/**
 * check-cas-number - Check the validity of a CAS number (RN)
 * @version v1.0.1
 * @link https://github.com/cheminfo/check-cas-number#readme
 * @license MIT
 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    typeof define === 'function' && define.amd ? define(['exports'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.ValidateCasNumber = {}));
})(this, (function (exports) { 'use strict';

    function check(cas, options = {}) {
      const {
        logger
      } = options;
      if (!cas?.match(/[0-9]{2,8}-[0-9]{2}-[0-9]/)) {
        logger?.error('Invalid CAS number, the format does not match: XXXXXXXX-XX-X.');
        return false;
      }
      let sum = 0;
      const digits = cas.replaceAll('-', '');
      for (let i = digits.length - 2; i >= 0; i--) {
        sum = sum + Number.parseInt(digits[i], 10) * (digits.length - i - 1);
      }
      // is it larger than 50000 ?
      if (Number.parseInt(cas.replaceAll('-', ''), 10) < 50000) {
        logger?.error('Invalid CAS number, the number is smaller than 50-00-0.');
        return false;
      }
      // does the checkdigit match ?
      const checkDigit = sum % 10;
      if (checkDigit !== Number.parseInt(cas.slice(-1), 10)) {
        logger?.error(`Invalid CAS number, the check digit does not match. Expected: ${checkDigit} but got: ${cas.slice(-1)}.`);
        return false;
      }
      return true;
    }

    exports.check = check;

}));
//# sourceMappingURL=check-cas-number.js.map
