!function(t,n){"object"==typeof exports&&"undefined"!=typeof module?n(exports):"function"==typeof define&&define.amd?define(["exports"],n):n((t="undefined"!=typeof globalThis?globalThis:t||self).NMRProcessing={})}(this,(function(exports){"use strict";const impurities={cdcl3:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"ds",shift:7.26}],h2o:[{proton:"H2O",coupling:0,multiplicity:"bs",shift:1.56}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.17}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.28}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.19},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.98},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.01},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.27},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.43}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.26}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.73}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.3}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.21},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.48}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.65},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.57},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.39}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.4},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.55}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.09},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.02},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.88}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.62}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.71}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.25},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.72},{proton:"OH",coupling:5,multiplicity:"s,t",shift:1.32}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.05},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.12},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.14},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.46},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.06}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.76}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.26}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.26}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.65}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.49},{proton:"OH",coupling:0,multiplicity:"s",shift:1.09}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.33}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:7},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.22},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.04}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.62},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.29},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.68}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.07}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.85},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.76}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.17},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.03},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.53}]},"(cd3)2co":{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:2.05}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.84}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.05}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.13},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.96},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.41}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.87}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.63}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.41}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.56},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.47},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.28}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.46}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.78}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.52}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.59}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.57},{proton:"OH",coupling:5,multiplicity:"s,t",shift:3.39}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.05},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.45},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.28}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.87},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.59}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"OH",coupling:0,multiplicity:"s",shift:3.12}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.43}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.1},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.9}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.35},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.76}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.13}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.79},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.63}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.5},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.5}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},dmso:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"quint",shift:2.5}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:3.33}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.91}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.07}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.19}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.08}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.87},{proton:"OHc",coupling:0,multiplicity:"s",shift:6.65},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.18},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.36}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.32}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.76}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.09},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.38}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.51},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.38},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.24}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.24},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.43}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.78}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.95},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.73}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.54}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.57}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.06},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.44},{proton:"OH",coupling:5,multiplicity:"s,t",shift:4.63}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.99},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.03},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.17}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.91}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.34}],"grease^f":[],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.25}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.53}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.16},{proton:"OH",coupling:0,multiplicity:"s",shift:4.01}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.42}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.04},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.78}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.39},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.79}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.76},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.6}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.3},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.18},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.93},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.43}]},c6d6:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:7.16}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:.4}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.15}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:1.55}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.07},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.04}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:7.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.79},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.24},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.38}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:6.15}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:2.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:4.27}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.26}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.46},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.34},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.11}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.12},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.33}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.6},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.57},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.05}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.63},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH3",coupling:0,multiplicity:"s",shift:1.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.68}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.35}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.34}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.65},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.89},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.92}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.58},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:1.81},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.85}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.41}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.92},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.36}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.24}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.4}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.07}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.23}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:.95},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.67}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:6.66},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:6.98}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.29}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.4},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.57}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.11},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.02},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.13}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.4}]},cd3cn:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:1.94}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.13}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.16},{proton:"OHc",coupling:0,multiplicity:"s",shift:2.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.14},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.97},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.2},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.39}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.58}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.44}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.81}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.44}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.42}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.53},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.45},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.29}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.45}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.77}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.5}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.54},{proton:"OH",coupling:5,multiplicity:"s,t",shift:2.47}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.06},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.06},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.51}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.27}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.57}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"OH",coupling:0,multiplicity:"s",shift:2.16}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.31}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.87},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.09},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.87}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.57},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.33},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.73}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.08}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.8},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.64}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.33},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.2},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.2}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},cd3od:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:3.31}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:4.87}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.99}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.15}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.03}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.33}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.4}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.15},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.2}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.92},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.21},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.4}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.9}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.45}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.78}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.49}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.18},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.49}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.58},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.35}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.35},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.52}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.92}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.97},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.99},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.65}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.66}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.19},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.6}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.01},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.09},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.12},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.5},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.01}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.59}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.88},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.9},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.64}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.34}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.5},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.92}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.44},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.85}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.1}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.87},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.71}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.16},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.16}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.05},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.58}]},d2o:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:4.79}],h2o:[],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.22}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.06}],benzene:[],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.24}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.21},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[],chloroform:[],cyclohexane:[],"1,2-dichloroethane":[],dichloromethane:[],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.56}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.67},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.37}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.37},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.08},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.06},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.9}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:3.01},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.85}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.71}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.75}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.65}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.14},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.19},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.18},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.65}],"grease^f":[],"n-hexane":[],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.61}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.4}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.9}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.17},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.02}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.52},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.45},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.87}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.88},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.74}],toluene:[],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.99},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.57}]}},toCheck=["solvent","H2O","TMS"];function peaksFilterImpurities(t,n={}){let{solvent:e="",error:o=.025,remove:r=!1}=n;e=e.toLowerCase(),"(cd3)2so"===e&&(e="dmso"),"meod"===e&&(e="cd3od");let i=impurities[e];if(i)for(let n of toCheck){let e=n.toLowerCase();checkImpurity(t,i[e],{error:o,remove:r,name:e})}return t}function checkImpurity(t,n,e){let o,r,i,{name:a,error:s,remove:u}=e,f=n.length;for(;f--;)for(o=t.length;o--;)t[o].asymmetric||(r=s+t[o].width,i=Math.abs(n[f].shift-t[o].x),i<r&&(u?t.splice(o,1):t[o].kind=a))}const GAUSSIAN_EXP_FACTOR=-4*Math.LN2,ROOT_PI_OVER_LN2=Math.sqrt(Math.PI/Math.LN2),ROOT_THREE=Math.sqrt(3),ROOT_2LN2=Math.sqrt(2*Math.LN2),ROOT_2LN2_MINUS_ONE=Math.sqrt(2*Math.LN2)-1;function erfinv(t){if(0===t)return 0;let n=Math.log(1-t*t),e=n/2+2/(.147*Math.PI),o=Math.sqrt(e**2-n/.147);return Math.sqrt(o-e)*(t>0?1:-1)}class Gaussian{constructor(t={}){this.fwhm=t.sd?Gaussian.widthToFWHM(2*t.sd):t.fwhm?t.fwhm:500,this.height=void 0===t.height?Math.sqrt(-GAUSSIAN_EXP_FACTOR/Math.PI)/this.fwhm:t.height}getData(t={}){let{length:n,factor:e=this.getFactor()}=t;n||(n=Math.min(Math.ceil(this.fwhm*e),Math.pow(2,25)-1),n%2==0&&n++);const o=(n-1)/2,r=new Float64Array(n);for(let t=0;t<=o;t++)r[t]=this.fct(t-o)*this.height,r[n-1-t]=r[t];return r}fct(t){return Gaussian.fct(t,this.fwhm)}getFactor(t=.9999){return Gaussian.getFactor(t)}getArea(){return Gaussian.getArea(this.fwhm,{height:this.height})}widthToFWHM(t){return Gaussian.widthToFWHM(t)}fwhmToWidth(t=this.fwhm){return Gaussian.fwhmToWidth(t)}setFWHM(t){this.fwhm=t}setHeight(t){this.height=t}}Gaussian.fct=function(t,n=500){return Math.exp(GAUSSIAN_EXP_FACTOR*Math.pow(t/n,2))},Gaussian.widthToFWHM=function(t){return t*ROOT_2LN2},Gaussian.fwhmToWidth=function(t){return t/ROOT_2LN2},Gaussian.getArea=function(t,n={}){let{height:e=1}=n;return e*ROOT_PI_OVER_LN2*t/2},Gaussian.getFactor=function(t=.9999){return Math.sqrt(2)*erfinv(t)};class Lorentzian{constructor(t={}){this.fwhm=void 0===t.fwhm?500:t.fwhm,this.height=void 0===t.height?2/Math.PI/this.fwhm:t.height}getData(t={}){let{length:n,factor:e=this.getFactor()}=t;n||(n=Math.min(Math.ceil(this.fwhm*e),Math.pow(2,25)-1),n%2==0&&n++);const o=(n-1)/2,r=new Float64Array(n);for(let t=0;t<=o;t++)r[t]=this.fct(t-o)*this.height,r[n-1-t]=r[t];return r}fct(t){return Lorentzian.fct(t,this.fwhm)}getFactor(t=.9999){return Lorentzian.getFactor(t)}getArea(){return Lorentzian.getArea(this.fwhm,{height:this.height})}fwhmToWidth(t=this.fwhm){return Lorentzian.fwhmToWidth(t)}widthToFWHM(t){return Lorentzian.widthToFWHM(t)}setFWHM(t){this.fwhm=t}setHeight(t){this.height=t}}Lorentzian.fct=function(t,n){const e=n*n;return e/(4*Math.pow(t,2)+e)},Lorentzian.fwhmToWidth=function(t){return t/ROOT_THREE},Lorentzian.widthToFWHM=function(t){return t*ROOT_THREE},Lorentzian.getArea=function(t,n={}){let{height:e=1}=n;return e*Math.PI*t/2},Lorentzian.getFactor=function(t=.9999){return 2*Math.tan(Math.PI*(t-.5))};class PseudoVoigt{constructor(t={}){this.mu=void 0===t.mu?.5:t.mu,this.fwhm=void 0===t.fwhm?500:t.fwhm,this.height=void 0===t.height?1/(this.mu/Math.sqrt(-GAUSSIAN_EXP_FACTOR/Math.PI)*this.fwhm+(1-this.mu)*this.fwhm*Math.PI/2):t.height}getData(t={}){let{length:n,factor:e=this.getFactor()}=t;n||(n=Math.ceil(this.fwhm*e),n%2==0&&n++);const o=(n-1)/2;let r=new Float64Array(n);for(let t=0;t<=o;t++)r[t]=this.fct(t-o)*this.height,r[n-1-t]=r[t];return r}fct(t){return PseudoVoigt.fct(t,this.fwhm,this.mu)}getFactor(t=.9999,n=this.mu){return PseudoVoigt.getFactor(t,n)}getArea(){return PseudoVoigt.getArea(this.fwhm,{height:this.height,mu:this.mu})}widthToFWHM(t,n){return PseudoVoigt.widthToFWHM(t,n)}fwhmToWidth(t=this.fwhm,n=this.mu){return PseudoVoigt.fwhmToWidth(t,n)}setFWHM(t){this.fwhm=t}setHeight(t){this.height=t}setMu(t){this.mu=t}}PseudoVoigt.fct=function(t,n,e=.5){return(1-e)*Lorentzian.fct(t,n)+e*Gaussian.fct(t,n)},PseudoVoigt.widthToFWHM=function(t,n=.5){return t*(n*ROOT_2LN2_MINUS_ONE+1)},PseudoVoigt.fwhmToWidth=function(t,n=.5){return t/(n*ROOT_2LN2_MINUS_ONE+1)},PseudoVoigt.getArea=function(t,n={}){let{height:e=1,mu:o=.5}=n;return t*e*(o*ROOT_PI_OVER_LN2+(1-o)*Math.PI)/2},PseudoVoigt.getFactor=function(t=.9999,n=.5){return n<1?Lorentzian.getFactor(t):Gaussian.getFactor(t)};let axis=["x","y"];class Gaussian2D{constructor(t={}){let{fwhm:n=500}=t;for(let e of axis){let o;o=t[e]?t[e].sd?Gaussian2D.widthToFWHM(2*t[e].sd):t[e].fwhm||n:n,this[e]={fwhm:o}}this.height=void 0===t.height?-GAUSSIAN_EXP_FACTOR/Math.PI/this.x.fwhm/this.y.fwhm:t.height}getData(t={}){let{x:n={},y:e={},factor:o=this.getFactor(),length:r}=t,i=n.length||r;if(!i){let{factor:t=o}=n;i=Math.min(Math.ceil(this.x.fwhm*t),Math.pow(2,25)-1),i%2==0&&i++}let a=e.length||r;if(!a){let{factor:t=o}=e;a=Math.min(Math.ceil(this.y.fwhm*t),Math.pow(2,25)-1),a%2==0&&a++}const s=(i-1)/2,u=(a-1)/2,f=new Array(i);for(let t=0;t<i;t++)f[t]=new Array(a);for(let t=0;t<i;t++)for(let n=0;n<a;n++)f[t][n]=this.fct(t-s,n-u)*this.height;return f}fct(t,n){return Gaussian2D.fct(t,n,this.x.fwhm,this.y.fwhm)}getFactor(t=.9999){return Gaussian2D.getFactor(t)}getVolume(){return Gaussian2D.getVolume(this.x.fwhm,this.y.fwhm,{height:this.height})}widthToFWHM(t){return Gaussian2D.widthToFWHM(t)}fwhmToWidth(t=this.x.fwhm){return Gaussian2D.fwhmToWidth(t)}setFWHM(t,n){n||(n=axis),Array.isArray(n)||(n=[n]);for(let e of n){let n=e.toLowerCase();if("y"!==n&&"x"!==n)throw new Error("axis label should be x or y");this[n].fwhm=t}}setHeight(t){this.height=t}}function getShapeGenerator(t){let{kind:n="Gaussian",options:e}=t;switch(n.toLowerCase().replace(/[^a-z^0-9]/g,"")){case"gaussian":return new Gaussian(e);case"lorentzian":return new Lorentzian(e);case"pseudovoigt":return new PseudoVoigt(e);case"gaussian2d":return new Gaussian2D(e);default:throw new Error(`Unknown kind: ${n}`)}}function SavitzkyGolay(t,n,e={}){let{windowSize:o=9,derivative:r=0,polynomial:i=3}=e;if(o%2==0||o<5||!Number.isInteger(o))throw new RangeError("Invalid window size (should be odd and at least 5 integer number)");if(o>t.length)throw new RangeError(`Window size is higher than the data length ${o}>${t.length}`);if(r<0||!Number.isInteger(r))throw new RangeError("Derivative should be a positive integer");if(i<1||!Number.isInteger(i))throw new RangeError("Polynomial should be a positive integer");i>=6&&console.warn("You should not use polynomial grade higher than 5 if you are not sure that your data arises from such a model. Possible polynomial oscillation problems");let a=Math.floor(o/2),s=t.length,u=new Array(s),f=fullWeights(o,i,r),l=0,c=!0;Array.isArray(n)?c=!1:l=Math.pow(n,r);for(let e=0;e<a;e++){let i=f[a-e-1],h=f[a+e+1],w=0,g=0;for(let n=0;n<o;n++)w+=i[n]*t[n],g+=h[n]*t[s-o+n];c?(u[a-e-1]=w/l,u[s-a+e]=g/l):(l=getHs(n,a-e-1,a,r),u[a-e-1]=w/l,l=getHs(n,s-a+e,a,r),u[s-a+e]=g/l)}let h=f[a];for(let e=o;e<=s;e++){let i=0;for(let n=0;n<o;n++)i+=h[n]*t[n+e-o];c||(l=getHs(n,e-a-1,a,r)),u[e-a-1]=i/l}return u}function getHs(t,n,e,o){let r=0,i=0;for(let o=n-e;o<n+e;o++)o>=0&&o<t.length-1&&(r+=t[o+1]-t[o],i++);return Math.pow(r/i,o)}function GramPoly(t,n,e,o){let r=0;return r=e>0?(4*e-2)/(e*(2*n-e+1))*(t*GramPoly(t,n,e-1,o)+o*GramPoly(t,n,e-1,o-1))-(e-1)*(2*n+e)/(e*(2*n-e+1))*GramPoly(t,n,e-2,o):0===e&&0===o?1:0,r}function GenFact(t,n){let e=1;if(t>=n)for(let o=t-n+1;o<=t;o++)e*=o;return e}function Weight(t,n,e,o,r){let i=0;for(let a=0;a<=o;a++)i+=(2*a+1)*(GenFact(2*e,a)/GenFact(2*e+a+1,a+1))*GramPoly(t,e,a,0)*GramPoly(n,e,a,r);return i}function fullWeights(t,n,e){let o=new Array(t),r=Math.floor(t/2);for(let i=-r;i<=r;i++){o[i+r]=new Array(t);for(let t=-r;t<=r;t++)o[i+r][t+r]=Weight(t,i,r,n,e)}return o}function gsd(t,n={}){let{noiseLevel:e,sgOptions:o={windowSize:9,polynomial:3},shape:r={},smoothY:i=!0,heightFactor:a=0,broadRatio:s=0,maxCriteria:u=!0,minMaxRatio:f=25e-5,derivativeThreshold:l=-1,realTopDetection:c=!1}=n,{y:h,x:w}=t;const g=h.slice();let m=isEqualSpaced(w);if(!1===u)for(let t=0;t<g.length;t++)g[t]*=-1;void 0===e&&(e=m?getNoiseLevel(g):0);for(let t=0;t<g.length;t++)g[t]-=e;for(let t=0;t<g.length;t++)g[t]<0&&(g[t]=0);let d,p,G=g;const{windowSize:b,polynomial:y}=o;m?(i&&(G=SavitzkyGolay(g,w[1]-w[0],{windowSize:b,polynomial:y,derivative:0})),d=SavitzkyGolay(g,w[1]-w[0],{windowSize:b,polynomial:y,derivative:1}),p=SavitzkyGolay(g,w[1]-w[0],{windowSize:b,polynomial:y,derivative:2})):(i&&(G=SavitzkyGolay(g,w,{windowSize:b,polynomial:y,derivative:0})),d=SavitzkyGolay(g,w,{windowSize:b,polynomial:y,derivative:1}),p=SavitzkyGolay(g,w,{windowSize:b,polynomial:y,derivative:2}));const j=w,N=w[1]-w[0];let H=0,v=0;for(let t=0;t<G.length;t++)Math.abs(p[t])>H&&(H=Math.abs(p[t])),Math.abs(G[t])>v&&(v=Math.abs(G[t]));let M=null,A=null,S=[],C=[],x=[],k=[];for(let t=1;t<G.length-1;++t)Math.abs(d[t])>l&&((d[t]<d[t-1]&&d[t]<=d[t+1]||d[t]<=d[t-1]&&d[t]<d[t+1])&&(A={x:j[t],index:t},N>0&&null!==M&&(C.push(M),x.push(A))),(d[t]>=d[t-1]&&d[t]>d[t+1]||d[t]>d[t-1]&&d[t]>=d[t+1])&&(M={x:j[t],index:t},N<0&&null!==A&&(C.push(M),x.push(A)))),p[t]<p[t-1]&&p[t]<p[t+1]&&(S.push(t),k.push(Math.abs(p[t])<=s*H));let R,I,D,F,T,B=r.kind?getShapeGenerator(r.kind,r.options).widthToFWHM:t=>t,$=[],P=-1;for(let t=0;t<S.length;++t){I=j[S[t]],R=-1;let n=P+1;for(F=Number.MAX_VALUE,D=0,T=!0;-1===R&&n<C.length&&T;)D=Math.abs(I-(C[n].x+x[n].x)/2),D<F?F=D:T=!1,D<Math.abs(C[n].x-x[n].x)/2&&(R=n,P=n),++n;if(-1!==R&&Math.abs(G[S[t]])>f*v){let n=Math.abs(x[R].x-C[R].x);if($.push({index:S[t],x:I,y:u?G[S[t]]+e:-G[S[t]]-e,width:B(n),soft:k[t]}),$[$.length-1].left=C[R],$[$.length-1].right=x[R],a){let t=G[C[R].index],n=G[x[R].index];$[$.length-1].height=a*($[$.length-1].y-(t+n)/2)}}}c&&determineRealTop$1($,j,G);for(let t=0;t<$.length;t++)$[t].base=e;return $.sort((function(t,n){return t.x-n.x})),$}Gaussian2D.fct=function(t,n,e=500,o=500){return Math.exp(GAUSSIAN_EXP_FACTOR*(Math.pow(t/e,2)+Math.pow(n/o,2)))},Gaussian2D.widthToFWHM=function(t){return t*ROOT_2LN2},Gaussian2D.fwhmToWidth=function(t){return t/ROOT_2LN2},Gaussian2D.getVolume=function(t,n,e={}){let{height:o=1}=e;return o*Math.PI*t*n/Math.LN2/4},Gaussian2D.getFactor=function(t=.9999){return Math.sqrt(2)*erfinv(t)};const isEqualSpaced=t=>{let n,e=0,o=Number.MAX_SAFE_INTEGER;for(let r=0;r<t.length-1;++r)n=Math.abs(t[r+1]-t[r]),n<o&&(o=n),n>e&&(e=n);return(e-o)/e<.05},getNoiseLevel=t=>{let n=0,e=0,o=t.length;for(let e=0;e<o;++e)n+=t[e];n/=o;let r=new Array(o);for(let e=0;e<o;++e)r[e]=Math.abs(t[e]-n);return r.sort(((t,n)=>t-n)),e=o%2==1?r[(o-1)/2]/.6745:.5*(r[o/2]+r[o/2-1])/.6745,e},determineRealTop$1=(t,n,e)=>{let o,r,i,a,s;for(let u=0;u<t.length;u++)s=t[u].index,e[s-1]>=e[s-2]&&e[s-1]>=e[s]?s--:e[s+1]>=e[s]&&e[s+1]>=e[s+2]?s++:e[s-2]>=e[s-3]&&e[s-2]>=e[s-1]?s-=2:e[s+2]>=e[s+1]&&e[s+2]>=e[s+3]&&(s+=2),e[s-1]>0&&e[s+1]>0&&e[s]>=e[s-1]&&e[s]>=e[s+1]&&(e[s]!==e[s-1]||e[s]!==e[s+1])&&(o=20*Math.log10(e[s-1]),r=20*Math.log10(e[s]),i=20*Math.log10(e[s+1]),a=.5*(o-i)/(o-2*r+i),t[u].x=n[s]+(n[s]-n[s-1])*a,t[u].y=e[s]-.25*(e[s-1]-e[s+1])*a)};var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function getDefaultExportFromCjs(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var assignDeep$1={exports:{}};
/*!
   * assign-symbols <https://github.com/jonschlinkert/assign-symbols>
   *
   * Copyright (c) 2015-present, Jon Schlinkert.
   * Licensed under the MIT License.
   */const toString$2=Object.prototype.toString,isEnumerable=Object.prototype.propertyIsEnumerable,getSymbols=Object.getOwnPropertySymbols;var assignSymbols$1=(t,...n)=>{if(!isObject$1(t))throw new TypeError("expected the first argument to be an object");if(0===n.length||"function"!=typeof Symbol||"function"!=typeof getSymbols)return t;for(let e of n){let n=getSymbols(e);for(let o of n)isEnumerable.call(e,o)&&(t[o]=e[o])}return t};function isObject$1(t){return"function"==typeof t||"[object Object]"===toString$2.call(t)||Array.isArray(t)}
/*!
   * assign-deep <https://github.com/jonschlinkert/assign-deep>
   *
   * Copyright (c) 2017-present, Jon Schlinkert.
   * Released under the MIT License.
   */const toString$1=Object.prototype.toString,assignSymbols=assignSymbols$1,isValidKey=t=>"__proto__"!==t&&"constructor"!==t&&"prototype"!==t,assign=assignDeep$1.exports=(t,...n)=>{let e=0;for(isPrimitive(t)&&(t=n[e++]),t||(t={});e<n.length;e++)if(isObject(n[e])){for(const o of Object.keys(n[e]))isValidKey(o)&&(isObject(t[o])&&isObject(n[e][o])?assign(t[o],n[e][o]):t[o]=n[e][o]);assignSymbols(t,n[e])}return t};function isObject(t){return"function"==typeof t||"[object Object]"===toString$1.call(t)}function isPrimitive(t){return"object"==typeof t?null===t:"function"!=typeof t}var assignDeep=assignDeep$1.exports;const toString=Object.prototype.toString;function isAnyArray(t){return toString.call(t).endsWith("Array]")}function max(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var e=n.fromIndex,o=void 0===e?0:e,r=n.toIndex,i=void 0===r?t.length:r;if(o<0||o>=t.length||!Number.isInteger(o))throw new Error("fromIndex must be a positive integer smaller than length");if(i<=o||i>t.length||!Number.isInteger(i))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[o],s=o+1;s<i;s++)t[s]>a&&(a=t[s]);return a}function sumOfGaussianLorentzians(t){return function(n){let e=t.length/4,o=0;for(let r=0;r<e;r++)o+=t[r+e]*PseudoVoigt.fct(n-t[r],t[r+2*e],t[r+3*e]);return o}}function sumOfGaussians(t){return function(n){let e=t.length/3,o=0;for(let r=0;r<e;r++)o+=t[r+e]*Gaussian.fct(n-t[r],t[r+2*e]);return o}}function sumOfLorentzians(t){return function(n){let e=t.length/3,o=0;for(let r=0;r<e;r++)o+=t[r+e]*Lorentzian.fct(n-t[r],t[r+2*e]);return o}}function checkInput(t,n,e){let o,r,{shape:i={kind:"gaussian"},optimization:a={kind:"lm"}}=e;if("string"!=typeof i.kind)throw new Error("kind should be a string");switch(i.kind.toLowerCase().replace(/[^a-z]/g,"")){case"gaussian":o=sumOfGaussians,r={x:{init:t=>t.x,max:t=>t.x+2*t.width,min:t=>t.x-2*t.width,gradientDifference:t=>.002*t.width},y:{init:t=>t.y,max:()=>1.5,min:()=>0,gradientDifference:()=>.001},width:{init:t=>t.width,max:t=>4*t.width,min:t=>.25*t.width,gradientDifference:t=>.002*t.width}};break;case"lorentzian":o=sumOfLorentzians,r={x:{init:t=>t.x,max:t=>t.x+2*t.width,min:t=>t.x-2*t.width,gradientDifference:t=>.002*t.width},y:{init:t=>t.y,max:()=>1.5,min:()=>0,gradientDifference:()=>.001},width:{init:t=>t.width,max:t=>4*t.width,min:t=>.25*t.width,gradientDifference:t=>.002*t.width}};break;case"pseudovoigt":o=sumOfGaussianLorentzians,r={x:{init:t=>t.x,max:t=>t.x+2*t.width,min:t=>t.x-2*t.width,gradientDifference:t=>.002*t.width},y:{init:t=>t.y,max:()=>1.5,min:()=>0,gradientDifference:()=>.001},width:{init:t=>t.width,max:t=>4*t.width,min:t=>.25*t.width,gradientDifference:t=>.002*t.width},mu:{init:t=>void 0!==t.mu?t.mu:.5,min:()=>0,max:()=>1,gradientDifference:()=>.01}};break;default:throw new Error("kind of shape is not supported")}let s=t.x,u=max(t.y),f=new Array(s.length);for(let n=0;n<s.length;n++)f[n]=t.y[n]/u;for(let t=0;t<n.length;t++)n[t].y/=u;let l=assignDeep({},a.parameters,r);for(let t in l)for(let e in l[t]){if(Array.isArray(l[t][e])||(l[t][e]=[l[t][e]]),1!==l[t][e].length&&l[t][e].length!==n.length)throw new Error(`The length of ${t}-${e} is not correct`);for(let n=0;n<l[t][e].length;n++)if("number"==typeof l[t][e][n]){let o=l[t][e][n];l[t][e][n]=()=>o}}return a.parameters=l,{y:f,x:s,maxY:u,peaks:n,paramsFunc:o,optimization:a}}function checkOptions$1(t,n,e){let{timeout:o,minValues:r,maxValues:i,initialValues:a,weights:s=1,damping:u=.01,dampingStepUp:f=11,dampingStepDown:l=9,maxIterations:c=100,errorTolerance:h=1e-7,centralDifference:w=!1,gradientDifference:g=.1,improvementThreshold:m=.001}=e;if(u<=0)throw new Error("The damping option must be a positive number");if(!t.x||!t.y)throw new Error("The data parameter must have x and y elements");if(!isAnyArray(t.x)||t.x.length<2||!isAnyArray(t.y)||t.y.length<2)throw new Error("The data parameter elements must be an array with more than 2 points");if(t.x.length!==t.y.length)throw new Error("The data parameter elements must have the same size");let d,p,G=a||new Array(n.length).fill(1),b=t.y.length,y=G.length;if(i=i||new Array(y).fill(Number.MAX_SAFE_INTEGER),r=r||new Array(y).fill(Number.MIN_SAFE_INTEGER),i.length!==r.length)throw new Error("minValues and maxValues must be the same size");if(!isAnyArray(G))throw new Error("initialValues must be an array");if("number"==typeof g)g=new Array(G.length).fill(g);else{if(!isAnyArray(g))throw new Error("gradientDifference should be a number or array with length equal to the number of parameters");g.length!==y&&(g=new Array(y).fill(g[0]))}if("number"==typeof s){let t=1/s**2;d=()=>t}else{if(!isAnyArray(s))throw new Error("weights should be a number or array with length equal to the number of data points");if(s.length<t.x.length){let t=1/s[0]**2;d=()=>t}else d=t=>1/s[t]**2}if(void 0!==o){if("number"!=typeof o)throw new Error("timeout should be a number");let t=Date.now()+1e3*o;p=()=>Date.now()>t}else p=()=>!1;let j=new Array(t.x.length);for(let t=0;t<b;t++)j[t]=d(t);return{checkTimeout:p,minValues:r,maxValues:i,parameters:G,weightSquare:j,damping:u,dampingStepUp:f,dampingStepDown:l,maxIterations:c,errorTolerance:h,centralDifference:w,gradientDifference:g,improvementThreshold:m}}function errorCalculation(t,n,e,o){let r=0;const i=e(n);for(let n=0;n<t.x.length;n++)r+=Math.pow(t.y[n]-i(t.x[n]),2)/o[n];return r}function min(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var e=n.fromIndex,o=void 0===e?0:e,r=n.toIndex,i=void 0===r?t.length:r;if(o<0||o>=t.length||!Number.isInteger(o))throw new Error("fromIndex must be a positive integer smaller than length");if(i<=o||i>t.length||!Number.isInteger(i))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[o],s=o+1;s<i;s++)t[s]<a&&(a=t[s]);return a}function rescale(t){var n,e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(void 0!==e.output){if(!isAnyArray(e.output))throw new TypeError("output option must be an array if specified");n=e.output}else n=new Array(t.length);var o=min(t),r=max(t);if(o===r)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var i=e.min,a=void 0===i?e.autoMinMax?o:0:i,s=e.max,u=void 0===s?e.autoMinMax?r:1:s;if(a>=u)throw new RangeError("min option must be smaller than max option");for(var f=(u-a)/(r-o),l=0;l<t.length;l++)n[l]=(t[l]-o)*f+a;return n}const indent=" ".repeat(2),indentData=" ".repeat(4);function inspectMatrix(){return inspectMatrixWithOptions(this)}function inspectMatrixWithOptions(t,n={}){const{maxRows:e=15,maxColumns:o=10,maxNumSize:r=8}=n;return`${t.constructor.name} {\n${indent}[\n${indentData}${inspectData(t,e,o,r)}\n${indent}]\n${indent}rows: ${t.rows}\n${indent}columns: ${t.columns}\n}`}function inspectData(t,n,e,o){const{rows:r,columns:i}=t,a=Math.min(r,n),s=Math.min(i,e),u=[];for(let n=0;n<a;n++){let e=[];for(let r=0;r<s;r++)e.push(formatNumber(t.get(n,r),o));u.push(`${e.join(" ")}`)}return s!==i&&(u[u.length-1]+=` ... ${i-e} more columns`),a!==r&&u.push(`... ${r-n} more rows`),u.join(`\n${indentData}`)}function formatNumber(t,n){const e=String(t);if(e.length<=n)return e.padEnd(n," ");const o=t.toPrecision(n-2);if(o.length<=n)return o;const r=t.toExponential(n-2),i=r.indexOf("e"),a=r.slice(i);return r.slice(0,n-a.length)+a}function installMathOperations(t,n){t.prototype.add=function(t){return"number"==typeof t?this.addS(t):this.addM(t)},t.prototype.addS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)+t);return this},t.prototype.addM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)+t.get(n,e));return this},t.add=function(t,e){return new n(t).add(e)},t.prototype.sub=function(t){return"number"==typeof t?this.subS(t):this.subM(t)},t.prototype.subS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)-t);return this},t.prototype.subM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)-t.get(n,e));return this},t.sub=function(t,e){return new n(t).sub(e)},t.prototype.subtract=t.prototype.sub,t.prototype.subtractS=t.prototype.subS,t.prototype.subtractM=t.prototype.subM,t.subtract=t.sub,t.prototype.mul=function(t){return"number"==typeof t?this.mulS(t):this.mulM(t)},t.prototype.mulS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)*t);return this},t.prototype.mulM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)*t.get(n,e));return this},t.mul=function(t,e){return new n(t).mul(e)},t.prototype.multiply=t.prototype.mul,t.prototype.multiplyS=t.prototype.mulS,t.prototype.multiplyM=t.prototype.mulM,t.multiply=t.mul,t.prototype.div=function(t){return"number"==typeof t?this.divS(t):this.divM(t)},t.prototype.divS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)/t);return this},t.prototype.divM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)/t.get(n,e));return this},t.div=function(t,e){return new n(t).div(e)},t.prototype.divide=t.prototype.div,t.prototype.divideS=t.prototype.divS,t.prototype.divideM=t.prototype.divM,t.divide=t.div,t.prototype.mod=function(t){return"number"==typeof t?this.modS(t):this.modM(t)},t.prototype.modS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)%t);return this},t.prototype.modM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)%t.get(n,e));return this},t.mod=function(t,e){return new n(t).mod(e)},t.prototype.modulus=t.prototype.mod,t.prototype.modulusS=t.prototype.modS,t.prototype.modulusM=t.prototype.modM,t.modulus=t.mod,t.prototype.and=function(t){return"number"==typeof t?this.andS(t):this.andM(t)},t.prototype.andS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)&t);return this},t.prototype.andM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)&t.get(n,e));return this},t.and=function(t,e){return new n(t).and(e)},t.prototype.or=function(t){return"number"==typeof t?this.orS(t):this.orM(t)},t.prototype.orS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)|t);return this},t.prototype.orM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)|t.get(n,e));return this},t.or=function(t,e){return new n(t).or(e)},t.prototype.xor=function(t){return"number"==typeof t?this.xorS(t):this.xorM(t)},t.prototype.xorS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)^t);return this},t.prototype.xorM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)^t.get(n,e));return this},t.xor=function(t,e){return new n(t).xor(e)},t.prototype.leftShift=function(t){return"number"==typeof t?this.leftShiftS(t):this.leftShiftM(t)},t.prototype.leftShiftS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)<<t);return this},t.prototype.leftShiftM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)<<t.get(n,e));return this},t.leftShift=function(t,e){return new n(t).leftShift(e)},t.prototype.signPropagatingRightShift=function(t){return"number"==typeof t?this.signPropagatingRightShiftS(t):this.signPropagatingRightShiftM(t)},t.prototype.signPropagatingRightShiftS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)>>t);return this},t.prototype.signPropagatingRightShiftM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)>>t.get(n,e));return this},t.signPropagatingRightShift=function(t,e){return new n(t).signPropagatingRightShift(e)},t.prototype.rightShift=function(t){return"number"==typeof t?this.rightShiftS(t):this.rightShiftM(t)},t.prototype.rightShiftS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)>>>t);return this},t.prototype.rightShiftM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)>>>t.get(n,e));return this},t.rightShift=function(t,e){return new n(t).rightShift(e)},t.prototype.zeroFillRightShift=t.prototype.rightShift,t.prototype.zeroFillRightShiftS=t.prototype.rightShiftS,t.prototype.zeroFillRightShiftM=t.prototype.rightShiftM,t.zeroFillRightShift=t.rightShift,t.prototype.not=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,~this.get(t,n));return this},t.not=function(t){return new n(t).not()},t.prototype.abs=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.abs(this.get(t,n)));return this},t.abs=function(t){return new n(t).abs()},t.prototype.acos=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.acos(this.get(t,n)));return this},t.acos=function(t){return new n(t).acos()},t.prototype.acosh=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.acosh(this.get(t,n)));return this},t.acosh=function(t){return new n(t).acosh()},t.prototype.asin=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.asin(this.get(t,n)));return this},t.asin=function(t){return new n(t).asin()},t.prototype.asinh=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.asinh(this.get(t,n)));return this},t.asinh=function(t){return new n(t).asinh()},t.prototype.atan=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.atan(this.get(t,n)));return this},t.atan=function(t){return new n(t).atan()},t.prototype.atanh=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.atanh(this.get(t,n)));return this},t.atanh=function(t){return new n(t).atanh()},t.prototype.cbrt=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.cbrt(this.get(t,n)));return this},t.cbrt=function(t){return new n(t).cbrt()},t.prototype.ceil=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.ceil(this.get(t,n)));return this},t.ceil=function(t){return new n(t).ceil()},t.prototype.clz32=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.clz32(this.get(t,n)));return this},t.clz32=function(t){return new n(t).clz32()},t.prototype.cos=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.cos(this.get(t,n)));return this},t.cos=function(t){return new n(t).cos()},t.prototype.cosh=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.cosh(this.get(t,n)));return this},t.cosh=function(t){return new n(t).cosh()},t.prototype.exp=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.exp(this.get(t,n)));return this},t.exp=function(t){return new n(t).exp()},t.prototype.expm1=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.expm1(this.get(t,n)));return this},t.expm1=function(t){return new n(t).expm1()},t.prototype.floor=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.floor(this.get(t,n)));return this},t.floor=function(t){return new n(t).floor()},t.prototype.fround=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.fround(this.get(t,n)));return this},t.fround=function(t){return new n(t).fround()},t.prototype.log=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.log(this.get(t,n)));return this},t.log=function(t){return new n(t).log()},t.prototype.log1p=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.log1p(this.get(t,n)));return this},t.log1p=function(t){return new n(t).log1p()},t.prototype.log10=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.log10(this.get(t,n)));return this},t.log10=function(t){return new n(t).log10()},t.prototype.log2=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.log2(this.get(t,n)));return this},t.log2=function(t){return new n(t).log2()},t.prototype.round=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.round(this.get(t,n)));return this},t.round=function(t){return new n(t).round()},t.prototype.sign=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.sign(this.get(t,n)));return this},t.sign=function(t){return new n(t).sign()},t.prototype.sin=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.sin(this.get(t,n)));return this},t.sin=function(t){return new n(t).sin()},t.prototype.sinh=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.sinh(this.get(t,n)));return this},t.sinh=function(t){return new n(t).sinh()},t.prototype.sqrt=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.sqrt(this.get(t,n)));return this},t.sqrt=function(t){return new n(t).sqrt()},t.prototype.tan=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.tan(this.get(t,n)));return this},t.tan=function(t){return new n(t).tan()},t.prototype.tanh=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.tanh(this.get(t,n)));return this},t.tanh=function(t){return new n(t).tanh()},t.prototype.trunc=function(){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)this.set(t,n,Math.trunc(this.get(t,n)));return this},t.trunc=function(t){return new n(t).trunc()},t.pow=function(t,e){return new n(t).pow(e)},t.prototype.pow=function(t){return"number"==typeof t?this.powS(t):this.powM(t)},t.prototype.powS=function(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,Math.pow(this.get(n,e),t));return this},t.prototype.powM=function(t){if(t=n.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,Math.pow(this.get(n,e),t.get(n,e)));return this}}function checkRowIndex(t,n,e){let o=e?t.rows:t.rows-1;if(n<0||n>o)throw new RangeError("Row index out of range")}function checkColumnIndex(t,n,e){let o=e?t.columns:t.columns-1;if(n<0||n>o)throw new RangeError("Column index out of range")}function checkRowVector(t,n){if(n.to1DArray&&(n=n.to1DArray()),n.length!==t.columns)throw new RangeError("vector size must be the same as the number of columns");return n}function checkColumnVector(t,n){if(n.to1DArray&&(n=n.to1DArray()),n.length!==t.rows)throw new RangeError("vector size must be the same as the number of rows");return n}function checkIndices(t,n,e){return{row:checkRowIndices(t,n),column:checkColumnIndices(t,e)}}function checkRowIndices(t,n){if("object"!=typeof n)throw new TypeError("unexpected type for row indices");if(n.some((n=>n<0||n>=t.rows)))throw new RangeError("row indices are out of range");return Array.isArray(n)||(n=Array.from(n)),n}function checkColumnIndices(t,n){if("object"!=typeof n)throw new TypeError("unexpected type for column indices");if(n.some((n=>n<0||n>=t.columns)))throw new RangeError("column indices are out of range");return Array.isArray(n)||(n=Array.from(n)),n}function checkRange(t,n,e,o,r){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(checkNumber("startRow",n),checkNumber("endRow",e),checkNumber("startColumn",o),checkNumber("endColumn",r),n>e||o>r||n<0||n>=t.rows||e<0||e>=t.rows||o<0||o>=t.columns||r<0||r>=t.columns)throw new RangeError("Submatrix indices are out of range")}function newArray$1(t,n=0){let e=[];for(let o=0;o<t;o++)e.push(n);return e}function checkNumber(t,n){if("number"!=typeof n)throw new TypeError(`${t} must be a number`)}function checkNonEmpty(t){if(t.isEmpty())throw new Error("Empty matrix has no elements to index")}function sumByRow(t){let n=newArray$1(t.rows);for(let e=0;e<t.rows;++e)for(let o=0;o<t.columns;++o)n[e]+=t.get(e,o);return n}function sumByColumn(t){let n=newArray$1(t.columns);for(let e=0;e<t.rows;++e)for(let o=0;o<t.columns;++o)n[o]+=t.get(e,o);return n}function sumAll(t){let n=0;for(let e=0;e<t.rows;e++)for(let o=0;o<t.columns;o++)n+=t.get(e,o);return n}function productByRow(t){let n=newArray$1(t.rows,1);for(let e=0;e<t.rows;++e)for(let o=0;o<t.columns;++o)n[e]*=t.get(e,o);return n}function productByColumn(t){let n=newArray$1(t.columns,1);for(let e=0;e<t.rows;++e)for(let o=0;o<t.columns;++o)n[o]*=t.get(e,o);return n}function productAll(t){let n=1;for(let e=0;e<t.rows;e++)for(let o=0;o<t.columns;o++)n*=t.get(e,o);return n}function varianceByRow(t,n,e){const o=t.rows,r=t.columns,i=[];for(let a=0;a<o;a++){let o=0,s=0,u=0;for(let n=0;n<r;n++)u=t.get(a,n)-e[a],o+=u,s+=u*u;n?i.push((s-o*o/r)/(r-1)):i.push((s-o*o/r)/r)}return i}function varianceByColumn(t,n,e){const o=t.rows,r=t.columns,i=[];for(let a=0;a<r;a++){let r=0,s=0,u=0;for(let n=0;n<o;n++)u=t.get(n,a)-e[a],r+=u,s+=u*u;n?i.push((s-r*r/o)/(o-1)):i.push((s-r*r/o)/o)}return i}function varianceAll(t,n,e){const o=t.rows,r=t.columns,i=o*r;let a=0,s=0,u=0;for(let n=0;n<o;n++)for(let o=0;o<r;o++)u=t.get(n,o)-e,a+=u,s+=u*u;return n?(s-a*a/i)/(i-1):(s-a*a/i)/i}function centerByRow(t,n){for(let e=0;e<t.rows;e++)for(let o=0;o<t.columns;o++)t.set(e,o,t.get(e,o)-n[e])}function centerByColumn(t,n){for(let e=0;e<t.rows;e++)for(let o=0;o<t.columns;o++)t.set(e,o,t.get(e,o)-n[o])}function centerAll(t,n){for(let e=0;e<t.rows;e++)for(let o=0;o<t.columns;o++)t.set(e,o,t.get(e,o)-n)}function getScaleByRow(t){const n=[];for(let e=0;e<t.rows;e++){let o=0;for(let n=0;n<t.columns;n++)o+=Math.pow(t.get(e,n),2)/(t.columns-1);n.push(Math.sqrt(o))}return n}function scaleByRow(t,n){for(let e=0;e<t.rows;e++)for(let o=0;o<t.columns;o++)t.set(e,o,t.get(e,o)/n[e])}function getScaleByColumn(t){const n=[];for(let e=0;e<t.columns;e++){let o=0;for(let n=0;n<t.rows;n++)o+=Math.pow(t.get(n,e),2)/(t.rows-1);n.push(Math.sqrt(o))}return n}function scaleByColumn(t,n){for(let e=0;e<t.rows;e++)for(let o=0;o<t.columns;o++)t.set(e,o,t.get(e,o)/n[o])}function getScaleAll(t){const n=t.size-1;let e=0;for(let o=0;o<t.columns;o++)for(let r=0;r<t.rows;r++)e+=Math.pow(t.get(r,o),2)/n;return Math.sqrt(e)}function scaleAll(t,n){for(let e=0;e<t.rows;e++)for(let o=0;o<t.columns;o++)t.set(e,o,t.get(e,o)/n)}class AbstractMatrix{static from1DArray(t,n,e){if(t*n!==e.length)throw new RangeError("data length does not match given dimensions");let o=new Matrix(t,n);for(let r=0;r<t;r++)for(let t=0;t<n;t++)o.set(r,t,e[r*n+t]);return o}static rowVector(t){let n=new Matrix(1,t.length);for(let e=0;e<t.length;e++)n.set(0,e,t[e]);return n}static columnVector(t){let n=new Matrix(t.length,1);for(let e=0;e<t.length;e++)n.set(e,0,t[e]);return n}static zeros(t,n){return new Matrix(t,n)}static ones(t,n){return new Matrix(t,n).fill(1)}static rand(t,n,e={}){if("object"!=typeof e)throw new TypeError("options must be an object");const{random:o=Math.random}=e;let r=new Matrix(t,n);for(let e=0;e<t;e++)for(let t=0;t<n;t++)r.set(e,t,o());return r}static randInt(t,n,e={}){if("object"!=typeof e)throw new TypeError("options must be an object");const{min:o=0,max:r=1e3,random:i=Math.random}=e;if(!Number.isInteger(o))throw new TypeError("min must be an integer");if(!Number.isInteger(r))throw new TypeError("max must be an integer");if(o>=r)throw new RangeError("min must be smaller than max");let a=r-o,s=new Matrix(t,n);for(let e=0;e<t;e++)for(let t=0;t<n;t++){let n=o+Math.round(i()*a);s.set(e,t,n)}return s}static eye(t,n,e){void 0===n&&(n=t),void 0===e&&(e=1);let o=Math.min(t,n),r=this.zeros(t,n);for(let t=0;t<o;t++)r.set(t,t,e);return r}static diag(t,n,e){let o=t.length;void 0===n&&(n=o),void 0===e&&(e=n);let r=Math.min(o,n,e),i=this.zeros(n,e);for(let n=0;n<r;n++)i.set(n,n,t[n]);return i}static min(t,n){t=this.checkMatrix(t),n=this.checkMatrix(n);let e=t.rows,o=t.columns,r=new Matrix(e,o);for(let i=0;i<e;i++)for(let e=0;e<o;e++)r.set(i,e,Math.min(t.get(i,e),n.get(i,e)));return r}static max(t,n){t=this.checkMatrix(t),n=this.checkMatrix(n);let e=t.rows,o=t.columns,r=new this(e,o);for(let i=0;i<e;i++)for(let e=0;e<o;e++)r.set(i,e,Math.max(t.get(i,e),n.get(i,e)));return r}static checkMatrix(t){return AbstractMatrix.isMatrix(t)?t:new Matrix(t)}static isMatrix(t){return null!=t&&"Matrix"===t.klass}get size(){return this.rows*this.columns}apply(t){if("function"!=typeof t)throw new TypeError("callback must be a function");for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)t.call(this,n,e);return this}to1DArray(){let t=[];for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)t.push(this.get(n,e));return t}to2DArray(){let t=[];for(let n=0;n<this.rows;n++){t.push([]);for(let e=0;e<this.columns;e++)t[n].push(this.get(n,e))}return t}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let t=0;t<this.rows;t++)for(let n=0;n<=t;n++)if(this.get(t,n)!==this.get(n,t))return!1;return!0}return!1}isEchelonForm(){let t=0,n=0,e=-1,o=!0,r=!1;for(;t<this.rows&&o;){for(n=0,r=!1;n<this.columns&&!1===r;)0===this.get(t,n)?n++:1===this.get(t,n)&&n>e?(r=!0,e=n):(o=!1,r=!0);t++}return o}isReducedEchelonForm(){let t=0,n=0,e=-1,o=!0,r=!1;for(;t<this.rows&&o;){for(n=0,r=!1;n<this.columns&&!1===r;)0===this.get(t,n)?n++:1===this.get(t,n)&&n>e?(r=!0,e=n):(o=!1,r=!0);for(let e=n+1;e<this.rows;e++)0!==this.get(t,e)&&(o=!1);t++}return o}echelonForm(){let t=this.clone(),n=0,e=0;for(;n<t.rows&&e<t.columns;){let o=n;for(let r=n;r<t.rows;r++)t.get(r,e)>t.get(o,e)&&(o=r);if(0===t.get(o,e))e++;else{t.swapRows(n,o);let r=t.get(n,e);for(let o=e;o<t.columns;o++)t.set(n,o,t.get(n,o)/r);for(let o=n+1;o<t.rows;o++){let r=t.get(o,e)/t.get(n,e);t.set(o,e,0);for(let i=e+1;i<t.columns;i++)t.set(o,i,t.get(o,i)-t.get(n,i)*r)}n++,e++}}return t}reducedEchelonForm(){let t=this.echelonForm(),n=t.columns,e=t.rows,o=e-1;for(;o>=0;)if(0===t.maxRow(o))o--;else{let r=0,i=!1;for(;r<e&&!1===i;)1===t.get(o,r)?i=!0:r++;for(let e=0;e<o;e++){let i=t.get(e,r);for(let a=r;a<n;a++){let n=t.get(e,a)-i*t.get(o,a);t.set(e,a,n)}}o--}return t}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{rows:n=1,columns:e=1}=t;if(!Number.isInteger(n)||n<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(e)||e<=0)throw new TypeError("columns must be a positive integer");let o=new Matrix(this.rows*n,this.columns*e);for(let t=0;t<n;t++)for(let n=0;n<e;n++)o.setSubMatrix(this,this.rows*t,this.columns*n);return o}fill(t){for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,t);return this}neg(){return this.mulS(-1)}getRow(t){checkRowIndex(this,t);let n=[];for(let e=0;e<this.columns;e++)n.push(this.get(t,e));return n}getRowVector(t){return Matrix.rowVector(this.getRow(t))}setRow(t,n){checkRowIndex(this,t),n=checkRowVector(this,n);for(let e=0;e<this.columns;e++)this.set(t,e,n[e]);return this}swapRows(t,n){checkRowIndex(this,t),checkRowIndex(this,n);for(let e=0;e<this.columns;e++){let o=this.get(t,e);this.set(t,e,this.get(n,e)),this.set(n,e,o)}return this}getColumn(t){checkColumnIndex(this,t);let n=[];for(let e=0;e<this.rows;e++)n.push(this.get(e,t));return n}getColumnVector(t){return Matrix.columnVector(this.getColumn(t))}setColumn(t,n){checkColumnIndex(this,t),n=checkColumnVector(this,n);for(let e=0;e<this.rows;e++)this.set(e,t,n[e]);return this}swapColumns(t,n){checkColumnIndex(this,t),checkColumnIndex(this,n);for(let e=0;e<this.rows;e++){let o=this.get(e,t);this.set(e,t,this.get(e,n)),this.set(e,n,o)}return this}addRowVector(t){t=checkRowVector(this,t);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)+t[e]);return this}subRowVector(t){t=checkRowVector(this,t);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)-t[e]);return this}mulRowVector(t){t=checkRowVector(this,t);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)*t[e]);return this}divRowVector(t){t=checkRowVector(this,t);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)/t[e]);return this}addColumnVector(t){t=checkColumnVector(this,t);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)+t[n]);return this}subColumnVector(t){t=checkColumnVector(this,t);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)-t[n]);return this}mulColumnVector(t){t=checkColumnVector(this,t);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)*t[n]);return this}divColumnVector(t){t=checkColumnVector(this,t);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)/t[n]);return this}mulRow(t,n){checkRowIndex(this,t);for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n);return this}mulColumn(t,n){checkColumnIndex(this,t);for(let e=0;e<this.rows;e++)this.set(e,t,this.get(e,t)*n);return this}max(){if(this.isEmpty())return NaN;let t=this.get(0,0);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.get(n,e)>t&&(t=this.get(n,e));return t}maxIndex(){checkNonEmpty(this);let t=this.get(0,0),n=[0,0];for(let e=0;e<this.rows;e++)for(let o=0;o<this.columns;o++)this.get(e,o)>t&&(t=this.get(e,o),n[0]=e,n[1]=o);return n}min(){if(this.isEmpty())return NaN;let t=this.get(0,0);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)this.get(n,e)<t&&(t=this.get(n,e));return t}minIndex(){checkNonEmpty(this);let t=this.get(0,0),n=[0,0];for(let e=0;e<this.rows;e++)for(let o=0;o<this.columns;o++)this.get(e,o)<t&&(t=this.get(e,o),n[0]=e,n[1]=o);return n}maxRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let n=this.get(t,0);for(let e=1;e<this.columns;e++)this.get(t,e)>n&&(n=this.get(t,e));return n}maxRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let n=this.get(t,0),e=[t,0];for(let o=1;o<this.columns;o++)this.get(t,o)>n&&(n=this.get(t,o),e[1]=o);return e}minRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let n=this.get(t,0);for(let e=1;e<this.columns;e++)this.get(t,e)<n&&(n=this.get(t,e));return n}minRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let n=this.get(t,0),e=[t,0];for(let o=1;o<this.columns;o++)this.get(t,o)<n&&(n=this.get(t,o),e[1]=o);return e}maxColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let n=this.get(0,t);for(let e=1;e<this.rows;e++)this.get(e,t)>n&&(n=this.get(e,t));return n}maxColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let n=this.get(0,t),e=[0,t];for(let o=1;o<this.rows;o++)this.get(o,t)>n&&(n=this.get(o,t),e[0]=o);return e}minColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let n=this.get(0,t);for(let e=1;e<this.rows;e++)this.get(e,t)<n&&(n=this.get(e,t));return n}minColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let n=this.get(0,t),e=[0,t];for(let o=1;o<this.rows;o++)this.get(o,t)<n&&(n=this.get(o,t),e[0]=o);return e}diag(){let t=Math.min(this.rows,this.columns),n=[];for(let e=0;e<t;e++)n.push(this.get(e,e));return n}norm(t="frobenius"){let n=0;if("max"===t)return this.max();if("frobenius"===t){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n+=this.get(t,e)*this.get(t,e);return Math.sqrt(n)}throw new RangeError(`unknown norm type: ${t}`)}cumulativeSum(){let t=0;for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)t+=this.get(n,e),this.set(n,e,t);return this}dot(t){AbstractMatrix.isMatrix(t)&&(t=t.to1DArray());let n=this.to1DArray();if(n.length!==t.length)throw new RangeError("vectors do not have the same size");let e=0;for(let o=0;o<n.length;o++)e+=n[o]*t[o];return e}mmul(t){t=Matrix.checkMatrix(t);let n=this.rows,e=this.columns,o=t.columns,r=new Matrix(n,o),i=new Float64Array(e);for(let a=0;a<o;a++){for(let n=0;n<e;n++)i[n]=t.get(n,a);for(let t=0;t<n;t++){let n=0;for(let o=0;o<e;o++)n+=this.get(t,o)*i[o];r.set(t,a,n)}}return r}strassen2x2(t){t=Matrix.checkMatrix(t);let n=new Matrix(2,2);const e=this.get(0,0),o=t.get(0,0),r=this.get(0,1),i=t.get(0,1),a=this.get(1,0),s=t.get(1,0),u=this.get(1,1),f=t.get(1,1),l=(e+u)*(o+f),c=(a+u)*o,h=e*(i-f),w=u*(s-o),g=(e+r)*f,m=l+w-g+(r-u)*(s+f),d=h+g,p=c+w,G=l-c+h+(a-e)*(o+i);return n.set(0,0,m),n.set(0,1,d),n.set(1,0,p),n.set(1,1,G),n}strassen3x3(t){t=Matrix.checkMatrix(t);let n=new Matrix(3,3);const e=this.get(0,0),o=this.get(0,1),r=this.get(0,2),i=this.get(1,0),a=this.get(1,1),s=this.get(1,2),u=this.get(2,0),f=this.get(2,1),l=this.get(2,2),c=t.get(0,0),h=t.get(0,1),w=t.get(0,2),g=t.get(1,0),m=t.get(1,1),d=t.get(1,2),p=t.get(2,0),G=t.get(2,1),b=t.get(2,2),y=(e-i)*(-h+m),j=(-e+i+a)*(c-h+m),N=(i+a)*(-c+h),H=e*c,v=(-e+u+f)*(c-w+d),M=(-e+u)*(w-d),A=(u+f)*(-c+w),S=(-r+f+l)*(m+p-G),C=(r-l)*(m-G),x=r*p,k=(f+l)*(-p+G),R=(-r+a+s)*(d+p-b),I=(r-s)*(d-b),D=(a+s)*(-p+b),F=H+x+o*g,T=(e+o+r-i-a-f-l)*m+j+N+H+S+x+k,B=H+v+A+(e+o+r-a-s-u-f)*d+x+R+D,$=y+a*(-c+h+g-m-d-p+b)+j+H+x+R+I,P=y+j+N+H+s*G,K=x+R+I+D+i*w,V=H+v+M+f*(-c+w+g-m-d-p+G)+S+C+x,E=S+C+x+k+u*h,O=H+v+M+A+l*b;return n.set(0,0,F),n.set(0,1,T),n.set(0,2,B),n.set(1,0,$),n.set(1,1,P),n.set(1,2,K),n.set(2,0,V),n.set(2,1,E),n.set(2,2,O),n}mmulStrassen(t){t=Matrix.checkMatrix(t);let n=this.clone(),e=n.rows,o=n.columns,r=t.rows,i=t.columns;function a(t,n,e){let o=t.rows,r=t.columns;if(o===n&&r===e)return t;{let o=AbstractMatrix.zeros(n,e);return o=o.setSubMatrix(t,0,0),o}}o!==r&&console.warn(`Multiplying ${e} x ${o} and ${r} x ${i} matrix: dimensions do not match.`);let s=Math.max(e,r),u=Math.max(o,i);return n=a(n,s,u),function t(n,e,o,r){if(o<=512||r<=512)return n.mmul(e);o%2==1&&r%2==1?(n=a(n,o+1,r+1),e=a(e,o+1,r+1)):o%2==1?(n=a(n,o+1,r),e=a(e,o+1,r)):r%2==1&&(n=a(n,o,r+1),e=a(e,o,r+1));let i=parseInt(n.rows/2,10),s=parseInt(n.columns/2,10),u=n.subMatrix(0,i-1,0,s-1),f=e.subMatrix(0,i-1,0,s-1),l=n.subMatrix(0,i-1,s,n.columns-1),c=e.subMatrix(0,i-1,s,e.columns-1),h=n.subMatrix(i,n.rows-1,0,s-1),w=e.subMatrix(i,e.rows-1,0,s-1),g=n.subMatrix(i,n.rows-1,s,n.columns-1),m=e.subMatrix(i,e.rows-1,s,e.columns-1),d=t(AbstractMatrix.add(u,g),AbstractMatrix.add(f,m),i,s),p=t(AbstractMatrix.add(h,g),f,i,s),G=t(u,AbstractMatrix.sub(c,m),i,s),b=t(g,AbstractMatrix.sub(w,f),i,s),y=t(AbstractMatrix.add(u,l),m,i,s),j=t(AbstractMatrix.sub(h,u),AbstractMatrix.add(f,c),i,s),N=t(AbstractMatrix.sub(l,g),AbstractMatrix.add(w,m),i,s),H=AbstractMatrix.add(d,b);H.sub(y),H.add(N);let v=AbstractMatrix.add(G,y),M=AbstractMatrix.add(p,b),A=AbstractMatrix.sub(d,p);A.add(G),A.add(j);let S=AbstractMatrix.zeros(2*H.rows,2*H.columns);return S=S.setSubMatrix(H,0,0),S=S.setSubMatrix(v,H.rows,0),S=S.setSubMatrix(M,0,H.columns),S=S.setSubMatrix(A,H.rows,H.columns),S.subMatrix(0,o-1,0,r-1)}(n,t=a(t,s,u),s,u)}scaleRows(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:n=0,max:e=1}=t;if(!Number.isFinite(n))throw new TypeError("min must be a number");if(!Number.isFinite(e))throw new TypeError("max must be a number");if(n>=e)throw new RangeError("min must be smaller than max");let o=new Matrix(this.rows,this.columns);for(let t=0;t<this.rows;t++){const r=this.getRow(t);r.length>0&&rescale(r,{min:n,max:e,output:r}),o.setRow(t,r)}return o}scaleColumns(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:n=0,max:e=1}=t;if(!Number.isFinite(n))throw new TypeError("min must be a number");if(!Number.isFinite(e))throw new TypeError("max must be a number");if(n>=e)throw new RangeError("min must be smaller than max");let o=new Matrix(this.rows,this.columns);for(let t=0;t<this.columns;t++){const r=this.getColumn(t);r.length&&rescale(r,{min:n,max:e,output:r}),o.setColumn(t,r)}return o}flipRows(){const t=Math.ceil(this.columns/2);for(let n=0;n<this.rows;n++)for(let e=0;e<t;e++){let t=this.get(n,e),o=this.get(n,this.columns-1-e);this.set(n,e,o),this.set(n,this.columns-1-e,t)}return this}flipColumns(){const t=Math.ceil(this.rows/2);for(let n=0;n<this.columns;n++)for(let e=0;e<t;e++){let t=this.get(e,n),o=this.get(this.rows-1-e,n);this.set(e,n,o),this.set(this.rows-1-e,n,t)}return this}kroneckerProduct(t){t=Matrix.checkMatrix(t);let n=this.rows,e=this.columns,o=t.rows,r=t.columns,i=new Matrix(n*o,e*r);for(let a=0;a<n;a++)for(let n=0;n<e;n++)for(let e=0;e<o;e++)for(let s=0;s<r;s++)i.set(o*a+e,r*n+s,this.get(a,n)*t.get(e,s));return i}kroneckerSum(t){if(t=Matrix.checkMatrix(t),!this.isSquare()||!t.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let n=this.rows,e=t.rows,o=this.kroneckerProduct(Matrix.eye(e,e)),r=Matrix.eye(n,n).kroneckerProduct(t);return o.add(r)}transpose(){let t=new Matrix(this.columns,this.rows);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)t.set(e,n,this.get(n,e));return t}sortRows(t=compareNumbers){for(let n=0;n<this.rows;n++)this.setRow(n,this.getRow(n).sort(t));return this}sortColumns(t=compareNumbers){for(let n=0;n<this.columns;n++)this.setColumn(n,this.getColumn(n).sort(t));return this}subMatrix(t,n,e,o){checkRange(this,t,n,e,o);let r=new Matrix(n-t+1,o-e+1);for(let i=t;i<=n;i++)for(let n=e;n<=o;n++)r.set(i-t,n-e,this.get(i,n));return r}subMatrixRow(t,n,e){if(void 0===n&&(n=0),void 0===e&&(e=this.columns-1),n>e||n<0||n>=this.columns||e<0||e>=this.columns)throw new RangeError("Argument out of range");let o=new Matrix(t.length,e-n+1);for(let r=0;r<t.length;r++)for(let i=n;i<=e;i++){if(t[r]<0||t[r]>=this.rows)throw new RangeError(`Row index out of range: ${t[r]}`);o.set(r,i-n,this.get(t[r],i))}return o}subMatrixColumn(t,n,e){if(void 0===n&&(n=0),void 0===e&&(e=this.rows-1),n>e||n<0||n>=this.rows||e<0||e>=this.rows)throw new RangeError("Argument out of range");let o=new Matrix(e-n+1,t.length);for(let r=0;r<t.length;r++)for(let i=n;i<=e;i++){if(t[r]<0||t[r]>=this.columns)throw new RangeError(`Column index out of range: ${t[r]}`);o.set(i-n,r,this.get(i,t[r]))}return o}setSubMatrix(t,n,e){if((t=Matrix.checkMatrix(t)).isEmpty())return this;checkRange(this,n,n+t.rows-1,e,e+t.columns-1);for(let o=0;o<t.rows;o++)for(let r=0;r<t.columns;r++)this.set(n+o,e+r,t.get(o,r));return this}selection(t,n){let e=checkIndices(this,t,n),o=new Matrix(t.length,n.length);for(let t=0;t<e.row.length;t++){let n=e.row[t];for(let r=0;r<e.column.length;r++){let i=e.column[r];o.set(t,r,this.get(n,i))}}return o}trace(){let t=Math.min(this.rows,this.columns),n=0;for(let e=0;e<t;e++)n+=this.get(e,e);return n}clone(){let t=new Matrix(this.rows,this.columns);for(let n=0;n<this.rows;n++)for(let e=0;e<this.columns;e++)t.set(n,e,this.get(n,e));return t}sum(t){switch(t){case"row":return sumByRow(this);case"column":return sumByColumn(this);case void 0:return sumAll(this);default:throw new Error(`invalid option: ${t}`)}}product(t){switch(t){case"row":return productByRow(this);case"column":return productByColumn(this);case void 0:return productAll(this);default:throw new Error(`invalid option: ${t}`)}}mean(t){const n=this.sum(t);switch(t){case"row":for(let t=0;t<this.rows;t++)n[t]/=this.columns;return n;case"column":for(let t=0;t<this.columns;t++)n[t]/=this.rows;return n;case void 0:return n/this.size;default:throw new Error(`invalid option: ${t}`)}}variance(t,n={}){if("object"==typeof t&&(n=t,t=void 0),"object"!=typeof n)throw new TypeError("options must be an object");const{unbiased:e=!0,mean:o=this.mean(t)}=n;if("boolean"!=typeof e)throw new TypeError("unbiased must be a boolean");switch(t){case"row":if(!Array.isArray(o))throw new TypeError("mean must be an array");return varianceByRow(this,e,o);case"column":if(!Array.isArray(o))throw new TypeError("mean must be an array");return varianceByColumn(this,e,o);case void 0:if("number"!=typeof o)throw new TypeError("mean must be a number");return varianceAll(this,e,o);default:throw new Error(`invalid option: ${t}`)}}standardDeviation(t,n){"object"==typeof t&&(n=t,t=void 0);const e=this.variance(t,n);if(void 0===t)return Math.sqrt(e);for(let t=0;t<e.length;t++)e[t]=Math.sqrt(e[t]);return e}center(t,n={}){if("object"==typeof t&&(n=t,t=void 0),"object"!=typeof n)throw new TypeError("options must be an object");const{center:e=this.mean(t)}=n;switch(t){case"row":if(!Array.isArray(e))throw new TypeError("center must be an array");return centerByRow(this,e),this;case"column":if(!Array.isArray(e))throw new TypeError("center must be an array");return centerByColumn(this,e),this;case void 0:if("number"!=typeof e)throw new TypeError("center must be a number");return centerAll(this,e),this;default:throw new Error(`invalid option: ${t}`)}}scale(t,n={}){if("object"==typeof t&&(n=t,t=void 0),"object"!=typeof n)throw new TypeError("options must be an object");let e=n.scale;switch(t){case"row":if(void 0===e)e=getScaleByRow(this);else if(!Array.isArray(e))throw new TypeError("scale must be an array");return scaleByRow(this,e),this;case"column":if(void 0===e)e=getScaleByColumn(this);else if(!Array.isArray(e))throw new TypeError("scale must be an array");return scaleByColumn(this,e),this;case void 0:if(void 0===e)e=getScaleAll(this);else if("number"!=typeof e)throw new TypeError("scale must be a number");return scaleAll(this,e),this;default:throw new Error(`invalid option: ${t}`)}}toString(t){return inspectMatrixWithOptions(this,t)}}function compareNumbers(t,n){return t-n}AbstractMatrix.prototype.klass="Matrix","undefined"!=typeof Symbol&&(AbstractMatrix.prototype[Symbol.for("nodejs.util.inspect.custom")]=inspectMatrix),AbstractMatrix.random=AbstractMatrix.rand,AbstractMatrix.randomInt=AbstractMatrix.randInt,AbstractMatrix.diagonal=AbstractMatrix.diag,AbstractMatrix.prototype.diagonal=AbstractMatrix.prototype.diag,AbstractMatrix.identity=AbstractMatrix.eye,AbstractMatrix.prototype.negate=AbstractMatrix.prototype.neg,AbstractMatrix.prototype.tensorProduct=AbstractMatrix.prototype.kroneckerProduct;class Matrix extends AbstractMatrix{constructor(t,n){if(super(),Matrix.isMatrix(t))return t.clone();if(Number.isInteger(t)&&t>=0){if(this.data=[],!(Number.isInteger(n)&&n>=0))throw new TypeError("nColumns must be a positive integer");for(let e=0;e<t;e++)this.data.push(new Float64Array(n))}else{if(!Array.isArray(t))throw new TypeError("First argument must be a positive number or an array");{const e=t;if("number"!=typeof(n=(t=e.length)?e[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let o=0;o<t;o++){if(e[o].length!==n)throw new RangeError("Inconsistent array dimensions");this.data.push(Float64Array.from(e[o]))}}}this.rows=t,this.columns=n}set(t,n,e){return this.data[t][n]=e,this}get(t,n){return this.data[t][n]}removeRow(t){return checkRowIndex(this,t),this.data.splice(t,1),this.rows-=1,this}addRow(t,n){return void 0===n&&(n=t,t=this.rows),checkRowIndex(this,t,!0),n=Float64Array.from(checkRowVector(this,n)),this.data.splice(t,0,n),this.rows+=1,this}removeColumn(t){checkColumnIndex(this,t);for(let n=0;n<this.rows;n++){const e=new Float64Array(this.columns-1);for(let o=0;o<t;o++)e[o]=this.data[n][o];for(let o=t+1;o<this.columns;o++)e[o-1]=this.data[n][o];this.data[n]=e}return this.columns-=1,this}addColumn(t,n){void 0===n&&(n=t,t=this.columns),checkColumnIndex(this,t,!0),n=checkColumnVector(this,n);for(let e=0;e<this.rows;e++){const o=new Float64Array(this.columns+1);let r=0;for(;r<t;r++)o[r]=this.data[e][r];for(o[r++]=n[e];r<this.columns+1;r++)o[r]=this.data[e][r-1];this.data[e]=o}return this.columns+=1,this}}installMathOperations(AbstractMatrix,Matrix);class WrapperMatrix2D extends AbstractMatrix{constructor(t){super(),this.data=t,this.rows=t.length,this.columns=t[0].length}set(t,n,e){return this.data[t][n]=e,this}get(t,n){return this.data[t][n]}}class LuDecomposition{constructor(t){let n,e,o,r,i,a,s,u,f,l=(t=WrapperMatrix2D.checkMatrix(t)).clone(),c=l.rows,h=l.columns,w=new Float64Array(c),g=1;for(n=0;n<c;n++)w[n]=n;for(u=new Float64Array(c),e=0;e<h;e++){for(n=0;n<c;n++)u[n]=l.get(n,e);for(n=0;n<c;n++){for(f=Math.min(n,e),i=0,o=0;o<f;o++)i+=l.get(n,o)*u[o];u[n]-=i,l.set(n,e,u[n])}for(r=e,n=e+1;n<c;n++)Math.abs(u[n])>Math.abs(u[r])&&(r=n);if(r!==e){for(o=0;o<h;o++)a=l.get(r,o),l.set(r,o,l.get(e,o)),l.set(e,o,a);s=w[r],w[r]=w[e],w[e]=s,g=-g}if(e<c&&0!==l.get(e,e))for(n=e+1;n<c;n++)l.set(n,e,l.get(n,e)/l.get(e,e))}this.LU=l,this.pivotVector=w,this.pivotSign=g}isSingular(){let t=this.LU,n=t.columns;for(let e=0;e<n;e++)if(0===t.get(e,e))return!0;return!1}solve(t){t=Matrix.checkMatrix(t);let n=this.LU;if(n.rows!==t.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let e,o,r,i=t.columns,a=t.subMatrixRow(this.pivotVector,0,i-1),s=n.columns;for(r=0;r<s;r++)for(e=r+1;e<s;e++)for(o=0;o<i;o++)a.set(e,o,a.get(e,o)-a.get(r,o)*n.get(e,r));for(r=s-1;r>=0;r--){for(o=0;o<i;o++)a.set(r,o,a.get(r,o)/n.get(r,r));for(e=0;e<r;e++)for(o=0;o<i;o++)a.set(e,o,a.get(e,o)-a.get(r,o)*n.get(e,r))}return a}get determinant(){let t=this.LU;if(!t.isSquare())throw new Error("Matrix must be square");let n=this.pivotSign,e=t.columns;for(let o=0;o<e;o++)n*=t.get(o,o);return n}get lowerTriangularMatrix(){let t=this.LU,n=t.rows,e=t.columns,o=new Matrix(n,e);for(let r=0;r<n;r++)for(let n=0;n<e;n++)r>n?o.set(r,n,t.get(r,n)):r===n?o.set(r,n,1):o.set(r,n,0);return o}get upperTriangularMatrix(){let t=this.LU,n=t.rows,e=t.columns,o=new Matrix(n,e);for(let r=0;r<n;r++)for(let n=0;n<e;n++)r<=n?o.set(r,n,t.get(r,n)):o.set(r,n,0);return o}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function hypotenuse(t,n){let e=0;return Math.abs(t)>Math.abs(n)?(e=n/t,Math.abs(t)*Math.sqrt(1+e*e)):0!==n?(e=t/n,Math.abs(n)*Math.sqrt(1+e*e)):0}class QrDecomposition{constructor(t){let n,e,o,r,i=(t=WrapperMatrix2D.checkMatrix(t)).clone(),a=t.rows,s=t.columns,u=new Float64Array(s);for(o=0;o<s;o++){let t=0;for(n=o;n<a;n++)t=hypotenuse(t,i.get(n,o));if(0!==t){for(i.get(o,o)<0&&(t=-t),n=o;n<a;n++)i.set(n,o,i.get(n,o)/t);for(i.set(o,o,i.get(o,o)+1),e=o+1;e<s;e++){for(r=0,n=o;n<a;n++)r+=i.get(n,o)*i.get(n,e);for(r=-r/i.get(o,o),n=o;n<a;n++)i.set(n,e,i.get(n,e)+r*i.get(n,o))}}u[o]=-t}this.QR=i,this.Rdiag=u}solve(t){t=Matrix.checkMatrix(t);let n=this.QR,e=n.rows;if(t.rows!==e)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let o,r,i,a,s=t.columns,u=t.clone(),f=n.columns;for(i=0;i<f;i++)for(r=0;r<s;r++){for(a=0,o=i;o<e;o++)a+=n.get(o,i)*u.get(o,r);for(a=-a/n.get(i,i),o=i;o<e;o++)u.set(o,r,u.get(o,r)+a*n.get(o,i))}for(i=f-1;i>=0;i--){for(r=0;r<s;r++)u.set(i,r,u.get(i,r)/this.Rdiag[i]);for(o=0;o<i;o++)for(r=0;r<s;r++)u.set(o,r,u.get(o,r)-u.get(i,r)*n.get(o,i))}return u.subMatrix(0,f-1,0,s-1)}isFullRank(){let t=this.QR.columns;for(let n=0;n<t;n++)if(0===this.Rdiag[n])return!1;return!0}get upperTriangularMatrix(){let t,n,e=this.QR,o=e.columns,r=new Matrix(o,o);for(t=0;t<o;t++)for(n=0;n<o;n++)t<n?r.set(t,n,e.get(t,n)):t===n?r.set(t,n,this.Rdiag[t]):r.set(t,n,0);return r}get orthogonalMatrix(){let t,n,e,o,r=this.QR,i=r.rows,a=r.columns,s=new Matrix(i,a);for(e=a-1;e>=0;e--){for(t=0;t<i;t++)s.set(t,e,0);for(s.set(e,e,1),n=e;n<a;n++)if(0!==r.get(e,e)){for(o=0,t=e;t<i;t++)o+=r.get(t,e)*s.get(t,n);for(o=-o/r.get(e,e),t=e;t<i;t++)s.set(t,n,s.get(t,n)+o*r.get(t,e))}}return s}}class SingularValueDecomposition{constructor(t,n={}){if((t=WrapperMatrix2D.checkMatrix(t)).isEmpty())throw new Error("Matrix must be non-empty");let e=t.rows,o=t.columns;const{computeLeftSingularVectors:r=!0,computeRightSingularVectors:i=!0,autoTranspose:a=!1}=n;let s,u=Boolean(r),f=Boolean(i),l=!1;if(e<o)if(a){s=t.transpose(),e=s.rows,o=s.columns,l=!0;let n=u;u=f,f=n}else s=t.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else s=t.clone();let c=Math.min(e,o),h=Math.min(e+1,o),w=new Float64Array(h),g=new Matrix(e,c),m=new Matrix(o,o),d=new Float64Array(o),p=new Float64Array(e),G=new Float64Array(h);for(let t=0;t<h;t++)G[t]=t;let b=Math.min(e-1,o),y=Math.max(0,Math.min(o-2,e)),j=Math.max(b,y);for(let t=0;t<j;t++){if(t<b){w[t]=0;for(let n=t;n<e;n++)w[t]=hypotenuse(w[t],s.get(n,t));if(0!==w[t]){s.get(t,t)<0&&(w[t]=-w[t]);for(let n=t;n<e;n++)s.set(n,t,s.get(n,t)/w[t]);s.set(t,t,s.get(t,t)+1)}w[t]=-w[t]}for(let n=t+1;n<o;n++){if(t<b&&0!==w[t]){let o=0;for(let r=t;r<e;r++)o+=s.get(r,t)*s.get(r,n);o=-o/s.get(t,t);for(let r=t;r<e;r++)s.set(r,n,s.get(r,n)+o*s.get(r,t))}d[n]=s.get(t,n)}if(u&&t<b)for(let n=t;n<e;n++)g.set(n,t,s.get(n,t));if(t<y){d[t]=0;for(let n=t+1;n<o;n++)d[t]=hypotenuse(d[t],d[n]);if(0!==d[t]){d[t+1]<0&&(d[t]=0-d[t]);for(let n=t+1;n<o;n++)d[n]/=d[t];d[t+1]+=1}if(d[t]=-d[t],t+1<e&&0!==d[t]){for(let n=t+1;n<e;n++)p[n]=0;for(let n=t+1;n<e;n++)for(let e=t+1;e<o;e++)p[n]+=d[e]*s.get(n,e);for(let n=t+1;n<o;n++){let o=-d[n]/d[t+1];for(let r=t+1;r<e;r++)s.set(r,n,s.get(r,n)+o*p[r])}}if(f)for(let n=t+1;n<o;n++)m.set(n,t,d[n])}}let N=Math.min(o,e+1);if(b<o&&(w[b]=s.get(b,b)),e<N&&(w[N-1]=0),y+1<N&&(d[y]=s.get(y,N-1)),d[N-1]=0,u){for(let t=b;t<c;t++){for(let n=0;n<e;n++)g.set(n,t,0);g.set(t,t,1)}for(let t=b-1;t>=0;t--)if(0!==w[t]){for(let n=t+1;n<c;n++){let o=0;for(let r=t;r<e;r++)o+=g.get(r,t)*g.get(r,n);o=-o/g.get(t,t);for(let r=t;r<e;r++)g.set(r,n,g.get(r,n)+o*g.get(r,t))}for(let n=t;n<e;n++)g.set(n,t,-g.get(n,t));g.set(t,t,1+g.get(t,t));for(let n=0;n<t-1;n++)g.set(n,t,0)}else{for(let n=0;n<e;n++)g.set(n,t,0);g.set(t,t,1)}}if(f)for(let t=o-1;t>=0;t--){if(t<y&&0!==d[t])for(let n=t+1;n<o;n++){let e=0;for(let r=t+1;r<o;r++)e+=m.get(r,t)*m.get(r,n);e=-e/m.get(t+1,t);for(let r=t+1;r<o;r++)m.set(r,n,m.get(r,n)+e*m.get(r,t))}for(let n=0;n<o;n++)m.set(n,t,0);m.set(t,t,1)}let H=N-1,v=Number.EPSILON;for(;N>0;){let t,n;for(t=N-2;t>=-1&&-1!==t;t--){const n=Number.MIN_VALUE+v*Math.abs(w[t]+Math.abs(w[t+1]));if(Math.abs(d[t])<=n||Number.isNaN(d[t])){d[t]=0;break}}if(t===N-2)n=4;else{let e;for(e=N-1;e>=t&&e!==t;e--){let n=(e!==N?Math.abs(d[e]):0)+(e!==t+1?Math.abs(d[e-1]):0);if(Math.abs(w[e])<=v*n){w[e]=0;break}}e===t?n=3:e===N-1?n=1:(n=2,t=e)}switch(t++,n){case 1:{let n=d[N-2];d[N-2]=0;for(let e=N-2;e>=t;e--){let r=hypotenuse(w[e],n),i=w[e]/r,a=n/r;if(w[e]=r,e!==t&&(n=-a*d[e-1],d[e-1]=i*d[e-1]),f)for(let t=0;t<o;t++)r=i*m.get(t,e)+a*m.get(t,N-1),m.set(t,N-1,-a*m.get(t,e)+i*m.get(t,N-1)),m.set(t,e,r)}break}case 2:{let n=d[t-1];d[t-1]=0;for(let o=t;o<N;o++){let r=hypotenuse(w[o],n),i=w[o]/r,a=n/r;if(w[o]=r,n=-a*d[o],d[o]=i*d[o],u)for(let n=0;n<e;n++)r=i*g.get(n,o)+a*g.get(n,t-1),g.set(n,t-1,-a*g.get(n,o)+i*g.get(n,t-1)),g.set(n,o,r)}break}case 3:{const n=Math.max(Math.abs(w[N-1]),Math.abs(w[N-2]),Math.abs(d[N-2]),Math.abs(w[t]),Math.abs(d[t])),r=w[N-1]/n,i=w[N-2]/n,a=d[N-2]/n,s=w[t]/n,l=d[t]/n,c=((i+r)*(i-r)+a*a)/2,h=r*a*(r*a);let p=0;0===c&&0===h||(p=c<0?0-Math.sqrt(c*c+h):Math.sqrt(c*c+h),p=h/(c+p));let G=(s+r)*(s-r)+p,b=s*l;for(let n=t;n<N-1;n++){let r=hypotenuse(G,b);0===r&&(r=Number.MIN_VALUE);let i=G/r,a=b/r;if(n!==t&&(d[n-1]=r),G=i*w[n]+a*d[n],d[n]=i*d[n]-a*w[n],b=a*w[n+1],w[n+1]=i*w[n+1],f)for(let t=0;t<o;t++)r=i*m.get(t,n)+a*m.get(t,n+1),m.set(t,n+1,-a*m.get(t,n)+i*m.get(t,n+1)),m.set(t,n,r);if(r=hypotenuse(G,b),0===r&&(r=Number.MIN_VALUE),i=G/r,a=b/r,w[n]=r,G=i*d[n]+a*w[n+1],w[n+1]=-a*d[n]+i*w[n+1],b=a*d[n+1],d[n+1]=i*d[n+1],u&&n<e-1)for(let t=0;t<e;t++)r=i*g.get(t,n)+a*g.get(t,n+1),g.set(t,n+1,-a*g.get(t,n)+i*g.get(t,n+1)),g.set(t,n,r)}d[N-2]=G;break}case 4:if(w[t]<=0&&(w[t]=w[t]<0?-w[t]:0,f))for(let n=0;n<=H;n++)m.set(n,t,-m.get(n,t));for(;t<H&&!(w[t]>=w[t+1]);){let n=w[t];if(w[t]=w[t+1],w[t+1]=n,f&&t<o-1)for(let e=0;e<o;e++)n=m.get(e,t+1),m.set(e,t+1,m.get(e,t)),m.set(e,t,n);if(u&&t<e-1)for(let o=0;o<e;o++)n=g.get(o,t+1),g.set(o,t+1,g.get(o,t)),g.set(o,t,n);t++}N--}}if(l){let t=m;m=g,g=t}this.m=e,this.n=o,this.s=w,this.U=g,this.V=m}solve(t){let n=t,e=this.threshold,o=this.s.length,r=Matrix.zeros(o,o);for(let t=0;t<o;t++)Math.abs(this.s[t])<=e?r.set(t,t,0):r.set(t,t,1/this.s[t]);let i=this.U,a=this.rightSingularVectors,s=a.mmul(r),u=a.rows,f=i.rows,l=Matrix.zeros(u,f);for(let t=0;t<u;t++)for(let n=0;n<f;n++){let e=0;for(let r=0;r<o;r++)e+=s.get(t,r)*i.get(n,r);l.set(t,n,e)}return l.mmul(n)}solveForDiagonal(t){return this.solve(Matrix.diag(t))}inverse(){let t=this.V,n=this.threshold,e=t.rows,o=t.columns,r=new Matrix(e,this.s.length);for(let i=0;i<e;i++)for(let e=0;e<o;e++)Math.abs(this.s[e])>n&&r.set(i,e,t.get(i,e)/this.s[e]);let i=this.U,a=i.rows,s=i.columns,u=new Matrix(e,a);for(let t=0;t<e;t++)for(let n=0;n<a;n++){let e=0;for(let o=0;o<s;o++)e+=r.get(t,o)*i.get(n,o);u.set(t,n,e)}return u}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let t=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,n=0,e=this.s;for(let o=0,r=e.length;o<r;o++)e[o]>t&&n++;return n}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return Matrix.diag(this.s)}}function inverse(t,n=!1){return t=WrapperMatrix2D.checkMatrix(t),n?new SingularValueDecomposition(t).inverse():solve(t,Matrix.eye(t.rows))}function solve(t,n,e=!1){return t=WrapperMatrix2D.checkMatrix(t),n=WrapperMatrix2D.checkMatrix(n),e?new SingularValueDecomposition(t).solve(n):t.isSquare()?new LuDecomposition(t).solve(n):new QrDecomposition(t).solve(n)}class EigenvalueDecomposition{constructor(t,n={}){const{assumeSymmetric:e=!1}=n;if(!(t=WrapperMatrix2D.checkMatrix(t)).isSquare())throw new Error("Matrix is not a square matrix");if(t.isEmpty())throw new Error("Matrix must be non-empty");let o,r,i=t.columns,a=new Matrix(i,i),s=new Float64Array(i),u=new Float64Array(i),f=t,l=!1;if(l=!!e||t.isSymmetric(),l){for(o=0;o<i;o++)for(r=0;r<i;r++)a.set(o,r,f.get(o,r));tred2(i,u,s,a),tql2(i,u,s,a)}else{let t=new Matrix(i,i),n=new Float64Array(i);for(r=0;r<i;r++)for(o=0;o<i;o++)t.set(o,r,f.get(o,r));orthes(i,t,n,a),hqr2(i,u,s,a,t)}this.n=i,this.e=u,this.d=s,this.V=a}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let t,n,e=this.n,o=this.e,r=this.d,i=new Matrix(e,e);for(t=0;t<e;t++){for(n=0;n<e;n++)i.set(t,n,0);i.set(t,t,r[t]),o[t]>0?i.set(t,t+1,o[t]):o[t]<0&&i.set(t,t-1,o[t])}return i}}function tred2(t,n,e,o){let r,i,a,s,u,f,l,c;for(u=0;u<t;u++)e[u]=o.get(t-1,u);for(s=t-1;s>0;s--){for(c=0,a=0,f=0;f<s;f++)c+=Math.abs(e[f]);if(0===c)for(n[s]=e[s-1],u=0;u<s;u++)e[u]=o.get(s-1,u),o.set(s,u,0),o.set(u,s,0);else{for(f=0;f<s;f++)e[f]/=c,a+=e[f]*e[f];for(r=e[s-1],i=Math.sqrt(a),r>0&&(i=-i),n[s]=c*i,a-=r*i,e[s-1]=r-i,u=0;u<s;u++)n[u]=0;for(u=0;u<s;u++){for(r=e[u],o.set(u,s,r),i=n[u]+o.get(u,u)*r,f=u+1;f<=s-1;f++)i+=o.get(f,u)*e[f],n[f]+=o.get(f,u)*r;n[u]=i}for(r=0,u=0;u<s;u++)n[u]/=a,r+=n[u]*e[u];for(l=r/(a+a),u=0;u<s;u++)n[u]-=l*e[u];for(u=0;u<s;u++){for(r=e[u],i=n[u],f=u;f<=s-1;f++)o.set(f,u,o.get(f,u)-(r*n[f]+i*e[f]));e[u]=o.get(s-1,u),o.set(s,u,0)}}e[s]=a}for(s=0;s<t-1;s++){if(o.set(t-1,s,o.get(s,s)),o.set(s,s,1),a=e[s+1],0!==a){for(f=0;f<=s;f++)e[f]=o.get(f,s+1)/a;for(u=0;u<=s;u++){for(i=0,f=0;f<=s;f++)i+=o.get(f,s+1)*o.get(f,u);for(f=0;f<=s;f++)o.set(f,u,o.get(f,u)-i*e[f])}}for(f=0;f<=s;f++)o.set(f,s+1,0)}for(u=0;u<t;u++)e[u]=o.get(t-1,u),o.set(t-1,u,0);o.set(t-1,t-1,1),n[0]=0}function tql2(t,n,e,o){let r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b;for(a=1;a<t;a++)n[a-1]=n[a];n[t-1]=0;let y=0,j=0,N=Number.EPSILON;for(f=0;f<t;f++){for(j=Math.max(j,Math.abs(e[f])+Math.abs(n[f])),l=f;l<t&&!(Math.abs(n[l])<=N*j);)l++;if(l>f)do{for(r=e[f],c=(e[f+1]-r)/(2*n[f]),h=hypotenuse(c,1),c<0&&(h=-h),e[f]=n[f]/(c+h),e[f+1]=n[f]*(c+h),w=e[f+1],i=r-e[f],a=f+2;a<t;a++)e[a]-=i;for(y+=i,c=e[l],g=1,m=g,d=g,p=n[f+1],G=0,b=0,a=l-1;a>=f;a--)for(d=m,m=g,b=G,r=g*n[a],i=g*c,h=hypotenuse(c,n[a]),n[a+1]=G*h,G=n[a]/h,g=c/h,c=g*e[a]-G*r,e[a+1]=i+G*(g*r+G*e[a]),u=0;u<t;u++)i=o.get(u,a+1),o.set(u,a+1,G*o.get(u,a)+g*i),o.set(u,a,g*o.get(u,a)-G*i);c=-G*b*d*p*n[f]/w,n[f]=G*c,e[f]=g*c}while(Math.abs(n[f])>N*j);e[f]=e[f]+y,n[f]=0}for(a=0;a<t-1;a++){for(u=a,c=e[a],s=a+1;s<t;s++)e[s]<c&&(u=s,c=e[s]);if(u!==a)for(e[u]=e[a],e[a]=c,s=0;s<t;s++)c=o.get(s,a),o.set(s,a,o.get(s,u)),o.set(s,u,c)}}function orthes(t,n,e,o){let r,i,a,s,u,f,l,c=t-1;for(f=1;f<=c-1;f++){for(l=0,s=f;s<=c;s++)l+=Math.abs(n.get(s,f-1));if(0!==l){for(a=0,s=c;s>=f;s--)e[s]=n.get(s,f-1)/l,a+=e[s]*e[s];for(i=Math.sqrt(a),e[f]>0&&(i=-i),a-=e[f]*i,e[f]=e[f]-i,u=f;u<t;u++){for(r=0,s=c;s>=f;s--)r+=e[s]*n.get(s,u);for(r/=a,s=f;s<=c;s++)n.set(s,u,n.get(s,u)-r*e[s])}for(s=0;s<=c;s++){for(r=0,u=c;u>=f;u--)r+=e[u]*n.get(s,u);for(r/=a,u=f;u<=c;u++)n.set(s,u,n.get(s,u)-r*e[u])}e[f]=l*e[f],n.set(f,f-1,l*i)}}for(s=0;s<t;s++)for(u=0;u<t;u++)o.set(s,u,s===u?1:0);for(f=c-1;f>=1;f--)if(0!==n.get(f,f-1)){for(s=f+1;s<=c;s++)e[s]=n.get(s,f-1);for(u=f;u<=c;u++){for(i=0,s=f;s<=c;s++)i+=e[s]*o.get(s,u);for(i=i/e[f]/n.get(f,f-1),s=f;s<=c;s++)o.set(s,u,o.get(s,u)+i*e[s])}}}function hqr2(t,n,e,o,r){let i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y=t-1,j=t-1,N=Number.EPSILON,H=0,v=0,M=0,A=0,S=0,C=0,x=0,k=0;for(i=0;i<t;i++)for((i<0||i>j)&&(e[i]=r.get(i,i),n[i]=0),a=Math.max(i-1,0);a<t;a++)v+=Math.abs(r.get(i,a));for(;y>=0;){for(u=y;u>0&&(C=Math.abs(r.get(u-1,u-1))+Math.abs(r.get(u,u)),0===C&&(C=v),!(Math.abs(r.get(u,u-1))<N*C));)u--;if(u===y)r.set(y,y,r.get(y,y)+H),e[y]=r.get(y,y),n[y]=0,y--,k=0;else if(u===y-1){if(c=r.get(y,y-1)*r.get(y-1,y),M=(r.get(y-1,y-1)-r.get(y,y))/2,A=M*M+c,x=Math.sqrt(Math.abs(A)),r.set(y,y,r.get(y,y)+H),r.set(y-1,y-1,r.get(y-1,y-1)+H),h=r.get(y,y),A>=0){for(x=M>=0?M+x:M-x,e[y-1]=h+x,e[y]=e[y-1],0!==x&&(e[y]=h-c/x),n[y-1]=0,n[y]=0,h=r.get(y,y-1),C=Math.abs(h)+Math.abs(x),M=h/C,A=x/C,S=Math.sqrt(M*M+A*A),M/=S,A/=S,a=y-1;a<t;a++)x=r.get(y-1,a),r.set(y-1,a,A*x+M*r.get(y,a)),r.set(y,a,A*r.get(y,a)-M*x);for(i=0;i<=y;i++)x=r.get(i,y-1),r.set(i,y-1,A*x+M*r.get(i,y)),r.set(i,y,A*r.get(i,y)-M*x);for(i=0;i<=j;i++)x=o.get(i,y-1),o.set(i,y-1,A*x+M*o.get(i,y)),o.set(i,y,A*o.get(i,y)-M*x)}else e[y-1]=h+M,e[y]=h+M,n[y-1]=x,n[y]=-x;y-=2,k=0}else{if(h=r.get(y,y),w=0,c=0,u<y&&(w=r.get(y-1,y-1),c=r.get(y,y-1)*r.get(y-1,y)),10===k){for(H+=h,i=0;i<=y;i++)r.set(i,i,r.get(i,i)-h);C=Math.abs(r.get(y,y-1))+Math.abs(r.get(y-1,y-2)),h=w=.75*C,c=-.4375*C*C}if(30===k&&(C=(w-h)/2,C=C*C+c,C>0)){for(C=Math.sqrt(C),w<h&&(C=-C),C=h-c/((w-h)/2+C),i=0;i<=y;i++)r.set(i,i,r.get(i,i)-C);H+=C,h=w=c=.964}for(k+=1,f=y-2;f>=u&&(x=r.get(f,f),S=h-x,C=w-x,M=(S*C-c)/r.get(f+1,f)+r.get(f,f+1),A=r.get(f+1,f+1)-x-S-C,S=r.get(f+2,f+1),C=Math.abs(M)+Math.abs(A)+Math.abs(S),M/=C,A/=C,S/=C,f!==u)&&!(Math.abs(r.get(f,f-1))*(Math.abs(A)+Math.abs(S))<N*(Math.abs(M)*(Math.abs(r.get(f-1,f-1))+Math.abs(x)+Math.abs(r.get(f+1,f+1)))));)f--;for(i=f+2;i<=y;i++)r.set(i,i-2,0),i>f+2&&r.set(i,i-3,0);for(s=f;s<=y-1&&(G=s!==y-1,s!==f&&(M=r.get(s,s-1),A=r.get(s+1,s-1),S=G?r.get(s+2,s-1):0,h=Math.abs(M)+Math.abs(A)+Math.abs(S),0!==h&&(M/=h,A/=h,S/=h)),0!==h);s++)if(C=Math.sqrt(M*M+A*A+S*S),M<0&&(C=-C),0!==C){for(s!==f?r.set(s,s-1,-C*h):u!==f&&r.set(s,s-1,-r.get(s,s-1)),M+=C,h=M/C,w=A/C,x=S/C,A/=M,S/=M,a=s;a<t;a++)M=r.get(s,a)+A*r.get(s+1,a),G&&(M+=S*r.get(s+2,a),r.set(s+2,a,r.get(s+2,a)-M*x)),r.set(s,a,r.get(s,a)-M*h),r.set(s+1,a,r.get(s+1,a)-M*w);for(i=0;i<=Math.min(y,s+3);i++)M=h*r.get(i,s)+w*r.get(i,s+1),G&&(M+=x*r.get(i,s+2),r.set(i,s+2,r.get(i,s+2)-M*S)),r.set(i,s,r.get(i,s)-M),r.set(i,s+1,r.get(i,s+1)-M*A);for(i=0;i<=j;i++)M=h*o.get(i,s)+w*o.get(i,s+1),G&&(M+=x*o.get(i,s+2),o.set(i,s+2,o.get(i,s+2)-M*S)),o.set(i,s,o.get(i,s)-M),o.set(i,s+1,o.get(i,s+1)-M*A)}}}if(0!==v){for(y=t-1;y>=0;y--)if(M=e[y],A=n[y],0===A)for(u=y,r.set(y,y,1),i=y-1;i>=0;i--){for(c=r.get(i,i)-M,S=0,a=u;a<=y;a++)S+=r.get(i,a)*r.get(a,y);if(n[i]<0)x=c,C=S;else if(u=i,0===n[i]?r.set(i,y,0!==c?-S/c:-S/(N*v)):(h=r.get(i,i+1),w=r.get(i+1,i),A=(e[i]-M)*(e[i]-M)+n[i]*n[i],l=(h*C-x*S)/A,r.set(i,y,l),r.set(i+1,y,Math.abs(h)>Math.abs(x)?(-S-c*l)/h:(-C-w*l)/x)),l=Math.abs(r.get(i,y)),N*l*l>1)for(a=i;a<=y;a++)r.set(a,y,r.get(a,y)/l)}else if(A<0)for(u=y-1,Math.abs(r.get(y,y-1))>Math.abs(r.get(y-1,y))?(r.set(y-1,y-1,A/r.get(y,y-1)),r.set(y-1,y,-(r.get(y,y)-M)/r.get(y,y-1))):(b=cdiv(0,-r.get(y-1,y),r.get(y-1,y-1)-M,A),r.set(y-1,y-1,b[0]),r.set(y-1,y,b[1])),r.set(y,y-1,0),r.set(y,y,1),i=y-2;i>=0;i--){for(g=0,m=0,a=u;a<=y;a++)g+=r.get(i,a)*r.get(a,y-1),m+=r.get(i,a)*r.get(a,y);if(c=r.get(i,i)-M,n[i]<0)x=c,S=g,C=m;else if(u=i,0===n[i]?(b=cdiv(-g,-m,c,A),r.set(i,y-1,b[0]),r.set(i,y,b[1])):(h=r.get(i,i+1),w=r.get(i+1,i),d=(e[i]-M)*(e[i]-M)+n[i]*n[i]-A*A,p=2*(e[i]-M)*A,0===d&&0===p&&(d=N*v*(Math.abs(c)+Math.abs(A)+Math.abs(h)+Math.abs(w)+Math.abs(x))),b=cdiv(h*S-x*g+A*m,h*C-x*m-A*g,d,p),r.set(i,y-1,b[0]),r.set(i,y,b[1]),Math.abs(h)>Math.abs(x)+Math.abs(A)?(r.set(i+1,y-1,(-g-c*r.get(i,y-1)+A*r.get(i,y))/h),r.set(i+1,y,(-m-c*r.get(i,y)-A*r.get(i,y-1))/h)):(b=cdiv(-S-w*r.get(i,y-1),-C-w*r.get(i,y),x,A),r.set(i+1,y-1,b[0]),r.set(i+1,y,b[1]))),l=Math.max(Math.abs(r.get(i,y-1)),Math.abs(r.get(i,y))),N*l*l>1)for(a=i;a<=y;a++)r.set(a,y-1,r.get(a,y-1)/l),r.set(a,y,r.get(a,y)/l)}for(i=0;i<t;i++)if(i<0||i>j)for(a=i;a<t;a++)o.set(i,a,r.get(i,a));for(a=t-1;a>=0;a--)for(i=0;i<=j;i++){for(x=0,s=0;s<=Math.min(a,j);s++)x+=o.get(i,s)*r.get(s,a);o.set(i,a,x)}}}function cdiv(t,n,e,o){let r,i;return Math.abs(e)>Math.abs(o)?(r=o/e,i=e+r*o,[(t+r*n)/i,(n-r*t)/i]):(r=e/o,i=o+r*e,[(r*t+n)/i,(r*n-t)/i])}function gradientFunction(t,n,e,o,r,i){const a=e.length,s=t.x.length;let u=Matrix.zeros(a,s),f=0;for(let l=0;l<a;l++){if(0===o[l])continue;let a=o[l],c=e.slice();c[l]+=a;let h=r(c);if(i){c=e.slice(),c[l]-=a,a*=2;let n=r(c);for(let e=0;e<s;e++)u.set(f,e,(n(t.x[e])-h(t.x[e]))/a)}else for(let e=0;e<s;e++)u.set(f,e,(n[e]-h(t.x[e]))/a);f++}return u}function matrixFunction(t,n){const e=t.x.length;let o=new Matrix(e,1);for(let r=0;r<e;r++)o.set(r,0,t.y[r]-n[r]);return o}function step(t,n,e,o,r,i,a){let s=e,u=Matrix.eye(n.length,n.length,s);const f=r(n);let l=new Float64Array(t.x.length);for(let n=0;n<t.x.length;n++)l[n]=f(t.x[n]);let c=gradientFunction(t,l,n,o,r,i),h=matrixFunction(t,l),w=inverse(u.add(c.mmul(c.transpose().scale("row",{scale:a})))),g=c.mmul(h.scale("row",{scale:a}));return{perturbations:w.mmul(g),jacobianWeigthResidualError:g}}function levenbergMarquardt(t,n,e={}){let{checkTimeout:o,minValues:r,maxValues:i,parameters:a,weightSquare:s,damping:u,dampingStepUp:f,dampingStepDown:l,maxIterations:c,errorTolerance:h,centralDifference:w,gradientDifference:g,improvementThreshold:m}=checkOptions$1(t,n,e),d=errorCalculation(t,a,n,s),p=d<=h,G=0;for(;G<c&&!p;G++){let c=d,{perturbations:G,jacobianWeigthResidualError:b}=step(t,a,u,g,n,w,s);for(let t=0;t<a.length;t++)a[t]=Math.min(Math.max(r[t],a[t]-G.get(t,0)),i[t]);if(d=errorCalculation(t,a,n,s),isNaN(d))break;if((c-d)/G.transpose().mmul(G.mulS(u).add(b)).get(0,0)>m?u=Math.max(u/l,1e-7):(d=c,u=Math.min(u*f,1e7)),o())throw new Error(`The execution time is over to ${e.timeout} seconds`);p=d<=h}return{parameterValues:a,parameterError:d,iterations:G}}const LEVENBERG_MARQUARDT=1;function selectMethod(t={}){let{kind:n,options:e}=t;switch(n=getKind(n),n){case LEVENBERG_MARQUARDT:return{algorithm:levenbergMarquardt,optimizationOptions:checkOptions(n,e)};default:throw new Error("Unknown kind algorithm")}}function checkOptions(t,n={}){switch(t){case LEVENBERG_MARQUARDT:return Object.assign({},lmOptions,n)}}function getKind(t){if("string"!=typeof t)return t;switch(t.toLowerCase().replace(/[^a-z]/g,"")){case"lm":case"levenbergmarquardt":return LEVENBERG_MARQUARDT;default:throw new Error("Unknown kind algorithm")}}const lmOptions={damping:1.5,maxIterations:100,errorTolerance:1e-8};function optimize(t,n,e={}){const{y:o,x:r,maxY:i,peaks:a,paramsFunc:s,optimization:u}=checkInput(t,n,e);let f=u.parameters,l=a.length,c=Object.keys(f),h=l*c.length,w=new Float64Array(h),g=new Float64Array(h),m=new Float64Array(h),d=new Float64Array(h);for(let t=0;t<l;t++){let n=a[t];for(let e=0;e<c.length;e++){let o=c[e],r=f[o].init,i=f[o].min,a=f[o].max,s=f[o].gradientDifference;m[t+e*l]=r[t%r.length](n),w[t+e*l]=i[t%i.length](n),g[t+e*l]=a[t%a.length](n),d[t+e*l]=s[t%s.length](n)}}let{algorithm:p,optimizationOptions:G}=selectMethod(u);G.minValues=w,G.maxValues=g,G.initialValues=m,G.gradientDifference=d;let b=p({x:r,y:o},s,G),{parameterError:y,iterations:j}=b,N={error:y,iterations:j,peaks:a};for(let t=0;t<l;t++){b.parameterValues[t+l]*=i;for(let n=0;n<c.length;n++)a[t][c[n]]=b.parameterValues[t+n*l]}return N}function xAbsolute(t){let n=t.slice();for(let t=0;t<n.length;t++)n[t]<0&&(n[t]*=-1);return n}var medianQuickselect_min={exports:{}};!function(t){!function(){function n(t){for(var n=0,r=t.length-1,i=void 0,a=void 0,s=void 0,u=o(n,r);;){if(r<=n)return t[u];if(r==n+1)return t[n]>t[r]&&e(t,n,r),t[u];for(t[i=o(n,r)]>t[r]&&e(t,i,r),t[n]>t[r]&&e(t,n,r),t[i]>t[n]&&e(t,i,n),e(t,i,n+1),a=n+1,s=r;;){do{a++}while(t[n]>t[a]);do{s--}while(t[s]>t[n]);if(s<a)break;e(t,a,s)}e(t,n,s),s<=u&&(n=a),s>=u&&(r=s-1)}}var e=function(t,n,e){var o;return o=[t[e],t[n]],t[n]=o[0],t[e]=o[1],o},o=function(t,n){return~~((t+n)/2)};t.exports?t.exports=n:window.median=n}()}(medianQuickselect_min);var quickSelectMedian=medianQuickselect_min.exports;function median(t){if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");return quickSelectMedian(t.slice())}function xAbsoluteMedian(t){return median(xAbsolute(t))}function xFindClosestIndex(t,n){let e=0,o=t.length-1,r=0;for(;o-e>1;)if(r=e+(o-e>>1),t[r]<n)e=r;else{if(!(t[r]>n))return r;o=r}return e<t.length-1?Math.abs(n-t[e])<Math.abs(t[e+1]-n)?e:e+1:e}function xGetFromToIndex(t,n={}){let{fromIndex:e,toIndex:o,from:r,to:i}=n;return void 0===e&&(e=void 0!==r?xFindClosestIndex(t,r):0),void 0===o&&(o=void 0!==i?xFindClosestIndex(t,i):t.length-1),e>o&&([e,o]=[o,e]),{fromIndex:e,toIndex:o}}function _typeof(t){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function sequentialFill(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"!==_typeof(t)||isAnyArray(t)||(n=t,t=[]),!isAnyArray(t))throw new TypeError("input must be an array");var e=n,o=e.from,r=void 0===o?0:o,i=e.to,a=void 0===i?10:i,s=e.size,u=void 0===s?t.length:s,f=e.step;if(0!==u&&f)throw new Error("step is defined by the array size");if(u||(u=f?Math.floor((a-r)/f)+1:a-r+1),!f&&u&&(f=(a-r)/(u-1)),Array.isArray(t)){t.length=0;for(var l=0;l<u;l++)t.push(r),r+=f}else{if(t.length!==u)throw new Error("sequentialFill typed array must have the correct length");for(var c=0;c<u;c++)t[c]=r,r+=f}return t}var d3Array={exports:{}};!function(t,n){!function(t){function n(t,n){return t<n?-1:t>n?1:t>=n?0:NaN}function e(t){return 1===t.length&&(t=o(t)),{left:function(n,e,o,r){for(null==o&&(o=0),null==r&&(r=n.length);o<r;){var i=o+r>>>1;t(n[i],e)<0?o=i+1:r=i}return o},right:function(n,e,o,r){for(null==o&&(o=0),null==r&&(r=n.length);o<r;){var i=o+r>>>1;t(n[i],e)>0?r=i:o=i+1}return o}}}function o(t){return function(e,o){return n(t(e),o)}}var r=e(n),i=r.right,a=r.left;function s(t,n){return n<t?-1:n>t?1:n>=t?0:NaN}function u(t){return null===t?NaN:+t}function f(t,n){var e,o,r=t.length,i=0,a=0,s=-1,f=0;if(null==n)for(;++s<r;)isNaN(e=u(t[s]))||(a+=(o=e-i)*(e-(i+=o/++f)));else for(;++s<r;)isNaN(e=u(n(t[s],s,t)))||(a+=(o=e-i)*(e-(i+=o/++f)));if(f>1)return a/(f-1)}function l(t,n){var e=f(t,n);return e?Math.sqrt(e):e}function c(t,n){var e,o,r,i=-1,a=t.length;if(null==n){for(;++i<a;)if(null!=(o=t[i])&&o>=o){e=r=o;break}for(;++i<a;)null!=(o=t[i])&&(e>o&&(e=o),r<o&&(r=o))}else{for(;++i<a;)if(null!=(o=n(t[i],i,t))&&o>=o){e=r=o;break}for(;++i<a;)null!=(o=n(t[i],i,t))&&(e>o&&(e=o),r<o&&(r=o))}return[e,r]}function h(t){return function(){return t}}function w(t){return t}function g(t,n,e){t=+t,n=+n,e=(r=arguments.length)<2?(n=t,t=0,1):r<3?1:+e;for(var o=-1,r=0|Math.max(0,Math.ceil((n-t)/e)),i=new Array(r);++o<r;)i[o]=t+o*e;return i}var m=Math.sqrt(50),d=Math.sqrt(10),p=Math.sqrt(2);function G(t,n,e){var o=b(t,n,e);return g(Math.ceil(t/o)*o,Math.floor(n/o)*o+o/2,o)}function b(t,n,e){var o=Math.abs(n-t)/Math.max(0,e),r=Math.pow(10,Math.floor(Math.log(o)/Math.LN10)),i=o/r;return i>=m?r*=10:i>=d?r*=5:i>=p&&(r*=2),n<t?-r:r}function y(t){return Math.ceil(Math.log(t.length)/Math.LN2)+1}function j(t){return+t}function N(){var t=w,n=c,e=y;function o(o){var r,a,s=o.length,u=new Array(s);for(r=0;r<s;++r)u[r]=+t(o[r],r,o);var f=n(u),l=+f[0],c=+f[1],h=e(u,l,c);Array.isArray(h)||(h=G(l,c,+h));var w=h.length;for(r=0;r<w;++r)h[r]=+h[r];for(;h[0]<=l;)h.shift(),--w;for(;h[w-1]>=c;)h.pop(),--w;var g,m=new Array(w+1);for(r=0;r<=w;++r)(g=m[r]=[]).x0=r>0?h[r-1]:l,g.x1=r<w?h[r]:c;for(r=0;r<s;++r)l<=(a=u[r])&&a<=c&&m[i(h,a,0,w)].push(o[r]);return m}return o.value=function(n){return arguments.length?(t="function"==typeof n?n:h(+n),o):t},o.domain=function(t){return arguments.length?(n="function"==typeof t?t:h([+t[0],+t[1]]),o):n},o.thresholds=function(t){return arguments.length?(e="function"==typeof t?t:Array.isArray(t)?h(Array.prototype.map.call(t,j)):h(+t),o):e},o}function H(t,n,e){if(null==e&&(e=u),o=t.length){if((n=+n)<=0||o<2)return+e(t[0],0,t);if(n>=1)return+e(t[o-1],o-1,t);var o,r=(o-1)*n,i=Math.floor(r),a=+e(t[i],i,t);return a+(+e(t[i+1],i+1,t)-a)*(r-i)}}function v(t,e,o){return t.sort(n),Math.ceil((o-e)/(2*(H(t,.75)-H(t,.25))*Math.pow(t.length,-1/3)))}function M(t,n,e){return Math.ceil((e-n)/(3.5*l(t)*Math.pow(t.length,-1/3)))}function A(t,n){var e,o,r=-1,i=t.length;if(null==n){for(;++r<i;)if(null!=(o=t[r])&&o>=o){e=o;break}for(;++r<i;)null!=(o=t[r])&&o>e&&(e=o)}else{for(;++r<i;)if(null!=(o=n(t[r],r,t))&&o>=o){e=o;break}for(;++r<i;)null!=(o=n(t[r],r,t))&&o>e&&(e=o)}return e}function S(t,n){var e,o=0,r=t.length,i=-1,a=r;if(null==n)for(;++i<r;)isNaN(e=u(t[i]))?--a:o+=e;else for(;++i<r;)isNaN(e=u(n(t[i],i,t)))?--a:o+=e;if(a)return o/a}function C(t,e){var o,r=[],i=t.length,a=-1;if(null==e)for(;++a<i;)isNaN(o=u(t[a]))||r.push(o);else for(;++a<i;)isNaN(o=u(e(t[a],a,t)))||r.push(o);return H(r.sort(n),.5)}function x(t){for(var n,e,o,r=t.length,i=-1,a=0;++i<r;)a+=t[i].length;for(e=new Array(a);--r>=0;)for(n=(o=t[r]).length;--n>=0;)e[--a]=o[n];return e}function k(t,n){var e,o,r=-1,i=t.length;if(null==n){for(;++r<i;)if(null!=(o=t[r])&&o>=o){e=o;break}for(;++r<i;)null!=(o=t[r])&&e>o&&(e=o)}else{for(;++r<i;)if(null!=(o=n(t[r],r,t))&&o>=o){e=o;break}for(;++r<i;)null!=(o=n(t[r],r,t))&&e>o&&(e=o)}return e}function R(t){for(var n=0,e=t.length-1,o=t[0],r=new Array(e<0?0:e);n<e;)r[n]=[o,o=t[++n]];return r}function I(t,n){for(var e=n.length,o=new Array(e);e--;)o[e]=t[n[e]];return o}function D(t,e){if(o=t.length){var o,r,i=0,a=0,s=t[a];for(e||(e=n);++i<o;)(e(r=t[i],s)<0||0!==e(s,s))&&(s=r,a=i);return 0===e(s,s)?a:void 0}}function F(t,n,e){for(var o,r,i=(null==e?t.length:e)-(n=null==n?0:+n);i;)r=Math.random()*i--|0,o=t[i+n],t[i+n]=t[r+n],t[r+n]=o;return t}function T(t,n){var e,o=0,r=t.length,i=-1;if(null==n)for(;++i<r;)(e=+t[i])&&(o+=e);else for(;++i<r;)(e=+n(t[i],i,t))&&(o+=e);return o}function B(t){if(!(r=t.length))return[];for(var n=-1,e=k(t,$),o=new Array(e);++n<e;)for(var r,i=-1,a=o[n]=new Array(r);++i<r;)a[i]=t[i][n];return o}function $(t){return t.length}function P(){return B(arguments)}var K="0.7.1";t.version=K,t.bisect=i,t.bisectRight=i,t.bisectLeft=a,t.ascending=n,t.bisector=e,t.descending=s,t.deviation=l,t.extent=c,t.histogram=N,t.thresholdFreedmanDiaconis=v,t.thresholdScott=M,t.thresholdSturges=y,t.max=A,t.mean=S,t.median=C,t.merge=x,t.min=k,t.pairs=R,t.permute=I,t.quantile=H,t.range=g,t.scan=D,t.shuffle=F,t.sum=T,t.ticks=G,t.tickStep=b,t.transpose=B,t.variance=f,t.zip=P}(n)}(0,d3Array.exports);const{bisectRight:bisectRight}=d3Array.exports,quincunx=(t,n,e,o)=>{const r=t.length-1;t[0]=0,n[0]=0,e[0]=0,n[1]=n[1]/t[1],e[1]=e[1]/t[1];for(let o=2;o<r;++o)t[o]=t[o]-t[o-2]*e[o-2]*e[o-2]-t[o-1]*n[o-1]*n[o-1],n[o]=(n[o]-t[o-1]*n[o-1]*e[o-1])/t[o],e[o]=e[o]/t[o];for(let t=2;t<r;++t)o[t]=o[t]-n[t-1]*o[t-1]-e[t-2]*o[t-2];for(let n=1;n<r;++n)o[n]=o[n]/t[n];o[r-2]=o[r-2]-n[r-2]*o[r-1];for(let t=r-3;t>0;--t)o[t]=o[t]-n[t]*o[t+1]-e[t]*o[t+2]},smoothingSpline=(t,n,e,o)=>{const r=t.length-1,i=new Array(r+1),a=new Array(r+1),s=new Array(r+1),u=new Array(r+1),f=new Array(r+1),l=new Array(r+1),c=new Array(r+1),h=new Array(r+1),w=t.map((()=>[0,0,0,0]));w.pop();const g=2*(1-o)/(3*o);for(let n=0;n<r;++n)i[n]=t[n+1]-t[n],a[n]=3/i[n];f[0]=0;for(let e=1;e<r;++e)s[e]=-(a[e-1]+a[e]),u[e]=2*(t[e+1]-t[e-1]),f[e]=3*(n[e+1]-n[e])/i[e]-3*(n[e]-n[e-1])/i[e-1];f[r]=0;for(let t=1;t<r;++t)l[t]=a[t-1]*a[t-1]*e[t-1]+s[t]*s[t]*e[t]+a[t]*a[t]*e[t+1],l[t]=g*l[t]+u[t];for(let t=1;t<r-1;++t)c[t]=s[t]*a[t]*e[t]+a[t]*s[t+1]*e[t+1],c[t]=g*c[t]+i[t];for(let t=1;t<r-2;++t)h[t]=g*a[t]*a[t+1]*e[t+1];quincunx(l,c,h,f),w[0][3]=n[0]-g*a[0]*f[1]*e[0],w[1][3]=n[1]-g*(s[1]*f[1]+a[1]*f[2])*e[0],w[0][0]=f[1]/(3*i[0]),w[0][1]=0,w[0][2]=(w[1][3]-w[0][3])/i[0]-f[1]*i[0]/3,a[0]=0;for(let t=1;t<r;++t)w[t][0]=(f[t+1]-f[t])/(3*i[t]),w[t][1]=f[t],w[t][2]=(f[t]+f[t-1])*i[t-1]+w[t-1][2],w[t][3]=a[t-1]*f[t-1]+s[t]*f[t]+a[t]*f[t+1],w[t][3]=n[t]-g*w[t][3]*e[t];return w};class SplineInterpolator{constructor(t,n,e=1){const o=t.map(((t,n)=>n));o.sort(((n,e)=>t[n]-t[e]));const r=o.map((n=>t[n])),i=o.map((t=>n[t])),a=o.length,s=o.map((()=>1));this.n=a,this.x=r,this.y=i,this.params=smoothingSpline(r,i,s,e)}interpolate(t){if(t===this.x[this.n-1])return this.y[this.n-1];const n=Math.min(Math.max(0,bisectRight(this.x,t)-1),this.n-2),[e,o,r,i]=this.params[n];return e*(t-=this.x[n])*t*t+o*t*t+r*t+i}max(t=100){const n=this.x[0],e=(this.x[this.n-1]-n)/t;let o=-1/0;for(let r=0,i=n;r<t;++r,i+=e){const t=this.interpolate(i);t>o&&(o=t)}return o}min(t=100){const n=this.x[0],e=(this.x[this.n-1]-n)/t;let o=1/0;for(let r=0,i=n;r<t;++r,i+=e){const t=this.interpolate(i);t<o&&(o=t)}return o}domain(){return[this.x[0],this.x[this.x.length-1]]}range(){return[this.min(),this.max()]}curve(t,n=null){const e=((n=n||this.domain())[1]-n[0])/(t-1),o=new Array(t);for(let r=0;r<t;++r){const t=e*r+n[0];o[r]=[t,this.interpolate(t)]}return o}}var splineInterpolator=SplineInterpolator;const Y1=.08913147449493408,P1=[-.005387729650712429,.008226878746769157,.02198786811111689,-.03656379714117627,-.012692614766297404,.03348066254097446,-.008368748197417368,-.0005087819496582806],Q1=[.0008862163904564247,-.0023339375937419,.07952836873415717,-.05273963823400997,-.7122890234154284,.662328840472003,1.5622155839842302,-1.5657455823417585,-.9700050433032906,1],Y2=2.249481201171875,P2=[-3.6719225470772936,21.12946554483405,17.445385985570866,-44.6382324441787,-18.851064805871424,17.644729840837403,8.3705032834312,.10526468069939171,-.20243350835593876],Q2=[1.7211476576120028,-22.643693341313973,10.826866735546016,48.560921310873994,-20.14326346804852,-28.66081804998,3.971343795334387,6.242641248542475,1],Y3=.807220458984375,P3=[-6.81149956853777e-10,2.8522533178221704e-8,-6.794655751811263e-7,.0021455899538880526,.029015791000532906,.14286953440815717,.3377855389120359,.38707973897260434,.11703015634199525,-.16379404719331705,-.1311027816799519],Q3=[.011059242293464892,.15226433829533179,.848854343457902,2.5930192162362027,4.778465929458438,5.381683457070069,3.4662540724256723,1],Y4=.9399557113647461,P4=[26633922742578204e-28,-2.304047769118826e-10,460469890584318e-20,.00015754461742496055,.0018712349281955923,.009508047013259196,.018557330651423107,-.0022242652921344794,-.0350353787183178],Q4=[7646752923027944e-20,.00263861676657016,.03415891436709477,.22009110576413124,.7620591645536234,1.3653349817554064,1],Y5=.9836282730102539,P5=[9905570997331033e-32,-2811287356288318e-29,4.625961635228786e-9,4.4969678992770644e-7,14962478375834237e-21,.00020938631748758808,.001056288621524929,-.0011295143874558028,-.016743100507663373],Q5=[2.82243172016108e-7,27533547476472603e-21,.0009640118070051656,.016074608709367652,.1381518657490833,.5914293448864175,1];function polyval(t,n){let e=0;for(const o of t)e=e*n+o;return e}function calc(t,n,e,o,r){const i=t-n;return r*t+polyval(e,i)/polyval(o,i)*t}function erfcinv(t){let n,e,o,r,i=!1;if(Number.isNaN(t))return NaN;if(t<0||t>2)throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${t}\`.`);return 0===t?Number.POSITIVE_INFINITY:2===t?Number.NEGATIVE_INFINITY:1===t?0:(t>1?(e=2-t,t=1-e,i=!0):(e=t,t=1-t),t<=.5?(o=t*(t+10),r=polyval(P1,t)/polyval(Q1,t),n=o*Y1+o*r,i?-n:n):e>=.25?(o=Math.sqrt(-2*Math.log(e)),e-=.25,r=polyval(P2,e)/polyval(Q2,e),n=o/(Y2+r),i?-n:n):(e=Math.sqrt(-Math.log(e)),e<3?calc(e,1.125,P3,Q3,Y3):e<6?calc(e,3,P4,Q4,Y4):calc(e,6,P5,Q5,Y5)))}function rayleighCdf(t,n=1){return t<0?0:-Math.expm1(-Math.pow(t,2)/(2*Math.pow(n,2)))}function xNoiseSanPlot(t,n={}){const{mask:e,cutOff:o,refine:r=!0,magnitudeMode:i=!1,scaleFactor:a=1,factorStd:s=5,fixOffset:u=!0}=n;let f;if(f=Array.isArray(e)&&e.length===t.length?new Float64Array(t.filter(((t,n)=>!e[n]))):new Float64Array(t),a>1)for(let t=0;t<f.length;t++)f[t]*=a;if(f=f.sort().reverse(),u&&!i){let t=Math.floor(f.length/2),n=.5*(f[t]+f[t+1]);for(let t=0;t<f.length;t++)f[t]-=n}let l=f[f.length-1]>=0?f.length:f.findIndex((t=>t<0)),c=l-1;for(let t=c;t>=0;t--)if(f[t]>0){c=t;break}let h,w=f.slice(0,c+1),g=f.slice(l),m=o||determineCutOff(w,{magnitudeMode:i}),d=w[Math.floor(w.length*m)],p=w[0];if(g.length>0){h=-1*g[Math.floor(g.length*(1-m))]}else h=0;let G=d,b=h,y=w.slice(),j=g.slice(),N=0,H=2;if(r){let t=G*s;N=w.findIndex((n=>n<t)),N>-1&&(y=w.slice(N),G=y[Math.floor(y.length*m)]),t=b*s,H=g.findIndex((n=>n<t)),H>-1&&(j=g.slice(H),b=y[Math.floor(j.length*(1-m))])}let v,M,A=-simpleNormInv(m/2,{magnitudeMode:i});return d/=A,h/=A,r&&N>-1?(v=(m*y.length+N)/(y.length+N),M=-1*simpleNormInv(v/2,{magnitudeMode:i}),G/=M,H>-1&&(v=(m*j.length+H)/(j.length+H),M=-1*simpleNormInv(v/2,{magnitudeMode:i}),0!==b&&(b/=M))):(G/=A,b/=A),{positive:G,negative:b,snr:p/G,sanplot:generateSanPlot(f,{fromTo:{positive:{from:0,to:c},negative:{from:l,to:f.length}}})}}function determineCutOff(t,n={}){let{magnitudeMode:e=!1,considerList:o={from:.5,step:.1,to:.9}}=n,r=[],i=t.length-1;for(let n=.01;n<=.99;n+=.01){let o=-t[Math.round(i*n)]/simpleNormInv([n/2],{magnitudeMode:e});r.push([n,o])}let a=Number.MAX_SAFE_INTEGER,{from:s,to:u,step:f}=o,l=f/2,c=.5;for(let t=s;t<=u;t+=f){let n=t-l,e=t+l,o=r.filter((t=>t[0]<e&&t[0]>n)),i=o.reduce(((t,n)=>t+Math.abs(n[1])),0),s=0;for(let t=0;t<o.length;t++)s+=Math.pow(o[t][1]-i,2);s<a&&(a=s,c=t)}return c}function simpleNormInv(t,n={}){const{magnitudeMode:e=!1}=n;Array.isArray(t)||(t=[t]);let o=createArray(0,2,.01),r=new Float64Array(t.length),i=new Float64Array(o.length);if(e){let n=1;for(let t=0;t<i.length;t++){let e=o[t]*n;i[t]=1-rayleighCdf(e)}let e=new splineInterpolator(o,i);for(let n=0;n<r.length;n++){let o=2*t[n];r[n]=-1*e.interpolate(o)}}else for(let n=0;n<r.length;n++)r[n]=-1*Math.SQRT2*erfcinv(2*t[n]);return 1===r.length?r[0]:r}function createArray(t,n,e){let o=new Array(Math.abs((t-n)/e+1));for(let n=0;n<o.length;n++)o[n]=t+n*e;return o}function generateSanPlot(t,n={}){const{fromTo:e,logBaseY:o=2}=n;let r={};for(let n in e){let{from:i,to:a}=e[n];r[n]=i!==a?scale(t.slice(i,a),{logBaseY:o}):{x:[],y:[]},"negative"===n&&r[n].y.reverse()}return r}function scale(t,n={}){const{log10:e,abs:o}=Math,{logBaseY:r}=n;if(r){t=t.slice();const n=e(r);for(let r=0;r<t.length;r++)t[r]=e(o(t[r]))/n}return{x:sequentialFill({from:0,to:t.length-1,size:t.length}),y:t}}function sum(t){if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");for(var n=0,e=0;e<t.length;e++)n+=t[e];return n}function mean(t){return sum(t)/t.length}function xyCheck(t={}){if(!isAnyArray(t.x)||!isAnyArray(t.y))throw new Error("Data must be an object of x and y arrays");if(t.x.length!==t.y.length)throw new Error("The x and y arrays mush have the same length")}function zonesNormalize(t=[],n={}){if(0===t.length)return[];t=JSON.parse(JSON.stringify(t)).map((t=>t.from>t.to?{from:t.to,to:t.from}:t));let{from:e=Number.NEGATIVE_INFINITY,to:o=Number.POSITIVE_INFINITY}=n;if(e>o&&([e,o]=[o,e]),(t=t.sort(((t,n)=>t.from!==n.from?t.from-n.from:t.to-n.to))).forEach((t=>{e>t.from&&(t.from=e),o<t.to&&(t.to=o)})),0===(t=t.filter((t=>t.from<=t.to))).length)return[];let r=t[0],i=[r];for(let n of t)n.from<=r.to?r.to=n.to:(r=n,i.push(r));return i}function xyExtract(t={},n={}){xyCheck(t);const{x:e,y:o}=t;let{zones:r}=n;if(r=zonesNormalize(r),!Array.isArray(r)||0===r.length)return t;let i=[],a=[],s=r[0],u=0;t:for(let t=0;t<e.length;t++){for(;s.to<e[t];)if(u++,s=r[u],!s){t=e.length;break t}e[t]>=s.from&&(i.push(e[t]),a.push(o[t]))}return{x:i,y:a}}function xyIntegration(t={},n={}){xyCheck(t);const{x:e,y:o}=t;if(e.length<2)return 0;const{fromIndex:r,toIndex:i}=xGetFromToIndex(e,n);let a=0;for(let t=r;t<i;t++)a+=(e[t+1]-e[t])*(o[t+1]+o[t])/2;return a}function groupPeaks(t,n=1){if(0===t.length)return[];let e=t.sort(((t,n)=>t.x-n.x)),o={x:Number.NEGATIVE_INFINITY,width:1},r=[o],i=[];for(let t of e)(t.x-o.x)/(t.width+o.width)<=n/2?r.push(t):(r=[t],i.push(r)),t.group=i.length-1,o=t;return i}function optimizePeaks(t,n,e={}){const{factorWidth:o=1,factorLimits:r=2,shape:i={kind:"gaussian"},optimization:a={kind:"lm",options:{timeout:10}}}=e;t.x[0]>t.x[1]&&(t.x.reverse(),t.y.reverse());let s=groupPeaks(n,o),u=[];for(const n of s){const e=n[0],o=n[n.length-1],s=e.x-e.width*r,f=o.x+o.width*r,{fromIndex:l,toIndex:c}=xGetFromToIndex(t.x,{from:s,to:f}),h={x:t.x.slice(l,c),y:t.y.slice(l,c)};if(h.x.length>5){let{peaks:t}=optimize(h,n,{shape:i,optimization:a});u=u.concat(t)}else u=u.concat(n)}return u}function joinBroadPeaks(t,n={}){let{width:e=.25,shape:o={kind:"gaussian"},optimization:r={kind:"lm",timeout:10}}=n,i=[],a=0,s=0,u=1;for(let n=t.length-1;n>=0;n--)t[n].soft&&i.push(t.splice(n,1)[0]);i.push({x:Number.MAX_VALUE});let f={x:[i[0].x],y:[i[0].y]},l=[0];for(let n=1;n<i.length;n++)if(Math.abs(i[n-1].x-i[n].x)<e)f.x.push(i[n].x),f.y.push(i[n].y),i[n].y>a&&(a=i[n].y,s=n),l.push(n),u++;else{if(u>2){let n=optimize(f,[{x:i[s].x,y:a,width:Math.abs(f.x[0]-f.x[f.x.length-1])}],{shape:o,optimization:r}),{peaks:e}=n;e[0].index=Math.floor(l.reduce(((t,n)=>t+n),0)/l.length),e[0].soft=!1,t.push(e[0])}else l.forEach((n=>{t.push(i[n])}));f={x:[i[n].x],y:[i[n].y]},l=[n],a=i[n].y,s=n,u=1}return t.sort((function(t,n){return t.x-n.x})),t}function xyAutoPeaksPicking(t,n={}){const{from:e,to:o,noiseLevel:r,thresholdFactor:i=3,minMaxRatio:a=.05,broadRatio:s=25e-5,useSanPlot:u=!1,smoothY:f=!0,optimize:l=!1,factorWidth:c=4,realTopDetection:h=!0,shape:w={kind:"gaussian"},optimization:g={kind:"lm"},broadWidth:m=.25,lookNegative:d=!1,sgOptions:p={windowSize:9,polynomial:3}}=n;void 0!==e&&void 0!==o&&(t=xyExtract(t,[{from:e,to:o}]));const G=getCutOff(t.y,{noiseLevel:r,useSanPlot:u,thresholdFactor:i});let b={shape:w,broadWidth:m,optimize:l,factorWidth:c,sgOptions:p,minMaxRatio:a,broadRatio:s,noiseLevel:G.positive,smoothY:f,optimization:g,realTopDetection:h},y=getPeakList(t,b);return d&&(b.noiseLevel=G.negative,y.push(...getNegativePeaks(t,b))),y}function getPeakList(t,n){const{shape:e,broadWidth:o,optimize:r,factorWidth:i,sgOptions:a,minMaxRatio:s,broadRatio:u,noiseLevel:f,smoothY:l,optimization:c,realTopDetection:h}=n;let w=gsd(t,{sgOptions:a,minMaxRatio:s,broadRatio:u,noiseLevel:f,smoothY:l,realTopDetection:h});return o&&(w=joinBroadPeaks(w,{width:o,shape:e,optimization:c})),r&&(w=optimizePeaks(t,w,{shape:e,factorWidth:i,optimization:c})),w}function getNegativePeaks(t,n){let{x:e,y:o}=t,r=new Float64Array(t.y.length);for(let t=0;t<r.length;t++)r[t]=-1*o[t];let i=getPeakList({x:e,y:r},n);for(let t=0;t<i.length;t++)i[t].y*=-1;return i}function getCutOff(t,n={}){const{noiseLevel:e,useSanPlot:o,thresholdFactor:r}=n,i=t=>"number"==typeof t?{positive:t,negative:-t}:t;return e?i(e):o?xNoiseSanPlot(t,{factorStd:r}):i(xAbsoluteMedian(t)*r)}const patterns=["s","d","t","q","quint","h","sept","o","n"];let symRatio=1.5,maxErrorIter1=2.5,maxErrorIter2=1,jAxisKeys={jAxis:"x",intensity:"intensity"};var jAnalyzer={compilePattern:function(t,n={}){let{jAxisKey:e=jAxisKeys}=n;if(t.multiplicity="m",t.symRank=symmetrizeChoiseBest(t,{maxError:maxErrorIter1,iteration:1,jAxisKey:e}),t.asymmetric=!0,t.symRank>=.95&&t.peaksComp.length<32){let n,e,o;t.asymmetric=!1;let r=1,i=[];for(let a=0;a<9;a++){let s=normalize(t,a),u=!1;if(1===s.length&&0===a)u=!0;else if(s.length<=1)continue;let f=getRanges(s);e=Math.pow(2,a);let l=null,c=1;for(;!u&&null!==(l=getNextCombination(f,e))&&c<400;){let t=new Array(l.length);r=1;for(let n=0;n<l.length;n++){t[n]=new Array(l[n]);for(let e=0;e<l[n];e++)t[n][e]=r++}i=[];let e=1;i.push(s[1].x-s[0].x),n=s[0].x,t[0].splice(0,1),t[1].splice(0,1),r=1;let f=2;for(o=Math.pow(2,a)-1;i.length<a&&f<o&&r<s.length;){for(c+=1,e++;r<s.length&&0===t[r].length;)r++;if(r<s.length){i.push(s[r].x-s[0].x),t[r].splice(0,1),f++;for(let o=2;o<=e;o++){let e=0;for(let t=0;t<o;t++)e+=i[t];for(let o=1;o<t.length;o++)if(Math.abs(s[o].x-(n+e))<.25){t[o].splice(0,1),f++;break}}}}let h=idealPattern(i);u=!0;for(let t=0;t<h.length;t++)h[t].intensity!==l[t]&&(u=!1)}u&&updateSignal(t,i)}}for(let n=0;n<t.peaksComp.length;n++)t.peaksComp[n].x/=t.observe}};function updateSignal(t,n){let e=t.peaksComp,o=e.length;t.startX=e[0].x/t.observe-e[0].width,t.stopX=e[o-1].x/t.observe+e[o-1].width,t.integralData.from=e[0].x/t.observe-3*e[0].width,t.integralData.to=e[o-1].x/t.observe+3*e[o-1].width,t.maskPattern=t.mask2,t.multiplicity=abstractPattern(t,n),t.pattern=t.multiplicity}function abstractPattern(t,n){let e="",o=1,r=[];if(n&&n.length>0){n.sort((function(t,n){return n-t}));for(let t=0;t<n.length-1;t++)Math.abs(n[t]-n[t+1])<.05?o++:(r.push({coupling:Math.abs(n[t]),multiplicity:patterns[o]}),e+=patterns[o],o=1);let i=n.length-1;r.push({coupling:Math.abs(n[i]),multiplicity:patterns[o]}),e+=patterns[o],t.nmrJs=r}else e="s",Math.abs(t.startX-t.stopX)*t.observe>16&&(e="br s");return e}function idealPattern(t){let n=[{x:0,intensity:Math.pow(2,t.length)}];for(let e=0;e<t.length;e++)for(let o=n.length-1;o>=0;o--)n.push({x:n[o].x+t[e]/2,intensity:n[o].intensity/2}),n[o].x=n[o].x-t[e]/2,n[o].intensity=n[o].intensity/2;n.sort((function(t,n){return t.x-n.x}));for(let t=n.length-2;t>=0;t--)Math.abs(n[t].x-n[t+1].x)<.1&&(n[t].intensity+=n[t+1].intensity,n.splice(t+1,1));return n}function getNextCombination(t,n){let e,o=Math.ceil(.5*t.values.length),r=t.values.length,i=0;for(;i!==n;){for(e=!1;!e;)if(e=!0,t.currentIndex[t.active]++,t.currentIndex[t.active]>=t.values[t.active].length){if(t.active+1===o)return null;t.currentIndex[t.active]=0,e=!1,t.active++}else t.active=0;i=0;for(let n=0;n<o;n++)i+=2*t.values[n][t.currentIndex[n]];t.values.length%2!=0&&(i-=t.values[o-1][t.currentIndex[o-1]])}if(i===n){let n=new Array(r);for(let e=0;e<o;e++)n[e]=t.values[e][t.currentIndex[e]],n[r-e-1]=t.values[e][t.currentIndex[e]];return n}return null}function getRanges(t){let n,e,o=new Array(t.length),r=new Array(t.length);o[0]=[1],o[t.length-1]=[1],r[0]=-1,r[t.length-1]=0;for(let i=1;i<t.length-1;i++){n=Math.round(.85*t[i].intensity),e=Math.round(1.15*t[i].intensity),o[i]=[];for(let t=n;t<=e;t++)o[i].push(t);r[i]=0}return{values:o,currentIndex:r,active:0}}function symmetrizeChoiseBest(t,n={}){let{maxError:e,iteration:o,jAxisKey:r=jAxisKeys}=n,i=symmetrize(t,e,o,r),a=t.peaksComp,s=t.mask,u=t.delta1;t.delta1=(t.peaks[0].x+t.peaks[t.peaks.length-1].x)/2;let f=symmetrize(t,e,o,r);return t.peaksComp.length>a.length?f:(t.delta1=u,t.peaksComp=a,t.mask=s,i)}function symmetrize(t,n,e,o){let r,i,a,s,u,{jAxis:f,intensity:l}=o,c=new Array(t.peaks.length);for(let n=0;n<c.length;n++)c[n]={x:t.peaks[n][f]*t.observe,intensity:t.peaks[n][l],width:t.peaks[n].width};for(let t=c.length-2;t>=0;t--)Math.abs(c[t].x-c[t+1].x)<.25&&(c[t].x=c[t].x*c[t].intensity+c[t+1].x*c[t+1].intensity,c[t].intensity=c[t].intensity+c[t+1].intensity,c[t].x/=c[t].intensity,c[t].intensity/=2,c[t].width+=c[t+1].width,c.splice(t+1,1));t.peaksComp=c;let h=c.length,w=new Array(h);t.mask=w;let g=0,m=c.length-1,d=t.delta1*t.observe,p=[(c[0].x+c[h-1].x)/2,1];n=error(Math.abs(d-p[0]));let G=0;for(let t=0;t<h;t++)w[t]=!0,G+=c[t].intensity;for(;g<=m;){if(w[g]=!0,w[m]=!0,g===m)h>2&&Math.abs(c[g].x-d)>n&&(w[g]=!1);else if(r=Math.max(c[g].intensity,c[m].intensity),i=Math.min(c[g].intensity,c[m].intensity),s=r/i,s>symRatio)c[g].intensity===i?(w[g]=!1,m++):(w[m]=!1,g--);else{let t=Math.abs(c[g].x-d),e=Math.abs(c[m].x-d);Math.abs(t-e)<n?(a=Math.min(c[g].intensity,c[m].intensity),u=Math.min(c[g].width,c[m].width),c[g].intensity=c[m].intensity=a,c[g].width=c[m].width=u,p=[p[0]+(c[m].x+c[g].x)/2,p[1]+1]):Math.max(t,e)===e?(w[m]=!1,g--):(w[g]=!1,m++)}if(g++,m--,1===e&&(d=chemicalShift(c,w),isNaN(d)))return 0;n=error(Math.abs(d-p[0]/p[1]))}for(let t=h-1;t>=0;t--)!1===w[t]&&c.splice(t,1);if(d=chemicalShift(c),isNaN(d))return 0;t.delta1=d/t.observe;let b=0,y=0;if(c.length>1){for(let t=Math.ceil(c.length/2)-1;t>=0;t--)b+=(3+Math.min(Math.abs(c[t].x-d),Math.abs(c[c.length-1-t].x-d)))/(3+Math.max(Math.abs(c[t].x-d),Math.abs(c[c.length-1-t].x-d)))*c[t].intensity,y+=c[t].intensity;b/=y}else 1===c.length&&(b=1);let j=0;for(let t=0;t<c.length;t++)j+=c[t].intensity;if(b-=(G-j)/G*.12,b>.8&&b<.97&&e<2)return symmetrize(t,maxErrorIter2,2,o);if(c.length>1){let t;for(let n=Math.ceil(c.length/2)-1;n>=0;n--)t=(c[n].x-c[c.length-1-n].x)/2,c[n].x=d+t,c[c.length-1-n].x=d-t}return b}function error(t){let n=2.5*t;return n<.75&&(n=.75),n>3&&(n=3),n}function normalize(t,n){let e=JSON.parse(JSON.stringify(t.peaksComp)),o=0,r=0;for(let t=0;t<e.length;t++)o+=e[t].intensity;o=Math.pow(2,n)/o,t.mask2=JSON.parse(JSON.stringify(t.mask));let i=t.mask2.length-1;for(let n=e.length-1;n>=0;n--){for(e[n].intensity*=o;i>=0&&!1===t.mask2[i];)i--;e[n].intensity<.75?(e.splice(n,1),t.mask2[i]=!1):r+=e[n].intensity,i--}r=Math.pow(2,n)/r;for(let t=e.length-1;t>=0;t--)e[t].intensity*=r;return e}function chemicalShift(t,n){let e,o=0,r=0;if(n)for(let i=0;i<t.length;i++)!0===n[i]&&(e=getArea(t[i]),o+=e,r+=e*t[i].x);else for(let n=0;n<t.length;n++)e=getArea(t[n]),o+=e,r+=e*t[n].x;return r/o}function getArea(t){return Math.abs(t.intensity*t.width*1.57)}function joinRanges(t){t.sort(((t,n)=>t.from-n.from));for(let n=0;n<t.length-1;n++)t[n].to>t[n+1].from&&(t[n].to=Math.max(t[n+1].to,t[n].to),t[n].signal=t[n].signal.concat(t[n+1].signal),t[n].integral+=t[n+1].integral,t.splice(n+1,1),n--);return t}function peaksToRanges(t,n,e={}){let{integrationSum:o=100,joinOverlapRanges:r=!0,clean:i=.4,compile:a=!0,integralType:s="sum",frequency:u=400,frequencyCluster:f=16,keepPeaks:l=!1,nucleus:c="1H"}=e,h={integrationSum:o,integralType:s,frequencyCluster:f,frequency:u,nucleus:c};t.x[0]>t.x[1]&&(t.x=t.x.reverse(),t.y=t.y.reverse());let w=detectSignals(t,n,h);if(i)for(let t=0;t<w.length;t++)Math.abs(w[t].integralData.value)<i&&w.splice(t,1);if(a){let n,e;for(let o=0;o<w.length;o++)if(jAnalyzer.compilePattern(w[o]),w[o].maskPattern&&"m"!==w[o].multiplicity&&""!==w[o].multiplicity){n=0,e=0;let r=[];for(let t=w[o].maskPattern.length-1;t>=0;t--)if(e+=computeArea(w[o].peaks[t]),!1===w[o].maskPattern[t]){let e=w[o].peaks.splice(t,1)[0];r.push({x:e.x,y:e.intensity,width:e.width}),w[o].mask.splice(t,1),w[o].mask2.splice(t,1),w[o].maskPattern.splice(t,1),w[o].nbPeaks--,n+=computeArea(e)}if(r.length>0){n=n*w[o].integralData.value/e,w[o].integralData.value-=n;let i=[];for(let t=r.length-1;t>=0;t--)i.push(r[t]);h.integrationSum=Math.abs(n);let a=detectSignals(t,i,h);for(let t=0;t<a.length;t++)w.push(a[t])}}let r=0,i=0;for(let t=0;t<w.length;t++)i+=Math.abs(Math.round(w[t].integralData.value));if(i!==o){r=o/i;for(let t=0;t<w.length;t++)w[t].integralData.value*=r}}if(w.sort(((t,n)=>n.delta1-t.delta1)),i)for(let t=w.length-1;t>=0;t--)Math.abs(w[t].integralData.value)<i&&w.splice(t,1);let g=[];for(let t=0;t<w.length;t++){let n=w[t];g[t]={from:n.integralData.from,to:n.integralData.to,integral:n.integralData.value,signal:[{kind:n.kind||"signal",multiplicity:n.multiplicity}]},l&&(g[t].signal[0].peak=n.peaks),n.nmrJs&&(g[t].signal[0].j=n.nmrJs),n.asymmetric&&"m"!==n.multiplicity||(g[t].signal[0].delta=n.delta1)}return r&&(g=joinRanges(g)),g}function detectSignals(t,n,e={}){let o,r,{integrationSum:i=100,integralType:a="sum",frequencyCluster:s=16,frequency:u=400,nucleus:f="1H"}=e,l=[],c={x:1e5},h=0;s/=u;for(let t=0;t<n.length;t++){if(Math.abs(n[t].x-c.x)>s)o={nbPeaks:1,units:"PPM",startX:n[t].x-n[t].width,stopX:n[t].x+n[t].width,multiplicity:"",pattern:"",observe:u,nucleus:f,integralData:{from:n[t].x-3*n[t].width,to:n[t].x+3*n[t].width},peaks:[{x:n[t].x,intensity:n[t].y,width:n[t].width}]},n[t].kind&&(o.kind=n[t].kind),l.push(o);else{let e=n[t].x+n[t].width;o.stopX=Math.max(o.stopX,e),o.startX=Math.min(o.startX,e),o.nbPeaks++,o.peaks.push({x:n[t].x,intensity:n[t].y,width:n[t].width}),o.integralData.from=Math.min(o.integralData.from,n[t].x-3*n[t].width),o.integralData.to=Math.max(o.integralData.to,n[t].x+3*n[t].width),n[t].kind&&(o.kind=n[t].kind)}c=n[t]}for(let n=0;n<l.length;n++){r=l[n].peaks;let e=l[n].integralData,o=0,i=0;for(let t=0;t<r.length;t++){let n=computeArea(r[t]);o+=r[t].x*n,i+=n}l[n].delta1=o/i,e.value="sum"===a?xyIntegration(t,{from:e.from,to:e.to}):i,h+=e.value}if(i>0){let t=i/h;for(let n=0;n<l.length;n++){l[n].integralData.value*=t}}return l}function computeArea(t){return Math.abs(t.intensity*t.width*1.57)}function xyAutoRangesPicking(t,n={}){let e=xyAutoPeaksPicking(t,n.peakPicking);return e=peaksFilterImpurities(e,n.impurities),peaksToRanges(t,e,n.ranges)}function signalsToRanges(t,n={}){const{tolerance:e=.05,frequency:o=400}=n;let r=t.map((t=>({original:t})));r.forEach((t=>{let n=(t.original.j||[]).reduce(((t,n)=>t+n.coupling/o),0)/2+e;t.from=t.original.delta-n,t.to=t.original.delta+n})),r=r.sort(((t,n)=>t.from-n.from));let i=[],a={};for(let t of r)void 0===a.from||t.from>a.to?(a={from:t.from,to:t.to,integral:t.original.nbAtoms,signal:[t.original]},i.push(a)):(a.integral+=t.original.nbAtoms,t.to>a.to&&(a.to=t.to),a.signal.push(t.original));return i}const defOptions={threshold:0,out:"assignment"};var src$1=function(t,n){const e=Object.assign({},defOptions,n);var o,r;if("number"==typeof t[0])o=fullClusterGeneratorVector(t);else if("object"==typeof t[0]){for(var i=t.length,a=new Array(i*(i+1)/2),s=0,u=0;u<i;u++)for(var f=u;f<i;f++)t[u][f]>e.threshold?a[s++]=1:a[s++]=0;o=fullClusterGeneratorVector(a)}if("indexes"===e.out||"values"===e.out){var l=new Array(o.length);for(u=0;u<o.length;u++)for(l[u]=[],f=0;f<o[u].length;f++)0!=o[u][f]&&l[u].push(f);if("values"===e.out){var c=new Array(l.length);for(u=0;u<l.length;u++)for(c[u]=new Array(l[u].length),f=0;f<l[u].length;f++)for(c[u][f]=new Array(l[u].length),r=0;r<l[u].length;r++)c[u][f][r]=t[l[u][f]][l[u][r]];return c}return l}return o};function fullClusterGeneratorVector(t){var n=Math.sqrt(2*t.length+.25)-.5,e=[],o=new Array(n),r=n,i=0,a=[];for(i=n-1;i>=0;i--)o[i]=1;for(var s=-1,u=[];r>0;){if(0===u.length){for(a=new Array(n),i=0;i<n;i++)a[i]=0;for(e.push(a),s=0;0==o[s];s++);}else s=u.splice(0,1);a[s]=1,o[s]=0,r--;var f=new Array(n);for(i=0;i<n;i++){var l=Math.max(s,i),c=Math.min(s,i);f[i]=t[c*(2*n-c-1)/2+l],1==f[i]&&1==o[i]&&0==a[i]&&(u.push(i),a[i]=1)}}return e}function signalsToSpinSystem(t){const n=t.length,e=new Array(n),o=new Array(n),r=Matrix.zeros(n,n),i={};for(let r=0;r<n;r++)o[r]=2,e[r]=t[r].delta,i[t[r].assignment]=r;for(let e=0;e<n;e++){let{assignment:n,j:o}=t[e];for(let t=0;t<o.length;t++){let{coupling:e,assignment:a}=o[t];r.set(i[n],i[a],e),r.set(i[a],i[n],e)}}const a=Matrix.ones(r.rows,r.rows);for(let t=0;t<r.rows;t++)for(let n=t;n<r.columns;n++)0===r.get(t,n)&&(a.set(t,n,0),a.set(n,t,0));return{clusters:src$1(a.to2DArray(),{out:"indexes"}),couplingConstants:r,chemicalShifts:e,multiplicity:o,connectivity:a}}var binarySearch=function(t,n,e,o,r){var i,a;if(void 0===o)o=0;else if((o|=0)<0||o>=t.length)throw new RangeError("invalid lower bound");if(void 0===r)r=t.length-1;else if((r|=0)<o||r>=t.length)throw new RangeError("invalid upper bound");for(;o<=r;)if((a=+e(t[i=o+(r-o>>>1)],n,i,t))<0)o=i+1;else{if(!(a>0))return i;r=i-1}return~o},numSort={};function assertNumber$1(t){if("number"!=typeof t)throw new TypeError("Expected a number")}var ascending=numSort.ascending=(t,n)=>(assertNumber$1(t),assertNumber$1(n),Number.isNaN(t)?-1:Number.isNaN(n)?1:t-n);numSort.descending=(t,n)=>(assertNumber$1(t),assertNumber$1(n),Number.isNaN(t)?1:Number.isNaN(n)?-1:n-t);const largestPrime=2147483647,primeNumbers=[largestPrime,5,11,23,47,97,197,397,797,1597,3203,6421,12853,25717,51437,102877,205759,411527,823117,1646237,3292489,6584983,13169977,26339969,52679969,105359939,210719881,421439783,842879579,1685759167,433,877,1759,3527,7057,14143,28289,56591,113189,226379,452759,905551,1811107,3622219,7244441,14488931,28977863,57955739,115911563,231823147,463646329,927292699,1854585413,953,1907,3821,7643,15287,30577,61169,122347,244703,489407,978821,1957651,3915341,7830701,15661423,31322867,62645741,125291483,250582987,501165979,1002331963,2004663929,1039,2081,4177,8363,16729,33461,66923,133853,267713,535481,1070981,2141977,4283963,8567929,17135863,34271747,68543509,137087021,274174111,548348231,1096696463,31,67,137,277,557,1117,2237,4481,8963,17929,35863,71741,143483,286973,573953,1147921,2295859,4591721,9183457,18366923,36733847,73467739,146935499,293871013,587742049,1175484103,599,1201,2411,4831,9677,19373,38747,77509,155027,310081,620171,1240361,2480729,4961459,9922933,19845871,39691759,79383533,158767069,317534141,635068283,1270136683,311,631,1277,2557,5119,10243,20507,41017,82037,164089,328213,656429,1312867,2625761,5251529,10503061,21006137,42012281,84024581,168049163,336098327,672196673,1344393353,3,7,17,37,79,163,331,673,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,43,89,179,359,719,1439,2879,5779,11579,23159,46327,92657,185323,370661,741337,1482707,2965421,5930887,11861791,23723597,47447201,94894427,189788857,379577741,759155483,1518310967,379,761,1523,3049,6101,12203,24407,48817,97649,195311,390647,781301,1562611,3125257,6250537,12501169,25002389,50004791,100009607,200019221,400038451,800076929,1600153859,13,29,59,127,257,521,1049,2099,4201,8419,16843,33703,67409,134837,269683,539389,1078787,2157587,4315183,8630387,17260781,34521589,69043189,138086407,276172823,552345671,1104691373,19,41,83,167,337,677,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,53,107,223,449,907,1823,3659,7321,14653,29311,58631,117269,234539,469099,938207,1876417,3752839,7505681,15011389,30022781,60045577,120091177,240182359,480364727,960729461,1921458943];function nextPrime(t){let n=binarySearch(primeNumbers,t,ascending);return n<0&&(n=~n),primeNumbers[n]}primeNumbers.sort(ascending);const FREE=0,FULL=1,REMOVED=2,defaultInitialCapacity=150,defaultMinLoadFactor=1/6,defaultMaxLoadFactor=2/3;class HashTable{constructor(t={}){if(t instanceof HashTable)return this.table=t.table.slice(),this.values=t.values.slice(),this.state=t.state.slice(),this.minLoadFactor=t.minLoadFactor,this.maxLoadFactor=t.maxLoadFactor,this.distinct=t.distinct,this.freeEntries=t.freeEntries,this.lowWaterMark=t.lowWaterMark,void(this.highWaterMark=t.maxLoadFactor);const n=void 0===t.initialCapacity?defaultInitialCapacity:t.initialCapacity;if(n<0)throw new RangeError(`initial capacity must not be less than zero: ${n}`);const e=void 0===t.minLoadFactor?defaultMinLoadFactor:t.minLoadFactor,o=void 0===t.maxLoadFactor?defaultMaxLoadFactor:t.maxLoadFactor;if(e<0||e>=1)throw new RangeError(`invalid minLoadFactor: ${e}`);if(o<=0||o>=1)throw new RangeError(`invalid maxLoadFactor: ${o}`);if(e>=o)throw new RangeError(`minLoadFactor (${e}) must be smaller than maxLoadFactor (${o})`);let r=n;r=r/o|0,r=nextPrime(r),0===r&&(r=1),this.table=newArray(r),this.values=newArray(r),this.state=newArray(r),this.minLoadFactor=e,this.maxLoadFactor=r===largestPrime?1:o,this.distinct=0,this.freeEntries=r,this.lowWaterMark=0,this.highWaterMark=chooseHighWaterMark(r,this.maxLoadFactor)}clone(){return new HashTable(this)}get size(){return this.distinct}get(t){const n=this.indexOfKey(t);return n<0?0:this.values[n]}set(t,n){let e=this.indexOfInsertion(t);if(e<0)return e=-e-1,this.values[e]=n,!1;if(this.distinct>this.highWaterMark){const e=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);return this.rehash(e),this.set(t,n)}if(this.table[e]=t,this.values[e]=n,this.state[e]===FREE&&this.freeEntries--,this.state[e]=FULL,this.distinct++,this.freeEntries<1){const t=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);this.rehash(t)}return!0}remove(t,n){const e=this.indexOfKey(t);return!(e<0)&&(this.state[e]=REMOVED,this.distinct--,n||this.maybeShrinkCapacity(),!0)}delete(t,n){const e=this.indexOfKey(t);return!(e<0)&&(this.state[e]=FREE,this.distinct--,n||this.maybeShrinkCapacity(),!0)}maybeShrinkCapacity(){if(this.distinct<this.lowWaterMark){const t=chooseShrinkCapacity(this.distinct,this.minLoadFactor,this.maxLoadFactor);this.rehash(t)}}containsKey(t){return this.indexOfKey(t)>=0}indexOfKey(t){const n=this.table,e=this.state,o=this.table.length,r=2147483647&t;let i=r%o,a=r%(o-2);for(0===a&&(a=1);e[i]!==FREE&&(e[i]===REMOVED||n[i]!==t);)i-=a,i<0&&(i+=o);return e[i]===FREE?-1:i}containsValue(t){return this.indexOfValue(t)>=0}indexOfValue(t){const n=this.values,e=this.state;for(var o=0;o<e.length;o++)if(e[o]===FULL&&n[o]===t)return o;return-1}indexOfInsertion(t){const n=this.table,e=this.state,o=n.length,r=2147483647&t;let i=r%o,a=r%(o-2);for(0===a&&(a=1);e[i]===FULL&&n[i]!==t;)i-=a,i<0&&(i+=o);if(e[i]===REMOVED){const r=i;for(;e[i]!==FREE&&(e[i]===REMOVED||n[i]!==t);)i-=a,i<0&&(i+=o);e[i]===FREE&&(i=r)}return e[i]===FULL?-i-1:i}ensureCapacity(t){if(this.table.length<t){const n=nextPrime(t);this.rehash(n)}}rehash(t){const n=this.table.length;if(t<=this.distinct)throw new Error("Unexpected");const e=this.table,o=this.values,r=this.state,i=newArray(t),a=newArray(t),s=newArray(t);this.lowWaterMark=chooseLowWaterMark(t,this.minLoadFactor),this.highWaterMark=chooseHighWaterMark(t,this.maxLoadFactor),this.table=i,this.values=a,this.state=s,this.freeEntries=t-this.distinct;for(var u=0;u<n;u++)if(r[u]===FULL){var f=e[u],l=this.indexOfInsertion(f);i[l]=f,a[l]=o[u],s[l]=FULL}}forEachKey(t){for(var n=0;n<this.state.length;n++)if(this.state[n]===FULL&&!t(this.table[n]))return!1;return!0}forEachValue(t){for(var n=0;n<this.state.length;n++)if(this.state[n]===FULL&&!t(this.values[n]))return!1;return!0}forEachPair(t){for(var n=0;n<this.state.length;n++)if(this.state[n]===FULL&&!t(this.table[n],this.values[n]))return!1;return!0}}function chooseLowWaterMark(t,n){return t*n|0}function chooseHighWaterMark(t,n){return Math.min(t-2,t*n|0)}function chooseGrowCapacity(t,n,e){return nextPrime(Math.max(t+1,4*t/(3*n+e)|0))}function chooseShrinkCapacity(t,n,e){return nextPrime(Math.max(t+1,4*t/(n+3*e)|0))}function newArray(t){return Array(t).fill(0)}class SparseMatrix{constructor(t,n,e={}){if(t instanceof SparseMatrix){const n=t;this._init(n.rows,n.columns,n.elements.clone(),n.threshold)}else if(Array.isArray(t)){const o=t;t=o.length,e=n||{},n=o[0].length,this._init(t,n,new HashTable(e),e.threshold);for(let e=0;e<t;e++)for(let t=0;t<n;t++){let r=o[e][t];this.threshold&&Math.abs(r)<this.threshold&&(r=0),0!==r&&this.elements.set(e*n+t,o[e][t])}}else this._init(t,n,new HashTable(e),e.threshold)}_init(t,n,e,o){this.rows=t,this.columns=n,this.elements=e,this.threshold=o||0}static eye(t=1,n=t){const e=Math.min(t,n),o=new SparseMatrix(t,n,{initialCapacity:e});for(let t=0;t<e;t++)o.set(t,t,1);return o}clone(){return new SparseMatrix(this)}to2DArray(){const t=new Array(this.rows);for(let n=0;n<this.rows;n++){t[n]=new Array(this.columns);for(let e=0;e<this.columns;e++)t[n][e]=this.get(n,e)}return t}isSquare(){return this.rows===this.columns}isSymmetric(){if(!this.isSquare())return!1;let t=!0;return this.forEachNonZero(((n,e,o)=>this.get(e,n)!==o?(t=!1,!1):o)),t}bandWidth(){let t=this.columns,n=-1;return this.forEachNonZero(((e,o,r)=>{let i=e-o;return t=Math.min(t,i),n=Math.max(n,i),r})),n-t}isBanded(t){return this.bandWidth()<=t}get cardinality(){return this.elements.size}get size(){return this.rows*this.columns}get(t,n){return this.elements.get(t*this.columns+n)}set(t,n,e){return this.threshold&&Math.abs(e)<this.threshold&&(e=0),0===e?this.elements.remove(t*this.columns+n):this.elements.set(t*this.columns+n,e),this}mmul(t){this.columns!==t.rows&&console.warn("Number of columns of left matrix are not equal to number of rows of right matrix.");const n=this.rows,e=t.columns,o=new SparseMatrix(n,e);return this.forEachNonZero(((n,e,r)=>(t.forEachNonZero(((t,i,a)=>(e===t&&o.set(n,i,o.get(n,i)+r*a),a))),r))),o}kroneckerProduct(t){const n=this.rows,e=this.columns,o=t.rows,r=t.columns,i=new SparseMatrix(n*o,e*r,{initialCapacity:this.cardinality*t.cardinality});return this.forEachNonZero(((n,e,a)=>(t.forEachNonZero(((t,s,u)=>(i.set(o*n+t,r*e+s,a*u),u))),a))),i}forEachNonZero(t){return this.elements.forEachPair(((n,e)=>{const o=n/this.columns|0,r=n%this.columns;let i=t(o,r,e);return!1!==i&&(this.threshold&&Math.abs(i)<this.threshold&&(i=0),i!==e&&(0===i?this.elements.remove(n,!0):this.elements.set(n,i)),!0)})),this.elements.maybeShrinkCapacity(),this}getNonZeros(){const t=this.cardinality,n=new Array(t),e=new Array(t),o=new Array(t);let r=0;return this.forEachNonZero(((t,i,a)=>(n[r]=t,e[r]=i,o[r]=a,r++,a))),{rows:n,columns:e,values:o}}setThreshold(t){return 0!==t&&t!==this.threshold&&(this.threshold=t,this.forEachNonZero(((t,n,e)=>e))),this}transpose(){let t=new SparseMatrix(this.columns,this.rows,{initialCapacity:this.cardinality});return this.forEachNonZero(((n,e,o)=>(t.set(e,n,o),o))),t}isEmpty(){return 0===this.rows||0===this.columns}}SparseMatrix.prototype.klass="Matrix",SparseMatrix.identity=SparseMatrix.eye,SparseMatrix.prototype.tensorProduct=SparseMatrix.prototype.kroneckerProduct;let inplaceOperator="\n(function %name%(value) {\n    if (typeof value === 'number') return this.%name%S(value);\n    return this.%name%M(value);\n})\n",inplaceOperatorScalar="\n(function %name%S(value) {\n    this.forEachNonZero((i, j, v) => v %op% value);\n    return this;\n})\n",inplaceOperatorMatrix="\n(function %name%M(matrix) {\n    matrix.forEachNonZero((i, j, v) => {\n        this.set(i, j, this.get(i, j) %op% v);\n        return v;\n    });\n    return this;\n})\n",staticOperator="\n(function %name%(matrix, value) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%(value);\n})\n",inplaceMethod="\n(function %name%() {\n    this.forEachNonZero((i, j, v) => %method%(v));\n    return this;\n})\n",staticMethod="\n(function %name%(matrix) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%();\n})\n";const operators=[["+","add"],["-","sub","subtract"],["*","mul","multiply"],["/","div","divide"],["%","mod","modulus"],["&","and"],["|","or"],["^","xor"],["<<","leftShift"],[">>","signPropagatingRightShift"],[">>>","rightShift","zeroFillRightShift"]];for(const operator of operators)for(let i=1;i<operator.length;i++)SparseMatrix.prototype[operator[i]]=eval(fillTemplateFunction(inplaceOperator,{name:operator[i],op:operator[0]})),SparseMatrix.prototype[`${operator[i]}S`]=eval(fillTemplateFunction(inplaceOperatorScalar,{name:`${operator[i]}S`,op:operator[0]})),SparseMatrix.prototype[`${operator[i]}M`]=eval(fillTemplateFunction(inplaceOperatorMatrix,{name:`${operator[i]}M`,op:operator[0]})),SparseMatrix[operator[i]]=eval(fillTemplateFunction(staticOperator,{name:operator[i]}));let methods=[["~","not"]];["abs","acos","acosh","asin","asinh","atan","atanh","cbrt","ceil","clz32","cos","cosh","exp","expm1","floor","fround","log","log1p","log10","log2","round","sign","sin","sinh","sqrt","tan","tanh","trunc"].forEach((function(t){methods.push([`Math.${t}`,t])}));for(const method of methods)for(let i=1;i<method.length;i++)SparseMatrix.prototype[method[i]]=eval(fillTemplateFunction(inplaceMethod,{name:method[i],method:method[0]})),SparseMatrix[method[i]]=eval(fillTemplateFunction(staticMethod,{name:method[i]}));function fillTemplateFunction(t,n){for(const e in n)t=t.replace(new RegExp(`%${e}%`,"g"),n[e]);return t}function addBaseline(t,n){if(!n)return t;let e=t.x,o=t.y;for(let t=0;t<e.length;t++)o[t]+=n(e[t]);return t}var defaultSource=Math.random,randomUniform=function t(n){function e(t,e){return t=null==t?0:+t,e=null==e?1:+e,1===arguments.length?(e=t,t=0):e-=t,function(){return n()*e+t}}return e.source=t,e}(defaultSource),randomNormal=function t(n){function e(t,e){var o,r;return t=null==t?0:+t,e=null==e?1:+e,function(){var i;if(null!=o)i=o,o=null;else do{o=2*n()-1,i=2*n()-1,r=o*o+i*i}while(!r||r>1);return t+e*i*Math.sqrt(-2*Math.log(r)/r)}}return e.source=t,e}(defaultSource);const LOOP=8,FLOAT_MUL=1/16777216,sh1=15,sh2=18,sh3=11;function multiply_uint32(t,n){const e=65535&(t>>>=0);return((t-e)*(n>>>=0)>>>0)+e*n>>>0}class XSadd{constructor(t=Date.now()){this.state=new Uint32Array(4),this.init(t),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*FLOAT_MUL}init(t){if(!Number.isInteger(t))throw new TypeError("seed must be an integer");this.state[0]=t,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let t=1;t<LOOP;t++)this.state[3&t]^=t+multiply_uint32(1812433253,this.state[t-1&3]^this.state[t-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let t=0;t<LOOP;t++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let t=this.state[0];t^=t<<sh1,t^=t>>>sh2,t^=this.state[3]<<sh3,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=t}}function addNoise(t,n=0,e={}){const{distribution:o="uniform",seed:r}=e;let i;switch(o){case"uniform":i=getRandom(randomUniform,r,-.5,.5);break;case"normal":i=getRandom(randomNormal,r);break;default:throw new Error(`Unknown distribution ${e.distribution}`)}if(!n)return t;let a=t.y,s=n*findMax(a)/100;for(let t=0;t<a.length;t++)a[t]+=i()*s;return t}function getRandom(t,n,...e){return"number"==typeof n?t.source(new XSadd(n).random)(...e):t(...e)}function findMax(t){let n=Number.MIN_VALUE;for(let e of t)e>n&&(n=e);return n}class SpectrumGenerator{constructor(t={}){t=Object.assign({},{from:0,to:1e3,nbPoints:10001,peakWidthFct:()=>5,shape:{kind:"gaussian"}},t),this.from=t.from,this.to=t.to,this.nbPoints=t.nbPoints,this.interval=(this.to-this.from)/(this.nbPoints-1),this.peakWidthFct=t.peakWidthFct,this.maxPeakHeight=Number.MIN_SAFE_INTEGER;let n=getShapeGenerator(t.shape);if(this.shape=n,assertNumber(this.from,"from"),assertNumber(this.to,"to"),assertInteger(this.nbPoints,"nbPoints"),this.to<=this.from)throw new RangeError("to option must be larger than from");if("function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(t,n){if(!(Array.isArray(t)||"object"==typeof t&&void 0!==t.x&&void 0!==t.y&&Array.isArray(t.x)&&Array.isArray(t.y)&&t.x.length===t.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(t))for(const e of t)this.addPeak(e,n);else for(let e=0;e<t.x.length;e++)this.addPeak([t.x[e],t.y[e]],n);return this}addPeak(t,n={}){if("object"!=typeof t||2!==t.length&&3!==t.length&&(void 0===t.x||void 0===t.y))throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");let e,o,r,i;Array.isArray(t)?[e,o,r,i]=t:(e=t.x,o=t.y,r=t.width,i=t.options),o>this.maxPeakHeight&&(this.maxPeakHeight=o);let{width:a=(void 0===r?this.peakWidthFct(e):r),widthLeft:s,widthRight:u,shape:f}=n;i&&Object.assign(f||{},i||{});let l=f?getShapeGenerator(f):this.shape;s||(s=a),u||(u=a);let c=void 0===n.factor?l.getFactor():n.factor;const h=e-s/2*c,w=e+u/2*c,g=Math.max(0,Math.floor((h-this.from)/this.interval)),m=Math.min(this.nbPoints-1,Math.ceil((w-this.from)/this.interval)),d=Math.round((e-this.from)/this.interval);l.setFWHM(s);for(let t=g;t<Math.max(d,0);t++)this.data.y[t]+=o*l.fct(this.data.x[t]-e);l.setFWHM(u);for(let t=Math.min(d,m);t<=m;t++)this.data.y[t]+=o*l.fct(this.data.x[t]-e);return this}addBaseline(t){return addBaseline(this.data,t),this}addNoise(t,n){return addNoise(this.data,t,n),this}getSpectrum(t={}){"boolean"==typeof t&&(t={copy:t});const{copy:n=!0,threshold:e=0}=t;if(e){let t=this.maxPeakHeight*e,n=[],o=[];for(let e=0;e<this.data.x.length;e++)this.data.y[e]>=t&&(n.push(this.data.x[e]),o.push(this.data.y[e]));return{x:n,y:o}}return n?{x:this.data.x.slice(),y:this.data.y.slice()}:this.data}reset(){const t=this.data={x:new Float64Array(this.nbPoints),y:new Float64Array(this.nbPoints)};for(let n=0;n<this.nbPoints;n++)t.x[n]=this.from+n*this.interval;return this}}function assertInteger(t,n){if(!Number.isInteger(t))throw new TypeError(`${n} option must be an integer`)}function assertNumber(t,n){if(!Number.isFinite(t))throw new TypeError(`${n} option must be a number`)}function createPauli(t){const n=(t-1)/2,e=new Array(t),o=new Array(t);for(let r=0;r<t;r++)e[r]=t-1-r-n,o[r]=Math.sqrt(n*(n+1)-e[r]*(e[r]+1));const r=diag(o,1,t,t);for(let r=0;r<t;r++)o[r]=Math.sqrt(n*(n+1)-e[r]*(e[r]-1));const i=diag(o,-1,t,t);return{x:r.clone().add(i).mul(.5),y:i.clone().mul(-1).add(r).mul(-.5),z:diag(e,0,t,t),m:i,p:r}}function diag(t,n,e,o){const r=new SparseMatrix(e,o,{initialCapacity:20});for(let i=0;i<t.length;i++)i-n>=0&&i-n<e&&i<o&&r.set(i-n,i,t[i]);return r}const pauli2=createPauli(2);function getPauliMatrix(t){return 2===t?pauli2:createPauli(t)}const smallValue=.01;function simulate1D(t,n){let{lineWidth:e=1,maxClusterSize:o=10,frequency:r=400,shape:i={kind:"gaussian",options:{from:0,to:10,nbPoints:1024}}}=n,{options:a}=i,s=e/r;a.peakWidthFct=()=>s;let u=new SpectrumGenerator(a);const f=t.chemicalShifts.slice();for(let t=0;t<f.length;t++)f[t]=f[t]*r;const l=t.multiplicity;for(let n=0;n<t.clusters.length;n++){const i=t.clusters[n];let a=new Array(i.length);for(let t=0;t<i.length;t++)a[t]=i[t]<0?-i[t]-1:i[t];let s=1,c=0,h=[],w=[];if(i.length>o){let n=0;for(;i[n++]<0;);n=i[n-1],h.push(-f[n]);for(let e=0;e<i.length;e++)if(i[e]<0){let o=t.couplingConstants.get(n,a[e])/2,r=h.length;for(let t=0;t<r;t++)h.push(h[t]+o),h[t]-=o}h=Float64Array.from(h).sort(),c=h.length,s=1;for(let t=0;t<c;t++)w.push(1)}else{const n=getHamiltonian(f,t.couplingConstants,l,t.connectivity,a),e=n.rows,o=new EigenvalueDecomposition(n),r=o.eigenvectorMatrix,u=o.realEigenvalues,g=new SparseMatrix(e,e),m=i.length;s=0;for(let t=0;t<m;t++){const n=getPauliMatrix(l[a[t]]);let e=1;for(let n=0;n<t;n++)e*=l[a[n]];const o=SparseMatrix.eye(e);e=1;for(let n=t+1;n<m;n++)e*=l[a[n]];const r=SparseMatrix.eye(e),u=o.kroneckerProduct(n.m).kroneckerProduct(r);i[t]>=0?(g.add(u.mul(i[t]+1)),s++):g.add(u.mul(i[t]))}let d=Matrix.zeros(e,e);g.forEachNonZero(((t,n,e)=>{if(e>0)for(let e=0;e<r.columns;e++){let o=r.get(n,e);0!==o&&d.set(t,e,d.get(t,e)+o)}return e}));let p=d.clone();g.forEachNonZero(((t,n,e)=>{if(e<0)for(let e=0;e<r.columns;e++){let o=r.get(n,e);0!==o&&p.set(t,e,p.get(t,e)+o)}return e}));const G=r.transpose();d=G.mmul(d),d=new SparseMatrix(d.to2DArray(),{threshold:smallValue}),triuTimesAbs(d,smallValue),p=G.mmul(p),p=new SparseMatrix(p.to2DArray(),{threshold:smallValue}),p.forEachNonZero(((t,n,e)=>e)),triuTimesAbs(p,smallValue),p.forEachNonZero(((t,n,e)=>{let o=d.get(t,n);o=Math.min(Math.abs(o),Math.abs(e)),o*=o,c+=o;let r=u[t]-u[n],i=binarySearch(h,r,((t,n)=>t-n));i<0?(h.splice(-1-i,0,r),w.splice(-1-i,0,o)):w[i]+=o}))}const g=h.length;if(g>0){s/=c;const t=e/64;let n=h[0],o=w[0],i=1;for(let e=1;e<g;e++)Math.abs(h[e]-n/i)<t?(o+=w[e],n+=h[e],i++):(u.addPeak({x:-n/i/r,y:o*s}),n=h[e],o=w[e],i=1);u.addPeak({x:-n/i/r,y:o*s})}}return u.data}function triuTimesAbs(t,n){t.forEachNonZero(((t,e,o)=>t>e||Math.abs(o)<=n?0:o))}function getHamiltonian(t,n,e,o,r){let i=1;for(let t=0;t<r.length;t++)i*=e[r[t]];const a=new SparseMatrix(i,i);for(let i=0;i<r.length;i++){let s=r[i];const u=getPauliMatrix(e[s]);let f,l,c=1;for(let t=0;t<i;t++)c*=e[r[t]];f=SparseMatrix.eye(c),c=1;for(let t=i+1;t<r.length;t++)c*=e[r[t]];l=SparseMatrix.eye(c);const h=t[s],w=f.kroneckerProduct(u.z).kroneckerProduct(l);a.add(w.mul(h));for(let t=0;t<r.length;t++){const i=r[t];if(1===o.get(s,i)){const o=getPauliMatrix(e[i]);let c,h,w=1;for(let n=0;n<t;n++)w*=e[r[n]];c=SparseMatrix.eye(w),w=1;for(let n=t+1;n<r.length;n++)w*=e[r[n]];h=SparseMatrix.eye(w);const g=f.kroneckerProduct(u.x).kroneckerProduct(l).mmul(c.kroneckerProduct(o.x).kroneckerProduct(h));g.add(f.kroneckerProduct(u.y).kroneckerProduct(l).mul(-1).mmul(c.kroneckerProduct(o.y).kroneckerProduct(h))),g.add(f.kroneckerProduct(u.z).kroneckerProduct(l).mmul(c.kroneckerProduct(o.z).kroneckerProduct(h))),a.add(g.mul(n.get(s,i)/2))}}}return a}function squaredEuclidean(t,n){let e=0;for(let o=0;o<t.length;o++)e+=(t[o]-n[o])*(t[o]-n[o]);return e}function euclidean(t,n){return Math.sqrt(squaredEuclidean(t,n))}function distanceMatrix(t,n){const e=getMatrix(t.length);for(let o=0;o<t.length;o++)for(let r=0;r<=o;r++)e[o][r]=n(t[o],t[r]),e[r][o]=e[o][r];return e}function getMatrix(t){const n=[];for(let e=0;e<t;e++){const e=[];n.push(e);for(let n=0;n<t;n++)e.push(0)}return n}var heap$1={exports:{}};!function(t,n){(function(){var n,e,o,r,i,a,s,u,f,l,c,h,w,g,m;o=Math.floor,l=Math.min,e=function(t,n){return t<n?-1:t>n?1:0},f=function(t,n,r,i,a){var s;if(null==r&&(r=0),null==a&&(a=e),r<0)throw new Error("lo must be non-negative");for(null==i&&(i=t.length);r<i;)a(n,t[s=o((r+i)/2)])<0?i=s:r=s+1;return[].splice.apply(t,[r,r-r].concat(n)),n},a=function(t,n,o){return null==o&&(o=e),t.push(n),g(t,0,t.length-1,o)},i=function(t,n){var o,r;return null==n&&(n=e),o=t.pop(),t.length?(r=t[0],t[0]=o,m(t,0,n)):r=o,r},u=function(t,n,o){var r;return null==o&&(o=e),r=t[0],t[0]=n,m(t,0,o),r},s=function(t,n,o){var r;return null==o&&(o=e),t.length&&o(t[0],n)<0&&(n=(r=[t[0],n])[0],t[0]=r[1],m(t,0,o)),n},r=function(t,n){var r,i,a,s,u,f;for(null==n&&(n=e),u=[],i=0,a=(s=function(){f=[];for(var n=0,e=o(t.length/2);0<=e?n<e:n>e;0<=e?n++:n--)f.push(n);return f}.apply(this).reverse()).length;i<a;i++)r=s[i],u.push(m(t,r,n));return u},w=function(t,n,o){var r;if(null==o&&(o=e),-1!==(r=t.indexOf(n)))return g(t,0,r,o),m(t,r,o)},c=function(t,n,o){var i,a,u,f,l;if(null==o&&(o=e),!(a=t.slice(0,n)).length)return a;for(r(a,o),u=0,f=(l=t.slice(n)).length;u<f;u++)i=l[u],s(a,i,o);return a.sort(o).reverse()},h=function(t,n,o){var a,s,u,c,h,w,g,m,d;if(null==o&&(o=e),10*n<=t.length){if(!(u=t.slice(0,n).sort(o)).length)return u;for(s=u[u.length-1],c=0,w=(g=t.slice(n)).length;c<w;c++)o(a=g[c],s)<0&&(f(u,a,0,null,o),u.pop(),s=u[u.length-1]);return u}for(r(t,o),d=[],h=0,m=l(n,t.length);0<=m?h<m:h>m;0<=m?++h:--h)d.push(i(t,o));return d},g=function(t,n,o,r){var i,a,s;for(null==r&&(r=e),i=t[o];o>n&&r(i,a=t[s=o-1>>1])<0;)t[o]=a,o=s;return t[o]=i},m=function(t,n,o){var r,i,a,s,u;for(null==o&&(o=e),i=t.length,u=n,a=t[n],r=2*n+1;r<i;)(s=r+1)<i&&!(o(t[r],t[s])<0)&&(r=s),t[n]=t[r],r=2*(n=r)+1;return t[n]=a,g(t,u,n,o)},n=function(){function t(t){this.cmp=null!=t?t:e,this.nodes=[]}return t.push=a,t.pop=i,t.replace=u,t.pushpop=s,t.heapify=r,t.updateItem=w,t.nlargest=c,t.nsmallest=h,t.prototype.push=function(t){return a(this.nodes,t,this.cmp)},t.prototype.pop=function(){return i(this.nodes,this.cmp)},t.prototype.peek=function(){return this.nodes[0]},t.prototype.contains=function(t){return-1!==this.nodes.indexOf(t)},t.prototype.replace=function(t){return u(this.nodes,t,this.cmp)},t.prototype.pushpop=function(t){return s(this.nodes,t,this.cmp)},t.prototype.heapify=function(){return r(this.nodes,this.cmp)},t.prototype.updateItem=function(t){return w(this.nodes,t,this.cmp)},t.prototype.clear=function(){return this.nodes=[]},t.prototype.empty=function(){return 0===this.nodes.length},t.prototype.size=function(){return this.nodes.length},t.prototype.clone=function(){var n;return(n=new t).nodes=this.nodes.slice(0),n},t.prototype.toArray=function(){return this.nodes.slice(0)},t.prototype.insert=t.prototype.push,t.prototype.top=t.prototype.peek,t.prototype.front=t.prototype.peek,t.prototype.has=t.prototype.contains,t.prototype.copy=t.prototype.clone,t}(),t.exports=n}).call(commonjsGlobal)}(heap$1);var heap=heap$1.exports;class Cluster{constructor(){this.children=[],this.height=0,this.size=1,this.index=-1,this.isLeaf=!1}cut(t){if("number"!=typeof t)throw new TypeError("threshold must be a number");if(t<0)throw new RangeError("threshold must be a positive number");let n=[this];const e=[];for(;n.length>0;){const o=n.shift();t>=o.height?e.push(o):n=n.concat(o.children)}return e}group(t){if(!Number.isInteger(t)||t<1)throw new RangeError("groups must be a positive integer");const n=new heap(((t,n)=>n.height-t.height));for(n.push(this);n.size()<t;){var e=n.pop();if(0===e.children.length)break;e.children.forEach((t=>n.push(t)))}var o=new Cluster;return o.children=n.toArray(),o.height=this.height,o}traverse(t){!function t(n,e){if(e(n),n.children)for(const o of n.children)t(o,e)}(this,t)}indices(){const t=[];return this.traverse((n=>{n.isLeaf&&t.push(n.index)})),t}}function singleLink(t,n){return Math.min(t,n)}function completeLink(t,n){return Math.max(t,n)}function averageLink(t,n,e,o,r){return o/(o+r)*t+r/(o+r)*n}function weightedAverageLink(t,n){return(t+n)/2}function centroidLink(t,n,e,o,r){return o/(o+r)*t+r/(o+r)*n+-o*r/(o+r)**2*e}function medianLink(t,n,e){return t/2+n/2-e/4}function wardLink(t,n,e,o,r,i){return(o+i)/(o+r+i)*t+(r+i)/(o+r+i)*n+-i/(o+r+i)*e}function wardLink2(t,n,e,o,r,i){const a=(o+i)/(o+r+i),s=(r+i)/(o+r+i),u=-i/(o+r+i);return Math.sqrt(a*t*t+s*n*n+u*e*e)}function agnes(t,n={}){const{distanceFunction:e=euclidean,method:o="complete",isDistanceMatrix:r=!1}=n;let i;r||(t=distanceMatrix(t,e));let a=new Matrix(t);const s=a.rows;if("string"==typeof o)switch(o.toLowerCase()){case"single":i=singleLink;break;case"complete":i=completeLink;break;case"average":case"upgma":i=averageLink;break;case"wpgma":i=weightedAverageLink;break;case"centroid":case"upgmc":i=centroidLink;break;case"median":case"wpgmc":i=medianLink;break;case"ward":i=wardLink;break;case"ward2":i=wardLink2;break;default:throw new RangeError(`unknown clustering method: ${o}`)}else if("function"!=typeof o)throw new TypeError("method must be a string or function");let u=[];for(let t=0;t<s;t++){const n=new Cluster;n.isLeaf=!0,n.index=t,u.push(n)}for(let t=0;t<s-1;t++){const[t,n,e]=getSmallestDistance(a),o=u[t],r=u[n],s=new Cluster;s.size=o.size+r.size,s.children.push(o,r),s.height=e;const f=[s],l=new Matrix(a.rows-1,a.rows-1),c=e=>getPreviousIndex(e,Math.min(t,n),Math.max(t,n));for(let s=1;s<l.rows;s++){const h=c(s),w=u[h];f.push(w);for(let u=0;u<s;u++)if(0===u){const f=i(a.get(t,h),a.get(h,n),e,o.size,r.size,w.size);l.set(s,u,f),l.set(u,s,f)}else{const t=a.get(h,c(u));l.set(s,u,t),l.set(u,s,t)}}u=f,a=l}return u[0]}function getSmallestDistance(t){let n=1/0,e=0,o=0;for(let r=1;r<t.rows;r++)for(let i=0;i<r;i++)t.get(r,i)<n&&(n=t.get(r,i),e=r,o=i);return[e,o,n]}function getPreviousIndex(t,n,e){return(t-=1)>=n&&t++,t>=e&&t++,t}function splitSpinSystem(t,n={}){let{chemicalShifts:e,couplingConstants:o,connectivity:r}=t,{frequency:i=400,maxClusterSize:a=8}=n,s=agnes(calculateBetas(e,o,i),{method:"single",isDistanceMatrix:!0}),u=[],f=e.length;splitCluster(s,u,{maxClusterSize:a,force:!1,nSpins:f,connectivity:r});let l=mergeClusters(u,a),c=l.length,h=new Array(c);for(let t=0;t<c;t++){h[t]=[];for(let n=0;n<f;n++){let e=l[t][n];0!==e&&h[t].push(e<0?-(n+1):n)}}return h}function splitCluster(t,n,e={}){let{maxClusterSize:o,force:r,nSpins:i,connectivity:a}=e;if(!r&&t.size<=o)n.push(getMembers(t.indices(),i));else for(let e of t.children)if(e.size<=o){let t=getMembers(e.indices(),i),r=0;for(let n=0;n<i;n++)if(1===t[n]){for(let e=0;e<i;e++)1===a.get(n,e)&&0===t[e]&&(t[e]=-1,r++);r++}r<=o?n.push(t):e.index<0?splitCluster(e,n,{maxClusterSize:o,force:!0,nSpins:i,connectivity:a}):(t[e.index]=2,n.push(t))}else splitCluster(e,n,{maxClusterSize:o,force:!1,nSpins:i,connectivity:a})}function calculateBetas(t,n,e){let o=n.rows,r=n.columns,i=Matrix.zeros(o,o);for(let a=0;a<o;a++)for(let o=a;o<r;o++){let r=n.get(a,o);if(t[a]-t[o]!=0){let n=1-Math.abs(r/((t[a]-t[o])*e));i.set(a,o,n),i.set(o,a,n)}else a!==o&&0===r&&(i.set(a,o,1),i.set(o,a,1))}return i.to2DArray()}function mergeClusters(t,n){for(let e=t.length-1;e>=0;e--){let o=t[e],r=o.length,i=0;for(;i<r&&-1!==o[i++];);if(!(i>=r))for(let i=t.length-1;i>=e+1;i--){let e=t[i],a=0,s=0;for(let t=0;t<r;t++)o[t]*e[t]==-1&&s++,0===o[t]&&0===e[t]||a++;if(s>0&&a<=n){for(let t=0;t<r;t++)1===e[t]?o[t]=1:-1===e[t]&&1!==o[t]&&(o[t]=-1);t.splice(i,1)}}}return t}function getMembers(t,n){let e=new Int16Array(n);for(let n of t)e[n]=1;return e}function signalsToXY(t,n={}){let{frequency:e=400,shape:o={kind:"gaussian",options:{from:0,to:10,nbPoints:16384}},maxValue:r=1e8,maxClusterSize:i=8}=n,a=signalsToSpinSystem(t);a.clusters=splitSpinSystem(a,{frequency:e,maxClusterSize:i});let s=simulate1D(a,{frequency:e,shape:o});return r&&(s.y=rescale(s.y,{max:r})),s}const couplingPatterns=["s","d","t","q","quint","h","sept","o","n"],couplingValues={s:0,d:1,t:2,q:3,quint:4,h:5,hex:5,hept:6,sept:6,oct:7,o:7,non:8,n:8};function joinPatterns(t){let n=0;for(let e of t){if(void 0===couplingValues[e])throw new Error(`Unknown multiplicity: ${e}`);n+=couplingValues[e]}return couplingPatterns[n]}function signalNormalize(t){if((t=JSON.parse(JSON.stringify(t))).assignment&&!Array.isArray(t.assignment)&&(t.assignment=[t.assignment]),t.diaID&&!Array.isArray(t.diaID)&&(t.diaID=[t.diaID]),t.j){let n=t.j;for(let t of n)t.assignment&&!Array.isArray(t.assignment)&&(t.assignment=[t.assignment]),t.diaID&&!Array.isArray(t.diaID)&&(t.diaID=[t.diaID]);t.j=t.j.sort(((t,n)=>n.coupling-t.coupling))}return t}function signalJoinCouplings(t,n={}){const{tolerance:e=.05}=n;if(!(t=signalNormalize(t)).j||t.j.length<2)return t;let o=[t.j[0]],r=[o];for(let n=1;n<t.j.length;n++){let i=t.j[n];o[o.length-1].coupling-i.coupling<e?o.push(i):(o=[i],r.push(o))}t.j=[];for(let n of r){let e=sum(n.map((t=>t.coupling)))/n.length,o=distinctValues(n.filter((t=>t.assignment&&t.assignment.length>0)).map((t=>t.assignment)).flat()),r=distinctValues(n.filter((t=>t.diaID&&t.diaID.length>0)).map((t=>t.diaID)).flat()),i=distinctValues(n.map((t=>t.distance))),a={coupling:e,multiplicity:joinPatterns(n.map((t=>t.multiplicity)))};r.length>0&&(a.diaID=r),1===i.length&&i[0]&&(a.distance=i[0]),o.length>0&&(a.assignment=o),t.j.push(a)}return t}function distinctValues(t){return[...new Set(t)]}function signalMultiplicityPattern(t){let n=t.j,e="";if(n&&n.length>0)for(let t of n)e+=t.multiplicity;else e=t.delta?"s":"m";return e}const globalOptions={h:{nucleus:"1H",nbDecimalDelta:2,nbDecimalJ:1,observedFrequency:400},c:{nucleus:"13C",nbDecimalDelta:1,nbDecimalJ:1,observedFrequency:100},f:{nucleus:"19F",nbDecimalDelta:2,nbDecimalJ:1,observedFrequency:400}};function rangesToACS(t,n={}){n.nucleus||(n.nucleus="1H");let e=n.nucleus.toLowerCase().replace(/[0-9]/g,""),o=globalOptions[e];n=Object.assign({},o,{ascending:!1,format:"IMJA"},n),t=JSON.parse(JSON.stringify(t)),!0===n.ascending&&t.sort(((t,n)=>Math.min(t.from,t.to)-Math.min(n.from,n.to)));let r=formatAcs(t,n);return r.length>0&&(r+="."),r}function formatAcs(t,n){let e=spectroInformation(n);0===e.length&&(e="δ ");let o=[];for(let e of t)uselessKind(e.kind,n.filter)||pushDelta(e,o,n);return o.length>0?e+o.join(", "):""}function spectroInformation(t){let n=[],e=`${formatNucleus(t.nucleus)} NMR`;return t.solvent&&n.push(formatMF(t.solvent)),t.frequencyObserved&&n.push(`${(1*t.frequencyObserved).toFixed(0)} MHz`),n.length>0?e+=` (${n.join(", ")}): δ `:e+=": δ ",e}function pushDelta(t,n,e){let o="",r=[],i=[t.from,t.to];if(Array.isArray(t.signal)&&(t.signal=t.signal.filter((t=>!uselessKind(t.kind,e.filter)))),Array.isArray(t.signal)&&t.signal.length>0){let n=t.signal;if(n.length>1){!0===e.ascending&&n.sort(((t,n)=>t.delta-n.delta)),o+=`${Math.min(...i).toFixed(e.nbDecimalDelta)}-${Math.max(...i).toFixed(e.nbDecimalDelta)}`,o+=` (${getIntegral(t,e)}`;for(let t of n)r=[],void 0!==t.delta&&(o=appendSeparator(o),o+=t.delta.toFixed(e.nbDecimalDelta)),switchFormat({},t,r,e),r.length>0&&(o+=` (${r.join(", ")})`);o+=")"}else r=[],void 0!==n[0].delta?(o+=n[0].delta.toFixed(e.nbDecimalDelta),switchFormat(t,n[0],r,e),r.length>0&&(o+=` (${r.join(", ")})`)):(o+=`${Math.min(...i).toFixed(e.nbDecimalDelta)}-${Math.max(...i).toFixed(e.nbDecimalDelta)}`,switchFormat(t,n[0],r,e),r.length>0&&(o+=` (${r})`))}else o+=`${Math.min(...i).toFixed(e.nbDecimalDelta)}-${Math.max(...i).toFixed(e.nbDecimalDelta)}`,switchFormat(t,[],r,e),r.length>0&&(o+=` (${r.join(", ")})`);n.push(o)}function getIntegral(t,n){let e="";return t.pubIntegral?e=t.pubIntegral:t.integral&&(e=t.integral.toFixed(0)+n.nucleus[n.nucleus.length-1]),e}function pushIntegral(t,n,e){let o=getIntegral(t,e);o.length>0&&n.push(o)}function pushMultiplicityFromSignal(t,n){let e=t.multiplicity;if(!e){e=signalMultiplicityPattern(signalJoinCouplings(t,{tolerance:.05}))}e.length>0&&n.push(e)}function switchFormat(t,n,e,o){for(const r of o.format)switch(r.toUpperCase()){case"I":pushIntegral(t,e,o);break;case"M":pushMultiplicityFromSignal(n,e);break;case"A":pushAssignment(n,e);break;case"J":pushCoupling(n,e,o);break;default:throw new Error(`Unknow format letter: ${r}`)}}function formatMF(t){return t.replace(/(?<num>[0-9]+)/g,"<sub>$<num></sub>")}function formatNucleus(t){return t.replace(/(?<num>[0-9]+)/g,"<sup>$<num></sup>")}function appendSeparator(t){return t.length>0&&!t.match(/ $/)&&!t.match(/\($/)&&(t+=", "),t}function formatAssignment(t){return t=(t=t.replace(/(?<num>[0-9]+)/g,"<sub>$<num></sub>")).replace(/"(?<i>[^"]*)"/g,"<i>$<i></i>")}function pushCoupling(t,n,e){if(Array.isArray(t.j)&&t.j.length>0){t.j.sort((function(t,n){return n.coupling-t.coupling}));let o=[];for(let n of t.j)void 0!==n.coupling&&o.push(n.coupling.toFixed(e.nbDecimalJ));o.length>0&&n.push(`<i>J</i> = ${o.join(", ")} Hz`)}}function pushAssignment(t,n){t.pubAssignment?n.push(formatAssignment(t.pubAssignment)):t.assignment&&n.push(formatAssignment(t.assignment))}function uselessKind(t="",n=!0){return t=t.toLowerCase(),!(!n||"impurity"!==t&&"solvent"!==t)}var browserPonyfill={exports:{}};!function(t,n){var e="undefined"!=typeof self?self:commonjsGlobal,o=function(){function t(){this.fetch=!1,this.DOMException=e.DOMException}return t.prototype=e,new t}();!function(t){!function(n){var e="URLSearchParams"in t,o="Symbol"in t&&"iterator"in Symbol,r="FileReader"in t&&"Blob"in t&&function(){try{return new Blob,!0}catch(t){return!1}}(),i="FormData"in t,a="ArrayBuffer"in t;if(a)var s=["[object Int8Array]","[object Uint8Array]","[object Uint8ClampedArray]","[object Int16Array]","[object Uint16Array]","[object Int32Array]","[object Uint32Array]","[object Float32Array]","[object Float64Array]"],u=ArrayBuffer.isView||function(t){return t&&s.indexOf(Object.prototype.toString.call(t))>-1};function f(t){if("string"!=typeof t&&(t=String(t)),/[^a-z0-9\-#$%&'*+.^_`|~]/i.test(t))throw new TypeError("Invalid character in header field name");return t.toLowerCase()}function l(t){return"string"!=typeof t&&(t=String(t)),t}function c(t){var n={next:function(){var n=t.shift();return{done:void 0===n,value:n}}};return o&&(n[Symbol.iterator]=function(){return n}),n}function h(t){this.map={},t instanceof h?t.forEach((function(t,n){this.append(n,t)}),this):Array.isArray(t)?t.forEach((function(t){this.append(t[0],t[1])}),this):t&&Object.getOwnPropertyNames(t).forEach((function(n){this.append(n,t[n])}),this)}function w(t){if(t.bodyUsed)return Promise.reject(new TypeError("Already read"));t.bodyUsed=!0}function g(t){return new Promise((function(n,e){t.onload=function(){n(t.result)},t.onerror=function(){e(t.error)}}))}function m(t){var n=new FileReader,e=g(n);return n.readAsArrayBuffer(t),e}function d(t){if(t.slice)return t.slice(0);var n=new Uint8Array(t.byteLength);return n.set(new Uint8Array(t)),n.buffer}function p(){return this.bodyUsed=!1,this._initBody=function(t){var n;this._bodyInit=t,t?"string"==typeof t?this._bodyText=t:r&&Blob.prototype.isPrototypeOf(t)?this._bodyBlob=t:i&&FormData.prototype.isPrototypeOf(t)?this._bodyFormData=t:e&&URLSearchParams.prototype.isPrototypeOf(t)?this._bodyText=t.toString():a&&r&&((n=t)&&DataView.prototype.isPrototypeOf(n))?(this._bodyArrayBuffer=d(t.buffer),this._bodyInit=new Blob([this._bodyArrayBuffer])):a&&(ArrayBuffer.prototype.isPrototypeOf(t)||u(t))?this._bodyArrayBuffer=d(t):this._bodyText=t=Object.prototype.toString.call(t):this._bodyText="",this.headers.get("content-type")||("string"==typeof t?this.headers.set("content-type","text/plain;charset=UTF-8"):this._bodyBlob&&this._bodyBlob.type?this.headers.set("content-type",this._bodyBlob.type):e&&URLSearchParams.prototype.isPrototypeOf(t)&&this.headers.set("content-type","application/x-www-form-urlencoded;charset=UTF-8"))},r&&(this.blob=function(){var t=w(this);if(t)return t;if(this._bodyBlob)return Promise.resolve(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(new Blob([this._bodyArrayBuffer]));if(this._bodyFormData)throw new Error("could not read FormData body as blob");return Promise.resolve(new Blob([this._bodyText]))},this.arrayBuffer=function(){return this._bodyArrayBuffer?w(this)||Promise.resolve(this._bodyArrayBuffer):this.blob().then(m)}),this.text=function(){var t,n,e,o=w(this);if(o)return o;if(this._bodyBlob)return t=this._bodyBlob,n=new FileReader,e=g(n),n.readAsText(t),e;if(this._bodyArrayBuffer)return Promise.resolve(function(t){for(var n=new Uint8Array(t),e=new Array(n.length),o=0;o<n.length;o++)e[o]=String.fromCharCode(n[o]);return e.join("")}(this._bodyArrayBuffer));if(this._bodyFormData)throw new Error("could not read FormData body as text");return Promise.resolve(this._bodyText)},i&&(this.formData=function(){return this.text().then(y)}),this.json=function(){return this.text().then(JSON.parse)},this}h.prototype.append=function(t,n){t=f(t),n=l(n);var e=this.map[t];this.map[t]=e?e+", "+n:n},h.prototype.delete=function(t){delete this.map[f(t)]},h.prototype.get=function(t){return t=f(t),this.has(t)?this.map[t]:null},h.prototype.has=function(t){return this.map.hasOwnProperty(f(t))},h.prototype.set=function(t,n){this.map[f(t)]=l(n)},h.prototype.forEach=function(t,n){for(var e in this.map)this.map.hasOwnProperty(e)&&t.call(n,this.map[e],e,this)},h.prototype.keys=function(){var t=[];return this.forEach((function(n,e){t.push(e)})),c(t)},h.prototype.values=function(){var t=[];return this.forEach((function(n){t.push(n)})),c(t)},h.prototype.entries=function(){var t=[];return this.forEach((function(n,e){t.push([e,n])})),c(t)},o&&(h.prototype[Symbol.iterator]=h.prototype.entries);var G=["DELETE","GET","HEAD","OPTIONS","POST","PUT"];function b(t,n){var e,o,r=(n=n||{}).body;if(t instanceof b){if(t.bodyUsed)throw new TypeError("Already read");this.url=t.url,this.credentials=t.credentials,n.headers||(this.headers=new h(t.headers)),this.method=t.method,this.mode=t.mode,this.signal=t.signal,r||null==t._bodyInit||(r=t._bodyInit,t.bodyUsed=!0)}else this.url=String(t);if(this.credentials=n.credentials||this.credentials||"same-origin",!n.headers&&this.headers||(this.headers=new h(n.headers)),this.method=(e=n.method||this.method||"GET",o=e.toUpperCase(),G.indexOf(o)>-1?o:e),this.mode=n.mode||this.mode||null,this.signal=n.signal||this.signal,this.referrer=null,("GET"===this.method||"HEAD"===this.method)&&r)throw new TypeError("Body not allowed for GET or HEAD requests");this._initBody(r)}function y(t){var n=new FormData;return t.trim().split("&").forEach((function(t){if(t){var e=t.split("="),o=e.shift().replace(/\+/g," "),r=e.join("=").replace(/\+/g," ");n.append(decodeURIComponent(o),decodeURIComponent(r))}})),n}function j(t,n){n||(n={}),this.type="default",this.status=void 0===n.status?200:n.status,this.ok=this.status>=200&&this.status<300,this.statusText="statusText"in n?n.statusText:"OK",this.headers=new h(n.headers),this.url=n.url||"",this._initBody(t)}b.prototype.clone=function(){return new b(this,{body:this._bodyInit})},p.call(b.prototype),p.call(j.prototype),j.prototype.clone=function(){return new j(this._bodyInit,{status:this.status,statusText:this.statusText,headers:new h(this.headers),url:this.url})},j.error=function(){var t=new j(null,{status:0,statusText:""});return t.type="error",t};var N=[301,302,303,307,308];j.redirect=function(t,n){if(-1===N.indexOf(n))throw new RangeError("Invalid status code");return new j(null,{status:n,headers:{location:t}})},n.DOMException=t.DOMException;try{new n.DOMException}catch(t){n.DOMException=function(t,n){this.message=t,this.name=n;var e=Error(t);this.stack=e.stack},n.DOMException.prototype=Object.create(Error.prototype),n.DOMException.prototype.constructor=n.DOMException}function H(t,e){return new Promise((function(o,i){var a=new b(t,e);if(a.signal&&a.signal.aborted)return i(new n.DOMException("Aborted","AbortError"));var s=new XMLHttpRequest;function u(){s.abort()}s.onload=function(){var t,n,e={status:s.status,statusText:s.statusText,headers:(t=s.getAllResponseHeaders()||"",n=new h,t.replace(/\r?\n[\t ]+/g," ").split(/\r?\n/).forEach((function(t){var e=t.split(":"),o=e.shift().trim();if(o){var r=e.join(":").trim();n.append(o,r)}})),n)};e.url="responseURL"in s?s.responseURL:e.headers.get("X-Request-URL");var r="response"in s?s.response:s.responseText;o(new j(r,e))},s.onerror=function(){i(new TypeError("Network request failed"))},s.ontimeout=function(){i(new TypeError("Network request failed"))},s.onabort=function(){i(new n.DOMException("Aborted","AbortError"))},s.open(a.method,a.url,!0),"include"===a.credentials?s.withCredentials=!0:"omit"===a.credentials&&(s.withCredentials=!1),"responseType"in s&&r&&(s.responseType="blob"),a.headers.forEach((function(t,n){s.setRequestHeader(n,t)})),a.signal&&(a.signal.addEventListener("abort",u),s.onreadystatechange=function(){4===s.readyState&&a.signal.removeEventListener("abort",u)}),s.send(void 0===a._bodyInit?null:a._bodyInit)}))}H.polyfill=!0,t.fetch||(t.fetch=H,t.Headers=h,t.Request=b,t.Response=j),n.Headers=h,n.Request=b,n.Response=j,n.fetch=H,Object.defineProperty(n,"__esModule",{value:!0})}({})}(o),o.fetch.ponyfill=!0,delete o.fetch.polyfill;var r=o;(n=r.fetch).default=r.fetch,n.fetch=r.fetch,n.Headers=r.Headers,n.Request=r.Request,n.Response=r.Response,t.exports=n}(browserPonyfill,browserPonyfill.exports);var fetch=getDefaultExportFromCjs(browserPonyfill.exports),browser="object"==typeof self?self.FormData:window.FormData;let xAtomicNumber=0;function tagAtom(t,n){let e=`${t.getAtomLabel(n)}*`;return t.setAtomCustomLabel(n,e),1===t.getAtomicNo(n)?t.setAtomicNo(n,getXAtomicNumber(t)):t.setAtomMass(n,t.getAtomMass(n)+5),e}function getXAtomicNumber(t){if(!xAtomicNumber){const n=t.getOCL();xAtomicNumber=n.Molecule.getAtomicNoFromLabel("X")}return xAtomicNumber}function addDiastereotopicMissingChirality(t,n={}){const{Molecule:e}=t.getOCL(),{esrType:o=e.cESRTypeAnd}=n;for(let n=0;n<t.getAllAtoms();n++){let r=t.getCompactCopy();tagAtom(r,n),r.ensureHelperArrays(e.cHelperBitsStereo);for(let n=0;n<r.getAtoms();n++)if(r.isAtomStereoCenter(n)&&-1===r.getStereoBond(n)){let i=r.getAtomPreferredStereoBond(n);if(-1!==i){if(t.setBondType(i,e.cBondTypeUp),t.getBondAtom(1,i)===n){let e=t.getBondAtom(0,i);t.setBondAtom(0,i,n),t.setBondAtom(1,i,e)}t.setAtomESR(n,o,0)}}}}function makeRacemic(t){const{Molecule:n}=t.getOCL();t.ensureHelperArrays(n.cHelperCIP);for(let e=0;e<t.getAllAtoms();e++)t.getAtomParity(e)!==n.cAtomParityNone&&t.setAtomESR(e,n.cESRTypeAnd,0)}function getDiastereotopicAtomIDs(t){const n=t.getOCL();addDiastereotopicMissingChirality(t);let e=t.getAllAtoms(),o=[];for(let r=0;r<e;r++){let e=t.getCompactCopy();tagAtom(e,r),makeRacemic(e),o[r]=e.getCanonizedIDCode(n.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS)}return o}function getGroupedDiastereotopicAtomIDs(t,n={}){const{atomLabel:e}=n;let o=getDiastereotopicAtomIDs(t),r={};for(let n=0;n<o.length;n++)if(!e||t.getAtomLabel(n)===e){let e=o[n];r[e]||(r[e]={counter:0,atoms:[],oclID:e,atomLabel:t.getAtomLabel(n)}),r[e].counter++,r[e].atoms.push(n)}return Object.keys(r).map((t=>r[t]))}function isCsp3(t,n){return 6===t.getAtomicNo(n)&&(0===t.getAtomCharge(n)&&t.getImplicitHydrogens(n)+t.getConnAtoms(n)===4)}const FULL_HOSE_CODE=1,HOSE_CODE_CUT_C_SP3_SP3=2;function getHoseCodesForAtom(t,n,e={}){const o=t.getOCL(),{minSphereSize:r=0,maxSphereSize:i=4,kind:a=FULL_HOSE_CODE,isTagged:s=!1}=e,u=t.getCompactCopy();if(!s){let t=tagAtom(u,n);u.addImplicitHydrogens(),u.addMissingChirality(),u.ensureHelperArrays(o.Molecule.cHelperNeighbours);for(let e=0;e<u.getAllAtoms();e++)if(t===u.getAtomCustomLabel(e)){n=e;break}}let f=new o.Molecule(0,0),l=[],c=0,h=0,w=new Array(u.getAllAtoms()),g=new Array(u.getAllAtoms());for(let t=0;t<=i;t++){if(0===h)g[0]=n,w[n]=!0,h=1;else{let t=h;for(let n=c;n<h;n++){let e=g[n];for(let n=0;n<u.getAllConnAtoms(e);n++){let o=u.getConnAtom(e,n);if(!w[o])switch(a){case FULL_HOSE_CODE:w[o]=!0,g[t++]=o;break;case HOSE_CODE_CUT_C_SP3_SP3:isCsp3(u,e)&&isCsp3(u,o)||(w[o]=!0,g[t++]=o);break;default:throw new Error("getHoseCoesForAtom unknown kind")}}}c=h,h=t}u.copyMoleculeByAtoms(f,w,!0,null),t>=r&&(makeRacemic(f),l.push(f.getCanonizedIDCode(o.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS)))}return l}function getHoseCodesFromDiastereotopicID(t,n={}){t.addImplicitHydrogens(),t.addMissingChirality();let e=-1;for(let n=0;n<t.getAllAtoms();n++){const o=t.getAtomCustomLabel(n);if(null!=o&&o.endsWith("*")){e=n;break}}if(e>=0)return n.isTagged=!0,getHoseCodesForAtom(t,e,n)}function floydWarshall(t){if(Matrix.isMatrix(t)&&t.columns!==t.rows)throw new TypeError("The adjacency matrix should be squared");const n=t.columns;let e=new Matrix(n,n);e.apply(((n,o)=>{if(n===o)e.set(n,o,0);else{let r=t.get(n,o);r?e.set(n,o,r):e.set(n,o,Number.POSITIVE_INFINITY)}}));for(let t=0;t<n;++t)for(let o=0;o<n;++o)for(let r=0;r<n;++r){let n=e.get(o,t)+e.get(t,r);e.get(o,r)>n&&e.set(o,r,n)}return e.apply(((t,n)=>{e.get(t,n)===Number.POSITIVE_INFINITY&&e.set(t,n,-1)})),e}function getConnectivityMatrix(t,n={}){const e=t.getOCL();t.ensureHelperArrays(e.Molecule.cHelperNeighbours);let o=t.getAllAtoms(),r=new Array(o).fill();if(r=r.map((()=>new Array(o).fill(0))),!n.pathLength)if(n.atomicNo)for(let n=0;n<o;n++)r[n][n]=t.getAtomicNo(n);else if(n.negativeAtomicNo)for(let n=0;n<o;n++)r[n][n]=-t.getAtomicNo(n);else if(n.mass)for(let n=0;n<o;n++)r[n][n]=e.Molecule.cRoundedMass[t.getAtomicNo(n)];else for(let t=0;t<o;t++)r[t][t]=1;if(n.sdt)for(let n=0;n<o;n++){let e=t.getAllConnAtoms(n);for(let o=0;o<e;o++)r[n][t.getConnAtom(n,o)]=t.getConnBondOrder(n,o)}else if(n.sdta)for(let n=0;n<o;n++){let e=t.getAllConnAtoms(n);for(let o=0;o<e;o++){let e=t.getConnBond(n,o);t.isAromaticBond(e)?r[n][t.getConnAtom(n,o)]=4:r[n][t.getConnAtom(n,o)]=t.getConnBondOrder(n,o)}}else for(let n=0;n<o;n++){let e=t.getAllConnAtoms(n);for(let o=0;o<e;o++)r[n][t.getConnAtom(n,o)]=1}return n.pathLength&&(r=floydWarshall(new Matrix(r)).to2DArray()),r}function signalsJoin(t,n={}){const{tolerance:e=.1}=n;for(let n of t){if(!n.diaID||1===!n.diaID.length)return t;for(let e of n.j)if(!e.diaID||1===!e.diaID.length||"d"!==e.multiplicity)return t}const o={};for(let n of t){n=signalNormalize(n),n.j=n.j.sort(((t,n)=>t.diaID+t.distance<n.diaID+n.distance?1:-1));let t=`${n.diaID[0]} ${n.j.map((t=>`${t.diaID[0]} ${t.distance}`)).sort().join(" ")}`;o[t]||(o[t]=[]),o[t].push(n)}let r=[];for(let t in o){const n=o[t],e=[];for(let t=0;t<n[0].j.length;t++)e.push({diaID:n[0].j[t].diaID,distance:n[0].j[t].distance,multiplicity:n[0].j[t].multiplicity,coupling:mean(n.map((n=>n.j[t].coupling)))});r.push({nbAtoms:sum(n.map((t=>t.nbAtoms))),delta:mean(n.map((t=>t.delta))),diaID:n[0].diaID,assignment:n.map((t=>t.assignment)).flat().filter((t=>t)),j:e})}return r=r.map((t=>((t=signalNormalize(signalJoinCouplings(t,{tolerance:e}))).j&&(t.multiplicity=t.j.reduce(((t,n)=>`${t}${n.multiplicity}`),"")),t))).sort(((t,n)=>t.delta-n.delta)),r}async function predictProton(t,n={}){const{cache:e}=n;(t=t.getCompactCopy()).addImplicitHydrogens(),addDiastereotopicMissingChirality(t);const o=t.toMolfile();let r;if(e&&(r=e(o)),void 0===r){const t=new browser;t.append("molfile",o);const n=await fetch("https://www.nmrdb.org/service/predictor",{method:"POST",body:t});r=await n.text(),e&&e(o,r)}const i=getDiastereotopicAtomIDs(t),a=protonParser(r,t,i),s=signalsJoin(a);return{molfile:o,diaIDs:i,joinedSignals:s,signals:a,ranges:signalsToRanges(s)}}function protonParser(t,n,e){let o=getConnectivityMatrix(n,{pathLength:!0}),r=t.split("\n").filter((t=>t)),i=[];for(let t of r){let n=t.split("\t"),r=n.slice(4),a=n[0]-1,s={assignment:[a],diaID:[e[a]],nbAtoms:1,delta:Number(n[2]),j:[]};for(let t=0;t<r.length;t+=3){let n=Number(r[t]-1);s.j.push({coupling:Number(r[t+2]),assignment:[n],diaID:[e[n]],multiplicity:"d",distance:o[a][n]}),s.j.sort(((t,n)=>n.coupling-t.coupling))}i.push(s)}return i}var openchemlibMinimal={};!function(t){!function(n){var e;"undefined"!=typeof self?(!0,e=self):void 0!==commonjsGlobal?(!1,e=commonjsGlobal):(!1,e=n);var o,r=e.document||{};function i(){}r.compatMode||(r.compatMode="CSS1Compat"),(o={}).setTimeout=e.setTimeout?e.setTimeout.bind(e):i,o.clearTimeout=e.clearTimeout?e.clearTimeout.bind(e):i,o.setInterval=e.setInterval?e.setInterval.bind(e):i,o.clearInterval=e.clearInterval?e.clearInterval.bind(e):i,o.Error=e.Error,o.Math=e.Math,o.RegExp=e.RegExp,o.TypeError=e.TypeError,o.document||(o.document=r),function(t,n){for(var e=Object.keys(t),o=0;o<e.length;o++)n[e[o]]=t[e[o]]}(function(t){var n=t.document,e={},o={userAgent:"webkit"};function r(){}var i=r;i.__moduleStartupDone=r;var a,s,u,f,l,c,h,w="object",g="anonymous",m="fnStack",d="\n",p={4:1,10:1,7:1},G="Unknown",b="boolean",y="number",j="string",N=2147483647,H=-17592186044416,v=17592186044416,M=4194304,A=1048575,S="__noinit__",C={4:1,10:1,16:1,7:1},x={4:1,7:1},k="null",R={4:1,13:1,20:1,17:1},I='For input string: "',D=-2147483648,F={l:0,m:0,h:524288},T=1048576,B=4096,$=16384,P={4:1,10:1,28:1,16:1,7:1,29:1},K=65536,V=65535,E=1e4,O={37:1,76:1},Y={4:1,37:1,76:1},U={8:1,4:1},L={6:1,4:1},q="fromIndex: 0, toIndex: ",J=", length: ",Q="Index: ",X=", Size: ",_="fromIndex: ",z=", toIndex: ",Z=16777215,W=.30000001192092896,tt='<line x1="',nt='" ',et='y1="',ot='x2="',rt='y2="',it='stroke="',at='stroke-width="',st='" />',ut={14:1,4:1},ft={11:1,4:1},lt=536870912,ct=2.617993878,ht=3.665191429,wt=6.283185307179586,gt=3.141592653589793,mt=1.5707963267948966,dt=8192,pt=1920,Gt=1024,bt=234881024,yt=100663296,jt=201326592,Nt=114688,Ht=4063232,vt=2097152,Mt=393216,At=29360128,St=268435456,Ct=2048,xt=-1.5707963267948966,kt=32640,Rt=1572864,It=524288,Dt=229376,Ft=1.0471975511965976,Tt=.5235987755982988,Bt=262144,$t=2.8415926535897933,Pt={25:1,4:1,10:1,7:1},Kt={4:1,16:1,7:1},Vt={4:1},Et=-16777216,Ot=131072,Yt=-1073741824,Ut=-65536,Lt="??",qt=-268435456,Jt=65011712,Qt=3072,Xt=126976,_t=17976931348623157e292,zt=67108864,Zt=134217728,Wt=16777216,tn=-66584577,nn=-3.141592653589793,en=4194303,on=.7853981633974483,rn=3.061592653589793,an=1073741824,sn={9:1,4:1,7:1},un=281.17,fn=289.19,ln=294.21,cn="0.0000",hn="M  END\n",wn="ATOMS",gn="M  END",mn="$$$$",dn="M  V30 ",pn="M  V30 COUNTS ",Gn=")\n",bn="M  V30 MDLV30/STEREL",yn="M  V30 MDLV30/STERAC",jn=34028234663852886e22,Nn=239060990,Hn='class="event" ',vn='opacity="0" />',Mn="Assignment of aromatic double bonds failed",An="Members of ESR groups must only be stereo centers with known configuration.",Sn="Ambiguous configuration at stereo center because of 2 parallel bonds",Cn=-.5235987755982988,xn=-1.0471975511965976,kn=-.7853981633974483,Rn=2.0943951023931953,In=.17453292519943295,Dn="OCL_RXN_V1.0:",Fn="'$MOL' tag not found",Tn="'M  END' not found",Bn="\nActelion Java MolfileCreator 2.0\n\n  0  0  0  0  0  0              0 V3000\n",$n="M  V30 END CTAB",Pn="Over- or under-specified stereo feature or more than one racemic type bond",Kn="undefined",Vn=.08726646502812703,En='Too many percent/per mille characters in pattern "',On=1e9,Yn="CSS1Compat",Un=5.56,Ln=11.12,qn=13.34,Jn=14.44,Qn=4294967296,Xn=152587890625e-16,_n=.3010299956639812,zn=4294967295,Zn={30:1,60:1},Wn={37:1,77:1},te=15525485,ne=5.960464477539063e-8,ee={4:1,30:1,39:1,48:1},oe="Invalid UTF8 sequence",re={},ie={},ae={},se={},ue={},fe={},le={},ce={},he={},we={},ge={},me={},de={},pe={},Ge={},be={},ye={},je={},Ne={},He={},ve={},Me={},Ae={},Se={},Ce={};function xe(){}function ke(t){return Array.isArray(t)&&t.dc===xe?ie.Cc(t):t.toString()}function Re(n,e){var o=t;if(""===n)return o;var r,i=n.split(".");(!(i[0]in o)&&o.execScript&&o.execScript("var "+i[0]),e)&&(e.prototype.bc.e=e);for(;i.length&&(r=i.shift());)o=o[r]=o[r]||!i.length&&e||{};return o}function Ie(t,n,e){var o=function(){return t.apply(o,arguments)};return n.apply(o,e),o}function De(){}function Fe(t,n){for(var e in n)n[e].configurable=!0;Object.defineProperties(t,n)}function Te(t,n,e){var o=s,r=o[t],i=re.BO(r);r&&!i?a=r:((a=re.wO(n)).cc=e,!n&&(a.dc=xe),o[t]=a);for(var u=3;u<arguments.length;++u)arguments[u].prototype=a;i&&(a.bc=i)}function Be(){}function $e(t,n){return re.JI(t,n)}function Pe(t,n,e,o,r,i){return re.NI(t,n,e,o,r,0,i)}function Ke(t,n,e,o,r,i){var a;return a=re.QI(r,o),10!=r&&Oe($e(t,i),n,e,r,a),a}function Ve(t){return Array.isArray(t)&&t.dc===xe}function Ee(t,n,e){return re.SI(t,n,e)}function Oe(t,n,e,o,r){return re.UI(r,t),r.cc=n,r.dc=xe,re.WI(r,e),re.VI(r,o),r}function Ye(t){return!Array.isArray(t)&&t.dc===xe}function Ue(t,n){return null!=t&&function(t,n){return Xe(t)?!!c[n]:t.cc?!!t.cc[n]:qe(t)?!!l[n]:!!Le(t)&&!!f[n]}(t,n)}function Le(t){return typeof t===b}function qe(t){return typeof t===y}function Je(t){return null!=t&&re._J(t)&&!(t.dc===xe)}function Qe(t,n){return re.aK(t,n)}function Xe(t){return typeof t===j}function _e(t){return null==t?null:t}function ze(t){return 0|Math.max(Math.min(t,N),-2147483648)}function Ze(t){var n;return Ue(t,17)?t:((n=re.GN(t))||(n=new ae.RG(t),se.JH(n)),n)}function We(t){return t.backingJsObject}function to(t,n){var e;return re.YN(t)&&re.YN(n)&&(e=re.MN(re.NN(t))+re.MN(re.NN(n)),H<e&&e<v)?re.SN(e):re.RN(re.vJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t),re.YN(n)?re.iO(re.NN(n)):re.LN(n)))}function no(t,n){return re.RN(re.wJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t),re.YN(n)?re.iO(re.NN(n)):re.LN(n)))}function eo(t,n){var e;return re.YN(t)&&re.YN(n)&&(e=re.MN(re.NN(t))-re.MN(re.NN(n)),!isNaN(e))?e:re.xJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t),re.YN(n)?re.iO(re.NN(n)):re.LN(n))}function oo(n,e){var o;return re.YN(n)&&re.YN(e)&&(o=re.MN(re.NN(n))/re.MN(re.NN(e)),H<o&&o<v)?re.SN(o<0?t.Math.ceil(o):t.Math.floor(o)):re.RN(re.bJ(re.YN(n)?re.iO(re.NN(n)):re.LN(n),re.YN(e)?re.iO(re.NN(e)):re.LN(e),!1))}function ro(t,n){return 0==eo(t,n)}function io(n){return H<n&&n<v?re.SN(n<0?t.Math.ceil(n):t.Math.floor(n)):re.RN(re.yJ(n))}function ao(t){return re.SN(t)}function so(t,n){return eo(t,n)>0}function uo(t,n){return eo(t,n)<0}function fo(t,n){return eo(t,n)<=0}function lo(t,n){var e;return re.YN(t)&&re.YN(n)&&(e=re.MN(re.NN(t))%re.MN(re.NN(n)),H<e&&e<v)?re.SN(e):re.RN((re.bJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t),re.YN(n)?re.iO(re.NN(n)):re.LN(n),!0),re.ZI))}function co(t,n){var e;return re.YN(t)&&re.YN(n)&&(e=re.MN(re.NN(t))*re.MN(re.NN(n)),H<e&&e<v)?re.SN(e):re.RN(re.zJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t),re.YN(n)?re.iO(re.NN(n)):re.LN(n)))}function ho(t){var n;return re.YN(t)&&(n=0-re.MN(re.NN(t)),!isNaN(n))?re.SN(n):re.RN(re.AJ(re.LN(t)))}function wo(t,n){return 0!=eo(t,n)}function go(t,n){return re.RN(re.CJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t),re.YN(n)?re.iO(re.NN(n)):re.LN(n)))}function mo(t,n){return re.RN(re.DJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t),n))}function po(t,n){return re.RN(re.EJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t),n))}function Go(t,n){return re.RN(re.FJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t),n))}function bo(t,n){var e;return re.YN(t)&&re.YN(n)&&(e=re.MN(re.NN(t))-re.MN(re.NN(n)),H<e&&e<v)?re.SN(e):re.RN(re.GJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t),re.YN(n)?re.iO(re.NN(n)):re.LN(n)))}function yo(t){var n;return re.YN(t)?-0==(n=re.MN(re.NN(t)))?0:n:re.HJ(re.LN(t))}function jo(t){return re.YN(t)?re.ON(re.MN(re.NN(t))):re.IJ(re.LN(t))}function No(t){return re.YN(t)?""+re.MN(re.NN(t)):re.JJ(re.LN(t))}function Ho(t,n){return re.RN(re.KJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t),re.YN(n)?re.iO(re.NN(n)):re.LN(n)))}function vo(t){var n;return n=ie.iQ(t),ie.vQ(t,n),n}function Mo(t,n){var e;return e=ie.iQ(t),ie.vQ(t,e),e.f=n?8:0,e}function Ao(t){var n;return(n=ie.iQ(t)).k=t,n.f=1,n}re.FN=function(){},re.qO=function(){null==u&&(u=[])},re.oO=function(){},re.CO=function(t){function n(){}return n.prototype=t||{},new n},re.BO=function(t){return t instanceof Array?t[0]:null},re.wO=function(t){var n=t&&t.prototype;return!n&&(n=s[t]),re.CO(n)},re.uO=function(){},t.goog=t.goog||{},t.goog.global=t.goog.global||t,s={},!Array.isArray&&(Array.isArray=function(t){return"[object Array]"===Object.prototype.toString.call(t)}),!Date.now&&(Date.now=function(){return(new Date).getTime()}),ie.rc=function(t,n){return _e(t)===_e(n)},ie.sc=function(t){return t.bc},ie.tc=function(t){return le.Z$(t)},ie.wc=function(t,n){return Xe(t)?ie.GR(t,n):qe(t)?ie.FQ(t,n):Le(t)?ie.NP(t,n):Ye(t)?t.gb(n):Ve(t)?ie.rc(t,n):ae.XG(t,n)},ie.yc=function(t){return Xe(t)?ie.IR():qe(t)?ie.GQ():Le(t)?ie.OP():Ye(t)?t.bc:Ve(t)?ie.sc(t):ae.YG(t)},ie.Ac=function(t){return Xe(t)?ie.JR(t):qe(t)?ie.HQ(t):Le(t)?ie.PP(t):Ye(t)?t.ib():Ve(t)?ie.tc(t):ae.ZG(t)},ie.Cc=function(t){return ie.dQ(ie.yc(t))+"@"+le.V$(ie.mR(ie.Ac(t))).toString(16)},Te(1,null,{},Be),a.gb=function(t){return ie.rc(this,t)},a.hb=function(){return ie.sc(this)},a.ib=function(){return ie.tc(this)},a.jb=function(){return ie.dQ(ie.yc(this))+"@"+le.V$(ie.mR(ie.Ac(this))).toString(16)},a.equals=function(t){return this.gb(t)},a.hashCode=function(){return this.ib()},a.toString=function(){return this.jb()},ae.XG=function(t,n){return ae.bH(t)?ae.$G(t,n):_e(t)===_e(n)},ae.YG=function(t){return t.bc||Array.isArray(t)&&$e(re.yL,1)||re.yL},ae.ZG=function(t){return ae.cH(t)?ae._G(t):le.Z$(t)},ae.$G=function(t,n){return t.equals(n)},ae._G=function(t){return t.hashCode()},ae.aH=function(){return[]},ae.bH=function(t){return!!t&&!!t.equals},ae.cH=function(t){return!!t&&!!t.hashCode},ae.dH=function(t){return t.toString?t.toString():"[JavaScriptObject]"},se.IH=function(){var t,n;se.IH=De,n=!se.RH(),t=new se._H,se.HH=n?new se.SH:t},se.JH=function(t){se.IH(),se.HH.Fb(t)},se.KH=function(t){var n;return se.IH(),n=se.HH.Gb(t),se.LH(n)},se.LH=function(n){var e;for("JH","zG",e=t.Math.min(n.length,5)-1;e>=0;e--)if(ie.GR(n[e].d,"JH")||ie.GR(n[e].d,"zG")){n.length>=e+1&&le.V$(n).splice(0,e+1);break}return n},se.MH=function(t){var n=/function(?:\s+([\w$]+))?\s*\(/.exec(t);return n&&n[1]||g},se.NH=function(t){return se.IH(),t&&t[m]?t[m]:[]},se.OH=function(t){return se.IH(),t.name||(t.name=se.MH(t.toString()))},se.PH=function(t){return se.IH(),parseInt(t)||-1},se.QH=function(t){se.IH();var n=t.backingJsObject;if(n&&n.stack){var e=n.stack,o=n+d;return e.substring(0,o.length)==o&&(e=e.substring(o.length)),e.split(d)}return[]},se.RH=function(){return Error.stackTraceLimit>0?(t.Error.stackTraceLimit=Error.stackTraceLimit=64,!0):"stack"in new Error},Te(206,1,{}),se.SH=function(){},Te(154,206,{},se.SH),a.Fb=function(t){var n={},e=[];t[m]=e;for(var o=arguments.callee.caller;o;){var r=se.OH(o);e.push(r);var i,a,s=":"+r,u=n[s];if(u)for(i=0,a=u.length;i<a;i++)if(u[i]===o)return;(u||(n[s]=[])).push(o),o=o.caller}},a.Gb=function(t){var n,e,o,r;for(o=se.NH(t),e=ae.iH(o),r=Ke(re.pM,p,49,e,0,1),n=0;n<e;n++)r[n]=new ie.wR(ae.hH(o,n),null,-1);return r},se.VH=function(t,n){var e,o,r,i,a,s,u,f,l;return f="",0==le.V$(n).length?t.Hb(G,g,-1,-1):(l=ie.TR(n),ie.GR(le.V$(l).substr(0,3),"at ")&&(l=le.V$(l).substr(3)),l=se.WH(l),-1==(a=le.V$(l).indexOf("("))?-1==(a=le.V$(l).indexOf("@"))?(f=l,l=""):(f=ie.TR(le.V$(l).substr(a+1)),l=ie.TR(le.V$(l).substr(0,a))):(e=le.V$(l).indexOf(")",a),f=le.V$(l).substr(a+1,e-(a+1)),l=ie.TR(le.V$(l).substr(0,a))),-1!=(a=ie.KR(l,Fo(46)))&&(l=le.V$(l).substr(a+1)),(0==le.V$(l).length||ie.GR(l,"Anonymous function"))&&(l=g),s=ie.NR(f,Fo(58)),r=ie.OR(f,Fo(58),s-1),u=-1,o=-1,i=G,-1!=s&&-1!=r&&(i=le.V$(f).substr(0,r),u=se.PH(le.V$(f).substr(r+1,s-(r+1))),o=se.PH(le.V$(f).substr(s+1))),t.Hb(i,l,u,o))},se.WH=function(t){return t.replace(/\[.*?\]/g,"")},Te(207,206,{}),a.Fb=function(t){},a.Hb=function(t,n,e,o){return new ie.wR(n,t+"@"+o,e<0?-1:e)},a.Gb=function(t){var n,e,o,r,i,a;if(r=se.QH(t),i=Ke(re.pM,p,49,0,0,1),n=0,0==(o=ae.iH(r)))return i;for(a=se.VH(this,ae.hH(r,0)),ie.GR(a.d,g)||(i[n++]=a),e=1;e<o;e++)i[n++]=se.VH(this,ae.hH(r,e));return i},se._H=function(){},Te(155,207,{},se._H),a.Hb=function(t,n,e,o){return new ie.wR(n,t,-1)},re.HI=function(t){return t},re.JI=function(t,n){return ie.nQ(t,n)},re.KI=function(t){return null==t.__elementTypeCategory$?10:t.__elementTypeCategory$},re.LI=function(t){return t.__elementTypeId$},re.NI=function(t,n,e,o,r,i,a){var s,u,f,l,c;if(l=r[i],s=(f=i==a-1)?o:0,c=re.QI(s,l),10!=o&&Oe($e(t,a-i),n[i],e[i],s,c),!f)for(++i,u=0;u<l;++u)re.SI(c,u,re.NI(t,n,e,o,r,i,a));return c},re.QI=function(t,n){var e,o=new Array(n);switch(t){case 14:case 15:e=0;break;case 16:e=!1;break;default:return o}for(var r=0;r<n;++r)o[r]=e;return o},re.SI=function(t,n,e){return t[n]=e},re.UI=function(t,n){t.bc=n},re.VI=function(t,n){t.__elementTypeCategory$=n},re.WI=function(t,n){t.__elementTypeId$=n},re.YI=function(t,n){return 10!=re.KI(n)&&Oe(ie.yc(n),n.cc,re.LI(n),re.KI(n),t),re.HI(t)},re._J=function(t){return typeof t===w||"function"==typeof t},re.aK=function(t,n){return t&&n&&t instanceof n},re.GN=function(t){return t&&t.__java$exception},re.LN=function(t){return t},re.MN=function(t){return t},re.NN=function(t){return t},re.ON=function(t){return 0|t},re.QN=function(t){return t},re.RN=function(t){var n;return 0==(n=re.fJ(t))?re.SN(re.gJ(t)+re.hJ(t)*M):n==A?re.SN(re.gJ(t)+re.hJ(t)*M-v):re.QN(t)},re.SN=function(t){return t},re.YN=function(t){return typeof t===y},re.iO=function(t){var n,e,o,r;return o=0,(r=re.MN(t))<0&&(r+=v,o=A),e=ze(r/M),n=ze(r-e*M),re.aJ(n,e,o)},ie.gG=function(t){t.g=Ke(re.pM,p,49,0,0,1)},ie.hG=function(t){se.JH(t)},ie.iG=function(t){return se.KH(t)},ie.jG=function(t){return t.j&&(t.backingJsObject!==S&&t.Db(),t.g=null),t},ie.kG=function(t){return t.e},ie.lG=function(t,e){if(e instanceof Object)try{if(e.__java$exception=t,-1!=o.userAgent.toLowerCase().indexOf("msie")&&n.documentMode<9)return;var r=t;Object.defineProperties(e,{cause:{get:function(){var t=r.Bb();return t&&t.zb()}},suppressed:{get:function(){return r.Ab()}}})}catch(t){}},ie.mG=function(t,n,e){var o,r,i,a,s;for(ie.nG(t),null==t.i&&(t.i=Ke(re.wM,p,17,0,0,1)),i=0,a=(r=t.i).length;i<a;++i)o=r[i],ie.mG(o,n,"\t"+e);(s=t.e)&&ie.mG(s,n,e)},ie.nG=function(t){var n,e;for(null==t.g&&(t.g=ie.iG(t)),n=0,e=t.g.length;n<e;++n);},ie.oG=function(t,n){t.backingJsObject=n,ie.lG(t,n)},ie.pG=function(t){return ie.qG(t,t.Cb())},ie.qG=function(t,n){var e;return e=ie.dQ(t.bc),null==n?e:e+": "+n},ie.rG=function(){ie.gG(this),ie.jG(this),this.Db()},ie.sG=function(t){ie.gG(this),this.f=t,ie.jG(this),this.Db()},ie.uG=function(t){if(!("stack"in t))try{throw t}catch(t){}return t},Te(17,1,{4:1,17:1}),a.yb=function(t){return new Error(t)},a.zb=function(){return this.backingJsObject},a.Ab=function(){var t,n;return(t=fe.h$((n=fe.g$(ue.hX((null==this.i&&(this.i=Ke(re.wM,p,17,0,0,1)),this.i)),new ie.qS),fe.TZ(new fe.a$,new fe._Z,new fe.b$,Oe($e(re.oN,1),C,58,0,[(fe.XZ(),fe.VZ)])),n),new ue.gi)).nb(Ke(re.nM,x,1,t.size(),5,1))},a.Bb=function(){return ie.kG(this)},a.Cb=function(){return this.f},a.Db=function(){ie.oG(this,ie.uG(this.yb(ie.qG(this,this.f)))),ie.hG(this)},a.jb=function(){return ie.pG(this)},a.backingJsObject=S,a.j=!0,ie.CG=function(){ie.rG.call(this)},ie.DG=function(t){ie.gG(this),ie.jG(this),this.backingJsObject=t,ie.lG(this,t),this.f=null==t?k:ke(t)},ie.EG=function(t){ie.sG.call(this,t)},Te(13,17,{4:1,13:1,17:1},ie.EG),ie.FG=function(){ie.CG.call(this)},ie.GG=function(t){ie.DG.call(this,t)},ie.HG=function(t){ie.EG.call(this,t)},Te(20,13,R),ie.FP=function(){ie.FG.call(this)},ie.GP=function(t){ie.HG.call(this,t)},Te(53,20,R,ie.FP,ie.GP),ie.HP=function(){ie.FP.call(this)},ie.IP=function(t){ie.GP.call(this,t)},Te(88,53,R,ie.HP,ie.IP),ie.KP=function(){ie.KP=De,h=le.V$(!1),le.V$(!0)},ie.LP=function(t,n){return function(t,n){return ie.KP(),t==n?0:t?1:-1}(le.W$((le.M$(t),t)),le.W$((le.M$(n),n)))},ie.MP=function(t,n){return ie.LP(t,n)},ie.NP=function(t,n){return le.M$(t),_e(t)===_e(n)},ie.OP=function(){return re._L},ie.PP=function(t){return le.W$((le.M$(t),t))?1231:1237},ie.SP=function(t,n){return ie.KP(),Xe(t)?ie.BR(t,n):qe(t)?ie.EQ(t,n):Le(t)?ie.MP(t,n):t.lb(n)},f={4:1,151:1,30:1},ie.bQ=function(t){t.i=So++},ie.cQ=function(t){null==t.n&&ie.rQ(t)},ie.dQ=function(t){return ie.cQ(t),t.n},ie.eQ=function(t){return 0!=(4&t.f)},ie.fQ=function(t){return 0!=(1&t.f)},ie.gQ=function(){ie.bQ(this),this.n=null,this.j=null,this.g=null,this.d=null,this.b=null,this.k=null,this.a=null},ie.iQ=function(t){var n;return(n=new ie.gQ).n="Class$"+(t?"S"+t:""+n.i),n.b=n.n,n.j=n.n,n},ie.nQ=function(t,n){var e=t.a=t.a||[];return e[n]||(e[n]=t.Ib(n))},ie.rQ=function(t){if(t.Mb()){var n=t.c;return n.Nb()?t.n="["+n.k:n.Mb()?t.n="["+n.Kb():t.n="[L"+n.Kb()+";",t.b=n.Jb()+"[]",void(t.j=n.Lb()+"[]")}var e=t.g,o=t.d;o=o.split("/"),t.n=ie.uQ(".",[e,ie.uQ("$",o)]),t.b=ie.uQ(".",[e,ie.uQ(".",o)]),t.j=o[o.length-1]},ie.uQ=function(t,n){for(var e=0;!n[e]||""==n[e];)e++;for(var o=n[e++];e<n.length;e++)n[e]&&""!=n[e]&&(o+=t+n[e]);return o},ie.vQ=function(t,n){if(t){n.k=t;var e=function(t){if(t.Nb())return null;var n=t.k;return s[n]}(n);e?e.bc=n:s[t]=[n]}},Te(102,1,{},ie.gQ),a.Ib=function(t){var n;return(n=new ie.gQ).f=4,n.c=t>1?ie.nQ(this,t-1):this,n},a.Jb=function(){return ie.cQ(this),this.b},a.Kb=function(){return ie.dQ(this)},a.Lb=function(){return ie.cQ(this),this.j},a.Mb=function(){return ie.eQ(this)},a.Nb=function(){return ie.fQ(this)},a.jb=function(){return(0!=(2&this.f)?"interface ":0!=(1&this.f)?"":"class ")+(ie.cQ(this),this.n)},a.f=0,a.i=0;var So=1;function Co(t,n){return t<n?-1:t>n?1:t==n?0==t?Co(1/t,1/n):0:isNaN(t)?isNaN(n)?0:1:-1}function xo(t){var n,e,o,r,i,a;if(isNaN(t))return{l:0,m:0,h:524160};if(a=!1,0==t)return 1/t==-1/0?F:0;if(t<0&&(a=!0,t=-t),!isNaN(t)&&!isFinite(t))return a?{l:0,m:0,h:1048320}:{l:0,m:0,h:524032};if(e=0,t<1){for(n=512,o=0;o<10;++o,n>>=1)t<(ie.NQ(),ie.LQ)[o]&&e-n>=-1023&&(t*=ie.MQ[o],e-=n);t<1&&e-1>=-1023&&(t*=2,--e)}else if(t>=2)for(n=512,o=0;o<10;++o,n>>=1)t>=(ie.NQ(),ie.MQ)[o]&&(t*=ie.LQ[o],e+=n);return e>-1023?t-=1:t*=.5,r=io(t*T),i=io(4503599627370496*(t-=9.5367431640625e-7*yo(r))),r=go(r,re.SN(e+1023<<20)),a&&(r=go(r,2147483648)),go(mo(r,32),i)}function ko(t,n){this.a=t,this.b=n}function Ro(t){return t=((t=((t-=t>>1&1431655765)>>2&858993459)+(858993459&t))>>4)+t&252645135,t+=t>>8,63&(t+=t>>16)}function Io(t){var n,e,o;return t<0?0:0==t?32:(e=16-(n=(o=-(t>>16))>>16&16),e+=n=(o=(t>>=n)-256)>>16&8,e+=n=(o=(t<<=n)-B)>>16&4,(e+=n=(o=(t<<=n)-$)>>16&2)+2-(n=(o=(t<<=n)>>14)&~(o>>1)))}function Do(t){var n,e;if(0==t)return 32;for(e=0,n=1;0==(n&t);n<<=1)++e;return e}function Fo(t){var n,e;return t>=K?(n=55296+(t-K>>10&1023)&V,e=56320+(t-K&1023)&V,String.fromCharCode(n)+""+String.fromCharCode(e)):String.fromCharCode(t&V)}ie.AQ=function(n){return ie.GR(y,typeof n)||Qe(n,t.java.lang.Number$impl)},ie.BQ=function(t){if(null==ie.zQ&&(ie.zQ=new RegExp("^\\s*[+-]?(NaN|Infinity|((\\d+\\.?\\d*)|(\\.\\d+))([eE][+-]?\\d+)?[dDfF]?)\\s*$")),!ie.zQ.test(t))throw We(new ie.vR(I+t+'"'));return parseFloat(t)},ie.CQ=function(t){var n,e,o,r;if(null==t)throw We(new ie.vR(k));for(n=(o=le.V$(t).length)>0&&(le.S$(0,le.V$(t).length),45==le.V$(t).charCodeAt(0)||(le.S$(0,le.V$(t).length),43==le.V$(t).charCodeAt(0)))?1:0;n<o;n++)if(-1==Ko((le.S$(n,le.V$(t).length),le.V$(t).charCodeAt(n))))throw We(new ie.vR(I+t+'"'));if(e=(r=parseInt(t,10))<D,isNaN(r))throw We(new ie.vR(I+t+'"'));if(e||r>N)throw We(new ie.vR(I+t+'"'));return r},Te(73,1,{4:1,73:1}),ie.DQ=function(t,n){return Co(le.X$((le.M$(t),t)),le.X$((le.M$(n),n)))},ie.EQ=function(t,n){return ie.DQ(t,n)},ie.FQ=function(t,n){return le.M$(t),_e(t)===_e(n)},ie.GQ=function(){return re.bM},ie.HQ=function(t){return ze(le.X$((le.M$(t),t)))},l={4:1,30:1,152:1,73:1},ie.OQ=function(t,n){return t.b-n.b},ie.PQ=function(t){return null!=t.a?t.a:""+t.b},ie.QQ=function(t){return t.b},Te(39,1,{4:1,30:1,39:1}),a.lb=function(t){return ie.OQ(this,t)},a.compareTo=function(t){return ie.OQ(this,t)},a.equals=function(t){return this===t},a.gb=function(t){return this.equals(t)},a.hashCode=function(){return le.Z$(this)},a.ib=function(){return this.hashCode()},a.name=function(){return ie.PQ(this)},a.ordinal=function(){return ie.QQ(this)},a.toString=function(){return null!=this.a?this.a:""+this.b},a.jb=function(){return this.toString()},a.b=0,ie.$Q=function(){ie.FG.call(this)},ie._Q=function(t){ie.HG.call(this,t)},Te(26,20,R,ie.$Q,ie._Q),ie.aR=function(){ie.FG.call(this)},ie.bR=function(){ie.HG.call(this,"Stream already terminated, can't be modified or used")},Te(118,20,R,ie.aR,ie.bR),ie.cR=function(t,n){return function(t,n){return t<n?-1:t>n?1:0}(t.a,n.a)},ie.dR=function(t){this.a=t},ie.mR=function(t){return t>>>0},ie.nR=function(t){var n,e;return t>-129&&t<128?(n=t+128,!(e=(ie.pR(),ie.oR)[n])&&(e=ie.oR[n]=new ie.dR(t)),e):new ie.dR(t)},Te(36,73,{4:1,30:1,36:1,73:1},ie.dR),a.lb=function(t){return ie.cR(this,t)},a.gb=function(t){return Ue(t,36)&&t.a==this.a},a.ib=function(){return this.a},a.jb=function(){return""+this.a},a.a=0,ie.IG=function(){ie.FG.call(this)},ie.JG=function(t){ie.GG.call(this,t)},ie.KG=function(t){ie.HG.call(this,t)},Te(67,20,R,ie.JG),Te(251,1,{}),ie.rR=function(){ie.IG.call(this)},ie.sR=function(t){ie.JG.call(this,t)},ie.tR=function(t){ie.KG.call(this,t)},Te(87,67,R,ie.rR,ie.sR,ie.tR),a.yb=function(t){return new TypeError(t)},ie.AR=function(t,n){return le.S$(n,le.V$(t).length),le.V$(t).charCodeAt(n)},ie.BR=function(t,n){return ie.CR(t,n)},ie.CR=function(t,n){var e,o;return(e=le.X$((le.M$(t),t)))==(o=le.X$((le.M$(n),n)))?0:e<o?-1:1},ie.DR=function(t,n){return ie.CR(le.V$(t).toLowerCase(),le.V$(n).toLowerCase())},ie.ER=function(t,n){return le.M$(t),t+""+(le.M$(n),n)},ie.FR=function(t){var n;return ie.XR(le.D$(t,0,(n=t.length,le.A$(),n)))},ie.GR=function(t,n){return le.M$(t),_e(t)===_e(n)},ie.HR=function(t,n){return le.M$(t),null!=n&&(!!ie.GR(t,n)||le.V$(t).length==le.V$(n).length&&ie.GR(le.V$(t).toLowerCase(),le.V$(n).toLowerCase()))},ie.IR=function(){return re.uM},ie.JR=function(t){return le.e_(t)},ie.KR=function(t,n){return le.V$(t).indexOf(n)},ie.LR=function(t,n,e){return le.V$(t).indexOf(n,e)},ie.NR=function(t,n){return le.V$(t).lastIndexOf(n)},ie.OR=function(t,n,e){return le.V$(t).lastIndexOf(n,e)},ie.PR=function(t,n){return n=ie.WR(n),le.V$(t).replace(new RegExp('width="\\d+px" height="\\d+px" viewBox="0 0 \\d+ \\d+"',"g"),n)},ie.QR=function(t){var n,e,o,r,i,a,s,u;for(n=new RegExp(" ","g"),s=Ke(re.uM,P,2,0,6,1),e=0,u=t,r=null;;){if(null==(a=n.exec(u))||""==u){s[e]=u;break}i=a.index,s[e]=le.V$(u).substr(0,i),u=ie.SR(u,i+le.V$(le.V$(a)[0]).length,le.V$(u).length),n.lastIndex=0,r==u&&(s[e]=le.V$(u).substr(0,1),u=le.V$(u).substr(1)),r=u,++e}if(le.V$(t).length>0){for(o=s.length;o>0&&""==s[o-1];)--o;o<s.length&&(le.V$(s).length=o)}return s},ie.RR=function(t,n){return le.V$(t).substr(n)},ie.SR=function(t,n,e){return le.V$(t).substr(n,e-n)},ie.TR=function(t){var n,e,o;for(e=le.V$(t).length,o=0;o<e&&(le.S$(o,le.V$(t).length),le.V$(t).charCodeAt(o)<=32);)++o;for(n=e;n>o&&(le.S$(n-1,le.V$(t).length),le.V$(t).charCodeAt(n-1)<=32);)--n;return o>0||n<e?le.V$(t).substr(o,n-o):t},ie.UR=function(t){return String.fromCharCode.apply(null,t)},ie.WR=function(t){var n;for(n=0;0<=(n=le.V$(t).indexOf("\\",n));)le.S$(n+1,le.V$(t).length),t=36==le.V$(t).charCodeAt(n+1)?le.V$(t).substr(0,n)+"$"+ie.RR(t,++n):le.V$(t).substr(0,n)+""+ie.RR(t,++n);return t},ie.XR=function(t){return ie.YR(t,0,t.length)},ie.YR=function(n,e,o){var r,i,a,s;for(a=e+o,le.R$(e,a,n.length),s="",i=e;i<a;)r=t.Math.min(i+E,a),s+=ie.UR(le.V$(n).slice(i,r)),i=r;return s},c={4:1,104:1,30:1,2:1},ie.mS=function(t){ie.GP.call(this,t)},Te(119,53,R,ie.mS),ie.qS=function(){},Te(130,1,{},ie.qS),ie.rS=function(){ie.FG.call(this)},ie.sS=function(t){ie.HG.call(this,t)},Te(59,20,R,ie.rS,ie.sS),ue.ih=function(t,n,e){var o,r;for(r=t.mb();r.Ob();)if(o=r.Pb(),_e(n)===_e(o)||null!=n&&ie.wc(n,o))return e&&r.Qb(),!0;return!1},ue.jh=function(t,n){var e,o;for(le.M$(n),o=n.mb();o.Ob();)if(e=o.Pb(),!t.contains(e))return!1;return!0},ue.kh=function(t,n){var e,o,r;for(le.M$(n),e=!1,o=t.mb();o.Ob();)r=o.Pb(),n.contains(r)&&(o.Qb(),e=!0);return e},ue.lh=function(t){var n,e,o;for(o=new ue.gY("[","]"),e=t.mb();e.Ob();)n=e.Pb(),ue.eY(o,_e(n)===_e(t)?"(this Collection)":null==n?k:ke(n));return o.a?0==le.V$(o.e).length?o.a.a:o.a.a+""+o.e:o.c},Te(208,1,{37:1}),a.add=function(t){throw We(new ie.sS("Add not supported on this collection"))},a.addAll=function(t){var n,e,o;for(le.M$(t),n=!1,o=t.mb();o.Ob();)e=o.Pb(),n|=this.add(e);return n},a.clear=function(){var t;for(t=this.mb();t.Ob();)t.Pb(),t.Qb()},a.contains=function(t){return ue.ih(this,t,!1)},a.containsAll=function(t){return ue.jh(this,t)},a.isEmpty=function(){return 0==this.size()},a.remove=function(t){return ue.ih(this,t,!0)},a.removeAll=function(t){return ue.kh(this,t)},a.retainAll=function(t){var n,e,o;for(le.M$(t),n=!1,e=this.mb();e.Ob();)o=e.Pb(),t.contains(o)||(e.Qb(),n=!0);return n},a.toArray=function(){return this.nb(Ke(re.nM,x,1,this.size(),5,1))},a.nb=function(t){var n,e,o,r;for(r=this.size(),t.length<r&&(t=le.z$(new Array(r),t)),o=t,e=this.mb(),n=0;n<r;++n)Ee(o,n,e.Pb());return t.length>r&&re.SI(t,r,null),t},a.jb=function(){return ue.lh(this)},ue.yh=function(t,n,e){return new ue.YU(t,n,e)},Te(209,208,O),a.addAtIndex=function(t,n){throw We(new ie.sS("Add not supported on this list"))},a.add=function(t){return this.addAtIndex(this.size(),t),!0},a.addAllAtIndex=function(t,n){var e,o,r;for(le.M$(n),e=!1,r=n.mb();r.Ob();)o=r.Pb(),this.addAtIndex(t++,o),e=!0;return e},a.clear=function(){this.ob(0,this.size())},a.gb=function(t){var n,e,o,r,i;if(t===this)return!0;if(!Ue(t,76))return!1;if(i=t,this.size()!=i.size())return!1;for(r=i.mb(),e=this.mb();e.Ob();)if(n=e.Pb(),o=r.Pb(),!(_e(n)===_e(o)||null!=n&&ie.wc(n,o)))return!1;return!0},a.ib=function(){return ue.sX(this)},a.indexOf=function(t){var n,e;for(n=0,e=this.size();n<e;++n)if(ue.EX(t,this.getAtIndex(n)))return n;return-1},a.mb=function(){return new ue.RU(this)},a.lastIndexOf=function(t){var n;for(n=this.size()-1;n>-1;--n)if(ue.EX(t,this.getAtIndex(n)))return n;return-1},a.removeAtIndex=function(t){throw We(new ie.sS("Remove not supported on this list"))},a.ob=function(t,n){var e,o;for(o=new ue.WU(this,t),e=t;e<n;++e)le.K$(o.a<o.c.size()),o.c.getAtIndex(o.b=o.a++),ue.QU(o)},a.setAtIndex=function(t,n){throw We(new ie.sS("Set not supported on this list"))},a.subList=function(t,n){return ue.yh(this,t,n)},ue.zX=function(){throw We(new ie.rS)},ue.NU=function(t){},ue.OU=function(t){return t.a<t.c.size()},ue.PU=function(t){return le.K$(t.a<t.c.size()),t.c.getAtIndex(t.b=t.a++)},ue.QU=function(t){le.Q$(-1!=t.b),t.c.removeAtIndex(t.b),t.a=t.b,t.b=-1},ue.RU=function(t){this.c=t,ue.NU(this)},Te(112,1,{},ue.RU),a.Ob=function(){return ue.OU(this)},a.Pb=function(){return ue.PU(this)},a.Qb=function(){ue.QU(this)},a.a=0,a.b=-1,ue.VU=function(t){ue.QU(t)},ue.WU=function(t,n){ue.RU.call(this,t),le.O$(n,t.size()),this.a=n},Te(113,112,{},ue.WU),a.Qb=function(){ue.VU(this)},ue.YU=function(t,n,e){le.P$(n,e,t.size()),this.c=t,this.a=n,this.b=e-n},Te(114,209,O,ue.YU),a.addAtIndex=function(t,n){le.O$(t,this.b),this.c.addAtIndex(this.a+t,n),++this.b},a.getAtIndex=function(t){return le.L$(t,this.b),this.c.getAtIndex(this.a+t)},a.removeAtIndex=function(t){var n;return le.L$(t,this.b),n=this.c.removeAtIndex(this.a+t),--this.b,n},a.setAtIndex=function(t,n){return le.L$(t,this.b),this.c.setAtIndex(this.a+t,n)},a.size=function(){return this.b},a.a=0,a.b=0,ue.Mh=function(t){t.a=Ke(re.nM,x,1,0,5,1)},ue.Nh=function(t,n,e){le.O$(n,t.a.length),le.w$(t.a,n,e)},ue.Oh=function(t,n){return t.a[t.a.length]=n,!0},ue.Ph=function(t,n,e){var o;return le.O$(n,t.a.length),0!=(o=e.toArray()).length&&(le.x$(t.a,n,o),!0)},ue.Qh=function(t,n){var e;return 0!=(e=n.toArray()).length&&(le.x$(t.a,t.a.length,e),!0)},ue.Rh=function(t){t.a=Ke(re.nM,x,1,0,5,1)},ue.Sh=function(t,n){return-1!=ue.Vh(t,n,0)},ue.Th=function(t,n){return le.L$(n,t.a.length),t.a[n]},ue.Uh=function(t,n){return ue.Vh(t,n,0)},ue.Vh=function(t,n,e){for(;e<t.a.length;++e)if(ue.EX(n,t.a[e]))return e;return-1},ue.Wh=function(t){return 0==t.a.length},ue.Xh=function(t){return new ue.KW(t)},ue.Yh=function(t,n){return ue.Zh(t,n,t.a.length-1)},ue.Zh=function(t,n,e){for(;e>=0;--e)if(ue.EX(n,t.a[e]))return e;return-1},ue.$h=function(t,n){var e;return le.L$(n,t.a.length),e=t.a[n],le.y$(t.a,n,1),e},ue._h=function(t,n){var e;return-1!=(e=ue.Vh(t,n,0))&&(ue.$h(t,e),!0)},ue.ai=function(t,n,e){var o;le.P$(n,e,t.a.length),o=e-n,le.y$(t.a,n,o)},ue.bi=function(t,n,e){var o;return le.L$(n,t.a.length),o=t.a[n],t.a[n]=e,o},ue.ci=function(t){return t.a.length},ue.di=function(t,n){ue.eX(t.a,t.a.length,n)},ue.ei=function(t){return le.u$(t.a,t.a.length)},ue.fi=function(t,n){var e,o;for(o=t.a.length,n.length<o&&(n=le.z$(new Array(o),n)),e=0;e<o;++e)Ee(n,e,t.a[e]);return n.length>o&&re.SI(n,o,null),n},ue.gi=function(){ue.Mh(this)},Te(18,209,Y,ue.gi),a.addAtIndex=function(t,n){ue.Nh(this,t,n)},a.add=function(t){return ue.Oh(this,t)},a.addAllAtIndex=function(t,n){return ue.Ph(this,t,n)},a.addAll=function(t){return ue.Qh(this,t)},a.clear=function(){ue.Rh(this)},a.contains=function(t){return ue.Sh(this,t)},a.getAtIndex=function(t){return ue.Th(this,t)},a.indexOf=function(t){return ue.Uh(this,t)},a.isEmpty=function(){return ue.Wh(this)},a.mb=function(){return ue.Xh(this)},a.lastIndexOf=function(t){return ue.Yh(this,t)},a.removeAtIndex=function(t){return ue.$h(this,t)},a.remove=function(t){return ue._h(this,t)},a.ob=function(t,n){ue.ai(this,t,n)},a.setAtIndex=function(t,n){return ue.bi(this,t,n)},a.size=function(){return ue.ci(this)},a.toArray=function(){return ue.ei(this)},a.nb=function(t){return ue.fi(this,t)},ue.HW=function(t){},ue.IW=function(t){return t.a<t.c.a.length},ue.JW=function(t){return le.K$(t.a<t.c.a.length),t.b=t.a++,t.c.a[t.b]},ue.KW=function(t){this.c=t,ue.HW(this)},Te(19,1,{},ue.KW),a.Ob=function(){return ue.IW(this)},a.Pb=function(){return ue.JW(this)},a.Qb=function(){le.Q$(-1!=this.b),ue.$h(this.c,this.a=this.b),this.b=-1},a.a=0,a.b=-1,ue.OW=function(t,n){return le.J$(n),ue.QW(t,Ke(re.dK,U,5,n,15,1),n)},ue.PW=function(t,n){return le.J$(n),ue.QW(t,Ke(re.hK,L,5,n,15,1),n)},ue.QW=function(n,e,o){var r,i;return i=le.V$(n).length,r=t.Math.min(o,i),le.v$(n,0,e,0,r,!0),e},ue.RW=function(t){ue.UW(t,t.length)},ue.SW=function(t){ue.VW(t,t.length,-1)},ue.TW=function(t){ue.WW(t,t.length)},ue.UW=function(t,n){var e;for(e=0;e<n;++e)t[e]=-1},ue.VW=function(t,n,e){var o;for(o=0;o<n;++o)t[o]=e},ue.WW=function(t,n){var e;for(e=0;e<n;++e)t[e]=0},ue.XW=function(t,n){var e;for(e=0;e<n;++e)t[e]=!1},ue.YW=function(t){var n,e,o,r,i;for(i=1,o=0,r=(e=t).length;o<r;++o)i=31*i+(null!=(n=e[o])?ie.Ac(n):0),i|=0;return i},ue.ZW=function(t,n,e,o){var r,i,a;for(r=n+1;r<e;++r)for(i=r;i>n&&o.kb(t[i-1],t[i])>0;--i)a=t[i],re.SI(t,i,t[i-1]),re.SI(t,i-1,a)},ue.$W=function(t,n,e,o,r,i,a,s){var u;for(u=e;i<a;)u>=o||n<e&&s.kb(t[n],t[u])<=0?Ee(r,i++,t[n++]):Ee(r,i++,t[u++])},ue._W=function(t,n,e,o){var r;ue.uX(),o=o||ue.tX,r=le.V$(t).slice(n,e),ue.aX(r,t,n,e,-n,o)},ue.aX=function(t,n,e,o,r,i){var a,s,u;if(o-e<7)ue.ZW(n,e,o,i);else if(u=(s=e+r)+((a=o+r)-s>>1),ue.aX(n,t,s,u,-r,i),ue.aX(n,t,u,a,-r,i),i.kb(t[u-1],t[u])<=0)for(;e<o;)Ee(n,e++,t[s++]);else ue.$W(t,s,u,a,n,e,o,i)},ue.bX=function(t,n,e){var o;o=le.V$(t).slice(0,n),le.V$(o).sort(e),le.v$(o,0,t,0,n,!0)},ue.cX=function(t,n){le.I$(n,t.length),ue.bX(t,n,le.V$(Ie(ue.pX.prototype.Ub,ue.pX,[])))},ue.dX=function(t){ue._W(t,0,t.length,null)},ue.eX=function(t,n,e){le.I$(n,t.length),ue._W(t,0,n,e)},ue.fX=function(t,n){ue._W(t,0,t.length,n)},ue.gX=function(t,n){return ue.QX(n,t.length),new ue.bY(t,n)},ue.hX=function(t){return new fe.i$(null,ue.gX(t,t.length))},ue.rX=function(t){var n,e,o;for(o=0,e=t.mb();e.Ob();)o+=null!=(n=e.Pb())?ie.Ac(n):0,o|=0;return o},ue.sX=function(t){var n,e,o;for(o=1,e=t.mb();e.Ob();)o=31*o+(null!=(n=e.Pb())?ie.Ac(n):0),o|=0;return o},ue.DX=function(){ie.FG.call(this)},Te(185,20,R,ue.DX),ue.EX=function(t,n){return _e(t)===_e(n)||null!=t&&ie.wc(t,n)},ue.FX=function(t){return null!=t?ie.Ac(t):0},ue.PX=function(t,n){for(;t.Zb(n););},ue.QX=function(t,n){if(0>t||t>n)throw We(new ie.IP(q+t+J+n))},ue.RX=function(t,n){this.c=t,this.b=0!=(64&n)?n|$:n},Te(134,1,{}),a.Yb=function(t){ue.PX(this,t)},a.Wb=function(){return this.b},a.Xb=function(){return this.c},a.b=0,a.c=0,ue.VX=function(t,n){ue.RX.call(this,t,n)},Te(135,134,{}),ue.WX=function(t,n){for(le.M$(n);t.c<t.d;)ue.aY(t,n,t.c++)},ue.XX=function(t,n){return le.M$(n),t.c<t.d&&(ue.aY(t,n,t.c++),!0)},ue.YX=function(t){this.c=0,this.d=t,this.b=17488},Te(136,1,{}),a.Yb=function(t){ue.PX(this,t)},a.Wb=function(){return this.b},a.Xb=function(){return ao(this.d-this.c)},a.b=0,a.c=0,a.d=0,ue.aY=function(t,n,e){n.ac(t.a[e])},ue.bY=function(t,n){ue.YX.call(this,n),this.a=t},Te(137,136,{},ue.bY),a.Yb=function(t){ue.WX(this,t)},a.Zb=function(t){return ue.XX(this,t)},fe.TZ=function(t,n,e,o){return le.M$(t),le.M$(n),le.M$(e),le.M$(o),new fe.$Z},fe.XZ=function(){fe.XZ=De,fe.UZ=new fe.YZ("CONCURRENT",0),fe.VZ=new fe.YZ("IDENTITY_FINISH",1),fe.WZ=new fe.YZ("UNORDERED",2)},fe.YZ=function(t,n){ko.call(this,t,n)},fe.ZZ=function(){return fe.XZ(),Oe($e(re.oN,1),C,58,0,[fe.UZ,fe.VZ,fe.WZ])},Te(58,39,{4:1,30:1,39:1,58:1},fe.YZ),fe.$Z=function(){},Te(187,1,{},fe.$Z),fe._Z=function(){},Te(132,1,{},fe._Z),fe.a$=function(){},Te(131,1,{},fe.a$),fe.b$=function(){},Te(133,1,{},fe.b$),fe.c$=function(t){},fe.d$=function(t){t.b?fe.d$(t.b):(fe.e$(t),t.c=!0)},fe.e$=function(t){if(t.b)fe.e$(t.b);else if(t.c)throw We(new ie.bR)},fe.f$=function(t){fe.c$(this),t?this.b=t:(this.b=null,new ue.gi)},Te(174,1,{}),a.c=!1,fe.g$=function(t,n){return fe.e$(t),new fe.i$(t,new fe.l$(n,t.a))},fe.h$=function(t,n){var e;return fe.d$(t),(e=new fe.q$).a=n,t.a.Yb(new fe.s$(e)),e.a},fe.i$=function(t,n){fe.f$.call(this,t),this.a=n},fe.j$=function(t,n){return t.add(n),t},fe.k$=function(t,n){fe.p$(t,fe.j$(t.a,n))},Te(126,174,{},fe.i$),fe.l$=function(t,n){ue.VX.call(this,n.Xb(),-6&n.Wb()),le.M$(t),this.a=n},Te(175,135,{},fe.l$),a.Zb=function(t){return this.a.Zb(new fe.n$(t))},fe.n$=function(t){this.a=t},Te(177,1,{},fe.n$),a.ac=function(t){this.a.ac(t.backingJsObject)},fe.p$=function(t,n){t.a=n},fe.q$=function(){},Te(176,1,{},fe.q$),a.ac=function(t){fe.p$(this,t)},fe.s$=function(t){this.a=t},Te(178,1,{},fe.s$),a.ac=function(t){fe.k$(this.a,t)},le.u$=function(t,n){var e;return e=le.V$(t).slice(0,n),le.z$(e,t)},le.v$=function(n,e,o,r,i,a){var s,u,f,l,c;for(_e(n)===_e(o)&&(n=le.V$(n).slice(e,e+i),e=0),f=le.V$(o),u=e,l=e+i;u<l;)i=(s=t.Math.min(u+E,l))-u,c=le.V$(n).slice(u,s),le.V$(c).splice(0,0,r,a?i:0),Array.prototype.splice.apply(f,c),u=s,r+=i},le.w$=function(t,n,e){le.V$(t).splice(n,0,e)},le.x$=function(t,n,e){le.v$(e,0,t,n,e.length,!1)},le.y$=function(t,n,e){le.V$(t).splice(n,e)},Te(253,1,{}),le.z$=function(t,n){return re.YI(t,n)},le.H$=function(t){if(!t)throw We(new ie.$Q)},le.I$=function(t,n){if(0>t)throw We(new ie._Q("fromIndex: 0 > toIndex: "+t));if(t>n)throw We(new ie.IP(q+t+J+n))},le.J$=function(t){if(t<0)throw We(new ie.qR("Negative array size: "+t))},le.K$=function(t){if(!t)throw We(new ue.DX)},le.L$=function(t,n){if(t<0||t>=n)throw We(new ie.GP(Q+t+X+n))},le.M$=function(t){if(null==t)throw We(new ie.rR);return t},le.N$=function(t,n){if(null==t)throw We(new ie.tR(n))},le.O$=function(t,n){if(t<0||t>n)throw We(new ie.GP(Q+t+X+n))},le.P$=function(t,n,e){if(t<0||n>e)throw We(new ie.GP(_+t+z+n+", size: "+e));if(t>n)throw We(new ie._Q(_+t+" > toIndex: "+n))},le.Q$=function(t){if(!t)throw We(new ie.aR)},le.R$=function(t,n,e){if(t<0||n>e||n<t)throw We(new ie.mS(_+t+z+n+J+e))},le.S$=function(t,n){if(t<0||t>=n)throw We(new ie.mS(Q+t+X+n))},le.T$=function(t,n){return t[n]},le.U$=function(t,n,e){t[n]=e},le.V$=function(t){return t},le.W$=function(t){return t},le.X$=function(t){return t},Te(249,1,{}),le.Z$=function(t){return t.$H||(t.$H=le.$$())},le.$$=function(){return++le.Y$},le.Y$=0,le.c_=function(){le.c_=De,le._$=new Be,le.b_=new Be},le.d_=function(t){var n,e,o,r;for(n=0,r=(o=le.V$(t).length)-4,e=0;e<r;)le.S$(e+3,le.V$(t).length),n=le.V$(t).charCodeAt(e+3)+(le.S$(e+2,le.V$(t).length),31*(le.V$(t).charCodeAt(e+2)+(le.S$(e+1,le.V$(t).length),31*(le.V$(t).charCodeAt(e+1)+(le.S$(e,le.V$(t).length),31*(le.V$(t).charCodeAt(e)+31*n)))))),n|=0,e+=4;for(;e<o;)n=31*n+ie.AR(t,e++);return n|=0},le.e_=function(t){var n,e,o;return le.c_(),e=":"+t,null!=(o=le.T$(le.b_,e))?ze(le.X$((le.M$(o),o))):(n=null==(o=le.T$(le._$,e))?le.d_(t):ze(le.X$((le.M$(o),o))),le.f_(),le.U$(le.b_,e,le.V$(n)),n)},le.f_=function(){256==le.a_&&(le._$=le.b_,le.b_=new Be,le.a_=0),++le.a_},le.a_=0,re.nM=vo(1),re.yL=vo(0),re.FL=vo(206),re.CL=vo(154),re.EL=vo(207),re.DL=vo(155),re.wM=vo(17),re.dM=vo(13),re.oM=vo(20),re.gM=vo(53),re.$L=vo(88),re._L=vo(151),re.aM=vo(102),re.mM=vo(73),re.bM=vo(152),re.cM=vo(39),re.eM=vo(26),re.fM=vo(118),re.hM=vo(36),re.iM=vo(67),re.kM=vo(87),re.uM=vo(2),re.sM=vo(119),re.vM=vo(130),re.xM=vo(59),re.EM=vo(208),re.IM=vo(209),re.FM=vo(112),re.GM=vo(113),re.HM=vo(114),re.WM=vo(18),re.VM=vo(19),re.YM=vo(185),re.bN=vo(134),re.$M=vo(135),re.aN=vo(136),re._M=vo(137),re.oN=Mo(58,fe.ZZ),re.pN=vo(187),re.qN=vo(132),re.rN=vo(131),re.sN=vo(133),re.yN=vo(174),re.xN=vo(126),re.uN=vo(175),re.tN=vo(177),re.vN=vo(176),re.wN=vo(178),ce.Pc=function(){ce.Pc=De,ce.Dc=Oe($e(re.hK,1),L,5,15,[0,Z,14286847,13402367,12779264,16758197,9474192,3166456,16715021,9494608,11789301,11230450,9109248,12560038,1578e4,16744448,16777008,2093087,8442339,9388244,4062976,15132390,12567239,10921643,9083335,10255047,14706227,15765664,5296208,13140019,8224944,12750735,6721423,12419299,16752896,10889513,6076625,7351984,65280,9764863,9756896,7586505,5551541,3907230,2396047,687500,27013,12632256,16767375,10909043,6717568,10380213,13924864,9699476,4366e3,5707663,51456,7394559,16777159,14286791,13107143,10747847,9437127,6422471,4587463,3211207,2097095,65436,58997,54354,48952,43812,5096191,5089023,2200790,2522539,2516630,1528967,13684960,16765219,12105936,10900557,5724513,10375093,11230208,7688005,4358806,4325478,32e3,7384058,47871,41471,36863,33023,27647,5528818,7888099,9064419,10565332,11739092,11739066,11734438,12389767,13041766,13369433,13697103,14221381,14680120,15073326,15400998,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13158600,1334015,56540,15075850,15132160,56540,15075850,15461355,8553170,1016335,1016335,1334015,15132160,3289770,14456450,16422400,16422400,11819700,3289770,1016335]),ce.Gc=new He.RO(255,128,0),ce.Fc=new He.RO(92,160,255),ce.Oc=new He.RO(160,0,64),ce.Ec=new He.RO(255,160,255),ce.Hc=new He.RO(32,96,255),ce.Nc=new He.RO(255,0,0),ce.Kc=new He.RO(0,255,0),ce.Lc=new He.RO(192,0,255),ce.Mc=new He.RO(255,160,0),ce.Ic=new He.RO(0,128,0),ce.Jc=new He.RO(160,0,0)},ce.Qc=function(t){t.t=new ve.lP},ce.Rc=function(t){var n,e;0==(32&t.B)&&null!=(e=ce.Mr(t.H))&&(0==t.u.a&&0==t.u.b&&(n=t.M.c*ce.Jj(t.H),ce.Kd(t),ce.$c(t,n),ce.Hd(t,null,n,0)),ce.dr(t,ze(t.v)),1!=t.H.M&&ce.Id(t,448),ce.Zq(t,e,t.u.a,t.u.b+W*t.v))},ce.Sc=function(t,n){return null==t?n:null==n?t:t+","+n},ce.Tc=function(t){var n;n=t.M.c*ce.Jj(t.H),t.T=.06*n,t.O=.15*n,t.N=.38*n,t.R=.47*n,t.S=ze(n*t.F*.6+.5),t.Q=.12*n,t.U=.4*n,t.v=.5*n+.5},ce.Uc=function(t,n,e,o){var r,i,a;r=new ce.Qd,i=new ce.Qd,r.a=n.a,r.c=n.c,r.b=(n.a+n.b)/2,r.d=(n.c+n.d)/2,i.a=r.b,i.c=r.d,i.b=n.b,i.d=n.d,ce.Ed(t,r)&&(ce.Id(t,t.o[e]),a=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.a),(Ae.BU(),Ae.xU))))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,a)),ce.Ed(t,i)&&(ce.Id(t,t.o[o]),a=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(i.a),(Ae.BU(),Ae.xU))))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(i.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(i.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(i.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,a)),ce.Id(t,t.L)},ce.Vc=function(t,n,e,o){var r,i,a,s,u,f,l,c,h;c=(n.b-n.a)/10,h=(n.d-n.c)/10,r=new ce.Qd,ce.qk(t.H,ce.xm(t.H,e,o))?(i=-3,a=-3):(i=t.o[e],a=t.o[o]),ce.Id(t,i),r.a=n.a,r.c=n.c,r.b=n.a+2*c,r.d=n.c+2*h,u=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.a),(Ae.BU(),Ae.xU))))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,u),r.a=n.a+4*c,r.c=n.c+4*h,r.b=n.a+5*c,r.d=n.c+5*h,f=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.a),Ae.xU)))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,f),ce.Id(t,a),r.a=n.a+5*c,r.c=n.c+5*h,r.b=n.a+6*c,r.d=n.c+6*h,l=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.a),Ae.xU)))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,l),r.a=n.a+8*c,r.c=n.c+8*h,r.b=n.b,r.d=n.d,s=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.a),Ae.xU)))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,s),ce.Id(t,t.L)},ce.Wc=function(t,n,e){ce.$q(t,n-t.Q/2,e-t.Q/2,t.Q)},ce.Xc=function(t,n,e,o){var r;ce.qk(t.H,ce.xm(t.H,e,o))?(ce.Id(t,-3),r=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.a),(Ae.BU(),Ae.xU))))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,r),ce.Id(t,t.L)):t.o[e]!=t.o[o]?ce.Uc(t,n,e,o):0!=t.o[e]?(ce.Id(t,t.o[e]),r=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.a),(Ae.BU(),Ae.xU))))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,r),ce.Id(t,t.L)):(r=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.a),(Ae.BU(),Ae.xU))))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,r))},ce.Yc=function(n,e,o,r){var i,a,s,u,f,l,c,h,w,g,m,d;for(h=e.b-e.a,m=e.d-e.c,f=t.Math.sqrt(h*h+m*m),w=h/((l=2*jo(io(t.Math.round(f/(4*n.T)))))-1),d=m/(l-1),ce.qk(n.H,ce.xm(n.H,o,r))?(i=-3,a=-3):(i=n.o[o],a=n.o[r]),c=e.a-n.T/2,g=e.c-n.T/2,ce.Id(n,i),u=0;u<(l/2|0);u++)ce.$q(n,c,g,n.T),c+=w,g+=d;for(ce.Id(n,a),s=0;s<(l/2|0);s++)ce.$q(n,c,g,n.T),c+=w,g+=d;ce.Id(n,n.L)},ce.Zc=function(t,n,e,o){var r,i,a,s,u,f,l,c;l=(n.c-n.d)/9,c=(n.b-n.a)/9,a=Ke(re.fK,ut,5,3,15,1),s=Ke(re.fK,ut,5,3,15,1),u=Ke(re.fK,ut,5,4,15,1),f=Ke(re.fK,ut,5,4,15,1),a[0]=n.a,s[0]=n.c,u[2]=n.b+l,f[2]=n.d+c,u[3]=n.b-l,f[3]=n.d-c,a[1]=(a[0]+u[2])/2,s[1]=(s[0]+f[2])/2,a[2]=(a[0]+u[3])/2,s[2]=(s[0]+f[3])/2,u[0]=a[2],f[0]=s[2],u[1]=a[1],f[1]=s[1],ce.qk(t.H,ce.xm(t.H,e,o))?(r=-3,i=-3):(r=t.o[e],i=t.o[o],1!=t.H.M&&(i=ce.bd(t,e),r==ce.sj(t.H,e)&&(r=i))),ce.Id(t,r),ce.Yq(t,a,s,3),ce.Id(t,i),ce.Yq(t,u,f,4),ce.Id(t,t.L)},ce.$c=function(t,n){var e,o;for(o=0;o<t.V.a.length;o++)t.t=ve.jP(t.t,ue.Th(t.V,o));ce._c(t,n),e=.1*n,t.t.c-=e,t.t.d-=e,t.t.b+=2*e,t.t.a+=2*e},ce._c=function(t,n){var e,o,r,i,a,s,u;for(r=Ke(re.DN,ft,5,t.H.o,16,1),o=0;o<t.H.p;o++)ce.ok(t.H,o)&&(r[ce.Nj(t.H,0,o)]=!0,r[ce.Nj(t.H,1,o)]=!0);for(a=new ve.lP,e=0;e<t.H.o;e++)0!=(i=0!=(ce.Dj(t.H,e)&lt)?.47*n:r[e]?.38*n:0)&&(s=ce.dh(t.M,ce.Fj(t.H,e)),u=ce.eh(t.M,ce.Gj(t.H,e)),ve.kP(a,s-i,u-i,2*i,2*i),t.t=ve.jP(t.t,a))},ce.ad=function(t){var n,e;return He.MO(),n=He.IO,e=new He.QO(t),pe.aG(e,n)},ce.bd=function(t,n){var e,o;if(0!=(8320&t.B))return t.o[n];if(-1==(o=ce.cd(t,n))&&-1!=(e=ce.gm(t.H,n))&&(n=e,o=ce.cd(t,n)),-1==o)return t.o[n];switch(255&o){case 1:return 384;case 2:return 64;default:return 448}},ce.cd=function(t,n){var e,o,r;return r=-1,o=-1,0!=(128&t.B)||(ce.mk(t.H,n)&&(r=ce.wj(t.H,n),o=ce.vj(t.H,n)),-1!=(e=ce.im(t.H,n))&&(r=ce.Sj(t.H,e),o=ce.Rj(t.H,e)),-1!=r&&0!=r&&(r|=o<<8)),r},ce.dd=function(t){var n,e,o,r,i;for(ce.cr(t,2*t.N),r=new ce.Qd,o=0;o<t.H.p;o++)n=ce.Nj(t.H,0,o),e=ce.Nj(t.H,1,o),ce.ok(t.H,o)&&(r.a=ce.dh(t.M,ce.Fj(t.H,n)),r.c=ce.eh(t.M,ce.Gj(t.H,n)),r.b=ce.dh(t.M,ce.Fj(t.H,e)),r.d=ce.eh(t.M,ce.Gj(t.H,e)),ce.Id(t,-2),i=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.a),(Ae.BU(),Ae.xU))))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,i))},ce.ed=function(t){var n,e,o,r,i,a,s;if(t.H.I){for(a=t.R,ce.Id(t,-7),n=0;n<t.H.d;n++)0!=(ce.Dj(t.H,n)&lt)&&ce.$q(t,ce.dh(t.M,ce.Fj(t.H,n))-a,ce.eh(t.M,ce.Gj(t.H,n))-a,2*a);for(ce.cr(t,2*t.R),i=new ce.Qd,r=0;r<t.H.p;r++)e=ce.Nj(t.H,0,r),o=ce.Nj(t.H,1,r),0!=(ce.Dj(t.H,e)&ce.Dj(t.H,o)&lt)&&(i.a=ce.dh(t.M,ce.Fj(t.H,e)),i.c=ce.eh(t.M,ce.Gj(t.H,e)),i.b=ce.dh(t.M,ce.Fj(t.H,o)),i.d=ce.eh(t.M,ce.Gj(t.H,o)),s=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(i.a),(Ae.BU(),Ae.xU))))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(i.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(i.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(i.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,s))}},ce.fd=function(t){var n,e,o,r;if(t.H.I){if(ce.Id(t,320),0!=(8&t.B))for(n=0;n<t.H.d;n++)0!=(-536870913&ce.Dj(t.H,n))&&ce.$q(t,ce.dh(t.M,ce.Fj(t.H,n))-t.U/2,ce.eh(t.M,ce.Gj(t.H,n))-t.U/2,t.U);for(r=0;r<t.H.e;r++)0!=ce.Xj(t.H,r)&&(e=ce.Nj(t.H,0,r),o=ce.Nj(t.H,1,r),ce.$q(t,(ce.dh(t.M,ce.Fj(t.H,e))+ce.dh(t.M,ce.Fj(t.H,o))-t.U)/2,(ce.eh(t.M,ce.Gj(t.H,e))+ce.eh(t.M,ce.Gj(t.H,o))-t.U)/2,t.U))}},ce.gd=function(t){t.F=1,t.M=new ce.fh,t.V=new ue.gi,t.P=new ue.gi,t.q=Ke(re.DN,ft,5,t.H.o,16,1),t.u=new ve.aP,t.L=0,t.w=-1,ce.Md(t)},ce.hd=function(t,n){var e;if(0==ce.mm(t.H,n))return!1;for(e=0;e<ce.mm(t.H,n);e++)if(!ce.qk(t.H,ce.Bm(t.H,n,e)))return!1;return!0},ce.jd=function(t){var n;for(t.p=Ke(re.DN,ft,5,t.H.o,16,1),n=0;n<t.H.p;n++)t.p[ce.Nj(t.H,0,n)]=!0,t.p[ce.Nj(t.H,1,n)]=!0},ce.kd=function(t,n){var e;if(2!=ce.Am(t.H,n))return!1;for(e=0;e<2;e++)if(2!=ce.Cm(t.H,n,e))return!1;return!0},ce.ld=function(n,e,o,r,i){var a,s,u,f,l,c,h,w,g,m;for(w=!1,i.a=0,i.b=0,a=r>0?ct:ht,m=ce.Mj(n.H,e,o),c=0;c<ce.Am(n.H,e);c++)s=ce.Bm(n.H,e,c),u=m,(h=ce.Nj(n.H,0,s)==e?ce.Nj(n.H,1,s):ce.Nj(n.H,0,s))!=o&&(u<(g=ce.Mj(n.H,e,h))&&(u+=wt),f=u-g,r>0?(f<gt&&(w=!0),f>ct&&(f=ct),f<.523598776&&(f=.523598776),f<=a&&(a=f,l=n.O*t.Math.tan(a-mt)/2,i.a=-l*t.Math.sin(u),i.b=-l*t.Math.cos(u))):(f>=gt&&(w=!0),f<ht&&(f=ht),f>5.759586531&&(f=5.759586531),f>=a&&(a=f,l=n.O*t.Math.tan(4.712388981-a)/2,i.a=-l*t.Math.sin(u),i.b=-l*t.Math.cos(u))));return w},ce.md=function(n,e,o,r){var i;if(0==e)return r.a=o<0?n.O:-n.O,void(r.b=0);i=t.Math.atan(o/e),e<0&&(i+=gt),r.a=-n.O*t.Math.sin(i),r.b=n.O*t.Math.cos(i)},ce.nd=function(t,n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m;r=new ce.Qd,u=new ce.Qd,l=new ve.aP,f=new ve.aP,a=ce.Nj(t.H,0,e),s=ce.Nj(t.H,1,e),o&&(h=n.a,n.a=n.b,n.b=h,h=n.c,n.c=n.d,n.d=h,w=a,a=s,s=w),ce.Ed(t,n)&&(ce.xn(t.H,e)?(r.a=n.a,r.c=n.c,r.b=n.b,r.d=n.d,0==(c=o?-ce.Dd(t,e):ce.Dd(t,e))&&(c=1),ce.md(t,n.b-n.a,n.d-n.c,l),c>0?(u.a=n.a+l.a,u.c=n.c+l.b,u.b=n.b+l.a,u.d=n.d+l.b,(ce.ld(t,a,s,1,f)||ce.Am(t.H,a)>1)&&(u.a+=f.a+l.b,u.c+=f.b-l.a)):(u.a=n.a-l.a,u.c=n.c-l.b,u.b=n.b-l.a,u.d=n.d-l.b,(ce.ld(t,a,s,-1,f)||ce.Am(t.H,a)>1)&&(u.a+=f.a+l.b,u.c+=f.b-l.a)),26==ce.Yj(t.H,e)&&ce.Cd(r,u),ce.Ed(t,r)&&ce.Xc(t,r,a,s),64==ce.Yj(t.H,e)?ce.Ed(t,u)&&ce.Vc(t,u,a,s):ce.Ed(t,u)&&ce.Xc(t,u,a,s)):(ce.md(t,n.b-n.a,n.d-n.c,l),g=l.a/2,m=l.b/2,i=!1,r.a=n.a+g,r.c=n.c+m,r.b=n.b+g,r.d=n.d+m,ce.Am(t.H,a)>1&&(ce.ld(t,a,s,1,f)?(r.a+=f.a,r.c+=f.b,2==ce.Am(t.H,a)&&(0==f.a&&0==f.b||(r.a+=l.b,r.c-=l.a))):t.n[a]=new ve.bP(r.a,r.c)),u.a=n.a-g,u.c=n.c-m,u.b=n.b-g,u.d=n.d-m,ce.Am(t.H,a)>1&&(ce.ld(t,a,s,0,f)?(u.a+=f.a,u.c+=f.b,2==ce.Am(t.H,a)&&(0==f.a&&0==f.b||(u.a+=l.b,u.c-=l.a))):(t.n[a]=new ve.bP(u.a,u.c),i=!0)),26==ce.Yj(t.H,e)&&ce.Cd(r,u),64==ce.Yj(t.H,e)?i?(ce.Vc(t,r,a,s),ce.Xc(t,u,a,s)):(ce.Xc(t,r,a,s),ce.Vc(t,u,a,s)):(ce.Xc(t,r,a,s),ce.Xc(t,u,a,s))))},ce.od=function(t,n){var e,o,r,i,a,s,u,f,l,c,h;for(t.n=Ke(re.LL,p,43,t.H.o,0,1),u=0;u<t.H.p;u++)(2==ce.Yj(t.H,u)||26==ce.Yj(t.H,u)||64==ce.Yj(t.H,u))&&ce.rd(t,u);for(f=0;f<t.H.p;f++)2!=ce.Yj(t.H,f)&&26!=ce.Yj(t.H,f)&&64!=ce.Yj(t.H,f)&&ce.rd(t,f);if(0==(64&t.B))for(s=0;s<t.H.p;s++)0!=ce.Qj(t.H,s)&&(r=null,1==ce.Qj(t.H,s)||2==ce.Qj(t.H,s)?(2==ce.Vj(t.H,s)||0==ce.Sj(t.H,s)||n[ce.Sj(t.H,s)][ce.Rj(t.H,s)]>1)&&(r=1==ce.Qj(t.H,s)?2==ce.Vj(t.H,s)?"E":ce.sk(t.H,s)?"p":"P":2==ce.Vj(t.H,s)?"Z":ce.sk(t.H,s)?"m":"M"):r="?",null!=r&&(ce.dr(t,(2*t.S+1)/3|0),ce.Id(t,ce.qk(t.H,s)?-3:1==t.H.M||0!=(t.B&dt)?t.L:448),e=ce.Nj(t.H,0,s),o=ce.Nj(t.H,1,s),c=(ce.dh(t.M,ce.Fj(t.H,e))+ce.dh(t.M,ce.Fj(t.H,o)))/2,h=(ce.eh(t.M,ce.Gj(t.H,e))+ce.eh(t.M,ce.Gj(t.H,o)))/2,i=(ce.dh(t.M,ce.Fj(t.H,e))-ce.dh(t.M,ce.Fj(t.H,o)))/3,a=(ce.eh(t.M,ce.Gj(t.H,e))-ce.eh(t.M,ce.Gj(t.H,o)))/3,ce.ud(t,c+a,h-i,r,!0),ce.Id(t,t.L),ce.dr(t,t.S)));if(0!=(4&t.B)){for(ce.dr(t,(2*t.S+1)/3|0),ce.Id(t,384),s=0;s<t.H.p;s++)e=ce.Nj(t.H,0,s),o=ce.Nj(t.H,1,s),l=ce.qn(t.H,s)?"d":ce.mn(t.H,s)?"a":"",c=(ce.dh(t.M,ce.Fj(t.H,e))+ce.dh(t.M,ce.Fj(t.H,o)))/2,h=(ce.eh(t.M,ce.Gj(t.H,e))+ce.eh(t.M,ce.Gj(t.H,o)))/2,ce.ud(t,c,h,l+""+s,!0);ce.Id(t,t.L),ce.dr(t,t.S)}},ce.pd=function(t){var n,e;for(e=new ue.KW(t.P);e.a<e.c.a.length;)n=ue.JW(e),ce.Id(t,n.a),ce.Wc(t,n.b,n.c);ce.Id(t,t.L)},ce.qd=function(n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,x,k,R,I,D,F,T,P,K,V,E,O,Y,U,L,q,J,Q;if(n.G||ce._q(n,e,(ce.xj(n.H,e),ce.dh(n.M,ce.Fj(n.H,e))),ce.eh(n.M,ce.Gj(n.H,e))),F=null,0!=ce.rj(n.H,e)&&(O=1==t.Math.abs(ce.rj(n.H,e))?"":""+t.Math.abs(ce.rj(n.H,e)),F=ce.rj(n.H,e)<0?O+"-":O+"+"),A=null,0!=(T=ce.Dj(n.H,e))&&(0!=(2&T)&&(A=null==A?"a":A+",a"),0!=(4&T)&&(A=null==A?"!a":A+",!a"),0!=(T&B)&&(A=null==A?"s":A+",s"),0!=(T&pt)&&(1792==(N=T&pt)?A=null==A?"h0":A+",h0":1664==N?A=null==A?"h1":A+",h1":1408==N?A=null==A?"h2":A+",h2":128==N?A=null==A?"h>0":A+",h>0":384==N?A=null==A?"h>1":A+",h>1":896==N?A=null==A?"h>2":A+",h>2":N==Gt?A=null==A?"h<3":A+",h<3":1536==N&&(A=null==A?"h<2":A+",h<2")),0!=(T&bt)&&(167772160==(f=T&bt)?A=null==A?"c0":A+",c0":f==yt?A=null==A?"c+":A+",c+":f==jt&&(A=null==A?"c-":A+",c-")),0!=(T&Nt)&&(98304==(D=T&Nt)?A=null==A?"pi0":A+",pi0":81920==D?A=null==A?"pi1":A+",pi1":49152==D?A=null==A?"pi2":A+",pi2":D==$&&(A=null==A?"pi>0":A+",pi>0")),0!=(T&Ht)&&(3801088==(I=T&Ht)?A=null==A?"n1":A+",n1":3538944==I?A=null==A?"n2":A+",n2":3014656==I?A=null==A?"n3":A+",n3":3145728==I?A=null==A?"n<3":A+",n<3":I==vt?A=null==A?"n<4":A+",n<4":I==Mt?A=null==A?"n>1":A+",n>1":917504==I?A=null==A?"n>2":A+",n>2":1966080==I&&(A=null==A?"n>3":A+",n>3")),0!=(120&T)&&(112==(P=120&T)?A=null==A?"!r":A+",!r":8==P?A=null==A?"r":A+",r":104==P?A=null==A?"rb2":A+",rb2":88==P?A=null==A?"rb3":A+",rb3":56==P&&(A=null==A?"rb4":A+",rb4")),0!=(T&At)&&(A=null==A?"r"+((T&At)>>22):A+",r"+((T&At)>>22)),0!=(T&St)&&(A=null==A?"f":A+",f")),0!=ce.Bj(n.H,e)&&(A=ce.Sc(A,""+ce.Bj(n.H,e))),E=0,0!=ce.Ej(n.H,e))switch(ce.Ej(n.H,e)){case 16:F=null==F?"|":F+",|";break;case 32:E=1;break;case 48:E=2}if(h=null,0==(64&n.B))if(ce.jk(n.H,e))h="?";else if(0!=ce.qj(n.H,e)&&(0==ce.wj(n.H,e)||null==o||o[ce.wj(n.H,e)][ce.vj(n.H,e)]>1))if(2==ce.Am(n.H,e))switch(ce.qj(n.H,e)){case 2:h=ce.lk(n.H,e)?"p":"P";break;case 1:h=ce.lk(n.H,e)?"m":"M";break;default:h="*"}else switch(ce.qj(n.H,e)){case 1:h=ce.lk(n.H,e)?"r":"R";break;case 2:h=ce.lk(n.H,e)?"s":"S";break;default:h="*"}if(0!=(1792&n.B)&&(h=ce.Sc(h,""+ce.Ur(n.H,e))),k=null,0!=(16&n.B)&&0!=ce.Aj(n.H,e)&&(k=""+ce.Aj(n.H,e)),d=null,-1!=ce._m(n.H,e)&&-1!=(m=ce.cd(n,e))&&(d=0==m?"abs":(1==(255&m)?"&":"or")+(1+(m>>8))),H=0,n.H.I?0!=(ce.Dj(n.H,e)&Ct)&&(H=ce.Nm(n.H,e)):(6!=ce.Ij(n.H,e)||0!=ce.Bj(n.H,e)||!n.p[e]||0!=ce.Ej(n.H,e))&&(H=ce.Nm(n.H,e)),x=!1,null!=(a=ce.tj(n.H,e))&&ie.GR(le.V$(a).substr(0,1),"]")&&(A=ce.Sc(le.V$(a).substr(1),A),a=null,x=!0),null!=a?H=0:null!=ce.yj(n.H,e)?(a=(i=0!=(1&ce.Dj(n.H,e))?"[!":"[")+ce.zj(n.H,e)+"]",le.V$(a).length>5&&(a=i+ce.yj(n.H,e).length+"]"),0!=(ce.Dj(n.H,e)&Ct)&&(H=-1)):0!=(1&ce.Dj(n.H,e))?(a="?",0!=(ce.Dj(n.H,e)&Ct)&&(H=-1)):(6!=ce.Ij(n.H,e)||null!=F||null!=A||H>0||!n.p[e])&&(a=ce.xj(n.H,e)),C=0,!ce.Bk(n.H,e)&0!=(ce.Dj(n.H,e)&lt)&&ce.Id(n,-8),null!=a?(C=(Y=He.XO(n.e,a),new ve.mP(0,0,Y,0)).b,ce.ud(n,ce.dh(n.M,ce.Fj(n.H,e)),ce.eh(n.M,ce.Gj(n.H,e)),a,!0),n.q[e]=!0):ce.kd(n,e)&&ce.td(n,ce.dh(n.M,ce.Fj(n.H,e)),ce.eh(n.M,ce.Gj(n.H,e)),e),null!=F&&(ce.dr(n,(2*n.S+1)/3|0),L=ce.dh(n.M,ce.Fj(n.H,e))+((C+(Y=He.XO(n.e,F),new ve.mP(0,0,Y,0)).b)/2+1),J=ce.eh(n.M,ce.Gj(n.H,e))-((4*n.j-4)/8|0),ce.ud(n,L,J,F,!0),ce.dr(n,n.S)),0!=(2&n.B)&&(A=""+e),null!=A&&(x?ce.dr(n,(5*n.S+1)/6|0):ce.dr(n,(2*n.S+1)/3|0),L=ce.dh(n.M,ce.Fj(n.H,e))-(C+(Y=He.XO(n.e,A),new ve.mP(0,0,Y,0)).b)/2,J=ce.eh(n.M,ce.Gj(n.H,e))-((4*n.j-4)/8|0),ce.ud(n,L,J,A,!0),ce.dr(n,n.S)),null!=h&&(ce.dr(n,(2*n.S+1)/3|0),L=ce.dh(n.M,ce.Fj(n.H,e))-(C+(Y=He.XO(n.e,h),new ve.mP(0,0,Y,0)).b)/2,J=ce.eh(n.M,ce.Gj(n.H,e))+((4*n.j+4)/8|0),V=n.w,1!=n.H.M&&0==(n.B&dt)&&ce.Id(n,448),ce.ud(n,L,J,h,!1),ce.Id(n,V),ce.dr(n,n.S)),null!=k&&(ce.dr(n,(2*n.S+1)/3|0),L=ce.dh(n.M,ce.Fj(n.H,e))+((C+(Y=He.XO(n.e,k),new ve.mP(0,0,Y,0)).b)/2+1),J=ce.eh(n.M,ce.Gj(n.H,e))+((4*n.j+4)/8|0),V=n.w,ce.Id(n,ce.nk(n.H,e)?384:448),ce.ud(n,L,J,k,!0),ce.Id(n,V),ce.dr(n,n.S)),null!=d&&(r=ce.yd(n,e),ce.dr(n,(2*n.S+1)/3|0),L=ce.dh(n.M,ce.Fj(n.H,e))+.7*n.j*t.Math.sin(r),J=ce.eh(n.M,ce.Gj(n.H,e))+.7*n.j*t.Math.cos(r),V=n.w,!n.G&&1!=n.H.M&&ce.Id(n,ce.bd(n,e)),ce.ud(n,L,J,d,!1),ce.Id(n,V),ce.dr(n,n.S)),0!=H||0!=E){for(y=Ke(re.fK,ut,5,4,15,1),M=0;M<ce.nm(n.H,e);M++)for(u=ce.Bm(n.H,e,M),S=0;S<2;S++)ce.Nj(n.H,S,u)==e&&((K=ce.Mj(n.H,ce.Nj(n.H,S,u),ce.Nj(n.H,1-S,u)))<xt?(y[0]-=K+mt,y[3]+=K+gt):K<0?(y[2]+=K+mt,y[3]-=K):K<mt?(y[1]+=K,y[2]+=mt-K):(y[0]+=K-mt,y[1]+=gt-K));if(0==ce.Am(n.H,e)?ce.uk(n.H,e)?y[3]-=.2:y[1]-=.2:y[1]-=.1,(null!=F||null!=k)&&(y[1]+=10),(null!=A||null!=h)&&(y[3]+=10),G="",0!=H&&(j=(U=He.XO(n.e,"H"),new ve.mP(0,0,U,0)).b,b=0,p=n.j,-1==H?(G="n",ce.dr(n,(2*n.S+1)/3|0),b=(Y=He.XO(n.e,G),new ve.mP(0,0,Y,0)).b):H>1&&(G=""+H,ce.dr(n,(2*n.S+1)/3|0),b=(Y=He.XO(n.e,G),new ve.mP(0,0,Y,0)).b),y[1]<.6||y[3]<.6?(c=ce.eh(n.M,ce.Gj(n.H,e)),y[1]<=y[3]?(y[1]+=10,l=ce.dh(n.M,ce.Fj(n.H,e))+(C+j)/2):(y[3]+=10,l=ce.dh(n.M,ce.Fj(n.H,e))-(C+j)/2-b)):(l=ce.dh(n.M,ce.Fj(n.H,e)),y[0]<y[2]?(y[0]+=10,c=ce.eh(n.M,ce.Gj(n.H,e))-p):(y[2]+=10,c=ce.eh(n.M,ce.Gj(n.H,e))+p)),b>0&&(L=l+(j+b)/2,J=c+((4*n.j+4)/8|0),ce.ud(n,L,J,G,!0),ce.dr(n,n.S)),ce.ud(n,l,c,"H",!0)),s=0,0!=E){for(R=50,w=0,v=0;v<4;v++)g=v>1?v-2:v+2,y[v]<R?(s=v,R=y[v],w=y[g]):y[v]==R&&y[g]>w&&(s=v,w=y[g]);switch(s){case 0:l=ce.dh(n.M,ce.Fj(n.H,e)),c=ce.eh(n.M,ce.Gj(n.H,e))-n.Q-C/2;break;case 1:l=ce.dh(n.M,ce.Fj(n.H,e))+n.Q+C/2,c=ce.eh(n.M,ce.Gj(n.H,e));break;case 2:l=ce.dh(n.M,ce.Fj(n.H,e)),c=ce.eh(n.M,ce.Gj(n.H,e))+n.Q+C/2;break;default:l=ce.dh(n.M,ce.Fj(n.H,e))-n.Q-C/2,c=ce.eh(n.M,ce.Gj(n.H,e))}if(1==E)ue.Oh(n.V,new ve.mP(l-n.Q,c-n.Q,2*n.Q,2*n.Q)),n.G||ue.Oh(n.P,new ce.Pd(l,c,ce.hd(n,e)?-3:n.o[e]));else{switch(s){case 2:case 0:q=2*n.Q,Q=0,l-=n.Q;break;case 1:q=0,Q=2*n.Q,c-=n.Q;break;default:q=0,Q=2*n.Q,c-=n.Q}ue.Oh(n.V,new ve.mP(l-n.Q,c-n.Q,2*n.Q,2*n.Q)),n.G||ue.Oh(n.P,new ce.Pd(l,c,ce.hd(n,e)?-3:n.o[e])),ue.Oh(n.V,new ve.mP(l+q-n.Q,c+Q-n.Q,2*n.Q,2*n.Q)),n.G||ue.Oh(n.P,new ce.Pd(l+q,c+Q,ce.hd(n,e)?-3:n.o[e]))}}-8==n.w&&ce.Id(n,-9)}else-8==n.w&&ce.Id(n,-9)},ce.rd=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d;if(g=new ce.Qd,e=new ce.Qd,i=new ce.Qd,c=new ve.aP,l=new ve.aP,o=ce.Nj(t.H,0,n),r=ce.Nj(t.H,1,n),ce.Dj(t.H,o),ce.Dj(t.H,r),ce.ar(t,n,ce.dh(t.M,ce.Fj(t.H,o)),ce.eh(t.M,ce.Gj(t.H,o)),ce.dh(t.M,ce.Fj(t.H,r)),ce.eh(t.M,ce.Gj(t.H,r))),!ce.Bk(t.H,o)&&!ce.Bk(t.H,r)&&0!=((ce.Dj(t.H,o)|ce.Dj(t.H,r))&lt)&&ce.Id(t,-8),t.n[o]?(g.a=t.n[o].a,g.c=t.n[o].b):(g.a=ce.dh(t.M,ce.Fj(t.H,o)),g.c=ce.eh(t.M,ce.Gj(t.H,o))),t.n[r]?(g.b=t.n[r].a,g.d=t.n[r].b):(g.b=ce.dh(t.M,ce.Fj(t.H,r)),g.d=ce.eh(t.M,ce.Gj(t.H,r))),0!=(ce.Xj(t.H,n)&kt))return ce.Ed(t,g)&&(h='<line stroke-dasharray="3, 3" x1="'+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(g.a),(Ae.BU(),Ae.xU))))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(g.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(g.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(g.d),Ae.xU)))+nt+it+t.d+'" stroke-width:'+t.i+st,ce.gr(t,h)),void ce.Id(t,-9);switch(a=64==ce.Yj(t.H,n)?0:32==ce.Yj(t.H,n)?1:ce.Vj(t.H,n)){case 1:switch(ce.Yj(t.H,n)){case 1:ce.Ed(t,g)&&ce.Xc(t,g,o,r);break;case 17:ce.Ad(t,g,o,r);break;case 9:for(m=g.b-g.a,d=g.d-g.c,ce.qk(t.H,ce.xm(t.H,o,r))?(s=-3,u=-3):(s=t.o[o],u=ce.bd(t,o),s==ce.sj(t.H,o)&&(s=u)),f=2;f<17;f+=2)e.a=g.a+f*m/17-f*d/128,e.c=g.c+f*d/17+f*m/128,e.b=g.a+f*m/17+f*d/128,e.d=g.c+f*d/17-f*m/128,ce.Ed(t,e)&&(ce.Id(t,f<9?s:u),h=tt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(e.a),(Ae.BU(),Ae.xU))))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(e.c),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(e.b),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(e.d),Ae.xU)))+nt+it+t.d+nt+at+t.i+st,ce.gr(t,h),ce.Id(t,t.L));break;case 32:ce.Ed(t,g)&&ce.Yc(t,g,o,r)}break;case 0:case 2:if(!t.q[o]&&2!=ce.qm(t.H,o)||!t.q[r]&&2!=ce.qm(t.H,r)||ce.xn(t.H,n)||2!=a)!t.q[r]&&2!=ce.qm(t.H,r)||2!=a?!t.q[o]&&2!=ce.qm(t.H,o)||2!=a?(0==(w=ce.Dd(t,n))&&(w=1),e.a=g.a,e.c=g.c,e.b=g.b,e.d=g.d,ce.md(t,g.b-g.a,g.d-g.c,c),w>0?(i.a=g.a+c.a,i.c=g.c+c.b,i.b=g.b+c.a,i.d=g.d+c.b,(ce.ld(t,o,r,1,l)||ce.Am(t.H,o)>1)&&(i.a+=l.a+c.b,i.c+=l.b-c.a),(ce.ld(t,r,o,-1,l)||ce.Am(t.H,r)>1)&&(i.b+=l.a-c.b,i.d+=l.b+c.a)):(i.a=g.a-c.a,i.c=g.c-c.b,i.b=g.b-c.a,i.d=g.d-c.b,(ce.ld(t,o,r,-1,l)||ce.Am(t.H,o)>1)&&(i.a+=l.a+c.b,i.c+=l.b-c.a),(ce.ld(t,r,o,1,l)||ce.Am(t.H,r)>1)&&(i.b+=l.a-c.b,i.d+=l.b+c.a)),26==ce.Yj(t.H,n)&&ce.Cd(e,i),ce.Ed(t,e)&&ce.Xc(t,e,o,r),2==a?ce.Ed(t,i)&&ce.Xc(t,i,o,r):ce.Ed(t,i)&&ce.Vc(t,i,o,r)):ce.nd(t,g,n,!0):ce.nd(t,g,n,!1);else{if(!ce.Ed(t,g))break;ce.md(t,g.b-g.a,g.d-g.c,c),m=c.a/2,d=c.b/2,e.a=g.a+m,e.c=g.c+d,e.b=g.b+m,e.d=g.d+d,i.a=g.a-m,i.c=g.c-d,i.b=g.b-m,i.d=g.d-d,26==ce.Yj(t.H,n)&&ce.Cd(e,i),ce.Xc(t,e,o,r),2==a?ce.Xc(t,i,o,r):ce.Vc(t,i,o,r)}break;case 3:ce.Ed(t,g)&&(ce.Xc(t,g,o,r),ce.md(t,g.b-g.a,g.d-g.c,c),e.a=g.a+c.a,e.c=g.c+c.b,e.b=g.b+c.a,e.d=g.d+c.b,ce.Xc(t,e,o,r),e.a=g.a-c.a,e.c=g.c-c.b,e.b=g.b-c.a,e.d=g.d-c.b,ce.Xc(t,e,o,r))}-8==t.w&&ce.Id(t,-9)},ce.sd=function(n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p;for(g=!1,r=0;r<n.H.e;r++)l=null,ce.pk(n.H,r)?l=(h=ce.Pj(n.H,r))==(c=ce.Oj(n.H,r))?"["+h+"]":"["+h+":"+c+"]":0!=(ce.Xj(n.H,r)&Rt)?l=(ce.Xj(n.H,r)&Rt)==It?"a":64==(96&ce.Xj(n.H,r))?"r!a":"!a":0!=(96&ce.Xj(n.H,r))&&(l=64==(96&ce.Xj(n.H,r))?"r":"!r"),0!=(w=(ce.Xj(n.H,r)&Dt)>>15)&&(l=(null==l?"":l)+w),null!=l&&(e=ce.Nj(n.H,0,r),o=ce.Nj(n.H,1,r),g||(ce.dr(n,(2*n.S+1)/3|0),g=!0),d=(ce.dh(n.M,ce.Fj(n.H,e))+ce.dh(n.M,ce.Fj(n.H,o)))/2,p=(ce.eh(n.M,ce.Gj(n.H,e))+ce.eh(n.M,ce.Gj(n.H,o)))/2,a=ce.dh(n.M,ce.Fj(n.H,o))-ce.dh(n.M,ce.Fj(n.H,e)),s=ce.eh(n.M,ce.Gj(n.H,o))-ce.eh(n.M,ce.Gj(n.H,e)),i=t.Math.sqrt(a*a+s*s),f=.6*(m=He.XO(n.e,l),new ve.mP(0,0,m,0)).b,u=.55*n.j,0!=i&&(a>0?ce.ud(n,d+f*s/i,p-u*a/i,l,!0):ce.ud(n,d-f*s/i,p+u*a/i,l,!0)));g&&ce.dr(n,n.S)},ce.td=function(t,n,e,o){ue.Oh(t.V,new ve.mP(n-t.Q,e-t.Q,2*t.Q,2*t.Q)),t.G||ue.Oh(t.P,new ce.Pd(n,e,ce.hd(t,o)?-3:t.o[o]))},ce.ud=function(t,n,e,o,r){var i,a,s;r&&(a=(i=He.XO(t.e,o),new ve.mP(0,0,i,0)).b/2+(t.j/8|0),s=t.j/2|0,("+"==o||"-"==o)&&(s=2*s/3),ue.Oh(t.V,new ve.mP(n-a,e-s,2*a,2*s))),t.G||ce.Zq(t,o,n,e)},ce.vd=function(t){var n;n=t.a,t.a=t.b,t.b=n,n=t.c,t.c=t.d,t.d=n},ce.wd=function(n,e,o){var r;return r=0==e?wt+n[0]-n[n.length-1]:n[e]-n[e-1],r-=o>-2.0943951023931953&&o<Ft?2*t.Math.cos(o+Tt):.5*t.Math.cos(o+Tt)},ce.xd=function(t){var n;return n=new ve.lP,t.a<=t.b?(n.c=t.a,n.b=t.b-t.a):(n.c=t.b,n.b=t.a-t.b),t.c<=t.d?(n.d=t.c,n.a=t.d-t.c):(n.d=t.d,n.a=t.c-t.d),n},ce.yd=function(t,n){var e,o,r,i,a,s,u;for(e=Ke(re.fK,ut,5,ce.mm(t.H,n),15,1),r=0;r<ce.mm(t.H,n);r++)e[r]=ce.Mj(t.H,n,ce.zm(t.H,n,r));for(le.V$(e).sort(le.V$(Ie(ue.jX.prototype.Ub,ue.jX,[]))),i=ce.zd(e,0),a=ce.wd(e,0,i),o=1;o<e.length;o++)s=ce.zd(e,o),a<(u=ce.wd(e,o,s))&&(a=u,i=s);return i},ce.zd=function(t,n){var e;return n>0?(t[n]+t[n-1])/2:(e=gt+(t[0]+t[t.length-1])/2)>gt?e-wt:e},ce.Ad=function(t,n,e,o){var r,i,a,s;if(s=new ce.Qd,n.a!=n.b||n.c!=n.d){for(s.a=n.a,s.c=n.c,s.b=n.b,s.d=n.d,a=ce.xd(s),r=0;r<t.V.a.length;r++)if(!((i=ue.Th(t.V,r)).c>a.c+a.b||i.d>a.d+a.a||a.c>i.c+i.b||a.d>i.d+i.a)){if(ce.Bd(t,s.a,s.c,r)){if(ce.Bd(t,s.b,s.d,r))return;return ce.Fd(t,s,0,r),void ce.Ad(t,s,e,o)}if(ce.Bd(t,s.b,s.d,r))return ce.Fd(t,s,1,r),void ce.Ad(t,s,e,o)}ce.Zc(t,s,e,o)}},ce.Bd=function(t,n,e,o){var r;return 0==(1&t.B)&&(n>(r=ue.Th(t.V,o)).c&&n<r.c+r.b&&e>r.d&&e<r.d+r.a)},ce.Cd=function(t,n){var e;e=t.b,t.b=n.b,n.b=e,e=t.d,t.d=n.d,n.d=e},ce.Dd=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g;for(l=Ke(re.DN,ft,5,16,16,1),c=Ke(re.DN,ft,5,16,16,1),e=Ke(re.fK,ut,5,16,15,1),i=Ke(re.fK,ut,5,2,15,1),o=0,f=0;f<2;f++)for(r=ce.Nj(t.H,f,n),h=0;h<ce.Am(t.H,r);h++)if((s=ce.Bm(t.H,r,h))!=n){if(4==o)return 0;l[o]=ce.mn(t.H,s),c[o]=ce.xn(t.H,s),e[o++]=ce.Mj(t.H,r,ce.zm(t.H,r,h))}for(i[0]=ce.Mj(t.H,ce.Nj(t.H,0,n),ce.Nj(t.H,1,n)),i[0]<0?(i[1]=i[0]+gt,a=!1):(i[1]=i[0],i[0]=i[1]-gt,a=!0),w=0,u=0;u<o;u++)g=l[u]?20:c[u]?17:16,e[u]>i[0]&&e[u]<i[1]?w-=g:w+=g;return a?-w:w},ce.Ed=function(t,n){var e,o,r,i,a,s;if(n.a==n.b&&n.c==n.d){for(r=0;r<t.V.a.length;r++)if(a=ue.Th(t.V,r),ve.eP(a,n.a,n.c))return!1;return!0}for(s=ce.xd(n),e=!1,n.a>n.b&&(ce.vd(n),e=!0),o=0;o<t.V.a.length;o++)if(!((a=ue.Th(t.V,o)).c>s.c+s.b||a.d>s.d+s.a||s.c>a.c+a.b||s.d>a.d+a.a)){if(ce.Bd(t,n.a,n.c,o))return ce.Bd(t,n.b,n.d,o)?(e&&ce.vd(n),!1):(ce.Fd(t,n,0,o),i=ce.Ed(t,n),e&&ce.vd(n),i);if(ce.Bd(t,n.b,n.d,o))return ce.Fd(t,n,1,o),i=ce.Ed(t,n),e&&ce.vd(n),i}return e&&ce.vd(n),!0},ce.Fd=function(n,e,o,r){var i,a,s,u,f,l,c,h,w,g,m;0==o?(h=e.a,g=e.c,w=e.b,m=e.d):(h=e.b,g=e.d,w=e.a,m=e.c),c=ue.Th(n.V,r),f=w>h?c.c+c.b:c.c,l=m>g?c.d+c.a:c.d,i=w-h,a=m-g,t.Math.abs(i)>t.Math.abs(a)?g==m?(s=f,u=g):w>h==f>(s=h+i*(l-g)/a)?u=l:(s=f,u=g+a*(f-h)/i):h==w?(s=h,u=l):m>g==l>(u=g+a*(f-h)/i)?s=f:(s=h+i*(l-g)/a,u=l),0==o?(e.a=s,e.c=u):(e.b=s,e.d=u)},ce.Gd=function(t){var n,e,o,r;if(0!=t.H.o){for(ce.Jr(t.H,0!=(256&t.B)?63:0!=(512&t.B)?95:0!=(t.B&Gt)?159:31),ce.Tc(t),e=ce.Or(t.H),o=!1,t.o=Ke(re.hK,L,5,t.H.o,15,1),n=0;n<t.H.o;n++)t.o[n]=ce.sj(t.H,n),0!=t.o[n]&&(o=!0),ce.Bk(t.H,n)&&(t.o[n]=128),ce.ek(t.H,n)&&0==(t.B&B)&&(t.o[n]=256);for(ce.Id(t,-10),ce.ed(t),ce.dd(t),ce.fd(t),ce.Rc(t),ce.dr(t,t.S),ce.cr(t,t.T),ce.Id(t,t.L),ce.jd(t),t.P.a=Ke(re.nM,x,1,0,5,1),t.V.a=Ke(re.nM,x,1,0,5,1),r=0;r<t.H.o;r++)ce.hd(t,r)?(ce.Id(t,-3),ce.qd(t,r,e),ce.Id(t,t.L)):0!=t.o[r]?(ce.Id(t,t.o[r]),ce.qd(t,r,e),ce.Id(t,t.L)):!o&&1!=t.H.M&&1!=ce.Ij(t.H,r)&&6!=ce.Ij(t.H,r)&&0==(t.B&Ct)&&null==ce.yj(t.H,r)&&ce.Ij(t.H,r)<ce.Dc.length?(ce.Jd(t,ce.ad(ce.Dc[ce.Ij(t.H,r)])),ce.qd(t,r,e),ce.Id(t,t.L)):ce.qd(t,r,e);ce.pd(t),ce.sd(t),ce.od(t,e)}},ce.Hd=function(t,n,e,o){var r;switch(r=e/2,786432&o){case 786432:if(n){t.u.a=n.c+n.b/2,t.u.b=n.d+n.a-r;break}case 0:t.u.a=t.t.c+t.t.b/2,t.u.b=t.t.d+t.t.a+r,n&&t.u.b>n.d+n.a-r&&(t.u.b=n.d+n.a-r);break;case It:if(n){t.u.a=n.c+n.b/2,t.u.b=n.d+r;break}case Bt:t.u.a=t.t.c+t.t.b/2,t.u.b=t.t.d-r,n&&t.u.b<n.d+r&&(t.u.b=n.d+r)}},ce.Id=function(t,n){if(!t.G&&(-10==n&&(t.w=-999,n=t.L),n!=t.w&&(-8!=t.w||-9==n)))switch(-8==n&&(t.J=t.w),-9==n&&(n=t.J),t.w=n,n){case 0:ce.br(t,(He.MO(),He.JO));break;case-6:ce.br(t,t.A);break;case-4:ce.br(t,t.I);break;case-2:ce.br(t,t.r);break;case-3:ce.br(t,t.s);break;case-7:ce.br(t,t.C);break;case-8:ce.br(t,t.D);break;case-5:ce.br(t,t.K);break;case 64:ce.br(t,ce.Hc);break;case 128:ce.br(t,ce.Nc);break;case 256:ce.br(t,ce.Lc);break;case 192:ce.br(t,ce.Kc);break;case 320:ce.br(t,ce.Mc);break;case 384:ce.br(t,ce.Ic);break;case 448:ce.br(t,ce.Jc);break;case 1:ce.br(t,(He.MO(),He.KO));break;default:ce.br(t,(He.MO(),He.JO))}},ce.Jd=function(t,n){t.w=-5,t.K=n,t.d="rgb("+(n.c>>16&255)+","+(n.c>>8&255)+","+(255&n.c)+")"},ce.Kd=function(t){var n,e,o,r,i;for(r=ce.dh(t.M,ce.Fj(t.H,0)),e=ce.dh(t.M,ce.Fj(t.H,0)),i=ce.eh(t.M,ce.Gj(t.H,0)),o=ce.eh(t.M,ce.Gj(t.H,0)),n=0;n<t.H.o;n++)r>ce.dh(t.M,ce.Fj(t.H,n))&&(r=ce.dh(t.M,ce.Fj(t.H,n))),e<ce.dh(t.M,ce.Fj(t.H,n))&&(e=ce.dh(t.M,ce.Fj(t.H,n))),i>ce.eh(t.M,ce.Gj(t.H,n))&&(i=ce.eh(t.M,ce.Gj(t.H,n))),o<ce.eh(t.M,ce.Gj(t.H,n))&&(o=ce.eh(t.M,ce.Gj(t.H,n)));t.t=new ve.mP(r,i,e-r,o-i)},ce.Ld=function(t,n){var e,o;return 0==t.H.o?null:(ce.Kd(t),e=t.M.c*ce.Jj(t.H),1==(o=new ce.gh(t.t,n,e)).c&&0==o.a&&0==o.b?o=null:(ce.$g(o,t.M),ce.ah(o,t.t)),ce.Hd(t,n,e,K),o)},ce.Md=function(t){var n;He.MO(),n=He.IO,t.r=pe.bG(n,ce.Fc),t.s=pe.aG(ce.Gc,n),t.C=ce.Ec,t.D=ce.Oc},ce.Nd=function(t,n){var e,o,r,i;if(0==t.H.o)return null;for(r=ce.er(t,n),ce.Jr(t.H,0!=(256&t.B)?63:0!=(512&t.B)?95:0!=(t.B&Gt)?159:31),ce.jd(t),t.P.a=Ke(re.nM,x,1,0,5,1),t.V.a=Ke(re.nM,x,1,0,5,1),ce.Tc(t),ce.dr(t,t.S),t.G=!0,o=0;o<t.H.o;o++)ce.qd(t,o,null);return t.G=!1,e=t.M.c*ce.Jj(t.H),ce.$c(t,e),ce.Hd(t,n,e,K),ve.cP(n,t.t)?r:(i=new ce.gh(t.t,n,e),ce.$g(i,t.M),ce.ah(i,t.t),ce._g(i,t.u),r?(ce.$g(i,r),r):i)},ce.Od=function(t,n){ce.Qc(this),this.H=t,this.B=n,ce.gd(this)},Te(161,1,{}),a.v=0,a.w=0,a.B=0,a.F=0,a.G=!1,a.J=0,a.L=0,a.N=0,a.O=0,a.Q=0,a.R=0,a.S=0,a.T=0,a.U=0,re.lK=vo(161),ce.Pd=function(t,n,e){this.b=t,this.c=n,this.a=e},Te(75,1,{75:1},ce.Pd),a.a=0,a.b=0,a.c=0,re.jK=vo(75),ce.Qd=function(){},Te(38,1,{},ce.Qd),a.a=0,a.b=0,a.c=0,a.d=0,re.kK=vo(38),ce.Rd=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,x,k,R,I,D,F,T,B,$,P,K,V,E,O,Y,U,q;for(R=Ke(re.DN,ft,5,n.i.a.length,16,1),H=Ke(re.hK,L,5,t.f.d,15,1),E=0;E<n.i.a.length;E++){for(R[E]=!0,p=0,G=(d=ue.Th(n.j,E)).length;p<G;++p)if(b=d[p],!t.e[b]){R[E]=!1;break}if(R[E])for(a=0,f=(o=ue.Th(n.i,E)).length;a<f;++a)++H[e=o[a]]}for(k=Ke(re.DN,ft,5,t.f.d,16,1),O=0;O<n.i.a.length;O++)if((3==(Y=ue.Th(n.j,O).length)||5==Y||6==Y||7==Y)&&R[O]){for(s=0,l=(r=ue.Th(n.i,O)).length;s<l;++s)k[e=r[s]]=!0;for(P=!0,F=-1,T=0,u=0,c=(i=ue.Th(n.i,O)).length;u<c;++u)if(e=i[u],6==Y||H[e]>1){if(!ce.Vd(t,e,!1)){P=!1;break}}else if(V=5==Y?ce.Sd(t,e,!1):ce.Td(t,e,!1),ce.Vd(t,e,!1))T<V&&(T=V,F=e);else{if(10==T){P=!1;break}F=e,T=20}if(P)for(a=0,f=(o=ue.Th(n.i,O)).length;a<f;++a)(e=o[a])==F?(5==Y?ce.Sd(t,e,!0):ce.Td(t,e,!0),ce.ee(t,e)):ce.Vd(t,e,!0)}for(N=Ke(re.hK,L,5,t.f.d,15,1),M=Ke(re.DN,ft,5,t.f.d,16,1),m=0;m<t.f.e;m++)h=ce.Nj(t.f,0,m),w=ce.Nj(t.f,1,m),k[h]||k[w]||(t.e[m]&&(++N[h],++N[w]),32==ce.Yj(t.f,m)&&(M[h]=!0,M[w]=!0));for(K=Ke(re.hK,L,5,t.f.d,15,1),v=Ke(re.hK,L,5,t.f.d,15,1),q=0;q<t.f.d;q++)if(1==N[q])for(v[0]=q,j=0,A=0;j<=A;){for(S=0;S<ce.Am(t.f,v[j]);S++)if(t.e[ce.Bm(t.f,v[j],S)]&&(y=ce.zm(t.f,v[j],S),(0==j||y!=v[j-1])&&0!=N[y])){if(v[++A]=y,0!=(1&N[y])){for(D=1;D<A;D+=2)K[v[D]]=-1;A=0}break}++j}for(g=Ke(re.DN,ft,5,t.f.d,16,1),U=0;U<t.f.d;U++)if(!g[U]&&0!=N[U]){for(v[0]=U,g[U]=!0,j=0,A=0;j<=A;){for(S=0;S<ce.Am(t.f,v[j]);S++)t.e[ce.Bm(t.f,v[j],S)]&&(g[y=ce.zm(t.f,v[j],S)]||(v[++A]=y,g[y]=!0));++j}if(0==(1&A)){for(C=0;C<=A;C++)0==K[v[C]]&&(K[v[C]]=ce.Ud(t,v[C],!1));for(I=!0,x=0;x<=A;x++)if(K[v[x]]<=0&&!ce.Vd(t,v[x],!1)){I=!1;break}if(I){for($=0,B=-1,S=0;S<=A;S++)$<K[v[S]]&&($=K[v[S]],B=v[S]);$>0&&(ce.Ud(t,B,!0),ce.ee(t,B))}}}},ce.Sd=function(t,n,e){if(7==ce.Ij(t.f,n)){if(3==ce.mm(t.f,n))return 6;if(2==ce.Am(t.f,n))return 4}else{if(8==ce.Ij(t.f,n))return 10;if(15==ce.Ij(t.f,n)||33==ce.Ij(t.f,n)){if(3==ce.Am(t.f,n))return 8}else if(16==ce.Ij(t.f,n)||34==ce.Ij(t.f,n)||52==ce.Ij(t.f,n)){if(2==ce.Am(t.f,n))return 12}else if(6==ce.Ij(t.f,n))return e&&ce.Vk(t.f,n,-1),ce.mm(t.f,n)!=ce.nm(t.f,n)?2:3}return 0},ce.Td=function(t,n,e){if(t.a){if(3!=ce.mm(t.f,n))return 0}else if(ce.mm(t.f,n)>3)return 0;return 6==ce.Ij(t.f,n)?(e&&ce.Vk(t.f,n,1),2):5==ce.Ij(t.f,n)?4:0},ce.Ud=function(t,n,e){if(0!=ce.rj(t.f,n))return 0;if(t.a){if(5==ce.Ij(t.f,n))return 2!=ce.Sm(t.f,n)?0:(e&&ce.Vk(t.f,n,1),1);if(7==ce.Ij(t.f,n))return 2!=ce.Sm(t.f,n)?0:(e&&ce.Vk(t.f,n,-1),ce.Xd(t,n)?6:3);if(8==ce.Ij(t.f,n))return 1!=ce.Sm(t.f,n)?0:(e&&ce.Vk(t.f,n,-1),ce.Xd(t,n)?7:4);if(16==ce.Ij(t.f,n))return 1!=ce.Sm(t.f,n)?0:(e&&ce.Vk(t.f,n,-1),ce.Xd(t,n)?5:2);if(34==ce.Ij(t.f,n))return 1!=ce.Sm(t.f,n)?0:(e&&ce.Vk(t.f,n,-1),ce.Xd(t,n)?4:1)}else{if(5==ce.Ij(t.f,n))return ce.Sm(t.f,n)>2?0:(e&&ce.Vk(t.f,n,1),1);if(7==ce.Ij(t.f,n))return ce.Sm(t.f,n)>2?0:(e&&ce.Vk(t.f,n,-1),ce.Xd(t,n)?5:3);if(8==ce.Ij(t.f,n))return ce.Sm(t.f,n)>1?0:(e&&ce.Vk(t.f,n,-1),ce.Xd(t,n)?7:4);if(16==ce.Ij(t.f,n))return ce.Sm(t.f,n)>1?0:(e&&ce.Vk(t.f,n,-1),ce.Xd(t,n)?5:2)}return 0},ce.Vd=function(t,n,e){var o;if((o=ce.Ij(t.f,n))>=5&&o<=8||15==o||16==o||33==o||34==o||52==o){if(0!=ce.Om(t.f,n))return!0;if(0==ce.rj(t.f,n)){if(15==o||33==o)return e&&ce.Vk(t.f,n,1),!0;if(16==o||34==o||52==o)return e&&ce.Vk(t.f,n,1),!0;if(5==o)return e&&ce.Vk(t.f,n,-1),!0;if(7==o||8==o)return e&&ce.Vk(t.f,n,1),!0}}return!1},ce.Wd=function(t,n,e,o){var r;for(r=0;r<ce.Am(t.f,n);r++)if(1==o[ce.Bm(t.f,n,r)]&&ce.zm(t.f,n,r)!=e)return r;return-1},ce.Xd=function(t,n){var e;for(e=0;e<ce.Am(t.f,n);e++)if(ce.xk(t.f,ce.zm(t.f,n,e)))return!0;return!1},ce.Yd=function(t,n,e){var o;for(o=0;o<ce.Am(t.f,n);o++)if(e[ce.Bm(t.f,n,o)]>1)return!0;return!1},ce.Zd=function(t,n){var e;for(e=0;e<ce.Am(t.f,n);e++)if(t.e[ce.Bm(t.f,n,e)])return!0;return!1},ce.$d=function(t,n,e){var o,r,i,a,s,u,f,l,c,h;if(ce.Jr(t.f,1),null!=n)t.e=n;else for(t.e=Ke(re.DN,ft,5,t.f.e,16,1),r=0;r<t.f.e;r++)64==ce.Yj(t.f,r)&&(t.e[r]=!0,ce.wl(t.f,r,1));for(t.g=0,t.d=Ke(re.DN,ft,5,t.f.d,16,1),i=0;i<t.f.e;i++)if(t.e[i])for(++t.c,s=0;s<2;s++)t.d[ce.Nj(t.f,s,i)]||(t.d[ce.Nj(t.f,s,i)]=!0,++t.b);if(0==t.c)return!0;for(t.a=!1,ce.ge(t,e),t.f.I&&ce.ae(t),h=new ce.aq(t.f,1),e&&ce.Rd(t,h),ce.he(t,h),ce.de(t,h),ce.fe(t),ce.be(t);ce.ce(t,h);)ce.be(t);for(;0!=t.c;){if(!(a=!1))for(l=0;l<h.i.a.length;l++)if(6==ue.Th(h.j,l).length){for(f=!0,c=ue.Th(h.j,l),u=0;u<6;u++)if(!t.e[c[u]]){f=!1;break}if(f){for(s=0;s<6;s+=2)ce._d(t,c[s]);a=!0;break}}if(!a)for(o=0;o<t.f.e;o++)if(t.e[o]){ce._d(t,o),ce.be(t),a=!0;break}}return t.b==t.g},ce._d=function(t,n){var e,o,r,i;for(1==ce.Yj(t.f,n)&&(ce.wl(t.f,n,2),t.g+=2),r=0;r<2;r++)for(e=ce.Nj(t.f,r,n),i=0;i<ce.Am(t.f,e);i++)o=ce.Bm(t.f,e,i),t.e[o]&&(t.e[o]=!1,--t.c)},ce.ae=function(t){var n,e,o,r,i,a,s,u;for(e=0;e<t.f.e;e++)if(t.e[e])for(r=0;r<2;r++){for(s=ce.Nj(t.f,r,e),n=!1,a=0;a<ce.Am(t.f,s);a++)if(e!=ce.Bm(t.f,s,a)&&t.e[ce.Bm(t.f,s,a)]){n=!0;break}if(!n){for(u=e,o=ce.Nj(t.f,1-r,e);-1!=u;)for(t.e[u]=!1,--t.c,ce.wl(t.f,u,64),u=-1,s=o,i=0;i<ce.Am(t.f,s);i++)if(t.e[ce.Bm(t.f,s,i)]){if(-1!=u){s=-1,u=-1;break}u=ce.Bm(t.f,s,i),o=ce.zm(t.f,s,i)}break}}},ce.be=function(t){var n,e,o,r,i,a,s;do{for(s=!1,e=0;e<t.f.e;e++)if(t.e[e]){for(i=!1,r=0;r<2;r++){for(o=ce.Nj(t.f,r,e),n=!1,a=0;a<ce.Am(t.f,o);a++)if(e!=ce.Bm(t.f,o,a)&&t.e[ce.Bm(t.f,o,a)]){n=!0;break}if(!n){i=!0;break}}i&&(s=!0,ce._d(t,e))}}while(s)},ce.ce=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g;for(g=Ke(re.hK,L,5,t.f.e,15,1),h=0;h<n.i.a.length;h++){for(w=ue.Th(n.j,h),c=!0,l=0;l<w.length;l++)if(!t.e[w[l]]){c=!1;break}if(c)for(f=0;f<w.length;f++)++g[w[f]]}for(u=t.c,i=0;i<t.f.e;i++)if(1==g[i])for(f=0;f<2&&t.e[i];f++)if(e=ce.Nj(t.f,f,i),o=ce.Nj(t.f,1-f,i),ce.Yd(t,e,g)&&!ce.Yd(t,o,g))for(;-1!=(s=ce.Wd(t,o,e,g))&&(r=ce.zm(t.f,o,s),a=ce.Bm(t.f,o,s),t.e[a])&&(ce._d(t,a),-1!=(s=ce.Wd(t,r,o,g)));)e=r,o=ce.zm(t.f,r,s);return u!=t.c},ce.de=function(t,n){var e;for(e=0;e<t.f.e;e++)t.e[e]&&ce.Yp(n,e)&&(ce.ee(t,ce.Nj(t.f,0,e)),ce.ee(t,ce.Nj(t.f,1,e)))},ce.ee=function(t,n){var e,o;for(t.d[n]&&(t.d[n]=!1,--t.b),o=0;o<ce.Am(t.f,n);o++)e=ce.Bm(t.f,n,o),t.e[e]&&(t.e[e]=!1,--t.c)},ce.fe=function(t){var n,e,o,r,i;for(e=0;e<t.f.e;e++)if(2==ce.Vj(t.f,e))for(r=0;r<2;r++)if(n=ce.Nj(t.f,r,e),ce.Ij(t.f,n)<=8)for(i=0;i<ce.Am(t.f,n);i++)if(o=ce.Bm(t.f,n,i),t.e[o]){ce.ee(t,n);break}},ce.ge=function(t,n){var e;for(e=0;e<t.f.d;e++)t.d[e]&&0==ce.Om(t.f,e)&&(!n||!ce.uk(t.f,e)||ce.rj(t.f,e)>0)&&ce.ee(t,e)},ce.he=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w;for(l=0;l<n.i.a.length;l++)if(3==(w=ue.Th(n.j,l).length)||5==w||7==w)for(c=ue.Th(n.i,l),o=0;o<w;o++)e=c[o],ce.Zd(t,e)&&(5==w?(6==ce.Ij(t.f,e)&&-1==ce.rj(t.f,e)&&3==ce.mm(t.f,e)||7==ce.Ij(t.f,e)&&0==ce.rj(t.f,e)&&3==ce.mm(t.f,e)||8==ce.Ij(t.f,e)&&0==ce.rj(t.f,e)&&2==ce.Am(t.f,e)||16==ce.Ij(t.f,e)&&0==ce.rj(t.f,e)&&2==ce.Am(t.f,e)||34==ce.Ij(t.f,e)&&0==ce.rj(t.f,e)&&2==ce.Am(t.f,e))&&ce.ee(t,e):(5==ce.Ij(t.f,e)&&0==ce.rj(t.f,e)&&3==ce.mm(t.f,e)||6==ce.Ij(t.f,e)&&1==ce.rj(t.f,e))&&ce.ee(t,e));for(f=0;f<n.i.a.length;f++)if(5==ue.Th(n.j,f).length){for(h=ue.Th(n.j,f),i=!0,r=0;r<h.length;r++)if(!t.e[h[r]]){i=!1;break}if(i){for(c=ue.Th(n.i,f),s=0,a=-1,o=0;o<h.length;o++)-1==ce.rj(t.f,c[o])&&6==ce.Ij(t.f,c[o])&&s<(u=3==ce.mm(t.f,c[o])?3:3==ce.nm(t.f,c[o])?2:1)&&(s=u,a=c[o]);-1!=a&&ce.ee(t,a)}}},ce.ie=function(t){this.f=t},Te(72,1,{},ce.ie),a.a=!1,a.b=0,a.c=0,a.g=0,re.mK=vo(72),ce.je=function(t,n,e,o,r,i,a){var s,u,f,l;for(f=0,u=0;u<t.N.d;u++)0!=(ce.Dj(t.N,t.u[u])&r)&&++f;if(0==f)return!1;for(n>15&&(ce.ff(t,e),n-=16),ce.$e(t,1,1),ce.$e(t,n,4),ce.$e(t,f,o),s=0;s<t.N.d;s++)0!=(l=ce.Dj(t.N,t.u[s])&r)&&(ce.$e(t,s,o),1!=i&&ce.$e(t,l>>a,i));return!0},ce.ke=function(t,n,e,o,r,i,a){var s,u,f,l;for(f=0,u=0;u<t.N.e;u++)0!=(ce.Xj(t.N,t.v[u])&r)&&++f;if(0==f)return!1;for(n>15&&(ce.ff(t,e),n-=16),ce.$e(t,1,1),ce.$e(t,n,4),ce.$e(t,f,o),s=0;s<t.N.e;s++)0!=(l=ce.Xj(t.N,t.v[s])&r)&&(ce.$e(t,s,o),1!=i&&ce.$e(t,l>>a,i));return!0},ce.le=function(t){for(var n,e,o,r,i,a;;){for(i=Ke(re.DN,ft,5,t.Q+1,16,1),o=-1,e=0;e<t.N.d;e++)0!=ce.Om(t.N,e)&&(i[t.c[e]]&&o<t.c[e]&&(o=t.c[e]),i[t.c[e]]=!0);if(-1==o)break;for(r=0,n=0;n<t.N.d;n++)a=0,t.c[n]==o&&(a=++r),ce._f(t.b[n],n),ce.Yf(t.b[n],16,ao(t.c[n])),ce.Yf(t.b[n],8,re.SN(a));t.Q=ce.Je(t)}},ce.me=function(t,n,e){var o,r,i,a,s;return(6==ce.Ij(t.N,n)||7==ce.Ij(t.N,n))&&(r=ce.zm(t.N,n,0),i=ce.zm(t.N,n,1),1==ce.qm(t.N,r)&&1==ce.qm(t.N,i)&&(1!=ce.Am(t.N,r)&&1!=ce.Am(t.N,i)&&(!(ce.mm(t.N,r)>3||ce.mm(t.N,i)>3)&&(!((a=new ce.Fi(t.N,t.c,n,r)).f&&!e)&&(!((s=new ce.Fi(t.N,t.c,n,i)).f&&!e)&&((!a.f||!s.f)&&(e&&(a.f&&a.c&&(t.S[n]=!0),s.f&&s.c&&(t.S[n]=!0)),o=t.fb?ce.oe(t,a,s):ce.ne(a,s),e?(t.V&&0!=(2&t.M)||!t.V&&0!=(4&t.M))&&(a.f&&(1==o?(ce.Zf(t.b[a.b],64),ce.Zf(t.b[a.d],16)):(ce.Zf(t.b[a.b],16),ce.Zf(t.b[a.d],64))),s.f&&(2==o?(ce.Zf(t.b[s.b],64),ce.Zf(t.b[s.d],16)):(ce.Zf(t.b[s.b],16),ce.Zf(t.b[s.d],64)))):t._[n]=o,!0)))))))},ce.ne=function(t,n){var e,o,r;if(o=ce.Ei(t),r=ce.Ei(n),-1==o||-1==r||0==(o+r&1))return 3;switch(e=0,o+r){case 3:case 7:e=2;break;case 5:e=1}return e},ce.oe=function(n,e,o){var r,i;return(r=Ke(re.hK,L,5,4,15,1))[0]=e.b,r[1]=e.a,r[2]=o.a,r[3]=o.b,i=ce.Xi(n.N,r),t.Math.abs(i)<.3||t.Math.abs(i)>$t?3:i<0?2:1},ce.pe=function(t,n,e){var o,r,i,a,s;return!!ce.nn(t.N,n)&&(o=ce.Nj(t.N,0,n),r=ce.Nj(t.N,1,n),!((a=new ce.Fi(t.N,t.c,o,r)).f&&!e)&&(!((s=new ce.Fi(t.N,t.c,r,o)).f&&!e)&&((!a.f||!s.f)&&(e&&(a.f&&(t.R[n]=ce.uf(t,r)),s.f&&(t.R[n]=ce.uf(t,o))),i=t.fb?ce.re(t,a,s):ce.qe(a,s),e?(t.V&&0!=(2&t.M)||!t.V&&0!=(4&t.M))&&(a.f&&(2==i?(ce.Zf(t.b[a.b],4),ce.Zf(t.b[a.d],1)):(ce.Zf(t.b[a.b],1),ce.Zf(t.b[a.d],4))),s.f&&(2==i?(ce.Zf(t.b[s.b],4),ce.Zf(t.b[s.d],1)):(ce.Zf(t.b[s.b],1),ce.Zf(t.b[s.d],4)))):t.j[n]=i,!0))))},ce.qe=function(t,n){var e,o,r;if(o=ce.Ei(t),r=ce.Ei(n),-1==o||-1==r||0==(o+r&1))return 3;switch(e=0,o+r){case 3:case 7:e=1;break;case 5:e=2}return e},ce.re=function(n,e,o){var r,i;return(r=Ke(re.hK,L,5,4,15,1))[0]=e.b,r[1]=e.a,r[2]=o.a,r[3]=o.b,i=ce.Xi(n.N,r),t.Math.abs(i)<.3||t.Math.abs(i)>$t?3:i<0?1:2},ce.se=function(t,n,e){var o,r,i,a,s;return 0==t.j[n]&&(1==ce.Vj(t.N,n)?ce.pe(t,n,e):2==ce.Vj(t.N,n)&&(!ce.mn(t.N,n)&&(r=ce.Nj(t.N,0,n),i=ce.Nj(t.N,1,n),1!=ce.Am(t.N,r)&&1!=ce.Am(t.N,i)&&(!(ce.Am(t.N,r)>3||ce.Am(t.N,i)>3)&&(2!=ce.qm(t.N,r)&&2!=ce.qm(t.N,i)&&(!((a=new ce.Fi(t.N,t.c,i,r)).f&&!e)&&(!((s=new ce.Fi(t.N,t.c,r,i)).f&&!e)&&((!a.f||!s.f)&&(e&&(a.f&&a.c&&(t.R[n]=!0),s.f&&s.c&&(t.R[n]=!0)),o=ce.tk(t.N,n)?3:t.fb?ce.ue(t,a,s):ce.te(a,s),e?0!=(2&t.M)&&(a.f&&(1==o?(ce.Zf(t.b[a.b],4),ce.Zf(t.b[a.d],1)):2==o&&(ce.Zf(t.b[a.b],1),ce.Zf(t.b[a.d],4))),s.f&&(1==o?(ce.Zf(t.b[s.b],4),ce.Zf(t.b[s.d],1)):2==o&&(ce.Zf(t.b[s.b],1),ce.Zf(t.b[s.d],4)))):t.j[n]=o,!0)))))))))},ce.te=function(t,n){return-1==ce.Ei(t)||-1==ce.Ei(n)||0!=(1&(ce.Ei(t)|ce.Ei(n)))?3:ce.Ei(t)==ce.Ei(n)?1:2},ce.ue=function(n,e,o){var r,i,a,s,u;return(r=Ke(re.fK,ut,5,3,15,1))[0]=ce.Fj(n.N,o.a)-ce.Fj(n.N,e.a),r[1]=ce.Gj(n.N,o.a)-ce.Gj(n.N,e.a),r[2]=ce.Hj(n.N,o.a)-ce.Hj(n.N,e.a),(s=Ke(re.fK,ut,5,3,15,1))[0]=ce.Fj(n.N,e.b)-ce.Fj(n.N,e.a),s[1]=ce.Gj(n.N,e.b)-ce.Gj(n.N,e.a),s[2]=ce.Hj(n.N,e.b)-ce.Hj(n.N,e.a),(u=Ke(re.fK,ut,5,3,15,1))[0]=ce.Fj(n.N,o.b)-ce.Fj(n.N,o.a),u[1]=ce.Gj(n.N,o.b)-ce.Gj(n.N,o.a),u[2]=ce.Hj(n.N,o.b)-ce.Hj(n.N,o.a),(i=Ke(re.fK,ut,5,3,15,1))[0]=r[1]*s[2]-r[2]*s[1],i[1]=r[2]*s[0]-r[0]*s[2],i[2]=r[0]*s[1]-r[1]*s[0],(a=Ke(re.fK,ut,5,3,15,1))[0]=r[1]*i[2]-r[2]*i[1],a[1]=r[2]*i[0]-r[0]*i[2],a[2]=r[0]*i[1]-r[1]*i[0],(s[0]*a[0]+s[1]*a[1]+s[2]*a[2])/(t.Math.sqrt(s[0]*s[0]+s[1]*s[1]+s[2]*s[2])*t.Math.sqrt(a[0]*a[0]+a[1]*a[1]+a[2]*a[2]))<0^(u[0]*a[0]+u[1]*a[1]+u[2]*a[2])/(t.Math.sqrt(u[0]*u[0]+u[1]*u[1]+u[2]*u[2])*t.Math.sqrt(a[0]*a[0]+a[1]*a[1]+a[2]*a[2]))<0?1:2},ce.ve=function(t,n){var e,o,r,i;return e=ce.pj(t.N,n),i=-1,(o=ce.Mm(t.N,n,!1))!=(r=ce.Mm(t.N,n,!0))?i=-1!=e&&e>o?e<<24>>24:o<<24>>24:-1!=e?(e>r||e<r&&e>=ce.Sm(t.N,n))&&(i=e<<24>>24):ce.Pn(t.N,n)||0==ce.Em(t.N,n)||(i=ce.Sm(t.N,n),i-=ce.ak(t.N,n,i)),ce.Qe(t,n,i),i},ce.we=function(t){var n,e,o,r,i,a,s,u,f,l,c;for(o=Ke(re.hK,L,5,t.K,15,1),n=0;n<t.N.d;n++){for(l=ce.Am(t.N,n)+ce.Pm(t.N,n),f=0,i=0;i<ce.nm(t.N,n);i++)if(i<ce.Am(t.N,n)||i>=ce.mm(t.N,n)){for(c=2*t.c[ce.zm(t.N,n,i)],e=ce.Bm(t.N,n,i),2==ce.Vj(t.N,e)&&(ce.mn(t.N,e)||++c),s=0;s<f&&!(c<o[s]);s++);for(u=f;u>s;u--)o[u]=o[u-1];o[s]=c,++f}for(ce._f(t.b[n],n),ce.Yf(t.b[n],16,ao(t.c[n])),a=l;a<t.K;a++)ce.Yf(t.b[n],17,0);for(r=0;r<l;r++)ce.Yf(t.b[n],17,re.SN(o[r]))}},ce.xe=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g;if(0!=t._[n])return!1;if(5!=ce.Ij(t.N,n)&&6!=ce.Ij(t.N,n)&&7!=ce.Ij(t.N,n)&&14!=ce.Ij(t.N,n)&&15!=ce.Ij(t.N,n)&&16!=ce.Ij(t.N,n))return!1;if(0!=ce.qm(t.N,n)){if(ce.on(t.N,n))return ce.me(t,n,e);if(15!=ce.Ij(t.N,n)&&16!=ce.Ij(t.N,n))return!1}if(ce.Am(t.N,n)<3||ce.mm(t.N,n)>4)return!1;if(ce.rj(t.N,n)>0&&6==ce.Ij(t.N,n))return!1;if(5==ce.Ij(t.N,n)&&4!=ce.mm(t.N,n))return!1;if(7==ce.Ij(t.N,n)&&!t.O[n])return!1;for(w=Ke(re.hK,L,5,4,15,1),g=Ke(re.hK,L,5,4,15,1),f=Ke(re.DN,ft,5,4,16,1),s=0;s<ce.mm(t.N,n);s++){for(i=-1,r=0,u=0;u<ce.mm(t.N,n);u++)f[u]||i<t.c[ce.zm(t.N,n,u)]&&(i=t.c[ce.zm(t.N,n,u)],r=u);w[s]=r,g[s]=i,f[r]=!0}if(4==ce.mm(t.N,n)&&g[0]==g[1]&&g[2]==g[3])return!1;if(4==ce.mm(t.N,n)&&(g[0]==g[2]||g[1]==g[3]))return!1;if(3==ce.mm(t.N,n)&&g[0]==g[2])return!1;for(l=0,c=0,h=!1,a=1;a<ce.mm(t.N,n);a++)if(g[a-1]==g[a]){if(!e||0==g[a])return!1;l=ce.zm(t.N,n,w[a-1]),c=ce.zm(t.N,n,w[a]),ce.xn(t.N,ce.Bm(t.N,n,w[a]))&&(t.S[n]=!0),h=!0}return!(e&&!h)&&(o=t.fb?ce.ze(t,n,w):ce.ye(t,n,w),e?(t.V&&0!=(2&t.M)||!t.V&&0!=(4&t.M))&&(1==o?(ce.Zf(t.b[l],Gt),ce.Zf(t.b[c],256)):2==o&&(ce.Zf(t.b[l],256),ce.Zf(t.b[c],Gt))):t._[n]=o,!0)},ce.ye=function(t,n,e){var o,r,i,a,s,u,f,l,c,h;for(h=Oe($e(re.hK,2),Pt,6,0,[Oe($e(re.hK,1),L,5,15,[2,1,2,1]),Oe($e(re.hK,1),L,5,15,[1,2,2,1]),Oe($e(re.hK,1),L,5,15,[1,1,2,2]),Oe($e(re.hK,1),L,5,15,[2,1,1,2]),Oe($e(re.hK,1),L,5,15,[2,2,1,1]),Oe($e(re.hK,1),L,5,15,[1,2,1,2])]),o=Ke(re.fK,ut,5,ce.mm(t.N,n),15,1),a=0;a<ce.mm(t.N,n);a++)o[a]=ce.Mj(t.N,ce.zm(t.N,n,e[a]),n);if(3!=(f=ce.Gm(t.N,n,e,o,null)<<24>>24))return f;for(l=0,c=0,s=0;s<ce.mm(t.N,n);s++)r=ce.Bm(t.N,n,e[s]),ce.Nj(t.N,0,r)==n&&(9==ce.Yj(t.N,r)&&(0!=c&&ce.Fl(t.N,n),l=s,c=1),17==ce.Yj(t.N,r)&&(0!=c&&ce.Fl(t.N,n),l=s,c=2));if(0==c)return 3;for(i=1;i<ce.mm(t.N,n);i++)o[i]<o[0]&&(o[i]+=wt);if(3==ce.mm(t.N,n)){switch(l){case 0:(o[1]<o[2]&&o[2]-o[1]<gt||o[1]>o[2]&&o[1]-o[2]>gt)&&(c=3-c);break;case 1:o[2]-o[0]>gt&&(c=3-c);break;case 2:o[1]-o[0]<gt&&(c=3-c)}return 1==c?2:1}return u=0,o[1]<=o[2]&&o[2]<=o[3]?u=0:o[1]<=o[3]&&o[3]<=o[2]?u=1:o[2]<=o[1]&&o[1]<=o[3]?u=2:o[2]<=o[3]&&o[3]<=o[1]?u=3:o[3]<=o[1]&&o[1]<=o[2]?u=4:o[3]<=o[2]&&o[2]<=o[1]&&(u=5),h[u][l]==c?2:1},ce.ze=function(n,e,o){var r,i,a,s,u;for(r=Ke(re.hK,L,5,4,15,1),s=0;s<ce.mm(n.N,e);s++)r[s]=ce.zm(n.N,e,o[s]);for(3==ce.mm(n.N,e)&&(r[3]=e),i=Pe(re.fK,[p,ut],[14,5],15,[3,3],2),a=0;a<3;a++)i[a][0]=ce.Fj(n.N,r[a+1])-ce.Fj(n.N,r[0]),i[a][1]=ce.Gj(n.N,r[a+1])-ce.Gj(n.N,r[0]),i[a][2]=ce.Hj(n.N,r[a+1])-ce.Hj(n.N,r[0]);return(u=Ke(re.fK,ut,5,3,15,1))[0]=i[0][1]*i[1][2]-i[0][2]*i[1][1],u[1]=i[0][2]*i[1][0]-i[0][0]*i[1][2],u[2]=i[0][0]*i[1][1]-i[0][1]*i[1][0],(i[2][0]*u[0]+i[2][1]*u[1]+i[2][2]*u[2])/(t.Math.sqrt(i[2][0]*i[2][0]+i[2][1]*i[2][1]+i[2][2]*i[2][2])*t.Math.sqrt(u[0]*u[0]+u[1]*u[1]+u[2]*u[2]))>0?1:2},ce.Ae=function(t){var n,e;for(n=0,ue.dX(t.b),e=0;e<t.b.length;e++)(0==e||0!=ce.$f(t.b[e],t.b[e-1]))&&++n,t.c[t.b[e].a]=n;return n},ce.Be=function(t){var n,e,o,r,i,a,s,u,f,l,c,h;if(!t.t)for(t.t=new ue.gi,l=0,c=Ke(re.hK,L,5,t.N.d,15,1),a=Ke(re.hK,L,5,t.N.d,15,1),u=Ke(re.hK,L,5,t.N.e,15,1),n=0;n<t.N.d;n++)if(0==c[n]&&(ce.wn(t.N,n)||1==ce.qm(t.N,n))){for(a[0]=n,s=1,f=0,c[n]=++l,e=Ke(re.DN,ft,5,t.N.e,16,1),i=0;i<s;i++)for(h=0;h<ce.Am(t.N,a[i]);h++)r=ce.Bm(t.N,a[i],h),(ce.xn(t.N,r)||2==ce.Vj(t.N,r)||ce.nn(t.N,r))&&(o=ce.zm(t.N,a[i],h),e[r]||(u[f++]=r,e[r]=!0),0==c[o]&&(a[s++]=o,c[o]=l));ue.Oh(t.t,new ce.cg(a,s,u,f))}},ce.Ce=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y;for(t.O=Ke(re.DN,ft,5,t.N.d,16,1),n=0;n<t.N.d;n++)if(7==ce.Ij(t.N,n)){if(4==ce.Am(t.N,n)){t.O[n]=!0;continue}if(3==ce.Am(t.N,n)){if(1==ce.rj(t.N,n)){t.O[n]=!0;continue}if(ce.sn(t.N,n))continue;if(0!=(32&t.M)){t.O[n]=!0;continue}if(3!=ce.sm(t.N,n))continue;if((y=ce.um(t.N,n))>7)continue;for(G=ce.Ym(t.N),b=0;b<G.i.a.length&&(ue.Th(G.j,b).length!=y||!ce.Vp(G,b,n));)++b;for(u=-1,f=-1,c=0;c<3;c++)if(s=ce.Bm(t.N,n,c),!ce.Wp(G,b,s)){u=ce.zm(t.N,n,c),f=s;break}if((w=Ke(re.DN,ft,5,t.N.e,16,1))[f]=!0,g=Ke(re.hK,L,5,11,15,1),-1==(m=ce.Tm(t.N,g,u,n,10,w)))continue;for(o=1;!ce.Vp(G,b,g[o]);)++o;if(e=m-o,r=g[o],6==y&&2==e&&3==o&&ce.sm(t.N,g[1])>=3){for(h=!1,p=ue.Th(G.i,b),l=0;l<6;l++)if(n==p[l]){d=p[ce._p(G,b,r==p[ce._p(G,b,l+2)]?l-2:l+2)],ce.sm(t.N,d)>=3&&2==ce.Wm(t.N,g[1],d,2,null)&&(h=!0);break}if(h){t.O[n]=!0;continue}}if(a=!(i=1==ce.qm(t.N,r)||ce.ln(t.N,r)||ce.sn(t.N,r))&&7==ce.Ij(t.N,r)&&1!=ce.rj(t.N,r),1==e){!i&&!a&&y<=4&&o<=3&&(t.O[n]=!0);continue}switch(y){case 4:!i&&!a&&o<=4&&(t.O[n]=!0);break;case 5:a?o<=3&&(t.O[n]=!0):i||o<=4&&(t.O[n]=!0);break;case 6:2==e?i?o<=4&&(t.O[n]=!0):a||o<=3&&(t.O[n]=!0):3==e&&(i?o<=6&&(t.O[n]=!0):o<=4&&(t.O[n]=!0));break;case 7:3==e&&o<=3&&(t.O[n]=!0)}}}},ce.De=function(t,n){var e,o,r,i;for(r=!1,o=0;o<t.N.e;o++)ce.se(t,o,!1)&&(t.n[o]=t.H,n&&ce.Re(t,o),r=!0);for(i=!1,e=0;e<t.N.d;e++)ce.xe(t,e,!1)&&(t.eb[e]=t.H,n&&ce.Se(t,e),i=!0);return i&&(t.H=!t.H),r||i},ce.Ee=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v;for(G=Ke(re.DN,ft,5,t.N.d,16,1),b=Ke(re.DN,ft,5,t.N.e,16,1),n=0,j=!1,0!=(128&t.M)&&(t.U=Ke(re.hK,L,5,t.N.d,15,1),t.T=Ke(re.hK,L,5,t.N.e,15,1)),o=0;o<t.N.d;o++)t.S[o]&&(t.bb[o]||ce.xe(t,o,!1)&&(t.bb[o]=!0,G[o]=!0,++n));for(i=0;i<t.N.e;i++)t.R[i]&&(t.k[i]||ce.se(t,i,!1)&&(t.k[i]=!0,b[i]=!0,++n));if(1==n){for(e=0;e<t.N.d;e++)if(G[e]){t._[e]=0;break}for(r=0;r<t.N.e;r++)if(b[r]){t.j[r]=0;break}}else if(n>1)for(ce.Be(t),t.P=0,s=new ue.KW(t.t);s.a<s.c.a.length;){for(a=ue.JW(s),y=0,N=0,l=0,f=0,c=-1,u=-1,g=0;g<a.a.length;g++)G[a.a[g]]&&(++y,1!=t._[a.a[g]]&&2!=t._[a.a[g]]||(++N,j=!0,c<t.c[a.a[g]]&&(c=t.c[a.a[g]],l=a.a[g])));for(m=0;m<a.b.length;m++)b[a.b[m]]&&(++y,h=(H=t.c[ce.Nj(t.N,0,a.b[m])])>(v=t.c[ce.Nj(t.N,1,a.b[m])])?(H<<16)+v:(v<<16)+H,1!=t.j[a.b[m]]&&2!=t.j[a.b[m]]||(++N,j=!0,u<h&&(u=h,f=a.b[m])));if(0!=y)if(1==y){for(d=0;d<a.a.length;d++)G[a.a[d]]&&(t._[a.a[d]]=0);for(w=0;w<a.b.length;w++)b[a.b[w]]&&(t.j[a.b[w]]=0)}else if(1==N){for(d=0;d<a.a.length;d++)G[a.a[d]]&&(t._[a.a[d]]=3);for(w=0;w<a.b.length;w++)b[a.b[w]]&&(t.j[a.b[w]]=3)}else{if(0!=(128&t.M)){for(++t.P,d=0;d<a.a.length;d++)G[a.a[d]]&&(t.U[a.a[d]]=t.P);for(w=0;w<a.b.length;w++)b[a.b[w]]&&(t.T[a.b[w]]=t.P)}if(p=!1,-1!=c?2==t._[l]&&(p=!0):2==t.j[f]&&(p=!0),p){for(d=0;d<a.a.length;d++)if(G[a.a[d]])switch(t._[a.a[d]]){case 1:t._[a.a[d]]=2;break;case 2:t._[a.a[d]]=1}for(w=0;w<a.b.length;w++)if(b[a.b[w]])switch(t.j[a.b[w]]){case 1:t.j[a.b[w]]=2;break;case 2:t.j[a.b[w]]=1}}}}return j},ce.Fe=function(t,n){var e,o,r,i,a,s,u,f,l,c,h;for(i=Pe(re.hK,[Pt,L],[6,5],15,[2,32],2),a=0;a<2;a++){for(e=Ke(re.hK,Pt,6,32,0,2),h=0,r=0;r<32;r++)if(null!=n[a][r]){for(l=n[a][r].length,e[r]=Ke(re.hK,L,5,l,15,1),s=0;s<l;s++)e[r][s]=t.c[n[a][r][s]];le.V$(e[r]).sort(le.V$(Ie(ue.pX.prototype.Ub,ue.pX,[]))),++h}for(c=h;c>0;c--){for(f=0,u=null,o=0;o<32;o++)if(null!=e[o])if(null==u||u.length<e[o].length)u=e[o],f=o;else if(u.length==e[o].length)for(s=u.length-1;s>=0;s--)if(u[s]<e[o][s]){u=e[o],f=o;break}i[a][f]=c,e[f]=null}}return i},ce.Ge=function(n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y;if(h=!1,n.N.I)for(l=0;l<n.N.e;l++)if(0!=ce.Xj(n.N,l)){h=!0;break}for(n.K=2,o=0;o<n.N.d;o++)n.K=t.Math.max(n.K,ce.Am(n.N,o)+ce.Pm(n.N,o));for(f=t.Math.max(2,h?(78+37*n.K)/63|0:(78+21*n.K)/63|0),n.c=Ke(re.hK,L,5,n.N.o,15,1),n.b=Ke(re.rK,Kt,74,n.N.d,0,1),r=0;r<n.N.d;r++)n.b[r]=new ce.ag(f);for(u=!1,i=0;i<n.N.d;i++)ce._f(n.b[i],i),0!=(1&ce.Dj(n.N,i))||null!=ce.yj(n.N,i)?ce.Yf(n.b[i],8,6):ce.Yf(n.b[i],8,ao(ce.Ij(n.N,i))),ce.Yf(n.b[i],8,ao(ce.Bj(n.N,i))),ce.Yf(n.b[i],2,ao(ce.qm(n.N,i))),ce.Yf(n.b[i],4,ao(ce.Am(n.N,i)+ce.Pm(n.N,i))),0!=(1&ce.Dj(n.N,i))?ce.Yf(n.b[i],4,8):ce.Yf(n.b[i],4,ao(8+ce.rj(n.N,i))),ce.Yf(n.b[i],5,ao(t.Math.min(31,ce.um(n.N,i)))),ce.Yf(n.b[i],4,ao(ce.ve(n,i)+1)),ce.Yf(n.b[i],2,ao(ce.Ej(n.N,i)>>4)),n.N.I&&(ce.Yf(n.b[i],30,ao(ce.Dj(n.N,i))),null!=ce.yj(n.N,i)&&(u=!0));if(n.Q=ce.Je(n),n.Q<n.N.d){for(e=0;e<n.N.d;e++){for(ce._f(n.b[e],e),ce.Yf(n.b[e],16,ao(n.c[e])),w=Ke(re.hK,L,5,ce.Am(n.N,e),15,1),m=0;m<ce.Am(n.N,e);m++)w[m]=n.c[ce.zm(n.N,e,m)]<<5,w[m]|=t.Math.min(31,ce.ym(n.N,ce.Bm(n.N,e,m)));for(le.V$(w).sort(le.V$(Ie(ue.pX.prototype.Ub,ue.pX,[]))),d=n.K;d>w.length;d--)ce.Yf(n.b[e],21,0);for(g=w.length-1;g>=0;g--)ce.Yf(n.b[e],21,re.SN(w[g]))}n.Q=ce.Je(n)}if(u&&n.Q<n.N.d){for(e=0;e<n.N.d;e++){for(ce._f(n.b[e],e),ce.Yf(n.b[e],16,ao(n.c[e])),b=null==(s=ce.yj(n.N,e))?0:t.Math.min(12,s.length),m=12;m>b;m--)ce.Yf(n.b[e],8,0);for(g=b-1;g>=0;g--)ce.Yf(n.b[e],8,re.SN(s[g]))}n.Q=ce.Je(n)}if(h&&n.Q<n.N.d){for(e=0;e<n.N.d;e++){for(ce._f(n.b[e],e),ce.Yf(n.b[e],16,ao(n.c[e])),c=Ke(re.iK,Vt,5,ce.Am(n.N,e)+ce.Pm(n.N,e),14,1),p=0,m=0;m<ce.nm(n.N,e);m++)(m<ce.Am(n.N,e)||m>=ce.mm(n.N,e))&&(c[p]=ao(n.c[ce.zm(n.N,e,m)]),c[p]=mo(c[p],21),c[p]=go(c[p],ao(ce.Xj(n.N,ce.Bm(n.N,e,m)))),++p);for(le.V$(c).sort(le.V$(Ie(ue.mX.prototype.Vb,ue.mX,[]))),d=n.K;d>c.length;d--)ce.Yf(n.b[e],37,0);for(g=c.length-1;g>=0;g--)ce.Yf(n.b[e],37,c[g])}n.Q=ce.Je(n)}if(0!=(8&n.M)&&n.Q<n.N.d){for(G=new ce.Hr,a=0;a<n.N.d;a++)null!=ce.tj(n.N,a)&&ce.Fr(G,ce.tj(n.N,a));for(e=0;e<n.N.d;e++)y=null==ce.tj(n.N,e)?0:1+ce.Gr(G,ce.tj(n.N,e)),ce._f(n.b[e],e),ce.Yf(n.b[e],16,ao(n.c[e])),ce.Yf(n.b[e],16,re.SN(y));n.Q=ce.Je(n)}if(0!=(16&n.M)&&n.Q<n.N.d){for(e=0;e<n.N.d;e++)ce._f(n.b[e],e),ce.Yf(n.b[e],16,ao(n.c[e])),ce.Yf(n.b[e],1,ao(ce.Bk(n.N,e)?1:0));n.Q=ce.Je(n)}0!=(512&n.M)&&n.N.I&&ce.le(n)},ce.He=function(t){var n,e,o,r,i,a,s,u,f,l;for(i=0,e=0;e<t.N.d;e++)0!=t.Z[e]&&(2!=t.Z[e]||0==(256&t.M))&&++i;if(0!=i){for(l=Ke(re.hK,L,5,i,15,1),i=0,o=0;o<t.N.d;o++)0==t.Z[o]||2==t.Z[o]&&0!=(256&t.M)||(l[i]=t.Z[o]<<29|t.Y[o]<<24|t.c[o]<<12|o,++i);for(le.V$(l).sort(le.V$(Ie(ue.pX.prototype.Ub,ue.pX,[]))),a=0,f=0,s=l[0]&Et;;)if(++f==l.length||s!=(l[f]&Et)){for(r=Ke(re.hK,L,5,f-a,15,1),u=a;u<f;u++)n=4095&l[u],r[u-a]=n,t.cb[n]=!0;if(ue.Oh(t.db,r),f==l.length)break;s=l[f]&Et,a=f}}},ce.Ie=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w;for(s=!1,u=0;u<t.db.a.length;u++){for(a=ue.Th(t.db,u),n=!0,w=-1,f=!1,c=0;c<a.length;c++){if(e=a[c],0==t._[e]){n=!1;break}if(3!=t._[e]){for(l=!0,h=0;h<a.length;h++)if(h!=c&&t.c[e]==t.c[a[h]]){l=!1;break}l&&w<t.c[e]&&(w=t.c[e],f=1==t._[e])}}if(n&&-1!=w){for(r=0,i=(o=a).length;r<i;++r)e=o[r],(1==t._[e]||2==t._[e])&&(t.ab[e]=f),t.cb[e]=!1;ue._h(t.db,a),s=!0,--u}}return s},ce.Je=function(t){var n,e;n=ce.Ae(t);do{e=n,ce.we(t),n=ce.Ae(t)}while(e!=n);return n},ce.Ke=function(t){var n,e,o,r,i,a;if(t.S=Ke(re.DN,ft,5,t.N.d,16,1),t.R=Ke(re.DN,ft,5,t.N.e,16,1),0!=(6&t.M))for(n=0;n<t.N.d;n++)ce._f(t.b[n],n),ce.Yf(t.b[n],28,ao(t.c[n]<<12));if(t.Q<t.N.d){for(0,n=0;n<t.N.d;n++)ce.xe(t,n,!0)&&0;for(r=0;r<t.N.e;r++)ce.se(t,r,!0)&&0}for(0!=(6&t.M)&&(t.Q=ce.Je(t)),0!=(1&t.M)&&(t.d=ue.PW(t.c,t.N.d));t.Q<t.N.d;){for(e=0;e<t.N.d;e++)ce._f(t.b[e],e),ce.Yf(t.b[e],17,ao(2*t.c[e]));for(a=Ke(re.hK,L,5,t.Q+1,15,1),o=0;o<t.N.d;o++)++a[t.c[o]];for(i=1;1==a[i];)++i;for(n=0;n<t.N.d;n++)if(t.c[n]==i){ce.Zf(t.b[n],1);break}t.Q=ce.Je(t),ce.Ie(t),t.L&&ce.ng(t.L,t.c)}ce.Ie(t),ce.Ee(t),ce.gf(t)},ce.Le=function(t){var n,e,o,r,i;for(i=t.Q,r=ue.PW(t.c,t.N.d),t.N.I||(ce.Ne(t),ce.Af(t,i,r)),t.Z=Ke(re.dK,U,5,t.N.d,15,1),t.Y=Ke(re.dK,U,5,t.N.d,15,1),e=0;e<t.N.d;e++)t.Z[e]=ce.wj(t.N,e)<<24>>24,t.Y[e]=ce.vj(t.N,e)<<24>>24;for(t.i=Ke(re.dK,U,5,t.N.e,15,1),t.g=Ke(re.dK,U,5,t.N.e,15,1),o=0;o<t.N.e;o++)t.i[o]=ce.Sj(t.N,o)<<24>>24,t.g[o]=ce.Rj(t.N,o)<<24>>24;for(ce.Me(t),t.V=!1,t.I=Ke(re.DN,ft,5,t.N.d,16,1),n=0;n<t.N.d;n++)0!=t._[n]&&(t.I[n]=!0,t.V=!0);ce.Pe(t),t.L=null,t.$=Ke(re.DN,ft,5,t.N.d,16,1),t.V&&(t.L=new ce.tg(t.N,r,t.I,t._,t.j,t.Z,t.Y,t.eb,t.n,t.$),ce.og(t.L)),t.ab=Ke(re.DN,ft,5,t.N.d,16,1),t.cb=Ke(re.DN,ft,5,t.N.d,16,1),t.db=new ue.gi,ce.He(t),ce.Af(t,i,r),ce.Oe(t),t.L&&(t.G=ce.kg(t.L)),ce.Ze(t)},ce.Me=function(t){var n,e,o,r,i,a;for(t.H=!0,i=ce.De(t,!1);t.Q<t.N.d&&i;){for(n=0;n<t.N.d;n++)ce._f(t.b[n],n),ce.Yf(t.b[n],16,ao(t.c[n])),a=t._[n]<<7,1!=t._[n]&&2!=t._[n]||0==t.Z[n]||(a|=t.Z[n]<<5,a|=t.Y[n]),ce.Yf(t.b[n],18,re.SN(a<<9));for(e=0;e<t.N.e;e++)o=t.j[e]<<7,1!=t.j[e]&&2!=t.j[e]||1!=ce.Yj(t.N,e)||0==t.i[e]||(o|=t.i[e]<<5,o|=t.g[e]),ce.Zf(t.b[ce.Nj(t.N,0,e)],re.SN(o)),ce.Zf(t.b[ce.Nj(t.N,1,e)],re.SN(o));if(r=ce.Je(t),t.Q==r)break;t.Q=r,i=ce.De(t,!1)}},ce.Ne=function(t){var n,e,o,r;for(t.H=!0,t.W=Ke(re.dK,U,5,t.N.d,15,1),t.e=Ke(re.dK,U,5,t.N.e,15,1),r=ce.De(t,!0);t.Q<t.N.d&&r;){for(n=0;n<t.N.d;n++)ce._f(t.b[n],n),ce.Yf(t.b[n],20,ao(t.c[n]<<4|t._[n]<<2));for(e=0;e<t.N.e;e++)ce.Zf(t.b[ce.Nj(t.N,0,e)],ao(t.j[e])),ce.Zf(t.b[ce.Nj(t.N,1,e)],ao(t.j[e]));if(o=ce.Je(t),t.Q==o)break;t.Q=o,r=ce.De(t,!0)}},ce.Oe=function(t){var n,e,o,r,i,a,s;for(t.H=!0,o=ce.Ye(t),t.L&&ce.ng(t.L,t.c)&&(o=ce.Ye(t)),ce.De(t,!1)&&ce.Ie(t),a=!0;t.Q<t.N.d&&a;){for(r=ce.Fe(t,o),n=0;n<t.N.d;n++)ce._f(t.b[n],n),ce.Yf(t.b[n],16,ao(t.c[n])),ce.Yf(t.b[n],20,0),!t.$[n]&&0!=t.Z[n]&&ce.Zf(t.b[n],ao((t.Z[n]<<18)+(r[1==t.Z[n]?0:1][t.Y[n]]<<8))),s=t._[n],t.ab[n]&&(1==s?s=2:2==s&&(s=1)),ce.Zf(t.b[n],re.SN(s<<4));for(e=0;e<t.N.e;e++)ce.Zf(t.b[ce.Nj(t.N,0,e)],ao(t.j[e])),ce.Zf(t.b[ce.Nj(t.N,1,e)],ao(t.j[e]));if(i=ce.Je(t),t.Q==i)break;t.Q=i,a=!1,t.L&&ce.ng(t.L,t.c)&&(a=!0,o=ce.Ye(t)),ce.De(t,!1)&&(a=!0,ce.Ie(t))}},ce.Pe=function(t){var n,e;for(n=0;n<t.N.d;n++)(!t.I[n]||3==t._[n])&&(t.Z[n]=0);for(e=0;e<t.N.e;e++)(1!=ce.Yj(t.N,e)||0==t.j[e]||3==t.j[e])&&(t.i[e]=0)},ce.Qe=function(t,n,e){null==t.a&&(t.a=Ke(re.dK,U,5,t.N.d,15,1),ue.RW(t.a)),t.a[n]=e<<24>>24},ce.Re=function(t,n){var e,o,r,i,a,s;if((1==t.j[n]||2==t.j[n])&&!ce.An(t.N,n)){a=!1;try{for(i=0;i<2;i++)if(e=ce.Nj(t.N,i,n),3==ce.Am(t.N,e)){for(o=Ke(re.hK,L,5,2,15,1),r=0,s=0;s<ce.Am(t.N,e);s++)ce.Bm(t.N,e,s)!=n&&(o[r++]=ce.zm(t.N,e,s));t.c[o[0]]>t.c[o[1]]^ce.Te(t,e,o[0],o[1])&&(a=!a)}}catch(e){if(Ue(e=Ze(e),13))return void(t.e[n]=3);throw We(e)}1==t.j[n]^a?t.e[n]=1:t.e[n]=2}},ce.Se=function(t,n){var e,o,r,i,a,s,u;if(1==t._[n]||2==t._[n]){if(s=!1,2==ce.qm(t.N,n))try{for(a=0;a<2;a++)if(e=ce.zm(t.N,n,a),3==ce.Am(t.N,e)){for(r=Ke(re.hK,L,5,2,15,1),i=0,u=0;u<ce.Am(t.N,e);u++)1==ce.Cm(t.N,e,u)&&(r[i++]=ce.zm(t.N,e,u));t.c[r[0]]>t.c[r[1]]^ce.Te(t,e,r[0],r[1])&&(s=!s)}}catch(e){if(Ue(e=Ze(e),13))return void(t.W[n]=3);throw We(e)}else{try{o=ce.Ve(t,n)}catch(e){if(Ue(e=Ze(e),13))return void(t.W[n]=3);throw We(e)}for(a=1;a<o.length;a++)for(u=0;u<a;u++)t.c[o[a]]<t.c[o[u]]&&(s=!s)}1==t._[n]^s?t.W[n]=1:t.W[n]=2}},ce.Te=function(t,n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,x,k,R;if(ce.Ij(t.N,e)!=ce.Ij(t.N,o))return ce.Ij(t.N,e)>ce.Ij(t.N,o);if(ce.Bj(t.N,e)!=ce.Bj(t.N,o))return(ce.yk(t.N,e)?(ce.Li(),ce.Ji)[ce.Ij(t.N,e)]:ce.Bj(t.N,e))>(ce.yk(t.N,o)?(ce.Li(),ce.Ji)[ce.Ij(t.N,o)]:ce.Bj(t.N,o));for(N=t.N.d,G=Ke(re.hK,L,5,N,15,1),y=Ke(re.hK,L,5,N,15,1),j=Ke(re.hK,L,5,N,15,1),b=Ke(re.DN,ft,5,N,16,1),u=Ke(re.DN,ft,5,t.N.o,16,1),G[0]=n,G[1]=e,G[2]=o,y[0]=-1,y[1]=0,y[2]=0,u[n]=!0,u[e]=!0,u[o]=!0,h=1,H=2,(C=Ke(re.hK,L,5,64,15,1))[1]=1,C[2]=3,g=2;h<=H;){for(;h<C[g];){if(w=G[h],!b[h]){for(m=0,d=0,M=0;M<ce.Am(t.N,w);M++){if(l=ce.zm(t.N,w,M),H+ce.Cm(t.N,w,M)+1>=N&&(N+=t.N.d,G=ce.Df(G,N),y=ce.Df(y,N),j=ce.Df(j,N),b=ce.Ef(b,N)),ce.qn(t.N,ce.Bm(t.N,w,M)))++m,d+=ce.Ij(t.N,l);else for(S=1;S<ce.Cm(t.N,w,M);S++)G[++H]=l,y[H]=h,b[H]=!0;if(l!=G[k=y[h]]){if(s=!1,u[l])for(x=y[k];-1!=x;){if(l==G[x]){s=!0;break}x=y[x]}s?(G[++H]=l,y[H]=h,b[H]=!0):(G[++H]=l,y[H]=h,u[l]=!0)}}0!=m&&(j[++H]=(d<<2)/m|0,y[H]=h,b[H]=!0)}if(++h==E)throw We(new ie.EG("Emergency break in while loop."))}for(C.length==g+1&&(C=ce.Df(C,C.length+64)),C[g+1]=H+1,v=C[g];v<C[g+1];v++)0==j[v]&&(j[v]=(151==ce.Ij(t.N,G[v])||152==ce.Ij(t.N,G[v])?1:ce.Ij(t.N,G[v]))<<2),j[v]+=j[y[v]]<<16;if(ce.Xe(t,b,j,y,G,C,g),j[1]!=j[2])return j[1]>j[2];g>1&&ce.Ue(j,y,C,g),++g}for(c=Ke(re.hK,L,5,t.N.d,15,1),A=!1,i=0;i<t.N.d;i++)if(u[i]&&!ce.yk(t.N,i)){A=!0;break}if(A){for(a=0;a<t.N.d;a++)c[a]=ce.yk(t.N,a)?(ce.Li(),ce.Ji)[ce.Ij(t.N,a)]:ce.Bj(t.N,a);if(ce.We(t,b,j,y,G,c,C,g))return j[1]>j[2]}for(ue.VW(c,c.length,0),p=!1,f=0;f<t.N.e;f++)(u[ce.Nj(t.N,0,f)]||u[ce.Nj(t.N,1,f)])&&(1==t.e[f]?(c[ce.Nj(t.N,0,f)]=1,c[ce.Nj(t.N,1,f)]=1,p=!0):2==t.e[f]&&(c[ce.Nj(t.N,0,f)]=2,c[ce.Nj(t.N,1,f)]=2,p=!0));if(p&&ce.We(t,b,j,y,G,c,C,g))return j[1]>j[2];for(ue.VW(c,c.length,0),R=!1,r=0;r<t.N.d;r++)u[r]&&(2==t.W[r]?(c[r]=1,R=!0):1==t.W[r]&&(c[r]=2,R=!0));if(R&&ce.We(t,b,j,y,G,c,C,g))return j[1]>j[2];throw We(new ie.EG("no distinction applying CIP rules"))},ce.Ue=function(t,n,e,o){var r,i,a,s,u,f,l,c,h;for(c=e[o],a=e[o+1]-c,h=Ke(re.pK,x,97,a,0,1),u=0;u<a;u++)h[u]=new ce.Xf,h[u].c=t[u+c],h[u].b=n[u+c],h[u].a=u+c;for(r=new ce.Uf,l=o;l>1;l--){for(f=0;f<a;f++)h[f].c+=t[h[f].b]<<16,h[f].b=n[h[f].b];for(ue._W(h,0,h.length,r),i=1,s=0;s<a;s++)t[h[s].a]=i,s!=a-1&&0!=ce.Tf(h[s],h[s+1])&&++i}},ce.Ve=function(t,n){var e,o,r,i,a,s,u;for(a=ce.mm(t.N,n),s=Ke(re.hK,L,5,a,15,1),r=0;r<a;r++)s[r]=ce.zm(t.N,n,r);for(o=a;o>1;o--){for(e=!1,i=1;i<o;i++)ce.Te(t,n,s[i-1],s[i])&&(e=!0,u=s[i-1],s[i-1]=s[i],s[i]=u);if(!e)break}return s},ce.We=function(t,n,e,o,r,i,a,s){var u,f;for(f=1;f<s;f++){for(u=a[f];u<a[f+1];u++)e[u]=i[r[u]]+(e[o[u]]<<8);if(ce.Xe(t,n,e,o,r,a,f),e[1]!=e[2])return!0;f>1&&ce.Ue(e,o,a,f)}return!1},ce.Xe=function(t,n,e,o,r,i,a){var s,u,f,l,c,h,w,g,m,d,p;for(c=a;c>1;c--){for(m=i[c]-i[c-1],p=Ke(re.nK,x,96,m,0,1),s=i[c],g=0;g<m;g++){for(d=i[c-1]+g,h=s;h<i[c+1]&&o[h]==d;)++h;for(p[g]=new ce.Rf,p[g].c=d,p[g].d=e[d],p[g].b=n[d]?0:ce.Xm(t.N,r[d]),p[g].a=Ke(re.hK,L,5,h-s,15,1),l=s;l<h;l++)p[g].a[l-s]=e[l];le.V$(p[g].a).sort(le.V$(Ie(ue.pX.prototype.Ub,ue.pX,[]))),s=h}for(u=new ce.Of,ue._W(p,0,p.length,u),f=1,w=0;w<m;w++)e[p[w].c]=f,w!=m-1&&0!=ce.Nf(p[w],p[w+1])&&++f}},ce.Ye=function(t){var n,e;for(e=Pe(re.hK,[p,Pt],[25,6],0,[2,32],2),n=0;n<t.N.d;n++)t.I[n]&&(1==t.Z[n]?e[0][t.Y[n]]=ce.ug(e[0][t.Y[n]],n):2==t.Z[n]&&(e[1][t.Y[n]]=ce.ug(e[0][t.Y[n]],n)));return e},ce.Ze=function(t){var n,e,o,r,i,a,s,u,f,l,c,h;for(i=0,l=0,a=0,s=0,u=0,f=0,c=0,h=!1,n=Ke(re.DN,ft,5,32,16,1),e=0;e<t.N.d;e++)0!=t._[e]&&(++i,3==t._[e]?++l:0==t.Z[e]?(++a,t.L&&ce.jg(t.L,e)&&++s):2==t.Z[e]?0==t.Y[e]&&++f:1==t.Z[e]&&(n[r=t.Y[e]]||(++c,n[r]=!0),0==t.Y[e]&&++u,t.L&&ce.jg(t.L,e)&&(h=!0)));for(o=0;o<t.N.e;o++)0!=t.j[o]&&1==ce.Yj(t.N,o)&&(++i,3==t.j[o]?++l:0==t.i[o]?(++a,t.L&&ce.jg(t.L,ce.Nj(t.N,0,o))&&ce.jg(t.L,ce.Nj(t.N,1,o))&&++s):2==t.i[o]?0==t.g[o]&&++f:1==t.i[o]&&(n[r=t.g[o]]||(++c,n[r]=!0),0==t.g[o]&&++u,t.L&&ce.jg(t.L,ce.Nj(t.N,0,o))&&ce.jg(t.L,ce.Nj(t.N,1,o))&&(h=!0)));0!=i?0==l?t.G?ce.xl(t.N,Ot+(1<<c)):u+s!=i||h?a==i?ce.xl(t.N,Bt):f==i?ce.xl(t.N,327680):a==i-1&&1==u?ce.xl(t.N,Mt):ce.xl(t.N,458752+(1<<c)):ce.xl(t.N,196608):ce.xl(t.N,0):ce.xl(t.N,K)},ce.$e=function(t,n,e){for(;0!=e;)0==t.q&&((!t.o||63!=t.s)&&(t.s+=64),ie.cS(t.r,t.s&V),t.q=6,t.s=0),t.s<<=1,t.s|=1&n,n>>=1,--e,--t.q},ce._e=function(t){return t.s<<=t.q,(!t.o||63!=t.s)&&(t.s+=64),ie.cS(t.r,t.s&V),t.r.a},ce.af=function(t,n){t.r=new ie.jS,t.q=6,t.s=0,t.o=n},ce.bf=function(n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m,d,p;if(0!=n.N.d){if(h=!1,n.fb&&n.N.o>n.N.d&&!n.N.I)for(h=!0,f=0;f<n.N.d;f++)if(0!=ce.Nm(n.N,f)){h=!1;break}for(p=n.fb?16:8,ce.af(n,!0),ie.cS(n.r,h?35:33),ce.$e(n,n.fb?1:0,1),ce.$e(n,e?1:0,1),ce.$e(n,p/2|0,4),m=0,l=1;l<n.N.d;l++)m=ce.pf(n,n.u[l],-1==n.A[l]?-1:n.u[n.A[l]],m,o);if(h)for(f=0;f<n.N.d;f++)for(r=n.u[f],g=ce.Am(n.N,r);g<ce.mm(n.N,r);g++)m=ce.pf(n,ce.zm(n.N,r,g),r,m,o);if(n.N.d>1&&0==m)n.p="";else{for(d=m+(w=m/((s=1<<p)/2-1))/2,c=1;c<n.N.d;c++)ce.cf(n,n.u[c],-1==n.A[c]?-1:n.u[n.A[c]],d,w,p,o);if(h)for(u=0;u<n.N.d;u++)for(r=n.u[u],g=ce.Am(n.N,r);g<ce.mm(n.N,r);g++)ce.cf(n,ce.zm(n.N,r,g),r,d,w,p,o);e&&(a=n.fb?1.5:(ce.Li(),ce.Li(),ce.Ki),i=ce.Lj(n.N,h?n.N.o:n.N.d,h?n.N.p:n.N.e,a,o),ce.$e(n,t.Math.min(s-1,t.Math.max(0,ze(.5+t.Math.log(i/.1)*t.Math.LOG10E/(t.Math.log(2e3)*t.Math.LOG10E)*(s-1)))),p),ce.$e(n,ce.ef(o[n.u[0]].a/i,s),p),ce.$e(n,ce.ef(o[n.u[0]].b/i,s),p),n.fb&&ce.$e(n,ce.ef(o[n.u[0]].c/i,s),p)),n.p=ce._e(n)}}else n.p=""},ce.cf=function(t,n,e,o,r,i,a){var s,u,f;s=-1==e?(a[n].a-a[t.u[0]].a)/8:a[n].a-a[e].a,u=-1==e?(a[n].b-a[t.u[0]].b)/8:a[n].b-a[e].b,ce.$e(t,ze((o+s)/r),i),ce.$e(t,ze((o+u)/r),i),t.fb&&(f=-1==e?(a[n].c-a[t.u[0]].c)/8:a[n].c-a[e].c,ce.$e(t,ze((o+f)/r),i))},ce.df=function(t){var n,e,o,r,i,a;if(0!=t.N.d){for(i=0,o=!1,r=!1,e=0;e<t.N.d;e++)i<ce.Aj(t.N,e)&&(i=ce.Aj(t.N,e)),ce.nk(t.N,e)?o=!0:r=!0;if(0!=i){for(a=ce.yf(i),ce.af(t,!0),ce.$e(t,a,4),ce.$e(t,o?1:0,1),ce.$e(t,r?1:0,1),n=0;n<t.N.d;n++)ce.$e(t,ce.Aj(t.N,t.u[n]),a),o&&r&&ce.$e(t,ce.nk(t.N,t.u[n])?1:0,1);t.J=ce._e(t)}else t.J=""}else t.J=""},ce.ef=function(n,e){var o,r,i,a;return o=e/2|0,i=n<0,n=t.Math.abs(n),a=e/32|0,r=t.Math.min(o-1,jo(io(t.Math.round(n*o/(n+a))))),i?o+r:r},ce.ff=function(t,n){return n||(ce.$e(t,1,1),ce.$e(t,15,4)),!0},ce.gf=function(t){var n,e,o;for(n=0;n<t.N.d;n++)3==t._[n]&&!ce.jk(t.N,n)&&ce.Fl(t.N,n),(1==ce.wj(t.N,n)||2==ce.wj(t.N,n))&&(!t.I[n]||3==t._[n])&&ce.Fl(t.N,n),ce.jk(t.N,n)&&3!=t._[n]&&!ce.Cf(t,n)&&ce.Fl(t.N,n);for(o=0;o<t.N.p;o++)ce.Dk(t.N,o)&&!ce.Bf(t,o)&&ce.Fl(t.N,ce.Nj(t.N,0,o));for(e=0;e<t.N.e;e++)2==ce.Vj(t.N,e)&&(!ce.tk(t.N,e)||1!=t.j[e]&&2!=t.j[e]||(t.j[e]=3,ce.wl(t.N,e,26)),3!=t.j[e]||t.k[e]||26!=ce.Yj(t.N,e)&&(ce.Fl(t.N,ce.Nj(t.N,0,e)),ce.Fl(t.N,ce.Nj(t.N,1,e)))),1!=ce.Yj(t.N,e)||3!=t.j[e]||ce.jk(t.N,ce.Nj(t.N,0,e))||ce.jk(t.N,ce.Nj(t.N,1,e))||(ce.Fl(t.N,ce.Nj(t.N,0,e)),ce.Fl(t.N,ce.Nj(t.N,1,e))),1!=ce.Sj(t.N,e)&&2!=ce.Sj(t.N,e)||1==ce.Yj(t.N,e)&&(1==t.j[e]||2==t.j[e])||(ce.Fl(t.N,ce.Nj(t.N,0,e)),ce.Fl(t.N,ce.Nj(t.N,1,e)))},ce.hf=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y;if(0!=t.N.d&&!t.B){for(t.D=0,y=0,e=1;e<t.N.d;e++)t.c[e]>t.c[y]&&(y=e);for(o=Ke(re.DN,ft,5,t.N.d,16,1),i=Ke(re.DN,ft,5,t.N.e,16,1),t.C=Ke(re.hK,L,5,t.N.d,15,1),t.u=Ke(re.hK,L,5,t.N.d,15,1),t.A=Ke(re.hK,L,5,t.N.d,15,1),t.v=Ke(re.hK,L,5,t.N.e,15,1),t.u[0]=y,t.C[y]=0,o[y]=!0,s=0,u=1,f=0;s<t.N.d;)if(s<u){for(;;){for(w=0,g=0,c=-1,n=t.u[s],m=0;m<ce.nm(t.N,n);m++)(m<ce.Am(t.N,n)||m>=ce.mm(t.N,n))&&!o[a=ce.zm(t.N,n,m)]&&t.c[a]>c&&(w=a,g=ce.Bm(t.N,n,m),c=t.c[a]);if(-1==c)break;t.C[w]=u,t.A[u]=s,t.u[u++]=w,t.v[f++]=g,o[w]=!0,i[g]=!0}++s}else{for(h=0,c=-1,n=0;n<t.N.d;n++)!o[n]&&t.c[n]>c&&(h=n,c=t.c[n]);t.C[h]=u,t.A[u]=-1,t.u[u++]=h,o[h]=!0}for(t.w=Ke(re.hK,L,5,2*(t.N.e-f),15,1);;){for(p=t.N.K,G=t.N.K,b=-1,r=0;r<t.N.e;r++)i[r]||(t.C[ce.Nj(t.N,0,r)]<t.C[ce.Nj(t.N,1,r)]?(d=t.C[ce.Nj(t.N,0,r)],l=t.C[ce.Nj(t.N,1,r)]):(d=t.C[ce.Nj(t.N,1,r)],l=t.C[ce.Nj(t.N,0,r)]),(d<p||d==p&&l<G)&&(p=d,G=l,b=r));if(-1==b)break;i[b]=!0,t.v[f++]=b,t.w[2*t.D]=p,t.w[2*t.D+1]=G,++t.D}t.B=!0}},ce.jf=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w,g;for(u=null,g=ce.Ym(t.N),c=0;c<g.i.a.length;c++)if(g.e[c]){for(i=0,o=0,r=(e=h=ue.Th(g.i,c)).length;o<r;++o)n=e[o],ce.vf(t,n)&&++i;if(0!=i)if(w=ue.Th(g.j,c),null==u&&(u=Ke(re.DN,ft,5,t.N.e,16,1)),i==h.length){for(f=-1,l=N,a=0;a<h.length;a++)l>t.u[w[a]]&&(l=t.u[w[a]],f=a);for(;i>0;)u[w[f]]=!0,f=ce.Jf(f+2,h.length),i-=2}else{for(s=0;ce.vf(t,h[s]);)++s;for(;!ce.vf(t,h[s]);)s=ce.Jf(s+1,h.length);for(;i>0;)for(u[w[s]]=!0,s=ce.Jf(s+2,h.length),i-=2;!ce.vf(t,h[s]);)s=ce.Jf(s+1,h.length)}}return u},ce.kf=function(t,n){return t.j[n]},ce.lf=function(t){return ce.mf(t,t.fb)},ce.mf=function(t,n){return null==t.p&&(ce.hf(t),ce.bf(t,n,t.N.H)),t.p},ce.nf=function(t){return null==t.J&&(ce.hf(t),ce.df(t)),t.J},ce.of=function(t){return null==t.F&&(ce.hf(t),ce.xf(t),ce.zf(t,1),ce.zf(t,2),ce.wf(t)),t.F},ce.pf=function(n,e,o,r,i){var a,s,u;return r<(a=-1==o?t.Math.abs(i[e].a-i[n.u[0]].a)/8:t.Math.abs(i[e].a-i[o].a))&&(r=a),r<(s=-1==o?t.Math.abs(i[e].b-i[n.u[0]].b)/8:t.Math.abs(i[e].b-i[o].b))&&(r=s),n.fb&&r<(u=-1==o?t.Math.abs(i[e].c-i[n.u[0]].c)/8:t.Math.abs(i[e].c-i[o].c))&&(r=u),r},ce.qf=function(t,n){return t.T[n]},ce.rf=function(t,n){return t.U[n]},ce.sf=function(t,n){return null==t.d?-1:t.d[n]},ce.tf=function(t,n){return t._[n]},ce.uf=function(t,n){var e,o,r,i,a,s,u;for(u=ce.Ym(t.N),e=0;e<u.i.a.length;e++)if(u.d[e]&&ce.Vp(u,e,n)){for(i=0,a=(r=ue.Th(u.i,e)).length;i<a;++i)if((o=r[i])!=n)for(s=0;s<ce.Am(t.N,o);s++)if(ce.nn(t.N,ce.Bm(t.N,o,s)))return!0;return!1}return!1},ce.vf=function(t,n){var e,o,r;if(ce.qm(t.N,n)<2)return!1;if(2==ce.Am(t.N,n))return!0;for(e=0,r=0;r<ce.Am(t.N,n);r++)o=ce.Bm(t.N,n,r),ce.mn(t.N,o)&&(e+=ce.Vj(t.N,o)-1);return e>1},ce.wf=function(n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,x,k,R,I,D,F,T,$,P,K,V,E,O,Y,U,L,q,J,Q,X,_,z;if(ce.af(n,!1),ce.$e(n,9,4),J=t.Math.max(ce.yf(n.N.d),ce.yf(n.N.e)),ce.$e(n,J,4),0==J)return ce.$e(n,n.N.I?1:0,1),ce.$e(n,0,1),void(n.F=ce._e(n));for(Q=_=X=D=0,f=0;f<n.N.d;f++)if(0==(1&ce.Dj(n.N,f))){switch(ce.Ij(n.N,f)){case 6:break;case 7:++Q;break;case 8:++_;break;default:++X}0!=ce.rj(n.N,f)&&++D}for(ce.$e(n,n.N.d,J),ce.$e(n,n.N.e,J),ce.$e(n,Q,J),ce.$e(n,_,J),ce.$e(n,X,J),ce.$e(n,D,J),l=0;l<n.N.d;l++)7==ce.Ij(n.N,n.u[l])&&0==(1&ce.Dj(n.N,n.u[l]))&&ce.$e(n,l,J);for(m=0;m<n.N.d;m++)8==ce.Ij(n.N,n.u[m])&&0==(1&ce.Dj(n.N,n.u[m]))&&ce.$e(n,m,J);for(d=0;d<n.N.d;d++)6!=ce.Ij(n.N,n.u[d])&&7!=ce.Ij(n.N,n.u[d])&&8!=ce.Ij(n.N,n.u[d])&&0==(1&ce.Dj(n.N,n.u[d]))&&(ce.$e(n,d,J),ce.$e(n,ce.Ij(n.N,n.u[d]),8));for(p=0;p<n.N.d;p++)0!=ce.rj(n.N,n.u[p])&&0==(1&ce.Dj(n.N,n.u[p]))&&(ce.$e(n,p,J),ce.$e(n,8+ce.rj(n.N,n.u[p]),4));for(q=0,v=0,G=1;G<n.N.d;G++)-1==n.A[G]?P=0:(P=1+n.A[G]-v,v=n.A[G]),q<P&&(q=P);for($=ce.yf(q),ce.$e(n,$,4),v=0,b=1;b<n.N.d;b++)-1==n.A[b]?P=0:(P=1+n.A[b]-v,v=n.A[b]),ce.$e(n,P,$);for(V=0;V<2*n.D;V++)ce.$e(n,n.w[V],J);for(A=0;A<n.N.e;A++)I=0!=(ce.Xj(n.N,n.v[A])&kt)||32==ce.Yj(n.N,n.v[A])?1:ce.qn(n.N,n.v[A])?0:ce.Vj(n.N,n.v[A]),ce.$e(n,I,2);for(o=0,y=0;y<n.N.d;y++)0!=n.X[n.u[y]]&&3!=n.X[n.u[y]]&&++o;for(ce.$e(n,o,J),j=0;j<n.N.d;j++)0!=n.X[n.u[j]]&&3!=n.X[n.u[j]]&&(ce.$e(n,j,J),0==n.Z[n.u[j]]?ce.$e(n,n.X[n.u[j]],3):(z=1==n.X[n.u[j]]?1==n.Z[n.u[j]]?4:6:1==n.Z[n.u[j]]?5:7,ce.$e(n,z,3),ce.$e(n,n.Y[n.u[j]],3)));for(e=0,S=0;S<n.N.e;S++)0!=n.f[n.v[S]]&&3!=n.f[n.v[S]]&&(!ce.An(n.N,n.v[S])||1==ce.Yj(n.N,n.v[S]))&&++e;for(ce.$e(n,e,J),C=0;C<n.N.e;C++)0==n.f[n.v[C]]||3==n.f[n.v[C]]||ce.An(n.N,n.v[C])&&1!=ce.Yj(n.N,n.v[C])||(ce.$e(n,C,J),1==ce.Yj(n.N,n.v[C])?0==n.i[n.v[C]]?ce.$e(n,n.f[n.v[C]],3):(z=1==n.f[n.v[C]]?1==n.i[n.v[C]]?4:6:1==n.i[n.v[C]]?5:7,ce.$e(n,z,3),ce.$e(n,n.g[n.v[C]],3)):ce.$e(n,n.f[n.v[C]],2));for(ce.$e(n,n.N.I?1:0,1),F=0,N=0;N<n.N.d;N++)0!=ce.Bj(n.N,n.u[N])&&++F;if(0!=F)for(ce.$e(n,1,1),ce.$e(n,1,4),ce.$e(n,F,J),c=0;c<n.N.d;c++)0!=ce.Bj(n.N,n.u[c])&&(ce.$e(n,c,J),ce.$e(n,ce.Bj(n.N,n.u[c]),8));if(O=!1,n.N.I){for(ce.je(n,0,!1,J,Ct,1,-1),ce.je(n,3,!1,J,B,1,-1),ce.je(n,4,!1,J,120,4,3),ce.je(n,5,!1,J,6,2,1),ce.je(n,6,!1,J,1,1,-1),ce.je(n,7,!1,J,pt,4,7),F=0,c=0;c<n.N.d;c++)null!=ce.yj(n.N,n.u[c])&&++F;if(F>0)for(ce.$e(n,1,1),ce.$e(n,8,4),ce.$e(n,F,J),h=0;h<n.N.d;h++)if(null!=(H=ce.yj(n.N,n.u[h])))for(ce.$e(n,h,J),ce.$e(n,H.length,4),a=0,s=(i=H).length;a<s;++a)r=i[a],ce.$e(n,r,8);ce.ke(n,9,!1,J,96,2,5),ce.ke(n,10,!1,J,31,5,0),ce.je(n,11,!1,J,dt,1,-1),ce.ke(n,12,!1,J,kt,8,7),ce.je(n,13,!1,J,Nt,3,14),ce.je(n,14,!1,J,Ht,5,17),O|=ce.je(n,16,O,J,At,3,22)}for(F=0,w=0;w<n.N.d;w++)null!=n.a&&-1!=n.a[n.u[w]]&&++F;if(0!=F)for(O=ce.ff(n,O),ce.$e(n,1,1),ce.$e(n,1,4),ce.$e(n,F,J),c=0;c<n.N.d;c++)null!=n.a&&-1!=n.a[n.u[c]]&&(ce.$e(n,c,J),ce.$e(n,n.a[n.u[c]],4));if(0!=(8&n.M)){for(F=0,L=0,c=0;c<n.N.d;c++)null!=(Y=ce.tj(n.N,n.u[c]))&&(++F,L=t.Math.max(L,le.V$(Y).length));if(0!=F)for(O=ce.ff(n,O),U=ce.yf(L),ce.$e(n,1,1),ce.$e(n,2,4),ce.$e(n,F,J),ce.$e(n,U,4),h=0;h<n.N.d;h++)if(null!=(T=ce.tj(n.N,n.u[h])))for(ce.$e(n,h,J),ce.$e(n,le.V$(T).length,U),K=0;K<le.V$(T).length;K++)ce.$e(n,(le.S$(K,le.V$(T).length),le.V$(T).charCodeAt(K)),7)}for(n.N.I&&(O|=ce.je(n,19,O,J,bt,3,25),O|=ce.ke(n,20,O,J,Dt,3,15)),F=0,g=0;g<n.N.d;g++)0!=ce.Ej(n.N,n.u[g])&&++F;if(0!=F)for(O=ce.ff(n,O),ce.$e(n,1,1),ce.$e(n,5,4),ce.$e(n,F,J),u=0;u<n.N.d;u++)0!=ce.Ej(n.N,n.u[u])&&(ce.$e(n,u,J),ce.$e(n,ce.Ej(n.N,n.u[u])>>4,2));if(n.N.I&&(O|=ce.je(n,22,O,J,St,1,-1),O|=ce.ke(n,23,O,J,Bt,1,-1),O|=ce.ke(n,24,O,J,Rt,2,19)),0!=(16&n.M))for(u=0;u<n.N.d;u++)if(ce.Bk(n.N,n.u[u])){for(O=ce.ff(n,O),ce.$e(n,1,1),ce.$e(n,9,4),r=0;r<n.N.d;r++)ce.$e(n,ce.Bk(n.N,n.u[r])?1:0,1);break}if(null!=(E=ce.jf(n))){for(F=0,x=0;x<n.N.e;x++)E[n.v[x]]&&++F;for(O=ce.ff(n,O),ce.$e(n,1,1),ce.$e(n,10,4),ce.$e(n,F,J),k=0;k<n.N.e;k++)E[n.v[k]]&&ce.$e(n,k,J)}for(n.N.I&&(O|=ce.je(n,27,O,J,lt,1,-1)),F=0,R=0;R<n.N.e;R++)32==ce.Yj(n.N,n.v[R])&&++F;if(0!=F)for(O=ce.ff(n,O),ce.$e(n,1,1),ce.$e(n,12,4),ce.$e(n,F,J),M=0;M<n.N.e;M++)32==ce.Yj(n.N,n.v[M])&&ce.$e(n,M,J);n.N.I&&(O|=ce.je(n,29,O,J,Yt,2,30)),ce.$e(n,0,1),n.F=ce._e(n)},ce.xf=function(t){var n,e,o,r,i,a,s,u,f,l,c;for(t.X=Ke(re.dK,U,5,t.N.d,15,1),n=0;n<t.N.d;n++)if(1==t._[n]||2==t._[n]){if(u=t.ab[n],ce.on(t.N,n))for(s=0;s<ce.Am(t.N,n);s++){for(r=ce.zm(t.N,n,s),c=0,l=Ke(re.hK,L,5,3,15,1),f=0;f<ce.Am(t.N,r);f++)l[c]=ce.zm(t.N,r,f),l[c]!=n&&++c;2==c&&t.c[l[0]]>t.c[l[1]]^t.C[l[0]]<t.C[l[1]]&&(u=!u)}else for(s=1;s<ce.Am(t.N,n);s++)for(f=0;f<s;f++)i=ce.zm(t.N,n,s),a=ce.zm(t.N,n,f),t.c[i]>t.c[a]&&(u=!u),t.C[i]<t.C[a]&&(u=!u);t.X[n]=1==t._[n]^u?1:2}else t.X[n]=t._[n];for(t.f=Ke(re.dK,U,5,t.N.e,15,1),e=0;e<t.N.e;e++)if(1==t.j[e]||2==t.j[e]){for(u=!1,s=0;s<2;s++)if(o=ce.Nj(t.N,s,e),3==ce.Am(t.N,o)){for(l=Ke(re.hK,L,5,2,15,1),c=0,f=0;f<3;f++)ce.zm(t.N,o,f)!=ce.Nj(t.N,1-s,e)&&(l[c++]=ce.zm(t.N,o,f));t.c[l[0]]>t.c[l[1]]&&(u=!u),t.C[l[0]]<t.C[l[1]]&&(u=!u)}t.f[e]=1==t.j[e]^u?1:2}else t.f[e]=t.j[e]},ce.yf=function(t){var n;for(n=0;t>0;)t>>=1,++n;return n},ce.zf=function(n,e){var o,r,i,a,s,u,f,l,c,h,w,g,m;for(f=Ke(re.hK,L,5,32,15,1),l=0,r=0;r<n.N.d;r++)1!=n.X[r]&&2!=n.X[r]||n.Z[r]!=e||f[u=n.Y[r]]<n.c[r]&&(0==f[u]&&++l,f[u]=n.c[r]);for(a=0;a<n.N.e;a++)1!=n.f[a]&&2!=n.f[a]||n.i[a]!=e||1!=ce.Yj(n.N,a)||(u=n.g[a],m=t.Math.max(n.c[ce.Nj(n.N,0,a)],n.c[ce.Nj(n.N,1,a)]),f[u]<m&&(0==f[u]&&++l,f[u]=m));for(s=Ke(re.dK,U,5,32,15,1),c=0;c<l;c++){for(w=-1,g=0,h=0;h<32;h++)g<f[h]&&(g=f[h],w=h);f[w]=0,s[w]=c<<24>>24}for(o=0;o<n.N.d;o++)(1==n.X[o]||2==n.X[o])&&n.Z[o]==e&&(n.Y[o]=s[n.Y[o]]);for(i=0;i<n.N.e;i++)(1==n.f[i]||2==n.f[i])&&n.i[i]==e&&1==ce.Yj(n.N,i)&&(n.g[i]=s[n.g[i]])},ce.Af=function(t,n,e){var o,r;for(t.Q=n,o=0;o<t.N.d;o++)t.c[o]=e[o],t._[o]=0,t.eb[o]=!1;for(r=0;r<t.N.e;r++)t.j[r]=0,t.n[r]=!1},ce.Bf=function(t,n){var e,o,r;if((e=ce.Nj(t.N,0,n))>=t.N.d)return!1;if(1==t._[e]||2==t._[e])return!0;if(3==t._[e])return!1;if(-1!=(o=ce.im(t.N,e)))return 1==t.j[o]||2==t.j[o];for(r=0;r<ce.Am(t.N,e);r++)if(2==ce.Cm(t.N,e,r)&&(1==t._[ce.zm(t.N,e,r)]||2==t._[ce.zm(t.N,e,r)]))return!0;return!1},ce.Cf=function(t,n){var e;for(e=0;e<ce.Am(t.N,n);e++)if(3==t.j[ce.Bm(t.N,n,e)]&&1==ce.Cm(t.N,n,e))return!0;return!1},ce.Df=function(t,n){var e;return e=Ke(re.hK,L,5,n,15,1),ie.pS(t,0,e,0,t.length),e},ce.Ef=function(t,n){var e;return e=Ke(re.DN,ft,5,n,16,1),ie.pS(t,0,e,0,t.length),e},ce.Ff=function(t){var n,e;if(null!=t.W)for(n=0;n<t.N.d;n++)ce.Uk(t.N,n,t.W[n]);if(null!=t.e)for(e=0;e<t.N.e;e++)ce.pl(t.N,e,t.e[e])},ce.Gf=function(t){var n,e,o,r,i,a,s,u,f,l,c;for(n=0;n<t.N.d;n++)if(1==t._[n]||2==t._[n]){if(u=!1,ce.on(t.N,n))for(s=0;s<ce.Am(t.N,n);s++){for(r=ce.zm(t.N,n,s),c=0,l=Ke(re.hK,L,5,3,15,1),f=0;f<ce.Am(t.N,r);f++)l[c]=ce.zm(t.N,r,f),l[c]!=n&&++c;2==c&&t.c[l[0]]>t.c[l[1]]^l[0]<l[1]&&(u=!u)}else for(s=1;s<ce.Am(t.N,n);s++)for(f=0;f<s;f++)i=ce.zm(t.N,n,s),a=ce.zm(t.N,n,f),t.c[i]>t.c[a]&&(u=!u),i<a&&(u=!u);ce.el(t.N,n,1==t._[n]^u?1:2,t.bb[n])}else ce.el(t.N,n,t._[n],t.bb[n]);for(e=0;e<t.N.e;e++)if(1==t.j[e]||2==t.j[e]){for(u=!1,s=0;s<2;s++)if(o=ce.Nj(t.N,s,e),3==ce.Am(t.N,o)){for(l=Ke(re.hK,L,5,2,15,1),c=0,f=0;f<3;f++)ce.zm(t.N,o,f)!=ce.Nj(t.N,1-s,e)&&(l[c++]=ce.zm(t.N,o,f));t.c[l[0]]>t.c[l[1]]&&(u=!u),l[0]<l[1]&&(u=!u)}ce.tl(t.N,e,1==t.j[e]^u?1:2,t.k[e])}else ce.tl(t.N,e,t.j[e],t.k[e])},ce.Hf=function(t){var n;for(n=0;n<t.N.d;n++)ce.il(t.N,n,t.I[n])},ce.If=function(t){var n,e,o;for(n=0;n<t.N.d;n++)!ce.jk(t.N,n)&&3==t._[n]&&ce.Xk(t.N,n,!0);for(e=0;e<t.N.e;e++)3==t.j[e]&&(1==(o=ce.Vj(t.N,e))?ce.Xk(t.N,ce.Nj(t.N,0,e),!0):2==o&&ce.wl(t.N,e,26))},ce.Jf=function(t,n){return t<n?t:t-n},ce.Kf=function(t){ce.Lf.call(this,t,0)},ce.Lf=function(t,n){if(t.o>V)throw We(new ie._Q("Cannot canonize a molecule having more than 65535 atoms"));if(t.p>V)throw We(new ie._Q("Cannot canonize a molecule having more than 65535 bonds"));this.N=t,this.M=n,ce.Jr(this.N,7),ce.Ce(this),this.fb=0!=(64&n)||ce.ik(this.N),this._=Ke(re.dK,U,5,this.N.d,15,1),this.bb=Ke(re.DN,ft,5,this.N.d,16,1),this.eb=Ke(re.DN,ft,5,this.N.d,16,1),this.j=Ke(re.dK,U,5,this.N.e,15,1),this.n=Ke(re.DN,ft,5,this.N.e,16,1),this.k=Ke(re.DN,ft,5,this.N.e,16,1),ce.Ge(this),ce.Le(this),ce.Ke(this)},Te(46,1,{},ce.Kf,ce.Lf),a.o=!1,a.q=0,a.s=0,a.B=!1,a.D=0,a.G=!1,a.H=!1,a.K=0,a.M=0,a.P=0,a.Q=0,a.V=!1,a.fb=!1,re.xK=vo(46),ce.Mf=function(n,e){var o,r,i,a;if(n.d!=e.d)return n.d>e.d?1:-1;for(i=n.a.length,a=e.a.length,o=t.Math.min(i,a),r=0;r<o;r++)if(--i,--a,n.a[i]!=e.a[a])return n.a[i]>e.a[a]?1:-1;return i!=a?i>a?1:-1:n.b!=e.b?n.b>e.b?1:-1:0},ce.Nf=function(t,n){return ce.Mf(t,n)},ce.Of=function(){},Te(156,1,{},ce.Of),a.kb=function(t,n){return ce.Nf(t,n)},a.gb=function(t){return this===t},re.oK=vo(156),ce.Rf=function(){},Te(96,1,{96:1},ce.Rf),a.b=0,a.c=0,a.d=0,re.nK=vo(96),ce.Sf=function(t,n){return t.c!=n.c?t.c>n.c?1:-1:0},ce.Tf=function(t,n){return ce.Sf(t,n)},ce.Uf=function(){},Te(157,1,{},ce.Uf),a.kb=function(t,n){return ce.Tf(t,n)},a.gb=function(t){return this===t},re.qK=vo(157),ce.Xf=function(){},Te(97,1,{97:1},ce.Xf),a.a=0,a.b=0,a.c=0,re.pK=vo(97),ce.Yf=function(t,n,e){0==t.b&&(++t.c,t.b=63),63==t.b?(t.d[t.c]=go(t.d[t.c],e),t.b-=n):t.b>=n?(t.d[t.c]=mo(t.d[t.c],n),t.d[t.c]=go(t.d[t.c],e),t.b-=n):(t.d[t.c]=mo(t.d[t.c],t.b),t.d[t.c]=go(t.d[t.c],po(e,n-t.b)),n-=t.b,++t.c,t.b=63-n,t.d[t.c]=go(t.d[t.c],no(e,re.SN((1<<n)-1))))},ce.Zf=function(t,n){t.d[t.c]=to(t.d[t.c],n)},ce.$f=function(t,n){var e;for(e=0;e<t.c;e++)if(wo(t.d[e],n.d[e]))return uo(t.d[e],n.d[e])?-1:1;return ro(t.d[t.c],n.d[t.c])?0:uo(t.d[t.c],n.d[t.c])?-1:1},ce._f=function(t,n){t.a=n,t.c=0,t.b=63,ue.TW(t.d)},ce.ag=function(t){this.d=Ke(re.iK,Vt,5,t,14,1)},Te(74,1,{74:1,30:1},ce.ag),a.lb=function(t){return ce.$f(this,t)},a.a=0,a.b=0,a.c=0,re.rK=vo(74),ce.cg=function(t,n,e,o){this.a=(le.J$(n),ue.QW(t,Ke(re.hK,L,5,n,15,1),n)),this.b=(le.J$(o),ue.QW(e,Ke(re.hK,L,5,o,15,1),o))},Te(115,1,{115:1},ce.cg),re.sK=vo(115),ce.dg=function(t,n,e){var o,r,i,a,s,u,f,l,c;if(null!=n){for(s=0,r=0;r<t.i.d;r++)n[r]&&++s;for(c=Ke(re.hK,L,5,s,15,1),s=0,o=0;o<t.i.d;o++)n[o]&&(c[s++]=o);for(f=!1,a=new ue.KW(e);a.a<a.c.a.length;)if((i=ue.JW(a)).length==c.length){for(u=!1,l=0;l<i.length;l++)if(i[l]!=c[l]){u=!0;break}if(!u){f=!0;break}}f||(e.a[e.a.length]=c)}},ce.eg=function(t,n){var e,o;for(o=0;o<t.g[n].length;o++)if(e=t.g[n][o],t.f[e]&&(1==t.o[e]||2==t.o[e])&&0==t.k[e])return!0;return!1},ce.fg=function(t,n,e){var o,r,i,a,s;for(r=0,a=0,s=0;s<t.g[n].length;s++)o=t.g[n][s],t.k[o]==e&&0==(a&(i=1<<t.j[o]))&&(a|=i,++r);return r},ce.gg=function(t){var n,e,o,r,i,a,s,u,f,l,c,h;for(l=new ue.gi,c=0;c<t.i.d;c++)if(ce.qm(t.i,c)<2||ce.Am(t.i,c)>2)for(a=1;a<ce.Am(t.i,c);a++)for(n=ce.zm(t.i,c,a),f=0;f<a;f++)e=ce.zm(t.i,c,f),ce.lg(t,n,e)&&ce.dg(t,ce.sg(t,n,e),l);for(h=0;h<t.i.e;h++)(0==t.c[h]||2==ce.Vj(t.i,h)&&2==t.c[h])&&(n=ce.Nj(t.i,0,h),e=ce.Nj(t.i,1,h),ce.lg(t,n,e)&&ce.dg(t,ce.sg(t,n,e),l));for(s=l.a.length-1;s>=0;s--){for(le.L$(s,l.a.length),o=l.a[s],r=!1,f=0;f<o.length;f++)if(t.f[o[f]]){r=!0;break}r||ue._h(l,o)}for(t.g=ue.fi(l,Pe(re.hK,[Pt,L],[6,5],15,[0,0],2)),ue.fX(t.g,new ce.wg),t.e=Ke(re.DN,ft,5,t.i.d,16,1),i=0;i<t.g.length;i++)for(u=0;u<t.g[i].length;u++)t.e[t.g[i][u]]=!0},ce.hg=function(t,n,e,o){var r,i;for(i=0;i<ce.Am(t.i,e);i++)if(!o[r=ce.zm(t.i,e,i)]&&ce.lg(t,n,r))return r;return-1},ce.ig=function(t,n){return t.f[n]&&(1==t.o[n]||2==t.o[n])},ce.jg=function(t,n){return t.e[n]},ce.kg=function(t){var n,e;for(e=!0,n=0;n<t.i.d;n++)if(0!=t.o[n]&&!t.e[n]){e=!1;break}return e},ce.lg=function(t,n,e){var o,r,i,a,s;if(n==e)return!1;if(t.a[n]!=t.a[e])return!1;if(0!=t.o[n]){if(3==t.o[n]||3==t.o[e])return!1;if(t.p[n]^t.o[n]!==t.o[e])return!1;if(t.k[n]!==t.k[e]||t.j[n]!==t.j[e])return!1}if(-1!=(o=ce.xm(t.i,n,e))){if(1==ce.Vj(t.i,o)&&0!=t.c[o])return!1;if(2==ce.Vj(t.i,o)&&1==t.c[o])return!1}if(1==ce.qm(t.i,n)&&!ce.ln(t.i,n)){for(r=-1,s=0;s<ce.Am(t.i,n);s++)if(ce.zm(t.i,n,s)!=e&&2==ce.Cm(t.i,n,s)){r=ce.Bm(t.i,n,s);break}for(i=-1,a=0;a<ce.Am(t.i,e);a++)if(ce.zm(t.i,e,a)!=n&&2==ce.Cm(t.i,e,a)){i=ce.Bm(t.i,e,a);break}if(-1!=r&&0!=t.c[r]&&t.d[r]^t.c[r]===t.c[i])return!1}return!0},ce.mg=function(t,n,e,o,r){var i,a,s,u,f,l;for(u=null,i=null,l=0;l<t.g[n].length;l++)a=t.g[n][l],t.f[a]&&(1==t.o[a]||2==t.o[a])&&(0==t.k[a]?i=ce.ug(i,(r[a]<<16)+a):t.k[a]==o&&t.j[a]==e&&(u=ce.ug(u,(r[a]<<16)+a)));if(0==(s=ce.Mg(u,i)))return!1;if(s<0)for(f=0;f<t.g[n].length;f++)a=t.g[n][f],!t.f[a]||1!=t.o[a]&&2!=t.o[a]||(0==t.k[a]?(t.k[a]=o<<24>>24,t.j[a]=e<<24>>24):t.k[a]==o&&t.j[a]==e&&(t.k[a]=0,t.j[a]=-1));return!0},ce.ng=function(t,n){var e,o,r,i,a,s;if(!t.b)return!1;for(r=!1,i=t.b.a.length-1;i>=0;i--)if(o=!1,2==(a=ue.Th(t.b,i)).a?o=ce.mg(t,a.b,a.c,a.d,n):1==a.a&&(o=ce.rg(t,a.b,n)),o){for(ue._h(t.b,a),s=0;s<t.g[a.b].length;s++)e=t.g[a.b][s],t.n[e]=!1;r=!0}return r},ce.og=function(t){var n,e,o,r,i,a,s,u;if(null!=t.g)for(a=new ce.Lg(t),t.b=new ue.gi,r=0;r<t.g.length;r++)0==(o=ce.Dg(a,r))?(ce.zg(a,r),s=ce.fg(t,r,2),n=ce.fg(t,r,1),e=ce.eg(t,r),1!=s||1!=n||e||(ce.qg(t,r,a.a+a.f++),ue.Oh(t.b,new ce.Di(r,1,-1,-1))),s>0?(e&&(ce.pg(t,r,a.i+a.g++,2),++s),ue.Oh(t.b,new ce.Di(r,1,-1,-1))):n>0?(e&&ce.pg(t,r,a.a+a.f++,1),ue.Oh(t.b,new ce.Di(r,1,-1,-1))):e&&(ce.pg(t,r,a.a+a.f++,1),ue.Oh(t.b,new ce.Di(r,1,-1,-1)))):1==o&&(ce.eg(t,r)?(i=ce.Cg(a,r),u=ce.Eg(a,r),ue.Oh(t.b,new ce.Di(r,2,i,u))):(ce.zg(a,r),ue.Oh(t.b,new ce.Di(r,1,-1,-1))))},ce.pg=function(t,n,e,o){var r,i;for(i=0;i<t.g[n].length;i++)r=t.g[n][i],!t.f[r]||1!=t.o[r]&&2!=t.o[r]||0!=t.k[r]||(t.k[r]=o<<24>>24,t.j[r]=e<<24>>24)},ce.qg=function(t,n,e){var o,r;for(r=0;r<t.g[n].length;r++)o=t.g[n][r],2==t.k[o]&&(t.k[o]=1,t.j[o]=e<<24>>24)},ce.rg=function(t,n,e){var o,r,i,a,s,u,f,l;for(i=t.g[n],r=1,u=0;u<i.length;u++)if(o=i[u],t.f[o]&&2==t.k[o]){r=2;break}for(a=Ke(re.hK,Pt,6,32,0,2),f=0;f<i.length;f++)o=i[f],t.f[o]&&t.k[o]==r&&(a[t.j[o]]=ce.ug(a[t.j[o]],(e[o]<<16)+o));for(l=0;l<32;l++)null!=a[l]&&le.V$(a[l]).sort(le.V$(Ie(ue.pX.prototype.Ub,ue.pX,[])));if(ue.fX(a,new ce.Ng),0==ce.Mg(a[0],a[1]))return!1;for(s=0;s<a[0].length;s++)o=a[0][s]&V,t.k[o]=0,t.j[o]=-1;return!0},ce.sg=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j;for(u=Ke(re.hK,L,5,t.i.d,15,1),G=Ke(re.hK,L,5,t.i.d,15,1),g=Ke(re.DN,ft,5,t.i.d,16,1),m=Ke(re.DN,ft,5,t.i.d,16,1),f=Ke(re.DN,ft,5,t.i.d,16,1),u[0]=n,G[n]=e,G[e]=-2,g[n]=!0,g[e]=!0,i=0,l=0;i<=l;){if(G[a=u[i]]==a){for(c=0;c<ce.Am(t.i,a);c++)if(!g[o=ce.zm(t.i,a,c)])if(2==ce.Cm(t.i,a,c)&&ce.Ij(t.i,o)<10)u[++l]=o,G[o]=o,f[o]=f[a]||2==ce.qm(t.i,o),m[o]=f[a]&&!m[a],g[o]=!0;else if(f[a]&&m[a]){if(-1==(b=ce.hg(t,o,G[a],g)))return null;u[++l]=o,G[o]=b,G[b]=-2,f[o]=!1,g[o]=!0,g[b]=!0}else if(ce.xn(t.i,ce.Bm(t.i,a,c))&&(u[++l]=o,G[o]=o,f[o]=!1,g[o]=!0,(6==ce.Ij(t.i,o)&&0==ce.qm(t.i,o)||7==ce.Ij(t.i,o)&&1==ce.rj(t.i,o)||14==ce.Ij(t.i,o)||15==ce.Ij(t.i,o)&&ce.Am(t.i,o)>2||16==ce.Ij(t.i,o)&&ce.Am(t.i,o)>2)&&ce.Am(t.i,o)>2)){for(s=!1,d=1;d<ce.Am(t.i,o);d++)if(!g[y=ce.zm(t.i,o,d)])for(p=0;p<d;p++)g[j=ce.zm(t.i,o,p)]||ce.lg(t,y,j)&&(u[++l]=y,G[y]=j,G[j]=-2,f[y]=!1,g[y]=!0,g[j]=!0,s=!0);if(!s)return null}}else{for(r=Ke(re.DN,ft,5,ce.Am(t.i,a),16,1),h=0;h<ce.Am(t.i,a);h++)if(g[o=ce.zm(t.i,a,h)])r[h]=G[o]==o;else for(d=0;d<ce.Am(t.i,o);d++)if(ce.zm(t.i,o,d)==G[a]){r[h]=!0;break}for(w=0;w<ce.Am(t.i,a);w++)if(r[w])if(g[o=ce.zm(t.i,a,w)]){if(-1==ce.xm(t.i,o,G[a]))return null}else u[++l]=o,G[o]=o,m[o]=!1,f[o]=!0,g[o]=!0;for(c=0;c<ce.Am(t.i,a);c++)if(!r[c]&&!g[o=ce.zm(t.i,a,c)]){if(-1==(b=ce.hg(t,o,G[a],g)))return null;u[++l]=o,G[o]=b,G[b]=-2,f[o]=!1,g[o]=!0,g[b]=!0}}++i}return g},ce.tg=function(t,n,e,o,r,i,a,s,u,f){this.i=t,this.a=n,this.f=e,this.o=o,this.c=r,this.k=i,this.j=a,this.p=s,this.d=u,this.n=f,ce.gg(this)},ce.ug=function(t,n){var e,o;for(o=Ke(re.hK,L,5,null==t?1:t.length+1,15,1),e=0;e<o.length-1;e++)o[e]=t[e];return o[o.length-1]=n,o},Te(166,1,{},ce.tg),re.vK=vo(166),ce.vg=function(t,n){var e;if(t.length!=n.length)return t.length<n.length?-1:1;for(e=0;e<t.length;e++)if(t[e]!=n[e])return t[e]<n[e]?-1:1;return 0},ce.wg=function(){},Te(169,1,{},ce.wg),a.kb=function(t,n){return ce.vg(t,n)},a.gb=function(t){return this===t},re.tK=vo(169),ce.zg=function(t,n){var e,o,r,i,a,s;for(r=0;r<t.b;r++)if(t.e[r][n]&&-3!=t.c[r])for(o=0;o<=t.j.g.length;o++)if(o!=n&&t.e[r][o])for(t.e[r][n]=!1,s=r<t.a?r:r<t.b?r-t.a:-1,a=ce.Jg(t,r<t.a?1:r<t.b?2:0),i=0;i<t.j.g[n].length;i++)e=t.j.g[n][i],ce.ig(t.j,e)&&t.j.j[e]==s&&(t.j.j[e]=a<<24>>24)},ce.Ag=function(t,n,e){var o,r,i,a,s;for(s=!1,a=1,n[e]=a,o=!0;o;){for(o=!1,r=0;r<t.b;r++)if(n[r]==a)for(i=0;i<t.b;i++)0==n[i]&&ce.Ig(t,r,i)&&(-2==t.c[i]?(n[i]=a+1,o=!0):t.c[i]!=t.c[e]&&(n[i]=a+1,s=!0));++a}return s},ce.Bg=function(t,n,e,o){var r,i,a,s,u,f,l,c,h,w,g;for(u=o+1;u<t.j.g.length;u++)if(u!=o&&t.e[n][u]&&t.e[e][u])return(a=Ke(re.hK,L,5,2,15,1))[0]=e,a[1]=n,a;for(g=Ke(re.hK,L,5,t.b,15,1),l=Ke(re.hK,L,5,t.b,15,1),i=0,c=0,(f=Ke(re.hK,L,5,t.b,15,1))[0]=n,l[n]=1;i<=c;){for(h=0;h<t.d[f[i]].length;h++){if((r=t.d[f[i]][h])==e){if(0==i)continue;for(s=l[f[i]]+1,(a=Ke(re.hK,L,5,s,15,1))[0]=r,a[1]=f[i],w=2;w<s;w++)a[w]=g[a[w-1]];return a}0==l[r]&&-3!=t.c[r]&&(l[r]=l[f[i]]+1,f[++c]=r,g[r]=f[i])}++i}return null},ce.Cg=function(t,n){var e;for(e=0;e<t.b;e++)if(t.e[e][n]&&-3==t.c[e])return e<t.a?e:e<t.b?e-t.a:-1;return-1},ce.Dg=function(t,n){var e,o;for(e=0,o=0;o<t.b;o++)t.e[o][n]&&-3==t.c[o]&&++e;return e},ce.Eg=function(t,n){var e;for(e=0;e<t.b;e++)if(t.e[e][n]&&-3==t.c[e])return e<t.a?1:e<t.b?2:0;return-1},ce.Fg=function(t,n){return n<t.a?n:n<t.b?n-t.a:-1},ce.Gg=function(t,n){return n<t.a?1:n<t.b?2:0},ce.Hg=function(t,n){var e,o;return o=t.j.k[n],e=t.j.j[n],0==o?t.b:1==o?e:t.a+e},ce.Ig=function(t,n,e){var o;for(o=0;o<t.j.g.length;o++)if(t.e[n][o]&&t.e[e][o])return!0;return!1},ce.Jg=function(t,n){return 1==n?t.a+t.f++:t.i+t.g++},ce.Kg=function(t,n){var e,o,r,i,a,s,u,f,l,c;for(l=N,u=-1,c=-1,f=-1,o=0;o<t.j.i.d;o++)if(ce.ig(t.j,o)&&0!=t.j.k[o])for(s=0;s<n.length;s++)r=ce.Fg(t,n[s]),i=ce.Gg(t,n[s]),t.j.k[o]==i&&t.j.j[o]==r&&l>t.j.a[o]+(1==i?K:0)&&(l=t.j.a[o]+(1==i?K:0),u=r,c=i,f=n[s]);for(e=0;e<t.j.i.d;e++)ce.ig(t.j,e)&&t.j.k[e]==c&&t.j.j[e]==u&&(t.j.k[e]=0,t.j.j[e]=-1);for(a=0;a<t.j.g.length;a++)t.e[f][a]=!1},ce.Lg=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w,g,m,d;for(this.j=t,o=0;o<t.i.d;o++)t.f[o]&&(1==t.o[o]||2==t.o[o])&&(1==t.k[o]?this.a<=t.j[o]&&(this.a=1+t.j[o]):2==t.k[o]&&this.i<=t.j[o]&&(this.i=1+t.j[o]));for(this.b=this.a+this.i,this.e=Pe(re.DN,[p,ft],[11,5],16,[this.b+1,t.g.length+1],2),r=0;r<t.i.d;r++)t.f[r]&&(1==t.o[r]||2==t.o[r])&&!t.e[r]&&(this.e[ce.Hg(this,r)][t.g.length]=!0);for(u=0;u<t.g.length;u++)for(d=0;d<t.g[u].length;d++)e=t.g[u][d],t.f[e]&&(1==t.o[e]||2==t.o[e])&&(this.e[ce.Hg(this,e)][u]=!0);for(this.d=Ke(re.hK,Pt,6,this.b,0,2),f=0;f<t.g.length;f++)for(w=1;w<this.b;w++)if(this.e[w][f])for(g=0;g<w;g++)this.e[g][f]&&(this.d[w]=ce.ug(this.d[w],g),this.d[g]=ce.ug(this.d[g],w));for(this.c=Ke(re.hK,L,5,this.b+1,15,1),h=0;h<this.b;h++)this.e[h][t.g.length]?this.c[h]=-1:this.c[h]=-2;for(l=0;l<t.g.length;l++)if(this.e[this.b][l])for(c=0;c<this.b;c++)this.e[c][l]&&this.c[c]!=l&&(-2==this.c[c]?this.c[c]=l:this.c[c]=-3);for(n=0;n<this.b;n++)if(this.c[n]>=-1&&(i=Ke(re.hK,L,5,this.b,15,1),ce.Ag(this,i,n)))for(c=0;c<this.b;c++)0!=i[c]&&(this.c[c]=-3);for(s=0;s<t.g.length-1;s++)for(w=1;w<this.b;w++)if(this.e[w][s]&&-3!=this.c[w])for(g=0;g<w;g++)if(this.e[g][s]&&-3!=this.c[g]&&null!=(a=ce.Bg(this,w,g,s))){for(m=0;m<a.length;m++)this.c[a[m]]=-3;ce.Kg(this,a);break}},Te(167,1,{},ce.Lg),a.a=0,a.b=0,a.f=0,a.g=0,a.i=0,re.uK=vo(167),ce.Mg=function(n,e){var o,r;if(null==n)return null==e?0:1;if(null==e)return-1;for(o=t.Math.min(n.length,e.length),r=0;r<o;r++)if((n[r]&Ut)!=(e[r]&Ut))return(n[r]&Ut)<(e[r]&Ut)?-1:1;return n.length==e.length?0:n.length<e.length?-1:1},ce.Ng=function(){},Te(168,1,{},ce.Ng),a.kb=function(t,n){return ce.Mg(t,n)},a.gb=function(t){return this===t},re.wK=vo(168),ce.Qg=function(t,n){return t.a!=n.a?t.a<n.a?-1:1:t.b!=n.b?t.b<n.b?-1:1:t.c!=n.c?t.c<n.c?-1:1:0},ce.Rg=function(n,e){return t.Math.sqrt((e.a-n.a)*(e.a-n.a)+(e.b-n.b)*(e.b-n.b)+(e.c-n.c)*(e.c-n.c))},ce.Sg=function(t,n,e,o){t.a=n,t.b=e,t.c=o},ce.Tg=function(t,n){return ce.Sg(t,n.a,n.b,n.c),t},ce.Ug=function(){},ce.Vg=function(t,n,e){this.a=t,this.b=n,this.c=e},ce.Wg=function(t){ce.Vg.call(this,t.a,t.b,t.c)},Te(34,1,{34:1,4:1,30:1},ce.Ug,ce.Vg,ce.Wg),a.lb=function(t){return ce.Qg(this,t)},a.gb=function(n){var e;return!(null==n||!Ue(n,34))&&(e=n,t.Math.abs(e.a-this.a)+t.Math.abs(e.b-this.b)+t.Math.abs(e.c-this.c)<1e-6)},a.jb=function(){var t;return t=new Ce.LU("0.00"),"["+Ce.KU(t,this.a)+", "+Ce.KU(t,this.b)+", "+Ce.KU(t,this.c)+"]"},a.a=0,a.b=0,a.c=0,re.yK=vo(34),ce.$g=function(t,n){n.c*=t.c,n.a=n.a*t.c+t.a,n.b=n.b*t.c+t.b},ce._g=function(t,n){n.a=n.a*t.c+t.a,n.b=n.b*t.c+t.b},ce.ah=function(t,n){n.c=n.c*t.c+t.a,n.d=n.d*t.c+t.b,n.b*=t.c,n.a*=t.c},ce.bh=function(t){t.a=0,t.b=0,t.c=1},ce.dh=function(t,n){return n*t.c+t.a},ce.eh=function(t,n){return n*t.c+t.b},ce.fh=function(){ce.bh(this)},ce.gh=function(n,e,o){var r,i,a,s;ce.bh(this),i=e.b/n.b,s=e.a/n.a,0==(a=0)&&(a=24),r=a/o,this.c=t.Math.min(r,t.Math.min(i,s)),this.a=e.c+e.b/2-this.c*(n.c+n.b/2),this.b=e.d+e.a/2-this.c*(n.d+n.a/2)},Te(98,1,{},ce.fh,ce.gh),a.jb=function(){return"DepictorTransformation Offset: "+this.a+","+this.b+" Scaling: "+this.c},a.a=0,a.b=0,a.c=0,re.zK=vo(98),ce.zi=function(t){var n,e;for(e=new ie._R,n=0;n<t.a.length;n++)ie.$R(e,(le.L$(n,t.a.length),t.a[n]).ec()+d);return e.a},ce.Ai=function(t){var n;ue.gi.call(this);try{if(t)for(n=0;n<t.a.length;n++)ue.Oh(this,(le.L$(n,t.a.length),t.a[n]).ec())}catch(t){if(!Ue(t=Ze(t),13))throw We(t)}},ce.Bi=function(t){var n,e;if(ue.gi.call(this),null!=t&&0!=le.V$(t).length)for(n=0,e=ie.KR(t,Fo(10));-1!=e;)le.V$(t).substr(n,e-n),n=e+1,e=ie.LR(t,Fo(10),n)},Te(107,18,Y,ce.Ai,ce.Bi),a.jb=function(){return ce.zi(this)},re.AK=vo(107),ce.Di=function(t,n,e,o){this.b=t,this.a=n,this.c=e,this.d=o},Te(55,1,{55:1},ce.Di),a.a=0,a.b=0,a.c=0,a.d=0,re.BK=vo(55),ce.Ei=function(t){var n,e,o,r,i,a;if(0!=t.j)return t.j;if(t.i&&15!=ce.Ij(t.e,t.a)&&16!=ce.Ij(t.e,t.a))for(a=0;a<ce.mm(t.e,t.a);a++)if(i=ce.Bm(t.e,t.a,a),ce.Ek(t.e,i,t.a))return ce.zm(t.e,t.a,a)==t.b?t.j=17==ce.Yj(t.e,i)?3:1:t.j=17==ce.Yj(t.e,i)?1:3,t.j;return n=ce.Mj(t.e,t.a,t.g),(o=ce.Mj(t.e,t.a,t.b))<n&&(o+=wt),2==ce.mm(t.e,t.a)?(e=o-n)>3.0915926535897933&&e<3.191592653589793?(t.j=-1,t.j):(t.j=e<gt?4:2,t.j):((r=ce.Mj(t.e,t.a,t.d))<n&&(r+=wt),t.j=r<o?2:4,t.j)},ce.Fi=function(t,n,e,o){var r,i,a,s;for(this.e=t,this.g=e,this.a=o,a=-1,s=0;s<ce.mm(this.e,this.a);s++)r=ce.zm(this.e,this.a,s),i=ce.Bm(this.e,this.a,s),r!=this.g?(ce.Ek(this.e,i,this.a)&&(this.i&&(t.s[o]|=Ot),this.i=!0),a==n[r]?(this.d=r,this.f=!0,this.c=ce.xn(this.e,i)):a<n[r]?(a=n[r],this.d=this.b,this.b=r):this.d=r):26==ce.Yj(this.e,i)&&(this.j=-1)},Te(64,1,{},ce.Fi),a.a=0,a.b=0,a.c=!1,a.d=0,a.f=!1,a.g=0,a.i=!1,a.j=0,re.CK=vo(64),ce.Li=function(){ce.Li=De,ce.Gi=Oe($e(re.uM,1),P,2,6,["?","H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og",Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,"R4","R5","R6","R7","R8","R9","R10","R11","R12","R13","R14","R15","R16","R1","R2","R3","A","A1","A2","A3",Lt,Lt,"D","T","X","R","H2","H+","Nnn","HYD","Pol",Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,"Ala","Arg","Asn","Asp","Cys","Gln","Glu","Gly","His","Ile","Leu","Lys","Met","Phe","Pro","Ser","Thr","Trp","Tyr","Val"]),ce.Ji=Oe($e(re.CN,1),Vt,5,15,[0,1,4,7,9,11,12,14,16,19,20,23,24,27,28,31,32,35,40,39,40,45,48,51,52,55,56,59,58,63,64,69,74,75,80,79,84,85,88,89,90,93,98,0,102,103,106,107,114,115,120,121,130,127,132,133,138,139,140,141,142,0,152,153,158,159,164,165,166,169,174,175,180,181,184,187,192,193,195,197,202,205,208,209,209,210,222,223,226,227,232,231,238,237,244,243,247,247,251,252,257,258,259,262,267,268,271,270,277,276,281,281,283,285,289,289,293,294,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,156,114,115,103,128,129,57,137,113,113,128,131,147,97,87,101,186,163,99]),ce.Hi=Oe($e(re.dK,2),p,8,0,[null,Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[0]),Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[4]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[0]),Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[4]),Oe($e(re.dK,1),U,5,15,[3,5]),Oe($e(re.dK,1),U,5,15,[2,4,6]),Oe($e(re.dK,1),U,5,15,[1,3,5,7]),Oe($e(re.dK,1),U,5,15,[0]),Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),null,null,null,null,null,null,null,null,null,null,Oe($e(re.dK,1),U,5,15,[2,3]),Oe($e(re.dK,1),U,5,15,[2,4]),Oe($e(re.dK,1),U,5,15,[3,5]),Oe($e(re.dK,1),U,5,15,[2,4,6]),Oe($e(re.dK,1),U,5,15,[1,3,5,7]),Oe($e(re.dK,1),U,5,15,[0,2]),Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),null,null,null,null,null,null,null,null,null,null,Oe($e(re.dK,1),U,5,15,[1,2,3]),Oe($e(re.dK,1),U,5,15,[2,4]),Oe($e(re.dK,1),U,5,15,[3,5]),Oe($e(re.dK,1),U,5,15,[2,4,6]),Oe($e(re.dK,1),U,5,15,[1,3,5,7]),Oe($e(re.dK,1),U,5,15,[0,2,4,6]),Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[2])]),ce.Ii=Oe($e(re.dK,2),p,8,0,[null,Oe($e(re.dK,1),U,5,15,[1]),null,Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),null,null,Oe($e(re.dK,1),U,5,15,[-3]),Oe($e(re.dK,1),U,5,15,[-2]),Oe($e(re.dK,1),U,5,15,[-1]),null,Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[3]),null,Oe($e(re.dK,1),U,5,15,[-3]),Oe($e(re.dK,1),U,5,15,[-2]),Oe($e(re.dK,1),U,5,15,[-1]),null,Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[2,3,4]),Oe($e(re.dK,1),U,5,15,[2,3,4,5]),Oe($e(re.dK,1),U,5,15,[2,3,6]),Oe($e(re.dK,1),U,5,15,[2,3,4,7]),Oe($e(re.dK,1),U,5,15,[2,3]),Oe($e(re.dK,1),U,5,15,[2,3]),Oe($e(re.dK,1),U,5,15,[2,3]),Oe($e(re.dK,1),U,5,15,[1,2]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[2,4]),Oe($e(re.dK,1),U,5,15,[-3,3,5]),Oe($e(re.dK,1),U,5,15,[-2]),Oe($e(re.dK,1),U,5,15,[-1]),null,Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[4]),Oe($e(re.dK,1),U,5,15,[3,5]),Oe($e(re.dK,1),U,5,15,[6]),Oe($e(re.dK,1),U,5,15,[4,6,7]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[2,4]),Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[2,4]),Oe($e(re.dK,1),U,5,15,[-3,3,5]),Oe($e(re.dK,1),U,5,15,[-2,4,6]),Oe($e(re.dK,1),U,5,15,[-1]),null,Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3,4]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[2,3]),Oe($e(re.dK,1),U,5,15,[2,3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[2,3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[4]),Oe($e(re.dK,1),U,5,15,[5]),Oe($e(re.dK,1),U,5,15,[6]),Oe($e(re.dK,1),U,5,15,[4,6,7]),Oe($e(re.dK,1),U,5,15,[3,4]),Oe($e(re.dK,1),U,5,15,[3,4]),Oe($e(re.dK,1),U,5,15,[2,4]),Oe($e(re.dK,1),U,5,15,[1,3]),Oe($e(re.dK,1),U,5,15,[1,2]),Oe($e(re.dK,1),U,5,15,[1,3]),Oe($e(re.dK,1),U,5,15,[2,4]),Oe($e(re.dK,1),U,5,15,[3,5]),Oe($e(re.dK,1),U,5,15,[-2,2,4]),Oe($e(re.dK,1),U,5,15,[-1,1]),null,Oe($e(re.dK,1),U,5,15,[1]),Oe($e(re.dK,1),U,5,15,[2]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[4]),Oe($e(re.dK,1),U,5,15,[4,5]),Oe($e(re.dK,1),U,5,15,[3,4,5,6]),Oe($e(re.dK,1),U,5,15,[3,4,5,6]),Oe($e(re.dK,1),U,5,15,[3,4,5,6]),Oe($e(re.dK,1),U,5,15,[3,4,5,6]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3,4]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[3]),Oe($e(re.dK,1),U,5,15,[2,3]),Oe($e(re.dK,1),U,5,15,[2,3]),Oe($e(re.dK,1),U,5,15,[3])])},ce.Mi=function(t,n,e,o){var r;return r=ce.Ni(t,6),ce.Sg(t.H[r],n,e,o),r},ce.Ni=function(t,n){return t.o>=t.K&&ce.Bl(t,2*t.K),t.A[t.o]=0,ce.ml(t,t.o,n),t.q[t.o]=0,t.s[t.o]=0,t.w[t.o]=0,t.u[t.o]=0,ce.Sg(t.H[t.o],0,0,0),null!=t.t&&(t.t[t.o]=null),null!=t.r&&(t.r[t.o]=null),t.R=0,t.o++},ce.Oi=function(t,n,e){var o,r;return ce.Pi(t,n,e,(r=t.A[n])>=3&&r<=4||r>=11&&r<=13||r>=19&&r<=31||r>=37&&r<=51||r>=55&&r<=84||r>=87&&r<=103||((o=t.A[e])>=3&&o<=4||o>=11&&o<=13||o>=19&&o<=31||o>=37&&o<=51||o>=55&&o<=84||o>=87&&o<=103)?32:1)},ce.Pi=function(t,n,e,o){var r;if(n==e)return-1;for(r=0;r<t.p;r++)if(t.B[0][r]==n&&t.B[1][r]==e||t.B[0][r]==e&&t.B[1][r]==n)return t.F[r]<o&&(t.F[r]=o),r;return t.p>=t.L&&ce.Cl(t,2*t.L),t.B[0][t.p]=n,t.B[1][t.p]=e,t.F[t.p]=o,t.C[t.p]=0,t.D[t.p]=0,t.R=0,t.p++},ce.Qi=function(t,n){var e,o,r,i,a;for(t.I=t.I|n.I,o=Ke(re.hK,L,5,n.o,15,1),i=ce.Pk(t,1),a=ce.Pk(t,2),e=0;e<n.o;e++)o[e]=ce.bj(n,t,e,i,a);for(r=0;r<n.p;r++)ce.cj(n,t,r,i,a,o[n.B[0][r]],o[n.B[1][r]],!1);return t.J=t.J&&n.J,t.G=0,t.R=0,o},ce.Ri=function(t,n,e,o,r,i,a,s){var u,f;return-1==(u=ce.nj(t,n,e))?(t.o>=t.K&&ce.Bl(t,2*t.K),u=ce.Ni(t,o),ce.Sg(t.H[u],n,e,0),t.v[u]=r,ce.Tk(t,u,i),ce.gl(t,u,a),ce.Yk(t,u,s),!0):(f=ce.Yi(t,u,o,r,i,a),ce.Yk(t,u,s),f)},ce.Si=function(t,n,e,o){var r;for(r=0;r<t.p;r++)if(t.B[0][r]==n&&t.B[1][r]==e||t.B[0][r]==e&&t.B[1][r]==n)return ce.$i(t,r,o),t.R=0,r;return t.p>=t.L&&ce.Cl(t,2*t.L),t.B[0][t.p]=n,t.B[1][t.p]=e,t.F[t.p]=o,t.C[t.p]=0,t.D[t.p]=0,t.R=0,t.p++},ce.Ti=function(t,n,e,o,r){for(var i,a,s;t.o+o>t.K;)ce.Bl(t,2*t.K);for(;t.p+o>t.L;)ce.Cl(t,2*t.L);return-1!=(i=ce.nj(t,n,e))?ce.Ui(t,i,o,r):-1!=(a=ce.oj(t,n,e))?ce.Vi(t,a,o,r):(i=ce.Mi(t,n,e,0),s=gt*(o-2)/o,ce.Hk(t,i,o,i,r,0,gt-s),t.R=0,!0)},ce.Ui=function(n,e,o,r){var i,a,s,u,f,l;if(r&&ce.Sm(n,e)>1||!r&&ce.Sm(n,e)>2)return!1;for(a=0,i=Ke(re.fK,ut,5,4,15,1),u=0;u<n.p;u++){for(f=0;f<2;f++)if(n.B[f][u]==e){if(2==a){a=3;break}i[a++]=ce.Mj(n,e,n.B[1-f][u])}if(3==a)break}return 3!=a&&(l=1==a?i[0]+gt:t.Math.abs(i[0]-i[1])>gt?(i[0]+i[1])/2:(i[0]+i[1])/2+gt,s=gt*(o-2)/o,ce.Hk(n,e,o,e,r,l-s/2,gt-s),n.R=0,!0)},ce.Vi=function(t,n,e,o){var r,i,a,s,u,f,l,c,h,w,g;if(u=Ke(re.hK,L,5,2,15,1),s=Ke(re.fK,ut,5,2,15,1),u[0]=t.B[0][n],u[1]=t.B[1][n],ce.Sm(t,u[0])>3)return!1;if(ce.Sm(t,u[1])>3)return!1;for(i=0,r=Ke(re.fK,ut,5,4,15,1),c=0;c<t.p;c++)if(c!=n){for(h=0;h<2;h++){for(w=0;w<2;w++)if(t.B[h][c]==u[w]){if(4==i){i=5;break}r[i++]=ce.Mj(t,u[w],t.B[1-h][c])}if(5==i)break}if(5==i)break}if(5==i)return!1;for(s[0]=ce.Mj(t,u[0],u[1]),s[0]<0?(s[1]=s[0]+gt,a=0):(s[1]=s[0],s[0]=s[1]-gt,a=1),g=0,l=0;l<i;l++)r[l]>s[0]&&r[l]<s[1]?--g:++g;return a=g>0?1-a:a,f=gt*(e-2)/e,ce.Hk(t,u[a],e-1,u[1-a],o,s[g>0?0:1]+gt-f,gt-f),t.R=0,!0},ce.Wi=function(t,n,e){var o,r,i,a,s;for(r=Ke(re.hK,L,5,n.o,15,1),a=ce.Pk(t,1),s=ce.Pk(t,2),o=0;o<n.o;o++)0!=n.A[o]?r[o]=ce.bj(n,t,o,a,s):r[o]=e;for(i=0;i<n.p;i++)ce.cj(n,t,i,a,s,r[n.B[0][i]],r[n.B[1][i]],!1);return t.J=t.J&&n.J,t.G=0,t.R=0,r},ce.Xi=function(n,e){var o,r,i,a,s,u,f,l,c;return o=n.H[e[0]],r=n.H[e[1]],i=n.H[e[2]],a=n.H[e[3]],f=new ce.Vg(r.a-o.a,r.b-o.b,r.c-o.c),l=new ce.Vg(i.a-r.a,i.b-r.b,i.c-r.c),c=new ce.Vg(a.a-i.a,a.b-i.b,a.c-i.c),s=new ce.Vg(f.b*l.c-f.c*l.b,-(f.a*l.c-f.c*l.a),f.a*l.b-f.b*l.a),u=new ce.Vg(l.b*c.c-l.c*c.b,-(l.a*c.c-l.c*c.a),l.a*c.b-l.b*c.a),-t.Math.atan2(t.Math.sqrt(l.a*l.a+l.b*l.b+l.c*l.c)*(f.a*u.a+f.b*u.b+f.c*u.c),s.a*u.a+s.b*u.b+s.c*u.c)},ce.Yi=function(t,n,e,o,r,i){return(1!=e&&151!=e&&152!=e||!(ce.Sm(t,n)>1))&&(t.w[n]&=-2,null!=t.t&&(t.t[n]=null),null!=t.r&&(t.r[n]=null),(e!=t.A[n]||o!=t.v[n]||r!=((t.s[n]&qt)>>>28)-1||i!=(48&t.s[n]))&&(151!=e&&152!=e||(o=e-149,e=1),t.s[n]&=960,t.A[n]=e,t.v[n]=o,t.q[n]=0,t.w[n]=0,ce.Tk(t,n,r),ce.gl(t,n,i),ce.Nk(t,t.u[n]),t.R=0,!0))},ce.Zi=function(t,n,e){if(e){if(t.q[n]>8)return!1;++t.q[n]}else{if(t.q[n]<-8)return!1;--t.q[n]}return t.R=0,!0},ce.$i=function(t,n,e){var o,r,i,a,s;return i=!1,a=t.F[n],127==e?i=ce.fk(t,n):ce.Rn(t,n,e)&&(17==e||9==e?(o=ce.Ik(t,n,t.B[0][n]),r=ce.Ik(t,n,t.B[1][n]),e==a?(o==r||r)&&(s=t.B[0][n],t.B[0][n]=t.B[1][n],t.B[1][n]=s,i=!0):(!o&&r&&(s=t.B[0][n],t.B[0][n]=t.B[1][n],t.B[1][n]=s),t.F[n]=e,i=!0)):(t.F[n]=e,i=!0)),i&&(t.R=(103&a)==(103&e)?7&t.R:0,t.D[n]=0),i},ce._i=function(t){t.o=0,t.p=0,t.I=!1,t.J=!1,t.G=0,t.t=null,t.r=null,t.N=null,t.R=0},ce.aj=function(t){var n,e,o,r,i,a,s,u;for(a=0;a<t.p;a++)128==t.F[a]&&(e=t.B[0][a],o=t.B[1][a],-1==t.A[e]^-1==t.A[o]&&0!=t.q[e]&&0!=t.q[o]&&t.q[e]<0^t.q[o]<0&&(t.q[e]<0?(++t.q[e],--t.q[o]):(--t.q[e],++t.q[o])));for(u=Ke(re.hK,L,5,t.o,15,1),r=0,n=0;n<t.o;n++)-1!=t.A[n]?(r<n&&(t.A[r]=t.A[n],t.q[r]=t.q[n],t.v[r]=t.v[n],t.s[r]=t.s[n],t.w[r]=t.w[n],t.u[r]=t.u[n],ce.Tg(t.H[r],t.H[n]),null!=t.t&&(t.t[r]=t.t[n]),null!=t.r&&(t.r[r]=t.r[n])),u[n]=r,++r):u[n]=-1;for(t.o=r,s=0,i=0;i<t.p;i++)128!=t.F[i]&&(t.F[s]=t.F[i],t.C[s]=t.C[i],t.D[s]=t.D[i],t.B[0][s]=u[t.B[0][i]],t.B[1][s]=u[t.B[1][i]],++s);return t.p=s,u},ce.bj=function(n,e,o,r,i){var a,s,u;return(a=e.o)>=e.K&&ce.Bl(e,2*e.K),s=-1,1==(u=(n.s[o]&Rt)>>19)?s=-1==r?ce.Pk(e,u):t.Math.min(31,r+((n.s[o]&Rt)>>19!=1&&(n.s[o]&Rt)>>19!=2?-1:(n.s[o]&Jt)>>21)):2==u&&(s=-1==i?ce.Pk(e,u):t.Math.min(31,i+((n.s[o]&Rt)>>19!=1&&(n.s[o]&Rt)>>19!=2?-1:(n.s[o]&Jt)>>21))),e.A[a]=n.A[o],e.q[a]=n.q[o],e.v[a]=n.v[o],e.s[a]=n.s[o],e.w[a]=e.I?n.w[o]:0,ce.Tg(e.H[a],n.H[o]),e.u[a]=n.u[o],null!=e.t&&(e.t[a]=null),null!=n.t&&null!=n.t[o]&&e.I&&(null==e.t&&(e.t=Ke(re.hK,Pt,6,e.A.length,0,2)),e.t[a]=ue.PW(n.t[o],n.t[o].length)),null!=e.r&&(e.r[a]=null),null!=n.r&&null!=n.r[o]&&(null==e.r&&(e.r=Ke(re.dK,p,8,e.A.length,0,2)),e.r[a]=ue.OW(n.r[o],n.r[o].length)),-1!=s&&(e.s[a]&=-65011713,e.s[a]|=s<<21),++e.o,e.R=0,a},ce.cj=function(n,e,o,r,i,a,s,u){var f,l,c,h;return(l=e.p)>=e.L&&ce.Cl(e,2*e.L),c=-1,1==(h=(n.C[o]&Qt)>>10)&&(c=-1==r?ce.Pk(e,h):t.Math.min(32,r+((n.C[o]&Qt)>>10!=1&&(n.C[o]&Qt)>>10!=2?-1:(n.C[o]&Xt)>>12))),2==h&&(c=-1==i?ce.Pk(e,h):t.Math.min(32,i+((n.C[o]&Qt)>>10!=1&&(n.C[o]&Qt)>>10!=2?-1:(n.C[o]&Xt)>>12))),e.B[0][l]=a,e.B[1][l]=s,f=u&&0!=(512&n.C[o])?64:n.F[o],e.F[l]=f,e.C[l]=n.C[o],e.D[l]=e.I?n.D[o]:0,-1!=c&&(e.C[l]&=-126977,e.C[l]|=c<<12),++e.p,e.R=0,l},ce.dj=function(t,n,e,o,r,i,a){return ce.cj(t,n,e,o,r,null==i?t.B[0][e]:i[t.B[0][e]],null==i?t.B[1][e]:i[t.B[1][e]],a)},ce.ej=function(t,n){var e,o;for(n.t=null,n.r=null,n.I=t.I,n.o=0,e=0;e<t.o;e++)ce.bj(t,n,e,0,0);for(n.p=0,o=0;o<t.p;o++)ce.cj(t,n,o,0,0,t.B[0][o],t.B[1][o],!1);t.pb(n)},ce.fj=function(t,n){n.I=t.I,n.J=t.J,n.Q=t.Q,n.G=t.G,n.N=t.N,n.R=24&t.R},ce.gj=function(t,n){var e,o,r,i;for(e=0;e<t.p;e++)for(r=0;r<2;r++)if(t.B[r][e]==n){for(t.F[e]=128,o=0,i=0;i<t.p;i++)i!=e&&(t.B[0][i]===t.B[1-r][e]||t.B[1][i]===t.B[1-r][e])&&++o;0==o&&(ce.Nk(t,t.u[t.B[1-r][e]]),t.A[t.B[1-r][e]]=-1)}ce.Nk(t,t.u[n]),t.A[n]=-1,null!=t.t&&(t.t[n]=null),null!=t.r&&(t.r[n]=null),ce.aj(t),t.R=0},ce.hj=function(t,n,e){var o,r;return-1!=(o=ce.nj(t,n,e))?(0!=(512&t.s[o])?ce.mj(t):ce.gj(t,o),t.R=0,!0):-1!=(r=ce.oj(t,n,e))&&(0!=(t.s[t.B[0][r]]&t.s[t.B[1][r]]&512)?ce.mj(t):ce.kj(t,r),t.R=0,!0)},ce.ij=function(t,n){var e,o,r,i;if(0==n.length)return null;for(r=0,i=(o=n).length;r<i;++r)e=o[r],t.A[e]=-1;return ce.lj(t)},ce.jj=function(t,n){t.F[n]=128,ce.aj(t),t.R=0},ce.kj=function(t,n){var e,o,r;for(o=0;o<2;o++){for(e=0,r=0;r<t.p;r++)r!=n&&(t.B[0][r]===t.B[o][n]||t.B[1][r]===t.B[o][n])&&++e;0==e&&(ce.Nk(t,t.u[t.B[o][n]]),t.A[t.B[o][n]]=-1)}t.F[n]=128,ce.aj(t),t.R=0},ce.lj=function(t){var n,e,o;for(o=!1,n=0;n<t.o;n++)-1==t.A[n]&&(o=!0,ce.Nk(t,t.u[n]));for(e=0;e<t.p;e++)128==t.F[e]?o=!0:-1!=t.A[t.B[0][e]]&&-1!=t.A[t.B[1][e]]||(t.F[e]=128,o=!0);return o?(t.R=0,ce.aj(t)):null},ce.mj=function(t){var n,e;for(e=!1,n=0;n<t.o;n++)0!=(512&t.s[n])&&(t.A[n]=-1,e=!0);return e&&null!=ce.lj(t)},ce.nj=function(t,n,e){var o,r,i,a,s,u,f,l;for(a=-1,r=ce.Kj(t,t.o,t.p,ce.Ki),s=_t,u=r*r/12,o=0;o<t.o;o++)(i=(n-(f=t.H[o].a))*(n-f)+(e-(l=t.H[o].b))*(e-l))<u&&i<s&&(s=i,a=o);return a},ce.oj=function(n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m,d,p;for(c=-1,w=ce.Kj(n,n.o,n.p,ce.Ki),h=_t,r=0;r<n.p;r++)g=n.H[n.B[0][r]].a,d=n.H[n.B[0][r]].b,f=(m=n.H[n.B[1][r]].a)-g,l=(p=n.H[n.B[1][r]].b)-d,i=t.Math.sqrt(f*f+l*l),f=e-(g+m)/2,l=o-(d+p)/2,t.Math.sqrt(f*f+l*l)>i/2||(m==g?u=t.Math.abs(g-e):(s=-(a=(p-d)/(g-m))*g-d,u=t.Math.abs((a*e+o+s)/t.Math.sqrt(a*a+1))),u<w&&u<h&&(h=u,c=r));return c},ce.pj=function(t,n){return((t.s[n]&qt)>>>28)-1},ce.qj=function(t,n){return(98304&t.s[n])>>15},ce.rj=function(t,n){return t.q[n]},ce.sj=function(t,n){return 448&t.s[n]},ce.tj=function(t,n){return null==t.r||null==t.r[n]?null:ie.FR(t.r[n])},ce.uj=function(t,n){return null==t.r?null:t.r[n]},ce.vj=function(t,n){return(t.s[n]&Rt)>>19!=1&&(t.s[n]&Rt)>>19!=2?-1:(t.s[n]&Jt)>>21},ce.wj=function(t,n){return(t.s[n]&Rt)>>19},ce.xj=function(t,n){return ce.Gi[t.A[n]]},ce.yj=function(t,n){return null==t.t?null:t.t[n]},ce.zj=function(t,n){var e,o,r;if(null==t.t||null==t.t[n])return 0!=(1&t.w[n])?"":ce.Gi[t.A[n]];for(r="",o=0;o<t.t[n].length;o++)o>0&&(le.M$(r),r+=(le.M$(","),",")),e=t.t[n][o],r=ie.ER(r,ce.Gi[e]);return r},ce.Aj=function(n,e){return t.Math.abs(n.u[e])},ce.Bj=function(t,n){return t.v[n]},ce.Cj=function(t,n){return 3&t.s[n]},ce.Dj=function(t,n){return t.w[n]},ce.Ej=function(t,n){return 48&t.s[n]},ce.Fj=function(t,n){return t.H[n].a},ce.Gj=function(t,n){return t.H[n].b},ce.Hj=function(t,n){return t.H[n].c},ce.Ij=function(t,n){return t.A[n]},ce.Jj=function(t){return ce.Kj(t,t.o,t.p,ce.Ki)},ce.Kj=function(t,n,e,o){return ce.Lj(t,n,e,o,t.H)},ce.Lj=function(t,n,e,o,r){var i,a,s,u,f,l,c,h,w,g;for(c=!1,h=0,f=0;f<e;f++)32!=t.F[f]&&0==(t.D[f]&kt)&&++h;if(0==h){for(l=0;l<e;l++)0==(t.D[l]&kt)&&++h;c=!0}if(0==h){if(n<2)return o;for(g=_t,i=1;i<n;i++)for(a=0;a<i;a++)(w=ce.Rg(r[i],r[a]))>0&&w<g&&(g=w);return g!=_t?.6*g:o}for(s=0,u=0;u<e;u++)(c||32!=t.F[u])&&0==(t.D[u]&kt)&&(s+=ce.Rg(r[t.B[1][u]],r[t.B[0][u]]));return s/h},ce.Mj=function(t,n,e){return ce.Wl(t.H[n].a,t.H[n].b,t.H[e].a,t.H[e].b)},ce.Nj=function(t,n,e){return t.B[n][e]},ce.Oj=function(t,n){return((t.D[n]&pt)>>7)+((30720&t.D[n])>>11)},ce.Pj=function(t,n){return(t.D[n]&pt)>>7},ce.Qj=function(t,n){return(48&t.C[n])>>4},ce.Rj=function(t,n){return(t.C[n]&Qt)>>10!=1&&(t.C[n]&Qt)>>10!=2?-1:(t.C[n]&Xt)>>12},ce.Sj=function(t,n){return(t.C[n]&Qt)>>10},ce.Tj=function(n,e){var o,r,i,a;return o=n.B[0][e],r=n.B[1][e],i=n.H[r].a-n.H[o].a,a=n.H[r].b-n.H[o].b,t.Math.sqrt(i*i+a*a)},ce.Uj=function(t,n,e){var o;for(o=0;o<t.p;o++)if((t.B[0][o]==n&&t.B[1][o]==e||t.B[0][o]==e&&t.B[1][o]==n)&&128!=t.F[o])return o;return-1},ce.Vj=function(t,n){switch(103&t.F[n]){case 1:case 64:return 1;case 2:return 2;case 4:return 3;default:return 0}},ce.Wj=function(t,n){return 3&t.C[n]},ce.Xj=function(t,n){return t.D[n]},ce.Yj=function(t,n){return t.F[n]},ce.Zj=function(t,n){return 103&t.F[n]},ce.$j=function(t,n){var e,o,r,i,a;if(0==t.o)return null;for(o=t.H[0].a,i=t.H[0].b,r=t.H[0].a,a=t.H[0].b,e=1;e<t.o;e++)o>t.H[e].a?o=t.H[e].a:r<t.H[e].a&&(r=t.H[e].a),i>t.H[e].b?i=t.H[e].b:a<t.H[e].b&&(a=t.H[e].b);return n?(n.c=o,n.d=i,n.b=r-o,n.a=a-i):n=new ve.mP(o,i,r-o,a-i),n},ce._j=function(t,n){var e;return null==(e=t.A[n]<ce.Hi.length?ce.Hi[t.A[n]]:null)?6:e[e.length-1]},ce.ak=function(n,e,o){var r,i;return n.A[e]>=171&&n.A[e]<=190?0:(i=0,32==(48&n.s[e])&&(i-=1),(16==(48&n.s[e])||48==(48&n.s[e]))&&(i-=2),0==(r=n.q[e])&&n.I&&((n.w[e]&bt)==jt&&(r=-1),(n.w[e]&bt)==yt&&(r=1)),7==n.A[e]||8==n.A[e]||9==n.A[e]?i+=r:6==n.A[e]||14==n.A[e]||32==n.A[e]?i-=t.Math.abs(r):15==n.A[e]||33==n.A[e]?o-i-r<=3?i+=r:i-=r:16==n.A[e]||34==n.A[e]||52==n.A[e]?o-i-r<=4?i+=r:i-=t.Math.abs(r):17==n.A[e]||35==n.A[e]||53==n.A[e]?o-i-r<=5?i+=r:i-=t.Math.abs(r):i-=r,i)},ce.bk=function(t,n){var e;return(e=ce.ck(t,n))+ce.ak(t,n,e)},ce.ck=function(t,n){var e,o;return-1==(e=((t.s[n]&qt)>>>28)-1)&&(e=null==(o=t.A[n]<ce.Hi.length?ce.Hi[t.A[n]]:null)?6:o[o.length-1]),e},ce.dk=function(t,n){var e,o,r,i,a;for(i=3,o=0;o<2;o++)e=t.B[o][n],i>(r=ce.Vj(t,n)+((a=ce.ck(t,e))+ce.ak(t,e,a))-ce.Sm(t,e))&&(i=r);return i},ce.ek=function(t,n){return 0!=(t.s[n]&Ot)},ce.fk=function(t,n){var e,o,r;return o=ce.dk(t,n),r=(e=ce.xk(t,t.B[0][n])||ce.xk(t,t.B[1][n]))?32:1,4==t.F[n]?(t.F[n]=r,t.R=0,!0):2==t.F[n]&&(t.F[n]=26,t.R&=7,0==(128&t.C[n]))||(26==t.F[n]?(t.F[n]=3==o?4:r,t.R=0,!0):0!=(24&t.F[n])?(t.F[n]=1,t.R&=7,!0):!(!e&&o<2)&&(1==t.F[n]?(t.F[n]=2,t.R=0,!0):!(o<1)&&(32==t.F[n]&&(t.F[n]=1,t.R=0,!0))))},ce.gk=function(t){var n;for(t.R=0,t.A=Ke(re.hK,L,5,t.K,15,1),t.q=Ke(re.hK,L,5,t.K,15,1),t.u=Ke(re.hK,L,5,t.K,15,1),t.H=Ke(re.yK,C,34,t.K,0,1),n=0;n<t.K;n++)t.H[n]=new ce.Ug;t.v=Ke(re.hK,L,5,t.K,15,1),t.s=Ke(re.hK,L,5,t.K,15,1),t.w=Ke(re.hK,L,5,t.K,15,1),t.t=null,t.r=null,t.B=Pe(re.hK,[Pt,L],[6,5],15,[2,t.L],2),t.F=Ke(re.hK,L,5,t.L,15,1),t.C=Ke(re.hK,L,5,t.L,15,1),t.D=Ke(re.hK,L,5,t.L,15,1)},ce.hk=function(t,n){t.R&=~n},ce.ik=function(t){var n;for(n=0;n<t.o;n++)if(0!=t.H[n].c)return!0;return!1},ce.jk=function(t,n){return 0!=(t.s[n]&zt)},ce.kk=function(t,n){return-1==t.A[n]},ce.lk=function(t,n){return 0!=(4&t.s[n])},ce.mk=function(t,n){return 0!=(t.s[n]&Zt)},ce.nk=function(t,n){return t.u[n]<0};ce.ok=function(t,n){return 0!=(t.C[n]&Ot)},ce.pk=function(t,n){return 0!=(t.D[n]&kt)},ce.qk=function(t,n){return 0!=(t.C[n]&Bt)},ce.rk=function(t,n){return 128==t.F[n]},ce.sk=function(t,n){return 0!=(4&t.C[n])},ce.tk=function(t,n){return 0!=(t.C[n]&Wt)},ce.uk=function(t,n){return ce.Zl(t.A[n])},ce.vk=function(t,n){return ce.$l(t.A[n])},ce.wk=function(t,n){return 0!=(t.s[n]&Bt)},ce.xk=function(t,n){var e;return(e=t.A[n])>=3&&e<=4||e>=11&&e<=13||e>=19&&e<=31||e>=37&&e<=51||e>=55&&e<=84||e>=87&&e<=103},ce.yk=function(t,n){return 0==t.v[n]},ce.zk=function(t,n){var e;return 1==(e=t.A[n])||e>=5&&e<=9||e>=14&&e<=17||e>=32&&e<=35||e>=52&&e<=53},ce.Ak=function(t){var n;for(n=0;n<t.o;n++)switch(t.A[n]){case 1:case 5:case 6:case 7:case 8:case 9:case 14:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:continue;default:return!1}return!0},ce.Bk=function(t,n){return 0!=(512&t.s[n])},ce.Ck=function(t,n){return 0!=(t.s[t.B[0][n]]&t.s[t.B[1][n]]&512)},ce.Dk=function(t,n){return 17==t.F[n]||9==t.F[n]},ce.Ek=function(t,n,e){return(17==t.F[n]||9==t.F[n])&&t.B[0][n]==e},ce.Fk=function(t,n){t.A[n]=-1},ce.Gk=function(t,n){t.F[n]=128},ce.Hk=function(n,e,o,r,i,a,s){var u,f,l,c,h,w,g,m,d,p,G,b,y,j,N;for(e==r?g=ce.Kj(n,n.o,n.p,ce.Ki):(j=n.H[e].a-n.H[r].a,N=n.H[e].b-n.H[r].b,g=t.Math.sqrt(j*j+N*N)),u=e,m=3!=ce.Gl(n,e),y=1;y<o;y++){for(p=n.H[u].a+g*t.Math.sin(a),G=n.H[u].b+g*t.Math.cos(a),b=-1,d=0;d<n.o;d++)if(t.Math.abs(p-n.H[d].a)<4&&t.Math.abs(G-n.H[d].b)<4){b=d;break}-1==b&&(b=ce.Mi(n,p,G,0),n.H[b].a=p,n.H[b].b=G,n.H[b].c=0),-1==(w=ce.Uj(n,u,b))&&(w=ce.Pi(n,u,b,(l=n.A[u])>=3&&l<=4||l>=11&&l<=13||l>=19&&l<=31||l>=37&&l<=51||l>=55&&l<=84||l>=87&&l<=103||((c=n.A[b])>=3&&c<=4||c>=11&&c<=13||c>=19&&c<=31||c>=37&&c<=51||c>=55&&c<=84||c>=87&&c<=103)?32:1),i&&(m&&ce.Gl(n,n.B[0][w])<4&&ce.Gl(n,n.B[1][w])<3&&(n.F[w]=2),m=!m)),u=b,a+=s}-1==(w=ce.Uj(n,u,r))&&(w=ce.Pi(n,u,r,(h=n.A[u])>=3&&h<=4||h>=11&&h<=13||h>=19&&h<=31||h>=37&&h<=51||h>=55&&h<=84||h>=87&&h<=103||((f=n.A[r])>=3&&f<=4||f>=11&&f<=13||f>=19&&f<=31||f>=37&&f<=51||f>=55&&f<=84||f>=87&&f<=103)?32:1)),i&&m&&ce.Gl(n,n.B[0][w])<4&&ce.Gl(n,n.B[1][w])<4&&(n.F[w]=2)},ce.Ik=function(t,n,e){var o,r;if(1!=ce.Vj(t,n))return!1;if(0!=(3&t.s[e]))return!0;for(r=0;r<t.p;r++)if(r!=n&&2==t.F[r]&&(t.B[0][r]==e&&0!=(3&t.s[t.B[1][r]])||t.B[1][r]==e&&0!=(3&t.s[t.B[0][r]])))return!0;for(o=0;o<t.p;o++)if(o!=n&&1==t.F[o]&&(t.B[0][o]==e||t.B[1][o]==e)&&0!=(3&t.C[o]))return!0;return!1},ce.Jk=function(t){var n;for(n=0;n<t.o;n++)t.s[n]&=-449},ce.Kk=function(t){var n;for(n=0;n<t.o;n++)t.s[n]&=-262145},ce.Lk=function(t){var n;for(n=0;n<t.o;n++)t.s[n]&=-513},ce.Mk=function(t){var n;for(n=0;n<t.p;n++)t.C[n]&=-393217},ce.Nk=function(n,e){var o;for(o=0;o<n.o;o++)t.Math.abs(n.u[o])==t.Math.abs(e)&&(n.u[o]=0)},ce.Ok=function(t){var n,e,o,r;for(r=!1,e=0;e<t.o;e++)0!=(t.w[e]&lt)&&(t.A[e]=-1,r=!0);for(r&&ce.lj(t),null!=t.t&&(t.t=null,r=!0),n=0;n<t.o;n++)0!=t.w[n]&&(t.w[n]=0,r=!0);for(o=0;o<t.p;o++)0!=t.D[o]&&(t.D[o]=0,r=!0),64==t.F[o]&&(t.F[o]=1,r=!0);return r&&(t.R=0),r},ce.Pk=function(t,n){var e,o,r,i,a,s,u,f,l;if(0==n)return 0;for(s=null,o=0;o<t.o;o++)(t.s[o]&Rt)>>19==n&&(null==s&&(s=Ke(re.DN,ft,5,32,16,1)),s[(t.s[o]&Rt)>>19!=1&&(t.s[o]&Rt)>>19!=2?-1:(t.s[o]&Jt)>>21]=!0);for(i=0;i<t.p;i++)(t.C[i]&Qt)>>10==n&&(null==s&&(s=Ke(re.DN,ft,5,32,16,1)),s[(t.C[i]&Qt)>>10!=1&&(t.C[i]&Qt)>>10!=2?-1:(t.C[i]&Xt)>>12]=!0);if(l=0,null!=s){for(f=Ke(re.hK,L,5,32,15,1),u=0;u<32;u++)s[u]&&(f[u]=l++);for(e=0;e<t.o;e++)(t.s[e]&Rt)>>19==n&&(a=f[(t.s[e]&Rt)>>19!=1&&(t.s[e]&Rt)>>19!=2?-1:(t.s[e]&Jt)>>21],t.s[e]&=-65011713,t.s[e]|=a<<21);for(r=0;r<t.p;r++)(t.C[r]&Qt)>>10==n&&(a=f[(t.C[r]&Qt)>>10!=1&&(t.C[r]&Qt)>>10!=2?-1:(t.C[r]&Xt)>>12],t.C[r]&=-126977,t.C[r]|=a<<12)}return l},ce.Qk=function(t,n){var e;for(e=0;e<t.o;e++)t.H[e].a*=n,t.H[e].b*=n},ce.Rk=function(t,n){t.o=n,t.R=0},ce.Sk=function(t,n){t.p=n,t.R=0},ce.Tk=function(t,n,e){e>=-1&&e<=14&&(t.s[n]&=268435455,t.s[n]|=1+e<<28,6==t.A[n]&&(-1!=e&&0!=e&&2!=e&&4!=e||(t.s[n]&=-49,2==e&&(t.s[n]|=16))))},ce.Uk=function(t,n,e){t.s[n]&=-98305,t.s[n]|=e<<15},ce.Vk=function(t,n,e){t.q[n]=e,t.R=0},ce.Wk=function(t,n,e){t.s[n]&=-449,t.s[n]|=e},ce.Xk=function(t,n,e){e?t.s[n]|=zt:t.s[n]&=-67108865,t.R&=7},ce.Yk=function(t,n,e){var o,r;null!=e&&(0==le.V$(e).length?e=null:(0!=(o=ce.Yl(e))&&ie.GR(e,ce.Gi[o])||ie.GR(e,"?"))&&(ce.ml(t,n,o),e=null)),null==e?null!=t.r&&(t.r[n]=null):(null==t.r&&(t.r=Ke(re.dK,p,8,t.K,0,2)),t.r[n]=le.F$((r=e,le.A$(),r)))},ce.Zk=function(t,n,e){null!=e&&0==e.length&&(e=null),null==e?null!=t.r&&(t.r[n]=null):(null==t.r&&(t.r=Ke(re.dK,p,8,t.K,0,2)),t.r[n]=e)},ce.$k=function(t,n,e,o){var r,i,a;if(0==e)t.s[n]&=tn,t.s[n]|=e<<19;else{if(o>=32)return;if(-1==o){for(a=-1,i=0;i<t.o;i++)i!=n&&e==(t.s[i]&Rt)>>19&&a<((t.s[i]&Rt)>>19!=1&&(t.s[i]&Rt)>>19!=2?-1:(t.s[i]&Jt)>>21)&&(a=(t.s[i]&Rt)>>19!=1&&(t.s[i]&Rt)>>19!=2?-1:(t.s[i]&Jt)>>21);for(r=0;r<t.p;r++)e==(t.C[r]&Qt)>>10&&a<((t.C[r]&Qt)>>10!=1&&(t.C[r]&Qt)>>10!=2?-1:(t.C[r]&Xt)>>12)&&(a=(t.C[r]&Qt)>>10!=1&&(t.C[r]&Qt)>>10!=2?-1:(t.C[r]&Xt)>>12);if((o=a+1)>=32)return}t.s[n]&=tn,t.s[n]|=e<<19|o<<21}t.R&=7},ce._k=function(t,n,e){null==t.t&&(t.t=Ke(re.hK,Pt,6,t.K,0,2)),le.V$(e).sort(le.V$(Ie(ue.pX.prototype.Ub,ue.pX,[]))),t.t[n]=e,t.R=0,t.I=!0},ce.al=function(t,n,e,o){var r;if(null!=e){if(1==e.length&&!o)return r=e[0],t.A[n]!=r&&ce.Yi(t,n,r,0,-1,0),void(null!=t.t&&(t.t[n]=null));null==t.t&&(t.t=Ke(re.hK,Pt,6,t.K,0,2)),t.t[n]=e,o&&(t.w[n]|=1),t.R=0,t.I=!0}else null!=t.t&&(t.t[n]=null)},ce.bl=function(t,n,e,o){t.u[n]=o?-e:e},ce.cl=function(t,n,e){e?t.s[n]|=Bt:t.s[n]&=-262145},ce.dl=function(t,n,e){t.v[n]=e,t.R&=7},ce.el=function(t,n,e,o){t.s[n]&=-8,t.s[n]|=e,o&&(t.s[n]|=4)},ce.fl=function(t,n,e,o){o?t.w[n]|=e:t.w[n]&=~e,t.R=0,t.I=!0},ce.gl=function(t,n,e){t.s[n]&=-49,t.s[n]|=e,t.R&=7},ce.hl=function(t,n,e){e?t.s[n]|=512:t.s[n]&=-513},ce.il=function(t,n,e){t.s[n]&=-134217729,e&&(t.s[n]|=Zt)},ce.jl=function(t,n,e){t.H[n].a=e,t.R&=7},ce.kl=function(t,n,e){t.H[n].b=e,t.R&=7},ce.ll=function(t,n,e){t.H[n].c=e,t.R&=7},ce.ml=function(t,n,e){e>=0&&e<=190&&(151==e||152==e?(t.A[n]=1,t.v[n]=e-149):(t.A[n]=e,t.v[n]=0),t.s[n]&=268435455,t.R=0)},ce.nl=function(t,n,e,o){t.B[n][e]=o,t.R=0},ce.ol=function(t,n,e){e?t.C[n]|=Ot:t.C[n]&=-131073},ce.pl=function(t,n,e){t.C[n]&=-49,t.C[n]|=e<<4},ce.ql=function(t,n,e,o){var r,i,a;if(0==e)t.C[n]&=-130049,t.C[n]|=e<<10;else{if(o>=32)return;if(-1==o){for(a=-1,i=0;i<t.o;i++)e==(t.s[i]&Rt)>>19&&a<((t.s[i]&Rt)>>19!=1&&(t.s[i]&Rt)>>19!=2?-1:(t.s[i]&Jt)>>21)&&(a=(t.s[i]&Rt)>>19!=1&&(t.s[i]&Rt)>>19!=2?-1:(t.s[i]&Jt)>>21);for(r=0;r<t.p;r++)r!=n&&e==(t.C[r]&Qt)>>10&&a<((t.C[r]&Qt)>>10!=1&&(t.C[r]&Qt)>>10!=2?-1:(t.C[r]&Xt)>>12)&&(a=(t.C[r]&Qt)>>10!=1&&(t.C[r]&Qt)>>10!=2?-1:(t.C[r]&Xt)>>12);if((o=a+1)>=32)return}t.C[n]&=-130049,t.C[n]|=e<<10|o<<12}t.R&=7},ce.rl=function(t,n,e){e?t.C[n]|=Bt:t.C[n]&=-262145},ce.sl=function(t,n,e){t.F[n]=1==e?1:2==e?2:3==e?4:32,t.R=0},ce.tl=function(t,n,e,o){t.C[n]&=-16777224,t.C[n]|=e,o&&(t.C[n]|=4)},ce.ul=function(t,n){t.C[n]|=Wt},ce.vl=function(t,n,e,o){o?t.D[n]|=e:t.D[n]&=~e,t.R=0,t.I=!0},ce.wl=function(t,n,e){t.F[n]=e,t.R=0},ce.xl=function(t,n){t.G=n},ce.yl=function(t,n){t.I!=n&&(t.I=n,n||ce.Ok(t),t.R=0)},ce.zl=function(t,n){t.R=n},ce.Al=function(t,n){t.Q=n},ce.Bl=function(t,n){var e,o;for(t.A=ce.Sl(t.A,n),t.q=ce.Sl(t.q,n),t.u=ce.Sl(t.u,n),o=t.H.length,t.H=ce.Tl(t.H,n),e=o;e<n;e++)t.H[e]=new ce.Ug;t.v=ce.Sl(t.v,n),t.s=ce.Sl(t.s,n),t.w=ce.Sl(t.w,n),null!=t.t&&(t.t=ce.Vl(t.t,n)),null!=t.r&&(t.r=ce.Ul(t.r,n)),t.K=n},ce.Cl=function(t,n){t.B[0]=ce.Sl(t.B[0],n),t.B[1]=ce.Sl(t.B[1],n),t.F=ce.Sl(t.F,n),t.C=ce.Sl(t.C,n),t.D=ce.Sl(t.D,n),t.L=n},ce.Dl=function(t,n){t.M=n},ce.El=function(t,n){t.N=n},ce.Fl=function(t,n){t.s[n]|=Ot},ce.Gl=function(t,n){var e,o;for(o=0,e=0;e<t.p;e++)(t.B[0][e]==n||t.B[1][e]==n)&&(o+=ce.Vj(t,e));return o},ce.Hl=function(t){var n,e,o;for(e=!1,o=!1,n=0;n<t.o;n++)0!=t.v[n]&&(t.v[n]=0,e=!0,1==t.A[n]&&(o=!0));return o&&(t.R=0),e},ce.Il=function(t,n,e){var o,r;return(r=t.A[n])>=3&&r<=4||r>=11&&r<=13||r>=19&&r<=31||r>=37&&r<=51||r>=55&&r<=84||r>=87&&r<=103||((o=t.A[e])>=3&&o<=4||o>=11&&o<=13||o>=19&&o<=31||o>=37&&o<=51||o>=55&&o<=84||o>=87&&o<=103)?32:1},ce.Jl=function(t,n,e){var o,r,i,a,s;for(a=t.A[n],t.A[n]=t.A[e],t.A[e]=a,a=t.q[n],t.q[n]=t.q[e],t.q[e]=a,a=t.v[n],t.v[n]=t.v[e],t.v[e]=a,a=t.s[n],t.s[n]=t.s[e],t.s[e]=a,a=t.w[n],t.w[n]=t.w[e],t.w[e]=a,a=t.u[n],t.u[n]=t.u[e],t.u[e]=a,i=t.H[n],t.H[n]=t.H[e],t.H[e]=i,null!=t.t&&(s=t.t[n],t.t[n]=t.t[e],t.t[e]=s),null!=t.r&&(s=t.r[n],t.r[n]=t.r[e],t.r[e]=s),o=0;o<t.p;o++)for(r=0;r<2;r++)t.B[r][o]==n?t.B[r][o]=e:t.B[r][o]==e&&(t.B[r][o]=n);t.R=0},ce.Kl=function(t,n,e){var o;o=t.B[0][n],t.B[0][n]=t.B[0][e],t.B[0][e]=o,o=t.B[1][n],t.B[1][n]=t.B[1][e],t.B[1][e]=o,o=t.F[n],t.F[n]=t.F[e],t.F[e]=o,o=t.C[n],t.C[n]=t.C[e],t.C[e]=o,o=t.D[n],t.D[n]=t.D[e],t.D[e]=o,t.R=0},ce.Ll=function(t,n,e){var o;for(o=0;o<t.o;o++)t.H[o].a+=n,t.H[o].b+=e;t.S+=n,t.T+=e},ce.Ml=function(t,n,e){var o,r;switch(r=103&e,o=ce.dk(t,n),r){case 1:case 64:return o>=1;case 2:return o>=2;case 4:return o>=3;case 32:return!0;default:return!1}},ce.Nl=function(n,e,o,r){var i,a,s;for(i=0;i<n.o;i++)r&&0==(512&n.s[i])||(s=n.P[i]*e,a=n.O[i]-o,n.H[i].a=n.S+s*t.Math.sin(a),n.H[i].b=n.T+s*t.Math.cos(a));r&&(n.R&=7)},ce.Ol=function(n,e,o){var r,i,a;for(n.S=e,n.T=o,n.O=Ke(re.fK,ut,5,n.o,15,1),n.P=Ke(re.fK,ut,5,n.o,15,1),r=0;r<n.o;r++)i=e-n.H[r].a,a=o-n.H[r].b,n.P[r]=t.Math.sqrt(i*i+a*a),n.O[r]=ce.Wl(e,o,n.H[r].a,n.H[r].b)},ce.Pl=function(){this.K=this.L=256,ce.gk(this)},ce.Ql=function(n,e){this.K=t.Math.max(1,n),this.L=t.Math.max(1,e),ce.gk(this)},ce.Sl=function(n,e){var o;return o=Ke(re.hK,L,5,e,15,1),ie.pS(n,0,o,0,t.Math.min(n.length,e)),o},ce.Tl=function(t,n){var e,o;for(e=Ke(re.yK,C,34,n,0,1),o=0;o<t.length;o++)t[o]&&(e[o]=new ce.Wg(t[o]));return e},ce.Ul=function(t,n){var e,o;for(e=Ke(re.dK,p,8,n,0,2),o=0;o<t.length;o++)null!=t[o]&&(e[o]=Ke(re.dK,U,5,t[o].length,15,1),ie.pS(t[o],0,e[o],0,t[o].length));return e},ce.Vl=function(t,n){var e,o;for(e=Ke(re.hK,Pt,6,n,0,2),o=0;o<t.length;o++)null!=t[o]&&(e[o]=Ke(re.hK,L,5,t[o].length,15,1),ie.pS(t[o],0,e[o],0,t[o].length));return e},ce.Wl=function(n,e,o,r){var i,a,s;return ce.Li(),a=o-n,0!=(s=r-e)?(i=t.Math.atan(a/s),s<0&&(a<0?i-=gt:i+=gt)):i=a>0?mt:xt,i},ce.Xl=function(t,n){var e;for(ce.Li(),e=t-n;e<nn;)e+=wt;for(;e>gt;)e-=wt;return e},ce.Yl=function(t){var n;for(ce.Li(),n=1;n<ce.Gi.length;n++)if(ie.HR(t,ce.Gi[n]))return n;return 0},ce.Zl=function(t){switch(ce.Li(),t){case 7:case 8:case 9:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:return!0}return!1},ce.$l=function(t){return ce.Li(),1!=t&&6!=t&&(!ce.Zl(t)&&(2!=t&&10!=t&&18!=t&&36!=t&&54!=t&&!(t>103)))},Te(62,1,{62:1,4:1}),a.pb=function(t){ce.fj(this,t)},a.o=0,a.p=0,a.G=0,a.I=!1,a.J=!1,a.K=0,a.L=0,a.M=0,a.Q=!1,a.R=0,a.S=0,a.T=0,ce.Ki=24,re.JK=vo(62),ce._l=function(t,n,e,o){var r,i,a,s,u,f,l,c,h;for(ce.Jr(n,1),null==o&&(o=Ke(re.hK,L,5,n.o,15,1)),s=ce.Pk(t,1),u=ce.Pk(t,2),h=Ke(re.DN,ft,5,n.o,16,1),(f=Ke(re.hK,L,5,n.o,15,1))[0]=e,h[e]=!0,o[e]=ce.bj(n,t,e,s,u),a=0,l=0;a<=l;){for(c=0;c<ce.mm(n,f[a]);c++)h[i=n.f[f[a]][c]]||(f[++l]=i,h[i]=!0,o[i]=ce.bj(n,t,i,s,u));++a}for(r=0;r<n.p;r++)h[n.B[0][r]]&&ce.cj(n,t,r,s,u,null==o?n.B[0][r]:o[n.B[0][r]],null==o?n.B[1][r]:o[n.B[1][r]],!1);ce.Pk(t,1),ce.Pk(t,2),t.R=0},ce.am=function(t){var n,e,o,r,i,a,s,u,f,l,c,h;for(t.g=Ke(re.hK,L,5,t.o,15,1),t.c=Ke(re.hK,L,5,t.o,15,1),t.f=Ke(re.hK,Pt,6,t.o,0,2),t.i=Ke(re.hK,Pt,6,t.o,0,2),t.j=Ke(re.hK,Pt,6,t.o,0,2),t.k=Ke(re.hK,L,5,t.d,15,1),f=Ke(re.hK,L,5,t.o,15,1),a=0;a<t.p;a++)++f[t.B[0][a]],++f[t.B[1][a]];for(o=0;o<t.o;o++)t.f[o]=Ke(re.hK,L,5,f[o],15,1),t.i[o]=Ke(re.hK,L,5,f[o],15,1),t.j[o]=Ke(re.hK,L,5,f[o],15,1);for(c=!1,s=0;s<t.e;s++)if(0!=(h=ce.Vj(t,s)))for(l=0;l<2;l++)e=t.B[l][s],n=t.c[e],t.j[e][n]=h,t.f[e][n]=t.B[1-l][s],t.i[e][n]=s,++t.c[e],++t.g[e],e<t.d&&(h>1?t.k[e]+=h-1:64==t.F[s]&&(t.k[e]=1));else c=!0;for(u=t.e;u<t.p;u++)if(0!=(h=ce.Vj(t,u)))for(l=0;l<2;l++)e=t.B[l][u],n=t.c[e],t.j[e][n]=h,t.f[e][n]=t.B[1-l][u],t.i[e][n]=u,++t.c[e],t.B[1-l][u]<t.d&&++t.g[e];else c=!0;if(c){for(n=Ke(re.hK,L,5,t.o,15,1),r=0;r<t.o;r++)n[r]=t.c[r];for(i=0;i<t.p;i++)if(0==(h=ce.Vj(t,i)))for(l=0;l<2;l++)e=t.B[l][i],t.j[e][n[e]]=h,t.f[e][n[e]]=t.B[1-l][i],t.i[e][n[e]]=i,++n[e]}},ce.bm=function(n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v;for(ce.Jr(n,1),o&&(e=!0),c=0;c<n.p;c++)if(1==(h=ce.Vj(n,c))||2==h){if(n.q[n.B[0][c]]>0&&n.q[n.B[1][c]]<0)a=n.B[0][c],s=n.B[1][c];else{if(!(n.q[n.B[0][c]]<0&&n.q[n.B[1][c]]>0))continue;a=n.B[1][c],s=n.B[0][c]}if((l=n.A[a])>=3&&l<=4||l>=11&&l<=13||l>=19&&l<=31||l>=37&&l<=51||l>=55&&l<=84||l>=87&&l<=103||((f=n.A[s])>=3&&f<=4||f>=11&&f<=13||f>=19&&f<=31||f>=37&&f<=51||f>=55&&f<=84||f>=87&&f<=103))continue;if(n.A[a]<9&&ce.Sm(n,a)>3||n.A[s]<9&&ce.Sm(n,s)>3)continue;y=n.F[c],n.q[a]-=1,n.q[s]+=1,n.F[c]=1==h?2:4,9!=y&&17!=y||(v=n.B[0][c],b=ce.Gn(n,v),n.B[0][b]!=v&&(n.B[1][b]=n.B[0][b],n.B[1][b]=v)),n.R=0}for(j=0,p=0,m=0,i=0;i<n.o;i++)j+=n.q[i],n.q[i]<0&&!ce.gn(n,i)&&(++p,ce.Zl(n.A[i])&&(m-=n.q[i]));if(!e&&0!=j)throw We(new ie.EG("molecule's overall charges are not balanced"));for(ce.Jr(n,1),N=0,H=o?j+m:m,u=0;u<n.o;u++)n.q[u]>0&&!ce.fn(n,u)&&ce.Zl(n.A[u])&&0!=(w=t.Math.min(ce.Nm(n,u),n.q[u]))&&H>=w&&(j-=w,N-=w,H-=w,n.q[u]-=w,n.R&=1);if((G=o?j:N)<0){for(d=Ke(re.hK,L,5,p,15,1),p=0,a=0;a<n.o;a++)n.q[a]<0&&!ce.gn(n,a)&&(d[p++]=(n.A[a]<<22)+a);for(le.V$(d).sort(le.V$(Ie(ue.pX.prototype.Ub,ue.pX,[]))),g=d.length-1;G<0&&g>=d.length-p;g--)r=d[g]&en,ce.Zl(n.A[r])&&(j+=w=t.Math.min(-G,-n.q[r]),G+=w,n.q[r]+=w,n.R&=1)}return j},ce.cm=function(t,n){var e,o,r,i;if(2!=t.k[n]||2!=t.g[n]||2!=t.j[n][0])for(r=0;r<t.c[n];r++)o=t.i[n][r],(17==t.F[o]||9==t.F[o])&&t.B[0][o]==n&&(t.F[o]=1);else for(i=0;i<2;i++)-1!=(e=ce.hm(t,n,t.f[n][i]))&&ce.cm(t,e)},ce.dm=function(t,n,e,o,r){var i,a,s,u,f;for(o&&ce.Jr(t,7),n.t=null,t.I&&ce.yl(n,!0),u=e.length,null==r&&(r=Ke(re.hK,L,5,u,15,1)),n.o=0,i=0;i<u;i++)r[i]=e[i]?ce.bj(t,n,i,0,0):-1;for(n.p=0,f=0;f<t.p;f++)a=t.B[0][f],s=t.B[1][f],a<u&&s<u&&(e[a]&&e[s]?ce.cj(t,n,f,0,0,null==r?t.B[0][f]:r[t.B[0][f]],null==r?t.B[1][f]:r[t.B[1][f]],o):0!=t.q[a]&&0!=t.q[s]&&t.q[a]<0^t.q[s]<0&&(e[a]&&(n.q[r[a]]+=t.q[a]<0?1:-1),e[s]&&(n.q[r[s]]+=t.q[s]<0?1:-1)));ce.fj(t,n),t.b&&(n.R=0),n.R=0,ce.Pk(n,1),ce.Pk(n,2),n.o!=u&&ce.yl(n,!0),o&&ce.$d(new ce.ie(n),null,!1)},ce.em=function(t,n,e,o,r){var i,a,s,u,f;for(o&&ce.Jr(t,7),n.t=null,t.I&&ce.yl(n,!0),null==r&&(r=Ke(re.hK,L,5,t.o,15,1)),n.o=0,i=0;i<t.o;i++)for(r[i]=-1,f=0;f<t.g[i];f++)if(e[t.i[i][f]]){r[i]=ce.bj(t,n,i,0,0);break}for(n.p=0,u=0;u<t.p;u++)e[u]?ce.cj(t,n,u,0,0,null==r?t.B[0][u]:r[t.B[0][u]],null==r?t.B[1][u]:r[t.B[1][u]],o):(a=t.B[0][u],s=t.B[1][u],-1==r[a]^-1==r[s]&&0!=t.q[a]&&0!=t.q[s]&&t.q[a]<0^t.q[s]<0&&(-1!=r[a]&&(n.q[r[a]]+=t.q[a]<0?1:-1),-1!=r[s]&&(n.q[r[s]]+=t.q[s]<0?1:-1)));return ce.fj(t,n),t.b&&(n.R=0),n.R=0,ce.Pk(n,1),ce.Pk(n,2),n.o!=t.o&&ce.yl(n,!0),o&&ce.$d(new ce.ie(n),null,!1),r},ce.fm=function(t,n){var e,o,r,i,a,s,u,f,l,c,h;if(0!=(n&~t.R)&&(0==(1&t.R)&&(ce.en(t),ce.am(t),t.R|=1,ce.Sn(t)&&(ce.en(t),ce.am(t))),0!=(n&~t.R))){if(0!=(-7&t.R)){for(o=0;o<t.d;o++)t.s[o]&=-31753;for(a=0;a<t.e;a++)t.C[a]&=-961;if(0==(4&n))return ce.km(t,1),void(t.R|=2);for(ce.km(t,7),i=0;i<t.e;i++)64==t.F[i]&&(t.s[t.B[0][i]]|=B,t.s[t.B[1][i]]|=B,t.C[i]|=256,t.C[i]|=512);for(r=0;r<t.d;r++)for(c=0;c<t.g[r];c++)if(f=t.i[r][c],0==(256&t.C[f]))for(u=t.f[r][c],h=0;h<t.g[u];h++)t.i[u][h]!=f&&t.j[u][h]>1&&(6==t.A[t.f[u][h]]?t.s[r]|=dt:!ce.mn(t,t.i[u][h])&&ce.uk(t,t.f[u][h])&&(t.s[r]|=$));for(;;){for(l=!1,e=0;e<t.d;e++)if(t.k[e]>0&&(20480&t.s[e])==$)for(c=0;c<t.g[e];c++)if(t.j[e][c]>1)for(u=t.f[e][c],f=t.i[e][c],h=0;h<t.g[u];h++)t.i[u][h]!=f&&(s=t.f[u][h],0==(t.s[s]&$)&&(t.s[s]|=$,l=!0));if(!l)break}}t.R|=6}},ce.gm=function(t,n){var e,o,r,i,a;if(e=-1,1==t.k[n])for(i=0;i<t.g[n];i++)if(2==t.j[n][i]){if(o=t.f[n][i],2==t.g[o]&&2==t.k[o])for(a=0;a<2;a++)if((r=t.f[o][a])!=n&&1==t.k[r]){e=o;break}break}return e},ce.hm=function(t,n,e){var o,r;for(o=n;2==t.g[e]&&2==t.k[e]&&e!=o;)r=e,e=t.f[e][0]==n?t.f[e][1]:t.f[e][0],n=r;return e==o?-1:e},ce.im=function(t,n){var e;if(3==t.g[n]&&0!=(t.s[n]&B)&&(t.n&&n<t.d?ce.Lp(t.n,n):0)>=6)for(e=0;e<t.g[n];e++)if(ce.nn(t,t.i[n][e]))return t.i[n][e];return-1},ce.jm=function(t,n,e,o,r){var i,a,s,u,f,l;if(ce.Jr(t,7),!(0==(t.s[n]&Qt)||e&&0==(t.s[n]&B)))for((u=Ke(re.hK,L,5,t.d,15,1))[0]=n,o[n]=!0,s=0,f=0;s<=f;){for(l=0;l<t.g[u[s]];l++)r[a=t.i[u[s]][l]]||0==(64&t.C[a])||e&&0==(256&t.C[a])||(r[a]=!0,o[i=t.f[u[s]][l]]||(o[i]=!0,u[++f]=i));++s}},ce.km=function(t,n){var e,o,r,i,a,s,u,f,l;for(t.n=new ce.aq(t,n),o=Ke(re.hK,L,5,t.d,15,1),r=0;r<t.e;r++)0!=ce.Np(t.n,r)&&(t.C[r]|=64,++o[t.B[0][r]],++o[t.B[1][r]]);for(e=0;e<t.d;e++)2==o[e]?t.s[e]|=Gt:3==o[e]?t.s[e]|=Ct:o[e]>3&&(t.s[e]|=Qt);for(a=0!=(5&n&-2),l=0;l<t.n.i.a.length;l++)for(s=ce.Pp(t.n,l),f=ce.Qp(t.n,l),u=s.length,i=0;i<u;i++)t.s[s[i]]|=8,t.C[f[i]]|=128,a&&(ce.Up(t.n,l)&&(t.s[s[i]]|=B,t.C[f[i]]|=256),ce.Xp(t.n,l)&&(t.C[f[i]]|=512)),26==t.F[f[i]]&&(t.F[f[i]]=2)},ce.lm=function(t){var n,e,o,r,i,a,s,u,f,l;for(f=Ke(re.DN,ft,5,t.o,16,1),e=0;e<t.o;e++)f[e]=1==t.A[e]&&0==t.v[e]&&0==t.q[e]&&(null==t.r||null==t.r[e]);for(l=Ke(re.DN,ft,5,t.o,16,1),u=0;u<t.p;u++)o=t.B[0][u],r=t.B[1][u],1==ce.Vj(t,u)?(l[o]&&(f[o]=!1),l[r]&&(f[r]=!1),f[o]&&((a=t.A[r])>=3&&a<=4||a>=11&&a<=13||a>=19&&a<=31||a>=37&&a<=51||a>=55&&a<=84||a>=87&&a<=103)&&(f[o]=!1),f[r]&&((i=t.A[o])>=3&&i<=4||i>=11&&i<=13||i>=19&&i<=31||i>=37&&i<=51||i>=55&&i<=84||i>=87&&i<=103)&&(f[r]=!1),l[o]=!0,l[r]=!0):(f[o]=!1,f[r]=!1);for(s=0;s<t.p;s++)f[t.B[0][s]]&&f[t.B[1][s]]&&(f[t.B[0][s]]=!1,f[t.B[1][s]]=!1);for(n=0;n<t.o;n++)l[n]||(f[n]=!1);return f},ce.mm=function(t,n){return t.c[n]},ce.nm=function(t,n){return t.f[n].length},ce.om=function(t,n){return t.c[n]-ce.Rm(t,n)+ce.Nm(t,n)},ce.pm=function(t){var n,e;for(ce.Jr(t,7),n=0,e=0;e<t.n.i.a.length;e++)ce.Up(t.n,e)&&++n;return n},ce.qm=function(t,n){return t.k[n]},ce.rm=function(t,n){return ce.Jr(t,7),2==t.k[n]&&2==t.g[n]?ce.En(t,n):ce.Gn(t,n)},ce.sm=function(t,n){var e;return 0==(e=t.s[n]&Qt)?0:e==Gt?2:e==Ct?3:4},ce.tm=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g;for(ce.Jr(t,7),i=Ke(re.DN,ft,5,t.e,16,1),c=Ke(re.DN,ft,5,t.e,16,1),g=Ke(re.hK,L,5,t.d,15,1),a=0,s=1;s<t.g[n];s++)if(o=t.i[n][s],0!=(64&t.C[o]))for(f=0;f<s;f++)if(r=t.i[n][f],0!=(64&t.C[r])&&(c[o]=!0,c[r]=!0,w=ce.Tm(t,g,t.f[n][s],t.f[n][f],e-2,c),c[o]=!1,c[r]=!1,-1!=w)){for(u=!1,h=Ke(re.hK,L,5,w,15,1),ce.Um(t,g,h,w),l=0;l<w;l++)i[h[l]]||(i[h[l]]=!0,u=!0);u&&++a}return a},ce.um=function(t,n){return t.n&&n<t.d?ce.Lp(t.n,n):0},ce.vm=function(t,n){return n?(ce.Jr(t,1),ce.Kj(t,t.d,t.e,ce.Ki)):ce.Kj(t,t.o,t.p,ce.Ki)},ce.wm=function(t){var n,e,o,r,i,a,s,u;for(ce.Jr(t,1),s=Ke(re.gK,Vt,5,t.d,15,1),o=Ke(re.hK,L,5,t.d,15,1),u=0;u<t.d;u++){for(o[0]=u,(r=Ke(re.hK,L,5,t.d,15,1))[u]=1,e=0,i=0;e<=i;){for(a=0;a<t.g[o[e]];a++)0==r[n=t.f[o[e]][a]]&&(r[n]=r[o[e]]+1,o[++i]=n,s[u]+=r[n]-1);++e}s[u]/=i}return s},ce.xm=function(t,n,e){var o;for(o=0;o<t.f[n].length;o++)if(t.f[n][o]==e)return t.i[n][o];return-1},ce.ym=function(t,n){return t.n&&n<t.e?ce.Np(t.n,n):0},ce.zm=function(t,n,e){return t.f[n][e]},ce.Am=function(t,n){return t.g[n]},ce.Bm=function(t,n,e){return t.i[n][e]},ce.Cm=function(t,n,e){return t.j[n][e]},ce.Dm=function(t,n){var e,o;for(e=0,o=0;o<t.g[n];o++)0!=(t.w[o]&lt)&&++e;return e},ce.Em=function(t,n){return t.c[n]-t.g[n]},ce.Fm=function(n,e,o,r,i){var a,s,u,f;if(s=n.c[e],0!=n.k[e]||0!=(n.s[e]&B)||n.g[e]<3||s>4)return!1;for(f=Ke(re.DN,ft,5,4,16,1),u=0;u<s;u++){if(a=3.9269908169872414-r[u],t.Math.abs(on-a%mt)>.0872664675116539)return!1;if(i[u]=3&ze(a/mt),f[i[u]])return!1;if(f[i[u]]=!0,0==(1&i[u])){if(1!=n.F[n.i[e][o[u]]])return!1}else if(!ce.Ek(n,n.i[e][o[u]],e))return!1}return f[0]&&f[2]},ce.Gm=function(n,e,o,r,i){var a,s,u,f,l,c;if(a=n.c[e],null==i&&(i=Ke(re.hK,L,5,a,15,1)),!ce.Fm(n,e,o,r,i))return 3;for(f=-1,l=0;l<a;l++)if(1==(1&i[l])){if(s=n.F[n.i[e][o[l]]],-1!=f&&f!=s)return 3;f=s}return u=i[c=2==t.Math.abs(i[0]-i[1])?1:0]-i[c+1],3==t.Math.abs(u)^i[c]<i[c+1]^(3==a||1==(1&i[3]))^9==f?1:2},ce.Hm=function(t,n,e){var o,r,i,a,s,u,f,l,c,h;for(ce.Jr(t,1),h=Ke(re.DN,ft,5,t.o,16,1),(f=Ke(re.hK,L,5,t.o,15,1))[0]=n,h[n]=!0,a=0,l=0,u=1;a<=l;){for(i=e?ce.nm(t,f[a]):t.c[f[a]],c=0;c<i;c++)h[r=t.f[f[a]][c]]||(f[++l]=r,h[r]=!0,++u);++a}for(s=Ke(re.hK,L,5,u,15,1),u=0,o=0;o<t.o;o++)h[o]&&(s[u++]=o);return s},ce.Im=function(t,n,e,o){var r,i,a,s,u,f,l,c,h;for(ce.Jr(t,1),i=0;i<t.o;i++)n[i]=-1;for(f=0,r=0;r<t.o;r++)if(-1==n[r]&&(!e||0!=(t.s[r]&Bt))){for(n[r]=f,(l=Ke(re.hK,L,5,t.o,15,1))[0]=r,u=0,c=0;u<=c;){for(s=o?ce.nm(t,l[u]):t.c[l[u]],h=0;h<s;h++)-1!=n[a=t.f[l[u]][h]]||e&&0==(t.s[a]&Bt)||(l[++c]=a,n[a]=f);++u}++f}return f},ce.Jm=function(t,n){var e;return(e=ce.ck(t,n))+ce.ak(t,n,e)-ce.Sm(t,n)},ce.Km=function(t,n){var e,o,r,i,a;for(i=Ke(re.hK,L,5,t.o,15,1),o=0;o<t.o;o++)i[o]=o;r=t.o;do{--r}while(r>=0&&n[r]);for(e=0;e<r;e++)if(n[i[e]]){a=i[e],i[e]=i[r],i[r]=a;do{--r}while(n[r])}return i},ce.Lm=function(t){return ce.Km(t,ce.lm(t))},ce.Mm=function(n,e,o){var r,i,a,s;if(i=ce.Sm(n,e),i-=ce.ak(n,e,i),o&&(i-=n.c[e]-n.g[e]),i<=(a=null==(s=n.A[e]<ce.Hi.length?ce.Hi[n.A[e]]:null)?6:s[0]))return-1;if(null!=s)for(r=1;a<i&&r<s.length;r++)a=s[r];return t.Math.max(a,i)},ce.Nm=function(n,e){var o,r,i,a,s,u;if(n.I&&0==(n.w[e]&Ct))return 0;if(!ce.Pn(n,e))return 0;for(ce.Jr(n,1),s=0,i=0;i<n.c[e];i++)s+=n.j[e][i];if(n.I){for(o=1,r=0;r<n.g[e];r++)64==n.F[n.i[e][r]]&&++o;s+=o>>1}if(s-=ce.ak(n,e,s),-1==(a=((n.s[e]&qt)>>>28)-1))if(n.A[e]>=171&&n.A[e]<=190)a=2;else if(null==(u=n.A[e]<ce.Hi.length?ce.Hi[n.A[e]]:null))a=6;else for(a=u[0],r=1;a<s&&r<u.length;r++)a=u[r];return t.Math.max(0,a-s)},ce.Om=function(t,n){var e,o,r,i,a;if(r=ce.Sm(t,n),e=ce.ak(t,n,r),-1==(i=((t.s[n]&qt)>>>28)-1))if(null==(a=t.A[n]<ce.Hi.length?ce.Hi[t.A[n]]:null))i=6;else{for(o=0;r>a[o]+e&&o<a.length-1;)++o;i=a[o]}return i+e-r},ce.Pm=function(t,n){return t.f[n].length-t.c[n]},ce.Qm=function(t){var n,e,o;for(ce.Jr(t,1),o=0,n=0;n<t.o;n++)o+=(0!=t.v[n]?t.v[n]:ce.Ji[t.A[n]])+ce.Nm(t,n)*ce.Ji[1],t.A[n]>=171&&t.A[n]<=190&&(e=t.c[n])>2&&(o-=(e-2)*ce.Ji[1]);return o},ce.Rm=function(t,n){var e,o;for(e=t.g[n],o=0;o<t.g[n];o++)1==t.A[t.f[n][o]]&&--e;return e},ce.Sm=function(t,n){var e,o;for(t.qb(1),o=0,e=0;e<t.c[n];e++)(!t.I||0==(t.w[t.f[n][e]]&lt))&&(o+=t.j[n][e]);return o},ce.Tm=function(t,n,e,o,r,i){var a,s,u,f,l,c,h,w,g;if(e==o)return n[0]=e,0;for(ce.Jr(t,1),f=Ke(re.hK,L,5,t.o,15,1),u=Ke(re.hK,L,5,t.o,15,1),g=Ke(re.hK,L,5,t.o,15,1),u[0]=e,f[e]=1,s=0,l=0;s<=l&&f[u[s]]<=r;){for(w=u[s],c=0;c<t.c[w];c++)if(null==i||i.length<=t.i[w][c]||!i[t.i[w][c]]){if((a=t.f[w][c])==o){for(n[h=f[w]]=a,n[--h]=w;h>0;)n[h-1]=g[n[h]],--h;return f[w]}0==f[a]&&(u[++l]=a,f[a]=f[w]+1,g[a]=w)}++s}return-1},ce.Um=function(t,n,e,o){var r,i;for(ce.Jr(t,1),r=0;r<o;r++)for(i=0;i<t.c[n[r]];i++)if(t.f[n[r]][i]==n[r+1]){e[r]=t.i[n[r]][i];break}},ce.Vm=function(t,n,e){var o,r,i,a,s,u;if(n==e)return 0;for(ce.Jr(t,1),a=Ke(re.hK,L,5,t.o,15,1),(i=Ke(re.hK,L,5,t.o,15,1))[0]=n,a[n]=1,r=0,s=0;r<=s;){for(u=0;u<t.c[i[r]];u++){if((o=t.f[i[r]][u])==e)return a[i[r]];0==a[o]&&(i[++s]=o,a[o]=a[i[r]]+1)}++r}return-1},ce.Wm=function(t,n,e,o,r){var i,a,s,u,f,l;if(n==e)return 0;for(ce.Jr(t,1),u=Ke(re.hK,L,5,t.o,15,1),(s=Ke(re.hK,L,5,t.o,15,1))[0]=n,u[n]=1,a=0,f=0;a<=f&&u[s[a]]<=o;){for(l=0;l<t.c[s[a]];l++){if((i=t.f[s[a]][l])==e)return u[s[a]];0==u[i]&&(null==r||r.length<=i||!r[i])&&(s[++f]=i,u[i]=u[s[a]]+1)}++a}return-1},ce.Xm=function(t,n){return t.c[n]-t.g[n]+ce.Nm(t,n)},ce.Ym=function(t){return ce.Jr(t,7),t.n},ce.Zm=function(t){var n,e,o,r,i,a,s,u,f;for(f=0,ce.Jr(t,7),o=0;o<t.e;o++)if(1==ce.Vj(t,o)&&0==(64&t.C[o])){for(s=!0,a=0;a<2;a++){if(n=t.B[a][o],1==t.g[n]){s=!1;break}if(7==t.A[n]&&0==(t.s[n]&B))for(e=t.B[1-a][o],u=0;u<t.g[e];u++)if(r=t.f[e][u],(i=t.i[e][u])!=o&&ce.Vj(t,i)>1&&0==(t.s[r]&B)&&ce.Zl(t.A[r])){s=!1;break}}s&&!ce.vn(t,o)&&++f}return f},ce.$m=function(t,n){var e,o,r,i;for(e=t.c[n],i=Ke(re.hK,L,5,e,15,1),r=0;r<e;r++)i[r]=(t.f[n][r]<<16)+r;for(le.V$(i).sort(le.V$(Ie(ue.pX.prototype.Ub,ue.pX,[]))),o=0;o<e;o++)i[o]&=V;return i},ce._m=function(t,n){var e,o;if(ce.Jr(t,1),2==t.g[n]&&2==t.j[n][0]&&2==t.j[n][1]){for(e=0;e<2;e++)for(o=0;o<t.c[t.f[n][e]];o++)if(ce.Ek(t,t.i[t.f[n][e]][o],t.f[n][e]))return t.i[t.f[n][e]][o]}else for(e=0;e<t.c[n];e++)if(ce.Ek(t,t.i[n][e],n))return t.i[n][e];return-1},ce.an=function(t,n,e){return 1!=ce.Vj(t,n)?0:16-t.c[e]+(1==t.A[e]?B:0)+(0==(24&t.F[n])||t.B[0][n]!=e?Ct:0)+(0==(3&t.s[e])?Gt:0)+(0!=(64&t.C[n])?0:512)+(6!=t.A[e]?256:0)},ce.bn=function(t,n,e,o,r,i){var a,s,u,f,l;for(ce.Jr(t,1),r&&(ce._i(r),r.I=!1),u=Ke(re.hK,L,5,t.o,15,1),null==o?o=Ke(re.DN,ft,5,t.o,16,1):ue.XW(o,o.length),u[0]=n,u[1]=e,o[n]=!0,o[e]=!0,s=1,f=1;s<=f;){for(l=0;l<t.c[u[s]];l++){if((a=t.f[u[s]][l])==n&&1!=s)return-1;o[a]||(o[a]=!0,u[++f]=a)}++s}return r&&(null==i&&(i=Ke(re.hK,L,5,o.length,15,1)),ce.dm(t,r,o,!1,i),ce.Yi(r,i[n],0,0,-1,0)),o[n]=!1,f},ce.cn=function(t,n,e){var o,r,i,a,s,u;for(ce.Jr(t,1),i=Ke(re.hK,L,5,t.d,15,1),u=Ke(re.DN,ft,5,t.d,16,1),i[0]=n,i[1]=e,u[n]=!0,u[e]=!0,r=1,a=1;r<=a;){for(s=0;s<t.g[i[r]];s++){if((o=t.f[i[r]][s])==n&&1!=r)return-1;u[o]||(u[o]=!0,i[++a]=o)}++r}return a},ce.dn=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w;if(2!=ce.Vj(t,e)&&0==(256&t.C[e]))return-1;if(1!=(w=3&t.C[e])&&2!=w)return-1;for(u=0;u<2;u++){for(o=t.B[u][e],r=t.B[1-u][e],h=-1,a=!1,l=0;l<t.g[o];l++)(i=t.f[o][l])!=r&&(i==n?a=!0:h=i);if(a){for(c=-1,s=-1,f=0;f<t.g[r];f++)(i=t.f[r][f])!=o&&(-1==c?c=i:i>c?s=i:(s=c,c=i));return 2==t.g[o]?2==t.g[r]?2==w?c:-1:2==w?c:s:2==t.g[r]?2==w^n<h?-1:c:2==w^n<h?s:c}}return-1},ce.en=function(t){var n,e,o,r,i,a,s,u,f,l,c;a=ce.lm(t),u=t.o;do{--u}while(u>=0&&a[u]);for(n=0;n<u;n++)if(a[n]){ce.Jl(t,n,u),l=a[n],a[n]=a[u],a[u]=l;do{--u}while(a[u])}if(t.d=u+1,t.o!=t.d){for(s=Ke(re.DN,ft,5,t.p,16,1),i=0;i<t.p;i++)e=t.B[0][i],o=t.B[1][i],(a[e]||a[o])&&(s[i]=!0);f=t.p;do{--f}while(f>=0&&s[f]);for(r=0;r<f;r++)if(s[r]){c=t.B[0][r],t.B[0][r]=t.B[0][f],t.B[0][f]=c,c=t.B[1][r],t.B[1][r]=t.B[1][f],t.B[1][f]=c,c=t.F[r],t.F[r]=t.F[f],t.F[f]=c,s[r]=!1;do{--f}while(s[f])}t.e=f+1}else t.e=t.p},ce.fn=function(t,n){var e;for(e=0;e<t.g[n];e++)if(t.q[t.f[n][e]]<0)return!0;return!1},ce.gn=function(t,n){var e;for(e=0;e<t.g[n];e++)if(t.q[t.f[n][e]]>0)return!0;return!1},ce.hn=function(t,n){var e;return 3==(e=t.A[n])||11==e||19==e||37==e||55==e},ce.jn=function(t,n){return 0!=(t.s[n]&dt)},ce.kn=function(t,n){var e,o,r,i,a,s;for(ce.Jr(t,1),a=0;a<2;a++)if(e=t.B[a][n],7==t.A[e])for(o=t.B[1-a][n],s=0;s<t.g[o];s++)if(r=t.f[o][s],i=t.i[o][s],(7==t.A[r]||8==t.A[r]||16==t.A[r])&&ce.Vj(t,i)>=2)return!0;return!1},ce.ln=function(t,n){return 0!=(t.s[n]&B)},ce.mn=function(t,n){return 0!=(256&t.C[n])},ce.nn=function(t,n){var e,o,r,i,a,s;if(1!=t.F[n]||0!=(256&t.C[n])||0!=(64&t.C[n])&&(t.n&&n<t.e?ce.Np(t.n,n):0)<7)return!1;if(e=t.B[0][n],0==(t.s[e]&B)||(t.n&&e<t.d?ce.Lp(t.n,e):0)<6)return!1;if(o=t.B[1][n],0==(t.s[o]&B)||(t.n&&o<t.d?ce.Lp(t.n,o):0)<6)return!1;for(s=0,a=0;a<t.g[e];a++)(r=t.f[e][a])!=o&&t.g[r]>2&&++s;for(i=0;i<t.g[o];i++)(r=t.f[o][i])!=e&&t.g[r]>2&&++s;return s>2},ce.on=function(t,n){return 2==t.k[n]&&2==t.g[n]&&2==t.j[n][0]&&2==t.j[n][1]&&t.A[n]<=7},ce.pn=function(t,n){var e;return 8==(e=t.A[n])||16==e||34==e||52==e},ce.qn=function(t,n){return 0!=(512&t.C[n])},ce.rn=function(t,n){var e;return 12==(e=t.A[n])||20==e||38==e||56==e},ce.sn=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w;if(7!=t.A[n])return!1;if(0!=(t.s[n]&B)||0!=t.k[n]||0!=(t.w[n]&St))return!0;if(1==t.q[n])return!1;for(i=0,s=0;s<t.g[n];s++)1==t.j[n][s]&&(8==(e=t.A[t.f[n][s]])||9==e||17==e)&&++i;if(0==i)for(a=0;a<t.g[n];a++)if(o=t.f[n][a],0!=t.k[o]){if(0!=(t.s[o]&B)){if((t.n&&o<t.d?ce.Lp(t.n,o):0)>=5){for(w=0,l=0;l<t.g[o];l++)(h=t.f[o][l])!=n&&ce.Rm(t,h)>=3&&++w;if(c=ce.Rm(t,n),2==w&&c>=2||1==w&&3==c)continue}return!0}for(f=0;f<t.g[o];f++)if(2==t.j[o][f]||ce.mn(t,t.i[o][f]))return!0}if(i<2)for(a=0;a<t.g[n];a++){for(o=t.f[n][a],u=!1,r=!1,f=0;f<t.g[o];f++)t.f[o][f]!=n&&(1!=t.j[o][f]&&(7==t.A[t.f[o][f]]||8==t.A[t.f[o][f]]||16==t.A[t.f[o][f]])&&(u=!0),1==t.j[o][f]&&7==t.A[t.f[o][f]]&&(r=!0));if(u&&(!r||0==i))return!0}return!1},ce.tn=function(t,n){var e;return 9==(e=t.A[n])||17==e||35==e||53==e},ce.un=function(t,n){var e;return 7==(e=t.A[n])||15==e||33==e},ce.vn=function(t,n){var e,o,r,i,a,s;if(1!=ce.Vj(t,n))return!1;for(i=0;i<2;i++){for(e=t.B[i][n],s=t.B[1-i][n];2==t.k[e]&&2==t.g[e]&&t.A[e]<10;)for(a=0;a<2;a++)if((o=t.f[e][a])!=s){if(1==t.g[o])return!0;if(r=t.i[e][a],1==ce.Vj(t,r)&&r<n)return!0;s=e,e=o;break}if(1==t.g[e])return!0}return!1},ce.wn=function(t,n){return 0!=(t.s[n]&Qt)},ce.xn=function(t,n){return 0!=(64&t.C[n])},ce.yn=function(t,n){return 1==t.A[n]&&0==t.v[n]&&0==t.q[n]&&(null==t.r||null==t.r[n])},ce.zn=function(t,n){return 0!=(8&t.s[n])},ce.An=function(t,n){return 0!=(128&t.C[n])},ce.Bn=function(t,n){return 0!=(t.s[n]&$)},ce.Cn=function(t){var n,e,o,r,i,a,s,u,f,l,c;for(ce.Jr(t,1),ce.Dn(t),f=!1,e=0;e<t.d;e++)if(7==t.A[e]&&0==t.q[e])if(4==(c=ce.Sm(t,e))){for(l=0;l<t.g[e];l++)if(s=t.f[e][l],1==t.j[e][l]&&8==t.A[s]&&1==t.g[s]&&0==t.q[s]){f=!0,++t.q[e],--t.q[s];break}}else if(5==c)for(l=0;l<t.g[e];l++){if(s=t.f[e][l],u=t.i[e][l],2==t.j[e][l]&&8==t.A[s]){f=!0,++t.q[e],--t.q[s],t.F[u]=1;break}if(3==t.j[e][l]&&7==t.A[s]){f=!0,++t.q[e],--t.q[s],t.F[u]=2;break}}for(a=!1,i=0;i<t.e;i++)for(l=0;l<2;l++)if(ce.uk(t,t.B[l][i])){n=t.B[1-l][i],3!=(r=t.A[n])&&11!=r&&19!=r&&37!=r&&55!=r&&(12!=(o=t.A[n])&&20!=o&&38!=o&&56!=o)||(1==ce.Vj(t,i)?(++t.q[n],--t.q[t.B[l][i]],t.F[i]=128,a=!0):32==t.F[i]&&(t.F[i]=128,a=!0));break}return a&&(ce.aj(t),f=!0),f&&(t.R=0),f},ce.Dn=function(t){var n;for(n=0;n<t.e;n++)if(64==t.F[n])return ce.$d(new ce.ie(t),null,!1);return!1},ce.En=function(t,n){var e,o,r,i,a,s,u,f;for(u=-1,o=0,a=0;a<2;a++)for(e=t.f[n][a],s=0;s<t.c[e];s++)(r=t.f[e][s])!=n&&(i=t.i[e][s],o<(f=ce.an(t,i,r))&&(o=f,u=i));return u},ce.Fn=function(t,n){var e,o,r,i,a,s,u,f;for(u=-1,o=0,a=0;a<2;a++)for(e=t.B[a][n],s=0;s<t.c[e];s++)(r=t.f[e][s])!=t.B[1-a][n]&&(i=t.i[e][s],o<(f=ce.an(t,i,r))&&(o=f,u=i));return u},ce.Gn=function(n,e){var o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G;for(o=n.c[e],r=Ke(re.fK,ut,5,o,15,1),w=0;w<o;w++)r[w]=ce.Mj(n,e,n.f[e][w]);for(g=1;g<o;g++)for(m=0;m<g;m++)if((i=t.Math.abs(ce.Xl(r[g],r[m])))<.08||i>rn){for(a=0,s=0,d=0;d<o;d++)d!=g&&d!=m&&(a+=t.Math.abs(pe.XF(r[g],r[d])),s+=t.Math.abs(pe.XF(r[m],r[d])));if(f=a<s?n.i[e][g]:n.i[e][m],1==ce.Vj(n,f))return f}for(p=-1,u=0,h=0;h<o;h++)l=n.f[e][h],c=n.i[e][h],u<(G=ce.an(n,c,l))&&(u=G,p=c);return p},ce.Hn=function(t,n){var e,o,r;for(ce.Jr(t,n?1:15),t.o=t.d,t.p=t.e,o=0;o<t.d;o++)t.c[o]!=t.g[o]&&(e=ce.Mm(t,o,!1),t.c[o]=t.g[o],-1!=e&&e!=ce.Mm(t,o,!0)&&(-1==(r=((t.s[o]&qt)>>>28)-1)||r<e)&&ce.Tk(t,o,e));n||ce.Nn(t),t.R=0},ce.In=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,H;if(2!=t.g[n]||2!=t.j[n][0]||2!=t.j[n][1]||t.g[t.f[n][0]]<2||t.g[t.f[n][1]]<2||1!=t.k[t.f[n][0]]||1!=t.k[t.f[n][1]])ce.el(t,n,0,!1);else{for(y=-1,b=-1,G=-1,m=-1,i=0,l=0;l<2;l++)for(o=t.f[n][l],g=0;g<t.c[o];g++)(a=t.f[o][g])!=n&&(s=t.i[o][g],i<(j=ce.an(t,s,a))&&(i=j,b=a,y=s,G=o,m=t.f[n][1-l]));if(-1!=b){for(c=0;c<2;c++)for(w=0;w<t.c[t.f[n][c]];w++)t.f[t.f[n][c]][w]!=n&&(t.F[t.i[t.f[n][c]][w]]=1);for(t.B[1][y]!=b&&(t.B[0][y]=t.B[1][y],t.B[1][y]=b),u=N,h=0;h<t.g[G];h++)(a=t.f[G][h])!=n&&u>a&&(u=a);for(d=Ke(re.hK,L,5,2,15,1),p=0,f=0;f<t.g[m];f++)(a=t.f[m][f])!=n&&(d[p++]=a);e=ce.Wl(t.H[n].a,t.H[n].b,t.H[m].a,t.H[m].b),r=0,2==p?(d[0]>d[1]&&(H=d[0],d[0]=d[1],d[1]=H),r=ce.Xl(e,ce.Mj(t,m,d[0]))-ce.Xl(e,ce.Mj(t,m,d[1]))):r=ce.Xl(e,ce.Mj(t,m,d[0])),r<0^1==(3&t.s[n])^u==b?t.F[y]=17:t.F[y]=9}}},ce.Jn=function(t,n,e,o){var r,i,a,s,u,f;if(r=t.c[n],s=Ke(re.hK,L,5,r,15,1),3==(f=ce.Gm(t,n,e,o,s)))return!1;for(a=(3&t.s[n])==f?17:9,u=0;u<r;u++)1==(1&s[u])&&(i=t.i[n][e[u]],t.F[i]=a,t.B[0][i]!=n&&(t.B[1][i]=t.B[0][i],t.B[0][i]=n));return!0},ce.Kn=function(t,n){t.R|=504&(8|n)},ce.Ln=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G;if(ce.cm(t,n),0!=(3&t.s[n])&&3!=(3&t.s[n]))if(2!=t.k[n]||2!=t.g[n])if(t.g[n]<3||t.g[n]>4)ce.el(t,n,0,!1);else{for(e=t.c[n],d=!1,s=0;s<e;s++)if(1==ce.Vj(t,t.i[n][s])){d=!0;break}if(d){for(p=ce.$m(t,n),o=Ke(re.fK,ut,5,e,15,1),u=0;u<e;u++)o[u]=ce.Mj(t,t.f[n][p[u]],n);for(f=0;f<e;f++)t.B[0][t.i[n][f]]==n&&1==ce.Vj(t,t.i[n][f])&&(t.F[t.i[n][f]]=1);if(!ce.Jn(t,n,p,o)){for(g=-1,l=0;l<e;l++)i=t.i[n][l],17!=t.F[i]&&9!=t.F[i]||t.B[0][i]!=n||(t.F[t.i[n][l]]=1,g=-1==g?i:-2);for(g<0&&(g=ce.Gn(t,n)),t.B[0][g]!=n&&(t.B[1][g]=t.B[0][g],t.B[0][g]=n),m=-1,c=0;c<e;c++)if(g==t.i[n][p[c]]){m=c;break}for(G=Oe($e(re.hK,2),Pt,6,0,[Oe($e(re.hK,1),L,5,15,[2,1,2,1]),Oe($e(re.hK,1),L,5,15,[1,2,2,1]),Oe($e(re.hK,1),L,5,15,[1,1,2,2]),Oe($e(re.hK,1),L,5,15,[2,1,1,2]),Oe($e(re.hK,1),L,5,15,[2,2,1,1]),Oe($e(re.hK,1),L,5,15,[1,2,1,2])]),a=1;a<e;a++)o[a]<o[0]&&(o[a]+=wt);if(3==e){switch(h=!1,m){case 0:h=o[1]<o[2]&&o[2]-o[1]<gt||o[1]>o[2]&&o[1]-o[2]>gt;break;case 1:h=o[2]-o[0]>gt;break;case 2:h=o[1]-o[0]<gt}r=1==(3&t.s[n])^h?17:9}else w=0,o[1]<=o[2]&&o[2]<=o[3]?w=0:o[1]<=o[3]&&o[3]<=o[2]?w=1:o[2]<=o[1]&&o[1]<=o[3]?w=2:o[2]<=o[3]&&o[3]<=o[1]?w=3:o[3]<=o[1]&&o[1]<=o[2]?w=4:o[3]<=o[2]&&o[2]<=o[1]&&(w=5),r=1==(3&t.s[n])^1==G[w][m]?9:17;t.F[g]=r}}}else ce.In(t,n)},ce.Mn=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j;if(0!=(3&t.C[n])&&3!=(3&t.C[n])&&ce.nn(t,n)){for(b=-1,p=-1,G=-1,d=-1,r=0,l=0;l<2;l++)for(o=t.B[l][n],w=0;w<t.c[o];w++)(s=t.i[o][w])!=n&&1==ce.Vj(t,s)&&(a=t.f[o][w],r<(y=ce.an(t,s,a))&&(r=y,p=a,b=s,G=o,d=t.B[1-l][n]));if(-1!=p){for(c=0;c<2;c++)for(w=0;w<t.c[t.B[c][n]];w++)(s=t.i[t.B[c][n]][w])!=n&&1==ce.Vj(t,s)&&(t.F[s]=1);for(t.B[1][b]!=p&&(t.B[0][b]=t.B[1][b],t.B[1][b]=p),u=N,h=0;h<t.g[G];h++)a=t.f[G][h],t.i[G][h]!=n&&u>a&&(u=a);for(g=Ke(re.hK,L,5,2,15,1),m=0,f=0;f<t.g[d];f++)t.i[d][f]!=n&&(g[m++]=t.f[d][f]);i=ce.Wl(t.H[G].a,t.H[G].b,t.H[d].a,t.H[d].b),e=0,2==m?(g[0]>g[1]&&(j=g[0],g[0]=g[1],g[1]=j),e=ce.Xl(i,ce.Mj(t,d,g[0]))-ce.Xl(i,ce.Mj(t,d,g[1]))):e=ce.Xl(i,ce.Mj(t,d,g[0])),e<0^2==(3&t.C[n])^u==p?t.F[b]=17:t.F[b]=9}}},ce.Nn=function(t){var n,e,o;for(ce.Jr(t,7),n=0;n<t.d;n++)ce.Ln(t,n);for(o=0;o<t.e;o++)ce.Mn(t,o);for(e=0;e<t.e;e++)2==t.F[e]&&3==(3&t.C[e])&&(t.F[e]=26)},ce.On=function(t,n){var e,o,r,i,a,s,u,f,l,c;if(s=Ke(re.hK,L,5,t.o,15,1),(a=ce.Im(t,s,!1,n))<=1)return null;for(u=Ke(re.hK,L,5,a,15,1),o=0;o<t.d;o++)++u[s[o]];for(l=0,c=u[0],f=1;f<a;f++)c<u[f]&&(c=u[f],l=f);for(e=0;e<t.o;e++)s[e]!=l&&(t.A[e]=-1);for(i=0;i<t.p;i++)(!n&&32==t.F[i]||s[t.B[0][i]]!=l)&&(t.F[i]=128);r=ce.aj(t),t.R=0;try{ce.bm(t,!0,!0)}catch(t){if(!Ue(t=Ze(t),13))throw We(t)}return r},ce.Pn=function(t,n){var e;return 0!=(t.s[n]&qt)||1!=t.A[n]&&(1==(e=t.A[n])||e>=5&&e<=9||e>=14&&e<=17||e>=32&&e<=35||e>=52&&e<=53||13==t.A[n]||t.A[n]>=171)},ce.Qn=function(t){var n,e,o,r,i,a,s,u,f,l;for(a=(i=ce.Kj(t,t.o,t.p,ce.Ki))*i/16,o=1;o<t.o;o++)for(r=0;r<o;r++)if((u=t.H[r].a-t.H[o].a)*u+(f=t.H[r].b-t.H[o].b)*f+(l=t.H[r].c-t.H[o].c)*l<a)throw We(new ie.EG("The distance between two atoms is too close."));for(ce.Jr(t,1),n=0,e=0;e<t.d;e++){if(ce.Sm(t,e)>(s=ce.ck(t,e))+ce.ak(t,e,s))throw We(new ie.EG("atom valence exceeded"));n+=t.q[e]}if(0!=n)throw We(new ie.EG("unbalanced atom charge"))},ce.Rn=function(t,n,e){var o;return(o=ce.Ml(t,n,e))&&26==e&&(ce.Jr(t,7),o&=0==(128&t.C[n])),o},ce.Sn=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w;if(!t.I)return!1;for(e=0;e<t.o;e++)(w=ce.ck(t,e))+ce.ak(t,e,w)-ce.Sm(t,e)<=0&&(0!=t.q[e]||5!=t.A[e]&&(7!=(r=t.A[e])&&15!=r&&33!=r)&&(8!=(o=t.A[e])&&16!=o&&34!=o&&52!=o))&&(t.w[e]&=-6145);for(a=!1,n=0;n<t.d;n++){if(s=t.c[n]-t.g[n],!t.Q&&s>0)for(0==(t.w[n]&Ct)&&(l=896==(t.w[n]&pt)?3:384==(t.w[n]&pt)?2:128==(128&t.w[n])?1:0,u=(w=ce.ck(t,n))+ce.ak(t,n,w)-ce.Sm(t,n),0==t.q[n]&&0==(t.w[n]&bt)&&6!=t.A[n]&&++u,(c=s)>3-l&&(c=3-l),c>u+s-l&&(c=u+s-l),c>0&&(h=0==l?0:(t.w[n]&pt)<<c,h|=(3==c?7:2==s?3:1)<<7,t.w[n]&=-1921,t.w[n]|=pt&h)),f=t.g[n];f<t.c[n];f++)i=t.i[n][f],1==t.F[i]&&(t.A[t.f[n][f]]=-1,t.F[i]=128,a=!0);0!=(2&t.w[n])&&(t.w[n]&=-9),0!=t.q[n]&&(t.s[n]&=-234881025)}return a&&ce.aj(t),a},ce.Tn=function(){ce.Pl.call(this)},ce.Un=function(t,n){ce.Ql.call(this,t,n)},ce.Vn=function(t){ce.Ql.call(this,t?t.K:256,t?t.L:256),t&&ce.ej(t,this)},Te(71,62,{71:1,62:1,4:1}),a.qb=function(t){ce.fm(this,t)},a.d=0,a.e=0,re.DK=vo(71),ce.Xn=function(n,e){return t.Math.pow(10,t.Math.log(2e3)*t.Math.LOG10E*n/(e-1)-1)},ce.Yn=function(t,n){var e,o;for(e=n,o=0;0!=n;)0==t.c&&(t.e=(63&t.b[++t.d])<<11,t.c=6),o|=(K&t.e)>>16-e+n,t.e<<=1,--n,--t.c;return o},ce.Zn=function(t,n,e){t.c=6,t.d=e,t.b=n,t.e=(63&n[t.d])<<11},ce.$n=function(t,n){var e,o,r;return(r=t>=(o=n/2|0))&&(t-=o),e=(n/32|0)*t/(o-t),r?-e:e},ce._n=function(t,n){var e;return null==n||0==le.V$(n).length?null:ce.bo(t,le.F$((e=n,le.A$(),e)),null)},ce.ao=function(t,n,e){var o;return null==n?null:ce.bo(t,le.F$((o=n,le.A$(),o)),null==e?null:le.F$(e))},ce.bo=function(t,n,e){var o,r,i,a,s;return null==n?null:(ce.Zn(t,n,0),o=ce.Yn(t,4),a=ce.Yn(t,4),o>8&&(o=a),r=ce.Yn(t,o),i=ce.Yn(t,a),s=new ce._r(r,i),ce.co(t,s,n,e,0),s)},ce.co=function(n,e,o,r,i){var a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,x,k,R,I,D,F,T,$,P,K,V,E,O,Y,q,J,Q,X,_,z,Z,W,tt,nt,et,ot,rt,it,at,st,ut,ct,ht,wt,gt,mt,pt,Gt,bt,yt,jt,Nt,Ht,vt,Mt,At,xt,kt,Rt,It,Dt,Ft,Tt,$t,Pt,Kt,Vt,Et,Ot,Yt,Ut,Lt,qt,Jt,Qt,Xt,_t,zt,Zt,Wt,tn,nn,en,on,rn,an,sn,un,fn,ln,cn,hn,wn,gn,mn,dn,pn,Gn,bn;if(ce._i(e),!(null==o||0>=o.length))if(n.f=e,wn=8,null!=r&&i>=r.length&&(r=null),ce.Zn(n,o,0),u=ce.Yn(n,4),v=ce.Yn(n,4),u>8&&(wn=u,u=v),0!=u){for(f=ce.Yn(n,u),l=ce.Yn(n,v),nn=ce.Yn(n,u),an=ce.Yn(n,u),rn=ce.Yn(n,u),F=ce.Yn(n,u),g=0;g<f;g++)ce.Ni(n.f,6);for(rt=0;rt<nn;rt++)ce.ml(n.f,ce.Yn(n,u),7);for(it=0;it<an;it++)ce.ml(n.f,ce.Yn(n,u),8);for(bt=0;bt<rn;bt++)ce.ml(n.f,ce.Yn(n,u),ce.Yn(n,8));for(It=0;It<F;It++)ce.Vk(n.f,ce.Yn(n,u),ce.Yn(n,4)-8);for(T=1+l-f,E=ce.Yn(n,4),H=0,ce.jl(n.f,0,0),ce.kl(n.f,0,0),ce.ll(n.f,0,0),hn=0,mn=0,pn=0,bn=0,P=!1,K=!1,(O=null!=r&&r[0]>=39)&&(r.length>2*f-2&&39==r[2*f-2]||r.length>3*f-3&&39==r[3*f-3]?(K=!0,N=86*(r[(qt=(P=r.length==3*f-3+9)?3*f-3:2*f-2)+1]-40)+r[qt+2]-40,hn=t.Math.pow(10,N/2e3-1),gn=86*(r[(qt+=2)+1]-40)+r[qt+2]-40,mn=t.Math.pow(10,gn/1500-1),dn=86*(r[(qt+=2)+1]-40)+r[qt+2]-40,pn=t.Math.pow(10,dn/1500-1),P&&(Gn=86*(r[(qt+=2)+1]-40)+r[qt+2]-40,bn=t.Math.pow(10,Gn/1500-1))):P=r.length==3*f-3),n.rb()&&P&&(r=null,O=!1),Vt=1;Vt<f;Vt++)0!=(Y=ce.Yn(n,E))?(H+=Y-1,O&&(ce.jl(n.f,Vt,ce.Fj(n.f,H)+r[2*Vt-2]-83),ce.kl(n.f,Vt,ce.Gj(n.f,H)+r[2*Vt-1]-83),P&&ce.ll(n.f,Vt,ce.Hj(n.f,H)+(r[2*f-3+Vt]-83))),ce.Pi(n.f,H,Vt,1)):(O&&(ce.jl(n.f,Vt,ce.Fj(n.f,0)+8*(r[2*Vt-2]-83)),ce.kl(n.f,Vt,ce.Gj(n.f,0)+8*(r[2*Vt-1]-83)),P&&ce.ll(n.f,Vt,ce.Hj(n.f,0)+8*(r[2*f-3+Vt]-83))),++T);for(Et=0;Et<T;Et++)ce.Pi(n.f,ce.Yn(n,u),ce.Yn(n,u),1);for(Jt=Ke(re.DN,ft,5,l,16,1),k=0;k<l;k++)switch(ce.Yn(n,2)){case 0:Jt[k]=!0;break;case 2:ce.wl(n.f,k,2);break;case 3:ce.wl(n.f,k,4)}for(s=ce.Yn(n,u),Ot=0;Ot<s;Ot++)if(w=ce.Yn(n,u),8==wn)3==(sn=ce.Yn(n,2))?(ce.$k(n.f,w,1,0),ce.el(n.f,w,1,!1)):ce.el(n.f,w,sn,!1);else switch(sn=ce.Yn(n,3)){case 4:ce.el(n.f,w,1,!1),ce.$k(n.f,w,1,ce.Yn(n,3));break;case 5:ce.el(n.f,w,2,!1),ce.$k(n.f,w,1,ce.Yn(n,3));break;case 6:ce.el(n.f,w,1,!1),ce.$k(n.f,w,2,ce.Yn(n,3));break;case 7:ce.el(n.f,w,2,!1),ce.$k(n.f,w,2,ce.Yn(n,3));break;default:ce.el(n.f,w,sn,!1)}for(8==wn&&0==ce.Yn(n,1)&&(n.f.J=!0),a=ce.Yn(n,v),Yt=0;Yt<a;Yt++)if(A=ce.Yn(n,v),1==ce.Yj(n.f,A))switch(sn=ce.Yn(n,3)){case 4:ce.tl(n.f,A,1,!1),ce.ql(n.f,A,1,ce.Yn(n,3));break;case 5:ce.tl(n.f,A,2,!1),ce.ql(n.f,A,1,ce.Yn(n,3));break;case 6:ce.tl(n.f,A,1,!1),ce.ql(n.f,A,2,ce.Yn(n,3));break;case 7:ce.tl(n.f,A,2,!1),ce.ql(n.f,A,2,ce.Yn(n,3));break;default:ce.tl(n.f,A,sn,!1)}else ce.tl(n.f,A,ce.Yn(n,2),!1);for(ce.yl(n.f,1==ce.Yn(n,1)),h=null,on=0;1==ce.Yn(n,1);)switch(on+ce.Yn(n,4)){case 0:for(en=ce.Yn(n,u),Ut=0;Ut<en;Ut++)w=ce.Yn(n,u),ce.fl(n.f,w,Ct,!0);break;case 1:for(en=ce.Yn(n,u),Lt=0;Lt<en;Lt++)w=ce.Yn(n,u),Wt=ce.Yn(n,8),ce.dl(n.f,w,Wt);break;case 2:for(en=ce.Yn(n,v),at=0;at<en;at++)ce.Yn(n,v);break;case 3:for(en=ce.Yn(n,u),st=0;st<en;st++)w=ce.Yn(n,u),ce.fl(n.f,w,B,!0);break;case 4:for(en=ce.Yn(n,u),ut=0;ut<en;ut++)w=ce.Yn(n,u),cn=ce.Yn(n,4)<<3,ce.fl(n.f,w,cn,!0);break;case 5:for(en=ce.Yn(n,u),ct=0;ct<en;ct++)w=ce.Yn(n,u),c=ce.Yn(n,2)<<1,ce.fl(n.f,w,c,!0);break;case 6:for(en=ce.Yn(n,u),ht=0;ht<en;ht++)w=ce.Yn(n,u),ce.fl(n.f,w,1,!0);break;case 7:for(en=ce.Yn(n,u),wt=0;wt<en;wt++)w=ce.Yn(n,u),nt=ce.Yn(n,4)<<7,ce.fl(n.f,w,nt,!0);break;case 8:for(en=ce.Yn(n,u),gt=0;gt<en;gt++){for(w=ce.Yn(n,u),b=ce.Yn(n,4),p=Ke(re.hK,L,5,b,15,1),Qt=0;Qt<b;Qt++)G=ce.Yn(n,8),p[Qt]=G;ce._k(n.f,w,p)}break;case 9:for(en=ce.Yn(n,v),mt=0;mt<en;mt++)A=ce.Yn(n,v),cn=ce.Yn(n,2)<<5,ce.vl(n.f,A,cn,!0);break;case 10:for(en=ce.Yn(n,v),pt=0;pt<en;pt++)A=ce.Yn(n,v),R=ce.Yn(n,5),ce.vl(n.f,A,R,!0);break;case 11:for(en=ce.Yn(n,u),Gt=0;Gt<en;Gt++)w=ce.Yn(n,u),ce.fl(n.f,w,dt,!0);break;case 12:for(en=ce.Yn(n,v),yt=0;yt<en;yt++)A=ce.Yn(n,v),I=ce.Yn(n,8)<<7,ce.vl(n.f,A,I,!0);break;case 13:for(en=ce.Yn(n,u),jt=0;jt<en;jt++)w=ce.Yn(n,u),un=ce.Yn(n,3)<<14,ce.fl(n.f,w,un,!0);break;case 14:for(en=ce.Yn(n,u),Nt=0;Nt<en;Nt++)w=ce.Yn(n,u),tn=ce.Yn(n,5)<<17,ce.fl(n.f,w,tn,!0);break;case 15:on=16;break;case 16:for(en=ce.Yn(n,u),Ht=0;Ht<en;Ht++)w=ce.Yn(n,u),ln=ce.Yn(n,3)<<22,ce.fl(n.f,w,ln,!0);break;case 17:for(en=ce.Yn(n,u),vt=0;vt<en;vt++)w=ce.Yn(n,u),ce.Tk(n.f,w,ce.Yn(n,4));break;case 18:for(en=ce.Yn(n,u),Zt=ce.Yn(n,4),Mt=0;Mt<en;Mt++){for(w=ce.Yn(n,u),V=ce.Yn(n,Zt),Xt=Ke(re.dK,U,5,V,15,1),Qt=0;Qt<V;Qt++)Xt[Qt]=ce.Yn(n,7)<<24>>24;ce.Yk(n.f,w,ie.XR(le.D$(Xt,0,(_t=Xt.length,le.A$(),_t))))}break;case 19:for(en=ce.Yn(n,u),At=0;At<en;At++)w=ce.Yn(n,u),D=ce.Yn(n,3)<<25,ce.fl(n.f,w,D,!0);break;case 20:for(en=ce.Yn(n,v),xt=0;xt<en;xt++)A=ce.Yn(n,v),ln=ce.Yn(n,3)<<15,ce.vl(n.f,A,ln,!0);break;case 21:for(en=ce.Yn(n,u),kt=0;kt<en;kt++)w=ce.Yn(n,u),ce.gl(n.f,w,ce.Yn(n,2)<<4);break;case 22:for(en=ce.Yn(n,u),Rt=0;Rt<en;Rt++)w=ce.Yn(n,u),ce.fl(n.f,w,St,!0);break;case 23:for(en=ce.Yn(n,v),Dt=0;Dt<en;Dt++)A=ce.Yn(n,v),ce.vl(n.f,A,Bt,!0);break;case 24:for(en=ce.Yn(n,v),Ft=0;Ft<en;Ft++)A=ce.Yn(n,v),c=ce.Yn(n,2)<<19,ce.vl(n.f,A,c,!0);break;case 25:for(Tt=0;Tt<f;Tt++)1==ce.Yn(n,1)&&ce.hl(n.f,Tt,!0);break;case 26:for(en=ce.Yn(n,v),h=Ke(re.hK,L,5,en,15,1),$t=0;$t<en;$t++)h[$t]=ce.Yn(n,v);break;case 27:for(en=ce.Yn(n,u),Pt=0;Pt<en;Pt++)w=ce.Yn(n,u),ce.fl(n.f,w,lt,!0);break;case 28:for(en=ce.Yn(n,v),Kt=0;Kt<en;Kt++)ce.wl(n.f,ce.Yn(n,v),32);break;case 29:for(en=ce.Yn(n,u),ot=0;ot<en;ot++)w=ce.Yn(n,u),tt=ce.Yn(n,2)<<30,ce.fl(n.f,w,tt,!0)}if(ce.$d(new ce.ie(n.f),Jt,!1),null!=h)for(C=0,x=(S=h).length;C<x;++C)A=S[C],ce.wl(n.f,A,2==ce.Yj(n.f,A)?4:2);if(null==r&&!n.g&&o.length>n.d+1&&(32==o[n.d+1]||9==o[n.d+1])&&(r=o,i=n.d+2),null!=r)try{if(33==r[i]||35==r[i]){for(ce.Zn(n,r,i+1),P=1==ce.Yn(n,1),K=1==ce.Yn(n,1),M=1<<(fn=2*ce.Yn(n,4)),Z=0,A=0,m=1;m<f;m++)A<l&&ce.Nj(n.f,1,A)==m?(Z=ce.Nj(n.f,0,A++),z=1):(Z=0,z=8),ce.jl(n.f,m,ce.Fj(n.f,Z)+z*(ce.Yn(n,fn)-(M/2|0))),ce.kl(n.f,m,ce.Gj(n.f,Z)+z*(ce.Yn(n,fn)-(M/2|0))),P&&ce.ll(n.f,m,ce.Hj(n.f,Z)+z*(ce.Yn(n,fn)-(M/2|0)));if(35==r[i]){for(et=0,W=Ke(re.hK,L,5,f,15,1),d=0;d<f;d++)et+=W[d]=ce.Nm(n.f,d);for(w=0;w<f;w++)for(ot=0;ot<W[w];ot++)nt=ce.Ni(n.f,1),ce.Pi(n.f,w,nt,1),ce.jl(n.f,nt,ce.Fj(n.f,w)+(ce.Yn(n,fn)-(M/2|0))),ce.kl(n.f,nt,ce.Gj(n.f,w)+(ce.Yn(n,fn)-(M/2|0))),P&&ce.ll(n.f,nt,ce.Hj(n.f,w)+(ce.Yn(n,fn)-(M/2|0)));f+=et,l+=et}if(j=P?1.5:(ce.Li(),ce.Li(),ce.Ki),y=ce.Kj(n.f,f,l,j),K)for(mn=(hn=ce.Xn(ce.Yn(n,fn),M))*ce.$n(ce.Yn(n,fn),M),pn=hn*ce.$n(ce.Yn(n,fn),M),P&&(bn=hn*ce.$n(ce.Yn(n,fn),M)),z=hn/y,w=0;w<f;w++)ce.jl(n.f,w,mn+z*ce.Fj(n.f,w)),ce.kl(n.f,w,pn+z*ce.Gj(n.f,w)),P&&ce.ll(n.f,w,bn+z*ce.Hj(n.f,w));else for(z=(hn=1.5)/y,w=0;w<f;w++)ce.jl(n.f,w,z*ce.Fj(n.f,w)),ce.kl(n.f,w,z*ce.Gj(n.f,w)),P&&ce.ll(n.f,w,z*ce.Hj(n.f,w))}else if(P&&!K&&0==hn&&(hn=1.5),0!=hn&&0!=n.f.p){for(y=0,A=0;A<n.f.p;A++)q=ce.Fj(n.f,ce.Nj(n.f,0,A))-ce.Fj(n.f,ce.Nj(n.f,1,A)),J=ce.Gj(n.f,ce.Nj(n.f,0,A))-ce.Gj(n.f,ce.Nj(n.f,1,A)),Q=P?ce.Hj(n.f,ce.Nj(n.f,0,A))-ce.Hj(n.f,ce.Nj(n.f,1,A)):0,y+=t.Math.sqrt(q*q+J*J+Q*Q);for(_=hn/(y/=n.f.p),w=0;w<n.f.o;w++)ce.jl(n.f,w,ce.Fj(n.f,w)*_+mn),ce.kl(n.f,w,ce.Gj(n.f,w)*_+pn),P&&ce.ll(n.f,w,ce.Hj(n.f,w)*_+bn)}}catch(t){if(!Ue(t=Ze(t),13))throw We(t);X=t,ie.mG(X,(ie.oS(),ie.nS),""),ie.qG(X,X.Cb()),ie.XR(le.D$(o,0,(zt=o.length,le.A$(),zt))),ie.XR(le.D$(r,0,_t=r.length)),r=null,P=!1}if(($=null!=r&&!P)||n.rb())for(ce.Jr(n.f,7),A=0;A<n.f.e;A++)2==ce.Vj(n.f,A)&&!ce.An(n.f,A)&&0==ce.Wj(n.f,A)&&ce.ul(n.f,A);if(!$&&n.rb()){ce.Kn(n.f,0);try{n.sb(n.f),$=!0}catch(t){if(!Ue(t=Ze(t),13))throw We(t);X=t,ie.mG(X,(ie.oS(),ie.nS),""),ie.qG(X,X.Cb()),ie.XR(le.D$(o,0,(_t=o.length,le.A$(),_t)))}}$?(ce.Nn(n.f),ce.Wr(n.f)):P||ce.Kn(n.f,0)}else ce.yl(n.f,1==ce.Yn(n,1))},ce.eo=function(t,n){var e,o,r,i,a,s;if(!(n.length<=0||n[0]<64))for(ce.Zn(t,n,0),s=ce.Yn(t,4),r=1==ce.Yn(t,1),i=1==ce.Yn(t,1),e=0;e<t.f.d;e++)a=ce.Yn(t,s),o=r,r&&i&&(o=1==ce.Yn(t,1)),ce.bl(t.f,e,a,o)},ce.fo=function(){},Te(162,1,{},ce.fo),a.rb=function(){return!1},a.sb=function(t){throw We(new ie.EG("Unexpected request to invent coordinates. Check source code logic!"))},a.c=0,a.d=0,a.e=0,a.g=!1,re.EK=vo(162),ce.io=function(t){this.a=t},Te(52,162,{},ce.io),a.rb=function(){return this.a},a.sb=function(t){var n;(n=new we.pt).f=new ue.OX(78187493520),we.$s(n,t)},a.a=!1,re.FK=vo(52),ce.lo=function(n,e,o){var r,i,a,s,u,f,l,c,h,w;r=e.a,l=e.e,u=ce.xj(n.n,r),ce.ln(n.n,r)&&(u=le.V$(u).toLowerCase()),e.d&&(o.a+="("),-1!=l&&ce.po(n,e,o),i=ce.rj(n.n,r),s=ce.Bj(n.n,r),f=n.j?ce.Aj(n.n,r):0,(w=!ce.Co(ce.Ij(n.n,r))||(1==ce.Cj(n.n,r)||2==ce.Cj(n.n,r))&&!(-1!=(h=ce.wj(n.n,r)-1)&&n.k[h][ce.vj(n.n,r)]<=1)&&(7!=ce.Ij(n.n,r)||ce.rj(n.n,r)>0)||0!=i||0!=s||0!=f||-1!=ce.pj(n.n,r)||ce.ln(n.n,r)&&0==ce.qm(n.n,r)&&0!=ce.Nm(n.n,r))&&(o.a+="["),0!=s&&(o.a+=s),o.a+=""+u,(1==ce.Cj(n.n,r)||2==ce.Cj(n.n,r))&&!(-1!=(c=ce.wj(n.n,r)-1)&&n.k[c][ce.vj(n.n,r)]<=1)&&(7!=ce.Ij(n.n,r)||ce.rj(n.n,r)>0)&&ie.gS(o,ce.wo(n,r,l)),w&&0!=(a=ce.Nm(n.n,r))&&(o.a+="H",a>1&&(o.a+=a)),0!=i&&(o.a+=String.fromCharCode(i>0?43:45),t.Math.abs(i)>1&&ie.eS(o,t.Math.abs(i))),0!=f&&(o.a+=":",o.a+=f),w&&(o.a+="]"),ce.qo(n,e,o),e.c&&(o.a+=")")},ce.mo=function(t,n,e){var o,r,i,a;for(r=!0,a=ue.Th(t.i,n).a,i=ce.zo(t,a);-1!=i;)o=ce.zm(t.n,a,i),ce.Bm(t.n,a,i),i=ce.zo(t,o),ce.no(t,new ce.jr(o,a,e&&r,e&&-1==i),++n),a=o,r=!1},ce.no=function(t,n,e){ue.Nh(t.i,e,n),t.b[n.a]=!0,-1!=n.e&&(t.c[ce.xm(t.n,n.a,n.e)]=!0)},ce.oo=function(t,n,e){var o;ce.mn(t.n,n)||(1==(o=103&ce.Yj(t.n,n))?ce.ln(t.n,ce.Nj(t.n,0,n))&&ce.ln(t.n,ce.Nj(t.n,1,n))&&(e.a+="-"):2==o?e.a+="=":4==o&&(e.a+="#"))},ce.po=function(t,n,e){0==n.b?ce.oo(t,ce.xm(t.n,n.a,n.e),e):ie.cS(e,1==n.b?47:92)},ce.qo=function(t,n,e){var o,r,i,a,s,u;for(r=0,s=0;s<ce.Am(t.n,n.a);s++)o=ce.Bm(t.n,n.a,s),0!=t.f[o]&&(u=t.g[o]?0:an,t.e[r++]=u|t.f[o]<<20|o);if(0!=r)for(ue.cX(t.e,r),a=0;a<r;a++)o=262143&t.e[a],i=(1073479680&t.e[a])>>20,t.g[o]||(t.g[o]=!0,ce.oo(t,o,e)),i>9&&(e.a+="%"),e.a+=i},ce.ro=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w,g,m;for(s=new ue.KW(t.i);s.a<s.c.a.length;)if(-1!=(a=ue.JW(s)).e&&(n=ce.xm(t.n,a.a,a.e),!(ce.nn(t.n,n)||ce.An(t.n,n)||1!=ce.Wj(t.n,n)&&2!=ce.Wj(t.n,n)))){if(0==(l=(m=ue.Th(t.i,t.r[a.e])).b)&&(l=m.b=1),f=l,3==ce.Am(t.n,m.a))for(w=0;w<ce.Am(t.n,m.a);w++)if((i=ce.zm(t.n,m.a,w))!=m.e&&i!=a.a){(e=ue.Th(t.i,t.r[i])).e==m.a&&(e.b=l),i<m.e&&(f=3-f);break}for(2==ce.Wj(t.n,n)&&(f=3-f),h=0;h<ce.Am(t.n,a.a);h++)if((o=ce.zm(t.n,a.a,h))!=a.e){if(c=f,3==ce.Am(t.n,a.a))for(g=0;g<ce.Am(t.n,a.a);g++)if((i=ce.zm(t.n,a.a,g))!=a.e&&i!=o){i<o&&(c=3-c);break}ce.sk(t.n,n)&&(u=ce.qf(t.d,n),t.o[u]||(t.o[u]=!0,t.p[u]=2==c),t.p[u]&&(c=3-c)),(r=ue.Th(t.i,t.r[o])).e==a.a&&(r.b=c)}}},ce.so=function(t){var n,e,o,r,i,a,s;if(!t.n||0==t.n.o)return"";for(ce.Jr(t.n,15),t.d=new ce.Lf(t.n,129),e=t.d.P,t.p=Ke(re.DN,ft,5,e+1,16,1),t.o=Ke(re.DN,ft,5,e+1,16,1),t.k=Pe(re.hK,[Pt,L],[6,5],15,[2,32],2),n=0;n<t.n.d;n++)-1!=(s=ce.wj(t.n,n)-1)&&++t.k[s][ce.vj(t.n,n)];for(ce.vo(t),ce.to(t),ce.ro(t),r=new ie.jS,o=!0,a=new ue.KW(t.i);a.a<a.c.a.length;)-1==(i=ue.JW(a)).e&&(o?o=!1:r.a+="."),ce.lo(t,i,r);return r.a},ce.to=function(t){var n,e,o,r,i,a,s,u;for(r=Ke(re.DN,ft,5,t.n.e,16,1),t.f=Ke(re.hK,L,5,t.n.e,15,1),u=new ue.KW(t.i);u.a<u.c.a.length;){for(s=ue.JW(u),i=0;i<ce.Am(t.n,s.a);i++)n=ce.Bm(t.n,s.a,i),r[t.f[n]]=!1;for(a=ce.Ao(t,s.a);-1!=a;){for(e=ce.Bm(t.n,s.a,a),t.c[e]=!0,o=1;r[o];)++o;t.f[e]=o,r[o]=!0,a=ce.Ao(t,s.a)}}t.g=Ke(re.DN,ft,5,t.n.e,16,1),t.e=Ke(re.hK,L,5,8,15,1)},ce.uo=function(t){var n,e,o,r;for(o=-1,r=N,n=0;n<t.n.d;n++)t.b[n]||r>(e=((0==ce.Am(t.n,n)?127:ce.Am(t.n,n))<<24)+t.a[n])&&(r=e,o=n);return o},ce.vo=function(t){var n,e,o,r,i;for(t.a=t.d.c,t.b=Ke(re.DN,ft,5,t.n.d,16,1),t.c=Ke(re.DN,ft,5,t.n.e,16,1),t.i=new ue.gi,n=ce.uo(t);-1!=n;){if(e=t.i.a.length,ce.no(t,new ce.jr(n,-1,!1,!1),e),0!=ce.Am(t.n,n))for(ce.mo(t,e,!1);e<t.i.a.length-1;){for(;ce.Bo(t,ue.Th(t.i,e).a);)ce.mo(t,e,!0);++e}n=ce.uo(t)}for(t.r=Ke(re.hK,L,5,t.n.d,15,1),o=0,i=new ue.KW(t.i);i.a<i.c.a.length;)r=ue.JW(i),t.r[r.a]=o++},ce.wo=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g;if(u=!1,0!=ce.qm(t.n,n)&&2==ce.Am(t.n,n)&&2==ce.Cm(t.n,n,0)&&2==ce.Cm(t.n,n,1))for(i=0;i<ce.Am(t.n,n);i++){for(o=ce.zm(t.n,n,i),g=0,w=Ke(re.hK,L,5,3,15,1),l=0;l<ce.Am(t.n,o);l++)w[g]=ce.zm(t.n,o,l),w[g]!=n&&++g;2==g&&t.r[w[0]]<t.r[w[1]]^w[0]<w[1]&&(u=!u)}else{for(c=Ke(re.hK,L,5,3,15,1),h=Ke(re.hK,L,5,3,15,1),s=0,a=0;a<ce.Am(t.n,n);a++)(o=ce.zm(t.n,n,a))!=e&&(c[s]=o,h[s++]=ce.yo(t,n,a));for(2==s&&(0==ce.Nm(t.n,n)?c[s]=n:c[s]=N,h[s++]=8*t.r[n]),h[0]>h[1]&&(u=!u),h[0]>h[2]&&(u=!u),h[1]>h[2]&&(u=!u),c[0]>c[1]&&(u=!u),c[0]>c[2]&&(u=!u),c[1]>c[2]&&(u=!u),i=0;i<3;i++)e>c[i]&&(u=!u)}return f=1==ce.Cj(t.n,n)^u,ce.lk(t.n,n)&&(r=ce.rf(t.d,n),t.o[r]||(t.o[r]=!0,t.p[r]=f),t.p[r]&&(f=!f)),f?"@@":"@"},ce.xo=function(t){return null==t.q&&(t.q=ce.so(t)),t.q},ce.yo=function(t,n,e){var o,r,i;if(o=ce.Bm(t.n,n,e),0!=t.f[o]){for(i=8*t.r[n]+1,r=0;r<e;r++)0!=t.f[ce.zm(t.n,n,r)]&&++i;return i}return 8*t.r[ce.zm(t.n,n,e)]},ce.zo=function(t,n){var e,o,r,i,a;for(e=-1,o=-1,i=0;i<ce.Am(t.n,n);i++)r=ce.zm(t.n,n,i),a=(ce.Cm(t.n,n,i)<<24)+t.a[r],!t.b[r]&&(-1==e||o<a)&&(e=i,o=a);return e},ce.Ao=function(t,n){var e,o;for(e=-1,o=0;o<ce.Am(t.n,n);o++)!t.c[ce.Bm(t.n,n,o)]&&(-1==e||t.a[ce.zm(t.n,n,e)]<t.a[ce.zm(t.n,n,o)])&&(e=o);return e},ce.Bo=function(t,n){var e;for(e=0;e<ce.Am(t.n,n);e++)if(!t.b[ce.zm(t.n,n,e)])return!0;return!1},ce.Co=function(t){return t>=5&&t<=9||t>=15&&t<=17||35==t||53==t},ce.Do=function(t){ce.Eo.call(this,t,!1)},ce.Eo=function(t,n){this.n=t,this.j=n},ce.Fo=function(t){var n,e,o,r;for(r=new ie.jS,e=0;e<t.g.a.length;e++)0!=e&&(r.a+="."),ie.gS(r,ce.xo(new ce.Eo(ue.Th(t.g,e),!0)));for(r.a+=">",o=0;o<t.a.a.length;o++)0!=o&&(r.a+="."),ie.gS(r,ce.xo(new ce.Do(ue.Th(t.a,o))));for(r.a+=">",n=0;n<t.f.a.length;n++)0!=n&&(r.a+="."),ie.gS(r,ce.xo(new ce.Eo(ue.Th(t.f,n),!0)));return r.a},Te(69,1,{},ce.Do,ce.Eo),a.j=!1,re.GK=vo(69),ce.Go=function(t,n){this.b=t,this.a=n},Te(3,1,{3:1},ce.Go),a.a=0,a.b=0,re.HK=vo(3),ce.Io=function(){ce.Io=De,ce.Ho=Oe($e(re.HK,2),p,9,0,[null,Oe($e(re.HK,1),sn,3,0,[new ce.Go(0,1.007825032),new ce.Go(1,2.014101778),new ce.Go(2,3.016049268),new ce.Go(3,4.027834627),new ce.Go(4,5.039542911),new ce.Go(5,6.044942608)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(1,3.01602931),new ce.Go(2,4.00260325),new ce.Go(3,5.012223628),new ce.Go(4,6.018888072),new ce.Go(5,7.028030527),new ce.Go(6,8.033921838),new ce.Go(7,9.043820323),new ce.Go(8,10.052399713)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(1,4.027182329),new ce.Go(2,5.012537796),new ce.Go(3,6.015122281),new ce.Go(4,7.016004049),new ce.Go(5,8.02248667),new ce.Go(6,9.026789122),new ce.Go(7,10.035480884),new ce.Go(8,11.043796166),new ce.Go(9,12.05378)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(1,5.04079),new ce.Go(2,6.019725804),new ce.Go(3,7.016929246),new ce.Go(4,8.005305094),new ce.Go(5,9.012182135),new ce.Go(6,10.01353372),new ce.Go(7,11.021657653),new ce.Go(8,12.026920631),new ce.Go(9,13.036133834),new ce.Go(10,14.042815522)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(2,7.029917389),new ce.Go(3,8.024606713),new ce.Go(4,9.013328806),new ce.Go(5,10.012937027),new ce.Go(6,11.009305466),new ce.Go(7,12.014352109),new ce.Go(8,13.017780267),new ce.Go(9,14.025404064),new ce.Go(10,15.031097291),new ce.Go(11,16.039808836),new ce.Go(12,17.046931399),new ce.Go(13,18.05617),new ce.Go(14,19.06373)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(2,8.037675026),new ce.Go(3,9.031040087),new ce.Go(4,10.01685311),new ce.Go(5,11.011433818),new ce.Go(6,12),new ce.Go(7,13.003354838),new ce.Go(8,14.003241988),new ce.Go(9,15.010599258),new ce.Go(10,16.014701243),new ce.Go(11,17.022583712),new ce.Go(12,18.026757058),new ce.Go(13,19.035248094),new ce.Go(14,20.040322395),new ce.Go(15,21.04934),new ce.Go(16,22.05645)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(3,10.042618),new ce.Go(4,11.026796226),new ce.Go(5,12.018613202),new ce.Go(6,13.005738584),new ce.Go(7,14.003074005),new ce.Go(8,15.000108898),new ce.Go(9,16.006101417),new ce.Go(10,17.008449673),new ce.Go(11,18.014081827),new ce.Go(12,19.017026896),new ce.Go(13,20.023367295),new ce.Go(14,21.027087574),new ce.Go(15,22.034440259),new ce.Go(16,23.04051),new ce.Go(17,24.0505)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(4,12.034404776),new ce.Go(5,13.0248104),new ce.Go(6,14.008595285),new ce.Go(7,15.003065386),new ce.Go(8,15.994914622),new ce.Go(9,16.999131501),new ce.Go(10,17.999160419),new ce.Go(11,19.00357873),new ce.Go(12,20.00407615),new ce.Go(13,21.008654631),new ce.Go(14,22.009967157),new ce.Go(15,23.015691325),new ce.Go(16,24.020369922),new ce.Go(17,25.02914),new ce.Go(18,26.03775)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(5,14.03608),new ce.Go(6,15.018010856),new ce.Go(7,16.01146573),new ce.Go(8,17.002095238),new ce.Go(9,18.000937667),new ce.Go(10,18.998403205),new ce.Go(11,19.999981324),new ce.Go(12,20.999948921),new ce.Go(13,22.00299925),new ce.Go(14,23.003574385),new ce.Go(15,24.008099371),new ce.Go(16,25.012094963),new ce.Go(17,26.019633157),new ce.Go(18,27.026892316),new ce.Go(19,28.03567),new ce.Go(20,29.04326)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(6,16.025756907),new ce.Go(7,17.017697565),new ce.Go(8,18.005697066),new ce.Go(9,19.001879839),new ce.Go(10,19.992440176),new ce.Go(11,20.993846744),new ce.Go(12,21.99138551),new ce.Go(13,22.994467337),new ce.Go(14,23.993615074),new ce.Go(15,24.997789899),new ce.Go(16,26.000461498),new ce.Go(17,27.0076152),new ce.Go(18,28.012108072),new ce.Go(19,29.019345902),new ce.Go(20,30.023872),new ce.Go(21,31.03311),new ce.Go(22,32.03991)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(7,18.02718),new ce.Go(8,19.01387945),new ce.Go(9,20.00734826),new ce.Go(10,20.997655099),new ce.Go(11,21.994436782),new ce.Go(12,22.989769675),new ce.Go(13,23.990963332),new ce.Go(14,24.989954352),new ce.Go(15,25.992589898),new ce.Go(16,26.994008702),new ce.Go(17,27.99889041),new ce.Go(18,29.002811301),new ce.Go(19,30.009226487),new ce.Go(20,31.013595108),new ce.Go(21,32.019649792),new ce.Go(22,33.027386),new ce.Go(23,34.0349),new ce.Go(24,35.04418)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(8,20.018862744),new ce.Go(9,21.011714174),new ce.Go(10,21.999574055),new ce.Go(11,22.99412485),new ce.Go(12,23.985041898),new ce.Go(13,24.985837023),new ce.Go(14,25.98259304),new ce.Go(15,26.984340742),new ce.Go(16,27.983876703),new ce.Go(17,28.988554743),new ce.Go(18,29.990464529),new ce.Go(19,30.996548459),new ce.Go(20,31.999145889),new ce.Go(21,33.005586975),new ce.Go(22,34.00907244),new ce.Go(23,35.018669),new ce.Go(24,36.02245),new ce.Go(25,37.03124)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(8,21.02804),new ce.Go(9,22.01952),new ce.Go(10,23.0072649),new ce.Go(11,23.999940911),new ce.Go(12,24.990428555),new ce.Go(13,25.986891659),new ce.Go(14,26.981538441),new ce.Go(15,27.981910184),new ce.Go(16,28.980444848),new ce.Go(17,29.982960304),new ce.Go(18,30.983946023),new ce.Go(19,31.988124379),new ce.Go(20,32.990869587),new ce.Go(21,33.996927255),new ce.Go(22,34.99993765),new ce.Go(23,36.006351501),new ce.Go(24,37.01031),new ce.Go(25,38.0169),new ce.Go(26,39.0219)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(8,22.03453),new ce.Go(9,23.02552),new ce.Go(10,24.011545711),new ce.Go(11,25.00410664),new ce.Go(12,25.992329935),new ce.Go(13,26.986704764),new ce.Go(14,27.976926533),new ce.Go(15,28.976494719),new ce.Go(16,29.973770218),new ce.Go(17,30.975363275),new ce.Go(18,31.974148129),new ce.Go(19,32.97800052),new ce.Go(20,33.978575745),new ce.Go(21,34.984584158),new ce.Go(22,35.986687363),new ce.Go(23,36.99299599),new ce.Go(24,37.99598),new ce.Go(25,39.0023),new ce.Go(26,40.0058),new ce.Go(27,41.0127),new ce.Go(28,42.0161)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(9,24.03435),new ce.Go(10,25.02026),new ce.Go(11,26.01178),new ce.Go(12,26.999191645),new ce.Go(13,27.99231233),new ce.Go(14,28.981801376),new ce.Go(15,29.978313807),new ce.Go(16,30.973761512),new ce.Go(17,31.973907163),new ce.Go(18,32.971725281),new ce.Go(19,33.973636381),new ce.Go(20,34.973314249),new ce.Go(21,35.978259824),new ce.Go(22,36.979608338),new ce.Go(23,37.98447),new ce.Go(24,38.98642),new ce.Go(25,39.99105),new ce.Go(26,40.9948),new ce.Go(27,42.00009),new ce.Go(28,43.00331),new ce.Go(29,44.00988),new ce.Go(30,45.01514),new ce.Go(31,46.02383)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(10,26.02788),new ce.Go(11,27.018795),new ce.Go(12,28.004372661),new ce.Go(13,28.996608805),new ce.Go(14,29.984902954),new ce.Go(15,30.979554421),new ce.Go(16,31.97207069),new ce.Go(17,32.971458497),new ce.Go(18,33.967866831),new ce.Go(19,34.96903214),new ce.Go(20,35.96708088),new ce.Go(21,36.971125716),new ce.Go(22,37.971163443),new ce.Go(23,38.975135275),new ce.Go(24,39.97547),new ce.Go(25,40.98003),new ce.Go(26,41.98149),new ce.Go(27,42.9866),new ce.Go(28,43.98832),new ce.Go(29,44.99482),new ce.Go(30,45.99957),new ce.Go(31,47.00762),new ce.Go(32,48.01299),new ce.Go(33,49.02201)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(11,28.02851),new ce.Go(12,29.01411),new ce.Go(13,30.00477),new ce.Go(14,30.992416014),new ce.Go(15,31.985688908),new ce.Go(16,32.977451798),new ce.Go(17,33.973761967),new ce.Go(18,34.968852707),new ce.Go(19,35.968306945),new ce.Go(20,36.9659026),new ce.Go(21,37.96801055),new ce.Go(22,38.968007677),new ce.Go(23,39.970415555),new ce.Go(24,40.970650212),new ce.Go(25,41.973174994),new ce.Go(26,42.974203385),new ce.Go(27,43.978538712),new ce.Go(28,44.9797),new ce.Go(29,45.98412),new ce.Go(30,46.98795),new ce.Go(31,47.99485),new ce.Go(32,48.99989),new ce.Go(33,50.00773),new ce.Go(34,51.01353)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(12,30.02156),new ce.Go(13,31.012126),new ce.Go(14,31.99766066),new ce.Go(15,32.989928719),new ce.Go(16,33.980270118),new ce.Go(17,34.975256726),new ce.Go(18,35.967546282),new ce.Go(19,36.966775912),new ce.Go(20,37.962732161),new ce.Go(21,38.964313413),new ce.Go(22,39.962383123),new ce.Go(23,40.964500828),new ce.Go(24,41.963046386),new ce.Go(25,42.965670701),new ce.Go(26,43.965365269),new ce.Go(27,44.968094979),new ce.Go(28,45.968093467),new ce.Go(29,46.972186238),new ce.Go(30,47.97507),new ce.Go(31,48.98218),new ce.Go(32,49.98594),new ce.Go(33,50.99324),new ce.Go(34,51.99817),new ce.Go(35,53.006227)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(13,32.02192),new ce.Go(14,33.00726),new ce.Go(15,33.99841),new ce.Go(16,34.988011615),new ce.Go(17,35.981293405),new ce.Go(18,36.973376915),new ce.Go(19,37.969080107),new ce.Go(20,38.963706861),new ce.Go(21,39.963998672),new ce.Go(22,40.961825972),new ce.Go(23,41.962403059),new ce.Go(24,42.960715746),new ce.Go(25,43.961556146),new ce.Go(26,44.960699658),new ce.Go(27,45.961976203),new ce.Go(28,46.961677807),new ce.Go(29,47.965512946),new ce.Go(30,48.967450084),new ce.Go(31,49.972782832),new ce.Go(32,50.97638),new ce.Go(33,51.98261),new ce.Go(34,52.98712),new ce.Go(35,53.99399),new ce.Go(36,54.999388)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(14,34.01412),new ce.Go(15,35.004765),new ce.Go(16,35.993087234),new ce.Go(17,36.985871505),new ce.Go(18,37.976318637),new ce.Go(19,38.970717729),new ce.Go(20,39.962591155),new ce.Go(21,40.962278349),new ce.Go(22,41.958618337),new ce.Go(23,42.958766833),new ce.Go(24,43.955481094),new ce.Go(25,44.956185938),new ce.Go(26,45.953692759),new ce.Go(27,46.954546459),new ce.Go(28,47.952533512),new ce.Go(29,48.955673302),new ce.Go(30,49.957518286),new ce.Go(31,50.961474238),new ce.Go(32,51.9651),new ce.Go(33,52.97005),new ce.Go(34,53.97468),new ce.Go(35,54.98055),new ce.Go(36,55.98579),new ce.Go(37,56.992356)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(15,36.01492),new ce.Go(16,37.00305),new ce.Go(17,37.9947),new ce.Go(18,38.984790009),new ce.Go(19,39.977964014),new ce.Go(20,40.969251316),new ce.Go(21,41.965516761),new ce.Go(22,42.96115098),new ce.Go(23,43.959403048),new ce.Go(24,44.955910243),new ce.Go(25,45.95517025),new ce.Go(26,46.952408027),new ce.Go(27,47.952234991),new ce.Go(28,48.950024065),new ce.Go(29,49.952187008),new ce.Go(30,50.9536027),new ce.Go(31,51.95665),new ce.Go(32,52.95817),new ce.Go(33,53.963),new ce.Go(34,54.9694),new ce.Go(35,55.97266),new ce.Go(36,56.97704),new ce.Go(37,57.98307),new ce.Go(38,58.988041)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(16,38.00977),new ce.Go(17,39.001323),new ce.Go(18,39.990498907),new ce.Go(19,40.983131),new ce.Go(20,41.973031622),new ce.Go(21,42.968523342),new ce.Go(22,43.959690235),new ce.Go(23,44.958124349),new ce.Go(24,45.952629491),new ce.Go(25,46.951763792),new ce.Go(26,47.947947053),new ce.Go(27,48.947870789),new ce.Go(28,49.944792069),new ce.Go(29,50.946616017),new ce.Go(30,51.946898175),new ce.Go(31,52.949731709),new ce.Go(32,53.95087),new ce.Go(33,54.95512),new ce.Go(34,55.95799),new ce.Go(35,56.9643),new ce.Go(36,57.96611),new ce.Go(37,58.97196),new ce.Go(38,59.97564),new ce.Go(39,60.982018)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(17,40.01109),new ce.Go(18,40.99974),new ce.Go(19,41.99123),new ce.Go(20,42.98065),new ce.Go(21,43.9744),new ce.Go(22,44.965782286),new ce.Go(23,45.960199491),new ce.Go(24,46.954906918),new ce.Go(25,47.95225448),new ce.Go(26,48.948516914),new ce.Go(27,49.947162792),new ce.Go(28,50.943963675),new ce.Go(29,51.944779658),new ce.Go(30,52.944342517),new ce.Go(31,53.946444381),new ce.Go(32,54.947238194),new ce.Go(33,55.95036),new ce.Go(34,56.95236),new ce.Go(35,57.95665),new ce.Go(36,58.9593),new ce.Go(37,59.9645),new ce.Go(38,60.96741),new ce.Go(39,61.97314),new ce.Go(40,62.97675)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(18,42.00643),new ce.Go(19,42.997707),new ce.Go(20,43.98547),new ce.Go(21,44.97916),new ce.Go(22,45.968361649),new ce.Go(23,46.962906512),new ce.Go(24,47.954035861),new ce.Go(25,48.951341135),new ce.Go(26,49.946049607),new ce.Go(27,50.944771767),new ce.Go(28,51.940511904),new ce.Go(29,52.940653781),new ce.Go(30,53.938884921),new ce.Go(31,54.940844164),new ce.Go(32,55.940645238),new ce.Go(33,56.9437538),new ce.Go(34,57.94425),new ce.Go(35,58.94863),new ce.Go(36,59.94973),new ce.Go(37,60.95409),new ce.Go(38,61.9558),new ce.Go(39,62.96186),new ce.Go(40,63.9642),new ce.Go(41,64.97037)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(19,44.00687),new ce.Go(20,44.99451),new ce.Go(21,45.98672),new ce.Go(22,46.9761),new ce.Go(23,47.96887),new ce.Go(24,48.959623415),new ce.Go(25,49.95424396),new ce.Go(26,50.948215487),new ce.Go(27,51.945570079),new ce.Go(28,52.941294702),new ce.Go(29,53.940363247),new ce.Go(30,54.938049636),new ce.Go(31,55.938909366),new ce.Go(32,56.938287458),new ce.Go(33,57.939986451),new ce.Go(34,58.940447166),new ce.Go(35,59.943193998),new ce.Go(36,60.94446),new ce.Go(37,61.94797),new ce.Go(38,62.94981),new ce.Go(39,63.95373),new ce.Go(40,64.9561),new ce.Go(41,65.96082),new ce.Go(42,66.96382)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(19,45.01456),new ce.Go(20,46.00081),new ce.Go(21,46.99289),new ce.Go(22,47.98056),new ce.Go(23,48.97361),new ce.Go(24,49.962993316),new ce.Go(25,50.956824936),new ce.Go(26,51.948116526),new ce.Go(27,52.945312282),new ce.Go(28,53.939614836),new ce.Go(29,54.938298029),new ce.Go(30,55.934942133),new ce.Go(31,56.935398707),new ce.Go(32,57.933280458),new ce.Go(33,58.934880493),new ce.Go(34,59.934076943),new ce.Go(35,60.936749461),new ce.Go(36,61.936770495),new ce.Go(37,62.940118442),new ce.Go(38,63.94087),new ce.Go(39,64.94494),new ce.Go(40,65.94598),new ce.Go(41,66.95),new ce.Go(42,67.95251),new ce.Go(43,68.9577)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(21,48.00176),new ce.Go(22,48.98972),new ce.Go(23,49.98154),new ce.Go(24,50.97072),new ce.Go(25,51.96359),new ce.Go(26,52.954224985),new ce.Go(27,53.948464147),new ce.Go(28,54.942003149),new ce.Go(29,55.939843937),new ce.Go(30,56.936296235),new ce.Go(31,57.935757571),new ce.Go(32,58.933200194),new ce.Go(33,59.933822196),new ce.Go(34,60.932479381),new ce.Go(35,61.934054212),new ce.Go(36,62.933615218),new ce.Go(37,63.935813523),new ce.Go(38,64.936484581),new ce.Go(39,65.939825412),new ce.Go(40,66.94061),new ce.Go(41,67.94436),new ce.Go(42,68.9452),new ce.Go(43,69.94981),new ce.Go(44,70.95173),new ce.Go(45,71.95641)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(22,49.99593),new ce.Go(23,50.98772),new ce.Go(24,51.97568),new ce.Go(25,52.96846),new ce.Go(26,53.957910508),new ce.Go(27,54.951336329),new ce.Go(28,55.942136339),new ce.Go(29,56.939800489),new ce.Go(30,57.935347922),new ce.Go(31,58.934351553),new ce.Go(32,59.930790633),new ce.Go(33,60.931060442),new ce.Go(34,61.928348763),new ce.Go(35,62.929672948),new ce.Go(36,63.927969574),new ce.Go(37,64.930088013),new ce.Go(38,65.929115232),new ce.Go(39,66.931569638),new ce.Go(40,67.931844932),new ce.Go(41,68.935181837),new ce.Go(42,69.93614),new ce.Go(43,70.94),new ce.Go(44,71.9413),new ce.Go(45,72.94608),new ce.Go(46,73.94791),new ce.Go(47,74.95297),new ce.Go(48,75.95533),new ce.Go(49,76.96083),new ce.Go(50,77.9638)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(23,51.99718),new ce.Go(24,52.98555),new ce.Go(25,53.97671),new ce.Go(26,54.96605),new ce.Go(27,55.95856),new ce.Go(28,56.949215695),new ce.Go(29,57.944540734),new ce.Go(30,58.939504114),new ce.Go(31,59.937368123),new ce.Go(32,60.933462181),new ce.Go(33,61.932587299),new ce.Go(34,62.929601079),new ce.Go(35,63.929767865),new ce.Go(36,64.927793707),new ce.Go(37,65.928873041),new ce.Go(38,66.927750294),new ce.Go(39,67.929637875),new ce.Go(40,68.929425281),new ce.Go(41,69.932409287),new ce.Go(42,70.932619818),new ce.Go(43,71.93552),new ce.Go(44,72.93649),new ce.Go(45,73.9402),new ce.Go(46,74.9417),new ce.Go(47,75.94599),new ce.Go(48,76.94795),new ce.Go(49,77.95281),new ce.Go(50,78.95528),new ce.Go(51,79.96189)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(24,53.99295),new ce.Go(25,54.98398),new ce.Go(26,55.97238),new ce.Go(27,56.96491),new ce.Go(28,57.954596465),new ce.Go(29,58.949267074),new ce.Go(30,59.941832031),new ce.Go(31,60.939513907),new ce.Go(32,61.934334132),new ce.Go(33,62.933215563),new ce.Go(34,63.929146578),new ce.Go(35,64.929245079),new ce.Go(36,65.926036763),new ce.Go(37,66.927130859),new ce.Go(38,67.924847566),new ce.Go(39,68.926553538),new ce.Go(40,69.92532487),new ce.Go(41,70.927727195),new ce.Go(42,71.926861122),new ce.Go(43,72.929779469),new ce.Go(44,73.929458261),new ce.Go(45,74.932937379),new ce.Go(46,75.933394207),new ce.Go(47,76.937085857),new ce.Go(48,77.938569576),new ce.Go(49,78.942095175),new ce.Go(50,79.944414722),new ce.Go(51,80.95048),new ce.Go(52,81.95484)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(25,55.99491),new ce.Go(26,56.98293),new ce.Go(27,57.97425),new ce.Go(28,58.96337),new ce.Go(29,59.95706),new ce.Go(30,60.94917),new ce.Go(31,61.944179608),new ce.Go(32,62.939141527),new ce.Go(33,63.936838307),new ce.Go(34,64.932739322),new ce.Go(35,65.931592355),new ce.Go(36,66.928204915),new ce.Go(37,67.927983497),new ce.Go(38,68.925580912),new ce.Go(39,69.926027741),new ce.Go(40,70.92470501),new ce.Go(41,71.92636935),new ce.Go(42,72.925169832),new ce.Go(43,73.926940999),new ce.Go(44,74.926500645),new ce.Go(45,75.928928262),new ce.Go(46,76.929281189),new ce.Go(47,77.93165595),new ce.Go(48,78.932916371),new ce.Go(49,79.936588154),new ce.Go(50,80.937752955),new ce.Go(51,81.94316),new ce.Go(52,82.94687),new ce.Go(53,83.95234)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(26,57.99101),new ce.Go(27,58.98175),new ce.Go(28,59.97019),new ce.Go(29,60.96379),new ce.Go(30,61.95465),new ce.Go(31,62.94964),new ce.Go(32,63.941572638),new ce.Go(33,64.939440762),new ce.Go(34,65.933846798),new ce.Go(35,66.932738415),new ce.Go(36,67.928097266),new ce.Go(37,68.927972002),new ce.Go(38,69.924250365),new ce.Go(39,70.924953991),new ce.Go(40,71.922076184),new ce.Go(41,72.923459361),new ce.Go(42,73.921178213),new ce.Go(43,74.922859494),new ce.Go(44,75.921402716),new ce.Go(45,76.923548462),new ce.Go(46,77.922852886),new ce.Go(47,78.92540156),new ce.Go(48,79.925444764),new ce.Go(49,80.928821065),new ce.Go(50,81.929550326),new ce.Go(51,82.93451),new ce.Go(52,83.93731),new ce.Go(53,84.94269),new ce.Go(54,85.94627)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(27,59.99313),new ce.Go(28,60.98062),new ce.Go(29,61.9732),new ce.Go(30,62.96369),new ce.Go(31,63.957572),new ce.Go(32,64.949484),new ce.Go(33,65.944099147),new ce.Go(34,66.939190417),new ce.Go(35,67.936792976),new ce.Go(36,68.932280154),new ce.Go(37,69.930927811),new ce.Go(38,70.927114724),new ce.Go(39,71.926752647),new ce.Go(40,72.923825288),new ce.Go(41,73.923929076),new ce.Go(42,74.921596417),new ce.Go(43,75.922393933),new ce.Go(44,76.920647703),new ce.Go(45,77.921828577),new ce.Go(46,78.920948498),new ce.Go(47,79.922578162),new ce.Go(48,80.922132884),new ce.Go(49,81.924504668),new ce.Go(50,82.924980625),new ce.Go(51,83.92906),new ce.Go(52,84.93181),new ce.Go(53,85.93623),new ce.Go(54,86.93958),new ce.Go(55,87.94456),new ce.Go(56,88.94923)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(31,64.96466),new ce.Go(32,65.95521),new ce.Go(33,66.95009),new ce.Go(34,67.94187),new ce.Go(35,68.939562155),new ce.Go(36,69.933504),new ce.Go(37,70.931868378),new ce.Go(38,71.927112313),new ce.Go(39,72.9267668),new ce.Go(40,73.922476561),new ce.Go(41,74.922523571),new ce.Go(42,75.919214107),new ce.Go(43,76.91991461),new ce.Go(44,77.917309522),new ce.Go(45,78.918499802),new ce.Go(46,79.916521828),new ce.Go(47,80.917992931),new ce.Go(48,81.9167),new ce.Go(49,82.919119072),new ce.Go(50,83.918464523),new ce.Go(51,84.922244678),new ce.Go(52,85.924271165),new ce.Go(53,86.928520749),new ce.Go(54,87.931423982),new ce.Go(55,88.93602),new ce.Go(56,89.93942),new ce.Go(57,90.94537),new ce.Go(58,91.94933)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(32,66.96479),new ce.Go(33,67.958248),new ce.Go(34,68.950178),new ce.Go(35,69.944208),new ce.Go(36,70.939246),new ce.Go(37,71.936496876),new ce.Go(38,72.931794889),new ce.Go(39,73.929891152),new ce.Go(40,74.92577641),new ce.Go(41,75.924541974),new ce.Go(42,76.921380123),new ce.Go(43,77.92114613),new ce.Go(44,78.918337647),new ce.Go(45,79.918529952),new ce.Go(46,80.91629106),new ce.Go(47,81.916804666),new ce.Go(48,82.915180219),new ce.Go(49,83.916503685),new ce.Go(50,84.915608027),new ce.Go(51,85.918797162),new ce.Go(52,86.920710713),new ce.Go(53,87.924065908),new ce.Go(54,88.92638726),new ce.Go(55,89.930634988),new ce.Go(56,90.9339653),new ce.Go(57,91.939255258),new ce.Go(58,92.9431),new ce.Go(59,93.94868)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(33,68.96532),new ce.Go(34,69.95601),new ce.Go(35,70.95051),new ce.Go(36,71.94190754),new ce.Go(37,72.938931115),new ce.Go(38,73.933258225),new ce.Go(39,74.931033794),new ce.Go(40,75.925948304),new ce.Go(41,76.92466788),new ce.Go(42,77.920386271),new ce.Go(43,78.920082992),new ce.Go(44,79.91637804),new ce.Go(45,80.916592419),new ce.Go(46,81.913484601),new ce.Go(47,82.914135952),new ce.Go(48,83.911506627),new ce.Go(49,84.912526954),new ce.Go(50,85.910610313),new ce.Go(51,86.913354251),new ce.Go(52,87.914446951),new ce.Go(53,88.917632505),new ce.Go(54,89.919523803),new ce.Go(55,90.923442418),new ce.Go(56,91.926152752),new ce.Go(57,92.931265246),new ce.Go(58,93.934362),new ce.Go(59,94.93984),new ce.Go(60,95.94307),new ce.Go(61,96.94856)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(34,70.96532),new ce.Go(35,71.95908),new ce.Go(36,72.950366),new ce.Go(37,73.944470376),new ce.Go(38,74.938569199),new ce.Go(39,75.935071448),new ce.Go(40,76.930406599),new ce.Go(41,77.928141485),new ce.Go(42,78.923996719),new ce.Go(43,79.922519322),new ce.Go(44,80.918994165),new ce.Go(45,81.918207691),new ce.Go(46,82.915111951),new ce.Go(47,83.914384676),new ce.Go(48,84.911789341),new ce.Go(49,85.91116708),new ce.Go(50,86.909183465),new ce.Go(51,87.911318556),new ce.Go(52,88.912279939),new ce.Go(53,89.914808941),new ce.Go(54,90.91653416),new ce.Go(55,91.919725442),new ce.Go(56,92.922032765),new ce.Go(57,93.926407326),new ce.Go(58,94.92931926),new ce.Go(59,95.934283962),new ce.Go(60,96.937342863),new ce.Go(61,97.941703557),new ce.Go(62,98.945420616),new ce.Go(63,99.94987),new ce.Go(64,100.953195994),new ce.Go(65,101.95921)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(35,72.96597),new ce.Go(36,73.95631),new ce.Go(37,74.94992),new ce.Go(38,75.94161),new ce.Go(39,76.937761511),new ce.Go(40,77.932179362),new ce.Go(41,78.929707076),new ce.Go(42,79.924524588),new ce.Go(43,80.923213095),new ce.Go(44,81.918401258),new ce.Go(45,82.917555029),new ce.Go(46,83.913424778),new ce.Go(47,84.912932689),new ce.Go(48,85.909262351),new ce.Go(49,86.908879316),new ce.Go(50,87.905614339),new ce.Go(51,88.907452906),new ce.Go(52,89.907737596),new ce.Go(53,90.910209845),new ce.Go(54,91.911029895),new ce.Go(55,92.91402241),new ce.Go(56,93.915359856),new ce.Go(57,94.919358213),new ce.Go(58,95.921680473),new ce.Go(59,96.926148757),new ce.Go(60,97.928471177),new ce.Go(61,98.933315038),new ce.Go(62,99.935351729),new ce.Go(63,100.940517434),new ce.Go(64,101.943018795),new ce.Go(65,102.94895),new ce.Go(66,103.95233)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(38,76.94962),new ce.Go(39,77.9435),new ce.Go(40,78.937350712),new ce.Go(41,79.931982402),new ce.Go(42,80.929128719),new ce.Go(43,81.926792071),new ce.Go(44,82.922352572),new ce.Go(45,83.920387768),new ce.Go(46,84.916427076),new ce.Go(47,85.914887724),new ce.Go(48,86.910877833),new ce.Go(49,87.909503361),new ce.Go(50,88.905847902),new ce.Go(51,89.907151443),new ce.Go(52,90.907303415),new ce.Go(53,91.908946832),new ce.Go(54,92.909581582),new ce.Go(55,93.911594008),new ce.Go(56,94.912823709),new ce.Go(57,95.915897787),new ce.Go(58,96.918131017),new ce.Go(59,97.922219525),new ce.Go(60,98.924634736),new ce.Go(61,99.927756402),new ce.Go(62,100.930313395),new ce.Go(63,101.933555501),new ce.Go(64,102.93694),new ce.Go(65,103.94145),new ce.Go(66,104.94509),new ce.Go(67,105.95022)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(39,78.94916),new ce.Go(40,79.94055),new ce.Go(41,80.936815296),new ce.Go(42,81.931086249),new ce.Go(43,82.92865213),new ce.Go(44,83.92325),new ce.Go(45,84.92146522),new ce.Go(46,85.916472851),new ce.Go(47,86.914816578),new ce.Go(48,87.910226179),new ce.Go(49,88.908888916),new ce.Go(50,89.904703679),new ce.Go(51,90.905644968),new ce.Go(52,91.905040106),new ce.Go(53,92.906475627),new ce.Go(54,93.906315765),new ce.Go(55,94.908042739),new ce.Go(56,95.908275675),new ce.Go(57,96.910950716),new ce.Go(58,97.912746366),new ce.Go(59,98.916511084),new ce.Go(60,99.917761704),new ce.Go(61,100.921139958),new ce.Go(62,101.922981089),new ce.Go(63,102.926597062),new ce.Go(64,103.92878),new ce.Go(65,104.93305),new ce.Go(66,105.93591),new ce.Go(67,106.94086),new ce.Go(68,107.94428)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(40,80.94905),new ce.Go(41,81.94313),new ce.Go(42,82.936703713),new ce.Go(43,83.93357),new ce.Go(44,84.927906486),new ce.Go(45,85.925037588),new ce.Go(46,86.920361435),new ce.Go(47,87.91833144),new ce.Go(48,88.913495503),new ce.Go(49,89.911264109),new ce.Go(50,90.906990538),new ce.Go(51,91.907193214),new ce.Go(52,92.906377543),new ce.Go(53,93.907283457),new ce.Go(54,94.906835178),new ce.Go(55,95.908100076),new ce.Go(56,96.908097144),new ce.Go(57,97.91033069),new ce.Go(58,98.911617864),new ce.Go(59,99.914181434),new ce.Go(60,100.915251567),new ce.Go(61,101.918037417),new ce.Go(62,102.919141297),new ce.Go(63,103.922459464),new ce.Go(64,104.923934023),new ce.Go(65,105.92819),new ce.Go(66,106.93031),new ce.Go(67,107.93501),new ce.Go(68,108.93763),new ce.Go(69,109.94268)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(41,82.94874),new ce.Go(42,83.94009),new ce.Go(43,84.93659),new ce.Go(44,85.930695167),new ce.Go(45,86.92732683),new ce.Go(46,87.921952728),new ce.Go(47,88.919480562),new ce.Go(48,89.913936161),new ce.Go(49,90.911750754),new ce.Go(50,91.90681048),new ce.Go(51,92.906812213),new ce.Go(52,93.905087578),new ce.Go(53,94.905841487),new ce.Go(54,95.904678904),new ce.Go(55,96.906021033),new ce.Go(56,97.905407846),new ce.Go(57,98.907711598),new ce.Go(58,99.907477149),new ce.Go(59,100.910346543),new ce.Go(60,101.910297162),new ce.Go(61,102.913204596),new ce.Go(62,103.913758387),new ce.Go(63,104.916972087),new ce.Go(64,105.918134284),new ce.Go(65,106.921694724),new ce.Go(66,107.923973837),new ce.Go(67,108.92781),new ce.Go(68,109.92973),new ce.Go(69,110.93451),new ce.Go(70,111.93684),new ce.Go(71,112.94203)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(42,84.94894),new ce.Go(43,85.94288),new ce.Go(44,86.93653),new ce.Go(45,87.93283),new ce.Go(46,88.92754288),new ce.Go(47,89.92355583),new ce.Go(48,90.9184282),new ce.Go(49,91.915259655),new ce.Go(50,92.910248473),new ce.Go(51,93.909656309),new ce.Go(52,94.907656454),new ce.Go(53,95.907870803),new ce.Go(54,96.906364843),new ce.Go(55,97.907215692),new ce.Go(56,98.906254554),new ce.Go(57,99.907657594),new ce.Go(58,100.90731438),new ce.Go(59,101.909212938),new ce.Go(60,102.909178805),new ce.Go(61,103.911444898),new ce.Go(62,104.911658043),new ce.Go(63,105.914355408),new ce.Go(64,106.915081691),new ce.Go(65,107.918479973),new ce.Go(66,108.919980998),new ce.Go(67,109.92339),new ce.Go(68,110.92505),new ce.Go(69,111.92924),new ce.Go(70,112.93133),new ce.Go(71,113.93588),new ce.Go(72,114.93828)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(43,86.94918),new ce.Go(44,87.94042),new ce.Go(45,88.93611),new ce.Go(46,89.92978),new ce.Go(47,90.926377434),new ce.Go(48,91.92012),new ce.Go(49,92.917051523),new ce.Go(50,93.911359569),new ce.Go(51,94.910412729),new ce.Go(52,95.907597681),new ce.Go(53,96.907554546),new ce.Go(54,97.905287111),new ce.Go(55,98.905939307),new ce.Go(56,99.904219664),new ce.Go(57,100.905582219),new ce.Go(58,101.904349503),new ce.Go(59,102.906323677),new ce.Go(60,103.905430145),new ce.Go(61,104.907750341),new ce.Go(62,105.907326913),new ce.Go(63,106.909907207),new ce.Go(64,107.910192211),new ce.Go(65,108.913201565),new ce.Go(66,109.913966185),new ce.Go(67,110.91756),new ce.Go(68,111.918821673),new ce.Go(69,112.92254),new ce.Go(70,113.923891981),new ce.Go(71,114.92831),new ce.Go(72,115.93016),new ce.Go(73,116.93479),new ce.Go(74,117.93703)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(44,88.94938),new ce.Go(45,89.94287),new ce.Go(46,90.93655),new ce.Go(47,91.93198),new ce.Go(48,92.92574),new ce.Go(49,93.921698),new ce.Go(50,94.915898541),new ce.Go(51,95.914518212),new ce.Go(52,96.911336643),new ce.Go(53,97.910716431),new ce.Go(54,98.908132101),new ce.Go(55,99.90811663),new ce.Go(56,100.906163526),new ce.Go(57,101.906842845),new ce.Go(58,102.905504182),new ce.Go(59,103.906655315),new ce.Go(60,104.905692444),new ce.Go(61,105.907284615),new ce.Go(62,106.90675054),new ce.Go(63,107.908730768),new ce.Go(64,108.908735621),new ce.Go(65,109.910949525),new ce.Go(66,110.91166),new ce.Go(67,111.913969253),new ce.Go(68,112.91542),new ce.Go(69,113.91734336),new ce.Go(70,114.920124676),new ce.Go(71,115.922746643),new ce.Go(72,116.92535),new ce.Go(73,117.92943),new ce.Go(74,118.93136),new ce.Go(75,119.93578),new ce.Go(76,120.93808)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(45,90.94948),new ce.Go(46,91.94042),new ce.Go(47,92.93591),new ce.Go(48,93.92877),new ce.Go(49,94.92469),new ce.Go(50,95.91822194),new ce.Go(51,96.916478921),new ce.Go(52,97.912720751),new ce.Go(53,98.911767757),new ce.Go(54,99.908504596),new ce.Go(55,100.908289144),new ce.Go(56,101.905607716),new ce.Go(57,102.906087204),new ce.Go(58,103.904034912),new ce.Go(59,104.905084046),new ce.Go(60,105.903483087),new ce.Go(61,106.905128453),new ce.Go(62,107.903894451),new ce.Go(63,108.905953535),new ce.Go(64,109.905152385),new ce.Go(65,110.907643952),new ce.Go(66,111.907313277),new ce.Go(67,112.910151346),new ce.Go(68,113.910365322),new ce.Go(69,114.91368341),new ce.Go(70,115.914158288),new ce.Go(71,116.91784),new ce.Go(72,117.918983915),new ce.Go(73,118.92268),new ce.Go(74,119.92403),new ce.Go(75,120.92818),new ce.Go(76,121.9298),new ce.Go(77,122.93426)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(47,93.94278),new ce.Go(48,94.93548),new ce.Go(49,95.93068),new ce.Go(50,96.924),new ce.Go(51,97.921759995),new ce.Go(52,98.917597103),new ce.Go(53,99.916069387),new ce.Go(54,100.912802135),new ce.Go(55,101.911999996),new ce.Go(56,102.908972453),new ce.Go(57,103.908628228),new ce.Go(58,104.906528234),new ce.Go(59,105.906666431),new ce.Go(60,106.90509302),new ce.Go(61,107.905953705),new ce.Go(62,108.904755514),new ce.Go(63,109.90611046),new ce.Go(64,110.905294679),new ce.Go(65,111.907004132),new ce.Go(66,112.906565708),new ce.Go(67,113.908807907),new ce.Go(68,114.908762282),new ce.Go(69,115.911359558),new ce.Go(70,116.911684187),new ce.Go(71,117.914582383),new ce.Go(72,118.915666045),new ce.Go(73,119.918788609),new ce.Go(74,120.919851074),new ce.Go(75,121.92332),new ce.Go(76,122.9249),new ce.Go(77,123.92853),new ce.Go(78,124.93054),new ce.Go(79,125.9345),new ce.Go(80,126.93688)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(48,95.93977),new ce.Go(49,96.93494),new ce.Go(50,97.927579),new ce.Go(51,98.92501),new ce.Go(52,99.920230232),new ce.Go(53,100.918681442),new ce.Go(54,101.914777255),new ce.Go(55,102.913418952),new ce.Go(56,103.909848091),new ce.Go(57,104.909467818),new ce.Go(58,105.906458007),new ce.Go(59,106.906614232),new ce.Go(60,107.904183403),new ce.Go(61,108.904985569),new ce.Go(62,109.903005578),new ce.Go(63,110.904181628),new ce.Go(64,111.902757226),new ce.Go(65,112.904400947),new ce.Go(66,113.903358121),new ce.Go(67,114.905430553),new ce.Go(68,115.904755434),new ce.Go(69,116.907218242),new ce.Go(70,117.906914144),new ce.Go(71,118.909922582),new ce.Go(72,119.909851352),new ce.Go(73,120.91298039),new ce.Go(74,121.9135),new ce.Go(75,122.917003675),new ce.Go(76,123.917648302),new ce.Go(77,124.92124717),new ce.Go(78,125.922353996),new ce.Go(79,126.926434822),new ce.Go(80,127.927760617),new ce.Go(81,128.93226),new ce.Go(82,129.93398)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(49,97.94224),new ce.Go(50,98.93461),new ce.Go(51,99.931149033),new ce.Go(52,100.92656),new ce.Go(53,101.924707541),new ce.Go(54,102.919913896),new ce.Go(55,103.918338416),new ce.Go(56,104.914673434),new ce.Go(57,105.913461134),new ce.Go(58,106.910292195),new ce.Go(59,107.909719683),new ce.Go(60,108.907154078),new ce.Go(61,109.907168783),new ce.Go(62,110.905110677),new ce.Go(63,111.905533338),new ce.Go(64,112.904061223),new ce.Go(65,113.904916758),new ce.Go(66,114.903878328),new ce.Go(67,115.905259995),new ce.Go(68,116.904515731),new ce.Go(69,117.906354623),new ce.Go(70,118.905846334),new ce.Go(71,119.907961505),new ce.Go(72,120.907848847),new ce.Go(73,121.910277103),new ce.Go(74,122.910438951),new ce.Go(75,123.913175916),new ce.Go(76,124.913601387),new ce.Go(77,125.916464532),new ce.Go(78,126.917344048),new ce.Go(79,127.920170658),new ce.Go(80,128.921657958),new ce.Go(81,129.924854941),new ce.Go(82,130.926767408),new ce.Go(83,131.932919005),new ce.Go(84,132.93834),new ce.Go(85,133.94466)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(50,99.938954),new ce.Go(51,100.93606),new ce.Go(52,101.93049),new ce.Go(53,102.92813),new ce.Go(54,103.923185469),new ce.Go(55,104.921390409),new ce.Go(56,105.916880472),new ce.Go(57,106.915666702),new ce.Go(58,107.911965339),new ce.Go(59,108.911286879),new ce.Go(60,109.907852688),new ce.Go(61,110.907735404),new ce.Go(62,111.90482081),new ce.Go(63,112.905173373),new ce.Go(64,113.902781816),new ce.Go(65,114.903345973),new ce.Go(66,115.901744149),new ce.Go(67,116.902953765),new ce.Go(68,117.901606328),new ce.Go(69,118.90330888),new ce.Go(70,119.902196571),new ce.Go(71,120.904236867),new ce.Go(72,121.903440138),new ce.Go(73,122.905721901),new ce.Go(74,123.90527463),new ce.Go(75,124.907784924),new ce.Go(76,125.907653953),new ce.Go(77,126.91035098),new ce.Go(78,127.910534953),new ce.Go(79,128.913439976),new ce.Go(80,129.913852185),new ce.Go(81,130.916919144),new ce.Go(82,131.917744455),new ce.Go(83,132.923814085),new ce.Go(84,133.928463576),new ce.Go(85,134.93473),new ce.Go(86,135.93934),new ce.Go(87,136.94579)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(52,102.94012),new ce.Go(53,103.936287),new ce.Go(54,104.931528593),new ce.Go(55,105.928183134),new ce.Go(56,106.92415),new ce.Go(57,107.92216),new ce.Go(58,108.918136092),new ce.Go(59,109.917533911),new ce.Go(60,110.912534147),new ce.Go(61,111.91239464),new ce.Go(62,112.909377941),new ce.Go(63,113.909095876),new ce.Go(64,114.906598812),new ce.Go(65,115.906797235),new ce.Go(66,116.90483959),new ce.Go(67,117.905531885),new ce.Go(68,118.90394646),new ce.Go(69,119.905074315),new ce.Go(70,120.903818044),new ce.Go(71,121.905175415),new ce.Go(72,122.904215696),new ce.Go(73,123.905937525),new ce.Go(74,124.905247804),new ce.Go(75,125.907248153),new ce.Go(76,126.906914564),new ce.Go(77,127.90916733),new ce.Go(78,128.909150092),new ce.Go(79,129.911546459),new ce.Go(80,130.911946487),new ce.Go(81,131.914413247),new ce.Go(82,132.915236466),new ce.Go(83,133.920551554),new ce.Go(84,134.925167962),new ce.Go(85,135.93066),new ce.Go(86,136.93531),new ce.Go(87,137.94096),new ce.Go(88,138.94571)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(54,105.937702),new ce.Go(55,106.935036),new ce.Go(56,107.929486838),new ce.Go(57,108.927456483),new ce.Go(58,109.922407164),new ce.Go(59,110.921120589),new ce.Go(60,111.917061617),new ce.Go(61,112.915452551),new ce.Go(62,113.912498025),new ce.Go(63,114.911578627),new ce.Go(64,115.908420253),new ce.Go(65,116.90863418),new ce.Go(66,117.905825187),new ce.Go(67,118.90640811),new ce.Go(68,119.904019891),new ce.Go(69,120.904929815),new ce.Go(70,121.903047064),new ce.Go(71,122.904272951),new ce.Go(72,123.902819466),new ce.Go(73,124.904424718),new ce.Go(74,125.903305543),new ce.Go(75,126.90521729),new ce.Go(76,127.904461383),new ce.Go(77,128.906595593),new ce.Go(78,129.906222753),new ce.Go(79,130.90852188),new ce.Go(80,131.908523782),new ce.Go(81,132.910939068),new ce.Go(82,133.911540546),new ce.Go(83,134.916450782),new ce.Go(84,135.920103155),new ce.Go(85,136.925324769),new ce.Go(86,137.92922),new ce.Go(87,138.93473),new ce.Go(88,139.9387),new ce.Go(89,140.94439),new ce.Go(90,141.9485)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(55,107.943291),new ce.Go(56,108.938191658),new ce.Go(57,109.934634181),new ce.Go(58,110.930276),new ce.Go(59,111.92797),new ce.Go(60,112.923644245),new ce.Go(61,113.92185),new ce.Go(62,114.918272),new ce.Go(63,115.916735014),new ce.Go(64,116.913647692),new ce.Go(65,117.91337523),new ce.Go(66,118.910180837),new ce.Go(67,119.910047843),new ce.Go(68,120.907366063),new ce.Go(69,121.907592451),new ce.Go(70,122.905597944),new ce.Go(71,123.906211423),new ce.Go(72,124.90462415),new ce.Go(73,125.905619387),new ce.Go(74,126.90446842),new ce.Go(75,127.905805254),new ce.Go(76,128.904987487),new ce.Go(77,129.906674018),new ce.Go(78,130.906124168),new ce.Go(79,131.907994525),new ce.Go(80,132.907806465),new ce.Go(81,133.909876552),new ce.Go(82,134.91005031),new ce.Go(83,135.914655105),new ce.Go(84,136.917872653),new ce.Go(85,137.922383666),new ce.Go(86,138.926093402),new ce.Go(87,139.93121),new ce.Go(88,140.93483),new ce.Go(89,141.94018),new ce.Go(90,142.94407),new ce.Go(91,143.94961)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(56,109.944476),new ce.Go(57,110.941632),new ce.Go(58,111.93566535),new ce.Go(59,112.933382836),new ce.Go(60,113.928145),new ce.Go(61,114.926979032),new ce.Go(62,115.921394197),new ce.Go(63,116.920564355),new ce.Go(64,117.91657092),new ce.Go(65,118.915554295),new ce.Go(66,119.91215199),new ce.Go(67,120.911386497),new ce.Go(68,121.908548396),new ce.Go(69,122.908470748),new ce.Go(70,123.905895774),new ce.Go(71,124.906398236),new ce.Go(72,125.904268868),new ce.Go(73,126.905179581),new ce.Go(74,127.903530436),new ce.Go(75,128.904779458),new ce.Go(76,129.903507903),new ce.Go(77,130.90508192),new ce.Go(78,131.904154457),new ce.Go(79,132.90590566),new ce.Go(80,133.905394504),new ce.Go(81,134.907207499),new ce.Go(82,135.907219526),new ce.Go(83,136.911562939),new ce.Go(84,137.913988549),new ce.Go(85,138.918786859),new ce.Go(86,139.921635665),new ce.Go(87,140.926646282),new ce.Go(88,141.929702981),new ce.Go(89,142.93489),new ce.Go(90,143.93823),new ce.Go(91,144.94367),new ce.Go(92,145.9473),new ce.Go(93,146.95301)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(57,111.950331),new ce.Go(58,112.944535512),new ce.Go(59,113.940841319),new ce.Go(60,114.935939),new ce.Go(61,115.932914152),new ce.Go(62,116.928639484),new ce.Go(63,117.926554883),new ce.Go(64,118.922370879),new ce.Go(65,119.920678219),new ce.Go(66,120.917183637),new ce.Go(67,121.916121946),new ce.Go(68,122.912990168),new ce.Go(69,123.912245731),new ce.Go(70,124.909724871),new ce.Go(71,125.909447953),new ce.Go(72,126.9074176),new ce.Go(73,127.907747919),new ce.Go(74,128.906063369),new ce.Go(75,129.906706163),new ce.Go(76,130.905460232),new ce.Go(77,131.906429799),new ce.Go(78,132.90544687),new ce.Go(79,133.906713419),new ce.Go(80,134.905971903),new ce.Go(81,135.907305741),new ce.Go(82,136.907083505),new ce.Go(83,137.911010537),new ce.Go(84,138.913357921),new ce.Go(85,139.917277075),new ce.Go(86,140.920043984),new ce.Go(87,141.924292317),new ce.Go(88,142.927330292),new ce.Go(89,143.932027373),new ce.Go(90,144.935388226),new ce.Go(91,145.940162028),new ce.Go(92,146.943864435),new ce.Go(93,147.948899539),new ce.Go(94,148.95272),new ce.Go(95,149.95797),new ce.Go(96,150.962)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(58,113.950941),new ce.Go(59,114.94771),new ce.Go(60,115.94168),new ce.Go(61,116.937700229),new ce.Go(62,117.93344),new ce.Go(63,118.931051927),new ce.Go(64,119.926045941),new ce.Go(65,120.924485908),new ce.Go(66,121.92026),new ce.Go(67,122.91885),new ce.Go(68,123.915088437),new ce.Go(69,124.914620234),new ce.Go(70,125.911244146),new ce.Go(71,126.911121328),new ce.Go(72,127.90830887),new ce.Go(73,128.908673749),new ce.Go(74,129.906310478),new ce.Go(75,130.906930798),new ce.Go(76,131.905056152),new ce.Go(77,132.906002368),new ce.Go(78,133.904503347),new ce.Go(79,134.905682749),new ce.Go(80,135.904570109),new ce.Go(81,136.905821414),new ce.Go(82,137.905241273),new ce.Go(83,138.908835384),new ce.Go(84,139.910599485),new ce.Go(85,140.914406439),new ce.Go(86,141.916448175),new ce.Go(87,142.920617184),new ce.Go(88,143.922940468),new ce.Go(89,144.926923807),new ce.Go(90,145.930106645),new ce.Go(91,146.933992519),new ce.Go(92,147.937682377),new ce.Go(93,148.94246),new ce.Go(94,149.94562),new ce.Go(95,150.9507),new ce.Go(96,151.95416),new ce.Go(97,152.95961)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(60,116.95001),new ce.Go(61,117.94657),new ce.Go(62,118.94099),new ce.Go(63,119.93807),new ce.Go(64,120.93301),new ce.Go(65,121.93071),new ce.Go(66,122.92624),new ce.Go(67,123.92453),new ce.Go(68,124.92067),new ce.Go(69,125.91937),new ce.Go(70,126.91616),new ce.Go(71,127.91544794),new ce.Go(72,128.912667334),new ce.Go(73,129.91232),new ce.Go(74,130.910108489),new ce.Go(75,131.910110399),new ce.Go(76,132.908396372),new ce.Go(77,133.908489607),new ce.Go(78,134.906971003),new ce.Go(79,135.907651181),new ce.Go(80,136.906465656),new ce.Go(81,137.907106826),new ce.Go(82,138.90634816),new ce.Go(83,139.909472552),new ce.Go(84,140.910957016),new ce.Go(85,141.914074489),new ce.Go(86,142.916058646),new ce.Go(87,143.919591666),new ce.Go(88,144.92163837),new ce.Go(89,145.925700146),new ce.Go(90,146.927819639),new ce.Go(91,147.932191197),new ce.Go(92,148.93437),new ce.Go(93,149.93857),new ce.Go(94,150.94156),new ce.Go(95,151.94611),new ce.Go(96,152.94945),new ce.Go(97,153.9544),new ce.Go(98,154.95813)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(61,118.95276),new ce.Go(62,119.94664),new ce.Go(63,120.94367),new ce.Go(64,121.93801),new ce.Go(65,122.93551),new ce.Go(66,123.93052),new ce.Go(67,124.92854),new ce.Go(68,125.9241),new ce.Go(69,126.92275),new ce.Go(70,127.91887),new ce.Go(71,128.918679183),new ce.Go(72,129.914339361),new ce.Go(73,130.914424137),new ce.Go(74,131.91149),new ce.Go(75,132.91155),new ce.Go(76,133.909026379),new ce.Go(77,134.909145555),new ce.Go(78,135.907143574),new ce.Go(79,136.907777634),new ce.Go(80,137.905985574),new ce.Go(81,138.906646605),new ce.Go(82,139.905434035),new ce.Go(83,140.908271103),new ce.Go(84,141.909239733),new ce.Go(85,142.912381158),new ce.Go(86,143.913642686),new ce.Go(87,144.917227871),new ce.Go(88,145.918689722),new ce.Go(89,146.922510962),new ce.Go(90,147.924394738),new ce.Go(91,148.928289207),new ce.Go(92,149.930226399),new ce.Go(93,150.93404),new ce.Go(94,151.93638),new ce.Go(95,152.94058),new ce.Go(96,153.94332),new ce.Go(97,154.94804),new ce.Go(98,155.95126),new ce.Go(99,156.95634)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(62,120.955364),new ce.Go(63,121.95165),new ce.Go(64,122.94596),new ce.Go(65,123.94296),new ce.Go(66,124.93783),new ce.Go(67,125.93531),new ce.Go(68,126.93083),new ce.Go(69,127.9288),new ce.Go(70,128.92486),new ce.Go(71,129.92338),new ce.Go(72,130.920060245),new ce.Go(73,131.91912),new ce.Go(74,132.9162),new ce.Go(75,133.915672),new ce.Go(76,134.91313914),new ce.Go(77,135.912646935),new ce.Go(78,136.910678351),new ce.Go(79,137.910748891),new ce.Go(80,138.908932181),new ce.Go(81,139.909071204),new ce.Go(82,140.907647726),new ce.Go(83,141.910039865),new ce.Go(84,142.910812233),new ce.Go(85,143.913300595),new ce.Go(86,144.914506897),new ce.Go(87,145.917588016),new ce.Go(88,146.918979001),new ce.Go(89,147.922183237),new ce.Go(90,148.923791056),new ce.Go(91,149.926995031),new ce.Go(92,150.928227869),new ce.Go(93,151.9316),new ce.Go(94,152.93365),new ce.Go(95,153.93739),new ce.Go(96,154.93999),new ce.Go(97,155.94412),new ce.Go(98,156.94717),new ce.Go(99,157.95178),new ce.Go(100,158.95523)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(66,125.94307),new ce.Go(67,126.9405),new ce.Go(68,127.93539),new ce.Go(69,128.932385),new ce.Go(70,129.92878),new ce.Go(71,130.927102697),new ce.Go(72,131.92312),new ce.Go(73,132.92221),new ce.Go(74,133.918645),new ce.Go(75,134.91824),new ce.Go(76,135.915020542),new ce.Go(77,136.91463973),new ce.Go(78,137.91291745),new ce.Go(79,138.91192415),new ce.Go(80,139.909309824),new ce.Go(81,140.9096048),new ce.Go(82,141.907718643),new ce.Go(83,142.909809626),new ce.Go(84,143.910082629),new ce.Go(85,144.912568847),new ce.Go(86,145.913112139),new ce.Go(87,146.916095794),new ce.Go(88,147.916888516),new ce.Go(89,148.92014419),new ce.Go(90,149.920886563),new ce.Go(91,150.923824739),new ce.Go(92,151.924682428),new ce.Go(93,152.927694534),new ce.Go(94,153.929483295),new ce.Go(95,154.932629551),new ce.Go(96,155.9352),new ce.Go(97,156.93927),new ce.Go(98,157.94187),new ce.Go(99,158.94639),new ce.Go(100,159.94939),new ce.Go(101,160.95433)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(67,127.94826),new ce.Go(68,128.94316),new ce.Go(69,129.94045),new ce.Go(70,130.9358),new ce.Go(71,131.93375),new ce.Go(72,132.92972),new ce.Go(73,133.92849),new ce.Go(74,134.924617),new ce.Go(75,135.923447865),new ce.Go(76,136.920713),new ce.Go(77,137.920432261),new ce.Go(78,138.916759814),new ce.Go(79,139.915801649),new ce.Go(80,140.913606636),new ce.Go(81,141.912950738),new ce.Go(82,142.910927571),new ce.Go(83,143.912585768),new ce.Go(84,144.912743879),new ce.Go(85,145.914692165),new ce.Go(86,146.915133898),new ce.Go(87,147.917467786),new ce.Go(88,148.918329195),new ce.Go(89,149.920979477),new ce.Go(90,150.921202693),new ce.Go(91,151.923490557),new ce.Go(92,152.924113189),new ce.Go(93,153.926547019),new ce.Go(94,154.928097047),new ce.Go(95,155.931060357),new ce.Go(96,156.9332),new ce.Go(97,157.93669),new ce.Go(98,158.93913),new ce.Go(99,159.94299),new ce.Go(100,160.94586),new ce.Go(101,161.95029),new ce.Go(102,162.95352)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(68,129.94863),new ce.Go(69,130.94589),new ce.Go(70,131.94082),new ce.Go(71,132.93873),new ce.Go(72,133.93402),new ce.Go(73,134.93235),new ce.Go(74,135.9283),new ce.Go(75,136.927046709),new ce.Go(76,137.92354),new ce.Go(77,138.922302),new ce.Go(78,139.918991),new ce.Go(79,140.918468512),new ce.Go(80,141.915193274),new ce.Go(81,142.914623555),new ce.Go(82,143.91199473),new ce.Go(83,144.913405611),new ce.Go(84,145.91303676),new ce.Go(85,146.914893275),new ce.Go(86,147.914817914),new ce.Go(87,148.917179521),new ce.Go(88,149.917271454),new ce.Go(89,150.919928351),new ce.Go(90,151.919728244),new ce.Go(91,152.922093907),new ce.Go(92,153.922205303),new ce.Go(93,154.92463594),new ce.Go(94,155.925526236),new ce.Go(95,156.928354506),new ce.Go(96,157.929987938),new ce.Go(97,158.9332),new ce.Go(98,159.93514),new ce.Go(99,160.93883),new ce.Go(100,161.94122),new ce.Go(101,162.94536),new ce.Go(102,163.94828),new ce.Go(103,164.95298)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(69,131.95416),new ce.Go(70,132.9489),new ce.Go(71,133.94632),new ce.Go(72,134.94172),new ce.Go(73,135.9395),new ce.Go(74,136.93521),new ce.Go(75,137.93345),new ce.Go(76,138.92882915),new ce.Go(77,139.928083921),new ce.Go(78,140.924885867),new ce.Go(79,141.923400033),new ce.Go(80,142.920286634),new ce.Go(81,143.918774116),new ce.Go(82,144.916261285),new ce.Go(83,145.917199714),new ce.Go(84,146.916741206),new ce.Go(85,147.918153775),new ce.Go(86,148.917925922),new ce.Go(87,149.919698294),new ce.Go(88,150.919846022),new ce.Go(89,151.921740399),new ce.Go(90,152.921226219),new ce.Go(91,153.922975386),new ce.Go(92,154.922889429),new ce.Go(93,155.924750855),new ce.Go(94,156.925419435),new ce.Go(95,157.927841923),new ce.Go(96,158.9290845),new ce.Go(97,159.931460406),new ce.Go(98,160.93368),new ce.Go(99,161.93704),new ce.Go(100,162.93921),new ce.Go(101,163.94299),new ce.Go(102,164.94572),new ce.Go(103,165.94997),new ce.Go(104,166.95305)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(72,135.94707),new ce.Go(73,136.94465),new ce.Go(74,137.93997),new ce.Go(75,138.93808),new ce.Go(76,139.933236934),new ce.Go(77,140.93221),new ce.Go(78,141.927908919),new ce.Go(79,142.926738636),new ce.Go(80,143.923390357),new ce.Go(81,144.921687498),new ce.Go(82,145.918305344),new ce.Go(83,146.919089446),new ce.Go(84,147.918109771),new ce.Go(85,148.919336427),new ce.Go(86,149.918655455),new ce.Go(87,150.920344273),new ce.Go(88,151.919787882),new ce.Go(89,152.921746283),new ce.Go(90,153.920862271),new ce.Go(91,154.922618801),new ce.Go(92,155.922119552),new ce.Go(93,156.923956686),new ce.Go(94,157.924100533),new ce.Go(95,158.926385075),new ce.Go(96,159.927050616),new ce.Go(97,160.929665688),new ce.Go(98,161.930981211),new ce.Go(99,162.93399),new ce.Go(100,163.93586),new ce.Go(101,164.93938),new ce.Go(102,165.9416),new ce.Go(103,166.94557),new ce.Go(104,167.94836),new ce.Go(105,168.95287)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(73,137.95287),new ce.Go(74,138.94803),new ce.Go(75,139.945367985),new ce.Go(76,140.94116),new ce.Go(77,141.939073781),new ce.Go(78,142.93475),new ce.Go(79,143.93253),new ce.Go(80,144.92888),new ce.Go(81,145.927180629),new ce.Go(82,146.924037176),new ce.Go(83,147.924298636),new ce.Go(84,148.92324163),new ce.Go(85,149.923654158),new ce.Go(86,150.923098169),new ce.Go(87,151.924071324),new ce.Go(88,152.923430858),new ce.Go(89,153.924686236),new ce.Go(90,154.923500411),new ce.Go(91,155.924743749),new ce.Go(92,156.924021155),new ce.Go(93,157.92541026),new ce.Go(94,158.925343135),new ce.Go(95,159.927164021),new ce.Go(96,160.927566289),new ce.Go(97,161.929484803),new ce.Go(98,162.930643942),new ce.Go(99,163.933347253),new ce.Go(100,164.93488),new ce.Go(101,165.93805),new ce.Go(102,166.94005),new ce.Go(103,167.94364),new ce.Go(104,168.94622),new ce.Go(105,169.95025),new ce.Go(106,170.9533)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(74,139.95379),new ce.Go(75,140.95119),new ce.Go(76,141.946695946),new ce.Go(77,142.94383),new ce.Go(78,143.93907),new ce.Go(79,144.936717),new ce.Go(80,145.932720118),new ce.Go(81,146.930878496),new ce.Go(82,147.927177882),new ce.Go(83,148.927333981),new ce.Go(84,149.925579728),new ce.Go(85,150.92617963),new ce.Go(86,151.924713874),new ce.Go(87,152.925760865),new ce.Go(88,153.924422046),new ce.Go(89,154.92574895),new ce.Go(90,155.924278273),new ce.Go(91,156.925461256),new ce.Go(92,157.924404637),new ce.Go(93,158.92573566),new ce.Go(94,159.925193718),new ce.Go(95,160.926929595),new ce.Go(96,161.926794731),new ce.Go(97,162.928727532),new ce.Go(98,163.929171165),new ce.Go(99,164.931699828),new ce.Go(100,165.932803241),new ce.Go(101,166.935649025),new ce.Go(102,167.93723),new ce.Go(103,168.940303648),new ce.Go(104,169.94267),new ce.Go(105,170.94648),new ce.Go(106,171.94911),new ce.Go(107,172.95344)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(75,141.95986),new ce.Go(76,142.95469),new ce.Go(77,143.95164),new ce.Go(78,144.94688),new ce.Go(79,145.9441),new ce.Go(80,146.93984),new ce.Go(81,147.937269),new ce.Go(82,148.933789944),new ce.Go(83,149.932760914),new ce.Go(84,150.931680791),new ce.Go(85,151.931740598),new ce.Go(86,152.930194506),new ce.Go(87,153.930596268),new ce.Go(88,154.929079084),new ce.Go(89,155.929001869),new ce.Go(90,156.928188059),new ce.Go(91,157.92894573),new ce.Go(92,158.927708537),new ce.Go(93,159.928725679),new ce.Go(94,160.927851662),new ce.Go(95,161.92909242),new ce.Go(96,162.928730286),new ce.Go(97,163.930230577),new ce.Go(98,164.930319169),new ce.Go(99,165.932281267),new ce.Go(100,166.933126195),new ce.Go(101,167.935496424),new ce.Go(102,168.936868306),new ce.Go(103,169.939614951),new ce.Go(104,170.941461227),new ce.Go(105,171.94482),new ce.Go(106,172.94729),new ce.Go(107,173.95115),new ce.Go(108,174.95405)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(76,143.96059),new ce.Go(77,144.95746),new ce.Go(78,145.95212),new ce.Go(79,146.94931),new ce.Go(80,147.94444),new ce.Go(81,148.942780527),new ce.Go(82,149.937171034),new ce.Go(83,150.93746),new ce.Go(84,151.935078452),new ce.Go(85,152.935093125),new ce.Go(86,153.932777294),new ce.Go(87,154.933204273),new ce.Go(88,155.931015001),new ce.Go(89,156.931945517),new ce.Go(90,157.929912),new ce.Go(91,158.930680718),new ce.Go(92,159.929078924),new ce.Go(93,160.930001348),new ce.Go(94,161.928774923),new ce.Go(95,162.930029273),new ce.Go(96,163.929196996),new ce.Go(97,164.9307228),new ce.Go(98,165.93028997),new ce.Go(99,166.932045448),new ce.Go(100,167.932367781),new ce.Go(101,168.934588082),new ce.Go(102,169.935460334),new ce.Go(103,170.938025885),new ce.Go(104,171.939352149),new ce.Go(105,172.9424),new ce.Go(106,173.94434),new ce.Go(107,174.94793),new ce.Go(108,175.95029),new ce.Go(109,176.95437)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(77,145.966495),new ce.Go(78,146.961081),new ce.Go(79,147.95755),new ce.Go(80,148.95265),new ce.Go(81,149.94967),new ce.Go(82,150.944842),new ce.Go(83,151.9443),new ce.Go(84,152.942027631),new ce.Go(85,153.940832325),new ce.Go(86,154.939191562),new ce.Go(87,155.939006895),new ce.Go(88,156.936756069),new ce.Go(89,157.936996),new ce.Go(90,158.934808966),new ce.Go(91,159.935090772),new ce.Go(92,160.933398042),new ce.Go(93,161.933970147),new ce.Go(94,162.932647648),new ce.Go(95,163.933450972),new ce.Go(96,164.932432463),new ce.Go(97,165.933553133),new ce.Go(98,166.932848844),new ce.Go(99,167.934170375),new ce.Go(100,168.934211117),new ce.Go(101,169.935797877),new ce.Go(102,170.936425817),new ce.Go(103,171.938396118),new ce.Go(104,172.939600336),new ce.Go(105,173.942164618),new ce.Go(106,174.943832897),new ce.Go(107,175.946991412),new ce.Go(108,176.94904),new ce.Go(109,177.95264),new ce.Go(110,178.95534)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(78,147.96676),new ce.Go(79,148.96348),new ce.Go(80,149.95799),new ce.Go(81,150.954657965),new ce.Go(82,151.950167),new ce.Go(83,152.94921),new ce.Go(84,153.945651145),new ce.Go(85,154.945792),new ce.Go(86,155.942847109),new ce.Go(87,156.94265865),new ce.Go(88,157.939857897),new ce.Go(89,158.940153735),new ce.Go(90,159.93756),new ce.Go(91,160.937357719),new ce.Go(92,161.93575),new ce.Go(93,162.936265492),new ce.Go(94,163.93452),new ce.Go(95,164.935397592),new ce.Go(96,165.933879623),new ce.Go(97,166.934946862),new ce.Go(98,167.933894465),new ce.Go(99,168.93518712),new ce.Go(100,169.934758652),new ce.Go(101,170.936322297),new ce.Go(102,171.936377696),new ce.Go(103,172.938206756),new ce.Go(104,173.938858101),new ce.Go(105,174.941272494),new ce.Go(106,175.942568409),new ce.Go(107,176.945257126),new ce.Go(108,177.946643396),new ce.Go(109,178.95017),new ce.Go(110,179.95233),new ce.Go(111,180.95615)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(79,149.972668),new ce.Go(80,150.967147),new ce.Go(81,151.96361),new ce.Go(82,152.95869),new ce.Go(83,153.9571),new ce.Go(84,154.953641324),new ce.Go(85,155.952907),new ce.Go(86,156.950101536),new ce.Go(87,157.948577981),new ce.Go(88,158.946615113),new ce.Go(89,159.945383),new ce.Go(90,160.943047504),new ce.Go(91,161.943222),new ce.Go(92,162.941203796),new ce.Go(93,163.941215),new ce.Go(94,164.939605886),new ce.Go(95,165.939762646),new ce.Go(96,166.938307056),new ce.Go(97,167.938698576),new ce.Go(98,168.937648757),new ce.Go(99,169.93847219),new ce.Go(100,170.937909903),new ce.Go(101,171.939082239),new ce.Go(102,172.938926901),new ce.Go(103,173.940333522),new ce.Go(104,174.940767904),new ce.Go(105,175.942682399),new ce.Go(106,176.943754987),new ce.Go(107,177.945951366),new ce.Go(108,178.947324216),new ce.Go(109,179.949879968),new ce.Go(110,180.95197),new ce.Go(111,181.95521),new ce.Go(112,182.95757),new ce.Go(113,183.96117)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(82,153.96425),new ce.Go(83,154.96276),new ce.Go(84,155.959247),new ce.Go(85,156.958127),new ce.Go(86,157.95405528),new ce.Go(87,158.954003),new ce.Go(88,159.950713588),new ce.Go(89,160.950330852),new ce.Go(90,161.947202977),new ce.Go(91,162.947057),new ce.Go(92,163.944422),new ce.Go(93,164.94454),new ce.Go(94,165.94225),new ce.Go(95,166.9426),new ce.Go(96,167.94063),new ce.Go(97,168.941158567),new ce.Go(98,169.93965),new ce.Go(99,170.94049),new ce.Go(100,171.93945798),new ce.Go(101,172.94065),new ce.Go(102,173.940040159),new ce.Go(103,174.941502991),new ce.Go(104,175.941401828),new ce.Go(105,176.943220013),new ce.Go(106,177.943697732),new ce.Go(107,178.945815073),new ce.Go(108,179.94654876),new ce.Go(109,180.949099124),new ce.Go(110,181.950552893),new ce.Go(111,182.953531012),new ce.Go(112,183.95544788),new ce.Go(113,184.95878),new ce.Go(114,185.96092)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(83,155.971689),new ce.Go(84,156.968145),new ce.Go(85,157.966368),new ce.Go(86,158.96232309),new ce.Go(87,159.961358),new ce.Go(88,160.958372992),new ce.Go(89,161.956556553),new ce.Go(90,162.95431665),new ce.Go(91,163.95357),new ce.Go(92,164.950817),new ce.Go(93,165.95047),new ce.Go(94,166.948639),new ce.Go(95,167.947787),new ce.Go(96,168.94592),new ce.Go(97,169.94609),new ce.Go(98,170.94446),new ce.Go(99,171.944739818),new ce.Go(100,172.94459),new ce.Go(101,173.944167937),new ce.Go(102,174.94365),new ce.Go(103,175.944740551),new ce.Go(104,176.944471766),new ce.Go(105,177.945750349),new ce.Go(106,178.945934113),new ce.Go(107,179.947465655),new ce.Go(108,180.947996346),new ce.Go(109,181.950152414),new ce.Go(110,182.951373188),new ce.Go(111,183.954009331),new ce.Go(112,184.955559086),new ce.Go(113,185.9585501),new ce.Go(114,186.96041),new ce.Go(115,187.96371)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(84,157.973939),new ce.Go(85,158.97228),new ce.Go(86,159.968369),new ce.Go(87,160.967089),new ce.Go(88,161.962750303),new ce.Go(89,162.962532),new ce.Go(90,163.95898381),new ce.Go(91,164.958335962),new ce.Go(92,165.955019896),new ce.Go(93,166.954672),new ce.Go(94,167.951863),new ce.Go(95,168.951759),new ce.Go(96,169.948473988),new ce.Go(97,170.94946),new ce.Go(98,171.948228837),new ce.Go(99,172.948884),new ce.Go(100,173.94616),new ce.Go(101,174.94677),new ce.Go(102,175.94559),new ce.Go(103,176.94662),new ce.Go(104,177.945848364),new ce.Go(105,178.947071733),new ce.Go(106,179.946705734),new ce.Go(107,180.948198054),new ce.Go(108,181.948205519),new ce.Go(109,182.950224458),new ce.Go(110,183.950932553),new ce.Go(111,184.953420586),new ce.Go(112,185.954362204),new ce.Go(113,186.957158365),new ce.Go(114,187.958486954),new ce.Go(115,188.96191222),new ce.Go(116,189.963179541)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(85,159.981485),new ce.Go(86,160.977661),new ce.Go(87,161.975707),new ce.Go(88,162.971375872),new ce.Go(89,163.970319),new ce.Go(90,164.967050268),new ce.Go(91,165.965211372),new ce.Go(92,166.962564),new ce.Go(93,167.961609),new ce.Go(94,168.95883),new ce.Go(95,169.958163),new ce.Go(96,170.955547),new ce.Go(97,171.955285),new ce.Go(98,172.953062),new ce.Go(99,173.952114),new ce.Go(100,174.951393),new ce.Go(101,175.95157),new ce.Go(102,176.95027),new ce.Go(103,177.950851081),new ce.Go(104,178.949981038),new ce.Go(105,179.95078768),new ce.Go(106,180.950064596),new ce.Go(107,181.951211444),new ce.Go(108,182.950821349),new ce.Go(109,183.952524289),new ce.Go(110,184.952955747),new ce.Go(111,185.954986529),new ce.Go(112,186.955750787),new ce.Go(113,187.958112287),new ce.Go(114,188.959228359),new ce.Go(115,189.961816139),new ce.Go(116,190.963123592),new ce.Go(117,191.96596)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(86,161.983819),new ce.Go(87,162.982048),new ce.Go(88,163.977927),new ce.Go(89,164.976475),new ce.Go(90,165.971934911),new ce.Go(91,166.971554),new ce.Go(92,167.967832911),new ce.Go(93,168.967076205),new ce.Go(94,169.963569716),new ce.Go(95,170.96304),new ce.Go(96,171.960078),new ce.Go(97,172.959791),new ce.Go(98,173.956307704),new ce.Go(99,174.95708),new ce.Go(100,175.953757941),new ce.Go(101,176.955045),new ce.Go(102,177.953348225),new ce.Go(103,178.953951),new ce.Go(104,179.952308241),new ce.Go(105,180.953274494),new ce.Go(106,181.952186222),new ce.Go(107,182.95311),new ce.Go(108,183.952490808),new ce.Go(109,184.954043023),new ce.Go(110,185.953838355),new ce.Go(111,186.955747928),new ce.Go(112,187.955835993),new ce.Go(113,188.958144866),new ce.Go(114,189.95844521),new ce.Go(115,190.960927951),new ce.Go(116,191.961479047),new ce.Go(117,192.964148083),new ce.Go(118,193.965179314),new ce.Go(119,194.968123889),new ce.Go(120,195.96962255)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(88,164.98758),new ce.Go(89,165.985506),new ce.Go(90,166.980951577),new ce.Go(91,167.979966),new ce.Go(92,168.976390868),new ce.Go(93,169.974441697),new ce.Go(94,170.971779),new ce.Go(95,171.970643),new ce.Go(96,172.967707),new ce.Go(97,173.966804),new ce.Go(98,174.964279),new ce.Go(99,175.963511),new ce.Go(100,176.96117),new ce.Go(101,177.960084944),new ce.Go(102,178.95915),new ce.Go(103,179.958555615),new ce.Go(104,180.957642156),new ce.Go(105,181.958127689),new ce.Go(106,182.956814),new ce.Go(107,183.957388318),new ce.Go(108,184.95659),new ce.Go(109,185.957951104),new ce.Go(110,186.95736083),new ce.Go(111,187.958851962),new ce.Go(112,188.958716473),new ce.Go(113,189.960592299),new ce.Go(114,190.960591191),new ce.Go(115,191.962602198),new ce.Go(116,192.9629237),new ce.Go(117,193.96507561),new ce.Go(118,194.9659768),new ce.Go(119,195.968379906),new ce.Go(120,196.969636496),new ce.Go(121,197.97228),new ce.Go(122,198.973787159)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(90,167.988035),new ce.Go(91,168.986421),new ce.Go(92,169.981734918),new ce.Go(93,170.981251),new ce.Go(94,171.977376138),new ce.Go(95,172.976499642),new ce.Go(96,173.972811276),new ce.Go(97,174.972276),new ce.Go(98,175.969),new ce.Go(99,176.968453),new ce.Go(100,177.964894223),new ce.Go(101,178.965475),new ce.Go(102,179.962023729),new ce.Go(103,180.963177),new ce.Go(104,181.961267637),new ce.Go(105,182.961729),new ce.Go(106,183.959851685),new ce.Go(107,184.960753782),new ce.Go(108,185.959432346),new ce.Go(109,186.960697),new ce.Go(110,187.959395697),new ce.Go(111,188.9608319),new ce.Go(112,189.959930073),new ce.Go(113,190.961684653),new ce.Go(114,191.961035158),new ce.Go(115,192.962984504),new ce.Go(116,193.962663581),new ce.Go(117,194.964774449),new ce.Go(118,195.964934884),new ce.Go(119,196.967323401),new ce.Go(120,197.967876009),new ce.Go(121,198.970576213),new ce.Go(122,199.971423885),new ce.Go(123,200.974496467),new ce.Go(124,201.97574)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(92,170.991183),new ce.Go(93,171.990109),new ce.Go(94,172.986398138),new ce.Go(95,173.984325861),new ce.Go(96,174.981552),new ce.Go(97,175.980269),new ce.Go(98,176.977215),new ce.Go(99,177.975975),new ce.Go(100,178.973412),new ce.Go(101,179.972396),new ce.Go(102,180.969948),new ce.Go(103,181.968621416),new ce.Go(104,182.96762),new ce.Go(105,183.966776046),new ce.Go(106,184.965806956),new ce.Go(107,185.965997671),new ce.Go(108,186.964562),new ce.Go(109,187.965321662),new ce.Go(110,188.9642243),new ce.Go(111,189.964698757),new ce.Go(112,190.963649239),new ce.Go(113,191.964810107),new ce.Go(114,192.964131745),new ce.Go(115,193.96533889),new ce.Go(116,194.965017928),new ce.Go(117,195.966551315),new ce.Go(118,196.966551609),new ce.Go(119,197.968225244),new ce.Go(120,198.968748016),new ce.Go(121,199.970717886),new ce.Go(122,200.971640839),new ce.Go(123,201.973788431),new ce.Go(124,202.975137256),new ce.Go(125,203.977705),new ce.Go(126,204.97961)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(95,174.991411),new ce.Go(96,175.987413248),new ce.Go(97,176.986336874),new ce.Go(98,177.982476325),new ce.Go(99,178.981783),new ce.Go(100,179.978322),new ce.Go(101,180.977806),new ce.Go(102,181.97393546),new ce.Go(103,182.974561),new ce.Go(104,183.970705219),new ce.Go(105,184.971983),new ce.Go(106,185.969460021),new ce.Go(107,186.969785),new ce.Go(108,187.967511693),new ce.Go(109,188.968733187),new ce.Go(110,189.966958568),new ce.Go(111,190.96706311),new ce.Go(112,191.965921572),new ce.Go(113,192.966644169),new ce.Go(114,193.965381832),new ce.Go(115,194.966638981),new ce.Go(116,195.965814846),new ce.Go(117,196.967195333),new ce.Go(118,197.96675183),new ce.Go(119,198.968262489),new ce.Go(120,199.968308726),new ce.Go(121,200.970285275),new ce.Go(122,201.970625604),new ce.Go(123,202.972857096),new ce.Go(124,203.97347564),new ce.Go(125,204.976056104),new ce.Go(126,205.977498672),new ce.Go(127,206.982577025),new ce.Go(128,207.98594)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(96,176.996881),new ce.Go(97,177.994637),new ce.Go(98,178.991466),new ce.Go(99,179.990194),new ce.Go(100,180.986904),new ce.Go(101,181.98561),new ce.Go(102,182.982697),new ce.Go(103,183.98176),new ce.Go(104,184.9791),new ce.Go(105,185.977549881),new ce.Go(106,186.97617),new ce.Go(107,187.97592),new ce.Go(108,188.974290451),new ce.Go(109,189.974473379),new ce.Go(110,190.972261952),new ce.Go(111,191.972770785),new ce.Go(112,192.970548),new ce.Go(113,193.971053),new ce.Go(114,194.96965),new ce.Go(115,195.970515),new ce.Go(116,196.9695362),new ce.Go(117,197.970466294),new ce.Go(118,198.969813837),new ce.Go(119,199.970945394),new ce.Go(120,200.97080377),new ce.Go(121,201.972090569),new ce.Go(122,202.972329088),new ce.Go(123,203.973848646),new ce.Go(124,204.97441227),new ce.Go(125,205.976095321),new ce.Go(126,206.977407908),new ce.Go(127,207.982004653),new ce.Go(128,208.985349125),new ce.Go(129,209.990065574)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(99,180.996714),new ce.Go(100,181.992676101),new ce.Go(101,182.99193),new ce.Go(102,183.988198),new ce.Go(103,184.98758),new ce.Go(104,185.983485388),new ce.Go(105,186.98403),new ce.Go(106,187.979869108),new ce.Go(107,188.98088),new ce.Go(108,189.978180008),new ce.Go(109,190.9782),new ce.Go(110,191.975719811),new ce.Go(111,192.97608),new ce.Go(112,193.974648056),new ce.Go(113,194.975920279),new ce.Go(114,195.97271),new ce.Go(115,196.97338),new ce.Go(116,197.97198),new ce.Go(117,198.972909384),new ce.Go(118,199.97181556),new ce.Go(119,200.972846589),new ce.Go(120,201.972143786),new ce.Go(121,202.973375491),new ce.Go(122,203.973028761),new ce.Go(123,204.974467112),new ce.Go(124,205.974449002),new ce.Go(125,206.975880605),new ce.Go(126,207.97663585),new ce.Go(127,208.981074801),new ce.Go(128,209.984173129),new ce.Go(129,210.988731474),new ce.Go(130,211.991887495),new ce.Go(131,212.9965),new ce.Go(132,213.999798147)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(102,184.997708),new ce.Go(103,185.99648),new ce.Go(104,186.993458),new ce.Go(105,187.992173),new ce.Go(106,188.989505),new ce.Go(107,189.987520007),new ce.Go(108,190.986053),new ce.Go(109,191.985368),new ce.Go(110,192.983662229),new ce.Go(111,193.983430186),new ce.Go(112,194.98112697),new ce.Go(113,195.981236107),new ce.Go(114,196.978934287),new ce.Go(115,197.979024396),new ce.Go(116,198.977576953),new ce.Go(117,199.978141983),new ce.Go(118,200.976970721),new ce.Go(119,201.977674504),new ce.Go(120,202.976868118),new ce.Go(121,203.977805161),new ce.Go(122,204.977374688),new ce.Go(123,205.978482854),new ce.Go(124,206.978455217),new ce.Go(125,207.979726699),new ce.Go(126,208.980383241),new ce.Go(127,209.984104944),new ce.Go(128,210.987258139),new ce.Go(129,211.991271542),new ce.Go(130,212.994374836),new ce.Go(131,213.998698664),new ce.Go(132,215.001832349),new ce.Go(133,216.006199)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(106,189.994293888),new ce.Go(107,190.994653),new ce.Go(108,191.99033039),new ce.Go(109,192.991102),new ce.Go(110,193.988284107),new ce.Go(111,194.988045),new ce.Go(112,195.985469432),new ce.Go(113,196.985567),new ce.Go(114,197.984024384),new ce.Go(115,198.985044507),new ce.Go(116,199.981735),new ce.Go(117,200.982209),new ce.Go(118,201.980704),new ce.Go(119,202.981412863),new ce.Go(120,203.980307113),new ce.Go(121,204.981165396),new ce.Go(122,205.980465241),new ce.Go(123,206.981578228),new ce.Go(124,207.981231059),new ce.Go(125,208.982415788),new ce.Go(126,209.982857396),new ce.Go(127,210.986636869),new ce.Go(128,211.988851755),new ce.Go(129,212.992842522),new ce.Go(130,213.995185949),new ce.Go(131,214.999414609),new ce.Go(132,216.001905198),new ce.Go(133,217.006253),new ce.Go(134,218.008965773)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(108,193.000188),new ce.Go(109,193.997973),new ce.Go(110,194.996554),new ce.Go(111,195.995702),new ce.Go(112,196.993891293),new ce.Go(113,197.99343368),new ce.Go(114,198.991008569),new ce.Go(115,199.990920883),new ce.Go(116,200.988486908),new ce.Go(117,201.988448629),new ce.Go(118,202.986847216),new ce.Go(119,203.987261559),new ce.Go(120,204.986036352),new ce.Go(121,205.986599242),new ce.Go(122,206.985775861),new ce.Go(123,207.986582508),new ce.Go(124,208.986158678),new ce.Go(125,209.987131308),new ce.Go(126,210.987480806),new ce.Go(127,211.990734657),new ce.Go(128,212.99292115),new ce.Go(129,213.996356412),new ce.Go(130,214.998641245),new ce.Go(131,216.002408839),new ce.Go(132,217.004709619),new ce.Go(133,218.008681458),new ce.Go(134,219.011296478),new ce.Go(135,220.015301),new ce.Go(136,221.01814),new ce.Go(137,222.02233),new ce.Go(138,223.02534)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(110,196.001117268),new ce.Go(111,197.001661),new ce.Go(112,197.998779978),new ce.Go(113,198.998309),new ce.Go(114,199.995634148),new ce.Go(115,200.995535),new ce.Go(116,201.993899382),new ce.Go(117,202.994765192),new ce.Go(118,203.991365),new ce.Go(119,204.991668),new ce.Go(120,205.99016),new ce.Go(121,206.990726826),new ce.Go(122,207.989631237),new ce.Go(123,208.990376634),new ce.Go(124,209.989679862),new ce.Go(125,210.99058541),new ce.Go(126,211.990688899),new ce.Go(127,212.993868354),new ce.Go(128,213.995346275),new ce.Go(129,214.998729195),new ce.Go(130,216.000258153),new ce.Go(131,217.003914555),new ce.Go(132,218.005586315),new ce.Go(133,219.009474831),new ce.Go(134,220.011384149),new ce.Go(135,221.015455),new ce.Go(136,222.017570472),new ce.Go(137,223.02179),new ce.Go(138,224.02409),new ce.Go(139,225.02844),new ce.Go(140,226.03089),new ce.Go(141,227.035407),new ce.Go(142,228.038084)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(113,200.006499),new ce.Go(114,201.00458692),new ce.Go(115,202.00396885),new ce.Go(116,203.001423829),new ce.Go(117,204.001221209),new ce.Go(118,204.998663961),new ce.Go(119,205.998486886),new ce.Go(120,206.996859385),new ce.Go(121,207.997133849),new ce.Go(122,208.995915421),new ce.Go(123,209.996398327),new ce.Go(124,210.995529332),new ce.Go(125,211.996194988),new ce.Go(126,212.996174845),new ce.Go(127,213.99895474),new ce.Go(128,215.000326029),new ce.Go(129,216.003187873),new ce.Go(130,217.004616452),new ce.Go(131,218.007563326),new ce.Go(132,219.009240843),new ce.Go(133,220.012312978),new ce.Go(134,221.014245654),new ce.Go(135,222.017543957),new ce.Go(136,223.019730712),new ce.Go(137,224.023235513),new ce.Go(138,225.025606914),new ce.Go(139,226.029343423),new ce.Go(140,227.031833167),new ce.Go(141,228.034776087),new ce.Go(142,229.038426),new ce.Go(143,230.04251),new ce.Go(144,231.045407),new ce.Go(145,232.049654)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(115,203.00921),new ce.Go(116,204.006434513),new ce.Go(117,205.006187),new ce.Go(118,206.004463814),new ce.Go(119,207.005176607),new ce.Go(120,208.001776),new ce.Go(121,209.001944),new ce.Go(122,210.000446),new ce.Go(123,211.000893996),new ce.Go(124,211.999783492),new ce.Go(125,213.000345847),new ce.Go(126,214.000091141),new ce.Go(127,215.002704195),new ce.Go(128,216.003518402),new ce.Go(129,217.00630601),new ce.Go(130,218.007123948),new ce.Go(131,219.010068787),new ce.Go(132,220.011014669),new ce.Go(133,221.013907762),new ce.Go(134,222.01536182),new ce.Go(135,223.01849714),new ce.Go(136,224.020202004),new ce.Go(137,225.023604463),new ce.Go(138,226.025402555),new ce.Go(139,227.029170677),new ce.Go(140,228.031064101),new ce.Go(141,229.034820309),new ce.Go(142,230.037084774),new ce.Go(143,231.04122),new ce.Go(144,232.043693),new ce.Go(145,233.047995),new ce.Go(146,234.050547)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(118,207.012469754),new ce.Go(119,208.012112949),new ce.Go(120,209.009568736),new ce.Go(121,210.009256802),new ce.Go(122,211.007648196),new ce.Go(123,212.007811441),new ce.Go(124,213.006573689),new ce.Go(125,214.006893072),new ce.Go(126,215.006450832),new ce.Go(127,216.008721268),new ce.Go(128,217.009332676),new ce.Go(129,218.011625045),new ce.Go(130,219.012404918),new ce.Go(131,220.014752105),new ce.Go(132,221.015575746),new ce.Go(133,222.017828852),new ce.Go(134,223.01912603),new ce.Go(135,224.021708435),new ce.Go(136,225.023220576),new ce.Go(137,226.026089848),new ce.Go(138,227.027746979),new ce.Go(139,228.031014825),new ce.Go(140,229.032930871),new ce.Go(141,230.036025144),new ce.Go(142,231.038551503),new ce.Go(143,232.042022474),new ce.Go(144,233.04455),new ce.Go(145,234.04842),new ce.Go(146,235.051102),new ce.Go(147,236.055178)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(120,210.015711883),new ce.Go(121,211.016306912),new ce.Go(122,212.012916),new ce.Go(123,213.012962),new ce.Go(124,214.011451),new ce.Go(125,215.011726597),new ce.Go(126,216.011050963),new ce.Go(127,217.013066169),new ce.Go(128,218.013267744),new ce.Go(129,219.015521253),new ce.Go(130,220.015733126),new ce.Go(131,221.018171499),new ce.Go(132,222.018454131),new ce.Go(133,223.020795153),new ce.Go(134,224.02145925),new ce.Go(135,225.023941441),new ce.Go(136,226.024890681),new ce.Go(137,227.027698859),new ce.Go(138,228.028731348),new ce.Go(139,229.03175534),new ce.Go(140,230.033126574),new ce.Go(141,231.03629706),new ce.Go(142,232.03805036),new ce.Go(143,233.041576923),new ce.Go(144,234.043595497),new ce.Go(145,235.04750442),new ce.Go(146,236.04971),new ce.Go(147,237.053894),new ce.Go(148,238.056243)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(122,213.021183209),new ce.Go(123,214.02073923),new ce.Go(124,215.019097612),new ce.Go(125,216.019109649),new ce.Go(126,217.018288571),new ce.Go(127,218.020007906),new ce.Go(128,219.019880348),new ce.Go(129,220.021876493),new ce.Go(130,221.021863742),new ce.Go(131,222.023726),new ce.Go(132,223.023963748),new ce.Go(133,224.025614854),new ce.Go(134,225.026115172),new ce.Go(135,226.02793275),new ce.Go(136,227.028793151),new ce.Go(137,228.031036942),new ce.Go(138,229.032088601),new ce.Go(139,230.034532562),new ce.Go(140,231.035878898),new ce.Go(141,232.03858172),new ce.Go(142,233.040240235),new ce.Go(143,234.043302325),new ce.Go(144,235.045436759),new ce.Go(145,236.048675176),new ce.Go(146,237.05113943),new ce.Go(147,238.054497046),new ce.Go(148,239.05713),new ce.Go(149,240.06098)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(126,218.023487),new ce.Go(127,219.024915423),new ce.Go(128,220.024712),new ce.Go(129,221.026351),new ce.Go(130,222.02607),new ce.Go(131,223.027722956),new ce.Go(132,224.027590139),new ce.Go(133,225.029384369),new ce.Go(134,226.02933975),new ce.Go(135,227.031140069),new ce.Go(136,228.031366357),new ce.Go(137,229.033496137),new ce.Go(138,230.033927392),new ce.Go(139,231.036289158),new ce.Go(140,232.03714628),new ce.Go(141,233.039628196),new ce.Go(142,234.040945606),new ce.Go(143,235.043923062),new ce.Go(144,236.045561897),new ce.Go(145,237.048723955),new ce.Go(146,238.050782583),new ce.Go(147,239.054287777),new ce.Go(148,240.056585734),new ce.Go(149,241.06033),new ce.Go(150,242.062925)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(132,225.033899689),new ce.Go(133,226.035129),new ce.Go(134,227.034958261),new ce.Go(135,228.03618),new ce.Go(136,229.036246866),new ce.Go(137,230.037812591),new ce.Go(138,231.038233161),new ce.Go(139,232.040099),new ce.Go(140,233.04073235),new ce.Go(141,234.042888556),new ce.Go(142,235.044055876),new ce.Go(143,236.046559724),new ce.Go(144,237.048167253),new ce.Go(145,238.050940464),new ce.Go(146,239.052931399),new ce.Go(147,240.056168828),new ce.Go(148,241.058246266),new ce.Go(149,242.061635),new ce.Go(150,243.064273),new ce.Go(151,244.06785)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(134,228.038727686),new ce.Go(135,229.040138934),new ce.Go(136,230.039645603),new ce.Go(137,231.041258),new ce.Go(138,232.041179445),new ce.Go(139,233.04298757),new ce.Go(140,234.043304681),new ce.Go(141,235.0452815),new ce.Go(142,236.046048088),new ce.Go(143,237.048403774),new ce.Go(144,238.0495534),new ce.Go(145,239.052156519),new ce.Go(146,240.05380746),new ce.Go(147,241.056845291),new ce.Go(148,242.058736847),new ce.Go(149,243.061997013),new ce.Go(150,244.06419765),new ce.Go(151,245.067738657),new ce.Go(152,246.070198429),new ce.Go(153,247.07407)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(136,231.04556),new ce.Go(137,232.04659),new ce.Go(138,233.046472),new ce.Go(139,234.047794),new ce.Go(140,235.048029),new ce.Go(141,236.049569),new ce.Go(142,237.049970748),new ce.Go(143,238.051977839),new ce.Go(144,239.053018481),new ce.Go(145,240.055287826),new ce.Go(146,241.056822944),new ce.Go(147,242.059543039),new ce.Go(148,243.061372686),new ce.Go(149,244.064279429),new ce.Go(150,245.066445398),new ce.Go(151,246.069768438),new ce.Go(152,247.072086),new ce.Go(153,248.075745),new ce.Go(154,249.07848)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(137,233.0508),new ce.Go(138,234.05024),new ce.Go(139,235.051591),new ce.Go(140,236.051405),new ce.Go(141,237.052891),new ce.Go(142,238.053016298),new ce.Go(143,239.054951),new ce.Go(144,240.055519046),new ce.Go(145,241.057646736),new ce.Go(146,242.058829326),new ce.Go(147,243.061382249),new ce.Go(148,244.062746349),new ce.Go(149,245.065485586),new ce.Go(150,246.067217551),new ce.Go(151,247.070346811),new ce.Go(152,248.072342247),new ce.Go(153,249.075947062),new ce.Go(154,250.078350687),new ce.Go(155,251.082277873),new ce.Go(156,252.08487)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(138,235.05658),new ce.Go(139,236.05733),new ce.Go(140,237.057127),new ce.Go(141,238.058266),new ce.Go(142,239.058362),new ce.Go(143,240.059749),new ce.Go(144,241.060223),new ce.Go(145,242.06205),new ce.Go(146,243.06300157),new ce.Go(147,244.065167882),new ce.Go(148,245.066355386),new ce.Go(149,246.068666836),new ce.Go(150,247.070298533),new ce.Go(151,248.07308),new ce.Go(152,249.074979937),new ce.Go(153,250.078310529),new ce.Go(154,251.08075344),new ce.Go(155,252.084303),new ce.Go(156,253.08688),new ce.Go(157,254.0906)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(139,237.06207),new ce.Go(140,238.06141),new ce.Go(141,239.062579),new ce.Go(142,240.062295),new ce.Go(143,241.063716),new ce.Go(144,242.063688713),new ce.Go(145,243.065421),new ce.Go(146,244.06599039),new ce.Go(147,245.068039),new ce.Go(148,246.068798807),new ce.Go(149,247.070992043),new ce.Go(150,248.07217808),new ce.Go(151,249.074846818),new ce.Go(152,250.076399951),new ce.Go(153,251.079580056),new ce.Go(154,252.081619582),new ce.Go(155,253.085126791),new ce.Go(156,254.087316198),new ce.Go(157,255.091039),new ce.Go(158,256.09344)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(141,240.06892),new ce.Go(142,241.068662),new ce.Go(143,242.069699),new ce.Go(144,243.069631),new ce.Go(145,244.070969),new ce.Go(146,245.071317),new ce.Go(147,246.072965),new ce.Go(148,247.07365),new ce.Go(149,248.075458),new ce.Go(150,249.076405),new ce.Go(151,250.078654),new ce.Go(152,251.079983592),new ce.Go(153,252.082972247),new ce.Go(154,253.084817974),new ce.Go(155,254.088016026),new ce.Go(156,255.090266386),new ce.Go(157,256.093592),new ce.Go(158,257.095979)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(142,242.07343),new ce.Go(143,243.07451),new ce.Go(144,244.074077),new ce.Go(145,245.075375),new ce.Go(146,246.075281634),new ce.Go(147,247.076819),new ce.Go(148,248.077184411),new ce.Go(149,249.079024),new ce.Go(150,250.079514759),new ce.Go(151,251.081566467),new ce.Go(152,252.082460071),new ce.Go(153,253.085176259),new ce.Go(154,254.086847795),new ce.Go(155,255.089955466),new ce.Go(156,256.091766522),new ce.Go(157,257.095098635),new ce.Go(158,258.097069),new ce.Go(159,259.100588)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(144,245.081017),new ce.Go(145,246.081933),new ce.Go(146,247.081804),new ce.Go(147,248.082909),new ce.Go(148,249.083002),new ce.Go(149,250.084488),new ce.Go(150,251.084919),new ce.Go(151,252.08663),new ce.Go(152,253.08728),new ce.Go(153,254.089725),new ce.Go(154,255.091075196),new ce.Go(155,256.094052757),new ce.Go(156,257.095534643),new ce.Go(157,258.098425321),new ce.Go(158,259.100503),new ce.Go(159,260.103645)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(147,249.087823),new ce.Go(148,250.087493),new ce.Go(149,251.08896),new ce.Go(150,252.088965909),new ce.Go(151,253.090649),new ce.Go(152,254.090948746),new ce.Go(153,255.093232449),new ce.Go(154,256.094275879),new ce.Go(155,257.096852778),new ce.Go(156,258.0982),new ce.Go(157,259.101024),new ce.Go(158,260.102636),new ce.Go(159,261.105743),new ce.Go(160,262.10752)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(148,251.09436),new ce.Go(149,252.09533),new ce.Go(150,253.095258),new ce.Go(151,254.096587),new ce.Go(152,255.096769),new ce.Go(153,256.098763),new ce.Go(154,257.099606),new ce.Go(155,258.101883),new ce.Go(156,259.10299),new ce.Go(157,260.105572),new ce.Go(158,261.106941),new ce.Go(159,262.109692),new ce.Go(160,263.111394)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(149,253.100679),new ce.Go(150,254.100166),new ce.Go(151,255.101492),new ce.Go(152,256.101179573),new ce.Go(153,257.103072),new ce.Go(154,258.103568),new ce.Go(155,259.105628),new ce.Go(156,260.106434),new ce.Go(157,261.108752),new ce.Go(158,262.109918),new ce.Go(159,263.11254),new ce.Go(160,264.113978)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(150,255.107398),new ce.Go(151,256.10811),new ce.Go(152,257.107858),new ce.Go(153,258.109438),new ce.Go(154,259.109721),new ce.Go(155,260.111427),new ce.Go(156,261.112106),new ce.Go(157,262.114153),new ce.Go(158,263.115078),new ce.Go(159,264.117473),new ce.Go(160,265.118659)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(152,258.113151),new ce.Go(153,259.114652),new ce.Go(154,260.114435447),new ce.Go(155,261.116199),new ce.Go(156,262.116477),new ce.Go(157,263.118313),new ce.Go(158,264.118924),new ce.Go(159,265.121066),new ce.Go(160,266.121928)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(153,260.121803),new ce.Go(154,261.1218),new ce.Go(155,262.123009),new ce.Go(156,263.123146),new ce.Go(157,264.12473),new ce.Go(158,265.125198),new ce.Go(159,266.127009),new ce.Go(160,267.12774)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(155,263.12871),new ce.Go(156,264.128408258),new ce.Go(157,265.130001),new ce.Go(158,266.130042),new ce.Go(159,267.131774),new ce.Go(160,268.132156),new ce.Go(161,269.134114)]),Oe($e(re.HK,1),sn,3,0,[new ce.Go(156,265.136567),new ce.Go(157,266.13794),new ce.Go(158,267.137526),new ce.Go(159,268.138816),new ce.Go(160,269.139106),new ce.Go(161,270.140723),new ce.Go(162,271.141229)])])},ce.Jo=function(t,n){var e,o;for(ce.Io(),o=n-t,e=0;e<ce.Ho[t].length;e++)if(ce.Ho[t][e].b==o)return ce.Ho[t][e].a;return NaN},ce.No=function(){ce.No=De,ce.Mo=Oe($e(re.fK,1),ut,5,15,[0,1.00794,4.0026,6.941,9.0122,10.811,12.011,14.007,15.999,18.998,20.18,22.99,24.305,26.982,28.086,30.974,32.066,35.453,39.948,39.098,40.078,44.956,47.867,50.942,51.996,54.938,55.845,58.933,58.693,63.546,65.39,69.723,72.61,74.922,78.96,79.904,83.8,85.468,87.62,88.906,91.224,92.906,95.94,98.906,101.07,102.91,106.42,107.87,112.41,114.82,118.71,121.76,127.6,126.9,131.29,132.91,137.33,138.91,140.12,140.91,144.24,146.92,150.36,151.96,157.25,158.93,162.5,164.93,167.26,168.93,173.04,174.97,178.49,180.95,183.84,186.21,190.23,192.22,195.08,196.97,200.59,204.38,207.2,208.98,209.98,209.99,222.02,223.02,226.03,227.03,232.04,231.04,238.03,237.05,239.05,241.06,244.06,249.08,252.08,252.08,257.1,258.1,259.1,262.11,267.12,268.13,271.13,270.13,277.15,276.15,un,un,283.17,285.18,fn,fn,293.2,ln,ln,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.0141,3.016,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71.0787,156.18828,114.10364,115.0877,103.1447,128.13052,129.11458,57.05182,137.14158,113.15934,113.15934,128.17428,131.19846,147.17646,97.11658,87.0777,101.10458,186.2134,163.17546,99.13246]),ce.Ko=Oe($e(re.fK,1),ut,5,15,[0,1.007825,4.0026,7.016003,9.012182,11.009305,12,14.003074,15.994915,18.998403,19.992435,22.989767,23.985042,26.98153,27.976927,30.973762,31.97207,34.968852,39.962384,38.963707,39.962591,44.95591,47.947947,50.943962,51.940509,54.938047,55.934939,58.933198,57.935346,62.939598,63.929145,68.92558,73.921177,74.921594,79.91652,78.918336,83.911507,84.911794,87.905619,88.905849,89.904703,92.906377,97.905406,89.92381,101.904348,102.9055,105.903478,106.905092,113.903357,114.90388,119.9022,120.903821,129.906229,126.904473,131.904144,132.905429,137.905232,138.906346,139.905433,140.907647,141.907719,135.92398,151.919729,152.921225,157.924099,158.925342,163.929171,164.930319,165.93029,168.934212,173.938859,174.94077,179.946545,180.947992,183.950928,186.955744,191.961467,192.962917,194.964766,196.966543,201.970617,204.974401,207.976627,208.980374,193.98818,195.99573,199.9957,201.00411,206.0038,210.00923,232.038054,216.01896,238.050784,229.03623,232.041169,237.05005,238.05302,242.06194,240.06228,243.06947,243.07446,248.08275,251.08887,253.09515,257.10295,257.10777,271.13,270.13,277.15,276.15,un,un,283.17,285.18,fn,fn,291.2,ln,ln,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.014,3.01605,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]),ce.Lo=Oe($e(re.hK,1),L,5,15,[6,1,7,8])},ce.Oo=function(t){var n,e;for(e=t.a,n=0;n<t.b.length;n++)e+=t.b[n]*ce.Ko[t.c[n]];return e},ce.Po=function(t){var n,e;for(n=new ie._R,e=0;e<t.b.length;e++)ie.$R(n,(ce.Li(),ce.Gi)[t.c[e]]),t.b[e]>1&&ie.ZR(n,t.b[e]);return n.a},ce.Qo=function(t){var n,e;for(e=t.d,n=0;n<t.b.length;n++)e+=t.b[n]*ce.Mo[t.c[n]];return e},ce.Ro=function(t){var n,e,o,r,i,a,s,u,f,l,c;for(ce.Jr(t,1),r=Ke(re.hK,L,5,191,15,1),e=0;e<t.o;e++)switch(t.A[e]){case 171:r[1]+=5,r[6]+=3,r[7]+=1,r[8]+=1;break;case 172:r[1]+=12,r[6]+=6,r[7]+=4,r[8]+=1;break;case 173:r[1]+=6,r[6]+=4,r[7]+=2,r[8]+=2;break;case 174:r[1]+=5,r[6]+=4,r[7]+=1,r[8]+=3;break;case 175:r[1]+=5,r[6]+=3,r[7]+=1,r[8]+=1,r[16]+=1;break;case 176:r[1]+=8,r[6]+=5,r[7]+=2,r[8]+=2;break;case 177:r[1]+=7,r[6]+=5,r[7]+=1,r[8]+=3;break;case 178:r[1]+=3,r[6]+=2,r[7]+=1,r[8]+=1;break;case 179:r[1]+=7,r[6]+=6,r[7]+=3,r[8]+=1;break;case 181:case 180:r[1]+=11,r[6]+=6,r[7]+=1,r[8]+=1;break;case 182:r[1]+=12,r[6]+=6,r[7]+=2,r[8]+=1;break;case 183:r[1]+=9,r[6]+=5,r[7]+=1,r[8]+=1,r[16]+=1;break;case 184:r[1]+=9,r[6]+=9,r[7]+=1,r[8]+=1;break;case 185:r[1]+=7,r[6]+=5,r[7]+=1,r[8]+=1;break;case 186:r[1]+=5,r[6]+=3,r[7]+=1,r[8]+=2;break;case 187:r[1]+=7,r[6]+=4,r[7]+=1,r[8]+=2;break;case 188:r[1]+=10,r[6]+=11,r[7]+=2,r[8]+=1;break;case 189:r[1]+=9,r[6]+=9,r[7]+=1,r[8]+=2;break;case 190:r[1]+=9,r[6]+=5,r[7]+=1,r[8]+=1;break;case 1:switch(t.v[e]){case 0:case 1:++r[1];break;case 2:++r[151];break;case 3:++r[152]}break;default:++r[t.A[e]]}for(o=0;o<t.o;o++)t.A[o]>=171&&t.A[o]<=190?r[1]+=2-ce.Sm(t,o):r[1]+=ce.Nm(t,o);for(s=0,f=1;f<=190;f++)0!=r[f]&&++s;for(this.b=Ke(re.hK,L,5,s,15,1),this.c=Ke(re.hK,L,5,s,15,1),s=0,u=0;u<ce.Lo.length;u++)0!=r[ce.Lo[u]]&&(this.b[s]=r[ce.Lo[u]],this.c[s]=ce.Lo[u],++s,r[ce.Lo[u]]=0);for(;;){for(c="zzz",l=-1,a=1;a<=190;a++)r[a]>0&&ie.CR(c,(ce.Li(),ce.Gi)[a])>0&&(c=(ce.Li(),ce.Gi)[a],l=a);if(-1==l)break;this.b[s]=r[l],this.c[s]=l,++s,r[l]=0}for(this.a=0,this.d=0,n=0;n<t.d;n++)1!=t.A[n]&&0!=t.v[n]&&(a=t.A[n],i=t.v[n],this.a+=ce.Jo(a,i)-ce.Ko[a],this.d+=ce.Jo(a,i)-ce.Mo[a])},Te(82,1,{82:1}),a.gb=function(t){var n;if(t===this)return!0;if(!Ue(t,82))return!1;for(n=0;n<this.b.length;n++)if(this.b[n]!=t.b[n])return!1;return!0},a.a=0,a.d=0,re.IK=vo(82),ce.To=function(t,n){var e,o;for(o=Ce.KU(t.b,n),e=le.V$(o).length;e<10;e++)ie.cS(t.a,32);ie.gS(t.a,o)},ce.Uo=function(t,n){var e,o,r;if(n<0||n>999)ie.gS(t.a,"  ?");else for(e=!1,o=0;o<3;o++)0==(r=n/100|0)?2==o||e?ie.cS(t.a,48):ie.cS(t.a,32):(ie.cS(t.a,48+r&V),e=!0),n=n%100*10},ce.Vo=function(t,n){Me.uP(n,t.a.a)},ce.Wo=function(t){ce.Xo.call(this,t)},ce.Xo=function(t){ce.Zo.call(this,t,new ie.kS)},ce.Yo=function(n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m,p,G,b,y,j,N,H,v,M,A,S,C,x,k,R,I,D,F,T,$,P,K,E,O,Y,U,q,J,Q,X;for(this.b=new Ce.MU((cn,"0.0000")),ce.Jr(n,15),D=!0,i=0;i<n.d;i++)if(0!=(3&n.s[i])&&3!=(3&n.s[i])&&(n.s[i]&Rt)>>19!=1){D=!1;break}if(T=-1,D)for(S=Ke(re.hK,L,5,32,15,1),$=0,a=0;a<n.d;a++)if(0!=(3&n.s[a])&&3!=(3&n.s[a])&&(n.s[a]&Rt)>>19==1){++S[x=(n.s[a]&Rt)>>19!=1&&(n.s[a]&Rt)>>19!=2?-1:(n.s[a]&Jt)>>21],$<S[x]&&($=S[x],T=x);break}for(this.a=o||new ie.jS,K=null!=n.N?n.N:"",ie.gS(this.a,K+d),ie.gS(this.a,"Actelion Java MolfileCreator 1.0\n\n"),ce.Uo(this,n.o),ce.Uo(this,n.p),ie.gS(this.a,"  0  0"),ce.Uo(this,D?0:1),ie.gS(this.a,"  0  0  0  0  0999 V2000\n"),k=1==n.o,u=1;u<n.o;u++)if(n.H[u].a!=n.H[0].a||n.H[u].b!=n.H[0].b||n.H[u].c!=n.H[0].c){k=!0;break}if(C=1,k)if(0!=e)C=e;else if(0!=(G=ce.Kj(n,n.o,n.p,(ce.Li(),ce.Ki))))(G<1||G>3)&&(C=1.5/G);else{for(P=_t,a=1;a<n.o;a++)for(s=0;s<a;s++)P>(H=(v=n.H[s].a-n.H[a].a)*v+(M=n.H[s].b-n.H[a].b)*M+(A=n.H[s].c-n.H[a].c)*A)&&(P=H);C=3/P}for(f=0;f<n.o;f++)k?(ce.To(this,C*n.H[f].a),ce.To(this,C*-n.H[f].b),ce.To(this,C*-n.H[f].c)):ie.gS(this.a,"    0.0000    0.0000    0.0000"),null!=(null==n.t?null:n.t[f])?ie.gS(this.a," L  "):0!=(1&n.w[f])?ie.gS(this.a," A  "):(m=(ce.Li(),ce.Gi)[n.A[f]],ie.gS(this.a," "+m),1==le.V$(m).length?ie.gS(this.a,"  "):2==le.V$(m).length&&ie.gS(this.a," ")),ie.gS(this.a," 0  0  0"),0==(R=pt&n.w[f])?ie.gS(this.a,"  0"):384==R?ie.gS(this.a,"  3"):128==R?ie.gS(this.a,"  2"):1792==R?ie.gS(this.a,"  1"):1664==R&&ie.gS(this.a,"  2"),ie.gS(this.a,0!=(n.w[f]&dt)?"  1":"  0"),-1==(X=((n.s[f]&qt)>>>28)-1)?ie.gS(this.a,"  0"):0==X?ie.gS(this.a," 15"):ce.Uo(this,X),ie.gS(this.a,"  0  0  0"),ce.Uo(this,t.Math.abs(n.u[f])),ie.gS(this.a,"  0  0\n");for(b=0;b<n.p;b++){switch(n.F[b]){case 1:O=1,q=0;break;case 2:O=2,q=0;break;case 4:O=3,q=0;break;case 9:O=1,q=6;break;case 17:O=1,q=1;break;case 26:O=2,q=3;break;case 64:O=4,q=0;break;case 32:O=8,q=0;break;default:O=1,q=0}!D||1!=q&&6!=q||(a=n.B[0][b],(n.s[a]&Rt)>>19==2?q=0:(n.s[a]&Rt)>>19==1&&((n.s[a]&Rt)>>19!=1&&(n.s[a]&Rt)>>19!=2?-1:(n.s[a]&Jt)>>21)!=T&&(q=4)),0!=(y=31&n.D[b])&&(O=8==y?4:3==y?5:9==y?6:10==y?7:8),Q=0==(U=96&n.D[b])?0:64==U?1:2,ce.Uo(this,1+n.B[0][b]),ce.Uo(this,1+n.B[1][b]),ce.Uo(this,O),ce.Uo(this,q),ie.gS(this.a,"  0"),ce.Uo(this,Q),ie.gS(this.a,"  0\n")}for(E=0,l=0;l<n.o;l++)0!=n.q[l]&&++E;if(0!=E)for(N=0,a=0;a<n.o;a++)0!=n.q[a]&&(0==N&&(ie.gS(this.a,"M  CHG"),ce.Uo(this,t.Math.min(8,E))),ie.gS(this.a," "),ce.Uo(this,a+1),(j=n.q[a])<0?(ie.gS(this.a,"  -"),j=-j):ie.gS(this.a,"   "),ie.cS(this.a,48+j&V),--E,8!=++N&&0!=E||(N=0,ie.gS(this.a,d)));for(E=0,c=0;c<n.o;c++)0==n.v[c]||++E;if(0!=E)for(N=0,a=0;a<n.o;a++)0!=n.v[a]&&(0==N&&(ie.gS(this.a,"M  ISO"),ce.Uo(this,t.Math.min(8,E))),ie.gS(this.a," "),ce.Uo(this,a+1),ie.gS(this.a," "),ce.Uo(this,n.v[a]),--E,8!=++N&&0!=E||(N=0,ie.gS(this.a,d)));for(E=0,h=0;h<n.o;h++)0!=(48&n.s[h])&&++E;if(0!=E)for(N=0,r=0;r<n.o;r++)if(0!=(48&n.s[r])){switch(0==N&&(ie.gS(this.a,"M  RAD"),ce.Uo(this,t.Math.min(8,E))),ie.gS(this.a," "),ce.Uo(this,r+1),48&n.s[r]){case 16:ie.gS(this.a,"   1");break;case 32:ie.gS(this.a,"   2");break;case 48:ie.gS(this.a,"   3")}--E,8!=++N&&0!=E||(N=0,ie.gS(this.a,d))}if(n.I){for(E=0,a=0;a<n.o;a++)0!=(120&n.w[a])&&++E;if(0!=E)for(N=0,s=0;s<n.o;s++)if(0!=(Y=120&n.w[s])){switch(0==N&&(ie.gS(this.a,"M  RBC"),ce.Uo(this,t.Math.min(8,E))),ie.gS(this.a," "),ce.Uo(this,s+1),Y){case 112:ie.gS(this.a,"  -1");break;case 8:ie.gS(this.a,"   1");break;case 104:ie.gS(this.a,"   2");break;case 88:ie.gS(this.a,"   3");break;case 56:ie.gS(this.a,"   4")}--E,8!=++N&&0!=E||(N=0,ie.gS(this.a,d))}for(w=0;w<n.o;w++)if(null!=(p=null==n.t?null:n.t[w])){for(ie.gS(this.a,"M  ALS "),ce.Uo(this,w+1),ce.Uo(this,p.length),ie.gS(this.a,0!=(1&n.w[w])?" T ":" F "),I=0;I<p.length;I++)switch(F=(ce.Li(),ce.Gi)[p[I]],le.V$(F).length){case 1:ie.gS(this.a,F+"   ");break;case 2:ie.gS(this.a,F+"  ");break;case 3:ie.gS(this.a,F+" ");break;default:ie.gS(this.a,"   ?")}ie.gS(this.a,d)}for(E=0,g=0;g<n.o;g++)0!=(6144&n.w[g])&&++E;if(0!=E)for(N=0,r=0;r<n.o;r++)0!=(J=6144&n.w[r])&&(0==N&&(ie.gS(this.a,"M  SUB"),ce.Uo(this,t.Math.min(8,E))),ie.gS(this.a," "),ce.Uo(this,r+1),0!=(J&B)?ie.gS(this.a,"   "+(n.c[r]+1)):ie.gS(this.a,"  -2"),--E,8!=++N&&0!=E||(N=0,ie.gS(this.a,d)))}ie.gS(this.a,hn)},ce.Zo=function(t,n){ce.Yo.call(this,t,0,n)},Te(70,1,{},ce.Wo,ce.Yo),re.KK=vo(70),ce.$o=function(t,n,e,o,r,i){var a,s,u,f;switch(f=1,s=!1,r){case 1:f=17;break;case 3:f=26;break;case 4:f=17,s=!0;break;case 6:f=9;break;default:switch(o){case 1:f=1;break;case 2:f=2;break;case 3:f=4;break;case 4:f=64;break;case 9:f=32}}if(a=ce.Pi(t.f,n,e,f),u=0,s&&ce.$k(t.f,n,1,-1),o>4)switch(o){case 5:u|=3;break;case 6:u|=9;break;case 7:u|=10;break;case 8:32!=f&&(u|=31)}return 1==i&&(u|=64),2==i&&(u|=32),0!=u&&ce.vl(t.f,a,u,!0),a},ce._o=function(n){var e,o,r,i,a,s,u,f,l,c,h;for(s=Ke(re.hK,L,5,n.f.o,15,1),o=0;o<n.f.o;o++)s[o]=-ce.rj(n.f,o);for(ce.$d(new ce.ie(n.f),null,!0),r=0;r<n.f.o;r++)s[r]+=ce.rj(n.f,r);for(e=0;e<n.f.o;e++)if(0!=s[e])for(u=-s[e],i=0;i<n.f.p;i++)for(l=0;l<2;l++)u>0&&32==ce.Yj(n.f,i)&&ce.Nj(n.f,1-l,i)==e&&(h=ce.Nj(n.f,l,i),ce.xk(n.f,h)&&(c=ce.bp(n,h),(a=ce.rj(n.f,h))<c&&(f=t.Math.min(u,c-a),ce.Vk(n.f,h,a+f),u-=f)))},ce.ap=function(t,n){return t.f=null,ce.sp(t,new Me.pP(new Me.tP(n)))?t.f:null},ce.bp=function(t,n){var e,o;return null==(o=(e=ce.Ij(t.f,n))<(ce.Li(),ce.Ii).length?ce.Ii[e]:null)?0:o[o.length-1]},ce.cp=function(t,n){var e;return(e=t.a?ue.hW(t.a,new ie.dR(n)):null)?e.a:n-1},ce.dp=function(t,n){var e;return(e=t.b?ue.hW(t.b,new ie.dR(n)):null)?e.a:n-1},ce.ep=function(t,n){var e,o;if(null!=n)for(ce.Jr(t.f,1),e=0;e<t.f.d;e++)0!=n[e]&&(o=ce.ak(t.f,e,ce.Sm(t.f,e)),15==n[e]?o>=0&&ce.Tk(t.f,e,0):n[e]!=ce.bk(t.f,e)&&ce.Tk(t.f,e,n[e]-o))},ce.fp=function(t,n){var e;if(-1==n)return-1;for(e=n+1;e<le.V$(t).length;e++)if(le.S$(e,le.V$(t).length),32!=le.V$(t).charCodeAt(e)&&(le.S$(e,le.V$(t).length),9!=le.V$(t).charCodeAt(e)))return e;return-1},ce.gp=function(t,n){var e;for(e=n;e<le.V$(t).length;e++)if(le.S$(e,le.V$(t).length),32==le.V$(t).charCodeAt(e)||(le.S$(e,le.V$(t).length),9==le.V$(t).charCodeAt(e)))return e;return-1},ce.hp=function(t){return-1!=le.V$(t).indexOf("ATOMS=(")?wn:-1!=le.V$(t).indexOf("BONDS=(")?"BONDS":null},ce.ip=function(n,e){var o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C;for(d=0,p=-1==(u=ce.gp(e,d+1))?le.V$(e).length:u,r=ie.CQ(le.V$(e).substr(d,p-d)),d=ce.fp(e,p),p=-1==(f=ce.gp(e,d+1))?le.V$(e).length:f,b=le.V$(e).substr(d,p-d),v=null,i=!1,0!=(G=ce.pp(e))&&(v=ce.jp(e),G<0&&(i=!0),p=t.Math.abs(G)),d=ce.fp(e,p),p=-1==(l=ce.gp(e,d+1))?le.V$(e).length:l,A=Uo(le.V$(e).substr(d,p-d)),d=ce.fp(e,p),p=-1==(c=ce.gp(e,d+1))?le.V$(e).length:c,S=Uo(le.V$(e).substr(d,p-d)),d=ce.fp(e,p),p=-1==(h=ce.gp(e,d+1))?le.V$(e).length:h,C=Uo(le.V$(e).substr(d,p-d)),d=ce.fp(e,p),p=-1==(w=ce.gp(e,d+1))?le.V$(e).length:w,j=ie.CQ(le.V$(e).substr(d,p-d)),(o=ce.Mi(n.f,A,-S,-C))+1!=r&&(!n.a&&(n.a=new ue.yY),ue.qY(n.a,new ie.dR(r),new ie.dR(o))),null!=v&&ce.al(n.f,o,v,i),0!=j&&ce.bl(n.f,o,j,!1),ie.GR(b,"A")?ce.fl(n.f,o,1,!0):ie.GR(b,"Q")?((y=Ke(re.hK,L,5,1,15,1))[0]=6,ce.al(n.f,o,y,!0)):ce.ml(n.f,o,ce.Yl(b));-1!=(d=ce.fp(e,p));)if(p=-1==(s=ce.gp(e,d+1))?le.V$(e).length:s,N=le.V$(e).substr(d,p-d),m=ie.KR(N,Fo(61)),g=le.V$(N).substr(0,m),M=ie.CQ(le.V$(N).substr(m+1)),ie.GR(g,"CHG"))ce.Vk(n.f,o,M);else if(ie.GR(g,"RAD"))switch(M){case 1:ce.gl(n.f,o,16);break;case 2:ce.gl(n.f,o,32);break;case 3:ce.gl(n.f,o,48)}else if(ie.GR(g,"CFG"));else if(ie.GR(g,"MASS"))ce.dl(n.f,o,M);else if(ie.GR(g,"VAL"))ce.Tk(n.f,o,-1==M?0:0==M?-1:M);else if(ie.GR(g,"HCOUNT"))switch(M){case 0:break;case-1:ce.fl(n.f,o,1792,!0);break;case 1:ce.fl(n.f,o,128,!0);break;case 2:ce.fl(n.f,o,384,!0);break;default:ce.fl(n.f,o,896,!0)}else if(ie.GR(g,"SUBST")){if(-1==M)ce.fl(n.f,o,Ct,!0);else if(M>0){for(H=0,a=0;a<n.f.p;a++)(ce.Nj(n.f,0,a)==o||ce.Nj(n.f,1,a)==o)&&++H;M>H&&ce.fl(n.f,o,B,!0)}}else if(ie.GR(g,"RBCNT"))switch(M){case 3:case-1:ce.fl(n.f,o,112,!0);break;case 1:ce.fl(n.f,o,8,!0);break;case 2:ce.fl(n.f,o,104,!0);break;case 4:ce.fl(n.f,o,56,!0)}},ce.jp=function(t){var n,e,o,r,i,a,s,u;if(s=null,e=le.V$(t).indexOf("["),o=le.V$(t).indexOf("]",e),e>=0&&o>0){for(n=Ke(re.hK,L,5,16,15,1),u=le.V$(t).substr(e+1,o-(e+1)),r=0,a=!0;a&&r<16;)i=null,-1==(e=le.V$(u).indexOf(","))?(i=u,a=!1):(i=le.V$(u).substr(0,e),u=le.V$(u).substr(e+1)),n[r++]=ce.Yl(i);s=Ke(re.hK,L,5,r,15,1),ie.pS(n,0,s,0,r)}return s},ce.kp=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b;for(g=0,m=-1==(u=ce.gp(n,g+1))?le.V$(n).length:u,i=ie.CQ(le.V$(n).substr(g,m-g)),g=ce.fp(n,m),m=-1==(f=ce.gp(n,g+1))?le.V$(n).length:f,a=ie.CQ(le.V$(n).substr(g,m-g)),g=ce.fp(n,m),m=-1==(l=ce.gp(n,g+1))?le.V$(n).length:l,e=ce.cp(t,ie.CQ(le.V$(n).substr(g,m-g))),g=ce.fp(n,m),m=-1==(c=ce.gp(n,g+1))?le.V$(n).length:c,o=ce.cp(t,ie.CQ(le.V$(n).substr(g,m-g))),p=0,G=0;-1!=(g=ce.fp(n,m));)if(m=-1==(s=ce.gp(n,g+1))?le.V$(n).length:s,d=le.V$(n).substr(g,m-g),w=ie.KR(d,Fo(61)),h=le.V$(d).substr(0,w),b=ie.CQ(le.V$(d).substr(w+1)),ie.GR(h,"CFG"))switch(b){case 1:p=1;break;case 2:p=2==a?3:4;break;case 3:p=6}else ie.GR(h,"TOPO")&&(G=b);(r=ce.$o(t,e,o,a,p,G))+1!=i&&(!t.b&&(t.b=new ue.yY),ue.qY(t.b,new ie.dR(i),new ie.dR(r)))},ce.lp=function(t,n){var e,o,r,i,a,s;if(null!=(s=ce.hp(n)))if(a=ce.np(n,s),ie.GR(le.V$(n).substr(0,13),"MDLV30/STEABS"))if(ie.GR(s,wn))for(i=0;i<a.length;i++)ce.$k(t.f,ce.cp(t,a[i]),0,-1);else for(r=0;r<a.length;r++)ce.ql(t.f,ce.dp(t,a[r]),0,-1);else if(ie.GR(le.V$(n).substr(0,13),"MDLV30/STERAC"))if(o=ie.CQ(ie.SR(n,13,ce.gp(n,13))),ie.GR(s,wn))for(i=0;i<a.length;i++)ce.$k(t.f,ce.cp(t,a[i]),1,o-1);else for(r=0;r<a.length;r++)ce.ql(t.f,ce.dp(t,a[r]),1,o-1);else if(ie.GR(le.V$(n).substr(0,13),"MDLV30/STEREL"))if(o=ie.CQ(ie.SR(n,13,ce.gp(n,13))),ie.GR(s,wn))for(i=0;i<a.length;i++)ce.$k(t.f,ce.cp(t,a[i]),2,o-1);else for(r=0;r<a.length;r++)ce.ql(t.f,ce.dp(t,a[r]),2,o-1);else if(ie.GR(le.V$(n).substr(0,13),"MDLV30/HILITE"))if(ie.GR(s,wn))for(r=0;r<a.length;r++)ce.Wk(t.f,ce.cp(t,a[r]),448);else for(r=0;r<a.length;r++)e=ce.dp(t,a[r]),ce.Wk(t.f,ce.Nj(t.f,0,e),448),ce.Wk(t.f,ce.Nj(t.f,1,e),448)},ce.mp=function(t,n){var e,o,r;t.f||ie.GR(le.V$(n).substr(0,6),"COUNTS")&&(e=ce.fp(n,ce.gp(n,7)),o=ie.CQ(ie.SR(n,7,ce.gp(n,7))),r=ie.CQ(ie.SR(n,e,ce.gp(n,e))),t.f=new ce._r(o,r))},ce.np=function(t,n){var e,o,r,i,a,s;for(i=le.V$(t).indexOf(n+"=(")+le.V$(n).length+2,a=ie.LR(t,Fo(41),i),r=ce.gp(t,i),e=ie.CQ(le.V$(t).substr(i,r-i)),s=Ke(re.hK,L,5,e,15,1),o=0;o<e;o++)i=ce.fp(t,r),(-1==(r=ce.gp(t,i))||r>a)&&(r=a),s[o]=ie.CQ(le.V$(t).substr(i,r-i));return s},ce.op=function(t){var n,e,o,r,i,a,s,u,f;for(u=Ke(re.hK,L,5,t.f.o,15,1),o=0;o<t.f.p;o++)if(64==ce.Yj(t.f,o))for(a=0;a<2;a++)u[ce.Nj(t.f,a,o)]=1;for(r=0;r<t.f.p;r++)for(f=ce.Vj(t.f,r),i=0;i<2;i++)u[ce.Nj(t.f,i,r)]+=f;for(e=0;e<t.f.p;e++)if(1==ce.Vj(t.f,e))for(i=0;i<2;i++)s=ce.Nj(t.f,1-i,e),ce.xk(t.f,s)&&(n=ce.Nj(t.f,i,e),ce.uk(t.f,n)&&u[n]>ce.bk(t.f,n))&&ce.wl(t.f,e,32)},ce.pp=function(t){var n,e;if(le.V$(t).indexOf("[")>=0){if(n=le.V$(t).indexOf(" NOT["),e=le.V$(t).indexOf("]",n),n>=0&&e>0)return-(e+1);if(n=le.V$(t).indexOf(" ["),e=le.V$(t).indexOf("]",n),n>=0&&e>0)return e+1;if(n=le.V$(t).indexOf(" 'NOT["),e=le.V$(t).indexOf("]'",n),n>=0&&e>0)return-(e+2);if(n=le.V$(t).indexOf(" '["),e=le.V$(t).indexOf("]'",n),n>=0&&e>0)return e+2;ie.oS()}return 0},ce.qp=function(t,n,e){return t.f=n,ce.sp(t,e)},ce.rp=function(t){return 0==le.V$(t).length?0:ie.CQ(t)},ce.sp=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,x,k,R,I,D,F,T,$,P,K,V,E,O;$=null;try{if(t.d=null,t.f&&(ce._i(t.f),ce.yl(t.f,!1)),null==(v=y=Me.oP(n)))return!1;if(null==(y=Me.oP(n)))return!1;if(null==(y=Me.oP(n)))return!1;if(t.g=-1!=le.V$(y).indexOf("From CSD data. Using bond type 'Any'"),t.c=-1!=le.V$(y).indexOf("From CSD data."),null==(y=Me.oP(n)))return!1;try{M=ie.CQ(ie.TR(le.V$(y).substr(0,3))),A=ie.CQ(ie.TR(le.V$(y).substr(3,3))),S=ce.rp(ie.TR(le.V$(y).substr(6,3))),h=ce.rp(ie.TR(le.V$(y).substr(12,3))),P=le.V$(y).length>=39&&ie.GR(le.V$(y).substr(34,5),"V3000")?3:2}catch(t){if(Ue(t=Ze(t),13))return!1;throw We(t)}if(3==P)return x=ce.tp(t,n),ce.El(t.f,v),x;if(!t.f&&(t.f=new ce._r(M,A)),ce.El(t.f,v),0==h&&(t.f.J=!0),0==M){for(;null!=y&&!(ie.GR(y,gn)||ie.GR(y,mn)||ie.GR(le.V$(y).substr(1),"$"));)y=Me.oP(n);return!0}for(m=0;m<M;m++){if(null==(y=Me.oP(n)))return!1;switch(V=Uo(ie.TR(le.V$(y).substr(0,10))),E=Uo(ie.TR(le.V$(y).substr(10,10))),O=Uo(ie.TR(le.V$(y).substr(20,10))),o=ce.Mi(t.f,V,-E,-O),b=ie.TR(le.V$(y).substr(31,3)),a=ce.Yl(b),ce.ml(t.f,o,a),ie.GR(b,"A")&&ce.fl(t.f,o,1,!0),0!=(H=ce.rp(ie.TR(le.V$(y).substr(34,2))))&&ce.dl(t.f,o,(ce.Li(),ce.Ji)[a]+H),0!=(c=ce.rp(ie.TR(le.V$(y).substr(36,3))))&&ce.Vk(t.f,o,4-c),j=le.V$(y).length<63?0:ce.rp(ie.TR(le.V$(y).substr(60,3))),ce.bl(t.f,o,j,!1),le.V$(y).length<45?0:ce.rp(ie.TR(le.V$(y).substr(42,3)))){case 0:break;case 1:ce.fl(t.f,o,768,!0);break;case 2:ce.fl(t.f,o,128,!0);break;case 3:ce.fl(t.f,o,384,!0);break;default:ce.fl(t.f,o,896,!0)}le.V$(y).length>=48&&(le.S$(47,le.V$(y).length),49==le.V$(y).charCodeAt(47))&&ce.fl(t.f,o,dt,!0),0!=(T=le.V$(y).length<51?0:ce.rp(ie.TR(le.V$(y).substr(48,3))))&&(null==$&&($=Ke(re.hK,L,5,M,15,1)),$[o]=T)}for(d=0;d<A;d++){if(null==(y=Me.oP(n)))return!1;r=ie.CQ(ie.TR(le.V$(y).substr(0,3)))-1,i=ie.CQ(ie.TR(le.V$(y).substr(3,3)))-1,f=ie.CQ(ie.TR(le.V$(y).substr(6,3))),k=le.V$(y).length<12?0:ce.rp(ie.TR(le.V$(y).substr(9,3))),F=le.V$(y).length<18?0:ce.rp(ie.TR(le.V$(y).substr(15,3))),8==f&&(t.g||ce.xk(t.f,r)||ce.xk(t.f,i))&&(f=9),ce.$o(t,r,i,f,k,F)}for(g=0;g<S;g++)if(null==(y=Me.oP(n)))return!1;if(null==(y=Me.oP(n)))return 0!=(1&t.e)&&(t.d=ce.Lm(t.f)),ce.ep(t,$),0==h&&ce.Jr(t.f,15),!0;for(;null!=y&&!ie.GR(y,gn)&&!ie.GR(y,mn);){if(ie.GR(le.V$(y).substr(0,6),"M  CHG")&&(p=ie.CQ(ie.TR(le.V$(y).substr(6,3))))>0)for(e=10,K=14,G=1;G<=p;++G,e+=8,K+=8)o=ie.CQ(ie.TR(le.V$(y).substr(e,e+3-e)))-1,l=ie.CQ(ie.TR(le.V$(y).substr(K,K+3-K))),ce.Vk(t.f,o,l);if(ie.GR(le.V$(y).substr(0,6),"M  ISO")&&(p=ie.CQ(ie.TR(le.V$(y).substr(6,3))))>0)for(e=10,K=14,G=1;G<=p;++G,e+=8,K+=8)o=ie.CQ(ie.TR(le.V$(y).substr(e,e+3-e)))-1,N=ie.CQ(ie.TR(le.V$(y).substr(K,K+3-K))),ce.dl(t.f,o,N);if(ie.GR(le.V$(y).substr(0,6),"M  RAD")&&(p=ie.CQ(ie.TR(le.V$(y).substr(6,3))))>0)for(e=10,K=14,G=1;G<=p;++G,e+=8,K+=8)switch(o=ie.CQ(ie.TR(le.V$(y).substr(e,e+3-e)))-1,ie.CQ(ie.TR(le.V$(y).substr(K,K+3-K)))){case 1:ce.gl(t.f,o,16);break;case 2:ce.gl(t.f,o,32);break;case 3:ce.gl(t.f,o,48)}if((ie.GR(le.V$(y).substr(0,6),"M  RBC")||ie.GR(le.V$(y).substr(0,6),"M  RBD"))&&(p=ie.CQ(ie.TR(le.V$(y).substr(6,3))))>0)for(e=10,K=14,G=1;G<=p;++G,e+=8,K+=8)switch(o=ie.CQ(ie.TR(le.V$(y).substr(e,e+3-e)))-1,ie.CQ(ie.TR(le.V$(y).substr(K,K+3-K)))){case 3:case-1:ce.fl(t.f,o,112,!0);break;case 1:ce.fl(t.f,o,8,!0);break;case 2:ce.fl(t.f,o,104,!0);break;case 4:ce.fl(t.f,o,56,!0)}if(ie.GR(le.V$(y).substr(0,6),"M  ALS")&&(o=ie.CQ(ie.TR(le.V$(y).substr(7,3)))-1)>=0){for(C=ie.CQ(ie.TR(le.V$(y).substr(10,3))),le.S$(14,le.V$(y).length),s=84==le.V$(y).charCodeAt(14),T=Ke(re.hK,L,5,C,15,1),e=16,G=0;G<C;++G,e+=4)D=ie.TR(le.V$(y).substr(e,e+4-e)),T[G]=ce.Yl(D);ce.al(t.f,o,T,s)}if(ie.GR(le.V$(y).substr(0,6),"M  SUB")&&(p=ie.CQ(ie.TR(le.V$(y).substr(6,3))))>0)for(e=10,K=14,G=1;G<=p;++G,e+=8,K+=8)if(o=ie.CQ(ie.TR(le.V$(y).substr(e,e+3-e)))-1,-2==(R=ie.CQ(ie.TR(le.V$(y).substr(K,K+3-K)))))ce.fl(t.f,o,Ct,!0);else if(R>0){for(I=0,u=0;u<t.f.p;u++)(ce.Nj(t.f,0,u)==o||ce.Nj(t.f,1,u)==o)&&++I;R>I&&ce.fl(t.f,o,B,!0)}y=Me.oP(n)}}catch(t){if(Ue(t=Ze(t),13))return w=t,ie.mG(w,(ie.oS(),ie.nS),""),!1;throw We(t)}return t.c&&(ce.op(t),ce._o(t)),0!=(1&t.e)&&(t.d=ce.Lm(t.f)),ce.ep(t,$),ce.Jr(t.f,15),!0},ce.tp=function(t,n){var e,o,r,i,a;for(t.a&&ue.jY(t.a),t.b&&ue.jY(t.b),r=0,o=Me.oP(n);null!=o&&ie.GR(le.V$(o).substr(0,7),dn);){for(o=ie.TR(le.V$(o).substr(7));a=le.V$("-").length,ie.GR(le.V$(o).substr(le.V$(o).length-a,a),"-");){if(e=Me.oP(n),!ie.GR(le.V$(e).substr(0,7),dn))return!1;o=ie.TR(ie.ER(ie.SR(o,0,le.V$(o).length-1),le.V$(e).substr(7)))}if(ie.GR(le.V$(o).substr(0,5),"BEGIN"))if(i=ie.TR(le.V$(o).substr(6)),ie.GR(le.V$(i).substr(0,4),"CTAB"))r=1;else if(ie.GR(le.V$(i).substr(0,4),"ATOM"))r=2;else if(ie.GR(le.V$(i).substr(0,4),"BOND"))r=3;else{if(!ie.GR(le.V$(i).substr(0,10),"COLLECTION"))return!1;r=4}else if(ie.GR(le.V$(o).substr(0,3),"END"))r=0;else if(1==r)ce.mp(t,o);else if(2==r)ce.ip(t,o);else if(3==r)ce.kp(t,o);else{if(4!=r)return!1;ce.lp(t,o)}o=Me.oP(n)}for(;null!=o&&!ie.GR(le.V$(o).substr(0,6),gn)&&!ie.GR(o,mn);)o=Me.oP(n);return!0},ce.up=function(){this.e=0},ce.vp=function(){this.e=1},Te(68,1,{},ce.up,ce.vp),a.c=!1,a.e=0,a.g=!1,re.LK=vo(68),ce.wp=function(t){},ce.xp=function(n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m,p,G,b,y,j,N,H,v,M,A,S,C,x,k,R,I;for(ie.gS(n.a,"M  V30 BEGIN CTAB\n"),ie.gS(n.a,pn+e.o+" "+e.p+" 0 0 0\n"),ie.gS(n.a,"M  V30 BEGIN ATOM\n"),f=0;f<e.o;f++){if(ie.gS(n.a,dn+(f+1)),null!=(null==e.t?null:e.t[f])){for(c=null==e.t?null:e.t[f],j=0!=(1&e.w[f]),ie.gS(n.a,j?" NOT[":" ["),b=0;b<c.length;b++)switch(b>0&&ie.gS(n.a,","),y=(ce.Li(),ce.Gi)[c[b]],le.V$(y).length){case 2:case 3:case 1:ie.gS(n.a,y);break;default:ie.gS(n.a,"?")}ie.gS(n.a,"]")}else 0!=(1&e.w[f])?ie.gS(n.a," A"):ie.gS(n.a," "+(ce.Li(),ce.Gi)[e.A[f]]);if(o?(ie.gS(n.a," "+ze(E*n.b*e.H[f].a)/E),ie.gS(n.a," "+ze(E*n.b*-e.H[f].b)/E),ie.gS(n.a," "+ze(E*n.b*-e.H[f].c)/E)):ie.gS(n.a," 0 0 0"),ie.gS(n.a," "+t.Math.abs(e.u[f])),0!=e.q[f]&&ie.gS(n.a," CHG="+e.q[f]),0!=(48&e.s[f]))switch(ie.gS(n.a," RAD="),48&e.s[f]){case 16:ie.gS(n.a,"1");break;case 32:ie.gS(n.a,"2");break;case 48:ie.gS(n.a,"3")}if(1!=(3&e.s[f])&&2!=(3&e.s[f])||(ie.gS(n.a," CFG="),1==(3&e.s[f])?ie.gS(n.a,"1"):ie.gS(n.a,"2")),0!=e.v[f]&&ie.gS(n.a," MASS="+e.v[f]),-1!=(I=((e.s[f]&qt)>>>28)-1)&&ie.gS(n.a," VAL="+(0==I?"-1":ie.nR(I))),384==(G=pt&e.w[f])?ie.gS(n.a," HCOUNT=2"):128==G?ie.gS(n.a," HCOUNT=1"):1792==G?ie.gS(n.a," HCOUNT=-1"):1664==G&&ie.gS(n.a," HCOUNT=1"),0!=(x=6144&e.w[f])&&(0!=(x&B)?ie.gS(n.a," SUBST="+(e.c[f]+1)):ie.gS(n.a," SUBST=-1")),0!=(A=120&e.w[f]))switch(A){case 112:ie.gS(n.a," RBCNT=-1");break;case 104:case 8:ie.gS(n.a," RBCNT=2");break;case 88:ie.gS(n.a," RBCNT=3");break;case 56:ie.gS(n.a," RBCNT=4")}ie.gS(n.a,d)}for(ie.gS(n.a,"M  V30 END ATOM\n"),ie.gS(n.a,"M  V30 BEGIN BOND\n"),w=0;w<e.p;w++){switch(ie.gS(n.a,dn+(w+1)),e.F[w]){case 1:v=1,C=0;break;case 2:v=2,C=0;break;case 4:v=3,C=0;break;case 9:v=1,C=3;break;case 17:v=1,C=1;break;case 26:v=2,C=2;break;case 64:v=4,C=0;break;case 32:v=9,C=0;break;default:v=1,C=0}0!=(m=31&e.D[w])&&(v=8==m?4:3==m?5:9==m?6:10==m?7:8),ie.gS(n.a," "+v+" "+(e.B[0][w]+1)+" "+(e.B[1][w]+1)),0!=C&&ie.gS(n.a," CFG="+C),0!=(k=0==(S=96&e.D[w])?0:64==S?1:2)&&ie.gS(n.a," TOPO="+k),ie.gS(n.a,d)}for(ie.gS(n.a,"M  V30 END BOND\n"),M=!1,r=0,N=Ke(re.hK,L,5,32,15,1),a=Ke(re.hK,L,5,32,15,1),l=0;l<e.d;l++)1!=(3&e.s[l])&&2!=(3&e.s[l])||(M=!0,1==(R=(e.s[l]&Rt)>>19)?++a[(e.s[l]&Rt)>>19!=1&&(e.s[l]&Rt)>>19!=2?-1:(e.s[l]&Jt)>>21]:2==R?++N[(e.s[l]&Rt)>>19!=1&&(e.s[l]&Rt)>>19!=2?-1:(e.s[l]&Jt)>>21]:++r);for(i=0,H=Ke(re.hK,L,5,32,15,1),s=Ke(re.hK,L,5,32,15,1),g=0;g<e.e;g++)2==ce.Vj(e,g)||1!=(3&e.C[g])&&2!=(3&e.C[g])||(M=!0,1==(R=(e.C[g]&Qt)>>10)?++s[(e.C[g]&Qt)>>10!=1&&(e.C[g]&Qt)>>10!=2?-1:(e.C[g]&Xt)>>12]:2==R?++H[(e.C[g]&Qt)>>10!=1&&(e.C[g]&Qt)>>10!=2?-1:(e.C[g]&Xt)>>12]:++i);if(M){if(ie.gS(n.a,"M  V30 BEGIN COLLECTION\n"),0!=r){for(ie.gS(n.a,"M  V30 MDLV30/STEABS ATOMS=("+r),u=0;u<e.d;u++)(1==(3&e.s[u])||2==(3&e.s[u]))&&(e.s[u]&Rt)>>19==0&&ie.gS(n.a," "+(u+1));ie.gS(n.a,Gn)}if(0!=i){for(ie.gS(n.a,"M  V30 MDLV30/STEABS BONDS=("+i),h=0;h<e.e;h++)2!=ce.Vj(e,h)&&(1==(3&e.C[h])||2==(3&e.C[h]))&&(e.C[h]&Qt)>>10==0&&ie.gS(n.a," "+(h+1));ie.gS(n.a,Gn)}for(p=0;p<32;p++){if(0!=N[p]){for(ie.gS(n.a,bn+(p+1)+" ATOMS=("+N[p]),u=0;u<e.d;u++)(1==(3&e.s[u])||2==(3&e.s[u]))&&(e.s[u]&Rt)>>19==2&&((e.s[u]&Rt)>>19!=1&&(e.s[u]&Rt)>>19!=2?-1:(e.s[u]&Jt)>>21)==p&&ie.gS(n.a," "+(u+1));ie.gS(n.a,Gn)}if(0!=a[p]){for(ie.gS(n.a,yn+(p+1)+" ATOMS=("+a[p]),u=0;u<e.d;u++)(1==(3&e.s[u])||2==(3&e.s[u]))&&(e.s[u]&Rt)>>19==1&&((e.s[u]&Rt)>>19!=1&&(e.s[u]&Rt)>>19!=2?-1:(e.s[u]&Jt)>>21)==p&&ie.gS(n.a," "+(u+1));ie.gS(n.a,Gn)}if(0!=H[p]){for(ie.gS(n.a,bn+(p+1)+" BONDS=("+H[p]),h=0;h<e.e;h++)2!=ce.Vj(e,h)&&(1==(3&e.C[h])||2==(3&e.C[h]))&&(e.C[h]&Qt)>>10==2&&((e.C[h]&Qt)>>10!=1&&(e.C[h]&Qt)>>10!=2?-1:(e.C[h]&Xt)>>12)==p&&ie.gS(n.a," "+(h+1));ie.gS(n.a,Gn)}if(0!=s[p]){for(ie.gS(n.a,yn+(p+1)+" BONDS=("+s[p]),h=0;h<e.e;h++)2!=ce.Vj(e,h)&&(1==(3&e.C[h])||2==(3&e.C[h]))&&(e.C[h]&Qt)>>10==1&&((e.C[h]&Qt)>>10!=1&&(e.C[h]&Qt)>>10!=2?-1:(e.C[h]&Xt)>>12)==p&&ie.gS(n.a," "+(h+1));ie.gS(n.a,Gn)}}ie.gS(n.a,"M  V30 END COLLECTION\n")}ie.gS(n.a,"M  V30 END CTAB\n")},ce.yp=function(){ce.wp(this),this.a=new ie.kS},ce.zp=function(t){ce.Ap.call(this,t)},ce.Ap=function(t){ce.Bp.call(this,t,new ie.kS)},ce.Bp=function(t,n){var e,o;ce.wp(this),ce.Jr(t,15),this.a=n,o=null!=t.N?t.N:"",ie.gS(this.a,o+d),ie.gS(this.a,"Actelion Java MolfileCreator 2.0\n\n"),ie.gS(this.a,"  0  0  0  0  0  0              0 V3000\n"),this.b=1,(e=ce.Dp(t))&&(this.b=ce.Cp(t)),ce.xp(this,t,e),ie.gS(this.a,hn)},ce.Cp=function(t){var n,e,o,r,i,a,s,u,f;if(f=1,0!=(o=ce.Kj(t,t.o,t.p,(ce.Li(),ce.Ki))))(o<1||o>3)&&(f=1.5/o);else{for(u=jn,n=1;n<t.o;n++)for(e=0;e<n;e++)u>(r=(i=t.H[e].a-t.H[n].a)*i+(a=t.H[e].b-t.H[n].b)*a+(s=t.H[e].c-t.H[n].c)*s)&&(u=r);f=3/u}return f},ce.Dp=function(t){var n;if(1==t.o)return!0;for(n=1;n<t.o;n++)if(t.H[n].a!=t.H[0].a||t.H[n].b!=t.H[0].b||t.H[n].c!=t.H[0].c)return!0;return!1},ce.Ep=function(t,n){var e;return(e=new ce.yp).b=n,ce.Jr(t,15),ce.xp(e,t,!0),e.a.a},Te(79,1,{},ce.yp,ce.zp),a.b=1,re.MK=vo(79),ce.Fp=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g;for(f=t.g.K,l=0,i=0;i<e;i++)f>n[i]&&(f=n[i],l=i);for(g=Ke(re.hK,L,5,e,15,1),c=l<e-1?l+1:0,s=n[l>0?l-1:e-1]<n[c],a=0;a<e;a++)g[a]=n[l],s?--l<0&&(l=e-1):++l==e&&(l=0);for(r=0;r<t.i.a.length;r++)if((w=ue.Th(t.i,r)).length==e){for(o=!0,u=0;u<e;u++)if(w[u]!=g[u]){o=!1;break}if(o)return}ue.Oh(t.i,g),h=ce.Rp(t,g),ue.Oh(t.j,h),ce.$p(t,g,h)},ce.Gp=function(t,n,e){var o,r,i,a,s,u,f;for(u=Ke(re.hK,L,5,t.f,15,1),a=Ke(re.hK,L,5,t.f,15,1),f=Ke(re.DN,ft,5,t.g.d,16,1),o=ce.Nj(t.g,0,n),r=ce.Nj(t.g,1,n),u[0]=o,u[1]=r,a[1]=-1,f[r]=!0,s=1;s>=1;)if(++a[s],a[s]!=ce.Am(t.g,u[s])){if(!f[i=ce.zm(t.g,u[s],a[s])]&&!e[i])if(i==o&&s>1){if(ce.Fp(t,u,s+1),t.i.a.length>=Gt)return}else s+1<t.f&&(u[++s]=i,f[i]=!0,a[s]=-1)}else f[u[s]]=!1,--s},ce.Hp=function(t,n,e,o,r,i,a,s){var u,f,l,c,h,w,g,m,d,p,G,b,y,j,N;for(b=ue.Th(t.i,n),j=(y=ue.Th(t.j,n)).length,l=0,f=0,N=!1,p=0;p<j;p++)l<<=1,f<<=1,ce.Zp(t,y[p])?l|=1:s&&ce.Yp(t,y[p])?(l|=1,f|=1):-1!=(u=e[n][p])&&(o[u]?r[u]&&(l|=1,i[u]||(f|=1)):N=!0);switch(d=!1,j){case 3:for(c=Oe($e(re.hK,1),L,5,15,[2,1,4]),d=!0,m=0;m<3;m++)(l&c[m])==c[m]&&(6==ce.Ij(t.g,b[m])&&1==ce.rj(t.g,b[m])||5==ce.Ij(t.g,b[m])&&0==ce.rj(t.g,b[m]))&&(r[n]=!0,a[n]=m,0==(f&c[m])&&(d=!1));break;case 5:for(h=Oe($e(re.hK,1),L,5,15,[10,5,18,9,20]),d=!0,G=0;G<5;G++)if((l&h[G])==h[G])switch(ce.Ij(t.g,b[G])){case 6:-1==ce.rj(t.g,b[G])&&(r[n]=!0,a[n]=G,0==(f&h[G])&&(d=!1));break;case 7:ce.rj(t.g,b[G])<=0&&(r[n]=!0,a[n]=G);break;case 8:r[n]=!0,a[n]=G;break;case 16:case 34:case 52:2==ce.Am(t.g,b[G])&&(r[n]=!0,a[n]=G)}break;case 6:d=!0,21==(21&l)&&(r[n]=!0,0==(21&f)&&(d=!1)),42==(42&l)&&(r[n]=!0,0==(42&f)&&(d=!1));break;case 7:for(w=Oe($e(re.hK,1),L,5,15,[42,21,74,37,82,41,84]),d=!0,g=0;g<7;g++)(l&w[g])==w[g]&&(6==ce.Ij(t.g,b[g])&&1==ce.rj(t.g,b[g])||5==ce.Ij(t.g,b[g])&&0==ce.rj(t.g,b[g]))&&(r[n]=!0,a[n]=g,0==(f&w[g])&&(d=!1))}return r[n]&&!d&&(i[n]=!0),!!r[n]||!N},ce.Ip=function(t,n,e,o,r){var i,a,s,u,f,l,c,h,w,g,m,d;for(i=Ke(re.hK,Pt,6,t.i.a.length,0,2),f=0;f<t.i.a.length;f++)for(i[f]=Ke(re.hK,L,5,ue.Th(t.i,f).length,15,1),l=0;l<ue.Th(t.i,f).length;l++)i[f][l]=-1;for(m=Ke(re.hK,L,5,t.g.e,15,1),w=0;w<t.j.a.length;w++)if(3==(g=ue.Th(t.j,w)).length||g.length>=5&&g.length<=7)for(u=0;u<g.length;u++)s=g[u],3==ce.Am(t.g,ce.Nj(t.g,0,s))&&3==ce.Am(t.g,ce.Nj(t.g,1,s))&&(m[s]>0?(i[m[s]>>>16][32767&m[s]]=w,i[w][u]=m[s]>>>16):m[s]=32768+(w<<16)+u);for(a=Ke(re.DN,ft,5,t.i.a.length,16,1),d=0,c=-1;d>c;)for(c=d,h=0;h<t.i.a.length;h++)a[h]||ce.Hp(t,h,i,a,n,e,o,r)&&(a[h]=!0,++d)},ce.Jp=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g;for(r=ce.Nj(t.g,0,n),i=ce.Nj(t.g,1,n),u=Ke(re.hK,L,5,t.g.d,15,1),f=Ke(re.hK,L,5,t.g.d,15,1),l=Ke(re.hK,L,5,t.g.d,15,1),u[0]=r,u[1]=i,f[r]=1,f[i]=2,l[r]=-1,l[i]=r,s=1,c=1;s<=c;){for(h=0;h<ce.Am(t.g,u[s]);h++){if(a=ce.zm(t.g,u[s],h),s>1&&a==r){for(g=Ke(re.hK,L,5,f[u[s]],15,1),o=u[s],w=0;w<g.length;w++)g[w]=o,o=l[o];return g}0!=f[a]||e[a]||(u[++c]=a,f[a]=f[u[s]]+1,l[a]=u[s])}++s}return null},ce.Kp=function(t,n,e){var o,r;for(r=ue.Th(t.i,n),o=0;o<r.length;o++)if(e==r[o])return o;return-1},ce.Lp=function(t,n){return t.a[n]},ce.Mp=function(t,n,e){var o,r;for(r=ue.Th(t.j,n),o=0;o<r.length;o++)if(e==r[o])return o;return-1},ce.Np=function(t,n){return t.b[n]},ce.Op=function(t,n){return t.c[n]},ce.Pp=function(t,n){return ue.Th(t.i,n)},ce.Qp=function(t,n){return ue.Th(t.j,n)},ce.Rp=function(t,n){var e,o,r,i,a;for(i=n.length,a=Ke(re.hK,L,5,i,15,1),o=0;o<i;o++)for(e=o==i-1?n[0]:n[o+1],r=0;r<ce.Am(t.g,n[o]);r++)if(ce.zm(t.g,n[o],r)==e){a[o]=ce.Bm(t.g,n[o],r);break}return a},ce.Sp=function(t,n){return ue.Th(t.j,n).length},ce.Tp=function(t,n,e){var o;for(o=0;o<t.j.a.length;o++)if(ce.Wp(t,o,n)&&ce.Wp(t,o,e))return o;return-1},ce.Up=function(t,n){return t.d[n]},ce.Vp=function(t,n,e){var o,r;for(r=ue.Th(t.i,n),o=0;o<r.length;o++)if(e==r[o])return!0;return!1},ce.Wp=function(t,n,e){var o,r;for(r=ue.Th(t.j,n),o=0;o<r.length;o++)if(e==r[o])return!0;return!1},ce.Xp=function(t,n){return t.e[n]},ce.Yp=function(t,n){var e,o,r,i,a,s;for(a=0;a<2;a++)if(e=ce.Nj(t.g,a,n),7==ce.Ij(t.g,e)&&2==ce.Am(t.g,e)&&(o=ce.Nj(t.g,1-a,n),6==ce.Ij(t.g,o)))for(s=0;s<ce.Am(t.g,o);s++)if(r=ce.zm(t.g,o,s),i=ce.Bm(t.g,o,s),(8==ce.Ij(t.g,r)||16==ce.Ij(t.g,r))&&2==ce.Vj(t.g,i)&&1==ce.Am(t.g,r))return!0;return!1},ce.Zp=function(t,n){return ce.Vj(t.g,n)>1||64==ce.Yj(t.g,n)},ce.$p=function(t,n,e){var o,r,i;for(i=n.length,r=0;r<i;r++)(0==t.a[n[r]]||t.a[n[r]]>i)&&(t.a[n[r]]=i);for(o=0;o<i;o++)(0==t.b[e[o]]||t.b[e[o]]>i)&&(t.b[e[o]]=i)},ce._p=function(t,n,e){var o;for(o=ue.Th(t.j,n).length;e>=o;)e-=o;for(;e<0;)e+=o;return e},ce.aq=function(t,n){ce.bq.call(this,t,n)},ce.bq=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G;this.g=t,this.f=7,this.i=new ue.gi,this.j=new ue.gi,this.a=Ke(re.hK,L,5,this.g.d,15,1),this.b=Ke(re.hK,L,5,this.g.e,15,1),this.g.qb(1),h=Ke(re.DN,ft,5,this.g.d,16,1),w=Ke(re.DN,ft,5,this.g.e,16,1);do{for(a=!1,e=0;e<this.g.d;e++)if(!h[e]){for(d=0,c=0;c<ce.Am(this.g,e);c++)h[ce.zm(this.g,e,c)]||++d;if(d<2){for(h[e]=!0,l=0;l<ce.Am(this.g,e);l++)w[ce.Bm(this.g,e,l)]=!0;a=!0}}}while(a);for(G=0;G<this.g.d&&h[G];)++G;if(G!=this.g.d){for((u=Ke(re.hK,L,5,this.g.d,15,1))[0]=G,(m=Ke(re.hK,L,5,this.g.d,15,1))[0]=-1,(s=Ke(re.hK,L,5,this.g.d,15,1))[G]=1,i=0,f=0,g=1;i<=f;){for(l=0;l<ce.Am(this.g,u[i]);l++)(r=ce.zm(this.g,u[i],l))!=m[u[i]]&&(0==s[r]?h[r]||(s[r]=g,m[r]=u[i],u[++f]=r):ce.Gp(this,ce.Bm(this.g,u[i],l),h));if(++i>f)for(e=0;e<this.g.d;e++)if(0==s[e]&&!h[e]){s[e]=++g,u[++f]=e,m[e]=-1;break}}if(0!=(4&n)&&(this.d=Ke(re.DN,ft,5,this.i.a.length,16,1),this.e=Ke(re.DN,ft,5,this.i.a.length,16,1),this.c=Ke(re.hK,L,5,this.i.a.length,15,1),ce.Ip(this,this.d,this.e,this.c,!1)),0!=(2&n))for(o=0;o<this.g.e;o++)w[o]||0==ce.Vj(this.g,o)||null!=(p=ce.Jp(this,o,h))&&ce.$p(this,p,ce.Rp(this,p))}},Te(81,1,{},ce.aq),a.f=0,re.NK=vo(81),ce.cq=function(t,n){var e,o,r,i,a,s,u,f,l,c;if(c=ce.Eq(t.B,t.B.length),2!=n&&5!=n){if(0==t.n&&4!=n&&3!=n);else if(c=ce.oq(c),4==n)ue.kZ(t.J,c)||(ue.iZ(t.J,c),ue.Oh(t.A,ce.Eq(t.B,t.B.length)));else if(3==n&&!ue.kZ(t.J,c)){for(l=!1,a=new ue.IY(new ue.NY(new ue.vW(t.J.a).a).b),u=new ue.DW(a);ue.OU(u.a.a);){for(s=ue.GY(u.a).Sb(),f=0,r=0,i=(o=c).length;r<i;++r){for(e=o[r];f<s.length&&s[f]<e;)++f;if(f<s.length&&e==s[f]){l=!0;break}}if(l)break}l||(ue.iZ(t.J,c),ue.Oh(t.A,ce.Eq(t.B,t.B.length)))}}else ue.Oh(t.A,c)},ce.dq=function(t,n,e){var o,r,i,a,s,u,f,l,c,h;if(u=ce.Am(t.C,n),(r=t.k[e])>u)return!1;if(l=ce.Dj(t.C,n),a=ce.Dj(t.f,e),i=ce.yj(t.f,e),f=ce.yj(t.C,n),0!=(1&a)){if(null!=i)if(0!=(1&l)){if(null==f)return!1;if(!ce.tq(i,f))return!1}else if(null!=f){if(ce.vq(f,i))return!1}else if(ce.sq(ce.Ij(t.C,n),i))return!1}else{if(0!=(1&l))return!1;if(null!=i){if(null!=f){if(!ce.tq(f,i))return!1}else if(!ce.sq(ce.Ij(t.C,n),i))return!1}else{if(null!=f)return!1;if(t.F[n]!=t.i[e])return!1}}if(0!=(l|a)){if(0!=(a&Ct)){if(t.C.I&&0==(l&Ct))return!1;if(r!=u)return!1}if(0!=(a&B)&&r>=u&&0==(l&B))return!1}if(0!=(t.D[n]&~t.g[e]))return!1;if(0!=ce.rj(t.f,e)&&ce.rj(t.f,e)!=ce.rj(t.C,n))return!1;if(0!=ce.Bj(t.f,e)&&ce.Bj(t.f,e)!=ce.Bj(t.C,n))return!1;if(0!=(h=(ce.Dj(t.f,e)&At)>>22)){if(t.C.I&&h==(ce.Dj(t.C,e)&At)>>22)return!0;for(o=!1,c=ce.Ym(t.C),s=0;s<c.i.a.length;s++)if(ue.Th(c.j,s).length==h&&ce.Vp(c,s,n)){o=!0;break}if(!o)return!1}return!0},ce.eq=function(t,n,e){var o,r,i,a;if(0!=(t.G[n]&~t.j[e]))return!1;if(0!=(a=(ce.Xj(t.f,e)&Dt)>>15)){if(t.C.I&&a==(ce.Xj(t.C,e)&Dt)>>15)return!0;for(o=!1,i=ce.Ym(t.C),r=0;r<i.i.a.length;r++)if(ue.Th(i.j,r).length==a&&ce.Wp(i,r,n)){o=!0;break}if(!o)return!1}return!0},ce.fq=function(t){var n,e;for(t.a=null,n=0;n<t.f.e;n++)ce.pk(t.f,n)&&(!t.a&&(t.a=new ue.gi),(e=new ce.Fq).a=ce.Nj(t.f,0,n),e.b=ce.Nj(t.f,1,n),e.d=ce.Pj(t.f,n),e.c=ce.Oj(t.f,n),ue.Oh(t.a,e))},ce.gq=function(n){var e,o,r,i,a,s,u,f,l,c,h,w;for(ce.Jr(n.f,n.I),f=t.Math.max(n.f.d,n.f.e)+16,n.q=Ke(re.hK,L,5,f,15,1),n.s=Ke(re.hK,L,5,f,15,1),n.t=Ke(re.hK,L,5,f,15,1),n.r=Ke(re.DN,ft,5,f+1,16,1),s=Ke(re.DN,ft,5,n.f.d,16,1),u=Ke(re.DN,ft,5,n.f.e,16,1),r=0,o=0;o<n.f.d;o++)if(!n.w[o]&&!s[o])for(n.q[r]=o,n.t[r]=-1,n.s[r]=-1,l=r;r<=l;){for(c=0;c<ce.nm(n.f,n.q[r]);c++)l=ce.Cq(n,r,l,c,s,u,-1);for(;n.r[++r];);}if(n.u=r,0!=n.n){for(l=n.u-1,a=0;a<n.c;a++)for(r=0;r<=l;){for(h=0;h<ce.nm(n.f,n.q[r]);h++)l=ce.Cq(n,r,l,h,s,u,a);for(;n.r[++r];);}for(e=0;e<n.f.d;e++)if(n.w[e]&&!s[e])for(n.q[r]=e,n.t[r]=-1,n.s[r]=-1,l=r;r<=l;){for(h=0;h<ce.nm(n.f,n.q[r]);h++)ce.zm(n.f,n.q[r],h)<n.f.d&&(l=ce.Cq(n,r,l,h,s,u,n.e[e]));for(;n.r[++r];);}for(n.d=Ke(re.hK,L,5,n.c,15,1),w=0;w<n.c;w++)n.d[w]=-1;for(c=n.u;c<r;c++)i=n.e[n.q[c]],-1==n.d[i]&&(n.d[i]=c)}n.v=r},ce.hq=function(t,n){var e,o,r,i,a,s,u,f;for(f=ce.Ym(t.C),s=0;s<f.i.a.length;s++)if(ce.Wp(f,s,n)){for(u=Ke(re.hK,L,5,2,15,1),r=0;r<2;r++)for(u[r]=N,o=ce.Nj(t.C,r,n),i=0;i<ce.Am(t.C,o);i++)(e=ce.zm(t.C,o,i))!=ce.Nj(t.C,1-r,n)&&u[r]>e&&(u[r]=e);return a=0,ce.Vp(f,s,u[0])&&++a,ce.Vp(f,s,u[1])&&++a,2==a?2:1==a?1:2}return 0},ce.iq=function(t,n,e){var o,r,i;if(t.a)for(r=new ue.KW(t.a);r.a<r.c.a.length;)if(o=ue.JW(r),(null==t.e||-1==e&&-1==t.e[o.a]&&-1==t.e[o.b]||-1!=e&&(t.e[o.a]==e||t.e[o.b]==e))&&((i=ce.Wm(t.C,t.B[o.a],t.B[o.b],o.c+1,n)-1)<o.d||i>o.c))return!1;return!0},ce.jq=function(t,n){var e,o,r,i,a,s,u,f;for(r=0;r<t.f.e;r++)if(0!=(ce.Xj(t.f,r)&Bt)){if(0==(i=ce.Wj(t.f,r)))continue;if(e=ce.Nj(t.f,0,r),o=ce.Nj(t.f,1,r),null==t.e||-1==n&&-1==t.e[e]&&-1==t.e[o]||-1!=n&&(t.e[e]==n||t.e[o]==n)){if(a=t.B[e],s=t.B[o],u=ce.xm(t.C,a,s),0==(f=ce.Wj(t.C,u))&&(ce.An(t.C,u)&&(f=ce.hq(t,u)),0==f))continue;if(3==i)continue;if(3==f)continue;if(ce.pq(t,r)==(i==f))return!1}}return!0},ce.kq=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g;for(a=0,u=0;u<t.f.d;u++)if((null==t.e||t.e[u]==n)&&0!=(ce.Dj(t.f,u)&dt)){if(h=t.B[u],c=ce.Cj(t.f,u),g=ce.Cj(t.C,h),0==c)continue;if(0==g)continue;if(3==c)continue;if(3==g)continue;if(1==ce.wj(t.f,u)){++a;continue}if(1==ce.wj(t.C,h))return!1;if(2==ce.wj(t.f,u)){++a;continue}if(2==ce.wj(t.C,h))return!1;if(ce.uq(t,u)==(c==g))return!1}if(0!=a){for(r=Ke(re.hK,L,5,a,15,1),i=0,f=0;f<t.f.d;f++)null!=t.e&&t.e[f]!=n||0==(ce.Dj(t.f,f)&dt)||0!=(c=ce.Cj(t.f,f))&&3!=c&&(r[i++]=ce.vj(t.f,f)<<24|ce.wj(t.f,f)<<22|f);for(le.V$(r).sort(le.V$(Ie(ue.pX.prototype.Ub,ue.pX,[]))),i=0;i<r.length;)for(l=r[i]&en,w=t.B[l],e=-4194304&r[i],o=ce.uq(t,l)^ce.Cj(t.f,l)==ce.Cj(t.C,w),++i;i<r.length&&(-4194304&r[i])==e;i++){if(s=r[i]&en,h=t.B[s],ce.wj(t.C,h)!=ce.wj(t.C,w)||ce.vj(t.C,h)!=ce.vj(t.C,w))return!1;if((ce.uq(t,s)^ce.Cj(t.f,s)==ce.Cj(t.C,h))!=o)return!1}}return!0},ce.lq=function(t,n,e){var o,r,i,a,s,u,f;if(t.A=new ue.gi,ue.jY(t.J.a),!t.C||!t.f)return 0;if(t.f.d-t.n>t.C.d||t.f.e-t.o>t.C.e)return 0;if(0==t.f.d)return 0;for(ce.yq(t,e),o=Ke(re.DN,ft,5,t.C.d,16,1),t.B=Ke(re.hK,L,5,t.f.d,15,1),ue.SW(t.B),s=Ke(re.hK,L,5,t.v,15,1),ue.VW(s,s.length,-1),i=0;;){if(0!=t.u){if(f=-1==t.s[i]?t.C.d:ce.nm(t.C,t.B[t.s[i]]),++s[i],s[i]==f){if(s[i]=-1,0==i)break;--i,t.r[i]||(o[t.B[t.q[i]]]=!1);continue}if(-1==t.s[i])o[s[i]]||ce.dq(t,s[i],t.q[i])&&(t.B[t.q[i]]=s[i],o[s[i]]=!0,++i);else{if(ce.zm(t.C,t.B[t.s[i]],s[i])>=t.C.d)continue;r=ce.zm(t.C,t.B[t.s[i]],s[i]),t.r[i]?r==t.B[t.q[i]]&&ce.eq(t,ce.Bm(t.C,t.B[t.s[i]],s[i]),t.t[i])&&++i:o[r]||ce.dq(t,r,t.q[i])&&ce.eq(t,ce.Bm(t.C,t.B[t.s[i]],s[i]),t.t[i])&&(o[r]=!0,t.B[t.q[i]]=r,++i)}}if(i==t.u){if(ce.kq(t,-1)&&ce.jq(t,-1)&&ce.iq(t,o,-1)){for(u=!1,a=0;a<t.c;a++)if(ce.qq(t,o,s,a)){u=!0;break}if(1==n&&!u)return 1;if(!u&&(ce.cq(t,n),2==n))return 1}if(0==i)break;--i,t.r[i]||(o[t.B[t.q[i]]]=!1)}}return t.A.a.length},ce.mq=function(t,n){var e,o,r,i,a;if(i=0,t.I)switch(0!=(t.s[n]&B)&&(i|=2),0!=(a=0==(o=t.s[n]&Qt)?0:o==Gt?2:o==Ct?3:4)&&(i|=8,a>2&&(i|=16),a>3&&(i|=32)),(e=t.q[n])<0?i|=jt:e>0&&(i|=yt),t.g[n]){case 0:break;case 1:i|=Ot;break;case 2:i|=Mt;break;case 3:i|=917504;break;default:i|=1966080}else{switch(0!=(t.s[n]&B)?i|=2:i|=4,i|=0==(a=0==(o=t.s[n]&Qt)?0:o==Gt?2:o==Ct?3:4)?112:2==a?104:3==a?88:56,0==(e=t.q[n])?i|=167772160:e<0?i|=jt:e>0&&(i|=yt),t.c[n]-ce.Rm(t,n)+ce.Nm(t,n)){case 0:i|=1792;break;case 1:i|=1664;break;case 2:i|=1408;break;default:i|=896}switch(t.g[n]){case 0:i|=3932160;break;case 1:i|=3801088;break;case 2:i|=3538944;break;case 3:i|=3014656;break;default:i|=1966080}switch(t.k[n]){case 0:i|=98304;break;case 1:i|=81920;break;default:i|=49152}}return(r=t.k[n])>0&&(i|=$),r>1&&(i|=32768),i},ce.nq=function(t,n){var e;if(e=0,0!=(512&t.C[n])||64==t.F[n])e|=8;else switch(ce.Vj(t,n)){case 0:e|=32;break;case 1:e|=1;break;case 2:e|=2;break;case 3:e|=4}return 0!=(64&t.C[n])?e|=64:t.I||(e|=32),0!=(256&t.C[n])?e|=It:t.I||(e|=T),e},ce.oq=function(t){var n,e,o,r,i,a,s,u,f,l;for(u=0,i=0,s=(o=t).length;i<s;++i)-1==(n=o[i])&&++u;if(0!=u)for(l=t,t=Ke(re.hK,L,5,l.length-u,15,1),f=0,r=0,a=(e=l).length;r<a;++r)-1!=(n=e[r])&&(t[f++]=n);return le.V$(t).sort(le.V$(Ie(ue.pX.prototype.Ub,ue.pX,[]))),t},ce.pq=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w;for(i=!1,r=0;r<2;r++)if(e=ce.Nj(t.f,r,n),l=t.B[e],ce.Am(t.C,l)>2){for(h=ce.Nj(t.f,1-r,n),u=N,s=0;s<ce.Am(t.f,e);s++)(o=ce.zm(t.f,e,s))!=h&&u>o&&(u=o);for(w=t.B[h],f=N,a=0;a<ce.Am(t.C,l);a++)(c=ce.zm(t.C,l,a))!=w&&f>c&&(f=c);t.B[u]!=f&&(i=!i)}return i},ce.qq=function(t,n,e,o){var r,i,a,s,u,f,l,c;for(u=(s=t.d[o])+1;u<t.v&&t.e[t.q[u]]==o;)++u;for(l=s;l<u;l++)e[l]=-1;for(a=s;;)if(c=-1==t.s[a]?t.C.d:ce.nm(t.C,t.B[t.s[a]]),++e[a],e[a]!=c){if(-1==t.s[a])n[e[a]]||ce.dq(t,e[a],t.q[a])&&(t.B[t.q[a]]=e[a],n[e[a]]=!0,++a);else{if(ce.zm(t.C,t.B[t.s[a]],e[a])>=t.C.d){++e[a];continue}i=ce.zm(t.C,t.B[t.s[a]],e[a]),t.r[a]?i==t.B[t.q[a]]&&ce.eq(t,ce.Bm(t.C,t.B[t.s[a]],e[a]),t.t[a])&&++a:n[i]||ce.dq(t,i,t.q[a])&&ce.eq(t,ce.Bm(t.C,t.B[t.s[a]],e[a]),t.t[a])&&(n[i]=!0,t.B[t.q[a]]=i,++a)}if(a==u){if(ce.kq(t,o)&&ce.jq(t,o)&&ce.iq(t,n,o)){for(f=s;f<u;f++)t.r[f]||(r=t.q[f],n[t.B[r]]=!1,t.B[r]=-1);return!0}--a,t.r[a]||(n[t.B[t.q[a]]]=!1,t.B[t.q[a]]=-1)}}else{if(e[a]=-1,a==s)break;--a,t.r[a]||(n[t.B[t.q[a]]]=!1,t.B[t.q[a]]=-1)}return!1},ce.rq=function(t){return ce.lq(t,1,t.b)>0},ce.sq=function(t,n){var e;for(e=0;e<n.length;e++)if(n[e]==t)return!0;return!1},ce.tq=function(t,n){var e,o,r;for(r=0,o=0;o<t.length;o++){for(e=t[o];n[r]<e;)if(++r==n.length)return!1;if(n[r]>e)return!1}return!0},ce.uq=function(t,n){var e,o,r,i,a,s,u,f;if(a=!1,0==ce.qm(t.f,n))for(i=1;i<ce.Am(t.f,n);i++)for(s=0;s<i;s++)o=ce.zm(t.f,n,i),r=ce.zm(t.f,n,s),t.B[o]>t.B[r]^o>r&&(a=!a);else for(i=0;i<ce.Am(t.f,n);i++){for(e=ce.zm(t.f,n,i),f=0,u=Ke(re.hK,L,5,3,15,1),s=0;s<ce.Am(t.f,e);s++)u[f]=ce.zm(t.f,e,s),u[f]!=n&&++f;2==f&&t.B[u[0]]>t.B[u[1]]^u[0]>u[1]&&(a=!a)}return a},ce.vq=function(t,n){var e,o,r,i;for(r=0,i=0;r<t.length&&i<n.length;){if((e=t[r])==(o=n[i]))return!0;e<o?++r:++i}return!1},ce.wq=function(t,n){var e,o,r,i,a;if(n&&0!=n.o&&n.I){for(t.f=n,t.p=!1,ce.Jr(t.f,1),t.I=7,o=0;o<t.f.d;o++)0!=(ce.Dj(t.f,o)&dt)&&(t.I=15);for(a=0;a<t.f.e;a++)0!=(ce.Xj(t.f,a)&Bt)&&(t.I=15);for(t.H&&7!=t.I&&ce.Jr(t.C,t.I),t.n=0,t.o=0,t.w=Ke(re.DN,ft,5,t.f.d,16,1),r=0;r<t.f.d;r++)t.w[r]=0!=(ce.Dj(t.f,r)&lt),t.w[r]&&++t.n;if(t.c=0,t.e=null,0!=t.n){if(0!=t.n)for(i=0;i<t.f.e;i++)(t.w[ce.Nj(t.f,0,i)]||t.w[ce.Nj(t.f,1,i)])&&++t.o;for(e=0;e<t.f.o;e++)ce.cl(t.f,e,t.w[e]);t.e=Ke(re.hK,L,5,t.f.o,15,1),t.c=ce.Im(t.f,t.e,!0,!1)}}else t.f=null},ce.xq=function(t,n){n&&0!=n.o?(t.C=n,t.H=!1,ce.Jr(t.C,1)):t.C=null},ce.yq=function(t,n){t.H||(ce.Bq(t,n),t.H=!0),t.p||(ce.zq(t,n),ce.gq(t),ce.fq(t),t.p=!0)},ce.zq=function(t,n){var e,o,r,i,a,s,u,f,l,c;for(i=null,u=null,a=null,ce.Jr(t.f,t.I),t.k=Ke(re.hK,L,5,t.f.d,15,1),o=0;o<t.f.d;o++)t.k[o]=ce.Am(t.f,o);if(0!=t.n){for(f=new ce._r(t.f.o,t.f.p),c=Ke(re.DN,ft,5,t.f.o,16,1),r=0;r<t.f.o;r++)c[r]=!t.w[r];for(ce.dm(t.f,f,c,!0,null),ce.Jr(f,t.I),ce.Aq(t,f,n),i=t.g,u=t.j,a=t.i,l=0,e=0;e<t.f.d;e++)t.w[e]||(t.k[e]=ce.Am(f,l++))}if(ce.Aq(t,t.f,n),0!=t.n){for(l=0,e=0;e<t.f.o;e++)t.w[e]||(t.g[e]=i[l],t.i[e]=a[l++]);for(l=0,s=0;s<t.f.p;s++)!t.w[ce.Nj(t.f,0,s)]&&!t.w[ce.Nj(t.f,1,s)]&&(t.j[s]=u[l++])}},ce.Aq=function(t,n,e){var o,r,i,a;for(i=n.d,t.g=Ke(re.hK,L,5,n.d,15,1),t.i=Ke(re.hK,L,5,n.d,15,1),o=0;o<i;o++)t.g[o]=(ce.mq(n,o)|n.w[o])&Nn^Nn,t.i[o]=n.A[o],0!=(1&e)&&(t.i[o]+=n.q[o]+16<<8),0!=(2&e)&&(t.i[o]+=n.v[o]<<16);for(a=n.e,t.j=Ke(re.hK,L,5,n.e,15,1),r=0;r<a;r++)t.j[r]=1572991&(ce.nq(n,r)|n.D[r])^1572960,0!=(4&e)?0!=(2&t.j[r])&&(t.j[r]|=8):0!=(8&e)&&0!=(2&t.j[r])&&0!=(256&n.C[r])&&(t.j[r]|=8)},ce.Bq=function(t,n){var e,o,r,i;for(ce.Jr(t.C,t.I),r=t.C.d,t.F=Ke(re.hK,L,5,r,15,1),t.D=Ke(re.hK,L,5,r,15,1),e=0;e<r;e++)t.D[e]=(ce.mq(t.C,e)|ce.Dj(t.C,e))&Nn^Nn,t.F[e]=ce.Ij(t.C,e),0!=(1&n)&&(t.F[e]+=ce.rj(t.C,e)+16<<8),0!=(2&n)&&(t.F[e]+=ce.Bj(t.C,e)<<16);for(i=t.C.e,t.G=Ke(re.hK,L,5,i,15,1),o=0;o<i;o++)t.G[o]=1605631&(ce.nq(t.C,o)|ce.Xj(t.C,o))^1572960},ce.Cq=function(t,n,e,o,r,i,a){var s,u;return s=ce.zm(t.f,t.q[n],o),t.w[s]&&t.e[s]!=a||s==t.s[n]||i[u=ce.Bm(t.f,t.q[n],o)]||ce.pk(t.f,u)||(t.q[++e]=s,t.s[e]=t.q[n],t.t[e]=u,i[u]=!0,r[s]?t.r[e]=!0:r[s]=!0),e},ce.Dq=function(){this.b=8,this.A=new ue.gi,this.J=new ue.mZ(new pe.dG)},ce.Eq=function(n,e){var o;return o=Ke(re.hK,L,5,e,15,1),ie.pS(n,0,o,0,t.Math.min(n.length,e)),o},Te(92,1,{},ce.Dq),a.b=0,a.c=0,a.n=0,a.o=0,a.p=!1,a.u=0,a.v=0,a.H=!1,a.I=0,re.QK=vo(92),ce.Fq=function(){},Te(108,1,{108:1},ce.Fq),a.a=0,a.b=0,a.c=0,a.d=0,re.OK=vo(108),ce.Iq=function(){ce.Iq=De,ce.Gq=Oe($e(re.uM,1),P,2,6,["QM@HzAmdqjF@","RF@Q``","qC`@ISTAlQE`","`J@H","QM@HzAmdqbF@","qC`@ISTAlQEhqPp@","sJP@DiZhAmQEb","RF@QPvR@","QM@HzA@","qC`@ISTAlQEhpPp@","qC`@Qz`MbHl","sJP@DiZhAmQEcFZF@","RFPDXH","qC`@IVtAlQE`","QM@HvAmdqfF@","sGP@DiVj`FsDVM@","`L@H","sJP@DizhAmQEcFBF@","sJP@DjvhAmQEb","sFp@DiTt@@AlqEcP","sGP@LdbMU@MfHlZ","QMHAIhD","QM@HzAy@","sJP@DkVhAmQEb","sNp@DiUjj@[\\QXu`","sJP@DiZhAmQEcFBF@","sGP@DjVj`FsDVM@","RFPDTH","RG@DXOH@","sGP@Divj`FsDVMcAC@","sGP@Dj}j`FsDVM@","qC`@Qz`MbHmFRF@","sNp@LdbJjj@[\\QXu`","QMHAIhGe@","QM@HzAyd`","QM`AIhD","qC`@ISTA@","sGP@DkUj`FsDVM@","qC`@IVtAlQEhqPp@","sNp@DiUjj@[\\QXuqea`@","KAx@@IRjuUPAlHPfES\\","QM`BN`P","sJP@DjZhAmQEcFJF@","Hid@@DjU^nBBH@FtaBXUMp`","sNp@Diujj@[\\QXuq`a`@","sJP@DjvhAmQEcFZF@","sJP@DjZhAmQEcFFF@","sOp@DjWkB@@FwDVM\\YhX@","sNp@Dj}Zj@[\\QXu`","sNp@DiWjj@[\\QXuq`a`@","sOp@DjWkB@@D","KAx@@ITouUPAlHPfES\\","KAx@@YIDTjjh@vDHSBin@","sNp@DkUZj@[\\QXu`","RFPDXOH@","QM`BN`^L`","qC`@ISTAy@","sGP@LdbMU@MfHl[FVF@","qCb@AIZ`H","KAx@@IRjuUPAlHPfES]FFa`@","KAx@@ITnuUPAlHPfES\\","HiD@@DiUVjj`AmHPfES\\H","sNp@DjUjj@[\\QXu`","sJP@DkVhAmQEcFJF@","sGP@DjVj`FsDVMcCC@","qC`@Qz`MbHmFBF@","sJP@DkfhAmQEb","qC`@IVtAlQEhsPp@","sGP@Djuj`FsDVM@","sGP@Dj}j`FsDVMcMC@","sJP@DiZhA@","KAx@@ISjuUPAlHPfES]F@a`@","sJP@DjZhAmQEcFRF@","KAx@@IRnuUPAlHPfES]F@a`@","HiD@@DjWvjj`AmHPfES\\H","QMHAIhGd@","sNp@DiUjj@[\\QXuq`a`@","KAx@@IVjmUPAlHPfES\\","sGP@DjVj`FsDVMcMC@","QM`AIhGe@","HiD@@LdbJRjjh@[RDIaTwB","qCp@AIZ`H","sGP@LdbMU@MfHl[FFF@","QMDARVA@","sNp@LdbJjj@[\\QXuqba`@","sNp@LdbJjj@[\\QXuqca`@","sGP@Dkej`FsDVM@","qCb@AIZ`OI@","HaD@@DjUZxHH@AlHPfES]FLa`@","sGP@DkYj`FsDVM@","qCb@AIV`H","sNp@LdbJjj@[\\QXuqea`@","sGP@DkUj`FsDVMcEC@","sFp@DiTt@@Axa@","Hmt@@DjU_ZxHHj@AmhPfES\\Lj","QM`BN`^P","qCb@AIZ`OH`","sFp@DiTt@@AxaP","sGP@Djuj`FsDVMcEC@","sGP@Djuj`FsDVMcIC@","sGP@DkUj`FsDVMcKC@","sJP@DkfhAmQEcFRF@","sGP@DjVj`FsDVMcIC@","HaD@@DjUZxHH@AlHPfES]FFa`@","qC`@IRtDVqDV@","sNp@Dj}Zj@[\\QXuqfa`@","KAx@@ITnuUPAlHPfES]FFa`@","HiD@@DkUUjj`AmHPfES\\H","sJQ@@dkU@H","qC`@Qz`H","KAx@@IUkmUPAlHPfES\\","KAx@@ITouUPAlHPfES]FJa`@","sJP@H~j@[TQX`","sGP@DjZj`FsDVM@","sJP@DkVhAmQEcFFF@","sJX@@eKU@H","sJP@DizhAy@","QMHAIhGbP","KAx@@ITouUPAlHPfES]FNa`@","HaD@@DjUZxHD@AlHPfES\\","HaD@@DjUZxHH@A@","sNp@LdbJjj@[\\QXuqaa`@","Hed@@LdbRQUUUP@vTHSBinFP","KAx@@ITouUPAlHPfES]FLa`@","sNp@DkUZj@[\\QXuqba`@","KAx@@ITjuUPAlHPfES]FNa`@","KAx@@YIDTjjh@vDHSBincGPp@","HaD@@DjYvxH`@AlHPfES]FLa`@","RF@QP`","qCb@AIj`H","sNp@DjUjj@[\\QXuqaa`@","sNp@DkVZj@[\\QXu`","KAx@@YIDUJjh@vDHSBin@","sGP@DkYj`FsDVMcIC@","sGP@DjVj`FsDVMcAC@","sGP@DiVj`D","sJP@DkVhAmQEcFZF@","sNp@LdbLjj@[\\QXu`","QM@HvAmdqbF@","HaD@@DjWjXHB@AlHPfES\\","sNp@DjwZj@[\\QXuqba`@","sNp@LdbJjj@[\\QXuqda`@","sFp@DiTt@@Axa`","HiD@@Djuujj`AmHPfES\\H","sNp@DkUZj@[\\QXuqca`@","sJP@DiZhAy@","KAx@@YIDTjjh@vDHSBincCPp@","KAx@@IWNmUPAlHPfES\\","KAx@@IVkMUPAlHPfES\\","sJQ@@dju@H","qCb@AIZ`OH@","qC`@ISTAxa@","sNp@DjyZj@[\\QXu`","Hid@@DjUfaBB`@FtaBXUMp`","HiD@@DiUVjj`AmHPfES\\LXBF@","KAx@@IUjmUPAlHPfES\\","HiD@@DjWvjj`AmHPfES\\LXjF@","sJP@DjVhAmQEb","qCb@AIV`OH`","HiD@@LdbJRjjh@[RDIaTwCFDa`@","KAx@@YIDTjjh@vDHSBinc@Pp@","sNp@DjUjj@[\\QXuqda`@","qC`@Qz`OED","sJP@DkfhAmQEcFZF@","KAx@@YIDbjjh@vDHSBincDPp@","sGP@Djyj`FsDVMcMC@","KAx@@IVrmUPAlHPfES\\","qCp@AIZ`OI@","sJX@@dkU@H","sJQ@@dkU@OH`","sNp@Di]ZjBBvxbqk@","Hkl@@DjU_Uk``bj`@[VDIaTwCJzX","sGP@DjZj`FsDVMcEC@","Hid@@DjU^nBBH@FtaBXUMpqcHX@","sNp@DkeZj@[\\QXu`","sNp@DjYjj@[\\QXuqca`@","sGQ@@djuT@`","HiD@@LdbJTjjh@[RDIaTwB","sOp@DjWkB@@Gd`","HeT@@LdbbRKBDQD@CYPaLJfxY@","qCr@XIKTA@","HiD@@DjW^jj`AmHPfES\\LXJF@","HeT@@DjU]k``b`@[JDIaTwCH","sGP@Djuj`FsDVMcCC@","`IH`B","sOp@DjWkB@@GdX","sJQ@@eKU@H","KAx@@YIDUJjh@vDHSBincBPp@","sJX@@eKU@OH@","KAx@@YIDTjjh@vDHSBincAPp@","sOq@@drm\\@@@`","KAx@@IUkMUPAlHPfES\\","qCp@AIj`H","Hed@@DjUUjjj@FraBXUMpr","sGX@@eJuT@`","sGP@DkUj`FsDVMcCC@","HiD@@Dj}Ujj`AmHPfES\\LXrF@","KAx@@ITouUPAlHPfES]FHa`@","Hed@@DjWujjj@FraBXUMpsFIa`@","sGP@DiUj``mfHlZ","sFp@DiTvjhAlqEcP","Hid@@DjU^nBBH@FtaBXUMpq`XX@","sJP@DkVdAmQEb","qCp@AIZ`OH`","QMhDRVA@","qC`@ISJAlQE`","qCp@BOTAyhl","sJX@@eOU@ODB","sFp@DiTt@@AyaB","sGP@DkUj`FsDVMcMC@","Hid@@DjYUaBH`@FtaBXUMpqcHX@","qC`@Qz`OH@","HiD@@DjUVjj`AmHPfES\\LXZF@","sJP@H~j@[TQXqda`@","sJX@@eKU@OI@","sNp@Djejj@[\\QXu`","sJQ@@dsU@H","sJQ@@dkU@OI`","KAx@@YIMDVjh@vDHSBin@","Hid@@DjU^nBBD@FtaBXUMp`","sNp@DkgZj@[\\QXuqca`@","qC`@IRtDVqDVcEC@","Hed@@LdbRQeUUP@vTHSBinFP","sNp@DiUjj@P","qC`@IRtDT","sNp@DkYZj@[\\QXuqca`@","KAx@@IUkmUPAlHPfES]FDa`@","KAx@@IVjmUPAlHPfES]FNa`@","sOx@@drm\\@@@`","KAx@@ITjuUPAlHPfES]FBa`@","QMDARVAyH","sJP`@dfvhA@","HeT@@DjU_k``b`@[JDIaTwCLXfF@","KAx@@IToUUPAlHPfES]FJa`@","sGP@DkYj`FsDVMcEC@","qCb@AIZ`ODH","`I@`B","KAx@@IUzmUPAlHPfES]FFa`@","sNp@DkfZj@[\\QXu`","KAx@@ITnuUPAlHPfES]F@a`@","HiD@@LddURjjh@[RDIaTwB","sNp@Dj~Zj@[\\QXuqfa`@","Hed@@Dj{uZjj@FraBXUMpr","KAx@@ITsUUPAlHPfES\\","Hid@@LdbRQk``b@AmHPfES\\LXrF@","sOp@DjWkB@@GdH","sJQ@@dkU@OH@","Hid@@DjU^nBBH@FtaBXUMpqahX@","sGP@DiYj``mfHlZ","KAx@@IToUUPAlHPfES]FLa`@","qCp@AJZ`ODH","Hmt@@DjU]ZxHHj@AmhPfES\\Lj","sGP@DkUjPFsDVM@","qC`@IVtA@","Hed@@LdbJReUUP@vTHSBinFP","sNp@DjuZj@[\\QXuqea`@","KAx@@IUkmUPAlHPfES]FNa`@","HiD@@DkVUjj`AmHPfES\\H","Hed@@DkUeZjj@FraBXUMpr","sNp@DkVZj@[\\QXuqea`@","sJP@DiVhHKZbKFLLL@","HiD@@Djuyjj`AmHPfES\\H","sNp@DjUjj@[\\QXuq`a`@","HeT@@DjYUXPbH`@[JDIaTwCH","HiD@@DjwUjj`AmHPfES\\LXRF@","sNq@@djmUPB","KAx@@YIEEZjh@vDHSBincCPp@","sGP@Di^V`dmfHlZ","Hid@@DjYUaBHP@FtaBXUMp`","sNp@DjYjj@[\\QXuqba`@","sGP@Dkej`FsDVMcKC@","HeT@@DjU^k``b`@[JDIaTwCH","qC`@Qv`MbHmFBF@","sGQ@@djmT@`","qCr@XIKTAyH","qC`@IVtAlQEhpPp@","Hid@@LdbbQxXF@@AmHPfES\\LXjF@","sGP@DkYj`FsDVMcCC@","KAx@@IVsMUPAlHPfES\\","qCp@AIj`ODl","HiD@@DkeUjj`AmHPfES\\H","deT@@DjU[k``b`@vTHSBinFP","sJP@DkVdAmQEcFRF@","HiD@@LdbJTjjh@[RDIaTwCFDa`@","HiD@@DkYyjj`AmHPfES\\H","sJP@DjZhAyH","KAx@@IVkMUPAlHPfES]FDa`@","sJX@@dkU@OI@","Hed@@LdbRQUUUP@vTHSBinFXpLL@","Hed@@DjuUZjj@FraBXUMpr","sGP@Djfj`FsDVMcKC@","sNp@DkVZj@[\\QXuqba`@","sNp@DjyZj@[\\QXuqfa`@","qCb@AIj`OH@","sNp@DjUZj@[\\QXu`","KAx@@IWOMUPAlHPfES\\","Hid@@DjU^nBBH@D","Hed@@DjuvZjj@FraBXUMpr","sJP@DiVhHKZbKFLtL@","dmt@@DjU_ZxHHj@C[PaLJfxYVLKC@","sNp@DjuZj@[\\QXuqca`@","sJP@DkfhAmQEcFJF@","sNp@LdbJZj@[\\QXu`","HeT@@DjU_k``b`@[JDIaTwCLXFF@","KAx@@IVlmUPAlHPfES]FNa`@","HeT@@LdbbRKBDQD@CYPaLJfxYcEPp@","Hid@@DjUZnBBH@FtaBXUMpqcHX@","qCa@CIKTA@","HiD@@Dj~]jj`AmHPfES\\LXFF@","sKP@Di\\Zj@[TQX`","sGP@Djfj`FsDVMcEC@","HiD@@DkgYjj`AmHPfES\\H","sNp@DjuZj@[\\QXuqaa`@","KAx@@YIMDVjh@vDHSBincDPp@","sJP@DjVhHKZbKFLTL@","Hid@@LdbRQk``b@AmHPfES\\LXZF@","HiD@@Dj}Ujj`AmHPfES\\LXzF@","HeT@@DjU_k``bP@[JDIaTwCH","sNp@DkUZi@[\\QXu`","HiD@@DjYfjj`AmHPfES\\H","sGP@DjZj`FsDVMcAC@","Hmt@@DjU_jxHHj@AmhPfES\\Lj","Hid@@LdbRQk``R@AmHPfES\\H","KAx@@YIDUJjh@vDHSBincDPp@","qCr@XIKTAyD","sOq@@drm\\@@@|`@","Hed@@DjW^jjj@FraBXUMpsFBa`@","HeT@@DjY]zXFB@@[JDIaTwCH","Hkl@@DjU_Vk``bj`@[VDIaTwCJzX","Hid@@DjY}nBHH@FtaBXUMpqcHX@","sGX@@eKuT@|d@","sGP@Dj^Y`FsDVM@","HcL@@DjU_ZnBBJh@FqaBXUMprn`","sJP@DkVdAmQEcFJF@","sOq@@drm\\@@@|b@","sNp@DjyZj@[\\QXuqaa`@","HaD@@DjUZxHH@AyD@","qC`@Qv`H","dmt@@DjU_ZxHHj@C[PaLJfxYVLYC@","sGP@Dkej`FsDVMcMC@","Hed@@DjUUjjj@FraBXUMpsFHa`@","HeT@@LdbbRkBDQD@CYPaLJfxY@","KAx@@IU{MUPAlHPfES]FLa`@","RG@DTH","sJY@DDeVhA@","KAx@@YIDUJjh@vDHSBinc@Pp@","sJX@@dkU@OI`","sJQ@@dju@OI`","HeT@@LdbbRKBDQD@CYPaLJfxYcFPp@","sFp@DiTvjhAlqEcXpPp@","HaD@@DjUZxHH@AyG@","sNx@@eJ}UPB","sNp@LddUjj@[\\QXuqca`@","HaDH@@RVU[j@@@D","sNp@DkgZi@[\\QXu`","sGY@LDeVj`D","sNp@LdbJfZBZvxbqk@","sJP`@dfvhAyL","sGX@AddQjhAxe`","Hmt@@DjU_ZxHHj@AmhPfES\\LkFIa`@","qCh@CIKTA@","sNp@LdbLjj@[\\QXuq`a`@","sOq@@drm\\@@@|a@","KAx@@IUzmUPAlHPfES]FJa`@","sNx@AddQUUPB","sGP@Di]jP`mfHlZ","sJP`@TeZhA@","KAx@@IRjmUPHKXPaLJfx","HeT@@LdbRTM\\DDT@CYPaLJfxY@","HaF@@@Rfu[j@@@D","Hid@@DjYUaBH`@FtaBXUMpqchX@","KAx@@IUjmTpAlHPfES\\","Hid@@DjU^nBBD@FtaBXUMpqcHX@","sGP@DiUj``mfHl[FFF@","KAx@@IUvmUPAlHPfES]FLa`@","Hed@@LdbQTUUUP@vTHSBinFXqDL@","sJP@DkVhA@","sOx@@drm\\@@@|b@","KAx@@IUkMUPAlHPfES]FDa`@","HeT@@LdbRQU\\DDT@CYPaLJfxY@","HiD@@Dj}Yjj`AmHPfES\\LXrF@","HiD@@Dj{ujj`AmHPfES\\LXFF@","KAx@@IWNmUPAlHPfES]FFa`@","KAx@@IRkMUPHKXPaLJfx","sJP@DjYdAmQEcFZF@","sJY@LDeZhAyL","HaDH@@RVU[f@@@D","sJP`@deVhAyB","HaD@@DjWjZjj`AlHPfES\\","sGP@DkYj`FsDVMcMC@","sNp@DkgZj@[\\QXuqea`@","sJQ@@dlu@H","HeT@@DjU]k``b`@[JDIaTwCLXrF@","sJX@@dkU@OH`","RFDDQFCr`","sJP@DiYXIKZbKFLLL@","KAx@@YIHjjjh@vDHSBincGPp@","Hk\\@@DjU^ukmLHH@@@AmXPfES\\Lki`","sGQ@@djmT@|b@","Hid@@DjUfaBB`@FtaBXUMpqahX@","sNx@@eRmUPB","Hmt@@LdbRVak``ah@FvaBXUMprh","qCr@XIJtA@","KAx@@IWMmUPAlHPfES]FNa`@","HeT@@DjYYZPbJ@@[JDIaTwCH","sNp@DkfZj@[\\QXuqea`@","Hid@@DjU^nBAHAEVtaBXUMp`","dmt@@DjUgZDHJJ@C[PaLJfxYT","sGP@DkejPFsDVM@","sNx@@eJmUPB","qCb@AIf`H","HcL@@DjU_VnBBJh@FqaBXUMprnqcXX@","Hid@@DjUZnBBH@FtaBXUMpqahX@","sNp@LdbQZjBBvxbqkcGC@","sOx@@drm\\@@@|c@","sJP@H~j@^R@","KAx@@YIDcFjhDElHPfES\\","Hid@@DjUZnBAH@FtaBXUMp`","sNp@LddUji@[\\QXu`","sGP@DjfjPFsDVM@","HeT@@DjYUXPbD`@[JDIaTwCH","KAx@@IUoMUPAlHPfES]FDa`@","sFp@DiTt@@AyaD","Hed@@DjuuZjj@FraBXUMpsFIa`@","HeT@@DjUghP`h`@[JDIaTwCLXfF@","sOp@DjWkjj`FwDVM\\YhX@","sGP@Djfj`FsDVMcIC@","KAx@@IRkmUPHKXPaLJfzL]C@","sNx@@djmUPB","QM`AIdD","sOp@DjWkB@@Gbe@","sNp@DjyZj@[\\QXuqca`@","QM@HuAmd`","sNp@LddUjj@[\\QXuqea`@","daD@@DjUZxHD@CXPaLJfzLYC@","qCb@AIZPH","HiD@@LdbJTjjh@[RDIaTwCF@a`@","Hmt@@DjU_ZxHHi@AmhPfES\\Lj","HaDH@@RYWih@H@D","HiD@@LdbJTjjh@[RDIaTwCFHa`@","sGX@@djuT@|a@","sNp@DkfZj@[\\QXuqaa`@","Hid@@DjU^nBBH@GdL","KAx@@IVkMUPAlHPfES]FJa`@","qCr@XIKTAy@","HmT@@Dj{uVjjh@[ZDIaTwCJqaXX@","dmt@@DjYWVDHbJ@C[PaLJfxYT","Hif@@@RUe^Fh@@@P","HaDH@@Rfu[j@@@GdH","KAx@@IVsMUPAlHPfES]FDa`@","sKP@Di\\Zj@[TQXq`a`@","sJX@@eMU@OH@","HeT@@DjU^k``b`@[JDIaTwCLXFF@","Hmt@@LdbbRJXPbHh@FvaBXUMprh","sJP@DjvhAmQEcFBF@","dmt@@LdbbRNXPbHh@MmBDpj[aeXplL@","sJP`@dfvhAyD","sGP@Di^V`dmfHl[FVF@","KAx@@IVsmUPAlHPfES]FBa`@","sOq@@drm\\@@@|PP","sJY@BDeZhA@","HeT@@LdbRbmBDED@CYPaLJfxY@","Hed@@Djy[Zjj@FraBXUMpr","HeT@@DjU]k``b`@[JDIaTwCLXFF@","Hid@@DjUfaBB`@D","qCa@CIJtA@","QMPARVA@","Hid@@DjUfaBB`@FtaBXUMpqcHX@","sJY@BDfZhA@","HeT@@DjUghP`hP@[JDIaTwCH","Hed@@Dj{uZjj@FraBXUMpsFIa`@","dmt@@DjYUvDHbJ@C[PaLJfxYVLUC@","sNp`@dfuZj@P","sJQ@@dmU@OH@","sJX@@dmU@H","HeT@@DjU]k``b`@[JDIaTwCLXZF@","HiD@@LdfbJZjh@[RDIaTwCFAa`@","sOx@@drm\\@@@|a@","deT@@DjUfhP`h`@vTHSBinFP","dmt@@DjU]ZxHHj@C[PaLJfxYVLKC@","sOp@DjWkjj`FwDVM\\XHX@","HcL@@LdbbRNSBDQEP@McBDpj[ae]cFpp@","HiD@@Dj}Yji`AmHPfES\\H","HaDH@@RYe[hB@@D","Hid@@DjU^njjj@FtaBXUMpq`XX@","deT@@LdbbRKBDQB@FraBXUMpr","QMPARZA@","sOq@@drm\\@@@|QX","HaD@@DjYvxH`@A@","HcL@@LdbbRNcBDQEP@McBDpj[ae]@","QMhDRZA@","RG@DXLHmP","QM`BN`XQYd","RG@DTLHmP","QMHAIXFEVd","QMDARVAaH","RFPDXLHmP","RF@Q`vRbdLEC@","RF@QpvR@","QO@HyjAmd`","`II@B","`II@CFspqJp","`II@CF[@hM@prB`","`H@[T[|B`XN@PdM@p|@bHrBcDk@","RG@DXMj}F@","QM`BN`[L~b@","RG@DTMj}D@","QMHAIXFt~j@","QMDARVA}L@","RFPDXMj}D@","sKP@Di\\YZ@[TQXqaa`@","eF`BHD"])},ce.Jq=function(t,n){var e,o;if(!n)return null;for(o=Ke(re.hK,L,5,(ce.Gq.length+31)/32|0,15,1),n=ce.Oq(n),ce.xq(t.g,n),e=0;e<ce.Gq.length;e++)ce.wq(t.g,ce.Hq[e]),ce.lq(t.g,1,4)>0&&(o[e/32|0]|=1<<31-e%32);return o},ce.Kq=function(t,n){var e,o;if(!n)return null;for(o=Ke(re.iK,Vt,5,(ce.Gq.length+63)/64|0,14,1),n=ce.Oq(n),ce.xq(t.g,n),e=0;e<ce.Gq.length;e++)ce.wq(t.g,ce.Hq[e]),ce.lq(t.g,1,4)>0&&(o[e/64|0]=go(o[e/64|0],mo(1,63-e%64)));return o},ce.Lq=function(){var t,n;if(null==ce.Hq)for(n=new ce.io(!1),ce.Hq=Ke(re.XK,p,23,ce.Gq.length,0,1),t=0;t<ce.Gq.length;t++)ce.Hq[t]=ce._n(n,ce.Gq[t]),ce.Jr(ce.Hq[t],1)},ce.Mq=function(t){var n;if(null==t.f)return!1;for(n=0;n<t.f.length;n++)if(0!=(t.c[n]&~t.f[n]))return!1;return ce.Nq(t)},ce.Nq=function(t){return!t.d&&(t.d=ce.bo(new ce.io(!1),t.e,null)),!t.a&&(t.a=ce.bo(new ce.io(!1),t.b,null)),ce.xq(t.g,t.d),ce.wq(t.g,t.a),ce.rq(t.g)},ce.Oq=function(t){var n,e;if(t.I)for(n=0;n<t.o;n++)if(0!=(t.w[n]&lt)){for(t=new ce.as(t),e=n;e<t.o;e++)0!=(t.w[e]&lt)&&(t.A[e]=-1);ce.lj(t)}return t},ce.Pq=function(t,n,e){t.b=null,t.a=n,t.c=null==e?ce.Jq(t,n):e},ce.Qq=function(t,n,e){t.e=null,t.d=n,t.f=null==e?ce.Jq(t,n):e},ce.Rq=function(){ce.Iq(),this.g=new ce.Dq,ce.Lq()},ce.Sq=function(t){var n,e,o,r,i,a;if(ce.Iq(),null==t)return null;for(n=Ke(re.dK,U,5,8*t.length,15,1),o=0;o<t.length;o++)for(a=t[o],r=7;r>=0;r--)(e=15&a)>9&&(e+=7),n[8*o+r]=48+e<<24>>24,a>>=4;return ie.XR(le.D$(n,0,(i=n.length,le.A$(),i)))},ce.Tq=function(t){var n,e,o,r;if(ce.Iq(),0==le.V$(t).length||0!=(7&le.V$(t).length))return null;for(o=Ke(re.hK,L,5,le.V$(t).length/8|0,15,1),e=0;e<le.V$(t).length;e++)r=e/8|0,le.S$(e,le.V$(t).length),(n=le.V$(t).charCodeAt(e)-48)>16&&(n-=7),o[r]<<=4,o[r]+=n;return o},ce.Uq=function(n,e){var o,r,i,a;for(ce.Iq(),a=0,r=0,i=0,o=0;o<n.length;o++)a+=Ro(n[o]&e[o]),r+=Ro(n[o]),i+=Ro(e[o]);return a/t.Math.sqrt(r*i)},ce.Vq=function(t,n){var e,o,r;for(ce.Iq(),r=0,e=0,o=0;o<t.length;o++)r+=Ro(t[o]&n[o]),e+=Ro(t[o]|n[o]);return r/e},Te(90,1,{},ce.Rq),re.PK=vo(90),ce.Xq=function(t){t.i=1,t.j=10,t.k=400,t.f=400,t.d="black",t.b=new ue.gi,t.a=new ue.gi,t.c=new ie._R,t.e=new He.ZO(12)},ce.Yq=function(t,n,e,o){var r,i;for(i=new ie.lS('<polygon points="'),r=0;r<o;r++)ie.dS(i,ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n[r]),(Ae.BU(),Ae.xU))))),i.a+=",",ie.dS(i,ie.BQ(Ae.HS(Ae.ES(new Ae.IS(e[r]),Ae.xU)))),i.a+=" ";ie.gS(i,'" fill="'+t.d+nt+it+t.d+'" stroke-width="1" />'),ce.gr(t,i.a)},ce.Zq=function(t,n,e,o){var r,i,a;i=(a=He.XO(t.e,n),new ve.mP(0,0,a,0)).b,r='<text x="'+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(e-i/2),(Ae.BU(),Ae.xU))))+'" y="'+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(o+t.j/3),Ae.xU)))+'" font-family=" '+t.e.a+'" font-size="'+t.e.b+'" fill="'+t.d+'">'+n+"</text>",ce.gr(t,r)},ce.$q=function(t,n,e,o){var r;r='<circle cx="'+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(n+o/2),(Ae.BU(),Ae.xU))))+'" cy="'+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(e+o/2),Ae.xU)))+'" r="'+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(o/2),Ae.xU)))+'" fill="'+t.d+st,ce.gr(t,r)},ce._q=function(t,n,e,o){var r;r='<circle id="'+(null!=t.g?t.g:"mol"+ce.Wq)+":Atom:"+n+nt+Hn+'cx="'+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(e),(Ae.BU(),Ae.xU))))+'" cy="'+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(o),Ae.xU)))+'" r="8'+nt+vn,ue.Oh(t.a,r)},ce.ar=function(t,n,e,o,r,i){var a;a='<line id="'+(null!=t.g?t.g:"mol"+ce.Wq)+":Bond:"+n+nt+Hn+'x1="'+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(e),(Ae.BU(),Ae.xU))))+nt+et+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(o),Ae.xU)))+nt+ot+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(r),Ae.xU)))+nt+rt+ie.BQ(Ae.HS(Ae.ES(new Ae.IS(i),Ae.xU)))+nt+at+8+nt+vn,ue.Oh(t.b,a)},ce.br=function(t,n){t.d="rgb("+(n.c>>16&255)+","+(n.c>>8&255)+","+(255&n.c)+")"},ce.cr=function(n,e){n.i=ie.BQ(Ae.HS(Ae.ES(new Ae.IS(t.Math.max(e,1)),(Ae.BU(),Ae.xU))))},ce.dr=function(t,n){t.j!=n&&(t.j=n,t.e=new He.ZO(n))},ce.er=function(n,e){return n.k=jo(io(t.Math.round(e.b))),n.f=jo(io(t.Math.round(e.a))),ce.Ld(n,e)},ce.fr=function(t){var n,e,o,r,i;for(i='<svg id="'+(null!=t.g?t.g:"mol"+ce.Wq)+'" xmlns="http://www.w3.org/2000/svg" version="1.1" width="'+t.k+'px" height="'+t.f+'px" viewBox="0 0 '+t.k+" "+t.f+'">\n',i+="  ",i+="<style> #"+(null!=t.g?t.g:"mol"+ce.Wq)+" { pointer-events:none; } #"+(null!=t.g?t.g:"mol"+ce.Wq)+" .event  { pointer-events:all; } line { stroke-linecap:round; } polygon { stroke-linejoin:round; } </style>\n",r=new ue.KW(t.b);r.a<r.c.a.length;)o=ue.JW(r),ce.gr(t,o);for(e=new ue.KW(t.a);e.a<e.c.a.length;)n=ue.JW(e),ce.gr(t,n);return i+t.c.a+"</svg>"},ce.gr=function(t,n){ie.$R(t.c,"  "),ie.$R(t.c,n),ie.$R(t.c,d)},ce.hr=function(t,n,e){ce.Pc(),ce.Od.call(this,t,n),ce.Xq(this),this.g=e,++ce.Wq},Te(141,161,{},ce.hr),a.jb=function(){return ce.fr(this)},a.f=0,a.i=0,a.j=0,a.k=0,ce.Wq=0,re.RK=vo(141),ce.jr=function(t,n,e,o){this.a=t,this.e=n,this.d=e,this.c=o},Te(95,1,{95:1},ce.jr),a.a=0,a.b=0,a.c=!1,a.d=!1,a.e=0,re.SK=vo(95),ce.kr=function(t,n){var e,o,r,i;for(i=!1,t.b=n,ce.Jr(t.b,15),e=t.b.d,o=t.b.e,t.j=Ke(re.DN,ft,5,o,16,1),r=0;r<o;++r)t.j[r]=!1;for(t.g=Ke(re.DN,ft,5,e,16,1),t.c=Ke(re.hK,L,5,e,15,1),r=0;r<e;++r)t.g[r]=!1,t.c[r]=-1;for(t.e=Ke(re.uM,P,2,3*e,6,1),t.i=0,t.d=0,t.a=0;!i;){for(r=0;r<e;++r)if(!t.g[r]){t.a>0&&(t.e[t.i++]="."),ce.mr(t,r,-1),++t.a;break}r==e&&(i=!0)}for(t.f="",r=0;r<t.i;++r)t.f+=""+t.e[r];return t.f},ce.lr=function(t){switch(t){case 5:case 6:case 7:case 8:case 9:case 15:case 16:case 17:case 35:case 53:return!0;default:return!1}},ce.mr=function(n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m,d;if(r=!0,f=0,d=0,w=n.i,n.c[e]=w,u=ce.Ij(n.b,e),s=ce.xj(n.b,e),i=ce.rj(n.b,e),a=ce.Bj(n.b,e),c=ce.Am(n.b,e),0==i&&0==a&&ce.lr(u)&&(r=!1),n.e[w]="",-1!=o)switch(ce.Vj(n.b,o)){case 0:n.e[w]+="~";break;case 2:n.e[w]+="=";break;case 3:n.e[w]+="#"}for(r&&(n.e[w]+="["),0!=a&&(n.e[w]+=""+a),n.e[w]+=""+s,r&&0<(m=ce.Nm(n.b,e))&&(n.e[w]+="H",1<m&&(n.e[w]+=m)),0!=i&&(n.e[w]+=i>0?"+":"-",t.Math.abs(i)>1&&(n.e[w]+=""+t.Math.abs(i))),r&&(n.e[w]+="]"),-1!=o&&(n.j[o]=!0),n.g[e]=!0,++n.i,g=0;g<c;++g)n.j[ce.Bm(n.b,e,g)]||++f;for(g=0;g<c;++g)if(l=ce.zm(n.b,e,g),h=ce.Bm(n.b,e,g),n.j[h])++d;else if(n.g[l]){switch(++n.d,n.j[h]=!0,ce.Vj(n.b,h)){case 0:n.e[n.c[l]]+="~",n.e[w]+="~";break;case 2:n.e[n.c[l]]+="=",n.e[w]+="=";break;case 3:n.e[n.c[l]]+="#",n.e[w]+="3"}n.d>9&&(n.e[n.c[l]]+="%",n.e[w]+="%"),n.e[n.c[l]]+=""+n.d,n.e[w]+=""+n.d}else g-d<f-1&&(n.e[n.i++]="("),ce.mr(n,l,h),g-d<f-1&&(n.e[n.i++]=")")},ce.nr=function(){},Te(140,1,{},ce.nr),a.a=0,a.d=0,a.i=0,re.TK=vo(140),ce.or=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g;for(f=Ke(re.hK,L,5,t.d.d,15,1),s=Ke(re.hK,L,5,t.d.d,15,1),u=Ke(re.hK,L,5,t.d.d,15,1),l=Ke(re.hK,L,5,t.d.d,15,1),e=ce.Nj(t.d,0,n),o=ce.Nj(t.d,1,n),s[0]=e,s[1]=o,u[0]=-1,u[1]=n,f[e]=1,f[o]=2,l[e]=-1,l[o]=e,a=1,c=1;a<=c&&f[s[a]]<15;){for(g=s[a],h=0;h<ce.Am(t.d,g);h++)if((r=ce.zm(t.d,g,h))!=l[g]){if(i=ce.Bm(t.d,g,h),r==e){for(u[0]=i,w=0;w<=c;w++)t.c[u[h]]||(t.c[u[h]]=!0,++t.b);return}ce.wk(t.d,r)&&0==f[r]&&(s[++c]=r,u[c]=i,f[r]=f[g]+1,l[r]=g)}++a}},ce.pr=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w;for(ce.Jr(t.d,7),c=!1,h=Ke(re.hK,L,5,2,15,1),w=Ke(re.hK,L,5,2,15,1),l=Ke(re.hK,L,5,2,15,1),o=0;o<t.d.e;o++)if(!ce.An(t.d,o)&&2==ce.Yj(t.d,o)){for(a=0;a<2;a++){for(h[a]=-1,l[a]=-1,n=ce.Nj(t.d,a,o),f=0;f<ce.Am(t.d,n);f++)(r=ce.Bm(t.d,n,f))!=o&&(-1!=h[a]||17!=ce.Yj(t.d,r)&&9!=ce.Yj(t.d,r)?l[a]=ce.zm(t.d,n,f):(h[a]=ce.zm(t.d,n,f),w[a]=r));if(-1==h[a])break}if(-1!=h[0]&&-1!=h[1]){for(u=ce.Yj(t.d,w[0])==ce.Yj(t.d,w[1]),s=0;s<2;s++)h[s]==ce.Nj(t.d,0,w[s])&&(u=!u);for(i=0;i<2;i++)-1!=l[i]&&l[i]<h[i]&&(u=!u);ce.tl(t.d,o,u?2:1,!1),c=!0}}for(e=0;e<t.d.e;e++)(17==ce.Yj(t.d,e)||9==ce.Yj(t.d,e))&&ce.wl(t.d,e,1);return c},ce.qr=function(t,n){var e,o,r,i,a,s,u,f,l,c,h;for(e=0;e<t.d.d;e++)if(ce.wk(t.d,e))for(u=Ke(re.hK,L,5,t.d.d,15,1),s=Ke(re.hK,L,5,t.d.d,15,1),f=Ke(re.hK,L,5,t.d.d,15,1),s[0]=e,u[e]=1,f[e]=-1,a=0,l=0;a<=l;){for(r=1==(1&u[s[a]])?1:2,c=0;c<ce.Am(t.d,s[a]);c++)if(o=ce.Bm(t.d,s[a],c),ce.Vj(t.d,o)==r&&n[o]&&0==u[i=ce.zm(t.d,s[a],c)]){if(1==r&&ce.wk(t.d,i)){for(h=s[a];-1!=h;)ce.wl(t.d,ce.xm(t.d,i,h),1==r?2:1),r=3-r,i=h,h=f[h];return ce.cl(t.d,e,!1),ce.cl(t.d,i,!1),t.a-=2,!0}s[++l]=i,f[i]=s[a],u[i]=u[s[a]]+1}++a}return!1},ce.rr=function(t){var n,e,o,r;for(n=0;n<t.d.d;n++)if(7==ce.Ij(t.d,n)&&0==ce.rj(t.d,n)&&ce.Sm(t.d,n)>3&&ce.qm(t.d,n)>0)for(r=0;r<ce.Am(t.d,n);r++)if(e=ce.zm(t.d,n,r),o=ce.Bm(t.d,n,r),ce.Vj(t.d,o)>1&&ce.uk(t.d,e)){4==ce.Yj(t.d,o)?ce.wl(t.d,o,2):ce.wl(t.d,o,1),ce.Vk(t.d,n,ce.rj(t.d,n)+1),ce.Vk(t.d,e,ce.rj(t.d,e)-1);break}},ce.sr=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M;for(ce.Jr(t.d,1),t.c=Ke(re.DN,ft,5,t.d.e,16,1),t.b=0,a=0;a<t.d.e;a++)64==ce.Yj(t.d,a)&&(ce.wl(t.d,a,1),t.c[a]=!0,++t.b);for(M=new ce.aq(t.d,3),m=Ke(re.DN,ft,5,M.i.a.length,16,1),j=0;j<M.i.a.length;j++){for(H=ue.Th(M.i,j),m[j]=!0,c=0;c<H.length;c++)if(!ce.wk(t.d,H[c])){m[j]=!1;break}if(m[j])for(v=ue.Th(M.j,j),h=0;h<v.length;h++)t.c[v[h]]||(t.c[v[h]]=!0,++t.b)}for(s=0;s<t.d.e;s++)!t.c[s]&&0!=M.b[s]&&ce.wk(t.d,ce.Nj(t.d,0,s))&&ce.wk(t.d,ce.Nj(t.d,1,s))&&ce.or(t,s);for(ce.Jr(t.d,7),g=Ke(re.DN,ft,5,t.d.e,16,1),w=0;w<t.d.e;w++)g[w]=t.c[w];for(N=0;N<M.i.a.length;N++)if(m[N])for(H=ue.Th(M.i,N),l=0;l<H.length;l++)if(!ce.yr(t,H[l]))for(ce.wk(t.d,H[l])&&(ce.cl(t.d,H[l],!1),--t.a),p=0;p<ce.Am(t.d,H[l]);p++)f=ce.Bm(t.d,H[l],p),t.c[f]&&(t.c[f]=!1,--t.b);for(ce.xr(t),y=0;y<M.i.a.length;y++)if(m[y]&&6==ue.Th(M.j,y).length){for(d=!0,r=0,i=(o=v=ue.Th(M.j,y)).length;r<i;++r)if(e=o[r],!t.c[e]){d=!1;break}d&&(ce.wr(t,v[0]),ce.wr(t,v[2]),ce.wr(t,v[4]),ce.xr(t))}for(b=5;b>=4;b--)do{for(G=!1,e=0;e<t.d.e;e++)if(t.c[e]){for(n=0,l=0;l<2;l++)for(u=ce.Nj(t.d,l,e),p=0;p<ce.Am(t.d,u);p++)t.c[ce.Bm(t.d,u,p)]&&++n;if(n==b){ce.wr(t,e),ce.xr(t),G=!0;break}}}while(G);for(;t.a>=2&&ce.qr(t,g););if(0!=t.a)throw We(new ie.EG(Mn));if(0!=t.b)throw We(new ie.EG(Mn))},ce.tr=function(t,n,e,o,r,i,a){var s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,x,k,R,I,D,F,T,B,$,P,K,E,O,Y,q,J,Q,X,_,z;for(t.d=n,ce._i(t.d),B=null,(c=Ke(re.hK,L,5,64,15,1))[0]=-1,P=Ke(re.hK,L,5,64,15,1),E=Ke(re.hK,L,5,64,15,1),K=Ke(re.hK,L,5,64,15,1),H=0;H<64;H++)P[H]=-1;for(f=0,b=-1,Y=!1,$=!1,O=!1,w=0,h=1;e[o]<=32;)++o;for(;o<r;)if(Eo(q=e[o++]&V)||42==q){if(l=0,G=-1,A=!1,T=!1,M=!1,Y)82==q&&Vo(e[o]&V)?(k=Vo(e[o+1]&V)?2:1,l=ce.Yl(ie.XR(le.D$(e,o-1,(C=1+k,le.A$(),C)))),o+=k):(S=Yo(e[o]&V)==(e[o]&V)&&Eo(e[o]&V)?2:1,l=ce.Yl(ie.XR(le.D$(e,o-1,(C=S,le.A$(),C)))),o+=S-1,G=0),64==e[o]&&(64==e[++o]&&(M=!0,++o),T=!0),72==e[o]&&(G=1,Vo(e[++o]&V)&&(G=e[o]-48,++o));else if(42==q)l=6,A=!0;else switch(String.fromCharCode(q).toUpperCase().charCodeAt(0)){case 66:o<r&&114==e[o]?(l=35,++o):l=5;break;case 67:o<r&&108==e[o]?(l=17,++o):l=6;break;case 70:l=9;break;case 73:l=53;break;case 78:l=7;break;case 79:l=8;break;case 80:l=15;break;case 83:l=16}if(0==l)throw We(new ie.EG("SmilesParser: unknown element label found"));u=ce.Ni(t.d,l),A&&(O=!0,ce.fl(t.d,u,1,!0)),Yo(q)==q&&Eo(q)?(ce.cl(t.d,u,!0),++t.a):ce.cl(t.d,u,!1),-1!=G&&1!=l&&((g=Ke(re.dK,U,5,1,15,1))[0]=G<<24>>24,ce.Zk(t.d,u,g)),b=c[w],-1!=c[w]&&128!=h&&ce.Pi(t.d,c[w],u,h),h=1,c[w]=u,0!=f&&(ce.dl(t.d,u,f),f=0),a&&((D=B?ue.hW(B,ie.nR(b)):null)&&ce.Ar(D,u,o,1==l&&0==f),T&&(!B&&(B=new ue.yY),ue.qY(B,ie.nR(u),new ce.Dr(t,u,b,G,o,M))))}else if(46!=q)if(61!=q)if(35!=q)if(Vo(q))if(R=q-48,Y){for(;o<r&&Vo(e[o]&V);)R=10*R+e[o]-48,++o;f=R}else{if(j=45==e[o-2]||47==e[o-2]||92==e[o-2]||61==e[o-2]||35==e[o-2]||58==e[o-2],$&&o<r&&Vo(e[o]&V)&&(R=10*R+e[o]-48,++o),$=!1,R>=64)throw We(new ie.EG("SmilesParser: ringClosureAtom number out of range"));if(-1==P[R])P[R]=c[w],E[R]=o-1,K[R]=j?h:-1;else{if(P[R]==c[w])throw We(new ie.EG("SmilesParser: ring closure to same atom"));a&&B&&((D=ue.hW(B,ie.nR(P[R])))&&ce.Ar(D,c[w],E[R],!1),(D=ue.hW(B,ie.nR(c[w])))&&ce.Ar(D,P[R],o-1,!1)),-1!=K[R]?h=K[R]:17==h?h=9:9==h&&(h=17),ce.Pi(t.d,P[R],c[w],h),P[R]=-1}h=1}else if(43!=q)if(45!=q)if(40!=q)if(41!=q)if(91!=q)if(93!=q)if(37!=q)if(58!=q)if(47!=q)if(92!=q){if(!(q<=32))throw We(new ie.EG("SmilesParser: unexpected character found: '"+String.fromCharCode(q)+"'"));o=r}else a&&(h=9);else a&&(h=17);else{if(!Y){h=64;continue}for(x=0;Vo(e[o]&V);)x=10*x+e[o]-48,++o;ce.bl(t.d,c[w],x,!1)}else $=!0;else{if(!Y)throw We(new ie.EG("SmilesParser: closing bracket without opening one"));Y=!1}else{if(Y)throw We(new ie.EG("SmilesParser: nested square brackets found"));Y=!0}else--w;else{if(-1==c[w])throw We(new ie.EG("Smiles with leading parenthesis are not supported"));c[w+1]=c[w],++w}else{if(!Y)continue;for(m=-1;45==e[o];)--m,++o;-1==m&&Vo(e[o]&V)&&(m=48-e[o],++o),ce.Vk(t.d,c[w],m)}else{if(!Y)throw We(new ie.EG("SmilesParser: '+' found outside brackets"));for(m=1;43==e[o];)++m,++o;1==m&&Vo(e[o]&V)&&(m=e[o]-48,++o),ce.Vk(t.d,c[w],m)}else h=4;else h=2;else c[w]=-1,h=128;if(1!=h)throw We(new ie.EG("SmilesParser: dangling open bond"));for(v=0;v<64;v++)if(-1!=P[v])throw We(new ie.EG("SmilesParser: dangling ring closure"));for(y=ce.Lm(t.d),ce.Al(t.d,!0),ce.Jr(t.d,1),s=0;s<t.d.o;s++)if(null!=(null==n.r||null==n.r[s]?null:ie.FR(n.r[s]))&&!ce.wk(t.d,s))if(p=ce.uj(t.d,s)[0],ce.Ij(t.d,s)<(ce.Li(),ce.Hi).length&&null!=ce.Hi[ce.Ij(t.d,s)]){for(d=!1,J=ce.Sm(t.d,s),J-=ce.ak(t.d,s,J),_=0,z=(X=ce.Hi[ce.Ij(t.d,s)]).length;_<z;++_)if(J<=(Q=X[_])){d=!0,Q!=J+p&&ce.Tk(t.d,s,J+p);break}d||ce.Tk(t.d,s,J+p)}else for(N=0;N<p;N++)ce.Pi(n,s,ce.Ni(n,1),1);if(ce.Jr(t.d,1),ce.rr(t),ce.sr(t),t.d.r=null,ce.Al(t.d,!1),a&&(ce.pr(t),B)){for(I=new ue.IY(new ue.NY(new ue.MV(B).a).b),F=new ue.TV(I);ue.OU(F.a.a);)D=ue.GY(F.a).Tb(),ce.el(t.d,D.a,ce.Br(D,y),!1);ce.Kn(t.d,0)}ce.Kn(t.d,0),i&&(we.$s(new we.pt,t.d),a&&ce.Wr(t.d)),O&&ce.yl(t.d,!0)},ce.ur=function(t,n,e,o){ce.tr(t,n,e,0,e.length,!1,o)},ce.vr=function(t,n){var e,o,r,i,a,s;if(-1==(r=-1==(o=pe.YF(n,0))?-1:pe.YF(n,o+1)))throw We(new ie.EG("Missing one or both separators ('>')."));if(-1!=pe.YF(n,r+1))throw We(new ie.EG("Found more than 2 separators ('>')."));return a=new ce.$r,ce.tr(t,a,n,0,o,!0,!0),i=new ce.$r,ce.tr(t,i,n,r+1,n.length,!0,!0),e=null,r-o>1&&(e=new ce.$r,ce.tr(t,e,n,o+1,r,!0,!0)),s=new me.Zu,ue.Oh(s.g,a),s.d=-1,ue.Oh(s.f,i),s.d=-1,e&&ue.Oh(s.a,e),s},ce.wr=function(t,n){var e,o,r,i;for(1==ce.Yj(t.d,n)&&ce.wl(t.d,n,2),r=0;r<2;r++)for(e=ce.Nj(t.d,r,n),ce.wk(t.d,e)&&(ce.cl(t.d,e,!1),--t.a),i=0;i<ce.Am(t.d,e);i++)o=ce.Bm(t.d,e,i),t.c[o]&&(t.c[o]=!1,--t.b)},ce.xr=function(t){var n,e,o,r,i,a,s;do{for(s=!1,e=0;e<t.d.e;e++)if(t.c[e]){for(i=!1,r=0;r<2;r++){for(n=!1,o=ce.Nj(t.d,r,e),a=0;a<ce.Am(t.d,o);a++)if(e!=ce.Bm(t.d,o,a)&&t.c[ce.Bm(t.d,o,a)]){n=!0;break}if(!n){i=!0;break}}i&&(s=!0,ce.wr(t,e))}}while(s)},ce.yr=function(t,n){var e,o;if(6==ce.Ij(t.d,n)&&0!=ce.rj(t.d,n)||!ce.wk(t.d,n))return!1;if(e=null==ce.tj(t.d,n)?0:ce.uj(t.d,n)[0],(o=ce.Jm(t.d,n)-e)<1)return!1;if(16==ce.Ij(t.d,n)||34==ce.Ij(t.d,n)||52==ce.Ij(t.d,n)){if(2==ce.Am(t.d,n)&&ce.rj(t.d,n)<=0)return!1;if(2==o)return!1}return 5==ce.Ij(t.d,n)||6==ce.Ij(t.d,n)||7==ce.Ij(t.d,n)||8==ce.Ij(t.d,n)||15==ce.Ij(t.d,n)||16==ce.Ij(t.d,n)||33==ce.Ij(t.d,n)||34==ce.Ij(t.d,n)},ce.zr=function(){},Te(105,1,{},ce.zr),a.a=0,a.b=0,re.VK=vo(105),ce.Ar=function(t,n,e,o){t.b||(4==t.g||3==t.g&&-1!=t.c?t.b=!0:(t.i[t.g]=o,t.f[t.g]=n,t.j[t.g]=e,++t.g))},ce.Br=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g;if(t.b)return 3;for(-1!=t.c&&(t.c=n[t.c]),a=0;a<t.g;a++)t.f[a]!=N&&(t.f[a]=n[t.f[a]]);if(-1==t.c&&0==t.d){for(w=N,h=-1,s=0;s<t.g;s++)w>t.j[s]&&(w=t.j[s],h=s);for(t.c=t.f[h],u=h+1;u<t.g;u++)t.f[u-1]=t.f[u],t.j[u-1]=t.j[u],t.i[u-1]=t.i[u];--t.g}if((g=(-1==t.c?0:1)+t.d+t.g)>4||g<3)return 3;for(e=-1==t.c&&1==t.d||-1!=t.c&&ce.yn(t.k.d,t.c),r=-1,f=0;f<t.g;f++)if(t.i[f]){if(-1!=r||e)return 3;r=f}if(c=!1,-1!=r)for(l=0;l<t.g;l++)!t.i[l]&&t.f[r]<t.f[l]&&(c=!c);if(o=!1,-1!=t.c&&!e)for(i=0;i<t.g;i++)t.c<t.f[i]&&(o=!o);return t.e^ce.Cr(t.f,t.j,t.g)^o^c?2:1},ce.Cr=function(t,n,e){var o,r,i;for(r=!1,o=1;o<e;o++)for(i=0;i<o;i++)t[i]>t[o]&&(r=!r),n[i]>n[o]&&(r=!r);return r},ce.Dr=function(t,n,e,o,r,i){this.k=t,0!=o&&1!=o?this.b=!0:(this.a=n,this.c=e,this.d=o,this.e=i,this.g=0,this.i=Ke(re.DN,ft,5,4,16,1),this.f=Ke(re.hK,L,5,4,15,1),this.j=Ke(re.hK,L,5,4,15,1),-1!=e&&1==o&&(ce.Ar(this,N,r,!0),this.d=0))},Te(117,1,{117:1},ce.Dr),a.a=0,a.b=!1,a.c=0,a.d=0,a.e=!1,a.g=0,re.UK=vo(117),ce.Er=function(t){t.c=new ue.gi},ce.Fr=function(t,n){var e,o,r,i;if(0==(i=t.c.a.length))return ue.Nh(t.c,0,n),0;for(r=1;2*r<=i;)r<<=1;for(o=r,--r;0!=o;)if(o>>=1,r>=i)r-=o;else{if(0==(e=ie.CR(n,ue.Th(t.c,r))))return-1;if(0==o)break;e<0?r-=o:r+=o}return r<i&&ie.CR(n,ue.Th(t.c,r))>0&&++r,ue.Nh(t.c,r,n),r},ce.Gr=function(t,n){var e,o,r,i;if(0==(i=t.c.a.length))return-1;for(r=1;2*r<=i;)r<<=1;for(o=r,--r;0!=o;)if(o>>=1,r>=i)r-=o;else{if(0==(e=ie.CR(n,ue.Th(t.c,r))))return r;if(0==o)break;e<0?r-=o:r+=o}return-1},ce.Hr=function(){ce.Er(this)},Te(123,1,Vt,ce.Hr),re.WK=vo(123),ce.Ir=function(t,n){ce.fj(t,n),t.b&&(n.R=0)},ce.Jr=function(t,n){var e,o,r,i;if(ce.fm(t,n),0!=(n&~t.R)){for(t.a&&(n|=256),e=0;e<t.o;e++)t.s[e]&=-134447112;for(o=0;o<t.e;o++)t.C[o]&=-64;r=0,i=0,0!=(32&n)?(r=32,i=1):0!=(64&n)?(r=64,i=3):0!=(128&n)&&(r=128,i=5),0!=(256&n)&&(r|=256,i|=32),t.b=new ce.Lf(t,i),ce.Gf(t.b),ce.Hf(t.b),ce.Ff(t.b),ce.Zr(t)&&(t.b=new ce.Lf(t,i)),t.R|=24|r}},ce.Kr=function(t,n){return ce.tf(t.b,n)},ce.Lr=function(t,n){return ce.kf(t.b,n)},ce.Mr=function(t){var n;switch(ce.Jr(t,31),n=t.G&V,t.G&Ut){case K:return null;case Ot:return 1==n?"meso":n+" meso diastereomers";case 0:return"unknown chirality";case 196608:return"racemate";case Bt:return"this enantiomer";case 327680:return"this or other enantiomer";case Mt:return"two epimers";default:return 1==n?"one stereo isomer":n+" stereo isomers"}},ce.Nr=function(t){var n;return n=new ce._r(t.o,t.p),ce.ej(t,n),n},ce.Or=function(n){var e,o,r,i,a,s,u;for(ce.Jr(n,15),s=Ke(re.hK,L,5,3,15,1),o=0;o<n.d;o++)0!=(n.s[o]&Zt)&&0!=(u=(n.s[o]&Rt)>>19)&&(s[u]=t.Math.max(s[u],(n.s[o]&Rt)>>19!=1&&(n.s[o]&Rt)>>19!=2?-1:(n.s[o]&Jt)>>21));for(i=0;i<n.e;i++)1!=(3&n.C[i])&&2!=(3&n.C[i])||1!=n.F[i]||0!=(u=(n.C[i]&Qt)>>10)&&(s[u]=t.Math.max(s[u],(n.C[i]&Qt)>>10!=1&&(n.C[i]&Qt)>>10!=2?-1:(n.C[i]&Xt)>>12));for((a=Ke(re.hK,Pt,6,3,0,2))[1]=Ke(re.hK,L,5,1+s[1],15,1),a[2]=Ke(re.hK,L,5,1+s[2],15,1),e=0;e<n.d;e++)0!=(n.s[e]&Zt)&&0!=(u=(n.s[e]&Rt)>>19)&&++a[u][(n.s[e]&Rt)>>19!=1&&(n.s[e]&Rt)>>19!=2?-1:(n.s[e]&Jt)>>21];for(r=0;r<n.e;r++)1!=(3&n.C[r])&&2!=(3&n.C[r])||1!=n.F[r]||0!=(u=(n.C[r]&Qt)>>10)&&++a[u][(n.C[r]&Qt)>>10!=1&&(n.C[r]&Qt)>>10!=2?-1:(n.C[r]&Xt)>>12];return a},ce.Pr=function(t){var n,e;return n=Ke(re.hK,L,5,t.o,15,1),e=ce.Im(t,n,!1,!1),ce.Qr(t,n,e)},ce.Qr=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g,m,d;for(m=Ke(re.XK,p,23,e,0,1),a=Ke(re.hK,L,5,e,15,1),f=Ke(re.hK,L,5,e,15,1),i=Ke(re.hK,L,5,t.o,15,1),r=0;r<t.o;r++)-1!=n[r]&&(i[r]=a[n[r]]++);for(u=0;u<t.p;u++)(g=n[t.B[0][u]])==n[t.B[1][u]]&&-1!=g&&++f[g];for(d=0;d<e;d++)m[d]=new ce._r(a[d],f[d]),ce.Ir(t,m[d]);for(o=0;o<t.o;o++)-1!=n[o]&&ce.bj(t,m[n[o]],o,0,0);for(s=0;s<t.p;s++)(g=n[t.B[0][s]])==n[t.B[1][s]]&&-1!=g&&ce.dj(t,m[g],s,0,0,i,!1);for(h=0,w=(c=m).length;h<w;++h)l=c[h],ce.Pk(l,1),ce.Pk(l,2);return m},ce.Rr=function(t){return ce.Jr(t,15),t.b?ce.of(t.b):null},ce.Sr=function(t){return ce.Jr(t,15),t.b?ce.lf(t.b):null},ce.Tr=function(t){var n,e;for(ce.Jr(t,31),e=0,n=0;n<t.d;n++)0!=(3&t.s[n])&&0==(4&t.s[n])&&++e;return e},ce.Ur=function(t,n){return ce.sf(t.b,n)},ce.Vr=function(t,n){t.a=n,t.R&=-272},ce.Wr=function(t){ce.Jr(t,31),t.b&&ce.If(t.b)},ce.Xr=function(t){var n,e;for(ce.Jr(t,15),t.J=!1,n=0;n<t.o;n++)t.s[n]&=tn,0!=(3&t.s[n])?t.s[n]|=zt:t.s[n]&=-67108865;for(e=0;e<t.p;e++)0!=(3&t.C[e])&&2==ce.Vj(t,e)?t.F[e]=26:t.F[e]&=-25;t.R&=-505},ce.Yr=function(n){var e,o,r,i,a,s;for(ce.Qn(n),ce.Jr(n,31),r=0;r<n.d;r++){if(!((n.s[r]&Rt)>>19!=1&&(n.s[r]&Rt)>>19!=2||0!=(n.s[r]&Zt)&&3!=(3&n.s[r])))throw We(new ie.EG(An));if(0!=(n.s[r]&Ot))throw We(new ie.EG("Over- or under-specified stereofeature or more than one racemic type bond"));if((1==(3&n.s[r])||2==(3&n.s[r]))&&0==n.k[r]){for(e=Ke(re.fK,ut,5,n.g[r],15,1),a=0;a<n.g[r];a++)e[a]=ce.Mj(n,r,n.f[r][a]);for(i=1;i<n.g[r];i++)if(!ce.Ek(n,n.i[r][i],r))for(s=0;s<i;s++)if(!ce.Ek(n,n.i[r][s],r)&&((o=t.Math.abs(ce.Xl(e[i],e[s])))<.08||o>rn))throw We(new ie.EG(Sn))}}},ce.Zr=function(t){var n,e,o,r,i,a,s;for(s=!1,e=0;e<t.d;e++)(0==(t.s[e]&Zt)||3==(3&t.s[e]))&&(t.s[e]&=tn);for(i=0;i<t.e;i++)(1!=ce.Vj(t,i)||0==(3&t.C[i])||3==(3&t.C[i]))&&(t.C[i]&=-130049);if(t.J){if((t.G&Ut)!=Ot){for(a=Ke(re.DN,ft,5,t.d,16,1),o=0;o<t.d;o++)0!=(t.s[o]&Zt)&&3!=(3&t.s[o])&&(t.s[o]&Rt)>>19==1&&(a[o]=!0);for(r=0;r<t.d;r++)0!=(t.s[r]&Zt)&&3!=(3&t.s[r])&&(ce.$k(t,r,1,0),s=!0);for(n=0;n<t.d;n++)a[n]&&(ce.el(t,n,1,!1),ce.$k(t,n,1,-1),s=!0)}t.J=!1}return ce.Pk(t,1),ce.Pk(t,2),s},ce.$r=function(){ce.Li(),ce.Tn.call(this)},ce._r=function(t,n){ce.Li(),ce.Un.call(this,t,n)},ce.as=function(t){ce.Li(),ce.Vn.call(this,t)},Te(23,71,{71:1,62:1,23:1,4:1},ce.$r,ce._r,ce.as),a.pb=function(t){ce.Ir(this,t)},a.qb=function(t){ce.Jr(this,t)},a.a=!1,re.XK=vo(23),ce.ds=function(t){t.b=new ue.gi,t.a=new ue.gi},ce.es=function(t,n){var e,o;return-1==(e=ce.Fr(t,n))?-1:(o=t.b.a.length,ue.Oh(t.b,n),ue.Nh(t.a,e,new ie.dR(o)),o)},ce.fs=function(){ce.Hr.call(this),ce.ds(this)},Te(148,123,Vt,ce.fs),re.YK=vo(148),he.hs=function(){he.hs=De,he.gs=ce.Yl("X")},he.is=function(t,n){var e,o,r,i,a;for(he.hs(),r=0;r<t.o;r++)for(a=ce.Nr(t),ce.ml(a,r,he.gs),ce.Jr(a,15),o=0;o<a.d;o++)0!=(a.s[o]&Zt)&&-1==ce._m(a,o)&&(ce.Jr(a,7),-1!=(i=2==a.k[o]&&2==a.g[o]?ce.En(a,o):ce.Gn(a,o))&&(t.F[i]=17,t.R=0,t.B[1][i]==o&&(e=t.B[0][i],t.B[0][i]=o,t.R=0,t.B[1][i]=e,t.R=0),ce.$k(t,o,n,0)))},he.js=function(t){var n,e,o,r;for(he.hs(),he.is(t,1),o=t.o,e=Ke(re.uM,P,2,o,6,1),n=0;n<o;n++)r=ce.Nr(t),ce.Yk(r,n,(ce.Li(),ce.Gi)[r.A[n]]+"*"),1==r.A[n]?ce.ml(r,n,he.gs):ce.dl(r,n,r.v[n]+5),he.ks(r),e[n]=ce.of(new ce.Lf(r,8));return e},he.ks=function(t){var n;for(ce.Jr(t,15),n=0;n<t.o;n++)0!=(3&t.s[n])&&ce.$k(t,n,1,0)},he.gs=0,he.ls=function(t,n,e){var o,r;for(o=Pe(re.uM,[p,P],[29,2],6,[t.d,n],2),ce.Jr(t,7),r=0;r<t.d;r++)o[r]=he.ms(t,r,n,e);return o},he.ms=function(t,n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m;for(u=new ce._r(t.d,t.e),l=new ue.wZ,w=0,h=0,a=Ke(re.DN,ft,5,t.d,16,1),i=Ke(re.hK,L,5,t.d,15,1),m=0;m<e&&h<t.d;m++){if(0==h)i[0]=n,a[n]=!0,h=1;else{for(g=h,f=w;f<h;f++)for(r=i[f],c=0;c<t.g[r];c++)if(!a[s=t.f[r][c]])switch(o){case 0:a[s]=!0,i[g++]=s;break;case 1:he.os(t,r)&&he.os(t,s)||(a[s]=!0,i[g++]=s)}w=h,h=g}ce.dm(t,u,a,!0,null),ue.tZ(l,ce.of(new ce.Lf(u,8)))}return ue.vZ(l,Ke(re.uM,P,2,l.a.a.length,6,1))},he.ns=function(t,n,e){var o,r,i,a,s;for(a=ce._n(new ce.io(!0),t),r=-1,i=0;i<a.o;i++)if(null!=(o=null==a.r||null==a.r[i]?null:ie.FR(a.r[i]))&&(s=le.V$("*").length,ie.GR(le.V$(o).substr(le.V$(o).length-s,s),"*"))){r=i;break}return r>=0?he.ms(a,r,n,e):Ke(re.uM,P,2,0,6,1)},he.os=function(t,n){return 6==t.A[n]&&(0==t.q[n]&&ce.Nm(t,n)+t.g[n]==4)},he.zs=function(){he.zs=De,he.ps=t.Math.cos(Tt),he.us=t.Math.sin(Tt),he.rs=t.Math.cos(Cn),he.ws=t.Math.sin(Cn),he.ts=t.Math.cos(Ft),he.ys=t.Math.sin(Ft),he.qs=t.Math.cos(xn),he.vs=t.Math.sin(xn),he.ss=t.Math.cos(on),he.xs=t.Math.sin(on),t.Math.cos(kn),t.Math.sin(kn)},he.As=function(t){var n,e;for(he.zs(),ce.Jr(t,1),e=t.d,n=0;n<e;n++)he.Bs(t,n)},he.Bs=function(n,e){var o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,x,k,R,I,D,F,T,B,$,P;switch(he.zs(),k=ce.Nm(n,e),$=n.H[e].a,P=n.H[e].b,k){case 1:if(0==(I=n.g[e])){for(g=_t,M=-1,a=0;a<n.o;a++)a!=e&&(h=$-n.H[a].a,w=P-n.H[a].b,g>(l=t.Math.sqrt(h*h+w*w))&&(g=l,M=a));d=$-n.H[M].a,b=P-n.H[M].b}else d=$-ce.Fj(n,n.f[e][0]),b=P-ce.Gj(n,n.f[e][0]);if(1==I)A=ce.Mi(n,$+he.ss*d+he.xs*b,P-he.xs*d+he.ss*b,0);else if(2==I)d=$-.5*(ce.Fj(n,n.f[e][0])+ce.Fj(n,n.f[e][1])),b=P-.5*(ce.Gj(n,n.f[e][0])+ce.Gj(n,n.f[e][1])),A=ce.Mi(n,$+d,P+b,0);else if(3==I){for(F=n.f[e][0],H=1;H<3;H++)f=n.i[e][H],(9==n.F[f]||17==n.F[f])&&(F=n.f[e][H]);if(o=t.Math.abs(ce.Xl(ce.Wl(n.H[e].a,n.H[e].b,ce.Fj(n,n.f[e][0]),ce.Gj(n,n.f[e][0])),ce.Wl(n.H[e].a,n.H[e].b,ce.Fj(n,n.f[e][1]),ce.Gj(n,n.f[e][1])))),r=t.Math.abs(ce.Xl(ce.Wl(n.H[e].a,n.H[e].b,ce.Fj(n,n.f[e][0]),ce.Gj(n,n.f[e][0])),ce.Wl(n.H[e].a,n.H[e].b,ce.Fj(n,n.f[e][2]),ce.Gj(n,n.f[e][2])))),i=t.Math.abs(ce.Xl(ce.Wl(n.H[e].a,n.H[e].b,ce.Fj(n,n.f[e][1]),ce.Gj(n,n.f[e][1])),ce.Wl(n.H[e].a,n.H[e].b,ce.Fj(n,n.f[e][2]),ce.Gj(n,n.f[e][2])))),D=!0,o>r&&o>i?r+i<gt&&(D=!1,d=$-.5*(ce.Fj(n,n.f[e][0])+ce.Fj(n,n.f[e][1])),b=P-.5*(ce.Gj(n,n.f[e][0])+ce.Gj(n,n.f[e][1]))):r>o&&r>i?o+i<gt&&(D=!1,d=$-.5*(ce.Fj(n,n.f[e][0])+ce.Fj(n,n.f[e][2])),b=P-.5*(ce.Gj(n,n.f[e][0])+ce.Gj(n,n.f[e][2]))):o+r<gt&&(D=!1,d=$-.5*(ce.Fj(n,n.f[e][1])+ce.Fj(n,n.f[e][2])),b=P-.5*(ce.Gj(n,n.f[e][1])+ce.Gj(n,n.f[e][2]))),D){for(T=n.f[e][0],m=_t,N=0;N<3;N++)(s=n.f[e][N])!=F&&(c=t.Math.pow(n.H[e].a-n.H[s].a,2)+t.Math.pow(n.H[e].b-n.H[s].b,2))<m&&(T=s,m=c,ie.oS());A=ce.Mi(n,(n.H[F].a+n.H[T].a)/2,(n.H[F].b+n.H[T].b)/2,0)}else A=ce.Mi(n,$+d,P+b,0)}else A=ce.Mi(n,$+d,P+b,0);ce.ml(n,A,1),ce.Pi(n,e,A,1);break;case 2:if(1==(R=n.g[e]))d=$-ce.Fj(n,n.f[e][0]),b=P-ce.Gj(n,n.f[e][0]),A=ce.Mi(n,$+.7*(he.ts*d-he.ys*b),P+.7*(he.ys*d+he.ts*b),0),ce.ml(n,A,1),ce.Pi(n,e,A,1),A=ce.Mi(n,$+.7*(he.qs*d-he.vs*b),P+.7*(he.vs*d+he.qs*b),0),ce.ml(n,A,1),ce.Pi(n,e,A,1);else if(2==R)p=$-ce.Fj(n,n.f[e][0]),y=P-ce.Gj(n,n.f[e][0]),G=$-ce.Fj(n,n.f[e][1]),j=P-ce.Gj(n,n.f[e][1]),C=.7*t.Math.sqrt(p*p+y*y),x=.7*t.Math.sqrt(G*G+j*j),b=y+j,d=(d=p+G)/(S=t.Math.sqrt(d*d+b*b))*(u=(C+x)/2),b=b/S*u,B=ce._m(n,e),A=ce.Mi(n,$+he.ps*d-he.us*b,P+he.us*d+he.ps*b,0),ce.ml(n,A,1),B>-1?ce.Pi(n,e,A,1):ce.Pi(n,e,A,17),A=ce.Mi(n,$+he.rs*d-he.ws*b,P+he.ws*d+he.rs*b,0),ce.ml(n,A,1),ce.Pi(n,e,A,1);else for(v=0;v<k;v++)A=ce.Mi(n,$,P,0),ce.ml(n,A,1),ce.Pi(n,e,A,1);break;case 3:d=.7*($-ce.Fj(n,n.f[e][0])),b=.7*(P-ce.Gj(n,n.f[e][0])),A=ce.Mi(n,$+d,P+b,0),ce.ml(n,A,1),ce.Pi(n,e,A,1),A=ce.Mi(n,$-b,P+d,0),ce.ml(n,A,1),ce.Pi(n,e,A,1),A=ce.Mi(n,$+b,P-d,0),ce.ml(n,A,1),ce.Pi(n,e,A,1);break;default:for(v=0;v<k;v++)A=ce.Mi(n,$,P,0),ce.ml(n,A,1),ce.Pi(n,e,A,1)}},he.Cs=function(t){var n,e;for(he.zs(),ce.Jr(t,1),e=0,n=0;n<t.o;n++)1==t.A[n]?++e:e+=t.c[n]-t.g[n]+ce.Nm(t,n);return e},he.ps=0,he.qs=0,he.rs=0,he.ss=0,he.ts=0,he.us=0,he.vs=0,he.ws=0,he.xs=0,he.ys=0,we.Es=function(t,n,e){var o,r,i;for(i=n.length,(o=new we.cu(t.e,i,t.d)).a[0]=0,o.b[0]=0,r=0;r<i;r++)o.k[r]=128-i,o.e[r]=n[r];i<8?we.Ns(o):we.Ls(t,o,n,e),ue.Oh(t.c,o)},we.Fs=function(n,e,o){var r,i,a,s,u,f,l,c;for(i=Ke(re.hK,L,5,16,15,1),r=0;r<n.e.o;r++){for(s=0;s<ce.mm(n.e,r);s++){for(c=o[ce.zm(n.e,r,s)],u=0;u<s&&!(c<i[u]);u++);for(f=s;f>u;f--)i[f]=i[f-1];i[u]=c}for(l=t.Math.min(6,ce.mm(n.e,r)),ce._f(e[r],r),ce.Yf(e[r],16,re.SN(o[r])),ce.Yf(e[r],17*(6-l),0),a=0;a<l;a++)ce.Yf(e[r],17,re.SN(i[a]))}},we.Gs=function(t){var n,e,o,r,i,a,s;for(e=Ke(re.rK,Kt,74,t.e.o,0,1),n=0;n<t.e.o;n++)e[n]=new ce.ag(2),ce._f(e[n],n);for(s=Ke(re.hK,L,5,t.e.o,15,1),o=0;o<t.e.e;o++)1!=(r=ce.Wj(t.e,o))&&2!=r||(ce.Zf(e[ce.Nj(t.e,0,o)],re.SN(r)),ce.Zf(e[ce.Nj(t.e,1,o)],re.SN(r)));i=we.Hs(e,s);do{a=i,we.Fs(t,e,s),i=we.Hs(e,s)}while(a!=i);return s},we.Hs=function(t,n){var e,o;for(o=0,ue._W(t,0,t.length,null),e=0;e<t.length;e++)(0==e||0!=ce.$f(t[e],t[e-1]))&&++o,n[t[e].a]=o;return o},we.Is=function(t){var n,e,o,r,i,a,s,u,f,l,c,h;for(u=0;u<t.c.a.length;u++)for(s=ue.Th(t.c,u),f=0;f<s.f.length;f++)if(o=s.f[f],2==ce.Vj(t.e,o)&&(!ce.An(t.e,o)&&(3==ce.Wj(t.e,o)||0==ce.Wj(t.e,o))&&ce.ul(t.e,o),!ce.xn(t.e,o)&&ce.Am(t.e,ce.Nj(t.e,0,o))>1&&ce.Am(t.e,ce.Nj(t.e,1,o))>1&&(1==ce.Wj(t.e,o)||2==ce.Wj(t.e,o)))){for(h=Ke(re.hK,L,5,2,15,1),r=Ke(re.hK,L,5,2,15,1),l=0;l<2;l++)for(h[l]=t.e.K,r[l]=ce.Nj(t.e,l,o),c=0;c<ce.mm(t.e,r[l]);c++)(i=ce.zm(t.e,r[l],c))!=ce.Nj(t.e,1-l,o)&&h[l]>i&&(h[l]=i);a=we.Kt(s.a[s.g[r[0]]],s.b[s.g[r[0]]],s.a[s.g[r[1]]],s.b[s.g[r[1]]]),n=we.Kt(s.a[s.g[h[0]]],s.b[s.g[h[0]]],s.a[s.g[r[0]]],s.b[s.g[r[0]]]),e=we.Kt(s.a[s.g[r[1]]],s.b[s.g[r[1]]],s.a[s.g[h[1]]],s.b[s.g[h[1]]]),we.Ps(a,n)<0^we.Ps(a,e)<0^2==ce.Wj(t.e,o)&&we.Tt(s,o)}},we.Js=function(n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G;for(w=new ue.gi,G=new ue.gi,r=new ue.gi,a=new ue.KW(n.c);a.a<a.c.a.length;){for(i=ue.JW(a),s=0,r.a=Ke(re.nM,x,1,0,5,1),u=0;u<i.e.length;u++)e=i.e[u],0!=(o=n.g[e])&&(ue.Oh(r,new we.Mt(i,u,o)),s+=o);if(0!=s)for(ue.di(r,new we.tt),l=new ue.KW(r);l.a<l.c.a.length&&!(s*(f=ue.JW(l)).b>0&&(s-=o=t.Math.abs(s)>=t.Math.abs(f.b)?f.b:s,ue.Oh(o<0?w:G,new we.Mt(i,f.a,o)),0==s)););}if(0==w.a.length||0==G.a.length)return null;for(ue.di(G,new we.xt),ue.di(w,new we.Bt),d=new ue.KW(G);d.a<d.c.a.length;)for(g=ue.JW(d),h=new ue.KW(w);h.a<h.c.a.length;)if(c=ue.JW(h),g.b==-c.b)return n.g[we.Xt(g.c,g.a)]-=g.b,n.g[we.Xt(c.c,c.a)]-=c.b,new we.Ht(g.c,c.c,g.a,c.a);for(p=new ue.KW(G);p.a<p.c.a.length;)for(g=ue.JW(p),h=new ue.KW(w);h.a<h.c.a.length;)if(c=ue.JW(h),g.b>-c.b)return n.g[we.Xt(g.c,g.a)]+=c.b,n.g[we.Xt(c.c,c.a)]-=c.b,new we.Ht(g.c,c.c,g.a,c.a);for(m=new ue.KW(G);m.a<m.c.a.length;)for(g=ue.JW(m),h=new ue.KW(w);h.a<h.c.a.length;)if(c=ue.JW(h),g.b<-c.b)return n.g[we.Xt(g.c,g.a)]-=g.b,n.g[we.Xt(c.c,c.a)]+=g.b,new we.Ht(g.c,c.c,g.a,c.a);return null},we.Ks=function(t){return t.c.a.length<2?null:new we.Gt(ue.Th(t.c,0),ue.Th(t.c,1))},we.Ls=function(n,e,o,r){var i,a,s,u,f,l,c,h,w,g,m,d,G,b,y,j,H,v,M,A,S,C;if(c=Oe($e(re.fK,2),p,14,0,[Oe($e(re.fK,1),ut,5,15,[20]),null,null,Oe($e(re.fK,1),ut,5,15,[0,10]),null,null,Oe($e(re.fK,1),ut,5,15,[-4,12]),Oe($e(re.fK,1),ut,5,15,[0,0,-7.5]),null,null,null,null,Oe($e(re.fK,1),ut,5,15,[8,-8]),null,null,null,Oe($e(re.fK,1),ut,5,15,[-2.4])]),h=Oe($e(re.hK,2),Pt,6,0,[Oe($e(re.hK,1),L,5,15,[146]),Oe($e(re.hK,1),L,5,15,[627]),null,Oe($e(re.hK,1),L,5,15,[2457,1170]),null,Oe($e(re.hK,1),L,5,15,[2451,8643,2519]),Oe($e(re.hK,1),L,5,15,[9362,14798]),Oe($e(re.hK,1),L,5,15,[34377,-2147448999,26214]),null,Oe($e(re.hK,1),L,5,15,[37449,137313,95703,34371,37815,54891,132867,-2147309741,54857,55129,-2147449005,-2147449065]),null,Oe($e(re.hK,1),L,5,15,[530697,531819,899169,137289,694617,-2146951863,-2146952797,-2146939175,-2146929547,-2146929564,-2146625111,-2146931799,-2146940503,-2146931935]),Oe($e(re.hK,1),L,5,15,[1007293,610915]),Oe($e(re.hK,1),L,5,15,[542985,137283,2122017,530691,2206773,-2144711351,219209,2840841,137555,-2146871031,-2147264167,613705,-2145360543,-2146625271,694611,2454837,-2145356703,-2147345133,-2146928951,-2146931805,-2144641719,-2146951869,-2146625237,-2146624183,2841963,1074905,-2146625117,2799955,-2144723645,138583,859225,-2145264843,-2145216253,-2146624149,-2144700727,-2146928917,-2143905527,-2144045771,-2146789097,2288547,544407,2104323,-2146911977,-2144479405,3633737,-2146870089,-2146952169]),null,Oe($e(re.hK,1),L,5,15,[8487297,2172633,2116611,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8829813]),Oe($e(re.hK,1),L,5,15,[14071213])]),y=1<<e.e.length,s=0,f=0,e.e.length>7)for(g=0;g<e.e.length;g++)1==(u=we.Ts(n,o,r,g))?s+=y:2==u&&(f+=y),s>>>=1,f>>>=1;if(v=e.e.length-9,e.e.length>=9&&e.e.length<=25&&null!=h[v])for(C=0;C<h[v].length;C++)for(b=0==(D&h[v][C]),l=N&h[v][C],d=!1;!d;d=!d){if(d){if(b)break;for(j=0,i=1;i!=y;i<<=1)j<<=1,0!=(l&i)&&(j|=1);l=j}for(M=0;M<e.e.length;M++){if(0==(l&s)&&0==(~l&f)){for(a=0,w=.017453292519943295*(null==c[v]?0:c[v][C]),H=0,A=l,G=!0,m=0;m<e.e.length;m++)G&&++H,0==(1&A)&&(G=!G),A>>>=1;for(S=H>(e.e.length/2|0),g=1;g<e.e.length;g++)e.a[g]=e.a[g-1]+t.Math.sin(a),e.b[g]=e.b[g-1]+t.Math.cos(a),0==(1&l)&&(S=!S),a+=w+(S?Ft:xn),l>>>=1;return}0!=(1&l)&&(l|=y),l>>>=1}}we.Os(e,s,f)},we.Ms=function(t){var n,e,o,r,i,a,s,u,f,l;for(n=null,f=null,a=0;a<t.e.e;a++)if(32==ce.Yj(t.e,a)){for(e=ce.Nj(t.e,0,a),r=-1,s=0;s<t.c.a.length&&-1==(r=we.Yt(ue.Th(t.c,s),e));s++);for(o=ce.Nj(t.e,1,a),i=-1,u=0;u<t.c.a.length&&-1==(i=we.Yt(ue.Th(t.c,u),o));u++);s!=u&&(s>u&&(l=s,s=u,u=l,l=r,r=i,i=l),null==f&&(f=Ke(re.bL,p,217,t.c.a.length,0,2)),null==f[u]&&(f[u]=Ke(re.bL,{217:1,4:1,7:1},54,u,0,1)),f[u][s]?we.Et(f[u][s],r,i):(Ee(f[u],s,new we.Ht(ue.Th(t.c,s),ue.Th(t.c,u),r,i)),!n&&(n=new ue.gi),ue.Oh(n,f[u][s])))}return n},we.Ns=function(n){var e,o;for(e=gt-gt*(n.e.length-2)/n.e.length,o=1;o<n.e.length;o++)n.a[o]=n.a[o-1]+t.Math.sin(e*(o-1)),n.b[o]=n.b[o-1]+t.Math.cos(e*(o-1))},we.Os=function(n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m,d,p,G;if(0!=e&&0==(e&o)){for(p=-1,G=0,a=1<<n.e.length-2,i=1<<n.e.length-1,u=1,s=2,l=0;l<n.e.length;l++)0==(o&(i|u))&&0!=(e&(i|u))&&0==(e&a)&&(m=0,0!=(o&a)&&(m+=4),0!=(e&i)&&(m+=2),0!=(e&u)&&(m+=1),G<m&&(G=m,p=l)),a=i,i=u,u=s,s=1<<(l+2<n.e.length?l+2:l+2-n.e.length);if(-1!=p){for(w=0,w|=1<<p,g=2;g<n.e.length-1;)if(0==(o&(i=1<<(0==(h=p+g<n.e.length?p+g:p+g-n.e.length)?n.e.length-1:h-1))))if(u=1<<h,0==(e&i))s=1<<(h+1<n.e.length?h+1:h+1-n.e.length),0==(e&u)||0==(o&s)?++g:(w|=u,g+=3);else{if(0!=(o&u))return void we.Ns(n);w|=u,g+=2}else++g;if(0!=w){for(r=gt-gt*(n.e.length-2)/n.e.length,c=1;c<n.e.length;c++)n.a[c]=n.a[c-1]+t.Math.sin(r*(c-1)),n.b[c]=n.b[c-1]+t.Math.cos(r*(c-1));for(u=1,d=2*t.Math.sin(r/2),f=0;f<n.e.length;f++)0!=(w&u)&&(n.a[f]+=d*t.Math.cos(r*(f-.5)),n.b[f]-=d*t.Math.sin(r*(f-.5))),u<<=1}else we.Ns(n)}else we.Ns(n)}else we.Ns(n)},we.Ps=function(t,n){var e;for(e=t-n;e<nn;)e+=wt;for(;e>gt;)e-=wt;return e},we.Qs=function(t,n,e){var o,r;for(o=0,r=0;r<ce.mm(t.e,e);r++)we.Zt(n,ce.zm(t.e,e,r))&&++o;return o},we.Rs=function(t,n,e,o){var r,i,a,s,u;return s=we.Yt(n,o),u=we.Yt(e,o),we.bu(e,n.a[s]-e.a[u],n.b[s]-e.b[u]),r=we.nt(t,n,o),i=we.nt(t,e,o),a=0,1==we.Qs(t,n,o)&&1==we.Qs(t,e,o)&&(a=Ft),we.au(e,e.a[u],e.b[u],r-i+a+gt),we.Ws(t,n,e,1)},we.Ss=function(n,e,o,r,i){var a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,k,R,I,D,F,T;for(y=Ke(re.hK,L,5,i,15,1),j=Ke(re.hK,L,5,i,15,1),d=0;d<i;d++)y[d]=we.Yt(e,r[d]),j[d]=we.Yt(o,r[d]);for(C=0,R=0,k=0,I=0,p=0;p<i;p++)C+=e.a[y[p]],R+=e.b[y[p]],k+=o.a[j[p]],I+=o.b[j[p]];for(C/=i,R/=i,k/=i,I/=i,we.bu(o,C-k,R-I),l=Ke(re.cL,x,24,i,0,1),h=Ke(re.cL,x,24,i,0,1),a=Ke(re.cL,x,24,i,0,1),s=Ke(re.cL,x,24,i,0,1),G=0;G<i;G++)l[G]=new we.Jt(C,R,e.a[y[G]],e.b[y[G]]),h[G]=new we.Jt(C,R,o.a[j[G]],o.b[j[G]]),a[G]=new we.It(l[G].a-h[G].a,l[G].b*h[G].b),s[G]=new we.It(l[G].a+h[G].a,l[G].b*h[G].b);for(H=we.rt(a,i),v=we.rt(s,i),F=0,T=0,b=0;b<i;b++)for(N=0;N<ce.mm(n.e,r[b]);N++)u=ce.zm(n.e,r[b],N),we.Zt(e,u)&&!we.Zt(o,u)&&++F,!we.Zt(e,u)&&we.Zt(o,u)&&++T;for(c=Ke(re.cL,x,24,F,0,1),w=Ke(re.cL,x,24,T,0,1),g=Ke(re.cL,x,24,T,0,1),F=0,T=0,m=0;m<i;m++)for(N=0;N<ce.mm(n.e,r[m]);N++)u=ce.zm(n.e,r[m],N),we.Zt(e,u)&&!we.Zt(o,u)&&(f=we.Yt(e,u),c[F]=new we.Jt(e.a[y[m]],e.b[y[m]],e.a[f],e.b[f]),++F),!we.Zt(e,u)&&we.Zt(o,u)&&(f=we.Yt(o,u),D=new we.Jt(o.a[j[m]],o.b[j[m]],o.a[f],o.b[f]),w[T]=new we.It(H.a+D.a,D.b),g[T]=new we.It(v.a-D.a,D.b),++T);return M=we.rt(c,F),A=we.rt(w,T),S=we.rt(g,T),t.Math.abs(we.Ps(M.a,A.a))>t.Math.abs(we.Ps(M.a,S.a))?we.au(o,C,R,H.a):(we.St(o,C,R),we.au(o,C,R,v.a)),we.Ws(n,e,o,i)},we.Ts=function(t,n,e,o){var r,i,a,s,u,f;return i=o==n.length-1?0:o+1,s=0==o?n.length-1:o-1,a=i==n.length-1?0:i+1,2!=ce.Vj(t.e,e[o])||1!=(r=ce.Wj(t.e,e[o]))&&2!=r?ce.An(t.e,e[o])&&(u=ce.Tp(ce.Ym(t.e),e[s],e[o]),f=ce.Tp(ce.Ym(t.e),e[i],e[o]),-1!=u||-1!=f)?u==f?2:1:0:(we._s(t,n[s],n[o],n[i])^we._s(t,n[a],n[i],n[o])&&(r=1==r?2:1),r)},we.Us=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w;for(r=Ke(re.hK,L,5,t.e.o,15,1),i=Ke(re.hK,L,5,t.e.o,15,1),a=Ke(re.hK,L,5,t.e.o,15,1),s=Ke(re.hK,L,5,t.e.o,15,1),r[0]=n,a[n]=1,s[0]=-1,o=0,u=0;o<=u;){if(0==o||!t.a[r[o]])for(f=0;f<ce.mm(t.e,r[o]);f++)e=ce.zm(t.e,r[o],f),h=ce.Bm(t.e,r[o],f),0!=a[e]||t.b[h]||(r[++u]=e,i[u]=h,a[e]=a[r[o]]+1,s[u]=o);if(o==u){for(w=new we.Lt(a[r[o]]),l=o,c=0;c<w.a.length;c++)w.a[c]=r[l],w.b[c]=i[l],l=s[l];return w}++o}return null},we.Vs=function(t){var n,e,o,r;for(r=0,o=null,e=new ue.KW(t);e.a<e.c.a.length;)r<(n=ue.JW(e)).b[0].e.length*n.b[1].e.length&&(r=n.b[0].e.length*n.b[1].e.length,o=n);return o},we.Ws=function(t,n,e,o){var r,i,a,s,u;for(i=new we.cu(t.e,n.e.length+e.e.length-o,t.d),r=0,s=0;s<n.e.length;s++)i.e[r]=n.e[s],i.k[r]=n.k[s],i.a[r]=n.a[s],i.b[r++]=n.b[s];for(a=0;a<e.e.length;a++)-1==(u=we.Yt(n,e.e[a]))?(i.e[r]=e.e[a],i.k[r]=e.k[a],i.a[r]=e.a[a],i.b[r++]=e.b[a]):i.k[u]<e.k[a]&&(i.k[u]=e.k[a],i.a[u]=e.a[a],i.b[u]=e.b[a]);return i},we.Xs=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g;for(s=Ke(re.hK,L,5,t.e.o,15,1),u=Ke(re.hK,L,5,t.e.o,15,1),f=Ke(re.hK,L,5,t.e.o,15,1),l=Ke(re.hK,L,5,t.e.o,15,1),s[0]=e,f[e]=1,l[0]=-1,a=0,c=0;a<=c;){for(h=0;h<ce.nm(t.e,s[a]);h++){if(r=ce.zm(t.e,s[a],h),g=ce.Bm(t.e,s[a],h),r==n){for(i=f[s[a]],(o=Ke(re.hK,L,5,i,15,1))[0]=g,w=1;w<i;w++)o[w]=u[a],a=l[a];return o}0==f[r]&&(s[++c]=r,u[c]=g,f[r]=f[s[a]]+1,l[c]=a)}if(a==c)return null;++a}return null},we.Ys=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g;for(e=ce.Nj(t.e,0,n),o=ce.Nj(t.e,1,n),a=Ke(re.hK,L,5,t.e.o,15,1),s=Ke(re.hK,L,5,t.e.o,15,1),u=Ke(re.hK,L,5,t.e.o,15,1),f=Ke(re.hK,L,5,t.e.o,15,1),a[0]=e,a[1]=o,s[1]=n,u[e]=1,u[o]=2,f[0]=-1,f[1]=0,i=1,l=1;i<=l;){for(c=0;c<ce.mm(t.e,a[i]);c++){if(r=ce.zm(t.e,a[i],c),i>1&&r==e){for(g=new we.Lt(u[a[i]]),s[0]=ce.Bm(t.e,a[i],c),h=i,w=0;w<g.a.length;w++)g.a[w]=a[h],g.b[w]=s[h],h=f[h];return g}0==u[r]&&ce.wn(t.e,r)&&(a[++l]=r,s[l]=ce.Bm(t.e,a[i],c),u[r]=u[a[i]]+1,f[l]=i)}++i}return null},we.Zs=function(t,n,e,o){var r,i,a,s,u,f;for(a=Ke(re.hK,L,5,t.e.o,15,1),s=Ke(re.hK,L,5,t.e.o,15,1),a[0]=e,a[1]=n,s[e]=1,s[n]=2,i=1,u=1;i<=u;){for(f=0;f<ce.mm(t.e,a[i]);f++){if((r=ce.zm(t.e,a[i],f))==o)return 1+s[a[i]];0==s[r]&&ce.wn(t.e,r)&&(a[++u]=r,s[r]=s[a[i]]+1)}++i}return 0},we.$s=function(t,n){var e,o,r,i,a,s;for(s=0!=(15&n.R),!t.f&&(t.f=new ue.NX),0!=(2&t.d)&&ce.Hn(n,!1),t.e=n,ce.Jr(t.e,7),t.c=new ue.gi,t.a=Ke(re.DN,ft,5,t.e.o,16,1),t.b=Ke(re.DN,ft,5,t.e.p,16,1),t.g=Ke(re.hK,L,5,t.e.o,15,1),e=0;e<t.e.o;e++)t.g[e]=ce.rj(t.e,e);for(0!=(12&t.d)&&we.jt(t),0==(1&t.d)&&we.Ds&&we.lt(t,we.Ds),we.it(t),we.et(t),we.gt(t),we.et(t),r=new ue.KW(t.c);r.a<r.c.a.length;)o=ue.JW(r),we.$t(o);for(we.Is(t),we.mt(t),we.kt(t),we.dt(t),we.bt(t),we.ft(t),i=0;i<t.c.a.length;i++)for(o=ue.Th(t.c,i),a=0;a<o.e.length;a++)ce.jl(t.e,o.e[a],o.a[a]),ce.kl(t.e,o.e[a],o.b[a]),ce.ll(t.e,o.e[a],0);s&&ce.Nn(t.e)},we._s=function(t,n,e,o){var r,i;for(i=0;i<ce.Am(t.e,e);i++)if((r=ce.zm(t.e,e,i))!=o&&r<n)return!1;return!0},we.at=function(t,n,e){var o;we.Ft(n,e,0!=(12&t.d)),o=we.Ws(t,n.b[0],n.b[1],0),we.ot(t,n.b[0],n.b[1],o)},we.bt=function(t){var n;for(n=we.Js(t);n;)we.at(t,n,1.5),n=we.Js(t)},we.ct=function(t,n,e,o){var r,i,a,s,u;for(r=Ke(re.hK,L,5,o,15,1),i=0,a=0;a<n.e.length;a++)for(s=0;s<e.e.length;s++)n.e[a]==e.e[s]&&(r[i++]=n.e[a]);u=1==o?we.Rs(t,n,e,r[0]):we.Ss(t,n,e,r,o),we.ot(t,n,e,u)},we.dt=function(t){var n,e;for(e=we.Ms(t);e;)n=we.Vs(e),we.at(t,n,1.2),e=we.Ms(t)},we.et=function(t){for(var n,e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G;;){for(G=0,w=0,d=null,p=null,a=1;a<t.c.a.length;a++)for(o=ue.Th(t.c,a),s=0;s<a;s++){for(r=ue.Th(t.c,s),n=0,e=0,g=0,m=0,l=0;l<o.e.length;l++)for(h=0;h<r.e.length;h++)o.e[l]==r.e[h]&&(++e,n=o.e[l],g<o.k[l]&&(g=o.k[l]),m<r.k[h]&&(m=r.k[h]));if(e>0&&(i=1==e&&1==we.Qs(t,o,n)&&1==we.Qs(t,r,n)?0:1,G<(u=g>m?(i<<24)+(g<<16)+(m<<8)+e:(i<<24)+(m<<16)+(g<<8)+e))){for(G=u,w=e,g=0,m=0,c=0;c<o.e.length;c++)g<o.k[c]&&(g=o.k[c]);for(f=0;f<r.e.length;f++)m<r.k[f]&&(m=r.k[f]);g>m?(d=o,p=r):(d=r,p=o)}}if(0==G)break;w==d.e.length?ue._h(t.c,d):w==p.e.length?ue._h(t.c,p):we.ct(t,d,p,w)}},we.ft=function(t){var n;for(n=we.Ks(t);n;)we.at(t,n,1.8),n=we.Ks(t)},we.gt=function(n){for(var e,o,r,i,a,s,u;;){for(a=null,e=0;e<n.e.o;e++){for(u=0,i=0;i<ce.mm(n.e,e);i++)n.b[ce.Bm(n.e,e,i)]||++u;1==u&&(s=we.Us(n,e),(!a||s.a.length>a.a.length)&&(a=s))}if(!a)break;for(o=new we.cu(n.e,a.a.length,n.d),r=0;r<a.a.length;r++)n.a[a.a[r]]=!0,r<a.a.length-1&&(n.b[a.b[r]]=!0),o.e[r]=a.a[r],o.a[r]=t.Math.cos(Tt)*r,o.b[r]=1==(1&r)?0:.5,o.k[r]=128+a.a.length;ue.Oh(n.c,o)}},we.ht=function(t,n,e){var o,r,i,a,s,u,f,l,c,h;for(i=0;i<t.e.p;i++)if(o=ce.Nj(t.e,0,i),r=ce.Nj(t.e,1,i),!(ce.xn(t.e,i)||1!=ce.Vj(t.e,i)||1==ce.mm(t.e,o)||1==ce.mm(t.e,r)||0!=(4&t.d)&&ce.wk(t.e,o)&&ce.wk(t.e,r))){for(c=!1,f=0;f<2;f++)if(a=ce.Nj(t.e,f,i),ce.mm(t.e,a)>2){for(h=!0,u=-1,l=0;l<ce.mm(t.e,a);l++)(s=ce.zm(t.e,a,l))!=ce.Nj(t.e,1-f,i)&&(-1==u?u=e[s]:u!=e[s]&&(h=!1));if(h){c=!0;break}}c||(0!=(8&t.d)&&ce.wk(t.e,o)&&ce.wk(t.e,r)?n[i]=1:n[i]=2)}},we.it=function(n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,x,k,R,I,D,F,T;for(r=0;r<n.e.o;r++)if(ce.mm(n.e,r)>4){for((w=new we.cu(n.e,1+ce.mm(n.e,r),n.d)).a[ce.mm(n.e,r)]=0,w.b[ce.mm(n.e,r)]=0,w.k[ce.mm(n.e,r)]=32,w.e[ce.mm(n.e,r)]=r,n.a[r]=!0,m=0;m<ce.mm(n.e,r);m++)l=ce.zm(n.e,r,m),w.a[m]=t.Math.sin(Ft*m-Rn),w.b[m]=t.Math.cos(Ft*m-Rn),w.k[m]=32,w.e[m]=l,n.a[l]=!0,n.b[ce.Bm(n.e,r,m)]=!0;ue.Oh(n.c,w)}for(R=ce.Ym(n.e),k=0;k<R.i.a.length;k++){if(I=ue.Th(R.j,k).length,C=ue.Th(R.i,k),D=!1,0!=(12&n.d))for(D=!0,m=0;m<I;m++)if(!ce.wk(n.e,C[m])){D=!1;break}if(!D){for(G=!1,d=0;d<I;d++)if(ce.um(n.e,C[d])==I){G=!0;break}if(G)for(x=ue.Th(R.j,k),we.Es(n,C,x),m=0;m<I;m++)n.a[C[m]]=!0,n.b[x[m]]=!0}}for(u=0;u<n.e.p;u++)if(ce.xn(n.e,u)&&!n.b[u])for(C=(T=we.Ys(n,u)).a,x=T.b,we.Es(n,C,x),m=0;m<T.a.length;m++)n.a[C[m]]=!0,n.b[x[m]]=!0;for(f=0;f<n.e.p;f++)if(!n.b[f]&&3==ce.Vj(n.e,f)&&(i=ce.Nj(n.e,0,f),a=ce.Nj(n.e,1,f),(H=ce.mm(n.e,i)+ce.mm(n.e,a))>2)){for(w=new we.cu(n.e,H,n.d),c=0,d=0;d<ce.mm(n.e,i);d++)(l=ce.zm(n.e,i,d))!=a&&(w.e[c++]=l,n.a[l]=!0,n.b[ce.Bm(n.e,i,d)]=!0);for(w.e[c++]=i,w.e[c++]=a,p=0;p<ce.mm(n.e,a);p++)(l=ce.zm(n.e,a,p))!=i&&(w.e[c++]=l,n.a[l]=!0,n.b[ce.Bm(n.e,a,p)]=!0);for(m=0;m<H;m++)w.a[m]=m,w.b[m]=0,w.k[m]=1;n.a[i]=!0,n.a[a]=!0,n.b[f]=!0,ue.Oh(n.c,w)}for(s=0;s<n.e.p;s++)if(!n.b[s]&&2==ce.Vj(n.e,s))for(e=Ke(re.hK,L,5,n.e.o,15,1),m=0;m<2;m++)if(e[0]=ce.Nj(n.e,m,s),e[1]=ce.Nj(n.e,1-m,s),1==ce.qm(n.e,e[0])&&2==ce.qm(n.e,e[1])&&2==ce.mm(n.e,e[1])){n.a[e[0]]=!0,n.a[e[1]]=!0,n.b[s]=!0,N=1;do{if(v=ce.zm(n.e,e[N],0)==e[N-1]?1:0,e[N+1]=ce.zm(n.e,e[N],v),2==ce.qm(n.e,e[N+1])&&ce.mm(n.e,e[N+1])>2)break;n.a[e[N+1]]=!0,n.b[ce.Bm(n.e,e[N],v)]=!0,++N}while(2==ce.qm(n.e,e[N])&&2==ce.mm(n.e,e[N]));for(H=ce.mm(n.e,e[0])+ce.mm(n.e,e[N])+N-1,w=new we.cu(n.e,H,n.d),y=0;y<=N;y++)w.a[y]=y,w.b[y]=0,w.k[y]=64,w.e[y]=e[y];for(h=N+1,g=!1,j=0;j<ce.mm(n.e,e[0]);j++)(l=ce.zm(n.e,e[0],j))!=e[1]&&(w.a[h]=-.5,w.b[h]=g?t.Math.sin(Ft):-t.Math.sin(Ft),w.k[h]=64,w.e[h]=l,++h,g=!0);for(g=!1,b=0;b<ce.mm(n.e,e[N]);b++)(l=ce.zm(n.e,e[N],b))!=e[N-1]&&(w.a[h]=N+.5,w.b[h]=g?-t.Math.sin(Ft):t.Math.sin(Ft),w.k[h]=64,w.e[h]=l,++h,g=!0);ue.Oh(n.c,w)}for(o=0;o<n.e.o;o++)if(4==ce.mm(n.e,o)){for(M=Ke(re.hK,L,5,4,15,1),A=Ke(re.hK,L,5,4,15,1),S=0,d=0;d<4;d++)M[S]=ce.zm(n.e,o,d),A[S]=ce.Bm(n.e,o,d),1==ce.mm(n.e,M[S])&&!n.b[A[S]]&&++S;if(2==S){for(w=new we.cu(n.e,3,n.d),m=0;m<2;m++)n.a[M[m]]=!0,n.b[A[m]]=!0,w.e[m]=M[m],w.k[m]=32;w.a[0]=-.5,w.b[0]=.866,w.a[1]=.5,w.b[1]=.866,w.a[2]=0,w.b[2]=0,w.k[2]=32,w.e[2]=o,ue.Oh(n.c,w)}if(3==S){for(p=0;p<2;p++)1==ce.Vj(n.e,A[p])&&(F=M[p],M[p]=M[2],M[2]=F,F=A[p],A[p]=A[2],A[2]=F);for(w=new we.cu(n.e,4,n.d),m=0;m<3;m++)n.a[M[m]]=!0,n.b[A[m]]=!0,w.e[m]=M[m],w.k[m]=32;w.a[0]=-1,w.b[0]=0,w.a[1]=1,w.b[1]=0,w.a[2]=0,w.b[2]=1,w.a[3]=0,w.b[3]=0,w.k[3]=32,w.e[3]=o,ue.Oh(n.c,w)}}},we.jt=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j;for(s=0,e=0;e<t.e.o;e++)ce.wk(t.e,e)&&++s;if(!(s<2)){for(c=0,f=0,l=0;l<t.e.p;l++)o=ce.Nj(t.e,0,l),r=ce.Nj(t.e,1,l),ce.wk(t.e,o)&&ce.wk(t.e,r)&&(t.b[l]=!0,t.a[o]=!0,t.a[r]=!0,f+=ce.Tj(t.e,l),++c);for(0!=c&&0!=f?f/=c:f=ce.Jj(t.e),i=0;i<t.e.o;i++)ce.wk(t.e,i)&&!t.a[i]&&--s;if(!(s<2)){for(b=Ke(re.hK,L,5,t.e.o,15,1),h=ce.Im(t.e,b,!0,!0),G=Ke(re.hK,L,5,h,15,1),a=0;a<t.e.o;a++)-1!=b[a]&&++G[b[a]];for(p=Ke(re.gL,x,31,h,0,1),g=0;g<h;g++)p[g]=new we.cu(t.e,G[g],t.d);for(u=Ke(re.hK,L,5,h,15,1),n=0;n<t.e.o;n++)-1!=(m=b[n])&&(p[m].k[u[m]]=Gt,p[m].e[u[m]]=n,p[m].a[u[m]]=ce.Fj(t.e,n)/f,p[m].b[u[m]]=ce.Gj(t.e,n)/f,++u[m]);for(y=-1,j=0,d=0;d<h;d++)j<G[d]&&(j=G[d],y=d);for(ue.Oh(t.c,p[y]),w=0;w<h;w++)w!=y&&ue.Oh(t.c,p[w])}}},we.kt=function(t){var n,e;for(n=0;n<t.e.o;n++)t.a[n]||0!=ce.mm(t.e,n)||(e=new we.cu(t.e,1,t.d),t.a[n]=!0,e.e[0]=n,e.a[0]=0,e.b[0]=0,e.k[0]=0,ue.Oh(t.c,e))},we.lt=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m;for(null,h=new ce.Dq,ce.xq(h,t.e),a=Ke(re.DN,ft,5,t.e.d,16,1),g=n.mb();g.Ob();)if(w=g.Pb(),c=null,ce.wq(h,w.b),0!=ce.lq(h,4,8)&&(c=h.A),c)for(l=new ue.KW(c);l.a<l.c.a.length;){for(m=0,r=0,i=(o=f=ue.JW(l)).length;r<i;++r)a[e=o[r]]&&++m;if(m<=1){for(s=new we.cu(t.e,f.length,t.d),u=0;u<f.length;u++)e=f[u],s.k[u]=256,s.e[u]=e,s.a[u]=ce.Fj(w.b,u)/w.a,s.b[u]=ce.Gj(w.b,u)/w.a,a[e]=!0,t.a[e]=!0;ue.Oh(t.c,s)}}return a},we.mt=function(t){var n,e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y;for(n=we.Gs(t),i=Ke(re.dK,U,5,t.e.p,15,1),we.ht(t,i,n),r=0;r<t.e.p;r++)2==i[r]&&(ce.wn(t.e,ce.Nj(t.e,0,r))||ce.wn(t.e,ce.Nj(t.e,1,r)))&&(i[r]=3);for(w=0;w<t.c.a.length;w++){for(c=ue.Th(t.c,w),u=we.Wt(c),p=c.c,d=new we.du(c,t.d),m=-1,h=0;h<224&&0!=u.a.length;h++){if(f=ue.KX(t.f,u.a.length),le.L$(f,u.a.length),s=u.a[f],a=we.Xs(t,s[0],s[1]),e=Ke(re.hK,L,5,a.length,15,1),o=0,h<32)for(g=1;g<a.length-1;g++)3==i[a[g]]&&(e[o++]=a[g]);else if(h<96)for(g=1;g<a.length-1;g++)i[a[g]]>=2&&(e[o++]=a[g]);else for(g=1;g<a.length-1;g++)i[a[g]]>=1&&(e[o++]=a[g]);if(0!=o){if(b=e[0],o>1)do{b=e[ue.KX(t.f,o)]}while(b==m);b!=m&&(m=b,we.Tt(c,b),u=we.Wt(c),p>c.c&&(p=c.c,d=new we.du(c,t.d)))}}ue.bi(t.c,w,d),c=d,l=1;do{for(G=9999,g=0;g<c.e.length;g++)(y=n[c.e[g]])==l?we._t(c,g):y>l&&y<G&&(G=y);l=G}while(9999!=G)}},we.nt=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b;for(r=Ke(re.fK,ut,5,ce.mm(t.e,e)+1,15,1),a=Ke(re.hK,L,5,ce.mm(t.e,e)+1,15,1),s=Ke(re.hK,L,5,ce.mm(t.e,e)+1,15,1),d=we.Yt(n,e),i=0,f=0;f<ce.mm(t.e,e);f++)a[i]=ce.zm(t.e,e,f),s[i]=ce.Bm(t.e,e,f),-1!=(c=we.Yt(n,a[i]))&&(r[i++]=we.Kt(n.a[d],n.b[d],n.a[c],n.b[c]));if(1==i)return r[0]+gt;for(l=i-1;l>0;l--)for(h=0;h<l;h++)r[h]>r[h+1]&&(p=r[h],r[h]=r[h+1],r[h+1]=p,G=a[h],a[h]=a[h+1],a[h+1]=G,b=s[h],s[h]=s[h+1],s[h+1]=b);for(r[i]=r[0]+wt,a[i]=a[0],s[i]=s[0],w=-100,g=0,u=0;u<i;u++)o=r[u+1]-r[u],i>2&&ce.xn(t.e,s[u])&&ce.xn(t.e,s[u+1])&&0!=(m=we.Zs(t,a[u],e,a[u+1]))&&(o-=100-m),w<o&&(w=o,g=u);return(r[g]+r[g+1])/2},we.ot=function(n,e,o,r){var i;i=t.Math.min(ue.Vh(n.c,e,0),ue.Vh(n.c,o,0)),ue.Nh(n.c,i,r),ue._h(n.c,e),ue._h(n.c,o)},we.pt=function(){we.qt.call(this)},we.qt=function(){this.d=2,!we.Ds&&!we.Ds&&(we.Ds=new we.Pt)},we.rt=function(n,e){var o,r,i,a,s;for(s=0,o=0,r=0;r<e;r++)s+=n[r].b*t.Math.sin(n[r].a),o+=n[r].b*t.Math.cos(n[r].a);return 0==o?a=s>0?mt:xt:(a=t.Math.atan(s/o),o<0&&(a+=gt)),i=t.Math.sqrt(s*s+o*o)/e,new we.It(a,i)},Te(80,1,{},we.pt),a.d=0,re.aL=vo(80),we.st=function(n,e){var o,r;return(o=t.Math.abs(n.b))<(r=t.Math.abs(e.b))?-1:o==r?0:1},we.tt=function(){},Te(158,1,{},we.tt),a.kb=function(t,n){return we.st(t,n)},a.gb=function(t){return this===t},re.ZK=vo(158),we.wt=function(t){var n,e;return(n=t.c.e.length)<(e=t.c.e.length)?1:n==e?0:-1},we.xt=function(){},Te(159,1,{},we.xt),a.kb=function(t,n){return we.wt(t)},a.gb=function(t){return this===t},re.$K=vo(159),we.At=function(t){var n,e;return(n=t.c.e.length)<(e=t.c.e.length)?-1:n==e?0:1},we.Bt=function(){},Te(160,1,{},we.Bt),a.kb=function(t,n){return we.At(t)},a.gb=function(t){return this===t},re._K=vo(160),we.Et=function(t,n,e){t.c[0]+=we.Ut(t.b[0],n),t.d[0]+=we.Vt(t.b[0],n),t.c[1]+=we.Ut(t.b[1],e),t.d[1]+=we.Vt(t.b[1],e),++t.a[0],++t.a[1]},we.Ft=function(n,e,o){var r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H;for(r=Ke(re.fK,ut,5,2,15,1),l=0;l<2;l++)n.c[l]/=n.a[l],n.d[l]/=n.a[l],r[l]=we.Qt(n.b[l],n.c[l],n.d[l],n.b[1-l].e.length,e);for(we.au(n.b[0],n.c[0],n.d[0],mt-r[0]),we.au(n.b[1],n.c[1],n.d[1],4.71238898038469-r[1]),H=_t,N=-17976931348623157e292,s=n.d[0]-n.d[1],c=0;c<n.b[1].b.length;c++)n.b[1].b[c]+=s,H>n.b[1].b[c]&&(H=n.b[1].b[c]),N<n.b[1].b[c]&&(N=n.b[1].b[c]);for(H+=((y=N-H+2*e)-(i=ze(t.Math.ceil(y))))/2-e,G=Ke(re.fK,ut,5,i,15,1),h=0;h<i;h++)G[h]=n.c[1]+e;for(w=0;w<n.b[1].b.length;w++)for(b=ze((j=n.b[1].b[w]-H)-e),u=t.Math.min(ze(j+e),i-1),p=b;p<=u;p++)G[p]>n.b[1].a[w]&&(G[p]=n.b[1].a[w]);for(g=0;g<i;g++)G[g]-=e;for(a=n.c[0]-n.c[1],m=0;m<n.b[0].a.length;m++)(d=ze(n.b[0].b[m]-H))>=0&&d<G.length&&a<n.b[0].a[m]-G[d]&&(a=n.b[0].a[m]-G[d]);for(f=0;f<n.b[1].a.length;f++)n.b[1].a[f]+=a;o&&(we.au(n.b[0],n.c[0],n.d[0],r[0]-mt),we.au(n.b[1],n.c[0],n.d[0],r[0]-mt))},we.Gt=function(t,n){var e,o;for(this.b=Ke(re.gL,x,31,2,0,1),this.b[0]=t,this.b[1]=n,this.c=Ke(re.fK,ut,5,2,15,1),this.d=Ke(re.fK,ut,5,2,15,1),this.a=Ke(re.hK,L,5,2,15,1),e=0;e<2;e++){for(o=0;o<this.b[e].e.length;o++)this.c[e]+=we.Ut(this.b[e],o),this.d[e]+=we.Vt(this.b[e],o);this.a[e]=this.b[e].e.length}},we.Ht=function(t,n,e,o){this.b=Ke(re.gL,x,31,2,0,1),this.b[0]=t,this.b[1]=n,this.c=Ke(re.fK,ut,5,2,15,1),this.d=Ke(re.fK,ut,5,2,15,1),this.c[0]=we.Ut(this.b[0],e),this.d[0]=we.Vt(this.b[0],e),this.c[1]=we.Ut(this.b[1],o),this.d[1]=we.Vt(this.b[1],o),this.a=Ke(re.hK,L,5,2,15,1),this.a[0]=1,this.a[1]=1},Te(54,1,{54:1},we.Gt,we.Ht),re.bL=vo(54),we.It=function(t,n){this.a=t,this.b=n},we.Jt=function(n,e,o,r){var i,a;this.a=we.Kt(n,e,o,r),i=o-n,a=r-e,this.b=t.Math.sqrt(i*i+a*a)},we.Kt=function(n,e,o,r){var i,a,s;return a=o-n,0!=(s=r-e)?(i=t.Math.atan(a/s),s<0&&(a<0?i-=gt:i+=gt)):i=a>0?mt:xt,i},Te(24,1,{24:1},we.It,we.Jt),a.a=0,a.b=0,re.cL=vo(24),we.Lt=function(t){this.a=Ke(re.hK,L,5,t,15,1),this.b=Ke(re.hK,L,5,t,15,1)},Te(128,1,{},we.Lt),re.dL=vo(128),we.Mt=function(t,n,e){this.c=t,this.a=n,this.b=e},Te(101,1,{101:1},we.Mt),a.a=0,a.b=0,re.eL=vo(101),we.Ot=function(){we.Ot=De,we.Nt=Oe($e(re.uM,1),P,2,6,["gkvt@@@@LddTTTrbTRTRTRRRRRRRRRRRRRrVRrIh\\IAaQxlY@gRHdJCJcRXlv_CfJx|A\\hRHejiLaQjTje^kSjtFcIhvXmVKMjt{lN{Kavy\\^wGjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjh@@vo@HBC@PhLN@bPhtFKCcpDbILaRhtzCIbsX\\nOO`JDbqDjSKdJeJmQjtz}Ahr[LVkMnpz\\nwGj{PBhBdBlBBBjBfBnBaBiBeBmBcBkBgBoB`bhbdblbbbjbfbnbabibebmbcbkbgbob`RhRdRlRbRjRfRnRaRiReRmRcRkRgRoR`rhrdrlrbrjrfrnrarirermrcrkrgror`JhJdJlJbJjJfJnJaJiJeJmJcJkJgJoJ`jhjdjljbjjjfjnjajijej` !BnkjyVwsVr|iQn|Q|goTZWPIJwbudnRkVYBez]siZymNJZUqNFBqZWxS~iCXVU]SeRjwrtSPAjkvXLpBAZauDPzq]PfMlecrMnkv|@\\SFD`m|mWiEoCXp`SIe_J[l|[XCbloTV`[Gc@FJGopyyoOlFQfUy^w\\Bgz|","gcrt@@@@LdbbbbTRbRbRbRRRRRRRRRRRRVRrVQIA`HtRGAaIxZAHfShTjCIbqylQGKgqdBaXeQJeruBiPitZmFoPZLFSYbvZlVGMnsZ]vWSmr{]UUUUUUUUUUUUUUUUUUUUUUUUUUUUUT@@[G`DAA`HTFG@QHTZCEaqxBQDfPiTZ]AdqYlNWGgpEBQXbUIerEReVhuZ]^`tYMfKUfwX]NW[jkPBhBdBlBbBjBfBnBaBiBeBmBcBkBgBoB`bhbdblbbbjbfbnbabibebmbcbkbgbob`RhRdRlRbRjRfRnRaRiReRmRcRkRgRoR`rhrdrlrbrjrfrnrarirermrcrkrgror`JhJdJlJbJjJfJnJaJiJeJmJcJkJgJoJ`jhjdjljbjjjfjnjajij` !B^cR]`]Fm]QkfljE\\pUVfgOmFXsQe_gXPyXis_wF|vUUX_XbxpzU]HUFgYViwFo~@uemc@}~TIEPioYVwr]JnM~[ZEC\\g}~o_pUfdo~irsklTLiyVJshnw^iVAsZ`_~}PYkckURH{FYMImFaRaccUlCZSHMfP","dml@@Dje^VGiyZjjjh@vtHSBinFU@ !BPTCTy[skMzUPF`AJbBixEZHS[Il","dml@@DjYVvGiyZjjjh@vtHSBinFU@ !BwLo~BJ~UquhXBinZ\\ykA@F_eMrT","dml@@LdfbbQX^fUZjjj`C[PaLJfxYT !BzxIHVc{OiJVRpprePho~]}ywLl","deL@@DjUYkfEijjjj@MeBDpj[ad !BaAMVr[AvkKzm_jKvVbD{sk","dil@@LddTQRl[NX^Fjjjj@MiBDpj[a@ !BPfL@ox@M~T@ox@`C~@@","daL@@DjYtKJqjynjjjj@MaBDpj[` !B`bL@_gx@@Gy~@Gx@_`@"])},we.Pt=function(){var t,n,e,o,r,i,a;for(we.Ot(),ue.gi.call(this),i=new ce.Rq,o=0,r=(e=we.Nt).length;o<r;++o)n=e[o],t=ce._n(new ce.fo,n),ce.Kq(i,t),(a=new we.eu(t)).a=ce.Jj(a.b),this.a[this.a.length]=a},Te(180,18,Y,we.Pt),re.fL=vo(180),we.Qt=function(n,e,o,r,i){var a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,x;if(1==n.e.length)return 0;for(A=i+t.Math.sqrt(r),c=Ke(re.fK,ut,5,36,15,1),m=0;m<n.e.length;m++)a=we.Kt(e,o,n.a[m],n.b[m]),u=we.Rt(jo(io(t.Math.round(36*a/wt)))),C=(h=e-n.a[m])*h+(w=o-n.b[m])*w,c[u]<C&&(c[u]=C);for(N=-1,j=-1,d=0;d<36;d++)c[d]=t.Math.sqrt(c[d]),N<c[d]&&(N=c[d],j=d);for(S=j-18<0?j-18+36:j-18>=36?j-18-36:j-18,p=0;p<=18;p++)c[S+p<0?S+p+36:S+p>=36?S+p-36:S+p]+=.01*p,c[S-p<0?S-p+36:S-p>=36?S-p-36:S-p]+=.01*p;for(x=Ke(re.fK,ut,5,9,15,1),f=Ke(re.fK,ut,5,9,15,1),G=1;G<9;G++)x[G]=t.Math.sin(G*In),f[G]=t.Math.cos(G*In);for(v=_t,H=-1,s=0;s<36;s++)if(!(c[s]>=v)){for(y=c[s],g=1;g<9;g++){for(b=-1;b<=1&&!(!(c[M=s+b*g<0?s+b*g+36:s+b*g>=36?s+b*g-36:s+b*g]*f[g]<=y)&&y<(l=f[g]*t.Math.min(c[M],A/x[g]))&&v<=(y=l));b+=2);if(v<=y)break}v>y&&(v=y,H=s)}return wt*H/36},we.Rt=function(t){return t<0?t+36:t>=36?t-36:t},we.St=function(n,e,o){var r,i,a;for(a=0;a<n.e.length;a++)i=t.Math.sqrt((n.a[a]-e)*(n.a[a]-e)+(n.b[a]-o)*(n.b[a]-o)),r=0-we.Kt(e,o,n.a[a],n.b[a]),n.a[a]=e+i*t.Math.sin(r),n.b[a]=o+i*t.Math.cos(r)},we.Tt=function(n,e){var o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N;if(null==n.d&&(n.d=Ke(re.hK,Pt,6,n.j.p,0,2)),null==n.d[e]){for(w=Ke(re.hK,L,5,n.e.length,15,1),b=Ke(re.DN,ft,5,n.j.o,16,1),r=ce.Nj(n.j,0,e),i=ce.Nj(n.j,1,e),w[0]=r,b[r]=!0,l=0,g=0;l<=g;){for(d=0;d<ce.mm(n.j,w[l]);d++)b[a=ce.zm(n.j,w[l],d)]||a==i||(w[++g]=a,b[a]=!0);if(l==g)break;++l}if(h=g+1>(n.e.length/2|0),0!=(12&n.i)){for(u=!1,s=!1,d=0;d<n.e.length;d++)ce.wk(n.j,n.e[d])&&(b[n.e[d]]?u=!0:s=!0);u!=s&&(h=u)}for(f=2,n.d[e]=Ke(re.hK,L,5,h?n.e.length-g:g+2,15,1),p=0;p<n.e.length;p++)n.e[p]==r?n.d[e][h?0:1]=p:n.e[p]==i?n.d[e][h?1:0]=p:h^b[n.e[p]]&&(n.d[e][f++]=p)}for(j=n.a[n.d[e][0]],N=n.b[n.d[e][0]],y=we.Kt(j,N,n.a[n.d[e][1]],n.b[n.d[e][1]]),m=2;m<n.d[e].length;m++)G=n.d[e][m],c=t.Math.sqrt((n.a[G]-j)*(n.a[G]-j)+(n.b[G]-N)*(n.b[G]-N)),o=2*y-we.Kt(j,N,n.a[G],n.b[G]),n.a[G]=j+c*t.Math.sin(o),n.b[G]=N+c*t.Math.cos(o)},we.Ut=function(t,n){return t.a[n]},we.Vt=function(t,n){return t.b[n]},we.Wt=function(n){var e,o,r,i,a,s,u,f;for(n.c=0,o=new ue.gi,i=1;i<n.e.length;i++)for(a=0;a<i;a++)u=t.Math.abs(n.a[i]-n.a[a]),f=t.Math.abs(n.b[i]-n.b[a]),(r=t.Math.sqrt(u*u+f*f))<.8&&((e=Ke(re.hK,L,5,2,15,1))[0]=n.e[i],e[1]=n.e[a],o.a[o.a.length]=e),s=1-t.Math.min(r,1),n.c+=s*s;return o},we.Xt=function(t,n){return t.e[n]},we.Yt=function(t,n){var e;for(e=0;e<t.e.length;e++)if(n==t.e[e])return e;return-1},we.Zt=function(t,n){var e;for(e=0;e<t.e.length;e++)if(n==t.e[e])return!0;return!1},we.$t=function(t){var n,e,o,r,i,a;for(o=0,i=0;i<t.e.length;i++)for(n=t.e[i],e=ce.mm(t.j,n),a=0;a<e;a++)ce.zm(t.j,n,a)>n&&++o;for(t.f=Ke(re.hK,L,5,o,15,1),t.g=Ke(re.hK,L,5,t.j.o,15,1),o=0,r=0;r<t.e.length;r++)for(n=t.e[r],e=ce.mm(t.j,n),t.g[n]=r,a=0;a<e;a++)ce.zm(t.j,n,a)>n&&(t.f[o++]=ce.Bm(t.j,n,a))},we._t=function(n,e){var o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j;for(g=n.a[e],G=n.b[e],i=Ke(re.cL,x,24,4,0,1),l=0,c=0;c<n.f.length&&!(l>=4);c++)e!=n.g[ce.Nj(n.j,0,n.f[c])]&&e!=n.g[ce.Nj(n.j,1,n.f[c])]&&(m=n.a[n.g[ce.Nj(n.j,0,n.f[c])]],b=n.b[n.g[ce.Nj(n.j,0,n.f[c])]],d=n.a[n.g[ce.Nj(n.j,1,n.f[c])]],y=n.b[n.g[ce.Nj(n.j,1,n.f[c])]],s=t.Math.sqrt((m-g)*(m-g)+(b-G)*(b-G)),u=t.Math.sqrt((d-g)*(d-g)+(y-G)*(y-G)),s<(r=t.Math.sqrt((d-m)*(d-m)+(y-b)*(y-b)))&&u<r?m==d?(a=t.Math.abs(g-m))<.5&&(i[l++]=new we.It(we.Kt(m,G,g,G),(.5-a)/2)):b==y?(a=t.Math.abs(G-b))<.5&&(i[l++]=new we.It(we.Kt(g,b,g,G),(.5-a)/2)):(j=(h=(y-b)/(d-m))*(p=(G-(w=-1/h)*g-(o=b-h*m))/(h-w))+o,(a=t.Math.sqrt((p-g)*(p-g)+(j-G)*(j-G)))<.5&&(i[l++]=new we.It(we.Kt(p,j,g,G),(.5-a)/2))):s<.5?i[l++]=new we.It(we.Kt(m,b,g,G),(.5-s)/2):u<.5&&(i[l++]=new we.It(we.Kt(d,y,g,G),(.5-u)/2)));l>0&&(f=we.rt(i,l),n.a[e]+=f.b*t.Math.sin(f.a),n.b[e]+=f.b*t.Math.cos(f.a))},we.au=function(n,e,o,r){var i,a,s;for(s=0;s<n.e.length;s++)a=t.Math.sqrt((n.a[s]-e)*(n.a[s]-e)+(n.b[s]-o)*(n.b[s]-o)),i=we.Kt(e,o,n.a[s],n.b[s])+r,n.a[s]=e+a*t.Math.sin(i),n.b[s]=o+a*t.Math.cos(i)},we.bu=function(t,n,e){var o;for(o=0;o<t.e.length;o++)t.a[o]+=n,t.b[o]+=e},we.cu=function(t,n,e){this.j=t,this.i=e,this.e=Ke(re.hK,L,5,n,15,1),this.k=Ke(re.hK,L,5,n,15,1),this.a=Ke(re.fK,ut,5,n,15,1),this.b=Ke(re.fK,ut,5,n,15,1)},we.du=function(t,n){var e,o;for(this.j=t.j,this.i=n,this.e=Ke(re.hK,L,5,t.e.length,15,1),this.k=Ke(re.hK,L,5,t.e.length,15,1),this.a=Ke(re.fK,ut,5,t.e.length,15,1),this.b=Ke(re.fK,ut,5,t.e.length,15,1),o=0;o<t.e.length;o++)this.e[o]=t.e[o],this.k[o]=t.k[o],this.a[o]=t.a[o],this.b[o]=t.b[o];if(null!=t.f)for(this.f=Ke(re.hK,L,5,t.f.length,15,1),e=0;e<t.f.length;e++)this.f[e]=t.f[e];if(null!=t.g)for(this.g=Ke(re.hK,L,5,t.g.length,15,1),e=0;e<t.g.length;e++)this.g[e]=t.g[e]},Te(31,1,{31:1},we.cu,we.du),a.c=0,a.i=0,re.gL=vo(31),we.eu=function(t){this.b=t},Te(127,1,{127:1},we.eu),a.a=0,re.hL=vo(127),Te(193,1,{}),re.iL=vo(193),ge.fu=function(t){},ge.gu=function(t){var n,e,o;for(n=0,e=0,o=0;o<t.g.a.length+t.f.a.length;o++)n+=ce.Jj(o<t.g.a.length?ue.Th(t.g,o):ue.Th(t.f,o-t.g.a.length))*(o<t.g.a.length?ue.Th(t.g,o):ue.Th(t.f,o-t.g.a.length)).p,e+=(o<t.g.a.length?ue.Th(t.g,o):ue.Th(t.f,o-t.g.a.length)).p;return 0!=e?e/n:1},ge.hu=function(t,n){var e,o,r,i;ge.fu(this),o=new me.$u(t);try{for(i=new Me.vP,ie.$R(i.a,"$RXN\n"),ie.$R(i.a,null!=n?n:""),ie.$R(i.a,"\n\n"),Me.uP(i,Dn+me.cv(t,11)),ie.$R(i.a,d),Me.uP(i,"  "+o.g.a.length+"  "+o.f.a.length+d),r=ge.gu(o),e=0;e<o.g.a.length+o.f.a.length;e++)ie.$R(i.a,"$MOL\n"),ce.Vo(new ce.Yo(e<o.g.a.length?ue.Th(o.g,e):ue.Th(o.f,e-o.g.a.length),r,null),i);this.a=i.a}catch(t){if(!Ue(t=Ze(t),13))throw We(t);ie.oS()}},Te(145,1,{},ge.hu),a.a=null,re.jL=vo(145),ge.iu=function(t){var n,e;return n=new me.Zu,e=new Me.pP(new Me.tP(t)),ge.ju(n,e),n},ge.ju=function(t,n){var e;if(!1,null==(e=Me.oP(n))||!ie.GR(le.V$(e).substr(0,4),"$RXN"))throw We(new ie.EG("'$RXN' tag not found"));return ie.GR(e,"$RXN V3000")?ge.lu(t,n,!1):ge.ku(t,n,!1)},ge.ku=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g;if(f=ie.TR(Me.oP(n)),0!=le.V$(f).length&&(t.e=f),Me.oP(n),o=Me.oP(n),!e&&ie.GR(le.V$(o).substr(0,13),Dn)&&(r=le.V$(o).substr(13),me.bv(r,t)))return!0;for(g=Me.oP(n),w=ie.CQ(ie.TR(le.V$(g).substr(0,3))),c=ie.CQ(ie.TR(le.V$(g).substr(3,3))),s=new ce.up,a=0;a<w;a++){if(null==(g=Me.oP(n))||!ie.GR(le.V$(g).substr(0,4),"$MOL"))throw We(new ie.EG(Fn));h=new ce.$r,u=new ie.aS;do{g=Me.oP(n),u.a+=""+g,u.a+=d}while(null!=g&&!ie.GR(le.V$(g).substr(0,6),gn));if(null==g)throw We(new ie.EG(Tn));ce.qp(s,h,new Me.pP(new Me.tP(u.a))),ue.Oh(t.g,h),t.d=-1}for(i=0;i<c;i++){if(null==(g=Me.oP(n))||!ie.GR(le.V$(g).substr(0,4),"$MOL"))throw We(new ie.EG(Fn));l=new ce.$r,u=new ie.aS;do{g=Me.oP(n),u.a+=""+g,u.a+=d}while(null!=g&&!ie.GR(le.V$(g).substr(0,6),gn));if(null==g)throw We(new ie.EG(Tn));ce.qp(s,l,new Me.pP(new Me.tP(u.a))),ue.Oh(t.f,l),t.d=-1}return!0},ge.lu=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g;if(f=ie.TR(Me.oP(n)),0!=le.V$(f).length&&(t.e=f),Me.oP(n),o=Me.oP(n),!e&&ie.GR(le.V$(o).substr(0,13),Dn)&&(r=le.V$(o).substr(13),me.bv(r,t)))return!0;if(g=Me.oP(n),a=new ce.up,null!=g&&ie.GR(le.V$(g).substr(0,13),"M  V30 COUNTS")){if(w=ie.TR(le.V$(g).substr(13)),l=ie.QR(w),h=ie.CQ(l[0]),c=ie.CQ(l[1]),h>0){if(g=Me.oP(n),ie.GR("M  V30 BEGIN REACTANT",g))for(i=0;i<h;i++){s=new ce.$r,(u=new ie.aS).a+=Bn;do{g=Me.oP(n),u.a+=""+g,u.a+=d}while(null!=g&&!ie.GR(le.V$(g).substr(0,15),$n));ce.qp(a,s,new Me.pP(new Me.tP(u.a))),ue.Oh(t.g,s),t.d=-1}g=Me.oP(n)}if(c>0&&(g=Me.oP(n),ie.GR("M  V30 BEGIN PRODUCT",g))){for(i=0;i<c;i++){s=new ce.$r,(u=new ie.aS).a+=Bn;do{g=Me.oP(n),u.a+=""+g,u.a+=d}while(null!=g&&!ie.GR(le.V$(g).substr(0,15),$n));ce.qp(a,s,new Me.pP(new Me.tP(u.a))),ue.Oh(t.f,s),t.d=-1}g=Me.oP(n)}return!0}return!1},ge.mu=function(t){},ge.nu=function(t){var n,e,o;for(n=0,e=0,o=0;o<t.g.a.length+t.f.a.length;o++)n+=ce.Jj(o<t.g.a.length?ue.Th(t.g,o):ue.Th(t.f,o-t.g.a.length))*(o<t.g.a.length?ue.Th(t.g,o):ue.Th(t.f,o-t.g.a.length)).p,e+=(o<t.g.a.length?ue.Th(t.g,o):ue.Th(t.f,o-t.g.a.length)).p;return 0!=e?n/e:1},ge.ou=function(t,n){var e,o,r,i,a,s;ge.mu(this),i=new me.$u(t);try{if(s=new Me.vP,ie.$R(s.a,"$RXN V3000\n"),ie.$R(s.a,null!=n?n:""),ie.$R(s.a,"\n\n"),Me.uP(s,Dn+me.cv(t,11)),ie.$R(s.a,d),r=i.g.a.length,o=i.f.a.length,ie.$R(s.a,le.V$(pn+r+" "+o+d).substr(r,r+o-r)),a=ge.nu(i),r>0){for(ie.$R(s.a,"M  V30 BEGIN REACTANT\n"),e=0;e<i.g.a.length;e++)Me.uP(s,ce.Ep(ue.Th(i.g,e),a));ie.$R(s.a,"M  V30 END REACTANT\n")}if(o>0){for(ie.$R(s.a,"M  V30 BEGIN PRODUCT\n"),e=0;e<i.f.a.length;e++)Me.uP(s,ce.Ep(ue.Th(i.f,e),a));ie.$R(s.a,"M  V30 END PRODUCT\n")}ie.$R(s.a,hn),this.a=s.a}catch(t){if(!Ue(t=Ze(t),13))throw We(t);ie.oS()}},Te(146,1,{},ge.ou),a.a=null,re.kL=vo(146),ge.qu=function(){ge.qu=De,ge.pu=Oe($e(re.uM,1),P,2,6,["Idorsia No","Actelion No","ID","IDNUMBER","COMPOUND_ID","NAME","COMPND"])},ge.ru=function(t){var n,e,o,r,i,a,s,u,f;if(!t.g)return!1;ie.AP(t.f),ie.AP(t.a),t.e=null,f=!1,e=-1,o=null,t.b=null==t.c?null:Ke(re.uM,P,2,t.c.length,6,1),t.d=-1;do{try{if(null==(u=Me.oP(t.g)))return ie.AP(t.f),!1}catch(n){if(Ue(n=Ze(n),78))return ie.AP(t.f),!1;throw We(n)}if(f)ie.gS(t.a,u),ie.cS(t.a,10);else{if(!ie.GR(le.V$(u).substr(0,1),">")){ie.gS(t.f,u),ie.cS(t.f,10),ie.GR(le.V$(u).substr(0,6),gn)&&(f=!0);continue}f=!0,ie.gS(t.f,gn),ie.cS(t.f,10),ie.gS(t.a,u),ie.cS(t.a,10)}if(null!=t.c)if(0==le.V$(u).length)e=-1;else if(-1==e){if(null!=(o=ge.tu(u))){for(e=-1,n=0;n<t.c.length;n++)if(ie.GR(o,t.c[n])){e=n;break}if(-1==t.d)for(a=0,s=(i=ge.pu).length;a<s;++a)if(r=i[a],ie.GR(o,r)){t.d=e;break}}}else null==t.b[e]?t.b[e]=u:t.b[e]=ie.ER(ie.ER(t.b[e],d),u)}while(!ie.GR(le.V$(u).substr(0,4),mn));return!0},ge.su=function(t,n){var e,o,r,i;for(i=0,o=new ce.fs;i<n;){try{r=Me.oP(t.g)}catch(t){if(Ue(t=Ze(t),78))break;throw We(t)}if(null==r)break;ie.GR(le.V$(r).substr(0,4),mn)&&++i,ie.GR(le.V$(r).substr(0,1),">")&&null!=(e=ge.tu(r))&&ce.es(o,e)}t.c=ue.fi(o.b,Ke(re.uM,P,2,0,6,1))},ge.tu=function(t){var n,e,o,r;if(0==le.V$(t).length||(le.S$(0,le.V$(t).length),62!=le.V$(t).charCodeAt(0)))return null;for(o=1,r=0,n=0;o<le.V$(t).length;){if(le.S$(o,le.V$(t).length),60==le.V$(t).charCodeAt(o)){if(0!=r)return null;r=o}else if(le.S$(o,le.V$(t).length),62==le.V$(t).charCodeAt(o)){if(0!=n)return null;n=o}++o}if(0!=r&&r<n)return le.V$(t).substr(r+1,n-(r+1));if(-1==(o=le.V$(t).indexOf("DT",1)))return null;for(e=o+2;Vo((le.S$(e,le.V$(t).length),le.V$(t).charCodeAt(e)));)++e;return e==o+2?null:le.V$(t).substr(o,e-o)},ge.uu=function(t,n){return null==t.b?null:t.b[n]},ge.vu=function(t){return null==t.c&&ge.su(t,10240),t.c},ge.wu=function(t,n){return null==t.c&&ge.su(t,n),t.c},ge.xu=function(t){return t.e||(t.e=ce.ap(new ce.up,t.f.a),t.e&&(null==t.e.N||0==le.V$(t.e.N).length)&&ce.El(t.e,-1!=t.d&&null!=t.b?t.b[t.d]:t.e?t.e.N:null)),t.e},ge.yu=function(t,n){ge.qu(),this.c=n,this.g=new Me.pP(t),this.f=new ie.kS,this.a=new ie.kS},Te(147,193,{},ge.yu),a.d=0,re.lL=vo(147),me.zu=function(t,n){ue.Oh(t.a,n)},me.Au=function(t,n,e){ue.Nh(t.a,e,n)},me.Bu=function(t,n){ue.Oh(t.f,n),t.d=-1},me.Cu=function(t,n,e){ue.Nh(t.f,e,n),t.d=-1},me.Du=function(t,n){ue.Oh(t.g,n),t.d=-1},me.Eu=function(t,n,e){ue.Nh(t.g,e,n),t.d=-1},me.Fu=function(t){t.g.a=Ke(re.nM,x,1,0,5,1),t.f.a=Ke(re.nM,x,1,0,5,1),t.a.a=Ke(re.nM,x,1,0,5,1),t.b=null,t.d=-1},me.Gu=function(t){var n,e;for(e=new ue.KW(t.g);e.a<e.c.a.length;)if(ue.JW(e).I)return!0;for(n=new ue.KW(t.f);n.a<n.c.a.length;)if(ue.JW(n).I)return!0;return!1},me.Hu=function(t){var n,e,o,r;for(e=0,n=0,o=0;o<t.g.a.length+t.f.a.length;o++)0!=(r=o<t.g.a.length?ue.Th(t.g,o):ue.Th(t.f,o-t.g.a.length)).p&&(e+=r.p,n+=ce.Kj(r,r.o,r.p,(ce.Li(),ce.Ki))*r.p);return 0==e?(ce.Li(),ce.Li(),ce.Ki):n/e},me.Iu=function(t,n){return ue.Th(t.a,n)},me.Ju=function(n){var e,o,r;if(-1!=n.d)return n.d;for(n.d=0,o=0;o<n.g.a.length+n.f.a.length;o++)for(r=o<n.g.a.length?ue.Th(n.g,o):ue.Th(n.f,o-n.g.a.length),e=0;e<r.o;e++)n.d<t.Math.abs(r.u[e])&&(n.d=t.Math.abs(r.u[e]));return n.d},me.Ku=function(t){var n,e,o,r;if(e=new me.Zu,0!=t.g.a.length){for(r=new ce.as(ue.Th(t.g,0)),n=1;n<t.g.a.length;n++)ce.Qi(r,ue.Th(t.g,n));ue.Oh(e.g,r),e.d=-1}if(0!=t.f.a.length){for(o=new ce.as(ue.Th(t.f,0)),n=1;n<t.f.a.length;n++)ce.Qi(o,ue.Th(t.f,n));ue.Oh(e.f,o),e.d=-1}return e},me.Lu=function(t,n){return n<t.g.a.length?ue.Th(t.g,n):ue.Th(t.f,n-t.g.a.length)},me.Mu=function(t){return t.g.a.length+t.f.a.length},me.Nu=function(t){return null==t.e?"":t.e},me.Ou=function(t,n){return ue.Th(t.f,n)},me.Pu=function(t,n){return ue.Th(t.g,n)},me.Qu=function(n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y;if(0==n.g.a.length||0==n.f.a.length)return null;if(0==(w=me.Ju(n)))return null;for(h=Ke(re.hK,Pt,6,n.f.a.length,0,2),a=0;a<n.f.a.length;a++)for(d=ue.Th(n.f,a),ce.Jr(d,15),h[a]=Ke(re.hK,L,5,w+1,15,1),ue.SW(h[a]),e=0;e<d.o;e++){if(0!=(c=t.Math.abs(d.u[e]))&&-1!=h[a][c])return null;h[a][c]=e}for(s=Ke(re.DN,ft,5,w+1,16,1),i=0;i<n.g.a.length;i++)for(y=ue.Th(n.g,i),ce.Jr(y,15),G=0;G<y.o;G++)if(0!=(c=t.Math.abs(y.u[G]))&&!s[c])for(u=0;u<n.f.a.length;u++)if(-1!=(g=h[u][c])){if(d=ue.Th(n.f,u),y.g[G]!=d.g[g]){s[c]=!0;break}if((3&y.s[G])!=(3&d.s[g])){s[c]=!0;break}for(f=0;f<y.g[G];f++)if(0==(o=ce.Aj(y,y.f[G][f])))s[c]=!0;else{for(b=y.i[G][f],r=!1,l=0;l<d.g[g];l++){if(0==(p=ce.Aj(d,d.f[g][l]))){s[c]=!0;break}if(p==o){if(r=!0,m=d.i[g][l],0!=(512&y.C[b])^0!=(512&d.C[m])||0==(512&y.C[b])&&(ce.Vj(y,b)!=ce.Vj(d,m)||(3&y.C[b])!=(3&d.C[m]))){s[c]=!0,s[o]=!0;break}break}}r||(s[c]=!0)}}return s},me.Ru=function(t){var n,e,o;for(e=new ue.KW(t.g);e.a<e.c.a.length;)if(0!=ue.JW(e).o)return!1;for(o=new ue.KW(t.f);o.a<o.c.a.length;)if(0!=ue.JW(o).o)return!1;for(n=new ue.KW(t.a);n.a<n.c.a.length;)if(0!=ue.JW(n).o)return!1;return!0},me.Su=function(t){return t.g.a.length+t.f.a.length==0?t.c:me.Gu(t)},me.Tu=function(n){var e,o,r,i,a,s,u,f,l,c,h;for(o=0,h=new ue.KW(n.g);h.a<h.c.a.length;)l=ue.JW(h),ce.Jr(l,1),o+=l.d;for(f=new ue.KW(n.f);f.a<f.c.a.length;)s=ue.JW(f),ce.Jr(s,1),o-=s.d;if(0!=o)return!1;for(a=me.Ju(n),r=Ke(re.DN,ft,5,a+1,16,1),c=new ue.KW(n.g);c.a<c.c.a.length;)for(l=ue.JW(c),e=0;e<l.d;e++){if(r[i=t.Math.abs(l.u[e])])return!1;r[i]=!0}for(u=new ue.KW(n.f);u.a<u.c.a.length;)for(s=ue.JW(u),ce.Jr(s,1),e=0;e<s.d;e++){if((i=t.Math.abs(s.u[e]))>=a||!r[i])return!1;r[i]=!1}return!0},me.Uu=function(t){var n,e,o,r;if(t.g.a.length+t.f.a.length<=1)return!1;for(n=me.Hu(t),r=Ke(re.NL,x,21,t.g.a.length+t.f.a.length,0,1),e=0;e<t.g.a.length+t.f.a.length;e++)if(r[e]=ce.$j(e<t.g.a.length?ue.Th(t.g,e):ue.Th(t.f,e-t.g.a.length),null),r[e]){for(o=0;o<e;o++)if(r[o]){if(r[e].c+r[e].b>=r[o].c&&r[e].c<=r[o].c+r[o].b)return!0;if(r[e].d+r[e].a>=r[o].d&&r[e].d<=r[o].d+r[o].a)return!0}if(0!=e&&r[e-1]){if(r[e].c-r[e-1].c-r[e].b>5*n)return!0;if(r[e].d-r[e-1].d-r[e].a>5*n)return!0}}return!1},me.Vu=function(t,n){t.b=n},me.Wu=function(t,n){var e,o,r;for(t.c=n,r=new ue.KW(t.g);r.a<r.c.a.length;)e=ue.JW(r),ce.yl(e,n);for(o=new ue.KW(t.f);o.a<o.c.a.length;)e=ue.JW(o),ce.yl(e,n)},me.Xu=function(t,n){t.e=n},me.Yu=function(n){var e,o,r,i,a,s,u,f,l;for(r=0;r<n.g.a.length;r++)for(l=ue.Th(n.g,r),i=0;i<l.o;i++)if(0!=(u=t.Math.abs(l.u[i]))){for(e=0,a=0;a<n.f.a.length;a++)for(f=ue.Th(n.f,a),s=0;s<f.o;s++)t.Math.abs(f.u[s])==u&&++e;if(0==e)l.u[i]=0;else if(e>1)throw We(new ie.EG("Duplicate mapping no in products"))}for(o=0;o<n.f.a.length;o++)for(f=ue.Th(n.f,o),i=0;i<f.o;i++)if(0!=(u=t.Math.abs(f.u[i]))){for(e=0,a=0;a<n.g.a.length;a++)for(l=ue.Th(n.g,a),s=0;s<l.o;s++)t.Math.abs(l.u[s])==u&&++e;if(0==e)f.u[i]=0;else if(e>1)throw We(new ie.EG("Duplicate mapping no in reactants"))}},me.Zu=function(){this.g=new ue.gi,this.f=new ue.gi,this.a=new ue.gi,this.d=-1,this.c=!1},me.$u=function(t){var n,e,o,r,i,a;for(me.Zu.call(this),a=t&&t.g?t.g.a.length:0,i=t&&t.f?t.f.a.length:0,n=t&&t.a?t.a.a.length:0,o=0;o<a;o++)ue.Oh(this.g,new ce.as(ue.Th(t.g,o)));for(r=0;r<i;r++)ue.Oh(this.f,new ce.as(ue.Th(t.f,r)));for(e=0;e<n;e++)ue.Oh(this.a,new ce.as(ue.Th(t.a,e)));this.b=new ce.Ai(t.b),null!=t.e&&(this.e=t.e),this.c=t.c},me._u=function(t,n){var e,o;for(me.Zu.call(this),o=0;o<n;o++)ue.Oh(this.g,t[o]);for(e=n;e<t.length;e++)ue.Oh(this.f,t[e]);this.c=me.Gu(this)},Te(40,1,Vt,me.Zu,me.$u,me._u),a.c=!1,a.d=0,re.mL=vo(40),me.av=function(t,n,e,o,r,i){var a,s,u,f,l,c,h,w,g,m,d,p,G,b,y;if(null==t||0==le.V$(t).length)return null;if(w=!1,l=0,p=0,s=0,-1==(y=ie.KR(t,Fo(33))))return null;for(me.Fu(i);-1!=l;)l>y&&(w=!0),u=ie.LR(t,Fo(32),l),!w&&(u>y||-1==u)&&(u=y),f=null,-1==u?(f=le.V$(t).substr(l),l=-1):(f=le.V$(t).substr(l,u-l),l=u+1),d=null,null!=n&&0!=le.V$(n).length&&(-1==(u=ie.LR(n,Fo(32),p))?d=le.V$(n).substr(p):(d=le.V$(n).substr(p,u-p),p=u+1)),a=null,null!=e&&0!=le.V$(e).length&&(-1==(u=ie.LR(e,Fo(32),s))?a=le.V$(e).substr(s):(a=le.V$(e).substr(s,u-s),s=u+1)),b=new ce.io(!0),G=null==f?null:ce.bo(b,le.F$((m=f,le.A$(),m)),null==a?null:le.F$(a)),null!=d&&ce.eo(b,le.F$((g=d,le.A$(),g))),w?(ue.Oh(i.f,G),i.d=-1):(ue.Oh(i.g,G),i.d=-1);if(null!=o&&0!=le.V$(o).length&&me.Vu(i,new ce.Bi(o)),null!=r&&0!=le.V$(r).length){for(b=new ce.io(!0),c=0,h=ie.KR(r,Fo(43));-1!=h;)me.zu(i,ce._n(b,le.V$(r).substr(c,h-c))),c=h+1,h=ie.LR(r,Fo(43),c);me.zu(i,ce._n(b,le.V$(r).substr(c)))}return i},me.bv=function(t,n){var e,o,r,i,a,s,u,f,l;return null==t?null:(s=t,f=null,u=null,l=null,a=null,-1==(e=ie.KR(t,Fo(35)))?s=t:(s=le.V$(t).substr(0,e),-1==(o=ie.LR(t,Fo(35),e+1))?f=le.V$(t).substr(e+1):(f=le.V$(t).substr(e+1,o-(e+1)),-1==(r=ie.LR(t,Fo(35),o+1))?u=le.V$(t).substr(o+1):(u=le.V$(t).substr(o+1,r-(o+1)),-1==(i=ie.LR(t,Fo(35),r+1))?l=le.V$(t).substr(r+1):(l=le.V$(t).substr(r+1,i-(r+1)),a=le.V$(t).substr(i+1))))),me.av(s,f,u,l,a,n))},me.cv=function(t,n){var e,o;return null==(o=me.dv(t,0==(16&n)))?null:(e=new ie.bS(o[0]),0!=n&&(e.a+="#",0!=(1&n)&&o.length>1&&null!=o[1]&&ie.$R(e,o[1])),0!=(n&=-2)&&(e.a+="#",0!=(2&n)&&o.length>2&&null!=o[2]&&ie.$R(e,o[2])),0!=(n&=-3)&&(e.a+="#",0!=(4&n)&&o.length>3&&null!=o[3]&&ie.$R(e,o[3])),0!=(n&=-5)&&(e.a+="#",0!=(8&n)&&o.length>4&&null!=o[4]&&ie.$R(e,o[4])),e.a)},me.dv=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p;if(!t||0==t.g.a.length||0==t.f.a.length)return null;for(f=Ke(re.uM,P,2,t.g.a.length+t.f.a.length,6,1),w=Ke(re.uM,P,2,t.g.a.length+t.f.a.length,6,1),r=Ke(re.uM,P,2,t.g.a.length+t.f.a.length,6,1),s=0;s<t.g.a.length+t.f.a.length;s++){if((d=s<t.g.a.length?ue.Th(t.g,s):ue.Th(t.f,s-t.g.a.length)).I&&s<t.g.a.length)for(e=0;e<d.o;e++)ce.fl(d,e,Yt,!1);if(o=new ce.Kf(d),f[s]=ce.of(o),null==f[s])return null;w[s]=ce.nf(o),r[s]=ce.mf(o,!0)}for(l=new ie.jS,i=new ie.jS,g=new ie.jS,u=0;u<t.g.a.length;u++){if(c=u,n)for(m="",c=-1,h=0;h<t.g.a.length;h++)ie.CR(m,f[h])<0&&(m=f[h],c=h);u>0&&(l.a+=" ",g.a+=" ",i.a+=" "),ie.gS(l,f[c]),ie.gS(g,w[c]),ie.gS(i,r[c]),f[c]=""}for(l.a+="!",g.a+=" ",i.a+=" ",a=t.g.a.length;a<t.g.a.length+t.f.a.length;a++){if(c=a,n)for(m="",c=-1,h=t.g.a.length;h<t.g.a.length+t.f.a.length;h++)ie.CR(m,f[h])<0&&(m=f[h],c=h);a>t.g.a.length&&(l.a+=" ",g.a+=" ",i.a+=" "),ie.gS(l,f[c]),ie.gS(g,w[c]),ie.gS(i,r[c]),f[c]=""}return(p=Ke(re.uM,P,2,5,6,1))[0]=l.a,le.V$(g.a).length>t.g.a.length+t.f.a.length-1&&(p[1]=g.a),le.V$(i.a).length>t.g.a.length+t.f.a.length-1&&(p[2]=i.a),t.b&&(p[3]=ce.zi(t.b)),0!=t.a.a.length&&(p[4]=me.ev(t)),p},me.ev=function(t){var n,e,o;for(o=new ie.jS,e=0;e<t.a.a.length;e++)0!=le.V$(o.a).length&&(o.a+="+"),n=new ce.Kf(ue.Th(t.a,e)),ie.gS(o,ce.of(n)),o.a+=" ",ie.gS(o,ce.mf(n,!0));return o.a},de.Gy=function(){de.Gy=De,de.Fy=(!de.SF&&(de.SF=new de.VF),de.SF),de.Ey=new ve.lP,de.Hv=Oe($e(re.uM,1),P,2,6,["?","H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr",Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,"R4","R5","R6","R7","R8","R9","R10","R11","R12","R13","R14","R15","R16","R1","R2","R3","A","A1","A2","A3",Lt,Lt,"D","T","X","R","H2","H+","Nnn","HYD","Pol",Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,Lt,"Ala","Arg","Asn","Asp","Cys","Gln","Glu","Gly","His","Ile","Leu","Lys","Met","Phe","Pro","Ser","Thr","Trp","Tyr","Val"]),de.Dy=Oe($e(re.CN,1),Vt,5,15,[0,1,4,7,9,11,12,14,16,19,20,23,24,27,28,31,32,35,40,39,40,45,48,51,52,55,56,59,58,63,64,69,74,75,80,79,84,85,88,89,90,93,98,0,102,103,106,107,114,115,120,121,130,127,132,133,138,139,140,141,142,0,152,153,158,159,164,165,166,169,174,175,180,181,184,187,192,193,195,197,202,205,208,209,0,0,0,0,0,0,232,0,238,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,156,114,115,103,128,129,57,137,113,113,128,131,147,97,87,101,186,163,99]),de.rv=Oe($e(re.uM,1),P,2,6,[An,Pn,Sn])},de.Hy=function(t,n,e,o){return{x:t,y:n,width:e,height:o}},de.Iy=function(t){var n;(n=new we.pt).f=new ue.OX(0),we.$s(n,t.a),ce.Nn(t.a)},de.Jy=function(){de.Ky.call(this,32,32,null)},de.Ky=function(t,n,e){de.Gy(),this.a=e||new ce._r(t,n)},de.Ly=function(t){de.Gy(),de.Ky.call(this,0,0,t)},de.nz=function(t,n){return{molecule:t,map:n}},de.Dz=function(t,n){var e;return de.Gy(),typeof n===Kn&&(n=!0),typeof n===b?(e=de.Fz(t,!1),!0===n&&e.inventCoordinates()):typeof n===j&&(e=de.Ez(t,n)),e},de.Ez=function(t,n){return new de.Ly(ce.ao(new ce.io(!1),t,n))},de.Fz=function(t,n){return new de.Ly(ce._n(new ce.io(n),t))},de.Gz=function(t){return de.Gy(),new de.Ly(ce.ap(new ce.up,t))},de.Hz=function(t){var n,e,o;return de.Gy(),(o=new ce.vp).f=null,e=ce.sp(o,new Me.pP(new Me.tP(t)))?o.f:null,n=null==o.d?ce.Lm(o.f):o.d,de.nz(new de.Ly(e),n)},de.Iz=function(t,n){de.Gy();var e=!(n=n||{}).noCoordinates,o=!n.noStereo;return de.Jz(t,e,o)},de.Jz=function(t,n,e){var o,r;return r=new de.Jy,ce.ur(new ce.zr,r.a,le.F$((o=t,le.A$(),o)),e),n&&de.Iy(r),r},de.Rz=function(t,n,e,o){return de.Gy(),ce.Wl(t,n,e,o)},de.Sz=function(t,n){return de.Gy(),ce.Xl(t,n)},de.qA=function(t){return de.Gy(),ce.Yl(t)},de.UA=function(){return de.Gy(),ce.Li(),ce.Li(),ce.Ki},de.ZB=function(t){return de.Gy(),ce.Zl(t)},de.$B=function(t){return de.Gy(),ce.$l(t)},de.wD=function(t){de.Gy(),ce.Li(),ce.Ki=t},Te(32,1,{32:1},de.Jy,de.Ky,de.Ly),a.addAtom=function(t){return ce.Ni(this.a,t)},a.addBond=function(t,n){return ce.Oi(this.a,t,n)},a.addFragment=function(t,n,e){ce._l(this.a,t.a,n,e)},a.tb=function(){he.As(this.a)},a.ub=function(t){he.Bs(this.a,t)},a.addImplicitHydrogens=function(t){void 0===t?this.tb():this.ub(t)},a.vb=function(){he.hs(),he.is(this.a,1)},a.wb=function(t){he.is(this.a,t)},a.addMissingChirality=function(t){void 0===t?this.vb():this.wb(t)},a.addMolecule=function(t){return ce.Qi(this.a,t.a)},a.addOrChangeAtom=function(t,n,e,o,r,i,a){return ce.Ri(this.a,t,n,e,o,r,i,a)},a.addOrChangeBond=function(t,n,e){return ce.Si(this.a,t,n,e)},a.addRing=function(t,n,e,o){return ce.Ti(this.a,t,n,e,o)},a.addRingToAtom=function(t,n,e){return ce.Ui(this.a,t,n,e)},a.addRingToBond=function(t,n,e){return ce.Vi(this.a,t,n,e)},a.addSubstituent=function(t,n){return ce.Wi(this.a,t.a,n)},a.calculateTorsion=function(t){return ce.Xi(this.a,t)},a.canonizeCharge=function(t){return ce.bm(this.a,t,!1)},a.changeAtom=function(t,n,e,o,r){return ce.Yi(this.a,t,n,e,o,r)},a.changeAtomCharge=function(t,n){return ce.Zi(this.a,t,n)},a.changeBond=function(t,n){return ce.$i(this.a,t,n)},a.clear=function(){ce._i(this.a)},a.convertStereoBondsToSingleBonds=function(t){ce.cm(this.a,t)},a.copyAtom=function(t,n,e,o){return ce.bj(this.a,t.a,n,e,o)},a.copyBond=function(t,n,e,o,r,i){return ce.dj(this.a,t.a,n,e,o,r,i)},a.copyMolecule=function(t){ce.ej(this.a,t.a)},a.copyMoleculeByAtoms=function(t,n,e,o){ce.dm(this.a,t.a,n,e,o)},a.copyMoleculeByBonds=function(t,n,e,o){return ce.em(this.a,t.a,n,e,o)},a.copyMoleculeProperties=function(t){ce.Ir(this.a,t.a)},a.deleteAtom=function(t){ce.gj(this.a,t)},a.deleteAtomOrBond=function(t,n){return ce.hj(this.a,t,n)},a.deleteAtoms=function(t){return ce.ij(this.a,t)},a.deleteBond=function(t){ce.jj(this.a,t)},a.deleteBondAndSurrounding=function(t){ce.kj(this.a,t)},a.deleteMarkedAtomsAndBonds=function(){return ce.lj(this.a)},a.deleteMolecule=function(){ce._i(this.a)},a.deleteSelectedAtoms=function(){return ce.mj(this.a)},a.ensureHelperArrays=function(t){ce.Jr(this.a,t)},a.findAlleneCenterAtom=function(t){return ce.gm(this.a,t)},a.findAlleneEndAtom=function(t,n){return ce.hm(this.a,t,n)},a.findAtom=function(t,n){return ce.nj(this.a,t,n)},a.findBINAPChiralityBond=function(t){return ce.im(this.a,t)},a.findBond=function(t,n){return ce.oj(this.a,t,n)},a.findRingSystem=function(t,n,e,o){ce.jm(this.a,t,n,e,o)},a.getAbsoluteAtomParity=function(t){return ce.Kr(this.a,t)},a.getAbsoluteBondParity=function(t){return ce.Lr(this.a,t)},a.getAllAtoms=function(){return this.a.o},a.getAllBonds=function(){return this.a.p},a.getAllConnAtoms=function(t){return ce.mm(this.a,t)},a.getAllConnAtomsPlusMetalBonds=function(t){return ce.nm(this.a,t)},a.getAllHydrogens=function(t){return ce.om(this.a,t)};a.getAromaticRingCount=function(){return ce.pm(this.a)},a.getAtomAbnormalValence=function(t){return ce.pj(this.a,t)},a.getAtomCIPParity=function(t){return ce.qj(this.a,t)},a.getAtomCharge=function(t){return ce.rj(this.a,t)},a.getAtomColor=function(t){return ce.sj(this.a,t)},a.getAtomCustomLabel=function(t){return ce.tj(this.a,t)},a.getAtomESRGroup=function(t){return ce.vj(this.a,t)},a.getAtomESRType=function(t){return ce.wj(this.a,t)},a.getAtomLabel=function(t){return ce.xj(this.a,t)},a.getAtomList=function(t){return ce.yj(this.a,t)},a.getAtomListString=function(t){return ce.zj(this.a,t)},a.getAtomMapNo=function(t){return ce.Aj(this.a,t)},a.getAtomMass=function(t){return ce.Bj(this.a,t)},a.getAtomParity=function(t){return ce.Cj(this.a,t)},a.getAtomPi=function(t){return ce.qm(this.a,t)},a.getAtomPreferredStereoBond=function(t){return ce.rm(this.a,t)},a.getAtomQueryFeatures=function(t){return ce.Dj(this.a,t)},a.getAtomRadical=function(t){return ce.Ej(this.a,t)},a.getAtomRingBondCount=function(t){return ce.sm(this.a,t)},a.getAtomRingCount=function(t,n){return ce.tm(this.a,t,n)},a.getAtomRingSize=function(t){return ce.um(this.a,t)},a.getAtomX=function(t){return ce.Fj(this.a,t)},a.getAtomY=function(t){return ce.Gj(this.a,t)},a.getAtomZ=function(t){return ce.Hj(this.a,t)},a.getAtomicNo=function(t){return ce.Ij(this.a,t)},a.getAtoms=function(){return this.a.d},a.getAverageBondLength=function(t){return ce.vm(this.a,t)},a.getAverageTopologicalAtomDistance=function(){return ce.wm(this.a)},a.getBond=function(t,n){return ce.xm(this.a,t,n)},a.getBondAngle=function(t,n){return ce.Mj(this.a,t,n)},a.getBondAtom=function(t,n){return ce.Nj(this.a,t,n)},a.getBondBridgeMaxSize=function(t){return ce.Oj(this.a,t)},a.getBondBridgeMinSize=function(t){return ce.Pj(this.a,t)},a.getBondCIPParity=function(t){return ce.Qj(this.a,t)},a.getBondESRGroup=function(t){return ce.Rj(this.a,t)},a.getBondESRType=function(t){return ce.Sj(this.a,t)},a.getBondLength=function(t){return ce.Tj(this.a,t)},a.getBondOrder=function(t){return ce.Vj(this.a,t)},a.getBondParity=function(t){return ce.Wj(this.a,t)},a.getBondPreferredStereoBond=function(t){return ce.Fn(this.a,t)},a.getBondQueryFeatures=function(t){return ce.Xj(this.a,t)},a.getBondRingSize=function(t){return ce.ym(this.a,t)},a.getBondType=function(t){return ce.Yj(this.a,t)},a.getBondTypeSimple=function(t){return ce.Zj(this.a,t)},a.getBonds=function(){return this.a.e},a.getBounds=function(){var t;return(t=ce.$j(this.a,de.Ey))?de.Hy(t.c,t.d,t.b,t.a):null},a.getCanonizedIDCode=function(t){var n;return n=new ce.Lf(this.a,t),ce.of(n)},a.getChiralText=function(){return ce.Mr(this.a)},a.getChirality=function(){return this.a.G},a.getCompactCopy=function(){return new de.Ly(ce.Nr(this.a))},a.getConnAtom=function(t,n){return ce.zm(this.a,t,n)},a.getConnAtoms=function(t){return ce.Am(this.a,t)},a.getConnBond=function(t,n){return ce.Bm(this.a,t,n)},a.getConnBondOrder=function(t,n){return ce.Cm(this.a,t,n)},a.getDefaultMaxValenceUncharged=function(t){return ce._j(this.a,t)},a.getDiastereotopicAtomIDs=function(){return he.js(this.a)},a.getElectronValenceCorrection=function(t,n){return ce.ak(this.a,t,n)},a.getExcludedNeighbourCount=function(t){return ce.Dm(this.a,t)},a.getExplicitHydrogens=function(t){return ce.Em(this.a,t)},a.getFisherProjectionParity=function(t,n,e,o){return ce.Gm(this.a,t,n,e,o)},a.getFragmentAtoms=function(t,n){return ce.Hm(this.a,t,n)},a.getFragmentNumbers=function(t,n,e){return ce.Im(this.a,t,n,e)},a.getFragments=function(){var t,n,e;for(t=ce.Pr(this.a),e=Ke(re.nL,x,32,t.length,0,1),n=0;n<t.length;n++)e[n]=new de.Ly(t[n]);return e},a.getFreeValence=function(t){return ce.Jm(this.a,t)},a.getHandleHydrogenMap=function(){return ce.Lm(this.a)},a.getHelperArrayStatus=function(){return this.a.R},a.getHoseCodes=function(t){var n=0|(typeof(t=t||{}).maxSphereSize===Kn?5:t.maxSphereSize),e=0|(typeof t.type===Kn?0:t.type);return he.ls(this.a,n,e)},a.getIDCode=function(){return ce.Rr(this.a)},a.getIDCodeAndCoordinates=function(){return{idCode:this.getIDCode(),coordinates:this.getIDCoordinates()}},a.getIDCoordinates=function(){return ce.Sr(this.a)},a.getImplicitHigherValence=function(t,n){return ce.Mm(this.a,t,n)},a.getImplicitHydrogens=function(t){return ce.Nm(this.a,t)},a.getIndex=function(){return ce.Jq(de.UF(de.Fy),this.a)},a.getLowestFreeValence=function(t){return ce.Om(this.a,t)},a.getMaxAtoms=function(){return this.a.K},a.getMaxBonds=function(){return this.a.L},a.getMaxValence=function(t){return ce.bk(this.a,t)},a.getMaxValenceUncharged=function(t){return ce.ck(this.a,t)},a.getMetalBondedConnAtoms=function(t){return ce.Pm(this.a,t)},a.getMolecularFormula=function(){return new de.OF(this.a)},a.getMoleculeColor=function(){return this.a.M},a.getMolweight=function(){return ce.Qm(this.a)},a.getName=function(){return this.a.N},a.getNonHydrogenNeighbourCount=function(t){return ce.Rm(this.a,t)},a.getNumberOfHydrogens=function(){return he.Cs(this.a)},a.getOCL=function(){return t.OCL},a.getOccupiedValence=function(t){return ce.Sm(this.a,t)},a.getPath=function(t,n,e,o,r){return ce.Tm(this.a,t,n,e,o,r)},a.getPathBonds=function(t,n,e){ce.Um(this.a,t,n,e)},a.getPathLength=function(t,n){return ce.Vm(this.a,t,n)},a.getRingSet=function(){return new de.QE(ce.Ym(this.a))},a.getRotatableBondCount=function(){return ce.Zm(this.a)},a.xb=function(n,e,o,r,i,a,s){var u,f,l,c,h,w,g,m;return l=de.WF(s),(f=new ce.hr(this.a,l,a)).F=o,ce.Nd(f,new ve.mP(0,0,n,e)),u=f.t,ce.Gd(f),m=ce.fr(f),r?(h=jo(io(t.Math.round(u.b+2*i))),c=jo(io(t.Math.round(u.a+2*i))),w=jo(io(t.Math.round(u.c-i))),g=jo(io(t.Math.round(u.d-i))),ie.PR(m,'width="'+h+'px" height="'+c+'px" viewBox="'+w+" "+g+" "+h+" "+c+'"')):m},a.getStereoBond=function(t){return ce._m(this.a,t)},a.getStereoCenterCount=function(){return ce.Tr(this.a)},a.getStereoProblem=function(t){return ce.ek(this.a,t)},a.getSubstituent=function(t,n,e,o,r){return ce.bn(this.a,t,n,e,o.a,r)},a.getSubstituentSize=function(t,n){return ce.cn(this.a,t,n)},a.getSymmetryRank=function(t){return ce.Ur(this.a,t)},a.getZNeighbour=function(t,n){return ce.dn(this.a,t,n)},a.invalidateHelperArrays=function(t){ce.hk(this.a,t)},a.inventCoordinates=function(){de.Iy(this)},a.is3D=function(){return ce.ik(this.a)},a.isAlkaliMetal=function(t){return ce.hn(this.a,t)},a.isAllylicAtom=function(t){return ce.jn(this.a,t)},a.isAmideTypeBond=function(t){return ce.kn(this.a,t)},a.isAromaticAtom=function(t){return ce.ln(this.a,t)},a.isAromaticBond=function(t){return ce.mn(this.a,t)},a.isAtomConfigurationUnknown=function(t){return ce.jk(this.a,t)},a.isAtomMarkedForDeletion=function(t){return ce.kk(this.a,t)},a.isAtomParityPseudo=function(t){return ce.lk(this.a,t)},a.isAtomStereoCenter=function(t){return ce.mk(this.a,t)},a.isAutoMappedAtom=function(t){return ce.nk(this.a,t)},a.isBINAPChiralityBond=function(t){return ce.nn(this.a,t)},a.isBondBackgroundHilited=function(t){return ce.ok(this.a,t)},a.isBondBridge=function(t){return ce.pk(this.a,t)},a.isBondForegroundHilited=function(t){return ce.qk(this.a,t)},a.isBondMarkedForDeletion=function(t){return ce.rk(this.a,t)},a.isBondParityPseudo=function(t){return ce.sk(this.a,t)},a.isBondParityUnknownOrNone=function(t){return ce.tk(this.a,t)},a.isChalcogene=function(t){return ce.pn(this.a,t)},a.isDelocalizedBond=function(t){return ce.qn(this.a,t)},a.isEarthAlkaliMetal=function(t){return ce.rn(this.a,t)},a.isElectronegative=function(t){return ce.uk(this.a,t)},a.isElectropositive=function(t){return ce.vk(this.a,t)},a.isFlatNitrogen=function(t){return ce.sn(this.a,t)},a.isFragment=function(){return this.a.I},a.isHalogene=function(t){return ce.tn(this.a,t)},a.isMarkedAtom=function(t){return ce.wk(this.a,t)},a.isMetalAtom=function(t){return ce.xk(this.a,t)},a.isNaturalAbundance=function(t){return ce.yk(this.a,t)},a.isNitrogenFamily=function(t){return ce.un(this.a,t)},a.isOrganicAtom=function(t){return ce.zk(this.a,t)},a.isPseudoRotatableBond=function(t){return ce.vn(this.a,t)},a.isPurelyOrganic=function(){return ce.Ak(this.a)},a.isRingAtom=function(t){return ce.wn(this.a,t)},a.isRingBond=function(t){return ce.xn(this.a,t)},a.isSelectedAtom=function(t){return ce.Bk(this.a,t)},a.isSelectedBond=function(t){return ce.Ck(this.a,t)},a.isSimpleHydrogen=function(t){return ce.yn(this.a,t)},a.isSmallRingAtom=function(t){return ce.zn(this.a,t)},a.isSmallRingBond=function(t){return ce.An(this.a,t)},a.isStabilizedAtom=function(t){return ce.Bn(this.a,t)},a.isStereoBond=function(t){return ce.Dk(this.a,t)},a.markAtomForDeletion=function(t){ce.Fk(this.a,t)},a.markBondForDeletion=function(t){ce.Gk(this.a,t)},a.normalizeAmbiguousBonds=function(){return ce.Cn(this.a)},a.removeAtomColors=function(){ce.Jk(this.a)},a.removeAtomCustomLabels=function(){this.a.r=null},a.removeAtomMarkers=function(){ce.Kk(this.a)},a.removeAtomSelection=function(){ce.Lk(this.a)},a.removeBondHiliting=function(){ce.Mk(this.a)},a.removeExplicitHydrogens=function(t){ce.Hn(this.a,t)},a.removeQueryFeatures=function(){return ce.Ok(this.a)},a.renumberESRGroups=function(t){return ce.Pk(this.a,t)},a.scaleCoords=function(t){ce.Qk(this.a,t)},a.setAllAtoms=function(t){ce.Rk(this.a,t)},a.setAllBonds=function(t){ce.Sk(this.a,t)},a.setAssignParitiesToNitrogen=function(t){ce.Vr(this.a,t)},a.setAtomAbnormalValence=function(t,n){ce.Tk(this.a,t,n)},a.setAtomCIPParity=function(t,n){ce.Uk(this.a,t,n)},a.setAtomCharge=function(t,n){ce.Vk(this.a,t,n)},a.setAtomColor=function(t,n){ce.Wk(this.a,t,n)},a.setAtomConfigurationUnknown=function(t,n){ce.Xk(this.a,t,n)},a.setAtomCustomLabel=function(t,n){ce.Yk(this.a,t,n)},a.setAtomESR=function(t,n,e){ce.$k(this.a,t,n,e)},a.setAtomList=function(t,n,e){ce.al(this.a,t,n,e)},a.setAtomMapNo=function(t,n,e){ce.bl(this.a,t,n,e)},a.setAtomMarker=function(t,n){ce.cl(this.a,t,n)},a.setAtomMass=function(t,n){ce.dl(this.a,t,n)},a.setAtomParity=function(t,n,e){ce.el(this.a,t,n,e)},a.setAtomQueryFeature=function(t,n,e){ce.fl(this.a,t,n,e)},a.setAtomRadical=function(t,n){ce.gl(this.a,t,n)},a.setAtomSelection=function(t,n){ce.hl(this.a,t,n)},a.setAtomX=function(t,n){ce.jl(this.a,t,n)},a.setAtomY=function(t,n){ce.kl(this.a,t,n)},a.setAtomZ=function(t,n){ce.ll(this.a,t,n)},a.setAtomicNo=function(t,n){ce.ml(this.a,t,n)},a.setBondAtom=function(t,n,e){ce.nl(this.a,t,n,e)},a.setBondBackgroundHiliting=function(t,n){ce.ol(this.a,t,n)},a.setBondCIPParity=function(t,n){ce.pl(this.a,t,n)},a.setBondESR=function(t,n,e){ce.ql(this.a,t,n,e)},a.setBondForegroundHiliting=function(t,n){ce.rl(this.a,t,n)},a.setBondOrder=function(t,n){ce.sl(this.a,t,n)},a.setBondParity=function(t,n,e){ce.tl(this.a,t,n,e)},a.setBondParityUnknownOrNone=function(t){ce.ul(this.a,t)},a.setBondQueryFeature=function(t,n,e){ce.vl(this.a,t,n,e)},a.setBondType=function(t,n){ce.wl(this.a,t,n)},a.setChirality=function(t){ce.xl(this.a,t)},a.setFragment=function(t){ce.yl(this.a,t)},a.setHelperValidity=function(t){ce.zl(this.a,t)},a.setHydrogenProtection=function(t){ce.Al(this.a,t)},a.setMaxAtoms=function(t){ce.Bl(this.a,t)},a.setMaxBonds=function(t){ce.Cl(this.a,t)},a.setMoleculeColor=function(t){ce.Dl(this.a,t)},a.setName=function(t){ce.El(this.a,t)},a.setParitiesValid=function(t){ce.Kn(this.a,t)},a.setStereoBondFromAtomParity=function(t){ce.Ln(this.a,t)},a.setStereoBondFromBondParity=function(t){ce.Mn(this.a,t)},a.setStereoBondsFromParity=function(){ce.Nn(this.a)},a.setToRacemate=function(){this.a.J=!0},a.setUnknownParitiesToExplicitlyUnknown=function(){ce.Wr(this.a)},a.shareSameFragment=function(t,n){return-1!=ce.Vm(this.a,t,n)},a.stripIsotopInfo=function(){return ce.Hl(this.a)},a.stripSmallFragments=function(t){return ce.On(this.a,t)},a.stripStereoInformation=function(){ce.Xr(this.a)},a.suggestBondType=function(t,n){return ce.Il(this.a,t,n)},a.supportsImplicitHydrogen=function(t){return ce.Pn(this.a,t)},a.swapAtoms=function(t,n){ce.Jl(this.a,t,n)},a.swapBonds=function(t,n){ce.Kl(this.a,t,n)},a.toIsomericSmiles=function(t){return ce.xo(new ce.Eo(this.a,t))},a.toMolfile=function(){return new ce.Wo(this.a).a.a},a.toMolfileV3=function(){return new ce.zp(this.a).a.a},a.toSVG=function(t,n,e,o){var r=(o=o||{}).factorTextSize||1,i=!0===o.autoCrop,a=typeof o.autoCropMargin===Kn?5:o.autoCropMargin,s=this.xb(t,n,r,i,a,e,o);return o.fontWeight&&(s=s.replace(/font-family=" Helvetica" /g,'font-family=" Helvetica" font-weight="'+o.fontWeight+nt)),o.strokeWidth&&(s=s.replace(/stroke-width="[^"]+"/g,at+o.strokeWidth+'"')),s},a.toSmiles=function(){return ce.kr(new ce.nr,this.a)},a.translateCoords=function(t,n){ce.Ll(this.a,t,n)},a.validate=function(){ce.Yr(this.a)},a.zoomAndRotate=function(t,n,e){ce.Nl(this.a,t,n,e)},a.zoomAndRotateInit=function(t,n){ce.Ol(this.a,t,n)},de.fv=32,de.gv=2,de.hv=4,de.iv=6,de.jv=64,de.kv=128,de.lv=1,de.mv=256,de.nv=8,de.ov=16,de.pv=Vn,de.qv=Vn,de.sv=Sn,de.tv=An,de.uv=Pn,de.vv=0,de.wv=3,de.xv=1,de.yv=2,de.zv=64,de.Av=384,de.Bv=448,de.Cv=192,de.Dv=256,de.Ev=0,de.Fv=320,de.Gv=128,de.Iv=1,de.Jv=2,de.Kv=4,de.Lv=0,de.Mv=3,de.Nv=1,de.Ov=6,de.Pv=2,de.Qv=1,de.Rv=2,de.Sv=bt,de.Tv=3,de.Uv=25,de.Vv=lt,de.Wv=St,de.Xv=pt,de.Yv=4,de.Zv=7,de.$v=dt,de._v=B,de.aw=Nn,de.bw=5,de.cw=17,de.dw=Ht,de.ew=Ct,de.fw=30,de.gw=128,de.hw=Ot,de.iw=$,de.jw=256,de.kw=Bt,de.lw=32768,de.mw=512,de.nw=It,de.ow=K,de.pw=16,de.qw=Gt,de.rw=T,de.sw=32,de.tw=vt,de.uw=64,de.vw=4,de.ww=8,de.xw=zt,de.yw=33554432,de.zw=Zt,de.Aw=3,de.Bw=14,de.Cw=Nt,de.Dw=At,de.Ew=3,de.Fw=22,de.Gw=120,de.Hw=4,de.Iw=3,de.Jw=2,de.Kw=Yt,de.Lw=D,de.Mw=Yt,de.Nw=an,de.Ow=30,de.Pw=Nn,de.Qw=48,de.Rw=32,de.Sw=0,de.Tw=16,de.Uw=4,de.Vw=48,de.Ww=1,de.Xw=0,de.Yw=3,de.Zw=2,de.$w=1,de._w=0,de.ax=3,de.bx=2,de.cx=2097151,de.dx=Rt,de.ex=2,de.fx=19,de.gx=It,de.hx=31,de.ix=5,de.jx=0,de.kx=kt,de.lx=8,de.mx=pt,de.nx=4,de.ox=7,de.px=7,de.qx=30720,de.rx=4,de.sx=11,de.tx=8,de.ux=2,de.vx=Bt,de.wx=16,de.xx=1572960,de.yx=21,de.zx=T,de.Ax=32,de.Bx=64,de.Cx=Dt,de.Dx=3,de.Ex=15,de.Fx=96,de.Gx=2,de.Hx=5,de.Ix=1572991,de.Jx=1,de.Kx=4,de.Lx=26,de.Mx=128,de.Nx=64,de.Ox=2,de.Px=9,de.Qx=127,de.Rx=32,de.Sx=1,de.Tx=4,de.Ux=17,de.Vx=458752,de.Wx=Mt,de.Xx=V,de.Yx=Bt,de.Zx=Ot,de.$x=K,de._x=196608,de.ay=0,de.by=327680,de.cy=6,de.dy=5,de.ey=32,de.fy=0,de.gy=1,de.hy=2,de.iy=8,de.jy=128,de.ky=1,de.ly=4,de.my=2,de.ny=32,de.oy=64,de.py=16,de.qy=252,de.ry=15,de.sy=1,de.ty=0,de.uy=7,de.vy=3,de.wy=47,de.xy=79,de.yy=31,de.zy=190,de.Ay=16,de.By=0,de.Cy=1,re.nL=vo(32),de._D=function(t){this.a=t},de.iE=function(){return new de._D(new me.Zu)},de.jE=function(t,n){var e,o;for(o=Ke(re.XK,p,23,t.length,0,1),e=0;e<t.length;e++)o[e]=t[e].a;return new de._D(new me._u(o,n))},de.kE=function(t){return new de._D(ge.iu(t))},de.lE=function(t){var n,e;return e=ce.vr(new ce.zr,le.F$((n=t,le.A$(),n))),new de._D(e)},Te(63,1,{},de._D),a.addCatalyst=function(t){me.zu(this.a,t.a)},a.addCatalystAt=function(t,n){me.Au(this.a,t.a,n)},a.addProduct=function(t){me.Bu(this.a,t.a)},a.addProductAt=function(t,n){me.Cu(this.a,t.a,n)},a.addReactant=function(t){me.Du(this.a,t.a)},a.addReactantAt=function(t,n){me.Eu(this.a,t.a,n)},a.clear=function(){me.Fu(this.a)},a.clone=function(){return new de._D(new me.$u(this.a))},a.getAverageBondLength=function(){return me.Hu(this.a)},a.getCatalyst=function(t){return new de.Ly(me.Iu(this.a,t))},a.getCatalysts=function(){return this.a.a.a.length},a.getHighestMapNo=function(){return me.Ju(this.a)},a.getMergedCopy=function(){return new de._D(me.Ku(this.a))},a.getMolecule=function(t){return new de.Ly(me.Lu(this.a,t))},a.getMolecules=function(){return me.Mu(this.a)},a.getName=function(){return me.Nu(this.a)},a.getOCL=function(){return t.OCL},a.getProduct=function(t){return new de.Ly(me.Ou(this.a,t))},a.getProducts=function(){return this.a.f.a.length},a.getReactant=function(t){return new de.Ly(me.Pu(this.a,t))},a.getReactants=function(){return this.a.g.a.length},a.getReactionCenterMapNos=function(){return me.Qu(this.a)},a.isEmpty=function(){return me.Ru(this.a)},a.isFragment=function(){return me.Su(this.a)},a.isPerfectlyMapped=function(){return me.Tu(this.a)},a.isReactionLayoutRequired=function(){return me.Uu(this.a)},a.removeCatalysts=function(){this.a.a.a=Ke(re.nM,x,1,0,5,1)},a.setFragment=function(t){me.Wu(this.a,t)},a.setName=function(t){me.Xu(this.a,t)},a.toRxn=function(t){var n;return(n=new ge.hu(this.a,t)).a?n.a.a:null},a.toRxnV3=function(t){var n;return(n=new ge.ou(this.a,t)).a?n.a.a:null},a.toSmiles=function(){return ce.Fo(this.a)},a.validateMapping=function(){me.Yu(this.a)},re.oL=vo(63),de.QE=function(t){this.a=t},Te(143,1,{},de.QE),a.determineAromaticity=function(t,n,e,o){ce.Ip(this.a,t,n,e,o)},a.getAtomIndex=function(t,n){return ce.Kp(this.a,t,n)},a.getAtomRingSize=function(t){return ce.Lp(this.a,t)},a.getBondIndex=function(t,n){return ce.Mp(this.a,t,n)},a.getBondRingSize=function(t){return ce.Np(this.a,t)},a.getHeteroPosition=function(t){return ce.Op(this.a,t)},a.getOCL=function(){return t.OCL},a.getRingAtoms=function(t){return ce.Pp(this.a,t)},a.getRingBonds=function(t){return ce.Qp(this.a,t)},a.getRingSize=function(t){return ce.Sp(this.a,t)},a.getSharedRing=function(t,n){return ce.Tp(this.a,t,n)},a.getSize=function(){return this.a.i.a.length},a.isAromatic=function(t){return ce.Up(this.a,t)},a.isAtomMember=function(t,n){return ce.Vp(this.a,t,n)},a.isBondMember=function(t,n){return ce.Wp(this.a,t,n)},a.isDelocalized=function(t){return ce.Xp(this.a,t)},a.qualifiesAsAmideTypeBond=function(t){return ce.Yp(this.a,t)},a.validateMemberIndex=function(t,n){return ce._p(this.a,t,n)},de.LE=7,de.ME=3,de.NE=7,de.OE=5,de.PE=1,re.pL=vo(143),de.hF=function(t,n){this.a=new ge.yu(new Me.tP(t),n)},Te(192,1,{},de.hF),a.getField=function(t){var n,e;for(e=ge.vu(this.a),n=0;n<e.length;n++)if(ie.GR(e[n],t))return ge.uu(this.a,n);return null},a.getFieldData=function(t){return ge.uu(this.a,t)},a.getFieldNames=function(t){return ge.wu(this.a,t)},a.getMolecule=function(){return new de.Ly(ge.xu(this.a))},a.getNextFieldData=function(){return this.a.a.a},a.getNextMolFile=function(){return this.a.f.a},a.getOCL=function(){return t.OCL},a.next=function(){return ge.ru(this.a)},re.qL=vo(192),de.qF=function(t){t.a=new ce.Dq},de.rF=function(t,n){ce.wq(t.a,n.a)},de.sF=function(t,n){ce.xq(t.a,n.a)},de.tF=function(){de.qF(this)},Te(194,1,{},de.tF),a.getOCL=function(){return t.OCL},a.isFragmentInMolecule=function(){return ce.rq(this.a)},a.setFragment=function(t){de.rF(this,t)},a.setMol=function(t,n){ce.xq(this.a,n.a),ce.wq(this.a,t.a)},a.setMolecule=function(t){de.sF(this,t)},re.sL=vo(194),de.zF=function(t){t.a=new ce.Rq},de.AF=function(){de.zF(this)},de.BF=function(t){return Ro(t)},de.DF=function(t){return ce.Sq(t)},de.EF=function(t){return ce.Tq(t)},de.FF=function(){return ce.Iq(),ce.Gq},de.HF=function(t,n){return ce.Uq(t,n)},de.IF=function(t,n){return ce.Vq(t,n)},Te(195,1,{},de.AF),a.createIndex=function(t){return ce.Jq(this.a,t.a)},a.getOCL=function(){return t.OCL},a.isFragmentInMolecule=function(){return ce.Mq(this.a)},a.setFragment=function(t,n){ce.Pq(this.a,t.a,n)},a.setMolecule=function(t,n){ce.Qq(this.a,t.a,n)},re.rL=vo(195),de.MF=function(){},de.NF=function(t,n){var e=0|(typeof(n=n||{}).maxSphereSize===Kn?5:n.maxSphereSize),o=0|(typeof n.type===Kn?0:n.type);return he.ns(t,e,o)},Te(196,1,{},de.MF),re.tL=vo(196),de.OF=function(t){ce.No(),ce.Ro.call(this,t)},Te(142,82,{82:1},de.OF),Fe(a,{absoluteWeight:{get:function(){return ce.Oo(this)}}}),Fe(a,{formula:{get:function(){return ce.Po(this)}}}),Fe(a,{relativeWeight:{get:function(){return ce.Qo(this)}}}),re.uL=vo(142),de.TF=function(t){},de.UF=function(t){return!t.a&&(t.a=new ce.Rq),t.a},de.VF=function(){de.TF(this)},Te(139,1,{},de.VF),a.a=null,de.SF=null,re.vL=vo(139),de.WF=function(t){if(!t)return 0;var n=0;return t.inflateToMaxAVBL&&(n|=K),t.inflateToHighResAVBL&&(n|=Ot),t.chiralTextBelowMolecule&&(n|=0),t.chiralTextAboveMolecule&&(n|=Bt),t.chiralTextOnFrameTop&&(n|=It),t.chiralTextOnFrameBottom&&(n|=786432),t.noTabus&&(n|=1),t.showAtomNumber&&(n|=2),t.showBondNumber&&(n|=4),t.highlightQueryFeatures&&(n|=8),t.showMapping&&(n|=16),t.suppressChiralText&&(n|=32),t.suppressCIPParity&&(n|=64),t.suppressESR&&(n|=128),t.showSymmetrySimple&&(n|=256),t.showSymmetryDiastereotopic&&(n|=512),t.showSymmetryEnantiotopic&&(n|=Gt),t.noImplicitAtomLabelColors&&(n|=Ct),t.noStereoProblem&&(n|=B),n},pe.XF=function(t,n){var e;return(e=t-n)>=gt?e-=wt:e<nn&&(e+=wt),e},pe.YF=function(t,n){var e;for(e=n;e<t.length;e++)if(62==t[e])return e;return-1},pe.$F=function(){pe.$F=De,pe.ZF=Oe($e(re.gK,1),Vt,5,15,[.29899999499320984,.5870000123977661,.11400000005960464])},pe._F=function(t,n){var e,o,r,i,a,s,u,f,l;if(e=He.OO(t),0==(s=t?(pe.ZF[0]*(t.c>>16&255)+pe.ZF[1]*(t.c>>8&255)+pe.ZF[2]*(255&t.c))/255:1))return new He.PO(s,s,s,e[3]);for(o=n/(t?(pe.ZF[0]*(t.c>>16&255)+pe.ZF[1]*(t.c>>8&255)+pe.ZF[2]*(255&t.c))/255:1),l=0,f=0,i=0;i<3;i++)e[i]*=o,e[i]<1?f+=pe.ZF[i]:(l+=(e[i]-1)*pe.ZF[i],e[i]=1);if(0!=l){for(u=0,a=0;a<3;a++)e[a]<1&&(e[a]+=l/f,e[a]>1&&(u+=(e[a]-1)*pe.ZF[a],e[a]=1));if(0!=u)for(r=0;r<3;r++)e[r]<1&&(e[r]+=u/pe.ZF[r],e[r]>1&&(e[r]=1))}return new He.PO(e[0],e[1],e[2],e[3])},pe.aG=function(n,e){var o,r,i,a,s,u,f,l,c,h,w;return pe.$F(),o=e?(pe.ZF[0]*(e.c>>16&255)+pe.ZF[1]*(e.c>>8&255)+pe.ZF[2]*(255&e.c))/255:1,s=n?(pe.ZF[0]*(n.c>>16&255)+pe.ZF[1]*(n.c>>8&255)+pe.ZF[2]*(255&n.c))/255:1,(i=t.Math.abs(o-s))>W?n:(u=Ke(re.gK,Vt,5,3,15,1),He.MO(),He.TO((e.c>>16&255)/255,(e.c>>8&255)/255,(255&e.c)/255,u),f=Ke(re.gK,Vt,5,3,15,1),He.TO((n.c>>16&255)/255,(n.c>>8&255)/255,(255&n.c)/255,f),(l=t.Math.abs(f[0]-u[0]))>.5&&(l=1-l),w=1-t.Math.max(f[1],u[1]),r=t.Math.abs(s+o-1),c=t.Math.cos(gt*l*3),i>(h=W*t.Math.max(w,t.Math.max(r,c)))?n:(a=s>o?s+h>1:s-h>0,pe._F(n,a?o-h:o+h)))},pe.bG=function(t,n){return pe.$F(),new He.RO(ze((t.c>>16&255)+W*((n.c>>16&255)-(t.c>>16&255))),ze((t.c>>8&255)+W*((n.c>>8&255)-(t.c>>8&255))),ze((255&t.c)+W*((255&n.c)-(255&t.c))))},pe.cG=function(t,n){var e;if(null==t)return null==n?0:1;if(null==n)return-1;for(e=0;e<t.length;e++){if(n.length==e)return 1;if(t[e]!=n[e])return t[e]<n[e]?-1:1}return n.length>t.length?-1:0},pe.dG=function(){},Te(149,1,Vt,pe.dG),a.kb=function(t,n){return pe.cG(t,n)},a.gb=function(t){return this===t},re.wL=vo(149),se.LG=function(t){ie.JG.call(this,t)},Te(163,67,R),re.AL=vo(163),ae.NG=function(){ae.NG=De,ae.MG=new Be},ae.OG=function(t){t.a=""},ae.PG=function(t){var n;null==t.c&&(n=_e(t.b)===_e(ae.MG)?null:t.b,t.d=null==n?k:Je(n)?ae.UG(n):Xe(n)?"String":ie.dQ(ie.yc(n)),t.a=t.a+": "+(Je(n)?ae.TG(n):n+""),t.c="("+t.d+") "+t.a)},ae.QG=function(t){return _e(t.b)===_e(ae.MG)?null:t.b},ae.RG=function(t){ae.NG(),ae.SG.call(this,t)},ae.SG=function(t){se.LG.call(this,t),ae.OG(this),this.b=t,this.a=""},ae.TG=function(t){return null==t?null:t.message},ae.UG=function(t){return null==t?null:t.name},Te(83,163,{83:1,4:1,13:1,20:1,17:1},ae.RG),a.Cb=function(){return ae.PG(this),this.c},a.Eb=function(){return ae.QG(this)},re.xL=vo(83),ae.eH=function(t,n){return t[n]},ae.fH=function(t){return t.length},ae.gH=function(t,n){t[t.length]=n},ae.hH=function(t,n){return t[n]},ae.iH=function(t){return t.length},ae.jH=function(){return Date.now?Date.now():(new Date).getTime()},Te(189,1,{}),re.zL=vo(189),se.nH=function(){se.nH=De,se.IH(),se.HH},se.oH=function(t,n,e){return t.apply(n,e)},se.pH=function(){var t;return 0!=To&&(t=ae.jH())-Bo>2e3&&(Bo=t,$o=se.wH()),0==To++&&(se.zH((se.yH(),se.xH)),!0)},se.rH=function(t,n,e){var o;o=se.pH();try{return se.oH(t,n,e)}finally{se.sH(o)}},se.sH=function(t){t&&se.AH((se.yH(),se.xH)),--To,t&&-1!=$o&&(se.uH($o),$o=-1)},se.tH=function(n){se.nH(),t.setTimeout((function(){throw n}),0)},se.uH=function(n){t.clearTimeout(n)},se.vH=function(){0!=To&&(To=0),$o=-1},se.wH=function(){return t.setTimeout(se.vH,10)};var To=0,Bo=0,$o=-1;function Po(t,n,e){var o,r;return(o=ie.AR(t,n++))>=55296&&o<=56319&&n<e&&function(t){return t>=56320&&t<=57343}((le.S$(n,le.V$(t).length),r=le.V$(t).charCodeAt(n)))?K+((1023&o)<<10)+(1023&r):o}function Ko(n){return n>=48&&n<48+t.Math.min(10,10)?n-48:n>=97&&n<97?n-97+10:n>=65&&n<65?n-65+10:-1}function Vo(t){return null!=String.fromCharCode(t).match(/\d/)}function Eo(t){return null!=String.fromCharCode(t).match(/[A-Z]/i)}function Oo(t,n,e){return function(t){if(!t)throw We(new ie.$Q)}(t>=0&&t<=1114111),t>=K?(n[e++]=55296+(t-K>>10&1023)&V,n[e]=56320+(t-K&1023)&V,2):(n[e]=t&V,1)}function Yo(t){return String.fromCharCode(t).toLowerCase().charCodeAt(0)}function Uo(t){var n;return(n=ie.BQ(t))>jn?1/0:n<-34028234663852886e22?-1/0:n}se.yH=function(){se.yH=De,se.xH=new se.BH},se.zH=function(t){var n,e;if(t.a){e=null;do{n=t.a,t.a=null,e=se.DH(n,e)}while(t.a);t.a=e}},se.AH=function(t){var n,e;if(t.b){e=null;do{n=t.b,t.b=null,e=se.DH(n,e)}while(t.b);t.b=e}},se.BH=function(){},se.CH=function(t,n){return!t&&(t=ae.aH()),ae.gH(t,n),t},se.DH=function(t,n){var e,o,r,i;for(o=0,r=ae.fH(t);o<r;o++){i=ae.eH(t,o);try{se.GH(i)?se.EH(i).ec()&&(n=se.CH(n,i)):se.FH(i).ec()}catch(t){if(!Ue(t=Ze(t),17))throw We(t);e=t,se.nH(),se.tH(Ue(e,83)?e.Eb():e)}}return n},Te(182,189,{},se.BH),re.BL=vo(182),se.EH=function(t){return t[0]},se.FH=function(t){return t[0]},se.GH=function(t){return t[1]},Ge.bI=function(t){return t.compatMode},Ge.cI=function(){return n},be.dI=function(){return["USD","US$",2,"US$","$"]},be.fI=function(){be.fI=De,be.eI=new be.hI},be.gI=function(t){return!t.a&&(t.a=new ye.CI),t.a},be.hI=function(){},Te(184,1,{},be.hI),re.GL=vo(184),be.iI=function(){be.iI=De,be.gI((be.fI(),be.fI(),be.eI))},be.jI=function(t){},be.kI=function(t,n){var e,o;for(n.a+="E",t.e<0&&(t.e=-t.e,n.a+="-"),e=""+t.e,o=le.V$(e).length;o<t.k;++o)n.a+="0";n.a+=e},be.lI=function(t,n,e){0==t.d&&(ie.iS(n,0,String.fromCharCode(48)),++t.b,++t.d),(t.b<t.d||t.c)&&(ie.iS(n,t.b,String.fromCharCode(e)),++t.d)},be.mI=function(t,n){var e,o;if(e=t.b+t.n,t.d<e)for(;t.d<e;)n.a+="0",++t.d;else{for((o=t.b+t.i)>t.d&&(o=t.d);o>e&&48==ie.AR(n.a,o-1);)--o;o<t.d&&(ie.hS(n,o,t.d),t.d=o)}},be.nI=function(t,n){var e,o;for(o=0;o<t.d-1&&48==ie.AR(n.a,o);)++o;o>0&&(n.a=ie.SR(n.a,0,0)+""+ie.RR(n.a,o),t.d-=o,t.e-=o),t.j>t.o&&t.j>0?(t.e+=t.b-1,(e=t.e%t.j)<0&&(e+=t.j),t.b=e+1,t.e-=e):(t.e+=t.b-t.o,t.b=t.o),1==t.d&&48==ie.AR(n.a,0)&&(t.e=0,t.b=t.o)},be.oI=function(t,n){var e,o,r,i;return isNaN(n)?"NaN":((o=n<0||0==n&&1/n<0)&&(n=-n),e=new ie.jS,isNaN(n)||isFinite(n)?(n*=t.p,i=be.BI(e,n),(r=le.V$(e.a).length+i+t.i+3)>0&&r<le.V$(e.a).length&&57==ie.AR(e.a,r)&&(be.wI(t,e,r-1),i+=le.V$(e.a).length-r,ie.hS(e,r,le.V$(e.a).length)),be.pI(t,o,e,i),e.a):(ie.gS(e,o?t.q:t.t),e.a+="∞",ie.gS(e,o?t.r:t.u),e.a))},be.pI=function(t,n,e,o){var r,i,a,s,u;t.g,le.S$(0,le.V$(".").length),i=le.V$(".").charCodeAt(0),le.S$(0,le.V$(",").length),a=le.V$(",").charCodeAt(0),t.e=0,t.d=le.V$(e.a).length,t.b=t.d+o,s=t.v,r=t.f,t.b>Gt&&(s=!0),s&&be.nI(t,e),be.vI(t,e),be.xI(t,e),be.qI(t,e,a,r),be.mI(t,e),be.lI(t,e,i),s&&be.kI(t,e),le.S$(0,le.V$("0").length),48!=(u=le.V$("0").charCodeAt(0))&&be.rI(e,u),ie.iS(e,0,n?t.q:t.t),ie.gS(e,n?t.r:t.u)},be.qI=function(t,n,e,o){var r;if(o>0)for(r=o;r<t.b;r+=o+1)ie.iS(n,t.b-r,String.fromCharCode(e)),++t.b,++t.d},be.rI=function(t,n){var e,o,r;for(r=le.V$(t.a).length,o=0;o<r;++o)(e=ie.AR(t.a,o))>=48&&e<=57&&ie.zP(t,o,e-48+n&V)},be.sI=function(t,n,e,o,r){var i,a,s,u;for(ie.hS(o,0,le.V$(o.a).length),a=!1,s=le.V$(n).length,u=e;u<s;++u)if(le.S$(u,le.V$(n).length),39!=(i=le.V$(n).charCodeAt(u)))if(a)o.a+=String.fromCharCode(i);else switch(i){case 35:case 48:case 44:case 46:case 59:return u-e;case 164:t.g=!0,u+1<s&&(le.S$(u+1,le.V$(n).length),164==le.V$(n).charCodeAt(u+1))?++u<s-2&&(le.S$(u+1,le.V$(n).length),164==le.V$(n).charCodeAt(u+1))&&(le.S$(u+2,le.V$(n).length),164==le.V$(n).charCodeAt(u+2))?(u+=2,ie.gS(o,je.GI(t.a))):ie.gS(o,je.DI(t.a)):ie.gS(o,je.EI(t.a));break;case 37:if(!r){if(1!=t.p)throw We(new ie._Q(En+n+'"'));t.p=100}o.a+="%";break;case 8240:if(!r){if(1!=t.p)throw We(new ie._Q(En+n+'"'));t.p=1e3}o.a+="‰";break;case 45:o.a+="-";break;default:o.a+=String.fromCharCode(i)}else u+1<s&&(le.S$(u+1,le.V$(n).length),39==le.V$(n).charCodeAt(u+1))?(++u,o.a+="'"):a=!a;return s-e},be.tI=function(t,n){var e,o;o=0,e=new ie.jS,o+=be.sI(t,n,o,e,!1),t.t=e.a,o+=be.uI(t,n,o,!1),o+=be.sI(t,n,o,e,!1),t.u=e.a,o<le.V$(n).length&&(le.S$(o,le.V$(n).length),59==le.V$(n).charCodeAt(o))?(++o,o+=be.sI(t,n,o,e,!0),t.q=e.a,o+=be.uI(t,n,o,!0),o+=be.sI(t,n,o,e,!0),t.r=e.a):(t.q="-"+t.t,t.r=t.u)},be.uI=function(t,n,e,o){var r,i,a,s,u,f,l,c,h,w,g;for(r=-1,i=0,g=0,a=0,u=-1,f=le.V$(n).length,h=e,l=!0;h<f&&l;++h)switch(le.S$(h,le.V$(n).length),le.V$(n).charCodeAt(h)){case 35:g>0?++a:++i,u>=0&&r<0&&++u;break;case 48:if(a>0)throw We(new ie._Q("Unexpected '0' in pattern \""+n+'"'));++g,u>=0&&r<0&&++u;break;case 44:u=0;break;case 46:if(r>=0)throw We(new ie._Q('Multiple decimal separators in pattern "'+n+'"'));r=i+g+a;break;case 69:if(!o){if(t.v)throw We(new ie._Q('Multiple exponential symbols in pattern "'+n+'"'));t.v=!0,t.k=0}for(;h+1<f&&(le.S$(h+1,le.V$(n).length),48==le.V$(n).charCodeAt(h+1));)++h,o||++t.k;if(!o&&i+g<1||t.k<1)throw We(new ie._Q('Malformed exponential pattern "'+n+'"'));l=!1;break;default:--h,l=!1}if(0==g&&i>0&&r>=0&&(0==(c=r)&&++c,a=i-c,i=c-1,g=1),r<0&&a>0||r>=0&&(r<i||r>i+g)||0==u)throw We(new ie._Q('Malformed pattern "'+n+'"'));return o||(w=i+g+a,t.i=r>=0?w-r:0,r>=0&&(t.n=i+g-r,t.n<0&&(t.n=0)),s=r>=0?r:w,t.o=s-i,t.v&&(t.j=i+t.o,0==t.i&&0==t.o&&(t.o=1)),t.f=u>0?u:0,t.c=0==r||r==w),h-e},be.vI=function(t,n){var e,o,r;if(t.b>t.d)for(;t.d<t.b;)n.a+="0",++t.d;if(!t.v)if(t.b<t.o){for(o=new ie.jS;t.b<t.o;)o.a+="0",++t.b,++t.d;ie.iS(n,0,o.a)}else if(t.b>t.o){for(r=t.b-t.o,e=0;e<r;++e)if(48!=ie.AR(n.a,e)){r=e;break}r>0&&(n.a=ie.SR(n.a,0,0)+""+ie.RR(n.a,r),t.d-=r,t.b-=r)}},be.wI=function(t,n,e){var o,r;for(o=!0;o&&e>=0;)57==(r=ie.AR(n.a,e))?ie.zP(n,e--,48):(ie.zP(n,e,r+1&V),o=!1);o&&(ie.iS(n,0,String.fromCharCode(49)),++t.b,++t.d)},be.xI=function(t,n){var e;t.d>t.b+t.i&&ie.xP(n,t.b+t.i)>=53&&(e=t.b+t.i-1,be.wI(t,n,e))},be.yI=function(t,n,e){if(be.jI(this),!n)throw We(new ie._Q("Unknown currency code"));this.s=t,this.a=n,be.tI(this,this.s),!e&&this.g&&(this.n=7&je.FI(this.a),this.i=this.n)},be.zI=function(t,n){be.iI(),be.yI.call(this,t,n,!0)},be.AI=function(t,n){return t.toPrecision(n)},be.BI=function(t,n){var e,o,r,i,a;return a=le.V$(t.a).length,ie.gS(t,be.AI(n,20)),i=0,(r=ie.LR(t.a,"e",a))<0&&(r=ie.LR(t.a,"E",a)),r>=0&&((o=r+1)<le.V$(t.a).length&&43==ie.AR(t.a,o)&&++o,o<le.V$(t.a).length&&(i=ie.CQ(ie.RR(t.a,o))),ie.hS(t,r,le.V$(t.a).length)),(e=ie.LR(t.a,".",a))>=0&&(t.a=ie.SR(t.a,0,e)+""+ie.RR(t.a,e+1),i-=le.V$(t.a).length-e),i},Te(129,1,{},be.zI),a.b=0,a.c=!1,a.d=0,a.e=0,a.f=3,a.g=!1,a.i=3,a.j=40,a.k=0,a.n=0,a.o=1,a.p=1,a.q="-",a.r="",a.t="",a.u="",a.v=!1,re.HL=vo(129),ye.CI=function(){},Te(186,1,{},ye.CI),re.IL=vo(186),je.DI=function(t){return t[0]},je.EI=function(t){return t[1]},je.FI=function(t){return t[2]},je.GI=function(t){return t[4]||t[1]},re.$I=function(t){var n,e,o;return n=t&en,e=t>>22&en,o=t<0?A:0,re.aJ(n,e,o)},re._I=function(t){return re.aJ(re.gJ(t),re.hJ(t),re.fJ(t))},re.aJ=function(t,n,e){return{l:t,m:n,h:e}},re.bJ=function(t,n,e){var o,r,i,a,s,u;if(0==re.gJ(n)&&0==re.hJ(n)&&0==re.fJ(n))throw We(new ie.EP("divide by zero"));if(0==re.gJ(t)&&0==re.hJ(t)&&0==re.fJ(t))return e&&(re.ZI=re.aJ(0,0,0)),re.aJ(0,0,0);if(re.fJ(n)==It&&0==re.hJ(n)&&0==re.gJ(n))return re.cJ(t,e);if(u=!1,re.fJ(n)>>19!=0&&(n=re.AJ(n),u=!u),a=re.lJ(n),i=!1,r=!1,o=!1,re.fJ(t)==It&&0==re.hJ(t)&&0==re.gJ(t)){if(r=!0,i=!0,-1!=a)return s=re.EJ(t,a),u&&re.jJ(s),e&&(re.ZI=re.aJ(0,0,0)),s;t=re._I((re.PJ(),re.LJ)),o=!0,u=!u}else re.fJ(t)>>19!=0&&(i=!0,t=re.AJ(t),o=!0,u=!u);return-1!=a?re.dJ(t,a,u,i,e):re.xJ(t,n)<0?(e&&(re.ZI=i?re.AJ(t):re.aJ(re.gJ(t),re.hJ(t),re.fJ(t))),re.aJ(0,0,0)):re.eJ(o?t:re.aJ(re.gJ(t),re.hJ(t),re.fJ(t)),n,u,i,r,e)},re.cJ=function(t,n){return re.fJ(t)==It&&0==re.hJ(t)&&0==re.gJ(t)?(n&&(re.ZI=re.aJ(0,0,0)),re._I((re.PJ(),re.NJ))):(n&&(re.ZI=re.aJ(re.gJ(t),re.hJ(t),re.fJ(t))),re.aJ(0,0,0))},re.dJ=function(t,n,e,o,r){var i;return i=re.EJ(t,n),e&&re.jJ(i),r&&(t=re.iJ(t,n),re.ZI=o?re.AJ(t):re.aJ(re.gJ(t),re.hJ(t),re.fJ(t))),i},re.eJ=function(t,n,e,o,r,i){var a,s,u;for(u=re.kJ(n)-re.kJ(t),a=re.DJ(n,u),s=re.aJ(0,0,0);u>=0&&(!re.uJ(t,a)||(u<22?re.nJ(s,u):u<44?re.oJ(s,u-22):re.mJ(s,u-44),0!=re.gJ(t)||0!=re.hJ(t)||0!=re.fJ(t)));)re.tJ(a),--u;return e&&re.jJ(s),i&&(o?(re.ZI=re.AJ(t),r&&(re.ZI=re.GJ(re.ZI,(re.PJ(),re.NJ)))):re.ZI=re.aJ(re.gJ(t),re.hJ(t),re.fJ(t))),s},re.fJ=function(t){return t.h},re.gJ=function(t){return t.l},re.hJ=function(t){return t.m},re.iJ=function(t,n){var e,o,r;return n<=22?(e=re.gJ(t)&(1<<n)-1,o=r=0):n<=44?(e=re.gJ(t),o=re.hJ(t)&(1<<n-22)-1,r=0):(e=re.gJ(t),o=re.hJ(t),r=re.fJ(t)&(1<<n-44)-1),re.aJ(e,o,r)},re.jJ=function(t){var n,e,o;n=1+~re.gJ(t)&en,e=~re.hJ(t)+(0==n?1:0)&en,o=~re.fJ(t)+(0==n&&0==e?1:0)&A,re.qJ(t,n),re.rJ(t,e),re.pJ(t,o)},re.kJ=function(t){var n,e;return 32==(e=Io(re.fJ(t)))?32==(n=Io(re.hJ(t)))?Io(re.gJ(t))+32:n+20-10:e-12},re.lJ=function(t){var n,e,o;return 0!=((e=re.gJ(t))&e-1)||0!=((o=re.hJ(t))&o-1)||0!=((n=re.fJ(t))&n-1)||0==n&&0==o&&0==e?-1:0==n&&0==o&&0!=e?Do(e):0==n&&0!=o&&0==e?Do(o)+22:0!=n&&0==o&&0==e?Do(n)+44:-1},re.mJ=function(t,n){t.h|=1<<n},re.nJ=function(t,n){t.l|=1<<n},re.oJ=function(t,n){t.m|=1<<n},re.pJ=function(t,n){t.h=n},re.qJ=function(t,n){t.l=n},re.rJ=function(t,n){t.m=n},re.sJ=function(t){return re.gJ(t)+re.hJ(t)*M+re.fJ(t)*v},re.tJ=function(t){var n,e,o;e=re.hJ(t),o=re.fJ(t),n=re.gJ(t),re.pJ(t,o>>>1),re.rJ(t,e>>>1|(1&o)<<21),re.qJ(t,n>>>1|(1&e)<<21)},re.uJ=function(t,n){var e,o,r;return!((r=re.fJ(t)-re.fJ(n))<0)&&(e=re.gJ(t)-re.gJ(n),!((r+=(o=re.hJ(t)-re.hJ(n)+(e>>22))>>22)<0)&&(re.qJ(t,e&en),re.rJ(t,o&en),re.pJ(t,r&A),!0))},re.vJ=function(t,n){var e,o,r;return e=re.gJ(t)+re.gJ(n),o=re.hJ(t)+re.hJ(n)+(e>>22),r=re.fJ(t)+re.fJ(n)+(o>>22),re.aJ(e&en,o&en,r&A)},re.wJ=function(t,n){return re.aJ(re.gJ(t)&re.gJ(n),re.hJ(t)&re.hJ(n),re.fJ(t)&re.fJ(n))},re.xJ=function(t,n){var e,o,r,i,a,s;return(a=re.fJ(t)>>19)!=(s=re.fJ(n)>>19)?s-a:(o=re.fJ(t))!=(i=re.fJ(n))?o-i:(e=re.hJ(t))!=(r=re.hJ(n))?e-r:re.gJ(t)-re.gJ(n)},re.yJ=function(t){var n,e,o,r,i;return isNaN(t)?(re.PJ(),re.OJ):t<-0x8000000000000000?(re.PJ(),re.MJ):t>=0x8000000000000000?(re.PJ(),re.LJ):(r=!1,t<0&&(r=!0,t=-t),o=0,t>=v&&(t-=(o=ze(t/v))*v),e=0,t>=M&&(t-=(e=ze(t/M))*M),n=ze(t),i=re.aJ(n,e,o),r&&re.jJ(i),i)},re.zJ=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b;return e=8191&re.gJ(t),o=re.gJ(t)>>13|(15&re.hJ(t))<<9,r=re.hJ(t)>>4&8191,i=re.hJ(t)>>17|(255&re.fJ(t))<<5,a=(1048320&re.fJ(t))>>8,d=o*(s=8191&re.gJ(n)),p=r*s,G=i*s,b=a*s,0!=(u=re.gJ(n)>>13|(15&re.hJ(n))<<9)&&(d+=e*u,p+=o*u,G+=r*u,b+=i*u),0!=(f=re.hJ(n)>>4&8191)&&(p+=e*f,G+=o*f,b+=r*f),0!=(l=re.hJ(n)>>17|(255&re.fJ(n))<<5)&&(G+=e*l,b+=o*l),0!=(c=(1048320&re.fJ(n))>>8)&&(b+=e*c),w=((m=e*s)>>22)+(d>>9)+((262143&p)<<4)+((31&G)<<17),g=(p>>18)+(G>>5)+((4095&b)<<8),w+=(h=(m&en)+((511&d)<<13))>>22,h&=en,g+=w>>22,w&=en,g&=A,re.aJ(h,w,g)},re.AJ=function(t){var n,e,o;return n=1+~re.gJ(t)&en,e=~re.hJ(t)+(0==n?1:0)&en,o=~re.fJ(t)+(0==n&&0==e?1:0)&A,re.aJ(n,e,o)},re.BJ=function(t){return re.aJ(~re.gJ(t)&en,~re.hJ(t)&en,~re.fJ(t)&A)},re.CJ=function(t,n){return re.aJ(re.gJ(t)|re.gJ(n),re.hJ(t)|re.hJ(n),re.fJ(t)|re.fJ(n))},re.DJ=function(t,n){var e,o,r;return(n&=63)<22?(e=re.gJ(t)<<n,o=re.hJ(t)<<n|re.gJ(t)>>22-n,r=re.fJ(t)<<n|re.hJ(t)>>22-n):n<44?(e=0,o=re.gJ(t)<<n-22,r=re.hJ(t)<<n-22|re.gJ(t)>>44-n):(e=0,o=0,r=re.gJ(t)<<n-44),re.aJ(e&en,o&en,r&A)},re.EJ=function(t,n){var e,o,r,i,a;return n&=63,(o=0!=((e=re.fJ(t))&It))&&(e|=-1048576),n<22?(a=e>>n,i=re.hJ(t)>>n|e<<22-n,r=re.gJ(t)>>n|re.hJ(t)<<22-n):n<44?(a=o?A:0,i=e>>n-22,r=re.hJ(t)>>n-22|e<<44-n):(a=o?A:0,i=o?en:0,r=e>>n-44),re.aJ(r&en,i&en,a&A)},re.FJ=function(t,n){var e,o,r,i;return n&=63,e=re.fJ(t)&A,n<22?(i=e>>>n,r=re.hJ(t)>>n|e<<22-n,o=re.gJ(t)>>n|re.hJ(t)<<22-n):n<44?(i=0,r=e>>>n-22,o=re.hJ(t)>>n-22|re.fJ(t)<<44-n):(i=0,r=0,o=e>>>n-44),re.aJ(o&en,r&en,i&A)},re.GJ=function(t,n){var e,o,r;return e=re.gJ(t)-re.gJ(n),o=re.hJ(t)-re.hJ(n)+(e>>22),r=re.fJ(t)-re.fJ(n)+(o>>22),re.aJ(e&en,o&en,r&A)},re.HJ=function(t){return re.xJ(t,(re.PJ(),re.OJ))<0?-re.sJ(re.AJ(t)):re.gJ(t)+re.hJ(t)*M+re.fJ(t)*v},re.IJ=function(t){return re.gJ(t)|re.hJ(t)<<22},re.JJ=function(t){var n,e,o,r,i;if(0==re.gJ(t)&&0==re.hJ(t)&&0==re.fJ(t))return"0";if(re.fJ(t)==It&&0==re.hJ(t)&&0==re.gJ(t))return"-9223372036854775808";if(re.fJ(t)>>19!=0)return"-"+re.JJ(re.AJ(t));for(e=t,o="";0!=re.gJ(e)||0!=re.hJ(e)||0!=re.fJ(e);){if(r=re.$I(On),e=re.bJ(e,r,!0),n=""+re.IJ(re.ZI),0!=re.gJ(e)||0!=re.hJ(e)||0!=re.fJ(e))for(i=9-le.V$(n).length;i>0;i--)n="0"+n;o=n+o}return o},re.KJ=function(t,n){return re.aJ(re.gJ(t)^re.gJ(n),re.hJ(t)^re.hJ(n),re.fJ(t)^re.fJ(n))},re.PJ=function(){re.PJ=De,re.LJ=re.aJ(en,en,524287),re.MJ=re.aJ(0,0,It),re.NJ=re.$I(1),re.$I(2),re.OJ=re.$I(0)},Ne.HO=function(){var t,n,e;for(n=Ge.bI(Ge.cI()),t=Oe($e(re.uM,1),P,2,6,[Yn]),e=0;e<t.length;e++)if(ie.GR(t[e],n))return;1==t.length&&ie.GR(Yn,t[0])&&ie.GR("BackCompat",n)},He.MO=function(){He.MO=De,He.LO=new He.RO(255,255,255),He.IO=He.LO,He.KO=new He.RO(128,128,128),He.JO=new He.RO(0,0,0)},He.NO=function(t){},He.OO=function(t){var n;return n=Ke(re.gK,Vt,5,4,15,1),null==t.b?(n[0]=(t.c>>16&255)/255,n[1]=(t.c>>8&255)/255,n[2]=(255&t.c)/255,n[3]=(t.c>>24&255)/255):(n[0]=t.b[0],n[1]=t.b[1],n[2]=t.b[2],n[3]=t.a),n},He.PO=function(t,n,e,o){He.MO(),He.SO.call(this,ze(255*t+.5),ze(255*n+.5),ze(255*e+.5),ze(255*o+.5)),this.b=Ke(re.gK,Vt,5,3,15,1),this.b[0]=t,this.b[1]=n,this.b[2]=e,this.a=o},He.QO=function(t){He.MO(),He.NO(this),this.c=Et|t},He.RO=function(t,n,e){He.MO(),He.SO.call(this,t,n,e,255)},He.SO=function(t,n,e,o){He.NO(this),this.c=(255&o)<<24|(255&t)<<16|(255&n)<<8|255&e},He.TO=function(n,e,o,r){var i,a,s,u,f,l;return He.MO(),s=0,l=0,i=0,f=t.Math.min(n,t.Math.min(e,o)),i=u=t.Math.max(n,t.Math.max(e,o)),0==(a=u-f)?(i=f,s=0,r[0]=s,r[1]=l,r[2]=i,r):0==u?(l=0,s=0,r[0]=s,r[1]=l,r[2]=i,r):(l=a/u,s=n==u?(e-o)/a:e==u?2+(o-n)/a:4+(n-e)/a,(s*=60)<0&&(s+=360),r[0]=s/360,r[1]=l,r[2]=i,r)},Te(27,1,{},He.PO,He.QO,He.RO),a.a=0,a.b=null,a.c=0,re.JL=vo(27),He.WO=function(){He.WO=De,He.VO=Oe($e(re.fK,1),ut,5,15,[5.55,15,15,15,15,15,15,15,15,Un,Un,Un,Un,Un,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,Un,Un,7.1,Ln,Ln,17.78,qn,3.82,6.66,6.66,7.78,11.68,Un,6.66,Un,Un,Ln,Ln,Ln,Ln,Ln,Ln,Ln,Ln,Ln,Ln,Un,Un,11.68,11.68,11.68,Ln,20.3,qn,qn,Jn,Jn,qn,12.22,15.56,Jn,Un,10,qn,Ln,16.66,Jn,15.56,qn,15.56,Jn,qn,12.22,Jn,qn,18.88,qn,qn,12.22,Un,Un,Un,9.38,Ln,6.66,Ln,Ln,10,Ln,Ln,Un,Ln,Ln,4.44,4.44,10,4.44,16.66,Ln,Ln,Ln,Ln,6.66,10,Un,Ln,10,Jn,10,10,10,6.68,5.2,6.68,11.68,10.5])},He.XO=function(t,n){var e,o,r,i;if(ie.GR(t.a,"Helvetica")){for(i=0,o=0,r=le.V$(n).length;o<r;o++)le.S$(o,le.V$(n).length),i+=((e=le.V$(n).charCodeAt(o))<128?He.VO[e]:Un)*t.b/20;return i}return He.YO(t,n)},He.YO=function(t,e){var o=He.UO;o||(o=n.createElement("canvas"),He.UO=o);var r=t.b+"px "+t.a,i=o.getContext("2d");return i.font=r,(e=i.measureText(e)).width},He.ZO=function(t){He.WO(),this.a="Helvetica",this.b=t},Te(124,1,{},He.ZO),a.b=0,He.UO=null,re.KL=vo(124),Te(116,1,{116:1}),a.gb=function(t){var n;return this===t||(Ue(t,43)?(n=t,this.a==n.a&&this.b==n.b):this===t)},a.ib=function(){return 37*ze(this.a+this.b)},re.ML=vo(116),ve.aP=function(){},ve.bP=function(t,n){this.a=t,this.b=n},Te(43,116,{116:1,43:1,4:1},ve.aP,ve.bP),a.a=0,a.b=0,re.LL=vo(43),ve.cP=function(t,n){return ve.fP(t,n.c,n.d,n.b,n.a)},ve.dP=function(t,n,e,o,r){var i;o<n&&(i=n,n=o,o=i),r<e&&(i=e,e=r,r=i),ve.kP(t,n,e,o-n,r-e)},Te(91,1,{144:1,91:1}),re.PL=vo(91),ve.eP=function(t,n,e){var o,r;return o=t.c,r=t.d,n>=o&&e>=r&&n<o+t.b&&e<r+t.a},ve.fP=function(t,n,e,o,r){var i,a;return!(t.b<=0||t.a<=0||o<=0||r<=0)&&(i=t.c,a=t.d,n>=i&&e>=a&&n+o<=i+t.b&&e+r<=a+t.a)},ve.iP=function(n,e,o){var r,i,a,s;r=t.Math.min(n.c,e.c),a=t.Math.min(n.d,e.d),i=t.Math.max(n.c+n.b,e.c+e.b),s=t.Math.max(n.d+n.a,e.d+e.a),ve.dP(o,r,a,i,s)},Te(106,91,{144:1,106:1,91:1}),a.gb=function(t){var n;return t===this||!!Ue(t,21)&&(n=t,this.c==n.c&&this.d==n.d&&this.b==n.b&&this.a==n.a)},a.ib=function(){var t;return t=to(t=xo(this.c),co(xo(this.d),37)),t=to(t,co(xo(this.b),43)),jo(t=to(t,co(xo(this.a),47)))^jo(po(t,32))},re.OL=vo(106),ve.jP=function(t,n){var e;return e=new ve.lP,ve.iP(t,n,e),e},ve.kP=function(t,n,e,o,r){t.c=n,t.d=e,t.b=o,t.a=r},ve.lP=function(){},ve.mP=function(t,n,e,o){ve.kP(this,t,n,e,o)},Te(21,106,{144:1,106:1,21:1,91:1},ve.lP,ve.mP),a.a=0,a.b=0,a.c=0,a.d=0,re.NL=vo(21),Te(210,1,{}),re.UL=vo(210),Me.nP=function(t){var n;return n=-1,-2!=t.a?(n=t.a,t.a=-2):n=Me.sP(t.b),n},Me.oP=function(t){var n,e,o;if(-1==(e=Me.nP(t)))return null;for(o=new ie.jS,n=!1;!n;)if(10==e?n=!0:13==e&&(n=!0,10!=(e=Me.nP(t))&&(t.a=e)),!n){if(-1==e)break;ie.cS(o,e&V),e=Me.nP(t)}return o.a},Me.pP=function(t){this.b=t,this.a=-2},Te(51,210,{},Me.pP),a.a=0,re.QL=vo(51),Te(191,1,{}),re.SL=vo(191),Te(190,191,{}),re.RL=vo(190),Me.qP=function(){},Te(138,190,{},Me.qP),re.TL=vo(138),Me.sP=function(t){return t.a==le.V$(t.b).length?-1:ie.AR(t.b,t.a++)},Me.tP=function(t){this.b=t,this.a=0},Te(50,210,{},Me.tP),a.a=0,re.VL=vo(50),Te(211,1,{}),re.XL=vo(211),Me.uP=function(t,n){ie.$R(t.a,n)},Me.vP=function(){this.a=new ie._R},Te(120,211,{},Me.vP),a.jb=function(){return this.a.a},re.WL=vo(120),ie.xP=function(t,n){return ie.AR(t.a,n)},ie.yP=function(t,n,e,o){t.a=ie.SR(t.a,0,n)+""+o+ie.RR(t.a,e)},ie.zP=function(t,n,e){ie.yP(t,n,n+1,String.fromCharCode(e))},ie.AP=function(t){var n;0<(n=le.V$(t.a).length)?t.a=ie.SR(t.a,0,0):0>n&&(t.a+=ie.XR(Ke(re.eK,Vt,5,-n,15,1)))},ie.BP=function(t){return t.a},ie.CP=function(t){this.a=t},Te(61,1,{104:1}),a.jb=function(){return ie.BP(this)},re.YL=vo(61),ie.EP=function(t){ie.HG.call(this,t)},Te(66,20,R,ie.EP),re.ZL=vo(66),ie.NQ=function(){ie.NQ=De,ie.MQ=Oe($e(re.fK,1),ut,5,15,[13407807929942597e138,1157920892373162e62,3402823669209385e23,0x10000000000000000,Qn,K,256,16,4,2]),ie.LQ=Oe($e(re.fK,1),ut,5,15,[7458340731200207e-170,8636168555094445e-93,2938735877055719e-54,5.421010862427522e-20,2.3283064365386963e-10,Xn,.00390625,.0625,.25,.5])},ie.pR=function(){ie.pR=De,ie.oR=Ke(re.hM,C,36,256,0,1)},ie.qR=function(t){ie.HG.call(this,t)},Te(183,20,R,ie.qR),re.jM=vo(183),ie.vR=function(t){ie._Q.call(this,t)},Te(42,26,R,ie.vR),re.lM=vo(42),ie.wR=function(t,n,e){this.a=G,this.d=t,this.b=n,this.c=e},Te(49,1,{4:1,49:1},ie.wR),a.gb=function(t){var n;return!!Ue(t,49)&&(n=t,this.c==n.c&&this.d==n.d&&this.a==n.a&&this.b==n.b)},a.ib=function(){return ue.YW(Oe($e(re.nM,1),x,1,5,[ie.nR(this.c),this.a,this.d,this.b]))},a.jb=function(){return this.a+"."+this.d+"("+(null!=this.b?this.b:"Unknown Source")+(this.c>=0?":"+this.c:"")+")"},a.c=0,re.pM=vo(49),ie.ZR=function(t,n){return t.a+=n,t},ie.$R=function(t,n){return t.a+=""+n,t},ie._R=function(){ie.CP.call(this,"")},ie.aS=function(){ie.CP.call(this,"")},ie.bS=function(t){ie.CP.call(this,(le.M$(t),t))},Te(45,61,{104:1},ie._R,ie.aS,ie.bS),re.qM=vo(45),ie.cS=function(t,n){return t.a+=String.fromCharCode(n),t},ie.dS=function(t,n){return t.a+=n,t},ie.eS=function(t,n){return t.a+=n,t},ie.fS=function(t,n){return t.a+=""+n,t},ie.gS=function(t,n){return t.a+=""+n,t},ie.hS=function(t,n,e){return t.a=ie.SR(t.a,0,n)+""+ie.RR(t.a,e),t},ie.iS=function(t,n,e){return t.a=ie.SR(t.a,0,n)+""+e+ie.RR(t.a,n),t},ie.jS=function(){ie.CP.call(this,"")},ie.kS=function(){ie.CP.call(this,"")},ie.lS=function(t){ie.CP.call(this,(le.M$(t),t))},Te(22,61,{104:1},ie.jS,ie.kS,ie.lS),re.rM=vo(22),ie.oS=function(){ie.oS=De,ie.nS=new Me.qP},ie.pS=function(t,n,e,o,r){var i,a;if(ie.oS(),le.N$(t,"src"),le.N$(e,"dest"),ie.yc(t),ie.yc(e),a=le.V$(t).length,i=le.V$(e).length,n<0||o<0||r<0||n+r>a||o+r>i)throw We(new ie.FP);r>0&&le.v$(t,n,e,o,r,!0)},Te(260,1,{}),Ae.BS=function(){var t,n,e;for(Ae.BS=De,new Ae.KS(1,0),new Ae.KS(10,0),new Ae.KS(0,0),Ae.tS=Ke(re.yM,C,12,11,0,1),Ae.uS=Ke(re.eK,Vt,5,100,15,1),Ae.vS=Oe($e(re.fK,1),ut,5,15,[1,5,25,125,625,3125,15625,78125,390625,1953125,9765625,48828125,244140625,1220703125,6103515625,30517578125,152587890625,762939453125,3814697265625,19073486328125,95367431640625,476837158203125,0x878678326eac9]),Ae.wS=Ke(re.hK,L,5,Ae.vS.length,15,1),Ae.xS=Oe($e(re.fK,1),ut,5,15,[1,10,100,1e3,E,1e5,1e6,1e7,1e8,On,1e10,1e11,1e12,1e13,1e14,1e15,1e16]),Ae.yS=Ke(re.hK,L,5,Ae.xS.length,15,1),Ae.zS=Ke(re.yM,C,12,11,0,1),t=0;t<Ae.zS.length;t++)Ae.tS[t]=new Ae.KS(re.SN(t),0),Ae.zS[t]=new Ae.KS(0,t),Ae.uS[t]=48;for(;t<Ae.uS.length;t++)Ae.uS[t]=48;for(e=0;e<Ae.wS.length;e++)Ae.wS[e]=Ae.NS(Ae.vS[e]);for(n=0;n<Ae.yS.length;n++)Ae.yS[n]=Ae.NS(Ae.xS[n]);Ae.iU()},Ae.CS=function(n,e){var o,r,i,a,s,u;return(i=Ae.GS(n))==(u=Ae.GS(e))?n.e==e.e&&n.a<54&&e.a<54?n.f<e.f?-1:n.f>e.f?1:0:(r=n.e-e.e,(o=(n.d>0?n.d:t.Math.floor((n.a-1)*_n)+1)-(e.d>0?e.d:t.Math.floor((e.a-1)*_n)+1))>r+1?i:o<r-1?-i:(!n.c&&(n.c=Ae.FT(n.f)),a=n.c,!e.c&&(e.c=Ae.FT(e.f)),s=e.c,r<0?a=Ae.kT(a,Ae.rU(-r)):r>0&&(s=Ae.kT(s,Ae.rU(r))),Ae.dT(a,s))):i<u?-1:1},Ae.DS=function(t,n){var e,o,r,i,a,s,u,f;if(e=0,a=0,i=le.V$(n).length,s=null,le.V$(n),f=new ie.kS,a<i&&(le.S$(a,le.V$(n).length),43==le.V$(n).charCodeAt(a))&&(++e,++a<i&&(le.S$(a,le.V$(n).length),43==le.V$(n).charCodeAt(a)||(le.S$(a,le.V$(n).length),45==le.V$(n).charCodeAt(a)))))throw We(new ie.vR(I+n+'"'));for(;a<i&&(le.S$(a,le.V$(n).length),46!=le.V$(n).charCodeAt(a))&&(le.S$(a,le.V$(n).length),101!=le.V$(n).charCodeAt(a))&&(le.S$(a,le.V$(n).length),69!=le.V$(n).charCodeAt(a));)++a;if(f.a+=""+ie.SR(null==n?k:(le.M$(n),n),e,a),a<i&&(le.S$(a,le.V$(n).length),46==le.V$(n).charCodeAt(a))){for(e=++a;a<i&&(le.S$(a,le.V$(n).length),101!=le.V$(n).charCodeAt(a))&&(le.S$(a,le.V$(n).length),69!=le.V$(n).charCodeAt(a));)++a;t.e=a-e,f.a+=""+ie.SR(null==n?k:(le.M$(n),n),e,a)}else t.e=0;if(a<i&&(le.S$(a,le.V$(n).length),101==le.V$(n).charCodeAt(a)||(le.S$(a,le.V$(n).length),69==le.V$(n).charCodeAt(a)))&&(e=++a,a<i&&(le.S$(a,le.V$(n).length),43==le.V$(n).charCodeAt(a))&&++a<i&&(le.S$(a,le.V$(n).length),45!=le.V$(n).charCodeAt(a))&&++e,s=le.V$(n).substr(e,i-e),t.e=t.e-ie.CQ(s),t.e!=ze(t.e)))throw We(new ie.vR("Scale out of range."));if(u=f.a,le.V$(u).length<16){if(t.f=(null==Ae.AS&&(Ae.AS=new RegExp("^[+-]?\\d*$","i")),Ae.AS.test(u)?parseInt(u,10):NaN),isNaN(t.f))throw We(new ie.vR(I+n+'"'));t.a=Ae.NS(t.f)}else Ae.FS(t,new Ae.wT(u));for(t.d=le.V$(f.a).length,r=0;r<le.V$(f.a).length&&(45==(o=ie.AR(f.a,r))||48==o);++r)--t.d;0==t.d&&(t.d=1)},Ae.ES=function(t,n){var e;return le.M$(n),0==(e=2-t.e)?t:e>0?e<Ae.xS.length&&t.a+Ae.yS[ze(e)]<54?new Ae.JS(t.f*Ae.xS[ze(e)]):new Ae.MS(Ae.oU((!t.c&&(t.c=Ae.FT(t.f)),t.c),ze(e))):t.a<54&&-e<Ae.xS.length?Ae.RS(t.f,Ae.xS[ze(-e)],n):Ae.QS((!t.c&&(t.c=Ae.FT(t.f)),t.c),Ae.rU(-e),n)},Ae.FS=function(t,n){var e;t.c=n,t.a=Ae.HT(n),t.a<54&&(t.f=(e=n.d>1?go(mo(ao(n.a[1]),32),no(ao(n.a[0]),zn)):no(ao(n.a[0]),zn),yo(co(ao(n.e),e))))},Ae.GS=function(t){return t.a<54?t.f<0?-1:t.f>0?1:0:(!t.c&&(t.c=Ae.FT(t.f)),t.c).e},Ae.HS=function(t){var n,e,o,r,i;return null!=t.g?t.g:t.a<32?(t.g=Ae.ST(io(t.f),ze(t.e)),t.g):(r=Ae.TT((!t.c&&(t.c=Ae.FT(t.f)),t.c),0),0==t.e?r:(n=(!t.c&&(t.c=Ae.FT(t.f)),t.c).e<0?2:1,e=le.V$(r).length,o=-t.e+e-n,(i=new ie.jS).a+=""+r,t.e>0&&o>=-6?o>=0?ie.iS(i,e-ze(t.e),String.fromCharCode(46)):(i.a=ie.SR(i.a,0,n-1)+"0."+ie.RR(i.a,n-1),ie.iS(i,n+1,ie.YR(Ae.uS,0,-ze(o)-1))):(e-n>=1&&(ie.iS(i,n,String.fromCharCode(46)),++e),ie.iS(i,e,String.fromCharCode(69)),o>0&&ie.iS(i,++e,String.fromCharCode(43)),ie.iS(i,++e,""+No(io(o)))),t.g=i.a,t.g))},Ae.IS=function(t){if(Ae.BS(),!isNaN(t)&&!isFinite(t)||isNaN(t))throw We(new ie.vR("Infinite or NaN"));Ae.DS(this,le.V$(t).toPrecision(20))},Ae.JS=function(t){this.f=t,this.e=2,this.a=Ae.NS(t)},Ae.KS=function(t,n){this.e=n,this.a=Ae.OS(t),this.a<54?this.f=yo(t):this.c=Ae.GT(t)},Ae.LS=function(t){this.e=2,Ae.FS(this,(le.M$(t),t))},Ae.MS=function(t){Ae.LS.call(this,t)},Ae.NS=function(n){var e,o;return n>-0x800000000000&&n<0x800000000000?0==n?0:((e=n<0)&&(n=-n),o=ze(t.Math.floor(t.Math.log(n)/.6931471805599453)),(!e||n!=t.Math.pow(2,o))&&++o,o):Ae.OS(io(n))},Ae.OS=function(t){var n;return eo(t,0)<0&&(t=re.RN(re.BJ(re.YN(t)?re.iO(re.NN(t)):re.LN(t)))),64-(0!=(n=jo(po(t,32)))?Io(n):Io(jo(t))+32)},Ae.QS=function(t,n,e){var o,r,i,a,s,u,f,l,c;return a=(i=Ae.fT(t,n))[0],0==(u=i[1]).e?new Ae.MS(a):(f=t.e*n.e,Ae.HT(n)<54?(c=u.d>1?go(mo(ao(u.a[1]),32),no(ao(u.a[0]),zn)):no(ao(u.a[0]),zn),s=co(ao(u.e),c),l=n.d>1?go(mo(ao(n.a[1]),32),no(ao(n.a[0]),zn)):no(ao(n.a[0]),zn),r=co(ao(n.e),l),o=uo(mo(eo(s,0)<0?ho(s):s,1),eo(r,0)<0?ho(r):r)?-1:so(mo(eo(s,0)<0?ho(s):s,1),eo(r,0)<0?ho(r):r)?1:0,o=Ae.US(Ae.pT(a,0)?1:0,f*(5+o),e)):(o=Ae.dT(Ae.nT(u.e<0?new Ae.tT(1,u.d,u.a):u),n.e<0?new Ae.tT(1,n.d,n.a):n),o=Ae.US(Ae.pT(a,0)?1:0,f*(5+o),e)),0!=o?Ae.HT(a)<54?Ae.WS((l=a.d>1?go(mo(ao(a.a[1]),32),no(ao(a.a[0]),zn)):no(ao(a.a[0]),zn),to(co(ao(a.e),l),re.SN(o)))):(a=Ae.ZT(a,Ae.GT(re.SN(o))),new Ae.MS(a)):new Ae.MS(a))},Ae.RS=function(n,e,o){var r,i,a,s,u;return a=(i=n/e)>0?t.Math.floor(i):t.Math.ceil(i),s=n%e,u=Co(n*e,0),0!=s&&(r=Co(2*t.Math.abs(s),t.Math.abs(e)),a+=Ae.US(1&ze(a),u*(5+r),o)),new Ae.JS(a)},Ae.US=function(n,e,o){var r;switch(r=0,o.b){case 7:if(0!=e)throw We(new ie.EP("Rounding necessary"));break;case 0:r=0==e?0:e<0?-1:1;break;case 2:r=t.Math.max(0==e?0:e<0?-1:1,0);break;case 3:r=t.Math.min(0==e?0:e<0?-1:1,0);break;case 4:t.Math.abs(e)>=5&&(r=0==e?0:e<0?-1:1);break;case 5:t.Math.abs(e)>5&&(r=0==e?0:e<0?-1:1);break;case 6:t.Math.abs(e)+n>5&&(r=0==e?0:e<0?-1:1)}return r},Ae.WS=function(t){return 0==eo(t,0)&&2<Ae.zS.length?Ae.zS[2]:new Ae.KS(t,2)},Te(12,73,{4:1,30:1,73:1,12:1},Ae.IS,Ae.JS,Ae.KS,Ae.MS),a.lb=function(t){return Ae.CS(this,t)},a.gb=function(t){var n;return this===t||!!Ue(t,12)&&(n=t,this.e==n.e&&0==Ae.CS(this,n))},a.ib=function(){var t;return 0!=this.b?this.b:this.a<54?(t=io(this.f),this.b=jo(no(t,-1)),this.b=33*this.b+jo(no(po(t,32),-1)),this.b=17*this.b+ze(this.e),this.b):(this.b=17*Ae.jT(this.c)+ze(this.e),this.b)},a.jb=function(){return Ae.HS(this)},a.a=0,a.b=0,a.d=0,a.e=0,a.f=0,re.yM=vo(12),Ae.bT=function(){var t;for(Ae.bT=De,Ae.YS=new Ae.sT(1,1),Ae.$S=new Ae.sT(1,10),Ae.aT=new Ae.sT(0,0),Ae.XS=new Ae.sT(-1,1),Ae.ZS=Oe($e(re.zM,1),C,15,0,[Ae.aT,Ae.YS,new Ae.sT(1,2),new Ae.sT(1,3),new Ae.sT(1,4),new Ae.sT(1,5),new Ae.sT(1,6),new Ae.sT(1,7),new Ae.sT(1,8),new Ae.sT(1,9),Ae.$S]),Ae._S=Ke(re.zM,C,15,32,0,1),t=0;t<Ae._S.length;t++)Ae._S[t]=Ae.GT(mo(1,t))},Ae.cT=function(t){},Ae.dT=function(t,n){return t.e>n.e?1:t.e<n.e?-1:t.d>n.d?t.e:t.d<n.d?-n.e:t.e*Ae.aU(t.a,n.a,t.d)},Ae.eT=function(t){for(;t.d>0&&0==t.a[--t.d];);0==t.a[t.d++]&&(t.e=0)},Ae.fT=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g;if(0==(r=n.e))throw We(new ie.EP("BigInteger divide by zero"));return o=n.d,e=n.a,1==o?Ae.VT(t,e[0],r):(h=t.a,((w=t.d)!=o?w>o?1:-1:Ae.aU(h,e,w))<0?Oe($e(re.zM,1),C,15,0,[Ae.aT,t]):(a=w-o+1,f=o,s=(g=t.e)==r?1:-1,i=Ke(re.hK,L,5,a,15,1),u=Ae.UT(i,a,h,w,e,o),l=new Ae.tT(s,a,i),c=new Ae.tT(g,f,u),Ae.eT(l),Ae.eT(c),Oe($e(re.zM,1),C,15,0,[l,c])))},Ae.gT=function(t,n){var e;return _e(t)===_e(n)||!!Ue(n,15)&&(e=n,t.e==e.e&&t.d==e.d&&Ae.hT(t,e.a))},Ae.hT=function(t,n){var e;for(e=t.d-1;e>=0&&t.a[e]==n[e];e--);return e<0},Ae.iT=function(t){var n;if(-2==t.b){if(0==t.e)n=-1;else for(n=0;0==t.a[n];n++);t.b=n}return t.b},Ae.jT=function(t){var n;if(0!=t.c)return t.c;for(n=0;n<t.a.length;n++)t.c=33*t.c+(-1&t.a[n]);return t.c=t.c*t.e,t.c},Ae.kT=function(t,n){return 0==n.e||0==t.e?Ae.aT:(Ae.iU(),Ae.jU(t,n))},Ae.lT=function(t,n){var e;if(n<0)throw We(new ie.EP("Negative exponent"));if(0==n)return Ae.YS;if(1==n||Ae.gT(t,Ae.YS)||Ae.gT(t,Ae.aT))return t;if(!Ae.pT(t,0)){for(e=1;!Ae.pT(t,e);)++e;return Ae.kT(Ae.AT(e*n),Ae.lT(Ae.oT(t,e),n))}return Ae.qU(t,n)},Ae.mT=function(t,n){return 0==n||0==t.e?t:n>0?Ae.IT(t,n):Ae.MT(t,-n)},Ae.nT=function(t){return 0==t.e?t:Ae.KT(t)},Ae.oT=function(t,n){return 0==n||0==t.e?t:n>0?Ae.MT(t,n):Ae.IT(t,-n)},Ae.pT=function(t,n){var e,o,r;if(0==n)return 0!=(1&t.a[0]);if(n<0)throw We(new ie.EP("Negative bit address"));if((r=n>>5)>=t.d)return t.e<0;if(e=t.a[r],n=1<<(31&n),t.e<0){if(r<(o=Ae.iT(t)))return!1;e=o==r?-e:~e}return 0!=(e&n)},Ae.qT=function(t){return Ae.TT(t,0)},Ae.rT=function(t,n){Ae.cT(this),this.e=t,n<Qn?(this.d=1,this.a=Oe($e(re.hK,1),L,5,15,[Ae.ET(n)])):(this.d=2,this.a=Oe($e(re.hK,1),L,5,15,[Ae.ET(n%Qn),Ae.ET(n/Qn)]))},Ae.sT=function(t,n){Ae.bT(),Ae.cT(this),this.e=t,this.d=1,this.a=Oe($e(re.hK,1),L,5,15,[n])},Ae.tT=function(t,n,e){Ae.bT(),Ae.cT(this),this.e=t,this.d=n,this.a=e},Ae.uT=function(t,n){Ae.cT(this),this.e=t,ro(no(n,-4294967296),0)?(this.d=1,this.a=Oe($e(re.hK,1),L,5,15,[jo(n)])):(this.d=2,this.a=Oe($e(re.hK,1),L,5,15,[jo(n),jo(po(n,32))]))},Ae.vT=function(t){Ae.bT(),Ae.cT(this),0==t.length?(this.e=0,this.d=1,this.a=Oe($e(re.hK,1),L,5,15,[0])):(this.e=1,this.d=t.length,this.a=t,Ae.eT(this))},Ae.wT=function(t){Ae.bT(),Ae.xT.call(this,t)},Ae.xT=function(t){if(Ae.cT(this),le.M$(t),0==le.V$(t).length)throw We(new ie.vR("Zero length BigInteger"));Ae.CT(this,t)},Ae.AT=function(t){var n,e,o;return t<Ae._S.length?Ae._S[t]:(e=t>>5,n=31&t,(o=Ke(re.hK,L,5,e+1,15,1))[e]=1<<n,new Ae.tT(1,e+1,o))},Ae.CT=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d;for(u=w=le.V$(n).length,le.S$(0,le.V$(n).length),45==le.V$(n).charCodeAt(0)?(c=-1,h=1,--w):(c=1,h=0),r=w/(i=(Ae.QT(),Ae.PT)[10])|0,0!=(d=w%i)&&++r,s=Ke(re.hK,L,5,r,15,1),e=Ae.OT[8],a=0,g=h+(0==d?i:d),m=h;m<u;g=(m=g)+i)o=ie.CQ(le.V$(n).substr(m,g-m)),Ae.iU(),f=Ae.mU(s,s,a,e),f+=Ae.bU(s,a,o),s[a++]=f;l=a,t.e=c,t.d=l,t.a=s,Ae.eT(t)},Ae.ET=function(t){return 0|t},Ae.FT=function(t){return Ae.bT(),t<0?-1!=t?new Ae.rT(-1,-t):Ae.XS:t<=10?Ae.ZS[ze(t)]:new Ae.rT(1,t)},Ae.GT=function(t){return Ae.bT(),eo(t,0)<0?0!=eo(t,-1)?new Ae.uT(-1,ho(t)):Ae.XS:eo(t,10)<=0?Ae.ZS[jo(t)]:new Ae.uT(1,t)},Te(15,73,{4:1,30:1,73:1,15:1},Ae.rT,Ae.sT,Ae.tT,Ae.uT,Ae.vT,Ae.wT),a.lb=function(t){return Ae.dT(this,t)},a.gb=function(t){return Ae.gT(this,t)},a.ib=function(){return Ae.jT(this)},a.jb=function(){return Ae.qT(this)},a.b=-2,a.c=0,a.d=0,a.e=0,re.zM=vo(15),Ae.HT=function(t){var n,e;return 0==t.e?0:(n=t.d<<5,e=t.a[t.d-1],t.e<0&&Ae.iT(t)==t.d-1&&(--e,e|=0),n-=Io(e))},Ae.IT=function(t,n){var e,o,r,i;return e=n>>5,n&=31,r=t.d+e+(0==n?0:1),o=Ke(re.hK,L,5,r,15,1),Ae.JT(o,t.a,e,n),i=new Ae.tT(t.e,r,o),Ae.eT(i),i},Ae.JT=function(t,n,e,o){var r,i,a;if(0==o)ie.pS(n,0,t,e,t.length-e);else for(a=32-o,t[t.length-1]=0,i=t.length-1;i>e;i--)t[i]|=n[i-e-1]>>>a,t[i-1]=n[i-e-1]<<o;for(r=0;r<e;r++)t[r]=0},Ae.KT=function(t){var n,e,o,r;return e=(r=t.d)+1,n=Ke(re.hK,L,5,e,15,1),Ae.LT(n,t.a,r),o=new Ae.tT(t.e,e,n),Ae.eT(o),o},Ae.LT=function(t,n,e){var o,r,i;for(o=0,r=0;r<e;r++)i=n[r],t[r]=i<<1|o,o=i>>>31;0!=o&&(t[e]=o)},Ae.MT=function(t,n){var e,o,r,i,a;if(o=n>>5,n&=31,o>=t.d)return t.e<0?(Ae.bT(),Ae.XS):(Ae.bT(),Ae.aT);if(i=t.d-o,r=Ke(re.hK,L,5,i+1,15,1),Ae.NT(r,i,t.a,o,n),t.e<0){for(e=0;e<o&&0==t.a[e];e++);if(e<o||n>0&&t.a[e]<<32-n!=0){for(e=0;e<i&&-1==r[e];e++)r[e]=0;e==i&&++i,++r[e]}}return a=new Ae.tT(t.e,i,r),Ae.eT(a),a},Ae.NT=function(t,n,e,o,r){var i,a,s;for(i=!0,a=0;a<o;a++)i&=0==e[a];if(0==r)ie.pS(e,o,t,0,n),a=n;else{for(s=32-r,i&=e[a]<<s==0,a=0;a<n-1;a++)t[a]=e[a+o]>>>r|e[a+o+1]<<s;t[a]=e[a+o]>>>r,++a}return i},Ae.QT=function(){Ae.QT=De,Ae.OT=Oe($e(re.hK,1),L,5,15,[D,1162261467,an,1220703125,362797056,1977326743,an,387420489,On,214358881,429981696,815730721,1475789056,170859375,St,410338673,612220032,893871739,128e7,1801088541,113379904,148035889,191102976,244140625,308915776,387420489,481890304,594823321,729e6,887503681,an,1291467969,1544804416,1838265625,60466176]),Ae.PT=Oe($e(re.hK,1),L,5,15,[-1,-1,31,19,15,13,11,11,10,9,9,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5])},Ae.RT=function(t){var n,e,o;return eo(t,0)>=0?(e=oo(t,On),o=lo(t,On)):(e=oo(n=Go(t,1),5e8),o=to(mo(o=lo(n,5e8),1),no(t,1))),go(mo(o,32),no(e,zn))},Ae.ST=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g;if(Ae.QT(),(s=eo(t,0)<0)&&(t=ho(t)),0==eo(t,0))switch(n){case 0:return"0";case 1:return"0.0";case 2:return"0.00";case 3:return"0.000";case 4:return cn;case 5:return"0.00000";case 6:return"0.000000";default:return(h=new ie.jS).a+=n<0?"0E+":"0E",h.a+=n==D?"2147483648":""+-n,h.a}f=18,l=Ke(re.eK,Vt,5,19,15,1),e=f,g=t;do{u=g,g=oo(g,10),l[--e]=jo(to(48,bo(u,co(g,10))))&V}while(0!=eo(g,0));if(o=bo(bo(bo(re.SN(f),re.SN(e)),re.SN(n)),1),0==n)return s&&(l[--e]=45),ie.YR(l,e,f-e);if(n>0&&eo(o,-6)>=0){if(eo(o,0)>=0){for(r=e+jo(o),a=17;a>=r;a--)l[a+1]=l[a];return l[++r]=46,s&&(l[--e]=45),ie.YR(l,e,f-e+1)}for(i=2;uo(re.SN(i),to(ho(o),1));i++)l[--e]=48;return l[--e]=46,l[--e]=48,s&&(l[--e]=45),ie.YR(l,e,f-e)}return w=e+1,f,c=new ie.kS,s&&(c.a+="-"),18-w>=1?(ie.cS(c,l[e]),c.a+=".",c.a+=ie.YR(l,e+1,f-e-1)):c.a+=ie.YR(l,e,f-e),c.a+="E",eo(o,0)>0&&(c.a+="+"),c.a+=""+No(o),c.a},Ae.TT=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N,H,v,M,A,S,C,x;if(Ae.QT(),v=t.e,g=t.d,r=t.a,0==v)switch(n){case 0:return"0";case 1:return"0.0";case 2:return"0.00";case 3:return"0.000";case 4:return cn;case 5:return"0.00000";case 6:return"0.000000";default:return(N=new ie.jS).a+=n<0?"0E+":"0E",N.a+=-n,N.a}if(b=10*g+1+7,y=Ke(re.eK,Vt,5,b+1,15,1),e=b,1==g)if((s=r[0])<0){x=no(re.SN(s),zn);do{m=x,x=oo(x,10),y[--e]=48+jo(bo(m,co(x,10)))&V}while(0!=eo(x,0))}else{x=s;do{m=x,x=x/10|0,y[--e]=m-10*x+48&V}while(0!=x)}else{A=Ke(re.hK,L,5,g,15,1),C=g,ie.pS(r,0,A,0,C);t:for(;;){for(H=0,f=C-1;f>=0;f--)S=to(mo(H,32),no(re.SN(A[f]),zn)),p=Ae.RT(S),A[f]=jo(p),H=ao(jo(po(p,32)));G=jo(H),d=e;do{y[--e]=48+G%10&V}while(0!=(G=G/10|0)&&0!=e);for(o=9-d+e,u=0;u<o&&e>0;u++)y[--e]=48;for(c=C-1;0==A[c];c--)if(0==c)break t;C=c+1}for(;48==y[e];)++e}if(w=v<0,a=b-e-n-1,0==n)return w&&(y[--e]=45),ie.YR(y,e,b-e);if(n>0&&a>=-6){if(a>=0){for(l=e+a,h=b-1;h>=l;h--)y[h+1]=y[h];return y[++l]=46,w&&(y[--e]=45),ie.YR(y,e,b-e+1)}for(c=2;c<1-a;c++)y[--e]=48;return y[--e]=46,y[--e]=48,w&&(y[--e]=45),ie.YR(y,e,b-e)}return M=e+1,i=b,j=new ie.kS,w&&(j.a+="-"),i-M>=1?(ie.cS(j,y[e]),j.a+=".",j.a+=ie.YR(y,e+1,b-e-1)):j.a+=ie.YR(y,e,b-e),j.a+="E",a>0&&(j.a+="+"),j.a+=""+a,j.a},Ae.UT=function(t,n,e,o,r,i){var a,s,u,f,l,c,h,w,g,m,d,p,G,b,y,j,N;for(m=Ke(re.hK,L,5,o+1,15,1),d=Ke(re.hK,L,5,i+1,15,1),p=i,0!=(s=Io(r[i-1]))?(Ae.JT(d,r,0,s),Ae.JT(m,e,0,s)):(ie.pS(e,0,m,0,o),ie.pS(r,0,d,0,i)),u=d[p-1],l=n-1,c=o;l>=0;){if(f=0,m[c]==u)f=-1;else if(G=to(mo(no(re.SN(m[c]),zn),32),no(re.SN(m[c-1]),zn)),f=jo(j=Ae.XT(G,u)),y=jo(po(j,32)),0!=f){w=0,N=0,b=!1,++f;do{if(--f,b)break;w=co(no(re.SN(f),zn),no(re.SN(d[p-2]),zn)),N=to(mo(re.SN(y),32),no(re.SN(m[c-2]),zn)),Io(jo(Go(g=to(no(re.SN(y),zn),no(re.SN(u),zn)),32)))<32?b=!0:y=jo(g)}while(so(Ho(w,F),Ho(N,F)))}if(0!=f&&0!=Ae.YT(m,c-p,d,p,f))for(--f,a=0,h=0;h<p;h++)a=to(a,to(no(re.SN(m[c-p+h]),zn),no(re.SN(d[h]),zn))),m[c-p+h]=jo(a),a=Go(a,32);t[l]=f,--c,--l}return 0!=s?(Ae.NT(d,p,m,0,s),d):(ie.pS(m,0,d,0,i),m)},Ae.VT=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w,g,m;return w=t.a,g=t.d,m=t.e,1==g?(i=oo(o=no(re.SN(w[0]),zn),r=no(re.SN(n),zn)),f=lo(o,r),m!=e&&(i=ho(i)),m<0&&(f=ho(f)),Oe($e(re.zM,1),C,15,0,[Ae.GT(i),Ae.GT(f)])):(s=g,u=m==e?1:-1,a=Ke(re.hK,L,5,s,15,1),l=Oe($e(re.hK,1),L,5,15,[Ae.WT(a,w,g,n)]),c=new Ae.tT(u,s,a),h=new Ae.tT(m,1,l),Ae.eT(c),Ae.eT(h),Oe($e(re.zM,1),C,15,0,[c,h]))},Ae.WT=function(t,n,e,o){var r,i,a,s,u,f,l;for(f=0,i=no(re.SN(o),zn),s=e-1;s>=0;s--)eo(l=go(mo(f,32),no(re.SN(n[s]),zn)),0)>=0?(u=oo(l,i),f=lo(l,i)):(u=oo(r=Go(l,1),a=re.SN(o>>>1)),f=to(mo(f=lo(r,a),1),no(l,1)),0!=(1&o)&&(eo(u,f)<=0?f=bo(f,u):fo(bo(u,f),i)?(f=to(f,bo(i,u)),u=bo(u,1)):(f=to(f,bo(mo(i,1),u)),u=bo(u,2)))),t[s]=jo(no(u,zn));return jo(f)},Ae.XT=function(t,n){var e,o,r,i,a;return o=no(re.SN(n),zn),eo(t,0)>=0?(i=oo(t,o),a=lo(t,o)):(i=oo(e=Go(t,1),r=re.SN(n>>>1)),a=to(mo(a=lo(e,r),1),no(t,1)),0!=(1&n)&&(eo(i,a)<=0?a=bo(a,i):fo(bo(i,a),o)?(a=to(a,bo(o,i)),i=bo(i,1)):(a=to(a,bo(mo(o,1),i)),i=bo(i,2)))),go(mo(a,32),no(i,zn))},Ae.YT=function(t,n,e,o,r){var i,a,s;for(i=0,a=0,s=0;s<o;s++)Ae.iU(),i=to(co(no(re.SN(e[s]),zn),no(re.SN(r),zn)),no(ao(jo(i)),zn)),a=to(bo(no(re.SN(t[n+s]),zn),no(i,zn)),a),t[n+s]=jo(a),a=po(a,32),i=Go(i,32);return a=to(bo(no(re.SN(t[n+o]),zn),i),a),t[n+o]=jo(a),jo(po(a,32))},Ae.ZT=function(t,n){var e,o,r,i,a,s,u,f,l,c,h,w,g;if(a=t.e,u=n.e,0==a)return n;if(0==u)return t;if((i=t.d)+(s=n.d)==2)return e=no(ao(t.a[0]),zn),o=no(ao(n.a[0]),zn),a==u?(g=jo(l=to(e,o)),0==(w=jo(Go(l,32)))?new Ae.sT(a,g):new Ae.tT(a,2,Oe($e(re.hK,1),L,5,15,[g,w]))):Ae.GT(a<0?bo(o,e):bo(e,o));if(a==u)h=a,c=i>=s?Ae.$T(t.a,i,n.a,s):Ae.$T(n.a,s,t.a,i);else{if(0==(r=i!=s?i>s?1:-1:Ae.aU(t.a,n.a,i)))return Ae.bT(),Ae.aT;1==r?(h=a,c=Ae.dU(t.a,i,n.a,s)):(h=u,c=Ae.dU(n.a,s,t.a,i))}return f=new Ae.tT(h,c.length,c),Ae.eT(f),f},Ae.$T=function(t,n,e,o){var r;return r=Ke(re.hK,L,5,n+1,15,1),Ae._T(r,t,n,e,o),r},Ae._T=function(t,n,e,o,r){var i,a;if(i=to(no(re.SN(n[0]),zn),no(re.SN(o[0]),zn)),t[0]=jo(i),i=po(i,32),e>=r){for(a=1;a<r;a++)i=to(i,to(no(re.SN(n[a]),zn),no(re.SN(o[a]),zn))),t[a]=jo(i),i=po(i,32);for(;a<e;a++)i=to(i,no(re.SN(n[a]),zn)),t[a]=jo(i),i=po(i,32)}else{for(a=1;a<e;a++)i=to(i,to(no(re.SN(n[a]),zn),no(re.SN(o[a]),zn))),t[a]=jo(i),i=po(i,32);for(;a<r;a++)i=to(i,no(re.SN(o[a]),zn)),t[a]=jo(i),i=po(i,32)}0!=eo(i,0)&&(t[a]=jo(i))},Ae.aU=function(t,n,e){var o;for(o=e-1;o>=0&&t[o]==n[o];o--);return o<0?0:uo(no(re.SN(t[o]),zn),no(re.SN(n[o]),zn))?-1:1},Ae.bU=function(t,n,e){var o,r;for(o=no(re.SN(e),zn),r=0;0!=eo(o,0)&&r<n;r++)o=to(o,no(re.SN(t[r]),zn)),t[r]=jo(o),o=po(o,32);return jo(o)},Ae.cU=function(t,n){var e,o,r,i,a,s,u,f,l,c;if(a=t.e,0==(u=n.e))return t;if(0==a)return 0==n.e?n:new Ae.tT(-n.e,n.d,n.a);if((i=t.d)+(s=n.d)==2)return e=no(ao(t.a[0]),zn),o=no(ao(n.a[0]),zn),a<0&&(e=ho(e)),u<0&&(o=ho(o)),Ae.GT(bo(e,o));if(-1==(r=i!=s?i>s?1:-1:Ae.aU(t.a,n.a,i)))c=-u,l=a==u?Ae.dU(n.a,s,t.a,i):Ae.$T(n.a,s,t.a,i);else if(c=a,a==u){if(0==r)return Ae.bT(),Ae.aT;l=Ae.dU(t.a,i,n.a,s)}else l=Ae.$T(t.a,i,n.a,s);return f=new Ae.tT(c,l.length,l),Ae.eT(f),f},Ae.dU=function(t,n,e,o){var r;return r=Ke(re.hK,L,5,n,15,1),Ae.eU(r,t,n,e,o),r},Ae.eU=function(t,n,e,o,r){var i,a;for(i=0,a=0;a<r;a++)i=to(i,bo(no(re.SN(n[a]),zn),no(re.SN(o[a]),zn))),t[a]=jo(i),i=po(i,32);for(;a<e;a++)i=to(i,no(re.SN(n[a]),zn)),t[a]=jo(i),i=po(i,32)},Ae.iU=function(){var t,n;for(Ae.iU=De,Ae.fU=Ke(re.zM,C,15,32,0,1),Ae.gU=Ke(re.zM,C,15,32,0,1),Ae.hU=Oe($e(re.hK,1),L,5,15,[1,10,100,1e3,E,1e5,1e6,1e7,1e8,On]),t=1,n=0;n<=18;n++)Ae.fU[n]=Ae.GT(t),Ae.gU[n]=Ae.GT(mo(t,n)),t=co(t,5);for(;n<Ae.gU.length;n++)Ae.fU[n]=Ae.kT(Ae.fU[n-1],Ae.fU[1]),Ae.gU[n]=Ae.kT(Ae.gU[n-1],(Ae.bT(),Ae.$S))},Ae.jU=function(t,n){var e,o,r,i,a,s,u,f,l;return Ae.iU(),n.d>t.d&&(s=t,t=n,n=s),n.d<63?Ae.pU(t,n):(a=(-2&t.d)<<4,f=Ae.oT(t,a),l=Ae.oT(n,a),o=Ae.cU(t,Ae.mT(f,a)),r=Ae.cU(n,Ae.mT(l,a)),u=Ae.jU(f,l),e=Ae.jU(o,r),i=Ae.jU(Ae.cU(f,o),Ae.cU(r,l)),i=Ae.ZT(Ae.ZT(i,u),e),i=Ae.mT(i,a),u=Ae.mT(u,a<<1),Ae.ZT(Ae.ZT(u,i),e))},Ae.kU=function(t,n,e,o,r){0!=n&&0!=o&&(1==n?r[o]=Ae.mU(r,e,o,t[0]):1==o?r[n]=Ae.mU(r,t,n,e[0]):Ae.lU(t,e,r,n,o))},Ae.lU=function(t,n,e,o,r){var i,a,s,u;if(_e(t)!==_e(n)||o!=r)for(s=0;s<o;s++){for(a=0,i=t[s],u=0;u<r;u++)a=to(to(co(no(re.SN(i),zn),no(re.SN(n[u]),zn)),no(re.SN(e[s+u]),zn)),no(ao(jo(a)),zn)),e[s+u]=jo(a),a=Go(a,32);e[s+r]=jo(a)}else Ae.sU(t,o,e)},Ae.mU=function(t,n,e,o){var r,i;for(Ae.iU(),r=0,i=0;i<e;i++)r=to(co(no(re.SN(n[i]),zn),no(re.SN(o),zn)),no(ao(jo(r)),zn)),t[i]=jo(r),r=Go(r,32);return jo(r)},Ae.nU=function(t,n){var e,o,r,i,a,s,u,f,l;return 0==(f=t.e)?(Ae.bT(),Ae.aT):(o=t.d,e=t.a,1==o?(u=jo(r=co(no(re.SN(e[0]),zn),no(re.SN(n),zn))),0==(a=jo(Go(r,32)))?new Ae.sT(f,u):new Ae.tT(f,2,Oe($e(re.hK,1),L,5,15,[u,a]))):(s=o+1,(i=Ke(re.hK,L,5,s,15,1))[o]=Ae.mU(i,e,o,n),l=new Ae.tT(f,s,i),Ae.eT(l),l))},Ae.oU=function(t,n){return Ae.iU(),n<Ae.hU.length?Ae.nU(t,Ae.hU[n]):Ae.kT(t,Ae.rU(n))},Ae.pU=function(t,n){var e,o,r,i,a,s,u,f,l,c,h;return s=(o=t.d)+(i=n.d),u=t.e!=n.e?-1:1,2==s?(h=jo(l=co(no(ao(t.a[0]),zn),no(ao(n.a[0]),zn))),0==(c=jo(Go(l,32)))?new Ae.sT(u,h):new Ae.tT(u,2,Oe($e(re.hK,1),L,5,15,[h,c]))):(e=t.a,r=n.a,a=Ke(re.hK,L,5,s,15,1),Ae.kU(e,o,r,i,a),f=new Ae.tT(u,s,a),Ae.eT(f),f)},Ae.qU=function(t,n){var e,o;for(Ae.iU(),Ae.bT(),o=Ae.YS,e=t;n>1;n>>=1)0!=(1&n)&&(o=Ae.kT(o,e)),e=1==e.d?Ae.kT(e,e):new Ae.vT(Ae.sU(e.a,e.d,Ke(re.hK,L,5,e.d<<1,15,1)));return o=Ae.kT(o,e)},Ae.rU=function(t){var n,e,o,r;if(Ae.iU(),n=ze(t),t<Ae.gU.length)return Ae.gU[n];if(t<=50)return Ae.lT((Ae.bT(),Ae.$S),n);if(t<=1e3)return Ae.mT(Ae.lT(Ae.fU[1],n),n);if(t>1e6)throw We(new ie.EP("power of ten too big"));if(t<=N)return Ae.mT(Ae.lT(Ae.fU[1],n),n);for(r=o=Ae.lT(Ae.fU[1],N),e=io(t-N),n=ze(t%N);eo(e,N)>0;)r=Ae.kT(r,o),e=bo(e,N);for(r=Ae.kT(r,Ae.lT(Ae.fU[1],n)),r=Ae.mT(r,N),e=io(t-N);eo(e,N)>0;)r=Ae.mT(r,N),e=bo(e,N);return r=Ae.mT(r,n)},Ae.sU=function(t,n,e){var o,r,i,a,s;for(i=0;i<n;i++){for(o=0,s=i+1;s<n;s++)o=to(to(co(no(re.SN(t[i]),zn),no(re.SN(t[s]),zn)),no(re.SN(e[i+s]),zn)),no(ao(jo(o)),zn)),e[i+s]=jo(o),o=Go(o,32);e[i+n]=jo(o)}for(Ae.LT(e,e,n<<1),o=0,r=0,a=0;r<n;++r,a++)o=to(to(co(no(re.SN(t[r]),zn),no(re.SN(t[r]),zn)),no(re.SN(e[a]),zn)),no(ao(jo(o)),zn)),e[a]=jo(o),++a,o=to(o=Go(o,32),no(re.SN(e[a]),zn)),e[a]=jo(o),o=Go(o,32);return e},Ae.BU=function(){Ae.BU=De,Ae.AU=new Ae.CU("UP",0),Ae.uU=new Ae.CU("DOWN",1),Ae.tU=new Ae.CU("CEILING",2),Ae.vU=new Ae.CU("FLOOR",3),Ae.yU=new Ae.CU("HALF_UP",4),Ae.wU=new Ae.CU("HALF_DOWN",5),Ae.xU=new Ae.CU("HALF_EVEN",6),Ae.zU=new Ae.CU("UNNECESSARY",7)},Ae.CU=function(t,n){ko.call(this,t,n)},Ae.DU=function(){return Ae.BU(),Oe($e(re.AM,1),C,44,0,[Ae.AU,Ae.uU,Ae.tU,Ae.vU,Ae.yU,Ae.wU,Ae.xU,Ae.zU])},Te(44,39,{4:1,30:1,39:1,44:1},Ae.CU),re.AM=Mo(44,Ae.DU),Se.EU=function(t,n){return ie.DR(t.a,n.a)},Se.FU=function(t){this.a=t},Te(60,1,Zn),a.lb=function(t){return Se.EU(this,t)},a.gb=function(t){var n;return t===this||!!Ue(t,60)&&(n=t,ie.GR(this.a,n.a))},a.ib=function(){return le.e_(this.a)},a.jb=function(){return this.a},re.BM=vo(60),Te(215,1,{}),re.DM=vo(215),Ce.KU=function(t,n){return be.oI(t.a,n)},Ce.LU=function(t){this.a=(be.iI(),new be.zI(t,be.dI()))},Ce.MU=function(t){Ce.LU.call(this,t)},Te(100,215,{},Ce.LU,Ce.MU),re.CM=vo(100),ue.AX=function(t,n,e){var o,r,i;return i=n,null!=(o=ue.lV(ue.lY(t,i)))||(r=n,ue.lY(t,r))?o:e},ue.BX=function(t,n,e){var o,r;return r=n,null!=(o=ue.lV(ue.lY(t,r)))?o:ue.qY(t,n,e)},ue.CX=function(t,n,e){var o;return o=n,ue.lY(t,o)?ue.qY(t,n,e):null},ue.cV=function(t,n){var e,o;for(e=new ue.IY(new ue.NY(t).b);ue.OU(e.a);)if(o=(e.b=ue.PU(e.a)).Tb(),_e(n)===_e(o)||null!=n&&ie.wc(n,o))return!0;return!1},ue.dV=function(t,n,e){var o,r,i;for(r=new ue.IY(new ue.NY(t).b);ue.OU(r.a);)if(i=(o=r.b=ue.PU(r.a)).Sb(),_e(n)===_e(i)||null!=n&&ie.wc(n,i))return e&&(o=new ue.eW(o.Sb(),o.Tb()),ue.HY(r)),o;return null},ue.eV=function(t,n){return n===t?"(this Map)":null==n?k:ke(n)},ue.fV=function(t){return new ue.MV(t)},ue.lV=function(t){return t?t.Tb():null},Te(213,1,{188:1}),a.getOrDefault=function(t,n){var e,o,r;return r=t,null!=(e=ue.lV(ue.lY(this,r)))||(o=t,ue.lY(this,o))?e:n},a.putIfAbsent=function(t,n){var e,o;return o=t,null!=(e=ue.lV(ue.lY(this,o)))?e:ue.qY(this,t,n)},a.replace=function(t,n){var e;return e=t,ue.lY(this,e)?ue.qY(this,t,n):null},a.clear=function(){this.Rb().clear()},a.containsKey=function(t){return!!ue.dV(this,t,!1)},a.containsValue=function(t){return ue.cV(this,t)},a.gb=function(t){var n,e,o;if(t===this)return!0;if(!Ue(t,56))return!1;if(o=t,this.c!=o.c)return!1;for(e=new ue.IY(new ue.NY(o).b);ue.OU(e.a);)if(n=e.b=ue.PU(e.a),!ue.fW(this,n))return!1;return!0},a.get=function(t){return ue.lV(ue.dV(this,t,!1))},a.ib=function(){return ue.rX(this.Rb())},a.isEmpty=function(){return 0==this.c},a.keySet=function(){return new ue.BV(this)},a.put=function(t,n){throw We(new ie.sS("Put not supported on this map"))},a.putAll=function(t){var n,e;for(le.M$(t),e=new ue.IY(t.Rb().b);ue.OU(e.a);)n=e.b=ue.PU(e.a),ue.qY(this,n.Sb(),n.Tb())},a.remove=function(t){return ue.lV(ue.dV(this,t,!0))},a.size=function(){return this.Rb().b.c},a.jb=function(){var t,n,e;for(e=new ue.gY("{","}"),n=new ue.IY(this.Rb().b);ue.OU(n.a);)t=n.b=ue.PU(n.a),ue.eY(e,ue.eV(this,t.Sb())+"="+ue.eV(this,t.Tb()));return e.a?0==le.V$(e.e).length?e.a.a:e.a.a+""+e.e:e.c},a.values=function(){return ue.fV(this)},re.PM=vo(213),Te(212,208,Wn),a.gb=function(t){var n;return t===this||!!Ue(t,77)&&((n=t).size()==this.size()&&ue.jh(this,n))},a.ib=function(){return ue.rX(this)},a.removeAll=function(t){var n,e,o,r;if(le.M$(t),(r=this.size())<t.size())for(n=this.mb();n.Ob();)e=n.Pb(),t.contains(e)&&n.Qb();else for(o=t.mb();o.Ob();)e=o.Pb(),this.remove(e);return r!=this.size()},re.UM=vo(212),ue.BV=function(t){this.a=t},Te(164,212,Wn,ue.BV),a.clear=function(){ue.jY(this.a)},a.contains=function(t){return ue.gW(this.a,t)},a.mb=function(){var t;return t=new ue.IY(new ue.NY(this.a).b),new ue.HV(t)},a.remove=function(t){return!!ue.gW(this.a,t)&&(ue.rY(this.a,t),!0)},a.size=function(){return this.a.c},re.KM=vo(164),ue.HV=function(t){this.a=t},Te(165,1,{},ue.HV),a.Ob=function(){return ue.OU(this.a.a)},a.Pb=function(){return ue.GY(this.a).Sb()},a.Qb=function(){ue.HY(this.a)},re.JM=vo(165),ue.LV=function(t){var n;return n=new ue.IY(new ue.NY(t.a).b),new ue.TV(n)},ue.MV=function(t){this.a=t},Te(121,208,{37:1},ue.MV),a.clear=function(){ue.jY(this.a)},a.contains=function(t){return ue.cV(this.a,t)},a.mb=function(){return ue.LV(this)},a.size=function(){return this.a.c},re.MM=vo(121),ue.RV=function(t){return ue.OU(t.a.a)},ue.SV=function(t){return ue.GY(t.a).Tb()},ue.TV=function(t){this.a=t},Te(122,1,{},ue.TV),a.Ob=function(){return ue.RV(this)},a.Pb=function(){return ue.SV(this)},a.Qb=function(){ue.HY(this.a)},re.LM=vo(122),ue.XV=function(t){return t.c},ue.YV=function(t){return t.d},ue.ZV=function(t,n){var e;return e=t.d,t.d=n,e},ue.$V=function(t,n){this.c=t,this.d=n},Te(84,1,{84:1,86:1}),a.gb=function(t){var n;return!!Ue(t,86)&&(n=t,ue.EX(this.c,n.Sb())&&ue.EX(this.d,n.Tb()))},a.Sb=function(){return ue.XV(this)},a.Tb=function(){return ue.YV(this)},a.ib=function(){return ue.FX(this.c)^ue.FX(this.d)},a.jb=function(){return this.c+"="+this.d},re.NM=vo(84),ue.eW=function(t,n){ue.$V.call(this,t,n)},Te(85,84,{84:1,85:1,86:1},ue.eW),re.OM=vo(85),ue.fW=function(t,n){var e,o;return e=n.Sb(),!!(o=ue.lY(t,e))&&ue.EX(o.d,n.Tb())},ue.gW=function(t,n){var e;return e=n,!!ue.lY(t,e)},ue.hW=function(t,n){var e;return e=n,ue.lV(ue.lY(t,e))},ue.iW=function(t){return new ue.vW(t)},Te(214,213,{188:1}),a.containsKey=function(t){return ue.gW(this,t)},a.Rb=function(){return new ue.pW(this)},a.get=function(t){return ue.hW(this,t)},a.keySet=function(){return ue.iW(this)},re.TM=vo(214),ue.nW=function(t){return new ue.IY(t.b)},ue.oW=function(t){return t.b.c},ue.pW=function(t){this.b=t},Te(125,212,Wn,ue.pW),a.contains=function(t){return Ue(t,86)&&ue.fW(this.b,t)},a.mb=function(){return ue.nW(this)},a.remove=function(t){var n;return!!Ue(t,86)&&(n=t,ue.sY(this.b,n))},a.size=function(){return ue.oW(this)},re.QM=vo(125),ue.uW=function(t){var n;return n=new ue.IY(new ue.NY(t.a).b),new ue.DW(n)},ue.vW=function(t){this.a=t},Te(93,212,Wn,ue.vW),a.clear=function(){ue.jY(this.a)},a.contains=function(t){return ue.gW(this.a,t)},a.mb=function(){return ue.uW(this)},a.remove=function(t){return!!ue.gW(this.a,t)&&(ue.rY(this.a,t),!0)},a.size=function(){return this.a.c},re.SM=vo(93),ue.BW=function(t){return ue.OU(t.a.a)},ue.CW=function(t){return ue.GY(t.a).Sb()},ue.DW=function(t){this.a=t},Te(94,1,{},ue.DW),a.Ob=function(){return ue.BW(this)},a.Pb=function(){return ue.CW(this)},a.Qb=function(){ue.HY(this.a)},re.RM=vo(94),ue.iX=function(){return re.yL},ue.jX=function(){},Te(220,t.Function,{},ue.jX),a.Ub=function(t,n){return Co(t,n)},ue.lX=function(){return re.yL},ue.mX=function(){},Te(221,t.Function,{},ue.mX),a.Vb=function(t,n){return eo(t,n)<0?-1:eo(t,n)>0?1:0},ue.oX=function(){return re.yL},ue.pX=function(){},Te(47,t.Function,{},ue.pX),a.Ub=function(t,n){return t-n},ue.uX=function(){ue.uX=De,ue.tX=new ue.wX},ue.vX=function(t,n){return le.M$(t),ie.SP(t,(le.M$(n),n))},ue.wX=function(){},Te(181,1,Vt,ue.wX),a.kb=function(t,n){return ue.vX(t,n)},a.gb=function(t){return this===t},re.XM=vo(181),ue.JX=function(){var t,n,e,o;for(ue.JX=De,ue.GX=Ke(re.fK,ut,5,25,15,1),ue.HX=Ke(re.fK,ut,5,33,15,1),o=Xn,n=32;n>=0;n--)ue.HX[n]=o,o*=.5;for(e=1,t=24;t>=0;t--)ue.GX[t]=e,e*=.5},ue.KX=function(t,n){var e,o;if(le.H$(n>0),(n&-n)==n)return ze(n*ue.LX(t)*4.656612873077393e-10);do{o=(e=ue.LX(t))%n}while(e-o+(n-1)<0);return ze(o)},ue.LX=function(n){var e,o,r,i;return r=n.a*te+1502*n.b,i=n.b*te+11,r+=e=t.Math.floor(i*ne),i-=e*Wt,r%=Wt,n.a=r,n.b=i,(o=128*n.a+t.Math.floor(n.b*ue.HX[31]))>=2147483648&&(o-=Qn),o},ue.MX=function(t,n,e){t.a=1502^n,t.b=e^te},ue.NX=function(){var n,e,o;ue.JX(),o=ue.IX+++Date.now(),n=ze(t.Math.floor(o*ne))&Z,e=ze(o-n*Wt),this.a=1502^n,this.b=e^te},ue.OX=function(t){ue.JX(),ue.MX(this,jo(no(po(t,24),Z)),jo(no(t,Z)))},Te(89,1,{},ue.NX,ue.OX),a.a=0,a.b=0,ue.IX=0,re.ZM=vo(89),ue.eY=function(t,n){return t.a?ie.gS(t.a,t.b):t.a=new ie.lS(t.d),ie.fS(t.a,n),t},ue.fY=function(t){return t.a?0==le.V$(t.e).length?t.a.a:t.a.a+""+t.e:t.c},ue.gY=function(t,n){this.b=", ",this.d=t,this.e=n,this.c=this.d+""+this.e},Te(109,1,{},ue.gY),a.jb=function(){return ue.fY(this)},re.cN=vo(109),ue.iY=function(t){},ue.jY=function(t){t.b=null,t.c=0},ue.kY=function(t){return new ue.NY(t)},ue.lY=function(t,n){var e,o,r;for(r=t.b;r;){if(0==(e=t.a.kb(n,r.c)))return r;o=e<0?0:1,r=r.a[o]}return null},ue.mY=function(t,n,e,o,r,i,a,s){var u,f;o&&((u=o.a[0])&&ue.mY(t,n,e,u,r,i,a,s),ue.nY(t,e,o.c,r,i,a,s)&&n.add(o),(f=o.a[1])&&ue.mY(t,n,e,f,r,i,a,s))},ue.nY=function(t,n,e,o,r,i,a){var s,u;return!(n.$b()&&(u=t.a.kb(e,o),u<0||!r&&0==u))&&!(n._b()&&(s=t.a.kb(e,i),s>0||!a&&0==s))},ue.oY=function(t,n,e,o){var r,i;return n?0==(r=t.a.kb(e.c,n.c))?(o.d=ue.ZV(n,e.d),o.b=!0,n):(i=r<0?0:1,n.a[i]=ue.oY(t,n.a[i],e,o),ue.pY(n.a[i])&&(ue.pY(n.a[1-i])?(n.b=!0,n.a[0].b=!1,n.a[1].b=!1):ue.pY(n.a[i].a[i])?n=ue.wY(n,1-i):ue.pY(n.a[i].a[1-i])&&(n=ue.vY(n,1-i))),n):e},ue.pY=function(t){return!!t&&t.b},ue.qY=function(t,n,e){var o,r;return o=new ue.QY(n,e),r=new ue.SY,t.b=ue.oY(t,t.b,o,r),r.b||++t.c,t.b.b=!1,r.d},ue.rY=function(t,n){var e,o;return e=n,o=new ue.SY,ue.tY(t,e,o),o.d},ue.sY=function(t,n){var e;return(e=new ue.SY).c=!0,e.d=n.Tb(),ue.tY(t,n.Sb(),e)},ue.tY=function(t,n,e){var o,r,i,a,s,u,f,l,c,h,w;if(!t.b)return!1;for(a=null,h=null,r=1,(u=new ue.QY(null,null)).a[1]=t.b,c=u;c.a[r];)f=r,s=h,h=c,c=c.a[r],r=(o=t.a.kb(n,c.c))<0?0:1,0==o&&(!e.c||ue.EX(c.d,e.d))&&(a=c),c&&c.b||ue.pY(c.a[r])||(ue.pY(c.a[1-r])?h=h.a[f]=ue.wY(c,r):ue.pY(c.a[1-r])||(w=h.a[1-f])&&(ue.pY(w.a[1-f])||ue.pY(w.a[f])?(i=s.a[1]==h?1:0,ue.pY(w.a[f])?s.a[i]=ue.vY(h,f):ue.pY(w.a[1-f])&&(s.a[i]=ue.wY(h,f)),c.b=s.a[i].b=!0,s.a[i].a[0].b=!1,s.a[i].a[1].b=!1):(h.b=!1,w.b=!0,c.b=!0)));return a&&(e.b=!0,e.d=a.d,c!=a&&(l=new ue.QY(c.c,c.d),ue.uY(t,u,a,l),h==a&&(h=l)),h.a[h.a[1]==c?1:0]=c.a[c.a[0]?0:1],--t.c),t.b=u.a[1],t.b&&(t.b.b=!1),e.b},ue.uY=function(t,n,e,o){var r,i;for(r=null==(i=n).c||t.a.kb(e.c,i.c)>0?1:0;i.a[r]!=e;)i=i.a[r],r=t.a.kb(e.c,i.c)>0?1:0;i.a[r]=o,o.b=e.b,o.a[0]=e.a[0],o.a[1]=e.a[1],e.a[0]=null,e.a[1]=null},ue.vY=function(t,n){var e;return e=1-n,t.a[e]=ue.wY(t.a[e],e),ue.wY(t,n)},ue.wY=function(t,n){var e,o;return e=1-n,o=t.a[e],t.a[e]=o.a[n],o.a[n]=t,t.b=!0,o.b=!1,o},ue.xY=function(t){return t.c},ue.yY=function(){ue.zY.call(this,null)},ue.zY=function(t){ue.iY(this),this.b=null,this.a=(ue.uX(),t||ue.tX)},Te(56,214,{4:1,188:1,56:1},ue.yY,ue.zY),a.clear=function(){ue.jY(this)},a.Rb=function(){return ue.kY(this)},a.put=function(t,n){return ue.qY(this,t,n)},a.remove=function(t){return ue.rY(this,t)},a.size=function(){return ue.xY(this)},a.c=0,re.lN=vo(56),ue.FY=function(t){return ue.OU(t.a)},ue.GY=function(t){return t.b=ue.PU(t.a)},ue.HY=function(t){ue.QU(t.a),ue.sY(t.c,t.b),t.b=null},ue.IY=function(t){ue.JY.call(this,t,(ue.YY(),ue.UY))},ue.JY=function(t,n){var e;this.c=t,e=new ue.gi,ue.mY(t,e,n,t.b,null,!1,null,!1),this.a=new ue.WU(e,0)},Te(35,1,{},ue.IY),a.Pb=function(){return ue.GY(this)},a.Ob=function(){return ue.FY(this)},a.Qb=function(){ue.HY(this)},re.dN=vo(35),ue.NY=function(t){this.a=t,ue.pW.call(this,t)},Te(41,125,Wn,ue.NY),a.clear=function(){ue.jY(this.a)},re.eN=vo(41),ue.PY=function(t){t.a=Ke(re.fN,x,65,2,0,1)},ue.QY=function(t,n){ue.RY.call(this,t,n)},ue.RY=function(t,n){ue.eW.call(this,t,n),ue.PY(this),this.b=!0},Te(65,85,{84:1,85:1,86:1,65:1},ue.QY),a.b=!1,re.fN=vo(65),ue.SY=function(){},Te(99,1,{},ue.SY),a.jb=function(){return"State: mv="+this.c+" value="+this.d+" done="+this.a+" found="+this.b},a.a=!1,a.b=!1,a.c=!1,re.gN=vo(99),ue.YY=function(){ue.YY=De,ue.UY=new ue.ZY("All",0),ue.VY=new ue.bZ,ue.WY=new ue.dZ,ue.XY=new ue.gZ},ue.ZY=function(t,n){ko.call(this,t,n)},ue.aZ=function(){return ue.YY(),Oe($e(re.kN,1),C,48,0,[ue.UY,ue.VY,ue.WY,ue.XY])},Te(48,39,ee,ue.ZY),a.$b=function(){return!1},a._b=function(){return!1},re.kN=Mo(48,ue.aZ),ue.bZ=function(){ue.ZY.call(this,"Head",1)},Te(171,48,ee,ue.bZ),a._b=function(){return!0},re.hN=Mo(171,null),ue.dZ=function(){ue.ZY.call(this,"Range",2)},Te(172,48,ee,ue.dZ),a.$b=function(){return!0},a._b=function(){return!0},re.iN=Mo(172,null),ue.gZ=function(){ue.ZY.call(this,"Tail",3)},Te(173,48,ee,ue.gZ),a.$b=function(){return!0},re.jN=Mo(173,null),ue.iZ=function(t,n){return null==ue.qY(t.a,n,(ie.KP(),h))},ue.jZ=function(t){ue.jY(t.a)},ue.kZ=function(t,n){return ue.gW(t.a,n)},ue.lZ=function(t){var n;return n=new ue.IY(new ue.NY(new ue.vW(t.a).a).b),new ue.DW(n)},ue.mZ=function(t){this.a=new ue.zY(t)},Te(150,212,{4:1,37:1,77:1},ue.mZ),a.add=function(t){return ue.iZ(this,t)},a.clear=function(){ue.jZ(this)},a.contains=function(t){return ue.kZ(this,t)},a.mb=function(){return ue.lZ(this)},a.remove=function(t){return null!=ue.rY(this.a,t)},a.size=function(){return this.a.c},re.mN=vo(150),ue.tZ=function(t,n){return ue.Oh(t.a,n)},ue.uZ=function(t){return t.a.a.length},ue.vZ=function(t,n){return ue.fi(t.a,n)},ue.wZ=function(){this.a=new ue.gi},ue.BZ=function(t,n){if(t<0||t>=n)throw We(new ie.HP)},Te(170,209,Y,ue.wZ),a.addAtIndex=function(t,n){ue.BZ(t,this.a.a.length+1),ue.Nh(this.a,t,n)},a.add=function(t){return ue.tZ(this,t)},a.addAllAtIndex=function(t,n){return ue.BZ(t,this.a.a.length+1),ue.Ph(this.a,t,n)},a.addAll=function(t){return ue.Qh(this.a,t)},a.clear=function(){this.a.a=Ke(re.nM,x,1,0,5,1)},a.contains=function(t){return-1!=ue.Vh(this.a,t,0)},a.containsAll=function(t){return ue.jh(this.a,t)},a.getAtIndex=function(t){return ue.BZ(t,this.a.a.length),ue.Th(this.a,t)},a.indexOf=function(t){return ue.Vh(this.a,t,0)},a.isEmpty=function(){return 0==this.a.a.length},a.mb=function(){return new ue.KW(this.a)},a.lastIndexOf=function(t){return ue.Yh(this.a,t)},a.removeAtIndex=function(t){return ue.BZ(t,this.a.a.length),ue.$h(this.a,t)},a.removeAll=function(t){return ue.kh(this.a,t)},a.ob=function(t,n){ue.ai(this.a,t,n)},a.setAtIndex=function(t,n){return ue.BZ(t,this.a.a.length),ue.bi(this.a,t,n)},a.size=function(){return ue.uZ(this)},a.subList=function(t,n){return new ue.YU(this.a,t,n)},a.toArray=function(){return ue.ei(this.a)},a.nb=function(t){return ue.vZ(this,t)},a.jb=function(){return ue.lh(this.a)},re.nN=vo(170),le.A$=function(){le.A$=De,new le.G$,new le.C$("ISO-LATIN-1"),new le.C$("ISO-8859-1")},le.B$=function(t){Se.FU.call(this,t)},Te(110,60,Zn),re.BN=vo(110),le.C$=function(t){le.B$.call(this,t)},Te(111,110,Zn,le.C$),re.zN=vo(111),le.D$=function(t,n,e){var o,r,i,a,s,u,f,l;for(i=0,f=0;f<e;){if(++i,128==(192&(r=t[n+f])))throw We(new ie._Q(oe));if(0==(128&r))++f;else if(192==(224&r))f+=2;else if(224==(240&r))f+=3;else{if(240!=(248&r))throw We(new ie._Q(oe));f+=4}if(f>e)throw We(new ie.GP(oe))}for(a=Ke(re.eK,Vt,5,i,15,1),l=0,s=0,u=0;u<e;){for(0==(128&(r=t[n+u++]))?(s=1,r&=127):192==(224&r)?(s=2,r&=31):224==(240&r)?(s=3,r&=15):240==(248&r)?(s=4,r&=7):248==(252&r)&&(s=5,r&=3);--s>0;){if(128!=(192&(o=t[n+u++])))throw We(new ie._Q("Invalid UTF8 sequence at "+(n+u-1)+", byte="+le.V$(ie.mR(o)).toString(16)));r=r<<6|63&o}l+=Oo(r,a,l)}return a},le.E$=function(t,n,e){if(e<128)return t[n]=(127&e)<<24>>24,1;if(e<Ct)return t[n++]=(e>>6&31|192)<<24>>24,t[n]=(63&e|128)<<24>>24,2;if(e<K)return t[n++]=(e>>12&15|224)<<24>>24,t[n++]=(e>>6&63|128)<<24>>24,t[n]=(63&e|128)<<24>>24,3;if(e<vt)return t[n++]=(e>>18&7|240)<<24>>24,t[n++]=(e>>12&63|128)<<24>>24,t[n++]=(e>>6&63|128)<<24>>24,t[n]=(63&e|128)<<24>>24,4;if(e<zt)return t[n++]=(e>>24&3|248)<<24>>24,t[n++]=(e>>18&63|128)<<24>>24,t[n++]=(e>>12&63|128)<<24>>24,t[n++]=(e>>6&63|128)<<24>>24,t[n]=(63&e|128)<<24>>24,5;throw We(new ie._Q("Character out of range: "+e))},le.F$=function(t){var n,e,o,r,i,a,s;for(a=le.V$(t).length,n=0,i=0;i<a;)i+=(o=Po(t,i,le.V$(t).length))>=K?2:1,o<128?++n:o<Ct?n+=2:o<K?n+=3:o<vt?n+=4:o<zt&&(n+=5);for(e=Ke(re.dK,U,5,n,15,1),s=0,r=0;r<a;)r+=(o=Po(t,r,le.V$(t).length))>=K?2:1,s+=le.E$(e,s,o);return e},le.G$=function(){le.B$.call(this,"UTF-8")},Te(153,110,Zn,le.G$),re.AN=vo(153),re.eK=Ao("C"),re.CN=Ao("S"),re.hK=Ao("I"),re.DN=Ao("Z"),re.fK=Ao("D"),re.gK=Ao("F"),re.dK=Ao("B"),re.iK=Ao("J"),de.Gy(),(a=Re("OCL.Molecule",de.Ky)).CANONIZER_ASSIGN_PARITIES_TO_TETRAHEDRAL_N=de.fv,a.CANONIZER_CONSIDER_DIASTEREOTOPICITY=de.gv,a.CANONIZER_CONSIDER_ENANTIOTOPICITY=de.hv,a.CANONIZER_CONSIDER_STEREOHETEROTOPICITY=de.iv,a.CANONIZER_COORDS_ARE_3D=de.jv,a.CANONIZER_CREATE_PSEUDO_STEREO_GROUPS=de.kv,a.CANONIZER_CREATE_SYMMETRY_RANK=de.lv,a.CANONIZER_DISTINGUISH_RACEMIC_OR_GROUPS=de.mv,a.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS=de.nv,a.CANONIZER_ENCODE_ATOM_SELECTION=de.ov,a.FISCHER_PROJECTION_LIMIT=de.pv,a.STEREO_ANGLE_LIMIT=de.qv,a.VALIDATION_ERRORS_STEREO=de.rv,a.VALIDATION_ERROR_AMBIGUOUS_CONFIGURATION=de.sv,a.VALIDATION_ERROR_ESR_CENTER_UNKNOWN=de.tv,a.VALIDATION_ERROR_OVER_UNDER_SPECIFIED=de.uv,a.cAtomCIPParityNone=de.vv,a.cAtomCIPParityProblem=de.wv,a.cAtomCIPParityRorM=de.xv,a.cAtomCIPParitySorP=de.yv,a.cAtomColorBlue=de.zv,a.cAtomColorDarkGreen=de.Av,a.cAtomColorDarkRed=de.Bv,a.cAtomColorGreen=de.Cv,a.cAtomColorMagenta=de.Dv,a.cAtomColorNone=de.Ev,a.cAtomColorOrange=de.Fv,a.cAtomColorRed=de.Gv,a.cAtomLabel=de.Hv,a.cAtomParity1=de.Iv,a.cAtomParity2=de.Jv,a.cAtomParityIsPseudo=de.Kv,a.cAtomParityNone=de.Lv,a.cAtomParityUnknown=de.Mv,a.cAtomQFAny=de.Nv,a.cAtomQFAromState=de.Ov,a.cAtomQFAromStateBits=de.Pv,a.cAtomQFAromStateShift=de.Qv,a.cAtomQFAromatic=de.Rv,a.cAtomQFCharge=de.Sv,a.cAtomQFChargeBits=de.Tv,a.cAtomQFChargeShift=de.Uv,a.cAtomQFExcludeGroup=de.Vv,a.cAtomQFFlatNitrogen=de.Wv,a.cAtomQFHydrogen=de.Xv,a.cAtomQFHydrogenBits=de.Yv,a.cAtomQFHydrogenShift=de.Zv,a.cAtomQFMatchStereo=de.$v,a.cAtomQFMoreNeighbours=de._v,a.cAtomQFNarrowing=de.aw,a.cAtomQFNeighbourBits=de.bw,a.cAtomQFNeighbourShift=de.cw,a.cAtomQFNeighbours=de.dw,a.cAtomQFNoMoreNeighbours=de.ew,a.cAtomQFNoOfBits=de.fw,a.cAtomQFNot0Hydrogen=de.gw,a.cAtomQFNot0Neighbours=de.hw,a.cAtomQFNot0PiElectrons=de.iw,a.cAtomQFNot1Hydrogen=de.jw,a.cAtomQFNot1Neighbour=de.kw,a.cAtomQFNot1PiElectron=de.lw,a.cAtomQFNot2Hydrogen=de.mw,a.cAtomQFNot2Neighbours=de.nw,a.cAtomQFNot2PiElectrons=de.ow,a.cAtomQFNot2RingBonds=de.pw,a.cAtomQFNot3Hydrogen=de.qw,a.cAtomQFNot3Neighbours=de.rw,a.cAtomQFNot3RingBonds=de.sw,a.cAtomQFNot4Neighbours=de.tw,a.cAtomQFNot4RingBonds=de.uw,a.cAtomQFNotAromatic=de.vw,a.cAtomQFNotChain=de.ww,a.cAtomQFNotCharge0=de.xw,a.cAtomQFNotChargeNeg=de.yw,a.cAtomQFNotChargePos=de.zw,a.cAtomQFPiElectronBits=de.Aw,a.cAtomQFPiElectronShift=de.Bw,a.cAtomQFPiElectrons=de.Cw,a.cAtomQFRingSize=de.Dw,a.cAtomQFRingSizeBits=de.Ew,a.cAtomQFRingSizeShift=de.Fw,a.cAtomQFRingState=de.Gw,a.cAtomQFRingStateBits=de.Hw,a.cAtomQFRingStateShift=de.Iw,a.cAtomQFRxnParityBits=de.Jw,a.cAtomQFRxnParityHint=de.Kw,a.cAtomQFRxnParityInvert=de.Lw,a.cAtomQFRxnParityRacemize=de.Mw,a.cAtomQFRxnParityRetain=de.Nw,a.cAtomQFRxnParityShift=de.Ow,a.cAtomQFSimpleFeatures=de.Pw,a.cAtomRadicalState=de.Qw,a.cAtomRadicalStateD=de.Rw,a.cAtomRadicalStateNone=de.Sw,a.cAtomRadicalStateS=de.Tw,a.cAtomRadicalStateShift=de.Uw,a.cAtomRadicalStateT=de.Vw,a.cBondCIPParityEorP=de.Ww,a.cBondCIPParityNone=de.Xw,a.cBondCIPParityProblem=de.Yw,a.cBondCIPParityZorM=de.Zw,a.cBondParityEor1=de.$w,a.cBondParityNone=de._w,a.cBondParityUnknown=de.ax,a.cBondParityZor2=de.bx,a.cBondQFAllFeatures=de.cx,a.cBondQFAromState=de.dx,a.cBondQFAromStateBits=de.ex,a.cBondQFAromStateShift=de.fx,a.cBondQFAromatic=de.gx,a.cBondQFBondTypes=de.hx,a.cBondQFBondTypesBits=de.ix,a.cBondQFBondTypesShift=de.jx,a.cBondQFBridge=de.kx,a.cBondQFBridgeBits=de.lx,a.cBondQFBridgeMin=de.mx,a.cBondQFBridgeMinBits=de.nx,a.cBondQFBridgeMinShift=de.ox,a.cBondQFBridgeShift=de.px,a.cBondQFBridgeSpan=de.qx,a.cBondQFBridgeSpanBits=de.rx,a.cBondQFBridgeSpanShift=de.sx,a.cBondQFDelocalized=de.tx,a.cBondQFDouble=de.ux,a.cBondQFMatchStereo=de.vx,a.cBondQFMetalLigand=de.wx,a.cBondQFNarrowing=de.xx,a.cBondQFNoOfBits=de.yx,a.cBondQFNotAromatic=de.zx,a.cBondQFNotRing=de.Ax,a.cBondQFRing=de.Bx,a.cBondQFRingSize=de.Cx,a.cBondQFRingSizeBits=de.Dx,a.cBondQFRingSizeShift=de.Ex,a.cBondQFRingState=de.Fx,a.cBondQFRingStateBits=de.Gx,a.cBondQFRingStateShift=de.Hx,a.cBondQFSimpleFeatures=de.Ix,a.cBondQFSingle=de.Jx,a.cBondQFTriple=de.Kx,a.cBondTypeCross=de.Lx,a.cBondTypeDeleted=de.Mx,a.cBondTypeDelocalized=de.Nx,a.cBondTypeDouble=de.Ox,a.cBondTypeDown=de.Px,a.cBondTypeIncreaseOrder=de.Qx,a.cBondTypeMetalLigand=de.Rx,a.cBondTypeSingle=de.Sx,a.cBondTypeTriple=de.Tx,a.cBondTypeUp=de.Ux,a.cChiralityDiastereomers=de.Vx,a.cChiralityEpimers=de.Wx,a.cChiralityIsomerCountMask=de.Xx,a.cChiralityKnownEnantiomer=de.Yx,a.cChiralityMeso=de.Zx,a.cChiralityNotChiral=de.$x,a.cChiralityRacemic=de._x,a.cChiralityUnknown=de.ay,a.cChiralityUnknownEnantiomer=de.by,a.cDefaultAtomValence=de.cy,a.cESRGroupBits=de.dy,a.cESRMaxGroups=de.ey,a.cESRTypeAbs=de.fy,a.cESRTypeAnd=de.gy,a.cESRTypeOr=de.hy,a.cHelperBitCIP=de.iy,a.cHelperBitIncludeNitrogenParities=de.jy,a.cHelperBitNeighbours=de.ky,a.cHelperBitParities=de.ly,a.cHelperBitRings=de.my,a.cHelperBitSymmetryDiastereotopic=de.ny,a.cHelperBitSymmetryEnantiotopic=de.oy,a.cHelperBitSymmetrySimple=de.py,a.cHelperBitsStereo=de.qy,a.cHelperCIP=de.ry,a.cHelperNeighbours=de.sy,a.cHelperNone=de.ty,a.cHelperParities=de.uy,a.cHelperRings=de.vy,a.cHelperSymmetryDiastereotopic=de.wy,a.cHelperSymmetryEnantiotopic=de.xy,a.cHelperSymmetrySimple=de.yy,a.cMaxAtomicNo=de.zy,a.cMaxConnAtoms=de.Ay,a.cMoleculeColorDefault=de.By,a.cMoleculeColorNeutral=de.Cy,a.cRoundedMass=de.Dy,a.fromIDCode=de.Dz,a.fromMolfile=de.Gz,a.fromMolfileWithAtomMap=de.Hz,a.fromSmiles=de.Iz,a.getAngle=de.Rz,a.getAngleDif=de.Sz,a.getAtomicNoFromLabel=de.qA,a.getDefaultAverageBondLength=de.UA,a.isAtomicNoElectronegative=de.ZB,a.isAtomicNoElectropositive=de.$B,a.setDefaultAverageBondLength=de.wD,(a=Re("OCL.Reaction")).create=de.iE,a.fromMolecules=de.jE,a.fromRxn=de.kE,a.fromSmiles=de.lE,(a=Re("OCL.RingCollection")).MAX_SMALL_RING_SIZE=de.LE,a.MODE_SMALL_AND_LARGE_RINGS=de.ME,a.MODE_SMALL_AND_LARGE_RINGS_AND_AROMATICITY=de.NE,a.MODE_SMALL_RINGS_AND_AROMATICITY=de.OE,a.MODE_SMALL_RINGS_ONLY=de.PE,a=Re("OCL.SDFileParser",de.hF),a=Re("OCL.SSSearcher",de.tF),(a=Re("OCL.SSSearcherWithIndex",de.AF)).bitCount=de.BF,a.getHexStringFromIndex=de.DF,a.getIndexFromHexString=de.EF,a.getKeyIDCode=de.FF,a.getSimilarityAngleCosine=de.HF,a.getSimilarityTanimoto=de.IF,(a=Re("OCL.Util",de.MF)).getHoseCodesFromDiastereotopicID=de.NF,(a=Re("java.io.Serializable")).$isInstance=function(t){var n;return null!=t&&(n=typeof t,ie.GR(n,b)||ie.GR(n,y)||ie.GR(n,j)||t.$implements__java_io_Serializable||Array.isArray(t))},ie.KP(),(a=Re("java.lang.Boolean")).$isInstance=function(t){return ie.KP(),ie.GR(b,typeof t)},(a=Re("java.lang.CharSequence")).$isInstance=function(t){return!!ie.GR(typeof t,j)||null!=t&&t.$implements__java_lang_CharSequence},(a=Re("java.lang.Cloneable")).$isInstance=function(t){return null!=t&&(t.$implements__java_lang_Cloneable||Array.isArray(t))},(a=Re("java.lang.Comparable")).$isInstance=function(t){var n;return n=typeof t,!!(ie.GR(n,b)||ie.GR(n,y)||ie.GR(n,j))||null!=t&&t.$implements__java_lang_Comparable},(a=Re("java.lang.Double")).$isInstance=function(t){return ie.GR(y,typeof t)},(a=Re("java.lang.Number")).$isInstance=ie.AQ,(a=Re("java.lang.String")).$isInstance=function(t){return ie.GR(j,typeof t)},(a=Re("java.lang.Throwable")).of=function(t){var n;return null!=t&&(n=t.__java$exception)?n:Qe(t,TypeError)?new ie.sR(t):new ie.JG(t)};var Lo,qo,Jo=(se.nH(),function(t){return se.nH(),function(){return se.rH(t,this,arguments)}}),Qo=Qo=function(t,n,e,o){re.qO();var r=u;function i(){for(var t=0;t<r.length;t++)r[t]()}if(t)try{Jo(i)()}catch(e){t(n,e)}else Jo(i)()};!function(){re.qO();for(var t=u,n=0;n<arguments.length;n++)t.push(arguments[n])}((function(){Ne.HO()})),Lo="permProps",qo=[[["locale","default"],["user.agent","safari"]]],typeof window===w&&typeof window.$gwt===w&&(window.$gwt[Lo]=qo),Qo(i.__errFn,i.__moduleName,i.__moduleBase,i.__softPermutationId,i.__computePropValue),e&&e.permProps&&i.__moduleStartupDone(e.permProps);var Xo=t.OCL;return Xo.version="7.4.0",Xo}(o),t)}(commonjsGlobal)}(openchemlibMinimal);var minimal=openchemlibMinimal;function createInputJSON(t,n){const{levels:e}=n;let o=getGroupedDiastereotopicAtomIDs(t);o=o.filter((t=>"C"===t.atomLabel)).sort((function(t,n){return t.atomLabel===n.atomLabel?n.counter-t.counter:t.atomLabel<n.atomLabel?1:-1}));const r={};for(const t of o){t.hose=getHoseCodesFromDiastereotopicID(minimal.Molecule.fromIDCode(t.oclID),{maxSphereSize:e[0]});for(const n of t.atoms)r[n]=t.oclID}return{id:t.getIDCode(),atom:r,diaIDs:o}}function queryByHose(t,n,e){const{levels:o}=e;o.sort(((t,n)=>n-t));const r=[];for(const e of t.diaIDs){let t,i=0;for(;!t&&i<o.length;)n[o[i]]&&(t=n[o[i]][e.hose[o[i]]]),i++;t||(t=[null],i=0);for(const n of e.atoms){let o={diaIDs:[e.oclID]};o.delta=t[0],o.atomIDs=[n],o.nbAtoms=1,r.push(o)}}return r}const cache={};async function loadDB(t="https://www.lactame.com/lib/nmr-processing/data/20210711/carbon.js"){if(cache[t])return cache[t];const n=await fetch(t);return cache[t]=await n.json(),cache[t]}async function predictCarbon(t,n={}){let{levels:e=[3,2,1,0],url:o,database:r}=n;r=r||await loadDB(o),t.addImplicitHydrogens(),t.addMissingChirality(),addDiastereotopicMissingChirality(t);const i=t.toMolfile(),a=createInputJSON(t,{levels:e});const s=formatSignals(queryByHose(a,r,{levels:e})),u=joinSignalByDiaID(s);return{molfile:i,diaIDs:a.diaIDs.map((t=>t.diaId)),joinedSignals:u,signals:s,ranges:signalsToRanges(u)}}function formatSignals(t){let n=[];for(const e of t){const{atomIDs:t,nbAtoms:o,delta:r,diaIDs:i}=e;n.push({delta:r,assignment:t,diaID:i,nbAtoms:o,j:[]})}return n}function joinSignalByDiaID(t){let n={};for(let e of t){let t=e.diaID[0];n[t]?(n[t].nbAtoms+=e.nbAtoms,n[t].assignment.push(...e.assignment)):n[t]=JSON.parse(JSON.stringify(e))}return Object.values(n)}var src={},fftlib={};!function(t){(function(){var n,e="0.3.0",o="2013-03";(n=t).toString=function(){return"version "+e+", released "+o};for(var r=0,i=null,a=null,s={init:function(t){if(0===t||0!=(t&t-1))throw new Error("init: radix-2 required");r=t,s._initArray(),s._makeBitReversalTable(),s._makeCosSinTable()},fft1d:function(t,n){s.fft(t,n,1)},ifft1d:function(t,n){var e=1/r;s.fft(t,n,-1);for(var o=0;o<r;o++)t[o]*=e,n[o]*=e},bt1d:function(t,n){s.fft(t,n,-1)},fft2d:function(t,n){for(var e=[],o=[],i=0,a=0;a<r;a++){i=a*r;for(var u=0;u<r;u++)e[u]=t[u+i],o[u]=n[u+i];s.fft1d(e,o);for(var f=0;f<r;f++)t[f+i]=e[f],n[f+i]=o[f]}for(var l=0;l<r;l++){for(var c=0;c<r;c++)i=l+c*r,e[c]=t[i],o[c]=n[i];s.fft1d(e,o);for(var h=0;h<r;h++)t[i=l+h*r]=e[h],n[i]=o[h]}},ifft2d:function(t,n){for(var e=[],o=[],i=0,a=0;a<r;a++){i=a*r;for(var u=0;u<r;u++)e[u]=t[u+i],o[u]=n[u+i];s.ifft1d(e,o);for(var f=0;f<r;f++)t[f+i]=e[f],n[f+i]=o[f]}for(var l=0;l<r;l++){for(var c=0;c<r;c++)i=l+c*r,e[c]=t[i],o[c]=n[i];s.ifft1d(e,o);for(var h=0;h<r;h++)t[i=l+h*r]=e[h],n[i]=o[h]}},fft:function(t,n,e){for(var o,s,u,f,l,c,h,w,g,m=r>>2,d=0;d<r;d++)d<(f=i[d])&&(l=t[d],t[d]=t[f],t[f]=l,l=n[d],n[d]=n[f],n[f]=l);for(var p=1;p<r;p<<=1){s=0,o=r/(p<<1);for(var G=0;G<p;G++){c=a[s+m],h=e*a[s];for(var b=G;b<r;b+=p<<1)w=c*t[u=b+p]+h*n[u],g=c*n[u]-h*t[u],t[u]=t[b]-w,t[b]+=w,n[u]=n[b]-g,n[b]+=g;s+=o}}},_initArray:function(){i="undefined"!=typeof Uint32Array?new Uint32Array(r):[],a="undefined"!=typeof Float64Array?new Float64Array(1.25*r):[]},_paddingZero:function(){},_makeBitReversalTable:function(){var t=0,n=0,e=0;for(i[0]=0;++t<r;){for(e=r>>1;e<=n;)n-=e,e>>=1;n+=e,i[t]=n}},_makeCosSinTable:function(){var t=r>>1,n=r>>2,e=r>>3,o=t+n,i=Math.sin(Math.PI/r),s=2*i*i,u=Math.sqrt(s*(2-s)),f=a[n]=1,l=a[0]=0;i=2*s;for(var c=1;c<e;c++)s+=i*(f-=s),u-=i*(l+=u),a[c]=l,a[n-c]=f;0!==e&&(a[e]=Math.sqrt(.5));for(var h=0;h<n;h++)a[t-h]=a[h];for(var w=0;w<o;w++)a[w+t]=-a[w]}},u=["init","fft1d","ifft1d","fft2d","ifft2d"],f=0;f<u.length;f++)n[u[f]]=s[u[f]];return n.bt=s.bt1d,n.fft=s.fft1d,n.ifft=s.ifft1d,n}).call(commonjsGlobal)}(fftlib);var FFT=fftlib,FFTUtils$1={DEBUG:!1,ifft2DArray:function(t,n,e){var o=new Array(n*e),r=n/2,i=2*(e-1);FFT.init(r);for(var a={re:new Array(r),im:new Array(r)},s=0;s<e;s++){for(var u=r-1;u>=0;u--)a.re[u]=t[2*u*e+s],a.im[u]=t[(2*u+1)*e+s];FFT.bt(a.re,a.im);for(u=r-1;u>=0;u--)o[2*u*e+s]=a.re[u],o[(2*u+1)*e+s]=a.im[u]}var f=new Array(r*i);FFT.init(i);var l={re:new Array(i),im:new Array(i)},c=i*r;for(u=0;u<n;u+=2){l.re[0]=o[u*e],l.im[0]=o[(u+1)*e];for(s=1;s<e;s++)l.re[s]=o[u*e+s],l.im[s]=o[(u+1)*e+s],l.re[i-s]=o[u*e+s],l.im[i-s]=-o[(u+1)*e+s];FFT.bt(l.re,l.im);var h=u/2*i;for(s=i-1;s>=0;s--)f[h+s]=l.re[s]/c}return f},fft2DArray:function(t,n,e,o){Object.assign({},{inplace:!0});var r=e/2+1,i=2*n,a=new Array(i*r);FFT.init(e);for(var s,u,f,l,c,h={re:new Array(e),im:new Array(e)},w={re:new Array(e),im:new Array(e)},g={re:new Array(e),im:new Array(e)},m=0;m<n/2;m++){s=2*m*e,h.re=t.slice(s,s+e),s=(2*m+1)*e,h.im=t.slice(s,s+e),FFT.fft1d(h.re,h.im),this.reconstructTwoRealFFT(h,w,g),u=4*m*r,f=(4*m+1)*r,l=(4*m+2)*r,c=(4*m+3)*r;for(var d=r-1;d>=0;d--)a[u+d]=w.re[d],a[f+d]=w.im[d],a[l+d]=g.re[d],a[c+d]=g.im[d]}w=null,g=null;var p=new Array(i*r);FFT.init(n);for(var G={re:new Array(n),im:new Array(n)},b=r-1;b>=0;b--){for(m=n-1;m>=0;m--)G.re[m]=a[2*m*r+b],G.im[m]=a[(2*m+1)*r+b],isNaN(G.re[m])&&(G.re[m]=0),isNaN(G.im[m])&&(G.im[m]=0);FFT.fft1d(G.re,G.im);for(m=n-1;m>=0;m--)p[2*m*r+b]=G.re[m],p[(2*m+1)*r+b]=G.im[m]}return p},reconstructTwoRealFFT:function(t,n,e){var o,r,i,a,s,u=t.re.length;n.re[0]=t.re[0],n.im[0]=0,e.re[0]=t.im[0],e.im[0]=0;for(var f=u/2;f>0;f--)s=u-f,o=.5*(t.re[f]-t.re[s]),r=.5*(t.re[f]+t.re[s]),i=.5*(t.im[f]-t.im[s]),a=.5*(t.im[f]+t.im[s]),n.re[f]=r,n.im[f]=i,n.re[s]=r,n.im[s]=-i,e.re[f]=a,e.im[f]=-o,e.re[s]=a,e.im[s]=o},convolute2DI:function(t,n,e,o){for(var r,i,a=0;a<e/2;a++)for(var s=0;s<o;s++)r=t[2*a*o+s]*n[2*a*o+s]-t[(2*a+1)*o+s]*n[(2*a+1)*o+s],i=t[2*a*o+s]*n[(2*a+1)*o+s]+t[(2*a+1)*o+s]*n[2*a*o+s],t[2*a*o+s]=r,t[(2*a+1)*o+s]=i},convolute:function(t,n,e,o,r){for(var i=new Array(o*e),a=0;a<e*o;a++)i[a]=t[a];i=this.fft2DArray(i,e,o);var s,u=n.length,f=n[0].length,l=new Array(o*e);for(a=0;a<o*e;a++)l[a]=0;for(var c=Math.floor((u-1)/2),h=Math.floor((f-1)/2),w=0;w<u;w++){s=(w-c+e)%e;for(var g=0;g<f;g++)l[s*o+(g-h+o)%o]=n[w][g]}l=this.fft2DArray(l,e,o);var m=2*e,d=o/2+1;return this.convolute2DI(i,l,m,d),this.ifft2DArray(i,m,d)},toRadix2:function(t,n,e){var o,r,i,a,s=e,u=n;if(0===e||0!=(e&e-1)){for(s=0;e>>++s!=0;);s=1<<s}if(0===n||0!=(n&n-1)){for(u=0;n>>++u!=0;);u=1<<u}if(u==n&&s==e)return{data:t,rows:n,cols:e};var f=new Array(u*s),l=Math.floor((u-n)/2)-n,c=Math.floor((s-e)/2)-e;for(o=0;o<u;o++)for(i=o*s,a=(o-l)%n*e,r=0;r<s;r++)f[i+r]=t[a+(r-c)%e];return{data:f,rows:u,cols:s}},crop:function(t,n,e,o,r,i){if(n==o&&e==r)return t;Object.assign({},i);var a,s,u,f,l=new Array(r*o),c=Math.floor((n-o)/2),h=Math.floor((e-r)/2);for(u=0;u<o;u++)for(a=u*r,s=(u+c)*e,f=0;f<r;f++)l[a+f]=t[s+(f+h)];return l}},FFTUtils_1=FFTUtils$1,FFTUtils=src.FFTUtils=FFTUtils_1;function matrix2Array(t){let n,e,o=t;if("number"!=typeof t[0]){n=t.length,e=t[0].length,o=new Array(n*e);for(let r=0;r<n;r++)for(let n=0;n<e;n++)o[r*e+n]=t[r][n]}else{let o=Math.sqrt(t.length);Number.isInteger(o)&&(n=o,e=o)}return{data:o,rows:n,cols:e}}function convolutionFFT(t,n,e){let o,r,i=matrix2Array(t),a=i.data,s=Object.assign({normalize:!1,divisor:1,rows:i.rows,cols:i.cols},e);if(!s.rows||!s.cols)throw new Error(`Invalid number of rows or columns ${o} ${r}`);o=s.rows,r=s.cols;let u=s.divisor,f=n.length,l=n[0].length;if(s.normalize){u=0;for(let t=0;t<f;t++)for(let e=0;e<l;e++)u+=n[t][e]}if(0===u)throw new RangeError("convolution: The divisor is equal to zero");let c=FFTUtils.toRadix2(a,o,r),h=FFTUtils.convolute(c.data,n,c.rows,c.cols);if(h=FFTUtils.crop(h,c.rows,c.cols,o,r),0!==u&&1!==u)for(let t=0;t<h.length;t++)h[t]/=u;return h}function convolutionDirect(t,n,e){let o,r,i=matrix2Array(t),a=i.data,s=Object.assign({normalize:!1,divisor:1,rows:i.rows,cols:i.cols},e);if(!s.rows||!s.cols)throw new Error(`Invalid number of rows or columns ${o} ${r}`);o=s.rows,r=s.cols;let u,f,l,c,h,w=s.divisor,g=n.length,m=n[0].length;if(s.normalize){w=0;for(let t=0;t<g;t++)for(let e=0;e<m;e++)w+=n[t][e]}if(0===w)throw new RangeError("convolution: The divisor is equal to zero");let d=new Array(o*r),p=Math.floor(g/2),G=Math.floor(m/2);for(let t=0;t<o;t++)for(let e=0;e<r;e++){f=0;for(let i=0;i<g;i++)for(let s=0;s<m;s++)l=n[g-i-1][m-s-1],c=(t+i-p+o)%o,h=(e+s-G+r)%r,u=c*r+h,f+=a[u]*l;u=t*r+e,d[u]=f/w}return d}src.FFT=fftlib;class DisjointSet{constructor(){this.nodes=new Map}add(t){var n=this.nodes.get(t);return n||(n=new DisjointSetNode(t),this.nodes.set(t,n)),n}union(t,n){const e=this.find(t),o=this.find(n);e!==o&&(e.rank<o.rank?e.parent=o:e.rank>o.rank?o.parent=e:(o.parent=e,e.rank++))}find(t){for(var n=t;null!==n.parent;)n=n.parent;for(var e=t;null!==e.parent;){var o=e;e=e.parent,o.parent=n}return n}connected(t,n){return this.find(t)===this.find(n)}}var DisjointSet_1=DisjointSet;function DisjointSetNode(t){this.value=t,this.parent=null,this.rank=0}const direction8X$2=[-1,-1,0,1,-1,0,1,1],direction8Y$2=[0,-1,-1,-1,1,1,1,0],neighbours8$1=[null,null,null,null,null,null,null,null],direction4X$1=[-1,0,1,0],direction4Y$1=[0,-1,0,1],neighbours4$1=[null,null,null,null];function drainLabelling(t,n,e={}){const{neighbours:o=8,width:r,height:i}=e;let a,s,u;if(8===o)a=direction8X$2,s=direction8Y$2,u=neighbours8$1;else{if(4!==o)throw new RangeError(`unsupported neighbours count: ${o}`);a=direction4X$1,s=direction4Y$1,u=neighbours4$1}let f=new Array(i*r);for(let e=0,o=0;e<i;e++)for(let i=0;i<r;i++,o++)f[o]={value:t[o],row:e,col:i,mask:n[o]};f.sort(((t,n)=>t.value-n.value));const l=n.length,c=new Array(l),h=new Int16Array(l),w=new DisjointSet_1;for(let e=0,o=1;e<n.length;e++){let n=f[e];if(!n.mask)continue;let{row:l,col:h,value:g}=n,m=h+l*r;c[m]||(c[m]=w.add(o++));for(let n=0;n<u.length;n++){let e=h+a[n],o=l+s[n];if(e>=0&&o>=0&&e<r&&o<i){if(!c[e+o*r]){g<t[e+o*r]&&(c[e+o*r]=c[m])}}}}for(let t=0;t<i;t++)for(let e=0;e<r;e++){let o=e+t*r;n[o]&&(h[o]=w.find(c[o]).value)}return h}const direction4X=[-1,0],direction4Y=[0,-1],neighbours4=[null,null],direction8X$1=[-1,-1,0,1],direction8Y$1=[0,-1,-1,-1],neighbours8=[null,null,null,null];function floodFillLabelling(t,n,e,o){const r=(o=o||{}).neighbours||8;let i,a,s;if(8===r)i=direction8X$1,a=direction8Y$1,s=neighbours8;else{if(4!==r)throw new RangeError(`unsupported neighbours count: ${r}`);i=direction4X,a=direction4Y,s=neighbours4}const u=t.length,f=new Array(u),l=new Int16Array(u),c=new DisjointSet_1;let h,w=1;for(let o=0;o<e;o++)for(let r=0;r<n;r++){let u=null;if(h=r+o*n,t[h]){for(let t=0;t<s.length;t++){let l=r+i[t],c=o+a[t];if(l>=0&&c>=0&&l<n&&c<e){let e=f[l+c*n];e?(s[t]=e,(!u||s[t].value<u.value)&&(u=s[t])):s[t]=null}}if(u){f[h]=u;for(let t=0;t<s.length;t++)s[t]&&s[t]!==u&&c.union(u,s[t])}else f[h]=c.add(w++)}}for(let o=0;o<e;o++)for(let e=0;e<n;e++)h=e+o*n,t[h]&&(l[h]=c.find(f[h]).value);return l}const smallFilter$1=[[0,0,1,2,2,2,1,0,0],[0,1,4,7,7,7,4,1,0],[1,4,5,3,0,3,5,4,1],[2,7,3,-12,-23,-12,3,7,2],[2,7,0,-23,-40,-23,0,7,2],[2,7,3,-12,-23,-12,3,7,2],[1,4,5,3,0,3,5,4,1],[0,1,3,7,7,7,3,1,0],[0,0,1,2,2,2,1,0,0]];function findPeaks2DRegion(t,n={}){let{nStdDev:e=3,kernel:o=smallFilter$1,originalData:r=matrix2Array(t).data,filteredData:i,rows:a,cols:s,labelling:u="drain"}=n,f=matrix2Array(t),l=f.data;if(a&&s||(a=f.rows,s=f.cols),!a||!s)throw new Error(`Invalid number of rows or columns ${a} ${s}`);let c=i;c||(c=convolutionFFT(l,o,n));let h=0;for(let t=s*a-2;t>=0;t--)h+=Math.pow(c[t]-c[t+1],2);h=-Math.sqrt(h)*e/a;let w,g=new Uint16Array(s*a);for(let t=c.length-1;t>=0;t--)c[t]<h&&(g[t]=1);switch(u.toLowerCase()){case"drain":w=drainLabelling(c,g,{neighbours:8,width:s,height:a});break;case"floodfill":w=floodFillLabelling(g,s,a,{neighbours:8});break;default:throw new Error(`labelling ${u} does not support`)}return extractPeaks(w,{data:l,nCols:s,originalData:r})}function extractPeaks(t,n){const{data:e,nCols:o,originalData:r}=n;let i,a,s,u={};for(let n=0;n<t.length;n++)0!==t[n]&&(a=n%o,i=(n-a)/o,u[t[n]]?(s=u[t[n]],s.x+=a*e[n],s.y+=i*e[n],s.z+=r[n],a<s.minX&&(s.minX=a),a>s.maxX&&(s.maxX=a),i<s.minY&&(s.minY=i),i>s.maxY&&(s.maxY=i)):u[t[n]]={x:a*e[n],y:i*e[n],z:r[n],minX:a,maxX:a,minY:i,maxY:i});let f=Object.keys(u),l=new Array(f.length);for(let t=0;t<f.length;t++){l[t]=u[f[t]];let n=Math.abs(l[t].z);l[t].x/=n,l[t].y/=n}return l}const direction8X=[-1,-1,-1,0,0,1,1,1],direction8Y=[-1,0,1,-1,1,-1,0,1],direction16X=[-2,-2,-2,-2,-2,-1,-1,0,0,1,1,2,2,2,2,2],direction16Y=[-2,-1,0,1,2,-2,2,-2,2,-2,2,-2,-1,0,1,2];function determineRealTop(t,n){let{nCols:e,absoluteData:o,originalData:r,minX:i,maxX:a,minY:s,maxY:u}=n;for(let n=0;n<t.length;n++){let f=Math.round(t[n].x),l=Math.round(t[n].y),c=f+l*e,{index:h,isMax:w}=determineMax(o,{xIndex:f,yIndex:l,nCols:e,shell:1});c=w?h:determineMax(o,{xIndex:f,yIndex:l,nCols:e,shell:2}).index;let g=fitGaussian(r,{nCols:e,index:c,minY:s,maxY:u,minX:i,maxX:a});t[n]=Object.assign(t[n],g)}return t}function determineMax(t,n){let{xIndex:e,yIndex:o,shell:r,nCols:i}=n,a=e+o*i,[s,u]=r>1?[direction16X,direction16Y]:[direction8X,direction8Y],f=!1;for(let n=0;n<s.length;n++){let r=e+s[n],l=o+u[n];if(t[r+l*i]>=t[a]){f=!0;let n=r+l*i;for(let e=0;e<direction8Y.length;e++){if(t[r+direction8X[e]+(l+direction8Y[e])*i]>t[n]){f=!1;break}}f&&(a=n)}}return{index:a,isMax:f}}function fitGaussian(t,n){let{nCols:e,index:o,minY:r,maxY:i,minX:a,maxX:s}=n,u=(s-a)/(e-1),f=(i-r)/(t.length/e-1),l=o%e,c=(o-l)/e,h=Number.MIN_SAFE_INTEGER,w=new Array(direction8X.length+1),g=new Array(direction8X.length+1);for(let n=-1,o=0;n<2;n++)for(let r=-1;r<2;r++,g[o]=o++){let o=t[l+r+(c+n)*e];h<o&&(h=o),w[1+r+3*(1+n)]=o}for(let t=0;t<w.length;t++)w[t]/=h;let m=[2,2,1.5,1,1],d=[0,0,-1.5,.001,.001],p=[1,1,w[4],.2,.2],G=levenbergMarquardt({x:g,y:w},paramGaussian2D(u,f,3),{damping:1.5,maxIterations:100,errorTolerance:1e-8,initialValues:p,gradientDifference:[1e-4,1e-4,.001,.001,.001],maxValues:m,minValues:d}).parameterValues;return{x:G[0]+l-1,y:G[1]+c-1,z:G[2]*h}}function paramGaussian2D(t,n,e){return function(o){return function(r){let i=o.length/5,a=0,s=r%e,u=(r-s)/e;for(let e=0;e<i;e++)a+=o[e+2*i]*Gaussian2D.fct((s-o[e])*t,(u-o[e+i])*n,o[e+3*i],o[e+4*i]);return a}}}function getKernel(t={}){let{sigma:n=1.4,xLength:e=9,yLength:o=9}=t,r=-40/laplacianOfGaussian(0,0,n);const i=(e-1)/2,a=(o-1)/2;let s=new Array(e);for(let t=0;t<e;t++){s[t]=new Array(o);for(let e=0;e<o;e++)s[t][e]=laplacianOfGaussian(t-i,e-a,n)*r}return s}const laplacianOfGaussian=(t,n,e)=>{let o=-(Math.pow(t,2)+Math.pow(n,2))/2/Math.pow(e,2);return-1/Math.PI/Math.pow(e,4)*(1+o)*Math.exp(o)};let diagonalError=.05,tolerance=.05;function clean(t,n){let e=Number.NEGATIVE_INFINITY;for(let n=t.length-1;n>=0;n--)Math.abs(t[n].z)>e&&(e=Math.abs(t[n].z));e*=n;for(let n=t.length-1;n>=0;n--)Math.abs(t[n].z)<e&&t.splice(n,1);return t}function enhanceSymmetry(t){let n,e=initializeProperties(t),o=t.slice();for(let t=o.length-1;t>=0;t--){let n=o[t];if(n.peaks.length>1&&e[t][1]++,1===e[t][0]){let r=exist(o,e,n,-1,!0);r>=0&&(e[t][1]+=2,e[r][1]+=2)}}for(let t=o.length-1;t>=0;t--){let r=o[t];0===e[t][0]&&(n=checkCrossPeaks(o,e,r,!0),e[t][1]+=n)}let r=0;for(let t=o.length-1;t>=0;t--)0!==e[t][0]&&e[t][1]>2&&(r++,r+=completeMissingIfNeeded(o,e,o[t],e[t])),e[t][1]>=2&&0===e[t][0]&&r++;let i=new Array(r);r--;for(let t=o.length-1;t>=0;t--)(0!==e[t][0]&&e[t][1]>2||0===e[t][0]&&e[t][1]>1)&&(i[r--]=o[t]);return i}function completeMissingIfNeeded(t,n,e,o){let r,i,a=0,s=null,u=null;exist(t,n,e,-o[0],!0)<0&&(s={nucleusX:e.nucleusX,nucleusY:e.nucleusY},s.resolutionX=e.resolutionX,s.resolutionY=e.resolutionY,s.shiftX=e.shiftY,s.shiftY=e.shiftX,s.peaks=[{x:e.shiftY,y:e.shiftX,z:1}],t.push(s),u=[-o[0],o[1]],n.push(u),a++);let f=!1,l=!1;for(r=t.length-1;r>=0;r--)i=t[r],0===n[r][0]&&(Math.abs(i.shiftX-e.shiftX)<diagonalError&&(f=!0),Math.abs(i.shiftY-e.shiftY)<diagonalError&&(l=!0));return!1===f&&(s={nucleusX:e.nucleusX,nucleusY:e.nucleusY},s.resolutionX=e.resolutionX,s.resolutionY=e.resolutionY,s.shiftX=e.shiftX,s.shiftY=e.shiftX,s.peaks=[{x:e.shiftX,y:e.shiftX,z:1}],t.push(s),u=[0,o[1]],n.push(u),a++),!1===l&&(s={nucleusX:e.nucleusX,nucleusY:e.nucleusY},s.resolutionX=e.resolutionX,s.resolutionY=e.resolutionY,s.shiftX=e.shiftY,s.shiftY=e.shiftY,s.peaks=[{x:e.shiftY,y:e.shiftY,z:1}],t.push(s),u=[0,o[1]],n.push(u),a++),a}function checkCrossPeaks(t,n,e,o){let r,i=0,a=4*e.shiftX,s=[],u=[];for(let f=t.length-1;f>=0;f--)r=t[f],0!==n[f][0]&&(Math.abs(r.shiftX-e.shiftX)<diagonalError?(i++,o&&n[f][1]++,s.push(f),a+=r.shiftX):Math.abs(r.shiftY-e.shiftY)<diagonalError&&(i++,o&&n[f][1]++,u.push(f),a+=r.shiftY));if(a/=s.length+u.length+4,s.length>0)for(let n=s.length-1;n>=0;n--)t[s[n]].shiftX=a;if(u.length>0)for(let n=u.length-1;n>=0;n--)t[u[n]].shiftY=a;return e.shiftX=a,e.shiftY=a,i}function exist(t,n,e,o,r){for(let i=t.length-1;i>=0;i--)if(n[i][0]===o&&distanceTo(e,t[i],r)<tolerance){if(r){let n=e.shiftX,o=t[i].shiftX;t[i].shiftY=n,e.shiftY=o}else{let n=(t[i].shiftX+e.shiftX)/2,o=(t[i].shiftY+e.shiftY)/2;t[i].shiftX=n,t[i].shiftY=o,e.shiftX=n,e.shiftY=o}return i}return-1}function initializeProperties(t){let n=new Array(t.length);for(let e=t.length-1;e>=0;e--)if(n[e]=[0,0],Math.abs(t[e].shiftX-t[e].shiftY)<=diagonalError){n[e][1]=1;let o=(2*t[e].shiftX+t[e].shiftY)/3;t[e].shiftX=o,t[e].shiftY=o}else t[e].shiftX-t[e].shiftY>0?n[e][0]=1:n[e][0]=-1;return n}function distanceTo(t,n,e){return e?Math.sqrt(Math.pow(t.shiftX-n.shiftY,2)+Math.pow(t.shiftY-n.shiftX,2)):Math.sqrt(Math.pow(t.shiftX-n.shiftX,2)+Math.pow(t.shiftY-n.shiftY,2))}const smallFilter=[[0,0,1,2,2,2,1,0,0],[0,1,4,7,7,7,4,1,0],[1,4,5,3,0,3,5,4,1],[2,7,3,-12,-23,-12,3,7,2],[2,7,0,-23,-40,-23,0,7,2],[2,7,3,-12,-23,-12,3,7,2],[1,4,5,3,0,3,5,4,1],[0,1,3,7,7,7,3,1,0],[0,0,1,2,2,2,1,0,0]];function xyzAutoPeaksPicking(t,n={}){let{sizeToPad:e=14,realTopDetection:o=!0,thresholdFactor:r=.5,nucleus:i=["1H","1H"],observeFrequencies:a,enhanceSymmetry:s=!1,clean:u=!0,maxPercentCutOff:f=.03,tolerances:l=[24,24],convolutionByFFT:c=!0,kernel:h}=n;r=0===r?1:Math.abs(r);let w=t.z[0].length,g=t.z.length;g<e&&(w=(t=padData(t,{width:e})).z[0].length,g=t.z.length);let m=new Float64Array(w*g),d=new Float64Array(w*g);for(let n=0;n<g;n++){let e=t.z[n];for(let t=0;t<w;t++){let o=n*w+t;m[o]=Math.abs(e[t]),d[o]=e[t]}}let p=h?getKernel(h):smallFilter,G=findPeaks2DRegion(m,{originalData:d,filteredData:c?convolutionFFT(m,p,{rows:g,cols:w}):convolutionDirect(m,p,{rows:g,cols:w}),rows:g,cols:w,nStdDev:r});u&&(G=clean(G,f));let b=createSignals2D$1(G,{nRows:g,nCols:w,minX:t.minX,maxX:t.maxX,minY:t.minY,maxY:t.maxY,absoluteData:m,originalData:d,tolerances:l,nucleus:i,observeFrequencies:a,realTopDetection:o});return s&&(b=enhanceSymmetry(b)),b}const createSignals2D$1=(t,n)=>{let{nCols:e,nRows:o,absoluteData:r,originalData:i,observeFrequencies:a,tolerances:s,nucleus:u,realTopDetection:f,minY:l,maxY:c,minX:h,maxX:w}=n,[g,m]=u,[d,p]=s,[G,b]=a,y=(c-l)/(o-1),j=(w-h)/(e-1);f&&(t=determineRealTop(t,{nCols:e,absoluteData:r,originalData:i,minX:h,maxX:w,minY:l,maxY:c}));for(let n=t.length-1;n>=0;n--){let{x:e,y:o}=t[n];t[n].x=h+j*e,t[n].y=l+y*o,t[n].minX=h+j*t[n].minX,t[n].minY=l+y*t[n].minY,t[n].maxX=h+j*t[n].maxX,t[n].maxY=l+y*t[n].maxY,(t[n].y<-1||t[n].y>=210)&&t.splice(n,1)}let N=[];for(let n=0;n<t.length;n++)for(let e=n;e<t.length;e++)Math.abs(t[n].x-t[e].x)*G<d&&Math.abs(t[n].y-t[e].y)*b<p?N.push(1):N.push(0);let H=src$1(N),v=[];if(H)for(let n=0;n<H.length;n++){let e={nucleusX:g,nucleusY:m};e.resolutionX=j,e.resolutionY=y;let o=[];e.shiftX=0,e.shiftY=0;let r=[Number.MAX_VALUE,0],i=[Number.MAX_VALUE,0],a=0;for(let s=0;s<H[n].length;s++)1===H[n][s]&&(o.push(t[s]),e.shiftX+=t[s].x*t[s].z,e.shiftY+=t[s].y*t[s].z,a+=t[s].z,t[s].minX<r[0]&&(r[0]=t[s].minX),t[s].maxX>r[1]&&(r[1]=t[s].maxX),t[s].minY<i[0]&&(i[0]=t[s].minY),t[s].maxY>i[1]&&(i[1]=t[s].maxY));e.fromTo=[{from:r[0],to:r[1]},{from:i[0],to:i[1]}],e.shiftX/=a,e.shiftY/=a,e.peaks=o,v.push(e)}return v},padData=(t,n={})=>{let{minX:e,maxX:o,minY:r,maxY:i}=t,{width:a}=n,s=t.z[0].length,u=t.z.length,f=(i-r)/(u-1),l=(o-e)/(s-1),c=a-u,h=Math.max(a-s,0);h%2&&h++,c%2&&c++;let w=h/2,g=c/2,m=Matrix.zeros(u+c,s+h);for(let n=0;n<u;n++)for(let e=0;e<s;e++)m.set(n+g,e+w,t.z[n][e]);return{z:m.to2DArray(),minX:e-w*l,maxX:o+w*l,minY:r-g*f,maxY:i+g*f}},gyromagneticRatio={"1H":267522187.44,"2H":41065e3,"3H":285350800,"3He":-203789e3,"7Li":103962e3,"13C":67282840,"14N":19331e3,"15N":-27116e3,"17O":-36264e3,"19F":251662e3,"23Na":70761e3,"27Al":69763e3,"29Si":-5319e4,"31P":108291e3,"57Fe":8681e3,"63Cu":71118e3,"67Zn":16767e3,"129Xe":-73997e3},defaultOptions={reference:0,referenceMaxShiftError:.08,tolerances:[10,100],nucleus:["1H","1H"],observeFrequencies:[400,400],jAnalyzer:{jAxisKey:{jAxis:"y",intensity:"z"}}};function xyzJResAnalyzer(t,n={}){let e=assignDeep({},defaultOptions,n),{reference:o,referenceMaxShiftError:r}=e,i=compilePattern(t,e),a=[];for(let t=0;t<i.length;t++){let n=i[t].shiftY;Math.abs(n-o)>r||a.push(i[t])}return a}function compilePattern(t,n={}){let{observeFrequencies:e,tolerances:o,nucleus:r,jAnalyzer:i}=n,a={observeFrequencies:e,tolerances:o,nucleus:r,dx:t[0].resolutionX,dy:t[0].resolutionY};for(let n=0;n<t.length;n++){let o=t[n],r=o.peaks;o.nbPeaks=o.peaks.length,o.multiplicity="",o.pattern="",o.delta1=o.shiftY,o.observe=e[1],o.integralData={from:Number.MAX_SAFE_INTEGER,to:Number.MIN_SAFE_INTEGER};for(let t=0;t<r.length;t++)r[t].width||(r[t].width=.02);r.sort(((t,n)=>t.y-n.y))}for(let n=0;n<t.length;n++)if(jAnalyzer.compilePattern(t[n],i),t[n].maskPattern&&"m"!==t[n].multiplicity&&""!==t[n].multiplicity){let e=[];for(let o=t[n].maskPattern.length-1;o>=0;o--)if(!1===t[n].maskPattern[o]){let r=t[n].peaks.splice(o,1)[0];e.push(r),t[n].mask.splice(o,1),t[n].mask2.splice(o,1),t[n].maskPattern.splice(o,1),t[n].nbPeaks--}if(e.length>0){e.reverse();let n=createSignals2D(e,a);for(let e=0;e<n.length;e++)t.push(n[e])}}return t.sort(((t,n)=>n.shiftX-t.shiftX)),t}function createSignals2D(t,n){let{observeFrequencies:e,tolerances:o,nucleus:r,dx:i,dy:a}=n,[s,u]=r,[f,l]=o,[c,h]=e,w=[];for(let n=0;n<t.length;n++)for(let e=n;e<t.length;e++)Math.abs(t[n].x-t[e].x)*c<f&&Math.abs(t[n].y-t[e].y)*h<l?w.push(1):w.push(0);let g=src$1(w),m=[];if(g)for(let n=0;n<g.length;n++){let e={nucleusX:s,nucleusY:u,integralData:{from:Number.MAX_SAFE_INTEGER,to:Number.MIN_SAFE_INTEGER},nbPeaks:0,multiplicity:"",pattern:""};e.observe=h,e.resolutionX=i,e.resolutionY=a;let o=[];e.shiftX=0,e.shiftY=0;let r=[Number.MAX_VALUE,0],f=[Number.MAX_VALUE,0],l=0;for(let i=g[n].length-1;i>=0;i--)1===g[n][i]&&(e.nbPeaks++,t[i].width||(t[i].width=.02),o.push(t[i]),e.shiftX+=t[i].x*t[i].z,e.shiftY+=t[i].y*t[i].z,l+=t[i].z,t[i].minX<r[0]&&(r[0]=t[i].minX),t[i].maxX>r[1]&&(r[1]=t[i].maxX),t[i].minY<f[0]&&(f[0]=t[i].minY),t[i].maxY>f[1]&&(f[1]=t[i].maxY));e.fromTo=[{from:r[0],to:r[1]},{from:f[0],to:f[1]}],e.shiftX/=l,e.shiftY/=l,e.delta1=e.shiftY,e.peaks=o,m.push(e)}return m}exports.couplingPatterns=couplingPatterns,exports.gyromagneticRatio=gyromagneticRatio,exports.impurities=impurities,exports.peaksFilterImpurities=peaksFilterImpurities,exports.predictCarbon=predictCarbon,exports.predictProton=predictProton,exports.rangesToACS=rangesToACS,exports.signalsToRanges=signalsToRanges,exports.signalsToXY=signalsToXY,exports.xyAutoPeaksPicking=xyAutoPeaksPicking,exports.xyAutoRangesPicking=xyAutoRangesPicking,exports.xyzAutoPeaksPicking=xyzAutoPeaksPicking,exports.xyzJResAnalyzer=xyzJResAnalyzer,Object.defineProperty(exports,"__esModule",{value:!0})}));
//# sourceMappingURL=nmr-processing.min.js.map
