/**
 * nmr-processing
 * @version v1.5.0
 * @link https://github.com/cheminfo/nmr-processing#readme
 * @license MIT
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.NMRProcessing = {}));
}(this, (function (exports) { 'use strict';

  /* eslint-disable camelcase */
  const impurities = {
    cdcl3: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: 'ds',
        shift: 7.26
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 'bs',
        shift: 1.56
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.1
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.17
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.1
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.36
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.28
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.19
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.22
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.98
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 5.01
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.27
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.43
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.26
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.43
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.73
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 5.3
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.21
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.48
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.65
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.57
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.39
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.4
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.55
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.09
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.02
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.94
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 8.02
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.96
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.88
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.62
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.71
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.25
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.72
      }, {
        proton: 'OH',
        coupling: 5,
        multiplicity: 's,t',
        shift: 1.32
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.05
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.12
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.26
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.14
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.46
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.06
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.76
      }],
      'grease^f': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 'm',
        shift: 0.86
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'br_s',
        shift: 1.26
      }],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.88
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.26
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.65
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.49
      }, {
        proton: 'OH',
        coupling: 0,
        multiplicity: 's',
        shift: 1.09
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.33
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 7
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.27
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.22
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 4.04
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.62
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.29
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.68
      }],
      silicone_greasei: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 0.07
      }],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.85
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.76
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.36
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.17
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.25
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.03
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.53
      }]
    },
    '(cd3)2co': {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 2.05
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 's',
        shift: 2.84
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.96
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.09
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.05
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.36
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.18
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.13
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.13
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.96
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.22
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.41
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 8.02
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.43
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.87
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 5.63
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.11
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.41
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.56
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.47
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.28
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.28
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.46
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.97
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.83
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.96
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.94
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.78
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.52
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.59
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.12
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.57
      }, {
        proton: 'OH',
        coupling: 5,
        multiplicity: 's,t',
        shift: 3.39
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.97
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.05
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.2
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.07
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.45
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.28
      }],
      'grease^f': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 'm',
        shift: 0.87
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'br_s',
        shift: 1.29
      }],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.88
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.28
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.59
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.31
      }, {
        proton: 'OH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.12
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.43
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.88
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.27
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.1
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 3.9
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.58
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.35
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.76
      }],
      silicone_greasei: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 0.13
      }],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.79
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.63
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.32
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.5
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.5
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.45
      }]
    },
    dmso: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: 'quint',
        shift: 2.5
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 's',
        shift: 3.33
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.91
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.09
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.07
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.37
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.11
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 4.19
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.11
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.08
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.87
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 6.65
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.18
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.36
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 8.32
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.4
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.9
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 5.76
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.09
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.38
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.51
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.38
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.24
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.24
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.43
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.96
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.94
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.78
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.95
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.89
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.73
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.54
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.57
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.06
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.44
      }, {
        proton: 'OH',
        coupling: 5,
        multiplicity: 's,t',
        shift: 4.63
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.99
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.03
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.17
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.07
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.43
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.91
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.34
      }],
      'grease^f': [],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.86
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.25
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.53
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.16
      }, {
        proton: 'OH',
        coupling: 0,
        multiplicity: 's',
        shift: 4.01
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.42
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.88
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.27
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.04
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 3.78
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.58
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.39
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.79
      }],
      silicone_greasei: [],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.76
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.6
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.3
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.18
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.25
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.93
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.43
      }]
    },
    c6d6: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 7.16
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 's',
        shift: 0.4
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.55
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.55
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.55
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.15
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.05
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 1.55
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.07
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.04
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.05
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 4.79
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.24
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.38
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.15
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.4
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 2.9
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 4.27
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.11
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.26
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.46
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.34
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.11
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.12
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.33
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.6
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.57
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.05
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.63
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.36
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.86
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.68
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.35
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.34
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.65
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.89
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.92
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.58
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 1.81
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.85
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.41
      }],
      'grease^f': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 'm',
        shift: 0.92
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'br_s',
        shift: 1.36
      }],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.89
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.24
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.4
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.07
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.94
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.86
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.23
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 0.95
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 3.67
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.53
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 6.66
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 6.98
      }],
      silicone_greasei: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 0.29
      }],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.4
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.57
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.11
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.02
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.13
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.4
      }]
    },
    cd3cn: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 1.94
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 's',
        shift: 2.13
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.96
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.08
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.96
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.37
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.16
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 2.18
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.14
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.13
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.97
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 5.2
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.22
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.39
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.58
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.44
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.81
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 5.44
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.12
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.42
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.53
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.45
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.29
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.28
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.45
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.97
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.96
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.83
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.92
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.89
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.77
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.5
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.6
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.12
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.54
      }, {
        proton: 'OH',
        coupling: 5,
        multiplicity: 's,t',
        shift: 2.47
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.97
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.06
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.2
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.06
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.43
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.51
      }],
      'grease^f': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 'm',
        shift: 0.86
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'br_s',
        shift: 1.27
      }],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.89
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.28
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.57
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.28
      }, {
        proton: 'OH',
        coupling: 0,
        multiplicity: 's',
        shift: 2.16
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.31
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.87
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.29
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.09
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 3.87
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.57
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.33
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.73
      }],
      silicone_greasei: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 0.08
      }],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.8
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.64
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.33
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.2
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.2
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.45
      }]
    },
    cd3od: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 3.31
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 's',
        shift: 4.87
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.99
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.15
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.03
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.33
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.4
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.15
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.2
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.92
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.21
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.4
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.9
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.45
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.78
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 5.49
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.18
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.49
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.61
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.58
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.35
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.35
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.52
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.07
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.31
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.92
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.97
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.99
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.86
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.65
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.66
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.19
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.6
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.01
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.09
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.24
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.12
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.5
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.01
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.59
      }],
      'grease^f': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 'm',
        shift: 0.88
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'br_s',
        shift: 1.29
      }],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.9
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.29
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.64
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.34
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.34
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.89
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.29
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.5
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 3.92
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.53
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.44
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.85
      }],
      silicone_greasei: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 0.1
      }],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.87
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.71
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.32
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.16
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.16
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.05
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.58
      }]
    },
    d2o: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 4.79
      }],
      h2o: [],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.08
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.22
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.06
      }],
      benzene: [],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.24
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.21
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.22
      }],
      bhtb: [],
      chloroform: [],
      cyclohexane: [],
      '1,2-dichloroethane': [],
      dichloromethane: [],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.17
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.56
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.67
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.61
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.37
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.37
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.6
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.08
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.06
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.9
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.92
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.01
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.85
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.71
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.75
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.17
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.65
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.07
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.14
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.24
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.19
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.18
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.26
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.65
      }],
      'grease^f': [],
      'n-hexane': [],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.61
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.34
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.4
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.9
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.17
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 4.02
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.52
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.45
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.87
      }],
      silicone_greasei: [],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.88
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.74
      }],
      toluene: [],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.99
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.57
      }]
    }
  };

  const toCheck = ['solvent', 'H2O', 'TMS'];
  /**
   * Try to remove peaks of impurities.
   * @param {array} peakList - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
   * @param {object} [options={}] - options
   * @param {string} [options.solvent=''] - solvent name.
   * @param {string} [options.error=0.025] - tolerance in ppm to assign a impurity.
   */

  function peaksFilterImpurities(peakList, options = {}) {
    let {
      solvent = '',
      error = 0.025,
      remove = false
    } = options;
    solvent = solvent.toLowerCase();
    if (solvent === '(cd3)2so') solvent = 'dmso';
    if (solvent === 'meod') solvent = 'cd3od';
    let solventImpurities = impurities[solvent];

    if (solventImpurities) {
      for (let impurity of toCheck) {
        let name = impurity.toLowerCase();
        let impurityShifts = solventImpurities[name];
        checkImpurity(peakList, impurityShifts, {
          error,
          remove,
          name
        });
      }
    }

    return peakList;
  }

  function checkImpurity(peakList, impurity, options) {
    let {
      name,
      error,
      remove
    } = options;
    let j, tolerance, difference;
    let i = impurity.length;

    while (i--) {
      j = peakList.length;

      while (j--) {
        if (!peakList[j].asymmetric) {
          tolerance = error + peakList[j].width;
          difference = Math.abs(impurity[i].shift - peakList[j].x);

          if (difference < tolerance) {
            // && (impurity[i].multiplicity === '' || (impurity[i].multiplicity.indexOf(peakList[j].multiplicity)) { // some impurities has multiplicities like 'bs' but at presents it is unsupported
            if (remove) {
              peakList.splice(j, 1);
            } else {
              peakList[j].kind = name;
            }
          }
        }
      }
    }
  }

  const GAUSSIAN_EXP_FACTOR = -4 * Math.LN2;
  const ROOT_PI_OVER_LN2 = Math.sqrt(Math.PI / Math.LN2);
  const ROOT_THREE = Math.sqrt(3);
  const ROOT_2LN2 = Math.sqrt(2 * Math.LN2);
  const ROOT_2LN2_MINUS_ONE = Math.sqrt(2 * Math.LN2) - 1;

  // https://en.wikipedia.org/wiki/Error_function#Inverse_functions
  // This code yields to a good approximation
  // If needed a better implementation using polynomial can be found on https://en.wikipedia.org/wiki/Error_function#Inverse_functions
  function erfinv(x) {
    let a = 0.147;
    if (x === 0) return 0;
    let ln1MinusXSqrd = Math.log(1 - x * x);
    let lnEtcBy2Plus2 = ln1MinusXSqrd / 2 + 2 / (Math.PI * a);
    let firstSqrt = Math.sqrt(lnEtcBy2Plus2 ** 2 - ln1MinusXSqrd / a);
    let secondSqrt = Math.sqrt(firstSqrt - lnEtcBy2Plus2);
    return secondSqrt * (x > 0 ? 1 : -1);
  }

  class Gaussian {
    /**
     * @param {object} [options = {}]
     * @param {number} [options.height=4*LN2/(PI*FWHM)] Define the height of the peak, by default area=1 (normalized)
     * @param {number} [options.fwhm = 500] - Full Width at Half Maximum in the number of points in FWHM.
     * @param {number} [options.sd] - Standard deviation, if it's defined options.fwhm will be ignored and the value will be computed sd * Math.sqrt(8 * Math.LN2);
     */
    constructor(options = {}) {
      this.fwhm = options.sd ? Gaussian.widthToFWHM(2 * options.sd) : options.fwhm ? options.fwhm : 500;
      this.height = options.height === undefined ? Math.sqrt(-GAUSSIAN_EXP_FACTOR / Math.PI) / this.fwhm : options.height;
    }
    /**
     * Calculate a gaussian shape
     * @param {object} [options = {}]
     * @param {number} [options.factor = 6] - Number of time to take fwhm to calculate length. Default covers 99.99 % of area.
     * @param {number} [options.length = fwhm * factor + 1] - total number of points to calculate
     * @return {Float64Array} y values
     */


    getData(options = {}) {
      let {
        length,
        factor = this.getFactor()
      } = options;

      if (!length) {
        length = Math.min(Math.ceil(this.fwhm * factor), Math.pow(2, 25) - 1);
        if (length % 2 === 0) length++;
      }

      const center = (length - 1) / 2;
      const data = new Float64Array(length);

      for (let i = 0; i <= center; i++) {
        data[i] = this.fct(i - center) * this.height;
        data[length - 1 - i] = data[i];
      }

      return data;
    }
    /**
     * Return a parameterized function of a gaussian shape (see README for equation).
     * @param {number} x - x value to calculate.
     * @returns {number} - the y value of gaussian with the current parameters.
     */


    fct(x) {
      return Gaussian.fct(x, this.fwhm);
    }
    /**
     * Calculate the number of times FWHM allows to reach a specific area coverage
     * @param {number} [area=0.9999]
     * @returns {number}
     */


    getFactor(area = 0.9999) {
      return Gaussian.getFactor(area);
    }
    /**
     * Calculate the area of the shape.
     * @returns {number} - returns the area.
     */


    getArea() {
      return Gaussian.getArea(this.fwhm, {
        height: this.height
      });
    }
    /**
     * Compute the value of Full Width at Half Maximum (FWHM) from the width between the inflection points.
     * //https://mathworld.wolfram.com/GaussianFunction.html
     * @param {number} width - Width between the inflection points
     * @returns {number} fwhm
     */


    widthToFWHM(width) {
      //https://mathworld.wolfram.com/GaussianFunction.html
      return Gaussian.widthToFWHM(width);
    }
    /**
     * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
     * //https://mathworld.wolfram.com/GaussianFunction.html
     * @param {number} fwhm - Full Width at Half Maximum.
     * @returns {number} width
     */


    fwhmToWidth(fwhm = this.fwhm) {
      return Gaussian.fwhmToWidth(fwhm);
    }
    /**
     * set a new full width at half maximum
     * @param {number} fwhm - full width at half maximum
     */


    setFWHM(fwhm) {
      this.fwhm = fwhm;
    }
    /**
     * set a new height
     * @param {number} height - The maximal intensity of the shape.
     */


    setHeight(height) {
      this.height = height;
    }

  }
  /**
   * Return a parameterized function of a gaussian shape (see README for equation).
   * @param {number} x - x value to calculate.
   * @param {number} fwhm - full width half maximum
   * @returns {number} - the y value of gaussian with the current parameters.
   */

  Gaussian.fct = function fct(x, fwhm = 500) {
    return Math.exp(GAUSSIAN_EXP_FACTOR * Math.pow(x / fwhm, 2));
  };
  /**
   * Compute the value of Full Width at Half Maximum (FWHM) from the width between the inflection points.
   * //https://mathworld.wolfram.com/GaussianFunction.html
   * @param {number} width - Width between the inflection points
   * @returns {number} fwhm
   */


  Gaussian.widthToFWHM = function widthToFWHM(width) {
    return width * ROOT_2LN2;
  };
  /**
   * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
   * //https://mathworld.wolfram.com/GaussianFunction.html
   * @param {number} fwhm - Full Width at Half Maximum.
   * @returns {number} width
   */


  Gaussian.fwhmToWidth = function fwhmToWidth(fwhm) {
    return fwhm / ROOT_2LN2;
  };
  /**
   * Calculate the area of a specific shape.
   * @param {number} fwhm - Full width at half maximum.
   * @param {object} [options = {}] - options.
   * @param {number} [options.height = 1] - Maximum y value of the shape.
   * @returns {number} - returns the area of the specific shape and parameters.
   */


  Gaussian.getArea = function getArea(fwhm, options = {}) {
    let {
      height = 1
    } = options;
    return height * ROOT_PI_OVER_LN2 * fwhm / 2;
  };
  /**
   * Calculate the number of times FWHM allows to reach a specific area coverage.
   * @param {number} [area=0.9999]
   * @returns {number}
   */


  Gaussian.getFactor = function getFactor(area = 0.9999) {
    return Math.sqrt(2) * erfinv(area);
  };

  class Lorentzian {
    /**
     * @param {object} [options = {}]
     * @param {number} [options.height=2/(PI*FWHM)] Define the height of the peak, by default area=1 (normalized)
     * @param {number} [options.fwhm = 500] - Full Width at Half Maximum in the number of points in FWHM.
     * @param {number} [options.sd] - Standard deviation, if it's defined options.fwhm will be ignored and the value will be computed sd * Math.sqrt(8 * Math.LN2);
     */
    constructor(options = {}) {
      this.fwhm = options.fwhm === undefined ? 500 : options.fwhm;
      this.height = options.height === undefined ? 2 / Math.PI / this.fwhm : options.height;
    }
    /**
     * Calculate a lorentzian shape
     * @param {object} [options = {}]
     * @param {number} [options.factor = Math.tan(Math.PI * (0.9999 - 0.5))] - Number of time to take fwhm to calculate length. Default covers 99.99 % of area.
     * @param {number} [options.length = fwhm * factor + 1] - total number of points to calculate
     * @return {Float64Array} y values
     */


    getData(options = {}) {
      let {
        length,
        factor = this.getFactor()
      } = options;

      if (!length) {
        length = Math.min(Math.ceil(this.fwhm * factor), Math.pow(2, 25) - 1);
        if (length % 2 === 0) length++;
      }

      const center = (length - 1) / 2;
      const data = new Float64Array(length);

      for (let i = 0; i <= center; i++) {
        data[i] = this.fct(i - center) * this.height;
        data[length - 1 - i] = data[i];
      }

      return data;
    }
    /**
     * Return a parameterized function of a lorentzian shape (see README for equation).
     * @param {number} x - x value to calculate.
     * @returns {number} - the y value of lorentzian with the current parameters.
     */


    fct(x) {
      return Lorentzian.fct(x, this.fwhm);
    }
    /**
     * Calculate the number of times FWHM allows to reach a specific area coverage
     * @param {number} [area=0.9999]
     * @returns {number}
     */


    getFactor(area = 0.9999) {
      return Lorentzian.getFactor(area);
    }
    /**
     * Calculate the area of the shape.
     * @returns {number} - returns the area.
     */


    getArea() {
      return Lorentzian.getArea(this.fwhm, {
        height: this.height
      });
    }
    /**
     * Compute the value of width between the inflection points of a specific shape from Full Width at Half Maximum (FWHM).
     * //https://mathworld.wolfram.com/LorentzianFunction.html
     * @param {number} [fwhm] - Full Width at Half Maximum.
     * @returns {number} width between the inflection points
     */


    fwhmToWidth(fwhm = this.fwhm) {
      return Lorentzian.fwhmToWidth(fwhm);
    }
    /**
     * Compute the value of Full Width at Half Maximum (FWHM) of a specific shape from the width between the inflection points.
     * //https://mathworld.wolfram.com/LorentzianFunction.html
     * @param {number} [width] Width between the inflection points
     * @returns {number} fwhm
     */


    widthToFWHM(width) {
      return Lorentzian.widthToFWHM(width);
    }
    /**
     * set a new full width at half maximum
     * @param {number} fwhm - full width at half maximum
     */


    setFWHM(fwhm) {
      this.fwhm = fwhm;
    }
    /**
     * set a new height
     * @param {number} height - The maximal intensity of the shape.
     */


    setHeight(height) {
      this.height = height;
    }

  }
  /**
   * Return a parameterized function of a gaussian shape (see README for equation).
   * @param {number} x - x value to calculate.
   * @param {number} fwhm - full width half maximum
   * @returns {number} - the y value of gaussian with the current parameters.
   */

  Lorentzian.fct = function fct(x, fwhm) {
    const squareFWHM = fwhm * fwhm;
    return squareFWHM / (4 * Math.pow(x, 2) + squareFWHM);
  };
  /**
   * Compute the value of width between the inflection points of a specific shape from Full Width at Half Maximum (FWHM).
   * //https://mathworld.wolfram.com/LorentzianFunction.html
   * @param {number} [fwhm] - Full Width at Half Maximum.
   * @returns {number} width between the inflection points
   */


  Lorentzian.fwhmToWidth = function fwhmToWidth(fwhm) {
    return fwhm / ROOT_THREE;
  };
  /**
   * Compute the value of Full Width at Half Maximum (FWHM) of a specific shape from the width between the inflection points.
   * //https://mathworld.wolfram.com/LorentzianFunction.html
   * @param {number} [width] Width between the inflection points
   * @returns {number} fwhm
   */


  Lorentzian.widthToFWHM = function widthToFWHM(width) {
    return width * ROOT_THREE;
  };
  /**
   * Calculate the area of a specific shape.
   * @param {number} fwhm - Full width at half maximum.
   * @param {*} [options = {}] - options.
   * @param {number} [options.height = 1] - Maximum y value of the shape.
   * @returns {number} - returns the area of the specific shape and parameters.
   */


  Lorentzian.getArea = function getArea(fwhm, options = {}) {
    let {
      height = 1
    } = options;
    return height * Math.PI * fwhm / 2;
  };
  /**
   * Calculate the number of times FWHM allows to reach a specific area coverage
   * @param {number} [area=0.9999]
   * @returns {number}
   */


  Lorentzian.getFactor = function getFactor(area = 0.9999) {
    return 2 * Math.tan(Math.PI * (area - 0.5));
  };

  class PseudoVoigt {
    /**
     * @param {object} [options={}]
     * @param {number} [options.height=1/(mu*FWHM/sqrt(4*LN2/PI)+(1-mu)*fwhm*PI*0.5)] Define the height of the peak, by default area=1 (normalized)
     * @param {number} [options.fwhm=500] - Full Width at Half Maximum in the number of points in FWHM.
     * @param {number} [options.mu=0.5] - ratio of gaussian contribution.
     */
    constructor(options = {}) {
      this.mu = options.mu === undefined ? 0.5 : options.mu;
      this.fwhm = options.fwhm === undefined ? 500 : options.fwhm;
      this.height = options.height === undefined ? 1 / (this.mu / Math.sqrt(-GAUSSIAN_EXP_FACTOR / Math.PI) * this.fwhm + (1 - this.mu) * this.fwhm * Math.PI / 2) : options.height;
    }
    /**
     * Calculate a linear combination of gaussian and lorentzian function width an same full width at half maximum
     * @param { object } [options = {}]
     * @param { number } [options.factor = 2 * Math.tan(Math.PI * (0.9999 - 0.5))] - Number of time to take fwhm in the calculation of the length.Default covers 99.99 % of area.
     * @param { number } [options.length = fwhm * factor + 1] - total number of points to calculate
     * @return { object } - { fwhm, data<Float64Array>} - An with the number of points at half maximum and the array of y values covering the 99.99 % of the area.
     */


    getData(options = {}) {
      let {
        length,
        factor = this.getFactor()
      } = options;

      if (!length) {
        length = Math.ceil(this.fwhm * factor);
        if (length % 2 === 0) length++;
      }

      const center = (length - 1) / 2;
      let data = new Float64Array(length);

      for (let i = 0; i <= center; i++) {
        data[i] = this.fct(i - center) * this.height;
        data[length - 1 - i] = data[i];
      }

      return data;
    }
    /**
     * Return a parameterized function of a linear combination of Gaussian and Lorentzian shapes where the full width at half maximum are the same for both kind of shapes (see README for equation).
     * @param {number} [x] x value to calculate.
     * @returns {number} - the y value of a pseudo voigt with the current parameters.
     */


    fct(x) {
      return PseudoVoigt.fct(x, this.fwhm, this.mu);
    }
    /**
     * Calculate the number of times FWHM allows to reach a specific area coverage
     * @param {number} [area=0.9999] - required area to be coverage
     * @param {number} [mu=this.mu] - ratio of gaussian contribution.
     * @returns {number}
     */


    getFactor(area = 0.9999, mu = this.mu) {
      return PseudoVoigt.getFactor(area, mu);
    }
    /**
     * Calculate the area of the shape.
     * @returns {number} - returns the area.
     */


    getArea() {
      return PseudoVoigt.getArea(this.fwhm, {
        height: this.height,
        mu: this.mu
      });
    }
    /**
     * Compute the value of Full Width at Half Maximum (FMHM) from width between the inflection points.
     * @param {number} width - width between the inflection points
     * @param {number} [mu = 0.5] - ratio of gaussian contribution.
     * @returns {number} Full Width at Half Maximum (FMHM).
     */


    widthToFWHM(width, mu) {
      return PseudoVoigt.widthToFWHM(width, mu);
    }
    /**
     * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
     * @param {number} fwhm - Full Width at Half Maximum.
     * @param {number} [mu] - ratio of gaussian contribution.
     * @returns {number} width between the inflection points.
     */


    fwhmToWidth(fwhm = this.fwhm, mu = this.mu) {
      return PseudoVoigt.fwhmToWidth(fwhm, mu);
    }
    /**
     * set a new full width at half maximum
     * @param {number} fwhm - full width at half maximum
     */


    setFWHM(fwhm) {
      this.fwhm = fwhm;
    }
    /**
     * set a new height
     * @param {number} height - The maximal intensity of the shape.
     */


    setHeight(height) {
      this.height = height;
    }
    /**
     * set a new mu
     * @param {number} mu - ratio of gaussian contribution.
     */


    setMu(mu) {
      this.mu = mu;
    }

  }
  /**
   * Return a parameterized function of a gaussian shape (see README for equation).
   * @param {number} x - x value to calculate.
   * @param {number} fwhm - full width half maximum
   * @param {number} [mu=0.5] - ratio of gaussian contribution.
   * @returns {number} - the y value of gaussian with the current parameters.
   */

  PseudoVoigt.fct = function fct(x, fwhm, mu = 0.5) {
    return (1 - mu) * Lorentzian.fct(x, fwhm) + mu * Gaussian.fct(x, fwhm);
  };
  /**
   * Compute the value of Full Width at Half Maximum (FMHM) from width between the inflection points.
   * @param {number} width - width between the inflection points
   * @param {number} [mu = 0.5] - ratio of gaussian contribution.
   * @returns {number} Full Width at Half Maximum (FMHM).
   */


  PseudoVoigt.widthToFWHM = function widthToFWHM(width, mu = 0.5) {
    return width * (mu * ROOT_2LN2_MINUS_ONE + 1);
  };
  /**
   * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
   * @param {number} fwhm - Full Width at Half Maximum.
   * @param {number} [mu = 0.5] - ratio of gaussian contribution.
   * @returns {number} width between the inflection points.
   */


  PseudoVoigt.fwhmToWidth = function fwhmToWidth(fwhm, mu = 0.5) {
    return fwhm / (mu * ROOT_2LN2_MINUS_ONE + 1);
  };
  /**
   * Calculate the area of a specific shape.
   * @param {number} fwhm - Full width at half maximum.
   * @param {*} [options = {}] - options.
   * @param {number} [options.height = 1] - Maximum y value of the shape.
   * @param {number} [options.mu = 0.5] - ratio of gaussian contribution.
   * @returns {number} - returns the area of the specific shape and parameters.
   */


  PseudoVoigt.getArea = function getArea(fwhm, options = {}) {
    let {
      height = 1,
      mu = 0.5
    } = options;
    return fwhm * height * (mu * ROOT_PI_OVER_LN2 + (1 - mu) * Math.PI) / 2;
  };
  /**
   * Calculate the number of times FWHM allows to reach a specific area coverage
   * @param {number} [area=0.9999] - required area to be coverage
   * @param {number} [mu=this.mu] - ratio of gaussian contribution.
   * @returns {number}
   */


  PseudoVoigt.getFactor = function getFactor(area = 0.9999, mu = 0.5) {
    return mu < 1 ? Lorentzian.getFactor(area) : Gaussian.getFactor(area);
  };

  let axis = ['x', 'y'];
  class Gaussian2D {
    /**
     * @param {object} [options = {}]
     * @param {number} [options.height=4*LN2/(PI*xFWHM*yFWHM)] Define the height of the peak, by default area=1 (normalized).
     * @param {number} [options.fwhm = 500] - Full Width at Half Maximum in the number of points in FWHM used if x or y has not the fwhm property.
     * @param {object} [options.x] - Options for x axis.
     * @param {number} [options.x.fwhm = fwhm] - Full Width at Half Maximum in the number of points in FWHM for x axis.
     * @param {number} [options.x.sd] - Standard deviation for x axis, if it's defined options.x.fwhm will be ignored and the value will be computed sd * Math.sqrt(8 * Math.LN2);
     * @param {object} [options.y] - Options for y axis.
     * @param {number} [options.y.fwhm = fwhm] - Full Width at Half Maximum in the number of points in FWHM for y axis.
     * @param {number} [options.y.sd] - Standard deviation for y axis, if it's defined options.y.fwhm will be ignored and the value will be computed sd * Math.sqrt(8 * Math.LN2);
     */
    constructor(options = {}) {
      let {
        fwhm: globalFWHM = 500
      } = options;

      for (let i of axis) {
        let fwhm;

        if (!options[i]) {
          fwhm = globalFWHM;
        } else {
          fwhm = options[i].sd ? Gaussian2D.widthToFWHM(2 * options[i].sd) : options[i].fwhm || globalFWHM;
        }

        this[i] = {
          fwhm
        };
      }

      this.height = options.height === undefined ? -GAUSSIAN_EXP_FACTOR / Math.PI / this.x.fwhm / this.y.fwhm : options.height;
    }
    /**
     * Calculate a Gaussian2D shape
     * @param {object} [options = {}]
     * @param {number} [options.factor] - Number of time to take fwhm to calculate length. Default covers 99.99 % of area.
     * @param {object} [options.x] - parameter for x axis.
     * @param {number} [options.x.length=fwhm*factor+1] - length on x axis.
     * @param {number} [options.x.factor=factor] - Number of time to take fwhm to calculate length. Default covers 99.99 % of area.
     * @param {object} [options.y] - parameter for y axis.
     * @param {number} [options.y.length=fwhm*factor+1] - length on y axis.
     * @param {number} [options.y.factor=factor] - Number of time to take fwhm to calculate length. Default covers 99.99 % of area.
     * @return {Array<Float64Array>} - z values.
     */


    getData(options = {}) {
      let {
        x = {},
        y = {},
        factor = this.getFactor(),
        length
      } = options;
      let xLength = x.length || length;

      if (!xLength) {
        let {
          factor: xFactor = factor
        } = x;
        xLength = Math.min(Math.ceil(this.x.fwhm * xFactor), Math.pow(2, 25) - 1);
        if (xLength % 2 === 0) xLength++;
      }

      let yLength = y.length || length;

      if (!yLength) {
        let {
          factor: yFactor = factor
        } = y;
        yLength = Math.min(Math.ceil(this.y.fwhm * yFactor), Math.pow(2, 25) - 1);
        if (yLength % 2 === 0) yLength++;
      }

      const xCenter = (xLength - 1) / 2;
      const yCenter = (yLength - 1) / 2;
      const data = new Array(xLength);

      for (let i = 0; i < xLength; i++) {
        data[i] = new Array(yLength);
      }

      for (let i = 0; i < xLength; i++) {
        for (let j = 0; j < yLength; j++) {
          data[i][j] = this.fct(i - xCenter, j - yCenter) * this.height;
        }
      }

      return data;
    }
    /**
     * Return the intensity value of a 2D gaussian shape (see README for equation).
     * @param {number} x - x value to calculate.
     * @param {number} y - y value to calculate.
     * @returns {number} - the z value of bi-dimensional gaussian with the current parameters.
     */


    fct(x, y) {
      return Gaussian2D.fct(x, y, this.x.fwhm, this.y.fwhm);
    }
    /**
     * Calculate the number of times FWHM allows to reach a specific volume coverage.
     * @param {number} [volume=0.9999]
     * @returns {number}
     */


    getFactor(volume = 0.9999) {
      return Gaussian2D.getFactor(volume);
    }
    /**
     * Calculate the volume of the shape.
     * @returns {number} - returns the volume.
     */


    getVolume() {
      return Gaussian2D.getVolume(this.x.fwhm, this.y.fwhm, {
        height: this.height
      });
    }
    /**
     * Compute the value of Full Width at Half Maximum (FWHM) from the width between the inflection points.
     * //https://mathworld.wolfram.com/Gaussian2DFunction.html
     * @param {number} width - Width between the inflection points
     * @returns {number} fwhm
     */


    widthToFWHM(width) {
      //https://mathworld.wolfram.com/Gaussian2DFunction.html
      return Gaussian2D.widthToFWHM(width);
    }
    /**
     * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
     * //https://mathworld.wolfram.com/Gaussian2DFunction.html
     * @param {number} fwhm - Full Width at Half Maximum.
     * @returns {number} width
     */


    fwhmToWidth(fwhm = this.x.fwhm) {
      return Gaussian2D.fwhmToWidth(fwhm);
    }
    /**
     * set a new full width at half maximum
     * @param {number} fwhm - full width at half maximum
     * @param {string|Array<string>} axisLabel - label of axis, if it is undefined fwhm is set to both axis.
     */


    setFWHM(fwhm, axisLabel) {
      if (!axisLabel) axisLabel = axis;
      if (!Array.isArray(axisLabel)) axisLabel = [axisLabel];

      for (let i of axisLabel) {
        let axisName = i.toLowerCase();

        if (axisName !== 'y' && axisName !== 'x') {
          throw new Error('axis label should be x or y');
        }

        this[axisName].fwhm = fwhm;
      }
    }
    /**
     * set a new height
     * @param {number} height - The maximal intensity of the shape.
     */


    setHeight(height) {
      this.height = height;
    }

  }
  /**
   * Return a parameterized function of a Gaussian2D shape (see README for equation).
   * @param {number} x - x value to calculate.
   * @param {number} y - y value to calculate.
   * @param {number} fwhmX - full width half maximum in the x axis.
   * @param {number} fwhmY - full width half maximum in the y axis.
   * @returns {number} - the z value of bi-dimensional gaussian with the current parameters.
   */

  Gaussian2D.fct = function fct(x, y, xFWHM = 500, yFWHM = 500) {
    return Math.exp(GAUSSIAN_EXP_FACTOR * (Math.pow(x / xFWHM, 2) + Math.pow(y / yFWHM, 2)));
  };
  /**
   * Compute the value of Full Width at Half Maximum (FWHM) from the width between the inflection points.
   * //https://mathworld.wolfram.com/Gaussian2DFunction.html
   * @param {number} width - Width between the inflection points
   * @returns {number} fwhm
   */


  Gaussian2D.widthToFWHM = function widthToFWHM(width) {
    return width * ROOT_2LN2;
  };
  /**
   * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
   * //https://mathworld.wolfram.com/Gaussian2DFunction.html
   * @param {number} fwhm - Full Width at Half Maximum.
   * @returns {number} width
   */


  Gaussian2D.fwhmToWidth = function fwhmToWidth(fwhm) {
    return fwhm / ROOT_2LN2;
  };
  /**
   * Calculate the volume of a specific shape.
   * @param {number} xFWHM - Full width at half maximum for x axis.
   * @param {number} yFWHM - Full width at half maximum for y axis.
   * @param {object} [options = {}] - options.
   * @param {number} [options.height = 1] - Maximum z value of the shape.
   * @returns {number} - returns the area of the specific shape and parameters.
   */


  Gaussian2D.getVolume = function getVolume(xFWHM, yFWHM, options = {}) {
    let {
      height = 1
    } = options;
    return height * Math.PI * xFWHM * yFWHM / Math.LN2 / 4;
  };
  /**@TODO look for a better factor
   * Calculate the number of times FWHM allows to reach a specific volume coverage.
   * @param {number} [volume=0.9999]
   * @returns {number}
   */


  Gaussian2D.getFactor = function getFactor(volume = 0.9999) {
    return Math.sqrt(2) * erfinv(volume);
  };

  function getShapeGenerator(options) {
    let {
      kind = 'Gaussian',
      options: shapeOptions
    } = options;

    switch (kind.toLowerCase().replace(/[^a-z^0-9]/g, '')) {
      case 'gaussian':
        return new Gaussian(shapeOptions);

      case 'lorentzian':
        return new Lorentzian(shapeOptions);

      case 'pseudovoigt':
        return new PseudoVoigt(shapeOptions);

      case 'gaussian2d':
        return new Gaussian2D(shapeOptions);

      default:
        throw new Error(`Unknown kind: ${kind}`);
    }
  }

  /**
   * Apply Savitzky Golay algorithm
   * @param {array} [ys] Array of y values
   * @param {array|number} [xs] Array of X or deltaX
   * @param {object} [options={}]
   * @param {number} [options.windowSize=9]
   * @param {number} [options.derivative=0]
   * @param {number} [options.polynomial=3]
   * @return {array} Array containing the new ys (same length)
   */
  function SavitzkyGolay(ys, xs, options = {}) {
    let {
      windowSize = 9,
      derivative = 0,
      polynomial = 3
    } = options;

    if (windowSize % 2 === 0 || windowSize < 5 || !Number.isInteger(windowSize)) {
      throw new RangeError('Invalid window size (should be odd and at least 5 integer number)');
    }

    if (windowSize > ys.length) {
      throw new RangeError(`Window size is higher than the data length ${windowSize}>${ys.length}`);
    }

    if (derivative < 0 || !Number.isInteger(derivative)) {
      throw new RangeError('Derivative should be a positive integer');
    }

    if (polynomial < 1 || !Number.isInteger(polynomial)) {
      throw new RangeError('Polynomial should be a positive integer');
    }

    if (polynomial >= 6) {
      // eslint-disable-next-line no-console
      console.warn('You should not use polynomial grade higher than 5 if you are' + ' not sure that your data arises from such a model. Possible polynomial oscillation problems');
    }

    let half = Math.floor(windowSize / 2);
    let np = ys.length;
    let ans = new Array(np);
    let weights = fullWeights(windowSize, polynomial, derivative);
    let hs = 0;
    let constantH = true;

    if (Array.isArray(xs)) {
      constantH = false;
    } else {
      hs = Math.pow(xs, derivative);
    } //For the borders


    for (let i = 0; i < half; i++) {
      let wg1 = weights[half - i - 1];
      let wg2 = weights[half + i + 1];
      let d1 = 0;
      let d2 = 0;

      for (let l = 0; l < windowSize; l++) {
        d1 += wg1[l] * ys[l];
        d2 += wg2[l] * ys[np - windowSize + l];
      }

      if (constantH) {
        ans[half - i - 1] = d1 / hs;
        ans[np - half + i] = d2 / hs;
      } else {
        hs = getHs(xs, half - i - 1, half, derivative);
        ans[half - i - 1] = d1 / hs;
        hs = getHs(xs, np - half + i, half, derivative);
        ans[np - half + i] = d2 / hs;
      }
    } //For the internal points


    let wg = weights[half];

    for (let i = windowSize; i <= np; i++) {
      let d = 0;

      for (let l = 0; l < windowSize; l++) d += wg[l] * ys[l + i - windowSize];

      if (!constantH) hs = getHs(xs, i - half - 1, half, derivative);
      ans[i - half - 1] = d / hs;
    }

    return ans;
  }

  function getHs(h, center, half, derivative) {
    let hs = 0;
    let count = 0;

    for (let i = center - half; i < center + half; i++) {
      if (i >= 0 && i < h.length - 1) {
        hs += h[i + 1] - h[i];
        count++;
      }
    }

    return Math.pow(hs / count, derivative);
  }

  function GramPoly(i, m, k, s) {
    let Grampoly = 0;

    if (k > 0) {
      Grampoly = (4 * k - 2) / (k * (2 * m - k + 1)) * (i * GramPoly(i, m, k - 1, s) + s * GramPoly(i, m, k - 1, s - 1)) - (k - 1) * (2 * m + k) / (k * (2 * m - k + 1)) * GramPoly(i, m, k - 2, s);
    } else {
      if (k === 0 && s === 0) {
        Grampoly = 1;
      } else {
        Grampoly = 0;
      }
    }

    return Grampoly;
  }

  function GenFact(a, b) {
    let gf = 1;

    if (a >= b) {
      for (let j = a - b + 1; j <= a; j++) {
        gf *= j;
      }
    }

    return gf;
  }

  function Weight(i, t, m, n, s) {
    let sum = 0;

    for (let k = 0; k <= n; k++) {
      //console.log(k);
      sum += (2 * k + 1) * (GenFact(2 * m, k) / GenFact(2 * m + k + 1, k + 1)) * GramPoly(i, m, k, 0) * GramPoly(t, m, k, s);
    }

    return sum;
  }
  /**
   *
   * @param m  Number of points
   * @param n  Polynomial grade
   * @param s  Derivative
   */


  function fullWeights(m, n, s) {
    let weights = new Array(m);
    let np = Math.floor(m / 2);

    for (let t = -np; t <= np; t++) {
      weights[t + np] = new Array(m);

      for (let j = -np; j <= np; j++) {
        weights[t + np][j + np] = Weight(j, t, np, n, s);
      }
    }

    return weights;
  }
  /*function entropy(data,h,options){
      var trend = SavitzkyGolay(data,h,trendOptions);
      var copy = new Array(data.length);
      var sum = 0;
      var max = 0;
      for(var i=0;i<data.length;i++){
          copy[i] = data[i]-trend[i];
      }

      sum/=data.length;
      console.log(sum+" "+max);
      console.log(stat.array.standardDeviation(copy));
      console.log(Math.abs(stat.array.mean(copy))/stat.array.standardDeviation(copy));
      return sum;

  }



  function guessWindowSize(data, h){
      console.log("entropy "+entropy(data,h,trendOptions));
      return 5;
  }
  */

  /**
   * Global spectra deconvolution
   * @param {object} data - Object data with x and y arrays
   * @param {Array<number>} [data.x] - Independent variable
   * @param {Array<number>} [data.y] - Dependent variable
   * @param {object} [options={}] - Options object
   * @param {object} [options.shape={}] - Object that specified the kind of shape to calculate the FWHM instead of width between inflection points. see https://mljs.github.io/peak-shape-generator/#inflectionpointswidthtofwhm
   * @param {object} [options.shape.kind='gaussian']
   * @param {object} [options.shape.options={}]
   * @param {object} [options.sgOptions] - Options object for Savitzky-Golay filter. See https://github.com/mljs/savitzky-golay-generalized#options
   * @param {number} [options.sgOptions.windowSize = 9] - points to use in the approximations
   * @param {number} [options.sgOptions.polynomial = 3] - degree of the polynomial to use in the approximations
   * @param {number} [options.minMaxRatio = 0.00025] - Threshold to determine if a given peak should be considered as a noise
   * @param {number} [options.broadRatio = 0.00] - If `broadRatio` is higher than 0, then all the peaks which second derivative
   * smaller than `broadRatio * maxAbsSecondDerivative` will be marked with the soft mask equal to true.
   * @param {number} [options.noiseLevel = 0] - Noise threshold in spectrum units
   * @param {boolean} [options.maxCriteria = true] - Peaks are local maximum(true) or minimum(false)
   * @param {boolean} [options.smoothY = true] - Select the peak intensities from a smoothed version of the independent variables
   * @param {boolean} [options.realTopDetection = false] - Use a quadratic optimizations with the peak and its 3 closest neighbors
   * to determine the true x,y values of the peak?
   * @param {number} [options.heightFactor = 0] - Factor to multiply the calculated height (usually 2)
   * @param {number} [options.derivativeThreshold = -1] - Filters based on the amplitude of the first derivative
   * @return {Array<object>}
   */

  function gsd(data, options = {}) {
    let {
      noiseLevel,
      sgOptions = {
        windowSize: 9,
        polynomial: 3
      },
      shape = {},
      smoothY = true,
      heightFactor = 0,
      broadRatio = 0.0,
      maxCriteria = true,
      minMaxRatio = 0.00025,
      derivativeThreshold = -1,
      realTopDetection = false
    } = options;
    let {
      y: yIn,
      x
    } = data;
    const y = yIn.slice();
    let equalSpaced = isEqualSpaced(x);

    if (maxCriteria === false) {
      for (let i = 0; i < y.length; i++) {
        y[i] *= -1;
      }
    }

    if (noiseLevel === undefined) {
      noiseLevel = equalSpaced ? getNoiseLevel(y) : 0;
    }

    for (let i = 0; i < y.length; i++) {
      y[i] -= noiseLevel;
    }

    for (let i = 0; i < y.length; i++) {
      if (y[i] < 0) {
        y[i] = 0;
      }
    } // If the max difference between delta x is less than 5%, then,
    // we can assume it to be equally spaced variable


    let yData = y;
    let dY, ddY;
    const {
      windowSize,
      polynomial
    } = sgOptions;

    if (equalSpaced) {
      if (smoothY) {
        yData = SavitzkyGolay(y, x[1] - x[0], {
          windowSize,
          polynomial,
          derivative: 0
        });
      }

      dY = SavitzkyGolay(y, x[1] - x[0], {
        windowSize,
        polynomial,
        derivative: 1
      });
      ddY = SavitzkyGolay(y, x[1] - x[0], {
        windowSize,
        polynomial,
        derivative: 2
      });
    } else {
      if (smoothY) {
        yData = SavitzkyGolay(y, x, {
          windowSize,
          polynomial,
          derivative: 0
        });
      }

      dY = SavitzkyGolay(y, x, {
        windowSize,
        polynomial,
        derivative: 1
      });
      ddY = SavitzkyGolay(y, x, {
        windowSize,
        polynomial,
        derivative: 2
      });
    }

    const xData = x;
    const dX = x[1] - x[0];
    let maxDdy = 0;
    let maxY = 0;

    for (let i = 0; i < yData.length; i++) {
      if (Math.abs(ddY[i]) > maxDdy) {
        maxDdy = Math.abs(ddY[i]);
      }

      if (Math.abs(yData[i]) > maxY) {
        maxY = Math.abs(yData[i]);
      }
    }

    let lastMax = null;
    let lastMin = null;
    let minddY = [];
    let intervalL = [];
    let intervalR = [];
    let broadMask = []; // By the intermediate value theorem We cannot find 2 consecutive maximum or minimum

    for (let i = 1; i < yData.length - 1; ++i) {
      // filter based on derivativeThreshold
      // console.log('pasa', y[i], dY[i], ddY[i]);
      if (Math.abs(dY[i]) > derivativeThreshold) {
        // Minimum in first derivative
        if (dY[i] < dY[i - 1] && dY[i] <= dY[i + 1] || dY[i] <= dY[i - 1] && dY[i] < dY[i + 1]) {
          lastMin = {
            x: xData[i],
            index: i
          };

          if (dX > 0 && lastMax !== null) {
            intervalL.push(lastMax);
            intervalR.push(lastMin);
          }
        } // Maximum in first derivative


        if (dY[i] >= dY[i - 1] && dY[i] > dY[i + 1] || dY[i] > dY[i - 1] && dY[i] >= dY[i + 1]) {
          lastMax = {
            x: xData[i],
            index: i
          };

          if (dX < 0 && lastMin !== null) {
            intervalL.push(lastMax);
            intervalR.push(lastMin);
          }
        }
      } // Minimum in second derivative


      if (ddY[i] < ddY[i - 1] && ddY[i] < ddY[i + 1]) {
        minddY.push(i);
        broadMask.push(Math.abs(ddY[i]) <= broadRatio * maxDdy);
      }
    }

    let widthProcessor = shape.kind ? getShapeGenerator(shape.kind, shape.options).widthToFWHM : x => x;
    let signals = [];
    let lastK = -1;
    let possible, frequency, distanceJ, minDistance, gettingCloser;

    for (let j = 0; j < minddY.length; ++j) {
      frequency = xData[minddY[j]];
      possible = -1;
      let k = lastK + 1;
      minDistance = Number.MAX_VALUE;
      distanceJ = 0;
      gettingCloser = true;

      while (possible === -1 && k < intervalL.length && gettingCloser) {
        distanceJ = Math.abs(frequency - (intervalL[k].x + intervalR[k].x) / 2); // Still getting closer?

        if (distanceJ < minDistance) {
          minDistance = distanceJ;
        } else {
          gettingCloser = false;
        }

        if (distanceJ < Math.abs(intervalL[k].x - intervalR[k].x) / 2) {
          possible = k;
          lastK = k;
        }

        ++k;
      }

      if (possible !== -1) {
        if (Math.abs(yData[minddY[j]]) > minMaxRatio * maxY) {
          let width = Math.abs(intervalR[possible].x - intervalL[possible].x);
          signals.push({
            index: minddY[j],
            x: frequency,
            y: maxCriteria ? yData[minddY[j]] + noiseLevel : -yData[minddY[j]] - noiseLevel,
            width: widthProcessor(width),
            soft: broadMask[j]
          });
          signals[signals.length - 1].left = intervalL[possible];
          signals[signals.length - 1].right = intervalR[possible];

          if (heightFactor) {
            let yLeft = yData[intervalL[possible].index];
            let yRight = yData[intervalR[possible].index];
            signals[signals.length - 1].height = heightFactor * (signals[signals.length - 1].y - (yLeft + yRight) / 2);
          }
        }
      }
    }

    if (realTopDetection) {
      determineRealTop$1(signals, xData, yData);
    } // Correct the values to fit the original spectra data


    for (let j = 0; j < signals.length; j++) {
      signals[j].base = noiseLevel;
    }

    signals.sort(function (a, b) {
      return a.x - b.x;
    });
    return signals;
  }

  const isEqualSpaced = x => {
    let tmp;
    let maxDx = 0;
    let minDx = Number.MAX_SAFE_INTEGER;

    for (let i = 0; i < x.length - 1; ++i) {
      tmp = Math.abs(x[i + 1] - x[i]);

      if (tmp < minDx) {
        minDx = tmp;
      }

      if (tmp > maxDx) {
        maxDx = tmp;
      }
    }

    return (maxDx - minDx) / maxDx < 0.05;
  };

  const getNoiseLevel = y => {
    let mean = 0;
    let stddev = 0;
    let length = y.length;

    for (let i = 0; i < length; ++i) {
      mean += y[i];
    }

    mean /= length;
    let averageDeviations = new Array(length);

    for (let i = 0; i < length; ++i) {
      averageDeviations[i] = Math.abs(y[i] - mean);
    }

    averageDeviations.sort((a, b) => a - b);

    if (length % 2 === 1) {
      stddev = averageDeviations[(length - 1) / 2] / 0.6745;
    } else {
      stddev = 0.5 * (averageDeviations[length / 2] + averageDeviations[length / 2 - 1]) / 0.6745;
    }

    return stddev;
  };

  const determineRealTop$1 = (peakList, x, y) => {
    let alpha, beta, gamma, p, currentPoint;

    for (let j = 0; j < peakList.length; j++) {
      currentPoint = peakList[j].index; // peakList[j][2];
      // The detected peak could be moved 1 or 2 units to left or right.

      if (y[currentPoint - 1] >= y[currentPoint - 2] && y[currentPoint - 1] >= y[currentPoint]) {
        currentPoint--;
      } else {
        if (y[currentPoint + 1] >= y[currentPoint] && y[currentPoint + 1] >= y[currentPoint + 2]) {
          currentPoint++;
        } else {
          if (y[currentPoint - 2] >= y[currentPoint - 3] && y[currentPoint - 2] >= y[currentPoint - 1]) {
            currentPoint -= 2;
          } else {
            if (y[currentPoint + 2] >= y[currentPoint + 1] && y[currentPoint + 2] >= y[currentPoint + 3]) {
              currentPoint += 2;
            }
          }
        }
      } // interpolation to a sin() function


      if (y[currentPoint - 1] > 0 && y[currentPoint + 1] > 0 && y[currentPoint] >= y[currentPoint - 1] && y[currentPoint] >= y[currentPoint + 1] && (y[currentPoint] !== y[currentPoint - 1] || y[currentPoint] !== y[currentPoint + 1])) {
        alpha = 20 * Math.log10(y[currentPoint - 1]);
        beta = 20 * Math.log10(y[currentPoint]);
        gamma = 20 * Math.log10(y[currentPoint + 1]);
        p = 0.5 * (alpha - gamma) / (alpha - 2 * beta + gamma); // console.log(alpha, beta, gamma, `p: ${p}`);
        // console.log(x[currentPoint]+" "+tmp+" "+currentPoint);

        peakList[j].x = x[currentPoint] + (x[currentPoint] - x[currentPoint - 1]) * p;
        peakList[j].y = y[currentPoint] - 0.25 * (y[currentPoint - 1] - y[currentPoint + 1]) * p;
      }
    }
  };

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function getDefaultExportFromCjs (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  var assignDeep$1 = {exports: {}};

  /*!
   * assign-symbols <https://github.com/jonschlinkert/assign-symbols>
   *
   * Copyright (c) 2015-present, Jon Schlinkert.
   * Licensed under the MIT License.
   */

  const toString$2 = Object.prototype.toString;
  const isEnumerable = Object.prototype.propertyIsEnumerable;
  const getSymbols = Object.getOwnPropertySymbols;

  var assignSymbols$1 = (target, ...args) => {
    if (!isObject$1(target)) {
      throw new TypeError('expected the first argument to be an object');
    }

    if (args.length === 0 || typeof Symbol !== 'function' || typeof getSymbols !== 'function') {
      return target;
    }

    for (let arg of args) {
      let names = getSymbols(arg);

      for (let key of names) {
        if (isEnumerable.call(arg, key)) {
          target[key] = arg[key];
        }
      }
    }

    return target;
  };

  function isObject$1(val) {
    return typeof val === 'function' || toString$2.call(val) === '[object Object]' || Array.isArray(val);
  }

  /*!
   * assign-deep <https://github.com/jonschlinkert/assign-deep>
   *
   * Copyright (c) 2017-present, Jon Schlinkert.
   * Released under the MIT License.
   */

  const toString$1 = Object.prototype.toString;
  const assignSymbols = assignSymbols$1;

  const isValidKey = key => {
    return key !== '__proto__' && key !== 'constructor' && key !== 'prototype';
  };

  const assign = assignDeep$1.exports = (target, ...args) => {
    let i = 0;
    if (isPrimitive(target)) target = args[i++];
    if (!target) target = {};

    for (; i < args.length; i++) {
      if (isObject(args[i])) {
        for (const key of Object.keys(args[i])) {
          if (isValidKey(key)) {
            if (isObject(target[key]) && isObject(args[i][key])) {
              assign(target[key], args[i][key]);
            } else {
              target[key] = args[i][key];
            }
          }
        }

        assignSymbols(target, args[i]);
      }
    }

    return target;
  };

  function isObject(val) {
    return typeof val === 'function' || toString$1.call(val) === '[object Object]';
  }

  function isPrimitive(val) {
    return typeof val === 'object' ? val === null : typeof val !== 'function';
  }

  var assignDeep = assignDeep$1.exports;

  const toString = Object.prototype.toString;
  function isAnyArray(object) {
    return toString.call(object).endsWith('Array]');
  }

  function max(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    }

    if (input.length === 0) {
      throw new TypeError('input must not be empty');
    }

    var _options$fromIndex = options.fromIndex,
        fromIndex = _options$fromIndex === void 0 ? 0 : _options$fromIndex,
        _options$toIndex = options.toIndex,
        toIndex = _options$toIndex === void 0 ? input.length : _options$toIndex;

    if (fromIndex < 0 || fromIndex >= input.length || !Number.isInteger(fromIndex)) {
      throw new Error('fromIndex must be a positive integer smaller than length');
    }

    if (toIndex <= fromIndex || toIndex > input.length || !Number.isInteger(toIndex)) {
      throw new Error('toIndex must be an integer greater than fromIndex and at most equal to length');
    }

    var maxValue = input[fromIndex];

    for (var i = fromIndex + 1; i < toIndex; i++) {
      if (input[i] > maxValue) maxValue = input[i];
    }

    return maxValue;
  }

  /**
   * This function calculates the spectrum as a sum of linear combination of gaussian and lorentzian functions. The pseudo voigt
   * parameters are divided in 4 batches. 1st: centers; 2nd: heights; 3th: widths; 4th: mu's ;
   * @param t Ordinate value
   * @param p Lorentzian parameters
   * @returns {*}
   */

  function sumOfGaussianLorentzians(p) {
    return function (t) {
      let nL = p.length / 4;
      let result = 0;

      for (let i = 0; i < nL; i++) {
        result += p[i + nL] * PseudoVoigt.fct(t - p[i], p[i + nL * 2], p[i + nL * 3]);
      }

      return result;
    };
  }

  /**
   * This function calculates the spectrum as a sum of gaussian functions. The Gaussian
   * parameters are divided in 3 batches. 1st: centers; 2nd: height; 3th: widths;
   * @param t Ordinate values
   * @param p Gaussian parameters
   * @returns {*}
   */

  function sumOfGaussians(p) {
    return function (t) {
      let nL = p.length / 3;
      let result = 0;

      for (let i = 0; i < nL; i++) {
        result += p[i + nL] * Gaussian.fct(t - p[i], p[i + nL * 2]);
      }

      return result;
    };
  }

  /**
   * This function calculates the spectrum as a sum of lorentzian functions. The Lorentzian
   * parameters are divided in 3 batches. 1st: centers; 2nd: heights; 3th: widths;
   * @param t Ordinate values
   * @param p Lorentzian parameters
   * @returns {*}
   */

  function sumOfLorentzians(p) {
    return function (t) {
      let nL = p.length / 3;
      let result = 0;

      for (let i = 0; i < nL; i++) {
        result += p[i + nL] * Lorentzian.fct(t - p[i], p[i + nL * 2]);
      }

      return result;
    };
  }

  function checkInput(data, peaks, options) {
    let {
      shape = {
        kind: 'gaussian'
      },
      optimization = {
        kind: 'lm'
      }
    } = options;

    if (typeof shape.kind !== 'string') {
      throw new Error('kind should be a string');
    }

    let kind = shape.kind.toLowerCase().replace(/[^a-z]/g, '');
    let paramsFunc;
    let defaultParameters;

    switch (kind) {
      case 'gaussian':
        paramsFunc = sumOfGaussians;
        defaultParameters = {
          x: {
            init: peak => peak.x,
            max: peak => peak.x + peak.width * 2,
            min: peak => peak.x - peak.width * 2,
            gradientDifference: peak => peak.width * 2e-3
          },
          y: {
            init: peak => peak.y,
            max: () => 1.5,
            min: () => 0,
            gradientDifference: () => 1e-3
          },
          width: {
            init: peak => peak.width,
            max: peak => peak.width * 4,
            min: peak => peak.width * 0.25,
            gradientDifference: peak => peak.width * 2e-3
          }
        };
        break;

      case 'lorentzian':
        paramsFunc = sumOfLorentzians;
        defaultParameters = {
          x: {
            init: peak => peak.x,
            max: peak => peak.x + peak.width * 2,
            min: peak => peak.x - peak.width * 2,
            gradientDifference: peak => peak.width * 2e-3
          },
          y: {
            init: peak => peak.y,
            max: () => 1.5,
            min: () => 0,
            gradientDifference: () => 1e-3
          },
          width: {
            init: peak => peak.width,
            max: peak => peak.width * 4,
            min: peak => peak.width * 0.25,
            gradientDifference: peak => peak.width * 2e-3
          }
        };
        break;

      case 'pseudovoigt':
        paramsFunc = sumOfGaussianLorentzians;
        defaultParameters = {
          x: {
            init: peak => peak.x,
            max: peak => peak.x + peak.width * 2,
            min: peak => peak.x - peak.width * 2,
            gradientDifference: peak => peak.width * 2e-3
          },
          y: {
            init: peak => peak.y,
            max: () => 1.5,
            min: () => 0,
            gradientDifference: () => 1e-3
          },
          width: {
            init: peak => peak.width,
            max: peak => peak.width * 4,
            min: peak => peak.width * 0.25,
            gradientDifference: peak => peak.width * 2e-3
          },
          mu: {
            init: peak => peak.mu !== undefined ? peak.mu : 0.5,
            min: () => 0,
            max: () => 1,
            gradientDifference: () => 0.01
          }
        };
        break;

      default:
        throw new Error('kind of shape is not supported');
    }

    let x = data.x;
    let maxY = max(data.y);
    let y = new Array(x.length);

    for (let i = 0; i < x.length; i++) {
      y[i] = data.y[i] / maxY;
    }

    for (let i = 0; i < peaks.length; i++) {
      peaks[i].y /= maxY;
    }

    let parameters = assignDeep({}, optimization.parameters, defaultParameters);

    for (let key in parameters) {
      for (let par in parameters[key]) {
        if (!Array.isArray(parameters[key][par])) {
          parameters[key][par] = [parameters[key][par]];
        }

        if (parameters[key][par].length !== 1 && parameters[key][par].length !== peaks.length) {
          throw new Error(`The length of ${key}-${par} is not correct`);
        }

        for (let index = 0; index < parameters[key][par].length; index++) {
          if (typeof parameters[key][par][index] === 'number') {
            let value = parameters[key][par][index];

            parameters[key][par][index] = () => value;
          }
        }
      }
    }

    optimization.parameters = parameters;
    return {
      y,
      x,
      maxY,
      peaks,
      paramsFunc,
      optimization
    };
  }

  function checkOptions$1(data, parameterizedFunction, options) {
    let {
      timeout,
      minValues,
      maxValues,
      initialValues,
      weights = 1,
      damping = 1e-2,
      dampingStepUp = 11,
      dampingStepDown = 9,
      maxIterations = 100,
      errorTolerance = 1e-7,
      centralDifference = false,
      gradientDifference = 10e-2,
      improvementThreshold = 1e-3
    } = options;

    if (damping <= 0) {
      throw new Error('The damping option must be a positive number');
    } else if (!data.x || !data.y) {
      throw new Error('The data parameter must have x and y elements');
    } else if (!isAnyArray(data.x) || data.x.length < 2 || !isAnyArray(data.y) || data.y.length < 2) {
      throw new Error('The data parameter elements must be an array with more than 2 points');
    } else if (data.x.length !== data.y.length) {
      throw new Error('The data parameter elements must have the same size');
    }

    let parameters = initialValues || new Array(parameterizedFunction.length).fill(1);
    let nbPoints = data.y.length;
    let parLen = parameters.length;
    maxValues = maxValues || new Array(parLen).fill(Number.MAX_SAFE_INTEGER);
    minValues = minValues || new Array(parLen).fill(Number.MIN_SAFE_INTEGER);

    if (maxValues.length !== minValues.length) {
      throw new Error('minValues and maxValues must be the same size');
    }

    if (!isAnyArray(parameters)) {
      throw new Error('initialValues must be an array');
    }

    if (typeof gradientDifference === 'number') {
      gradientDifference = new Array(parameters.length).fill(gradientDifference);
    } else if (isAnyArray(gradientDifference)) {
      if (gradientDifference.length !== parLen) {
        gradientDifference = new Array(parLen).fill(gradientDifference[0]);
      }
    } else {
      throw new Error('gradientDifference should be a number or array with length equal to the number of parameters');
    }

    let filler;

    if (typeof weights === 'number') {
      let value = 1 / weights ** 2;

      filler = () => value;
    } else if (isAnyArray(weights)) {
      if (weights.length < data.x.length) {
        let value = 1 / weights[0] ** 2;

        filler = () => value;
      } else {
        filler = i => 1 / weights[i] ** 2;
      }
    } else {
      throw new Error('weights should be a number or array with length equal to the number of data points');
    }

    let checkTimeout;

    if (timeout !== undefined) {
      if (typeof timeout !== 'number') {
        throw new Error('timeout should be a number');
      }

      let endTime = Date.now() + timeout * 1000;

      checkTimeout = () => Date.now() > endTime;
    } else {
      checkTimeout = () => false;
    }

    let weightSquare = new Array(data.x.length);

    for (let i = 0; i < nbPoints; i++) {
      weightSquare[i] = filler(i);
    }

    return {
      checkTimeout,
      minValues,
      maxValues,
      parameters,
      weightSquare,
      damping,
      dampingStepUp,
      dampingStepDown,
      maxIterations,
      errorTolerance,
      centralDifference,
      gradientDifference,
      improvementThreshold
    };
  }

  /**
   * the sum of the weighted squares of the errors (or weighted residuals) between the data.y
   * and the curve-fit function.
   * @ignore
   * @param {{x:Array<number>, y:Array<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
   * @param {Array<number>} parameters - Array of current parameter values
   * @param {function} parameterizedFunction - The parameters and returns a function with the independent variable as a parameter
   * @param {Array} weightSquare - Square of weights
   * @return {number}
   */
  function errorCalculation(data, parameters, parameterizedFunction, weightSquare) {
    let error = 0;
    const func = parameterizedFunction(parameters);

    for (let i = 0; i < data.x.length; i++) {
      error += Math.pow(data.y[i] - func(data.x[i]), 2) / weightSquare[i];
    }

    return error;
  }

  function min(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    }

    if (input.length === 0) {
      throw new TypeError('input must not be empty');
    }

    var _options$fromIndex = options.fromIndex,
        fromIndex = _options$fromIndex === void 0 ? 0 : _options$fromIndex,
        _options$toIndex = options.toIndex,
        toIndex = _options$toIndex === void 0 ? input.length : _options$toIndex;

    if (fromIndex < 0 || fromIndex >= input.length || !Number.isInteger(fromIndex)) {
      throw new Error('fromIndex must be a positive integer smaller than length');
    }

    if (toIndex <= fromIndex || toIndex > input.length || !Number.isInteger(toIndex)) {
      throw new Error('toIndex must be an integer greater than fromIndex and at most equal to length');
    }

    var minValue = input[fromIndex];

    for (var i = fromIndex + 1; i < toIndex; i++) {
      if (input[i] < minValue) minValue = input[i];
    }

    return minValue;
  }

  function rescale(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    } else if (input.length === 0) {
      throw new TypeError('input must not be empty');
    }

    var output;

    if (options.output !== undefined) {
      if (!isAnyArray(options.output)) {
        throw new TypeError('output option must be an array if specified');
      }

      output = options.output;
    } else {
      output = new Array(input.length);
    }

    var currentMin = min(input);
    var currentMax = max(input);

    if (currentMin === currentMax) {
      throw new RangeError('minimum and maximum input values are equal. Cannot rescale a constant array');
    }

    var _options$min = options.min,
        minValue = _options$min === void 0 ? options.autoMinMax ? currentMin : 0 : _options$min,
        _options$max = options.max,
        maxValue = _options$max === void 0 ? options.autoMinMax ? currentMax : 1 : _options$max;

    if (minValue >= maxValue) {
      throw new RangeError('min option must be smaller than max option');
    }

    var factor = (maxValue - minValue) / (currentMax - currentMin);

    for (var i = 0; i < input.length; i++) {
      output[i] = (input[i] - currentMin) * factor + minValue;
    }

    return output;
  }

  const indent = ' '.repeat(2);
  const indentData = ' '.repeat(4);
  function inspectMatrix() {
    return inspectMatrixWithOptions(this);
  }
  function inspectMatrixWithOptions(matrix, options = {}) {
    const {
      maxRows = 15,
      maxColumns = 10,
      maxNumSize = 8
    } = options;
    return `${matrix.constructor.name} {
${indent}[
${indentData}${inspectData(matrix, maxRows, maxColumns, maxNumSize)}
${indent}]
${indent}rows: ${matrix.rows}
${indent}columns: ${matrix.columns}
}`;
  }

  function inspectData(matrix, maxRows, maxColumns, maxNumSize) {
    const {
      rows,
      columns
    } = matrix;
    const maxI = Math.min(rows, maxRows);
    const maxJ = Math.min(columns, maxColumns);
    const result = [];

    for (let i = 0; i < maxI; i++) {
      let line = [];

      for (let j = 0; j < maxJ; j++) {
        line.push(formatNumber(matrix.get(i, j), maxNumSize));
      }

      result.push(`${line.join(' ')}`);
    }

    if (maxJ !== columns) {
      result[result.length - 1] += ` ... ${columns - maxColumns} more columns`;
    }

    if (maxI !== rows) {
      result.push(`... ${rows - maxRows} more rows`);
    }

    return result.join(`\n${indentData}`);
  }

  function formatNumber(num, maxNumSize) {
    const numStr = String(num);

    if (numStr.length <= maxNumSize) {
      return numStr.padEnd(maxNumSize, ' ');
    }

    const precise = num.toPrecision(maxNumSize - 2);

    if (precise.length <= maxNumSize) {
      return precise;
    }

    const exponential = num.toExponential(maxNumSize - 2);
    const eIndex = exponential.indexOf('e');
    const e = exponential.slice(eIndex);
    return exponential.slice(0, maxNumSize - e.length) + e;
  }

  function installMathOperations(AbstractMatrix, Matrix) {
    AbstractMatrix.prototype.add = function add(value) {
      if (typeof value === 'number') return this.addS(value);
      return this.addM(value);
    };

    AbstractMatrix.prototype.addS = function addS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) + value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.addM = function addM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) + matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.add = function add(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.add(value);
    };

    AbstractMatrix.prototype.sub = function sub(value) {
      if (typeof value === 'number') return this.subS(value);
      return this.subM(value);
    };

    AbstractMatrix.prototype.subS = function subS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) - value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.subM = function subM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) - matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.sub = function sub(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.sub(value);
    };

    AbstractMatrix.prototype.subtract = AbstractMatrix.prototype.sub;
    AbstractMatrix.prototype.subtractS = AbstractMatrix.prototype.subS;
    AbstractMatrix.prototype.subtractM = AbstractMatrix.prototype.subM;
    AbstractMatrix.subtract = AbstractMatrix.sub;

    AbstractMatrix.prototype.mul = function mul(value) {
      if (typeof value === 'number') return this.mulS(value);
      return this.mulM(value);
    };

    AbstractMatrix.prototype.mulS = function mulS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) * value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.mulM = function mulM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) * matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.mul = function mul(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.mul(value);
    };

    AbstractMatrix.prototype.multiply = AbstractMatrix.prototype.mul;
    AbstractMatrix.prototype.multiplyS = AbstractMatrix.prototype.mulS;
    AbstractMatrix.prototype.multiplyM = AbstractMatrix.prototype.mulM;
    AbstractMatrix.multiply = AbstractMatrix.mul;

    AbstractMatrix.prototype.div = function div(value) {
      if (typeof value === 'number') return this.divS(value);
      return this.divM(value);
    };

    AbstractMatrix.prototype.divS = function divS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) / value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.divM = function divM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) / matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.div = function div(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.div(value);
    };

    AbstractMatrix.prototype.divide = AbstractMatrix.prototype.div;
    AbstractMatrix.prototype.divideS = AbstractMatrix.prototype.divS;
    AbstractMatrix.prototype.divideM = AbstractMatrix.prototype.divM;
    AbstractMatrix.divide = AbstractMatrix.div;

    AbstractMatrix.prototype.mod = function mod(value) {
      if (typeof value === 'number') return this.modS(value);
      return this.modM(value);
    };

    AbstractMatrix.prototype.modS = function modS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) % value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.modM = function modM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) % matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.mod = function mod(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.mod(value);
    };

    AbstractMatrix.prototype.modulus = AbstractMatrix.prototype.mod;
    AbstractMatrix.prototype.modulusS = AbstractMatrix.prototype.modS;
    AbstractMatrix.prototype.modulusM = AbstractMatrix.prototype.modM;
    AbstractMatrix.modulus = AbstractMatrix.mod;

    AbstractMatrix.prototype.and = function and(value) {
      if (typeof value === 'number') return this.andS(value);
      return this.andM(value);
    };

    AbstractMatrix.prototype.andS = function andS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) & value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.andM = function andM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) & matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.and = function and(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.and(value);
    };

    AbstractMatrix.prototype.or = function or(value) {
      if (typeof value === 'number') return this.orS(value);
      return this.orM(value);
    };

    AbstractMatrix.prototype.orS = function orS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) | value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.orM = function orM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) | matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.or = function or(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.or(value);
    };

    AbstractMatrix.prototype.xor = function xor(value) {
      if (typeof value === 'number') return this.xorS(value);
      return this.xorM(value);
    };

    AbstractMatrix.prototype.xorS = function xorS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) ^ value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.xorM = function xorM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) ^ matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.xor = function xor(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.xor(value);
    };

    AbstractMatrix.prototype.leftShift = function leftShift(value) {
      if (typeof value === 'number') return this.leftShiftS(value);
      return this.leftShiftM(value);
    };

    AbstractMatrix.prototype.leftShiftS = function leftShiftS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) << value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.leftShiftM = function leftShiftM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) << matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.leftShift = function leftShift(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.leftShift(value);
    };

    AbstractMatrix.prototype.signPropagatingRightShift = function signPropagatingRightShift(value) {
      if (typeof value === 'number') return this.signPropagatingRightShiftS(value);
      return this.signPropagatingRightShiftM(value);
    };

    AbstractMatrix.prototype.signPropagatingRightShiftS = function signPropagatingRightShiftS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) >> value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.signPropagatingRightShiftM = function signPropagatingRightShiftM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) >> matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.signPropagatingRightShift = function signPropagatingRightShift(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.signPropagatingRightShift(value);
    };

    AbstractMatrix.prototype.rightShift = function rightShift(value) {
      if (typeof value === 'number') return this.rightShiftS(value);
      return this.rightShiftM(value);
    };

    AbstractMatrix.prototype.rightShiftS = function rightShiftS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) >>> value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.rightShiftM = function rightShiftM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) >>> matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.rightShift = function rightShift(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.rightShift(value);
    };

    AbstractMatrix.prototype.zeroFillRightShift = AbstractMatrix.prototype.rightShift;
    AbstractMatrix.prototype.zeroFillRightShiftS = AbstractMatrix.prototype.rightShiftS;
    AbstractMatrix.prototype.zeroFillRightShiftM = AbstractMatrix.prototype.rightShiftM;
    AbstractMatrix.zeroFillRightShift = AbstractMatrix.rightShift;

    AbstractMatrix.prototype.not = function not() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, ~this.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.not = function not(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.not();
    };

    AbstractMatrix.prototype.abs = function abs() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.abs(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.abs = function abs(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.abs();
    };

    AbstractMatrix.prototype.acos = function acos() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.acos(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.acos = function acos(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.acos();
    };

    AbstractMatrix.prototype.acosh = function acosh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.acosh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.acosh = function acosh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.acosh();
    };

    AbstractMatrix.prototype.asin = function asin() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.asin(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.asin = function asin(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.asin();
    };

    AbstractMatrix.prototype.asinh = function asinh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.asinh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.asinh = function asinh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.asinh();
    };

    AbstractMatrix.prototype.atan = function atan() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.atan(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.atan = function atan(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.atan();
    };

    AbstractMatrix.prototype.atanh = function atanh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.atanh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.atanh = function atanh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.atanh();
    };

    AbstractMatrix.prototype.cbrt = function cbrt() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.cbrt(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.cbrt = function cbrt(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.cbrt();
    };

    AbstractMatrix.prototype.ceil = function ceil() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.ceil(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.ceil = function ceil(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.ceil();
    };

    AbstractMatrix.prototype.clz32 = function clz32() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.clz32(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.clz32 = function clz32(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.clz32();
    };

    AbstractMatrix.prototype.cos = function cos() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.cos(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.cos = function cos(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.cos();
    };

    AbstractMatrix.prototype.cosh = function cosh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.cosh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.cosh = function cosh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.cosh();
    };

    AbstractMatrix.prototype.exp = function exp() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.exp(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.exp = function exp(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.exp();
    };

    AbstractMatrix.prototype.expm1 = function expm1() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.expm1(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.expm1 = function expm1(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.expm1();
    };

    AbstractMatrix.prototype.floor = function floor() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.floor(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.floor = function floor(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.floor();
    };

    AbstractMatrix.prototype.fround = function fround() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.fround(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.fround = function fround(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.fround();
    };

    AbstractMatrix.prototype.log = function log() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.log(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.log = function log(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.log();
    };

    AbstractMatrix.prototype.log1p = function log1p() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.log1p(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.log1p = function log1p(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.log1p();
    };

    AbstractMatrix.prototype.log10 = function log10() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.log10(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.log10 = function log10(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.log10();
    };

    AbstractMatrix.prototype.log2 = function log2() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.log2(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.log2 = function log2(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.log2();
    };

    AbstractMatrix.prototype.round = function round() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.round(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.round = function round(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.round();
    };

    AbstractMatrix.prototype.sign = function sign() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.sign(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.sign = function sign(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.sign();
    };

    AbstractMatrix.prototype.sin = function sin() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.sin(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.sin = function sin(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.sin();
    };

    AbstractMatrix.prototype.sinh = function sinh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.sinh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.sinh = function sinh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.sinh();
    };

    AbstractMatrix.prototype.sqrt = function sqrt() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.sqrt(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.sqrt = function sqrt(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.sqrt();
    };

    AbstractMatrix.prototype.tan = function tan() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.tan(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.tan = function tan(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.tan();
    };

    AbstractMatrix.prototype.tanh = function tanh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.tanh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.tanh = function tanh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.tanh();
    };

    AbstractMatrix.prototype.trunc = function trunc() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.trunc(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.trunc = function trunc(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.trunc();
    };

    AbstractMatrix.pow = function pow(matrix, arg0) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.pow(arg0);
    };

    AbstractMatrix.prototype.pow = function pow(value) {
      if (typeof value === 'number') return this.powS(value);
      return this.powM(value);
    };

    AbstractMatrix.prototype.powS = function powS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.pow(this.get(i, j), value));
        }
      }

      return this;
    };

    AbstractMatrix.prototype.powM = function powM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.pow(this.get(i, j), matrix.get(i, j)));
        }
      }

      return this;
    };
  }

  /**
   * @private
   * Check that a row index is not out of bounds
   * @param {Matrix} matrix
   * @param {number} index
   * @param {boolean} [outer]
   */
  function checkRowIndex(matrix, index, outer) {
    let max = outer ? matrix.rows : matrix.rows - 1;

    if (index < 0 || index > max) {
      throw new RangeError('Row index out of range');
    }
  }
  /**
   * @private
   * Check that a column index is not out of bounds
   * @param {Matrix} matrix
   * @param {number} index
   * @param {boolean} [outer]
   */

  function checkColumnIndex(matrix, index, outer) {
    let max = outer ? matrix.columns : matrix.columns - 1;

    if (index < 0 || index > max) {
      throw new RangeError('Column index out of range');
    }
  }
  /**
   * @private
   * Check that the provided vector is an array with the right length
   * @param {Matrix} matrix
   * @param {Array|Matrix} vector
   * @return {Array}
   * @throws {RangeError}
   */

  function checkRowVector(matrix, vector) {
    if (vector.to1DArray) {
      vector = vector.to1DArray();
    }

    if (vector.length !== matrix.columns) {
      throw new RangeError('vector size must be the same as the number of columns');
    }

    return vector;
  }
  /**
   * @private
   * Check that the provided vector is an array with the right length
   * @param {Matrix} matrix
   * @param {Array|Matrix} vector
   * @return {Array}
   * @throws {RangeError}
   */

  function checkColumnVector(matrix, vector) {
    if (vector.to1DArray) {
      vector = vector.to1DArray();
    }

    if (vector.length !== matrix.rows) {
      throw new RangeError('vector size must be the same as the number of rows');
    }

    return vector;
  }
  function checkIndices(matrix, rowIndices, columnIndices) {
    return {
      row: checkRowIndices(matrix, rowIndices),
      column: checkColumnIndices(matrix, columnIndices)
    };
  }
  function checkRowIndices(matrix, rowIndices) {
    if (typeof rowIndices !== 'object') {
      throw new TypeError('unexpected type for row indices');
    }

    let rowOut = rowIndices.some(r => {
      return r < 0 || r >= matrix.rows;
    });

    if (rowOut) {
      throw new RangeError('row indices are out of range');
    }

    if (!Array.isArray(rowIndices)) rowIndices = Array.from(rowIndices);
    return rowIndices;
  }
  function checkColumnIndices(matrix, columnIndices) {
    if (typeof columnIndices !== 'object') {
      throw new TypeError('unexpected type for column indices');
    }

    let columnOut = columnIndices.some(c => {
      return c < 0 || c >= matrix.columns;
    });

    if (columnOut) {
      throw new RangeError('column indices are out of range');
    }

    if (!Array.isArray(columnIndices)) columnIndices = Array.from(columnIndices);
    return columnIndices;
  }
  function checkRange(matrix, startRow, endRow, startColumn, endColumn) {
    if (arguments.length !== 5) {
      throw new RangeError('expected 4 arguments');
    }

    checkNumber('startRow', startRow);
    checkNumber('endRow', endRow);
    checkNumber('startColumn', startColumn);
    checkNumber('endColumn', endColumn);

    if (startRow > endRow || startColumn > endColumn || startRow < 0 || startRow >= matrix.rows || endRow < 0 || endRow >= matrix.rows || startColumn < 0 || startColumn >= matrix.columns || endColumn < 0 || endColumn >= matrix.columns) {
      throw new RangeError('Submatrix indices are out of range');
    }
  }
  function newArray$1(length, value = 0) {
    let array = [];

    for (let i = 0; i < length; i++) {
      array.push(value);
    }

    return array;
  }

  function checkNumber(name, value) {
    if (typeof value !== 'number') {
      throw new TypeError(`${name} must be a number`);
    }
  }

  function checkNonEmpty(matrix) {
    if (matrix.isEmpty()) {
      throw new Error('Empty matrix has no elements to index');
    }
  }

  function sumByRow(matrix) {
    let sum = newArray$1(matrix.rows);

    for (let i = 0; i < matrix.rows; ++i) {
      for (let j = 0; j < matrix.columns; ++j) {
        sum[i] += matrix.get(i, j);
      }
    }

    return sum;
  }
  function sumByColumn(matrix) {
    let sum = newArray$1(matrix.columns);

    for (let i = 0; i < matrix.rows; ++i) {
      for (let j = 0; j < matrix.columns; ++j) {
        sum[j] += matrix.get(i, j);
      }
    }

    return sum;
  }
  function sumAll(matrix) {
    let v = 0;

    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        v += matrix.get(i, j);
      }
    }

    return v;
  }
  function productByRow(matrix) {
    let sum = newArray$1(matrix.rows, 1);

    for (let i = 0; i < matrix.rows; ++i) {
      for (let j = 0; j < matrix.columns; ++j) {
        sum[i] *= matrix.get(i, j);
      }
    }

    return sum;
  }
  function productByColumn(matrix) {
    let sum = newArray$1(matrix.columns, 1);

    for (let i = 0; i < matrix.rows; ++i) {
      for (let j = 0; j < matrix.columns; ++j) {
        sum[j] *= matrix.get(i, j);
      }
    }

    return sum;
  }
  function productAll(matrix) {
    let v = 1;

    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        v *= matrix.get(i, j);
      }
    }

    return v;
  }
  function varianceByRow(matrix, unbiased, mean) {
    const rows = matrix.rows;
    const cols = matrix.columns;
    const variance = [];

    for (let i = 0; i < rows; i++) {
      let sum1 = 0;
      let sum2 = 0;
      let x = 0;

      for (let j = 0; j < cols; j++) {
        x = matrix.get(i, j) - mean[i];
        sum1 += x;
        sum2 += x * x;
      }

      if (unbiased) {
        variance.push((sum2 - sum1 * sum1 / cols) / (cols - 1));
      } else {
        variance.push((sum2 - sum1 * sum1 / cols) / cols);
      }
    }

    return variance;
  }
  function varianceByColumn(matrix, unbiased, mean) {
    const rows = matrix.rows;
    const cols = matrix.columns;
    const variance = [];

    for (let j = 0; j < cols; j++) {
      let sum1 = 0;
      let sum2 = 0;
      let x = 0;

      for (let i = 0; i < rows; i++) {
        x = matrix.get(i, j) - mean[j];
        sum1 += x;
        sum2 += x * x;
      }

      if (unbiased) {
        variance.push((sum2 - sum1 * sum1 / rows) / (rows - 1));
      } else {
        variance.push((sum2 - sum1 * sum1 / rows) / rows);
      }
    }

    return variance;
  }
  function varianceAll(matrix, unbiased, mean) {
    const rows = matrix.rows;
    const cols = matrix.columns;
    const size = rows * cols;
    let sum1 = 0;
    let sum2 = 0;
    let x = 0;

    for (let i = 0; i < rows; i++) {
      for (let j = 0; j < cols; j++) {
        x = matrix.get(i, j) - mean;
        sum1 += x;
        sum2 += x * x;
      }
    }

    if (unbiased) {
      return (sum2 - sum1 * sum1 / size) / (size - 1);
    } else {
      return (sum2 - sum1 * sum1 / size) / size;
    }
  }
  function centerByRow(matrix, mean) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) - mean[i]);
      }
    }
  }
  function centerByColumn(matrix, mean) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) - mean[j]);
      }
    }
  }
  function centerAll(matrix, mean) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) - mean);
      }
    }
  }
  function getScaleByRow(matrix) {
    const scale = [];

    for (let i = 0; i < matrix.rows; i++) {
      let sum = 0;

      for (let j = 0; j < matrix.columns; j++) {
        sum += Math.pow(matrix.get(i, j), 2) / (matrix.columns - 1);
      }

      scale.push(Math.sqrt(sum));
    }

    return scale;
  }
  function scaleByRow(matrix, scale) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) / scale[i]);
      }
    }
  }
  function getScaleByColumn(matrix) {
    const scale = [];

    for (let j = 0; j < matrix.columns; j++) {
      let sum = 0;

      for (let i = 0; i < matrix.rows; i++) {
        sum += Math.pow(matrix.get(i, j), 2) / (matrix.rows - 1);
      }

      scale.push(Math.sqrt(sum));
    }

    return scale;
  }
  function scaleByColumn(matrix, scale) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) / scale[j]);
      }
    }
  }
  function getScaleAll(matrix) {
    const divider = matrix.size - 1;
    let sum = 0;

    for (let j = 0; j < matrix.columns; j++) {
      for (let i = 0; i < matrix.rows; i++) {
        sum += Math.pow(matrix.get(i, j), 2) / divider;
      }
    }

    return Math.sqrt(sum);
  }
  function scaleAll(matrix, scale) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) / scale);
      }
    }
  }

  class AbstractMatrix {
    static from1DArray(newRows, newColumns, newData) {
      let length = newRows * newColumns;

      if (length !== newData.length) {
        throw new RangeError('data length does not match given dimensions');
      }

      let newMatrix = new Matrix(newRows, newColumns);

      for (let row = 0; row < newRows; row++) {
        for (let column = 0; column < newColumns; column++) {
          newMatrix.set(row, column, newData[row * newColumns + column]);
        }
      }

      return newMatrix;
    }

    static rowVector(newData) {
      let vector = new Matrix(1, newData.length);

      for (let i = 0; i < newData.length; i++) {
        vector.set(0, i, newData[i]);
      }

      return vector;
    }

    static columnVector(newData) {
      let vector = new Matrix(newData.length, 1);

      for (let i = 0; i < newData.length; i++) {
        vector.set(i, 0, newData[i]);
      }

      return vector;
    }

    static zeros(rows, columns) {
      return new Matrix(rows, columns);
    }

    static ones(rows, columns) {
      return new Matrix(rows, columns).fill(1);
    }

    static rand(rows, columns, options = {}) {
      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        random = Math.random
      } = options;
      let matrix = new Matrix(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          matrix.set(i, j, random());
        }
      }

      return matrix;
    }

    static randInt(rows, columns, options = {}) {
      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        min = 0,
        max = 1000,
        random = Math.random
      } = options;
      if (!Number.isInteger(min)) throw new TypeError('min must be an integer');
      if (!Number.isInteger(max)) throw new TypeError('max must be an integer');
      if (min >= max) throw new RangeError('min must be smaller than max');
      let interval = max - min;
      let matrix = new Matrix(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          let value = min + Math.round(random() * interval);
          matrix.set(i, j, value);
        }
      }

      return matrix;
    }

    static eye(rows, columns, value) {
      if (columns === undefined) columns = rows;
      if (value === undefined) value = 1;
      let min = Math.min(rows, columns);
      let matrix = this.zeros(rows, columns);

      for (let i = 0; i < min; i++) {
        matrix.set(i, i, value);
      }

      return matrix;
    }

    static diag(data, rows, columns) {
      let l = data.length;
      if (rows === undefined) rows = l;
      if (columns === undefined) columns = rows;
      let min = Math.min(l, rows, columns);
      let matrix = this.zeros(rows, columns);

      for (let i = 0; i < min; i++) {
        matrix.set(i, i, data[i]);
      }

      return matrix;
    }

    static min(matrix1, matrix2) {
      matrix1 = this.checkMatrix(matrix1);
      matrix2 = this.checkMatrix(matrix2);
      let rows = matrix1.rows;
      let columns = matrix1.columns;
      let result = new Matrix(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          result.set(i, j, Math.min(matrix1.get(i, j), matrix2.get(i, j)));
        }
      }

      return result;
    }

    static max(matrix1, matrix2) {
      matrix1 = this.checkMatrix(matrix1);
      matrix2 = this.checkMatrix(matrix2);
      let rows = matrix1.rows;
      let columns = matrix1.columns;
      let result = new this(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          result.set(i, j, Math.max(matrix1.get(i, j), matrix2.get(i, j)));
        }
      }

      return result;
    }

    static checkMatrix(value) {
      return AbstractMatrix.isMatrix(value) ? value : new Matrix(value);
    }

    static isMatrix(value) {
      return value != null && value.klass === 'Matrix';
    }

    get size() {
      return this.rows * this.columns;
    }

    apply(callback) {
      if (typeof callback !== 'function') {
        throw new TypeError('callback must be a function');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          callback.call(this, i, j);
        }
      }

      return this;
    }

    to1DArray() {
      let array = [];

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          array.push(this.get(i, j));
        }
      }

      return array;
    }

    to2DArray() {
      let copy = [];

      for (let i = 0; i < this.rows; i++) {
        copy.push([]);

        for (let j = 0; j < this.columns; j++) {
          copy[i].push(this.get(i, j));
        }
      }

      return copy;
    }

    toJSON() {
      return this.to2DArray();
    }

    isRowVector() {
      return this.rows === 1;
    }

    isColumnVector() {
      return this.columns === 1;
    }

    isVector() {
      return this.rows === 1 || this.columns === 1;
    }

    isSquare() {
      return this.rows === this.columns;
    }

    isEmpty() {
      return this.rows === 0 || this.columns === 0;
    }

    isSymmetric() {
      if (this.isSquare()) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j <= i; j++) {
            if (this.get(i, j) !== this.get(j, i)) {
              return false;
            }
          }
        }

        return true;
      }

      return false;
    }

    isEchelonForm() {
      let i = 0;
      let j = 0;
      let previousColumn = -1;
      let isEchelonForm = true;
      let checked = false;

      while (i < this.rows && isEchelonForm) {
        j = 0;
        checked = false;

        while (j < this.columns && checked === false) {
          if (this.get(i, j) === 0) {
            j++;
          } else if (this.get(i, j) === 1 && j > previousColumn) {
            checked = true;
            previousColumn = j;
          } else {
            isEchelonForm = false;
            checked = true;
          }
        }

        i++;
      }

      return isEchelonForm;
    }

    isReducedEchelonForm() {
      let i = 0;
      let j = 0;
      let previousColumn = -1;
      let isReducedEchelonForm = true;
      let checked = false;

      while (i < this.rows && isReducedEchelonForm) {
        j = 0;
        checked = false;

        while (j < this.columns && checked === false) {
          if (this.get(i, j) === 0) {
            j++;
          } else if (this.get(i, j) === 1 && j > previousColumn) {
            checked = true;
            previousColumn = j;
          } else {
            isReducedEchelonForm = false;
            checked = true;
          }
        }

        for (let k = j + 1; k < this.rows; k++) {
          if (this.get(i, k) !== 0) {
            isReducedEchelonForm = false;
          }
        }

        i++;
      }

      return isReducedEchelonForm;
    }

    echelonForm() {
      let result = this.clone();
      let h = 0;
      let k = 0;

      while (h < result.rows && k < result.columns) {
        let iMax = h;

        for (let i = h; i < result.rows; i++) {
          if (result.get(i, k) > result.get(iMax, k)) {
            iMax = i;
          }
        }

        if (result.get(iMax, k) === 0) {
          k++;
        } else {
          result.swapRows(h, iMax);
          let tmp = result.get(h, k);

          for (let j = k; j < result.columns; j++) {
            result.set(h, j, result.get(h, j) / tmp);
          }

          for (let i = h + 1; i < result.rows; i++) {
            let factor = result.get(i, k) / result.get(h, k);
            result.set(i, k, 0);

            for (let j = k + 1; j < result.columns; j++) {
              result.set(i, j, result.get(i, j) - result.get(h, j) * factor);
            }
          }

          h++;
          k++;
        }
      }

      return result;
    }

    reducedEchelonForm() {
      let result = this.echelonForm();
      let m = result.columns;
      let n = result.rows;
      let h = n - 1;

      while (h >= 0) {
        if (result.maxRow(h) === 0) {
          h--;
        } else {
          let p = 0;
          let pivot = false;

          while (p < n && pivot === false) {
            if (result.get(h, p) === 1) {
              pivot = true;
            } else {
              p++;
            }
          }

          for (let i = 0; i < h; i++) {
            let factor = result.get(i, p);

            for (let j = p; j < m; j++) {
              let tmp = result.get(i, j) - factor * result.get(h, j);
              result.set(i, j, tmp);
            }
          }

          h--;
        }
      }

      return result;
    }

    set() {
      throw new Error('set method is unimplemented');
    }

    get() {
      throw new Error('get method is unimplemented');
    }

    repeat(options = {}) {
      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        rows = 1,
        columns = 1
      } = options;

      if (!Number.isInteger(rows) || rows <= 0) {
        throw new TypeError('rows must be a positive integer');
      }

      if (!Number.isInteger(columns) || columns <= 0) {
        throw new TypeError('columns must be a positive integer');
      }

      let matrix = new Matrix(this.rows * rows, this.columns * columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          matrix.setSubMatrix(this, this.rows * i, this.columns * j);
        }
      }

      return matrix;
    }

    fill(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, value);
        }
      }

      return this;
    }

    neg() {
      return this.mulS(-1);
    }

    getRow(index) {
      checkRowIndex(this, index);
      let row = [];

      for (let i = 0; i < this.columns; i++) {
        row.push(this.get(index, i));
      }

      return row;
    }

    getRowVector(index) {
      return Matrix.rowVector(this.getRow(index));
    }

    setRow(index, array) {
      checkRowIndex(this, index);
      array = checkRowVector(this, array);

      for (let i = 0; i < this.columns; i++) {
        this.set(index, i, array[i]);
      }

      return this;
    }

    swapRows(row1, row2) {
      checkRowIndex(this, row1);
      checkRowIndex(this, row2);

      for (let i = 0; i < this.columns; i++) {
        let temp = this.get(row1, i);
        this.set(row1, i, this.get(row2, i));
        this.set(row2, i, temp);
      }

      return this;
    }

    getColumn(index) {
      checkColumnIndex(this, index);
      let column = [];

      for (let i = 0; i < this.rows; i++) {
        column.push(this.get(i, index));
      }

      return column;
    }

    getColumnVector(index) {
      return Matrix.columnVector(this.getColumn(index));
    }

    setColumn(index, array) {
      checkColumnIndex(this, index);
      array = checkColumnVector(this, array);

      for (let i = 0; i < this.rows; i++) {
        this.set(i, index, array[i]);
      }

      return this;
    }

    swapColumns(column1, column2) {
      checkColumnIndex(this, column1);
      checkColumnIndex(this, column2);

      for (let i = 0; i < this.rows; i++) {
        let temp = this.get(i, column1);
        this.set(i, column1, this.get(i, column2));
        this.set(i, column2, temp);
      }

      return this;
    }

    addRowVector(vector) {
      vector = checkRowVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) + vector[j]);
        }
      }

      return this;
    }

    subRowVector(vector) {
      vector = checkRowVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) - vector[j]);
        }
      }

      return this;
    }

    mulRowVector(vector) {
      vector = checkRowVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) * vector[j]);
        }
      }

      return this;
    }

    divRowVector(vector) {
      vector = checkRowVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) / vector[j]);
        }
      }

      return this;
    }

    addColumnVector(vector) {
      vector = checkColumnVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) + vector[i]);
        }
      }

      return this;
    }

    subColumnVector(vector) {
      vector = checkColumnVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) - vector[i]);
        }
      }

      return this;
    }

    mulColumnVector(vector) {
      vector = checkColumnVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) * vector[i]);
        }
      }

      return this;
    }

    divColumnVector(vector) {
      vector = checkColumnVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) / vector[i]);
        }
      }

      return this;
    }

    mulRow(index, value) {
      checkRowIndex(this, index);

      for (let i = 0; i < this.columns; i++) {
        this.set(index, i, this.get(index, i) * value);
      }

      return this;
    }

    mulColumn(index, value) {
      checkColumnIndex(this, index);

      for (let i = 0; i < this.rows; i++) {
        this.set(i, index, this.get(i, index) * value);
      }

      return this;
    }

    max() {
      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(0, 0);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          if (this.get(i, j) > v) {
            v = this.get(i, j);
          }
        }
      }

      return v;
    }

    maxIndex() {
      checkNonEmpty(this);
      let v = this.get(0, 0);
      let idx = [0, 0];

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          if (this.get(i, j) > v) {
            v = this.get(i, j);
            idx[0] = i;
            idx[1] = j;
          }
        }
      }

      return idx;
    }

    min() {
      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(0, 0);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          if (this.get(i, j) < v) {
            v = this.get(i, j);
          }
        }
      }

      return v;
    }

    minIndex() {
      checkNonEmpty(this);
      let v = this.get(0, 0);
      let idx = [0, 0];

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          if (this.get(i, j) < v) {
            v = this.get(i, j);
            idx[0] = i;
            idx[1] = j;
          }
        }
      }

      return idx;
    }

    maxRow(row) {
      checkRowIndex(this, row);

      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(row, 0);

      for (let i = 1; i < this.columns; i++) {
        if (this.get(row, i) > v) {
          v = this.get(row, i);
        }
      }

      return v;
    }

    maxRowIndex(row) {
      checkRowIndex(this, row);
      checkNonEmpty(this);
      let v = this.get(row, 0);
      let idx = [row, 0];

      for (let i = 1; i < this.columns; i++) {
        if (this.get(row, i) > v) {
          v = this.get(row, i);
          idx[1] = i;
        }
      }

      return idx;
    }

    minRow(row) {
      checkRowIndex(this, row);

      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(row, 0);

      for (let i = 1; i < this.columns; i++) {
        if (this.get(row, i) < v) {
          v = this.get(row, i);
        }
      }

      return v;
    }

    minRowIndex(row) {
      checkRowIndex(this, row);
      checkNonEmpty(this);
      let v = this.get(row, 0);
      let idx = [row, 0];

      for (let i = 1; i < this.columns; i++) {
        if (this.get(row, i) < v) {
          v = this.get(row, i);
          idx[1] = i;
        }
      }

      return idx;
    }

    maxColumn(column) {
      checkColumnIndex(this, column);

      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(0, column);

      for (let i = 1; i < this.rows; i++) {
        if (this.get(i, column) > v) {
          v = this.get(i, column);
        }
      }

      return v;
    }

    maxColumnIndex(column) {
      checkColumnIndex(this, column);
      checkNonEmpty(this);
      let v = this.get(0, column);
      let idx = [0, column];

      for (let i = 1; i < this.rows; i++) {
        if (this.get(i, column) > v) {
          v = this.get(i, column);
          idx[0] = i;
        }
      }

      return idx;
    }

    minColumn(column) {
      checkColumnIndex(this, column);

      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(0, column);

      for (let i = 1; i < this.rows; i++) {
        if (this.get(i, column) < v) {
          v = this.get(i, column);
        }
      }

      return v;
    }

    minColumnIndex(column) {
      checkColumnIndex(this, column);
      checkNonEmpty(this);
      let v = this.get(0, column);
      let idx = [0, column];

      for (let i = 1; i < this.rows; i++) {
        if (this.get(i, column) < v) {
          v = this.get(i, column);
          idx[0] = i;
        }
      }

      return idx;
    }

    diag() {
      let min = Math.min(this.rows, this.columns);
      let diag = [];

      for (let i = 0; i < min; i++) {
        diag.push(this.get(i, i));
      }

      return diag;
    }

    norm(type = 'frobenius') {
      let result = 0;

      if (type === 'max') {
        return this.max();
      } else if (type === 'frobenius') {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            result = result + this.get(i, j) * this.get(i, j);
          }
        }

        return Math.sqrt(result);
      } else {
        throw new RangeError(`unknown norm type: ${type}`);
      }
    }

    cumulativeSum() {
      let sum = 0;

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          sum += this.get(i, j);
          this.set(i, j, sum);
        }
      }

      return this;
    }

    dot(vector2) {
      if (AbstractMatrix.isMatrix(vector2)) vector2 = vector2.to1DArray();
      let vector1 = this.to1DArray();

      if (vector1.length !== vector2.length) {
        throw new RangeError('vectors do not have the same size');
      }

      let dot = 0;

      for (let i = 0; i < vector1.length; i++) {
        dot += vector1[i] * vector2[i];
      }

      return dot;
    }

    mmul(other) {
      other = Matrix.checkMatrix(other);
      let m = this.rows;
      let n = this.columns;
      let p = other.columns;
      let result = new Matrix(m, p);
      let Bcolj = new Float64Array(n);

      for (let j = 0; j < p; j++) {
        for (let k = 0; k < n; k++) {
          Bcolj[k] = other.get(k, j);
        }

        for (let i = 0; i < m; i++) {
          let s = 0;

          for (let k = 0; k < n; k++) {
            s += this.get(i, k) * Bcolj[k];
          }

          result.set(i, j, s);
        }
      }

      return result;
    }

    strassen2x2(other) {
      other = Matrix.checkMatrix(other);
      let result = new Matrix(2, 2);
      const a11 = this.get(0, 0);
      const b11 = other.get(0, 0);
      const a12 = this.get(0, 1);
      const b12 = other.get(0, 1);
      const a21 = this.get(1, 0);
      const b21 = other.get(1, 0);
      const a22 = this.get(1, 1);
      const b22 = other.get(1, 1); // Compute intermediate values.

      const m1 = (a11 + a22) * (b11 + b22);
      const m2 = (a21 + a22) * b11;
      const m3 = a11 * (b12 - b22);
      const m4 = a22 * (b21 - b11);
      const m5 = (a11 + a12) * b22;
      const m6 = (a21 - a11) * (b11 + b12);
      const m7 = (a12 - a22) * (b21 + b22); // Combine intermediate values into the output.

      const c00 = m1 + m4 - m5 + m7;
      const c01 = m3 + m5;
      const c10 = m2 + m4;
      const c11 = m1 - m2 + m3 + m6;
      result.set(0, 0, c00);
      result.set(0, 1, c01);
      result.set(1, 0, c10);
      result.set(1, 1, c11);
      return result;
    }

    strassen3x3(other) {
      other = Matrix.checkMatrix(other);
      let result = new Matrix(3, 3);
      const a00 = this.get(0, 0);
      const a01 = this.get(0, 1);
      const a02 = this.get(0, 2);
      const a10 = this.get(1, 0);
      const a11 = this.get(1, 1);
      const a12 = this.get(1, 2);
      const a20 = this.get(2, 0);
      const a21 = this.get(2, 1);
      const a22 = this.get(2, 2);
      const b00 = other.get(0, 0);
      const b01 = other.get(0, 1);
      const b02 = other.get(0, 2);
      const b10 = other.get(1, 0);
      const b11 = other.get(1, 1);
      const b12 = other.get(1, 2);
      const b20 = other.get(2, 0);
      const b21 = other.get(2, 1);
      const b22 = other.get(2, 2);
      const m1 = (a00 + a01 + a02 - a10 - a11 - a21 - a22) * b11;
      const m2 = (a00 - a10) * (-b01 + b11);
      const m3 = a11 * (-b00 + b01 + b10 - b11 - b12 - b20 + b22);
      const m4 = (-a00 + a10 + a11) * (b00 - b01 + b11);
      const m5 = (a10 + a11) * (-b00 + b01);
      const m6 = a00 * b00;
      const m7 = (-a00 + a20 + a21) * (b00 - b02 + b12);
      const m8 = (-a00 + a20) * (b02 - b12);
      const m9 = (a20 + a21) * (-b00 + b02);
      const m10 = (a00 + a01 + a02 - a11 - a12 - a20 - a21) * b12;
      const m11 = a21 * (-b00 + b02 + b10 - b11 - b12 - b20 + b21);
      const m12 = (-a02 + a21 + a22) * (b11 + b20 - b21);
      const m13 = (a02 - a22) * (b11 - b21);
      const m14 = a02 * b20;
      const m15 = (a21 + a22) * (-b20 + b21);
      const m16 = (-a02 + a11 + a12) * (b12 + b20 - b22);
      const m17 = (a02 - a12) * (b12 - b22);
      const m18 = (a11 + a12) * (-b20 + b22);
      const m19 = a01 * b10;
      const m20 = a12 * b21;
      const m21 = a10 * b02;
      const m22 = a20 * b01;
      const m23 = a22 * b22;
      const c00 = m6 + m14 + m19;
      const c01 = m1 + m4 + m5 + m6 + m12 + m14 + m15;
      const c02 = m6 + m7 + m9 + m10 + m14 + m16 + m18;
      const c10 = m2 + m3 + m4 + m6 + m14 + m16 + m17;
      const c11 = m2 + m4 + m5 + m6 + m20;
      const c12 = m14 + m16 + m17 + m18 + m21;
      const c20 = m6 + m7 + m8 + m11 + m12 + m13 + m14;
      const c21 = m12 + m13 + m14 + m15 + m22;
      const c22 = m6 + m7 + m8 + m9 + m23;
      result.set(0, 0, c00);
      result.set(0, 1, c01);
      result.set(0, 2, c02);
      result.set(1, 0, c10);
      result.set(1, 1, c11);
      result.set(1, 2, c12);
      result.set(2, 0, c20);
      result.set(2, 1, c21);
      result.set(2, 2, c22);
      return result;
    }

    mmulStrassen(y) {
      y = Matrix.checkMatrix(y);
      let x = this.clone();
      let r1 = x.rows;
      let c1 = x.columns;
      let r2 = y.rows;
      let c2 = y.columns;

      if (c1 !== r2) {
        // eslint-disable-next-line no-console
        console.warn(`Multiplying ${r1} x ${c1} and ${r2} x ${c2} matrix: dimensions do not match.`);
      } // Put a matrix into the top left of a matrix of zeros.
      // `rows` and `cols` are the dimensions of the output matrix.


      function embed(mat, rows, cols) {
        let r = mat.rows;
        let c = mat.columns;

        if (r === rows && c === cols) {
          return mat;
        } else {
          let resultat = AbstractMatrix.zeros(rows, cols);
          resultat = resultat.setSubMatrix(mat, 0, 0);
          return resultat;
        }
      } // Make sure both matrices are the same size.
      // This is exclusively for simplicity:
      // this algorithm can be implemented with matrices of different sizes.


      let r = Math.max(r1, r2);
      let c = Math.max(c1, c2);
      x = embed(x, r, c);
      y = embed(y, r, c); // Our recursive multiplication function.

      function blockMult(a, b, rows, cols) {
        // For small matrices, resort to naive multiplication.
        if (rows <= 512 || cols <= 512) {
          return a.mmul(b); // a is equivalent to this
        } // Apply dynamic padding.


        if (rows % 2 === 1 && cols % 2 === 1) {
          a = embed(a, rows + 1, cols + 1);
          b = embed(b, rows + 1, cols + 1);
        } else if (rows % 2 === 1) {
          a = embed(a, rows + 1, cols);
          b = embed(b, rows + 1, cols);
        } else if (cols % 2 === 1) {
          a = embed(a, rows, cols + 1);
          b = embed(b, rows, cols + 1);
        }

        let halfRows = parseInt(a.rows / 2, 10);
        let halfCols = parseInt(a.columns / 2, 10); // Subdivide input matrices.

        let a11 = a.subMatrix(0, halfRows - 1, 0, halfCols - 1);
        let b11 = b.subMatrix(0, halfRows - 1, 0, halfCols - 1);
        let a12 = a.subMatrix(0, halfRows - 1, halfCols, a.columns - 1);
        let b12 = b.subMatrix(0, halfRows - 1, halfCols, b.columns - 1);
        let a21 = a.subMatrix(halfRows, a.rows - 1, 0, halfCols - 1);
        let b21 = b.subMatrix(halfRows, b.rows - 1, 0, halfCols - 1);
        let a22 = a.subMatrix(halfRows, a.rows - 1, halfCols, a.columns - 1);
        let b22 = b.subMatrix(halfRows, b.rows - 1, halfCols, b.columns - 1); // Compute intermediate values.

        let m1 = blockMult(AbstractMatrix.add(a11, a22), AbstractMatrix.add(b11, b22), halfRows, halfCols);
        let m2 = blockMult(AbstractMatrix.add(a21, a22), b11, halfRows, halfCols);
        let m3 = blockMult(a11, AbstractMatrix.sub(b12, b22), halfRows, halfCols);
        let m4 = blockMult(a22, AbstractMatrix.sub(b21, b11), halfRows, halfCols);
        let m5 = blockMult(AbstractMatrix.add(a11, a12), b22, halfRows, halfCols);
        let m6 = blockMult(AbstractMatrix.sub(a21, a11), AbstractMatrix.add(b11, b12), halfRows, halfCols);
        let m7 = blockMult(AbstractMatrix.sub(a12, a22), AbstractMatrix.add(b21, b22), halfRows, halfCols); // Combine intermediate values into the output.

        let c11 = AbstractMatrix.add(m1, m4);
        c11.sub(m5);
        c11.add(m7);
        let c12 = AbstractMatrix.add(m3, m5);
        let c21 = AbstractMatrix.add(m2, m4);
        let c22 = AbstractMatrix.sub(m1, m2);
        c22.add(m3);
        c22.add(m6); // Crop output to the desired size (undo dynamic padding).

        let resultat = AbstractMatrix.zeros(2 * c11.rows, 2 * c11.columns);
        resultat = resultat.setSubMatrix(c11, 0, 0);
        resultat = resultat.setSubMatrix(c12, c11.rows, 0);
        resultat = resultat.setSubMatrix(c21, 0, c11.columns);
        resultat = resultat.setSubMatrix(c22, c11.rows, c11.columns);
        return resultat.subMatrix(0, rows - 1, 0, cols - 1);
      }

      return blockMult(x, y, r, c);
    }

    scaleRows(options = {}) {
      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        min = 0,
        max = 1
      } = options;
      if (!Number.isFinite(min)) throw new TypeError('min must be a number');
      if (!Number.isFinite(max)) throw new TypeError('max must be a number');
      if (min >= max) throw new RangeError('min must be smaller than max');
      let newMatrix = new Matrix(this.rows, this.columns);

      for (let i = 0; i < this.rows; i++) {
        const row = this.getRow(i);

        if (row.length > 0) {
          rescale(row, {
            min,
            max,
            output: row
          });
        }

        newMatrix.setRow(i, row);
      }

      return newMatrix;
    }

    scaleColumns(options = {}) {
      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        min = 0,
        max = 1
      } = options;
      if (!Number.isFinite(min)) throw new TypeError('min must be a number');
      if (!Number.isFinite(max)) throw new TypeError('max must be a number');
      if (min >= max) throw new RangeError('min must be smaller than max');
      let newMatrix = new Matrix(this.rows, this.columns);

      for (let i = 0; i < this.columns; i++) {
        const column = this.getColumn(i);

        if (column.length) {
          rescale(column, {
            min: min,
            max: max,
            output: column
          });
        }

        newMatrix.setColumn(i, column);
      }

      return newMatrix;
    }

    flipRows() {
      const middle = Math.ceil(this.columns / 2);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < middle; j++) {
          let first = this.get(i, j);
          let last = this.get(i, this.columns - 1 - j);
          this.set(i, j, last);
          this.set(i, this.columns - 1 - j, first);
        }
      }

      return this;
    }

    flipColumns() {
      const middle = Math.ceil(this.rows / 2);

      for (let j = 0; j < this.columns; j++) {
        for (let i = 0; i < middle; i++) {
          let first = this.get(i, j);
          let last = this.get(this.rows - 1 - i, j);
          this.set(i, j, last);
          this.set(this.rows - 1 - i, j, first);
        }
      }

      return this;
    }

    kroneckerProduct(other) {
      other = Matrix.checkMatrix(other);
      let m = this.rows;
      let n = this.columns;
      let p = other.rows;
      let q = other.columns;
      let result = new Matrix(m * p, n * q);

      for (let i = 0; i < m; i++) {
        for (let j = 0; j < n; j++) {
          for (let k = 0; k < p; k++) {
            for (let l = 0; l < q; l++) {
              result.set(p * i + k, q * j + l, this.get(i, j) * other.get(k, l));
            }
          }
        }
      }

      return result;
    }

    kroneckerSum(other) {
      other = Matrix.checkMatrix(other);

      if (!this.isSquare() || !other.isSquare()) {
        throw new Error('Kronecker Sum needs two Square Matrices');
      }

      let m = this.rows;
      let n = other.rows;
      let AxI = this.kroneckerProduct(Matrix.eye(n, n));
      let IxB = Matrix.eye(m, m).kroneckerProduct(other);
      return AxI.add(IxB);
    }

    transpose() {
      let result = new Matrix(this.columns, this.rows);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          result.set(j, i, this.get(i, j));
        }
      }

      return result;
    }

    sortRows(compareFunction = compareNumbers) {
      for (let i = 0; i < this.rows; i++) {
        this.setRow(i, this.getRow(i).sort(compareFunction));
      }

      return this;
    }

    sortColumns(compareFunction = compareNumbers) {
      for (let i = 0; i < this.columns; i++) {
        this.setColumn(i, this.getColumn(i).sort(compareFunction));
      }

      return this;
    }

    subMatrix(startRow, endRow, startColumn, endColumn) {
      checkRange(this, startRow, endRow, startColumn, endColumn);
      let newMatrix = new Matrix(endRow - startRow + 1, endColumn - startColumn + 1);

      for (let i = startRow; i <= endRow; i++) {
        for (let j = startColumn; j <= endColumn; j++) {
          newMatrix.set(i - startRow, j - startColumn, this.get(i, j));
        }
      }

      return newMatrix;
    }

    subMatrixRow(indices, startColumn, endColumn) {
      if (startColumn === undefined) startColumn = 0;
      if (endColumn === undefined) endColumn = this.columns - 1;

      if (startColumn > endColumn || startColumn < 0 || startColumn >= this.columns || endColumn < 0 || endColumn >= this.columns) {
        throw new RangeError('Argument out of range');
      }

      let newMatrix = new Matrix(indices.length, endColumn - startColumn + 1);

      for (let i = 0; i < indices.length; i++) {
        for (let j = startColumn; j <= endColumn; j++) {
          if (indices[i] < 0 || indices[i] >= this.rows) {
            throw new RangeError(`Row index out of range: ${indices[i]}`);
          }

          newMatrix.set(i, j - startColumn, this.get(indices[i], j));
        }
      }

      return newMatrix;
    }

    subMatrixColumn(indices, startRow, endRow) {
      if (startRow === undefined) startRow = 0;
      if (endRow === undefined) endRow = this.rows - 1;

      if (startRow > endRow || startRow < 0 || startRow >= this.rows || endRow < 0 || endRow >= this.rows) {
        throw new RangeError('Argument out of range');
      }

      let newMatrix = new Matrix(endRow - startRow + 1, indices.length);

      for (let i = 0; i < indices.length; i++) {
        for (let j = startRow; j <= endRow; j++) {
          if (indices[i] < 0 || indices[i] >= this.columns) {
            throw new RangeError(`Column index out of range: ${indices[i]}`);
          }

          newMatrix.set(j - startRow, i, this.get(j, indices[i]));
        }
      }

      return newMatrix;
    }

    setSubMatrix(matrix, startRow, startColumn) {
      matrix = Matrix.checkMatrix(matrix);

      if (matrix.isEmpty()) {
        return this;
      }

      let endRow = startRow + matrix.rows - 1;
      let endColumn = startColumn + matrix.columns - 1;
      checkRange(this, startRow, endRow, startColumn, endColumn);

      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          this.set(startRow + i, startColumn + j, matrix.get(i, j));
        }
      }

      return this;
    }

    selection(rowIndices, columnIndices) {
      let indices = checkIndices(this, rowIndices, columnIndices);
      let newMatrix = new Matrix(rowIndices.length, columnIndices.length);

      for (let i = 0; i < indices.row.length; i++) {
        let rowIndex = indices.row[i];

        for (let j = 0; j < indices.column.length; j++) {
          let columnIndex = indices.column[j];
          newMatrix.set(i, j, this.get(rowIndex, columnIndex));
        }
      }

      return newMatrix;
    }

    trace() {
      let min = Math.min(this.rows, this.columns);
      let trace = 0;

      for (let i = 0; i < min; i++) {
        trace += this.get(i, i);
      }

      return trace;
    }

    clone() {
      let newMatrix = new Matrix(this.rows, this.columns);

      for (let row = 0; row < this.rows; row++) {
        for (let column = 0; column < this.columns; column++) {
          newMatrix.set(row, column, this.get(row, column));
        }
      }

      return newMatrix;
    }

    sum(by) {
      switch (by) {
        case 'row':
          return sumByRow(this);

        case 'column':
          return sumByColumn(this);

        case undefined:
          return sumAll(this);

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    product(by) {
      switch (by) {
        case 'row':
          return productByRow(this);

        case 'column':
          return productByColumn(this);

        case undefined:
          return productAll(this);

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    mean(by) {
      const sum = this.sum(by);

      switch (by) {
        case 'row':
          {
            for (let i = 0; i < this.rows; i++) {
              sum[i] /= this.columns;
            }

            return sum;
          }

        case 'column':
          {
            for (let i = 0; i < this.columns; i++) {
              sum[i] /= this.rows;
            }

            return sum;
          }

        case undefined:
          return sum / this.size;

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    variance(by, options = {}) {
      if (typeof by === 'object') {
        options = by;
        by = undefined;
      }

      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        unbiased = true,
        mean = this.mean(by)
      } = options;

      if (typeof unbiased !== 'boolean') {
        throw new TypeError('unbiased must be a boolean');
      }

      switch (by) {
        case 'row':
          {
            if (!Array.isArray(mean)) {
              throw new TypeError('mean must be an array');
            }

            return varianceByRow(this, unbiased, mean);
          }

        case 'column':
          {
            if (!Array.isArray(mean)) {
              throw new TypeError('mean must be an array');
            }

            return varianceByColumn(this, unbiased, mean);
          }

        case undefined:
          {
            if (typeof mean !== 'number') {
              throw new TypeError('mean must be a number');
            }

            return varianceAll(this, unbiased, mean);
          }

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    standardDeviation(by, options) {
      if (typeof by === 'object') {
        options = by;
        by = undefined;
      }

      const variance = this.variance(by, options);

      if (by === undefined) {
        return Math.sqrt(variance);
      } else {
        for (let i = 0; i < variance.length; i++) {
          variance[i] = Math.sqrt(variance[i]);
        }

        return variance;
      }
    }

    center(by, options = {}) {
      if (typeof by === 'object') {
        options = by;
        by = undefined;
      }

      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        center = this.mean(by)
      } = options;

      switch (by) {
        case 'row':
          {
            if (!Array.isArray(center)) {
              throw new TypeError('center must be an array');
            }

            centerByRow(this, center);
            return this;
          }

        case 'column':
          {
            if (!Array.isArray(center)) {
              throw new TypeError('center must be an array');
            }

            centerByColumn(this, center);
            return this;
          }

        case undefined:
          {
            if (typeof center !== 'number') {
              throw new TypeError('center must be a number');
            }

            centerAll(this, center);
            return this;
          }

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    scale(by, options = {}) {
      if (typeof by === 'object') {
        options = by;
        by = undefined;
      }

      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      let scale = options.scale;

      switch (by) {
        case 'row':
          {
            if (scale === undefined) {
              scale = getScaleByRow(this);
            } else if (!Array.isArray(scale)) {
              throw new TypeError('scale must be an array');
            }

            scaleByRow(this, scale);
            return this;
          }

        case 'column':
          {
            if (scale === undefined) {
              scale = getScaleByColumn(this);
            } else if (!Array.isArray(scale)) {
              throw new TypeError('scale must be an array');
            }

            scaleByColumn(this, scale);
            return this;
          }

        case undefined:
          {
            if (scale === undefined) {
              scale = getScaleAll(this);
            } else if (typeof scale !== 'number') {
              throw new TypeError('scale must be a number');
            }

            scaleAll(this, scale);
            return this;
          }

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    toString(options) {
      return inspectMatrixWithOptions(this, options);
    }

  }
  AbstractMatrix.prototype.klass = 'Matrix';

  if (typeof Symbol !== 'undefined') {
    AbstractMatrix.prototype[Symbol.for('nodejs.util.inspect.custom')] = inspectMatrix;
  }

  function compareNumbers(a, b) {
    return a - b;
  } // Synonyms


  AbstractMatrix.random = AbstractMatrix.rand;
  AbstractMatrix.randomInt = AbstractMatrix.randInt;
  AbstractMatrix.diagonal = AbstractMatrix.diag;
  AbstractMatrix.prototype.diagonal = AbstractMatrix.prototype.diag;
  AbstractMatrix.identity = AbstractMatrix.eye;
  AbstractMatrix.prototype.negate = AbstractMatrix.prototype.neg;
  AbstractMatrix.prototype.tensorProduct = AbstractMatrix.prototype.kroneckerProduct;
  class Matrix extends AbstractMatrix {
    constructor(nRows, nColumns) {
      super();

      if (Matrix.isMatrix(nRows)) {
        // eslint-disable-next-line no-constructor-return
        return nRows.clone();
      } else if (Number.isInteger(nRows) && nRows >= 0) {
        // Create an empty matrix
        this.data = [];

        if (Number.isInteger(nColumns) && nColumns >= 0) {
          for (let i = 0; i < nRows; i++) {
            this.data.push(new Float64Array(nColumns));
          }
        } else {
          throw new TypeError('nColumns must be a positive integer');
        }
      } else if (Array.isArray(nRows)) {
        // Copy the values from the 2D array
        const arrayData = nRows;
        nRows = arrayData.length;
        nColumns = nRows ? arrayData[0].length : 0;

        if (typeof nColumns !== 'number') {
          throw new TypeError('Data must be a 2D array with at least one element');
        }

        this.data = [];

        for (let i = 0; i < nRows; i++) {
          if (arrayData[i].length !== nColumns) {
            throw new RangeError('Inconsistent array dimensions');
          }

          this.data.push(Float64Array.from(arrayData[i]));
        }
      } else {
        throw new TypeError('First argument must be a positive number or an array');
      }

      this.rows = nRows;
      this.columns = nColumns;
    }

    set(rowIndex, columnIndex, value) {
      this.data[rowIndex][columnIndex] = value;
      return this;
    }

    get(rowIndex, columnIndex) {
      return this.data[rowIndex][columnIndex];
    }

    removeRow(index) {
      checkRowIndex(this, index);
      this.data.splice(index, 1);
      this.rows -= 1;
      return this;
    }

    addRow(index, array) {
      if (array === undefined) {
        array = index;
        index = this.rows;
      }

      checkRowIndex(this, index, true);
      array = Float64Array.from(checkRowVector(this, array));
      this.data.splice(index, 0, array);
      this.rows += 1;
      return this;
    }

    removeColumn(index) {
      checkColumnIndex(this, index);

      for (let i = 0; i < this.rows; i++) {
        const newRow = new Float64Array(this.columns - 1);

        for (let j = 0; j < index; j++) {
          newRow[j] = this.data[i][j];
        }

        for (let j = index + 1; j < this.columns; j++) {
          newRow[j - 1] = this.data[i][j];
        }

        this.data[i] = newRow;
      }

      this.columns -= 1;
      return this;
    }

    addColumn(index, array) {
      if (typeof array === 'undefined') {
        array = index;
        index = this.columns;
      }

      checkColumnIndex(this, index, true);
      array = checkColumnVector(this, array);

      for (let i = 0; i < this.rows; i++) {
        const newRow = new Float64Array(this.columns + 1);
        let j = 0;

        for (; j < index; j++) {
          newRow[j] = this.data[i][j];
        }

        newRow[j++] = array[i];

        for (; j < this.columns + 1; j++) {
          newRow[j] = this.data[i][j - 1];
        }

        this.data[i] = newRow;
      }

      this.columns += 1;
      return this;
    }

  }
  installMathOperations(AbstractMatrix, Matrix);

  class WrapperMatrix2D extends AbstractMatrix {
    constructor(data) {
      super();
      this.data = data;
      this.rows = data.length;
      this.columns = data[0].length;
    }

    set(rowIndex, columnIndex, value) {
      this.data[rowIndex][columnIndex] = value;
      return this;
    }

    get(rowIndex, columnIndex) {
      return this.data[rowIndex][columnIndex];
    }

  }

  class LuDecomposition {
    constructor(matrix) {
      matrix = WrapperMatrix2D.checkMatrix(matrix);
      let lu = matrix.clone();
      let rows = lu.rows;
      let columns = lu.columns;
      let pivotVector = new Float64Array(rows);
      let pivotSign = 1;
      let i, j, k, p, s, t, v;
      let LUcolj, kmax;

      for (i = 0; i < rows; i++) {
        pivotVector[i] = i;
      }

      LUcolj = new Float64Array(rows);

      for (j = 0; j < columns; j++) {
        for (i = 0; i < rows; i++) {
          LUcolj[i] = lu.get(i, j);
        }

        for (i = 0; i < rows; i++) {
          kmax = Math.min(i, j);
          s = 0;

          for (k = 0; k < kmax; k++) {
            s += lu.get(i, k) * LUcolj[k];
          }

          LUcolj[i] -= s;
          lu.set(i, j, LUcolj[i]);
        }

        p = j;

        for (i = j + 1; i < rows; i++) {
          if (Math.abs(LUcolj[i]) > Math.abs(LUcolj[p])) {
            p = i;
          }
        }

        if (p !== j) {
          for (k = 0; k < columns; k++) {
            t = lu.get(p, k);
            lu.set(p, k, lu.get(j, k));
            lu.set(j, k, t);
          }

          v = pivotVector[p];
          pivotVector[p] = pivotVector[j];
          pivotVector[j] = v;
          pivotSign = -pivotSign;
        }

        if (j < rows && lu.get(j, j) !== 0) {
          for (i = j + 1; i < rows; i++) {
            lu.set(i, j, lu.get(i, j) / lu.get(j, j));
          }
        }
      }

      this.LU = lu;
      this.pivotVector = pivotVector;
      this.pivotSign = pivotSign;
    }

    isSingular() {
      let data = this.LU;
      let col = data.columns;

      for (let j = 0; j < col; j++) {
        if (data.get(j, j) === 0) {
          return true;
        }
      }

      return false;
    }

    solve(value) {
      value = Matrix.checkMatrix(value);
      let lu = this.LU;
      let rows = lu.rows;

      if (rows !== value.rows) {
        throw new Error('Invalid matrix dimensions');
      }

      if (this.isSingular()) {
        throw new Error('LU matrix is singular');
      }

      let count = value.columns;
      let X = value.subMatrixRow(this.pivotVector, 0, count - 1);
      let columns = lu.columns;
      let i, j, k;

      for (k = 0; k < columns; k++) {
        for (i = k + 1; i < columns; i++) {
          for (j = 0; j < count; j++) {
            X.set(i, j, X.get(i, j) - X.get(k, j) * lu.get(i, k));
          }
        }
      }

      for (k = columns - 1; k >= 0; k--) {
        for (j = 0; j < count; j++) {
          X.set(k, j, X.get(k, j) / lu.get(k, k));
        }

        for (i = 0; i < k; i++) {
          for (j = 0; j < count; j++) {
            X.set(i, j, X.get(i, j) - X.get(k, j) * lu.get(i, k));
          }
        }
      }

      return X;
    }

    get determinant() {
      let data = this.LU;

      if (!data.isSquare()) {
        throw new Error('Matrix must be square');
      }

      let determinant = this.pivotSign;
      let col = data.columns;

      for (let j = 0; j < col; j++) {
        determinant *= data.get(j, j);
      }

      return determinant;
    }

    get lowerTriangularMatrix() {
      let data = this.LU;
      let rows = data.rows;
      let columns = data.columns;
      let X = new Matrix(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          if (i > j) {
            X.set(i, j, data.get(i, j));
          } else if (i === j) {
            X.set(i, j, 1);
          } else {
            X.set(i, j, 0);
          }
        }
      }

      return X;
    }

    get upperTriangularMatrix() {
      let data = this.LU;
      let rows = data.rows;
      let columns = data.columns;
      let X = new Matrix(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          if (i <= j) {
            X.set(i, j, data.get(i, j));
          } else {
            X.set(i, j, 0);
          }
        }
      }

      return X;
    }

    get pivotPermutationVector() {
      return Array.from(this.pivotVector);
    }

  }

  function hypotenuse(a, b) {
    let r = 0;

    if (Math.abs(a) > Math.abs(b)) {
      r = b / a;
      return Math.abs(a) * Math.sqrt(1 + r * r);
    }

    if (b !== 0) {
      r = a / b;
      return Math.abs(b) * Math.sqrt(1 + r * r);
    }

    return 0;
  }

  class QrDecomposition {
    constructor(value) {
      value = WrapperMatrix2D.checkMatrix(value);
      let qr = value.clone();
      let m = value.rows;
      let n = value.columns;
      let rdiag = new Float64Array(n);
      let i, j, k, s;

      for (k = 0; k < n; k++) {
        let nrm = 0;

        for (i = k; i < m; i++) {
          nrm = hypotenuse(nrm, qr.get(i, k));
        }

        if (nrm !== 0) {
          if (qr.get(k, k) < 0) {
            nrm = -nrm;
          }

          for (i = k; i < m; i++) {
            qr.set(i, k, qr.get(i, k) / nrm);
          }

          qr.set(k, k, qr.get(k, k) + 1);

          for (j = k + 1; j < n; j++) {
            s = 0;

            for (i = k; i < m; i++) {
              s += qr.get(i, k) * qr.get(i, j);
            }

            s = -s / qr.get(k, k);

            for (i = k; i < m; i++) {
              qr.set(i, j, qr.get(i, j) + s * qr.get(i, k));
            }
          }
        }

        rdiag[k] = -nrm;
      }

      this.QR = qr;
      this.Rdiag = rdiag;
    }

    solve(value) {
      value = Matrix.checkMatrix(value);
      let qr = this.QR;
      let m = qr.rows;

      if (value.rows !== m) {
        throw new Error('Matrix row dimensions must agree');
      }

      if (!this.isFullRank()) {
        throw new Error('Matrix is rank deficient');
      }

      let count = value.columns;
      let X = value.clone();
      let n = qr.columns;
      let i, j, k, s;

      for (k = 0; k < n; k++) {
        for (j = 0; j < count; j++) {
          s = 0;

          for (i = k; i < m; i++) {
            s += qr.get(i, k) * X.get(i, j);
          }

          s = -s / qr.get(k, k);

          for (i = k; i < m; i++) {
            X.set(i, j, X.get(i, j) + s * qr.get(i, k));
          }
        }
      }

      for (k = n - 1; k >= 0; k--) {
        for (j = 0; j < count; j++) {
          X.set(k, j, X.get(k, j) / this.Rdiag[k]);
        }

        for (i = 0; i < k; i++) {
          for (j = 0; j < count; j++) {
            X.set(i, j, X.get(i, j) - X.get(k, j) * qr.get(i, k));
          }
        }
      }

      return X.subMatrix(0, n - 1, 0, count - 1);
    }

    isFullRank() {
      let columns = this.QR.columns;

      for (let i = 0; i < columns; i++) {
        if (this.Rdiag[i] === 0) {
          return false;
        }
      }

      return true;
    }

    get upperTriangularMatrix() {
      let qr = this.QR;
      let n = qr.columns;
      let X = new Matrix(n, n);
      let i, j;

      for (i = 0; i < n; i++) {
        for (j = 0; j < n; j++) {
          if (i < j) {
            X.set(i, j, qr.get(i, j));
          } else if (i === j) {
            X.set(i, j, this.Rdiag[i]);
          } else {
            X.set(i, j, 0);
          }
        }
      }

      return X;
    }

    get orthogonalMatrix() {
      let qr = this.QR;
      let rows = qr.rows;
      let columns = qr.columns;
      let X = new Matrix(rows, columns);
      let i, j, k, s;

      for (k = columns - 1; k >= 0; k--) {
        for (i = 0; i < rows; i++) {
          X.set(i, k, 0);
        }

        X.set(k, k, 1);

        for (j = k; j < columns; j++) {
          if (qr.get(k, k) !== 0) {
            s = 0;

            for (i = k; i < rows; i++) {
              s += qr.get(i, k) * X.get(i, j);
            }

            s = -s / qr.get(k, k);

            for (i = k; i < rows; i++) {
              X.set(i, j, X.get(i, j) + s * qr.get(i, k));
            }
          }
        }
      }

      return X;
    }

  }

  class SingularValueDecomposition {
    constructor(value, options = {}) {
      value = WrapperMatrix2D.checkMatrix(value);

      if (value.isEmpty()) {
        throw new Error('Matrix must be non-empty');
      }

      let m = value.rows;
      let n = value.columns;
      const {
        computeLeftSingularVectors = true,
        computeRightSingularVectors = true,
        autoTranspose = false
      } = options;
      let wantu = Boolean(computeLeftSingularVectors);
      let wantv = Boolean(computeRightSingularVectors);
      let swapped = false;
      let a;

      if (m < n) {
        if (!autoTranspose) {
          a = value.clone(); // eslint-disable-next-line no-console

          console.warn('Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose');
        } else {
          a = value.transpose();
          m = a.rows;
          n = a.columns;
          swapped = true;
          let aux = wantu;
          wantu = wantv;
          wantv = aux;
        }
      } else {
        a = value.clone();
      }

      let nu = Math.min(m, n);
      let ni = Math.min(m + 1, n);
      let s = new Float64Array(ni);
      let U = new Matrix(m, nu);
      let V = new Matrix(n, n);
      let e = new Float64Array(n);
      let work = new Float64Array(m);
      let si = new Float64Array(ni);

      for (let i = 0; i < ni; i++) si[i] = i;

      let nct = Math.min(m - 1, n);
      let nrt = Math.max(0, Math.min(n - 2, m));
      let mrc = Math.max(nct, nrt);

      for (let k = 0; k < mrc; k++) {
        if (k < nct) {
          s[k] = 0;

          for (let i = k; i < m; i++) {
            s[k] = hypotenuse(s[k], a.get(i, k));
          }

          if (s[k] !== 0) {
            if (a.get(k, k) < 0) {
              s[k] = -s[k];
            }

            for (let i = k; i < m; i++) {
              a.set(i, k, a.get(i, k) / s[k]);
            }

            a.set(k, k, a.get(k, k) + 1);
          }

          s[k] = -s[k];
        }

        for (let j = k + 1; j < n; j++) {
          if (k < nct && s[k] !== 0) {
            let t = 0;

            for (let i = k; i < m; i++) {
              t += a.get(i, k) * a.get(i, j);
            }

            t = -t / a.get(k, k);

            for (let i = k; i < m; i++) {
              a.set(i, j, a.get(i, j) + t * a.get(i, k));
            }
          }

          e[j] = a.get(k, j);
        }

        if (wantu && k < nct) {
          for (let i = k; i < m; i++) {
            U.set(i, k, a.get(i, k));
          }
        }

        if (k < nrt) {
          e[k] = 0;

          for (let i = k + 1; i < n; i++) {
            e[k] = hypotenuse(e[k], e[i]);
          }

          if (e[k] !== 0) {
            if (e[k + 1] < 0) {
              e[k] = 0 - e[k];
            }

            for (let i = k + 1; i < n; i++) {
              e[i] /= e[k];
            }

            e[k + 1] += 1;
          }

          e[k] = -e[k];

          if (k + 1 < m && e[k] !== 0) {
            for (let i = k + 1; i < m; i++) {
              work[i] = 0;
            }

            for (let i = k + 1; i < m; i++) {
              for (let j = k + 1; j < n; j++) {
                work[i] += e[j] * a.get(i, j);
              }
            }

            for (let j = k + 1; j < n; j++) {
              let t = -e[j] / e[k + 1];

              for (let i = k + 1; i < m; i++) {
                a.set(i, j, a.get(i, j) + t * work[i]);
              }
            }
          }

          if (wantv) {
            for (let i = k + 1; i < n; i++) {
              V.set(i, k, e[i]);
            }
          }
        }
      }

      let p = Math.min(n, m + 1);

      if (nct < n) {
        s[nct] = a.get(nct, nct);
      }

      if (m < p) {
        s[p - 1] = 0;
      }

      if (nrt + 1 < p) {
        e[nrt] = a.get(nrt, p - 1);
      }

      e[p - 1] = 0;

      if (wantu) {
        for (let j = nct; j < nu; j++) {
          for (let i = 0; i < m; i++) {
            U.set(i, j, 0);
          }

          U.set(j, j, 1);
        }

        for (let k = nct - 1; k >= 0; k--) {
          if (s[k] !== 0) {
            for (let j = k + 1; j < nu; j++) {
              let t = 0;

              for (let i = k; i < m; i++) {
                t += U.get(i, k) * U.get(i, j);
              }

              t = -t / U.get(k, k);

              for (let i = k; i < m; i++) {
                U.set(i, j, U.get(i, j) + t * U.get(i, k));
              }
            }

            for (let i = k; i < m; i++) {
              U.set(i, k, -U.get(i, k));
            }

            U.set(k, k, 1 + U.get(k, k));

            for (let i = 0; i < k - 1; i++) {
              U.set(i, k, 0);
            }
          } else {
            for (let i = 0; i < m; i++) {
              U.set(i, k, 0);
            }

            U.set(k, k, 1);
          }
        }
      }

      if (wantv) {
        for (let k = n - 1; k >= 0; k--) {
          if (k < nrt && e[k] !== 0) {
            for (let j = k + 1; j < n; j++) {
              let t = 0;

              for (let i = k + 1; i < n; i++) {
                t += V.get(i, k) * V.get(i, j);
              }

              t = -t / V.get(k + 1, k);

              for (let i = k + 1; i < n; i++) {
                V.set(i, j, V.get(i, j) + t * V.get(i, k));
              }
            }
          }

          for (let i = 0; i < n; i++) {
            V.set(i, k, 0);
          }

          V.set(k, k, 1);
        }
      }

      let pp = p - 1;
      let eps = Number.EPSILON;

      while (p > 0) {
        let k, kase;

        for (k = p - 2; k >= -1; k--) {
          if (k === -1) {
            break;
          }

          const alpha = Number.MIN_VALUE + eps * Math.abs(s[k] + Math.abs(s[k + 1]));

          if (Math.abs(e[k]) <= alpha || Number.isNaN(e[k])) {
            e[k] = 0;
            break;
          }
        }

        if (k === p - 2) {
          kase = 4;
        } else {
          let ks;

          for (ks = p - 1; ks >= k; ks--) {
            if (ks === k) {
              break;
            }

            let t = (ks !== p ? Math.abs(e[ks]) : 0) + (ks !== k + 1 ? Math.abs(e[ks - 1]) : 0);

            if (Math.abs(s[ks]) <= eps * t) {
              s[ks] = 0;
              break;
            }
          }

          if (ks === k) {
            kase = 3;
          } else if (ks === p - 1) {
            kase = 1;
          } else {
            kase = 2;
            k = ks;
          }
        }

        k++;

        switch (kase) {
          case 1:
            {
              let f = e[p - 2];
              e[p - 2] = 0;

              for (let j = p - 2; j >= k; j--) {
                let t = hypotenuse(s[j], f);
                let cs = s[j] / t;
                let sn = f / t;
                s[j] = t;

                if (j !== k) {
                  f = -sn * e[j - 1];
                  e[j - 1] = cs * e[j - 1];
                }

                if (wantv) {
                  for (let i = 0; i < n; i++) {
                    t = cs * V.get(i, j) + sn * V.get(i, p - 1);
                    V.set(i, p - 1, -sn * V.get(i, j) + cs * V.get(i, p - 1));
                    V.set(i, j, t);
                  }
                }
              }

              break;
            }

          case 2:
            {
              let f = e[k - 1];
              e[k - 1] = 0;

              for (let j = k; j < p; j++) {
                let t = hypotenuse(s[j], f);
                let cs = s[j] / t;
                let sn = f / t;
                s[j] = t;
                f = -sn * e[j];
                e[j] = cs * e[j];

                if (wantu) {
                  for (let i = 0; i < m; i++) {
                    t = cs * U.get(i, j) + sn * U.get(i, k - 1);
                    U.set(i, k - 1, -sn * U.get(i, j) + cs * U.get(i, k - 1));
                    U.set(i, j, t);
                  }
                }
              }

              break;
            }

          case 3:
            {
              const scale = Math.max(Math.abs(s[p - 1]), Math.abs(s[p - 2]), Math.abs(e[p - 2]), Math.abs(s[k]), Math.abs(e[k]));
              const sp = s[p - 1] / scale;
              const spm1 = s[p - 2] / scale;
              const epm1 = e[p - 2] / scale;
              const sk = s[k] / scale;
              const ek = e[k] / scale;
              const b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2;
              const c = sp * epm1 * (sp * epm1);
              let shift = 0;

              if (b !== 0 || c !== 0) {
                if (b < 0) {
                  shift = 0 - Math.sqrt(b * b + c);
                } else {
                  shift = Math.sqrt(b * b + c);
                }

                shift = c / (b + shift);
              }

              let f = (sk + sp) * (sk - sp) + shift;
              let g = sk * ek;

              for (let j = k; j < p - 1; j++) {
                let t = hypotenuse(f, g);
                if (t === 0) t = Number.MIN_VALUE;
                let cs = f / t;
                let sn = g / t;

                if (j !== k) {
                  e[j - 1] = t;
                }

                f = cs * s[j] + sn * e[j];
                e[j] = cs * e[j] - sn * s[j];
                g = sn * s[j + 1];
                s[j + 1] = cs * s[j + 1];

                if (wantv) {
                  for (let i = 0; i < n; i++) {
                    t = cs * V.get(i, j) + sn * V.get(i, j + 1);
                    V.set(i, j + 1, -sn * V.get(i, j) + cs * V.get(i, j + 1));
                    V.set(i, j, t);
                  }
                }

                t = hypotenuse(f, g);
                if (t === 0) t = Number.MIN_VALUE;
                cs = f / t;
                sn = g / t;
                s[j] = t;
                f = cs * e[j] + sn * s[j + 1];
                s[j + 1] = -sn * e[j] + cs * s[j + 1];
                g = sn * e[j + 1];
                e[j + 1] = cs * e[j + 1];

                if (wantu && j < m - 1) {
                  for (let i = 0; i < m; i++) {
                    t = cs * U.get(i, j) + sn * U.get(i, j + 1);
                    U.set(i, j + 1, -sn * U.get(i, j) + cs * U.get(i, j + 1));
                    U.set(i, j, t);
                  }
                }
              }

              e[p - 2] = f;
              break;
            }

          case 4:
            {
              if (s[k] <= 0) {
                s[k] = s[k] < 0 ? -s[k] : 0;

                if (wantv) {
                  for (let i = 0; i <= pp; i++) {
                    V.set(i, k, -V.get(i, k));
                  }
                }
              }

              while (k < pp) {
                if (s[k] >= s[k + 1]) {
                  break;
                }

                let t = s[k];
                s[k] = s[k + 1];
                s[k + 1] = t;

                if (wantv && k < n - 1) {
                  for (let i = 0; i < n; i++) {
                    t = V.get(i, k + 1);
                    V.set(i, k + 1, V.get(i, k));
                    V.set(i, k, t);
                  }
                }

                if (wantu && k < m - 1) {
                  for (let i = 0; i < m; i++) {
                    t = U.get(i, k + 1);
                    U.set(i, k + 1, U.get(i, k));
                    U.set(i, k, t);
                  }
                }

                k++;
              }
              p--;
              break;
            }
          // no default
        }
      }

      if (swapped) {
        let tmp = V;
        V = U;
        U = tmp;
      }

      this.m = m;
      this.n = n;
      this.s = s;
      this.U = U;
      this.V = V;
    }

    solve(value) {
      let Y = value;
      let e = this.threshold;
      let scols = this.s.length;
      let Ls = Matrix.zeros(scols, scols);

      for (let i = 0; i < scols; i++) {
        if (Math.abs(this.s[i]) <= e) {
          Ls.set(i, i, 0);
        } else {
          Ls.set(i, i, 1 / this.s[i]);
        }
      }

      let U = this.U;
      let V = this.rightSingularVectors;
      let VL = V.mmul(Ls);
      let vrows = V.rows;
      let urows = U.rows;
      let VLU = Matrix.zeros(vrows, urows);

      for (let i = 0; i < vrows; i++) {
        for (let j = 0; j < urows; j++) {
          let sum = 0;

          for (let k = 0; k < scols; k++) {
            sum += VL.get(i, k) * U.get(j, k);
          }

          VLU.set(i, j, sum);
        }
      }

      return VLU.mmul(Y);
    }

    solveForDiagonal(value) {
      return this.solve(Matrix.diag(value));
    }

    inverse() {
      let V = this.V;
      let e = this.threshold;
      let vrows = V.rows;
      let vcols = V.columns;
      let X = new Matrix(vrows, this.s.length);

      for (let i = 0; i < vrows; i++) {
        for (let j = 0; j < vcols; j++) {
          if (Math.abs(this.s[j]) > e) {
            X.set(i, j, V.get(i, j) / this.s[j]);
          }
        }
      }

      let U = this.U;
      let urows = U.rows;
      let ucols = U.columns;
      let Y = new Matrix(vrows, urows);

      for (let i = 0; i < vrows; i++) {
        for (let j = 0; j < urows; j++) {
          let sum = 0;

          for (let k = 0; k < ucols; k++) {
            sum += X.get(i, k) * U.get(j, k);
          }

          Y.set(i, j, sum);
        }
      }

      return Y;
    }

    get condition() {
      return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    get norm2() {
      return this.s[0];
    }

    get rank() {
      let tol = Math.max(this.m, this.n) * this.s[0] * Number.EPSILON;
      let r = 0;
      let s = this.s;

      for (let i = 0, ii = s.length; i < ii; i++) {
        if (s[i] > tol) {
          r++;
        }
      }

      return r;
    }

    get diagonal() {
      return Array.from(this.s);
    }

    get threshold() {
      return Number.EPSILON / 2 * Math.max(this.m, this.n) * this.s[0];
    }

    get leftSingularVectors() {
      return this.U;
    }

    get rightSingularVectors() {
      return this.V;
    }

    get diagonalMatrix() {
      return Matrix.diag(this.s);
    }

  }

  function inverse(matrix, useSVD = false) {
    matrix = WrapperMatrix2D.checkMatrix(matrix);

    if (useSVD) {
      return new SingularValueDecomposition(matrix).inverse();
    } else {
      return solve(matrix, Matrix.eye(matrix.rows));
    }
  }
  function solve(leftHandSide, rightHandSide, useSVD = false) {
    leftHandSide = WrapperMatrix2D.checkMatrix(leftHandSide);
    rightHandSide = WrapperMatrix2D.checkMatrix(rightHandSide);

    if (useSVD) {
      return new SingularValueDecomposition(leftHandSide).solve(rightHandSide);
    } else {
      return leftHandSide.isSquare() ? new LuDecomposition(leftHandSide).solve(rightHandSide) : new QrDecomposition(leftHandSide).solve(rightHandSide);
    }
  }

  class EigenvalueDecomposition {
    constructor(matrix, options = {}) {
      const {
        assumeSymmetric = false
      } = options;
      matrix = WrapperMatrix2D.checkMatrix(matrix);

      if (!matrix.isSquare()) {
        throw new Error('Matrix is not a square matrix');
      }

      if (matrix.isEmpty()) {
        throw new Error('Matrix must be non-empty');
      }

      let n = matrix.columns;
      let V = new Matrix(n, n);
      let d = new Float64Array(n);
      let e = new Float64Array(n);
      let value = matrix;
      let i, j;
      let isSymmetric = false;

      if (assumeSymmetric) {
        isSymmetric = true;
      } else {
        isSymmetric = matrix.isSymmetric();
      }

      if (isSymmetric) {
        for (i = 0; i < n; i++) {
          for (j = 0; j < n; j++) {
            V.set(i, j, value.get(i, j));
          }
        }

        tred2(n, e, d, V);
        tql2(n, e, d, V);
      } else {
        let H = new Matrix(n, n);
        let ort = new Float64Array(n);

        for (j = 0; j < n; j++) {
          for (i = 0; i < n; i++) {
            H.set(i, j, value.get(i, j));
          }
        }

        orthes(n, H, ort, V);
        hqr2(n, e, d, V, H);
      }

      this.n = n;
      this.e = e;
      this.d = d;
      this.V = V;
    }

    get realEigenvalues() {
      return Array.from(this.d);
    }

    get imaginaryEigenvalues() {
      return Array.from(this.e);
    }

    get eigenvectorMatrix() {
      return this.V;
    }

    get diagonalMatrix() {
      let n = this.n;
      let e = this.e;
      let d = this.d;
      let X = new Matrix(n, n);
      let i, j;

      for (i = 0; i < n; i++) {
        for (j = 0; j < n; j++) {
          X.set(i, j, 0);
        }

        X.set(i, i, d[i]);

        if (e[i] > 0) {
          X.set(i, i + 1, e[i]);
        } else if (e[i] < 0) {
          X.set(i, i - 1, e[i]);
        }
      }

      return X;
    }

  }

  function tred2(n, e, d, V) {
    let f, g, h, i, j, k, hh, scale;

    for (j = 0; j < n; j++) {
      d[j] = V.get(n - 1, j);
    }

    for (i = n - 1; i > 0; i--) {
      scale = 0;
      h = 0;

      for (k = 0; k < i; k++) {
        scale = scale + Math.abs(d[k]);
      }

      if (scale === 0) {
        e[i] = d[i - 1];

        for (j = 0; j < i; j++) {
          d[j] = V.get(i - 1, j);
          V.set(i, j, 0);
          V.set(j, i, 0);
        }
      } else {
        for (k = 0; k < i; k++) {
          d[k] /= scale;
          h += d[k] * d[k];
        }

        f = d[i - 1];
        g = Math.sqrt(h);

        if (f > 0) {
          g = -g;
        }

        e[i] = scale * g;
        h = h - f * g;
        d[i - 1] = f - g;

        for (j = 0; j < i; j++) {
          e[j] = 0;
        }

        for (j = 0; j < i; j++) {
          f = d[j];
          V.set(j, i, f);
          g = e[j] + V.get(j, j) * f;

          for (k = j + 1; k <= i - 1; k++) {
            g += V.get(k, j) * d[k];
            e[k] += V.get(k, j) * f;
          }

          e[j] = g;
        }

        f = 0;

        for (j = 0; j < i; j++) {
          e[j] /= h;
          f += e[j] * d[j];
        }

        hh = f / (h + h);

        for (j = 0; j < i; j++) {
          e[j] -= hh * d[j];
        }

        for (j = 0; j < i; j++) {
          f = d[j];
          g = e[j];

          for (k = j; k <= i - 1; k++) {
            V.set(k, j, V.get(k, j) - (f * e[k] + g * d[k]));
          }

          d[j] = V.get(i - 1, j);
          V.set(i, j, 0);
        }
      }

      d[i] = h;
    }

    for (i = 0; i < n - 1; i++) {
      V.set(n - 1, i, V.get(i, i));
      V.set(i, i, 1);
      h = d[i + 1];

      if (h !== 0) {
        for (k = 0; k <= i; k++) {
          d[k] = V.get(k, i + 1) / h;
        }

        for (j = 0; j <= i; j++) {
          g = 0;

          for (k = 0; k <= i; k++) {
            g += V.get(k, i + 1) * V.get(k, j);
          }

          for (k = 0; k <= i; k++) {
            V.set(k, j, V.get(k, j) - g * d[k]);
          }
        }
      }

      for (k = 0; k <= i; k++) {
        V.set(k, i + 1, 0);
      }
    }

    for (j = 0; j < n; j++) {
      d[j] = V.get(n - 1, j);
      V.set(n - 1, j, 0);
    }

    V.set(n - 1, n - 1, 1);
    e[0] = 0;
  }

  function tql2(n, e, d, V) {
    let g, h, i, j, k, l, m, p, r, dl1, c, c2, c3, el1, s, s2;

    for (i = 1; i < n; i++) {
      e[i - 1] = e[i];
    }

    e[n - 1] = 0;
    let f = 0;
    let tst1 = 0;
    let eps = Number.EPSILON;

    for (l = 0; l < n; l++) {
      tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
      m = l;

      while (m < n) {
        if (Math.abs(e[m]) <= eps * tst1) {
          break;
        }

        m++;
      }

      if (m > l) {

        do {
          g = d[l];
          p = (d[l + 1] - g) / (2 * e[l]);
          r = hypotenuse(p, 1);

          if (p < 0) {
            r = -r;
          }

          d[l] = e[l] / (p + r);
          d[l + 1] = e[l] * (p + r);
          dl1 = d[l + 1];
          h = g - d[l];

          for (i = l + 2; i < n; i++) {
            d[i] -= h;
          }

          f = f + h;
          p = d[m];
          c = 1;
          c2 = c;
          c3 = c;
          el1 = e[l + 1];
          s = 0;
          s2 = 0;

          for (i = m - 1; i >= l; i--) {
            c3 = c2;
            c2 = c;
            s2 = s;
            g = c * e[i];
            h = c * p;
            r = hypotenuse(p, e[i]);
            e[i + 1] = s * r;
            s = e[i] / r;
            c = p / r;
            p = c * d[i] - s * g;
            d[i + 1] = h + s * (c * g + s * d[i]);

            for (k = 0; k < n; k++) {
              h = V.get(k, i + 1);
              V.set(k, i + 1, s * V.get(k, i) + c * h);
              V.set(k, i, c * V.get(k, i) - s * h);
            }
          }

          p = -s * s2 * c3 * el1 * e[l] / dl1;
          e[l] = s * p;
          d[l] = c * p;
        } while (Math.abs(e[l]) > eps * tst1);
      }

      d[l] = d[l] + f;
      e[l] = 0;
    }

    for (i = 0; i < n - 1; i++) {
      k = i;
      p = d[i];

      for (j = i + 1; j < n; j++) {
        if (d[j] < p) {
          k = j;
          p = d[j];
        }
      }

      if (k !== i) {
        d[k] = d[i];
        d[i] = p;

        for (j = 0; j < n; j++) {
          p = V.get(j, i);
          V.set(j, i, V.get(j, k));
          V.set(j, k, p);
        }
      }
    }
  }

  function orthes(n, H, ort, V) {
    let low = 0;
    let high = n - 1;
    let f, g, h, i, j, m;
    let scale;

    for (m = low + 1; m <= high - 1; m++) {
      scale = 0;

      for (i = m; i <= high; i++) {
        scale = scale + Math.abs(H.get(i, m - 1));
      }

      if (scale !== 0) {
        h = 0;

        for (i = high; i >= m; i--) {
          ort[i] = H.get(i, m - 1) / scale;
          h += ort[i] * ort[i];
        }

        g = Math.sqrt(h);

        if (ort[m] > 0) {
          g = -g;
        }

        h = h - ort[m] * g;
        ort[m] = ort[m] - g;

        for (j = m; j < n; j++) {
          f = 0;

          for (i = high; i >= m; i--) {
            f += ort[i] * H.get(i, j);
          }

          f = f / h;

          for (i = m; i <= high; i++) {
            H.set(i, j, H.get(i, j) - f * ort[i]);
          }
        }

        for (i = 0; i <= high; i++) {
          f = 0;

          for (j = high; j >= m; j--) {
            f += ort[j] * H.get(i, j);
          }

          f = f / h;

          for (j = m; j <= high; j++) {
            H.set(i, j, H.get(i, j) - f * ort[j]);
          }
        }

        ort[m] = scale * ort[m];
        H.set(m, m - 1, scale * g);
      }
    }

    for (i = 0; i < n; i++) {
      for (j = 0; j < n; j++) {
        V.set(i, j, i === j ? 1 : 0);
      }
    }

    for (m = high - 1; m >= low + 1; m--) {
      if (H.get(m, m - 1) !== 0) {
        for (i = m + 1; i <= high; i++) {
          ort[i] = H.get(i, m - 1);
        }

        for (j = m; j <= high; j++) {
          g = 0;

          for (i = m; i <= high; i++) {
            g += ort[i] * V.get(i, j);
          }

          g = g / ort[m] / H.get(m, m - 1);

          for (i = m; i <= high; i++) {
            V.set(i, j, V.get(i, j) + g * ort[i]);
          }
        }
      }
    }
  }

  function hqr2(nn, e, d, V, H) {
    let n = nn - 1;
    let low = 0;
    let high = nn - 1;
    let eps = Number.EPSILON;
    let exshift = 0;
    let norm = 0;
    let p = 0;
    let q = 0;
    let r = 0;
    let s = 0;
    let z = 0;
    let iter = 0;
    let i, j, k, l, m, t, w, x, y;
    let ra, sa, vr, vi;
    let notlast, cdivres;

    for (i = 0; i < nn; i++) {
      if (i < low || i > high) {
        d[i] = H.get(i, i);
        e[i] = 0;
      }

      for (j = Math.max(i - 1, 0); j < nn; j++) {
        norm = norm + Math.abs(H.get(i, j));
      }
    }

    while (n >= low) {
      l = n;

      while (l > low) {
        s = Math.abs(H.get(l - 1, l - 1)) + Math.abs(H.get(l, l));

        if (s === 0) {
          s = norm;
        }

        if (Math.abs(H.get(l, l - 1)) < eps * s) {
          break;
        }

        l--;
      }

      if (l === n) {
        H.set(n, n, H.get(n, n) + exshift);
        d[n] = H.get(n, n);
        e[n] = 0;
        n--;
        iter = 0;
      } else if (l === n - 1) {
        w = H.get(n, n - 1) * H.get(n - 1, n);
        p = (H.get(n - 1, n - 1) - H.get(n, n)) / 2;
        q = p * p + w;
        z = Math.sqrt(Math.abs(q));
        H.set(n, n, H.get(n, n) + exshift);
        H.set(n - 1, n - 1, H.get(n - 1, n - 1) + exshift);
        x = H.get(n, n);

        if (q >= 0) {
          z = p >= 0 ? p + z : p - z;
          d[n - 1] = x + z;
          d[n] = d[n - 1];

          if (z !== 0) {
            d[n] = x - w / z;
          }

          e[n - 1] = 0;
          e[n] = 0;
          x = H.get(n, n - 1);
          s = Math.abs(x) + Math.abs(z);
          p = x / s;
          q = z / s;
          r = Math.sqrt(p * p + q * q);
          p = p / r;
          q = q / r;

          for (j = n - 1; j < nn; j++) {
            z = H.get(n - 1, j);
            H.set(n - 1, j, q * z + p * H.get(n, j));
            H.set(n, j, q * H.get(n, j) - p * z);
          }

          for (i = 0; i <= n; i++) {
            z = H.get(i, n - 1);
            H.set(i, n - 1, q * z + p * H.get(i, n));
            H.set(i, n, q * H.get(i, n) - p * z);
          }

          for (i = low; i <= high; i++) {
            z = V.get(i, n - 1);
            V.set(i, n - 1, q * z + p * V.get(i, n));
            V.set(i, n, q * V.get(i, n) - p * z);
          }
        } else {
          d[n - 1] = x + p;
          d[n] = x + p;
          e[n - 1] = z;
          e[n] = -z;
        }

        n = n - 2;
        iter = 0;
      } else {
        x = H.get(n, n);
        y = 0;
        w = 0;

        if (l < n) {
          y = H.get(n - 1, n - 1);
          w = H.get(n, n - 1) * H.get(n - 1, n);
        }

        if (iter === 10) {
          exshift += x;

          for (i = low; i <= n; i++) {
            H.set(i, i, H.get(i, i) - x);
          }

          s = Math.abs(H.get(n, n - 1)) + Math.abs(H.get(n - 1, n - 2));
          x = y = 0.75 * s;
          w = -0.4375 * s * s;
        }

        if (iter === 30) {
          s = (y - x) / 2;
          s = s * s + w;

          if (s > 0) {
            s = Math.sqrt(s);

            if (y < x) {
              s = -s;
            }

            s = x - w / ((y - x) / 2 + s);

            for (i = low; i <= n; i++) {
              H.set(i, i, H.get(i, i) - s);
            }

            exshift += s;
            x = y = w = 0.964;
          }
        }

        iter = iter + 1;
        m = n - 2;

        while (m >= l) {
          z = H.get(m, m);
          r = x - z;
          s = y - z;
          p = (r * s - w) / H.get(m + 1, m) + H.get(m, m + 1);
          q = H.get(m + 1, m + 1) - z - r - s;
          r = H.get(m + 2, m + 1);
          s = Math.abs(p) + Math.abs(q) + Math.abs(r);
          p = p / s;
          q = q / s;
          r = r / s;

          if (m === l) {
            break;
          }

          if (Math.abs(H.get(m, m - 1)) * (Math.abs(q) + Math.abs(r)) < eps * (Math.abs(p) * (Math.abs(H.get(m - 1, m - 1)) + Math.abs(z) + Math.abs(H.get(m + 1, m + 1))))) {
            break;
          }

          m--;
        }

        for (i = m + 2; i <= n; i++) {
          H.set(i, i - 2, 0);

          if (i > m + 2) {
            H.set(i, i - 3, 0);
          }
        }

        for (k = m; k <= n - 1; k++) {
          notlast = k !== n - 1;

          if (k !== m) {
            p = H.get(k, k - 1);
            q = H.get(k + 1, k - 1);
            r = notlast ? H.get(k + 2, k - 1) : 0;
            x = Math.abs(p) + Math.abs(q) + Math.abs(r);

            if (x !== 0) {
              p = p / x;
              q = q / x;
              r = r / x;
            }
          }

          if (x === 0) {
            break;
          }

          s = Math.sqrt(p * p + q * q + r * r);

          if (p < 0) {
            s = -s;
          }

          if (s !== 0) {
            if (k !== m) {
              H.set(k, k - 1, -s * x);
            } else if (l !== m) {
              H.set(k, k - 1, -H.get(k, k - 1));
            }

            p = p + s;
            x = p / s;
            y = q / s;
            z = r / s;
            q = q / p;
            r = r / p;

            for (j = k; j < nn; j++) {
              p = H.get(k, j) + q * H.get(k + 1, j);

              if (notlast) {
                p = p + r * H.get(k + 2, j);
                H.set(k + 2, j, H.get(k + 2, j) - p * z);
              }

              H.set(k, j, H.get(k, j) - p * x);
              H.set(k + 1, j, H.get(k + 1, j) - p * y);
            }

            for (i = 0; i <= Math.min(n, k + 3); i++) {
              p = x * H.get(i, k) + y * H.get(i, k + 1);

              if (notlast) {
                p = p + z * H.get(i, k + 2);
                H.set(i, k + 2, H.get(i, k + 2) - p * r);
              }

              H.set(i, k, H.get(i, k) - p);
              H.set(i, k + 1, H.get(i, k + 1) - p * q);
            }

            for (i = low; i <= high; i++) {
              p = x * V.get(i, k) + y * V.get(i, k + 1);

              if (notlast) {
                p = p + z * V.get(i, k + 2);
                V.set(i, k + 2, V.get(i, k + 2) - p * r);
              }

              V.set(i, k, V.get(i, k) - p);
              V.set(i, k + 1, V.get(i, k + 1) - p * q);
            }
          }
        }
      }
    }

    if (norm === 0) {
      return;
    }

    for (n = nn - 1; n >= 0; n--) {
      p = d[n];
      q = e[n];

      if (q === 0) {
        l = n;
        H.set(n, n, 1);

        for (i = n - 1; i >= 0; i--) {
          w = H.get(i, i) - p;
          r = 0;

          for (j = l; j <= n; j++) {
            r = r + H.get(i, j) * H.get(j, n);
          }

          if (e[i] < 0) {
            z = w;
            s = r;
          } else {
            l = i;

            if (e[i] === 0) {
              H.set(i, n, w !== 0 ? -r / w : -r / (eps * norm));
            } else {
              x = H.get(i, i + 1);
              y = H.get(i + 1, i);
              q = (d[i] - p) * (d[i] - p) + e[i] * e[i];
              t = (x * s - z * r) / q;
              H.set(i, n, t);
              H.set(i + 1, n, Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z);
            }

            t = Math.abs(H.get(i, n));

            if (eps * t * t > 1) {
              for (j = i; j <= n; j++) {
                H.set(j, n, H.get(j, n) / t);
              }
            }
          }
        }
      } else if (q < 0) {
        l = n - 1;

        if (Math.abs(H.get(n, n - 1)) > Math.abs(H.get(n - 1, n))) {
          H.set(n - 1, n - 1, q / H.get(n, n - 1));
          H.set(n - 1, n, -(H.get(n, n) - p) / H.get(n, n - 1));
        } else {
          cdivres = cdiv(0, -H.get(n - 1, n), H.get(n - 1, n - 1) - p, q);
          H.set(n - 1, n - 1, cdivres[0]);
          H.set(n - 1, n, cdivres[1]);
        }

        H.set(n, n - 1, 0);
        H.set(n, n, 1);

        for (i = n - 2; i >= 0; i--) {
          ra = 0;
          sa = 0;

          for (j = l; j <= n; j++) {
            ra = ra + H.get(i, j) * H.get(j, n - 1);
            sa = sa + H.get(i, j) * H.get(j, n);
          }

          w = H.get(i, i) - p;

          if (e[i] < 0) {
            z = w;
            r = ra;
            s = sa;
          } else {
            l = i;

            if (e[i] === 0) {
              cdivres = cdiv(-ra, -sa, w, q);
              H.set(i, n - 1, cdivres[0]);
              H.set(i, n, cdivres[1]);
            } else {
              x = H.get(i, i + 1);
              y = H.get(i + 1, i);
              vr = (d[i] - p) * (d[i] - p) + e[i] * e[i] - q * q;
              vi = (d[i] - p) * 2 * q;

              if (vr === 0 && vi === 0) {
                vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
              }

              cdivres = cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
              H.set(i, n - 1, cdivres[0]);
              H.set(i, n, cdivres[1]);

              if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                H.set(i + 1, n - 1, (-ra - w * H.get(i, n - 1) + q * H.get(i, n)) / x);
                H.set(i + 1, n, (-sa - w * H.get(i, n) - q * H.get(i, n - 1)) / x);
              } else {
                cdivres = cdiv(-r - y * H.get(i, n - 1), -s - y * H.get(i, n), z, q);
                H.set(i + 1, n - 1, cdivres[0]);
                H.set(i + 1, n, cdivres[1]);
              }
            }

            t = Math.max(Math.abs(H.get(i, n - 1)), Math.abs(H.get(i, n)));

            if (eps * t * t > 1) {
              for (j = i; j <= n; j++) {
                H.set(j, n - 1, H.get(j, n - 1) / t);
                H.set(j, n, H.get(j, n) / t);
              }
            }
          }
        }
      }
    }

    for (i = 0; i < nn; i++) {
      if (i < low || i > high) {
        for (j = i; j < nn; j++) {
          V.set(i, j, H.get(i, j));
        }
      }
    }

    for (j = nn - 1; j >= low; j--) {
      for (i = low; i <= high; i++) {
        z = 0;

        for (k = low; k <= Math.min(j, high); k++) {
          z = z + V.get(i, k) * H.get(k, j);
        }

        V.set(i, j, z);
      }
    }
  }

  function cdiv(xr, xi, yr, yi) {
    let r, d;

    if (Math.abs(yr) > Math.abs(yi)) {
      r = yi / yr;
      d = yr + r * yi;
      return [(xr + r * xi) / d, (xi - r * xr) / d];
    } else {
      r = yr / yi;
      d = yi + r * yr;
      return [(r * xr + xi) / d, (r * xi - xr) / d];
    }
  }

  /**
   * Difference of the matrix function over the parameters
   * @ignore
   * @param {{x:Array<number>, y:Array<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
   * @param {Array<number>} evaluatedData - Array of previous evaluated function values
   * @param {Array<number>} params - Array of previous parameter values
   * @param {number|array} gradientDifference - The step size to approximate the jacobian matrix
   * @param {boolean} centralDifference - If true the jacobian matrix is approximated by central differences otherwise by forward differences
   * @param {function} paramFunction - The parameters and returns a function with the independent variable as a parameter
   * @return {Matrix}
   */

  function gradientFunction(data, evaluatedData, params, gradientDifference, paramFunction, centralDifference) {
    const nbParams = params.length;
    const nbPoints = data.x.length;
    let ans = Matrix.zeros(nbParams, nbPoints);
    let rowIndex = 0;

    for (let param = 0; param < nbParams; param++) {
      if (gradientDifference[param] === 0) continue;
      let delta = gradientDifference[param];
      let auxParams = params.slice();
      auxParams[param] += delta;
      let funcParam = paramFunction(auxParams);

      if (!centralDifference) {
        for (let point = 0; point < nbPoints; point++) {
          ans.set(rowIndex, point, (evaluatedData[point] - funcParam(data.x[point])) / delta);
        }
      } else {
        auxParams = params.slice();
        auxParams[param] -= delta;
        delta *= 2;
        let funcParam2 = paramFunction(auxParams);

        for (let point = 0; point < nbPoints; point++) {
          ans.set(rowIndex, point, (funcParam2(data.x[point]) - funcParam(data.x[point])) / delta);
        }
      }

      rowIndex++;
    }

    return ans;
  }

  /**
   * Matrix function over the samples
   * @ignore
   * @param {{x:Array<number>, y:Array<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
   * @param {Array<number>} evaluatedData - Array of previous evaluated function values
   * @return {Matrix}
   */

  function matrixFunction(data, evaluatedData) {
    const m = data.x.length;
    let ans = new Matrix(m, 1);

    for (let point = 0; point < m; point++) {
      ans.set(point, 0, data.y[point] - evaluatedData[point]);
    }

    return ans;
  }
  /**
   * Iteration for Levenberg-Marquardt
   * @ignore
   * @param {{x:Array<number>, y:Array<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
   * @param {Array<number>} params - Array of previous parameter values
   * @param {number} damping - Levenberg-Marquardt parameter
   * @param {number|array} gradientDifference - The step size to approximate the jacobian matrix
   * @param {boolean} centralDifference - If true the jacobian matrix is approximated by central differences otherwise by forward differences
   * @param {function} parameterizedFunction - The parameters and returns a function with the independent variable as a parameter
   * @return {Array<number>}
   */


  function step(data, params, damping, gradientDifference, parameterizedFunction, centralDifference, weights) {
    let value = damping;
    let identity = Matrix.eye(params.length, params.length, value);
    const func = parameterizedFunction(params);
    let evaluatedData = new Float64Array(data.x.length);

    for (let i = 0; i < data.x.length; i++) {
      evaluatedData[i] = func(data.x[i]);
    }

    let gradientFunc = gradientFunction(data, evaluatedData, params, gradientDifference, parameterizedFunction, centralDifference);
    let residualError = matrixFunction(data, evaluatedData);
    let inverseMatrix = inverse(identity.add(gradientFunc.mmul(gradientFunc.transpose().scale('row', {
      scale: weights
    }))));
    let jacobianWeigthResidualError = gradientFunc.mmul(residualError.scale('row', {
      scale: weights
    }));
    let perturbations = inverseMatrix.mmul(jacobianWeigthResidualError);
    return {
      perturbations,
      jacobianWeigthResidualError
    };
  }

  /**
   * Curve fitting algorithm
   * @param {{x:Array<number>, y:Array<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
   * @param {function} parameterizedFunction - The parameters and returns a function with the independent variable as a parameter
   * @param {object} [options] - Options object
   * @param {number|array} [options.weights = 1] - weighting vector, if the length does not match with the number of data points, the vector is reconstructed with first value.
   * @param {number} [options.damping = 1e-2] - Levenberg-Marquardt parameter, small values of the damping parameter λ result in a Gauss-Newton update and large
  values of λ result in a gradient descent update
   * @param {number} [options.dampingStepDown = 9] - factor to reduce the damping (Levenberg-Marquardt parameter) when there is not an improvement when updating parameters.
   * @param {number} [options.dampingStepUp = 11] - factor to increase the damping (Levenberg-Marquardt parameter) when there is an improvement when updating parameters.
   * @param {number} [options.improvementThreshold = 1e-3] - the threshold to define an improvement through an update of parameters
   * @param {number|array} [options.gradientDifference = 10e-2] - The step size to approximate the jacobian matrix
   * @param {boolean} [options.centralDifference = false] - If true the jacobian matrix is approximated by central differences otherwise by forward differences
   * @param {Array<number>} [options.minValues] - Minimum allowed values for parameters
   * @param {Array<number>} [options.maxValues] - Maximum allowed values for parameters
   * @param {Array<number>} [options.initialValues] - Array of initial parameter values
   * @param {number} [options.maxIterations = 100] - Maximum of allowed iterations
   * @param {number} [options.errorTolerance = 10e-3] - Minimum uncertainty allowed for each point.
   * @param {number} [options.timeout] - maximum time running before throw in seconds.
   * @return {{parameterValues: Array<number>, parameterError: number, iterations: number}}
   */

  function levenbergMarquardt(data, parameterizedFunction, options = {}) {
    let {
      checkTimeout,
      minValues,
      maxValues,
      parameters,
      weightSquare,
      damping,
      dampingStepUp,
      dampingStepDown,
      maxIterations,
      errorTolerance,
      centralDifference,
      gradientDifference,
      improvementThreshold
    } = checkOptions$1(data, parameterizedFunction, options);
    let error = errorCalculation(data, parameters, parameterizedFunction, weightSquare);
    let converged = error <= errorTolerance;
    let iteration = 0;

    for (; iteration < maxIterations && !converged; iteration++) {
      let previousError = error;
      let {
        perturbations,
        jacobianWeigthResidualError
      } = step(data, parameters, damping, gradientDifference, parameterizedFunction, centralDifference, weightSquare);

      for (let k = 0; k < parameters.length; k++) {
        parameters[k] = Math.min(Math.max(minValues[k], parameters[k] - perturbations.get(k, 0)), maxValues[k]);
      }

      error = errorCalculation(data, parameters, parameterizedFunction, weightSquare);
      if (isNaN(error)) break;
      let improvementMetric = (previousError - error) / perturbations.transpose().mmul(perturbations.mulS(damping).add(jacobianWeigthResidualError)).get(0, 0);

      if (improvementMetric > improvementThreshold) {
        damping = Math.max(damping / dampingStepDown, 1e-7);
      } else {
        error = previousError;
        damping = Math.min(damping * dampingStepUp, 1e7);
      }

      if (checkTimeout()) {
        throw new Error(`The execution time is over to ${options.timeout} seconds`);
      }

      converged = error <= errorTolerance;
    }

    return {
      parameterValues: parameters,
      parameterError: error,
      iterations: iteration
    };
  }

  const LEVENBERG_MARQUARDT = 1;
  function selectMethod(optimizationOptions = {}) {
    let {
      kind,
      options
    } = optimizationOptions;
    kind = getKind(kind);

    switch (kind) {
      case LEVENBERG_MARQUARDT:
        return {
          algorithm: levenbergMarquardt,
          optimizationOptions: checkOptions(kind, options)
        };

      default:
        throw new Error(`Unknown kind algorithm`);
    }
  }

  function checkOptions(kind, options = {}) {
    // eslint-disable-next-line default-case
    switch (kind) {
      case LEVENBERG_MARQUARDT:
        return Object.assign({}, lmOptions, options);
    }
  }

  function getKind(kind) {
    if (typeof kind !== 'string') return kind;

    switch (kind.toLowerCase().replace(/[^a-z]/g, '')) {
      case 'lm':
      case 'levenbergmarquardt':
        return LEVENBERG_MARQUARDT;

      default:
        throw new Error(`Unknown kind algorithm`);
    }
  }

  const lmOptions = {
    damping: 1.5,
    maxIterations: 100,
    errorTolerance: 1e-8
  };

  // const STATE_MIN = 1;
  // const STATE_MAX = 2;
  // const STATE_GRADIENT_DIFFERENCE = 3;
  // const X = 0;
  // const Y = 1;
  // const WIDTH = 2;
  // const MU = 3;
  // const keys = ['x', 'y', 'width', 'mu'];

  /**
   * Fits a set of points to the sum of a set of bell functions.
   * @param {object} data - An object containing the x and y data to be fitted.
   * @param {array} peaks - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
   * @param {object} [options = {}]
   * @param {object} [options.shape={}] - it's specify the kind of shape used to fitting.
   * @param {string} [options.shape.kind = 'gaussian'] - kind of shape; lorentzian, gaussian and pseudovoigt are supported.
   * @param {object} [options.optimization = {}] - it's specify the kind and options of the algorithm use to optimize parameters.
   * @param {object} [options.optimization.kind = 'lm'] - kind of algorithm. By default it's levenberg-marquardt.
   * @param {object} [options.optimization.parameters] - options of each parameter to be optimized e.g. For a gaussian shape
   *  it could have x, y and with properties, each of which could contain init, min, max and gradientDifference, those options will define the guess,
   *  the min and max value of the parameter (search space) and the step size to approximate the jacobian matrix respectively. Those options could be a number,
   *  array of numbers, callback, or array of callbacks. Each kind of shape has default parameters so it could be undefined.
   * @param {object} [options.optimization.parameters.x] - options for x parameter.
   * @param {number|callback|array<number|callback>} [options.optimization.parameters.x.init] - definition of the starting point of the parameter (the guess),
   *  if it is a callback the method pass the peak as the unique input, if it is an array the first element define the guess of the first peak and so on.
   * @param {number|callback|array<number|callback>} [options.optimization.parameters.x.min] - definition of the lower limit of the parameter,
   *  if it is a callback the method pass the peak as the unique input, if it is an array the first element define the min of the first peak and so on.
   * @param {number|callback|array<number|callback>} [options.optimization.parameters.x.max] - definition of the upper limit of the parameter,
   *  if it is a callback the method pass the peak as the unique input, if it is an array the first element define the max of the first peak and so on.
   * @param {number|callback|array<number|callback>} [options.optimization.parameters.x.gradientDifference] - definition of  the step size to approximate the jacobian matrix of the parameter,
   *  if it is a callback the method pass the peak as the unique input, if it is an array the first element define the gradientDifference of the first peak and so on.
   * @param {object} [options.optimization.options = {}] - options for the specific kind of algorithm.
   * @param {number} [options.optimization.options.timeout] - maximum time running before break in seconds.
   * @param {number} [options.optimization.options.damping=1.5]
   * @param {number} [options.optimization.options.maxIterations=100]
   * @param {number} [options.optimization.options.errorTolerance=1e-8]
   * @returns {object} - A object with fitting error and the list of optimized parameters { parameters: [ {x, y, width} ], error } if the kind of shape is pseudoVoigt mu parameter is optimized.
   */

  function optimize(data, peakList, options = {}) {
    const {
      y,
      x,
      maxY,
      peaks,
      paramsFunc,
      optimization
    } = checkInput(data, peakList, options);
    let parameters = optimization.parameters;
    let nbShapes = peaks.length;
    let parameterKey = Object.keys(parameters);
    let nbParams = nbShapes * parameterKey.length;
    let pMin = new Float64Array(nbParams);
    let pMax = new Float64Array(nbParams);
    let pInit = new Float64Array(nbParams);
    let gradientDifference = new Float64Array(nbParams);

    for (let i = 0; i < nbShapes; i++) {
      let peak = peaks[i];

      for (let k = 0; k < parameterKey.length; k++) {
        let key = parameterKey[k];
        let init = parameters[key].init;
        let min = parameters[key].min;
        let max = parameters[key].max;
        let gradientDifferenceValue = parameters[key].gradientDifference;
        pInit[i + k * nbShapes] = init[i % init.length](peak);
        pMin[i + k * nbShapes] = min[i % min.length](peak);
        pMax[i + k * nbShapes] = max[i % max.length](peak);
        gradientDifference[i + k * nbShapes] = gradientDifferenceValue[i % gradientDifferenceValue.length](peak);
      }
    }

    let {
      algorithm,
      optimizationOptions
    } = selectMethod(optimization);
    optimizationOptions.minValues = pMin;
    optimizationOptions.maxValues = pMax;
    optimizationOptions.initialValues = pInit;
    optimizationOptions.gradientDifference = gradientDifference;
    let pFit = algorithm({
      x,
      y
    }, paramsFunc, optimizationOptions);
    let {
      parameterError: error,
      iterations
    } = pFit;
    let result = {
      error,
      iterations,
      peaks
    };

    for (let i = 0; i < nbShapes; i++) {
      pFit.parameterValues[i + nbShapes] *= maxY;

      for (let k = 0; k < parameterKey.length; k++) {
        // we modify the optimized parameters
        peaks[i][parameterKey[k]] = pFit.parameterValues[i + k * nbShapes];
      }
    }

    return result;
  }

  /**
   * This function returns an array with absolute values
   * @param {Array<Number>} array
   * @return {Number}
   */
  function xAbsolute(array) {
    let tmpArray = array.slice();

    for (let i = 0; i < tmpArray.length; i++) {
      if (tmpArray[i] < 0) tmpArray[i] *= -1;
    }

    return tmpArray;
  }

  var medianQuickselect_min = {exports: {}};

  (function (module) {
    (function () {
      function a(d) {
        for (var e = 0, f = d.length - 1, g = void 0, h = void 0, i = void 0, j = c(e, f); !0;) {
          if (f <= e) return d[j];
          if (f == e + 1) return d[e] > d[f] && b(d, e, f), d[j];

          for (g = c(e, f), d[g] > d[f] && b(d, g, f), d[e] > d[f] && b(d, e, f), d[g] > d[e] && b(d, g, e), b(d, g, e + 1), h = e + 1, i = f; !0;) {
            do h++; while (d[e] > d[h]);

            do i--; while (d[i] > d[e]);

            if (i < h) break;
            b(d, h, i);
          }

          b(d, e, i), i <= j && (e = h), i >= j && (f = i - 1);
        }
      }

      var b = function b(d, e, f) {
        var _ref;

        return _ref = [d[f], d[e]], d[e] = _ref[0], d[f] = _ref[1], _ref;
      },
          c = function c(d, e) {
        return ~~((d + e) / 2);
      };

      module.exports ? module.exports = a : window.median = a;
    })();
  })(medianQuickselect_min);

  var quickSelectMedian = medianQuickselect_min.exports;

  function median(input) {
    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    }

    if (input.length === 0) {
      throw new TypeError('input must not be empty');
    }

    return quickSelectMedian(input.slice());
  }

  /**
   * This function calculates the median after taking the reimAbsolute values of the points
   * @param {Array<Number>} array - the array that will be rotated
   * @return {Number}
   */

  function xAbsoluteMedian(array) {
    return median(xAbsolute(array));
  }

  /**
   * Returns the closest index of a `target` in an ordered array
   * @param {array<Number>} array
   * @param {number} target
   */
  function xFindClosestIndex(array, target) {
    let low = 0;
    let high = array.length - 1;
    let middle = 0;

    while (high - low > 1) {
      middle = low + (high - low >> 1);

      if (array[middle] < target) {
        low = middle;
      } else if (array[middle] > target) {
        high = middle;
      } else {
        return middle;
      }
    }

    if (low < array.length - 1) {
      if (Math.abs(target - array[low]) < Math.abs(array[low + 1] - target)) {
        return low;
      } else {
        return low + 1;
      }
    } else {
      return low;
    }
  }

  /**
   * Returns an object with {fromIndex, toIndex} for a specific from / to
   * @param {array} x
   * @param {object} [options={}]
   * @param {number} [options.from] - First value for xyIntegration in the X scale
   * @param {number} [options.fromIndex=0] - First point for xyIntegration
   * @param {number} [options.to] - Last value for xyIntegration in the X scale
   * @param {number} [options.toIndex=x.length-1] - Last point for xyIntegration
   */

  function xGetFromToIndex(x, options = {}) {
    let {
      fromIndex,
      toIndex,
      from,
      to
    } = options;

    if (fromIndex === undefined) {
      if (from !== undefined) {
        fromIndex = xFindClosestIndex(x, from);
      } else {
        fromIndex = 0;
      }
    }

    if (toIndex === undefined) {
      if (to !== undefined) {
        toIndex = xFindClosestIndex(x, to);
      } else {
        toIndex = x.length - 1;
      }
    }

    if (fromIndex > toIndex) [fromIndex, toIndex] = [toIndex, fromIndex];
    return {
      fromIndex,
      toIndex
    };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";

    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }
  /**
   * Fill an array with sequential numbers
   * @param {Array<number>} [input] - optional destination array (if not provided a new array will be created)
   * @param {object} [options={}]
   * @param {number} [options.from=0] - first value in the array
   * @param {number} [options.to=10] - last value in the array
   * @param {number} [options.size=input.length] - size of the array (if not provided calculated from step)
   * @param {number} [options.step] - if not provided calculated from size
   * @return {Array<number>}
   */


  function sequentialFill() {
    var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (_typeof(input) === 'object' && !isAnyArray(input)) {
      options = input;
      input = [];
    }

    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    }

    var _options = options,
        _options$from = _options.from,
        from = _options$from === void 0 ? 0 : _options$from,
        _options$to = _options.to,
        to = _options$to === void 0 ? 10 : _options$to,
        _options$size = _options.size,
        size = _options$size === void 0 ? input.length : _options$size,
        step = _options.step;

    if (size !== 0 && step) {
      throw new Error('step is defined by the array size');
    }

    if (!size) {
      if (step) {
        size = Math.floor((to - from) / step) + 1;
      } else {
        size = to - from + 1;
      }
    }

    if (!step && size) {
      step = (to - from) / (size - 1);
    }

    if (Array.isArray(input)) {
      // only works with normal array
      input.length = 0;

      for (var i = 0; i < size; i++) {
        input.push(from);
        from += step;
      }
    } else {
      if (input.length !== size) {
        throw new Error('sequentialFill typed array must have the correct length');
      }

      for (var _i = 0; _i < size; _i++) {
        input[_i] = from;
        from += step;
      }
    }

    return input;
  }

  var d3Array = {exports: {}};

  (function (module, exports) {
    (function (global, factory) {
      factory(exports) ;
    })(commonjsGlobal, function (exports) {

      function ascending(a, b) {
        return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
      }

      function bisector(compare) {
        if (compare.length === 1) compare = ascendingComparator(compare);
        return {
          left: function (a, x, lo, hi) {
            if (lo == null) lo = 0;
            if (hi == null) hi = a.length;

            while (lo < hi) {
              var mid = lo + hi >>> 1;
              if (compare(a[mid], x) < 0) lo = mid + 1;else hi = mid;
            }

            return lo;
          },
          right: function (a, x, lo, hi) {
            if (lo == null) lo = 0;
            if (hi == null) hi = a.length;

            while (lo < hi) {
              var mid = lo + hi >>> 1;
              if (compare(a[mid], x) > 0) hi = mid;else lo = mid + 1;
            }

            return lo;
          }
        };
      }

      function ascendingComparator(f) {
        return function (d, x) {
          return ascending(f(d), x);
        };
      }

      var ascendingBisect = bisector(ascending);
      var bisectRight = ascendingBisect.right;
      var bisectLeft = ascendingBisect.left;

      function descending(a, b) {
        return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
      }

      function number$1(x) {
        return x === null ? NaN : +x;
      }

      function variance(array, f) {
        var n = array.length,
            m = 0,
            a,
            d,
            s = 0,
            i = -1,
            j = 0;

        if (f == null) {
          while (++i < n) {
            if (!isNaN(a = number$1(array[i]))) {
              d = a - m;
              m += d / ++j;
              s += d * (a - m);
            }
          }
        } else {
          while (++i < n) {
            if (!isNaN(a = number$1(f(array[i], i, array)))) {
              d = a - m;
              m += d / ++j;
              s += d * (a - m);
            }
          }
        }

        if (j > 1) return s / (j - 1);
      }

      function deviation(array, f) {
        var v = variance(array, f);
        return v ? Math.sqrt(v) : v;
      }

      function extent(array, f) {
        var i = -1,
            n = array.length,
            a,
            b,
            c;

        if (f == null) {
          while (++i < n) if ((b = array[i]) != null && b >= b) {
            a = c = b;
            break;
          }

          while (++i < n) if ((b = array[i]) != null) {
            if (a > b) a = b;
            if (c < b) c = b;
          }
        } else {
          while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
            a = c = b;
            break;
          }

          while (++i < n) if ((b = f(array[i], i, array)) != null) {
            if (a > b) a = b;
            if (c < b) c = b;
          }
        }

        return [a, c];
      }

      function constant(x) {
        return function () {
          return x;
        };
      }

      function identity(x) {
        return x;
      }

      function range(start, stop, step) {
        start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;
        var i = -1,
            n = Math.max(0, Math.ceil((stop - start) / step)) | 0,
            range = new Array(n);

        while (++i < n) {
          range[i] = start + i * step;
        }

        return range;
      }

      var e10 = Math.sqrt(50);
      var e5 = Math.sqrt(10);
      var e2 = Math.sqrt(2);

      function ticks(start, stop, count) {
        var step = tickStep(start, stop, count);
        return range(Math.ceil(start / step) * step, Math.floor(stop / step) * step + step / 2, // inclusive
        step);
      }

      function tickStep(start, stop, count) {
        var step0 = Math.abs(stop - start) / Math.max(0, count),
            step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),
            error = step0 / step1;
        if (error >= e10) step1 *= 10;else if (error >= e5) step1 *= 5;else if (error >= e2) step1 *= 2;
        return stop < start ? -step1 : step1;
      }

      function sturges(values) {
        return Math.ceil(Math.log(values.length) / Math.LN2) + 1;
      }

      function number(x) {
        return +x;
      }

      function histogram() {
        var value = identity,
            domain = extent,
            threshold = sturges;

        function histogram(data) {
          var i,
              n = data.length,
              x,
              values = new Array(n); // Coerce values to numbers.

          for (i = 0; i < n; ++i) {
            values[i] = +value(data[i], i, data);
          }

          var xz = domain(values),
              x0 = +xz[0],
              x1 = +xz[1],
              tz = threshold(values, x0, x1); // Convert number of thresholds into uniform thresholds.

          if (!Array.isArray(tz)) tz = ticks(x0, x1, +tz); // Coerce thresholds to numbers, ignoring any outside the domain.

          var m = tz.length;

          for (i = 0; i < m; ++i) tz[i] = +tz[i];

          while (tz[0] <= x0) tz.shift(), --m;

          while (tz[m - 1] >= x1) tz.pop(), --m;

          var bins = new Array(m + 1),
              bin; // Initialize bins.

          for (i = 0; i <= m; ++i) {
            bin = bins[i] = [];
            bin.x0 = i > 0 ? tz[i - 1] : x0;
            bin.x1 = i < m ? tz[i] : x1;
          } // Assign data to bins by value, ignoring any outside the domain.


          for (i = 0; i < n; ++i) {
            x = values[i];

            if (x0 <= x && x <= x1) {
              bins[bisectRight(tz, x, 0, m)].push(data[i]);
            }
          }

          return bins;
        }

        histogram.value = function (_) {
          return arguments.length ? (value = typeof _ === "function" ? _ : constant(+_), histogram) : value;
        };

        histogram.domain = function (_) {
          return arguments.length ? (domain = typeof _ === "function" ? _ : constant([+_[0], +_[1]]), histogram) : domain;
        };

        histogram.thresholds = function (_) {
          if (!arguments.length) return threshold;
          threshold = typeof _ === "function" ? _ : Array.isArray(_) ? constant(Array.prototype.map.call(_, number)) : constant(+_);
          return histogram;
        };

        return histogram;
      }

      function quantile(array, p, f) {
        if (f == null) f = number$1;
        if (!(n = array.length)) return;
        if ((p = +p) <= 0 || n < 2) return +f(array[0], 0, array);
        if (p >= 1) return +f(array[n - 1], n - 1, array);
        var n,
            h = (n - 1) * p,
            i = Math.floor(h),
            a = +f(array[i], i, array),
            b = +f(array[i + 1], i + 1, array);
        return a + (b - a) * (h - i);
      }

      function freedmanDiaconis(values, min, max) {
        values.sort(ascending);
        return Math.ceil((max - min) / (2 * (quantile(values, 0.75) - quantile(values, 0.25)) * Math.pow(values.length, -1 / 3)));
      }

      function scott(values, min, max) {
        return Math.ceil((max - min) / (3.5 * deviation(values) * Math.pow(values.length, -1 / 3)));
      }

      function max(array, f) {
        var i = -1,
            n = array.length,
            a,
            b;

        if (f == null) {
          while (++i < n) if ((b = array[i]) != null && b >= b) {
            a = b;
            break;
          }

          while (++i < n) if ((b = array[i]) != null && b > a) a = b;
        } else {
          while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
            a = b;
            break;
          }

          while (++i < n) if ((b = f(array[i], i, array)) != null && b > a) a = b;
        }

        return a;
      }

      function mean(array, f) {
        var s = 0,
            n = array.length,
            a,
            i = -1,
            j = n;

        if (f == null) {
          while (++i < n) if (!isNaN(a = number$1(array[i]))) s += a;else --j;
        } else {
          while (++i < n) if (!isNaN(a = number$1(f(array[i], i, array)))) s += a;else --j;
        }

        if (j) return s / j;
      }

      function median(array, f) {
        var numbers = [],
            n = array.length,
            a,
            i = -1;

        if (f == null) {
          while (++i < n) if (!isNaN(a = number$1(array[i]))) numbers.push(a);
        } else {
          while (++i < n) if (!isNaN(a = number$1(f(array[i], i, array)))) numbers.push(a);
        }

        return quantile(numbers.sort(ascending), 0.5);
      }

      function merge(arrays) {
        var n = arrays.length,
            m,
            i = -1,
            j = 0,
            merged,
            array;

        while (++i < n) j += arrays[i].length;

        merged = new Array(j);

        while (--n >= 0) {
          array = arrays[n];
          m = array.length;

          while (--m >= 0) {
            merged[--j] = array[m];
          }
        }

        return merged;
      }

      function min(array, f) {
        var i = -1,
            n = array.length,
            a,
            b;

        if (f == null) {
          while (++i < n) if ((b = array[i]) != null && b >= b) {
            a = b;
            break;
          }

          while (++i < n) if ((b = array[i]) != null && a > b) a = b;
        } else {
          while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
            a = b;
            break;
          }

          while (++i < n) if ((b = f(array[i], i, array)) != null && a > b) a = b;
        }

        return a;
      }

      function pairs(array) {
        var i = 0,
            n = array.length - 1,
            p = array[0],
            pairs = new Array(n < 0 ? 0 : n);

        while (i < n) pairs[i] = [p, p = array[++i]];

        return pairs;
      }

      function permute(array, indexes) {
        var i = indexes.length,
            permutes = new Array(i);

        while (i--) permutes[i] = array[indexes[i]];

        return permutes;
      }

      function scan(array, compare) {
        if (!(n = array.length)) return;
        var i = 0,
            n,
            j = 0,
            xi,
            xj = array[j];
        if (!compare) compare = ascending;

        while (++i < n) if (compare(xi = array[i], xj) < 0 || compare(xj, xj) !== 0) xj = xi, j = i;

        if (compare(xj, xj) === 0) return j;
      }

      function shuffle(array, i0, i1) {
        var m = (i1 == null ? array.length : i1) - (i0 = i0 == null ? 0 : +i0),
            t,
            i;

        while (m) {
          i = Math.random() * m-- | 0;
          t = array[m + i0];
          array[m + i0] = array[i + i0];
          array[i + i0] = t;
        }

        return array;
      }

      function sum(array, f) {
        var s = 0,
            n = array.length,
            a,
            i = -1;

        if (f == null) {
          while (++i < n) if (a = +array[i]) s += a; // Note: zero and null are equivalent.

        } else {
          while (++i < n) if (a = +f(array[i], i, array)) s += a;
        }

        return s;
      }

      function transpose(matrix) {
        if (!(n = matrix.length)) return [];

        for (var i = -1, m = min(matrix, length), transpose = new Array(m); ++i < m;) {
          for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n;) {
            row[j] = matrix[j][i];
          }
        }

        return transpose;
      }

      function length(d) {
        return d.length;
      }

      function zip() {
        return transpose(arguments);
      }

      var version = "0.7.1";
      exports.version = version;
      exports.bisect = bisectRight;
      exports.bisectRight = bisectRight;
      exports.bisectLeft = bisectLeft;
      exports.ascending = ascending;
      exports.bisector = bisector;
      exports.descending = descending;
      exports.deviation = deviation;
      exports.extent = extent;
      exports.histogram = histogram;
      exports.thresholdFreedmanDiaconis = freedmanDiaconis;
      exports.thresholdScott = scott;
      exports.thresholdSturges = sturges;
      exports.max = max;
      exports.mean = mean;
      exports.median = median;
      exports.merge = merge;
      exports.min = min;
      exports.pairs = pairs;
      exports.permute = permute;
      exports.quantile = quantile;
      exports.range = range;
      exports.scan = scan;
      exports.shuffle = shuffle;
      exports.sum = sum;
      exports.ticks = ticks;
      exports.tickStep = tickStep;
      exports.transpose = transpose;
      exports.variance = variance;
      exports.zip = zip;
    });
  })(d3Array, d3Array.exports);

  const {
    bisectRight
  } = d3Array.exports;

  const quincunx = (u, v, w, q) => {
    const n = u.length - 1;
    u[0] = 0;
    v[0] = 0;
    w[0] = 0;
    v[1] = v[1] / u[1];
    w[1] = w[1] / u[1];

    for (let i = 2; i < n; ++i) {
      u[i] = u[i] - u[i - 2] * w[i - 2] * w[i - 2] - u[i - 1] * v[i - 1] * v[i - 1];
      v[i] = (v[i] - u[i - 1] * v[i - 1] * w[i - 1]) / u[i];
      w[i] = w[i] / u[i];
    }

    for (let i = 2; i < n; ++i) {
      q[i] = q[i] - v[i - 1] * q[i - 1] - w[i - 2] * q[i - 2];
    }

    for (let i = 1; i < n; ++i) {
      q[i] = q[i] / u[i];
    }

    q[n - 2] = q[n - 2] - v[n - 2] * q[n - 1];

    for (let i = n - 3; i > 0; --i) {
      q[i] = q[i] - v[i] * q[i + 1] - w[i] * q[i + 2];
    }
  };

  const smoothingSpline = (x, y, sigma, lambda) => {
    const n = x.length - 1;
    const h = new Array(n + 1);
    const r = new Array(n + 1);
    const f = new Array(n + 1);
    const p = new Array(n + 1);
    const q = new Array(n + 1);
    const u = new Array(n + 1);
    const v = new Array(n + 1);
    const w = new Array(n + 1);
    const params = x.map(() => [0, 0, 0, 0]);
    params.pop();
    const mu = 2 * (1 - lambda) / (3 * lambda);

    for (let i = 0; i < n; ++i) {
      h[i] = x[i + 1] - x[i];
      r[i] = 3 / h[i];
    }

    q[0] = 0;

    for (let i = 1; i < n; ++i) {
      f[i] = -(r[i - 1] + r[i]);
      p[i] = 2 * (x[i + 1] - x[i - 1]);
      q[i] = 3 * (y[i + 1] - y[i]) / h[i] - 3 * (y[i] - y[i - 1]) / h[i - 1];
    }

    q[n] = 0;

    for (let i = 1; i < n; ++i) {
      u[i] = r[i - 1] * r[i - 1] * sigma[i - 1] + f[i] * f[i] * sigma[i] + r[i] * r[i] * sigma[i + 1];
      u[i] = mu * u[i] + p[i];
    }

    for (let i = 1; i < n - 1; ++i) {
      v[i] = f[i] * r[i] * sigma[i] + r[i] * f[i + 1] * sigma[i + 1];
      v[i] = mu * v[i] + h[i];
    }

    for (let i = 1; i < n - 2; ++i) {
      w[i] = mu * r[i] * r[i + 1] * sigma[i + 1];
    }

    quincunx(u, v, w, q);
    params[0][3] = y[0] - mu * r[0] * q[1] * sigma[0];
    params[1][3] = y[1] - mu * (f[1] * q[1] + r[1] * q[2]) * sigma[0];
    params[0][0] = q[1] / (3 * h[0]);
    params[0][1] = 0;
    params[0][2] = (params[1][3] - params[0][3]) / h[0] - q[1] * h[0] / 3;
    r[0] = 0;

    for (let i = 1; i < n; ++i) {
      params[i][0] = (q[i + 1] - q[i]) / (3 * h[i]);
      params[i][1] = q[i];
      params[i][2] = (q[i] + q[i - 1]) * h[i - 1] + params[i - 1][2];
      params[i][3] = r[i - 1] * q[i - 1] + f[i] * q[i] + r[i] * q[i + 1];
      params[i][3] = y[i] - mu * params[i][3] * sigma[i];
    }

    return params;
  };

  class SplineInterpolator {
    constructor(xIn, yIn, lambda = 1) {
      const indices = xIn.map((_, i) => i);
      indices.sort((i, j) => xIn[i] - xIn[j]);
      const x = indices.map(i => xIn[i]);
      const y = indices.map(i => yIn[i]);
      const n = indices.length;
      const sigma = indices.map(() => 1);
      this.n = n;
      this.x = x;
      this.y = y;
      this.params = smoothingSpline(x, y, sigma, lambda);
    }

    interpolate(v) {
      if (v === this.x[this.n - 1]) {
        return this.y[this.n - 1];
      }

      const i = Math.min(Math.max(0, bisectRight(this.x, v) - 1), this.n - 2);
      const [a, b, c, d] = this.params[i];
      v = v - this.x[i];
      return a * v * v * v + b * v * v + c * v + d;
    }

    max(step = 100) {
      const xStart = this.x[0];
      const xStop = this.x[this.n - 1];
      const delta = (xStop - xStart) / step;
      let maxValue = -Infinity;

      for (let i = 0, x = xStart; i < step; ++i, x += delta) {
        const y = this.interpolate(x);

        if (y > maxValue) {
          maxValue = y;
        }
      }

      return maxValue;
    }

    min(step = 100) {
      const xStart = this.x[0];
      const xStop = this.x[this.n - 1];
      const delta = (xStop - xStart) / step;
      let minValue = Infinity;

      for (let i = 0, x = xStart; i < step; ++i, x += delta) {
        const y = this.interpolate(x);

        if (y < minValue) {
          minValue = y;
        }
      }

      return minValue;
    }

    domain() {
      return [this.x[0], this.x[this.x.length - 1]];
    }

    range() {
      return [this.min(), this.max()];
    }

    curve(nInterval, domain = null) {
      domain = domain || this.domain();
      const delta = (domain[1] - domain[0]) / (nInterval - 1);
      const vals = new Array(nInterval);

      for (let i = 0; i < nInterval; ++i) {
        const x = delta * i + domain[0];
        vals[i] = [x, this.interpolate(x)];
      }

      return vals;
    }

  }

  var splineInterpolator = SplineInterpolator;

  /* eslint-disable no-loss-of-precision */

  /*
  Adapted from: https://github.com/compute-io/erfcinv/blob/aa116e23883839359e310ad41a7c42f72815fc1e/lib/number.js

  The MIT License (MIT)

  Copyright (c) 2014-2015 The Compute.io Authors. All rights reserved.

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all
  copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.


  Boost Software License - Version 1.0 - August 17th, 2003

  Permission is hereby granted, free of charge, to any person or organization obtaining a copy of the software and accompanying documentation covered by this license (the "Software") to use, reproduce, display, distribute, execute, and transmit the Software, and to prepare derivative works of the Software, and to permit third-parties to whom the Software is furnished to do so, all subject to the following:

  The copyright notices in the Software and this entire statement, including the above license grant, this restriction and the following disclaimer, must be included in all copies of the Software, in whole or in part, and all derivative works of the Software, unless such copies or derivative works are solely in the form of machine-executable object code generated by a source language processor.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
  */
  // Coefficients for erfcinv on [0, 0.5]:
  const Y1 = 8.91314744949340820313e-2;
  const P1 = [-5.38772965071242932965e-3, 8.22687874676915743155e-3, 2.19878681111168899165e-2, -3.65637971411762664006e-2, -1.26926147662974029034e-2, 3.34806625409744615033e-2, -8.36874819741736770379e-3, -5.08781949658280665617e-4];
  const Q1 = [8.86216390456424707504e-4, -2.33393759374190016776e-3, 7.95283687341571680018e-2, -5.27396382340099713954e-2, -7.1228902341542847553e-1, 6.62328840472002992063e-1, 1.56221558398423026363, -1.56574558234175846809, -9.70005043303290640362e-1, 1]; // Coefficients for erfcinv for 0.5 > 1-x >= 0:

  const Y2 = 2.249481201171875;
  const P2 = [-3.67192254707729348546, 2.11294655448340526258e1, 1.7445385985570866523e1, -4.46382324441786960818e1, -1.88510648058714251895e1, 1.76447298408374015486e1, 8.37050328343119927838, 1.05264680699391713268e-1, -2.02433508355938759655e-1];
  const Q2 = [1.72114765761200282724, -2.26436933413139721736e1, 1.08268667355460159008e1, 4.85609213108739935468e1, -2.01432634680485188801e1, -2.86608180499800029974e1, 3.9713437953343869095, 6.24264124854247537712, 1]; // Coefficients for erfcinv for sqrt( -log(1-x)):

  const Y3 = 8.07220458984375e-1;
  const P3 = [-6.81149956853776992068e-10, 2.85225331782217055858e-8, -6.79465575181126350155e-7, 2.14558995388805277169e-3, 2.90157910005329060432e-2, 1.42869534408157156766e-1, 3.37785538912035898924e-1, 3.87079738972604337464e-1, 1.17030156341995252019e-1, -1.63794047193317060787e-1, -1.31102781679951906451e-1];
  const Q3 = [1.105924229346489121e-2, 1.52264338295331783612e-1, 8.48854343457902036425e-1, 2.59301921623620271374, 4.77846592945843778382, 5.38168345707006855425, 3.46625407242567245975, 1];
  const Y4 = 9.3995571136474609375e-1;
  const P4 = [2.66339227425782031962e-12, -2.30404776911882601748e-10, 4.60469890584317994083e-6, 1.57544617424960554631e-4, 1.87123492819559223345e-3, 9.50804701325919603619e-3, 1.85573306514231072324e-2, -2.22426529213447927281e-3, -3.50353787183177984712e-2];
  const Q4 = [7.64675292302794483503e-5, 2.63861676657015992959e-3, 3.41589143670947727934e-2, 2.20091105764131249824e-1, 7.62059164553623404043e-1, 1.3653349817554063097, 1];
  const Y5 = 9.8362827301025390625e-1;
  const P5 = [9.9055709973310326855e-17, -2.81128735628831791805e-14, 4.62596163522878599135e-9, 4.49696789927706453732e-7, 1.49624783758342370182e-5, 2.09386317487588078668e-4, 1.05628862152492910091e-3, -1.12951438745580278863e-3, -1.67431005076633737133e-2];
  const Q5 = [2.82243172016108031869e-7, 2.75335474764726041141e-5, 9.64011807005165528527e-4, 1.60746087093676504695e-2, 1.38151865749083321638e-1, 5.91429344886417493481e-1, 1];

  function polyval(c, x) {
    let p = 0;

    for (const coef of c) {
      p = p * x + coef;
    }

    return p;
  }
  /**
   * Calculates a rational approximation.
   *
   * @private
   * @param {Number} x
   * @param {Number} v
   * @param {Array} P - array of polynomial coefficients
   * @param {Array} Q - array of polynomial coefficients
   * @param {Number} Y
   * @returns {Number} rational approximation
   */


  function calc(x, v, P, Q, Y) {
    const s = x - v;
    const r = polyval(P, s) / polyval(Q, s);
    return Y * x + r * x;
  }
  /**
   * Evaluates the complementary inverse error function for an input value.
   *
   * @private
   * @param {Number} x - input value
   * @returns {Number} evaluated complementary inverse error function
   */


  function erfcinv(x) {
    let sign = false;
    let val;
    let q;
    let g;
    let r; // [1] Special cases...
    // NaN:

    if (Number.isNaN(x)) {
      return NaN;
    } // x not on the interval: [0,2]


    if (x < 0 || x > 2) {
      throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${x}\`.`);
    }

    if (x === 0) {
      return Number.POSITIVE_INFINITY;
    }

    if (x === 2) {
      return Number.NEGATIVE_INFINITY;
    }

    if (x === 1) {
      return 0;
    } // [2] Get the sign and make use of `erfc` reflection formula: `erfc(-z)=2 - erfc(z)`...


    if (x > 1) {
      q = 2 - x;
      x = 1 - q;
      sign = true;
    } else {
      q = x;
      x = 1 - x;
    } // [3] |x| <= 0.5


    if (x <= 0.5) {
      g = x * (x + 10);
      r = polyval(P1, x) / polyval(Q1, x);
      val = g * Y1 + g * r;
      return sign ? -val : val;
    } // [4] 1-|x| >= 0.25


    if (q >= 0.25) {
      g = Math.sqrt(-2 * Math.log(q));
      q = q - 0.25;
      r = polyval(P2, q) / polyval(Q2, q);
      val = g / (Y2 + r);
      return sign ? -val : val;
    }

    q = Math.sqrt(-Math.log(q)); // [5] q < 3

    if (q < 3) {
      return calc(q, 1.125, P3, Q3, Y3);
    } // [6] q < 6


    if (q < 6) {
      return calc(q, 3, P4, Q4, Y4);
    } // Note that the smallest number in JavaScript is 5e-324. Math.sqrt( -Math.log( 5e-324 ) ) ~27.2844


    return calc(q, 6, P5, Q5, Y5); // Note that in the boost library, they are able to go to much smaller values, as 128 bit long doubles support ~1e-5000; something which JavaScript does not natively support.
  }

  function rayleighCdf(x, sigma = 1) {
    if (x < 0) {
      return 0;
    }

    return -Math.expm1(-Math.pow(x, 2) / (2 * Math.pow(sigma, 2)));
  }

  /**
   * Determine noise level by san plot methodology (https://doi.org/10.1002/mrc.4882)
   * @param {Array} data - real or magnitude spectra data.
   * @param {object} [options = {}]
   * @param {array} [options.mask] - boolean array to filter data, if the i-th element is true then the i-th element of the distribution will be ignored.
   * @param {number} [options.scaleFactor=1] - factor to scale the data input[i]*=scaleFactor.
   * @param {number} [options.cutOff] - percent of positive signal distribution where the noise level will be determined, if it is not defined the program calculate it.
   * @param {number} [options.factorStd=5] - factor times std to determine what will be marked as signals.
   * @param {boolean} [options.refine=true] - if true the noise level will be recalculated get out the signals using factorStd.
   * @param {boolean} [options.fixOffset=true] - If the baseline is correct, the midpoint of distribution should be zero. if true, the distribution will be centered.
   * @param {number} [options.logBaseY=2] - log scale to apply in the intensity axis in order to avoid big numbers.
   */

  function xNoiseSanPlot(data, options = {}) {
    const {
      mask,
      cutOff,
      refine = true,
      magnitudeMode = false,
      scaleFactor = 1,
      factorStd = 5,
      fixOffset = true
    } = options;
    let input;

    if (Array.isArray(mask) && mask.length === data.length) {
      input = new Float64Array(data.filter((_e, i) => !mask[i]));
    } else {
      input = new Float64Array(data);
    }

    if (scaleFactor > 1) {
      for (let i = 0; i < input.length; i++) {
        input[i] *= scaleFactor;
      }
    }

    input = input.sort().reverse();

    if (fixOffset && !magnitudeMode) {
      let medianIndex = Math.floor(input.length / 2);
      let median = 0.5 * (input[medianIndex] + input[medianIndex + 1]);

      for (let i = 0; i < input.length; i++) {
        input[i] -= median;
      }
    }

    let firstNegativeValueIndex = input[input.length - 1] >= 0 ? input.length : input.findIndex(e => e < 0);
    let lastPositiveValueIndex = firstNegativeValueIndex - 1;

    for (let i = lastPositiveValueIndex; i >= 0; i--) {
      if (input[i] > 0) {
        lastPositiveValueIndex = i;
        break;
      }
    }

    let signPositive = input.slice(0, lastPositiveValueIndex + 1);
    let signNegative = input.slice(firstNegativeValueIndex);
    let cutOffDist = cutOff || determineCutOff(signPositive, {
      magnitudeMode
    });
    let pIndex = Math.floor(signPositive.length * cutOffDist);
    let initialNoiseLevelPositive = signPositive[pIndex];
    let skyPoint = signPositive[0];
    let initialNoiseLevelNegative;

    if (signNegative.length > 0) {
      let nIndex = Math.floor(signNegative.length * (1 - cutOffDist));
      initialNoiseLevelNegative = -1 * signNegative[nIndex];
    } else {
      initialNoiseLevelNegative = 0;
    }

    let noiseLevelPositive = initialNoiseLevelPositive;
    let noiseLevelNegative = initialNoiseLevelNegative;
    let cloneSignPositive = signPositive.slice();
    let cloneSignNegative = signNegative.slice();
    let cutOffSignalsIndexPlus = 0;
    let cutOffSignalsIndexNeg = 2;

    if (refine) {
      let cutOffSignals = noiseLevelPositive * factorStd;
      cutOffSignalsIndexPlus = signPositive.findIndex(e => e < cutOffSignals);

      if (cutOffSignalsIndexPlus > -1) {
        cloneSignPositive = signPositive.slice(cutOffSignalsIndexPlus);
        noiseLevelPositive = cloneSignPositive[Math.floor(cloneSignPositive.length * cutOffDist)];
      }

      cutOffSignals = noiseLevelNegative * factorStd;
      cutOffSignalsIndexNeg = signNegative.findIndex(e => e < cutOffSignals);

      if (cutOffSignalsIndexNeg > -1) {
        cloneSignNegative = signNegative.slice(cutOffSignalsIndexNeg);
        noiseLevelNegative = cloneSignPositive[Math.floor(cloneSignNegative.length * (1 - cutOffDist))];
      }
    }

    let correctionFactor = -simpleNormInv(cutOffDist / 2, {
      magnitudeMode
    });
    initialNoiseLevelPositive = initialNoiseLevelPositive / correctionFactor;
    initialNoiseLevelNegative = initialNoiseLevelNegative / correctionFactor;
    let effectiveCutOffDist, refinedCorrectionFactor;

    if (refine && cutOffSignalsIndexPlus > -1) {
      effectiveCutOffDist = (cutOffDist * cloneSignPositive.length + cutOffSignalsIndexPlus) / (cloneSignPositive.length + cutOffSignalsIndexPlus);
      refinedCorrectionFactor = -1 * simpleNormInv(effectiveCutOffDist / 2, {
        magnitudeMode
      });
      noiseLevelPositive /= refinedCorrectionFactor;

      if (cutOffSignalsIndexNeg > -1) {
        effectiveCutOffDist = (cutOffDist * cloneSignNegative.length + cutOffSignalsIndexNeg) / (cloneSignNegative.length + cutOffSignalsIndexNeg);
        refinedCorrectionFactor = -1 * simpleNormInv(effectiveCutOffDist / 2, {
          magnitudeMode
        });

        if (noiseLevelNegative !== 0) {
          noiseLevelNegative /= refinedCorrectionFactor;
        }
      }
    } else {
      noiseLevelPositive /= correctionFactor;
      noiseLevelNegative /= correctionFactor;
    }

    return {
      positive: noiseLevelPositive,
      negative: noiseLevelNegative,
      snr: skyPoint / noiseLevelPositive,
      sanplot: generateSanPlot(input, {
        fromTo: {
          positive: {
            from: 0,
            to: lastPositiveValueIndex
          },
          negative: {
            from: firstNegativeValueIndex,
            to: input.length
          }
        }
      })
    };
  }

  function determineCutOff(signPositive, options = {}) {
    let {
      magnitudeMode = false,
      considerList = {
        from: 0.5,
        step: 0.1,
        to: 0.9
      }
    } = options; //generate a list of values for

    let cutOff = [];
    let indexMax = signPositive.length - 1;

    for (let i = 0.01; i <= 0.99; i += 0.01) {
      let index = Math.round(indexMax * i);
      let value = -signPositive[index] / simpleNormInv([i / 2], {
        magnitudeMode
      });
      cutOff.push([i, value]);
    }

    let minKi = Number.MAX_SAFE_INTEGER;
    let {
      from,
      to,
      step
    } = considerList;
    let delta = step / 2;
    let whereToCutStat = 0.5;

    for (let i = from; i <= to; i += step) {
      let floor = i - delta;
      let top = i + delta;
      let elementsOfCutOff = cutOff.filter(e => e[0] < top && e[0] > floor);
      let averageValue = elementsOfCutOff.reduce((a, b) => a + Math.abs(b[1]), 0);
      let kiSqrt = 0;

      for (let j = 0; j < elementsOfCutOff.length; j++) {
        kiSqrt += Math.pow(elementsOfCutOff[j][1] - averageValue, 2);
      }

      if (kiSqrt < minKi) {
        minKi = kiSqrt;
        whereToCutStat = i;
      }
    }

    return whereToCutStat;
  }

  function simpleNormInv(data, options = {}) {
    const {
      magnitudeMode = false
    } = options;
    if (!Array.isArray(data)) data = [data];
    let from = 0;
    let to = 2;
    let step = 0.01;
    let xTraining = createArray(from, to, step);
    let result = new Float64Array(data.length);
    let yTraining = new Float64Array(xTraining.length);

    if (magnitudeMode) {
      let factor = 1;

      for (let i = 0; i < yTraining.length; i++) {
        let finalInput = xTraining[i] * factor;
        yTraining[i] = 1 - rayleighCdf(finalInput);
      }

      let interp = new splineInterpolator(xTraining, yTraining);

      for (let i = 0; i < result.length; i++) {
        let yValue = 2 * data[i];
        result[i] = -1 * interp.interpolate(yValue);
      }
    } else {
      for (let i = 0; i < result.length; i++) {
        result[i] = -1 * Math.SQRT2 * erfcinv(2 * data[i]);
      }
    }

    return result.length === 1 ? result[0] : result;
  }

  function createArray(from, to, step) {
    let result = new Array(Math.abs((from - to) / step + 1));

    for (let i = 0; i < result.length; i++) {
      result[i] = from + i * step;
    }

    return result;
  }

  function generateSanPlot(array, options = {}) {
    const {
      fromTo,
      logBaseY = 2
    } = options;
    let sanplot = {};

    for (let key in fromTo) {
      let {
        from,
        to
      } = fromTo[key];
      sanplot[key] = from !== to ? scale(array.slice(from, to), {
        logBaseY
      }) : {
        x: [],
        y: []
      };

      if (key === 'negative') {
        sanplot[key].y.reverse();
      }
    }

    return sanplot;
  }

  function scale(array, options = {}) {
    const {
      log10,
      abs
    } = Math;
    const {
      logBaseY
    } = options;

    if (logBaseY) {
      array = array.slice();
      const logOfBase = log10(logBaseY);

      for (let i = 0; i < array.length; i++) {
        array[i] = log10(abs(array[i])) / logOfBase;
      }
    }

    const xAxis = sequentialFill({
      from: 0,
      to: array.length - 1,
      size: array.length
    });
    return {
      x: xAxis,
      y: array
    };
  }

  function sum(input) {
    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    }

    if (input.length === 0) {
      throw new TypeError('input must not be empty');
    }

    var sumValue = 0;

    for (var i = 0; i < input.length; i++) {
      sumValue += input[i];
    }

    return sumValue;
  }

  function mean(input) {
    return sum(input) / input.length;
  }

  /**
   * Throw an error in no an object of x,y arrays
   * @param {DataXY} [data={}]
   */

  function xyCheck(data = {}) {
    if (!isAnyArray(data.x) || !isAnyArray(data.y)) {
      throw new Error('Data must be an object of x and y arrays');
    }

    if (data.x.length !== data.y.length) {
      throw new Error('The x and y arrays mush have the same length');
    }
  }

  /**
   * Normalize an array of zones:
   * - ensure than from < to
   * - merge overlapping zones
   * @param {Array<Zone>} [zones=[]]
   * @param {object} [options={}]
   * @param {number} [options.from=Number.MIN_VALUE]
   * @param {number} [options.to=Number.MAX_VALUE]
   */
  function zonesNormalize(zones = [], options = {}) {
    if (zones.length === 0) return [];
    zones = JSON.parse(JSON.stringify(zones)).map(zone => zone.from > zone.to ? {
      from: zone.to,
      to: zone.from
    } : zone);
    let {
      from = Number.NEGATIVE_INFINITY,
      to = Number.POSITIVE_INFINITY
    } = options;

    if (from > to) {
      [from, to] = [to, from];
    }

    zones = zones.sort((a, b) => {
      if (a.from !== b.from) return a.from - b.from;
      return a.to - b.to;
    });
    zones.forEach(zone => {
      if (from > zone.from) zone.from = from;
      if (to < zone.to) zone.to = to;
    });
    zones = zones.filter(zone => zone.from <= zone.to);
    if (zones.length === 0) return [];
    let currentZone = zones[0];
    let result = [currentZone];

    for (let zone of zones) {
      if (zone.from <= currentZone.to) {
        currentZone.to = zone.to;
      } else {
        currentZone = zone;
        result.push(currentZone);
      }
    }

    return result;
  }

  /**
   * xyExtract zones from a XY data
   * @param {DataXY} [data={}] - Object that contains property x (an ordered increasing array) and y (an array)
   * @param {object} [options={}]
   * @param {Array} [options.zones=[]]
   * @return {Array} Array of points
   */

  function xyExtract(data = {}, options = {}) {
    xyCheck(data);
    const {
      x,
      y
    } = data;
    let {
      zones
    } = options;
    zones = zonesNormalize(zones);
    if (!Array.isArray(zones) || zones.length === 0) return data;
    let newX = [];
    let newY = [];
    let currentZone = zones[0];
    let position = 0;

    loop: for (let i = 0; i < x.length; i++) {
      while (currentZone.to < x[i]) {
        position++;
        currentZone = zones[position];

        if (!currentZone) {
          i = x.length;
          break loop;
        }
      }

      if (x[i] >= currentZone.from) {
        newX.push(x[i]);
        newY.push(y[i]);
      }
    }

    return {
      x: newX,
      y: newY
    };
  }

  /**
   * Calculate integration
   * @param {DataXY} [data={}] - Object that contains property x (an ordered increasing array) and y (an array)
   * @param {object} [options={}]
   * @param {number} [options.from] - First value for xyIntegration in the X scale
   * @param {number} [options.fromIndex=0] - First point for xyIntegration
   * @param {number} [options.to] - Last value for xyIntegration in the X scale
   * @param {number} [options.toIndex=x.length-1] - Last point for xyIntegration
   * @return {number} xyIntegration value on the specified range
   */

  function xyIntegration(data = {}, options = {}) {
    xyCheck(data);
    const {
      x,
      y
    } = data;
    if (x.length < 2) return 0;
    const {
      fromIndex,
      toIndex
    } = xGetFromToIndex(x, options);
    let currentxyIntegration = 0;

    for (let i = fromIndex; i < toIndex; i++) {
      currentxyIntegration += (x[i + 1] - x[i]) * (y[i + 1] + y[i]) / 2;
    }

    return currentxyIntegration;
  }

  /**
   * Group peaks based on factor and add group property in peaks
   * @param {array} peakList
   * @param {number} factor
   */
  function groupPeaks(peakList, factor = 1) {
    if (peakList.length === 0) return [];
    let peaks = peakList.sort((a, b) => a.x - b.x);
    let previousPeak = {
      x: Number.NEGATIVE_INFINITY,
      width: 1
    };
    let currentGroup = [previousPeak];
    let groups = [];

    for (let peak of peaks) {
      if ((peak.x - previousPeak.x) / (peak.width + previousPeak.width) <= factor / 2) {
        currentGroup.push(peak);
      } else {
        currentGroup = [peak];
        groups.push(currentGroup);
      }

      peak.group = groups.length - 1;
      previousPeak = peak;
    }

    return groups;
  }

  /**
   * Optimize the position (x), max intensity (y), full width at half maximum (width)
   * and the ratio of gaussian contribution (mu) if it's required. It supports three kind of shapes: gaussian, lorentzian and pseudovoigt
   * @param {object} data - An object containing the x and y data to be fitted.
   * @param {Array} peakList - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
   * @param {object} [options = {}] -
   * @param {number} [options.factorWidth = 1] - times of width to group peaks.
   * @param {number} [options.factorLimits = 2] - times of width to use to optimize peaks
   * @param {object} [options.shape={}] - it's specify the kind of shape used to fitting.
   * @param {string} [options.shape.kind='gaussian'] - kind of shape; lorentzian, gaussian and pseudovoigt are supported.
   * @param {string} [options.shape.options={}] - options depending the kind of shape
   * @param {object} [options.optimization={}] - it's specify the kind and options of the algorithm use to optimize parameters.
   * @param {string} [options.optimization.kind='lm'] - kind of algorithm. By default it's levenberg-marquardt.
   * @param {object} [options.optimization.options={}] - options for the specific kind of algorithm.
   * @param {number} [options.optimization.options.timeout=10] - maximum time running before break in seconds.
   */

  function optimizePeaks(data, peakList, options = {}) {
    const {
      factorWidth = 1,
      factorLimits = 2,
      shape = {
        kind: 'gaussian'
      },
      optimization = {
        kind: 'lm',
        options: {
          timeout: 10
        }
      }
    } = options;

    if (data.x[0] > data.x[1]) {
      data.x.reverse();
      data.y.reverse();
    }

    let groups = groupPeaks(peakList, factorWidth);
    let results = [];

    for (const peaks of groups) {
      const firstPeak = peaks[0];
      const lastPeak = peaks[peaks.length - 1];
      const from = firstPeak.x - firstPeak.width * factorLimits;
      const to = lastPeak.x + lastPeak.width * factorLimits;
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(data.x, {
        from,
        to
      }); // Multiple peaks

      const currentRange = {
        x: data.x.slice(fromIndex, toIndex),
        y: data.y.slice(fromIndex, toIndex)
      };

      if (currentRange.x.length > 5) {
        let {
          peaks: optimizedPeaks
        } = optimize(currentRange, peaks, {
          shape,
          optimization
        });
        results = results.concat(optimizedPeaks);
      } else {
        results = results.concat(peaks);
      }
    }

    return results;
  }

  /**
   * This function try to join the peaks that seems to belong to a broad signal in a single broad peak.
   * @param {Array} peakList - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
   * @param {object} [options = {}] - options
   * @param {number} [options.width=0.25] - width limit to join peaks.
   * @param {object} [options.shape={}] - it's specify the kind of shape used to fitting.
   * @param {string} [options.shape.kind = 'gaussian'] - kind of shape; lorentzian, gaussian and pseudovoigt are supported.
   * @param {object} [options.optimization = {}] - it's specify the kind and options of the algorithm use to optimize parameters.
   * @param {string} [options.optimization.kind = 'lm'] - kind of algorithm. By default it's levenberg-marquardt.
   * @param {number} [options.optimization.options.timeout = 10] - maximum time running before break in seconds.
   * @param {object} [options.optimization.options = {}] - options for the specific kind of algorithm.
   */

  function joinBroadPeaks(peakList, options = {}) {
    let {
      width = 0.25,
      shape = {
        kind: 'gaussian'
      },
      optimization = {
        kind: 'lm',
        timeout: 10
      }
    } = options;
    let broadLines = []; // Optimize the possible broad lines

    let max = 0;
    let maxI = 0;
    let count = 1;

    for (let i = peakList.length - 1; i >= 0; i--) {
      if (peakList[i].soft) {
        broadLines.push(peakList.splice(i, 1)[0]);
      }
    } // Push a feke peak


    broadLines.push({
      x: Number.MAX_VALUE
    });
    let candidates = {
      x: [broadLines[0].x],
      y: [broadLines[0].y]
    };
    let indexes = [0];

    for (let i = 1; i < broadLines.length; i++) {
      if (Math.abs(broadLines[i - 1].x - broadLines[i].x) < width) {
        candidates.x.push(broadLines[i].x);
        candidates.y.push(broadLines[i].y);

        if (broadLines[i].y > max) {
          max = broadLines[i].y;
          maxI = i;
        }

        indexes.push(i);
        count++;
      } else {
        if (count > 2) {
          let fitted = optimize(candidates, [{
            x: broadLines[maxI].x,
            y: max,
            width: Math.abs(candidates.x[0] - candidates.x[candidates.x.length - 1])
          }], {
            shape,
            optimization
          });
          let {
            peaks: peak
          } = fitted;
          peak[0].index = Math.floor(indexes.reduce((a, b) => a + b, 0) / indexes.length);
          peak[0].soft = false;
          peakList.push(peak[0]);
        } else {
          // Put back the candidates to the signals list
          indexes.forEach(index => {
            peakList.push(broadLines[index]);
          });
        }

        candidates = {
          x: [broadLines[i].x],
          y: [broadLines[i].y]
        };
        indexes = [i];
        max = broadLines[i].y;
        maxI = i;
        count = 1;
      }
    }

    peakList.sort(function (a, b) {
      return a.x - b.x;
    });
    return peakList;
  }

  /**
   * Implementation of the peak picking method described by Cobas in:
   * A new approach to improving automated analysis of proton NMR spectra
   * through Global Spectral Deconvolution (GSD)
   * http://www.spectrosco-pyeurope.com/images/stories/ColumnPDFs/TD_23_1.pdf
   * @param {DataXY} data - Object of kind
   * @param {object} [options={}] - options object with some parameter for GSD.
   * @param {number} [options.minMaxRatio = 0.01] - Threshold to determine if a given peak should be considered as a noise, bases on its relative height compared to the highest peak.
   * @param {number} [options.broadRatio = 0.00025] - If broadRatio is higher than 0, then all the peaks which second derivative smaller than broadRatio * maxAbsSecondDerivative will be marked with the soft mask equal to true.
   * @param {number} [options.broadWidth = 0.25] - Threshold to determine if some peak is candidate to clustering into range.
   * @param {number} [options.thresholdFactor=3] - the factor that multiplies the noise level to set up a threshold to select peaks with respect to the intensity.
   * @param {number} [options.noiseLevel = median(data.y) * (options.thresholdFactor || 3)] - Noise threshold in spectrum y units. Default is three/thresholdFactor times the absolute median of data.y.
   * @param {number} [options.factorWidth = 4] - factor to determine the width at the moment to group the peaks in signals in 'GSD.optimizePeaks' function.
   * @param {object} [options.shape={}] - it's specify the kind of shape used to fitting.
   * @param {string} [options.shape.kind = 'gaussian'] - kind of shape; lorentzian, gaussian and pseudovoigt are supported.
   * @param {object} [options.optimization = {}] - it's specify the kind and options of the algorithm use to optimize parameters.
   * @param {string} [options.optimization.kind = 'lm'] - kind of algorithm. By default it's levenberg-marquardt.
   * @param {object} [options.optimization.options = {}] - options for the specific kind of algorithm.
   * @param {Boolean} [options.smoothY = true] - Select the peak intensities from a smoothed version of the independent variables?
   * @param {Boolean} [options.optimize = true] - if it's true adjust an train of gaussian or lorentzian shapes to spectrum.
   * @return {Array}
   */

  function xyAutoPeaksPicking(data, options = {}) {
    const {
      from,
      to,
      noiseLevel,
      thresholdFactor = 3,
      minMaxRatio = 0.05,
      broadRatio = 0.00025,
      useSanPlot = false,
      smoothY = true,
      optimize = false,
      factorWidth = 4,
      realTopDetection = true,
      shape = {
        kind: 'gaussian'
      },
      optimization = {
        kind: 'lm'
      },
      broadWidth = 0.25,
      lookNegative = false,
      sgOptions = {
        windowSize: 9,
        polynomial: 3
      }
    } = options;

    if (from !== undefined && to !== undefined) {
      data = xyExtract(data, [{
        from,
        to
      }]);
    }

    const cutOff = getCutOff(data.y, {
      noiseLevel,
      useSanPlot,
      thresholdFactor
    });
    let getPeakOptions = {
      shape,
      broadWidth,
      optimize,
      factorWidth,
      sgOptions,
      minMaxRatio,
      broadRatio,
      noiseLevel: cutOff.positive,
      smoothY,
      optimization,
      realTopDetection
    };
    let peaks = getPeakList(data, getPeakOptions);

    if (lookNegative) {
      getPeakOptions.noiseLevel = cutOff.negative;
      peaks.push(...getNegativePeaks(data, getPeakOptions));
    }

    return peaks;
  }

  function getPeakList(data, options) {
    const {
      shape,
      broadWidth,
      optimize,
      factorWidth,
      sgOptions,
      minMaxRatio,
      broadRatio,
      noiseLevel,
      smoothY,
      optimization,
      realTopDetection
    } = options;
    let peakList = gsd(data, {
      sgOptions,
      minMaxRatio,
      broadRatio,
      noiseLevel,
      smoothY,
      realTopDetection
    });

    if (broadWidth) {
      peakList = joinBroadPeaks(peakList, {
        width: broadWidth,
        shape,
        optimization
      });
    }

    if (optimize) {
      peakList = optimizePeaks(data, peakList, {
        shape,
        factorWidth,
        optimization
      });
    }

    return peakList;
  }

  function getNegativePeaks(data, options) {
    let {
      x,
      y
    } = data;
    let negativeDataY = new Float64Array(data.y.length);

    for (let i = 0; i < negativeDataY.length; i++) {
      negativeDataY[i] = -1 * y[i];
    }

    let peakList = getPeakList({
      x,
      y: negativeDataY
    }, options);

    for (let i = 0; i < peakList.length; i++) {
      peakList[i].y *= -1;
    }

    return peakList;
  }

  function getCutOff(data, options = {}) {
    const {
      noiseLevel,
      useSanPlot,
      thresholdFactor
    } = options;

    const formatResult = noiseLevel => typeof noiseLevel === 'number' ? {
      positive: noiseLevel,
      negative: -noiseLevel
    } : noiseLevel;

    if (noiseLevel) {
      return formatResult(noiseLevel);
    } else {
      return useSanPlot ? xNoiseSanPlot(data, {
        factorStd: thresholdFactor
      }) : formatResult(xAbsoluteMedian(data) * thresholdFactor);
    }
  }

  /*
   * This library implements the J analyser described by Cobas et al in the paper:
   * A two-stage approach to automatic determination of 1H NMR coupling constants
   */
  const patterns = ['s', 'd', 't', 'q', 'quint', 'h', 'sept', 'o', 'n'];
  let symRatio = 1.5;
  let maxErrorIter1 = 2.5; // Hz

  let maxErrorIter2 = 1; // Hz

  let jAxisKeys = {
    jAxis: 'x',
    intensity: 'intensity'
  };
  var jAnalyzer = {
    /**
     * The compilation process implements at the first stage a normalization procedure described by Golotvin et al.
     * embedding in peak-component-counting method described by Hoyes et al.
     * @param {object} signal
     * @private
     */
    compilePattern: function (signal, options = {}) {
      let {
        jAxisKey = jAxisKeys
      } = options;
      signal.multiplicity = 'm'; // 1.1 symmetrize
      // It will add a set of peaks(signal.peaksComp) to the signal that will be used during
      // the compilation process. The unit of those peaks will be in Hz

      signal.symRank = symmetrizeChoiseBest(signal, {
        maxError: maxErrorIter1,
        iteration: 1,
        jAxisKey
      });
      signal.asymmetric = true; // Is the signal symmetric?

      if (signal.symRank >= 0.95 && signal.peaksComp.length < 32) {
        signal.asymmetric = false;
        let P1, n2, maxFlagged;
        let k = 1;
        let Jc = []; // Loop over the possible number of coupling contributing to the multiplet

        for (let n = 0; n < 9; n++) {
          // 1.2 Normalize. It makes a deep copy of the peaks before to modify them.
          let peaks = normalize(signal, n); // signal.peaksCompX = peaks;

          let validPattern = false; // It will change to true, when we find the good patter
          // Lets check if the signal could be a singulet.

          if (peaks.length === 1 && n === 0) {
            validPattern = true;
          } else {
            if (peaks.length <= 1) {
              continue;
            }
          } // 1.3 Establish a range for the Heights Hi [peaks.intensity*0.85,peaks.intensity*1.15];


          let ranges = getRanges(peaks);
          n2 = Math.pow(2, n); // 1.4 Find a combination of integer heights Hi, one from each Si, that sums to 2^n.

          let heights = null;
          let counter = 1;

          while (!validPattern && (heights = getNextCombination(ranges, n2)) !== null && counter < 400) {
            // 2.1 Number the components of the multiplet consecutively from 1 to 2n,
            // starting at peak 1
            let numbering = new Array(heights.length);
            k = 1;

            for (let i = 0; i < heights.length; i++) {
              numbering[i] = new Array(heights[i]);

              for (let j = 0; j < heights[i]; j++) {
                numbering[i][j] = k++;
              }
            }

            Jc = []; // The array to store the detected j-coupling
            // 2.2 Set j = 1; J1 = P2 - P1. Flag components 1 and 2 as accounted for.

            let j = 1;
            Jc.push(peaks[1].x - peaks[0].x);
            P1 = peaks[0].x;
            numbering[0].splice(0, 1); // Flagged

            numbering[1].splice(0, 1); // Flagged

            k = 1;
            let nFlagged = 2;
            maxFlagged = Math.pow(2, n) - 1;

            while (Jc.length < n && nFlagged < maxFlagged && k < peaks.length) {
              counter += 1; // 4.1. Increment j. Set k to the number of the first unflagged component.

              j++;

              while (k < peaks.length && numbering[k].length === 0) {
                k++;
              }

              if (k < peaks.length) {
                // 4.2 Jj = Pk - P1.
                Jc.push(peaks[k].x - peaks[0].x); // Flag component k and, for each sum of the...

                numbering[k].splice(0, 1); // Flageed

                nFlagged++; // Flag the other components of the multiplet

                for (let u = 2; u <= j; u++) {
                  let jSum = 0;

                  for (let i = 0; i < u; i++) {
                    jSum += Jc[i];
                  }

                  for (let i = 1; i < numbering.length; i++) {
                    // Maybe 0.25 Hz is too much?
                    if (Math.abs(peaks[i].x - (P1 + jSum)) < 0.25) {
                      numbering[i].splice(0, 1); // Flageed

                      nFlagged++;
                      break;
                    }
                  }
                }
              }
            } // Calculate the ideal patter by using the extracted j-couplings


            let pattern = idealPattern(Jc); // Compare the ideal pattern with the proposed intensities.
            // All the intensities have to match to accept the multiplet

            validPattern = true;

            for (let i = 0; i < pattern.length; i++) {
              if (pattern[i].intensity !== heights[i]) {
                validPattern = false;
              }
            }
          } // If we found a valid pattern we should inform about the pattern.


          if (validPattern) {
            updateSignal(signal, Jc);
          }
        }
      } // Before to return, change the units of peaksComp from Hz to PPM again


      for (let i = 0; i < signal.peaksComp.length; i++) {
        signal.peaksComp[i].x /= signal.observe;
      }
    }
  };
  /**
   * @private
   * update the signal
   * @param {*} signal
   * @param {*} Jc
   */

  function updateSignal(signal, Jc) {
    // Update the limits of the signal
    let peaks = signal.peaksComp; // Always in Hz

    let nbPeaks = peaks.length;
    signal.startX = peaks[0].x / signal.observe - peaks[0].width;
    signal.stopX = peaks[nbPeaks - 1].x / signal.observe + peaks[nbPeaks - 1].width;
    signal.integralData.from = peaks[0].x / signal.observe - peaks[0].width * 3;
    signal.integralData.to = peaks[nbPeaks - 1].x / signal.observe + peaks[nbPeaks - 1].width * 3; // Compile the pattern and format the constant couplings

    signal.maskPattern = signal.mask2;
    signal.multiplicity = abstractPattern(signal, Jc);
    signal.pattern = signal.multiplicity; // Our library depends on this parameter, but it is old
  }
  /**
   * Returns the multiplet in the compact format
   * @param {object} signal
   * @param {object} Jc
   * @return {String}
   * @private
   */


  function abstractPattern(signal, Jc) {
    let tol = 0.05;
    let pattern = '';
    let cont = 1;
    let newNmrJs = [];

    if (Jc && Jc.length > 0) {
      Jc.sort(function (a, b) {
        return b - a;
      });

      for (let i = 0; i < Jc.length - 1; i++) {
        if (Math.abs(Jc[i] - Jc[i + 1]) < tol) {
          cont++;
        } else {
          newNmrJs.push({
            coupling: Math.abs(Jc[i]),
            multiplicity: patterns[cont]
          });
          pattern += patterns[cont];
          cont = 1;
        }
      }

      let index = Jc.length - 1;
      newNmrJs.push({
        coupling: Math.abs(Jc[index]),
        multiplicity: patterns[cont]
      });
      pattern += patterns[cont];
      signal.nmrJs = newNmrJs;
    } else {
      pattern = 's';

      if (Math.abs(signal.startX - signal.stopX) * signal.observe > 16) {
        pattern = 'br s';
      }
    }

    return pattern;
  }
  /**
   * This function creates an ideal pattern from the given J-couplings
   * @private
   * @param {Array} Jc
   * @return {*[]}
   * @private
   */


  function idealPattern(Jc) {
    let hsum = Math.pow(2, Jc.length);
    let pattern = [{
      x: 0,
      intensity: hsum
    }]; // To split the initial height

    for (let i = 0; i < Jc.length; i++) {
      for (let j = pattern.length - 1; j >= 0; j--) {
        pattern.push({
          x: pattern[j].x + Jc[i] / 2,
          intensity: pattern[j].intensity / 2
        });
        pattern[j].x = pattern[j].x - Jc[i] / 2;
        pattern[j].intensity = pattern[j].intensity / 2;
      }
    } // To sum the heights in the same positions


    pattern.sort(function compare(a, b) {
      return a.x - b.x;
    });

    for (let j = pattern.length - 2; j >= 0; j--) {
      if (Math.abs(pattern[j].x - pattern[j + 1].x) < 0.1) {
        pattern[j].intensity += pattern[j + 1].intensity;
        pattern.splice(j + 1, 1);
      }
    }

    return pattern;
  }
  /**
   * Find a combination of integer heights Hi, one from each Si, that sums to 2n.
   * @param {object} ranges
   * @param {Number} value
   * @return {*}
   * @private
   */


  function getNextCombination(ranges, value) {
    let half = Math.ceil(ranges.values.length * 0.5);
    let lng = ranges.values.length;
    let sum = 0;
    let ok;

    while (sum !== value) {
      // Update the indexes to point at the next possible combination
      ok = false;

      while (!ok) {
        ok = true;
        ranges.currentIndex[ranges.active]++;

        if (ranges.currentIndex[ranges.active] >= ranges.values[ranges.active].length) {
          // In this case, there is no more possible combinations
          if (ranges.active + 1 === half) {
            return null;
          } else {
            // If this happens we need to try the next active peak
            ranges.currentIndex[ranges.active] = 0;
            ok = false;
            ranges.active++;
          }
        } else {
          ranges.active = 0;
        }
      } // Sum the heights for this combination


      sum = 0;

      for (let i = 0; i < half; i++) {
        sum += ranges.values[i][ranges.currentIndex[i]] * 2;
      }

      if (ranges.values.length % 2 !== 0) {
        sum -= ranges.values[half - 1][ranges.currentIndex[half - 1]];
      }
    } // If the sum is equal to the expected value, fill the array to return


    if (sum === value) {
      let heights = new Array(lng);

      for (let i = 0; i < half; i++) {
        heights[i] = ranges.values[i][ranges.currentIndex[i]];
        heights[lng - i - 1] = ranges.values[i][ranges.currentIndex[i]];
      }

      return heights;
    }

    return null;
  }
  /**
   * This function generates the possible values that each peak can contribute
   * to the multiplet.
   * @param {Array} peaks Array of objects with peaks information {intensity}
   * @return {{values: Array, currentIndex: Array, active: number}}
   * @private
   */


  function getRanges(peaks) {
    let ranges = new Array(peaks.length);
    let currentIndex = new Array(peaks.length);
    let min, max;
    ranges[0] = [1];
    ranges[peaks.length - 1] = [1];
    currentIndex[0] = -1;
    currentIndex[peaks.length - 1] = 0;

    for (let i = 1; i < peaks.length - 1; i++) {
      min = Math.round(peaks[i].intensity * 0.85);
      max = Math.round(peaks[i].intensity * 1.15);
      ranges[i] = [];

      for (let j = min; j <= max; j++) {
        ranges[i].push(j);
      }

      currentIndex[i] = 0;
    }

    return {
      values: ranges,
      currentIndex: currentIndex,
      active: 0
    };
  }
  /**
   * Performs a symmetrization of the signal by using different aproximations to the center.
   * It will return the result of the symmetrization that removes less peaks from the signal
   * @param {object} signal
   * @param {Number} maxError
   * @param {Number} iteration
   * @return {*}
   * @private
   */


  function symmetrizeChoiseBest(signal, options = {}) {
    let {
      maxError,
      iteration,
      jAxisKey = jAxisKeys
    } = options;
    let symRank1 = symmetrize(signal, maxError, iteration, jAxisKey);
    let tmpPeaks = signal.peaksComp;
    let tmpMask = signal.mask;
    let cs = signal.delta1;
    signal.delta1 = (signal.peaks[0].x + signal.peaks[signal.peaks.length - 1].x) / 2;
    let symRank2 = symmetrize(signal, maxError, iteration, jAxisKey);

    if (signal.peaksComp.length > tmpPeaks.length) {
      return symRank2;
    } else {
      signal.delta1 = cs;
      signal.peaksComp = tmpPeaks;
      signal.mask = tmpMask;
      return symRank1;
    }
  }
  /**
   * This function will return a set of symmetric peaks that will
   * be the enter point for the patter compilation process.
   * @param {object} signal
   * @param {Number} maxError
   * @param {Number} iteration
   * @return {Number}
   * @private
   */


  function symmetrize(signal, maxError, iteration, key) {
    let {
      jAxis,
      intensity
    } = key; // Before to symmetrize we need to keep only the peaks that possibly conforms the multiplete

    let max, min, avg, ratio, avgWidth;
    let peaks = new Array(signal.peaks.length); // Make a deep copy of the peaks and convert PPM ot HZ

    for (let i = 0; i < peaks.length; i++) {
      peaks[i] = {
        x: signal.peaks[i][jAxis] * signal.observe,
        intensity: signal.peaks[i][intensity],
        width: signal.peaks[i].width
      };
    } // Join the peaks that are closer than 0.25 Hz


    for (let i = peaks.length - 2; i >= 0; i--) {
      if (Math.abs(peaks[i].x - peaks[i + 1].x) < 0.25) {
        peaks[i].x = peaks[i].x * peaks[i].intensity + peaks[i + 1].x * peaks[i + 1].intensity;
        peaks[i].intensity = peaks[i].intensity + peaks[i + 1].intensity;
        peaks[i].x /= peaks[i].intensity;
        peaks[i].intensity /= 2;
        peaks[i].width += peaks[i + 1].width;
        peaks.splice(i + 1, 1);
      }
    }

    signal.peaksComp = peaks;
    let nbPeaks = peaks.length;
    let mask = new Array(nbPeaks);
    signal.mask = mask;
    let left = 0;
    let right = peaks.length - 1;
    let cs = signal.delta1 * signal.observe;
    let middle = [(peaks[0].x + peaks[nbPeaks - 1].x) / 2, 1];
    maxError = error(Math.abs(cs - middle[0]));
    let heightSum = 0; // We try to symmetrize the extreme peaks. We consider as candidates for symmetricing those which have
    // ratio smaller than 3

    for (let i = 0; i < nbPeaks; i++) {
      mask[i] = true; // heightSum += signal.peaks[i].intensity;

      heightSum += peaks[i].intensity;
    }

    while (left <= right) {
      mask[left] = true;
      mask[right] = true;

      if (left === right) {
        if (nbPeaks > 2 && Math.abs(peaks[left].x - cs) > maxError) {
          mask[left] = false;
        }
      } else {
        max = Math.max(peaks[left].intensity, peaks[right].intensity);
        min = Math.min(peaks[left].intensity, peaks[right].intensity);
        ratio = max / min;

        if (ratio > symRatio) {
          if (peaks[left].intensity === min) {
            mask[left] = false;
            right++;
          } else {
            mask[right] = false;
            left--;
          }
        } else {
          let diffL = Math.abs(peaks[left].x - cs);
          let diffR = Math.abs(peaks[right].x - cs);

          if (Math.abs(diffL - diffR) < maxError) {
            avg = Math.min(peaks[left].intensity, peaks[right].intensity);
            avgWidth = Math.min(peaks[left].width, peaks[right].width);
            peaks[left].intensity = peaks[right].intensity = avg;
            peaks[left].width = peaks[right].width = avgWidth;
            middle = [middle[0] + (peaks[right].x + peaks[left].x) / 2, middle[1] + 1];
          } else {
            if (Math.max(diffL, diffR) === diffR) {
              mask[right] = false;
              left--;
            } else {
              mask[left] = false;
              right++;
            }
          }
        }
      }

      left++;
      right--; // Only alter cs if it is the first iteration of the sym process.

      if (iteration === 1) {
        cs = chemicalShift(peaks, mask); // There is not more available peaks

        if (isNaN(cs)) {
          return 0;
        }
      }

      maxError = error(Math.abs(cs - middle[0] / middle[1]));
    } // To remove the weak peaks and recalculate the cs


    for (let i = nbPeaks - 1; i >= 0; i--) {
      if (mask[i] === false) {
        peaks.splice(i, 1);
      }
    }

    cs = chemicalShift(peaks);

    if (isNaN(cs)) {
      return 0;
    }

    signal.delta1 = cs / signal.observe; // Now, the peak should be symmetric in heights, but we need to know if it is symmetric in x

    let symFactor = 0;
    let weight = 0;

    if (peaks.length > 1) {
      for (let i = Math.ceil(peaks.length / 2) - 1; i >= 0; i--) {
        symFactor += (3 + Math.min(Math.abs(peaks[i].x - cs), Math.abs(peaks[peaks.length - 1 - i].x - cs))) / (3 + Math.max(Math.abs(peaks[i].x - cs), Math.abs(peaks[peaks.length - 1 - i].x - cs))) * peaks[i].intensity;
        weight += peaks[i].intensity;
      }

      symFactor /= weight;
    } else {
      if (peaks.length === 1) {
        symFactor = 1;
      }
    }

    let newSumHeights = 0;

    for (let i = 0; i < peaks.length; i++) {
      newSumHeights += peaks[i].intensity;
    }

    symFactor -= (heightSum - newSumHeights) / heightSum * 0.12; // Removed peaks penalty
    // Sometimes we need a second opinion after the first symmetrization.

    if (symFactor > 0.8 && symFactor < 0.97 && iteration < 2) {
      return symmetrize(signal, maxErrorIter2, 2, key);
    } else {
      // Center the given pattern at cs and symmetrize x
      if (peaks.length > 1) {
        let dxi;

        for (let i = Math.ceil(peaks.length / 2) - 1; i >= 0; i--) {
          dxi = (peaks[i].x - peaks[peaks.length - 1 - i].x) / 2.0;
          peaks[i].x = cs + dxi;
          peaks[peaks.length - 1 - i].x = cs - dxi;
        }
      }
    }

    return symFactor;
  }
  /**
   * Error validator
   * @param {Number} value
   * @return {Number}
   * @private
   */


  function error(value) {
    let maxError = value * 2.5;

    if (maxError < 0.75) {
      maxError = 0.75;
    }

    if (maxError > 3) {
      maxError = 3;
    }

    return maxError;
  }
  /**
   * @private
   * 2 stages normalizarion of the peaks heights to Math.pow(2,n).
   * Creates a new mask with the peaks that could contribute to the multiplete
   * @param {object} signal
   * @param {Number} n
   * @return {*}
   */


  function normalize(signal, n) {
    // Perhaps this is slow
    let peaks = JSON.parse(JSON.stringify(signal.peaksComp));
    let norm = 0;
    let norm2 = 0;

    for (let i = 0; i < peaks.length; i++) {
      norm += peaks[i].intensity;
    }

    norm = Math.pow(2, n) / norm;
    signal.mask2 = JSON.parse(JSON.stringify(signal.mask));
    let index = signal.mask2.length - 1;

    for (let i = peaks.length - 1; i >= 0; i--) {
      peaks[i].intensity *= norm;

      while (index >= 0 && signal.mask2[index] === false) {
        index--;
      }

      if (peaks[i].intensity < 0.75) {
        peaks.splice(i, 1);
        signal.mask2[index] = false;
      } else {
        norm2 += peaks[i].intensity;
      }

      index--;
    }

    norm2 = Math.pow(2, n) / norm2;

    for (let i = peaks.length - 1; i >= 0; i--) {
      peaks[i].intensity *= norm2;
    }

    return peaks;
  }
  /**
   * @private
   * Calculates the chemical shift as the weighted sum of the peaks
   * @param {Array} peaks
   * @param {Array} mask
   * @return {Number}
   */


  function chemicalShift(peaks, mask) {
    let sum = 0;
    let cs = 0;
    let area;

    if (mask) {
      for (let i = 0; i < peaks.length; i++) {
        if (mask[i] === true) {
          area = getArea(peaks[i]);
          sum += area;
          cs += area * peaks[i].x;
        }
      }
    } else {
      for (let i = 0; i < peaks.length; i++) {
        area = getArea(peaks[i]);
        sum += area;
        cs += area * peaks[i].x;
      }
    }

    return cs / sum;
  }
  /**
   * Return the area of a Lorentzian function
   * @param {object} peak - object with peak information
   * @return {Number}
   * @private
   */


  function getArea(peak) {
    return Math.abs(peak.intensity * peak.width * 1.57); // 1.772453851);
  }

  function joinRanges(ranges) {
    ranges.sort((a, b) => a.from - b.from);

    for (let i = 0; i < ranges.length - 1; i++) {
      if (ranges[i].to > ranges[i + 1].from) {
        ranges[i].to = Math.max(ranges[i + 1].to, ranges[i].to);
        ranges[i].signal = ranges[i].signal.concat(ranges[i + 1].signal);
        ranges[i].integral += ranges[i + 1].integral;
        ranges.splice(i + 1, 1);
        i--;
      }
    }

    return ranges;
  }

  // import { Ranges } from 'spectra-data-ranges';
  /**
   * This function clustering peaks and calculate the integral value for each range from the peak list returned from extractPeaks function.
   * @param {Object} data - spectra data
   * @param {Array} peakList - nmr signals
   * @param {Object} [options={}] - options object with some parameter for GSD, detectSignal functions.
   * @param {Number} [options.integrationSum=100] - Number of hydrogens or some number to normalize the integral data. If it's zero return the absolute integral value
   * @param {String} [options.integralType='sum'] - option to chose between approx area with peaks or the sum of the points of given range ('sum', 'peaks')
   * @param {Number} [options.frequencyCluster=16] - distance limit to clustering peaks.
   * @param {Number} [options.clean=0.4] - If exits it remove all the signals with integration < clean value
   * @param {Boolean} [options.compile=true] - If true, the Janalyzer function is run over signals to compile the patterns.
   * @param {Boolean} [options.keepPeaks=false] - If true each signal will contain an array of peaks.
   * @param {String} [options.nucleus='1H'] - Nucleus
   * @param {String} [options.frequency=400] - Observed frequency
   * @returns {Array}
   */

  function peaksToRanges(data, peakList, options = {}) {
    let {
      integrationSum = 100,
      joinOverlapRanges = true,
      clean = 0.4,
      compile = true,
      integralType = 'sum',
      frequency = 400,
      frequencyCluster = 16,
      keepPeaks = false,
      nucleus = '1H'
    } = options;
    let signalOptions = {
      integrationSum,
      integralType,
      frequencyCluster,
      frequency,
      nucleus
    };

    if (data.x[0] > data.x[1]) {
      data.x = data.x.reverse();
      data.y = data.y.reverse();
    }

    let signals = detectSignals(data, peakList, signalOptions);

    if (clean) {
      for (let i = 0; i < signals.length; i++) {
        if (Math.abs(signals[i].integralData.value) < clean) {
          signals.splice(i, 1);
        }
      }
    }

    if (compile) {
      let nHi, sum;

      for (let i = 0; i < signals.length; i++) {
        jAnalyzer.compilePattern(signals[i]);

        if (signals[i].maskPattern && signals[i].multiplicity !== 'm' && signals[i].multiplicity !== '') {
          // Create a new signal with the removed peaks
          nHi = 0;
          sum = 0;
          let peaksO = [];

          for (let j = signals[i].maskPattern.length - 1; j >= 0; j--) {
            sum += computeArea(signals[i].peaks[j]);

            if (signals[i].maskPattern[j] === false) {
              let peakR = signals[i].peaks.splice(j, 1)[0];
              peaksO.push({
                x: peakR.x,
                y: peakR.intensity,
                width: peakR.width
              });
              signals[i].mask.splice(j, 1);
              signals[i].mask2.splice(j, 1);
              signals[i].maskPattern.splice(j, 1);
              signals[i].nbPeaks--;
              nHi += computeArea(peakR);
            }
          }

          if (peaksO.length > 0) {
            nHi = nHi * signals[i].integralData.value / sum;
            signals[i].integralData.value -= nHi;
            let peaks1 = [];

            for (let j = peaksO.length - 1; j >= 0; j--) {
              peaks1.push(peaksO[j]);
            }

            signalOptions.integrationSum = Math.abs(nHi);
            let ranges = detectSignals(data, peaks1, signalOptions);

            for (let j = 0; j < ranges.length; j++) {
              signals.push(ranges[j]);
            }
          }
        }
      } // it was a updateIntegrals function.


      let sumIntegral = 0;
      let sumObserved = 0;

      for (let i = 0; i < signals.length; i++) {
        sumObserved += Math.abs(Math.round(signals[i].integralData.value));
      }

      if (sumObserved !== integrationSum) {
        sumIntegral = integrationSum / sumObserved;

        for (let i = 0; i < signals.length; i++) {
          signals[i].integralData.value *= sumIntegral;
        }
      }
    }

    signals.sort((a, b) => {
      return b.delta1 - a.delta1;
    });

    if (clean) {
      for (let i = signals.length - 1; i >= 0; i--) {
        if (Math.abs(signals[i].integralData.value) < clean) {
          signals.splice(i, 1);
        }
      }
    }

    let ranges = []; //new Array(signals.length);

    for (let i = 0; i < signals.length; i++) {
      let signal = signals[i];
      ranges[i] = {
        from: signal.integralData.from,
        to: signal.integralData.to,
        integral: signal.integralData.value,
        signal: [{
          kind: signal.kind || 'signal',
          multiplicity: signal.multiplicity
        }]
      };

      if (keepPeaks) {
        ranges[i].signal[0].peak = signal.peaks;
      }

      if (signal.nmrJs) {
        ranges[i].signal[0].j = signal.nmrJs;
      }

      if (!signal.asymmetric || signal.multiplicity === 'm') {
        ranges[i].signal[0].delta = signal.delta1;
      }
    }

    if (joinOverlapRanges) ranges = joinRanges(ranges); // return new Ranges(ranges);

    return ranges;
  }
  /**
   * Extract the signals from the peakList and the given spectrum.
   * @param {object} data - spectra data
   * @param {array} peakList - nmr signals
   * @param {object} [options = {}]
   * @param {number} [options.integrationSum='100'] - Number of hydrogens or some number to normalize the integration data, If it's zero return the absolute integral value
   * @param {string} [options.integralType='sum'] - option to chose between approx area with peaks or the sum of the points of given range
   * @param {number} [options.frequencyCluster=16] - distance limit to clustering the peaks.
   * range = frequencyCluster / observeFrequency -> Peaks withing this range are considered to belongs to the same signal1D
   * @param {string} [options.nucleus='1H'] - - Nucleus
   * @param {String} [options.frequency = 400] - Observed frequency
   * @return {array} nmr signals
   * @private
   */

  function detectSignals(data, peakList, options = {}) {
    let {
      integrationSum = 100,
      integralType = 'sum',
      frequencyCluster = 16,
      frequency = 400,
      nucleus = '1H'
    } = options;
    let signal1D, peaks;
    let signals = [];
    let prevPeak = {
      x: 100000
    };
    let spectrumIntegral = 0;
    frequencyCluster /= frequency;

    for (let i = 0; i < peakList.length; i++) {
      if (Math.abs(peakList[i].x - prevPeak.x) > frequencyCluster) {
        signal1D = {
          nbPeaks: 1,
          units: 'PPM',
          startX: peakList[i].x - peakList[i].width,
          stopX: peakList[i].x + peakList[i].width,
          multiplicity: '',
          pattern: '',
          observe: frequency,
          nucleus,
          integralData: {
            from: peakList[i].x - peakList[i].width * 3,
            to: peakList[i].x + peakList[i].width * 3
          },
          peaks: [{
            x: peakList[i].x,
            intensity: peakList[i].y,
            width: peakList[i].width
          }]
        };
        if (peakList[i].kind) signal1D.kind = peakList[i].kind;
        signals.push(signal1D);
      } else {
        let tmp = peakList[i].x + peakList[i].width;
        signal1D.stopX = Math.max(signal1D.stopX, tmp);
        signal1D.startX = Math.min(signal1D.startX, tmp);
        signal1D.nbPeaks++;
        signal1D.peaks.push({
          x: peakList[i].x,
          intensity: peakList[i].y,
          width: peakList[i].width
        });
        signal1D.integralData.from = Math.min(signal1D.integralData.from, peakList[i].x - peakList[i].width * 3);
        signal1D.integralData.to = Math.max(signal1D.integralData.to, peakList[i].x + peakList[i].width * 3);
        if (peakList[i].kind) signal1D.kind = peakList[i].kind;
      }

      prevPeak = peakList[i];
    }

    for (let i = 0; i < signals.length; i++) {
      peaks = signals[i].peaks;
      let integral = signals[i].integralData;
      let chemicalShift = 0;
      let integralPeaks = 0;

      for (let j = 0; j < peaks.length; j++) {
        let area = computeArea(peaks[j]);
        chemicalShift += peaks[j].x * area;
        integralPeaks += area;
      }

      signals[i].delta1 = chemicalShift / integralPeaks;

      if (integralType === 'sum') {
        integral.value = xyIntegration(data, {
          from: integral.from,
          to: integral.to
        });
      } else {
        integral.value = integralPeaks;
      }

      spectrumIntegral += integral.value;
    }

    if (integrationSum > 0) {
      let integralFactor = integrationSum / spectrumIntegral;

      for (let i = 0; i < signals.length; i++) {
        let integral = signals[i].integralData;
        integral.value *= integralFactor;
      }
    }

    return signals;
  }
  /**
   * Return the area of a Lorentzian function
   * @param {object} peak - object with peak information
   * @return {Number}
   * @private
   */


  function computeArea(peak) {
    return Math.abs(peak.intensity * peak.width * 1.57); // todo add an option with this value: 1.772453851
  }

  /**
   * Detect peaks, optimize parameters and compile multiplicity if required.
   * @param {DataXY}  data - Object of kind
   * @param {object}  [options={}] - options object with some parameter for GSD.
   * @param {object}  [options.peakPicking={}] - options to peak detection and optimization.
   * @param {number}  [options.peakPicking.minMaxRatio=0.01] - Threshold to determine if a given peak should be considered as a noise, bases on its relative height compared to the highest peak.
   * @param {number}  [options.peakPicking.broadRatio=0.00025] - If broadRatio is higher than 0, then all the peaks which second derivative smaller than broadRatio * maxAbsSecondDerivative will be marked with the soft mask equal to true.
   * @param {number}  [options.peakPicking.broadWidth=0.25] - Threshold to determine if some peak is candidate to clustering into range.
   * @param {number}  [options.peakPicking.noiseLevel=median(data.y) * (options.thresholdFactor || 3)] - Noise threshold in spectrum y units. Default is three/thresholdFactor times the absolute median of data.y.
   * @param {number}  [options.peakPicking.factorWidth=4] - factor to determine the width at the moment to group the peaks in signals in 'GSD.optimizePeaks' function.
   * @param {object}  [options.peakPicking.shape={}] - it's specify the kind of shape used to fitting.
   * @param {string}  [options.peakPicking.shape.kind='gaussian'] - kind of shape; lorentzian, gaussian and pseudovoigt are supported.
   * @param {object}  [options.peakPicking.optimization={}] - it's specify the kind and options of the algorithm use to optimize parameters.
   * @param {string}  [options.peakPicking.optimization.kind='lm'] - kind of algorithm. By default it's levenberg-marquardt.
   * @param {object}  [options.peakPicking.optimization.options={}] - options for the specific kind of algorithm.
   * @param {Boolean} [options.peakPicking.compile=true] - If true, the Janalyzer function is run over signals to compile the patterns.
   * @param {Boolean} [options.peakPicking.smoothY=true] - Select the peak intensities from a smoothed version of the independent variables?
   * @param {Boolean} [options.peakPicking.optimize=true] - if it's true adjust an train of gaussian or lorentzian shapes to spectrum.
   * @param {Boolean} [options.peakPicking.optimize=true] - if it's true adjust an train of gaussian or lorentzian shapes to spectrum.
   * @param {Number}  [options.ranges.integrationSum=100] - Number of hydrogens or some number to normalize the integral data. If it's zero return the absolute integral value
   * @param {String}  [options.ranges.integralType='sum'] - option to chose between approx area with peaks or the sum of the points of given range ('sum', 'peaks')
   * @param {Number}  [options.ranges.frequencyCluster=16] - distance limit to clustering peaks.
   * @param {Number}  [options.ranges.clean=0.4] - If exits it remove all the signals with integration < clean value
   * @param {Boolean} [options.ranges.compile=true] - If true, the Janalyzer function is run over signals to compile the patterns.
   * @param {Boolean} [options.ranges.keepPeaks=false] - If true each signal will contain an array of peaks.
   * @param {String}  [options.ranges.nucleus='1H'] - Nucleus
   * @param {String}  [options.ranges.frequency=400] - Observed frequency
   * @param {object}  [options.impurities={}] - impurities options.
   * @param {string}  [options.impurities.solvent=''] - solvent name.
   * @param {string}  [options.impurities.error=0.025] - tolerance in ppm to assign a impurity.
   * @returns {array} - Array of ranges with {from, to, integral, signals: [{delta, j, multiplicity, peaks}]}
   */

  function xyAutoRangesPicking(data, options = {}) {
    let peaks = xyAutoPeaksPicking(data, options.peakPicking);
    peaks = peaksFilterImpurities(peaks, options.impurities);
    return peaksToRanges(data, peaks, options.ranges);
  }

  function signalsToRanges(signals, options = {}) {
    const {
      tolerance = 0.05,
      frequency = 400
    } = options;
    let wrapped = signals.map(signal => ({
      original: signal
    }));
    wrapped.forEach(signal => {
      let halfWidth = (signal.original.j || []).reduce((total, j) => total += j.coupling / frequency, 0) / 2 + tolerance;
      signal.from = signal.original.delta - halfWidth;
      signal.to = signal.original.delta + halfWidth;
    });
    wrapped = wrapped.sort((signal1, signal2) => signal1.from - signal2.from);
    let ranges = [];
    let range = {};

    for (let signal of wrapped) {
      if (range.from === undefined || signal.from > range.to) {
        range = {
          from: signal.from,
          to: signal.to,
          integral: signal.original.nbAtoms,
          signal: [signal.original]
        };
        ranges.push(range);
      } else {
        range.integral += signal.original.nbAtoms;
        if (signal.to > range.to) range.to = signal.to;
        range.signal.push(signal.original);
      }
    }

    return ranges;
  }

  /**
   * Created by acastillo on 8/8/16.
   */

  const defOptions = {
    threshold: 0,
    out: "assignment"
  }; //TODO Consider a matrix of distances too

  var src$1 = function fullClusterGenerator(conMat, opt) {
    const options = Object.assign({}, defOptions, opt);
    var clList, i, j, k;

    if (typeof conMat[0] === "number") {
      clList = fullClusterGeneratorVector(conMat);
    } else {
      if (typeof conMat[0] === "object") {
        var nRows = conMat.length;
        var conn = new Array(nRows * (nRows + 1) / 2);
        var index = 0;

        for (var i = 0; i < nRows; i++) {
          for (var j = i; j < nRows; j++) {
            if (conMat[i][j] > options.threshold) conn[index++] = 1;else conn[index++] = 0;
          }
        }

        clList = fullClusterGeneratorVector(conn);
      }
    }

    if (options.out === "indexes" || options.out === "values") {
      var result = new Array(clList.length);

      for (i = 0; i < clList.length; i++) {
        result[i] = [];

        for (j = 0; j < clList[i].length; j++) {
          if (clList[i][j] != 0) {
            result[i].push(j);
          }
        }
      }

      if (options.out === "values") {
        var resultAsMatrix = new Array(result.length);

        for (i = 0; i < result.length; i++) {
          resultAsMatrix[i] = new Array(result[i].length);

          for (j = 0; j < result[i].length; j++) {
            resultAsMatrix[i][j] = new Array(result[i].length);

            for (k = 0; k < result[i].length; k++) {
              resultAsMatrix[i][j][k] = conMat[result[i][j]][result[i][k]];
            }
          }
        }

        return resultAsMatrix;
      } else {
        return result;
      }
    }

    return clList;
  };

  function fullClusterGeneratorVector(conn) {
    var nRows = Math.sqrt(conn.length * 2 + 0.25) - 0.5;
    var clusterList = [];
    var available = new Array(nRows);
    var remaining = nRows,
        i = 0;
    var cluster = []; //Mark all the elements as available

    for (i = nRows - 1; i >= 0; i--) {
      available[i] = 1;
    }

    var nextAv = -1;
    var toInclude = [];

    while (remaining > 0) {
      if (toInclude.length === 0) {
        //If there is no more elements to include. Start a new cluster
        cluster = new Array(nRows);

        for (i = 0; i < nRows; i++) cluster[i] = 0;

        clusterList.push(cluster);

        for (nextAv = 0; available[nextAv] == 0; nextAv++) {}
      } else {
        nextAv = toInclude.splice(0, 1);
      }

      cluster[nextAv] = 1;
      available[nextAv] = 0;
      remaining--; //Copy the next available row

      var row = new Array(nRows);

      for (i = 0; i < nRows; i++) {
        var c = Math.max(nextAv, i);
        var r = Math.min(nextAv, i); //The element in the conn matrix
        //console.log("index: "+r*(2*nRows-r-1)/2+c)

        row[i] = conn[r * (2 * nRows - r - 1) / 2 + c]; //There is new elements to include in this row?
        //Then, include it to the current cluster

        if (row[i] == 1 && available[i] == 1 && cluster[i] == 0) {
          toInclude.push(i);
          cluster[i] = 1;
        }
      }
    }

    return clusterList;
  }

  function signalsToSpinSystem(signals) {
    const nSpins = signals.length;
    const chemicalShifts = new Array(nSpins);
    const multiplicity = new Array(nSpins);
    const couplingConstants = Matrix.zeros(nSpins, nSpins); //create a list of assignments

    const ids = {};

    for (let i = 0; i < nSpins; i++) {
      multiplicity[i] = 2;
      chemicalShifts[i] = signals[i].delta;
      ids[signals[i].assignment] = i;
    } //create the coupling matrix


    for (let i = 0; i < nSpins; i++) {
      let {
        assignment: signalAssignment,
        j: jCoupling
      } = signals[i];

      for (let k = 0; k < jCoupling.length; k++) {
        let {
          coupling,
          assignment
        } = jCoupling[k];
        couplingConstants.set(ids[signalAssignment], ids[assignment], coupling);
        couplingConstants.set(ids[assignment], ids[signalAssignment], coupling);
      }
    }

    const connectivity = Matrix.ones(couplingConstants.rows, couplingConstants.rows);

    for (let i = 0; i < couplingConstants.rows; i++) {
      for (let j = i; j < couplingConstants.columns; j++) {
        if (couplingConstants.get(i, j) === 0) {
          connectivity.set(i, j, 0);
          connectivity.set(j, i, 0);
        }
      }
    }

    let clusters = src$1(connectivity.to2DArray(), {
      out: 'indexes'
    });
    return {
      clusters,
      couplingConstants,
      chemicalShifts,
      multiplicity,
      connectivity
    };
  }

  var binarySearch = function (haystack, needle, comparator, low, high) {
    var mid, cmp;
    if (low === undefined) low = 0;else {
      low = low | 0;
      if (low < 0 || low >= haystack.length) throw new RangeError("invalid lower bound");
    }
    if (high === undefined) high = haystack.length - 1;else {
      high = high | 0;
      if (high < low || high >= haystack.length) throw new RangeError("invalid upper bound");
    }

    while (low <= high) {
      // The naive `low + high >>> 1` could fail for array lengths > 2**31
      // because `>>>` converts its operands to int32. `low + (high - low >>> 1)`
      // works for array lengths <= 2**32-1 which is also Javascript's max array
      // length.
      mid = low + (high - low >>> 1);
      cmp = +comparator(haystack[mid], needle, mid, haystack); // Too low.

      if (cmp < 0.0) low = mid + 1; // Too high.
      else if (cmp > 0.0) high = mid - 1; // Key found.
        else return mid;
    } // Key not found.


    return ~low;
  };

  var numSort = {};

  function assertNumber$1(number) {
    if (typeof number !== 'number') {
      throw new TypeError('Expected a number');
    }
  }

  var ascending = numSort.ascending = (left, right) => {
    assertNumber$1(left);
    assertNumber$1(right);

    if (Number.isNaN(left)) {
      return -1;
    }

    if (Number.isNaN(right)) {
      return 1;
    }

    return left - right;
  };

  numSort.descending = (left, right) => {
    assertNumber$1(left);
    assertNumber$1(right);

    if (Number.isNaN(left)) {
      return 1;
    }

    if (Number.isNaN(right)) {
      return -1;
    }

    return right - left;
  };

  const largestPrime = 0x7fffffff;
  const primeNumbers = [// chunk #0
  largestPrime, // 2^31-1
  // chunk #1
  5, 11, 23, 47, 97, 197, 397, 797, 1597, 3203, 6421, 12853, 25717, 51437, 102877, 205759, 411527, 823117, 1646237, 3292489, 6584983, 13169977, 26339969, 52679969, 105359939, 210719881, 421439783, 842879579, 1685759167, // chunk #2
  433, 877, 1759, 3527, 7057, 14143, 28289, 56591, 113189, 226379, 452759, 905551, 1811107, 3622219, 7244441, 14488931, 28977863, 57955739, 115911563, 231823147, 463646329, 927292699, 1854585413, // chunk #3
  953, 1907, 3821, 7643, 15287, 30577, 61169, 122347, 244703, 489407, 978821, 1957651, 3915341, 7830701, 15661423, 31322867, 62645741, 125291483, 250582987, 501165979, 1002331963, 2004663929, // chunk #4
  1039, 2081, 4177, 8363, 16729, 33461, 66923, 133853, 267713, 535481, 1070981, 2141977, 4283963, 8567929, 17135863, 34271747, 68543509, 137087021, 274174111, 548348231, 1096696463, // chunk #5
  31, 67, 137, 277, 557, 1117, 2237, 4481, 8963, 17929, 35863, 71741, 143483, 286973, 573953, 1147921, 2295859, 4591721, 9183457, 18366923, 36733847, 73467739, 146935499, 293871013, 587742049, 1175484103, // chunk #6
  599, 1201, 2411, 4831, 9677, 19373, 38747, 77509, 155027, 310081, 620171, 1240361, 2480729, 4961459, 9922933, 19845871, 39691759, 79383533, 158767069, 317534141, 635068283, 1270136683, // chunk #7
  311, 631, 1277, 2557, 5119, 10243, 20507, 41017, 82037, 164089, 328213, 656429, 1312867, 2625761, 5251529, 10503061, 21006137, 42012281, 84024581, 168049163, 336098327, 672196673, 1344393353, // chunk #8
  3, 7, 17, 37, 79, 163, 331, 673, 1361, 2729, 5471, 10949, 21911, 43853, 87719, 175447, 350899, 701819, 1403641, 2807303, 5614657, 11229331, 22458671, 44917381, 89834777, 179669557, 359339171, 718678369, 1437356741, // chunk #9
  43, 89, 179, 359, 719, 1439, 2879, 5779, 11579, 23159, 46327, 92657, 185323, 370661, 741337, 1482707, 2965421, 5930887, 11861791, 23723597, 47447201, 94894427, 189788857, 379577741, 759155483, 1518310967, // chunk #10
  379, 761, 1523, 3049, 6101, 12203, 24407, 48817, 97649, 195311, 390647, 781301, 1562611, 3125257, 6250537, 12501169, 25002389, 50004791, 100009607, 200019221, 400038451, 800076929, 1600153859, // chunk #11
  13, 29, 59, 127, 257, 521, 1049, 2099, 4201, 8419, 16843, 33703, 67409, 134837, 269683, 539389, 1078787, 2157587, 4315183, 8630387, 17260781, 34521589, 69043189, 138086407, 276172823, 552345671, 1104691373, // chunk #12
  19, 41, 83, 167, 337, 677, 1361, 2729, 5471, 10949, 21911, 43853, 87719, 175447, 350899, 701819, 1403641, 2807303, 5614657, 11229331, 22458671, 44917381, 89834777, 179669557, 359339171, 718678369, 1437356741, // chunk #13
  53, 107, 223, 449, 907, 1823, 3659, 7321, 14653, 29311, 58631, 117269, 234539, 469099, 938207, 1876417, 3752839, 7505681, 15011389, 30022781, 60045577, 120091177, 240182359, 480364727, 960729461, 1921458943];
  primeNumbers.sort(ascending);
  function nextPrime(value) {
    let index = binarySearch(primeNumbers, value, ascending);

    if (index < 0) {
      index = ~index;
    }

    return primeNumbers[index];
  }

  const FREE = 0;
  const FULL = 1;
  const REMOVED = 2;
  const defaultInitialCapacity = 150;
  const defaultMinLoadFactor = 1 / 6;
  const defaultMaxLoadFactor = 2 / 3;
  class HashTable {
    constructor(options = {}) {
      if (options instanceof HashTable) {
        this.table = options.table.slice();
        this.values = options.values.slice();
        this.state = options.state.slice();
        this.minLoadFactor = options.minLoadFactor;
        this.maxLoadFactor = options.maxLoadFactor;
        this.distinct = options.distinct;
        this.freeEntries = options.freeEntries;
        this.lowWaterMark = options.lowWaterMark;
        this.highWaterMark = options.maxLoadFactor;
        return;
      }

      const initialCapacity = options.initialCapacity === undefined ? defaultInitialCapacity : options.initialCapacity;

      if (initialCapacity < 0) {
        throw new RangeError(`initial capacity must not be less than zero: ${initialCapacity}`);
      }

      const minLoadFactor = options.minLoadFactor === undefined ? defaultMinLoadFactor : options.minLoadFactor;
      const maxLoadFactor = options.maxLoadFactor === undefined ? defaultMaxLoadFactor : options.maxLoadFactor;

      if (minLoadFactor < 0 || minLoadFactor >= 1) {
        throw new RangeError(`invalid minLoadFactor: ${minLoadFactor}`);
      }

      if (maxLoadFactor <= 0 || maxLoadFactor >= 1) {
        throw new RangeError(`invalid maxLoadFactor: ${maxLoadFactor}`);
      }

      if (minLoadFactor >= maxLoadFactor) {
        throw new RangeError(`minLoadFactor (${minLoadFactor}) must be smaller than maxLoadFactor (${maxLoadFactor})`);
      }

      let capacity = initialCapacity; // User wants to put at least capacity elements. We need to choose the size based on the maxLoadFactor to
      // avoid the need to rehash before this capacity is reached.
      // actualCapacity * maxLoadFactor >= capacity

      capacity = capacity / maxLoadFactor | 0;
      capacity = nextPrime(capacity);
      if (capacity === 0) capacity = 1;
      this.table = newArray(capacity);
      this.values = newArray(capacity);
      this.state = newArray(capacity);
      this.minLoadFactor = minLoadFactor;

      if (capacity === largestPrime) {
        this.maxLoadFactor = 1;
      } else {
        this.maxLoadFactor = maxLoadFactor;
      }

      this.distinct = 0;
      this.freeEntries = capacity;
      this.lowWaterMark = 0;
      this.highWaterMark = chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    clone() {
      return new HashTable(this);
    }

    get size() {
      return this.distinct;
    }

    get(key) {
      const i = this.indexOfKey(key);
      if (i < 0) return 0;
      return this.values[i];
    }

    set(key, value) {
      let i = this.indexOfInsertion(key);

      if (i < 0) {
        i = -i - 1;
        this.values[i] = value;
        return false;
      }

      if (this.distinct > this.highWaterMark) {
        const newCapacity = chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
        this.rehash(newCapacity);
        return this.set(key, value);
      }

      this.table[i] = key;
      this.values[i] = value;
      if (this.state[i] === FREE) this.freeEntries--;
      this.state[i] = FULL;
      this.distinct++;

      if (this.freeEntries < 1) {
        const newCapacity = chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
        this.rehash(newCapacity);
      }

      return true;
    }

    remove(key, noRehash) {
      const i = this.indexOfKey(key);
      if (i < 0) return false;
      this.state[i] = REMOVED;
      this.distinct--;
      if (!noRehash) this.maybeShrinkCapacity();
      return true;
    }

    delete(key, noRehash) {
      const i = this.indexOfKey(key);
      if (i < 0) return false;
      this.state[i] = FREE;
      this.distinct--;
      if (!noRehash) this.maybeShrinkCapacity();
      return true;
    }

    maybeShrinkCapacity() {
      if (this.distinct < this.lowWaterMark) {
        const newCapacity = chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
        this.rehash(newCapacity);
      }
    }

    containsKey(key) {
      return this.indexOfKey(key) >= 0;
    }

    indexOfKey(key) {
      const table = this.table;
      const state = this.state;
      const length = this.table.length;
      const hash = key & 0x7fffffff;
      let i = hash % length;
      let decrement = hash % (length - 2);
      if (decrement === 0) decrement = 1;

      while (state[i] !== FREE && (state[i] === REMOVED || table[i] !== key)) {
        i -= decrement;
        if (i < 0) i += length;
      }

      if (state[i] === FREE) return -1;
      return i;
    }

    containsValue(value) {
      return this.indexOfValue(value) >= 0;
    }

    indexOfValue(value) {
      const values = this.values;
      const state = this.state;

      for (var i = 0; i < state.length; i++) {
        if (state[i] === FULL && values[i] === value) {
          return i;
        }
      }

      return -1;
    }

    indexOfInsertion(key) {
      const table = this.table;
      const state = this.state;
      const length = table.length;
      const hash = key & 0x7fffffff;
      let i = hash % length;
      let decrement = hash % (length - 2);
      if (decrement === 0) decrement = 1;

      while (state[i] === FULL && table[i] !== key) {
        i -= decrement;
        if (i < 0) i += length;
      }

      if (state[i] === REMOVED) {
        const j = i;

        while (state[i] !== FREE && (state[i] === REMOVED || table[i] !== key)) {
          i -= decrement;
          if (i < 0) i += length;
        }

        if (state[i] === FREE) i = j;
      }

      if (state[i] === FULL) {
        return -i - 1;
      }

      return i;
    }

    ensureCapacity(minCapacity) {
      if (this.table.length < minCapacity) {
        const newCapacity = nextPrime(minCapacity);
        this.rehash(newCapacity);
      }
    }

    rehash(newCapacity) {
      const oldCapacity = this.table.length;
      if (newCapacity <= this.distinct) throw new Error('Unexpected');
      const oldTable = this.table;
      const oldValues = this.values;
      const oldState = this.state;
      const newTable = newArray(newCapacity);
      const newValues = newArray(newCapacity);
      const newState = newArray(newCapacity);
      this.lowWaterMark = chooseLowWaterMark(newCapacity, this.minLoadFactor);
      this.highWaterMark = chooseHighWaterMark(newCapacity, this.maxLoadFactor);
      this.table = newTable;
      this.values = newValues;
      this.state = newState;
      this.freeEntries = newCapacity - this.distinct;

      for (var i = 0; i < oldCapacity; i++) {
        if (oldState[i] === FULL) {
          var element = oldTable[i];
          var index = this.indexOfInsertion(element);
          newTable[index] = element;
          newValues[index] = oldValues[i];
          newState[index] = FULL;
        }
      }
    }

    forEachKey(callback) {
      for (var i = 0; i < this.state.length; i++) {
        if (this.state[i] === FULL) {
          if (!callback(this.table[i])) return false;
        }
      }

      return true;
    }

    forEachValue(callback) {
      for (var i = 0; i < this.state.length; i++) {
        if (this.state[i] === FULL) {
          if (!callback(this.values[i])) return false;
        }
      }

      return true;
    }

    forEachPair(callback) {
      for (var i = 0; i < this.state.length; i++) {
        if (this.state[i] === FULL) {
          if (!callback(this.table[i], this.values[i])) return false;
        }
      }

      return true;
    }

  }

  function chooseLowWaterMark(capacity, minLoad) {
    return capacity * minLoad | 0;
  }

  function chooseHighWaterMark(capacity, maxLoad) {
    return Math.min(capacity - 2, capacity * maxLoad | 0);
  }

  function chooseGrowCapacity(size, minLoad, maxLoad) {
    return nextPrime(Math.max(size + 1, 4 * size / (3 * minLoad + maxLoad) | 0));
  }

  function chooseShrinkCapacity(size, minLoad, maxLoad) {
    return nextPrime(Math.max(size + 1, 4 * size / (minLoad + 3 * maxLoad) | 0));
  }

  function newArray(size) {
    return Array(size).fill(0);
  }

  /* eslint-disable no-eval */
  class SparseMatrix {
    constructor(rows, columns, options = {}) {
      if (rows instanceof SparseMatrix) {
        // clone
        const other = rows;

        this._init(other.rows, other.columns, other.elements.clone(), other.threshold);

        return;
      }

      if (Array.isArray(rows)) {
        const matrix = rows;
        rows = matrix.length;
        options = columns || {};
        columns = matrix[0].length;

        this._init(rows, columns, new HashTable(options), options.threshold);

        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            let value = matrix[i][j];
            if (this.threshold && Math.abs(value) < this.threshold) value = 0;

            if (value !== 0) {
              this.elements.set(i * columns + j, matrix[i][j]);
            }
          }
        }
      } else {
        this._init(rows, columns, new HashTable(options), options.threshold);
      }
    }

    _init(rows, columns, elements, threshold) {
      this.rows = rows;
      this.columns = columns;
      this.elements = elements;
      this.threshold = threshold || 0;
    }

    static eye(rows = 1, columns = rows) {
      const min = Math.min(rows, columns);
      const matrix = new SparseMatrix(rows, columns, {
        initialCapacity: min
      });

      for (let i = 0; i < min; i++) {
        matrix.set(i, i, 1);
      }

      return matrix;
    }

    clone() {
      return new SparseMatrix(this);
    }

    to2DArray() {
      const copy = new Array(this.rows);

      for (let i = 0; i < this.rows; i++) {
        copy[i] = new Array(this.columns);

        for (let j = 0; j < this.columns; j++) {
          copy[i][j] = this.get(i, j);
        }
      }

      return copy;
    }

    isSquare() {
      return this.rows === this.columns;
    }

    isSymmetric() {
      if (!this.isSquare()) return false;
      let symmetric = true;
      this.forEachNonZero((i, j, v) => {
        if (this.get(j, i) !== v) {
          symmetric = false;
          return false;
        }

        return v;
      });
      return symmetric;
    }
    /**
     * Search for the wither band in the main diagonals
     * @return {number}
     */


    bandWidth() {
      let min = this.columns;
      let max = -1;
      this.forEachNonZero((i, j, v) => {
        let diff = i - j;
        min = Math.min(min, diff);
        max = Math.max(max, diff);
        return v;
      });
      return max - min;
    }
    /**
     * Test if a matrix is consider banded using a threshold
     * @param {number} width
     * @return {boolean}
     */


    isBanded(width) {
      let bandWidth = this.bandWidth();
      return bandWidth <= width;
    }

    get cardinality() {
      return this.elements.size;
    }

    get size() {
      return this.rows * this.columns;
    }

    get(row, column) {
      return this.elements.get(row * this.columns + column);
    }

    set(row, column, value) {
      if (this.threshold && Math.abs(value) < this.threshold) value = 0;

      if (value === 0) {
        this.elements.remove(row * this.columns + column);
      } else {
        this.elements.set(row * this.columns + column, value);
      }

      return this;
    }

    mmul(other) {
      if (this.columns !== other.rows) {
        // eslint-disable-next-line no-console
        console.warn('Number of columns of left matrix are not equal to number of rows of right matrix.');
      }

      const m = this.rows;
      const p = other.columns;
      const result = new SparseMatrix(m, p);
      this.forEachNonZero((i, j, v1) => {
        other.forEachNonZero((k, l, v2) => {
          if (j === k) {
            result.set(i, l, result.get(i, l) + v1 * v2);
          }

          return v2;
        });
        return v1;
      });
      return result;
    }

    kroneckerProduct(other) {
      const m = this.rows;
      const n = this.columns;
      const p = other.rows;
      const q = other.columns;
      const result = new SparseMatrix(m * p, n * q, {
        initialCapacity: this.cardinality * other.cardinality
      });
      this.forEachNonZero((i, j, v1) => {
        other.forEachNonZero((k, l, v2) => {
          result.set(p * i + k, q * j + l, v1 * v2);
          return v2;
        });
        return v1;
      });
      return result;
    }

    forEachNonZero(callback) {
      this.elements.forEachPair((key, value) => {
        const i = key / this.columns | 0;
        const j = key % this.columns;
        let r = callback(i, j, value);
        if (r === false) return false; // stop iteration

        if (this.threshold && Math.abs(r) < this.threshold) r = 0;

        if (r !== value) {
          if (r === 0) {
            this.elements.remove(key, true);
          } else {
            this.elements.set(key, r);
          }
        }

        return true;
      });
      this.elements.maybeShrinkCapacity();
      return this;
    }

    getNonZeros() {
      const cardinality = this.cardinality;
      const rows = new Array(cardinality);
      const columns = new Array(cardinality);
      const values = new Array(cardinality);
      let idx = 0;
      this.forEachNonZero((i, j, value) => {
        rows[idx] = i;
        columns[idx] = j;
        values[idx] = value;
        idx++;
        return value;
      });
      return {
        rows,
        columns,
        values
      };
    }

    setThreshold(newThreshold) {
      if (newThreshold !== 0 && newThreshold !== this.threshold) {
        this.threshold = newThreshold;
        this.forEachNonZero((i, j, v) => v);
      }

      return this;
    }
    /**
     * @return {SparseMatrix} - New transposed sparse matrix
     */


    transpose() {
      let trans = new SparseMatrix(this.columns, this.rows, {
        initialCapacity: this.cardinality
      });
      this.forEachNonZero((i, j, value) => {
        trans.set(j, i, value);
        return value;
      });
      return trans;
    }

    isEmpty() {
      return this.rows === 0 || this.columns === 0;
    }

  }
  SparseMatrix.prototype.klass = 'Matrix';
  SparseMatrix.identity = SparseMatrix.eye;
  SparseMatrix.prototype.tensorProduct = SparseMatrix.prototype.kroneckerProduct;
  /*
   Add dynamically instance and static methods for mathematical operations
   */

  let inplaceOperator = `
(function %name%(value) {
    if (typeof value === 'number') return this.%name%S(value);
    return this.%name%M(value);
})
`;
  let inplaceOperatorScalar = `
(function %name%S(value) {
    this.forEachNonZero((i, j, v) => v %op% value);
    return this;
})
`;
  let inplaceOperatorMatrix = `
(function %name%M(matrix) {
    matrix.forEachNonZero((i, j, v) => {
        this.set(i, j, this.get(i, j) %op% v);
        return v;
    });
    return this;
})
`;
  let staticOperator = `
(function %name%(matrix, value) {
    var newMatrix = new SparseMatrix(matrix);
    return newMatrix.%name%(value);
})
`;
  let inplaceMethod = `
(function %name%() {
    this.forEachNonZero((i, j, v) => %method%(v));
    return this;
})
`;
  let staticMethod = `
(function %name%(matrix) {
    var newMatrix = new SparseMatrix(matrix);
    return newMatrix.%name%();
})
`;
  const operators = [// Arithmetic operators
  ['+', 'add'], ['-', 'sub', 'subtract'], ['*', 'mul', 'multiply'], ['/', 'div', 'divide'], ['%', 'mod', 'modulus'], // Bitwise operators
  ['&', 'and'], ['|', 'or'], ['^', 'xor'], ['<<', 'leftShift'], ['>>', 'signPropagatingRightShift'], ['>>>', 'rightShift', 'zeroFillRightShift']];

  for (const operator of operators) {
    for (let i = 1; i < operator.length; i++) {
      SparseMatrix.prototype[operator[i]] = eval(fillTemplateFunction(inplaceOperator, {
        name: operator[i],
        op: operator[0]
      }));
      SparseMatrix.prototype[`${operator[i]}S`] = eval(fillTemplateFunction(inplaceOperatorScalar, {
        name: `${operator[i]}S`,
        op: operator[0]
      }));
      SparseMatrix.prototype[`${operator[i]}M`] = eval(fillTemplateFunction(inplaceOperatorMatrix, {
        name: `${operator[i]}M`,
        op: operator[0]
      }));
      SparseMatrix[operator[i]] = eval(fillTemplateFunction(staticOperator, {
        name: operator[i]
      }));
    }
  }

  let methods = [['~', 'not']];
  ['abs', 'acos', 'acosh', 'asin', 'asinh', 'atan', 'atanh', 'cbrt', 'ceil', 'clz32', 'cos', 'cosh', 'exp', 'expm1', 'floor', 'fround', 'log', 'log1p', 'log10', 'log2', 'round', 'sign', 'sin', 'sinh', 'sqrt', 'tan', 'tanh', 'trunc'].forEach(function (mathMethod) {
    methods.push([`Math.${mathMethod}`, mathMethod]);
  });

  for (const method of methods) {
    for (let i = 1; i < method.length; i++) {
      SparseMatrix.prototype[method[i]] = eval(fillTemplateFunction(inplaceMethod, {
        name: method[i],
        method: method[0]
      }));
      SparseMatrix[method[i]] = eval(fillTemplateFunction(staticMethod, {
        name: method[i]
      }));
    }
  }

  function fillTemplateFunction(template, values) {
    for (const i in values) {
      template = template.replace(new RegExp(`%${i}%`, 'g'), values[i]);
    }

    return template;
  }

  function addBaseline(data, baselineFct) {
    if (!baselineFct) return data;
    let xs = data.x;
    let ys = data.y;

    for (let i = 0; i < xs.length; i++) {
      ys[i] += baselineFct(xs[i]);
    }

    return data;
  }

  var defaultSource = Math.random;

  var randomUniform = (function sourceRandomUniform(source) {
    function randomUniform(min, max) {
      min = min == null ? 0 : +min;
      max = max == null ? 1 : +max;
      if (arguments.length === 1) max = min, min = 0;else max -= min;
      return function () {
        return source() * max + min;
      };
    }

    randomUniform.source = sourceRandomUniform;
    return randomUniform;
  })(defaultSource);

  var randomNormal = (function sourceRandomNormal(source) {
    function randomNormal(mu, sigma) {
      var x, r;
      mu = mu == null ? 0 : +mu;
      sigma = sigma == null ? 1 : +sigma;
      return function () {
        var y; // If available, use the second previously-generated uniform random.

        if (x != null) y = x, x = null; // Otherwise, generate a new x and y.
        else do {
            x = source() * 2 - 1;
            y = source() * 2 - 1;
            r = x * x + y * y;
          } while (!r || r > 1);
        return mu + sigma * y * Math.sqrt(-2 * Math.log(r) / r);
      };
    }

    randomNormal.source = sourceRandomNormal;
    return randomNormal;
  })(defaultSource);

  const LOOP = 8;
  const FLOAT_MUL = 1 / 16777216;
  const sh1 = 15;
  const sh2 = 18;
  const sh3 = 11;

  function multiply_uint32(n, m) {
    n >>>= 0;
    m >>>= 0;
    const nlo = n & 0xffff;
    const nhi = n - nlo;
    return (nhi * m >>> 0) + nlo * m >>> 0;
  }

  class XSadd {
    constructor(seed = Date.now()) {
      this.state = new Uint32Array(4);
      this.init(seed);
      this.random = this.getFloat.bind(this);
    }
    /**
     * Returns a 32-bit integer r (0 <= r < 2^32)
     */


    getUint32() {
      this.nextState();
      return this.state[3] + this.state[2] >>> 0;
    }
    /**
     * Returns a floating point number r (0.0 <= r < 1.0)
     */


    getFloat() {
      return (this.getUint32() >>> 8) * FLOAT_MUL;
    }

    init(seed) {
      if (!Number.isInteger(seed)) {
        throw new TypeError('seed must be an integer');
      }

      this.state[0] = seed;
      this.state[1] = 0;
      this.state[2] = 0;
      this.state[3] = 0;

      for (let i = 1; i < LOOP; i++) {
        this.state[i & 3] ^= i + multiply_uint32(1812433253, this.state[i - 1 & 3] ^ this.state[i - 1 & 3] >>> 30 >>> 0) >>> 0;
      }

      this.periodCertification();

      for (let i = 0; i < LOOP; i++) {
        this.nextState();
      }
    }

    periodCertification() {
      if (this.state[0] === 0 && this.state[1] === 0 && this.state[2] === 0 && this.state[3] === 0) {
        this.state[0] = 88; // X

        this.state[1] = 83; // S

        this.state[2] = 65; // A

        this.state[3] = 68; // D
      }
    }

    nextState() {
      let t = this.state[0];
      t ^= t << sh1;
      t ^= t >>> sh2;
      t ^= this.state[3] << sh3;
      this.state[0] = this.state[1];
      this.state[1] = this.state[2];
      this.state[2] = this.state[3];
      this.state[3] = t;
    }

  }

  function addNoise(data, percent = 0, options = {}) {
    const {
      distribution = 'uniform',
      seed
    } = options;
    let generateRandomNumber;

    switch (distribution) {
      case 'uniform':
        {
          generateRandomNumber = getRandom(randomUniform, seed, -0.5, 0.5);
          break;
        }

      case 'normal':
        {
          generateRandomNumber = getRandom(randomNormal, seed);
          break;
        }

      default:
        throw new Error(`Unknown distribution ${options.distribution}`);
    }

    if (!percent) return data;
    let ys = data.y;
    let factor = percent * findMax(ys) / 100;

    for (let i = 0; i < ys.length; i++) {
      ys[i] += generateRandomNumber() * factor;
    }

    return data;
  }

  function getRandom(func, seed, ...args) {
    return typeof seed === 'number' ? func.source(new XSadd(seed).random)(...args) : func(...args);
  }

  function findMax(array) {
    let max = Number.MIN_VALUE;

    for (let item of array) {
      if (item > max) max = item;
    }

    return max;
  }

  class SpectrumGenerator {
    /**
     *
     * @param {object} [options={}]
     * @param {number} [options.from=0]
     * @param {number} [options.to=0]
     * @param {function} [options.nbPoints=10001]
     * @param {number} [options.factor] default value depends of the shape in order to cover 99.99% of the surface
     * @param {object} [options.shape={kind:'gaussian'}]
     * @param {string} [options.shape.kind] kind of shape, gaussian, lorentzian or pseudovoigt
     * @param {object} [options.shape.options] options for the shape (like `mu` for pseudovoigt)
     */
    constructor(options = {}) {
      options = Object.assign({}, {
        from: 0,
        to: 1000,
        nbPoints: 10001,
        peakWidthFct: () => 5,
        shape: {
          kind: 'gaussian'
        }
      }, options);
      this.from = options.from;
      this.to = options.to;
      this.nbPoints = options.nbPoints;
      this.interval = (this.to - this.from) / (this.nbPoints - 1);
      this.peakWidthFct = options.peakWidthFct;
      this.maxPeakHeight = Number.MIN_SAFE_INTEGER;
      let shapeGenerator = getShapeGenerator(options.shape);
      this.shape = shapeGenerator;
      assertNumber(this.from, 'from');
      assertNumber(this.to, 'to');
      assertInteger(this.nbPoints, 'nbPoints');

      if (this.to <= this.from) {
        throw new RangeError('to option must be larger than from');
      }

      if (typeof this.peakWidthFct !== 'function') {
        throw new TypeError('peakWidthFct option must be a function');
      }

      this.reset();
    }

    addPeaks(peaks, options) {
      if (!Array.isArray(peaks) && (typeof peaks !== 'object' || peaks.x === undefined || peaks.y === undefined || !Array.isArray(peaks.x) || !Array.isArray(peaks.y) || peaks.x.length !== peaks.y.length)) {
        throw new TypeError('peaks must be an array or an object containing x[] and y[]');
      }

      if (Array.isArray(peaks)) {
        for (const peak of peaks) {
          this.addPeak(peak, options);
        }
      } else {
        for (let i = 0; i < peaks.x.length; i++) {
          this.addPeak([peaks.x[i], peaks.y[i]], options);
        }
      }

      return this;
    }
    /**
     *
     * @param {[x,y]|[x,y,w]|{x,y,width}} [peak]
     * @param {*} options
     */


    addPeak(peak, options = {}) {
      if (typeof peak !== 'object' || peak.length !== 2 && peak.length !== 3 && (peak.x === undefined || peak.y === undefined)) {
        throw new Error('peak must be an array with two (or three) values or an object with {x,y,width?}');
      }

      let xPosition;
      let intensity;
      let peakWidth;
      let peakOptions;

      if (Array.isArray(peak)) {
        [xPosition, intensity, peakWidth, peakOptions] = peak;
      } else {
        xPosition = peak.x;
        intensity = peak.y;
        peakWidth = peak.width;
        peakOptions = peak.options;
      }

      if (intensity > this.maxPeakHeight) this.maxPeakHeight = intensity;
      let {
        width = peakWidth === undefined ? this.peakWidthFct(xPosition) : peakWidth,
        widthLeft,
        widthRight,
        shape: shapeOptions
      } = options;

      if (peakOptions) {
        Object.assign(shapeOptions || {}, peakOptions || {});
      }

      let shapeGenerator = shapeOptions ? getShapeGenerator(shapeOptions) : this.shape;
      if (!widthLeft) widthLeft = width;
      if (!widthRight) widthRight = width;
      let factor = options.factor === undefined ? shapeGenerator.getFactor() : options.factor;
      const firstValue = xPosition - widthLeft / 2 * factor;
      const lastValue = xPosition + widthRight / 2 * factor;
      const firstPoint = Math.max(0, Math.floor((firstValue - this.from) / this.interval));
      const lastPoint = Math.min(this.nbPoints - 1, Math.ceil((lastValue - this.from) / this.interval));
      const middlePoint = Math.round((xPosition - this.from) / this.interval); // PEAK SHAPE MAY BE ASYMMETRC (widthLeft and widthRight) !
      // we calculate the left part of the shape

      shapeGenerator.setFWHM(widthLeft);

      for (let index = firstPoint; index < Math.max(middlePoint, 0); index++) {
        this.data.y[index] += intensity * shapeGenerator.fct(this.data.x[index] - xPosition);
      } // we calculate the right part of the gaussian


      shapeGenerator.setFWHM(widthRight);

      for (let index = Math.min(middlePoint, lastPoint); index <= lastPoint; index++) {
        this.data.y[index] += intensity * shapeGenerator.fct(this.data.x[index] - xPosition);
      }

      return this;
    }

    addBaseline(baselineFct) {
      addBaseline(this.data, baselineFct);
      return this;
    }

    addNoise(percent, options) {
      addNoise(this.data, percent, options);
      return this;
    }

    getSpectrum(options = {}) {
      if (typeof options === 'boolean') {
        options = {
          copy: options
        };
      }

      const {
        copy = true,
        threshold = 0
      } = options;

      if (threshold) {
        let minPeakHeight = this.maxPeakHeight * threshold;
        let x = [];
        let y = [];

        for (let i = 0; i < this.data.x.length; i++) {
          if (this.data.y[i] >= minPeakHeight) {
            x.push(this.data.x[i]);
            y.push(this.data.y[i]);
          }
        }

        return {
          x,
          y
        };
      }

      if (copy) {
        return {
          x: this.data.x.slice(),
          y: this.data.y.slice()
        };
      } else {
        return this.data;
      }
    }

    reset() {
      const spectrum = this.data = {
        x: new Float64Array(this.nbPoints),
        y: new Float64Array(this.nbPoints)
      };

      for (let i = 0; i < this.nbPoints; i++) {
        spectrum.x[i] = this.from + i * this.interval;
      }

      return this;
    }

  }

  function assertInteger(value, name) {
    if (!Number.isInteger(value)) {
      throw new TypeError(`${name} option must be an integer`);
    }
  }

  function assertNumber(value, name) {
    if (!Number.isFinite(value)) {
      throw new TypeError(`${name} option must be a number`);
    }
  }

  function createPauli(mult) {
    const spin = (mult - 1) / 2;
    const prjs = new Array(mult);
    const temp = new Array(mult);

    for (let i = 0; i < mult; i++) {
      prjs[i] = mult - 1 - i - spin;
      temp[i] = Math.sqrt(spin * (spin + 1) - prjs[i] * (prjs[i] + 1));
    }

    const p = diag(temp, 1, mult, mult);

    for (let i = 0; i < mult; i++) {
      temp[i] = Math.sqrt(spin * (spin + 1) - prjs[i] * (prjs[i] - 1));
    }

    const m = diag(temp, -1, mult, mult);
    const x = p.clone().add(m).mul(0.5);
    const y = m.clone().mul(-1).add(p).mul(-0.5);
    const z = diag(prjs, 0, mult, mult);
    return {
      x,
      y,
      z,
      m,
      p
    };
  }

  function diag(A, d, n, m) {
    const diag = new SparseMatrix(n, m, {
      initialCapacity: 20
    });

    for (let i = 0; i < A.length; i++) {
      if (i - d >= 0 && i - d < n && i < m) {
        diag.set(i - d, i, A[i]);
      }
    }

    return diag;
  }

  const pauli2 = createPauli(2);
  function getPauliMatrix(mult) {
    if (mult === 2) return pauli2;else return createPauli(mult);
  }

  const smallValue = 1e-2;
  /**
   * This function simulates a one dimensional nmr spectrum. This function returns an array containing the relative intensities of the spectrum in the specified simulation window (from-to).
   * @param {object} spinSystem - The SpinSystem object to be simulated
   * @param {object} [options={}] - options.
   * @param {number} [options.frequency=400] - The frequency in Mhz of the fake spectrometer that records the spectrum.
   * @param {number} [options.lineWidth=1] - The linewidth of the output spectrum, expresed in Hz.
   * @param {object} options.shape - options for spectrum-generator.
   * @param {string} [options.shape.kind='gaussian'] - kind of shape to generate the spectrum.
   * @param {object} options.shape.options - spectrum and shape options. See spectrum-generator for more information about shape options.
   * @param {number} [options.from=0] - The low limit of the ordinate variable.
   * @param {number} [options.to=10] - The upper limit of the ordinate variable.
   * @param {number} [options.nbPoints=16*1024] - Number of points of the output spectrum.
   * @param {number} [options.maxClusterSize=8] - Maximum number of atoms on each cluster that can be considered to be simulated together. It affects the the quality and speed of the simulation.
   * @return {object}
   */

  function simulate1D(spinSystem, options) {
    let {
      lineWidth = 1,
      maxClusterSize = 10,
      frequency: frequencyMHz = 400,
      shape = {
        kind: 'gaussian',
        options: {
          from: 0,
          to: 10,
          nbPoints: 1024
        }
      }
    } = options;
    let {
      options: shapeOptions
    } = shape;
    let peakWidth = lineWidth / frequencyMHz;

    shapeOptions.peakWidthFct = () => peakWidth;

    let spectrumGenerator = new SpectrumGenerator(shapeOptions);
    const chemicalShifts = spinSystem.chemicalShifts.slice();

    for (let i = 0; i < chemicalShifts.length; i++) {
      chemicalShifts[i] = chemicalShifts[i] * frequencyMHz;
    }

    const multiplicity = spinSystem.multiplicity;

    for (let h = 0; h < spinSystem.clusters.length; h++) {
      const cluster = spinSystem.clusters[h];
      let clusterFake = new Array(cluster.length);

      for (let i = 0; i < cluster.length; i++) {
        clusterFake[i] = cluster[i] < 0 ? -cluster[i] - 1 : cluster[i];
      }

      let weight = 1;
      let sumI = 0;
      let frequencies = [];
      let intensities = [];

      if (cluster.length > maxClusterSize) {
        // This is a single spin, but the cluster exceeds the maxClusterSize criteria
        // we use the simple multiplicity algorithm
        // Add the central peak. It will be split with every single J coupling.
        let index = 0;

        while (cluster[index++] < 0);

        index = cluster[index - 1];
        frequencies.push(-chemicalShifts[index]);

        for (let i = 0; i < cluster.length; i++) {
          if (cluster[i] < 0) {
            let jc = spinSystem.couplingConstants.get(index, clusterFake[i]) / 2;
            let currentSize = frequencies.length;

            for (let j = 0; j < currentSize; j++) {
              frequencies.push(frequencies[j] + jc);
              frequencies[j] -= jc;
            }
          }
        }

        frequencies = Float64Array.from(frequencies).sort();
        sumI = frequencies.length;
        weight = 1;

        for (let i = 0; i < sumI; i++) {
          intensities.push(1);
        }
      } else {
        const hamiltonian = getHamiltonian(chemicalShifts, spinSystem.couplingConstants, multiplicity, spinSystem.connectivity, clusterFake);
        const hamSize = hamiltonian.rows;
        const evd = new EigenvalueDecomposition(hamiltonian);
        const V = evd.eigenvectorMatrix;
        const diagB = evd.realEigenvalues;
        const assignmentMatrix = new SparseMatrix(hamSize, hamSize);
        const multLen = cluster.length;
        weight = 0;

        for (let n = 0; n < multLen; n++) {
          const L = getPauliMatrix(multiplicity[clusterFake[n]]);
          let temp = 1;

          for (let j = 0; j < n; j++) {
            temp *= multiplicity[clusterFake[j]];
          }

          const A = SparseMatrix.eye(temp);
          temp = 1;

          for (let j = n + 1; j < multLen; j++) {
            temp *= multiplicity[clusterFake[j]];
          }

          const B = SparseMatrix.eye(temp);
          const tempMat = A.kroneckerProduct(L.m).kroneckerProduct(B);

          if (cluster[n] >= 0) {
            assignmentMatrix.add(tempMat.mul(cluster[n] + 1));
            weight++;
          } else {
            assignmentMatrix.add(tempMat.mul(cluster[n]));
          }
        }

        let rhoip = Matrix.zeros(hamSize, hamSize);
        assignmentMatrix.forEachNonZero((i, j, v) => {
          if (v > 0) {
            for (let k = 0; k < V.columns; k++) {
              let element = V.get(j, k);

              if (element !== 0) {
                rhoip.set(i, k, rhoip.get(i, k) + element);
              }
            }
          }

          return v;
        });
        let rhoip2 = rhoip.clone();
        assignmentMatrix.forEachNonZero((i, j, v) => {
          if (v < 0) {
            for (let k = 0; k < V.columns; k++) {
              let element = V.get(j, k);

              if (element !== 0) {
                rhoip2.set(i, k, rhoip2.get(i, k) + element);
              }
            }
          }

          return v;
        });
        const tV = V.transpose();
        rhoip = tV.mmul(rhoip);
        rhoip = new SparseMatrix(rhoip.to2DArray(), {
          threshold: smallValue
        });
        triuTimesAbs(rhoip, smallValue);
        rhoip2 = tV.mmul(rhoip2);
        rhoip2 = new SparseMatrix(rhoip2.to2DArray(), {
          threshold: smallValue
        });
        rhoip2.forEachNonZero((i, j, v) => {
          return v;
        });
        triuTimesAbs(rhoip2, smallValue);
        rhoip2.forEachNonZero((i, j, v) => {
          let val = rhoip.get(i, j);
          val = Math.min(Math.abs(val), Math.abs(v));
          val *= val;
          sumI += val;
          let valFreq = diagB[i] - diagB[j];
          let insertIn = binarySearch(frequencies, valFreq, (a, b) => a - b);

          if (insertIn < 0) {
            frequencies.splice(-1 - insertIn, 0, valFreq);
            intensities.splice(-1 - insertIn, 0, val);
          } else {
            intensities[insertIn] += val;
          }
        });
      }

      const numFreq = frequencies.length;

      if (numFreq > 0) {
        weight /= sumI;
        const diff = lineWidth / 64;
        let valFreq = frequencies[0];
        let inte = intensities[0];
        let count = 1;

        for (let i = 1; i < numFreq; i++) {
          if (Math.abs(frequencies[i] - valFreq / count) < diff) {
            inte += intensities[i];
            valFreq += frequencies[i];
            count++;
          } else {
            spectrumGenerator.addPeak({
              x: -valFreq / count / frequencyMHz,
              y: inte * weight
            });
            valFreq = frequencies[i];
            inte = intensities[i];
            count = 1;
          }
        }

        spectrumGenerator.addPeak({
          x: -valFreq / count / frequencyMHz,
          y: inte * weight
        });
      }
    }

    return spectrumGenerator.data;
  }

  function triuTimesAbs(A, val) {
    A.forEachNonZero((i, j, v) => {
      if (i > j) return 0;
      if (Math.abs(v) <= val) return 0;
      return v;
    });
  }
  /**
   * Create a hamiltonian matrix for the given spinsystem
   * @param {Array} chemicalShifts - An array containing the chemical shift in Hz
   * @param {Array} couplingConstants - An array containing the coupling constants in Hz
   * @param {Array} multiplicity - An array specifiying the multiplicities of each scalar coupling
   * @param {Array} conMatrix - A one step connectivity matrix for the given spin system
   * @param {Array} cluster - An binary array specifiying the spins to be considered for this hamiltonial
   * @return {object}
   */


  function getHamiltonian(chemicalShifts, couplingConstants, multiplicity, conMatrix, cluster) {
    let hamSize = 1;

    for (let i = 0; i < cluster.length; i++) {
      hamSize *= multiplicity[cluster[i]];
    }

    const clusterHam = new SparseMatrix(hamSize, hamSize);

    for (let pos = 0; pos < cluster.length; pos++) {
      let n = cluster[pos];
      const L = getPauliMatrix(multiplicity[n]);
      let A1, B1;
      let temp = 1;

      for (let i = 0; i < pos; i++) {
        temp *= multiplicity[cluster[i]];
      }

      A1 = SparseMatrix.eye(temp);
      temp = 1;

      for (let i = pos + 1; i < cluster.length; i++) {
        temp *= multiplicity[cluster[i]];
      }

      B1 = SparseMatrix.eye(temp);
      const alpha = chemicalShifts[n];
      const kronProd = A1.kroneckerProduct(L.z).kroneckerProduct(B1);
      clusterHam.add(kronProd.mul(alpha));

      for (let pos2 = 0; pos2 < cluster.length; pos2++) {
        const k = cluster[pos2];

        if (conMatrix.get(n, k) === 1) {
          const S = getPauliMatrix(multiplicity[k]);
          let A2, B2;
          let temp = 1;

          for (let i = 0; i < pos2; i++) {
            temp *= multiplicity[cluster[i]];
          }

          A2 = SparseMatrix.eye(temp);
          temp = 1;

          for (let i = pos2 + 1; i < cluster.length; i++) {
            temp *= multiplicity[cluster[i]];
          }

          B2 = SparseMatrix.eye(temp);
          const kron1 = A1.kroneckerProduct(L.x).kroneckerProduct(B1).mmul(A2.kroneckerProduct(S.x).kroneckerProduct(B2));
          kron1.add(A1.kroneckerProduct(L.y).kroneckerProduct(B1).mul(-1).mmul(A2.kroneckerProduct(S.y).kroneckerProduct(B2)));
          kron1.add(A1.kroneckerProduct(L.z).kroneckerProduct(B1).mmul(A2.kroneckerProduct(S.z).kroneckerProduct(B2)));
          clusterHam.add(kron1.mul(couplingConstants.get(n, k) / 2));
        }
      }
    }

    return clusterHam;
  }

  function squaredEuclidean(p, q) {
    let d = 0;

    for (let i = 0; i < p.length; i++) {
      d += (p[i] - q[i]) * (p[i] - q[i]);
    }

    return d;
  }
  function euclidean(p, q) {
    return Math.sqrt(squaredEuclidean(p, q));
  }

  /**
   * Computes a distance/similarity matrix given an array of data and a distance/similarity function.
   * @param {Array} data An array of data
   * @param {function} distanceFn  A function that accepts two arguments and computes a distance/similarity between them
   * @return {Array<Array>} The distance/similarity matrix. The matrix is square and has a size equal to the length of
   * the data array
   */
  function distanceMatrix(data, distanceFn) {
    const result = getMatrix(data.length); // Compute upper distance matrix

    for (let i = 0; i < data.length; i++) {
      for (let j = 0; j <= i; j++) {
        result[i][j] = distanceFn(data[i], data[j]);
        result[j][i] = result[i][j];
      }
    }

    return result;
  }

  function getMatrix(size) {
    const matrix = [];

    for (let i = 0; i < size; i++) {
      const row = [];
      matrix.push(row);

      for (let j = 0; j < size; j++) {
        row.push(0);
      }
    }

    return matrix;
  }

  var heap$1 = {exports: {}};

  (function (module, exports) {
    // Generated by CoffeeScript 1.8.0
    (function () {
      var Heap, defaultCmp, floor, heapify, heappop, heappush, heappushpop, heapreplace, insort, min, nlargest, nsmallest, updateItem, _siftdown, _siftup;

      floor = Math.floor, min = Math.min;
      /*
      Default comparison function to be used
       */

      defaultCmp = function (x, y) {
        if (x < y) {
          return -1;
        }

        if (x > y) {
          return 1;
        }

        return 0;
      };
      /*
      Insert item x in list a, and keep it sorted assuming a is sorted.
      
      If x is already in a, insert it to the right of the rightmost x.
      
      Optional args lo (default 0) and hi (default a.length) bound the slice
      of a to be searched.
       */


      insort = function (a, x, lo, hi, cmp) {
        var mid;

        if (lo == null) {
          lo = 0;
        }

        if (cmp == null) {
          cmp = defaultCmp;
        }

        if (lo < 0) {
          throw new Error('lo must be non-negative');
        }

        if (hi == null) {
          hi = a.length;
        }

        while (lo < hi) {
          mid = floor((lo + hi) / 2);

          if (cmp(x, a[mid]) < 0) {
            hi = mid;
          } else {
            lo = mid + 1;
          }
        }

        return [].splice.apply(a, [lo, lo - lo].concat(x)), x;
      };
      /*
      Push item onto heap, maintaining the heap invariant.
       */


      heappush = function (array, item, cmp) {
        if (cmp == null) {
          cmp = defaultCmp;
        }

        array.push(item);
        return _siftdown(array, 0, array.length - 1, cmp);
      };
      /*
      Pop the smallest item off the heap, maintaining the heap invariant.
       */


      heappop = function (array, cmp) {
        var lastelt, returnitem;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        lastelt = array.pop();

        if (array.length) {
          returnitem = array[0];
          array[0] = lastelt;

          _siftup(array, 0, cmp);
        } else {
          returnitem = lastelt;
        }

        return returnitem;
      };
      /*
      Pop and return the current smallest value, and add the new item.
      
      This is more efficient than heappop() followed by heappush(), and can be
      more appropriate when using a fixed size heap. Note that the value
      returned may be larger than item! That constrains reasonable use of
      this routine unless written as part of a conditional replacement:
          if item > array[0]
            item = heapreplace(array, item)
       */


      heapreplace = function (array, item, cmp) {
        var returnitem;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        returnitem = array[0];
        array[0] = item;

        _siftup(array, 0, cmp);

        return returnitem;
      };
      /*
      Fast version of a heappush followed by a heappop.
       */


      heappushpop = function (array, item, cmp) {
        var _ref;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        if (array.length && cmp(array[0], item) < 0) {
          _ref = [array[0], item], item = _ref[0], array[0] = _ref[1];

          _siftup(array, 0, cmp);
        }

        return item;
      };
      /*
      Transform list into a heap, in-place, in O(array.length) time.
       */


      heapify = function (array, cmp) {
        var i, _i, _len, _ref1, _results, _results1;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        _ref1 = function () {
          _results1 = [];

          for (var _j = 0, _ref = floor(array.length / 2); 0 <= _ref ? _j < _ref : _j > _ref; 0 <= _ref ? _j++ : _j--) {
            _results1.push(_j);
          }

          return _results1;
        }.apply(this).reverse();

        _results = [];

        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
          i = _ref1[_i];

          _results.push(_siftup(array, i, cmp));
        }

        return _results;
      };
      /*
      Update the position of the given item in the heap.
      This function should be called every time the item is being modified.
       */


      updateItem = function (array, item, cmp) {
        var pos;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        pos = array.indexOf(item);

        if (pos === -1) {
          return;
        }

        _siftdown(array, 0, pos, cmp);

        return _siftup(array, pos, cmp);
      };
      /*
      Find the n largest elements in a dataset.
       */


      nlargest = function (array, n, cmp) {
        var elem, result, _i, _len, _ref;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        result = array.slice(0, n);

        if (!result.length) {
          return result;
        }

        heapify(result, cmp);
        _ref = array.slice(n);

        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          elem = _ref[_i];
          heappushpop(result, elem, cmp);
        }

        return result.sort(cmp).reverse();
      };
      /*
      Find the n smallest elements in a dataset.
       */


      nsmallest = function (array, n, cmp) {
        var elem, los, result, _i, _j, _len, _ref, _ref1, _results;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        if (n * 10 <= array.length) {
          result = array.slice(0, n).sort(cmp);

          if (!result.length) {
            return result;
          }

          los = result[result.length - 1];
          _ref = array.slice(n);

          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            elem = _ref[_i];

            if (cmp(elem, los) < 0) {
              insort(result, elem, 0, null, cmp);
              result.pop();
              los = result[result.length - 1];
            }
          }

          return result;
        }

        heapify(array, cmp);
        _results = [];

        for (_j = 0, _ref1 = min(n, array.length); 0 <= _ref1 ? _j < _ref1 : _j > _ref1; 0 <= _ref1 ? ++_j : --_j) {
          _results.push(heappop(array, cmp));
        }

        return _results;
      };

      _siftdown = function (array, startpos, pos, cmp) {
        var newitem, parent, parentpos;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        newitem = array[pos];

        while (pos > startpos) {
          parentpos = pos - 1 >> 1;
          parent = array[parentpos];

          if (cmp(newitem, parent) < 0) {
            array[pos] = parent;
            pos = parentpos;
            continue;
          }

          break;
        }

        return array[pos] = newitem;
      };

      _siftup = function (array, pos, cmp) {
        var childpos, endpos, newitem, rightpos, startpos;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        endpos = array.length;
        startpos = pos;
        newitem = array[pos];
        childpos = 2 * pos + 1;

        while (childpos < endpos) {
          rightpos = childpos + 1;

          if (rightpos < endpos && !(cmp(array[childpos], array[rightpos]) < 0)) {
            childpos = rightpos;
          }

          array[pos] = array[childpos];
          pos = childpos;
          childpos = 2 * pos + 1;
        }

        array[pos] = newitem;
        return _siftdown(array, startpos, pos, cmp);
      };

      Heap = function () {
        Heap.push = heappush;
        Heap.pop = heappop;
        Heap.replace = heapreplace;
        Heap.pushpop = heappushpop;
        Heap.heapify = heapify;
        Heap.updateItem = updateItem;
        Heap.nlargest = nlargest;
        Heap.nsmallest = nsmallest;

        function Heap(cmp) {
          this.cmp = cmp != null ? cmp : defaultCmp;
          this.nodes = [];
        }

        Heap.prototype.push = function (x) {
          return heappush(this.nodes, x, this.cmp);
        };

        Heap.prototype.pop = function () {
          return heappop(this.nodes, this.cmp);
        };

        Heap.prototype.peek = function () {
          return this.nodes[0];
        };

        Heap.prototype.contains = function (x) {
          return this.nodes.indexOf(x) !== -1;
        };

        Heap.prototype.replace = function (x) {
          return heapreplace(this.nodes, x, this.cmp);
        };

        Heap.prototype.pushpop = function (x) {
          return heappushpop(this.nodes, x, this.cmp);
        };

        Heap.prototype.heapify = function () {
          return heapify(this.nodes, this.cmp);
        };

        Heap.prototype.updateItem = function (x) {
          return updateItem(this.nodes, x, this.cmp);
        };

        Heap.prototype.clear = function () {
          return this.nodes = [];
        };

        Heap.prototype.empty = function () {
          return this.nodes.length === 0;
        };

        Heap.prototype.size = function () {
          return this.nodes.length;
        };

        Heap.prototype.clone = function () {
          var heap;
          heap = new Heap();
          heap.nodes = this.nodes.slice(0);
          return heap;
        };

        Heap.prototype.toArray = function () {
          return this.nodes.slice(0);
        };

        Heap.prototype.insert = Heap.prototype.push;
        Heap.prototype.top = Heap.prototype.peek;
        Heap.prototype.front = Heap.prototype.peek;
        Heap.prototype.has = Heap.prototype.contains;
        Heap.prototype.copy = Heap.prototype.clone;
        return Heap;
      }();

      (function (root, factory) {
        {
          return module.exports = factory();
        }
      })(this, function () {
        return Heap;
      });
    }).call(commonjsGlobal);
  })(heap$1);

  var heap = heap$1.exports;

  class Cluster {
    constructor() {
      this.children = [];
      this.height = 0;
      this.size = 1;
      this.index = -1;
      this.isLeaf = false;
    }
    /**
     * Creates an array of clusters where the maximum height is smaller than the threshold
     * @param {number} threshold
     * @return {Array<Cluster>}
     */


    cut(threshold) {
      if (typeof threshold !== 'number') {
        throw new TypeError('threshold must be a number');
      }

      if (threshold < 0) {
        throw new RangeError('threshold must be a positive number');
      }

      let list = [this];
      const ans = [];

      while (list.length > 0) {
        const aux = list.shift();

        if (threshold >= aux.height) {
          ans.push(aux);
        } else {
          list = list.concat(aux.children);
        }
      }

      return ans;
    }
    /**
     * Merge the leaves in the minimum way to have `groups` number of clusters.
     * @param {number} groups - Them number of children the first level of the tree should have.
     * @return {Cluster}
     */


    group(groups) {
      if (!Number.isInteger(groups) || groups < 1) {
        throw new RangeError('groups must be a positive integer');
      }

      const heap$1 = new heap((a, b) => {
        return b.height - a.height;
      });
      heap$1.push(this);

      while (heap$1.size() < groups) {
        var first = heap$1.pop();

        if (first.children.length === 0) {
          break;
        }

        first.children.forEach(child => heap$1.push(child));
      }

      var root = new Cluster();
      root.children = heap$1.toArray();
      root.height = this.height;
      return root;
    }
    /**
     * Traverses the tree depth-first and calls the provided callback with each individual node
     * @param {function} cb - The callback to be called on each node encounter
     */


    traverse(cb) {
      function visit(root, callback) {
        callback(root);

        if (root.children) {
          for (const child of root.children) {
            visit(child, callback);
          }
        }
      }

      visit(this, cb);
    }
    /**
     * Returns a list of indices for all the leaves of this cluster.
     * The list is ordered in such a way that a dendrogram could be drawn without crossing branches.
     * @returns {Array<number>}
     */


    indices() {
      const result = [];
      this.traverse(cluster => {
        if (cluster.isLeaf) {
          result.push(cluster.index);
        }
      });
      return result;
    }

  }

  function singleLink(dKI, dKJ) {
    return Math.min(dKI, dKJ);
  }

  function completeLink(dKI, dKJ) {
    return Math.max(dKI, dKJ);
  }

  function averageLink(dKI, dKJ, dIJ, ni, nj) {
    const ai = ni / (ni + nj);
    const aj = nj / (ni + nj);
    return ai * dKI + aj * dKJ;
  }

  function weightedAverageLink(dKI, dKJ) {
    return (dKI + dKJ) / 2;
  }

  function centroidLink(dKI, dKJ, dIJ, ni, nj) {
    const ai = ni / (ni + nj);
    const aj = nj / (ni + nj);
    const b = -(ni * nj) / (ni + nj) ** 2;
    return ai * dKI + aj * dKJ + b * dIJ;
  }

  function medianLink(dKI, dKJ, dIJ) {
    return dKI / 2 + dKJ / 2 - dIJ / 4;
  }

  function wardLink(dKI, dKJ, dIJ, ni, nj, nk) {
    const ai = (ni + nk) / (ni + nj + nk);
    const aj = (nj + nk) / (ni + nj + nk);
    const b = -nk / (ni + nj + nk);
    return ai * dKI + aj * dKJ + b * dIJ;
  }

  function wardLink2(dKI, dKJ, dIJ, ni, nj, nk) {
    const ai = (ni + nk) / (ni + nj + nk);
    const aj = (nj + nk) / (ni + nj + nk);
    const b = -nk / (ni + nj + nk);
    return Math.sqrt(ai * dKI * dKI + aj * dKJ * dKJ + b * dIJ * dIJ);
  }
  /**
   * Continuously merge nodes that have the least dissimilarity
   * @param {Array<Array<number>>} data - Array of points to be clustered
   * @param {object} [options]
   * @param {Function} [options.distanceFunction]
   * @param {string} [options.method] - Default: `'complete'`
   * @param {boolean} [options.isDistanceMatrix] - Is the input already a distance matrix?
   * @constructor
   */


  function agnes(data, options = {}) {
    const {
      distanceFunction = euclidean,
      method = 'complete',
      isDistanceMatrix = false
    } = options;
    let updateFunc;

    if (!isDistanceMatrix) {
      data = distanceMatrix(data, distanceFunction);
    }

    let distanceMatrix$1 = new Matrix(data);
    const numLeaves = distanceMatrix$1.rows; // allows to use a string or a given function

    if (typeof method === 'string') {
      switch (method.toLowerCase()) {
        case 'single':
          updateFunc = singleLink;
          break;

        case 'complete':
          updateFunc = completeLink;
          break;

        case 'average':
        case 'upgma':
          updateFunc = averageLink;
          break;

        case 'wpgma':
          updateFunc = weightedAverageLink;
          break;

        case 'centroid':
        case 'upgmc':
          updateFunc = centroidLink;
          break;

        case 'median':
        case 'wpgmc':
          updateFunc = medianLink;
          break;

        case 'ward':
          updateFunc = wardLink;
          break;

        case 'ward2':
          updateFunc = wardLink2;
          break;

        default:
          throw new RangeError(`unknown clustering method: ${method}`);
      }
    } else if (typeof method !== 'function') {
      throw new TypeError('method must be a string or function');
    }

    let clusters = [];

    for (let i = 0; i < numLeaves; i++) {
      const cluster = new Cluster();
      cluster.isLeaf = true;
      cluster.index = i;
      clusters.push(cluster);
    }

    for (let n = 0; n < numLeaves - 1; n++) {
      const [row, column, distance] = getSmallestDistance(distanceMatrix$1);
      const cluster1 = clusters[row];
      const cluster2 = clusters[column];
      const newCluster = new Cluster();
      newCluster.size = cluster1.size + cluster2.size;
      newCluster.children.push(cluster1, cluster2);
      newCluster.height = distance;
      const newClusters = [newCluster];
      const newDistanceMatrix = new Matrix(distanceMatrix$1.rows - 1, distanceMatrix$1.rows - 1);

      const previous = newIndex => getPreviousIndex(newIndex, Math.min(row, column), Math.max(row, column));

      for (let i = 1; i < newDistanceMatrix.rows; i++) {
        const prevI = previous(i);
        const prevICluster = clusters[prevI];
        newClusters.push(prevICluster);

        for (let j = 0; j < i; j++) {
          if (j === 0) {
            const dKI = distanceMatrix$1.get(row, prevI);
            const dKJ = distanceMatrix$1.get(prevI, column);
            const val = updateFunc(dKI, dKJ, distance, cluster1.size, cluster2.size, prevICluster.size);
            newDistanceMatrix.set(i, j, val);
            newDistanceMatrix.set(j, i, val);
          } else {
            // Just copy distance from previous matrix
            const val = distanceMatrix$1.get(prevI, previous(j));
            newDistanceMatrix.set(i, j, val);
            newDistanceMatrix.set(j, i, val);
          }
        }
      }

      clusters = newClusters;
      distanceMatrix$1 = newDistanceMatrix;
    }

    return clusters[0];
  }

  function getSmallestDistance(distance) {
    let smallest = Infinity;
    let smallestI = 0;
    let smallestJ = 0;

    for (let i = 1; i < distance.rows; i++) {
      for (let j = 0; j < i; j++) {
        if (distance.get(i, j) < smallest) {
          smallest = distance.get(i, j);
          smallestI = i;
          smallestJ = j;
        }
      }
    }

    return [smallestI, smallestJ, smallest];
  }

  function getPreviousIndex(newIndex, prev1, prev2) {
    newIndex -= 1;
    if (newIndex >= prev1) newIndex++;
    if (newIndex >= prev2) newIndex++;
    return newIndex;
  }

  function splitSpinSystem(spinSystem, options = {}) {
    let {
      chemicalShifts,
      couplingConstants,
      connectivity
    } = spinSystem;
    let {
      frequency = 400,
      maxClusterSize = 8
    } = options;
    let betas = calculateBetas(chemicalShifts, couplingConstants, frequency);
    let initClusters = agnes(betas, {
      method: 'single',
      isDistanceMatrix: true
    });
    let clusterList = [];
    let nSpins = chemicalShifts.length;
    splitCluster(initClusters, clusterList, {
      maxClusterSize,
      force: false,
      nSpins,
      connectivity
    });
    let mergedClusters = mergeClusters(clusterList, maxClusterSize);
    let nClusters = mergedClusters.length;
    let clusters = new Array(nClusters);

    for (let j = 0; j < nClusters; j++) {
      clusters[j] = [];

      for (let i = 0; i < nSpins; i++) {
        let element = mergedClusters[j][i];
        if (element === 0) continue;
        clusters[j].push(element < 0 ? -(i + 1) : i);
      }
    }

    return clusters;
  }

  function splitCluster(cluster, clusterList, options = {}) {
    let {
      maxClusterSize,
      force,
      nSpins,
      connectivity
    } = options;

    if (!force && cluster.size <= maxClusterSize) {
      clusterList.push(getMembers(cluster.indices(), nSpins));
    } else {
      for (let child of cluster.children) {
        if (child.size <= maxClusterSize) {
          let members = getMembers(child.indices(), nSpins); // Add the neighbors that shares at least 1 coupling with the given cluster

          let count = 0;

          for (let i = 0; i < nSpins; i++) {
            if (members[i] === 1) {
              for (let j = 0; j < nSpins; j++) {
                if (connectivity.get(i, j) === 1 && members[j] === 0) {
                  members[j] = -1;
                  count++;
                }
              }

              count++;
            }
          }

          if (count <= maxClusterSize) {
            clusterList.push(members);
          } else {
            if (child.index < 0) {
              splitCluster(child, clusterList, {
                maxClusterSize,
                force: true,
                nSpins,
                connectivity
              });
            } else {
              // We have to threat this spin alone and use the resurrection algorithm instead of the simulation
              members[child.index] = 2;
              clusterList.push(members);
            }
          }
        } else {
          splitCluster(child, clusterList, {
            maxClusterSize,
            force: false,
            nSpins,
            connectivity
          });
        }
      }
    }
  }

  function calculateBetas(chemicalShifts, couplingConstants, frequency) {
    let nRows = couplingConstants.rows;
    let nColumns = couplingConstants.columns;
    let betas = Matrix.zeros(nRows, nRows); // Before clustering, we must add hidden couplingConstants, we could use molecular information if available

    for (let i = 0; i < nRows; i++) {
      for (let j = i; j < nColumns; j++) {
        let element = couplingConstants.get(i, j);

        if (chemicalShifts[i] - chemicalShifts[j] !== 0) {
          let value = 1 - Math.abs(element / ((chemicalShifts[i] - chemicalShifts[j]) * frequency));
          betas.set(i, j, value);
          betas.set(j, i, value);
        } else if (!(i === j || element !== 0)) {
          betas.set(i, j, 1);
          betas.set(j, i, 1);
        }
      }
    }

    return betas.to2DArray();
  }

  function mergeClusters(list, maxClusterSize) {
    for (let i = list.length - 1; i >= 0; i--) {
      let clusterA = list[i];
      let nElements = clusterA.length;
      let index = 0; // Is it a candidate to be merged?

      while (index < nElements && clusterA[index++] !== -1);

      if (index >= nElements) continue;

      for (let j = list.length - 1; j >= i + 1; j--) {
        let clusterB = list[j]; // Do they have common elements?

        let count = 0;
        let common = 0;

        for (let index = 0; index < nElements; index++) {
          if (clusterA[index] * clusterB[index] === -1) common++;
          if (clusterA[index] !== 0 || clusterB[index] !== 0) count++;
        }

        if (common > 0 && count <= maxClusterSize) {
          // Then we can merge those 2 clusters
          for (let index = 0; index < nElements; index++) {
            if (clusterB[index] === 1) {
              clusterA[index] = 1;
            } else if (clusterB[index] === -1 && clusterA[index] !== 1) {
              clusterA[index] = -1;
            }
          }

          list.splice(j, 1);
        }
      }
    }

    return list;
  }

  function getMembers(cluster, nSpins) {
    let members = new Int16Array(nSpins);

    for (let e of cluster) {
      members[e] = 1;
    }

    return members;
  }

  /**
   * Generate a spectrum from an array of singals
   * @param {array} signals
   * @param {object} [options={}]
   * @param {number} [options.frequency=400] Frequency (in MHz) of the simulated spectrum
   * @param {number} [options.maxValue=1e8] Default height of the simulated spectrum
   * @param {number} [options.maxClusterSize=8] Maximal size of a cluster before dividing the problem. Smaller value increase the speed but reduce the quality
   * @param {object} [options.shape] Shape of the peaks, by default gaussian shape
   * @returns  {object} an object of the kind {x:[], y:[]}
   */

  function signalsToXY(signals, options = {}) {
    let {
      frequency = 400,
      shape = {
        kind: 'gaussian',
        options: {
          from: 0,
          to: 10,
          nbPoints: 16 * 1024
        }
      },
      maxValue = 1e8,
      maxClusterSize = 8
    } = options;
    let spinSystem = signalsToSpinSystem(signals);
    spinSystem.clusters = splitSpinSystem(spinSystem, {
      frequency,
      maxClusterSize
    });
    let spectrum = simulate1D(spinSystem, {
      frequency,
      shape
    });

    if (maxValue) {
      spectrum.y = rescale(spectrum.y, {
        max: maxValue
      });
    }

    return spectrum;
  }

  const couplingPatterns = ['s', 'd', 't', 'q', 'quint', 'h', 'sept', 'o', 'n'];

  const couplingValues = {
    s: 0,
    d: 1,
    t: 2,
    q: 3,
    quint: 4,
    h: 5,
    hex: 5,
    hept: 6,
    sept: 6,
    oct: 7,
    o: 7,
    non: 8,
    n: 8
  };

  /**
   *
   * @param {array<string>} patterns
   * @returns
   */

  function joinPatterns(patterns) {
    let sum = 0;

    for (let pattern of patterns) {
      if (couplingValues[pattern] !== undefined) {
        sum += couplingValues[pattern];
      } else {
        throw new Error(`Unknown multiplicity: ${pattern}`);
      }
    }

    return couplingPatterns[sum];
  }

  /**
   * Ensure that assignment and diaID are arrays and coupling are sorted
   * @param {object} signal
   * @returns signal
   */
  function signalNormalize(signal) {
    signal = JSON.parse(JSON.stringify(signal));

    if (signal.assignment && !Array.isArray(signal.assignment)) {
      signal.assignment = [signal.assignment];
    }

    if (signal.diaID && !Array.isArray(signal.diaID)) {
      signal.diaID = [signal.diaID];
    }

    if (signal.j) {
      let couplings = signal.j;

      for (let coupling of couplings) {
        if (coupling.assignment && !Array.isArray(coupling.assignment)) {
          coupling.assignment = [coupling.assignment];
        }

        if (coupling.diaID && !Array.isArray(coupling.diaID)) {
          coupling.diaID = [coupling.diaID];
        }
      }

      signal.j = signal.j.sort((a, b) => b.coupling - a.coupling);
    }

    return signal;
  }

  /**
   * Join couplings smaller than a define tolerance.
   * The resulting coupling should be an average of the existing one.
   * This function will also ensure that assignment and diaID are arrays.
   * If distance is specified and is not always the same this property will be removed.
   * @param {object} signal
   * @param {object} [options={}]
   * @param {number} [options.tolerance=0.05] tolerance to merge the couplings
   * @returns signal
   */

  function signalJoinCouplings(signal, options = {}) {
    const {
      tolerance = 0.05
    } = options;
    signal = signalNormalize(signal);
    if (!signal.j || signal.j.length < 2) return signal; // we group the couplings that are less than the expected tolerance

    let currentGroup = [signal.j[0]];
    let groups = [currentGroup];

    for (let i = 1; i < signal.j.length; i++) {
      let currentJ = signal.j[i];

      if (currentGroup[currentGroup.length - 1].coupling - currentJ.coupling < tolerance) {
        currentGroup.push(currentJ);
      } else {
        currentGroup = [currentJ];
        groups.push(currentGroup);
      }
    }

    signal.j = [];

    for (let group of groups) {
      let coupling = sum(group.map(group => group.coupling)) / group.length;
      let assignment = distinctValues(group.filter(group => group.assignment && group.assignment.length > 0).map(group => group.assignment).flat());
      let diaID = distinctValues(group.filter(group => group.diaID && group.diaID.length > 0).map(group => group.diaID).flat());
      let distances = distinctValues(group.map(group => group.distance));
      let multiplicity = joinPatterns(group.map(group => group.multiplicity));
      let newJ = {
        coupling,
        multiplicity
      };
      if (diaID.length > 0) newJ.diaID = diaID;
      if (distances.length === 1 && distances[0]) newJ.distance = distances[0];
      if (assignment.length > 0) newJ.assignment = assignment;
      signal.j.push(newJ);
    }

    return signal;
  }

  function distinctValues(array) {
    return [...new Set(array)];
  }

  /**
   * Return
   * @param {*} signal
   */
  function signalMultiplicityPattern(signal) {
    let js = signal.j;
    let pattern = '';

    if (js && js.length > 0) {
      for (let coupling of js) {
        pattern += coupling.multiplicity;
      }
    } else if (signal.delta) {
      pattern = 's';
    } else {
      pattern = 'm';
    }

    return pattern;
  }

  const globalOptions = {
    h: {
      nucleus: '1H',
      nbDecimalDelta: 2,
      nbDecimalJ: 1,
      observedFrequency: 400
    },
    c: {
      nucleus: '13C',
      nbDecimalDelta: 1,
      nbDecimalJ: 1,
      observedFrequency: 100
    },
    f: {
      nucleus: '19F',
      nbDecimalDelta: 2,
      nbDecimalJ: 1,
      observedFrequency: 400
    }
  };
  /**
   *
   * @param {array} ranges
   * @param {object} [options={}]
   * @param {boolean} [options.filter=true] remove annotated signals as solvent and impurities
   * @param {number} [options.nucleus]
   * @param {number} [options.nbDecimalDelta] default value depends of nucleus
   * @param {number} [options.nbDecimalJ] default value depends of nucleus
   * @param {number} [options.observedFrequency] default value depends of nucleus 1H: 400MHz
   */

  function rangesToACS(ranges, options = {}) {
    if (!options.nucleus) options.nucleus = '1H';
    let nucleus = options.nucleus.toLowerCase().replace(/[0-9]/g, '');
    let defaultOptions = globalOptions[nucleus];
    options = Object.assign({}, defaultOptions, {
      ascending: false,
      format: 'IMJA'
    }, options);
    ranges = JSON.parse(JSON.stringify(ranges));

    if (options.ascending === true) {
      ranges.sort((a, b) => {
        let fromA = Math.min(a.from, a.to);
        let fromB = Math.min(b.from, b.to);
        return fromA - fromB;
      });
    }

    let acsString = formatAcs(ranges, options);
    if (acsString.length > 0) acsString += '.';
    return acsString;
  }

  function formatAcs(ranges, options) {
    let acs = spectroInformation(options);
    if (acs.length === 0) acs = 'δ ';
    let acsRanges = [];

    for (let range of ranges) {
      if (uselessKind(range.kind, options.filter)) continue;
      pushDelta(range, acsRanges, options);
    }

    if (acsRanges.length > 0) {
      return acs + acsRanges.join(', ');
    } else {
      return '';
    }
  }

  function spectroInformation(options) {
    let parenthesis = [];
    let strings = `${formatNucleus(options.nucleus)} NMR`;

    if (options.solvent) {
      parenthesis.push(formatMF(options.solvent));
    }

    if (options.frequencyObserved) {
      parenthesis.push(`${(options.frequencyObserved * 1).toFixed(0)} MHz`);
    }

    if (parenthesis.length > 0) {
      strings += ` (${parenthesis.join(', ')}): δ `;
    } else {
      strings += ': δ ';
    }

    return strings;
  }

  function pushDelta(range, acsRanges, options) {
    let strings = '';
    let parenthesis = [];
    let fromTo = [range.from, range.to];

    if (Array.isArray(range.signal)) {
      range.signal = range.signal.filter(signal => !uselessKind(signal.kind, options.filter));
    }

    if (Array.isArray(range.signal) && range.signal.length > 0) {
      let signals = range.signal;

      if (signals.length > 1) {
        if (options.ascending === true) {
          signals.sort((a, b) => {
            return a.delta - b.delta;
          });
        }

        strings += `${Math.min(...fromTo).toFixed(options.nbDecimalDelta)}-${Math.max(...fromTo).toFixed(options.nbDecimalDelta)}`;
        strings += ` (${getIntegral(range, options)}`;

        for (let signal of signals) {
          parenthesis = [];

          if (signal.delta !== undefined) {
            strings = appendSeparator(strings);
            strings += signal.delta.toFixed(options.nbDecimalDelta);
          }

          switchFormat({}, signal, parenthesis, options);
          if (parenthesis.length > 0) strings += ` (${parenthesis.join(', ')})`;
        }

        strings += ')';
      } else {
        parenthesis = [];

        if (signals[0].delta !== undefined) {
          strings += signals[0].delta.toFixed(options.nbDecimalDelta);
          switchFormat(range, signals[0], parenthesis, options);
          if (parenthesis.length > 0) strings += ` (${parenthesis.join(', ')})`;
        } else {
          strings += `${Math.min(...fromTo).toFixed(options.nbDecimalDelta)}-${Math.max(...fromTo).toFixed(options.nbDecimalDelta)}`;
          switchFormat(range, signals[0], parenthesis, options);
          if (parenthesis.length > 0) strings += ` (${parenthesis})`;
        }
      }
    } else {
      strings += `${Math.min(...fromTo).toFixed(options.nbDecimalDelta)}-${Math.max(...fromTo).toFixed(options.nbDecimalDelta)}`;
      switchFormat(range, [], parenthesis, options);
      if (parenthesis.length > 0) strings += ` (${parenthesis.join(', ')})`;
    }

    acsRanges.push(strings);
  }

  function getIntegral(range, options) {
    let integral = '';

    if (range.pubIntegral) {
      integral = range.pubIntegral;
    } else if (range.integral) {
      integral = range.integral.toFixed(0) + options.nucleus[options.nucleus.length - 1];
    }

    return integral;
  }

  function pushIntegral(range, parenthesis, options) {
    let integral = getIntegral(range, options);
    if (integral.length > 0) parenthesis.push(integral);
  }

  function pushMultiplicityFromSignal(signal, parenthesis) {
    let multiplicity = signal.multiplicity;

    if (!multiplicity) {
      let joinedCouplings = signalJoinCouplings(signal, {
        tolerance: 0.05
      });
      multiplicity = signalMultiplicityPattern(joinedCouplings);
    }

    if (multiplicity.length > 0) parenthesis.push(multiplicity);
  }

  function switchFormat(range, signal, parenthesis, options) {
    for (const char of options.format) {
      switch (char.toUpperCase()) {
        case 'I':
          pushIntegral(range, parenthesis, options);
          break;

        case 'M':
          pushMultiplicityFromSignal(signal, parenthesis);
          break;

        case 'A':
          pushAssignment(signal, parenthesis);
          break;

        case 'J':
          pushCoupling(signal, parenthesis, options);
          break;

        default:
          throw new Error(`Unknow format letter: ${char}`);
      }
    }
  }

  function formatMF(mf) {
    return mf.replace(/(?<num>[0-9]+)/g, '<sub>$<num></sub>');
  }

  function formatNucleus(nucleus) {
    return nucleus.replace(/(?<num>[0-9]+)/g, '<sup>$<num></sup>');
  }

  function appendSeparator(strings) {
    if (strings.length > 0 && !strings.match(/ $/) && !strings.match(/\($/)) {
      strings += ', ';
    }

    return strings;
  }

  function formatAssignment(assignment) {
    assignment = assignment.replace(/(?<num>[0-9]+)/g, '<sub>$<num></sub>');
    assignment = assignment.replace(/"(?<i>[^"]*)"/g, '<i>$<i></i>');
    return assignment;
  }

  function pushCoupling(signal, parenthesis, options) {
    if (Array.isArray(signal.j) && signal.j.length > 0) {
      signal.j.sort(function (a, b) {
        return b.coupling - a.coupling;
      });
      let values = [];

      for (let j of signal.j) {
        if (j.coupling !== undefined) {
          values.push(j.coupling.toFixed(options.nbDecimalJ));
        }
      }

      if (values.length > 0) {
        parenthesis.push(`<i>J</i> = ${values.join(', ')} Hz`);
      }
    }
  }

  function pushAssignment(signal, parenthesis) {
    if (signal.pubAssignment) {
      parenthesis.push(formatAssignment(signal.pubAssignment));
    } else if (signal.assignment) {
      parenthesis.push(formatAssignment(signal.assignment));
    }
  }

  function uselessKind(kind = '', filter = true) {
    kind = kind.toLowerCase();
    if (filter && (kind === 'impurity' || kind === 'solvent')) return true;
    return false;
  }

  var browserPonyfill = {exports: {}};

  (function (module, exports) {
    var global = typeof self !== 'undefined' ? self : commonjsGlobal;

    var __self__ = function () {
      function F() {
        this.fetch = false;
        this.DOMException = global.DOMException;
      }

      F.prototype = global;
      return new F();
    }();

    (function (self) {
      (function (exports) {
        var support = {
          searchParams: 'URLSearchParams' in self,
          iterable: 'Symbol' in self && 'iterator' in Symbol,
          blob: 'FileReader' in self && 'Blob' in self && function () {
            try {
              new Blob();
              return true;
            } catch (e) {
              return false;
            }
          }(),
          formData: 'FormData' in self,
          arrayBuffer: 'ArrayBuffer' in self
        };

        function isDataView(obj) {
          return obj && DataView.prototype.isPrototypeOf(obj);
        }

        if (support.arrayBuffer) {
          var viewClasses = ['[object Int8Array]', '[object Uint8Array]', '[object Uint8ClampedArray]', '[object Int16Array]', '[object Uint16Array]', '[object Int32Array]', '[object Uint32Array]', '[object Float32Array]', '[object Float64Array]'];

          var isArrayBufferView = ArrayBuffer.isView || function (obj) {
            return obj && viewClasses.indexOf(Object.prototype.toString.call(obj)) > -1;
          };
        }

        function normalizeName(name) {
          if (typeof name !== 'string') {
            name = String(name);
          }

          if (/[^a-z0-9\-#$%&'*+.^_`|~]/i.test(name)) {
            throw new TypeError('Invalid character in header field name');
          }

          return name.toLowerCase();
        }

        function normalizeValue(value) {
          if (typeof value !== 'string') {
            value = String(value);
          }

          return value;
        } // Build a destructive iterator for the value list


        function iteratorFor(items) {
          var iterator = {
            next: function () {
              var value = items.shift();
              return {
                done: value === undefined,
                value: value
              };
            }
          };

          if (support.iterable) {
            iterator[Symbol.iterator] = function () {
              return iterator;
            };
          }

          return iterator;
        }

        function Headers(headers) {
          this.map = {};

          if (headers instanceof Headers) {
            headers.forEach(function (value, name) {
              this.append(name, value);
            }, this);
          } else if (Array.isArray(headers)) {
            headers.forEach(function (header) {
              this.append(header[0], header[1]);
            }, this);
          } else if (headers) {
            Object.getOwnPropertyNames(headers).forEach(function (name) {
              this.append(name, headers[name]);
            }, this);
          }
        }

        Headers.prototype.append = function (name, value) {
          name = normalizeName(name);
          value = normalizeValue(value);
          var oldValue = this.map[name];
          this.map[name] = oldValue ? oldValue + ', ' + value : value;
        };

        Headers.prototype['delete'] = function (name) {
          delete this.map[normalizeName(name)];
        };

        Headers.prototype.get = function (name) {
          name = normalizeName(name);
          return this.has(name) ? this.map[name] : null;
        };

        Headers.prototype.has = function (name) {
          return this.map.hasOwnProperty(normalizeName(name));
        };

        Headers.prototype.set = function (name, value) {
          this.map[normalizeName(name)] = normalizeValue(value);
        };

        Headers.prototype.forEach = function (callback, thisArg) {
          for (var name in this.map) {
            if (this.map.hasOwnProperty(name)) {
              callback.call(thisArg, this.map[name], name, this);
            }
          }
        };

        Headers.prototype.keys = function () {
          var items = [];
          this.forEach(function (value, name) {
            items.push(name);
          });
          return iteratorFor(items);
        };

        Headers.prototype.values = function () {
          var items = [];
          this.forEach(function (value) {
            items.push(value);
          });
          return iteratorFor(items);
        };

        Headers.prototype.entries = function () {
          var items = [];
          this.forEach(function (value, name) {
            items.push([name, value]);
          });
          return iteratorFor(items);
        };

        if (support.iterable) {
          Headers.prototype[Symbol.iterator] = Headers.prototype.entries;
        }

        function consumed(body) {
          if (body.bodyUsed) {
            return Promise.reject(new TypeError('Already read'));
          }

          body.bodyUsed = true;
        }

        function fileReaderReady(reader) {
          return new Promise(function (resolve, reject) {
            reader.onload = function () {
              resolve(reader.result);
            };

            reader.onerror = function () {
              reject(reader.error);
            };
          });
        }

        function readBlobAsArrayBuffer(blob) {
          var reader = new FileReader();
          var promise = fileReaderReady(reader);
          reader.readAsArrayBuffer(blob);
          return promise;
        }

        function readBlobAsText(blob) {
          var reader = new FileReader();
          var promise = fileReaderReady(reader);
          reader.readAsText(blob);
          return promise;
        }

        function readArrayBufferAsText(buf) {
          var view = new Uint8Array(buf);
          var chars = new Array(view.length);

          for (var i = 0; i < view.length; i++) {
            chars[i] = String.fromCharCode(view[i]);
          }

          return chars.join('');
        }

        function bufferClone(buf) {
          if (buf.slice) {
            return buf.slice(0);
          } else {
            var view = new Uint8Array(buf.byteLength);
            view.set(new Uint8Array(buf));
            return view.buffer;
          }
        }

        function Body() {
          this.bodyUsed = false;

          this._initBody = function (body) {
            this._bodyInit = body;

            if (!body) {
              this._bodyText = '';
            } else if (typeof body === 'string') {
              this._bodyText = body;
            } else if (support.blob && Blob.prototype.isPrototypeOf(body)) {
              this._bodyBlob = body;
            } else if (support.formData && FormData.prototype.isPrototypeOf(body)) {
              this._bodyFormData = body;
            } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
              this._bodyText = body.toString();
            } else if (support.arrayBuffer && support.blob && isDataView(body)) {
              this._bodyArrayBuffer = bufferClone(body.buffer); // IE 10-11 can't handle a DataView body.

              this._bodyInit = new Blob([this._bodyArrayBuffer]);
            } else if (support.arrayBuffer && (ArrayBuffer.prototype.isPrototypeOf(body) || isArrayBufferView(body))) {
              this._bodyArrayBuffer = bufferClone(body);
            } else {
              this._bodyText = body = Object.prototype.toString.call(body);
            }

            if (!this.headers.get('content-type')) {
              if (typeof body === 'string') {
                this.headers.set('content-type', 'text/plain;charset=UTF-8');
              } else if (this._bodyBlob && this._bodyBlob.type) {
                this.headers.set('content-type', this._bodyBlob.type);
              } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
                this.headers.set('content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
              }
            }
          };

          if (support.blob) {
            this.blob = function () {
              var rejected = consumed(this);

              if (rejected) {
                return rejected;
              }

              if (this._bodyBlob) {
                return Promise.resolve(this._bodyBlob);
              } else if (this._bodyArrayBuffer) {
                return Promise.resolve(new Blob([this._bodyArrayBuffer]));
              } else if (this._bodyFormData) {
                throw new Error('could not read FormData body as blob');
              } else {
                return Promise.resolve(new Blob([this._bodyText]));
              }
            };

            this.arrayBuffer = function () {
              if (this._bodyArrayBuffer) {
                return consumed(this) || Promise.resolve(this._bodyArrayBuffer);
              } else {
                return this.blob().then(readBlobAsArrayBuffer);
              }
            };
          }

          this.text = function () {
            var rejected = consumed(this);

            if (rejected) {
              return rejected;
            }

            if (this._bodyBlob) {
              return readBlobAsText(this._bodyBlob);
            } else if (this._bodyArrayBuffer) {
              return Promise.resolve(readArrayBufferAsText(this._bodyArrayBuffer));
            } else if (this._bodyFormData) {
              throw new Error('could not read FormData body as text');
            } else {
              return Promise.resolve(this._bodyText);
            }
          };

          if (support.formData) {
            this.formData = function () {
              return this.text().then(decode);
            };
          }

          this.json = function () {
            return this.text().then(JSON.parse);
          };

          return this;
        } // HTTP methods whose capitalization should be normalized


        var methods = ['DELETE', 'GET', 'HEAD', 'OPTIONS', 'POST', 'PUT'];

        function normalizeMethod(method) {
          var upcased = method.toUpperCase();
          return methods.indexOf(upcased) > -1 ? upcased : method;
        }

        function Request(input, options) {
          options = options || {};
          var body = options.body;

          if (input instanceof Request) {
            if (input.bodyUsed) {
              throw new TypeError('Already read');
            }

            this.url = input.url;
            this.credentials = input.credentials;

            if (!options.headers) {
              this.headers = new Headers(input.headers);
            }

            this.method = input.method;
            this.mode = input.mode;
            this.signal = input.signal;

            if (!body && input._bodyInit != null) {
              body = input._bodyInit;
              input.bodyUsed = true;
            }
          } else {
            this.url = String(input);
          }

          this.credentials = options.credentials || this.credentials || 'same-origin';

          if (options.headers || !this.headers) {
            this.headers = new Headers(options.headers);
          }

          this.method = normalizeMethod(options.method || this.method || 'GET');
          this.mode = options.mode || this.mode || null;
          this.signal = options.signal || this.signal;
          this.referrer = null;

          if ((this.method === 'GET' || this.method === 'HEAD') && body) {
            throw new TypeError('Body not allowed for GET or HEAD requests');
          }

          this._initBody(body);
        }

        Request.prototype.clone = function () {
          return new Request(this, {
            body: this._bodyInit
          });
        };

        function decode(body) {
          var form = new FormData();
          body.trim().split('&').forEach(function (bytes) {
            if (bytes) {
              var split = bytes.split('=');
              var name = split.shift().replace(/\+/g, ' ');
              var value = split.join('=').replace(/\+/g, ' ');
              form.append(decodeURIComponent(name), decodeURIComponent(value));
            }
          });
          return form;
        }

        function parseHeaders(rawHeaders) {
          var headers = new Headers(); // Replace instances of \r\n and \n followed by at least one space or horizontal tab with a space
          // https://tools.ietf.org/html/rfc7230#section-3.2

          var preProcessedHeaders = rawHeaders.replace(/\r?\n[\t ]+/g, ' ');
          preProcessedHeaders.split(/\r?\n/).forEach(function (line) {
            var parts = line.split(':');
            var key = parts.shift().trim();

            if (key) {
              var value = parts.join(':').trim();
              headers.append(key, value);
            }
          });
          return headers;
        }

        Body.call(Request.prototype);

        function Response(bodyInit, options) {
          if (!options) {
            options = {};
          }

          this.type = 'default';
          this.status = options.status === undefined ? 200 : options.status;
          this.ok = this.status >= 200 && this.status < 300;
          this.statusText = 'statusText' in options ? options.statusText : 'OK';
          this.headers = new Headers(options.headers);
          this.url = options.url || '';

          this._initBody(bodyInit);
        }

        Body.call(Response.prototype);

        Response.prototype.clone = function () {
          return new Response(this._bodyInit, {
            status: this.status,
            statusText: this.statusText,
            headers: new Headers(this.headers),
            url: this.url
          });
        };

        Response.error = function () {
          var response = new Response(null, {
            status: 0,
            statusText: ''
          });
          response.type = 'error';
          return response;
        };

        var redirectStatuses = [301, 302, 303, 307, 308];

        Response.redirect = function (url, status) {
          if (redirectStatuses.indexOf(status) === -1) {
            throw new RangeError('Invalid status code');
          }

          return new Response(null, {
            status: status,
            headers: {
              location: url
            }
          });
        };

        exports.DOMException = self.DOMException;

        try {
          new exports.DOMException();
        } catch (err) {
          exports.DOMException = function (message, name) {
            this.message = message;
            this.name = name;
            var error = Error(message);
            this.stack = error.stack;
          };

          exports.DOMException.prototype = Object.create(Error.prototype);
          exports.DOMException.prototype.constructor = exports.DOMException;
        }

        function fetch(input, init) {
          return new Promise(function (resolve, reject) {
            var request = new Request(input, init);

            if (request.signal && request.signal.aborted) {
              return reject(new exports.DOMException('Aborted', 'AbortError'));
            }

            var xhr = new XMLHttpRequest();

            function abortXhr() {
              xhr.abort();
            }

            xhr.onload = function () {
              var options = {
                status: xhr.status,
                statusText: xhr.statusText,
                headers: parseHeaders(xhr.getAllResponseHeaders() || '')
              };
              options.url = 'responseURL' in xhr ? xhr.responseURL : options.headers.get('X-Request-URL');
              var body = 'response' in xhr ? xhr.response : xhr.responseText;
              resolve(new Response(body, options));
            };

            xhr.onerror = function () {
              reject(new TypeError('Network request failed'));
            };

            xhr.ontimeout = function () {
              reject(new TypeError('Network request failed'));
            };

            xhr.onabort = function () {
              reject(new exports.DOMException('Aborted', 'AbortError'));
            };

            xhr.open(request.method, request.url, true);

            if (request.credentials === 'include') {
              xhr.withCredentials = true;
            } else if (request.credentials === 'omit') {
              xhr.withCredentials = false;
            }

            if ('responseType' in xhr && support.blob) {
              xhr.responseType = 'blob';
            }

            request.headers.forEach(function (value, name) {
              xhr.setRequestHeader(name, value);
            });

            if (request.signal) {
              request.signal.addEventListener('abort', abortXhr);

              xhr.onreadystatechange = function () {
                // DONE (success or failure)
                if (xhr.readyState === 4) {
                  request.signal.removeEventListener('abort', abortXhr);
                }
              };
            }

            xhr.send(typeof request._bodyInit === 'undefined' ? null : request._bodyInit);
          });
        }

        fetch.polyfill = true;

        if (!self.fetch) {
          self.fetch = fetch;
          self.Headers = Headers;
          self.Request = Request;
          self.Response = Response;
        }

        exports.Headers = Headers;
        exports.Request = Request;
        exports.Response = Response;
        exports.fetch = fetch;
        Object.defineProperty(exports, '__esModule', {
          value: true
        });
        return exports;
      })({});
    })(__self__);

    __self__.fetch.ponyfill = true; // Remove "polyfill" property added by whatwg-fetch

    delete __self__.fetch.polyfill; // Choose between native implementation (global) or custom implementation (__self__)
    // var ctx = global.fetch ? global : __self__;

    var ctx = __self__; // this line disable service worker support temporarily

    exports = ctx.fetch; // To enable: import fetch from 'cross-fetch'

    exports.default = ctx.fetch; // For TypeScript consumers without esModuleInterop.

    exports.fetch = ctx.fetch; // To enable: import {fetch} from 'cross-fetch'

    exports.Headers = ctx.Headers;
    exports.Request = ctx.Request;
    exports.Response = ctx.Response;
    module.exports = exports;
  })(browserPonyfill, browserPonyfill.exports);

  var fetch = /*@__PURE__*/getDefaultExportFromCjs(browserPonyfill.exports);

  /* eslint-env browser */
  var browser = typeof self == 'object' ? self.FormData : window.FormData;

  let xAtomicNumber = 0;
  /**
   * Tag an atom to be able to visualize it
   * @param {OCL.Molecule} molecule
   * @param {number} iAtom
   */

  function tagAtom(molecule, iAtom) {
    let customLabel = `${molecule.getAtomLabel(iAtom)}*`;
    molecule.setAtomCustomLabel(iAtom, customLabel);

    if (molecule.getAtomicNo(iAtom) === 1) {
      molecule.setAtomicNo(iAtom, getXAtomicNumber(molecule));
    } else {
      // we can not use X because we would have problems with valencies if it is
      // expanded hydrogens or not
      // we can not only use a custom label because it does not count for the canonisation
      molecule.setAtomMass(iAtom, molecule.getAtomMass(iAtom) + 5);
    }

    return customLabel;
  }

  function getXAtomicNumber(molecule) {
    if (!xAtomicNumber) {
      const OCL = molecule.getOCL();
      xAtomicNumber = OCL.Molecule.getAtomicNoFromLabel('X');
    }

    return xAtomicNumber;
  }

  /**
   * Add either missing chirality of diastereotopic missing chirality
   * The problem is that sometimes we need to add chiral bond that was not planned because it is the same group
   * This is the case for example for the valine where the 2 C of the methyl groups are diastereotopic
   * @param {OCL.Molecule} molecule
   * @param {object} [options={}]
   * @param {number} [options.esrType=cESRTypeAnd]
   */

  function addDiastereotopicMissingChirality(molecule, options = {}) {
    const {
      Molecule
    } = molecule.getOCL();
    const {
      esrType = Molecule.cESRTypeAnd
    } = options;

    for (let iAtom = 0; iAtom < molecule.getAllAtoms(); iAtom++) {
      let tempMolecule = molecule.getCompactCopy();
      tagAtom(tempMolecule, iAtom); // After copy, helpers must be recalculated

      tempMolecule.ensureHelperArrays(Molecule.cHelperBitsStereo); // We need to have >0 and not >1 because there could be unspecified chirality in racemate

      for (let i = 0; i < tempMolecule.getAtoms(); i++) {
        // changed from from handling below; TLS 9.Nov.2015
        if (tempMolecule.isAtomStereoCenter(i) && tempMolecule.getStereoBond(i) === -1) {
          let stereoBond = tempMolecule.getAtomPreferredStereoBond(i);

          if (stereoBond !== -1) {
            molecule.setBondType(stereoBond, Molecule.cBondTypeUp);

            if (molecule.getBondAtom(1, stereoBond) === i) {
              let connAtom = molecule.getBondAtom(0, stereoBond);
              molecule.setBondAtom(0, stereoBond, i);
              molecule.setBondAtom(1, stereoBond, connAtom);
            } // To me it seems that we have to add all stereo centers into AND group 0. TLS 9.Nov.2015


            molecule.setAtomESR(i, esrType, 0);
          }
        }
      }
    }
  }

  /**
   *
   * @param {OCL.Molecule} [molecule] An instance of a molecule
   * @param {object} [options={}]
   * @param {object} [options.OCL] openchemlib library
   */
  function makeRacemic(molecule) {
    const {
      Molecule
    } = molecule.getOCL(); // if we don't calculate this we have 2 epimers

    molecule.ensureHelperArrays(Molecule.cHelperCIP); // we need to make one group "AND" for chiral (to force to racemic, this means diastereotopic and not enantiotopic)

    for (let i = 0; i < molecule.getAllAtoms(); i++) {
      if (molecule.getAtomParity(i) !== Molecule.cAtomParityNone) {
        molecule.setAtomESR(i, Molecule.cESRTypeAnd, 0); // changed to group 0; TLS 9.Nov.2015
      }
    }
  }

  /**
   * Returns an array of diastereotopic ID (as oclCode)
   * @param {OCL.Molecule} molecule
   */

  function getDiastereotopicAtomIDs(molecule) {
    const OCL = molecule.getOCL();
    addDiastereotopicMissingChirality(molecule);
    let numberAtoms = molecule.getAllAtoms();
    let ids = [];

    for (let iAtom = 0; iAtom < numberAtoms; iAtom++) {
      let tempMolecule = molecule.getCompactCopy();
      tagAtom(tempMolecule, iAtom);
      makeRacemic(tempMolecule); // We need to ensure the helper array in order to get correctly the result of racemisation

      ids[iAtom] = tempMolecule.getCanonizedIDCode(OCL.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS);
    }

    return ids;
  }

  /**
   * This function groups the diasterotopic atomIds of the molecule based on equivalence of atoms. The output object contains
   * a set of chemically equivalent atoms(element.atoms) and the groups of magnetically equivalent atoms (element.magneticGroups)
   * @param {OCL.Molecule} molecule
   * @param {object} [options={}]
   * @param {string} [options.atomLabel] Select atoms of the given atomLabel. By default it returns all the explicit atoms in the molecule
   * @returns {Array}
   */

  function getGroupedDiastereotopicAtomIDs(molecule, options = {}) {
    const {
      atomLabel
    } = options;
    let diaIDs = getDiastereotopicAtomIDs(molecule);
    let diaIDsObject = {};

    for (let i = 0; i < diaIDs.length; i++) {
      if (!atomLabel || molecule.getAtomLabel(i) === atomLabel) {
        let diaID = diaIDs[i];

        if (!diaIDsObject[diaID]) {
          diaIDsObject[diaID] = {
            counter: 0,
            atoms: [],
            oclID: diaID,
            atomLabel: molecule.getAtomLabel(i)
          };
        }

        diaIDsObject[diaID].counter++;
        diaIDsObject[diaID].atoms.push(i);
      }
    }

    return Object.keys(diaIDsObject).map(key => diaIDsObject[key]);
  }

  /**
   * Check if a specific atom is a sp3 carbon
   * @param {OCL.Molecule} molecule
   * @param {number} atomID
   */
  function isCsp3(molecule, atomID) {
    if (molecule.getAtomicNo(atomID) !== 6) return false;
    if (molecule.getAtomCharge(atomID) !== 0) return false;

    if (molecule.getImplicitHydrogens(atomID) + molecule.getConnAtoms(atomID) !== 4) {
      return false;
    }

    return true;
  }

  const FULL_HOSE_CODE = 1;
  const HOSE_CODE_CUT_C_SP3_SP3 = 2;
  /**
   * Returns the hose code for a specific atom number
   * @param {OCL.Molecule} originalMolecule
   * @param {number} rootAtom
   * @param {object} [options={}]
   * @param {boolean} [options.isTagged] Specify is the atom is already tagged
   */

  function getHoseCodesForAtom(originalMolecule, rootAtom, options = {}) {
    const OCL = originalMolecule.getOCL();
    const {
      minSphereSize = 0,
      maxSphereSize = 4,
      kind = FULL_HOSE_CODE,
      isTagged = false
    } = options;
    const molecule = originalMolecule.getCompactCopy();

    if (!isTagged) {
      let tag = tagAtom(molecule, rootAtom);
      molecule.addImplicitHydrogens();
      molecule.addMissingChirality();
      molecule.ensureHelperArrays(OCL.Molecule.cHelperNeighbours); // because ensuring helper reorder atoms we need to look again for it

      for (let i = 0; i < molecule.getAllAtoms(); i++) {
        if (tag === molecule.getAtomCustomLabel(i)) {
          rootAtom = i;
          break;
        }
      }
    }

    let fragment = new OCL.Molecule(0, 0);
    let results = [];
    let min = 0;
    let max = 0;
    let atomMask = new Array(molecule.getAllAtoms());
    let atomList = new Array(molecule.getAllAtoms());

    for (let sphere = 0; sphere <= maxSphereSize; sphere++) {
      if (max === 0) {
        atomList[0] = rootAtom;
        atomMask[rootAtom] = true;
        max = 1;
      } else {
        let newMax = max;

        for (let i = min; i < max; i++) {
          let atom = atomList[i];

          for (let j = 0; j < molecule.getAllConnAtoms(atom); j++) {
            let connAtom = molecule.getConnAtom(atom, j);

            if (!atomMask[connAtom]) {
              switch (kind) {
                case FULL_HOSE_CODE:
                  atomMask[connAtom] = true;
                  atomList[newMax++] = connAtom;
                  break;

                case HOSE_CODE_CUT_C_SP3_SP3:
                  if (!(isCsp3(molecule, atom) && isCsp3(molecule, connAtom))) {
                    atomMask[connAtom] = true;
                    atomList[newMax++] = connAtom;
                  }

                  break;

                default:
                  throw new Error('getHoseCoesForAtom unknown kind');
              }
            }
          }
        }

        min = max;
        max = newMax;
      }

      molecule.copyMoleculeByAtoms(fragment, atomMask, true, null);

      if (sphere >= minSphereSize) {
        makeRacemic(fragment);
        results.push(fragment.getCanonizedIDCode(OCL.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS));
      }
    }

    return results;
  }

  /**
   * Returns the hose code for a specific marked atom
   * @param {OCL.Molecule} diastereotopicID
   * @param {object} options
   */

  function getHoseCodesFromDiastereotopicID(molecule, options = {}) {
    molecule.addImplicitHydrogens();
    molecule.addMissingChirality(); // One of the atom has to be marked !

    let atomID = -1;

    for (let i = 0; i < molecule.getAllAtoms(); i++) {
      // we need to find the marked atom
      const atomCustomLabel = molecule.getAtomCustomLabel(i);

      if (atomCustomLabel != null && atomCustomLabel.endsWith('*')) {
        atomID = i;
        break;
      }
    }

    if (atomID >= 0) {
      options.isTagged = true;
      return getHoseCodesForAtom(molecule, atomID, options);
    }

    return undefined;
  }

  /**
   * Algorithm that finds the shortest distance from one node to the other
   * @param {Matrix} adjMatrix - A squared adjacency matrix
   * @return {Matrix} - Distance from a node to the other, -1 if the node is unreachable
   */

  function floydWarshall(adjMatrix) {
    if (Matrix.isMatrix(adjMatrix) && adjMatrix.columns !== adjMatrix.rows) {
      throw new TypeError('The adjacency matrix should be squared');
    }

    const numVertices = adjMatrix.columns;
    let distMatrix = new Matrix(numVertices, numVertices);
    distMatrix.apply((row, column) => {
      // principal diagonal is 0
      if (row === column) {
        distMatrix.set(row, column, 0);
      } else {
        let val = adjMatrix.get(row, column);

        if (val) {
          // edges values remain the same
          distMatrix.set(row, column, val);
        } else {
          // 0 values become infinity
          distMatrix.set(row, column, Number.POSITIVE_INFINITY);
        }
      }
    });

    for (let k = 0; k < numVertices; ++k) {
      for (let i = 0; i < numVertices; ++i) {
        for (let j = 0; j < numVertices; ++j) {
          let dist = distMatrix.get(i, k) + distMatrix.get(k, j);

          if (distMatrix.get(i, j) > dist) {
            distMatrix.set(i, j, dist);
          }
        }
      }
    } // When there's no connection the value is -1


    distMatrix.apply((row, column) => {
      if (distMatrix.get(row, column) === Number.POSITIVE_INFINITY) {
        distMatrix.set(row, column, -1);
      }
    });
    return distMatrix;
  }

  /**
   * Returns a connectivity matrix
   * @param {OCL.Molecule} molecule
   * @param {object} [options={}]
   * @param {boolean} [options.pathLength=false] get the path length between atoms
   * @param {boolean} [options.mass=false] set the nominal mass of the atoms on diagonal
   * @param {boolean} [options.atomicNo=false] set the atomic number of the atom on diagonal
   * @param {boolean} [options.negativeAtomicNo=false] set the atomic number * -1 of the atom on diagonal
   * @param {boolean} [options.sdt=false] set 1, 2 or 3 depending if single, double or triple bond
   * @param {boolean} [options.sdta=false] set 1, 2, 3 or 4 depending if single, double, triple or aromatic  bond
   */

  function getConnectivityMatrix(molecule, options = {}) {
    const OCL = molecule.getOCL();
    molecule.ensureHelperArrays(OCL.Molecule.cHelperNeighbours);
    let nbAtoms = molecule.getAllAtoms();
    let result = new Array(nbAtoms).fill();
    result = result.map(() => new Array(nbAtoms).fill(0));

    if (!options.pathLength) {
      if (options.atomicNo) {
        for (let i = 0; i < nbAtoms; i++) {
          result[i][i] = molecule.getAtomicNo(i);
        }
      } else if (options.negativeAtomicNo) {
        for (let i = 0; i < nbAtoms; i++) {
          result[i][i] = -molecule.getAtomicNo(i);
        }
      } else if (options.mass) {
        for (let i = 0; i < nbAtoms; i++) {
          result[i][i] = OCL.Molecule.cRoundedMass[molecule.getAtomicNo(i)];
        }
      } else {
        for (let i = 0; i < nbAtoms; i++) {
          result[i][i] = 1;
        }
      }
    }

    if (options.sdt) {
      for (let i = 0; i < nbAtoms; i++) {
        let l = molecule.getAllConnAtoms(i);

        for (let j = 0; j < l; j++) {
          result[i][molecule.getConnAtom(i, j)] = molecule.getConnBondOrder(i, j);
        }
      }
    } else if (options.sdta) {
      for (let i = 0; i < nbAtoms; i++) {
        let l = molecule.getAllConnAtoms(i);

        for (let j = 0; j < l; j++) {
          let bondNumber = molecule.getConnBond(i, j);

          if (molecule.isAromaticBond(bondNumber)) {
            result[i][molecule.getConnAtom(i, j)] = 4;
          } else {
            result[i][molecule.getConnAtom(i, j)] = molecule.getConnBondOrder(i, j);
          }
        }
      }
    } else {
      for (let i = 0; i < nbAtoms; i++) {
        let l = molecule.getAllConnAtoms(i);

        for (let j = 0; j < l; j++) {
          result[i][molecule.getConnAtom(i, j)] = 1;
        }
      }
    }

    if (options.pathLength) {
      result = floydWarshall(new Matrix(result)).to2DArray();
    }

    return result;
  }

  /**
   * Join signals if all the same diaID
   * diaID must be present at the level of the signal and the coupling so practically it only applies on simulated data
   */

  function signalsJoin(signals, options = {}) {
    const {
      tolerance = 0.1
    } = options; // diaIDs is mandatory everywhere

    for (let signal of signals) {
      if (!signal.diaID || !signal.diaID.length === 1) return signals;

      for (let coupling of signal.j) {
        if (!coupling.diaID || !coupling.diaID.length === 1 || coupling.multiplicity !== 'd') {
          return signals;
        }
      }
    } // we group them by diaIDs


    const groupedSignals = {};

    for (let signal of signals) {
      signal = signalNormalize(signal); // we have a copy

      signal.j = signal.j.sort((a, b) => a.diaID + a.distance < b.diaID + b.distance ? 1 : -1);
      let id = `${signal.diaID[0]} ${signal.j.map(j => `${j.diaID[0]} ${j.distance}`).sort().join(' ')}`;

      if (!groupedSignals[id]) {
        groupedSignals[id] = [];
      }

      groupedSignals[id].push(signal);
    } // for each group we need to combine assignments and average couplings


    let newSignals = [];

    for (let key in groupedSignals) {
      const group = groupedSignals[key]; // joining couplings only if diaID and distance are equal

      const j = [];

      for (let i = 0; i < group[0].j.length; i++) {
        j.push({
          diaID: group[0].j[i].diaID,
          distance: group[0].j[i].distance,
          multiplicity: group[0].j[i].multiplicity,
          coupling: mean(group.map(item => item.j[i].coupling))
        });
      }

      newSignals.push({
        nbAtoms: sum(group.map(item => item.nbAtoms)),
        delta: mean(group.map(item => item.delta)),
        diaID: group[0].diaID,
        assignment: group.map(item => item.assignment).flat().filter(item => item),
        j
      });
    }

    newSignals = newSignals.map(signal => {
      signal = signalNormalize(signalJoinCouplings(signal, {
        tolerance
      }));

      if (signal.j) {
        signal.multiplicity = signal.j.reduce((multiplicity, jCoupling) => {
          return `${multiplicity}${jCoupling.multiplicity}`;
        }, '');
      }

      return signal;
    }).sort((a, b) => a.delta - b.delta);
    return newSignals;
  }

  /**
   * Makes a prediction using proton.
   * @param {Molecule} molecule - OCL Molecule instance.
   * @param {object} [options={}]
   * @param {function} [options.cache] A callback receiving a molfile and the result
   * @return {Promise<Array>}
   */

  async function predictProton(molecule, options = {}) {
    const {
      cache
    } = options;
    molecule = molecule.getCompactCopy();
    molecule.addImplicitHydrogens();
    addDiastereotopicMissingChirality(molecule);
    const molfile = molecule.toMolfile();
    let result;

    if (cache) {
      result = cache(molfile);
    }

    if (result === undefined) {
      const formData = new browser();
      formData.append('molfile', molfile);
      const response = await fetch('https://www.nmrdb.org/service/predictor', {
        method: 'POST',
        body: formData
      });
      result = await response.text();

      if (cache) {
        cache(molfile, result);
      }
    }

    const diaIDs = getDiastereotopicAtomIDs(molecule);
    const signals = protonParser(result, molecule, diaIDs);
    const joinedSignals = signalsJoin(signals);
    return {
      molfile,
      diaIDs,
      joinedSignals,
      signals,
      ranges: signalsToRanges(joinedSignals)
    };
  }

  function protonParser(result, molecule, diaIDs) {
    let distanceMatrix = getConnectivityMatrix(molecule, {
      pathLength: true
    });
    let lines = result.split('\n').filter(line => line);
    let signals = [];

    for (let line of lines) {
      let fields = line.split('\t');
      let couplings = fields.slice(4);
      let atom = fields[0] - 1;
      let signal = {
        assignment: [atom],
        diaID: [diaIDs[atom]],
        nbAtoms: 1,
        delta: Number(fields[2]),
        j: []
      };

      for (let i = 0; i < couplings.length; i += 3) {
        let linked = Number(couplings[i] - 1);
        signal.j.push({
          coupling: Number(couplings[i + 2]),
          assignment: [linked],
          diaID: [diaIDs[linked]],
          multiplicity: 'd',
          distance: distanceMatrix[atom][linked]
        });
        signal.j.sort((a, b) => b.coupling - a.coupling);
      }

      signals.push(signal);
    }

    return signals;
  }

  var openchemlibMinimal = {};

  (function(exports){(function(root){function getExports($wnd){var $doc=$wnd.document;var $gwt={};var navigator={userAgent:'webkit'};function noop(){}var __gwtModuleFunction=noop;__gwtModuleFunction.__moduleStartupDone=noop;var G_='object',H_='anonymous',I_='fnStack',J_='\n',K_={4:1,10:1,7:1},L_='Unknown',M_='boolean',N_='number',O_='string',P_=2147483647,Q_=-17592186044416,R_=17592186044416,S_=4194304,T_=1048575,U_='__noinit__',V_={4:1,10:1,16:1,7:1},W_={4:1,7:1},X_='null',Y_={4:1,13:1,20:1,17:1},Z_='For input string: "',$_=-2147483648,__={l:0,m:0,h:524288},a0=1048576,b0=4096,c0=16384,d0={4:1,10:1,28:1,16:1,7:1,29:1},e0=65536,f0=65535,g0=10000,h0={37:1,76:1},i0={4:1,37:1,76:1},j0={8:1,4:1},k0={6:1,4:1},l0='fromIndex: 0, toIndex: ',m0=', length: ',n0='Index: ',o0=', Size: ',p0='fromIndex: ',q0=', toIndex: ',r0=16777215,s0=0.30000001192092896,t0='<line x1="',u0='" ',v0='y1="',w0='x2="',x0='y2="',y0='stroke="',z0='stroke-width="',A0='" />',B0={14:1,4:1},C0={11:1,4:1},D0=536870912,E0=2.617993878,F0=3.665191429,G0=6.283185307179586,H0=3.141592653589793,I0=1.5707963267948966,J0=8192,K0=1920,L0=1024,M0=234881024,N0=100663296,O0=201326592,P0=114688,Q0=4063232,R0=2097152,S0=393216,T0=29360128,U0=268435456,V0=2048,W0=-1.5707963267948966,X0=32640,Y0=1572864,Z0=524288,$0=229376,_0=1.0471975511965976,a1=0.5235987755982988,b1=262144,c1=2.8415926535897933,d1={25:1,4:1,10:1,7:1},e1={4:1,16:1,7:1},f1={4:1},g1=-16777216,h1=131072,i1=-1073741824,j1=-65536,k1='??',l1=-268435456,m1=65011712,n1=3072,o1=126976,p1=1.7976931348623157E308,q1=67108864,r1=134217728,s1=16777216,t1=-66584577,u1=-3.141592653589793,v1=4194303,w1=0.7853981633974483,x1=3.061592653589793,y1=1073741824,z1={9:1,4:1,7:1},A1=281.17,B1=289.19,C1=294.21,D1='0.0000',E1='M  END\n',F1='ATOMS',G1='M  END',H1='$$$$',I1='M  V30 ',J1='M  V30 COUNTS ',K1=')\n',L1='M  V30 MDLV30/STEREL',M1='M  V30 MDLV30/STERAC',N1=3.4028234663852886E38,O1=239060990,P1='class="event" ',Q1='opacity="0" />',R1='Assignment of aromatic double bonds failed',S1='Members of ESR groups must only be stereo centers with known configuration.',T1='Ambiguous configuration at stereo center because of 2 parallel bonds',U1=-0.5235987755982988,V1=-1.0471975511965976,W1=-0.7853981633974483,X1=2.0943951023931953,Y1=0.17453292519943295,Z1='OCL_RXN_V1.0:',$1="'$MOL' tag not found",_1="'M  END' not found",a2='\nActelion Java MolfileCreator 2.0\n\n  0  0  0  0  0  0              0 V3000\n',b2='M  V30 END CTAB',c2='Over- or under-specified stereo feature or more than one racemic type bond',d2='undefined',e2=0.08726646502812703,f2='Too many percent/per mille characters in pattern "',g2=1000000000,h2='CSS1Compat',i2=5.56,j2=11.12,k2=13.34,l2=14.44,m2=4294967296,n2=1.52587890625E-5,o2=0.3010299956639812,p2=4294967295,q2={30:1,60:1},r2={37:1,77:1},s2=15525485,t2=5.9604644775390625E-8,u2={4:1,30:1,39:1,48:1},v2='Invalid UTF8 sequence';var h_={};var i_={};var j_={};var k_={};var l_={};var m_={};var n_={};var o_={};var p_={};var q_={};var r_={};var s_={};var t_={};var u_={};var v_={};var w_={};var x_={};var y_={};var z_={};var A_={};var B_={};var C_={};var D_={};var E_={};var F_={};var _;var tO;var nO;h_.FN=function FN(){};function sO(a,b){typeof window===G_&&typeof window['$gwt']===G_&&(window['$gwt'][a]=b);}function rO(b,c,d,e){h_.qO();var f=nO;function g(){for(var a=0;a<f.length;a++){f[a]();}}if(b){try{g_(g)();}catch(a){b(c,a);}}else {g_(g)();}}h_.qO=function qO(){nO==null&&(nO=[]);};function pO(){h_.qO();var a=nO;for(var b=0;b<arguments.length;b++){a.push(arguments[b]);}}h_.oO=function oO(){};function FO(){}function EO(a){if(Array.isArray(a)&&a.dc===FO){return i_.Cc(a);}return a.toString();}function DO(a,b){var c=$wnd;if(a===''){return c;}var d=a.split('.');!(d[0]in c)&&c.execScript&&c.execScript('var '+d[0]);if(b){var e=b.prototype.bc;e.e=b;}for(var f;d.length&&(f=d.shift());){c=c[f]=c[f]||!d.length&&b||{};}return c;}h_.CO=function CO(a){function b(){}b.prototype=a||{};return new b();};h_.BO=function BO(a){return a instanceof Array?a[0]:null;};function AO(a,b,c){var d=function(){return a.apply(d,arguments);};b.apply(d,c);return d;}function zO(){}function yO(a,b){for(var c in b){b[c]['configurable']=true;}Object.defineProperties(a,b);}function xO(a,b,c){var d=tO;var e=d[a];var f=h_.BO(e);if(e&&!f){_=e;}else {_=h_.wO(b);_.cc=c;!b&&(_.dc=FO);d[a]=_;}for(var g=3;g<arguments.length;++g){arguments[g].prototype=_;}f&&(_.bc=f);}h_.wO=function wO(a){var b=a&&a.prototype;!b&&(b=tO[a]);return h_.CO(b);};function vO(){tO={};!Array.isArray&&(Array.isArray=function(a){return Object.prototype.toString.call(a)==='[object Array]';});function b(){return new Date().getTime();}!Date.now&&(Date.now=b);}h_.uO=function uO(){};$wnd.goog=$wnd.goog||{};$wnd.goog.global=$wnd.goog.global||$wnd;vO();i_.rc=function rc(a,b){return bK(a)===bK(b);};i_.sc=function sc(a){return a.bc;};i_.tc=function tc(a){return n_.Z$(a);};function uc(){}i_.wc=function wc(a,b){return $J(a)?i_.GR(a,b):XJ(a)?i_.FQ(a,b):WJ(a)?i_.NP(a,b):UJ(a)?a.gb(b):RI(a)?i_.rc(a,b):j_.XG(a,b);};i_.yc=function yc(a){return $J(a)?i_.IR():XJ(a)?i_.GQ():WJ(a)?i_.OP():UJ(a)?a.bc:RI(a)?i_.sc(a):j_.YG(a);};i_.Ac=function Ac(a){return $J(a)?i_.JR(a):XJ(a)?i_.HQ(a):WJ(a)?i_.PP(a):UJ(a)?a.ib():RI(a)?i_.tc(a):j_.ZG(a);};i_.Cc=function Cc(a){var b;return i_.dQ(i_.yc(a))+'@'+(b=n_.V$(i_.mR(i_.Ac(a))),b.toString(16));};xO(1,null,{},uc);_.gb=function vc(a){return i_.rc(this,a);};_.hb=function xc(){return i_.sc(this);};_.ib=function zc(){return i_.tc(this);};_.jb=function Bc(){var a;return i_.dQ(i_.yc(this))+'@'+(a=n_.V$(i_.mR(i_.Ac(this))),a.toString(16));};_.equals=function(a){return this.gb(a);};_.hashCode=function(){return this.ib();};_.toString=function(){return this.jb();};j_.XG=function XG(a,b){return j_.bH(a)?j_.$G(a,b):bK(a)===bK(b);};j_.YG=function YG(a){return a.bc||Array.isArray(a)&&II(h_.yL,1)||h_.yL;};j_.ZG=function ZG(a){return j_.cH(a)?j_._G(a):n_.Z$(a);};j_.$G=function $G(a,b){return a.equals(b);};j_._G=function _G(a){return a.hashCode();};j_.aH=function aH(){return [];};j_.bH=function bH(a){return !!a&&!!a.equals;};j_.cH=function cH(a){return !!a&&!!a.hashCode;};j_.dH=function dH(a){return a.toString?a.toString():'[JavaScriptObject]';};k_.IH=function IH(){k_.IH=zO;var a,b;b=!k_.RH();a=new k_._H();k_.HH=b?new k_.SH():a;};k_.JH=function JH(a){k_.IH();k_.HH.Fb(a);};k_.KH=function KH(a){k_.IH();var b;b=k_.HH.Gb(a);return k_.LH(b);};k_.LH=function LH(a){var b,c,d,e;b='JH';c='zG';e=$wnd.Math.min(a.length,5);for(d=e-1;d>=0;d--){if(i_.GR(a[d].d,b)||i_.GR(a[d].d,c)){a.length>=d+1&&n_.V$(a).splice(0,d+1);break;}}return a;};k_.MH=function MH(a){var b=/function(?:\s+([\w$]+))?\s*\(/;var c=b.exec(a);return c&&c[1]||H_;};k_.NH=function NH(a){k_.IH();return a&&a[I_]?a[I_]:[];};k_.OH=function OH(a){k_.IH();return a.name||(a.name=k_.MH(a.toString()));};k_.PH=function PH(a){k_.IH();return parseInt(a)||-1;};k_.QH=function QH(a){k_.IH();var b=a.backingJsObject;if(b&&b.stack){var c=b.stack;var d=b+J_;c.substring(0,d.length)==d&&(c=c.substring(d.length));return c.split(J_);}return [];};k_.RH=function RH(){if(Error.stackTraceLimit>0){$wnd.Error.stackTraceLimit=Error.stackTraceLimit=64;return true;}return 'stack'in new Error();};xO(206,1,{});k_.SH=function SH(){};xO(154,206,{},k_.SH);_.Fb=function TH(a){var b={};var c=[];a[I_]=c;var d=arguments.callee.caller;while(d){var e=k_.OH(d);c.push(e);var f=':'+e;var g=b[f];if(g){var h,i;for(h=0,i=g.length;h<i;h++){if(g[h]===d){return;}}}(g||(b[f]=[])).push(d);d=d.caller;}};_.Gb=function UH(a){var b,c,d,e;d=k_.NH(a);c=j_.iH(d);e=OI(h_.pM,K_,49,c,0,1);for(b=0;b<c;b++){e[b]=new i_.wR(j_.hH(d,b),null,-1);}return e;};k_.VH=function VH(a,b){var c,d,e,f,g,h,i,j,k;j='';if(n_.V$(b).length==0){return a.Hb(L_,H_,-1,-1);}k=i_.TR(b);i_.GR(n_.V$(k).substr(0,3),'at ')&&(k=n_.V$(k).substr(3));k=k_.WH(k);g=n_.V$(k).indexOf('(');if(g==-1){g=n_.V$(k).indexOf('@');if(g==-1){j=k;k='';}else {j=i_.TR(n_.V$(k).substr(g+1));k=i_.TR(n_.V$(k).substr(0,g));}}else {c=n_.V$(k).indexOf(')',g);j=n_.V$(k).substr(g+1,c-(g+1));k=i_.TR(n_.V$(k).substr(0,g));}g=i_.KR(k,VR(46));g!=-1&&(k=n_.V$(k).substr(g+1));(n_.V$(k).length==0||i_.GR(k,'Anonymous function'))&&(k=H_);h=i_.NR(j,VR(58));e=i_.OR(j,VR(58),h-1);i=-1;d=-1;f=L_;if(h!=-1&&e!=-1){f=n_.V$(j).substr(0,e);i=k_.PH(n_.V$(j).substr(e+1,h-(e+1)));d=k_.PH(n_.V$(j).substr(h+1));}return a.Hb(f,k,i,d);};k_.WH=function WH(a){return a.replace(/\[.*?\]/g,'');};xO(207,206,{});_.Fb=function XH(a){};_.Hb=function YH(a,b,c,d){return new i_.wR(b,a+'@'+d,c<0?-1:c);};_.Gb=function ZH(a){var b,c,d,e,f,g;e=k_.QH(a);f=OI(h_.pM,K_,49,0,0,1);b=0;d=j_.iH(e);if(d==0){return f;}g=k_.VH(this,j_.hH(e,0));i_.GR(g.d,H_)||(f[b++]=g);for(c=1;c<d;c++){f[b++]=k_.VH(this,j_.hH(e,c));}return f;};k_._H=function _H(){};xO(155,207,{},k_._H);_.Hb=function aI(a,b,c,d){return new i_.wR(b,a,-1);};h_.HI=function HI(a){return a;};function II(a,b){return h_.JI(a,b);}h_.JI=function JI(a,b){return i_.nQ(a,b);};h_.KI=function KI(a){return a.__elementTypeCategory$==null?10:a.__elementTypeCategory$;};h_.LI=function LI(a){return a.__elementTypeId$;};function MI(a,b,c,d,e,f){return h_.NI(a,b,c,d,e,0,f);}h_.NI=function NI(a,b,c,d,e,f,g){var h,i,j,k,l;k=e[f];j=f==g-1;h=j?d:0;l=h_.QI(h,k);d!=10&&XI(II(a,g-f),b[f],c[f],h,l);if(!j){++f;for(i=0;i<k;++i){h_.SI(l,i,h_.NI(a,b,c,d,e,f,g));}}return l;};function OI(a,b,c,d,e,f){var g;g=h_.QI(e,d);e!=10&&XI(II(a,f),b,c,e,g);return g;}h_.QI=function QI(a,b){var c=new Array(b);var d;switch(a){case 14:case 15:d=0;break;case 16:d=false;break;default:return c;}for(var e=0;e<b;++e){c[e]=d;}return c;};function RI(a){return Array.isArray(a)&&a.dc===FO;}h_.SI=function SI(a,b,c){return a[b]=c;};function TI(a,b,c){return h_.SI(a,b,c);}h_.UI=function UI(a,b){a.bc=b;};h_.VI=function VI(a,b){a.__elementTypeCategory$=b;};h_.WI=function WI(a,b){a.__elementTypeId$=b;};function XI(a,b,c,d,e){h_.UI(e,a);e.cc=b;e.dc=FO;h_.WI(e,c);h_.VI(e,d);return e;}h_.YI=function YI(a,b){h_.KI(b)!=10&&XI(i_.yc(b),b.cc,h_.LI(b),h_.KI(b),a);return h_.HI(a);};function TJ(a,b){if($J(a)){return !!SJ[b];}else if(a.cc){return !!a.cc[b];}else if(XJ(a)){return !!RJ[b];}else if(WJ(a)){return !!QJ[b];}return false;}function UJ(a){return !Array.isArray(a)&&a.dc===FO;}function VJ(a,b){return a!=null&&TJ(a,b);}function WJ(a){return typeof a===M_;}function XJ(a){return typeof a===N_;}function YJ(a){return a!=null&&h_._J(a)&&!(a.dc===FO);}function ZJ(a,b){return h_.aK(a,b);}function $J(a){return typeof a===O_;}h_._J=function _J(a){return typeof a===G_||typeof a==='function';};h_.aK=function aK(a,b){return a&&b&&a instanceof b;};function bK(a){return a==null?null:a;}function cK(a){return Math.max(Math.min(a,P_),-2147483648)|0;}var QJ;var RJ;var SJ;h_.GN=function GN(a){return a&&a.__java$exception;};function HN(a){var b;if(VJ(a,17)){return a;}b=h_.GN(a);if(!b){b=new j_.RG(a);k_.JH(b);}return b;}function IN(a){return a.backingJsObject;}function JN(a,b){var c;if(h_.YN(a)&&h_.YN(b)){c=h_.MN(h_.NN(a))+h_.MN(h_.NN(b));if(Q_<c&&c<R_){return h_.SN(c);}}return h_.RN(h_.vJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),h_.YN(b)?h_.iO(h_.NN(b)):h_.LN(b)));}function KN(a,b){return h_.RN(h_.wJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),h_.YN(b)?h_.iO(h_.NN(b)):h_.LN(b)));}h_.LN=function LN(a){return a;};h_.MN=function MN(a){return a;};h_.NN=function NN(a){return a;};h_.ON=function ON(a){return a|0;};function PN(a,b){var c;if(h_.YN(a)&&h_.YN(b)){c=h_.MN(h_.NN(a))-h_.MN(h_.NN(b));if(!isNaN(c)){return c;}}return h_.xJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),h_.YN(b)?h_.iO(h_.NN(b)):h_.LN(b));}h_.QN=function QN(a){return a;};h_.RN=function RN(a){var b;b=h_.fJ(a);if(b==0){return h_.SN(h_.gJ(a)+h_.hJ(a)*S_);}if(b==T_){return h_.SN(h_.gJ(a)+h_.hJ(a)*S_-R_);}return h_.QN(a);};h_.SN=function SN(a){return a;};function TN(a,b){var c;if(h_.YN(a)&&h_.YN(b)){c=h_.MN(h_.NN(a))/h_.MN(h_.NN(b));if(Q_<c&&c<R_){return h_.SN(c<0?$wnd.Math.ceil(c):$wnd.Math.floor(c));}}return h_.RN(h_.bJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),h_.YN(b)?h_.iO(h_.NN(b)):h_.LN(b),false));}function UN(a,b){return PN(a,b)==0;}function VN(a){if(Q_<a&&a<R_){return h_.SN(a<0?$wnd.Math.ceil(a):$wnd.Math.floor(a));}return h_.RN(h_.yJ(a));}function WN(a){return h_.SN(a);}function XN(a,b){return PN(a,b)>0;}h_.YN=function YN(a){return typeof a===N_;};function ZN(a,b){return PN(a,b)<0;}function $N(a,b){return PN(a,b)<=0;}function _N(a,b){var c;if(h_.YN(a)&&h_.YN(b)){c=h_.MN(h_.NN(a))%h_.MN(h_.NN(b));if(Q_<c&&c<R_){return h_.SN(c);}}return h_.RN((h_.bJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),h_.YN(b)?h_.iO(h_.NN(b)):h_.LN(b),true),h_.ZI));}function aO(a,b){var c;if(h_.YN(a)&&h_.YN(b)){c=h_.MN(h_.NN(a))*h_.MN(h_.NN(b));if(Q_<c&&c<R_){return h_.SN(c);}}return h_.RN(h_.zJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),h_.YN(b)?h_.iO(h_.NN(b)):h_.LN(b)));}function bO(a){var b;if(h_.YN(a)){b=0-h_.MN(h_.NN(a));if(!isNaN(b)){return h_.SN(b);}}return h_.RN(h_.AJ(h_.LN(a)));}function cO(a,b){return PN(a,b)!=0;}function dO(a,b){return h_.RN(h_.CJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),h_.YN(b)?h_.iO(h_.NN(b)):h_.LN(b)));}function eO(a,b){return h_.RN(h_.DJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),b));}function fO(a,b){return h_.RN(h_.EJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),b));}function gO(a,b){return h_.RN(h_.FJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),b));}function hO(a,b){var c;if(h_.YN(a)&&h_.YN(b)){c=h_.MN(h_.NN(a))-h_.MN(h_.NN(b));if(Q_<c&&c<R_){return h_.SN(c);}}return h_.RN(h_.GJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),h_.YN(b)?h_.iO(h_.NN(b)):h_.LN(b)));}h_.iO=function iO(a){var b,c,d,e;e=h_.MN(a);d=0;if(e<0){e+=R_;d=T_;}c=cK(e/S_);b=cK(e-c*S_);return h_.aJ(b,c,d);};function jO(a){var b;if(h_.YN(a)){b=h_.MN(h_.NN(a));return b==-0.?0:b;}return h_.HJ(h_.LN(a));}function kO(a){if(h_.YN(a)){return h_.ON(h_.MN(h_.NN(a)));}return h_.IJ(h_.LN(a));}function lO(a){if(h_.YN(a)){return ''+h_.MN(h_.NN(a));}return h_.JJ(h_.LN(a));}function mO(a,b){return h_.RN(h_.KJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a),h_.YN(b)?h_.iO(h_.NN(b)):h_.LN(b)));}function rP(a){var b;if(a==null){return false;}b=typeof a;return i_.GR(b,M_)||i_.GR(b,N_)||i_.GR(b,O_)||a.$implements__java_io_Serializable||Array.isArray(a);}i_.gG=function gG(a){a.g=OI(h_.pM,K_,49,0,0,1);};i_.hG=function hG(a){k_.JH(a);};i_.iG=function iG(a){return k_.KH(a);};i_.jG=function jG(a){if(a.j){a.backingJsObject!==U_&&a.Db();a.g=null;}return a;};i_.kG=function kG(a){return a.e;};i_.lG=function lG(d,b){if(b instanceof Object){try{b.__java$exception=d;if(navigator.userAgent.toLowerCase().indexOf('msie')!=-1&&$doc.documentMode<9){return;}var c=d;Object.defineProperties(b,{cause:{get:function(){var a=c.Bb();return a&&a.zb();}},suppressed:{get:function(){return c.Ab();}}});}catch(a){}}};i_.mG=function mG(a,b,c){var d,e,f,g,h;i_.nG(a);for(e=(a.i==null&&(a.i=OI(h_.wM,K_,17,0,0,1)),a.i),f=0,g=e.length;f<g;++f){d=e[f];i_.mG(d,b,'\t'+c);}h=a.e;!!h&&i_.mG(h,b,c);};i_.nG=function nG(a){var b,c,d;for(b=(a.g==null&&(a.g=i_.iG(a)),a.g),c=0,d=b.length;c<d;++c);};i_.oG=function oG(a,b){a.backingJsObject=b;i_.lG(a,b);};i_.pG=function pG(a){return i_.qG(a,a.Cb());};i_.qG=function qG(a,b){var c;c=i_.dQ(a.bc);return b==null?c:c+': '+b;};i_.rG=function rG(){i_.gG(this);i_.jG(this);this.Db();};i_.sG=function sG(a){i_.gG(this);this.f=a;i_.jG(this);this.Db();};i_.uG=function uG(b){if(!('stack'in b)){try{throw b;}catch(a){}}return b;};function AG(a){var b;if(a!=null){b=a.__java$exception;if(b){return b;}}return ZJ(a,TypeError)?new i_.sR(a):new i_.JG(a);}xO(17,1,{4:1,17:1});_.yb=function tG(a){return new Error(a);};_.zb=function vG(){return this.backingJsObject;};_.Ab=function wG(){var a,b,c;return a=m_.h$((c=m_.g$(l_.hX((this.i==null&&(this.i=OI(h_.wM,K_,17,0,0,1)),this.i)),new i_.qS()),m_.TZ(new m_.a$(),new m_._Z(),new m_.b$(),XI(II(h_.oN,1),V_,58,0,[(m_.XZ(),m_.VZ)])),c),(b=new l_.gi(),b)),a.nb(OI(h_.nM,W_,1,a.size(),5,1));};_.Bb=function xG(){return i_.kG(this);};_.Cb=function yG(){return this.f;};_.Db=function zG(){i_.oG(this,i_.uG(this.yb(i_.qG(this,this.f))));i_.hG(this);};_.jb=function BG(){return i_.pG(this);};_.backingJsObject=U_;_.j=true;i_.CG=function CG(){i_.rG.call(this);};i_.DG=function DG(a){i_.gG(this);i_.jG(this);this.backingJsObject=a;i_.lG(this,a);this.f=a==null?X_:EO(a);};i_.EG=function EG(a){i_.sG.call(this,a);};xO(13,17,{4:1,13:1,17:1},i_.EG);i_.FG=function FG(){i_.CG.call(this);};i_.GG=function GG(a){i_.DG.call(this,a);};i_.HG=function HG(a){i_.EG.call(this,a);};xO(20,13,Y_);i_.FP=function FP(){i_.FG.call(this);};i_.GP=function GP(a){i_.HG.call(this,a);};xO(53,20,Y_,i_.FP,i_.GP);i_.HP=function HP(){i_.FP.call(this);};i_.IP=function IP(a){i_.GP.call(this,a);};xO(88,53,Y_,i_.HP,i_.IP);function yQ(a){var b;b=typeof a;if(i_.GR(b,M_)||i_.GR(b,N_)||i_.GR(b,O_)){return true;}return a!=null&&a.$implements__java_lang_Comparable;}i_.KP=function KP(){i_.KP=zO;JP=n_.V$(false);n_.V$(true);};i_.LP=function LP(a,b){return RP(n_.W$((n_.M$(a),a)),n_.W$((n_.M$(b),b)));};i_.MP=function MP(a,b){return i_.LP(a,b);};i_.NP=function NP(a,b){return n_.M$(a),bK(a)===bK(b);};i_.OP=function OP(){return h_._L;};i_.PP=function PP(a){return n_.W$((n_.M$(a),a))?1231:1237;};function QP(a){i_.KP();return i_.GR(M_,typeof a);}function RP(a,b){i_.KP();return a==b?0:a?1:-1;}i_.SP=function SP(a,b){i_.KP();return $J(a)?i_.BR(a,b):XJ(a)?i_.EQ(a,b):WJ(a)?i_.MP(a,b):a.lb(b);};QJ={4:1,151:1,30:1};var JP;function TP(a){if(i_.GR(typeof a,O_)){return true;}return a!=null&&a.$implements__java_lang_CharSequence;}i_.bQ=function bQ(a){a.i=aQ++;};i_.cQ=function cQ(a){if(a.n!=null){return;}i_.rQ(a);};i_.dQ=function dQ(a){i_.cQ(a);return a.n;};i_.eQ=function eQ(a){return (a.f&4)!=0;};i_.fQ=function fQ(a){return (a.f&1)!=0;};i_.gQ=function gQ(){i_.bQ(this);this.n=null;this.j=null;this.g=null;this.d=null;this.b=null;this.k=null;this.a=null;};i_.iQ=function iQ(a){var b;b=new i_.gQ();b.n='Class$'+(a?'S'+a:''+b.i);b.b=b.n;b.j=b.n;return b;};function jQ(a){var b;b=i_.iQ(a);i_.vQ(a,b);return b;}function kQ(a,b){var c;c=i_.iQ(a);i_.vQ(a,c);c.f=b?8:0;return c;}function lQ(a){var b;b=i_.iQ(a);b.k=a;b.f=1;return b;}i_.nQ=function nQ(a,b){var c=a.a=a.a||[];return c[b]||(c[b]=a.Ib(b));};function pQ(a){if(a.Nb()){return null;}var b=a.k;return tO[b];}i_.rQ=function rQ(a){if(a.Mb()){var b=a.c;b.Nb()?a.n='['+b.k:!b.Mb()?a.n='[L'+b.Kb()+';':a.n='['+b.Kb();a.b=b.Jb()+'[]';a.j=b.Lb()+'[]';return;}var c=a.g;var d=a.d;d=d.split('/');a.n=i_.uQ('.',[c,i_.uQ('$',d)]);a.b=i_.uQ('.',[c,i_.uQ('.',d)]);a.j=d[d.length-1];};i_.uQ=function uQ(a,b){var c=0;while(!b[c]||b[c]==''){c++;}var d=b[c++];for(;c<b.length;c++){if(!b[c]||b[c]==''){continue;}d+=a+b[c];}return d;};i_.vQ=function vQ(a,b){if(!a){return;}b.k=a;var d=pQ(b);if(!d){tO[a]=[b];return;}d.bc=b;};xO(102,1,{},i_.gQ);_.Ib=function hQ(a){var b;b=new i_.gQ();b.f=4;a>1?b.c=i_.nQ(this,a-1):b.c=this;return b;};_.Jb=function mQ(){i_.cQ(this);return this.b;};_.Kb=function oQ(){return i_.dQ(this);};_.Lb=function qQ(){i_.cQ(this);return this.j;};_.Mb=function sQ(){return i_.eQ(this);};_.Nb=function tQ(){return i_.fQ(this);};_.jb=function wQ(){return ((this.f&2)!=0?'interface ':(this.f&1)!=0?'':'class ')+(i_.cQ(this),this.n);};_.f=0;_.i=0;var aQ=1;function xQ(a){if(a==null){return false;}return a.$implements__java_lang_Cloneable||Array.isArray(a);}i_.AQ=function AQ(a){return i_.GR(N_,typeof a)||ZJ(a,$wnd.java.lang.Number$impl);};i_.BQ=function BQ(a){i_.zQ==null&&(i_.zQ=new RegExp('^\\s*[+-]?(NaN|Infinity|((\\d+\\.?\\d*)|(\\.\\d+))([eE][+-]?\\d+)?[dDfF]?)\\s*$'));if(!i_.zQ.test(a)){throw IN(new i_.vR(Z_+a+'"'));}return parseFloat(a);};i_.CQ=function CQ(a){var b,c,d,e,f;if(a==null){throw IN(new i_.vR(X_));}d=n_.V$(a).length;e=d>0&&(n_.S$(0,n_.V$(a).length),n_.V$(a).charCodeAt(0)==45||(n_.S$(0,n_.V$(a).length),n_.V$(a).charCodeAt(0)==43))?1:0;for(b=e;b<d;b++){if(WP((n_.S$(b,n_.V$(a).length),n_.V$(a).charCodeAt(b)))==-1){throw IN(new i_.vR(Z_+a+'"'));}}f=parseInt(a,10);c=f<$_;if(isNaN(f)){throw IN(new i_.vR(Z_+a+'"'));}else if(c||f>P_){throw IN(new i_.vR(Z_+a+'"'));}return f;};xO(73,1,{4:1,73:1});i_.DQ=function DQ(a,b){return JQ(n_.X$((n_.M$(a),a)),n_.X$((n_.M$(b),b)));};i_.EQ=function EQ(a,b){return i_.DQ(a,b);};i_.FQ=function FQ(a,b){return n_.M$(a),bK(a)===bK(b);};i_.GQ=function GQ(){return h_.bM;};i_.HQ=function HQ(a){return cK(n_.X$((n_.M$(a),a)));};function IQ(a){return i_.GR(N_,typeof a);}function JQ(a,b){if(a<b){return -1;}if(a>b){return 1;}if(a==b){return a==0?JQ(1/a,1/b):0;}return isNaN(a)?isNaN(b)?0:1:-1;}function KQ(a){var b,c,d,e,f,g;if(isNaN(a)){return {l:0,m:0,h:524160};}g=false;if(a==0){return 1/a==-Infinity?__:0;}if(a<0){g=true;a=-a;}if(!isNaN(a)&&!isFinite(a)){return g?{l:0,m:0,h:1048320}:{l:0,m:0,h:524032};}c=0;if(a<1){b=512;for(d=0;d<10;++d,b>>=1){if(a<(i_.NQ(),i_.LQ)[d]&&c-b>=-1023){a*=i_.MQ[d];c-=b;}}if(a<1&&c-1>=-1023){a*=2;--c;}}else if(a>=2){b=512;for(d=0;d<10;++d,b>>=1){if(a>=(i_.NQ(),i_.MQ)[d]){a*=i_.LQ[d];c+=b;}}}c>-1023?a-=1:a*=0.5;e=VN(a*a0);a-=jO(e)*9.5367431640625E-7;f=VN(a*4503599627370496);e=dO(e,h_.SN(c+1023<<20));g&&(e=dO(e,2147483648));return dO(eO(e,32),f);}RJ={4:1,30:1,152:1,73:1};i_.OQ=function OQ(a,b){return a.b-b.b;};i_.PQ=function PQ(a){return a.a!=null?a.a:''+a.b;};i_.QQ=function QQ(a){return a.b;};function RQ(a,b){this.a=a;this.b=b;}xO(39,1,{4:1,30:1,39:1});_.lb=function TQ(a){return i_.OQ(this,a);};_.compareTo=function SQ(a){return i_.OQ(this,a);};_.equals=function UQ(a){return this===a;};_.gb=function(a){return this.equals(a);};_.hashCode=function VQ(){return n_.Z$(this);};_.ib=function(){return this.hashCode();};_.name=function WQ(){return i_.PQ(this);};_.ordinal=function XQ(){return i_.QQ(this);};_.toString=function YQ(){return this.a!=null?this.a:''+this.b;};_.jb=function(){return this.toString();};_.b=0;i_.$Q=function $Q(){i_.FG.call(this);};i_._Q=function _Q(a){i_.HG.call(this,a);};xO(26,20,Y_,i_.$Q,i_._Q);i_.aR=function aR(){i_.FG.call(this);};i_.bR=function bR(){i_.HG.call(this,"Stream already terminated, can't be modified or used");};xO(118,20,Y_,i_.aR,i_.bR);i_.cR=function cR(a,b){return fR(a.a,b.a);};i_.dR=function dR(a){this.a=a;};function eR(a){a-=a>>1&1431655765;a=(a>>2&858993459)+(a&858993459);a=(a>>4)+a&252645135;a+=a>>8;a+=a>>16;return a&63;}function fR(a,b){return a<b?-1:a>b?1:0;}function jR(a){var b,c,d;if(a<0){return 0;}else if(a==0){return 32;}else {d=-(a>>16);b=d>>16&16;c=16-b;a=a>>b;d=a-256;b=d>>16&8;c+=b;a<<=b;d=a-b0;b=d>>16&4;c+=b;a<<=b;d=a-c0;b=d>>16&2;c+=b;a<<=b;d=a>>14;b=d&~(d>>1);return c+2-b;}}function kR(a){var b,c;if(a==0){return 32;}else {c=0;for(b=1;(b&a)==0;b<<=1){++c;}return c;}}i_.mR=function mR(a){return a>>>0;};i_.nR=function nR(a){var b,c;if(a>-129&&a<128){b=a+128;c=(i_.pR(),i_.oR)[b];!c&&(c=i_.oR[b]=new i_.dR(a));return c;}return new i_.dR(a);};xO(36,73,{4:1,30:1,36:1,73:1},i_.dR);_.lb=function gR(a){return i_.cR(this,a);};_.gb=function hR(a){return VJ(a,36)&&a.a==this.a;};_.ib=function iR(){return this.a;};_.jb=function lR(){return ''+this.a;};_.a=0;i_.IG=function IG(){i_.FG.call(this);};i_.JG=function JG(a){i_.GG.call(this,a);};i_.KG=function KG(a){i_.HG.call(this,a);};xO(67,20,Y_,i_.JG);xO(251,1,{});i_.rR=function rR(){i_.IG.call(this);};i_.sR=function sR(a){i_.JG.call(this,a);};i_.tR=function tR(a){i_.KG.call(this,a);};xO(87,67,Y_,i_.rR,i_.sR,i_.tR);_.yb=function uR(a){return new TypeError(a);};i_.AR=function AR(a,b){n_.S$(b,n_.V$(a).length);return n_.V$(a).charCodeAt(b);};i_.BR=function BR(a,b){return i_.CR(a,b);};i_.CR=function CR(a,b){var c,d;c=n_.X$((n_.M$(a),a));d=n_.X$((n_.M$(b),b));return c==d?0:c<d?-1:1;};i_.DR=function DR(a,b){return i_.CR(n_.V$(a).toLowerCase(),n_.V$(b).toLowerCase());};i_.ER=function ER(a,b){return n_.M$(a),a+(''+(n_.M$(b),b));};i_.FR=function FR(a){var b;return i_.XR(n_.D$(a,0,(b=a.length,n_.A$(),b)));};i_.GR=function GR(a,b){return n_.M$(a),bK(a)===bK(b);};i_.HR=function HR(a,b){n_.M$(a);if(b==null){return false;}if(i_.GR(a,b)){return true;}return n_.V$(a).length==n_.V$(b).length&&i_.GR(n_.V$(a).toLowerCase(),n_.V$(b).toLowerCase());};i_.IR=function IR(){return h_.uM;};i_.JR=function JR(a){return n_.e_(a);};i_.KR=function KR(a,b){return n_.V$(a).indexOf(b);};i_.LR=function LR(a,b,c){return n_.V$(a).indexOf(b,c);};function MR(a){return i_.GR(O_,typeof a);}i_.NR=function NR(a,b){return n_.V$(a).lastIndexOf(b);};i_.OR=function OR(a,b,c){return n_.V$(a).lastIndexOf(b,c);};i_.PR=function PR(a,b){b=i_.WR(b);return n_.V$(a).replace(new RegExp('width="\\d+px" height="\\d+px" viewBox="0 0 \\d+ \\d+"','g'),b);};i_.QR=function QR(a){var b,c,d,e,f,g,h,i;b=new RegExp(' ','g');h=OI(h_.uM,d0,2,0,6,1);c=0;i=a;e=null;while(true){g=b.exec(i);if(g==null||i==''){h[c]=i;break;}else {f=g.index;h[c]=n_.V$(i).substr(0,f);i=i_.SR(i,f+n_.V$(n_.V$(g)[0]).length,n_.V$(i).length);b.lastIndex=0;if(e==i){h[c]=n_.V$(i).substr(0,1);i=n_.V$(i).substr(1);}e=i;++c;}}if(n_.V$(a).length>0){d=h.length;while(d>0&&h[d-1]==''){--d;}d<h.length&&(n_.V$(h).length=d);}return h;};i_.RR=function RR(a,b){return n_.V$(a).substr(b);};i_.SR=function SR(a,b,c){return n_.V$(a).substr(b,c-b);};i_.TR=function TR(a){var b,c,d;c=n_.V$(a).length;d=0;while(d<c&&(n_.S$(d,n_.V$(a).length),n_.V$(a).charCodeAt(d)<=32)){++d;}b=c;while(b>d&&(n_.S$(b-1,n_.V$(a).length),n_.V$(a).charCodeAt(b-1)<=32)){--b;}return d>0||b<c?n_.V$(a).substr(d,b-d):a;};i_.UR=function UR(a){return String.fromCharCode.apply(null,a);};function VR(a){var b,c;if(a>=e0){b=55296+(a-e0>>10&1023)&f0;c=56320+(a-e0&1023)&f0;return String.fromCharCode(b)+(''+String.fromCharCode(c));}else {return String.fromCharCode(a&f0);}}i_.WR=function WR(a){var b;b=0;while(0<=(b=n_.V$(a).indexOf('\\',b))){n_.S$(b+1,n_.V$(a).length);n_.V$(a).charCodeAt(b+1)==36?a=n_.V$(a).substr(0,b)+'$'+i_.RR(a,++b):a=n_.V$(a).substr(0,b)+(''+i_.RR(a,++b));}return a;};i_.XR=function XR(a){return i_.YR(a,0,a.length);};i_.YR=function YR(a,b,c){var d,e,f,g;f=b+c;n_.R$(b,f,a.length);g='';for(e=b;e<f;){d=$wnd.Math.min(e+g0,f);g+=i_.UR(n_.V$(a).slice(e,d));e=d;}return g;};SJ={4:1,104:1,30:1,2:1};i_.mS=function mS(a){i_.GP.call(this,a);};xO(119,53,Y_,i_.mS);i_.qS=function qS(){};xO(130,1,{},i_.qS);i_.rS=function rS(){i_.FG.call(this);};i_.sS=function sS(a){i_.HG.call(this,a);};xO(59,20,Y_,i_.rS,i_.sS);l_.ih=function ih(a,b,c){var d,e;for(e=a.mb();e.Ob();){d=e.Pb();if(bK(b)===bK(d)||b!=null&&i_.wc(b,d)){c&&e.Qb();return true;}}return false;};l_.jh=function jh(a,b){var c,d;n_.M$(b);for(d=b.mb();d.Ob();){c=d.Pb();if(!a.contains(c)){return false;}}return true;};l_.kh=function kh(a,b){var c,d,e;n_.M$(b);c=false;for(d=a.mb();d.Ob();){e=d.Pb();if(b.contains(e)){d.Qb();c=true;}}return c;};l_.lh=function lh(a){var b,c,d;d=new l_.gY('[',']');for(c=a.mb();c.Ob();){b=c.Pb();l_.eY(d,bK(b)===bK(a)?'(this Collection)':b==null?X_:EO(b));}return !d.a?d.c:n_.V$(d.e).length==0?d.a.a:d.a.a+(''+d.e);};xO(208,1,{37:1});_.add=function mh(a){throw IN(new i_.sS('Add not supported on this collection'));};_.addAll=function nh(a){var b,c,d;n_.M$(a);b=false;for(d=a.mb();d.Ob();){c=d.Pb();b=b|this.add(c);}return b;};_.clear=function oh(){var a;for(a=this.mb();a.Ob();){a.Pb();a.Qb();}};_.contains=function ph(a){return l_.ih(this,a,false);};_.containsAll=function qh(a){return l_.jh(this,a);};_.isEmpty=function rh(){return this.size()==0;};_.remove=function sh(a){return l_.ih(this,a,true);};_.removeAll=function th(a){return l_.kh(this,a);};_.retainAll=function uh(a){var b,c,d;n_.M$(a);b=false;for(c=this.mb();c.Ob();){d=c.Pb();if(!a.contains(d)){c.Qb();b=true;}}return b;};_.toArray=function vh(){return this.nb(OI(h_.nM,W_,1,this.size(),5,1));};_.nb=function wh(a){var b,c,d,e;e=this.size();a.length<e&&(a=n_.z$(new Array(e),a));d=a;c=this.mb();for(b=0;b<e;++b){TI(d,b,c.Pb());}a.length>e&&h_.SI(a,e,null);return a;};_.jb=function xh(){return l_.lh(this);};l_.yh=function yh(a,b,c){return new l_.YU(a,b,c);};xO(209,208,h0);_.addAtIndex=function zh(a,b){throw IN(new i_.sS('Add not supported on this list'));};_.add=function Ah(a){this.addAtIndex(this.size(),a);return true;};_.addAllAtIndex=function Bh(a,b){var c,d,e;n_.M$(b);c=false;for(e=b.mb();e.Ob();){d=e.Pb();this.addAtIndex(a++,d);c=true;}return c;};_.clear=function Ch(){this.ob(0,this.size());};_.gb=function Dh(a){var b,c,d,e,f;if(a===this){return true;}if(!VJ(a,76)){return false;}f=a;if(this.size()!=f.size()){return false;}e=f.mb();for(c=this.mb();c.Ob();){b=c.Pb();d=e.Pb();if(!(bK(b)===bK(d)||b!=null&&i_.wc(b,d))){return false;}}return true;};_.ib=function Eh(){return l_.sX(this);};_.indexOf=function Fh(a){var b,c;for(b=0,c=this.size();b<c;++b){if(l_.EX(a,this.getAtIndex(b))){return b;}}return -1;};_.mb=function Gh(){return new l_.RU(this);};_.lastIndexOf=function Hh(a){var b;for(b=this.size()-1;b>-1;--b){if(l_.EX(a,this.getAtIndex(b))){return b;}}return -1;};_.removeAtIndex=function Ih(a){throw IN(new i_.sS('Remove not supported on this list'));};_.ob=function Jh(a,b){var c,d;d=new l_.WU(this,a);for(c=a;c<b;++c){n_.K$(d.a<d.c.size());d.c.getAtIndex(d.b=d.a++);l_.QU(d);}};_.setAtIndex=function Kh(a,b){throw IN(new i_.sS('Set not supported on this list'));};_.subList=function Lh(a,b){return l_.yh(this,a,b);};l_.zX=function zX(){throw IN(new i_.rS());};l_.NU=function NU(a){};l_.OU=function OU(a){return a.a<a.c.size();};l_.PU=function PU(a){n_.K$(a.a<a.c.size());return a.c.getAtIndex(a.b=a.a++);};l_.QU=function QU(a){n_.Q$(a.b!=-1);a.c.removeAtIndex(a.b);a.a=a.b;a.b=-1;};l_.RU=function RU(a){this.c=a;l_.NU(this);};xO(112,1,{},l_.RU);_.Ob=function SU(){return l_.OU(this);};_.Pb=function TU(){return l_.PU(this);};_.Qb=function UU(){l_.QU(this);};_.a=0;_.b=-1;l_.VU=function VU(a){l_.QU(a);};l_.WU=function WU(a,b){l_.RU.call(this,a);n_.O$(b,a.size());this.a=b;};xO(113,112,{},l_.WU);_.Qb=function XU(){l_.VU(this);};l_.YU=function YU(a,b,c){n_.P$(b,c,a.size());this.c=a;this.a=b;this.b=c-b;};xO(114,209,h0,l_.YU);_.addAtIndex=function ZU(a,b){n_.O$(a,this.b);this.c.addAtIndex(this.a+a,b);++this.b;};_.getAtIndex=function $U(a){n_.L$(a,this.b);return this.c.getAtIndex(this.a+a);};_.removeAtIndex=function _U(a){var b;n_.L$(a,this.b);b=this.c.removeAtIndex(this.a+a);--this.b;return b;};_.setAtIndex=function aV(a,b){n_.L$(a,this.b);return this.c.setAtIndex(this.a+a,b);};_.size=function bV(){return this.b;};_.a=0;_.b=0;l_.Mh=function Mh(a){a.a=OI(h_.nM,W_,1,0,5,1);};l_.Nh=function Nh(a,b,c){n_.O$(b,a.a.length);n_.w$(a.a,b,c);};l_.Oh=function Oh(a,b){a.a[a.a.length]=b;return true;};l_.Ph=function Ph(a,b,c){var d,e;n_.O$(b,a.a.length);d=c.toArray();e=d.length;if(e==0){return false;}n_.x$(a.a,b,d);return true;};l_.Qh=function Qh(a,b){var c,d;c=b.toArray();d=c.length;if(d==0){return false;}n_.x$(a.a,a.a.length,c);return true;};l_.Rh=function Rh(a){a.a=OI(h_.nM,W_,1,0,5,1);};l_.Sh=function Sh(a,b){return l_.Vh(a,b,0)!=-1;};l_.Th=function Th(a,b){n_.L$(b,a.a.length);return a.a[b];};l_.Uh=function Uh(a,b){return l_.Vh(a,b,0);};l_.Vh=function Vh(a,b,c){for(;c<a.a.length;++c){if(l_.EX(b,a.a[c])){return c;}}return -1;};l_.Wh=function Wh(a){return a.a.length==0;};l_.Xh=function Xh(a){return new l_.KW(a);};l_.Yh=function Yh(a,b){return l_.Zh(a,b,a.a.length-1);};l_.Zh=function Zh(a,b,c){for(;c>=0;--c){if(l_.EX(b,a.a[c])){return c;}}return -1;};l_.$h=function $h(a,b){var c;c=(n_.L$(b,a.a.length),a.a[b]);n_.y$(a.a,b,1);return c;};l_._h=function _h(a,b){var c;c=l_.Vh(a,b,0);if(c==-1){return false;}l_.$h(a,c);return true;};l_.ai=function ai(a,b,c){var d;n_.P$(b,c,a.a.length);d=c-b;n_.y$(a.a,b,d);};l_.bi=function bi(a,b,c){var d;d=(n_.L$(b,a.a.length),a.a[b]);a.a[b]=c;return d;};l_.ci=function ci(a){return a.a.length;};l_.di=function di(a,b){l_.eX(a.a,a.a.length,b);};l_.ei=function ei(a){return n_.u$(a.a,a.a.length);};l_.fi=function fi(a,b){var c,d;d=a.a.length;b.length<d&&(b=n_.z$(new Array(d),b));for(c=0;c<d;++c){TI(b,c,a.a[c]);}b.length>d&&h_.SI(b,d,null);return b;};l_.gi=function gi(){l_.Mh(this);};xO(18,209,i0,l_.gi);_.addAtIndex=function hi(a,b){l_.Nh(this,a,b);};_.add=function ii(a){return l_.Oh(this,a);};_.addAllAtIndex=function ji(a,b){return l_.Ph(this,a,b);};_.addAll=function ki(a){return l_.Qh(this,a);};_.clear=function li(){l_.Rh(this);};_.contains=function mi(a){return l_.Sh(this,a);};_.getAtIndex=function ni(a){return l_.Th(this,a);};_.indexOf=function oi(a){return l_.Uh(this,a);};_.isEmpty=function pi(){return l_.Wh(this);};_.mb=function qi(){return l_.Xh(this);};_.lastIndexOf=function ri(a){return l_.Yh(this,a);};_.removeAtIndex=function si(a){return l_.$h(this,a);};_.remove=function ti(a){return l_._h(this,a);};_.ob=function ui(a,b){l_.ai(this,a,b);};_.setAtIndex=function vi(a,b){return l_.bi(this,a,b);};_.size=function wi(){return l_.ci(this);};_.toArray=function xi(){return l_.ei(this);};_.nb=function yi(a){return l_.fi(this,a);};l_.HW=function HW(a){};l_.IW=function IW(a){return a.a<a.c.a.length;};l_.JW=function JW(a){n_.K$(a.a<a.c.a.length);a.b=a.a++;return a.c.a[a.b];};l_.KW=function KW(a){this.c=a;l_.HW(this);};xO(19,1,{},l_.KW);_.Ob=function LW(){return l_.IW(this);};_.Pb=function MW(){return l_.JW(this);};_.Qb=function NW(){n_.Q$(this.b!=-1);l_.$h(this.c,this.a=this.b);this.b=-1;};_.a=0;_.b=-1;l_.OW=function OW(a,b){n_.J$(b);return l_.QW(a,OI(h_.dK,j0,5,b,15,1),b);};l_.PW=function PW(a,b){n_.J$(b);return l_.QW(a,OI(h_.hK,k0,5,b,15,1),b);};l_.QW=function QW(a,b,c){var d,e;e=n_.V$(a).length;d=$wnd.Math.min(c,e);n_.v$(a,0,b,0,d,true);return b;};l_.RW=function RW(a){l_.UW(a,a.length);};l_.SW=function SW(a){l_.VW(a,a.length,-1);};l_.TW=function TW(a){l_.WW(a,a.length);};l_.UW=function UW(a,b){var c;for(c=0;c<b;++c){a[c]=-1;}};l_.VW=function VW(a,b,c){var d;for(d=0;d<b;++d){a[d]=c;}};l_.WW=function WW(a,b){var c;for(c=0;c<b;++c){a[c]=0;}};l_.XW=function XW(a,b){var c;for(c=0;c<b;++c){a[c]=false;}};l_.YW=function YW(a){var b,c,d,e,f;f=1;for(c=a,d=0,e=c.length;d<e;++d){b=c[d];f=31*f+(b!=null?i_.Ac(b):0);f=f|0;}return f;};l_.ZW=function ZW(a,b,c,d){var e,f,g;for(e=b+1;e<c;++e){for(f=e;f>b&&d.kb(a[f-1],a[f])>0;--f){g=a[f];h_.SI(a,f,a[f-1]);h_.SI(a,f-1,g);}}};l_.$W=function $W(a,b,c,d,e,f,g,h){var i;i=c;while(f<g){i>=d||b<c&&h.kb(a[b],a[i])<=0?TI(e,f++,a[b++]):TI(e,f++,a[i++]);}};l_._W=function _W(a,b,c,d){var e;d=(l_.uX(),!d?l_.tX:d);e=n_.V$(a).slice(b,c);l_.aX(e,a,b,c,-b,d);};l_.aX=function aX(a,b,c,d,e,f){var g,h,i,j;g=d-c;if(g<7){l_.ZW(b,c,d,f);return;}i=c+e;h=d+e;j=i+(h-i>>1);l_.aX(b,a,i,j,-e,f);l_.aX(b,a,j,h,-e,f);if(f.kb(a[j-1],a[j])<=0){while(c<d){TI(b,c++,a[i++]);}return;}l_.$W(a,i,j,h,b,c,d,f);};l_.bX=function bX(a,b,c){var d;d=n_.V$(a).slice(0,b);n_.V$(d).sort(c);n_.v$(d,0,a,0,b,true);};l_.cX=function cX(a,b){n_.I$(b,a.length);l_.bX(a,b,n_.V$(AO(l_.pX.prototype.Ub,l_.pX,[])));};l_.dX=function dX(a){l_._W(a,0,a.length,null);};l_.eX=function eX(a,b,c){n_.I$(b,a.length);l_._W(a,0,b,c);};l_.fX=function fX(a,b){l_._W(a,0,a.length,b);};l_.gX=function gX(a,b){return l_.QX(b,a.length),new l_.bY(a,b);};l_.hX=function hX(a){return new m_.i$(null,l_.gX(a,a.length));};l_.rX=function rX(a){var b,c,d;d=0;for(c=a.mb();c.Ob();){b=c.Pb();d=d+(b!=null?i_.Ac(b):0);d=d|0;}return d;};l_.sX=function sX(a){var b,c,d;d=1;for(c=a.mb();c.Ob();){b=c.Pb();d=31*d+(b!=null?i_.Ac(b):0);d=d|0;}return d;};l_.DX=function DX(){i_.FG.call(this);};xO(185,20,Y_,l_.DX);l_.EX=function EX(a,b){return bK(a)===bK(b)||a!=null&&i_.wc(a,b);};l_.FX=function FX(a){return a!=null?i_.Ac(a):0;};l_.PX=function PX(a,b){while(a.Zb(b));};l_.QX=function QX(a,b){if(0>a||a>b){throw IN(new i_.IP(l0+a+m0+b));}};l_.RX=function RX(a,b){this.c=a;this.b=(b&64)!=0?b|c0:b;};xO(134,1,{});_.Yb=function UX(a){l_.PX(this,a);};_.Wb=function SX(){return this.b;};_.Xb=function TX(){return this.c;};_.b=0;_.c=0;l_.VX=function VX(a,b){l_.RX.call(this,a,b);};xO(135,134,{});l_.WX=function WX(a,b){n_.M$(b);while(a.c<a.d){l_.aY(a,b,a.c++);}};l_.XX=function XX(a,b){n_.M$(b);if(a.c<a.d){l_.aY(a,b,a.c++);return true;}return false;};l_.YX=function YX(a){this.c=0;this.d=a;this.b=17488;};xO(136,1,{});_.Yb=function _X(a){l_.PX(this,a);};_.Wb=function ZX(){return this.b;};_.Xb=function $X(){return WN(this.d-this.c);};_.b=0;_.c=0;_.d=0;l_.aY=function aY(a,b,c){b.ac(a.a[c]);};l_.bY=function bY(a,b){l_.YX.call(this,b);this.a=a;};xO(137,136,{},l_.bY);_.Yb=function cY(a){l_.WX(this,a);};_.Zb=function dY(a){return l_.XX(this,a);};m_.TZ=function TZ(a,b,c,d){n_.M$(a);n_.M$(b);n_.M$(c);n_.M$(d);return new m_.$Z();};m_.XZ=function XZ(){m_.XZ=zO;m_.UZ=new m_.YZ('CONCURRENT',0);m_.VZ=new m_.YZ('IDENTITY_FINISH',1);m_.WZ=new m_.YZ('UNORDERED',2);};m_.YZ=function YZ(a,b){RQ.call(this,a,b);};m_.ZZ=function ZZ(){m_.XZ();return XI(II(h_.oN,1),V_,58,0,[m_.UZ,m_.VZ,m_.WZ]);};xO(58,39,{4:1,30:1,39:1,58:1},m_.YZ);m_.$Z=function $Z(){};xO(187,1,{},m_.$Z);m_._Z=function _Z(){};xO(132,1,{},m_._Z);m_.a$=function a$(){};xO(131,1,{},m_.a$);m_.b$=function b$(){};xO(133,1,{},m_.b$);m_.c$=function c$(a){};m_.d$=function d$(a){if(!a.b){m_.e$(a);a.c=true;}else {m_.d$(a.b);}};m_.e$=function e$(a){if(a.b){m_.e$(a.b);}else if(a.c){throw IN(new i_.bR());}};m_.f$=function f$(a){m_.c$(this);if(!a){this.b=null;new l_.gi();}else {this.b=a;}};xO(174,1,{});_.c=false;m_.g$=function g$(a,b){m_.e$(a);return new m_.i$(a,new m_.l$(b,a.a));};m_.h$=function h$(a,b){var c;m_.d$(a);c=new m_.q$();c.a=b;a.a.Yb(new m_.s$(c));return c.a;};m_.i$=function i$(a,b){m_.f$.call(this,a);this.a=b;};m_.j$=function j$(a,b){a.add(b);return a;};m_.k$=function k$(a,b){m_.p$(a,m_.j$(a.a,b));};xO(126,174,{},m_.i$);m_.l$=function l$(a,b){l_.VX.call(this,b.Xb(),b.Wb()&-6);n_.M$(a);this.a=b;};xO(175,135,{},m_.l$);_.Zb=function m$(a){return this.a.Zb(new m_.n$(a));};m_.n$=function n$(a){this.a=a;};xO(177,1,{},m_.n$);_.ac=function o$(a){this.a.ac(a.backingJsObject);};m_.p$=function p$(a,b){a.a=b;};m_.q$=function q$(){};xO(176,1,{},m_.q$);_.ac=function r$(a){m_.p$(this,a);};m_.s$=function s$(a){this.a=a;};xO(178,1,{},m_.s$);_.ac=function t$(a){m_.k$(this.a,a);};n_.u$=function u$(a,b){var c;c=n_.V$(a).slice(0,b);return n_.z$(c,a);};n_.v$=function v$(a,b,c,d,e,f){var g,h,i,j,k;if(bK(a)===bK(c)){a=n_.V$(a).slice(b,b+e);b=0;}i=n_.V$(c);for(h=b,j=b+e;h<j;){g=$wnd.Math.min(h+g0,j);e=g-h;k=n_.V$(a).slice(h,g);n_.V$(k).splice(0,0,d,f?e:0);Array.prototype.splice.apply(i,k);h=g;d+=e;}};n_.w$=function w$(a,b,c){n_.V$(a).splice(b,0,c);};n_.x$=function x$(a,b,c){n_.v$(c,0,a,b,c.length,false);};n_.y$=function y$(a,b,c){n_.V$(a).splice(b,c);};xO(253,1,{});n_.z$=function z$(a,b){return h_.YI(a,b);};n_.H$=function H$(a){if(!a){throw IN(new i_.$Q());}};n_.I$=function I$(a,b){if(0>a){throw IN(new i_._Q('fromIndex: 0 > toIndex: '+a));}if(a>b){throw IN(new i_.IP(l0+a+m0+b));}};n_.J$=function J$(a){if(a<0){throw IN(new i_.qR('Negative array size: '+a));}};n_.K$=function K$(a){if(!a){throw IN(new l_.DX());}};n_.L$=function L$(a,b){if(a<0||a>=b){throw IN(new i_.GP(n0+a+o0+b));}};n_.M$=function M$(a){if(a==null){throw IN(new i_.rR());}return a;};n_.N$=function N$(a,b){if(a==null){throw IN(new i_.tR(b));}};n_.O$=function O$(a,b){if(a<0||a>b){throw IN(new i_.GP(n0+a+o0+b));}};n_.P$=function P$(a,b,c){if(a<0||b>c){throw IN(new i_.GP(p0+a+q0+b+', size: '+c));}if(a>b){throw IN(new i_._Q(p0+a+' > toIndex: '+b));}};n_.Q$=function Q$(a){if(!a){throw IN(new i_.aR());}};n_.R$=function R$(a,b,c){if(a<0||b>c||b<a){throw IN(new i_.mS(p0+a+q0+b+m0+c));}};n_.S$=function S$(a,b){if(a<0||a>=b){throw IN(new i_.mS(n0+a+o0+b));}};n_.T$=function T$(a,b){return a[b];};n_.U$=function U$(a,b,c){a[b]=c;};n_.V$=function V$(a){return a;};n_.W$=function W$(a){return a;};n_.X$=function X$(a){return a;};xO(249,1,{});n_.Z$=function Z$(a){return a.$H||(a.$H=n_.$$());};n_.$$=function $$(){return ++n_.Y$;};n_.Y$=0;n_.c_=function c_(){n_.c_=zO;n_._$=new uc();n_.b_=new uc();};n_.d_=function d_(a){var b,c,d,e;b=0;d=n_.V$(a).length;e=d-4;c=0;while(c<e){b=(n_.S$(c+3,n_.V$(a).length),n_.V$(a).charCodeAt(c+3)+(n_.S$(c+2,n_.V$(a).length),31*(n_.V$(a).charCodeAt(c+2)+(n_.S$(c+1,n_.V$(a).length),31*(n_.V$(a).charCodeAt(c+1)+(n_.S$(c,n_.V$(a).length),31*(n_.V$(a).charCodeAt(c)+31*b)))))));b=b|0;c+=4;}while(c<d){b=b*31+i_.AR(a,c++);}b=b|0;return b;};n_.e_=function e_(a){n_.c_();var b,c,d;c=':'+a;d=n_.T$(n_.b_,c);if(d!=null){return cK(n_.X$((n_.M$(d),d)));}d=n_.T$(n_._$,c);b=d==null?n_.d_(a):cK(n_.X$((n_.M$(d),d)));n_.f_();n_.U$(n_.b_,c,n_.V$(b));return b;};n_.f_=function f_(){if(n_.a_==256){n_._$=n_.b_;n_.b_=new uc();n_.a_=0;}++n_.a_;};n_.a_=0;h_.nM=jQ(1);h_.yL=jQ(0);h_.FL=jQ(206);h_.CL=jQ(154);h_.EL=jQ(207);h_.DL=jQ(155);h_.wM=jQ(17);h_.dM=jQ(13);h_.oM=jQ(20);h_.gM=jQ(53);h_.$L=jQ(88);h_._L=jQ(151);h_.aM=jQ(102);h_.mM=jQ(73);h_.bM=jQ(152);h_.cM=jQ(39);h_.eM=jQ(26);h_.fM=jQ(118);h_.hM=jQ(36);h_.iM=jQ(67);h_.kM=jQ(87);h_.uM=jQ(2);h_.sM=jQ(119);h_.vM=jQ(130);h_.xM=jQ(59);h_.EM=jQ(208);h_.IM=jQ(209);h_.FM=jQ(112);h_.GM=jQ(113);h_.HM=jQ(114);h_.WM=jQ(18);h_.VM=jQ(19);h_.YM=jQ(185);h_.bN=jQ(134);h_.$M=jQ(135);h_.aN=jQ(136);h_._M=jQ(137);h_.oN=kQ(58,m_.ZZ);h_.pN=jQ(187);h_.qN=jQ(132);h_.rN=jQ(131);h_.sN=jQ(133);h_.yN=jQ(174);h_.xN=jQ(126);h_.uN=jQ(175);h_.tN=jQ(177);h_.vN=jQ(176);h_.wN=jQ(178);o_.Pc=function Pc(){o_.Pc=zO;o_.Dc=XI(II(h_.hK,1),k0,5,15,[0,r0,14286847,13402367,12779264,16758197,9474192,3166456,16715021,9494608,11789301,11230450,9109248,12560038,15780000,16744448,16777008,2093087,8442339,9388244,4062976,15132390,12567239,10921643,9083335,10255047,14706227,15765664,5296208,13140019,8224944,12750735,6721423,12419299,16752896,10889513,6076625,7351984,65280,9764863,9756896,7586505,5551541,3907230,2396047,687500,27013,12632256,16767375,10909043,6717568,10380213,13924864,9699476,4366000,5707663,51456,7394559,16777159,14286791,13107143,10747847,9437127,6422471,4587463,3211207,2097095,65436,58997,54354,48952,43812,5096191,5089023,2200790,2522539,2516630,1528967,13684960,16765219,12105936,10900557,5724513,10375093,11230208,7688005,4358806,4325478,32000,7384058,47871,41471,36863,33023,27647,5528818,7888099,9064419,10565332,11739092,11739066,11734438,12389767,13041766,13369433,13697103,14221381,14680120,15073326,15400998,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13158600,1334015,56540,15075850,15132160,56540,15075850,15461355,8553170,1016335,1016335,1334015,15132160,3289770,14456450,16422400,16422400,11819700,3289770,1016335]);o_.Gc=new A_.RO(255,128,0);o_.Fc=new A_.RO(92,160,255);o_.Oc=new A_.RO(160,0,64);o_.Ec=new A_.RO(255,160,255);o_.Hc=new A_.RO(32,96,255);o_.Nc=new A_.RO(255,0,0);o_.Kc=new A_.RO(0,255,0);o_.Lc=new A_.RO(192,0,255);o_.Mc=new A_.RO(255,160,0);o_.Ic=new A_.RO(0,128,0);o_.Jc=new A_.RO(160,0,0);};o_.Qc=function Qc(a){a.t=new B_.lP();};o_.Rc=function Rc(a){var b,c;if((a.B&32)!=0)return;c=o_.Mr(a.H);if(c!=null){if(a.u.a==0&&a.u.b==0){b=a.M.c*o_.Jj(a.H);o_.Kd(a);o_.$c(a,b);o_.Hd(a,null,b,0);}o_.dr(a,cK(a.v));a.H.M!=1&&o_.Id(a,448);o_.Zq(a,c,a.u.a,a.u.b+s0*a.v);}};o_.Sc=function Sc(a,b){return a==null?b:b==null?a:a+','+b;};o_.Tc=function Tc(a){var b;b=a.M.c*o_.Jj(a.H);a.T=b*0.06;a.O=b*0.15;a.N=b*0.38;a.R=b*0.47;a.S=cK(b*a.F*0.6+0.5);a.Q=b*0.12;a.U=b*0.4;a.v=b*0.5+0.5;};o_.Uc=function Uc(a,b,c,d){var e,f,g;e=new o_.Qd();f=new o_.Qd();e.a=b.a;e.c=b.c;e.b=(b.a+b.b)/2;e.d=(b.c+b.d)/2;f.a=e.b;f.c=e.d;f.b=b.b;f.d=b.d;if(o_.Ed(a,e)){o_.Id(a,a.o[c]);g=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.a),(D_.BU(),D_.xU))))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,g);}if(o_.Ed(a,f)){o_.Id(a,a.o[d]);g=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(f.a),(D_.BU(),D_.xU))))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(f.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(f.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(f.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,g);}o_.Id(a,a.L);};o_.Vc=function Vc(a,b,c,d){var e,f,g,h,i,j,k,l,m;l=(b.b-b.a)/10;m=(b.d-b.c)/10;e=new o_.Qd();if(o_.qk(a.H,o_.xm(a.H,c,d))){f=-3;g=-3;}else {f=a.o[c];g=a.o[d];}o_.Id(a,f);e.a=b.a;e.c=b.c;e.b=b.a+l*2;e.d=b.c+m*2;i=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.a),(D_.BU(),D_.xU))))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,i);e.a=b.a+l*4;e.c=b.c+m*4;e.b=b.a+l*5;e.d=b.c+m*5;j=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.a),D_.xU)))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,j);o_.Id(a,g);e.a=b.a+l*5;e.c=b.c+m*5;e.b=b.a+l*6;e.d=b.c+m*6;k=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.a),D_.xU)))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,k);e.a=b.a+l*8;e.c=b.c+m*8;e.b=b.b;e.d=b.d;h=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.a),D_.xU)))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,h);o_.Id(a,a.L);};o_.Wc=function Wc(a,b,c){o_.$q(a,b-a.Q/2,c-a.Q/2,a.Q);};o_.Xc=function Xc(a,b,c,d){var e;if(o_.qk(a.H,o_.xm(a.H,c,d))){o_.Id(a,-3);e=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.a),(D_.BU(),D_.xU))))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,e);o_.Id(a,a.L);}else if(a.o[c]!=a.o[d]){o_.Uc(a,b,c,d);}else if(a.o[c]!=0){o_.Id(a,a.o[c]);e=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.a),(D_.BU(),D_.xU))))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,e);o_.Id(a,a.L);}else {e=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.a),(D_.BU(),D_.xU))))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(b.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,e);}};o_.Yc=function Yc(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p;l=b.b-b.a;o=b.d-b.c;i=$wnd.Math.sqrt(l*l+o*o);j=2*kO(VN($wnd.Math.round(i/(4*a.T))));m=l/(j-1);p=o/(j-1);if(o_.qk(a.H,o_.xm(a.H,c,d))){e=-3;f=-3;}else {e=a.o[c];f=a.o[d];}k=b.a-a.T/2;n=b.c-a.T/2;o_.Id(a,e);for(h=0;h<(j/2|0);h++){o_.$q(a,k,n,a.T);k+=m;n+=p;}o_.Id(a,f);for(g=0;g<(j/2|0);g++){o_.$q(a,k,n,a.T);k+=m;n+=p;}o_.Id(a,a.L);};o_.Zc=function Zc(a,b,c,d){var e,f,g,h,i,j,k,l;k=(b.c-b.d)/9;l=(b.b-b.a)/9;g=OI(h_.fK,B0,5,3,15,1);h=OI(h_.fK,B0,5,3,15,1);i=OI(h_.fK,B0,5,4,15,1);j=OI(h_.fK,B0,5,4,15,1);g[0]=b.a;h[0]=b.c;i[2]=b.b+k;j[2]=b.d+l;i[3]=b.b-k;j[3]=b.d-l;g[1]=(g[0]+i[2])/2;h[1]=(h[0]+j[2])/2;g[2]=(g[0]+i[3])/2;h[2]=(h[0]+j[3])/2;i[0]=g[2];j[0]=h[2];i[1]=g[1];j[1]=h[1];if(o_.qk(a.H,o_.xm(a.H,c,d))){e=-3;f=-3;}else {e=a.o[c];f=a.o[d];if(a.H.M!=1){f=o_.bd(a,c);e==o_.sj(a.H,c)&&(e=f);}}o_.Id(a,e);o_.Yq(a,g,h,3);o_.Id(a,f);o_.Yq(a,i,j,4);o_.Id(a,a.L);};o_.$c=function $c(a,b){var c,d;for(d=0;d<a.V.a.length;d++)a.t=B_.jP(a.t,l_.Th(a.V,d));o_._c(a,b);c=0.1*b;a.t.c-=c;a.t.d-=c;a.t.b+=2*c;a.t.a+=2*c;};o_._c=function _c(a,b){var c,d,e,f,g,h,i;e=OI(h_.DN,C0,5,a.H.o,16,1);for(d=0;d<a.H.p;d++){if(o_.ok(a.H,d)){e[o_.Nj(a.H,0,d)]=true;e[o_.Nj(a.H,1,d)]=true;}}g=new B_.lP();for(c=0;c<a.H.o;c++){f=(o_.Dj(a.H,c)&D0)!=0?b*0.47:e[c]?b*0.38:0;if(f!=0){h=o_.dh(a.M,o_.Fj(a.H,c));i=o_.eh(a.M,o_.Gj(a.H,c));B_.kP(g,h-f,i-f,f*2,f*2);a.t=B_.jP(a.t,g);}}};o_.ad=function ad(a){var b,c;b=(A_.MO(),A_.IO);c=new A_.QO(a);return u_.aG(c,b);};o_.bd=function bd(a,b){var c,d;if((a.B&8320)!=0)return a.o[b];d=o_.cd(a,b);if(d==-1){c=o_.gm(a.H,b);if(c!=-1){b=c;d=o_.cd(a,b);}}if(d==-1)return a.o[b];switch(d&255){case 1:return 384;case 2:return 64;default:return 448;}};o_.cd=function cd(a,b){var c,d,e;e=-1;d=-1;if((a.B&128)!=0)return e;if(o_.mk(a.H,b)){e=o_.wj(a.H,b);d=o_.vj(a.H,b);}c=o_.im(a.H,b);if(c!=-1){e=o_.Sj(a.H,c);d=o_.Rj(a.H,c);}e!=-1&&e!=0&&(e|=d<<8);return e;};o_.dd=function dd(a){var b,c,d,e,f;o_.cr(a,2*a.N);e=new o_.Qd();for(d=0;d<a.H.p;d++){b=o_.Nj(a.H,0,d);c=o_.Nj(a.H,1,d);if(o_.ok(a.H,d)){e.a=o_.dh(a.M,o_.Fj(a.H,b));e.c=o_.eh(a.M,o_.Gj(a.H,b));e.b=o_.dh(a.M,o_.Fj(a.H,c));e.d=o_.eh(a.M,o_.Gj(a.H,c));o_.Id(a,-2);f=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.a),(D_.BU(),D_.xU))))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(e.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,f);}}};o_.ed=function ed(a){var b,c,d,e,f,g,h;if(a.H.I){g=a.R;o_.Id(a,-7);for(b=0;b<a.H.d;b++)(o_.Dj(a.H,b)&D0)!=0&&o_.$q(a,o_.dh(a.M,o_.Fj(a.H,b))-g,o_.eh(a.M,o_.Gj(a.H,b))-g,2*g);o_.cr(a,2*a.R);f=new o_.Qd();for(e=0;e<a.H.p;e++){c=o_.Nj(a.H,0,e);d=o_.Nj(a.H,1,e);if((o_.Dj(a.H,c)&o_.Dj(a.H,d)&D0)!=0){f.a=o_.dh(a.M,o_.Fj(a.H,c));f.c=o_.eh(a.M,o_.Gj(a.H,c));f.b=o_.dh(a.M,o_.Fj(a.H,d));f.d=o_.eh(a.M,o_.Gj(a.H,d));h=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(f.a),(D_.BU(),D_.xU))))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(f.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(f.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(f.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,h);}}}};o_.fd=function fd(a){var b,c,d,e;if(a.H.I){o_.Id(a,320);if((a.B&8)!=0)for(b=0;b<a.H.d;b++)(o_.Dj(a.H,b)&-536870913)!=0&&o_.$q(a,o_.dh(a.M,o_.Fj(a.H,b))-a.U/2,o_.eh(a.M,o_.Gj(a.H,b))-a.U/2,a.U);for(e=0;e<a.H.e;e++){if(o_.Xj(a.H,e)!=0){c=o_.Nj(a.H,0,e);d=o_.Nj(a.H,1,e);o_.$q(a,(o_.dh(a.M,o_.Fj(a.H,c))+o_.dh(a.M,o_.Fj(a.H,d))-a.U)/2,(o_.eh(a.M,o_.Gj(a.H,c))+o_.eh(a.M,o_.Gj(a.H,d))-a.U)/2,a.U);}}}};o_.gd=function gd(a){a.F=1;a.M=new o_.fh();a.V=new l_.gi();a.P=new l_.gi();a.q=OI(h_.DN,C0,5,a.H.o,16,1);a.u=new B_.aP();a.L=0;a.w=-1;o_.Md(a);};o_.hd=function hd(a,b){var c;if(o_.mm(a.H,b)==0)return false;for(c=0;c<o_.mm(a.H,b);c++)if(!o_.qk(a.H,o_.Bm(a.H,b,c)))return false;return true;};o_.jd=function jd(a){var b;a.p=OI(h_.DN,C0,5,a.H.o,16,1);for(b=0;b<a.H.p;b++){a.p[o_.Nj(a.H,0,b)]=true;a.p[o_.Nj(a.H,1,b)]=true;}};o_.kd=function kd(a,b){var c;if(o_.Am(a.H,b)!=2)return false;for(c=0;c<2;c++)if(o_.Cm(a.H,b,c)!=2)return false;return true;};o_.ld=function ld(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o;m=false;e.a=0;e.b=0;d>0?f=E0:f=F0;o=o_.Mj(a.H,b,c);for(k=0;k<o_.Am(a.H,b);k++){g=o_.Bm(a.H,b,k);h=o;o_.Nj(a.H,0,g)==b?l=o_.Nj(a.H,1,g):l=o_.Nj(a.H,0,g);if(l==c)continue;n=o_.Mj(a.H,b,l);h<n&&(h+=G0);i=h-n;if(d>0){i<H0&&(m=true);i>E0&&(i=E0);i<0.523598776&&(i=0.523598776);if(i<=f){f=i;j=a.O*$wnd.Math.tan(f-I0)/2;e.a=-(j*$wnd.Math.sin(h));e.b=-(j*$wnd.Math.cos(h));}}else {i>=H0&&(m=true);i<F0&&(i=F0);i>5.759586531&&(i=5.759586531);if(i>=f){f=i;j=a.O*$wnd.Math.tan(4.712388981-f)/2;e.a=-(j*$wnd.Math.sin(h));e.b=-(j*$wnd.Math.cos(h));}}}return m;};o_.md=function md(a,b,c,d){var e;if(b==0){c<0?d.a=a.O:d.a=-a.O;d.b=0;return;}e=$wnd.Math.atan(c/b);b<0&&(e+=H0);d.a=-(a.O*$wnd.Math.sin(e));d.b=a.O*$wnd.Math.cos(e);};o_.nd=function nd(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p;e=new o_.Qd();i=new o_.Qd();k=new B_.aP();j=new B_.aP();g=o_.Nj(a.H,0,c);h=o_.Nj(a.H,1,c);if(d){m=b.a;b.a=b.b;b.b=m;m=b.c;b.c=b.d;b.d=m;n=g;g=h;h=n;}if(!o_.Ed(a,b))return;if(o_.xn(a.H,c)){e.a=b.a;e.c=b.c;e.b=b.b;e.d=b.d;l=d?-o_.Dd(a,c):o_.Dd(a,c);l==0&&(l=1);o_.md(a,b.b-b.a,b.d-b.c,k);if(l>0){i.a=b.a+k.a;i.c=b.c+k.b;i.b=b.b+k.a;i.d=b.d+k.b;if(o_.ld(a,g,h,1,j)||o_.Am(a.H,g)>1){i.a+=j.a+k.b;i.c+=j.b-k.a;}}else {i.a=b.a-k.a;i.c=b.c-k.b;i.b=b.b-k.a;i.d=b.d-k.b;if(o_.ld(a,g,h,-1,j)||o_.Am(a.H,g)>1){i.a+=j.a+k.b;i.c+=j.b-k.a;}}o_.Yj(a.H,c)==26&&o_.Cd(e,i);o_.Ed(a,e)&&o_.Xc(a,e,g,h);o_.Yj(a.H,c)==64?o_.Ed(a,i)&&o_.Vc(a,i,g,h):o_.Ed(a,i)&&o_.Xc(a,i,g,h);}else {o_.md(a,b.b-b.a,b.d-b.c,k);o=k.a/2;p=k.b/2;f=false;e.a=b.a+o;e.c=b.c+p;e.b=b.b+o;e.d=b.d+p;if(o_.Am(a.H,g)>1){if(o_.ld(a,g,h,1,j)){e.a+=j.a;e.c+=j.b;if(o_.Am(a.H,g)==2){if(j.a!=0||j.b!=0){e.a+=k.b;e.c-=k.a;}}}else {a.n[g]=new B_.bP(e.a,e.c);}}i.a=b.a-o;i.c=b.c-p;i.b=b.b-o;i.d=b.d-p;if(o_.Am(a.H,g)>1){if(o_.ld(a,g,h,0,j)){i.a+=j.a;i.c+=j.b;if(o_.Am(a.H,g)==2){if(j.a!=0||j.b!=0){i.a+=k.b;i.c-=k.a;}}}else {a.n[g]=new B_.bP(i.a,i.c);f=true;}}o_.Yj(a.H,c)==26&&o_.Cd(e,i);if(o_.Yj(a.H,c)==64){if(f){o_.Vc(a,e,g,h);o_.Xc(a,i,g,h);}else {o_.Xc(a,e,g,h);o_.Vc(a,i,g,h);}}else {o_.Xc(a,e,g,h);o_.Xc(a,i,g,h);}}};o_.od=function od(a,b){var c,d,e,f,g,h,i,j,k,l,m;a.n=OI(h_.LL,K_,43,a.H.o,0,1);for(i=0;i<a.H.p;i++)(o_.Yj(a.H,i)==2||o_.Yj(a.H,i)==26||o_.Yj(a.H,i)==64)&&o_.rd(a,i);for(j=0;j<a.H.p;j++)o_.Yj(a.H,j)!=2&&o_.Yj(a.H,j)!=26&&o_.Yj(a.H,j)!=64&&o_.rd(a,j);if((a.B&64)==0){for(h=0;h<a.H.p;h++){if(o_.Qj(a.H,h)!=0){e=null;o_.Qj(a.H,h)==1||o_.Qj(a.H,h)==2?(o_.Vj(a.H,h)==2||o_.Sj(a.H,h)==0||b[o_.Sj(a.H,h)][o_.Rj(a.H,h)]>1)&&(o_.Qj(a.H,h)==1?e=o_.Vj(a.H,h)==2?'E':o_.sk(a.H,h)?'p':'P':e=o_.Vj(a.H,h)==2?'Z':o_.sk(a.H,h)?'m':'M'):e='?';if(e!=null){o_.dr(a,(a.S*2+1)/3|0);o_.Id(a,o_.qk(a.H,h)?-3:a.H.M==1||(a.B&J0)!=0?a.L:448);c=o_.Nj(a.H,0,h);d=o_.Nj(a.H,1,h);l=(o_.dh(a.M,o_.Fj(a.H,c))+o_.dh(a.M,o_.Fj(a.H,d)))/2;m=(o_.eh(a.M,o_.Gj(a.H,c))+o_.eh(a.M,o_.Gj(a.H,d)))/2;f=(o_.dh(a.M,o_.Fj(a.H,c))-o_.dh(a.M,o_.Fj(a.H,d)))/3;g=(o_.eh(a.M,o_.Gj(a.H,c))-o_.eh(a.M,o_.Gj(a.H,d)))/3;o_.ud(a,l+g,m-f,e,true);o_.Id(a,a.L);o_.dr(a,a.S);}}}}if((a.B&4)!=0){o_.dr(a,(a.S*2+1)/3|0);o_.Id(a,384);for(h=0;h<a.H.p;h++){c=o_.Nj(a.H,0,h);d=o_.Nj(a.H,1,h);k=o_.qn(a.H,h)?'d':o_.mn(a.H,h)?'a':'';l=(o_.dh(a.M,o_.Fj(a.H,c))+o_.dh(a.M,o_.Fj(a.H,d)))/2;m=(o_.eh(a.M,o_.Gj(a.H,c))+o_.eh(a.M,o_.Gj(a.H,d)))/2;o_.ud(a,l,m,k+(''+h),true);}o_.Id(a,a.L);o_.dr(a,a.S);}};o_.pd=function pd(a){var b,c;for(c=new l_.KW(a.P);c.a<c.c.a.length;){b=l_.JW(c);o_.Id(a,b.a);o_.Wc(a,b.b,b.c);}o_.Id(a,a.L);};o_.qd=function qd(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z;a.G||o_._q(a,b,(o_.xj(a.H,b),o_.dh(a.M,o_.Fj(a.H,b))),o_.eh(a.M,o_.Gj(a.H,b)));L=null;if(o_.rj(a.H,b)!=0){T=$wnd.Math.abs(o_.rj(a.H,b))==1?'':''+$wnd.Math.abs(o_.rj(a.H,b));L=o_.rj(a.H,b)<0?T+'-':T+'+';}C=null;M=o_.Dj(a.H,b);if(M!=0){(M&2)!=0&&(C=C==null?'a':C+','+'a');(M&4)!=0&&(C=C==null?'!a':C+','+'!a');(M&b0)!=0&&(C=C==null?'s':C+','+'s');if((M&K0)!=0){v=M&K0;v==1792?C=C==null?'h0':C+','+'h0':v==1664?C=C==null?'h1':C+','+'h1':v==1408?C=C==null?'h2':C+','+'h2':v==128?C=C==null?'h>0':C+','+'h>0':v==384?C=C==null?'h>1':C+','+'h>1':v==896?C=C==null?'h>2':C+','+'h>2':v==L0?C=C==null?'h<3':C+','+'h<3':v==1536&&(C=C==null?'h<2':C+','+'h<2');}if((M&M0)!=0){i=M&M0;i==167772160?C=C==null?'c0':C+','+'c0':i==N0?C=C==null?'c+':C+','+'c+':i==O0&&(C=C==null?'c-':C+','+'c-');}if((M&P0)!=0){K=M&P0;K==98304?C=C==null?'pi0':C+','+'pi0':K==81920?C=C==null?'pi1':C+','+'pi1':K==49152?C=C==null?'pi2':C+','+'pi2':K==c0&&(C=C==null?'pi>0':C+','+'pi>0');}if((M&Q0)!=0){J=M&Q0;J==3801088?C=C==null?'n1':C+','+'n1':J==3538944?C=C==null?'n2':C+','+'n2':J==3014656?C=C==null?'n3':C+','+'n3':J==3145728?C=C==null?'n<3':C+','+'n<3':J==R0?C=C==null?'n<4':C+','+'n<4':J==S0?C=C==null?'n>1':C+','+'n>1':J==917504?C=C==null?'n>2':C+','+'n>2':J==1966080&&(C=C==null?'n>3':C+','+'n>3');}if((M&120)!=0){P=M&120;P==112?C=C==null?'!r':C+','+'!r':P==8?C=C==null?'r':C+','+'r':P==104?C=C==null?'rb2':C+','+'rb2':P==88?C=C==null?'rb3':C+','+'rb3':P==56&&(C=C==null?'rb4':C+','+'rb4');}(M&T0)!=0&&(C=C==null?'r'+((M&T0)>>22):C+','+('r'+((M&T0)>>22)));(M&U0)!=0&&(C=C==null?'f':C+','+'f');}o_.Bj(a.H,b)!=0&&(C=o_.Sc(C,''+o_.Bj(a.H,b)));S=0;if(o_.Ej(a.H,b)!=0){switch(o_.Ej(a.H,b)){case 16:L=L==null?'|':L+','+'|';break;case 32:S=1;break;case 48:S=2;}}l=null;if((a.B&64)==0){if(o_.jk(a.H,b))l='?';else if(o_.qj(a.H,b)!=0){if(o_.wj(a.H,b)==0||c==null||c[o_.wj(a.H,b)][o_.vj(a.H,b)]>1){if(o_.Am(a.H,b)==2){switch(o_.qj(a.H,b)){case 2:l=o_.lk(a.H,b)?'p':'P';break;case 1:l=o_.lk(a.H,b)?'m':'M';break;default:l='*';}}else {switch(o_.qj(a.H,b)){case 1:l=o_.lk(a.H,b)?'r':'R';break;case 2:l=o_.lk(a.H,b)?'s':'S';break;default:l='*';}}}}}(a.B&1792)!=0&&(l=o_.Sc(l,''+o_.Ur(a.H,b)));H=null;(a.B&16)!=0&&o_.Aj(a.H,b)!=0&&(H=''+o_.Aj(a.H,b));p=null;if(o_._m(a.H,b)!=-1){o=o_.cd(a,b);o!=-1&&(p=o==0?'abs':((o&255)==1?'&':'or')+(1+(o>>8)));}w=0;a.H.I?(o_.Dj(a.H,b)&V0)!=0&&(w=o_.Nm(a.H,b)):(o_.Ij(a.H,b)!=6||o_.Bj(a.H,b)!=0||!a.p[b]||o_.Ej(a.H,b)!=0)&&(w=o_.Nm(a.H,b));G=false;f=o_.tj(a.H,b);if(f!=null&&i_.GR(n_.V$(f).substr(0,1),']')){C=o_.Sc(n_.V$(f).substr(1),C);f=null;G=true;}if(f!=null){w=0;}else if(o_.yj(a.H,b)!=null){e=(o_.Dj(a.H,b)&1)!=0?'[!':'[';f=e+o_.zj(a.H,b)+']';n_.V$(f).length>5&&(f=e+o_.yj(a.H,b).length+']');(o_.Dj(a.H,b)&V0)!=0&&(w=-1);}else if((o_.Dj(a.H,b)&1)!=0){f='?';(o_.Dj(a.H,b)&V0)!=0&&(w=-1);}else (o_.Ij(a.H,b)!=6||L!=null||C!=null||w>0||!a.p[b])&&(f=o_.xj(a.H,b));F=0;!o_.Bk(a.H,b)&(o_.Dj(a.H,b)&D0)!=0&&o_.Id(a,-8);if(f!=null){F=(N=(U=A_.XO(a.e,f),new B_.mP(0,0,U,0)).b,N);o_.ud(a,o_.dh(a.M,o_.Fj(a.H,b)),o_.eh(a.M,o_.Gj(a.H,b)),f,true);a.q[b]=true;}else o_.kd(a,b)&&o_.td(a,o_.dh(a.M,o_.Fj(a.H,b)),o_.eh(a.M,o_.Gj(a.H,b)),b);if(L!=null){o_.dr(a,(a.S*2+1)/3|0);W=o_.dh(a.M,o_.Fj(a.H,b))+((F+(N=(U=A_.XO(a.e,L),new B_.mP(0,0,U,0)).b,N))/2+1);Y=o_.eh(a.M,o_.Gj(a.H,b))-((a.j*4-4)/8|0);o_.ud(a,W,Y,L,true);o_.dr(a,a.S);}(a.B&2)!=0&&(C=''+b);if(C!=null){G?o_.dr(a,(a.S*5+1)/6|0):o_.dr(a,(a.S*2+1)/3|0);W=o_.dh(a.M,o_.Fj(a.H,b))-(F+(N=(U=A_.XO(a.e,C),new B_.mP(0,0,U,0)).b,N))/2;Y=o_.eh(a.M,o_.Gj(a.H,b))-((a.j*4-4)/8|0);o_.ud(a,W,Y,C,true);o_.dr(a,a.S);}if(l!=null){o_.dr(a,(a.S*2+1)/3|0);W=o_.dh(a.M,o_.Fj(a.H,b))-(F+(N=(U=A_.XO(a.e,l),new B_.mP(0,0,U,0)).b,N))/2;Y=o_.eh(a.M,o_.Gj(a.H,b))+((a.j*4+4)/8|0);R=a.w;a.H.M!=1&&(a.B&J0)==0&&o_.Id(a,448);o_.ud(a,W,Y,l,false);o_.Id(a,R);o_.dr(a,a.S);}if(H!=null){o_.dr(a,(a.S*2+1)/3|0);W=o_.dh(a.M,o_.Fj(a.H,b))+((F+(N=(U=A_.XO(a.e,H),new B_.mP(0,0,U,0)).b,N))/2+1);Y=o_.eh(a.M,o_.Gj(a.H,b))+((a.j*4+4)/8|0);R=a.w;o_.Id(a,o_.nk(a.H,b)?384:448);o_.ud(a,W,Y,H,true);o_.Id(a,R);o_.dr(a,a.S);}if(p!=null){d=o_.yd(a,b);o_.dr(a,(a.S*2+1)/3|0);W=o_.dh(a.M,o_.Fj(a.H,b))+0.7*a.j*$wnd.Math.sin(d);Y=o_.eh(a.M,o_.Gj(a.H,b))+0.7*a.j*$wnd.Math.cos(d);R=a.w;!a.G&&a.H.M!=1&&o_.Id(a,o_.bd(a,b));o_.ud(a,W,Y,p,false);o_.Id(a,R);o_.dr(a,a.S);}if(w==0&&S==0){a.w==-8&&o_.Id(a,-9);return;}t=OI(h_.fK,B0,5,4,15,1);for(B=0;B<o_.nm(a.H,b);B++){h=o_.Bm(a.H,b,B);for(D=0;D<2;D++){if(o_.Nj(a.H,D,h)==b){Q=o_.Mj(a.H,o_.Nj(a.H,D,h),o_.Nj(a.H,1-D,h));if(Q<W0){t[0]-=Q+I0;t[3]+=Q+H0;}else if(Q<0){t[2]+=Q+I0;t[3]-=Q;}else if(Q<I0){t[1]+=Q;t[2]+=I0-Q;}else {t[0]+=Q-I0;t[1]+=H0-Q;}}}}o_.Am(a.H,b)==0?o_.uk(a.H,b)?t[3]-=0.2:t[1]-=0.2:t[1]-=0.1;(L!=null||H!=null)&&(t[1]+=10);(C!=null||l!=null)&&(t[3]+=10);r='';if(w!=0){u=(O=(V=A_.XO(a.e,'H'),new B_.mP(0,0,V,0)).b,O);s=0;q=a.j;if(w==-1){r='n';o_.dr(a,(a.S*2+1)/3|0);s=(N=(U=A_.XO(a.e,r),new B_.mP(0,0,U,0)).b,N);}else if(w>1){r=''+w;o_.dr(a,(a.S*2+1)/3|0);s=(N=(U=A_.XO(a.e,r),new B_.mP(0,0,U,0)).b,N);}if(t[1]<0.6||t[3]<0.6){k=o_.eh(a.M,o_.Gj(a.H,b));if(t[1]<=t[3]){t[1]+=10;j=o_.dh(a.M,o_.Fj(a.H,b))+(F+u)/2;}else {t[3]+=10;j=o_.dh(a.M,o_.Fj(a.H,b))-(F+u)/2-s;}}else {j=o_.dh(a.M,o_.Fj(a.H,b));if(t[0]<t[2]){t[0]+=10;k=o_.eh(a.M,o_.Gj(a.H,b))-q;}else {t[2]+=10;k=o_.eh(a.M,o_.Gj(a.H,b))+q;}}if(s>0){W=j+(u+s)/2;Y=k+((a.j*4+4)/8|0);o_.ud(a,W,Y,r,true);o_.dr(a,a.S);}o_.ud(a,j,k,'H',true);}g=0;if(S!=0){I=50;m=0;for(A=0;A<4;A++){n=A>1?A-2:A+2;if(t[A]<I){g=A;I=t[A];m=t[n];}else if(t[A]==I){if(t[n]>m){g=A;m=t[n];}}}switch(g){case 0:j=o_.dh(a.M,o_.Fj(a.H,b));k=o_.eh(a.M,o_.Gj(a.H,b))-a.Q-F/2;break;case 1:j=o_.dh(a.M,o_.Fj(a.H,b))+a.Q+F/2;k=o_.eh(a.M,o_.Gj(a.H,b));break;case 2:j=o_.dh(a.M,o_.Fj(a.H,b));k=o_.eh(a.M,o_.Gj(a.H,b))+a.Q+F/2;break;default:j=o_.dh(a.M,o_.Fj(a.H,b))-a.Q-F/2;k=o_.eh(a.M,o_.Gj(a.H,b));}if(S==1){l_.Oh(a.V,new B_.mP(j-a.Q,k-a.Q,2*a.Q,2*a.Q));a.G||l_.Oh(a.P,new o_.Pd(j,k,o_.hd(a,b)?-3:a.o[b]));}else {switch(g){case 2:case 0:X=2*a.Q;Z=0;j-=a.Q;break;case 1:X=0;Z=2*a.Q;k-=a.Q;break;default:X=0;Z=2*a.Q;k-=a.Q;}l_.Oh(a.V,new B_.mP(j-a.Q,k-a.Q,2*a.Q,2*a.Q));a.G||l_.Oh(a.P,new o_.Pd(j,k,o_.hd(a,b)?-3:a.o[b]));l_.Oh(a.V,new B_.mP(j+X-a.Q,k+Z-a.Q,2*a.Q,2*a.Q));a.G||l_.Oh(a.P,new o_.Pd(j+X,k+Z,o_.hd(a,b)?-3:a.o[b]));}}a.w==-8&&o_.Id(a,-9);};o_.rd=function rd(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;o=new o_.Qd();c=new o_.Qd();f=new o_.Qd();l=new B_.aP();k=new B_.aP();d=o_.Nj(a.H,0,b);e=o_.Nj(a.H,1,b);((o_.Dj(a.H,d)|o_.Dj(a.H,e))&D0)!=0;o_.ar(a,b,o_.dh(a.M,o_.Fj(a.H,d)),o_.eh(a.M,o_.Gj(a.H,d)),o_.dh(a.M,o_.Fj(a.H,e)),o_.eh(a.M,o_.Gj(a.H,e)));!o_.Bk(a.H,d)&&!o_.Bk(a.H,e)&&((o_.Dj(a.H,d)|o_.Dj(a.H,e))&D0)!=0&&o_.Id(a,-8);if(!a.n[d]){o.a=o_.dh(a.M,o_.Fj(a.H,d));o.c=o_.eh(a.M,o_.Gj(a.H,d));}else {o.a=a.n[d].a;o.c=a.n[d].b;}if(!a.n[e]){o.b=o_.dh(a.M,o_.Fj(a.H,e));o.d=o_.eh(a.M,o_.Gj(a.H,e));}else {o.b=a.n[e].a;o.d=a.n[e].b;}if((o_.Xj(a.H,b)&X0)!=0){o_.Ed(a,o)&&(m='<line stroke-dasharray="3, 3" x1="'+i_.BQ(D_.HS(D_.ES(new D_.IS(o.a),(D_.BU(),D_.xU))))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(o.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(o.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(o.d),D_.xU)))+u0+y0+a.d+u0+'stroke-width:'+a.i+A0,o_.gr(a,m));o_.Id(a,-9);return;}g=o_.Yj(a.H,b)==64?0:o_.Yj(a.H,b)==32?1:o_.Vj(a.H,b);switch(g){case 1:switch(o_.Yj(a.H,b)){case 1:o_.Ed(a,o)&&o_.Xc(a,o,d,e);break;case 17:o_.Ad(a,o,d,e);break;case 9:p=o.b-o.a;q=o.d-o.c;if(o_.qk(a.H,o_.xm(a.H,d,e))){h=-3;i=-3;}else {h=a.o[d];i=o_.bd(a,d);h==o_.sj(a.H,d)&&(h=i);}for(j=2;j<17;j+=2){c.a=o.a+j*p/17-j*q/128;c.c=o.c+j*q/17+j*p/128;c.b=o.a+j*p/17+j*q/128;c.d=o.c+j*q/17-j*p/128;if(o_.Ed(a,c)){o_.Id(a,j<9?h:i);m=t0+i_.BQ(D_.HS(D_.ES(new D_.IS(c.a),(D_.BU(),D_.xU))))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(c.c),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(c.b),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(c.d),D_.xU)))+u0+y0+a.d+u0+z0+a.i+A0;o_.gr(a,m);o_.Id(a,a.L);}}break;case 32:o_.Ed(a,o)&&o_.Yc(a,o,d,e);}break;case 0:case 2:if((a.q[d]||o_.qm(a.H,d)==2)&&(a.q[e]||o_.qm(a.H,e)==2)&&!o_.xn(a.H,b)&&g==2){if(!o_.Ed(a,o))break;o_.md(a,o.b-o.a,o.d-o.c,l);p=l.a/2;q=l.b/2;c.a=o.a+p;c.c=o.c+q;c.b=o.b+p;c.d=o.d+q;f.a=o.a-p;f.c=o.c-q;f.b=o.b-p;f.d=o.d-q;o_.Yj(a.H,b)==26&&o_.Cd(c,f);o_.Xc(a,c,d,e);g==2?o_.Xc(a,f,d,e):o_.Vc(a,f,d,e);}else if((a.q[e]||o_.qm(a.H,e)==2)&&g==2){o_.nd(a,o,b,false);}else if((a.q[d]||o_.qm(a.H,d)==2)&&g==2){o_.nd(a,o,b,true);}else {n=o_.Dd(a,b);n==0&&(n=1);c.a=o.a;c.c=o.c;c.b=o.b;c.d=o.d;o_.md(a,o.b-o.a,o.d-o.c,l);if(n>0){f.a=o.a+l.a;f.c=o.c+l.b;f.b=o.b+l.a;f.d=o.d+l.b;if(o_.ld(a,d,e,1,k)||o_.Am(a.H,d)>1){f.a+=k.a+l.b;f.c+=k.b-l.a;}if(o_.ld(a,e,d,-1,k)||o_.Am(a.H,e)>1){f.b+=k.a-l.b;f.d+=k.b+l.a;}}else {f.a=o.a-l.a;f.c=o.c-l.b;f.b=o.b-l.a;f.d=o.d-l.b;if(o_.ld(a,d,e,-1,k)||o_.Am(a.H,d)>1){f.a+=k.a+l.b;f.c+=k.b-l.a;}if(o_.ld(a,e,d,1,k)||o_.Am(a.H,e)>1){f.b+=k.a-l.b;f.d+=k.b+l.a;}}o_.Yj(a.H,b)==26&&o_.Cd(c,f);o_.Ed(a,c)&&o_.Xc(a,c,d,e);g==2?o_.Ed(a,f)&&o_.Xc(a,f,d,e):o_.Ed(a,f)&&o_.Vc(a,f,d,e);}break;case 3:if(o_.Ed(a,o)){o_.Xc(a,o,d,e);o_.md(a,o.b-o.a,o.d-o.c,l);c.a=o.a+l.a;c.c=o.c+l.b;c.b=o.b+l.a;c.d=o.d+l.b;o_.Xc(a,c,d,e);c.a=o.a-l.a;c.c=o.c-l.b;c.b=o.b-l.a;c.d=o.d-l.b;o_.Xc(a,c,d,e);}}a.w==-8&&o_.Id(a,-9);};o_.sd=function sd(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;o=false;for(d=0;d<a.H.e;d++){j=null;if(o_.pk(a.H,d)){l=o_.Pj(a.H,d);k=o_.Oj(a.H,d);j=l==k?'['+l+']':'['+l+':'+k+']';}else (o_.Xj(a.H,d)&Y0)!=0?j=(o_.Xj(a.H,d)&Y0)==Z0?'a':(o_.Xj(a.H,d)&96)==64?'r!a':'!a':(o_.Xj(a.H,d)&96)!=0&&(j=(o_.Xj(a.H,d)&96)==64?'r':'!r');n=(o_.Xj(a.H,d)&$0)>>15;n!=0&&(j=(j==null?'':j)+n);if(j!=null){b=o_.Nj(a.H,0,d);c=o_.Nj(a.H,1,d);if(!o){o_.dr(a,(a.S*2+1)/3|0);o=true;}q=(o_.dh(a.M,o_.Fj(a.H,b))+o_.dh(a.M,o_.Fj(a.H,c)))/2;r=(o_.eh(a.M,o_.Gj(a.H,b))+o_.eh(a.M,o_.Gj(a.H,c)))/2;f=o_.dh(a.M,o_.Fj(a.H,c))-o_.dh(a.M,o_.Fj(a.H,b));g=o_.eh(a.M,o_.Gj(a.H,c))-o_.eh(a.M,o_.Gj(a.H,b));e=$wnd.Math.sqrt(f*f+g*g);i=(m=(p=A_.XO(a.e,j),new B_.mP(0,0,p,0)).b,0.6*m);h=0.55*a.j;e!=0&&(f>0?o_.ud(a,q+i*g/e,r-h*f/e,j,true):o_.ud(a,q-i*g/e,r+h*f/e,j,true));}}o&&o_.dr(a,a.S);};o_.td=function td(a,b,c,d){l_.Oh(a.V,new B_.mP(b-a.Q,c-a.Q,2*a.Q,2*a.Q));a.G||l_.Oh(a.P,new o_.Pd(b,c,o_.hd(a,d)?-3:a.o[d]));};o_.ud=function ud(a,b,c,d,e){var f,g,h,i,j;if(e){g=(f=(h=A_.XO(a.e,d),new B_.mP(0,0,h,0)).b,f);i=g/2+(a.j/8|0);j=a.j/2|0;(d=='+'||d=='-')&&(j=j*2/3);l_.Oh(a.V,new B_.mP(b-i,c-j,2*i,2*j));}a.G||o_.Zq(a,d,b,c);};o_.vd=function vd(a){var b;b=a.a;a.a=a.b;a.b=b;b=a.c;a.c=a.d;a.d=b;};o_.wd=function wd(a,b,c){var d;d=b==0?G0+a[0]-a[a.length-1]:a[b]-a[b-1];c>-2.0943951023931953&&c<_0?d-=2*$wnd.Math.cos(c+a1):d-=0.5*$wnd.Math.cos(c+a1);return d;};o_.xd=function xd(a){var b;b=new B_.lP();if(a.a<=a.b){b.c=a.a;b.b=a.b-a.a;}else {b.c=a.b;b.b=a.a-a.b;}if(a.c<=a.d){b.d=a.c;b.a=a.d-a.c;}else {b.d=a.d;b.a=a.c-a.d;}return b;};o_.yd=function yd(a,b){var c,d,e,f,g,h,i;c=OI(h_.fK,B0,5,o_.mm(a.H,b),15,1);for(e=0;e<o_.mm(a.H,b);e++)c[e]=o_.Mj(a.H,b,o_.zm(a.H,b,e));n_.V$(c).sort(n_.V$(AO(l_.jX.prototype.Ub,l_.jX,[])));f=o_.zd(c,0);g=o_.wd(c,0,f);for(d=1;d<c.length;d++){h=o_.zd(c,d);i=o_.wd(c,d,h);if(g<i){g=i;f=h;}}return f;};o_.zd=function zd(a,b){var c;if(b>0)return (a[b]+a[b-1])/2;c=H0+(a[0]+a[a.length-1])/2;return c>H0?c-G0:c;};o_.Ad=function Ad(a,b,c,d){var e,f,g,h;h=new o_.Qd();if(b.a==b.b&&b.c==b.d)return;h.a=b.a;h.c=b.c;h.b=b.b;h.d=b.d;g=o_.xd(h);for(e=0;e<a.V.a.length;e++){f=l_.Th(a.V,e);if(f.c>g.c+g.b||f.d>g.d+g.a||g.c>f.c+f.b||g.d>f.d+f.a)continue;if(o_.Bd(a,h.a,h.c,e)){if(o_.Bd(a,h.b,h.d,e))return;o_.Fd(a,h,0,e);o_.Ad(a,h,c,d);return;}if(o_.Bd(a,h.b,h.d,e)){o_.Fd(a,h,1,e);o_.Ad(a,h,c,d);return;}}o_.Zc(a,h,c,d);};o_.Bd=function Bd(a,b,c,d){var e;if((a.B&1)!=0)return false;e=l_.Th(a.V,d);return b>e.c&&b<e.c+e.b&&c>e.d&&c<e.d+e.a;};o_.Cd=function Cd(a,b){var c;c=a.b;a.b=b.b;b.b=c;c=a.d;a.d=b.d;b.d=c;};o_.Dd=function Dd(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;k=OI(h_.DN,C0,5,16,16,1);l=OI(h_.DN,C0,5,16,16,1);c=OI(h_.fK,B0,5,16,15,1);f=OI(h_.fK,B0,5,2,15,1);d=0;for(j=0;j<2;j++){e=o_.Nj(a.H,j,b);for(m=0;m<o_.Am(a.H,e);m++){h=o_.Bm(a.H,e,m);if(h==b)continue;if(d==4)return 0;k[d]=o_.mn(a.H,h);l[d]=o_.xn(a.H,h);c[d++]=o_.Mj(a.H,e,o_.zm(a.H,e,m));}}f[0]=o_.Mj(a.H,o_.Nj(a.H,0,b),o_.Nj(a.H,1,b));if(f[0]<0){f[1]=f[0]+H0;g=false;}else {f[1]=f[0];f[0]=f[1]-H0;g=true;}n=0;for(i=0;i<d;i++){k[i]?o=20:l[i]?o=17:o=16;c[i]>f[0]&&c[i]<f[1]?n-=o:n+=o;}return g?-n:n;};o_.Ed=function Ed(a,b){var c,d,e,f,g,h;if(b.a==b.b&&b.c==b.d){for(e=0;e<a.V.a.length;e++){g=l_.Th(a.V,e);if(B_.eP(g,b.a,b.c))return false;}return true;}h=o_.xd(b);c=false;if(b.a>b.b){o_.vd(b);c=true;}for(d=0;d<a.V.a.length;d++){g=l_.Th(a.V,d);if(g.c>h.c+h.b||g.d>h.d+h.a||h.c>g.c+g.b||h.d>g.d+g.a)continue;if(o_.Bd(a,b.a,b.c,d)){if(o_.Bd(a,b.b,b.d,d)){c&&o_.vd(b);return false;}o_.Fd(a,b,0,d);f=o_.Ed(a,b);c&&o_.vd(b);return f;}if(o_.Bd(a,b.b,b.d,d)){o_.Fd(a,b,1,d);f=o_.Ed(a,b);c&&o_.vd(b);return f;}}c&&o_.vd(b);return true;};o_.Fd=function Fd(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o;if(c==0){l=b.a;n=b.c;m=b.b;o=b.d;}else {l=b.b;n=b.d;m=b.a;o=b.c;}k=l_.Th(a.V,d);i=m>l?k.c+k.b:k.c;j=o>n?k.d+k.a:k.d;e=m-l;f=o-n;if($wnd.Math.abs(e)>$wnd.Math.abs(f)){if(n==o){g=i;h=n;}else {g=l+e*(j-n)/f;if(m>l==i>g){h=j;}else {g=i;h=n+f*(i-l)/e;}}}else {if(l==m){g=l;h=j;}else {h=n+f*(i-l)/e;if(o>n==j>h){g=i;}else {g=l+e*(j-n)/f;h=j;}}}if(c==0){b.a=g;b.c=h;}else {b.b=g;b.d=h;}};o_.Gd=function Gd(a){var b,c,d,e;if(a.H.o==0)return;o_.Jr(a.H,(a.B&256)!=0?63:(a.B&512)!=0?95:(a.B&L0)!=0?159:31);o_.Tc(a);c=o_.Or(a.H);d=false;a.o=OI(h_.hK,k0,5,a.H.o,15,1);for(b=0;b<a.H.o;b++){a.o[b]=o_.sj(a.H,b);a.o[b]!=0&&(d=true);o_.Bk(a.H,b)&&(a.o[b]=128);o_.ek(a.H,b)&&(a.B&b0)==0&&(a.o[b]=256);}o_.Id(a,-10);o_.ed(a);o_.dd(a);o_.fd(a);o_.Rc(a);o_.dr(a,a.S);o_.cr(a,a.T);o_.Id(a,a.L);o_.jd(a);a.P.a=OI(h_.nM,W_,1,0,5,1);a.V.a=OI(h_.nM,W_,1,0,5,1);for(e=0;e<a.H.o;e++){if(o_.hd(a,e)){o_.Id(a,-3);o_.qd(a,e,c);o_.Id(a,a.L);}else if(a.o[e]!=0){o_.Id(a,a.o[e]);o_.qd(a,e,c);o_.Id(a,a.L);}else if(!d&&a.H.M!=1&&o_.Ij(a.H,e)!=1&&o_.Ij(a.H,e)!=6&&(a.B&V0)==0&&o_.yj(a.H,e)==null&&o_.Ij(a.H,e)<o_.Dc.length){o_.Jd(a,o_.ad(o_.Dc[o_.Ij(a.H,e)]));o_.qd(a,e,c);o_.Id(a,a.L);}else {o_.qd(a,e,c);}}o_.pd(a);o_.sd(a);o_.od(a,c);};o_.Hd=function Hd(a,b,c,d){var e;e=c/2;switch(d&786432){case 786432:if(b){a.u.a=b.c+b.b/2;a.u.b=b.d+b.a-e;break;}case 0:a.u.a=a.t.c+a.t.b/2;a.u.b=a.t.d+a.t.a+e;!!b&&a.u.b>b.d+b.a-e&&(a.u.b=b.d+b.a-e);break;case Z0:if(b){a.u.a=b.c+b.b/2;a.u.b=b.d+e;break;}case b1:a.u.a=a.t.c+a.t.b/2;a.u.b=a.t.d-e;!!b&&a.u.b<b.d+e&&(a.u.b=b.d+e);}};o_.Id=function Id(a,b){if(a.G)return;if(b==-10){a.w=-999;b=a.L;}if(b==a.w)return;if(a.w==-8&&b!=-9)return;b==-8&&(a.J=a.w);b==-9&&(b=a.J);a.w=b;switch(b){case 0:o_.br(a,(A_.MO(),A_.JO));break;case-6:o_.br(a,a.A);break;case-4:o_.br(a,a.I);break;case-2:o_.br(a,a.r);break;case-3:o_.br(a,a.s);break;case-7:o_.br(a,a.C);break;case-8:o_.br(a,a.D);break;case-5:o_.br(a,a.K);break;case 64:o_.br(a,o_.Hc);break;case 128:o_.br(a,o_.Nc);break;case 256:o_.br(a,o_.Lc);break;case 192:o_.br(a,o_.Kc);break;case 320:o_.br(a,o_.Mc);break;case 384:o_.br(a,o_.Ic);break;case 448:o_.br(a,o_.Jc);break;case 1:o_.br(a,(A_.MO(),A_.KO));break;default:o_.br(a,(A_.MO(),A_.JO));}};o_.Jd=function Jd(a,b){a.w=-5;a.K=b;a.d='rgb('+(b.c>>16&255)+','+(b.c>>8&255)+','+(b.c&255)+')';};o_.Kd=function Kd(a){var b,c,d,e,f;e=o_.dh(a.M,o_.Fj(a.H,0));c=o_.dh(a.M,o_.Fj(a.H,0));f=o_.eh(a.M,o_.Gj(a.H,0));d=o_.eh(a.M,o_.Gj(a.H,0));for(b=0;b<a.H.o;b++){e>o_.dh(a.M,o_.Fj(a.H,b))&&(e=o_.dh(a.M,o_.Fj(a.H,b)));c<o_.dh(a.M,o_.Fj(a.H,b))&&(c=o_.dh(a.M,o_.Fj(a.H,b)));f>o_.eh(a.M,o_.Gj(a.H,b))&&(f=o_.eh(a.M,o_.Gj(a.H,b)));d<o_.eh(a.M,o_.Gj(a.H,b))&&(d=o_.eh(a.M,o_.Gj(a.H,b)));}a.t=new B_.mP(e,f,c-e,d-f);};o_.Ld=function Ld(a,b){var c,d;if(a.H.o==0)return null;o_.Kd(a);c=a.M.c*o_.Jj(a.H);d=new o_.gh(a.t,b,c);if(d.c==1&&d.a==0&&d.b==0){d=null;}else {o_.$g(d,a.M);o_.ah(d,a.t);}o_.Hd(a,b,c,e0);return d;};o_.Md=function Md(a){var b;b=(A_.MO(),A_.IO);a.r=u_.bG(b,o_.Fc);a.s=u_.aG(o_.Gc,b);a.C=o_.Ec;a.D=o_.Oc;};o_.Nd=function Nd(a,b){var c,d,e,f;if(a.H.o==0)return null;e=o_.er(a,b);o_.Jr(a.H,(a.B&256)!=0?63:(a.B&512)!=0?95:(a.B&L0)!=0?159:31);o_.jd(a);a.P.a=OI(h_.nM,W_,1,0,5,1);a.V.a=OI(h_.nM,W_,1,0,5,1);o_.Tc(a);o_.dr(a,a.S);a.G=true;for(d=0;d<a.H.o;d++)o_.qd(a,d,null);a.G=false;c=a.M.c*o_.Jj(a.H);o_.$c(a,c);o_.Hd(a,b,c,e0);if(B_.cP(b,a.t))return e;f=new o_.gh(a.t,b,c);o_.$g(f,a.M);o_.ah(f,a.t);o_._g(f,a.u);if(!e)return f;o_.$g(f,e);return e;};o_.Od=function Od(a,b){o_.Qc(this);this.H=a;this.B=b;o_.gd(this);};xO(161,1,{});_.v=0;_.w=0;_.B=0;_.F=0;_.G=false;_.J=0;_.L=0;_.N=0;_.O=0;_.Q=0;_.R=0;_.S=0;_.T=0;_.U=0;h_.lK=jQ(161);o_.Pd=function Pd(a,b,c){this.b=a;this.c=b;this.a=c;};xO(75,1,{75:1},o_.Pd);_.a=0;_.b=0;_.c=0;h_.jK=jQ(75);o_.Qd=function Qd(){};xO(38,1,{},o_.Qd);_.a=0;_.b=0;_.c=0;_.d=0;h_.kK=jQ(38);o_.Rd=function Rd(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X;J=OI(h_.DN,C0,5,b.i.a.length,16,1);A=OI(h_.hK,k0,5,a.f.d,15,1);for(T=0;T<b.i.a.length;T++){J[T]=true;for(q=l_.Th(b.j,T),r=0,s=q.length;r<s;++r){t=q[r];if(!a.e[t]){J[T]=false;break;}}if(J[T])for(d=l_.Th(b.i,T),g=0,j=d.length;g<j;++g){c=d[g];++A[c];}}I=OI(h_.DN,C0,5,a.f.d,16,1);for(U=0;U<b.i.a.length;U++){V=l_.Th(b.j,U).length;if(V==3||V==5||V==6||V==7){if(J[U]){for(e=l_.Th(b.i,U),h=0,k=e.length;h<k;++h){c=e[h];I[c]=true;}Q=true;M=-1;N=0;for(f=l_.Th(b.i,U),i=0,l=f.length;i<l;++i){c=f[i];if(V==6||A[c]>1){if(!o_.Vd(a,c,false)){Q=false;break;}}else {S=V==5?o_.Sd(a,c,false):o_.Td(a,c,false);if(o_.Vd(a,c,false)){if(N<S){N=S;M=c;}}else {if(N==10){Q=false;break;}M=c;N=20;}}}if(Q){for(d=l_.Th(b.i,U),g=0,j=d.length;g<j;++g){c=d[g];if(c==M){V==5?o_.Sd(a,c,true):o_.Td(a,c,true);o_.ee(a,c);}else {o_.Vd(a,c,true);}}}}}}w=OI(h_.hK,k0,5,a.f.d,15,1);C=OI(h_.DN,C0,5,a.f.d,16,1);for(p=0;p<a.f.e;p++){m=o_.Nj(a.f,0,p);n=o_.Nj(a.f,1,p);if(!I[m]&&!I[n]){if(a.e[p]){++w[m];++w[n];}if(o_.Yj(a.f,p)==32){C[m]=true;C[n]=true;}}}R=OI(h_.hK,k0,5,a.f.d,15,1);B=OI(h_.hK,k0,5,a.f.d,15,1);for(X=0;X<a.f.d;X++){if(w[X]==1){B[0]=X;v=0;D=0;while(v<=D){for(F=0;F<o_.Am(a.f,B[v]);F++){if(a.e[o_.Bm(a.f,B[v],F)]){u=o_.zm(a.f,B[v],F);if((v==0||u!=B[v-1])&&w[u]!=0){B[++D]=u;if((w[u]&1)!=0){for(L=1;L<D;L+=2)R[B[L]]=-1;D=0;}break;}}}++v;}}}o=OI(h_.DN,C0,5,a.f.d,16,1);for(W=0;W<a.f.d;W++){if(!o[W]&&w[W]!=0){B[0]=W;o[W]=true;v=0;D=0;while(v<=D){for(F=0;F<o_.Am(a.f,B[v]);F++){if(a.e[o_.Bm(a.f,B[v],F)]){u=o_.zm(a.f,B[v],F);if(!o[u]){B[++D]=u;o[u]=true;}}}++v;}if((D&1)==0){for(G=0;G<=D;G++)R[B[G]]==0&&(R[B[G]]=o_.Ud(a,B[G],false));K=true;for(H=0;H<=D;H++){if(R[B[H]]<=0){if(!o_.Vd(a,B[H],false)){K=false;break;}}}if(K){P=0;O=-1;for(F=0;F<=D;F++){if(P<R[B[F]]){P=R[B[F]];O=B[F];}}if(P>0){o_.Ud(a,O,true);o_.ee(a,O);}}}}}};o_.Sd=function Sd(a,b,c){if(o_.Ij(a.f,b)==7){if(o_.mm(a.f,b)==3)return 6;else if(o_.Am(a.f,b)==2)return 4;}else if(o_.Ij(a.f,b)==8){return 10;}else if(o_.Ij(a.f,b)==15||o_.Ij(a.f,b)==33){if(o_.Am(a.f,b)==3)return 8;}else if(o_.Ij(a.f,b)==16||o_.Ij(a.f,b)==34||o_.Ij(a.f,b)==52){if(o_.Am(a.f,b)==2)return 12;}else if(o_.Ij(a.f,b)==6){c&&o_.Vk(a.f,b,-1);return o_.mm(a.f,b)!=o_.nm(a.f,b)?2:3;}return 0;};o_.Td=function Td(a,b,c){if(a.a){if(o_.mm(a.f,b)!=3)return 0;}else {if(o_.mm(a.f,b)>3)return 0;}if(o_.Ij(a.f,b)==6){c&&o_.Vk(a.f,b,1);return 2;}if(o_.Ij(a.f,b)==5){return 4;}return 0;};o_.Ud=function Ud(a,b,c){if(o_.rj(a.f,b)!=0)return 0;if(a.a){if(o_.Ij(a.f,b)==5){if(o_.Sm(a.f,b)!=2)return 0;c&&o_.Vk(a.f,b,1);return 1;}if(o_.Ij(a.f,b)==7){if(o_.Sm(a.f,b)!=2)return 0;c&&o_.Vk(a.f,b,-1);return o_.Xd(a,b)?6:3;}if(o_.Ij(a.f,b)==8){if(o_.Sm(a.f,b)!=1)return 0;c&&o_.Vk(a.f,b,-1);return o_.Xd(a,b)?7:4;}if(o_.Ij(a.f,b)==16){if(o_.Sm(a.f,b)!=1)return 0;c&&o_.Vk(a.f,b,-1);return o_.Xd(a,b)?5:2;}if(o_.Ij(a.f,b)==34){if(o_.Sm(a.f,b)!=1)return 0;c&&o_.Vk(a.f,b,-1);return o_.Xd(a,b)?4:1;}}else {if(o_.Ij(a.f,b)==5){if(o_.Sm(a.f,b)>2)return 0;c&&o_.Vk(a.f,b,1);return 1;}if(o_.Ij(a.f,b)==7){if(o_.Sm(a.f,b)>2)return 0;c&&o_.Vk(a.f,b,-1);return o_.Xd(a,b)?5:3;}if(o_.Ij(a.f,b)==8){if(o_.Sm(a.f,b)>1)return 0;c&&o_.Vk(a.f,b,-1);return o_.Xd(a,b)?7:4;}if(o_.Ij(a.f,b)==16){if(o_.Sm(a.f,b)>1)return 0;c&&o_.Vk(a.f,b,-1);return o_.Xd(a,b)?5:2;}}return 0;};o_.Vd=function Vd(a,b,c){var d,e;d=o_.Ij(a.f,b);if(d>=5&&d<=8||d==15||d==16||d==33||d==34||d==52){e=o_.Om(a.f,b);if(e!=0)return true;if(o_.rj(a.f,b)==0){if(d==15||d==33){c&&o_.Vk(a.f,b,1);return true;}if(d==16||d==34||d==52){c&&o_.Vk(a.f,b,1);return true;}if(d==5){c&&o_.Vk(a.f,b,-1);return true;}if(d==7||d==8){c&&o_.Vk(a.f,b,1);return true;}}}return false;};o_.Wd=function Wd(a,b,c,d){var e;for(e=0;e<o_.Am(a.f,b);e++)if(d[o_.Bm(a.f,b,e)]==1&&o_.zm(a.f,b,e)!=c)return e;return -1;};o_.Xd=function Xd(a,b){var c;for(c=0;c<o_.Am(a.f,b);c++)if(o_.xk(a.f,o_.zm(a.f,b,c)))return true;return false;};o_.Yd=function Yd(a,b,c){var d;for(d=0;d<o_.Am(a.f,b);d++)if(c[o_.Bm(a.f,b,d)]>1)return true;return false;};o_.Zd=function Zd(a,b){var c;for(c=0;c<o_.Am(a.f,b);c++)if(a.e[o_.Bm(a.f,b,c)])return true;return false;};o_.$d=function $d(a,b,c){var d,e,f,g,h,i,j,k,l,m;o_.Jr(a.f,1);if(b!=null){a.e=b;}else {a.e=OI(h_.DN,C0,5,a.f.e,16,1);for(e=0;e<a.f.e;e++){if(o_.Yj(a.f,e)==64){a.e[e]=true;o_.wl(a.f,e,1);}}}a.g=0;a.d=OI(h_.DN,C0,5,a.f.d,16,1);for(f=0;f<a.f.e;f++){if(a.e[f]){++a.c;for(h=0;h<2;h++){if(!a.d[o_.Nj(a.f,h,f)]){a.d[o_.Nj(a.f,h,f)]=true;++a.b;}}}}if(a.c==0)return true;a.a=false;o_.ge(a,c);a.f.I&&o_.ae(a);m=new o_.aq(a.f,1);c&&o_.Rd(a,m);o_.he(a,m);o_.de(a,m);o_.fe(a);o_.be(a);while(o_.ce(a,m))o_.be(a);while(a.c!=0){g=false;if(!g){for(k=0;k<m.i.a.length;k++){if(l_.Th(m.j,k).length==6){j=true;l=l_.Th(m.j,k);for(i=0;i<6;i++){if(!a.e[l[i]]){j=false;break;}}if(j){for(h=0;h<6;h+=2)o_._d(a,l[h]);g=true;break;}}}}if(!g){for(d=0;d<a.f.e;d++){if(a.e[d]){o_._d(a,d);o_.be(a);g=true;break;}}}}return a.b==a.g;};o_._d=function _d(a,b){var c,d,e,f;if(o_.Yj(a.f,b)==1){o_.wl(a.f,b,2);a.g+=2;}for(e=0;e<2;e++){c=o_.Nj(a.f,e,b);for(f=0;f<o_.Am(a.f,c);f++){d=o_.Bm(a.f,c,f);if(a.e[d]){a.e[d]=false;--a.c;}}}};o_.ae=function ae(a){var b,c,d,e,f,g,h,i;for(c=0;c<a.f.e;c++){if(a.e[c]){for(e=0;e<2;e++){h=o_.Nj(a.f,e,c);b=false;for(g=0;g<o_.Am(a.f,h);g++){if(c!=o_.Bm(a.f,h,g)&&a.e[o_.Bm(a.f,h,g)]){b=true;break;}}if(!b){i=c;d=o_.Nj(a.f,1-e,c);while(i!=-1){a.e[i]=false;--a.c;o_.wl(a.f,i,64);i=-1;h=d;for(f=0;f<o_.Am(a.f,h);f++){if(a.e[o_.Bm(a.f,h,f)]){if(i==-1){i=o_.Bm(a.f,h,f);d=o_.zm(a.f,h,f);}else {h=-1;i=-1;break;}}}}break;}}}}};o_.be=function be(a){var b,c,d,e,f,g,h;do{h=false;for(c=0;c<a.f.e;c++){if(a.e[c]){f=false;for(e=0;e<2;e++){d=o_.Nj(a.f,e,c);b=false;for(g=0;g<o_.Am(a.f,d);g++){if(c!=o_.Bm(a.f,d,g)&&a.e[o_.Bm(a.f,d,g)]){b=true;break;}}if(!b){f=true;break;}}if(f){h=true;o_._d(a,c);}}}}while(h);};o_.ce=function ce(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;o=OI(h_.hK,k0,5,a.f.e,15,1);for(m=0;m<b.i.a.length;m++){n=l_.Th(b.j,m);l=true;for(k=0;k<n.length;k++){if(!a.e[n[k]]){l=false;break;}}if(l)for(j=0;j<n.length;j++)++o[n[j]];}i=a.c;for(f=0;f<a.f.e;f++){if(o[f]==1){for(j=0;j<2&&a.e[f];j++){c=o_.Nj(a.f,j,f);d=o_.Nj(a.f,1-j,f);if(o_.Yd(a,c,o)&&!o_.Yd(a,d,o)){while(-1!=(h=o_.Wd(a,d,c,o))){e=o_.zm(a.f,d,h);g=o_.Bm(a.f,d,h);if(!a.e[g])break;o_._d(a,g);h=o_.Wd(a,e,d,o);if(h==-1)break;c=e;d=o_.zm(a.f,e,h);}}}}}return i!=a.c;};o_.de=function de(a,b){var c;for(c=0;c<a.f.e;c++){if(a.e[c]&&o_.Yp(b,c)){o_.ee(a,o_.Nj(a.f,0,c));o_.ee(a,o_.Nj(a.f,1,c));}}};o_.ee=function ee(a,b){var c,d;if(a.d[b]){a.d[b]=false;--a.b;}for(d=0;d<o_.Am(a.f,b);d++){c=o_.Bm(a.f,b,d);if(a.e[c]){a.e[c]=false;--a.c;}}};o_.fe=function fe(a){var b,c,d,e,f;for(c=0;c<a.f.e;c++){if(o_.Vj(a.f,c)==2){for(e=0;e<2;e++){b=o_.Nj(a.f,e,c);if(o_.Ij(a.f,b)<=8){for(f=0;f<o_.Am(a.f,b);f++){d=o_.Bm(a.f,b,f);if(a.e[d]){o_.ee(a,b);break;}}}}}}};o_.ge=function ge(a,b){var c;for(c=0;c<a.f.d;c++)a.d[c]&&o_.Om(a.f,c)==0&&(!b||!o_.uk(a.f,c)||o_.rj(a.f,c)>0)&&o_.ee(a,c);};o_.he=function he(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;for(k=0;k<b.i.a.length;k++){n=l_.Th(b.j,k).length;if(n==3||n==5||n==7){l=l_.Th(b.i,k);for(d=0;d<n;d++){c=l[d];o_.Zd(a,c)&&(n==5?(o_.Ij(a.f,c)==6&&o_.rj(a.f,c)==-1&&o_.mm(a.f,c)==3||o_.Ij(a.f,c)==7&&o_.rj(a.f,c)==0&&o_.mm(a.f,c)==3||o_.Ij(a.f,c)==8&&o_.rj(a.f,c)==0&&o_.Am(a.f,c)==2||o_.Ij(a.f,c)==16&&o_.rj(a.f,c)==0&&o_.Am(a.f,c)==2||o_.Ij(a.f,c)==34&&o_.rj(a.f,c)==0&&o_.Am(a.f,c)==2)&&o_.ee(a,c):(o_.Ij(a.f,c)==5&&o_.rj(a.f,c)==0&&o_.mm(a.f,c)==3||o_.Ij(a.f,c)==6&&o_.rj(a.f,c)==1)&&o_.ee(a,c));}}}for(j=0;j<b.i.a.length;j++){if(l_.Th(b.j,j).length==5){m=l_.Th(b.j,j);f=true;for(e=0;e<m.length;e++){if(!a.e[m[e]]){f=false;break;}}if(f){l=l_.Th(b.i,j);h=0;g=-1;for(d=0;d<m.length;d++){if(o_.rj(a.f,l[d])==-1&&o_.Ij(a.f,l[d])==6){i=o_.mm(a.f,l[d])==3?3:o_.nm(a.f,l[d])==3?2:1;if(h<i){h=i;g=l[d];}}}g!=-1&&o_.ee(a,g);}}}};o_.ie=function ie(a){this.f=a;};xO(72,1,{},o_.ie);_.a=false;_.b=0;_.c=0;_.g=0;h_.mK=jQ(72);o_.je=function je(a,b,c,d,e,f,g){var h,i,j,k;j=0;for(i=0;i<a.N.d;i++)(o_.Dj(a.N,a.u[i])&e)!=0&&++j;if(j==0)return false;if(b>15){o_.ff(a,c);b-=16;}o_.$e(a,1,1);o_.$e(a,b,4);o_.$e(a,j,d);for(h=0;h<a.N.d;h++){k=o_.Dj(a.N,a.u[h])&e;if(k!=0){o_.$e(a,h,d);f!=1&&o_.$e(a,k>>g,f);}}return true;};o_.ke=function ke(a,b,c,d,e,f,g){var h,i,j,k;j=0;for(i=0;i<a.N.e;i++)(o_.Xj(a.N,a.v[i])&e)!=0&&++j;if(j==0)return false;if(b>15){o_.ff(a,c);b-=16;}o_.$e(a,1,1);o_.$e(a,b,4);o_.$e(a,j,d);for(h=0;h<a.N.e;h++){k=o_.Xj(a.N,a.v[h])&e;if(k!=0){o_.$e(a,h,d);f!=1&&o_.$e(a,k>>g,f);}}return true;};o_.le=function le(a){var b,c,d,e,f,g;while(true){f=OI(h_.DN,C0,5,a.Q+1,16,1);d=-1;for(c=0;c<a.N.d;c++){if(o_.Om(a.N,c)!=0){f[a.c[c]]&&d<a.c[c]&&(d=a.c[c]);f[a.c[c]]=true;}}if(d==-1)break;e=0;for(b=0;b<a.N.d;b++){g=0;a.c[b]==d&&(g=++e);o_._f(a.b[b],b);o_.Yf(a.b[b],16,WN(a.c[b]));o_.Yf(a.b[b],8,h_.SN(g));}a.Q=o_.Je(a);}};o_.me=function me(a,b,c){var d,e,f,g,h;if(o_.Ij(a.N,b)!=6&&o_.Ij(a.N,b)!=7)return false;e=o_.zm(a.N,b,0);f=o_.zm(a.N,b,1);if(o_.qm(a.N,e)!=1||o_.qm(a.N,f)!=1)return false;if(o_.Am(a.N,e)==1||o_.Am(a.N,f)==1)return false;if(o_.mm(a.N,e)>3||o_.mm(a.N,f)>3)return false;g=new o_.Fi(a.N,a.c,b,e);if(g.f&&!c)return false;h=new o_.Fi(a.N,a.c,b,f);if(h.f&&!c)return false;if(g.f&&h.f)return false;if(c){g.f&&g.c&&(a.S[b]=true);h.f&&h.c&&(a.S[b]=true);}d=a.fb?o_.oe(a,g,h):o_.ne(g,h);if(c){if(a.V&&(a.M&2)!=0||!a.V&&(a.M&4)!=0){if(g.f){if(d==1){o_.Zf(a.b[g.b],64);o_.Zf(a.b[g.d],16);}else {o_.Zf(a.b[g.b],16);o_.Zf(a.b[g.d],64);}}if(h.f){if(d==2){o_.Zf(a.b[h.b],64);o_.Zf(a.b[h.d],16);}else {o_.Zf(a.b[h.b],16);o_.Zf(a.b[h.d],64);}}}}else {a._[b]=d;}return true;};o_.ne=function ne(a,b){var c,d,e;d=o_.Ei(a);e=o_.Ei(b);if(d==-1||e==-1||(d+e&1)==0)return 3;c=0;switch(d+e){case 3:case 7:c=2;break;case 5:c=1;}return c;};o_.oe=function oe(a,b,c){var d,e;d=OI(h_.hK,k0,5,4,15,1);d[0]=b.b;d[1]=b.a;d[2]=c.a;d[3]=c.b;e=o_.Xi(a.N,d);if($wnd.Math.abs(e)<0.3||$wnd.Math.abs(e)>c1)return 3;return e<0?2:1;};o_.pe=function pe(a,b,c){var d,e,f,g,h;if(!o_.nn(a.N,b))return false;d=o_.Nj(a.N,0,b);e=o_.Nj(a.N,1,b);g=new o_.Fi(a.N,a.c,d,e);if(g.f&&!c)return false;h=new o_.Fi(a.N,a.c,e,d);if(h.f&&!c)return false;if(g.f&&h.f)return false;if(c){g.f&&(a.R[b]=o_.uf(a,e));h.f&&(a.R[b]=o_.uf(a,d));}f=a.fb?o_.re(a,g,h):o_.qe(g,h);if(c){if(a.V&&(a.M&2)!=0||!a.V&&(a.M&4)!=0){if(g.f){if(f==2){o_.Zf(a.b[g.b],4);o_.Zf(a.b[g.d],1);}else {o_.Zf(a.b[g.b],1);o_.Zf(a.b[g.d],4);}}if(h.f){if(f==2){o_.Zf(a.b[h.b],4);o_.Zf(a.b[h.d],1);}else {o_.Zf(a.b[h.b],1);o_.Zf(a.b[h.d],4);}}}}else {a.j[b]=f;}return true;};o_.qe=function qe(a,b){var c,d,e;d=o_.Ei(a);e=o_.Ei(b);if(d==-1||e==-1||(d+e&1)==0)return 3;c=0;switch(d+e){case 3:case 7:c=1;break;case 5:c=2;}return c;};o_.re=function re(a,b,c){var d,e;d=OI(h_.hK,k0,5,4,15,1);d[0]=b.b;d[1]=b.a;d[2]=c.a;d[3]=c.b;e=o_.Xi(a.N,d);if($wnd.Math.abs(e)<0.3||$wnd.Math.abs(e)>c1)return 3;return e<0?1:2;};o_.se=function se(a,b,c){var d,e,f,g,h;if(a.j[b]!=0)return false;if(o_.Vj(a.N,b)==1)return o_.pe(a,b,c);if(o_.Vj(a.N,b)!=2)return false;if(o_.mn(a.N,b))return false;e=o_.Nj(a.N,0,b);f=o_.Nj(a.N,1,b);if(o_.Am(a.N,e)==1||o_.Am(a.N,f)==1)return false;if(o_.Am(a.N,e)>3||o_.Am(a.N,f)>3)return false;if(o_.qm(a.N,e)==2||o_.qm(a.N,f)==2)return false;g=new o_.Fi(a.N,a.c,f,e);if(g.f&&!c)return false;h=new o_.Fi(a.N,a.c,e,f);if(h.f&&!c)return false;if(g.f&&h.f)return false;if(c){g.f&&g.c&&(a.R[b]=true);h.f&&h.c&&(a.R[b]=true);}d=o_.tk(a.N,b)?3:a.fb?o_.ue(a,g,h):o_.te(g,h);if(c){if((a.M&2)!=0){if(g.f){if(d==1){o_.Zf(a.b[g.b],4);o_.Zf(a.b[g.d],1);}else if(d==2){o_.Zf(a.b[g.b],1);o_.Zf(a.b[g.d],4);}}if(h.f){if(d==1){o_.Zf(a.b[h.b],4);o_.Zf(a.b[h.d],1);}else if(d==2){o_.Zf(a.b[h.b],1);o_.Zf(a.b[h.d],4);}}}}else {a.j[b]=d;}return true;};o_.te=function te(a,b){if(o_.Ei(a)==-1||o_.Ei(b)==-1)return 3;if(((o_.Ei(a)|o_.Ei(b))&1)!=0)return 3;return o_.Ei(a)==o_.Ei(b)?1:2;};o_.ue=function ue(a,b,c){var d,e,f,g,h,i,j;f=OI(h_.fK,B0,5,3,15,1);f[0]=o_.Fj(a.N,c.a)-o_.Fj(a.N,b.a);f[1]=o_.Gj(a.N,c.a)-o_.Gj(a.N,b.a);f[2]=o_.Hj(a.N,c.a)-o_.Hj(a.N,b.a);i=OI(h_.fK,B0,5,3,15,1);i[0]=o_.Fj(a.N,b.b)-o_.Fj(a.N,b.a);i[1]=o_.Gj(a.N,b.b)-o_.Gj(a.N,b.a);i[2]=o_.Hj(a.N,b.b)-o_.Hj(a.N,b.a);j=OI(h_.fK,B0,5,3,15,1);j[0]=o_.Fj(a.N,c.b)-o_.Fj(a.N,c.a);j[1]=o_.Gj(a.N,c.b)-o_.Gj(a.N,c.a);j[2]=o_.Hj(a.N,c.b)-o_.Hj(a.N,c.a);g=OI(h_.fK,B0,5,3,15,1);g[0]=f[1]*i[2]-f[2]*i[1];g[1]=f[2]*i[0]-f[0]*i[2];g[2]=f[0]*i[1]-f[1]*i[0];h=OI(h_.fK,B0,5,3,15,1);h[0]=f[1]*g[2]-f[2]*g[1];h[1]=f[2]*g[0]-f[0]*g[2];h[2]=f[0]*g[1]-f[1]*g[0];d=(i[0]*h[0]+i[1]*h[1]+i[2]*h[2])/($wnd.Math.sqrt(i[0]*i[0]+i[1]*i[1]+i[2]*i[2])*$wnd.Math.sqrt(h[0]*h[0]+h[1]*h[1]+h[2]*h[2]));e=(j[0]*h[0]+j[1]*h[1]+j[2]*h[2])/($wnd.Math.sqrt(j[0]*j[0]+j[1]*j[1]+j[2]*j[2])*$wnd.Math.sqrt(h[0]*h[0]+h[1]*h[1]+h[2]*h[2]));return d<0^e<0?1:2;};o_.ve=function ve(a,b){var c,d,e,f;c=o_.pj(a.N,b);d=o_.Mm(a.N,b,false);e=o_.Mm(a.N,b,true);f=-1;if(d!=e){c!=-1&&c>d?f=c<<24>>24:f=d<<24>>24;}else if(c!=-1){(c>e||c<e&&c>=o_.Sm(a.N,b))&&(f=c<<24>>24);}else if(!o_.Pn(a.N,b)&&o_.Em(a.N,b)!=0){f=o_.Sm(a.N,b);f-=o_.ak(a.N,b,f);}o_.Qe(a,b,f);return f;};o_.we=function we(a){var b,c,d,e,f,g,h,i,j,k,l;d=OI(h_.hK,k0,5,a.K,15,1);for(b=0;b<a.N.d;b++){k=o_.Am(a.N,b)+o_.Pm(a.N,b);j=0;for(f=0;f<o_.nm(a.N,b);f++){if(f<o_.Am(a.N,b)||f>=o_.mm(a.N,b)){l=2*a.c[o_.zm(a.N,b,f)];c=o_.Bm(a.N,b,f);o_.Vj(a.N,c)==2&&(o_.mn(a.N,c)||++l);for(h=0;h<j;h++)if(l<d[h])break;for(i=j;i>h;i--)d[i]=d[i-1];d[h]=l;++j;}}o_._f(a.b[b],b);o_.Yf(a.b[b],16,WN(a.c[b]));for(g=k;g<a.K;g++)o_.Yf(a.b[b],17,0);for(e=0;e<k;e++)o_.Yf(a.b[b],17,h_.SN(d[e]));}};o_.xe=function xe(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;if(a._[b]!=0)return false;if(o_.Ij(a.N,b)!=5&&o_.Ij(a.N,b)!=6&&o_.Ij(a.N,b)!=7&&o_.Ij(a.N,b)!=14&&o_.Ij(a.N,b)!=15&&o_.Ij(a.N,b)!=16)return false;if(o_.qm(a.N,b)!=0){if(o_.on(a.N,b))return o_.me(a,b,c);if(o_.Ij(a.N,b)!=15&&o_.Ij(a.N,b)!=16)return false;}if(o_.Am(a.N,b)<3||o_.mm(a.N,b)>4)return false;if(o_.rj(a.N,b)>0&&o_.Ij(a.N,b)==6)return false;if(o_.Ij(a.N,b)==5&&o_.mm(a.N,b)!=4)return false;if(o_.Ij(a.N,b)==7&&!a.O[b])return false;n=OI(h_.hK,k0,5,4,15,1);o=OI(h_.hK,k0,5,4,15,1);j=OI(h_.DN,C0,5,4,16,1);for(h=0;h<o_.mm(a.N,b);h++){f=-1;e=0;for(i=0;i<o_.mm(a.N,b);i++){if(!j[i]){if(f<a.c[o_.zm(a.N,b,i)]){f=a.c[o_.zm(a.N,b,i)];e=i;}}}n[h]=e;o[h]=f;j[e]=true;}if(o_.mm(a.N,b)==4&&o[0]==o[1]&&o[2]==o[3])return false;if(o_.mm(a.N,b)==4&&(o[0]==o[2]||o[1]==o[3]))return false;if(o_.mm(a.N,b)==3&&o[0]==o[2])return false;k=0;l=0;m=false;for(g=1;g<o_.mm(a.N,b);g++){if(o[g-1]==o[g]){if(!c||o[g]==0)return false;k=o_.zm(a.N,b,n[g-1]);l=o_.zm(a.N,b,n[g]);o_.xn(a.N,o_.Bm(a.N,b,n[g]))&&(a.S[b]=true);m=true;}}if(c&&!m)return false;d=a.fb?o_.ze(a,b,n):o_.ye(a,b,n);if(c){if(a.V&&(a.M&2)!=0||!a.V&&(a.M&4)!=0){if(d==1){o_.Zf(a.b[k],L0);o_.Zf(a.b[l],256);}else if(d==2){o_.Zf(a.b[k],256);o_.Zf(a.b[l],L0);}}}else {a._[b]=d;}return true;};o_.ye=function ye(a,b,c){var d,e,f,g,h,i,j,k,l,m;m=XI(II(h_.hK,2),d1,6,0,[XI(II(h_.hK,1),k0,5,15,[2,1,2,1]),XI(II(h_.hK,1),k0,5,15,[1,2,2,1]),XI(II(h_.hK,1),k0,5,15,[1,1,2,2]),XI(II(h_.hK,1),k0,5,15,[2,1,1,2]),XI(II(h_.hK,1),k0,5,15,[2,2,1,1]),XI(II(h_.hK,1),k0,5,15,[1,2,1,2])]);d=OI(h_.fK,B0,5,o_.mm(a.N,b),15,1);for(g=0;g<o_.mm(a.N,b);g++)d[g]=o_.Mj(a.N,o_.zm(a.N,b,c[g]),b);j=o_.Gm(a.N,b,c,d,null)<<24>>24;if(j!=3)return j;k=0;l=0;for(h=0;h<o_.mm(a.N,b);h++){e=o_.Bm(a.N,b,c[h]);if(o_.Nj(a.N,0,e)==b){if(o_.Yj(a.N,e)==9){l!=0&&o_.Fl(a.N,b);k=h;l=1;}if(o_.Yj(a.N,e)==17){l!=0&&o_.Fl(a.N,b);k=h;l=2;}}}if(l==0)return 3;for(f=1;f<o_.mm(a.N,b);f++)d[f]<d[0]&&(d[f]+=G0);if(o_.mm(a.N,b)==3){switch(k){case 0:(d[1]<d[2]&&d[2]-d[1]<H0||d[1]>d[2]&&d[1]-d[2]>H0)&&(l=3-l);break;case 1:d[2]-d[0]>H0&&(l=3-l);break;case 2:d[1]-d[0]<H0&&(l=3-l);}return l==1?2:1;}i=0;d[1]<=d[2]&&d[2]<=d[3]?i=0:d[1]<=d[3]&&d[3]<=d[2]?i=1:d[2]<=d[1]&&d[1]<=d[3]?i=2:d[2]<=d[3]&&d[3]<=d[1]?i=3:d[3]<=d[1]&&d[1]<=d[2]?i=4:d[3]<=d[2]&&d[2]<=d[1]&&(i=5);return m[i][k]==l?2:1;};o_.ze=function ze(a,b,c){var d,e,f,g,h,i;d=OI(h_.hK,k0,5,4,15,1);for(h=0;h<o_.mm(a.N,b);h++)d[h]=o_.zm(a.N,b,c[h]);o_.mm(a.N,b)==3&&(d[3]=b);e=MI(h_.fK,[K_,B0],[14,5],15,[3,3],2);for(g=0;g<3;g++){e[g][0]=o_.Fj(a.N,d[g+1])-o_.Fj(a.N,d[0]);e[g][1]=o_.Gj(a.N,d[g+1])-o_.Gj(a.N,d[0]);e[g][2]=o_.Hj(a.N,d[g+1])-o_.Hj(a.N,d[0]);}i=OI(h_.fK,B0,5,3,15,1);i[0]=e[0][1]*e[1][2]-e[0][2]*e[1][1];i[1]=e[0][2]*e[1][0]-e[0][0]*e[1][2];i[2]=e[0][0]*e[1][1]-e[0][1]*e[1][0];f=(e[2][0]*i[0]+e[2][1]*i[1]+e[2][2]*i[2])/($wnd.Math.sqrt(e[2][0]*e[2][0]+e[2][1]*e[2][1]+e[2][2]*e[2][2])*$wnd.Math.sqrt(i[0]*i[0]+i[1]*i[1]+i[2]*i[2]));return f>0?1:2;};o_.Ae=function Ae(a){var b,c;b=0;l_.dX(a.b);for(c=0;c<a.b.length;c++){(c==0||o_.$f(a.b[c],a.b[c-1])!=0)&&++b;a.c[a.b[c].a]=b;}return b;};o_.Be=function Be(a){var b,c,d,e,f,g,h,i,j,k,l,m;if(a.t)return;a.t=new l_.gi();k=0;l=OI(h_.hK,k0,5,a.N.d,15,1);g=OI(h_.hK,k0,5,a.N.d,15,1);i=OI(h_.hK,k0,5,a.N.e,15,1);for(b=0;b<a.N.d;b++){if(l[b]==0&&(o_.wn(a.N,b)||o_.qm(a.N,b)==1)){g[0]=b;h=1;j=0;l[b]=++k;c=OI(h_.DN,C0,5,a.N.e,16,1);for(f=0;f<h;f++){for(m=0;m<o_.Am(a.N,g[f]);m++){e=o_.Bm(a.N,g[f],m);if(o_.xn(a.N,e)||o_.Vj(a.N,e)==2||o_.nn(a.N,e)){d=o_.zm(a.N,g[f],m);if(!c[e]){i[j++]=e;c[e]=true;}if(l[d]==0){g[h++]=d;l[d]=k;}}}}l_.Oh(a.t,new o_.cg(g,h,i,j));}}};o_.Ce=function Ce(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;a.O=OI(h_.DN,C0,5,a.N.d,16,1);for(b=0;b<a.N.d;b++){if(o_.Ij(a.N,b)==7){if(o_.Am(a.N,b)==4){a.O[b]=true;continue;}if(o_.Am(a.N,b)==3){if(o_.rj(a.N,b)==1){a.O[b]=true;continue;}if(o_.sn(a.N,b))continue;if((a.M&32)!=0){a.O[b]=true;continue;}if(o_.sm(a.N,b)!=3)continue;v=o_.um(a.N,b);if(v>7)continue;t=o_.Ym(a.N);u=0;while(u<t.i.a.length){if(l_.Th(t.j,u).length==v&&o_.Vp(t,u,b))break;++u;}i=-1;j=-1;for(l=0;l<3;l++){h=o_.Bm(a.N,b,l);if(!o_.Wp(t,u,h)){i=o_.zm(a.N,b,l);j=h;break;}}n=OI(h_.DN,C0,5,a.N.e,16,1);n[j]=true;o=OI(h_.hK,k0,5,11,15,1);p=o_.Tm(a.N,o,i,b,10,n);if(p==-1)continue;d=1;while(!o_.Vp(t,u,o[d]))++d;c=p-d;e=o[d];if(v==6&&c==2&&d==3){if(o_.sm(a.N,o[1])>=3){m=false;s=l_.Th(t.i,u);for(k=0;k<6;k++){if(b==s[k]){r=o_._p(t,u,e==s[o_._p(t,u,k+2)]?k-2:k+2);q=s[r];o_.sm(a.N,q)>=3&&o_.Wm(a.N,o[1],q,2,null)==2&&(m=true);break;}}if(m){a.O[b]=true;continue;}}}f=o_.qm(a.N,e)==1||o_.ln(a.N,e)||o_.sn(a.N,e);g=!f&&o_.Ij(a.N,e)==7&&o_.rj(a.N,e)!=1;if(c==1){!f&&!g&&v<=4&&d<=3&&(a.O[b]=true);continue;}switch(v){case 4:!f&&!g&&d<=4&&(a.O[b]=true);break;case 5:g?d<=3&&(a.O[b]=true):f||d<=4&&(a.O[b]=true);break;case 6:c==2?f?d<=4&&(a.O[b]=true):g||d<=3&&(a.O[b]=true):c==3&&(f?d<=6&&(a.O[b]=true):d<=4&&(a.O[b]=true));break;case 7:c==3&&d<=3&&(a.O[b]=true);}}}}};o_.De=function De(a,b){var c,d,e,f;e=false;for(d=0;d<a.N.e;d++)if(o_.se(a,d,false)){a.n[d]=a.H;b&&o_.Re(a,d);e=true;}f=false;for(c=0;c<a.N.d;c++)if(o_.xe(a,c,false)){a.eb[c]=a.H;b&&o_.Se(a,c);f=true;}f&&(a.H=!a.H);return e||f;};o_.Ee=function Ee(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B;s=OI(h_.DN,C0,5,a.N.d,16,1);t=OI(h_.DN,C0,5,a.N.e,16,1);b=0;v=false;if((a.M&128)!=0){a.U=OI(h_.hK,k0,5,a.N.d,15,1);a.T=OI(h_.hK,k0,5,a.N.e,15,1);}for(d=0;d<a.N.d;d++){if(a.S[d]){if(!a.bb[d]){if(o_.xe(a,d,false)){a.bb[d]=true;s[d]=true;++b;}}}}for(f=0;f<a.N.e;f++){if(a.R[f]){if(!a.k[f]){if(o_.se(a,f,false)){a.k[f]=true;t[f]=true;++b;}}}}if(b==1){for(c=0;c<a.N.d;c++){if(s[c]){a._[c]=0;break;}}for(e=0;e<a.N.e;e++){if(t[e]){a.j[e]=0;break;}}}else if(b>1){o_.Be(a);a.P=0;for(h=new l_.KW(a.t);h.a<h.c.a.length;){g=l_.JW(h);u=0;w=0;k=0;j=0;l=-1;i=-1;for(o=0;o<g.a.length;o++){if(s[g.a[o]]){++u;if(a._[g.a[o]]==1||a._[g.a[o]]==2){++w;v=true;if(l<a.c[g.a[o]]){l=a.c[g.a[o]];k=g.a[o];}}}}for(p=0;p<g.b.length;p++){if(t[g.b[p]]){++u;A=a.c[o_.Nj(a.N,0,g.b[p])];B=a.c[o_.Nj(a.N,1,g.b[p])];m=A>B?(A<<16)+B:(B<<16)+A;if(a.j[g.b[p]]==1||a.j[g.b[p]]==2){++w;v=true;if(i<m){i=m;j=g.b[p];}}}}if(u==0)continue;if(u==1){for(q=0;q<g.a.length;q++)s[g.a[q]]&&(a._[g.a[q]]=0);for(n=0;n<g.b.length;n++)t[g.b[n]]&&(a.j[g.b[n]]=0);}else {if(w==1){for(q=0;q<g.a.length;q++)s[g.a[q]]&&(a._[g.a[q]]=3);for(n=0;n<g.b.length;n++)t[g.b[n]]&&(a.j[g.b[n]]=3);}else {if((a.M&128)!=0){++a.P;for(q=0;q<g.a.length;q++)s[g.a[q]]&&(a.U[g.a[q]]=a.P);for(n=0;n<g.b.length;n++)t[g.b[n]]&&(a.T[g.b[n]]=a.P);}r=false;l!=-1?a._[k]==2&&(r=true):a.j[j]==2&&(r=true);if(r){for(q=0;q<g.a.length;q++){if(s[g.a[q]]){switch(a._[g.a[q]]){case 1:a._[g.a[q]]=2;break;case 2:a._[g.a[q]]=1;}}}for(n=0;n<g.b.length;n++){if(t[g.b[n]]){switch(a.j[g.b[n]]){case 1:a.j[g.b[n]]=2;break;case 2:a.j[g.b[n]]=1;}}}}}}}}return v;};o_.Fe=function Fe(a,b){var c,d,e,f,g,h,i,j,k,l,m;f=MI(h_.hK,[d1,k0],[6,5],15,[2,32],2);for(g=0;g<2;g++){c=OI(h_.hK,d1,6,32,0,2);m=0;for(e=0;e<32;e++){if(b[g][e]!=null){k=b[g][e].length;c[e]=OI(h_.hK,k0,5,k,15,1);for(h=0;h<k;h++)c[e][h]=a.c[b[g][e][h]];n_.V$(c[e]).sort(n_.V$(AO(l_.pX.prototype.Ub,l_.pX,[])));++m;}}for(l=m;l>0;l--){j=0;i=null;for(d=0;d<32;d++){if(c[d]!=null){if(i==null||i.length<c[d].length){i=c[d];j=d;}else if(i.length==c[d].length){for(h=i.length-1;h>=0;h--){if(i[h]<c[d][h]){i=c[d];j=d;break;}}}}}f[g][j]=l;c[j]=null;}}return f;};o_.Ge=function Ge(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;l=false;if(a.N.I){for(j=0;j<a.N.e;j++){if(o_.Xj(a.N,j)!=0){l=true;break;}}}a.K=2;for(c=0;c<a.N.d;c++)a.K=$wnd.Math.max(a.K,o_.Am(a.N,c)+o_.Pm(a.N,c));i=$wnd.Math.max(2,l?(78+a.K*37)/63|0:(78+a.K*21)/63|0);a.c=OI(h_.hK,k0,5,a.N.o,15,1);a.b=OI(h_.rK,e1,74,a.N.d,0,1);for(d=0;d<a.N.d;d++)a.b[d]=new o_.ag(i);h=false;for(e=0;e<a.N.d;e++){o_._f(a.b[e],e);(o_.Dj(a.N,e)&1)!=0||o_.yj(a.N,e)!=null?o_.Yf(a.b[e],8,6):o_.Yf(a.b[e],8,WN(o_.Ij(a.N,e)));o_.Yf(a.b[e],8,WN(o_.Bj(a.N,e)));o_.Yf(a.b[e],2,WN(o_.qm(a.N,e)));o_.Yf(a.b[e],4,WN(o_.Am(a.N,e)+o_.Pm(a.N,e)));(o_.Dj(a.N,e)&1)!=0?o_.Yf(a.b[e],4,8):o_.Yf(a.b[e],4,WN(8+o_.rj(a.N,e)));o_.Yf(a.b[e],5,WN($wnd.Math.min(31,o_.um(a.N,e))));o_.Yf(a.b[e],4,WN(o_.ve(a,e)+1));o_.Yf(a.b[e],2,WN(o_.Ej(a.N,e)>>4));if(a.N.I){o_.Yf(a.b[e],30,WN(o_.Dj(a.N,e)));o_.yj(a.N,e)!=null&&(h=true);}}a.Q=o_.Je(a);if(a.Q<a.N.d){for(b=0;b<a.N.d;b++){o_._f(a.b[b],b);o_.Yf(a.b[b],16,WN(a.c[b]));m=OI(h_.hK,k0,5,o_.Am(a.N,b),15,1);for(o=0;o<o_.Am(a.N,b);o++){m[o]=a.c[o_.zm(a.N,b,o)]<<5;m[o]|=$wnd.Math.min(31,o_.ym(a.N,o_.Bm(a.N,b,o)));}n_.V$(m).sort(n_.V$(AO(l_.pX.prototype.Ub,l_.pX,[])));for(p=a.K;p>m.length;p--)o_.Yf(a.b[b],21,0);for(n=m.length-1;n>=0;n--)o_.Yf(a.b[b],21,h_.SN(m[n]));}a.Q=o_.Je(a);}if(h&&a.Q<a.N.d){for(b=0;b<a.N.d;b++){o_._f(a.b[b],b);o_.Yf(a.b[b],16,WN(a.c[b]));g=o_.yj(a.N,b);s=g==null?0:$wnd.Math.min(12,g.length);for(o=12;o>s;o--)o_.Yf(a.b[b],8,0);for(n=s-1;n>=0;n--)o_.Yf(a.b[b],8,h_.SN(g[n]));}a.Q=o_.Je(a);}if(l&&a.Q<a.N.d){for(b=0;b<a.N.d;b++){o_._f(a.b[b],b);o_.Yf(a.b[b],16,WN(a.c[b]));k=OI(h_.iK,f1,5,o_.Am(a.N,b)+o_.Pm(a.N,b),14,1);q=0;for(o=0;o<o_.nm(a.N,b);o++){if(o<o_.Am(a.N,b)||o>=o_.mm(a.N,b)){k[q]=WN(a.c[o_.zm(a.N,b,o)]);k[q]=eO(k[q],21);k[q]=dO(k[q],WN(o_.Xj(a.N,o_.Bm(a.N,b,o))));++q;}}n_.V$(k).sort(n_.V$(AO(l_.mX.prototype.Vb,l_.mX,[])));for(p=a.K;p>k.length;p--)o_.Yf(a.b[b],37,0);for(n=k.length-1;n>=0;n--)o_.Yf(a.b[b],37,k[n]);}a.Q=o_.Je(a);}if((a.M&8)!=0&&a.Q<a.N.d){r=new o_.Hr();for(f=0;f<a.N.d;f++)o_.tj(a.N,f)!=null&&o_.Fr(r,o_.tj(a.N,f));for(b=0;b<a.N.d;b++){t=o_.tj(a.N,b)==null?0:1+o_.Gr(r,o_.tj(a.N,b));o_._f(a.b[b],b);o_.Yf(a.b[b],16,WN(a.c[b]));o_.Yf(a.b[b],16,h_.SN(t));}a.Q=o_.Je(a);}if((a.M&16)!=0&&a.Q<a.N.d){for(b=0;b<a.N.d;b++){o_._f(a.b[b],b);o_.Yf(a.b[b],16,WN(a.c[b]));o_.Yf(a.b[b],1,WN(o_.Bk(a.N,b)?1:0));}a.Q=o_.Je(a);}(a.M&512)!=0&&a.N.I&&o_.le(a);};o_.He=function He(a){var b,c,d,e,f,g,h,i,j,k;f=0;for(c=0;c<a.N.d;c++)a.Z[c]!=0&&(a.Z[c]!=2||(a.M&256)==0)&&++f;if(f==0)return;k=OI(h_.hK,k0,5,f,15,1);f=0;for(d=0;d<a.N.d;d++){if(a.Z[d]!=0&&(a.Z[d]!=2||(a.M&256)==0)){k[f]=a.Z[d]<<29|a.Y[d]<<24|a.c[d]<<12|d;++f;}}n_.V$(k).sort(n_.V$(AO(l_.pX.prototype.Ub,l_.pX,[])));g=0;j=0;h=k[0]&g1;while(true){++j;if(j==k.length||h!=(k[j]&g1)){e=OI(h_.hK,k0,5,j-g,15,1);for(i=g;i<j;i++){b=k[i]&4095;e[i-g]=b;a.cb[b]=true;}l_.Oh(a.db,e);if(j==k.length)break;h=k[j]&g1;g=j;}}};o_.Ie=function Ie(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;h=false;for(i=0;i<a.db.a.length;i++){g=l_.Th(a.db,i);b=true;n=-1;j=false;for(l=0;l<g.length;l++){c=g[l];if(a._[c]==0){b=false;break;}if(a._[c]!=3){k=true;for(m=0;m<g.length;m++){if(m!=l&&a.c[c]==a.c[g[m]]){k=false;break;}}if(k&&n<a.c[c]){n=a.c[c];j=a._[c]==1;}}}if(b&&n!=-1){for(d=g,e=0,f=d.length;e<f;++e){c=d[e];(a._[c]==1||a._[c]==2)&&(a.ab[c]=j);a.cb[c]=false;}l_._h(a.db,g);h=true;--i;}}return h;};o_.Je=function Je(a){var b,c;b=o_.Ae(a);do{c=b;o_.we(a);b=o_.Ae(a);}while(c!=b);return b;};o_.Ke=function Ke(a){var b,c,d,e,f,g,h;a.S=OI(h_.DN,C0,5,a.N.d,16,1);a.R=OI(h_.DN,C0,5,a.N.e,16,1);if((a.M&6)!=0){for(b=0;b<a.N.d;b++){o_._f(a.b[b],b);o_.Yf(a.b[b],28,WN(a.c[b]<<12));}}if(a.Q<a.N.d){f=0;for(b=0;b<a.N.d;b++)o_.xe(a,b,true)&&++f;for(e=0;e<a.N.e;e++)o_.se(a,e,true)&&++f;}(a.M&6)!=0&&(a.Q=o_.Je(a));(a.M&1)!=0&&(a.d=l_.PW(a.c,a.N.d));while(a.Q<a.N.d){for(c=0;c<a.N.d;c++){o_._f(a.b[c],c);o_.Yf(a.b[c],17,WN(2*a.c[c]));}h=OI(h_.hK,k0,5,a.Q+1,15,1);for(d=0;d<a.N.d;d++)++h[a.c[d]];g=1;while(h[g]==1)++g;for(b=0;b<a.N.d;b++){if(a.c[b]==g){o_.Zf(a.b[b],1);break;}}a.Q=o_.Je(a);o_.Ie(a);!!a.L&&o_.ng(a.L,a.c);}o_.Ie(a);o_.Ee(a);o_.gf(a);};o_.Le=function Le(a){var b,c,d,e,f;f=a.Q;e=l_.PW(a.c,a.N.d);if(!a.N.I){o_.Ne(a);o_.Af(a,f,e);}a.Z=OI(h_.dK,j0,5,a.N.d,15,1);a.Y=OI(h_.dK,j0,5,a.N.d,15,1);for(c=0;c<a.N.d;c++){a.Z[c]=o_.wj(a.N,c)<<24>>24;a.Y[c]=o_.vj(a.N,c)<<24>>24;}a.i=OI(h_.dK,j0,5,a.N.e,15,1);a.g=OI(h_.dK,j0,5,a.N.e,15,1);for(d=0;d<a.N.e;d++){a.i[d]=o_.Sj(a.N,d)<<24>>24;a.g[d]=o_.Rj(a.N,d)<<24>>24;}o_.Me(a);a.V=false;a.I=OI(h_.DN,C0,5,a.N.d,16,1);for(b=0;b<a.N.d;b++){if(a._[b]!=0){a.I[b]=true;a.V=true;}}o_.Pe(a);a.L=null;a.$=OI(h_.DN,C0,5,a.N.d,16,1);if(a.V){a.L=new o_.tg(a.N,e,a.I,a._,a.j,a.Z,a.Y,a.eb,a.n,a.$);o_.og(a.L);}a.ab=OI(h_.DN,C0,5,a.N.d,16,1);a.cb=OI(h_.DN,C0,5,a.N.d,16,1);a.db=new l_.gi();o_.He(a);o_.Af(a,f,e);o_.Oe(a);!!a.L&&(a.G=o_.kg(a.L));o_.Ze(a);};o_.Me=function Me(a){var b,c,d,e,f,g;a.H=true;f=o_.De(a,false);while(a.Q<a.N.d&&f){for(b=0;b<a.N.d;b++){o_._f(a.b[b],b);o_.Yf(a.b[b],16,WN(a.c[b]));g=a._[b]<<7;if((a._[b]==1||a._[b]==2)&&a.Z[b]!=0){g|=a.Z[b]<<5;g|=a.Y[b];}o_.Yf(a.b[b],18,h_.SN(g<<9));}for(c=0;c<a.N.e;c++){d=a.j[c]<<7;if((a.j[c]==1||a.j[c]==2)&&o_.Yj(a.N,c)==1&&a.i[c]!=0){d|=a.i[c]<<5;d|=a.g[c];}o_.Zf(a.b[o_.Nj(a.N,0,c)],h_.SN(d));o_.Zf(a.b[o_.Nj(a.N,1,c)],h_.SN(d));}e=o_.Je(a);if(a.Q==e)break;a.Q=e;f=o_.De(a,false);}};o_.Ne=function Ne(a){var b,c,d,e;a.H=true;a.W=OI(h_.dK,j0,5,a.N.d,15,1);a.e=OI(h_.dK,j0,5,a.N.e,15,1);e=o_.De(a,true);while(a.Q<a.N.d&&e){for(b=0;b<a.N.d;b++){o_._f(a.b[b],b);o_.Yf(a.b[b],20,WN(a.c[b]<<4|a._[b]<<2));}for(c=0;c<a.N.e;c++){o_.Zf(a.b[o_.Nj(a.N,0,c)],WN(a.j[c]));o_.Zf(a.b[o_.Nj(a.N,1,c)],WN(a.j[c]));}d=o_.Je(a);if(a.Q==d)break;a.Q=d;e=o_.De(a,true);}};o_.Oe=function Oe(a){var b,c,d,e,f,g,h;a.H=true;d=o_.Ye(a);!!a.L&&o_.ng(a.L,a.c)&&(d=o_.Ye(a));o_.De(a,false)&&o_.Ie(a);g=true;while(a.Q<a.N.d&&g){e=o_.Fe(a,d);for(b=0;b<a.N.d;b++){o_._f(a.b[b],b);o_.Yf(a.b[b],16,WN(a.c[b]));o_.Yf(a.b[b],20,0);!a.$[b]&&a.Z[b]!=0&&o_.Zf(a.b[b],WN((a.Z[b]<<18)+(e[a.Z[b]==1?0:1][a.Y[b]]<<8)));h=a._[b];a.ab[b]&&(h==1?h=2:h==2&&(h=1));o_.Zf(a.b[b],h_.SN(h<<4));}for(c=0;c<a.N.e;c++){o_.Zf(a.b[o_.Nj(a.N,0,c)],WN(a.j[c]));o_.Zf(a.b[o_.Nj(a.N,1,c)],WN(a.j[c]));}f=o_.Je(a);if(a.Q==f)break;a.Q=f;g=false;if(!!a.L&&o_.ng(a.L,a.c)){g=true;d=o_.Ye(a);}if(o_.De(a,false)){g=true;o_.Ie(a);}}};o_.Pe=function Pe(a){var b,c;for(b=0;b<a.N.d;b++)(!a.I[b]||a._[b]==3)&&(a.Z[b]=0);for(c=0;c<a.N.e;c++)(o_.Yj(a.N,c)!=1||a.j[c]==0||a.j[c]==3)&&(a.i[c]=0);};o_.Qe=function Qe(a,b,c){if(a.a==null){a.a=OI(h_.dK,j0,5,a.N.d,15,1);l_.RW(a.a);}a.a[b]=c<<24>>24;};o_.Re=function Re(b,c){var d,e,f,g,h,i;if((b.j[c]==1||b.j[c]==2)&&!o_.An(b.N,c)){h=false;try{for(g=0;g<2;g++){d=o_.Nj(b.N,g,c);if(o_.Am(b.N,d)==3){e=OI(h_.hK,k0,5,2,15,1);f=0;for(i=0;i<o_.Am(b.N,d);i++)o_.Bm(b.N,d,i)!=c&&(e[f++]=o_.zm(b.N,d,i));b.c[e[0]]>b.c[e[1]]^o_.Te(b,d,e[0],e[1])&&(h=!h);}}}catch(a){a=HN(a);if(VJ(a,13)){b.e[c]=3;return;}else throw IN(a);}b.j[c]==1^h?b.e[c]=1:b.e[c]=2;}};o_.Se=function Se(b,c){var d,e,f,g,h,i,j;if(b._[c]==1||b._[c]==2){i=false;if(o_.qm(b.N,c)==2){try{for(h=0;h<2;h++){d=o_.zm(b.N,c,h);if(o_.Am(b.N,d)==3){f=OI(h_.hK,k0,5,2,15,1);g=0;for(j=0;j<o_.Am(b.N,d);j++)o_.Cm(b.N,d,j)==1&&(f[g++]=o_.zm(b.N,d,j));b.c[f[0]]>b.c[f[1]]^o_.Te(b,d,f[0],f[1])&&(i=!i);}}}catch(a){a=HN(a);if(VJ(a,13)){b.W[c]=3;return;}else throw IN(a);}}else {try{e=o_.Ve(b,c);}catch(a){a=HN(a);if(VJ(a,13)){b.W[c]=3;return;}else throw IN(a);}for(h=1;h<e.length;h++)for(j=0;j<h;j++)b.c[e[h]]<b.c[e[j]]&&(i=!i);}b._[c]==1^i?b.W[c]=1:b.W[c]=2;}};o_.Te=function Te(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L;if(o_.Ij(a.N,c)!=o_.Ij(a.N,d))return o_.Ij(a.N,c)>o_.Ij(a.N,d);if(o_.Bj(a.N,c)!=o_.Bj(a.N,d)){H=o_.yk(a.N,c)?(o_.Li(),o_.Ji)[o_.Ij(a.N,c)]:o_.Bj(a.N,c);I=o_.yk(a.N,d)?(o_.Li(),o_.Ji)[o_.Ij(a.N,d)]:o_.Bj(a.N,d);return H>I;}w=a.N.d;s=OI(h_.hK,k0,5,w,15,1);u=OI(h_.hK,k0,5,w,15,1);v=OI(h_.hK,k0,5,w,15,1);t=OI(h_.DN,C0,5,w,16,1);i=OI(h_.DN,C0,5,a.N.o,16,1);s[0]=b;s[1]=c;s[2]=d;u[0]=-1;u[1]=0;u[2]=0;i[b]=true;i[c]=true;i[d]=true;m=1;A=2;G=OI(h_.hK,k0,5,64,15,1);G[1]=1;G[2]=3;o=2;while(m<=A){while(m<G[o]){n=s[m];if(!t[m]){p=0;q=0;for(C=0;C<o_.Am(a.N,n);C++){k=o_.zm(a.N,n,C);if(A+o_.Cm(a.N,n,C)+1>=w){w+=a.N.d;s=o_.Df(s,w);u=o_.Df(u,w);v=o_.Df(v,w);t=o_.Ef(t,w);}if(o_.qn(a.N,o_.Bm(a.N,n,C))){++p;q+=o_.Ij(a.N,k);}else {for(F=1;F<o_.Cm(a.N,n,C);F++){++A;s[A]=k;u[A]=m;t[A]=true;}}K=u[m];if(k==s[K])continue;h=false;if(i[k]){J=u[K];while(J!=-1){if(k==s[J]){h=true;break;}J=u[J];}}if(h){++A;s[A]=k;u[A]=m;t[A]=true;}else {++A;s[A]=k;u[A]=m;i[k]=true;}}if(p!=0){++A;v[A]=(q<<2)/p|0;u[A]=m;t[A]=true;}}++m;if(m==g0){throw IN(new i_.EG('Emergency break in while loop.'));}}G.length==o+1&&(G=o_.Df(G,G.length+64));G[o+1]=A+1;for(B=G[o];B<G[o+1];B++){v[B]==0&&(v[B]=(o_.Ij(a.N,s[B])==151?1:o_.Ij(a.N,s[B])==152?1:o_.Ij(a.N,s[B]))<<2);v[B]+=v[u[B]]<<16;}o_.Xe(a,t,v,u,s,G,o);if(v[1]!=v[2])return v[1]>v[2];o>1&&o_.Ue(v,u,G,o);++o;}l=OI(h_.hK,k0,5,a.N.d,15,1);D=false;for(f=0;f<a.N.d;f++){if(i[f]&&!o_.yk(a.N,f)){D=true;break;}}if(D){for(g=0;g<a.N.d;g++)l[g]=o_.yk(a.N,g)?(o_.Li(),o_.Ji)[o_.Ij(a.N,g)]:o_.Bj(a.N,g);if(o_.We(a,t,v,u,s,l,G,o))return v[1]>v[2];}l_.VW(l,l.length,0);r=false;for(j=0;j<a.N.e;j++){if(i[o_.Nj(a.N,0,j)]||i[o_.Nj(a.N,1,j)]){if(a.e[j]==1){l[o_.Nj(a.N,0,j)]=1;l[o_.Nj(a.N,1,j)]=1;r=true;}else if(a.e[j]==2){l[o_.Nj(a.N,0,j)]=2;l[o_.Nj(a.N,1,j)]=2;r=true;}}}if(r&&o_.We(a,t,v,u,s,l,G,o))return v[1]>v[2];l_.VW(l,l.length,0);L=false;for(e=0;e<a.N.d;e++){if(i[e]){if(a.W[e]==2){l[e]=1;L=true;}else if(a.W[e]==1){l[e]=2;L=true;}}}if(L&&o_.We(a,t,v,u,s,l,G,o))return v[1]>v[2];throw IN(new i_.EG('no distinction applying CIP rules'));};o_.Ue=function Ue(a,b,c,d){var e,f,g,h,i,j,k,l,m;l=c[d];g=c[d+1]-l;m=OI(h_.pK,W_,97,g,0,1);for(i=0;i<g;i++){m[i]=new o_.Xf();m[i].c=a[i+l];m[i].b=b[i+l];m[i].a=i+l;}e=new o_.Uf();for(k=d;k>1;k--){for(j=0;j<g;j++){m[j].c+=a[m[j].b]<<16;m[j].b=b[m[j].b];}l_._W(m,0,m.length,e);f=1;for(h=0;h<g;h++){a[m[h].a]=f;h!=g-1&&o_.Tf(m[h],m[h+1])!=0&&++f;}}};o_.Ve=function Ve(a,b){var c,d,e,f,g,h,i;g=o_.mm(a.N,b);h=OI(h_.hK,k0,5,g,15,1);for(e=0;e<g;e++)h[e]=o_.zm(a.N,b,e);for(d=g;d>1;d--){c=false;for(f=1;f<d;f++){if(o_.Te(a,b,h[f-1],h[f])){c=true;i=h[f-1];h[f-1]=h[f];h[f]=i;}}if(!c)break;}return h;};o_.We=function We(a,b,c,d,e,f,g,h){var i,j;for(j=1;j<h;j++){for(i=g[j];i<g[j+1];i++)c[i]=f[e[i]]+(c[d[i]]<<8);o_.Xe(a,b,c,d,e,g,j);if(c[1]!=c[2])return true;j>1&&o_.Ue(c,d,g,j);}return false;};o_.Xe=function Xe(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p,q,r;for(l=g;l>1;l--){p=f[l]-f[l-1];r=OI(h_.nK,W_,96,p,0,1);h=f[l];for(o=0;o<p;o++){q=f[l-1]+o;m=h;while(m<f[l+1]&&d[m]==q)++m;r[o]=new o_.Rf();r[o].c=q;r[o].d=c[q];r[o].b=b[q]?0:o_.Xm(a.N,e[q]);r[o].a=OI(h_.hK,k0,5,m-h,15,1);for(k=h;k<m;k++)r[o].a[k-h]=c[k];n_.V$(r[o].a).sort(n_.V$(AO(l_.pX.prototype.Ub,l_.pX,[])));h=m;}i=new o_.Of();l_._W(r,0,r.length,i);j=1;for(n=0;n<p;n++){c[r[n].c]=j;n!=p-1&&o_.Nf(r[n],r[n+1])!=0&&++j;}}};o_.Ye=function Ye(a){var b,c;c=MI(h_.hK,[K_,d1],[25,6],0,[2,32],2);for(b=0;b<a.N.d;b++){a.I[b]&&(a.Z[b]==1?c[0][a.Y[b]]=o_.ug(c[0][a.Y[b]],b):a.Z[b]==2&&(c[1][a.Y[b]]=o_.ug(c[0][a.Y[b]],b)));}return c;};o_.Ze=function Ze(a){var b,c,d,e,f,g,h,i,j,k,l,m;f=0;k=0;g=0;h=0;i=0;j=0;l=0;m=false;b=OI(h_.DN,C0,5,32,16,1);for(c=0;c<a.N.d;c++){if(a._[c]!=0){++f;if(a._[c]==3){++k;}else {if(a.Z[c]==0){++g;!!a.L&&o_.jg(a.L,c)&&++h;}else if(a.Z[c]==2){a.Y[c]==0&&++j;}else if(a.Z[c]==1){e=a.Y[c];if(!b[e]){++l;b[e]=true;}a.Y[c]==0&&++i;!!a.L&&o_.jg(a.L,c)&&(m=true);}}}}for(d=0;d<a.N.e;d++){if(a.j[d]!=0&&o_.Yj(a.N,d)==1){++f;if(a.j[d]==3){++k;}else {if(a.i[d]==0){++g;!!a.L&&o_.jg(a.L,o_.Nj(a.N,0,d))&&o_.jg(a.L,o_.Nj(a.N,1,d))&&++h;}else if(a.i[d]==2){a.g[d]==0&&++j;}else if(a.i[d]==1){e=a.g[d];if(!b[e]){++l;b[e]=true;}a.g[d]==0&&++i;!!a.L&&o_.jg(a.L,o_.Nj(a.N,0,d))&&o_.jg(a.L,o_.Nj(a.N,1,d))&&(m=true);}}}}if(f==0){o_.xl(a.N,e0);return;}if(k!=0){o_.xl(a.N,0);return;}if(a.G){o_.xl(a.N,h1+(1<<l));return;}i+h==f&&!m?o_.xl(a.N,196608):g==f?o_.xl(a.N,b1):j==f?o_.xl(a.N,327680):g==f-1&&i==1?o_.xl(a.N,S0):o_.xl(a.N,458752+(1<<l));};o_.$e=function $e(a,b,c){while(c!=0){if(a.q==0){(!a.o||a.s!=63)&&(a.s+=64);i_.cS(a.r,a.s&f0);a.q=6;a.s=0;}a.s<<=1;a.s|=b&1;b>>=1;--c;--a.q;}};o_._e=function _e(a){a.s<<=a.q;(!a.o||a.s!=63)&&(a.s+=64);i_.cS(a.r,a.s&f0);return a.r.a;};o_.af=function af(a,b){a.r=new i_.jS();a.q=6;a.s=0;a.o=b;};o_.bf=function bf(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q;if(a.N.d==0){a.p='';return;}l=false;if(a.fb&&a.N.o>a.N.d&&!a.N.I){l=true;for(i=0;i<a.N.d;i++){if(o_.Nm(a.N,i)!=0){l=false;break;}}}q=a.fb?16:8;o_.af(a,true);i_.cS(a.r,l?35:33);o_.$e(a,a.fb?1:0,1);o_.$e(a,b?1:0,1);o_.$e(a,q/2|0,4);o=0;for(j=1;j<a.N.d;j++)o=o_.pf(a,a.u[j],a.A[j]==-1?-1:a.u[a.A[j]],o,c);if(l){for(i=0;i<a.N.d;i++){d=a.u[i];for(n=o_.Am(a.N,d);n<o_.mm(a.N,d);n++)o=o_.pf(a,o_.zm(a.N,d,n),d,o,c);}}if(a.N.d>1&&o==0){a.p='';return;}g=1<<q;m=o/(g/2-1);p=o+m/2;for(k=1;k<a.N.d;k++)o_.cf(a,a.u[k],a.A[k]==-1?-1:a.u[a.A[k]],p,m,q,c);if(l){for(h=0;h<a.N.d;h++){d=a.u[h];for(n=o_.Am(a.N,d);n<o_.mm(a.N,d);n++)o_.cf(a,o_.zm(a.N,d,n),d,p,m,q,c);}}if(b){f=a.fb?1.5:(o_.Li(),o_.Li(),o_.Ki);e=o_.Lj(a.N,l?a.N.o:a.N.d,l?a.N.p:a.N.e,f,c);o_.$e(a,$wnd.Math.min(g-1,$wnd.Math.max(0,cK(0.5+$wnd.Math.log(e/0.1)*$wnd.Math.LOG10E/($wnd.Math.log(2000)*$wnd.Math.LOG10E)*(g-1)))),q);o_.$e(a,o_.ef(c[a.u[0]].a/e,g),q);o_.$e(a,o_.ef(c[a.u[0]].b/e,g),q);a.fb&&o_.$e(a,o_.ef(c[a.u[0]].c/e,g),q);}a.p=o_._e(a);};o_.cf=function cf(a,b,c,d,e,f,g){var h,i,j;h=c==-1?(g[b].a-g[a.u[0]].a)/8:g[b].a-g[c].a;i=c==-1?(g[b].b-g[a.u[0]].b)/8:g[b].b-g[c].b;o_.$e(a,cK((d+h)/e),f);o_.$e(a,cK((d+i)/e),f);if(a.fb){j=c==-1?(g[b].c-g[a.u[0]].c)/8:g[b].c-g[c].c;o_.$e(a,cK((d+j)/e),f);}};o_.df=function df(a){var b,c,d,e,f,g;if(a.N.d==0){a.J='';return;}f=0;d=false;e=false;for(c=0;c<a.N.d;c++){f<o_.Aj(a.N,c)&&(f=o_.Aj(a.N,c));o_.nk(a.N,c)?d=true:e=true;}if(f==0){a.J='';return;}g=o_.yf(f);o_.af(a,true);o_.$e(a,g,4);o_.$e(a,d?1:0,1);o_.$e(a,e?1:0,1);for(b=0;b<a.N.d;b++){o_.$e(a,o_.Aj(a.N,a.u[b]),g);d&&e&&o_.$e(a,o_.nk(a.N,a.u[b])?1:0,1);}a.J=o_._e(a);};o_.ef=function ef(a,b){var c,d,e,f;c=b/2|0;e=a<0;a=$wnd.Math.abs(a);f=b/32|0;d=$wnd.Math.min(c-1,kO(VN($wnd.Math.round(a*c/(a+f)))));return e?c+d:d;};o_.ff=function ff(a,b){if(!b){o_.$e(a,1,1);o_.$e(a,15,4);}return true;};o_.gf=function gf(a){var b,c,d;for(b=0;b<a.N.d;b++){a._[b]==3&&!o_.jk(a.N,b)&&o_.Fl(a.N,b);(o_.wj(a.N,b)==1||o_.wj(a.N,b)==2)&&(!a.I[b]||a._[b]==3)&&o_.Fl(a.N,b);o_.jk(a.N,b)&&a._[b]!=3&&!o_.Cf(a,b)&&o_.Fl(a.N,b);}for(d=0;d<a.N.p;d++)o_.Dk(a.N,d)&&!o_.Bf(a,d)&&o_.Fl(a.N,o_.Nj(a.N,0,d));for(c=0;c<a.N.e;c++){if(o_.Vj(a.N,c)==2){if(o_.tk(a.N,c)&&(a.j[c]==1||a.j[c]==2)){a.j[c]=3;o_.wl(a.N,c,26);}if(a.j[c]==3&&!a.k[c]){if(o_.Yj(a.N,c)!=26){o_.Fl(a.N,o_.Nj(a.N,0,c));o_.Fl(a.N,o_.Nj(a.N,1,c));}}}if(o_.Yj(a.N,c)==1&&a.j[c]==3&&!o_.jk(a.N,o_.Nj(a.N,0,c))&&!o_.jk(a.N,o_.Nj(a.N,1,c))){o_.Fl(a.N,o_.Nj(a.N,0,c));o_.Fl(a.N,o_.Nj(a.N,1,c));}if((o_.Sj(a.N,c)==1||o_.Sj(a.N,c)==2)&&(o_.Yj(a.N,c)!=1||a.j[c]!=1&&a.j[c]!=2)){o_.Fl(a.N,o_.Nj(a.N,0,c));o_.Fl(a.N,o_.Nj(a.N,1,c));}}};o_.hf=function hf(a){var b,c,d,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;if(a.N.d==0)return;if(a.B)return;a.D=0;v=0;for(c=1;c<a.N.d;c++)a.c[c]>a.c[v]&&(v=c);d=OI(h_.DN,C0,5,a.N.d,16,1);g=OI(h_.DN,C0,5,a.N.e,16,1);a.C=OI(h_.hK,k0,5,a.N.d,15,1);a.u=OI(h_.hK,k0,5,a.N.d,15,1);a.A=OI(h_.hK,k0,5,a.N.d,15,1);a.v=OI(h_.hK,k0,5,a.N.e,15,1);a.u[0]=v;a.C[v]=0;d[v]=true;i=0;j=1;k=0;while(i<a.N.d){if(i<j){while(true){o=0;p=0;m=-1;b=a.u[i];for(q=0;q<o_.nm(a.N,b);q++){if(q<o_.Am(a.N,b)||q>=o_.mm(a.N,b)){h=o_.zm(a.N,b,q);if(!d[h]&&a.c[h]>m){o=h;p=o_.Bm(a.N,b,q);m=a.c[h];}}}if(m==-1)break;a.C[o]=j;a.A[j]=i;a.u[j++]=o;a.v[k++]=p;d[o]=true;g[p]=true;}++i;}else {n=0;m=-1;for(b=0;b<a.N.d;b++){if(!d[b]&&a.c[b]>m){n=b;m=a.c[b];}}a.C[n]=j;a.A[j]=-1;a.u[j++]=n;d[n]=true;}}a.w=OI(h_.hK,k0,5,2*(a.N.e-k),15,1);while(true){s=a.N.K;t=a.N.K;u=-1;for(f=0;f<a.N.e;f++){if(!g[f]){if(a.C[o_.Nj(a.N,0,f)]<a.C[o_.Nj(a.N,1,f)]){r=a.C[o_.Nj(a.N,0,f)];l=a.C[o_.Nj(a.N,1,f)];}else {r=a.C[o_.Nj(a.N,1,f)];l=a.C[o_.Nj(a.N,0,f)];}if(r<s||r==s&&l<t){s=r;t=l;u=f;}}}if(u==-1)break;g[u]=true;a.v[k++]=u;a.w[2*a.D]=s;a.w[2*a.D+1]=t;++a.D;}a.B=true;};o_.jf=function jf(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o;i=null;o=o_.Ym(a.N);for(l=0;l<o.i.a.length;l++){if(o.e[l]){f=0;m=l_.Th(o.i,l);for(c=m,d=0,e=c.length;d<e;++d){b=c[d];o_.vf(a,b)&&++f;}if(f!=0){n=l_.Th(o.j,l);i==null&&(i=OI(h_.DN,C0,5,a.N.e,16,1));if(f==m.length){j=-1;k=P_;for(g=0;g<m.length;g++){if(k>a.u[n[g]]){k=a.u[n[g]];j=g;}}while(f>0){i[n[j]]=true;j=o_.Jf(j+2,m.length);f-=2;}}else {h=0;while(o_.vf(a,m[h]))++h;while(!o_.vf(a,m[h]))h=o_.Jf(h+1,m.length);while(f>0){i[n[h]]=true;h=o_.Jf(h+2,m.length);f-=2;while(!o_.vf(a,m[h]))h=o_.Jf(h+1,m.length);}}}}}return i;};o_.kf=function kf(a,b){return a.j[b];};o_.lf=function lf(a){return o_.mf(a,a.fb);};o_.mf=function mf(a,b){if(a.p==null){o_.hf(a);o_.bf(a,b,a.N.H);}return a.p;};o_.nf=function nf(a){if(a.J==null){o_.hf(a);o_.df(a);}return a.J;};o_.of=function of(a){if(a.F==null){o_.hf(a);o_.xf(a);o_.zf(a,1);o_.zf(a,2);o_.wf(a);}return a.F;};o_.pf=function pf(a,b,c,d,e){var f,g,h;f=c==-1?$wnd.Math.abs(e[b].a-e[a.u[0]].a)/8:$wnd.Math.abs(e[b].a-e[c].a);d<f&&(d=f);g=c==-1?$wnd.Math.abs(e[b].b-e[a.u[0]].b)/8:$wnd.Math.abs(e[b].b-e[c].b);d<g&&(d=g);if(a.fb){h=c==-1?$wnd.Math.abs(e[b].c-e[a.u[0]].c)/8:$wnd.Math.abs(e[b].c-e[c].c);d<h&&(d=h);}return d;};o_.qf=function qf(a,b){return a.T[b];};o_.rf=function rf(a,b){return a.U[b];};o_.sf=function sf(a,b){return a.d==null?-1:a.d[b];};o_.tf=function tf(a,b){return a._[b];};o_.uf=function uf(a,b){var c,d,e,f,g,h,i;i=o_.Ym(a.N);for(c=0;c<i.i.a.length;c++){if(i.d[c]&&o_.Vp(i,c,b)){for(e=l_.Th(i.i,c),f=0,g=e.length;f<g;++f){d=e[f];if(d!=b)for(h=0;h<o_.Am(a.N,d);h++)if(o_.nn(a.N,o_.Bm(a.N,d,h)))return true;}return false;}}return false;};o_.vf=function vf(a,b){var c,d,e;if(o_.qm(a.N,b)<2)return false;if(o_.Am(a.N,b)==2)return true;c=0;for(e=0;e<o_.Am(a.N,b);e++){d=o_.Bm(a.N,b,e);o_.mn(a.N,d)&&(c+=o_.Vj(a.N,d)-1);}return c>1;};o_.wf=function wf(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab;o_.af(a,false);o_.$e(a,9,4);X=$wnd.Math.max(o_.yf(a.N.d),o_.yf(a.N.e));o_.$e(a,X,4);if(X==0){o_.$e(a,a.N.I?1:0,1);o_.$e(a,0,1);a.F=o_._e(a);return;}Y=$=Z=K=0;for(i=0;i<a.N.d;i++){if((o_.Dj(a.N,i)&1)==0){switch(o_.Ij(a.N,i)){case 6:break;case 7:++Y;break;case 8:++$;break;default:++Z;}o_.rj(a.N,i)!=0&&++K;}}o_.$e(a,a.N.d,X);o_.$e(a,a.N.e,X);o_.$e(a,Y,X);o_.$e(a,$,X);o_.$e(a,Z,X);o_.$e(a,K,X);for(j=0;j<a.N.d;j++)o_.Ij(a.N,a.u[j])==7&&(o_.Dj(a.N,a.u[j])&1)==0&&o_.$e(a,j,X);for(o=0;o<a.N.d;o++)o_.Ij(a.N,a.u[o])==8&&(o_.Dj(a.N,a.u[o])&1)==0&&o_.$e(a,o,X);for(p=0;p<a.N.d;p++)if(o_.Ij(a.N,a.u[p])!=6&&o_.Ij(a.N,a.u[p])!=7&&o_.Ij(a.N,a.u[p])!=8&&(o_.Dj(a.N,a.u[p])&1)==0){o_.$e(a,p,X);o_.$e(a,o_.Ij(a.N,a.u[p]),8);}for(q=0;q<a.N.d;q++)if(o_.rj(a.N,a.u[q])!=0&&(o_.Dj(a.N,a.u[q])&1)==0){o_.$e(a,q,X);o_.$e(a,8+o_.rj(a.N,a.u[q]),4);}W=0;A=0;for(r=1;r<a.N.d;r++){if(a.A[r]==-1){O=0;}else {O=1+a.A[r]-A;A=a.A[r];}W<O&&(W=O);}N=o_.yf(W);o_.$e(a,N,4);A=0;for(s=1;s<a.N.d;s++){if(a.A[s]==-1){O=0;}else {O=1+a.A[s]-A;A=a.A[s];}o_.$e(a,O,N);}for(Q=0;Q<2*a.D;Q++)o_.$e(a,a.w[Q],X);for(C=0;C<a.N.e;C++){J=(o_.Xj(a.N,a.v[C])&X0)!=0||o_.Yj(a.N,a.v[C])==32?1:o_.qn(a.N,a.v[C])?0:o_.Vj(a.N,a.v[C]);o_.$e(a,J,2);}c=0;for(t=0;t<a.N.d;t++)a.X[a.u[t]]!=0&&a.X[a.u[t]]!=3&&++c;o_.$e(a,c,X);for(u=0;u<a.N.d;u++)if(a.X[a.u[u]]!=0&&a.X[a.u[u]]!=3){o_.$e(a,u,X);if(a.Z[a.u[u]]==0){o_.$e(a,a.X[a.u[u]],3);}else {ab=a.X[a.u[u]]==1?a.Z[a.u[u]]==1?4:6:a.Z[a.u[u]]==1?5:7;o_.$e(a,ab,3);o_.$e(a,a.Y[a.u[u]],3);}}b=0;for(D=0;D<a.N.e;D++)a.f[a.v[D]]!=0&&a.f[a.v[D]]!=3&&(!o_.An(a.N,a.v[D])||o_.Yj(a.N,a.v[D])==1)&&++b;o_.$e(a,b,X);for(F=0;F<a.N.e;F++)if(a.f[a.v[F]]!=0&&a.f[a.v[F]]!=3&&(!o_.An(a.N,a.v[F])||o_.Yj(a.N,a.v[F])==1)){o_.$e(a,F,X);if(o_.Yj(a.N,a.v[F])==1){if(a.i[a.v[F]]==0){o_.$e(a,a.f[a.v[F]],3);}else {ab=a.f[a.v[F]]==1?a.i[a.v[F]]==1?4:6:a.i[a.v[F]]==1?5:7;o_.$e(a,ab,3);o_.$e(a,a.g[a.v[F]],3);}}else {o_.$e(a,a.f[a.v[F]],2);}}o_.$e(a,a.N.I?1:0,1);L=0;for(v=0;v<a.N.d;v++)o_.Bj(a.N,a.u[v])!=0&&++L;if(L!=0){o_.$e(a,1,1);o_.$e(a,1,4);o_.$e(a,L,X);for(k=0;k<a.N.d;k++){if(o_.Bj(a.N,a.u[k])!=0){o_.$e(a,k,X);o_.$e(a,o_.Bj(a.N,a.u[k]),8);}}}S=false;if(a.N.I){o_.je(a,0,false,X,V0,1,-1);o_.je(a,3,false,X,b0,1,-1);o_.je(a,4,false,X,120,4,3);o_.je(a,5,false,X,6,2,1);o_.je(a,6,false,X,1,1,-1);o_.je(a,7,false,X,K0,4,7);L=0;for(k=0;k<a.N.d;k++)o_.yj(a.N,a.u[k])!=null&&++L;if(L>0){o_.$e(a,1,1);o_.$e(a,8,4);o_.$e(a,L,X);for(l=0;l<a.N.d;l++){w=o_.yj(a.N,a.u[l]);if(w!=null){o_.$e(a,l,X);o_.$e(a,w.length,4);for(e=w,f=0,g=e.length;f<g;++f){d=e[f];o_.$e(a,d,8);}}}}o_.ke(a,9,false,X,96,2,5);o_.ke(a,10,false,X,31,5,0);o_.je(a,11,false,X,J0,1,-1);o_.ke(a,12,false,X,X0,8,7);o_.je(a,13,false,X,P0,3,14);o_.je(a,14,false,X,Q0,5,17);S=S|o_.je(a,16,S,X,T0,3,22);}L=0;for(m=0;m<a.N.d;m++)a.a!=null&&a.a[a.u[m]]!=-1&&++L;if(L!=0){S=o_.ff(a,S);o_.$e(a,1,1);o_.$e(a,1,4);o_.$e(a,L,X);for(k=0;k<a.N.d;k++){if(a.a!=null&&a.a[a.u[k]]!=-1){o_.$e(a,k,X);o_.$e(a,a.a[a.u[k]],4);}}}if((a.M&8)!=0){L=0;V=0;for(k=0;k<a.N.d;k++){T=o_.tj(a.N,a.u[k]);if(T!=null){++L;V=$wnd.Math.max(V,n_.V$(T).length);}}if(L!=0){S=o_.ff(a,S);U=o_.yf(V);o_.$e(a,1,1);o_.$e(a,2,4);o_.$e(a,L,X);o_.$e(a,U,4);for(l=0;l<a.N.d;l++){M=o_.tj(a.N,a.u[l]);if(M!=null){o_.$e(a,l,X);o_.$e(a,n_.V$(M).length,U);for(P=0;P<n_.V$(M).length;P++)o_.$e(a,(n_.S$(P,n_.V$(M).length),n_.V$(M).charCodeAt(P)),7);}}}}if(a.N.I){S=S|o_.je(a,19,S,X,M0,3,25);S=S|o_.ke(a,20,S,X,$0,3,15);}L=0;for(n=0;n<a.N.d;n++)o_.Ej(a.N,a.u[n])!=0&&++L;if(L!=0){S=o_.ff(a,S);o_.$e(a,1,1);o_.$e(a,5,4);o_.$e(a,L,X);for(h=0;h<a.N.d;h++){if(o_.Ej(a.N,a.u[h])!=0){o_.$e(a,h,X);o_.$e(a,o_.Ej(a.N,a.u[h])>>4,2);}}}if(a.N.I){S=S|o_.je(a,22,S,X,U0,1,-1);S=S|o_.ke(a,23,S,X,b1,1,-1);S=S|o_.ke(a,24,S,X,Y0,2,19);}if((a.M&16)!=0){for(h=0;h<a.N.d;h++){if(o_.Bk(a.N,a.u[h])){S=o_.ff(a,S);o_.$e(a,1,1);o_.$e(a,9,4);for(d=0;d<a.N.d;d++)o_.$e(a,o_.Bk(a.N,a.u[d])?1:0,1);break;}}}R=o_.jf(a);if(R!=null){L=0;for(G=0;G<a.N.e;G++)R[a.v[G]]&&++L;S=o_.ff(a,S);o_.$e(a,1,1);o_.$e(a,10,4);o_.$e(a,L,X);for(H=0;H<a.N.e;H++)R[a.v[H]]&&o_.$e(a,H,X);}a.N.I&&(S=S|o_.je(a,27,S,X,D0,1,-1));L=0;for(I=0;I<a.N.e;I++)o_.Yj(a.N,a.v[I])==32&&++L;if(L!=0){S=o_.ff(a,S);o_.$e(a,1,1);o_.$e(a,12,4);o_.$e(a,L,X);for(B=0;B<a.N.e;B++)o_.Yj(a.N,a.v[B])==32&&o_.$e(a,B,X);}a.N.I&&(S=S|o_.je(a,29,S,X,i1,2,30));o_.$e(a,0,1);a.F=o_._e(a);};o_.xf=function xf(a){var b,c,d,e,f,g,h,i,j,k,l;a.X=OI(h_.dK,j0,5,a.N.d,15,1);for(b=0;b<a.N.d;b++){if(a._[b]==1||a._[b]==2){i=a.ab[b];if(o_.on(a.N,b)){for(h=0;h<o_.Am(a.N,b);h++){e=o_.zm(a.N,b,h);l=0;k=OI(h_.hK,k0,5,3,15,1);for(j=0;j<o_.Am(a.N,e);j++){k[l]=o_.zm(a.N,e,j);k[l]!=b&&++l;}l==2&&a.c[k[0]]>a.c[k[1]]^a.C[k[0]]<a.C[k[1]]&&(i=!i);}}else {for(h=1;h<o_.Am(a.N,b);h++){for(j=0;j<h;j++){f=o_.zm(a.N,b,h);g=o_.zm(a.N,b,j);a.c[f]>a.c[g]&&(i=!i);a.C[f]<a.C[g]&&(i=!i);}}}a.X[b]=a._[b]==1^i?1:2;}else {a.X[b]=a._[b];}}a.f=OI(h_.dK,j0,5,a.N.e,15,1);for(c=0;c<a.N.e;c++){if(a.j[c]==1||a.j[c]==2){i=false;for(h=0;h<2;h++){d=o_.Nj(a.N,h,c);if(o_.Am(a.N,d)==3){k=OI(h_.hK,k0,5,2,15,1);l=0;for(j=0;j<3;j++)o_.zm(a.N,d,j)!=o_.Nj(a.N,1-h,c)&&(k[l++]=o_.zm(a.N,d,j));a.c[k[0]]>a.c[k[1]]&&(i=!i);a.C[k[0]]<a.C[k[1]]&&(i=!i);}}a.f[c]=a.j[c]==1^i?1:2;}else {a.f[c]=a.j[c];}}};o_.yf=function yf(a){var b;b=0;while(a>0){a>>=1;++b;}return b;};o_.zf=function zf(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;i=OI(h_.hK,k0,5,32,15,1);j=0;for(d=0;d<a.N.d;d++){if((a.X[d]==1||a.X[d]==2)&&a.Z[d]==b){h=a.Y[d];if(i[h]<a.c[d]){i[h]==0&&++j;i[h]=a.c[d];}}}for(f=0;f<a.N.e;f++){if((a.f[f]==1||a.f[f]==2)&&a.i[f]==b&&o_.Yj(a.N,f)==1){h=a.g[f];o=$wnd.Math.max(a.c[o_.Nj(a.N,0,f)],a.c[o_.Nj(a.N,1,f)]);if(i[h]<o){i[h]==0&&++j;i[h]=o;}}}g=OI(h_.dK,j0,5,32,15,1);for(k=0;k<j;k++){m=-1;n=0;for(l=0;l<32;l++){if(n<i[l]){n=i[l];m=l;}}i[m]=0;g[m]=k<<24>>24;}for(c=0;c<a.N.d;c++)(a.X[c]==1||a.X[c]==2)&&a.Z[c]==b&&(a.Y[c]=g[a.Y[c]]);for(e=0;e<a.N.e;e++)(a.f[e]==1||a.f[e]==2)&&a.i[e]==b&&o_.Yj(a.N,e)==1&&(a.g[e]=g[a.g[e]]);};o_.Af=function Af(a,b,c){var d,e;a.Q=b;for(d=0;d<a.N.d;d++){a.c[d]=c[d];a._[d]=0;a.eb[d]=false;}for(e=0;e<a.N.e;e++){a.j[e]=0;a.n[e]=false;}};o_.Bf=function Bf(a,b){var c,d,e;c=o_.Nj(a.N,0,b);if(c>=a.N.d)return false;if(a._[c]==1||a._[c]==2)return true;if(a._[c]==3)return false;d=o_.im(a.N,c);if(d!=-1)return a.j[d]==1||a.j[d]==2;for(e=0;e<o_.Am(a.N,c);e++){if(o_.Cm(a.N,c,e)==2){if(a._[o_.zm(a.N,c,e)]==1||a._[o_.zm(a.N,c,e)]==2)return true;}}return false;};o_.Cf=function Cf(a,b){var c;for(c=0;c<o_.Am(a.N,b);c++)if(a.j[o_.Bm(a.N,b,c)]==3&&o_.Cm(a.N,b,c)==1)return true;return false;};o_.Df=function Df(a,b){var c;c=OI(h_.hK,k0,5,b,15,1);i_.pS(a,0,c,0,a.length);return c;};o_.Ef=function Ef(a,b){var c;c=OI(h_.DN,C0,5,b,16,1);i_.pS(a,0,c,0,a.length);return c;};o_.Ff=function Ff(a){var b,c;if(a.W!=null)for(b=0;b<a.N.d;b++)o_.Uk(a.N,b,a.W[b]);if(a.e!=null)for(c=0;c<a.N.e;c++)o_.pl(a.N,c,a.e[c]);};o_.Gf=function Gf(a){var b,c,d,e,f,g,h,i,j,k,l;for(b=0;b<a.N.d;b++){if(a._[b]==1||a._[b]==2){i=false;if(o_.on(a.N,b)){for(h=0;h<o_.Am(a.N,b);h++){e=o_.zm(a.N,b,h);l=0;k=OI(h_.hK,k0,5,3,15,1);for(j=0;j<o_.Am(a.N,e);j++){k[l]=o_.zm(a.N,e,j);k[l]!=b&&++l;}l==2&&a.c[k[0]]>a.c[k[1]]^k[0]<k[1]&&(i=!i);}}else {for(h=1;h<o_.Am(a.N,b);h++){for(j=0;j<h;j++){f=o_.zm(a.N,b,h);g=o_.zm(a.N,b,j);a.c[f]>a.c[g]&&(i=!i);f<g&&(i=!i);}}}o_.el(a.N,b,a._[b]==1^i?1:2,a.bb[b]);}else {o_.el(a.N,b,a._[b],a.bb[b]);}}for(c=0;c<a.N.e;c++){if(a.j[c]==1||a.j[c]==2){i=false;for(h=0;h<2;h++){d=o_.Nj(a.N,h,c);if(o_.Am(a.N,d)==3){k=OI(h_.hK,k0,5,2,15,1);l=0;for(j=0;j<3;j++)o_.zm(a.N,d,j)!=o_.Nj(a.N,1-h,c)&&(k[l++]=o_.zm(a.N,d,j));a.c[k[0]]>a.c[k[1]]&&(i=!i);k[0]<k[1]&&(i=!i);}}o_.tl(a.N,c,a.j[c]==1^i?1:2,a.k[c]);}else {o_.tl(a.N,c,a.j[c],a.k[c]);}}};o_.Hf=function Hf(a){var b;for(b=0;b<a.N.d;b++){o_.il(a.N,b,a.I[b]);}};o_.If=function If(a){var b,c,d;for(b=0;b<a.N.d;b++)!o_.jk(a.N,b)&&a._[b]==3&&o_.Xk(a.N,b,true);for(c=0;c<a.N.e;c++){if(a.j[c]==3){d=o_.Vj(a.N,c);d==1?o_.Xk(a.N,o_.Nj(a.N,0,c),true):d==2&&o_.wl(a.N,c,26);}}};o_.Jf=function Jf(a,b){return a<b?a:a-b;};o_.Kf=function Kf(a){o_.Lf.call(this,a,0);};o_.Lf=function Lf(a,b){if(a.o>f0)throw IN(new i_._Q('Cannot canonize a molecule having more than 65535 atoms'));if(a.p>f0)throw IN(new i_._Q('Cannot canonize a molecule having more than 65535 bonds'));this.N=a;this.M=b;o_.Jr(this.N,7);o_.Ce(this);this.fb=(b&64)!=0||o_.ik(this.N);this._=OI(h_.dK,j0,5,this.N.d,15,1);this.bb=OI(h_.DN,C0,5,this.N.d,16,1);this.eb=OI(h_.DN,C0,5,this.N.d,16,1);this.j=OI(h_.dK,j0,5,this.N.e,15,1);this.n=OI(h_.DN,C0,5,this.N.e,16,1);this.k=OI(h_.DN,C0,5,this.N.e,16,1);o_.Ge(this);o_.Le(this);o_.Ke(this);};xO(46,1,{},o_.Kf,o_.Lf);_.o=false;_.q=0;_.s=0;_.B=false;_.D=0;_.G=false;_.H=false;_.K=0;_.M=0;_.P=0;_.Q=0;_.V=false;_.fb=false;h_.xK=jQ(46);o_.Mf=function Mf(a,b){var c,d,e,f;if(a.d!=b.d)return a.d>b.d?1:-1;e=a.a.length;f=b.a.length;c=$wnd.Math.min(e,f);for(d=0;d<c;d++){--e;--f;if(a.a[e]!=b.a[f])return a.a[e]>b.a[f]?1:-1;}if(e!=f)return e>f?1:-1;if(a.b!=b.b)return a.b>b.b?1:-1;return 0;};o_.Nf=function Nf(a,b){return o_.Mf(a,b);};o_.Of=function Of(){};xO(156,1,{},o_.Of);_.kb=function Pf(a,b){return o_.Nf(a,b);};_.gb=function Qf(a){return this===a;};h_.oK=jQ(156);o_.Rf=function Rf(){};xO(96,1,{96:1},o_.Rf);_.b=0;_.c=0;_.d=0;h_.nK=jQ(96);o_.Sf=function Sf(a,b){if(a.c!=b.c)return a.c>b.c?1:-1;return 0;};o_.Tf=function Tf(a,b){return o_.Sf(a,b);};o_.Uf=function Uf(){};xO(157,1,{},o_.Uf);_.kb=function Vf(a,b){return o_.Tf(a,b);};_.gb=function Wf(a){return this===a;};h_.qK=jQ(157);o_.Xf=function Xf(){};xO(97,1,{97:1},o_.Xf);_.a=0;_.b=0;_.c=0;h_.pK=jQ(97);o_.Yf=function Yf(a,b,c){if(a.b==0){++a.c;a.b=63;}if(a.b==63){a.d[a.c]=dO(a.d[a.c],c);a.b-=b;}else {if(a.b>=b){a.d[a.c]=eO(a.d[a.c],b);a.d[a.c]=dO(a.d[a.c],c);a.b-=b;}else {a.d[a.c]=eO(a.d[a.c],a.b);a.d[a.c]=dO(a.d[a.c],fO(c,b-a.b));b-=a.b;++a.c;a.b=63-b;a.d[a.c]=dO(a.d[a.c],KN(c,h_.SN((1<<b)-1)));}}};o_.Zf=function Zf(a,b){a.d[a.c]=JN(a.d[a.c],b);};o_.$f=function $f(a,b){var c;for(c=0;c<a.c;c++)if(cO(a.d[c],b.d[c]))return ZN(a.d[c],b.d[c])?-1:1;return UN(a.d[a.c],b.d[a.c])?0:ZN(a.d[a.c],b.d[a.c])?-1:1;};o_._f=function _f(a,b){a.a=b;a.c=0;a.b=63;l_.TW(a.d);};o_.ag=function ag(a){this.d=OI(h_.iK,f1,5,a,14,1);};xO(74,1,{74:1,30:1},o_.ag);_.lb=function bg(a){return o_.$f(this,a);};_.a=0;_.b=0;_.c=0;h_.rK=jQ(74);o_.cg=function cg(a,b,c,d){this.a=(n_.J$(b),l_.QW(a,OI(h_.hK,k0,5,b,15,1),b));this.b=(n_.J$(d),l_.QW(c,OI(h_.hK,k0,5,d,15,1),d));};xO(115,1,{115:1},o_.cg);h_.sK=jQ(115);o_.dg=function dg(a,b,c){var d,e,f,g,h,i,j,k,l;if(b==null)return;h=0;for(e=0;e<a.i.d;e++)b[e]&&++h;l=OI(h_.hK,k0,5,h,15,1);h=0;for(d=0;d<a.i.d;d++)b[d]&&(l[h++]=d);j=false;for(g=new l_.KW(c);g.a<g.c.a.length;){f=l_.JW(g);if(f.length==l.length){i=false;for(k=0;k<f.length;k++){if(f[k]!=l[k]){i=true;break;}}if(!i){j=true;break;}}}j||(c.a[c.a.length]=l,true);};o_.eg=function eg(a,b){var c,d;for(d=0;d<a.g[b].length;d++){c=a.g[b][d];if(a.f[c]&&(a.o[c]==1||a.o[c]==2)&&a.k[c]==0)return true;}return false;};o_.fg=function fg(a,b,c){var d,e,f,g,h;e=0;g=0;for(h=0;h<a.g[b].length;h++){d=a.g[b][h];if(a.k[d]==c){f=1<<a.j[d];if((g&f)==0){g|=f;++e;}}}return e;};o_.gg=function gg(a){var b,c,d,e,f,g,h,i,j,k,l,m;k=new l_.gi();for(l=0;l<a.i.d;l++){if(o_.qm(a.i,l)<2||o_.Am(a.i,l)>2){for(g=1;g<o_.Am(a.i,l);g++){b=o_.zm(a.i,l,g);for(j=0;j<g;j++){c=o_.zm(a.i,l,j);o_.lg(a,b,c)&&o_.dg(a,o_.sg(a,b,c),k);}}}}for(m=0;m<a.i.e;m++){if(a.c[m]!=0){if(o_.Vj(a.i,m)!=2||a.c[m]!=2)continue;}b=o_.Nj(a.i,0,m);c=o_.Nj(a.i,1,m);o_.lg(a,b,c)&&o_.dg(a,o_.sg(a,b,c),k);}for(h=k.a.length-1;h>=0;h--){d=(n_.L$(h,k.a.length),k.a[h]);e=false;for(j=0;j<d.length;j++){if(a.f[d[j]]){e=true;break;}}e||l_._h(k,d);}a.g=l_.fi(k,MI(h_.hK,[d1,k0],[6,5],15,[0,0],2));l_.fX(a.g,new o_.wg());a.e=OI(h_.DN,C0,5,a.i.d,16,1);for(f=0;f<a.g.length;f++)for(i=0;i<a.g[f].length;i++)a.e[a.g[f][i]]=true;};o_.hg=function hg(a,b,c,d){var e,f;for(f=0;f<o_.Am(a.i,c);f++){e=o_.zm(a.i,c,f);if(!d[e]&&o_.lg(a,b,e))return e;}return -1;};o_.ig=function ig(a,b){return a.f[b]&&(a.o[b]==1||a.o[b]==2);};o_.jg=function jg(a,b){return a.e[b];};o_.kg=function kg(a){var b,c;c=true;for(b=0;b<a.i.d;b++){if(a.o[b]!=0&&!a.e[b]){c=false;break;}}return c;};o_.lg=function lg(a,b,c){var d,e,f,g,h;if(b==c)return false;if(a.a[b]!=a.a[c])return false;if(a.o[b]!=0){if(a.o[b]==3||a.o[c]==3)return false;if(a.p[b]^a.o[b]!==a.o[c])return false;if(a.k[b]!==a.k[c]||a.j[b]!==a.j[c])return false;}d=o_.xm(a.i,b,c);if(d!=-1){if(o_.Vj(a.i,d)==1&&a.c[d]!=0)return false;if(o_.Vj(a.i,d)==2&&a.c[d]==1)return false;}if(o_.qm(a.i,b)==1&&!o_.ln(a.i,b)){e=-1;for(h=0;h<o_.Am(a.i,b);h++){if(o_.zm(a.i,b,h)!=c&&o_.Cm(a.i,b,h)==2){e=o_.Bm(a.i,b,h);break;}}f=-1;for(g=0;g<o_.Am(a.i,c);g++){if(o_.zm(a.i,c,g)!=b&&o_.Cm(a.i,c,g)==2){f=o_.Bm(a.i,c,g);break;}}if(e!=-1&&a.c[e]!=0&&a.d[e]^a.c[e]===a.c[f])return false;}return true;};o_.mg=function mg(a,b,c,d,e){var f,g,h,i,j,k;i=null;f=null;for(k=0;k<a.g[b].length;k++){g=a.g[b][k];a.f[g]&&(a.o[g]==1||a.o[g]==2)&&(a.k[g]==0?f=o_.ug(f,(e[g]<<16)+g):a.k[g]==d&&a.j[g]==c&&(i=o_.ug(i,(e[g]<<16)+g)));}h=o_.Mg(i,f);if(h==0)return false;if(h<0){for(j=0;j<a.g[b].length;j++){g=a.g[b][j];if(a.f[g]&&(a.o[g]==1||a.o[g]==2)){if(a.k[g]==0){a.k[g]=d<<24>>24;a.j[g]=c<<24>>24;}else if(a.k[g]==d&&a.j[g]==c){a.k[g]=0;a.j[g]=-1;}}}}return true;};o_.ng=function ng(a,b){var c,d,e,f,g,h;if(!a.b)return false;e=false;for(f=a.b.a.length-1;f>=0;f--){d=false;g=l_.Th(a.b,f);g.a==2?d=o_.mg(a,g.b,g.c,g.d,b):g.a==1&&(d=o_.rg(a,g.b,b));if(d){l_._h(a.b,g);for(h=0;h<a.g[g.b].length;h++){c=a.g[g.b][h];a.n[c]=false;}e=true;}}return e;};o_.og=function og(a){var b,c,d,e,f,g,h,i;if(a.g!=null){g=new o_.Lg(a);a.b=new l_.gi();for(e=0;e<a.g.length;e++){d=o_.Dg(g,e);if(d==0){o_.zg(g,e);h=o_.fg(a,e,2);b=o_.fg(a,e,1);c=o_.eg(a,e);if(h==1&&b==1&&!c){o_.qg(a,e,g.a+g.f++);l_.Oh(a.b,new o_.Di(e,1,-1,-1));}if(h>0){if(c){o_.pg(a,e,g.i+g.g++,2);++h;}l_.Oh(a.b,new o_.Di(e,1,-1,-1));}else if(b>0){c&&o_.pg(a,e,g.a+g.f++,1);l_.Oh(a.b,new o_.Di(e,1,-1,-1));}else if(c){o_.pg(a,e,g.a+g.f++,1);l_.Oh(a.b,new o_.Di(e,1,-1,-1));}}else if(d==1){if(o_.eg(a,e)){f=o_.Cg(g,e);i=o_.Eg(g,e);l_.Oh(a.b,new o_.Di(e,2,f,i));}else {o_.zg(g,e);l_.Oh(a.b,new o_.Di(e,1,-1,-1));}}}}};o_.pg=function pg(a,b,c,d){var e,f;for(f=0;f<a.g[b].length;f++){e=a.g[b][f];if(a.f[e]&&(a.o[e]==1||a.o[e]==2)&&a.k[e]==0){a.k[e]=d<<24>>24;a.j[e]=c<<24>>24;}}};o_.qg=function qg(a,b,c){var d,e;for(e=0;e<a.g[b].length;e++){d=a.g[b][e];if(a.k[d]==2){a.k[d]=1;a.j[d]=c<<24>>24;}}};o_.rg=function rg(a,b,c){var d,e,f,g,h,i,j,k;f=a.g[b];e=1;for(i=0;i<f.length;i++){d=f[i];if(a.f[d]&&a.k[d]==2){e=2;break;}}g=OI(h_.hK,d1,6,32,0,2);for(j=0;j<f.length;j++){d=f[j];a.f[d]&&a.k[d]==e&&(g[a.j[d]]=o_.ug(g[a.j[d]],(c[d]<<16)+d));}for(k=0;k<32;k++)g[k]!=null&&n_.V$(g[k]).sort(n_.V$(AO(l_.pX.prototype.Ub,l_.pX,[])));l_.fX(g,new o_.Ng());if(o_.Mg(g[0],g[1])==0)return false;for(h=0;h<g[0].length;h++){d=g[0][h]&f0;a.k[d]=0;a.j[d]=-1;}return true;};o_.sg=function sg(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;i=OI(h_.hK,k0,5,a.i.d,15,1);s=OI(h_.hK,k0,5,a.i.d,15,1);o=OI(h_.DN,C0,5,a.i.d,16,1);p=OI(h_.DN,C0,5,a.i.d,16,1);j=OI(h_.DN,C0,5,a.i.d,16,1);i[0]=b;s[b]=c;s[c]=-2;o[b]=true;o[c]=true;f=0;k=0;while(f<=k){g=i[f];if(s[g]==g){for(l=0;l<o_.Am(a.i,g);l++){d=o_.zm(a.i,g,l);if(!o[d]){if(o_.Cm(a.i,g,l)==2&&o_.Ij(a.i,d)<10){i[++k]=d;s[d]=d;j[d]=j[g]||o_.qm(a.i,d)==2;p[d]=j[g]&&!p[g];o[d]=true;}else if(j[g]&&p[g]){t=o_.hg(a,d,s[g],o);if(t==-1)return null;i[++k]=d;s[d]=t;s[t]=-2;j[d]=false;o[d]=true;o[t]=true;}else if(o_.xn(a.i,o_.Bm(a.i,g,l))){i[++k]=d;s[d]=d;j[d]=false;o[d]=true;if((o_.Ij(a.i,d)==6&&o_.qm(a.i,d)==0||o_.Ij(a.i,d)==7&&o_.rj(a.i,d)==1||o_.Ij(a.i,d)==14||o_.Ij(a.i,d)==15&&o_.Am(a.i,d)>2||o_.Ij(a.i,d)==16&&o_.Am(a.i,d)>2)&&o_.Am(a.i,d)>2){h=false;for(q=1;q<o_.Am(a.i,d);q++){u=o_.zm(a.i,d,q);if(!o[u]){for(r=0;r<q;r++){v=o_.zm(a.i,d,r);if(!o[v]){if(o_.lg(a,u,v)){i[++k]=u;s[u]=v;s[v]=-2;j[u]=false;o[u]=true;o[v]=true;h=true;}}}}}if(!h)return null;}}}}}else {e=OI(h_.DN,C0,5,o_.Am(a.i,g),16,1);for(m=0;m<o_.Am(a.i,g);m++){d=o_.zm(a.i,g,m);if(o[d]){e[m]=s[d]==d;}else {for(q=0;q<o_.Am(a.i,d);q++){if(o_.zm(a.i,d,q)==s[g]){e[m]=true;break;}}}}for(n=0;n<o_.Am(a.i,g);n++){if(e[n]){d=o_.zm(a.i,g,n);if(o[d]){if(o_.xm(a.i,d,s[g])==-1)return null;}else {i[++k]=d;s[d]=d;p[d]=false;j[d]=true;o[d]=true;}}}for(l=0;l<o_.Am(a.i,g);l++){if(!e[l]){d=o_.zm(a.i,g,l);if(!o[d]){t=o_.hg(a,d,s[g],o);if(t==-1)return null;i[++k]=d;s[d]=t;s[t]=-2;j[d]=false;o[d]=true;o[t]=true;}}}}++f;}return o;};o_.tg=function tg(a,b,c,d,e,f,g,h,i,j){this.i=a;this.a=b;this.f=c;this.o=d;this.c=e;this.k=f;this.j=g;this.p=h;this.d=i;this.n=j;o_.gg(this);};o_.ug=function ug(a,b){var c,d;d=OI(h_.hK,k0,5,a==null?1:a.length+1,15,1);for(c=0;c<d.length-1;c++)d[c]=a[c];d[d.length-1]=b;return d;};xO(166,1,{},o_.tg);h_.vK=jQ(166);o_.vg=function vg(a,b){var c;if(a.length!=b.length)return a.length<b.length?-1:1;for(c=0;c<a.length;c++)if(a[c]!=b[c])return a[c]<b[c]?-1:1;return 0;};o_.wg=function wg(){};xO(169,1,{},o_.wg);_.kb=function xg(a,b){return o_.vg(a,b);};_.gb=function yg(a){return this===a;};h_.tK=jQ(169);o_.zg=function zg(a,b){var c,d,e,f,g,h;for(e=0;e<a.b;e++){if(a.e[e][b]&&a.c[e]!=-3){for(d=0;d<=a.j.g.length;d++){if(d!=b&&a.e[e][d]){a.e[e][b]=false;h=e<a.a?e:e<a.b?e-a.a:-1;g=o_.Jg(a,e<a.a?1:e<a.b?2:0);for(f=0;f<a.j.g[b].length;f++){c=a.j.g[b][f];o_.ig(a.j,c)&&a.j.j[c]==h&&(a.j.j[c]=g<<24>>24);}}}}}};o_.Ag=function Ag(a,b,c){var d,e,f,g,h;h=false;g=1;b[c]=g;d=true;while(d){d=false;for(e=0;e<a.b;e++){if(b[e]==g){for(f=0;f<a.b;f++){if(b[f]==0&&o_.Ig(a,e,f)){if(a.c[f]==-2){b[f]=g+1;d=true;}else if(a.c[f]!=a.c[c]){b[f]=g+1;h=true;}}}}}++g;}return h;};o_.Bg=function Bg(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o;for(i=d+1;i<a.j.g.length;i++){if(i!=d&&a.e[b][i]&&a.e[c][i]){g=OI(h_.hK,k0,5,2,15,1);g[0]=c;g[1]=b;return g;}}o=OI(h_.hK,k0,5,a.b,15,1);k=OI(h_.hK,k0,5,a.b,15,1);j=OI(h_.hK,k0,5,a.b,15,1);f=0;l=0;j[0]=b;k[b]=1;while(f<=l){for(m=0;m<a.d[j[f]].length;m++){e=a.d[j[f]][m];if(e==c){if(f==0)continue;h=k[j[f]]+1;g=OI(h_.hK,k0,5,h,15,1);g[0]=e;g[1]=j[f];for(n=2;n<h;n++)g[n]=o[g[n-1]];return g;}if(k[e]==0&&a.c[e]!=-3){k[e]=k[j[f]]+1;j[++l]=e;o[e]=j[f];}}++f;}return null;};o_.Cg=function Cg(a,b){var c;for(c=0;c<a.b;c++)if(a.e[c][b]&&a.c[c]==-3)return c<a.a?c:c<a.b?c-a.a:-1;return -1;};o_.Dg=function Dg(a,b){var c,d;c=0;for(d=0;d<a.b;d++)a.e[d][b]&&a.c[d]==-3&&++c;return c;};o_.Eg=function Eg(a,b){var c;for(c=0;c<a.b;c++)if(a.e[c][b]&&a.c[c]==-3)return c<a.a?1:c<a.b?2:0;return -1;};o_.Fg=function Fg(a,b){return b<a.a?b:b<a.b?b-a.a:-1;};o_.Gg=function Gg(a,b){return b<a.a?1:b<a.b?2:0;};o_.Hg=function Hg(a,b){var c,d;d=a.j.k[b];c=a.j.j[b];return d==0?a.b:d==1?c:a.a+c;};o_.Ig=function Ig(a,b,c){var d;for(d=0;d<a.j.g.length;d++)if(a.e[b][d]&&a.e[c][d])return true;return false;};o_.Jg=function Jg(a,b){return b==1?a.a+a.f++:a.i+a.g++;};o_.Kg=function Kg(a,b){var c,d,e,f,g,h,i,j,k,l;k=P_;i=-1;l=-1;j=-1;for(d=0;d<a.j.i.d;d++){if(o_.ig(a.j,d)&&a.j.k[d]!=0){for(h=0;h<b.length;h++){e=o_.Fg(a,b[h]);f=o_.Gg(a,b[h]);if(a.j.k[d]==f&&a.j.j[d]==e){if(k>a.j.a[d]+(f==1?e0:0)){k=a.j.a[d]+(f==1?e0:0);i=e;l=f;j=b[h];}}}}}for(c=0;c<a.j.i.d;c++){if(o_.ig(a.j,c)&&a.j.k[c]==l&&a.j.j[c]==i){a.j.k[c]=0;a.j.j[c]=-1;}}for(g=0;g<a.j.g.length;g++)a.e[j][g]=false;};o_.Lg=function Lg(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;this.j=a;for(d=0;d<a.i.d;d++){a.f[d]&&(a.o[d]==1||a.o[d]==2)&&(a.k[d]==1?this.a<=a.j[d]&&(this.a=1+a.j[d]):a.k[d]==2&&this.i<=a.j[d]&&(this.i=1+a.j[d]));}this.b=this.a+this.i;this.e=MI(h_.DN,[K_,C0],[11,5],16,[this.b+1,a.g.length+1],2);for(e=0;e<a.i.d;e++)a.f[e]&&(a.o[e]==1||a.o[e]==2)&&!a.e[e]&&(this.e[o_.Hg(this,e)][a.g.length]=true);for(i=0;i<a.g.length;i++){for(q=0;q<a.g[i].length;q++){c=a.g[i][q];a.f[c]&&(a.o[c]==1||a.o[c]==2)&&(this.e[o_.Hg(this,c)][i]=true);}}this.d=OI(h_.hK,d1,6,this.b,0,2);for(j=0;j<a.g.length;j++){for(n=1;n<this.b;n++){if(this.e[n][j]){for(o=0;o<n;o++){if(this.e[o][j]){this.d[n]=o_.ug(this.d[n],o);this.d[o]=o_.ug(this.d[o],n);}}}}}this.c=OI(h_.hK,k0,5,this.b+1,15,1);for(m=0;m<this.b;m++){this.e[m][a.g.length]?this.c[m]=-1:this.c[m]=-2;}for(k=0;k<a.g.length;k++){if(this.e[this.b][k]){for(l=0;l<this.b;l++){this.e[l][k]&&this.c[l]!=k&&(this.c[l]==-2?this.c[l]=k:this.c[l]=-3);}}}for(b=0;b<this.b;b++){if(this.c[b]>=-1){f=OI(h_.hK,k0,5,this.b,15,1);if(o_.Ag(this,f,b)){for(l=0;l<this.b;l++){f[l]!=0&&(this.c[l]=-3);}}}}for(h=0;h<a.g.length-1;h++){for(n=1;n<this.b;n++){if(this.e[n][h]&&this.c[n]!=-3){for(o=0;o<n;o++){if(this.e[o][h]&&this.c[o]!=-3){g=o_.Bg(this,n,o,h);if(g!=null){for(p=0;p<g.length;p++)this.c[g[p]]=-3;o_.Kg(this,g);break;}}}}}}};xO(167,1,{},o_.Lg);_.a=0;_.b=0;_.f=0;_.g=0;_.i=0;h_.uK=jQ(167);o_.Mg=function Mg(a,b){var c,d;if(a==null)return b==null?0:1;if(b==null)return -1;c=$wnd.Math.min(a.length,b.length);for(d=0;d<c;d++)if((a[d]&j1)!=(b[d]&j1))return (a[d]&j1)<(b[d]&j1)?-1:1;return a.length==b.length?0:a.length<b.length?-1:1;};o_.Ng=function Ng(){};xO(168,1,{},o_.Ng);_.kb=function Og(a,b){return o_.Mg(a,b);};_.gb=function Pg(a){return this===a;};h_.wK=jQ(168);o_.Qg=function Qg(a,b){if(a.a!=b.a)return a.a<b.a?-1:1;if(a.b!=b.b)return a.b<b.b?-1:1;if(a.c!=b.c)return a.c<b.c?-1:1;return 0;};o_.Rg=function Rg(a,b){return $wnd.Math.sqrt((b.a-a.a)*(b.a-a.a)+(b.b-a.b)*(b.b-a.b)+(b.c-a.c)*(b.c-a.c));};o_.Sg=function Sg(a,b,c,d){a.a=b;a.b=c;a.c=d;};o_.Tg=function Tg(a,b){o_.Sg(a,b.a,b.b,b.c);return a;};o_.Ug=function Ug(){};o_.Vg=function Vg(a,b,c){this.a=a;this.b=b;this.c=c;};o_.Wg=function Wg(a){o_.Vg.call(this,a.a,a.b,a.c);};xO(34,1,{34:1,4:1,30:1},o_.Ug,o_.Vg,o_.Wg);_.lb=function Xg(a){return o_.Qg(this,a);};_.gb=function Yg(a){var b;if(a==null||!VJ(a,34))return false;b=a;return $wnd.Math.abs(b.a-this.a)+$wnd.Math.abs(b.b-this.b)+$wnd.Math.abs(b.c-this.c)<1.0E-6;};_.jb=function Zg(){var a;a=new F_.LU('0.00');return '['+F_.KU(a,this.a)+', '+F_.KU(a,this.b)+', '+F_.KU(a,this.c)+']';};_.a=0;_.b=0;_.c=0;h_.yK=jQ(34);o_.$g=function $g(a,b){b.c*=a.c;b.a=b.a*a.c+a.a;b.b=b.b*a.c+a.b;};o_._g=function _g(a,b){b.a=b.a*a.c+a.a;b.b=b.b*a.c+a.b;};o_.ah=function ah(a,b){b.c=b.c*a.c+a.a;b.d=b.d*a.c+a.b;b.b*=a.c;b.a*=a.c;};o_.bh=function bh(a){a.a=0;a.b=0;a.c=1;};o_.dh=function dh(a,b){return b*a.c+a.a;};o_.eh=function eh(a,b){return b*a.c+a.b;};o_.fh=function fh(){o_.bh(this);};o_.gh=function gh(a,b,c){var d,e,f,g;o_.bh(this);e=b.b/a.b;g=b.a/a.a;f=0;f==0&&(f=24);d=f/c;this.c=$wnd.Math.min(d,$wnd.Math.min(e,g));this.a=b.c+b.b/2-this.c*(a.c+a.b/2);this.b=b.d+b.a/2-this.c*(a.d+a.a/2);};xO(98,1,{},o_.fh,o_.gh);_.jb=function hh(){return 'DepictorTransformation Offset: '+this.a+','+this.b+' Scaling: '+this.c;};_.a=0;_.b=0;_.c=0;h_.zK=jQ(98);o_.zi=function zi(a){var b,c;c=new i_._R();for(b=0;b<a.a.length;b++)i_.$R(c,(n_.L$(b,a.a.length),a.a[b]).ec()+J_);return c.a;};o_.Ai=function Ai(b){var c;l_.gi.call(this);try{if(b){for(c=0;c<b.a.length;c++)l_.Oh(this,(n_.L$(c,b.a.length),b.a[c]).ec());}}catch(a){a=HN(a);if(!VJ(a,13))throw IN(a);}};o_.Bi=function Bi(a){var b,c;l_.gi.call(this);if(a==null||n_.V$(a).length==0)return;b=0;c=i_.KR(a,VR(10));while(c!=-1){n_.V$(a).substr(b,c-b);b=c+1;c=i_.LR(a,VR(10),b);}};xO(107,18,i0,o_.Ai,o_.Bi);_.jb=function Ci(){return o_.zi(this);};h_.AK=jQ(107);o_.Di=function Di(a,b,c,d){this.b=a;this.a=b;this.c=c;this.d=d;};xO(55,1,{55:1},o_.Di);_.a=0;_.b=0;_.c=0;_.d=0;h_.BK=jQ(55);o_.Ei=function Ei(a){var b,c,d,e,f,g;if(a.j!=0)return a.j;if(a.i&&o_.Ij(a.e,a.a)!=15&&o_.Ij(a.e,a.a)!=16){for(g=0;g<o_.mm(a.e,a.a);g++){f=o_.Bm(a.e,a.a,g);if(o_.Ek(a.e,f,a.a)){o_.zm(a.e,a.a,g)==a.b?a.j=o_.Yj(a.e,f)==17?3:1:a.j=o_.Yj(a.e,f)==17?1:3;return a.j;}}}b=o_.Mj(a.e,a.a,a.g);d=o_.Mj(a.e,a.a,a.b);d<b&&(d+=G0);if(o_.mm(a.e,a.a)==2){c=d-b;if(c>3.0915926535897933&&c<3.191592653589793){a.j=-1;return a.j;}a.j=c<H0?4:2;return a.j;}else {e=o_.Mj(a.e,a.a,a.d);e<b&&(e+=G0);a.j=e<d?2:4;return a.j;}};o_.Fi=function Fi(a,b,c,d){var e,f,g,h;this.e=a;this.g=c;this.a=d;g=-1;for(h=0;h<o_.mm(this.e,this.a);h++){e=o_.zm(this.e,this.a,h);f=o_.Bm(this.e,this.a,h);if(e==this.g){o_.Yj(this.e,f)==26&&(this.j=-1);continue;}if(o_.Ek(this.e,f,this.a)){this.i&&(a.s[d]|=h1);this.i=true;}if(g==b[e]){this.d=e;this.f=true;this.c=o_.xn(this.e,f);}else if(g<b[e]){g=b[e];this.d=this.b;this.b=e;}else {this.d=e;}}};xO(64,1,{},o_.Fi);_.a=0;_.b=0;_.c=false;_.d=0;_.f=false;_.g=0;_.i=false;_.j=0;h_.CK=jQ(64);o_.Li=function Li(){o_.Li=zO;o_.Gi=XI(II(h_.uM,1),d0,2,6,['?','H','He','Li','Be','B','C','N','O','F','Ne','Na','Mg','Al','Si','P','S','Cl','Ar','K','Ca','Sc','Ti','V','Cr','Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As','Se','Br','Kr','Rb','Sr','Y','Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn','Sb','Te','I','Xe','Cs','Ba','La','Ce','Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb','Lu','Hf','Ta','W','Re','Os','Ir','Pt','Au','Hg','Tl','Pb','Bi','Po','At','Rn','Fr','Ra','Ac','Th','Pa','U','Np','Pu','Am','Cm','Bk','Cf','Es','Fm','Md','No','Lr','Rf','Db','Sg','Bh','Hs','Mt','Ds','Rg','Cn','Nh','Fl','Mc','Lv','Ts','Og',k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,'R4','R5','R6','R7','R8','R9','R10','R11','R12','R13','R14','R15','R16','R1','R2','R3','A','A1','A2','A3',k1,k1,'D','T','X','R','H2','H+','Nnn','HYD','Pol',k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,'Ala','Arg','Asn','Asp','Cys','Gln','Glu','Gly','His','Ile','Leu','Lys','Met','Phe','Pro','Ser','Thr','Trp','Tyr','Val']);o_.Ji=XI(II(h_.CN,1),f1,5,15,[0,1,4,7,9,11,12,14,16,19,20,23,24,27,28,31,32,35,40,39,40,45,48,51,52,55,56,59,58,63,64,69,74,75,80,79,84,85,88,89,90,93,98,0,102,103,106,107,114,115,120,121,130,127,132,133,138,139,140,141,142,0,152,153,158,159,164,165,166,169,174,175,180,181,184,187,192,193,195,197,202,205,208,209,209,210,222,223,226,227,232,231,238,237,244,243,247,247,251,252,257,258,259,262,267,268,271,270,277,276,281,281,283,285,289,289,293,294,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,156,114,115,103,128,129,57,137,113,113,128,131,147,97,87,101,186,163,99]);o_.Hi=XI(II(h_.dK,2),K_,8,0,[null,XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[0]),XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[4]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[0]),XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[4]),XI(II(h_.dK,1),j0,5,15,[3,5]),XI(II(h_.dK,1),j0,5,15,[2,4,6]),XI(II(h_.dK,1),j0,5,15,[1,3,5,7]),XI(II(h_.dK,1),j0,5,15,[0]),XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),null,null,null,null,null,null,null,null,null,null,XI(II(h_.dK,1),j0,5,15,[2,3]),XI(II(h_.dK,1),j0,5,15,[2,4]),XI(II(h_.dK,1),j0,5,15,[3,5]),XI(II(h_.dK,1),j0,5,15,[2,4,6]),XI(II(h_.dK,1),j0,5,15,[1,3,5,7]),XI(II(h_.dK,1),j0,5,15,[0,2]),XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),null,null,null,null,null,null,null,null,null,null,XI(II(h_.dK,1),j0,5,15,[1,2,3]),XI(II(h_.dK,1),j0,5,15,[2,4]),XI(II(h_.dK,1),j0,5,15,[3,5]),XI(II(h_.dK,1),j0,5,15,[2,4,6]),XI(II(h_.dK,1),j0,5,15,[1,3,5,7]),XI(II(h_.dK,1),j0,5,15,[0,2,4,6]),XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[2])]);o_.Ii=XI(II(h_.dK,2),K_,8,0,[null,XI(II(h_.dK,1),j0,5,15,[1]),null,XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),null,null,XI(II(h_.dK,1),j0,5,15,[-3]),XI(II(h_.dK,1),j0,5,15,[-2]),XI(II(h_.dK,1),j0,5,15,[-1]),null,XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[3]),null,XI(II(h_.dK,1),j0,5,15,[-3]),XI(II(h_.dK,1),j0,5,15,[-2]),XI(II(h_.dK,1),j0,5,15,[-1]),null,XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[2,3,4]),XI(II(h_.dK,1),j0,5,15,[2,3,4,5]),XI(II(h_.dK,1),j0,5,15,[2,3,6]),XI(II(h_.dK,1),j0,5,15,[2,3,4,7]),XI(II(h_.dK,1),j0,5,15,[2,3]),XI(II(h_.dK,1),j0,5,15,[2,3]),XI(II(h_.dK,1),j0,5,15,[2,3]),XI(II(h_.dK,1),j0,5,15,[1,2]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[2,4]),XI(II(h_.dK,1),j0,5,15,[-3,3,5]),XI(II(h_.dK,1),j0,5,15,[-2]),XI(II(h_.dK,1),j0,5,15,[-1]),null,XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[4]),XI(II(h_.dK,1),j0,5,15,[3,5]),XI(II(h_.dK,1),j0,5,15,[6]),XI(II(h_.dK,1),j0,5,15,[4,6,7]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[2,4]),XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[2,4]),XI(II(h_.dK,1),j0,5,15,[-3,3,5]),XI(II(h_.dK,1),j0,5,15,[-2,4,6]),XI(II(h_.dK,1),j0,5,15,[-1]),null,XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3,4]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[2,3]),XI(II(h_.dK,1),j0,5,15,[2,3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[2,3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[4]),XI(II(h_.dK,1),j0,5,15,[5]),XI(II(h_.dK,1),j0,5,15,[6]),XI(II(h_.dK,1),j0,5,15,[4,6,7]),XI(II(h_.dK,1),j0,5,15,[3,4]),XI(II(h_.dK,1),j0,5,15,[3,4]),XI(II(h_.dK,1),j0,5,15,[2,4]),XI(II(h_.dK,1),j0,5,15,[1,3]),XI(II(h_.dK,1),j0,5,15,[1,2]),XI(II(h_.dK,1),j0,5,15,[1,3]),XI(II(h_.dK,1),j0,5,15,[2,4]),XI(II(h_.dK,1),j0,5,15,[3,5]),XI(II(h_.dK,1),j0,5,15,[-2,2,4]),XI(II(h_.dK,1),j0,5,15,[-1,1]),null,XI(II(h_.dK,1),j0,5,15,[1]),XI(II(h_.dK,1),j0,5,15,[2]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[4]),XI(II(h_.dK,1),j0,5,15,[4,5]),XI(II(h_.dK,1),j0,5,15,[3,4,5,6]),XI(II(h_.dK,1),j0,5,15,[3,4,5,6]),XI(II(h_.dK,1),j0,5,15,[3,4,5,6]),XI(II(h_.dK,1),j0,5,15,[3,4,5,6]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3,4]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[3]),XI(II(h_.dK,1),j0,5,15,[2,3]),XI(II(h_.dK,1),j0,5,15,[2,3]),XI(II(h_.dK,1),j0,5,15,[3])]);};o_.Mi=function Mi(a,b,c,d){var e;e=o_.Ni(a,6);o_.Sg(a.H[e],b,c,d);return e;};o_.Ni=function Ni(a,b){a.o>=a.K&&o_.Bl(a,a.K*2);a.A[a.o]=0;o_.ml(a,a.o,b);a.q[a.o]=0;a.s[a.o]=0;a.w[a.o]=0;a.u[a.o]=0;o_.Sg(a.H[a.o],0,0,0);a.t!=null&&(a.t[a.o]=null);a.r!=null&&(a.r[a.o]=null);a.R=0;return a.o++;};o_.Oi=function Oi(a,b,c){var d,e;return o_.Pi(a,b,c,(e=a.A[b],e>=3&&e<=4||e>=11&&e<=13||e>=19&&e<=31||e>=37&&e<=51||e>=55&&e<=84||e>=87&&e<=103||(d=a.A[c],d>=3&&d<=4||d>=11&&d<=13||d>=19&&d<=31||d>=37&&d<=51||d>=55&&d<=84||d>=87&&d<=103)?32:1));};o_.Pi=function Pi(a,b,c,d){var e;if(b==c)return -1;for(e=0;e<a.p;e++){if(a.B[0][e]==b&&a.B[1][e]==c||a.B[0][e]==c&&a.B[1][e]==b){a.F[e]<d&&(a.F[e]=d);return e;}}a.p>=a.L&&o_.Cl(a,a.L*2);a.B[0][a.p]=b;a.B[1][a.p]=c;a.F[a.p]=d;a.C[a.p]=0;a.D[a.p]=0;a.R=0;return a.p++;};o_.Qi=function Qi(a,b){var c,d,e,f,g;a.I=a.I|b.I;d=OI(h_.hK,k0,5,b.o,15,1);f=o_.Pk(a,1);g=o_.Pk(a,2);for(c=0;c<b.o;c++){d[c]=o_.bj(b,a,c,f,g);}for(e=0;e<b.p;e++){o_.cj(b,a,e,f,g,d[b.B[0][e]],d[b.B[1][e]],false);}a.J=a.J&&b.J;a.G=0;a.R=0;return d;};o_.Ri=function Ri(a,b,c,d,e,f,g,h){var i,j;i=o_.nj(a,b,c);if(i==-1){a.o>=a.K&&o_.Bl(a,a.K*2);i=o_.Ni(a,d);o_.Sg(a.H[i],b,c,0);a.v[i]=e;o_.Tk(a,i,f);o_.gl(a,i,g);o_.Yk(a,i,h);return true;}j=o_.Yi(a,i,d,e,f,g);o_.Yk(a,i,h);return j;};o_.Si=function Si(a,b,c,d){var e;for(e=0;e<a.p;e++){if(a.B[0][e]==b&&a.B[1][e]==c||a.B[0][e]==c&&a.B[1][e]==b){o_.$i(a,e,d);a.R=0;return e;}}a.p>=a.L&&o_.Cl(a,a.L*2);a.B[0][a.p]=b;a.B[1][a.p]=c;a.F[a.p]=d;a.C[a.p]=0;a.D[a.p]=0;a.R=0;return a.p++;};o_.Ti=function Ti(a,b,c,d,e){var f,g,h;while(a.o+d>a.K)o_.Bl(a,a.K*2);while(a.p+d>a.L)o_.Cl(a,a.L*2);f=o_.nj(a,b,c);if(f!=-1)return o_.Ui(a,f,d,e);g=o_.oj(a,b,c);if(g!=-1)return o_.Vi(a,g,d,e);f=o_.Mi(a,b,c,0);h=H0*(d-2)/d;o_.Hk(a,f,d,f,e,0,H0-h);a.R=0;return true;};o_.Ui=function Ui(a,b,c,d){var e,f,g,h,i,j;if(d&&o_.Sm(a,b)>1||!d&&o_.Sm(a,b)>2)return false;f=0;e=OI(h_.fK,B0,5,4,15,1);for(h=0;h<a.p;h++){for(i=0;i<2;i++){if(a.B[i][h]==b){if(f==2){f=3;break;}e[f++]=o_.Mj(a,b,a.B[1-i][h]);}}if(f==3)break;}if(f==3)return false;j=f==1?e[0]+H0:$wnd.Math.abs(e[0]-e[1])>H0?(e[0]+e[1])/2:(e[0]+e[1])/2+H0;g=H0*(c-2)/c;o_.Hk(a,b,c,b,d,j-g/2,H0-g);a.R=0;return true;};o_.Vi=function Vi(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o;i=OI(h_.hK,k0,5,2,15,1);h=OI(h_.fK,B0,5,2,15,1);i[0]=a.B[0][b];i[1]=a.B[1][b];if(o_.Sm(a,i[0])>3)return false;if(o_.Sm(a,i[1])>3)return false;f=0;e=OI(h_.fK,B0,5,4,15,1);for(l=0;l<a.p;l++){if(l==b)continue;for(m=0;m<2;m++){for(n=0;n<2;n++){if(a.B[m][l]==i[n]){if(f==4){f=5;break;}e[f++]=o_.Mj(a,i[n],a.B[1-m][l]);}}if(f==5)break;}if(f==5)break;}if(f==5)return false;h[0]=o_.Mj(a,i[0],i[1]);if(h[0]<0){h[1]=h[0]+H0;g=0;}else {h[1]=h[0];h[0]=h[1]-H0;g=1;}o=0;for(k=0;k<f;k++){e[k]>h[0]&&e[k]<h[1]?--o:++o;}g=o>0?1-g:g;j=H0*(c-2)/c;o_.Hk(a,i[g],c-1,i[1-g],d,h[o>0?0:1]+H0-j,H0-j);a.R=0;return true;};o_.Wi=function Wi(a,b,c){var d,e,f,g,h;e=OI(h_.hK,k0,5,b.o,15,1);g=o_.Pk(a,1);h=o_.Pk(a,2);for(d=0;d<b.o;d++){b.A[d]!=0?e[d]=o_.bj(b,a,d,g,h):e[d]=c;}for(f=0;f<b.p;f++){o_.cj(b,a,f,g,h,e[b.B[0][f]],e[b.B[1][f]],false);}a.J=a.J&&b.J;a.G=0;a.R=0;return e;};o_.Xi=function Xi(a,b){var c,d,e,f,g,h,i,j,k;c=a.H[b[0]];d=a.H[b[1]];e=a.H[b[2]];f=a.H[b[3]];i=new o_.Vg(d.a-c.a,d.b-c.b,d.c-c.c);j=new o_.Vg(e.a-d.a,e.b-d.b,e.c-d.c);k=new o_.Vg(f.a-e.a,f.b-e.b,f.c-e.c);g=new o_.Vg(i.b*j.c-i.c*j.b,-(i.a*j.c-i.c*j.a),i.a*j.b-i.b*j.a);h=new o_.Vg(j.b*k.c-j.c*k.b,-(j.a*k.c-j.c*k.a),j.a*k.b-j.b*k.a);return -$wnd.Math.atan2($wnd.Math.sqrt(j.a*j.a+j.b*j.b+j.c*j.c)*(i.a*h.a+i.b*h.b+i.c*h.c),g.a*h.a+g.b*h.b+g.c*h.c);};o_.Yi=function Yi(a,b,c,d,e,f){if((c==1||c==151||c==152)&&o_.Sm(a,b)>1)return false;a.w[b]&=-2;a.t!=null&&(a.t[b]=null);a.r!=null&&(a.r[b]=null);if(c==a.A[b]&&d==a.v[b]&&e==((a.s[b]&l1)>>>28)-1&&f==(a.s[b]&48))return false;if(c==151||c==152){d=c-149;c=1;}a.s[b]&=960;a.A[b]=c;a.v[b]=d;a.q[b]=0;a.w[b]=0;o_.Tk(a,b,e);o_.gl(a,b,f);o_.Nk(a,a.u[b]);a.R=0;return true;};o_.Zi=function Zi(a,b,c){if(c){if(a.q[b]>8)return false;++a.q[b];}else {if(a.q[b]<-8)return false;--a.q[b];}a.R=0;return true;};o_.$i=function $i(a,b,c){var d,e,f,g,h;f=false;g=a.F[b];if(c==127){f=o_.fk(a,b);}else if(o_.Rn(a,b,c)){if(c==17||c==9){d=o_.Ik(a,b,a.B[0][b]);e=o_.Ik(a,b,a.B[1][b]);if(c==g){if(d==e||e){h=a.B[0][b];a.B[0][b]=a.B[1][b];a.B[1][b]=h;f=true;}}else {if(!d&&e){h=a.B[0][b];a.B[0][b]=a.B[1][b];a.B[1][b]=h;}a.F[b]=c;f=true;}}else {a.F[b]=c;f=true;}}if(f){a.R=(g&103)==(c&103)?a.R&7:0;a.D[b]=0;}return f;};o_._i=function _i(a){a.o=0;a.p=0;a.I=false;a.J=false;a.G=0;a.t=null;a.r=null;a.N=null;a.R=0;};o_.aj=function aj(a){var b,c,d,e,f,g,h,i;for(g=0;g<a.p;g++){if(a.F[g]==128){c=a.B[0][g];d=a.B[1][g];if(a.A[c]==-1^a.A[d]==-1){if(a.q[c]!=0&&a.q[d]!=0){if(a.q[c]<0^a.q[d]<0){if(a.q[c]<0){++a.q[c];--a.q[d];}else {--a.q[c];++a.q[d];}}}}}}i=OI(h_.hK,k0,5,a.o,15,1);e=0;for(b=0;b<a.o;b++){if(a.A[b]==-1){i[b]=-1;continue;}if(e<b){a.A[e]=a.A[b];a.q[e]=a.q[b];a.v[e]=a.v[b];a.s[e]=a.s[b];a.w[e]=a.w[b];a.u[e]=a.u[b];o_.Tg(a.H[e],a.H[b]);a.t!=null&&(a.t[e]=a.t[b]);a.r!=null&&(a.r[e]=a.r[b]);}i[b]=e;++e;}a.o=e;h=0;for(f=0;f<a.p;f++){if(a.F[f]==128)continue;a.F[h]=a.F[f];a.C[h]=a.C[f];a.D[h]=a.D[f];a.B[0][h]=i[a.B[0][f]];a.B[1][h]=i[a.B[1][f]];++h;}a.p=h;return i;};o_.bj=function bj(a,b,c,d,e){var f,g,h;f=b.o;f>=b.K&&o_.Bl(b,b.K*2);h=(a.s[c]&Y0)>>19;g=-1;h==1?d==-1?g=o_.Pk(b,h):g=$wnd.Math.min(31,d+((a.s[c]&Y0)>>19!=1&&(a.s[c]&Y0)>>19!=2?-1:(a.s[c]&m1)>>21)):h==2&&(e==-1?g=o_.Pk(b,h):g=$wnd.Math.min(31,e+((a.s[c]&Y0)>>19!=1&&(a.s[c]&Y0)>>19!=2?-1:(a.s[c]&m1)>>21)));b.A[f]=a.A[c];b.q[f]=a.q[c];b.v[f]=a.v[c];b.s[f]=a.s[c];b.w[f]=b.I?a.w[c]:0;o_.Tg(b.H[f],a.H[c]);b.u[f]=a.u[c];b.t!=null&&(b.t[f]=null);if(a.t!=null&&a.t[c]!=null&&b.I){b.t==null&&(b.t=OI(h_.hK,d1,6,b.A.length,0,2));b.t[f]=l_.PW(a.t[c],a.t[c].length);}b.r!=null&&(b.r[f]=null);if(a.r!=null&&a.r[c]!=null){b.r==null&&(b.r=OI(h_.dK,K_,8,b.A.length,0,2));b.r[f]=l_.OW(a.r[c],a.r[c].length);}if(g!=-1){b.s[f]&=-65011713;b.s[f]|=g<<21;}++b.o;b.R=0;return f;};o_.cj=function cj(a,b,c,d,e,f,g,h){var i,j,k,l;j=b.p;j>=b.L&&o_.Cl(b,b.L*2);l=(a.C[c]&n1)>>10;k=-1;l==1&&(d==-1?k=o_.Pk(b,l):k=$wnd.Math.min(32,d+((a.C[c]&n1)>>10!=1&&(a.C[c]&n1)>>10!=2?-1:(a.C[c]&o1)>>12)));l==2&&(e==-1?k=o_.Pk(b,l):k=$wnd.Math.min(32,e+((a.C[c]&n1)>>10!=1&&(a.C[c]&n1)>>10!=2?-1:(a.C[c]&o1)>>12)));b.B[0][j]=f;b.B[1][j]=g;i=h&&(a.C[c]&512)!=0?64:a.F[c];b.F[j]=i;b.C[j]=a.C[c];b.D[j]=b.I?a.D[c]:0;if(k!=-1){b.C[j]&=-126977;b.C[j]|=k<<12;}++b.p;b.R=0;return j;};o_.dj=function dj(a,b,c,d,e,f,g){return o_.cj(a,b,c,d,e,f==null?a.B[0][c]:f[a.B[0][c]],f==null?a.B[1][c]:f[a.B[1][c]],g);};o_.ej=function ej(a,b){var c,d;b.t=null;b.r=null;b.I=a.I;b.o=0;for(c=0;c<a.o;c++)o_.bj(a,b,c,0,0);b.p=0;for(d=0;d<a.p;d++)o_.cj(a,b,d,0,0,a.B[0][d],a.B[1][d],false);a.pb(b);};o_.fj=function fj(a,b){b.I=a.I;b.J=a.J;b.Q=a.Q;b.G=a.G;b.N=a.N;b.R=a.R&24;};o_.gj=function gj(a,b){var c,d,e,f;for(c=0;c<a.p;c++){for(e=0;e<2;e++){if(a.B[e][c]==b){a.F[c]=128;d=0;for(f=0;f<a.p;f++){if(f==c)continue;(a.B[0][f]===a.B[1-e][c]||a.B[1][f]===a.B[1-e][c])&&++d;}if(d==0){o_.Nk(a,a.u[a.B[1-e][c]]);a.A[a.B[1-e][c]]=-1;}}}}o_.Nk(a,a.u[b]);a.A[b]=-1;a.t!=null&&(a.t[b]=null);a.r!=null&&(a.r[b]=null);o_.aj(a);a.R=0;};o_.hj=function hj(a,b,c){var d,e;d=o_.nj(a,b,c);if(d!=-1){(a.s[d]&512)!=0?o_.mj(a):o_.gj(a,d);a.R=0;return true;}e=o_.oj(a,b,c);if(e!=-1){(a.s[a.B[0][e]]&a.s[a.B[1][e]]&512)!=0?o_.mj(a):o_.kj(a,e);a.R=0;return true;}return false;};o_.ij=function ij(a,b){var c,d,e,f;if(b.length==0)return null;for(d=b,e=0,f=d.length;e<f;++e){c=d[e];a.A[c]=-1;}return o_.lj(a);};o_.jj=function jj(a,b){a.F[b]=128;o_.aj(a);a.R=0;};o_.kj=function kj(a,b){var c,d,e;for(d=0;d<2;d++){c=0;for(e=0;e<a.p;e++){if(e==b)continue;(a.B[0][e]===a.B[d][b]||a.B[1][e]===a.B[d][b])&&++c;}if(c==0){o_.Nk(a,a.u[a.B[d][b]]);a.A[a.B[d][b]]=-1;}}a.F[b]=128;o_.aj(a);a.R=0;};o_.lj=function lj(a){var b,c,d;d=false;for(b=0;b<a.o;b++){if(a.A[b]==-1){d=true;o_.Nk(a,a.u[b]);}}for(c=0;c<a.p;c++){if(a.F[c]==128){d=true;}else if(a.A[a.B[0][c]]==-1||a.A[a.B[1][c]]==-1){a.F[c]=128;d=true;}}if(d){a.R=0;return o_.aj(a);}return null;};o_.mj=function mj(a){var b,c;c=false;for(b=0;b<a.o;b++){if((a.s[b]&512)!=0){a.A[b]=-1;c=true;}}return c&&o_.lj(a)!=null;};o_.nj=function nj(a,b,c){var d,e,f,g,h,i,j,k;g=-1;e=o_.Kj(a,a.o,a.p,o_.Ki);h=p1;i=e*e/12;for(d=0;d<a.o;d++){j=a.H[d].a;k=a.H[d].b;f=(b-j)*(b-j)+(c-k)*(c-k);if(f<i&&f<h){h=f;g=d;}}return g;};o_.oj=function oj(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;m=-1;o=o_.Kj(a,a.o,a.p,o_.Ki);n=p1;for(d=0;d<a.p;d++){p=a.H[a.B[0][d]].a;r=a.H[a.B[0][d]].b;q=a.H[a.B[1][d]].a;s=a.H[a.B[1][d]].b;k=q-p;l=s-r;e=$wnd.Math.sqrt(k*k+l*l);f=(p+q)/2;g=(r+s)/2;k=b-f;l=c-g;if($wnd.Math.sqrt(k*k+l*l)>e/2)continue;if(q==p)j=$wnd.Math.abs(p-b);else {h=(s-r)/(p-q);i=-h*p-r;j=$wnd.Math.abs((h*b+c+i)/$wnd.Math.sqrt(h*h+1));}if(j<o&&j<n){n=j;m=d;}}return m;};o_.pj=function pj(a,b){return ((a.s[b]&l1)>>>28)-1;};o_.qj=function qj(a,b){return (a.s[b]&98304)>>15;};o_.rj=function rj(a,b){return a.q[b];};o_.sj=function sj(a,b){return a.s[b]&448;};o_.tj=function tj(a,b){return a.r==null?null:a.r[b]==null?null:i_.FR(a.r[b]);};o_.uj=function uj(a,b){return a.r==null?null:a.r[b];};o_.vj=function vj(a,b){return (a.s[b]&Y0)>>19!=1&&(a.s[b]&Y0)>>19!=2?-1:(a.s[b]&m1)>>21;};o_.wj=function wj(a,b){return (a.s[b]&Y0)>>19;};o_.xj=function xj(a,b){return o_.Gi[a.A[b]];};o_.yj=function yj(a,b){return a.t==null?null:a.t[b];};o_.zj=function zj(a,b){var c,d,e;if(a.t==null||a.t[b]==null)return (a.w[b]&1)!=0?'':o_.Gi[a.A[b]];e='';for(d=0;d<a.t[b].length;d++){d>0&&(e=(n_.M$(e),e+(n_.M$(','),',')));c=a.t[b][d];e=i_.ER(e,o_.Gi[c]);}return e;};o_.Aj=function Aj(a,b){return $wnd.Math.abs(a.u[b]);};o_.Bj=function Bj(a,b){return a.v[b];};o_.Cj=function Cj(a,b){return a.s[b]&3;};o_.Dj=function Dj(a,b){return a.w[b];};o_.Ej=function Ej(a,b){return a.s[b]&48;};o_.Fj=function Fj(a,b){return a.H[b].a;};o_.Gj=function Gj(a,b){return a.H[b].b;};o_.Hj=function Hj(a,b){return a.H[b].c;};o_.Ij=function Ij(a,b){return a.A[b];};o_.Jj=function Jj(a){return o_.Kj(a,a.o,a.p,o_.Ki);};o_.Kj=function Kj(a,b,c,d){return o_.Lj(a,b,c,d,a.H);};o_.Lj=function Lj(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o;l=false;m=0;for(j=0;j<c;j++)a.F[j]!=32&&(a.D[j]&X0)==0&&++m;if(m==0){for(k=0;k<c;k++)(a.D[k]&X0)==0&&++m;l=true;}if(m==0){if(b<2)return d;o=p1;for(f=1;f<b;f++){for(g=0;g<f;g++){n=o_.Rg(e[f],e[g]);n>0&&n<o&&(o=n);}}return o!=p1?0.6*o:d;}h=0;for(i=0;i<c;i++){(l||a.F[i]!=32)&&(a.D[i]&X0)==0&&(h+=o_.Rg(e[a.B[1][i]],e[a.B[0][i]]));}return h/m;};o_.Mj=function Mj(a,b,c){return o_.Wl(a.H[b].a,a.H[b].b,a.H[c].a,a.H[c].b);};o_.Nj=function Nj(a,b,c){return a.B[b][c];};o_.Oj=function Oj(a,b){return ((a.D[b]&K0)>>7)+((a.D[b]&30720)>>11);};o_.Pj=function Pj(a,b){return (a.D[b]&K0)>>7;};o_.Qj=function Qj(a,b){return (a.C[b]&48)>>4;};o_.Rj=function Rj(a,b){return (a.C[b]&n1)>>10!=1&&(a.C[b]&n1)>>10!=2?-1:(a.C[b]&o1)>>12;};o_.Sj=function Sj(a,b){return (a.C[b]&n1)>>10;};o_.Tj=function Tj(a,b){var c,d,e,f;c=a.B[0][b];d=a.B[1][b];e=a.H[d].a-a.H[c].a;f=a.H[d].b-a.H[c].b;return $wnd.Math.sqrt(e*e+f*f);};o_.Uj=function Uj(a,b,c){var d;for(d=0;d<a.p;d++)if(a.B[0][d]==b&&a.B[1][d]==c||a.B[0][d]==c&&a.B[1][d]==b)if(a.F[d]!=128)return d;return -1;};o_.Vj=function Vj(a,b){switch(a.F[b]&103){case 1:case 64:return 1;case 2:return 2;case 4:return 3;default:return 0;}};o_.Wj=function Wj(a,b){return a.C[b]&3;};o_.Xj=function Xj(a,b){return a.D[b];};o_.Yj=function Yj(a,b){return a.F[b];};o_.Zj=function Zj(a,b){return a.F[b]&103;};o_.$j=function $j(a,b){var c,d,e,f,g;if(a.o==0)return null;d=a.H[0].a;f=a.H[0].b;e=a.H[0].a;g=a.H[0].b;for(c=1;c<a.o;c++){d>a.H[c].a?d=a.H[c].a:e<a.H[c].a&&(e=a.H[c].a);f>a.H[c].b?f=a.H[c].b:g<a.H[c].b&&(g=a.H[c].b);}if(!b){b=new B_.mP(d,f,e-d,g-f);}else {b.c=d;b.d=f;b.b=e-d;b.a=g-f;}return b;};o_._j=function _j(a,b){var c;c=a.A[b]<o_.Hi.length?o_.Hi[a.A[b]]:null;return c==null?6:c[c.length-1];};o_.ak=function ak(a,b,c){var d,e;if(a.A[b]>=171&&a.A[b]<=190)return 0;e=0;(a.s[b]&48)==32&&(e-=1);((a.s[b]&48)==16||(a.s[b]&48)==48)&&(e-=2);d=a.q[b];if(d==0&&a.I){(a.w[b]&M0)==O0&&(d=-1);(a.w[b]&M0)==N0&&(d=1);}a.A[b]==7||a.A[b]==8||a.A[b]==9?e+=d:a.A[b]==6||a.A[b]==14||a.A[b]==32?e-=$wnd.Math.abs(d):a.A[b]==15||a.A[b]==33?c-e-d<=3?e+=d:e-=d:a.A[b]==16||a.A[b]==34||a.A[b]==52?c-e-d<=4?e+=d:e-=$wnd.Math.abs(d):a.A[b]==17||a.A[b]==35||a.A[b]==53?c-e-d<=5?e+=d:e-=$wnd.Math.abs(d):e-=d;return e;};o_.bk=function bk(a,b){var c;c=o_.ck(a,b);return c+o_.ak(a,b,c);};o_.ck=function ck(a,b){var c,d;c=((a.s[b]&l1)>>>28)-1;c==-1&&(c=(d=a.A[b]<o_.Hi.length?o_.Hi[a.A[b]]:null,d==null?6:d[d.length-1]));return c;};o_.dk=function dk(a,b){var c,d,e,f,g;f=3;for(d=0;d<2;d++){c=a.B[d][b];e=o_.Vj(a,b)+(g=o_.ck(a,c),g+o_.ak(a,c,g))-o_.Sm(a,c);f>e&&(f=e);}return f;};o_.ek=function ek(a,b){return (a.s[b]&h1)!=0;};o_.fk=function fk(a,b){var c,d,e;d=o_.dk(a,b);c=o_.xk(a,a.B[0][b])||o_.xk(a,a.B[1][b]);e=c?32:1;if(a.F[b]==4){a.F[b]=e;a.R=0;return true;}if(a.F[b]==2){a.F[b]=26;a.R&=7;if((a.C[b]&128)==0)return true;}if(a.F[b]==26){d==3?a.F[b]=4:a.F[b]=e;a.R=0;return true;}if((24&a.F[b])!=0){a.F[b]=1;a.R&=7;return true;}if(!c&&d<2)return false;if(a.F[b]==1){a.F[b]=2;a.R=0;return true;}if(d<1)return false;if(a.F[b]==32){a.F[b]=1;a.R=0;return true;}return false;};o_.gk=function gk(a){var b;a.R=0;a.A=OI(h_.hK,k0,5,a.K,15,1);a.q=OI(h_.hK,k0,5,a.K,15,1);a.u=OI(h_.hK,k0,5,a.K,15,1);a.H=OI(h_.yK,V_,34,a.K,0,1);for(b=0;b<a.K;b++)a.H[b]=new o_.Ug();a.v=OI(h_.hK,k0,5,a.K,15,1);a.s=OI(h_.hK,k0,5,a.K,15,1);a.w=OI(h_.hK,k0,5,a.K,15,1);a.t=null;a.r=null;a.B=MI(h_.hK,[d1,k0],[6,5],15,[2,a.L],2);a.F=OI(h_.hK,k0,5,a.L,15,1);a.C=OI(h_.hK,k0,5,a.L,15,1);a.D=OI(h_.hK,k0,5,a.L,15,1);};o_.hk=function hk(a,b){a.R&=~b;};o_.ik=function ik(a){var b;for(b=0;b<a.o;b++)if(a.H[b].c!=0)return true;return false;};o_.jk=function jk(a,b){return (a.s[b]&q1)!=0;};o_.kk=function kk(a,b){return a.A[b]==-1;};o_.lk=function lk(a,b){return (a.s[b]&4)!=0;};o_.mk=function mk(a,b){return (a.s[b]&r1)!=0;};o_.nk=function nk(a,b){return a.u[b]<0;};o_.ok=function ok(a,b){return (a.C[b]&h1)!=0;};o_.pk=function pk(a,b){return (a.D[b]&X0)!=0;};o_.qk=function qk(a,b){return (a.C[b]&b1)!=0;};o_.rk=function rk(a,b){return a.F[b]==128;};o_.sk=function sk(a,b){return (a.C[b]&4)!=0;};o_.tk=function tk(a,b){return (a.C[b]&s1)!=0;};o_.uk=function uk(a,b){return o_.Zl(a.A[b]);};o_.vk=function vk(a,b){return o_.$l(a.A[b]);};o_.wk=function wk(a,b){return (a.s[b]&b1)!=0;};o_.xk=function xk(a,b){var c;c=a.A[b];return c>=3&&c<=4||c>=11&&c<=13||c>=19&&c<=31||c>=37&&c<=51||c>=55&&c<=84||c>=87&&c<=103;};o_.yk=function yk(a,b){return a.v[b]==0;};o_.zk=function zk(a,b){var c;c=a.A[b];return c==1||c>=5&&c<=9||c>=14&&c<=17||c>=32&&c<=35||c>=52&&c<=53;};o_.Ak=function Ak(a){var b;for(b=0;b<a.o;b++){switch(a.A[b]){case 1:case 5:case 6:case 7:case 8:case 9:case 14:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:continue;default:return false;}}return true;};o_.Bk=function Bk(a,b){return (a.s[b]&512)!=0;};o_.Ck=function Ck(a,b){return (a.s[a.B[0][b]]&a.s[a.B[1][b]]&512)!=0;};o_.Dk=function Dk(a,b){return a.F[b]==17||a.F[b]==9;};o_.Ek=function Ek(a,b,c){return (a.F[b]==17||a.F[b]==9)&&a.B[0][b]==c;};o_.Fk=function Fk(a,b){a.A[b]=-1;};o_.Gk=function Gk(a,b){a.F[b]=128;};o_.Hk=function Hk(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;if(b==d){n=o_.Kj(a,a.o,a.p,o_.Ki);}else {u=a.H[b].a-a.H[d].a;v=a.H[b].b-a.H[d].b;n=$wnd.Math.sqrt(u*u+v*v);}h=b;o=o_.Gl(a,b)!=3;for(t=1;t<c;t++){q=a.H[h].a+n*$wnd.Math.sin(f);r=a.H[h].b+n*$wnd.Math.cos(f);s=-1;for(p=0;p<a.o;p++){if($wnd.Math.abs(q-a.H[p].a)<4&&$wnd.Math.abs(r-a.H[p].b)<4){s=p;break;}}if(s==-1){s=o_.Mi(a,q,r,0);a.H[s].a=q;a.H[s].b=r;a.H[s].c=0;}m=o_.Uj(a,h,s);if(m==-1){m=o_.Pi(a,h,s,(j=a.A[h],j>=3&&j<=4||j>=11&&j<=13||j>=19&&j<=31||j>=37&&j<=51||j>=55&&j<=84||j>=87&&j<=103||(k=a.A[s],k>=3&&k<=4||k>=11&&k<=13||k>=19&&k<=31||k>=37&&k<=51||k>=55&&k<=84||k>=87&&k<=103)?32:1));if(e){o&&o_.Gl(a,a.B[0][m])<4&&o_.Gl(a,a.B[1][m])<3&&(a.F[m]=2);o=!o;}}h=s;f+=g;}m=o_.Uj(a,h,d);m==-1&&(m=o_.Pi(a,h,d,(l=a.A[h],l>=3&&l<=4||l>=11&&l<=13||l>=19&&l<=31||l>=37&&l<=51||l>=55&&l<=84||l>=87&&l<=103||(i=a.A[d],i>=3&&i<=4||i>=11&&i<=13||i>=19&&i<=31||i>=37&&i<=51||i>=55&&i<=84||i>=87&&i<=103)?32:1)));e&&o&&o_.Gl(a,a.B[0][m])<4&&o_.Gl(a,a.B[1][m])<4&&(a.F[m]=2);};o_.Ik=function Ik(a,b,c){var d,e;if(o_.Vj(a,b)!=1)return false;if((a.s[c]&3)!=0)return true;for(e=0;e<a.p;e++)if(e!=b&&a.F[e]==2&&(a.B[0][e]==c&&(a.s[a.B[1][e]]&3)!=0||a.B[1][e]==c&&(a.s[a.B[0][e]]&3)!=0))return true;for(d=0;d<a.p;d++)if(d!=b&&a.F[d]==1&&(a.B[0][d]==c||a.B[1][d]==c)&&(a.C[d]&3)!=0)return true;return false;};o_.Jk=function Jk(a){var b;for(b=0;b<a.o;b++)a.s[b]&=-449;};o_.Kk=function Kk(a){var b;for(b=0;b<a.o;b++)a.s[b]&=-262145;};o_.Lk=function Lk(a){var b;for(b=0;b<a.o;b++)a.s[b]&=-513;};o_.Mk=function Mk(a){var b;for(b=0;b<a.p;b++)a.C[b]&=-393217;};o_.Nk=function Nk(a,b){var c;for(c=0;c<a.o;c++)$wnd.Math.abs(a.u[c])==$wnd.Math.abs(b)&&(a.u[c]=0);};o_.Ok=function Ok(a){var b,c,d,e;e=false;for(c=0;c<a.o;c++){if((a.w[c]&D0)!=0){a.A[c]=-1;e=true;}}e&&o_.lj(a);if(a.t!=null){a.t=null;e=true;}for(b=0;b<a.o;b++){if(a.w[b]!=0){a.w[b]=0;e=true;}}for(d=0;d<a.p;d++){if(a.D[d]!=0){a.D[d]=0;e=true;}if(a.F[d]==64){a.F[d]=1;e=true;}}e&&(a.R=0);return e;};o_.Pk=function Pk(a,b){var c,d,e,f,g,h,i,j,k;if(b==0)return 0;h=null;for(d=0;d<a.o;d++){if((a.s[d]&Y0)>>19==b){h==null&&(h=OI(h_.DN,C0,5,32,16,1));h[(a.s[d]&Y0)>>19!=1&&(a.s[d]&Y0)>>19!=2?-1:(a.s[d]&m1)>>21]=true;}}for(f=0;f<a.p;f++){if((a.C[f]&n1)>>10==b){h==null&&(h=OI(h_.DN,C0,5,32,16,1));h[(a.C[f]&n1)>>10!=1&&(a.C[f]&n1)>>10!=2?-1:(a.C[f]&o1)>>12]=true;}}k=0;if(h!=null){j=OI(h_.hK,k0,5,32,15,1);for(i=0;i<32;i++)h[i]&&(j[i]=k++);for(c=0;c<a.o;c++){if((a.s[c]&Y0)>>19==b){g=j[(a.s[c]&Y0)>>19!=1&&(a.s[c]&Y0)>>19!=2?-1:(a.s[c]&m1)>>21];a.s[c]&=-65011713;a.s[c]|=g<<21;}}for(e=0;e<a.p;e++){if((a.C[e]&n1)>>10==b){g=j[(a.C[e]&n1)>>10!=1&&(a.C[e]&n1)>>10!=2?-1:(a.C[e]&o1)>>12];a.C[e]&=-126977;a.C[e]|=g<<12;}}}return k;};o_.Qk=function Qk(a,b){var c;for(c=0;c<a.o;c++){a.H[c].a*=b;a.H[c].b*=b;}};o_.Rk=function Rk(a,b){a.o=b;a.R=0;};o_.Sk=function Sk(a,b){a.p=b;a.R=0;};o_.Tk=function Tk(a,b,c){if(c>=-1&&c<=14){a.s[b]&=268435455;a.s[b]|=1+c<<28;if(a.A[b]==6){if(c==-1||c==0||c==2||c==4){a.s[b]&=-49;c==2&&(a.s[b]|=16);}}}};o_.Uk=function Uk(a,b,c){a.s[b]&=-98305;a.s[b]|=c<<15;};o_.Vk=function Vk(a,b,c){a.q[b]=c;a.R=0;};o_.Wk=function Wk(a,b,c){a.s[b]&=-449;a.s[b]|=c;};o_.Xk=function Xk(a,b,c){c?a.s[b]|=q1:a.s[b]&=-67108865;a.R&=7;};o_.Yk=function Yk(a,b,c){var d,e;if(c!=null){if(n_.V$(c).length==0)c=null;else {d=o_.Yl(c);if(d!=0&&i_.GR(c,o_.Gi[d])||i_.GR(c,'?')){o_.ml(a,b,d);c=null;}}}if(c==null){a.r!=null&&(a.r[b]=null);}else {a.r==null&&(a.r=OI(h_.dK,K_,8,a.K,0,2));a.r[b]=n_.F$((e=c,n_.A$(),e));}};o_.Zk=function Zk(a,b,c){c!=null&&c.length==0&&(c=null);if(c==null){a.r!=null&&(a.r[b]=null);}else {a.r==null&&(a.r=OI(h_.dK,K_,8,a.K,0,2));a.r[b]=c;}};o_.$k=function $k(a,b,c,d){var e,f,g;if(c==0){a.s[b]&=t1;a.s[b]|=c<<19;}else {if(d>=32)return;if(d==-1){g=-1;for(f=0;f<a.o;f++)f!=b&&c==(a.s[f]&Y0)>>19&&g<((a.s[f]&Y0)>>19!=1&&(a.s[f]&Y0)>>19!=2?-1:(a.s[f]&m1)>>21)&&(g=(a.s[f]&Y0)>>19!=1&&(a.s[f]&Y0)>>19!=2?-1:(a.s[f]&m1)>>21);for(e=0;e<a.p;e++)c==(a.C[e]&n1)>>10&&g<((a.C[e]&n1)>>10!=1&&(a.C[e]&n1)>>10!=2?-1:(a.C[e]&o1)>>12)&&(g=(a.C[e]&n1)>>10!=1&&(a.C[e]&n1)>>10!=2?-1:(a.C[e]&o1)>>12);d=g+1;if(d>=32)return;}a.s[b]&=t1;a.s[b]|=c<<19|d<<21;}a.R&=7;};o_._k=function _k(a,b,c){a.t==null&&(a.t=OI(h_.hK,d1,6,a.K,0,2));n_.V$(c).sort(n_.V$(AO(l_.pX.prototype.Ub,l_.pX,[])));a.t[b]=c;a.R=0;a.I=true;};o_.al=function al(a,b,c,d){var e;if(c==null){a.t!=null&&(a.t[b]=null);return;}if(c.length==1&&!d){e=c[0];a.A[b]!=e&&o_.Yi(a,b,e,0,-1,0);a.t!=null&&(a.t[b]=null);return;}a.t==null&&(a.t=OI(h_.hK,d1,6,a.K,0,2));a.t[b]=c;d&&(a.w[b]|=1);a.R=0;a.I=true;};o_.bl=function bl(a,b,c,d){a.u[b]=d?-c:c;};o_.cl=function cl(a,b,c){c?a.s[b]|=b1:a.s[b]&=-262145;};o_.dl=function dl(a,b,c){a.v[b]=c;a.R&=7;};o_.el=function el(a,b,c,d){a.s[b]&=-8;a.s[b]|=c;d&&(a.s[b]|=4);};o_.fl=function fl(a,b,c,d){d?a.w[b]|=c:a.w[b]&=~c;a.R=0;a.I=true;};o_.gl=function gl(a,b,c){a.s[b]&=-49;a.s[b]|=c;a.R&=7;};o_.hl=function hl(a,b,c){c?a.s[b]|=512:a.s[b]&=-513;};o_.il=function il(a,b,c){a.s[b]&=-134217729;c&&(a.s[b]|=r1);};o_.jl=function jl(a,b,c){a.H[b].a=c;a.R&=7;};o_.kl=function kl(a,b,c){a.H[b].b=c;a.R&=7;};o_.ll=function ll(a,b,c){a.H[b].c=c;a.R&=7;};o_.ml=function ml(a,b,c){if(c>=0&&c<=190){if(c==151||c==152){a.A[b]=1;a.v[b]=c-149;}else {a.A[b]=c;a.v[b]=0;}a.s[b]&=268435455;a.R=0;}};o_.nl=function nl(a,b,c,d){a.B[b][c]=d;a.R=0;};o_.ol=function ol(a,b,c){c?a.C[b]|=h1:a.C[b]&=-131073;};o_.pl=function pl(a,b,c){a.C[b]&=-49;a.C[b]|=c<<4;};o_.ql=function ql(a,b,c,d){var e,f,g;if(c==0){a.C[b]&=-130049;a.C[b]|=c<<10;}else {if(d>=32)return;if(d==-1){g=-1;for(f=0;f<a.o;f++)c==(a.s[f]&Y0)>>19&&g<((a.s[f]&Y0)>>19!=1&&(a.s[f]&Y0)>>19!=2?-1:(a.s[f]&m1)>>21)&&(g=(a.s[f]&Y0)>>19!=1&&(a.s[f]&Y0)>>19!=2?-1:(a.s[f]&m1)>>21);for(e=0;e<a.p;e++)e!=b&&c==(a.C[e]&n1)>>10&&g<((a.C[e]&n1)>>10!=1&&(a.C[e]&n1)>>10!=2?-1:(a.C[e]&o1)>>12)&&(g=(a.C[e]&n1)>>10!=1&&(a.C[e]&n1)>>10!=2?-1:(a.C[e]&o1)>>12);d=g+1;if(d>=32)return;}a.C[b]&=-130049;a.C[b]|=c<<10|d<<12;}a.R&=7;};o_.rl=function rl(a,b,c){c?a.C[b]|=b1:a.C[b]&=-262145;};o_.sl=function sl(a,b,c){a.F[b]=c==1?1:c==2?2:c==3?4:32;a.R=0;};o_.tl=function tl(a,b,c,d){a.C[b]&=-16777224;a.C[b]|=c;d&&(a.C[b]|=4);};o_.ul=function ul(a,b){a.C[b]|=s1;};o_.vl=function vl(a,b,c,d){d?a.D[b]|=c:a.D[b]&=~c;a.R=0;a.I=true;};o_.wl=function wl(a,b,c){a.F[b]=c;a.R=0;};o_.xl=function xl(a,b){a.G=b;};o_.yl=function yl(a,b){if(a.I!=b){a.I=b;b||o_.Ok(a);a.R=0;}};o_.zl=function zl(a,b){a.R=b;};o_.Al=function Al(a,b){a.Q=b;};o_.Bl=function Bl(a,b){var c,d;a.A=o_.Sl(a.A,b);a.q=o_.Sl(a.q,b);a.u=o_.Sl(a.u,b);d=a.H.length;a.H=o_.Tl(a.H,b);for(c=d;c<b;c++)a.H[c]=new o_.Ug();a.v=o_.Sl(a.v,b);a.s=o_.Sl(a.s,b);a.w=o_.Sl(a.w,b);a.t!=null&&(a.t=o_.Vl(a.t,b));a.r!=null&&(a.r=o_.Ul(a.r,b));a.K=b;};o_.Cl=function Cl(a,b){a.B[0]=o_.Sl(a.B[0],b);a.B[1]=o_.Sl(a.B[1],b);a.F=o_.Sl(a.F,b);a.C=o_.Sl(a.C,b);a.D=o_.Sl(a.D,b);a.L=b;};o_.Dl=function Dl(a,b){a.M=b;};o_.El=function El(a,b){a.N=b;};o_.Fl=function Fl(a,b){a.s[b]|=h1;};o_.Gl=function Gl(a,b){var c,d;d=0;for(c=0;c<a.p;c++)(a.B[0][c]==b||a.B[1][c]==b)&&(d+=o_.Vj(a,c));return d;};o_.Hl=function Hl(a){var b,c,d;c=false;d=false;for(b=0;b<a.o;b++){if(a.v[b]!=0){a.v[b]=0;c=true;a.A[b]==1&&(d=true);}}d&&(a.R=0);return c;};o_.Il=function Il(a,b,c){var d,e;return e=a.A[b],e>=3&&e<=4||e>=11&&e<=13||e>=19&&e<=31||e>=37&&e<=51||e>=55&&e<=84||e>=87&&e<=103||(d=a.A[c],d>=3&&d<=4||d>=11&&d<=13||d>=19&&d<=31||d>=37&&d<=51||d>=55&&d<=84||d>=87&&d<=103)?32:1;};o_.Jl=function Jl(a,b,c){var d,e,f,g,h;g=a.A[b];a.A[b]=a.A[c];a.A[c]=g;g=a.q[b];a.q[b]=a.q[c];a.q[c]=g;g=a.v[b];a.v[b]=a.v[c];a.v[c]=g;g=a.s[b];a.s[b]=a.s[c];a.s[c]=g;g=a.w[b];a.w[b]=a.w[c];a.w[c]=g;g=a.u[b];a.u[b]=a.u[c];a.u[c]=g;f=a.H[b];a.H[b]=a.H[c];a.H[c]=f;if(a.t!=null){h=a.t[b];a.t[b]=a.t[c];a.t[c]=h;}if(a.r!=null){h=a.r[b];a.r[b]=a.r[c];a.r[c]=h;}for(d=0;d<a.p;d++){for(e=0;e<2;e++){a.B[e][d]==b?a.B[e][d]=c:a.B[e][d]==c&&(a.B[e][d]=b);}}a.R=0;};o_.Kl=function Kl(a,b,c){var d;d=a.B[0][b];a.B[0][b]=a.B[0][c];a.B[0][c]=d;d=a.B[1][b];a.B[1][b]=a.B[1][c];a.B[1][c]=d;d=a.F[b];a.F[b]=a.F[c];a.F[c]=d;d=a.C[b];a.C[b]=a.C[c];a.C[c]=d;d=a.D[b];a.D[b]=a.D[c];a.D[c]=d;a.R=0;};o_.Ll=function Ll(a,b,c){var d;for(d=0;d<a.o;d++){a.H[d].a+=b;a.H[d].b+=c;}a.S+=b;a.T+=c;};o_.Ml=function Ml(a,b,c){var d,e;e=c&103;d=o_.dk(a,b);switch(e){case 1:case 64:return d>=1;case 2:return d>=2;case 4:return d>=3;case 32:return true;default:return false;}};o_.Nl=function Nl(a,b,c,d){var e,f,g;for(e=0;e<a.o;e++){if(!d||(a.s[e]&512)!=0){g=a.P[e]*b;f=a.O[e]-c;a.H[e].a=a.S+g*$wnd.Math.sin(f);a.H[e].b=a.T+g*$wnd.Math.cos(f);}}d&&(a.R&=7);};o_.Ol=function Ol(a,b,c){var d,e,f;a.S=b;a.T=c;a.O=OI(h_.fK,B0,5,a.o,15,1);a.P=OI(h_.fK,B0,5,a.o,15,1);for(d=0;d<a.o;d++){e=b-a.H[d].a;f=c-a.H[d].b;a.P[d]=$wnd.Math.sqrt(e*e+f*f);a.O[d]=o_.Wl(b,c,a.H[d].a,a.H[d].b);}};o_.Pl=function Pl(){this.K=this.L=256;o_.gk(this);};o_.Ql=function Ql(a,b){this.K=$wnd.Math.max(1,a);this.L=$wnd.Math.max(1,b);o_.gk(this);};o_.Sl=function Sl(a,b){var c;c=OI(h_.hK,k0,5,b,15,1);i_.pS(a,0,c,0,$wnd.Math.min(a.length,b));return c;};o_.Tl=function Tl(a,b){var c,d;c=OI(h_.yK,V_,34,b,0,1);for(d=0;d<a.length;d++)!!a[d]&&(c[d]=new o_.Wg(a[d]));return c;};o_.Ul=function Ul(a,b){var c,d;c=OI(h_.dK,K_,8,b,0,2);for(d=0;d<a.length;d++){if(a[d]!=null){c[d]=OI(h_.dK,j0,5,a[d].length,15,1);i_.pS(a[d],0,c[d],0,a[d].length);}}return c;};o_.Vl=function Vl(a,b){var c,d;c=OI(h_.hK,d1,6,b,0,2);for(d=0;d<a.length;d++){if(a[d]!=null){c[d]=OI(h_.hK,k0,5,a[d].length,15,1);i_.pS(a[d],0,c[d],0,a[d].length);}}return c;};o_.Wl=function Wl(a,b,c,d){o_.Li();var e,f,g;f=c-a;g=d-b;if(g!=0){e=$wnd.Math.atan(f/g);g<0&&(f<0?e-=H0:e+=H0);}else e=f>0?I0:W0;return e;};o_.Xl=function Xl(a,b){o_.Li();var c;c=a-b;while(c<u1)c+=G0;while(c>H0)c-=G0;return c;};o_.Yl=function Yl(a){o_.Li();var b;for(b=1;b<o_.Gi.length;b++)if(i_.HR(a,o_.Gi[b]))return b;return 0;};o_.Zl=function Zl(a){o_.Li();switch(a){case 7:case 8:case 9:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:return true;}return false;};o_.$l=function $l(a){o_.Li();if(a==1||a==6)return false;if(o_.Zl(a))return false;if(a==2||a==10||a==18||a==36||a==54)return false;if(a>103)return false;return true;};xO(62,1,{62:1,4:1});_.pb=function Rl(a){o_.fj(this,a);};_.o=0;_.p=0;_.G=0;_.I=false;_.J=false;_.K=0;_.L=0;_.M=0;_.Q=false;_.R=0;_.S=0;_.T=0;o_.Ki=24;h_.JK=jQ(62);o_._l=function _l(a,b,c,d){var e,f,g,h,i,j,k,l,m;o_.Jr(b,1);d==null&&(d=OI(h_.hK,k0,5,b.o,15,1));h=o_.Pk(a,1);i=o_.Pk(a,2);m=OI(h_.DN,C0,5,b.o,16,1);j=OI(h_.hK,k0,5,b.o,15,1);j[0]=c;m[c]=true;d[c]=o_.bj(b,a,c,h,i);g=0;k=0;while(g<=k){for(l=0;l<o_.mm(b,j[g]);l++){f=b.f[j[g]][l];if(!m[f]){j[++k]=f;m[f]=true;d[f]=o_.bj(b,a,f,h,i);}}++g;}for(e=0;e<b.p;e++)m[b.B[0][e]]&&o_.cj(b,a,e,h,i,d==null?b.B[0][e]:d[b.B[0][e]],d==null?b.B[1][e]:d[b.B[1][e]],false);o_.Pk(a,1);o_.Pk(a,2);a.R=0;};o_.am=function am(a){var b,c,d,e,f,g,h,i,j,k,l,m;a.g=OI(h_.hK,k0,5,a.o,15,1);a.c=OI(h_.hK,k0,5,a.o,15,1);a.f=OI(h_.hK,d1,6,a.o,0,2);a.i=OI(h_.hK,d1,6,a.o,0,2);a.j=OI(h_.hK,d1,6,a.o,0,2);a.k=OI(h_.hK,k0,5,a.d,15,1);j=OI(h_.hK,k0,5,a.o,15,1);for(g=0;g<a.p;g++){++j[a.B[0][g]];++j[a.B[1][g]];}for(d=0;d<a.o;d++){a.f[d]=OI(h_.hK,k0,5,j[d],15,1);a.i[d]=OI(h_.hK,k0,5,j[d],15,1);a.j[d]=OI(h_.hK,k0,5,j[d],15,1);}l=false;for(h=0;h<a.e;h++){m=o_.Vj(a,h);if(m==0){l=true;continue;}for(k=0;k<2;k++){c=a.B[k][h];b=a.c[c];a.j[c][b]=m;a.f[c][b]=a.B[1-k][h];a.i[c][b]=h;++a.c[c];++a.g[c];c<a.d&&(m>1?a.k[c]+=m-1:a.F[h]==64&&(a.k[c]=1));}}for(i=a.e;i<a.p;i++){m=o_.Vj(a,i);if(m==0){l=true;continue;}for(k=0;k<2;k++){c=a.B[k][i];b=a.c[c];a.j[c][b]=m;a.f[c][b]=a.B[1-k][i];a.i[c][b]=i;++a.c[c];a.B[1-k][i]<a.d&&++a.g[c];}}if(l){b=OI(h_.hK,k0,5,a.o,15,1);for(e=0;e<a.o;e++)b[e]=a.c[e];for(f=0;f<a.p;f++){m=o_.Vj(a,f);if(m==0){for(k=0;k<2;k++){c=a.B[k][f];a.j[c][b[c]]=m;a.f[c][b[c]]=a.B[1-k][f];a.i[c][b[c]]=f;++b[c];}}}}};o_.bm=function bm(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;o_.Jr(a,1);c&&(b=true);for(k=0;k<a.p;k++){l=o_.Vj(a,k);if(l==1||l==2){if(a.q[a.B[0][k]]>0&&a.q[a.B[1][k]]<0){f=a.B[0][k];g=a.B[1][k];}else if(a.q[a.B[0][k]]<0&&a.q[a.B[1][k]]>0){f=a.B[1][k];g=a.B[0][k];}else continue;j=a.A[f];if(j>=3&&j<=4||j>=11&&j<=13||j>=19&&j<=31||j>=37&&j<=51||j>=55&&j<=84||j>=87&&j<=103||(i=a.A[g],i>=3&&i<=4||i>=11&&i<=13||i>=19&&i<=31||i>=37&&i<=51||i>=55&&i<=84||i>=87&&i<=103))continue;if(a.A[f]<9&&o_.Sm(a,f)>3||a.A[g]<9&&o_.Sm(a,g)>3)continue;t=a.F[k];a.q[f]-=1;a.q[g]+=1;l==1?a.F[k]=2:a.F[k]=4;if(t==9||t==17){A=a.B[0][k];s=o_.Gn(a,A);if(a.B[0][s]!=A){a.B[1][s]=a.B[0][s];a.B[1][s]=A;}}a.R=0;}}u=0;q=0;o=0;for(e=0;e<a.o;e++){u+=a.q[e];if(a.q[e]<0&&!o_.gn(a,e)){++q;o_.Zl(a.A[e])&&(o-=a.q[e]);}}if(!b&&u!=0)throw IN(new i_.EG("molecule's overall charges are not balanced"));o_.Jr(a,1);v=0;w=c?u+o:o;for(h=0;h<a.o;h++){if(a.q[h]>0){if(!o_.fn(a,h)&&o_.Zl(a.A[h])){m=$wnd.Math.min(o_.Nm(a,h),a.q[h]);if(m!=0&&w>=m){u-=m;v-=m;w-=m;a.q[h]-=m;a.R&=1;}}}}r=c?u:v;if(r<0){p=OI(h_.hK,k0,5,q,15,1);q=0;for(f=0;f<a.o;f++){a.q[f]<0&&!o_.gn(a,f)&&(p[q++]=(a.A[f]<<22)+f);}n_.V$(p).sort(n_.V$(AO(l_.pX.prototype.Ub,l_.pX,[])));for(n=p.length-1;r<0&&n>=p.length-q;n--){d=p[n]&v1;if(o_.Zl(a.A[d])){m=$wnd.Math.min(-r,-a.q[d]);u+=m;r+=m;a.q[d]+=m;a.R&=1;}}}return u;};o_.cm=function cm(a,b){var c,d,e,f;if(a.k[b]==2&&a.g[b]==2&&a.j[b][0]==2){for(f=0;f<2;f++){c=o_.hm(a,b,a.f[b][f]);c!=-1&&o_.cm(a,c);}return;}for(e=0;e<a.c[b];e++){d=a.i[b][e];(a.F[d]==17||a.F[d]==9)&&a.B[0][d]==b&&(a.F[d]=1);}};o_.dm=function dm(a,b,c,d,e){var f,g,h,i,j;d&&o_.Jr(a,7);b.t=null;a.I&&o_.yl(b,true);i=c.length;e==null&&(e=OI(h_.hK,k0,5,i,15,1));b.o=0;for(f=0;f<i;f++)e[f]=c[f]?o_.bj(a,b,f,0,0):-1;b.p=0;for(j=0;j<a.p;j++){g=a.B[0][j];h=a.B[1][j];if(g<i&&h<i){if(c[g]&&c[h])o_.cj(a,b,j,0,0,e==null?a.B[0][j]:e[a.B[0][j]],e==null?a.B[1][j]:e[a.B[1][j]],d);else if(a.q[g]!=0&&a.q[h]!=0&&a.q[g]<0^a.q[h]<0){c[g]&&(b.q[e[g]]+=a.q[g]<0?1:-1);c[h]&&(b.q[e[h]]+=a.q[h]<0?1:-1);}}}o_.fj(a,b);!!a.b&&(b.R=0);b.R=0;o_.Pk(b,1);o_.Pk(b,2);b.o!=i&&o_.yl(b,true);d&&o_.$d(new o_.ie(b),null,false);};o_.em=function em(a,b,c,d,e){var f,g,h,i,j;d&&o_.Jr(a,7);b.t=null;a.I&&o_.yl(b,true);e==null&&(e=OI(h_.hK,k0,5,a.o,15,1));b.o=0;for(f=0;f<a.o;f++){e[f]=-1;for(j=0;j<a.g[f];j++){if(c[a.i[f][j]]){e[f]=o_.bj(a,b,f,0,0);break;}}}b.p=0;for(i=0;i<a.p;i++)if(c[i]){o_.cj(a,b,i,0,0,e==null?a.B[0][i]:e[a.B[0][i]],e==null?a.B[1][i]:e[a.B[1][i]],d);}else {g=a.B[0][i];h=a.B[1][i];if(e[g]==-1^e[h]==-1){if(a.q[g]!=0&&a.q[h]!=0&&a.q[g]<0^a.q[h]<0){e[g]!=-1&&(b.q[e[g]]+=a.q[g]<0?1:-1);e[h]!=-1&&(b.q[e[h]]+=a.q[h]<0?1:-1);}}}o_.fj(a,b);!!a.b&&(b.R=0);b.R=0;o_.Pk(b,1);o_.Pk(b,2);b.o!=a.o&&o_.yl(b,true);d&&o_.$d(new o_.ie(b),null,false);return e;};o_.fm=function fm(a,b){var c,d,e,f,g,h,i,j,k,l,m;if((b&~a.R)==0)return;if((a.R&1)==0){o_.en(a);o_.am(a);a.R|=1;if(o_.Sn(a)){o_.en(a);o_.am(a);}}if((b&~a.R)==0)return;if((a.R&-7)!=0){for(d=0;d<a.d;d++)a.s[d]&=-31753;for(g=0;g<a.e;g++)a.C[g]&=-961;if((b&4)==0){o_.km(a,1);a.R|=2;return;}o_.km(a,7);for(f=0;f<a.e;f++){if(a.F[f]==64){a.s[a.B[0][f]]|=b0;a.s[a.B[1][f]]|=b0;a.C[f]|=256;a.C[f]|=512;}}for(e=0;e<a.d;e++){for(l=0;l<a.g[e];l++){j=a.i[e][l];if((a.C[j]&256)!=0)continue;i=a.f[e][l];for(m=0;m<a.g[i];m++){if(a.i[i][m]==j)continue;a.j[i][m]>1&&(a.A[a.f[i][m]]==6?a.s[e]|=J0:!o_.mn(a,a.i[i][m])&&o_.uk(a,a.f[i][m])&&(a.s[e]|=c0));}}}while(true){k=false;for(c=0;c<a.d;c++){if(a.k[c]>0&&(20480&a.s[c])==c0){for(l=0;l<a.g[c];l++){if(a.j[c][l]>1){i=a.f[c][l];j=a.i[c][l];for(m=0;m<a.g[i];m++){if(a.i[i][m]!=j){h=a.f[i][m];if((a.s[h]&c0)==0){a.s[h]|=c0;k=true;}}}}}}}if(!k)break;}}a.R|=6;};o_.gm=function gm(a,b){var c,d,e,f,g;c=-1;if(a.k[b]==1){for(f=0;f<a.g[b];f++){if(a.j[b][f]==2){d=a.f[b][f];if(a.g[d]==2&&a.k[d]==2){for(g=0;g<2;g++){e=a.f[d][g];if(e!=b&&a.k[e]==1){c=d;break;}}}break;}}}return c;};o_.hm=function hm(a,b,c){var d,e;d=b;while(a.g[c]==2&&a.k[c]==2&&c!=d){e=c;c=a.f[c][0]==b?a.f[c][1]:a.f[c][0];b=e;}return c==d?-1:c;};o_.im=function im(a,b){var c;if(a.g[b]==3&&(a.s[b]&b0)!=0&&(!!a.n&&b<a.d?o_.Lp(a.n,b):0)>=6)for(c=0;c<a.g[b];c++)if(o_.nn(a,a.i[b][c]))return a.i[b][c];return -1;};o_.jm=function jm(a,b,c,d,e){var f,g,h,i,j,k;o_.Jr(a,7);if((a.s[b]&n1)==0||c&&(a.s[b]&b0)==0)return;i=OI(h_.hK,k0,5,a.d,15,1);i[0]=b;d[b]=true;h=0;j=0;while(h<=j){for(k=0;k<a.g[i[h]];k++){g=a.i[i[h]][k];if(!e[g]&&(a.C[g]&64)!=0&&(!c||(a.C[g]&256)!=0)){e[g]=true;f=a.f[i[h]][k];if(!d[f]){d[f]=true;i[++j]=f;}}}++h;}};o_.km=function km(a,b){var c,d,e,f,g,h,i,j,k;a.n=new o_.aq(a,b);d=OI(h_.hK,k0,5,a.d,15,1);for(e=0;e<a.e;e++){if(o_.Np(a.n,e)!=0){a.C[e]|=64;++d[a.B[0][e]];++d[a.B[1][e]];}}for(c=0;c<a.d;c++){d[c]==2?a.s[c]|=L0:d[c]==3?a.s[c]|=V0:d[c]>3&&(a.s[c]|=n1);}g=(b&5&-2)!=0;for(k=0;k<a.n.i.a.length;k++){h=o_.Pp(a.n,k);j=o_.Qp(a.n,k);i=h.length;for(f=0;f<i;f++){a.s[h[f]]|=8;a.C[j[f]]|=128;if(g){if(o_.Up(a.n,k)){a.s[h[f]]|=b0;a.C[j[f]]|=256;}o_.Xp(a.n,k)&&(a.C[j[f]]|=512);}a.F[j[f]]==26&&(a.F[j[f]]=2);}}};o_.lm=function lm(a){var b,c,d,e,f,g,h,i,j,k;j=OI(h_.DN,C0,5,a.o,16,1);for(c=0;c<a.o;c++)j[c]=a.A[c]==1&&a.v[c]==0&&a.q[c]==0&&(a.r==null||a.r[c]==null);k=OI(h_.DN,C0,5,a.o,16,1);for(i=0;i<a.p;i++){d=a.B[0][i];e=a.B[1][i];if(o_.Vj(a,i)!=1){j[d]=false;j[e]=false;continue;}k[d]&&(j[d]=false);k[e]&&(j[e]=false);j[d]&&(g=a.A[e],g>=3&&g<=4||g>=11&&g<=13||g>=19&&g<=31||g>=37&&g<=51||g>=55&&g<=84||g>=87&&g<=103)&&(j[d]=false);j[e]&&(f=a.A[d],f>=3&&f<=4||f>=11&&f<=13||f>=19&&f<=31||f>=37&&f<=51||f>=55&&f<=84||f>=87&&f<=103)&&(j[e]=false);k[d]=true;k[e]=true;}for(h=0;h<a.p;h++){if(j[a.B[0][h]]&&j[a.B[1][h]]){j[a.B[0][h]]=false;j[a.B[1][h]]=false;}}for(b=0;b<a.o;b++)k[b]||(j[b]=false);return j;};o_.mm=function mm(a,b){return a.c[b];};o_.nm=function nm(a,b){return a.f[b].length;};o_.om=function om(a,b){return a.c[b]-o_.Rm(a,b)+o_.Nm(a,b);};o_.pm=function pm(a){var b,c;o_.Jr(a,7);b=0;for(c=0;c<a.n.i.a.length;c++)o_.Up(a.n,c)&&++b;return b;};o_.qm=function qm(a,b){return a.k[b];};o_.rm=function rm(a,b){o_.Jr(a,7);return a.k[b]==2&&a.g[b]==2?o_.En(a,b):o_.Gn(a,b);};o_.sm=function sm(a,b){var c;c=a.s[b]&n1;return c==0?0:c==L0?2:c==V0?3:4;};o_.tm=function tm(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;o_.Jr(a,7);f=OI(h_.DN,C0,5,a.e,16,1);l=OI(h_.DN,C0,5,a.e,16,1);o=OI(h_.hK,k0,5,a.d,15,1);g=0;for(h=1;h<a.g[b];h++){d=a.i[b][h];if((a.C[d]&64)!=0){for(j=0;j<h;j++){e=a.i[b][j];if((a.C[e]&64)!=0){l[d]=true;l[e]=true;n=o_.Tm(a,o,a.f[b][h],a.f[b][j],c-2,l);l[d]=false;l[e]=false;if(n!=-1){i=false;m=OI(h_.hK,k0,5,n,15,1);o_.Um(a,o,m,n);for(k=0;k<n;k++){if(!f[m[k]]){f[m[k]]=true;i=true;}}i&&++g;}}}}}return g;};o_.um=function um(a,b){return !!a.n&&b<a.d?o_.Lp(a.n,b):0;};o_.vm=function vm(a,b){if(b){o_.Jr(a,1);return o_.Kj(a,a.d,a.e,o_.Ki);}else {return o_.Kj(a,a.o,a.p,o_.Ki);}};o_.wm=function wm(a){var b,c,d,e,f,g,h,i;o_.Jr(a,1);h=OI(h_.gK,f1,5,a.d,15,1);d=OI(h_.hK,k0,5,a.d,15,1);for(i=0;i<a.d;i++){d[0]=i;e=OI(h_.hK,k0,5,a.d,15,1);e[i]=1;c=0;f=0;while(c<=f){for(g=0;g<a.g[d[c]];g++){b=a.f[d[c]][g];if(e[b]==0){e[b]=e[d[c]]+1;d[++f]=b;h[i]+=e[b]-1;}}++c;}h[i]/=f;}return h;};o_.xm=function xm(a,b,c){var d;for(d=0;d<a.f[b].length;d++)if(a.f[b][d]==c)return a.i[b][d];return -1;};o_.ym=function ym(a,b){return !!a.n&&b<a.e?o_.Np(a.n,b):0;};o_.zm=function zm(a,b,c){return a.f[b][c];};o_.Am=function Am(a,b){return a.g[b];};o_.Bm=function Bm(a,b,c){return a.i[b][c];};o_.Cm=function Cm(a,b,c){return a.j[b][c];};o_.Dm=function Dm(a,b){var c,d;c=0;for(d=0;d<a.g[b];d++)(a.w[d]&D0)!=0&&++c;return c;};o_.Em=function Em(a,b){return a.c[b]-a.g[b];};o_.Fm=function Fm(a,b,c,d,e){var f,g,h,i;g=a.c[b];if(a.k[b]!=0||(a.s[b]&b0)!=0||a.g[b]<3||g>4)return false;i=OI(h_.DN,C0,5,4,16,1);for(h=0;h<g;h++){f=3.9269908169872414-d[h];if($wnd.Math.abs(w1-f%I0)>0.0872664675116539)return false;e[h]=3&cK(f/I0);if(i[e[h]])return false;i[e[h]]=true;if((e[h]&1)==0){if(a.F[a.i[b][c[h]]]!=1)return false;}else {if(!o_.Ek(a,a.i[b][c[h]],b))return false;}}return i[0]&&i[2];};o_.Gm=function Gm(a,b,c,d,e){var f,g,h,i,j,k,l,m;f=a.c[b];e==null&&(e=OI(h_.hK,k0,5,f,15,1));if(!o_.Fm(a,b,c,d,e))return 3;i=-1;for(j=0;j<f;j++){if((e[j]&1)==1){g=a.F[a.i[b][c[j]]];if(i!=-1&&i!=g)return 3;i=g;}}k=$wnd.Math.abs(e[0]-e[1])==2?1:0;h=e[k]-e[k+1];m=$wnd.Math.abs(h)==3^e[k]<e[k+1];l=f==3||(e[3]&1)==1;return m^l^i==9?1:2;};o_.Hm=function Hm(a,b,c){var d,e,f,g,h,i,j,k,l,m;o_.Jr(a,1);m=OI(h_.DN,C0,5,a.o,16,1);j=OI(h_.hK,k0,5,a.o,15,1);j[0]=b;m[b]=true;g=0;k=0;i=1;while(g<=k){f=c?o_.nm(a,j[g]):a.c[j[g]];for(l=0;l<f;l++){e=a.f[j[g]][l];if(!m[e]){j[++k]=e;m[e]=true;++i;}}++g;}h=OI(h_.hK,k0,5,i,15,1);i=0;for(d=0;d<a.o;d++)m[d]&&(h[i++]=d);return h;};o_.Im=function Im(a,b,c,d){var e,f,g,h,i,j,k,l,m;o_.Jr(a,1);for(f=0;f<a.o;f++)b[f]=-1;j=0;for(e=0;e<a.o;e++){if(b[e]==-1&&(!c||(a.s[e]&b1)!=0)){b[e]=j;k=OI(h_.hK,k0,5,a.o,15,1);k[0]=e;i=0;l=0;while(i<=l){h=d?o_.nm(a,k[i]):a.c[k[i]];for(m=0;m<h;m++){g=a.f[k[i]][m];if(b[g]==-1&&(!c||(a.s[g]&b1)!=0)){k[++l]=g;b[g]=j;}}++i;}++j;}}return j;};o_.Jm=function Jm(a,b){var c;return c=o_.ck(a,b),c+o_.ak(a,b,c)-o_.Sm(a,b);};o_.Km=function Km(a,b){var c,d,e,f,g;f=OI(h_.hK,k0,5,a.o,15,1);for(d=0;d<a.o;d++)f[d]=d;e=a.o;do--e;while(e>=0&&b[e]);for(c=0;c<e;c++){if(b[f[c]]){g=f[c];f[c]=f[e];f[e]=g;do--e;while(b[e]);}}return f;};o_.Lm=function Lm(a){return o_.Km(a,o_.lm(a));};o_.Mm=function Mm(a,b,c){var d,e,f,g;e=o_.Sm(a,b);e-=o_.ak(a,b,e);c&&(e-=a.c[b]-a.g[b]);g=a.A[b]<o_.Hi.length?o_.Hi[a.A[b]]:null;f=g==null?6:g[0];if(e<=f)return -1;if(g!=null)for(d=1;f<e&&d<g.length;d++)f=g[d];return $wnd.Math.max(f,e);};o_.Nm=function Nm(a,b){var c,d,e,f,g,h;if(a.I&&(a.w[b]&V0)==0)return 0;if(!o_.Pn(a,b))return 0;o_.Jr(a,1);g=0;for(e=0;e<a.c[b];e++)g+=a.j[b][e];if(a.I){c=1;for(d=0;d<a.g[b];d++)a.F[a.i[b][d]]==64&&++c;g+=c>>1;}g-=o_.ak(a,b,g);f=((a.s[b]&l1)>>>28)-1;if(f==-1){if(a.A[b]>=171&&a.A[b]<=190){f=2;}else {h=a.A[b]<o_.Hi.length?o_.Hi[a.A[b]]:null;if(h==null){f=6;}else {f=h[0];for(d=1;f<g&&d<h.length;d++)f=h[d];}}}return $wnd.Math.max(0,f-g);};o_.Om=function Om(a,b){var c,d,e,f,g;e=o_.Sm(a,b);c=o_.ak(a,b,e);f=((a.s[b]&l1)>>>28)-1;if(f==-1){g=a.A[b]<o_.Hi.length?o_.Hi[a.A[b]]:null;if(g==null){f=6;}else {d=0;while(e>g[d]+c&&d<g.length-1)++d;f=g[d];}}return f+c-e;};o_.Pm=function Pm(a,b){return a.f[b].length-a.c[b];};o_.Qm=function Qm(a){var b,c,d,e;o_.Jr(a,1);e=0;for(b=0;b<a.o;b++){d=a.v[b]!=0?a.v[b]:o_.Ji[a.A[b]];e+=d+o_.Nm(a,b)*o_.Ji[1];if(a.A[b]>=171&&a.A[b]<=190){c=a.c[b];c>2&&(e-=(c-2)*o_.Ji[1]);}}return e;};o_.Rm=function Rm(a,b){var c,d;c=a.g[b];for(d=0;d<a.g[b];d++)a.A[a.f[b][d]]==1&&--c;return c;};o_.Sm=function Sm(a,b){var c,d;a.qb(1);d=0;for(c=0;c<a.c[b];c++)(!a.I||(a.w[a.f[b][c]]&D0)==0)&&(d+=a.j[b][c]);return d;};o_.Tm=function Tm(a,b,c,d,e,f){var g,h,i,j,k,l,m,n,o;if(c==d){b[0]=c;return 0;}o_.Jr(a,1);j=OI(h_.hK,k0,5,a.o,15,1);i=OI(h_.hK,k0,5,a.o,15,1);o=OI(h_.hK,k0,5,a.o,15,1);i[0]=c;j[c]=1;h=0;k=0;while(h<=k&&j[i[h]]<=e){n=i[h];for(l=0;l<a.c[n];l++){if(f==null||f.length<=a.i[n][l]||!f[a.i[n][l]]){g=a.f[n][l];if(g==d){m=j[n];b[m]=g;b[--m]=n;while(m>0){b[m-1]=o[b[m]];--m;}return j[n];}if(j[g]==0){i[++k]=g;j[g]=j[n]+1;o[g]=n;}}}++h;}return -1;};o_.Um=function Um(a,b,c,d){var e,f;o_.Jr(a,1);for(e=0;e<d;e++){for(f=0;f<a.c[b[e]];f++){if(a.f[b[e]][f]==b[e+1]){c[e]=a.i[b[e]][f];break;}}}};o_.Vm=function Vm(a,b,c){var d,e,f,g,h,i;if(b==c)return 0;o_.Jr(a,1);g=OI(h_.hK,k0,5,a.o,15,1);f=OI(h_.hK,k0,5,a.o,15,1);f[0]=b;g[b]=1;e=0;h=0;while(e<=h){for(i=0;i<a.c[f[e]];i++){d=a.f[f[e]][i];if(d==c)return g[f[e]];if(g[d]==0){f[++h]=d;g[d]=g[f[e]]+1;}}++e;}return -1;};o_.Wm=function Wm(a,b,c,d,e){var f,g,h,i,j,k;if(b==c)return 0;o_.Jr(a,1);i=OI(h_.hK,k0,5,a.o,15,1);h=OI(h_.hK,k0,5,a.o,15,1);h[0]=b;i[b]=1;g=0;j=0;while(g<=j&&i[h[g]]<=d){for(k=0;k<a.c[h[g]];k++){f=a.f[h[g]][k];if(f==c)return i[h[g]];if(i[f]==0&&(e==null||e.length<=f||!e[f])){h[++j]=f;i[f]=i[h[g]]+1;}}++g;}return -1;};o_.Xm=function Xm(a,b){return a.c[b]-a.g[b]+o_.Nm(a,b);};o_.Ym=function Ym(a){o_.Jr(a,7);return a.n;};o_.Zm=function Zm(a){var b,c,d,e,f,g,h,i,j;j=0;o_.Jr(a,7);for(d=0;d<a.e;d++){if(o_.Vj(a,d)==1&&(a.C[d]&64)==0){h=true;for(g=0;g<2;g++){b=a.B[g][d];if(a.g[b]==1){h=false;break;}if(a.A[b]==7&&(a.s[b]&b0)==0){c=a.B[1-g][d];for(i=0;i<a.g[c];i++){e=a.f[c][i];f=a.i[c][i];if(f!=d&&o_.Vj(a,f)>1&&(a.s[e]&b0)==0&&o_.Zl(a.A[e])){h=false;break;}}}}h&&!o_.vn(a,d)&&++j;}}return j;};o_.$m=function $m(a,b){var c,d,e,f;c=a.c[b];f=OI(h_.hK,k0,5,c,15,1);for(e=0;e<c;e++)f[e]=(a.f[b][e]<<16)+e;n_.V$(f).sort(n_.V$(AO(l_.pX.prototype.Ub,l_.pX,[])));for(d=0;d<c;d++)f[d]&=f0;return f;};o_._m=function _m(a,b){var c,d;o_.Jr(a,1);if(a.g[b]==2&&a.j[b][0]==2&&a.j[b][1]==2){for(c=0;c<2;c++)for(d=0;d<a.c[a.f[b][c]];d++)if(o_.Ek(a,a.i[a.f[b][c]][d],a.f[b][c]))return a.i[a.f[b][c]][d];}else {for(c=0;c<a.c[b];c++)if(o_.Ek(a,a.i[b][c],b))return a.i[b][c];}return -1;};o_.an=function an(a,b,c){if(o_.Vj(a,b)!=1)return 0;return 16-a.c[c]+(a.A[c]==1?b0:0)+((a.F[b]&24)==0||a.B[0][b]!=c?V0:0)+((a.s[c]&3)==0?L0:0)+((a.C[b]&64)!=0?0:512)+(a.A[c]!=6?256:0);};o_.bn=function bn(a,b,c,d,e,f){var g,h,i,j,k;o_.Jr(a,1);if(e){o_._i(e);e.I=false;}i=OI(h_.hK,k0,5,a.o,15,1);d==null?d=OI(h_.DN,C0,5,a.o,16,1):l_.XW(d,d.length);i[0]=b;i[1]=c;d[b]=true;d[c]=true;h=1;j=1;while(h<=j){for(k=0;k<a.c[i[h]];k++){g=a.f[i[h]][k];if(g==b){if(h!=1)return -1;}if(!d[g]){d[g]=true;i[++j]=g;}}++h;}if(e){f==null&&(f=OI(h_.hK,k0,5,d.length,15,1));o_.dm(a,e,d,false,f);o_.Yi(e,f[b],0,0,-1,0);}d[b]=false;return j;};o_.cn=function cn(a,b,c){var d,e,f,g,h,i;o_.Jr(a,1);f=OI(h_.hK,k0,5,a.d,15,1);i=OI(h_.DN,C0,5,a.d,16,1);f[0]=b;f[1]=c;i[b]=true;i[c]=true;e=1;g=1;while(e<=g){for(h=0;h<a.g[f[e]];h++){d=a.f[f[e]][h];if(d==b){if(e!=1)return -1;}if(!i[d]){i[d]=true;f[++g]=d;}}++e;}return g;};o_.dn=function dn(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;if(o_.Vj(a,c)!=2&&(a.C[c]&256)==0)return -1;n=a.C[c]&3;if(n!=1&&n!=2)return -1;for(i=0;i<2;i++){d=a.B[i][c];e=a.B[1-i][c];m=-1;g=false;for(k=0;k<a.g[d];k++){f=a.f[d][k];f!=e&&(f==b?g=true:m=f);}if(g){l=-1;h=-1;for(j=0;j<a.g[e];j++){f=a.f[e][j];if(f!=d){if(l==-1)l=f;else if(f>l)h=f;else {h=l;l=f;}}}if(a.g[d]==2){if(a.g[e]==2)return n==2?l:-1;return n==2?l:h;}else {if(a.g[e]==2)return n==2^b<m?-1:l;return n==2^b<m?h:l;}}}return -1;};o_.en=function en(a){var b,c,d,e,f,g,h,i,j,k,l;g=o_.lm(a);i=a.o;do--i;while(i>=0&&g[i]);for(b=0;b<i;b++){if(g[b]){o_.Jl(a,b,i);k=g[b];g[b]=g[i];g[i]=k;do--i;while(g[i]);}}a.d=i+1;if(a.o==a.d){a.e=a.p;return;}h=OI(h_.DN,C0,5,a.p,16,1);for(f=0;f<a.p;f++){c=a.B[0][f];d=a.B[1][f];(g[c]||g[d])&&(h[f]=true);}j=a.p;do--j;while(j>=0&&h[j]);for(e=0;e<j;e++){if(h[e]){l=a.B[0][e];a.B[0][e]=a.B[0][j];a.B[0][j]=l;l=a.B[1][e];a.B[1][e]=a.B[1][j];a.B[1][j]=l;l=a.F[e];a.F[e]=a.F[j];a.F[j]=l;h[e]=false;do--j;while(h[j]);}}a.e=j+1;};o_.fn=function fn(a,b){var c;for(c=0;c<a.g[b];c++)if(a.q[a.f[b][c]]<0)return true;return false;};o_.gn=function gn(a,b){var c;for(c=0;c<a.g[b];c++)if(a.q[a.f[b][c]]>0)return true;return false;};o_.hn=function hn(a,b){var c;c=a.A[b];return c==3||c==11||c==19||c==37||c==55;};o_.jn=function jn(a,b){return (a.s[b]&J0)!=0;};o_.kn=function kn(a,b){var c,d,e,f,g,h;o_.Jr(a,1);for(g=0;g<2;g++){c=a.B[g][b];if(a.A[c]==7){d=a.B[1-g][b];for(h=0;h<a.g[d];h++){e=a.f[d][h];f=a.i[d][h];if((a.A[e]==7||a.A[e]==8||a.A[e]==16)&&o_.Vj(a,f)>=2)return true;}}}return false;};o_.ln=function ln(a,b){return (a.s[b]&b0)!=0;};o_.mn=function mn(a,b){return (a.C[b]&256)!=0;};o_.nn=function nn(a,b){var c,d,e,f,g,h;if(a.F[b]!=1||(a.C[b]&256)!=0||(a.C[b]&64)!=0&&(!!a.n&&b<a.e?o_.Np(a.n,b):0)<7)return false;c=a.B[0][b];if((a.s[c]&b0)==0||(!!a.n&&c<a.d?o_.Lp(a.n,c):0)<6)return false;d=a.B[1][b];if((a.s[d]&b0)==0||(!!a.n&&d<a.d?o_.Lp(a.n,d):0)<6)return false;h=0;for(g=0;g<a.g[c];g++){e=a.f[c][g];e!=d&&a.g[e]>2&&++h;}for(f=0;f<a.g[d];f++){e=a.f[d][f];e!=c&&a.g[e]>2&&++h;}return h>2;};o_.on=function on(a,b){return a.k[b]==2&&a.g[b]==2&&a.j[b][0]==2&&a.j[b][1]==2&&a.A[b]<=7;};o_.pn=function pn(a,b){var c;c=a.A[b];return c==8||c==16||c==34||c==52;};o_.qn=function qn(a,b){return (a.C[b]&512)!=0;};o_.rn=function rn(a,b){var c;c=a.A[b];return c==12||c==20||c==38||c==56;};o_.sn=function sn(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;if(a.A[b]!=7)return false;if((a.s[b]&b0)!=0||a.k[b]!=0||(a.w[b]&U0)!=0)return true;if(a.q[b]==1)return false;f=0;for(h=0;h<a.g[b];h++){if(a.j[b][h]==1){c=a.A[a.f[b][h]];(c==8||c==9||c==17)&&++f;}}if(f==0){for(g=0;g<a.g[b];g++){d=a.f[b][g];if(a.k[d]!=0){if((a.s[d]&b0)!=0){if((!!a.n&&d<a.d?o_.Lp(a.n,d):0)>=5){n=0;for(k=0;k<a.g[d];k++){m=a.f[d][k];m!=b&&o_.Rm(a,m)>=3&&++n;}l=o_.Rm(a,b);if(n==2&&l>=2||n==1&&l==3)continue;}return true;}for(j=0;j<a.g[d];j++){if(a.j[d][j]==2||o_.mn(a,a.i[d][j]))return true;}}}}if(f<2){for(g=0;g<a.g[b];g++){d=a.f[b][g];i=false;e=false;for(j=0;j<a.g[d];j++){if(a.f[d][j]!=b){a.j[d][j]!=1&&(a.A[a.f[d][j]]==7||a.A[a.f[d][j]]==8||a.A[a.f[d][j]]==16)&&(i=true);a.j[d][j]==1&&a.A[a.f[d][j]]==7&&(e=true);}}if(i&&(!e||f==0))return true;}}return false;};o_.tn=function tn(a,b){var c;c=a.A[b];return c==9||c==17||c==35||c==53;};o_.un=function un(a,b){var c;c=a.A[b];return c==7||c==15||c==33;};o_.vn=function vn(a,b){var c,d,e,f,g,h;if(o_.Vj(a,b)!=1)return false;for(f=0;f<2;f++){c=a.B[f][b];h=a.B[1-f][b];while(a.k[c]==2&&a.g[c]==2&&a.A[c]<10){for(g=0;g<2;g++){d=a.f[c][g];if(d!=h){if(a.g[d]==1)return true;e=a.i[c][g];if(o_.Vj(a,e)==1&&e<b)return true;h=c;c=d;break;}}}if(a.g[c]==1)return true;}return false;};o_.wn=function wn(a,b){return (a.s[b]&n1)!=0;};o_.xn=function xn(a,b){return (a.C[b]&64)!=0;};o_.yn=function yn(a,b){return a.A[b]==1&&a.v[b]==0&&a.q[b]==0&&(a.r==null||a.r[b]==null);};o_.zn=function zn(a,b){return (a.s[b]&8)!=0;};o_.An=function An(a,b){return (a.C[b]&128)!=0;};o_.Bn=function Bn(a,b){return (a.s[b]&c0)!=0;};o_.Cn=function Cn(a){var b,c,d,e,f,g,h,i,j,k,l;o_.Jr(a,1);o_.Dn(a);j=false;for(c=0;c<a.d;c++){if(a.A[c]==7&&a.q[c]==0){l=o_.Sm(a,c);if(l==4){for(k=0;k<a.g[c];k++){h=a.f[c][k];if(a.j[c][k]==1&&a.A[h]==8&&a.g[h]==1&&a.q[h]==0){j=true;++a.q[c];--a.q[h];break;}}}else if(l==5){for(k=0;k<a.g[c];k++){h=a.f[c][k];i=a.i[c][k];if(a.j[c][k]==2&&a.A[h]==8){j=true;++a.q[c];--a.q[h];a.F[i]=1;break;}if(a.j[c][k]==3&&a.A[h]==7){j=true;++a.q[c];--a.q[h];a.F[i]=2;break;}}}}}g=false;for(f=0;f<a.e;f++){for(k=0;k<2;k++){if(o_.uk(a,a.B[k][f])){b=a.B[1-k][f];e=a.A[b];if(e==3||e==11||e==19||e==37||e==55||(d=a.A[b],d==12||d==20||d==38||d==56)){if(o_.Vj(a,f)==1){++a.q[b];--a.q[a.B[k][f]];a.F[f]=128;g=true;}else if(a.F[f]==32){a.F[f]=128;g=true;}}break;}}}if(g){o_.aj(a);j=true;}j&&(a.R=0);return j;};o_.Dn=function Dn(a){var b;for(b=0;b<a.e;b++)if(a.F[b]==64)return o_.$d(new o_.ie(a),null,false);return false;};o_.En=function En(a,b){var c,d,e,f,g,h,i,j;i=-1;d=0;for(g=0;g<2;g++){c=a.f[b][g];for(h=0;h<a.c[c];h++){e=a.f[c][h];if(e!=b){f=a.i[c][h];j=o_.an(a,f,e);if(d<j){d=j;i=f;}}}}return i;};o_.Fn=function Fn(a,b){var c,d,e,f,g,h,i,j;i=-1;d=0;for(g=0;g<2;g++){c=a.B[g][b];for(h=0;h<a.c[c];h++){e=a.f[c][h];if(e!=a.B[1-g][b]){f=a.i[c][h];j=o_.an(a,f,e);if(d<j){d=j;i=f;}}}}return i;};o_.Gn=function Gn(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;c=a.c[b];d=OI(h_.fK,B0,5,c,15,1);for(m=0;m<c;m++)d[m]=o_.Mj(a,b,a.f[b][m]);for(n=1;n<c;n++){for(o=0;o<n;o++){e=$wnd.Math.abs(o_.Xl(d[n],d[o]));if(e<0.08||e>x1){f=0;g=0;for(p=0;p<c;p++){if(p!=n&&p!=o){f+=$wnd.Math.abs(u_.XF(d[n],d[p]));g+=$wnd.Math.abs(u_.XF(d[o],d[p]));}}i=f<g?a.i[b][n]:a.i[b][o];if(o_.Vj(a,i)==1)return i;}}}q=-1;h=0;for(l=0;l<c;l++){j=a.f[b][l];k=a.i[b][l];r=o_.an(a,k,j);if(h<r){h=r;q=k;}}return q;};o_.Hn=function Hn(a,b){var c,d,e,f;o_.Jr(a,b?1:15);a.o=a.d;a.p=a.e;for(d=0;d<a.d;d++){if(a.c[d]!=a.g[d]){c=o_.Mm(a,d,false);a.c[d]=a.g[d];if(c!=-1){f=o_.Mm(a,d,true);if(c!=f){e=((a.s[d]&l1)>>>28)-1;(e==-1||e<c)&&o_.Tk(a,d,c);}}}}b||o_.Nn(a);a.R=0;};o_.In=function In(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B;if(a.g[b]!=2||a.j[b][0]!=2||a.j[b][1]!=2||a.g[a.f[b][0]]<2||a.g[a.f[b][1]]<2||a.k[a.f[b][0]]!=1||a.k[a.f[b][1]]!=1){o_.el(a,b,0,false);return;}w=-1;v=-1;u=-1;r=-1;f=0;for(l=0;l<2;l++){d=a.f[b][l];for(p=0;p<a.c[d];p++){g=a.f[d][p];if(g!=b){h=a.i[d][p];A=o_.an(a,h,g);if(f<A){f=A;v=g;w=h;u=d;r=a.f[b][1-l];}}}}if(v==-1)return;for(m=0;m<2;m++)for(o=0;o<a.c[a.f[b][m]];o++)a.f[a.f[b][m]][o]!=b&&(a.F[a.i[a.f[b][m]][o]]=1);if(a.B[1][w]!=v){a.B[0][w]=a.B[1][w];a.B[1][w]=v;}i=P_;for(n=0;n<a.g[u];n++){g=a.f[u][n];g!=b&&i>g&&(i=g);}s=OI(h_.hK,k0,5,2,15,1);t=0;for(k=0;k<a.g[r];k++){g=a.f[r][k];g!=b&&(s[t++]=g);}c=o_.Wl(a.H[b].a,a.H[b].b,a.H[r].a,a.H[r].b);e=0;if(t==2){if(s[0]>s[1]){B=s[0];s[0]=s[1];s[1]=B;}j=o_.Xl(c,o_.Mj(a,r,s[0]));q=o_.Xl(c,o_.Mj(a,r,s[1]));e=j-q;}else {e=o_.Xl(c,o_.Mj(a,r,s[0]));}e<0^(a.s[b]&3)==1^i==v?a.F[w]=17:a.F[w]=9;};o_.Jn=function Jn(a,b,c,d){var e,f,g,h,i,j;e=a.c[b];h=OI(h_.hK,k0,5,e,15,1);j=o_.Gm(a,b,c,d,h);if(j==3)return false;g=(a.s[b]&3)==j?17:9;for(i=0;i<e;i++){if((h[i]&1)==1){f=a.i[b][c[i]];a.F[f]=g;if(a.B[0][f]!=b){a.B[1][f]=a.B[0][f];a.B[0][f]=b;}}}return true;};o_.Kn=function Kn(a,b){a.R|=504&(8|b);};o_.Ln=function Ln(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;o_.cm(a,b);if((a.s[b]&3)==0||(a.s[b]&3)==3)return;if(a.k[b]==2&&a.g[b]==2){o_.In(a,b);return;}if(a.g[b]<3||a.g[b]>4){o_.el(a,b,0,false);return;}c=a.c[b];q=false;for(h=0;h<c;h++){if(o_.Vj(a,a.i[b][h])==1){q=true;break;}}if(!q)return;r=o_.$m(a,b);d=OI(h_.fK,B0,5,c,15,1);for(i=0;i<c;i++)d[i]=o_.Mj(a,a.f[b][r[i]],b);for(j=0;j<c;j++)a.B[0][a.i[b][j]]==b&&o_.Vj(a,a.i[b][j])==1&&(a.F[a.i[b][j]]=1);if(o_.Jn(a,b,r,d))return;o=-1;for(k=0;k<c;k++){f=a.i[b][k];if((a.F[f]==17||a.F[f]==9)&&a.B[0][f]==b){a.F[a.i[b][k]]=1;o==-1?o=f:o=-2;}}o<0&&(o=o_.Gn(a,b));if(a.B[0][o]!=b){a.B[1][o]=a.B[0][o];a.B[0][o]=b;}p=-1;for(l=0;l<c;l++){if(o==a.i[b][r[l]]){p=l;break;}}s=XI(II(h_.hK,2),d1,6,0,[XI(II(h_.hK,1),k0,5,15,[2,1,2,1]),XI(II(h_.hK,1),k0,5,15,[1,2,2,1]),XI(II(h_.hK,1),k0,5,15,[1,1,2,2]),XI(II(h_.hK,1),k0,5,15,[2,1,1,2]),XI(II(h_.hK,1),k0,5,15,[2,2,1,1]),XI(II(h_.hK,1),k0,5,15,[1,2,1,2])]);for(g=1;g<c;g++)d[g]<d[0]&&(d[g]+=G0);if(c==3){m=false;switch(p){case 0:m=d[1]<d[2]&&d[2]-d[1]<H0||d[1]>d[2]&&d[1]-d[2]>H0;break;case 1:m=d[2]-d[0]>H0;break;case 2:m=d[1]-d[0]<H0;}e=(a.s[b]&3)==1^m?17:9;}else {n=0;d[1]<=d[2]&&d[2]<=d[3]?n=0:d[1]<=d[3]&&d[3]<=d[2]?n=1:d[2]<=d[1]&&d[1]<=d[3]?n=2:d[2]<=d[3]&&d[3]<=d[1]?n=3:d[3]<=d[1]&&d[1]<=d[2]?n=4:d[3]<=d[2]&&d[2]<=d[1]&&(n=5);e=(a.s[b]&3)==1^s[n][p]==1?9:17;}a.F[o]=e;};o_.Mn=function Mn(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;if((a.C[b]&3)==0||(a.C[b]&3)==3||!o_.nn(a,b))return;v=-1;t=-1;u=-1;s=-1;e=0;for(l=0;l<2;l++){d=a.B[l][b];for(o=0;o<a.c[d];o++){h=a.i[d][o];if(h!=b&&o_.Vj(a,h)==1){g=a.f[d][o];w=o_.an(a,h,g);if(e<w){e=w;t=g;v=h;u=d;s=a.B[1-l][b];}}}}if(t==-1)return;for(m=0;m<2;m++){for(o=0;o<a.c[a.B[m][b]];o++){h=a.i[a.B[m][b]][o];h!=b&&o_.Vj(a,h)==1&&(a.F[h]=1);}}if(a.B[1][v]!=t){a.B[0][v]=a.B[1][v];a.B[1][v]=t;}i=P_;for(n=0;n<a.g[u];n++){g=a.f[u][n];a.i[u][n]!=b&&i>g&&(i=g);}q=OI(h_.hK,k0,5,2,15,1);r=0;for(k=0;k<a.g[s];k++)a.i[s][k]!=b&&(q[r++]=a.f[s][k]);f=o_.Wl(a.H[u].a,a.H[u].b,a.H[s].a,a.H[s].b);c=0;if(r==2){if(q[0]>q[1]){A=q[0];q[0]=q[1];q[1]=A;}j=o_.Xl(f,o_.Mj(a,s,q[0]));p=o_.Xl(f,o_.Mj(a,s,q[1]));c=j-p;}else {c=o_.Xl(f,o_.Mj(a,s,q[0]));}c<0^(a.C[b]&3)==2^i==t?a.F[v]=17:a.F[v]=9;};o_.Nn=function Nn(a){var b,c,d;o_.Jr(a,7);for(b=0;b<a.d;b++)o_.Ln(a,b);for(d=0;d<a.e;d++)o_.Mn(a,d);for(c=0;c<a.e;c++)a.F[c]==2&&(a.C[c]&3)==3&&(a.F[c]=26);};o_.On=function On(b,c){var d,e,f,g,h,i,j,k,l,m;i=OI(h_.hK,k0,5,b.o,15,1);h=o_.Im(b,i,false,c);if(h<=1)return null;j=OI(h_.hK,k0,5,h,15,1);for(e=0;e<b.d;e++)++j[i[e]];l=0;m=j[0];for(k=1;k<h;k++){if(m<j[k]){m=j[k];l=k;}}for(d=0;d<b.o;d++)i[d]!=l&&(b.A[d]=-1);for(g=0;g<b.p;g++)(!c&&b.F[g]==32||i[b.B[0][g]]!=l)&&(b.F[g]=128);f=o_.aj(b);b.R=0;try{o_.bm(b,true,true);}catch(a){a=HN(a);if(!VJ(a,13))throw IN(a);}return f;};o_.Pn=function Pn(a,b){var c;if((a.s[b]&l1)!=0)return true;if(a.A[b]==1)return false;return c=a.A[b],c==1||c>=5&&c<=9||c>=14&&c<=17||c>=32&&c<=35||c>=52&&c<=53||a.A[b]==13||a.A[b]>=171;};o_.Qn=function Qn(a){var b,c,d,e,f,g,h,i,j,k;f=o_.Kj(a,a.o,a.p,o_.Ki);g=f*f/16;for(d=1;d<a.o;d++){for(e=0;e<d;e++){i=a.H[e].a-a.H[d].a;j=a.H[e].b-a.H[d].b;k=a.H[e].c-a.H[d].c;if(i*i+j*j+k*k<g)throw IN(new i_.EG('The distance between two atoms is too close.'));}}o_.Jr(a,1);b=0;for(c=0;c<a.d;c++){if(o_.Sm(a,c)>(h=o_.ck(a,c),h+o_.ak(a,c,h)))throw IN(new i_.EG('atom valence exceeded'));b+=a.q[c];}if(b!=0)throw IN(new i_.EG('unbalanced atom charge'));};o_.Rn=function Rn(a,b,c){var d;d=o_.Ml(a,b,c);if(d&&c==26){o_.Jr(a,7);d=d&(a.C[b]&128)==0;}return d;};o_.Sn=function Sn(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;if(!a.I)return false;for(c=0;c<a.o;c++){n=o_.ck(a,c);n+o_.ak(a,c,n)-o_.Sm(a,c)<=0&&!(a.q[c]==0&&(a.A[c]==5||(e=a.A[c],e==7||e==15||e==33)||(d=a.A[c],d==8||d==16||d==34||d==52)))&&(a.w[c]&=-6145);}g=false;for(b=0;b<a.d;b++){h=a.c[b]-a.g[b];if(!a.Q&&h>0){if((a.w[b]&V0)==0){k=(a.w[b]&K0)==896?3:(a.w[b]&K0)==384?2:(a.w[b]&128)==128?1:0;i=(n=o_.ck(a,b),n+o_.ak(a,b,n)-o_.Sm(a,b));a.q[b]==0&&(a.w[b]&M0)==0&&a.A[b]!=6&&++i;l=h;l>3-k&&(l=3-k);l>i+h-k&&(l=i+h-k);if(l>0){m=k==0?0:(a.w[b]&K0)<<l;m|=(l==3?7:h==2?3:1)<<7;a.w[b]&=-1921;a.w[b]|=K0&m;}}for(j=a.g[b];j<a.c[b];j++){f=a.i[b][j];if(a.F[f]==1){a.A[a.f[b][j]]=-1;a.F[f]=128;g=true;}}}(a.w[b]&2)!=0&&(a.w[b]&=-9);a.q[b]!=0&&(a.s[b]&=-234881025);}g&&o_.aj(a);return g;};o_.Tn=function Tn(){o_.Pl.call(this);};o_.Un=function Un(a,b){o_.Ql.call(this,a,b);};o_.Vn=function Vn(a){o_.Ql.call(this,!a?256:a.K,!a?256:a.L);!!a&&o_.ej(a,this);};xO(71,62,{71:1,62:1,4:1});_.qb=function Wn(a){o_.fm(this,a);};_.d=0;_.e=0;h_.DK=jQ(71);o_.Xn=function Xn(a,b){return $wnd.Math.pow(10,$wnd.Math.log(2000)*$wnd.Math.LOG10E*a/(b-1)-1);};o_.Yn=function Yn(a,b){var c,d;c=b;d=0;while(b!=0){if(a.c==0){a.e=(a.b[++a.d]&63)<<11;a.c=6;}d|=(e0&a.e)>>16-c+b;a.e<<=1;--b;--a.c;}return d;};o_.Zn=function Zn(a,b,c){a.c=6;a.d=c;a.b=b;a.e=(b[a.d]&63)<<11;};o_.$n=function $n(a,b){var c,d,e,f;d=b/2|0;e=a>=d;e&&(a-=d);f=b/32|0;c=f*a/(d-a);return e?-c:c;};o_._n=function _n(a,b){var c;return b==null||n_.V$(b).length==0?null:o_.bo(a,n_.F$((c=b,n_.A$(),c)),null);};o_.ao=function ao(a,b,c){var d,e;return b==null?null:o_.bo(a,n_.F$((e=b,n_.A$(),e)),c==null?null:n_.F$((d=c,d)));};o_.bo=function bo(a,b,c){var d,e,f,g,h;if(b==null)return null;o_.Zn(a,b,0);d=o_.Yn(a,4);g=o_.Yn(a,4);d>8&&(d=g);e=o_.Yn(a,d);f=o_.Yn(a,g);h=new o_._r(e,f);o_.co(a,h,b,c,0);return h;};o_.co=function co(b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab,bb,cb,db,eb,fb,gb,hb,ib,jb,kb,lb,mb,nb,ob,pb,qb,rb,sb,tb,ub,vb,wb,xb,yb,zb,Ab,Bb,Cb,Db,Eb,Fb,Gb,Hb,Ib,Jb,Kb,Lb,Mb,Nb,Ob,Pb,Qb,Rb,Sb,Tb,Ub,Vb,Wb,Xb,Yb,Zb,$b,_b,ac,bc,cc,dc,ec,fc,gc,hc,ic,jc,kc,lc,mc,nc,oc,pc,qc;o_._i(c);if(d==null||0>=d.length)return;b.f=c;kc=8;e!=null&&f>=e.length&&(e=null);o_.Zn(b,d,0);i=o_.Yn(b,4);B=o_.Yn(b,4);if(i>8){kc=i;i=B;}if(i==0){o_.yl(b.f,o_.Yn(b,1)==1);return;}j=o_.Yn(b,i);k=o_.Yn(b,B);_b=o_.Yn(b,i);dc=o_.Yn(b,i);cc=o_.Yn(b,i);N=o_.Yn(b,i);for(o=0;o<j;o++)o_.Ni(b.f,6);for(ib=0;ib<_b;ib++)o_.ml(b.f,o_.Yn(b,i),7);for(jb=0;jb<dc;jb++)o_.ml(b.f,o_.Yn(b,i),8);for(ub=0;ub<cc;ub++)o_.ml(b.f,o_.Yn(b,i),o_.Yn(b,8));for(Fb=0;Fb<N;Fb++)o_.Vk(b.f,o_.Yn(b,i),o_.Yn(b,4)-8);O=1+k-j;U=o_.Yn(b,4);A=0;o_.jl(b.f,0,0);o_.kl(b.f,0,0);o_.ll(b.f,0,0);V=e!=null&&e[0]>=39;jc=0;mc=0;oc=0;qc=0;Q=false;R=false;if(V){if(e.length>2*j-2&&e[2*j-2]==39||e.length>3*j-3&&e[3*j-3]==39){R=true;Q=e.length==3*j-3+9;Sb=Q?3*j-3:2*j-2;w=86*(e[Sb+1]-40)+e[Sb+2]-40;jc=$wnd.Math.pow(10,w/2000-1);Sb+=2;lc=86*(e[Sb+1]-40)+e[Sb+2]-40;mc=$wnd.Math.pow(10,lc/1500-1);Sb+=2;nc=86*(e[Sb+1]-40)+e[Sb+2]-40;oc=$wnd.Math.pow(10,nc/1500-1);if(Q){Sb+=2;pc=86*(e[Sb+1]-40)+e[Sb+2]-40;qc=$wnd.Math.pow(10,pc/1500-1);}}else {Q=e.length==3*j-3;}}if(b.rb()&&Q){e=null;V=false;}for(Mb=1;Mb<j;Mb++){W=o_.Yn(b,U);if(W==0){if(V){o_.jl(b.f,Mb,o_.Fj(b.f,0)+8*(e[Mb*2-2]-83));o_.kl(b.f,Mb,o_.Gj(b.f,0)+8*(e[Mb*2-1]-83));Q&&o_.ll(b.f,Mb,o_.Hj(b.f,0)+8*(e[2*j-3+Mb]-83));}++O;continue;}A+=W-1;if(V){o_.jl(b.f,Mb,o_.Fj(b.f,A)+e[Mb*2-2]-83);o_.kl(b.f,Mb,o_.Gj(b.f,A)+e[Mb*2-1]-83);Q&&o_.ll(b.f,Mb,o_.Hj(b.f,A)+(e[2*j-3+Mb]-83));}o_.Pi(b.f,A,Mb,1);}for(Nb=0;Nb<O;Nb++)o_.Pi(b.f,o_.Yn(b,i),o_.Yn(b,i),1);Tb=OI(h_.DN,C0,5,k,16,1);for(I=0;I<k;I++){J=o_.Yn(b,2);switch(J){case 0:Tb[I]=true;break;case 2:o_.wl(b.f,I,2);break;case 3:o_.wl(b.f,I,4);}}h=o_.Yn(b,i);for(Ob=0;Ob<h;Ob++){n=o_.Yn(b,i);if(kc==8){ec=o_.Yn(b,2);if(ec==3){o_.$k(b.f,n,1,0);o_.el(b.f,n,1,false);}else {o_.el(b.f,n,ec,false);}}else {ec=o_.Yn(b,3);switch(ec){case 4:o_.el(b.f,n,1,false);o_.$k(b.f,n,1,o_.Yn(b,3));break;case 5:o_.el(b.f,n,2,false);o_.$k(b.f,n,1,o_.Yn(b,3));break;case 6:o_.el(b.f,n,1,false);o_.$k(b.f,n,2,o_.Yn(b,3));break;case 7:o_.el(b.f,n,2,false);o_.$k(b.f,n,2,o_.Yn(b,3));break;default:o_.el(b.f,n,ec,false);}}}kc==8&&o_.Yn(b,1)==0&&(b.f.J=true);g=o_.Yn(b,B);for(Pb=0;Pb<g;Pb++){D=o_.Yn(b,B);if(o_.Yj(b.f,D)==1){ec=o_.Yn(b,3);switch(ec){case 4:o_.tl(b.f,D,1,false);o_.ql(b.f,D,1,o_.Yn(b,3));break;case 5:o_.tl(b.f,D,2,false);o_.ql(b.f,D,1,o_.Yn(b,3));break;case 6:o_.tl(b.f,D,1,false);o_.ql(b.f,D,2,o_.Yn(b,3));break;case 7:o_.tl(b.f,D,2,false);o_.ql(b.f,D,2,o_.Yn(b,3));break;default:o_.tl(b.f,D,ec,false);}}else {o_.tl(b.f,D,o_.Yn(b,2),false);}}o_.yl(b.f,o_.Yn(b,1)==1);m=null;bc=0;while(o_.Yn(b,1)==1){T=bc+o_.Yn(b,4);switch(T){case 0:ac=o_.Yn(b,i);for(Qb=0;Qb<ac;Qb++){n=o_.Yn(b,i);o_.fl(b.f,n,V0,true);}break;case 1:ac=o_.Yn(b,i);for(Rb=0;Rb<ac;Rb++){n=o_.Yn(b,i);Zb=o_.Yn(b,8);o_.dl(b.f,n,Zb);}break;case 2:ac=o_.Yn(b,B);for(kb=0;kb<ac;kb++){o_.Yn(b,B);}break;case 3:ac=o_.Yn(b,i);for(lb=0;lb<ac;lb++){n=o_.Yn(b,i);o_.fl(b.f,n,b0,true);}break;case 4:ac=o_.Yn(b,i);for(mb=0;mb<ac;mb++){n=o_.Yn(b,i);ic=o_.Yn(b,4)<<3;o_.fl(b.f,n,ic,true);}break;case 5:ac=o_.Yn(b,i);for(nb=0;nb<ac;nb++){n=o_.Yn(b,i);l=o_.Yn(b,2)<<1;o_.fl(b.f,n,l,true);}break;case 6:ac=o_.Yn(b,i);for(ob=0;ob<ac;ob++){n=o_.Yn(b,i);o_.fl(b.f,n,1,true);}break;case 7:ac=o_.Yn(b,i);for(pb=0;pb<ac;pb++){n=o_.Yn(b,i);fb=o_.Yn(b,4)<<7;o_.fl(b.f,n,fb,true);}break;case 8:ac=o_.Yn(b,i);for(qb=0;qb<ac;qb++){n=o_.Yn(b,i);t=o_.Yn(b,4);r=OI(h_.hK,k0,5,t,15,1);for(Ub=0;Ub<t;Ub++){s=o_.Yn(b,8);r[Ub]=s;}o_._k(b.f,n,r);}break;case 9:ac=o_.Yn(b,B);for(rb=0;rb<ac;rb++){D=o_.Yn(b,B);ic=o_.Yn(b,2)<<5;o_.vl(b.f,D,ic,true);}break;case 10:ac=o_.Yn(b,B);for(sb=0;sb<ac;sb++){D=o_.Yn(b,B);K=o_.Yn(b,5);o_.vl(b.f,D,K,true);}break;case 11:ac=o_.Yn(b,i);for(tb=0;tb<ac;tb++){n=o_.Yn(b,i);o_.fl(b.f,n,J0,true);}break;case 12:ac=o_.Yn(b,B);for(vb=0;vb<ac;vb++){D=o_.Yn(b,B);L=o_.Yn(b,8)<<7;o_.vl(b.f,D,L,true);}break;case 13:ac=o_.Yn(b,i);for(wb=0;wb<ac;wb++){n=o_.Yn(b,i);fc=o_.Yn(b,3)<<14;o_.fl(b.f,n,fc,true);}break;case 14:ac=o_.Yn(b,i);for(xb=0;xb<ac;xb++){n=o_.Yn(b,i);$b=o_.Yn(b,5)<<17;o_.fl(b.f,n,$b,true);}break;case 15:bc=16;break;case 16:ac=o_.Yn(b,i);for(yb=0;yb<ac;yb++){n=o_.Yn(b,i);hc=o_.Yn(b,3)<<22;o_.fl(b.f,n,hc,true);}break;case 17:ac=o_.Yn(b,i);for(zb=0;zb<ac;zb++){n=o_.Yn(b,i);o_.Tk(b.f,n,o_.Yn(b,4));}break;case 18:ac=o_.Yn(b,i);Yb=o_.Yn(b,4);for(Ab=0;Ab<ac;Ab++){n=o_.Yn(b,i);S=o_.Yn(b,Yb);Vb=OI(h_.dK,j0,5,S,15,1);for(Ub=0;Ub<S;Ub++)Vb[Ub]=o_.Yn(b,7)<<24>>24;o_.Yk(b.f,n,i_.XR(n_.D$(Vb,0,(Wb=Vb.length,n_.A$(),Wb))));}break;case 19:ac=o_.Yn(b,i);for(Bb=0;Bb<ac;Bb++){n=o_.Yn(b,i);M=o_.Yn(b,3)<<25;o_.fl(b.f,n,M,true);}break;case 20:ac=o_.Yn(b,B);for(Cb=0;Cb<ac;Cb++){D=o_.Yn(b,B);hc=o_.Yn(b,3)<<15;o_.vl(b.f,D,hc,true);}break;case 21:ac=o_.Yn(b,i);for(Db=0;Db<ac;Db++){n=o_.Yn(b,i);o_.gl(b.f,n,o_.Yn(b,2)<<4);}break;case 22:ac=o_.Yn(b,i);for(Eb=0;Eb<ac;Eb++){n=o_.Yn(b,i);o_.fl(b.f,n,U0,true);}break;case 23:ac=o_.Yn(b,B);for(Gb=0;Gb<ac;Gb++){D=o_.Yn(b,B);o_.vl(b.f,D,b1,true);}break;case 24:ac=o_.Yn(b,B);for(Hb=0;Hb<ac;Hb++){D=o_.Yn(b,B);l=o_.Yn(b,2)<<19;o_.vl(b.f,D,l,true);}break;case 25:for(Ib=0;Ib<j;Ib++)o_.Yn(b,1)==1&&o_.hl(b.f,Ib,true);break;case 26:ac=o_.Yn(b,B);m=OI(h_.hK,k0,5,ac,15,1);for(Jb=0;Jb<ac;Jb++)m[Jb]=o_.Yn(b,B);break;case 27:ac=o_.Yn(b,i);for(Kb=0;Kb<ac;Kb++){n=o_.Yn(b,i);o_.fl(b.f,n,D0,true);}break;case 28:ac=o_.Yn(b,B);for(Lb=0;Lb<ac;Lb++)o_.wl(b.f,o_.Yn(b,B),32);break;case 29:ac=o_.Yn(b,i);for(hb=0;hb<ac;hb++){n=o_.Yn(b,i);eb=o_.Yn(b,2)<<30;o_.fl(b.f,n,eb,true);}}}o_.$d(new o_.ie(b.f),Tb,false);if(m!=null)for(F=m,G=0,H=F.length;G<H;++G){D=F[G];o_.wl(b.f,D,o_.Yj(b.f,D)==2?4:2);}if(e==null&&!b.g&&d.length>b.d+1&&(d[b.d+1]==32||d[b.d+1]==9)){e=d;f=b.d+2;}if(e!=null){try{if(e[f]==33||e[f]==35){o_.Zn(b,e,f+1);Q=o_.Yn(b,1)==1;R=o_.Yn(b,1)==1;gc=2*o_.Yn(b,4);C=1<<gc;cb=0;D=0;for(p=1;p<j;p++){if(D<k&&o_.Nj(b.f,1,D)==p){cb=o_.Nj(b.f,0,D++);bb=1;}else {cb=0;bb=8;}o_.jl(b.f,p,o_.Fj(b.f,cb)+bb*(o_.Yn(b,gc)-(C/2|0)));o_.kl(b.f,p,o_.Gj(b.f,cb)+bb*(o_.Yn(b,gc)-(C/2|0)));Q&&o_.ll(b.f,p,o_.Hj(b.f,cb)+bb*(o_.Yn(b,gc)-(C/2|0)));}if(e[f]==35){gb=0;db=OI(h_.hK,k0,5,j,15,1);for(q=0;q<j;q++)gb+=db[q]=o_.Nm(b.f,q);for(n=0;n<j;n++){for(hb=0;hb<db[n];hb++){fb=o_.Ni(b.f,1);o_.Pi(b.f,n,fb,1);o_.jl(b.f,fb,o_.Fj(b.f,n)+(o_.Yn(b,gc)-(C/2|0)));o_.kl(b.f,fb,o_.Gj(b.f,n)+(o_.Yn(b,gc)-(C/2|0)));Q&&o_.ll(b.f,fb,o_.Hj(b.f,n)+(o_.Yn(b,gc)-(C/2|0)));}}j+=gb;k+=gb;}v=Q?1.5:(o_.Li(),o_.Li(),o_.Ki);u=o_.Kj(b.f,j,k,v);if(R){jc=o_.Xn(o_.Yn(b,gc),C);mc=jc*o_.$n(o_.Yn(b,gc),C);oc=jc*o_.$n(o_.Yn(b,gc),C);Q&&(qc=jc*o_.$n(o_.Yn(b,gc),C));bb=jc/u;for(n=0;n<j;n++){o_.jl(b.f,n,mc+bb*o_.Fj(b.f,n));o_.kl(b.f,n,oc+bb*o_.Gj(b.f,n));Q&&o_.ll(b.f,n,qc+bb*o_.Hj(b.f,n));}}else {jc=1.5;bb=jc/u;for(n=0;n<j;n++){o_.jl(b.f,n,bb*o_.Fj(b.f,n));o_.kl(b.f,n,bb*o_.Gj(b.f,n));Q&&o_.ll(b.f,n,bb*o_.Hj(b.f,n));}}}else {Q&&!R&&jc==0&&(jc=1.5);if(jc!=0&&b.f.p!=0){u=0;for(D=0;D<b.f.p;D++){X=o_.Fj(b.f,o_.Nj(b.f,0,D))-o_.Fj(b.f,o_.Nj(b.f,1,D));Y=o_.Gj(b.f,o_.Nj(b.f,0,D))-o_.Gj(b.f,o_.Nj(b.f,1,D));Z=Q?o_.Hj(b.f,o_.Nj(b.f,0,D))-o_.Hj(b.f,o_.Nj(b.f,1,D)):0;u+=$wnd.Math.sqrt(X*X+Y*Y+Z*Z);}u/=b.f.p;ab=jc/u;for(n=0;n<b.f.o;n++){o_.jl(b.f,n,o_.Fj(b.f,n)*ab+mc);o_.kl(b.f,n,o_.Gj(b.f,n)*ab+oc);Q&&o_.ll(b.f,n,o_.Hj(b.f,n)*ab+qc);}}}}catch(a){a=HN(a);if(VJ(a,13)){$=a;i_.mG($,(i_.oS(),i_.nS),'');'Faulty id-coordinates:'+i_.qG($,$.Cb())+' '+i_.XR(n_.D$(d,0,(Xb=d.length,n_.A$(),Xb)))+' '+i_.XR(n_.D$(e,0,(Wb=e.length,Wb)));e=null;Q=false;}else throw IN(a);}}P=e!=null&&!Q;if(P||b.rb()){o_.Jr(b.f,7);for(D=0;D<b.f.e;D++)o_.Vj(b.f,D)==2&&!o_.An(b.f,D)&&o_.Wj(b.f,D)==0&&o_.ul(b.f,D);}if(!P&&b.rb()){o_.Kn(b.f,0);try{b.sb(b.f);P=true;}catch(a){a=HN(a);if(VJ(a,13)){$=a;i_.mG($,(i_.oS(),i_.nS),'');'2D-coordinate creation failed:'+i_.qG($,$.Cb())+' '+i_.XR(n_.D$(d,0,(Wb=d.length,n_.A$(),Wb)));}else throw IN(a);}}if(P){o_.Nn(b.f);o_.Wr(b.f);}else Q||o_.Kn(b.f,0);};o_.eo=function eo(a,b){var c,d,e,f,g,h;if(b.length<=0||b[0]<64)return;o_.Zn(a,b,0);h=o_.Yn(a,4);e=o_.Yn(a,1)==1;f=o_.Yn(a,1)==1;for(c=0;c<a.f.d;c++){g=o_.Yn(a,h);d=e;e&&f&&(d=o_.Yn(a,1)==1);o_.bl(a.f,c,g,d);}};o_.fo=function fo(){};xO(162,1,{},o_.fo);_.rb=function go(){return false;};_.sb=function ho(a){throw IN(new i_.EG('Unexpected request to invent coordinates. Check source code logic!'));};_.c=0;_.d=0;_.e=0;_.g=false;h_.EK=jQ(162);o_.io=function io(a){this.a=a;};xO(52,162,{},o_.io);_.rb=function jo(){return this.a;};_.sb=function ko(a){var b;b=new q_.pt();b.f=new l_.OX(78187493520);q_.$s(b,a);};_.a=false;h_.FK=jQ(52);o_.lo=function lo(a,b,c){var d,e,f,g,h,i,j,k,l,m;d=b.a;j=b.e;h=o_.xj(a.n,d);o_.ln(a.n,d)&&(h=n_.V$(h).toLowerCase());b.d&&(c.a+='(',c);j!=-1&&o_.po(a,b,c);e=o_.rj(a.n,d);g=o_.Bj(a.n,d);i=a.j?o_.Aj(a.n,d):0;m=!o_.Co(o_.Ij(a.n,d))||(o_.Cj(a.n,d)==1||o_.Cj(a.n,d)==2)&&(l=o_.wj(a.n,d)-1,!(l!=-1&&a.k[l][o_.vj(a.n,d)]<=1))&&(o_.Ij(a.n,d)!=7||o_.rj(a.n,d)>0)||e!=0||g!=0||i!=0||o_.pj(a.n,d)!=-1||o_.ln(a.n,d)&&o_.qm(a.n,d)==0&&o_.Nm(a.n,d)!=0;m&&(c.a+='[',c);g!=0&&(c.a+=g,c);c.a+=''+h;(o_.Cj(a.n,d)==1||o_.Cj(a.n,d)==2)&&(k=o_.wj(a.n,d)-1,!(k!=-1&&a.k[k][o_.vj(a.n,d)]<=1))&&(o_.Ij(a.n,d)!=7||o_.rj(a.n,d)>0)&&i_.gS(c,o_.wo(a,d,j));if(m){f=o_.Nm(a.n,d);if(f!=0){c.a+='H';f>1&&(c.a+=f,c);}}if(e!=0){c.a+=String.fromCharCode(e>0?43:45);$wnd.Math.abs(e)>1&&i_.eS(c,$wnd.Math.abs(e));}if(i!=0){c.a+=':';c.a+=i;}m&&(c.a+=']',c);o_.qo(a,b,c);b.c&&(c.a+=')',c);};o_.mo=function mo(a,b,c){var d,e,f,g;e=true;g=l_.Th(a.i,b).a;f=o_.zo(a,g);while(f!=-1){d=o_.zm(a.n,g,f);o_.Bm(a.n,g,f);f=o_.zo(a,d);o_.no(a,new o_.jr(d,g,c&&e,c&&f==-1),++b);g=d;e=false;}};o_.no=function no(a,b,c){l_.Nh(a.i,c,b);a.b[b.a]=true;b.e!=-1&&(a.c[o_.xm(a.n,b.a,b.e)]=true);};o_.oo=function oo(a,b,c){var d;if(!o_.mn(a.n,b)){d=o_.Yj(a.n,b)&103;d==1?o_.ln(a.n,o_.Nj(a.n,0,b))&&o_.ln(a.n,o_.Nj(a.n,1,b))&&(c.a+='-',c):d==2?(c.a+='=',c):d==4&&(c.a+='#',c);}};o_.po=function po(a,b,c){if(b.b!=0){i_.cS(c,b.b==1?47:92);return;}o_.oo(a,o_.xm(a.n,b.a,b.e),c);};o_.qo=function qo(a,b,c){var d,e,f,g,h,i;e=0;for(h=0;h<o_.Am(a.n,b.a);h++){d=o_.Bm(a.n,b.a,h);if(a.f[d]!=0){i=a.g[d]?0:y1;a.e[e++]=i|a.f[d]<<20|d;}}if(e!=0){l_.cX(a.e,e);for(g=0;g<e;g++){d=a.e[g]&262143;f=(a.e[g]&1073479680)>>20;if(!a.g[d]){a.g[d]=true;o_.oo(a,d,c);}f>9&&(c.a+='%',c);c.a+=f;}}};o_.ro=function ro(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p;for(h=new l_.KW(a.i);h.a<h.c.a.length;){g=l_.JW(h);if(g.e!=-1){b=o_.xm(a.n,g.a,g.e);if(!o_.nn(a.n,b)&&!o_.An(a.n,b)&&(o_.Wj(a.n,b)==1||o_.Wj(a.n,b)==2)){p=l_.Th(a.i,a.r[g.e]);k=p.b;k==0&&(k=p.b=1);j=k;if(o_.Am(a.n,p.a)==3){for(n=0;n<o_.Am(a.n,p.a);n++){f=o_.zm(a.n,p.a,n);if(f!=p.e&&f!=g.a){c=l_.Th(a.i,a.r[f]);c.e==p.a&&(c.b=k);f<p.e&&(j=3-j);break;}}}o_.Wj(a.n,b)==2&&(j=3-j);for(m=0;m<o_.Am(a.n,g.a);m++){d=o_.zm(a.n,g.a,m);if(d!=g.e){l=j;if(o_.Am(a.n,g.a)==3){for(o=0;o<o_.Am(a.n,g.a);o++){f=o_.zm(a.n,g.a,o);if(f!=g.e&&f!=d){f<d&&(l=3-l);break;}}}if(o_.sk(a.n,b)){i=o_.qf(a.d,b);if(!a.o[i]){a.o[i]=true;a.p[i]=l==2;}a.p[i]&&(l=3-l);}e=l_.Th(a.i,a.r[d]);e.e==g.a&&(e.b=l);}}}}}};o_.so=function so(a){var b,c,d,e,f,g,h;if(!a.n||a.n.o==0)return '';o_.Jr(a.n,15);a.d=new o_.Lf(a.n,129);c=a.d.P;a.p=OI(h_.DN,C0,5,c+1,16,1);a.o=OI(h_.DN,C0,5,c+1,16,1);a.k=MI(h_.hK,[d1,k0],[6,5],15,[2,32],2);for(b=0;b<a.n.d;b++){h=o_.wj(a.n,b)-1;h!=-1&&++a.k[h][o_.vj(a.n,b)];}o_.vo(a);o_.to(a);o_.ro(a);e=new i_.jS();d=true;for(g=new l_.KW(a.i);g.a<g.c.a.length;){f=l_.JW(g);f.e==-1&&(d?d=false:(e.a+='.',e));o_.lo(a,f,e);}return e.a;};o_.to=function to(a){var b,c,d,e,f,g,h,i;e=OI(h_.DN,C0,5,a.n.e,16,1);a.f=OI(h_.hK,k0,5,a.n.e,15,1);for(i=new l_.KW(a.i);i.a<i.c.a.length;){h=l_.JW(i);for(f=0;f<o_.Am(a.n,h.a);f++){b=o_.Bm(a.n,h.a,f);e[a.f[b]]=false;}g=o_.Ao(a,h.a);while(g!=-1){c=o_.Bm(a.n,h.a,g);a.c[c]=true;d=1;while(e[d])++d;a.f[c]=d;e[d]=true;g=o_.Ao(a,h.a);}}a.g=OI(h_.DN,C0,5,a.n.e,16,1);a.e=OI(h_.hK,k0,5,8,15,1);};o_.uo=function uo(a){var b,c,d,e;d=-1;e=P_;for(b=0;b<a.n.d;b++){if(!a.b[b]){c=((o_.Am(a.n,b)==0?127:o_.Am(a.n,b))<<24)+a.a[b];if(e>c){e=c;d=b;}}}return d;};o_.vo=function vo(a){var b,c,d,e,f;a.a=a.d.c;a.b=OI(h_.DN,C0,5,a.n.d,16,1);a.c=OI(h_.DN,C0,5,a.n.e,16,1);a.i=new l_.gi();b=o_.uo(a);while(b!=-1){c=a.i.a.length;o_.no(a,new o_.jr(b,-1,false,false),c);if(o_.Am(a.n,b)!=0){o_.mo(a,c,false);while(c<a.i.a.length-1){while(o_.Bo(a,l_.Th(a.i,c).a))o_.mo(a,c,true);++c;}}b=o_.uo(a);}a.r=OI(h_.hK,k0,5,a.n.d,15,1);d=0;for(f=new l_.KW(a.i);f.a<f.c.a.length;){e=l_.JW(f);a.r[e.a]=d++;}};o_.wo=function wo(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;i=false;if(o_.qm(a.n,b)!=0&&o_.Am(a.n,b)==2&&o_.Cm(a.n,b,0)==2&&o_.Cm(a.n,b,1)==2){for(f=0;f<o_.Am(a.n,b);f++){d=o_.zm(a.n,b,f);o=0;n=OI(h_.hK,k0,5,3,15,1);for(k=0;k<o_.Am(a.n,d);k++){n[o]=o_.zm(a.n,d,k);n[o]!=b&&++o;}o==2&&a.r[n[0]]<a.r[n[1]]^n[0]<n[1]&&(i=!i);}}else {l=OI(h_.hK,k0,5,3,15,1);m=OI(h_.hK,k0,5,3,15,1);h=0;for(g=0;g<o_.Am(a.n,b);g++){d=o_.zm(a.n,b,g);if(d!=c){l[h]=d;m[h++]=o_.yo(a,b,g);}}if(h==2){o_.Nm(a.n,b)==0?l[h]=b:l[h]=P_;m[h++]=8*a.r[b];}m[0]>m[1]&&(i=!i);m[0]>m[2]&&(i=!i);m[1]>m[2]&&(i=!i);l[0]>l[1]&&(i=!i);l[0]>l[2]&&(i=!i);l[1]>l[2]&&(i=!i);for(f=0;f<3;f++)c>l[f]&&(i=!i);}j=o_.Cj(a.n,b)==1^i;if(o_.lk(a.n,b)){e=o_.rf(a.d,b);if(!a.o[e]){a.o[e]=true;a.p[e]=j;}a.p[e]&&(j=!j);}return j?'@@':'@';};o_.xo=function xo(a){a.q==null&&(a.q=o_.so(a));return a.q;};o_.yo=function yo(a,b,c){var d,e,f;d=o_.Bm(a.n,b,c);if(a.f[d]!=0){f=8*a.r[b]+1;for(e=0;e<c;e++)a.f[o_.zm(a.n,b,e)]!=0&&++f;return f;}return 8*a.r[o_.zm(a.n,b,c)];};o_.zo=function zo(a,b){var c,d,e,f,g;c=-1;d=-1;for(f=0;f<o_.Am(a.n,b);f++){e=o_.zm(a.n,b,f);g=(o_.Cm(a.n,b,f)<<24)+a.a[e];if(!a.b[e]&&(c==-1||d<g)){c=f;d=g;}}return c;};o_.Ao=function Ao(a,b){var c,d;c=-1;for(d=0;d<o_.Am(a.n,b);d++)!a.c[o_.Bm(a.n,b,d)]&&(c==-1||a.a[o_.zm(a.n,b,c)]<a.a[o_.zm(a.n,b,d)])&&(c=d);return c;};o_.Bo=function Bo(a,b){var c;for(c=0;c<o_.Am(a.n,b);c++)if(!a.b[o_.zm(a.n,b,c)])return true;return false;};o_.Co=function Co(a){return a>=5&&a<=9||a>=15&&a<=17||a==35||a==53;};o_.Do=function Do(a){o_.Eo.call(this,a,false);};o_.Eo=function Eo(a,b){this.n=a;this.j=b;};o_.Fo=function Fo(a){var b,c,d,e;e=new i_.jS();for(c=0;c<a.g.a.length;c++){c!=0&&(e.a+='.',e);i_.gS(e,o_.xo(new o_.Eo(l_.Th(a.g,c),true)));}e.a+='>';for(d=0;d<a.a.a.length;d++){d!=0&&(e.a+='.',e);i_.gS(e,o_.xo(new o_.Do(l_.Th(a.a,d))));}e.a+='>';for(b=0;b<a.f.a.length;b++){b!=0&&(e.a+='.',e);i_.gS(e,o_.xo(new o_.Eo(l_.Th(a.f,b),true)));}return e.a;};xO(69,1,{},o_.Do,o_.Eo);_.j=false;h_.GK=jQ(69);o_.Go=function Go(a,b){this.b=a;this.a=b;};xO(3,1,{3:1},o_.Go);_.a=0;_.b=0;h_.HK=jQ(3);o_.Io=function Io(){o_.Io=zO;o_.Ho=XI(II(h_.HK,2),K_,9,0,[null,XI(II(h_.HK,1),z1,3,0,[new o_.Go(0,1.007825032),new o_.Go(1,2.014101778),new o_.Go(2,3.016049268),new o_.Go(3,4.027834627),new o_.Go(4,5.039542911),new o_.Go(5,6.044942608)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(1,3.01602931),new o_.Go(2,4.00260325),new o_.Go(3,5.012223628),new o_.Go(4,6.018888072),new o_.Go(5,7.028030527),new o_.Go(6,8.033921838),new o_.Go(7,9.043820323),new o_.Go(8,10.052399713)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(1,4.027182329),new o_.Go(2,5.012537796),new o_.Go(3,6.015122281),new o_.Go(4,7.016004049),new o_.Go(5,8.02248667),new o_.Go(6,9.026789122),new o_.Go(7,10.035480884),new o_.Go(8,11.043796166),new o_.Go(9,12.05378)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(1,5.04079),new o_.Go(2,6.019725804),new o_.Go(3,7.016929246),new o_.Go(4,8.005305094),new o_.Go(5,9.012182135),new o_.Go(6,10.01353372),new o_.Go(7,11.021657653),new o_.Go(8,12.026920631),new o_.Go(9,13.036133834),new o_.Go(10,14.042815522)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(2,7.029917389),new o_.Go(3,8.024606713),new o_.Go(4,9.013328806),new o_.Go(5,10.012937027),new o_.Go(6,11.009305466),new o_.Go(7,12.014352109),new o_.Go(8,13.017780267),new o_.Go(9,14.025404064),new o_.Go(10,15.031097291),new o_.Go(11,16.039808836),new o_.Go(12,17.046931399),new o_.Go(13,18.05617),new o_.Go(14,19.06373)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(2,8.037675026),new o_.Go(3,9.031040087),new o_.Go(4,10.01685311),new o_.Go(5,11.011433818),new o_.Go(6,12),new o_.Go(7,13.003354838),new o_.Go(8,14.003241988),new o_.Go(9,15.010599258),new o_.Go(10,16.014701243),new o_.Go(11,17.022583712),new o_.Go(12,18.026757058),new o_.Go(13,19.035248094),new o_.Go(14,20.040322395),new o_.Go(15,21.04934),new o_.Go(16,22.05645)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(3,10.042618),new o_.Go(4,11.026796226),new o_.Go(5,12.018613202),new o_.Go(6,13.005738584),new o_.Go(7,14.003074005),new o_.Go(8,15.000108898),new o_.Go(9,16.006101417),new o_.Go(10,17.008449673),new o_.Go(11,18.014081827),new o_.Go(12,19.017026896),new o_.Go(13,20.023367295),new o_.Go(14,21.027087574),new o_.Go(15,22.034440259),new o_.Go(16,23.04051),new o_.Go(17,24.0505)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(4,12.034404776),new o_.Go(5,13.0248104),new o_.Go(6,14.008595285),new o_.Go(7,15.003065386),new o_.Go(8,15.994914622),new o_.Go(9,16.999131501),new o_.Go(10,17.999160419),new o_.Go(11,19.00357873),new o_.Go(12,20.00407615),new o_.Go(13,21.008654631),new o_.Go(14,22.009967157),new o_.Go(15,23.015691325),new o_.Go(16,24.020369922),new o_.Go(17,25.02914),new o_.Go(18,26.03775)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(5,14.03608),new o_.Go(6,15.018010856),new o_.Go(7,16.01146573),new o_.Go(8,17.002095238),new o_.Go(9,18.000937667),new o_.Go(10,18.998403205),new o_.Go(11,19.999981324),new o_.Go(12,20.999948921),new o_.Go(13,22.00299925),new o_.Go(14,23.003574385),new o_.Go(15,24.008099371),new o_.Go(16,25.012094963),new o_.Go(17,26.019633157),new o_.Go(18,27.026892316),new o_.Go(19,28.03567),new o_.Go(20,29.04326)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(6,16.025756907),new o_.Go(7,17.017697565),new o_.Go(8,18.005697066),new o_.Go(9,19.001879839),new o_.Go(10,19.992440176),new o_.Go(11,20.993846744),new o_.Go(12,21.99138551),new o_.Go(13,22.994467337),new o_.Go(14,23.993615074),new o_.Go(15,24.997789899),new o_.Go(16,26.000461498),new o_.Go(17,27.0076152),new o_.Go(18,28.012108072),new o_.Go(19,29.019345902),new o_.Go(20,30.023872),new o_.Go(21,31.03311),new o_.Go(22,32.03991)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(7,18.02718),new o_.Go(8,19.01387945),new o_.Go(9,20.00734826),new o_.Go(10,20.997655099),new o_.Go(11,21.994436782),new o_.Go(12,22.989769675),new o_.Go(13,23.990963332),new o_.Go(14,24.989954352),new o_.Go(15,25.992589898),new o_.Go(16,26.994008702),new o_.Go(17,27.99889041),new o_.Go(18,29.002811301),new o_.Go(19,30.009226487),new o_.Go(20,31.013595108),new o_.Go(21,32.019649792),new o_.Go(22,33.027386),new o_.Go(23,34.0349),new o_.Go(24,35.04418)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(8,20.018862744),new o_.Go(9,21.011714174),new o_.Go(10,21.999574055),new o_.Go(11,22.99412485),new o_.Go(12,23.985041898),new o_.Go(13,24.985837023),new o_.Go(14,25.98259304),new o_.Go(15,26.984340742),new o_.Go(16,27.983876703),new o_.Go(17,28.988554743),new o_.Go(18,29.990464529),new o_.Go(19,30.996548459),new o_.Go(20,31.999145889),new o_.Go(21,33.005586975),new o_.Go(22,34.00907244),new o_.Go(23,35.018669),new o_.Go(24,36.02245),new o_.Go(25,37.03124)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(8,21.02804),new o_.Go(9,22.01952),new o_.Go(10,23.0072649),new o_.Go(11,23.999940911),new o_.Go(12,24.990428555),new o_.Go(13,25.986891659),new o_.Go(14,26.981538441),new o_.Go(15,27.981910184),new o_.Go(16,28.980444848),new o_.Go(17,29.982960304),new o_.Go(18,30.983946023),new o_.Go(19,31.988124379),new o_.Go(20,32.990869587),new o_.Go(21,33.996927255),new o_.Go(22,34.99993765),new o_.Go(23,36.006351501),new o_.Go(24,37.01031),new o_.Go(25,38.0169),new o_.Go(26,39.0219)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(8,22.03453),new o_.Go(9,23.02552),new o_.Go(10,24.011545711),new o_.Go(11,25.00410664),new o_.Go(12,25.992329935),new o_.Go(13,26.986704764),new o_.Go(14,27.976926533),new o_.Go(15,28.976494719),new o_.Go(16,29.973770218),new o_.Go(17,30.975363275),new o_.Go(18,31.974148129),new o_.Go(19,32.97800052),new o_.Go(20,33.978575745),new o_.Go(21,34.984584158),new o_.Go(22,35.986687363),new o_.Go(23,36.99299599),new o_.Go(24,37.99598),new o_.Go(25,39.0023),new o_.Go(26,40.0058),new o_.Go(27,41.0127),new o_.Go(28,42.0161)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(9,24.03435),new o_.Go(10,25.02026),new o_.Go(11,26.01178),new o_.Go(12,26.999191645),new o_.Go(13,27.99231233),new o_.Go(14,28.981801376),new o_.Go(15,29.978313807),new o_.Go(16,30.973761512),new o_.Go(17,31.973907163),new o_.Go(18,32.971725281),new o_.Go(19,33.973636381),new o_.Go(20,34.973314249),new o_.Go(21,35.978259824),new o_.Go(22,36.979608338),new o_.Go(23,37.98447),new o_.Go(24,38.98642),new o_.Go(25,39.99105),new o_.Go(26,40.9948),new o_.Go(27,42.00009),new o_.Go(28,43.00331),new o_.Go(29,44.00988),new o_.Go(30,45.01514),new o_.Go(31,46.02383)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(10,26.02788),new o_.Go(11,27.018795),new o_.Go(12,28.004372661),new o_.Go(13,28.996608805),new o_.Go(14,29.984902954),new o_.Go(15,30.979554421),new o_.Go(16,31.97207069),new o_.Go(17,32.971458497),new o_.Go(18,33.967866831),new o_.Go(19,34.96903214),new o_.Go(20,35.96708088),new o_.Go(21,36.971125716),new o_.Go(22,37.971163443),new o_.Go(23,38.975135275),new o_.Go(24,39.97547),new o_.Go(25,40.98003),new o_.Go(26,41.98149),new o_.Go(27,42.9866),new o_.Go(28,43.98832),new o_.Go(29,44.99482),new o_.Go(30,45.99957),new o_.Go(31,47.00762),new o_.Go(32,48.01299),new o_.Go(33,49.02201)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(11,28.02851),new o_.Go(12,29.01411),new o_.Go(13,30.00477),new o_.Go(14,30.992416014),new o_.Go(15,31.985688908),new o_.Go(16,32.977451798),new o_.Go(17,33.973761967),new o_.Go(18,34.968852707),new o_.Go(19,35.968306945),new o_.Go(20,36.9659026),new o_.Go(21,37.96801055),new o_.Go(22,38.968007677),new o_.Go(23,39.970415555),new o_.Go(24,40.970650212),new o_.Go(25,41.973174994),new o_.Go(26,42.974203385),new o_.Go(27,43.978538712),new o_.Go(28,44.9797),new o_.Go(29,45.98412),new o_.Go(30,46.98795),new o_.Go(31,47.99485),new o_.Go(32,48.99989),new o_.Go(33,50.00773),new o_.Go(34,51.01353)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(12,30.02156),new o_.Go(13,31.012126),new o_.Go(14,31.99766066),new o_.Go(15,32.989928719),new o_.Go(16,33.980270118),new o_.Go(17,34.975256726),new o_.Go(18,35.967546282),new o_.Go(19,36.966775912),new o_.Go(20,37.962732161),new o_.Go(21,38.964313413),new o_.Go(22,39.962383123),new o_.Go(23,40.964500828),new o_.Go(24,41.963046386),new o_.Go(25,42.965670701),new o_.Go(26,43.965365269),new o_.Go(27,44.968094979),new o_.Go(28,45.968093467),new o_.Go(29,46.972186238),new o_.Go(30,47.97507),new o_.Go(31,48.98218),new o_.Go(32,49.98594),new o_.Go(33,50.99324),new o_.Go(34,51.99817),new o_.Go(35,53.006227)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(13,32.02192),new o_.Go(14,33.00726),new o_.Go(15,33.99841),new o_.Go(16,34.988011615),new o_.Go(17,35.981293405),new o_.Go(18,36.973376915),new o_.Go(19,37.969080107),new o_.Go(20,38.963706861),new o_.Go(21,39.963998672),new o_.Go(22,40.961825972),new o_.Go(23,41.962403059),new o_.Go(24,42.960715746),new o_.Go(25,43.961556146),new o_.Go(26,44.960699658),new o_.Go(27,45.961976203),new o_.Go(28,46.961677807),new o_.Go(29,47.965512946),new o_.Go(30,48.967450084),new o_.Go(31,49.972782832),new o_.Go(32,50.97638),new o_.Go(33,51.98261),new o_.Go(34,52.98712),new o_.Go(35,53.99399),new o_.Go(36,54.999388)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(14,34.01412),new o_.Go(15,35.004765),new o_.Go(16,35.993087234),new o_.Go(17,36.985871505),new o_.Go(18,37.976318637),new o_.Go(19,38.970717729),new o_.Go(20,39.962591155),new o_.Go(21,40.962278349),new o_.Go(22,41.958618337),new o_.Go(23,42.958766833),new o_.Go(24,43.955481094),new o_.Go(25,44.956185938),new o_.Go(26,45.953692759),new o_.Go(27,46.954546459),new o_.Go(28,47.952533512),new o_.Go(29,48.955673302),new o_.Go(30,49.957518286),new o_.Go(31,50.961474238),new o_.Go(32,51.9651),new o_.Go(33,52.97005),new o_.Go(34,53.97468),new o_.Go(35,54.98055),new o_.Go(36,55.98579),new o_.Go(37,56.992356)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(15,36.01492),new o_.Go(16,37.00305),new o_.Go(17,37.9947),new o_.Go(18,38.984790009),new o_.Go(19,39.977964014),new o_.Go(20,40.969251316),new o_.Go(21,41.965516761),new o_.Go(22,42.96115098),new o_.Go(23,43.959403048),new o_.Go(24,44.955910243),new o_.Go(25,45.95517025),new o_.Go(26,46.952408027),new o_.Go(27,47.952234991),new o_.Go(28,48.950024065),new o_.Go(29,49.952187008),new o_.Go(30,50.9536027),new o_.Go(31,51.95665),new o_.Go(32,52.95817),new o_.Go(33,53.963),new o_.Go(34,54.9694),new o_.Go(35,55.97266),new o_.Go(36,56.97704),new o_.Go(37,57.98307),new o_.Go(38,58.988041)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(16,38.00977),new o_.Go(17,39.001323),new o_.Go(18,39.990498907),new o_.Go(19,40.983131),new o_.Go(20,41.973031622),new o_.Go(21,42.968523342),new o_.Go(22,43.959690235),new o_.Go(23,44.958124349),new o_.Go(24,45.952629491),new o_.Go(25,46.951763792),new o_.Go(26,47.947947053),new o_.Go(27,48.947870789),new o_.Go(28,49.944792069),new o_.Go(29,50.946616017),new o_.Go(30,51.946898175),new o_.Go(31,52.949731709),new o_.Go(32,53.95087),new o_.Go(33,54.95512),new o_.Go(34,55.95799),new o_.Go(35,56.9643),new o_.Go(36,57.96611),new o_.Go(37,58.97196),new o_.Go(38,59.97564),new o_.Go(39,60.982018)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(17,40.01109),new o_.Go(18,40.99974),new o_.Go(19,41.99123),new o_.Go(20,42.98065),new o_.Go(21,43.9744),new o_.Go(22,44.965782286),new o_.Go(23,45.960199491),new o_.Go(24,46.954906918),new o_.Go(25,47.95225448),new o_.Go(26,48.948516914),new o_.Go(27,49.947162792),new o_.Go(28,50.943963675),new o_.Go(29,51.944779658),new o_.Go(30,52.944342517),new o_.Go(31,53.946444381),new o_.Go(32,54.947238194),new o_.Go(33,55.95036),new o_.Go(34,56.95236),new o_.Go(35,57.95665),new o_.Go(36,58.9593),new o_.Go(37,59.9645),new o_.Go(38,60.96741),new o_.Go(39,61.97314),new o_.Go(40,62.97675)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(18,42.00643),new o_.Go(19,42.997707),new o_.Go(20,43.98547),new o_.Go(21,44.97916),new o_.Go(22,45.968361649),new o_.Go(23,46.962906512),new o_.Go(24,47.954035861),new o_.Go(25,48.951341135),new o_.Go(26,49.946049607),new o_.Go(27,50.944771767),new o_.Go(28,51.940511904),new o_.Go(29,52.940653781),new o_.Go(30,53.938884921),new o_.Go(31,54.940844164),new o_.Go(32,55.940645238),new o_.Go(33,56.9437538),new o_.Go(34,57.94425),new o_.Go(35,58.94863),new o_.Go(36,59.94973),new o_.Go(37,60.95409),new o_.Go(38,61.9558),new o_.Go(39,62.96186),new o_.Go(40,63.9642),new o_.Go(41,64.97037)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(19,44.00687),new o_.Go(20,44.99451),new o_.Go(21,45.98672),new o_.Go(22,46.9761),new o_.Go(23,47.96887),new o_.Go(24,48.959623415),new o_.Go(25,49.95424396),new o_.Go(26,50.948215487),new o_.Go(27,51.945570079),new o_.Go(28,52.941294702),new o_.Go(29,53.940363247),new o_.Go(30,54.938049636),new o_.Go(31,55.938909366),new o_.Go(32,56.938287458),new o_.Go(33,57.939986451),new o_.Go(34,58.940447166),new o_.Go(35,59.943193998),new o_.Go(36,60.94446),new o_.Go(37,61.94797),new o_.Go(38,62.94981),new o_.Go(39,63.95373),new o_.Go(40,64.9561),new o_.Go(41,65.96082),new o_.Go(42,66.96382)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(19,45.01456),new o_.Go(20,46.00081),new o_.Go(21,46.99289),new o_.Go(22,47.98056),new o_.Go(23,48.97361),new o_.Go(24,49.962993316),new o_.Go(25,50.956824936),new o_.Go(26,51.948116526),new o_.Go(27,52.945312282),new o_.Go(28,53.939614836),new o_.Go(29,54.938298029),new o_.Go(30,55.934942133),new o_.Go(31,56.935398707),new o_.Go(32,57.933280458),new o_.Go(33,58.934880493),new o_.Go(34,59.934076943),new o_.Go(35,60.936749461),new o_.Go(36,61.936770495),new o_.Go(37,62.940118442),new o_.Go(38,63.94087),new o_.Go(39,64.94494),new o_.Go(40,65.94598),new o_.Go(41,66.95),new o_.Go(42,67.95251),new o_.Go(43,68.9577)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(21,48.00176),new o_.Go(22,48.98972),new o_.Go(23,49.98154),new o_.Go(24,50.97072),new o_.Go(25,51.96359),new o_.Go(26,52.954224985),new o_.Go(27,53.948464147),new o_.Go(28,54.942003149),new o_.Go(29,55.939843937),new o_.Go(30,56.936296235),new o_.Go(31,57.935757571),new o_.Go(32,58.933200194),new o_.Go(33,59.933822196),new o_.Go(34,60.932479381),new o_.Go(35,61.934054212),new o_.Go(36,62.933615218),new o_.Go(37,63.935813523),new o_.Go(38,64.936484581),new o_.Go(39,65.939825412),new o_.Go(40,66.94061),new o_.Go(41,67.94436),new o_.Go(42,68.9452),new o_.Go(43,69.94981),new o_.Go(44,70.95173),new o_.Go(45,71.95641)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(22,49.99593),new o_.Go(23,50.98772),new o_.Go(24,51.97568),new o_.Go(25,52.96846),new o_.Go(26,53.957910508),new o_.Go(27,54.951336329),new o_.Go(28,55.942136339),new o_.Go(29,56.939800489),new o_.Go(30,57.935347922),new o_.Go(31,58.934351553),new o_.Go(32,59.930790633),new o_.Go(33,60.931060442),new o_.Go(34,61.928348763),new o_.Go(35,62.929672948),new o_.Go(36,63.927969574),new o_.Go(37,64.930088013),new o_.Go(38,65.929115232),new o_.Go(39,66.931569638),new o_.Go(40,67.931844932),new o_.Go(41,68.935181837),new o_.Go(42,69.93614),new o_.Go(43,70.94),new o_.Go(44,71.9413),new o_.Go(45,72.94608),new o_.Go(46,73.94791),new o_.Go(47,74.95297),new o_.Go(48,75.95533),new o_.Go(49,76.96083),new o_.Go(50,77.9638)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(23,51.99718),new o_.Go(24,52.98555),new o_.Go(25,53.97671),new o_.Go(26,54.96605),new o_.Go(27,55.95856),new o_.Go(28,56.949215695),new o_.Go(29,57.944540734),new o_.Go(30,58.939504114),new o_.Go(31,59.937368123),new o_.Go(32,60.933462181),new o_.Go(33,61.932587299),new o_.Go(34,62.929601079),new o_.Go(35,63.929767865),new o_.Go(36,64.927793707),new o_.Go(37,65.928873041),new o_.Go(38,66.927750294),new o_.Go(39,67.929637875),new o_.Go(40,68.929425281),new o_.Go(41,69.932409287),new o_.Go(42,70.932619818),new o_.Go(43,71.93552),new o_.Go(44,72.93649),new o_.Go(45,73.9402),new o_.Go(46,74.9417),new o_.Go(47,75.94599),new o_.Go(48,76.94795),new o_.Go(49,77.95281),new o_.Go(50,78.95528),new o_.Go(51,79.96189)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(24,53.99295),new o_.Go(25,54.98398),new o_.Go(26,55.97238),new o_.Go(27,56.96491),new o_.Go(28,57.954596465),new o_.Go(29,58.949267074),new o_.Go(30,59.941832031),new o_.Go(31,60.939513907),new o_.Go(32,61.934334132),new o_.Go(33,62.933215563),new o_.Go(34,63.929146578),new o_.Go(35,64.929245079),new o_.Go(36,65.926036763),new o_.Go(37,66.927130859),new o_.Go(38,67.924847566),new o_.Go(39,68.926553538),new o_.Go(40,69.92532487),new o_.Go(41,70.927727195),new o_.Go(42,71.926861122),new o_.Go(43,72.929779469),new o_.Go(44,73.929458261),new o_.Go(45,74.932937379),new o_.Go(46,75.933394207),new o_.Go(47,76.937085857),new o_.Go(48,77.938569576),new o_.Go(49,78.942095175),new o_.Go(50,79.944414722),new o_.Go(51,80.95048),new o_.Go(52,81.95484)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(25,55.99491),new o_.Go(26,56.98293),new o_.Go(27,57.97425),new o_.Go(28,58.96337),new o_.Go(29,59.95706),new o_.Go(30,60.94917),new o_.Go(31,61.944179608),new o_.Go(32,62.939141527),new o_.Go(33,63.936838307),new o_.Go(34,64.932739322),new o_.Go(35,65.931592355),new o_.Go(36,66.928204915),new o_.Go(37,67.927983497),new o_.Go(38,68.925580912),new o_.Go(39,69.926027741),new o_.Go(40,70.92470501),new o_.Go(41,71.92636935),new o_.Go(42,72.925169832),new o_.Go(43,73.926940999),new o_.Go(44,74.926500645),new o_.Go(45,75.928928262),new o_.Go(46,76.929281189),new o_.Go(47,77.93165595),new o_.Go(48,78.932916371),new o_.Go(49,79.936588154),new o_.Go(50,80.937752955),new o_.Go(51,81.94316),new o_.Go(52,82.94687),new o_.Go(53,83.95234)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(26,57.99101),new o_.Go(27,58.98175),new o_.Go(28,59.97019),new o_.Go(29,60.96379),new o_.Go(30,61.95465),new o_.Go(31,62.94964),new o_.Go(32,63.941572638),new o_.Go(33,64.939440762),new o_.Go(34,65.933846798),new o_.Go(35,66.932738415),new o_.Go(36,67.928097266),new o_.Go(37,68.927972002),new o_.Go(38,69.924250365),new o_.Go(39,70.924953991),new o_.Go(40,71.922076184),new o_.Go(41,72.923459361),new o_.Go(42,73.921178213),new o_.Go(43,74.922859494),new o_.Go(44,75.921402716),new o_.Go(45,76.923548462),new o_.Go(46,77.922852886),new o_.Go(47,78.92540156),new o_.Go(48,79.925444764),new o_.Go(49,80.928821065),new o_.Go(50,81.929550326),new o_.Go(51,82.93451),new o_.Go(52,83.93731),new o_.Go(53,84.94269),new o_.Go(54,85.94627)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(27,59.99313),new o_.Go(28,60.98062),new o_.Go(29,61.9732),new o_.Go(30,62.96369),new o_.Go(31,63.957572),new o_.Go(32,64.949484),new o_.Go(33,65.944099147),new o_.Go(34,66.939190417),new o_.Go(35,67.936792976),new o_.Go(36,68.932280154),new o_.Go(37,69.930927811),new o_.Go(38,70.927114724),new o_.Go(39,71.926752647),new o_.Go(40,72.923825288),new o_.Go(41,73.923929076),new o_.Go(42,74.921596417),new o_.Go(43,75.922393933),new o_.Go(44,76.920647703),new o_.Go(45,77.921828577),new o_.Go(46,78.920948498),new o_.Go(47,79.922578162),new o_.Go(48,80.922132884),new o_.Go(49,81.924504668),new o_.Go(50,82.924980625),new o_.Go(51,83.92906),new o_.Go(52,84.93181),new o_.Go(53,85.93623),new o_.Go(54,86.93958),new o_.Go(55,87.94456),new o_.Go(56,88.94923)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(31,64.96466),new o_.Go(32,65.95521),new o_.Go(33,66.95009),new o_.Go(34,67.94187),new o_.Go(35,68.939562155),new o_.Go(36,69.933504),new o_.Go(37,70.931868378),new o_.Go(38,71.927112313),new o_.Go(39,72.9267668),new o_.Go(40,73.922476561),new o_.Go(41,74.922523571),new o_.Go(42,75.919214107),new o_.Go(43,76.91991461),new o_.Go(44,77.917309522),new o_.Go(45,78.918499802),new o_.Go(46,79.916521828),new o_.Go(47,80.917992931),new o_.Go(48,81.9167),new o_.Go(49,82.919119072),new o_.Go(50,83.918464523),new o_.Go(51,84.922244678),new o_.Go(52,85.924271165),new o_.Go(53,86.928520749),new o_.Go(54,87.931423982),new o_.Go(55,88.93602),new o_.Go(56,89.93942),new o_.Go(57,90.94537),new o_.Go(58,91.94933)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(32,66.96479),new o_.Go(33,67.958248),new o_.Go(34,68.950178),new o_.Go(35,69.944208),new o_.Go(36,70.939246),new o_.Go(37,71.936496876),new o_.Go(38,72.931794889),new o_.Go(39,73.929891152),new o_.Go(40,74.92577641),new o_.Go(41,75.924541974),new o_.Go(42,76.921380123),new o_.Go(43,77.92114613),new o_.Go(44,78.918337647),new o_.Go(45,79.918529952),new o_.Go(46,80.91629106),new o_.Go(47,81.916804666),new o_.Go(48,82.915180219),new o_.Go(49,83.916503685),new o_.Go(50,84.915608027),new o_.Go(51,85.918797162),new o_.Go(52,86.920710713),new o_.Go(53,87.924065908),new o_.Go(54,88.92638726),new o_.Go(55,89.930634988),new o_.Go(56,90.9339653),new o_.Go(57,91.939255258),new o_.Go(58,92.9431),new o_.Go(59,93.94868)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(33,68.96532),new o_.Go(34,69.95601),new o_.Go(35,70.95051),new o_.Go(36,71.94190754),new o_.Go(37,72.938931115),new o_.Go(38,73.933258225),new o_.Go(39,74.931033794),new o_.Go(40,75.925948304),new o_.Go(41,76.92466788),new o_.Go(42,77.920386271),new o_.Go(43,78.920082992),new o_.Go(44,79.91637804),new o_.Go(45,80.916592419),new o_.Go(46,81.913484601),new o_.Go(47,82.914135952),new o_.Go(48,83.911506627),new o_.Go(49,84.912526954),new o_.Go(50,85.910610313),new o_.Go(51,86.913354251),new o_.Go(52,87.914446951),new o_.Go(53,88.917632505),new o_.Go(54,89.919523803),new o_.Go(55,90.923442418),new o_.Go(56,91.926152752),new o_.Go(57,92.931265246),new o_.Go(58,93.934362),new o_.Go(59,94.93984),new o_.Go(60,95.94307),new o_.Go(61,96.94856)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(34,70.96532),new o_.Go(35,71.95908),new o_.Go(36,72.950366),new o_.Go(37,73.944470376),new o_.Go(38,74.938569199),new o_.Go(39,75.935071448),new o_.Go(40,76.930406599),new o_.Go(41,77.928141485),new o_.Go(42,78.923996719),new o_.Go(43,79.922519322),new o_.Go(44,80.918994165),new o_.Go(45,81.918207691),new o_.Go(46,82.915111951),new o_.Go(47,83.914384676),new o_.Go(48,84.911789341),new o_.Go(49,85.91116708),new o_.Go(50,86.909183465),new o_.Go(51,87.911318556),new o_.Go(52,88.912279939),new o_.Go(53,89.914808941),new o_.Go(54,90.91653416),new o_.Go(55,91.919725442),new o_.Go(56,92.922032765),new o_.Go(57,93.926407326),new o_.Go(58,94.92931926),new o_.Go(59,95.934283962),new o_.Go(60,96.937342863),new o_.Go(61,97.941703557),new o_.Go(62,98.945420616),new o_.Go(63,99.94987),new o_.Go(64,100.953195994),new o_.Go(65,101.95921)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(35,72.96597),new o_.Go(36,73.95631),new o_.Go(37,74.94992),new o_.Go(38,75.94161),new o_.Go(39,76.937761511),new o_.Go(40,77.932179362),new o_.Go(41,78.929707076),new o_.Go(42,79.924524588),new o_.Go(43,80.923213095),new o_.Go(44,81.918401258),new o_.Go(45,82.917555029),new o_.Go(46,83.913424778),new o_.Go(47,84.912932689),new o_.Go(48,85.909262351),new o_.Go(49,86.908879316),new o_.Go(50,87.905614339),new o_.Go(51,88.907452906),new o_.Go(52,89.907737596),new o_.Go(53,90.910209845),new o_.Go(54,91.911029895),new o_.Go(55,92.91402241),new o_.Go(56,93.915359856),new o_.Go(57,94.919358213),new o_.Go(58,95.921680473),new o_.Go(59,96.926148757),new o_.Go(60,97.928471177),new o_.Go(61,98.933315038),new o_.Go(62,99.935351729),new o_.Go(63,100.940517434),new o_.Go(64,101.943018795),new o_.Go(65,102.94895),new o_.Go(66,103.95233)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(38,76.94962),new o_.Go(39,77.9435),new o_.Go(40,78.937350712),new o_.Go(41,79.931982402),new o_.Go(42,80.929128719),new o_.Go(43,81.926792071),new o_.Go(44,82.922352572),new o_.Go(45,83.920387768),new o_.Go(46,84.916427076),new o_.Go(47,85.914887724),new o_.Go(48,86.910877833),new o_.Go(49,87.909503361),new o_.Go(50,88.905847902),new o_.Go(51,89.907151443),new o_.Go(52,90.907303415),new o_.Go(53,91.908946832),new o_.Go(54,92.909581582),new o_.Go(55,93.911594008),new o_.Go(56,94.912823709),new o_.Go(57,95.915897787),new o_.Go(58,96.918131017),new o_.Go(59,97.922219525),new o_.Go(60,98.924634736),new o_.Go(61,99.927756402),new o_.Go(62,100.930313395),new o_.Go(63,101.933555501),new o_.Go(64,102.93694),new o_.Go(65,103.94145),new o_.Go(66,104.94509),new o_.Go(67,105.95022)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(39,78.94916),new o_.Go(40,79.94055),new o_.Go(41,80.936815296),new o_.Go(42,81.931086249),new o_.Go(43,82.92865213),new o_.Go(44,83.92325),new o_.Go(45,84.92146522),new o_.Go(46,85.916472851),new o_.Go(47,86.914816578),new o_.Go(48,87.910226179),new o_.Go(49,88.908888916),new o_.Go(50,89.904703679),new o_.Go(51,90.905644968),new o_.Go(52,91.905040106),new o_.Go(53,92.906475627),new o_.Go(54,93.906315765),new o_.Go(55,94.908042739),new o_.Go(56,95.908275675),new o_.Go(57,96.910950716),new o_.Go(58,97.912746366),new o_.Go(59,98.916511084),new o_.Go(60,99.917761704),new o_.Go(61,100.921139958),new o_.Go(62,101.922981089),new o_.Go(63,102.926597062),new o_.Go(64,103.92878),new o_.Go(65,104.93305),new o_.Go(66,105.93591),new o_.Go(67,106.94086),new o_.Go(68,107.94428)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(40,80.94905),new o_.Go(41,81.94313),new o_.Go(42,82.936703713),new o_.Go(43,83.93357),new o_.Go(44,84.927906486),new o_.Go(45,85.925037588),new o_.Go(46,86.920361435),new o_.Go(47,87.91833144),new o_.Go(48,88.913495503),new o_.Go(49,89.911264109),new o_.Go(50,90.906990538),new o_.Go(51,91.907193214),new o_.Go(52,92.906377543),new o_.Go(53,93.907283457),new o_.Go(54,94.906835178),new o_.Go(55,95.908100076),new o_.Go(56,96.908097144),new o_.Go(57,97.91033069),new o_.Go(58,98.911617864),new o_.Go(59,99.914181434),new o_.Go(60,100.915251567),new o_.Go(61,101.918037417),new o_.Go(62,102.919141297),new o_.Go(63,103.922459464),new o_.Go(64,104.923934023),new o_.Go(65,105.92819),new o_.Go(66,106.93031),new o_.Go(67,107.93501),new o_.Go(68,108.93763),new o_.Go(69,109.94268)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(41,82.94874),new o_.Go(42,83.94009),new o_.Go(43,84.93659),new o_.Go(44,85.930695167),new o_.Go(45,86.92732683),new o_.Go(46,87.921952728),new o_.Go(47,88.919480562),new o_.Go(48,89.913936161),new o_.Go(49,90.911750754),new o_.Go(50,91.90681048),new o_.Go(51,92.906812213),new o_.Go(52,93.905087578),new o_.Go(53,94.905841487),new o_.Go(54,95.904678904),new o_.Go(55,96.906021033),new o_.Go(56,97.905407846),new o_.Go(57,98.907711598),new o_.Go(58,99.907477149),new o_.Go(59,100.910346543),new o_.Go(60,101.910297162),new o_.Go(61,102.913204596),new o_.Go(62,103.913758387),new o_.Go(63,104.916972087),new o_.Go(64,105.918134284),new o_.Go(65,106.921694724),new o_.Go(66,107.923973837),new o_.Go(67,108.92781),new o_.Go(68,109.92973),new o_.Go(69,110.93451),new o_.Go(70,111.93684),new o_.Go(71,112.94203)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(42,84.94894),new o_.Go(43,85.94288),new o_.Go(44,86.93653),new o_.Go(45,87.93283),new o_.Go(46,88.92754288),new o_.Go(47,89.92355583),new o_.Go(48,90.9184282),new o_.Go(49,91.915259655),new o_.Go(50,92.910248473),new o_.Go(51,93.909656309),new o_.Go(52,94.907656454),new o_.Go(53,95.907870803),new o_.Go(54,96.906364843),new o_.Go(55,97.907215692),new o_.Go(56,98.906254554),new o_.Go(57,99.907657594),new o_.Go(58,100.90731438),new o_.Go(59,101.909212938),new o_.Go(60,102.909178805),new o_.Go(61,103.911444898),new o_.Go(62,104.911658043),new o_.Go(63,105.914355408),new o_.Go(64,106.915081691),new o_.Go(65,107.918479973),new o_.Go(66,108.919980998),new o_.Go(67,109.92339),new o_.Go(68,110.92505),new o_.Go(69,111.92924),new o_.Go(70,112.93133),new o_.Go(71,113.93588),new o_.Go(72,114.93828)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(43,86.94918),new o_.Go(44,87.94042),new o_.Go(45,88.93611),new o_.Go(46,89.92978),new o_.Go(47,90.926377434),new o_.Go(48,91.92012),new o_.Go(49,92.917051523),new o_.Go(50,93.911359569),new o_.Go(51,94.910412729),new o_.Go(52,95.907597681),new o_.Go(53,96.907554546),new o_.Go(54,97.905287111),new o_.Go(55,98.905939307),new o_.Go(56,99.904219664),new o_.Go(57,100.905582219),new o_.Go(58,101.904349503),new o_.Go(59,102.906323677),new o_.Go(60,103.905430145),new o_.Go(61,104.907750341),new o_.Go(62,105.907326913),new o_.Go(63,106.909907207),new o_.Go(64,107.910192211),new o_.Go(65,108.913201565),new o_.Go(66,109.913966185),new o_.Go(67,110.91756),new o_.Go(68,111.918821673),new o_.Go(69,112.92254),new o_.Go(70,113.923891981),new o_.Go(71,114.92831),new o_.Go(72,115.93016),new o_.Go(73,116.93479),new o_.Go(74,117.93703)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(44,88.94938),new o_.Go(45,89.94287),new o_.Go(46,90.93655),new o_.Go(47,91.93198),new o_.Go(48,92.92574),new o_.Go(49,93.921698),new o_.Go(50,94.915898541),new o_.Go(51,95.914518212),new o_.Go(52,96.911336643),new o_.Go(53,97.910716431),new o_.Go(54,98.908132101),new o_.Go(55,99.90811663),new o_.Go(56,100.906163526),new o_.Go(57,101.906842845),new o_.Go(58,102.905504182),new o_.Go(59,103.906655315),new o_.Go(60,104.905692444),new o_.Go(61,105.907284615),new o_.Go(62,106.90675054),new o_.Go(63,107.908730768),new o_.Go(64,108.908735621),new o_.Go(65,109.910949525),new o_.Go(66,110.91166),new o_.Go(67,111.913969253),new o_.Go(68,112.91542),new o_.Go(69,113.91734336),new o_.Go(70,114.920124676),new o_.Go(71,115.922746643),new o_.Go(72,116.92535),new o_.Go(73,117.92943),new o_.Go(74,118.93136),new o_.Go(75,119.93578),new o_.Go(76,120.93808)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(45,90.94948),new o_.Go(46,91.94042),new o_.Go(47,92.93591),new o_.Go(48,93.92877),new o_.Go(49,94.92469),new o_.Go(50,95.91822194),new o_.Go(51,96.916478921),new o_.Go(52,97.912720751),new o_.Go(53,98.911767757),new o_.Go(54,99.908504596),new o_.Go(55,100.908289144),new o_.Go(56,101.905607716),new o_.Go(57,102.906087204),new o_.Go(58,103.904034912),new o_.Go(59,104.905084046),new o_.Go(60,105.903483087),new o_.Go(61,106.905128453),new o_.Go(62,107.903894451),new o_.Go(63,108.905953535),new o_.Go(64,109.905152385),new o_.Go(65,110.907643952),new o_.Go(66,111.907313277),new o_.Go(67,112.910151346),new o_.Go(68,113.910365322),new o_.Go(69,114.91368341),new o_.Go(70,115.914158288),new o_.Go(71,116.91784),new o_.Go(72,117.918983915),new o_.Go(73,118.92268),new o_.Go(74,119.92403),new o_.Go(75,120.92818),new o_.Go(76,121.9298),new o_.Go(77,122.93426)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(47,93.94278),new o_.Go(48,94.93548),new o_.Go(49,95.93068),new o_.Go(50,96.924),new o_.Go(51,97.921759995),new o_.Go(52,98.917597103),new o_.Go(53,99.916069387),new o_.Go(54,100.912802135),new o_.Go(55,101.911999996),new o_.Go(56,102.908972453),new o_.Go(57,103.908628228),new o_.Go(58,104.906528234),new o_.Go(59,105.906666431),new o_.Go(60,106.90509302),new o_.Go(61,107.905953705),new o_.Go(62,108.904755514),new o_.Go(63,109.90611046),new o_.Go(64,110.905294679),new o_.Go(65,111.907004132),new o_.Go(66,112.906565708),new o_.Go(67,113.908807907),new o_.Go(68,114.908762282),new o_.Go(69,115.911359558),new o_.Go(70,116.911684187),new o_.Go(71,117.914582383),new o_.Go(72,118.915666045),new o_.Go(73,119.918788609),new o_.Go(74,120.919851074),new o_.Go(75,121.92332),new o_.Go(76,122.9249),new o_.Go(77,123.92853),new o_.Go(78,124.93054),new o_.Go(79,125.9345),new o_.Go(80,126.93688)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(48,95.93977),new o_.Go(49,96.93494),new o_.Go(50,97.927579),new o_.Go(51,98.92501),new o_.Go(52,99.920230232),new o_.Go(53,100.918681442),new o_.Go(54,101.914777255),new o_.Go(55,102.913418952),new o_.Go(56,103.909848091),new o_.Go(57,104.909467818),new o_.Go(58,105.906458007),new o_.Go(59,106.906614232),new o_.Go(60,107.904183403),new o_.Go(61,108.904985569),new o_.Go(62,109.903005578),new o_.Go(63,110.904181628),new o_.Go(64,111.902757226),new o_.Go(65,112.904400947),new o_.Go(66,113.903358121),new o_.Go(67,114.905430553),new o_.Go(68,115.904755434),new o_.Go(69,116.907218242),new o_.Go(70,117.906914144),new o_.Go(71,118.909922582),new o_.Go(72,119.909851352),new o_.Go(73,120.91298039),new o_.Go(74,121.9135),new o_.Go(75,122.917003675),new o_.Go(76,123.917648302),new o_.Go(77,124.92124717),new o_.Go(78,125.922353996),new o_.Go(79,126.926434822),new o_.Go(80,127.927760617),new o_.Go(81,128.93226),new o_.Go(82,129.93398)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(49,97.94224),new o_.Go(50,98.93461),new o_.Go(51,99.931149033),new o_.Go(52,100.92656),new o_.Go(53,101.924707541),new o_.Go(54,102.919913896),new o_.Go(55,103.918338416),new o_.Go(56,104.914673434),new o_.Go(57,105.913461134),new o_.Go(58,106.910292195),new o_.Go(59,107.909719683),new o_.Go(60,108.907154078),new o_.Go(61,109.907168783),new o_.Go(62,110.905110677),new o_.Go(63,111.905533338),new o_.Go(64,112.904061223),new o_.Go(65,113.904916758),new o_.Go(66,114.903878328),new o_.Go(67,115.905259995),new o_.Go(68,116.904515731),new o_.Go(69,117.906354623),new o_.Go(70,118.905846334),new o_.Go(71,119.907961505),new o_.Go(72,120.907848847),new o_.Go(73,121.910277103),new o_.Go(74,122.910438951),new o_.Go(75,123.913175916),new o_.Go(76,124.913601387),new o_.Go(77,125.916464532),new o_.Go(78,126.917344048),new o_.Go(79,127.920170658),new o_.Go(80,128.921657958),new o_.Go(81,129.924854941),new o_.Go(82,130.926767408),new o_.Go(83,131.932919005),new o_.Go(84,132.93834),new o_.Go(85,133.94466)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(50,99.938954),new o_.Go(51,100.93606),new o_.Go(52,101.93049),new o_.Go(53,102.92813),new o_.Go(54,103.923185469),new o_.Go(55,104.921390409),new o_.Go(56,105.916880472),new o_.Go(57,106.915666702),new o_.Go(58,107.911965339),new o_.Go(59,108.911286879),new o_.Go(60,109.907852688),new o_.Go(61,110.907735404),new o_.Go(62,111.90482081),new o_.Go(63,112.905173373),new o_.Go(64,113.902781816),new o_.Go(65,114.903345973),new o_.Go(66,115.901744149),new o_.Go(67,116.902953765),new o_.Go(68,117.901606328),new o_.Go(69,118.90330888),new o_.Go(70,119.902196571),new o_.Go(71,120.904236867),new o_.Go(72,121.903440138),new o_.Go(73,122.905721901),new o_.Go(74,123.90527463),new o_.Go(75,124.907784924),new o_.Go(76,125.907653953),new o_.Go(77,126.91035098),new o_.Go(78,127.910534953),new o_.Go(79,128.913439976),new o_.Go(80,129.913852185),new o_.Go(81,130.916919144),new o_.Go(82,131.917744455),new o_.Go(83,132.923814085),new o_.Go(84,133.928463576),new o_.Go(85,134.93473),new o_.Go(86,135.93934),new o_.Go(87,136.94579)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(52,102.94012),new o_.Go(53,103.936287),new o_.Go(54,104.931528593),new o_.Go(55,105.928183134),new o_.Go(56,106.92415),new o_.Go(57,107.92216),new o_.Go(58,108.918136092),new o_.Go(59,109.917533911),new o_.Go(60,110.912534147),new o_.Go(61,111.91239464),new o_.Go(62,112.909377941),new o_.Go(63,113.909095876),new o_.Go(64,114.906598812),new o_.Go(65,115.906797235),new o_.Go(66,116.90483959),new o_.Go(67,117.905531885),new o_.Go(68,118.90394646),new o_.Go(69,119.905074315),new o_.Go(70,120.903818044),new o_.Go(71,121.905175415),new o_.Go(72,122.904215696),new o_.Go(73,123.905937525),new o_.Go(74,124.905247804),new o_.Go(75,125.907248153),new o_.Go(76,126.906914564),new o_.Go(77,127.90916733),new o_.Go(78,128.909150092),new o_.Go(79,129.911546459),new o_.Go(80,130.911946487),new o_.Go(81,131.914413247),new o_.Go(82,132.915236466),new o_.Go(83,133.920551554),new o_.Go(84,134.925167962),new o_.Go(85,135.93066),new o_.Go(86,136.93531),new o_.Go(87,137.94096),new o_.Go(88,138.94571)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(54,105.937702),new o_.Go(55,106.935036),new o_.Go(56,107.929486838),new o_.Go(57,108.927456483),new o_.Go(58,109.922407164),new o_.Go(59,110.921120589),new o_.Go(60,111.917061617),new o_.Go(61,112.915452551),new o_.Go(62,113.912498025),new o_.Go(63,114.911578627),new o_.Go(64,115.908420253),new o_.Go(65,116.90863418),new o_.Go(66,117.905825187),new o_.Go(67,118.90640811),new o_.Go(68,119.904019891),new o_.Go(69,120.904929815),new o_.Go(70,121.903047064),new o_.Go(71,122.904272951),new o_.Go(72,123.902819466),new o_.Go(73,124.904424718),new o_.Go(74,125.903305543),new o_.Go(75,126.90521729),new o_.Go(76,127.904461383),new o_.Go(77,128.906595593),new o_.Go(78,129.906222753),new o_.Go(79,130.90852188),new o_.Go(80,131.908523782),new o_.Go(81,132.910939068),new o_.Go(82,133.911540546),new o_.Go(83,134.916450782),new o_.Go(84,135.920103155),new o_.Go(85,136.925324769),new o_.Go(86,137.92922),new o_.Go(87,138.93473),new o_.Go(88,139.9387),new o_.Go(89,140.94439),new o_.Go(90,141.9485)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(55,107.943291),new o_.Go(56,108.938191658),new o_.Go(57,109.934634181),new o_.Go(58,110.930276),new o_.Go(59,111.92797),new o_.Go(60,112.923644245),new o_.Go(61,113.92185),new o_.Go(62,114.918272),new o_.Go(63,115.916735014),new o_.Go(64,116.913647692),new o_.Go(65,117.91337523),new o_.Go(66,118.910180837),new o_.Go(67,119.910047843),new o_.Go(68,120.907366063),new o_.Go(69,121.907592451),new o_.Go(70,122.905597944),new o_.Go(71,123.906211423),new o_.Go(72,124.90462415),new o_.Go(73,125.905619387),new o_.Go(74,126.90446842),new o_.Go(75,127.905805254),new o_.Go(76,128.904987487),new o_.Go(77,129.906674018),new o_.Go(78,130.906124168),new o_.Go(79,131.907994525),new o_.Go(80,132.907806465),new o_.Go(81,133.909876552),new o_.Go(82,134.91005031),new o_.Go(83,135.914655105),new o_.Go(84,136.917872653),new o_.Go(85,137.922383666),new o_.Go(86,138.926093402),new o_.Go(87,139.93121),new o_.Go(88,140.93483),new o_.Go(89,141.94018),new o_.Go(90,142.94407),new o_.Go(91,143.94961)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(56,109.944476),new o_.Go(57,110.941632),new o_.Go(58,111.93566535),new o_.Go(59,112.933382836),new o_.Go(60,113.928145),new o_.Go(61,114.926979032),new o_.Go(62,115.921394197),new o_.Go(63,116.920564355),new o_.Go(64,117.91657092),new o_.Go(65,118.915554295),new o_.Go(66,119.91215199),new o_.Go(67,120.911386497),new o_.Go(68,121.908548396),new o_.Go(69,122.908470748),new o_.Go(70,123.905895774),new o_.Go(71,124.906398236),new o_.Go(72,125.904268868),new o_.Go(73,126.905179581),new o_.Go(74,127.903530436),new o_.Go(75,128.904779458),new o_.Go(76,129.903507903),new o_.Go(77,130.90508192),new o_.Go(78,131.904154457),new o_.Go(79,132.90590566),new o_.Go(80,133.905394504),new o_.Go(81,134.907207499),new o_.Go(82,135.907219526),new o_.Go(83,136.911562939),new o_.Go(84,137.913988549),new o_.Go(85,138.918786859),new o_.Go(86,139.921635665),new o_.Go(87,140.926646282),new o_.Go(88,141.929702981),new o_.Go(89,142.93489),new o_.Go(90,143.93823),new o_.Go(91,144.94367),new o_.Go(92,145.9473),new o_.Go(93,146.95301)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(57,111.950331),new o_.Go(58,112.944535512),new o_.Go(59,113.940841319),new o_.Go(60,114.935939),new o_.Go(61,115.932914152),new o_.Go(62,116.928639484),new o_.Go(63,117.926554883),new o_.Go(64,118.922370879),new o_.Go(65,119.920678219),new o_.Go(66,120.917183637),new o_.Go(67,121.916121946),new o_.Go(68,122.912990168),new o_.Go(69,123.912245731),new o_.Go(70,124.909724871),new o_.Go(71,125.909447953),new o_.Go(72,126.9074176),new o_.Go(73,127.907747919),new o_.Go(74,128.906063369),new o_.Go(75,129.906706163),new o_.Go(76,130.905460232),new o_.Go(77,131.906429799),new o_.Go(78,132.90544687),new o_.Go(79,133.906713419),new o_.Go(80,134.905971903),new o_.Go(81,135.907305741),new o_.Go(82,136.907083505),new o_.Go(83,137.911010537),new o_.Go(84,138.913357921),new o_.Go(85,139.917277075),new o_.Go(86,140.920043984),new o_.Go(87,141.924292317),new o_.Go(88,142.927330292),new o_.Go(89,143.932027373),new o_.Go(90,144.935388226),new o_.Go(91,145.940162028),new o_.Go(92,146.943864435),new o_.Go(93,147.948899539),new o_.Go(94,148.95272),new o_.Go(95,149.95797),new o_.Go(96,150.962)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(58,113.950941),new o_.Go(59,114.94771),new o_.Go(60,115.94168),new o_.Go(61,116.937700229),new o_.Go(62,117.93344),new o_.Go(63,118.931051927),new o_.Go(64,119.926045941),new o_.Go(65,120.924485908),new o_.Go(66,121.92026),new o_.Go(67,122.91885),new o_.Go(68,123.915088437),new o_.Go(69,124.914620234),new o_.Go(70,125.911244146),new o_.Go(71,126.911121328),new o_.Go(72,127.90830887),new o_.Go(73,128.908673749),new o_.Go(74,129.906310478),new o_.Go(75,130.906930798),new o_.Go(76,131.905056152),new o_.Go(77,132.906002368),new o_.Go(78,133.904503347),new o_.Go(79,134.905682749),new o_.Go(80,135.904570109),new o_.Go(81,136.905821414),new o_.Go(82,137.905241273),new o_.Go(83,138.908835384),new o_.Go(84,139.910599485),new o_.Go(85,140.914406439),new o_.Go(86,141.916448175),new o_.Go(87,142.920617184),new o_.Go(88,143.922940468),new o_.Go(89,144.926923807),new o_.Go(90,145.930106645),new o_.Go(91,146.933992519),new o_.Go(92,147.937682377),new o_.Go(93,148.94246),new o_.Go(94,149.94562),new o_.Go(95,150.9507),new o_.Go(96,151.95416),new o_.Go(97,152.95961)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(60,116.95001),new o_.Go(61,117.94657),new o_.Go(62,118.94099),new o_.Go(63,119.93807),new o_.Go(64,120.93301),new o_.Go(65,121.93071),new o_.Go(66,122.92624),new o_.Go(67,123.92453),new o_.Go(68,124.92067),new o_.Go(69,125.91937),new o_.Go(70,126.91616),new o_.Go(71,127.91544794),new o_.Go(72,128.912667334),new o_.Go(73,129.91232),new o_.Go(74,130.910108489),new o_.Go(75,131.910110399),new o_.Go(76,132.908396372),new o_.Go(77,133.908489607),new o_.Go(78,134.906971003),new o_.Go(79,135.907651181),new o_.Go(80,136.906465656),new o_.Go(81,137.907106826),new o_.Go(82,138.90634816),new o_.Go(83,139.909472552),new o_.Go(84,140.910957016),new o_.Go(85,141.914074489),new o_.Go(86,142.916058646),new o_.Go(87,143.919591666),new o_.Go(88,144.92163837),new o_.Go(89,145.925700146),new o_.Go(90,146.927819639),new o_.Go(91,147.932191197),new o_.Go(92,148.93437),new o_.Go(93,149.93857),new o_.Go(94,150.94156),new o_.Go(95,151.94611),new o_.Go(96,152.94945),new o_.Go(97,153.9544),new o_.Go(98,154.95813)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(61,118.95276),new o_.Go(62,119.94664),new o_.Go(63,120.94367),new o_.Go(64,121.93801),new o_.Go(65,122.93551),new o_.Go(66,123.93052),new o_.Go(67,124.92854),new o_.Go(68,125.9241),new o_.Go(69,126.92275),new o_.Go(70,127.91887),new o_.Go(71,128.918679183),new o_.Go(72,129.914339361),new o_.Go(73,130.914424137),new o_.Go(74,131.91149),new o_.Go(75,132.91155),new o_.Go(76,133.909026379),new o_.Go(77,134.909145555),new o_.Go(78,135.907143574),new o_.Go(79,136.907777634),new o_.Go(80,137.905985574),new o_.Go(81,138.906646605),new o_.Go(82,139.905434035),new o_.Go(83,140.908271103),new o_.Go(84,141.909239733),new o_.Go(85,142.912381158),new o_.Go(86,143.913642686),new o_.Go(87,144.917227871),new o_.Go(88,145.918689722),new o_.Go(89,146.922510962),new o_.Go(90,147.924394738),new o_.Go(91,148.928289207),new o_.Go(92,149.930226399),new o_.Go(93,150.93404),new o_.Go(94,151.93638),new o_.Go(95,152.94058),new o_.Go(96,153.94332),new o_.Go(97,154.94804),new o_.Go(98,155.95126),new o_.Go(99,156.95634)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(62,120.955364),new o_.Go(63,121.95165),new o_.Go(64,122.94596),new o_.Go(65,123.94296),new o_.Go(66,124.93783),new o_.Go(67,125.93531),new o_.Go(68,126.93083),new o_.Go(69,127.9288),new o_.Go(70,128.92486),new o_.Go(71,129.92338),new o_.Go(72,130.920060245),new o_.Go(73,131.91912),new o_.Go(74,132.9162),new o_.Go(75,133.915672),new o_.Go(76,134.91313914),new o_.Go(77,135.912646935),new o_.Go(78,136.910678351),new o_.Go(79,137.910748891),new o_.Go(80,138.908932181),new o_.Go(81,139.909071204),new o_.Go(82,140.907647726),new o_.Go(83,141.910039865),new o_.Go(84,142.910812233),new o_.Go(85,143.913300595),new o_.Go(86,144.914506897),new o_.Go(87,145.917588016),new o_.Go(88,146.918979001),new o_.Go(89,147.922183237),new o_.Go(90,148.923791056),new o_.Go(91,149.926995031),new o_.Go(92,150.928227869),new o_.Go(93,151.9316),new o_.Go(94,152.93365),new o_.Go(95,153.93739),new o_.Go(96,154.93999),new o_.Go(97,155.94412),new o_.Go(98,156.94717),new o_.Go(99,157.95178),new o_.Go(100,158.95523)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(66,125.94307),new o_.Go(67,126.9405),new o_.Go(68,127.93539),new o_.Go(69,128.932385),new o_.Go(70,129.92878),new o_.Go(71,130.927102697),new o_.Go(72,131.92312),new o_.Go(73,132.92221),new o_.Go(74,133.918645),new o_.Go(75,134.91824),new o_.Go(76,135.915020542),new o_.Go(77,136.91463973),new o_.Go(78,137.91291745),new o_.Go(79,138.91192415),new o_.Go(80,139.909309824),new o_.Go(81,140.9096048),new o_.Go(82,141.907718643),new o_.Go(83,142.909809626),new o_.Go(84,143.910082629),new o_.Go(85,144.912568847),new o_.Go(86,145.913112139),new o_.Go(87,146.916095794),new o_.Go(88,147.916888516),new o_.Go(89,148.92014419),new o_.Go(90,149.920886563),new o_.Go(91,150.923824739),new o_.Go(92,151.924682428),new o_.Go(93,152.927694534),new o_.Go(94,153.929483295),new o_.Go(95,154.932629551),new o_.Go(96,155.9352),new o_.Go(97,156.93927),new o_.Go(98,157.94187),new o_.Go(99,158.94639),new o_.Go(100,159.94939),new o_.Go(101,160.95433)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(67,127.94826),new o_.Go(68,128.94316),new o_.Go(69,129.94045),new o_.Go(70,130.9358),new o_.Go(71,131.93375),new o_.Go(72,132.92972),new o_.Go(73,133.92849),new o_.Go(74,134.924617),new o_.Go(75,135.923447865),new o_.Go(76,136.920713),new o_.Go(77,137.920432261),new o_.Go(78,138.916759814),new o_.Go(79,139.915801649),new o_.Go(80,140.913606636),new o_.Go(81,141.912950738),new o_.Go(82,142.910927571),new o_.Go(83,143.912585768),new o_.Go(84,144.912743879),new o_.Go(85,145.914692165),new o_.Go(86,146.915133898),new o_.Go(87,147.917467786),new o_.Go(88,148.918329195),new o_.Go(89,149.920979477),new o_.Go(90,150.921202693),new o_.Go(91,151.923490557),new o_.Go(92,152.924113189),new o_.Go(93,153.926547019),new o_.Go(94,154.928097047),new o_.Go(95,155.931060357),new o_.Go(96,156.9332),new o_.Go(97,157.93669),new o_.Go(98,158.93913),new o_.Go(99,159.94299),new o_.Go(100,160.94586),new o_.Go(101,161.95029),new o_.Go(102,162.95352)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(68,129.94863),new o_.Go(69,130.94589),new o_.Go(70,131.94082),new o_.Go(71,132.93873),new o_.Go(72,133.93402),new o_.Go(73,134.93235),new o_.Go(74,135.9283),new o_.Go(75,136.927046709),new o_.Go(76,137.92354),new o_.Go(77,138.922302),new o_.Go(78,139.918991),new o_.Go(79,140.918468512),new o_.Go(80,141.915193274),new o_.Go(81,142.914623555),new o_.Go(82,143.91199473),new o_.Go(83,144.913405611),new o_.Go(84,145.91303676),new o_.Go(85,146.914893275),new o_.Go(86,147.914817914),new o_.Go(87,148.917179521),new o_.Go(88,149.917271454),new o_.Go(89,150.919928351),new o_.Go(90,151.919728244),new o_.Go(91,152.922093907),new o_.Go(92,153.922205303),new o_.Go(93,154.92463594),new o_.Go(94,155.925526236),new o_.Go(95,156.928354506),new o_.Go(96,157.929987938),new o_.Go(97,158.9332),new o_.Go(98,159.93514),new o_.Go(99,160.93883),new o_.Go(100,161.94122),new o_.Go(101,162.94536),new o_.Go(102,163.94828),new o_.Go(103,164.95298)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(69,131.95416),new o_.Go(70,132.9489),new o_.Go(71,133.94632),new o_.Go(72,134.94172),new o_.Go(73,135.9395),new o_.Go(74,136.93521),new o_.Go(75,137.93345),new o_.Go(76,138.92882915),new o_.Go(77,139.928083921),new o_.Go(78,140.924885867),new o_.Go(79,141.923400033),new o_.Go(80,142.920286634),new o_.Go(81,143.918774116),new o_.Go(82,144.916261285),new o_.Go(83,145.917199714),new o_.Go(84,146.916741206),new o_.Go(85,147.918153775),new o_.Go(86,148.917925922),new o_.Go(87,149.919698294),new o_.Go(88,150.919846022),new o_.Go(89,151.921740399),new o_.Go(90,152.921226219),new o_.Go(91,153.922975386),new o_.Go(92,154.922889429),new o_.Go(93,155.924750855),new o_.Go(94,156.925419435),new o_.Go(95,157.927841923),new o_.Go(96,158.9290845),new o_.Go(97,159.931460406),new o_.Go(98,160.93368),new o_.Go(99,161.93704),new o_.Go(100,162.93921),new o_.Go(101,163.94299),new o_.Go(102,164.94572),new o_.Go(103,165.94997),new o_.Go(104,166.95305)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(72,135.94707),new o_.Go(73,136.94465),new o_.Go(74,137.93997),new o_.Go(75,138.93808),new o_.Go(76,139.933236934),new o_.Go(77,140.93221),new o_.Go(78,141.927908919),new o_.Go(79,142.926738636),new o_.Go(80,143.923390357),new o_.Go(81,144.921687498),new o_.Go(82,145.918305344),new o_.Go(83,146.919089446),new o_.Go(84,147.918109771),new o_.Go(85,148.919336427),new o_.Go(86,149.918655455),new o_.Go(87,150.920344273),new o_.Go(88,151.919787882),new o_.Go(89,152.921746283),new o_.Go(90,153.920862271),new o_.Go(91,154.922618801),new o_.Go(92,155.922119552),new o_.Go(93,156.923956686),new o_.Go(94,157.924100533),new o_.Go(95,158.926385075),new o_.Go(96,159.927050616),new o_.Go(97,160.929665688),new o_.Go(98,161.930981211),new o_.Go(99,162.93399),new o_.Go(100,163.93586),new o_.Go(101,164.93938),new o_.Go(102,165.9416),new o_.Go(103,166.94557),new o_.Go(104,167.94836),new o_.Go(105,168.95287)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(73,137.95287),new o_.Go(74,138.94803),new o_.Go(75,139.945367985),new o_.Go(76,140.94116),new o_.Go(77,141.939073781),new o_.Go(78,142.93475),new o_.Go(79,143.93253),new o_.Go(80,144.92888),new o_.Go(81,145.927180629),new o_.Go(82,146.924037176),new o_.Go(83,147.924298636),new o_.Go(84,148.92324163),new o_.Go(85,149.923654158),new o_.Go(86,150.923098169),new o_.Go(87,151.924071324),new o_.Go(88,152.923430858),new o_.Go(89,153.924686236),new o_.Go(90,154.923500411),new o_.Go(91,155.924743749),new o_.Go(92,156.924021155),new o_.Go(93,157.92541026),new o_.Go(94,158.925343135),new o_.Go(95,159.927164021),new o_.Go(96,160.927566289),new o_.Go(97,161.929484803),new o_.Go(98,162.930643942),new o_.Go(99,163.933347253),new o_.Go(100,164.93488),new o_.Go(101,165.93805),new o_.Go(102,166.94005),new o_.Go(103,167.94364),new o_.Go(104,168.94622),new o_.Go(105,169.95025),new o_.Go(106,170.9533)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(74,139.95379),new o_.Go(75,140.95119),new o_.Go(76,141.946695946),new o_.Go(77,142.94383),new o_.Go(78,143.93907),new o_.Go(79,144.936717),new o_.Go(80,145.932720118),new o_.Go(81,146.930878496),new o_.Go(82,147.927177882),new o_.Go(83,148.927333981),new o_.Go(84,149.925579728),new o_.Go(85,150.92617963),new o_.Go(86,151.924713874),new o_.Go(87,152.925760865),new o_.Go(88,153.924422046),new o_.Go(89,154.92574895),new o_.Go(90,155.924278273),new o_.Go(91,156.925461256),new o_.Go(92,157.924404637),new o_.Go(93,158.92573566),new o_.Go(94,159.925193718),new o_.Go(95,160.926929595),new o_.Go(96,161.926794731),new o_.Go(97,162.928727532),new o_.Go(98,163.929171165),new o_.Go(99,164.931699828),new o_.Go(100,165.932803241),new o_.Go(101,166.935649025),new o_.Go(102,167.93723),new o_.Go(103,168.940303648),new o_.Go(104,169.94267),new o_.Go(105,170.94648),new o_.Go(106,171.94911),new o_.Go(107,172.95344)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(75,141.95986),new o_.Go(76,142.95469),new o_.Go(77,143.95164),new o_.Go(78,144.94688),new o_.Go(79,145.9441),new o_.Go(80,146.93984),new o_.Go(81,147.937269),new o_.Go(82,148.933789944),new o_.Go(83,149.932760914),new o_.Go(84,150.931680791),new o_.Go(85,151.931740598),new o_.Go(86,152.930194506),new o_.Go(87,153.930596268),new o_.Go(88,154.929079084),new o_.Go(89,155.929001869),new o_.Go(90,156.928188059),new o_.Go(91,157.92894573),new o_.Go(92,158.927708537),new o_.Go(93,159.928725679),new o_.Go(94,160.927851662),new o_.Go(95,161.92909242),new o_.Go(96,162.928730286),new o_.Go(97,163.930230577),new o_.Go(98,164.930319169),new o_.Go(99,165.932281267),new o_.Go(100,166.933126195),new o_.Go(101,167.935496424),new o_.Go(102,168.936868306),new o_.Go(103,169.939614951),new o_.Go(104,170.941461227),new o_.Go(105,171.94482),new o_.Go(106,172.94729),new o_.Go(107,173.95115),new o_.Go(108,174.95405)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(76,143.96059),new o_.Go(77,144.95746),new o_.Go(78,145.95212),new o_.Go(79,146.94931),new o_.Go(80,147.94444),new o_.Go(81,148.942780527),new o_.Go(82,149.937171034),new o_.Go(83,150.93746),new o_.Go(84,151.935078452),new o_.Go(85,152.935093125),new o_.Go(86,153.932777294),new o_.Go(87,154.933204273),new o_.Go(88,155.931015001),new o_.Go(89,156.931945517),new o_.Go(90,157.929912),new o_.Go(91,158.930680718),new o_.Go(92,159.929078924),new o_.Go(93,160.930001348),new o_.Go(94,161.928774923),new o_.Go(95,162.930029273),new o_.Go(96,163.929196996),new o_.Go(97,164.9307228),new o_.Go(98,165.93028997),new o_.Go(99,166.932045448),new o_.Go(100,167.932367781),new o_.Go(101,168.934588082),new o_.Go(102,169.935460334),new o_.Go(103,170.938025885),new o_.Go(104,171.939352149),new o_.Go(105,172.9424),new o_.Go(106,173.94434),new o_.Go(107,174.94793),new o_.Go(108,175.95029),new o_.Go(109,176.95437)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(77,145.966495),new o_.Go(78,146.961081),new o_.Go(79,147.95755),new o_.Go(80,148.95265),new o_.Go(81,149.94967),new o_.Go(82,150.944842),new o_.Go(83,151.9443),new o_.Go(84,152.942027631),new o_.Go(85,153.940832325),new o_.Go(86,154.939191562),new o_.Go(87,155.939006895),new o_.Go(88,156.936756069),new o_.Go(89,157.936996),new o_.Go(90,158.934808966),new o_.Go(91,159.935090772),new o_.Go(92,160.933398042),new o_.Go(93,161.933970147),new o_.Go(94,162.932647648),new o_.Go(95,163.933450972),new o_.Go(96,164.932432463),new o_.Go(97,165.933553133),new o_.Go(98,166.932848844),new o_.Go(99,167.934170375),new o_.Go(100,168.934211117),new o_.Go(101,169.935797877),new o_.Go(102,170.936425817),new o_.Go(103,171.938396118),new o_.Go(104,172.939600336),new o_.Go(105,173.942164618),new o_.Go(106,174.943832897),new o_.Go(107,175.946991412),new o_.Go(108,176.94904),new o_.Go(109,177.95264),new o_.Go(110,178.95534)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(78,147.96676),new o_.Go(79,148.96348),new o_.Go(80,149.95799),new o_.Go(81,150.954657965),new o_.Go(82,151.950167),new o_.Go(83,152.94921),new o_.Go(84,153.945651145),new o_.Go(85,154.945792),new o_.Go(86,155.942847109),new o_.Go(87,156.94265865),new o_.Go(88,157.939857897),new o_.Go(89,158.940153735),new o_.Go(90,159.93756),new o_.Go(91,160.937357719),new o_.Go(92,161.93575),new o_.Go(93,162.936265492),new o_.Go(94,163.93452),new o_.Go(95,164.935397592),new o_.Go(96,165.933879623),new o_.Go(97,166.934946862),new o_.Go(98,167.933894465),new o_.Go(99,168.93518712),new o_.Go(100,169.934758652),new o_.Go(101,170.936322297),new o_.Go(102,171.936377696),new o_.Go(103,172.938206756),new o_.Go(104,173.938858101),new o_.Go(105,174.941272494),new o_.Go(106,175.942568409),new o_.Go(107,176.945257126),new o_.Go(108,177.946643396),new o_.Go(109,178.95017),new o_.Go(110,179.95233),new o_.Go(111,180.95615)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(79,149.972668),new o_.Go(80,150.967147),new o_.Go(81,151.96361),new o_.Go(82,152.95869),new o_.Go(83,153.9571),new o_.Go(84,154.953641324),new o_.Go(85,155.952907),new o_.Go(86,156.950101536),new o_.Go(87,157.948577981),new o_.Go(88,158.946615113),new o_.Go(89,159.945383),new o_.Go(90,160.943047504),new o_.Go(91,161.943222),new o_.Go(92,162.941203796),new o_.Go(93,163.941215),new o_.Go(94,164.939605886),new o_.Go(95,165.939762646),new o_.Go(96,166.938307056),new o_.Go(97,167.938698576),new o_.Go(98,168.937648757),new o_.Go(99,169.93847219),new o_.Go(100,170.937909903),new o_.Go(101,171.939082239),new o_.Go(102,172.938926901),new o_.Go(103,173.940333522),new o_.Go(104,174.940767904),new o_.Go(105,175.942682399),new o_.Go(106,176.943754987),new o_.Go(107,177.945951366),new o_.Go(108,178.947324216),new o_.Go(109,179.949879968),new o_.Go(110,180.95197),new o_.Go(111,181.95521),new o_.Go(112,182.95757),new o_.Go(113,183.96117)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(82,153.96425),new o_.Go(83,154.96276),new o_.Go(84,155.959247),new o_.Go(85,156.958127),new o_.Go(86,157.95405528),new o_.Go(87,158.954003),new o_.Go(88,159.950713588),new o_.Go(89,160.950330852),new o_.Go(90,161.947202977),new o_.Go(91,162.947057),new o_.Go(92,163.944422),new o_.Go(93,164.94454),new o_.Go(94,165.94225),new o_.Go(95,166.9426),new o_.Go(96,167.94063),new o_.Go(97,168.941158567),new o_.Go(98,169.93965),new o_.Go(99,170.94049),new o_.Go(100,171.93945798),new o_.Go(101,172.94065),new o_.Go(102,173.940040159),new o_.Go(103,174.941502991),new o_.Go(104,175.941401828),new o_.Go(105,176.943220013),new o_.Go(106,177.943697732),new o_.Go(107,178.945815073),new o_.Go(108,179.94654876),new o_.Go(109,180.949099124),new o_.Go(110,181.950552893),new o_.Go(111,182.953531012),new o_.Go(112,183.95544788),new o_.Go(113,184.95878),new o_.Go(114,185.96092)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(83,155.971689),new o_.Go(84,156.968145),new o_.Go(85,157.966368),new o_.Go(86,158.96232309),new o_.Go(87,159.961358),new o_.Go(88,160.958372992),new o_.Go(89,161.956556553),new o_.Go(90,162.95431665),new o_.Go(91,163.95357),new o_.Go(92,164.950817),new o_.Go(93,165.95047),new o_.Go(94,166.948639),new o_.Go(95,167.947787),new o_.Go(96,168.94592),new o_.Go(97,169.94609),new o_.Go(98,170.94446),new o_.Go(99,171.944739818),new o_.Go(100,172.94459),new o_.Go(101,173.944167937),new o_.Go(102,174.94365),new o_.Go(103,175.944740551),new o_.Go(104,176.944471766),new o_.Go(105,177.945750349),new o_.Go(106,178.945934113),new o_.Go(107,179.947465655),new o_.Go(108,180.947996346),new o_.Go(109,181.950152414),new o_.Go(110,182.951373188),new o_.Go(111,183.954009331),new o_.Go(112,184.955559086),new o_.Go(113,185.9585501),new o_.Go(114,186.96041),new o_.Go(115,187.96371)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(84,157.973939),new o_.Go(85,158.97228),new o_.Go(86,159.968369),new o_.Go(87,160.967089),new o_.Go(88,161.962750303),new o_.Go(89,162.962532),new o_.Go(90,163.95898381),new o_.Go(91,164.958335962),new o_.Go(92,165.955019896),new o_.Go(93,166.954672),new o_.Go(94,167.951863),new o_.Go(95,168.951759),new o_.Go(96,169.948473988),new o_.Go(97,170.94946),new o_.Go(98,171.948228837),new o_.Go(99,172.948884),new o_.Go(100,173.94616),new o_.Go(101,174.94677),new o_.Go(102,175.94559),new o_.Go(103,176.94662),new o_.Go(104,177.945848364),new o_.Go(105,178.947071733),new o_.Go(106,179.946705734),new o_.Go(107,180.948198054),new o_.Go(108,181.948205519),new o_.Go(109,182.950224458),new o_.Go(110,183.950932553),new o_.Go(111,184.953420586),new o_.Go(112,185.954362204),new o_.Go(113,186.957158365),new o_.Go(114,187.958486954),new o_.Go(115,188.96191222),new o_.Go(116,189.963179541)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(85,159.981485),new o_.Go(86,160.977661),new o_.Go(87,161.975707),new o_.Go(88,162.971375872),new o_.Go(89,163.970319),new o_.Go(90,164.967050268),new o_.Go(91,165.965211372),new o_.Go(92,166.962564),new o_.Go(93,167.961609),new o_.Go(94,168.95883),new o_.Go(95,169.958163),new o_.Go(96,170.955547),new o_.Go(97,171.955285),new o_.Go(98,172.953062),new o_.Go(99,173.952114),new o_.Go(100,174.951393),new o_.Go(101,175.95157),new o_.Go(102,176.95027),new o_.Go(103,177.950851081),new o_.Go(104,178.949981038),new o_.Go(105,179.95078768),new o_.Go(106,180.950064596),new o_.Go(107,181.951211444),new o_.Go(108,182.950821349),new o_.Go(109,183.952524289),new o_.Go(110,184.952955747),new o_.Go(111,185.954986529),new o_.Go(112,186.955750787),new o_.Go(113,187.958112287),new o_.Go(114,188.959228359),new o_.Go(115,189.961816139),new o_.Go(116,190.963123592),new o_.Go(117,191.96596)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(86,161.983819),new o_.Go(87,162.982048),new o_.Go(88,163.977927),new o_.Go(89,164.976475),new o_.Go(90,165.971934911),new o_.Go(91,166.971554),new o_.Go(92,167.967832911),new o_.Go(93,168.967076205),new o_.Go(94,169.963569716),new o_.Go(95,170.96304),new o_.Go(96,171.960078),new o_.Go(97,172.959791),new o_.Go(98,173.956307704),new o_.Go(99,174.95708),new o_.Go(100,175.953757941),new o_.Go(101,176.955045),new o_.Go(102,177.953348225),new o_.Go(103,178.953951),new o_.Go(104,179.952308241),new o_.Go(105,180.953274494),new o_.Go(106,181.952186222),new o_.Go(107,182.95311),new o_.Go(108,183.952490808),new o_.Go(109,184.954043023),new o_.Go(110,185.953838355),new o_.Go(111,186.955747928),new o_.Go(112,187.955835993),new o_.Go(113,188.958144866),new o_.Go(114,189.95844521),new o_.Go(115,190.960927951),new o_.Go(116,191.961479047),new o_.Go(117,192.964148083),new o_.Go(118,193.965179314),new o_.Go(119,194.968123889),new o_.Go(120,195.96962255)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(88,164.98758),new o_.Go(89,165.985506),new o_.Go(90,166.980951577),new o_.Go(91,167.979966),new o_.Go(92,168.976390868),new o_.Go(93,169.974441697),new o_.Go(94,170.971779),new o_.Go(95,171.970643),new o_.Go(96,172.967707),new o_.Go(97,173.966804),new o_.Go(98,174.964279),new o_.Go(99,175.963511),new o_.Go(100,176.96117),new o_.Go(101,177.960084944),new o_.Go(102,178.95915),new o_.Go(103,179.958555615),new o_.Go(104,180.957642156),new o_.Go(105,181.958127689),new o_.Go(106,182.956814),new o_.Go(107,183.957388318),new o_.Go(108,184.95659),new o_.Go(109,185.957951104),new o_.Go(110,186.95736083),new o_.Go(111,187.958851962),new o_.Go(112,188.958716473),new o_.Go(113,189.960592299),new o_.Go(114,190.960591191),new o_.Go(115,191.962602198),new o_.Go(116,192.9629237),new o_.Go(117,193.96507561),new o_.Go(118,194.9659768),new o_.Go(119,195.968379906),new o_.Go(120,196.969636496),new o_.Go(121,197.97228),new o_.Go(122,198.973787159)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(90,167.988035),new o_.Go(91,168.986421),new o_.Go(92,169.981734918),new o_.Go(93,170.981251),new o_.Go(94,171.977376138),new o_.Go(95,172.976499642),new o_.Go(96,173.972811276),new o_.Go(97,174.972276),new o_.Go(98,175.969),new o_.Go(99,176.968453),new o_.Go(100,177.964894223),new o_.Go(101,178.965475),new o_.Go(102,179.962023729),new o_.Go(103,180.963177),new o_.Go(104,181.961267637),new o_.Go(105,182.961729),new o_.Go(106,183.959851685),new o_.Go(107,184.960753782),new o_.Go(108,185.959432346),new o_.Go(109,186.960697),new o_.Go(110,187.959395697),new o_.Go(111,188.9608319),new o_.Go(112,189.959930073),new o_.Go(113,190.961684653),new o_.Go(114,191.961035158),new o_.Go(115,192.962984504),new o_.Go(116,193.962663581),new o_.Go(117,194.964774449),new o_.Go(118,195.964934884),new o_.Go(119,196.967323401),new o_.Go(120,197.967876009),new o_.Go(121,198.970576213),new o_.Go(122,199.971423885),new o_.Go(123,200.974496467),new o_.Go(124,201.97574)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(92,170.991183),new o_.Go(93,171.990109),new o_.Go(94,172.986398138),new o_.Go(95,173.984325861),new o_.Go(96,174.981552),new o_.Go(97,175.980269),new o_.Go(98,176.977215),new o_.Go(99,177.975975),new o_.Go(100,178.973412),new o_.Go(101,179.972396),new o_.Go(102,180.969948),new o_.Go(103,181.968621416),new o_.Go(104,182.96762),new o_.Go(105,183.966776046),new o_.Go(106,184.965806956),new o_.Go(107,185.965997671),new o_.Go(108,186.964562),new o_.Go(109,187.965321662),new o_.Go(110,188.9642243),new o_.Go(111,189.964698757),new o_.Go(112,190.963649239),new o_.Go(113,191.964810107),new o_.Go(114,192.964131745),new o_.Go(115,193.96533889),new o_.Go(116,194.965017928),new o_.Go(117,195.966551315),new o_.Go(118,196.966551609),new o_.Go(119,197.968225244),new o_.Go(120,198.968748016),new o_.Go(121,199.970717886),new o_.Go(122,200.971640839),new o_.Go(123,201.973788431),new o_.Go(124,202.975137256),new o_.Go(125,203.977705),new o_.Go(126,204.97961)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(95,174.991411),new o_.Go(96,175.987413248),new o_.Go(97,176.986336874),new o_.Go(98,177.982476325),new o_.Go(99,178.981783),new o_.Go(100,179.978322),new o_.Go(101,180.977806),new o_.Go(102,181.97393546),new o_.Go(103,182.974561),new o_.Go(104,183.970705219),new o_.Go(105,184.971983),new o_.Go(106,185.969460021),new o_.Go(107,186.969785),new o_.Go(108,187.967511693),new o_.Go(109,188.968733187),new o_.Go(110,189.966958568),new o_.Go(111,190.96706311),new o_.Go(112,191.965921572),new o_.Go(113,192.966644169),new o_.Go(114,193.965381832),new o_.Go(115,194.966638981),new o_.Go(116,195.965814846),new o_.Go(117,196.967195333),new o_.Go(118,197.96675183),new o_.Go(119,198.968262489),new o_.Go(120,199.968308726),new o_.Go(121,200.970285275),new o_.Go(122,201.970625604),new o_.Go(123,202.972857096),new o_.Go(124,203.97347564),new o_.Go(125,204.976056104),new o_.Go(126,205.977498672),new o_.Go(127,206.982577025),new o_.Go(128,207.98594)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(96,176.996881),new o_.Go(97,177.994637),new o_.Go(98,178.991466),new o_.Go(99,179.990194),new o_.Go(100,180.986904),new o_.Go(101,181.98561),new o_.Go(102,182.982697),new o_.Go(103,183.98176),new o_.Go(104,184.9791),new o_.Go(105,185.977549881),new o_.Go(106,186.97617),new o_.Go(107,187.97592),new o_.Go(108,188.974290451),new o_.Go(109,189.974473379),new o_.Go(110,190.972261952),new o_.Go(111,191.972770785),new o_.Go(112,192.970548),new o_.Go(113,193.971053),new o_.Go(114,194.96965),new o_.Go(115,195.970515),new o_.Go(116,196.9695362),new o_.Go(117,197.970466294),new o_.Go(118,198.969813837),new o_.Go(119,199.970945394),new o_.Go(120,200.97080377),new o_.Go(121,201.972090569),new o_.Go(122,202.972329088),new o_.Go(123,203.973848646),new o_.Go(124,204.97441227),new o_.Go(125,205.976095321),new o_.Go(126,206.977407908),new o_.Go(127,207.982004653),new o_.Go(128,208.985349125),new o_.Go(129,209.990065574)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(99,180.996714),new o_.Go(100,181.992676101),new o_.Go(101,182.99193),new o_.Go(102,183.988198),new o_.Go(103,184.98758),new o_.Go(104,185.983485388),new o_.Go(105,186.98403),new o_.Go(106,187.979869108),new o_.Go(107,188.98088),new o_.Go(108,189.978180008),new o_.Go(109,190.9782),new o_.Go(110,191.975719811),new o_.Go(111,192.97608),new o_.Go(112,193.974648056),new o_.Go(113,194.975920279),new o_.Go(114,195.97271),new o_.Go(115,196.97338),new o_.Go(116,197.97198),new o_.Go(117,198.972909384),new o_.Go(118,199.97181556),new o_.Go(119,200.972846589),new o_.Go(120,201.972143786),new o_.Go(121,202.973375491),new o_.Go(122,203.973028761),new o_.Go(123,204.974467112),new o_.Go(124,205.974449002),new o_.Go(125,206.975880605),new o_.Go(126,207.97663585),new o_.Go(127,208.981074801),new o_.Go(128,209.984173129),new o_.Go(129,210.988731474),new o_.Go(130,211.991887495),new o_.Go(131,212.9965),new o_.Go(132,213.999798147)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(102,184.997708),new o_.Go(103,185.99648),new o_.Go(104,186.993458),new o_.Go(105,187.992173),new o_.Go(106,188.989505),new o_.Go(107,189.987520007),new o_.Go(108,190.986053),new o_.Go(109,191.985368),new o_.Go(110,192.983662229),new o_.Go(111,193.983430186),new o_.Go(112,194.98112697),new o_.Go(113,195.981236107),new o_.Go(114,196.978934287),new o_.Go(115,197.979024396),new o_.Go(116,198.977576953),new o_.Go(117,199.978141983),new o_.Go(118,200.976970721),new o_.Go(119,201.977674504),new o_.Go(120,202.976868118),new o_.Go(121,203.977805161),new o_.Go(122,204.977374688),new o_.Go(123,205.978482854),new o_.Go(124,206.978455217),new o_.Go(125,207.979726699),new o_.Go(126,208.980383241),new o_.Go(127,209.984104944),new o_.Go(128,210.987258139),new o_.Go(129,211.991271542),new o_.Go(130,212.994374836),new o_.Go(131,213.998698664),new o_.Go(132,215.001832349),new o_.Go(133,216.006199)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(106,189.994293888),new o_.Go(107,190.994653),new o_.Go(108,191.99033039),new o_.Go(109,192.991102),new o_.Go(110,193.988284107),new o_.Go(111,194.988045),new o_.Go(112,195.985469432),new o_.Go(113,196.985567),new o_.Go(114,197.984024384),new o_.Go(115,198.985044507),new o_.Go(116,199.981735),new o_.Go(117,200.982209),new o_.Go(118,201.980704),new o_.Go(119,202.981412863),new o_.Go(120,203.980307113),new o_.Go(121,204.981165396),new o_.Go(122,205.980465241),new o_.Go(123,206.981578228),new o_.Go(124,207.981231059),new o_.Go(125,208.982415788),new o_.Go(126,209.982857396),new o_.Go(127,210.986636869),new o_.Go(128,211.988851755),new o_.Go(129,212.992842522),new o_.Go(130,213.995185949),new o_.Go(131,214.999414609),new o_.Go(132,216.001905198),new o_.Go(133,217.006253),new o_.Go(134,218.008965773)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(108,193.000188),new o_.Go(109,193.997973),new o_.Go(110,194.996554),new o_.Go(111,195.995702),new o_.Go(112,196.993891293),new o_.Go(113,197.99343368),new o_.Go(114,198.991008569),new o_.Go(115,199.990920883),new o_.Go(116,200.988486908),new o_.Go(117,201.988448629),new o_.Go(118,202.986847216),new o_.Go(119,203.987261559),new o_.Go(120,204.986036352),new o_.Go(121,205.986599242),new o_.Go(122,206.985775861),new o_.Go(123,207.986582508),new o_.Go(124,208.986158678),new o_.Go(125,209.987131308),new o_.Go(126,210.987480806),new o_.Go(127,211.990734657),new o_.Go(128,212.99292115),new o_.Go(129,213.996356412),new o_.Go(130,214.998641245),new o_.Go(131,216.002408839),new o_.Go(132,217.004709619),new o_.Go(133,218.008681458),new o_.Go(134,219.011296478),new o_.Go(135,220.015301),new o_.Go(136,221.01814),new o_.Go(137,222.02233),new o_.Go(138,223.02534)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(110,196.001117268),new o_.Go(111,197.001661),new o_.Go(112,197.998779978),new o_.Go(113,198.998309),new o_.Go(114,199.995634148),new o_.Go(115,200.995535),new o_.Go(116,201.993899382),new o_.Go(117,202.994765192),new o_.Go(118,203.991365),new o_.Go(119,204.991668),new o_.Go(120,205.99016),new o_.Go(121,206.990726826),new o_.Go(122,207.989631237),new o_.Go(123,208.990376634),new o_.Go(124,209.989679862),new o_.Go(125,210.99058541),new o_.Go(126,211.990688899),new o_.Go(127,212.993868354),new o_.Go(128,213.995346275),new o_.Go(129,214.998729195),new o_.Go(130,216.000258153),new o_.Go(131,217.003914555),new o_.Go(132,218.005586315),new o_.Go(133,219.009474831),new o_.Go(134,220.011384149),new o_.Go(135,221.015455),new o_.Go(136,222.017570472),new o_.Go(137,223.02179),new o_.Go(138,224.02409),new o_.Go(139,225.02844),new o_.Go(140,226.03089),new o_.Go(141,227.035407),new o_.Go(142,228.038084)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(113,200.006499),new o_.Go(114,201.00458692),new o_.Go(115,202.00396885),new o_.Go(116,203.001423829),new o_.Go(117,204.001221209),new o_.Go(118,204.998663961),new o_.Go(119,205.998486886),new o_.Go(120,206.996859385),new o_.Go(121,207.997133849),new o_.Go(122,208.995915421),new o_.Go(123,209.996398327),new o_.Go(124,210.995529332),new o_.Go(125,211.996194988),new o_.Go(126,212.996174845),new o_.Go(127,213.99895474),new o_.Go(128,215.000326029),new o_.Go(129,216.003187873),new o_.Go(130,217.004616452),new o_.Go(131,218.007563326),new o_.Go(132,219.009240843),new o_.Go(133,220.012312978),new o_.Go(134,221.014245654),new o_.Go(135,222.017543957),new o_.Go(136,223.019730712),new o_.Go(137,224.023235513),new o_.Go(138,225.025606914),new o_.Go(139,226.029343423),new o_.Go(140,227.031833167),new o_.Go(141,228.034776087),new o_.Go(142,229.038426),new o_.Go(143,230.04251),new o_.Go(144,231.045407),new o_.Go(145,232.049654)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(115,203.00921),new o_.Go(116,204.006434513),new o_.Go(117,205.006187),new o_.Go(118,206.004463814),new o_.Go(119,207.005176607),new o_.Go(120,208.001776),new o_.Go(121,209.001944),new o_.Go(122,210.000446),new o_.Go(123,211.000893996),new o_.Go(124,211.999783492),new o_.Go(125,213.000345847),new o_.Go(126,214.000091141),new o_.Go(127,215.002704195),new o_.Go(128,216.003518402),new o_.Go(129,217.00630601),new o_.Go(130,218.007123948),new o_.Go(131,219.010068787),new o_.Go(132,220.011014669),new o_.Go(133,221.013907762),new o_.Go(134,222.01536182),new o_.Go(135,223.01849714),new o_.Go(136,224.020202004),new o_.Go(137,225.023604463),new o_.Go(138,226.025402555),new o_.Go(139,227.029170677),new o_.Go(140,228.031064101),new o_.Go(141,229.034820309),new o_.Go(142,230.037084774),new o_.Go(143,231.04122),new o_.Go(144,232.043693),new o_.Go(145,233.047995),new o_.Go(146,234.050547)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(118,207.012469754),new o_.Go(119,208.012112949),new o_.Go(120,209.009568736),new o_.Go(121,210.009256802),new o_.Go(122,211.007648196),new o_.Go(123,212.007811441),new o_.Go(124,213.006573689),new o_.Go(125,214.006893072),new o_.Go(126,215.006450832),new o_.Go(127,216.008721268),new o_.Go(128,217.009332676),new o_.Go(129,218.011625045),new o_.Go(130,219.012404918),new o_.Go(131,220.014752105),new o_.Go(132,221.015575746),new o_.Go(133,222.017828852),new o_.Go(134,223.01912603),new o_.Go(135,224.021708435),new o_.Go(136,225.023220576),new o_.Go(137,226.026089848),new o_.Go(138,227.027746979),new o_.Go(139,228.031014825),new o_.Go(140,229.032930871),new o_.Go(141,230.036025144),new o_.Go(142,231.038551503),new o_.Go(143,232.042022474),new o_.Go(144,233.04455),new o_.Go(145,234.04842),new o_.Go(146,235.051102),new o_.Go(147,236.055178)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(120,210.015711883),new o_.Go(121,211.016306912),new o_.Go(122,212.012916),new o_.Go(123,213.012962),new o_.Go(124,214.011451),new o_.Go(125,215.011726597),new o_.Go(126,216.011050963),new o_.Go(127,217.013066169),new o_.Go(128,218.013267744),new o_.Go(129,219.015521253),new o_.Go(130,220.015733126),new o_.Go(131,221.018171499),new o_.Go(132,222.018454131),new o_.Go(133,223.020795153),new o_.Go(134,224.02145925),new o_.Go(135,225.023941441),new o_.Go(136,226.024890681),new o_.Go(137,227.027698859),new o_.Go(138,228.028731348),new o_.Go(139,229.03175534),new o_.Go(140,230.033126574),new o_.Go(141,231.03629706),new o_.Go(142,232.03805036),new o_.Go(143,233.041576923),new o_.Go(144,234.043595497),new o_.Go(145,235.04750442),new o_.Go(146,236.04971),new o_.Go(147,237.053894),new o_.Go(148,238.056243)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(122,213.021183209),new o_.Go(123,214.02073923),new o_.Go(124,215.019097612),new o_.Go(125,216.019109649),new o_.Go(126,217.018288571),new o_.Go(127,218.020007906),new o_.Go(128,219.019880348),new o_.Go(129,220.021876493),new o_.Go(130,221.021863742),new o_.Go(131,222.023726),new o_.Go(132,223.023963748),new o_.Go(133,224.025614854),new o_.Go(134,225.026115172),new o_.Go(135,226.02793275),new o_.Go(136,227.028793151),new o_.Go(137,228.031036942),new o_.Go(138,229.032088601),new o_.Go(139,230.034532562),new o_.Go(140,231.035878898),new o_.Go(141,232.03858172),new o_.Go(142,233.040240235),new o_.Go(143,234.043302325),new o_.Go(144,235.045436759),new o_.Go(145,236.048675176),new o_.Go(146,237.05113943),new o_.Go(147,238.054497046),new o_.Go(148,239.05713),new o_.Go(149,240.06098)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(126,218.023487),new o_.Go(127,219.024915423),new o_.Go(128,220.024712),new o_.Go(129,221.026351),new o_.Go(130,222.02607),new o_.Go(131,223.027722956),new o_.Go(132,224.027590139),new o_.Go(133,225.029384369),new o_.Go(134,226.02933975),new o_.Go(135,227.031140069),new o_.Go(136,228.031366357),new o_.Go(137,229.033496137),new o_.Go(138,230.033927392),new o_.Go(139,231.036289158),new o_.Go(140,232.03714628),new o_.Go(141,233.039628196),new o_.Go(142,234.040945606),new o_.Go(143,235.043923062),new o_.Go(144,236.045561897),new o_.Go(145,237.048723955),new o_.Go(146,238.050782583),new o_.Go(147,239.054287777),new o_.Go(148,240.056585734),new o_.Go(149,241.06033),new o_.Go(150,242.062925)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(132,225.033899689),new o_.Go(133,226.035129),new o_.Go(134,227.034958261),new o_.Go(135,228.03618),new o_.Go(136,229.036246866),new o_.Go(137,230.037812591),new o_.Go(138,231.038233161),new o_.Go(139,232.040099),new o_.Go(140,233.04073235),new o_.Go(141,234.042888556),new o_.Go(142,235.044055876),new o_.Go(143,236.046559724),new o_.Go(144,237.048167253),new o_.Go(145,238.050940464),new o_.Go(146,239.052931399),new o_.Go(147,240.056168828),new o_.Go(148,241.058246266),new o_.Go(149,242.061635),new o_.Go(150,243.064273),new o_.Go(151,244.06785)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(134,228.038727686),new o_.Go(135,229.040138934),new o_.Go(136,230.039645603),new o_.Go(137,231.041258),new o_.Go(138,232.041179445),new o_.Go(139,233.04298757),new o_.Go(140,234.043304681),new o_.Go(141,235.0452815),new o_.Go(142,236.046048088),new o_.Go(143,237.048403774),new o_.Go(144,238.0495534),new o_.Go(145,239.052156519),new o_.Go(146,240.05380746),new o_.Go(147,241.056845291),new o_.Go(148,242.058736847),new o_.Go(149,243.061997013),new o_.Go(150,244.06419765),new o_.Go(151,245.067738657),new o_.Go(152,246.070198429),new o_.Go(153,247.07407)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(136,231.04556),new o_.Go(137,232.04659),new o_.Go(138,233.046472),new o_.Go(139,234.047794),new o_.Go(140,235.048029),new o_.Go(141,236.049569),new o_.Go(142,237.049970748),new o_.Go(143,238.051977839),new o_.Go(144,239.053018481),new o_.Go(145,240.055287826),new o_.Go(146,241.056822944),new o_.Go(147,242.059543039),new o_.Go(148,243.061372686),new o_.Go(149,244.064279429),new o_.Go(150,245.066445398),new o_.Go(151,246.069768438),new o_.Go(152,247.072086),new o_.Go(153,248.075745),new o_.Go(154,249.07848)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(137,233.0508),new o_.Go(138,234.05024),new o_.Go(139,235.051591),new o_.Go(140,236.051405),new o_.Go(141,237.052891),new o_.Go(142,238.053016298),new o_.Go(143,239.054951),new o_.Go(144,240.055519046),new o_.Go(145,241.057646736),new o_.Go(146,242.058829326),new o_.Go(147,243.061382249),new o_.Go(148,244.062746349),new o_.Go(149,245.065485586),new o_.Go(150,246.067217551),new o_.Go(151,247.070346811),new o_.Go(152,248.072342247),new o_.Go(153,249.075947062),new o_.Go(154,250.078350687),new o_.Go(155,251.082277873),new o_.Go(156,252.08487)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(138,235.05658),new o_.Go(139,236.05733),new o_.Go(140,237.057127),new o_.Go(141,238.058266),new o_.Go(142,239.058362),new o_.Go(143,240.059749),new o_.Go(144,241.060223),new o_.Go(145,242.06205),new o_.Go(146,243.06300157),new o_.Go(147,244.065167882),new o_.Go(148,245.066355386),new o_.Go(149,246.068666836),new o_.Go(150,247.070298533),new o_.Go(151,248.07308),new o_.Go(152,249.074979937),new o_.Go(153,250.078310529),new o_.Go(154,251.08075344),new o_.Go(155,252.084303),new o_.Go(156,253.08688),new o_.Go(157,254.0906)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(139,237.06207),new o_.Go(140,238.06141),new o_.Go(141,239.062579),new o_.Go(142,240.062295),new o_.Go(143,241.063716),new o_.Go(144,242.063688713),new o_.Go(145,243.065421),new o_.Go(146,244.06599039),new o_.Go(147,245.068039),new o_.Go(148,246.068798807),new o_.Go(149,247.070992043),new o_.Go(150,248.07217808),new o_.Go(151,249.074846818),new o_.Go(152,250.076399951),new o_.Go(153,251.079580056),new o_.Go(154,252.081619582),new o_.Go(155,253.085126791),new o_.Go(156,254.087316198),new o_.Go(157,255.091039),new o_.Go(158,256.09344)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(141,240.06892),new o_.Go(142,241.068662),new o_.Go(143,242.069699),new o_.Go(144,243.069631),new o_.Go(145,244.070969),new o_.Go(146,245.071317),new o_.Go(147,246.072965),new o_.Go(148,247.07365),new o_.Go(149,248.075458),new o_.Go(150,249.076405),new o_.Go(151,250.078654),new o_.Go(152,251.079983592),new o_.Go(153,252.082972247),new o_.Go(154,253.084817974),new o_.Go(155,254.088016026),new o_.Go(156,255.090266386),new o_.Go(157,256.093592),new o_.Go(158,257.095979)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(142,242.07343),new o_.Go(143,243.07451),new o_.Go(144,244.074077),new o_.Go(145,245.075375),new o_.Go(146,246.075281634),new o_.Go(147,247.076819),new o_.Go(148,248.077184411),new o_.Go(149,249.079024),new o_.Go(150,250.079514759),new o_.Go(151,251.081566467),new o_.Go(152,252.082460071),new o_.Go(153,253.085176259),new o_.Go(154,254.086847795),new o_.Go(155,255.089955466),new o_.Go(156,256.091766522),new o_.Go(157,257.095098635),new o_.Go(158,258.097069),new o_.Go(159,259.100588)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(144,245.081017),new o_.Go(145,246.081933),new o_.Go(146,247.081804),new o_.Go(147,248.082909),new o_.Go(148,249.083002),new o_.Go(149,250.084488),new o_.Go(150,251.084919),new o_.Go(151,252.08663),new o_.Go(152,253.08728),new o_.Go(153,254.089725),new o_.Go(154,255.091075196),new o_.Go(155,256.094052757),new o_.Go(156,257.095534643),new o_.Go(157,258.098425321),new o_.Go(158,259.100503),new o_.Go(159,260.103645)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(147,249.087823),new o_.Go(148,250.087493),new o_.Go(149,251.08896),new o_.Go(150,252.088965909),new o_.Go(151,253.090649),new o_.Go(152,254.090948746),new o_.Go(153,255.093232449),new o_.Go(154,256.094275879),new o_.Go(155,257.096852778),new o_.Go(156,258.0982),new o_.Go(157,259.101024),new o_.Go(158,260.102636),new o_.Go(159,261.105743),new o_.Go(160,262.10752)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(148,251.09436),new o_.Go(149,252.09533),new o_.Go(150,253.095258),new o_.Go(151,254.096587),new o_.Go(152,255.096769),new o_.Go(153,256.098763),new o_.Go(154,257.099606),new o_.Go(155,258.101883),new o_.Go(156,259.10299),new o_.Go(157,260.105572),new o_.Go(158,261.106941),new o_.Go(159,262.109692),new o_.Go(160,263.111394)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(149,253.100679),new o_.Go(150,254.100166),new o_.Go(151,255.101492),new o_.Go(152,256.101179573),new o_.Go(153,257.103072),new o_.Go(154,258.103568),new o_.Go(155,259.105628),new o_.Go(156,260.106434),new o_.Go(157,261.108752),new o_.Go(158,262.109918),new o_.Go(159,263.11254),new o_.Go(160,264.113978)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(150,255.107398),new o_.Go(151,256.10811),new o_.Go(152,257.107858),new o_.Go(153,258.109438),new o_.Go(154,259.109721),new o_.Go(155,260.111427),new o_.Go(156,261.112106),new o_.Go(157,262.114153),new o_.Go(158,263.115078),new o_.Go(159,264.117473),new o_.Go(160,265.118659)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(152,258.113151),new o_.Go(153,259.114652),new o_.Go(154,260.114435447),new o_.Go(155,261.116199),new o_.Go(156,262.116477),new o_.Go(157,263.118313),new o_.Go(158,264.118924),new o_.Go(159,265.121066),new o_.Go(160,266.121928)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(153,260.121803),new o_.Go(154,261.1218),new o_.Go(155,262.123009),new o_.Go(156,263.123146),new o_.Go(157,264.12473),new o_.Go(158,265.125198),new o_.Go(159,266.127009),new o_.Go(160,267.12774)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(155,263.12871),new o_.Go(156,264.128408258),new o_.Go(157,265.130001),new o_.Go(158,266.130042),new o_.Go(159,267.131774),new o_.Go(160,268.132156),new o_.Go(161,269.134114)]),XI(II(h_.HK,1),z1,3,0,[new o_.Go(156,265.136567),new o_.Go(157,266.13794),new o_.Go(158,267.137526),new o_.Go(159,268.138816),new o_.Go(160,269.139106),new o_.Go(161,270.140723),new o_.Go(162,271.141229)])]);};o_.Jo=function Jo(a,b){o_.Io();var c,d;d=b-a;for(c=0;c<o_.Ho[a].length;c++)if(o_.Ho[a][c].b==d)return o_.Ho[a][c].a;return NaN;};o_.No=function No(){o_.No=zO;o_.Mo=XI(II(h_.fK,1),B0,5,15,[0,1.00794,4.0026,6.941,9.0122,10.811,12.011,14.007,15.999,18.998,20.18,22.99,24.305,26.982,28.086,30.974,32.066,35.453,39.948,39.098,40.078,44.956,47.867,50.942,51.996,54.938,55.845,58.933,58.693,63.546,65.39,69.723,72.61,74.922,78.96,79.904,83.8,85.468,87.62,88.906,91.224,92.906,95.94,98.906,101.07,102.91,106.42,107.87,112.41,114.82,118.71,121.76,127.6,126.9,131.29,132.91,137.33,138.91,140.12,140.91,144.24,146.92,150.36,151.96,157.25,158.93,162.5,164.93,167.26,168.93,173.04,174.97,178.49,180.95,183.84,186.21,190.23,192.22,195.08,196.97,200.59,204.38,207.2,208.98,209.98,209.99,222.02,223.02,226.03,227.03,232.04,231.04,238.03,237.05,239.05,241.06,244.06,249.08,252.08,252.08,257.1,258.1,259.1,262.11,267.12,268.13,271.13,270.13,277.15,276.15,A1,A1,283.17,285.18,B1,B1,293.2,C1,C1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.0141,3.016,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71.0787,156.18828,114.10364,115.0877,103.1447,128.13052,129.11458,57.05182,137.14158,113.15934,113.15934,128.17428,131.19846,147.17646,97.11658,87.0777,101.10458,186.2134,163.17546,99.13246]);o_.Ko=XI(II(h_.fK,1),B0,5,15,[0,1.007825,4.0026,7.016003,9.012182,11.009305,12,14.003074,15.994915,18.998403,19.992435,22.989767,23.985042,26.98153,27.976927,30.973762,31.97207,34.968852,39.962384,38.963707,39.962591,44.95591,47.947947,50.943962,51.940509,54.938047,55.934939,58.933198,57.935346,62.939598,63.929145,68.92558,73.921177,74.921594,79.91652,78.918336,83.911507,84.911794,87.905619,88.905849,89.904703,92.906377,97.905406,89.92381,101.904348,102.9055,105.903478,106.905092,113.903357,114.90388,119.9022,120.903821,129.906229,126.904473,131.904144,132.905429,137.905232,138.906346,139.905433,140.907647,141.907719,135.92398,151.919729,152.921225,157.924099,158.925342,163.929171,164.930319,165.93029,168.934212,173.938859,174.94077,179.946545,180.947992,183.950928,186.955744,191.961467,192.962917,194.964766,196.966543,201.970617,204.974401,207.976627,208.980374,193.98818,195.99573,199.9957,201.00411,206.0038,210.00923,232.038054,216.01896,238.050784,229.03623,232.041169,237.05005,238.05302,242.06194,240.06228,243.06947,243.07446,248.08275,251.08887,253.09515,257.10295,257.10777,271.13,270.13,277.15,276.15,A1,A1,283.17,285.18,B1,B1,291.2,C1,C1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.014,3.01605,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]);o_.Lo=XI(II(h_.hK,1),k0,5,15,[6,1,7,8]);};o_.Oo=function Oo(a){var b,c;c=a.a;for(b=0;b<a.b.length;b++)c+=a.b[b]*o_.Ko[a.c[b]];return c;};o_.Po=function Po(a){var b,c;b=new i_._R();for(c=0;c<a.b.length;c++){i_.$R(b,(o_.Li(),o_.Gi)[a.c[c]]);a.b[c]>1&&i_.ZR(b,a.b[c]);}return b.a;};o_.Qo=function Qo(a){var b,c;c=a.d;for(b=0;b<a.b.length;b++)c+=a.b[b]*o_.Mo[a.c[b]];return c;};o_.Ro=function Ro(a){var b,c,d,e,f,g,h,i,j,k,l;o_.Jr(a,1);e=OI(h_.hK,k0,5,191,15,1);for(c=0;c<a.o;c++){switch(a.A[c]){case 171:e[1]+=5;e[6]+=3;e[7]+=1;e[8]+=1;break;case 172:e[1]+=12;e[6]+=6;e[7]+=4;e[8]+=1;break;case 173:e[1]+=6;e[6]+=4;e[7]+=2;e[8]+=2;break;case 174:e[1]+=5;e[6]+=4;e[7]+=1;e[8]+=3;break;case 175:e[1]+=5;e[6]+=3;e[7]+=1;e[8]+=1;e[16]+=1;break;case 176:e[1]+=8;e[6]+=5;e[7]+=2;e[8]+=2;break;case 177:e[1]+=7;e[6]+=5;e[7]+=1;e[8]+=3;break;case 178:e[1]+=3;e[6]+=2;e[7]+=1;e[8]+=1;break;case 179:e[1]+=7;e[6]+=6;e[7]+=3;e[8]+=1;break;case 181:case 180:e[1]+=11;e[6]+=6;e[7]+=1;e[8]+=1;break;case 182:e[1]+=12;e[6]+=6;e[7]+=2;e[8]+=1;break;case 183:e[1]+=9;e[6]+=5;e[7]+=1;e[8]+=1;e[16]+=1;break;case 184:e[1]+=9;e[6]+=9;e[7]+=1;e[8]+=1;break;case 185:e[1]+=7;e[6]+=5;e[7]+=1;e[8]+=1;break;case 186:e[1]+=5;e[6]+=3;e[7]+=1;e[8]+=2;break;case 187:e[1]+=7;e[6]+=4;e[7]+=1;e[8]+=2;break;case 188:e[1]+=10;e[6]+=11;e[7]+=2;e[8]+=1;break;case 189:e[1]+=9;e[6]+=9;e[7]+=1;e[8]+=2;break;case 190:e[1]+=9;e[6]+=5;e[7]+=1;e[8]+=1;break;case 1:switch(a.v[c]){case 0:case 1:++e[1];break;case 2:++e[151];break;case 3:++e[152];}break;default:++e[a.A[c]];}}for(d=0;d<a.o;d++)a.A[d]>=171&&a.A[d]<=190?e[1]+=2-o_.Sm(a,d):e[1]+=o_.Nm(a,d);h=0;for(j=1;j<=190;j++)e[j]!=0&&++h;this.b=OI(h_.hK,k0,5,h,15,1);this.c=OI(h_.hK,k0,5,h,15,1);h=0;for(i=0;i<o_.Lo.length;i++){if(e[o_.Lo[i]]!=0){this.b[h]=e[o_.Lo[i]];this.c[h]=o_.Lo[i];++h;e[o_.Lo[i]]=0;}}while(true){l='zzz';k=-1;for(g=1;g<=190;g++)if(e[g]>0&&i_.CR(l,(o_.Li(),o_.Gi)[g])>0){l=(o_.Li(),o_.Gi)[g];k=g;}if(k==-1)break;this.b[h]=e[k];this.c[h]=k;++h;e[k]=0;}this.a=0;this.d=0;for(b=0;b<a.d;b++){if(a.A[b]!=1&&a.v[b]!=0){g=a.A[b];f=a.v[b];this.a+=o_.Jo(g,f)-o_.Ko[g];this.d+=o_.Jo(g,f)-o_.Mo[g];}}};xO(82,1,{82:1});_.gb=function So(a){var b;if(a===this)return true;if(!VJ(a,82))return false;for(b=0;b<this.b.length;b++)if(this.b[b]!=a.b[b])return false;return true;};_.a=0;_.d=0;h_.IK=jQ(82);o_.To=function To(a,b){var c,d;d=F_.KU(a.b,b);for(c=n_.V$(d).length;c<10;c++)i_.cS(a.a,32);i_.gS(a.a,d);};o_.Uo=function Uo(a,b){var c,d,e;if(b<0||b>999){i_.gS(a.a,'  ?');return;}c=false;for(d=0;d<3;d++){e=b/100|0;if(e==0){d==2||c?i_.cS(a.a,48):i_.cS(a.a,32);}else {i_.cS(a.a,48+e&f0);c=true;}b=10*(b%100);}};o_.Vo=function Vo(a,b){C_.uP(b,a.a.a);};o_.Wo=function Wo(a){o_.Xo.call(this,a);};o_.Xo=function Xo(a){o_.Zo.call(this,a,new i_.kS());};o_.Yo=function Yo(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X;this.b=new F_.MU((L=D1,L));o_.Jr(a,15);J=true;for(e=0;e<a.d;e++){if((a.s[e]&3)!=0&&(a.s[e]&3)!=3&&(a.s[e]&Y0)>>19!=1){J=false;break;}}M=-1;if(J){C=OI(h_.hK,k0,5,32,15,1);N=0;for(f=0;f<a.d;f++){if((a.s[f]&3)!=0&&(a.s[f]&3)!=3&&(a.s[f]&Y0)>>19==1){F=(a.s[f]&Y0)>>19!=1&&(a.s[f]&Y0)>>19!=2?-1:(a.s[f]&m1)>>21;++C[F];if(N<C[F]){N=C[F];M=F;}break;}}}this.a=!c?new i_.jS():c;P=a.N!=null?a.N:'';i_.gS(this.a,P+J_);i_.gS(this.a,'Actelion Java MolfileCreator 1.0\n\n');o_.Uo(this,a.o);o_.Uo(this,a.p);i_.gS(this.a,'  0  0');o_.Uo(this,J?0:1);i_.gS(this.a,'  0  0  0  0  0999 V2000\n');G=a.o==1;for(h=1;h<a.o;h++){if(a.H[h].a!=a.H[0].a||a.H[h].b!=a.H[0].b||a.H[h].c!=a.H[0].c){G=true;break;}}D=1;if(G){if(b!=0){D=b;}else {q=o_.Kj(a,a.o,a.p,(o_.Li(),o_.Ki));if(q!=0){(q<1||q>3)&&(D=1.5/q);}else {O=p1;for(f=1;f<a.o;f++){for(g=0;g<f;g++){w=a.H[g].a-a.H[f].a;A=a.H[g].b-a.H[f].b;B=a.H[g].c-a.H[f].c;v=w*w+A*A+B*B;O>v&&(O=v);}}D=3/O;}}}for(i=0;i<a.o;i++){if(G){o_.To(this,D*a.H[i].a);o_.To(this,D*-a.H[i].b);o_.To(this,D*-a.H[i].c);}else {i_.gS(this.a,'    0.0000    0.0000    0.0000');}if((a.t==null?null:a.t[i])!=null)i_.gS(this.a,' L  ');else if((a.w[i]&1)!=0)i_.gS(this.a,' A  ');else {o=(o_.Li(),o_.Gi)[a.A[i]];i_.gS(this.a,' '+o);n_.V$(o).length==1?i_.gS(this.a,'  '):n_.V$(o).length==2&&i_.gS(this.a,' ');}i_.gS(this.a,' 0  0  0');H=K0&a.w[i];H==0?i_.gS(this.a,'  0'):H==384?i_.gS(this.a,'  3'):H==128?i_.gS(this.a,'  2'):H==1792?i_.gS(this.a,'  1'):H==1664&&i_.gS(this.a,'  2');i_.gS(this.a,(a.w[i]&J0)!=0?'  1':'  0');X=((a.s[i]&l1)>>>28)-1;X==-1?i_.gS(this.a,'  0'):X==0?i_.gS(this.a,' 15'):o_.Uo(this,X);i_.gS(this.a,'  0  0  0');o_.Uo(this,$wnd.Math.abs(a.u[i]));i_.gS(this.a,'  0  0\n');}for(r=0;r<a.p;r++){switch(a.F[r]){case 1:R=1;U=0;break;case 2:R=2;U=0;break;case 4:R=3;U=0;break;case 9:R=1;U=6;break;case 17:R=1;U=1;break;case 26:R=2;U=3;break;case 64:R=4;U=0;break;case 32:R=8;U=0;break;default:R=1;U=0;}if(J&&(U==1||U==6)){f=a.B[0][r];(a.s[f]&Y0)>>19==2?U=0:(a.s[f]&Y0)>>19==1&&((a.s[f]&Y0)>>19!=1&&(a.s[f]&Y0)>>19!=2?-1:(a.s[f]&m1)>>21)!=M&&(U=4);}s=a.D[r]&31;s!=0&&(s==8?R=4:s==3?R=5:s==9?R=6:s==10?R=7:R=8);T=a.D[r]&96;W=T==0?0:T==64?1:2;o_.Uo(this,1+a.B[0][r]);o_.Uo(this,1+a.B[1][r]);o_.Uo(this,R);o_.Uo(this,U);i_.gS(this.a,'  0');o_.Uo(this,W);i_.gS(this.a,'  0\n');}Q=0;for(j=0;j<a.o;j++)a.q[j]!=0&&++Q;if(Q!=0){u=0;for(f=0;f<a.o;f++){if(a.q[f]!=0){if(u==0){i_.gS(this.a,'M  CHG');o_.Uo(this,$wnd.Math.min(8,Q));}i_.gS(this.a,' ');o_.Uo(this,f+1);t=a.q[f];if(t<0){i_.gS(this.a,'  -');t=-t;}else i_.gS(this.a,'   ');i_.cS(this.a,48+t&f0);--Q;if(++u==8||Q==0){u=0;i_.gS(this.a,J_);}}}}Q=0;for(k=0;k<a.o;k++)a.v[k]==0||++Q;if(Q!=0){u=0;for(f=0;f<a.o;f++){if(a.v[f]!=0){if(u==0){i_.gS(this.a,'M  ISO');o_.Uo(this,$wnd.Math.min(8,Q));}i_.gS(this.a,' ');o_.Uo(this,f+1);i_.gS(this.a,' ');o_.Uo(this,a.v[f]);--Q;if(++u==8||Q==0){u=0;i_.gS(this.a,J_);}}}}Q=0;for(l=0;l<a.o;l++)(a.s[l]&48)!=0&&++Q;if(Q!=0){u=0;for(d=0;d<a.o;d++){if((a.s[d]&48)!=0){if(u==0){i_.gS(this.a,'M  RAD');o_.Uo(this,$wnd.Math.min(8,Q));}i_.gS(this.a,' ');o_.Uo(this,d+1);switch(a.s[d]&48){case 16:i_.gS(this.a,'   1');break;case 32:i_.gS(this.a,'   2');break;case 48:i_.gS(this.a,'   3');}--Q;if(++u==8||Q==0){u=0;i_.gS(this.a,J_);}}}}if(a.I){Q=0;for(f=0;f<a.o;f++)(a.w[f]&120)!=0&&++Q;if(Q!=0){u=0;for(g=0;g<a.o;g++){S=a.w[g]&120;if(S!=0){if(u==0){i_.gS(this.a,'M  RBC');o_.Uo(this,$wnd.Math.min(8,Q));}i_.gS(this.a,' ');o_.Uo(this,g+1);switch(S){case 112:i_.gS(this.a,'  -1');break;case 8:i_.gS(this.a,'   1');break;case 104:i_.gS(this.a,'   2');break;case 88:i_.gS(this.a,'   3');break;case 56:i_.gS(this.a,'   4');}--Q;if(++u==8||Q==0){u=0;i_.gS(this.a,J_);}}}}for(m=0;m<a.o;m++){p=a.t==null?null:a.t[m];if(p!=null){i_.gS(this.a,'M  ALS ');o_.Uo(this,m+1);o_.Uo(this,p.length);i_.gS(this.a,(a.w[m]&1)!=0?' T ':' F ');for(I=0;I<p.length;I++){K=(o_.Li(),o_.Gi)[p[I]];switch(n_.V$(K).length){case 1:i_.gS(this.a,K+'   ');break;case 2:i_.gS(this.a,K+'  ');break;case 3:i_.gS(this.a,K+' ');break;default:i_.gS(this.a,'   ?');}}i_.gS(this.a,J_);}}Q=0;for(n=0;n<a.o;n++)(a.w[n]&6144)!=0&&++Q;if(Q!=0){u=0;for(d=0;d<a.o;d++){V=a.w[d]&6144;if(V!=0){if(u==0){i_.gS(this.a,'M  SUB');o_.Uo(this,$wnd.Math.min(8,Q));}i_.gS(this.a,' ');o_.Uo(this,d+1);(V&b0)!=0?i_.gS(this.a,'   '+(a.c[d]+1)):i_.gS(this.a,'  -2');--Q;if(++u==8||Q==0){u=0;i_.gS(this.a,J_);}}}}}i_.gS(this.a,E1);};o_.Zo=function Zo(a,b){o_.Yo.call(this,a,0,b);};xO(70,1,{},o_.Wo,o_.Yo);h_.KK=jQ(70);o_.$o=function $o(a,b,c,d,e,f){var g,h,i,j;j=1;h=false;switch(e){case 1:j=17;break;case 3:j=26;break;case 4:j=17;h=true;break;case 6:j=9;break;default:switch(d){case 1:j=1;break;case 2:j=2;break;case 3:j=4;break;case 4:j=64;break;case 9:j=32;}}g=o_.Pi(a.f,b,c,j);i=0;h&&o_.$k(a.f,b,1,-1);if(d>4){switch(d){case 5:i|=3;break;case 6:i|=9;break;case 7:i|=10;break;case 8:j!=32&&(i|=31);}}f==1&&(i|=64);f==2&&(i|=32);i!=0&&o_.vl(a.f,g,i,true);return g;};o_._o=function _o(a){var b,c,d,e,f,g,h,i,j,k,l;g=OI(h_.hK,k0,5,a.f.o,15,1);for(c=0;c<a.f.o;c++)g[c]=-o_.rj(a.f,c);o_.$d(new o_.ie(a.f),null,true);for(d=0;d<a.f.o;d++)g[d]+=o_.rj(a.f,d);for(b=0;b<a.f.o;b++){if(g[b]!=0){h=-g[b];for(e=0;e<a.f.p;e++){for(j=0;j<2;j++){if(h>0&&o_.Yj(a.f,e)==32&&o_.Nj(a.f,1-j,e)==b){l=o_.Nj(a.f,j,e);if(o_.xk(a.f,l)){k=o_.bp(a,l);f=o_.rj(a.f,l);if(f<k){i=$wnd.Math.min(h,k-f);o_.Vk(a.f,l,f+i);h-=i;}}}}}}}};o_.ap=function ap(a,b){a.f=null;return o_.sp(a,new C_.pP(new C_.tP(b)))?a.f:null;};o_.bp=function bp(a,b){var c,d;c=o_.Ij(a.f,b);d=c<(o_.Li(),o_.Ii).length?o_.Ii[c]:null;return d==null?0:d[d.length-1];};o_.cp=function cp(a,b){var c;c=!a.a?null:l_.hW(a.a,new i_.dR(b));return !c?b-1:c.a;};o_.dp=function dp(a,b){var c;c=!a.b?null:l_.hW(a.b,new i_.dR(b));return !c?b-1:c.a;};o_.ep=function ep(a,b){var c,d;if(b!=null){o_.Jr(a.f,1);for(c=0;c<a.f.d;c++){if(b[c]!=0){d=o_.ak(a.f,c,o_.Sm(a.f,c));b[c]==15?d>=0&&o_.Tk(a.f,c,0):b[c]!=o_.bk(a.f,c)&&o_.Tk(a.f,c,b[c]-d);}}}};o_.fp=function fp(a,b){var c;if(b==-1){return -1;}for(c=b+1;c<n_.V$(a).length;c++){n_.S$(c,n_.V$(a).length);if(n_.V$(a).charCodeAt(c)!=32&&(n_.S$(c,n_.V$(a).length),n_.V$(a).charCodeAt(c)!=9)){return c;}}return -1;};o_.gp=function gp(a,b){var c;for(c=b;c<n_.V$(a).length;c++){n_.S$(c,n_.V$(a).length);if(n_.V$(a).charCodeAt(c)==32||(n_.S$(c,n_.V$(a).length),n_.V$(a).charCodeAt(c)==9)){return c;}}return -1;};o_.hp=function hp(a){if(n_.V$(a).indexOf('ATOMS=(')!=-1)return F1;if(n_.V$(a).indexOf('BONDS=(')!=-1)return 'BONDS';return null;};o_.ip=function ip(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F;p=0;q=(h=o_.gp(b,p+1),h==-1?n_.V$(b).length:h);d=i_.CQ(n_.V$(b).substr(p,q-p));p=o_.fp(b,q);q=(i=o_.gp(b,p+1),i==-1?n_.V$(b).length:i);s=n_.V$(b).substr(p,q-p);A=null;e=false;r=o_.pp(b);if(r!=0){A=o_.jp(b);r<0&&(e=true);q=$wnd.Math.abs(r);}p=o_.fp(b,q);q=(j=o_.gp(b,p+1),j==-1?n_.V$(b).length:j);C=ZQ(n_.V$(b).substr(p,q-p));p=o_.fp(b,q);q=(k=o_.gp(b,p+1),k==-1?n_.V$(b).length:k);D=ZQ(n_.V$(b).substr(p,q-p));p=o_.fp(b,q);q=(l=o_.gp(b,p+1),l==-1?n_.V$(b).length:l);F=ZQ(n_.V$(b).substr(p,q-p));p=o_.fp(b,q);q=(m=o_.gp(b,p+1),m==-1?n_.V$(b).length:m);u=i_.CQ(n_.V$(b).substr(p,q-p));c=o_.Mi(a.f,C,-D,-F);c+1!=d&&(!a.a&&(a.a=new l_.yY()),l_.qY(a.a,new i_.dR(d),new i_.dR(c)));A!=null&&o_.al(a.f,c,A,e);u!=0&&o_.bl(a.f,c,u,false);if(i_.GR(s,'A')){o_.fl(a.f,c,1,true);}else if(i_.GR(s,'Q')){t=OI(h_.hK,k0,5,1,15,1);t[0]=6;o_.al(a.f,c,t,true);}else {o_.ml(a.f,c,o_.Yl(s));}while((p=o_.fp(b,q))!=-1){q=(g=o_.gp(b,p+1),g==-1?n_.V$(b).length:g);v=n_.V$(b).substr(p,q-p);o=i_.KR(v,VR(61));n=n_.V$(v).substr(0,o);B=i_.CQ(n_.V$(v).substr(o+1));if(i_.GR(n,'CHG')){o_.Vk(a.f,c,B);}else if(i_.GR(n,'RAD')){switch(B){case 1:o_.gl(a.f,c,16);break;case 2:o_.gl(a.f,c,32);break;case 3:o_.gl(a.f,c,48);}}else if(i_.GR(n,'CFG'));else if(i_.GR(n,'MASS')){o_.dl(a.f,c,B);}else if(i_.GR(n,'VAL')){o_.Tk(a.f,c,B==-1?0:B==0?-1:B);}else if(i_.GR(n,'HCOUNT')){switch(B){case 0:break;case-1:o_.fl(a.f,c,1792,true);break;case 1:o_.fl(a.f,c,128,true);break;case 2:o_.fl(a.f,c,384,true);break;default:o_.fl(a.f,c,896,true);}}else if(i_.GR(n,'SUBST')){if(B==-1){o_.fl(a.f,c,V0,true);}else if(B>0){w=0;for(f=0;f<a.f.p;f++){(o_.Nj(a.f,0,f)==c||o_.Nj(a.f,1,f)==c)&&++w;}B>w&&o_.fl(a.f,c,b0,true);}}else if(i_.GR(n,'RBCNT')){switch(B){case 3:case-1:o_.fl(a.f,c,112,true);break;case 1:o_.fl(a.f,c,8,true);break;case 2:o_.fl(a.f,c,104,true);break;case 4:o_.fl(a.f,c,56,true);}}}};o_.jp=function jp(a){var b,c,d,e,f,g,h,i;h=null;c=n_.V$(a).indexOf('[');d=n_.V$(a).indexOf(']',c);if(c>=0&&d>0){b=OI(h_.hK,k0,5,16,15,1);i=n_.V$(a).substr(c+1,d-(c+1));e=0;g=true;while(g&&e<16){c=n_.V$(i).indexOf(',');f=null;if(c==-1){f=i;g=false;}else {f=n_.V$(i).substr(0,c);i=n_.V$(i).substr(c+1);}b[e++]=o_.Yl(f);}h=OI(h_.hK,k0,5,e,15,1);i_.pS(b,0,h,0,e);}return h;};o_.kp=function kp(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;o=0;p=(i=o_.gp(b,o+1),i==-1?n_.V$(b).length:i);f=i_.CQ(n_.V$(b).substr(o,p-o));o=o_.fp(b,p);p=(j=o_.gp(b,o+1),j==-1?n_.V$(b).length:j);g=i_.CQ(n_.V$(b).substr(o,p-o));o=o_.fp(b,p);p=(k=o_.gp(b,o+1),k==-1?n_.V$(b).length:k);c=o_.cp(a,i_.CQ(n_.V$(b).substr(o,p-o)));o=o_.fp(b,p);p=(l=o_.gp(b,o+1),l==-1?n_.V$(b).length:l);d=o_.cp(a,i_.CQ(n_.V$(b).substr(o,p-o)));r=0;s=0;while((o=o_.fp(b,p))!=-1){p=(h=o_.gp(b,o+1),h==-1?n_.V$(b).length:h);q=n_.V$(b).substr(o,p-o);n=i_.KR(q,VR(61));m=n_.V$(q).substr(0,n);t=i_.CQ(n_.V$(q).substr(n+1));if(i_.GR(m,'CFG')){switch(t){case 1:r=1;break;case 2:r=g==2?3:4;break;case 3:r=6;}}else i_.GR(m,'TOPO')?s=t:undefined;}e=o_.$o(a,c,d,g,r,s);e+1!=f&&(!a.b&&(a.b=new l_.yY()),l_.qY(a.b,new i_.dR(f),new i_.dR(e)));};o_.lp=function lp(a,b){var c,d,e,f,g,h;h=o_.hp(b);if(h!=null){g=o_.np(b,h);if(i_.GR(n_.V$(b).substr(0,13),'MDLV30/STEABS')){if(i_.GR(h,F1))for(f=0;f<g.length;f++)o_.$k(a.f,o_.cp(a,g[f]),0,-1);else for(e=0;e<g.length;e++)o_.ql(a.f,o_.dp(a,g[e]),0,-1);}else if(i_.GR(n_.V$(b).substr(0,13),'MDLV30/STERAC')){d=i_.CQ(i_.SR(b,13,o_.gp(b,13)));if(i_.GR(h,F1))for(f=0;f<g.length;f++)o_.$k(a.f,o_.cp(a,g[f]),1,d-1);else for(e=0;e<g.length;e++)o_.ql(a.f,o_.dp(a,g[e]),1,d-1);}else if(i_.GR(n_.V$(b).substr(0,13),'MDLV30/STEREL')){d=i_.CQ(i_.SR(b,13,o_.gp(b,13)));if(i_.GR(h,F1))for(f=0;f<g.length;f++)o_.$k(a.f,o_.cp(a,g[f]),2,d-1);else for(e=0;e<g.length;e++)o_.ql(a.f,o_.dp(a,g[e]),2,d-1);}else if(i_.GR(n_.V$(b).substr(0,13),'MDLV30/HILITE')){if(i_.GR(h,F1)){for(e=0;e<g.length;e++)o_.Wk(a.f,o_.cp(a,g[e]),448);}else {for(e=0;e<g.length;e++){c=o_.dp(a,g[e]);o_.Wk(a.f,o_.Nj(a.f,0,c),448);o_.Wk(a.f,o_.Nj(a.f,1,c),448);}}}}};o_.mp=function mp(a,b){var c,d,e;if(!a.f){if(i_.GR(n_.V$(b).substr(0,6),'COUNTS')){c=o_.fp(b,o_.gp(b,7));d=i_.CQ(i_.SR(b,7,o_.gp(b,7)));e=i_.CQ(i_.SR(b,c,o_.gp(b,c)));a.f=new o_._r(d,e);}}};o_.np=function np(a,b){var c,d,e,f,g,h;f=n_.V$(a).indexOf(b+'=(')+n_.V$(b).length+2;g=i_.LR(a,VR(41),f);e=o_.gp(a,f);c=i_.CQ(n_.V$(a).substr(f,e-f));h=OI(h_.hK,k0,5,c,15,1);for(d=0;d<c;d++){f=o_.fp(a,e);e=o_.gp(a,f);(e==-1||e>g)&&(e=g);h[d]=i_.CQ(n_.V$(a).substr(f,e-f));}return h;};o_.op=function op(a){var b,c,d,e,f,g,h,i,j;i=OI(h_.hK,k0,5,a.f.o,15,1);for(d=0;d<a.f.p;d++)if(o_.Yj(a.f,d)==64)for(g=0;g<2;g++)i[o_.Nj(a.f,g,d)]=1;for(e=0;e<a.f.p;e++){j=o_.Vj(a.f,e);for(f=0;f<2;f++)i[o_.Nj(a.f,f,e)]+=j;}for(c=0;c<a.f.p;c++){if(o_.Vj(a.f,c)==1){for(f=0;f<2;f++){h=o_.Nj(a.f,1-f,c);if(o_.xk(a.f,h)){b=o_.Nj(a.f,f,c);if(o_.uk(a.f,b)&&i[b]>o_.bk(a.f,b)){o_.wl(a.f,c,32);continue;}}}}}};o_.pp=function pp(a){var b,c;if(n_.V$(a).indexOf('[')>=0){b=n_.V$(a).indexOf(' NOT[');c=n_.V$(a).indexOf(']',b);if(b>=0&&c>0){return -(c+1);}else {b=n_.V$(a).indexOf(' [');c=n_.V$(a).indexOf(']',b);if(b>=0&&c>0){return c+1;}}b=n_.V$(a).indexOf(" 'NOT[");c=n_.V$(a).indexOf("]'",b);if(b>=0&&c>0){return -(c+2);}else {b=n_.V$(a).indexOf(" '[");c=n_.V$(a).indexOf("]'",b);if(b>=0&&c>0){return c+2;}}i_.oS();}return 0;};o_.qp=function qp(a,b,c){a.f=b;return o_.sp(a,c);};o_.rp=function rp(a){return n_.V$(a).length==0?0:i_.CQ(a);};o_.sp=function sp(b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X;S=null;try{b.d=null;if(b.f){o_._i(b.f);o_.yl(b.f,false);}D=w=C_.oP(c);if(null==D){return false;}if(null==(w=C_.oP(c))){return false;}if(null==(w=C_.oP(c))){return false;}b.g=n_.V$(w).indexOf("From CSD data. Using bond type 'Any'")!=-1;b.c=n_.V$(w).indexOf('From CSD data.')!=-1;if(null==(w=C_.oP(c))){return false;}try{F=i_.CQ(i_.TR(n_.V$(w).substr(0,3)));G=i_.CQ(i_.TR(n_.V$(w).substr(3,3)));H=o_.rp(i_.TR(n_.V$(w).substr(6,3)));n=o_.rp(i_.TR(n_.V$(w).substr(12,3)));T=n_.V$(w).length>=39&&i_.GR(n_.V$(w).substr(34,5),'V3000')?3:2;}catch(a){a=HN(a);if(VJ(a,13)){return false;}else throw IN(a);}if(T==3){K=o_.tp(b,c);o_.El(b.f,D);return K;}!b.f&&(b.f=new o_._r(F,G));o_.El(b.f,D);n==0&&(b.f.J=true);if(0==F){while(w!=null&&!(i_.GR(w,G1)||i_.GR(w,H1)||i_.GR(n_.V$(w).substr(1),'$'))){w=C_.oP(c);}return true;}for(r=0;r<F;r++){if(null==(w=C_.oP(c))){return false;}V=ZQ(i_.TR(n_.V$(w).substr(0,10)));W=ZQ(i_.TR(n_.V$(w).substr(10,10)));X=ZQ(i_.TR(n_.V$(w).substr(20,10)));e=o_.Mi(b.f,V,-W,-X);v=i_.TR(n_.V$(w).substr(31,3));h=o_.Yl(v);o_.ml(b.f,e,h);i_.GR(v,'A')&&o_.fl(b.f,e,1,true);C=o_.rp(i_.TR(n_.V$(w).substr(34,2)));C!=0&&o_.dl(b.f,e,(o_.Li(),o_.Ji)[h]+C);m=o_.rp(i_.TR(n_.V$(w).substr(36,3)));m!=0&&o_.Vk(b.f,e,4-m);A=n_.V$(w).length<63?0:o_.rp(i_.TR(n_.V$(w).substr(60,3)));o_.bl(b.f,e,A,false);p=n_.V$(w).length<45?0:o_.rp(i_.TR(n_.V$(w).substr(42,3)));switch(p){case 0:break;case 1:o_.fl(b.f,e,768,true);break;case 2:o_.fl(b.f,e,128,true);break;case 3:o_.fl(b.f,e,384,true);break;default:o_.fl(b.f,e,896,true);}n_.V$(w).length>=48&&(n_.S$(47,n_.V$(w).length),n_.V$(w).charCodeAt(47)==49)&&o_.fl(b.f,e,J0,true);R=n_.V$(w).length<51?0:o_.rp(i_.TR(n_.V$(w).substr(48,3)));if(R!=0){S==null&&(S=OI(h_.hK,k0,5,F,15,1));S[e]=R;}}for(s=0;s<G;s++){if(null==(w=C_.oP(c))){return false;}f=i_.CQ(i_.TR(n_.V$(w).substr(0,3)))-1;g=i_.CQ(i_.TR(n_.V$(w).substr(3,3)))-1;k=i_.CQ(i_.TR(n_.V$(w).substr(6,3)));M=n_.V$(w).length<12?0:o_.rp(i_.TR(n_.V$(w).substr(9,3)));Q=n_.V$(w).length<18?0:o_.rp(i_.TR(n_.V$(w).substr(15,3)));k==8&&(b.g||o_.xk(b.f,f)||o_.xk(b.f,g))&&(k=9);o_.$o(b,f,g,k,M,Q);}for(q=0;q<H;q++){if(null==(w=C_.oP(c))){return false;}}if(null==(w=C_.oP(c))){(b.e&1)!=0&&(b.d=o_.Lm(b.f));o_.ep(b,S);n==0&&o_.Jr(b.f,15);return true;}while(w!=null&&!(i_.GR(w,G1)||i_.GR(w,H1))){if(i_.GR(n_.V$(w).substr(0,6),'M  CHG')){t=i_.CQ(i_.TR(n_.V$(w).substr(6,3)));if(t>0){d=10;U=14;for(u=1;u<=t;++u,d+=8,U+=8){e=i_.CQ(i_.TR(n_.V$(w).substr(d,d+3-d)))-1;l=i_.CQ(i_.TR(n_.V$(w).substr(U,U+3-U)));o_.Vk(b.f,e,l);}}}if(i_.GR(n_.V$(w).substr(0,6),'M  ISO')){t=i_.CQ(i_.TR(n_.V$(w).substr(6,3)));if(t>0){d=10;U=14;for(u=1;u<=t;++u,d+=8,U+=8){e=i_.CQ(i_.TR(n_.V$(w).substr(d,d+3-d)))-1;B=i_.CQ(i_.TR(n_.V$(w).substr(U,U+3-U)));o_.dl(b.f,e,B);}}}if(i_.GR(n_.V$(w).substr(0,6),'M  RAD')){t=i_.CQ(i_.TR(n_.V$(w).substr(6,3)));if(t>0){d=10;U=14;for(u=1;u<=t;++u,d+=8,U+=8){e=i_.CQ(i_.TR(n_.V$(w).substr(d,d+3-d)))-1;J=i_.CQ(i_.TR(n_.V$(w).substr(U,U+3-U)));switch(J){case 1:o_.gl(b.f,e,16);break;case 2:o_.gl(b.f,e,32);break;case 3:o_.gl(b.f,e,48);}}}}if(i_.GR(n_.V$(w).substr(0,6),'M  RBC')||i_.GR(n_.V$(w).substr(0,6),'M  RBD')){t=i_.CQ(i_.TR(n_.V$(w).substr(6,3)));if(t>0){d=10;U=14;for(u=1;u<=t;++u,d+=8,U+=8){e=i_.CQ(i_.TR(n_.V$(w).substr(d,d+3-d)))-1;L=i_.CQ(i_.TR(n_.V$(w).substr(U,U+3-U)));switch(L){case 3:case-1:o_.fl(b.f,e,112,true);break;case 1:o_.fl(b.f,e,8,true);break;case 2:o_.fl(b.f,e,104,true);break;case 4:o_.fl(b.f,e,56,true);}}}}if(i_.GR(n_.V$(w).substr(0,6),'M  ALS')){e=i_.CQ(i_.TR(n_.V$(w).substr(7,3)))-1;if(e>=0){I=i_.CQ(i_.TR(n_.V$(w).substr(10,3)));i=(n_.S$(14,n_.V$(w).length),n_.V$(w).charCodeAt(14)==84);R=OI(h_.hK,k0,5,I,15,1);d=16;for(u=0;u<I;++u,d+=4){P=i_.TR(n_.V$(w).substr(d,d+4-d));R[u]=o_.Yl(P);}o_.al(b.f,e,R,i);}}if(i_.GR(n_.V$(w).substr(0,6),'M  SUB')){t=i_.CQ(i_.TR(n_.V$(w).substr(6,3)));if(t>0){d=10;U=14;for(u=1;u<=t;++u,d+=8,U+=8){e=i_.CQ(i_.TR(n_.V$(w).substr(d,d+3-d)))-1;N=i_.CQ(i_.TR(n_.V$(w).substr(U,U+3-U)));if(N==-2){o_.fl(b.f,e,V0,true);}else if(N>0){O=0;for(j=0;j<b.f.p;j++){(o_.Nj(b.f,0,j)==e||o_.Nj(b.f,1,j)==e)&&++O;}N>O&&o_.fl(b.f,e,b0,true);}}}}w=C_.oP(c);}}catch(a){a=HN(a);if(VJ(a,13)){o=a;i_.mG(o,(i_.oS(),i_.nS),'');return false;}else throw IN(a);}if(b.c){o_.op(b);o_._o(b);}(b.e&1)!=0&&(b.d=o_.Lm(b.f));o_.ep(b,S);o_.Jr(b.f,15);return true;};o_.tp=function tp(a,b){var c,d,e,f,g;!!a.a&&l_.jY(a.a);!!a.b&&l_.jY(a.b);e=0;d=C_.oP(b);while(d!=null&&i_.GR(n_.V$(d).substr(0,7),I1)){d=i_.TR(n_.V$(d).substr(7));while(g=n_.V$('-').length,i_.GR(n_.V$(d).substr(n_.V$(d).length-g,g),'-')){c=C_.oP(b);if(!i_.GR(n_.V$(c).substr(0,7),I1)){return false;}d=i_.TR(i_.ER(i_.SR(d,0,n_.V$(d).length-1),n_.V$(c).substr(7)));}if(i_.GR(n_.V$(d).substr(0,5),'BEGIN')){f=i_.TR(n_.V$(d).substr(6));if(i_.GR(n_.V$(f).substr(0,4),'CTAB')){e=1;}else if(i_.GR(n_.V$(f).substr(0,4),'ATOM')){e=2;}else if(i_.GR(n_.V$(f).substr(0,4),'BOND')){e=3;}else if(i_.GR(n_.V$(f).substr(0,10),'COLLECTION')){e=4;}else {return false;}}else if(i_.GR(n_.V$(d).substr(0,3),'END')){e=0;}else if(e==1){o_.mp(a,d);}else if(e==2){o_.ip(a,d);}else if(e==3){o_.kp(a,d);}else if(e==4){o_.lp(a,d);}else {return false;}d=C_.oP(b);}while(d!=null&&!(i_.GR(n_.V$(d).substr(0,6),G1)||i_.GR(d,H1))){d=C_.oP(b);}return true;};o_.up=function up(){this.e=0;};o_.vp=function vp(){this.e=1;};xO(68,1,{},o_.up,o_.vp);_.c=false;_.e=0;_.g=false;h_.LK=jQ(68);o_.wp=function wp(a){};o_.xp=function xp(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I;i_.gS(a.a,'M  V30 BEGIN CTAB\n');i_.gS(a.a,J1+b.o+' '+b.p+' 0 0 0\n');i_.gS(a.a,'M  V30 BEGIN ATOM\n');for(i=0;i<b.o;i++){i_.gS(a.a,I1+(i+1));if((b.t==null?null:b.t[i])!=null){k=b.t==null?null:b.t[i];t=(b.w[i]&1)!=0;i_.gS(a.a,t?' NOT[':' [');for(r=0;r<k.length;r++){r>0&&i_.gS(a.a,',');s=(o_.Li(),o_.Gi)[k[r]];switch(n_.V$(s).length){case 2:case 3:case 1:i_.gS(a.a,s);break;default:i_.gS(a.a,'?');}}i_.gS(a.a,']');}else (b.w[i]&1)!=0?i_.gS(a.a,' A'):i_.gS(a.a,' '+(o_.Li(),o_.Gi)[b.A[i]]);if(c){i_.gS(a.a,' '+cK(g0*a.b*b.H[i].a)/g0);i_.gS(a.a,' '+cK(g0*a.b*-b.H[i].b)/g0);i_.gS(a.a,' '+cK(g0*a.b*-b.H[i].c)/g0);}else {i_.gS(a.a,' 0 0 0');}i_.gS(a.a,' '+$wnd.Math.abs(b.u[i]));b.q[i]!=0&&i_.gS(a.a,' CHG='+b.q[i]);if((b.s[i]&48)!=0){i_.gS(a.a,' RAD=');switch(b.s[i]&48){case 16:i_.gS(a.a,'1');break;case 32:i_.gS(a.a,'2');break;case 48:i_.gS(a.a,'3');}}if((b.s[i]&3)==1||(b.s[i]&3)==2){i_.gS(a.a,' CFG=');(b.s[i]&3)==1?i_.gS(a.a,'1'):i_.gS(a.a,'2');}b.v[i]!=0&&i_.gS(a.a,' MASS='+b.v[i]);I=((b.s[i]&l1)>>>28)-1;I!=-1&&i_.gS(a.a,' VAL='+(I==0?'-1':i_.nR(I)));q=K0&b.w[i];q==384?i_.gS(a.a,' HCOUNT=2'):q==128?i_.gS(a.a,' HCOUNT=1'):q==1792?i_.gS(a.a,' HCOUNT=-1'):q==1664&&i_.gS(a.a,' HCOUNT=1');F=b.w[i]&6144;F!=0&&((F&b0)!=0?i_.gS(a.a,' SUBST='+(b.c[i]+1)):i_.gS(a.a,' SUBST=-1'));B=b.w[i]&120;if(B!=0){switch(B){case 112:i_.gS(a.a,' RBCNT=-1');break;case 104:case 8:i_.gS(a.a,' RBCNT=2');break;case 88:i_.gS(a.a,' RBCNT=3');break;case 56:i_.gS(a.a,' RBCNT=4');}}i_.gS(a.a,J_);}i_.gS(a.a,'M  V30 END ATOM\n');i_.gS(a.a,'M  V30 BEGIN BOND\n');for(m=0;m<b.p;m++){i_.gS(a.a,I1+(m+1));switch(b.F[m]){case 1:w=1;D=0;break;case 2:w=2;D=0;break;case 4:w=3;D=0;break;case 9:w=1;D=3;break;case 17:w=1;D=1;break;case 26:w=2;D=2;break;case 64:w=4;D=0;break;case 32:w=9;D=0;break;default:w=1;D=0;}o=b.D[m]&31;o!=0&&(o==8?w=4:o==3?w=5:o==9?w=6:o==10?w=7:w=8);i_.gS(a.a,' '+w+' '+(b.B[0][m]+1)+' '+(b.B[1][m]+1));D!=0&&i_.gS(a.a,' CFG='+D);C=b.D[m]&96;G=C==0?0:C==64?1:2;G!=0&&i_.gS(a.a,' TOPO='+G);i_.gS(a.a,J_);}i_.gS(a.a,'M  V30 END BOND\n');A=false;d=0;u=OI(h_.hK,k0,5,32,15,1);f=OI(h_.hK,k0,5,32,15,1);for(j=0;j<b.d;j++){if((b.s[j]&3)==1||(b.s[j]&3)==2){A=true;H=(b.s[j]&Y0)>>19;H==1?++f[(b.s[j]&Y0)>>19!=1&&(b.s[j]&Y0)>>19!=2?-1:(b.s[j]&m1)>>21]:H==2?++u[(b.s[j]&Y0)>>19!=1&&(b.s[j]&Y0)>>19!=2?-1:(b.s[j]&m1)>>21]:++d;}}e=0;v=OI(h_.hK,k0,5,32,15,1);g=OI(h_.hK,k0,5,32,15,1);for(n=0;n<b.e;n++){if(o_.Vj(b,n)!=2&&((b.C[n]&3)==1||(b.C[n]&3)==2)){A=true;H=(b.C[n]&n1)>>10;H==1?++g[(b.C[n]&n1)>>10!=1&&(b.C[n]&n1)>>10!=2?-1:(b.C[n]&o1)>>12]:H==2?++v[(b.C[n]&n1)>>10!=1&&(b.C[n]&n1)>>10!=2?-1:(b.C[n]&o1)>>12]:++e;}}if(A){i_.gS(a.a,'M  V30 BEGIN COLLECTION\n');if(d!=0){i_.gS(a.a,'M  V30 MDLV30/STEABS ATOMS=('+d);for(h=0;h<b.d;h++){((b.s[h]&3)==1||(b.s[h]&3)==2)&&(b.s[h]&Y0)>>19==0&&i_.gS(a.a,' '+(h+1));}i_.gS(a.a,K1);}if(e!=0){i_.gS(a.a,'M  V30 MDLV30/STEABS BONDS=('+e);for(l=0;l<b.e;l++){o_.Vj(b,l)!=2&&((b.C[l]&3)==1||(b.C[l]&3)==2)&&(b.C[l]&n1)>>10==0&&i_.gS(a.a,' '+(l+1));}i_.gS(a.a,K1);}for(p=0;p<32;p++){if(u[p]!=0){i_.gS(a.a,L1+(p+1)+' ATOMS=('+u[p]);for(h=0;h<b.d;h++){((b.s[h]&3)==1||(b.s[h]&3)==2)&&(b.s[h]&Y0)>>19==2&&((b.s[h]&Y0)>>19!=1&&(b.s[h]&Y0)>>19!=2?-1:(b.s[h]&m1)>>21)==p&&i_.gS(a.a,' '+(h+1));}i_.gS(a.a,K1);}if(f[p]!=0){i_.gS(a.a,M1+(p+1)+' ATOMS=('+f[p]);for(h=0;h<b.d;h++){((b.s[h]&3)==1||(b.s[h]&3)==2)&&(b.s[h]&Y0)>>19==1&&((b.s[h]&Y0)>>19!=1&&(b.s[h]&Y0)>>19!=2?-1:(b.s[h]&m1)>>21)==p&&i_.gS(a.a,' '+(h+1));}i_.gS(a.a,K1);}if(v[p]!=0){i_.gS(a.a,L1+(p+1)+' BONDS=('+v[p]);for(l=0;l<b.e;l++){o_.Vj(b,l)!=2&&((b.C[l]&3)==1||(b.C[l]&3)==2)&&(b.C[l]&n1)>>10==2&&((b.C[l]&n1)>>10!=1&&(b.C[l]&n1)>>10!=2?-1:(b.C[l]&o1)>>12)==p&&i_.gS(a.a,' '+(l+1));}i_.gS(a.a,K1);}if(g[p]!=0){i_.gS(a.a,M1+(p+1)+' BONDS=('+g[p]);for(l=0;l<b.e;l++){o_.Vj(b,l)!=2&&((b.C[l]&3)==1||(b.C[l]&3)==2)&&(b.C[l]&n1)>>10==1&&((b.C[l]&n1)>>10!=1&&(b.C[l]&n1)>>10!=2?-1:(b.C[l]&o1)>>12)==p&&i_.gS(a.a,' '+(l+1));}i_.gS(a.a,K1);}}i_.gS(a.a,'M  V30 END COLLECTION\n');}i_.gS(a.a,'M  V30 END CTAB\n');};o_.yp=function yp(){o_.wp(this);this.a=new i_.kS();};o_.zp=function zp(a){o_.Ap.call(this,a);};o_.Ap=function Ap(a){o_.Bp.call(this,a,new i_.kS());};o_.Bp=function Bp(a,b){var c,d;o_.wp(this);o_.Jr(a,15);this.a=b;d=a.N!=null?a.N:'';i_.gS(this.a,d+J_);i_.gS(this.a,'Actelion Java MolfileCreator 2.0\n\n');i_.gS(this.a,'  0  0  0  0  0  0              0 V3000\n');this.b=1;c=o_.Dp(a);c&&(this.b=o_.Cp(a));o_.xp(this,a,c);i_.gS(this.a,E1);};o_.Cp=function Cp(a){var b,c,d,e,f,g,h,i,j;j=1;d=o_.Kj(a,a.o,a.p,(o_.Li(),o_.Ki));if(d!=0){(d<1||d>3)&&(j=1.5/d);}else {i=N1;for(b=1;b<a.o;b++){for(c=0;c<b;c++){f=a.H[c].a-a.H[b].a;g=a.H[c].b-a.H[b].b;h=a.H[c].c-a.H[b].c;e=f*f+g*g+h*h;i>e&&(i=e);}}j=3/i;}return j;};o_.Dp=function Dp(a){var b;if(a.o==1)return true;for(b=1;b<a.o;b++){if(a.H[b].a!=a.H[0].a||a.H[b].b!=a.H[0].b||a.H[b].c!=a.H[0].c){return true;}}return false;};o_.Ep=function Ep(a,b){var c;c=new o_.yp();c.b=b;o_.Jr(a,15);o_.xp(c,a,true);return c.a.a;};xO(79,1,{},o_.yp,o_.zp);_.b=1;h_.MK=jQ(79);o_.Fp=function Fp(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;k=a.g.K;l=0;for(f=0;f<c;f++){if(k>b[f]){k=b[f];l=f;}}p=OI(h_.hK,k0,5,c,15,1);j=l>0?l-1:c-1;m=l<c-1?l+1:0;h=b[j]<b[m];for(g=0;g<c;g++){p[g]=b[l];h?--l<0&&(l=c-1):++l==c&&(l=0);}for(e=0;e<a.i.a.length;e++){o=l_.Th(a.i,e);if(o.length!=c)continue;d=true;for(i=0;i<c;i++){if(o[i]!=p[i]){d=false;break;}}if(d)return;}l_.Oh(a.i,p);n=o_.Rp(a,p);l_.Oh(a.j,n);o_.$p(a,p,n);};o_.Gp=function Gp(a,b,c){var d,e,f,g,h,i,j;i=OI(h_.hK,k0,5,a.f,15,1);g=OI(h_.hK,k0,5,a.f,15,1);j=OI(h_.DN,C0,5,a.g.d,16,1);d=o_.Nj(a.g,0,b);e=o_.Nj(a.g,1,b);i[0]=d;i[1]=e;g[1]=-1;j[e]=true;h=1;while(h>=1){++g[h];if(g[h]==o_.Am(a.g,i[h])){j[i[h]]=false;--h;continue;}f=o_.zm(a.g,i[h],g[h]);if(j[f]||c[f])continue;if(f==d&&h>1){o_.Fp(a,i,h+1);if(a.i.a.length>=L0)return;continue;}if(h+1<a.f){++h;i[h]=f;j[f]=true;g[h]=-1;}}};o_.Hp=function Hp(a,b,c,d,e,f,g,h){var i,j,k,l,m,n,o,p,q,r,s,t,u,v,w;t=l_.Th(a.i,b);u=l_.Th(a.j,b);v=u.length;k=0;j=0;w=false;for(r=0;r<v;r++){k<<=1;j<<=1;if(o_.Zp(a,u[r])){k|=1;}else if(h&&o_.Yp(a,u[r])){k|=1;j|=1;}else {i=c[b][r];if(i!=-1){if(d[i]){if(e[i]){k|=1;f[i]||(j|=1);}}else {w=true;}}}}q=false;switch(v){case 3:l=XI(II(h_.hK,1),k0,5,15,[2,1,4]);q=true;for(p=0;p<3;p++){if((k&l[p])==l[p]){if(o_.Ij(a.g,t[p])==6&&o_.rj(a.g,t[p])==1||o_.Ij(a.g,t[p])==5&&o_.rj(a.g,t[p])==0){e[b]=true;g[b]=p;(j&l[p])==0&&(q=false);}}}break;case 5:m=XI(II(h_.hK,1),k0,5,15,[10,5,18,9,20]);q=true;for(s=0;s<5;s++){if((k&m[s])==m[s]){switch(o_.Ij(a.g,t[s])){case 6:if(o_.rj(a.g,t[s])==-1){e[b]=true;g[b]=s;(j&m[s])==0&&(q=false);}break;case 7:if(o_.rj(a.g,t[s])<=0){e[b]=true;g[b]=s;}break;case 8:e[b]=true;g[b]=s;break;case 16:case 34:case 52:if(o_.Am(a.g,t[s])==2){e[b]=true;g[b]=s;}}}}break;case 6:q=true;if((k&21)==21){e[b]=true;(j&21)==0&&(q=false);}if((k&42)==42){e[b]=true;(j&42)==0&&(q=false);}break;case 7:n=XI(II(h_.hK,1),k0,5,15,[42,21,74,37,82,41,84]);q=true;for(o=0;o<7;o++){if((k&n[o])==n[o]){if(o_.Ij(a.g,t[o])==6&&o_.rj(a.g,t[o])==1||o_.Ij(a.g,t[o])==5&&o_.rj(a.g,t[o])==0){e[b]=true;g[b]=o;(j&n[o])==0&&(q=false);}}}}e[b]&&!q&&(f[b]=true);if(e[b])return true;return !w;};o_.Ip=function Ip(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q;f=OI(h_.hK,d1,6,a.i.a.length,0,2);for(j=0;j<a.i.a.length;j++){f[j]=OI(h_.hK,k0,5,l_.Th(a.i,j).length,15,1);for(k=0;k<l_.Th(a.i,j).length;k++)f[j][k]=-1;}p=OI(h_.hK,k0,5,a.g.e,15,1);for(n=0;n<a.j.a.length;n++){o=l_.Th(a.j,n);if(o.length==3||o.length>=5&&o.length<=7){for(i=0;i<o.length;i++){h=o[i];if(o_.Am(a.g,o_.Nj(a.g,0,h))==3&&o_.Am(a.g,o_.Nj(a.g,1,h))==3){if(p[h]>0){f[p[h]>>>16][p[h]&32767]=n;f[n][i]=p[h]>>>16;}else {p[h]=(n<<16)+32768+i;}}}}}g=OI(h_.DN,C0,5,a.i.a.length,16,1);q=0;l=-1;while(q>l){l=q;for(m=0;m<a.i.a.length;m++){if(!g[m]){if(o_.Hp(a,m,f,g,b,c,d,e)){g[m]=true;++q;}}}}};o_.Jp=function Jp(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;e=o_.Nj(a.g,0,b);f=o_.Nj(a.g,1,b);i=OI(h_.hK,k0,5,a.g.d,15,1);j=OI(h_.hK,k0,5,a.g.d,15,1);k=OI(h_.hK,k0,5,a.g.d,15,1);i[0]=e;i[1]=f;j[e]=1;j[f]=2;k[e]=-1;k[f]=e;h=1;l=1;while(h<=l){for(m=0;m<o_.Am(a.g,i[h]);m++){g=o_.zm(a.g,i[h],m);if(h>1&&g==e){o=OI(h_.hK,k0,5,j[i[h]],15,1);d=i[h];for(n=0;n<o.length;n++){o[n]=d;d=k[d];}return o;}if(j[g]==0&&!c[g]){i[++l]=g;j[g]=j[i[h]]+1;k[g]=i[h];}}++h;}return null;};o_.Kp=function Kp(a,b,c){var d,e;e=l_.Th(a.i,b);for(d=0;d<e.length;d++)if(c==e[d])return d;return -1;};o_.Lp=function Lp(a,b){return a.a[b];};o_.Mp=function Mp(a,b,c){var d,e;e=l_.Th(a.j,b);for(d=0;d<e.length;d++)if(c==e[d])return d;return -1;};o_.Np=function Np(a,b){return a.b[b];};o_.Op=function Op(a,b){return a.c[b];};o_.Pp=function Pp(a,b){return l_.Th(a.i,b);};o_.Qp=function Qp(a,b){return l_.Th(a.j,b);};o_.Rp=function Rp(a,b){var c,d,e,f,g;f=b.length;g=OI(h_.hK,k0,5,f,15,1);for(d=0;d<f;d++){c=d==f-1?b[0]:b[d+1];for(e=0;e<o_.Am(a.g,b[d]);e++){if(o_.zm(a.g,b[d],e)==c){g[d]=o_.Bm(a.g,b[d],e);break;}}}return g;};o_.Sp=function Sp(a,b){return l_.Th(a.j,b).length;};o_.Tp=function Tp(a,b,c){var d;for(d=0;d<a.j.a.length;d++)if(o_.Wp(a,d,b)&&o_.Wp(a,d,c))return d;return -1;};o_.Up=function Up(a,b){return a.d[b];};o_.Vp=function Vp(a,b,c){var d,e;e=l_.Th(a.i,b);for(d=0;d<e.length;d++)if(c==e[d])return true;return false;};o_.Wp=function Wp(a,b,c){var d,e;e=l_.Th(a.j,b);for(d=0;d<e.length;d++)if(c==e[d])return true;return false;};o_.Xp=function Xp(a,b){return a.e[b];};o_.Yp=function Yp(a,b){var c,d,e,f,g,h;for(g=0;g<2;g++){c=o_.Nj(a.g,g,b);if(o_.Ij(a.g,c)==7&&o_.Am(a.g,c)==2){d=o_.Nj(a.g,1-g,b);if(o_.Ij(a.g,d)==6){for(h=0;h<o_.Am(a.g,d);h++){e=o_.zm(a.g,d,h);f=o_.Bm(a.g,d,h);if((o_.Ij(a.g,e)==8||o_.Ij(a.g,e)==16)&&o_.Vj(a.g,f)==2&&o_.Am(a.g,e)==1)return true;}}}}return false;};o_.Zp=function Zp(a,b){return o_.Vj(a.g,b)>1||o_.Yj(a.g,b)==64;};o_.$p=function $p(a,b,c){var d,e,f;f=b.length;for(e=0;e<f;e++)(a.a[b[e]]==0||a.a[b[e]]>f)&&(a.a[b[e]]=f);for(d=0;d<f;d++)(a.b[c[d]]==0||a.b[c[d]]>f)&&(a.b[c[d]]=f);};o_._p=function _p(a,b,c){var d;d=l_.Th(a.j,b).length;while(c>=d)c-=d;while(c<0)c+=d;return c;};o_.aq=function aq(a,b){o_.bq.call(this,a,b);};o_.bq=function bq(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;this.g=a;this.f=7;this.i=new l_.gi();this.j=new l_.gi();this.a=OI(h_.hK,k0,5,this.g.d,15,1);this.b=OI(h_.hK,k0,5,this.g.e,15,1);this.g.qb(1);m=OI(h_.DN,C0,5,this.g.d,16,1);n=OI(h_.DN,C0,5,this.g.e,16,1);do{g=false;for(c=0;c<this.g.d;c++){if(!m[c]){q=0;for(l=0;l<o_.Am(this.g,c);l++)m[o_.zm(this.g,c,l)]||++q;if(q<2){m[c]=true;for(k=0;k<o_.Am(this.g,c);k++)n[o_.Bm(this.g,c,k)]=true;g=true;}}}}while(g);s=0;while(s<this.g.d&&m[s])++s;if(s==this.g.d)return;i=OI(h_.hK,k0,5,this.g.d,15,1);i[0]=s;p=OI(h_.hK,k0,5,this.g.d,15,1);p[0]=-1;h=OI(h_.hK,k0,5,this.g.d,15,1);h[s]=1;f=0;j=0;o=1;while(f<=j){for(k=0;k<o_.Am(this.g,i[f]);k++){e=o_.zm(this.g,i[f],k);if(e==p[i[f]])continue;if(h[e]!=0){o_.Gp(this,o_.Bm(this.g,i[f],k),m);continue;}if(!m[e]){h[e]=o;p[e]=i[f];i[++j]=e;}}++f;if(f>j){for(c=0;c<this.g.d;c++){if(h[c]==0&&!m[c]){h[c]=++o;i[++j]=c;p[c]=-1;break;}}}}if((b&4)!=0){this.d=OI(h_.DN,C0,5,this.i.a.length,16,1);this.e=OI(h_.DN,C0,5,this.i.a.length,16,1);this.c=OI(h_.hK,k0,5,this.i.a.length,15,1);o_.Ip(this,this.d,this.e,this.c,false);}if((b&2)!=0){for(d=0;d<this.g.e;d++){if(!n[d]&&o_.Vj(this.g,d)!=0){r=o_.Jp(this,d,m);r!=null&&o_.$p(this,r,o_.Rp(this,r));}}}};xO(81,1,{},o_.aq);_.f=0;h_.NK=jQ(81);o_.cq=function cq(a,b){var c,d,e,f,g,h,i,j,k,l,m;m=o_.Eq(a.B,a.B.length);if(b==2||b==5){l_.Oh(a.A,m);return;}if(a.n!=0||b==4||b==3){m=o_.oq(m);if(b==4){if(!l_.kZ(a.J,m)){l_.iZ(a.J,m);l_.Oh(a.A,o_.Eq(a.B,a.B.length));}}else if(b==3){if(!l_.kZ(a.J,m)){l=false;for(j=(h=new l_.IY(new l_.NY(new l_.vW(a.J.a).a).b),new l_.DW(h));l_.OU(j.a.a);){i=(g=l_.GY(j.a),g.Sb());k=0;for(d=m,e=0,f=d.length;e<f;++e){c=d[e];while(k<i.length&&i[k]<c)++k;if(k<i.length){if(c==i[k]){l=true;break;}}}if(l)break;}if(!l){l_.iZ(a.J,m);l_.Oh(a.A,o_.Eq(a.B,a.B.length));}}}return;}return;};o_.dq=function dq(a,b,c){var d,e,f,g,h,i,j,k,l,m;i=o_.Am(a.C,b);e=a.k[c];if(e>i)return false;k=o_.Dj(a.C,b);g=o_.Dj(a.f,c);f=o_.yj(a.f,c);j=o_.yj(a.C,b);if((g&1)!=0){if(f!=null){if((k&1)!=0){if(j==null)return false;if(!o_.tq(f,j))return false;}else {if(j!=null){if(o_.vq(j,f))return false;}else {if(o_.sq(o_.Ij(a.C,b),f))return false;}}}}else {if((k&1)!=0)return false;if(f!=null){if(j!=null){if(!o_.tq(j,f))return false;}else {if(!o_.sq(o_.Ij(a.C,b),f))return false;}}else {if(j!=null)return false;if(a.F[b]!=a.i[c])return false;}}if((k|g)!=0){if((g&V0)!=0){if(a.C.I&&(k&V0)==0)return false;else if(e!=i)return false;}if((g&b0)!=0){if(e>=i&&(k&b0)==0)return false;}}if((a.D[b]&~a.g[c])!=0)return false;if(o_.rj(a.f,c)!=0&&o_.rj(a.f,c)!=o_.rj(a.C,b))return false;if(o_.Bj(a.f,c)!=0&&o_.Bj(a.f,c)!=o_.Bj(a.C,b))return false;m=(o_.Dj(a.f,c)&T0)>>22;if(m!=0){if(a.C.I&&m==(o_.Dj(a.C,c)&T0)>>22)return true;d=false;l=o_.Ym(a.C);for(h=0;h<l.i.a.length;h++){if(l_.Th(l.j,h).length==m){if(o_.Vp(l,h,b)){d=true;break;}}}if(!d)return false;}return true;};o_.eq=function eq(a,b,c){var d,e,f,g;if((a.G[b]&~a.j[c])!=0)return false;g=(o_.Xj(a.f,c)&$0)>>15;if(g!=0){if(a.C.I&&g==(o_.Xj(a.C,c)&$0)>>15)return true;d=false;f=o_.Ym(a.C);for(e=0;e<f.i.a.length;e++){if(l_.Th(f.j,e).length==g){if(o_.Wp(f,e,b)){d=true;break;}}}if(!d)return false;}return true;};o_.fq=function fq(a){var b,c;a.a=null;for(b=0;b<a.f.e;b++){if(o_.pk(a.f,b)){!a.a&&(a.a=new l_.gi());c=new o_.Fq();c.a=o_.Nj(a.f,0,b);c.b=o_.Nj(a.f,1,b);c.d=o_.Pj(a.f,b);c.c=o_.Oj(a.f,b);l_.Oh(a.a,c);}}};o_.gq=function gq(a){var b,c,d,e,f,g,h,i,j,k,l,m;o_.Jr(a.f,a.I);i=$wnd.Math.max(a.f.d,a.f.e)+16;a.q=OI(h_.hK,k0,5,i,15,1);a.s=OI(h_.hK,k0,5,i,15,1);a.t=OI(h_.hK,k0,5,i,15,1);a.r=OI(h_.DN,C0,5,i+1,16,1);g=OI(h_.DN,C0,5,a.f.d,16,1);h=OI(h_.DN,C0,5,a.f.e,16,1);d=0;for(c=0;c<a.f.d;c++){if(!a.w[c]&&!g[c]){a.q[d]=c;a.t[d]=-1;a.s[d]=-1;j=d;while(d<=j){for(k=0;k<o_.nm(a.f,a.q[d]);k++)j=o_.Cq(a,d,j,k,g,h,-1);while(a.r[++d]);}}}a.u=d;if(a.n!=0){j=a.u-1;for(f=0;f<a.c;f++){d=0;while(d<=j){for(l=0;l<o_.nm(a.f,a.q[d]);l++)j=o_.Cq(a,d,j,l,g,h,f);while(a.r[++d]);}}for(b=0;b<a.f.d;b++){if(a.w[b]&&!g[b]){a.q[d]=b;a.t[d]=-1;a.s[d]=-1;j=d;while(d<=j){for(l=0;l<o_.nm(a.f,a.q[d]);l++)o_.zm(a.f,a.q[d],l)<a.f.d&&(j=o_.Cq(a,d,j,l,g,h,a.e[b]));while(a.r[++d]);}}}a.d=OI(h_.hK,k0,5,a.c,15,1);for(m=0;m<a.c;m++)a.d[m]=-1;for(k=a.u;k<d;k++){e=a.e[a.q[k]];a.d[e]==-1&&(a.d[e]=k);}}a.v=d;};o_.hq=function hq(a,b){var c,d,e,f,g,h,i,j;j=o_.Ym(a.C);for(h=0;h<j.i.a.length;h++){if(o_.Wp(j,h,b)){i=OI(h_.hK,k0,5,2,15,1);for(e=0;e<2;e++){i[e]=P_;d=o_.Nj(a.C,e,b);for(f=0;f<o_.Am(a.C,d);f++){c=o_.zm(a.C,d,f);c!=o_.Nj(a.C,1-e,b)&&i[e]>c&&(i[e]=c);}}g=0;o_.Vp(j,h,i[0])&&++g;o_.Vp(j,h,i[1])&&++g;if(g==2)return 2;if(g==1)return 1;return 2;}}return 0;};o_.iq=function iq(a,b,c){var d,e,f;if(a.a){for(e=new l_.KW(a.a);e.a<e.c.a.length;){d=l_.JW(e);if(a.e==null||c==-1&&a.e[d.a]==-1&&a.e[d.b]==-1||c!=-1&&(a.e[d.a]==c||a.e[d.b]==c)){f=o_.Wm(a.C,a.B[d.a],a.B[d.b],d.c+1,b)-1;if(f<d.d||f>d.c)return false;}}}return true;};o_.jq=function jq(a,b){var c,d,e,f,g,h,i,j;for(e=0;e<a.f.e;e++){if((o_.Xj(a.f,e)&b1)!=0){f=o_.Wj(a.f,e);if(f==0)continue;c=o_.Nj(a.f,0,e);d=o_.Nj(a.f,1,e);if(a.e==null||b==-1&&a.e[c]==-1&&a.e[d]==-1||b!=-1&&(a.e[c]==b||a.e[d]==b)){g=a.B[c];h=a.B[d];i=o_.xm(a.C,g,h);j=o_.Wj(a.C,i);if(j==0){o_.An(a.C,i)&&(j=o_.hq(a,i));if(j==0)continue;}if(f==3)continue;if(j==3)continue;if(o_.pq(a,e)==(f==j))return false;}}}return true;};o_.kq=function kq(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p;g=0;for(i=0;i<a.f.d;i++){if((a.e==null||a.e[i]==b)&&(o_.Dj(a.f,i)&J0)!=0){m=a.B[i];l=o_.Cj(a.f,i);o=o_.Cj(a.C,m);if(l==0)continue;if(o==0)continue;if(l==3)continue;if(o==3)continue;if(o_.wj(a.f,i)==1){++g;continue;}if(o_.wj(a.C,m)==1)return false;if(o_.wj(a.f,i)==2){++g;continue;}if(o_.wj(a.C,m)==2)return false;if(o_.uq(a,i)==(l==o))return false;}}if(g!=0){e=OI(h_.hK,k0,5,g,15,1);f=0;for(j=0;j<a.f.d;j++){if((a.e==null||a.e[j]==b)&&(o_.Dj(a.f,j)&J0)!=0){l=o_.Cj(a.f,j);l!=0&&l!=3&&(e[f++]=o_.vj(a.f,j)<<24|o_.wj(a.f,j)<<22|j);}}n_.V$(e).sort(n_.V$(AO(l_.pX.prototype.Ub,l_.pX,[])));f=0;while(f<e.length){k=e[f]&v1;n=a.B[k];c=e[f]&-4194304;d=o_.uq(a,k)^o_.Cj(a.f,k)==o_.Cj(a.C,n);for(++f;f<e.length&&(e[f]&-4194304)==c;f++){h=e[f]&v1;m=a.B[h];if(o_.wj(a.C,m)!=o_.wj(a.C,n)||o_.vj(a.C,m)!=o_.vj(a.C,n))return false;p=o_.uq(a,h)^o_.Cj(a.f,h)==o_.Cj(a.C,m);if(p!=d)return false;}}}return true;};o_.lq=function lq(a,b,c){var d,e,f,g,h,i,j;a.A=new l_.gi();l_.jY(a.J.a);if(!a.C||!a.f)return 0;if(a.f.d-a.n>a.C.d||a.f.e-a.o>a.C.e)return 0;if(a.f.d==0)return 0;o_.yq(a,c);d=OI(h_.DN,C0,5,a.C.d,16,1);a.B=OI(h_.hK,k0,5,a.f.d,15,1);l_.SW(a.B);h=OI(h_.hK,k0,5,a.v,15,1);l_.VW(h,h.length,-1);f=0;while(true){if(a.u!=0){j=a.s[f]==-1?a.C.d:o_.nm(a.C,a.B[a.s[f]]);++h[f];if(h[f]==j){h[f]=-1;if(f==0)break;--f;a.r[f]||(d[a.B[a.q[f]]]=false);continue;}if(a.s[f]==-1){if(!d[h[f]]){if(o_.dq(a,h[f],a.q[f])){a.B[a.q[f]]=h[f];d[h[f]]=true;++f;}}}else {if(o_.zm(a.C,a.B[a.s[f]],h[f])>=a.C.d)continue;e=o_.zm(a.C,a.B[a.s[f]],h[f]);if(a.r[f]){e==a.B[a.q[f]]&&o_.eq(a,o_.Bm(a.C,a.B[a.s[f]],h[f]),a.t[f])&&++f;}else {if(!d[e]){if(o_.dq(a,e,a.q[f])&&o_.eq(a,o_.Bm(a.C,a.B[a.s[f]],h[f]),a.t[f])){d[e]=true;a.B[a.q[f]]=e;++f;}}}}}if(f==a.u){if(o_.kq(a,-1)&&o_.jq(a,-1)&&o_.iq(a,d,-1)){i=false;for(g=0;g<a.c;g++){if(o_.qq(a,d,h,g)){i=true;break;}}if(b==1&&!i)return 1;if(!i){o_.cq(a,b);if(b==2)return 1;}}if(f==0)break;--f;a.r[f]||(d[a.B[a.q[f]]]=false);}}return a.A.a.length;};o_.mq=function mq(a,b){var c,d,e,f,g,h,i,j;i=0;if(a.I){(a.s[b]&b0)!=0&&(i|=2);j=(d=a.s[b]&n1,d==0?0:d==L0?2:d==V0?3:4);if(j!=0){i|=8;j>2&&(i|=16);j>3&&(i|=32);}c=a.q[b];c<0?i|=O0:c>0&&(i|=N0);f=a.g[b];switch(f){case 0:break;case 1:i|=h1;break;case 2:i|=S0;break;case 3:i|=917504;break;default:i|=1966080;}}else {(a.s[b]&b0)!=0?i|=2:i|=4;j=(d=a.s[b]&n1,d==0?0:d==L0?2:d==V0?3:4);j==0?i|=112:j==2?i|=104:j==3?i|=88:i|=56;c=a.q[b];c==0?i|=167772160:c<0?i|=O0:c>0&&(i|=N0);e=a.c[b]-o_.Rm(a,b)+o_.Nm(a,b);switch(e){case 0:i|=1792;break;case 1:i|=1664;break;case 2:i|=1408;break;default:i|=896;}f=a.g[b];switch(f){case 0:i|=3932160;break;case 1:i|=3801088;break;case 2:i|=3538944;break;case 3:i|=3014656;break;default:i|=1966080;}h=a.k[b];switch(h){case 0:i|=98304;break;case 1:i|=81920;break;default:i|=49152;}}g=a.k[b];g>0&&(i|=c0);g>1&&(i|=32768);return i;};o_.nq=function nq(a,b){var c;c=0;if((a.C[b]&512)!=0||a.F[b]==64)c|=8;else switch(o_.Vj(a,b)){case 0:c|=32;break;case 1:c|=1;break;case 2:c|=2;break;case 3:c|=4;}(a.C[b]&64)!=0?c|=64:a.I||(c|=32);(a.C[b]&256)!=0?c|=Z0:a.I||(c|=a0);return c;};o_.oq=function oq(a){var b,c,d,e,f,g,h,i,j,k;i=0;for(d=a,f=0,h=d.length;f<h;++f){b=d[f];b==-1&&++i;}if(i!=0){k=a;a=OI(h_.hK,k0,5,k.length-i,15,1);j=0;for(c=k,e=0,g=c.length;e<g;++e){b=c[e];b!=-1&&(a[j++]=b);}}n_.V$(a).sort(n_.V$(AO(l_.pX.prototype.Ub,l_.pX,[])));return a;};o_.pq=function pq(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;f=false;for(e=0;e<2;e++){c=o_.Nj(a.f,e,b);k=a.B[c];if(o_.Am(a.C,k)>2){m=o_.Nj(a.f,1-e,b);i=P_;for(h=0;h<o_.Am(a.f,c);h++){d=o_.zm(a.f,c,h);d!=m&&i>d&&(i=d);}n=a.B[m];j=P_;for(g=0;g<o_.Am(a.C,k);g++){l=o_.zm(a.C,k,g);l!=n&&j>l&&(j=l);}a.B[i]!=j&&(f=!f);}}return f;};o_.qq=function qq(a,b,c,d){var e,f,g,h,i,j,k,l;h=a.d[d];i=h+1;while(i<a.v&&a.e[a.q[i]]==d)++i;for(k=h;k<i;k++)c[k]=-1;g=h;while(true){l=a.s[g]==-1?a.C.d:o_.nm(a.C,a.B[a.s[g]]);++c[g];if(c[g]==l){c[g]=-1;if(g==h)break;--g;if(!a.r[g]){b[a.B[a.q[g]]]=false;a.B[a.q[g]]=-1;}continue;}if(a.s[g]==-1){if(!b[c[g]]){if(o_.dq(a,c[g],a.q[g])){a.B[a.q[g]]=c[g];b[c[g]]=true;++g;}}}else {if(o_.zm(a.C,a.B[a.s[g]],c[g])>=a.C.d){++c[g];continue;}f=o_.zm(a.C,a.B[a.s[g]],c[g]);if(a.r[g]){f==a.B[a.q[g]]&&o_.eq(a,o_.Bm(a.C,a.B[a.s[g]],c[g]),a.t[g])&&++g;}else {if(!b[f]){if(o_.dq(a,f,a.q[g])&&o_.eq(a,o_.Bm(a.C,a.B[a.s[g]],c[g]),a.t[g])){b[f]=true;a.B[a.q[g]]=f;++g;}}}}if(g==i){if(o_.kq(a,d)&&o_.jq(a,d)&&o_.iq(a,b,d)){for(j=h;j<i;j++){if(!a.r[j]){e=a.q[j];b[a.B[e]]=false;a.B[e]=-1;}}return true;}--g;if(!a.r[g]){b[a.B[a.q[g]]]=false;a.B[a.q[g]]=-1;}}}return false;};o_.rq=function rq(a){return o_.lq(a,1,a.b)>0;};o_.sq=function sq(a,b){var c;for(c=0;c<b.length;c++)if(b[c]==a)return true;return false;};o_.tq=function tq(a,b){var c,d,e;e=0;for(d=0;d<a.length;d++){c=a[d];while(b[e]<c){++e;if(e==b.length)return false;}if(b[e]>c)return false;}return true;};o_.uq=function uq(a,b){var c,d,e,f,g,h,i,j;g=false;if(o_.qm(a.f,b)==0){for(f=1;f<o_.Am(a.f,b);f++){for(h=0;h<f;h++){d=o_.zm(a.f,b,f);e=o_.zm(a.f,b,h);a.B[d]>a.B[e]^d>e&&(g=!g);}}}else {for(f=0;f<o_.Am(a.f,b);f++){c=o_.zm(a.f,b,f);j=0;i=OI(h_.hK,k0,5,3,15,1);for(h=0;h<o_.Am(a.f,c);h++){i[j]=o_.zm(a.f,c,h);i[j]!=b&&++j;}j==2&&a.B[i[0]]>a.B[i[1]]^i[0]>i[1]&&(g=!g);}}return g;};o_.vq=function vq(a,b){var c,d,e,f;e=0;f=0;while(e<a.length&&f<b.length){c=a[e];d=b[f];if(c==d)return true;c<d?++e:++f;}return false;};o_.wq=function wq(a,b){var c,d,e,f,g;if(!b||b.o==0||!b.I){a.f=null;return;}a.f=b;a.p=false;o_.Jr(a.f,1);a.I=7;for(d=0;d<a.f.d;d++)(o_.Dj(a.f,d)&J0)!=0&&(a.I=15);for(g=0;g<a.f.e;g++)(o_.Xj(a.f,g)&b1)!=0&&(a.I=15);a.H&&a.I!=7&&o_.Jr(a.C,a.I);a.n=0;a.o=0;a.w=OI(h_.DN,C0,5,a.f.d,16,1);for(e=0;e<a.f.d;e++){a.w[e]=(o_.Dj(a.f,e)&D0)!=0;a.w[e]&&++a.n;}a.c=0;a.e=null;if(a.n!=0){if(a.n!=0)for(f=0;f<a.f.e;f++)(a.w[o_.Nj(a.f,0,f)]||a.w[o_.Nj(a.f,1,f)])&&++a.o;for(c=0;c<a.f.o;c++)o_.cl(a.f,c,a.w[c]);a.e=OI(h_.hK,k0,5,a.f.o,15,1);a.c=o_.Im(a.f,a.e,true,false);}};o_.xq=function xq(a,b){if(!b||b.o==0){a.C=null;return;}a.C=b;a.H=false;o_.Jr(a.C,1);};o_.yq=function yq(a,b){if(!a.H){o_.Bq(a,b);a.H=true;}if(!a.p){o_.zq(a,b);o_.gq(a);o_.fq(a);a.p=true;}};o_.zq=function zq(a,b){var c,d,e,f,g,h,i,j,k,l;f=null;i=null;g=null;o_.Jr(a.f,a.I);a.k=OI(h_.hK,k0,5,a.f.d,15,1);for(d=0;d<a.f.d;d++)a.k[d]=o_.Am(a.f,d);if(a.n!=0){j=new o_._r(a.f.o,a.f.p);l=OI(h_.DN,C0,5,a.f.o,16,1);for(e=0;e<a.f.o;e++)l[e]=!a.w[e];o_.dm(a.f,j,l,true,null);o_.Jr(j,a.I);o_.Aq(a,j,b);f=a.g;i=a.j;g=a.i;k=0;for(c=0;c<a.f.d;c++)a.w[c]||(a.k[c]=o_.Am(j,k++));}o_.Aq(a,a.f,b);if(a.n!=0){k=0;for(c=0;c<a.f.o;c++){if(!a.w[c]){a.g[c]=f[k];a.i[c]=g[k++];}}k=0;for(h=0;h<a.f.p;h++){!a.w[o_.Nj(a.f,0,h)]&&!a.w[o_.Nj(a.f,1,h)]&&(a.j[h]=i[k++]);}}};o_.Aq=function Aq(a,b,c){var d,e,f,g;f=b.d;a.g=OI(h_.hK,k0,5,b.d,15,1);a.i=OI(h_.hK,k0,5,b.d,15,1);for(d=0;d<f;d++){a.g[d]=(o_.mq(b,d)|b.w[d])&O1^O1;a.i[d]=b.A[d];(c&1)!=0&&(a.i[d]+=b.q[d]+16<<8);(c&2)!=0&&(a.i[d]+=b.v[d]<<16);}g=b.e;a.j=OI(h_.hK,k0,5,b.e,15,1);for(e=0;e<g;e++){a.j[e]=(o_.nq(b,e)|b.D[e])&1572991^1572960;(c&4)!=0?(a.j[e]&2)!=0&&(a.j[e]|=8):(c&8)!=0&&(a.j[e]&2)!=0&&(b.C[e]&256)!=0&&(a.j[e]|=8);}};o_.Bq=function Bq(a,b){var c,d,e,f;o_.Jr(a.C,a.I);e=a.C.d;a.F=OI(h_.hK,k0,5,e,15,1);a.D=OI(h_.hK,k0,5,e,15,1);for(c=0;c<e;c++){a.D[c]=(o_.mq(a.C,c)|o_.Dj(a.C,c))&O1^O1;a.F[c]=o_.Ij(a.C,c);(b&1)!=0&&(a.F[c]+=o_.rj(a.C,c)+16<<8);(b&2)!=0&&(a.F[c]+=o_.Bj(a.C,c)<<16);}f=a.C.e;a.G=OI(h_.hK,k0,5,f,15,1);for(d=0;d<f;d++)a.G[d]=(o_.nq(a.C,d)|o_.Xj(a.C,d))&1605631^1572960;};o_.Cq=function Cq(a,b,c,d,e,f,g){var h,i;h=o_.zm(a.f,a.q[b],d);if((!a.w[h]||a.e[h]==g)&&h!=a.s[b]){i=o_.Bm(a.f,a.q[b],d);if(!f[i]&&!o_.pk(a.f,i)){a.q[++c]=h;a.s[c]=a.q[b];a.t[c]=i;f[i]=true;e[h]?a.r[c]=true:e[h]=true;}}return c;};o_.Dq=function Dq(){this.b=8;this.A=new l_.gi();this.J=new l_.mZ(new u_.dG());};o_.Eq=function Eq(a,b){var c;c=OI(h_.hK,k0,5,b,15,1);i_.pS(a,0,c,0,$wnd.Math.min(a.length,b));return c;};xO(92,1,{},o_.Dq);_.b=0;_.c=0;_.n=0;_.o=0;_.p=false;_.u=0;_.v=0;_.H=false;_.I=0;h_.QK=jQ(92);o_.Fq=function Fq(){};xO(108,1,{108:1},o_.Fq);_.a=0;_.b=0;_.c=0;_.d=0;h_.OK=jQ(108);o_.Iq=function Iq(){o_.Iq=zO;o_.Gq=XI(II(h_.uM,1),d0,2,6,['QM@HzAmdqjF@','RF@Q``','qC`@ISTAlQE`','`J@H','QM@HzAmdqbF@','qC`@ISTAlQEhqPp@','sJP@DiZhAmQEb','RF@QPvR@','QM@HzA@','qC`@ISTAlQEhpPp@','qC`@Qz`MbHl','sJP@DiZhAmQEcFZF@','RFPDXH','qC`@IVtAlQE`','QM@HvAmdqfF@','sGP@DiVj`FsDVM@','`L@H','sJP@DizhAmQEcFBF@','sJP@DjvhAmQEb','sFp@DiTt@@AlqEcP','sGP@LdbMU@MfHlZ','QMHAIhD','QM@HzAy@','sJP@DkVhAmQEb','sNp@DiUjj@[\\QXu`','sJP@DiZhAmQEcFBF@','sGP@DjVj`FsDVM@','RFPDTH','RG@DXOH@','sGP@Divj`FsDVMcAC@','sGP@Dj}j`FsDVM@','qC`@Qz`MbHmFRF@','sNp@LdbJjj@[\\QXu`','QMHAIhGe@','QM@HzAyd`','QM`AIhD','qC`@ISTA@','sGP@DkUj`FsDVM@','qC`@IVtAlQEhqPp@','sNp@DiUjj@[\\QXuqea`@','KAx@@IRjuUPAlHPfES\\','QM`BN`P','sJP@DjZhAmQEcFJF@','Hid@@DjU^nBBH@FtaBXUMp`','sNp@Diujj@[\\QXuq`a`@','sJP@DjvhAmQEcFZF@','sJP@DjZhAmQEcFFF@','sOp@DjWkB@@FwDVM\\YhX@','sNp@Dj}Zj@[\\QXu`','sNp@DiWjj@[\\QXuq`a`@','sOp@DjWkB@@D','KAx@@ITouUPAlHPfES\\','KAx@@YIDTjjh@vDHSBin@','sNp@DkUZj@[\\QXu`','RFPDXOH@','QM`BN`^L`','qC`@ISTAy@','sGP@LdbMU@MfHl[FVF@','qCb@AIZ`H','KAx@@IRjuUPAlHPfES]FFa`@','KAx@@ITnuUPAlHPfES\\','HiD@@DiUVjj`AmHPfES\\H','sNp@DjUjj@[\\QXu`','sJP@DkVhAmQEcFJF@','sGP@DjVj`FsDVMcCC@','qC`@Qz`MbHmFBF@','sJP@DkfhAmQEb','qC`@IVtAlQEhsPp@','sGP@Djuj`FsDVM@','sGP@Dj}j`FsDVMcMC@','sJP@DiZhA@','KAx@@ISjuUPAlHPfES]F@a`@','sJP@DjZhAmQEcFRF@','KAx@@IRnuUPAlHPfES]F@a`@','HiD@@DjWvjj`AmHPfES\\H','QMHAIhGd@','sNp@DiUjj@[\\QXuq`a`@','KAx@@IVjmUPAlHPfES\\','sGP@DjVj`FsDVMcMC@','QM`AIhGe@','HiD@@LdbJRjjh@[RDIaTwB','qCp@AIZ`H','sGP@LdbMU@MfHl[FFF@','QMDARVA@','sNp@LdbJjj@[\\QXuqba`@','sNp@LdbJjj@[\\QXuqca`@','sGP@Dkej`FsDVM@','qCb@AIZ`OI@','HaD@@DjUZxHH@AlHPfES]FLa`@','sGP@DkYj`FsDVM@','qCb@AIV`H','sNp@LdbJjj@[\\QXuqea`@','sGP@DkUj`FsDVMcEC@','sFp@DiTt@@Axa@','Hmt@@DjU_ZxHHj@AmhPfES\\Lj','QM`BN`^P','qCb@AIZ`OH`','sFp@DiTt@@AxaP','sGP@Djuj`FsDVMcEC@','sGP@Djuj`FsDVMcIC@','sGP@DkUj`FsDVMcKC@','sJP@DkfhAmQEcFRF@','sGP@DjVj`FsDVMcIC@','HaD@@DjUZxHH@AlHPfES]FFa`@','qC`@IRtDVqDV@','sNp@Dj}Zj@[\\QXuqfa`@','KAx@@ITnuUPAlHPfES]FFa`@','HiD@@DkUUjj`AmHPfES\\H','sJQ@@dkU@H','qC`@Qz`H','KAx@@IUkmUPAlHPfES\\','KAx@@ITouUPAlHPfES]FJa`@','sJP@H~j@[TQX`','sGP@DjZj`FsDVM@','sJP@DkVhAmQEcFFF@','sJX@@eKU@H','sJP@DizhAy@','QMHAIhGbP','KAx@@ITouUPAlHPfES]FNa`@','HaD@@DjUZxHD@AlHPfES\\','HaD@@DjUZxHH@A@','sNp@LdbJjj@[\\QXuqaa`@','Hed@@LdbRQUUUP@vTHSBinFP','KAx@@ITouUPAlHPfES]FLa`@','sNp@DkUZj@[\\QXuqba`@','KAx@@ITjuUPAlHPfES]FNa`@','KAx@@YIDTjjh@vDHSBincGPp@','HaD@@DjYvxH`@AlHPfES]FLa`@','RF@QP`','qCb@AIj`H','sNp@DjUjj@[\\QXuqaa`@','sNp@DkVZj@[\\QXu`','KAx@@YIDUJjh@vDHSBin@','sGP@DkYj`FsDVMcIC@','sGP@DjVj`FsDVMcAC@','sGP@DiVj`D','sJP@DkVhAmQEcFZF@','sNp@LdbLjj@[\\QXu`','QM@HvAmdqbF@','HaD@@DjWjXHB@AlHPfES\\','sNp@DjwZj@[\\QXuqba`@','sNp@LdbJjj@[\\QXuqda`@','sFp@DiTt@@Axa`','HiD@@Djuujj`AmHPfES\\H','sNp@DkUZj@[\\QXuqca`@','sJP@DiZhAy@','KAx@@YIDTjjh@vDHSBincCPp@','KAx@@IWNmUPAlHPfES\\','KAx@@IVkMUPAlHPfES\\','sJQ@@dju@H','qCb@AIZ`OH@','qC`@ISTAxa@','sNp@DjyZj@[\\QXu`','Hid@@DjUfaBB`@FtaBXUMp`','HiD@@DiUVjj`AmHPfES\\LXBF@','KAx@@IUjmUPAlHPfES\\','HiD@@DjWvjj`AmHPfES\\LXjF@','sJP@DjVhAmQEb','qCb@AIV`OH`','HiD@@LdbJRjjh@[RDIaTwCFDa`@','KAx@@YIDTjjh@vDHSBinc@Pp@','sNp@DjUjj@[\\QXuqda`@','qC`@Qz`OED','sJP@DkfhAmQEcFZF@','KAx@@YIDbjjh@vDHSBincDPp@','sGP@Djyj`FsDVMcMC@','KAx@@IVrmUPAlHPfES\\','qCp@AIZ`OI@','sJX@@dkU@H','sJQ@@dkU@OH`','sNp@Di]ZjBBvxbqk@','Hkl@@DjU_Uk``bj`@[VDIaTwCJzX','sGP@DjZj`FsDVMcEC@','Hid@@DjU^nBBH@FtaBXUMpqcHX@','sNp@DkeZj@[\\QXu`','sNp@DjYjj@[\\QXuqca`@','sGQ@@djuT@`','HiD@@LdbJTjjh@[RDIaTwB','sOp@DjWkB@@Gd`','HeT@@LdbbRKBDQD@CYPaLJfxY@','qCr@XIKTA@','HiD@@DjW^jj`AmHPfES\\LXJF@','HeT@@DjU]k``b`@[JDIaTwCH','sGP@Djuj`FsDVMcCC@','`IH`B','sOp@DjWkB@@GdX','sJQ@@eKU@H','KAx@@YIDUJjh@vDHSBincBPp@','sJX@@eKU@OH@','KAx@@YIDTjjh@vDHSBincAPp@','sOq@@drm\\@@@`','KAx@@IUkMUPAlHPfES\\','qCp@AIj`H','Hed@@DjUUjjj@FraBXUMpr','sGX@@eJuT@`','sGP@DkUj`FsDVMcCC@','HiD@@Dj}Ujj`AmHPfES\\LXrF@','KAx@@ITouUPAlHPfES]FHa`@','Hed@@DjWujjj@FraBXUMpsFIa`@','sGP@DiUj``mfHlZ','sFp@DiTvjhAlqEcP','Hid@@DjU^nBBH@FtaBXUMpq`XX@','sJP@DkVdAmQEb','qCp@AIZ`OH`','QMhDRVA@','qC`@ISJAlQE`','qCp@BOTAyhl','sJX@@eOU@ODB','sFp@DiTt@@AyaB','sGP@DkUj`FsDVMcMC@','Hid@@DjYUaBH`@FtaBXUMpqcHX@','qC`@Qz`OH@','HiD@@DjUVjj`AmHPfES\\LXZF@','sJP@H~j@[TQXqda`@','sJX@@eKU@OI@','sNp@Djejj@[\\QXu`','sJQ@@dsU@H','sJQ@@dkU@OI`','KAx@@YIMDVjh@vDHSBin@','Hid@@DjU^nBBD@FtaBXUMp`','sNp@DkgZj@[\\QXuqca`@','qC`@IRtDVqDVcEC@','Hed@@LdbRQeUUP@vTHSBinFP','sNp@DiUjj@P','qC`@IRtDT','sNp@DkYZj@[\\QXuqca`@','KAx@@IUkmUPAlHPfES]FDa`@','KAx@@IVjmUPAlHPfES]FNa`@','sOx@@drm\\@@@`','KAx@@ITjuUPAlHPfES]FBa`@','QMDARVAyH','sJP`@dfvhA@','HeT@@DjU_k``b`@[JDIaTwCLXfF@','KAx@@IToUUPAlHPfES]FJa`@','sGP@DkYj`FsDVMcEC@','qCb@AIZ`ODH','`I@`B','KAx@@IUzmUPAlHPfES]FFa`@','sNp@DkfZj@[\\QXu`','KAx@@ITnuUPAlHPfES]F@a`@','HiD@@LddURjjh@[RDIaTwB','sNp@Dj~Zj@[\\QXuqfa`@','Hed@@Dj{uZjj@FraBXUMpr','KAx@@ITsUUPAlHPfES\\','Hid@@LdbRQk``b@AmHPfES\\LXrF@','sOp@DjWkB@@GdH','sJQ@@dkU@OH@','Hid@@DjU^nBBH@FtaBXUMpqahX@','sGP@DiYj``mfHlZ','KAx@@IToUUPAlHPfES]FLa`@','qCp@AJZ`ODH','Hmt@@DjU]ZxHHj@AmhPfES\\Lj','sGP@DkUjPFsDVM@','qC`@IVtA@','Hed@@LdbJReUUP@vTHSBinFP','sNp@DjuZj@[\\QXuqea`@','KAx@@IUkmUPAlHPfES]FNa`@','HiD@@DkVUjj`AmHPfES\\H','Hed@@DkUeZjj@FraBXUMpr','sNp@DkVZj@[\\QXuqea`@','sJP@DiVhHKZbKFLLL@','HiD@@Djuyjj`AmHPfES\\H','sNp@DjUjj@[\\QXuq`a`@','HeT@@DjYUXPbH`@[JDIaTwCH','HiD@@DjwUjj`AmHPfES\\LXRF@','sNq@@djmUPB','KAx@@YIEEZjh@vDHSBincCPp@','sGP@Di^V`dmfHlZ','Hid@@DjYUaBHP@FtaBXUMp`','sNp@DjYjj@[\\QXuqba`@','sGP@Dkej`FsDVMcKC@','HeT@@DjU^k``b`@[JDIaTwCH','qC`@Qv`MbHmFBF@','sGQ@@djmT@`','qCr@XIKTAyH','qC`@IVtAlQEhpPp@','Hid@@LdbbQxXF@@AmHPfES\\LXjF@','sGP@DkYj`FsDVMcCC@','KAx@@IVsMUPAlHPfES\\','qCp@AIj`ODl','HiD@@DkeUjj`AmHPfES\\H','deT@@DjU[k``b`@vTHSBinFP','sJP@DkVdAmQEcFRF@','HiD@@LdbJTjjh@[RDIaTwCFDa`@','HiD@@DkYyjj`AmHPfES\\H','sJP@DjZhAyH','KAx@@IVkMUPAlHPfES]FDa`@','sJX@@dkU@OI@','Hed@@LdbRQUUUP@vTHSBinFXpLL@','Hed@@DjuUZjj@FraBXUMpr','sGP@Djfj`FsDVMcKC@','sNp@DkVZj@[\\QXuqba`@','sNp@DjyZj@[\\QXuqfa`@','qCb@AIj`OH@','sNp@DjUZj@[\\QXu`','KAx@@IWOMUPAlHPfES\\','Hid@@DjU^nBBH@D','Hed@@DjuvZjj@FraBXUMpr','sJP@DiVhHKZbKFLtL@','dmt@@DjU_ZxHHj@C[PaLJfxYVLKC@','sNp@DjuZj@[\\QXuqca`@','sJP@DkfhAmQEcFJF@','sNp@LdbJZj@[\\QXu`','HeT@@DjU_k``b`@[JDIaTwCLXFF@','KAx@@IVlmUPAlHPfES]FNa`@','HeT@@LdbbRKBDQD@CYPaLJfxYcEPp@','Hid@@DjUZnBBH@FtaBXUMpqcHX@','qCa@CIKTA@','HiD@@Dj~]jj`AmHPfES\\LXFF@','sKP@Di\\Zj@[TQX`','sGP@Djfj`FsDVMcEC@','HiD@@DkgYjj`AmHPfES\\H','sNp@DjuZj@[\\QXuqaa`@','KAx@@YIMDVjh@vDHSBincDPp@','sJP@DjVhHKZbKFLTL@','Hid@@LdbRQk``b@AmHPfES\\LXZF@','HiD@@Dj}Ujj`AmHPfES\\LXzF@','HeT@@DjU_k``bP@[JDIaTwCH','sNp@DkUZi@[\\QXu`','HiD@@DjYfjj`AmHPfES\\H','sGP@DjZj`FsDVMcAC@','Hmt@@DjU_jxHHj@AmhPfES\\Lj','Hid@@LdbRQk``R@AmHPfES\\H','KAx@@YIDUJjh@vDHSBincDPp@','qCr@XIKTAyD','sOq@@drm\\@@@|`@','Hed@@DjW^jjj@FraBXUMpsFBa`@','HeT@@DjY]zXFB@@[JDIaTwCH','Hkl@@DjU_Vk``bj`@[VDIaTwCJzX','Hid@@DjY}nBHH@FtaBXUMpqcHX@','sGX@@eKuT@|d@','sGP@Dj^Y`FsDVM@','HcL@@DjU_ZnBBJh@FqaBXUMprn`','sJP@DkVdAmQEcFJF@','sOq@@drm\\@@@|b@','sNp@DjyZj@[\\QXuqaa`@','HaD@@DjUZxHH@AyD@','qC`@Qv`H','dmt@@DjU_ZxHHj@C[PaLJfxYVLYC@','sGP@Dkej`FsDVMcMC@','Hed@@DjUUjjj@FraBXUMpsFHa`@','HeT@@LdbbRkBDQD@CYPaLJfxY@','KAx@@IU{MUPAlHPfES]FLa`@','RG@DTH','sJY@DDeVhA@','KAx@@YIDUJjh@vDHSBinc@Pp@','sJX@@dkU@OI`','sJQ@@dju@OI`','HeT@@LdbbRKBDQD@CYPaLJfxYcFPp@','sFp@DiTvjhAlqEcXpPp@','HaD@@DjUZxHH@AyG@','sNx@@eJ}UPB','sNp@LddUjj@[\\QXuqca`@','HaDH@@RVU[j@@@D','sNp@DkgZi@[\\QXu`','sGY@LDeVj`D','sNp@LdbJfZBZvxbqk@','sJP`@dfvhAyL','sGX@AddQjhAxe`','Hmt@@DjU_ZxHHj@AmhPfES\\LkFIa`@','qCh@CIKTA@','sNp@LdbLjj@[\\QXuq`a`@','sOq@@drm\\@@@|a@','KAx@@IUzmUPAlHPfES]FJa`@','sNx@AddQUUPB','sGP@Di]jP`mfHlZ','sJP`@TeZhA@','KAx@@IRjmUPHKXPaLJfx','HeT@@LdbRTM\\DDT@CYPaLJfxY@','HaF@@@Rfu[j@@@D','Hid@@DjYUaBH`@FtaBXUMpqchX@','KAx@@IUjmTpAlHPfES\\','Hid@@DjU^nBBD@FtaBXUMpqcHX@','sGP@DiUj``mfHl[FFF@','KAx@@IUvmUPAlHPfES]FLa`@','Hed@@LdbQTUUUP@vTHSBinFXqDL@','sJP@DkVhA@','sOx@@drm\\@@@|b@','KAx@@IUkMUPAlHPfES]FDa`@','HeT@@LdbRQU\\DDT@CYPaLJfxY@','HiD@@Dj}Yjj`AmHPfES\\LXrF@','HiD@@Dj{ujj`AmHPfES\\LXFF@','KAx@@IWNmUPAlHPfES]FFa`@','KAx@@IRkMUPHKXPaLJfx','sJP@DjYdAmQEcFZF@','sJY@LDeZhAyL','HaDH@@RVU[f@@@D','sJP`@deVhAyB','HaD@@DjWjZjj`AlHPfES\\','sGP@DkYj`FsDVMcMC@','sNp@DkgZj@[\\QXuqea`@','sJQ@@dlu@H','HeT@@DjU]k``b`@[JDIaTwCLXrF@','sJX@@dkU@OH`','RFDDQFCr`','sJP@DiYXIKZbKFLLL@','KAx@@YIHjjjh@vDHSBincGPp@','Hk\\@@DjU^ukmLHH@@@AmXPfES\\Lki`','sGQ@@djmT@|b@','Hid@@DjUfaBB`@FtaBXUMpqahX@','sNx@@eRmUPB','Hmt@@LdbRVak``ah@FvaBXUMprh','qCr@XIJtA@','KAx@@IWMmUPAlHPfES]FNa`@','HeT@@DjYYZPbJ@@[JDIaTwCH','sNp@DkfZj@[\\QXuqea`@','Hid@@DjU^nBAHAEVtaBXUMp`','dmt@@DjUgZDHJJ@C[PaLJfxYT','sGP@DkejPFsDVM@','sNx@@eJmUPB','qCb@AIf`H','HcL@@DjU_VnBBJh@FqaBXUMprnqcXX@','Hid@@DjUZnBBH@FtaBXUMpqahX@','sNp@LdbQZjBBvxbqkcGC@','sOx@@drm\\@@@|c@','sJP@H~j@^R@','KAx@@YIDcFjhDElHPfES\\','Hid@@DjUZnBAH@FtaBXUMp`','sNp@LddUji@[\\QXu`','sGP@DjfjPFsDVM@','HeT@@DjYUXPbD`@[JDIaTwCH','KAx@@IUoMUPAlHPfES]FDa`@','sFp@DiTt@@AyaD','Hed@@DjuuZjj@FraBXUMpsFIa`@','HeT@@DjUghP`h`@[JDIaTwCLXfF@','sOp@DjWkjj`FwDVM\\YhX@','sGP@Djfj`FsDVMcIC@','KAx@@IRkmUPHKXPaLJfzL]C@','sNx@@djmUPB','QM`AIdD','sOp@DjWkB@@Gbe@','sNp@DjyZj@[\\QXuqca`@','QM@HuAmd`','sNp@LddUjj@[\\QXuqea`@','daD@@DjUZxHD@CXPaLJfzLYC@','qCb@AIZPH','HiD@@LdbJTjjh@[RDIaTwCF@a`@','Hmt@@DjU_ZxHHi@AmhPfES\\Lj','HaDH@@RYWih@H@D','HiD@@LdbJTjjh@[RDIaTwCFHa`@','sGX@@djuT@|a@','sNp@DkfZj@[\\QXuqaa`@','Hid@@DjU^nBBH@GdL','KAx@@IVkMUPAlHPfES]FJa`@','qCr@XIKTAy@','HmT@@Dj{uVjjh@[ZDIaTwCJqaXX@','dmt@@DjYWVDHbJ@C[PaLJfxYT','Hif@@@RUe^Fh@@@P','HaDH@@Rfu[j@@@GdH','KAx@@IVsMUPAlHPfES]FDa`@','sKP@Di\\Zj@[TQXq`a`@','sJX@@eMU@OH@','HeT@@DjU^k``b`@[JDIaTwCLXFF@','Hmt@@LdbbRJXPbHh@FvaBXUMprh','sJP@DjvhAmQEcFBF@','dmt@@LdbbRNXPbHh@MmBDpj[aeXplL@','sJP`@dfvhAyD','sGP@Di^V`dmfHl[FVF@','KAx@@IVsmUPAlHPfES]FBa`@','sOq@@drm\\@@@|PP','sJY@BDeZhA@','HeT@@LdbRbmBDED@CYPaLJfxY@','Hed@@Djy[Zjj@FraBXUMpr','HeT@@DjU]k``b`@[JDIaTwCLXFF@','Hid@@DjUfaBB`@D','qCa@CIJtA@','QMPARVA@','Hid@@DjUfaBB`@FtaBXUMpqcHX@','sJY@BDfZhA@','HeT@@DjUghP`hP@[JDIaTwCH','Hed@@Dj{uZjj@FraBXUMpsFIa`@','dmt@@DjYUvDHbJ@C[PaLJfxYVLUC@','sNp`@dfuZj@P','sJQ@@dmU@OH@','sJX@@dmU@H','HeT@@DjU]k``b`@[JDIaTwCLXZF@','HiD@@LdfbJZjh@[RDIaTwCFAa`@','sOx@@drm\\@@@|a@','deT@@DjUfhP`h`@vTHSBinFP','dmt@@DjU]ZxHHj@C[PaLJfxYVLKC@','sOp@DjWkjj`FwDVM\\XHX@','HcL@@LdbbRNSBDQEP@McBDpj[ae]cFpp@','HiD@@Dj}Yji`AmHPfES\\H','HaDH@@RYe[hB@@D','Hid@@DjU^njjj@FtaBXUMpq`XX@','deT@@LdbbRKBDQB@FraBXUMpr','QMPARZA@','sOq@@drm\\@@@|QX','HaD@@DjYvxH`@A@','HcL@@LdbbRNcBDQEP@McBDpj[ae]@','QMhDRZA@','RG@DXLHmP','QM`BN`XQYd','RG@DTLHmP','QMHAIXFEVd','QMDARVAaH','RFPDXLHmP','RF@Q`vRbdLEC@','RF@QpvR@','QO@HyjAmd`','`II@B','`II@CFspqJp','`II@CF[@hM@prB`','`H@[T[|B`XN@PdM@p|@bHrBcDk@','RG@DXMj}F@','QM`BN`[L~b@','RG@DTMj}D@','QMHAIXFt~j@','QMDARVA}L@','RFPDXMj}D@','sKP@Di\\YZ@[TQXqaa`@','eF`BHD']);};o_.Jq=function Jq(a,b){var c,d;if(!b)return null;d=OI(h_.hK,k0,5,(o_.Gq.length+31)/32|0,15,1);b=o_.Oq(b);o_.xq(a.g,b);for(c=0;c<o_.Gq.length;c++){o_.wq(a.g,o_.Hq[c]);o_.lq(a.g,1,4)>0&&(d[c/32|0]|=1<<31-c%32);}return d;};o_.Kq=function Kq(a,b){var c,d;if(!b)return null;d=OI(h_.iK,f1,5,(o_.Gq.length+63)/64|0,14,1);b=o_.Oq(b);o_.xq(a.g,b);for(c=0;c<o_.Gq.length;c++){o_.wq(a.g,o_.Hq[c]);o_.lq(a.g,1,4)>0&&(d[c/64|0]=dO(d[c/64|0],eO(1,63-c%64)));}return d;};o_.Lq=function Lq(){var a,b;if(o_.Hq==null){b=new o_.io(false);o_.Hq=OI(h_.XK,K_,23,o_.Gq.length,0,1);for(a=0;a<o_.Gq.length;a++){o_.Hq[a]=o_._n(b,o_.Gq[a]);o_.Jr(o_.Hq[a],1);}}};o_.Mq=function Mq(a){var b;if(a.f!=null){for(b=0;b<a.f.length;b++)if((a.c[b]&~a.f[b])!=0)return false;}else {return false;}return o_.Nq(a);};o_.Nq=function Nq(a){!a.d&&(a.d=o_.bo(new o_.io(false),a.e,null));!a.a&&(a.a=o_.bo(new o_.io(false),a.b,null));o_.xq(a.g,a.d);o_.wq(a.g,a.a);return o_.rq(a.g);};o_.Oq=function Oq(a){var b,c;if(a.I){for(b=0;b<a.o;b++){if((a.w[b]&D0)!=0){a=new o_.as(a);for(c=b;c<a.o;c++)(a.w[c]&D0)!=0&&(a.A[c]=-1);o_.lj(a);}}}return a;};o_.Pq=function Pq(a,b,c){a.b=null;a.a=b;c==null?a.c=o_.Jq(a,b):a.c=c;};o_.Qq=function Qq(a,b,c){a.e=null;a.d=b;c==null?a.f=o_.Jq(a,b):a.f=c;};o_.Rq=function Rq(){o_.Iq();this.g=new o_.Dq();o_.Lq();};o_.Sq=function Sq(a){o_.Iq();var b,c,d,e,f,g;if(a==null)return null;b=OI(h_.dK,j0,5,a.length*8,15,1);for(d=0;d<a.length;d++){g=a[d];for(e=7;e>=0;e--){c=g&15;c>9&&(c+=7);b[d*8+e]=48+c<<24>>24;g>>=4;}}return i_.XR(n_.D$(b,0,(f=b.length,n_.A$(),f)));};o_.Tq=function Tq(a){o_.Iq();var b,c,d,e;if(n_.V$(a).length==0||(n_.V$(a).length&7)!=0)return null;d=OI(h_.hK,k0,5,n_.V$(a).length/8|0,15,1);for(c=0;c<n_.V$(a).length;c++){e=c/8|0;b=(n_.S$(c,n_.V$(a).length),n_.V$(a).charCodeAt(c)-48);b>16&&(b-=7);d[e]<<=4;d[e]+=b;}return d;};o_.Uq=function Uq(a,b){o_.Iq();var c,d,e,f;f=0;d=0;e=0;for(c=0;c<a.length;c++){f+=eR(a[c]&b[c]);d+=eR(a[c]);e+=eR(b[c]);}return f/$wnd.Math.sqrt(d*e);};o_.Vq=function Vq(a,b){o_.Iq();var c,d,e;e=0;c=0;for(d=0;d<a.length;d++){e+=eR(a[d]&b[d]);c+=eR(a[d]|b[d]);}return e/c;};xO(90,1,{},o_.Rq);h_.PK=jQ(90);o_.Xq=function Xq(a){a.i=1;a.j=10;a.k=400;a.f=400;a.d='black';a.b=new l_.gi();a.a=new l_.gi();a.c=new i_._R();a.e=new A_.ZO(12);};o_.Yq=function Yq(a,b,c,d){var e,f;f=new i_.lS('<polygon points="');for(e=0;e<d;e++){i_.dS(f,i_.BQ(D_.HS(D_.ES(new D_.IS(b[e]),(D_.BU(),D_.xU)))));f.a+=',';i_.dS(f,i_.BQ(D_.HS(D_.ES(new D_.IS(c[e]),D_.xU))));f.a+=' ';}i_.gS(f,'" fill="'+a.d+u0+y0+a.d+u0+'stroke-width="1" />');o_.gr(a,f.a);};o_.Zq=function Zq(a,b,c,d){var e,f,g,h;g=(e=(h=A_.XO(a.e,b),new B_.mP(0,0,h,0)).b,e);f='<text x="'+i_.BQ(D_.HS(D_.ES(new D_.IS(c-g/2),(D_.BU(),D_.xU))))+u0+'y="'+i_.BQ(D_.HS(D_.ES(new D_.IS(d+a.j/3),D_.xU)))+u0+'font-family=" '+a.e.a+u0+'font-size="'+a.e.b+u0+'fill="'+a.d+'">'+b+'<\/text>';o_.gr(a,f);};o_.$q=function $q(a,b,c,d){var e;e='<circle cx="'+i_.BQ(D_.HS(D_.ES(new D_.IS(b+d/2),(D_.BU(),D_.xU))))+u0+'cy="'+i_.BQ(D_.HS(D_.ES(new D_.IS(c+d/2),D_.xU)))+u0+'r="'+i_.BQ(D_.HS(D_.ES(new D_.IS(d/2),D_.xU)))+u0+'fill="'+a.d+A0;o_.gr(a,e);};o_._q=function _q(a,b,c,d){var e;e='<circle id="'+(a.g!=null?a.g:'mol'+o_.Wq)+':Atom:'+b+u0+P1+'cx="'+i_.BQ(D_.HS(D_.ES(new D_.IS(c),(D_.BU(),D_.xU))))+u0+'cy="'+i_.BQ(D_.HS(D_.ES(new D_.IS(d),D_.xU)))+u0+'r="'+8+u0+Q1;l_.Oh(a.a,e);};o_.ar=function ar(a,b,c,d,e,f){var g;g='<line id="'+(a.g!=null?a.g:'mol'+o_.Wq)+':Bond:'+b+u0+P1+'x1="'+i_.BQ(D_.HS(D_.ES(new D_.IS(c),(D_.BU(),D_.xU))))+u0+v0+i_.BQ(D_.HS(D_.ES(new D_.IS(d),D_.xU)))+u0+w0+i_.BQ(D_.HS(D_.ES(new D_.IS(e),D_.xU)))+u0+x0+i_.BQ(D_.HS(D_.ES(new D_.IS(f),D_.xU)))+u0+z0+8+u0+Q1;l_.Oh(a.b,g);};o_.br=function br(a,b){a.d='rgb('+(b.c>>16&255)+','+(b.c>>8&255)+','+(b.c&255)+')';};o_.cr=function cr(a,b){a.i=i_.BQ(D_.HS(D_.ES(new D_.IS($wnd.Math.max(b,1)),(D_.BU(),D_.xU))));};o_.dr=function dr(a,b){if(a.j!=b){a.j=b;a.e=new A_.ZO(b);}};o_.er=function er(a,b){a.k=kO(VN($wnd.Math.round(b.b)));a.f=kO(VN($wnd.Math.round(b.a)));return o_.Ld(a,b);};o_.fr=function fr(a){var b,c,d,e,f,g;f='<svg id="'+(a.g!=null?a.g:'mol'+o_.Wq)+u0+'xmlns="http://www.w3.org/2000/svg" version="1.1" '+'width="'+a.k+'px" '+'height="'+a.f+'px" '+'viewBox="0 0 '+a.k+' '+a.f+'">\n';g='<style> #'+(a.g!=null?a.g:'mol'+o_.Wq)+' { pointer-events:none; }'+' #'+(a.g!=null?a.g:'mol'+o_.Wq)+' .event '+' { pointer-events:all; }'+' line { stroke-linecap:round; }'+' polygon { stroke-linejoin:round; }'+' <\/style>\n';f+='  ';f+=g;for(e=new l_.KW(a.b);e.a<e.c.a.length;){d=l_.JW(e);o_.gr(a,d);}for(c=new l_.KW(a.a);c.a<c.c.a.length;){b=l_.JW(c);o_.gr(a,b);}return f+a.c.a+'<\/svg>';};o_.gr=function gr(a,b){i_.$R(a.c,'  ');i_.$R(a.c,b);i_.$R(a.c,J_);};o_.hr=function hr(a,b,c){o_.Pc();o_.Od.call(this,a,b);o_.Xq(this);this.g=c;++o_.Wq;};xO(141,161,{},o_.hr);_.jb=function ir(){return o_.fr(this);};_.f=0;_.i=0;_.j=0;_.k=0;o_.Wq=0;h_.RK=jQ(141);o_.jr=function jr(a,b,c,d){this.a=a;this.e=b;this.d=c;this.c=d;};xO(95,1,{95:1},o_.jr);_.a=0;_.b=0;_.c=false;_.d=false;_.e=0;h_.SK=jQ(95);o_.kr=function kr(a,b){var c,d,e,f;f=false;a.b=b;o_.Jr(a.b,15);c=a.b.d;d=a.b.e;a.j=OI(h_.DN,C0,5,d,16,1);for(e=0;e<d;++e)a.j[e]=false;a.g=OI(h_.DN,C0,5,c,16,1);a.c=OI(h_.hK,k0,5,c,15,1);for(e=0;e<c;++e){a.g[e]=false;a.c[e]=-1;}a.e=OI(h_.uM,d0,2,3*c,6,1);a.i=0;a.d=0;a.a=0;while(!f){for(e=0;e<c;++e){if(!a.g[e]){a.a>0&&(a.e[a.i++]='.');o_.mr(a,e,-1);++a.a;break;}}e==c&&(f=true);}a.f='';for(e=0;e<a.i;++e)a.f+=''+a.e[e];return a.f;};o_.lr=function lr(a){switch(a){case 5:case 6:case 7:case 8:case 9:case 15:case 16:case 17:case 35:case 53:return true;default:return false;}};o_.mr=function mr(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;d=true;i=0;p=0;m=a.i;a.c[b]=m;h=o_.Ij(a.b,b);g=o_.xj(a.b,b);e=o_.rj(a.b,b);f=o_.Bj(a.b,b);k=o_.Am(a.b,b);e==0&&f==0&&o_.lr(h)&&(d=false);a.e[m]='';if(c!=-1){switch(o_.Vj(a.b,c)){case 0:a.e[m]+='~';break;case 2:a.e[m]+='=';break;case 3:a.e[m]+='#';}}d&&(a.e[m]+='[');f!=0&&(a.e[m]+=''+f);a.e[m]+=''+g;if(d){if(0<(o=o_.Nm(a.b,b))){a.e[m]+='H';1<o&&(a.e[m]+=o);}}if(e!=0){e>0?a.e[m]+='+':a.e[m]+='-';$wnd.Math.abs(e)>1&&(a.e[m]+=''+$wnd.Math.abs(e));}d&&(a.e[m]+=']');c!=-1&&(a.j[c]=true);a.g[b]=true;++a.i;for(n=0;n<k;++n)a.j[o_.Bm(a.b,b,n)]||++i;for(n=0;n<k;++n){j=o_.zm(a.b,b,n);l=o_.Bm(a.b,b,n);if(a.j[l]){++p;continue;}if(a.g[j]){++a.d;a.j[l]=true;switch(o_.Vj(a.b,l)){case 0:a.e[a.c[j]]+='~';a.e[m]+='~';break;case 2:a.e[a.c[j]]+='=';a.e[m]+='=';break;case 3:a.e[a.c[j]]+='#';a.e[m]+='3';}if(a.d>9){a.e[a.c[j]]+='%';a.e[m]+='%';}a.e[a.c[j]]+=''+a.d;a.e[m]+=''+a.d;continue;}n-p<i-1&&(a.e[a.i++]='(');o_.mr(a,j,l);n-p<i-1&&(a.e[a.i++]=')');}};o_.nr=function nr(){};xO(140,1,{},o_.nr);_.a=0;_.d=0;_.i=0;h_.TK=jQ(140);o_.or=function or(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;j=OI(h_.hK,k0,5,a.d.d,15,1);h=OI(h_.hK,k0,5,a.d.d,15,1);i=OI(h_.hK,k0,5,a.d.d,15,1);k=OI(h_.hK,k0,5,a.d.d,15,1);c=o_.Nj(a.d,0,b);d=o_.Nj(a.d,1,b);h[0]=c;h[1]=d;i[0]=-1;i[1]=b;j[c]=1;j[d]=2;k[c]=-1;k[d]=c;g=1;l=1;while(g<=l&&j[h[g]]<15){o=h[g];for(m=0;m<o_.Am(a.d,o);m++){e=o_.zm(a.d,o,m);if(e!=k[o]){f=o_.Bm(a.d,o,m);if(e==c){i[0]=f;for(n=0;n<=l;n++){if(!a.c[i[m]]){a.c[i[m]]=true;++a.b;}}return;}if(o_.wk(a.d,e)&&j[e]==0){++l;h[l]=e;i[l]=f;j[e]=j[o]+1;k[e]=o;}}}++g;}return;};o_.pr=function pr(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;o_.Jr(a.d,7);l=false;m=OI(h_.hK,k0,5,2,15,1);n=OI(h_.hK,k0,5,2,15,1);k=OI(h_.hK,k0,5,2,15,1);for(d=0;d<a.d.e;d++){if(!o_.An(a.d,d)&&o_.Yj(a.d,d)==2){for(g=0;g<2;g++){m[g]=-1;k[g]=-1;b=o_.Nj(a.d,g,d);for(j=0;j<o_.Am(a.d,b);j++){e=o_.Bm(a.d,b,j);if(e!=d){if(m[g]==-1&&(o_.Yj(a.d,e)==17||o_.Yj(a.d,e)==9)){m[g]=o_.zm(a.d,b,j);n[g]=e;}else {k[g]=o_.zm(a.d,b,j);}}}if(m[g]==-1)break;}if(m[0]!=-1&&m[1]!=-1){i=o_.Yj(a.d,n[0])==o_.Yj(a.d,n[1]);for(h=0;h<2;h++)m[h]==o_.Nj(a.d,0,n[h])&&(i=!i);for(f=0;f<2;f++)k[f]!=-1&&k[f]<m[f]&&(i=!i);o_.tl(a.d,d,i?2:1,false);l=true;}}}for(c=0;c<a.d.e;c++)(o_.Yj(a.d,c)==17||o_.Yj(a.d,c)==9)&&o_.wl(a.d,c,1);return l;};o_.qr=function qr(a,b){var c,d,e,f,g,h,i,j,k,l,m;for(c=0;c<a.d.d;c++){if(o_.wk(a.d,c)){i=OI(h_.hK,k0,5,a.d.d,15,1);h=OI(h_.hK,k0,5,a.d.d,15,1);j=OI(h_.hK,k0,5,a.d.d,15,1);h[0]=c;i[c]=1;j[c]=-1;g=0;k=0;while(g<=k){e=(i[h[g]]&1)==1?1:2;for(l=0;l<o_.Am(a.d,h[g]);l++){d=o_.Bm(a.d,h[g],l);if(o_.Vj(a.d,d)==e&&b[d]){f=o_.zm(a.d,h[g],l);if(i[f]==0){if(e==1&&o_.wk(a.d,f)){m=h[g];while(m!=-1){o_.wl(a.d,o_.xm(a.d,f,m),e==1?2:1);e=3-e;f=m;m=j[m];}o_.cl(a.d,c,false);o_.cl(a.d,f,false);a.a-=2;return true;}h[++k]=f;j[f]=h[g];i[f]=i[h[g]]+1;}}}++g;}}}return false;};o_.rr=function rr(a){var b,c,d,e;for(b=0;b<a.d.d;b++){if(o_.Ij(a.d,b)==7&&o_.rj(a.d,b)==0&&o_.Sm(a.d,b)>3&&o_.qm(a.d,b)>0){for(e=0;e<o_.Am(a.d,b);e++){c=o_.zm(a.d,b,e);d=o_.Bm(a.d,b,e);if(o_.Vj(a.d,d)>1&&o_.uk(a.d,c)){o_.Yj(a.d,d)==4?o_.wl(a.d,d,2):o_.wl(a.d,d,1);o_.Vk(a.d,b,o_.rj(a.d,b)+1);o_.Vk(a.d,c,o_.rj(a.d,c)-1);break;}}}}};o_.sr=function sr(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C;o_.Jr(a.d,1);a.c=OI(h_.DN,C0,5,a.d.e,16,1);a.b=0;for(g=0;g<a.d.e;g++){if(o_.Yj(a.d,g)==64){o_.wl(a.d,g,1);a.c[g]=true;++a.b;}}C=new o_.aq(a.d,3);p=OI(h_.DN,C0,5,C.i.a.length,16,1);for(v=0;v<C.i.a.length;v++){A=l_.Th(C.i,v);p[v]=true;for(l=0;l<A.length;l++){if(!o_.wk(a.d,A[l])){p[v]=false;break;}}if(p[v]){B=l_.Th(C.j,v);for(m=0;m<B.length;m++){if(!a.c[B[m]]){a.c[B[m]]=true;++a.b;}}}}for(h=0;h<a.d.e;h++){!a.c[h]&&C.b[h]!=0&&o_.wk(a.d,o_.Nj(a.d,0,h))&&o_.wk(a.d,o_.Nj(a.d,1,h))&&o_.or(a,h);}o_.Jr(a.d,7);o=OI(h_.DN,C0,5,a.d.e,16,1);for(n=0;n<a.d.e;n++)o[n]=a.c[n];for(w=0;w<C.i.a.length;w++){if(p[w]){A=l_.Th(C.i,w);for(k=0;k<A.length;k++){if(!o_.yr(a,A[k])){if(o_.wk(a.d,A[k])){o_.cl(a.d,A[k],false);--a.a;}for(r=0;r<o_.Am(a.d,A[k]);r++){j=o_.Bm(a.d,A[k],r);if(a.c[j]){a.c[j]=false;--a.b;}}}}}}o_.xr(a);for(u=0;u<C.i.a.length;u++){if(p[u]&&l_.Th(C.j,u).length==6){B=l_.Th(C.j,u);q=true;for(d=B,e=0,f=d.length;e<f;++e){c=d[e];if(!a.c[c]){q=false;break;}}if(q){o_.wr(a,B[0]);o_.wr(a,B[2]);o_.wr(a,B[4]);o_.xr(a);}}}for(t=5;t>=4;t--){do{s=false;for(c=0;c<a.d.e;c++){if(a.c[c]){b=0;for(k=0;k<2;k++){i=o_.Nj(a.d,k,c);for(r=0;r<o_.Am(a.d,i);r++)a.c[o_.Bm(a.d,i,r)]&&++b;}if(b==t){o_.wr(a,c);o_.xr(a);s=true;break;}}}}while(s);}while(a.a>=2)if(!o_.qr(a,o))break;if(a.a!=0)throw IN(new i_.EG(R1));if(a.b!=0)throw IN(new i_.EG(R1));};o_.tr=function tr(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab;a.d=b;o_._i(a.d);P=null;l=OI(h_.hK,k0,5,64,15,1);l[0]=-1;R=OI(h_.hK,k0,5,64,15,1);T=OI(h_.hK,k0,5,64,15,1);S=OI(h_.hK,k0,5,64,15,1);for(B=0;B<64;B++)R[B]=-1;j=0;u=-1;V=false;Q=false;U=false;n=0;m=1;while(c[d]<=32)++d;while(d<e){W=c[d++]&f0;if(YP(W)||W==42){k=0;t=-1;F=false;O=false;D=false;if(V){if(W==82&&XP(c[d]&f0)){J=XP(c[d+1]&f0)?2:1;k=o_.Yl(i_.XR(n_.D$(c,d-1,(H=1+J,n_.A$(),H))));d+=J;}else {G=_P(c[d]&f0)==(c[d]&f0)&&YP(c[d]&f0)?2:1;k=o_.Yl(i_.XR(n_.D$(c,d-1,(H=G,n_.A$(),H))));d+=G-1;t=0;}if(c[d]==64){++d;if(c[d]==64){D=true;++d;}O=true;}if(c[d]==72){++d;t=1;if(XP(c[d]&f0)){t=c[d]-48;++d;}}}else if(W==42){k=6;F=true;}else {switch(String.fromCharCode(W).toUpperCase().charCodeAt(0)){case 66:if(d<e&&c[d]==114){k=35;++d;}else k=5;break;case 67:if(d<e&&c[d]==108){k=17;++d;}else k=6;break;case 70:k=9;break;case 73:k=53;break;case 78:k=7;break;case 79:k=8;break;case 80:k=15;break;case 83:k=16;}}if(k==0)throw IN(new i_.EG('SmilesParser: unknown element label found'));i=o_.Ni(a.d,k);if(F){U=true;o_.fl(a.d,i,1,true);}if(_P(W)==W&&YP(W)){o_.cl(a.d,i,true);++a.a;}else {o_.cl(a.d,i,false);}if(t!=-1&&k!=1){o=OI(h_.dK,j0,5,1,15,1);o[0]=t<<24>>24;o_.Zk(a.d,i,o);}u=l[n];l[n]!=-1&&m!=128&&o_.Pi(a.d,l[n],i,m);m=1;l[n]=i;if(j!=0){o_.dl(a.d,i,j);j=0;}if(g){M=!P?null:l_.hW(P,i_.nR(u));!!M&&o_.Ar(M,i,d,k==1&&j==0);if(O){!P&&(P=new l_.yY());l_.qY(P,i_.nR(i),new o_.Dr(a,i,u,t,d,D));}}continue;}if(W==46){l[n]=-1;m=128;continue;}if(W==61){m=2;continue;}if(W==35){m=4;continue;}if(XP(W)){K=W-48;if(V){while(d<e&&XP(c[d]&f0)){K=10*K+c[d]-48;++d;}j=K;}else {w=c[d-2]==45||c[d-2]==47||c[d-2]==92||c[d-2]==61||c[d-2]==35||c[d-2]==58;if(Q&&d<e&&XP(c[d]&f0)){K=10*K+c[d]-48;++d;}Q=false;if(K>=64)throw IN(new i_.EG('SmilesParser: ringClosureAtom number out of range'));if(R[K]==-1){R[K]=l[n];T[K]=d-1;S[K]=w?m:-1;}else {if(R[K]==l[n])throw IN(new i_.EG('SmilesParser: ring closure to same atom'));if(g&&!!P){M=l_.hW(P,i_.nR(R[K]));!!M&&o_.Ar(M,l[n],T[K],false);M=l_.hW(P,i_.nR(l[n]));!!M&&o_.Ar(M,R[K],d-1,false);}S[K]!=-1?m=S[K]:m==17?m=9:m==9&&(m=17);o_.Pi(a.d,R[K],l[n],m);R[K]=-1;}m=1;}continue;}if(W==43){if(!V)throw IN(new i_.EG("SmilesParser: '+' found outside brackets"));p=1;while(c[d]==43){++p;++d;}if(p==1&&XP(c[d]&f0)){p=c[d]-48;++d;}o_.Vk(a.d,l[n],p);continue;}if(W==45){if(!V)continue;p=-1;while(c[d]==45){--p;++d;}if(p==-1&&XP(c[d]&f0)){p=48-c[d];++d;}o_.Vk(a.d,l[n],p);continue;}if(W==40){if(l[n]==-1)throw IN(new i_.EG('Smiles with leading parenthesis are not supported'));l[n+1]=l[n];++n;continue;}if(W==41){--n;continue;}if(W==91){if(V)throw IN(new i_.EG('SmilesParser: nested square brackets found'));V=true;continue;}if(W==93){if(!V)throw IN(new i_.EG('SmilesParser: closing bracket without opening one'));V=false;continue;}if(W==37){Q=true;continue;}if(W==58){if(!V){m=64;continue;}I=0;while(XP(c[d]&f0)){I=10*I+c[d]-48;++d;}o_.bl(a.d,l[n],I,false);continue;}if(W==47){g&&(m=17);continue;}if(W==92){g&&(m=9);continue;}if(W<=32){d=e;continue;}throw IN(new i_.EG("SmilesParser: unexpected character found: '"+String.fromCharCode(W)+"'"));}if(m!=1)throw IN(new i_.EG('SmilesParser: dangling open bond'));for(C=0;C<64;C++)if(R[C]!=-1)throw IN(new i_.EG('SmilesParser: dangling ring closure'));v=o_.Lm(a.d);o_.Al(a.d,true);o_.Jr(a.d,1);for(h=0;h<a.d.o;h++){if((b.r==null?null:b.r[h]==null?null:i_.FR(b.r[h]))!=null){if(!o_.wk(a.d,h)){s=o_.uj(a.d,h)[0];if(o_.Ij(a.d,h)<(o_.Li(),o_.Hi).length&&o_.Hi[o_.Ij(a.d,h)]!=null){q=false;X=o_.Sm(a.d,h);X-=o_.ak(a.d,h,X);for(Z=o_.Hi[o_.Ij(a.d,h)],$=0,ab=Z.length;$<ab;++$){Y=Z[$];if(X<=Y){q=true;Y!=X+s&&o_.Tk(a.d,h,X+s);break;}}q||o_.Tk(a.d,h,X+s);}else {for(A=0;A<s;A++)o_.Pi(b,h,o_.Ni(b,1),1);}}}}o_.Jr(a.d,1);o_.rr(a);o_.sr(a);a.d.r=null;o_.Al(a.d,false);if(g){o_.pr(a);if(P){for(N=(L=new l_.IY(new l_.NY(new l_.MV(P).a).b),new l_.TV(L));l_.OU(N.a.a);){M=(r=l_.GY(N.a),r.Tb());o_.el(a.d,M.a,o_.Br(M,v),false);}o_.Kn(a.d,0);}}o_.Kn(a.d,0);if(f){q_.$s(new q_.pt(),a.d);g&&o_.Wr(a.d);}U&&o_.yl(a.d,true);};o_.ur=function ur(a,b,c,d){o_.tr(a,b,c,0,c.length,false,d);};o_.vr=function vr(a,b){var c,d,e,f,g,h;d=u_.YF(b,0);e=d==-1?-1:u_.YF(b,d+1);if(e==-1)throw IN(new i_.EG("Missing one or both separators ('>')."));if(u_.YF(b,e+1)!=-1)throw IN(new i_.EG("Found more than 2 separators ('>')."));g=new o_.$r();o_.tr(a,g,b,0,d,true,true);f=new o_.$r();o_.tr(a,f,b,e+1,b.length,true,true);c=null;if(e-d>1){c=new o_.$r();o_.tr(a,c,b,d+1,e,true,true);}h=new s_.Zu();l_.Oh(h.g,g);h.d=-1;l_.Oh(h.f,f);h.d=-1;!!c&&l_.Oh(h.a,c);return h;};o_.wr=function wr(a,b){var c,d,e,f;o_.Yj(a.d,b)==1&&o_.wl(a.d,b,2);for(e=0;e<2;e++){c=o_.Nj(a.d,e,b);if(o_.wk(a.d,c)){o_.cl(a.d,c,false);--a.a;}for(f=0;f<o_.Am(a.d,c);f++){d=o_.Bm(a.d,c,f);if(a.c[d]){a.c[d]=false;--a.b;}}}};o_.xr=function xr(a){var b,c,d,e,f,g,h;do{h=false;for(c=0;c<a.d.e;c++){if(a.c[c]){f=false;for(e=0;e<2;e++){b=false;d=o_.Nj(a.d,e,c);for(g=0;g<o_.Am(a.d,d);g++){if(c!=o_.Bm(a.d,d,g)&&a.c[o_.Bm(a.d,d,g)]){b=true;break;}}if(!b){f=true;break;}}if(f){h=true;o_.wr(a,c);}}}}while(h);};o_.yr=function yr(a,b){var c,d;if(o_.Ij(a.d,b)==6&&o_.rj(a.d,b)!=0||!o_.wk(a.d,b))return false;c=o_.tj(a.d,b)==null?0:o_.uj(a.d,b)[0];d=o_.Jm(a.d,b)-c;if(d<1)return false;if(o_.Ij(a.d,b)==16||o_.Ij(a.d,b)==34||o_.Ij(a.d,b)==52){if(o_.Am(a.d,b)==2&&o_.rj(a.d,b)<=0)return false;if(d==2)return false;}if(o_.Ij(a.d,b)!=5&&o_.Ij(a.d,b)!=6&&o_.Ij(a.d,b)!=7&&o_.Ij(a.d,b)!=8&&o_.Ij(a.d,b)!=15&&o_.Ij(a.d,b)!=16&&o_.Ij(a.d,b)!=33&&o_.Ij(a.d,b)!=34)return false;return true;};o_.zr=function zr(){};xO(105,1,{},o_.zr);_.a=0;_.b=0;h_.VK=jQ(105);o_.Ar=function Ar(a,b,c,d){if(a.b)return;if(a.g==4||a.g==3&&a.c!=-1){a.b=true;return;}a.i[a.g]=d;a.f[a.g]=b;a.j[a.g]=c;++a.g;};o_.Br=function Br(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p;if(a.b)return 3;a.c!=-1&&(a.c=b[a.c]);for(g=0;g<a.g;g++)a.f[g]!=P_&&(a.f[g]=b[a.f[g]]);if(a.c==-1&&a.d==0){n=P_;m=-1;for(h=0;h<a.g;h++){if(n>a.j[h]){n=a.j[h];m=h;}}a.c=a.f[m];for(i=m+1;i<a.g;i++){a.f[i-1]=a.f[i];a.j[i-1]=a.j[i];a.i[i-1]=a.i[i];}--a.g;}p=(a.c==-1?0:1)+a.d+a.g;if(p>4||p<3)return 3;c=a.c==-1&&a.d==1||a.c!=-1&&o_.yn(a.k.d,a.c);e=-1;for(j=0;j<a.g;j++){if(a.i[j]){if(e!=-1||c)return 3;e=j;}}l=false;if(e!=-1)for(k=0;k<a.g;k++)!a.i[k]&&a.f[e]<a.f[k]&&(l=!l);d=false;if(a.c!=-1&&!c)for(f=0;f<a.g;f++)a.c<a.f[f]&&(d=!d);o=a.e^o_.Cr(a.f,a.j,a.g)^d^l?2:1;return o;};o_.Cr=function Cr(a,b,c){var d,e,f;e=false;for(d=1;d<c;d++){for(f=0;f<d;f++){a[f]>a[d]&&(e=!e);b[f]>b[d]&&(e=!e);}}return e;};o_.Dr=function Dr(a,b,c,d,e,f){this.k=a;if(d!=0&&d!=1){this.b=true;}else {this.a=b;this.c=c;this.d=d;this.e=f;this.g=0;this.i=OI(h_.DN,C0,5,4,16,1);this.f=OI(h_.hK,k0,5,4,15,1);this.j=OI(h_.hK,k0,5,4,15,1);if(c!=-1&&d==1){o_.Ar(this,P_,e,true);this.d=0;}}};xO(117,1,{117:1},o_.Dr);_.a=0;_.b=false;_.c=0;_.d=0;_.e=false;_.g=0;h_.UK=jQ(117);o_.Er=function Er(a){a.c=new l_.gi();};o_.Fr=function Fr(a,b){var c,d,e,f;f=a.c.a.length;if(f==0){l_.Nh(a.c,0,b);return 0;}e=1;while(2*e<=f)e<<=1;d=e;--e;while(d!=0){d>>=1;if(e>=f){e-=d;continue;}c=i_.CR(b,l_.Th(a.c,e));if(c==0)return -1;if(d==0)break;c<0?e-=d:e+=d;}e<f&&i_.CR(b,l_.Th(a.c,e))>0&&++e;l_.Nh(a.c,e,b);return e;};o_.Gr=function Gr(a,b){var c,d,e,f;f=a.c.a.length;if(f==0)return -1;e=1;while(2*e<=f)e<<=1;d=e;--e;while(d!=0){d>>=1;if(e>=f){e-=d;continue;}c=i_.CR(b,l_.Th(a.c,e));if(c==0)return e;if(d==0)break;c<0?e-=d:e+=d;}return -1;};o_.Hr=function Hr(){o_.Er(this);};xO(123,1,f1,o_.Hr);h_.WK=jQ(123);o_.Ir=function Ir(a,b){o_.fj(a,b);!!a.b&&(b.R=0);};o_.Jr=function Jr(a,b){var c,d,e,f;o_.fm(a,b);if((b&~a.R)==0)return;a.a&&(b|=256);for(c=0;c<a.o;c++)a.s[c]&=-134447112;for(d=0;d<a.e;d++)a.C[d]&=-64;e=0;f=0;if((b&32)!=0){e=32;f=1;}else if((b&64)!=0){e=64;f=3;}else if((b&128)!=0){e=128;f=5;}if((b&256)!=0){e|=256;f|=32;}a.b=new o_.Lf(a,f);o_.Gf(a.b);o_.Hf(a.b);o_.Ff(a.b);o_.Zr(a)&&(a.b=new o_.Lf(a,f));a.R|=24|e;};o_.Kr=function Kr(a,b){return o_.tf(a.b,b);};o_.Lr=function Lr(a,b){return o_.kf(a.b,b);};o_.Mr=function Mr(a){var b;o_.Jr(a,31);b=a.G&f0;switch(a.G&j1){case e0:return null;case h1:return b==1?'meso':''+b+' meso diastereomers';case 0:return 'unknown chirality';case 196608:return 'racemate';case b1:return 'this enantiomer';case 327680:return 'this or other enantiomer';case S0:return 'two epimers';default:return b==1?'one stereo isomer':''+b+' stereo isomers';}};o_.Nr=function Nr(a){var b;b=new o_._r(a.o,a.p);o_.ej(a,b);return b;};o_.Or=function Or(a){var b,c,d,e,f,g,h;o_.Jr(a,15);g=OI(h_.hK,k0,5,3,15,1);for(c=0;c<a.d;c++){if((a.s[c]&r1)!=0){h=(a.s[c]&Y0)>>19;h!=0&&(g[h]=$wnd.Math.max(g[h],(a.s[c]&Y0)>>19!=1&&(a.s[c]&Y0)>>19!=2?-1:(a.s[c]&m1)>>21));}}for(e=0;e<a.e;e++){if(((a.C[e]&3)==1||(a.C[e]&3)==2)&&a.F[e]==1){h=(a.C[e]&n1)>>10;h!=0&&(g[h]=$wnd.Math.max(g[h],(a.C[e]&n1)>>10!=1&&(a.C[e]&n1)>>10!=2?-1:(a.C[e]&o1)>>12));}}f=OI(h_.hK,d1,6,3,0,2);f[1]=OI(h_.hK,k0,5,1+g[1],15,1);f[2]=OI(h_.hK,k0,5,1+g[2],15,1);for(b=0;b<a.d;b++){if((a.s[b]&r1)!=0){h=(a.s[b]&Y0)>>19;h!=0&&++f[h][(a.s[b]&Y0)>>19!=1&&(a.s[b]&Y0)>>19!=2?-1:(a.s[b]&m1)>>21];}}for(d=0;d<a.e;d++){if(((a.C[d]&3)==1||(a.C[d]&3)==2)&&a.F[d]==1){h=(a.C[d]&n1)>>10;h!=0&&++f[h][(a.C[d]&n1)>>10!=1&&(a.C[d]&n1)>>10!=2?-1:(a.C[d]&o1)>>12];}}return f;};o_.Pr=function Pr(a){var b,c;b=OI(h_.hK,k0,5,a.o,15,1);c=o_.Im(a,b,false,false);return o_.Qr(a,b,c);};o_.Qr=function Qr(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;q=OI(h_.XK,K_,23,c,0,1);g=OI(h_.hK,k0,5,c,15,1);j=OI(h_.hK,k0,5,c,15,1);f=OI(h_.hK,k0,5,a.o,15,1);for(e=0;e<a.o;e++)b[e]!=-1&&(f[e]=g[b[e]]++);for(i=0;i<a.p;i++){o=b[a.B[0][i]];p=b[a.B[1][i]];o==p&&o!=-1&&++j[o];}for(r=0;r<c;r++){q[r]=new o_._r(g[r],j[r]);o_.Ir(a,q[r]);}for(d=0;d<a.o;d++)b[d]!=-1&&o_.bj(a,q[b[d]],d,0,0);for(h=0;h<a.p;h++){o=b[a.B[0][h]];p=b[a.B[1][h]];o==p&&o!=-1&&o_.dj(a,q[o],h,0,0,f,false);}for(l=q,m=0,n=l.length;m<n;++m){k=l[m];o_.Pk(k,1);o_.Pk(k,2);}return q;};o_.Rr=function Rr(a){o_.Jr(a,15);return !a.b?null:o_.of(a.b);};o_.Sr=function Sr(a){o_.Jr(a,15);return !a.b?null:o_.lf(a.b);};o_.Tr=function Tr(a){var b,c;o_.Jr(a,31);c=0;for(b=0;b<a.d;b++)(a.s[b]&3)!=0&&(a.s[b]&4)==0&&++c;return c;};o_.Ur=function Ur(a,b){return o_.sf(a.b,b);};o_.Vr=function Vr(a,b){a.a=b;a.R&=-272;};o_.Wr=function Wr(a){o_.Jr(a,31);!!a.b&&o_.If(a.b);};o_.Xr=function Xr(a){var b,c;o_.Jr(a,15);a.J=false;for(b=0;b<a.o;b++){a.s[b]&=t1;(a.s[b]&3)!=0?a.s[b]|=q1:a.s[b]&=-67108865;}for(c=0;c<a.p;c++)(a.C[c]&3)!=0&&o_.Vj(a,c)==2?a.F[c]=26:a.F[c]&=-25;a.R&=-505;};o_.Yr=function Yr(a){var b,c,d,e,f,g;o_.Qn(a);o_.Jr(a,31);for(d=0;d<a.d;d++){if(((a.s[d]&Y0)>>19==1||(a.s[d]&Y0)>>19==2)&&((a.s[d]&r1)==0||(a.s[d]&3)==3))throw IN(new i_.EG(S1));if((a.s[d]&h1)!=0)throw IN(new i_.EG('Over- or under-specified stereofeature or more than one racemic type bond'));if(((a.s[d]&3)==1||(a.s[d]&3)==2)&&a.k[d]==0){b=OI(h_.fK,B0,5,a.g[d],15,1);for(f=0;f<a.g[d];f++)b[f]=o_.Mj(a,d,a.f[d][f]);for(e=1;e<a.g[d];e++)if(!o_.Ek(a,a.i[d][e],d))for(g=0;g<e;g++)if(!o_.Ek(a,a.i[d][g],d)){c=$wnd.Math.abs(o_.Xl(b[e],b[g]));if(c<0.08||c>x1)throw IN(new i_.EG(T1));}}}};o_.Zr=function Zr(a){var b,c,d,e,f,g,h;h=false;for(c=0;c<a.d;c++)((a.s[c]&r1)==0||(a.s[c]&3)==3)&&(a.s[c]&=t1);for(f=0;f<a.e;f++)(o_.Vj(a,f)!=1||(a.C[f]&3)==0||(a.C[f]&3)==3)&&(a.C[f]&=-130049);if(a.J){if((a.G&j1)!=h1){g=OI(h_.DN,C0,5,a.d,16,1);for(d=0;d<a.d;d++)(a.s[d]&r1)!=0&&(a.s[d]&3)!=3&&(a.s[d]&Y0)>>19==1&&(g[d]=true);for(e=0;e<a.d;e++){if((a.s[e]&r1)!=0&&(a.s[e]&3)!=3){o_.$k(a,e,1,0);h=true;}}for(b=0;b<a.d;b++){if(g[b]){o_.el(a,b,1,false);o_.$k(a,b,1,-1);h=true;}}}a.J=false;}o_.Pk(a,1);o_.Pk(a,2);return h;};o_.$r=function $r(){o_.Li();o_.Tn.call(this);};o_._r=function _r(a,b){o_.Li();o_.Un.call(this,a,b);};o_.as=function as(a){o_.Li();o_.Vn.call(this,a);};xO(23,71,{71:1,62:1,23:1,4:1},o_.$r,o_._r,o_.as);_.pb=function bs(a){o_.Ir(this,a);};_.qb=function cs(a){o_.Jr(this,a);};_.a=false;h_.XK=jQ(23);o_.ds=function ds(a){a.b=new l_.gi();a.a=new l_.gi();};o_.es=function es(a,b){var c,d;c=o_.Fr(a,b);if(c==-1)return -1;d=a.b.a.length;l_.Oh(a.b,b);l_.Nh(a.a,c,new i_.dR(d));return d;};o_.fs=function fs(){o_.Hr.call(this);o_.ds(this);};xO(148,123,f1,o_.fs);h_.YK=jQ(148);p_.hs=function hs(){p_.hs=zO;p_.gs=o_.Yl('X');};p_.is=function is(a,b){p_.hs();var c,d,e,f,g;for(e=0;e<a.o;e++){g=o_.Nr(a);o_.ml(g,e,p_.gs);o_.Jr(g,15);for(d=0;d<g.d;d++){if((g.s[d]&r1)!=0&&o_._m(g,d)==-1){f=(o_.Jr(g,7),g.k[d]==2&&g.g[d]==2?o_.En(g,d):o_.Gn(g,d));if(f!=-1){a.F[f]=17;a.R=0;if(a.B[1][f]==d){c=a.B[0][f];a.B[0][f]=d;a.R=0;a.B[1][f]=c;a.R=0;}o_.$k(a,d,b,0);}}}}};p_.js=function js(a){p_.hs();var b,c,d,e;p_.is(a,1);d=a.o;c=OI(h_.uM,d0,2,d,6,1);for(b=0;b<d;b++){e=o_.Nr(a);o_.Yk(e,b,(o_.Li(),o_.Gi)[e.A[b]]+'*');e.A[b]==1?o_.ml(e,b,p_.gs):o_.dl(e,b,e.v[b]+5);p_.ks(e);c[b]=o_.of(new o_.Lf(e,8));}return c;};p_.ks=function ks(a){var b;o_.Jr(a,15);for(b=0;b<a.o;b++){(a.s[b]&3)!=0&&o_.$k(a,b,1,0);}};p_.gs=0;p_.ls=function ls(a,b,c){var d,e;d=MI(h_.uM,[K_,d0],[29,2],6,[a.d,b],2);o_.Jr(a,7);for(e=0;e<a.d;e++){d[e]=p_.ms(a,e,b,c);}return d;};p_.ms=function ms(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p;i=new o_._r(a.d,a.e);k=new l_.wZ();n=0;m=0;g=OI(h_.DN,C0,5,a.d,16,1);f=OI(h_.hK,k0,5,a.d,15,1);for(p=0;p<c&&m<a.d;p++){if(m==0){f[0]=b;g[b]=true;m=1;}else {o=m;for(j=n;j<m;j++){e=f[j];for(l=0;l<a.g[e];l++){h=a.f[e][l];if(!g[h]){switch(d){case 0:g[h]=true;f[o++]=h;break;case 1:if(!(p_.os(a,e)&&p_.os(a,h))){g[h]=true;f[o++]=h;}}}}}n=m;m=o;}o_.dm(a,i,g,true,null);l_.tZ(k,o_.of(new o_.Lf(i,8)));}return l_.vZ(k,OI(h_.uM,d0,2,k.a.a.length,6,1));};p_.ns=function ns(a,b,c){var d,e,f,g,h;g=o_._n(new o_.io(true),a);e=-1;for(f=0;f<g.o;f++){d=g.r==null?null:g.r[f]==null?null:i_.FR(g.r[f]);if(d!=null&&(h=n_.V$('*').length,i_.GR(n_.V$(d).substr(n_.V$(d).length-h,h),'*'))){e=f;break;}}if(e>=0){return p_.ms(g,e,b,c);}return OI(h_.uM,d0,2,0,6,1);};p_.os=function os(a,b){if(a.A[b]!=6)return false;if(a.q[b]!=0)return false;if(o_.Nm(a,b)+a.g[b]!=4)return false;return true;};p_.zs=function zs(){p_.zs=zO;p_.ps=$wnd.Math.cos(a1);p_.us=$wnd.Math.sin(a1);p_.rs=$wnd.Math.cos(U1);p_.ws=$wnd.Math.sin(U1);p_.ts=$wnd.Math.cos(_0);p_.ys=$wnd.Math.sin(_0);p_.qs=$wnd.Math.cos(V1);p_.vs=$wnd.Math.sin(V1);p_.ss=$wnd.Math.cos(w1);p_.xs=$wnd.Math.sin(w1);$wnd.Math.cos(W1);$wnd.Math.sin(W1);};p_.As=function As(a){p_.zs();var b,c;o_.Jr(a,1);c=a.d;for(b=0;b<c;b++){p_.Bs(a,b);}};p_.Bs=function Bs(a,b){p_.zs();var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P;H=o_.Nm(a,b);O=a.H[b].a;P=a.H[b].b;switch(H){case 1:{J=a.g[b];if(J==0){n=p1;B=-1;for(f=0;f<a.o;f++){if(f==b)continue;l=O-a.H[f].a;m=P-a.H[f].b;j=$wnd.Math.sqrt(l*l+m*m);if(n>j){n=j;B=f;}}p=O-a.H[B].a;s=P-a.H[B].b;}else {p=O-o_.Fj(a,a.f[b][0]);s=P-o_.Gj(a,a.f[b][0]);}if(J==1){C=o_.Mi(a,O+p_.ss*p+p_.xs*s,P-p_.xs*p+p_.ss*s,0);}else if(J==2){p=O-0.5*(o_.Fj(a,a.f[b][0])+o_.Fj(a,a.f[b][1]));s=P-0.5*(o_.Gj(a,a.f[b][0])+o_.Gj(a,a.f[b][1]));C=o_.Mi(a,O+p,P+s,0);}else if(J==3){L=a.f[b][0];for(w=1;w<3;w++){i=a.i[b][w];(a.F[i]==9||a.F[i]==17)&&(L=a.f[b][w]);}c=$wnd.Math.abs(o_.Xl(o_.Wl(a.H[b].a,a.H[b].b,o_.Fj(a,a.f[b][0]),o_.Gj(a,a.f[b][0])),o_.Wl(a.H[b].a,a.H[b].b,o_.Fj(a,a.f[b][1]),o_.Gj(a,a.f[b][1]))));d=$wnd.Math.abs(o_.Xl(o_.Wl(a.H[b].a,a.H[b].b,o_.Fj(a,a.f[b][0]),o_.Gj(a,a.f[b][0])),o_.Wl(a.H[b].a,a.H[b].b,o_.Fj(a,a.f[b][2]),o_.Gj(a,a.f[b][2]))));e=$wnd.Math.abs(o_.Xl(o_.Wl(a.H[b].a,a.H[b].b,o_.Fj(a,a.f[b][1]),o_.Gj(a,a.f[b][1])),o_.Wl(a.H[b].a,a.H[b].b,o_.Fj(a,a.f[b][2]),o_.Gj(a,a.f[b][2]))));K=true;if(c>d&&c>e){if(d+e<H0){K=false;p=O-0.5*(o_.Fj(a,a.f[b][0])+o_.Fj(a,a.f[b][1]));s=P-0.5*(o_.Gj(a,a.f[b][0])+o_.Gj(a,a.f[b][1]));}}else if(d>c&&d>e){if(c+e<H0){K=false;p=O-0.5*(o_.Fj(a,a.f[b][0])+o_.Fj(a,a.f[b][2]));s=P-0.5*(o_.Gj(a,a.f[b][0])+o_.Gj(a,a.f[b][2]));}}else {if(c+d<H0){K=false;p=O-0.5*(o_.Fj(a,a.f[b][1])+o_.Fj(a,a.f[b][2]));s=P-0.5*(o_.Gj(a,a.f[b][1])+o_.Gj(a,a.f[b][2]));}}if(K){M=a.f[b][0];o=p1;for(v=0;v<3;v++){g=a.f[b][v];if(g!=L){k=$wnd.Math.pow(a.H[b].a-a.H[g].a,2)+$wnd.Math.pow(a.H[b].b-a.H[g].b,2);if(k<o){M=g;o=k;i_.oS();}}}C=o_.Mi(a,(a.H[L].a+a.H[M].a)/2,(a.H[L].b+a.H[M].b)/2,0);}else {C=o_.Mi(a,O+p,P+s,0);}}else {C=o_.Mi(a,O+p,P+s,0);}o_.ml(a,C,1);o_.Pi(a,b,C,1);}break;case 2:I=a.g[b];if(I==1){p=O-o_.Fj(a,a.f[b][0]);s=P-o_.Gj(a,a.f[b][0]);C=o_.Mi(a,O+(p_.ts*p-p_.ys*s)*0.7,P+(p_.ys*p+p_.ts*s)*0.7,0);o_.ml(a,C,1);o_.Pi(a,b,C,1);C=o_.Mi(a,O+(p_.qs*p-p_.vs*s)*0.7,P+(p_.vs*p+p_.qs*s)*0.7,0);o_.ml(a,C,1);o_.Pi(a,b,C,1);}else if(I==2){q=O-o_.Fj(a,a.f[b][0]);t=P-o_.Gj(a,a.f[b][0]);r=O-o_.Fj(a,a.f[b][1]);u=P-o_.Gj(a,a.f[b][1]);F=$wnd.Math.sqrt(q*q+t*t)*0.7;G=$wnd.Math.sqrt(r*r+u*u)*0.7;p=q+r;s=t+u;D=$wnd.Math.sqrt(p*p+s*s);h=(F+G)/2;p=p/D*h;s=s/D*h;N=o_._m(a,b);C=o_.Mi(a,O+p_.ps*p-p_.us*s,P+p_.us*p+p_.ps*s,0);o_.ml(a,C,1);N>-1?o_.Pi(a,b,C,1):o_.Pi(a,b,C,17);C=o_.Mi(a,O+p_.rs*p-p_.ws*s,P+p_.ws*p+p_.rs*s,0);o_.ml(a,C,1);o_.Pi(a,b,C,1);}else {for(A=0;A<H;A++){C=o_.Mi(a,O,P,0);o_.ml(a,C,1);o_.Pi(a,b,C,1);}}break;case 3:{p=(O-o_.Fj(a,a.f[b][0]))*0.7;s=(P-o_.Gj(a,a.f[b][0]))*0.7;C=o_.Mi(a,O+p,P+s,0);o_.ml(a,C,1);o_.Pi(a,b,C,1);C=o_.Mi(a,O-s,P+p,0);o_.ml(a,C,1);o_.Pi(a,b,C,1);C=o_.Mi(a,O+s,P-p,0);o_.ml(a,C,1);o_.Pi(a,b,C,1);}break;default:{for(A=0;A<H;A++){C=o_.Mi(a,O,P,0);o_.ml(a,C,1);o_.Pi(a,b,C,1);}break;}}};p_.Cs=function Cs(a){p_.zs();var b,c;o_.Jr(a,1);c=0;for(b=0;b<a.o;b++){a.A[b]==1?++c:c+=a.c[b]-a.g[b]+o_.Nm(a,b);}return c;};p_.ps=0;p_.qs=0;p_.rs=0;p_.ss=0;p_.ts=0;p_.us=0;p_.vs=0;p_.ws=0;p_.xs=0;p_.ys=0;q_.Es=function Es(a,b,c){var d,e,f;f=b.length;d=new q_.cu(a.e,f,a.d);d.a[0]=0;d.b[0]=0;for(e=0;e<f;e++){d.k[e]=128-f;d.e[e]=b[e];}f<8?q_.Ns(d):q_.Ls(a,d,b,c);l_.Oh(a.c,d);};q_.Fs=function Fs(a,b,c){var d,e,f,g,h,i,j,k;e=OI(h_.hK,k0,5,16,15,1);for(d=0;d<a.e.o;d++){for(g=0;g<o_.mm(a.e,d);g++){k=c[o_.zm(a.e,d,g)];for(h=0;h<g;h++)if(k<e[h])break;for(i=g;i>h;i--)e[i]=e[i-1];e[h]=k;}j=$wnd.Math.min(6,o_.mm(a.e,d));o_._f(b[d],d);o_.Yf(b[d],16,h_.SN(c[d]));o_.Yf(b[d],(6-j)*17,0);for(f=0;f<j;f++)o_.Yf(b[d],17,h_.SN(e[f]));}};q_.Gs=function Gs(a){var b,c,d,e,f,g,h;c=OI(h_.rK,e1,74,a.e.o,0,1);for(b=0;b<a.e.o;b++){c[b]=new o_.ag(2);o_._f(c[b],b);}h=OI(h_.hK,k0,5,a.e.o,15,1);for(d=0;d<a.e.e;d++){e=o_.Wj(a.e,d);if(e==1||e==2){o_.Zf(c[o_.Nj(a.e,0,d)],h_.SN(e));o_.Zf(c[o_.Nj(a.e,1,d)],h_.SN(e));}}f=q_.Hs(c,h);do{g=f;q_.Fs(a,c,h);f=q_.Hs(c,h);}while(g!=f);return h;};q_.Hs=function Hs(a,b){var c,d;d=0;l_._W(a,0,a.length,null);for(c=0;c<a.length;c++){(c==0||o_.$f(a[c],a[c-1])!=0)&&++d;b[a[c].a]=d;}return d;};q_.Is=function Is(a){var b,c,d,e,f,g,h,i,j,k,l,m;for(i=0;i<a.c.a.length;i++){h=l_.Th(a.c,i);for(j=0;j<h.f.length;j++){d=h.f[j];if(o_.Vj(a.e,d)==2){!o_.An(a.e,d)&&(o_.Wj(a.e,d)==3||o_.Wj(a.e,d)==0)&&o_.ul(a.e,d);if(!o_.xn(a.e,d)&&o_.Am(a.e,o_.Nj(a.e,0,d))>1&&o_.Am(a.e,o_.Nj(a.e,1,d))>1&&(o_.Wj(a.e,d)==1||o_.Wj(a.e,d)==2)){m=OI(h_.hK,k0,5,2,15,1);e=OI(h_.hK,k0,5,2,15,1);for(k=0;k<2;k++){m[k]=a.e.K;e[k]=o_.Nj(a.e,k,d);for(l=0;l<o_.mm(a.e,e[k]);l++){f=o_.zm(a.e,e[k],l);f!=o_.Nj(a.e,1-k,d)&&m[k]>f&&(m[k]=f);}}g=q_.Kt(h.a[h.g[e[0]]],h.b[h.g[e[0]]],h.a[h.g[e[1]]],h.b[h.g[e[1]]]);b=q_.Kt(h.a[h.g[m[0]]],h.b[h.g[m[0]]],h.a[h.g[e[0]]],h.b[h.g[e[0]]]);c=q_.Kt(h.a[h.g[e[1]]],h.b[h.g[e[1]]],h.a[h.g[m[1]]],h.b[h.g[m[1]]]);q_.Ps(g,b)<0^q_.Ps(g,c)<0^o_.Wj(a.e,d)==2&&q_.Tt(h,d);}}}}};q_.Js=function Js(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;m=new l_.gi();r=new l_.gi();d=new l_.gi();for(f=new l_.KW(a.c);f.a<f.c.a.length;){e=l_.JW(f);g=0;d.a=OI(h_.nM,W_,1,0,5,1);for(h=0;h<e.e.length;h++){b=e.e[h];c=a.g[b];if(c!=0){l_.Oh(d,new q_.Mt(e,h,c));g+=c;}}if(g!=0){l_.di(d,new q_.tt());for(j=new l_.KW(d);j.a<j.c.a.length;){i=l_.JW(j);if(g*i.b>0){c=$wnd.Math.abs(g)>=$wnd.Math.abs(i.b)?i.b:g;g-=c;l_.Oh(c<0?m:r,new q_.Mt(e,i.a,c));if(g==0)break;}}}}if(m.a.length==0||r.a.length==0)return null;l_.di(r,new q_.xt());l_.di(m,new q_.Bt());for(p=new l_.KW(r);p.a<p.c.a.length;){n=l_.JW(p);for(l=new l_.KW(m);l.a<l.c.a.length;){k=l_.JW(l);if(n.b==-k.b){a.g[q_.Xt(n.c,n.a)]-=n.b;a.g[q_.Xt(k.c,k.a)]-=k.b;return new q_.Ht(n.c,k.c,n.a,k.a);}}}for(q=new l_.KW(r);q.a<q.c.a.length;){n=l_.JW(q);for(l=new l_.KW(m);l.a<l.c.a.length;){k=l_.JW(l);if(n.b>-k.b){a.g[q_.Xt(n.c,n.a)]+=k.b;a.g[q_.Xt(k.c,k.a)]-=k.b;return new q_.Ht(n.c,k.c,n.a,k.a);}}}for(o=new l_.KW(r);o.a<o.c.a.length;){n=l_.JW(o);for(l=new l_.KW(m);l.a<l.c.a.length;){k=l_.JW(l);if(n.b<-k.b){a.g[q_.Xt(n.c,n.a)]-=n.b;a.g[q_.Xt(k.c,k.a)]+=n.b;return new q_.Ht(n.c,k.c,n.a,k.a);}}}return null;};q_.Ks=function Ks(a){if(a.c.a.length<2)return null;return new q_.Gt(l_.Th(a.c,0),l_.Th(a.c,1));};q_.Ls=function Ls(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C;k=XI(II(h_.fK,2),K_,14,0,[XI(II(h_.fK,1),B0,5,15,[20]),null,null,XI(II(h_.fK,1),B0,5,15,[0,10]),null,null,XI(II(h_.fK,1),B0,5,15,[-4,12]),XI(II(h_.fK,1),B0,5,15,[0,0,-7.5]),null,null,null,null,XI(II(h_.fK,1),B0,5,15,[8,-8]),null,null,null,XI(II(h_.fK,1),B0,5,15,[-2.4])]);l=XI(II(h_.hK,2),d1,6,0,[XI(II(h_.hK,1),k0,5,15,[146]),XI(II(h_.hK,1),k0,5,15,[627]),null,XI(II(h_.hK,1),k0,5,15,[2457,1170]),null,XI(II(h_.hK,1),k0,5,15,[2451,8643,2519]),XI(II(h_.hK,1),k0,5,15,[9362,14798]),XI(II(h_.hK,1),k0,5,15,[34377,-2147448999,26214]),null,XI(II(h_.hK,1),k0,5,15,[37449,137313,95703,34371,37815,54891,132867,-2147309741,54857,55129,-2147449005,-2147449065]),null,XI(II(h_.hK,1),k0,5,15,[530697,531819,899169,137289,694617,-2146951863,-2146952797,-2146939175,-2146929547,-2146929564,-2146625111,-2146931799,-2146940503,-2146931935]),XI(II(h_.hK,1),k0,5,15,[1007293,610915]),XI(II(h_.hK,1),k0,5,15,[542985,137283,2122017,530691,2206773,-2144711351,219209,2840841,137555,-2146871031,-2147264167,613705,-2145360543,-2146625271,694611,2454837,-2145356703,-2147345133,-2146928951,-2146931805,-2144641719,-2146951869,-2146625237,-2146624183,2841963,1074905,-2146625117,2799955,-2144723645,138583,859225,-2145264843,-2145216253,-2146624149,-2144700727,-2146928917,-2143905527,-2144045771,-2146789097,2288547,544407,2104323,-2146911977,-2144479405,3633737,-2146870089,-2146952169]),null,XI(II(h_.hK,1),k0,5,15,[8487297,2172633,2116611,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8829813]),XI(II(h_.hK,1),k0,5,15,[14071213])]);s=1<<b.e.length;g=0;i=0;if(b.e.length>7){for(n=0;n<b.e.length;n++){h=q_.Ts(a,c,d,n);h==1?g+=s:h==2&&(i+=s);g>>>=1;i>>>=1;}}v=b.e.length-9;if(b.e.length>=9&&b.e.length<=25&&l[v]!=null){for(C=0;C<l[v].length;C++){r=($_&l[v][C])==0;j=P_&l[v][C];for(p=false;!p;p=!p){if(p){if(r)break;t=0;for(e=1;e!=s;e<<=1){t<<=1;(j&e)!=0&&(t|=1);}j=t;}for(w=0;w<b.e.length;w++){if((j&g)==0&&(~j&i)==0){f=0;m=0.017453292519943295*(k[v]==null?0:k[v][C]);u=0;A=j;q=true;for(o=0;o<b.e.length;o++){q&&++u;(A&1)==0&&(q=!q);A>>>=1;}B=u>(b.e.length/2|0);for(n=1;n<b.e.length;n++){b.a[n]=b.a[n-1]+$wnd.Math.sin(f);b.b[n]=b.b[n-1]+$wnd.Math.cos(f);(j&1)==0&&(B=!B);f+=m+(B?_0:V1);j>>>=1;}return;}(j&1)!=0&&(j|=s);j>>>=1;}}}}q_.Os(b,g,i);};q_.Ms=function Ms(a){var b,c,d,e,f,g,h,i,j,k;b=null;j=null;for(g=0;g<a.e.e;g++){if(o_.Yj(a.e,g)==32){c=o_.Nj(a.e,0,g);e=-1;h=0;for(;h<a.c.a.length;h++){e=q_.Yt(l_.Th(a.c,h),c);if(e!=-1)break;}d=o_.Nj(a.e,1,g);f=-1;i=0;for(;i<a.c.a.length;i++){f=q_.Yt(l_.Th(a.c,i),d);if(f!=-1)break;}if(h!=i){if(h>i){k=h;h=i;i=k;k=e;e=f;f=k;}j==null&&(j=OI(h_.bL,K_,217,a.c.a.length,0,2));j[i]==null&&(j[i]=OI(h_.bL,{217:1,4:1,7:1},54,i,0,1));if(j[i][h])q_.Et(j[i][h],e,f);else {TI(j[i],h,new q_.Ht(l_.Th(a.c,h),l_.Th(a.c,i),e,f));!b&&(b=new l_.gi());l_.Oh(b,j[i][h]);}}}}return b;};q_.Ns=function Ns(a){var b,c;b=H0-H0*(a.e.length-2)/a.e.length;for(c=1;c<a.e.length;c++){a.a[c]=a.a[c-1]+$wnd.Math.sin(b*(c-1));a.b[c]=a.b[c-1]+$wnd.Math.cos(b*(c-1));}};q_.Os=function Os(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;if(b==0||(b&c)!=0){q_.Ns(a);return;}q=-1;r=0;f=1<<a.e.length-2;e=1<<a.e.length-1;h=1;g=2;for(j=0;j<a.e.length;j++){if((c&(e|h))==0&&(b&(e|h))!=0&&(b&f)==0){o=0;(c&f)!=0&&(o+=4);(b&e)!=0&&(o+=2);(b&h)!=0&&(o+=1);if(r<o){r=o;q=j;}}f=e;e=h;h=g;g=1<<(j+2<a.e.length?j+2:j+2-a.e.length);}if(q==-1){q_.Ns(a);return;}m=0;m|=1<<q;n=2;while(n<a.e.length-1){l=q+n<a.e.length?q+n:q+n-a.e.length;e=1<<(l==0?a.e.length-1:l-1);if((c&e)!=0){++n;continue;}h=1<<l;if((b&e)!=0){if((c&h)!=0){q_.Ns(a);return;}m|=h;n+=2;continue;}g=1<<(l+1<a.e.length?l+1:l+1-a.e.length);if((b&h)!=0&&(c&g)!=0){m|=h;n+=3;continue;}++n;}if(m==0){q_.Ns(a);return;}d=H0-H0*(a.e.length-2)/a.e.length;for(k=1;k<a.e.length;k++){a.a[k]=a.a[k-1]+$wnd.Math.sin(d*(k-1));a.b[k]=a.b[k-1]+$wnd.Math.cos(d*(k-1));}h=1;p=2*$wnd.Math.sin(d/2);for(i=0;i<a.e.length;i++){if((m&h)!=0){a.a[i]+=p*$wnd.Math.cos(d*(i-0.5));a.b[i]-=p*$wnd.Math.sin(d*(i-0.5));}h<<=1;}};q_.Ps=function Ps(a,b){var c;c=a-b;while(c<u1)c+=G0;while(c>H0)c-=G0;return c;};q_.Qs=function Qs(a,b,c){var d,e;d=0;for(e=0;e<o_.mm(a.e,c);e++){q_.Zt(b,o_.zm(a.e,c,e))&&++d;}return d;};q_.Rs=function Rs(a,b,c,d){var e,f,g,h,i;h=q_.Yt(b,d);i=q_.Yt(c,d);q_.bu(c,b.a[h]-c.a[i],b.b[h]-c.b[i]);e=q_.nt(a,b,d);f=q_.nt(a,c,d);g=0;q_.Qs(a,b,d)==1&&q_.Qs(a,c,d)==1&&(g=_0);q_.au(c,c.a[i],c.b[i],e-f+g+H0);return q_.Ws(a,b,c,1);};q_.Ss=function Ss(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L;t=OI(h_.hK,k0,5,e,15,1);u=OI(h_.hK,k0,5,e,15,1);for(p=0;p<e;p++){t[p]=q_.Yt(b,d[p]);u[p]=q_.Yt(c,d[p]);}F=0;H=0;G=0;I=0;for(q=0;q<e;q++){F+=b.a[t[q]];H+=b.b[t[q]];G+=c.a[u[q]];I+=c.b[u[q]];}F/=e;H/=e;G/=e;I/=e;q_.bu(c,F-G,H-I);j=OI(h_.cL,W_,24,e,0,1);l=OI(h_.cL,W_,24,e,0,1);f=OI(h_.cL,W_,24,e,0,1);g=OI(h_.cL,W_,24,e,0,1);for(r=0;r<e;r++){j[r]=new q_.Jt(F,H,b.a[t[r]],b.b[t[r]]);l[r]=new q_.Jt(F,H,c.a[u[r]],c.b[u[r]]);f[r]=new q_.It(j[r].a-l[r].a,j[r].b*l[r].b);g[r]=new q_.It(j[r].a+l[r].a,j[r].b*l[r].b);}w=q_.rt(f,e);A=q_.rt(g,e);K=0;L=0;for(s=0;s<e;s++){for(v=0;v<o_.mm(a.e,d[s]);v++){h=o_.zm(a.e,d[s],v);q_.Zt(b,h)&&!q_.Zt(c,h)&&++K;!q_.Zt(b,h)&&q_.Zt(c,h)&&++L;}}k=OI(h_.cL,W_,24,K,0,1);m=OI(h_.cL,W_,24,L,0,1);n=OI(h_.cL,W_,24,L,0,1);K=0;L=0;for(o=0;o<e;o++){for(v=0;v<o_.mm(a.e,d[o]);v++){h=o_.zm(a.e,d[o],v);if(q_.Zt(b,h)&&!q_.Zt(c,h)){i=q_.Yt(b,h);k[K]=new q_.Jt(b.a[t[o]],b.b[t[o]],b.a[i],b.b[i]);++K;}if(!q_.Zt(b,h)&&q_.Zt(c,h)){i=q_.Yt(c,h);J=new q_.Jt(c.a[u[o]],c.b[u[o]],c.a[i],c.b[i]);m[L]=new q_.It(w.a+J.a,J.b);n[L]=new q_.It(A.a-J.a,J.b);++L;}}}B=q_.rt(k,K);C=q_.rt(m,L);D=q_.rt(n,L);if($wnd.Math.abs(q_.Ps(B.a,C.a))>$wnd.Math.abs(q_.Ps(B.a,D.a))){q_.au(c,F,H,w.a);}else {q_.St(c,F,H);q_.au(c,F,H,A.a);}return q_.Ws(a,b,c,e);};q_.Ts=function Ts(a,b,c,d){var e,f,g,h,i,j;f=d==b.length-1?0:d+1;h=d==0?b.length-1:d-1;g=f==b.length-1?0:f+1;if(o_.Vj(a.e,c[d])==2){e=o_.Wj(a.e,c[d]);if(e==1||e==2){q_._s(a,b[h],b[d],b[f])^q_._s(a,b[g],b[f],b[d])&&(e=e==1?2:1);return e;}}if(o_.An(a.e,c[d])){i=o_.Tp(o_.Ym(a.e),c[h],c[d]);j=o_.Tp(o_.Ym(a.e),c[f],c[d]);if(i!=-1||j!=-1)return i==j?2:1;}return 0;};q_.Us=function Us(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;e=OI(h_.hK,k0,5,a.e.o,15,1);f=OI(h_.hK,k0,5,a.e.o,15,1);g=OI(h_.hK,k0,5,a.e.o,15,1);h=OI(h_.hK,k0,5,a.e.o,15,1);e[0]=b;g[b]=1;h[0]=-1;d=0;i=0;while(d<=i){if(d==0||!a.a[e[d]]){for(j=0;j<o_.mm(a.e,e[d]);j++){c=o_.zm(a.e,e[d],j);m=o_.Bm(a.e,e[d],j);if(g[c]==0&&!a.b[m]){e[++i]=c;f[i]=m;g[c]=g[e[d]]+1;h[i]=d;}}}if(d==i){n=new q_.Lt(g[e[d]]);k=d;for(l=0;l<n.a.length;l++){n.a[l]=e[k];n.b[l]=f[k];k=h[k];}return n;}++d;}return null;};q_.Vs=function Vs(a){var b,c,d,e;e=0;d=null;for(c=new l_.KW(a);c.a<c.c.a.length;){b=l_.JW(c);if(e<b.b[0].e.length*b.b[1].e.length){e=b.b[0].e.length*b.b[1].e.length;d=b;}}return d;};q_.Ws=function Ws(a,b,c,d){var e,f,g,h,i;f=new q_.cu(a.e,b.e.length+c.e.length-d,a.d);e=0;for(h=0;h<b.e.length;h++){f.e[e]=b.e[h];f.k[e]=b.k[h];f.a[e]=b.a[h];f.b[e++]=b.b[h];}for(g=0;g<c.e.length;g++){i=q_.Yt(b,c.e[g]);if(i==-1){f.e[e]=c.e[g];f.k[e]=c.k[g];f.a[e]=c.a[g];f.b[e++]=c.b[g];}else {if(f.k[i]<c.k[g]){f.k[i]=c.k[g];f.a[i]=c.a[g];f.b[i]=c.b[g];}}}return f;};q_.Xs=function Xs(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;h=OI(h_.hK,k0,5,a.e.o,15,1);i=OI(h_.hK,k0,5,a.e.o,15,1);j=OI(h_.hK,k0,5,a.e.o,15,1);k=OI(h_.hK,k0,5,a.e.o,15,1);h[0]=c;j[c]=1;k[0]=-1;g=0;l=0;while(g<=l){for(m=0;m<o_.nm(a.e,h[g]);m++){e=o_.zm(a.e,h[g],m);o=o_.Bm(a.e,h[g],m);if(e==b){f=j[h[g]];d=OI(h_.hK,k0,5,f,15,1);d[0]=o;for(n=1;n<f;n++){d[n]=i[g];g=k[g];}return d;}if(j[e]==0){h[++l]=e;i[l]=o;j[e]=j[h[g]]+1;k[l]=g;}}if(g==l)return null;++g;}return null;};q_.Ys=function Ys(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;c=o_.Nj(a.e,0,b);d=o_.Nj(a.e,1,b);g=OI(h_.hK,k0,5,a.e.o,15,1);h=OI(h_.hK,k0,5,a.e.o,15,1);i=OI(h_.hK,k0,5,a.e.o,15,1);j=OI(h_.hK,k0,5,a.e.o,15,1);g[0]=c;g[1]=d;h[1]=b;i[c]=1;i[d]=2;j[0]=-1;j[1]=0;f=1;k=1;while(f<=k){for(l=0;l<o_.mm(a.e,g[f]);l++){e=o_.zm(a.e,g[f],l);if(f>1&&e==c){o=new q_.Lt(i[g[f]]);h[0]=o_.Bm(a.e,g[f],l);m=f;for(n=0;n<o.a.length;n++){o.a[n]=g[m];o.b[n]=h[m];m=j[m];}return o;}if(i[e]==0&&o_.wn(a.e,e)){g[++k]=e;h[k]=o_.Bm(a.e,g[f],l);i[e]=i[g[f]]+1;j[k]=f;}}++f;}return null;};q_.Zs=function Zs(a,b,c,d){var e,f,g,h,i,j;g=OI(h_.hK,k0,5,a.e.o,15,1);h=OI(h_.hK,k0,5,a.e.o,15,1);g[0]=c;g[1]=b;h[c]=1;h[b]=2;f=1;i=1;while(f<=i){for(j=0;j<o_.mm(a.e,g[f]);j++){e=o_.zm(a.e,g[f],j);if(e==d)return 1+h[g[f]];if(h[e]==0&&o_.wn(a.e,e)){g[++i]=e;h[e]=h[g[f]]+1;}}++f;}return 0;};q_.$s=function $s(a,b){var c,d,e,f,g,h;h=(b.R&15)!=0;!a.f&&(a.f=new l_.NX());(a.d&2)!=0&&o_.Hn(b,false);a.e=b;o_.Jr(a.e,7);a.c=new l_.gi();a.a=OI(h_.DN,C0,5,a.e.o,16,1);a.b=OI(h_.DN,C0,5,a.e.p,16,1);a.g=OI(h_.hK,k0,5,a.e.o,15,1);for(c=0;c<a.e.o;c++)a.g[c]=o_.rj(a.e,c);(a.d&12)!=0&&q_.jt(a);(a.d&1)==0&&!!q_.Ds&&q_.lt(a,q_.Ds);q_.it(a);q_.et(a);q_.gt(a);q_.et(a);for(e=new l_.KW(a.c);e.a<e.c.a.length;){d=l_.JW(e);q_.$t(d);}q_.Is(a);q_.mt(a);q_.kt(a);q_.dt(a);q_.bt(a);q_.ft(a);for(f=0;f<a.c.a.length;f++){d=l_.Th(a.c,f);for(g=0;g<d.e.length;g++){o_.jl(a.e,d.e[g],d.a[g]);o_.kl(a.e,d.e[g],d.b[g]);o_.ll(a.e,d.e[g],0);}}h&&o_.Nn(a.e);};q_._s=function _s(a,b,c,d){var e,f;for(f=0;f<o_.Am(a.e,c);f++){e=o_.zm(a.e,c,f);if(e!=d&&e<b)return false;}return true;};q_.at=function at(a,b,c){var d;q_.Ft(b,c,(a.d&12)!=0);d=q_.Ws(a,b.b[0],b.b[1],0);q_.ot(a,b.b[0],b.b[1],d);};q_.bt=function bt(a){var b;b=q_.Js(a);while(b){q_.at(a,b,1.5);b=q_.Js(a);}};q_.ct=function ct(a,b,c,d){var e,f,g,h,i;e=OI(h_.hK,k0,5,d,15,1);f=0;for(g=0;g<b.e.length;g++)for(h=0;h<c.e.length;h++)b.e[g]==c.e[h]&&(e[f++]=b.e[g]);i=d==1?q_.Rs(a,b,c,e[0]):q_.Ss(a,b,c,e,d);q_.ot(a,b,c,i);};q_.dt=function dt(a){var b,c;c=q_.Ms(a);while(c){b=q_.Vs(c);q_.at(a,b,1.2);c=q_.Ms(a);}};q_.et=function et(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;while(true){s=0;n=0;q=null;r=null;for(g=1;g<a.c.a.length;g++){d=l_.Th(a.c,g);for(h=0;h<g;h++){e=l_.Th(a.c,h);b=0;c=0;o=0;p=0;for(k=0;k<d.e.length;k++){for(m=0;m<e.e.length;m++){if(d.e[k]==e.e[m]){++c;b=d.e[k];o<d.k[k]&&(o=d.k[k]);p<e.k[m]&&(p=e.k[m]);}}}if(c>0){f=c==1&&q_.Qs(a,d,b)==1&&q_.Qs(a,e,b)==1?0:1;o>p?i=(f<<24)+(o<<16)+(p<<8)+c:i=(f<<24)+(p<<16)+(o<<8)+c;if(s<i){s=i;n=c;o=0;p=0;for(l=0;l<d.e.length;l++)o<d.k[l]&&(o=d.k[l]);for(j=0;j<e.e.length;j++)p<e.k[j]&&(p=e.k[j]);if(o>p){q=d;r=e;}else {q=e;r=d;}}}}}if(s==0)break;n==q.e.length?l_._h(a.c,q):n==r.e.length?l_._h(a.c,r):q_.ct(a,q,r,n);}};q_.ft=function ft(a){var b;b=q_.Ks(a);while(b){q_.at(a,b,1.8);b=q_.Ks(a);}};q_.gt=function gt(a){var b,c,d,e,f,g,h;while(true){f=null;for(b=0;b<a.e.o;b++){h=0;for(e=0;e<o_.mm(a.e,b);e++)a.b[o_.Bm(a.e,b,e)]||++h;if(h==1){g=q_.Us(a,b);(!f||g.a.length>f.a.length)&&(f=g);}}if(!f)break;c=new q_.cu(a.e,f.a.length,a.d);for(d=0;d<f.a.length;d++){a.a[f.a[d]]=true;d<f.a.length-1&&(a.b[f.b[d]]=true);c.e[d]=f.a[d];c.a[d]=$wnd.Math.cos(a1)*d;c.b[d]=(d&1)==1?0:0.5;c.k[d]=128+f.a.length;}l_.Oh(a.c,c);}};q_.ht=function ht(a,b,c){var d,e,f,g,h,i,j,k,l,m;for(f=0;f<a.e.p;f++){d=o_.Nj(a.e,0,f);e=o_.Nj(a.e,1,f);if(o_.xn(a.e,f)||o_.Vj(a.e,f)!=1||o_.mm(a.e,d)==1||o_.mm(a.e,e)==1)continue;if((a.d&4)!=0&&o_.wk(a.e,d)&&o_.wk(a.e,e))continue;l=false;for(j=0;j<2;j++){g=o_.Nj(a.e,j,f);if(o_.mm(a.e,g)>2){m=true;i=-1;for(k=0;k<o_.mm(a.e,g);k++){h=o_.zm(a.e,g,k);h!=o_.Nj(a.e,1-j,f)&&(i==-1?i=c[h]:i!=c[h]&&(m=false));}if(m){l=true;break;}}}l||((a.d&8)!=0&&o_.wk(a.e,d)&&o_.wk(a.e,e)?b[f]=1:b[f]=2);}};q_.it=function it(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M;for(d=0;d<a.e.o;d++){if(o_.mm(a.e,d)>4){m=new q_.cu(a.e,1+o_.mm(a.e,d),a.d);m.a[o_.mm(a.e,d)]=0;m.b[o_.mm(a.e,d)]=0;m.k[o_.mm(a.e,d)]=32;m.e[o_.mm(a.e,d)]=d;a.a[d]=true;for(o=0;o<o_.mm(a.e,d);o++){j=o_.zm(a.e,d,o);m.a[o]=$wnd.Math.sin(_0*o-X1);m.b[o]=$wnd.Math.cos(_0*o-X1);m.k[o]=32;m.e[o]=j;a.a[j]=true;a.b[o_.Bm(a.e,d,o)]=true;}l_.Oh(a.c,m);}}I=o_.Ym(a.e);for(H=0;H<I.i.a.length;H++){J=l_.Th(I.j,H).length;F=l_.Th(I.i,H);K=false;if((a.d&12)!=0){K=true;for(o=0;o<J;o++){if(!o_.wk(a.e,F[o])){K=false;break;}}}if(!K){r=false;for(p=0;p<J;p++){if(o_.um(a.e,F[p])==J){r=true;break;}}if(r){G=l_.Th(I.j,H);q_.Es(a,F,G);for(o=0;o<J;o++){a.a[F[o]]=true;a.b[G[o]]=true;}}}}for(h=0;h<a.e.p;h++){if(o_.xn(a.e,h)&&!a.b[h]){M=q_.Ys(a,h);F=M.a;G=M.b;q_.Es(a,F,G);for(o=0;o<M.a.length;o++){a.a[F[o]]=true;a.b[G[o]]=true;}}}for(i=0;i<a.e.p;i++){if(!a.b[i]&&o_.Vj(a.e,i)==3){e=o_.Nj(a.e,0,i);f=o_.Nj(a.e,1,i);w=o_.mm(a.e,e)+o_.mm(a.e,f);if(w>2){m=new q_.cu(a.e,w,a.d);k=0;for(p=0;p<o_.mm(a.e,e);p++){j=o_.zm(a.e,e,p);if(j!=f){m.e[k++]=j;a.a[j]=true;a.b[o_.Bm(a.e,e,p)]=true;}}m.e[k++]=e;m.e[k++]=f;for(q=0;q<o_.mm(a.e,f);q++){j=o_.zm(a.e,f,q);if(j!=e){m.e[k++]=j;a.a[j]=true;a.b[o_.Bm(a.e,f,q)]=true;}}for(o=0;o<w;o++){m.a[o]=o;m.b[o]=0;m.k[o]=1;}a.a[e]=true;a.a[f]=true;a.b[i]=true;l_.Oh(a.c,m);}}}for(g=0;g<a.e.p;g++){if(!a.b[g]&&o_.Vj(a.e,g)==2){b=OI(h_.hK,k0,5,a.e.o,15,1);for(o=0;o<2;o++){b[0]=o_.Nj(a.e,o,g);b[1]=o_.Nj(a.e,1-o,g);if(o_.qm(a.e,b[0])==1&&o_.qm(a.e,b[1])==2&&o_.mm(a.e,b[1])==2){a.a[b[0]]=true;a.a[b[1]]=true;a.b[g]=true;v=1;do{A=o_.zm(a.e,b[v],0)==b[v-1]?1:0;b[v+1]=o_.zm(a.e,b[v],A);if(o_.qm(a.e,b[v+1])==2&&o_.mm(a.e,b[v+1])>2)break;a.a[b[v+1]]=true;a.b[o_.Bm(a.e,b[v],A)]=true;++v;}while(o_.qm(a.e,b[v])==2&&o_.mm(a.e,b[v])==2);w=o_.mm(a.e,b[0])+o_.mm(a.e,b[v])+v-1;m=new q_.cu(a.e,w,a.d);for(t=0;t<=v;t++){m.a[t]=t;m.b[t]=0;m.k[t]=64;m.e[t]=b[t];}l=v+1;n=false;for(u=0;u<o_.mm(a.e,b[0]);u++){j=o_.zm(a.e,b[0],u);if(j!=b[1]){m.a[l]=-0.5;m.b[l]=n?$wnd.Math.sin(_0):-$wnd.Math.sin(_0);m.k[l]=64;m.e[l]=j;++l;n=true;}}n=false;for(s=0;s<o_.mm(a.e,b[v]);s++){j=o_.zm(a.e,b[v],s);if(j!=b[v-1]){m.a[l]=v+0.5;m.b[l]=n?-$wnd.Math.sin(_0):$wnd.Math.sin(_0);m.k[l]=64;m.e[l]=j;++l;n=true;}}l_.Oh(a.c,m);}}}}for(c=0;c<a.e.o;c++){if(o_.mm(a.e,c)==4){B=OI(h_.hK,k0,5,4,15,1);C=OI(h_.hK,k0,5,4,15,1);D=0;for(p=0;p<4;p++){B[D]=o_.zm(a.e,c,p);C[D]=o_.Bm(a.e,c,p);o_.mm(a.e,B[D])==1&&!a.b[C[D]]&&++D;}if(D==2){m=new q_.cu(a.e,3,a.d);for(o=0;o<2;o++){a.a[B[o]]=true;a.b[C[o]]=true;m.e[o]=B[o];m.k[o]=32;}m.a[0]=-0.5;m.b[0]=0.866;m.a[1]=0.5;m.b[1]=0.866;m.a[2]=0;m.b[2]=0;m.k[2]=32;m.e[2]=c;l_.Oh(a.c,m);}if(D==3){for(q=0;q<2;q++){if(o_.Vj(a.e,C[q])==1){L=B[q];B[q]=B[2];B[2]=L;L=C[q];C[q]=C[2];C[2]=L;}}m=new q_.cu(a.e,4,a.d);for(o=0;o<3;o++){a.a[B[o]]=true;a.b[C[o]]=true;m.e[o]=B[o];m.k[o]=32;}m.a[0]=-1;m.b[0]=0;m.a[1]=1;m.b[1]=0;m.a[2]=0;m.b[2]=1;m.a[3]=0;m.b[3]=0;m.k[3]=32;m.e[3]=c;l_.Oh(a.c,m);}}}};q_.jt=function jt(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;h=0;for(c=0;c<a.e.o;c++)o_.wk(a.e,c)&&++h;if(h<2)return;l=0;j=0;for(k=0;k<a.e.p;k++){d=o_.Nj(a.e,0,k);e=o_.Nj(a.e,1,k);if(o_.wk(a.e,d)&&o_.wk(a.e,e)){a.b[k]=true;a.a[d]=true;a.a[e]=true;j+=o_.Tj(a.e,k);++l;}}l!=0&&j!=0?j/=l:j=o_.Jj(a.e);for(f=0;f<a.e.o;f++)o_.wk(a.e,f)&&!a.a[f]&&--h;if(h<2)return;t=OI(h_.hK,k0,5,a.e.o,15,1);m=o_.Im(a.e,t,true,true);s=OI(h_.hK,k0,5,m,15,1);for(g=0;g<a.e.o;g++)t[g]!=-1&&++s[t[g]];r=OI(h_.gL,W_,31,m,0,1);for(o=0;o<m;o++)r[o]=new q_.cu(a.e,s[o],a.d);i=OI(h_.hK,k0,5,m,15,1);for(b=0;b<a.e.o;b++){p=t[b];if(p!=-1){r[p].k[i[p]]=L0;r[p].e[i[p]]=b;r[p].a[i[p]]=o_.Fj(a.e,b)/j;r[p].b[i[p]]=o_.Gj(a.e,b)/j;++i[p];}}u=-1;v=0;for(q=0;q<m;q++){if(v<s[q]){v=s[q];u=q;}}l_.Oh(a.c,r[u]);for(n=0;n<m;n++)n!=u&&l_.Oh(a.c,r[n]);};q_.kt=function kt(a){var b,c;for(b=0;b<a.e.o;b++){if(!a.a[b]&&o_.mm(a.e,b)==0){c=new q_.cu(a.e,1,a.d);a.a[b]=true;c.e[0]=b;c.a[0]=0;c.b[0]=0;c.k[0]=0;l_.Oh(a.c,c);}}};q_.lt=function lt(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p;m=null;m=new o_.Dq();o_.xq(m,a.e);g=OI(h_.DN,C0,5,a.e.d,16,1);for(o=b.mb();o.Ob();){n=o.Pb();l=null;o_.wq(m,n.b);o_.lq(m,4,8)!=0&&(l=m.A);if(l){for(k=new l_.KW(l);k.a<k.c.a.length;){j=l_.JW(k);p=0;for(d=j,e=0,f=d.length;e<f;++e){c=d[e];g[c]&&++p;}if(p<=1){h=new q_.cu(a.e,j.length,a.d);for(i=0;i<j.length;i++){c=j[i];h.k[i]=256;h.e[i]=c;h.a[i]=o_.Fj(n.b,i)/n.a;h.b[i]=o_.Gj(n.b,i)/n.a;g[c]=true;a.a[c]=true;}l_.Oh(a.c,h);}}}}return g;};q_.mt=function mt(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u;b=q_.Gs(a);f=OI(h_.dK,j0,5,a.e.p,15,1);q_.ht(a,f,b);for(e=0;e<a.e.p;e++)f[e]==2&&(o_.wn(a.e,o_.Nj(a.e,0,e))||o_.wn(a.e,o_.Nj(a.e,1,e)))&&(f[e]=3);for(n=0;n<a.c.a.length;n++){l=l_.Th(a.c,n);i=q_.Wt(l);r=l.c;q=new q_.du(l,a.d);p=-1;for(m=0;m<224&&i.a.length!=0;m++){j=l_.KX(a.f,i.a.length);h=(n_.L$(j,i.a.length),i.a[j]);g=q_.Xs(a,h[0],h[1]);c=OI(h_.hK,k0,5,g.length,15,1);d=0;if(m<32){for(o=1;o<g.length-1;o++)f[g[o]]==3&&(c[d++]=g[o]);}else if(m<96){for(o=1;o<g.length-1;o++)f[g[o]]>=2&&(c[d++]=g[o]);}else {for(o=1;o<g.length-1;o++)f[g[o]]>=1&&(c[d++]=g[o]);}if(d!=0){t=c[0];if(d>1){do{t=c[l_.KX(a.f,d)];}while(t==p);}if(t!=p){p=t;q_.Tt(l,t);i=q_.Wt(l);if(r>l.c){r=l.c;q=new q_.du(l,a.d);}}}}l_.bi(a.c,n,q);l=q;k=1;do{s=9999;for(o=0;o<l.e.length;o++){u=b[l.e[o]];u==k?q_._t(l,o):u>k&&u<s&&(s=u);}k=s;}while(s!=9999);}};q_.nt=function nt(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;e=OI(h_.fK,B0,5,o_.mm(a.e,c)+1,15,1);g=OI(h_.hK,k0,5,o_.mm(a.e,c)+1,15,1);h=OI(h_.hK,k0,5,o_.mm(a.e,c)+1,15,1);q=q_.Yt(b,c);f=0;for(j=0;j<o_.mm(a.e,c);j++){g[f]=o_.zm(a.e,c,j);h[f]=o_.Bm(a.e,c,j);l=q_.Yt(b,g[f]);l!=-1&&(e[f++]=q_.Kt(b.a[q],b.b[q],b.a[l],b.b[l]));}if(f==1)return e[0]+H0;for(k=f-1;k>0;k--){for(m=0;m<k;m++){if(e[m]>e[m+1]){r=e[m];e[m]=e[m+1];e[m+1]=r;s=g[m];g[m]=g[m+1];g[m+1]=s;t=h[m];h[m]=h[m+1];h[m+1]=t;}}}e[f]=e[0]+G0;g[f]=g[0];h[f]=h[0];n=-100;o=0;for(i=0;i<f;i++){d=e[i+1]-e[i];if(f>2&&o_.xn(a.e,h[i])&&o_.xn(a.e,h[i+1])){p=q_.Zs(a,g[i],c,g[i+1]);p!=0&&(d-=100-p);}if(n<d){n=d;o=i;}}return (e[o]+e[o+1])/2;};q_.ot=function ot(a,b,c,d){var e;e=$wnd.Math.min(l_.Vh(a.c,b,0),l_.Vh(a.c,c,0));l_.Nh(a.c,e,d);l_._h(a.c,b);l_._h(a.c,c);};q_.pt=function pt(){q_.qt.call(this);};q_.qt=function qt(){this.d=2;!q_.Ds&&!q_.Ds&&(q_.Ds=new q_.Pt());};q_.rt=function rt(a,b){var c,d,e,f,g;g=0;c=0;for(d=0;d<b;d++){g+=a[d].b*$wnd.Math.sin(a[d].a);c+=a[d].b*$wnd.Math.cos(a[d].a);}if(c==0)f=g>0?I0:W0;else {f=$wnd.Math.atan(g/c);c<0&&(f+=H0);}e=$wnd.Math.sqrt(g*g+c*c)/b;return new q_.It(f,e);};xO(80,1,{},q_.pt);_.d=0;h_.aL=jQ(80);q_.st=function st(a,b){var c,d;c=$wnd.Math.abs(a.b);d=$wnd.Math.abs(b.b);return c<d?-1:c==d?0:1;};q_.tt=function tt(){};xO(158,1,{},q_.tt);_.kb=function ut(a,b){return q_.st(a,b);};_.gb=function vt(a){return this===a;};h_.ZK=jQ(158);q_.wt=function wt(a){var b,c;b=a.c.e.length;c=a.c.e.length;return b<c?1:b==c?0:-1;};q_.xt=function xt(){};xO(159,1,{},q_.xt);_.kb=function yt(a,b){var c;return q_.wt((c=a,c));};_.gb=function zt(a){return this===a;};h_.$K=jQ(159);q_.At=function At(a){var b,c;b=a.c.e.length;c=a.c.e.length;return b<c?-1:b==c?0:1;};q_.Bt=function Bt(){};xO(160,1,{},q_.Bt);_.kb=function Ct(a,b){var c;return q_.At((c=a,c));};_.gb=function Dt(a){return this===a;};h_._K=jQ(160);q_.Et=function Et(a,b,c){a.c[0]+=q_.Ut(a.b[0],b);a.d[0]+=q_.Vt(a.b[0],b);a.c[1]+=q_.Ut(a.b[1],c);a.d[1]+=q_.Vt(a.b[1],c);++a.a[0];++a.a[1];};q_.Ft=function Ft(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w;d=OI(h_.fK,B0,5,2,15,1);for(j=0;j<2;j++){a.c[j]/=a.a[j];a.d[j]/=a.a[j];d[j]=q_.Qt(a.b[j],a.c[j],a.d[j],a.b[1-j].e.length,b);}q_.au(a.b[0],a.c[0],a.d[0],I0-d[0]);q_.au(a.b[1],a.c[1],a.d[1],4.71238898038469-d[1]);w=p1;v=-1.7976931348623157E308;g=a.d[0]-a.d[1];for(k=0;k<a.b[1].b.length;k++){a.b[1].b[k]+=g;w>a.b[1].b[k]&&(w=a.b[1].b[k]);v<a.b[1].b[k]&&(v=a.b[1].b[k]);}t=v-w+2*b;e=cK($wnd.Math.ceil(t));w+=(t-e)/2-b;r=OI(h_.fK,B0,5,e,15,1);for(l=0;l<e;l++)r[l]=a.c[1]+b;for(m=0;m<a.b[1].b.length;m++){u=a.b[1].b[m]-w;s=cK(u-b);h=$wnd.Math.min(cK(u+b),e-1);for(q=s;q<=h;q++){r[q]>a.b[1].a[m]&&(r[q]=a.b[1].a[m]);}}for(n=0;n<e;n++)r[n]-=b;f=a.c[0]-a.c[1];for(o=0;o<a.b[0].a.length;o++){p=cK(a.b[0].b[o]-w);p>=0&&p<r.length&&f<a.b[0].a[o]-r[p]&&(f=a.b[0].a[o]-r[p]);}for(i=0;i<a.b[1].a.length;i++)a.b[1].a[i]+=f;if(c){q_.au(a.b[0],a.c[0],a.d[0],d[0]-I0);q_.au(a.b[1],a.c[0],a.d[0],d[0]-I0);}};q_.Gt=function Gt(a,b){var c,d;this.b=OI(h_.gL,W_,31,2,0,1);this.b[0]=a;this.b[1]=b;this.c=OI(h_.fK,B0,5,2,15,1);this.d=OI(h_.fK,B0,5,2,15,1);this.a=OI(h_.hK,k0,5,2,15,1);for(c=0;c<2;c++){for(d=0;d<this.b[c].e.length;d++){this.c[c]+=q_.Ut(this.b[c],d);this.d[c]+=q_.Vt(this.b[c],d);}this.a[c]=this.b[c].e.length;}};q_.Ht=function Ht(a,b,c,d){this.b=OI(h_.gL,W_,31,2,0,1);this.b[0]=a;this.b[1]=b;this.c=OI(h_.fK,B0,5,2,15,1);this.d=OI(h_.fK,B0,5,2,15,1);this.c[0]=q_.Ut(this.b[0],c);this.d[0]=q_.Vt(this.b[0],c);this.c[1]=q_.Ut(this.b[1],d);this.d[1]=q_.Vt(this.b[1],d);this.a=OI(h_.hK,k0,5,2,15,1);this.a[0]=1;this.a[1]=1;};xO(54,1,{54:1},q_.Gt,q_.Ht);h_.bL=jQ(54);q_.It=function It(a,b){this.a=a;this.b=b;};q_.Jt=function Jt(a,b,c,d){var e,f;this.a=q_.Kt(a,b,c,d);e=c-a;f=d-b;this.b=$wnd.Math.sqrt(e*e+f*f);};q_.Kt=function Kt(a,b,c,d){var e,f,g;f=c-a;g=d-b;if(g!=0){e=$wnd.Math.atan(f/g);g<0&&(f<0?e-=H0:e+=H0);}else e=f>0?I0:W0;return e;};xO(24,1,{24:1},q_.It,q_.Jt);_.a=0;_.b=0;h_.cL=jQ(24);q_.Lt=function Lt(a){this.a=OI(h_.hK,k0,5,a,15,1);this.b=OI(h_.hK,k0,5,a,15,1);};xO(128,1,{},q_.Lt);h_.dL=jQ(128);q_.Mt=function Mt(a,b,c){this.c=a;this.a=b;this.b=c;};xO(101,1,{101:1},q_.Mt);_.a=0;_.b=0;h_.eL=jQ(101);q_.Ot=function Ot(){q_.Ot=zO;q_.Nt=XI(II(h_.uM,1),d0,2,6,['gkvt@@@@LddTTTrbTRTRTRRRRRRRRRRRRRrVRrIh\\IAaQxlY@gRHdJCJcRXlv_CfJx|A\\hRHejiLaQjTje^kSjtFcIhvXmVKMjt{lN{Kavy\\^wGjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjh@@vo@HBC@PhLN@bPhtFKCcpDbILaRhtzCIbsX\\nOO`JDbqDjSKdJeJmQjtz}Ahr[LVkMnpz\\nwGj{PBhBdBlBBBjBfBnBaBiBeBmBcBkBgBoB`bhbdblbbbjbfbnbabibebmbcbkbgbob`RhRdRlRbRjRfRnRaRiReRmRcRkRgRoR`rhrdrlrbrjrfrnrarirermrcrkrgror`JhJdJlJbJjJfJnJaJiJeJmJcJkJgJoJ`jhjdjljbjjjfjnjajijej` !BnkjyVwsVr|iQn|Q|goTZWPIJwbudnRkVYBez]siZymNJZUqNFBqZWxS~iCXVU]SeRjwrtSPAjkvXLpBAZauDPzq]PfMlecrMnkv|@\\SFD`m|mWiEoCXp`SIe_J[l|[XCbloTV`[Gc@FJGopyyoOlFQfUy^w\\Bgz|','gcrt@@@@LdbbbbTRbRbRbRRRRRRRRRRRRVRrVQIA`HtRGAaIxZAHfShTjCIbqylQGKgqdBaXeQJeruBiPitZmFoPZLFSYbvZlVGMnsZ]vWSmr{]UUUUUUUUUUUUUUUUUUUUUUUUUUUUUT@@[G`DAA`HTFG@QHTZCEaqxBQDfPiTZ]AdqYlNWGgpEBQXbUIerEReVhuZ]^`tYMfKUfwX]NW[jkPBhBdBlBbBjBfBnBaBiBeBmBcBkBgBoB`bhbdblbbbjbfbnbabibebmbcbkbgbob`RhRdRlRbRjRfRnRaRiReRmRcRkRgRoR`rhrdrlrbrjrfrnrarirermrcrkrgror`JhJdJlJbJjJfJnJaJiJeJmJcJkJgJoJ`jhjdjljbjjjfjnjajij` !B^cR]`]Fm]QkfljE\\p\x7FUVfgOmFXsQe_gXPyXis_wF|vUUX_XbxpzU]HUFgYViwFo~@uemc@}~T\x7FIEPioYVwr]JnM~[ZEC\\g}~o_pUfdo~irsklTLiyVJshnw^iVAsZ`_~}PYkckURH{FYMImFaRaccUlCZSHMfP','dml@@Dje^VGiyZjjjh@vtHSBinFU@ !BPTCTy[skMzUPF`AJbBixEZHS[Il','dml@@DjYVvGiyZjjjh@vtHSBinFU@ !BwLo~BJ~UquhXBinZ\\ykA@F_eMrT','dml@@LdfbbQX^fUZjjj`C[PaLJfxYT !BzxIHVc{OiJVRpprePho~]}y\x7FwLl','deL@@DjUYkfEijjjj@MeBDpj[ad !B\x7FaA\x7FMVr[AvkKzm_jKvVbD{sk','dil@@LddTQRl[NX^Fjjjj@MiBDpj[a@ !BPfL@\x7Fox@M~T@\x7Fox@\x7F`C~@@','daL@@DjYtKJqjynjjjj@MaBDpj[` !B`bL@_gx@@Gy~@Gx@_`@']);};q_.Pt=function Pt(){q_.Ot();var a,b,c,d,e,f,g;l_.gi.call(this);f=new o_.Rq();for(c=q_.Nt,d=0,e=c.length;d<e;++d){b=c[d];a=o_._n(new o_.fo(),b);o_.Kq(f,a);g=new q_.eu(a);g.a=o_.Jj(g.b);this.a[this.a.length]=g;}};xO(180,18,i0,q_.Pt);h_.fL=jQ(180);q_.Qt=function Qt(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G;if(a.e.length==1)return 0;C=e+$wnd.Math.sqrt(d);k=OI(h_.fK,B0,5,36,15,1);for(o=0;o<a.e.length;o++){f=q_.Kt(b,c,a.a[o],a.b[o]);h=q_.Rt(kO(VN($wnd.Math.round(f*36/G0))));l=b-a.a[o];m=c-a.b[o];F=l*l+m*m;k[h]<F&&(k[h]=F);}v=-1;u=-1;for(p=0;p<36;p++){k[p]=$wnd.Math.sqrt(k[p]);if(v<k[p]){v=k[p];u=p;}}D=u-18<0?u-18+36:u-18>=36?u-18-36:u-18;for(q=0;q<=18;q++){k[D+q<0?D+q+36:D+q>=36?D+q-36:D+q]+=0.01*q;k[D-q<0?D-q+36:D-q>=36?D-q-36:D-q]+=0.01*q;}G=OI(h_.fK,B0,5,9,15,1);i=OI(h_.fK,B0,5,9,15,1);for(r=1;r<9;r++){G[r]=$wnd.Math.sin(r*Y1);i[r]=$wnd.Math.cos(r*Y1);}A=p1;w=-1;for(g=0;g<36;g++){if(k[g]>=A)continue;t=k[g];for(n=1;n<9;n++){for(s=-1;s<=1;s+=2){B=g+s*n<0?g+s*n+36:g+s*n>=36?g+s*n-36:g+s*n;if(k[B]*i[n]<=t)continue;j=i[n]*$wnd.Math.min(k[B],C/G[n]);if(t<j){t=j;if(A<=t)break;}}if(A<=t)break;}if(A>t){A=t;w=g;}}return G0*w/36;};q_.Rt=function Rt(a){return a<0?a+36:a>=36?a-36:a;};q_.St=function St(a,b,c){var d,e,f;for(f=0;f<a.e.length;f++){e=$wnd.Math.sqrt((a.a[f]-b)*(a.a[f]-b)+(a.b[f]-c)*(a.b[f]-c));d=0-q_.Kt(b,c,a.a[f],a.b[f]);a.a[f]=b+e*$wnd.Math.sin(d);a.b[f]=c+e*$wnd.Math.cos(d);}};q_.Tt=function Tt(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;a.d==null&&(a.d=OI(h_.hK,d1,6,a.j.p,0,2));if(a.d[b]==null){m=OI(h_.hK,k0,5,a.e.length,15,1);s=OI(h_.DN,C0,5,a.j.o,16,1);d=o_.Nj(a.j,0,b);e=o_.Nj(a.j,1,b);m[0]=d;s[d]=true;j=0;n=0;while(j<=n){for(p=0;p<o_.mm(a.j,m[j]);p++){f=o_.zm(a.j,m[j],p);if(!s[f]&&f!=e){m[++n]=f;s[f]=true;}}if(j==n)break;++j;}l=n+1>(a.e.length/2|0);if((a.i&12)!=0){h=false;g=false;for(p=0;p<a.e.length;p++){o_.wk(a.j,a.e[p])&&(s[a.e[p]]?h=true:g=true);}h!=g&&(l=h);}i=2;a.d[b]=OI(h_.hK,k0,5,l?a.e.length-n:n+2,15,1);for(q=0;q<a.e.length;q++){a.e[q]==d?a.d[b][l?0:1]=q:a.e[q]==e?a.d[b][l?1:0]=q:l^s[a.e[q]]&&(a.d[b][i++]=q);}}u=a.a[a.d[b][0]];v=a.b[a.d[b][0]];t=q_.Kt(u,v,a.a[a.d[b][1]],a.b[a.d[b][1]]);for(o=2;o<a.d[b].length;o++){r=a.d[b][o];k=$wnd.Math.sqrt((a.a[r]-u)*(a.a[r]-u)+(a.b[r]-v)*(a.b[r]-v));c=2*t-q_.Kt(u,v,a.a[r],a.b[r]);a.a[r]=u+k*$wnd.Math.sin(c);a.b[r]=v+k*$wnd.Math.cos(c);}};q_.Ut=function Ut(a,b){return a.a[b];};q_.Vt=function Vt(a,b){return a.b[b];};q_.Wt=function Wt(a){var b,c,d,e,f,g,h,i;a.c=0;c=new l_.gi();for(e=1;e<a.e.length;e++){for(f=0;f<e;f++){h=$wnd.Math.abs(a.a[e]-a.a[f]);i=$wnd.Math.abs(a.b[e]-a.b[f]);d=$wnd.Math.sqrt(h*h+i*i);if(d<0.8){b=OI(h_.hK,k0,5,2,15,1);b[0]=a.e[e];b[1]=a.e[f];c.a[c.a.length]=b;}g=1-$wnd.Math.min(d,1);a.c+=g*g;}}return c;};q_.Xt=function Xt(a,b){return a.e[b];};q_.Yt=function Yt(a,b){var c;for(c=0;c<a.e.length;c++)if(b==a.e[c])return c;return -1;};q_.Zt=function Zt(a,b){var c;for(c=0;c<a.e.length;c++)if(b==a.e[c])return true;return false;};q_.$t=function $t(a){var b,c,d,e,f,g;d=0;for(f=0;f<a.e.length;f++){b=a.e[f];c=o_.mm(a.j,b);for(g=0;g<c;g++)o_.zm(a.j,b,g)>b&&++d;}a.f=OI(h_.hK,k0,5,d,15,1);a.g=OI(h_.hK,k0,5,a.j.o,15,1);d=0;for(e=0;e<a.e.length;e++){b=a.e[e];c=o_.mm(a.j,b);a.g[b]=e;for(g=0;g<c;g++)o_.zm(a.j,b,g)>b&&(a.f[d++]=o_.Bm(a.j,b,g));}};q_._t=function _t(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;o=a.a[b];s=a.b[b];f=OI(h_.cL,W_,24,4,0,1);k=0;for(l=0;l<a.f.length;l++){if(k>=4)break;if(b==a.g[o_.Nj(a.j,0,a.f[l])]||b==a.g[o_.Nj(a.j,1,a.f[l])])continue;p=a.a[a.g[o_.Nj(a.j,0,a.f[l])]];t=a.b[a.g[o_.Nj(a.j,0,a.f[l])]];q=a.a[a.g[o_.Nj(a.j,1,a.f[l])]];u=a.b[a.g[o_.Nj(a.j,1,a.f[l])]];h=$wnd.Math.sqrt((p-o)*(p-o)+(t-s)*(t-s));i=$wnd.Math.sqrt((q-o)*(q-o)+(u-s)*(u-s));e=$wnd.Math.sqrt((q-p)*(q-p)+(u-t)*(u-t));if(h<e&&i<e){if(p==q){g=$wnd.Math.abs(o-p);g<0.5&&(f[k++]=new q_.It(q_.Kt(p,s,o,s),(0.5-g)/2));}else if(t==u){g=$wnd.Math.abs(s-t);g<0.5&&(f[k++]=new q_.It(q_.Kt(o,t,o,s),(0.5-g)/2));}else {m=(u-t)/(q-p);n=-1/m;c=t-m*p;d=s-n*o;r=(d-c)/(m-n);v=m*r+c;g=$wnd.Math.sqrt((r-o)*(r-o)+(v-s)*(v-s));g<0.5&&(f[k++]=new q_.It(q_.Kt(r,v,o,s),(0.5-g)/2));}continue;}if(h<0.5){f[k++]=new q_.It(q_.Kt(p,t,o,s),(0.5-h)/2);continue;}if(i<0.5){f[k++]=new q_.It(q_.Kt(q,u,o,s),(0.5-i)/2);continue;}}if(k>0){j=q_.rt(f,k);a.a[b]+=j.b*$wnd.Math.sin(j.a);a.b[b]+=j.b*$wnd.Math.cos(j.a);}};q_.au=function au(a,b,c,d){var e,f,g;for(g=0;g<a.e.length;g++){f=$wnd.Math.sqrt((a.a[g]-b)*(a.a[g]-b)+(a.b[g]-c)*(a.b[g]-c));e=q_.Kt(b,c,a.a[g],a.b[g])+d;a.a[g]=b+f*$wnd.Math.sin(e);a.b[g]=c+f*$wnd.Math.cos(e);}};q_.bu=function bu(a,b,c){var d;for(d=0;d<a.e.length;d++){a.a[d]+=b;a.b[d]+=c;}};q_.cu=function cu(a,b,c){this.j=a;this.i=c;this.e=OI(h_.hK,k0,5,b,15,1);this.k=OI(h_.hK,k0,5,b,15,1);this.a=OI(h_.fK,B0,5,b,15,1);this.b=OI(h_.fK,B0,5,b,15,1);};q_.du=function du(a,b){var c,d;this.j=a.j;this.i=b;this.e=OI(h_.hK,k0,5,a.e.length,15,1);this.k=OI(h_.hK,k0,5,a.e.length,15,1);this.a=OI(h_.fK,B0,5,a.e.length,15,1);this.b=OI(h_.fK,B0,5,a.e.length,15,1);for(d=0;d<a.e.length;d++){this.e[d]=a.e[d];this.k[d]=a.k[d];this.a[d]=a.a[d];this.b[d]=a.b[d];}if(a.f!=null){this.f=OI(h_.hK,k0,5,a.f.length,15,1);for(c=0;c<a.f.length;c++)this.f[c]=a.f[c];}if(a.g!=null){this.g=OI(h_.hK,k0,5,a.g.length,15,1);for(c=0;c<a.g.length;c++)this.g[c]=a.g[c];}};xO(31,1,{31:1},q_.cu,q_.du);_.c=0;_.i=0;h_.gL=jQ(31);q_.eu=function eu(a){this.b=a;};xO(127,1,{127:1},q_.eu);_.a=0;h_.hL=jQ(127);xO(193,1,{});h_.iL=jQ(193);r_.fu=function fu(a){};r_.gu=function gu(a){var b,c,d;b=0;c=0;for(d=0;d<a.g.a.length+a.f.a.length;d++){b+=o_.Jj(d<a.g.a.length?l_.Th(a.g,d):l_.Th(a.f,d-a.g.a.length))*(d<a.g.a.length?l_.Th(a.g,d):l_.Th(a.f,d-a.g.a.length)).p;c+=(d<a.g.a.length?l_.Th(a.g,d):l_.Th(a.f,d-a.g.a.length)).p;}if(c!=0)return c/b;return 1;};r_.hu=function hu(b,c){var d,e,f,g;r_.fu(this);e=new s_.$u(b);try{g=new C_.vP();i_.$R(g.a,'$RXN\n');i_.$R(g.a,c!=null?c:'');i_.$R(g.a,'\n\n');C_.uP(g,Z1+s_.cv(b,11));i_.$R(g.a,J_);C_.uP(g,'  '+e.g.a.length+'  '+e.f.a.length+J_);f=r_.gu(e);for(d=0;d<e.g.a.length+e.f.a.length;d++){i_.$R(g.a,'$MOL\n');o_.Vo(new o_.Yo(d<e.g.a.length?l_.Th(e.g,d):l_.Th(e.f,d-e.g.a.length),f,null),g);}this.a=g.a;}catch(a){a=HN(a);if(VJ(a,13)){i_.oS();}else throw IN(a);}};xO(145,1,{},r_.hu);_.a=null;h_.jL=jQ(145);r_.iu=function iu(a){var b,c;b=new s_.Zu();c=new C_.pP(new C_.tP(a));r_.ju(b,c);return b;};r_.ju=function ju(a,b){var c,d;d=C_.oP(b);c=false;if(d==null||!i_.GR(n_.V$(d).substr(0,4),'$RXN')){throw IN(new i_.EG("'$RXN' tag not found"));}i_.GR(d,'$RXN V3000')?c=r_.lu(a,b,false):c=r_.ku(a,b,false);return c;};r_.ku=function ku(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;j=i_.TR(C_.oP(b));n_.V$(j).length!=0&&(a.e=j);C_.oP(b);d=C_.oP(b);if(!c&&i_.GR(n_.V$(d).substr(0,13),Z1)){e=n_.V$(d).substr(13);if(s_.bv(e,a))return true;}o=C_.oP(b);n=i_.CQ(i_.TR(n_.V$(o).substr(0,3)));l=i_.CQ(i_.TR(n_.V$(o).substr(3,3)));h=new o_.up();for(g=0;g<n;g++){o=C_.oP(b);if(o==null||!i_.GR(n_.V$(o).substr(0,4),'$MOL')){throw IN(new i_.EG($1));}m=new o_.$r();i=new i_.aS();do{o=C_.oP(b);i.a+=''+o;i.a+=J_;}while(o!=null&&!i_.GR(n_.V$(o).substr(0,6),G1));if(o==null){throw IN(new i_.EG(_1));}o_.qp(h,m,new C_.pP(new C_.tP(i.a)));l_.Oh(a.g,m);a.d=-1;}for(f=0;f<l;f++){o=C_.oP(b);if(o==null||!i_.GR(n_.V$(o).substr(0,4),'$MOL')){throw IN(new i_.EG($1));}k=new o_.$r();i=new i_.aS();do{o=C_.oP(b);i.a+=''+o;i.a+=J_;}while(o!=null&&!i_.GR(n_.V$(o).substr(0,6),G1));if(o==null){throw IN(new i_.EG(_1));}o_.qp(h,k,new C_.pP(new C_.tP(i.a)));l_.Oh(a.f,k);a.d=-1;}return true;};r_.lu=function lu(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;j=i_.TR(C_.oP(b));n_.V$(j).length!=0&&(a.e=j);C_.oP(b);d=C_.oP(b);if(!c&&i_.GR(n_.V$(d).substr(0,13),Z1)){e=n_.V$(d).substr(13);if(s_.bv(e,a))return true;}o=C_.oP(b);g=new o_.up();if(o!=null&&i_.GR(n_.V$(o).substr(0,13),'M  V30 COUNTS')){n=i_.TR(n_.V$(o).substr(13));k=i_.QR(n);m=i_.CQ(k[0]);l=i_.CQ(k[1]);if(m>0){o=C_.oP(b);if(i_.GR('M  V30 BEGIN REACTANT',o)){for(f=0;f<m;f++){h=new o_.$r();i=new i_.aS();i.a+=a2;do{o=C_.oP(b);i.a+=''+o;i.a+=J_;}while(o!=null&&!i_.GR(n_.V$(o).substr(0,15),b2));o_.qp(g,h,new C_.pP(new C_.tP(i.a)));l_.Oh(a.g,h);a.d=-1;}}o=C_.oP(b);}if(l>0){o=C_.oP(b);if(i_.GR('M  V30 BEGIN PRODUCT',o)){for(f=0;f<l;f++){h=new o_.$r();i=new i_.aS();i.a+=a2;do{o=C_.oP(b);i.a+=''+o;i.a+=J_;}while(o!=null&&!i_.GR(n_.V$(o).substr(0,15),b2));o_.qp(g,h,new C_.pP(new C_.tP(i.a)));l_.Oh(a.f,h);a.d=-1;}o=C_.oP(b);}}return true;}return false;};r_.mu=function mu(a){};r_.nu=function nu(a){var b,c,d;b=0;c=0;for(d=0;d<a.g.a.length+a.f.a.length;d++){b+=o_.Jj(d<a.g.a.length?l_.Th(a.g,d):l_.Th(a.f,d-a.g.a.length))*(d<a.g.a.length?l_.Th(a.g,d):l_.Th(a.f,d-a.g.a.length)).p;c+=(d<a.g.a.length?l_.Th(a.g,d):l_.Th(a.f,d-a.g.a.length)).p;}if(c!=0)return b/c;return 1;};r_.ou=function ou(b,c){var d,e,f,g,h,i;r_.mu(this);g=new s_.$u(b);try{i=new C_.vP();i_.$R(i.a,'$RXN V3000\n');i_.$R(i.a,c!=null?c:'');i_.$R(i.a,'\n\n');C_.uP(i,Z1+s_.cv(b,11));i_.$R(i.a,J_);f=g.g.a.length;e=g.f.a.length;i_.$R(i.a,n_.V$(J1+f+' '+e+J_).substr(f,f+e-f));h=r_.nu(g);if(f>0){i_.$R(i.a,'M  V30 BEGIN REACTANT\n');for(d=0;d<g.g.a.length;d++){C_.uP(i,o_.Ep(l_.Th(g.g,d),h));}i_.$R(i.a,'M  V30 END REACTANT\n');}if(e>0){i_.$R(i.a,'M  V30 BEGIN PRODUCT\n');for(d=0;d<g.f.a.length;d++){C_.uP(i,o_.Ep(l_.Th(g.f,d),h));}i_.$R(i.a,'M  V30 END PRODUCT\n');}i_.$R(i.a,E1);this.a=i.a;}catch(a){a=HN(a);if(VJ(a,13)){i_.oS();}else throw IN(a);}};xO(146,1,{},r_.ou);_.a=null;h_.kL=jQ(146);r_.qu=function qu(){r_.qu=zO;r_.pu=XI(II(h_.uM,1),d0,2,6,['Idorsia No','Actelion No','ID','IDNUMBER','COMPOUND_ID','NAME','COMPND']);};r_.ru=function ru(b){var c,d,e,f,g,h,i,j,k;if(!b.g)return false;i_.AP(b.f);i_.AP(b.a);b.e=null;k=false;d=-1;e=null;b.b=b.c==null?null:OI(h_.uM,d0,2,b.c.length,6,1);b.d=-1;do{try{j=C_.oP(b.g);if(j==null){i_.AP(b.f);return false;}}catch(a){a=HN(a);if(VJ(a,78)){i_.AP(b.f);return false;}else throw IN(a);}if(k){i_.gS(b.a,j);i_.cS(b.a,10);}else {if(i_.GR(n_.V$(j).substr(0,1),'>')){k=true;i_.gS(b.f,G1);i_.cS(b.f,10);i_.gS(b.a,j);i_.cS(b.a,10);}else {i_.gS(b.f,j);i_.cS(b.f,10);i_.GR(n_.V$(j).substr(0,6),G1)&&(k=true);continue;}}if(b.c!=null){if(n_.V$(j).length==0){d=-1;}else if(d==-1){e=r_.tu(j);if(e!=null){d=-1;for(c=0;c<b.c.length;c++){if(i_.GR(e,b.c[c])){d=c;break;}}if(b.d==-1){for(g=r_.pu,h=0,i=g.length;h<i;++h){f=g[h];if(i_.GR(e,f)){b.d=d;break;}}}}}else {b.b[d]==null?b.b[d]=j:b.b[d]=i_.ER(i_.ER(b.b[d],J_),j);}}}while(!i_.GR(n_.V$(j).substr(0,4),H1));return true;};r_.su=function su(b,c){var d,e,f,g;g=0;e=new o_.fs();while(g<c){try{f=C_.oP(b.g);}catch(a){a=HN(a);if(VJ(a,78)){break;}else throw IN(a);}if(f==null){break;}i_.GR(n_.V$(f).substr(0,4),H1)&&++g;if(i_.GR(n_.V$(f).substr(0,1),'>')){d=r_.tu(f);d!=null&&o_.es(e,d);}}b.c=l_.fi(e.b,OI(h_.uM,d0,2,0,6,1));};r_.tu=function tu(a){var b,c,d,e;if(n_.V$(a).length==0||(n_.S$(0,n_.V$(a).length),n_.V$(a).charCodeAt(0)!=62))return null;d=1;e=0;b=0;while(d<n_.V$(a).length){n_.S$(d,n_.V$(a).length);if(n_.V$(a).charCodeAt(d)==60){if(e!=0)return null;e=d;}else {n_.S$(d,n_.V$(a).length);if(n_.V$(a).charCodeAt(d)==62){if(b!=0)return null;b=d;}}++d;}if(e!=0&&e<b)return n_.V$(a).substr(e+1,b-(e+1));d=n_.V$(a).indexOf('DT',1);if(d==-1)return null;c=d+2;while(XP((n_.S$(c,n_.V$(a).length),n_.V$(a).charCodeAt(c))))++c;return c==d+2?null:n_.V$(a).substr(d,c-d);};r_.uu=function uu(a,b){if(a.b==null)return null;return a.b[b];};r_.vu=function vu(a){a.c==null&&r_.su(a,10240);return a.c;};r_.wu=function wu(a,b){a.c==null&&r_.su(a,b);return a.c;};r_.xu=function xu(a){var b;if(a.e)return a.e;a.e=o_.ap(new o_.up(),(b=a.f.a,b));!!a.e&&(a.e.N==null||n_.V$(a.e.N).length==0)&&o_.El(a.e,a.d!=-1&&a.b!=null?a.b[a.d]:a.e?a.e.N:null);return a.e;};r_.yu=function yu(a,b){r_.qu();this.c=b;this.g=new C_.pP(a);this.f=new i_.kS();this.a=new i_.kS();};xO(147,193,{},r_.yu);_.d=0;h_.lL=jQ(147);s_.zu=function zu(a,b){l_.Oh(a.a,b);};s_.Au=function Au(a,b,c){l_.Nh(a.a,c,b);};s_.Bu=function Bu(a,b){l_.Oh(a.f,b);a.d=-1;};s_.Cu=function Cu(a,b,c){l_.Nh(a.f,c,b);a.d=-1;};s_.Du=function Du(a,b){l_.Oh(a.g,b);a.d=-1;};s_.Eu=function Eu(a,b,c){l_.Nh(a.g,c,b);a.d=-1;};s_.Fu=function Fu(a){a.g.a=OI(h_.nM,W_,1,0,5,1);a.f.a=OI(h_.nM,W_,1,0,5,1);a.a.a=OI(h_.nM,W_,1,0,5,1);a.b=null;a.d=-1;};s_.Gu=function Gu(a){var b,c,d;for(d=new l_.KW(a.g);d.a<d.c.a.length;){b=l_.JW(d);if(b.I)return true;}for(c=new l_.KW(a.f);c.a<c.c.a.length;){b=l_.JW(c);if(b.I)return true;}return false;};s_.Hu=function Hu(a){var b,c,d,e;c=0;b=0;for(d=0;d<a.g.a.length+a.f.a.length;d++){e=d<a.g.a.length?l_.Th(a.g,d):l_.Th(a.f,d-a.g.a.length);if(e.p!=0){c+=e.p;b+=o_.Kj(e,e.o,e.p,(o_.Li(),o_.Ki))*e.p;}}return c==0?(o_.Li(),o_.Li(),o_.Ki):b/c;};s_.Iu=function Iu(a,b){return l_.Th(a.a,b);};s_.Ju=function Ju(a){var b,c,d;if(a.d!=-1)return a.d;a.d=0;for(c=0;c<a.g.a.length+a.f.a.length;c++){d=c<a.g.a.length?l_.Th(a.g,c):l_.Th(a.f,c-a.g.a.length);for(b=0;b<d.o;b++){a.d<$wnd.Math.abs(d.u[b])&&(a.d=$wnd.Math.abs(d.u[b]));}}return a.d;};s_.Ku=function Ku(a){var b,c,d,e;c=new s_.Zu();if(a.g.a.length!=0){e=new o_.as(l_.Th(a.g,0));for(b=1;b<a.g.a.length;b++)o_.Qi(e,l_.Th(a.g,b));l_.Oh(c.g,e);c.d=-1;}if(a.f.a.length!=0){d=new o_.as(l_.Th(a.f,0));for(b=1;b<a.f.a.length;b++)o_.Qi(d,l_.Th(a.f,b));l_.Oh(c.f,d);c.d=-1;}return c;};s_.Lu=function Lu(a,b){return b<a.g.a.length?l_.Th(a.g,b):l_.Th(a.f,b-a.g.a.length);};s_.Mu=function Mu(a){return a.g.a.length+a.f.a.length;};s_.Nu=function Nu(a){return a.e==null?'':a.e;};s_.Ou=function Ou(a,b){return l_.Th(a.f,b);};s_.Pu=function Pu(a,b){return l_.Th(a.g,b);};s_.Qu=function Qu(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;if(a.g.a.length==0||a.f.a.length==0)return null;m=s_.Ju(a);if(m==0)return null;l=OI(h_.hK,d1,6,a.f.a.length,0,2);for(f=0;f<a.f.a.length;f++){p=l_.Th(a.f,f);o_.Jr(p,15);l[f]=OI(h_.hK,k0,5,m+1,15,1);l_.SW(l[f]);for(b=0;b<p.o;b++){k=$wnd.Math.abs(p.u[b]);if(k!=0&&l[f][k]!=-1)return null;l[f][k]=b;}}g=OI(h_.DN,C0,5,m+1,16,1);for(e=0;e<a.g.a.length;e++){t=l_.Th(a.g,e);o_.Jr(t,15);for(r=0;r<t.o;r++){k=$wnd.Math.abs(t.u[r]);if(k!=0&&!g[k]){for(h=0;h<a.f.a.length;h++){n=l[h][k];if(n!=-1){p=l_.Th(a.f,h);if(t.g[r]!=p.g[n]){g[k]=true;break;}if((t.s[r]&3)!=(p.s[n]&3)){g[k]=true;break;}for(i=0;i<t.g[r];i++){c=o_.Aj(t,t.f[r][i]);if(c==0){g[k]=true;}else {s=t.i[r][i];d=false;for(j=0;j<p.g[n];j++){q=o_.Aj(p,p.f[n][j]);if(q==0){g[k]=true;break;}if(q==c){d=true;o=p.i[n][j];if((t.C[s]&512)!=0^(p.C[o]&512)!=0||(t.C[s]&512)==0&&(o_.Vj(t,s)!=o_.Vj(p,o)||(t.C[s]&3)!=(p.C[o]&3))){g[k]=true;g[c]=true;break;}break;}}d||(g[k]=true);}}}}}}}return g;};s_.Ru=function Ru(a){var b,c,d,e;for(d=new l_.KW(a.g);d.a<d.c.a.length;){b=l_.JW(d);if(b.o!=0)return false;}for(e=new l_.KW(a.f);e.a<e.c.a.length;){b=l_.JW(e);if(b.o!=0)return false;}for(c=new l_.KW(a.a);c.a<c.c.a.length;){b=l_.JW(c);if(b.o!=0)return false;}return true;};s_.Su=function Su(a){return a.g.a.length+a.f.a.length==0?a.c:s_.Gu(a);};s_.Tu=function Tu(a){var b,c,d,e,f,g,h,i,j,k,l;c=0;for(l=new l_.KW(a.g);l.a<l.c.a.length;){j=l_.JW(l);o_.Jr(j,1);c+=j.d;}for(i=new l_.KW(a.f);i.a<i.c.a.length;){g=l_.JW(i);o_.Jr(g,1);c-=g.d;}if(c!=0)return false;f=s_.Ju(a);d=OI(h_.DN,C0,5,f+1,16,1);for(k=new l_.KW(a.g);k.a<k.c.a.length;){j=l_.JW(k);for(b=0;b<j.d;b++){e=$wnd.Math.abs(j.u[b]);if(d[e])return false;d[e]=true;}}for(h=new l_.KW(a.f);h.a<h.c.a.length;){g=l_.JW(h);o_.Jr(g,1);for(b=0;b<g.d;b++){e=$wnd.Math.abs(g.u[b]);if(e>=f||!d[e])return false;d[e]=false;}}return true;};s_.Uu=function Uu(a){var b,c,d,e;if(a.g.a.length+a.f.a.length<=1)return false;b=s_.Hu(a);e=OI(h_.NL,W_,21,a.g.a.length+a.f.a.length,0,1);for(c=0;c<a.g.a.length+a.f.a.length;c++){e[c]=o_.$j(c<a.g.a.length?l_.Th(a.g,c):l_.Th(a.f,c-a.g.a.length),null);if(e[c]){for(d=0;d<c;d++){if(e[d]){if(e[c].c+e[c].b>=e[d].c&&e[c].c<=e[d].c+e[d].b)return true;if(e[c].d+e[c].a>=e[d].d&&e[c].d<=e[d].d+e[d].a)return true;}}if(c!=0&&!!e[c-1]){if(e[c].c-e[c-1].c-e[c].b>5*b)return true;if(e[c].d-e[c-1].d-e[c].a>5*b)return true;}}}return false;};s_.Vu=function Vu(a,b){a.b=b;};s_.Wu=function Wu(a,b){var c,d,e;a.c=b;for(e=new l_.KW(a.g);e.a<e.c.a.length;){c=l_.JW(e);o_.yl(c,b);}for(d=new l_.KW(a.f);d.a<d.c.a.length;){c=l_.JW(d);o_.yl(c,b);}};s_.Xu=function Xu(a,b){a.e=b;};s_.Yu=function Yu(a){var b,c,d,e,f,g,h,i,j;for(d=0;d<a.g.a.length;d++){j=l_.Th(a.g,d);for(e=0;e<j.o;e++){h=$wnd.Math.abs(j.u[e]);if(h!=0){b=0;for(f=0;f<a.f.a.length;f++){i=l_.Th(a.f,f);for(g=0;g<i.o;g++)$wnd.Math.abs(i.u[g])==h&&++b;}if(b==0)j.u[e]=0;else if(b>1)throw IN(new i_.EG('Duplicate mapping no in products'));}}}for(c=0;c<a.f.a.length;c++){i=l_.Th(a.f,c);for(e=0;e<i.o;e++){h=$wnd.Math.abs(i.u[e]);if(h!=0){b=0;for(f=0;f<a.g.a.length;f++){j=l_.Th(a.g,f);for(g=0;g<j.o;g++)$wnd.Math.abs(j.u[g])==h&&++b;}if(b==0)i.u[e]=0;else if(b>1)throw IN(new i_.EG('Duplicate mapping no in reactants'));}}}};s_.Zu=function Zu(){this.g=new l_.gi();this.f=new l_.gi();this.a=new l_.gi();this.d=-1;this.c=false;};s_.$u=function $u(a){var b,c,d,e,f,g;s_.Zu.call(this);g=!a?0:!a.g?0:a.g.a.length;f=!a?0:!a.f?0:a.f.a.length;b=!a?0:!a.a?0:a.a.a.length;for(d=0;d<g;d++)l_.Oh(this.g,new o_.as(l_.Th(a.g,d)));for(e=0;e<f;e++)l_.Oh(this.f,new o_.as(l_.Th(a.f,e)));for(c=0;c<b;c++)l_.Oh(this.a,new o_.as(l_.Th(a.a,c)));this.b=new o_.Ai(a.b);a.e!=null&&(this.e=a.e);this.c=a.c;};s_._u=function _u(a,b){var c,d;s_.Zu.call(this);for(d=0;d<b;d++)l_.Oh(this.g,a[d]);for(c=b;c<a.length;c++)l_.Oh(this.f,a[c]);this.c=s_.Gu(this);};xO(40,1,f1,s_.Zu,s_.$u,s_._u);_.c=false;_.d=0;h_.mL=jQ(40);s_.av=function av(a,b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;if(a==null||n_.V$(a).length==0){return null;}n=false;k=0;s=0;h=0;v=i_.KR(a,VR(33));if(v==-1){return null;}s_.Fu(f);while(k!=-1){k>v&&(n=true);i=i_.LR(a,VR(32),k);!n&&(i>v||i==-1)&&(i=v);j=null;if(i==-1){j=n_.V$(a).substr(k);k=-1;}else {j=n_.V$(a).substr(k,i-k);k=i+1;}r=null;if(b!=null&&n_.V$(b).length!=0){i=i_.LR(b,VR(32),s);if(i==-1){r=n_.V$(b).substr(s);}else {r=n_.V$(b).substr(s,i-s);s=i+1;}}g=null;if(c!=null&&n_.V$(c).length!=0){i=i_.LR(c,VR(32),h);if(i==-1){g=n_.V$(c).substr(h);}else {g=n_.V$(c).substr(h,i-h);h=i+1;}}u=new o_.io(true);t=j==null?null:o_.bo(u,n_.F$((p=j,n_.A$(),p)),g==null?null:n_.F$((q=g,q)));r!=null&&o_.eo(u,n_.F$((o=r,n_.A$(),o)));n?(l_.Oh(f.f,t),f.d=-1):(l_.Oh(f.g,t),f.d=-1);}d!=null&&n_.V$(d).length!=0&&s_.Vu(f,new o_.Bi(d));if(e!=null&&n_.V$(e).length!=0){u=new o_.io(true);l=0;m=i_.KR(e,VR(43));while(m!=-1){s_.zu(f,o_._n(u,n_.V$(e).substr(l,m-l)));l=m+1;m=i_.LR(e,VR(43),l);}s_.zu(f,o_._n(u,n_.V$(e).substr(l)));}return f;};s_.bv=function bv(a,b){var c,d,e,f,g,h,i,j,k;if(a==null)return null;h=a;j=null;i=null;k=null;g=null;c=i_.KR(a,VR(35));if(c==-1){h=a;}else {h=n_.V$(a).substr(0,c);d=i_.LR(a,VR(35),c+1);if(d==-1){j=n_.V$(a).substr(c+1);}else {j=n_.V$(a).substr(c+1,d-(c+1));e=i_.LR(a,VR(35),d+1);if(e==-1){i=n_.V$(a).substr(d+1);}else {i=n_.V$(a).substr(d+1,e-(d+1));f=i_.LR(a,VR(35),e+1);if(f==-1){k=n_.V$(a).substr(e+1);}else {k=n_.V$(a).substr(e+1,f-(e+1));g=n_.V$(a).substr(f+1);}}}}return s_.av(h,j,i,k,g,b);};s_.cv=function cv(a,b){var c,d;d=s_.dv(a,(b&16)==0);if(d==null){return null;}c=new i_.bS(d[0]);if(b!=0){c.a+='#';(b&1)!=0&&d.length>1&&d[1]!=null&&i_.$R(c,d[1]);}b&=-2;if(b!=0){c.a+='#';(b&2)!=0&&d.length>2&&d[2]!=null&&i_.$R(c,d[2]);}b&=-3;if(b!=0){c.a+='#';(b&4)!=0&&d.length>3&&d[3]!=null&&i_.$R(c,d[3]);}b&=-5;if(b!=0){c.a+='#';(b&8)!=0&&d.length>4&&d[4]!=null&&i_.$R(c,d[4]);}return c.a;};s_.dv=function dv(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;if(!a||a.g.a.length==0||a.f.a.length==0){return null;}j=OI(h_.uM,d0,2,a.g.a.length+a.f.a.length,6,1);n=OI(h_.uM,d0,2,a.g.a.length+a.f.a.length,6,1);e=OI(h_.uM,d0,2,a.g.a.length+a.f.a.length,6,1);for(h=0;h<a.g.a.length+a.f.a.length;h++){q=h<a.g.a.length?l_.Th(a.g,h):l_.Th(a.f,h-a.g.a.length);if(q.I&&h<a.g.a.length)for(c=0;c<q.o;c++)o_.fl(q,c,i1,false);d=new o_.Kf(q);j[h]=o_.of(d);if(j[h]==null){return null;}n[h]=o_.nf(d);e[h]=o_.mf(d,true);}k=new i_.jS();f=new i_.jS();o=new i_.jS();for(i=0;i<a.g.a.length;i++){l=i;if(b){p='';l=-1;for(m=0;m<a.g.a.length;m++){if(i_.CR(p,j[m])<0){p=j[m];l=m;}}}if(i>0){k.a+=' ';o.a+=' ';f.a+=' ';}i_.gS(k,j[l]);i_.gS(o,n[l]);i_.gS(f,e[l]);j[l]='';}k.a+='!';o.a+=' ';f.a+=' ';for(g=a.g.a.length;g<a.g.a.length+a.f.a.length;g++){l=g;if(b){p='';l=-1;for(m=a.g.a.length;m<a.g.a.length+a.f.a.length;m++){if(i_.CR(p,j[m])<0){p=j[m];l=m;}}}if(g>a.g.a.length){k.a+=' ';o.a+=' ';f.a+=' ';}i_.gS(k,j[l]);i_.gS(o,n[l]);i_.gS(f,e[l]);j[l]='';}r=OI(h_.uM,d0,2,5,6,1);r[0]=k.a;n_.V$(o.a).length>a.g.a.length+a.f.a.length-1&&(r[1]=o.a);n_.V$(f.a).length>a.g.a.length+a.f.a.length-1&&(r[2]=f.a);!!a.b&&(r[3]=o_.zi(a.b));a.a.a.length!=0&&(r[4]=s_.ev(a));return r;};s_.ev=function ev(a){var b,c,d;d=new i_.jS();for(c=0;c<a.a.a.length;c++){n_.V$(d.a).length!=0&&(d.a+='+',d);b=new o_.Kf(l_.Th(a.a,c));i_.gS(d,o_.of(b));d.a+=' ';i_.gS(d,o_.mf(b,true));}return d.a;};t_.Gy=function Gy(){t_.Gy=zO;t_.Fy=(!t_.SF&&(t_.SF=new t_.VF()),t_.SF);t_.Ey=new B_.lP();t_.Hv=XI(II(h_.uM,1),d0,2,6,['?','H','He','Li','Be','B','C','N','O','F','Ne','Na','Mg','Al','Si','P','S','Cl','Ar','K','Ca','Sc','Ti','V','Cr','Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As','Se','Br','Kr','Rb','Sr','Y','Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn','Sb','Te','I','Xe','Cs','Ba','La','Ce','Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb','Lu','Hf','Ta','W','Re','Os','Ir','Pt','Au','Hg','Tl','Pb','Bi','Po','At','Rn','Fr','Ra','Ac','Th','Pa','U','Np','Pu','Am','Cm','Bk','Cf','Es','Fm','Md','No','Lr',k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,'R4','R5','R6','R7','R8','R9','R10','R11','R12','R13','R14','R15','R16','R1','R2','R3','A','A1','A2','A3',k1,k1,'D','T','X','R','H2','H+','Nnn','HYD','Pol',k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,k1,'Ala','Arg','Asn','Asp','Cys','Gln','Glu','Gly','His','Ile','Leu','Lys','Met','Phe','Pro','Ser','Thr','Trp','Tyr','Val']);t_.Dy=XI(II(h_.CN,1),f1,5,15,[0,1,4,7,9,11,12,14,16,19,20,23,24,27,28,31,32,35,40,39,40,45,48,51,52,55,56,59,58,63,64,69,74,75,80,79,84,85,88,89,90,93,98,0,102,103,106,107,114,115,120,121,130,127,132,133,138,139,140,141,142,0,152,153,158,159,164,165,166,169,174,175,180,181,184,187,192,193,195,197,202,205,208,209,0,0,0,0,0,0,232,0,238,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,156,114,115,103,128,129,57,137,113,113,128,131,147,97,87,101,186,163,99]);t_.rv=XI(II(h_.uM,1),d0,2,6,[S1,c2,T1]);};t_.Hy=function Hy(a,b,c,d){return {x:a,y:b,width:c,height:d};};t_.Iy=function Iy(a){var b;b=new q_.pt();b.f=new l_.OX(0);q_.$s(b,a.a);o_.Nn(a.a);};t_.Jy=function Jy(){t_.Ky.call(this,32,32,null);};t_.Ky=function Ky(a,b,c){t_.Gy();c?this.a=c:this.a=new o_._r(a,b);};t_.Ly=function Ly(a){t_.Gy();t_.Ky.call(this,0,0,a);};t_.nz=function nz(a,b){return {molecule:a,map:b};};t_.Dz=function Dz(a,b){t_.Gy();var c;typeof b===d2&&(b=true);if(typeof b===M_){c=t_.Fz(a,false);b===true&&c.inventCoordinates();}else typeof b===O_&&(c=t_.Ez(a,b));return c;};t_.Ez=function Ez(a,b){return new t_.Ly(o_.ao(new o_.io(false),a,b));};t_.Fz=function Fz(a,b){return new t_.Ly(o_._n(new o_.io(b),a));};t_.Gz=function Gz(a){t_.Gy();return new t_.Ly(o_.ap(new o_.up(),a));};t_.Hz=function Hz(a){t_.Gy();var b,c,d;d=new o_.vp();c=(d.f=null,o_.sp(d,new C_.pP(new C_.tP(a)))?d.f:null);b=d.d==null?o_.Lm(d.f):d.d;return t_.nz(new t_.Ly(c),b);};t_.Iz=function Iz(a,b){t_.Gy();b=b||{};var c=!b.noCoordinates;var d=!b.noStereo;return t_.Jz(a,c,d);};t_.Jz=function Jz(a,b,c){var d,e;e=new t_.Jy();o_.ur(new o_.zr(),e.a,n_.F$((d=a,n_.A$(),d)),c);b&&t_.Iy(e);return e;};t_.Rz=function Rz(a,b,c,d){t_.Gy();return o_.Wl(a,b,c,d);};t_.Sz=function Sz(a,b){t_.Gy();return o_.Xl(a,b);};t_.qA=function qA(a){t_.Gy();return o_.Yl(a);};t_.UA=function UA(){t_.Gy();return o_.Li(),o_.Li(),o_.Ki;};t_.ZB=function ZB(a){t_.Gy();return o_.Zl(a);};t_.$B=function $B(a){t_.Gy();return o_.$l(a);};t_.wD=function wD(a){t_.Gy();o_.Li();o_.Ki=a;};xO(32,1,{32:1},t_.Jy,t_.Ky,t_.Ly);_.addAtom=function My(a){return o_.Ni(this.a,a);};_.addBond=function Ny(a,b){return o_.Oi(this.a,a,b);};_.addFragment=function Oy(a,b,c){o_._l(this.a,a.a,b,c);};_.tb=function Py(){p_.As(this.a);};_.ub=function Qy(a){p_.Bs(this.a,a);};_.addImplicitHydrogens=function Ry(a){a===undefined?this.tb():this.ub(a);};_.vb=function Sy(){p_.hs();p_.is(this.a,1);};_.wb=function Ty(a){p_.is(this.a,a);};_.addMissingChirality=function Uy(a){a===undefined?this.vb():this.wb(a);};_.addMolecule=function Vy(a){return o_.Qi(this.a,a.a);};_.addOrChangeAtom=function Wy(a,b,c,d,e,f,g){return o_.Ri(this.a,a,b,c,d,e,f,g);};_.addOrChangeBond=function Xy(a,b,c){return o_.Si(this.a,a,b,c);};_.addRing=function Yy(a,b,c,d){return o_.Ti(this.a,a,b,c,d);};_.addRingToAtom=function Zy(a,b,c){return o_.Ui(this.a,a,b,c);};_.addRingToBond=function $y(a,b,c){return o_.Vi(this.a,a,b,c);};_.addSubstituent=function _y(a,b){return o_.Wi(this.a,a.a,b);};_.calculateTorsion=function az(a){return o_.Xi(this.a,a);};_.canonizeCharge=function bz(a){return o_.bm(this.a,a,false);};_.changeAtom=function cz(a,b,c,d,e){return o_.Yi(this.a,a,b,c,d,e);};_.changeAtomCharge=function dz(a,b){return o_.Zi(this.a,a,b);};_.changeBond=function ez(a,b){return o_.$i(this.a,a,b);};_.clear=function fz(){o_._i(this.a);};_.convertStereoBondsToSingleBonds=function gz(a){o_.cm(this.a,a);};_.copyAtom=function hz(a,b,c,d){return o_.bj(this.a,a.a,b,c,d);};_.copyBond=function iz(a,b,c,d,e,f){return o_.dj(this.a,a.a,b,c,d,e,f);};_.copyMolecule=function jz(a){o_.ej(this.a,a.a);};_.copyMoleculeByAtoms=function kz(a,b,c,d){o_.dm(this.a,a.a,b,c,d);};_.copyMoleculeByBonds=function lz(a,b,c,d){return o_.em(this.a,a.a,b,c,d);};_.copyMoleculeProperties=function mz(a){o_.Ir(this.a,a.a);};_.deleteAtom=function oz(a){o_.gj(this.a,a);};_.deleteAtomOrBond=function pz(a,b){return o_.hj(this.a,a,b);};_.deleteAtoms=function qz(a){return o_.ij(this.a,a);};_.deleteBond=function rz(a){o_.jj(this.a,a);};_.deleteBondAndSurrounding=function sz(a){o_.kj(this.a,a);};_.deleteMarkedAtomsAndBonds=function tz(){return o_.lj(this.a);};_.deleteMolecule=function uz(){o_._i(this.a);};_.deleteSelectedAtoms=function vz(){return o_.mj(this.a);};_.ensureHelperArrays=function wz(a){o_.Jr(this.a,a);};_.findAlleneCenterAtom=function xz(a){return o_.gm(this.a,a);};_.findAlleneEndAtom=function yz(a,b){return o_.hm(this.a,a,b);};_.findAtom=function zz(a,b){return o_.nj(this.a,a,b);};_.findBINAPChiralityBond=function Az(a){return o_.im(this.a,a);};_.findBond=function Bz(a,b){return o_.oj(this.a,a,b);};_.findRingSystem=function Cz(a,b,c,d){o_.jm(this.a,a,b,c,d);};_.getAbsoluteAtomParity=function Kz(a){return o_.Kr(this.a,a);};_.getAbsoluteBondParity=function Lz(a){return o_.Lr(this.a,a);};_.getAllAtoms=function Mz(){return this.a.o;};_.getAllBonds=function Nz(){return this.a.p;};_.getAllConnAtoms=function Oz(a){return o_.mm(this.a,a);};_.getAllConnAtomsPlusMetalBonds=function Pz(a){return o_.nm(this.a,a);};_.getAllHydrogens=function Qz(a){return o_.om(this.a,a);};_.getAromaticRingCount=function Tz(){return o_.pm(this.a);};_.getAtomAbnormalValence=function Uz(a){return o_.pj(this.a,a);};_.getAtomCIPParity=function Vz(a){return o_.qj(this.a,a);};_.getAtomCharge=function Wz(a){return o_.rj(this.a,a);};_.getAtomColor=function Xz(a){return o_.sj(this.a,a);};_.getAtomCustomLabel=function Yz(a){return o_.tj(this.a,a);};_.getAtomESRGroup=function Zz(a){return o_.vj(this.a,a);};_.getAtomESRType=function $z(a){return o_.wj(this.a,a);};_.getAtomLabel=function _z(a){return o_.xj(this.a,a);};_.getAtomList=function aA(a){return o_.yj(this.a,a);};_.getAtomListString=function bA(a){return o_.zj(this.a,a);};_.getAtomMapNo=function cA(a){return o_.Aj(this.a,a);};_.getAtomMass=function dA(a){return o_.Bj(this.a,a);};_.getAtomParity=function eA(a){return o_.Cj(this.a,a);};_.getAtomPi=function fA(a){return o_.qm(this.a,a);};_.getAtomPreferredStereoBond=function gA(a){return o_.rm(this.a,a);};_.getAtomQueryFeatures=function hA(a){return o_.Dj(this.a,a);};_.getAtomRadical=function iA(a){return o_.Ej(this.a,a);};_.getAtomRingBondCount=function jA(a){return o_.sm(this.a,a);};_.getAtomRingCount=function kA(a,b){return o_.tm(this.a,a,b);};_.getAtomRingSize=function lA(a){return o_.um(this.a,a);};_.getAtomX=function mA(a){return o_.Fj(this.a,a);};_.getAtomY=function nA(a){return o_.Gj(this.a,a);};_.getAtomZ=function oA(a){return o_.Hj(this.a,a);};_.getAtomicNo=function pA(a){return o_.Ij(this.a,a);};_.getAtoms=function rA(){return this.a.d;};_.getAverageBondLength=function sA(a){return o_.vm(this.a,a);};_.getAverageTopologicalAtomDistance=function tA(){return o_.wm(this.a);};_.getBond=function uA(a,b){return o_.xm(this.a,a,b);};_.getBondAngle=function vA(a,b){return o_.Mj(this.a,a,b);};_.getBondAtom=function wA(a,b){return o_.Nj(this.a,a,b);};_.getBondBridgeMaxSize=function xA(a){return o_.Oj(this.a,a);};_.getBondBridgeMinSize=function yA(a){return o_.Pj(this.a,a);};_.getBondCIPParity=function zA(a){return o_.Qj(this.a,a);};_.getBondESRGroup=function AA(a){return o_.Rj(this.a,a);};_.getBondESRType=function BA(a){return o_.Sj(this.a,a);};_.getBondLength=function CA(a){return o_.Tj(this.a,a);};_.getBondOrder=function DA(a){return o_.Vj(this.a,a);};_.getBondParity=function EA(a){return o_.Wj(this.a,a);};_.getBondPreferredStereoBond=function FA(a){return o_.Fn(this.a,a);};_.getBondQueryFeatures=function GA(a){return o_.Xj(this.a,a);};_.getBondRingSize=function HA(a){return o_.ym(this.a,a);};_.getBondType=function IA(a){return o_.Yj(this.a,a);};_.getBondTypeSimple=function JA(a){return o_.Zj(this.a,a);};_.getBonds=function KA(){return this.a.e;};_.getBounds=function LA(){var a;a=o_.$j(this.a,t_.Ey);if(!a)return null;return t_.Hy(a.c,a.d,a.b,a.a);};_.getCanonizedIDCode=function MA(a){var b;b=new o_.Lf(this.a,a);return o_.of(b);};_.getChiralText=function NA(){return o_.Mr(this.a);};_.getChirality=function OA(){return this.a.G;};_.getCompactCopy=function PA(){return new t_.Ly(o_.Nr(this.a));};_.getConnAtom=function QA(a,b){return o_.zm(this.a,a,b);};_.getConnAtoms=function RA(a){return o_.Am(this.a,a);};_.getConnBond=function SA(a,b){return o_.Bm(this.a,a,b);};_.getConnBondOrder=function TA(a,b){return o_.Cm(this.a,a,b);};_.getDefaultMaxValenceUncharged=function VA(a){return o_._j(this.a,a);};_.getDiastereotopicAtomIDs=function WA(){return p_.js(this.a);};_.getElectronValenceCorrection=function XA(a,b){return o_.ak(this.a,a,b);};_.getExcludedNeighbourCount=function YA(a){return o_.Dm(this.a,a);};_.getExplicitHydrogens=function ZA(a){return o_.Em(this.a,a);};_.getFisherProjectionParity=function $A(a,b,c,d){return o_.Gm(this.a,a,b,c,d);};_.getFragmentAtoms=function _A(a,b){return o_.Hm(this.a,a,b);};_.getFragmentNumbers=function aB(a,b,c){return o_.Im(this.a,a,b,c);};_.getFragments=function bB(){var a,b,c;a=o_.Pr(this.a);c=OI(h_.nL,W_,32,a.length,0,1);for(b=0;b<a.length;b++){c[b]=new t_.Ly(a[b]);}return c;};_.getFreeValence=function cB(a){return o_.Jm(this.a,a);};_.getHandleHydrogenMap=function dB(){return o_.Lm(this.a);};_.getHelperArrayStatus=function eB(){return this.a.R;};_.getHoseCodes=function fB(a){a=a||{};var b=(typeof a.maxSphereSize===d2?5:a.maxSphereSize)|0;var c=(typeof a.type===d2?0:a.type)|0;return p_.ls(this.a,b,c);};_.getIDCode=function gB(){return o_.Rr(this.a);};_.getIDCodeAndCoordinates=function hB(){return {idCode:this.getIDCode(),coordinates:this.getIDCoordinates()};};_.getIDCoordinates=function iB(){return o_.Sr(this.a);};_.getImplicitHigherValence=function jB(a,b){return o_.Mm(this.a,a,b);};_.getImplicitHydrogens=function kB(a){return o_.Nm(this.a,a);};_.getIndex=function lB(){return o_.Jq(t_.UF(t_.Fy),this.a);};_.getLowestFreeValence=function mB(a){return o_.Om(this.a,a);};_.getMaxAtoms=function nB(){return this.a.K;};_.getMaxBonds=function oB(){return this.a.L;};_.getMaxValence=function pB(a){return o_.bk(this.a,a);};_.getMaxValenceUncharged=function qB(a){return o_.ck(this.a,a);};_.getMetalBondedConnAtoms=function rB(a){return o_.Pm(this.a,a);};_.getMolecularFormula=function sB(){return new t_.OF(this.a);};_.getMoleculeColor=function tB(){return this.a.M;};_.getMolweight=function uB(){return o_.Qm(this.a);};_.getName=function vB(){return this.a.N;};_.getNonHydrogenNeighbourCount=function wB(a){return o_.Rm(this.a,a);};_.getNumberOfHydrogens=function xB(){return p_.Cs(this.a);};_.getOCL=function yB(){return $wnd.OCL;};_.getOccupiedValence=function zB(a){return o_.Sm(this.a,a);};_.getPath=function AB(a,b,c,d,e){return o_.Tm(this.a,a,b,c,d,e);};_.getPathBonds=function BB(a,b,c){o_.Um(this.a,a,b,c);};_.getPathLength=function CB(a,b){return o_.Vm(this.a,a,b);};_.getRingSet=function DB(){return new t_.QE(o_.Ym(this.a));};_.getRotatableBondCount=function EB(){return o_.Zm(this.a);};_.xb=function FB(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o;j=t_.WF(g);i=new o_.hr(this.a,j,f);i.F=c;o_.Nd(i,new B_.mP(0,0,a,b));h=i.t;o_.Gd(i);o=o_.fr(i);if(d){l=kO(VN($wnd.Math.round(h.b+e*2)));k=kO(VN($wnd.Math.round(h.a+e*2)));m=kO(VN($wnd.Math.round(h.c-e)));n=kO(VN($wnd.Math.round(h.d-e)));return i_.PR(o,'width="'+l+'px" height="'+k+'px" viewBox="'+m+' '+n+' '+l+' '+k+'"');}else {return o;}};_.getStereoBond=function GB(a){return o_._m(this.a,a);};_.getStereoCenterCount=function HB(){return o_.Tr(this.a);};_.getStereoProblem=function IB(a){return o_.ek(this.a,a);};_.getSubstituent=function JB(a,b,c,d,e){return o_.bn(this.a,a,b,c,d.a,e);};_.getSubstituentSize=function KB(a,b){return o_.cn(this.a,a,b);};_.getSymmetryRank=function LB(a){return o_.Ur(this.a,a);};_.getZNeighbour=function MB(a,b){return o_.dn(this.a,a,b);};_.invalidateHelperArrays=function NB(a){o_.hk(this.a,a);};_.inventCoordinates=function OB(){t_.Iy(this);};_.is3D=function PB(){return o_.ik(this.a);};_.isAlkaliMetal=function QB(a){return o_.hn(this.a,a);};_.isAllylicAtom=function RB(a){return o_.jn(this.a,a);};_.isAmideTypeBond=function SB(a){return o_.kn(this.a,a);};_.isAromaticAtom=function TB(a){return o_.ln(this.a,a);};_.isAromaticBond=function UB(a){return o_.mn(this.a,a);};_.isAtomConfigurationUnknown=function VB(a){return o_.jk(this.a,a);};_.isAtomMarkedForDeletion=function WB(a){return o_.kk(this.a,a);};_.isAtomParityPseudo=function XB(a){return o_.lk(this.a,a);};_.isAtomStereoCenter=function YB(a){return o_.mk(this.a,a);};_.isAutoMappedAtom=function _B(a){return o_.nk(this.a,a);};_.isBINAPChiralityBond=function aC(a){return o_.nn(this.a,a);};_.isBondBackgroundHilited=function bC(a){return o_.ok(this.a,a);};_.isBondBridge=function cC(a){return o_.pk(this.a,a);};_.isBondForegroundHilited=function dC(a){return o_.qk(this.a,a);};_.isBondMarkedForDeletion=function eC(a){return o_.rk(this.a,a);};_.isBondParityPseudo=function fC(a){return o_.sk(this.a,a);};_.isBondParityUnknownOrNone=function gC(a){return o_.tk(this.a,a);};_.isChalcogene=function hC(a){return o_.pn(this.a,a);};_.isDelocalizedBond=function iC(a){return o_.qn(this.a,a);};_.isEarthAlkaliMetal=function jC(a){return o_.rn(this.a,a);};_.isElectronegative=function kC(a){return o_.uk(this.a,a);};_.isElectropositive=function lC(a){return o_.vk(this.a,a);};_.isFlatNitrogen=function mC(a){return o_.sn(this.a,a);};_.isFragment=function nC(){return this.a.I;};_.isHalogene=function oC(a){return o_.tn(this.a,a);};_.isMarkedAtom=function pC(a){return o_.wk(this.a,a);};_.isMetalAtom=function qC(a){return o_.xk(this.a,a);};_.isNaturalAbundance=function rC(a){return o_.yk(this.a,a);};_.isNitrogenFamily=function sC(a){return o_.un(this.a,a);};_.isOrganicAtom=function tC(a){return o_.zk(this.a,a);};_.isPseudoRotatableBond=function uC(a){return o_.vn(this.a,a);};_.isPurelyOrganic=function vC(){return o_.Ak(this.a);};_.isRingAtom=function wC(a){return o_.wn(this.a,a);};_.isRingBond=function xC(a){return o_.xn(this.a,a);};_.isSelectedAtom=function yC(a){return o_.Bk(this.a,a);};_.isSelectedBond=function zC(a){return o_.Ck(this.a,a);};_.isSimpleHydrogen=function AC(a){return o_.yn(this.a,a);};_.isSmallRingAtom=function BC(a){return o_.zn(this.a,a);};_.isSmallRingBond=function CC(a){return o_.An(this.a,a);};_.isStabilizedAtom=function DC(a){return o_.Bn(this.a,a);};_.isStereoBond=function EC(a){return o_.Dk(this.a,a);};_.markAtomForDeletion=function FC(a){o_.Fk(this.a,a);};_.markBondForDeletion=function GC(a){o_.Gk(this.a,a);};_.normalizeAmbiguousBonds=function HC(){return o_.Cn(this.a);};_.removeAtomColors=function IC(){o_.Jk(this.a);};_.removeAtomCustomLabels=function JC(){this.a.r=null;};_.removeAtomMarkers=function KC(){o_.Kk(this.a);};_.removeAtomSelection=function LC(){o_.Lk(this.a);};_.removeBondHiliting=function MC(){o_.Mk(this.a);};_.removeExplicitHydrogens=function NC(a){o_.Hn(this.a,a);};_.removeQueryFeatures=function OC(){return o_.Ok(this.a);};_.renumberESRGroups=function PC(a){return o_.Pk(this.a,a);};_.scaleCoords=function QC(a){o_.Qk(this.a,a);};_.setAllAtoms=function RC(a){o_.Rk(this.a,a);};_.setAllBonds=function SC(a){o_.Sk(this.a,a);};_.setAssignParitiesToNitrogen=function TC(a){o_.Vr(this.a,a);};_.setAtomAbnormalValence=function UC(a,b){o_.Tk(this.a,a,b);};_.setAtomCIPParity=function VC(a,b){o_.Uk(this.a,a,b);};_.setAtomCharge=function WC(a,b){o_.Vk(this.a,a,b);};_.setAtomColor=function XC(a,b){o_.Wk(this.a,a,b);};_.setAtomConfigurationUnknown=function YC(a,b){o_.Xk(this.a,a,b);};_.setAtomCustomLabel=function ZC(a,b){o_.Yk(this.a,a,b);};_.setAtomESR=function $C(a,b,c){o_.$k(this.a,a,b,c);};_.setAtomList=function _C(a,b,c){o_.al(this.a,a,b,c);};_.setAtomMapNo=function aD(a,b,c){o_.bl(this.a,a,b,c);};_.setAtomMarker=function bD(a,b){o_.cl(this.a,a,b);};_.setAtomMass=function cD(a,b){o_.dl(this.a,a,b);};_.setAtomParity=function dD(a,b,c){o_.el(this.a,a,b,c);};_.setAtomQueryFeature=function eD(a,b,c){o_.fl(this.a,a,b,c);};_.setAtomRadical=function fD(a,b){o_.gl(this.a,a,b);};_.setAtomSelection=function gD(a,b){o_.hl(this.a,a,b);};_.setAtomX=function hD(a,b){o_.jl(this.a,a,b);};_.setAtomY=function iD(a,b){o_.kl(this.a,a,b);};_.setAtomZ=function jD(a,b){o_.ll(this.a,a,b);};_.setAtomicNo=function kD(a,b){o_.ml(this.a,a,b);};_.setBondAtom=function lD(a,b,c){o_.nl(this.a,a,b,c);};_.setBondBackgroundHiliting=function mD(a,b){o_.ol(this.a,a,b);};_.setBondCIPParity=function nD(a,b){o_.pl(this.a,a,b);};_.setBondESR=function oD(a,b,c){o_.ql(this.a,a,b,c);};_.setBondForegroundHiliting=function pD(a,b){o_.rl(this.a,a,b);};_.setBondOrder=function qD(a,b){o_.sl(this.a,a,b);};_.setBondParity=function rD(a,b,c){o_.tl(this.a,a,b,c);};_.setBondParityUnknownOrNone=function sD(a){o_.ul(this.a,a);};_.setBondQueryFeature=function tD(a,b,c){o_.vl(this.a,a,b,c);};_.setBondType=function uD(a,b){o_.wl(this.a,a,b);};_.setChirality=function vD(a){o_.xl(this.a,a);};_.setFragment=function xD(a){o_.yl(this.a,a);};_.setHelperValidity=function yD(a){o_.zl(this.a,a);};_.setHydrogenProtection=function zD(a){o_.Al(this.a,a);};_.setMaxAtoms=function AD(a){o_.Bl(this.a,a);};_.setMaxBonds=function BD(a){o_.Cl(this.a,a);};_.setMoleculeColor=function CD(a){o_.Dl(this.a,a);};_.setName=function DD(a){o_.El(this.a,a);};_.setParitiesValid=function ED(a){o_.Kn(this.a,a);};_.setStereoBondFromAtomParity=function FD(a){o_.Ln(this.a,a);};_.setStereoBondFromBondParity=function GD(a){o_.Mn(this.a,a);};_.setStereoBondsFromParity=function HD(){o_.Nn(this.a);};_.setToRacemate=function ID(){this.a.J=true;};_.setUnknownParitiesToExplicitlyUnknown=function JD(){o_.Wr(this.a);};_.shareSameFragment=function KD(a,b){return o_.Vm(this.a,a,b)!=-1;};_.stripIsotopInfo=function LD(){return o_.Hl(this.a);};_.stripSmallFragments=function MD(a){return o_.On(this.a,a);};_.stripStereoInformation=function ND(){o_.Xr(this.a);};_.suggestBondType=function OD(a,b){return o_.Il(this.a,a,b);};_.supportsImplicitHydrogen=function PD(a){return o_.Pn(this.a,a);};_.swapAtoms=function QD(a,b){o_.Jl(this.a,a,b);};_.swapBonds=function RD(a,b){o_.Kl(this.a,a,b);};_.toIsomericSmiles=function SD(a){return o_.xo(new o_.Eo(this.a,a));};_.toMolfile=function TD(){var a;a=new o_.Wo(this.a);return a.a.a;};_.toMolfileV3=function UD(){var a;a=new o_.zp(this.a);return a.a.a;};_.toSVG=function VD(a,b,c,d){d=d||{};var e=d.factorTextSize||1;var f=d.autoCrop===true;var g=typeof d.autoCropMargin===d2?5:d.autoCropMargin;var h=this.xb(a,b,e,f,g,c,d);d.fontWeight&&(h=h.replace(/font-family=" Helvetica" /g,'font-family=" Helvetica" font-weight="'+d.fontWeight+u0));d.strokeWidth&&(h=h.replace(/stroke-width="[^"]+"/g,z0+d.strokeWidth+'"'));return h;};_.toSmiles=function WD(){return o_.kr(new o_.nr(),this.a);};_.translateCoords=function XD(a,b){o_.Ll(this.a,a,b);};_.validate=function YD(){o_.Yr(this.a);};_.zoomAndRotate=function ZD(a,b,c){o_.Nl(this.a,a,b,c);};_.zoomAndRotateInit=function $D(a,b){o_.Ol(this.a,a,b);};t_.fv=32;t_.gv=2;t_.hv=4;t_.iv=6;t_.jv=64;t_.kv=128;t_.lv=1;t_.mv=256;t_.nv=8;t_.ov=16;t_.pv=e2;t_.qv=e2;t_.sv=T1;t_.tv=S1;t_.uv=c2;t_.vv=0;t_.wv=3;t_.xv=1;t_.yv=2;t_.zv=64;t_.Av=384;t_.Bv=448;t_.Cv=192;t_.Dv=256;t_.Ev=0;t_.Fv=320;t_.Gv=128;t_.Iv=1;t_.Jv=2;t_.Kv=4;t_.Lv=0;t_.Mv=3;t_.Nv=1;t_.Ov=6;t_.Pv=2;t_.Qv=1;t_.Rv=2;t_.Sv=M0;t_.Tv=3;t_.Uv=25;t_.Vv=D0;t_.Wv=U0;t_.Xv=K0;t_.Yv=4;t_.Zv=7;t_.$v=J0;t_._v=b0;t_.aw=O1;t_.bw=5;t_.cw=17;t_.dw=Q0;t_.ew=V0;t_.fw=30;t_.gw=128;t_.hw=h1;t_.iw=c0;t_.jw=256;t_.kw=b1;t_.lw=32768;t_.mw=512;t_.nw=Z0;t_.ow=e0;t_.pw=16;t_.qw=L0;t_.rw=a0;t_.sw=32;t_.tw=R0;t_.uw=64;t_.vw=4;t_.ww=8;t_.xw=q1;t_.yw=33554432;t_.zw=r1;t_.Aw=3;t_.Bw=14;t_.Cw=P0;t_.Dw=T0;t_.Ew=3;t_.Fw=22;t_.Gw=120;t_.Hw=4;t_.Iw=3;t_.Jw=2;t_.Kw=i1;t_.Lw=$_;t_.Mw=i1;t_.Nw=y1;t_.Ow=30;t_.Pw=O1;t_.Qw=48;t_.Rw=32;t_.Sw=0;t_.Tw=16;t_.Uw=4;t_.Vw=48;t_.Ww=1;t_.Xw=0;t_.Yw=3;t_.Zw=2;t_.$w=1;t_._w=0;t_.ax=3;t_.bx=2;t_.cx=2097151;t_.dx=Y0;t_.ex=2;t_.fx=19;t_.gx=Z0;t_.hx=31;t_.ix=5;t_.jx=0;t_.kx=X0;t_.lx=8;t_.mx=K0;t_.nx=4;t_.ox=7;t_.px=7;t_.qx=30720;t_.rx=4;t_.sx=11;t_.tx=8;t_.ux=2;t_.vx=b1;t_.wx=16;t_.xx=1572960;t_.yx=21;t_.zx=a0;t_.Ax=32;t_.Bx=64;t_.Cx=$0;t_.Dx=3;t_.Ex=15;t_.Fx=96;t_.Gx=2;t_.Hx=5;t_.Ix=1572991;t_.Jx=1;t_.Kx=4;t_.Lx=26;t_.Mx=128;t_.Nx=64;t_.Ox=2;t_.Px=9;t_.Qx=127;t_.Rx=32;t_.Sx=1;t_.Tx=4;t_.Ux=17;t_.Vx=458752;t_.Wx=S0;t_.Xx=f0;t_.Yx=b1;t_.Zx=h1;t_.$x=e0;t_._x=196608;t_.ay=0;t_.by=327680;t_.cy=6;t_.dy=5;t_.ey=32;t_.fy=0;t_.gy=1;t_.hy=2;t_.iy=8;t_.jy=128;t_.ky=1;t_.ly=4;t_.my=2;t_.ny=32;t_.oy=64;t_.py=16;t_.qy=252;t_.ry=15;t_.sy=1;t_.ty=0;t_.uy=7;t_.vy=3;t_.wy=47;t_.xy=79;t_.yy=31;t_.zy=190;t_.Ay=16;t_.By=0;t_.Cy=1;h_.nL=jQ(32);t_._D=function _D(a){this.a=a;};t_.iE=function iE(){return new t_._D(new s_.Zu());};t_.jE=function jE(a,b){var c,d;d=OI(h_.XK,K_,23,a.length,0,1);for(c=0;c<a.length;c++){d[c]=a[c].a;}return new t_._D(new s_._u(d,b));};t_.kE=function kE(a){return new t_._D(r_.iu(a));};t_.lE=function lE(a){var b,c;c=o_.vr(new o_.zr(),n_.F$((b=a,n_.A$(),b)));return new t_._D(c);};xO(63,1,{},t_._D);_.addCatalyst=function aE(a){s_.zu(this.a,a.a);};_.addCatalystAt=function bE(a,b){s_.Au(this.a,a.a,b);};_.addProduct=function cE(a){s_.Bu(this.a,a.a);};_.addProductAt=function dE(a,b){s_.Cu(this.a,a.a,b);};_.addReactant=function eE(a){s_.Du(this.a,a.a);};_.addReactantAt=function fE(a,b){s_.Eu(this.a,a.a,b);};_.clear=function gE(){s_.Fu(this.a);};_.clone=function hE(){return new t_._D(new s_.$u(this.a));};_.getAverageBondLength=function mE(){return s_.Hu(this.a);};_.getCatalyst=function nE(a){return new t_.Ly(s_.Iu(this.a,a));};_.getCatalysts=function oE(){return this.a.a.a.length;};_.getHighestMapNo=function pE(){return s_.Ju(this.a);};_.getMergedCopy=function qE(){return new t_._D(s_.Ku(this.a));};_.getMolecule=function rE(a){return new t_.Ly(s_.Lu(this.a,a));};_.getMolecules=function sE(){return s_.Mu(this.a);};_.getName=function tE(){return s_.Nu(this.a);};_.getOCL=function uE(){return $wnd.OCL;};_.getProduct=function vE(a){return new t_.Ly(s_.Ou(this.a,a));};_.getProducts=function wE(){return this.a.f.a.length;};_.getReactant=function xE(a){return new t_.Ly(s_.Pu(this.a,a));};_.getReactants=function yE(){return this.a.g.a.length;};_.getReactionCenterMapNos=function zE(){return s_.Qu(this.a);};_.isEmpty=function AE(){return s_.Ru(this.a);};_.isFragment=function BE(){return s_.Su(this.a);};_.isPerfectlyMapped=function CE(){return s_.Tu(this.a);};_.isReactionLayoutRequired=function DE(){return s_.Uu(this.a);};_.removeCatalysts=function EE(){this.a.a.a=OI(h_.nM,W_,1,0,5,1);};_.setFragment=function FE(a){s_.Wu(this.a,a);};_.setName=function GE(a){s_.Xu(this.a,a);};_.toRxn=function HE(a){var b;b=new r_.hu(this.a,a);return b.a?b.a.a:null;};_.toRxnV3=function IE(a){var b;b=new r_.ou(this.a,a);return b.a?b.a.a:null;};_.toSmiles=function JE(){return o_.Fo(this.a);};_.validateMapping=function KE(){s_.Yu(this.a);};h_.oL=jQ(63);t_.QE=function QE(a){this.a=a;};xO(143,1,{},t_.QE);_.determineAromaticity=function RE(a,b,c,d){o_.Ip(this.a,a,b,c,d);};_.getAtomIndex=function SE(a,b){return o_.Kp(this.a,a,b);};_.getAtomRingSize=function TE(a){return o_.Lp(this.a,a);};_.getBondIndex=function UE(a,b){return o_.Mp(this.a,a,b);};_.getBondRingSize=function VE(a){return o_.Np(this.a,a);};_.getHeteroPosition=function WE(a){return o_.Op(this.a,a);};_.getOCL=function XE(){return $wnd.OCL;};_.getRingAtoms=function YE(a){return o_.Pp(this.a,a);};_.getRingBonds=function ZE(a){return o_.Qp(this.a,a);};_.getRingSize=function $E(a){return o_.Sp(this.a,a);};_.getSharedRing=function _E(a,b){return o_.Tp(this.a,a,b);};_.getSize=function aF(){return this.a.i.a.length;};_.isAromatic=function bF(a){return o_.Up(this.a,a);};_.isAtomMember=function cF(a,b){return o_.Vp(this.a,a,b);};_.isBondMember=function dF(a,b){return o_.Wp(this.a,a,b);};_.isDelocalized=function eF(a){return o_.Xp(this.a,a);};_.qualifiesAsAmideTypeBond=function fF(a){return o_.Yp(this.a,a);};_.validateMemberIndex=function gF(a,b){return o_._p(this.a,a,b);};t_.LE=7;t_.ME=3;t_.NE=7;t_.OE=5;t_.PE=1;h_.pL=jQ(143);t_.hF=function hF(a,b){this.a=new r_.yu(new C_.tP(a),b);};xO(192,1,{},t_.hF);_.getField=function iF(a){var b,c;c=r_.vu(this.a);for(b=0;b<c.length;b++){if(i_.GR(c[b],a)){return r_.uu(this.a,b);}}return null;};_.getFieldData=function jF(a){return r_.uu(this.a,a);};_.getFieldNames=function kF(a){return r_.wu(this.a,a);};_.getMolecule=function lF(){return new t_.Ly(r_.xu(this.a));};_.getNextFieldData=function mF(){var a;return a=this.a.a.a,a;};_.getNextMolFile=function nF(){var a;return a=this.a.f.a,a;};_.getOCL=function oF(){return $wnd.OCL;};_.next=function pF(){return r_.ru(this.a);};h_.qL=jQ(192);t_.qF=function qF(a){a.a=new o_.Dq();};t_.rF=function rF(a,b){o_.wq(a.a,b.a);};t_.sF=function sF(a,b){o_.xq(a.a,b.a);};t_.tF=function tF(){t_.qF(this);};xO(194,1,{},t_.tF);_.getOCL=function uF(){return $wnd.OCL;};_.isFragmentInMolecule=function vF(){return o_.rq(this.a);};_.setFragment=function wF(a){t_.rF(this,a);};_.setMol=function xF(a,b){o_.xq(this.a,b.a);o_.wq(this.a,a.a);};_.setMolecule=function yF(a){t_.sF(this,a);};h_.sL=jQ(194);t_.zF=function zF(a){a.a=new o_.Rq();};t_.AF=function AF(){t_.zF(this);};t_.BF=function BF(a){return eR(a);};t_.DF=function DF(a){return o_.Sq(a);};t_.EF=function EF(a){return o_.Tq(a);};t_.FF=function FF(){return o_.Iq(),o_.Gq;};t_.HF=function HF(a,b){return o_.Uq(a,b);};t_.IF=function IF(a,b){return o_.Vq(a,b);};xO(195,1,{},t_.AF);_.createIndex=function CF(a){return o_.Jq(this.a,a.a);};_.getOCL=function GF(){return $wnd.OCL;};_.isFragmentInMolecule=function JF(){return o_.Mq(this.a);};_.setFragment=function KF(a,b){o_.Pq(this.a,a.a,b);};_.setMolecule=function LF(a,b){o_.Qq(this.a,a.a,b);};h_.rL=jQ(195);t_.MF=function MF(){};t_.NF=function NF(a,b){b=b||{};var c=(typeof b.maxSphereSize===d2?5:b.maxSphereSize)|0;var d=(typeof b.type===d2?0:b.type)|0;return p_.ns(a,c,d);};xO(196,1,{},t_.MF);h_.tL=jQ(196);t_.OF=function OF(a){o_.No();o_.Ro.call(this,a);};xO(142,82,{82:1},t_.OF);yO(_,{absoluteWeight:{'get':function PF(){return o_.Oo(this);}}});yO(_,{formula:{'get':function QF(){return o_.Po(this);}}});yO(_,{relativeWeight:{'get':function RF(){return o_.Qo(this);}}});h_.uL=jQ(142);t_.TF=function TF(a){};t_.UF=function UF(a){!a.a&&(a.a=new o_.Rq());return a.a;};t_.VF=function VF(){t_.TF(this);};xO(139,1,{},t_.VF);_.a=null;t_.SF=null;h_.vL=jQ(139);t_.WF=function WF(a){if(!a)return 0;var b=0;a.inflateToMaxAVBL&&(b|=e0);a.inflateToHighResAVBL&&(b|=h1);a.chiralTextBelowMolecule&&(b|=0);a.chiralTextAboveMolecule&&(b|=b1);a.chiralTextOnFrameTop&&(b|=Z0);a.chiralTextOnFrameBottom&&(b|=786432);a.noTabus&&(b|=1);a.showAtomNumber&&(b|=2);a.showBondNumber&&(b|=4);a.highlightQueryFeatures&&(b|=8);a.showMapping&&(b|=16);a.suppressChiralText&&(b|=32);a.suppressCIPParity&&(b|=64);a.suppressESR&&(b|=128);a.showSymmetrySimple&&(b|=256);a.showSymmetryDiastereotopic&&(b|=512);a.showSymmetryEnantiotopic&&(b|=L0);a.noImplicitAtomLabelColors&&(b|=V0);a.noStereoProblem&&(b|=b0);return b;};u_.XF=function XF(a,b){var c;c=a-b;c>=H0?c-=G0:c<u1&&(c+=G0);return c;};u_.YF=function YF(a,b){var c;for(c=b;c<a.length;c++){if(a[c]==62)return c;}return -1;};u_.$F=function $F(){u_.$F=zO;u_.ZF=XI(II(h_.gK,1),f1,5,15,[0.29899999499320984,0.5870000123977661,0.11400000005960464]);};u_._F=function _F(a,b){var c,d,e,f,g,h,i,j,k;c=A_.OO(a);h=!a?1:(u_.ZF[0]*(a.c>>16&255)+u_.ZF[1]*(a.c>>8&255)+u_.ZF[2]*(a.c&255))/255;if(h==0)return new A_.PO(h,h,h,c[3]);d=b/(!a?1:(u_.ZF[0]*(a.c>>16&255)+u_.ZF[1]*(a.c>>8&255)+u_.ZF[2]*(a.c&255))/255);k=0;j=0;for(f=0;f<3;f++){c[f]*=d;if(c[f]<1){j+=u_.ZF[f];}else {k+=(c[f]-1)*u_.ZF[f];c[f]=1;}}if(k!=0){i=0;for(g=0;g<3;g++){if(c[g]<1){c[g]+=k/j;if(c[g]>1){i+=(c[g]-1)*u_.ZF[g];c[g]=1;}}}if(i!=0){for(e=0;e<3;e++){if(c[e]<1){c[e]+=i/u_.ZF[e];c[e]>1&&(c[e]=1);}}}}return new A_.PO(c[0],c[1],c[2],c[3]);};u_.aG=function aG(a,b){u_.$F();var c,d,e,f,g,h,i,j,k,l,m;c=!b?1:(u_.ZF[0]*(b.c>>16&255)+u_.ZF[1]*(b.c>>8&255)+u_.ZF[2]*(b.c&255))/255;g=!a?1:(u_.ZF[0]*(a.c>>16&255)+u_.ZF[1]*(a.c>>8&255)+u_.ZF[2]*(a.c&255))/255;e=$wnd.Math.abs(c-g);if(e>s0)return a;h=OI(h_.gK,f1,5,3,15,1);A_.MO();A_.TO((b.c>>16&255)/255,(b.c>>8&255)/255,(b.c&255)/255,h);i=OI(h_.gK,f1,5,3,15,1);A_.TO((a.c>>16&255)/255,(a.c>>8&255)/255,(a.c&255)/255,i);j=$wnd.Math.abs(i[0]-h[0]);j>0.5&&(j=1-j);m=1-$wnd.Math.max(i[1],h[1]);d=$wnd.Math.abs(g+c-1);k=$wnd.Math.cos(H0*j*3);l=s0*$wnd.Math.max(m,$wnd.Math.max(d,k));if(e>l)return a;f=g>c?g+l>1:g-l>0;return u_._F(a,f?c-l:c+l);};u_.bG=function bG(a,b){u_.$F();return new A_.RO(cK((a.c>>16&255)+s0*((b.c>>16&255)-(a.c>>16&255))),cK((a.c>>8&255)+s0*((b.c>>8&255)-(a.c>>8&255))),cK((a.c&255)+s0*((b.c&255)-(a.c&255))));};u_.cG=function cG(a,b){var c;if(a==null)return b==null?0:1;if(b==null)return -1;for(c=0;c<a.length;c++){if(b.length==c)return 1;if(a[c]!=b[c])return a[c]<b[c]?-1:1;}return b.length>a.length?-1:0;};u_.dG=function dG(){};xO(149,1,f1,u_.dG);_.kb=function eG(a,b){return u_.cG(a,b);};_.gb=function fG(a){return this===a;};h_.wL=jQ(149);k_.LG=function LG(a){i_.JG.call(this,a);};xO(163,67,Y_);h_.AL=jQ(163);j_.NG=function NG(){j_.NG=zO;j_.MG=new uc();};j_.OG=function OG(a){a.a='';};j_.PG=function PG(a){var b;if(a.c==null){b=bK(a.b)===bK(j_.MG)?null:a.b;a.d=b==null?X_:YJ(b)?j_.UG(b):$J(b)?'String':i_.dQ(i_.yc(b));a.a=a.a+': '+(YJ(b)?j_.TG(b):b+'');a.c='('+a.d+') '+a.a;}};j_.QG=function QG(a){return bK(a.b)===bK(j_.MG)?null:a.b;};j_.RG=function RG(a){j_.NG();j_.SG.call(this,a);};j_.SG=function SG(a){k_.LG.call(this,a);j_.OG(this);this.b=a;this.a='';};j_.TG=function TG(a){return a==null?null:a.message;};j_.UG=function UG(a){return a==null?null:a.name;};xO(83,163,{83:1,4:1,13:1,20:1,17:1},j_.RG);_.Cb=function VG(){j_.PG(this);return this.c;};_.Eb=function WG(){return j_.QG(this);};h_.xL=jQ(83);j_.eH=function eH(b,a){return b[a];};j_.fH=function fH(a){return a.length;};j_.gH=function gH(b,a){b[b.length]=a;};j_.hH=function hH(b,a){return b[a];};j_.iH=function iH(a){return a.length;};j_.jH=function jH(){if(Date.now){return Date.now();}return new Date().getTime();};xO(189,1,{});h_.zL=jQ(189);k_.nH=function nH(){k_.nH=zO;!!(k_.IH(),k_.HH);};k_.oH=function oH(a,b,c){return a.apply(b,c);};k_.pH=function pH(){var a;if(kH!=0){a=j_.jH();if(a-lH>2000){lH=a;mH=k_.wH();}}if(kH++==0){k_.zH((k_.yH(),k_.xH));return true;}return false;};function qH(b){k_.nH();return function(){return k_.rH(b,this,arguments);};}k_.rH=function rH(a,b,c){var d;d=k_.pH();try{return k_.oH(a,b,c);}finally{k_.sH(d);}};k_.sH=function sH(a){a&&k_.AH((k_.yH(),k_.xH));--kH;if(a){if(mH!=-1){k_.uH(mH);mH=-1;}}};k_.tH=function tH(a){k_.nH();$wnd.setTimeout(function(){throw a;},0);};k_.uH=function uH(a){$wnd.clearTimeout(a);};k_.vH=function vH(){kH!=0&&(kH=0);mH=-1;};k_.wH=function wH(){return $wnd.setTimeout(k_.vH,10);};var kH=0;var lH=0;var mH=-1;k_.yH=function yH(){k_.yH=zO;k_.xH=new k_.BH();};k_.zH=function zH(a){var b,c;if(a.a){c=null;do{b=a.a;a.a=null;c=k_.DH(b,c);}while(a.a);a.a=c;}};k_.AH=function AH(a){var b,c;if(a.b){c=null;do{b=a.b;a.b=null;c=k_.DH(b,c);}while(a.b);a.b=c;}};k_.BH=function BH(){};k_.CH=function CH(a,b){!a&&(a=j_.aH());j_.gH(a,b);return a;};k_.DH=function DH(b,c){var d,e,f,g;for(e=0,f=j_.fH(b);e<f;e++){g=j_.eH(b,e);try{k_.GH(g)?k_.EH(g).ec()&&(c=k_.CH(c,g)):k_.FH(g).ec();}catch(a){a=HN(a);if(VJ(a,17)){d=a;k_.nH();k_.tH(VJ(d,83)?d.Eb():d);}else throw IN(a);}}return c;};xO(182,189,{},k_.BH);h_.BL=jQ(182);k_.EH=function EH(a){return a[0];};k_.FH=function FH(a){return a[0];};k_.GH=function GH(a){return a[1];};v_.bI=function bI(a){return a.compatMode;};v_.cI=function cI(){return $doc;};w_.dI=function dI(){return ['USD','US$',2,'US$','$'];};w_.fI=function fI(){w_.fI=zO;w_.eI=new w_.hI();};w_.gI=function gI(a){!a.a&&(a.a=new x_.CI());return a.a;};w_.hI=function hI(){};xO(184,1,{},w_.hI);h_.GL=jQ(184);w_.iI=function iI(){w_.iI=zO;w_.gI((w_.fI(),w_.fI(),w_.eI));};w_.jI=function jI(a){};w_.kI=function kI(a,b){var c,d;b.a+='E';if(a.e<0){a.e=-a.e;b.a+='-';}c=''+a.e;for(d=n_.V$(c).length;d<a.k;++d){b.a+='0';}b.a+=c;};w_.lI=function lI(a,b,c){if(a.d==0){i_.iS(b,0,String.fromCharCode(48));++a.b;++a.d;}if(a.b<a.d||a.c){i_.iS(b,a.b,String.fromCharCode(c));++a.d;}};w_.mI=function mI(a,b){var c,d;c=a.b+a.n;if(a.d<c){while(a.d<c){b.a+='0';++a.d;}}else {d=a.b+a.i;d>a.d&&(d=a.d);while(d>c&&i_.AR(b.a,d-1)==48){--d;}if(d<a.d){i_.hS(b,d,a.d);a.d=d;}}};w_.nI=function nI(a,b){var c,d;d=0;while(d<a.d-1&&i_.AR(b.a,d)==48){++d;}if(d>0){b.a=i_.SR(b.a,0,0)+''+i_.RR(b.a,d);a.d-=d;a.e-=d;}if(a.j>a.o&&a.j>0){a.e+=a.b-1;c=a.e%a.j;c<0&&(c+=a.j);a.b=c+1;a.e-=c;}else {a.e+=a.b-a.o;a.b=a.o;}if(a.d==1&&i_.AR(b.a,0)==48){a.e=0;a.b=a.o;}};w_.oI=function oI(a,b){var c,d,e,f;if(isNaN(b)){return 'NaN';}d=b<0||b==0&&1/b<0;d&&(b=-b);c=new i_.jS();if(!isNaN(b)&&!isFinite(b)){i_.gS(c,d?a.q:a.t);c.a+='\u221E';i_.gS(c,d?a.r:a.u);return c.a;}b*=a.p;f=w_.BI(c,b);e=n_.V$(c.a).length+f+a.i+3;if(e>0&&e<n_.V$(c.a).length&&i_.AR(c.a,e)==57){w_.wI(a,c,e-1);f+=n_.V$(c.a).length-e;i_.hS(c,e,n_.V$(c.a).length);}w_.pI(a,d,c,f);return c.a;};w_.pI=function pI(a,b,c,d){var e,f,g,h,i;if(a.g){f=(n_.S$(0,n_.V$('.').length),n_.V$('.').charCodeAt(0));g=(n_.S$(0,n_.V$(',').length),n_.V$(',').charCodeAt(0));}else {f=(n_.S$(0,n_.V$('.').length),n_.V$('.').charCodeAt(0));g=(n_.S$(0,n_.V$(',').length),n_.V$(',').charCodeAt(0));}a.e=0;a.d=n_.V$(c.a).length;a.b=a.d+d;h=a.v;e=a.f;a.b>L0&&(h=true);h&&w_.nI(a,c);w_.vI(a,c);w_.xI(a,c);w_.qI(a,c,g,e);w_.mI(a,c);w_.lI(a,c,f);h&&w_.kI(a,c);i=(n_.S$(0,n_.V$('0').length),n_.V$('0').charCodeAt(0));i!=48&&w_.rI(c,i);i_.iS(c,0,b?a.q:a.t);i_.gS(c,b?a.r:a.u);};w_.qI=function qI(a,b,c,d){var e;if(d>0){for(e=d;e<a.b;e+=d+1){i_.iS(b,a.b-e,String.fromCharCode(c));++a.b;++a.d;}}};w_.rI=function rI(a,b){var c,d,e;e=n_.V$(a.a).length;for(d=0;d<e;++d){c=i_.AR(a.a,d);c>=48&&c<=57&&i_.zP(a,d,c-48+b&f0);}};w_.sI=function sI(a,b,c,d,e){var f,g,h,i;i_.hS(d,0,n_.V$(d.a).length);g=false;h=n_.V$(b).length;for(i=c;i<h;++i){f=(n_.S$(i,n_.V$(b).length),n_.V$(b).charCodeAt(i));if(f==39){if(i+1<h&&(n_.S$(i+1,n_.V$(b).length),n_.V$(b).charCodeAt(i+1)==39)){++i;d.a+="'";}else {g=!g;}continue;}if(g){d.a+=String.fromCharCode(f);}else {switch(f){case 35:case 48:case 44:case 46:case 59:return i-c;case 164:a.g=true;if(i+1<h&&(n_.S$(i+1,n_.V$(b).length),n_.V$(b).charCodeAt(i+1)==164)){++i;if(i<h-2&&(n_.S$(i+1,n_.V$(b).length),n_.V$(b).charCodeAt(i+1)==164)&&(n_.S$(i+2,n_.V$(b).length),n_.V$(b).charCodeAt(i+2)==164)){i+=2;i_.gS(d,y_.GI(a.a));}else {i_.gS(d,y_.DI(a.a));}}else {i_.gS(d,y_.EI(a.a));}break;case 37:if(!e){if(a.p!=1){throw IN(new i_._Q(f2+b+'"'));}a.p=100;}d.a+='%';break;case 8240:if(!e){if(a.p!=1){throw IN(new i_._Q(f2+b+'"'));}a.p=1000;}d.a+='\u2030';break;case 45:d.a+='-';break;default:d.a+=String.fromCharCode(f);}}}return h-c;};w_.tI=function tI(a,b){var c,d;d=0;c=new i_.jS();d+=w_.sI(a,b,d,c,false);a.t=c.a;d+=w_.uI(a,b,d,false);d+=w_.sI(a,b,d,c,false);a.u=c.a;if(d<n_.V$(b).length&&(n_.S$(d,n_.V$(b).length),n_.V$(b).charCodeAt(d)==59)){++d;d+=w_.sI(a,b,d,c,true);a.q=c.a;d+=w_.uI(a,b,d,true);d+=w_.sI(a,b,d,c,true);a.r=c.a;}else {a.q='-'+a.t;a.r=a.u;}};w_.uI=function uI(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p;f=-1;g=0;p=0;h=0;j=-1;k=n_.V$(b).length;n=c;l=true;for(;n<k&&l;++n){e=(n_.S$(n,n_.V$(b).length),n_.V$(b).charCodeAt(n));switch(e){case 35:p>0?++h:++g;j>=0&&f<0&&++j;break;case 48:if(h>0){throw IN(new i_._Q("Unexpected '0' in pattern \""+b+'"'));}++p;j>=0&&f<0&&++j;break;case 44:j=0;break;case 46:if(f>=0){throw IN(new i_._Q('Multiple decimal separators in pattern "'+b+'"'));}f=g+p+h;break;case 69:if(!d){if(a.v){throw IN(new i_._Q('Multiple exponential symbols in pattern "'+b+'"'));}a.v=true;a.k=0;}while(n+1<k&&(n_.S$(n+1,n_.V$(b).length),n_.V$(b).charCodeAt(n+1)==48)){++n;d||++a.k;}if(!d&&g+p<1||a.k<1){throw IN(new i_._Q('Malformed exponential pattern "'+b+'"'));}l=false;break;default:--n;l=false;}}if(p==0&&g>0&&f>=0){m=f;m==0&&++m;h=g-m;g=m-1;p=1;}if(f<0&&h>0||f>=0&&(f<g||f>g+p)||j==0){throw IN(new i_._Q('Malformed pattern "'+b+'"'));}if(d){return n-c;}o=g+p+h;a.i=f>=0?o-f:0;if(f>=0){a.n=g+p-f;a.n<0&&(a.n=0);}i=f>=0?f:o;a.o=i-g;if(a.v){a.j=g+a.o;a.i==0&&a.o==0&&(a.o=1);}a.f=j>0?j:0;a.c=f==0||f==o;return n-c;};w_.vI=function vI(a,b){var c,d,e;if(a.b>a.d){while(a.d<a.b){b.a+='0';++a.d;}}if(!a.v){if(a.b<a.o){d=new i_.jS();while(a.b<a.o){d.a+='0';++a.b;++a.d;}i_.iS(b,0,d.a);}else if(a.b>a.o){e=a.b-a.o;for(c=0;c<e;++c){if(i_.AR(b.a,c)!=48){e=c;break;}}if(e>0){b.a=i_.SR(b.a,0,0)+''+i_.RR(b.a,e);a.d-=e;a.b-=e;}}}};w_.wI=function wI(a,b,c){var d,e;d=true;while(d&&c>=0){e=i_.AR(b.a,c);if(e==57){i_.zP(b,c--,48);}else {i_.zP(b,c,e+1&f0);d=false;}}if(d){i_.iS(b,0,String.fromCharCode(49));++a.b;++a.d;}};w_.xI=function xI(a,b){var c;if(a.d>a.b+a.i&&i_.xP(b,a.b+a.i)>=53){c=a.b+a.i-1;w_.wI(a,b,c);}};w_.yI=function yI(a,b,c){w_.jI(this);if(!b){throw IN(new i_._Q('Unknown currency code'));}this.s=a;this.a=b;w_.tI(this,this.s);if(!c&&this.g){this.n=y_.FI(this.a)&7;this.i=this.n;}};w_.zI=function zI(a,b){w_.iI();w_.yI.call(this,a,b,true);};w_.AI=function AI(a,b){return a.toPrecision(b);};w_.BI=function BI(a,b){var c,d,e,f,g;g=n_.V$(a.a).length;i_.gS(a,w_.AI(b,20));f=0;e=i_.LR(a.a,'e',g);e<0&&(e=i_.LR(a.a,'E',g));if(e>=0){d=e+1;d<n_.V$(a.a).length&&i_.AR(a.a,d)==43&&++d;d<n_.V$(a.a).length&&(f=i_.CQ(i_.RR(a.a,d)));i_.hS(a,e,n_.V$(a.a).length);}c=i_.LR(a.a,'.',g);if(c>=0){a.a=i_.SR(a.a,0,c)+''+i_.RR(a.a,c+1);f-=n_.V$(a.a).length-c;}return f;};xO(129,1,{},w_.zI);_.b=0;_.c=false;_.d=0;_.e=0;_.f=3;_.g=false;_.i=3;_.j=40;_.k=0;_.n=0;_.o=1;_.p=1;_.q='-';_.r='';_.t='';_.u='';_.v=false;h_.HL=jQ(129);x_.CI=function CI(){};xO(186,1,{},x_.CI);h_.IL=jQ(186);y_.DI=function DI(a){return a[0];};y_.EI=function EI(a){return a[1];};y_.FI=function FI(a){return a[2];};y_.GI=function GI(a){return a[4]||a[1];};h_.$I=function $I(a){var b,c,d;b=a&v1;c=a>>22&v1;d=a<0?T_:0;return h_.aJ(b,c,d);};h_._I=function _I(a){return h_.aJ(h_.gJ(a),h_.hJ(a),h_.fJ(a));};h_.aJ=function aJ(a,b,c){return {l:a,m:b,h:c};};h_.bJ=function bJ(a,b,c){var d,e,f,g,h,i;if(h_.gJ(b)==0&&h_.hJ(b)==0&&h_.fJ(b)==0){throw IN(new i_.EP('divide by zero'));}if(h_.gJ(a)==0&&h_.hJ(a)==0&&h_.fJ(a)==0){c&&(h_.ZI=h_.aJ(0,0,0));return h_.aJ(0,0,0);}if(h_.fJ(b)==Z0&&h_.hJ(b)==0&&h_.gJ(b)==0){return h_.cJ(a,c);}i=false;if(h_.fJ(b)>>19!=0){b=h_.AJ(b);i=!i;}g=h_.lJ(b);f=false;e=false;d=false;if(h_.fJ(a)==Z0&&h_.hJ(a)==0&&h_.gJ(a)==0){e=true;f=true;if(g==-1){a=h_._I((h_.PJ(),h_.LJ));d=true;i=!i;}else {h=h_.EJ(a,g);i&&h_.jJ(h);c&&(h_.ZI=h_.aJ(0,0,0));return h;}}else if(h_.fJ(a)>>19!=0){f=true;a=h_.AJ(a);d=true;i=!i;}if(g!=-1){return h_.dJ(a,g,i,f,c);}if(h_.xJ(a,b)<0){c&&(f?h_.ZI=h_.AJ(a):h_.ZI=h_.aJ(h_.gJ(a),h_.hJ(a),h_.fJ(a)));return h_.aJ(0,0,0);}return h_.eJ(d?a:h_.aJ(h_.gJ(a),h_.hJ(a),h_.fJ(a)),b,i,f,e,c);};h_.cJ=function cJ(a,b){if(h_.fJ(a)==Z0&&h_.hJ(a)==0&&h_.gJ(a)==0){b&&(h_.ZI=h_.aJ(0,0,0));return h_._I((h_.PJ(),h_.NJ));}b&&(h_.ZI=h_.aJ(h_.gJ(a),h_.hJ(a),h_.fJ(a)));return h_.aJ(0,0,0);};h_.dJ=function dJ(a,b,c,d,e){var f;f=h_.EJ(a,b);c&&h_.jJ(f);if(e){a=h_.iJ(a,b);d?h_.ZI=h_.AJ(a):h_.ZI=h_.aJ(h_.gJ(a),h_.hJ(a),h_.fJ(a));}return f;};h_.eJ=function eJ(a,b,c,d,e,f){var g,h,i,j;j=h_.kJ(b)-h_.kJ(a);g=h_.DJ(b,j);i=h_.aJ(0,0,0);while(j>=0){h=h_.uJ(a,g);if(h){j<22?h_.nJ(i,j):j<44?h_.oJ(i,j-22):h_.mJ(i,j-44);if(h_.gJ(a)==0&&h_.hJ(a)==0&&h_.fJ(a)==0){break;}}h_.tJ(g);--j;}c&&h_.jJ(i);if(f){if(d){h_.ZI=h_.AJ(a);e&&(h_.ZI=h_.GJ(h_.ZI,(h_.PJ(),h_.NJ)));}else {h_.ZI=h_.aJ(h_.gJ(a),h_.hJ(a),h_.fJ(a));}}return i;};h_.fJ=function fJ(a){return a.h;};h_.gJ=function gJ(a){return a.l;};h_.hJ=function hJ(a){return a.m;};h_.iJ=function iJ(a,b){var c,d,e;if(b<=22){c=h_.gJ(a)&(1<<b)-1;d=e=0;}else if(b<=44){c=h_.gJ(a);d=h_.hJ(a)&(1<<b-22)-1;e=0;}else {c=h_.gJ(a);d=h_.hJ(a);e=h_.fJ(a)&(1<<b-44)-1;}return h_.aJ(c,d,e);};h_.jJ=function jJ(a){var b,c,d;b=~h_.gJ(a)+1&v1;c=~h_.hJ(a)+(b==0?1:0)&v1;d=~h_.fJ(a)+(b==0&&c==0?1:0)&T_;h_.qJ(a,b);h_.rJ(a,c);h_.pJ(a,d);};h_.kJ=function kJ(a){var b,c;c=jR(h_.fJ(a));if(c==32){b=jR(h_.hJ(a));return b==32?jR(h_.gJ(a))+32:b+20-10;}else {return c-12;}};h_.lJ=function lJ(a){var b,c,d;c=h_.gJ(a);if((c&c-1)!=0){return -1;}d=h_.hJ(a);if((d&d-1)!=0){return -1;}b=h_.fJ(a);if((b&b-1)!=0){return -1;}if(b==0&&d==0&&c==0){return -1;}if(b==0&&d==0&&c!=0){return kR(c);}if(b==0&&d!=0&&c==0){return kR(d)+22;}if(b!=0&&d==0&&c==0){return kR(b)+44;}return -1;};h_.mJ=function mJ(a,b){a.h|=1<<b;};h_.nJ=function nJ(a,b){a.l|=1<<b;};h_.oJ=function oJ(a,b){a.m|=1<<b;};h_.pJ=function pJ(a,b){a.h=b;};h_.qJ=function qJ(a,b){a.l=b;};h_.rJ=function rJ(a,b){a.m=b;};h_.sJ=function sJ(a){return h_.gJ(a)+h_.hJ(a)*S_+h_.fJ(a)*R_;};h_.tJ=function tJ(a){var b,c,d;c=h_.hJ(a);d=h_.fJ(a);b=h_.gJ(a);h_.pJ(a,d>>>1);h_.rJ(a,c>>>1|(d&1)<<21);h_.qJ(a,b>>>1|(c&1)<<21);};h_.uJ=function uJ(a,b){var c,d,e;e=h_.fJ(a)-h_.fJ(b);if(e<0){return false;}c=h_.gJ(a)-h_.gJ(b);d=h_.hJ(a)-h_.hJ(b)+(c>>22);e+=d>>22;if(e<0){return false;}h_.qJ(a,c&v1);h_.rJ(a,d&v1);h_.pJ(a,e&T_);return true;};h_.vJ=function vJ(a,b){var c,d,e;c=h_.gJ(a)+h_.gJ(b);d=h_.hJ(a)+h_.hJ(b)+(c>>22);e=h_.fJ(a)+h_.fJ(b)+(d>>22);return h_.aJ(c&v1,d&v1,e&T_);};h_.wJ=function wJ(a,b){return h_.aJ(h_.gJ(a)&h_.gJ(b),h_.hJ(a)&h_.hJ(b),h_.fJ(a)&h_.fJ(b));};h_.xJ=function xJ(a,b){var c,d,e,f,g,h,i,j;i=h_.fJ(a)>>19;j=h_.fJ(b)>>19;if(i!=j){return j-i;}e=h_.fJ(a);h=h_.fJ(b);if(e!=h){return e-h;}d=h_.hJ(a);g=h_.hJ(b);if(d!=g){return d-g;}c=h_.gJ(a);f=h_.gJ(b);return c-f;};h_.yJ=function yJ(a){var b,c,d,e,f;if(isNaN(a)){return h_.PJ(),h_.OJ;}if(a<-9223372036854775808){return h_.PJ(),h_.MJ;}if(a>=9223372036854775807){return h_.PJ(),h_.LJ;}e=false;if(a<0){e=true;a=-a;}d=0;if(a>=R_){d=cK(a/R_);a-=d*R_;}c=0;if(a>=S_){c=cK(a/S_);a-=c*S_;}b=cK(a);f=h_.aJ(b,c,d);e&&h_.jJ(f);return f;};h_.zJ=function zJ(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G;c=h_.gJ(a)&8191;d=h_.gJ(a)>>13|(h_.hJ(a)&15)<<9;e=h_.hJ(a)>>4&8191;f=h_.hJ(a)>>17|(h_.fJ(a)&255)<<5;g=(h_.fJ(a)&1048320)>>8;h=h_.gJ(b)&8191;i=h_.gJ(b)>>13|(h_.hJ(b)&15)<<9;j=h_.hJ(b)>>4&8191;k=h_.hJ(b)>>17|(h_.fJ(b)&255)<<5;l=(h_.fJ(b)&1048320)>>8;B=c*h;C=d*h;D=e*h;F=f*h;G=g*h;if(i!=0){C+=c*i;D+=d*i;F+=e*i;G+=f*i;}if(j!=0){D+=c*j;F+=d*j;G+=e*j;}if(k!=0){F+=c*k;G+=d*k;}l!=0&&(G+=c*l);n=B&v1;o=(C&511)<<13;m=n+o;q=B>>22;r=C>>9;s=(D&262143)<<4;t=(F&31)<<17;p=q+r+s+t;v=D>>18;w=F>>5;A=(G&4095)<<8;u=v+w+A;p+=m>>22;m&=v1;u+=p>>22;p&=v1;u&=T_;return h_.aJ(m,p,u);};h_.AJ=function AJ(a){var b,c,d;b=~h_.gJ(a)+1&v1;c=~h_.hJ(a)+(b==0?1:0)&v1;d=~h_.fJ(a)+(b==0&&c==0?1:0)&T_;return h_.aJ(b,c,d);};h_.BJ=function BJ(a){return h_.aJ(~h_.gJ(a)&v1,~h_.hJ(a)&v1,~h_.fJ(a)&T_);};h_.CJ=function CJ(a,b){return h_.aJ(h_.gJ(a)|h_.gJ(b),h_.hJ(a)|h_.hJ(b),h_.fJ(a)|h_.fJ(b));};h_.DJ=function DJ(a,b){var c,d,e;b&=63;if(b<22){c=h_.gJ(a)<<b;d=h_.hJ(a)<<b|h_.gJ(a)>>22-b;e=h_.fJ(a)<<b|h_.hJ(a)>>22-b;}else if(b<44){c=0;d=h_.gJ(a)<<b-22;e=h_.hJ(a)<<b-22|h_.gJ(a)>>44-b;}else {c=0;d=0;e=h_.gJ(a)<<b-44;}return h_.aJ(c&v1,d&v1,e&T_);};h_.EJ=function EJ(a,b){var c,d,e,f,g;b&=63;c=h_.fJ(a);d=(c&Z0)!=0;d&&(c|=-1048576);if(b<22){g=c>>b;f=h_.hJ(a)>>b|c<<22-b;e=h_.gJ(a)>>b|h_.hJ(a)<<22-b;}else if(b<44){g=d?T_:0;f=c>>b-22;e=h_.hJ(a)>>b-22|c<<44-b;}else {g=d?T_:0;f=d?v1:0;e=c>>b-44;}return h_.aJ(e&v1,f&v1,g&T_);};h_.FJ=function FJ(a,b){var c,d,e,f;b&=63;c=h_.fJ(a)&T_;if(b<22){f=c>>>b;e=h_.hJ(a)>>b|c<<22-b;d=h_.gJ(a)>>b|h_.hJ(a)<<22-b;}else if(b<44){f=0;e=c>>>b-22;d=h_.hJ(a)>>b-22|h_.fJ(a)<<44-b;}else {f=0;e=0;d=c>>>b-44;}return h_.aJ(d&v1,e&v1,f&T_);};h_.GJ=function GJ(a,b){var c,d,e;c=h_.gJ(a)-h_.gJ(b);d=h_.hJ(a)-h_.hJ(b)+(c>>22);e=h_.fJ(a)-h_.fJ(b)+(d>>22);return h_.aJ(c&v1,d&v1,e&T_);};h_.HJ=function HJ(a){if(h_.xJ(a,(h_.PJ(),h_.OJ))<0){return -h_.sJ(h_.AJ(a));}return h_.gJ(a)+h_.hJ(a)*S_+h_.fJ(a)*R_;};h_.IJ=function IJ(a){return h_.gJ(a)|h_.hJ(a)<<22;};h_.JJ=function JJ(a){var b,c,d,e,f;if(h_.gJ(a)==0&&h_.hJ(a)==0&&h_.fJ(a)==0){return '0';}if(h_.fJ(a)==Z0&&h_.hJ(a)==0&&h_.gJ(a)==0){return '-9223372036854775808';}if(h_.fJ(a)>>19!=0){return '-'+h_.JJ(h_.AJ(a));}c=a;d='';while(!(h_.gJ(c)==0&&h_.hJ(c)==0&&h_.fJ(c)==0)){e=h_.$I(g2);c=h_.bJ(c,e,true);b=''+h_.IJ(h_.ZI);if(!(h_.gJ(c)==0&&h_.hJ(c)==0&&h_.fJ(c)==0)){f=9-n_.V$(b).length;for(;f>0;f--){b='0'+b;}}d=b+d;}return d;};h_.KJ=function KJ(a,b){return h_.aJ(h_.gJ(a)^h_.gJ(b),h_.hJ(a)^h_.hJ(b),h_.fJ(a)^h_.fJ(b));};h_.PJ=function PJ(){h_.PJ=zO;h_.LJ=h_.aJ(v1,v1,524287);h_.MJ=h_.aJ(0,0,Z0);h_.NJ=h_.$I(1);h_.$I(2);h_.OJ=h_.$I(0);};function GO(){z_.HO();}z_.HO=function HO(){var a,b,c;b=v_.bI(v_.cI());a=XI(II(h_.uM,1),d0,2,6,[h2]);for(c=0;c<a.length;c++){if(i_.GR(a[c],b)){return;}}a.length==1&&i_.GR(h2,a[0])&&i_.GR('BackCompat',b)?"GWT no longer supports Quirks Mode (document.compatMode=' BackCompat').<br>Make sure your application's host HTML page has a Standards Mode (document.compatMode=' CSS1Compat') doctype,<br>e.g. by using &lt;!doctype html&gt; at the start of your application's HTML page.<br><br>To continue using this unsupported rendering mode and risk layout problems, suppress this message by adding<br>the following line to your*.gwt.xml module file:<br>&nbsp;&nbsp;&lt;extend-configuration-property name=\"document.compatMode\" value=\""+b+'"/&gt;':"Your *.gwt.xml module configuration prohibits the use of the current document rendering mode (document.compatMode=' "+b+"').<br>Modify your application's host HTML page doctype, or update your custom "+"'document.compatMode' configuration property settings.";};A_.MO=function MO(){A_.MO=zO;A_.LO=new A_.RO(255,255,255);A_.IO=A_.LO;A_.KO=new A_.RO(128,128,128);A_.JO=new A_.RO(0,0,0);};A_.NO=function NO(a){};A_.OO=function OO(a){var b;b=OI(h_.gK,f1,5,4,15,1);if(a.b==null){b[0]=(a.c>>16&255)/255;b[1]=(a.c>>8&255)/255;b[2]=(a.c&255)/255;b[3]=(a.c>>24&255)/255;}else {b[0]=a.b[0];b[1]=a.b[1];b[2]=a.b[2];b[3]=a.a;}return b;};A_.PO=function PO(a,b,c,d){A_.MO();A_.SO.call(this,cK(a*255+0.5),cK(b*255+0.5),cK(c*255+0.5),cK(d*255+0.5));this.b=OI(h_.gK,f1,5,3,15,1);this.b[0]=a;this.b[1]=b;this.b[2]=c;this.a=d;};A_.QO=function QO(a){A_.MO();A_.NO(this);this.c=g1|a;};A_.RO=function RO(a,b,c){A_.MO();A_.SO.call(this,a,b,c,255);};A_.SO=function SO(a,b,c,d){A_.NO(this);this.c=(d&255)<<24|(a&255)<<16|(b&255)<<8|c&255;};A_.TO=function TO(a,b,c,d){A_.MO();var e,f,g,h,i,j;g=0;j=0;e=0;i=$wnd.Math.min(a,$wnd.Math.min(b,c));h=$wnd.Math.max(a,$wnd.Math.max(b,c));e=h;f=h-i;if(f==0){e=i;g=0;d[0]=g;d[1]=j;d[2]=e;return d;}if(h!=0)j=f/h;else {j=0;g=0;d[0]=g;d[1]=j;d[2]=e;return d;}a==h?g=(b-c)/f:b==h?g=2+(c-a)/f:g=4+(a-b)/f;g*=60;g<0&&(g+=360);d[0]=g/360;d[1]=j;d[2]=e;return d;};xO(27,1,{},A_.PO,A_.QO,A_.RO);_.a=0;_.b=null;_.c=0;h_.JL=jQ(27);A_.WO=function WO(){A_.WO=zO;A_.VO=XI(II(h_.fK,1),B0,5,15,[5.55,15,15,15,15,15,15,15,15,i2,i2,i2,i2,i2,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,i2,i2,7.1,j2,j2,17.78,k2,3.82,6.66,6.66,7.78,11.68,i2,6.66,i2,i2,j2,j2,j2,j2,j2,j2,j2,j2,j2,j2,i2,i2,11.68,11.68,11.68,j2,20.3,k2,k2,l2,l2,k2,12.22,15.56,l2,i2,10,k2,j2,16.66,l2,15.56,k2,15.56,l2,k2,12.22,l2,k2,18.88,k2,k2,12.22,i2,i2,i2,9.38,j2,6.66,j2,j2,10,j2,j2,i2,j2,j2,4.44,4.44,10,4.44,16.66,j2,j2,j2,j2,6.66,10,i2,j2,10,l2,10,10,10,6.68,5.2,6.68,11.68,10.5]);};A_.XO=function XO(a,b){var c,d,e,f,g;if(i_.GR(a.a,'Helvetica')){f=0;for(d=0,e=n_.V$(b).length;d<e;d++){c=(n_.S$(d,n_.V$(b).length),n_.V$(b).charCodeAt(d));f+=(c<128?g=A_.VO[c]:g=i2,g*a.b/20);}return f;}else {return A_.YO(a,b);}};A_.YO=function YO(e,a){var b=A_.UO;if(!b){b=$doc.createElement('canvas');A_.UO=b;}var c=''+e.b+'px '+e.a;var d=b.getContext('2d');d.font=c;var a=d.measureText(a);return a.width;};A_.ZO=function ZO(a){A_.WO();this.a='Helvetica';this.b=a;};xO(124,1,{},A_.ZO);_.b=0;A_.UO=null;h_.KL=jQ(124);xO(116,1,{116:1});_.gb=function $O(a){var b;if(this===a)return true;if(VJ(a,43)){b=a;return this.a==b.a&&this.b==b.b;}return this===a;};_.ib=function _O(){var a;a=this.a+this.b;return cK(a)*37;};h_.ML=jQ(116);B_.aP=function aP(){};B_.bP=function bP(a,b){this.a=a;this.b=b;};xO(43,116,{116:1,43:1,4:1},B_.aP,B_.bP);_.a=0;_.b=0;h_.LL=jQ(43);B_.cP=function cP(a,b){return B_.fP(a,b.c,b.d,b.b,b.a);};B_.dP=function dP(a,b,c,d,e){var f;if(d<b){f=b;b=d;d=f;}if(e<c){f=c;c=e;e=f;}B_.kP(a,b,c,d-b,e-c);};xO(91,1,{144:1,91:1});h_.PL=jQ(91);B_.eP=function eP(a,b,c){var d,e;d=a.c;e=a.d;return b>=d&&c>=e&&b<d+a.b&&c<e+a.a;};B_.fP=function fP(a,b,c,d,e){var f,g;if(a.b<=0||a.a<=0||d<=0||e<=0){return false;}f=a.c;g=a.d;return b>=f&&c>=g&&b+d<=f+a.b&&c+e<=g+a.a;};B_.iP=function iP(a,b,c){var d,e,f,g;d=$wnd.Math.min(a.c,b.c);f=$wnd.Math.min(a.d,b.d);e=$wnd.Math.max(a.c+a.b,b.c+b.b);g=$wnd.Math.max(a.d+a.a,b.d+b.a);B_.dP(c,d,f,e,g);};xO(106,91,{144:1,106:1,91:1});_.gb=function gP(a){var b;if(a===this){return true;}if(VJ(a,21)){b=a;return this.c==b.c&&this.d==b.d&&this.b==b.b&&this.a==b.a;}return false;};_.ib=function hP(){var a;a=KQ(this.c);a=JN(a,aO(KQ(this.d),37));a=JN(a,aO(KQ(this.b),43));a=JN(a,aO(KQ(this.a),47));return kO(a)^kO(fO(a,32));};h_.OL=jQ(106);B_.jP=function jP(a,b){var c;c=new B_.lP();B_.iP(a,b,c);return c;};B_.kP=function kP(a,b,c,d,e){a.c=b;a.d=c;a.b=d;a.a=e;};B_.lP=function lP(){};B_.mP=function mP(a,b,c,d){B_.kP(this,a,b,c,d);};xO(21,106,{144:1,106:1,21:1,91:1},B_.lP,B_.mP);_.a=0;_.b=0;_.c=0;_.d=0;h_.NL=jQ(21);xO(210,1,{});h_.UL=jQ(210);C_.nP=function nP(a){var b;b=-1;if(a.a!=-2){b=a.a;a.a=-2;}else {b=C_.sP(a.b);}return b;};C_.oP=function oP(a){var b,c,d;c=C_.nP(a);if(c==-1)return null;d=new i_.jS();b=false;while(!b){if(c==10){b=true;}else if(c==13){b=true;c=C_.nP(a);c!=10&&(a.a=c);}if(!b){if(c==-1){break;}i_.cS(d,c&f0);c=C_.nP(a);}}return d.a;};C_.pP=function pP(a){this.b=a;this.a=-2;};xO(51,210,{},C_.pP);_.a=0;h_.QL=jQ(51);xO(191,1,{});h_.SL=jQ(191);xO(190,191,{});h_.RL=jQ(190);C_.qP=function qP(){};xO(138,190,{},C_.qP);h_.TL=jQ(138);C_.sP=function sP(a){return a.a==n_.V$(a.b).length?-1:i_.AR(a.b,a.a++);};C_.tP=function tP(a){this.b=a;this.a=0;};xO(50,210,{},C_.tP);_.a=0;h_.VL=jQ(50);xO(211,1,{});h_.XL=jQ(211);C_.uP=function uP(a,b){i_.$R(a.a,b);};C_.vP=function vP(){this.a=new i_._R();};xO(120,211,{},C_.vP);_.jb=function wP(){return this.a.a;};h_.WL=jQ(120);i_.xP=function xP(a,b){return i_.AR(a.a,b);};i_.yP=function yP(a,b,c,d){a.a=i_.SR(a.a,0,b)+(''+d)+i_.RR(a.a,c);};i_.zP=function zP(a,b,c){i_.yP(a,b,b+1,String.fromCharCode(c));};i_.AP=function AP(a){var b;b=n_.V$(a.a).length;0<b?a.a=i_.SR(a.a,0,0):0>b&&(a.a+=i_.XR(OI(h_.eK,f1,5,-b,15,1)));};i_.BP=function BP(a){return a.a;};i_.CP=function CP(a){this.a=a;};xO(61,1,{104:1});_.jb=function DP(){return i_.BP(this);};h_.YL=jQ(61);i_.EP=function EP(a){i_.HG.call(this,a);};xO(66,20,Y_,i_.EP);h_.ZL=jQ(66);function UP(a){if(!a){throw IN(new i_.$Q());}}function VP(a,b,c){var d,e;d=i_.AR(a,b++);if(d>=55296&&d<=56319&&b<c&&ZP(e=(n_.S$(b,n_.V$(a).length),n_.V$(a).charCodeAt(b)))){return e0+((d&1023)<<10)+(e&1023);}return d;}function WP(a){if(a>=48&&a<48+$wnd.Math.min(10,10)){return a-48;}if(a>=97&&a<97){return a-97+10;}if(a>=65&&a<65){return a-65+10;}return -1;}function XP(a){return null!=String.fromCharCode(a).match(/\d/);}function YP(a){return null!=String.fromCharCode(a).match(/[A-Z]/i);}function ZP(a){return a>=56320&&a<=57343;}function $P(a,b,c){UP(a>=0&&a<=1114111);if(a>=e0){b[c++]=55296+(a-e0>>10&1023)&f0;b[c]=56320+(a-e0&1023)&f0;return 2;}else {b[c]=a&f0;return 1;}}function _P(a){return String.fromCharCode(a).toLowerCase().charCodeAt(0);}i_.NQ=function NQ(){i_.NQ=zO;i_.MQ=XI(II(h_.fK,1),B0,5,15,[1.3407807929942597E154,1.157920892373162E77,3.4028236692093846E38,1.8446744073709552E19,m2,e0,256,16,4,2]);i_.LQ=XI(II(h_.fK,1),B0,5,15,[7.458340731200207E-155,8.636168555094445E-78,2.9387358770557188E-39,5.421010862427522E-20,2.3283064365386963E-10,n2,0.00390625,0.0625,0.25,0.5]);};function ZQ(a){var b;b=i_.BQ(a);if(b>N1){return Infinity;}else if(b<-3.4028234663852886E38){return -Infinity;}return b;}i_.pR=function pR(){i_.pR=zO;i_.oR=OI(h_.hM,V_,36,256,0,1);};i_.qR=function qR(a){i_.HG.call(this,a);};xO(183,20,Y_,i_.qR);h_.jM=jQ(183);i_.vR=function vR(a){i_._Q.call(this,a);};xO(42,26,Y_,i_.vR);h_.lM=jQ(42);i_.wR=function wR(a,b,c){this.a=L_;this.d=a;this.b=b;this.c=c;};xO(49,1,{4:1,49:1},i_.wR);_.gb=function xR(a){var b;if(VJ(a,49)){b=a;return this.c==b.c&&this.d==b.d&&this.a==b.a&&this.b==b.b;}return false;};_.ib=function yR(){return l_.YW(XI(II(h_.nM,1),W_,1,5,[i_.nR(this.c),this.a,this.d,this.b]));};_.jb=function zR(){return this.a+'.'+this.d+'('+(this.b!=null?this.b:'Unknown Source')+(this.c>=0?':'+this.c:'')+')';};_.c=0;h_.pM=jQ(49);i_.ZR=function ZR(a,b){a.a+=b;return a;};i_.$R=function $R(a,b){a.a+=''+b;return a;};i_._R=function _R(){i_.CP.call(this,'');};i_.aS=function aS(){i_.CP.call(this,'');};i_.bS=function bS(a){i_.CP.call(this,(n_.M$(a),a));};xO(45,61,{104:1},i_._R,i_.aS,i_.bS);h_.qM=jQ(45);i_.cS=function cS(a,b){a.a+=String.fromCharCode(b);return a;};i_.dS=function dS(a,b){a.a+=b;return a;};i_.eS=function eS(a,b){a.a+=b;return a;};i_.fS=function fS(a,b){a.a+=''+b;return a;};i_.gS=function gS(a,b){a.a+=''+b;return a;};i_.hS=function hS(a,b,c){a.a=i_.SR(a.a,0,b)+''+i_.RR(a.a,c);return a;};i_.iS=function iS(a,b,c){a.a=i_.SR(a.a,0,b)+(''+c)+i_.RR(a.a,b);return a;};i_.jS=function jS(){i_.CP.call(this,'');};i_.kS=function kS(){i_.CP.call(this,'');};i_.lS=function lS(a){i_.CP.call(this,(n_.M$(a),a));};xO(22,61,{104:1},i_.jS,i_.kS,i_.lS);h_.rM=jQ(22);i_.oS=function oS(){i_.oS=zO;i_.nS=new C_.qP();};i_.pS=function pS(a,b,c,d,e){i_.oS();var f,g;n_.N$(a,'src');n_.N$(c,'dest');i_.yc(a);i_.yc(c);g=n_.V$(a).length;f=n_.V$(c).length;if(b<0||d<0||e<0||b+e>g||d+e>f){throw IN(new i_.FP());}e>0&&n_.v$(a,b,c,d,e,true);};xO(260,1,{});D_.BS=function BS(){D_.BS=zO;var a,b,c;new D_.KS(1,0);new D_.KS(10,0);new D_.KS(0,0);D_.tS=OI(h_.yM,V_,12,11,0,1);D_.uS=OI(h_.eK,f1,5,100,15,1);D_.vS=XI(II(h_.fK,1),B0,5,15,[1,5,25,125,625,3125,15625,78125,390625,1953125,9765625,48828125,244140625,1220703125,6103515625,30517578125,152587890625,762939453125,3814697265625,19073486328125,95367431640625,476837158203125,2384185791015625]);D_.wS=OI(h_.hK,k0,5,D_.vS.length,15,1);D_.xS=XI(II(h_.fK,1),B0,5,15,[1,10,100,1000,g0,100000,1000000,10000000,100000000,g2,10000000000,100000000000,1000000000000,10000000000000,100000000000000,1000000000000000,10000000000000000]);D_.yS=OI(h_.hK,k0,5,D_.xS.length,15,1);D_.zS=OI(h_.yM,V_,12,11,0,1);a=0;for(;a<D_.zS.length;a++){D_.tS[a]=new D_.KS(h_.SN(a),0);D_.zS[a]=new D_.KS(0,a);D_.uS[a]=48;}for(;a<D_.uS.length;a++){D_.uS[a]=48;}for(c=0;c<D_.wS.length;c++){D_.wS[c]=D_.NS(D_.vS[c]);}for(b=0;b<D_.yS.length;b++){D_.yS[b]=D_.NS(D_.xS[b]);}D_.iU();};D_.CS=function CS(a,b){var c,d,e,f,g,h;e=D_.GS(a);h=D_.GS(b);if(e==h){if(a.e==b.e&&a.a<54&&b.a<54){return a.f<b.f?-1:a.f>b.f?1:0;}d=a.e-b.e;c=(a.d>0?a.d:$wnd.Math.floor((a.a-1)*o2)+1)-(b.d>0?b.d:$wnd.Math.floor((b.a-1)*o2)+1);if(c>d+1){return e;}else if(c<d-1){return -e;}else {f=(!a.c&&(a.c=D_.FT(a.f)),a.c);g=(!b.c&&(b.c=D_.FT(b.f)),b.c);d<0?f=D_.kT(f,D_.rU(-d)):d>0&&(g=D_.kT(g,D_.rU(d)));return D_.dT(f,g);}}else return e<h?-1:1;};D_.DS=function DS(a,b){var c,d,e,f,g,h,i,j;c=0;g=0;f=n_.V$(b).length;h=null;j=(n_.V$(b),new i_.kS());if(g<f&&(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)==43)){++g;++c;if(g<f&&(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)==43||(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)==45))){throw IN(new i_.vR(Z_+b+'"'));}}while(g<f&&(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)!=46)&&(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)!=101)&&(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)!=69)){++g;}j.a+=''+i_.SR(b==null?X_:(n_.M$(b),b),c,g);if(g<f&&(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)==46)){++g;c=g;while(g<f&&(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)!=101)&&(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)!=69)){++g;}a.e=g-c;j.a+=''+i_.SR(b==null?X_:(n_.M$(b),b),c,g);}else {a.e=0;}if(g<f&&(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)==101||(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)==69))){++g;c=g;if(g<f&&(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)==43)){++g;g<f&&(n_.S$(g,n_.V$(b).length),n_.V$(b).charCodeAt(g)!=45)&&++c;}h=n_.V$(b).substr(c,f-c);a.e=a.e-i_.CQ(h);if(a.e!=cK(a.e)){throw IN(new i_.vR('Scale out of range.'));}}i=j.a;if(n_.V$(i).length<16){a.f=(D_.AS==null&&(D_.AS=new RegExp('^[+-]?\\d*$','i')),D_.AS.test(i)?parseInt(i,10):NaN);if(isNaN(a.f)){throw IN(new i_.vR(Z_+b+'"'));}a.a=D_.NS(a.f);}else {D_.FS(a,new D_.wT(i));}a.d=n_.V$(j.a).length;for(e=0;e<n_.V$(j.a).length;++e){d=i_.AR(j.a,e);if(d!=45&&d!=48){break;}--a.d;}a.d==0&&(a.d=1);};D_.ES=function ES(a,b){var c;n_.M$(b);c=2-a.e;if(c==0){return a;}if(c>0){if(c<D_.xS.length&&a.a+D_.yS[cK(c)]<54){return new D_.JS(a.f*D_.xS[cK(c)]);}return new D_.MS(D_.oU((!a.c&&(a.c=D_.FT(a.f)),a.c),cK(c)));}if(a.a<54&&-c<D_.xS.length){return D_.RS(a.f,D_.xS[cK(-c)],b);}return D_.QS((!a.c&&(a.c=D_.FT(a.f)),a.c),D_.rU(-c),b);};D_.FS=function FS(a,b){var c;a.c=b;a.a=D_.HT(b);a.a<54&&(a.f=(c=b.d>1?dO(eO(WN(b.a[1]),32),KN(WN(b.a[0]),p2)):KN(WN(b.a[0]),p2),jO(aO(WN(b.e),c))));};D_.GS=function GS(a){if(a.a<54){return a.f<0?-1:a.f>0?1:0;}return (!a.c&&(a.c=D_.FT(a.f)),a.c).e;};D_.HS=function HS(a){var b,c,d,e,f;if(a.g!=null){return a.g;}if(a.a<32){a.g=D_.ST(VN(a.f),cK(a.e));return a.g;}e=D_.TT((!a.c&&(a.c=D_.FT(a.f)),a.c),0);if(a.e==0){return e;}b=(!a.c&&(a.c=D_.FT(a.f)),a.c).e<0?2:1;c=n_.V$(e).length;d=-a.e+c-b;f=new i_.jS();f.a+=''+e;if(a.e>0&&d>=-6){if(d>=0){i_.iS(f,c-cK(a.e),String.fromCharCode(46));}else {f.a=i_.SR(f.a,0,b-1)+'0.'+i_.RR(f.a,b-1);i_.iS(f,b+1,i_.YR(D_.uS,0,-cK(d)-1));}}else {if(c-b>=1){i_.iS(f,b,String.fromCharCode(46));++c;}i_.iS(f,c,String.fromCharCode(69));d>0&&i_.iS(f,++c,String.fromCharCode(43));i_.iS(f,++c,''+lO(VN(d)));}a.g=f.a;return a.g;};D_.IS=function IS(a){D_.BS();var b;if(!isNaN(a)&&!isFinite(a)||isNaN(a)){throw IN(new i_.vR('Infinite or NaN'));}D_.DS(this,(b=n_.V$(a),b.toPrecision(20)));};D_.JS=function JS(a){this.f=a;this.e=2;this.a=D_.NS(a);};D_.KS=function KS(a,b){this.e=b;this.a=D_.OS(a);this.a<54?this.f=jO(a):this.c=D_.GT(a);};D_.LS=function LS(a){this.e=2;D_.FS(this,(n_.M$(a),a));};D_.MS=function MS(a){D_.LS.call(this,a);};D_.NS=function NS(a){var b,c;if(a>-140737488355328&&a<140737488355328){if(a==0){return 0;}b=a<0;b&&(a=-a);c=cK($wnd.Math.floor($wnd.Math.log(a)/0.6931471805599453));(!b||a!=$wnd.Math.pow(2,c))&&++c;return c;}return D_.OS(VN(a));};D_.OS=function OS(a){var b;PN(a,0)<0&&(a=h_.RN(h_.BJ(h_.YN(a)?h_.iO(h_.NN(a)):h_.LN(a))));return b=kO(fO(a,32)),64-(b!=0?jR(b):jR(kO(a))+32);};D_.QS=function QS(a,b,c){var d,e,f,g,h,i,j,k,l;f=D_.fT(a,b);g=f[0];i=f[1];if(i.e==0){return new D_.MS(g);}j=a.e*b.e;if(D_.HT(b)<54){h=(l=i.d>1?dO(eO(WN(i.a[1]),32),KN(WN(i.a[0]),p2)):KN(WN(i.a[0]),p2),aO(WN(i.e),l));e=(k=b.d>1?dO(eO(WN(b.a[1]),32),KN(WN(b.a[0]),p2)):KN(WN(b.a[0]),p2),aO(WN(b.e),k));d=ZN(eO(PN(h,0)<0?bO(h):h,1),PN(e,0)<0?bO(e):e)?-1:XN(eO(PN(h,0)<0?bO(h):h,1),PN(e,0)<0?bO(e):e)?1:0;d=D_.US(D_.pT(g,0)?1:0,j*(5+d),c);}else {d=D_.dT(D_.nT(i.e<0?new D_.tT(1,i.d,i.a):i),b.e<0?new D_.tT(1,b.d,b.a):b);d=D_.US(D_.pT(g,0)?1:0,j*(5+d),c);}if(d!=0){if(D_.HT(g)<54){return D_.WS((k=g.d>1?dO(eO(WN(g.a[1]),32),KN(WN(g.a[0]),p2)):KN(WN(g.a[0]),p2),JN(aO(WN(g.e),k),h_.SN(d))));}g=D_.ZT(g,D_.GT(h_.SN(d)));return new D_.MS(g);}return new D_.MS(g);};D_.RS=function RS(a,b,c){var d,e,f,g,h;f=(e=a/b,e>0?$wnd.Math.floor(e):$wnd.Math.ceil(e));g=a%b;h=JQ(a*b,0);if(g!=0){d=JQ($wnd.Math.abs(g)*2,$wnd.Math.abs(b));f+=D_.US(cK(f)&1,h*(5+d),c);}return new D_.JS(f);};D_.US=function US(a,b,c){var d;d=0;switch(c.b){case 7:if(b!=0){throw IN(new i_.EP('Rounding necessary'));}break;case 0:d=b==0?0:b<0?-1:1;break;case 2:d=$wnd.Math.max(b==0?0:b<0?-1:1,0);break;case 3:d=$wnd.Math.min(b==0?0:b<0?-1:1,0);break;case 4:$wnd.Math.abs(b)>=5&&(d=b==0?0:b<0?-1:1);break;case 5:$wnd.Math.abs(b)>5&&(d=b==0?0:b<0?-1:1);break;case 6:$wnd.Math.abs(b)+a>5&&(d=b==0?0:b<0?-1:1);}return d;};D_.WS=function WS(a){if(PN(a,0)==0&&2<D_.zS.length){return D_.zS[2];}return new D_.KS(a,2);};xO(12,73,{4:1,30:1,73:1,12:1},D_.IS,D_.JS,D_.KS,D_.MS);_.lb=function PS(a){return D_.CS(this,a);};_.gb=function SS(a){var b;if(this===a){return true;}if(VJ(a,12)){b=a;return this.e==b.e&&D_.CS(this,b)==0;}return false;};_.ib=function TS(){var a;if(this.b!=0){return this.b;}if(this.a<54){a=VN(this.f);this.b=kO(KN(a,-1));this.b=33*this.b+kO(KN(fO(a,32),-1));this.b=17*this.b+cK(this.e);return this.b;}this.b=17*D_.jT(this.c)+cK(this.e);return this.b;};_.jb=function VS(){return D_.HS(this);};_.a=0;_.b=0;_.d=0;_.e=0;_.f=0;h_.yM=jQ(12);D_.bT=function bT(){D_.bT=zO;var a;D_.YS=new D_.sT(1,1);D_.$S=new D_.sT(1,10);D_.aT=new D_.sT(0,0);D_.XS=new D_.sT(-1,1);D_.ZS=XI(II(h_.zM,1),V_,15,0,[D_.aT,D_.YS,new D_.sT(1,2),new D_.sT(1,3),new D_.sT(1,4),new D_.sT(1,5),new D_.sT(1,6),new D_.sT(1,7),new D_.sT(1,8),new D_.sT(1,9),D_.$S]);D_._S=OI(h_.zM,V_,15,32,0,1);for(a=0;a<D_._S.length;a++){D_._S[a]=D_.GT(eO(1,a));}};D_.cT=function cT(a){};D_.dT=function dT(a,b){if(a.e>b.e){return 1;}if(a.e<b.e){return -1;}if(a.d>b.d){return a.e;}if(a.d<b.d){return -b.e;}return a.e*D_.aU(a.a,b.a,a.d);};D_.eT=function eT(a){while(a.d>0&&a.a[--a.d]==0);a.a[a.d++]==0&&(a.e=0);};D_.fT=function fT(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p;f=b.e;if(f==0){throw IN(new i_.EP('BigInteger divide by zero'));}e=b.d;d=b.a;if(e==1){return D_.VT(a,d[0],f);}n=a.a;o=a.d;c=o!=e?o>e?1:-1:D_.aU(n,d,o);if(c<0){return XI(II(h_.zM,1),V_,15,0,[D_.aT,a]);}p=a.e;h=o-e+1;k=e;i=p==f?1:-1;g=OI(h_.hK,k0,5,h,15,1);j=D_.UT(g,h,n,o,d,e);l=new D_.tT(i,h,g);m=new D_.tT(p,k,j);D_.eT(l);D_.eT(m);return XI(II(h_.zM,1),V_,15,0,[l,m]);};D_.gT=function gT(a,b){var c;if(bK(a)===bK(b)){return true;}if(VJ(b,15)){c=b;return a.e==c.e&&a.d==c.d&&D_.hT(a,c.a);}return false;};D_.hT=function hT(a,b){var c;for(c=a.d-1;c>=0&&a.a[c]==b[c];c--);return c<0;};D_.iT=function iT(a){var b;if(a.b==-2){if(a.e==0){b=-1;}else {for(b=0;a.a[b]==0;b++);}a.b=b;}return a.b;};D_.jT=function jT(a){var b;if(a.c!=0){return a.c;}for(b=0;b<a.a.length;b++){a.c=a.c*33+(a.a[b]&-1);}a.c=a.c*a.e;return a.c;};D_.kT=function kT(a,b){if(b.e==0){return D_.aT;}if(a.e==0){return D_.aT;}return D_.iU(),D_.jU(a,b);};D_.lT=function lT(a,b){var c;if(b<0){throw IN(new i_.EP('Negative exponent'));}if(b==0){return D_.YS;}else if(b==1||D_.gT(a,D_.YS)||D_.gT(a,D_.aT)){return a;}if(!D_.pT(a,0)){c=1;while(!D_.pT(a,c)){++c;}return D_.kT(D_.AT(c*b),D_.lT(D_.oT(a,c),b));}return D_.qU(a,b);};D_.mT=function mT(a,b){if(b==0||a.e==0){return a;}return b>0?D_.IT(a,b):D_.MT(a,-b);};D_.nT=function nT(a){return a.e==0?a:D_.KT(a);};D_.oT=function oT(a,b){if(b==0||a.e==0){return a;}return b>0?D_.MT(a,b):D_.IT(a,-b);};D_.pT=function pT(a,b){var c,d,e;if(b==0){return (a.a[0]&1)!=0;}if(b<0){throw IN(new i_.EP('Negative bit address'));}e=b>>5;if(e>=a.d){return a.e<0;}c=a.a[e];b=1<<(b&31);if(a.e<0){d=D_.iT(a);if(e<d){return false;}else d==e?c=-c:c=~c;}return (c&b)!=0;};D_.qT=function qT(a){return D_.TT(a,0);};D_.rT=function rT(a,b){D_.cT(this);this.e=a;if(b<m2){this.d=1;this.a=XI(II(h_.hK,1),k0,5,15,[D_.ET(b)]);}else {this.d=2;this.a=XI(II(h_.hK,1),k0,5,15,[D_.ET(b%m2),D_.ET(b/m2)]);}};D_.sT=function sT(a,b){D_.bT();D_.cT(this);this.e=a;this.d=1;this.a=XI(II(h_.hK,1),k0,5,15,[b]);};D_.tT=function tT(a,b,c){D_.bT();D_.cT(this);this.e=a;this.d=b;this.a=c;};D_.uT=function uT(a,b){D_.cT(this);this.e=a;if(UN(KN(b,-4294967296),0)){this.d=1;this.a=XI(II(h_.hK,1),k0,5,15,[kO(b)]);}else {this.d=2;this.a=XI(II(h_.hK,1),k0,5,15,[kO(b),kO(fO(b,32))]);}};D_.vT=function vT(a){D_.bT();D_.cT(this);if(a.length==0){this.e=0;this.d=1;this.a=XI(II(h_.hK,1),k0,5,15,[0]);}else {this.e=1;this.d=a.length;this.a=a;D_.eT(this);}};D_.wT=function wT(a){D_.bT();D_.xT.call(this,a);};D_.xT=function xT(a){D_.cT(this);n_.M$(a);if(n_.V$(a).length==0){throw IN(new i_.vR('Zero length BigInteger'));}D_.CT(this,a);};D_.AT=function AT(a){var b,c,d;if(a<D_._S.length){return D_._S[a];}c=a>>5;b=a&31;d=OI(h_.hK,k0,5,c+1,15,1);d[c]=1<<b;return new D_.tT(1,c+1,d);};D_.CT=function CT(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;n=n_.V$(b).length;i=n;n_.S$(0,n_.V$(b).length);if(n_.V$(b).charCodeAt(0)==45){l=-1;m=1;--n;}else {l=1;m=0;}f=(D_.QT(),D_.PT)[10];e=n/f|0;q=n%f;q!=0&&++e;h=OI(h_.hK,k0,5,e,15,1);c=D_.OT[8];g=0;o=m+(q==0?f:q);for(p=m;p<i;p=o,o=p+f){d=i_.CQ(n_.V$(b).substr(p,o-p));j=(D_.iU(),D_.mU(h,h,g,c));j+=D_.bU(h,g,d);h[g++]=j;}k=g;a.e=l;a.d=k;a.a=h;D_.eT(a);};D_.ET=function ET(a){return a|0;};D_.FT=function FT(a){D_.bT();if(a<0){if(a!=-1){return new D_.rT(-1,-a);}return D_.XS;}else return a<=10?D_.ZS[cK(a)]:new D_.rT(1,a);};D_.GT=function GT(a){D_.bT();if(PN(a,0)<0){if(PN(a,-1)!=0){return new D_.uT(-1,bO(a));}return D_.XS;}else return PN(a,10)<=0?D_.ZS[kO(a)]:new D_.uT(1,a);};xO(15,73,{4:1,30:1,73:1,15:1},D_.rT,D_.sT,D_.tT,D_.uT,D_.vT,D_.wT);_.lb=function yT(a){return D_.dT(this,a);};_.gb=function zT(a){return D_.gT(this,a);};_.ib=function BT(){return D_.jT(this);};_.jb=function DT(){return D_.qT(this);};_.b=-2;_.c=0;_.d=0;_.e=0;h_.zM=jQ(15);D_.HT=function HT(a){var b,c,d;if(a.e==0){return 0;}b=a.d<<5;c=a.a[a.d-1];if(a.e<0){d=D_.iT(a);if(d==a.d-1){--c;c=c|0;}}b-=jR(c);return b;};D_.IT=function IT(a,b){var c,d,e,f;c=b>>5;b&=31;e=a.d+c+(b==0?0:1);d=OI(h_.hK,k0,5,e,15,1);D_.JT(d,a.a,c,b);f=new D_.tT(a.e,e,d);D_.eT(f);return f;};D_.JT=function JT(a,b,c,d){var e,f,g;if(d==0){i_.pS(b,0,a,c,a.length-c);}else {g=32-d;a[a.length-1]=0;for(f=a.length-1;f>c;f--){a[f]|=b[f-c-1]>>>g;a[f-1]=b[f-c-1]<<d;}}for(e=0;e<c;e++){a[e]=0;}};D_.KT=function KT(a){var b,c,d,e;e=a.d;c=e+1;b=OI(h_.hK,k0,5,c,15,1);D_.LT(b,a.a,e);d=new D_.tT(a.e,c,b);D_.eT(d);return d;};D_.LT=function LT(a,b,c){var d,e,f;d=0;for(e=0;e<c;e++){f=b[e];a[e]=f<<1|d;d=f>>>31;}d!=0&&(a[c]=d);};D_.MT=function MT(a,b){var c,d,e,f,g;d=b>>5;b&=31;if(d>=a.d){return a.e<0?(D_.bT(),D_.XS):(D_.bT(),D_.aT);}f=a.d-d;e=OI(h_.hK,k0,5,f+1,15,1);D_.NT(e,f,a.a,d,b);if(a.e<0){for(c=0;c<d&&a.a[c]==0;c++);if(c<d||b>0&&a.a[c]<<32-b!=0){for(c=0;c<f&&e[c]==-1;c++){e[c]=0;}c==f&&++f;++e[c];}}g=new D_.tT(a.e,f,e);D_.eT(g);return g;};D_.NT=function NT(a,b,c,d,e){var f,g,h;f=true;for(g=0;g<d;g++){f=f&c[g]==0;}if(e==0){i_.pS(c,d,a,0,b);g=b;}else {h=32-e;f=f&c[g]<<h==0;for(g=0;g<b-1;g++){a[g]=c[g+d]>>>e|c[g+d+1]<<h;}a[g]=c[g+d]>>>e;++g;}return f;};D_.QT=function QT(){D_.QT=zO;D_.OT=XI(II(h_.hK,1),k0,5,15,[$_,1162261467,y1,1220703125,362797056,1977326743,y1,387420489,g2,214358881,429981696,815730721,1475789056,170859375,U0,410338673,612220032,893871739,1280000000,1801088541,113379904,148035889,191102976,244140625,308915776,387420489,481890304,594823321,729000000,887503681,y1,1291467969,1544804416,1838265625,60466176]);D_.PT=XI(II(h_.hK,1),k0,5,15,[-1,-1,31,19,15,13,11,11,10,9,9,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5]);};D_.RT=function RT(a){var b,c,d;if(PN(a,0)>=0){c=TN(a,g2);d=_N(a,g2);}else {b=gO(a,1);c=TN(b,500000000);d=_N(b,500000000);d=JN(eO(d,1),KN(a,1));}return dO(eO(d,32),KN(c,p2));};D_.ST=function ST(a,b){D_.QT();var c,d,e,f,g,h,i,j,k,l,m,n,o,p;i=PN(a,0)<0;i&&(a=bO(a));if(PN(a,0)==0){switch(b){case 0:return '0';case 1:return '0.0';case 2:return '0.00';case 3:return '0.000';case 4:return D1;case 5:return '0.00000';case 6:return '0.000000';default:n=new i_.jS();b<0?(n.a+='0E+',n):(n.a+='0E',n);n.a+=b==$_?'2147483648':''+-b;return n.a;}}k=18;l=OI(h_.eK,f1,5,k+1,15,1);c=k;p=a;do{j=p;p=TN(p,10);l[--c]=kO(JN(48,hO(j,aO(p,10))))&f0;}while(PN(p,0)!=0);e=hO(hO(hO(h_.SN(k),h_.SN(c)),h_.SN(b)),1);if(b==0){i&&(l[--c]=45);return i_.YR(l,c,k-c);}if(b>0&&PN(e,-6)>=0){if(PN(e,0)>=0){f=c+kO(e);for(h=k-1;h>=f;h--){l[h+1]=l[h];}l[++f]=46;i&&(l[--c]=45);return i_.YR(l,c,k-c+1);}for(g=2;ZN(h_.SN(g),JN(bO(e),1));g++){l[--c]=48;}l[--c]=46;l[--c]=48;i&&(l[--c]=45);return i_.YR(l,c,k-c);}o=c+1;d=k;m=new i_.kS();i&&(m.a+='-',m);if(d-o>=1){i_.cS(m,l[c]);m.a+='.';m.a+=i_.YR(l,c+1,k-c-1);}else {m.a+=i_.YR(l,c,k-c);}m.a+='E';PN(e,0)>0&&(m.a+='+',m);m.a+=''+lO(e);return m.a;};D_.TT=function TT(a,b){D_.QT();var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H;B=a.e;o=a.d;e=a.a;if(B==0){switch(b){case 0:return '0';case 1:return '0.0';case 2:return '0.00';case 3:return '0.000';case 4:return D1;case 5:return '0.00000';case 6:return '0.000000';default:w=new i_.jS();b<0?(w.a+='0E+',w):(w.a+='0E',w);w.a+=-b;return w.a;}}t=o*10+1+7;u=OI(h_.eK,f1,5,t+1,15,1);c=t;if(o==1){h=e[0];if(h<0){H=KN(h_.SN(h),p2);do{p=H;H=TN(H,10);u[--c]=48+kO(hO(p,aO(H,10)))&f0;}while(PN(H,0)!=0);}else {H=h;do{p=H;H=H/10|0;u[--c]=48+(p-H*10)&f0;}while(H!=0);}}else {D=OI(h_.hK,k0,5,o,15,1);G=o;i_.pS(e,0,D,0,G);I:while(true){A=0;for(j=G-1;j>=0;j--){F=JN(eO(A,32),KN(h_.SN(D[j]),p2));r=D_.RT(F);D[j]=kO(r);A=WN(kO(fO(r,32)));}s=kO(A);q=c;do{u[--c]=48+s%10&f0;}while((s=s/10|0)!=0&&c!=0);d=9-q+c;for(i=0;i<d&&c>0;i++){u[--c]=48;}l=G-1;for(;D[l]==0;l--){if(l==0){break I;}}G=l+1;}while(u[c]==48){++c;}}n=B<0;g=t-c-b-1;if(b==0){n&&(u[--c]=45);return i_.YR(u,c,t-c);}if(b>0&&g>=-6){if(g>=0){k=c+g;for(m=t-1;m>=k;m--){u[m+1]=u[m];}u[++k]=46;n&&(u[--c]=45);return i_.YR(u,c,t-c+1);}for(l=2;l<-g+1;l++){u[--c]=48;}u[--c]=46;u[--c]=48;n&&(u[--c]=45);return i_.YR(u,c,t-c);}C=c+1;f=t;v=new i_.kS();n&&(v.a+='-',v);if(f-C>=1){i_.cS(v,u[c]);v.a+='.';v.a+=i_.YR(u,c+1,t-c-1);}else {v.a+=i_.YR(u,c,t-c);}v.a+='E';g>0&&(v.a+='+',v);v.a+=''+g;return v.a;};D_.UT=function UT(a,b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;q=OI(h_.hK,k0,5,d+1,15,1);r=OI(h_.hK,k0,5,f+1,15,1);s=f;i=jR(e[f-1]);if(i!=0){D_.JT(r,e,0,i);D_.JT(q,c,0,i);}else {i_.pS(c,0,q,0,d);i_.pS(e,0,r,0,f);}j=r[s-1];l=b-1;m=d;while(l>=0){k=0;if(q[m]==j){k=-1;}else {t=JN(eO(KN(h_.SN(q[m]),p2),32),KN(h_.SN(q[m-1]),p2));w=D_.XT(t,j);k=kO(w);v=kO(fO(w,32));if(k!=0){o=0;A=0;u=false;++k;do{--k;if(u){break;}o=aO(KN(h_.SN(k),p2),KN(h_.SN(r[s-2]),p2));A=JN(eO(h_.SN(v),32),KN(h_.SN(q[m-2]),p2));p=JN(KN(h_.SN(v),p2),KN(h_.SN(j),p2));jR(kO(gO(p,32)))<32?u=true:v=kO(p);}while(XN(mO(o,__),mO(A,__)));}}if(k!=0){g=D_.YT(q,m-s,r,s,k);if(g!=0){--k;h=0;for(n=0;n<s;n++){h=JN(h,JN(KN(h_.SN(q[m-s+n]),p2),KN(h_.SN(r[n]),p2)));q[m-s+n]=kO(h);h=gO(h,32);}}}a[l]=k;--m;--l;}if(i!=0){D_.NT(r,s,q,0,i);return r;}i_.pS(q,0,r,0,f);return q;};D_.VT=function VT(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;n=a.a;o=a.d;p=a.e;if(o==1){d=KN(h_.SN(n[0]),p2);e=KN(h_.SN(b),p2);f=TN(d,e);j=_N(d,e);p!=c&&(f=bO(f));p<0&&(j=bO(j));return XI(II(h_.zM,1),V_,15,0,[D_.GT(f),D_.GT(j)]);}h=o;i=p==c?1:-1;g=OI(h_.hK,k0,5,h,15,1);k=XI(II(h_.hK,1),k0,5,15,[D_.WT(g,n,o,b)]);l=new D_.tT(i,h,g);m=new D_.tT(p,1,k);D_.eT(l);D_.eT(m);return XI(II(h_.zM,1),V_,15,0,[l,m]);};D_.WT=function WT(a,b,c,d){var e,f,g,h,i,j,k;j=0;f=KN(h_.SN(d),p2);for(h=c-1;h>=0;h--){k=dO(eO(j,32),KN(h_.SN(b[h]),p2));if(PN(k,0)>=0){i=TN(k,f);j=_N(k,f);}else {e=gO(k,1);g=h_.SN(d>>>1);i=TN(e,g);j=_N(e,g);j=JN(eO(j,1),KN(k,1));if((d&1)!=0){if(PN(i,j)<=0){j=hO(j,i);}else {if($N(hO(i,j),f)){j=JN(j,hO(f,i));i=hO(i,1);}else {j=JN(j,hO(eO(f,1),i));i=hO(i,2);}}}}a[h]=kO(KN(i,p2));}return kO(j);};D_.XT=function XT(a,b){var c,d,e,f,g;d=KN(h_.SN(b),p2);if(PN(a,0)>=0){f=TN(a,d);g=_N(a,d);}else {c=gO(a,1);e=h_.SN(b>>>1);f=TN(c,e);g=_N(c,e);g=JN(eO(g,1),KN(a,1));if((b&1)!=0){if(PN(f,g)<=0){g=hO(g,f);}else {if($N(hO(f,g),d)){g=JN(g,hO(d,f));f=hO(f,1);}else {g=JN(g,hO(eO(d,1),f));f=hO(f,2);}}}}return dO(eO(g,32),KN(f,p2));};D_.YT=function YT(a,b,c,d,e){var f,g,h;f=0;g=0;for(h=0;h<d;h++){f=(D_.iU(),JN(aO(KN(h_.SN(c[h]),p2),KN(h_.SN(e),p2)),KN(WN(kO(f)),p2)));g=JN(hO(KN(h_.SN(a[b+h]),p2),KN(f,p2)),g);a[b+h]=kO(g);g=fO(g,32);f=gO(f,32);}g=JN(hO(KN(h_.SN(a[b+d]),p2),f),g);a[b+d]=kO(g);return kO(fO(g,32));};D_.ZT=function ZT(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;g=a.e;i=b.e;if(g==0){return b;}if(i==0){return a;}f=a.d;h=b.d;if(f+h==2){c=KN(WN(a.a[0]),p2);d=KN(WN(b.a[0]),p2);if(g==i){k=JN(c,d);o=kO(k);n=kO(gO(k,32));return n==0?new D_.sT(g,o):new D_.tT(g,2,XI(II(h_.hK,1),k0,5,15,[o,n]));}return D_.GT(g<0?hO(d,c):hO(c,d));}else if(g==i){m=g;l=f>=h?D_.$T(a.a,f,b.a,h):D_.$T(b.a,h,a.a,f);}else {e=f!=h?f>h?1:-1:D_.aU(a.a,b.a,f);if(e==0){return D_.bT(),D_.aT;}if(e==1){m=g;l=D_.dU(a.a,f,b.a,h);}else {m=i;l=D_.dU(b.a,h,a.a,f);}}j=new D_.tT(m,l.length,l);D_.eT(j);return j;};D_.$T=function $T(a,b,c,d){var e;e=OI(h_.hK,k0,5,b+1,15,1);D_._T(e,a,b,c,d);return e;};D_._T=function _T(a,b,c,d,e){var f,g;f=JN(KN(h_.SN(b[0]),p2),KN(h_.SN(d[0]),p2));a[0]=kO(f);f=fO(f,32);if(c>=e){for(g=1;g<e;g++){f=JN(f,JN(KN(h_.SN(b[g]),p2),KN(h_.SN(d[g]),p2)));a[g]=kO(f);f=fO(f,32);}for(;g<c;g++){f=JN(f,KN(h_.SN(b[g]),p2));a[g]=kO(f);f=fO(f,32);}}else {for(g=1;g<c;g++){f=JN(f,JN(KN(h_.SN(b[g]),p2),KN(h_.SN(d[g]),p2)));a[g]=kO(f);f=fO(f,32);}for(;g<e;g++){f=JN(f,KN(h_.SN(d[g]),p2));a[g]=kO(f);f=fO(f,32);}}PN(f,0)!=0&&(a[g]=kO(f));};D_.aU=function aU(a,b,c){var d;for(d=c-1;d>=0&&a[d]==b[d];d--);return d<0?0:ZN(KN(h_.SN(a[d]),p2),KN(h_.SN(b[d]),p2))?-1:1;};D_.bU=function bU(a,b,c){var d,e;d=KN(h_.SN(c),p2);for(e=0;PN(d,0)!=0&&e<b;e++){d=JN(d,KN(h_.SN(a[e]),p2));a[e]=kO(d);d=fO(d,32);}return kO(d);};D_.cU=function cU(a,b){var c,d,e,f,g,h,i,j,k,l;g=a.e;i=b.e;if(i==0){return a;}if(g==0){return b.e==0?b:new D_.tT(-b.e,b.d,b.a);}f=a.d;h=b.d;if(f+h==2){c=KN(WN(a.a[0]),p2);d=KN(WN(b.a[0]),p2);g<0&&(c=bO(c));i<0&&(d=bO(d));return D_.GT(hO(c,d));}e=f!=h?f>h?1:-1:D_.aU(a.a,b.a,f);if(e==-1){l=-i;k=g==i?D_.dU(b.a,h,a.a,f):D_.$T(b.a,h,a.a,f);}else {l=g;if(g==i){if(e==0){return D_.bT(),D_.aT;}k=D_.dU(a.a,f,b.a,h);}else {k=D_.$T(a.a,f,b.a,h);}}j=new D_.tT(l,k.length,k);D_.eT(j);return j;};D_.dU=function dU(a,b,c,d){var e;e=OI(h_.hK,k0,5,b,15,1);D_.eU(e,a,b,c,d);return e;};D_.eU=function eU(a,b,c,d,e){var f,g;f=0;for(g=0;g<e;g++){f=JN(f,hO(KN(h_.SN(b[g]),p2),KN(h_.SN(d[g]),p2)));a[g]=kO(f);f=fO(f,32);}for(;g<c;g++){f=JN(f,KN(h_.SN(b[g]),p2));a[g]=kO(f);f=fO(f,32);}};D_.iU=function iU(){D_.iU=zO;var a,b;D_.fU=OI(h_.zM,V_,15,32,0,1);D_.gU=OI(h_.zM,V_,15,32,0,1);D_.hU=XI(II(h_.hK,1),k0,5,15,[1,10,100,1000,g0,100000,1000000,10000000,100000000,g2]);a=1;for(b=0;b<=18;b++){D_.fU[b]=D_.GT(a);D_.gU[b]=D_.GT(eO(a,b));a=aO(a,5);}for(;b<D_.gU.length;b++){D_.fU[b]=D_.kT(D_.fU[b-1],D_.fU[1]);D_.gU[b]=D_.kT(D_.gU[b-1],(D_.bT(),D_.$S));}};D_.jU=function jU(a,b){D_.iU();var c,d,e,f,g,h,i,j,k;if(b.d>a.d){h=a;a=b;b=h;}if(b.d<63){return D_.pU(a,b);}g=(a.d&-2)<<4;j=D_.oT(a,g);k=D_.oT(b,g);d=D_.cU(a,D_.mT(j,g));e=D_.cU(b,D_.mT(k,g));i=D_.jU(j,k);c=D_.jU(d,e);f=D_.jU(D_.cU(j,d),D_.cU(e,k));f=D_.ZT(D_.ZT(f,i),c);f=D_.mT(f,g);i=D_.mT(i,g<<1);return D_.ZT(D_.ZT(i,f),c);};D_.kU=function kU(a,b,c,d,e){if(b==0||d==0){return;}b==1?e[d]=D_.mU(e,c,d,a[0]):d==1?e[b]=D_.mU(e,a,b,c[0]):D_.lU(a,c,e,b,d);};D_.lU=function lU(a,b,c,d,e){var f,g,h,i;if(bK(a)===bK(b)&&d==e){D_.sU(a,d,c);return;}for(h=0;h<d;h++){g=0;f=a[h];for(i=0;i<e;i++){g=JN(JN(aO(KN(h_.SN(f),p2),KN(h_.SN(b[i]),p2)),KN(h_.SN(c[h+i]),p2)),KN(WN(kO(g)),p2));c[h+i]=kO(g);g=gO(g,32);}c[h+e]=kO(g);}};D_.mU=function mU(a,b,c,d){D_.iU();var e,f;e=0;for(f=0;f<c;f++){e=JN(aO(KN(h_.SN(b[f]),p2),KN(h_.SN(d),p2)),KN(WN(kO(e)),p2));a[f]=kO(e);e=gO(e,32);}return kO(e);};D_.nU=function nU(a,b){var c,d,e,f,g,h,i,j,k;j=a.e;if(j==0){return D_.bT(),D_.aT;}d=a.d;c=a.a;if(d==1){e=aO(KN(h_.SN(c[0]),p2),KN(h_.SN(b),p2));i=kO(e);g=kO(gO(e,32));return g==0?new D_.sT(j,i):new D_.tT(j,2,XI(II(h_.hK,1),k0,5,15,[i,g]));}h=d+1;f=OI(h_.hK,k0,5,h,15,1);f[d]=D_.mU(f,c,d,b);k=new D_.tT(j,h,f);D_.eT(k);return k;};D_.oU=function oU(a,b){D_.iU();return b<D_.hU.length?D_.nU(a,D_.hU[b]):D_.kT(a,D_.rU(b));};D_.pU=function pU(a,b){var c,d,e,f,g,h,i,j,k,l,m;d=a.d;f=b.d;h=d+f;i=a.e!=b.e?-1:1;if(h==2){k=aO(KN(WN(a.a[0]),p2),KN(WN(b.a[0]),p2));m=kO(k);l=kO(gO(k,32));return l==0?new D_.sT(i,m):new D_.tT(i,2,XI(II(h_.hK,1),k0,5,15,[m,l]));}c=a.a;e=b.a;g=OI(h_.hK,k0,5,h,15,1);D_.kU(c,d,e,f,g);j=new D_.tT(i,h,g);D_.eT(j);return j;};D_.qU=function qU(a,b){D_.iU();var c,d;d=(D_.bT(),D_.YS);c=a;for(;b>1;b>>=1){(b&1)!=0&&(d=D_.kT(d,c));c.d==1?c=D_.kT(c,c):c=new D_.vT(D_.sU(c.a,c.d,OI(h_.hK,k0,5,c.d<<1,15,1)));}d=D_.kT(d,c);return d;};D_.rU=function rU(a){D_.iU();var b,c,d,e;b=cK(a);if(a<D_.gU.length){return D_.gU[b];}else if(a<=50){return D_.lT((D_.bT(),D_.$S),b);}else if(a<=1000){return D_.mT(D_.lT(D_.fU[1],b),b);}if(a>1000000){throw IN(new i_.EP('power of ten too big'));}if(a<=P_){return D_.mT(D_.lT(D_.fU[1],b),b);}d=D_.lT(D_.fU[1],P_);e=d;c=VN(a-P_);b=cK(a%P_);while(PN(c,P_)>0){e=D_.kT(e,d);c=hO(c,P_);}e=D_.kT(e,D_.lT(D_.fU[1],b));e=D_.mT(e,P_);c=VN(a-P_);while(PN(c,P_)>0){e=D_.mT(e,P_);c=hO(c,P_);}e=D_.mT(e,b);return e;};D_.sU=function sU(a,b,c){var d,e,f,g,h;for(f=0;f<b;f++){d=0;for(h=f+1;h<b;h++){d=JN(JN(aO(KN(h_.SN(a[f]),p2),KN(h_.SN(a[h]),p2)),KN(h_.SN(c[f+h]),p2)),KN(WN(kO(d)),p2));c[f+h]=kO(d);d=gO(d,32);}c[f+b]=kO(d);}D_.LT(c,c,b<<1);d=0;for(e=0,g=0;e<b;++e,g++){d=JN(JN(aO(KN(h_.SN(a[e]),p2),KN(h_.SN(a[e]),p2)),KN(h_.SN(c[g]),p2)),KN(WN(kO(d)),p2));c[g]=kO(d);d=gO(d,32);++g;d=JN(d,KN(h_.SN(c[g]),p2));c[g]=kO(d);d=gO(d,32);}return c;};D_.BU=function BU(){D_.BU=zO;D_.AU=new D_.CU('UP',0);D_.uU=new D_.CU('DOWN',1);D_.tU=new D_.CU('CEILING',2);D_.vU=new D_.CU('FLOOR',3);D_.yU=new D_.CU('HALF_UP',4);D_.wU=new D_.CU('HALF_DOWN',5);D_.xU=new D_.CU('HALF_EVEN',6);D_.zU=new D_.CU('UNNECESSARY',7);};D_.CU=function CU(a,b){RQ.call(this,a,b);};D_.DU=function DU(){D_.BU();return XI(II(h_.AM,1),V_,44,0,[D_.AU,D_.uU,D_.tU,D_.vU,D_.yU,D_.wU,D_.xU,D_.zU]);};xO(44,39,{4:1,30:1,39:1,44:1},D_.CU);h_.AM=kQ(44,D_.DU);E_.EU=function EU(a,b){return i_.DR(a.a,b.a);};E_.FU=function FU(a){this.a=a;};xO(60,1,q2);_.lb=function GU(a){return E_.EU(this,a);};_.gb=function HU(a){var b;if(a===this){return true;}if(!VJ(a,60)){return false;}b=a;return i_.GR(this.a,b.a);};_.ib=function IU(){return n_.e_(this.a);};_.jb=function JU(){return this.a;};h_.BM=jQ(60);xO(215,1,{});h_.DM=jQ(215);F_.KU=function KU(a,b){return w_.oI(a.a,b);};F_.LU=function LU(a){this.a=(w_.iI(),new w_.zI(a,w_.dI()));};F_.MU=function MU(a){F_.LU.call(this,a);};xO(100,215,{},F_.LU,F_.MU);h_.CM=jQ(100);l_.AX=function AX(a,b,c){var d,e,f;d=(f=b,l_.lV(l_.lY(a,f)));return d==null&&(e=b,!l_.lY(a,e))?c:d;};l_.BX=function BX(a,b,c){var d,e;d=(e=b,l_.lV(l_.lY(a,e)));return d!=null?d:l_.qY(a,b,c);};l_.CX=function CX(a,b,c){var d;return d=b,l_.lY(a,d)?l_.qY(a,b,c):null;};l_.cV=function cV(a,b){var c,d,e;for(d=new l_.IY(new l_.NY(a).b);l_.OU(d.a);){c=d.b=l_.PU(d.a);e=c.Tb();if(bK(b)===bK(e)||b!=null&&i_.wc(b,e)){return true;}}return false;};l_.dV=function dV(a,b,c){var d,e,f;for(e=new l_.IY(new l_.NY(a).b);l_.OU(e.a);){d=e.b=l_.PU(e.a);f=d.Sb();if(bK(b)===bK(f)||b!=null&&i_.wc(b,f)){if(c){d=new l_.eW(d.Sb(),d.Tb());l_.HY(e);}return d;}}return null;};l_.eV=function eV(a,b){return b===a?'(this Map)':b==null?X_:EO(b);};l_.fV=function fV(a){return new l_.MV(a);};l_.lV=function lV(a){return !a?null:a.Tb();};xO(213,1,{188:1});_.getOrDefault=function mV(a,b){var c,d,e;return c=(e=a,l_.lV(l_.lY(this,e))),c==null&&(d=a,!l_.lY(this,d))?b:c;};_.putIfAbsent=function sV(a,b){var c,d;return c=(d=a,l_.lV(l_.lY(this,d))),c!=null?c:l_.qY(this,a,b);};_.replace=function uV(a,b){var c;return c=a,l_.lY(this,c)?l_.qY(this,a,b):null;};_.clear=function gV(){this.Rb().clear();};_.containsKey=function hV(a){return !!l_.dV(this,a,false);};_.containsValue=function iV(a){return l_.cV(this,a);};_.gb=function jV(a){var b,c,d;if(a===this){return true;}if(!VJ(a,56)){return false;}d=a;if(this.c!=d.c){return false;}for(c=new l_.IY(new l_.NY(d).b);l_.OU(c.a);){b=c.b=l_.PU(c.a);if(!l_.fW(this,b)){return false;}}return true;};_.get=function kV(a){return l_.lV(l_.dV(this,a,false));};_.ib=function nV(){return l_.rX(this.Rb());};_.isEmpty=function oV(){return this.c==0;};_.keySet=function pV(){return new l_.BV(this);};_.put=function qV(a,b){throw IN(new i_.sS('Put not supported on this map'));};_.putAll=function rV(a){var b,c;n_.M$(a);for(c=new l_.IY(a.Rb().b);l_.OU(c.a);){b=c.b=l_.PU(c.a);l_.qY(this,b.Sb(),b.Tb());}};_.remove=function tV(a){return l_.lV(l_.dV(this,a,true));};_.size=function vV(){return this.Rb().b.c;};_.jb=function wV(){var a,b,c;c=new l_.gY('{','}');for(b=new l_.IY(this.Rb().b);l_.OU(b.a);){a=b.b=l_.PU(b.a);l_.eY(c,l_.eV(this,a.Sb())+'='+l_.eV(this,a.Tb()));}return !c.a?c.c:n_.V$(c.e).length==0?c.a.a:c.a.a+(''+c.e);};_.values=function xV(){return l_.fV(this);};h_.PM=jQ(213);xO(212,208,r2);_.gb=function yV(a){var b;if(a===this){return true;}if(!VJ(a,77)){return false;}b=a;if(b.size()!=this.size()){return false;}return l_.jh(this,b);};_.ib=function zV(){return l_.rX(this);};_.removeAll=function AV(a){var b,c,d,e;n_.M$(a);e=this.size();if(e<a.size()){for(b=this.mb();b.Ob();){c=b.Pb();a.contains(c)&&b.Qb();}}else {for(d=a.mb();d.Ob();){c=d.Pb();this.remove(c);}}return e!=this.size();};h_.UM=jQ(212);l_.BV=function BV(a){this.a=a;};xO(164,212,r2,l_.BV);_.clear=function CV(){l_.jY(this.a);};_.contains=function DV(a){return l_.gW(this.a,a);};_.mb=function EV(){var a;a=new l_.IY(new l_.NY(this.a).b);return new l_.HV(a);};_.remove=function FV(a){if(l_.gW(this.a,a)){l_.rY(this.a,a);return true;}return false;};_.size=function GV(){return this.a.c;};h_.KM=jQ(164);l_.HV=function HV(a){this.a=a;};xO(165,1,{},l_.HV);_.Ob=function IV(){return l_.OU(this.a.a);};_.Pb=function JV(){var a;a=l_.GY(this.a);return a.Sb();};_.Qb=function KV(){l_.HY(this.a);};h_.JM=jQ(165);l_.LV=function LV(a){var b;b=new l_.IY(new l_.NY(a.a).b);return new l_.TV(b);};l_.MV=function MV(a){this.a=a;};xO(121,208,{37:1},l_.MV);_.clear=function NV(){l_.jY(this.a);};_.contains=function OV(a){return l_.cV(this.a,a);};_.mb=function PV(){return l_.LV(this);};_.size=function QV(){return this.a.c;};h_.MM=jQ(121);l_.RV=function RV(a){return l_.OU(a.a.a);};l_.SV=function SV(a){var b;b=l_.GY(a.a);return b.Tb();};l_.TV=function TV(a){this.a=a;};xO(122,1,{},l_.TV);_.Ob=function UV(){return l_.RV(this);};_.Pb=function VV(){return l_.SV(this);};_.Qb=function WV(){l_.HY(this.a);};h_.LM=jQ(122);l_.XV=function XV(a){return a.c;};l_.YV=function YV(a){return a.d;};l_.ZV=function ZV(a,b){var c;c=a.d;a.d=b;return c;};l_.$V=function $V(a,b){this.c=a;this.d=b;};xO(84,1,{84:1,86:1});_.gb=function _V(a){var b;if(!VJ(a,86)){return false;}b=a;return l_.EX(this.c,b.Sb())&&l_.EX(this.d,b.Tb());};_.Sb=function aW(){return l_.XV(this);};_.Tb=function bW(){return l_.YV(this);};_.ib=function cW(){return l_.FX(this.c)^l_.FX(this.d);};_.jb=function dW(){return this.c+'='+this.d;};h_.NM=jQ(84);l_.eW=function eW(a,b){l_.$V.call(this,a,b);};xO(85,84,{84:1,85:1,86:1},l_.eW);h_.OM=jQ(85);l_.fW=function fW(a,b){var c,d;c=b.Sb();d=l_.lY(a,c);return !!d&&l_.EX(d.d,b.Tb());};l_.gW=function gW(a,b){var c;c=b;return !!l_.lY(a,c);};l_.hW=function hW(a,b){var c;c=b;return l_.lV(l_.lY(a,c));};l_.iW=function iW(a){return new l_.vW(a);};xO(214,213,{188:1});_.containsKey=function jW(a){return l_.gW(this,a);};_.Rb=function kW(){return new l_.pW(this);};_.get=function lW(a){return l_.hW(this,a);};_.keySet=function mW(){return l_.iW(this);};h_.TM=jQ(214);l_.nW=function nW(a){return new l_.IY(a.b);};l_.oW=function oW(a){return a.b.c;};l_.pW=function pW(a){this.b=a;};xO(125,212,r2,l_.pW);_.contains=function qW(a){return VJ(a,86)&&l_.fW(this.b,a);};_.mb=function rW(){return l_.nW(this);};_.remove=function sW(a){var b;if(VJ(a,86)){b=a;return l_.sY(this.b,b);}return false;};_.size=function tW(){return l_.oW(this);};h_.QM=jQ(125);l_.uW=function uW(a){var b;b=new l_.IY(new l_.NY(a.a).b);return new l_.DW(b);};l_.vW=function vW(a){this.a=a;};xO(93,212,r2,l_.vW);_.clear=function wW(){l_.jY(this.a);};_.contains=function xW(a){return l_.gW(this.a,a);};_.mb=function yW(){return l_.uW(this);};_.remove=function zW(a){if(l_.gW(this.a,a)){l_.rY(this.a,a);return true;}return false;};_.size=function AW(){return this.a.c;};h_.SM=jQ(93);l_.BW=function BW(a){return l_.OU(a.a.a);};l_.CW=function CW(a){var b;b=l_.GY(a.a);return b.Sb();};l_.DW=function DW(a){this.a=a;};xO(94,1,{},l_.DW);_.Ob=function EW(){return l_.BW(this);};_.Pb=function FW(){return l_.CW(this);};_.Qb=function GW(){l_.HY(this.a);};h_.RM=jQ(94);l_.iX=function iX(){return h_.yL;};l_.jX=function jX(){};xO(220,$wnd.Function,{},l_.jX);_.Ub=function kX(a,b){return JQ(a,b);};l_.lX=function lX(){return h_.yL;};l_.mX=function mX(){};xO(221,$wnd.Function,{},l_.mX);_.Vb=function nX(a,b){return PN(a,b)<0?-1:PN(a,b)>0?1:0;};l_.oX=function oX(){return h_.yL;};l_.pX=function pX(){};xO(47,$wnd.Function,{},l_.pX);_.Ub=function qX(a,b){return a-b;};l_.uX=function uX(){l_.uX=zO;l_.tX=new l_.wX();};l_.vX=function vX(a,b){return n_.M$(a),i_.SP(a,(n_.M$(b),b));};l_.wX=function wX(){};xO(181,1,f1,l_.wX);_.kb=function xX(a,b){return l_.vX(a,b);};_.gb=function yX(a){return this===a;};h_.XM=jQ(181);l_.JX=function JX(){l_.JX=zO;var a,b,c,d;l_.GX=OI(h_.fK,B0,5,25,15,1);l_.HX=OI(h_.fK,B0,5,33,15,1);d=n2;for(b=32;b>=0;b--){l_.HX[b]=d;d*=0.5;}c=1;for(a=24;a>=0;a--){l_.GX[a]=c;c*=0.5;}};l_.KX=function KX(a,b){var c,d;n_.H$(b>0);if((b&-b)==b){return cK(b*l_.LX(a)*4.6566128730773926E-10);}do{c=l_.LX(a);d=c%b;}while(c-d+(b-1)<0);return cK(d);};l_.LX=function LX(a){var b,c,d,e,f,g;e=a.a*s2+a.b*1502;g=a.b*s2+11;b=$wnd.Math.floor(g*t2);e+=b;g-=b*s1;e%=s1;a.a=e;a.b=g;d=a.a*128;f=$wnd.Math.floor(a.b*l_.HX[31]);c=d+f;c>=2147483648&&(c-=m2);return c;};l_.MX=function MX(a,b,c){a.a=b^1502;a.b=c^s2;};l_.NX=function NX(){l_.JX();var a,b,c;c=l_.IX++ +Date.now();a=cK($wnd.Math.floor(c*t2))&r0;b=cK(c-a*s1);this.a=a^1502;this.b=b^s2;};l_.OX=function OX(a){l_.JX();l_.MX(this,kO(KN(fO(a,24),r0)),kO(KN(a,r0)));};xO(89,1,{},l_.NX,l_.OX);_.a=0;_.b=0;l_.IX=0;h_.ZM=jQ(89);l_.eY=function eY(a,b){!a.a?a.a=new i_.lS(a.d):i_.gS(a.a,a.b);i_.fS(a.a,b);return a;};l_.fY=function fY(a){return !a.a?a.c:n_.V$(a.e).length==0?a.a.a:a.a.a+(''+a.e);};l_.gY=function gY(a,b){this.b=', ';this.d=a;this.e=b;this.c=this.d+(''+this.e);};xO(109,1,{},l_.gY);_.jb=function hY(){return l_.fY(this);};h_.cN=jQ(109);l_.iY=function iY(a){};l_.jY=function jY(a){a.b=null;a.c=0;};l_.kY=function kY(a){return new l_.NY(a);};l_.lY=function lY(a,b){var c,d,e;e=a.b;while(e){c=a.a.kb(b,e.c);if(c==0){return e;}d=c<0?0:1;e=e.a[d];}return null;};l_.mY=function mY(a,b,c,d,e,f,g,h){var i,j;if(!d){return;}i=d.a[0];!!i&&l_.mY(a,b,c,i,e,f,g,h);l_.nY(a,c,d.c,e,f,g,h)&&b.add(d);j=d.a[1];!!j&&l_.mY(a,b,c,j,e,f,g,h);};l_.nY=function nY(a,b,c,d,e,f,g){var h,i;if(b.$b()&&(i=a.a.kb(c,d),i<0||!e&&i==0)){return false;}if(b._b()&&(h=a.a.kb(c,f),h>0||!g&&h==0)){return false;}return true;};l_.oY=function oY(a,b,c,d){var e,f;if(!b){return c;}else {e=a.a.kb(c.c,b.c);if(e==0){d.d=l_.ZV(b,c.d);d.b=true;return b;}f=e<0?0:1;b.a[f]=l_.oY(a,b.a[f],c,d);if(l_.pY(b.a[f])){if(l_.pY(b.a[1-f])){b.b=true;b.a[0].b=false;b.a[1].b=false;}else {l_.pY(b.a[f].a[f])?b=l_.wY(b,1-f):l_.pY(b.a[f].a[1-f])&&(b=l_.vY(b,1-f));}}}return b;};l_.pY=function pY(a){return !!a&&a.b;};l_.qY=function qY(a,b,c){var d,e;d=new l_.QY(b,c);e=new l_.SY();a.b=l_.oY(a,a.b,d,e);e.b||++a.c;a.b.b=false;return e.d;};l_.rY=function rY(a,b){var c,d;c=b;d=new l_.SY();l_.tY(a,c,d);return d.d;};l_.sY=function sY(a,b){var c;c=new l_.SY();c.c=true;c.d=b.Tb();return l_.tY(a,b.Sb(),c);};l_.tY=function tY(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;if(!a.b){return false;}g=null;m=null;i=new l_.QY(null,null);e=1;i.a[1]=a.b;l=i;while(l.a[e]){j=e;h=m;m=l;l=l.a[e];d=a.a.kb(b,l.c);e=d<0?0:1;d==0&&(!c.c||l_.EX(l.d,c.d))&&(g=l);if(!(!!l&&l.b)&&!l_.pY(l.a[e])){if(l_.pY(l.a[1-e])){m=m.a[j]=l_.wY(l,e);}else if(!l_.pY(l.a[1-e])){n=m.a[1-j];if(n){if(!l_.pY(n.a[1-j])&&!l_.pY(n.a[j])){m.b=false;n.b=true;l.b=true;}else {f=h.a[1]==m?1:0;l_.pY(n.a[j])?h.a[f]=l_.vY(m,j):l_.pY(n.a[1-j])&&(h.a[f]=l_.wY(m,j));l.b=h.a[f].b=true;h.a[f].a[0].b=false;h.a[f].a[1].b=false;}}}}}if(g){c.b=true;c.d=g.d;if(l!=g){k=new l_.QY(l.c,l.d);l_.uY(a,i,g,k);m==g&&(m=k);}m.a[m.a[1]==l?1:0]=l.a[!l.a[0]?1:0];--a.c;}a.b=i.a[1];!!a.b&&(a.b.b=false);return c.b;};l_.uY=function uY(a,b,c,d){var e,f;f=b;e=f.c==null||a.a.kb(c.c,f.c)>0?1:0;while(f.a[e]!=c){f=f.a[e];e=a.a.kb(c.c,f.c)>0?1:0;}f.a[e]=d;d.b=c.b;d.a[0]=c.a[0];d.a[1]=c.a[1];c.a[0]=null;c.a[1]=null;};l_.vY=function vY(a,b){var c;c=1-b;a.a[c]=l_.wY(a.a[c],c);return l_.wY(a,b);};l_.wY=function wY(a,b){var c,d;c=1-b;d=a.a[c];a.a[c]=d.a[b];d.a[b]=a;a.b=true;d.b=false;return d;};l_.xY=function xY(a){return a.c;};l_.yY=function yY(){l_.zY.call(this,null);};l_.zY=function zY(a){l_.iY(this);this.b=null;this.a=(l_.uX(),!a?l_.tX:a);};xO(56,214,{4:1,188:1,56:1},l_.yY,l_.zY);_.clear=function AY(){l_.jY(this);};_.Rb=function BY(){return l_.kY(this);};_.put=function CY(a,b){return l_.qY(this,a,b);};_.remove=function DY(a){return l_.rY(this,a);};_.size=function EY(){return l_.xY(this);};_.c=0;h_.lN=jQ(56);l_.FY=function FY(a){return l_.OU(a.a);};l_.GY=function GY(a){return a.b=l_.PU(a.a);};l_.HY=function HY(a){l_.QU(a.a);l_.sY(a.c,a.b);a.b=null;};l_.IY=function IY(a){l_.JY.call(this,a,(l_.YY(),l_.UY));};l_.JY=function JY(a,b){var c;this.c=a;c=new l_.gi();l_.mY(a,c,b,a.b,null,false,null,false);this.a=new l_.WU(c,0);};xO(35,1,{},l_.IY);_.Pb=function LY(){return l_.GY(this);};_.Ob=function KY(){return l_.FY(this);};_.Qb=function MY(){l_.HY(this);};h_.dN=jQ(35);l_.NY=function NY(a){this.a=a;l_.pW.call(this,a);};xO(41,125,r2,l_.NY);_.clear=function OY(){l_.jY(this.a);};h_.eN=jQ(41);l_.PY=function PY(a){a.a=OI(h_.fN,W_,65,2,0,1);};l_.QY=function QY(a,b){l_.RY.call(this,a,b);};l_.RY=function RY(a,b){l_.eW.call(this,a,b);l_.PY(this);this.b=true;};xO(65,85,{84:1,85:1,86:1,65:1},l_.QY);_.b=false;h_.fN=jQ(65);l_.SY=function SY(){};xO(99,1,{},l_.SY);_.jb=function TY(){return 'State: mv='+this.c+' value='+this.d+' done='+this.a+' found='+this.b;};_.a=false;_.b=false;_.c=false;h_.gN=jQ(99);l_.YY=function YY(){l_.YY=zO;l_.UY=new l_.ZY('All',0);l_.VY=new l_.bZ();l_.WY=new l_.dZ();l_.XY=new l_.gZ();};l_.ZY=function ZY(a,b){RQ.call(this,a,b);};l_.aZ=function aZ(){l_.YY();return XI(II(h_.kN,1),V_,48,0,[l_.UY,l_.VY,l_.WY,l_.XY]);};xO(48,39,u2,l_.ZY);_.$b=function $Y(){return false;};_._b=function _Y(){return false;};h_.kN=kQ(48,l_.aZ);l_.bZ=function bZ(){l_.ZY.call(this,'Head',1);};xO(171,48,u2,l_.bZ);_._b=function cZ(){return true;};h_.hN=kQ(171,null);l_.dZ=function dZ(){l_.ZY.call(this,'Range',2);};xO(172,48,u2,l_.dZ);_.$b=function eZ(){return true;};_._b=function fZ(){return true;};h_.iN=kQ(172,null);l_.gZ=function gZ(){l_.ZY.call(this,'Tail',3);};xO(173,48,u2,l_.gZ);_.$b=function hZ(){return true;};h_.jN=kQ(173,null);l_.iZ=function iZ(a,b){return l_.qY(a.a,b,(i_.KP(),JP))==null;};l_.jZ=function jZ(a){l_.jY(a.a);};l_.kZ=function kZ(a,b){return l_.gW(a.a,b);};l_.lZ=function lZ(a){var b;return b=new l_.IY(new l_.NY(new l_.vW(a.a).a).b),new l_.DW(b);};l_.mZ=function mZ(a){this.a=new l_.zY(a);};xO(150,212,{4:1,37:1,77:1},l_.mZ);_.add=function nZ(a){return l_.iZ(this,a);};_.clear=function oZ(){l_.jZ(this);};_.contains=function pZ(a){return l_.kZ(this,a);};_.mb=function qZ(){return l_.lZ(this);};_.remove=function rZ(a){return l_.rY(this.a,a)!=null;};_.size=function sZ(){return this.a.c;};h_.mN=jQ(150);l_.tZ=function tZ(a,b){return l_.Oh(a.a,b);};l_.uZ=function uZ(a){return a.a.a.length;};l_.vZ=function vZ(a,b){return l_.fi(a.a,b);};l_.wZ=function wZ(){this.a=new l_.gi();};l_.BZ=function BZ(a,b){if(a<0||a>=b){throw IN(new i_.HP());}};xO(170,209,i0,l_.wZ);_.addAtIndex=function xZ(a,b){l_.BZ(a,this.a.a.length+1);l_.Nh(this.a,a,b);};_.add=function yZ(a){return l_.tZ(this,a);};_.addAllAtIndex=function zZ(a,b){l_.BZ(a,this.a.a.length+1);return l_.Ph(this.a,a,b);};_.addAll=function AZ(a){return l_.Qh(this.a,a);};_.clear=function CZ(){this.a.a=OI(h_.nM,W_,1,0,5,1);};_.contains=function DZ(a){return l_.Vh(this.a,a,0)!=-1;};_.containsAll=function EZ(a){return l_.jh(this.a,a);};_.getAtIndex=function FZ(a){l_.BZ(a,this.a.a.length);return l_.Th(this.a,a);};_.indexOf=function GZ(a){return l_.Vh(this.a,a,0);};_.isEmpty=function HZ(){return this.a.a.length==0;};_.mb=function IZ(){return new l_.KW(this.a);};_.lastIndexOf=function JZ(a){return l_.Yh(this.a,a);};_.removeAtIndex=function KZ(a){l_.BZ(a,this.a.a.length);return l_.$h(this.a,a);};_.removeAll=function LZ(a){return l_.kh(this.a,a);};_.ob=function MZ(a,b){l_.ai(this.a,a,b);};_.setAtIndex=function NZ(a,b){l_.BZ(a,this.a.a.length);return l_.bi(this.a,a,b);};_.size=function OZ(){return l_.uZ(this);};_.subList=function PZ(a,b){return new l_.YU(this.a,a,b);};_.toArray=function QZ(){return l_.ei(this.a);};_.nb=function RZ(a){return l_.vZ(this,a);};_.jb=function SZ(){return l_.lh(this.a);};h_.nN=jQ(170);n_.A$=function A$(){n_.A$=zO;new n_.G$();new n_.C$('ISO-LATIN-1');new n_.C$('ISO-8859-1');};n_.B$=function B$(a){E_.FU.call(this,a);};xO(110,60,q2);h_.BN=jQ(110);n_.C$=function C$(a){n_.B$.call(this,a);};xO(111,110,q2,n_.C$);h_.zN=jQ(111);n_.D$=function D$(a,b,c){var d,e,f,g,h,i,j,k,l;f=0;for(j=0;j<c;){++f;e=a[b+j];if((e&192)==128){throw IN(new i_._Q(v2));}else if((e&128)==0){++j;}else if((e&224)==192){j+=2;}else if((e&240)==224){j+=3;}else if((e&248)==240){j+=4;}else {throw IN(new i_._Q(v2));}if(j>c){throw IN(new i_.GP(v2));}}g=OI(h_.eK,f1,5,f,15,1);l=0;h=0;for(i=0;i<c;){e=a[b+i++];if((e&128)==0){h=1;e&=127;}else if((e&224)==192){h=2;e&=31;}else if((e&240)==224){h=3;e&=15;}else if((e&248)==240){h=4;e&=7;}else if((e&252)==248){h=5;e&=3;}while(--h>0){d=a[b+i++];if((d&192)!=128){throw IN(new i_._Q('Invalid UTF8 sequence at '+(b+i-1)+', byte='+(k=n_.V$(i_.mR(d)),k.toString(16))));}e=e<<6|d&63;}l+=$P(e,g,l);}return g;};n_.E$=function E$(a,b,c){if(c<128){a[b]=(c&127)<<24>>24;return 1;}else if(c<V0){a[b++]=(c>>6&31|192)<<24>>24;a[b]=(c&63|128)<<24>>24;return 2;}else if(c<e0){a[b++]=(c>>12&15|224)<<24>>24;a[b++]=(c>>6&63|128)<<24>>24;a[b]=(c&63|128)<<24>>24;return 3;}else if(c<R0){a[b++]=(c>>18&7|240)<<24>>24;a[b++]=(c>>12&63|128)<<24>>24;a[b++]=(c>>6&63|128)<<24>>24;a[b]=(c&63|128)<<24>>24;return 4;}else if(c<q1){a[b++]=(c>>24&3|248)<<24>>24;a[b++]=(c>>18&63|128)<<24>>24;a[b++]=(c>>12&63|128)<<24>>24;a[b++]=(c>>6&63|128)<<24>>24;a[b]=(c&63|128)<<24>>24;return 5;}throw IN(new i_._Q('Character out of range: '+c));};n_.F$=function F$(a){var b,c,d,e,f,g,h;g=n_.V$(a).length;b=0;for(f=0;f<g;){d=VP(a,f,n_.V$(a).length);f+=d>=e0?2:1;d<128?++b:d<V0?b+=2:d<e0?b+=3:d<R0?b+=4:d<q1&&(b+=5);}c=OI(h_.dK,j0,5,b,15,1);h=0;for(e=0;e<g;){d=VP(a,e,n_.V$(a).length);e+=d>=e0?2:1;h+=n_.E$(c,h,d);}return c;};n_.G$=function G$(){n_.B$.call(this,'UTF-8');};xO(153,110,q2,n_.G$);h_.AN=jQ(153);h_.eK=lQ('C');h_.CN=lQ('S');h_.hK=lQ('I');h_.DN=lQ('Z');h_.fK=lQ('D');h_.gK=lQ('F');h_.dK=lQ('B');h_.iK=lQ('J');t_.Gy();_=DO('OCL.Molecule',t_.Ky);_.CANONIZER_ASSIGN_PARITIES_TO_TETRAHEDRAL_N=t_.fv;_.CANONIZER_CONSIDER_DIASTEREOTOPICITY=t_.gv;_.CANONIZER_CONSIDER_ENANTIOTOPICITY=t_.hv;_.CANONIZER_CONSIDER_STEREOHETEROTOPICITY=t_.iv;_.CANONIZER_COORDS_ARE_3D=t_.jv;_.CANONIZER_CREATE_PSEUDO_STEREO_GROUPS=t_.kv;_.CANONIZER_CREATE_SYMMETRY_RANK=t_.lv;_.CANONIZER_DISTINGUISH_RACEMIC_OR_GROUPS=t_.mv;_.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS=t_.nv;_.CANONIZER_ENCODE_ATOM_SELECTION=t_.ov;_.FISCHER_PROJECTION_LIMIT=t_.pv;_.STEREO_ANGLE_LIMIT=t_.qv;_.VALIDATION_ERRORS_STEREO=t_.rv;_.VALIDATION_ERROR_AMBIGUOUS_CONFIGURATION=t_.sv;_.VALIDATION_ERROR_ESR_CENTER_UNKNOWN=t_.tv;_.VALIDATION_ERROR_OVER_UNDER_SPECIFIED=t_.uv;_.cAtomCIPParityNone=t_.vv;_.cAtomCIPParityProblem=t_.wv;_.cAtomCIPParityRorM=t_.xv;_.cAtomCIPParitySorP=t_.yv;_.cAtomColorBlue=t_.zv;_.cAtomColorDarkGreen=t_.Av;_.cAtomColorDarkRed=t_.Bv;_.cAtomColorGreen=t_.Cv;_.cAtomColorMagenta=t_.Dv;_.cAtomColorNone=t_.Ev;_.cAtomColorOrange=t_.Fv;_.cAtomColorRed=t_.Gv;_.cAtomLabel=t_.Hv;_.cAtomParity1=t_.Iv;_.cAtomParity2=t_.Jv;_.cAtomParityIsPseudo=t_.Kv;_.cAtomParityNone=t_.Lv;_.cAtomParityUnknown=t_.Mv;_.cAtomQFAny=t_.Nv;_.cAtomQFAromState=t_.Ov;_.cAtomQFAromStateBits=t_.Pv;_.cAtomQFAromStateShift=t_.Qv;_.cAtomQFAromatic=t_.Rv;_.cAtomQFCharge=t_.Sv;_.cAtomQFChargeBits=t_.Tv;_.cAtomQFChargeShift=t_.Uv;_.cAtomQFExcludeGroup=t_.Vv;_.cAtomQFFlatNitrogen=t_.Wv;_.cAtomQFHydrogen=t_.Xv;_.cAtomQFHydrogenBits=t_.Yv;_.cAtomQFHydrogenShift=t_.Zv;_.cAtomQFMatchStereo=t_.$v;_.cAtomQFMoreNeighbours=t_._v;_.cAtomQFNarrowing=t_.aw;_.cAtomQFNeighbourBits=t_.bw;_.cAtomQFNeighbourShift=t_.cw;_.cAtomQFNeighbours=t_.dw;_.cAtomQFNoMoreNeighbours=t_.ew;_.cAtomQFNoOfBits=t_.fw;_.cAtomQFNot0Hydrogen=t_.gw;_.cAtomQFNot0Neighbours=t_.hw;_.cAtomQFNot0PiElectrons=t_.iw;_.cAtomQFNot1Hydrogen=t_.jw;_.cAtomQFNot1Neighbour=t_.kw;_.cAtomQFNot1PiElectron=t_.lw;_.cAtomQFNot2Hydrogen=t_.mw;_.cAtomQFNot2Neighbours=t_.nw;_.cAtomQFNot2PiElectrons=t_.ow;_.cAtomQFNot2RingBonds=t_.pw;_.cAtomQFNot3Hydrogen=t_.qw;_.cAtomQFNot3Neighbours=t_.rw;_.cAtomQFNot3RingBonds=t_.sw;_.cAtomQFNot4Neighbours=t_.tw;_.cAtomQFNot4RingBonds=t_.uw;_.cAtomQFNotAromatic=t_.vw;_.cAtomQFNotChain=t_.ww;_.cAtomQFNotCharge0=t_.xw;_.cAtomQFNotChargeNeg=t_.yw;_.cAtomQFNotChargePos=t_.zw;_.cAtomQFPiElectronBits=t_.Aw;_.cAtomQFPiElectronShift=t_.Bw;_.cAtomQFPiElectrons=t_.Cw;_.cAtomQFRingSize=t_.Dw;_.cAtomQFRingSizeBits=t_.Ew;_.cAtomQFRingSizeShift=t_.Fw;_.cAtomQFRingState=t_.Gw;_.cAtomQFRingStateBits=t_.Hw;_.cAtomQFRingStateShift=t_.Iw;_.cAtomQFRxnParityBits=t_.Jw;_.cAtomQFRxnParityHint=t_.Kw;_.cAtomQFRxnParityInvert=t_.Lw;_.cAtomQFRxnParityRacemize=t_.Mw;_.cAtomQFRxnParityRetain=t_.Nw;_.cAtomQFRxnParityShift=t_.Ow;_.cAtomQFSimpleFeatures=t_.Pw;_.cAtomRadicalState=t_.Qw;_.cAtomRadicalStateD=t_.Rw;_.cAtomRadicalStateNone=t_.Sw;_.cAtomRadicalStateS=t_.Tw;_.cAtomRadicalStateShift=t_.Uw;_.cAtomRadicalStateT=t_.Vw;_.cBondCIPParityEorP=t_.Ww;_.cBondCIPParityNone=t_.Xw;_.cBondCIPParityProblem=t_.Yw;_.cBondCIPParityZorM=t_.Zw;_.cBondParityEor1=t_.$w;_.cBondParityNone=t_._w;_.cBondParityUnknown=t_.ax;_.cBondParityZor2=t_.bx;_.cBondQFAllFeatures=t_.cx;_.cBondQFAromState=t_.dx;_.cBondQFAromStateBits=t_.ex;_.cBondQFAromStateShift=t_.fx;_.cBondQFAromatic=t_.gx;_.cBondQFBondTypes=t_.hx;_.cBondQFBondTypesBits=t_.ix;_.cBondQFBondTypesShift=t_.jx;_.cBondQFBridge=t_.kx;_.cBondQFBridgeBits=t_.lx;_.cBondQFBridgeMin=t_.mx;_.cBondQFBridgeMinBits=t_.nx;_.cBondQFBridgeMinShift=t_.ox;_.cBondQFBridgeShift=t_.px;_.cBondQFBridgeSpan=t_.qx;_.cBondQFBridgeSpanBits=t_.rx;_.cBondQFBridgeSpanShift=t_.sx;_.cBondQFDelocalized=t_.tx;_.cBondQFDouble=t_.ux;_.cBondQFMatchStereo=t_.vx;_.cBondQFMetalLigand=t_.wx;_.cBondQFNarrowing=t_.xx;_.cBondQFNoOfBits=t_.yx;_.cBondQFNotAromatic=t_.zx;_.cBondQFNotRing=t_.Ax;_.cBondQFRing=t_.Bx;_.cBondQFRingSize=t_.Cx;_.cBondQFRingSizeBits=t_.Dx;_.cBondQFRingSizeShift=t_.Ex;_.cBondQFRingState=t_.Fx;_.cBondQFRingStateBits=t_.Gx;_.cBondQFRingStateShift=t_.Hx;_.cBondQFSimpleFeatures=t_.Ix;_.cBondQFSingle=t_.Jx;_.cBondQFTriple=t_.Kx;_.cBondTypeCross=t_.Lx;_.cBondTypeDeleted=t_.Mx;_.cBondTypeDelocalized=t_.Nx;_.cBondTypeDouble=t_.Ox;_.cBondTypeDown=t_.Px;_.cBondTypeIncreaseOrder=t_.Qx;_.cBondTypeMetalLigand=t_.Rx;_.cBondTypeSingle=t_.Sx;_.cBondTypeTriple=t_.Tx;_.cBondTypeUp=t_.Ux;_.cChiralityDiastereomers=t_.Vx;_.cChiralityEpimers=t_.Wx;_.cChiralityIsomerCountMask=t_.Xx;_.cChiralityKnownEnantiomer=t_.Yx;_.cChiralityMeso=t_.Zx;_.cChiralityNotChiral=t_.$x;_.cChiralityRacemic=t_._x;_.cChiralityUnknown=t_.ay;_.cChiralityUnknownEnantiomer=t_.by;_.cDefaultAtomValence=t_.cy;_.cESRGroupBits=t_.dy;_.cESRMaxGroups=t_.ey;_.cESRTypeAbs=t_.fy;_.cESRTypeAnd=t_.gy;_.cESRTypeOr=t_.hy;_.cHelperBitCIP=t_.iy;_.cHelperBitIncludeNitrogenParities=t_.jy;_.cHelperBitNeighbours=t_.ky;_.cHelperBitParities=t_.ly;_.cHelperBitRings=t_.my;_.cHelperBitSymmetryDiastereotopic=t_.ny;_.cHelperBitSymmetryEnantiotopic=t_.oy;_.cHelperBitSymmetrySimple=t_.py;_.cHelperBitsStereo=t_.qy;_.cHelperCIP=t_.ry;_.cHelperNeighbours=t_.sy;_.cHelperNone=t_.ty;_.cHelperParities=t_.uy;_.cHelperRings=t_.vy;_.cHelperSymmetryDiastereotopic=t_.wy;_.cHelperSymmetryEnantiotopic=t_.xy;_.cHelperSymmetrySimple=t_.yy;_.cMaxAtomicNo=t_.zy;_.cMaxConnAtoms=t_.Ay;_.cMoleculeColorDefault=t_.By;_.cMoleculeColorNeutral=t_.Cy;_.cRoundedMass=t_.Dy;_.fromIDCode=t_.Dz;_.fromMolfile=t_.Gz;_.fromMolfileWithAtomMap=t_.Hz;_.fromSmiles=t_.Iz;_.getAngle=t_.Rz;_.getAngleDif=t_.Sz;_.getAtomicNoFromLabel=t_.qA;_.getDefaultAverageBondLength=t_.UA;_.isAtomicNoElectronegative=t_.ZB;_.isAtomicNoElectropositive=t_.$B;_.setDefaultAverageBondLength=t_.wD;_=DO('OCL.Reaction');_.create=t_.iE;_.fromMolecules=t_.jE;_.fromRxn=t_.kE;_.fromSmiles=t_.lE;_=DO('OCL.RingCollection');_.MAX_SMALL_RING_SIZE=t_.LE;_.MODE_SMALL_AND_LARGE_RINGS=t_.ME;_.MODE_SMALL_AND_LARGE_RINGS_AND_AROMATICITY=t_.NE;_.MODE_SMALL_RINGS_AND_AROMATICITY=t_.OE;_.MODE_SMALL_RINGS_ONLY=t_.PE;_=DO('OCL.SDFileParser',t_.hF);_=DO('OCL.SSSearcher',t_.tF);_=DO('OCL.SSSearcherWithIndex',t_.AF);_.bitCount=t_.BF;_.getHexStringFromIndex=t_.DF;_.getIndexFromHexString=t_.EF;_.getKeyIDCode=t_.FF;_.getSimilarityAngleCosine=t_.HF;_.getSimilarityTanimoto=t_.IF;_=DO('OCL.Util',t_.MF);_.getHoseCodesFromDiastereotopicID=t_.NF;_=DO('java.io.Serializable');_.$isInstance=rP;i_.KP();_=DO('java.lang.Boolean');_.$isInstance=QP;_=DO('java.lang.CharSequence');_.$isInstance=TP;_=DO('java.lang.Cloneable');_.$isInstance=xQ;_=DO('java.lang.Comparable');_.$isInstance=yQ;_=DO('java.lang.Double');_.$isInstance=IQ;_=DO('java.lang.Number');_.$isInstance=i_.AQ;_=DO('java.lang.String');_.$isInstance=MR;_=DO('java.lang.Throwable');_.of=AG;var g_=(k_.nH(),qH);var gwtOnLoad=gwtOnLoad=rO;pO(GO);sO('permProps',[[['locale','default'],['user.agent','safari']]]);gwtOnLoad(__gwtModuleFunction.__errFn,__gwtModuleFunction.__moduleName,__gwtModuleFunction.__moduleBase,__gwtModuleFunction.__softPermutationId,__gwtModuleFunction.__computePropValue);$gwt&&$gwt.permProps&&__gwtModuleFunction.__moduleStartupDone($gwt.permProps);// End GWT code
  var toReturn=$wnd["OCL"];toReturn.version='7.4.0';return toReturn;}var isBrowser,globalEnv;if(typeof self!=='undefined'){// Usual Browser Window or Web Worker
  isBrowser=true;globalEnv=self;}else if(typeof commonjsGlobal!=='undefined'){// Node.js
  isBrowser=false;globalEnv=commonjsGlobal;}else {// Other environment (example: CouchDB)
  isBrowser=false;globalEnv=root;}var document=globalEnv.document||{};if(!document.compatMode){document.compatMode='CSS1Compat';}var fakeWindow;if(isBrowser&&!true){fakeWindow=globalEnv;}else {fakeWindow={};fakeWindow.setTimeout=globalEnv.setTimeout?globalEnv.setTimeout.bind(globalEnv):noop;fakeWindow.clearTimeout=globalEnv.clearTimeout?globalEnv.clearTimeout.bind(globalEnv):noop;fakeWindow.setInterval=globalEnv.setInterval?globalEnv.setInterval.bind(globalEnv):noop;fakeWindow.clearInterval=globalEnv.clearInterval?globalEnv.clearInterval.bind(globalEnv):noop;// required since GWT 2.8.0
  fakeWindow.Error=globalEnv.Error;fakeWindow.Math=globalEnv.Math;fakeWindow.RegExp=globalEnv.RegExp;fakeWindow.TypeError=globalEnv.TypeError;}if(!fakeWindow.document){fakeWindow.document=document;}var exportedApi=getExports(fakeWindow);{// NodeJS
  fillExports(exportedApi,exports);}function fillExports(obj,exports){var keys=Object.keys(obj);for(var i=0;i<keys.length;i++){exports[keys[i]]=obj[keys[i]];}}function noop(){}})(commonjsGlobal);})(openchemlibMinimal);

  var minimal = openchemlibMinimal;

  function createInputJSON(molecule, options) {
    const {
      levels
    } = options;
    let diaIDs = getGroupedDiastereotopicAtomIDs(molecule);
    diaIDs = diaIDs.filter(e => e.atomLabel === 'C').sort(function (a, b) {
      if (a.atomLabel === b.atomLabel) {
        return b.counter - a.counter;
      }

      return a.atomLabel < b.atomLabel ? 1 : -1;
    });
    const atoms = {};

    for (const diaId of diaIDs) {
      diaId.hose = getHoseCodesFromDiastereotopicID(minimal.Molecule.fromIDCode(diaId.oclID), {
        maxSphereSize: levels[0]
      });

      for (const atomID of diaId.atoms) {
        atoms[atomID] = diaId.oclID;
      }
    }

    let toReturn = {
      id: molecule.getIDCode(),
      atom: atoms,
      diaIDs
    };
    return toReturn;
  }

  function queryByHose(input, db, options) {
    const {
      levels
    } = options;
    levels.sort((a, b) => b - a);
    const toReturn = [];

    for (const element of input.diaIDs) {
      let res;
      let k = 0;

      while (!res && k < levels.length) {
        if (db[levels[k]]) {
          res = db[levels[k]][element.hose[levels[k]]];
        }

        k++;
      }

      if (!res) {
        res = [null];
        k = 0;
      }

      for (const atomNumber of element.atoms) {
        let atom = {
          diaIDs: [element.oclID]
        };
        atom.delta = res[0];
        atom.atomIDs = [atomNumber];
        atom.nbAtoms = 1;
        toReturn.push(atom);
      }
    }

    return toReturn;
  }

  const cache = {};

  async function loadDB(url = 'https://www.lactame.com/lib/nmr-processing/data/20210711/carbon.js') {
    if (cache[url]) {
      return cache[url];
    }

    const response = await fetch(url);
    cache[url] = await response.json();
    return cache[url];
  }

  async function predictCarbon(molecule, options = {}) {
    let {
      levels = [3, 2, 1, 0],
      url,
      database
    } = options;
    database = database || (await loadDB(url));
    molecule.addImplicitHydrogens();
    molecule.addMissingChirality();
    addDiastereotopicMissingChirality(molecule);
    const molfile = molecule.toMolfile();
    const inputJSON = createInputJSON(molecule, {
      levels
    });
    let predictions = queryByHose(inputJSON, database, {
      levels
    });
    const signals = formatSignals(predictions);
    const joinedSignals = joinSignalByDiaID(signals);
    return {
      molfile,
      diaIDs: inputJSON.diaIDs.map(e => e.diaId),
      joinedSignals,
      signals,
      ranges: signalsToRanges(joinedSignals)
    };
  }

  function formatSignals(predictions) {
    let signals = [];

    for (const prediction of predictions) {
      const {
        atomIDs,
        nbAtoms,
        delta,
        diaIDs
      } = prediction;
      signals.push({
        delta,
        assignment: atomIDs,
        diaID: diaIDs,
        nbAtoms,
        j: []
      });
    }

    return signals;
  }

  function joinSignalByDiaID(signals) {
    let joinedSignals = {};

    for (let signal of signals) {
      let diaID = signal.diaID[0];

      if (!joinedSignals[diaID]) {
        joinedSignals[diaID] = JSON.parse(JSON.stringify(signal));
      } else {
        joinedSignals[diaID].nbAtoms += signal.nbAtoms;
        joinedSignals[diaID].assignment.push(...signal.assignment);
      }
    }

    return Object.values(joinedSignals);
  }

  var src = {};

  var fftlib = {};

  /**
   * Fast Fourier Transform module
   * 1D-FFT/IFFT, 2D-FFT/IFFT (radix-2)
   */

  (function (exports) {
    (function () {
      var FFT;

      {
        FFT = exports; // for CommonJS
      }

      var version = {
        release: '0.3.0',
        date: '2013-03'
      };

      FFT.toString = function () {
        return "version " + version.release + ", released " + version.date;
      }; // core operations


      var _n = 0,
          // order
      _bitrev = null,
          // bit reversal table
      _cstb = null; // sin/cos table

      var core = {
        init: function (n) {
          if (n !== 0 && (n & n - 1) === 0) {
            _n = n;

            core._initArray();

            core._makeBitReversalTable();

            core._makeCosSinTable();
          } else {
            throw new Error("init: radix-2 required");
          }
        },
        // 1D-FFT
        fft1d: function (re, im) {
          core.fft(re, im, 1);
        },
        // 1D-IFFT
        ifft1d: function (re, im) {
          var n = 1 / _n;
          core.fft(re, im, -1);

          for (var i = 0; i < _n; i++) {
            re[i] *= n;
            im[i] *= n;
          }
        },
        // 1D-IFFT
        bt1d: function (re, im) {
          core.fft(re, im, -1);
        },
        // 2D-FFT Not very useful if the number of rows have to be equal to cols
        fft2d: function (re, im) {
          var tre = [],
              tim = [],
              i = 0; // x-axis

          for (var y = 0; y < _n; y++) {
            i = y * _n;

            for (var x1 = 0; x1 < _n; x1++) {
              tre[x1] = re[x1 + i];
              tim[x1] = im[x1 + i];
            }

            core.fft1d(tre, tim);

            for (var x2 = 0; x2 < _n; x2++) {
              re[x2 + i] = tre[x2];
              im[x2 + i] = tim[x2];
            }
          } // y-axis


          for (var x = 0; x < _n; x++) {
            for (var y1 = 0; y1 < _n; y1++) {
              i = x + y1 * _n;
              tre[y1] = re[i];
              tim[y1] = im[i];
            }

            core.fft1d(tre, tim);

            for (var y2 = 0; y2 < _n; y2++) {
              i = x + y2 * _n;
              re[i] = tre[y2];
              im[i] = tim[y2];
            }
          }
        },
        // 2D-IFFT
        ifft2d: function (re, im) {
          var tre = [],
              tim = [],
              i = 0; // x-axis

          for (var y = 0; y < _n; y++) {
            i = y * _n;

            for (var x1 = 0; x1 < _n; x1++) {
              tre[x1] = re[x1 + i];
              tim[x1] = im[x1 + i];
            }

            core.ifft1d(tre, tim);

            for (var x2 = 0; x2 < _n; x2++) {
              re[x2 + i] = tre[x2];
              im[x2 + i] = tim[x2];
            }
          } // y-axis


          for (var x = 0; x < _n; x++) {
            for (var y1 = 0; y1 < _n; y1++) {
              i = x + y1 * _n;
              tre[y1] = re[i];
              tim[y1] = im[i];
            }

            core.ifft1d(tre, tim);

            for (var y2 = 0; y2 < _n; y2++) {
              i = x + y2 * _n;
              re[i] = tre[y2];
              im[i] = tim[y2];
            }
          }
        },
        // core operation of FFT
        fft: function (re, im, inv) {
          var d,
              h,
              ik,
              m,
              tmp,
              wr,
              wi,
              xr,
              xi,
              n4 = _n >> 2; // bit reversal

          for (var l = 0; l < _n; l++) {
            m = _bitrev[l];

            if (l < m) {
              tmp = re[l];
              re[l] = re[m];
              re[m] = tmp;
              tmp = im[l];
              im[l] = im[m];
              im[m] = tmp;
            }
          } // butterfly operation


          for (var k = 1; k < _n; k <<= 1) {
            h = 0;
            d = _n / (k << 1);

            for (var j = 0; j < k; j++) {
              wr = _cstb[h + n4];
              wi = inv * _cstb[h];

              for (var i = j; i < _n; i += k << 1) {
                ik = i + k;
                xr = wr * re[ik] + wi * im[ik];
                xi = wr * im[ik] - wi * re[ik];
                re[ik] = re[i] - xr;
                re[i] += xr;
                im[ik] = im[i] - xi;
                im[i] += xi;
              }

              h += d;
            }
          }
        },
        // initialize the array (supports TypedArray)
        _initArray: function () {
          if (typeof Uint32Array !== 'undefined') {
            _bitrev = new Uint32Array(_n);
          } else {
            _bitrev = [];
          }

          if (typeof Float64Array !== 'undefined') {
            _cstb = new Float64Array(_n * 1.25);
          } else {
            _cstb = [];
          }
        },
        // zero padding
        _paddingZero: function () {// TODO
        },
        // makes bit reversal table
        _makeBitReversalTable: function () {
          var i = 0,
              j = 0,
              k = 0;
          _bitrev[0] = 0;

          while (++i < _n) {
            k = _n >> 1;

            while (k <= j) {
              j -= k;
              k >>= 1;
            }

            j += k;
            _bitrev[i] = j;
          }
        },
        // makes trigonometiric function table
        _makeCosSinTable: function () {
          var n2 = _n >> 1,
              n4 = _n >> 2,
              n8 = _n >> 3,
              n2p4 = n2 + n4,
              t = Math.sin(Math.PI / _n),
              dc = 2 * t * t,
              ds = Math.sqrt(dc * (2 - dc)),
              c = _cstb[n4] = 1,
              s = _cstb[0] = 0;
          t = 2 * dc;

          for (var i = 1; i < n8; i++) {
            c -= dc;
            dc += t * c;
            s += ds;
            ds -= t * s;
            _cstb[i] = s;
            _cstb[n4 - i] = c;
          }

          if (n8 !== 0) {
            _cstb[n8] = Math.sqrt(0.5);
          }

          for (var j = 0; j < n4; j++) {
            _cstb[n2 - j] = _cstb[j];
          }

          for (var k = 0; k < n2p4; k++) {
            _cstb[k + n2] = -_cstb[k];
          }
        }
      }; // aliases (public APIs)

      var apis = ['init', 'fft1d', 'ifft1d', 'fft2d', 'ifft2d'];

      for (var i = 0; i < apis.length; i++) {
        FFT[apis[i]] = core[apis[i]];
      }

      FFT.bt = core.bt1d;
      FFT.fft = core.fft1d;
      FFT.ifft = core.ifft1d;
      return FFT;
    }).call(commonjsGlobal);
  })(fftlib);

  var FFT = fftlib;
  var FFTUtils$1 = {
    DEBUG: false,

    /**
     * Calculates the inverse of a 2D Fourier transform
     *
     * @param ft
     * @param ftRows
     * @param ftCols
     * @return
     */
    ifft2DArray: function (ft, ftRows, ftCols) {
      var tempTransform = new Array(ftRows * ftCols);
      var nRows = ftRows / 2;
      var nCols = (ftCols - 1) * 2; // reverse transform columns

      FFT.init(nRows);
      var tmpCols = {
        re: new Array(nRows),
        im: new Array(nRows)
      };

      for (var iCol = 0; iCol < ftCols; iCol++) {
        for (var iRow = nRows - 1; iRow >= 0; iRow--) {
          tmpCols.re[iRow] = ft[iRow * 2 * ftCols + iCol];
          tmpCols.im[iRow] = ft[(iRow * 2 + 1) * ftCols + iCol];
        } //Unnormalized inverse transform


        FFT.bt(tmpCols.re, tmpCols.im);

        for (var iRow = nRows - 1; iRow >= 0; iRow--) {
          tempTransform[iRow * 2 * ftCols + iCol] = tmpCols.re[iRow];
          tempTransform[(iRow * 2 + 1) * ftCols + iCol] = tmpCols.im[iRow];
        }
      } // reverse row transform


      var finalTransform = new Array(nRows * nCols);
      FFT.init(nCols);
      var tmpRows = {
        re: new Array(nCols),
        im: new Array(nCols)
      };
      var scale = nCols * nRows;

      for (var iRow = 0; iRow < ftRows; iRow += 2) {
        tmpRows.re[0] = tempTransform[iRow * ftCols];
        tmpRows.im[0] = tempTransform[(iRow + 1) * ftCols];

        for (var iCol = 1; iCol < ftCols; iCol++) {
          tmpRows.re[iCol] = tempTransform[iRow * ftCols + iCol];
          tmpRows.im[iCol] = tempTransform[(iRow + 1) * ftCols + iCol];
          tmpRows.re[nCols - iCol] = tempTransform[iRow * ftCols + iCol];
          tmpRows.im[nCols - iCol] = -tempTransform[(iRow + 1) * ftCols + iCol];
        } //Unnormalized inverse transform


        FFT.bt(tmpRows.re, tmpRows.im);
        var indexB = iRow / 2 * nCols;

        for (var iCol = nCols - 1; iCol >= 0; iCol--) {
          finalTransform[indexB + iCol] = tmpRows.re[iCol] / scale;
        }
      }

      return finalTransform;
    },

    /**
     * Calculates the fourier transform of a matrix of size (nRows,nCols) It is
     * assumed that both nRows and nCols are a power of two
     *
     * On exit the matrix has dimensions (nRows * 2, nCols / 2 + 1) where the
     * even rows contain the real part and the odd rows the imaginary part of the
     * transform
     * @param data
     * @param nRows
     * @param nCols
     * @return
     */
    fft2DArray: function (data, nRows, nCols, opt) {
      Object.assign({}, {
        inplace: true
      });
      var ftCols = nCols / 2 + 1;
      var ftRows = nRows * 2;
      var tempTransform = new Array(ftRows * ftCols);
      FFT.init(nCols); // transform rows

      var tmpRows = {
        re: new Array(nCols),
        im: new Array(nCols)
      };
      var row1 = {
        re: new Array(nCols),
        im: new Array(nCols)
      };
      var row2 = {
        re: new Array(nCols),
        im: new Array(nCols)
      };
      var index, iRow0, iRow1, iRow2, iRow3;

      for (var iRow = 0; iRow < nRows / 2; iRow++) {
        index = iRow * 2 * nCols;
        tmpRows.re = data.slice(index, index + nCols);
        index = (iRow * 2 + 1) * nCols;
        tmpRows.im = data.slice(index, index + nCols);
        FFT.fft1d(tmpRows.re, tmpRows.im);
        this.reconstructTwoRealFFT(tmpRows, row1, row2); //Now lets put back the result into the output array

        iRow0 = iRow * 4 * ftCols;
        iRow1 = (iRow * 4 + 1) * ftCols;
        iRow2 = (iRow * 4 + 2) * ftCols;
        iRow3 = (iRow * 4 + 3) * ftCols;

        for (var k = ftCols - 1; k >= 0; k--) {
          tempTransform[iRow0 + k] = row1.re[k];
          tempTransform[iRow1 + k] = row1.im[k];
          tempTransform[iRow2 + k] = row2.re[k];
          tempTransform[iRow3 + k] = row2.im[k];
        }
      } //console.log(tempTransform);


      row1 = null;
      row2 = null; // transform columns

      var finalTransform = new Array(ftRows * ftCols);
      FFT.init(nRows);
      var tmpCols = {
        re: new Array(nRows),
        im: new Array(nRows)
      };

      for (var iCol = ftCols - 1; iCol >= 0; iCol--) {
        for (var iRow = nRows - 1; iRow >= 0; iRow--) {
          tmpCols.re[iRow] = tempTransform[iRow * 2 * ftCols + iCol];
          tmpCols.im[iRow] = tempTransform[(iRow * 2 + 1) * ftCols + iCol]; //TODO Chech why this happens

          if (isNaN(tmpCols.re[iRow])) {
            tmpCols.re[iRow] = 0;
          }

          if (isNaN(tmpCols.im[iRow])) {
            tmpCols.im[iRow] = 0;
          }
        }

        FFT.fft1d(tmpCols.re, tmpCols.im);

        for (var iRow = nRows - 1; iRow >= 0; iRow--) {
          finalTransform[iRow * 2 * ftCols + iCol] = tmpCols.re[iRow];
          finalTransform[(iRow * 2 + 1) * ftCols + iCol] = tmpCols.im[iRow];
        }
      } //console.log(finalTransform);


      return finalTransform;
    },

    /**
     *
     * @param fourierTransform
     * @param realTransform1
     * @param realTransform2
     *
     * Reconstructs the individual Fourier transforms of two simultaneously
     * transformed series. Based on the Symmetry relationships (the asterisk
     * denotes the complex conjugate)
     *
     * F_{N-n} = F_n^{*} for a purely real f transformed to F
     *
     * G_{N-n} = G_n^{*} for a purely imaginary g transformed to G
     *
     */
    reconstructTwoRealFFT: function (fourierTransform, realTransform1, realTransform2) {
      var length = fourierTransform.re.length; // the components n=0 are trivial

      realTransform1.re[0] = fourierTransform.re[0];
      realTransform1.im[0] = 0.0;
      realTransform2.re[0] = fourierTransform.im[0];
      realTransform2.im[0] = 0.0;
      var rm, rp, im, ip, j;

      for (var i = length / 2; i > 0; i--) {
        j = length - i;
        rm = 0.5 * (fourierTransform.re[i] - fourierTransform.re[j]);
        rp = 0.5 * (fourierTransform.re[i] + fourierTransform.re[j]);
        im = 0.5 * (fourierTransform.im[i] - fourierTransform.im[j]);
        ip = 0.5 * (fourierTransform.im[i] + fourierTransform.im[j]);
        realTransform1.re[i] = rp;
        realTransform1.im[i] = im;
        realTransform1.re[j] = rp;
        realTransform1.im[j] = -im;
        realTransform2.re[i] = ip;
        realTransform2.im[i] = -rm;
        realTransform2.re[j] = ip;
        realTransform2.im[j] = rm;
      }
    },

    /**
     * In place version of convolute 2D
     *
     * @param ftSignal
     * @param ftFilter
     * @param ftRows
     * @param ftCols
     * @return
     */
    convolute2DI: function (ftSignal, ftFilter, ftRows, ftCols) {
      var re, im;

      for (var iRow = 0; iRow < ftRows / 2; iRow++) {
        for (var iCol = 0; iCol < ftCols; iCol++) {
          //
          re = ftSignal[iRow * 2 * ftCols + iCol] * ftFilter[iRow * 2 * ftCols + iCol] - ftSignal[(iRow * 2 + 1) * ftCols + iCol] * ftFilter[(iRow * 2 + 1) * ftCols + iCol];
          im = ftSignal[iRow * 2 * ftCols + iCol] * ftFilter[(iRow * 2 + 1) * ftCols + iCol] + ftSignal[(iRow * 2 + 1) * ftCols + iCol] * ftFilter[iRow * 2 * ftCols + iCol]; //

          ftSignal[iRow * 2 * ftCols + iCol] = re;
          ftSignal[(iRow * 2 + 1) * ftCols + iCol] = im;
        }
      }
    },

    /**
     *
     * @param data
     * @param kernel
     * @param nRows
     * @param nCols
     * @returns {*}
     */
    convolute: function (data, kernel, nRows, nCols, opt) {
      var ftSpectrum = new Array(nCols * nRows);

      for (var i = 0; i < nRows * nCols; i++) {
        ftSpectrum[i] = data[i];
      }

      ftSpectrum = this.fft2DArray(ftSpectrum, nRows, nCols);
      var dimR = kernel.length;
      var dimC = kernel[0].length;
      var ftFilterData = new Array(nCols * nRows);

      for (var i = 0; i < nCols * nRows; i++) {
        ftFilterData[i] = 0;
      }

      var iRow, iCol;
      var shiftR = Math.floor((dimR - 1) / 2);
      var shiftC = Math.floor((dimC - 1) / 2);

      for (var ir = 0; ir < dimR; ir++) {
        iRow = (ir - shiftR + nRows) % nRows;

        for (var ic = 0; ic < dimC; ic++) {
          iCol = (ic - shiftC + nCols) % nCols;
          ftFilterData[iRow * nCols + iCol] = kernel[ir][ic];
        }
      }

      ftFilterData = this.fft2DArray(ftFilterData, nRows, nCols);
      var ftRows = nRows * 2;
      var ftCols = nCols / 2 + 1;
      this.convolute2DI(ftSpectrum, ftFilterData, ftRows, ftCols);
      return this.ifft2DArray(ftSpectrum, ftRows, ftCols);
    },
    toRadix2: function (data, nRows, nCols) {
      var i, j, irow, icol;
      var cols = nCols,
          rows = nRows;

      if (!(nCols !== 0 && (nCols & nCols - 1) === 0)) {
        //Then we have to make a pading to next radix2
        cols = 0;

        while (nCols >> ++cols != 0);

        cols = 1 << cols;
      }

      if (!(nRows !== 0 && (nRows & nRows - 1) === 0)) {
        //Then we have to make a pading to next radix2
        rows = 0;

        while (nRows >> ++rows != 0);

        rows = 1 << rows;
      }

      if (rows == nRows && cols == nCols) //Do nothing. Returns the same input!!! Be careful
        return {
          data: data,
          rows: nRows,
          cols: nCols
        };
      var output = new Array(rows * cols);
      var shiftR = Math.floor((rows - nRows) / 2) - nRows;
      var shiftC = Math.floor((cols - nCols) / 2) - nCols;

      for (i = 0; i < rows; i++) {
        irow = i * cols;
        icol = (i - shiftR) % nRows * nCols;

        for (j = 0; j < cols; j++) {
          output[irow + j] = data[icol + (j - shiftC) % nCols];
        }
      }

      return {
        data: output,
        rows: rows,
        cols: cols
      };
    },

    /**
     * Crop the given matrix to fit the corresponding number of rows and columns
     */
    crop: function (data, rows, cols, nRows, nCols, opt) {
      if (rows == nRows && cols == nCols) //Do nothing. Returns the same input!!! Be careful
        return data;
      Object.assign({}, opt);
      var output = new Array(nCols * nRows);
      var shiftR = Math.floor((rows - nRows) / 2);
      var shiftC = Math.floor((cols - nCols) / 2);
      var destinyRow, sourceRow, i, j;

      for (i = 0; i < nRows; i++) {
        destinyRow = i * nCols;
        sourceRow = (i + shiftR) * cols;

        for (j = 0; j < nCols; j++) {
          output[destinyRow + j] = data[sourceRow + (j + shiftC)];
        }
      }

      return output;
    }
  };
  var FFTUtils_1 = FFTUtils