!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).nmrProcessing={})}(this,(function(exports){"use strict";const gyromagneticRatio={"1H":267522187.44,"2H":41065e3,"3H":285350800,"3He":-203789e3,"7Li":103962e3,"13C":67282840,"14N":19331e3,"15N":-27116e3,"17O":-36264e3,"19F":251662e3,"23Na":70761e3,"27Al":69763e3,"29Si":-5319e4,"31P":108291e3,"57Fe":8681e3,"63Cu":71118e3,"67Zn":16767e3,"129Xe":-73997e3},impurities={cdcl3:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"ds",shift:7.26}],h2o:[{proton:"H2O",coupling:0,multiplicity:"bs",shift:1.56}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.17}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.28}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.19},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.98},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.01},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.27},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.43}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.26}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.73}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.3}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.21},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.48}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.65},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.57},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.39}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.4},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.55}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.09},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.02},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.88}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.62}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.71}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.25},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.72},{proton:"OH",coupling:5,multiplicity:"s,t",shift:1.32}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.05},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.12},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.14},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.46},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.06}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.76}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.26}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.26}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.65}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.49},{proton:"OH",coupling:0,multiplicity:"s",shift:1.09}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.33}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:7},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.22},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.04}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.62},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.29},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.68}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.07}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.85},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.76}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.17},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.03},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.53}]},"(cd3)2co":{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:2.05}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.84}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.05}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.13},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.96},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.41}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.87}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.63}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.41}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.56},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.47},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.28}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.46}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.78}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.52}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.59}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.57},{proton:"OH",coupling:5,multiplicity:"s,t",shift:3.39}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.05},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.45},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.28}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.87},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.59}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"OH",coupling:0,multiplicity:"s",shift:3.12}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.43}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.1},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.9}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.35},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.76}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.13}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.79},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.63}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.5},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.5}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},dmso:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"quint",shift:2.5}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:3.33}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.91}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.07}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.19}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.08}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.87},{proton:"OHc",coupling:0,multiplicity:"s",shift:6.65},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.18},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.36}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.32}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.76}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.09},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.38}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.51},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.38},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.24}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.24},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.43}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.78}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.95},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.73}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.54}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.57}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.06},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.44},{proton:"OH",coupling:5,multiplicity:"s,t",shift:4.63}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.99},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.03},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.17}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.91}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.34}],"grease^f":[],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.25}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.53}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.16},{proton:"OH",coupling:0,multiplicity:"s",shift:4.01}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.42}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.04},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.78}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.39},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.79}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.76},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.6}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.3},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.18},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.93},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.43}]},c6d6:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:7.16}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:.4}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.15}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:1.55}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.07},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.04}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:7.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.79},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.24},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.38}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:6.15}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:2.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:4.27}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.26}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.46},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.34},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.11}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.12},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.33}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.6},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.57},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.05}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.63},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH3",coupling:0,multiplicity:"s",shift:1.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.68}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.35}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.34}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.65},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.89},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.92}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.58},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:1.81},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.85}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.41}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.92},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.36}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.24}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.4}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.07}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.23}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:.95},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.67}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:6.66},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:6.98}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.29}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.4},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.57}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.11},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.02},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.13}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.4}]},cd3cn:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:1.94}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.13}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.16},{proton:"OHc",coupling:0,multiplicity:"s",shift:2.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.14},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.97},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.2},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.39}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.58}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.44}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.81}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.44}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.42}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.53},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.45},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.29}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.45}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.77}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.5}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.54},{proton:"OH",coupling:5,multiplicity:"s,t",shift:2.47}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.06},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.06},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.51}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.27}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.57}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"OH",coupling:0,multiplicity:"s",shift:2.16}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.31}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.87},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.09},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.87}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.57},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.33},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.73}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.08}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.8},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.64}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.33},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.2},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.2}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},cd3od:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:3.31}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:4.87}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.99}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.15}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.03}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.33}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.4}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.15},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.2}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.92},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.21},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.4}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.9}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.45}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.78}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.49}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.18},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.49}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.58},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.35}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.35},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.52}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.92}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.97},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.99},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.65}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.66}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.19},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.6}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.01},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.09},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.12},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.5},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.01}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.59}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.88},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.9},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.64}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.34}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.5},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.92}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.44},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.85}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.1}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.87},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.71}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.16},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.16}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.05},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.58}]},d2o:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:4.79}],h2o:[],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.22}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.06}],benzene:[],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.24}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.21},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[],chloroform:[],cyclohexane:[],"1,2-dichloroethane":[],dichloromethane:[],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.56}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.67},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.37}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.37},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.08},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.06},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.9}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:3.01},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.85}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.71}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.75}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.65}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.14},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.19},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.18},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.65}],"grease^f":[],"n-hexane":[],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.61}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.4}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.9}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.17},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.02}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.52},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.45},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.87}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.88},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.74}],toluene:[],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.99},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.57}]}},SignalKinds=[{label:"Signal",value:"signal"},{label:"Reference",value:"reference"},{label:"Solvent",value:"solvent"},{label:"Impurity",value:"impurity"},{label:"Standard",value:"standard"},{label:"P1",value:"p1"},{label:"P2",value:"p2"},{label:"P3",value:"p3"}],SignalKindsToInclude=["signal"],DatumKind={signal:"signal",mixed:"mixed"},MultiplicityPatterns=[{label:"singlet",value:"s",multiplicity:1,names:["br s"]},{label:"triplet",value:"t",multiplicity:3,names:[]},{label:"doublet",value:"d",multiplicity:2,names:[]},{label:"quartet",value:"q",multiplicity:4,names:[]},{label:"quintet",value:"i",acs:"quint",multiplicity:5,names:["quint","qui","qnt","pentet","pnt","pent"]},{label:"sextet",value:"h",multiplicity:6,names:["x","sxt","sext","hexuplet"]},{label:"septet",value:"p",acs:"sept",multiplicity:7,names:["sept","spt","heptet","hpt","hept"]},{label:"octet",value:"o",multiplicity:8,names:["oct"]},{label:"nonet",value:"n",multiplicity:9,names:["non"]},{label:"massive",value:"m",multiplicity:null,names:[]}];MultiplicityPatterns.sort(((t,e)=>null!==t.multiplicity&&null!==e.multiplicity?t.multiplicity-e.multiplicity:Number.MAX_SAFE_INTEGER));const couplingPatterns=MultiplicityPatterns.map((t=>t.value)),couplingACSPatterns=MultiplicityPatterns.map((t=>t.acs||t.value)),toCheck=["solvent","h2o","tms"];function peaksFilterImpurities(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{solvent:n,error:s=.025,remove:i=!1}=e;if(n){"(cd3)2so"===n&&(n="dmso"),"meod"===n&&(n="cd3od");let e=impurities[n];for(let n of toCheck){checkImpurity(t,e[n],{error:s,remove:i,name:n})}}return t}function checkImpurity(t,e,n){let s,i,o,{name:a,error:l,remove:r}=n,m=e.length;for(;m--;)for(s=t.length;s--;)i=l+t[s].width,o=Math.abs(e[m].shift-t[s].x),o<i&&(r?t.splice(s,1):t[s].kind=a)}const GAUSSIAN_EXP_FACTOR=-4*Math.LN2,ROOT_PI_OVER_LN2=Math.sqrt(Math.PI/Math.LN2),ROOT_THREE=Math.sqrt(3),ROOT_2LN2=Math.sqrt(2*Math.LN2),ROOT_2LN2_MINUS_ONE=Math.sqrt(2*Math.LN2)-1;function erfinv(t){if(0===t)return 0;let e=Math.log(1-t*t),n=e/2+2/(.147*Math.PI),s=Math.sqrt(n**2-e/.147);return Math.sqrt(s-n)*(t>0?1:-1)}class Gaussian{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const{fwhm:e=500,sd:n}=t;this.fwhm=n?gaussianWidthToFWHM(2*n):e}fwhmToWidth(){return gaussianFwhmToWidth(arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.fwhm)}widthToFWHM(t){return gaussianWidthToFWHM(t)}fct(t){return gaussianFct(t,this.fwhm)}getArea(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:calculateGaussianHeight({fwhm:this.fwhm});return getGaussianArea({fwhm:this.fwhm,height:t})}getFactor(t){return getGaussianFactor(t)}getData(){return getGaussianData(this,arguments.length>0&&void 0!==arguments[0]?arguments[0]:{})}calculateHeight(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return calculateGaussianHeight({fwhm:this.fwhm,area:t})}getParameters(){return["fwhm"]}}function calculateGaussianHeight(t){let{fwhm:e=500,area:n=1,sd:s}=t;return s&&(e=gaussianWidthToFWHM(2*s)),2*n/ROOT_PI_OVER_LN2/e}function gaussianFct(t,e){return Math.exp(GAUSSIAN_EXP_FACTOR*Math.pow(t/e,2))}function gaussianWidthToFWHM(t){return t*ROOT_2LN2}function gaussianFwhmToWidth(t){return t/ROOT_2LN2}function getGaussianArea(t){let{fwhm:e=500,sd:n,height:s=1}=t;return n&&(e=gaussianWidthToFWHM(2*n)),s*ROOT_PI_OVER_LN2*e/2}function getGaussianFactor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:.9999;return Math.sqrt(2)*erfinv(t)}function getGaussianData(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{fwhm:n=500,sd:s}=t;s&&(n=gaussianWidthToFWHM(2*s));let{length:i,factor:o=getGaussianFactor(),height:a=calculateGaussianHeight({fwhm:n})}=e;i||(i=Math.min(Math.ceil(n*o),Math.pow(2,25)-1),i%2==0&&i++);const l=(i-1)/2,r=new Float64Array(i);for(let t=0;t<=l;t++)r[t]=gaussianFct(t-l,n)*a,r[i-1-t]=r[t];return r}class Lorentzian{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const{fwhm:e=500}=t;this.fwhm=e}fwhmToWidth(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.fwhm;return lorentzianFwhmToWidth(t)}widthToFWHM(t){return lorentzianWidthToFWHM(t)}fct(t){return lorentzianFct(t,this.fwhm)}getArea(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return getLorentzianArea({fwhm:this.fwhm,height:t})}getFactor(t){return getLorentzianFactor(t)}getData(){return getLorentzianData(this,arguments.length>0&&void 0!==arguments[0]?arguments[0]:{})}calculateHeight(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return calculateLorentzianHeight({fwhm:this.fwhm,area:t})}getParameters(){return["fwhm"]}}const calculateLorentzianHeight=t=>{let{fwhm:e=1,area:n=1}=t;return 2*n/Math.PI/e},getLorentzianArea=t=>{const{fwhm:e=500,height:n=1}=t;return n*Math.PI*e/2},lorentzianFct=(t,e)=>e**2/(4*t**2+e**2),lorentzianWidthToFWHM=t=>t*ROOT_THREE,lorentzianFwhmToWidth=t=>t/ROOT_THREE,getLorentzianFactor=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:.9999;if(t>=1)throw new Error("area should be (0 - 1)");const e=.5*(1-t),n=t=>Math.tan(Math.PI*(t-.5));return(n(1-e)-n(e))/2},getLorentzianData=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{fwhm:n=500}=t,{length:s,factor:i=getLorentzianFactor(),height:o=calculateLorentzianHeight({fwhm:n,area:1})}=e;s||(s=Math.min(Math.ceil(n*i),Math.pow(2,25)-1),s%2==0&&s++);const a=(s-1)/2,l=new Float64Array(s);for(let t=0;t<=a;t++)l[t]=lorentzianFct(t-a,n)*o,l[s-1-t]=l[t];return l};class PseudoVoigt{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const{fwhm:e=500,mu:n=.5}=t;this.mu=n,this.fwhm=e}fwhmToWidth(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.fwhm,e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.mu;return pseudoVoigtFwhmToWidth(t,e)}widthToFWHM(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.mu;return pseudoVoigtWidthToFWHM(t,e)}fct(t){return pseudoVoigtFct(t,this.fwhm,this.mu)}getArea(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return getPseudoVoigtArea({fwhm:this.fwhm,height:t,mu:this.mu})}getFactor(t){return getPseudoVoigtFactor(t)}getData(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const{length:e,factor:n,height:s=calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:1})}=t;return getPseudoVoigtData(this,{factor:n,length:e,height:s})}calculateHeight(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:t})}getParameters(){return["fwhm","mu"]}}const calculatePseudoVoigtHeight=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{fwhm:e=1,mu:n=.5,area:s=1}=t;return 2*s/(e*(n*ROOT_PI_OVER_LN2+(1-n)*Math.PI))},pseudoVoigtFct=(t,e,n)=>(1-n)*lorentzianFct(t,e)+n*gaussianFct(t,e),pseudoVoigtWidthToFWHM=function(t){return t*((arguments.length>1&&void 0!==arguments[1]?arguments[1]:.5)*ROOT_2LN2_MINUS_ONE+1)},pseudoVoigtFwhmToWidth=function(t){return t/((arguments.length>1&&void 0!==arguments[1]?arguments[1]:.5)*ROOT_2LN2_MINUS_ONE+1)},getPseudoVoigtArea=t=>{const{fwhm:e=500,height:n=1,mu:s=.5}=t;return e*n*(s*ROOT_PI_OVER_LN2+(1-s)*Math.PI)/2},getPseudoVoigtFactor=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:.9999;return(arguments.length>1&&void 0!==arguments[1]?arguments[1]:.5)<1?getLorentzianFactor(t):getGaussianFactor(t)},getPseudoVoigtData=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{fwhm:n=500,mu:s=.5}=t,{length:i,factor:o=getPseudoVoigtFactor(.999,s),height:a=calculatePseudoVoigtHeight({fwhm:n,mu:s,area:1})}=e;a||(a=1/(s/Math.sqrt(-GAUSSIAN_EXP_FACTOR/Math.PI)*n+(1-s)*n*Math.PI/2)),i||(i=Math.min(Math.ceil(n*o),Math.pow(2,25)-1),i%2==0&&i++);const l=(i-1)/2,r=new Float64Array(i);for(let t=0;t<=l;t++)r[t]=pseudoVoigtFct(t-l,n,s)*a,r[i-1-t]=r[t];return r};class Gaussian2D{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{fwhm:e=20,sd:n}=t;e=ensureFWHM2D(e,n),this.fwhmX=e.x,this.fwhmY=e.y}fct(t,e){return gaussian2DFct(t,e,this.fwhmX,this.fwhmY)}getData(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return getGaussian2DData({fwhm:{x:this.fwhmX,y:this.fwhmY}},t)}getFactor(){return getGaussianFactor(arguments.length>0&&void 0!==arguments[0]?arguments[0]:1)}getVolume(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:calculateGaussian2DHeight({fwhm:{x:this.fwhmX,y:this.fwhmY},volume:1});return getGaussian2DVolume({fwhm:{x:this.fwhmX,y:this.fwhmY},height:t})}widthToFWHM(t){return gaussianWidthToFWHM(t)}fwhmToWidth(t){return gaussianFwhmToWidth(t)}calculateHeight(){return calculateGaussian2DHeight({volume:arguments.length>0&&void 0!==arguments[0]?arguments[0]:1,fwhm:{x:this.fwhmX,y:this.fwhmY}})}set fwhm(t){t=ensureXYNumber$2(t),this.fwhmX=t.x,this.fwhmY=t.y}}const gaussian2DFct=(t,e,n,s)=>Math.exp(GAUSSIAN_EXP_FACTOR*(Math.pow(t/n,2)+Math.pow(e/s,2))),getGaussian2DData=function(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{fwhm:n=50,sd:s}=t;n=ensureFWHM2D(n,s);let{factor:i=getGaussianFactor(),length:o={x:0,y:0},height:a=calculateGaussian2DHeight({fwhm:n,volume:1})}=e;i=ensureXYNumber$2(i),o=ensureXYNumber$2(o);for(const t of["x","y"])o[t]||(o[t]=Math.min(Math.ceil(n[t]*i[t]),Math.pow(2,25)-1),o[t]%2==0&&o[t]++);const l=(o.x-1)/2,r=(o.y-1)/2,m=new Array(o.x);for(let t=0;t<o.x;t++)m[t]=new Float64Array(o.y);for(let t=0;t<o.x;t++)for(let e=0;e<o.y;e++)m[t][e]=gaussian2DFct(t-l,e-r,n.x,n.y)*a;return m},calculateGaussian2DHeight=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{volume:e=1,fwhm:n=50,sd:s}=t;return n=ensureFWHM2D(n,s),e*Math.LN2*4/(Math.PI*n.y*n.x)},getGaussian2DVolume=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{fwhm:e=50,height:n=1,sd:s}=t;return e=ensureFWHM2D(e,s),n*Math.PI*e.y*e.x/Math.LN2/4};function ensureXYNumber$2(t){return"object"!=typeof t?{x:t,y:t}:{...t}}function ensureFWHM2D(t,e){if(void 0!==e){let t=ensureXYNumber$2(e);return{x:gaussianWidthToFWHM(2*t.x),y:gaussianWidthToFWHM(2*t.y)}}if(void 0!==t)return ensureXYNumber$2(t);throw new Error("ensureFWHM2D must have either fwhm or sd defined")}function getShape1D(t){const{kind:e}=t;switch(e){case"gaussian":return new Gaussian(t);case"lorentzian":return new Lorentzian(t);case"pseudoVoigt":return new PseudoVoigt(t);default:throw Error(`Unknown distribution ${e}`)}}function getShape2D(t){const{kind:e}=t;if("gaussian"===e)return new Gaussian2D(t);throw Error(`Unknown distribution ${e}`)}function addBaseline(t,e){if(!e)return t;let n=t.x,s=t.y;for(let t=0;t<n.length;t++)s[t]+=e(n[t]);return t}function reimAbsolute(t){const e=t.re.length,n=t.re,s=t.im,i=new Float64Array(e);for(let t=0;t<e;t++)i[t]=Math.sqrt(n[t]**2+s[t]**2);return i}var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function getDefaultExportFromCjs(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var d3Array={exports:{}};!function(t,e){!function(t){function e(t,e){return t<e?-1:t>e?1:t>=e?0:NaN}function n(t){return 1===t.length&&(t=s(t)),{left:function(e,n,s,i){for(null==s&&(s=0),null==i&&(i=e.length);s<i;){var o=s+i>>>1;t(e[o],n)<0?s=o+1:i=o}return s},right:function(e,n,s,i){for(null==s&&(s=0),null==i&&(i=e.length);s<i;){var o=s+i>>>1;t(e[o],n)>0?i=o:s=o+1}return s}}}function s(t){return function(n,s){return e(t(n),s)}}var i=n(e),o=i.right,a=i.left;function l(t,e){return e<t?-1:e>t?1:e>=t?0:NaN}function r(t){return null===t?NaN:+t}function m(t,e){var n,s,i=t.length,o=0,a=0,l=-1,m=0;if(null==e)for(;++l<i;)isNaN(n=r(t[l]))||(a+=(s=n-o)*(n-(o+=s/++m)));else for(;++l<i;)isNaN(n=r(e(t[l],l,t)))||(a+=(s=n-o)*(n-(o+=s/++m)));if(m>1)return a/(m-1)}function g(t,e){var n=m(t,e);return n?Math.sqrt(n):n}function u(t,e){var n,s,i,o=-1,a=t.length;if(null==e){for(;++o<a;)if(null!=(s=t[o])&&s>=s){n=i=s;break}for(;++o<a;)null!=(s=t[o])&&(n>s&&(n=s),i<s&&(i=s))}else{for(;++o<a;)if(null!=(s=e(t[o],o,t))&&s>=s){n=i=s;break}for(;++o<a;)null!=(s=e(t[o],o,t))&&(n>s&&(n=s),i<s&&(i=s))}return[n,i]}function c(t){return function(){return t}}function C(t){return t}function f(t,e,n){t=+t,e=+e,n=(i=arguments.length)<2?(e=t,t=0,1):i<3?1:+n;for(var s=-1,i=0|Math.max(0,Math.ceil((e-t)/n)),o=new Array(i);++s<i;)o[s]=t+s*n;return o}var h=Math.sqrt(50),p=Math.sqrt(10),d=Math.sqrt(2);function y(t,e,n){var s=H(t,e,n);return f(Math.ceil(t/s)*s,Math.floor(e/s)*s+s/2,s)}function H(t,e,n){var s=Math.abs(e-t)/Math.max(0,n),i=Math.pow(10,Math.floor(Math.log(s)/Math.LN10)),o=s/i;return o>=h?i*=10:o>=p?i*=5:o>=d&&(i*=2),e<t?-i:i}function v(t){return Math.ceil(Math.log(t.length)/Math.LN2)+1}function b(t){return+t}function w(){var t=C,e=u,n=v;function s(s){var i,a,l=s.length,r=new Array(l);for(i=0;i<l;++i)r[i]=+t(s[i],i,s);var m=e(r),g=+m[0],u=+m[1],c=n(r,g,u);Array.isArray(c)||(c=y(g,u,+c));var C=c.length;for(i=0;i<C;++i)c[i]=+c[i];for(;c[0]<=g;)c.shift(),--C;for(;c[C-1]>=u;)c.pop(),--C;var f,h=new Array(C+1);for(i=0;i<=C;++i)(f=h[i]=[]).x0=i>0?c[i-1]:g,f.x1=i<C?c[i]:u;for(i=0;i<l;++i)g<=(a=r[i])&&a<=u&&h[o(c,a,0,C)].push(s[i]);return h}return s.value=function(e){return arguments.length?(t="function"==typeof e?e:c(+e),s):t},s.domain=function(t){return arguments.length?(e="function"==typeof t?t:c([+t[0],+t[1]]),s):e},s.thresholds=function(t){return arguments.length?(n="function"==typeof t?t:Array.isArray(t)?c(Array.prototype.map.call(t,b)):c(+t),s):n},s}function x(t,e,n){if(null==n&&(n=r),s=t.length){if((e=+e)<=0||s<2)return+n(t[0],0,t);if(e>=1)return+n(t[s-1],s-1,t);var s,i=(s-1)*e,o=Math.floor(i),a=+n(t[o],o,t);return a+(+n(t[o+1],o+1,t)-a)*(i-o)}}function O(t,n,s){return t.sort(e),Math.ceil((s-n)/(2*(x(t,.75)-x(t,.25))*Math.pow(t.length,-1/3)))}function D(t,e,n){return Math.ceil((n-e)/(3.5*g(t)*Math.pow(t.length,-1/3)))}function A(t,e){var n,s,i=-1,o=t.length;if(null==e){for(;++i<o;)if(null!=(s=t[i])&&s>=s){n=s;break}for(;++i<o;)null!=(s=t[i])&&s>n&&(n=s)}else{for(;++i<o;)if(null!=(s=e(t[i],i,t))&&s>=s){n=s;break}for(;++i<o;)null!=(s=e(t[i],i,t))&&s>n&&(n=s)}return n}function S(t,e){var n,s=0,i=t.length,o=-1,a=i;if(null==e)for(;++o<i;)isNaN(n=r(t[o]))?--a:s+=n;else for(;++o<i;)isNaN(n=r(e(t[o],o,t)))?--a:s+=n;if(a)return s/a}function M(t,n){var s,i=[],o=t.length,a=-1;if(null==n)for(;++a<o;)isNaN(s=r(t[a]))||i.push(s);else for(;++a<o;)isNaN(s=r(n(t[a],a,t)))||i.push(s);return x(i.sort(e),.5)}function j(t){for(var e,n,s,i=t.length,o=-1,a=0;++o<i;)a+=t[o].length;for(n=new Array(a);--i>=0;)for(e=(s=t[i]).length;--e>=0;)n[--a]=s[e];return n}function $(t,e){var n,s,i=-1,o=t.length;if(null==e){for(;++i<o;)if(null!=(s=t[i])&&s>=s){n=s;break}for(;++i<o;)null!=(s=t[i])&&n>s&&(n=s)}else{for(;++i<o;)if(null!=(s=e(t[i],i,t))&&s>=s){n=s;break}for(;++i<o;)null!=(s=e(t[i],i,t))&&n>s&&(n=s)}return n}function T(t){for(var e=0,n=t.length-1,s=t[0],i=new Array(n<0?0:n);e<n;)i[e]=[s,s=t[++e]];return i}function _(t,e){for(var n=e.length,s=new Array(n);n--;)s[n]=t[e[n]];return s}function N(t,n){if(s=t.length){var s,i,o=0,a=0,l=t[a];for(n||(n=e);++o<s;)(n(i=t[o],l)<0||0!==n(l,l))&&(l=i,a=o);return 0===n(l,l)?a:void 0}}function F(t,e,n){for(var s,i,o=(null==n?t.length:n)-(e=null==e?0:+e);o;)i=Math.random()*o--|0,s=t[o+e],t[o+e]=t[i+e],t[i+e]=s;return t}function E(t,e){var n,s=0,i=t.length,o=-1;if(null==e)for(;++o<i;)(n=+t[o])&&(s+=n);else for(;++o<i;)(n=+e(t[o],o,t))&&(s+=n);return s}function k(t){if(!(i=t.length))return[];for(var e=-1,n=$(t,I),s=new Array(n);++e<n;)for(var i,o=-1,a=s[e]=new Array(i);++o<i;)a[o]=t[o][e];return s}function I(t){return t.length}function P(){return k(arguments)}var R="0.7.1";t.version=R,t.bisect=o,t.bisectRight=o,t.bisectLeft=a,t.ascending=e,t.bisector=n,t.descending=l,t.deviation=g,t.extent=u,t.histogram=w,t.thresholdFreedmanDiaconis=O,t.thresholdScott=D,t.thresholdSturges=v,t.max=A,t.mean=S,t.median=M,t.merge=j,t.min=$,t.pairs=T,t.permute=_,t.quantile=x,t.range=f,t.scan=N,t.shuffle=F,t.sum=E,t.ticks=y,t.tickStep=H,t.transpose=k,t.variance=m,t.zip=P}(e)}(0,d3Array.exports);const{bisectRight:bisectRight}=d3Array.exports,quincunx=(t,e,n,s)=>{const i=t.length-1;t[0]=0,e[0]=0,n[0]=0,e[1]=e[1]/t[1],n[1]=n[1]/t[1];for(let s=2;s<i;++s)t[s]=t[s]-t[s-2]*n[s-2]*n[s-2]-t[s-1]*e[s-1]*e[s-1],e[s]=(e[s]-t[s-1]*e[s-1]*n[s-1])/t[s],n[s]=n[s]/t[s];for(let t=2;t<i;++t)s[t]=s[t]-e[t-1]*s[t-1]-n[t-2]*s[t-2];for(let e=1;e<i;++e)s[e]=s[e]/t[e];s[i-2]=s[i-2]-e[i-2]*s[i-1];for(let t=i-3;t>0;--t)s[t]=s[t]-e[t]*s[t+1]-n[t]*s[t+2]},smoothingSpline=(t,e,n,s)=>{const i=t.length-1,o=new Array(i+1),a=new Array(i+1),l=new Array(i+1),r=new Array(i+1),m=new Array(i+1),g=new Array(i+1),u=new Array(i+1),c=new Array(i+1),C=t.map((()=>[0,0,0,0]));C.pop();const f=2*(1-s)/(3*s);for(let e=0;e<i;++e)o[e]=t[e+1]-t[e],a[e]=3/o[e];m[0]=0;for(let n=1;n<i;++n)l[n]=-(a[n-1]+a[n]),r[n]=2*(t[n+1]-t[n-1]),m[n]=3*(e[n+1]-e[n])/o[n]-3*(e[n]-e[n-1])/o[n-1];m[i]=0;for(let t=1;t<i;++t)g[t]=a[t-1]*a[t-1]*n[t-1]+l[t]*l[t]*n[t]+a[t]*a[t]*n[t+1],g[t]=f*g[t]+r[t];for(let t=1;t<i-1;++t)u[t]=l[t]*a[t]*n[t]+a[t]*l[t+1]*n[t+1],u[t]=f*u[t]+o[t];for(let t=1;t<i-2;++t)c[t]=f*a[t]*a[t+1]*n[t+1];quincunx(g,u,c,m),C[0][3]=e[0]-f*a[0]*m[1]*n[0],C[1][3]=e[1]-f*(l[1]*m[1]+a[1]*m[2])*n[0],C[0][0]=m[1]/(3*o[0]),C[0][1]=0,C[0][2]=(C[1][3]-C[0][3])/o[0]-m[1]*o[0]/3,a[0]=0;for(let t=1;t<i;++t)C[t][0]=(m[t+1]-m[t])/(3*o[t]),C[t][1]=m[t],C[t][2]=(m[t]+m[t-1])*o[t-1]+C[t-1][2],C[t][3]=a[t-1]*m[t-1]+l[t]*m[t]+a[t]*m[t+1],C[t][3]=e[t]-f*C[t][3]*n[t];return C};class SplineInterpolator{constructor(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1;const s=t.map(((t,e)=>e));s.sort(((e,n)=>t[e]-t[n]));const i=s.map((e=>t[e])),o=s.map((t=>e[t])),a=s.length,l=s.map((()=>1));this.n=a,this.x=i,this.y=o,this.params=smoothingSpline(i,o,l,n)}interpolate(t){if(t===this.x[this.n-1])return this.y[this.n-1];const e=Math.min(Math.max(0,bisectRight(this.x,t)-1),this.n-2),[n,s,i,o]=this.params[e];return n*(t-=this.x[e])*t*t+s*t*t+i*t+o}max(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:100;const e=this.x[0],n=(this.x[this.n-1]-e)/t;let s=-1/0;for(let i=0,o=e;i<t;++i,o+=n){const t=this.interpolate(o);t>s&&(s=t)}return s}min(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:100;const e=this.x[0],n=(this.x[this.n-1]-e)/t;let s=1/0;for(let i=0,o=e;i<t;++i,o+=n){const t=this.interpolate(o);t<s&&(s=t)}return s}domain(){return[this.x[0],this.x[this.x.length-1]]}range(){return[this.min(),this.max()]}curve(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;e=e||this.domain();const n=(e[1]-e[0])/(t-1),s=new Array(t);for(let i=0;i<t;++i){const t=n*i+e[0];s[i]=[t,this.interpolate(t)]}return s}}var splineInterpolator=SplineInterpolator,SplineInterpolator$1=splineInterpolator;function createFromToArray(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{from:e=0,to:n=1,length:s=1e3,includeFrom:i=!0,includeTo:o=!0,distribution:a="uniform"}=t;const l=new Float64Array(s);let r=s;i&&o?r=s-1:!i&&o||i&&!o?r=s:i||o||(r=s+1);let m=(n-e)/r;if("uniform"===a)if(i){let t=0;for(;t<s;)l[t]=e+m*t,t++}else{let t=0;for(;t<s;)l[t]=e+m*(t+1),t++}else{if("log"!==a)throw new Error("Please choose for the distribution either uniform or log. By default the distribution chosen is uniform.");{let t=(n/e)**(1/r),o=Math.log(e)/Math.log(t);if(i){let e=0;for(;e<s;)l[e]=t**(o+e),e++}else{let e=0;for(;e<s;)l[e]=t**(o+e+1),e++}}}return l}const Y1=.08913147449493408,P1=[-.005387729650712429,.008226878746769157,.02198786811111689,-.03656379714117627,-.012692614766297404,.03348066254097446,-.008368748197417368,-.0005087819496582806],Q1=[.0008862163904564247,-.0023339375937419,.07952836873415717,-.05273963823400997,-.7122890234154284,.662328840472003,1.5622155839842302,-1.5657455823417585,-.9700050433032906,1],Y2=2.249481201171875,P2=[-3.6719225470772936,21.12946554483405,17.445385985570866,-44.6382324441787,-18.851064805871424,17.644729840837403,8.3705032834312,.10526468069939171,-.20243350835593876],Q2=[1.7211476576120028,-22.643693341313973,10.826866735546016,48.560921310873994,-20.14326346804852,-28.66081804998,3.971343795334387,6.242641248542475,1],Y3=.807220458984375,P3=[-6.81149956853777e-10,2.8522533178221704e-8,-6.794655751811263e-7,.0021455899538880526,.029015791000532906,.14286953440815717,.3377855389120359,.38707973897260434,.11703015634199525,-.16379404719331705,-.1311027816799519],Q3=[.011059242293464892,.15226433829533179,.848854343457902,2.5930192162362027,4.778465929458438,5.381683457070069,3.4662540724256723,1],Y4=.9399557113647461,P4=[26633922742578204e-28,-2.304047769118826e-10,460469890584318e-20,.00015754461742496055,.0018712349281955923,.009508047013259196,.018557330651423107,-.0022242652921344794,-.0350353787183178],Q4=[7646752923027944e-20,.00263861676657016,.03415891436709477,.22009110576413124,.7620591645536234,1.3653349817554064,1],Y5=.9836282730102539,P5=[9905570997331033e-32,-2811287356288318e-29,4.625961635228786e-9,4.4969678992770644e-7,14962478375834237e-21,.00020938631748758808,.001056288621524929,-.0011295143874558028,-.016743100507663373],Q5=[2.82243172016108e-7,27533547476472603e-21,.0009640118070051656,.016074608709367652,.1381518657490833,.5914293448864175,1];function polyval(t,e){let n=0;for(const s of t)n=n*e+s;return n}function calc(t,e,n,s,i){const o=t-e;return i*t+polyval(n,o)/polyval(s,o)*t}function erfcinv(t){let e,n,s,i,o=!1;if(Number.isNaN(t))return Number.NaN;if(t<0||t>2)throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${t}\`.`);return 0===t?Number.POSITIVE_INFINITY:2===t?Number.NEGATIVE_INFINITY:1===t?0:(t>1?(n=2-t,t=1-n,o=!0):(n=t,t=1-t),t<=.5?(s=t*(t+10),i=polyval(P1,t)/polyval(Q1,t),e=s*Y1+s*i,o?-e:e):n>=.25?(s=Math.sqrt(-2*Math.log(n)),n-=.25,i=polyval(P2,n)/polyval(Q2,n),e=s/(Y2+i),o?-e:e):(n=Math.sqrt(-Math.log(n)),n<3?calc(n,1.125,P3,Q3,Y3):n<6?calc(n,3,P4,Q4,Y4):calc(n,6,P5,Q5,Y5)))}function rayleighCdf(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;return t<0?0:-Math.expm1(-Math.pow(t,2)/(2*Math.pow(e,2)))}function xNoiseSanPlot(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{mask:n,cutOff:s,refine:i=!0,magnitudeMode:o=!1,scaleFactor:a=1,factorStd:l=5,fixOffset:r=!0}=e;let m;if(m=Array.isArray(n)&&n.length===t.length?new Float64Array(t.filter(((t,e)=>!n[e]))):new Float64Array(t),a>1)for(let t=0;t<m.length;t++)m[t]*=a;if(m=m.sort().reverse(),r&&!o){let t=Math.floor(m.length/2),e=.5*(m[t]+m[t+1]);for(let t=0;t<m.length;t++)m[t]-=e}let g=m[m.length-1]>=0?m.length:m.findIndex((t=>t<0)),u=g-1;for(let t=u;t>=0;t--)if(m[t]>0){u=t;break}let c,C=m.slice(0,u+1),f=m.slice(g),h=s||determineCutOff(C,{magnitudeMode:o}),p=C[Math.floor(C.length*h)],d=C[0];if(f.length>0){c=-1*f[Math.floor(f.length*(1-h))]}else c=0;let y=p,H=c,v=C.slice(),b=f.slice(),w=0,x=2;if(i){let t=y*l;w=C.findIndex((e=>e<t)),w>-1&&(v=C.slice(w),y=v[Math.floor(v.length*h)]),t=H*l,x=f.findIndex((e=>e<t)),x>-1&&(b=f.slice(x),H=v[Math.floor(b.length*(1-h))])}let O,D,A=-simpleNormInv(h/2,{magnitudeMode:o});return p/=A,c/=A,i&&w>-1?(O=(h*v.length+w)/(v.length+w),D=-1*simpleNormInv(O/2,{magnitudeMode:o}),y/=D,x>-1&&(O=(h*b.length+x)/(b.length+x),D=-1*simpleNormInv(O/2,{magnitudeMode:o}),0!==H&&(H/=D))):(y/=A,H/=A),{positive:y,negative:H,snr:d/y,sanplot:generateSanPlot(m,{fromTo:{positive:{from:0,to:u},negative:{from:g,to:m.length}}})}}function determineCutOff(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{magnitudeMode:n=!1,considerList:s={from:.5,step:.1,to:.9}}=e,i=[],o=t.length-1;for(let e=.01;e<=.99;e+=.01){let s=-t[Math.round(o*e)]/simpleNormInv([e/2],{magnitudeMode:n});i.push([e,s])}let a=Number.MAX_SAFE_INTEGER,{from:l,to:r,step:m}=s,g=m/2,u=.5;for(let t=l;t<=r;t+=m){let e=t-g,n=t+g,s=i.filter((t=>t[0]<n&&t[0]>e)),o=s.reduce(((t,e)=>t+Math.abs(e[1])),0),l=0;for(const t of s)l+=Math.pow(t[1]-o,2);l<a&&(a=l,u=t)}return u}function simpleNormInv(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{magnitudeMode:n=!1}=e;Array.isArray(t)||(t=[t]);let s=Array.from(createArray(0,2,.01)),i=new Float64Array(t.length),o=new Float64Array(s.length);if(n){let e=1;for(let t=0;t<o.length;t++){let n=s[t]*e;o[t]=1-rayleighCdf(n)}let n=new SplineInterpolator$1(s,o);for(let e=0;e<i.length;e++){let s=2*t[e];i[e]=-1*n.interpolate(s)}}else for(let e=0;e<i.length;e++)i[e]=-1*Math.SQRT2*erfcinv(2*t[e]);return 1===i.length?i[0]:i}function createArray(t,e,n){let s=new Float64Array(Math.abs((t-e)/n+1));for(let e=0;e<s.length;e++)s[e]=t+e*n;return s}function generateSanPlot(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{fromTo:n,logBaseY:s=2}=e;let i={};for(let e in n){let{from:o,to:a}=n[e];i[e]=o!==a?scale(t.slice(o,a),{logBaseY:s}):{x:[],y:[]},"negative"===e&&i[e].y.reverse()}return i}function scale(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{log10:n,abs:s}=Math,{logBaseY:i}=e;if(i){t=t.slice();const e=n(i);for(let i=0;i<t.length;i++)t[i]=n(s(t[i]))/e}return{x:createFromToArray({from:0,to:t.length-1,length:t.length}),y:t}}function reimPhaseCorrection(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,s=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const{reverse:i=!1}=s;e=Number.isFinite(e)?e:0,n=Number.isFinite(n)?n:0;const o=t.re,a=t.im,l=t.re.length;let r=e,m=n/l;i&&(m*=-1,r+=n);const g=2*Math.pow(Math.sin(m/2),2),u=Math.sin(m);let c=Math.cos(r),C=Math.sin(r);const f=new Float64Array(l),h=new Float64Array(l);for(let t=0;t<l;t++){f[t]=o[t]*c-a[t]*C,h[t]=a[t]*c+o[t]*C;let e=C-(g*C-u*c);c=c-(g*c+u*C),C=e}return{re:f,im:h}}function reimAutoPhaseCorrection(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{re:n,im:s}=t,i=n.length,{magnitudeMode:o=!0,minRegSize:a=30,factorNoise:l=3,maxDistanceToJoin:r=256,reverse:m=!1}=e;let g=o?reimAbsolute(t):n,u=robustBaseLineRegionsDetection(holoborodko(g),{maxDistanceToJoin:r,magnitudeMode:o,factorNoise:l}),c=robustBaseLineRegionsDetection(g,{maxDistanceToJoin:r,magnitudeMode:o,factorNoise:l}),C=new Uint8Array(i);for(let t=0;t<i;t++)C[t]=c[t]&&u[t];const f=m?t=>i-t:t=>t;let h=-1,p=0,d=[];for(;h<i;){let t=[],e=[];for(;!C[++h]&&h<i;)p=f(h);for(;C[h]&&h<i;h++)t.push(n[h]),e.push(s[h]),h++;t.length>a&&d.push(autoPhaseRegion(t,e,p))}let[y,H]=weightedLinearRegression(d.map((t=>t.x0/i)),d.map((t=>t.ph0)),d.map((t=>t.area/1e11)));return{data:reimPhaseCorrection({re:n,im:s},H*Math.PI/180,y*Math.PI/180,{reverse:m}),ph0:H,ph1:y}}function autoPhaseRegion(t,e,n){let s=-180,i=180,o=5,a=0,l=Number.MAX_SAFE_INTEGER;for(;o>0;){let n=(i-s)/7;for(let o=s;o<=i;o+=n){let n=reimPhaseCorrection({re:t,im:e},toRadians(o),0),s=getNegArea(n.re);s<l&&([l,a]=[s,o])}s=a-n,i=a+n,o--}let r=reimPhaseCorrection({re:t,im:e},toRadians(a),0),m=0,g=0;for(let e=0;e<t.length;e++)m+=r.re[e],g+=r.re[e]*(e+n);return{ph0:a,area:m,x0:g/m}}function holoborodko(t){let e=new Float64Array(t.length);for(let n=5;n<t.length-5;n++)e[n]=(42*(t[n+1]-t[n-1])+48*(t[n+2]-t[n-2])+27*(t[n+3]+t[n-3])+8*(t[n+4]-t[n-4])+t[n+5]-t[n-5])/512;for(let n=0;n<5;n++)e[n]=e[5],e[t.length-n-1]=e[t.length-6];return e}function robustBaseLineRegionsDetection(t,e){const{maxDistanceToJoin:n,magnitudeMode:s,factorNoise:i}=e;let o=new Uint8Array(t.length);for(let e=0;e<t.length;e++)o[e]=0;let a=!0;for(;a;){let e=i*xNoiseSanPlot(t,{magnitudeMode:s}).positive;a=!1;for(let n=0;n<t.length;n++)Math.abs(t[n])>e&&!o[n]&&(a=!0,o[n]=1)}let l=0,r=0;for(let e=0;e<t.length;e++)if(o[e]){if(l<n)for(let t=0;t<=l;t++)o[r+t]=1;for(;o[++e]&&e<t.length;);r=e,l=0}else l++;return o}function weightedLinearRegression(t,e,n){let s=0,i=0,o=0,a=0,l=0;for(let r=0;r<t.length;r++)s+=t[r]*t[r]*n[r],i+=t[r]*n[r],o+=n[r],a+=t[r]*n[r]*e[r],l+=n[r]*e[r];let r=s*o-i*i,m=[[o/r,-i/r],[-i/r,s/r]];return[m[0][0]*a+m[0][1]*l,m[1][0]*a+m[1][1]*l]}const toRadians=t=>t*Math.PI/180,getNegArea=t=>{let e=0;for(let n of t)n<0&&(e-=n);return e};function FFT$1(t){if(this.size=0|t,this.size<=1||0!=(this.size&this.size-1))throw new Error("FFT size must be a power of two and bigger than 1");this._csize=t<<1;for(var e=new Array(2*this.size),n=0;n<e.length;n+=2){const t=Math.PI*n/this.size;e[n]=Math.cos(t),e[n+1]=-Math.sin(t)}this.table=e;for(var s=0,i=1;this.size>i;i<<=1)s++;this._width=s%2==0?s-1:s,this._bitrev=new Array(1<<this._width);for(var o=0;o<this._bitrev.length;o++){this._bitrev[o]=0;for(var a=0;a<this._width;a+=2){var l=this._width-a-2;this._bitrev[o]|=(o>>>a&3)<<l}}this._out=null,this._data=null,this._inv=0}var fft$1=FFT$1;FFT$1.prototype.fromComplexArray=function(t,e){for(var n=e||new Array(t.length>>>1),s=0;s<t.length;s+=2)n[s>>>1]=t[s];return n},FFT$1.prototype.createComplexArray=function(){const t=new Array(this._csize);for(var e=0;e<t.length;e++)t[e]=0;return t},FFT$1.prototype.toComplexArray=function(t,e){for(var n=e||this.createComplexArray(),s=0;s<n.length;s+=2)n[s]=t[s>>>1],n[s+1]=0;return n},FFT$1.prototype.completeSpectrum=function(t){for(var e=this._csize,n=e>>>1,s=2;s<n;s+=2)t[e-s]=t[s],t[e-s+1]=-t[s+1]},FFT$1.prototype.transform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._transform4(),this._out=null,this._data=null},FFT$1.prototype.realTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._realTransform4(),this._out=null,this._data=null},FFT$1.prototype.inverseTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=1,this._transform4();for(var n=0;n<t.length;n++)t[n]/=this.size;this._out=null,this._data=null},FFT$1.prototype._transform4=function(){var t,e,n=this._out,s=this._csize,i=1<<this._width,o=s/i<<1,a=this._bitrev;if(4===o)for(t=0,e=0;t<s;t+=o,e++){const n=a[e];this._singleTransform2(t,n,i)}else for(t=0,e=0;t<s;t+=o,e++){const n=a[e];this._singleTransform4(t,n,i)}var l=this._inv?-1:1,r=this.table;for(i>>=2;i>=2;i>>=2){var m=(o=s/i<<1)>>>2;for(t=0;t<s;t+=o)for(var g=t+m,u=t,c=0;u<g;u+=2,c+=i){const t=u,e=t+m,s=e+m,i=s+m,o=n[t],a=n[t+1],g=n[e],C=n[e+1],f=n[s],h=n[s+1],p=n[i],d=n[i+1],y=o,H=a,v=r[c],b=l*r[c+1],w=g*v-C*b,x=g*b+C*v,O=r[2*c],D=l*r[2*c+1],A=f*O-h*D,S=f*D+h*O,M=r[3*c],j=l*r[3*c+1],$=p*M-d*j,T=p*j+d*M,_=y+A,N=H+S,F=y-A,E=H-S,k=w+$,I=x+T,P=l*(w-$),R=l*(x-T),z=_+k,L=N+I,q=_-k,V=N-I,B=F+R,U=E-P,X=F-R,G=E+P;n[t]=z,n[t+1]=L,n[e]=B,n[e+1]=U,n[s]=q,n[s+1]=V,n[i]=X,n[i+1]=G}}},FFT$1.prototype._singleTransform2=function(t,e,n){const s=this._out,i=this._data,o=i[e],a=i[e+1],l=i[e+n],r=i[e+n+1],m=o+l,g=a+r,u=o-l,c=a-r;s[t]=m,s[t+1]=g,s[t+2]=u,s[t+3]=c},FFT$1.prototype._singleTransform4=function(t,e,n){const s=this._out,i=this._data,o=this._inv?-1:1,a=2*n,l=3*n,r=i[e],m=i[e+1],g=i[e+n],u=i[e+n+1],c=i[e+a],C=i[e+a+1],f=i[e+l],h=i[e+l+1],p=r+c,d=m+C,y=r-c,H=m-C,v=g+f,b=u+h,w=o*(g-f),x=o*(u-h),O=p+v,D=d+b,A=y+x,S=H-w,M=p-v,j=d-b,$=y-x,T=H+w;s[t]=O,s[t+1]=D,s[t+2]=A,s[t+3]=S,s[t+4]=M,s[t+5]=j,s[t+6]=$,s[t+7]=T},FFT$1.prototype._realTransform4=function(){var t,e,n=this._out,s=this._csize,i=1<<this._width,o=s/i<<1,a=this._bitrev;if(4===o)for(t=0,e=0;t<s;t+=o,e++){const n=a[e];this._singleRealTransform2(t,n>>>1,i>>>1)}else for(t=0,e=0;t<s;t+=o,e++){const n=a[e];this._singleRealTransform4(t,n>>>1,i>>>1)}var l=this._inv?-1:1,r=this.table;for(i>>=2;i>=2;i>>=2){var m=(o=s/i<<1)>>>1,g=m>>>1,u=g>>>1;for(t=0;t<s;t+=o)for(var c=0,C=0;c<=u;c+=2,C+=i){var f=t+c,h=f+g,p=h+g,d=p+g,y=n[f],H=n[f+1],v=n[h],b=n[h+1],w=n[p],x=n[p+1],O=n[d],D=n[d+1],A=y,S=H,M=r[C],j=l*r[C+1],$=v*M-b*j,T=v*j+b*M,_=r[2*C],N=l*r[2*C+1],F=w*_-x*N,E=w*N+x*_,k=r[3*C],I=l*r[3*C+1],P=O*k-D*I,R=O*I+D*k,z=A+F,L=S+E,q=A-F,V=S-E,B=$+P,U=T+R,X=l*($-P),G=l*(T-R),Y=z+B,W=L+U,K=q+G,J=V-X;if(n[f]=Y,n[f+1]=W,n[h]=K,n[h+1]=J,0!==c){if(c!==u){var Z=q+-l*G,Q=-V+-l*X,tt=z+-l*B,et=-L- -l*U,nt=t+g-c,st=t+m-c;n[nt]=Z,n[nt+1]=Q,n[st]=tt,n[st+1]=et}}else{var it=z-B,ot=L-U;n[p]=it,n[p+1]=ot}}}},FFT$1.prototype._singleRealTransform2=function(t,e,n){const s=this._out,i=this._data,o=i[e],a=i[e+n],l=o+a,r=o-a;s[t]=l,s[t+1]=0,s[t+2]=r,s[t+3]=0},FFT$1.prototype._singleRealTransform4=function(t,e,n){const s=this._out,i=this._data,o=this._inv?-1:1,a=2*n,l=3*n,r=i[e],m=i[e+n],g=i[e+a],u=i[e+l],c=r+g,C=r-g,f=m+u,h=o*(m-u),p=c+f,d=C,y=-h,H=c-f,v=C,b=h;s[t]=p,s[t+1]=0,s[t+2]=d,s[t+3]=y,s[t+4]=H,s[t+5]=0,s[t+6]=v,s[t+7]=b};var FFT$2=fft$1;function xRotate(t,e){(e%=t.length)<0&&(e+=t.length);let n=new Float64Array(t.length);return n.set(t.slice(t.length-e)),n.set(t.slice(0,t.length-e),e),n}function reimFFT(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{inverse:n=!1,applyZeroShift:s=!1}=e;let{re:i,im:o}=t;const a=i.length,l=a<<1;let r=new Float64Array(l);for(let t=0;t<l;t+=2)r[t]=i[t>>>1],r[t+1]=o[t>>>1];let m=new FFT$2(a),g=new Float64Array(l);n?(s&&(r=zeroShift(r,!0)),m.inverseTransform(g,r)):(m.transform(g,r),s&&(g=zeroShift(g)));let u=new Float64Array(a),c=new Float64Array(a);for(let t=0;t<l;t+=2)u[t>>>1]=g[t],c[t>>>1]=g[t+1];return{re:u,im:c}}const zeroShift=(t,e)=>xRotate(t,e?Math.ceil(t.length/2):Math.floor(t.length/2));function xAbsolute(t){let e=t.slice();for(let t=0;t<e.length;t++)e[t]<0&&(e[t]*=-1);return e}const toString$2=Object.prototype.toString;function isAnyArray(t){const e=toString$2.call(t);return e.endsWith("Array]")&&!e.includes("Big")}function xMedian(t){if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");const e=t.slice();let n=0,s=e.length-1,i=0,o=0,a=0,l=calcMiddle(n,s);for(;;){if(s<=n)return e[l];if(s===n+1)return e[n]>e[s]&&swap(e,n,s),e[l];for(i=calcMiddle(n,s),e[i]>e[s]&&swap(e,i,s),e[n]>e[s]&&swap(e,n,s),e[i]>e[n]&&swap(e,i,n),swap(e,i,n+1),o=n+1,a=s;;){do{o++}while(e[n]>e[o]);do{a--}while(e[a]>e[n]);if(a<o)break;swap(e,o,a)}swap(e,n,a),a<=l&&(n=o),a>=l&&(s=a-1)}}function swap(t,e,n){const s=t[n];t[n]=t[e],t[e]=s}function calcMiddle(t,e){return Math.floor((t+e)/2)}function xAbsoluteMedian(t){return xMedian(xAbsolute(t))}function xAdd(t,e){let n=!1,s=0;if(isAnyArray(e)){if(t.length!==e.length)throw new Error("xAdd: size of array1 and array2 must be identical")}else n=!0,s=e;let i=new Float64Array(t.length);if(n)for(let e=0;e<t.length;e++)i[e]=t[e]+s;else for(let n=0;n<t.length;n++)i[n]=t[n]+e[n];return i}function xApplyFunctionStr(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{variableLabel:n="x",fctString:s=n}=e,i=new Function(n,`return Number(${s.replace(/(?<before>^|\W)(?<after>[\da-z]{2,}\()/g,"$<before>Math.$<after>").replace(/Math\.Math/g,"Math")})`),o=Float64Array.from(t);for(let e=0;e<t.length;e++)if(o[e]=i(t[e]),Number.isNaN(o[e]))throw new Error(`The callback ${s} does not return a number: ${t[e]}`);return o}function getOutputArray(t,e){if(void 0!==t){if(!isAnyArray(t))throw new TypeError("output option must be an array if specified");if(t.length!==e)throw new TypeError("the output array does not have the correct length");return t}return new Float64Array(e)}function xMultiply(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},s=!1,i=0;if(isAnyArray(e)){if(t.length!==e.length)throw new Error("xMultiply: size of array1 and array2 must be identical")}else s=!0,i=Number(e);let o=getOutputArray(n.output,t.length);if(s)for(let e=0;e<t.length;e++)o[e]=t[e]*i;else for(let n=0;n<t.length;n++)o[n]=t[n]*e[n];return o}function xCheck(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{minLength:n}=e;if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(n&&t.length<n)throw new Error(`input must have a length of at least ${n}`)}function max(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var n=e.fromIndex,s=void 0===n?0:n,i=e.toIndex,o=void 0===i?t.length:i;if(s<0||s>=t.length||!Number.isInteger(s))throw new Error("fromIndex must be a positive integer smaller than length");if(o<=s||o>t.length||!Number.isInteger(o))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[s],l=s+1;l<o;l++)t[l]>a&&(a=t[l]);return a}function min(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var n=e.fromIndex,s=void 0===n?0:n,i=e.toIndex,o=void 0===i?t.length:i;if(s<0||s>=t.length||!Number.isInteger(s))throw new Error("fromIndex must be a positive integer smaller than length");if(o<=s||o>t.length||!Number.isInteger(o))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[s],l=s+1;l<o;l++)t[l]<a&&(a=t[l]);return a}function rescale$1(t){var e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(void 0!==n.output){if(!isAnyArray(n.output))throw new TypeError("output option must be an array if specified");e=n.output}else e=new Array(t.length);var s=min(t),i=max(t);if(s===i)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var o=n.min,a=void 0===o?n.autoMinMax?s:0:o,l=n.max,r=void 0===l?n.autoMinMax?i:1:l;if(a>=r)throw new RangeError("min option must be smaller than max option");for(var m=(r-a)/(i-s),g=0;g<t.length;g++)e[g]=(t[g]-s)*m+a;return e}const indent=" ".repeat(2),indentData=" ".repeat(4);function inspectMatrix(){return inspectMatrixWithOptions(this)}function inspectMatrixWithOptions(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{maxRows:n=15,maxColumns:s=10,maxNumSize:i=8,padMinus:o="auto"}=e;return`${t.constructor.name} {\n${indent}[\n${indentData}${inspectData(t,n,s,i,o)}\n${indent}]\n${indent}rows: ${t.rows}\n${indent}columns: ${t.columns}\n}`}function inspectData(t,e,n,s,i){const{rows:o,columns:a}=t,l=Math.min(o,e),r=Math.min(a,n),m=[];if("auto"===i){i=!1;t:for(let e=0;e<l;e++)for(let n=0;n<r;n++)if(t.get(e,n)<0){i=!0;break t}}for(let e=0;e<l;e++){let n=[];for(let o=0;o<r;o++)n.push(formatNumber(t.get(e,o),s,i));m.push(`${n.join(" ")}`)}return r!==a&&(m[m.length-1]+=` ... ${a-n} more columns`),l!==o&&m.push(`... ${o-e} more rows`),m.join(`\n${indentData}`)}function formatNumber(t,e,n){return(t>=0&&n?` ${formatNumber2(t,e-1)}`:formatNumber2(t,e)).padEnd(e)}function formatNumber2(t,e){let n=t.toString();if(n.length<=e)return n;let s=t.toFixed(e);if(s.length>e&&(s=t.toFixed(Math.max(0,e-(s.length-e)))),s.length<=e&&!s.startsWith("0.000")&&!s.startsWith("-0.000"))return s;let i=t.toExponential(e);return i.length>e&&(i=t.toExponential(Math.max(0,e-(i.length-e)))),i.slice(0)}function installMathOperations(t,e){t.prototype.add=function(t){return"number"==typeof t?this.addS(t):this.addM(t)},t.prototype.addS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)+t);return this},t.prototype.addM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)+t.get(e,n));return this},t.add=function(t,n){return new e(t).add(n)},t.prototype.sub=function(t){return"number"==typeof t?this.subS(t):this.subM(t)},t.prototype.subS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)-t);return this},t.prototype.subM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)-t.get(e,n));return this},t.sub=function(t,n){return new e(t).sub(n)},t.prototype.subtract=t.prototype.sub,t.prototype.subtractS=t.prototype.subS,t.prototype.subtractM=t.prototype.subM,t.subtract=t.sub,t.prototype.mul=function(t){return"number"==typeof t?this.mulS(t):this.mulM(t)},t.prototype.mulS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)*t);return this},t.prototype.mulM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)*t.get(e,n));return this},t.mul=function(t,n){return new e(t).mul(n)},t.prototype.multiply=t.prototype.mul,t.prototype.multiplyS=t.prototype.mulS,t.prototype.multiplyM=t.prototype.mulM,t.multiply=t.mul,t.prototype.div=function(t){return"number"==typeof t?this.divS(t):this.divM(t)},t.prototype.divS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)/t);return this},t.prototype.divM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)/t.get(e,n));return this},t.div=function(t,n){return new e(t).div(n)},t.prototype.divide=t.prototype.div,t.prototype.divideS=t.prototype.divS,t.prototype.divideM=t.prototype.divM,t.divide=t.div,t.prototype.mod=function(t){return"number"==typeof t?this.modS(t):this.modM(t)},t.prototype.modS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)%t);return this},t.prototype.modM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)%t.get(e,n));return this},t.mod=function(t,n){return new e(t).mod(n)},t.prototype.modulus=t.prototype.mod,t.prototype.modulusS=t.prototype.modS,t.prototype.modulusM=t.prototype.modM,t.modulus=t.mod,t.prototype.and=function(t){return"number"==typeof t?this.andS(t):this.andM(t)},t.prototype.andS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)&t);return this},t.prototype.andM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)&t.get(e,n));return this},t.and=function(t,n){return new e(t).and(n)},t.prototype.or=function(t){return"number"==typeof t?this.orS(t):this.orM(t)},t.prototype.orS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)|t);return this},t.prototype.orM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)|t.get(e,n));return this},t.or=function(t,n){return new e(t).or(n)},t.prototype.xor=function(t){return"number"==typeof t?this.xorS(t):this.xorM(t)},t.prototype.xorS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)^t);return this},t.prototype.xorM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)^t.get(e,n));return this},t.xor=function(t,n){return new e(t).xor(n)},t.prototype.leftShift=function(t){return"number"==typeof t?this.leftShiftS(t):this.leftShiftM(t)},t.prototype.leftShiftS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)<<t);return this},t.prototype.leftShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)<<t.get(e,n));return this},t.leftShift=function(t,n){return new e(t).leftShift(n)},t.prototype.signPropagatingRightShift=function(t){return"number"==typeof t?this.signPropagatingRightShiftS(t):this.signPropagatingRightShiftM(t)},t.prototype.signPropagatingRightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)>>t);return this},t.prototype.signPropagatingRightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)>>t.get(e,n));return this},t.signPropagatingRightShift=function(t,n){return new e(t).signPropagatingRightShift(n)},t.prototype.rightShift=function(t){return"number"==typeof t?this.rightShiftS(t):this.rightShiftM(t)},t.prototype.rightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)>>>t);return this},t.prototype.rightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)>>>t.get(e,n));return this},t.rightShift=function(t,n){return new e(t).rightShift(n)},t.prototype.zeroFillRightShift=t.prototype.rightShift,t.prototype.zeroFillRightShiftS=t.prototype.rightShiftS,t.prototype.zeroFillRightShiftM=t.prototype.rightShiftM,t.zeroFillRightShift=t.rightShift,t.prototype.not=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,~this.get(t,e));return this},t.not=function(t){return new e(t).not()},t.prototype.abs=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.abs(this.get(t,e)));return this},t.abs=function(t){return new e(t).abs()},t.prototype.acos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acos(this.get(t,e)));return this},t.acos=function(t){return new e(t).acos()},t.prototype.acosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acosh(this.get(t,e)));return this},t.acosh=function(t){return new e(t).acosh()},t.prototype.asin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asin(this.get(t,e)));return this},t.asin=function(t){return new e(t).asin()},t.prototype.asinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asinh(this.get(t,e)));return this},t.asinh=function(t){return new e(t).asinh()},t.prototype.atan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atan(this.get(t,e)));return this},t.atan=function(t){return new e(t).atan()},t.prototype.atanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atanh(this.get(t,e)));return this},t.atanh=function(t){return new e(t).atanh()},t.prototype.cbrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cbrt(this.get(t,e)));return this},t.cbrt=function(t){return new e(t).cbrt()},t.prototype.ceil=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.ceil(this.get(t,e)));return this},t.ceil=function(t){return new e(t).ceil()},t.prototype.clz32=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.clz32(this.get(t,e)));return this},t.clz32=function(t){return new e(t).clz32()},t.prototype.cos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cos(this.get(t,e)));return this},t.cos=function(t){return new e(t).cos()},t.prototype.cosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cosh(this.get(t,e)));return this},t.cosh=function(t){return new e(t).cosh()},t.prototype.exp=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.exp(this.get(t,e)));return this},t.exp=function(t){return new e(t).exp()},t.prototype.expm1=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.expm1(this.get(t,e)));return this},t.expm1=function(t){return new e(t).expm1()},t.prototype.floor=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.floor(this.get(t,e)));return this},t.floor=function(t){return new e(t).floor()},t.prototype.fround=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.fround(this.get(t,e)));return this},t.fround=function(t){return new e(t).fround()},t.prototype.log=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log(this.get(t,e)));return this},t.log=function(t){return new e(t).log()},t.prototype.log1p=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log1p(this.get(t,e)));return this},t.log1p=function(t){return new e(t).log1p()},t.prototype.log10=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log10(this.get(t,e)));return this},t.log10=function(t){return new e(t).log10()},t.prototype.log2=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log2(this.get(t,e)));return this},t.log2=function(t){return new e(t).log2()},t.prototype.round=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.round(this.get(t,e)));return this},t.round=function(t){return new e(t).round()},t.prototype.sign=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sign(this.get(t,e)));return this},t.sign=function(t){return new e(t).sign()},t.prototype.sin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sin(this.get(t,e)));return this},t.sin=function(t){return new e(t).sin()},t.prototype.sinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sinh(this.get(t,e)));return this},t.sinh=function(t){return new e(t).sinh()},t.prototype.sqrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sqrt(this.get(t,e)));return this},t.sqrt=function(t){return new e(t).sqrt()},t.prototype.tan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tan(this.get(t,e)));return this},t.tan=function(t){return new e(t).tan()},t.prototype.tanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tanh(this.get(t,e)));return this},t.tanh=function(t){return new e(t).tanh()},t.prototype.trunc=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.trunc(this.get(t,e)));return this},t.trunc=function(t){return new e(t).trunc()},t.pow=function(t,n){return new e(t).pow(n)},t.prototype.pow=function(t){return"number"==typeof t?this.powS(t):this.powM(t)},t.prototype.powS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,Math.pow(this.get(e,n),t));return this},t.prototype.powM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,Math.pow(this.get(e,n),t.get(e,n)));return this}}function checkRowIndex(t,e,n){let s=n?t.rows:t.rows-1;if(e<0||e>s)throw new RangeError("Row index out of range")}function checkColumnIndex(t,e,n){let s=n?t.columns:t.columns-1;if(e<0||e>s)throw new RangeError("Column index out of range")}function checkRowVector(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.columns)throw new RangeError("vector size must be the same as the number of columns");return e}function checkColumnVector(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.rows)throw new RangeError("vector size must be the same as the number of rows");return e}function checkRowIndices(t,e){if(!isAnyArray(e))throw new TypeError("row indices must be an array");for(let n=0;n<e.length;n++)if(e[n]<0||e[n]>=t.rows)throw new RangeError("row indices are out of range")}function checkColumnIndices(t,e){if(!isAnyArray(e))throw new TypeError("column indices must be an array");for(let n=0;n<e.length;n++)if(e[n]<0||e[n]>=t.columns)throw new RangeError("column indices are out of range")}function checkRange$1(t,e,n,s,i){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(checkNumber("startRow",e),checkNumber("endRow",n),checkNumber("startColumn",s),checkNumber("endColumn",i),e>n||s>i||e<0||e>=t.rows||n<0||n>=t.rows||s<0||s>=t.columns||i<0||i>=t.columns)throw new RangeError("Submatrix indices are out of range")}function newArray$1(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,n=[];for(let s=0;s<t;s++)n.push(e);return n}function checkNumber(t,e){if("number"!=typeof e)throw new TypeError(`${t} must be a number`)}function checkNonEmpty(t){if(t.isEmpty())throw new Error("Empty matrix has no elements to index")}function sumByRow(t){let e=newArray$1(t.rows);for(let n=0;n<t.rows;++n)for(let s=0;s<t.columns;++s)e[n]+=t.get(n,s);return e}function sumByColumn(t){let e=newArray$1(t.columns);for(let n=0;n<t.rows;++n)for(let s=0;s<t.columns;++s)e[s]+=t.get(n,s);return e}function sumAll(t){let e=0;for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)e+=t.get(n,s);return e}function productByRow(t){let e=newArray$1(t.rows,1);for(let n=0;n<t.rows;++n)for(let s=0;s<t.columns;++s)e[n]*=t.get(n,s);return e}function productByColumn(t){let e=newArray$1(t.columns,1);for(let n=0;n<t.rows;++n)for(let s=0;s<t.columns;++s)e[s]*=t.get(n,s);return e}function productAll(t){let e=1;for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)e*=t.get(n,s);return e}function varianceByRow(t,e,n){const s=t.rows,i=t.columns,o=[];for(let a=0;a<s;a++){let s=0,l=0,r=0;for(let e=0;e<i;e++)r=t.get(a,e)-n[a],s+=r,l+=r*r;e?o.push((l-s*s/i)/(i-1)):o.push((l-s*s/i)/i)}return o}function varianceByColumn(t,e,n){const s=t.rows,i=t.columns,o=[];for(let a=0;a<i;a++){let i=0,l=0,r=0;for(let e=0;e<s;e++)r=t.get(e,a)-n[a],i+=r,l+=r*r;e?o.push((l-i*i/s)/(s-1)):o.push((l-i*i/s)/s)}return o}function varianceAll(t,e,n){const s=t.rows,i=t.columns,o=s*i;let a=0,l=0,r=0;for(let e=0;e<s;e++)for(let s=0;s<i;s++)r=t.get(e,s)-n,a+=r,l+=r*r;return e?(l-a*a/o)/(o-1):(l-a*a/o)/o}function centerByRow(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)-e[n])}function centerByColumn(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)-e[s])}function centerAll(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)-e)}function getScaleByRow(t){const e=[];for(let n=0;n<t.rows;n++){let s=0;for(let e=0;e<t.columns;e++)s+=Math.pow(t.get(n,e),2)/(t.columns-1);e.push(Math.sqrt(s))}return e}function scaleByRow(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)/e[n])}function getScaleByColumn(t){const e=[];for(let n=0;n<t.columns;n++){let s=0;for(let e=0;e<t.rows;e++)s+=Math.pow(t.get(e,n),2)/(t.rows-1);e.push(Math.sqrt(s))}return e}function scaleByColumn(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)/e[s])}function getScaleAll(t){const e=t.size-1;let n=0;for(let s=0;s<t.columns;s++)for(let i=0;i<t.rows;i++)n+=Math.pow(t.get(i,s),2)/e;return Math.sqrt(n)}function scaleAll(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)/e)}class AbstractMatrix{static from1DArray(t,e,n){if(t*e!==n.length)throw new RangeError("data length does not match given dimensions");let s=new Matrix(t,e);for(let i=0;i<t;i++)for(let t=0;t<e;t++)s.set(i,t,n[i*e+t]);return s}static rowVector(t){let e=new Matrix(1,t.length);for(let n=0;n<t.length;n++)e.set(0,n,t[n]);return e}static columnVector(t){let e=new Matrix(t.length,1);for(let n=0;n<t.length;n++)e.set(n,0,t[n]);return e}static zeros(t,e){return new Matrix(t,e)}static ones(t,e){return new Matrix(t,e).fill(1)}static rand(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if("object"!=typeof n)throw new TypeError("options must be an object");const{random:s=Math.random}=n;let i=new Matrix(t,e);for(let n=0;n<t;n++)for(let t=0;t<e;t++)i.set(n,t,s());return i}static randInt(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if("object"!=typeof n)throw new TypeError("options must be an object");const{min:s=0,max:i=1e3,random:o=Math.random}=n;if(!Number.isInteger(s))throw new TypeError("min must be an integer");if(!Number.isInteger(i))throw new TypeError("max must be an integer");if(s>=i)throw new RangeError("min must be smaller than max");let a=i-s,l=new Matrix(t,e);for(let n=0;n<t;n++)for(let t=0;t<e;t++){let e=s+Math.round(o()*a);l.set(n,t,e)}return l}static eye(t,e,n){void 0===e&&(e=t),void 0===n&&(n=1);let s=Math.min(t,e),i=this.zeros(t,e);for(let t=0;t<s;t++)i.set(t,t,n);return i}static diag(t,e,n){let s=t.length;void 0===e&&(e=s),void 0===n&&(n=e);let i=Math.min(s,e,n),o=this.zeros(e,n);for(let e=0;e<i;e++)o.set(e,e,t[e]);return o}static min(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let n=t.rows,s=t.columns,i=new Matrix(n,s);for(let o=0;o<n;o++)for(let n=0;n<s;n++)i.set(o,n,Math.min(t.get(o,n),e.get(o,n)));return i}static max(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let n=t.rows,s=t.columns,i=new this(n,s);for(let o=0;o<n;o++)for(let n=0;n<s;n++)i.set(o,n,Math.max(t.get(o,n),e.get(o,n)));return i}static checkMatrix(t){return AbstractMatrix.isMatrix(t)?t:new Matrix(t)}static isMatrix(t){return null!=t&&"Matrix"===t.klass}get size(){return this.rows*this.columns}apply(t){if("function"!=typeof t)throw new TypeError("callback must be a function");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)t.call(this,e,n);return this}to1DArray(){let t=[];for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)t.push(this.get(e,n));return t}to2DArray(){let t=[];for(let e=0;e<this.rows;e++){t.push([]);for(let n=0;n<this.columns;n++)t[e].push(this.get(e,n))}return t}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let t=0;t<this.rows;t++)for(let e=0;e<=t;e++)if(this.get(t,e)!==this.get(e,t))return!1;return!0}return!1}isEchelonForm(){let t=0,e=0,n=-1,s=!0,i=!1;for(;t<this.rows&&s;){for(e=0,i=!1;e<this.columns&&!1===i;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>n?(i=!0,n=e):(s=!1,i=!0);t++}return s}isReducedEchelonForm(){let t=0,e=0,n=-1,s=!0,i=!1;for(;t<this.rows&&s;){for(e=0,i=!1;e<this.columns&&!1===i;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>n?(i=!0,n=e):(s=!1,i=!0);for(let n=e+1;n<this.rows;n++)0!==this.get(t,n)&&(s=!1);t++}return s}echelonForm(){let t=this.clone(),e=0,n=0;for(;e<t.rows&&n<t.columns;){let s=e;for(let i=e;i<t.rows;i++)t.get(i,n)>t.get(s,n)&&(s=i);if(0===t.get(s,n))n++;else{t.swapRows(e,s);let i=t.get(e,n);for(let s=n;s<t.columns;s++)t.set(e,s,t.get(e,s)/i);for(let s=e+1;s<t.rows;s++){let i=t.get(s,n)/t.get(e,n);t.set(s,n,0);for(let o=n+1;o<t.columns;o++)t.set(s,o,t.get(s,o)-t.get(e,o)*i)}e++,n++}}return t}reducedEchelonForm(){let t=this.echelonForm(),e=t.columns,n=t.rows,s=n-1;for(;s>=0;)if(0===t.maxRow(s))s--;else{let i=0,o=!1;for(;i<n&&!1===o;)1===t.get(s,i)?o=!0:i++;for(let n=0;n<s;n++){let o=t.get(n,i);for(let a=i;a<e;a++){let e=t.get(n,a)-o*t.get(s,a);t.set(n,a,e)}}s--}return t}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if("object"!=typeof t)throw new TypeError("options must be an object");const{rows:e=1,columns:n=1}=t;if(!Number.isInteger(e)||e<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(n)||n<=0)throw new TypeError("columns must be a positive integer");let s=new Matrix(this.rows*e,this.columns*n);for(let t=0;t<e;t++)for(let e=0;e<n;e++)s.setSubMatrix(this,this.rows*t,this.columns*e);return s}fill(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,t);return this}neg(){return this.mulS(-1)}getRow(t){checkRowIndex(this,t);let e=[];for(let n=0;n<this.columns;n++)e.push(this.get(t,n));return e}getRowVector(t){return Matrix.rowVector(this.getRow(t))}setRow(t,e){checkRowIndex(this,t),e=checkRowVector(this,e);for(let n=0;n<this.columns;n++)this.set(t,n,e[n]);return this}swapRows(t,e){checkRowIndex(this,t),checkRowIndex(this,e);for(let n=0;n<this.columns;n++){let s=this.get(t,n);this.set(t,n,this.get(e,n)),this.set(e,n,s)}return this}getColumn(t){checkColumnIndex(this,t);let e=[];for(let n=0;n<this.rows;n++)e.push(this.get(n,t));return e}getColumnVector(t){return Matrix.columnVector(this.getColumn(t))}setColumn(t,e){checkColumnIndex(this,t),e=checkColumnVector(this,e);for(let n=0;n<this.rows;n++)this.set(n,t,e[n]);return this}swapColumns(t,e){checkColumnIndex(this,t),checkColumnIndex(this,e);for(let n=0;n<this.rows;n++){let s=this.get(n,t);this.set(n,t,this.get(n,e)),this.set(n,e,s)}return this}addRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)+t[n]);return this}subRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)-t[n]);return this}mulRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)*t[n]);return this}divRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)/t[n]);return this}addColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)+t[e]);return this}subColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)-t[e]);return this}mulColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)*t[e]);return this}divColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)/t[e]);return this}mulRow(t,e){checkRowIndex(this,t);for(let n=0;n<this.columns;n++)this.set(t,n,this.get(t,n)*e);return this}mulColumn(t,e){checkColumnIndex(this,t);for(let n=0;n<this.rows;n++)this.set(n,t,this.get(n,t)*e);return this}max(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)>t[e]&&(t[e]=this.get(e,n));return t}case"column":{const t=new Array(this.columns).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)>t[n]&&(t[n]=this.get(e,n));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)>t&&(t=this.get(e,n));return t}default:throw new Error(`invalid option: ${t}`)}}maxIndex(){checkNonEmpty(this);let t=this.get(0,0),e=[0,0];for(let n=0;n<this.rows;n++)for(let s=0;s<this.columns;s++)this.get(n,s)>t&&(t=this.get(n,s),e[0]=n,e[1]=s);return e}min(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)<t[e]&&(t[e]=this.get(e,n));return t}case"column":{const t=new Array(this.columns).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)<t[n]&&(t[n]=this.get(e,n));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)<t&&(t=this.get(e,n));return t}default:throw new Error(`invalid option: ${t}`)}}minIndex(){checkNonEmpty(this);let t=this.get(0,0),e=[0,0];for(let n=0;n<this.rows;n++)for(let s=0;s<this.columns;s++)this.get(n,s)<t&&(t=this.get(n,s),e[0]=n,e[1]=s);return e}maxRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let n=1;n<this.columns;n++)this.get(t,n)>e&&(e=this.get(t,n));return e}maxRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let e=this.get(t,0),n=[t,0];for(let s=1;s<this.columns;s++)this.get(t,s)>e&&(e=this.get(t,s),n[1]=s);return n}minRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let n=1;n<this.columns;n++)this.get(t,n)<e&&(e=this.get(t,n));return e}minRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let e=this.get(t,0),n=[t,0];for(let s=1;s<this.columns;s++)this.get(t,s)<e&&(e=this.get(t,s),n[1]=s);return n}maxColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let n=1;n<this.rows;n++)this.get(n,t)>e&&(e=this.get(n,t));return e}maxColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let e=this.get(0,t),n=[0,t];for(let s=1;s<this.rows;s++)this.get(s,t)>e&&(e=this.get(s,t),n[0]=s);return n}minColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let n=1;n<this.rows;n++)this.get(n,t)<e&&(e=this.get(n,t));return e}minColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let e=this.get(0,t),n=[0,t];for(let s=1;s<this.rows;s++)this.get(s,t)<e&&(e=this.get(s,t),n[0]=s);return n}diag(){let t=Math.min(this.rows,this.columns),e=[];for(let n=0;n<t;n++)e.push(this.get(n,n));return e}norm(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"frobenius",e=0;if("max"===t)return this.max();if("frobenius"===t){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)e+=this.get(t,n)*this.get(t,n);return Math.sqrt(e)}throw new RangeError(`unknown norm type: ${t}`)}cumulativeSum(){let t=0;for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)t+=this.get(e,n),this.set(e,n,t);return this}dot(t){AbstractMatrix.isMatrix(t)&&(t=t.to1DArray());let e=this.to1DArray();if(e.length!==t.length)throw new RangeError("vectors do not have the same size");let n=0;for(let s=0;s<e.length;s++)n+=e[s]*t[s];return n}mmul(t){t=Matrix.checkMatrix(t);let e=this.rows,n=this.columns,s=t.columns,i=new Matrix(e,s),o=new Float64Array(n);for(let a=0;a<s;a++){for(let e=0;e<n;e++)o[e]=t.get(e,a);for(let t=0;t<e;t++){let e=0;for(let s=0;s<n;s++)e+=this.get(t,s)*o[s];i.set(t,a,e)}}return i}strassen2x2(t){t=Matrix.checkMatrix(t);let e=new Matrix(2,2);const n=this.get(0,0),s=t.get(0,0),i=this.get(0,1),o=t.get(0,1),a=this.get(1,0),l=t.get(1,0),r=this.get(1,1),m=t.get(1,1),g=(n+r)*(s+m),u=(a+r)*s,c=n*(o-m),C=r*(l-s),f=(n+i)*m,h=g+C-f+(i-r)*(l+m),p=c+f,d=u+C,y=g-u+c+(a-n)*(s+o);return e.set(0,0,h),e.set(0,1,p),e.set(1,0,d),e.set(1,1,y),e}strassen3x3(t){t=Matrix.checkMatrix(t);let e=new Matrix(3,3);const n=this.get(0,0),s=this.get(0,1),i=this.get(0,2),o=this.get(1,0),a=this.get(1,1),l=this.get(1,2),r=this.get(2,0),m=this.get(2,1),g=this.get(2,2),u=t.get(0,0),c=t.get(0,1),C=t.get(0,2),f=t.get(1,0),h=t.get(1,1),p=t.get(1,2),d=t.get(2,0),y=t.get(2,1),H=t.get(2,2),v=(n-o)*(-c+h),b=(-n+o+a)*(u-c+h),w=(o+a)*(-u+c),x=n*u,O=(-n+r+m)*(u-C+p),D=(-n+r)*(C-p),A=(r+m)*(-u+C),S=(-i+m+g)*(h+d-y),M=(i-g)*(h-y),j=i*d,$=(m+g)*(-d+y),T=(-i+a+l)*(p+d-H),_=(i-l)*(p-H),N=(a+l)*(-d+H),F=x+j+s*f,E=(n+s+i-o-a-m-g)*h+b+w+x+S+j+$,k=x+O+A+(n+s+i-a-l-r-m)*p+j+T+N,I=v+a*(-u+c+f-h-p-d+H)+b+x+j+T+_,P=v+b+w+x+l*y,R=j+T+_+N+o*C,z=x+O+D+m*(-u+C+f-h-p-d+y)+S+M+j,L=S+M+j+$+r*c,q=x+O+D+A+g*H;return e.set(0,0,F),e.set(0,1,E),e.set(0,2,k),e.set(1,0,I),e.set(1,1,P),e.set(1,2,R),e.set(2,0,z),e.set(2,1,L),e.set(2,2,q),e}mmulStrassen(t){t=Matrix.checkMatrix(t);let e=this.clone(),n=e.rows,s=e.columns,i=t.rows,o=t.columns;function a(t,e,n){let s=t.rows,i=t.columns;if(s===e&&i===n)return t;{let s=AbstractMatrix.zeros(e,n);return s=s.setSubMatrix(t,0,0),s}}s!==i&&console.warn(`Multiplying ${n} x ${s} and ${i} x ${o} matrix: dimensions do not match.`);let l=Math.max(n,i),r=Math.max(s,o);return e=a(e,l,r),function t(e,n,s,i){if(s<=512||i<=512)return e.mmul(n);s%2==1&&i%2==1?(e=a(e,s+1,i+1),n=a(n,s+1,i+1)):s%2==1?(e=a(e,s+1,i),n=a(n,s+1,i)):i%2==1&&(e=a(e,s,i+1),n=a(n,s,i+1));let o=parseInt(e.rows/2,10),l=parseInt(e.columns/2,10),r=e.subMatrix(0,o-1,0,l-1),m=n.subMatrix(0,o-1,0,l-1),g=e.subMatrix(0,o-1,l,e.columns-1),u=n.subMatrix(0,o-1,l,n.columns-1),c=e.subMatrix(o,e.rows-1,0,l-1),C=n.subMatrix(o,n.rows-1,0,l-1),f=e.subMatrix(o,e.rows-1,l,e.columns-1),h=n.subMatrix(o,n.rows-1,l,n.columns-1),p=t(AbstractMatrix.add(r,f),AbstractMatrix.add(m,h),o,l),d=t(AbstractMatrix.add(c,f),m,o,l),y=t(r,AbstractMatrix.sub(u,h),o,l),H=t(f,AbstractMatrix.sub(C,m),o,l),v=t(AbstractMatrix.add(r,g),h,o,l),b=t(AbstractMatrix.sub(c,r),AbstractMatrix.add(m,u),o,l),w=t(AbstractMatrix.sub(g,f),AbstractMatrix.add(C,h),o,l),x=AbstractMatrix.add(p,H);x.sub(v),x.add(w);let O=AbstractMatrix.add(y,v),D=AbstractMatrix.add(d,H),A=AbstractMatrix.sub(p,d);A.add(y),A.add(b);let S=AbstractMatrix.zeros(2*x.rows,2*x.columns);return S=S.setSubMatrix(x,0,0),S=S.setSubMatrix(O,x.rows,0),S=S.setSubMatrix(D,0,x.columns),S=S.setSubMatrix(A,x.rows,x.columns),S.subMatrix(0,s-1,0,i-1)}(e,t=a(t,l,r),l,r)}scaleRows(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:n=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(n))throw new TypeError("max must be a number");if(e>=n)throw new RangeError("min must be smaller than max");let s=new Matrix(this.rows,this.columns);for(let t=0;t<this.rows;t++){const i=this.getRow(t);i.length>0&&rescale$1(i,{min:e,max:n,output:i}),s.setRow(t,i)}return s}scaleColumns(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:n=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(n))throw new TypeError("max must be a number");if(e>=n)throw new RangeError("min must be smaller than max");let s=new Matrix(this.rows,this.columns);for(let t=0;t<this.columns;t++){const i=this.getColumn(t);i.length&&rescale$1(i,{min:e,max:n,output:i}),s.setColumn(t,i)}return s}flipRows(){const t=Math.ceil(this.columns/2);for(let e=0;e<this.rows;e++)for(let n=0;n<t;n++){let t=this.get(e,n),s=this.get(e,this.columns-1-n);this.set(e,n,s),this.set(e,this.columns-1-n,t)}return this}flipColumns(){const t=Math.ceil(this.rows/2);for(let e=0;e<this.columns;e++)for(let n=0;n<t;n++){let t=this.get(n,e),s=this.get(this.rows-1-n,e);this.set(n,e,s),this.set(this.rows-1-n,e,t)}return this}kroneckerProduct(t){t=Matrix.checkMatrix(t);let e=this.rows,n=this.columns,s=t.rows,i=t.columns,o=new Matrix(e*s,n*i);for(let a=0;a<e;a++)for(let e=0;e<n;e++)for(let n=0;n<s;n++)for(let l=0;l<i;l++)o.set(s*a+n,i*e+l,this.get(a,e)*t.get(n,l));return o}kroneckerSum(t){if(t=Matrix.checkMatrix(t),!this.isSquare()||!t.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let e=this.rows,n=t.rows,s=this.kroneckerProduct(Matrix.eye(n,n)),i=Matrix.eye(e,e).kroneckerProduct(t);return s.add(i)}transpose(){let t=new Matrix(this.columns,this.rows);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)t.set(n,e,this.get(e,n));return t}sortRows(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:compareNumbers;for(let e=0;e<this.rows;e++)this.setRow(e,this.getRow(e).sort(t));return this}sortColumns(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:compareNumbers;for(let e=0;e<this.columns;e++)this.setColumn(e,this.getColumn(e).sort(t));return this}subMatrix(t,e,n,s){checkRange$1(this,t,e,n,s);let i=new Matrix(e-t+1,s-n+1);for(let o=t;o<=e;o++)for(let e=n;e<=s;e++)i.set(o-t,e-n,this.get(o,e));return i}subMatrixRow(t,e,n){if(void 0===e&&(e=0),void 0===n&&(n=this.columns-1),e>n||e<0||e>=this.columns||n<0||n>=this.columns)throw new RangeError("Argument out of range");let s=new Matrix(t.length,n-e+1);for(let i=0;i<t.length;i++)for(let o=e;o<=n;o++){if(t[i]<0||t[i]>=this.rows)throw new RangeError(`Row index out of range: ${t[i]}`);s.set(i,o-e,this.get(t[i],o))}return s}subMatrixColumn(t,e,n){if(void 0===e&&(e=0),void 0===n&&(n=this.rows-1),e>n||e<0||e>=this.rows||n<0||n>=this.rows)throw new RangeError("Argument out of range");let s=new Matrix(n-e+1,t.length);for(let i=0;i<t.length;i++)for(let o=e;o<=n;o++){if(t[i]<0||t[i]>=this.columns)throw new RangeError(`Column index out of range: ${t[i]}`);s.set(o-e,i,this.get(o,t[i]))}return s}setSubMatrix(t,e,n){if((t=Matrix.checkMatrix(t)).isEmpty())return this;checkRange$1(this,e,e+t.rows-1,n,n+t.columns-1);for(let s=0;s<t.rows;s++)for(let i=0;i<t.columns;i++)this.set(e+s,n+i,t.get(s,i));return this}selection(t,e){checkRowIndices(this,t),checkColumnIndices(this,e);let n=new Matrix(t.length,e.length);for(let s=0;s<t.length;s++){let i=t[s];for(let t=0;t<e.length;t++){let o=e[t];n.set(s,t,this.get(i,o))}}return n}trace(){let t=Math.min(this.rows,this.columns),e=0;for(let n=0;n<t;n++)e+=this.get(n,n);return e}clone(){let t=new Matrix(this.rows,this.columns);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)t.set(e,n,this.get(e,n));return t}sum(t){switch(t){case"row":return sumByRow(this);case"column":return sumByColumn(this);case void 0:return sumAll(this);default:throw new Error(`invalid option: ${t}`)}}product(t){switch(t){case"row":return productByRow(this);case"column":return productByColumn(this);case void 0:return productAll(this);default:throw new Error(`invalid option: ${t}`)}}mean(t){const e=this.sum(t);switch(t){case"row":for(let t=0;t<this.rows;t++)e[t]/=this.columns;return e;case"column":for(let t=0;t<this.columns;t++)e[t]/=this.rows;return e;case void 0:return e/this.size;default:throw new Error(`invalid option: ${t}`)}}variance(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{unbiased:n=!0,mean:s=this.mean(t)}=e;if("boolean"!=typeof n)throw new TypeError("unbiased must be a boolean");switch(t){case"row":if(!isAnyArray(s))throw new TypeError("mean must be an array");return varianceByRow(this,n,s);case"column":if(!isAnyArray(s))throw new TypeError("mean must be an array");return varianceByColumn(this,n,s);case void 0:if("number"!=typeof s)throw new TypeError("mean must be a number");return varianceAll(this,n,s);default:throw new Error(`invalid option: ${t}`)}}standardDeviation(t,e){"object"==typeof t&&(e=t,t=void 0);const n=this.variance(t,e);if(void 0===t)return Math.sqrt(n);for(let t=0;t<n.length;t++)n[t]=Math.sqrt(n[t]);return n}center(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{center:n=this.mean(t)}=e;switch(t){case"row":if(!isAnyArray(n))throw new TypeError("center must be an array");return centerByRow(this,n),this;case"column":if(!isAnyArray(n))throw new TypeError("center must be an array");return centerByColumn(this,n),this;case void 0:if("number"!=typeof n)throw new TypeError("center must be a number");return centerAll(this,n),this;default:throw new Error(`invalid option: ${t}`)}}scale(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");let n=e.scale;switch(t){case"row":if(void 0===n)n=getScaleByRow(this);else if(!isAnyArray(n))throw new TypeError("scale must be an array");return scaleByRow(this,n),this;case"column":if(void 0===n)n=getScaleByColumn(this);else if(!isAnyArray(n))throw new TypeError("scale must be an array");return scaleByColumn(this,n),this;case void 0:if(void 0===n)n=getScaleAll(this);else if("number"!=typeof n)throw new TypeError("scale must be a number");return scaleAll(this,n),this;default:throw new Error(`invalid option: ${t}`)}}toString(t){return inspectMatrixWithOptions(this,t)}}function compareNumbers(t,e){return t-e}function isArrayOfNumbers(t){return t.every((t=>"number"==typeof t))}AbstractMatrix.prototype.klass="Matrix","undefined"!=typeof Symbol&&(AbstractMatrix.prototype[Symbol.for("nodejs.util.inspect.custom")]=inspectMatrix),AbstractMatrix.random=AbstractMatrix.rand,AbstractMatrix.randomInt=AbstractMatrix.randInt,AbstractMatrix.diagonal=AbstractMatrix.diag,AbstractMatrix.prototype.diagonal=AbstractMatrix.prototype.diag,AbstractMatrix.identity=AbstractMatrix.eye,AbstractMatrix.prototype.negate=AbstractMatrix.prototype.neg,AbstractMatrix.prototype.tensorProduct=AbstractMatrix.prototype.kroneckerProduct;class Matrix extends AbstractMatrix{constructor(t,e){if(super(),Matrix.isMatrix(t))return t.clone();if(Number.isInteger(t)&&t>=0){if(this.data=[],!(Number.isInteger(e)&&e>=0))throw new TypeError("nColumns must be a positive integer");for(let n=0;n<t;n++)this.data.push(new Float64Array(e))}else{if(!isAnyArray(t))throw new TypeError("First argument must be a positive number or an array");{const n=t;if("number"!=typeof(e=(t=n.length)?n[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let s=0;s<t;s++){if(n[s].length!==e)throw new RangeError("Inconsistent array dimensions");if(!isArrayOfNumbers(n[s]))throw new TypeError("Input data contains non-numeric values");this.data.push(Float64Array.from(n[s]))}}}this.rows=t,this.columns=e}set(t,e,n){return this.data[t][e]=n,this}get(t,e){return this.data[t][e]}removeRow(t){return checkRowIndex(this,t),this.data.splice(t,1),this.rows-=1,this}addRow(t,e){return void 0===e&&(e=t,t=this.rows),checkRowIndex(this,t,!0),e=Float64Array.from(checkRowVector(this,e)),this.data.splice(t,0,e),this.rows+=1,this}removeColumn(t){checkColumnIndex(this,t);for(let e=0;e<this.rows;e++){const n=new Float64Array(this.columns-1);for(let s=0;s<t;s++)n[s]=this.data[e][s];for(let s=t+1;s<this.columns;s++)n[s-1]=this.data[e][s];this.data[e]=n}return this.columns-=1,this}addColumn(t,e){void 0===e&&(e=t,t=this.columns),checkColumnIndex(this,t,!0),e=checkColumnVector(this,e);for(let n=0;n<this.rows;n++){const s=new Float64Array(this.columns+1);let i=0;for(;i<t;i++)s[i]=this.data[n][i];for(s[i++]=e[n];i<this.columns+1;i++)s[i]=this.data[n][i-1];this.data[n]=s}return this.columns+=1,this}}installMathOperations(AbstractMatrix,Matrix);class BaseView extends AbstractMatrix{constructor(t,e,n){super(),this.matrix=t,this.rows=e,this.columns=n}}class MatrixTransposeView extends BaseView{constructor(t){super(t,t.columns,t.rows)}set(t,e,n){return this.matrix.set(e,t,n),this}get(t,e){return this.matrix.get(e,t)}}class WrapperMatrix2D extends AbstractMatrix{constructor(t){super(),this.data=t,this.rows=t.length,this.columns=t[0].length}set(t,e,n){return this.data[t][e]=n,this}get(t,e){return this.data[t][e]}}class LuDecomposition{constructor(t){let e,n,s,i,o,a,l,r,m,g=(t=WrapperMatrix2D.checkMatrix(t)).clone(),u=g.rows,c=g.columns,C=new Float64Array(u),f=1;for(e=0;e<u;e++)C[e]=e;for(r=new Float64Array(u),n=0;n<c;n++){for(e=0;e<u;e++)r[e]=g.get(e,n);for(e=0;e<u;e++){for(m=Math.min(e,n),o=0,s=0;s<m;s++)o+=g.get(e,s)*r[s];r[e]-=o,g.set(e,n,r[e])}for(i=n,e=n+1;e<u;e++)Math.abs(r[e])>Math.abs(r[i])&&(i=e);if(i!==n){for(s=0;s<c;s++)a=g.get(i,s),g.set(i,s,g.get(n,s)),g.set(n,s,a);l=C[i],C[i]=C[n],C[n]=l,f=-f}if(n<u&&0!==g.get(n,n))for(e=n+1;e<u;e++)g.set(e,n,g.get(e,n)/g.get(n,n))}this.LU=g,this.pivotVector=C,this.pivotSign=f}isSingular(){let t=this.LU,e=t.columns;for(let n=0;n<e;n++)if(0===t.get(n,n))return!0;return!1}solve(t){t=Matrix.checkMatrix(t);let e=this.LU;if(e.rows!==t.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let n,s,i,o=t.columns,a=t.subMatrixRow(this.pivotVector,0,o-1),l=e.columns;for(i=0;i<l;i++)for(n=i+1;n<l;n++)for(s=0;s<o;s++)a.set(n,s,a.get(n,s)-a.get(i,s)*e.get(n,i));for(i=l-1;i>=0;i--){for(s=0;s<o;s++)a.set(i,s,a.get(i,s)/e.get(i,i));for(n=0;n<i;n++)for(s=0;s<o;s++)a.set(n,s,a.get(n,s)-a.get(i,s)*e.get(n,i))}return a}get determinant(){let t=this.LU;if(!t.isSquare())throw new Error("Matrix must be square");let e=this.pivotSign,n=t.columns;for(let s=0;s<n;s++)e*=t.get(s,s);return e}get lowerTriangularMatrix(){let t=this.LU,e=t.rows,n=t.columns,s=new Matrix(e,n);for(let i=0;i<e;i++)for(let e=0;e<n;e++)i>e?s.set(i,e,t.get(i,e)):i===e?s.set(i,e,1):s.set(i,e,0);return s}get upperTriangularMatrix(){let t=this.LU,e=t.rows,n=t.columns,s=new Matrix(e,n);for(let i=0;i<e;i++)for(let e=0;e<n;e++)i<=e?s.set(i,e,t.get(i,e)):s.set(i,e,0);return s}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function hypotenuse(t,e){let n=0;return Math.abs(t)>Math.abs(e)?(n=e/t,Math.abs(t)*Math.sqrt(1+n*n)):0!==e?(n=t/e,Math.abs(e)*Math.sqrt(1+n*n)):0}class QrDecomposition{constructor(t){let e,n,s,i,o=(t=WrapperMatrix2D.checkMatrix(t)).clone(),a=t.rows,l=t.columns,r=new Float64Array(l);for(s=0;s<l;s++){let t=0;for(e=s;e<a;e++)t=hypotenuse(t,o.get(e,s));if(0!==t){for(o.get(s,s)<0&&(t=-t),e=s;e<a;e++)o.set(e,s,o.get(e,s)/t);for(o.set(s,s,o.get(s,s)+1),n=s+1;n<l;n++){for(i=0,e=s;e<a;e++)i+=o.get(e,s)*o.get(e,n);for(i=-i/o.get(s,s),e=s;e<a;e++)o.set(e,n,o.get(e,n)+i*o.get(e,s))}}r[s]=-t}this.QR=o,this.Rdiag=r}solve(t){t=Matrix.checkMatrix(t);let e=this.QR,n=e.rows;if(t.rows!==n)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let s,i,o,a,l=t.columns,r=t.clone(),m=e.columns;for(o=0;o<m;o++)for(i=0;i<l;i++){for(a=0,s=o;s<n;s++)a+=e.get(s,o)*r.get(s,i);for(a=-a/e.get(o,o),s=o;s<n;s++)r.set(s,i,r.get(s,i)+a*e.get(s,o))}for(o=m-1;o>=0;o--){for(i=0;i<l;i++)r.set(o,i,r.get(o,i)/this.Rdiag[o]);for(s=0;s<o;s++)for(i=0;i<l;i++)r.set(s,i,r.get(s,i)-r.get(o,i)*e.get(s,o))}return r.subMatrix(0,m-1,0,l-1)}isFullRank(){let t=this.QR.columns;for(let e=0;e<t;e++)if(0===this.Rdiag[e])return!1;return!0}get upperTriangularMatrix(){let t,e,n=this.QR,s=n.columns,i=new Matrix(s,s);for(t=0;t<s;t++)for(e=0;e<s;e++)t<e?i.set(t,e,n.get(t,e)):t===e?i.set(t,e,this.Rdiag[t]):i.set(t,e,0);return i}get orthogonalMatrix(){let t,e,n,s,i=this.QR,o=i.rows,a=i.columns,l=new Matrix(o,a);for(n=a-1;n>=0;n--){for(t=0;t<o;t++)l.set(t,n,0);for(l.set(n,n,1),e=n;e<a;e++)if(0!==i.get(n,n)){for(s=0,t=n;t<o;t++)s+=i.get(t,n)*l.get(t,e);for(s=-s/i.get(n,n),t=n;t<o;t++)l.set(t,e,l.get(t,e)+s*i.get(t,n))}}return l}}class SingularValueDecomposition{constructor(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if((t=WrapperMatrix2D.checkMatrix(t)).isEmpty())throw new Error("Matrix must be non-empty");let n=t.rows,s=t.columns;const{computeLeftSingularVectors:i=!0,computeRightSingularVectors:o=!0,autoTranspose:a=!1}=e;let l,r=Boolean(i),m=Boolean(o),g=!1;if(n<s)if(a){l=t.transpose(),n=l.rows,s=l.columns,g=!0;let e=r;r=m,m=e}else l=t.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else l=t.clone();let u=Math.min(n,s),c=Math.min(n+1,s),C=new Float64Array(c),f=new Matrix(n,u),h=new Matrix(s,s),p=new Float64Array(s),d=new Float64Array(n),y=new Float64Array(c);for(let t=0;t<c;t++)y[t]=t;let H=Math.min(n-1,s),v=Math.max(0,Math.min(s-2,n)),b=Math.max(H,v);for(let t=0;t<b;t++){if(t<H){C[t]=0;for(let e=t;e<n;e++)C[t]=hypotenuse(C[t],l.get(e,t));if(0!==C[t]){l.get(t,t)<0&&(C[t]=-C[t]);for(let e=t;e<n;e++)l.set(e,t,l.get(e,t)/C[t]);l.set(t,t,l.get(t,t)+1)}C[t]=-C[t]}for(let e=t+1;e<s;e++){if(t<H&&0!==C[t]){let s=0;for(let i=t;i<n;i++)s+=l.get(i,t)*l.get(i,e);s=-s/l.get(t,t);for(let i=t;i<n;i++)l.set(i,e,l.get(i,e)+s*l.get(i,t))}p[e]=l.get(t,e)}if(r&&t<H)for(let e=t;e<n;e++)f.set(e,t,l.get(e,t));if(t<v){p[t]=0;for(let e=t+1;e<s;e++)p[t]=hypotenuse(p[t],p[e]);if(0!==p[t]){p[t+1]<0&&(p[t]=0-p[t]);for(let e=t+1;e<s;e++)p[e]/=p[t];p[t+1]+=1}if(p[t]=-p[t],t+1<n&&0!==p[t]){for(let e=t+1;e<n;e++)d[e]=0;for(let e=t+1;e<n;e++)for(let n=t+1;n<s;n++)d[e]+=p[n]*l.get(e,n);for(let e=t+1;e<s;e++){let s=-p[e]/p[t+1];for(let i=t+1;i<n;i++)l.set(i,e,l.get(i,e)+s*d[i])}}if(m)for(let e=t+1;e<s;e++)h.set(e,t,p[e])}}let w=Math.min(s,n+1);if(H<s&&(C[H]=l.get(H,H)),n<w&&(C[w-1]=0),v+1<w&&(p[v]=l.get(v,w-1)),p[w-1]=0,r){for(let t=H;t<u;t++){for(let e=0;e<n;e++)f.set(e,t,0);f.set(t,t,1)}for(let t=H-1;t>=0;t--)if(0!==C[t]){for(let e=t+1;e<u;e++){let s=0;for(let i=t;i<n;i++)s+=f.get(i,t)*f.get(i,e);s=-s/f.get(t,t);for(let i=t;i<n;i++)f.set(i,e,f.get(i,e)+s*f.get(i,t))}for(let e=t;e<n;e++)f.set(e,t,-f.get(e,t));f.set(t,t,1+f.get(t,t));for(let e=0;e<t-1;e++)f.set(e,t,0)}else{for(let e=0;e<n;e++)f.set(e,t,0);f.set(t,t,1)}}if(m)for(let t=s-1;t>=0;t--){if(t<v&&0!==p[t])for(let e=t+1;e<s;e++){let n=0;for(let i=t+1;i<s;i++)n+=h.get(i,t)*h.get(i,e);n=-n/h.get(t+1,t);for(let i=t+1;i<s;i++)h.set(i,e,h.get(i,e)+n*h.get(i,t))}for(let e=0;e<s;e++)h.set(e,t,0);h.set(t,t,1)}let x=w-1,O=Number.EPSILON;for(;w>0;){let t,e;for(t=w-2;t>=-1&&-1!==t;t--){const e=Number.MIN_VALUE+O*Math.abs(C[t]+Math.abs(C[t+1]));if(Math.abs(p[t])<=e||Number.isNaN(p[t])){p[t]=0;break}}if(t===w-2)e=4;else{let n;for(n=w-1;n>=t&&n!==t;n--){let e=(n!==w?Math.abs(p[n]):0)+(n!==t+1?Math.abs(p[n-1]):0);if(Math.abs(C[n])<=O*e){C[n]=0;break}}n===t?e=3:n===w-1?e=1:(e=2,t=n)}switch(t++,e){case 1:{let e=p[w-2];p[w-2]=0;for(let n=w-2;n>=t;n--){let i=hypotenuse(C[n],e),o=C[n]/i,a=e/i;if(C[n]=i,n!==t&&(e=-a*p[n-1],p[n-1]=o*p[n-1]),m)for(let t=0;t<s;t++)i=o*h.get(t,n)+a*h.get(t,w-1),h.set(t,w-1,-a*h.get(t,n)+o*h.get(t,w-1)),h.set(t,n,i)}break}case 2:{let e=p[t-1];p[t-1]=0;for(let s=t;s<w;s++){let i=hypotenuse(C[s],e),o=C[s]/i,a=e/i;if(C[s]=i,e=-a*p[s],p[s]=o*p[s],r)for(let e=0;e<n;e++)i=o*f.get(e,s)+a*f.get(e,t-1),f.set(e,t-1,-a*f.get(e,s)+o*f.get(e,t-1)),f.set(e,s,i)}break}case 3:{const e=Math.max(Math.abs(C[w-1]),Math.abs(C[w-2]),Math.abs(p[w-2]),Math.abs(C[t]),Math.abs(p[t])),i=C[w-1]/e,o=C[w-2]/e,a=p[w-2]/e,l=C[t]/e,g=p[t]/e,u=((o+i)*(o-i)+a*a)/2,c=i*a*(i*a);let d=0;0===u&&0===c||(d=u<0?0-Math.sqrt(u*u+c):Math.sqrt(u*u+c),d=c/(u+d));let y=(l+i)*(l-i)+d,H=l*g;for(let e=t;e<w-1;e++){let i=hypotenuse(y,H);0===i&&(i=Number.MIN_VALUE);let o=y/i,a=H/i;if(e!==t&&(p[e-1]=i),y=o*C[e]+a*p[e],p[e]=o*p[e]-a*C[e],H=a*C[e+1],C[e+1]=o*C[e+1],m)for(let t=0;t<s;t++)i=o*h.get(t,e)+a*h.get(t,e+1),h.set(t,e+1,-a*h.get(t,e)+o*h.get(t,e+1)),h.set(t,e,i);if(i=hypotenuse(y,H),0===i&&(i=Number.MIN_VALUE),o=y/i,a=H/i,C[e]=i,y=o*p[e]+a*C[e+1],C[e+1]=-a*p[e]+o*C[e+1],H=a*p[e+1],p[e+1]=o*p[e+1],r&&e<n-1)for(let t=0;t<n;t++)i=o*f.get(t,e)+a*f.get(t,e+1),f.set(t,e+1,-a*f.get(t,e)+o*f.get(t,e+1)),f.set(t,e,i)}p[w-2]=y;break}case 4:if(C[t]<=0&&(C[t]=C[t]<0?-C[t]:0,m))for(let e=0;e<=x;e++)h.set(e,t,-h.get(e,t));for(;t<x&&!(C[t]>=C[t+1]);){let e=C[t];if(C[t]=C[t+1],C[t+1]=e,m&&t<s-1)for(let n=0;n<s;n++)e=h.get(n,t+1),h.set(n,t+1,h.get(n,t)),h.set(n,t,e);if(r&&t<n-1)for(let s=0;s<n;s++)e=f.get(s,t+1),f.set(s,t+1,f.get(s,t)),f.set(s,t,e);t++}w--}}if(g){let t=h;h=f,f=t}this.m=n,this.n=s,this.s=C,this.U=f,this.V=h}solve(t){let e=t,n=this.threshold,s=this.s.length,i=Matrix.zeros(s,s);for(let t=0;t<s;t++)Math.abs(this.s[t])<=n?i.set(t,t,0):i.set(t,t,1/this.s[t]);let o=this.U,a=this.rightSingularVectors,l=a.mmul(i),r=a.rows,m=o.rows,g=Matrix.zeros(r,m);for(let t=0;t<r;t++)for(let e=0;e<m;e++){let n=0;for(let i=0;i<s;i++)n+=l.get(t,i)*o.get(e,i);g.set(t,e,n)}return g.mmul(e)}solveForDiagonal(t){return this.solve(Matrix.diag(t))}inverse(){let t=this.V,e=this.threshold,n=t.rows,s=t.columns,i=new Matrix(n,this.s.length);for(let o=0;o<n;o++)for(let n=0;n<s;n++)Math.abs(this.s[n])>e&&i.set(o,n,t.get(o,n)/this.s[n]);let o=this.U,a=o.rows,l=o.columns,r=new Matrix(n,a);for(let t=0;t<n;t++)for(let e=0;e<a;e++){let n=0;for(let s=0;s<l;s++)n+=i.get(t,s)*o.get(e,s);r.set(t,e,n)}return r}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let t=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,e=0,n=this.s;for(let s=0,i=n.length;s<i;s++)n[s]>t&&e++;return e}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return Matrix.diag(this.s)}}function inverse(t){let e=arguments.length>1&&void 0!==arguments[1]&&arguments[1];return t=WrapperMatrix2D.checkMatrix(t),e?new SingularValueDecomposition(t).inverse():solve(t,Matrix.eye(t.rows))}function solve(t,e){let n=arguments.length>2&&void 0!==arguments[2]&&arguments[2];return t=WrapperMatrix2D.checkMatrix(t),e=WrapperMatrix2D.checkMatrix(e),n?new SingularValueDecomposition(t).solve(e):t.isSquare()?new LuDecomposition(t).solve(e):new QrDecomposition(t).solve(e)}class EigenvalueDecomposition{constructor(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{assumeSymmetric:n=!1}=e;if(!(t=WrapperMatrix2D.checkMatrix(t)).isSquare())throw new Error("Matrix is not a square matrix");if(t.isEmpty())throw new Error("Matrix must be non-empty");let s,i,o=t.columns,a=new Matrix(o,o),l=new Float64Array(o),r=new Float64Array(o),m=t,g=!1;if(g=!!n||t.isSymmetric(),g){for(s=0;s<o;s++)for(i=0;i<o;i++)a.set(s,i,m.get(s,i));tred2(o,r,l,a),tql2(o,r,l,a)}else{let t=new Matrix(o,o),e=new Float64Array(o);for(i=0;i<o;i++)for(s=0;s<o;s++)t.set(s,i,m.get(s,i));orthes(o,t,e,a),hqr2(o,r,l,a,t)}this.n=o,this.e=r,this.d=l,this.V=a}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let t,e,n=this.n,s=this.e,i=this.d,o=new Matrix(n,n);for(t=0;t<n;t++){for(e=0;e<n;e++)o.set(t,e,0);o.set(t,t,i[t]),s[t]>0?o.set(t,t+1,s[t]):s[t]<0&&o.set(t,t-1,s[t])}return o}}function tred2(t,e,n,s){let i,o,a,l,r,m,g,u;for(r=0;r<t;r++)n[r]=s.get(t-1,r);for(l=t-1;l>0;l--){for(u=0,a=0,m=0;m<l;m++)u+=Math.abs(n[m]);if(0===u)for(e[l]=n[l-1],r=0;r<l;r++)n[r]=s.get(l-1,r),s.set(l,r,0),s.set(r,l,0);else{for(m=0;m<l;m++)n[m]/=u,a+=n[m]*n[m];for(i=n[l-1],o=Math.sqrt(a),i>0&&(o=-o),e[l]=u*o,a-=i*o,n[l-1]=i-o,r=0;r<l;r++)e[r]=0;for(r=0;r<l;r++){for(i=n[r],s.set(r,l,i),o=e[r]+s.get(r,r)*i,m=r+1;m<=l-1;m++)o+=s.get(m,r)*n[m],e[m]+=s.get(m,r)*i;e[r]=o}for(i=0,r=0;r<l;r++)e[r]/=a,i+=e[r]*n[r];for(g=i/(a+a),r=0;r<l;r++)e[r]-=g*n[r];for(r=0;r<l;r++){for(i=n[r],o=e[r],m=r;m<=l-1;m++)s.set(m,r,s.get(m,r)-(i*e[m]+o*n[m]));n[r]=s.get(l-1,r),s.set(l,r,0)}}n[l]=a}for(l=0;l<t-1;l++){if(s.set(t-1,l,s.get(l,l)),s.set(l,l,1),a=n[l+1],0!==a){for(m=0;m<=l;m++)n[m]=s.get(m,l+1)/a;for(r=0;r<=l;r++){for(o=0,m=0;m<=l;m++)o+=s.get(m,l+1)*s.get(m,r);for(m=0;m<=l;m++)s.set(m,r,s.get(m,r)-o*n[m])}}for(m=0;m<=l;m++)s.set(m,l+1,0)}for(r=0;r<t;r++)n[r]=s.get(t-1,r),s.set(t-1,r,0);s.set(t-1,t-1,1),e[0]=0}function tql2(t,e,n,s){let i,o,a,l,r,m,g,u,c,C,f,h,p,d,y,H;for(a=1;a<t;a++)e[a-1]=e[a];e[t-1]=0;let v=0,b=0,w=Number.EPSILON;for(m=0;m<t;m++){for(b=Math.max(b,Math.abs(n[m])+Math.abs(e[m])),g=m;g<t&&!(Math.abs(e[g])<=w*b);)g++;if(g>m)do{for(i=n[m],u=(n[m+1]-i)/(2*e[m]),c=hypotenuse(u,1),u<0&&(c=-c),n[m]=e[m]/(u+c),n[m+1]=e[m]*(u+c),C=n[m+1],o=i-n[m],a=m+2;a<t;a++)n[a]-=o;for(v+=o,u=n[g],f=1,h=f,p=f,d=e[m+1],y=0,H=0,a=g-1;a>=m;a--)for(p=h,h=f,H=y,i=f*e[a],o=f*u,c=hypotenuse(u,e[a]),e[a+1]=y*c,y=e[a]/c,f=u/c,u=f*n[a]-y*i,n[a+1]=o+y*(f*i+y*n[a]),r=0;r<t;r++)o=s.get(r,a+1),s.set(r,a+1,y*s.get(r,a)+f*o),s.set(r,a,f*s.get(r,a)-y*o);u=-y*H*p*d*e[m]/C,e[m]=y*u,n[m]=f*u}while(Math.abs(e[m])>w*b);n[m]=n[m]+v,e[m]=0}for(a=0;a<t-1;a++){for(r=a,u=n[a],l=a+1;l<t;l++)n[l]<u&&(r=l,u=n[l]);if(r!==a)for(n[r]=n[a],n[a]=u,l=0;l<t;l++)u=s.get(l,a),s.set(l,a,s.get(l,r)),s.set(l,r,u)}}function orthes(t,e,n,s){let i,o,a,l,r,m,g,u=t-1;for(m=1;m<=u-1;m++){for(g=0,l=m;l<=u;l++)g+=Math.abs(e.get(l,m-1));if(0!==g){for(a=0,l=u;l>=m;l--)n[l]=e.get(l,m-1)/g,a+=n[l]*n[l];for(o=Math.sqrt(a),n[m]>0&&(o=-o),a-=n[m]*o,n[m]=n[m]-o,r=m;r<t;r++){for(i=0,l=u;l>=m;l--)i+=n[l]*e.get(l,r);for(i/=a,l=m;l<=u;l++)e.set(l,r,e.get(l,r)-i*n[l])}for(l=0;l<=u;l++){for(i=0,r=u;r>=m;r--)i+=n[r]*e.get(l,r);for(i/=a,r=m;r<=u;r++)e.set(l,r,e.get(l,r)-i*n[r])}n[m]=g*n[m],e.set(m,m-1,g*o)}}for(l=0;l<t;l++)for(r=0;r<t;r++)s.set(l,r,l===r?1:0);for(m=u-1;m>=1;m--)if(0!==e.get(m,m-1)){for(l=m+1;l<=u;l++)n[l]=e.get(l,m-1);for(r=m;r<=u;r++){for(o=0,l=m;l<=u;l++)o+=n[l]*s.get(l,r);for(o=o/n[m]/e.get(m,m-1),l=m;l<=u;l++)s.set(l,r,s.get(l,r)+o*n[l])}}}function hqr2(t,e,n,s,i){let o,a,l,r,m,g,u,c,C,f,h,p,d,y,H,v=t-1,b=t-1,w=Number.EPSILON,x=0,O=0,D=0,A=0,S=0,M=0,j=0,$=0;for(o=0;o<t;o++)for((o<0||o>b)&&(n[o]=i.get(o,o),e[o]=0),a=Math.max(o-1,0);a<t;a++)O+=Math.abs(i.get(o,a));for(;v>=0;){for(r=v;r>0&&(M=Math.abs(i.get(r-1,r-1))+Math.abs(i.get(r,r)),0===M&&(M=O),!(Math.abs(i.get(r,r-1))<w*M));)r--;if(r===v)i.set(v,v,i.get(v,v)+x),n[v]=i.get(v,v),e[v]=0,v--,$=0;else if(r===v-1){if(u=i.get(v,v-1)*i.get(v-1,v),D=(i.get(v-1,v-1)-i.get(v,v))/2,A=D*D+u,j=Math.sqrt(Math.abs(A)),i.set(v,v,i.get(v,v)+x),i.set(v-1,v-1,i.get(v-1,v-1)+x),c=i.get(v,v),A>=0){for(j=D>=0?D+j:D-j,n[v-1]=c+j,n[v]=n[v-1],0!==j&&(n[v]=c-u/j),e[v-1]=0,e[v]=0,c=i.get(v,v-1),M=Math.abs(c)+Math.abs(j),D=c/M,A=j/M,S=Math.sqrt(D*D+A*A),D/=S,A/=S,a=v-1;a<t;a++)j=i.get(v-1,a),i.set(v-1,a,A*j+D*i.get(v,a)),i.set(v,a,A*i.get(v,a)-D*j);for(o=0;o<=v;o++)j=i.get(o,v-1),i.set(o,v-1,A*j+D*i.get(o,v)),i.set(o,v,A*i.get(o,v)-D*j);for(o=0;o<=b;o++)j=s.get(o,v-1),s.set(o,v-1,A*j+D*s.get(o,v)),s.set(o,v,A*s.get(o,v)-D*j)}else n[v-1]=c+D,n[v]=c+D,e[v-1]=j,e[v]=-j;v-=2,$=0}else{if(c=i.get(v,v),C=0,u=0,r<v&&(C=i.get(v-1,v-1),u=i.get(v,v-1)*i.get(v-1,v)),10===$){for(x+=c,o=0;o<=v;o++)i.set(o,o,i.get(o,o)-c);M=Math.abs(i.get(v,v-1))+Math.abs(i.get(v-1,v-2)),c=C=.75*M,u=-.4375*M*M}if(30===$&&(M=(C-c)/2,M=M*M+u,M>0)){for(M=Math.sqrt(M),C<c&&(M=-M),M=c-u/((C-c)/2+M),o=0;o<=v;o++)i.set(o,o,i.get(o,o)-M);x+=M,c=C=u=.964}for($+=1,m=v-2;m>=r&&(j=i.get(m,m),S=c-j,M=C-j,D=(S*M-u)/i.get(m+1,m)+i.get(m,m+1),A=i.get(m+1,m+1)-j-S-M,S=i.get(m+2,m+1),M=Math.abs(D)+Math.abs(A)+Math.abs(S),D/=M,A/=M,S/=M,m!==r)&&!(Math.abs(i.get(m,m-1))*(Math.abs(A)+Math.abs(S))<w*(Math.abs(D)*(Math.abs(i.get(m-1,m-1))+Math.abs(j)+Math.abs(i.get(m+1,m+1)))));)m--;for(o=m+2;o<=v;o++)i.set(o,o-2,0),o>m+2&&i.set(o,o-3,0);for(l=m;l<=v-1&&(y=l!==v-1,l!==m&&(D=i.get(l,l-1),A=i.get(l+1,l-1),S=y?i.get(l+2,l-1):0,c=Math.abs(D)+Math.abs(A)+Math.abs(S),0!==c&&(D/=c,A/=c,S/=c)),0!==c);l++)if(M=Math.sqrt(D*D+A*A+S*S),D<0&&(M=-M),0!==M){for(l!==m?i.set(l,l-1,-M*c):r!==m&&i.set(l,l-1,-i.get(l,l-1)),D+=M,c=D/M,C=A/M,j=S/M,A/=D,S/=D,a=l;a<t;a++)D=i.get(l,a)+A*i.get(l+1,a),y&&(D+=S*i.get(l+2,a),i.set(l+2,a,i.get(l+2,a)-D*j)),i.set(l,a,i.get(l,a)-D*c),i.set(l+1,a,i.get(l+1,a)-D*C);for(o=0;o<=Math.min(v,l+3);o++)D=c*i.get(o,l)+C*i.get(o,l+1),y&&(D+=j*i.get(o,l+2),i.set(o,l+2,i.get(o,l+2)-D*S)),i.set(o,l,i.get(o,l)-D),i.set(o,l+1,i.get(o,l+1)-D*A);for(o=0;o<=b;o++)D=c*s.get(o,l)+C*s.get(o,l+1),y&&(D+=j*s.get(o,l+2),s.set(o,l+2,s.get(o,l+2)-D*S)),s.set(o,l,s.get(o,l)-D),s.set(o,l+1,s.get(o,l+1)-D*A)}}}if(0!==O){for(v=t-1;v>=0;v--)if(D=n[v],A=e[v],0===A)for(r=v,i.set(v,v,1),o=v-1;o>=0;o--){for(u=i.get(o,o)-D,S=0,a=r;a<=v;a++)S+=i.get(o,a)*i.get(a,v);if(e[o]<0)j=u,M=S;else if(r=o,0===e[o]?i.set(o,v,0!==u?-S/u:-S/(w*O)):(c=i.get(o,o+1),C=i.get(o+1,o),A=(n[o]-D)*(n[o]-D)+e[o]*e[o],g=(c*M-j*S)/A,i.set(o,v,g),i.set(o+1,v,Math.abs(c)>Math.abs(j)?(-S-u*g)/c:(-M-C*g)/j)),g=Math.abs(i.get(o,v)),w*g*g>1)for(a=o;a<=v;a++)i.set(a,v,i.get(a,v)/g)}else if(A<0)for(r=v-1,Math.abs(i.get(v,v-1))>Math.abs(i.get(v-1,v))?(i.set(v-1,v-1,A/i.get(v,v-1)),i.set(v-1,v,-(i.get(v,v)-D)/i.get(v,v-1))):(H=cdiv(0,-i.get(v-1,v),i.get(v-1,v-1)-D,A),i.set(v-1,v-1,H[0]),i.set(v-1,v,H[1])),i.set(v,v-1,0),i.set(v,v,1),o=v-2;o>=0;o--){for(f=0,h=0,a=r;a<=v;a++)f+=i.get(o,a)*i.get(a,v-1),h+=i.get(o,a)*i.get(a,v);if(u=i.get(o,o)-D,e[o]<0)j=u,S=f,M=h;else if(r=o,0===e[o]?(H=cdiv(-f,-h,u,A),i.set(o,v-1,H[0]),i.set(o,v,H[1])):(c=i.get(o,o+1),C=i.get(o+1,o),p=(n[o]-D)*(n[o]-D)+e[o]*e[o]-A*A,d=2*(n[o]-D)*A,0===p&&0===d&&(p=w*O*(Math.abs(u)+Math.abs(A)+Math.abs(c)+Math.abs(C)+Math.abs(j))),H=cdiv(c*S-j*f+A*h,c*M-j*h-A*f,p,d),i.set(o,v-1,H[0]),i.set(o,v,H[1]),Math.abs(c)>Math.abs(j)+Math.abs(A)?(i.set(o+1,v-1,(-f-u*i.get(o,v-1)+A*i.get(o,v))/c),i.set(o+1,v,(-h-u*i.get(o,v)-A*i.get(o,v-1))/c)):(H=cdiv(-S-C*i.get(o,v-1),-M-C*i.get(o,v),j,A),i.set(o+1,v-1,H[0]),i.set(o+1,v,H[1]))),g=Math.max(Math.abs(i.get(o,v-1)),Math.abs(i.get(o,v))),w*g*g>1)for(a=o;a<=v;a++)i.set(a,v-1,i.get(a,v-1)/g),i.set(a,v,i.get(a,v)/g)}for(o=0;o<t;o++)if(o<0||o>b)for(a=o;a<t;a++)s.set(o,a,i.get(o,a));for(a=t-1;a>=0;a--)for(o=0;o<=b;o++){for(j=0,l=0;l<=Math.min(a,b);l++)j+=s.get(o,l)*i.get(l,a);s.set(o,a,j)}}}function cdiv(t,e,n,s){let i,o;return Math.abs(n)>Math.abs(s)?(i=s/n,o=n+i*s,[(t+i*e)/o,(e-i*t)/o]):(i=n/s,o=s+i*n,[(i*t+e)/o,(i*e-t)/o])}function xEnsureFloat64(t){return xCheck(t),t instanceof Float64Array?t.slice(0):Float64Array.from(t)}function xFindClosestIndex(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{sorted:s=!0}=n;if(s){let n=0,s=t.length-1,i=0;for(;s-n>1;)if(i=n+(s-n>>1),t[i]<e)n=i;else{if(!(t[i]>e))return i;s=i}return n<t.length-1?Math.abs(e-t[n])<Math.abs(t[n+1]-e)?n:n+1:n}{let n=0,s=Number.POSITIVE_INFINITY;for(let i=0;i<t.length;i++){const o=Math.abs(t[i]-e);o<s&&(s=o,n=i)}return n}}function xGetFromToIndex(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{fromIndex:n,toIndex:s,from:i,to:o}=e;return void 0===n&&(n=void 0!==i?xFindClosestIndex(t,i):0),void 0===s&&(s=void 0!==o?xFindClosestIndex(t,o):t.length-1),n<0&&(n=0),s<0&&(s=0),n>=t.length&&(n=t.length-1),s>=t.length&&(s=t.length-1),n>s&&([n,s]=[s,n]),{fromIndex:n,toIndex:s}}function xMaxValue(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xCheck(t);const{fromIndex:n,toIndex:s}=xGetFromToIndex(t,e);let i=t[n];for(let e=n+1;e<=s;e++)t[e]>i&&(i=t[e]);return i}function xMinValue(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xCheck(t);const{fromIndex:n,toIndex:s}=xGetFromToIndex(t,e);let i=t[n];for(let e=n+1;e<=s;e++)t[e]<i&&(i=t[e]);return i}function xIsEquallySpaced(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(t.length<3)return!0;const{tolerance:n=.05}=e;let s=0,i=Number.MAX_SAFE_INTEGER;for(let e=0;e<t.length-1;++e){let n=t[e+1]-t[e];n<i&&(i=n),n>s&&(s=n)}return(s-i)/s<n}function xIsMonotonic(t){if(t.length<=2)return 1;if(t[0]===t[1]){for(let e=1;e<t.length-1;e++)if(t[e]!==t[e+1])return 0;return 1}if(t[0]<t[t.length-1]){for(let e=0;e<t.length-1;e++)if(t[e]>=t[e+1])return 0;return 1}for(let e=0;e<t.length-1;e++)if(t[e]<=t[e+1])return 0;return-1}function xMean(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xCheck(t);const{fromIndex:n,toIndex:s}=xGetFromToIndex(t,e);let i=t[n];for(let e=n+1;e<=s;e++)i+=t[e];return i/(s-n+1)}function xMedianAbsoluteDeviation(t){const e=xMedian(t),n=new Float64Array(t.length);for(let s=0;s<t.length;s++)n[s]=Math.abs(t[s]-e);return{median:e,mad:xMedian(n)}}function xMinMaxValues(t){xCheck(t);let e=t[0],n=t[0];for(let s of t)s<e&&(e=s),s>n&&(n=s);return{min:e,max:n}}function xNoiseStandardDeviation(t){const{mad:e,median:n}=xMedianAbsoluteDeviation(t);return{sd:e/.6744897501960817,mad:e,median:n}}function xNorm(t){let e=0;for(const n of t)e+=n**2;return Math.sqrt(e)}function xSum(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xCheck(t);const{fromIndex:n,toIndex:s}=xGetFromToIndex(t,e);let i=t[n];for(let e=n+1;e<=s;e++)i+=t[e];return i}function xNormed(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{algorithm:n="absolute",value:s=1}=e;xCheck(t);const i=getOutputArray(e.output,t.length);if(0===t.length)throw new Error("input must not be empty");switch(n.toLowerCase()){case"absolute":{let e=absoluteSum(t)/s;if(0===e)throw new Error("xNormed: trying to divide by 0");for(let n=0;n<t.length;n++)i[n]=t[n]/e;return i}case"max":{let e=xMaxValue(t);if(0===e)throw new Error("xNormed: trying to divide by 0");const n=s/e;for(let e=0;e<t.length;e++)i[e]=t[e]*n;return i}case"sum":{let e=xSum(t)/s;if(0===e)throw new Error("xNormed: trying to divide by 0");for(let n=0;n<t.length;n++)i[n]=t[n]/e;return i}default:throw new Error(`norm: unknown algorithm: ${n}`)}}function absoluteSum(t){let e=0;for(let n=0;n<t.length;n++)e+=Math.abs(t[n]);return e}function xPadding(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{size:n=0,value:s=0,algorithm:i=""}=e;if(xCheck(t),!i)return t instanceof Float64Array?t.slice():Float64Array.from(t);let o=new Float64Array(t.length+2*n);for(let e=0;e<t.length;e++)o[e+n]=t[e];let a=n+t.length,l=2*n+t.length;switch(i.toLowerCase()){case"value":for(let t=0;t<n;t++)o[t]=s;for(let t=a;t<l;t++)o[t]=s;break;case"duplicate":for(let e=0;e<n;e++)o[e]=t[0];for(let e=a;e<l;e++)o[e]=t[t.length-1];break;case"circular":for(let e=0;e<n;e++)o[e]=t[(t.length-n%t.length+e)%t.length];for(let e=0;e<n;e++)o[e+a]=t[e%t.length];break;default:throw new Error("xPadding: unknown algorithm")}return o}function xVariance(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");const{unbiased:n=!0,mean:s=xMean(t)}=e;let i=0;for(let e=0;e<t.length;e++){let n=t[e]-s;i+=n*n}return n?i/(t.length-1):i/t.length}function xStandardDeviation(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return Math.sqrt(xVariance(t,e))}function xParetoNormalization(t){xCheck(t);let e=[];const n=Math.sqrt(xStandardDeviation(t));for(let s of t)e.push(s/n);return e}function xRescale(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xCheck(t);const n=getOutputArray(e.output,t.length),s=xMinValue(t),i=xMaxValue(t);if(s===i)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");const{min:o=0,max:a=1}=e;if(o>=a)throw new RangeError("min option must be smaller than max option");const l=(a-o)/(i-s);for(let e=0;e<t.length;e++)n[e]=(t[e]-s)*l+o;return n}function xRolling(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(xCheck(t),"function"!=typeof e)throw new Error("fct has to be a function");const{window:s=5,padding:i={}}=n,{size:o=s-1,algorithm:a,value:l}=i;t=xPadding(t,{size:o,algorithm:a,value:l});const r=[];for(let n=0;n<t.length-s+1;n++)r.push(e(t.subarray(n,n+s)));return r}function xRollingAverage(t){return xRolling(t,xMean,arguments.length>1&&void 0!==arguments[1]?arguments[1]:{})}function xRollingMedian(t){return xRolling(t,xMedian,arguments.length>1&&void 0!==arguments[1]?arguments[1]:{})}function xSequentialFill(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"!=typeof t||isAnyArray(t)||(e=t,t=[]),!isAnyArray(t))throw new TypeError("input must be an array");let{from:n=0,to:s=10,size:i=(Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array?t.length:0),step:o=null}=e;if(i||(i=o?Math.floor((s-n)/o)+1:s-n+1),!o&&i&&(o=(s-n)/(i-1)),Array.isArray(t)){t.length=0;for(let e=0;e<i;e++)t.push(n),o&&(n+=o)}else{if(Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array&&t.length!==i)throw new Error("sequentialFill typed array must have the correct length");for(let e=0;e<i;e++)(Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array)&&(t[e]=n),o&&(n+=o)}return Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array?Array.from(t):[]}function xSubtract(t,e){let n=!1,s=0;if(isAnyArray(e)){if(t.length!==e.length)throw new Error("xSubtract: size of array1 and array2 must be identical")}else n=!0,s=Number(e);let i=new Float64Array(t.length);if(n)for(let e=0;e<t.length;e++)i[e]=t[e]-s;else for(let n=0;n<t.length;n++)i[n]=t[n]-e[n];return i}function xyCheck(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{minLength:n}=e;if("object"!=typeof t||!isAnyArray(t.x)||!isAnyArray(t.y))throw new Error("Data must be an object of x and y arrays");if(t.x.length!==t.y.length)throw new Error("The x and y arrays must have the same length");if(n&&t.x.length<n)throw new Error(`data.x must have a length of at least ${n}`)}function xyFindClosestPoint(t,e){const{x:n,y:s}=t,i=xFindClosestIndex(n,e);return{x:n[i],y:s[i]}}function xyEnsureGrowingX(t){if(xyCheck(t),1===xIsMonotonic(t.x))return t;const e=Array.from(t.x),n=Array.from(t.y);let s=Number.NEGATIVE_INFINITY,i=0;for(let t=0;t<e.length;t++)s<e[t]&&(i<t&&(e[i]=e[t],n[i]=n[t]),i++,s=e[t]);return e.length=i,n.length=i,{x:e,y:n}}function zonesNormalize(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{from:n=Number.NEGATIVE_INFINITY,to:s=Number.POSITIVE_INFINITY,exclusions:i=[]}=e;n>s&&([n,s]=[s,n]),t=JSON.parse(JSON.stringify(t)).map((t=>t.from>t.to?{from:t.to,to:t.from}:t)),t=t.sort(((t,e)=>t.from!==e.from?t.from-e.from:t.to-e.to)),0===t.length&&t.push({from:n,to:s});for(const e of t)n>e.from&&(e.from=n),s<e.to&&(e.to=s);if(t=t.filter((t=>t.from<=t.to)),0===t.length)return[];let o=t[0],a=[o];for(let e=1;e<t.length;e++){let n=t[e];n.from<=o.to?o.to<n.to&&(o.to=n.to):(o=n,a.push(o))}if(0===i.length)return a;const l=zonesNormalize(i);let r=0;const m=[];let g=0;for(let t=0;t<a.length&&!(g++>5);t++){const e=a[t];if(r!==l.length){for(;r<l.length&&l[r].to<=e.from;)r++;if(r!==l.length)if(e.to<l[r].from)m.push(e);else{if(l[r].to>=e.to){if(l[r].from<=e.from)continue;m.push({from:l[r].to,to:e.to})}l[r].from>e.from&&m.push({from:e.from,to:l[r].from}),e.from=l[r].to,t--}else m.push(e)}else m.push(e)}return m}function zonesWithPoints(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:10,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(0===t.length)return t;let s=zonesNormalize(t,n);let i=s.reduce(((t,e)=>t+(e.to-e.from)),0)/e,o=0;for(let t=0;t<s.length-1;t++){let n=s[t];n.numberOfPoints=Math.min(Math.round((n.to-n.from)/i),e-o),o+=n.numberOfPoints}return s[s.length-1].numberOfPoints=e-o,s}function equallySpacedSlot(t,e,n,s,i){let o=t.length,a=(s-n)/(i>1?i-1:1),l=a/2,r=t[t.length-1]-t[t.length-2],m=n-l,g=new Float64Array(i),u=m,c=m+a,C=-Number.MAX_VALUE,f=0,h=t[0],p=e[0],d=0,y=!0,H=0,v=0,b=1,w=0;t:for(;;){if(C>=h)throw new Error("x must be a growing series");for(;C-c>0;){if(y&&(v++,y=!1),g[w]=v<=0?0:H/v,w++,w===i)break t;u=c,c+=a,H=0,v=0}C>u&&(H+=f,v++),(C===-Number.MAX_VALUE||d>1)&&v--,C=h,f=p,b<o?(h=t[b],p=e[b],b++):(h+=r,p=0,d++)}return g}function integral(t,e,n,s){return.5*n*e*e+s*e-(.5*n*t*t+s*t)}function equallySpacedSmooth(t,e,n,s,i){let o=t.length,a=(s-n)/(i>1?i-1:1),l=a/2,r=new Float64Array(i),m=t[1]-t[0],g=t[o-1]-t[o-2],u=n-l,c=n+l,C=Number.MIN_SAFE_INTEGER,f=0,h=t[0]-m,p=0,d=0,y=0,H=0,v=0,b=0,w=0,x=0,O=0;t:for(;;){if(C>=h)throw new Error("x must be a growing series");for(C<=u&&u<=h&&(O=integral(0,u-C,y,f),v=d+O);h-c>=0;){if(O=integral(0,c-C,y,f),b=d+O,r[x++]=(b-v)/a,x===i)break t;u=c,c+=a,v=b}d+=integral(C,h,y,H),C=h,f=p,w<o?(h=t[w],p=e[w],w++):w===o&&(h+=g,p=0),y=getSlope(C,f,h,p),H=-y*C+f}return r}function getSlope(t,e,n,s){return(s-e)/(n-t)}function xyEquallySpaced(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{x:n,y:s}=t,i=n.length;const{from:o=n[0],to:a=n[i-1],variant:l="smooth",numberOfPoints:r=100,exclusions:m=[],zones:g=[{from:o,to:a}]}=e;if(o>a)throw new RangeError("from should be larger than to");if(xyCheck(t),r<2)throw new RangeError("'numberOfPoints' option must be greater than 1");const u=zonesWithPoints(zonesNormalize(g,{from:o,to:a,exclusions:m}),r,{from:o,to:a});let c=[],C=[];for(let t of u){t.numberOfPoints||(t.numberOfPoints=0);let e=processZone(Array.from(n),Array.from(s),t.from,t.to,t.numberOfPoints,l);c=c.concat(e.x),C=C.concat(e.y)}return{x:c,y:C}}function processZone(t,e,n,s,i,o){if(i<1)throw new RangeError("the number of points must be at least 1");let a="slot"===o?Array.from(equallySpacedSlot(t,e,n,s,i)):Array.from(equallySpacedSmooth(t,e,n,s,i));return{x:Array.from(createFromToArray({from:n,to:s,length:i})),y:a}}function xyExtract(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xyCheck(t);const{x:n,y:s}=t;let{zones:i}=e;if(i=zonesNormalize(i),void 0===n||void 0===s||!Array.isArray(i)||0===i.length)return t;let o=[],a=[],l=i[0],r=0;t:for(let t=0;t<n.length;t++){for(;l.to<n[t];)if(r++,l=i[r],!l){t=n.length;break t}n[t]>=l.from&&(o.push(n[t]),a.push(s[t]))}return{x:o,y:a}}function xyFilterX(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{x:n,y:s}=t,{from:i=n[0],to:o=n[n.length-1],zones:a=[{from:i,to:o}],exclusions:l=[]}=e;let r=zonesNormalize(a,{from:i,to:o,exclusions:l}),m=0,g=[],u=[],c=0;for(;c<n.length;){if(n[c]<=r[m].to&&n[c]>=r[m].from)g.push(n[c]),u.push(s[c]);else if(n[c]>r[m].to&&(m++,!r[m]))break;c++}return{x:g,y:u}}function xyIntegration(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xyCheck(t,{minLength:1});const{x:n,y:s}=t;if(1===n.length)return 0;const{fromIndex:i,toIndex:o}=xGetFromToIndex(n,e);let a=0;for(let t=i;t<o;t++)a+=(n[t+1]-n[t])*(s[t+1]+s[t])/2;return a}function xySetYValue(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xyCheck(t);const{x:n,y:s}=t;let{zones:i,value:o=0}=e;if(!Array.isArray(i)||0===i.length)return t;i=zonesNormalize(i);const a=n.slice(),l=s.slice();let r=i[0],m=0;t:for(let t=0;t<n.length;t++){for(;r.to<n[t];)if(m++,r=i[m],!r){t=n.length;break t}n[t]>=r.from&&(l[t]=o)}return{x:a,y:l}}function matrixCheck(t){if(0===t.length||0===t[0].length)throw new RangeError("matrix should contain data");const e=t[0].length;for(let n=1;n<t.length;n++)if(t[n].length!==e)throw new RangeError("All rows should has the same length")}function matrixMinMaxZ(t){matrixCheck(t);const e=t.length,n=t[0].length;let s=t[0][0],i=t[0][0];for(let o=0;o<n;o++)for(let n=0;n<e;n++)t[n][o]<s&&(s=t[n][o]),t[n][o]>i&&(i=t[n][o]);return{min:s,max:i}}const LOOP=8,FLOAT_MUL=1/16777216,sh1=15,sh2=18,sh3=11;function multiply_uint32(t,e){const n=65535&(t>>>=0);return((t-n)*(e>>>=0)>>>0)+n*e>>>0}class XSadd{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:Date.now();this.state=new Uint32Array(4),this.init(t),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*FLOAT_MUL}init(t){if(!Number.isInteger(t))throw new TypeError("seed must be an integer");this.state[0]=t,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let t=1;t<LOOP;t++)this.state[3&t]^=t+multiply_uint32(1812433253,this.state[t-1&3]^this.state[t-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let t=0;t<LOOP;t++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let t=this.state[0];t^=t<<sh1,t^=t>>>sh2,t^=this.state[3]<<sh3,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=t}}let spare,hasSpare=!1;function createRandomArray(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const{mean:e=0,standardDeviation:n=1,length:s=1e3,range:i=1,seed:o,distribution:a="normal"}=t,l=new XSadd(o);let r=new Float64Array(s);switch(a){case"normal":for(let t=0;t<s;t++)r[t]=generateGaussian(e,n,l);break;case"uniform":for(let t=0;t<s;t++)r[t]=(l.random()-.5)*i+e;break;default:throw new Error(`unknown distribution: ${a}`)}return r}function generateGaussian(t,e,n){let s,i,o,a;if(hasSpare)hasSpare=!1,s=spare*e+t;else{do{i=2*n.random()-1,o=2*n.random()-1,a=i*i+o*o}while(a>=1||0===a);a=Math.sqrt(-2*Math.log(a)/a),spare=o*a,hasSpare=!0,s=t+e*i*a}return s}function addNoise(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{seed:n=0,distribution:s="normal",percent:i=1}=e,o=xMaxValue(t.y)*i/100,a=createRandomArray({distribution:s,seed:n,mean:0,standardDeviation:o,range:o,length:t.x.length});return t.y=xAdd(t.y,a),t}class SpectrumGenerator{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const{from:e=0,to:n=1e3,nbPoints:s=10001,peakWidthFct:i,shape:o={kind:"gaussian",fwhm:5}}=t;this.from=e,this.to=n,this.nbPoints=s,this.interval=(this.to-this.from)/(this.nbPoints-1),this.peakWidthFct=i,this.maxPeakHeight=Number.MIN_SAFE_INTEGER,this.data={x:new Float64Array(this.nbPoints),y:new Float64Array(this.nbPoints)};let a=getShape1D(o);if(this.shape=a,assertNumber$2(this.from,"from"),assertNumber$2(this.to,"to"),assertInteger$1(this.nbPoints,"nbPoints"),this.to<=this.from)throw new RangeError("to option must be larger than from");if(this.peakWidthFct&&"function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(t,e){if(!(Array.isArray(t)||"object"==typeof t&&void 0!==t.x&&void 0!==t.y&&Array.isArray(t.x)&&Array.isArray(t.y)&&t.x.length===t.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(t))for(const n of t)this.addPeak(n,e);else for(let n=0;n<t.x.length;n++)this.addPeak([t.x[n],t.y[n]],e)}addPeak(t){let e,n,s,i,o,a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(Array.isArray(t)&&t.length<2)throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");if(!Array.isArray(t)&&(void 0===t.x||void 0===t.y))throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");Array.isArray(t)?[e,n,s,o]=t:(e=t.x,n=t.y,i=t.width,o=t.shape),n>this.maxPeakHeight&&(this.maxPeakHeight=n);let{shape:l}=a;o&&(l=l?{...l,...o}:o);const r=l?getShape1D(l):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),this.shape);let{width:m,widthLeft:g,widthRight:u}=a;const c=void 0!==s?s:i?r.widthToFWHM(i):this.peakWidthFct?this.peakWidthFct(e):void 0!==m?m:r.fwhm;if(g||(g=c),u||(u=c),!g||!u)throw new Error("Width left or right is undefined or zero");let C=void 0===a.factor?r.getFactor():a.factor;const f=e-g/2*C,h=e+u/2*C,p=Math.max(0,Math.floor((f-this.from)/this.interval)),d=Math.min(this.nbPoints-1,Math.ceil((h-this.from)/this.interval)),y=Math.round((e-this.from)/this.interval);r.fwhm=g;for(let t=p;t<Math.max(y,0);t++)this.data.y[t]+=n*r.fct(this.data.x[t]-e);r.fwhm=u;for(let t=Math.min(y,d);t<=d;t++)this.data.y[t]+=n*r.fct(this.data.x[t]-e)}addBaseline(t){return addBaseline(this.data,t),this}addNoise(t){return addNoise(this.data,t),this}getSpectrum(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};"boolean"==typeof t&&(t={copy:t});const{copy:e=!0,threshold:n=0}=t;if(n){let t=this.maxPeakHeight*n,e=[],s=[];for(let n=0;n<this.data.x.length;n++)this.data.y[n]>=t&&(e.push(this.data.x[n]),s.push(this.data.y[n]));return{x:e,y:s}}return e?{x:this.data.x.slice(),y:this.data.y.slice()}:this.data}reset(){const t=this.data;for(let e=0;e<this.nbPoints;e++)t.x[e]=this.from+e*this.interval;return this}}function assertInteger$1(t,e){if(!Number.isInteger(t))throw new TypeError(`${e} option must be an integer`)}function assertNumber$2(t,e){if(!Number.isFinite(t))throw new TypeError(`${e} option must be a number`)}function generateSpectrum(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{generator:n,noise:s,baseline:i,threshold:o,peakOptions:a}=e,l=new SpectrumGenerator(n);return l.addPeaks(t,a),i&&l.addBaseline(i),s&&l.addNoise(s),l.getSpectrum({threshold:o})}const axis2D=["x","y"],peakCoordinates=["x","y","z"],convertWidthToFWHM=(t,e)=>{const n=ensureXYNumber$1(e);for(let e of axis2D)n[e]=t.widthToFWHM(n[e]);return n};class Spectrum2DGenerator{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{from:e=0,to:n=100,nbPoints:s=1001,peakWidthFct:i=(()=>5),shape:o={kind:"gaussian"}}=t;e=ensureXYNumber$1(e),n=ensureXYNumber$1(n),s=ensureXYNumber$1(s);for(const t of axis2D)assertNumber$1(e[t],`from-${t}`),assertNumber$1(n[t],`to-${t}`),assertInteger(s[t],`nbPoints-${t}`);this.from=e,this.to=n,this.nbPoints=s,this.interval=calculeIntervals(e,n,s),this.peakWidthFct=i,this.maxPeakHeight=Number.MIN_SAFE_INTEGER;let a=getShape2D(o);this.shape=a,this.data={x:new Float64Array(s.x),y:new Float64Array(s.y),z:createMatrix(this.nbPoints)};for(const t of axis2D)if(this.to[t]<=this.from[t])throw new RangeError("to option must be larger than from");if("function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(t,e){if(!(Array.isArray(t)||"object"==typeof t&&void 0!==t.x&&void 0!==t.y&&Array.isArray(t.x)&&Array.isArray(t.y)&&t.x.length===t.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(t))for(const n of t)this.addPeak(n,e);else{let n=t.x.length;for(const e of peakCoordinates)if(t[e]&&Array.isArray(t[e])&&n!==t[e].length)throw new Error("x, y, z should have the same length");for(let n=0;n<t.x.length;n++)this.addPeak([t.x[n],t.y[n],t.z[n]],e)}return this}addPeak(t){let e,n,s,i,o,a,l=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(Array.isArray(t)&&t.length<3)throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");if(!Array.isArray(t)&&peakCoordinates.some((e=>void 0===t[e])))throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");Array.isArray(t)?[e,n,s,i,a]=t:(e=t.x,n=t.y,s=t.z,i=t.fwhm,o=t.width,a=t.shape);const r={x:e,y:n};s>this.maxPeakHeight&&(this.maxPeakHeight=s);let{shape:m,width:g}=l;a&&(m=m?{...m,...a}:a);const u=m?getShape2D(m):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),JSON.parse(JSON.stringify(this.shape)));let{fwhm:c=(void 0!==i?i:o?convertWidthToFWHM(u,o):g?convertWidthToFWHM(u,g):this.peakWidthFct(e,n))}=l;c=ensureXYNumber$1(c);let C=void 0===l.factor?u.getFactor():l.factor;C=ensureXYNumber$1(C);const f={x:0,y:0},h={x:0,y:0};for(const t of axis2D){const e=r[t]-c[t]/2*C[t],n=r[t]+c[t]/2*C[t];f[t]=Math.max(0,Math.floor((e-this.from[t])/this.interval[t])),h[t]=Math.min(this.nbPoints[t],Math.ceil((n-this.from[t])/this.interval[t]))}u.fwhm=c;for(let t=f.x;t<h.x;t++)for(let e=f.y;e<h.y;e++){const n=s*u.fct(this.data.x[t]-r.x,this.data.y[e]-r.y);n>1e-6&&(this.data.z[e][t]+=n)}return this}getSpectrum(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};"boolean"==typeof t&&(t={copy:t});const{copy:e=!0}=t;let n=matrixMinMaxZ(this.data.z);return{minX:this.from.x,maxX:this.to.x,maxY:this.to.y,minY:this.from.y,minZ:n.min,maxZ:n.max,z:e?this.data.z.slice():this.data.z}}reset(){const t=this.data;for(const e of axis2D)for(let n=0;n<this.nbPoints[e];n++)t[e][n]=this.from[e]+n*this.interval[e];for(let e of t.z)for(let t=0;t<e.length;t++)e[t]=0;return this}}function generateSpectrum2D(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{generator:n,peaks:s}=e,i=new Spectrum2DGenerator(n);return i.addPeaks(t,s),i.getSpectrum()}function ensureXYNumber$1(t){return"object"!=typeof t?{x:t,y:t}:{...t}}function calculeIntervals(t,e,n){return{x:(e.x-t.x)/(n.x-1),y:(e.y-t.y)/(n.y-1)}}function assertInteger(t,e){if(!Number.isInteger(t))throw new TypeError(`${e} option must be an integer`)}function assertNumber$1(t,e){if(!Number.isFinite(t))throw new TypeError(`${e} option must be a number`)}function createMatrix(t){const e=new Array(t.y);for(let n=0;n<t.y;n++)e[n]=new Float64Array(t.x);return e}function hasProperty(t,e){return e in t}const{parse:parse$7,stringify:stringify$7}=JSON;function convertWidth(t,e){const{frequency:n,convertTo:s,output:i=parse$7(stringify$7(t))}=e,o=getConverter(s,n);for(const t of i)if(t.width=o(t.width),hasProperty(t,"shape")){const e=t.shape;e.fwhm&&(e.fwhm=o(e.fwhm))}return i}function getConverter(t,e){switch(t){case"ppm":return t=>t/e;case"hz":return t=>t*e;default:throw new Error(`Does not support convert to ${t}`)}}function convertWidthToPPM(t,e){return convertWidth(t,{...e,convertTo:"ppm"})}function peaksToXY(t,e){const{frequency:n,nbPoints:s=1024,shape:i}=e;if(!n)throw new Error("frequency is mandatory");const o=convertWidthToPPM(t,{frequency:n});return generateSpectrum(o,{generator:{...getFromTo$1(o,e),nbPoints:s,shape:i}})}function getFromTo$1(t,e){if("to"in e&&"from"in e)return{from:e.from,to:e.to};t.sort(((t,e)=>t.x-e.x));const n=t[0],s=t[t.length-1],{from:i=n.x-2*n.width/e.frequency,to:o=s.x+2*s.width/e.frequency}=e;return{from:i,to:o}}for(var IDX=256,HEX=[],BUFFER;IDX--;)HEX[IDX]=(IDX+256).toString(16).substring(1);function v4(){var t,e=0,n="";if(!BUFFER||IDX+16>256){for(BUFFER=Array(e=256);e--;)BUFFER[e]=256*Math.random()|0;e=IDX=0}for(;e<16;e++)t=BUFFER[IDX+e],n+=6==e?HEX[15&t|64]:8==e?HEX[63&t|128]:HEX[t],1&e&&e>1&&e<11&&(n+="-");return IDX++,n}function sgg(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{windowSize:s=9,derivative:i=0,polynomial:o=3}=n;if(s%2==0||s<5||!Number.isInteger(s))throw new RangeError("Invalid window size (should be odd and at least 5 integer number)");if(!isAnyArray(t))throw new TypeError("Y values must be an array");if(void 0===e)throw new TypeError("X must be defined");if(s>t.length)throw new RangeError(`Window size is higher than the data length ${s}>${t.length}`);if(i<0||!Number.isInteger(i))throw new RangeError("Derivative should be a positive integer");if(o<1||!Number.isInteger(o))throw new RangeError("Polynomial should be a positive integer");o>=6&&console.warn("You should not use polynomial grade higher than 5 if you are not sure that your data arises from such a model. Possible polynomial oscillation problems");let a=Math.floor(s/2),l=t.length,r=new Float64Array(l),m=fullWeights(s,o,i),g=0,u=!0;isAnyArray(e)?u=!1:g=Math.pow(e,i);for(let n=0;n<a;n++){let o=m[a-n-1],c=m[a+n+1],C=0,f=0;for(let e=0;e<s;e++)C+=o[e]*t[e],f+=c[e]*t[l-s+e];u?(r[a-n-1]=C/g,r[l-a+n]=f/g):(g=getHs(e,a-n-1,a,i),r[a-n-1]=C/g,g=getHs(e,l-a+n,a,i),r[l-a+n]=f/g)}let c=m[a];for(let n=s;n<=l;n++){let o=0;for(let e=0;e<s;e++)o+=c[e]*t[e+n-s];u||(g=getHs(e,n-a-1,a,i)),r[n-a-1]=o/g}return r}function getHs(t,e,n,s){let i=0,o=0;for(let s=e-n;s<e+n;s++)s>=0&&s<t.length-1&&(i+=t[s+1]-t[s],o++);return Math.pow(i/o,s)}function gramPoly(t,e,n,s){let i=0;return i=n>0?(4*n-2)/(n*(2*e-n+1))*(t*gramPoly(t,e,n-1,s)+s*gramPoly(t,e,n-1,s-1))-(n-1)*(2*e+n)/(n*(2*e-n+1))*gramPoly(t,e,n-2,s):0===n&&0===s?1:0,i}function genFact(t,e){let n=1;if(t>=e)for(let s=t-e+1;s<=t;s++)n*=s;return n}function weight(t,e,n,s,i){let o=0;for(let a=0;a<=s;a++)o+=(2*a+1)*(genFact(2*n,a)/genFact(2*n+a+1,a+1))*gramPoly(t,n,a,0)*gramPoly(e,n,a,i);return o}function fullWeights(t,e,n){let s=new Array(t),i=Math.floor(t/2);for(let o=-i;o<=i;o++){s[o+i]=new Float64Array(t);for(let t=-i;t<=i;t++)s[o+i][t+i]=weight(t,o,i,e,n)}return s}function optimizeTop(t,e){const{x:n,y:s}=t;for(const t of e){let e=t.index;if(s[e-1]>=s[e-2]&&s[e-1]>=s[e]?e--:s[e+1]>=s[e]&&s[e+1]>=s[e+2]?e++:s[e-2]>=s[e-3]&&s[e-2]>=s[e-1]?e-=2:s[e+2]>=s[e+1]&&s[e+2]>=s[e+3]&&(e+=2),s[e-1]>0&&s[e+1]>0&&s[e]>=s[e-1]&&s[e]>=s[e+1]&&(s[e]!==s[e-1]||s[e]!==s[e+1])){let i=20*Math.log10(s[e-1]),o=20*Math.log10(s[e]),a=20*Math.log10(s[e+1]),l=.5*(i-a)/(i-2*o+a);t.x=n[e]+(n[e]-n[e-1])*l,t.y=s[e]-.25*(s[e-1]-s[e+1])*l}}}function gsd(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{sgOptions:n={windowSize:9,polynomial:3},noiseLevel:s,smoothY:i=!1,maxCriteria:o=!0,minMaxRatio:a=25e-5,realTopDetection:l=!1}=e,{x:r,y:m}=t;if(1!==xIsMonotonic(r))throw new Error("GSD only accepts monotone increasing x values");m=m.slice();let g=xIsEquallySpaced(r);if(void 0===s)if(g){const t=xNoiseStandardDeviation(m);s=o?t.median+1.5*t.sd:-t.median+1.5*t.sd}else s=0;else o||(s*=-1);if(!o)for(let t=0;t<m.length;t++)m[t]*=-1;if(void 0!==s)for(let t=0;t<m.length;t++)m[t]<s&&(m[t]=s);let u,c,C=m;const{windowSize:f,polynomial:h}=n;g?(i&&(C=sgg(m,r[1]-r[0],{windowSize:f,polynomial:h,derivative:0})),u=sgg(m,r[1]-r[0],{windowSize:f,polynomial:h,derivative:1}),c=sgg(m,r[1]-r[0],{windowSize:f,polynomial:h,derivative:2})):(i&&(C=sgg(m,r,{windowSize:f,polynomial:h,derivative:0})),u=sgg(m,r,{windowSize:f,polynomial:h,derivative:1}),c=sgg(m,r,{windowSize:f,polynomial:h,derivative:2}));const p=xMinValue(C),d=xMaxValue(C);if(p>d||p===d)return[];const y=p+(d-p)*a,H=r[1]-r[0];let v=null,b=null,w=[],x=[],O=[];for(let t=1;t<C.length-1;++t)(u[t]<u[t-1]&&u[t]<=u[t+1]||u[t]<=u[t-1]&&u[t]<u[t+1])&&(b={x:r[t],index:t},H>0&&null!==v&&(x.push(v),O.push(b))),(u[t]>=u[t-1]&&u[t]>u[t+1]||u[t]>u[t-1]&&u[t]>=u[t+1])&&(v={x:r[t],index:t},H<0&&null!==b&&(x.push(v),O.push(b))),c[t]<c[t-1]&&c[t]<c[t+1]&&w.push(t);let D=-1;const A=[];for(const t of w){let e=r[t],n=-1,s=D+1,i=Number.POSITIVE_INFINITY,o=0;for(;-1===n&&s<x.length&&(o=Math.abs(e-(x[s].x+O[s].x)/2),o<(O[s].x-x[s].x)/2&&(n=s,D=s),++s,!(o>=i));)i=o;if(-1!==n&&C[t]>y){let s=Math.abs(O[n].x-x[n].x);A.push({id:v4(),x:e,y:C[t],width:s,index:t,ddY:c[t],inflectionPoints:{from:x[n],to:O[n]}})}}return l&&optimizeTop({x:r,y:C},A),A.forEach((t=>{o||(t.y*=-1,t.ddY=-1*t.ddY)})),A.sort(((t,e)=>t.x-e.x)),A}function getSumOfShapes$1(t){return function(e){return n=>{let s=0;for(const i of t){const t=e[i.fromIndex],o=e[i.fromIndex+1];for(let t=2;t<e.length;t++)i.shapeFct[i.parameters[t]]=e[i.fromIndex+t];s+=o*i.shapeFct.fct(n-t)}return s}}}function assert(t,e){if(!t)throw new Error(e||"unreachable")}const DefaultParameters={x:{init:t=>t.x,min:(t,e)=>t.x-2*e.fwhm,max:(t,e)=>t.x+2*e.fwhm,gradientDifference:(t,e)=>.002*e.fwhm},y:{init:t=>t.y,min:t=>t.y<0?-1.1:0,max:t=>t.y<0?0:1.1,gradientDifference:()=>.001},fwhm:{init:(t,e)=>e.fwhm,min:(t,e)=>.25*e.fwhm,max:(t,e)=>4*e.fwhm,gradientDifference:(t,e)=>.002*e.fwhm},mu:{init:(t,e)=>e.mu,min:()=>0,max:()=>1,gradientDifference:()=>.01}},properties$1=["init","min","max","gradientDifference"];function getInternalPeaks(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},s=0,i=[];const{baseline:o=e.min}=n,a=t.map((t=>({...t,y:(t.y-o)/e.range})));for(const t of a){const{id:o,shape:a=(n.shape?n.shape:{kind:"gaussian"})}=t,l=getShape1D(a),r=["x","y",...l.getParameters()],m={min:[],max:[],init:[],gradientDifference:[]};for(let s of r)for(let i of properties$1){let o=t?.parameters?.[s]?.[i];if(o){o=getNormalizedValue$1(o,s,i,e,n.baseline),m[i].push(o);continue}let a=n?.parameters?.[s]?.[i];if(a){if("number"==typeof a){a=getNormalizedValue$1(a,s,i,e,n.baseline),m[i].push(a);continue}{let o=a(t);o=getNormalizedValue$1(o,s,i,e,n.baseline),m[i].push(o);continue}}assert(DefaultParameters[s],`No default parameter for ${s}`);const r=DefaultParameters[s][i];m[i].push(r(t,l))}const g=s,u=g+r.length-1;s+=u-g+1,i.push({id:o,shape:a,shapeFct:l,parameters:r,propertiesValues:m,fromIndex:g,toIndex:u})}return i}function getNormalizedValue$1(t,e,n,s,i){return"y"===e?"gradientDifference"===n?t:void 0!==i?(t-i)/s.range:(t-s.min)/s.range:t}function checkOptions(t,e,n){let{timeout:s,minValues:i,maxValues:o,initialValues:a,weights:l=1,damping:r=.01,dampingStepUp:m=11,dampingStepDown:g=9,maxIterations:u=100,errorTolerance:c=1e-7,centralDifference:C=!1,gradientDifference:f=.1,improvementThreshold:h=.001}=n;if(r<=0)throw new Error("The damping option must be a positive number");if(!t.x||!t.y)throw new Error("The data parameter must have x and y elements");if(!isAnyArray(t.x)||t.x.length<2||!isAnyArray(t.y)||t.y.length<2)throw new Error("The data parameter elements must be an array with more than 2 points");if(t.x.length!==t.y.length)throw new Error("The data parameter elements must have the same size");if(!(a&&a.length>0))throw new Error("The initialValues option is mandatory and must be an array");let p,d,y=a,H=t.y.length,v=y.length;if(o=o||new Array(v).fill(Number.MAX_SAFE_INTEGER),i=i||new Array(v).fill(Number.MIN_SAFE_INTEGER),o.length!==i.length)throw new Error("minValues and maxValues must be the same size");if("number"==typeof f)f=new Array(y.length).fill(f);else{if(!isAnyArray(f))throw new Error("gradientDifference should be a number or array with length equal to the number of parameters");f.length!==v&&(f=new Array(v).fill(f[0]))}if("number"==typeof l){let t=1/l**2;p=()=>t}else{if(!isAnyArray(l))throw new Error("weights should be a number or array with length equal to the number of data points");if(l.length<t.x.length){let t=1/l[0]**2;p=()=>t}else p=t=>1/l[t]**2}if(void 0!==s){if("number"!=typeof s)throw new Error("timeout should be a number");let t=Date.now()+1e3*s;d=()=>Date.now()>t}else d=()=>!1;let b=new Array(t.x.length);for(let t=0;t<H;t++)b[t]=p(t);return{checkTimeout:d,minValues:i,maxValues:o,parameters:y,weightSquare:b,damping:r,dampingStepUp:m,dampingStepDown:g,maxIterations:u,errorTolerance:c,centralDifference:C,gradientDifference:f,improvementThreshold:h}}function errorCalculation(t,e,n,s){let i=0;const o=n(e);for(let e=0;e<t.x.length;e++)i+=Math.pow(t.y[e]-o(t.x[e]),2)/s[e];return i}function gradientFunction(t,e,n,s,i,o){const a=n.length,l=t.x.length;let r=Matrix.zeros(a,l),m=0;for(let g=0;g<a;g++){if(0===s[g])continue;let a=s[g],u=n.slice();u[g]+=a;let c=i(u);if(o){u=n.slice(),u[g]-=a,a*=2;let e=i(u);for(let n=0;n<l;n++)r.set(m,n,(e(t.x[n])-c(t.x[n]))/a)}else for(let n=0;n<l;n++)r.set(m,n,(e[n]-c(t.x[n]))/a);m++}return r}function matrixFunction(t,e){const n=t.x.length;let s=new Matrix(n,1);for(let i=0;i<n;i++)s.set(i,0,t.y[i]-e[i]);return s}function step(t,e,n,s,i,o,a){let l=n,r=Matrix.eye(e.length,e.length,l);const m=i(e);let g=new Float64Array(t.x.length);for(let e=0;e<t.x.length;e++)g[e]=m(t.x[e]);let u=gradientFunction(t,g,e,s,i,o),c=matrixFunction(t,g),C=inverse(r.add(u.mmul(u.transpose().scale("row",{scale:a})))),f=u.mmul(c.scale("row",{scale:a}));return{perturbations:C.mmul(f),jacobianWeightResidualError:f}}function levenbergMarquardt(t,e,n){let{checkTimeout:s,minValues:i,maxValues:o,parameters:a,weightSquare:l,damping:r,dampingStepUp:m,dampingStepDown:g,maxIterations:u,errorTolerance:c,centralDifference:C,gradientDifference:f,improvementThreshold:h}=checkOptions(t,e,n),p=errorCalculation(t,a,e,l),d=p,y=a.slice(),H=p<=c,v=0;for(;v<u&&!H;v++){let u=p,{perturbations:v,jacobianWeightResidualError:b}=step(t,a,r,f,e,C,l);for(let t=0;t<a.length;t++)a[t]=Math.min(Math.max(i[t],a[t]-v.get(t,0)),o[t]);if(p=errorCalculation(t,a,e,l),isNaN(p))break;if(p<d-c&&(d=p,y=a.slice()),r=(u-p)/v.transpose().mmul(v.mul(r).add(b)).get(0,0)>h?Math.max(r/g,1e-7):Math.min(r*m,1e7),s())throw new Error(`The execution time is over to ${n.timeout} seconds`);H=p<=c}return{parameterValues:y,parameterError:d,iterations:v}}function antiLowerConvexHull(t,e){if(t.length!==e.length)throw new RangeError("X and Y vectors has different dimensions");const n=t.length-1;if(0===n)return[0];if(1===n)return[0,1];let s=0,i=new Array(t.length).fill(!0);for(;;){const o=s,a=moveOn(s,n,i),l=moveOn(moveOn(s,n,i),n,i);if(t[l]*(e[o]-e[a])+t[o]*(e[a]-e[l])+t[a]*(e[l]-e[o])>=0?s=a:(i[a]=!1,s=moveBack(s,n,i)),l===n)break}return i.map(((t,e)=>!1!==t&&e)).filter((t=>!1!==t))}function moveBack(t,e,n){let s=t-1;for(;!1===n[s];)s--;return 0===t?e:s}function moveOn(t,e,n){let s=t+1;for(;!1===n[s];)s++;return t===e?0:s}function direct(t,e,n){let s=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const{iterations:i=50,epsilon:o=1e-4,tolerance:a=1e-16,tolerance2:l=1e-12,initialState:r={}}=s;if(void 0===t||void 0===e||void 0===n)throw new RangeError("There is something undefined");if(e=new Float64Array(e),n=new Float64Array(n),e.length!==n.length)throw new Error("Lower bounds and Upper bounds for x are not of the same length");let m=e.length,g=n.map(((t,n)=>t-e[n])),{numberOfRectangles:u=0,totalIterations:c=0,unitaryCoordinates:C=[new Float64Array(m).fill(.5)],middlePoint:f=new Float64Array(m).map(((t,n)=>e[n]+C[0][n]*g[n])),bestCurrentValue:h=t(f),fCalls:p=1,smallerDistance:d=0,edgeSizes:y=[new Float64Array(m).fill(.5)],diagonalDistances:H=[Math.sqrt(m*Math.pow(.5,2))],functionValues:v=[h],differentDistances:b=H,smallerValuesByDistance:w=[h],choiceLimit:x}=r;if(r.originalCoordinates&&r.originalCoordinates.length>0){h=xMinValue(v),x=o*Math.abs(h)>1e-8?o*Math.abs(h):1e-8,d=getMinIndex(v,H,x,h),C=r.originalCoordinates.slice();for(let t=0;t<C.length;t++)for(let n=0;n<e.length;n++)C[t][n]=(C[t][n]-e[n])/g[n]}let O=0;for(;O<i;){let n,s,i=[],r=b.findIndex((t=>t===H[d])),m=0;for(let t=r;t<b.length;t++)for(let e=0;e<v.length;e++)v[e]===w[t]&H[e]===b[t]&&(i[m++]=e);if(b.length-r>1){let t=H[d],e=v[d],n=b[b.length-1],o=(w[b.length-1]-e)/(n-t),a=e-o*t,r=new Uint32Array(m);m=0;for(let t=0;t<r.length;t++){let e=i[t];v[e]<=o*H[e]+a+l&&(r[m++]=e)}let g=[],u=[];for(let t=0;t<m;t++)g.push(H[r[t]]),u.push(v[r[t]]);let c=antiLowerConvexHull(g,u);s=[];for(let t=0;t<c.length;t++)s.push(r[c[t]])}else s=i.slice(0,m);n=s;for(let s=0;s<n.length;s++){let i=n[s],o=xMaxValue(y[i]),l=new Uint32Array(y[i].length);m=0;for(let t=0;t<y[i].length;t++)Math.abs(y[i][t]-o)<a&&(l[m++]=t);let r=2*o/3,c=[];for(let n=0;n<m;n++){let s=l[n],o=C[i].slice(),a=C[i].slice();o[s]+=r,a[s]-=r;let m=new Float64Array(o.length),u=new Float64Array(a.length);for(let t=0;t<o.length;t++)m[t]=e[t]+o[t]*g[t],u[t]=e[t]+a[t]*g[t];let f=t(m),h=t(u);p+=2,c.push({minValue:Math.min(f,h),index:n}),C.push(o,a),v.push(f,h)}let f=c.sort(((t,e)=>t.minValue-e.minValue));for(let t=0;t<m;t++){let e=l[f[t].index],n=u+2*(f[t].index+1)-1,s=u+2*(f[t].index+1);y[i][e]=r/2,y[n]=y[i].slice(),y[s]=y[i].slice(),H[i]=xNorm(y[i]),H[n]=H[i],H[s]=H[i]}u+=2*m}h=xMinValue(v),x=o*Math.abs(h)>1e-8?o*Math.abs(h):1e-8,d=getMinIndex(v,H,x,h),b=Array.from(new Set(H)),b=b.sort(((t,e)=>t-e)),w=[];for(let t=0;t<b.length;t++){let e,n=Number.POSITIVE_INFINITY;for(let s=0;s<H.length;s++)H[s]===b[t]&&v[s]<n&&(n=v[s],e=s);w.push(v[e])}for(let t=0;t<v.length;t++)if(v[t]===h){let n=[];for(let s=0;s<e.length;s++)n.push(e[s]+C[t][s]*g[s])}O+=1}let D={};D.minFunctionValue=h,D.iterations=O;let A=[];for(let t=0;t<u+1;t++){let n=[];for(let s=0;s<e.length;s++)n.push(e[s]+C[t][s]*g[s]);A.push(n)}D.finalState={numberOfRectangles:u,totalIterations:c+=i,originalCoordinates:A,middlePoint:f,fCalls:p,smallerDistance:d,edgeSizes:y,diagonalDistances:H,functionValues:v,differentDistances:b,smallerValuesByDistance:w,choiceLimit:x};let S=[];for(let t=0;t<v.length;t++)v[t]===h&&S.push(A[t]);return D.optima=S,D}function getMinIndex(t,e,n,s){let i=[];for(let o=0;o<t.length;o++)i[o]=Math.abs(t[o]-(s+n))/e[o];const o=xMinValue(i);return i.findIndex((t=>t===o))}function directOptimization$1(t,e,n){const{minValues:s,maxValues:i,maxIterations:o,epsilon:a,tolerance:l,tolerance2:r,initialState:m}=n,g=direct(getObjectiveFunction$1(t,e),s,i,{iterations:o,epsilon:a,tolerance:l,tolerance2:r,initialState:m}),{optima:u}=g;return{parameterError:g.minFunctionValue,iterations:g.iterations,parameterValues:u[0]}}function getObjectiveFunction$1(t,e){const{x:n,y:s}=t,i=n.length;return t=>{const o=e(t);let a=0;for(let t=0;t<i;t++)a+=Math.pow(s[t]-o(n[t]),2);return a}}function selectMethod(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{kind:e="lm",options:n}=t;switch(e){case"lm":case"levenbergMarquardt":return{algorithm:levenbergMarquardt,optimizationOptions:{damping:1.5,maxIterations:100,errorTolerance:1e-8,...n}};case"direct":return{algorithm:directOptimization$1,optimizationOptions:{iterations:20,epsilon:1e-4,tolerance:1e-16,tolerance2:1e-12,initialState:{},...n}};default:throw new Error("Unknown fitting algorithm")}}function optimize(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},s=xMinMaxValues(t.y);const i={...s,range:s.max-s.min},o=getInternalPeaks(e,i,n),{baseline:a=i.min}=n;let l=new Float64Array(t.y.length);for(let e=0;e<t.y.length;e++)l[e]=(t.y[e]-a)/i.range;const r=o[o.length-1].toIndex+1,m=new Float64Array(r),g=new Float64Array(r),u=new Float64Array(r),c=new Float64Array(r);let C=0;for(const t of o)for(let e=0;e<t.parameters.length;e++)m[C]=t.propertiesValues.min[e],g[C]=t.propertiesValues.max[e],u[C]=t.propertiesValues.init[e],c[C]=t.propertiesValues.gradientDifference[e],C++;let{algorithm:f,optimizationOptions:h}=selectMethod(n.optimization),p=getSumOfShapes$1(o),d=f({x:t.x,y:l},p,{minValues:m,maxValues:g,initialValues:u,gradientDifference:c,...h});const y=d.parameterValues;let H=[];for(let t of o){const{id:e,shape:n,parameters:s,fromIndex:o}=t;let l={x:0,y:0,shape:n};e&&(l={...l,id:e}),l.x=y[o],l.y=y[o+1]*i.range+a;for(let t=2;t<s.length;t++)l.shape[s[t]]=y[o+t];H.push(l)}return{error:d.parameterError,iterations:d.iterations,peaks:H}}const{parse:parse$6,stringify:stringify$6}=JSON;function addMissingShape(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{shape:n={kind:"gaussian"},output:s=parse$6(stringify$6(t))}=e;let i=getShape1D(n);return s.map((t=>{if(hasShape(t)){if(!("fwhm"in t.shape)){const e=getShape1D(t.shape);t.shape.fwhm=e.widthToFWHM(t.width)}return t}return{...t,shape:{fwhm:i.widthToFWHM(t.width),...n}}}))}function hasShape(t){return"shape"in t}function groupPeaks(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(t&&0===t.length)return[];const{factor:n=1}=e;(t=JSON.parse(JSON.stringify(t))).sort(((t,e)=>t.x-e.x));let s=t[0],i=[s],o=[i];for(let e=1;e<t.length;e++){const a=t[e];(a.x-s.x)/((a.width+s.width)/2)<=n?i.push(a):(i=[a],o.push(i)),s=a}return o}function optimizePeaksWithLogs(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{fromTo:s={},baseline:i,shape:o={kind:"gaussian"},groupingFactor:a=1,factorLimits:l=2,optimization:r={kind:"lm",options:{timeout:10}}}=n;let m=groupPeaks(e,{factor:a}),g=[],u=[];return m.forEach((e=>{const n=Date.now(),a=addMissingShape(e,{shape:o}),m=a[0],c=a[a.length-1],{from:C=m.x-m.width*l,to:f=c.x+c.width*l}=s,{fromIndex:h,toIndex:p}=xGetFromToIndex(t.x,{from:C,to:f}),d=t.x instanceof Float64Array?t.x.subarray(h,p):t.x.slice(h,p),y=t.y instanceof Float64Array?t.y.subarray(h,p):t.y.slice(h,p),H={range:{from:C,to:f},parameters:r,groupSize:e.length,time:Date.now()-n};if(d.length>5){const{iterations:t,error:e,peaks:n}=optimize({x:d,y:y},a,{shape:o,baseline:i,optimization:r});for(let t=0;t<a.length;t++)u.push({...n[t],width:getShape1D(a[t].shape).fwhmToWidth(n[t].shape.fwhm)});g.push({...H,iterations:t,error:e,message:"optimization successful"})}else u.push(...a),g.push({...H,iterations:0,message:"x length too small for optimization"})})),{logs:g,optimizedPeaks:u}}function optimizePeaks(t,e){return optimizePeaksWithLogs(t,e,arguments.length>2&&void 0!==arguments[2]?arguments[2]:{}).optimizedPeaks}const{parse:parse$5,stringify:stringify$5}=JSON;function addMissingIDs$1(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{output:n=parse$5(stringify$5(t))}=e;for(const t of n)"id"in t||(t.id=v4());return n}function joinBroadPeaks(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{shape:n={kind:"gaussian"},optimization:s={kind:"lm",options:{timeout:10}},broadWidth:i=.25,broadRatio:o=.0025}=e,a=0,l=0,r=1;const m=[];if(t.length<2)return addMissingIDs$1(addMissingShape(t.map(getGSDPeakOptimizedStructure),{shape:n}));let g=t[0].ddY;for(let e=1;e<t.length;e++)Math.abs(t[e].ddY)>g&&(g=Math.abs(t[e].ddY));const u=[];for(const e of t)Math.abs(e.ddY)<=o*g?m.push(e):u.push(getGSDPeakOptimizedStructure(e));m.push({x:Number.MAX_VALUE,y:0});let c={x:[m[0].x],y:[m[0].y]},C=[0];for(let t=1;t<m.length;t++)if(Math.abs(m[t-1].x-m[t].x)<i)c.x.push(m[t].x),c.y.push(m[t].y),m[t].y>a&&(a=m[t].y,l=t),C.push(t),r++;else{if(r>2){let t=optimizePeaks(c,[{id:v4(),x:m[l].x,y:a,width:c.x[0]-c.x[c.x.length-1]}],{shape:n,optimization:s});u.push(t[0])}else for(const t of C)u.push(getGSDPeakOptimizedStructure(m[t]));c={x:[m[t].x],y:[m[t].y]},C=[t],a=m[t].y,l=t,r=1}return u.sort(((t,e)=>t.x-e.x)),addMissingIDs$1(u,{output:u})}function getGSDPeakOptimizedStructure(t){const{id:e,shape:n,x:s,y:i,width:o}=t;let a={x:s,y:i,width:o,shape:n};return e&&(a.id=e),a}const{parse:parse$4,stringify:stringify$4}=JSON;function setShape(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{shape:n={kind:"gaussian"},output:s=parse$4(stringify$4(t))}=e,i=getShape1D(n);return s.map((t=>({...t,shape:{fwhm:i.widthToFWHM(t.width),...n}})))}function peakToXY(t,e){const n=addMissingShape([t])[0],s=getShape1D(n.shape).getFactor(),{from:i=n.x-t.width*s/e.frequency,to:o=n.x+t.width*s/e.frequency}=e;return peaksToXY([t],{...e,from:i,to:o})}var browserPonyfill={exports:{}};!function(t,e){var n="undefined"!=typeof self?self:commonjsGlobal,s=function(){function t(){this.fetch=!1,this.DOMException=n.DOMException}return t.prototype=n,new t}();!function(t){!function(e){var n="URLSearchParams"in t,s="Symbol"in t&&"iterator"in Symbol,i="FileReader"in t&&"Blob"in t&&function(){try{return new Blob,!0}catch(t){return!1}}(),o="FormData"in t,a="ArrayBuffer"in t;if(a)var l=["[object Int8Array]","[object Uint8Array]","[object Uint8ClampedArray]","[object Int16Array]","[object Uint16Array]","[object Int32Array]","[object Uint32Array]","[object Float32Array]","[object Float64Array]"],r=ArrayBuffer.isView||function(t){return t&&l.indexOf(Object.prototype.toString.call(t))>-1};function m(t){if("string"!=typeof t&&(t=String(t)),/[^a-z0-9\-#$%&'*+.^_`|~]/i.test(t))throw new TypeError("Invalid character in header field name");return t.toLowerCase()}function g(t){return"string"!=typeof t&&(t=String(t)),t}function u(t){var e={next:function(){var e=t.shift();return{done:void 0===e,value:e}}};return s&&(e[Symbol.iterator]=function(){return e}),e}function c(t){this.map={},t instanceof c?t.forEach((function(t,e){this.append(e,t)}),this):Array.isArray(t)?t.forEach((function(t){this.append(t[0],t[1])}),this):t&&Object.getOwnPropertyNames(t).forEach((function(e){this.append(e,t[e])}),this)}function C(t){if(t.bodyUsed)return Promise.reject(new TypeError("Already read"));t.bodyUsed=!0}function f(t){return new Promise((function(e,n){t.onload=function(){e(t.result)},t.onerror=function(){n(t.error)}}))}function h(t){var e=new FileReader,n=f(e);return e.readAsArrayBuffer(t),n}function p(t){if(t.slice)return t.slice(0);var e=new Uint8Array(t.byteLength);return e.set(new Uint8Array(t)),e.buffer}function d(){return this.bodyUsed=!1,this._initBody=function(t){var e;this._bodyInit=t,t?"string"==typeof t?this._bodyText=t:i&&Blob.prototype.isPrototypeOf(t)?this._bodyBlob=t:o&&FormData.prototype.isPrototypeOf(t)?this._bodyFormData=t:n&&URLSearchParams.prototype.isPrototypeOf(t)?this._bodyText=t.toString():a&&i&&((e=t)&&DataView.prototype.isPrototypeOf(e))?(this._bodyArrayBuffer=p(t.buffer),this._bodyInit=new Blob([this._bodyArrayBuffer])):a&&(ArrayBuffer.prototype.isPrototypeOf(t)||r(t))?this._bodyArrayBuffer=p(t):this._bodyText=t=Object.prototype.toString.call(t):this._bodyText="",this.headers.get("content-type")||("string"==typeof t?this.headers.set("content-type","text/plain;charset=UTF-8"):this._bodyBlob&&this._bodyBlob.type?this.headers.set("content-type",this._bodyBlob.type):n&&URLSearchParams.prototype.isPrototypeOf(t)&&this.headers.set("content-type","application/x-www-form-urlencoded;charset=UTF-8"))},i&&(this.blob=function(){var t=C(this);if(t)return t;if(this._bodyBlob)return Promise.resolve(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(new Blob([this._bodyArrayBuffer]));if(this._bodyFormData)throw new Error("could not read FormData body as blob");return Promise.resolve(new Blob([this._bodyText]))},this.arrayBuffer=function(){return this._bodyArrayBuffer?C(this)||Promise.resolve(this._bodyArrayBuffer):this.blob().then(h)}),this.text=function(){var t,e,n,s=C(this);if(s)return s;if(this._bodyBlob)return t=this._bodyBlob,e=new FileReader,n=f(e),e.readAsText(t),n;if(this._bodyArrayBuffer)return Promise.resolve(function(t){for(var e=new Uint8Array(t),n=new Array(e.length),s=0;s<e.length;s++)n[s]=String.fromCharCode(e[s]);return n.join("")}(this._bodyArrayBuffer));if(this._bodyFormData)throw new Error("could not read FormData body as text");return Promise.resolve(this._bodyText)},o&&(this.formData=function(){return this.text().then(v)}),this.json=function(){return this.text().then(JSON.parse)},this}c.prototype.append=function(t,e){t=m(t),e=g(e);var n=this.map[t];this.map[t]=n?n+", "+e:e},c.prototype.delete=function(t){delete this.map[m(t)]},c.prototype.get=function(t){return t=m(t),this.has(t)?this.map[t]:null},c.prototype.has=function(t){return this.map.hasOwnProperty(m(t))},c.prototype.set=function(t,e){this.map[m(t)]=g(e)},c.prototype.forEach=function(t,e){for(var n in this.map)this.map.hasOwnProperty(n)&&t.call(e,this.map[n],n,this)},c.prototype.keys=function(){var t=[];return this.forEach((function(e,n){t.push(n)})),u(t)},c.prototype.values=function(){var t=[];return this.forEach((function(e){t.push(e)})),u(t)},c.prototype.entries=function(){var t=[];return this.forEach((function(e,n){t.push([n,e])})),u(t)},s&&(c.prototype[Symbol.iterator]=c.prototype.entries);var y=["DELETE","GET","HEAD","OPTIONS","POST","PUT"];function H(t,e){var n,s,i=(e=e||{}).body;if(t instanceof H){if(t.bodyUsed)throw new TypeError("Already read");this.url=t.url,this.credentials=t.credentials,e.headers||(this.headers=new c(t.headers)),this.method=t.method,this.mode=t.mode,this.signal=t.signal,i||null==t._bodyInit||(i=t._bodyInit,t.bodyUsed=!0)}else this.url=String(t);if(this.credentials=e.credentials||this.credentials||"same-origin",!e.headers&&this.headers||(this.headers=new c(e.headers)),this.method=(n=e.method||this.method||"GET",s=n.toUpperCase(),y.indexOf(s)>-1?s:n),this.mode=e.mode||this.mode||null,this.signal=e.signal||this.signal,this.referrer=null,("GET"===this.method||"HEAD"===this.method)&&i)throw new TypeError("Body not allowed for GET or HEAD requests");this._initBody(i)}function v(t){var e=new FormData;return t.trim().split("&").forEach((function(t){if(t){var n=t.split("="),s=n.shift().replace(/\+/g," "),i=n.join("=").replace(/\+/g," ");e.append(decodeURIComponent(s),decodeURIComponent(i))}})),e}function b(t,e){e||(e={}),this.type="default",this.status=void 0===e.status?200:e.status,this.ok=this.status>=200&&this.status<300,this.statusText="statusText"in e?e.statusText:"OK",this.headers=new c(e.headers),this.url=e.url||"",this._initBody(t)}H.prototype.clone=function(){return new H(this,{body:this._bodyInit})},d.call(H.prototype),d.call(b.prototype),b.prototype.clone=function(){return new b(this._bodyInit,{status:this.status,statusText:this.statusText,headers:new c(this.headers),url:this.url})},b.error=function(){var t=new b(null,{status:0,statusText:""});return t.type="error",t};var w=[301,302,303,307,308];b.redirect=function(t,e){if(-1===w.indexOf(e))throw new RangeError("Invalid status code");return new b(null,{status:e,headers:{location:t}})},e.DOMException=t.DOMException;try{new e.DOMException}catch(t){e.DOMException=function(t,e){this.message=t,this.name=e;var n=Error(t);this.stack=n.stack},e.DOMException.prototype=Object.create(Error.prototype),e.DOMException.prototype.constructor=e.DOMException}function x(t,n){return new Promise((function(s,o){var a=new H(t,n);if(a.signal&&a.signal.aborted)return o(new e.DOMException("Aborted","AbortError"));var l=new XMLHttpRequest;function r(){l.abort()}l.onload=function(){var t,e,n={status:l.status,statusText:l.statusText,headers:(t=l.getAllResponseHeaders()||"",e=new c,t.replace(/\r?\n[\t ]+/g," ").split(/\r?\n/).forEach((function(t){var n=t.split(":"),s=n.shift().trim();if(s){var i=n.join(":").trim();e.append(s,i)}})),e)};n.url="responseURL"in l?l.responseURL:n.headers.get("X-Request-URL");var i="response"in l?l.response:l.responseText;s(new b(i,n))},l.onerror=function(){o(new TypeError("Network request failed"))},l.ontimeout=function(){o(new TypeError("Network request failed"))},l.onabort=function(){o(new e.DOMException("Aborted","AbortError"))},l.open(a.method,a.url,!0),"include"===a.credentials?l.withCredentials=!0:"omit"===a.credentials&&(l.withCredentials=!1),"responseType"in l&&i&&(l.responseType="blob"),a.headers.forEach((function(t,e){l.setRequestHeader(e,t)})),a.signal&&(a.signal.addEventListener("abort",r),l.onreadystatechange=function(){4===l.readyState&&a.signal.removeEventListener("abort",r)}),l.send(void 0===a._bodyInit?null:a._bodyInit)}))}x.polyfill=!0,t.fetch||(t.fetch=x,t.Headers=c,t.Request=H,t.Response=b),e.Headers=c,e.Request=H,e.Response=b,e.fetch=x,Object.defineProperty(e,"__esModule",{value:!0})}({})}(s),s.fetch.ponyfill=!0,delete s.fetch.polyfill;var i=s;(e=i.fetch).default=i.fetch,e.fetch=i.fetch,e.Headers=i.Headers,e.Request=i.Request,e.Response=i.Response,t.exports=e}(browserPonyfill,browserPonyfill.exports);var fetch=getDefaultExportFromCjs(browserPonyfill.exports),browser="object"==typeof self?self.FormData:window.FormData,FormData$1=browser;let xAtomicNumber=0;function tagAtom(t,e){let n=`${t.getAtomLabel(e)}*`;return t.setAtomCustomLabel(e,n),1===t.getAtomicNo(e)?t.setAtomicNo(e,getXAtomicNumber(t)):t.setAtomMass(e,t.getAtomMass(e)+5),n}function getXAtomicNumber(t){if(!xAtomicNumber){const e=t.getOCL();xAtomicNumber=e.Molecule.getAtomicNoFromLabel("X",e.Molecule.cPseudoAtomX)}return xAtomicNumber}function addDiastereotopicMissingChirality(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{Molecule:n}=t.getOCL(),{esrType:s=n.cESRTypeAnd}=e;for(let e=0;e<t.getAllAtoms();e++){let i=t.getCompactCopy();tagAtom(i,e),i.ensureHelperArrays(n.cHelperBitsStereo);for(let e=0;e<i.getAtoms();e++)if(i.isAtomStereoCenter(e)&&-1===i.getStereoBond(e)){let o=i.getAtomPreferredStereoBond(e);if(-1!==o){if(t.setBondType(o,n.cBondTypeUp),t.getBondAtom(1,o)===e){let n=t.getBondAtom(0,o);t.setBondAtom(0,o,e),t.setBondAtom(1,o,n)}t.setAtomESR(e,s,0)}}}}function makeRacemic(t){const{Molecule:e}=t.getOCL();t.ensureHelperArrays(e.cHelperCIP);for(let n=0;n<t.getAllAtoms();n++)t.getAtomParity(n)!==e.cAtomParityNone&&t.setAtomESR(n,e.cESRTypeAnd,0)}function getDiastereotopicAtomIDs(t){const e=t.getOCL();addDiastereotopicMissingChirality(t);let n=t.getAllAtoms(),s=[];for(let i=0;i<n;i++){let n=t.getCompactCopy();tagAtom(n,i),makeRacemic(n),s[i]=n.getCanonizedIDCode(e.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS)}return s}function groupDiastereotopicAtomIDs(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{atomLabel:s}=n,i={};for(let n=0;n<t.length;n++)if(!s||e.getAtomLabel(n)===s){let s=t[n];i[s]||(i[s]={counter:0,atoms:[],oclID:s,atomLabel:e.getAtomLabel(n)}),i[s].counter++,i[s].atoms.push(n)}return Object.keys(i).map((t=>i[t]))}function getGroupedDiastereotopicAtomIDs(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return groupDiastereotopicAtomIDs(getDiastereotopicAtomIDs(t),t,e)}function isCsp3(t,e){return 6===t.getAtomicNo(e)&&(0===t.getAtomCharge(e)&&t.getImplicitHydrogens(e)+t.getConnAtoms(e)===4)}const FULL_HOSE_CODE=1,HOSE_CODE_CUT_C_SP3_SP3=2;function getHoseCodesForAtoms(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const s=t.getOCL(),{minSphereSize:i=0,maxSphereSize:o=4,kind:a=FULL_HOSE_CODE,isTagged:l=!1}=n,r=t.getCompactCopy();if(!l){const t=[];for(let n=0;n<e.length;n++){let i=e[n];t.push(tagAtom(r,i)),r.addImplicitHydrogens(),r.addMissingChirality(),r.ensureHelperArrays(s.Molecule.cHelperNeighbours)}e.length=0;for(let n=0;n<r.getAllAtoms();n++)t.includes(r.getAtomCustomLabel(n))&&e.push(n)}let m=new s.Molecule(0,0),g=[],u=0,c=0,C=new Array(r.getAllAtoms()),f=new Array(r.getAllAtoms());for(let t=0;t<=o;t++){if(0===c)for(let t of e)f[c]=t,C[t]=!0,c++;else{let t=c;for(let e=u;e<c;e++){let n=f[e];for(let e=0;e<r.getAllConnAtoms(n);e++){let s=r.getConnAtom(n,e);if(!C[s])switch(a){case FULL_HOSE_CODE:C[s]=!0,f[t++]=s;break;case HOSE_CODE_CUT_C_SP3_SP3:isCsp3(r,n)&&isCsp3(r,s)||(C[s]=!0,f[t++]=s);break;default:throw new Error("getHoseCoesForAtom unknown kind")}}}u=c,c=t}r.copyMoleculeByAtoms(m,C,!0,null),t>=i&&(makeRacemic(m),g.push(m.getCanonizedIDCode(s.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS)))}return g}function getHoseCodesForAtom(t,e){return getHoseCodesForAtoms(t,[e],arguments.length>2&&void 0!==arguments[2]?arguments[2]:{})}function getHoseCodesFromDiastereotopicID(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};t.addImplicitHydrogens(),t.addMissingChirality();let n=-1;for(let e=0;e<t.getAllAtoms();e++){const s=t.getAtomCustomLabel(e);if(null!=s&&s.endsWith("*")){n=e;break}}if(n>=0)return e.isTagged=!0,getHoseCodesForAtom(t,n,e)}let fragment$1,fragment;function getHoseCodesForPath(t,e,n,s){const i=t.getOCL(),o=e,a=n;let l,r=[];(t=t.getCompactCopy()).getPath(r,e,n,s+1),4===r.length&&(l=t.calculateTorsion(r));const m=tagAtom(t,e),g=tagAtom(t,n);t.addImplicitHydrogens(),t.addMissingChirality(),t.ensureHelperArrays(i.Molecule.cHelperNeighbours),e=-1,n=-1;for(let s=0;s<t.getAllAtoms();s++)m===g?t.getAtomCustomLabel(s)===m&&(-1===e?e=s:n=s):(m===t.getAtomCustomLabel(s)&&(e=s),g===t.getAtomCustomLabel(s)&&(n=s));fragment$1||(fragment$1=new i.Molecule(0,0));let u=[];t.getPath(u,e,n,s+1);let c=0,C=0,f=new Array(t.getAllAtoms()).fill(!1),h=new Array(t.getAllAtoms()).fill(-1),p=[];for(let e=0;e<=2;e++){if(0===C)for(let t of u)f[t]=!0,h[C++]=t;else{let e=C;for(let n=c;n<C;n++){let s=h[n];for(let n=0;n<t.getAllConnAtoms(s);n++){let i=t.getConnAtom(s,n);f[i]||(f[i]=!0,h[e++]=i)}}c=C,C=e}let n=[];t.copyMoleculeByAtoms(fragment$1,f,!0,n),makeRacemic(fragment$1);let s=fragment$1.getCanonizedIDCode(i.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS);p.push({sphere:e,oclID:s})}return{atoms:r,from:o,to:a,torsion:l,hoses:p,length:r.length-1}}function getAtomsInfo(t){const e=t.getOCL();t.ensureHelperArrays(e.Molecule.cHelperRings);let n=getDiastereotopicAtomIDs(t),s=[];for(let e=0;e<n.length;e++){let i={oclID:n[e],extra:{singleBonds:0,doubleBonds:0,tripleBonds:0,aromaticBonds:0,cnoHybridation:0}},o=i.extra;s.push(i),i.abnormalValence=t.getAtomAbnormalValence(e),i.charge=t.getAtomCharge(e),i.cipParity=t.getAtomCIPParity(e),i.color=t.getAtomColor(e),i.customLabel=t.getAtomCustomLabel(e),i.atomicNo=t.getAtomicNo(e),i.label=t.getAtomLabel(e),i.mass=t.getAtomMass(e),i.radical=t.getAtomRadical(e),i.ringBondCount=t.getAtomRingBondCount(e),i.ringSize=t.getAtomRingSize(e),i.x=t.getAtomX(e),i.y=t.getAtomY(e),i.z=t.getAtomZ(e),i.allHydrogens=t.getAllHydrogens(e),i.connAtoms=t.getConnAtoms(e),i.allConnAtoms=t.getAllConnAtoms(e),i.implicitHydrogens=i.allHydrogens+i.connAtoms-i.allConnAtoms,i.isAromatic=t.isAromaticAtom(e),i.isAllylic=t.isAllylicAtom(e),i.isStereoCenter=t.isAtomStereoCenter(e),i.isRing=t.isRingAtom(e),i.isSmallRing=t.isSmallRingAtom(e),i.isStabilized=t.isStabilizedAtom(e),i.extra.singleBonds=1===i.atomicNo?0:i.implicitHydrogens;for(let n=0;n<t.getAllConnAtoms(e);n++){let s=t.getConnBond(e,n),i=t.getBondOrder(s);t.isAromaticBond(s)?o.aromaticBonds++:1===i?o.singleBonds++:2===i?o.doubleBonds++:3===i&&o.tripleBonds++}if(i.extra.totalBonds=i.extra.singleBonds+i.extra.doubleBonds+i.extra.tripleBonds+i.extra.aromaticBonds,6===i.atomicNo)i.extra.cnoHybridation=i.extra.totalBonds-1;else if(7===i.atomicNo)i.extra.cnoHybridation=i.extra.totalBonds;else if(8===i.atomicNo)i.extra.cnoHybridation=i.extra.totalBonds+1;else if(1===i.atomicNo){let n=0===t.getAllConnAtoms(e)?0:t.getAtomicNo(t.getConnAtom(e,0));i.extra.hydrogenOnAtomicNo=n,7!==n&&8!==n||(i.extra.labileHydrogen=!0)}}return s}function floydWarshall(t){if(Matrix.isMatrix(t)&&t.columns!==t.rows)throw new TypeError("The adjacency matrix should be squared");const e=t.columns;let n=new Matrix(e,e);n.apply(((e,s)=>{if(e===s)n.set(e,s,0);else{let i=t.get(e,s);i||Object.is(i,-0)?n.set(e,s,i):n.set(e,s,Number.POSITIVE_INFINITY)}}));for(let t=0;t<e;++t)for(let s=0;s<e;++s)for(let i=0;i<e;++i){let e=n.get(s,t)+n.get(t,i);n.get(s,i)>e&&n.set(s,i,e)}return n.apply(((t,e)=>{n.get(t,e)===Number.POSITIVE_INFINITY&&n.set(t,e,-1)})),n}function getConnectivityMatrix(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const n=t.getOCL();t.ensureHelperArrays(n.Molecule.cHelperNeighbours);let s=t.getAllAtoms(),i=new Array(s).fill();if(i=i.map((()=>new Array(s).fill(0))),!e.pathLength)if(e.atomicNo)for(let e=0;e<s;e++)i[e][e]=t.getAtomicNo(e);else if(e.negativeAtomicNo)for(let e=0;e<s;e++)i[e][e]=-t.getAtomicNo(e);else if(e.mass)for(let e=0;e<s;e++)i[e][e]=n.Molecule.cRoundedMass[t.getAtomicNo(e)];else for(let t=0;t<s;t++)i[t][t]=1;if(e.sdt)for(let e=0;e<s;e++){let n=t.getAllConnAtoms(e);for(let s=0;s<n;s++)i[e][t.getConnAtom(e,s)]=t.getConnBondOrder(e,s)}else if(e.sdta)for(let e=0;e<s;e++){let n=t.getAllConnAtoms(e);for(let s=0;s<n;s++){let n=t.getConnBond(e,s);t.isAromaticBond(n)?i[e][t.getConnAtom(e,s)]=4:i[e][t.getConnAtom(e,s)]=t.getConnBondOrder(e,s)}}else for(let e=0;e<s;e++){let n=t.getAllConnAtoms(e);for(let s=0;s<n;s++)i[e][t.getConnAtom(e,s)]=1}return e.pathLength&&(i=floydWarshall(new Matrix(i)).to2DArray()),i}function getPathAndTorsion(t,e,n,s){let i,o=[];return t.getPath(o,e,n,s+1),4===o.length&&(i=t.calculateTorsion(o)),{atoms:o,from:e,to:n,torsion:i,length:o.length-1}}function getPathsInfo(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{fromLabel:n="H",toLabel:s="H",minLength:i=1,maxLength:o=4,withHOSES:a=!1}=e,l=t.getOCL();fragment||(fragment=new l.Molecule(0,0));let r=l.Molecule.getAtomicNoFromLabel(n),m=l.Molecule.getAtomicNoFromLabel(s),g=getAtomsInfo(t),u=getConnectivityMatrix(t,{pathLength:!0});for(let e=0;e<t.getAllAtoms();e++){g[e].paths=[];for(let n=0;n<t.getAllAtoms();n++)if(e!==n&&t.getAtomicNo(e)===r&&t.getAtomicNo(n)===m){let s=u[e][n];s>=i&&s<=o&&(a?g[e].paths.push(getHoseCodesForPath(t,e,n,s)):g[e].paths.push(getPathAndTorsion(t,e,n,s)))}}return g}const result={};for(const{value:t,multiplicity:e,names:n}of MultiplicityPatterns){e&&(result[t]=e-1);for(const t of n)e&&(result[t]=e-1)}const couplingValues=result;function joinPatterns(t,e){const n=t.reduce(((t,e)=>{if(isNaN(couplingValues[e]))throw new Error(`pattern ${e} is not in ${Object.keys(couplingValues).join(" ")}`);return t+couplingValues[e]}),0);if(!couplingPatterns[n])throw new Error("The joined pattern doesn't exist");return e?.acsFormat?couplingACSPatterns[n]:couplingPatterns[n]}const localeCompare$1=(t,e)=>t.localeCompare(e),localeCompareJcouplingKeys$1=(t,e)=>{const n=`${t.diaIDs.sort(localeCompare$1).join(" ")}`,s=`${e.diaIDs.sort(localeCompare$1).join(" ")}`;return localeCompare$1(n,s)},areThanClose=(t,e,n)=>Math.abs(t.coupling-e.coupling)<n,takeCareDiaIDs=(t,e,n)=>0===localeCompareJcouplingKeys$1(t,e)&&areThanClose(t,e,n);function signalJoinCouplings(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{tolerance:n=.05,ignoreDiaIDs:s=!1,acsFormat:i=!1}=e;return!t.js||t.js.length<2?t:s?(checkJs(t),groupJCouplings(t,areThanClose,{tolerance:n,acsFormat:i})):(checkJsAndDiaID(t),groupJCouplings(t,takeCareDiaIDs,{tolerance:n,acsFormat:i}))}function groupJCouplings(t,e,n){const{tolerance:s,acsFormat:i}=n;t.js.sort(((t,e)=>e.coupling-t.coupling));let o=[t.js[0]],a=[o];for(let n=1;n<t.js.length;n++){let i=t.js[n];e(o[o.length-1],i,s)?o.push(i):(o=[i],a.push(o))}t.js=[];for(let e of a){let n=xSum(e.map((t=>t.coupling)))/e.length,s=distinctValues(e.filter((t=>t.atoms)).map((t=>t.atoms)).flat()),o=distinctValues(e.filter((t=>t.assignment)).map((t=>t.assignment)).flat()).join(" "),a=distinctValues(e.filter((t=>t.diaIDs)).map((t=>t.diaIDs)).flat()),l=distinctValues(e.map((t=>t.pathLength))),r={coupling:n,multiplicity:joinPatterns(e.filter((t=>t.multiplicity)).map((t=>t.multiplicity)),{acsFormat:i})};1===a.length&&(r.diaIDs=a),1===l.length&&l[0]&&(r.pathLength=l[0]),o.length>0&&(r.assignment=o),s.length>0&&(r.atoms=s),t.js.push(r)}return t}function distinctValues(t){const e=new Set;for(const n of t)e.add(n);return Array.from(e)}function checkJsAndDiaID(t){if(!t.js)throw new Error("there is not js");for(const e of t.js)if(!e.diaIDs)throw new Error("there is not diaIDs")}function checkJs(t){if(!t.js)throw new Error("there is not js")}const localeCompare=(t,e)=>t.localeCompare(e),localeCompareJcouplingKeys=(t,e)=>{const n=`${t.diaIDs.join(" ")}${t.pathLength}`,s=`${e.diaIDs.join(" ")}${e.pathLength}`;return localeCompare(n,s)};function checkForMandatory$2(t){for(const e of t){if(!e.js)throw new Error("there is not js");if(!e.diaIDs)throw new Error("there is not diaIDs");for(const t of e.js){if(!t.diaIDs)throw new Error("there is not diaIDs");if(!t.pathLength)throw new Error("there is not pathLength")}}}function signalsJoin(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};checkForMandatory$2(t);const{joinCouplings:n={}}=e,{tolerance:s,ignoreDiaIDs:i}=n,o=JSON.parse(JSON.stringify(t)),a={};for(let t of o){t.js=t.js.sort(localeCompareJcouplingKeys);let e=`${t.diaIDs.join(" ")} ${t.js.map((t=>`${t.diaIDs.join(" ")} ${t.pathLength}`)).sort(localeCompare).join(" ")}`;a[e]||(a[e]=[]),a[e].push(t)}let l=[];return Object.values(a).forEach((t=>{let e=[];for(let n=0;n<t[0].js.length;n++){const s=t[0].js[n];e.push({diaIDs:s.diaIDs,pathLength:s.pathLength,multiplicity:s.multiplicity,coupling:xMean(t.map((t=>t.js[n].coupling)))})}let n={id:v4(),nbAtoms:xSum(t.map((t=>t.nbAtoms||0))),delta:xMean(t.map((t=>t.delta))),diaIDs:t[0].diaIDs,atoms:t.map((t=>t.atoms||[])).flat(),js:e};const s=t.map((t=>t.assignment)).filter((t=>t)).join(" ");s.length>0&&(n.assignment=s),l.push(n)})),l=l.map((t=>{let e=signalJoinCouplings(t,{tolerance:s,ignoreDiaIDs:i});return e.js&&(e.multiplicity=e.js.length>0?e.js.map((t=>t.multiplicity)).join(""):"s"),e})).sort(((t,e)=>t.delta-e.delta)),l}function rangeFromSignal(t,e){const{nucleus:n="1h",frequency:s=400}=e,{tolerance:i=getTolerance(n)/s}=e;let o=0;const{js:a=[],multiplicity:l}=t;if(a.length>0)for(const t of a){const{coupling:e,multiplicity:n="d"}=t;o+=couplingValues[n]*e/s}else"m"===l?o=16/s:"b"!==l&&"br s"!==l||(o=7/s);return o=i+o/2,{from:t.delta-o,to:t.delta+o}}function getTolerance(t){switch(t.toLocaleLowerCase()){case"1h":return 1.5;case"13C":return 3;default:return 2}}function checkNbAtoms(t){for(let e of t)if(!e.nbAtoms)throw new Error("nbAtoms is mandatory")}function signalsToRanges(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};checkNbAtoms(t);const{tolerance:n=.05,frequency:s=400}=e;let i=t.map((t=>({original:t})));i.forEach((t=>{const e=rangeFromSignal(t.original,{frequency:s,tolerance:n});t.from=e.from,t.to=e.to})),i=i.sort(((t,e)=>t.from-e.from));let o=[],a={};for(let t of i)void 0===a.from||t.from>a.to?(a={id:v4(),from:t.from,to:t.to,integration:t.original.nbAtoms,signals:[t.original]},o.push(a)):(a.integration+=t.original.nbAtoms,t.to>a.to&&(a.to=t.to),a.signals.push(t.original));return o}function isEmptyMolecule(t){return t.getAllAtoms()<1}async function predictProton(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(isEmptyMolecule(t))return{molfile:t.toMolfile(),nucleus:"13C",diaIDs:[],joinedSignals:[],signals:[],ranges:[],molecule:t};const{cache:n}=e;(t=t.getCompactCopy()).addImplicitHydrogens(),addDiastereotopicMissingChirality(t);const s=t.toMolfile();let i;if(n&&(i=n(s)),void 0===i){const t=new FormData$1;t.append("molfile",s);const e=await fetch("https://www.nmrdb.org/service/predictor",{method:"POST",body:t});i=await e.text(),n&&n(s,i)}const{diaIDs:o=getDiastereotopicAtomIDs(t)}=e,a=protonParser(i,t,o),l=signalsJoin(a);return{molfile:s,diaIDs:o,nucleus:"1H",joinedSignals:l,signals:a,ranges:signalsToRanges(l),molecule:t}}function protonParser(t,e,n){if(0===e.getAllAtoms())return[];if(t.includes("ERR"))throw Error(`Spinus optimization: ${t}`);let s=getConnectivityMatrix(e,{pathLength:!0}),i=t.split("\n").filter((t=>t)),o=[];for(let t of i){let e=t.split("\t"),i=e.slice(4),a=Number(e[0])-1,l={id:v4(),atoms:[a],diaIDs:[n[a]],nbAtoms:1,delta:Number(e[2]),js:[]};if(!l.js)throw new Error("For atom js property was not added");for(let t=0;t<i.length;t+=3){let e=Number(i[t])-1;l.js.push({coupling:Number(i[t+2]),atoms:[e],diaIDs:[n[e]],multiplicity:"d",pathLength:s[a][e]}),l.js.sort(((t,e)=>e.coupling-t.coupling))}o.push(l)}return o}const{parse:parse$3,stringify:stringify$3}=JSON;function setIDs(t){const e=(arguments.length>1&&void 0!==arguments[1]?arguments[1]:{}).output||parse$3(stringify$3(t));for(const t of e)t.id=v4();return e}async function fetchPrediction(t,e){const{webserviceURL:n}=e,s=await browserPonyfill.exports.fetch(n,{headers:{accept:"application/json","content-type":"application/json"},body:JSON.stringify({molfile:t.toMolfile()}),method:"POST"});if(s.status>=400)throw new Error(s.statusText);const i=(await s.json()).data;return i.molecule=t.getOCL().Molecule.fromMolfile(i.molfile),i}function getFilteredIDiaIDs(t,e){const{maxSphereSize:n,diaIDs:s}=e;t.addImplicitHydrogens(),t.addMissingChirality(),addDiastereotopicMissingChirality(t);const i=t.toMolfile();let o=groupDiastereotopicAtomIDs(s,t,{atomLabel:"C"}).sort(((t,e)=>t.atomLabel===e.atomLabel?e.counter-t.counter:t.atomLabel<e.atomLabel?1:-1));const a=t.getOCL();for(const t of o)t.hose=getHoseCodesFromDiastereotopicID(a.Molecule.fromIDCode(t.oclID),{maxSphereSize:n});return{molfile:i,carbonDiaIDs:o}}function queryByHose(t,e,n){const{maxSphereSize:s}=n,i=[];for(const n of t){let t,o=null;for(let i=s;!t&&i>=0;i--)e[i]&&(t=e[i][n.hose[i]],o=i);for(const e of n.atoms){let s={diaIDs:[n.oclID],delta:t?t[0]:null,atoms:[e],nbAtoms:1,level:o,statistic:t&&t.length>1?{mean:t[1],sd:t[2],min:t[3],max:t[4],nb:t[5]}:void 0};i.push(s)}}return i}function checkFromPrediction(t){if(!t.atoms)throw new Error("There is not atoms");if(!t.diaIDs)throw new Error("There is not diaIDs");if(!t.nbAtoms)throw new Error("There is not nbAtoms")}async function predictCarbon(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(isEmptyMolecule(t))return{molfile:t.toMolfile(),nucleus:"13C",diaIDs:[],joinedSignals:[],signals:[],ranges:[],molecule:t};let{database:n,webserviceURL:s="https://nmr-prediction.service.zakodium.com/v1/predict/carbon",diaIDs:i=getDiastereotopicAtomIDs(t)}=e;if(!n)return fetchPrediction(t,{webserviceURL:s});if(!n)throw new Error("There is not a database");const o=n.length-1;let{maxSphereSize:a=o}=e;a>o&&(a=o);const{carbonDiaIDs:l,molfile:r}=getFilteredIDiaIDs(t,{maxSphereSize:a,diaIDs:i});const m=formatSignals(queryByHose(l,n,{maxSphereSize:a})),g=joinSignalByDiaID(m);return{molfile:r,nucleus:"13C",diaIDs:i,joinedSignals:g,signals:m,ranges:signalsToRanges(g),molecule:t}}function formatSignals(t){let e=[];for(const n of t){const{atoms:t,nbAtoms:s,delta:i,diaIDs:o,statistic:a}=n,l={id:v4(),delta:i||NaN,atoms:t,diaIDs:o,multiplicity:"s",nbAtoms:s,statistic:a,js:[]};e.push(l)}return e}function joinSignalByDiaID(t){let e={};for(let n of t){checkFromPrediction(n);let t=n.diaIDs[0];e[t]?(e[t].nbAtoms+=n.nbAtoms,e[t].atoms.push(...n.atoms)):e[t]=JSON.parse(JSON.stringify(n))}return setIDs(Object.values(e))}function squaredEuclidean(t,e){let n=0;for(let s=0;s<t.length;s++)n+=(t[s]-e[s])*(t[s]-e[s]);return n}function euclidean(t,e){return Math.sqrt(squaredEuclidean(t,e))}function distanceMatrix(t,e){const n=getMatrix(t.length);for(let s=0;s<t.length;s++)for(let i=0;i<=s;i++)n[s][i]=e(t[s],t[i]),n[i][s]=n[s][i];return n}function getMatrix(t){const e=[];for(let n=0;n<t;n++){const n=[];e.push(n);for(let e=0;e<t;e++)n.push(0)}return e}var heap$1={exports:{}};!function(t,e){(function(){var e,n,s,i,o,a,l,r,m,g,u,c,C,f,h;s=Math.floor,g=Math.min,n=function(t,e){return t<e?-1:t>e?1:0},m=function(t,e,i,o,a){var l;if(null==i&&(i=0),null==a&&(a=n),i<0)throw new Error("lo must be non-negative");for(null==o&&(o=t.length);i<o;)a(e,t[l=s((i+o)/2)])<0?o=l:i=l+1;return[].splice.apply(t,[i,i-i].concat(e)),e},a=function(t,e,s){return null==s&&(s=n),t.push(e),f(t,0,t.length-1,s)},o=function(t,e){var s,i;return null==e&&(e=n),s=t.pop(),t.length?(i=t[0],t[0]=s,h(t,0,e)):i=s,i},r=function(t,e,s){var i;return null==s&&(s=n),i=t[0],t[0]=e,h(t,0,s),i},l=function(t,e,s){var i;return null==s&&(s=n),t.length&&s(t[0],e)<0&&(e=(i=[t[0],e])[0],t[0]=i[1],h(t,0,s)),e},i=function(t,e){var i,o,a,l,r,m;for(null==e&&(e=n),r=[],o=0,a=(l=function(){m=[];for(var e=0,n=s(t.length/2);0<=n?e<n:e>n;0<=n?e++:e--)m.push(e);return m}.apply(this).reverse()).length;o<a;o++)i=l[o],r.push(h(t,i,e));return r},C=function(t,e,s){var i;if(null==s&&(s=n),-1!==(i=t.indexOf(e)))return f(t,0,i,s),h(t,i,s)},u=function(t,e,s){var o,a,r,m,g;if(null==s&&(s=n),!(a=t.slice(0,e)).length)return a;for(i(a,s),r=0,m=(g=t.slice(e)).length;r<m;r++)o=g[r],l(a,o,s);return a.sort(s).reverse()},c=function(t,e,s){var a,l,r,u,c,C,f,h,p;if(null==s&&(s=n),10*e<=t.length){if(!(r=t.slice(0,e).sort(s)).length)return r;for(l=r[r.length-1],u=0,C=(f=t.slice(e)).length;u<C;u++)s(a=f[u],l)<0&&(m(r,a,0,null,s),r.pop(),l=r[r.length-1]);return r}for(i(t,s),p=[],c=0,h=g(e,t.length);0<=h?c<h:c>h;0<=h?++c:--c)p.push(o(t,s));return p},f=function(t,e,s,i){var o,a,l;for(null==i&&(i=n),o=t[s];s>e&&i(o,a=t[l=s-1>>1])<0;)t[s]=a,s=l;return t[s]=o},h=function(t,e,s){var i,o,a,l,r;for(null==s&&(s=n),o=t.length,r=e,a=t[e],i=2*e+1;i<o;)(l=i+1)<o&&!(s(t[i],t[l])<0)&&(i=l),t[e]=t[i],i=2*(e=i)+1;return t[e]=a,f(t,r,e,s)},e=function(){function t(t){this.cmp=null!=t?t:n,this.nodes=[]}return t.push=a,t.pop=o,t.replace=r,t.pushpop=l,t.heapify=i,t.updateItem=C,t.nlargest=u,t.nsmallest=c,t.prototype.push=function(t){return a(this.nodes,t,this.cmp)},t.prototype.pop=function(){return o(this.nodes,this.cmp)},t.prototype.peek=function(){return this.nodes[0]},t.prototype.contains=function(t){return-1!==this.nodes.indexOf(t)},t.prototype.replace=function(t){return r(this.nodes,t,this.cmp)},t.prototype.pushpop=function(t){return l(this.nodes,t,this.cmp)},t.prototype.heapify=function(){return i(this.nodes,this.cmp)},t.prototype.updateItem=function(t){return C(this.nodes,t,this.cmp)},t.prototype.clear=function(){return this.nodes=[]},t.prototype.empty=function(){return 0===this.nodes.length},t.prototype.size=function(){return this.nodes.length},t.prototype.clone=function(){var e;return(e=new t).nodes=this.nodes.slice(0),e},t.prototype.toArray=function(){return this.nodes.slice(0)},t.prototype.insert=t.prototype.push,t.prototype.top=t.prototype.peek,t.prototype.front=t.prototype.peek,t.prototype.has=t.prototype.contains,t.prototype.copy=t.prototype.clone,t}(),t.exports=e}).call(commonjsGlobal)}(heap$1);var heap=heap$1.exports,Heap=heap;class Cluster{constructor(){this.children=[],this.height=0,this.size=1,this.index=-1,this.isLeaf=!1}cut(t){if("number"!=typeof t)throw new TypeError("threshold must be a number");if(t<0)throw new RangeError("threshold must be a positive number");let e=[this];const n=[];for(;e.length>0;){const s=e.shift();t>=s.height?n.push(s):e=e.concat(s.children)}return n}group(t){if(!Number.isInteger(t)||t<1)throw new RangeError("groups must be a positive integer");const e=new Heap(((t,e)=>e.height-t.height));for(e.push(this);e.size()<t;){const t=e.pop();if(0===t.children.length)break;t.children.forEach((t=>e.push(t)))}const n=new Cluster;return n.children=e.toArray(),n.height=this.height,n}traverse(t){!function t(e,n){if(n(e),e.children)for(const s of e.children)t(s,n)}(this,t)}indices(){const t=[];return this.traverse((e=>{e.isLeaf&&t.push(e.index)})),t}}function singleLink(t,e){return Math.min(t,e)}function completeLink(t,e){return Math.max(t,e)}function averageLink(t,e,n,s,i){return s/(s+i)*t+i/(s+i)*e}function weightedAverageLink(t,e){return(t+e)/2}function centroidLink(t,e,n,s,i){return s/(s+i)*t+i/(s+i)*e+-s*i/(s+i)**2*n}function medianLink(t,e,n){return t/2+e/2-n/4}function wardLink(t,e,n,s,i,o){return(s+o)/(s+i+o)*t+(i+o)/(s+i+o)*e+-o/(s+i+o)*n}function wardLink2(t,e,n,s,i,o){const a=(s+o)/(s+i+o),l=(i+o)/(s+i+o),r=-o/(s+i+o);return Math.sqrt(a*t*t+l*e*e+r*n*n)}function agnes(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{distanceFunction:n=euclidean,method:s="complete",isDistanceMatrix:i=!1}=e;let o;i||(t=distanceMatrix(t,n));let a=new Matrix(t);const l=a.rows;if("string"==typeof s)switch(s.toLowerCase()){case"single":o=singleLink;break;case"complete":o=completeLink;break;case"average":case"upgma":o=averageLink;break;case"wpgma":o=weightedAverageLink;break;case"centroid":case"upgmc":o=centroidLink;break;case"median":case"wpgmc":o=medianLink;break;case"ward":o=wardLink;break;case"ward2":o=wardLink2;break;default:throw new RangeError(`unknown clustering method: ${s}`)}else if("function"!=typeof s)throw new TypeError("method must be a string or function");let r=[];for(let t=0;t<l;t++){const e=new Cluster;e.isLeaf=!0,e.index=t,r.push(e)}for(let t=0;t<l-1;t++){const[t,e,n]=getSmallestDistance(a),s=r[t],i=r[e],l=new Cluster;l.size=s.size+i.size,l.children.push(s,i),l.height=n;const m=[l],g=new Matrix(a.rows-1,a.rows-1),u=n=>getPreviousIndex(n,Math.min(t,e),Math.max(t,e));for(let l=1;l<g.rows;l++){const c=u(l),C=r[c];m.push(C);for(let r=0;r<l;r++)if(0===r){const m=o(a.get(t,c),a.get(c,e),n,s.size,i.size,C.size);g.set(l,r,m),g.set(r,l,m)}else{const t=a.get(c,u(r));g.set(l,r,t),g.set(r,l,t)}}r=m,a=g}return r[0]}function getSmallestDistance(t){let e=1/0,n=0,s=0;for(let i=1;i<t.rows;i++)for(let o=0;o<i;o++)t.get(i,o)<e&&(e=t.get(i,o),n=i,s=o);return[n,s,e]}function getPreviousIndex(t,e,n){return(t-=1)>=e&&t++,t>=n&&t++,t}const nucleusMap={h:"1H",c:"13C"};function getNuclei(t){return Object.values(t).map((t=>nucleusMap[t.toLowerCase()]))}async function getPredictions(t,e,n,s,i){let o;if(i?.[t])o=i[t];else if(s){const i=s[t];o=i?await i(e,n[t]):void 0}return o}function checkFromTo(t){if(!t.from||!t.to)throw new Error("options from and to are mandatory")}async function predict2D(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};checkFromTo(e),t.addImplicitHydrogens();let{from:n,to:s,diaIDs:i,minLength:o=0,maxLength:a,predictOptions:l={},predictions:r,predictor:m,joinDistance:g={H:.05,C:.5},includeDiagonal:u=!1}=e;const c=getPathsInfo(t,{fromLabel:n,toLabel:s,minLength:o,maxLength:a}),C=i?groupDiastereotopicAtomIDs(i,t):getGroupedDiastereotopicAtomIDs(t);let f=[];for(let t of C)f.push({...t,pathInfo:JSON.parse(JSON.stringify(c[t.atoms[0]]))});const h=await getPredictions(n,t,l,m,r),p=n===s?h:await getPredictions(s,t,l,m,r);if(!h||!p)throw new Error("predictions are not availaible");const d={x:h,y:p},y={x:{},y:{}};for(const t in y)for(const e of d[t].joinedSignals){if(!e.diaIDs)throw new Error("Signal has not diaIDs");y[t][e.diaIDs[0]]=e}let H={};for(const t of f){const e=t.pathInfo;if(e.paths.length<1)continue;if(!y.x[e.oclID])continue;const n=e.paths;for(const t of n){if(!y.y[c[t.to].oclID])continue;let n={x:e,y:c[t.to]};const s=`${n.x.oclID}-${n.y.oclID}`;if(s===`${e.oclID}-${e.oclID}`||H[s])continue;let i={id:v4(),z:100},o={id:v4(),x:{},y:{}};for(let t in n){let e=n[t].oclID;i[t]=y[t][e].delta,o[t].delta=y[t][e].delta,o[t].diaIDs=[e],o[t].atoms=y[t][e].atoms}o.peaks=[i],H[s]=o}}u&&addSelftCorrelation(H,{paths:c,signalsByDiaID:y});const v=Object.values(H),b=createZones(v,{joinDistance:g,from:n,to:s});return{molfile:t.toMolfile(),diaIDs:d.x.diaIDs,nuclei:getNuclei({from:n,to:s}),joinedSignals:v,signals:splitSignals(v),zones:b,molecule:t}}function splitSignals(t){let e=[];for(const n of t)for(const t of n.x.atoms||[])for(const s of n.y.atoms||[]){let i=JSON.parse(JSON.stringify(n));i.x.atoms=[t],i.y.atoms=[s],e.push(i)}return setIDs(e)}function addSelftCorrelation(t,e){const{paths:n=[],signalsByDiaID:s}=e;for(const e of n){if(e.paths.length<1)continue;let n=e.oclID;if(!s.x[n])continue;if(t[`${n}-${n}`])continue;let i={x:{},y:{}},o={z:1};for(let t of["x","y"])o[t]=s[t][n].delta,i[t].delta=s[t][n].delta,i[t].diaIDs=[n],i[t].atoms=s[t][n].atoms;i.peaks=[o],t[`${e.oclID}-${e.oclID}`]=i}}function createZones(t,e){if(t.length<1)return[];const{joinDistance:n,from:s,to:i}=e,o=new Matrix(t.map((t=>[t.x.delta,t.y.delta]))),a=o.minColumn(0),l=o.maxColumn(0),r=o.minColumn(1),m=o.maxColumn(1);o.mulColumn(0,1/(l-a)),o.mulColumn(1,1/(m-r));const g=Math.sqrt(Math.pow(n[s]/(l-a),2)+Math.pow(n[i]/(m-r),2));const u=splitClusters([agnes(o.to2DArray(),{method:"centroid"})],g),c=[];for(const e of u){const o=[];e.isLeaf&&o.push(t[e.index]);for(const n of e.children)for(const e of n.indices())o.push(t[e]);c.push({id:v4(),...fromTo$1(o,{joinDistance:n,from:s,to:i}),signals:o})}return c}function fromTo$1(t,e){const{joinDistance:n,from:s,to:i}=e;let o=Number.MAX_SAFE_INTEGER,a=Number.MAX_SAFE_INTEGER,l=Number.MIN_SAFE_INTEGER,r=Number.MIN_SAFE_INTEGER;for(const e of t)e.x.delta<o&&(o=e.x.delta),e.x.delta>l&&(l=e.x.delta),e.y.delta<a&&(a=e.y.delta),e.y.delta>r&&(r=e.y.delta);return{x:{from:o-n[s],to:l+n[s]},y:{from:a-n[i],to:r+n[i]}}}function splitClusters(t,e){let n=t.length;for(let n=0;n<t.length;n++){const s=t[n];s.height>e&&(t.push(...s.children),t.splice(n--,1))}return t.length<n?splitClusters(t,e):t}async function predictCOSY(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{minLength:n=2,maxLength:s=3,predictions:i,predictor:o={H:predictProton},predictOptions:a,joinDistance:l={H:.05,C:.5},includeDiagonal:r=!0}=e;return predict2D(t,{from:"H",to:"H",predictor:o,minLength:n,maxLength:s,joinDistance:l,predictions:i,includeDiagonal:r,predictOptions:a})}async function predictHSQC(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{minLength:n=1,maxLength:s=1,predictor:i={H:predictProton,C:predictCarbon},predictions:o,joinDistance:a={H:.05,C:.5},predictOptions:l}=e;return predict2D(t,{from:"H",to:"C",predictor:i,minLength:n,maxLength:s,predictions:o,predictOptions:l,joinDistance:a})}async function predictHMBC(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{minLength:n=2,maxLength:s=3,predictor:i={H:predictProton,C:predictCarbon},predictOptions:o,predictions:a,joinDistance:l={H:.05,C:.5}}=e;return predict2D(t,{from:"H",to:"C",predictor:i,minLength:n,maxLength:s,predictions:a,predictOptions:o,joinDistance:l})}async function predictAll(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{from:n="H",to:s="C",predictor:i={H:predictProton,C:predictCarbon},predictions:o,joinDistance:a={H:.05,C:.5},predictOptions:l={}}=e;const r=getDiastereotopicAtomIDs(t),m=await getPredictions(n,t,l,i,o),g=await getPredictions(s,t,l,i,o);if(!m||!g)throw new Error("predictions are not availaible");o={H:m,C:g};const{molfile:u}=m,c={proton:o.H,carbon:o.C};c.cosy=await predictCOSY(t,{predictions:o,joinDistance:a}),c.hsqc=await predictHSQC(t,{predictions:o,joinDistance:a}),c.hmbc=await predictHMBC(t,{predictions:o,joinDistance:a});for(const t in c)delete c[t].molfile,delete c[t].diaIDs;return{molfile:u,diaIDs:r,spectra:c}}function signals2DToZ(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{from:n=-1,to:s=12,nbPoints:i=512,width:o=.02,factor:a=3}=e;const l=t.reduce(((t,e)=>{let{x:n,y:s}=e;return t.x.push(n.delta),t.y.push(s.delta),t.z.push(1e6),t}),{x:[],y:[],z:[]});return o=ensureXYNumber(o),generateSpectrum2D(mergeClosePeaks(l),{generator:{from:ensureXYNumber(n),to:ensureXYNumber(s),nbPoints:ensureXYNumber(i)},peaks:{width:o,factor:a}})}function ensureXYNumber(t){return"object"!=typeof t?{x:t,y:t}:{...t}}function mergeClosePeaks(t){let e=JSON.parse(JSON.stringify(t));for(let t=0;t<e.x.length;t++)for(let n=t+1;n<e.x.length;n++)e.x[t]===e.x[n]&&e.y[t]===e.y[n]&&(e.z[t]+=e.z[n],e.x.splice(n,1),e.y.splice(n,1),e.z.splice(n,1),n--);return e}const defOptions={threshold:0,out:"assignment"};var src$2=function(t,e){const n=Object.assign({},defOptions,e);var s,i;if("number"==typeof t[0])s=fullClusterGeneratorVector(t);else if("object"==typeof t[0]){for(var o=t.length,a=new Array(o*(o+1)/2),l=0,r=0;r<o;r++)for(var m=r;m<o;m++)t[r][m]>n.threshold?a[l++]=1:a[l++]=0;s=fullClusterGeneratorVector(a)}if("indexes"===n.out||"values"===n.out){var g=new Array(s.length);for(r=0;r<s.length;r++)for(g[r]=[],m=0;m<s[r].length;m++)0!=s[r][m]&&g[r].push(m);if("values"===n.out){var u=new Array(g.length);for(r=0;r<g.length;r++)for(u[r]=new Array(g[r].length),m=0;m<g[r].length;m++)for(u[r][m]=new Array(g[r].length),i=0;i<g[r].length;i++)u[r][m][i]=t[g[r][m]][g[r][i]];return u}return g}return s};function fullClusterGeneratorVector(t){var e=Math.sqrt(2*t.length+.25)-.5,n=[],s=new Array(e),i=e,o=0,a=[];for(o=e-1;o>=0;o--)s[o]=1;for(var l=-1,r=[];i>0;){if(0===r.length){for(a=new Array(e),o=0;o<e;o++)a[o]=0;for(n.push(a),l=0;0==s[l];l++);}else l=r.splice(0,1);a[l]=1,s[l]=0,i--;var m=new Array(e);for(o=0;o<e;o++){var g=Math.max(l,o),u=Math.min(l,o);m[o]=t[u*(2*e-u-1)/2+g],1==m[o]&&1==s[o]&&0==a[o]&&(r.push(o),a[o]=1)}}return n}var simpleClustering=src$2;function checkForMandatory$1(t){for(const e of t){if(!e.js)throw new Error("there is not js");if(!e.atoms)throw new Error("there is not atoms");for(const t of e.js)if(!t.atoms)throw new Error("there is not atoms")}}function signalsToSpinSystem(t){checkForMandatory$1(t);const e=t.length,n=new Array(e),s=new Array(e),i=Matrix.zeros(e,e),o={};for(let i=0;i<e;i++){s[i]=2,n[i]=t[i].delta;o[t[i].atoms[0]]=i}for(let n=0;n<e;n++){let{atoms:e,js:s}=t[n];const a=e[0];for(const t of s){let{coupling:e,atoms:n}=t;const s=n[0];i.set(o[a],o[s],e),i.set(o[s],o[a],e)}}const a=Matrix.ones(i.rows,i.rows);for(let t=0;t<i.rows;t++)for(let e=t;e<i.columns;e++)0===i.get(t,e)&&(a.set(t,e,0),a.set(e,t,0));return{clusters:simpleClustering(a.to2DArray(),{out:"indexes"}),couplingConstants:i,chemicalShifts:n,multiplicity:s,connectivity:a}}var binarySearch=function(t,e,n,s,i){var o,a;if(void 0===s)s=0;else if((s|=0)<0||s>=t.length)throw new RangeError("invalid lower bound");if(void 0===i)i=t.length-1;else if((i|=0)<s||i>=t.length)throw new RangeError("invalid upper bound");for(;s<=i;)if((a=+n(t[o=s+(i-s>>>1)],e,o,t))<0)s=o+1;else{if(!(a>0))return o;i=o-1}return~s},binarySearch$1=binarySearch,numSort={};function assertNumber(t){if("number"!=typeof t)throw new TypeError("Expected a number")}var ascending=numSort.ascending=(t,e)=>(assertNumber(t),assertNumber(e),Number.isNaN(t)?-1:Number.isNaN(e)?1:t-e);numSort.descending=(t,e)=>(assertNumber(t),assertNumber(e),Number.isNaN(t)?1:Number.isNaN(e)?-1:e-t);const largestPrime=2147483647,primeNumbers=[largestPrime,5,11,23,47,97,197,397,797,1597,3203,6421,12853,25717,51437,102877,205759,411527,823117,1646237,3292489,6584983,13169977,26339969,52679969,105359939,210719881,421439783,842879579,1685759167,433,877,1759,3527,7057,14143,28289,56591,113189,226379,452759,905551,1811107,3622219,7244441,14488931,28977863,57955739,115911563,231823147,463646329,927292699,1854585413,953,1907,3821,7643,15287,30577,61169,122347,244703,489407,978821,1957651,3915341,7830701,15661423,31322867,62645741,125291483,250582987,501165979,1002331963,2004663929,1039,2081,4177,8363,16729,33461,66923,133853,267713,535481,1070981,2141977,4283963,8567929,17135863,34271747,68543509,137087021,274174111,548348231,1096696463,31,67,137,277,557,1117,2237,4481,8963,17929,35863,71741,143483,286973,573953,1147921,2295859,4591721,9183457,18366923,36733847,73467739,146935499,293871013,587742049,1175484103,599,1201,2411,4831,9677,19373,38747,77509,155027,310081,620171,1240361,2480729,4961459,9922933,19845871,39691759,79383533,158767069,317534141,635068283,1270136683,311,631,1277,2557,5119,10243,20507,41017,82037,164089,328213,656429,1312867,2625761,5251529,10503061,21006137,42012281,84024581,168049163,336098327,672196673,1344393353,3,7,17,37,79,163,331,673,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,43,89,179,359,719,1439,2879,5779,11579,23159,46327,92657,185323,370661,741337,1482707,2965421,5930887,11861791,23723597,47447201,94894427,189788857,379577741,759155483,1518310967,379,761,1523,3049,6101,12203,24407,48817,97649,195311,390647,781301,1562611,3125257,6250537,12501169,25002389,50004791,100009607,200019221,400038451,800076929,1600153859,13,29,59,127,257,521,1049,2099,4201,8419,16843,33703,67409,134837,269683,539389,1078787,2157587,4315183,8630387,17260781,34521589,69043189,138086407,276172823,552345671,1104691373,19,41,83,167,337,677,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,53,107,223,449,907,1823,3659,7321,14653,29311,58631,117269,234539,469099,938207,1876417,3752839,7505681,15011389,30022781,60045577,120091177,240182359,480364727,960729461,1921458943];function nextPrime(t){let e=binarySearch$1(primeNumbers,t,ascending);return e<0&&(e=~e),primeNumbers[e]}primeNumbers.sort(ascending);const FREE=0,FULL=1,REMOVED=2,defaultInitialCapacity=150,defaultMinLoadFactor=1/6,defaultMaxLoadFactor=2/3;class HashTable{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if(t instanceof HashTable)return this.table=t.table.slice(),this.values=t.values.slice(),this.state=t.state.slice(),this.minLoadFactor=t.minLoadFactor,this.maxLoadFactor=t.maxLoadFactor,this.distinct=t.distinct,this.freeEntries=t.freeEntries,this.lowWaterMark=t.lowWaterMark,void(this.highWaterMark=t.maxLoadFactor);const e=void 0===t.initialCapacity?defaultInitialCapacity:t.initialCapacity;if(e<0)throw new RangeError(`initial capacity must not be less than zero: ${e}`);const n=void 0===t.minLoadFactor?defaultMinLoadFactor:t.minLoadFactor,s=void 0===t.maxLoadFactor?defaultMaxLoadFactor:t.maxLoadFactor;if(n<0||n>=1)throw new RangeError(`invalid minLoadFactor: ${n}`);if(s<=0||s>=1)throw new RangeError(`invalid maxLoadFactor: ${s}`);if(n>=s)throw new RangeError(`minLoadFactor (${n}) must be smaller than maxLoadFactor (${s})`);let i=e;i=i/s|0,i=nextPrime(i),0===i&&(i=1),this.table=newArray(i),this.values=newArray(i),this.state=newArray(i),this.minLoadFactor=n,this.maxLoadFactor=i===largestPrime?1:s,this.distinct=0,this.freeEntries=i,this.lowWaterMark=0,this.highWaterMark=chooseHighWaterMark(i,this.maxLoadFactor)}clone(){return new HashTable(this)}get size(){return this.distinct}get(t){const e=this.indexOfKey(t);return e<0?0:this.values[e]}set(t,e){let n=this.indexOfInsertion(t);if(n<0)return n=-n-1,this.values[n]=e,!1;if(this.distinct>this.highWaterMark){const n=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);return this.rehash(n),this.set(t,e)}if(this.table[n]=t,this.values[n]=e,this.state[n]===FREE&&this.freeEntries--,this.state[n]=FULL,this.distinct++,this.freeEntries<1){const t=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);this.rehash(t)}return!0}remove(t,e){const n=this.indexOfKey(t);return!(n<0)&&(this.state[n]=REMOVED,this.distinct--,e||this.maybeShrinkCapacity(),!0)}delete(t,e){const n=this.indexOfKey(t);return!(n<0)&&(this.state[n]=FREE,this.distinct--,e||this.maybeShrinkCapacity(),!0)}maybeShrinkCapacity(){if(this.distinct<this.lowWaterMark){const t=chooseShrinkCapacity(this.distinct,this.minLoadFactor,this.maxLoadFactor);this.rehash(t)}}containsKey(t){return this.indexOfKey(t)>=0}indexOfKey(t){const e=this.table,n=this.state,s=this.table.length,i=2147483647&t;let o=i%s,a=i%(s-2);for(0===a&&(a=1);n[o]!==FREE&&(n[o]===REMOVED||e[o]!==t);)o-=a,o<0&&(o+=s);return n[o]===FREE?-1:o}containsValue(t){return this.indexOfValue(t)>=0}indexOfValue(t){const e=this.values,n=this.state;for(var s=0;s<n.length;s++)if(n[s]===FULL&&e[s]===t)return s;return-1}indexOfInsertion(t){const e=this.table,n=this.state,s=e.length,i=2147483647&t;let o=i%s,a=i%(s-2);for(0===a&&(a=1);n[o]===FULL&&e[o]!==t;)o-=a,o<0&&(o+=s);if(n[o]===REMOVED){const i=o;for(;n[o]!==FREE&&(n[o]===REMOVED||e[o]!==t);)o-=a,o<0&&(o+=s);n[o]===FREE&&(o=i)}return n[o]===FULL?-o-1:o}ensureCapacity(t){if(this.table.length<t){const e=nextPrime(t);this.rehash(e)}}rehash(t){const e=this.table.length;if(t<=this.distinct)throw new Error("Unexpected");const n=this.table,s=this.values,i=this.state,o=newArray(t),a=newArray(t),l=newArray(t);this.lowWaterMark=chooseLowWaterMark(t,this.minLoadFactor),this.highWaterMark=chooseHighWaterMark(t,this.maxLoadFactor),this.table=o,this.values=a,this.state=l,this.freeEntries=t-this.distinct;for(var r=0;r<e;r++)if(i[r]===FULL){var m=n[r],g=this.indexOfInsertion(m);o[g]=m,a[g]=s[r],l[g]=FULL}}forEachKey(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.table[e]))return!1;return!0}forEachValue(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.values[e]))return!1;return!0}forEachPair(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.table[e],this.values[e]))return!1;return!0}}function chooseLowWaterMark(t,e){return t*e|0}function chooseHighWaterMark(t,e){return Math.min(t-2,t*e|0)}function chooseGrowCapacity(t,e,n){return nextPrime(Math.max(t+1,4*t/(3*e+n)|0))}function chooseShrinkCapacity(t,e,n){return nextPrime(Math.max(t+1,4*t/(e+3*n)|0))}function newArray(t){return Array(t).fill(0)}class SparseMatrix{constructor(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(t instanceof SparseMatrix){const e=t;this._init(e.rows,e.columns,e.elements.clone(),e.threshold)}else if(Array.isArray(t)){const s=t;t=s.length,n=e||{},e=s[0].length,this._init(t,e,new HashTable(n),n.threshold);for(let n=0;n<t;n++)for(let t=0;t<e;t++){let i=s[n][t];this.threshold&&Math.abs(i)<this.threshold&&(i=0),0!==i&&this.elements.set(n*e+t,s[n][t])}}else this._init(t,e,new HashTable(n),n.threshold)}_init(t,e,n,s){this.rows=t,this.columns=e,this.elements=n,this.threshold=s||0}static eye(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1,e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:t;const n=Math.min(t,e),s=new SparseMatrix(t,e,{initialCapacity:n});for(let t=0;t<n;t++)s.set(t,t,1);return s}clone(){return new SparseMatrix(this)}to2DArray(){const t=new Array(this.rows);for(let e=0;e<this.rows;e++){t[e]=new Array(this.columns);for(let n=0;n<this.columns;n++)t[e][n]=this.get(e,n)}return t}isSquare(){return this.rows===this.columns}isSymmetric(){if(!this.isSquare())return!1;let t=!0;return this.forEachNonZero(((e,n,s)=>this.get(n,e)!==s?(t=!1,!1):s)),t}bandWidth(){let t=this.columns,e=-1;return this.forEachNonZero(((n,s,i)=>{let o=n-s;return t=Math.min(t,o),e=Math.max(e,o),i})),e-t}isBanded(t){return this.bandWidth()<=t}get cardinality(){return this.elements.size}get size(){return this.rows*this.columns}get(t,e){return this.elements.get(t*this.columns+e)}set(t,e,n){return this.threshold&&Math.abs(n)<this.threshold&&(n=0),0===n?this.elements.remove(t*this.columns+e):this.elements.set(t*this.columns+e,n),this}mmul(t){this.columns!==t.rows&&console.warn("Number of columns of left matrix are not equal to number of rows of right matrix.");const e=this.rows,n=t.columns,s=new SparseMatrix(e,n);return this.forEachNonZero(((e,n,i)=>(t.forEachNonZero(((t,o,a)=>(n===t&&s.set(e,o,s.get(e,o)+i*a),a))),i))),s}kroneckerProduct(t){const e=this.rows,n=this.columns,s=t.rows,i=t.columns,o=new SparseMatrix(e*s,n*i,{initialCapacity:this.cardinality*t.cardinality});return this.forEachNonZero(((e,n,a)=>(t.forEachNonZero(((t,l,r)=>(o.set(s*e+t,i*n+l,a*r),r))),a))),o}forEachNonZero(t){return this.elements.forEachPair(((e,n)=>{const s=e/this.columns|0,i=e%this.columns;let o=t(s,i,n);return!1!==o&&(this.threshold&&Math.abs(o)<this.threshold&&(o=0),o!==n&&(0===o?this.elements.remove(e,!0):this.elements.set(e,o)),!0)})),this.elements.maybeShrinkCapacity(),this}getNonZeros(){const t=this.cardinality,e=new Array(t),n=new Array(t),s=new Array(t);let i=0;return this.forEachNonZero(((t,o,a)=>(e[i]=t,n[i]=o,s[i]=a,i++,a))),{rows:e,columns:n,values:s}}setThreshold(t){return 0!==t&&t!==this.threshold&&(this.threshold=t,this.forEachNonZero(((t,e,n)=>n))),this}transpose(){let t=new SparseMatrix(this.columns,this.rows,{initialCapacity:this.cardinality});return this.forEachNonZero(((e,n,s)=>(t.set(n,e,s),s))),t}isEmpty(){return 0===this.rows||0===this.columns}}SparseMatrix.prototype.klass="Matrix",SparseMatrix.identity=SparseMatrix.eye,SparseMatrix.prototype.tensorProduct=SparseMatrix.prototype.kroneckerProduct;let inplaceOperator="\n(function %name%(value) {\n    if (typeof value === 'number') return this.%name%S(value);\n    return this.%name%M(value);\n})\n",inplaceOperatorScalar="\n(function %name%S(value) {\n    this.forEachNonZero((i, j, v) => v %op% value);\n    return this;\n})\n",inplaceOperatorMatrix="\n(function %name%M(matrix) {\n    matrix.forEachNonZero((i, j, v) => {\n        this.set(i, j, this.get(i, j) %op% v);\n        return v;\n    });\n    return this;\n})\n",staticOperator="\n(function %name%(matrix, value) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%(value);\n})\n",inplaceMethod="\n(function %name%() {\n    this.forEachNonZero((i, j, v) => %method%(v));\n    return this;\n})\n",staticMethod="\n(function %name%(matrix) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%();\n})\n";const operators=[["+","add"],["-","sub","subtract"],["*","mul","multiply"],["/","div","divide"],["%","mod","modulus"],["&","and"],["|","or"],["^","xor"],["<<","leftShift"],[">>","signPropagatingRightShift"],[">>>","rightShift","zeroFillRightShift"]];for(const operator of operators)for(let i=1;i<operator.length;i++)SparseMatrix.prototype[operator[i]]=eval(fillTemplateFunction(inplaceOperator,{name:operator[i],op:operator[0]})),SparseMatrix.prototype[`${operator[i]}S`]=eval(fillTemplateFunction(inplaceOperatorScalar,{name:`${operator[i]}S`,op:operator[0]})),SparseMatrix.prototype[`${operator[i]}M`]=eval(fillTemplateFunction(inplaceOperatorMatrix,{name:`${operator[i]}M`,op:operator[0]})),SparseMatrix[operator[i]]=eval(fillTemplateFunction(staticOperator,{name:operator[i]}));let methods=[["~","not"]];["abs","acos","acosh","asin","asinh","atan","atanh","cbrt","ceil","clz32","cos","cosh","exp","expm1","floor","fround","log","log1p","log10","log2","round","sign","sin","sinh","sqrt","tan","tanh","trunc"].forEach((function(t){methods.push([`Math.${t}`,t])}));for(const method of methods)for(let i=1;i<method.length;i++)SparseMatrix.prototype[method[i]]=eval(fillTemplateFunction(inplaceMethod,{name:method[i],method:method[0]})),SparseMatrix[method[i]]=eval(fillTemplateFunction(staticMethod,{name:method[i]}));function fillTemplateFunction(t,e){for(const n in e)t=t.replace(new RegExp(`%${n}%`,"g"),e[n]);return t}function createPauli(t){const e=(t-1)/2,n=new Array(t),s=new Array(t);for(let i=0;i<t;i++)n[i]=t-1-i-e,s[i]=Math.sqrt(e*(e+1)-n[i]*(n[i]+1));const i=diag(s,1,t,t);for(let i=0;i<t;i++)s[i]=Math.sqrt(e*(e+1)-n[i]*(n[i]-1));const o=diag(s,-1,t,t);return{x:i.clone().add(o).mul(.5),y:o.clone().mul(-1).add(i).mul(-.5),z:diag(n,0,t,t),m:o,p:i}}function diag(t,e,n,s){const i=new SparseMatrix(n,s,{initialCapacity:20});for(let o=0;o<t.length;o++)o-e>=0&&o-e<n&&o<s&&i.set(o-e,o,t[o]);return i}const pauli2=createPauli(2);function getPauliMatrix(t){return 2===t?pauli2:createPauli(t)}const smallValue=.01;function simulateXYPeaks(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{lineWidth:n=1,maxClusterSize:s=8,frequency:i=400}=e;const o=t.chemicalShifts.slice();for(let t=0;t<o.length;t++)o[t]=o[t]*i;const a=t.multiplicity,l=[];for(const e of t.clusters){let r=e.map((t=>t<0?-t-1:t)),m=1,g=0,u=[],c=[];if(e.length>s){let n=0;for(;e[n++]<0;);n=e[n-1],u.push(-o[n]);for(let s=0;s<e.length;s++)if(e[s]<0){let e=t.couplingConstants.get(n,r[s])/2,i=u.length;for(let t=0;t<i;t++)u.push(u[t]+e),u[t]-=e}u.sort(((t,e)=>t-e)),g=u.length,m=1;for(let t=0;t<g;t++)c.push(1)}else{const n=getHamiltonian(o,t.couplingConstants,a,t.connectivity,r),s=n.rows,i=new EigenvalueDecomposition(n),l=i.eigenvectorMatrix,C=i.realEigenvalues,f=new SparseMatrix(s,s),h=e.length;m=0;for(let t=0;t<h;t++){const n=getPauliMatrix(a[r[t]]);let s=1;for(let e=0;e<t;e++)s*=a[r[e]];const i=SparseMatrix.eye(s);s=1;for(let e=t+1;e<h;e++)s*=a[r[e]];const o=SparseMatrix.eye(s),l=i.kroneckerProduct(n.m).kroneckerProduct(o);e[t]>=0?(f.add(l.mul(e[t]+1)),m++):f.add(l.mul(e[t]))}let p=Matrix.zeros(s,s);f.forEachNonZero(((t,e,n)=>{if(n>0)for(let n=0;n<l.columns;n++){let s=l.get(e,n);0!==s&&p.set(t,n,p.get(t,n)+s)}return n}));let d=p.clone();f.forEachNonZero(((t,e,n)=>{if(n<0)for(let n=0;n<l.columns;n++){let s=l.get(e,n);0!==s&&d.set(t,n,d.get(t,n)+s)}return n}));const y=l.transpose();p=y.mmul(p);triuTimesAbs(new SparseMatrix(p.to2DArray(),{threshold:smallValue}),smallValue),d=y.mmul(d);const H=new SparseMatrix(d.to2DArray(),{threshold:smallValue});H.forEachNonZero(((t,e,n)=>n)),triuTimesAbs(H,smallValue),H.forEachNonZero(((t,e,n)=>{let s=p.get(t,e);s=Math.min(Math.abs(s),Math.abs(n)),s*=s,g+=s;let i=C[t]-C[e],o=binarySearch$1(u,i,((t,e)=>t-e));o<0?(u.splice(-1-o,0,i),c.splice(-1-o,0,s)):c[o]+=s}))}const C=u.length;if(C>0){m/=g;const t=n/64;let e=u[0],s=c[0],o=1;for(let n=1;n<C;n++)Math.abs(u[n]-e/o)<t?(s+=c[n],e+=u[n],o++):(l.push({x:-e/o/i,y:s*m}),e=u[n],s=c[n],o=1);l.push({x:-e/o/i,y:s*m})}}return l.filter((t=>t.x<1e3))}function triuTimesAbs(t,e){t.forEachNonZero(((t,n,s)=>t>n||Math.abs(s)<=e?0:s))}function getHamiltonian(t,e,n,s,i){let o=1;for(const t of i)o*=n[t];const a=new SparseMatrix(o,o);for(let o=0;o<i.length;o++){let l=i[o];const r=getPauliMatrix(n[l]);let m,g,u=1;for(let t=0;t<o;t++)u*=n[i[t]];m=SparseMatrix.eye(u),u=1;for(let t=o+1;t<i.length;t++)u*=n[i[t]];g=SparseMatrix.eye(u);const c=t[l],C=m.kroneckerProduct(r.z).kroneckerProduct(g);a.add(C.mul(c));for(let t=0;t<i.length;t++){const o=i[t];if(1===s.get(l,o)){const s=getPauliMatrix(n[o]);let u,c,C=1;for(let e=0;e<t;e++)C*=n[i[e]];u=SparseMatrix.eye(C),C=1;for(let e=t+1;e<i.length;e++)C*=n[i[e]];c=SparseMatrix.eye(C);const f=m.kroneckerProduct(r.x).kroneckerProduct(g).mmul(u.kroneckerProduct(s.x).kroneckerProduct(c));f.add(m.kroneckerProduct(r.y).kroneckerProduct(g).mul(-1).mmul(u.kroneckerProduct(s.y).kroneckerProduct(c))),f.add(m.kroneckerProduct(r.z).kroneckerProduct(g).mmul(u.kroneckerProduct(s.z).kroneckerProduct(c))),a.add(f.mul(e.get(l,o)/2))}}}return a}function simulate1D(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{lineWidth:n=1,frequency:s=400,from:i=0,to:o=10,nbPoints:a=1024,shape:l={kind:"gaussian"}}=e,r=n/s;return generateSpectrum(simulateXYPeaks(t,e),{generator:{from:i,to:o,nbPoints:a},peakOptions:{shape:l,width:r}})}function splitSpinSystem(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{chemicalShifts:n,couplingConstants:s,connectivity:i}=t,{frequency:o=400,maxClusterSize:a=8}=e,l=agnes(calculateBetas(n,s,o),{method:"single",isDistanceMatrix:!0}),r=[],m=n.length;splitCluster(l,r,{maxClusterSize:a,force:!1,nSpins:m,connectivity:i});let g=mergeClusters(r,a),u=g.length,c=new Array(u);for(let t=0;t<u;t++){c[t]=[];for(let e=0;e<m;e++){let n=g[t][e];0!==n&&c[t].push(n<0?-(e+1):e)}}return c}function splitCluster(t,e,n){let{maxClusterSize:s,force:i,nSpins:o,connectivity:a}=n;if(!i&&t.size<=s)e.push(getMembers(t.indices(),o));else for(let n of t.children)if(n.size<=s){let t=getMembers(n.indices(),o),i=0;for(let e=0;e<o;e++)if(1===t[e]){for(let n=0;n<o;n++)1===a.get(e,n)&&0===t[n]&&(t[n]=-1,i++);i++}i<=s?e.push(t):n.index<0?splitCluster(n,e,{maxClusterSize:s,force:!0,nSpins:o,connectivity:a}):(t[n.index]=2,e.push(t))}else splitCluster(n,e,{maxClusterSize:s,force:!1,nSpins:o,connectivity:a})}function calculateBetas(t,e,n){let s=e.rows,i=e.columns,o=Matrix.zeros(s,s);for(let a=0;a<s;a++)for(let s=a;s<i;s++){let i=e.get(a,s);if(t[a]-t[s]!=0){let e=1-Math.abs(i/((t[a]-t[s])*n));o.set(a,s,e),o.set(s,a,e)}else a!==s&&0===i&&(o.set(a,s,1),o.set(s,a,1))}return o.to2DArray()}function mergeClusters(t,e){for(let n=t.length-1;n>=0;n--){let s=t[n],i=s.length,o=0;for(;o<i&&-1!==s[o++];);if(!(o>=i))for(let o=t.length-1;o>=n+1;o--){let n=t[o],a=0,l=0;for(let t=0;t<i;t++)s[t]*n[t]==-1&&l++,0===s[t]&&0===n[t]||a++;if(l>0&&a<=e){for(let t=0;t<i;t++)1===n[t]?s[t]=1:-1===n[t]&&1!==s[t]&&(s[t]=-1);t.splice(o,1)}}}return t}function getMembers(t,e){let n=new Int16Array(e);for(let e of t)n[e]=1;return n}function checkForMandatory(t){for(const e of t){if(!e.js)throw new Error("There is not js");if(!e.atoms)throw new Error("There is not atoms");for(const t of e.js)if(!t.atoms)throw new Error("There is not atoms")}}function signalsToXY(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};checkForMandatory(t);let{frequency:n=400,shape:s={kind:"gaussian"},from:i=0,to:o=10,lineWidth:a=1,nbPoints:l=16384,maxValue:r=1e8,maxClusterSize:m=8}=e;if(0===t.length)return{x:xSequentialFill({from:i,to:o,size:l}),y:Array.from(new Float64Array(l))};let g=signalsToSpinSystem(t);g.clusters=splitSpinSystem(g,{frequency:n,maxClusterSize:m});let u=simulate1D(g,{frequency:n,from:i,to:o,nbPoints:l,lineWidth:a,shape:s});return r&&(u.y=xRescale(u.y,{max:r})),u}function getFrequency(t,e){const{nucleus:n,frequency:s}=e;return checkExistence$1(t,n),s*gyromagneticRatio[t]/gyromagneticRatio[n]}function checkExistence$1(){let t=[];for(var e=arguments.length,n=new Array(e),s=0;s<e;s++)n[s]=arguments[s];for(const e of n)e in gyromagneticRatio||t.push(e);if(0!==t.length)throw new Error(`${t.join(" , ")} is not supported`)}async function predictAllSpectra(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{simulation:n={oneD:{},twoD:{}},prediction:s={}}=e,i=await predictAll(t,s),{molfile:o,spectra:a}=i,l={proton:{from:0,to:14},carbon:{from:0,to:200},nbPoints:65536,lineWidth:1,...n.oneD||{}},r={from:{x:l.proton.from,y:l.carbon.from},to:{x:l.proton.to,y:l.carbon.to},nbPoints:{x:1024,y:1024},...n.twoD||{}},m=[];for(const t in a)switch(t){case"carbon":case"proton":m.push(get1DSpectrum(a[t],{nbPoints:l.nbPoints,lineWidth:l.lineWidth,...l[t],experiment:t,frequency:n.frequency}));break;case"cosy":case"hsqc":case"hmbc":m.push(get2DSpectrum(a[t],{...r,experiment:t,frequency:n.frequency}))}return{spectra:m,molecules:[{molfile:o}]}}function get2DSpectrum(t,e){const{signals:n,zones:s,nuclei:i}=t,{frequency:o,experiment:a}=e,l=get2DWidth(i),r=calculateFrequency(i,o);return{data:{rr:{...signals2DToZ(n,{...e,width:l,factor:3}),noise:.01}},info:{nucleus:i,originFrequency:r,baseFrequency:r,pulseSequence:a,experiment:"2d"},zones:{values:s}}}function get2DWidth(t){return t[0]===t[1]?.02:{x:.02,y:.2133}}function get1DSpectrum(t,e){const{frequency:n=400,experiment:s}=e,{signals:i,nucleus:o}=t,a=calculateFrequency(o,n),{x:l,y:r}=signalsToXY(i,{...e,frequency:a});return{data:{x:Array.from(l),re:Array.from(r),im:null},info:{nucleus:t.nucleus,dimension:1,isComplex:!1,originFrequency:a,baseFrequency:a,pulseSequence:"prediction",experiment:s,isFt:!0},ranges:{values:t.ranges}}}function calculateFrequency(t,e){return"string"==typeof t?getFrequency(t,{nucleus:"1H",frequency:e}):t[0]===t[1]?`${e},${e}`:`${e},${getFrequency(t[1],{nucleus:t[0],frequency:e})}`}class TreeSet{constructor(t){this.length=0,this.elements=[],this.compatator=t||function(t,e){return t-e}}size(){return this.elements.length}last(){return this.elements[this.length-1]}first(){return this.elements[0]}isEmpty(){return 0===this.size()}pollLast(){return this.length>0?(this.length--,this.elements.splice(this.length,1)):null}pollFirst(){return this.length>0?(this.length--,this.elements.splice(0,1)):null}add(t){let e=this.binarySearch(t);e<0&&(e=-e-1),this.elements.splice(e,0,t),this.length++}binarySearch(t){for(var e=0,n=this.elements.length-1;e<=n;){var s=e+n>>>1,i=this.elements[s],o=this.compatator(i,t);if(o<0)e=s+1;else{if(!(o>0))return s;n=s-1}}return-(e+1)}}var src$1=TreeSet,TreeSet$1=src$1;function createMapPossibleAssignments(t){const{restrictionByCS:e,predictions:n,targets:s,useIntegrationRestriction:i}=t,{tolerance:o,chemicalShiftRestriction:a}=e;let l=Math.abs(o);const r={};for(const t in n){let e=n[t];if(e.error&&(e.error=Math.abs(e.error)),r[t]=[],s)for(const n in s){let o=s[n];const{nbAtoms:m}=e,{integration:g}=o;if(!i||(!(g>0)||m-g<1))if(a&&void 0!==e.delta){let s=l;e.error&&(s=Math.max(s,e.error));const i=o.signals&&o.signals.length>0?o.signals[0].delta:(o.to+o.from)/2;Math.abs(e.delta-i-l)<4*l&&r[t].push(n)}else r[t].push(n)}r[t].push("*")}return r}function partialScore$1(t,e){const{useIntegrationRestriction:n,diaIDPeerPossibleAssignment:s,nbAllowedUnAssigned:i,restrictionByCS:o,predictions:a,targets:l}=e,{useChemicalShiftScore:r}=o;let m=0,g=t.length,u={};for(let e=0;e<t.length;e++){const n=t[e];n&&"*"!==n&&(u[n]||(u[n]=[]),u[n].push(s[e])),"*"===n&&m++}if(m>i)return 0;const c=Object.keys(u);if(0===c.length)return 0;if(n)for(let t of c){let e=u[t],n=0;for(const t of e){n+=a[t].allHydrogens}const{integration:s}=l[t];if(n-s>=.5)return 0}return(r?chemicalShiftScoring(t,e):1)-m/g}function chemicalShiftScoring(t,e){const{tolerance:n}=e.restrictionByCS,{diaIDPeerPossibleAssignment:s,predictions:i,targets:o}=e;let a=0,l=0;for(let e=0;e<t.length;e++){const r=t[e];if(r&&"*"!==r){l++;let t=i[s[e]],m=o[r],g=n;if(t.error&&(g=Math.max(t.error,n)),void 0===t.delta)a+=1;else{const e=m.signals&&m.signals.length>0?m.signals[0].delta:(m.to+m.from)/2;let n=Math.abs(t.delta-e);n<g?a+=1:(n=Math.abs(n-g),a+=-.25/g*n+1)}}}return l>0&&(a/=l),a}function exploreTreeRec(t,e,n,s){const{nSources:i,restrictionByCS:o,timeout:a,timeStart:l,maxSolutions:r,targets:m,predictions:g,lowerBoundScore:u,nbAllowedUnAssigned:c,possibleAssignmentMap:C,useIntegrationRestriction:f,diaIDPeerPossibleAssignment:h}=t;if(Date.now()-l>a)return s;const p=C[h[e]];for(let t of p){n[e]=t;let p=partialScore$1(n,{useIntegrationRestriction:f,diaIDPeerPossibleAssignment:h,nbAllowedUnAssigned:c,restrictionByCS:o,predictions:g,targets:m});0!==p?e===i-1&&p>=u?addSolution$1(s,{predictions:g,partial:n,score:p,maxSolutions:r}):e<i-1&&exploreTreeRec({nSources:i,restrictionByCS:o,timeout:a,timeStart:l,maxSolutions:r,targets:m,predictions:g,lowerBoundScore:u,nbAllowedUnAssigned:c,possibleAssignmentMap:C,useIntegrationRestriction:f,diaIDPeerPossibleAssignment:h},e+1,JSON.parse(JSON.stringify(n)),s):"*"===t&&(n[e]=null)}}function addSolution$1(t,e){let{score:n,maxSolutions:s,partial:i,predictions:o}=e;n/=doubleAssignmentPenalty$1(i,o),t.nSolutions++;let a={assignment:JSON.parse(JSON.stringify(i)),score:n};t.nSolutions>=s?a.score>t.solutions.last().score&&(t.solutions.pollLast(),t.solutions.add(a)):(t.solutions.add(a),t.nSolutions++)}function doubleAssignmentPenalty$1(t,e){let n=Object.keys(e).length-new Set(t).size;return n>0?2*n:1}const comparator$1=(t,e)=>e.score-t.score;async function buildAssignments$1(t){const{restrictionByCS:e={},useIntegrationRestriction:n,timeout:s,minScore:i,nbAllowedUnAssigned:o,maxSolutions:a,targets:l,joinedSignals:r}=t,{tolerance:m=1,useChemicalShiftScore:g=!1,chemicalShiftRestriction:u=!0}=e;let c={solutions:new TreeSet$1(comparator$1),nSolutions:0},C=r.length;const f={};for(let t of r){const e=t.diaIDs[0],n=t.atoms[0];f[e]={...t,diaIDIndex:n,allHydrogens:t.nbAtoms}}const h=createMapPossibleAssignments({restrictionByCS:{tolerance:m,useChemicalShiftScore:g,chemicalShiftRestriction:u},useIntegrationRestriction:n,predictions:f,targets:l}),p=Object.keys(h);let d=fillPartial$1(C);c={solutions:new TreeSet$1(comparator$1),nSolutions:0};exploreTreeRec({nSources:C,restrictionByCS:{tolerance:m,useChemicalShiftScore:g,chemicalShiftRestriction:u},timeout:s,timeStart:Date.now(),targets:l,predictions:f,maxSolutions:a,lowerBoundScore:i,nbAllowedUnAssigned:o,possibleAssignmentMap:h,diaIDPeerPossibleAssignment:p,useIntegrationRestriction:n},0,d,c);const y=[];for(const t of c.solutions.elements){const{assignment:e,score:n}=t,s=JSON.parse(JSON.stringify(l));for(let t=0;t<e.length;t++){let n=s[e[t]];n.diaIDs||(n.diaIDs=[]),e[t]&&n.diaIDs.push(p[t])}y.push({score:n,assignment:Object.values(s)})}return y}function fillPartial$1(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;const n=new Array(t);for(let s=0;s<t;s++)n[s]=e;return n}function checkAtomsAndDiaIDs$1(t){for(const e of t){if(!e.atoms)throw new Error("signal has not atoms property");if(!e.diaIDs)throw new Error("signal has not diaIDs property");if(!e.nbAtoms)throw new Error("signal has not nbAtoms property")}}function checkForIntegration(t){for(let e of t)if(void 0===e.integration)throw new Error("ranges has not integration property")}async function get1HAssignments(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{restrictionByCS:s,minScore:i=1,maxSolutions:o=10,nbAllowedUnAssigned:a=0,timeout:l=6e3,predictionOptions:r={}}=n;if(!e)throw new Error("It is needed a OCL molecule instance to assign");e.addImplicitHydrogens(),addDiastereotopicMissingChirality(e);const{joinedSignals:m}=await predictProton(e,r);checkForIntegration(t),checkAtomsAndDiaIDs$1(m);const g={};for(const e of t){const{id:t=v4()}=e;g[t]=JSON.parse(JSON.stringify(e))}return buildAssignments$1({restrictionByCS:s,timeout:l,minScore:i,nbAllowedUnAssigned:a,maxSolutions:o,targets:g,joinedSignals:m,useIntegrationRestriction:!0})}function checkAtomsAndDiaIDs(t){for(const e of t){if(!e.atoms)throw new Error("signal has not atoms property");if(!e.diaIDs)throw new Error("signal has not diaIDs property");if(!e.nbAtoms)throw new Error("signal has not nbAtoms property")}}function checkIntegration(t){for(let e of t)void 0===e.integration&&(e.integration=0);return t}async function get13CAssignments(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{restrictionByCS:s={},minScore:i=1,maxSolutions:o=10,nbAllowedUnAssigned:a=0,timeout:l=6e3,predictionOptions:r={}}=n;if(!e)throw new Error("It is needed a OCL molecule instance to assign");addDiastereotopicMissingChirality(e);const{joinedSignals:m}=await predictCarbon(e,r);checkAtomsAndDiaIDs(m);const g=checkIntegration(t),u={};for(const t of g){const{id:e=v4()}=t;u[e]=JSON.parse(JSON.stringify(t))}return buildAssignments$1({restrictionByCS:s,timeout:l,minScore:i,nbAllowedUnAssigned:a,maxSolutions:o,targets:u,joinedSignals:m,useIntegrationRestriction:!1})}function getAtomCounts(t){const e=t?t.match(/[A-Z][a-z]{0,1}/g):[],n={};return e&&e.forEach((e=>{const s=new RegExp(`(${e}\\d+)`,"g").exec(t);let i=1;s&&(i=Number(s[0].split(e)[1])),n[e]=i})),n}function getCorrelationIndex(t,e){return t.findIndex((t=>t.id===e.id))}function getCorrelationsByAtomType(t,e){return t?t.filter((t=>t.atomType===e)):[]}function buildState(t,e){const n={},s=getAtomCounts(e);return t.reduce(((t,e)=>t.includes(e.atomType)?t:t.concat(e.atomType)),[]).forEach((e=>{const i=getCorrelationsByAtomType(t,e);if(i.some((t=>!t.pseudo))){const o={},a=s[e];let l=i.reduce(((t,e)=>e.pseudo?t:t+e.equivalence),0);if("H"===e){t.forEach((t=>{t.pseudo&&"H"!==t.atomType&&1===t.protonsCount.length&&!t.link.some((t=>"hsqc"===t.experimentType))&&(l+=t.protonsCount[0])}));const e=i.reduce(((t,e)=>e.pseudo?t+1:t),0),n=i.reduce(((e,n)=>0===Object.keys(n.attachment).length?e.concat(getCorrelationIndex(t,n)):e),[]);n.length>0&&(o.notAttached=n),l-=n.length-e,l<0&&(l=0);const s=i.reduce(((e,n)=>Object.keys(n.attachment).length>1||Object.keys(n.attachment).some((t=>n.attachment[t].length>1))?e.concat(getCorrelationIndex(t,n)):e),[]);s.length>0&&(o.ambiguousAttachment=s)}if(void 0!==a){i.some(((t,n)=>!t.pseudo&&t.atomType===e&&n>=a))&&(o.outOfLimit=!0)}const r=void 0===a?void 0:l===a;!1===r&&(o.incomplete=!0),n[e]={current:l,total:a,complete:r,error:o}}})),n}var isArray$8=Array.isArray,isArray_1=isArray$8,freeGlobal$1="object"==typeof commonjsGlobal&&commonjsGlobal&&commonjsGlobal.Object===Object&&commonjsGlobal,_freeGlobal=freeGlobal$1,freeGlobal=_freeGlobal,freeSelf="object"==typeof self&&self&&self.Object===Object&&self,root$8=freeGlobal||freeSelf||Function("return this")(),_root=root$8,root$7=_root,Symbol$7=root$7.Symbol,_Symbol=Symbol$7,Symbol$6=_Symbol,objectProto$f=Object.prototype,hasOwnProperty$c=objectProto$f.hasOwnProperty,nativeObjectToString$1=objectProto$f.toString,symToStringTag$1=Symbol$6?Symbol$6.toStringTag:void 0;function getRawTag$1(t){var e=hasOwnProperty$c.call(t,symToStringTag$1),n=t[symToStringTag$1];try{t[symToStringTag$1]=void 0;var s=!0}catch(t){}var i=nativeObjectToString$1.call(t);return s&&(e?t[symToStringTag$1]=n:delete t[symToStringTag$1]),i}var _getRawTag=getRawTag$1,objectProto$e=Object.prototype,nativeObjectToString=objectProto$e.toString;function objectToString$1(t){return nativeObjectToString.call(t)}var _objectToString=objectToString$1,Symbol$5=_Symbol,getRawTag=_getRawTag,objectToString=_objectToString,nullTag="[object Null]",undefinedTag="[object Undefined]",symToStringTag=Symbol$5?Symbol$5.toStringTag:void 0;function baseGetTag$6(t){return null==t?void 0===t?undefinedTag:nullTag:symToStringTag&&symToStringTag in Object(t)?getRawTag(t):objectToString(t)}var _baseGetTag=baseGetTag$6;function isObjectLike$8(t){return null!=t&&"object"==typeof t}var isObjectLike_1=isObjectLike$8,baseGetTag$5=_baseGetTag,isObjectLike$7=isObjectLike_1,symbolTag$3="[object Symbol]";function isSymbol$3(t){return"symbol"==typeof t||isObjectLike$7(t)&&baseGetTag$5(t)==symbolTag$3}var isSymbol_1=isSymbol$3,isArray$7=isArray_1,isSymbol$2=isSymbol_1,reIsDeepProp=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,reIsPlainProp=/^\w*$/;function isKey$1(t,e){if(isArray$7(t))return!1;var n=typeof t;return!("number"!=n&&"symbol"!=n&&"boolean"!=n&&null!=t&&!isSymbol$2(t))||(reIsPlainProp.test(t)||!reIsDeepProp.test(t)||null!=e&&t in Object(e))}var _isKey=isKey$1;function isObject$5(t){var e=typeof t;return null!=t&&("object"==e||"function"==e)}var isObject_1=isObject$5,baseGetTag$4=_baseGetTag,isObject$4=isObject_1,asyncTag="[object AsyncFunction]",funcTag$2="[object Function]",genTag$1="[object GeneratorFunction]",proxyTag="[object Proxy]";function isFunction$2(t){if(!isObject$4(t))return!1;var e=baseGetTag$4(t);return e==funcTag$2||e==genTag$1||e==asyncTag||e==proxyTag}var isFunction_1=isFunction$2,root$6=_root,coreJsData$1=root$6["__core-js_shared__"],_coreJsData=coreJsData$1,coreJsData=_coreJsData,maskSrcKey=(uid=/[^.]+$/.exec(coreJsData&&coreJsData.keys&&coreJsData.keys.IE_PROTO||""),uid?"Symbol(src)_1."+uid:""),uid;function isMasked$1(t){return!!maskSrcKey&&maskSrcKey in t}var _isMasked=isMasked$1,funcProto$2=Function.prototype,funcToString$2=funcProto$2.toString;function toSource$2(t){if(null!=t){try{return funcToString$2.call(t)}catch(t){}try{return t+""}catch(t){}}return""}var _toSource=toSource$2,isFunction$1=isFunction_1,isMasked=_isMasked,isObject$3=isObject_1,toSource$1=_toSource,reRegExpChar=/[\\^$.*+?()[\]{}|]/g,reIsHostCtor=/^\[object .+?Constructor\]$/,funcProto$1=Function.prototype,objectProto$d=Object.prototype,funcToString$1=funcProto$1.toString,hasOwnProperty$b=objectProto$d.hasOwnProperty,reIsNative=RegExp("^"+funcToString$1.call(hasOwnProperty$b).replace(reRegExpChar,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");function baseIsNative$1(t){return!(!isObject$3(t)||isMasked(t))&&(isFunction$1(t)?reIsNative:reIsHostCtor).test(toSource$1(t))}var _baseIsNative=baseIsNative$1;function getValue$1(t,e){return null==t?void 0:t[e]}var _getValue=getValue$1,baseIsNative=_baseIsNative,getValue=_getValue;function getNative$7(t,e){var n=getValue(t,e);return baseIsNative(n)?n:void 0}var _getNative=getNative$7,getNative$6=_getNative,nativeCreate$4=getNative$6(Object,"create"),_nativeCreate=nativeCreate$4,nativeCreate$3=_nativeCreate;function hashClear$1(){this.__data__=nativeCreate$3?nativeCreate$3(null):{},this.size=0}var _hashClear=hashClear$1;function hashDelete$1(t){var e=this.has(t)&&delete this.__data__[t];return this.size-=e?1:0,e}var _hashDelete=hashDelete$1,nativeCreate$2=_nativeCreate,HASH_UNDEFINED$2="__lodash_hash_undefined__",objectProto$c=Object.prototype,hasOwnProperty$a=objectProto$c.hasOwnProperty;function hashGet$1(t){var e=this.__data__;if(nativeCreate$2){var n=e[t];return n===HASH_UNDEFINED$2?void 0:n}return hasOwnProperty$a.call(e,t)?e[t]:void 0}var _hashGet=hashGet$1,nativeCreate$1=_nativeCreate,objectProto$b=Object.prototype,hasOwnProperty$9=objectProto$b.hasOwnProperty;function hashHas$1(t){var e=this.__data__;return nativeCreate$1?void 0!==e[t]:hasOwnProperty$9.call(e,t)}var _hashHas=hashHas$1,nativeCreate=_nativeCreate,HASH_UNDEFINED$1="__lodash_hash_undefined__";function hashSet$1(t,e){var n=this.__data__;return this.size+=this.has(t)?0:1,n[t]=nativeCreate&&void 0===e?HASH_UNDEFINED$1:e,this}var _hashSet=hashSet$1,hashClear=_hashClear,hashDelete=_hashDelete,hashGet=_hashGet,hashHas=_hashHas,hashSet=_hashSet;function Hash$1(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var s=t[e];this.set(s[0],s[1])}}Hash$1.prototype.clear=hashClear,Hash$1.prototype.delete=hashDelete,Hash$1.prototype.get=hashGet,Hash$1.prototype.has=hashHas,Hash$1.prototype.set=hashSet;var _Hash=Hash$1;function listCacheClear$1(){this.__data__=[],this.size=0}var _listCacheClear=listCacheClear$1;function eq$3(t,e){return t===e||t!=t&&e!=e}var eq_1=eq$3,eq$2=eq_1;function assocIndexOf$4(t,e){for(var n=t.length;n--;)if(eq$2(t[n][0],e))return n;return-1}var _assocIndexOf=assocIndexOf$4,assocIndexOf$3=_assocIndexOf,arrayProto=Array.prototype,splice=arrayProto.splice;function listCacheDelete$1(t){var e=this.__data__,n=assocIndexOf$3(e,t);return!(n<0)&&(n==e.length-1?e.pop():splice.call(e,n,1),--this.size,!0)}var _listCacheDelete=listCacheDelete$1,assocIndexOf$2=_assocIndexOf;function listCacheGet$1(t){var e=this.__data__,n=assocIndexOf$2(e,t);return n<0?void 0:e[n][1]}var _listCacheGet=listCacheGet$1,assocIndexOf$1=_assocIndexOf;function listCacheHas$1(t){return assocIndexOf$1(this.__data__,t)>-1}var _listCacheHas=listCacheHas$1,assocIndexOf=_assocIndexOf;function listCacheSet$1(t,e){var n=this.__data__,s=assocIndexOf(n,t);return s<0?(++this.size,n.push([t,e])):n[s][1]=e,this}var _listCacheSet=listCacheSet$1,listCacheClear=_listCacheClear,listCacheDelete=_listCacheDelete,listCacheGet=_listCacheGet,listCacheHas=_listCacheHas,listCacheSet=_listCacheSet;function ListCache$4(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var s=t[e];this.set(s[0],s[1])}}ListCache$4.prototype.clear=listCacheClear,ListCache$4.prototype.delete=listCacheDelete,ListCache$4.prototype.get=listCacheGet,ListCache$4.prototype.has=listCacheHas,ListCache$4.prototype.set=listCacheSet;var _ListCache=ListCache$4,getNative$5=_getNative,root$5=_root,Map$4=getNative$5(root$5,"Map"),_Map=Map$4,Hash=_Hash,ListCache$3=_ListCache,Map$3=_Map;function mapCacheClear$1(){this.size=0,this.__data__={hash:new Hash,map:new(Map$3||ListCache$3),string:new Hash}}var _mapCacheClear=mapCacheClear$1;function isKeyable$1(t){var e=typeof t;return"string"==e||"number"==e||"symbol"==e||"boolean"==e?"__proto__"!==t:null===t}var _isKeyable=isKeyable$1,isKeyable=_isKeyable;function getMapData$4(t,e){var n=t.__data__;return isKeyable(e)?n["string"==typeof e?"string":"hash"]:n.map}var _getMapData=getMapData$4,getMapData$3=_getMapData;function mapCacheDelete$1(t){var e=getMapData$3(this,t).delete(t);return this.size-=e?1:0,e}var _mapCacheDelete=mapCacheDelete$1,getMapData$2=_getMapData;function mapCacheGet$1(t){return getMapData$2(this,t).get(t)}var _mapCacheGet=mapCacheGet$1,getMapData$1=_getMapData;function mapCacheHas$1(t){return getMapData$1(this,t).has(t)}var _mapCacheHas=mapCacheHas$1,getMapData=_getMapData;function mapCacheSet$1(t,e){var n=getMapData(this,t),s=n.size;return n.set(t,e),this.size+=n.size==s?0:1,this}var _mapCacheSet=mapCacheSet$1,mapCacheClear=_mapCacheClear,mapCacheDelete=_mapCacheDelete,mapCacheGet=_mapCacheGet,mapCacheHas=_mapCacheHas,mapCacheSet=_mapCacheSet;function MapCache$3(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var s=t[e];this.set(s[0],s[1])}}MapCache$3.prototype.clear=mapCacheClear,MapCache$3.prototype.delete=mapCacheDelete,MapCache$3.prototype.get=mapCacheGet,MapCache$3.prototype.has=mapCacheHas,MapCache$3.prototype.set=mapCacheSet;var _MapCache=MapCache$3,MapCache$2=_MapCache,FUNC_ERROR_TEXT="Expected a function";function memoize$1(t,e){if("function"!=typeof t||null!=e&&"function"!=typeof e)throw new TypeError(FUNC_ERROR_TEXT);var n=function(){var s=arguments,i=e?e.apply(this,s):s[0],o=n.cache;if(o.has(i))return o.get(i);var a=t.apply(this,s);return n.cache=o.set(i,a)||o,a};return n.cache=new(memoize$1.Cache||MapCache$2),n}memoize$1.Cache=MapCache$2;var memoize_1=memoize$1,memoize=memoize_1,MAX_MEMOIZE_SIZE=500;function memoizeCapped$1(t){var e=memoize(t,(function(t){return n.size===MAX_MEMOIZE_SIZE&&n.clear(),t})),n=e.cache;return e}var _memoizeCapped=memoizeCapped$1,memoizeCapped=_memoizeCapped,rePropName=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,reEscapeChar=/\\(\\)?/g,stringToPath$1=memoizeCapped((function(t){var e=[];return 46===t.charCodeAt(0)&&e.push(""),t.replace(rePropName,(function(t,n,s,i){e.push(s?i.replace(reEscapeChar,"$1"):n||t)})),e})),_stringToPath=stringToPath$1;function arrayMap$2(t,e){for(var n=-1,s=null==t?0:t.length,i=Array(s);++n<s;)i[n]=e(t[n],n,t);return i}var _arrayMap=arrayMap$2,Symbol$4=_Symbol,arrayMap$1=_arrayMap,isArray$6=isArray_1,isSymbol$1=isSymbol_1,INFINITY$1=1/0,symbolProto$2=Symbol$4?Symbol$4.prototype:void 0,symbolToString=symbolProto$2?symbolProto$2.toString:void 0;function baseToString$1(t){if("string"==typeof t)return t;if(isArray$6(t))return arrayMap$1(t,baseToString$1)+"";if(isSymbol$1(t))return symbolToString?symbolToString.call(t):"";var e=t+"";return"0"==e&&1/t==-INFINITY$1?"-0":e}var _baseToString=baseToString$1,baseToString=_baseToString;function toString$1(t){return null==t?"":baseToString(t)}var toString_1=toString$1,isArray$5=isArray_1,isKey=_isKey,stringToPath=_stringToPath,toString=toString_1;function castPath$3(t,e){return isArray$5(t)?t:isKey(t,e)?[t]:stringToPath(toString(t))}var _castPath=castPath$3,isSymbol=isSymbol_1,INFINITY=1/0;function toKey$2(t){if("string"==typeof t||isSymbol(t))return t;var e=t+"";return"0"==e&&1/t==-INFINITY?"-0":e}var _toKey=toKey$2,castPath$2=_castPath,toKey$1=_toKey;function baseGet$2(t,e){for(var n=0,s=(e=castPath$2(e,t)).length;null!=t&&n<s;)t=t[toKey$1(e[n++])];return n&&n==s?t:void 0}var _baseGet=baseGet$2,baseGet$1=_baseGet;function get(t,e,n){var s=null==t?void 0:baseGet$1(t,e);return void 0===s?n:s}var get_1=get,lodashGet=get_1;function checkMatch(t,e,n){return t-n<=e&&e<=t+n}function getLinkDim(t){return"1d"===t.experimentType?1:2}function getLinkDelta(t){if(!t.pseudo)return 1===getLinkDim(t)?t.signal.delta:"x"===t.axis?t.signal.x.delta:t.signal.y.delta}function getCorrelationDelta(t){if(t.link.length>0)return getLinkDelta(t.link[0])}function setProtonsCount(t,e,n,s){for(let i=0;i<t.length;i++){const o=t[i];if(o.edited.protonsCount)continue;const a=getCorrelationDelta(o),l=[-1,-1];for(let t=0;t<e.length;t++)if(void 0!==a&&checkMatch(a,e[t].delta,s)){l[0]=t;break}for(let t=0;t<n.length;t++)if(void 0!==a&&checkMatch(a,n[t].delta,s)){l[1]=t;break}l[0]>=0?o.protonsCount=[1]:l[1]>=0?1===n[l[1]].sign?e.length>0?o.protonsCount=[3]:o.protonsCount=[1,3]:o.protonsCount=[2]:n.length>0?o.protonsCount=[0]:o.protonsCount=[]}return t}function setProtonsCountFromDEPT(t,e,n,s){return setProtonsCount(getCorrelationsByAtomType(t,s).filter((t=>!t.pseudo)),lodashGet(e,"90",[]).filter((t=>t.atomType===s)).map((t=>t.signal)),lodashGet(e,"135",[]).filter((t=>t.atomType===s)).map((t=>t.signal)),n[s]),t}function setProtonsCountFromEditedHSQC(t,e,n,s){return setProtonsCount(t.filter((t=>!t.pseudo&&t.atomType===s)),[],lodashGet(e,"hsqc",[]).filter((t=>t.atomType[1]===s&&0!==t.signal.sign)).map((t=>({delta:t.signal.y.delta,sign:t.signal.sign}))),n[s]),t}function setProtonsCountFromData(t,e,n,s){const i=[];return t.forEach((o=>{o.pseudo||"H"===o.atomType||i.includes(o.atomType)||(i.push(o.atomType),Object.keys(e).length>0?setProtonsCountFromDEPT(t,e,s,o.atomType):setProtonsCountFromEditedHSQC(t,n,s,o.atomType))})),t}function getExperiments(t){if(!t)return{};const e={};for(const n of t){if(n.info.isFid)continue;e[`${n.info.dimension}D`]||(e[`${n.info.dimension}D`]={});const t=n.info.experiment;e[`${n.info.dimension}D`][`${t}`]||(e[`${n.info.dimension}D`][`${t}`]=[]),e[`${n.info.dimension}D`][`${t}`].push(n)}return e}function getAtomTypeFromNucleus(t){return t.length>0?t.split(/\d+/)[1]:""}function addToExperiments(t,e,n,s,i){const o=lodashGet(t,`${n}`,[]).filter((t=>{const e=lodashGet(t,n.includes("1D")?"ranges.values":"zones.values",[]).length>0;return s?getAtomTypeFromNucleus(t.info.nucleus)===i&&e:e}));o.length>0&&(e[i]=o)}function getExperiments1D(t){const e={};return lodashGet(t,"1D.1d",[]).map((t=>getAtomTypeFromNucleus(t.info.nucleus))).forEach((n=>{addToExperiments(t,e,"1D.1d",!0,n)})),e}function getExperiments1DExtra(t){const e={};return Object.keys(lodashGet(t,"1D",{})).filter((t=>"1d"!==t)).forEach((n=>{addToExperiments(t,e,`1D.${n}`,!1,n)})),e}function getExperiments2D(t){const e={};return Object.keys(lodashGet(t,"2D",{})).forEach((n=>{addToExperiments(t,e,`2D.${n}`,!1,n)})),e}const allowedSignalKinds=["signal"];function getSignals1D(t){const e={};for(const n in t){const s=[],i=t[`${n}`]||[];if(0===i.length)continue;const o=i[0];for(const t of o.ranges.values)for(const e of t.signals)e.kind&&allowedSignalKinds.includes(e.kind)&&(checkExistence(e,s)||s.push({experimentType:"1d",experimentID:o.id,integration:e.integration?e.integration:t.integration,atomType:n,signal:{...e}}));e[n]=s}return e}function checkExistence(t,e){for(const n of e)if(checkMatch(n.signal.delta,t.delta,0))return!0;return!1}var ListCache$2=_ListCache;function stackClear$1(){this.__data__=new ListCache$2,this.size=0}var _stackClear=stackClear$1;function stackDelete$1(t){var e=this.__data__,n=e.delete(t);return this.size=e.size,n}var _stackDelete=stackDelete$1;function stackGet$1(t){return this.__data__.get(t)}var _stackGet=stackGet$1;function stackHas$1(t){return this.__data__.has(t)}var _stackHas=stackHas$1,ListCache$1=_ListCache,Map$2=_Map,MapCache$1=_MapCache,LARGE_ARRAY_SIZE=200;function stackSet$1(t,e){var n=this.__data__;if(n instanceof ListCache$1){var s=n.__data__;if(!Map$2||s.length<LARGE_ARRAY_SIZE-1)return s.push([t,e]),this.size=++n.size,this;n=this.__data__=new MapCache$1(s)}return n.set(t,e),this.size=n.size,this}var _stackSet=stackSet$1,ListCache=_ListCache,stackClear=_stackClear,stackDelete=_stackDelete,stackGet=_stackGet,stackHas=_stackHas,stackSet=_stackSet;function Stack$2(t){var e=this.__data__=new ListCache(t);this.size=e.size}Stack$2.prototype.clear=stackClear,Stack$2.prototype.delete=stackDelete,Stack$2.prototype.get=stackGet,Stack$2.prototype.has=stackHas,Stack$2.prototype.set=stackSet;var _Stack=Stack$2;function arrayEach$1(t,e){for(var n=-1,s=null==t?0:t.length;++n<s&&!1!==e(t[n],n,t););return t}var _arrayEach=arrayEach$1,getNative$4=_getNative,defineProperty$2=function(){try{var t=getNative$4(Object,"defineProperty");return t({},"",{}),t}catch(t){}}(),_defineProperty=defineProperty$2,defineProperty$1=_defineProperty;function baseAssignValue$2(t,e,n){"__proto__"==e&&defineProperty$1?defineProperty$1(t,e,{configurable:!0,enumerable:!0,value:n,writable:!0}):t[e]=n}var _baseAssignValue=baseAssignValue$2,baseAssignValue$1=_baseAssignValue,eq$1=eq_1,objectProto$a=Object.prototype,hasOwnProperty$8=objectProto$a.hasOwnProperty;function assignValue$2(t,e,n){var s=t[e];hasOwnProperty$8.call(t,e)&&eq$1(s,n)&&(void 0!==n||e in t)||baseAssignValue$1(t,e,n)}var _assignValue=assignValue$2,assignValue$1=_assignValue,baseAssignValue=_baseAssignValue;function copyObject$5(t,e,n,s){var i=!n;n||(n={});for(var o=-1,a=e.length;++o<a;){var l=e[o],r=s?s(n[l],t[l],l,n,t):void 0;void 0===r&&(r=t[l]),i?baseAssignValue(n,l,r):assignValue$1(n,l,r)}return n}var _copyObject=copyObject$5;function baseTimes$1(t,e){for(var n=-1,s=Array(t);++n<t;)s[n]=e(n);return s}var _baseTimes=baseTimes$1,baseGetTag$3=_baseGetTag,isObjectLike$6=isObjectLike_1,argsTag$3="[object Arguments]";function baseIsArguments$1(t){return isObjectLike$6(t)&&baseGetTag$3(t)==argsTag$3}var _baseIsArguments=baseIsArguments$1,baseIsArguments=_baseIsArguments,isObjectLike$5=isObjectLike_1,objectProto$9=Object.prototype,hasOwnProperty$7=objectProto$9.hasOwnProperty,propertyIsEnumerable$1=objectProto$9.propertyIsEnumerable,isArguments$2=baseIsArguments(function(){return arguments}())?baseIsArguments:function(t){return isObjectLike$5(t)&&hasOwnProperty$7.call(t,"callee")&&!propertyIsEnumerable$1.call(t,"callee")},isArguments_1=isArguments$2,isBuffer$3={exports:{}};function stubFalse(){return!1}var stubFalse_1=stubFalse;!function(t,e){var n=_root,s=stubFalse_1,i=e&&!e.nodeType&&e,o=i&&t&&!t.nodeType&&t,a=o&&o.exports===i?n.Buffer:void 0,l=(a?a.isBuffer:void 0)||s;t.exports=l}(isBuffer$3,isBuffer$3.exports);var MAX_SAFE_INTEGER$1=9007199254740991,reIsUint=/^(?:0|[1-9]\d*)$/;function isIndex$1(t,e){var n=typeof t;return!!(e=null==e?MAX_SAFE_INTEGER$1:e)&&("number"==n||"symbol"!=n&&reIsUint.test(t))&&t>-1&&t%1==0&&t<e}var _isIndex=isIndex$1,MAX_SAFE_INTEGER=9007199254740991;function isLength$2(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=MAX_SAFE_INTEGER}var isLength_1=isLength$2,baseGetTag$2=_baseGetTag,isLength$1=isLength_1,isObjectLike$4=isObjectLike_1,argsTag$2="[object Arguments]",arrayTag$2="[object Array]",boolTag$3="[object Boolean]",dateTag$3="[object Date]",errorTag$2="[object Error]",funcTag$1="[object Function]",mapTag$5="[object Map]",numberTag$3="[object Number]",objectTag$4="[object Object]",regexpTag$3="[object RegExp]",setTag$5="[object Set]",stringTag$3="[object String]",weakMapTag$2="[object WeakMap]",arrayBufferTag$3="[object ArrayBuffer]",dataViewTag$4="[object DataView]",float32Tag$2="[object Float32Array]",float64Tag$2="[object Float64Array]",int8Tag$2="[object Int8Array]",int16Tag$2="[object Int16Array]",int32Tag$2="[object Int32Array]",uint8Tag$2="[object Uint8Array]",uint8ClampedTag$2="[object Uint8ClampedArray]",uint16Tag$2="[object Uint16Array]",uint32Tag$2="[object Uint32Array]",typedArrayTags={};function baseIsTypedArray$1(t){return isObjectLike$4(t)&&isLength$1(t.length)&&!!typedArrayTags[baseGetTag$2(t)]}typedArrayTags[float32Tag$2]=typedArrayTags[float64Tag$2]=typedArrayTags[int8Tag$2]=typedArrayTags[int16Tag$2]=typedArrayTags[int32Tag$2]=typedArrayTags[uint8Tag$2]=typedArrayTags[uint8ClampedTag$2]=typedArrayTags[uint16Tag$2]=typedArrayTags[uint32Tag$2]=!0,typedArrayTags[argsTag$2]=typedArrayTags[arrayTag$2]=typedArrayTags[arrayBufferTag$3]=typedArrayTags[boolTag$3]=typedArrayTags[dataViewTag$4]=typedArrayTags[dateTag$3]=typedArrayTags[errorTag$2]=typedArrayTags[funcTag$1]=typedArrayTags[mapTag$5]=typedArrayTags[numberTag$3]=typedArrayTags[objectTag$4]=typedArrayTags[regexpTag$3]=typedArrayTags[setTag$5]=typedArrayTags[stringTag$3]=typedArrayTags[weakMapTag$2]=!1;var _baseIsTypedArray=baseIsTypedArray$1;function baseUnary$3(t){return function(e){return t(e)}}var _baseUnary=baseUnary$3,_nodeUtil={exports:{}};!function(t,e){var n=_freeGlobal,s=e&&!e.nodeType&&e,i=s&&t&&!t.nodeType&&t,o=i&&i.exports===s&&n.process,a=function(){try{var t=i&&i.require&&i.require("util").types;return t||o&&o.binding&&o.binding("util")}catch(t){}}();t.exports=a}(_nodeUtil,_nodeUtil.exports);var baseIsTypedArray=_baseIsTypedArray,baseUnary$2=_baseUnary,nodeUtil$2=_nodeUtil.exports,nodeIsTypedArray=nodeUtil$2&&nodeUtil$2.isTypedArray,isTypedArray$2=nodeIsTypedArray?baseUnary$2(nodeIsTypedArray):baseIsTypedArray,isTypedArray_1=isTypedArray$2,baseTimes=_baseTimes,isArguments$1=isArguments_1,isArray$4=isArray_1,isBuffer$2=isBuffer$3.exports,isIndex=_isIndex,isTypedArray$1=isTypedArray_1,objectProto$8=Object.prototype,hasOwnProperty$6=objectProto$8.hasOwnProperty;function arrayLikeKeys$2(t,e){var n=isArray$4(t),s=!n&&isArguments$1(t),i=!n&&!s&&isBuffer$2(t),o=!n&&!s&&!i&&isTypedArray$1(t),a=n||s||i||o,l=a?baseTimes(t.length,String):[],r=l.length;for(var m in t)!e&&!hasOwnProperty$6.call(t,m)||a&&("length"==m||i&&("offset"==m||"parent"==m)||o&&("buffer"==m||"byteLength"==m||"byteOffset"==m)||isIndex(m,r))||l.push(m);return l}var _arrayLikeKeys=arrayLikeKeys$2,objectProto$7=Object.prototype;function isPrototype$3(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||objectProto$7)}var _isPrototype=isPrototype$3;function overArg$2(t,e){return function(n){return t(e(n))}}var _overArg=overArg$2,overArg$1=_overArg,nativeKeys$1=overArg$1(Object.keys,Object),_nativeKeys=nativeKeys$1,isPrototype$2=_isPrototype,nativeKeys=_nativeKeys,objectProto$6=Object.prototype,hasOwnProperty$5=objectProto$6.hasOwnProperty;function baseKeys$1(t){if(!isPrototype$2(t))return nativeKeys(t);var e=[];for(var n in Object(t))hasOwnProperty$5.call(t,n)&&"constructor"!=n&&e.push(n);return e}var _baseKeys=baseKeys$1,isFunction=isFunction_1,isLength=isLength_1;function isArrayLike$2(t){return null!=t&&isLength(t.length)&&!isFunction(t)}var isArrayLike_1=isArrayLike$2,arrayLikeKeys$1=_arrayLikeKeys,baseKeys=_baseKeys,isArrayLike$1=isArrayLike_1;function keys$3(t){return isArrayLike$1(t)?arrayLikeKeys$1(t):baseKeys(t)}var keys_1=keys$3,copyObject$4=_copyObject,keys$2=keys_1;function baseAssign$1(t,e){return t&&copyObject$4(e,keys$2(e),t)}var _baseAssign=baseAssign$1;function nativeKeysIn$1(t){var e=[];if(null!=t)for(var n in Object(t))e.push(n);return e}var _nativeKeysIn=nativeKeysIn$1,isObject$2=isObject_1,isPrototype$1=_isPrototype,nativeKeysIn=_nativeKeysIn,objectProto$5=Object.prototype,hasOwnProperty$4=objectProto$5.hasOwnProperty;function baseKeysIn$1(t){if(!isObject$2(t))return nativeKeysIn(t);var e=isPrototype$1(t),n=[];for(var s in t)("constructor"!=s||!e&&hasOwnProperty$4.call(t,s))&&n.push(s);return n}var _baseKeysIn=baseKeysIn$1,arrayLikeKeys=_arrayLikeKeys,baseKeysIn=_baseKeysIn,isArrayLike=isArrayLike_1;function keysIn$3(t){return isArrayLike(t)?arrayLikeKeys(t,!0):baseKeysIn(t)}var keysIn_1=keysIn$3,copyObject$3=_copyObject,keysIn$2=keysIn_1;function baseAssignIn$1(t,e){return t&&copyObject$3(e,keysIn$2(e),t)}var _baseAssignIn=baseAssignIn$1,_cloneBuffer={exports:{}};function copyArray$1(t,e){var n=-1,s=t.length;for(e||(e=Array(s));++n<s;)e[n]=t[n];return e}!function(t,e){var n=_root,s=e&&!e.nodeType&&e,i=s&&t&&!t.nodeType&&t,o=i&&i.exports===s?n.Buffer:void 0,a=o?o.allocUnsafe:void 0;t.exports=function(t,e){if(e)return t.slice();var n=t.length,s=a?a(n):new t.constructor(n);return t.copy(s),s}}(_cloneBuffer,_cloneBuffer.exports);var _copyArray=copyArray$1;function arrayFilter$1(t,e){for(var n=-1,s=null==t?0:t.length,i=0,o=[];++n<s;){var a=t[n];e(a,n,t)&&(o[i++]=a)}return o}var _arrayFilter=arrayFilter$1;function stubArray$2(){return[]}var stubArray_1=stubArray$2,arrayFilter=_arrayFilter,stubArray$1=stubArray_1,objectProto$4=Object.prototype,propertyIsEnumerable=objectProto$4.propertyIsEnumerable,nativeGetSymbols$1=Object.getOwnPropertySymbols,getSymbols$3=nativeGetSymbols$1?function(t){return null==t?[]:(t=Object(t),arrayFilter(nativeGetSymbols$1(t),(function(e){return propertyIsEnumerable.call(t,e)})))}:stubArray$1,_getSymbols=getSymbols$3,copyObject$2=_copyObject,getSymbols$2=_getSymbols;function copySymbols$1(t,e){return copyObject$2(t,getSymbols$2(t),e)}var _copySymbols=copySymbols$1;function arrayPush$3(t,e){for(var n=-1,s=e.length,i=t.length;++n<s;)t[i+n]=e[n];return t}var _arrayPush=arrayPush$3,overArg=_overArg,getPrototype$3=overArg(Object.getPrototypeOf,Object),_getPrototype=getPrototype$3,arrayPush$2=_arrayPush,getPrototype$2=_getPrototype,getSymbols$1=_getSymbols,stubArray=stubArray_1,nativeGetSymbols=Object.getOwnPropertySymbols,getSymbolsIn$2=nativeGetSymbols?function(t){for(var e=[];t;)arrayPush$2(e,getSymbols$1(t)),t=getPrototype$2(t);return e}:stubArray,_getSymbolsIn=getSymbolsIn$2,copyObject$1=_copyObject,getSymbolsIn$1=_getSymbolsIn;function copySymbolsIn$1(t,e){return copyObject$1(t,getSymbolsIn$1(t),e)}var _copySymbolsIn=copySymbolsIn$1,arrayPush$1=_arrayPush,isArray$3=isArray_1;function baseGetAllKeys$2(t,e,n){var s=e(t);return isArray$3(t)?s:arrayPush$1(s,n(t))}var _baseGetAllKeys=baseGetAllKeys$2,baseGetAllKeys$1=_baseGetAllKeys,getSymbols=_getSymbols,keys$1=keys_1;function getAllKeys$2(t){return baseGetAllKeys$1(t,keys$1,getSymbols)}var _getAllKeys=getAllKeys$2,baseGetAllKeys=_baseGetAllKeys,getSymbolsIn=_getSymbolsIn,keysIn$1=keysIn_1;function getAllKeysIn$2(t){return baseGetAllKeys(t,keysIn$1,getSymbolsIn)}var _getAllKeysIn=getAllKeysIn$2,getNative$3=_getNative,root$4=_root,DataView$2=getNative$3(root$4,"DataView"),_DataView=DataView$2,getNative$2=_getNative,root$3=_root,Promise$2=getNative$2(root$3,"Promise"),_Promise=Promise$2,getNative$1=_getNative,root$2=_root,Set$2=getNative$1(root$2,"Set"),_Set=Set$2,getNative=_getNative,root$1=_root,WeakMap$1=getNative(root$1,"WeakMap"),_WeakMap=WeakMap$1,DataView$1=_DataView,Map$1=_Map,Promise$1=_Promise,Set$1=_Set,WeakMap=_WeakMap,baseGetTag$1=_baseGetTag,toSource=_toSource,mapTag$4="[object Map]",objectTag$3="[object Object]",promiseTag="[object Promise]",setTag$4="[object Set]",weakMapTag$1="[object WeakMap]",dataViewTag$3="[object DataView]",dataViewCtorString=toSource(DataView$1),mapCtorString=toSource(Map$1),promiseCtorString=toSource(Promise$1),setCtorString=toSource(Set$1),weakMapCtorString=toSource(WeakMap),getTag$4=baseGetTag$1;(DataView$1&&getTag$4(new DataView$1(new ArrayBuffer(1)))!=dataViewTag$3||Map$1&&getTag$4(new Map$1)!=mapTag$4||Promise$1&&getTag$4(Promise$1.resolve())!=promiseTag||Set$1&&getTag$4(new Set$1)!=setTag$4||WeakMap&&getTag$4(new WeakMap)!=weakMapTag$1)&&(getTag$4=function(t){var e=baseGetTag$1(t),n=e==objectTag$3?t.constructor:void 0,s=n?toSource(n):"";if(s)switch(s){case dataViewCtorString:return dataViewTag$3;case mapCtorString:return mapTag$4;case promiseCtorString:return promiseTag;case setCtorString:return setTag$4;case weakMapCtorString:return weakMapTag$1}return e});var _getTag=getTag$4,objectProto$3=Object.prototype,hasOwnProperty$3=objectProto$3.hasOwnProperty;function initCloneArray$1(t){var e=t.length,n=new t.constructor(e);return e&&"string"==typeof t[0]&&hasOwnProperty$3.call(t,"index")&&(n.index=t.index,n.input=t.input),n}var _initCloneArray=initCloneArray$1,root=_root,Uint8Array$3=root.Uint8Array,_Uint8Array=Uint8Array$3,Uint8Array$2=_Uint8Array;function cloneArrayBuffer$3(t){var e=new t.constructor(t.byteLength);return new Uint8Array$2(e).set(new Uint8Array$2(t)),e}var _cloneArrayBuffer=cloneArrayBuffer$3,cloneArrayBuffer$2=_cloneArrayBuffer;function cloneDataView$1(t,e){var n=e?cloneArrayBuffer$2(t.buffer):t.buffer;return new t.constructor(n,t.byteOffset,t.byteLength)}var _cloneDataView=cloneDataView$1,reFlags=/\w*$/;function cloneRegExp$1(t){var e=new t.constructor(t.source,reFlags.exec(t));return e.lastIndex=t.lastIndex,e}var _cloneRegExp=cloneRegExp$1,Symbol$3=_Symbol,symbolProto$1=Symbol$3?Symbol$3.prototype:void 0,symbolValueOf$1=symbolProto$1?symbolProto$1.valueOf:void 0;function cloneSymbol$1(t){return symbolValueOf$1?Object(symbolValueOf$1.call(t)):{}}var _cloneSymbol=cloneSymbol$1,cloneArrayBuffer$1=_cloneArrayBuffer;function cloneTypedArray$1(t,e){var n=e?cloneArrayBuffer$1(t.buffer):t.buffer;return new t.constructor(n,t.byteOffset,t.length)}var _cloneTypedArray=cloneTypedArray$1,cloneArrayBuffer=_cloneArrayBuffer,cloneDataView=_cloneDataView,cloneRegExp=_cloneRegExp,cloneSymbol=_cloneSymbol,cloneTypedArray=_cloneTypedArray,boolTag$2="[object Boolean]",dateTag$2="[object Date]",mapTag$3="[object Map]",numberTag$2="[object Number]",regexpTag$2="[object RegExp]",setTag$3="[object Set]",stringTag$2="[object String]",symbolTag$2="[object Symbol]",arrayBufferTag$2="[object ArrayBuffer]",dataViewTag$2="[object DataView]",float32Tag$1="[object Float32Array]",float64Tag$1="[object Float64Array]",int8Tag$1="[object Int8Array]",int16Tag$1="[object Int16Array]",int32Tag$1="[object Int32Array]",uint8Tag$1="[object Uint8Array]",uint8ClampedTag$1="[object Uint8ClampedArray]",uint16Tag$1="[object Uint16Array]",uint32Tag$1="[object Uint32Array]";function initCloneByTag$1(t,e,n){var s=t.constructor;switch(e){case arrayBufferTag$2:return cloneArrayBuffer(t);case boolTag$2:case dateTag$2:return new s(+t);case dataViewTag$2:return cloneDataView(t,n);case float32Tag$1:case float64Tag$1:case int8Tag$1:case int16Tag$1:case int32Tag$1:case uint8Tag$1:case uint8ClampedTag$1:case uint16Tag$1:case uint32Tag$1:return cloneTypedArray(t,n);case mapTag$3:return new s;case numberTag$2:case stringTag$2:return new s(t);case regexpTag$2:return cloneRegExp(t);case setTag$3:return new s;case symbolTag$2:return cloneSymbol(t)}}var _initCloneByTag=initCloneByTag$1,isObject$1=isObject_1,objectCreate=Object.create,baseCreate$1=function(){function t(){}return function(e){if(!isObject$1(e))return{};if(objectCreate)return objectCreate(e);t.prototype=e;var n=new t;return t.prototype=void 0,n}}(),_baseCreate=baseCreate$1,baseCreate=_baseCreate,getPrototype$1=_getPrototype,isPrototype=_isPrototype;function initCloneObject$1(t){return"function"!=typeof t.constructor||isPrototype(t)?{}:baseCreate(getPrototype$1(t))}var _initCloneObject=initCloneObject$1,getTag$3=_getTag,isObjectLike$3=isObjectLike_1,mapTag$2="[object Map]";function baseIsMap$1(t){return isObjectLike$3(t)&&getTag$3(t)==mapTag$2}var _baseIsMap=baseIsMap$1,baseIsMap=_baseIsMap,baseUnary$1=_baseUnary,nodeUtil$1=_nodeUtil.exports,nodeIsMap=nodeUtil$1&&nodeUtil$1.isMap,isMap$1=nodeIsMap?baseUnary$1(nodeIsMap):baseIsMap,isMap_1=isMap$1,getTag$2=_getTag,isObjectLike$2=isObjectLike_1,setTag$2="[object Set]";function baseIsSet$1(t){return isObjectLike$2(t)&&getTag$2(t)==setTag$2}var _baseIsSet=baseIsSet$1,baseIsSet=_baseIsSet,baseUnary=_baseUnary,nodeUtil=_nodeUtil.exports,nodeIsSet=nodeUtil&&nodeUtil.isSet,isSet$1=nodeIsSet?baseUnary(nodeIsSet):baseIsSet,isSet_1=isSet$1,Stack$1=_Stack,arrayEach=_arrayEach,assignValue=_assignValue,baseAssign=_baseAssign,baseAssignIn=_baseAssignIn,cloneBuffer=_cloneBuffer.exports,copyArray=_copyArray,copySymbols=_copySymbols,copySymbolsIn=_copySymbolsIn,getAllKeys$1=_getAllKeys,getAllKeysIn$1=_getAllKeysIn,getTag$1=_getTag,initCloneArray=_initCloneArray,initCloneByTag=_initCloneByTag,initCloneObject=_initCloneObject,isArray$2=isArray_1,isBuffer$1=isBuffer$3.exports,isMap=isMap_1,isObject=isObject_1,isSet=isSet_1,keys=keys_1,keysIn=keysIn_1,CLONE_DEEP_FLAG$2=1,CLONE_FLAT_FLAG$1=2,CLONE_SYMBOLS_FLAG$2=4,argsTag$1="[object Arguments]",arrayTag$1="[object Array]",boolTag$1="[object Boolean]",dateTag$1="[object Date]",errorTag$1="[object Error]",funcTag="[object Function]",genTag="[object GeneratorFunction]",mapTag$1="[object Map]",numberTag$1="[object Number]",objectTag$2="[object Object]",regexpTag$1="[object RegExp]",setTag$1="[object Set]",stringTag$1="[object String]",symbolTag$1="[object Symbol]",weakMapTag="[object WeakMap]",arrayBufferTag$1="[object ArrayBuffer]",dataViewTag$1="[object DataView]",float32Tag="[object Float32Array]",float64Tag="[object Float64Array]",int8Tag="[object Int8Array]",int16Tag="[object Int16Array]",int32Tag="[object Int32Array]",uint8Tag="[object Uint8Array]",uint8ClampedTag="[object Uint8ClampedArray]",uint16Tag="[object Uint16Array]",uint32Tag="[object Uint32Array]",cloneableTags={};function baseClone$2(t,e,n,s,i,o){var a,l=e&CLONE_DEEP_FLAG$2,r=e&CLONE_FLAT_FLAG$1,m=e&CLONE_SYMBOLS_FLAG$2;if(n&&(a=i?n(t,s,i,o):n(t)),void 0!==a)return a;if(!isObject(t))return t;var g=isArray$2(t);if(g){if(a=initCloneArray(t),!l)return copyArray(t,a)}else{var u=getTag$1(t),c=u==funcTag||u==genTag;if(isBuffer$1(t))return cloneBuffer(t,l);if(u==objectTag$2||u==argsTag$1||c&&!i){if(a=r||c?{}:initCloneObject(t),!l)return r?copySymbolsIn(t,baseAssignIn(a,t)):copySymbols(t,baseAssign(a,t))}else{if(!cloneableTags[u])return i?t:{};a=initCloneByTag(t,u,l)}}o||(o=new Stack$1);var C=o.get(t);if(C)return C;o.set(t,a),isSet(t)?t.forEach((function(s){a.add(baseClone$2(s,e,n,s,t,o))})):isMap(t)&&t.forEach((function(s,i){a.set(i,baseClone$2(s,e,n,i,t,o))}));var f=g?void 0:(m?r?getAllKeysIn$1:getAllKeys$1:r?keysIn:keys)(t);return arrayEach(f||t,(function(s,i){f&&(s=t[i=s]),assignValue(a,i,baseClone$2(s,e,n,i,t,o))})),a}cloneableTags[argsTag$1]=cloneableTags[arrayTag$1]=cloneableTags[arrayBufferTag$1]=cloneableTags[dataViewTag$1]=cloneableTags[boolTag$1]=cloneableTags[dateTag$1]=cloneableTags[float32Tag]=cloneableTags[float64Tag]=cloneableTags[int8Tag]=cloneableTags[int16Tag]=cloneableTags[int32Tag]=cloneableTags[mapTag$1]=cloneableTags[numberTag$1]=cloneableTags[objectTag$2]=cloneableTags[regexpTag$1]=cloneableTags[setTag$1]=cloneableTags[stringTag$1]=cloneableTags[symbolTag$1]=cloneableTags[uint8Tag]=cloneableTags[uint8ClampedTag]=cloneableTags[uint16Tag]=cloneableTags[uint32Tag]=!0,cloneableTags[errorTag$1]=cloneableTags[funcTag]=cloneableTags[weakMapTag]=!1;var _baseClone=baseClone$2,baseClone$1=_baseClone,CLONE_DEEP_FLAG$1=1,CLONE_SYMBOLS_FLAG$1=4;function cloneDeep(t){return baseClone$1(t,CLONE_DEEP_FLAG$1|CLONE_SYMBOLS_FLAG$1)}var cloneDeep_1=cloneDeep,lodashCloneDeep=cloneDeep_1,HASH_UNDEFINED="__lodash_hash_undefined__";function setCacheAdd$1(t){return this.__data__.set(t,HASH_UNDEFINED),this}var _setCacheAdd=setCacheAdd$1;function setCacheHas$1(t){return this.__data__.has(t)}var _setCacheHas=setCacheHas$1,MapCache=_MapCache,setCacheAdd=_setCacheAdd,setCacheHas=_setCacheHas;function SetCache$1(t){var e=-1,n=null==t?0:t.length;for(this.__data__=new MapCache;++e<n;)this.add(t[e])}SetCache$1.prototype.add=SetCache$1.prototype.push=setCacheAdd,SetCache$1.prototype.has=setCacheHas;var _SetCache=SetCache$1;function arraySome$1(t,e){for(var n=-1,s=null==t?0:t.length;++n<s;)if(e(t[n],n,t))return!0;return!1}var _arraySome=arraySome$1;function cacheHas$1(t,e){return t.has(e)}var _cacheHas=cacheHas$1,SetCache=_SetCache,arraySome=_arraySome,cacheHas=_cacheHas,COMPARE_PARTIAL_FLAG$3=1,COMPARE_UNORDERED_FLAG$1=2;function equalArrays$2(t,e,n,s,i,o){var a=n&COMPARE_PARTIAL_FLAG$3,l=t.length,r=e.length;if(l!=r&&!(a&&r>l))return!1;var m=o.get(t),g=o.get(e);if(m&&g)return m==e&&g==t;var u=-1,c=!0,C=n&COMPARE_UNORDERED_FLAG$1?new SetCache:void 0;for(o.set(t,e),o.set(e,t);++u<l;){var f=t[u],h=e[u];if(s)var p=a?s(h,f,u,e,t,o):s(f,h,u,t,e,o);if(void 0!==p){if(p)continue;c=!1;break}if(C){if(!arraySome(e,(function(t,e){if(!cacheHas(C,e)&&(f===t||i(f,t,n,s,o)))return C.push(e)}))){c=!1;break}}else if(f!==h&&!i(f,h,n,s,o)){c=!1;break}}return o.delete(t),o.delete(e),c}var _equalArrays=equalArrays$2;function mapToArray$1(t){var e=-1,n=Array(t.size);return t.forEach((function(t,s){n[++e]=[s,t]})),n}var _mapToArray=mapToArray$1;function setToArray$1(t){var e=-1,n=Array(t.size);return t.forEach((function(t){n[++e]=t})),n}var _setToArray=setToArray$1,Symbol$2=_Symbol,Uint8Array$1=_Uint8Array,eq=eq_1,equalArrays$1=_equalArrays,mapToArray=_mapToArray,setToArray=_setToArray,COMPARE_PARTIAL_FLAG$2=1,COMPARE_UNORDERED_FLAG=2,boolTag="[object Boolean]",dateTag="[object Date]",errorTag="[object Error]",mapTag="[object Map]",numberTag="[object Number]",regexpTag="[object RegExp]",setTag="[object Set]",stringTag="[object String]",symbolTag="[object Symbol]",arrayBufferTag="[object ArrayBuffer]",dataViewTag="[object DataView]",symbolProto=Symbol$2?Symbol$2.prototype:void 0,symbolValueOf=symbolProto?symbolProto.valueOf:void 0;function equalByTag$1(t,e,n,s,i,o,a){switch(n){case dataViewTag:if(t.byteLength!=e.byteLength||t.byteOffset!=e.byteOffset)return!1;t=t.buffer,e=e.buffer;case arrayBufferTag:return!(t.byteLength!=e.byteLength||!o(new Uint8Array$1(t),new Uint8Array$1(e)));case boolTag:case dateTag:case numberTag:return eq(+t,+e);case errorTag:return t.name==e.name&&t.message==e.message;case regexpTag:case stringTag:return t==e+"";case mapTag:var l=mapToArray;case setTag:var r=s&COMPARE_PARTIAL_FLAG$2;if(l||(l=setToArray),t.size!=e.size&&!r)return!1;var m=a.get(t);if(m)return m==e;s|=COMPARE_UNORDERED_FLAG,a.set(t,e);var g=equalArrays$1(l(t),l(e),s,i,o,a);return a.delete(t),g;case symbolTag:if(symbolValueOf)return symbolValueOf.call(t)==symbolValueOf.call(e)}return!1}var _equalByTag=equalByTag$1,getAllKeys=_getAllKeys,COMPARE_PARTIAL_FLAG$1=1,objectProto$2=Object.prototype,hasOwnProperty$2=objectProto$2.hasOwnProperty;function equalObjects$1(t,e,n,s,i,o){var a=n&COMPARE_PARTIAL_FLAG$1,l=getAllKeys(t),r=l.length;if(r!=getAllKeys(e).length&&!a)return!1;for(var m=r;m--;){var g=l[m];if(!(a?g in e:hasOwnProperty$2.call(e,g)))return!1}var u=o.get(t),c=o.get(e);if(u&&c)return u==e&&c==t;var C=!0;o.set(t,e),o.set(e,t);for(var f=a;++m<r;){var h=t[g=l[m]],p=e[g];if(s)var d=a?s(p,h,g,e,t,o):s(h,p,g,t,e,o);if(!(void 0===d?h===p||i(h,p,n,s,o):d)){C=!1;break}f||(f="constructor"==g)}if(C&&!f){var y=t.constructor,H=e.constructor;y==H||!("constructor"in t)||!("constructor"in e)||"function"==typeof y&&y instanceof y&&"function"==typeof H&&H instanceof H||(C=!1)}return o.delete(t),o.delete(e),C}var _equalObjects=equalObjects$1,Stack=_Stack,equalArrays=_equalArrays,equalByTag=_equalByTag,equalObjects=_equalObjects,getTag=_getTag,isArray$1=isArray_1,isBuffer=isBuffer$3.exports,isTypedArray=isTypedArray_1,COMPARE_PARTIAL_FLAG=1,argsTag="[object Arguments]",arrayTag="[object Array]",objectTag$1="[object Object]",objectProto$1=Object.prototype,hasOwnProperty$1=objectProto$1.hasOwnProperty;function baseIsEqualDeep$1(t,e,n,s,i,o){var a=isArray$1(t),l=isArray$1(e),r=a?arrayTag:getTag(t),m=l?arrayTag:getTag(e),g=(r=r==argsTag?objectTag$1:r)==objectTag$1,u=(m=m==argsTag?objectTag$1:m)==objectTag$1,c=r==m;if(c&&isBuffer(t)){if(!isBuffer(e))return!1;a=!0,g=!1}if(c&&!g)return o||(o=new Stack),a||isTypedArray(t)?equalArrays(t,e,n,s,i,o):equalByTag(t,e,r,n,s,i,o);if(!(n&COMPARE_PARTIAL_FLAG)){var C=g&&hasOwnProperty$1.call(t,"__wrapped__"),f=u&&hasOwnProperty$1.call(e,"__wrapped__");if(C||f){var h=C?t.value():t,p=f?e.value():e;return o||(o=new Stack),i(h,p,n,s,o)}}return!!c&&(o||(o=new Stack),equalObjects(t,e,n,s,i,o))}var _baseIsEqualDeep=baseIsEqualDeep$1,baseIsEqualDeep=_baseIsEqualDeep,isObjectLike$1=isObjectLike_1;function baseIsEqual$1(t,e,n,s,i){return t===e||(null==t||null==e||!isObjectLike$1(t)&&!isObjectLike$1(e)?t!=t&&e!=e:baseIsEqualDeep(t,e,n,s,baseIsEqual$1,i))}var _baseIsEqual=baseIsEqual$1,baseIsEqual=_baseIsEqual;function isEqual(t,e){return baseIsEqual(t,e)}var isEqual_1=isEqual,lodashIsEqual=isEqual_1;function isEditedHSQC(t){return t.info.pulseSequence.includes("hsqced")}function getSignals2D(t){const e={};return Object.keys(t).forEach((n=>{const s=[],i=[],o=[];t[n].forEach(((t,e)=>{const n=t;o.some((t=>lodashIsEqual(t,n.info.nucleus)))||(o.push(n.info.nucleus),i.push(e))})),i.forEach((e=>{const i=t[n][e],o=i.info.nucleus.map((t=>getAtomTypeFromNucleus(t)));i.zones.values.map((t=>t.signals.filter((t=>t.kind&&allowedSignalKinds.includes(t.kind))))).flat().forEach((t=>{s.some((e=>checkMatch(e.signal.x.delta,t.x.delta,0)&&checkMatch(e.signal.y.delta,t.y.delta,0)))||s.push({experimentType:n,experimentID:i.id,atomType:o,signal:{...lodashCloneDeep(t),sign:isEditedHSQC(i)&&t.peaks?t.peaks[0].z>=0?1:-1:0}})}))})),e[n]=s})),e}function getSignalsDEPT(t){const e={};return Object.keys(t).filter((t=>"dept"===t)).forEach((n=>t[n].forEach((t=>{const s=t,i=[],o=s.info.pulseSequence.match(/\d/g);if(o){const t=o.reduce(((t,e)=>t+e)),a=getAtomTypeFromNucleus(s.info.nucleus);s.ranges.values.map((t=>t.signals.filter((t=>t.kind&&allowedSignalKinds.includes(t.kind))).map((e=>({...e,sign:t.absolute>0?1:-1}))))).flat().forEach((e=>{i.some((t=>checkMatch(t.signal.delta,e.delta,0)))||i.push({experimentType:n,experimentID:s.id,mode:t,atomType:a,signal:lodashCloneDeep(e)})})),e[t]=i}})))),e}function getSignals(t){const e=getExperiments(t),n=getExperiments1D(e),s=getExperiments1DExtra(e),i=getExperiments2D(e);return{signals1D:getSignals1D(n),signals2D:getSignals2D(i),signalsDEPT:getSignalsDEPT(s)}}const BASE62="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ",LENGTH=8;function generateID(){let t="";for(let e=0;e<LENGTH;e++)t+=BASE62.charAt(Math.floor(62*Math.random()));return t}function buildLink(t){return{id:t.id||generateID(),experimentType:t.experimentType,experimentID:t.experimentID,atomType:t.atomType,signal:t.signal,axis:t.axis,match:t.match||[],experimentLabel:t.experimentLabel||"",pseudo:t.pseudo||!1,edited:t.edited||{}}}function findLinkedCorrelationsBySignalID(t,e){return t.filter((t=>t.link.some((t=>t.signal.id===e))))}function containsLink(t,e){return t.link.some((t=>t.experimentType===e.experimentType&&t.experimentID===e.experimentID&&lodashIsEqual(t.atomType,e.atomType)&&t.signal.id===e.signal.id&&t.axis===e.axis))}function hasLinks(t){return t.link.length>0}function addSignal(t,e,n,s){if(0===t.length){const t=buildCorrelation({atomType:e});addLink(t,n);const i=s.findIndex((t=>t.atomType===e&&t.pseudo&&!hasLinks(t)));i>=0?s[i]=t:s.push(t)}else containsLink(s[t[0]],n)||addLink(s[t[0]],n)}function addFromData(t,e,n,s){return t=t.filter((t=>t.link.length>0||t.pseudo)),Object.keys(e).forEach((n=>{e[n].forEach((e=>{if(0===findLinkedCorrelationsBySignalID(t,e.signal.id||"").length){const i=t.map(((t,i)=>{const o=getCorrelationDelta(t);return!t.pseudo&&t.atomType===n&&void 0!==o&&checkMatch(o,e.signal.delta,s[n])?i:-1})).filter((t=>t>=0)).filter(((t,e,n)=>n.indexOf(t)===e)),o=buildLink({experimentType:e.experimentType,experimentID:e.experimentID,signal:e.signal,atomType:[n]});addSignal(i,n,o,t)}}))})),Object.keys(n).forEach((e=>n[e].forEach((e=>{0===findLinkedCorrelationsBySignalID(t,e.signal.id||"").length&&e.atomType.forEach(((n,i)=>{const o=0===i?"x":"y",a=t.map(((t,i)=>{const a=getCorrelationDelta(t);return!t.pseudo&&t.atomType===n&&void 0!==a&&checkMatch(a,e.signal[o].delta,s[n])?i:-1})).filter((t=>t>=0)).filter(((t,e,n)=>n.indexOf(t)===e)),l=buildLink({experimentType:e.experimentType,experimentID:e.experimentID,signal:e.signal,axis:o,atomType:e.atomType});addSignal(a,n,l,t)}))})))),t}function buildCorrelation(t){return{id:t.id||generateID(),atomType:t.atomType,label:t.label||{},link:t.link||[],equivalence:t.equivalence||1,attachment:t.attachment||{},protonsCount:t.protonsCount||[],hybridization:t.hybridization||[],pseudo:t.pseudo||!1,edited:t.edited||{}}}function addPseudoCorrelations(t,e){for(const n in e){for(let s=getCorrelationsByAtomType(t,n).reduce(((t,e)=>t+e.equivalence),0);s<e[n];s++)t.push(buildCorrelation({atomType:n,pseudo:!0}))}return t}function removeLink(t,e){return t.link=t.link.filter((t=>t.id!==e)),t}function removeMatch(t,e){const n=t.match.indexOf(e);return n>=0&&t.match.splice(n,1),t}function checkPseudoCorrelations(t,e){for(const n in e){const s=getCorrelationsByAtomType(t,n);if(s.length>e[n]){const i=s.filter((t=>t.pseudo&&1===t.equivalence&&!hasLinks(t)));for(let o=s.length-1;o>=e[n]&&0!==i.length;o--){const e=i.pop();e&&t.splice(t.indexOf(e),1)}}}for(const e of t){if(!e.pseudo||e.equivalence>1||hasLinks(e))continue;const n=[],s=getCorrelationIndex(t,e);for(const i of e.link){for(const e of i.match)t[e]&&t[e].link.some((t=>t.match.includes(s)))||removeMatch(i,e);0===i.match.length&&n.push(i)}for(const t of n)removeLink(e,t.id);e.edited.protonsCount||e.link.some((t=>"hsqc"===t.experimentType))||(e.protonsCount=[])}return Object.keys(e).length>0?t.filter((t=>Object.keys(e).includes(t.atomType))):t}function replacePseudoCorrelationsByEquivalences(t,e){for(const n in e){const s=getCorrelationsByAtomType(t,n),i=s.filter((t=>!t.pseudo||t.equivalence>1||hasLinks(t))),o=i.reduce(((t,e)=>t+(e.equivalence-1)),0),a=s.filter((t=>t.pseudo&&!i.some((e=>e.id===t.id))));for(let i=0;i<s.length-(e[n]-o)&&0!==a.length;i++){const e=a.pop();e&&t.splice(t.indexOf(e),1)}}return t}function updatePseudoCorrelations(t,e){const n=getAtomCounts(e);return 0===Object.keys(n).length&&(t=t.filter((t=>!t.pseudo))),t=checkPseudoCorrelations(t=replacePseudoCorrelationsByEquivalences(t=addPseudoCorrelations(t,n),n),n)}function removeObsoleteLinksAndNotLinkedCorrelations(t,e,n){const s=t.filter((t=>!t.pseudo)),i=s.slice();return s.forEach((t=>{for(const s of t.link)if("1d"===s.experimentType)if(lodashGet(e,s.atomType[0],[]).some((t=>t.signal.id===s.signal.id))){const e=i.indexOf(t);e>=0&&i.splice(e,1)}else s.pseudo||removeLink(t,s.id);else if(lodashGet(n,`${s.experimentType}`,[]).some((t=>t.signal.id===s.signal.id))){const e=i.indexOf(t);e>=0&&i.splice(e,1)}else s.pseudo||removeLink(t,s.id)})),i.forEach((e=>{const n=t.indexOf(e);n>=0&&t.splice(n,1)})),t}function hasAttachmentAtomType(t,e){return Boolean(t.attachment[e]&&t.attachment[e].length>0)}function addAttachmentAtomType(t,e){return hasAttachmentAtomType(t,e)||(t.attachment[e]=[]),t}function addAttachment(t,e,n){return addAttachmentAtomType(t,e),t.attachment[e].includes(n)||t.attachment[e].push(n),t}function removeAttachments(t){return t.attachment={},t}function setAttachmentsAndProtonEquivalences(t){for(const e of t){removeAttachments(e);const t=e.link.filter((t=>"hsqc"===t.experimentType||"hmqc"===t.experimentType));for(const n of t){const t=n.atomType["x"===n.axis?1:0];for(let s of n.match)addAttachment(e,t,s)}}for(const e of t)"H"===e.atomType&&(e.equivalence=0);for(const e of t)if("H"!==e.atomType&&1===e.protonsCount.length&&hasAttachmentAtomType(e,"H")){const{equivalence:n,protonsCount:s}=e;let i=1;3===s[0]?i=3:2===s[0]&&(i=2);const o=n*i/e.attachment.H.length;for(const n of e.attachment.H)t[n].equivalence+=o}for(const e of t)"H"===e.atomType&&0===e.equivalence&&(e.equivalence=1);return t}function setLabels(t){const e={};return t.forEach((t=>{lodashGet(e,t.atomType,!1)||(e[t.atomType]=0),e[t.atomType]++,t.label.origin=`${t.atomType}${e[t.atomType]}`})),t}function addMatch(t,e){return t.match.includes(e)||t.match.push(e),t}function removeMatches(t){return t.match=[],t}function setMatches(t){return t.forEach((e=>{e.link.forEach((n=>{removeMatches(n);const s="x"===n.axis?n.atomType[1]:n.atomType[0];getCorrelationsByAtomType(t,s).forEach((s=>{if(e.id!==s.id){const e=getCorrelationIndex(t,s);s.link.forEach((t=>{t.experimentType===n.experimentType&&t.experimentID===n.experimentID&&lodashIsEqual(t.atomType,n.atomType)&&t.signal.id===n.signal.id&&t.axis!==n.axis&&addMatch(n,e)}))}}))}))})),t.forEach((t=>{t.link.filter((t=>{var e;return 0===t.match.length&&"1d"!==t.experimentType&&!(null===(e=t.edited)||void 0===e?void 0:e.moved)})).forEach((e=>removeLink(t,e.id)))})),t}function sortCorrelations(t){const e=(t,e)=>{if(!t.pseudo&&!e.pseudo&&t.link.length>0&&e.link.length>0){const n=getCorrelationDelta(t),s=getCorrelationDelta(e);if(void 0!==n&&void 0!==s){if(n<s)return-1;if(n>s)return 1}}return!t.pseudo&&e.pseudo?-1:t.pseudo&&!e.pseudo?1:t.label.origin<e.label.origin?-1:t.label.origin>e.label.origin?1:0};let n=[];const s=t.map((t=>t.atomType)).filter(((t,e,n)=>n.indexOf(t)===e));return s.sort(((t,e)=>"C"===t?-1:"C"===e?1:"H"===t?-1:"H"===e?1:t<e?-1:t>e?1:0)),s.forEach((s=>{const i=getCorrelationsByAtomType(t,s);i.sort(e),n=n.concat(i)})),n}function buildValues(t,e){const{tolerance:n={},mf:s="",values:i=[]}=e,o=getSignals(t);let a=i?i.slice():[];return!0!==e.skipDataUpdate?(a=removeObsoleteLinksAndNotLinkedCorrelations(a,o.signals1D,o.signals2D),a=addFromData(a,o.signals1D,o.signals2D,n)):a=a.filter((t=>t.link.length>0||t.pseudo)),a=setProtonsCountFromData(a,o.signalsDEPT,o.signals2D,n),a=sortCorrelations(a),setMatches(a),setAttachmentsAndProtonEquivalences(a),a=updatePseudoCorrelations(a,s),setLabels(a),a}function buildCorrelationData(t,e){const n=t?buildValues(t,e):[];return delete e.values,delete e.skipDataUpdate,{values:n,options:e,state:buildState(n,e.mf||"")}}function addLink(t,e){return t.link.push(e),t}function createMapPossibleAssignment(t,e){const{restrictionByCS:n,predictions:s,targets:i}=e,{tolerance:o,chemicalShiftRestriction:a}=n,l=Object.keys(s);for(const e of l){let n=o[e],l=s[e],r=i[e];t[e]||(t[e]={});for(const s in l){let i=l[s];if(t[e][s]=[],r)for(const o in r){let l=r[o];const{nbAtoms:m,protonsCount:g}=i,{integration:u,protonsCount:c}=l;if(!u||("H"===e?m-u<1:!(c.length>0)||c.some((t=>g===t))))if(a&&void 0!==i.delta){let a=getCorrelationDelta(l);if(void 0===a)throw new Error("Correlation has not delta");Math.abs(i.delta-a-n)<4*n&&t[e][s].push(o)}else t[e][s].push(o)}t[e][s].push("*")}}return t}function groupCarbonTargetByIntegrationZone(t,e,n){let s=t[0],{H:i=[]}=e[s].attachment,o=[{targetIDs:[s],attachments:new Set(i)}];for(let n=1;n<t.length;n++){let s=t[n],i=e[s],{H:a=[]}=i.attachment,l=!0;for(let t of o){if(a.some((e=>t.attachments.has(e)))){l=!1,t.targetIDs.push(s);for(let e of a)t.attachments.add(e);break}}l&&o.push({targetIDs:[s],attachments:new Set(a)})}return o.map((t=>({atomType:"C",targetIDs:t.targetIDs,integration:n?Array.from(t.attachments).reduce(((t,e)=>n[e].integration+t),0):0})))}function partialScore(t,e){const{diaIDPeerPossibleAssignment:n,infoByAtomTypes:s,restrictionByCS:i,predictions:o,targets:a,correlations:l}=e,{tolerance:r,useChemicalShiftScore:m}=i;let g=0,u=0,c={},C={};const f=Object.keys(t);for(const e of f){let i=0;const{nbAllowedUnAssigned:o}=s[e],a={},l=t[e]||[];c[e]=a,C[e]=[],u+=l.length;for(let t=0;t<l.length;t++){const s=l[t];s&&"*"!==s&&(C[e].push(t),a[s]||(a[s]=[]),a[s].push(n[e][t])),"*"===s&&i++}if(i>o)return 0;g+=i}const h={};for(const t in c)h[t]=Object.keys(c[t]);const p=Object.values(h);if(p.reduce(((t,e)=>0===e.length?t+1:t),0)===p.length)return 0;const d=getPrediction.bind({},o),y=[];for(const e in t)if("C"===e&&h[e].length>0)y.push(...groupCarbonTargetByIntegrationZone(h[e],a[e],l));else for(let t of h[e])y.push({atomType:e,targetIDs:[t],integration:a.H[t].integration});for(const t of y){const{integration:e,atomType:n}=t;if(void 0===e||isNaN(e))continue;let s=0;for(let e of t.targetIDs){let t=c[n][e];for(const e of t){const{prediction:t,atomType:i}=d(e);n===i&&(s+=t.allHydrogens)}}if(s-e>=5)return 0}let H=1,v=1;if(m){v=0,H=0;for(const e of Object.keys(t)){const s=t[e],i=a[e];for(let t=0;t<s.length;t++){const a=s[t];if(a&&"*"!==a){H++;let s=n[e][t],l=o[e][s],m=i[a],g=r[e];if(void 0===l.delta)v+=1;else{const t=getCorrelationDelta(m);if(void 0===t)throw new Error("correlation has not delta");let e=Math.abs(l.delta-t);e<g?v+=1:(e=Math.abs(e-g),v+=-.25/g*e+1)}}}}H>0&&(v/=H)}let b=0;if(howManyActived(h)>1){let e={},s=[];for(const t of Object.keys(C))s=s.concat(C[t].map((e=>({index:e,atomType:t}))));for(let i=0;i<s.length;i++){const{atomType:l,index:r}=s[i],m=o[l][n[l][r]];for(let g=i+1;g<s.length;g++){const{atomType:i,index:u}=s[g],c=o[i][n[i][u]];let C=m.pathLength[c.diaIDIndex]<5,f=t[l][r],h=t[i][u];if(!f||!h)continue;let p=f>h?`${h} ${f}`:`${f} ${h}`,d=checkLinking({from:{targetID:f,atomType:l},to:{targetID:h,atomType:i}},a),y=C?d?1:0:d?0:1;e[p]=e[p]?Math.max(e[p],y):y}}let i=0;for(let t in e)i+=e[t];b=i/(s.length*(s.length-1)/2)}const w=g/u;return 0===v?b-w:0===b?v-w:(v+b)/2-w}function checkLinking(t,e){const{from:n,to:s}=t;if(n.targetID===s.targetID)return!0;let i=e[n.atomType][n.targetID],o=e[s.atomType][s.targetID];for(const t of o.link)for(const e of i.link)if(e.signal.id===t.signal.id)return!0;return!1}function getPrediction(t,e){const n=Object.keys(t);for(const s of n){const n=t[s];if(!n)throw new Error(`prediction by ${s}`);if(n[e])return{atomType:s,prediction:n[e]}}throw new Error(`There is not prediction for ${e}`)}function howManyActived(t){let e=0;for(const n in t)e+=t[n].length;return e}function exploreTree(t,e,n,s){const{currentAtomTypes:i,restrictionByCS:o,timeout:a,timeStart:l,maxSolutions:r,targets:m,predictions:g,correlations:u,lowerBoundScore:c,possibleAssignmentMap:C,diaIDPeerPossibleAssignment:f}=t;if(Date.now()-l>a)return s;for(const t of i){const{currentIndex:h,nSources:p}=e[t];if(h>=p-1&&null!==n[t][h])continue;const d=f[t][h],y=C[t][d];for(let p of y){n[t][h]=p;let d=partialScore(n,{diaIDPeerPossibleAssignment:f,infoByAtomTypes:e,restrictionByCS:o,predictions:g,correlations:u,targets:m});if(0!==d)if(isLastOne(i,e)&&d>=c)addSolution(s,{predictions:g,partial:n,score:d,maxSolutions:r});else{const h=JSON.parse(JSON.stringify(e));h[t].currentIndex+=1,exploreTree({currentAtomTypes:i,restrictionByCS:o,timeout:a,timeStart:l,maxSolutions:r,targets:m,predictions:g,correlations:u,lowerBoundScore:c,possibleAssignmentMap:C,diaIDPeerPossibleAssignment:f},h,JSON.parse(JSON.stringify(n)),s)}}}}function addSolution(t,e){let{score:n,maxSolutions:s,partial:i,predictions:o}=e;n/=doubleAssignmentPenalty(i,o);let a={assignment:JSON.parse(JSON.stringify(i)),score:n};t.nSolutions>=s?a.score>t.solutions.last().score&&(t.solutions.pollLast(),t.solutions.add(a)):(t.solutions.add(a),t.nSolutions++)}function isLastOne(t,e){let n=!0;for(const s of t){const{currentIndex:t,nSources:i}=e[s];n=n&&t>=i-1}return n}function doubleAssignmentPenalty(t,e){let n=0;for(const s in e){n+=Object.keys(e[s]).length-new Set(t[s]).size}return n>0?2*n:1}function isSpectraData1D(t){return"ranges"in t}function searchIndices(t,e){for(let n=0;n<e.length;n++){const s=e[n],i=isSpectraData1D(s)?s.ranges:s.zones;for(let e=0;e<i.length;e++){const s=i[e].signals||[];for(let i=0;i<s.length;i++)if(t===s[i].id)return{spectrumIndex:n,signalIndex:i,elementIndex:e}}}throw new Error(`There is not a signal with ${t} ID`)}const comparator=(t,e)=>e.score-t.score,predictor={H:predictProton,C:predictCarbon};function checkNMRSignal1D(t){const e=["nbAtoms","diaIDs","atoms"];for(const n of t)for(let t of e)if(!n[t])throw new Error(`property ${t} does not exist`)}const getAllHydrogens={C:(t,e)=>t.getAllHydrogens(e),H:()=>1};async function buildAssignments(t){const{spectra:e,molecule:n,restrictionByCS:s,timeout:i,minScore:o,nbAllowedUnAssigned:a={},maxSolutions:l,correlations:r,assignmentOrder:m,predictionOptions:g,predictions:u={},targets:c}=t;let C=o,f={solutions:new TreeSet$1(comparator),nSolutions:0};const h=getConnectivityMatrix(n,{pathLength:!0});let p={};const d={};let y={},H={};for(const t of m){for(const e of t){const t=g[e],s=u[e];let{joinedSignals:i}=s?{joinedSignals:s}:await predictor[e](n,t);checkNMRSignal1D(i),d[e]||(d[e]={});let o=0;for(let t of i){const s=t.diaIDs[0],i=t.atoms[0],a=getAllHydrogens[e](n,i);o+=t.nbAtoms*a,d[e][s]={...t,diaIDIndex:i,allHydrogens:t.nbAtoms*a,protonsCount:a,pathLength:h[i]}}for(let t in d[e])d[e][t].allHydrogens*=100/o;p[e]={nSources:i.length,currentIndex:0,nbAllowedUnAssigned:a[e]||0}}y=createMapPossibleAssignment(y,{restrictionByCS:s,predictions:d,targets:c}),H={};for(const t in y)H[t]=Object.keys(y[t]);let e=getSourceOfPartials(f,p,t);f={solutions:new TreeSet$1(comparator),nSolutions:0};const o=Date.now();for(let n of e)exploreTree({currentAtomTypes:t,restrictionByCS:s,timeout:i,timeStart:o,targets:c,predictions:d,correlations:r,maxSolutions:l,lowerBoundScore:C,possibleAssignmentMap:y,diaIDPeerPossibleAssignment:H},p,n,f)}return annotateSpectraData({store:f,spectra:e,diaIDPeerPossibleAssignment:H,targets:c})}function annotateSpectraData(t){const{store:e,spectra:n,diaIDPeerPossibleAssignment:s,targets:i}=t,{solutions:o}=e,a={},l=Object.keys(i);for(const t of l){const e=i[t];for(const t in e){let s=e[t];for(const t of s.link){const e=t.signal.id;a[e]||(a[t.signal.id]=searchIndices(e,n))}}}const r=[];for(let t of o.elements){const e=JSON.parse(JSON.stringify(n)),{assignment:o,score:l}=t,m=Object.keys(o);for(const t of m){const n=i[t],l=o[t];for(let i=0;i<l.length;i++){const o=l[i];if("*"===o||!o)continue;const r=n[o],m=s[t][i];for(let t of r.link){const{spectrumIndex:n,elementIndex:s,signalIndex:i}=a[t.signal.id],o=e[n];if(isSpectraData1D(o)){let{ranges:t}=o,e=t[s].signals[i];if(e.diaIDs||(e.diaIDs=[]),e.diaIDs.includes(m))continue;e.diaIDs.push(m)}else{const e=t.axis,n=o.zones[s].signals[i];if(n[e].diaIDs||(n[e].diaIDs=[]),n[e].diaIDs?.includes(m))continue;n[e].diaIDs?.push(m)}}}}r.push({score:l,assignment:e})}return r}function getSourceOfPartials(t,e,n){return t.nSolutions>0?t.solutions.elements.map((t=>{let s=t.assignment;for(const t of n)s[t]=fillPartial(e[t].nSources);return s})):initializePartials(e,n)}function initializePartials(t,e){const n={},s=Object.keys(t);for(const i of s){const s=e.includes(i)?null:"*";n[i]=fillPartial(t[i].nSources,s)}return[n]}function fillPartial(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;const n=new Array(t);for(let s=0;s<t;s++)n[s]=e;return n}function checkIDs(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=JSON.parse(JSON.stringify(t)),n=[];for(const t of e){if(!("info"in t))throw new Error("each spectrum should contain info properties with nucleus information");const{info:e,id:s}=t;if(isSpectraData1D(t)){let i=addIDs(t.ranges);n.push({id:s,info:e,ranges:i})}else{let i=addIDs(t.zones);n.push({id:s,info:e,zones:i})}}return n}function hasIDs(t){for(const e of t){if(!e.id)throw new Error("A range/zone has not an ID");for(let t of e.signals||[])if(!t.id)throw new Error("A signal has not an ID")}}function addIDs(t){for(const e of t){e.id||(e.id=v4());for(let t of e.signals||[])t.id||(t.id=v4())}return hasIDs(t),t}function formatData(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=JSON.parse(JSON.stringify(t)),n=[];for(const t of e){const{id:e,info:s}=t;if(isSpectraData1D(t)){const i=rescaleIntegration({id:e,info:s,ranges:t.ranges});n.push({id:e,info:s,ranges:{values:i}})}else n.push({id:e,info:s,zones:{values:t.zones}})}return n}function rescaleIntegration(t){if("1H"!==t.info.nucleus)return t.ranges;let e=t.ranges.reduce(((t,e)=>e.integration?t+e.integration:t),0);for(let n of t.ranges)if(n.integration&&(n.integration*=100/e,n.signals)){const t=n.signals.reduce(((t,e)=>e.integration?t+e.integration:t),0);for(let e of n.signals)e.integration?e.integration*=n.integration/t:e.integration=n.integration}return t.ranges}function getIntegrationOfAttachedProtons(t,e){const{H:n=[]}=t.attachment;let s=0;for(const t of n){const n=e[t];s+=Number(n.link[0].signal.integration)}return s}function getTargetsAndCorrelations(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{tolerance:n={C:.25,H:.05}}=e,s=formatData(t),{values:i}=buildCorrelationData(s,{tolerance:n});let o={};for(const t of i){if(t.pseudo)continue;const{id:e,atomType:n}=t;o[n]||(o[n]={}),o[n][e]=t,o[n][e].integration="H"===n?t.link[0].signal.integration:getIntegrationOfAttachedProtons(t,i)}return{targets:o,correlations:i}}function getWorkFlow(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];const n=extractExperimentType(t),{hasHSQC:s,types:i}=n;if(e.length>0)return{assignmentOrder:e,experimentTypes:n};const o=[];return s?o.push(["C"],["H"]):o.push(i.filter((t=>"H"===t||"C"===t))),{assignmentOrder:o,experimentTypes:n}}function extractExperimentType(t){const e=[];for(const n of t){let t=n.experimentType;"1d"===t&&(t=`${n.atomType.toUpperCase()}`),e.includes(t)||e.push(t);for(const s of n.link)t=s.experimentType,"1d"===t&&(t=`${s.atomType[0].toUpperCase()}`),e.includes(t)||e.push(t)}return{types:e,hasProton:e.includes("H"),hasCarbon:e.includes("C"),hasHSQC:e.includes("hsqc")}}async function getAssignments(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{restrictionByCS:n={},justAssign:s,minScore:i=.01,maxSolutions:o=10,nbAllowedUnAssigned:a,timeout:l=6e3,predictionOptions:r={},predictions:m={},correlation:g={}}=e;const{tolerance:u={H:.2,C:1},useChemicalShiftScore:c=!1,chemicalShiftRestriction:C=!0}=n,f=t.molecule;if(!f)throw new Error("It is needed a molecule to assign");f.addImplicitHydrogens(),addDiastereotopicMissingChirality(f);const h=checkIDs(t.spectra),{targets:p,correlations:d}=getTargetsAndCorrelations(h,g),{assignmentOrder:y}=getWorkFlow(d,s);return await buildAssignments({restrictionByCS:{tolerance:u,useChemicalShiftScore:c,chemicalShiftRestriction:C},spectra:h,molecule:f,timeout:l,minScore:i,maxSolutions:o,assignmentOrder:y,nbAllowedUnAssigned:a,correlations:d,targets:p,predictionOptions:r,predictions:m})}function selectACSPattern(t){const e=couplingValues[t];if(!e)throw new Error(`multiplicity pattern ${t} is not supported`);return couplingACSPatterns[e]}function signalMultiplicityPattern(t,e){let n=t.js,s="";if(n&&n.length>0)for(let t of n){const{multiplicity:n=""}=t;s+=e?.acsFormat?selectACSPattern(n):n}else s=t.delta?"":"m";return s}const globalOptions={h:{nucleus:"1H",nbDecimalDelta:2,nbDecimalJ:1,observedFrequency:400},c:{nucleus:"13C",nbDecimalDelta:1,nbDecimalJ:1,observedFrequency:100},f:{nucleus:"19F",nbDecimalDelta:2,nbDecimalJ:1,observedFrequency:400}};function rangesToACS(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};e.nucleus||(e.nucleus="1H");const n=e.nucleus.toLowerCase().replace(/[0-9]/g,"");e={...globalOptions[n],ascending:!1,format:"IMJA",...e},t=JSON.parse(JSON.stringify(t)),!0===e.ascending&&t.sort(((t,e)=>Math.min(t.from,t.to)-Math.min(e.from,e.to)));let s=formatAcs(t,e);return s.length>0&&(s+="."),s}function formatAcs(t,e){let n=spectroInformation(e);0===n.length&&(n="δ ");const s=[];for(const n of t)uselessKind(n.kind,e.filter)||pushDelta(n,s,e);return s.length>0?n+s.join(", "):""}function spectroInformation(t){const e=[];let n=`${formatNucleus(t.nucleus)} NMR`;return t.solvent&&e.push(formatMF(t.solvent)),t.observedFrequency&&e.push(`${(1*t.observedFrequency).toFixed(0)} MHz`),e.length>0?n+=` (${e.join(", ")}): δ `:n+=": δ ",n}function pushDelta(t,e,n){let s="",i=[];const o=[t.from,t.to];if(t.signals&&(t.signals=t.signals.filter((t=>!uselessKind(t.kind,n.filter)))),t.signals&&t.signals.length>0){let e=t.signals;if(e.length>1){if(!0===n.ascending&&e.sort(((t,e)=>t.delta-e.delta)),s+=`${Math.min(...o).toFixed(n.nbDecimalDelta)}-${Math.max(...o).toFixed(n.nbDecimalDelta)}`,s+=` (${getIntegral(t,n)}`,e.some((t=>t.multiplicity||t.js&&t.js.length>0)))for(let t of e){i=[],void 0!==t.delta&&(s=appendSeparator(s),s+=t.delta.toFixed(n.nbDecimalDelta));switchFormat({from:Number.MIN_SAFE_INTEGER,to:Number.MAX_SAFE_INTEGER},t,i,n),i.length>0&&(s+=` (${i.join(", ")})`)}s+=")"}else i=[],void 0!==e[0].delta?(s+=e[0].delta.toFixed(n.nbDecimalDelta),switchFormat(t,e[0],i,n),i.length>0&&(s+=` (${i.join(", ")})`)):(s+=`${Math.min(...o).toFixed(n.nbDecimalDelta)}-${Math.max(...o).toFixed(n.nbDecimalDelta)}`,switchFormat(t,e[0],i,n),i.length>0&&(s+=` (${i})`))}else{s+=`${Math.min(...o).toFixed(n.nbDecimalDelta)}-${Math.max(...o).toFixed(n.nbDecimalDelta)}`;switchFormat(t,{},i,n),i.length>0&&(s+=` (${i.join(", ")})`)}e.push(s)}function getIntegral(t,e){let n="";if(t.pubIntegral)n=String(t.pubIntegral);else if(t.integration){const{nucleus:s}=e;n=t.integration.toFixed(0)+s[s.length-1]}return n}function pushIntegral(t,e,n){let s=getIntegral(t,n);s.length>0&&e.push(s)}function pushmultiplicityFromSignal(t,e){let n=t.multiplicity;if(!n){n=signalMultiplicityPattern(signalJoinCouplings(t,{acsFormat:!0,tolerance:.05,ignoreDiaIDs:!0}))}n.length>0&&e.push(n)}function switchFormat(t,e,n,s){for(const i of s.format)switch(i.toUpperCase()){case"I":pushIntegral(t,n,s);break;case"M":pushmultiplicityFromSignal(e,n);break;case"A":pushAssignment(e,n);break;case"J":pushCoupling(e,n,s);break;default:throw new Error(`Unknow format letter: ${i}`)}}function formatMF(t){return t.replace(/(?<num>[0-9]+)/g,"<sub>$<num></sub>")}function formatNucleus(t){return t.replace(/(?<num>[0-9]+)/g,"<sup>$<num></sup>")}function appendSeparator(t){return t.length>0&&!/ $/.exec(t)&&!/\($/.exec(t)&&(t+=", "),t}function formatAssignment(t){return t=(t=t.replace(/(?<num>[0-9]+)/g,"<sub>$<num></sub>")).replace(/"(?<i>[^"]*)"/g,"<i>$<i></i>")}function pushCoupling(t,e,n){if(Array.isArray(t.js)&&t.js.length>0){t.js.sort(((t,e)=>e.coupling-t.coupling));let s=[];for(let e of t.js)void 0!==e.coupling&&s.push(e.coupling.toFixed(n.nbDecimalJ));s.length>0&&e.push(`<i>J</i> = ${s.join(", ")} Hz`)}}function pushAssignment(t,e){t.assignment&&e.push(formatAssignment(t.assignment))}function uselessKind(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",e=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return t=t.toLowerCase(),!(!e||"impurity"!==t&&"solvent"!==t)}function addDummySignals(t){let e=JSON.parse(JSON.stringify(t)),n=t.reduce(((t,e)=>{const{atoms:n=[]}=e;return Math.max(...n)>t?Math.max(...n):t}),0)+1;return t.forEach(((s,i)=>{const{js:o=[],atoms:a=[n++]}=s;let{newCouplings:l,tempSignals:r}=checkCouplings(o,a,n+t.length);r.length>0&&e.push(...r),e[i].js=l,e[i].atoms=a})),e.sort(((t,e)=>t.delta-e.delta))}function checkCouplings(t,e,n){let s=[];return{newCouplings:t.reduce(((t,i)=>{const{atoms:o=[],multiplicity:a,coupling:l}=i;if(0===o.length)if(l&&a){let i=[];const o=couplingPatterns.indexOf(a);for(let t=0;t<o;t++)n++,i.push({coupling:l,atoms:[n]}),s.push(formatSignal(l,[n],e));t.push(...i)}else t.push(i);return t}),[]),tempSignals:s}}function formatSignal(t,e,n){return{delta:1e5,atoms:e,js:[{coupling:t,atoms:n}]}}function hackSignalsToXY(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return signalsToXY(addDummySignals(t),e)}function checkForSignals(t){for(let e of t)if(!e.signals)throw new Error("range has not signals")}const defaultFromTo=function(){return"13C"===(arguments.length>0&&void 0!==arguments[0]?arguments[0]:"").toUpperCase()?{from:-5,to:206}:{from:-.5,to:10.5}};function rangesToXY(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};checkForSignals(t);let{frequency:n=400,lineWidth:s=1,nbPoints:i=16384,shape:o={kind:"gaussian"}}=e;const a=(t,e)=>{for(let n=0;n<i;n++)t[n]+=e[n]},{from:l,to:r}=getFromTo(t,e),m={to:r,from:l,nbPoints:i,shape:o,lineWidth:s,frequency:n};let g=new Float64Array(i);for(const e of t){const{integration:t,signals:n=[]}=e,{multiplicity:s=""}=e;if("m"===s&&n.length<1){const{from:t,to:s}=e;n.push({delta:(t+s)/2,multiplicity:"m"})}let o=new Float64Array(i);for(const t of n){const{multiplicity:e}=t;let n="m"===e||"b"===e||"br s"===e?broadPeakOrMultipletSpectrum([t],m).y:hackSignalsToXY([t],m).y;normalizeSpectrum(n,[t]),a(o,n)}e.integration&&normalizeSpectrum(o,n,{integration:t}),a(g,o)}return{x:xSequentialFill({from:l,to:r,size:i}),y:g}}function broadPeakOrMultipletSpectrum(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{lineWidth:n,frequency:s}=e,i=new SpectrumGenerator(e),o=3*n/s;for(let e of t){const{multiplicity:t,delta:a,integration:l=1}=e;if("b"===t||"br s"===t)i.addPeak({x:a,y:l,width:o});else{const t=peaksOfMultiplet(a,{lineWidth:n,frequency:s});i.addPeaks(t)}}return i.getSpectrum()}function peaksOfMultiplet(t,e){const{frequency:n,lineWidth:s,intensities:i=[1,2,5,4,5,7,5,4,5,2,1]}=e,o=s/n,a=1.5*o,l=[],r=t-a*i.length/2;for(let t=0;t<i.length;t++)l.push({x:r+a*t,y:i[t],width:o});return l}function normalizeSpectrum(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{integration:s=e.reduce(((t,e)=>{const{integration:n=1}=e;return t+n}),0)}=n,i=t.reduce(((t,e)=>t+e),0);if(0!==i){const e=s/i*1e6;for(let n=0;n<t.length;n++)t[n]*=e}}function getFromTo(t,e){const{from:n,to:s}=defaultFromTo(e.nucleus);let i=Number.MAX_SAFE_INTEGER,o=Number.MIN_SAFE_INTEGER;for(const e of t)for(const t of e.signals||[])i>t.delta&&(i=t.delta),o<t.delta&&(o=t.delta);const{from:a=Math.min(i-.5,n),to:l=Math.max(o+.5,s)}=e;return{from:a,to:l}}function directOptimization(t,e,n){const{minValues:s,maxValues:i,directOptions:o={}}=n,a=direct(getObjectiveFunction(t,e),s,i,o),{optima:l}=a;return{error:a.minFunctionValue,iterations:a.iterations,parameterValues:l[0]}}function getObjectiveFunction(t,e){const{x:n,y:s}=t,i=n.length;return t=>{const o=e(t);let a=0;for(let t=0;t<i;t++)a+=Math.pow(s[t]-o(n[t]),2);return a}}const defaultParameters={delta:{init:t=>t.signal.delta,min:t=>t.signal.delta-2*t.shape.fwhm,max:t=>t.signal.delta+2*t.shape.fwhm,gradientDifference:()=>.002},intensity:{init:t=>t.signal.intensity||1,min:()=>0,max:()=>1.5,gradientDifference:()=>.001},fwhm:{init:t=>t.shape.fwhm,min:t=>.25*t.shape.fwhm,max:t=>4*t.shape.fwhm,gradientDifference:t=>.002*t.shape.fwhm},mu:{init:t=>t.shape.mu||.5,min:()=>0,max:()=>1,gradientDifference:()=>.01},coupling:{init:t=>t.jCoupling.coupling,min:t=>.8*t.jCoupling.coupling,max:t=>1.2*t.jCoupling.coupling,gradientDifference:()=>.01}};function signalsToPointXY(t,e){const{frequency:n,maxClusterSize:s=1}=e,i=signalsToSpinSystem(addDummySignals(t));i.clusters=splitSpinSystem(i,{frequency:n,maxClusterSize:s});const o=simulateXYPeaks(i,e).filter((t=>t.x<1e3)),a=o.reduce(((t,e)=>e.y>t?e.y:t),Number.MIN_SAFE_INTEGER);for(const t of o)t.y/=a;return o}const properties=["init","min","max","gradientDifference"];function getInternalSignals(t,e,n,s){let i=0,o=[];const{shape:a={kind:"gaussian"},baseline:l=n.min,lineWidth:r=1,frequency:m}=s,g=normalizeSignals({signals:e,data:t,shiftValue:l,frequency:m,range:n.range});for(const t of g){const{shape:e={...a}}=t;e.fwhm||(e.fwhm=r),e.fwhm/=m;const l=getShape1D(e),g=["delta","intensity",...l.getParameters()],u={min:[],max:[],init:[],gradientDifference:[]};for(const e of g)for(const s of properties)u[s].push(getPropertyValue({signal:t,frequency:m,parameter:e,property:s,minMaxY:n,shapeFct:l}));for(const e of t.js||[])for(const t of properties){const i="coupling";let o=s?.parameters?.[i]?.[t];if(o)if("number"==typeof o)u[t].push(getNormalizedValue(o,i,t,n,m,s.baseline));else{let a=o({jCoupling:e});u[t].push(getNormalizedValue(a,i,t,n,m,s.baseline))}if(!defaultParameters[i])throw new Error(`No default parameter for ${i}`);const a=defaultParameters[i][t];u[t].push(a({jCoupling:e}))}const c=i,C=c+g.length-1,f=C+1,h=f+t.js.length-1;i+=h-c+1,o.push({shape:e,shapeFct:l,signal:t,parameters:g,propertiesValues:u,fromIndex:c,toIndex:C,fromIndexCoupling:f,toIndexCoupling:h})}return o}function normalizeSignals(t){const{signals:e,data:n,frequency:s,shiftValue:i,range:o}=t,a=t=>{const e=signalsToPointXY([t],{frequency:s,maxClusterSize:1}),i=e.reduce(((t,e)=>e.y>t.y?e:t),e[0]),{y:o}=xyFindClosestPoint(n,i.x);return o};return e.map((t=>{const{intensity:e=a(t)}=t;return{...t,js:t.js||[],intensity:(e-i)/o}}))}function getPropertyValue(t){const{signal:e,frequency:n,parameter:s,property:i,minMaxY:o,shapeFct:a}=t;let l=e?.parameters?.[s]?.[i];if(l)return getNormalizedValue(l,s,i,o,n,t.baseline);let r=t?.parameters?.[s]?.[i];if(r){if("number"==typeof r)return getNormalizedValue(r,s,i,o,n,t.baseline);return getNormalizedValue(r(e),s,i,o,n,t.baseline)}if(!defaultParameters[s])throw new Error(`No default parameter for ${s}`);return(0,defaultParameters[s][i])({signal:e,shape:a})}function getNormalizedValue(t,e,n,s,i,o){return"intensity"===e?"gradientDifference"===n?t:void 0!==o?(t-o)/s.range:(t-s.min)/s.range:"fwhm"===e?t/i:t}const defaultSimulationOptions={maxClusterSize:1};function getSumOfShapes(t,e){const n={...defaultSimulationOptions,...e};return function(e){const s=[];for(const i of t){const t=e[i.fromIndex],o=e[i.fromIndex+1];for(let t=2;t<i.parameters.length;t++)i.shapeFct[i.parameters[t]]=e[i.fromIndex+t];const a=i.signal.js;for(let t=0;t<a.length;t++)a[t].coupling=e[i.fromIndexCoupling+t];const l=signalsToPointXY([{delta:t,js:a}],n);s.push(...l.map((t=>({intensity:o,shape:i.shapeFct,...t}))))}return t=>{let e=0;for(let n of s){const{x:s,y:i,intensity:o,shape:a}=n;e+=i*o*a.fct(t-s)}return e}}}const defaultLMOptimizationOptions={damping:1.5,maxIterations:100,errorTolerance:1e-8},defaultDirectOptimizationOptions={iterations:25};function optimizeSignals(t,e,n){const{optimization:s={},simulation:i,...o}=n;let a=xMinMaxValues(t.y);const l={...a,range:a.max-a.min},r=getInternalSignals(t,e,l,{frequency:i.frequency,...o}),{baseline:m=l.min}=n;let g=new Float64Array(t.y.length);for(let e=0;e<t.y.length;e++)g[e]=(t.y[e]-m)/l.range;const u=r[r.length-1].toIndexCoupling+1,c=new Float64Array(u),C=new Float64Array(u),f=new Float64Array(u),h=new Float64Array(u);let p=0;for(const t of r){for(let e=0;e<t.parameters.length;e++)c[p]=t.propertiesValues.min[e],C[p]=t.propertiesValues.max[e],f[p]=t.propertiesValues.init[e],h[p++]=t.propertiesValues.gradientDifference[e];for(let e=t.parameters.length;e<t.parameters.length+t.signal.js.length;e++)c[p]=t.propertiesValues.min[e],C[p]=t.propertiesValues.max[e],f[p]=t.propertiesValues.init[e],h[p++]=t.propertiesValues.gradientDifference[e]}const d=getSumOfShapes(r,i),{kind:y,options:H}=s,[v,b]="direct"===y?[directOptimization,defaultDirectOptimizationOptions]:[levenbergMarquardt,defaultLMOptimizationOptions];const w=v({x:t.x,y:g},d,{minValues:c,maxValues:C,initialValues:f,gradientDifference:h,...b,...H}).parameterValues,x=[];for(const t of r){const{fromIndexCoupling:e}=t,n=t.signal.js.map(((t,n)=>(t.coupling=w[e+n],t))),s=w[t.fromIndex],o=signalsToPointXY([{delta:s,js:n}],i),a=w[t.fromIndex+1]*l.range+m,r=[];for(const{x:e,y:n}of o){const s={id:v4(),x:e,y:a*n,width:0,shape:{...t.shape}};for(let e=2;e<t.parameters.length;e++)s.shape[t.parameters[e]]=w[t.fromIndex+e];s.shape.fwhm*=i.frequency,s.width=getShape1D(s.shape).fwhmToWidth(s.shape.fwhm),r.push(s)}x.push({delta:s,js:n,shape:{...r[0].shape},intensity:a,peaks:r})}return x}function applyWindow(t,e){const n=t.length,{windowData:s,start:i=0,length:o=n,pointsToShift:a=0,output:l=new Float64Array(t)}=e,r=Math.min(i+o,n-a);for(let t=i,e=0;t<r;t++)l[t]*=s[e++];for(let t=n-1,e=0;t>n-a-1;t--)l[t]*=s[e++];return l}function exponential(t){const{lb:e,dw:n}=t,s=-e*Math.PI*n;return t=>Math.exp(s*t)}function lorentzToGauss(t){const{dw:e,length:n,gaussianHz:s=0,exponentialHz:i=0,center:o=0}=t;if(o>1||o<0)throw new Error("The center of gaussian shape should be inside of the window function: 0 - 1");const a=Math.pow(.6*Math.PI*s*e,2),l=o*(n-1),r=Math.PI*e*i;return t=>Math.exp(t*r-Math.pow(l-t,2)*a)}function sineBell(t){const{exponent:e=1,offset:n=0,end:s=1,length:i}=t;if(void 0===i)throw new Error("length options should exists for sineBell shape");if(s<0||s>1)throw new Error("the end parameter should be [0-1]");const o=Math.PI*n,a=Math.PI*(s-n)/(i-1);return t=>Math.pow(Math.sin(o+a*t),e)}function getFunction(t){const{kind:e,options:n}=t;switch(e){case"exponential":return exponential(n);case"lorentzToGauss":return lorentzToGauss(n);case"sineBell":return sineBell(n);default:throw Error(`Unknown distribution ${e}`)}}function getData(t,e){const n=new Float64Array(e);let s=Number.MIN_SAFE_INTEGER;for(let i=0;i<e;i++){const e=t(i);n[i]=e,e>s&&(s=e)}for(let t=0;t<e;t++)n[t]/=s;return n}function compose(t){const{length:e,shapes:n=[]}=t;let s=new Float64Array(e).fill(1);return n.forEach((t=>{const{shape:n,start:i=0}=t,{options:o}=n,a="length"in o?o.length:e-i,l=getData(getFunction(n),a);applyWindow(s,{windowData:l,length:a,start:i,output:s})})),s}function apodization$1(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{compose:n,pointsToShift:s,apply:i=!0}=e;if(!n)return{...t,windowData:new Float64Array(t.re.length).fill(1)};const o=compose(n),a={windowData:o,pointsToShift:s};return{re:i?applyWindow(t.re,a):t.re,im:i?applyWindow(t.im,a):t.im,windowData:o}}const twoPi=2*Math.PI;function signalsToFID(t,e){const{lb:n=1,from:s=0,to:i=10,nbPoints:o=1024,frequency:a=400,maxClusterSize:l=8}=e;let r=signalsToSpinSystem(t);r.clusters=splitSpinSystem(r,{frequency:a,maxClusterSize:l});const m=simulateXYPeaks(r,{frequency:a}),g=new Float64Array(o),u=new Float64Array(o),c=o/(Math.abs(i-s)*a),C=xSequentialFill({size:o,from:0,to:c});for(const t of m){const{x:e,y:n}=t,s=e*a*twoPi;for(let t=0;t<o;t++)g[t]+=n*Math.cos(s*C[t]),u[t]+=n*Math.sin(s*C[t])}const{windowData:f,...h}=apodization$1({re:g,im:u},{pointsToShift:0,compose:{length:o,shapes:[{start:0,shape:{kind:"exponential",options:{dw:c/(o-1),lb:n}}}]}});return h}let possiblePatterns=[];for(const{label:t,value:e,names:n}of MultiplicityPatterns)possiblePatterns.push(t,e,...n);function splitPatterns(t){if(/^\s*$/.exec(t))return[];const e=new RegExp(possiblePatterns.join("|"),"g");let n=t.match(e);return n?n.map((t=>t.trim())):[t]}function splitParenthesis(t){const e=/ *(?<before>[^(]*?) *\( *(?<inside>.*?) *\) *(?<after>.*?) */.exec(t);return e?e.groups:{before:t,inside:"",after:""}}function resurrectRange(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{nucleus:n="1h",frequency:s=400}=e,i=splitParenthesis(t);if(!i.before)return;const o=/.*?(?<from>-?[0-9.]+)-?(?<to>-?[0-9.]*).*/.exec(i.before);if(!o||!o.groups)return;const a=""!==o.groups.to,l=Number(o.groups.from),r=a?Number(o.groups.to):l,m=i.inside.split(/ *, */);let g={delta:NaN,js:[]},u={from:l,to:r,signals:[g]};const c=m.filter((t=>t.match(/^[0-9]+H$/)));1===c.length&&(u.integration=Number(c[0].replace("H","")));const C=m.filter((t=>t.match(/^([br ]*)[a-zA-Z]+$/)));if(1===C.length){const t=C[0];"m"===t?a?(g.delta=(l+r)/2,g.multiplicity=t):(g.delta=l,g.multiplicity=t):a||(g.delta=l,g.multiplicity=t)}const f=m.filter((t=>t.match(/(Hz|J|^[0-9.]+$)/))).map((t=>Number(t.replace(/[^0-9.]/g,"")))),h=splitPatterns(g.multiplicity||"");if(h.length===f.length)for(let t=0;t<h.length;t++){if(!g.js)throw new Error("signal has not js");g.js.push({coupling:f[t],multiplicity:h[t]})}return u.from===u.to&&(u={...u,...rangeFromSignal(g,{nucleus:n,frequency:s})}),u}function resurrect(t){const e={experiment:{},ranges:[],acsString:t,normalized:t.replace(/[\r\n\t]/g," ").replace(/[;:]/g,",").replace(/\}/g,")").replace(/\{/g,"(").replace(/[\u2011\u2012\u2013\u2014\u2015\u2212]/g,"-")};return createParts(e),parseParts(e),e}function parseParts(t){for(const e of t.parts)if(e.toLowerCase().includes("nmr"))processExperiment(t,e);else{const{frequency:n,nucleus:s}=t.experiment,i=resurrectRange(e,{frequency:n,nucleus:s});i&&t.ranges.push(i)}}function processExperiment(t,e){const n=splitParenthesis(e),s=n.before.replace(/[ -]*nmr[ -]*/i,"").replace(/[ -]/g,"");if(/^[0-9]+[A-Z][a-z]?$/.exec(s)&&(t.experiment.nucleus=s),/^[A-Z][a-z]?[0-9]+$/.exec(s)&&(t.experiment.nucleus=s.replace(/^([A-Z][a-z]?)([0-9]+)$/,"$2$1")),n.inside){const e=n.inside.split(/[,]/),s=e.filter((t=>/[0-9]{2}/.exec(t)));if(s.length){const e=s[0].replace(/[^0-9]/g,"");e.length>1&&(t.experiment.frequency=Number(e))}const i=e.filter((t=>!t.match(/[0-9]{2}/)));i.length&&(t.experiment.solvent=i[0])}}function createParts(t){const e=t.normalized.split(/\)(?![^()]*\))/).map((t=>t.replace(/^\s*(.*?)\s*$/,"$1"))).filter((t=>t)).map((t=>`${t})`)).map((t=>t.split(/[,;](?![^()]*\))/))).flat().map((t=>t.replace(/^\s*(.*?)\s*$/,"$1"))).filter((t=>t));t.parts=e}possiblePatterns=possiblePatterns.sort(((t,e)=>e.length-t.length));const nucleusSymbolMap={proton:"1H",hydrogen:"H",helium:"He",lithium:"Li",carbon:"C",nitrogen:"N",oxigen:"O",fluorine:"F",sodium:"Na",aluminum:"Al",silicon:"Si",phosphorus:"P",iron:"Fe",copper:"Cu",zinc:"Zn",xenon:"Xe"};function normalizeNucleus(t){if(gyromagneticRatio[t])return t;const e=t.replace(/\D/g,""),n=t.replace(/\d*\W*/g,"").toLowerCase(),s=`${e}${n.length>1?nucleusSymbolMap[n]:n.toUpperCase()}`;return gyromagneticRatio[s]?s:t}function convertWidthToHz(t,e){return convertWidth(t,{...e,convertTo:"hz"})}function xyAutoPeaksPicking(t,e){const{from:n,to:s,frequency:i,noiseLevel:o,thresholdFactor:a=3,minMaxRatio:l=.05,broadRatio:r=25e-5,useSanPlot:m=!1,smoothY:g=!0,optimize:u=!1,factorLimits:c=4,realTopDetection:C=!0,shape:f={kind:"gaussian"},optimization:h={kind:"lm"},broadWidth:p=.25,sgOptions:d={},direction:y="positive"}=e;let H=1/i/(t.x[1]-t.x[0]),v=Math.max(Math.round(H/2),5);const{windowSize:b=v-v%2+1,polynomial:w=3}=d;if(t.x.length<b)return[];void 0!==n&&void 0!==s&&(t=xyExtract(t,{zones:[{from:n,to:s}]}));const x=getCutOff(t.y,{noiseLevel:o,useSanPlot:m,thresholdFactor:a});let O={shape:f,frequency:i,broadWidth:p,optimize:u,factorLimits:c,maxCriteria:!0,sgOptions:{windowSize:b,polynomial:w},minMaxRatio:l,broadRatio:r,noiseLevel:x.positive,smoothY:g,optimization:h,realTopDetection:C};switch(y){case"positive":return getPeakList(t,O);case"negative":return getNegativePeaks(t,x,O);case"both":return[...getPeakList(t,O),...getNegativePeaks(t,x,O)];default:throw Error(`Unknown distribution ${y}`)}}function getNegativePeaks(t,e,n){return n.noiseLevel=e.negative,n.maxCriteria=!1,getPeakList(t,n)}function getPeakList(t,e){const{shape:n,frequency:s,broadWidth:i,optimize:o,maxCriteria:a,factorLimits:l,sgOptions:r,minMaxRatio:m,broadRatio:g,noiseLevel:u,smoothY:c,optimization:C,realTopDetection:f}=e,h=gsd(t,{sgOptions:r,maxCriteria:a,minMaxRatio:m,noiseLevel:u,smoothY:c,realTopDetection:f}),p=setShape(h,{output:h,shape:n}),d=i?joinBroadPeaks(p,{broadRatio:g,broadWidth:i,shape:n,optimization:C}).map(toNMRPeak1DStructure):p.map(toNMRPeak1DStructure);return convertWidthToHz(o?optimizePeaks(t,d,{shape:n,factorLimits:l,optimization:C}).map(toNMRPeak1DStructure):d,{frequency:s})}function getCutOff(t,e){const{noiseLevel:n,useSanPlot:s,thresholdFactor:i}=e,o=t=>"number"==typeof t?{positive:t,negative:-t}:t;return n?o(n):s?xNoiseSanPlot(t,{factorStd:i}):o(xAbsoluteMedian(t)*i)}function toNMRPeak1DStructure(t){const{id:e,shape:n,x:s,y:i,width:o}=t;return{id:e,x:s,y:i,width:o,shape:n}}function joinRanges(t){t.sort(((t,e)=>t.from-e.from));for(let e=0;e<t.length-1;e++){const n=t[e],s=t[e+1];n.to>s.from&&(n.id=v4(),n.to=Math.max(s.to,n.to),n.signals&&s.signals&&(n.signals=n.signals.concat(s.signals)),void 0!==n.integration&&(n.integration+=s.integration||0),t.splice(e+1,1),e--)}return t}const patterns=["s","d","t","q","quint","h","sept","o","n"];let symRatio=1.5,maxErrorIter1=2.5,maxErrorIter2=1,jAxisKeys={jAxis:"x",intensity:"intensity"};function checkSignalForCompilePattern(t){if(!("symRank"in t))throw new Error("Internal error, symRank was not calculated");if(!("mask"in t))throw new Error("Internal Error, mask was not added")}var jAnalyzer={compilePattern:function(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{jAxisKey:n=jAxisKeys}=e;const s=symmetrizeChoiseBest(t,{maxError:maxErrorIter1,iteration:1,jAxisKey:n});if(s.multiplicity="m",s.asymmetric=!0,checkSignalForCompilePattern(s),s.symRank>=.95&&s.peaksComp.length<32){let t,e,n;s.asymmetric=!1;let i=1,o=[];for(let a=0;a<9;a++){let l=normalize(s,a),r=!1;if(1===l.length&&0===a)r=!0;else if(l.length<=1)continue;let m=getRanges(l);e=Math.pow(2,a);let g=null,u=1;for(;!r&&null!==(g=getNextCombination(m,e))&&u<400;){let e=new Array(g.length);i=1;for(let t=0;t<g.length;t++){e[t]=new Array(g[t]);for(let n=0;n<g[t];n++)e[t][n]=i++}o=[];let s=1;o.push(l[1].x-l[0].x),t=l[0].x,e[0].splice(0,1),e[1].splice(0,1),i=1;let m=2;for(n=Math.pow(2,a)-1;o.length<a&&m<n&&i<l.length;){for(u+=1,s++;i<l.length&&0===e[i].length;)i++;if(i<l.length){o.push(l[i].x-l[0].x),e[i].splice(0,1),m++;for(let n=2;n<=s;n++){let s=0;for(let t=0;t<n;t++)s+=o[t];for(let n=1;n<e.length;n++)if(Math.abs(l[n].x-(t+s))<.25){e[n].splice(0,1),m++;break}}}}let c=idealPattern(o);r=!0;for(let t=0;t<c.length;t++)c[t].intensity!==g[t]&&(r=!1)}r&&updateSignal(s,o)}}for(let t of s.peaksComp)t.x/=s.observe,t.width*=s.observe;return s}};function updateSignal(t,e){let n=t.peaksComp,s=n.length;t.startX=n[0].x/t.observe-n[0].width,t.stopX=n[s-1].x/t.observe+n[s-1].width,t.integralData.from=n[0].x/t.observe-3*n[0].width,t.integralData.to=n[s-1].x/t.observe+3*n[s-1].width,t.maskPattern=t.mask2,t.multiplicity=abstractPattern(t,e),t.pattern=t.multiplicity}function abstractPattern(t,e){let n="",s=1,i=[];if(e&&e.length>0){e.sort(((t,e)=>e-t));for(let t=0;t<e.length-1;t++)Math.abs(e[t]-e[t+1])<.05?s++:(i.push({coupling:Math.abs(e[t]),multiplicity:patterns[s]}),n+=patterns[s],s=1);let o=e.length-1;i.push({coupling:Math.abs(e[o]),multiplicity:patterns[s]}),n+=patterns[s],t.nmrJs=i}else n="s",Math.abs(t.startX-t.stopX)*t.observe>16&&(n="br s");return n}function idealPattern(t){let e=[{x:0,intensity:Math.pow(2,t.length)}];for(const n of t)for(let t=e.length-1;t>=0;t--)e.push({x:e[t].x+n/2,intensity:e[t].intensity/2}),e[t].x=e[t].x-n/2,e[t].intensity=e[t].intensity/2;e.sort(((t,e)=>t.x-e.x));for(let t=e.length-2;t>=0;t--)Math.abs(e[t].x-e[t+1].x)<.1&&(e[t].intensity+=e[t+1].intensity,e.splice(t+1,1));return e}function getNextCombination(t,e){let n,s=Math.ceil(.5*t.values.length),i=t.values.length,o=0;for(;o!==e;){for(n=!1;!n;)if(n=!0,t.currentIndex[t.active]++,t.currentIndex[t.active]>=t.values[t.active].length){if(t.active+1===s)return null;t.currentIndex[t.active]=0,n=!1,t.active++}else t.active=0;o=0;for(let e=0;e<s;e++)o+=2*t.values[e][t.currentIndex[e]];t.values.length%2!=0&&(o-=t.values[s-1][t.currentIndex[s-1]])}if(o===e){let e=new Array(i);for(let n=0;n<s;n++)e[n]=t.values[n][t.currentIndex[n]],e[i-n-1]=t.values[n][t.currentIndex[n]];return e}return null}function getRanges(t){let e,n,s=new Array(t.length),i=new Array(t.length);s[0]=[1],s[t.length-1]=[1],i[0]=-1,i[t.length-1]=0;for(let o=1;o<t.length-1;o++){e=Math.round(.85*t[o].intensity),n=Math.round(1.15*t[o].intensity),s[o]=[];for(let t=e;t<=n;t++)s[o].push(t);i[o]=0}return{values:s,currentIndex:i,active:0}}function symmetrizeChoiseBest(t,e){let{maxError:n,iteration:s,jAxisKey:i=jAxisKeys}=e,o=symmetrize(t,n,s,i);if(!o.peaksComp)throw new Error("internal peaksComp was not created");let a=o.peaksComp,l=o.mask,r=t.delta;t.delta=(t.peaks[0].x+t.peaks[t.peaks.length-1].x)/2;let m=symmetrize(t,n,s,i);if(!m.peaksComp)throw new Error("internal peaksComp was not created");return m.peaksComp.length>a.length?m:(t.delta=r,t.peaksComp=a,t.mask=l,o)}function symmetrize(t,e,n,s){let{jAxis:i,intensity:o}=s;const a=JSON.parse(JSON.stringify(t));let l,r,m,g,u,c=new Array(a.peaks.length);for(let t=0;t<c.length;t++){let e=a.peaks[t];c[t]={x:e[i]*a.observe,intensity:e[o],width:e.width/a.observe}}for(let t=c.length-2;t>=0;t--)Math.abs(c[t].x-c[t+1].x)<.25&&(c[t].x=c[t].x*c[t].intensity+c[t+1].x*c[t+1].intensity,c[t].intensity=c[t].intensity+c[t+1].intensity,c[t].x/=c[t].intensity,c[t].intensity/=2,c[t].width+=c[t+1].width,c.splice(t+1,1));a.peaksComp=c;let C=c.length,f=new Array(C);a.mask=f;let h=0,p=c.length-1,d=a.delta*a.observe,y=[(c[0].x+c[C-1].x)/2,1];e=error(Math.abs(d-y[0]));let H=0;for(let t=0;t<C;t++)f[t]=!0,H+=c[t].intensity;for(;h<=p;){if(f[h]=!0,f[p]=!0,h===p)C>2&&Math.abs(c[h].x-d)>e&&(f[h]=!1);else if(l=Math.max(c[h].intensity,c[p].intensity),r=Math.min(c[h].intensity,c[p].intensity),g=l/r,g>symRatio)c[h].intensity===r?(f[h]=!1,p++):(f[p]=!1,h--);else{let t=Math.abs(c[h].x-d),n=Math.abs(c[p].x-d);Math.abs(t-n)<e?(m=Math.min(c[h].intensity,c[p].intensity),u=Math.min(c[h].width,c[p].width),c[h].intensity=m,c[p].intensity=m,c[h].width=u,c[p].width=u,y=[y[0]+(c[p].x+c[h].x)/2,y[1]+1]):Math.max(t,n)===n?(f[p]=!1,h--):(f[h]=!1,p++)}if(h++,p--,1===n&&(d=chemicalShift(c,f),isNaN(d)))return a.symRank=0,a;e=error(Math.abs(d-y[0]/y[1]))}for(let t=C-1;t>=0;t--)!1===f[t]&&c.splice(t,1);if(d=chemicalShift(c),isNaN(d))return a.symRank=0,a;a.delta=d/a.observe;let v=0,b=0;if(c.length>1){for(let t=Math.ceil(c.length/2)-1;t>=0;t--)v+=(3+Math.min(Math.abs(c[t].x-d),Math.abs(c[c.length-1-t].x-d)))/(3+Math.max(Math.abs(c[t].x-d),Math.abs(c[c.length-1-t].x-d)))*c[t].intensity,b+=c[t].intensity;v/=b}else 1===c.length&&(v=1);let w=0;for(const t of c)w+=t.intensity;if(v-=(H-w)/H*.12,v>.8&&v<.97&&n<2)return symmetrize(a,maxErrorIter2,2,s);if(c.length>1){let t;for(let e=Math.ceil(c.length/2)-1;e>=0;e--)t=(c[e].x-c[c.length-1-e].x)/2,c[e].x=d+t,c[c.length-1-e].x=d-t}return a.symRank=v,a}function error(t){let e=2.5*t;return e<.75&&(e=.75),e>3&&(e=3),e}function normalize(t,e){let n=JSON.parse(JSON.stringify(t.peaksComp)),s=0,i=0;for(let t of n)s+=t.intensity;s=Math.pow(2,e)/s,t.mask2=t.mask.slice();let o=t.mask2.length-1;for(let e=n.length-1;e>=0;e--){for(n[e].intensity*=s;o>=0&&!t.mask2[o];)o--;n[e].intensity<.75?(n.splice(e,1),t.mask2[o]=!1):i+=n[e].intensity,o--}i=Math.pow(2,e)/i;for(let t=n.length-1;t>=0;t--)n[t].intensity*=i;return n}function chemicalShift(t){let e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],s=0,i=0;if(n.length>0)for(let o=0;o<t.length;o++)n[o]&&(e=getArea(t[o]),s+=e,i+=e*t[o].x);else for(let n of t)e=getArea(n),s+=e,i+=e*n.x;return i/s}function getArea(t){return Math.abs(t.intensity*t.width*1.57)}function checkSignalAfterCompilePattern(t){if(!t.mask)throw new Error("Internal Error, mask was not added");if(!t.mask2)throw new Error("Internal Error, mask2 was not added");if(!t.maskPattern)throw new Error("Internal Error, maskPattern was not added")}const assignSignal=(t,e,n)=>({id:v4(),delta:NaN,nbPeaks:1,kind:"signal",startX:t.x-t.width/e,stopX:t.x+t.width/e,observe:e,nucleus:n,integralData:{from:t.x-3*t.width/e,to:t.x+3*t.width/e,value:0},peaks:[{x:t.x,intensity:t.y,width:t.width}]});function peaksToRanges(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{integrationSum:s=100,joinOverlapRanges:i=!0,clean:o=.4,compile:a=!0,integralType:l="sum",frequency:r=400,frequencyCluster:m=16,keepPeaks:g=!1,nucleus:u="1H"}=n,c={integrationSum:s,integralType:l,frequencyCluster:m,frequency:r,nucleus:u};if(0===e.length)return[];t.x[0]>t.x[1]&&(t.x=t.x.reverse(),t.y=t.y.reverse());let C=detectSignals(t,e,c);if(o)for(let t=0;t<C.length;t++)Math.abs(C[t].integralData.value)<o&&C.splice(t,1);if(a){let e,n;for(let s=0;s<C.length;s++){C[s]=jAnalyzer.compilePattern(C[s]);let i=C[s];if(i.maskPattern&&"m"!==i.multiplicity&&""!==i.multiplicity){checkSignalAfterCompilePattern(i),e=0,n=0;let s=[];for(let t=i.maskPattern.length-1;t>=0;t--)if(n+=computeArea(i.peaks[t],r),!i.maskPattern[t]){let n=i.peaks.splice(t,1)[0];s.push({x:n.x,y:n.intensity,width:n.width}),i.mask.splice(t,1),i.mask2.splice(t,1),i.maskPattern.splice(t,1),i.nbPeaks--,e+=computeArea(n,r)}if(s.length>0){e=e*i.integralData.value/n,i.integralData.value-=e;let o=[];for(let t=s.length-1;t>=0;t--)o.push(s[t]);c.integrationSum=Math.abs(e);let a=detectSignals(t,o,c);for(const t of a)C.push(t)}}}updateIntegration(C,s)}if(C.sort(((t,e)=>e.delta-t.delta)),o)for(let t=C.length-1;t>=0;t--)Math.abs(C[t].integralData.value)<o&&C.splice(t,1);let f=[];for(let t=0;t<C.length;t++){let e=C[t];const n={id:v4(),from:e.integralData.from,to:e.integralData.to,integration:e.integralData.value},s={delta:e.delta,kind:e.kind||"signal",multiplicity:e.multiplicity};g&&(s.peaks=e.peaks.map((t=>{const e={y:t.intensity,...t};return delete e.intensity,e}))),e.nmrJs&&(s.js=e.nmrJs),n.signals=[s],f[t]=n}return i&&(f=joinRanges(f)),f}function detectSignals(t,e){let n,s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{integrationSum:i=100,integralType:o="sum",frequencyCluster:a=16,frequency:l=400,nucleus:r="1H"}=s,m=assignSignal(e[0],l,r),g=[],u={x:Number.MIN_SAFE_INTEGER};a/=l;for(const t of e){if(Math.abs(t.x-u.x)>a)m=assignSignal(t,l,r),t.kind&&(m.kind=t.kind),g.push(m);else{let e=t.x+t.width/l;m.stopX=Math.max(m.stopX,e),m.startX=Math.min(m.startX,e),m.nbPeaks++,m.peaks.push({x:t.x,intensity:t.y,width:t.width}),m.integralData.from=Math.min(m.integralData.from,t.x-3*t.width/l),m.integralData.to=Math.max(m.integralData.to,t.x+3*t.width/l),t.kind&&(m.kind=t.kind)}u=t}for(let e of g){n=e.peaks;let s=e.integralData,i=0,a=0;for(const t of n){let e=computeArea(t,l);i+=t.x*e,a+=e}e.delta=i/a,s.value="sum"===o?xyIntegration(t,{from:s.from,to:s.to}):a}return i>0&&updateIntegration(g,i),g}function computeArea(t,e){return Math.abs(t.intensity*t.width/e*1.57)}function updateIntegration(t,e){let n=0,s=0;for(const e of t)s+=Math.abs(Math.round(e.integralData.value));if(s!==e){n=e/s;for(const e of t)e.integralData.value*=n}}function xyAutoRangesPicking(t,e){let n=xyAutoPeaksPicking(t,e.peakPicking);return n=peaksFilterImpurities(n,e.impurities),peaksToRanges(t,n,e.ranges)}function xyPeaksOptimization(t,e,n){const{frequency:s}=n,i=optimizePeaks(t,convertWidthToPPM(e,{frequency:s}),n);return convertWidthToHz(i,{frequency:s,output:i})}function formatZones(t){let e=[];for(const n of t){let t=[Number.MAX_VALUE,0],s=[Number.MAX_VALUE,0];for(const e of n.peaks||[])e.minX<t[0]&&(t[0]=e.minX),e.maxX>t[1]&&(t[1]=e.maxX),e.minY<s[0]&&(s[0]=e.minY),e.maxY>s[1]&&(s[1]=e.maxY);e.push({id:v4(),x:{from:t[0],to:t[1]},y:{from:s[0],to:s[1]},signals:[n]})}return e}function xyzAutoZonesPicking(t,e){return formatZones(xyzAutoSignalsPicking(t,e))}var src={},fftlib={};!function(t){(function(){var e,n="0.3.0",s="2013-03";(e=t).toString=function(){return"version "+n+", released "+s};for(var i=0,o=null,a=null,l={init:function(t){if(0===t||0!=(t&t-1))throw new Error("init: radix-2 required");i=t,l._initArray(),l._makeBitReversalTable(),l._makeCosSinTable()},fft1d:function(t,e){l.fft(t,e,1)},ifft1d:function(t,e){var n=1/i;l.fft(t,e,-1);for(var s=0;s<i;s++)t[s]*=n,e[s]*=n},bt1d:function(t,e){l.fft(t,e,-1)},fft2d:function(t,e){for(var n=[],s=[],o=0,a=0;a<i;a++){o=a*i;for(var r=0;r<i;r++)n[r]=t[r+o],s[r]=e[r+o];l.fft1d(n,s);for(var m=0;m<i;m++)t[m+o]=n[m],e[m+o]=s[m]}for(var g=0;g<i;g++){for(var u=0;u<i;u++)o=g+u*i,n[u]=t[o],s[u]=e[o];l.fft1d(n,s);for(var c=0;c<i;c++)t[o=g+c*i]=n[c],e[o]=s[c]}},ifft2d:function(t,e){for(var n=[],s=[],o=0,a=0;a<i;a++){o=a*i;for(var r=0;r<i;r++)n[r]=t[r+o],s[r]=e[r+o];l.ifft1d(n,s);for(var m=0;m<i;m++)t[m+o]=n[m],e[m+o]=s[m]}for(var g=0;g<i;g++){for(var u=0;u<i;u++)o=g+u*i,n[u]=t[o],s[u]=e[o];l.ifft1d(n,s);for(var c=0;c<i;c++)t[o=g+c*i]=n[c],e[o]=s[c]}},fft:function(t,e,n){for(var s,l,r,m,g,u,c,C,f,h=i>>2,p=0;p<i;p++)p<(m=o[p])&&(g=t[p],t[p]=t[m],t[m]=g,g=e[p],e[p]=e[m],e[m]=g);for(var d=1;d<i;d<<=1){l=0,s=i/(d<<1);for(var y=0;y<d;y++){u=a[l+h],c=n*a[l];for(var H=y;H<i;H+=d<<1)C=u*t[r=H+d]+c*e[r],f=u*e[r]-c*t[r],t[r]=t[H]-C,t[H]+=C,e[r]=e[H]-f,e[H]+=f;l+=s}}},_initArray:function(){o="undefined"!=typeof Uint32Array?new Uint32Array(i):[],a="undefined"!=typeof Float64Array?new Float64Array(1.25*i):[]},_paddingZero:function(){},_makeBitReversalTable:function(){var t=0,e=0,n=0;for(o[0]=0;++t<i;){for(n=i>>1;n<=e;)e-=n,n>>=1;e+=n,o[t]=e}},_makeCosSinTable:function(){var t=i>>1,e=i>>2,n=i>>3,s=t+e,o=Math.sin(Math.PI/i),l=2*o*o,r=Math.sqrt(l*(2-l)),m=a[e]=1,g=a[0]=0;o=2*l;for(var u=1;u<n;u++)l+=o*(m-=l),r-=o*(g+=r),a[u]=g,a[e-u]=m;0!==n&&(a[n]=Math.sqrt(.5));for(var c=0;c<e;c++)a[t-c]=a[c];for(var C=0;C<s;C++)a[C+t]=-a[C]}},r=["init","fft1d","ifft1d","fft2d","ifft2d"],m=0;m<r.length;m++)e[r[m]]=l[r[m]];return e.bt=l.bt1d,e.fft=l.fft1d,e.ifft=l.ifft1d,e}).call(commonjsGlobal)}(fftlib);var FFT=fftlib,FFTUtils$1={DEBUG:!1,ifft2DArray:function(t,e,n){var s=new Array(e*n),i=e/2,o=2*(n-1);FFT.init(i);for(var a={re:new Array(i),im:new Array(i)},l=0;l<n;l++){for(var r=i-1;r>=0;r--)a.re[r]=t[2*r*n+l],a.im[r]=t[(2*r+1)*n+l];FFT.bt(a.re,a.im);for(r=i-1;r>=0;r--)s[2*r*n+l]=a.re[r],s[(2*r+1)*n+l]=a.im[r]}var m=new Array(i*o);FFT.init(o);var g={re:new Array(o),im:new Array(o)},u=o*i;for(r=0;r<e;r+=2){g.re[0]=s[r*n],g.im[0]=s[(r+1)*n];for(l=1;l<n;l++)g.re[l]=s[r*n+l],g.im[l]=s[(r+1)*n+l],g.re[o-l]=s[r*n+l],g.im[o-l]=-s[(r+1)*n+l];FFT.bt(g.re,g.im);var c=r/2*o;for(l=o-1;l>=0;l--)m[c+l]=g.re[l]/u}return m},fft2DArray:function(t,e,n,s){Object.assign({},{inplace:!0});var i=n/2+1,o=2*e,a=new Array(o*i);FFT.init(n);for(var l,r,m,g,u,c={re:new Array(n),im:new Array(n)},C={re:new Array(n),im:new Array(n)},f={re:new Array(n),im:new Array(n)},h=0;h<e/2;h++){l=2*h*n,c.re=t.slice(l,l+n),l=(2*h+1)*n,c.im=t.slice(l,l+n),FFT.fft1d(c.re,c.im),this.reconstructTwoRealFFT(c,C,f),r=4*h*i,m=(4*h+1)*i,g=(4*h+2)*i,u=(4*h+3)*i;for(var p=i-1;p>=0;p--)a[r+p]=C.re[p],a[m+p]=C.im[p],a[g+p]=f.re[p],a[u+p]=f.im[p]}C=null,f=null;var d=new Array(o*i);FFT.init(e);for(var y={re:new Array(e),im:new Array(e)},H=i-1;H>=0;H--){for(h=e-1;h>=0;h--)y.re[h]=a[2*h*i+H],y.im[h]=a[(2*h+1)*i+H],isNaN(y.re[h])&&(y.re[h]=0),isNaN(y.im[h])&&(y.im[h]=0);FFT.fft1d(y.re,y.im);for(h=e-1;h>=0;h--)d[2*h*i+H]=y.re[h],d[(2*h+1)*i+H]=y.im[h]}return d},reconstructTwoRealFFT:function(t,e,n){var s,i,o,a,l,r=t.re.length;e.re[0]=t.re[0],e.im[0]=0,n.re[0]=t.im[0],n.im[0]=0;for(var m=r/2;m>0;m--)l=r-m,s=.5*(t.re[m]-t.re[l]),i=.5*(t.re[m]+t.re[l]),o=.5*(t.im[m]-t.im[l]),a=.5*(t.im[m]+t.im[l]),e.re[m]=i,e.im[m]=o,e.re[l]=i,e.im[l]=-o,n.re[m]=a,n.im[m]=-s,n.re[l]=a,n.im[l]=s},convolute2DI:function(t,e,n,s){for(var i,o,a=0;a<n/2;a++)for(var l=0;l<s;l++)i=t[2*a*s+l]*e[2*a*s+l]-t[(2*a+1)*s+l]*e[(2*a+1)*s+l],o=t[2*a*s+l]*e[(2*a+1)*s+l]+t[(2*a+1)*s+l]*e[2*a*s+l],t[2*a*s+l]=i,t[(2*a+1)*s+l]=o},convolute:function(t,e,n,s,i){for(var o=new Array(s*n),a=0;a<n*s;a++)o[a]=t[a];o=this.fft2DArray(o,n,s);var l,r=e.length,m=e[0].length,g=new Array(s*n);for(a=0;a<s*n;a++)g[a]=0;for(var u=Math.floor((r-1)/2),c=Math.floor((m-1)/2),C=0;C<r;C++){l=(C-u+n)%n;for(var f=0;f<m;f++)g[l*s+(f-c+s)%s]=e[C][f]}g=this.fft2DArray(g,n,s);var h=2*n,p=s/2+1;return this.convolute2DI(o,g,h,p),this.ifft2DArray(o,h,p)},toRadix2:function(t,e,n){var s,i,o,a,l=n,r=e;if(0===n||0!=(n&n-1)){for(l=0;n>>++l!=0;);l=1<<l}if(0===e||0!=(e&e-1)){for(r=0;e>>++r!=0;);r=1<<r}if(r==e&&l==n)return{data:t,rows:e,cols:n};var m=new Array(r*l),g=Math.floor((r-e)/2)-e,u=Math.floor((l-n)/2)-n;for(s=0;s<r;s++)for(o=s*l,a=(s-g)%e*n,i=0;i<l;i++)m[o+i]=t[a+(i-u)%n];return{data:m,rows:r,cols:l}},crop:function(t,e,n,s,i,o){if(e==s&&n==i)return t;Object.assign({},o);var a,l,r,m,g=new Array(i*s),u=Math.floor((e-s)/2),c=Math.floor((n-i)/2);for(r=0;r<s;r++)for(a=r*i,l=(r+u)*n,m=0;m<i;m++)g[a+m]=t[l+(m+c)];return g}},FFTUtils_1=FFTUtils$1,FFTUtils=src.FFTUtils=FFTUtils_1;function matrix2Array(t){let e,n,s=t;if("number"!=typeof t[0]){e=t.length,n=t[0].length,s=new Array(e*n);for(let i=0;i<e;i++)for(let e=0;e<n;e++)s[i*n+e]=t[i][e]}else{let s=Math.sqrt(t.length);Number.isInteger(s)&&(e=s,n=s)}return{data:s,rows:e,cols:n}}function convolutionFFT(t,e,n){let s,i,o=matrix2Array(t),a=o.data,l=Object.assign({normalize:!1,divisor:1,rows:o.rows,cols:o.cols},n);if(!l.rows||!l.cols)throw new Error(`Invalid number of rows or columns ${s} ${i}`);s=l.rows,i=l.cols;let r=l.divisor,m=e.length,g=e[0].length;if(l.normalize){r=0;for(let t=0;t<m;t++)for(let n=0;n<g;n++)r+=e[t][n]}if(0===r)throw new RangeError("convolution: The divisor is equal to zero");let u=FFTUtils.toRadix2(a,s,i),c=FFTUtils.convolute(u.data,e,u.rows,u.cols);if(c=FFTUtils.crop(c,u.rows,u.cols,s,i),0!==r&&1!==r)for(let t=0;t<c.length;t++)c[t]/=r;return c}function convolutionDirect(t,e,n){let s,i,o=matrix2Array(t),a=o.data,l=Object.assign({normalize:!1,divisor:1,rows:o.rows,cols:o.cols},n);if(!l.rows||!l.cols)throw new Error(`Invalid number of rows or columns ${s} ${i}`);s=l.rows,i=l.cols;let r,m,g,u,c,C=l.divisor,f=e.length,h=e[0].length;if(l.normalize){C=0;for(let t=0;t<f;t++)for(let n=0;n<h;n++)C+=e[t][n]}if(0===C)throw new RangeError("convolution: The divisor is equal to zero");let p=new Array(s*i),d=Math.floor(f/2),y=Math.floor(h/2);for(let t=0;t<s;t++)for(let n=0;n<i;n++){m=0;for(let o=0;o<f;o++)for(let l=0;l<h;l++)g=e[f-o-1][h-l-1],u=(t+o-d+s)%s,c=(n+l-y+i)%i,r=u*i+c,m+=a[r]*g;r=t*i+n,p[r]=m/C}return p}src.FFT=fftlib;class DisjointSet{constructor(){this.nodes=new Map}add(t){var e=this.nodes.get(t);return e||(e=new DisjointSetNode(t),this.nodes.set(t,e)),e}union(t,e){const n=this.find(t),s=this.find(e);n!==s&&(n.rank<s.rank?n.parent=s:n.rank>s.rank?s.parent=n:(s.parent=n,n.rank++))}find(t){for(var e=t;null!==e.parent;)e=e.parent;for(var n=t;null!==n.parent;){var s=n;n=n.parent,s.parent=e}return e}connected(t,e){return this.find(t)===this.find(e)}}var DisjointSet_1=DisjointSet;function DisjointSetNode(t){this.value=t,this.parent=null,this.rank=0}var DisjointSet$1=DisjointSet_1;const direction8X$2=[-1,-1,0,1,-1,0,1,1],direction8Y$2=[0,-1,-1,-1,1,1,1,0],neighbours8$1=[null,null,null,null,null,null,null,null],direction4X$1=[-1,0,1,0],direction4Y$1=[0,-1,0,1],neighbours4$1=[null,null,null,null];function drainLabelling(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{neighbours:s=8,width:i,height:o}=n;let a,l,r;if(8===s)a=direction8X$2,l=direction8Y$2,r=neighbours8$1;else{if(4!==s)throw new RangeError(`unsupported neighbours count: ${s}`);a=direction4X$1,l=direction4Y$1,r=neighbours4$1}let m=new Array(o*i);for(let n=0,s=0;n<o;n++)for(let o=0;o<i;o++,s++)m[s]={value:t[s],row:n,col:o,mask:e[s]};m.sort(((t,e)=>t.value-e.value));const g=e.length,u=new Array(g),c=new Int16Array(g),C=new DisjointSet$1;for(let n=0,s=1;n<e.length;n++){let e=m[n];if(!e.mask)continue;let{row:g,col:c,value:f}=e,h=c+g*i;u[h]||(u[h]=C.add(s++));for(let e=0;e<r.length;e++){let n=c+a[e],s=g+l[e];if(n>=0&&s>=0&&n<i&&s<o){if(!u[n+s*i]){f<t[n+s*i]&&(u[n+s*i]=u[h])}}}}for(let t=0;t<o;t++)for(let n=0;n<i;n++){let s=n+t*i;e[s]&&(c[s]=C.find(u[s]).value)}return c}const direction4X=[-1,0],direction4Y=[0,-1],neighbours4=[null,null],direction8X$1=[-1,-1,0,1],direction8Y$1=[0,-1,-1,-1],neighbours8=[null,null,null,null];function floodFillLabelling(t,e,n,s){const i=(s=s||{}).neighbours||8;let o,a,l;if(8===i)o=direction8X$1,a=direction8Y$1,l=neighbours8;else{if(4!==i)throw new RangeError(`unsupported neighbours count: ${i}`);o=direction4X,a=direction4Y,l=neighbours4}const r=t.length,m=new Array(r),g=new Int16Array(r),u=new DisjointSet$1;let c,C=1;for(let s=0;s<n;s++)for(let i=0;i<e;i++){let r=null;if(c=i+s*e,t[c]){for(let t=0;t<l.length;t++){let g=i+o[t],u=s+a[t];if(g>=0&&u>=0&&g<e&&u<n){let n=m[g+u*e];n?(l[t]=n,(!r||l[t].value<r.value)&&(r=l[t])):l[t]=null}}if(r){m[c]=r;for(let t=0;t<l.length;t++)l[t]&&l[t]!==r&&u.union(r,l[t])}else m[c]=u.add(C++)}}for(let s=0;s<n;s++)for(let n=0;n<e;n++)c=n+s*e,t[c]&&(g[c]=u.find(m[c]).value);return g}const smallFilter$1=[[0,0,1,2,2,2,1,0,0],[0,1,4,7,7,7,4,1,0],[1,4,5,3,0,3,5,4,1],[2,7,3,-12,-23,-12,3,7,2],[2,7,0,-23,-40,-23,0,7,2],[2,7,3,-12,-23,-12,3,7,2],[1,4,5,3,0,3,5,4,1],[0,1,3,7,7,7,3,1,0],[0,0,1,2,2,2,1,0,0]];function findPeaks2DRegion(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{nStdDev:n=3,kernel:s=smallFilter$1,originalData:i=matrix2Array(t).data,filteredData:o,rows:a,cols:l,labelling:r="drain"}=e,m=matrix2Array(t),g=m.data;if(a&&l||(a=m.rows,l=m.cols),!a||!l)throw new Error(`Invalid number of rows or columns ${a} ${l}`);let u=o;u||(u=convolutionFFT(g,s,e));let c=0;for(let t=l*a-2;t>=0;t--)c+=Math.pow(u[t]-u[t+1],2);c=-Math.sqrt(c)*n/a;let C,f=new Uint16Array(l*a);for(let t=u.length-1;t>=0;t--)u[t]<c&&(f[t]=1);switch(r.toLowerCase()){case"drain":C=drainLabelling(u,f,{neighbours:8,width:l,height:a});break;case"floodfill":C=floodFillLabelling(f,l,a,{neighbours:8});break;default:throw new Error(`labelling ${r} does not support`)}return extractPeaks(C,{data:g,nCols:l,originalData:i})}function extractPeaks(t,e){const{data:n,nCols:s,originalData:i}=e;let o,a,l,r={};for(let e=0;e<t.length;e++)0!==t[e]&&(a=e%s,o=(e-a)/s,r[t[e]]?(l=r[t[e]],l.x+=a*n[e],l.y+=o*n[e],l.z+=i[e],a<l.minX&&(l.minX=a),a>l.maxX&&(l.maxX=a),o<l.minY&&(l.minY=o),o>l.maxY&&(l.maxY=o)):r[t[e]]={x:a*n[e],y:o*n[e],z:i[e],minX:a,maxX:a,minY:o,maxY:o});let m=Object.keys(r),g=new Array(m.length);for(let t=0;t<m.length;t++){g[t]=r[m[t]];let e=Math.abs(g[t].z);g[t].x/=e,g[t].y/=e}return g}const{parse:parse$2,stringify:stringify$2}=JSON;function addMissingIDs(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{output:n=parse$2(stringify$2(t))}=e;for(const t of n)"id"in t||(t.id=v4());return n}const direction8X=[-1,-1,-1,0,0,1,1,1],direction8Y=[-1,0,1,-1,1,-1,0,1],direction16X=[-2,-2,-2,-2,-2,-1,-1,0,0,1,1,2,2,2,2,2],direction16Y=[-2,-1,0,1,2,-2,2,-2,2,-2,2,-2,-1,0,1,2];function determineRealTop(t,e){let{nCols:n,absoluteData:s,originalData:i,minX:o,maxX:a,minY:l,maxY:r}=e;for(let e=0;e<t.length;e++){let m=Math.round(t[e].x),g=Math.round(t[e].y),u=m+g*n,{index:c,isMax:C}=determineMax(s,{xIndex:m,yIndex:g,nCols:n,shell:1});u=C?c:determineMax(s,{xIndex:m,yIndex:g,nCols:n,shell:2}).index;let f=fitGaussian(i,{nCols:n,index:u,minY:l,maxY:r,minX:o,maxX:a});t[e]=Object.assign(t[e],f)}return t}function determineMax(t,e){let{xIndex:n,yIndex:s,shell:i,nCols:o}=e,a=n+s*o,[l,r]=i>1?[direction16X,direction16Y]:[direction8X,direction8Y],m=!1;for(let e=0;e<l.length;e++){let i=n+l[e],g=s+r[e];if(t[i+g*o]>=t[a]){m=!0;let e=i+g*o;for(let n=0;n<direction8Y.length;n++){if(t[i+direction8X[n]+(g+direction8Y[n])*o]>t[e]){m=!1;break}}m&&(a=e)}}return{index:a,isMax:m}}function fitGaussian(t,e){let{nCols:n,index:s,minY:i,maxY:o,minX:a,maxX:l}=e,r=(l-a)/(n-1),m=(o-i)/(t.length/n-1),g=s%n,u=(s-g)/n,c=Number.MIN_SAFE_INTEGER,C=new Array(direction8X.length+1),f=new Array(direction8X.length+1);for(let e=-1,s=0;e<2;e++)for(let i=-1;i<2;i++,f[s]=s++){let s=t[g+i+(u+e)*n];c<s&&(c=s),C[1+i+3*(1+e)]=s}for(let t=0;t<C.length;t++)C[t]/=c;let h=[2,2,1.5,1,1],p=[0,0,-1.5,.001,.001],d=[1,1,C[4],.2,.2],y=levenbergMarquardt({x:f,y:C},paramGaussian2D(r,m,3),{damping:1.5,maxIterations:100,errorTolerance:1e-8,initialValues:d,gradientDifference:[1e-4,1e-4,.001,.001,.001],maxValues:h,minValues:p}).parameterValues;return{x:y[0]+g-1,y:y[1]+u-1,z:y[2]*c}}function paramGaussian2D(t,e,n){const s=new Gaussian2D;return i=>o=>{let a=i.length/5,l=0,r=o%n,m=(o-r)/n;for(let n=0;n<a;n++)s.fwhm={x:i[n+3*a],y:i[n+4*a]},l+=i[n+2*a]*s.fct((r-i[n])*t,(m-i[n+a])*e);return l}}function getKernel(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{sigma:e=1.4,xLength:n=9,yLength:s=9}=t,i=-40/laplacianOfGaussian(0,0,e);const o=(n-1)/2,a=(s-1)/2;let l=new Array(n);for(let t=0;t<n;t++){l[t]=new Array(s);for(let n=0;n<s;n++)l[t][n]=laplacianOfGaussian(t-o,n-a,e)*i}return l}const laplacianOfGaussian=(t,e,n)=>{let s=-(Math.pow(t,2)+Math.pow(e,2))/2/Math.pow(n,2);return-1/Math.PI/Math.pow(n,4)*(1+s)*Math.exp(s)};let diagonalError=.05,tolerance=.05;function clean(t,e){let n=Number.NEGATIVE_INFINITY;for(let e=t.length-1;e>=0;e--)Math.abs(t[e].z)>n&&(n=Math.abs(t[e].z));n*=e;for(let e=t.length-1;e>=0;e--)Math.abs(t[e].z)<n&&t.splice(e,1);return t}function enhanceSymmetry(t){let e,n=initializeProperties(t),s=t.slice();for(let t=s.length-1;t>=0;t--){let e=s[t];if(e.peaks&&e.peaks.length>1&&n[t][1]++,1===n[t][0]){let i=exist(s,n,e,-1,!0);i>=0&&(n[t][1]+=2,n[i][1]+=2)}}for(let t=s.length-1;t>=0;t--){let i=s[t];0===n[t][0]&&(e=checkCrossPeaks(s,n,i,!0),n[t][1]+=e)}let i=0;for(let t=s.length-1;t>=0;t--)0!==n[t][0]&&n[t][1]>2&&(i++,i+=completeMissingIfNeeded(s,n,s[t],n[t])),n[t][1]>=2&&0===n[t][0]&&i++;let o=new Array(i);i--;for(let t=s.length-1;t>=0;t--)(0!==n[t][0]&&n[t][1]>2||0===n[t][0]&&n[t][1]>1)&&(o[i--]=s[t]);return o}function completeMissingIfNeeded(t,e,n,s){let i,o,a=0,l=null;exist(t,e,n,-s[0],!0)<0&&(i={x:{nucleus:n.x.nucleus,resolution:n.x.resolution,delta:n.y.delta},y:{nucleus:n.y.nucleus,resolution:n.y.resolution,delta:n.x.delta},peaks:[{x:n.y.delta,y:n.x.delta,z:1}]},t.push(i),l=[-s[0],s[1]],e.push(l),a++);let r=!1,m=!1;for(let s=t.length-1;s>=0;s--)o=t[s],0===e[s][0]&&(Math.abs(o.x.delta-n.x.delta)<diagonalError&&(r=!0),Math.abs(o.y.delta-n.y.delta)<diagonalError&&(m=!0));return r||(i={x:{delta:n.y.delta,nucleus:n.x.nucleus,resolution:n.x.resolution},y:{delta:n.x.delta,nucleus:n.y.nucleus,resolution:n.y.resolution},peaks:[{x:n.x.delta,y:n.x.delta,z:1}]},i.peaks=[{x:n.x.delta,y:n.x.delta,z:1}],t.push(i),l=[0,s[1]],e.push(l),a++),m||(i={x:{delta:n.y.delta,nucleus:n.x.nucleus,resolution:n.x.resolution},y:{delta:n.y.delta,nucleus:n.y.nucleus,resolution:n.y.resolution},peaks:[{x:n.y.delta,y:n.y.delta,z:1}]},t.push(i),l=[0,s[1]],e.push(l),a++),a}function checkCrossPeaks(t,e,n,s){let i,o=0,a=4*n.x.delta,l=[],r=[];for(let m=t.length-1;m>=0;m--)i=t[m],0!==e[m][0]&&(Math.abs(i.x.delta-n.x.delta)<diagonalError?(o++,s&&e[m][1]++,l.push(m),a+=i.x.delta):Math.abs(i.y.delta-n.y.delta)<diagonalError&&(o++,s&&e[m][1]++,r.push(m),a+=i.y.delta));if(a/=l.length+r.length+4,l.length>0)for(let e=l.length-1;e>=0;e--)t[l[e]].x.delta=a;if(r.length>0)for(let e=r.length-1;e>=0;e--)t[r[e]].y.delta=a;return n.x.delta=a,n.y.delta=a,o}function exist(t,e,n,s,i){for(let o=t.length-1;o>=0;o--)if(e[o][0]===s&&distanceTo(n,t[o],i)<tolerance){if(i){let e=n.x.delta,s=t[o].x.delta;t[o].y.delta=e,n.y.delta=s}else{let e=(t[o].x.delta+n.x.delta)/2,s=(t[o].y.delta+n.y.delta)/2;t[o].x.delta=e,t[o].y.delta=s,n.x.delta=e,n.y.delta=s}return o}return-1}function initializeProperties(t){let e=new Array(t.length);for(let n=t.length-1;n>=0;n--)if(e[n]=[0,0],Math.abs(t[n].x.delta-t[n].y.delta)<=diagonalError){e[n][1]=1;let s=(2*t[n].x.delta+t[n].y.delta)/3;t[n].x.delta=s,t[n].y.delta=s}else t[n].x.delta-t[n].y.delta>0?e[n][0]=1:e[n][0]=-1;return e}function distanceTo(t,e,n){return n?Math.sqrt(Math.pow(t.x.delta-e.y.delta,2)+Math.pow(t.y.delta-e.x.delta,2)):Math.sqrt(Math.pow(t.x.delta-e.x.delta,2)+Math.pow(t.y.delta-e.y.delta,2))}function padData(t,e){let{minX:n,maxX:s,minY:i,maxY:o}=t;const a=e.width;let l=t.z[0].length,r=t.z.length,m=(o-i)/(r-1),g=(s-n)/(l-1),u=a-r,c=Math.max(a-l,0);c%2&&c++,u%2&&u++;let C=c/2,f=u/2;const h=[];for(let t=0;t<r+u;t++)h.push(new Float64Array(l+c));for(let e=0;e<r;e++)for(let n=0;n<l;n++)h[e+f].set(t.z[e],C);return{...t,z:h,minX:n-C*g,maxX:s+C*g,minY:i-f*m,maxY:o+f*m}}const smallFilter=[[0,0,1,2,2,2,1,0,0],[0,1,4,7,7,7,4,1,0],[1,4,5,3,0,3,5,4,1],[2,7,3,-12,-23,-12,3,7,2],[2,7,0,-23,-40,-23,0,7,2],[2,7,3,-12,-23,-12,3,7,2],[1,4,5,3,0,3,5,4,1],[0,1,3,7,7,7,3,1,0],[0,0,1,2,2,2,1,0,0]];function xyzAutoSignalsPicking(t,e){let{sizeToPad:n=14,realTopDetection:s=!0,thresholdFactor:i=.5,nuclei:o=["1H","1H"],observedFrequencies:a,enhanceSymmetry:l=!1,clean:r=!0,maxPercentCutOff:m=.03,tolerances:g=[24,24],convolutionByFFT:u=!0,kernel:c}=e;if(!Array.isArray(a)&&!ArrayBuffer.isView(a))throw new Error("observedFrequencies is mandatory");i=0===i?1:Math.abs(i);let C=t.z[0].length,f=t.z.length;f<n&&(C=(t=padData(t,{width:n})).z[0].length,f=t.z.length);let h=new Float64Array(C*f),p=new Float64Array(C*f);for(let e=0;e<f;e++){let n=t.z[e];for(let t=0;t<C;t++){let s=e*C+t;h[s]=Math.abs(n[t]),p[s]=n[t]}}const d=c?getKernel(c):smallFilter;let y=findPeaks2DRegion(h,{originalData:p,filteredData:u?convolutionFFT(h,d,{rows:f,cols:C}):convolutionDirect(h,d,{rows:f,cols:C}),rows:f,cols:C,nStdDev:i});r&&(y=clean(y,m));let H=createSignals2D$1(addMissingIDs(y),{nRows:f,nCols:C,minX:t.minX,maxX:t.maxX,minY:t.minY,maxY:t.maxY,absoluteData:h,originalData:p,tolerances:g,nuclei:o,observedFrequencies:a,realTopDetection:s});return l&&(H=enhanceSymmetry(H)),H}function createSignals2D$1(t,e){let{nCols:n,nRows:s,absoluteData:i,originalData:o,observedFrequencies:a,tolerances:l,nuclei:r,realTopDetection:m,minY:g,maxY:u,minX:c,maxX:C}=e,[f,h]=r,[p,d]=l,[y,H]=a,v=(u-g)/(s-1),b=(C-c)/(n-1);m&&(t=determineRealTop(t,{nCols:n,absoluteData:i,originalData:o,minX:c,maxX:C,minY:g,maxY:u}));for(let e=t.length-1;e>=0;e--){let{x:n,y:s}=t[e];t[e].x=c+b*n,t[e].y=g+v*s,t[e].minX=c+b*t[e].minX,t[e].minY=g+v*t[e].minY,t[e].maxX=c+b*t[e].maxX,t[e].maxY=g+v*t[e].maxY}let w=[];for(let e=0;e<t.length;e++)for(let n=e;n<t.length;n++)Math.abs(t[e].x-t[n].x)*y<p&&Math.abs(t[e].y-t[n].y)*H<d?w.push(1):w.push(0);let x=simpleClustering(w),O=[];if(x)for(const e of x){let n={id:v4(),x:{delta:0,nucleus:f,resolution:b},y:{delta:0,nucleus:h,resolution:v}},s=[],i=0;for(let o=0;o<e.length;o++)1===e[o]&&(s.push(t[o]),n.x.delta+=t[o].x*t[o].z,n.y.delta+=t[o].y*t[o].z,i+=t[o].z);n.x.delta/=i,n.y.delta/=i,n.peaks=s,O.push(n)}return O}const{parse:parse$1,stringify:stringify$1}=JSON;function xyzJResAnalyzer(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{reference:n=0,getZones:s=!1,referenceMaxShiftError:i=.08,tolerances:o=[10,100],nuclei:a=["1H","1H"],observedFrequencies:l=[400,400],jAnalyzer:r={jAxisKey:{jAxis:"y",intensity:"z"}}}=e,m=compilePattern(t,{observedFrequencies:l,tolerances:o,nuclei:a,jAnalyzer:r}),g=[];for(const t of m){let e=t.y.delta;Math.abs(e-n)>i||g.push(t)}return g=addMissingIDs(g),s?formatZones(g):g}function compilePattern(t,e){let{observedFrequencies:n,tolerances:s,nuclei:i,jAnalyzer:o}=e,a={observedFrequencies:n,tolerances:s,nuclei:i,dx:t[0].x.resolution,dy:t[0].y.resolution};const l=.02*n[0],r=[];for(const e of t){let t=[];for(const n of e.peaks||[])t.push({...n,width:l});t.sort(((t,e)=>t.y-e.y)),r.push({nbPeaks:t.length,multiplicity:"",pattern:"",startX:t[0].y-l,stopX:t[t.length-1].y+l,delta:e.y.delta,observe:n[1],integralData:{value:-1,from:Number.MAX_SAFE_INTEGER,to:Number.MIN_SAFE_INTEGER},peaks:t})}for(let e=0;e<t.length;e++){const t=jAnalyzer.compilePattern(r[e],o);if(t.maskPattern&&"m"!==t.multiplicity&&""!==t.multiplicity){let e=[];for(let n=t.maskPattern.length-1;n>=0;n--)if(!t.maskPattern[n]){let s=t.peaks.splice(n,1)[0];e.push(s),t.mask.splice(n,1),t.mask2?.splice(n,1),t.maskPattern.splice(n,1),t.nbPeaks--}if(e.length>0){e.reverse();let t=createSignals2D(e,a);for(const e of t)r.push(e)}}}return t.sort(((t,e)=>e.x.delta-t.x.delta)),t}function createSignals2D(t,e){let{observedFrequencies:n,tolerances:s,nuclei:i,dx:o,dy:a}=e;const l=parse$1(stringify$1(t));let[r,m]=i,[g,u]=s,[c,C]=n,f=[];for(let t=0;t<l.length;t++)for(let e=t;e<l.length;e++)Math.abs(l[t].x-l[e].x)*c<g&&Math.abs(l[t].y-l[e].y)*C<u?f.push(1):f.push(0);let h=simpleClustering(f),p=[];if(h)for(let t of h){let e={id:v4(),nucleusX:r,nucleusY:m,integralData:{from:Number.MAX_SAFE_INTEGER,to:Number.MIN_SAFE_INTEGER},nbPeaks:0,multiplicity:"",pattern:"",observe:C,resolutionX:o,resolutionY:a,shiftX:0,shiftY:0},n=[],s=[Number.MAX_VALUE,0],i=[Number.MAX_VALUE,0],g=0;for(let o=t.length-1;o>=0;o--)1===t[o]&&(e.nbPeaks++,l[o].width||(l[o].width=.02),n.push(l[o]),e.shiftX+=l[o].x*l[o].z,e.shiftY+=l[o].y*l[o].z,g+=l[o].z,l[o].minX<s[0]&&(s[0]=l[o].minX),l[o].maxX>s[1]&&(s[1]=l[o].maxX),l[o].minY<i[0]&&(i[0]=l[o].minY),l[o].maxY>i[1]&&(i[1]=l[o].maxY));e.fromTo=[{from:s[0],to:s[1]},{from:i[0],to:i[1]}],e.shiftX/=g,e.shiftY/=g,e.delta1=e.shiftY,e.peaks=n,p.push(e)}return p}function checkData2DFid(t){if(!("re"in t)||!("im"in t))throw new Error("imaginary (im) data should exists")}function quadrature(t,e){checkData2DFid(t);const{fnMode:n}=e;switch(n){case"ttpi":return ttpiQuadrature(t);case"states":return shrQuadrature(t);case"echo":return echoQuadrature(t);default:return{re:t.re.z,im:t.im.z}}}function echoQuadrature(t){const{re:{z:e},im:{z:n}}=t,s=[],i=[];for(let t=0;t<e.length;t+=2){let o=e[t],a=n[t],l=e[t+1],r=n[t+1];s.push(xSubtract(xMultiply(r,-1),a)),s.push(xSubtract(l,o)),i.push(xAdd(l,o)),i.push(xSubtract(r,a))}return{re:s,im:i}}function shrQuadrature(t){const{re:e,im:n}=t;return{re:e.z,im:n.z}}function ttpiQuadrature(t){const e=[],n=[],{re:{z:s},im:{z:i}}=t;for(let t=0;t<s.length;t++)e.push(t%2?s[t].slice():xMultiply(s[t],-1)),n.push(t%2?i[t].slice():xMultiply(i[t],-1));return{re:e,im:n}}function digitalFilter$1(t,e){let{digitalFilterValue:n=0}=e,s=new Float64Array(t.re),i=new Float64Array(t.im),o=Math.floor(n);o+=0;const a=new Float64Array(s.length),l=new Float64Array(i.length);return a.set(s.slice(o)),a.set(s.slice(0,o),s.length-o),l.set(i.slice(o)),l.set(i.slice(0,o),i.length-o),{re:a,im:l}}function removeDCOffset$1(t,e){let{digitalFilterValue:n=0}=e;const s=t.re.length,i=new Float64Array(t.re),o=new Float64Array(t.im),a=xMean(t.re.slice(.75*s>>0,s-n)),l=xMean(t.im.slice(.75*s>>0,s-n));for(let t=n;t<s-n;t++)i[t]-=a,o[t]-=l;return{re:i,im:o}}function zeroFilling$1(t,e){let n,{nbPoints:s,factor:i=2,digitalFilterValue:o=0}=e;s||(s=2**Math.round(Math.log2(t.re.length*i))),n=o>0?Math.floor(o):0;const{re:a,im:l}=t;let r=new Float64Array(s),m=new Float64Array(s);const g=Math.min(s,a.length);return r.set(a.slice(0,g-n)),m.set(l.slice(0,g-n)),n>0&&n<s&&(r.set(a.slice(a.length-n),s-n),m.set(l.slice(a.length-n),s-n)),{re:r,im:m}}function fftDirectDimension(t,e){const{re:n,im:s}=t,i=n.length,o=n[0].length,{zeroFilling:a,digitalFilterValue:l=0}=e,{factor:r=2}=a||{},m=a?.nbPoints||2**Math.round(Math.log2(o*r)),g=new Matrix(i,m),u=new Matrix(i,m),{apodization:c}=e;let{ph0:C,ph1:f,mode:h="no"}=e?.phaseCorrection||{};for(let t=0;t<i;t++){const e=digitalFilter$1({re:n[t],im:s[t]},{digitalFilterValue:l});if(Object.assign(e,removeDCOffset$1(e,{digitalFilterValue:l})),c){const{re:t,im:n}=apodization$1(e,c);Object.assign(e,{re:t,im:n})}Object.assign(e,zeroFilling$1(e,{digitalFilterValue:l,nbPoints:m})),Object.assign(e,reimFFT(e,{applyZeroShift:!0}));const i=(l-Math.round(l))*Math.PI*2;if(i>0&&Object.assign(e,reimPhaseCorrection(e,0,-i)),0===t&&"pk"===h&&void 0===C&&void 0===f){const t=reimAutoPhaseCorrection(e,{magnitudeMode:!1});C=t.ph0,f=t.ph1}"pk"===h&&void 0!==C&&void 0!==f&&Object.assign(e,reimPhaseCorrection(e,C*Math.PI/180,f*Math.PI/180)),g.setRow(t,e.re),u.setRow(t,e.im)}return{re:g,im:u}}function fftIndirectDimension(t,e){const n=Matrix.checkMatrix(t.re),s=Matrix.checkMatrix(t.im),i=n.rows,o=n.columns,{zeroFilling:a}=e,{factor:l=2}=a||{},r=a?.nbPoints||2**Math.round(Math.log2(i*l)),{apodization:m}=e;let{ph0:g,ph1:u,mode:c}=e.phaseCorrection||{};const C=new Matrix(r,o),f=new Matrix(r,o);for(let t=0;t<o;t++){const{re:i,im:o}=apodization$1({re:n.getColumn(t),im:s.getColumn(t)},m),a=[],l=[];if("echo"===e.fnMode)for(let t=0;t<i.length;t+=2)a.push(i[t]),l.push(i[t+1]);else for(let t=0;t<i.length;t++)a.push(i[t]),l.push(-o[t]);let h=reimFFT(zeroFilling$1({re:a,im:l},{digitalFilterValue:0,nbPoints:r}),{applyZeroShift:!0}),{re:p,im:d}=h;if("mc"===e.phaseCorrection?.mode&&(p=reimAbsolute({re:p,im:d}),d=new Float64Array(d.length)),"pk"===c){if(0===t&&void 0===g&&void 0===u){const t=reimAutoPhaseCorrection({re:p,im:d},{magnitudeMode:!1});g=t.ph0,u=t.ph1}void 0!==g&&void 0!==u&&Object.assign(h,reimPhaseCorrection(h,g*Math.PI/180,u*Math.PI/180))}C.setColumn(t,p),f.setColumn(t,d)}return{re:C,im:f}}function xyzBidimensionalFFT(t,e){ensureData2DFid(t);const{info:n,fnMode:s,digitalFilterValue:i=0,zeroFilling:o}=e,a=quadrature(t,{fnMode:s}),{re:l}=a,r=l.length,m=l[0].length,{direct:g={},indirect:u={}}=e,{zeroFilling:c=o}=g,{factor:C=2}=c||{},f=c?.nbPoints||2**Math.round(Math.log2(m*C)),h=fftDirectDimension(a,{...g,fnMode:s,digitalFilterValue:i,zeroFilling:{nbPoints:f}}),{zeroFilling:p}=e,{factor:d=2}=p||{},y=p?.nbPoints||2**Math.round(Math.log2(r*d)),{re:H,im:v}=fftIndirectDimension(h,{...u,fnMode:s,zeroFilling:{nbPoints:y}}),b=getMinMaxXY(n);return{re:{z:convertToDoubleArray(H),maxZ:H.max(),minZ:H.min(),...b},im:{z:convertToDoubleArray(v),maxZ:v.max(),minZ:v.min(),...b}}}function ensureData2DFid(t){if(!("re"in t))throw new Error("bidimensional FFT only can be applied to raw data")}function convertToDoubleArray(t){const e=new Array(t.rows);for(let n=0;n<t.rows;n++)e[n]=new Float64Array(t.getRow(n));return e}function getMinMaxXY(t){const e=[],n=[];for(let s=0;s<t.baseFrequency.length;s++){const i=Number.parseFloat(t.baseFrequency[s]),o=Number.parseFloat(t.frequencyOffset[s]),a=Number.parseFloat(t.spectralWidth[s]),l=o/i;e.push(l-.5*a),n.push(l+.5*a)}return{minX:e[0],maxX:n[0],minY:e[1],maxY:n[1]}}async function getDatabase(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"https://docs.google.com/spreadsheets/d/1uwyq_L38PMRWCcT4If_EhPbHKyY3q_2tpjV8vr5_zh0/edit?usp=sharing",e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{format:n="tsv"}=e;let s;t.includes("google.com")&&(t=`https://googledocs.cheminfo.org/spreadsheets/d/${extractGoogleUUID(t)}/export?format=tsv`);const i=await browserPonyfill.exports.fetch(t);switch(n){case"tsv":s=parseData(await i.text());break;case"json":s=await i.json();break;default:throw new Error("unknown database format")}const o=[];for(let t of s.data){const e={smiles:"",solvent:"",nucleus:"",jcampURL:"",names:[],meta:{},ranges:[]};for(let n=0;n<t.length;n++)switch(s.kinds[n]){case"smiles":e.smiles=t[n];break;case"solvent":e.solvent=t[n];break;case"nucleus":e.nucleus=t[n];break;case"jcampURL":e.jcampURL=t[n];break;case"name":e.names&&e.names.push(t[n]);break;case"meta":e.meta&&(e.meta[s.labels[n]]=t[n]);break;case"signal":{const s=resurrectRange(t[n]);s&&e.ranges.push(s);break}default:throw new Error(`Unknown column kind: ${s.kinds[n]}`)}o.push(e)}return o}function extractGoogleUUID(t){return t.replace(/.*\/(?<uuid>[^/]{20,50}).*/,"$<uuid>")}function parseData(t){const e=t.split(/\r?\n/).filter((t=>!/^\s*$/.exec(t))).map((t=>t.split("\t").map((t=>t.trim()))));return{labels:e[0],kinds:e[1],data:e.slice(2)}}const carbonImpurities=[{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:171.69,assignment:"CO"}],from:171.68625,to:171.69375},{signals:[{delta:20.13,assignment:"CH₃"}],from:20.12625,to:20.13375}],nucleus:"13C",solvent:"THF-d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204.19,assignment:"CO"}],from:204.18625,to:204.19375},{signals:[{delta:30.17,assignment:"CH₃"}],from:30.16625,to:30.173750000000002}],nucleus:"13C",solvent:"THF-d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.79,assignment:"CN"}],from:116.78625000000001,to:116.79375},{signals:[{delta:.45,assignment:"CH₃"}],from:.44625000000000004,to:.45375}],nucleus:"13C",solvent:"THF-d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.84,assignment:"CH"}],from:128.83625,to:128.84375}],nucleus:"13C",solvent:"THF-d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:67.5,assignment:"(CH₃)₃C"}],from:67.49625,to:67.50375},{signals:[{delta:30.57,assignment:"(CH₃)₃C"}],from:30.56625,to:30.57375}],nucleus:"13C",solvent:"THF-d₈"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.69,assignment:"CO₂"}],from:125.68625,to:125.69375}],nucleus:"13C",solvent:"THF-d₈"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.37,assignment:"CS₂"}],from:193.36625,to:193.37375}],nucleus:"13C",solvent:"THF-d₈"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.89,assignment:"CCl₄"}],from:96.88625,to:96.89375}],nucleus:"13C",solvent:"THF-d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.24,assignment:"CH"}],from:79.23625,to:79.24374999999999}],nucleus:"13C",solvent:"THF-d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.34,assignment:"CH₂"}],from:71.33625,to:71.34375}],nucleus:"13C",solvent:"THF-d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.58,assignment:"CH₂"}],from:27.576249999999998,to:27.58375}],nucleus:"13C",solvent:"THF-d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:44.64,assignment:"CH₂"}],from:44.636250000000004,to:44.64375}],nucleus:"13C",solvent:"THF-d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.67,assignment:"CH₂"}],from:54.666250000000005,to:54.67375}],nucleus:"13C",solvent:"THF-d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.49,assignment:"CH₃"}],from:15.48625,to:15.49375},{signals:[{delta:66.14,assignment:"CH₂"}],from:66.13625,to:66.14375}],nucleus:"13C",solvent:"THF-d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.72,assignment:"CH₃"}],from:58.71625,to:58.723749999999995},{signals:[{delta:71.17,assignment:"CH₂"}],from:71.16625,to:71.17375},{signals:[{delta:72.72,assignment:"CH₂"}],from:72.71625,to:72.72375}],nucleus:"13C",solvent:"THF-d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:161.96,assignment:"CH"}],from:161.95625,to:161.96375},{signals:[{delta:35.65,assignment:"CH₃"}],from:35.64625,to:35.653749999999995},{signals:[{delta:30.7,assignment:"CH₃"}],from:30.69625,to:30.70375}],nucleus:"13C",solvent:"THF-d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.65,assignment:"CH₂"}],from:67.64625000000001,to:67.65375}],nucleus:"13C",solvent:"THF-d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.72,assignment:"CH₃"}],from:58.71625,to:58.723749999999995},{signals:[{delta:72.58,assignment:"CH₂"}],from:72.57625,to:72.58375}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.79,assignment:"CH₃"}],from:6.78625,to:6.79375}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.9,assignment:"CH₃"}],from:18.89625,to:18.90375},{signals:[{delta:57.6,assignment:"CH₂"}],from:57.596250000000005,to:57.60375}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.45,assignment:"CH₃CO"}],from:20.44625,to:20.45375},{signals:[{delta:170.32,assignment:"CO"}],from:170.31625,to:170.32375},{signals:[{delta:60.3,assignment:"CH₂"}],from:60.29625,to:60.303749999999994},{signals:[{delta:14.37,assignment:"CH₃"}],from:14.366249999999999,to:14.37375}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.09,assignment:"CH₂"}],from:123.08625,to:123.09375}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.35,assignment:"CH₂"}],from:64.34625,to:64.35374999999999}],nucleus:"13C",solvent:"THF-d₈"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.45,assignment:"CH₂"}],from:30.44625,to:30.45375}],nucleus:"13C",solvent:"THF-d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.88,assignment:"C"}],from:131.87625,to:131.88375},{signals:[{delta:16.71,assignment:"CH₃"}],from:16.70625,to:16.71375}],nucleus:"13C",solvent:"THF-d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.22,assignment:"CH₃"}],from:14.21625,to:14.22375},{signals:[{delta:23.33,assignment:"CH₂(2,5)"}],from:23.326249999999998,to:23.33375},{signals:[{delta:32.34,assignment:"CH₂(3,4)"}],from:32.33625000000001,to:32.34375}],nucleus:"13C",solvent:"THF-d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.83,assignment:"CH₃"}],from:1.8262500000000002,to:1.83375}],nucleus:"13C",solvent:"THF-d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.89,assignment:"CH₃"}],from:36.886250000000004,to:36.89375}],nucleus:"13C",solvent:"THF-d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.72,assignment:"CH(2)"}],from:135.71625,to:135.72375},{signals:[{delta:122.2,assignment:"CH(4,5)"}],from:122.19625,to:122.20375}],nucleus:"13C",solvent:"THF-d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.9,assignment:"CH₄"}],from:-4.9037500000000005,to:-4.89625}],nucleus:"13C",solvent:"THF-d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.64,assignment:"CH₃"}],from:49.636250000000004,to:49.64375}],nucleus:"13C",solvent:"THF-d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:62.49,assignment:"CH₃"}],from:62.486250000000005,to:62.49375}],nucleus:"13C",solvent:"THF-d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.18,assignment:"CH₃"}],from:14.17625,to:14.18375},{signals:[{delta:23,assignment:"CH₂(2,4)"}],from:22.99625,to:23.00375},{signals:[{delta:34.87,assignment:"CH₂(3)"}],from:34.86625,to:34.873749999999994}],nucleus:"13C",solvent:"THF-d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.6,assignment:"CH₃"}],from:16.59625,to:16.60375},{signals:[{delta:16.82,assignment:"CH₂"}],from:16.81625,to:16.82375}],nucleus:"13C",solvent:"THF-d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.7,assignment:"CH₃"}],from:25.69625,to:25.70375},{signals:[{delta:66.14,assignment:"CH"}],from:66.13625,to:66.14375}],nucleus:"13C",solvent:"THF-d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.27,assignment:"CH₃"}],from:19.26625,to:19.27375},{signals:[{delta:115.74,assignment:"CH₂"}],from:115.73625,to:115.74374999999999},{signals:[{delta:134.02,assignment:"CH"}],from:134.01625,to:134.02375}],nucleus:"13C",solvent:"THF-d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.57,assignment:"CH(2,6)"}],from:150.56625,to:150.57375},{signals:[{delta:124.08,assignment:"CH(3,5)"}],from:124.07625,to:124.08375},{signals:[{delta:135.99,assignment:"CH(4)"}],from:135.98625,to:135.99375}],nucleus:"13C",solvent:"THF-d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:118.03,assignment:"CH(2,5)"}],from:118.02625,to:118.03375},{signals:[{delta:107.74,assignment:"CH(3,4)"}],from:107.73625,to:107.74374999999999}],nucleus:"13C",solvent:"THF-d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:45.82,assignment:"CH₂(2,5)"}],from:45.816250000000004,to:45.82375},{signals:[{delta:26.17,assignment:"CH₂(3,4)"}],from:26.16625,to:26.173750000000002}],nucleus:"13C",solvent:"THF-d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.2,assignment:"CH₃"}],from:1.19625,to:1.2037499999999999}],nucleus:"13C",solvent:"THF-d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.03,assignment:"CH₂(2,5)"}],from:68.02625,to:68.03375},{signals:[{delta:26.19,assignment:"CH₂(3,4)"}],from:26.18625,to:26.19375}],nucleus:"13C",solvent:"THF-d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.29,assignment:"CH₃"}],from:21.28625,to:21.29375},{signals:[{delta:138.24,assignment:"C(1)"}],from:138.23625,to:138.24375},{signals:[{delta:129.47,assignment:"CH(2,6)"}],from:129.46625,to:129.47375},{signals:[{delta:128.71,assignment:"CH(3,5)"}],from:128.70625,to:128.71375},{signals:[{delta:125.84,assignment:"CH(4)"}],from:125.83625,to:125.84375}],nucleus:"13C",solvent:"THF-d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.51,assignment:"CH₃"}],from:12.50625,to:12.51375},{signals:[{delta:47.18,assignment:"CH₂"}],from:47.17625,to:47.183749999999996}],nucleus:"13C",solvent:"THF-d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.85,assignment:"CO"}],from:175.84625,to:175.85375},{signals:[{delta:20.91,assignment:"CH₃"}],from:20.90625,to:20.91375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:206.78,assignment:"CO"}],from:206.77625,to:206.78375},{signals:[{delta:31,assignment:"CH₃"}],from:30.99625,to:31.00375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.92,assignment:"CN"}],from:116.91625,to:116.92375},{signals:[{delta:2.03,assignment:"CH₃"}],from:2.0262499999999997,to:2.03375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.68,assignment:"CH"}],from:128.67625,to:128.68375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:69.11,assignment:"(CH₃)₃C"}],from:69.10625,to:69.11375},{signals:[{delta:31.46,assignment:"(CH₃)₃C"}],from:31.45625,to:31.46375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.26,assignment:"CO₂"}],from:125.25625000000001,to:125.26375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.95,assignment:"CS₂"}],from:192.94625,to:192.95374999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.52,assignment:"CCl₄"}],from:96.51625,to:96.52374999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.99,assignment:"CH"}],from:77.98625,to:77.99374999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.47,assignment:"CH₂"}],from:70.46625,to:70.47375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.38,assignment:"CH₂"}],from:27.37625,to:27.38375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:44.35,assignment:"CH₂"}],from:44.346250000000005,to:44.35375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.24,assignment:"CH₂"}],from:54.236250000000005,to:54.24375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.44,assignment:"CH₃"}],from:15.43625,to:15.44375},{signals:[{delta:66.11,assignment:"CH₂"}],from:66.10625,to:66.11375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.95,assignment:"CH₃"}],from:58.946250000000006,to:58.95375},{signals:[{delta:70.7,assignment:"CH₂"}],from:70.69625,to:70.70375},{signals:[{delta:72.25,assignment:"CH₂"}],from:72.24625,to:72.25375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.57,assignment:"CH"}],from:162.56625,to:162.57375},{signals:[{delta:36.56,assignment:"CH₃"}],from:36.556250000000006,to:36.56375},{signals:[{delta:31.39,assignment:"CH₃"}],from:31.38625,to:31.39375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.47,assignment:"CH₂"}],from:67.46625,to:67.47375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.02,assignment:"CH₃"}],from:59.01625000000001,to:59.02375},{signals:[{delta:72.24,assignment:"CH₂"}],from:72.23625,to:72.24374999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.91,assignment:"CH₃"}],from:6.90625,to:6.91375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.69,assignment:"CH₃"}],from:18.68625,to:18.69375},{signals:[{delta:58.57,assignment:"CH₂"}],from:58.566250000000004,to:58.57375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.15,assignment:"CH₃CO"}],from:21.14625,to:21.15375},{signals:[{delta:171.24,assignment:"CO"}],from:171.23625,to:171.24375},{signals:[{delta:60.63,assignment:"CH₂"}],from:60.626250000000006,to:60.63375},{signals:[{delta:14.37,assignment:"CH₃"}],from:14.366249999999999,to:14.37375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.2,assignment:"CH₂"}],from:123.19625,to:123.20375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.08,assignment:"CH₂"}],from:64.07625,to:64.08375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.14,assignment:"CH₂"}],from:30.13625,to:30.14375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.09,assignment:"C"}],from:132.08625,to:132.09375},{signals:[{delta:16.93,assignment:"CH₃"}],from:16.92625,to:16.93375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.28,assignment:"CH₃"}],from:14.27625,to:14.28375},{signals:[{delta:23.07,assignment:"CH₂(2,5)"}],from:23.06625,to:23.07375},{signals:[{delta:32.01,assignment:"CH₂(3,4)"}],from:32.00625,to:32.013749999999995}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.96,assignment:"CH₃"}],from:1.95625,to:1.9637499999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.99,assignment:"CH₃"}],from:36.986250000000005,to:36.99375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.76,assignment:"CH(2)"}],from:135.75625,to:135.76375},{signals:[{delta:122.16,assignment:"CH(4,5)"}],from:122.15625,to:122.16375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.33,assignment:"CH₄"}],from:-4.33375,to:-4.32625}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:50.45,assignment:"CH₃"}],from:50.446250000000006,to:50.45375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.03,assignment:"CH₃"}],from:63.026250000000005,to:63.03375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.24,assignment:"CH₃"}],from:14.23625,to:14.24375},{signals:[{delta:22.77,assignment:"CH₂(2,4)"}],from:22.76625,to:22.77375},{signals:[{delta:34.57,assignment:"CH₂(3)"}],from:34.566250000000004,to:34.57375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.63,assignment:"CH₃"}],from:16.62625,to:16.63375},{signals:[{delta:16.63,assignment:"CH₂"}],from:16.62625,to:16.63375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.43,assignment:"CH₃"}],from:25.42625,to:25.43375},{signals:[{delta:64.67,assignment:"CH"}],from:64.66625,to:64.67375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.47,assignment:"CH₃"}],from:19.46625,to:19.47375},{signals:[{delta:115.7,assignment:"CH₂"}],from:115.69625,to:115.70375},{signals:[{delta:134.21,assignment:"CH"}],from:134.20625,to:134.21375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.27,assignment:"CH(2,6)"}],from:150.26625,to:150.27375},{signals:[{delta:124.06,assignment:"CH(3,5)"}],from:124.05625,to:124.06375},{signals:[{delta:136.16,assignment:"CH(4)"}],from:136.15625,to:136.16375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.93,assignment:"CH(2,5)"}],from:117.92625000000001,to:117.93375},{signals:[{delta:108.02,assignment:"CH(3,4)"}],from:108.01625,to:108.02374999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.02,assignment:"CH₂(2,5)"}],from:47.01625000000001,to:47.02375},{signals:[{delta:25.83,assignment:"CH₂(3,4)"}],from:25.826249999999998,to:25.83375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.22,assignment:"CH₃"}],from:1.21625,to:1.22375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.16,assignment:"CH₂(2,5)"}],from:68.15625,to:68.16375},{signals:[{delta:25.98,assignment:"CH₂(3,4)"}],from:25.97625,to:25.98375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.53,assignment:"CH₃"}],from:21.52625,to:21.53375},{signals:[{delta:138.36,assignment:"C(1)"}],from:138.35625000000002,to:138.36375},{signals:[{delta:129.35,assignment:"CH(2,6)"}],from:129.34625,to:129.35375},{signals:[{delta:128.54,assignment:"CH(3,5)"}],from:128.53625,to:128.54375},{signals:[{delta:125.62,assignment:"CH(4)"}],from:125.61625000000001,to:125.62375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.12,assignment:"CH₃"}],from:12.116249999999999,to:12.12375},{signals:[{delta:46.75,assignment:"CH₂"}],from:46.74625,to:46.75375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.99,assignment:"CO"}],from:175.98625,to:175.99375},{signals:[{delta:20.81,assignment:"CH₃"}],from:20.80625,to:20.81375}],nucleus:"13C",solvent:"CDCl₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:207.07,assignment:"CO"}],from:207.06625,to:207.07375},{signals:[{delta:30.92,assignment:"CH₃"}],from:30.91625,to:30.923750000000002}],nucleus:"13C",solvent:"CDCl₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.43,assignment:"CN"}],from:116.42625000000001,to:116.43375},{signals:[{delta:1.89,assignment:"CH₃"}],from:1.88625,to:1.8937499999999998}],nucleus:"13C",solvent:"CDCl₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.37,assignment:"CH"}],from:128.36625,to:128.37375}],nucleus:"13C",solvent:"CDCl₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:69.15,assignment:"(CH₃)₃C"}],from:69.14625000000001,to:69.15375},{signals:[{delta:31.25,assignment:"(CH₃)₃C"}],from:31.24625,to:31.25375}],nucleus:"13C",solvent:"CDCl₃"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.99,assignment:"CO₂"}],from:124.98625,to:124.99374999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.83,assignment:"CS₂"}],from:192.82625000000002,to:192.83375}],nucleus:"13C",solvent:"CDCl₃"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.34,assignment:"CCl₄"}],from:96.33625,to:96.34375}],nucleus:"13C",solvent:"CDCl₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.36,assignment:"CH"}],from:77.35625,to:77.36375}],nucleus:"13C",solvent:"CDCl₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.55,assignment:"CH₂"}],from:70.54625,to:70.55375}],nucleus:"13C",solvent:"CDCl₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:26.94,assignment:"CH₂"}],from:26.93625,to:26.94375}],nucleus:"13C",solvent:"CDCl₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.5,assignment:"CH₂"}],from:43.49625,to:43.50375}],nucleus:"13C",solvent:"CDCl₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.52,assignment:"CH₂"}],from:53.51625000000001,to:53.52375}],nucleus:"13C",solvent:"CDCl₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.2,assignment:"CH₃"}],from:15.19625,to:15.20375},{signals:[{delta:65.91,assignment:"CH₂"}],from:65.90625,to:65.91375}],nucleus:"13C",solvent:"CDCl₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:59.01,assignment:"CH₃"}],from:59.00625,to:59.013749999999995},{signals:[{delta:70.51,assignment:"CH₂"}],from:70.50625000000001,to:70.51375},{signals:[{delta:71.9,assignment:"CH₂"}],from:71.89625000000001,to:71.90375}],nucleus:"13C",solvent:"CDCl₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.62,assignment:"CH"}],from:162.61625,to:162.62375},{signals:[{delta:36.5,assignment:"CH₃"}],from:36.49625,to:36.50375},{signals:[{delta:31.45,assignment:"CH₃"}],from:31.44625,to:31.45375}],nucleus:"13C",solvent:"CDCl₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.14,assignment:"CH₂"}],from:67.13625,to:67.14375}],nucleus:"13C",solvent:"CDCl₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.08,assignment:"CH₃"}],from:59.07625,to:59.083749999999995},{signals:[{delta:71.84,assignment:"CH₂"}],from:71.83625,to:71.84375}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.89,assignment:"CH₃"}],from:6.8862499999999995,to:6.89375}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.41,assignment:"CH₃"}],from:18.40625,to:18.41375},{signals:[{delta:58.28,assignment:"CH₂"}],from:58.276250000000005,to:58.28375}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.04,assignment:"CH₃CO"}],from:21.03625,to:21.04375},{signals:[{delta:171.36,assignment:"CO"}],from:171.35625000000002,to:171.36375},{signals:[{delta:60.49,assignment:"CH₂"}],from:60.486250000000005,to:60.49375},{signals:[{delta:14.19,assignment:"CH₃"}],from:14.18625,to:14.19375}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.13,assignment:"CH₂"}],from:123.12625,to:123.13374999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:63.79,assignment:"CH₂"}],from:63.78625,to:63.793749999999996}],nucleus:"13C",solvent:"CDCl₃"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:29.71,assignment:"CH₂"}],from:29.70625,to:29.71375}],nucleus:"13C",solvent:"CDCl₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.21,assignment:"C"}],from:132.20625,to:132.21375},{signals:[{delta:16.98,assignment:"CH₃"}],from:16.97625,to:16.98375}],nucleus:"13C",solvent:"CDCl₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.14,assignment:"CH₃"}],from:14.13625,to:14.14375},{signals:[{delta:22.7,assignment:"CH₂(2,5)"}],from:22.69625,to:22.70375},{signals:[{delta:31.64,assignment:"CH₂(3,4)"}],from:31.63625,to:31.64375}],nucleus:"13C",solvent:"CDCl₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.97,assignment:"CH₃"}],from:1.96625,to:1.97375}],nucleus:"13C",solvent:"CDCl₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.87,assignment:"CH₃"}],from:36.86625,to:36.873749999999994}],nucleus:"13C",solvent:"CDCl₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.38,assignment:"CH(2)"}],from:135.37625,to:135.38375},{signals:[{delta:122,assignment:"CH(4,5)"}],from:121.99625,to:122.00375}],nucleus:"13C",solvent:"CDCl₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.63,assignment:"CH₄"}],from:-4.63375,to:-4.62625}],nucleus:"13C",solvent:"CDCl₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:50.41,assignment:"CH₃"}],from:50.40625,to:50.41374999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:62.5,assignment:"CH₃"}],from:62.49625,to:62.50375}],nucleus:"13C",solvent:"CDCl₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.08,assignment:"CH₃"}],from:14.07625,to:14.08375},{signals:[{delta:22.38,assignment:"CH₂(2,4)"}],from:22.37625,to:22.38375},{signals:[{delta:34.16,assignment:"CH₂(3)"}],from:34.15625,to:34.16374999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.63,assignment:"CH₃"}],from:16.62625,to:16.63375},{signals:[{delta:16.37,assignment:"CH₂"}],from:16.36625,to:16.37375}],nucleus:"13C",solvent:"CDCl₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.14,assignment:"CH₃"}],from:25.13625,to:25.14375},{signals:[{delta:64.5,assignment:"CH"}],from:64.49625,to:64.50375}],nucleus:"13C",solvent:"CDCl₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.5,assignment:"CH₃"}],from:19.49625,to:19.50375},{signals:[{delta:115.74,assignment:"CH₂"}],from:115.73625,to:115.74374999999999},{signals:[{delta:133.91,assignment:"CH"}],from:133.90625,to:133.91375}],nucleus:"13C",solvent:"CDCl₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.9,assignment:"CH(2,6)"}],from:149.89625,to:149.90375},{signals:[{delta:123.75,assignment:"CH(3,5)"}],from:123.74625,to:123.75375},{signals:[{delta:135.96,assignment:"CH(4)"}],from:135.95625,to:135.96375}],nucleus:"13C",solvent:"CDCl₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.77,assignment:"CH(2,5)"}],from:117.76625,to:117.77374999999999},{signals:[{delta:107.98,assignment:"CH(3,4)"}],from:107.97625000000001,to:107.98375}],nucleus:"13C",solvent:"CDCl₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.93,assignment:"CH₂(2,5)"}],from:46.92625,to:46.933749999999996},{signals:[{delta:25.56,assignment:"CH₂(3,4)"}],from:25.55625,to:25.56375}],nucleus:"13C",solvent:"CDCl₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.19,assignment:"CH₃"}],from:1.18625,to:1.1937499999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.97,assignment:"CH₂(2,5)"}],from:67.96625,to:67.97375},{signals:[{delta:25.62,assignment:"CH₂(3,4)"}],from:25.61625,to:25.62375}],nucleus:"13C",solvent:"CDCl₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.46,assignment:"CH₃"}],from:21.45625,to:21.46375},{signals:[{delta:137.89,assignment:"C(1)"}],from:137.88625,to:137.89374999999998},{signals:[{delta:129.07,assignment:"CH(2,6)"}],from:129.06625,to:129.07375},{signals:[{delta:128.26,assignment:"CH(3,5)"}],from:128.25625,to:128.26375},{signals:[{delta:125.33,assignment:"CH(4)"}],from:125.32625,to:125.33375}],nucleus:"13C",solvent:"CDCl₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.61,assignment:"CH₃"}],from:11.60625,to:11.61375},{signals:[{delta:46.25,assignment:"CH₂"}],from:46.24625,to:46.25375}],nucleus:"13C",solvent:"CDCl₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.3,assignment:"CO"}],from:175.29625000000001,to:175.30375},{signals:[{delta:20.27,assignment:"CH₃"}],from:20.26625,to:20.27375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204,assignment:"CO"}],from:203.99625,to:204.00375},{signals:[{delta:30.03,assignment:"CH₃"}],from:30.02625,to:30.03375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:115.76,assignment:"CN"}],from:115.75625000000001,to:115.76375},{signals:[{delta:.03,assignment:"CH₃"}],from:.02625,to:.03375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.57,assignment:"CH"}],from:128.56625,to:128.57375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.12,assignment:"(CH₃)₃C"}],from:68.11625000000001,to:68.12375},{signals:[{delta:30.49,assignment:"(CH₃)₃C"}],from:30.48625,to:30.49375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.86,assignment:"CO₂"}],from:124.85625,to:124.86375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.71,assignment:"CS₂"}],from:192.70625,to:192.71375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.57,assignment:"CCl₄"}],from:96.56625,to:96.57374999999999}],nucleus:"13C",solvent:"toluene- d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.89,assignment:"CH"}],from:77.88625,to:77.89375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.86,assignment:"CH₂"}],from:70.85625,to:70.86375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.31,assignment:"CH₂"}],from:27.30625,to:27.31375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.4,assignment:"CH₂"}],from:43.39625,to:43.403749999999995}],nucleus:"13C",solvent:"toluene- d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.47,assignment:"CH₂"}],from:53.46625,to:53.473749999999995}],nucleus:"13C",solvent:"toluene- d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.47,assignment:"CH₃"}],from:15.46625,to:15.47375},{signals:[{delta:65.94,assignment:"CH₂"}],from:65.93625,to:65.94375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.62,assignment:"CH₃"}],from:58.61625,to:58.623749999999994},{signals:[{delta:70.92,assignment:"CH₂"}],from:70.91625,to:70.92375},{signals:[{delta:72.39,assignment:"CH₂"}],from:72.38625,to:72.39375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:161.93,assignment:"CH"}],from:161.92625,to:161.93375},{signals:[{delta:35.22,assignment:"CH₃"}],from:35.21625,to:35.223749999999995},{signals:[{delta:30.64,assignment:"CH₃"}],from:30.63625,to:30.64375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.17,assignment:"CH₂"}],from:67.16625,to:67.17375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.63,assignment:"CH₃"}],from:58.626250000000006,to:58.63375},{signals:[{delta:72.25,assignment:"CH₂"}],from:72.24625,to:72.25375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.94,assignment:"CH₃"}],from:6.93625,to:6.9437500000000005}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.78,assignment:"CH₃"}],from:18.77625,to:18.78375},{signals:[{delta:57.81,assignment:"CH₂"}],from:57.806250000000006,to:57.81375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.46,assignment:"CH₃CO"}],from:20.45625,to:20.46375},{signals:[{delta:170.02,assignment:"CO"}],from:170.01625,to:170.02375},{signals:[{delta:60.08,assignment:"CH₂"}],from:60.07625,to:60.083749999999995},{signals:[{delta:14.23,assignment:"CH₃"}],from:14.22625,to:14.23375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:122.92,assignment:"CH₂"}],from:122.91625,to:122.92375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.29,assignment:"CH₂"}],from:64.28625000000001,to:64.29375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.31,assignment:"CH₂"}],from:30.30625,to:30.31375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.72,assignment:"C"}],from:131.71625,to:131.72375},{signals:[{delta:16.84,assignment:"CH₃"}],from:16.83625,to:16.84375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.34,assignment:"CH₃"}],from:14.33625,to:14.34375},{signals:[{delta:23.12,assignment:"CH₂(2,5)"}],from:23.11625,to:23.12375},{signals:[{delta:32.06,assignment:"CH₂(3,4)"}],from:32.056250000000006,to:32.06375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.99,assignment:"CH₃"}],from:1.98625,to:1.99375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.8,assignment:"CH₃"}],from:36.79625,to:36.803749999999994}],nucleus:"13C",solvent:"toluene- d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.57,assignment:"CH(2)"}],from:135.56625,to:135.57375},{signals:[{delta:122.13,assignment:"CH(4,5)"}],from:122.12625,to:122.13374999999999}],nucleus:"13C",solvent:"toluene- d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.34,assignment:"CH₄"}],from:-4.34375,to:-4.33625}],nucleus:"13C",solvent:"toluene- d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.9,assignment:"CH₃"}],from:49.89625,to:49.903749999999995}],nucleus:"13C",solvent:"toluene- d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:61.14,assignment:"CH₃"}],from:61.136250000000004,to:61.14375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.27,assignment:"CH₃"}],from:14.26625,to:14.27375},{signals:[{delta:22.79,assignment:"CH₂(2,4)"}],from:22.78625,to:22.79375},{signals:[{delta:34.54,assignment:"CH₂(3)"}],from:34.53625,to:34.543749999999996}],nucleus:"13C",solvent:"toluene- d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.65,assignment:"CH₃"}],from:16.64625,to:16.65375},{signals:[{delta:16.63,assignment:"CH₂"}],from:16.62625,to:16.63375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.24,assignment:"CH₃"}],from:25.23625,to:25.24375},{signals:[{delta:64.12,assignment:"CH"}],from:64.11625000000001,to:64.12375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.32,assignment:"CH₃"}],from:19.31625,to:19.32375},{signals:[{delta:115.89,assignment:"CH₂"}],from:115.88625,to:115.89375},{signals:[{delta:133.61,assignment:"CH"}],from:133.60625000000002,to:133.61375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.25,assignment:"CH(2,6)"}],from:150.24625,to:150.25375},{signals:[{delta:123.46,assignment:"CH(3,5)"}],from:123.45625,to:123.46374999999999},{signals:[{delta:135.17,assignment:"CH(4)"}],from:135.16625,to:135.17374999999998}],nucleus:"13C",solvent:"toluene- d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.61,assignment:"CH(2,5)"}],from:117.60625,to:117.61375},{signals:[{delta:108.15,assignment:"CH(3,4)"}],from:108.14625000000001,to:108.15375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.12,assignment:"CH₂(2,5)"}],from:47.11625,to:47.123749999999994},{signals:[{delta:25.75,assignment:"CH₂(3,4)"}],from:25.74625,to:25.75375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.37,assignment:"CH₃"}],from:1.3662500000000002,to:1.37375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.75,assignment:"CH₂(2,5)"}],from:67.74625,to:67.75375},{signals:[{delta:25.79,assignment:"CH₂(3,4)"}],from:25.78625,to:25.79375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.37,assignment:"CH₃"}],from:21.36625,to:21.37375},{signals:[{delta:137.84,assignment:"C(1)"}],from:137.83625,to:137.84375},{signals:[{delta:129.33,assignment:"CH(2,6)"}],from:129.32625000000002,to:129.33375},{signals:[{delta:128.51,assignment:"CH(3,5)"}],from:128.50625,to:128.51375},{signals:[{delta:125.66,assignment:"CH(4)"}],from:125.65625,to:125.66375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.39,assignment:"CH₃"}],from:12.38625,to:12.39375},{signals:[{delta:46.82,assignment:"CH₂"}],from:46.816250000000004,to:46.82375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.82,assignment:"CO"}],from:175.81625,to:175.82375},{signals:[{delta:20.37,assignment:"CH₃"}],from:20.36625,to:20.37375}],nucleus:"13C",solvent:"C₆D₆"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204.43,assignment:"CO"}],from:204.42625,to:204.43375},{signals:[{delta:30.14,assignment:"CH₃"}],from:30.13625,to:30.14375}],nucleus:"13C",solvent:"C₆D₆"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.02,assignment:"CN"}],from:116.01625,to:116.02374999999999},{signals:[{delta:.2,assignment:"CH₃"}],from:.19625,to:.20375000000000001}],nucleus:"13C",solvent:"C₆D₆"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.62,assignment:"CH"}],from:128.61625,to:128.62375}],nucleus:"13C",solvent:"C₆D₆"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.19,assignment:"(CH₃)₃C"}],from:68.18625,to:68.19375},{signals:[{delta:30.47,assignment:"(CH₃)₃C"}],from:30.46625,to:30.47375}],nucleus:"13C",solvent:"C₆D₆"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.76,assignment:"CO₂"}],from:124.75625000000001,to:124.76375}],nucleus:"13C",solvent:"C₆D₆"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.69,assignment:"CS₂"}],from:192.68625,to:192.69375}],nucleus:"13C",solvent:"C₆D₆"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.44,assignment:"CCl₄"}],from:96.43625,to:96.44375}],nucleus:"13C",solvent:"C₆D₆"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.79,assignment:"CH"}],from:77.78625000000001,to:77.79375}],nucleus:"13C",solvent:"C₆D₆"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.59,assignment:"CH₂"}],from:70.58625,to:70.59375}],nucleus:"13C",solvent:"C₆D₆"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.23,assignment:"CH₂"}],from:27.22625,to:27.23375}],nucleus:"13C",solvent:"C₆D₆"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.59,assignment:"CH₂"}],from:43.58625000000001,to:43.59375}],nucleus:"13C",solvent:"C₆D₆"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.46,assignment:"CH₂"}],from:53.456250000000004,to:53.46375}],nucleus:"13C",solvent:"C₆D₆"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.46,assignment:"CH₃"}],from:15.45625,to:15.463750000000001},{signals:[{delta:65.94,assignment:"CH₂"}],from:65.93625,to:65.94375}],nucleus:"13C",solvent:"C₆D₆"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.66,assignment:"CH₃"}],from:58.65625,to:58.66374999999999},{signals:[{delta:70.87,assignment:"CH₂"}],from:70.86625000000001,to:70.87375},{signals:[{delta:72.35,assignment:"CH₂"}],from:72.34625,to:72.35374999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.13,assignment:"CH"}],from:162.12625,to:162.13375},{signals:[{delta:35.25,assignment:"CH₃"}],from:35.24625,to:35.25375},{signals:[{delta:30.72,assignment:"CH₃"}],from:30.71625,to:30.72375}],nucleus:"13C",solvent:"C₆D₆"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.16,assignment:"CH₂"}],from:67.15625,to:67.16375}],nucleus:"13C",solvent:"C₆D₆"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.68,assignment:"CH₃"}],from:58.67625,to:58.683749999999996},{signals:[{delta:72.21,assignment:"CH₂"}],from:72.20625,to:72.21374999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.96,assignment:"CH₃"}],from:6.95625,to:6.96375}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.72,assignment:"CH₃"}],from:18.71625,to:18.72375},{signals:[{delta:57.86,assignment:"CH₂"}],from:57.85625,to:57.863749999999996}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.56,assignment:"CH₃CO"}],from:20.55625,to:20.56375},{signals:[{delta:170.44,assignment:"CO"}],from:170.43625,to:170.44375},{signals:[{delta:60.21,assignment:"CH₂"}],from:60.206250000000004,to:60.21375},{signals:[{delta:14.19,assignment:"CH₃"}],from:14.18625,to:14.19375}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:122.96,assignment:"CH₂"}],from:122.95625,to:122.96374999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.34,assignment:"CH₂"}],from:64.33625,to:64.34375}],nucleus:"13C",solvent:"C₆D₆"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.22,assignment:"CH₂"}],from:30.21625,to:30.22375}],nucleus:"13C",solvent:"C₆D₆"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.79,assignment:"C"}],from:131.78625,to:131.79375},{signals:[{delta:16.95,assignment:"CH₃"}],from:16.94625,to:16.95375}],nucleus:"13C",solvent:"C₆D₆"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.32,assignment:"CH₃"}],from:14.31625,to:14.32375},{signals:[{delta:23.04,assignment:"CH₂(2,5)"}],from:23.03625,to:23.04375},{signals:[{delta:31.96,assignment:"CH₂(3,4)"}],from:31.95625,to:31.96375}],nucleus:"13C",solvent:"C₆D₆"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.05,assignment:"CH₃"}],from:2.0462499999999997,to:2.05375}],nucleus:"13C",solvent:"C₆D₆"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.88,assignment:"CH₃"}],from:36.876250000000006,to:36.88375}],nucleus:"13C",solvent:"C₆D₆"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.76,assignment:"CH(2)"}],from:135.75625,to:135.76375},{signals:[{delta:122.16,assignment:"CH(4,5)"}],from:122.15625,to:122.16375}],nucleus:"13C",solvent:"C₆D₆"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.29,assignment:"CH₄"}],from:-4.29375,to:-4.28625}],nucleus:"13C",solvent:"C₆D₆"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.97,assignment:"CH₃"}],from:49.96625,to:49.973749999999995}],nucleus:"13C",solvent:"C₆D₆"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:61.16,assignment:"CH₃"}],from:61.15625,to:61.16374999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.25,assignment:"CH₃"}],from:14.24625,to:14.25375},{signals:[{delta:22.72,assignment:"CH₂(2,4)"}],from:22.71625,to:22.72375},{signals:[{delta:34.45,assignment:"CH₂(3)"}],from:34.446250000000006,to:34.45375}],nucleus:"13C",solvent:"C₆D₆"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.66,assignment:"CH₃"}],from:16.65625,to:16.66375},{signals:[{delta:16.6,assignment:"CH₂"}],from:16.59625,to:16.60375}],nucleus:"13C",solvent:"C₆D₆"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.18,assignment:"CH₃"}],from:25.17625,to:25.18375},{signals:[{delta:64.23,assignment:"CH"}],from:64.22625000000001,to:64.23375}],nucleus:"13C",solvent:"C₆D₆"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.38,assignment:"CH₃"}],from:19.37625,to:19.38375},{signals:[{delta:115.92,assignment:"CH₂"}],from:115.91625,to:115.92375},{signals:[{delta:133.69,assignment:"CH"}],from:133.68625,to:133.69375}],nucleus:"13C",solvent:"C₆D₆"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.27,assignment:"CH(2,6)"}],from:150.26625,to:150.27375},{signals:[{delta:123.58,assignment:"CH(3,5)"}],from:123.57625,to:123.58375},{signals:[{delta:135.28,assignment:"CH(4)"}],from:135.27625,to:135.28375}],nucleus:"13C",solvent:"C₆D₆"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.78,assignment:"CH(2,5)"}],from:117.77625,to:117.78375},{signals:[{delta:108.21,assignment:"CH(3,4)"}],from:108.20625,to:108.21374999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.86,assignment:"CH₂(2,5)"}],from:46.85625,to:46.863749999999996},{signals:[{delta:25.65,assignment:"CH₂(3,4)"}],from:25.64625,to:25.65375}],nucleus:"13C",solvent:"C₆D₆"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.38,assignment:"CH₃"}],from:1.37625,to:1.3837499999999998}],nucleus:"13C",solvent:"C₆D₆"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.8,assignment:"CH₂(2,5)"}],from:67.79625,to:67.80375},{signals:[{delta:25.72,assignment:"CH₂(3,4)"}],from:25.71625,to:25.72375}],nucleus:"13C",solvent:"C₆D₆"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.1,assignment:"CH₃"}],from:21.09625,to:21.10375},{signals:[{delta:137.91,assignment:"C(1)"}],from:137.90625,to:137.91375},{signals:[{delta:129.33,assignment:"CH(2,6)"}],from:129.32625000000002,to:129.33375},{signals:[{delta:128.56,assignment:"CH(3,5)"}],from:128.55625,to:128.56375},{signals:[{delta:125.68,assignment:"CH(4)"}],from:125.67625000000001,to:125.68375}],nucleus:"13C",solvent:"C₆D₆"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.35,assignment:"CH₃"}],from:12.34625,to:12.35375},{signals:[{delta:46.77,assignment:"CH₂"}],from:46.76625000000001,to:46.77375}],nucleus:"13C",solvent:"C₆D₆"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.67,assignment:"CO"}],from:175.66625,to:175.67374999999998},{signals:[{delta:20.4,assignment:"CH₃"}],from:20.39625,to:20.40375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204.83,assignment:"CO"}],from:204.82625000000002,to:204.83375},{signals:[{delta:30.12,assignment:"CH₃"}],from:30.11625,to:30.12375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:115.93,assignment:"CN"}],from:115.92625000000001,to:115.93375},{signals:[{delta:.63,assignment:"CH₃"}],from:.62625,to:.63375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.38,assignment:"CH"}],from:128.37625,to:128.38375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.19,assignment:"(CH₃)₃C"}],from:68.18625,to:68.19375},{signals:[{delta:31.13,assignment:"(CH₃)₃C"}],from:31.12625,to:31.13375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:126.08,assignment:"CO₂"}],from:126.07625,to:126.08375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.49,assignment:"CS₂"}],from:192.48625,to:192.49375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.38,assignment:"CCl₄"}],from:96.37625,to:96.38374999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.67,assignment:"CH"}],from:77.66625,to:77.67375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.55,assignment:"CH₂"}],from:70.54625,to:70.55375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:26.99,assignment:"CH₂"}],from:26.98625,to:26.99375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.6,assignment:"CH₂"}],from:43.596250000000005,to:43.60375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.54,assignment:"CH₂"}],from:53.53625,to:53.543749999999996}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.35,assignment:"CH₃"}],from:15.34625,to:15.35375},{signals:[{delta:65.79,assignment:"CH₂"}],from:65.78625000000001,to:65.79375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.42,assignment:"CH₃"}],from:58.416250000000005,to:58.42375},{signals:[{delta:70.56,assignment:"CH₂"}],from:70.55625,to:70.56375},{signals:[{delta:72.07,assignment:"CH₂"}],from:72.06625,to:72.07374999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.01,assignment:"CH"}],from:162.00625,to:162.01375},{signals:[{delta:35.45,assignment:"CH₃"}],from:35.446250000000006,to:35.45375},{signals:[{delta:30.71,assignment:"CH₃"}],from:30.70625,to:30.71375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:66.95,assignment:"CH₂"}],from:66.94625,to:66.95375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.31,assignment:"CH₃"}],from:58.306250000000006,to:58.31375},{signals:[{delta:71.81,assignment:"CH₂"}],from:71.80625,to:71.81375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.91,assignment:"CH₃"}],from:6.90625,to:6.91375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.55,assignment:"CH₃"}],from:18.54625,to:18.55375},{signals:[{delta:57.63,assignment:"CH₂"}],from:57.626250000000006,to:57.63375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.5,assignment:"CH₃CO"}],from:20.49625,to:20.50375},{signals:[{delta:170.2,assignment:"CO"}],from:170.19625,to:170.20374999999999},{signals:[{delta:60.06,assignment:"CH₂"}],from:60.056250000000006,to:60.06375},{signals:[{delta:14.07,assignment:"CH₃"}],from:14.06625,to:14.07375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:122.95,assignment:"CH₂"}],from:122.94625,to:122.95375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.03,assignment:"CH₂"}],from:64.02625,to:64.03375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.11,assignment:"CH₂"}],from:30.10625,to:30.11375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.54,assignment:"C"}],from:131.53625,to:131.54375},{signals:[{delta:16.68,assignment:"CH₃"}],from:16.67625,to:16.68375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.18,assignment:"CH₃"}],from:14.17625,to:14.18375},{signals:[{delta:22.86,assignment:"CH₂(2,5)"}],from:22.85625,to:22.86375},{signals:[{delta:31.77,assignment:"CH₂(3,4)"}],from:31.76625,to:31.77375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.92,assignment:"CH₃"}],from:1.91625,to:1.9237499999999998}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.64,assignment:"CH₃"}],from:36.636250000000004,to:36.64375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.5,assignment:"CH(2)"}],from:135.49625,to:135.50375},{signals:[{delta:121.96,assignment:"CH(4,5)"}],from:121.95625,to:121.96374999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.33,assignment:"CH₄"}],from:-4.33375,to:-4.32625}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.66,assignment:"CH₃"}],from:49.65625,to:49.66374999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:61.68,assignment:"CH₃"}],from:61.67625,to:61.683749999999996}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.1,assignment:"CH₃"}],from:14.09625,to:14.10375},{signals:[{delta:22.54,assignment:"CH₂(2,4)"}],from:22.53625,to:22.54375},{signals:[{delta:34.26,assignment:"CH₂(3)"}],from:34.25625,to:34.263749999999995}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.56,assignment:"CH₃"}],from:16.55625,to:16.56375},{signals:[{delta:16.48,assignment:"CH₂"}],from:16.47625,to:16.48375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.14,assignment:"CH₃"}],from:25.13625,to:25.14375},{signals:[{delta:64.18,assignment:"CH"}],from:64.17625000000001,to:64.18375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.32,assignment:"CH₃"}],from:19.31625,to:19.32375},{signals:[{delta:115.86,assignment:"CH₂"}],from:115.85625,to:115.86375},{signals:[{delta:133.57,assignment:"CH"}],from:133.56625,to:133.57375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.93,assignment:"CH(2,6)"}],from:149.92625,to:149.93375},{signals:[{delta:123.49,assignment:"CH(3,5)"}],from:123.48625,to:123.49374999999999},{signals:[{delta:135.32,assignment:"CH(4)"}],from:135.31625,to:135.32375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.65,assignment:"CH(2,5)"}],from:117.64625000000001,to:117.65375},{signals:[{delta:108.03,assignment:"CH(3,4)"}],from:108.02625,to:108.03375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.75,assignment:"CH₂(2,5)"}],from:46.74625,to:46.75375},{signals:[{delta:25.59,assignment:"CH₂(3,4)"}],from:25.58625,to:25.59375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.09,assignment:"CH₃"}],from:1.0862500000000002,to:1.09375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.64,assignment:"CH₂(2,5)"}],from:67.63625,to:67.64375},{signals:[{delta:25.68,assignment:"CH₂(3,4)"}],from:25.67625,to:25.68375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.23,assignment:"CH₃"}],from:21.22625,to:21.23375},{signals:[{delta:137.65,assignment:"C(1)"}],from:137.64625,to:137.65375},{signals:[{delta:129.12,assignment:"CH(2,6)"}],from:129.11625,to:129.12375},{signals:[{delta:128.31,assignment:"CH(3,5)"}],from:128.30625,to:128.31375},{signals:[{delta:125.43,assignment:"CH(4)"}],from:125.42625000000001,to:125.43375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.87,assignment:"CH₃"}],from:11.866249999999999,to:11.87375},{signals:[{delta:46.36,assignment:"CH₂"}],from:46.35625,to:46.363749999999996}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:172.31,assignment:"CO"}],from:172.30625,to:172.31375},{signals:[{delta:20.51,assignment:"CH₃"}],from:20.50625,to:20.51375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:205.87,assignment:"CO"}],from:205.86625,to:205.87375},{signals:[{delta:30.6,assignment:"CH₃"}],from:30.59625,to:30.60375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:117.6,assignment:"CN"}],from:117.59625,to:117.60374999999999},{signals:[{delta:1.12,assignment:"CH₃"}],from:1.1162500000000002,to:1.12375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.15,assignment:"CH"}],from:129.14625,to:129.15375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.13,assignment:"(CH₃)₃C"}],from:68.12625,to:68.13374999999999},{signals:[{delta:30.72,assignment:"(CH₃)₃C"}],from:30.71625,to:30.72375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.81,assignment:"CO₂"}],from:125.80625,to:125.81375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.58,assignment:"CS₂"}],from:193.57625000000002,to:193.58375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.65,assignment:"CCl₄"}],from:96.64625000000001,to:96.65375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.19,assignment:"CH"}],from:79.18625,to:79.19375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.25,assignment:"CH₂"}],from:71.24625,to:71.25375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.51,assignment:"CH₂"}],from:27.50625,to:27.51375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.25,assignment:"CH₂"}],from:45.24625,to:45.25375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.95,assignment:"CH₂"}],from:54.946250000000006,to:54.95375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.78,assignment:"CH₃"}],from:15.77625,to:15.78375},{signals:[{delta:66.12,assignment:"CH₂"}],from:66.11625000000001,to:66.12375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.77,assignment:"CH₃"}],from:58.76625000000001,to:58.77375},{signals:[{delta:71.03,assignment:"CH₂"}],from:71.02625,to:71.03375},{signals:[{delta:72.63,assignment:"CH₂"}],from:72.62625,to:72.63374999999999}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.79,assignment:"CH"}],from:162.78625,to:162.79375},{signals:[{delta:36.15,assignment:"CH₃"}],from:36.14625,to:36.153749999999995},{signals:[{delta:31.03,assignment:"CH₃"}],from:31.02625,to:31.03375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.6,assignment:"CH₂"}],from:67.59625,to:67.60374999999999}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.45,assignment:"CH₃"}],from:58.446250000000006,to:58.45375},{signals:[{delta:72.47,assignment:"CH₂"}],from:72.46625,to:72.47375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.88,assignment:"CH₃"}],from:6.87625,to:6.88375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.89,assignment:"CH₃"}],from:18.88625,to:18.89375},{signals:[{delta:57.72,assignment:"CH₂"}],from:57.71625,to:57.723749999999995}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.83,assignment:"CH₃CO"}],from:20.826249999999998,to:20.83375},{signals:[{delta:170.96,assignment:"CO"}],from:170.95625,to:170.96375},{signals:[{delta:60.56,assignment:"CH₂"}],from:60.556250000000006,to:60.56375},{signals:[{delta:14.5,assignment:"CH₃"}],from:14.49625,to:14.50375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.47,assignment:"CH₂"}],from:123.46625,to:123.47375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.26,assignment:"CH₂"}],from:64.25625000000001,to:64.26375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.22,assignment:"C"}],from:132.21625,to:132.22375},{signals:[{delta:16.86,assignment:"CH₃"}],from:16.85625,to:16.86375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.34,assignment:"CH₃"}],from:14.33625,to:14.34375},{signals:[{delta:23.28,assignment:"CH₂(2,5)"}],from:23.27625,to:23.28375},{signals:[{delta:32.3,assignment:"CH₂(3,4)"}],from:32.29625,to:32.303749999999994}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.01,assignment:"CH₃"}],from:2.0062499999999996,to:2.01375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37.04,assignment:"CH₃"}],from:37.03625,to:37.043749999999996}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.89,assignment:"CH(2)"}],from:135.88625,to:135.89374999999998},{signals:[{delta:122.31,assignment:"CH(4,5)"}],from:122.30625,to:122.31375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-5.33,assignment:"CH₄"}],from:-5.33375,to:-5.32625}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.77,assignment:"CH₃"}],from:49.76625000000001,to:49.77375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.21,assignment:"CH₃"}],from:63.206250000000004,to:63.21375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.29,assignment:"CH₃"}],from:14.286249999999999,to:14.29375},{signals:[{delta:22.98,assignment:"CH₂(2,4)"}],from:22.97625,to:22.98375},{signals:[{delta:34.83,assignment:"CH₂(3)"}],from:34.82625,to:34.833749999999995}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.68,assignment:"CH₃"}],from:16.67625,to:16.68375},{signals:[{delta:16.78,assignment:"CH₂"}],from:16.77625,to:16.78375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.67,assignment:"CH₃"}],from:25.66625,to:25.673750000000002},{signals:[{delta:63.85,assignment:"CH"}],from:63.846250000000005,to:63.85375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.42,assignment:"CH₃"}],from:19.41625,to:19.423750000000002},{signals:[{delta:116.03,assignment:"CH₂"}],from:116.02625,to:116.03375},{signals:[{delta:134.34,assignment:"CH"}],from:134.33625,to:134.34375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.67,assignment:"CH(2,6)"}],from:150.66625,to:150.67374999999998},{signals:[{delta:124.57,assignment:"CH(3,5)"}],from:124.56625,to:124.57374999999999},{signals:[{delta:136.56,assignment:"CH(4)"}],from:136.55625,to:136.56375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.98,assignment:"CH(2,5)"}],from:117.97625000000001,to:117.98375},{signals:[{delta:108.04,assignment:"CH(3,4)"}],from:108.03625000000001,to:108.04375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.4,assignment:"CH₃"}],from:1.39625,to:1.4037499999999998}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.07,assignment:"CH₂(2,5)"}],from:68.06625,to:68.07374999999999},{signals:[{delta:26.15,assignment:"CH₂(3,4)"}],from:26.14625,to:26.15375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.46,assignment:"CH₃"}],from:21.45625,to:21.46375},{signals:[{delta:138.48,assignment:"C(1)"}],from:138.47625,to:138.48375},{signals:[{delta:129.76,assignment:"CH(2,6)"}],from:129.75625,to:129.76375},{signals:[{delta:129.03,assignment:"CH(3,5)"}],from:129.02625,to:129.03375},{signals:[{delta:126.12,assignment:"CH(4)"}],from:126.11625000000001,to:126.12375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.49,assignment:"CH₃"}],from:12.48625,to:12.49375},{signals:[{delta:47.07,assignment:"CH₂"}],from:47.066250000000004,to:47.07375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:171.93,assignment:"CO"}],from:171.92625,to:171.93375},{signals:[{delta:20.95,assignment:"CH₃"}],from:20.94625,to:20.95375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:206.31,assignment:"CO"}],from:206.30625,to:206.31375},{signals:[{delta:30.56,assignment:"CH₃"}],from:30.55625,to:30.56375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:117.91,assignment:"CN"}],from:117.90625,to:117.91375},{signals:[{delta:1.03,assignment:"CH₃"}],from:1.02625,to:1.03375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.3,assignment:"CH"}],from:128.29625000000001,to:128.30375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:66.88,assignment:"(CH₃)₃C"}],from:66.87625,to:66.88374999999999},{signals:[{delta:30.38,assignment:"(CH₃)₃C"}],from:30.37625,to:30.38375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.21,assignment:"CO₂"}],from:124.20625,to:124.21374999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.63,assignment:"CS₂"}],from:192.62625,to:192.63375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:95.44,assignment:"CCl₄"}],from:95.43625,to:95.44375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.16,assignment:"CH"}],from:79.15625,to:79.16375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:69.85,assignment:"CH₂"}],from:69.84625,to:69.85374999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:26.33,assignment:"CH₂"}],from:26.326249999999998,to:26.33375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.02,assignment:"CH₂"}],from:45.01625000000001,to:45.02375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.84,assignment:"CH₂"}],from:54.83625000000001,to:54.84375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.12,assignment:"CH₃"}],from:15.116249999999999,to:15.12375},{signals:[{delta:62.05,assignment:"CH₂"}],from:62.04625,to:62.053749999999994}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:57.98,assignment:"CH₃"}],from:57.97625,to:57.98374999999999},{signals:[{delta:69.54,assignment:"CH₂"}],from:69.53625000000001,to:69.54375},{signals:[{delta:71.25,assignment:"CH₂"}],from:71.24625,to:71.25375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.29,assignment:"CH"}],from:162.28625,to:162.29375},{signals:[{delta:35.73,assignment:"CH₃"}],from:35.72625,to:35.73374999999999},{signals:[{delta:30.73,assignment:"CH₃"}],from:30.72625,to:30.73375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:66.36,assignment:"CH₂"}],from:66.35625,to:66.36375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.03,assignment:"CH₃"}],from:58.026250000000005,to:58.03375},{signals:[{delta:71.17,assignment:"CH₂"}],from:71.16625,to:71.17375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.61,assignment:"CH₃"}],from:6.60625,to:6.6137500000000005}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.51,assignment:"CH₃"}],from:18.50625,to:18.51375},{signals:[{delta:56.07,assignment:"CH₂"}],from:56.066250000000004,to:56.07375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.68,assignment:"CH₃CO"}],from:20.67625,to:20.68375},{signals:[{delta:170.31,assignment:"CO"}],from:170.30625,to:170.31375},{signals:[{delta:59.74,assignment:"CH₂"}],from:59.736250000000005,to:59.74375},{signals:[{delta:14.4,assignment:"CH₃"}],from:14.39625,to:14.40375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.52,assignment:"CH₂"}],from:123.51625,to:123.52374999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:62.76,assignment:"CH₂"}],from:62.75625,to:62.763749999999995}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.1,assignment:"C"}],from:131.09625,to:131.10375},{signals:[{delta:16.6,assignment:"CH₃"}],from:16.59625,to:16.60375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:13.88,assignment:"CH₃"}],from:13.87625,to:13.883750000000001},{signals:[{delta:22.05,assignment:"CH₂(2,5)"}],from:22.04625,to:22.05375},{signals:[{delta:30.95,assignment:"CH₂(3,4)"}],from:30.94625,to:30.95375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.96,assignment:"CH₃"}],from:1.95625,to:1.9637499999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.42,assignment:"CH₃"}],from:36.416250000000005,to:36.42375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.15,assignment:"CH(2)"}],from:135.14625,to:135.15375},{signals:[{delta:121.55,assignment:"CH(4,5)"}],from:121.54625,to:121.55375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.01,assignment:"CH₄"}],from:-4.01375,to:-4.00625}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:48.59,assignment:"CH₃"}],from:48.58625000000001,to:48.59375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.28,assignment:"CH₃"}],from:63.276250000000005,to:63.28375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:13.28,assignment:"CH₃"}],from:13.27625,to:13.28375},{signals:[{delta:21.7,assignment:"CH₂(2,4)"}],from:21.69625,to:21.70375},{signals:[{delta:33.48,assignment:"CH₂(3)"}],from:33.47625,to:33.48374999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.34,assignment:"CH₃"}],from:16.33625,to:16.34375},{signals:[{delta:15.67,assignment:"CH₂"}],from:15.66625,to:15.67375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.43,assignment:"CH₃"}],from:25.42625,to:25.43375},{signals:[{delta:64.92,assignment:"CH"}],from:64.91625,to:64.92375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.2,assignment:"CH₃"}],from:19.19625,to:19.20375},{signals:[{delta:116.07,assignment:"CH₂"}],from:116.06625,to:116.07374999999999},{signals:[{delta:133.55,assignment:"CH"}],from:133.54625000000001,to:133.55375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.58,assignment:"CH(2,6)"}],from:149.57625000000002,to:149.58375},{signals:[{delta:123.84,assignment:"CH(3,5)"}],from:123.83625,to:123.84375},{signals:[{delta:136.05,assignment:"CH(4)"}],from:136.04625000000001,to:136.05375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.32,assignment:"CH(2,5)"}],from:117.31625,to:117.32374999999999},{signals:[{delta:107.07,assignment:"CH(3,4)"}],from:107.06625,to:107.07374999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.51,assignment:"CH₂(2,5)"}],from:46.50625,to:46.513749999999995},{signals:[{delta:25.26,assignment:"CH₂(3,4)"}],from:25.25625,to:25.26375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.03,assignment:"CH₂(2,5)"}],from:67.02625,to:67.03375},{signals:[{delta:25.14,assignment:"CH₂(3,4)"}],from:25.13625,to:25.14375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:20.99,assignment:"CH₃"}],from:20.98625,to:20.99375},{signals:[{delta:137.35,assignment:"C(1)"}],from:137.34625,to:137.35375},{signals:[{delta:128.88,assignment:"CH(2,6)"}],from:128.87625,to:128.88375},{signals:[{delta:128.18,assignment:"CH(3,5)"}],from:128.17625,to:128.18375},{signals:[{delta:125.29,assignment:"CH(4)"}],from:125.28625000000001,to:125.29375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.74,assignment:"CH₃"}],from:11.73625,to:11.74375},{signals:[{delta:45.74,assignment:"CH₂"}],from:45.736250000000005,to:45.74375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:173.21,assignment:"CO"}],from:173.20625,to:173.21375},{signals:[{delta:20.73,assignment:"CH₃"}],from:20.72625,to:20.73375}],nucleus:"13C",solvent:"CD₃CN"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:207.43,assignment:"CO"}],from:207.42625,to:207.43375},{signals:[{delta:30.91,assignment:"CH₃"}],from:30.90625,to:30.91375}],nucleus:"13C",solvent:"CD₃CN"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:118.26,assignment:"CN"}],from:118.25625000000001,to:118.26375},{signals:[{delta:1.79,assignment:"CH₃"}],from:1.7862500000000001,to:1.79375}],nucleus:"13C",solvent:"CD₃CN"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.32,assignment:"CH"}],from:129.31625,to:129.32375}],nucleus:"13C",solvent:"CD₃CN"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.74,assignment:"(CH₃)₃C"}],from:68.73625,to:68.74374999999999},{signals:[{delta:30.68,assignment:"(CH₃)₃C"}],from:30.67625,to:30.68375}],nucleus:"13C",solvent:"CD₃CN"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.89,assignment:"CO₂"}],from:125.88625,to:125.89375}],nucleus:"13C",solvent:"CD₃CN"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.6,assignment:"CS₂"}],from:193.59625,to:193.60375}],nucleus:"13C",solvent:"CD₃CN"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.68,assignment:"CCl₄"}],from:96.67625000000001,to:96.68375}],nucleus:"13C",solvent:"CD₃CN"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.17,assignment:"CH"}],from:79.16625,to:79.17375}],nucleus:"13C",solvent:"CD₃CN"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.22,assignment:"CH₂"}],from:71.21625,to:71.22375}],nucleus:"13C",solvent:"CD₃CN"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.63,assignment:"CH₂"}],from:27.62625,to:27.63375}],nucleus:"13C",solvent:"CD₃CN"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.54,assignment:"CH₂"}],from:45.53625,to:45.543749999999996}],nucleus:"13C",solvent:"CD₃CN"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:55.32,assignment:"CH₂"}],from:55.316250000000004,to:55.32375}],nucleus:"13C",solvent:"CD₃CN"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.63,assignment:"CH₃"}],from:15.62625,to:15.633750000000001},{signals:[{delta:66.32,assignment:"CH₂"}],from:66.31625,to:66.32374999999999}],nucleus:"13C",solvent:"CD₃CN"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.9,assignment:"CH₃"}],from:58.89625,to:58.903749999999995},{signals:[{delta:70.99,assignment:"CH₂"}],from:70.98625,to:70.99374999999999},{signals:[{delta:72.63,assignment:"CH₂"}],from:72.62625,to:72.63374999999999}],nucleus:"13C",solvent:"CD₃CN"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:163.31,assignment:"CH"}],from:163.30625,to:163.31375},{signals:[{delta:36.57,assignment:"CH₃"}],from:36.566250000000004,to:36.57375},{signals:[{delta:31.32,assignment:"CH₃"}],from:31.31625,to:31.32375}],nucleus:"13C",solvent:"CD₃CN"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.72,assignment:"CH₂"}],from:67.71625,to:67.72375}],nucleus:"13C",solvent:"CD₃CN"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.89,assignment:"CH₃"}],from:58.886250000000004,to:58.89375},{signals:[{delta:72.47,assignment:"CH₂"}],from:72.46625,to:72.47375}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.99,assignment:"CH₃"}],from:6.98625,to:6.99375}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.8,assignment:"CH₃"}],from:18.79625,to:18.80375},{signals:[{delta:57.96,assignment:"CH₂"}],from:57.956250000000004,to:57.96375}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.16,assignment:"CH₃CO"}],from:21.15625,to:21.16375},{signals:[{delta:171.68,assignment:"CO"}],from:171.67625,to:171.68375},{signals:[{delta:60.98,assignment:"CH₂"}],from:60.97625,to:60.98374999999999},{signals:[{delta:14.54,assignment:"CH₃"}],from:14.536249999999999,to:14.54375}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.69,assignment:"CH₂"}],from:123.68625,to:123.69375}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.22,assignment:"CH₂"}],from:64.21625,to:64.22375}],nucleus:"13C",solvent:"CD₃CN"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"CD₃CN"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.61,assignment:"C"}],from:132.60625000000002,to:132.61375},{signals:[{delta:16.94,assignment:"CH₃"}],from:16.93625,to:16.94375}],nucleus:"13C",solvent:"CD₃CN"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.43,assignment:"CH₃"}],from:14.42625,to:14.43375},{signals:[{delta:23.4,assignment:"CH₂(2,5)"}],from:23.39625,to:23.40375},{signals:[{delta:32.36,assignment:"CH₂(3,4)"}],from:32.35625,to:32.363749999999996}],nucleus:"13C",solvent:"CD₃CN"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.07,assignment:"CH₃"}],from:2.0662499999999997,to:2.07375}],nucleus:"13C",solvent:"CD₃CN"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37.1,assignment:"CH₃"}],from:37.096250000000005,to:37.10375}],nucleus:"13C",solvent:"CD₃CN"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.33,assignment:"CH(2)"}],from:136.32625000000002,to:136.33375},{signals:[{delta:122.78,assignment:"CH(4,5)"}],from:122.77625,to:122.78375}],nucleus:"13C",solvent:"CD₃CN"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.61,assignment:"CH₄"}],from:-4.6137500000000005,to:-4.60625}],nucleus:"13C",solvent:"CD₃CN"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.9,assignment:"CH₃"}],from:49.89625,to:49.903749999999995}],nucleus:"13C",solvent:"CD₃CN"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.66,assignment:"CH₃"}],from:63.65625,to:63.66374999999999}],nucleus:"13C",solvent:"CD₃CN"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.37,assignment:"CH₃"}],from:14.366249999999999,to:14.37375},{signals:[{delta:23.08,assignment:"CH₂(2,4)"}],from:23.076249999999998,to:23.08375},{signals:[{delta:34.89,assignment:"CH₂(3)"}],from:34.886250000000004,to:34.89375}],nucleus:"13C",solvent:"CD₃CN"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.73,assignment:"CH₃"}],from:16.72625,to:16.73375},{signals:[{delta:16.91,assignment:"CH₂"}],from:16.90625,to:16.91375}],nucleus:"13C",solvent:"CD₃CN"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.55,assignment:"CH₃"}],from:25.54625,to:25.55375},{signals:[{delta:64.3,assignment:"CH"}],from:64.29625,to:64.30375}],nucleus:"13C",solvent:"CD₃CN"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.48,assignment:"CH₃"}],from:19.47625,to:19.48375},{signals:[{delta:116.12,assignment:"CH₂"}],from:116.11625000000001,to:116.12375},{signals:[{delta:134.78,assignment:"CH"}],from:134.77625,to:134.78375}],nucleus:"13C",solvent:"CD₃CN"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.76,assignment:"CH(2,6)"}],from:150.75625,to:150.76375},{signals:[{delta:127.76,assignment:"CH(3,5)"}],from:127.75625000000001,to:127.76375},{signals:[{delta:136.89,assignment:"CH(4)"}],from:136.88625,to:136.89374999999998}],nucleus:"13C",solvent:"CD₃CN"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:118.47,assignment:"CH(2,5)"}],from:118.46625,to:118.47375},{signals:[{delta:108.31,assignment:"CH(3,4)"}],from:108.30625,to:108.31375}],nucleus:"13C",solvent:"CD₃CN"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.57,assignment:"CH₂(2,5)"}],from:47.566250000000004,to:47.57375},{signals:[{delta:26.34,assignment:"CH₂(3,4)"}],from:26.33625,to:26.34375}],nucleus:"13C",solvent:"CD₃CN"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"CD₃CN"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.33,assignment:"CH₂(2,5)"}],from:68.32625,to:68.33375},{signals:[{delta:26.27,assignment:"CH₂(3,4)"}],from:26.26625,to:26.27375}],nucleus:"13C",solvent:"CD₃CN"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.5,assignment:"CH₃"}],from:21.49625,to:21.50375},{signals:[{delta:138.9,assignment:"C(1)"}],from:138.89625,to:138.90375},{signals:[{delta:129.94,assignment:"CH(2,6)"}],from:129.93625,to:129.94375},{signals:[{delta:129.23,assignment:"CH(3,5)"}],from:129.22625,to:129.23375},{signals:[{delta:126.28,assignment:"CH(4)"}],from:126.27625,to:126.28375}],nucleus:"13C",solvent:"CD₃CN"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.38,assignment:"CH₃"}],from:12.37625,to:12.383750000000001},{signals:[{delta:47.1,assignment:"CH₂"}],from:47.096250000000005,to:47.10375}],nucleus:"13C",solvent:"CD₃CN"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:177.96,assignment:"CO"}],from:177.95625,to:177.96375},{signals:[{delta:20.91,assignment:"CH₃"}],from:20.90625,to:20.91375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:32.35,assignment:"CO"}],from:32.346250000000005,to:32.35375},{signals:[{delta:214.98,assignment:"CH₃"}],from:214.97625,to:214.98375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:118.95,assignment:"CN"}],from:118.94625,to:118.95375},{signals:[{delta:1,assignment:"CH₃"}],from:.99625,to:1.00375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.84,assignment:"CH"}],from:129.83625,to:129.84375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:72.35,assignment:"(CH₃)₃C"}],from:72.34625,to:72.35374999999999},{signals:[{delta:31.07,assignment:"(CH₃)₃C"}],from:31.06625,to:31.07375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:126.92,assignment:"CO₂"}],from:126.91625,to:126.92375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:196.26,assignment:"CS₂"}],from:196.25625,to:196.26375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:97.74,assignment:"CCl₄"}],from:97.73625,to:97.74374999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:78.83,assignment:"CH"}],from:78.82625,to:78.83375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.8,assignment:"CH₂"}],from:70.79625,to:70.80375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:28.34,assignment:"CH₂"}],from:28.33625,to:28.34375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.28,assignment:"CH₂"}],from:45.276250000000005,to:45.28375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.46,assignment:"CH₂"}],from:54.456250000000004,to:54.46375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.33,assignment:"CH₃"}],from:15.32625,to:15.33375},{signals:[{delta:67.55,assignment:"CH₂"}],from:67.54625,to:67.55375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:59.4,assignment:"CH₃"}],from:59.39625,to:59.403749999999995},{signals:[{delta:73.05,assignment:"CH₂"}],from:73.04625,to:73.05375},{signals:[{delta:71.33,assignment:"CH₂"}],from:71.32625,to:71.33375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:166.01,assignment:"CH"}],from:166.00625,to:166.01375},{signals:[{delta:37.76,assignment:"CH₃"}],from:37.75625,to:37.763749999999995},{signals:[{delta:30.96,assignment:"CH₃"}],from:30.95625,to:30.96375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:68.52,assignment:"CH₂"}],from:68.51625,to:68.52374999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.52,assignment:"CH₃"}],from:59.51625000000001,to:59.52375},{signals:[{delta:72.87,assignment:"CH₂"}],from:72.86625000000001,to:72.87375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:7.01,assignment:"CH₃"}],from:7.00625,to:7.01375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.11,assignment:"CH₃"}],from:18.10625,to:18.11375},{signals:[{delta:59.68,assignment:"CH₂"}],from:59.67625,to:59.683749999999996}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.18,assignment:"CH₃CO"}],from:21.17625,to:21.18375},{signals:[{delta:175.55,assignment:"CO"}],from:175.54625000000001,to:175.55375},{signals:[{delta:62.7,assignment:"CH₂"}],from:62.696250000000006,to:62.70375},{signals:[{delta:14.36,assignment:"CH₃"}],from:14.35625,to:14.36375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:124.08,assignment:"CH₂"}],from:124.07625,to:124.08375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.87,assignment:"CH₂"}],from:64.86625000000001,to:64.87375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"TFE-d₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:134.04,assignment:"C"}],from:134.03625,to:134.04375},{signals:[{delta:17.04,assignment:"CH₃"}],from:17.03625,to:17.04375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.63,assignment:"CH₃"}],from:14.62625,to:14.633750000000001},{signals:[{delta:24.06,assignment:"CH₂(2,5)"}],from:24.05625,to:24.06375},{signals:[{delta:33.17,assignment:"CH₂(3,4)"}],from:33.166250000000005,to:33.17375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.09,assignment:"CH₃"}],from:2.0862499999999997,to:2.09375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37.21,assignment:"CH₃"}],from:37.206250000000004,to:37.21375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.58,assignment:"CH(2)"}],from:136.57625000000002,to:136.58375},{signals:[{delta:122.93,assignment:"CH(4,5)"}],from:122.92625000000001,to:122.93375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-5.88,assignment:"CH₄"}],from:-5.88375,to:-5.87625}],nucleus:"13C",solvent:"TFE-d₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:50.67,assignment:"CH₃"}],from:50.666250000000005,to:50.67375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.17,assignment:"CH₃"}],from:63.166250000000005,to:63.17375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.54,assignment:"CH₃"}],from:14.536249999999999,to:14.54375},{signals:[{delta:23.75,assignment:"CH₂(2,4)"}],from:23.74625,to:23.75375},{signals:[{delta:35.76,assignment:"CH₂(3)"}],from:35.75625,to:35.763749999999995}],nucleus:"13C",solvent:"TFE-d₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.93,assignment:"CH₃"}],from:16.92625,to:16.93375},{signals:[{delta:17.46,assignment:"CH₂"}],from:17.45625,to:17.46375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.21,assignment:"CH₃"}],from:25.20625,to:25.21375},{signals:[{delta:66.69,assignment:"CH"}],from:66.68625,to:66.69375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.63,assignment:"CH₃"}],from:19.62625,to:19.63375},{signals:[{delta:116.38,assignment:"CH₂"}],from:116.37625,to:116.38374999999999},{signals:[{delta:136,assignment:"CH"}],from:135.99625,to:136.00375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.76,assignment:"CH(2,6)"}],from:149.75625,to:149.76375},{signals:[{delta:126.27,assignment:"CH(3,5)"}],from:126.26625,to:126.27374999999999},{signals:[{delta:139.62,assignment:"CH(4)"}],from:139.61625,to:139.62375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:119.61,assignment:"CH(2,5)"}],from:119.60625,to:119.61375},{signals:[{delta:108.85,assignment:"CH(3,4)"}],from:108.84625,to:108.85374999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.43,assignment:"CH₂(2,5)"}],from:47.42625,to:47.433749999999996},{signals:[{delta:25.73,assignment:"CH₂(3,4)"}],from:25.72625,to:25.73375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:2.87,assignment:"CH₃"}],from:2.86625,to:2.8737500000000002}],nucleus:"13C",solvent:"TFE-d₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:69.53,assignment:"CH₂(2,5)"}],from:69.52625,to:69.53375},{signals:[{delta:26.69,assignment:"CH₂(3,4)"}],from:26.68625,to:26.69375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.62,assignment:"CH₃"}],from:21.61625,to:21.62375},{signals:[{delta:139.92,assignment:"C(1)"}],from:139.91625,to:139.92374999999998},{signals:[{delta:130.58,assignment:"CH(2,6)"}],from:130.57625000000002,to:130.58375},{signals:[{delta:129.79,assignment:"CH(3,5)"}],from:129.78625,to:129.79375},{signals:[{delta:126.82,assignment:"CH(4)"}],from:126.81625,to:126.82374999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:9.51,assignment:"CH₃"}],from:9.50625,to:9.51375},{signals:[{delta:48.45,assignment:"CH₂"}],from:48.446250000000006,to:48.45375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.11,assignment:"CO"}],from:175.10625000000002,to:175.11375},{signals:[{delta:20.56,assignment:"CH₃"}],from:20.55625,to:20.56375}],nucleus:"13C",solvent:"CD₃OD"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:209.67,assignment:"CO"}],from:209.66625,to:209.67374999999998},{signals:[{delta:30.67,assignment:"CH₃"}],from:30.66625,to:30.673750000000002}],nucleus:"13C",solvent:"CD₃OD"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:118.06,assignment:"CN"}],from:118.05625,to:118.06375},{signals:[{delta:.85,assignment:"CH₃"}],from:.84625,to:.85375}],nucleus:"13C",solvent:"CD₃OD"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.34,assignment:"CH"}],from:129.33625,to:129.34375}],nucleus:"13C",solvent:"CD₃OD"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:69.4,assignment:"(CH₃)₃C"}],from:69.39625000000001,to:69.40375},{signals:[{delta:30.91,assignment:"(CH₃)₃C"}],from:30.90625,to:30.91375}],nucleus:"13C",solvent:"CD₃OD"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:126.31,assignment:"CO₂"}],from:126.30625,to:126.31375}],nucleus:"13C",solvent:"CD₃OD"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.82,assignment:"CS₂"}],from:193.81625,to:193.82375}],nucleus:"13C",solvent:"CD₃OD"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:97.21,assignment:"CCl₄"}],from:97.20625,to:97.21374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.44,assignment:"CH"}],from:79.43625,to:79.44375}],nucleus:"13C",solvent:"CD₃OD"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.47,assignment:"CH₂"}],from:71.46625,to:71.47375}],nucleus:"13C",solvent:"CD₃OD"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.96,assignment:"CH₂"}],from:27.95625,to:27.96375}],nucleus:"13C",solvent:"CD₃OD"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.11,assignment:"CH₂"}],from:45.10625,to:45.113749999999996}],nucleus:"13C",solvent:"CD₃OD"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.78,assignment:"CH₂"}],from:54.776250000000005,to:54.78375}],nucleus:"13C",solvent:"CD₃OD"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.46,assignment:"CH₃"}],from:15.45625,to:15.463750000000001},{signals:[{delta:66.88,assignment:"CH₂"}],from:66.87625,to:66.88374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:59.06,assignment:"CH₃"}],from:59.056250000000006,to:59.06375},{signals:[{delta:71.33,assignment:"CH₂"}],from:71.32625,to:71.33375},{signals:[{delta:72.92,assignment:"CH₂"}],from:72.91625,to:72.92375}],nucleus:"13C",solvent:"CD₃OD"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:164.73,assignment:"CH"}],from:164.72625,to:164.73375},{signals:[{delta:36.89,assignment:"CH₃"}],from:36.886250000000004,to:36.89375},{signals:[{delta:31.61,assignment:"CH₃"}],from:31.60625,to:31.61375}],nucleus:"13C",solvent:"CD₃OD"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:68.11,assignment:"CH₂"}],from:68.10625,to:68.11375}],nucleus:"13C",solvent:"CD₃OD"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.06,assignment:"CH₃"}],from:59.056250000000006,to:59.06375},{signals:[{delta:72.72,assignment:"CH₂"}],from:72.71625,to:72.72375}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.98,assignment:"CH₃"}],from:6.97625,to:6.983750000000001}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.4,assignment:"CH₃"}],from:18.39625,to:18.40375},{signals:[{delta:58.26,assignment:"CH₂"}],from:58.25625,to:58.263749999999995}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.88,assignment:"CH₃CO"}],from:20.87625,to:20.88375},{signals:[{delta:172.89,assignment:"CO"}],from:172.88625,to:172.89374999999998},{signals:[{delta:61.5,assignment:"CH₂"}],from:61.49625,to:61.50375},{signals:[{delta:14.49,assignment:"CH₃"}],from:14.48625,to:14.49375}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.46,assignment:"CH₂"}],from:123.45625,to:123.46374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.3,assignment:"CH₂"}],from:64.29625,to:64.30375}],nucleus:"13C",solvent:"CD₃OD"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"CD₃OD"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.53,assignment:"C"}],from:132.52625,to:132.53375},{signals:[{delta:16.9,assignment:"CH₃"}],from:16.89625,to:16.90375}],nucleus:"13C",solvent:"CD₃OD"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.45,assignment:"CH₃"}],from:14.44625,to:14.45375},{signals:[{delta:23.68,assignment:"CH₂(2,5)"}],from:23.67625,to:23.68375},{signals:[{delta:32.73,assignment:"CH₂(3,4)"}],from:32.72625,to:32.73374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.99,assignment:"CH₃"}],from:1.98625,to:1.99375}],nucleus:"13C",solvent:"CD₃OD"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37,assignment:"CH₃"}],from:36.99625,to:37.00375}],nucleus:"13C",solvent:"CD₃OD"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.31,assignment:"CH(2)"}],from:136.30625,to:136.31375},{signals:[{delta:122.6,assignment:"CH(4,5)"}],from:122.59625,to:122.60374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.9,assignment:"CH₄"}],from:-4.9037500000000005,to:-4.89625}],nucleus:"13C",solvent:"CD₃OD"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.86,assignment:"CH₃"}],from:49.85625,to:49.863749999999996}],nucleus:"13C",solvent:"CD₃OD"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.08,assignment:"CH₃"}],from:63.07625,to:63.083749999999995}],nucleus:"13C",solvent:"CD₃OD"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.39,assignment:"CH₃"}],from:14.38625,to:14.39375},{signals:[{delta:23.38,assignment:"CH₂(2,4)"}],from:23.37625,to:23.38375},{signals:[{delta:35.3,assignment:"CH₂(3)"}],from:35.29625,to:35.303749999999994}],nucleus:"13C",solvent:"CD₃OD"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.8,assignment:"CH₃"}],from:16.79625,to:16.80375},{signals:[{delta:17.19,assignment:"CH₂"}],from:17.18625,to:17.19375}],nucleus:"13C",solvent:"CD₃OD"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.27,assignment:"CH₃"}],from:25.26625,to:25.27375},{signals:[{delta:64.71,assignment:"CH"}],from:64.70625,to:64.71374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.5,assignment:"CH₃"}],from:19.49625,to:19.50375},{signals:[{delta:116.04,assignment:"CH₂"}],from:116.03625000000001,to:116.04375},{signals:[{delta:134.61,assignment:"CH"}],from:134.60625000000002,to:134.61375}],nucleus:"13C",solvent:"CD₃OD"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.07,assignment:"CH(2,6)"}],from:150.06625,to:150.07375},{signals:[{delta:125.53,assignment:"CH(3,5)"}],from:125.52625,to:125.53375},{signals:[{delta:138.35,assignment:"CH(4)"}],from:138.34625,to:138.35375}],nucleus:"13C",solvent:"CD₃OD"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:118.28,assignment:"CH(2,5)"}],from:118.27625,to:118.28375},{signals:[{delta:108.11,assignment:"CH(3,4)"}],from:108.10625,to:108.11375}],nucleus:"13C",solvent:"CD₃OD"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.23,assignment:"CH₂(2,5)"}],from:47.22625,to:47.23374999999999},{signals:[{delta:26.29,assignment:"CH₂(3,4)"}],from:26.28625,to:26.29375}],nucleus:"13C",solvent:"CD₃OD"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:2.1,assignment:"CH₃"}],from:2.09625,to:2.1037500000000002}],nucleus:"13C",solvent:"CD₃OD"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.83,assignment:"CH₂(2,5)"}],from:68.82625,to:68.83375},{signals:[{delta:26.48,assignment:"CH₂(3,4)"}],from:26.47625,to:26.48375}],nucleus:"13C",solvent:"CD₃OD"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.5,assignment:"CH₃"}],from:21.49625,to:21.50375},{signals:[{delta:138.85,assignment:"C(1)"}],from:138.84625,to:138.85375},{signals:[{delta:129.91,assignment:"CH(2,6)"}],from:129.90625,to:129.91375},{signals:[{delta:129.2,assignment:"CH(3,5)"}],from:129.19625,to:129.20374999999999},{signals:[{delta:126.29,assignment:"CH(4)"}],from:126.28625000000001,to:126.29375}],nucleus:"13C",solvent:"CD₃OD"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.09,assignment:"CH₃"}],from:11.08625,to:11.09375},{signals:[{delta:46.96,assignment:"CH₂"}],from:46.956250000000004,to:46.96375}],nucleus:"13C",solvent:"CD₃OD"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:177.21,assignment:"CO"}],from:177.20625,to:177.21375},{signals:[{delta:21.03,assignment:"CH₃"}],from:21.02625,to:21.03375}],nucleus:"13C",solvent:"D₂O"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:215.94,assignment:"CO"}],from:215.93625,to:215.94375},{signals:[{delta:30.89,assignment:"CH₃"}],from:30.88625,to:30.89375}],nucleus:"13C",solvent:"D₂O"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:119.68,assignment:"CN"}],from:119.67625000000001,to:119.68375},{signals:[{delta:1.47,assignment:"CH₃"}],from:1.46625,to:1.47375}],nucleus:"13C",solvent:"D₂O"},{names:["benzene"],smiles:"c1ccccc1",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:70.36,assignment:"(CH₃)₃C"}],from:70.35625,to:70.36375},{signals:[{delta:30.29,assignment:"(CH₃)₃C"}],from:30.28625,to:30.29375}],nucleus:"13C",solvent:"D₂O"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:197.25,assignment:"CS₂"}],from:197.24625,to:197.25375}],nucleus:"13C",solvent:"D₂O"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.73,assignment:"CCl₄"}],from:96.72625000000001,to:96.73375}],nucleus:"13C",solvent:"D₂O"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.14,assignment:"CH₂"}],from:70.13625,to:70.14375}],nucleus:"13C",solvent:"D₂O"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:14.77,assignment:"CH₃"}],from:14.76625,to:14.77375},{signals:[{delta:66.42,assignment:"CH₂"}],from:66.41625,to:66.42375}],nucleus:"13C",solvent:"D₂O"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.67,assignment:"CH₃"}],from:58.666250000000005,to:58.67375},{signals:[{delta:70.05,assignment:"CH₂"}],from:70.04625,to:70.05375},{signals:[{delta:71.63,assignment:"CH₂"}],from:71.62625,to:71.63374999999999}],nucleus:"13C",solvent:"D₂O"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:165.53,assignment:"CH"}],from:165.52625,to:165.53375},{signals:[{delta:37.54,assignment:"CH₃"}],from:37.53625,to:37.543749999999996},{signals:[{delta:32.03,assignment:"CH₃"}],from:32.026250000000005,to:32.03375}],nucleus:"13C",solvent:"D₂O"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.19,assignment:"CH₂"}],from:67.18625,to:67.19375}],nucleus:"13C",solvent:"D₂O"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.67,assignment:"CH₃"}],from:58.666250000000005,to:58.67375},{signals:[{delta:71.49,assignment:"CH₂"}],from:71.48625,to:71.49374999999999}],nucleus:"13C",solvent:"D₂O"},{names:["ethane"],smiles:"CC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:17.47,assignment:"CH₃"}],from:17.46625,to:17.47375},{signals:[{delta:58.05,assignment:"CH₂"}],from:58.04625,to:58.053749999999994}],nucleus:"13C",solvent:"D₂O"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.15,assignment:"CH₃CO"}],from:21.14625,to:21.15375},{signals:[{delta:175.26,assignment:"CO"}],from:175.25625,to:175.26375},{signals:[{delta:62.32,assignment:"CH₂"}],from:62.316250000000004,to:62.32375},{signals:[{delta:13.92,assignment:"CH₃"}],from:13.91625,to:13.92375}],nucleus:"13C",solvent:"D₂O"},{names:["ethylene"],smiles:"C=C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:63.17,assignment:"CH₂"}],from:63.166250000000005,to:63.17375}],nucleus:"13C",solvent:"D₂O"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.31,assignment:"CH₃"}],from:2.30625,to:2.31375}],nucleus:"13C",solvent:"D₂O"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.46,assignment:"CH₃"}],from:36.456250000000004,to:36.46375}],nucleus:"13C",solvent:"D₂O"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.65,assignment:"CH(2)"}],from:136.64625,to:136.65375},{signals:[{delta:122.43,assignment:"CH(4,5)"}],from:122.42625000000001,to:122.43375}],nucleus:"13C",solvent:"D₂O"},{names:["methane"],smiles:"C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.5,assignment:"CH₃"}],from:49.49625,to:49.50375}],nucleus:"13C",solvent:"D₂O"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.22,assignment:"CH₃"}],from:63.21625,to:63.223749999999995}],nucleus:"13C",solvent:"D₂O"},{names:["n-pentane"],smiles:"CCCCC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["propane"],smiles:"CCC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:24.38,assignment:"CH₃"}],from:24.37625,to:24.38375},{signals:[{delta:64.88,assignment:"CH"}],from:64.87625,to:64.88374999999999}],nucleus:"13C",solvent:"D₂O"},{names:["propylene"],smiles:"CC=C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.18,assignment:"CH(2,6)"}],from:149.17625,to:149.18375},{signals:[{delta:125.12,assignment:"CH(3,5)"}],from:125.11625000000001,to:125.12375},{signals:[{delta:138.27,assignment:"CH(4)"}],from:138.26625,to:138.27375}],nucleus:"13C",solvent:"D₂O"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:119.06,assignment:"CH(2,5)"}],from:119.05625,to:119.06375},{signals:[{delta:107.83,assignment:"CH(3,4)"}],from:107.82625,to:107.83375}],nucleus:"13C",solvent:"D₂O"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.83,assignment:"CH₂(2,5)"}],from:46.82625,to:46.833749999999995},{signals:[{delta:25.86,assignment:"CH₂(3,4)"}],from:25.85625,to:25.86375}],nucleus:"13C",solvent:"D₂O"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.68,assignment:"CH₂(2,5)"}],from:68.67625000000001,to:68.68375},{signals:[{delta:25.67,assignment:"CH₂(3,4)"}],from:25.66625,to:25.673750000000002}],nucleus:"13C",solvent:"D₂O"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:9.07,assignment:"CH₃"}],from:9.06625,to:9.07375},{signals:[{delta:47.19,assignment:"CH₂"}],from:47.18625,to:47.193749999999994}],nucleus:"13C",solvent:"D₂O"}],protonImpurities=[{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:2.46,multiplicity:"s",assignment:"OH"}],integration:2,from:2.45625,to:2.46375}],nucleus:"1H",solvent:"THF-d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.89,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.88625,to:1.8937499999999998}],nucleus:"1H",solvent:"THF-d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.05,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.0462499999999997,to:2.05375}],nucleus:"1H",solvent:"THF-d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.95,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.94625,to:1.9537499999999999}],nucleus:"1H",solvent:"THF-d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.31,multiplicity:"s",assignment:"CH"}],integration:6,from:7.3062499999999995,to:7.31375}],nucleus:"1H",solvent:"THF-d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.15,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.14625,to:1.1537499999999998},{signals:[{js:[],delta:3.16,multiplicity:"s",assignment:"OH"}],integration:1,from:3.15625,to:3.1637500000000003}],nucleus:"1H",solvent:"THF-d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.89,multiplicity:"s",assignment:"CH"}],integration:1,from:7.8862499999999995,to:7.89375}],nucleus:"1H",solvent:"THF-d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.57,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.5662499999999997,to:3.57375}],nucleus:"1H",solvent:"THF-d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.44,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.43625,to:1.4437499999999999}],nucleus:"1H",solvent:"THF-d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.77,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.76625,to:3.77375}],nucleus:"1H",solvent:"THF-d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.51,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.50625,to:5.51375}],nucleus:"1H",solvent:"THF-d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:6,from:1.0987500000000001,to:1.14125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.38,assignment:"CH₂"}],integration:4,from:3.35,to:3.4099999999999997}],nucleus:"1H",solvent:"THF-d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.43,assignment:"CH₂"}],integration:4,from:3.42625,to:3.4337500000000003},{signals:[{js:[],delta:3.53,assignment:"CH₂"}],integration:4,from:3.5262499999999997,to:3.53375},{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.2762499999999997,to:3.28375}],nucleus:"1H",solvent:"THF-d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.91,multiplicity:"s",assignment:"CH"}],integration:1,from:7.90625,to:7.91375},{signals:[{js:[],delta:2.88,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8762499999999998,to:2.88375},{signals:[{js:[],delta:2.76,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.7562499999999996,to:2.76375}],nucleus:"1H",solvent:"THF-d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.56,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.55625,to:3.56375}],nucleus:"1H",solvent:"THF-d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.2762499999999997,to:3.28375},{signals:[{js:[],delta:3.43,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.42625,to:3.4337500000000003}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.84625,to:.85375}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.1,assignment:"CH₃"}],integration:3,from:1.07875,to:1.12125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.51,assignment:"CH₂"}],integration:2,from:3.48,to:3.5399999999999996},{signals:[{js:[],delta:3.3,multiplicity:"s",assignment:"OH"}],integration:1,from:3.2962499999999997,to:3.30375}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.94,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.93625,to:1.9437499999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.04,assignment:"CH₂CH₃"}],integration:2,from:4.01,to:4.07},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.19,assignment:"CH₂CH₃"}],integration:3,from:1.16875,to:1.21125}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.36,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.35625,to:5.3637500000000005}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.48,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.47625,to:3.48375}],nucleus:"1H",solvent:"THF-d₈"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.85,to:.91,multiplicity:"m"},{signals:[{js:[],delta:1.29,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"THF-d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.18,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.17625,to:2.1837500000000003}],nucleus:"1H",solvent:"THF-d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.29,assignment:"CH₂"}],integration:8,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"THF-d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"THF-d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.58,assignment:"CH₃"}],integration:18,from:2.564375,to:2.595625}],nucleus:"1H",solvent:"THF-d₈"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.55,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.54625,to:4.55375}],nucleus:"1H",solvent:"THF-d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.48,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.47625,to:7.483750000000001},{signals:[{js:[],delta:6.94,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:6.93625,to:6.9437500000000005}],nucleus:"1H",solvent:"THF-d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.19,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.18625,to:.19375}],nucleus:"1H",solvent:"THF-d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.27,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.26625,to:3.27375},{signals:[{js:[],delta:3.02,multiplicity:"s",assignment:"OH"}],integration:1,from:3.01625,to:3.02375}],nucleus:"1H",solvent:"THF-d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.3062499999999995,to:4.31375}],nucleus:"1H",solvent:"THF-d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.31,assignment:"CH₂"}],integration:6,from:1.3062500000000001,to:1.31375}],nucleus:"1H",solvent:"THF-d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.878,to:.922},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.33,assignment:"CH₂"}],integration:2,from:1.2715,to:1.3885}],nucleus:"1H",solvent:"THF-d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.08,assignment:"CH₃"}],integration:6,from:1.06875,to:1.09125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.82,assignment:"CH"}],integration:1,from:3.7712499999999998,to:3.86875}],nucleus:"1H",solvent:"THF-d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.69,assignment:"CH₃"}],integration:3,from:1.6744999999999999,to:1.7055},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.89,assignment:"CH₂(1)"}],integration:1,from:4.873749999999999,to:4.90625},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:4.99,assignment:"CH₂(2)"}],integration:1,from:4.965,to:5.015000000000001},{signals:[{js:[],delta:5.79,assignment:"CH"}],integration:1,from:5.78625,to:5.79375}],nucleus:"1H",solvent:"THF-d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.54,assignment:"CH(2,6)"}],integration:2,from:8.536249999999999,to:8.54375},{signals:[{js:[],delta:7.25,assignment:"CH(3,5)"}],integration:2,from:7.24625,to:7.25375},{signals:[{js:[],delta:7.65,assignment:"CH(4)"}],integration:1,from:7.64625,to:7.6537500000000005}],nucleus:"1H",solvent:"THF-d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:9.96,assignment:"NH"}],integration:1,from:9.95625,to:9.963750000000001},{signals:[{js:[],delta:6.66,assignment:"CH(2,5)"}],integration:2,from:6.65625,to:6.66375},{signals:[{js:[],delta:6.02,assignment:"CH(3,4)"}],integration:2,from:6.016249999999999,to:6.02375}],nucleus:"1H",solvent:"THF-d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.75,assignment:"CH₂(2,5)"}],integration:4,from:2.74625,to:2.75375},{signals:[{js:[],delta:1.59,assignment:"CH₂(3,4)"}],integration:4,from:1.5862500000000002,to:1.59375}],nucleus:"1H",solvent:"THF-d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.11,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.10625,to:.11375}],nucleus:"1H",solvent:"THF-d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.62,assignment:"CH₂(2,5)"}],integration:4,from:3.61625,to:3.6237500000000002},{signals:[{js:[],delta:1.79,assignment:"CH₂(3,4)"}],integration:4,from:1.7862500000000001,to:1.79375}],nucleus:"1H",solvent:"THF-d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.30625,to:2.31375},{signals:[{js:[],delta:7.1,assignment:"CH(2,4,6)"}],integration:3,from:7.0962499999999995,to:7.10375},{signals:[{js:[],delta:7.19,assignment:"CH(3,5)"}],integration:2,from:7.18625,to:7.1937500000000005}],nucleus:"1H",solvent:"THF-d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.97,assignment:"CH₃"}],integration:6,from:.94875,to:.99125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.46,assignment:"CH₂"}],integration:4,from:2.43,to:2.4899999999999998}],nucleus:"1H",solvent:"THF-d₈"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:1.52,multiplicity:"s",assignment:"OH"}],integration:2,from:1.51625,to:1.52375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.06,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.05625,to:2.06375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.12,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.11625,to:2.1237500000000002}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.97,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.96625,to:1.97375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.35,multiplicity:"s",assignment:"CH"}],integration:6,from:7.3462499999999995,to:7.35375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.24,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.23625,to:1.24375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.32,multiplicity:"s",assignment:"CH"}],integration:1,from:7.31625,to:7.32375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.5862499999999997,to:3.59375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.44,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.43625,to:1.4437499999999999}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.76,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.7562499999999996,to:3.76375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.33,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.32625,to:5.33375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.15,assignment:"CH₃"}],integration:6,from:1.12875,to:1.17125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.43,assignment:"CH₂"}],integration:4,from:3.4000000000000004,to:3.46}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.57,assignment:"CH₂"}],integration:4,from:3.5662499999999997,to:3.57375},{signals:[{js:[],delta:3.5,assignment:"CH₂"}],integration:4,from:3.49625,to:3.50375},{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.32625,to:3.33375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.96,multiplicity:"s",assignment:"CH"}],integration:1,from:7.95625,to:7.96375},{signals:[{js:[],delta:2.91,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.90625,to:2.9137500000000003},{signals:[{js:[],delta:2.82,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8162499999999997,to:2.82375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.65,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.6462499999999998,to:3.65375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.3362499999999997,to:3.34375},{signals:[{js:[],delta:3.49,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.48625,to:3.4937500000000004}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.84625,to:.85375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.19,assignment:"CH₃"}],integration:3,from:1.16875,to:1.21125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.66,assignment:"CH₂"}],integration:2,from:3.6300000000000003,to:3.69},{signals:[{js:[],delta:1.33,multiplicity:"s",assignment:"OH"}],integration:1,from:1.3262500000000002,to:1.33375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.99625,to:2.00375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.08,assignment:"CH₂CH₃"}],integration:2,from:4.05,to:4.11},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.23,assignment:"CH₂CH₃"}],integration:3,from:1.20875,to:1.25125}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.4,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.39625,to:5.4037500000000005}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.66,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.65625,to:3.6637500000000003}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.84,to:.9,multiplicity:"m"},{signals:[{js:[],delta:1.27,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.26625,to:1.27375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.2,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.19625,to:2.2037500000000003}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.27,assignment:"CH₂"}],integration:8,from:1.26625,to:1.27375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.6,assignment:"CH₃"}],integration:18,from:2.584375,to:2.615625}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.59,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.58625,to:4.59375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.63,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.62625,to:7.63375},{signals:[{js:[],delta:7.07,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.06625,to:7.07375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.21,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.20625,to:.21375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.42,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.41625,to:3.42375},{signals:[{js:[],delta:1.09,multiplicity:"s",assignment:"OH"}],integration:1,from:1.0862500000000002,to:1.09375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.3062499999999995,to:4.31375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.3,assignment:"CH₂"}],integration:6,from:1.2962500000000001,to:1.30375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.878,to:.922},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.32,assignment:"CH₂"}],integration:2,from:1.2615,to:1.3785}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.17,assignment:"CH₃"}],integration:6,from:1.15875,to:1.18125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.97,assignment:"CH"}],integration:1,from:3.92125,to:4.01875}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.71,assignment:"CH₃"}],integration:3,from:1.6945,to:1.7255},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.93,assignment:"CH₂(1)"}],integration:1,from:4.913749999999999,to:4.94625},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.005,to:5.055000000000001},{signals:[{js:[],delta:5.84,assignment:"CH"}],integration:1,from:5.83625,to:5.84375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.59,assignment:"CH(2,6)"}],integration:2,from:8.58625,to:8.59375},{signals:[{js:[],delta:7.28,assignment:"CH(3,5)"}],integration:2,from:7.27625,to:7.28375},{signals:[{js:[],delta:7.68,assignment:"CH(4)"}],integration:1,from:7.67625,to:7.68375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:8.69,assignment:"NH"}],integration:1,from:8.68625,to:8.69375},{signals:[{js:[],delta:6.79,assignment:"CH(2,5)"}],integration:2,from:6.78625,to:6.79375},{signals:[{js:[],delta:6.19,assignment:"CH(3,4)"}],integration:2,from:6.18625,to:6.1937500000000005}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.82,assignment:"CH₂(2,5)"}],integration:4,from:2.8162499999999997,to:2.82375},{signals:[{js:[],delta:1.67,assignment:"CH₂(3,4)"}],integration:4,from:1.66625,to:1.6737499999999998}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.09,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.08625,to:.09375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.69,assignment:"CH₂(2,5)"}],integration:4,from:3.68625,to:3.69375},{signals:[{js:[],delta:1.82,assignment:"CH₂(3,4)"}],integration:4,from:1.8162500000000001,to:1.82375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.3362499999999997,to:2.34375},{signals:[{js:[],delta:7.15,assignment:"CH(2,4,6)"}],integration:3,from:7.14625,to:7.1537500000000005},{signals:[{js:[],delta:7.24,assignment:"CH(3,5)"}],integration:2,from:7.23625,to:7.24375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.99,assignment:"CH₃"}],integration:6,from:.96875,to:1.01125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.48,assignment:"CH₂"}],integration:4,from:2.45,to:2.51}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:1.56,multiplicity:"s",assignment:"OH"}],integration:2,from:1.5562500000000001,to:1.56375}],nucleus:"1H",solvent:"CDCl₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.09625,to:2.1037500000000002}],nucleus:"1H",solvent:"CDCl₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.17,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.16625,to:2.17375}],nucleus:"1H",solvent:"CDCl₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.09625,to:2.1037500000000002}],nucleus:"1H",solvent:"CDCl₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.36,multiplicity:"s",assignment:"CH"}],integration:6,from:7.35625,to:7.3637500000000005}],nucleus:"1H",solvent:"CDCl₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.28,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.27625,to:1.28375}],nucleus:"1H",solvent:"CDCl₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.26,multiplicity:"s",assignment:"CH"}],integration:1,from:7.25625,to:7.26375}],nucleus:"1H",solvent:"CDCl₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.67,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.66625,to:3.67375}],nucleus:"1H",solvent:"CDCl₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.43,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.42625,to:1.4337499999999999}],nucleus:"1H",solvent:"CDCl₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.73,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.72625,to:3.73375}],nucleus:"1H",solvent:"CDCl₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.3,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.29625,to:5.30375}],nucleus:"1H",solvent:"CDCl₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.21,assignment:"CH₃"}],integration:6,from:1.18875,to:1.23125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.48,assignment:"CH₂"}],integration:4,from:3.45,to:3.51}],nucleus:"1H",solvent:"CDCl₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.65,assignment:"CH₂"}],integration:4,from:3.6462499999999998,to:3.65375},{signals:[{js:[],delta:3.57,assignment:"CH₂"}],integration:4,from:3.5662499999999997,to:3.57375},{signals:[{js:[],delta:3.39,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.38625,to:3.3937500000000003}],nucleus:"1H",solvent:"CDCl₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:8.02,multiplicity:"s",assignment:"CH"}],integration:1,from:8.01625,to:8.02375},{signals:[{js:[],delta:2.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.95625,to:2.96375},{signals:[{js:[],delta:2.88,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8762499999999998,to:2.88375}],nucleus:"1H",solvent:"CDCl₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.71,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.70625,to:3.71375}],nucleus:"1H",solvent:"CDCl₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.4,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.3962499999999998,to:3.40375},{signals:[{js:[],delta:3.55,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.5462499999999997,to:3.55375}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.87,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.86625,to:.87375}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.25,assignment:"CH₃"}],integration:3,from:1.22875,to:1.27125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.72,assignment:"CH₂"}],integration:2,from:3.6900000000000004,to:3.75},{signals:[{js:[],delta:1.32,multiplicity:"s",assignment:"OH"}],integration:1,from:1.3162500000000001,to:1.32375}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.05,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.0462499999999997,to:2.05375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.12,assignment:"CH₂CH₃"}],integration:2,from:4.09,to:4.15},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.26,assignment:"CH₂CH₃"}],integration:3,from:1.23875,to:1.28125}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.4,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.39625,to:5.4037500000000005}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.76,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.7562499999999996,to:3.76375}],nucleus:"1H",solvent:"CDCl₃"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.84,to:.87,multiplicity:"m"},{signals:[{js:[],delta:1.25,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.24625,to:1.25375}],nucleus:"1H",solvent:"CDCl₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.24,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.23625,to:2.2437500000000004}],nucleus:"1H",solvent:"CDCl₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85875,to:.90125},{signals:[{js:[],delta:1.26,assignment:"CH₂"}],integration:8,from:1.25625,to:1.26375}],nucleus:"1H",solvent:"CDCl₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"CDCl₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.65,assignment:"CH₃"}],integration:18,from:2.634375,to:2.665625}],nucleus:"1H",solvent:"CDCl₃"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.62,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.61625,to:4.62375}],nucleus:"1H",solvent:"CDCl₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.67,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.66625,to:7.67375},{signals:[{js:[],delta:7.1,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.0962499999999995,to:7.10375}],nucleus:"1H",solvent:"CDCl₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.22,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.21625,to:.22375}],nucleus:"1H",solvent:"CDCl₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.49,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.48625,to:3.4937500000000004},{signals:[{js:[],delta:1.09,multiplicity:"s",assignment:"OH"}],integration:1,from:1.0862500000000002,to:1.09375}],nucleus:"1H",solvent:"CDCl₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.33,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.32625,to:4.33375}],nucleus:"1H",solvent:"CDCl₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85875,to:.90125},{signals:[{js:[],delta:1.27,assignment:"CH₂"}],integration:6,from:1.26625,to:1.27375}],nucleus:"1H",solvent:"CDCl₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.878,to:.922},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.32,assignment:"CH₂"}],integration:2,from:1.2615,to:1.3785}],nucleus:"1H",solvent:"CDCl₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.22,assignment:"CH₃"}],integration:6,from:1.20875,to:1.23125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:4.04,assignment:"CH"}],integration:1,from:3.99125,to:4.08875}],nucleus:"1H",solvent:"CDCl₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.73,assignment:"CH₃"}],integration:3,from:1.7145,to:1.7455},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.94,assignment:"CH₂(1)"}],integration:1,from:4.92375,to:4.956250000000001},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.005,to:5.055000000000001},{signals:[{js:[],delta:5.83,assignment:"CH"}],integration:1,from:5.82625,to:5.83375}],nucleus:"1H",solvent:"CDCl₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.62,assignment:"CH(2,6)"}],integration:2,from:8.616249999999999,to:8.62375},{signals:[{js:[],delta:7.29,assignment:"CH(3,5)"}],integration:2,from:7.28625,to:7.29375},{signals:[{js:[],delta:7.68,assignment:"CH(4)"}],integration:1,from:7.67625,to:7.68375}],nucleus:"1H",solvent:"CDCl₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:8.4,assignment:"NH"}],integration:1,from:8.39625,to:8.40375},{signals:[{js:[],delta:6.83,assignment:"CH(2,5)"}],integration:2,from:6.82625,to:6.83375},{signals:[{js:[],delta:6.26,assignment:"CH(3,4)"}],integration:2,from:6.25625,to:6.26375}],nucleus:"1H",solvent:"CDCl₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.87,assignment:"CH₂(2,5)"}],integration:4,from:2.86625,to:2.8737500000000002},{signals:[{js:[],delta:1.68,assignment:"CH₂(3,4)"}],integration:4,from:1.67625,to:1.6837499999999999}],nucleus:"1H",solvent:"CDCl₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"CDCl₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.76,assignment:"CH₂(2,5)"}],integration:4,from:3.7562499999999996,to:3.76375},{signals:[{js:[],delta:1.85,assignment:"CH₂(3,4)"}],integration:4,from:1.8462500000000002,to:1.85375}],nucleus:"1H",solvent:"CDCl₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.36,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.3562499999999997,to:2.36375},{signals:[{js:[],delta:7.17,assignment:"CH(2,4,6)"}],integration:3,from:7.16625,to:7.17375},{signals:[{js:[],delta:7.25,assignment:"CH(3,5)"}],integration:2,from:7.24625,to:7.25375}],nucleus:"1H",solvent:"CDCl₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.03,assignment:"CH₃"}],integration:6,from:1.00875,to:1.05125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.53,assignment:"CH₂"}],integration:4,from:2.5,to:2.5599999999999996}],nucleus:"1H",solvent:"CDCl₃"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:.43,multiplicity:"s",assignment:"OH"}],integration:2,from:.42625,to:.43374999999999997}],nucleus:"1H",solvent:"toluene-d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.57,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.5662500000000001,to:1.57375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:1.57,multiplicity:"s",assignment:"CH₃"}],integration:6,from:1.5662500000000001,to:1.57375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:.69,multiplicity:"s",assignment:"CH₃"}],integration:3,from:.6862499999999999,to:.69375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.12,multiplicity:"s",assignment:"CH"}],integration:6,from:7.11625,to:7.12375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.03,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.02625,to:1.03375},{signals:[{js:[],delta:.58,multiplicity:"s",assignment:"OH"}],integration:1,from:.5762499999999999,to:.58375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:6.1,multiplicity:"s",assignment:"CH"}],integration:1,from:6.0962499999999995,to:6.10375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.36,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.3562499999999997,to:3.36375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.39625,to:1.4037499999999998}],nucleus:"1H",solvent:"toluene-d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:2.91,multiplicity:"s",assignment:"CH₂"}],integration:4,from:2.90625,to:2.9137500000000003}],nucleus:"1H",solvent:"toluene-d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:4.32,multiplicity:"s",assignment:"CH₂"}],integration:2,from:4.31625,to:4.32375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.1,assignment:"CH₃"}],integration:6,from:1.07875,to:1.12125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.25,assignment:"CH₂"}],integration:4,from:3.22,to:3.28}],nucleus:"1H",solvent:"toluene-d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.43,assignment:"CH₂"}],integration:4,from:3.42625,to:3.4337500000000003},{signals:[{js:[],delta:3.31,assignment:"CH₂"}],integration:4,from:3.30625,to:3.31375},{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.11625,to:3.1237500000000002}],nucleus:"1H",solvent:"toluene-d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.57,multiplicity:"s",assignment:"CH"}],integration:1,from:7.56625,to:7.57375},{signals:[{js:[],delta:2.37,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.36625,to:2.3737500000000002},{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.95625,to:1.9637499999999999}],nucleus:"1H",solvent:"toluene-d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.32625,to:3.33375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.11625,to:3.1237500000000002},{signals:[{js:[],delta:3.31,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.30625,to:3.31375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.81,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.80625,to:.8137500000000001}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.97,assignment:"CH₃"}],integration:3,from:.94875,to:.99125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.36,assignment:"CH₂"}],integration:2,from:3.33,to:3.3899999999999997},{signals:[{js:[],delta:.83,multiplicity:"s",assignment:"OH"}],integration:1,from:.8262499999999999,to:.83375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.69,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.68625,to:1.6937499999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.87,assignment:"CH₂CH₃"}],integration:2,from:3.8400000000000003,to:3.9},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.94,assignment:"CH₂CH₃"}],integration:3,from:.91875,to:.9612499999999999}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.25,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.24625,to:5.25375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.36,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.3562499999999997,to:3.36375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.89,to:.96,multiplicity:"m"},{signals:[{js:[],delta:1.33,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.3262500000000002,to:1.33375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.09625,to:2.1037500000000002}],nucleus:"1H",solvent:"toluene-d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85875,to:.90125},{signals:[{js:[],delta:1.22,assignment:"CH₂"}],integration:8,from:1.21625,to:1.22375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.09625,to:.10375000000000001}],nucleus:"1H",solvent:"toluene-d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.42,assignment:"CH₃"}],integration:18,from:2.404375,to:2.435625}],nucleus:"1H",solvent:"toluene-d₈"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.5,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.49625,to:4.50375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.3,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.29625,to:7.30375},{signals:[{js:[],delta:6.86,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:6.85625,to:6.8637500000000005}],nucleus:"1H",solvent:"toluene-d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.17,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.16625,to:.17375000000000002}],nucleus:"1H",solvent:"toluene-d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.03,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.0262499999999997,to:3.03375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:3.01,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.0062499999999996,to:3.01375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.87,assignment:"CH₃"}],integration:6,from:.84875,to:.89125},{signals:[{js:[],delta:1.25,assignment:"CH₂"}],integration:6,from:1.24625,to:1.25375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.868,to:.912},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.32,assignment:"CH₂"}],integration:2,from:1.2615,to:1.3785}],nucleus:"1H",solvent:"toluene-d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:.95,assignment:"CH₃"}],integration:6,from:.93875,to:.9612499999999999},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.65,assignment:"CH"}],integration:1,from:3.60125,to:3.69875}],nucleus:"1H",solvent:"toluene-d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.55,assignment:"CH₃"}],integration:3,from:1.5345,to:1.5655000000000001},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.92,assignment:"CH₂(1)"}],integration:1,from:4.90375,to:4.93625},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:4.98,assignment:"CH₂(2)"}],integration:1,from:4.955,to:5.005000000000001},{signals:[{js:[],delta:5.7,assignment:"CH"}],integration:1,from:5.69625,to:5.70375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.47,assignment:"CH(2,6)"}],integration:2,from:8.46625,to:8.47375},{signals:[{js:[],delta:6.67,assignment:"CH(3,5)"}],integration:2,from:6.66625,to:6.67375},{signals:[{js:[],delta:6.99,assignment:"CH(4)"}],integration:1,from:6.98625,to:6.99375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:7.71,assignment:"NH"}],integration:1,from:7.70625,to:7.71375},{signals:[{js:[],delta:6.43,assignment:"CH(2,5)"}],integration:2,from:6.42625,to:6.43375},{signals:[{js:[],delta:6.27,assignment:"CH(3,4)"}],integration:2,from:6.266249999999999,to:6.27375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.54,assignment:"CH₂(2,5)"}],integration:4,from:2.53625,to:2.54375},{signals:[{js:[],delta:1.36,assignment:"CH₂(3,4)"}],integration:4,from:1.3562500000000002,to:1.36375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.26,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.25625000000000003,to:.26375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.54,assignment:"CH₂(2,5)"}],integration:4,from:3.53625,to:3.54375},{signals:[{js:[],delta:1.43,assignment:"CH₂(3,4)"}],integration:4,from:1.42625,to:1.4337499999999999}],nucleus:"1H",solvent:"toluene-d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.11,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.1062499999999997,to:2.11375},{signals:[],integration:3,from:6.96,to:7.01,multiplicity:"m"},{signals:[{js:[],delta:7.09,assignment:"CH(3,5)"}],integration:2,from:7.08625,to:7.09375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.95,assignment:"CH₃"}],integration:6,from:.92875,to:.97125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.39,assignment:"CH₂"}],integration:4,from:2.3600000000000003,to:2.42}],nucleus:"1H",solvent:"toluene-d₈"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:.4,multiplicity:"s",assignment:"OH"}],integration:2,from:.39625000000000005,to:.40375}],nucleus:"1H",solvent:"C₆D₆"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.52,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.51625,to:1.52375}],nucleus:"1H",solvent:"C₆D₆"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:1.55,multiplicity:"s",assignment:"CH₃"}],integration:6,from:1.5462500000000001,to:1.55375}],nucleus:"1H",solvent:"C₆D₆"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:.58,multiplicity:"s",assignment:"CH₃"}],integration:3,from:.5762499999999999,to:.58375}],nucleus:"1H",solvent:"C₆D₆"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.15,multiplicity:"s",assignment:"CH"}],integration:6,from:7.14625,to:7.1537500000000005}],nucleus:"1H",solvent:"C₆D₆"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.05,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.0462500000000001,to:1.05375},{signals:[{js:[],delta:.63,multiplicity:"s",assignment:"OH"}],integration:1,from:.62625,to:.63375}],nucleus:"1H",solvent:"C₆D₆"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:6.15,multiplicity:"s",assignment:"CH"}],integration:1,from:6.14625,to:6.1537500000000005}],nucleus:"1H",solvent:"C₆D₆"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.39,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.38625,to:3.3937500000000003}],nucleus:"1H",solvent:"C₆D₆"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.39625,to:1.4037499999999998}],nucleus:"1H",solvent:"C₆D₆"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:2.9,multiplicity:"s",assignment:"CH₂"}],integration:4,from:2.8962499999999998,to:2.90375}],nucleus:"1H",solvent:"C₆D₆"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:4.27,multiplicity:"s",assignment:"CH₂"}],integration:2,from:4.266249999999999,to:4.27375}],nucleus:"1H",solvent:"C₆D₆"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.11,assignment:"CH₃"}],integration:6,from:1.08875,to:1.13125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.26,assignment:"CH₂"}],integration:4,from:3.23,to:3.2899999999999996}],nucleus:"1H",solvent:"C₆D₆"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.46,assignment:"CH₂"}],integration:4,from:3.45625,to:3.46375},{signals:[{js:[],delta:3.34,assignment:"CH₂"}],integration:4,from:3.3362499999999997,to:3.34375},{signals:[{js:[],delta:3.11,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.1062499999999997,to:3.11375}],nucleus:"1H",solvent:"C₆D₆"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.63,multiplicity:"s",assignment:"CH"}],integration:1,from:7.62625,to:7.63375},{signals:[{js:[],delta:2.36,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.3562499999999997,to:2.36375},{signals:[{js:[],delta:1.86,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.8562500000000002,to:1.86375}],nucleus:"1H",solvent:"C₆D₆"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.35,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.34625,to:3.3537500000000002}],nucleus:"1H",solvent:"C₆D₆"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.11625,to:3.1237500000000002},{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.32625,to:3.33375}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.8,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.79625,to:.8037500000000001}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:3,from:.93875,to:.98125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.34,assignment:"CH₂"}],integration:2,from:3.31,to:3.3699999999999997},{signals:[{js:[],delta:.5,multiplicity:"s",assignment:"OH"}],integration:1,from:.49625,to:.50375}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.65,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.64625,to:1.6537499999999998},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.89,assignment:"CH₂CH₃"}],integration:2,from:3.8600000000000003,to:3.92},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.92,assignment:"CH₂CH₃"}],integration:3,from:.89875,to:.94125}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.25,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.24625,to:5.25375}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.41,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.40625,to:3.4137500000000003}],nucleus:"1H",solvent:"C₆D₆"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.9,to:.98,multiplicity:"m"},{signals:[{js:[],delta:1.32,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.3162500000000001,to:1.32375}],nucleus:"1H",solvent:"C₆D₆"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.13,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.1262499999999998,to:2.13375}],nucleus:"1H",solvent:"C₆D₆"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.24,assignment:"CH₂"}],integration:8,from:1.23625,to:1.24375}],nucleus:"1H",solvent:"C₆D₆"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.12,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.11624999999999999,to:.12375}],nucleus:"1H",solvent:"C₆D₆"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.4,assignment:"CH₃"}],integration:18,from:2.384375,to:2.415625}],nucleus:"1H",solvent:"C₆D₆"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.47,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.46625,to:4.47375}],nucleus:"1H",solvent:"C₆D₆"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.33,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.32625,to:7.33375},{signals:[{js:[],delta:6.9,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:6.89625,to:6.9037500000000005}],nucleus:"1H",solvent:"C₆D₆"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.16,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.15625,to:.16375}],nucleus:"1H",solvent:"C₆D₆"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.07,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.0662499999999997,to:3.07375}],nucleus:"1H",solvent:"C₆D₆"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:2.94,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.93625,to:2.94375}],nucleus:"1H",solvent:"C₆D₆"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.87,assignment:"CH₃"}],integration:6,from:.84875,to:.89125},{signals:[{js:[],delta:1.23,assignment:"CH₂"}],integration:6,from:1.22625,to:1.23375}],nucleus:"1H",solvent:"C₆D₆"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.86,assignment:"CH₃"}],integration:6,from:.838,to:.882},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.26,assignment:"CH₂"}],integration:2,from:1.2015,to:1.3185}],nucleus:"1H",solvent:"C₆D₆"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:.95,assignment:"CH₃"}],integration:6,from:.93875,to:.9612499999999999},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.67,assignment:"CH"}],integration:1,from:3.62125,to:3.71875}],nucleus:"1H",solvent:"C₆D₆"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.55,assignment:"CH₃"}],integration:3,from:1.5345,to:1.5655000000000001},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.95,assignment:"CH₂(1)"}],integration:1,from:4.93375,to:4.9662500000000005},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.01,assignment:"CH₂(2)"}],integration:1,from:4.984999999999999,to:5.035},{signals:[{js:[],delta:5.72,assignment:"CH"}],integration:1,from:5.71625,to:5.72375}],nucleus:"1H",solvent:"C₆D₆"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.53,assignment:"CH(2,6)"}],integration:2,from:8.52625,to:8.53375},{signals:[{js:[],delta:6.66,assignment:"CH(3,5)"}],integration:2,from:6.65625,to:6.66375},{signals:[{js:[],delta:6.98,assignment:"CH(4)"}],integration:1,from:6.97625,to:6.983750000000001}],nucleus:"1H",solvent:"C₆D₆"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:7.8,assignment:"NH"}],integration:1,from:7.79625,to:7.80375},{signals:[{js:[],delta:6.48,assignment:"CH(2,5)"}],integration:2,from:6.47625,to:6.483750000000001},{signals:[{js:[],delta:6.37,assignment:"CH(3,4)"}],integration:2,from:6.36625,to:6.37375}],nucleus:"1H",solvent:"C₆D₆"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.54,assignment:"CH₂(2,5)"}],integration:4,from:2.53625,to:2.54375},{signals:[{js:[],delta:1.33,assignment:"CH₂(3,4)"}],integration:4,from:1.3262500000000002,to:1.33375}],nucleus:"1H",solvent:"C₆D₆"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.29,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.28625,to:.29374999999999996}],nucleus:"1H",solvent:"C₆D₆"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.57,assignment:"CH₂(2,5)"}],integration:4,from:3.5662499999999997,to:3.57375},{signals:[{js:[],delta:1.4,assignment:"CH₂(3,4)"}],integration:4,from:1.39625,to:1.4037499999999998}],nucleus:"1H",solvent:"C₆D₆"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.11,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.1062499999999997,to:2.11375},{signals:[{js:[],delta:7.02,assignment:"CH(2,4,6)"}],integration:3,from:7.016249999999999,to:7.02375},{signals:[{js:[],delta:7.13,assignment:"CH(3,5)"}],integration:2,from:7.12625,to:7.13375}],nucleus:"1H",solvent:"C₆D₆"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:6,from:.93875,to:.98125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.4,assignment:"CH₂"}],integration:4,from:2.37,to:2.4299999999999997}],nucleus:"1H",solvent:"C₆D₆"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:1.03,multiplicity:"s",assignment:"OH"}],integration:2,from:1.02625,to:1.03375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.76,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.75625,to:1.76375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:1.77,multiplicity:"s",assignment:"CH₃"}],integration:6,from:1.76625,to:1.77375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.21,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.20625,to:1.2137499999999999}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.2,multiplicity:"s",assignment:"CH"}],integration:6,from:7.19625,to:7.20375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.12,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.1162500000000002,to:1.12375},{signals:[{js:[],delta:1.3,multiplicity:"s",assignment:"OH"}],integration:1,from:1.2962500000000001,to:1.30375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:6.74,multiplicity:"s",assignment:"CH"}],integration:1,from:6.73625,to:6.74375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.41,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.40625,to:3.4137500000000003}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.37,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.3662500000000002,to:1.37375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.26,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.2562499999999996,to:3.26375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:4.77,multiplicity:"s",assignment:"CH₂"}],integration:2,from:4.766249999999999,to:4.77375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.1,assignment:"CH₃"}],integration:6,from:1.07875,to:1.12125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.31,assignment:"CH₂"}],integration:4,from:3.2800000000000002,to:3.34}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.49,assignment:"CH₂"}],integration:4,from:3.48625,to:3.4937500000000004},{signals:[{js:[],delta:3.37,assignment:"CH₂"}],integration:4,from:3.36625,to:3.3737500000000002},{signals:[{js:[],delta:3.16,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.15625,to:3.1637500000000003}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.73,multiplicity:"s",assignment:"CH"}],integration:1,from:7.72625,to:7.733750000000001},{signals:[{js:[],delta:2.51,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.5062499999999996,to:2.51375},{signals:[{js:[],delta:2.3,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.2962499999999997,to:2.30375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.45,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.44625,to:3.4537500000000003}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.17,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.16625,to:3.17375},{signals:[{js:[],delta:3.37,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.36625,to:3.3737500000000002}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.79,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.78625,to:.7937500000000001}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.06,assignment:"CH₃"}],integration:3,from:1.03875,to:1.08125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.51,assignment:"CH₂"}],integration:2,from:3.48,to:3.5399999999999996},{signals:[{js:[],delta:1.39,multiplicity:"s",assignment:"OH"}],integration:1,from:1.38625,to:1.3937499999999998}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.78,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.77625,to:1.78375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.96,assignment:"CH₂CH₃"}],integration:2,from:3.93,to:3.9899999999999998},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.04,assignment:"CH₂CH₃"}],integration:3,from:1.01875,to:1.06125}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.29,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.28625,to:5.29375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.58,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.57625,to:3.58375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.86,to:.92,multiplicity:"m"},{signals:[{js:[],delta:1.3,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.2962500000000001,to:1.30375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.09625,to:2.1037500000000002}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.85,assignment:"CH₃"}],integration:6,from:.82875,to:.87125},{signals:[{js:[],delta:1.19,assignment:"CH₂"}],integration:8,from:1.18625,to:1.1937499999999999}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.09625,to:.10375000000000001}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.47,assignment:"CH₃"}],integration:18,from:2.454375,to:2.485625}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.49,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.48625,to:4.49375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.53,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.52625,to:7.53375},{signals:[{js:[],delta:7.01,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.00625,to:7.01375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.15,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.14625,to:.15375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.25,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.24625,to:3.25375},{signals:[{js:[],delta:1.3,multiplicity:"s",assignment:"OH"}],integration:1,from:1.2962500000000001,to:1.30375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.5862499999999997,to:3.59375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.84,assignment:"CH₃"}],integration:6,from:.81875,to:.86125},{signals:[{js:[],delta:1.23,assignment:"CH₂"}],integration:6,from:1.22625,to:1.23375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.84,assignment:"CH₃"}],integration:6,from:.818,to:.862},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.26,assignment:"CH₂"}],integration:2,from:1.2015,to:1.3185}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.04,assignment:"CH₃"}],integration:6,from:1.02875,to:1.05125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.82,assignment:"CH"}],integration:1,from:3.7712499999999998,to:3.86875}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.58,assignment:"CH₃"}],integration:3,from:1.5645,to:1.5955000000000001},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.91,assignment:"CH₂(1)"}],integration:1,from:4.89375,to:4.9262500000000005},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:4.98,assignment:"CH₂(2)"}],integration:1,from:4.955,to:5.005000000000001},{signals:[{js:[],delta:5.72,assignment:"CH"}],integration:1,from:5.71625,to:5.72375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.51,assignment:"CH(2,6)"}],integration:2,from:8.50625,to:8.51375},{signals:[{js:[],delta:6.9,assignment:"CH(3,5)"}],integration:2,from:6.89625,to:6.9037500000000005},{signals:[{js:[],delta:7.25,assignment:"CH(4)"}],integration:1,from:7.24625,to:7.25375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:8.61,assignment:"NH"}],integration:1,from:8.60625,to:8.61375},{signals:[{js:[],delta:6.62,assignment:"CH(2,5)"}],integration:2,from:6.61625,to:6.62375},{signals:[{js:[],delta:6.27,assignment:"CH(3,4)"}],integration:2,from:6.266249999999999,to:6.27375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.64,assignment:"CH₂(2,5)"}],integration:4,from:2.63625,to:2.6437500000000003},{signals:[{js:[],delta:1.43,assignment:"CH₂(3,4)"}],integration:4,from:1.42625,to:1.4337499999999999}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.14,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.13625,to:.14375000000000002}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.59,assignment:"CH₂(2,5)"}],integration:4,from:3.5862499999999997,to:3.59375},{signals:[{js:[],delta:1.55,assignment:"CH₂(3,4)"}],integration:4,from:1.5462500000000001,to:1.55375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.16,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.15625,to:2.1637500000000003},{signals:[],integration:3,from:7.01,to:7.08,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.17,multiplicity:"m"}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.93,assignment:"CH₃"}],integration:6,from:.9087500000000001,to:.95125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.39,assignment:"CH₂"}],integration:4,from:2.3600000000000003,to:2.42}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:2.84,multiplicity:"s",assignment:"OH"}],integration:2,from:2.8362499999999997,to:2.84375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.95625,to:1.9637499999999999}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.09,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.0862499999999997,to:2.09375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.05,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.0462499999999997,to:2.05375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.36,multiplicity:"s",assignment:"CH"}],integration:6,from:7.35625,to:7.3637500000000005}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.18,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.17625,to:1.1837499999999999}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:8.02,multiplicity:"s",assignment:"CH"}],integration:1,from:8.01625,to:8.02375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.5862499999999997,to:3.59375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.43,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.42625,to:1.4337499999999999}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.87,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.86625,to:3.8737500000000002}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.63,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.62625,to:5.63375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.11,assignment:"CH₃"}],integration:6,from:1.08875,to:1.13125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.41,assignment:"CH₂"}],integration:4,from:3.3800000000000003,to:3.44}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.56,assignment:"CH₂"}],integration:4,from:3.55625,to:3.56375},{signals:[{js:[],delta:3.47,assignment:"CH₂"}],integration:4,from:3.46625,to:3.4737500000000003},{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.2762499999999997,to:3.28375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.96,multiplicity:"s",assignment:"CH"}],integration:1,from:7.95625,to:7.96375},{signals:[{js:[],delta:2.94,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.93625,to:2.94375},{signals:[{js:[],delta:2.78,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.7762499999999997,to:2.78375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.5862499999999997,to:3.59375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.2762499999999997,to:3.28375},{signals:[{js:[],delta:3.46,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.45625,to:3.46375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.83,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.8262499999999999,to:.83375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:3,from:1.0987500000000001,to:1.14125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.57,assignment:"CH₂"}],integration:2,from:3.54,to:3.5999999999999996},{signals:[{js:[],delta:3.39,multiplicity:"s",assignment:"OH"}],integration:1,from:3.38625,to:3.3937500000000003}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.97,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.96625,to:1.97375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.05,assignment:"CH₂CH₃"}],integration:2,from:4.02,to:4.08},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.2,assignment:"CH₂CH₃"}],integration:3,from:1.17875,to:1.22125}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.38,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.37625,to:5.38375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.2762499999999997,to:3.28375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[{js:[],delta:.9,assignment:"CH₃"}],integration:6,from:.89625,to:.90375},{signals:[{js:[],delta:1.29,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.17,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.16625,to:2.17375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85875,to:.90125},{signals:[{js:[],delta:1.28,assignment:"CH₂"}],integration:8,from:1.27625,to:1.28375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.59,assignment:"CH₃"}],integration:18,from:2.574375,to:2.605625}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.54,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.53625,to:4.54375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.62,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.61625,to:7.62375},{signals:[{js:[],delta:7.04,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.03625,to:7.04375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.17,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.16625,to:.17375000000000002}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.30625,to:3.31375},{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"OH"}],integration:1,from:3.11625,to:3.1237500000000002}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.43,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.42625,to:4.43375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85875,to:.90125},{signals:[{js:[],delta:1.27,assignment:"CH₂"}],integration:6,from:1.26625,to:1.27375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.858,to:.902},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.31,assignment:"CH₂"}],integration:2,from:1.2515,to:1.3685}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.1,assignment:"CH₃"}],integration:6,from:1.08875,to:1.11125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.9,assignment:"CH"}],integration:1,from:3.85125,to:3.94875}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.68,assignment:"CH₃"}],integration:3,from:1.6644999999999999,to:1.6955},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.9,assignment:"CH₂(1)"}],integration:1,from:4.88375,to:4.916250000000001},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5,assignment:"CH₂(2)"}],integration:1,from:4.975,to:5.025},{signals:[{js:[],delta:5.81,assignment:"CH"}],integration:1,from:5.8062499999999995,to:5.81375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.58,assignment:"CH(2,6)"}],integration:2,from:8.57625,to:8.58375},{signals:[{js:[],delta:7.35,assignment:"CH(3,5)"}],integration:2,from:7.3462499999999995,to:7.35375},{signals:[{js:[],delta:7.76,assignment:"CH(4)"}],integration:1,from:7.75625,to:7.76375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:10.02,assignment:"NH"}],integration:1,from:10.01625,to:10.02375},{signals:[{js:[],delta:6.77,assignment:"CH(2,5)"}],integration:2,from:6.766249999999999,to:6.77375},{signals:[{js:[],delta:6.07,assignment:"CH(3,4)"}],integration:2,from:6.06625,to:6.07375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.13,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.12625,to:.13375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.63,assignment:"CH₂(2,5)"}],integration:4,from:3.6262499999999998,to:3.63375},{signals:[{js:[],delta:1.79,assignment:"CH₂(3,4)"}],integration:4,from:1.7862500000000001,to:1.79375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.32,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.3162499999999997,to:2.32375},{signals:[],integration:3,from:7.1,to:7.2,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.2,multiplicity:"m"}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:6,from:.93875,to:.98125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.45,assignment:"CH₂"}],integration:4,from:2.4200000000000004,to:2.48}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"OH"}],integration:2,from:3.32625,to:3.33375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.91,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.90625,to:1.9137499999999998}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.09,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.0862499999999997,to:2.09375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.07,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.0662499999999997,to:2.07375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.37,multiplicity:"s",assignment:"CH"}],integration:6,from:7.36625,to:7.37375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.11,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.1062500000000002,to:1.11375},{signals:[{js:[],delta:4.19,multiplicity:"s",assignment:"OH"}],integration:1,from:4.18625,to:4.1937500000000005}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:8.32,multiplicity:"s",assignment:"CH"}],integration:1,from:8.31625,to:8.32375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.51,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.5062499999999996,to:3.51375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.39625,to:1.4037499999999998}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.9,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.8962499999999998,to:3.90375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.76,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.75625,to:5.76375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.09,assignment:"CH₃"}],integration:6,from:1.06875,to:1.11125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.38,assignment:"CH₂"}],integration:4,from:3.35,to:3.4099999999999997}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.51,assignment:"CH₂"}],integration:4,from:3.5062499999999996,to:3.51375},{signals:[{js:[],delta:3.38,assignment:"CH₂"}],integration:4,from:3.3762499999999998,to:3.38375},{signals:[{js:[],delta:3.24,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.23625,to:3.2437500000000004}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.95,multiplicity:"s",assignment:"CH"}],integration:1,from:7.94625,to:7.95375},{signals:[{js:[],delta:2.89,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.88625,to:2.8937500000000003},{signals:[{js:[],delta:2.73,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.72625,to:2.73375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.57,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.5662499999999997,to:3.57375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.24,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.23625,to:3.2437500000000004},{signals:[{js:[],delta:3.43,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.42625,to:3.4337500000000003}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.82,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.8162499999999999,to:.82375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.06,assignment:"CH₃"}],integration:3,from:1.03875,to:1.08125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.44,assignment:"CH₂"}],integration:2,from:3.41,to:3.4699999999999998},{signals:[{js:[],delta:4.63,multiplicity:"s",assignment:"OH"}],integration:1,from:4.62625,to:4.63375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.99,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.98625,to:1.99375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.03,assignment:"CH₂CH₃"}],integration:2,from:4,to:4.0600000000000005},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.17,assignment:"CH₂CH₃"}],integration:3,from:1.14875,to:1.19125}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.41,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.40625,to:5.41375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.3362499999999997,to:3.34375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.82,to:.88,multiplicity:"m"},{signals:[{js:[],delta:1.24,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.23625,to:1.24375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.14,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.13625,to:2.1437500000000003}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.86,assignment:"CH₃"}],integration:6,from:.83875,to:.88125},{signals:[{js:[],delta:1.25,assignment:"CH₂"}],integration:8,from:1.24625,to:1.25375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.06,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.056249999999999994,to:.06375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.53,assignment:"CH₃"}],integration:18,from:2.514375,to:2.545625}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.61,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.60625,to:4.6137500000000005}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.63,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.62625,to:7.63375},{signals:[{js:[],delta:7.01,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.00625,to:7.01375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.2,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.19625,to:.20375000000000001}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.16,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.15625,to:3.1637500000000003},{signals:[{js:[],delta:4.01,multiplicity:"s",assignment:"OH"}],integration:1,from:4.00625,to:4.01375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.42,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.41625,to:4.42375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.86,assignment:"CH₃"}],integration:6,from:.83875,to:.88125},{signals:[{js:[],delta:1.27,assignment:"CH₂"}],integration:6,from:1.26625,to:1.27375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.87,assignment:"CH₃"}],integration:6,from:.848,to:.892},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.29,assignment:"CH₂"}],integration:2,from:1.2315,to:1.3485}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.04,assignment:"CH₃"}],integration:6,from:1.02875,to:1.05125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.78,assignment:"CH"}],integration:1,from:3.7312499999999997,to:3.82875}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.68,assignment:"CH₃"}],integration:3,from:1.6644999999999999,to:1.6955},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.94,assignment:"CH₂(1)"}],integration:1,from:4.92375,to:4.956250000000001},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.005,to:5.055000000000001},{signals:[{js:[],delta:5.8,assignment:"CH"}],integration:1,from:5.79625,to:5.80375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.58,assignment:"CH(2,6)"}],integration:2,from:8.57625,to:8.58375},{signals:[{js:[],delta:7.39,assignment:"CH(3,5)"}],integration:2,from:7.3862499999999995,to:7.39375},{signals:[{js:[],delta:7.79,assignment:"CH(4)"}],integration:1,from:7.78625,to:7.79375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:10.75,assignment:"NH"}],integration:1,from:10.74625,to:10.75375},{signals:[{js:[],delta:6.73,assignment:"CH(2,5)"}],integration:2,from:6.72625,to:6.733750000000001},{signals:[{js:[],delta:6.01,assignment:"CH(3,4)"}],integration:2,from:6.00625,to:6.01375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.67,assignment:"CH₂(2,5)"}],integration:4,from:2.66625,to:2.67375},{signals:[{js:[],delta:1.55,assignment:"CH₂(3,4)"}],integration:4,from:1.5462500000000001,to:1.55375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:-.06,multiplicity:"s",assignment:"CH₃"}],integration:6,from:-.06375,to:-.056249999999999994}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.6,assignment:"CH₂(2,5)"}],integration:4,from:3.59625,to:3.6037500000000002},{signals:[{js:[],delta:1.76,assignment:"CH₂(3,4)"}],integration:4,from:1.75625,to:1.76375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.3,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.2962499999999997,to:2.30375},{signals:[{js:[],delta:7.18,assignment:"CH(2,4,6)"}],integration:3,from:7.17625,to:7.18375},{signals:[{js:[],delta:7.25,assignment:"CH(3,5)"}],integration:2,from:7.24625,to:7.25375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.93,assignment:"CH₃"}],integration:6,from:.9087500000000001,to:.95125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.43,assignment:"CH₂"}],integration:4,from:2.4000000000000004,to:2.46}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:2.13,multiplicity:"s",assignment:"OH"}],integration:2,from:2.1262499999999998,to:2.13375}],nucleus:"1H",solvent:"CD₃CN"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.95625,to:1.9637499999999999}],nucleus:"1H",solvent:"CD₃CN"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.08,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.07625,to:2.08375}],nucleus:"1H",solvent:"CD₃CN"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.95625,to:1.9637499999999999}],nucleus:"1H",solvent:"CD₃CN"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.37,multiplicity:"s",assignment:"CH"}],integration:6,from:7.36625,to:7.37375}],nucleus:"1H",solvent:"CD₃CN"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.16,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.15625,to:1.1637499999999998},{signals:[{js:[],delta:2.18,multiplicity:"s",assignment:"OH"}],integration:1,from:2.17625,to:2.1837500000000003}],nucleus:"1H",solvent:"CD₃CN"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.58,multiplicity:"s",assignment:"CH"}],integration:1,from:7.57625,to:7.58375}],nucleus:"1H",solvent:"CD₃CN"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.51,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.5062499999999996,to:3.51375}],nucleus:"1H",solvent:"CD₃CN"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.44,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.43625,to:1.4437499999999999}],nucleus:"1H",solvent:"CD₃CN"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.81,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.80625,to:3.81375}],nucleus:"1H",solvent:"CD₃CN"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.44,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.43625,to:5.4437500000000005}],nucleus:"1H",solvent:"CD₃CN"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:6,from:1.0987500000000001,to:1.14125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.42,assignment:"CH₂"}],integration:4,from:3.39,to:3.4499999999999997}],nucleus:"1H",solvent:"CD₃CN"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.53,assignment:"CH₂"}],integration:4,from:3.5262499999999997,to:3.53375},{signals:[{js:[],delta:3.45,assignment:"CH₂"}],integration:4,from:3.44625,to:3.4537500000000003},{signals:[{js:[],delta:3.29,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.28625,to:3.29375}],nucleus:"1H",solvent:"CD₃CN"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.92,multiplicity:"s",assignment:"CH"}],integration:1,from:7.91625,to:7.92375},{signals:[{js:[],delta:2.89,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.88625,to:2.8937500000000003},{signals:[{js:[],delta:2.77,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.76625,to:2.77375}],nucleus:"1H",solvent:"CD₃CN"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.6,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.59625,to:3.6037500000000002}],nucleus:"1H",solvent:"CD₃CN"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.2762499999999997,to:3.28375},{signals:[{js:[],delta:3.45,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.44625,to:3.4537500000000003}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.84625,to:.85375}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:3,from:1.0987500000000001,to:1.14125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.54,assignment:"CH₂"}],integration:2,from:3.5100000000000002,to:3.57},{signals:[{js:[],delta:2.47,multiplicity:"s",assignment:"OH"}],integration:1,from:2.46625,to:2.4737500000000003}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.97,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.96625,to:1.97375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.06,assignment:"CH₂CH₃"}],integration:2,from:4.029999999999999,to:4.09},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.2,assignment:"CH₂CH₃"}],integration:3,from:1.17875,to:1.22125}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.41,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.40625,to:5.41375}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.51,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.5062499999999996,to:3.51375}],nucleus:"1H",solvent:"CD₃CN"},{names:["H greaseᶠ"],smiles:"",ranges:[],nucleus:"1H",solvent:"CD₃CN"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.19,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.18625,to:2.19375}],nucleus:"1H",solvent:"CD₃CN"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.28,assignment:"CH₂"}],integration:8,from:1.27625,to:1.28375}],nucleus:"1H",solvent:"CD₃CN"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"CD₃CN"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.57,assignment:"CH₃"}],integration:18,from:2.554375,to:2.585625}],nucleus:"1H",solvent:"CD₃CN"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.57,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.56625,to:4.57375}],nucleus:"1H",solvent:"CD₃CN"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.57,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.56625,to:7.57375},{signals:[{js:[],delta:7.01,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.00625,to:7.01375}],nucleus:"1H",solvent:"CD₃CN"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.2,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.19625,to:.20375000000000001}],nucleus:"1H",solvent:"CD₃CN"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.2762499999999997,to:3.28375},{signals:[{js:[],delta:2.16,multiplicity:"s",assignment:"OH"}],integration:1,from:2.15625,to:2.1637500000000003}],nucleus:"1H",solvent:"CD₃CN"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.3062499999999995,to:4.31375}],nucleus:"1H",solvent:"CD₃CN"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.29,assignment:"CH₂"}],integration:6,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"CD₃CN"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.878,to:.922},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.33,assignment:"CH₂"}],integration:2,from:1.2715,to:1.3885}],nucleus:"1H",solvent:"CD₃CN"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.09,assignment:"CH₃"}],integration:6,from:1.07875,to:1.10125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.87,assignment:"CH"}],integration:1,from:3.82125,to:3.91875}],nucleus:"1H",solvent:"CD₃CN"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.6844999999999999,to:1.7155},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.93,assignment:"CH₂(1)"}],integration:1,from:4.913749999999999,to:4.94625},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.04,assignment:"CH₂(2)"}],integration:1,from:5.015,to:5.065},{signals:[{js:[],delta:5.85,assignment:"CH"}],integration:1,from:5.8462499999999995,to:5.85375}],nucleus:"1H",solvent:"CD₃CN"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.57,assignment:"CH(2,6)"}],integration:2,from:8.56625,to:8.57375},{signals:[{js:[],delta:7.33,assignment:"CH(3,5)"}],integration:2,from:7.32625,to:7.33375},{signals:[{js:[],delta:7.73,assignment:"CH(4)"}],integration:1,from:7.72625,to:7.733750000000001}],nucleus:"1H",solvent:"CD₃CN"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:9.27,assignment:"NH"}],integration:1,from:9.26625,to:9.27375},{signals:[{js:[],delta:6.75,assignment:"CH(2,5)"}],integration:2,from:6.74625,to:6.75375},{signals:[{js:[],delta:6.1,assignment:"CH(3,4)"}],integration:2,from:6.0962499999999995,to:6.10375}],nucleus:"1H",solvent:"CD₃CN"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.75,assignment:"CH₂(2,5)"}],integration:4,from:2.74625,to:2.75375},{signals:[{js:[],delta:1.61,assignment:"CH₂(3,4)"}],integration:4,from:1.6062500000000002,to:1.61375}],nucleus:"1H",solvent:"CD₃CN"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.08,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.07625,to:.08375}],nucleus:"1H",solvent:"CD₃CN"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.64,assignment:"CH₂(2,5)"}],integration:4,from:3.63625,to:3.6437500000000003},{signals:[{js:[],delta:1.8,assignment:"CH₂(3,4)"}],integration:4,from:1.7962500000000001,to:1.80375}],nucleus:"1H",solvent:"CD₃CN"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.33,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.32625,to:2.33375},{signals:[],integration:3,from:7.1,to:7.3,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.3,multiplicity:"m"}],nucleus:"1H",solvent:"CD₃CN"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:6,from:.93875,to:.98125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.45,assignment:"CH₂"}],integration:4,from:2.4200000000000004,to:2.48}],nucleus:"1H",solvent:"CD₃CN"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:3.66,multiplicity:"s",assignment:"OH"}],integration:2,from:3.65625,to:3.6637500000000003}],nucleus:"1H",solvent:"TFE-d₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.06,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.05625,to:2.06375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.19,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.18625,to:2.19375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.95,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.94625,to:1.9537499999999999}],nucleus:"1H",solvent:"TFE-d₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.36,multiplicity:"s",assignment:"CH"}],integration:6,from:7.35625,to:7.3637500000000005}],nucleus:"1H",solvent:"TFE-d₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.28,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.27625,to:1.28375},{signals:[{js:[],delta:2.2,multiplicity:"s",assignment:"OH"}],integration:1,from:2.19625,to:2.2037500000000003}],nucleus:"1H",solvent:"TFE-d₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.33,multiplicity:"s",assignment:"CH"}],integration:1,from:7.32625,to:7.33375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.64,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.63625,to:3.6437500000000003}],nucleus:"1H",solvent:"TFE-d₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.47,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.46625,to:1.47375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.71,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.70625,to:3.71375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.24,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.23625,to:5.24375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.2,assignment:"CH₃"}],integration:6,from:1.17875,to:1.22125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.58,assignment:"CH₂"}],integration:4,from:3.5500000000000003,to:3.61}],nucleus:"1H",solvent:"TFE-d₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.67,assignment:"CH₂"}],integration:4,from:3.66625,to:3.67375},{signals:[{js:[],delta:3.62,assignment:"CH₂"}],integration:4,from:3.61625,to:3.6237500000000002},{signals:[{js:[],delta:3.41,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.40625,to:3.4137500000000003}],nucleus:"1H",solvent:"TFE-d₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.86,multiplicity:"s",assignment:"CH"}],integration:1,from:7.85625,to:7.8637500000000005},{signals:[{js:[],delta:2.98,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.97625,to:2.98375},{signals:[{js:[],delta:2.88,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8762499999999998,to:2.88375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.76,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.7562499999999996,to:3.76375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.4,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.3962499999999998,to:3.40375},{signals:[{js:[],delta:3.61,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.6062499999999997,to:3.61375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.84625,to:.85375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.22,assignment:"CH₃"}],integration:3,from:1.19875,to:1.24125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.71,assignment:"CH₂"}],integration:2,from:3.68,to:3.7399999999999998}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.03,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.0262499999999997,to:2.03375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.14,assignment:"CH₂CH₃"}],integration:2,from:4.109999999999999,to:4.17},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.26,assignment:"CH₂CH₃"}],integration:3,from:1.23875,to:1.28125}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.4,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.39625,to:5.4037500000000005}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.72,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.71625,to:3.7237500000000003}],nucleus:"1H",solvent:"TFE-d₃"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.88,to:.94,multiplicity:"m"},{signals:[{js:[],delta:1.33,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.3262500000000002,to:1.33375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.24,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.23625,to:2.2437500000000004}],nucleus:"1H",solvent:"TFE-d₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.91,assignment:"CH₃"}],integration:6,from:.88875,to:.93125},{signals:[{js:[],delta:1.31,assignment:"CH₂"}],integration:8,from:1.3062500000000001,to:1.31375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.08,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.07625,to:.08375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.63,assignment:"CH₃"}],integration:18,from:2.614375,to:2.645625}],nucleus:"1H",solvent:"TFE-d₃"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.53,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.52625,to:4.53375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.61,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.60625,to:7.6137500000000005},{signals:[{js:[],delta:7.03,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.02625,to:7.03375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.18,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.17625,to:.18375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.44,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.43625,to:3.44375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.28,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.27625,to:4.28375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.87875,to:.92125},{signals:[{js:[],delta:1.33,assignment:"CH₂"}],integration:6,from:1.3262500000000002,to:1.33375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.878,to:.922},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.33,assignment:"CH₂"}],integration:2,from:1.2715,to:1.3885}],nucleus:"1H",solvent:"TFE-d₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.2,assignment:"CH₃"}],integration:6,from:1.18875,to:1.21125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:4.05,assignment:"CH"}],integration:1,from:4.00125,to:4.09875}],nucleus:"1H",solvent:"TFE-d₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.6844999999999999,to:1.7155},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.93,assignment:"CH₂(1)"}],integration:1,from:4.913749999999999,to:4.94625},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.005,to:5.055000000000001},{signals:[{js:[],delta:5.87,assignment:"CH"}],integration:1,from:5.86625,to:5.87375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.45,assignment:"CH(2,6)"}],integration:2,from:8.44625,to:8.45375},{signals:[{js:[],delta:7.4,assignment:"CH(3,5)"}],integration:2,from:7.39625,to:7.4037500000000005},{signals:[{js:[],delta:7.82,assignment:"CH(4)"}],integration:1,from:7.81625,to:7.82375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:6.84,assignment:"CH(2,5)"}],integration:2,from:6.83625,to:6.84375},{signals:[{js:[],delta:6.24,assignment:"CH(3,4)"}],integration:2,from:6.23625,to:6.24375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:3.11,assignment:"CH₂(2,5)"}],integration:4,from:3.1062499999999997,to:3.11375},{signals:[{js:[],delta:1.93,assignment:"CH₂(3,4)"}],integration:4,from:1.92625,to:1.9337499999999999}],nucleus:"1H",solvent:"TFE-d₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.16,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.15625,to:.16375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.78,assignment:"CH₂(2,5)"}],integration:4,from:3.7762499999999997,to:3.78375},{signals:[{js:[],delta:1.91,assignment:"CH₂(3,4)"}],integration:4,from:1.90625,to:1.9137499999999998}],nucleus:"1H",solvent:"TFE-d₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.33,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.32625,to:2.33375},{signals:[],integration:3,from:7.1,to:7.3,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.3,multiplicity:"m"}],nucleus:"1H",solvent:"TFE-d₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.31,assignment:"CH₃"}],integration:6,from:1.28875,to:1.33125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.12,assignment:"CH₂"}],integration:4,from:3.0900000000000003,to:3.15}],nucleus:"1H",solvent:"TFE-d₃"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:4.87,multiplicity:"s",assignment:"OH"}],integration:2,from:4.86625,to:4.87375}],nucleus:"1H",solvent:"CD₃OD"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.99,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.98625,to:1.99375}],nucleus:"1H",solvent:"CD₃OD"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.15,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.1462499999999998,to:2.15375}],nucleus:"1H",solvent:"CD₃OD"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.03,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.0262499999999997,to:2.03375}],nucleus:"1H",solvent:"CD₃OD"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.33,multiplicity:"s",assignment:"CH"}],integration:6,from:7.32625,to:7.33375}],nucleus:"1H",solvent:"CD₃OD"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.39625,to:1.4037499999999998}],nucleus:"1H",solvent:"CD₃OD"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.9,multiplicity:"s",assignment:"CH"}],integration:1,from:7.89625,to:7.9037500000000005}],nucleus:"1H",solvent:"CD₃OD"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.64,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.63625,to:3.6437500000000003}],nucleus:"1H",solvent:"CD₃OD"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.45,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.44625,to:1.4537499999999999}],nucleus:"1H",solvent:"CD₃OD"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.78,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.7762499999999997,to:3.78375}],nucleus:"1H",solvent:"CD₃OD"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.49,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.48625,to:5.49375}],nucleus:"1H",solvent:"CD₃OD"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.18,assignment:"CH₃"}],integration:6,from:1.15875,to:1.20125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.49,assignment:"CH₂"}],integration:4,from:3.4600000000000004,to:3.52}],nucleus:"1H",solvent:"CD₃OD"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.61,assignment:"CH₂"}],integration:4,from:3.6062499999999997,to:3.61375},{signals:[{js:[],delta:3.58,assignment:"CH₂"}],integration:4,from:3.57625,to:3.58375},{signals:[{js:[],delta:3.35,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.34625,to:3.3537500000000002}],nucleus:"1H",solvent:"CD₃OD"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.97,multiplicity:"s",assignment:"CH"}],integration:1,from:7.96625,to:7.97375},{signals:[{js:[],delta:2.99,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.98625,to:2.9937500000000004},{signals:[{js:[],delta:2.86,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8562499999999997,to:2.86375}],nucleus:"1H",solvent:"CD₃OD"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.66,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.65625,to:3.6637500000000003}],nucleus:"1H",solvent:"CD₃OD"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.35,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.34625,to:3.3537500000000002},{signals:[{js:[],delta:3.52,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.51625,to:3.52375}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.84625,to:.85375}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.19,assignment:"CH₃"}],integration:3,from:1.16875,to:1.21125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.6,assignment:"CH₂"}],integration:2,from:3.5700000000000003,to:3.63}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.01,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.0062499999999996,to:2.01375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.09,assignment:"CH₂CH₃"}],integration:2,from:4.06,to:4.12},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.24,assignment:"CH₂CH₃"}],integration:3,from:1.21875,to:1.26125}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.39,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.3862499999999995,to:5.39375}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.5862499999999997,to:3.59375}],nucleus:"1H",solvent:"CD₃OD"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.86,to:.93,multiplicity:"m"},{signals:[{js:[],delta:1.29,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"CD₃OD"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.19,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.18625,to:2.19375}],nucleus:"1H",solvent:"CD₃OD"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.87875,to:.92125},{signals:[{js:[],delta:1.29,assignment:"CH₂"}],integration:8,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"CD₃OD"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"CD₃OD"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.64,assignment:"CH₃"}],integration:18,from:2.624375,to:2.655625}],nucleus:"1H",solvent:"CD₃OD"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.56,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.5562499999999995,to:4.56375}],nucleus:"1H",solvent:"CD₃OD"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.67,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.66625,to:7.67375},{signals:[{js:[],delta:7.05,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.04625,to:7.05375}],nucleus:"1H",solvent:"CD₃OD"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.2,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.19625,to:.20375000000000001}],nucleus:"1H",solvent:"CD₃OD"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.3362499999999997,to:3.34375}],nucleus:"1H",solvent:"CD₃OD"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.33625,to:4.34375}],nucleus:"1H",solvent:"CD₃OD"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.87875,to:.92125},{signals:[{js:[],delta:1.29,assignment:"CH₂"}],integration:6,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"CD₃OD"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.91,assignment:"CH₃"}],integration:6,from:.888,to:.932},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.34,assignment:"CH₂"}],integration:2,from:1.2815,to:1.3985}],nucleus:"1H",solvent:"CD₃OD"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.5,assignment:"CH₃"}],integration:6,from:1.48875,to:1.51125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.92,assignment:"CH"}],integration:1,from:3.87125,to:3.96875}],nucleus:"1H",solvent:"CD₃OD"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.6844999999999999,to:1.7155},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.91,assignment:"CH₂(1)"}],integration:1,from:4.89375,to:4.9262500000000005},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.01,assignment:"CH₂(2)"}],integration:1,from:4.984999999999999,to:5.035},{signals:[{js:[],delta:5.82,assignment:"CH"}],integration:1,from:5.81625,to:5.82375}],nucleus:"1H",solvent:"CD₃OD"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.53,assignment:"CH(2,6)"}],integration:2,from:8.52625,to:8.53375},{signals:[{js:[],delta:7.44,assignment:"CH(3,5)"}],integration:2,from:7.43625,to:7.4437500000000005},{signals:[{js:[],delta:7.85,assignment:"CH(4)"}],integration:1,from:7.8462499999999995,to:7.85375}],nucleus:"1H",solvent:"CD₃OD"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:6.72,assignment:"CH(2,5)"}],integration:2,from:6.71625,to:6.72375},{signals:[{js:[],delta:6.08,assignment:"CH(3,4)"}],integration:2,from:6.07625,to:6.08375}],nucleus:"1H",solvent:"CD₃OD"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.8,assignment:"CH₂(2,5)"}],integration:4,from:2.7962499999999997,to:2.80375},{signals:[{js:[],delta:1.72,assignment:"CH₂(3,4)"}],integration:4,from:1.71625,to:1.72375}],nucleus:"1H",solvent:"CD₃OD"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.1,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.09625,to:.10375000000000001}],nucleus:"1H",solvent:"CD₃OD"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.71,assignment:"CH₂(2,5)"}],integration:4,from:3.70625,to:3.71375},{signals:[{js:[],delta:1.87,assignment:"CH₂(3,4)"}],integration:4,from:1.8662500000000002,to:1.87375}],nucleus:"1H",solvent:"CD₃OD"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.32,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.3162499999999997,to:2.32375},{signals:[{js:[],delta:7.16,assignment:"CH(2,4,6)"}],integration:3,from:7.15625,to:7.16375},{signals:[{js:[],delta:7.16,assignment:"CH(3,5)"}],integration:2,from:7.15625,to:7.16375}],nucleus:"1H",solvent:"CD₃OD"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.05,assignment:"CH₃"}],integration:6,from:1.02875,to:1.07125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.58,assignment:"CH₂"}],integration:4,from:2.5500000000000003,to:2.61}],nucleus:"1H",solvent:"CD₃OD"},{names:["water"],smiles:"O",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.08,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.07625,to:2.08375}],nucleus:"1H",solvent:"D₂O"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.22,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.21625,to:2.2237500000000003}],nucleus:"1H",solvent:"D₂O"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.06,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.05625,to:2.06375}],nucleus:"1H",solvent:"D₂O"},{names:["benzene"],smiles:"c1ccccc1",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.24,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.23625,to:1.24375}],nucleus:"1H",solvent:"D₂O"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.8,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.7962499999999997,to:3.80375}],nucleus:"1H",solvent:"D₂O"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.17,assignment:"CH₃"}],integration:6,from:1.14875,to:1.19125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.56,assignment:"CH₂"}],integration:4,from:3.5300000000000002,to:3.59}],nucleus:"1H",solvent:"D₂O"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.67,assignment:"CH₂"}],integration:4,from:3.66625,to:3.67375},{signals:[{js:[],delta:3.61,assignment:"CH₂"}],integration:4,from:3.6062499999999997,to:3.61375},{signals:[{js:[],delta:3.37,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.36625,to:3.3737500000000002}],nucleus:"1H",solvent:"D₂O"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.92,multiplicity:"s",assignment:"CH"}],integration:1,from:7.91625,to:7.92375},{signals:[{js:[],delta:3.01,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.0062499999999996,to:3.01375},{signals:[{js:[],delta:2.85,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.84625,to:2.8537500000000002}],nucleus:"1H",solvent:"D₂O"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.75,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.74625,to:3.75375}],nucleus:"1H",solvent:"D₂O"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.37,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.36625,to:3.3737500000000002},{signals:[{js:[],delta:3.6,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.59625,to:3.6037500000000002}],nucleus:"1H",solvent:"D₂O"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.82,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.8162499999999999,to:.82375}],nucleus:"1H",solvent:"D₂O"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.17,assignment:"CH₃"}],integration:3,from:1.14875,to:1.19125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.65,assignment:"CH₂"}],integration:2,from:3.62,to:3.6799999999999997}],nucleus:"1H",solvent:"D₂O"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.07,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.0662499999999997,to:2.07375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.14,assignment:"CH₂CH₃"}],integration:2,from:4.109999999999999,to:4.17},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.24,assignment:"CH₂CH₃"}],integration:3,from:1.21875,to:1.26125}],nucleus:"1H",solvent:"D₂O"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.44,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.43625,to:5.4437500000000005}],nucleus:"1H",solvent:"D₂O"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.65,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.6462499999999998,to:3.65375}],nucleus:"1H",solvent:"D₂O"},{names:["H greaseᶠ"],smiles:"",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.28,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.27625000000000005,to:.28375}],nucleus:"1H",solvent:"D₂O"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.61,assignment:"CH₃"}],integration:18,from:2.594375,to:2.625625}],nucleus:"1H",solvent:"D₂O"},{names:["hydrogen"],smiles:"",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.78,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.77625,to:7.78375},{signals:[{js:[],delta:7.14,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.1362499999999995,to:7.14375}],nucleus:"1H",solvent:"D₂O"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.18,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.17625,to:.18375}],nucleus:"1H",solvent:"D₂O"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.3362499999999997,to:3.34375}],nucleus:"1H",solvent:"D₂O"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.4,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.39625,to:4.4037500000000005}],nucleus:"1H",solvent:"D₂O"},{names:["n-pentane"],smiles:"CCCCC",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.858,to:.902},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.3,assignment:"CH₂"}],integration:2,from:1.2415,to:1.3585}],nucleus:"1H",solvent:"D₂O"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.17,assignment:"CH₃"}],integration:6,from:1.15875,to:1.18125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:4.02,assignment:"CH"}],integration:1,from:3.9712499999999995,to:4.06875}],nucleus:"1H",solvent:"D₂O"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.6844999999999999,to:1.7155},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.95,assignment:"CH₂(1)"}],integration:1,from:4.93375,to:4.9662500000000005},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.06,assignment:"CH₂(2)"}],integration:1,from:5.034999999999999,to:5.085},{signals:[{js:[],delta:5.9,assignment:"CH"}],integration:1,from:5.89625,to:5.9037500000000005}],nucleus:"1H",solvent:"D₂O"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.52,assignment:"CH(2,6)"}],integration:2,from:8.51625,to:8.52375},{signals:[{js:[],delta:7.45,assignment:"CH(3,5)"}],integration:2,from:7.44625,to:7.45375},{signals:[{js:[],delta:7.87,assignment:"CH(4)"}],integration:1,from:7.86625,to:7.87375}],nucleus:"1H",solvent:"D₂O"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:6.93,assignment:"CH(2,5)"}],integration:2,from:6.92625,to:6.93375},{signals:[{js:[],delta:6.26,assignment:"CH(3,4)"}],integration:2,from:6.25625,to:6.26375}],nucleus:"1H",solvent:"D₂O"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:3.07,assignment:"CH₂(2,5)"}],integration:4,from:3.0662499999999997,to:3.07375},{signals:[{js:[],delta:1.87,assignment:"CH₂(3,4)"}],integration:4,from:1.8662500000000002,to:1.87375}],nucleus:"1H",solvent:"D₂O"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.74,assignment:"CH₂(2,5)"}],integration:4,from:3.73625,to:3.7437500000000004},{signals:[{js:[],delta:1.88,assignment:"CH₂(3,4)"}],integration:4,from:1.87625,to:1.8837499999999998}],nucleus:"1H",solvent:"D₂O"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.99,assignment:"CH₃"}],integration:6,from:.96875,to:1.01125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.57,assignment:"CH₂"}],integration:4,from:2.54,to:2.5999999999999996}],nucleus:"1H",solvent:"D₂O"}];function getShortestPath(t){let{currUnAssCol:e,dualVariableForColumns:n,dualVariableForRows:s,rowAssignments:i,columnAssignments:o,matrix:a}=t,l=a.rows,r=a.columns,m=new Float64Array(l),g=new Float64Array(r),u=new Float64Array(l),c=Array.from(xSequentialFill({from:0,to:l-1})),C=l,f=-1,h=0,p=e,d=new Array(l).fill(Number.POSITIVE_INFINITY);for(;-1===f;){g[p]=1;let t=Number.POSITIVE_INFINITY,e=-1;for(let i=0;i<C;i++){let o=c[i],l=h+a.get(o,p)-n[p]-s[o];l<d[o]&&(m[o]=p,d[o]=l),d[o]<t&&(t=d[o],e=i)}if(!Number.isFinite(t))return{dualVariableForColumns:n,dualVariableForRows:s,sink:f,pred:m};let o=c[e];u[o]=1,C-=1,c.splice(e,1),h=d[o],-1===i[o]?f=o:p=i[o]}n[e]+=h;for(let t=0;t<r;t++)0!==g[t]&&t!==e&&(n[t]+=h-d[o[t]]);for(let t=0;t<l;t++)0!==u[t]&&(s[t]-=h-d[t]);return{sink:f,pred:m,dualVariableForColumns:n,dualVariableForRows:s}}function linearSumAssignment(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{maximaze:n=!0}=e;let s=Matrix.checkMatrix(t),i=!1;s.columns>s.rows&&(i=!0,s=s.transpose());let o=s.rows,a=s.columns,l=n?s.max():s.min();s=s.subtract(l),n&&(s=s.mul(-1));let r=new Float64Array(o).fill(-1),m=new Float64Array(a).fill(-1),g=new Float64Array(a),u=new Float64Array(o);for(let t=0;t<a;t++){let e=getShortestPath({matrix:s,currUnAssCol:t,dualVariableForColumns:g,dualVariableForRows:u,rowAssignments:r,columnAssignments:m}),{sink:n,pred:i}=e;if(-1===n)return{rowAssignments:r,columnAssignments:m,gain:-1,dualVariableForColumns:g,dualVariableForRows:u};g=e.dualVariableForColumns,u=e.dualVariableForRows;let o=n;for(let e=i[o];;e=i[o]){r[o]=e;let n=m[e];if(m[e]=o,o=n,e===t)break}}let c=0;for(let t=0;t<a;t++)c+=s.get(m[t],t);return c=(n?-1:1)*c+l*a,i&&([m,r]=[r,m],[g,u]=[u,g]),{rowAssignments:r,columnAssignments:m,gain:c,dualVariableForColumns:g,dualVariableForRows:u}}const{stringify:stringify,parse:parse}=JSON;function cloneArray(t){return parse(stringify(t))}function solventSuppression(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const s=cloneArray(t).sort(((t,e)=>t.x-e.x)),i=s.map((t=>t.x)),{markSolventPeaks:o=!1,solventZoneExtension:a=1.2}=n;for(const t of e){let e=t.peaks?t.peaks:getSolventPeaks(t);e.sort(((t,e)=>t.x-e.x));let n=xFindClosestIndex(i,e[e.length-1].x+a),l=xFindClosestIndex(i,e[0].x-a);const r=s.filter(((t,e)=>e>=l&&e<=n)),m=[],g=[],u=[];for(let n of r){const{peaks:s,delta:i}=getShiftedSolventPeaks(n,t,e),o=getClosestPeaks(s,r);let a=0,l=0,c=0;for(let t=0;t<o.length;t++)l+=Math.abs(s[t].y-o[t].y),a+=Math.abs(s[t].x-o[t].x);0===o.length?(a=Number.MAX_SAFE_INTEGER,l=Number.MAX_SAFE_INTEGER,c=Number.MAX_SAFE_INTEGER):c=gaussianFct(Math.abs(t.delta-i),.5),m.push(l),g.push(a),u.push(c)}const[c,C,f]=[m,g,u].map((t=>{const e=xMaxValue(t);return 0===e?1:e}));let h=-1,p=Number.MAX_SAFE_INTEGER;for(let t=0;t<g.length;t++){const e=(m[t]/c+g[t]/C+1-u[t]/f)/3;p>e&&(h=t,p=e)}if(p<0||h<0)return s;const{peaks:d}=getShiftedSolventPeaks(r[h],t,e),y=getDiffMatrix(d,r),{rowAssignments:H,gain:v}=linearSumAssignment(y,{maximaze:!1});if(v<0)return s;if(o)for(let t of H)s[t+l].kind="solvent";else{H.sort(((t,e)=>e-t));for(let t of H)s.splice(t+l,1)}}return s}function getSolventPeaks(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=signalsToSpinSystem(addDummySignals([t]));const{frequency:s=400,maxClusterSize:i=8}=e;n.clusters=splitSpinSystem(n,{frequency:s,maxClusterSize:i});return simulateXYPeaks(n).filter((t=>t.x<1e3))}function getShiftedSolventPeaks(t,e,n){const s=JSON.parse(JSON.stringify(n));let i=t.x-e.delta;n.length>1&&n.length%2==0&&(i+=n[0].x);const o=s.reduce(((t,e)=>e.y>t?e.y:t),s[0].y);let a=0;for(let t of s)t.x+=i,t.y/=o,a+=t.x;return{peaks:s,delta:a/s.length}}function getClosestPeaks(t,e){const n=getDiffMatrix(t,e),{rowAssignments:s,gain:i}=linearSumAssignment(n,{maximaze:!1});if(-1===i)return[];const o=[];let a=Number.MIN_SAFE_INTEGER;for(let t of s)a<e[t].y&&(a=e[t].y),o.push({...e[t]});return o.forEach(((t,e,n)=>n[e].y/=a)),o}function getDiffMatrix(t,e){const n=e.length,s=t.length,i=new Matrix(s,n);for(let o=0;o<s;o++)for(let s=0;s<n;s++)i.set(o,s,Math.abs(t[o].x-e[s].x));return i}function markSolventPeaks(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{frequency:s=400}=n,i=addIDs(cloneArray(t));let o=[];for(const t of i){const e=t.id;for(const n of t.signals||[]){const t=n.id;for(let s of n.peaks||[])o.push({...s,rangeID:e,signalID:t})}}const a=solventSuppression(o,e,{markSolventPeaks:!0}),l=getSignalIDsWithSolvent(a);for(let t of i)if(t.signals)for(let e of t.signals){if(!l.includes(e.id))continue;const n=[],i=[];for(let t of a)if(t.signalID===e.id){const{signalID:e,rangeID:s,...o}=t;"solvent"===t.kind?i.push(o):n.push(o)}const o=n.length>0?detectSignals({x:[],y:[]},n,{integralType:"peak",frequency:s}):[];i.sort(((t,e)=>t.x-e.x));const r=i[0].x,m=detectSignals({x:[],y:[]},i,{integralType:"peak",frequencyCluster:(i[i.length-1].x-r)*s,frequency:s});t.signals=[...adaptSignals(o),...adaptSignals(m),...t.signals.filter((t=>t.id!==e.id))]}return i}function getSignalIDsWithSolvent(t){const e=new Set;for(let n of t)"solvent"===n.kind&&e.add(n.signalID);return Array.from(e)}function adaptSignals(t){const e=[];for(let n of t){const t={id:v4(),delta:n.delta,kind:n.kind||"signal",multiplicity:n.multiplicity,integration:n.integralData.value};t.peaks=n.peaks.map((t=>{const e={y:t.intensity,...t};return delete e.intensity,e})),t.js=n.nmrJs||[],e.push(t)}return e}function findMultiplet(t){return MultiplicityPatterns.find((e=>{const{label:n,value:s,names:i}=e;return[n,s,...i].includes(t)}))}function checkMultiplet(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];const n=findMultiplet(t);return n&&!e.includes(n.label)&&!e.includes(n.value)&&!n.names.some((t=>e.includes(t)))}function checkMultiplicity(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];if(void 0===t||0===t.length)return!1;const n=splitPatterns(t);return n.join("").length===t.length&&n.every((t=>checkMultiplet(t,e)))}function translateMultiplet(t){const e=findMultiplet(t);if(!e)throw new Error(`multiplet ${t} is not supported`);const{value:n,label:s}=e;return t===s?n:s}function apodizationFilter(t,e){const{lineBroadening:n,gaussBroadening:s,lineBroadeningCenter:i}=e,o=t.info?.digitalFilter||0,a=o>0?Math.floor(o):0,l=t.data.re,r=t.data.im,m=t.data.x,g=l.length;return apodization$1({re:l,im:r},{pointsToShift:a,compose:{length:g,shapes:[{start:0,shape:{kind:"lorentzToGauss",options:{length:g,dw:(m[g-1]-m[0])/(g-1),exponentialHz:s>0?n:-n,gaussianHz:s,center:i}}}]}})}const id$b="apodization",name$b="Apodization",DOMAIN_UPDATE_RULES$b={updateXDomain:!0,updateYDomain:!1};function apply$d(t,e){if(!isApplicable$b(t))throw new Error("apodization not applicable on this data");const n=apodizationFilter(t,e);t.data={...t.data,re:n.re,im:n.im}}function isApplicable$b(t){return!(!t.info.isComplex||!t.info.isFid)}function reduce$b(t,e){return{once:!0,reduce:e}}var apodization=Object.freeze({__proto__:null,id:id$b,name:name$b,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$b,apply:apply$d,isApplicable:isApplicable$b,reduce:reduce$b});function ldlSymbolic(t,e,n,s,i,o,a){let l,r,m,g,u;for(r=0;r<t;r++)for(i[r]=-1,a[r]=r,o[r]=0,g=r,u=e[g+1],m=e[g];m<u;m++)if(l=n[m],l<r)for(;a[l]!==r;l=i[l])-1===i[l]&&(i[l]=r),o[l]++,a[l]=r;for(s[0]=0,r=0;r<t;r++)s[r+1]=s[r]+o[r]}function ldlNumeric(t,e,n,s,i,o,a,l,r,m,g,u,c){let C,f,h,p,d,y,H,v,b;for(p=0;p<t;p++){for(g[p]=0,b=t,c[p]=p,a[p]=0,y=p,H=e[y+1],d=e[y];d<H;d++)if(h=n[d],h<=p){for(g[h]+=s[d],v=0;c[h]!==p;h=o[h])u[v++]=h,c[h]=p;for(;v>0;)u[--b]=u[--v]}for(m[p]=g[p],g[p]=0;b<t;b++){for(h=u[b],C=g[h],g[h]=0,H=i[h]+a[h],d=i[h];d<H;d++)g[l[d]]-=r[d]*C;f=C/m[h],m[p]-=f*C,l[d]=p,r[d]=f,a[h]++}if(0===m[p])return p}return t}function ldlLsolve(t,e,n,s,i){let o,a,l;for(o=0;o<t;o++)for(l=n[o+1],a=n[o];a<l;a++)e[s[a]]-=i[a]*e[o]}function ldlDsolve(t,e,n){let s;for(s=0;s<t;s++)e[s]/=n[s]}function ldlLTsolve(t,e,n,s,i){let o,a,l;for(o=t-1;o>=0;o--)for(l=n[o+1],a=n[o];a<l;a++)e[o]-=i[a]*e[s[a]]}function ldlPerm(t,e,n,s){let i;for(i=0;i<t;i++)e[i]=n[s[i]]}function ldlPermt(t,e,n,s){let i;for(i=0;i<t;i++)e[s[i]]=n[i]}function prepare(t,e,n){if(n){let s=new Array(e);for(let t=0;t<e;t++)s[n[t]]=t;let i=[];for(let e=0;e<t.length;++e){let n=s[t[e][0]],o=s[t[e][1]];if(o<n){let t=o;o=n,n=t}i[e]=[],i[e][0]=n,i[e][1]=o,i[e][2]=t[e][2]}t=i}else{n=[];for(let t=0;t<e;++t)n[t]=t}let s=new Array(e+1),i=new Array(t.length),o=new Array(t.length),a=[];for(let t=0;t<e;++t)a[t]=0;for(let e=0;e<t.length;++e)a[t[e][1]]++;s[0]=0;for(let t=0;t<e;++t)s[t+1]=s[t]+a[t];let l=[];for(let t=0;t<e;++t)l[t]=0;for(let e=0;e<t.length;++e){let n=t[e],a=n[1],r=s[a]+l[a];i[r]=n[0],o[r]=n[2],l[a]++}let r,m=new Array(e),g=new Array(e),u=new Array(e+1),c=new Array(e),C=new Array(e),f=new Array(e),h=new Array(e),p=new Array(e),d=new Array(e);ldlSymbolic(e,s,i,u,c,C,f);let y=new Array(u[e]),H=new Array(u[e]);return r=ldlNumeric(e,s,i,o,u,c,C,H,y,m,g,h,f),r===e?t=>(ldlPerm(e,p,t,n),ldlLsolve(e,p,u,H,y),ldlDsolve(e,p,m),ldlLTsolve(e,p,u,H,y),ldlPermt(e,d,p,n),d):null}var cuthillMckee_1=cuthillMckee;function compareNum(t,e){return t-e}function cuthillMckee(t,e){for(var n=new Array(e),s=new Array(e),i=0;i<e;++i)n[i]=[],s[i]=!1;for(i=0;i<t.length;++i){var o=t[i];n[o[0]].push(o[1])}var a=new Array(e),l=0,r=0;for(i=0;i<e;++i)if(!s[i])for(a[l++]=i,s[i]=!0;r<l;){var m=n[a[r++]];m.sort(compareNum);for(var g=0;g<m.length;++g){var u=m[g];s[u]||(s[u]=!0,a[l++]=u)}}var c=new Array(e);for(i=0;i<e;++i)c[a[i]]=i;return c}var cuthillMckee$1=cuthillMckee_1;const getClosestNumber=function(){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return(arguments.length>0&&void 0!==arguments[0]?arguments[0]:[]).reduce(((e,n)=>Math.abs(n-t)<Math.abs(e-t)?n:e))},getCloseIndex=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[];const e=getClosestNumber(t,arguments.length>1&&void 0!==arguments[1]?arguments[1]:0);return t.indexOf(e)},updateSystem=(t,e,n)=>{let s=e.length,i=s-1,o=new Array(t.length),a=new Float64Array(s);for(let s=0;s<i;s++){let i=n[s],l=2*s,r=l+1;o[l]=t[l].slice(),o[r]=t[r].slice(),0===i?a[s]=0:(a[s]=e[s]*i,o[l][2]+=i)}return a[i]=e[i]*n[i],o[2*i]=t[2*i].slice(),o[2*i][2]+=n[i],[o,a]},getDeltaMatrix=(t,e)=>{let n=[],s=t-1;for(let t=0;t<s;t++)n.push([t,t,2*e]),n.push([t+1,t,-1*e]);return n[0][2]=e,n.push([s,s,e]),{lowerTriangularNonZeros:n,permutationEncodedArray:cuthillMckee$1(n,t)}};function airPLS(t,e){let n,s,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{maxIterations:o=100,lambda:a=100,factorCriterion:l=.001,weights:r=new Array(e.length).fill(1),controlPoints:m=[],baseLineZones:g=[]}=i;m.length>0&&m.forEach(((e,n,s)=>s[n]=getCloseIndex(t,e))),g.length>0&&g.forEach((e=>{let n=getCloseIndex(t,e.from),s=getCloseIndex(t,e.to);n>s&&([n,s]=[s,n]);for(let t=n;t<s;t++)m.push(t)}));let u=e.length,c=u-1,C=Number.MAX_SAFE_INTEGER,f=l*e.reduce(((t,e)=>Math.abs(e)+t),0),{lowerTriangularNonZeros:h,permutationEncodedArray:p}=getDeltaMatrix(u,a);for(s=0;s<o&&Math.abs(C)>f;s++){let[t,i]=updateSystem(h,e,r),o=prepare(t,u,p);n=o(i),C=0;let a=e.map(d),l=-1*Number.MAX_SAFE_INTEGER;for(let t=1;t<c;t++){let e=a[t];e>=0?r[t]=0:(r[t]=Math.exp(s*e/C),l<e&&(l=e))}let g=Math.exp(s*l/C);r[0]=g,r[c]=g,m.forEach((t=>r[t]=g))}return{corrected:e.map(((t,e)=>t-n[e])),baseline:n,iteration:s,error:C};function d(t,e){let s=t-n[e];return s<0&&(C+=s),s}}function maybeToPrecision(t,e){return t<0?(t=0-t,"number"==typeof e?`- ${t.toPrecision(e)}`:`- ${t.toString()}`):"number"==typeof e?t.toPrecision(e):t.toString()}function checkArraySize(t,e){if(!isAnyArray(t)||!isAnyArray(e))throw new TypeError("x and y must be arrays");if(t.length!==e.length)throw new RangeError("x and y arrays must have the same length")}class BaseRegression{constructor(){if(new.target===BaseRegression)throw new Error("BaseRegression must be subclassed")}predict(t){if("number"==typeof t)return this._predict(t);if(isAnyArray(t)){const e=[];for(let n=0;n<t.length;n++)e.push(this._predict(t[n]));return e}throw new TypeError("x must be a number or array")}_predict(){throw new Error("_predict must be implemented")}train(){}toString(){return""}toLaTeX(){return""}score(t,e){if(!isAnyArray(t)||!isAnyArray(e)||t.length!==e.length)throw new Error("x and y must be arrays of the same length");const n=t.length,s=new Array(n);for(let e=0;e<n;e++)s[e]=this._predict(t[e]);let i=0,o=0,a=0,l=0,r=0,m=0,g=0;for(let t=0;t<n;t++)i+=s[t],o+=e[t],r+=s[t]*s[t],m+=e[t]*e[t],g+=s[t]*e[t],0!==e[t]&&(a+=(e[t]-s[t])*(e[t]-s[t])/e[t]),l+=(e[t]-s[t])*(e[t]-s[t]);const u=(n*g-i*o)/Math.sqrt((n*r-i*i)*(n*m-o*o));return{r:u,r2:u*u,chi2:a,rmsd:Math.sqrt(l/n)}}}class PolynomialRegression extends BaseRegression{constructor(t,e,n){super(),!0===t?(this.degree=e.degree,this.powers=e.powers,this.coefficients=e.coefficients):(checkArraySize(t,e),regress(this,t,e,n))}_predict(t){let e=0;for(let n=0;n<this.powers.length;n++)e+=this.coefficients[n]*Math.pow(t,this.powers[n]);return e}toJSON(){return{name:"polynomialRegression",degree:this.degree,powers:this.powers,coefficients:this.coefficients}}toString(t){return this._toFormula(t,!1)}toLaTeX(t){return this._toFormula(t,!0)}_toFormula(t,e){let n="^",s="",i=" * ";e&&(n="^{",s="}",i="");let o="",a="";for(let e=0;e<this.coefficients.length;e++)a="",0!==this.coefficients[e]&&(a=0===this.powers[e]?maybeToPrecision(this.coefficients[e],t):1===this.powers[e]?`${maybeToPrecision(this.coefficients[e],t)+i}x`:`${maybeToPrecision(this.coefficients[e],t)+i}x${n}${this.powers[e]}${s}`,this.coefficients[e]>0&&e!==this.coefficients.length-1?a=` + ${a}`:e!==this.coefficients.length-1&&(a=` ${a}`)),o=a+o;return"+"===o.charAt(0)&&(o=o.slice(1)),`f(x) = ${o}`}static load(t){if("polynomialRegression"!==t.name)throw new TypeError("not a polynomial regression model");return new PolynomialRegression(!0,t)}}function regress(t,e,n,s){const i=e.length;let o;if(Array.isArray(s))o=s,s=o.length;else{s++,o=new Array(s);for(let t=0;t<s;t++)o[t]=t}const a=new Matrix(i,s),l=new Matrix([n]);for(let t=0;t<s;t++)for(let n=0;n<i;n++)0===o[t]?a.set(n,t,1):a.set(n,t,Math.pow(e[n],o[t]));const r=new MatrixTransposeView(a),m=r.mmul(a),g=r.mmul(new MatrixTransposeView(l));t.degree=s-1,t.powers=o,t.coefficients=solve(m,g).to1DArray()}function baselineCorrectionRegression(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{maxIterations:s=100,Regression:i=PolynomialRegression,regressionOptions:o,tolerance:a=.001}=n;o||i!==PolynomialRegression||(o=3);let l,r,m=e.slice(),g=e.slice(),u=e,c=0;for(;c<s;){r=new i(t,m,o),l=0;for(let e=0;e<m.length;e++)g[e]=r.predict(t[e]),m[e]>g[e]&&(m[e]=g[e]),l+=Math.abs((g[e]-u[e])/u[e]);if(l<a)break;u=g.slice(),c++}let C=new Array(m.length);for(let t=0;t<m.length;t++)C[t]=e[t]-m[t];return{corrected:C,delta:l,iteration:c,baseline:m,regression:r}}const id$a="baselineCorrection",name$a="Baseline correction",DOMAIN_UPDATE_RULES$a={updateXDomain:!1,updateYDomain:!0};function apply$c(t,e){if(!isApplicable$a(t))throw new Error("baselineCorrection not applicable on this data");const{algorithm:n}=e;let s,{x:i,re:o}=t.data;switch(n){case"airpls":s=airPLS(i,o,e).corrected;break;case"polynomial":{const{degree:t,zones:n}=e;let a=xyEquallySpaced({x:i,y:o},{numberOfPoints:4096,zones:n}),l=baselineCorrectionRegression(a.x,a.y,{regressionOptions:t}),{regression:r}=l;s=new Float64Array(i.length);for(let t=0;t<o.length;t++)s[t]=o[t]-r.predict(i[t])}break;default:throw new Error(`baselineCorrection: algorithm unknown: ${n}`)}Object.assign(t.data,{re:s})}function isApplicable$a(t){return!t.info.isFid}function reduce$a(t,e){return{once:!0,reduce:e}}var baselineCorrection=Object.freeze({__proto__:null,id:id$a,name:name$a,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$a,apply:apply$c,isApplicable:isApplicable$a,reduce:reduce$a});const id$9="digitalFilter",name$9="Digital Filter",DOMAIN_UPDATE_RULES$9={updateXDomain:!0,updateYDomain:!0};function apply$b(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isApplicable$9(t))throw new Error("Digital Filter is not applicable on this data");let{digitalFilterValue:n}=e;if(!n){n=t.info.digitalFilter||0;const e=t.filters.find((t=>t.name===id$9));e&&(e.value={digitalFilterValue:n})}let s=new Float64Array(t.data.re),i=new Float64Array(t.data.im),o=Math.floor(n);o+=0;const a=new Float64Array(s.length),l=new Float64Array(i.length);a.set(s.slice(o)),a.set(s.slice(0,o),s.length-o),l.set(i.slice(o)),l.set(i.slice(0,o),i.length-o),t.data.re=a,t.data.im=l}function isApplicable$9(t){return!(!t.info.isComplex||!t.info.isFid)}function reduce$9(){return{once:!0,reduce:void 0}}var digitalFilter=Object.freeze({__proto__:null,id:id$9,name:name$9,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$9,apply:apply$b,isApplicable:isApplicable$9,reduce:reduce$9});const id$8="equallySpaced",name$8="Equally spaced",DOMAIN_UPDATE_RULES$8={updateXDomain:!1,updateYDomain:!1};function apply$a(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isApplicable$8(t))throw new Error("Equally Spaced is not applicable on this data");const{from:n,to:s,numberOfPoints:i,exclusions:o}=e,{x:a,re:l,im:r}=t.data,m=xyEquallySpaced({x:a,y:l},{from:n,to:s,numberOfPoints:i,exclusions:o});if(t.data.x=xEnsureFloat64(m.x),t.data.re=xEnsureFloat64(m.y),r){const e=xyEquallySpaced({x:a,y:l},{from:n,to:s,numberOfPoints:i,exclusions:o});t.data.im=xEnsureFloat64(e.y)}}function isApplicable$8(t){return!(!t.info.isComplex||t.info.isFid)}function reduce$8(){return{once:!1,reduce:null}}var equallySpaced$1=Object.freeze({__proto__:null,id:id$8,name:name$8,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$8,apply:apply$a,isApplicable:isApplicable$8,reduce:reduce$8});const id$7="exclusionZones",name$7="Exclusion zones",DOMAIN_UPDATE_RULES$7={updateXDomain:!1,updateYDomain:!1};function apply$9(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];if(!isApplicable$7(t))throw new Error("Exclusion Zones filter not applicable on this data");const{x:n,re:s,im:i}=t.data;t.data.re=Float64Array.from(xySetYValue({x:n,y:s},{zones:e}).y),t.data.im=i?Float64Array.from(xySetYValue({x:n,y:s},{zones:e}).y):i}function isApplicable$7(t){return!!t.info.isFt}function reduce$7(t,e){return{once:!0,reduce:zonesNormalize(t.concat(e))}}var exclusionZones=Object.freeze({__proto__:null,id:id$7,name:name$7,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$7,apply:apply$9,isApplicable:isApplicable$7,reduce:reduce$7});function padDataToNextPowerOfTwo(t,e){const{x:n,re:s,im:i}=t.data,o=nextPowerOfTwo(n.length);let a=new Float64Array(o),l=new Float64Array(o);const r=t.info?.digitalFilter||0,m=r>0?Math.floor(r):0;a.set(s.slice(0,o-m)),l.set(i.slice(0,o-m)),m>0&&e&&(a.set(s.slice(s.length-m),o-m),l.set(i.slice(s.length-m),o-m));const g=xSequentialFill({from:n[0],size:o,step:n[1]-n[0]});t.data={...t.data,re:a,im:l,x:g}}function nextPowerOfTwo(t){return 0===t?1:(t--,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,(t|=t>>16)+1)}const id$6="fft",name$6="FFT",DOMAIN_UPDATE_RULES$6={updateXDomain:!0,updateYDomain:!0};function apply$8(t){if(!isApplicable$6(t))throw new Error("fft not applicable on this data");checkSameLength(t);let e=t.filters.some((t=>"digitalFilter"===t.name&&t.flag));const{info:{aqMod:n}}=t;1===n&&removeDCOffset(t,e),isPowerOfTwo(t.data.x.length)||padDataToNextPowerOfTwo(t,e);const{data:s,info:i}=t;if(Object.assign(s,reimFFT({re:s.re,im:s.im},{applyZeroShift:!0})),e){let{digitalFilter:t=0}=i,e=(t-Math.floor(t))*Math.PI*2;Object.assign(s,reimPhaseCorrection(s,0,-e,{reverse:!0}))}t.data.x=generateXAxis(t),t.info={...t.info,isFid:!1,isFt:!0}}function isApplicable$6(t){return!(!t.info.isComplex||!t.info.isFid)}function reduce$6(){return{once:!0,reduce:void 0}}function generateXAxis(t){const e=t.info,n=Number(e.baseFrequency),s=Number(e.frequencyOffset),i=Number(e.spectralWidth),o=s/n;let a=.5*i,l=t.data.x.length,r=o-a,m=i/(l-1);const g=new Float64Array(l);for(let t=0;t<l;t++)g[t]=r,r+=m;return g}function isPowerOfTwo(t){return 0!==t&&0==(t&t-1)}function removeDCOffset(t,e){let{digitalFilter:n=0}=e&&t.info?t.info:{};const s=t.data,i=s.re.length,o=new Float64Array(s.re),a=new Float64Array(s.im),l=xMean(s.re.slice(.75*i>>0,i-n)),r=xMean(s.im.slice(.75*i>>0,i-n));for(let t=e?0:n;t<i-n;t++)o[t]-=l,a[t]-=r;return Object.assign(t.data,{re:o,im:a}),t}function checkSameLength(t){const{data:e}=t;if(e.x.length!==e.re.length||e.x.length!==e.im.length)throw new Error("The length of data should be equal")}var fft=Object.freeze({__proto__:null,id:id$6,name:name$6,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$6,apply:apply$8,isApplicable:isApplicable$6,reduce:reduce$6});const id$5="phaseCorrection",name$5="Phase correction",DOMAIN_UPDATE_RULES$5={updateXDomain:!1,updateYDomain:!1};function apply$7(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isApplicable$5(t))throw new Error("phaseCorrection not applicable on this data");const{absolute:n=!1}=e,s=t.filters?.find((t=>t.name===id$5));if(n){const{re:e,im:i}=t.data;t.data.re=reimAbsolute({re:e,im:i}),t.data.im=new Float64Array(0),s&&(s.value={...s.value,ph0:0,ph1:0,absolute:n})}else if("ph0"in e&&"ph1"in e){let{ph0:i,ph1:o}=e;phaseCorrection(t,{ph0:i,ph1:o}),s&&(s.value={...s.value,absolute:n})}else{let{ph0:e,ph1:i}=autoPhaseCorrection(t);phaseCorrection(t,{ph0:e,ph1:i}),s&&(s.value={...s.value,absolute:n,ph0:e,ph1:i})}}function phaseCorrection(t,e){let{ph0:n,ph1:s}=e;const{re:i,im:o}=t.data,a=reimPhaseCorrection({re:i,im:o},n*Math.PI/180,s*Math.PI/180,{reverse:!0});t.data={...t.data,re:xEnsureFloat64(a.re),im:xEnsureFloat64(a.im)}}function autoPhaseCorrection(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{minRegSize:n=5,maxDistanceToJoin:s=128,magnitudeMode:i=!0,factorNoise:o=5,reverse:a=!0}=e;return reimAutoPhaseCorrection(t.data,{minRegSize:n,maxDistanceToJoin:s,magnitudeMode:i,factorNoise:o,reverse:a})}function isApplicable$5(t){return!(!t.info.isComplex||t.info.isFid)}function reduce$5(t,e){return{once:!0,reduce:e}}var phaseCorrection$1=Object.freeze({__proto__:null,id:id$5,name:name$5,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$5,apply:apply$7,isApplicable:isApplicable$5,reduce:reduce$5});const id$4="shiftX",name$4="Shift X",DOMAIN_UPDATE_RULES$4={updateXDomain:!0,updateYDomain:!1};function apply$6(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{shift:n=0}=e;t.data.x=t.data.x.map((t=>t+n))}function isApplicable$4(){return!0}function reduce$4(t,e){const{shift:n=0}=t,{shift:s=0}=e;return{once:!0,reduce:{shift:n+s}}}var shiftX=Object.freeze({__proto__:null,id:id$4,name:name$4,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$4,apply:apply$6,isApplicable:isApplicable$4,reduce:reduce$4});function centerMean(t){const{y:e}=t,n=xMean(e);for(let t=0;t<e.length;t++)e[t]-=n;return{data:t}}function centerMedian(t){const{y:e}=t,n=xMedian(e);for(let t=0;t<e.length;t++)e[t]-=n;return{data:t}}function fromTo(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{fromIndex:n,toIndex:s}=xGetFromToIndex(t.x,e);return{data:{x:t.x.subarray(n,s+1),y:t.y.subarray(n,s+1)}}}function normed(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return xNormed(t.y,{...e,output:t.y}),{data:t}}function divideBySD(t){const{y:e}=t,n=xStandardDeviation(e);for(let t=0;t<e.length;t++)e[t]/=n;return{data:t}}function rescale(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return xRescale(t.y,{...e,output:t.y}),{data:t}}function paretoNormalization(t){return{data:{x:t.x,y:xParetoNormalization(t.y)}}}function _typeof(t){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},_typeof(t)}function sequentialFill(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"!==_typeof(t)||isAnyArray(t)||(e=t,t=[]),!isAnyArray(t))throw new TypeError("input must be an array");var n=e,s=n.from,i=void 0===s?0:s,o=n.to,a=void 0===o?10:o,l=n.size,r=void 0===l?t.length:l,m=n.step;if(0!==r&&m)throw new Error("step is defined by the array size");if(r||(r=m?Math.floor((a-i)/m)+1:a-i+1),!m&&r&&(m=(a-i)/(r-1)),Array.isArray(t)){t.length=0;for(var g=0;g<r;g++)t.push(i),i+=m}else{if(t.length!==r)throw new Error("sequentialFill typed array must have the correct length");for(var u=0;u<r;u++)t[u]=i,i+=m}return t}function airPLSBaseline$1(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const n=t.length;let{x:s,regressionOptions:i}=e;s||(s=sequentialFill({from:0,to:n-1,size:n}));let o=airPLS(s,t,i);return{baseline:o.baseline,correctedSpectrum:o.corrected}}function iterativePolynomialBaseline$1(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const n=t.length;let{x:s,regressionOptions:i}=e;s||(s=sequentialFill({from:0,to:n-1,size:n}));let o=baselineCorrectionRegression(s,t,i);return{baseline:o.baseline,correctedSpectrum:o.corrected}}function rollingAverageBaseline$1(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=Math.max(Math.round(.1*t.length),2),s=xRollingAverage(t,{...{window:n,padding:{size:n-1,algorithm:"duplicate",value:0}},...e}),i=new Float64Array(t.length);for(let e=0;e<i.length;e++)i[e]=t[e]-s[e];return{baseline:s,correctedSpectrum:i}}function rollingBall(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new Error("Spectrum must be an array");if(0===t.length)throw new TypeError("Spectrum must not be empty");const n=t.length,s=new Float64Array(n),i=new Float64Array(n),o=new Float64Array(n),{windowM:a=Math.round(.04*n),windowS:l=Math.round(.08*n)}=e;for(let e=0;e<t.length;e++){let n=Math.max(0,e-a),s=Math.min(e+a+1,t.length);i[e]=xMinValue(t,{fromIndex:n,toIndex:s})}for(let t=0;t<i.length;t++){let e=Math.max(0,t-a),n=Math.min(t+a+1,i.length);s[t]=xMaxValue(i,{fromIndex:e,toIndex:n})}for(let t=0;t<i.length;t++){let e=Math.max(0,t-l),n=Math.min(t+l+1,s.length);o[t]=xMean(s.subarray(e,n))}return o}function rollingBallBaseline$1(t){const e=rollingBall(t,arguments.length>1&&void 0!==arguments[1]?arguments[1]:{});let n=new Float64Array(t.length);for(let s=0;s<n.length;s++)n[s]=t[s]-e[s];return{baseline:e,correctedSpectrum:n}}function rollingMedianBaseline$1(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=Math.max(Math.round(.1*t.length),2),s=xRollingMedian(t,{...{window:n,padding:{size:n-1,algorithm:"duplicate",value:0}},...e}),i=new Float64Array(t.length);for(let e=0;e<i.length;e++)i[e]=t[e]-s[e];return{baseline:s,correctedSpectrum:i}}function airPLSBaseline(t){return t.y=airPLSBaseline$1(t.y).correctedSpectrum,{data:t}}function iterativePolynomialBaseline(t){return t.y=iterativePolynomialBaseline$1(t.y).correctedSpectrum,{data:t}}function rollingAverageBaseline(t){return t.y=rollingAverageBaseline$1(t.y).correctedSpectrum,{data:t}}function rollingBallBaseline(t){return t.y=rollingBallBaseline$1(t.y).correctedSpectrum,{data:t}}function rollingMedianBaseline(t){return t.y=rollingMedianBaseline$1(t.y).correctedSpectrum,{data:t}}function firstDerivative(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{x:n,y:s}=t;return{data:{x:n,y:sgg(s,n,{...e,derivative:1})}}}function secondDerivative(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{x:n,y:s}=t;return{data:{x:n,y:sgg(s,n,{...e,derivative:2})}}}function thirdDerivative(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{x:n,y:s}=t;return{data:{x:n,y:sgg(s,n,{...e,derivative:3})}}}function savitzkyGolay(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{x:n,y:s}=t;return{data:{x:n,y:sgg(s,n,e)}}}function ensureGrowing(t){return{data:xyEnsureGrowingX(t)}}function equallySpaced(t){return{data:xyEquallySpaced(t,arguments.length>1&&void 0!==arguments[1]?arguments[1]:{})}}function filterX(t){return{data:xyFilterX(t,arguments.length>1&&void 0!==arguments[1]?arguments[1]:{})}}function calibrateX(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{targetX:n=0,nbPeaks:s=1,from:i=t.x[0],to:o=t.x[t.x.length-1],gsd:a={minMaxRatio:.1,realTopDetection:!0,smoothY:!0,sgOptions:{windowSize:7,polynomial:3}}}=e,l=xFindClosestIndex(t.x,i),r=xFindClosestIndex(t.x,o);let m=gsd({x:t.x.subarray(l,r),y:t.y.subarray(l,r)},a).sort(((t,e)=>e.y-t.y)).slice(0,s);if(m.length<s)return{data:t};const g=xMean(m.map((t=>t.x)));return{data:{x:xAdd(t.x,n-g),y:t.y}}}function xFunction(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return{data:{x:xApplyFunctionStr(t.x,{variableLabel:"x",fctString:e.function}),y:t.y}}}function yFunction(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return{data:{x:t.x,y:xApplyFunctionStr(t.y,{variableLabel:"y",fctString:e.function})}}}var Filters$2=Object.freeze({__proto__:null,centerMean:centerMean,centerMedian:centerMedian,fromTo:fromTo,normed:normed,divideBySD:divideBySD,rescale:rescale,paretoNormalization:paretoNormalization,airPLSBaseline:airPLSBaseline,iterativePolynomialBaseline:iterativePolynomialBaseline,rollingAverageBaseline:rollingAverageBaseline,rollingBallBaseline:rollingBallBaseline,rollingMedianBaseline:rollingMedianBaseline,firstDerivative:firstDerivative,secondDerivative:secondDerivative,thirdDerivative:thirdDerivative,savitzkyGolay:savitzkyGolay,ensureGrowing:ensureGrowing,equallySpaced:equallySpaced,filterX:filterX,calibrateX:calibrateX,xFunction:xFunction,yFunction:yFunction});function filterXY$1(t,e){let n={data:{x:xEnsureFloat64(t.x),y:xEnsureFloat64(t.y)}};const s=[];for(let t of e){const e=Date.now(),i=Filters$2[t.name];if(!i)throw new Error(`Unknown filter: ${t.name}`);n=i(n.data,t.options),s.push({name:t.name,time:Date.now()-e})}return{logs:s,data:n.data}}var Filters$1=Object.freeze({__proto__:null,filterXY:filterXY$1,centerMean:centerMean,centerMedian:centerMedian,fromTo:fromTo,normed:normed,divideBySD:divideBySD,rescale:rescale,paretoNormalization:paretoNormalization,airPLSBaseline:airPLSBaseline,iterativePolynomialBaseline:iterativePolynomialBaseline,rollingAverageBaseline:rollingAverageBaseline,rollingBallBaseline:rollingBallBaseline,rollingMedianBaseline:rollingMedianBaseline,firstDerivative:firstDerivative,secondDerivative:secondDerivative,thirdDerivative:thirdDerivative,savitzkyGolay:savitzkyGolay,ensureGrowing:ensureGrowing,equallySpaced:equallySpaced,filterX:filterX,calibrateX:calibrateX,xFunction:xFunction,yFunction:yFunction});const id$3="signalProcessing",name$3="Signal processing",DOMAIN_UPDATE_RULES$3={updateXDomain:!0,updateYDomain:!0};function apply$5(t,e){if(!isApplicable$3(t))throw new Error("Signal Processing is not applicable on this data");t.data=filterXY(t,e)}function isApplicable$3(t){return!!t.info.isFt}function reduce$3(t,e){return{once:!0,reduce:e}}function filterXY(t,e){let n=t.data.x.slice(0),s=t.data.x.slice(0),i=t.data.re.slice(0),o=t.data.im?.slice(0);const a=e.filters.slice(),{range:{from:l,to:r},numberOfPoints:m,exclusionsZones:g}=e;a.push({name:"equallySpaced",options:{from:l,to:r,numberOfPoints:m,exclusions:g},properties:{}});for(const t of a){const e=Filters$1[t.name];if(!e)throw new Error(`Unknown filter: ${t.name}`);const a=t?.options||{},l=e({x:n,y:i},a);if(n=l.data.x,i=l.data.y,o){o=e({x:s,y:o},a).data.y}}return{x:n,re:i,im:o}}var signalProcessing=Object.freeze({__proto__:null,id:id$3,name:name$3,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$3,apply:apply$5,isApplicable:isApplicable$3,reduce:reduce$3,filterXY:filterXY});const id$2="zeroFilling",name$2="Zero Filling",DOMAIN_UPDATE_RULES$2={updateXDomain:!0,updateYDomain:!1};function apply$4(t,e){if(!isApplicable$2(t))throw new Error("zeroFilling not applicable on this data");let{nbPoints:n,factor:s=2}=e;if(!n){n=2**Math.round(Math.log2(t.data.x.length*s));const e=t.filters.find((t=>t.name===id$2));e&&(e.value={nbPoints:n})}let i=t.filters.some((t=>"digitalFilter"===t.name&&t.flag));const o=t.info?.digitalFilter||0,a=i&&o>0?Math.floor(o):0,{re:l,im:r,x:m}=t.data;let g=new Float64Array(n),u=new Float64Array(n),c=new Float64Array(n);const C=Math.min(n,l.length);g.set(l.slice(0,C-a)),u.set(r.slice(0,C-a)),c.set(m.slice(0,C-a));let f=m[1]-m[0],h=m[C-a-1];for(let t=C-a;t<n;t++)h+=f,c[t]=h;a>0&&a<n&&(g.set(l.slice(l.length-a),n-a),u.set(r.slice(l.length-a),n-a)),t.data={...t.data,re:g,im:u,x:c}}function isApplicable$2(t){return!(!t.info?.isComplex||!t.info?.isFid)}function reduce$2(t,e){return delete e.factor,{once:!0,reduce:e}}var zeroFilling=Object.freeze({__proto__:null,id:id$2,name:name$2,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$2,apply:apply$4,isApplicable:isApplicable$2,reduce:reduce$2});const id$1="shift2DX",name$1="Shift 2D X",DOMAIN_UPDATE_RULES$1={updateXDomain:!0,updateYDomain:!1};function apply$3(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;const n={...t.data};for(const t in n)n[t].minX+=e,n[t].maxX+=e}function isApplicable$1(){return!0}function reduce$1(t,e){return{once:!0,reduce:t+e}}var shift2DX=Object.freeze({__proto__:null,id:id$1,name:name$1,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$1,apply:apply$3,isApplicable:isApplicable$1,reduce:reduce$1});const id="shift2DY",name="Shift 2D Y",DOMAIN_UPDATE_RULES={updateXDomain:!1,updateYDomain:!0};function apply$2(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;const n={...t.data};for(const t in n)n[t].minY+=e,n[t].maxY+=e}function isApplicable(){return!0}function reduce(t,e){return{once:!0,reduce:t+e}}var shift2DY=Object.freeze({__proto__:null,id:id,name:name,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES,apply:apply$2,isApplicable:isApplicable,reduce:reduce});const Filters={apodization:apodization,exclusionZones:exclusionZones,signalProcessing:signalProcessing,baselineCorrection:baselineCorrection,digitalFilter:digitalFilter,equallySpaced:equallySpaced$1,fft:fft,phaseCorrection:phaseCorrection$1,shiftX:shiftX,zeroFilling:zeroFilling,shift2DX:shift2DX,shift2DY:shift2DY};function cloneData1D(t){const{x:e,re:n,im:s}=t||{x:[],re:[],im:[]};return{x:e.slice(),re:n.slice(),im:s?.slice()||null}}function cloneData2D(t){const e={};if(isData2DFt(t))for(const n in t)addCloneData(e,n,t[n]);else for(const n in t)addCloneData(e,n,t[n]);return e}function isData2DFt(t){return"re"in t}function addCloneData(t,e,n){if(n){const{z:s,...i}=n;t[e]={z:s.slice(),...i}}}function getShiftX(t){const e=t?.filters&&t?.filters.find((t=>t.name===Filters.shiftX.id));return e?.flag?e.value.shift:0}function getRange$1(t,e,n){const{originFrom:s,originTo:i,from:o,to:a}=t;return"origin"===e?{originFrom:o-n,originTo:a-n,from:o,to:a}:{originFrom:s,originTo:i,from:s+n,to:i+n}}function mapIntegrals(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"origin";const{x:s,re:i}=e.data,o=getShiftX(e);return t.map((t=>{const e=getRange$1(t,n,o),a=xyIntegration({x:s,y:i},{from:e.from,to:e.to,reverse:!0});return{...t,id:t.id||v4(),...e,absolute:a}}))}function getSum(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,s=0;for(const i of t)if(n?.(i)){const t=i[e];if(!t||isNaN(t))continue;s+=Math.abs(t)}return s}function checkIntegralKind(t){return SignalKindsToInclude.includes(t.kind)}function mapValues(t,e,n,s){return t.map((t=>({...t,...s(t)&&{[e]:t.absolute*n}})))}function updateIntegralsRelativeValues(t){let e=arguments.length>1&&void 0!==arguments[1]&&arguments[1];const{values:n,options:s}=t.integrals,i=getSum(n,"absolute",checkIntegralKind);let o=0;if(s?.sum)if(s.isSumConstant||e)o=i>0?s.sum/i:0;else if(n?.[0]){const t=n[0];o=(t.integral||s.sum)/t.absolute}t.integrals.values=mapValues(n,"integral",o,checkIntegralKind),s.isSumConstant||e||(s.sum=getSum(n,"integral",checkIntegralKind))}function updateIntegrals(t){t.integrals.values=mapIntegrals(t.integrals.values,t,"current"),updateIntegralsRelativeValues(t,!0)}function getSpectrumErrorValue(t){const{x:e}=t.data;return(e[e.length-1]-e[0])/1e4}function isExists(t,e,n){for(const{x:s}of e.peaks?.values||[])if(Math.abs(t.x-s)<n)return!0;return!1}function getPeakDelta(t,e,n){const{originalX:s=0,x:i}=t;return"origin"===e?{originalX:i-n,x:i}:{originalX:s,x:s+n}}function mapPeaks(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{checkIsExisting:s=!0,shiftTarget:i="origin"}=n,o=getShiftX(e),a=getSpectrumErrorValue(e);let l=[];for(const n of t){const t=getPeakDelta(n,i,o);(!s||s&&!isExists(n,e,a))&&l.push({...n,id:n?.id||v4(),...t})}return l}function updatePeaks(t){t.peaks.values=mapPeaks(t.peaks.values,t,{checkIsExisting:!1,shiftTarget:"current"})}function checkRange(t,e,n){for(const{from:s,to:i}of e.ranges?.values||[])if(Math.abs(t.from-s)<n&&Math.abs(t.to-i)<n)return!0}function getRange(t,e,n){const{originFrom:s,originTo:i,from:o,to:a}=t;return"origin"===e?{originFrom:o-n,originTo:a-n,from:o,to:a}:{originFrom:s,originTo:i,from:(s||0)+n,to:(i||0)+n}}function getSignalDelta(t,e,n){const{delta:s,originDelta:i}=t;return"origin"===e?{originDelta:s-n,delta:s}:{originDelta:i,delta:(i||0)+n}}function nmrRangeToRange(t){const{signals:e=[],integration:n=0,...s}=t,i=[];for(const t of e){const{multiplicity:e,...n}=t;i.push({id:v4(),js:[],multiplicity:e||signalMultiplicityPattern(t),...n})}return{id:v4(),integration:n,absolute:n||0,signals:i,...s}}function mapRanges(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{checkIsExisting:s=!0,shiftTarget:i="origin"}=n,{x:o,re:a}=e.data,l=getShiftX(e),r=getSpectrumErrorValue(e);let m=t.map(nmrRangeToRange);return s&&(m=m.filter((t=>s&&!checkRange(t,e,r)||"new"===t.id))),m.map((t=>{const e=getRange(t,i,l),n=xyIntegration({x:o,y:a},{from:e.from,to:e.to,reverse:!0}),s=t.signals.map((t=>{const{kind:e=null,id:n,...s}=t;return{kind:e||"signal",id:n||v4(),...s,...getSignalDelta(t,i,l)}}));return{...t,id:t.id||v4(),kind:s?.[0].kind||DatumKind.signal,...e,absolute:n,signals:s}}))}function last$1(t){var e=null==t?0:t.length;return e?t[e-1]:void 0}var last_1=last$1;function baseSlice$1(t,e,n){var s=-1,i=t.length;e<0&&(e=-e>i?0:i+e),(n=n>i?i:n)<0&&(n+=i),i=e>n?0:n-e>>>0,e>>>=0;for(var o=Array(i);++s<i;)o[s]=t[s+e];return o}var _baseSlice=baseSlice$1,baseGet=_baseGet,baseSlice=_baseSlice;function parent$1(t,e){return e.length<2?t:baseGet(t,baseSlice(e,0,-1))}var _parent=parent$1,castPath$1=_castPath,last=last_1,parent=_parent,toKey=_toKey;function baseUnset$1(t,e){return e=castPath$1(e,t),null==(t=parent(t,e))||delete t[toKey(last(e))]}var _baseUnset=baseUnset$1,baseGetTag=_baseGetTag,getPrototype=_getPrototype,isObjectLike=isObjectLike_1,objectTag="[object Object]",funcProto=Function.prototype,objectProto=Object.prototype,funcToString=funcProto.toString,hasOwnProperty=objectProto.hasOwnProperty,objectCtorString=funcToString.call(Object);function isPlainObject$1(t){if(!isObjectLike(t)||baseGetTag(t)!=objectTag)return!1;var e=getPrototype(t);if(null===e)return!0;var n=hasOwnProperty.call(e,"constructor")&&e.constructor;return"function"==typeof n&&n instanceof n&&funcToString.call(n)==objectCtorString}var isPlainObject_1=isPlainObject$1,isPlainObject=isPlainObject_1;function customOmitClone$1(t){return isPlainObject(t)?void 0:t}var _customOmitClone=customOmitClone$1,Symbol$1=_Symbol,isArguments=isArguments_1,isArray=isArray_1,spreadableSymbol=Symbol$1?Symbol$1.isConcatSpreadable:void 0;function isFlattenable$1(t){return isArray(t)||isArguments(t)||!!(spreadableSymbol&&t&&t[spreadableSymbol])}var _isFlattenable=isFlattenable$1,arrayPush=_arrayPush,isFlattenable=_isFlattenable;function baseFlatten$1(t,e,n,s,i){var o=-1,a=t.length;for(n||(n=isFlattenable),i||(i=[]);++o<a;){var l=t[o];e>0&&n(l)?e>1?baseFlatten$1(l,e-1,n,s,i):arrayPush(i,l):s||(i[i.length]=l)}return i}var _baseFlatten=baseFlatten$1,baseFlatten=_baseFlatten;function flatten$1(t){return(null==t?0:t.length)?baseFlatten(t,1):[]}var flatten_1=flatten$1;function apply$1(t,e,n){switch(n.length){case 0:return t.call(e);case 1:return t.call(e,n[0]);case 2:return t.call(e,n[0],n[1]);case 3:return t.call(e,n[0],n[1],n[2])}return t.apply(e,n)}var _apply=apply$1,apply=_apply,nativeMax=Math.max;function overRest$1(t,e,n){return e=nativeMax(void 0===e?t.length-1:e,0),function(){for(var s=arguments,i=-1,o=nativeMax(s.length-e,0),a=Array(o);++i<o;)a[i]=s[e+i];i=-1;for(var l=Array(e+1);++i<e;)l[i]=s[i];return l[e]=n(a),apply(t,this,l)}}var _overRest=overRest$1;function constant$1(t){return function(){return t}}var constant_1=constant$1;function identity$1(t){return t}var identity_1=identity$1,constant=constant_1,defineProperty=_defineProperty,identity=identity_1,baseSetToString$1=defineProperty?function(t,e){return defineProperty(t,"toString",{configurable:!0,enumerable:!1,value:constant(e),writable:!0})}:identity,_baseSetToString=baseSetToString$1,HOT_COUNT=800,HOT_SPAN=16,nativeNow=Date.now;function shortOut$1(t){var e=0,n=0;return function(){var s=nativeNow(),i=HOT_SPAN-(s-n);if(n=s,i>0){if(++e>=HOT_COUNT)return arguments[0]}else e=0;return t.apply(void 0,arguments)}}var _shortOut=shortOut$1,baseSetToString=_baseSetToString,shortOut=_shortOut,setToString$1=shortOut(baseSetToString),_setToString=setToString$1,flatten=flatten_1,overRest=_overRest,setToString=_setToString;function flatRest$1(t){return setToString(overRest(t,void 0,flatten),t+"")}var _flatRest=flatRest$1,arrayMap=_arrayMap,baseClone=_baseClone,baseUnset=_baseUnset,castPath=_castPath,copyObject=_copyObject,customOmitClone=_customOmitClone,flatRest=_flatRest,getAllKeysIn=_getAllKeysIn,CLONE_DEEP_FLAG=1,CLONE_FLAT_FLAG=2,CLONE_SYMBOLS_FLAG=4,omit=flatRest((function(t,e){var n={};if(null==t)return n;var s=!1;e=arrayMap(e,(function(e){return e=castPath(e,t),s||(s=e.length>1),e})),copyObject(t,getAllKeysIn(t),n),s&&(n=baseClone(n,CLONE_DEEP_FLAG|CLONE_FLAT_FLAG|CLONE_SYMBOLS_FLAG,customOmitClone));for(var i=e.length;i--;)baseUnset(n,e[i]);return n})),omit_1=omit,omit$1=omit_1;function getDiaIDs(t){return[].concat(t.diaIDs||[],t.signals?t.signals.flatMap((t=>t.diaIDs||[])):[])}function getNbAtoms(t,e){if(void 0===e){let e=0;if(t.signals)for(const n of t.signals)e+=n.nbAtoms||0;return e}return t.signals[e].nbAtoms||0}function setNbAtoms(t,e){t.nbAtoms=getNbAtoms(t,e),0===t.nbAtoms&&delete t.nbAtoms}function resetDiaIDs(t){const e=["diaIDs","nbAtoms"];(t=omit$1(t,e)).signals=t.signals.map((t=>omit$1(t,e)))}function unlink(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{unlinkType:n="both",signalIndex:s=-1}=e,i=["diaIDs","nbAtoms"];switch(n){case"both":resetDiaIDs(t);break;case"range":t=omit$1(t,i);break;case"signal":-1!==s&&(t.signals[s]=omit$1(t.signals[s],i))}return t}function addDefaultSignal(t){t.signals.push({id:v4(),multiplicity:"m",kind:"signal",js:[],delta:(t.to+t.from)/2})}function checkRangeKind$1(t){return t.kind===DatumKind.signal}function checkSignalKinds(t,e){return!t.signals.some((t=>void 0===t.kind||!e.includes(t.kind)))}var RangeUtilities=Object.freeze({__proto__:null,getDiaIDs:getDiaIDs,getNbAtoms:getNbAtoms,setNbAtoms:setNbAtoms,resetDiaIDs:resetDiaIDs,unlink:unlink,addDefaultSignal:addDefaultSignal,checkRangeKind:checkRangeKind$1,checkSignalKinds:checkSignalKinds});function checkRangeKind(t){return t.signals&&checkSignalKinds(t,SignalKindsToInclude)}function updateRangesRelativeValues(t){let e=arguments.length>1&&void 0!==arguments[1]&&arguments[1];const{values:n,options:s}=t.ranges,i=getSum(n,"absolute",checkRangeKind);let o=0;if(s?.sum)if(s.isSumConstant||e)o=i>0?s.sum/i:0;else if(n?.[0]){const t=n[0];o=(t.integration||s.sum)/t.absolute}t.ranges.values=mapValues(n,"integration",o,checkRangeKind),s.isSumConstant||e||(s.sum=getSum(n,"integration",checkRangeKind))}function updateRanges(t){t.ranges.values=mapRanges(t.ranges.values,t,{checkIsExisting:!1,shiftTarget:"current"}),updateRangesRelativeValues(t,!0)}function get2DSpectrumErrorValue(t){const{data:e,info:n}=t,{minX:s,maxX:i,minY:o,maxY:a}=n.isFid?e.re:e.rr;return{x:Math.abs(i-s)/1e4,y:Math.abs(a-o)/1e4}}function getShift(t){let e={x:0,y:0};if(t?.filters)for(const n of t.filters)n.name===Filters.shift2DX.id&&(e.x=n?.flag?n.value.shift:0),n.name===Filters.shift2DY.id&&(e.y=n?.flag?n.value.shift:0);return e}function isZoneExists(t,e,n){const s=t.x||{from:0,to:0},i=t.y||{from:0,to:0};if(!e.zones?.values)return!1;for(const{x:t,y:o}of e.zones.values)if(Math.abs(s.from-t.from)<n.x&&Math.abs(s.to-t.to)<n.x&&Math.abs(i.from-o.from)<n.y&&Math.abs(i.to-o.to)<n.y)return!0;return!1}function getSignal(t,e,n){const{x:s,y:i}=t;return"origin"===e?{...t,x:{...s,originDelta:s.delta-n.x},y:{...i,originDelta:i.delta-n.y}}:{...t,x:{...s,delta:s.originDelta+n.x},y:{...i,delta:i.originDelta+n.y}}}function mapZones(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{checkIsExisting:s=!0,shiftTarget:i="origin"}=n,o=getShift(e),a=get2DSpectrumErrorValue(e);let l=t;return s&&(l=t.filter((t=>!isZoneExists(t,e,a)))),l.map((t=>{const e=t.x||{from:0,to:0},n=t.y||{from:0,to:0},s=t.signals.map((t=>{const{id:e,kind:n}=t;return{...getSignal(t,i,o),id:e||v4(),kind:n||"signal"}}));return{...t,id:t.id||v4(),x:{from:e.from,to:e.to},y:{from:n.from,to:n.to},signals:s,kind:t.kind||DatumKind.signal}}))}function updateZones(t){t.zones.values=mapZones(t.zones.values,t,{checkIsExisting:!1,shiftTarget:"current"})}function resetDataToOrigin(t){t.data=1===t.info.dimension?cloneData1D(t.originalData):cloneData2D(t.originalData);const{originalInfo:e}=t;e&&(t.info={...e})}function updateData(t){1===t.info.dimension?(updatePeaks(t),updateRanges(t),updateIntegrals(t)):2===t.info.dimension&&updateZones(t)}function applyFilter(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{forceReapply:s=!1,filterIndex:i}=n;let o=!1;for(let n of e){const e={name:n.name,label:Filters[n.name].name,value:n.value},s=lookupForFilter(t,n.name),a=!("isDeleteAllow"in n)||n.isDeleteAllow;if(s){const l=Filters[n.name].reduce(s.value,e.value);l.once?(o||(o=!0),null!=l.reduce&&void 0!==l.reduce&&replaceFilter(t,s.id,l.reduce)):addFilter(t,e,{isDeleteAllow:a,filterIndex:i})}else addFilter(t,e,{isDeleteAllow:a,filterIndex:i})}if(s)reapplyFilters(t);else if(o)1===e.length&&isLastFilter(t,e[0].name)?Filters[e[0].name].apply(t,e[0].value):reapplyFilters(t);else for(let n of e)Filters[n.name].apply(t,n.value);updateData(t)}function isLastFilter(t,e){const n=t.filters.findIndex((t=>t.name===e));return t.filters.length===n+1}function lookupForFilter(t,e){return t.filters.find((t=>t.name===e))}function reapplyFilters(t,e){enableFilter(t,null,null,e||t.filters)}function enableFilter(t,e,n,s){t.filters=t.filters.slice(0),e&&(t.filters=t.filters.map((t=>({...t,flag:t.id===e?n:t.flag})))),resetDataToOrigin(t);const i=s||t.filters;for(let e=0;e<i.length;e++){const n=t.filters[e];if(t.filters[e]={...t.filters[e]},n.flag)try{Filters[n.name].apply(t,n.value)}catch(n){t.filters[e]={...t.filters[e],error:n.message}}}}function deleteFilter(t,e){t.filters=t.filters.slice(0).filter((t=>e?t.id!==e:!t.isDeleteAllow)),resetDataToOrigin(t);for(let e=0;e<t.filters.length;e++)if(t.filters[e]={...t.filters[e]},t.filters[e].flag){const{name:n,value:s}=t.filters[e];try{Filters[n].apply(t,s)}catch(n){t.filters[e]={...t.filters[e],error:n.message}}}updateData(t)}function addFilter(t,e){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{filterIndex:s,isDeleteAllow:i=!0}=n,o={...e,id:v4(),flag:!0,isDeleteAllow:i};"number"==typeof s&&-1!==s?t.filters=[...t.filters.slice(0,s+1),o,...t.filters.slice(s+1)]:t.filters.push(o)}function replaceFilter(t,e,n){const s=t.filters.findIndex((t=>t.id===e));t.filters[s]={...t.filters[s],value:n}}var FiltersManager=Object.freeze({__proto__:null,applyFilter:applyFilter,lookupForFilter:lookupForFilter,reapplyFilters:reapplyFilters,enableFilter:enableFilter,deleteFilter:deleteFilter,addFilter:addFilter});exports.DatumKind=DatumKind,exports.Filters=Filters,exports.FiltersManager=FiltersManager,exports.MultiplicityPatterns=MultiplicityPatterns,exports.RangeUtilities=RangeUtilities,exports.SignalKinds=SignalKinds,exports.SignalKindsToInclude=SignalKindsToInclude,exports.apodization=apodization$1,exports.apodizationFilter=apodizationFilter,exports.carbonImpurities=carbonImpurities,exports.checkIntegralKind=checkIntegralKind,exports.checkMultiplet=checkMultiplet,exports.checkMultiplicity=checkMultiplicity,exports.couplingACSPatterns=couplingACSPatterns,exports.couplingPatterns=couplingPatterns,exports.findMultiplet=findMultiplet,exports.get13CAssignments=get13CAssignments,exports.get1HAssignments=get1HAssignments,exports.getAssignments=getAssignments,exports.getDatabase=getDatabase,exports.getFrequency=getFrequency,exports.getShiftX=getShiftX,exports.getSpectrumErrorValue=getSpectrumErrorValue,exports.gyromagneticRatio=gyromagneticRatio,exports.impurities=impurities,exports.mapIntegrals=mapIntegrals,exports.mapPeaks=mapPeaks,exports.mapRanges=mapRanges,exports.markSolventPeaks=markSolventPeaks,exports.normalizeNucleus=normalizeNucleus,exports.optimizeSignals=optimizeSignals,exports.peakToXY=peakToXY,exports.peaksFilterImpurities=peaksFilterImpurities,exports.peaksToXY=peaksToXY,exports.predictAll=predictAll,exports.predictAllSpectra=predictAllSpectra,exports.predictCOSY=predictCOSY,exports.predictCarbon=predictCarbon,exports.predictHMBC=predictHMBC,exports.predictHSQC=predictHSQC,exports.predictProton=predictProton,exports.protonImpurities=protonImpurities,exports.rangeFromSignal=rangeFromSignal,exports.rangesToACS=rangesToACS,exports.rangesToXY=rangesToXY,exports.resurrect=resurrect,exports.signalJoinCouplings=signalJoinCouplings,exports.signalMultiplicityPattern=signalMultiplicityPattern,exports.signals2DToZ=signals2DToZ,exports.signalsToFID=signalsToFID,exports.signalsToRanges=signalsToRanges,exports.signalsToXY=signalsToXY,exports.solventSuppression=solventSuppression,exports.splitPatterns=splitPatterns,exports.translateMultiplet=translateMultiplet,exports.updateIntegralsRelativeValues=updateIntegralsRelativeValues,exports.updateRanges=updateRanges,exports.updateRangesRelativeValues=updateRangesRelativeValues,exports.xyAutoPeaksPicking=xyAutoPeaksPicking,exports.xyAutoRangesPicking=xyAutoRangesPicking,exports.xyPeaksOptimization=xyPeaksOptimization,exports.xyzAutoSignalsPicking=xyzAutoSignalsPicking,exports.xyzAutoZonesPicking=xyzAutoZonesPicking,exports.xyzBidimensionalFFT=xyzBidimensionalFFT,exports.xyzJResAnalyzer=xyzJResAnalyzer,Object.defineProperty(exports,"__esModule",{value:!0})}));
//# sourceMappingURL=nmr-processing.min.js.map
