!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).NMRProcessing={})}(this,(function(exports){"use strict";const impurities={cdcl3:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"ds",shift:7.26}],h2o:[{proton:"H2O",coupling:0,multiplicity:"bs",shift:1.56}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.17}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.28}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.19},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.98},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.01},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.27},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.43}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.26}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.73}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.3}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.21},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.48}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.65},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.57},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.39}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.4},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.55}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.09},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.02},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.88}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.62}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.71}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.25},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.72},{proton:"OH",coupling:5,multiplicity:"s,t",shift:1.32}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.05},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.12},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.14},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.46},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.06}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.76}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.26}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.26}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.65}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.49},{proton:"OH",coupling:0,multiplicity:"s",shift:1.09}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.33}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:7},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.22},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.04}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.62},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.29},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.68}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.07}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.85},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.76}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.17},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.03},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.53}]},"(cd3)2co":{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:2.05}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.84}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.05}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.13},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.96},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.41}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.87}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.63}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.41}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.56},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.47},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.28}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.46}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.78}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.52}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.59}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.57},{proton:"OH",coupling:5,multiplicity:"s,t",shift:3.39}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.05},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.45},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.28}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.87},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.59}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"OH",coupling:0,multiplicity:"s",shift:3.12}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.43}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.1},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.9}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.35},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.76}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.13}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.79},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.63}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.5},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.5}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},dmso:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"quint",shift:2.5}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:3.33}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.91}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.07}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.19}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.08}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.87},{proton:"OHc",coupling:0,multiplicity:"s",shift:6.65},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.18},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.36}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.32}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.76}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.09},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.38}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.51},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.38},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.24}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.24},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.43}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.78}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.95},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.73}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.54}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.57}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.06},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.44},{proton:"OH",coupling:5,multiplicity:"s,t",shift:4.63}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.99},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.03},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.17}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.91}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.34}],"grease^f":[],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.25}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.53}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.16},{proton:"OH",coupling:0,multiplicity:"s",shift:4.01}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.42}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.04},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.78}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.39},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.79}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.76},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.6}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.3},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.18},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.93},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.43}]},c6d6:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:7.16}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:.4}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.15}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:1.55}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.07},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.04}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:7.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.79},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.24},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.38}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:6.15}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:2.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:4.27}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.26}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.46},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.34},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.11}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.12},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.33}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.6},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.57},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.05}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.63},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH3",coupling:0,multiplicity:"s",shift:1.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.68}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.35}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.34}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.65},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.89},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.92}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.58},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:1.81},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.85}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.41}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.92},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.36}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.24}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.4}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.07}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.23}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:.95},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.67}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:6.66},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:6.98}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.29}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.4},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.57}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.11},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.02},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.13}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.4}]},cd3cn:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:1.94}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.13}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.16},{proton:"OHc",coupling:0,multiplicity:"s",shift:2.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.14},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.97},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.2},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.39}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.58}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.44}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.81}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.44}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.42}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.53},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.45},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.29}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.45}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.77}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.5}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.54},{proton:"OH",coupling:5,multiplicity:"s,t",shift:2.47}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.06},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.06},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.51}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.27}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.57}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"OH",coupling:0,multiplicity:"s",shift:2.16}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.31}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.87},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.09},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.87}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.57},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.33},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.73}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.08}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.8},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.64}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.33},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.2},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.2}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},cd3od:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:3.31}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:4.87}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.99}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.15}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.03}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.33}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.4}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.15},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.2}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.92},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.21},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.4}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.9}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.45}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.78}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.49}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.18},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.49}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.58},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.35}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.35},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.52}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.92}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.97},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.99},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.65}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.66}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.19},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.6}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.01},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.09},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.12},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.5},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.01}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.59}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.88},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.9},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.64}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.34}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.5},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.92}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.44},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.85}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.1}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.87},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.71}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.16},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.16}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.05},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.58}]},d2o:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:4.79}],h2o:[],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.22}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.06}],benzene:[],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.24}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.21},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[],chloroform:[],cyclohexane:[],"1,2-dichloroethane":[],dichloromethane:[],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.56}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.67},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.37}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.37},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.08},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.06},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.9}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:3.01},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.85}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.71}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.75}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.65}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.14},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.19},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.18},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.65}],"grease^f":[],"n-hexane":[],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.61}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.4}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.9}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.17},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.02}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.52},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.45},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.87}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.88},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.74}],toluene:[],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.99},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.57}]}},toCheck=["solvent","H2O","TMS"];function peaksFilterImpurities(t,e={}){let{solvent:i="",error:r=.025,remove:o=!1}=e;i=i.toLowerCase(),"(cd3)2so"===i&&(i="dmso"),"meod"===i&&(i="cd3od");let n=impurities[i];if(n)for(let e of toCheck){let i=e.toLowerCase();checkImpurity(t,n[i],{error:r,remove:o,name:i})}return t}function checkImpurity(t,e,i){let r,o,n,{name:s,error:l,remove:a}=i,u=e.length;for(;u--;)for(r=t.length;r--;)t[r].asymmetric||(o=l+t[r].width,n=Math.abs(e[u].shift-t[r].x),n<o&&(a?t.splice(r,1):t[r].kind=s))}const GAUSSIAN_EXP_FACTOR=-4*Math.LN2,ROOT_PI_OVER_LN2=Math.sqrt(Math.PI/Math.LN2),ROOT_THREE=Math.sqrt(3),ROOT_2LN2=Math.sqrt(2*Math.LN2),ROOT_2LN2_MINUS_ONE=Math.sqrt(2*Math.LN2)-1;function erfinv(t){if(0===t)return 0;let e=Math.log(1-t*t),i=e/2+2/(.147*Math.PI),r=Math.sqrt(i**2-e/.147);return Math.sqrt(r-i)*(t>0?1:-1)}class Gaussian{constructor(t={}){this.fwhm=t.sd?Gaussian.widthToFWHM(2*t.sd):t.fwhm?t.fwhm:500,this.height=void 0===t.height?Math.sqrt(-GAUSSIAN_EXP_FACTOR/Math.PI)/this.fwhm:t.height}getData(t={}){let{length:e,factor:i=this.getFactor()}=t;e||(e=Math.min(Math.ceil(this.fwhm*i),Math.pow(2,25)-1),e%2==0&&e++);const r=(e-1)/2,o=new Float64Array(e);for(let t=0;t<=r;t++)o[t]=this.fct(t-r)*this.height,o[e-1-t]=o[t];return o}fct(t){return Gaussian.fct(t,this.fwhm)}getFactor(t=.9999){return Gaussian.getFactor(t)}getArea(){return Gaussian.getArea(this.fwhm,{height:this.height})}widthToFWHM(t){return Gaussian.widthToFWHM(t)}fwhmToWidth(t=this.fwhm){return Gaussian.fwhmToWidth(t)}setFWHM(t){this.fwhm=t}setHeight(t){this.height=t}}Gaussian.fct=function(t,e=500){return Math.exp(GAUSSIAN_EXP_FACTOR*Math.pow(t/e,2))},Gaussian.widthToFWHM=function(t){return t*ROOT_2LN2},Gaussian.fwhmToWidth=function(t){return t/ROOT_2LN2},Gaussian.getArea=function(t,e={}){let{height:i=1}=e;return i*ROOT_PI_OVER_LN2*t/2},Gaussian.getFactor=function(t=.9999){return Math.sqrt(2)*erfinv(t)};class Lorentzian{constructor(t={}){this.fwhm=void 0===t.fwhm?500:t.fwhm,this.height=void 0===t.height?2/Math.PI/this.fwhm:t.height}getData(t={}){let{length:e,factor:i=this.getFactor()}=t;e||(e=Math.min(Math.ceil(this.fwhm*i),Math.pow(2,25)-1),e%2==0&&e++);const r=(e-1)/2,o=new Float64Array(e);for(let t=0;t<=r;t++)o[t]=this.fct(t-r)*this.height,o[e-1-t]=o[t];return o}fct(t){return Lorentzian.fct(t,this.fwhm)}getFactor(t=.9999){return Lorentzian.getFactor(t)}getArea(){return Lorentzian.getArea(this.fwhm,{height:this.height})}fwhmToWidth(t=this.fwhm){return Lorentzian.fwhmToWidth(t)}widthToFWHM(t){return Lorentzian.widthToFWHM(t)}setFWHM(t){this.fwhm=t}setHeight(t){this.height=t}}Lorentzian.fct=function(t,e){const i=e*e;return i/(4*Math.pow(t,2)+i)},Lorentzian.fwhmToWidth=function(t){return t/ROOT_THREE},Lorentzian.widthToFWHM=function(t){return t*ROOT_THREE},Lorentzian.getArea=function(t,e={}){let{height:i=1}=e;return i*Math.PI*t/2},Lorentzian.getFactor=function(t=.9999){return 2*Math.tan(Math.PI*(t-.5))};class PseudoVoigt{constructor(t={}){this.mu=void 0===t.mu?.5:t.mu,this.fwhm=void 0===t.fwhm?500:t.fwhm,this.height=void 0===t.height?1/(this.mu/Math.sqrt(-GAUSSIAN_EXP_FACTOR/Math.PI)*this.fwhm+(1-this.mu)*this.fwhm*Math.PI/2):t.height}getData(t={}){let{length:e,factor:i=this.getFactor()}=t;e||(e=Math.ceil(this.fwhm*i),e%2==0&&e++);const r=(e-1)/2;let o=new Float64Array(e);for(let t=0;t<=r;t++)o[t]=this.fct(t-r)*this.height,o[e-1-t]=o[t];return o}fct(t){return PseudoVoigt.fct(t,this.fwhm,this.mu)}getFactor(t=.9999,e=this.mu){return PseudoVoigt.getFactor(t,e)}getArea(){return PseudoVoigt.getArea(this.fwhm,{height:this.height,mu:this.mu})}widthToFWHM(t,e){return PseudoVoigt.widthToFWHM(t,e)}fwhmToWidth(t=this.fwhm,e=this.mu){return PseudoVoigt.fwhmToWidth(t,e)}setFWHM(t){this.fwhm=t}setHeight(t){this.height=t}setMu(t){this.mu=t}}PseudoVoigt.fct=function(t,e,i=.5){return(1-i)*Lorentzian.fct(t,e)+i*Gaussian.fct(t,e)},PseudoVoigt.widthToFWHM=function(t,e=.5){return t*(e*ROOT_2LN2_MINUS_ONE+1)},PseudoVoigt.fwhmToWidth=function(t,e=.5){return t/(e*ROOT_2LN2_MINUS_ONE+1)},PseudoVoigt.getArea=function(t,e={}){let{height:i=1,mu:r=.5}=e;return t*i*(r*ROOT_PI_OVER_LN2+(1-r)*Math.PI)/2},PseudoVoigt.getFactor=function(t=.9999,e=.5){return e<1?Lorentzian.getFactor(t):Gaussian.getFactor(t)};let axis=["x","y"];class Gaussian2D{constructor(t={}){let{fwhm:e=500}=t;for(let i of axis){let r;r=t[i]?t[i].sd?Gaussian2D.widthToFWHM(2*t[i].sd):t[i].fwhm||e:e,this[i]={fwhm:r}}this.height=void 0===t.height?-GAUSSIAN_EXP_FACTOR/Math.PI/this.x.fwhm/this.y.fwhm:t.height}getData(t={}){let{x:e={},y:i={},factor:r=this.getFactor(),length:o}=t,n=e.length||o;if(!n){let{factor:t=r}=e;n=Math.min(Math.ceil(this.x.fwhm*t),Math.pow(2,25)-1),n%2==0&&n++}let s=i.length||o;if(!s){let{factor:t=r}=i;s=Math.min(Math.ceil(this.y.fwhm*t),Math.pow(2,25)-1),s%2==0&&s++}const l=(n-1)/2,a=(s-1)/2,u=new Array(n);for(let t=0;t<n;t++)u[t]=new Array(s);for(let t=0;t<n;t++)for(let e=0;e<s;e++)u[t][e]=this.fct(t-l,e-a)*this.height;return u}fct(t,e){return Gaussian2D.fct(t,e,this.x.fwhm,this.y.fwhm)}getFactor(t=.9999){return Gaussian2D.getFactor(t)}getVolume(){return Gaussian2D.getVolume(this.x.fwhm,this.y.fwhm,{height:this.height})}widthToFWHM(t){return Gaussian2D.widthToFWHM(t)}fwhmToWidth(t=this.x.fwhm){return Gaussian2D.fwhmToWidth(t)}setFWHM(t,e){e||(e=axis),Array.isArray(e)||(e=[e]);for(let i of e){let e=i.toLowerCase();if("y"!==e&&"x"!==e)throw new Error("axis label should be x or y");this[e].fwhm=t}}setHeight(t){this.height=t}}function getShapeGenerator(t){let{kind:e="Gaussian",options:i}=t;switch(e.toLowerCase().replace(/[^a-z^0-9]/g,"")){case"gaussian":return new Gaussian(i);case"lorentzian":return new Lorentzian(i);case"pseudovoigt":return new PseudoVoigt(i);case"gaussian2d":return new Gaussian2D(i);default:throw new Error(`Unknown kind: ${e}`)}}function SavitzkyGolay(t,e,i={}){let{windowSize:r=9,derivative:o=0,polynomial:n=3}=i;if(r%2==0||r<5||!Number.isInteger(r))throw new RangeError("Invalid window size (should be odd and at least 5 integer number)");if(r>t.length)throw new RangeError(`Window size is higher than the data length ${r}>${t.length}`);if(o<0||!Number.isInteger(o))throw new RangeError("Derivative should be a positive integer");if(n<1||!Number.isInteger(n))throw new RangeError("Polynomial should be a positive integer");n>=6&&console.warn("You should not use polynomial grade higher than 5 if you are not sure that your data arises from such a model. Possible polynomial oscillation problems");let s=Math.floor(r/2),l=t.length,a=new Array(l),u=fullWeights(r,n,o),h=0,c=!0;Array.isArray(e)?c=!1:h=Math.pow(e,o);for(let i=0;i<s;i++){let n=u[s-i-1],f=u[s+i+1],p=0,m=0;for(let e=0;e<r;e++)p+=n[e]*t[e],m+=f[e]*t[l-r+e];c?(a[s-i-1]=p/h,a[l-s+i]=m/h):(h=getHs(e,s-i-1,s,o),a[s-i-1]=p/h,h=getHs(e,l-s+i,s,o),a[l-s+i]=m/h)}let f=u[s];for(let i=r;i<=l;i++){let n=0;for(let e=0;e<r;e++)n+=f[e]*t[e+i-r];c||(h=getHs(e,i-s-1,s,o)),a[i-s-1]=n/h}return a}function getHs(t,e,i,r){let o=0,n=0;for(let r=e-i;r<e+i;r++)r>=0&&r<t.length-1&&(o+=t[r+1]-t[r],n++);return Math.pow(o/n,r)}function GramPoly(t,e,i,r){let o=0;return o=i>0?(4*i-2)/(i*(2*e-i+1))*(t*GramPoly(t,e,i-1,r)+r*GramPoly(t,e,i-1,r-1))-(i-1)*(2*e+i)/(i*(2*e-i+1))*GramPoly(t,e,i-2,r):0===i&&0===r?1:0,o}function GenFact(t,e){let i=1;if(t>=e)for(let r=t-e+1;r<=t;r++)i*=r;return i}function Weight(t,e,i,r,o){let n=0;for(let s=0;s<=r;s++)n+=(2*s+1)*(GenFact(2*i,s)/GenFact(2*i+s+1,s+1))*GramPoly(t,i,s,0)*GramPoly(e,i,s,o);return n}function fullWeights(t,e,i){let r=new Array(t),o=Math.floor(t/2);for(let n=-o;n<=o;n++){r[n+o]=new Array(t);for(let t=-o;t<=o;t++)r[n+o][t+o]=Weight(t,n,o,e,i)}return r}function gsd(t,e={}){let{noiseLevel:i,sgOptions:r={windowSize:9,polynomial:3},shape:o={},smoothY:n=!0,heightFactor:s=0,broadRatio:l=0,maxCriteria:a=!0,minMaxRatio:u=25e-5,derivativeThreshold:h=-1,realTopDetection:c=!1}=e,{y:f,x:p}=t;const m=f.slice();let g=isEqualSpaced(p);if(!1===a)for(let t=0;t<m.length;t++)m[t]*=-1;void 0===i&&(i=g?getNoiseLevel(m):0);for(let t=0;t<m.length;t++)m[t]-=i;for(let t=0;t<m.length;t++)m[t]<0&&(m[t]=0);let y,d,w=m;const{windowSize:x,polynomial:b}=r;g?(n&&(w=SavitzkyGolay(m,p[1]-p[0],{windowSize:x,polynomial:b,derivative:0})),y=SavitzkyGolay(m,p[1]-p[0],{windowSize:x,polynomial:b,derivative:1}),d=SavitzkyGolay(m,p[1]-p[0],{windowSize:x,polynomial:b,derivative:2})):(n&&(w=SavitzkyGolay(m,p,{windowSize:x,polynomial:b,derivative:0})),y=SavitzkyGolay(m,p,{windowSize:x,polynomial:b,derivative:1}),d=SavitzkyGolay(m,p,{windowSize:x,polynomial:b,derivative:2}));const M=p,C=p[1]-p[0];let v=0,A=0;for(let t=0;t<w.length;t++)Math.abs(d[t])>v&&(v=Math.abs(d[t])),Math.abs(w[t])>A&&(A=Math.abs(w[t]));let H=null,k=null,E=[],S=[],N=[],F=[];for(let t=1;t<w.length-1;++t)Math.abs(y[t])>h&&((y[t]<y[t-1]&&y[t]<=y[t+1]||y[t]<=y[t-1]&&y[t]<y[t+1])&&(k={x:M[t],index:t},C>0&&null!==H&&(S.push(H),N.push(k))),(y[t]>=y[t-1]&&y[t]>y[t+1]||y[t]>y[t-1]&&y[t]>=y[t+1])&&(H={x:M[t],index:t},C<0&&null!==k&&(S.push(H),N.push(k)))),d[t]<d[t-1]&&d[t]<d[t+1]&&(E.push(t),F.push(Math.abs(d[t])<=l*v));let I,D,R,T,O,P=o.kind?getShapeGenerator(o.kind,o.options).widthToFWHM:t=>t,_=[],L=-1;for(let t=0;t<E.length;++t){D=M[E[t]],I=-1;let e=L+1;for(T=Number.MAX_VALUE,R=0,O=!0;-1===I&&e<S.length&&O;)R=Math.abs(D-(S[e].x+N[e].x)/2),R<T?T=R:O=!1,R<Math.abs(S[e].x-N[e].x)/2&&(I=e,L=e),++e;if(-1!==I&&Math.abs(w[E[t]])>u*A){let e=Math.abs(N[I].x-S[I].x);if(_.push({index:E[t],x:D,y:a?w[E[t]]+i:-w[E[t]]-i,width:P(e),soft:F[t]}),_[_.length-1].left=S[I],_[_.length-1].right=N[I],s){let t=w[S[I].index],e=w[N[I].index];_[_.length-1].height=s*(_[_.length-1].y-(t+e)/2)}}}c&&determineRealTop$1(_,M,w);for(let t=0;t<_.length;t++)_[t].base=i;return _.sort((function(t,e){return t.x-e.x})),_}Gaussian2D.fct=function(t,e,i=500,r=500){return Math.exp(GAUSSIAN_EXP_FACTOR*(Math.pow(t/i,2)+Math.pow(e/r,2)))},Gaussian2D.widthToFWHM=function(t){return t*ROOT_2LN2},Gaussian2D.fwhmToWidth=function(t){return t/ROOT_2LN2},Gaussian2D.getVolume=function(t,e,i={}){let{height:r=1}=i;return r*Math.PI*t*e/Math.LN2/4},Gaussian2D.getFactor=function(t=.9999){return Math.sqrt(2)*erfinv(t)};const isEqualSpaced=t=>{let e,i=0,r=Number.MAX_SAFE_INTEGER;for(let o=0;o<t.length-1;++o)e=Math.abs(t[o+1]-t[o]),e<r&&(r=e),e>i&&(i=e);return(i-r)/i<.05},getNoiseLevel=t=>{let e=0,i=0,r=t.length;for(let i=0;i<r;++i)e+=t[i];e/=r;let o=new Array(r);for(let i=0;i<r;++i)o[i]=Math.abs(t[i]-e);return o.sort(((t,e)=>t-e)),i=r%2==1?o[(r-1)/2]/.6745:.5*(o[r/2]+o[r/2-1])/.6745,i},determineRealTop$1=(t,e,i)=>{let r,o,n,s,l;for(let a=0;a<t.length;a++)l=t[a].index,i[l-1]>=i[l-2]&&i[l-1]>=i[l]?l--:i[l+1]>=i[l]&&i[l+1]>=i[l+2]?l++:i[l-2]>=i[l-3]&&i[l-2]>=i[l-1]?l-=2:i[l+2]>=i[l+1]&&i[l+2]>=i[l+3]&&(l+=2),i[l-1]>0&&i[l+1]>0&&i[l]>=i[l-1]&&i[l]>=i[l+1]&&(i[l]!==i[l-1]||i[l]!==i[l+1])&&(r=20*Math.log10(i[l-1]),o=20*Math.log10(i[l]),n=20*Math.log10(i[l+1]),s=.5*(r-n)/(r-2*o+n),t[a].x=e[l]+(e[l]-e[l-1])*s,t[a].y=i[l]-.25*(i[l-1]-i[l+1])*s)};var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function getDefaultExportFromCjs(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var assignDeep$1={exports:{}};
/*!
   * assign-symbols <https://github.com/jonschlinkert/assign-symbols>
   *
   * Copyright (c) 2015-present, Jon Schlinkert.
   * Licensed under the MIT License.
   */const toString$2=Object.prototype.toString,isEnumerable=Object.prototype.propertyIsEnumerable,getSymbols=Object.getOwnPropertySymbols;var assignSymbols$1=(t,...e)=>{if(!isObject$1(t))throw new TypeError("expected the first argument to be an object");if(0===e.length||"function"!=typeof Symbol||"function"!=typeof getSymbols)return t;for(let i of e){let e=getSymbols(i);for(let r of e)isEnumerable.call(i,r)&&(t[r]=i[r])}return t};function isObject$1(t){return"function"==typeof t||"[object Object]"===toString$2.call(t)||Array.isArray(t)}
/*!
   * assign-deep <https://github.com/jonschlinkert/assign-deep>
   *
   * Copyright (c) 2017-present, Jon Schlinkert.
   * Released under the MIT License.
   */const toString$1=Object.prototype.toString,assignSymbols=assignSymbols$1,isValidKey=t=>"__proto__"!==t&&"constructor"!==t&&"prototype"!==t,assign=assignDeep$1.exports=(t,...e)=>{let i=0;for(isPrimitive(t)&&(t=e[i++]),t||(t={});i<e.length;i++)if(isObject(e[i])){for(const r of Object.keys(e[i]))isValidKey(r)&&(isObject(t[r])&&isObject(e[i][r])?assign(t[r],e[i][r]):t[r]=e[i][r]);assignSymbols(t,e[i])}return t};function isObject(t){return"function"==typeof t||"[object Object]"===toString$1.call(t)}function isPrimitive(t){return"object"==typeof t?null===t:"function"!=typeof t}var assignDeep=assignDeep$1.exports;const toString=Object.prototype.toString;function isAnyArray(t){return toString.call(t).endsWith("Array]")}function max(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var i=e.fromIndex,r=void 0===i?0:i,o=e.toIndex,n=void 0===o?t.length:o;if(r<0||r>=t.length||!Number.isInteger(r))throw new Error("fromIndex must be a positive integer smaller than length");if(n<=r||n>t.length||!Number.isInteger(n))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var s=t[r],l=r+1;l<n;l++)t[l]>s&&(s=t[l]);return s}function sumOfGaussianLorentzians(t){return function(e){let i=t.length/4,r=0;for(let o=0;o<i;o++)r+=t[o+i]*PseudoVoigt.fct(e-t[o],t[o+2*i],t[o+3*i]);return r}}function sumOfGaussians(t){return function(e){let i=t.length/3,r=0;for(let o=0;o<i;o++)r+=t[o+i]*Gaussian.fct(e-t[o],t[o+2*i]);return r}}function sumOfLorentzians(t){return function(e){let i=t.length/3,r=0;for(let o=0;o<i;o++)r+=t[o+i]*Lorentzian.fct(e-t[o],t[o+2*i]);return r}}function checkInput(t,e,i){let r,o,{shape:n={kind:"gaussian"},optimization:s={kind:"lm"}}=i;if("string"!=typeof n.kind)throw new Error("kind should be a string");switch(n.kind.toLowerCase().replace(/[^a-z]/g,"")){case"gaussian":r=sumOfGaussians,o={x:{init:t=>t.x,max:t=>t.x+2*t.width,min:t=>t.x-2*t.width,gradientDifference:t=>.002*t.width},y:{init:t=>t.y,max:()=>1.5,min:()=>0,gradientDifference:()=>.001},width:{init:t=>t.width,max:t=>4*t.width,min:t=>.25*t.width,gradientDifference:t=>.002*t.width}};break;case"lorentzian":r=sumOfLorentzians,o={x:{init:t=>t.x,max:t=>t.x+2*t.width,min:t=>t.x-2*t.width,gradientDifference:t=>.002*t.width},y:{init:t=>t.y,max:()=>1.5,min:()=>0,gradientDifference:()=>.001},width:{init:t=>t.width,max:t=>4*t.width,min:t=>.25*t.width,gradientDifference:t=>.002*t.width}};break;case"pseudovoigt":r=sumOfGaussianLorentzians,o={x:{init:t=>t.x,max:t=>t.x+2*t.width,min:t=>t.x-2*t.width,gradientDifference:t=>.002*t.width},y:{init:t=>t.y,max:()=>1.5,min:()=>0,gradientDifference:()=>.001},width:{init:t=>t.width,max:t=>4*t.width,min:t=>.25*t.width,gradientDifference:t=>.002*t.width},mu:{init:t=>void 0!==t.mu?t.mu:.5,min:()=>0,max:()=>1,gradientDifference:()=>.01}};break;default:throw new Error("kind of shape is not supported")}let l=t.x,a=max(t.y),u=new Array(l.length);for(let e=0;e<l.length;e++)u[e]=t.y[e]/a;for(let t=0;t<e.length;t++)e[t].y/=a;let h=assignDeep({},s.parameters,o);for(let t in h)for(let i in h[t]){if(Array.isArray(h[t][i])||(h[t][i]=[h[t][i]]),1!==h[t][i].length&&h[t][i].length!==e.length)throw new Error(`The length of ${t}-${i} is not correct`);for(let e=0;e<h[t][i].length;e++)if("number"==typeof h[t][i][e]){let r=h[t][i][e];h[t][i][e]=()=>r}}return s.parameters=h,{y:u,x:l,maxY:a,peaks:e,paramsFunc:r,optimization:s}}function checkOptions$1(t,e,i){let{timeout:r,minValues:o,maxValues:n,initialValues:s,weights:l=1,damping:a=.01,dampingStepUp:u=11,dampingStepDown:h=9,maxIterations:c=100,errorTolerance:f=1e-7,centralDifference:p=!1,gradientDifference:m=.1,improvementThreshold:g=.001}=i;if(a<=0)throw new Error("The damping option must be a positive number");if(!t.x||!t.y)throw new Error("The data parameter must have x and y elements");if(!isAnyArray(t.x)||t.x.length<2||!isAnyArray(t.y)||t.y.length<2)throw new Error("The data parameter elements must be an array with more than 2 points");if(t.x.length!==t.y.length)throw new Error("The data parameter elements must have the same size");let y,d,w=s||new Array(e.length).fill(1),x=t.y.length,b=w.length;if(n=n||new Array(b).fill(Number.MAX_SAFE_INTEGER),o=o||new Array(b).fill(Number.MIN_SAFE_INTEGER),n.length!==o.length)throw new Error("minValues and maxValues must be the same size");if(!isAnyArray(w))throw new Error("initialValues must be an array");if("number"==typeof m)m=new Array(w.length).fill(m);else{if(!isAnyArray(m))throw new Error("gradientDifference should be a number or array with length equal to the number of parameters");m.length!==b&&(m=new Array(b).fill(m[0]))}if("number"==typeof l){let t=1/l**2;y=()=>t}else{if(!isAnyArray(l))throw new Error("weights should be a number or array with length equal to the number of data points");if(l.length<t.x.length){let t=1/l[0]**2;y=()=>t}else y=t=>1/l[t]**2}if(void 0!==r){if("number"!=typeof r)throw new Error("timeout should be a number");let t=Date.now()+1e3*r;d=()=>Date.now()>t}else d=()=>!1;let M=new Array(t.x.length);for(let t=0;t<x;t++)M[t]=y(t);return{checkTimeout:d,minValues:o,maxValues:n,parameters:w,weightSquare:M,damping:a,dampingStepUp:u,dampingStepDown:h,maxIterations:c,errorTolerance:f,centralDifference:p,gradientDifference:m,improvementThreshold:g}}function errorCalculation(t,e,i,r){let o=0;const n=i(e);for(let e=0;e<t.x.length;e++)o+=Math.pow(t.y[e]-n(t.x[e]),2)/r[e];return o}function min(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var i=e.fromIndex,r=void 0===i?0:i,o=e.toIndex,n=void 0===o?t.length:o;if(r<0||r>=t.length||!Number.isInteger(r))throw new Error("fromIndex must be a positive integer smaller than length");if(n<=r||n>t.length||!Number.isInteger(n))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var s=t[r],l=r+1;l<n;l++)t[l]<s&&(s=t[l]);return s}function rescale(t){var e,i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(void 0!==i.output){if(!isAnyArray(i.output))throw new TypeError("output option must be an array if specified");e=i.output}else e=new Array(t.length);var r=min(t),o=max(t);if(r===o)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var n=i.min,s=void 0===n?i.autoMinMax?r:0:n,l=i.max,a=void 0===l?i.autoMinMax?o:1:l;if(s>=a)throw new RangeError("min option must be smaller than max option");for(var u=(a-s)/(o-r),h=0;h<t.length;h++)e[h]=(t[h]-r)*u+s;return e}const indent=" ".repeat(2),indentData=" ".repeat(4);function inspectMatrix(){return inspectMatrixWithOptions(this)}function inspectMatrixWithOptions(t,e={}){const{maxRows:i=15,maxColumns:r=10,maxNumSize:o=8}=e;return`${t.constructor.name} {\n${indent}[\n${indentData}${inspectData(t,i,r,o)}\n${indent}]\n${indent}rows: ${t.rows}\n${indent}columns: ${t.columns}\n}`}function inspectData(t,e,i,r){const{rows:o,columns:n}=t,s=Math.min(o,e),l=Math.min(n,i),a=[];for(let e=0;e<s;e++){let i=[];for(let o=0;o<l;o++)i.push(formatNumber(t.get(e,o),r));a.push(`${i.join(" ")}`)}return l!==n&&(a[a.length-1]+=` ... ${n-i} more columns`),s!==o&&a.push(`... ${o-e} more rows`),a.join(`\n${indentData}`)}function formatNumber(t,e){const i=String(t);if(i.length<=e)return i.padEnd(e," ");const r=t.toPrecision(e-2);if(r.length<=e)return r;const o=t.toExponential(e-2),n=o.indexOf("e"),s=o.slice(n);return o.slice(0,e-s.length)+s}function installMathOperations(t,e){t.prototype.add=function(t){return"number"==typeof t?this.addS(t):this.addM(t)},t.prototype.addS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)+t);return this},t.prototype.addM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)+t.get(e,i));return this},t.add=function(t,i){return new e(t).add(i)},t.prototype.sub=function(t){return"number"==typeof t?this.subS(t):this.subM(t)},t.prototype.subS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)-t);return this},t.prototype.subM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)-t.get(e,i));return this},t.sub=function(t,i){return new e(t).sub(i)},t.prototype.subtract=t.prototype.sub,t.prototype.subtractS=t.prototype.subS,t.prototype.subtractM=t.prototype.subM,t.subtract=t.sub,t.prototype.mul=function(t){return"number"==typeof t?this.mulS(t):this.mulM(t)},t.prototype.mulS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)*t);return this},t.prototype.mulM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)*t.get(e,i));return this},t.mul=function(t,i){return new e(t).mul(i)},t.prototype.multiply=t.prototype.mul,t.prototype.multiplyS=t.prototype.mulS,t.prototype.multiplyM=t.prototype.mulM,t.multiply=t.mul,t.prototype.div=function(t){return"number"==typeof t?this.divS(t):this.divM(t)},t.prototype.divS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)/t);return this},t.prototype.divM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)/t.get(e,i));return this},t.div=function(t,i){return new e(t).div(i)},t.prototype.divide=t.prototype.div,t.prototype.divideS=t.prototype.divS,t.prototype.divideM=t.prototype.divM,t.divide=t.div,t.prototype.mod=function(t){return"number"==typeof t?this.modS(t):this.modM(t)},t.prototype.modS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)%t);return this},t.prototype.modM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)%t.get(e,i));return this},t.mod=function(t,i){return new e(t).mod(i)},t.prototype.modulus=t.prototype.mod,t.prototype.modulusS=t.prototype.modS,t.prototype.modulusM=t.prototype.modM,t.modulus=t.mod,t.prototype.and=function(t){return"number"==typeof t?this.andS(t):this.andM(t)},t.prototype.andS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)&t);return this},t.prototype.andM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)&t.get(e,i));return this},t.and=function(t,i){return new e(t).and(i)},t.prototype.or=function(t){return"number"==typeof t?this.orS(t):this.orM(t)},t.prototype.orS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)|t);return this},t.prototype.orM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)|t.get(e,i));return this},t.or=function(t,i){return new e(t).or(i)},t.prototype.xor=function(t){return"number"==typeof t?this.xorS(t):this.xorM(t)},t.prototype.xorS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)^t);return this},t.prototype.xorM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)^t.get(e,i));return this},t.xor=function(t,i){return new e(t).xor(i)},t.prototype.leftShift=function(t){return"number"==typeof t?this.leftShiftS(t):this.leftShiftM(t)},t.prototype.leftShiftS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)<<t);return this},t.prototype.leftShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)<<t.get(e,i));return this},t.leftShift=function(t,i){return new e(t).leftShift(i)},t.prototype.signPropagatingRightShift=function(t){return"number"==typeof t?this.signPropagatingRightShiftS(t):this.signPropagatingRightShiftM(t)},t.prototype.signPropagatingRightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)>>t);return this},t.prototype.signPropagatingRightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)>>t.get(e,i));return this},t.signPropagatingRightShift=function(t,i){return new e(t).signPropagatingRightShift(i)},t.prototype.rightShift=function(t){return"number"==typeof t?this.rightShiftS(t):this.rightShiftM(t)},t.prototype.rightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)>>>t);return this},t.prototype.rightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)>>>t.get(e,i));return this},t.rightShift=function(t,i){return new e(t).rightShift(i)},t.prototype.zeroFillRightShift=t.prototype.rightShift,t.prototype.zeroFillRightShiftS=t.prototype.rightShiftS,t.prototype.zeroFillRightShiftM=t.prototype.rightShiftM,t.zeroFillRightShift=t.rightShift,t.prototype.not=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,~this.get(t,e));return this},t.not=function(t){return new e(t).not()},t.prototype.abs=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.abs(this.get(t,e)));return this},t.abs=function(t){return new e(t).abs()},t.prototype.acos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acos(this.get(t,e)));return this},t.acos=function(t){return new e(t).acos()},t.prototype.acosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acosh(this.get(t,e)));return this},t.acosh=function(t){return new e(t).acosh()},t.prototype.asin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asin(this.get(t,e)));return this},t.asin=function(t){return new e(t).asin()},t.prototype.asinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asinh(this.get(t,e)));return this},t.asinh=function(t){return new e(t).asinh()},t.prototype.atan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atan(this.get(t,e)));return this},t.atan=function(t){return new e(t).atan()},t.prototype.atanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atanh(this.get(t,e)));return this},t.atanh=function(t){return new e(t).atanh()},t.prototype.cbrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cbrt(this.get(t,e)));return this},t.cbrt=function(t){return new e(t).cbrt()},t.prototype.ceil=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.ceil(this.get(t,e)));return this},t.ceil=function(t){return new e(t).ceil()},t.prototype.clz32=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.clz32(this.get(t,e)));return this},t.clz32=function(t){return new e(t).clz32()},t.prototype.cos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cos(this.get(t,e)));return this},t.cos=function(t){return new e(t).cos()},t.prototype.cosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cosh(this.get(t,e)));return this},t.cosh=function(t){return new e(t).cosh()},t.prototype.exp=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.exp(this.get(t,e)));return this},t.exp=function(t){return new e(t).exp()},t.prototype.expm1=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.expm1(this.get(t,e)));return this},t.expm1=function(t){return new e(t).expm1()},t.prototype.floor=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.floor(this.get(t,e)));return this},t.floor=function(t){return new e(t).floor()},t.prototype.fround=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.fround(this.get(t,e)));return this},t.fround=function(t){return new e(t).fround()},t.prototype.log=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log(this.get(t,e)));return this},t.log=function(t){return new e(t).log()},t.prototype.log1p=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log1p(this.get(t,e)));return this},t.log1p=function(t){return new e(t).log1p()},t.prototype.log10=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log10(this.get(t,e)));return this},t.log10=function(t){return new e(t).log10()},t.prototype.log2=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log2(this.get(t,e)));return this},t.log2=function(t){return new e(t).log2()},t.prototype.round=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.round(this.get(t,e)));return this},t.round=function(t){return new e(t).round()},t.prototype.sign=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sign(this.get(t,e)));return this},t.sign=function(t){return new e(t).sign()},t.prototype.sin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sin(this.get(t,e)));return this},t.sin=function(t){return new e(t).sin()},t.prototype.sinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sinh(this.get(t,e)));return this},t.sinh=function(t){return new e(t).sinh()},t.prototype.sqrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sqrt(this.get(t,e)));return this},t.sqrt=function(t){return new e(t).sqrt()},t.prototype.tan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tan(this.get(t,e)));return this},t.tan=function(t){return new e(t).tan()},t.prototype.tanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tanh(this.get(t,e)));return this},t.tanh=function(t){return new e(t).tanh()},t.prototype.trunc=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.trunc(this.get(t,e)));return this},t.trunc=function(t){return new e(t).trunc()},t.pow=function(t,i){return new e(t).pow(i)},t.prototype.pow=function(t){return"number"==typeof t?this.powS(t):this.powM(t)},t.prototype.powS=function(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,Math.pow(this.get(e,i),t));return this},t.prototype.powM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,Math.pow(this.get(e,i),t.get(e,i)));return this}}function checkRowIndex(t,e,i){let r=i?t.rows:t.rows-1;if(e<0||e>r)throw new RangeError("Row index out of range")}function checkColumnIndex(t,e,i){let r=i?t.columns:t.columns-1;if(e<0||e>r)throw new RangeError("Column index out of range")}function checkRowVector(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.columns)throw new RangeError("vector size must be the same as the number of columns");return e}function checkColumnVector(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.rows)throw new RangeError("vector size must be the same as the number of rows");return e}function checkIndices(t,e,i){return{row:checkRowIndices(t,e),column:checkColumnIndices(t,i)}}function checkRowIndices(t,e){if("object"!=typeof e)throw new TypeError("unexpected type for row indices");if(e.some((e=>e<0||e>=t.rows)))throw new RangeError("row indices are out of range");return Array.isArray(e)||(e=Array.from(e)),e}function checkColumnIndices(t,e){if("object"!=typeof e)throw new TypeError("unexpected type for column indices");if(e.some((e=>e<0||e>=t.columns)))throw new RangeError("column indices are out of range");return Array.isArray(e)||(e=Array.from(e)),e}function checkRange(t,e,i,r,o){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(checkNumber("startRow",e),checkNumber("endRow",i),checkNumber("startColumn",r),checkNumber("endColumn",o),e>i||r>o||e<0||e>=t.rows||i<0||i>=t.rows||r<0||r>=t.columns||o<0||o>=t.columns)throw new RangeError("Submatrix indices are out of range")}function newArray$1(t,e=0){let i=[];for(let r=0;r<t;r++)i.push(e);return i}function checkNumber(t,e){if("number"!=typeof e)throw new TypeError(`${t} must be a number`)}function checkNonEmpty(t){if(t.isEmpty())throw new Error("Empty matrix has no elements to index")}function sumByRow(t){let e=newArray$1(t.rows);for(let i=0;i<t.rows;++i)for(let r=0;r<t.columns;++r)e[i]+=t.get(i,r);return e}function sumByColumn(t){let e=newArray$1(t.columns);for(let i=0;i<t.rows;++i)for(let r=0;r<t.columns;++r)e[r]+=t.get(i,r);return e}function sumAll(t){let e=0;for(let i=0;i<t.rows;i++)for(let r=0;r<t.columns;r++)e+=t.get(i,r);return e}function productByRow(t){let e=newArray$1(t.rows,1);for(let i=0;i<t.rows;++i)for(let r=0;r<t.columns;++r)e[i]*=t.get(i,r);return e}function productByColumn(t){let e=newArray$1(t.columns,1);for(let i=0;i<t.rows;++i)for(let r=0;r<t.columns;++r)e[r]*=t.get(i,r);return e}function productAll(t){let e=1;for(let i=0;i<t.rows;i++)for(let r=0;r<t.columns;r++)e*=t.get(i,r);return e}function varianceByRow(t,e,i){const r=t.rows,o=t.columns,n=[];for(let s=0;s<r;s++){let r=0,l=0,a=0;for(let e=0;e<o;e++)a=t.get(s,e)-i[s],r+=a,l+=a*a;e?n.push((l-r*r/o)/(o-1)):n.push((l-r*r/o)/o)}return n}function varianceByColumn(t,e,i){const r=t.rows,o=t.columns,n=[];for(let s=0;s<o;s++){let o=0,l=0,a=0;for(let e=0;e<r;e++)a=t.get(e,s)-i[s],o+=a,l+=a*a;e?n.push((l-o*o/r)/(r-1)):n.push((l-o*o/r)/r)}return n}function varianceAll(t,e,i){const r=t.rows,o=t.columns,n=r*o;let s=0,l=0,a=0;for(let e=0;e<r;e++)for(let r=0;r<o;r++)a=t.get(e,r)-i,s+=a,l+=a*a;return e?(l-s*s/n)/(n-1):(l-s*s/n)/n}function centerByRow(t,e){for(let i=0;i<t.rows;i++)for(let r=0;r<t.columns;r++)t.set(i,r,t.get(i,r)-e[i])}function centerByColumn(t,e){for(let i=0;i<t.rows;i++)for(let r=0;r<t.columns;r++)t.set(i,r,t.get(i,r)-e[r])}function centerAll(t,e){for(let i=0;i<t.rows;i++)for(let r=0;r<t.columns;r++)t.set(i,r,t.get(i,r)-e)}function getScaleByRow(t){const e=[];for(let i=0;i<t.rows;i++){let r=0;for(let e=0;e<t.columns;e++)r+=Math.pow(t.get(i,e),2)/(t.columns-1);e.push(Math.sqrt(r))}return e}function scaleByRow(t,e){for(let i=0;i<t.rows;i++)for(let r=0;r<t.columns;r++)t.set(i,r,t.get(i,r)/e[i])}function getScaleByColumn(t){const e=[];for(let i=0;i<t.columns;i++){let r=0;for(let e=0;e<t.rows;e++)r+=Math.pow(t.get(e,i),2)/(t.rows-1);e.push(Math.sqrt(r))}return e}function scaleByColumn(t,e){for(let i=0;i<t.rows;i++)for(let r=0;r<t.columns;r++)t.set(i,r,t.get(i,r)/e[r])}function getScaleAll(t){const e=t.size-1;let i=0;for(let r=0;r<t.columns;r++)for(let o=0;o<t.rows;o++)i+=Math.pow(t.get(o,r),2)/e;return Math.sqrt(i)}function scaleAll(t,e){for(let i=0;i<t.rows;i++)for(let r=0;r<t.columns;r++)t.set(i,r,t.get(i,r)/e)}class AbstractMatrix{static from1DArray(t,e,i){if(t*e!==i.length)throw new RangeError("data length does not match given dimensions");let r=new Matrix(t,e);for(let o=0;o<t;o++)for(let t=0;t<e;t++)r.set(o,t,i[o*e+t]);return r}static rowVector(t){let e=new Matrix(1,t.length);for(let i=0;i<t.length;i++)e.set(0,i,t[i]);return e}static columnVector(t){let e=new Matrix(t.length,1);for(let i=0;i<t.length;i++)e.set(i,0,t[i]);return e}static zeros(t,e){return new Matrix(t,e)}static ones(t,e){return new Matrix(t,e).fill(1)}static rand(t,e,i={}){if("object"!=typeof i)throw new TypeError("options must be an object");const{random:r=Math.random}=i;let o=new Matrix(t,e);for(let i=0;i<t;i++)for(let t=0;t<e;t++)o.set(i,t,r());return o}static randInt(t,e,i={}){if("object"!=typeof i)throw new TypeError("options must be an object");const{min:r=0,max:o=1e3,random:n=Math.random}=i;if(!Number.isInteger(r))throw new TypeError("min must be an integer");if(!Number.isInteger(o))throw new TypeError("max must be an integer");if(r>=o)throw new RangeError("min must be smaller than max");let s=o-r,l=new Matrix(t,e);for(let i=0;i<t;i++)for(let t=0;t<e;t++){let e=r+Math.round(n()*s);l.set(i,t,e)}return l}static eye(t,e,i){void 0===e&&(e=t),void 0===i&&(i=1);let r=Math.min(t,e),o=this.zeros(t,e);for(let t=0;t<r;t++)o.set(t,t,i);return o}static diag(t,e,i){let r=t.length;void 0===e&&(e=r),void 0===i&&(i=e);let o=Math.min(r,e,i),n=this.zeros(e,i);for(let e=0;e<o;e++)n.set(e,e,t[e]);return n}static min(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let i=t.rows,r=t.columns,o=new Matrix(i,r);for(let n=0;n<i;n++)for(let i=0;i<r;i++)o.set(n,i,Math.min(t.get(n,i),e.get(n,i)));return o}static max(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let i=t.rows,r=t.columns,o=new this(i,r);for(let n=0;n<i;n++)for(let i=0;i<r;i++)o.set(n,i,Math.max(t.get(n,i),e.get(n,i)));return o}static checkMatrix(t){return AbstractMatrix.isMatrix(t)?t:new Matrix(t)}static isMatrix(t){return null!=t&&"Matrix"===t.klass}get size(){return this.rows*this.columns}apply(t){if("function"!=typeof t)throw new TypeError("callback must be a function");for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)t.call(this,e,i);return this}to1DArray(){let t=[];for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)t.push(this.get(e,i));return t}to2DArray(){let t=[];for(let e=0;e<this.rows;e++){t.push([]);for(let i=0;i<this.columns;i++)t[e].push(this.get(e,i))}return t}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let t=0;t<this.rows;t++)for(let e=0;e<=t;e++)if(this.get(t,e)!==this.get(e,t))return!1;return!0}return!1}isEchelonForm(){let t=0,e=0,i=-1,r=!0,o=!1;for(;t<this.rows&&r;){for(e=0,o=!1;e<this.columns&&!1===o;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>i?(o=!0,i=e):(r=!1,o=!0);t++}return r}isReducedEchelonForm(){let t=0,e=0,i=-1,r=!0,o=!1;for(;t<this.rows&&r;){for(e=0,o=!1;e<this.columns&&!1===o;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>i?(o=!0,i=e):(r=!1,o=!0);for(let i=e+1;i<this.rows;i++)0!==this.get(t,i)&&(r=!1);t++}return r}echelonForm(){let t=this.clone(),e=0,i=0;for(;e<t.rows&&i<t.columns;){let r=e;for(let o=e;o<t.rows;o++)t.get(o,i)>t.get(r,i)&&(r=o);if(0===t.get(r,i))i++;else{t.swapRows(e,r);let o=t.get(e,i);for(let r=i;r<t.columns;r++)t.set(e,r,t.get(e,r)/o);for(let r=e+1;r<t.rows;r++){let o=t.get(r,i)/t.get(e,i);t.set(r,i,0);for(let n=i+1;n<t.columns;n++)t.set(r,n,t.get(r,n)-t.get(e,n)*o)}e++,i++}}return t}reducedEchelonForm(){let t=this.echelonForm(),e=t.columns,i=t.rows,r=i-1;for(;r>=0;)if(0===t.maxRow(r))r--;else{let o=0,n=!1;for(;o<i&&!1===n;)1===t.get(r,o)?n=!0:o++;for(let i=0;i<r;i++){let n=t.get(i,o);for(let s=o;s<e;s++){let e=t.get(i,s)-n*t.get(r,s);t.set(i,s,e)}}r--}return t}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{rows:e=1,columns:i=1}=t;if(!Number.isInteger(e)||e<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(i)||i<=0)throw new TypeError("columns must be a positive integer");let r=new Matrix(this.rows*e,this.columns*i);for(let t=0;t<e;t++)for(let e=0;e<i;e++)r.setSubMatrix(this,this.rows*t,this.columns*e);return r}fill(t){for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,t);return this}neg(){return this.mulS(-1)}getRow(t){checkRowIndex(this,t);let e=[];for(let i=0;i<this.columns;i++)e.push(this.get(t,i));return e}getRowVector(t){return Matrix.rowVector(this.getRow(t))}setRow(t,e){checkRowIndex(this,t),e=checkRowVector(this,e);for(let i=0;i<this.columns;i++)this.set(t,i,e[i]);return this}swapRows(t,e){checkRowIndex(this,t),checkRowIndex(this,e);for(let i=0;i<this.columns;i++){let r=this.get(t,i);this.set(t,i,this.get(e,i)),this.set(e,i,r)}return this}getColumn(t){checkColumnIndex(this,t);let e=[];for(let i=0;i<this.rows;i++)e.push(this.get(i,t));return e}getColumnVector(t){return Matrix.columnVector(this.getColumn(t))}setColumn(t,e){checkColumnIndex(this,t),e=checkColumnVector(this,e);for(let i=0;i<this.rows;i++)this.set(i,t,e[i]);return this}swapColumns(t,e){checkColumnIndex(this,t),checkColumnIndex(this,e);for(let i=0;i<this.rows;i++){let r=this.get(i,t);this.set(i,t,this.get(i,e)),this.set(i,e,r)}return this}addRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)+t[i]);return this}subRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)-t[i]);return this}mulRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)*t[i]);return this}divRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)/t[i]);return this}addColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)+t[e]);return this}subColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)-t[e]);return this}mulColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)*t[e]);return this}divColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.set(e,i,this.get(e,i)/t[e]);return this}mulRow(t,e){checkRowIndex(this,t);for(let i=0;i<this.columns;i++)this.set(t,i,this.get(t,i)*e);return this}mulColumn(t,e){checkColumnIndex(this,t);for(let i=0;i<this.rows;i++)this.set(i,t,this.get(i,t)*e);return this}max(){if(this.isEmpty())return NaN;let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.get(e,i)>t&&(t=this.get(e,i));return t}maxIndex(){checkNonEmpty(this);let t=this.get(0,0),e=[0,0];for(let i=0;i<this.rows;i++)for(let r=0;r<this.columns;r++)this.get(i,r)>t&&(t=this.get(i,r),e[0]=i,e[1]=r);return e}min(){if(this.isEmpty())return NaN;let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.get(e,i)<t&&(t=this.get(e,i));return t}minIndex(){checkNonEmpty(this);let t=this.get(0,0),e=[0,0];for(let i=0;i<this.rows;i++)for(let r=0;r<this.columns;r++)this.get(i,r)<t&&(t=this.get(i,r),e[0]=i,e[1]=r);return e}maxRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let i=1;i<this.columns;i++)this.get(t,i)>e&&(e=this.get(t,i));return e}maxRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let e=this.get(t,0),i=[t,0];for(let r=1;r<this.columns;r++)this.get(t,r)>e&&(e=this.get(t,r),i[1]=r);return i}minRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let i=1;i<this.columns;i++)this.get(t,i)<e&&(e=this.get(t,i));return e}minRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let e=this.get(t,0),i=[t,0];for(let r=1;r<this.columns;r++)this.get(t,r)<e&&(e=this.get(t,r),i[1]=r);return i}maxColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let i=1;i<this.rows;i++)this.get(i,t)>e&&(e=this.get(i,t));return e}maxColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let e=this.get(0,t),i=[0,t];for(let r=1;r<this.rows;r++)this.get(r,t)>e&&(e=this.get(r,t),i[0]=r);return i}minColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let i=1;i<this.rows;i++)this.get(i,t)<e&&(e=this.get(i,t));return e}minColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let e=this.get(0,t),i=[0,t];for(let r=1;r<this.rows;r++)this.get(r,t)<e&&(e=this.get(r,t),i[0]=r);return i}diag(){let t=Math.min(this.rows,this.columns),e=[];for(let i=0;i<t;i++)e.push(this.get(i,i));return e}norm(t="frobenius"){let e=0;if("max"===t)return this.max();if("frobenius"===t){for(let t=0;t<this.rows;t++)for(let i=0;i<this.columns;i++)e+=this.get(t,i)*this.get(t,i);return Math.sqrt(e)}throw new RangeError(`unknown norm type: ${t}`)}cumulativeSum(){let t=0;for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)t+=this.get(e,i),this.set(e,i,t);return this}dot(t){AbstractMatrix.isMatrix(t)&&(t=t.to1DArray());let e=this.to1DArray();if(e.length!==t.length)throw new RangeError("vectors do not have the same size");let i=0;for(let r=0;r<e.length;r++)i+=e[r]*t[r];return i}mmul(t){t=Matrix.checkMatrix(t);let e=this.rows,i=this.columns,r=t.columns,o=new Matrix(e,r),n=new Float64Array(i);for(let s=0;s<r;s++){for(let e=0;e<i;e++)n[e]=t.get(e,s);for(let t=0;t<e;t++){let e=0;for(let r=0;r<i;r++)e+=this.get(t,r)*n[r];o.set(t,s,e)}}return o}strassen2x2(t){t=Matrix.checkMatrix(t);let e=new Matrix(2,2);const i=this.get(0,0),r=t.get(0,0),o=this.get(0,1),n=t.get(0,1),s=this.get(1,0),l=t.get(1,0),a=this.get(1,1),u=t.get(1,1),h=(i+a)*(r+u),c=(s+a)*r,f=i*(n-u),p=a*(l-r),m=(i+o)*u,g=h+p-m+(o-a)*(l+u),y=f+m,d=c+p,w=h-c+f+(s-i)*(r+n);return e.set(0,0,g),e.set(0,1,y),e.set(1,0,d),e.set(1,1,w),e}strassen3x3(t){t=Matrix.checkMatrix(t);let e=new Matrix(3,3);const i=this.get(0,0),r=this.get(0,1),o=this.get(0,2),n=this.get(1,0),s=this.get(1,1),l=this.get(1,2),a=this.get(2,0),u=this.get(2,1),h=this.get(2,2),c=t.get(0,0),f=t.get(0,1),p=t.get(0,2),m=t.get(1,0),g=t.get(1,1),y=t.get(1,2),d=t.get(2,0),w=t.get(2,1),x=t.get(2,2),b=(i-n)*(-f+g),M=(-i+n+s)*(c-f+g),C=(n+s)*(-c+f),v=i*c,A=(-i+a+u)*(c-p+y),H=(-i+a)*(p-y),k=(a+u)*(-c+p),E=(-o+u+h)*(g+d-w),S=(o-h)*(g-w),N=o*d,F=(u+h)*(-d+w),I=(-o+s+l)*(y+d-x),D=(o-l)*(y-x),R=(s+l)*(-d+x),T=v+N+r*m,O=(i+r+o-n-s-u-h)*g+M+C+v+E+N+F,P=v+A+k+(i+r+o-s-l-a-u)*y+N+I+R,_=b+s*(-c+f+m-g-y-d+x)+M+v+N+I+D,L=b+M+C+v+l*w,z=N+I+D+R+n*p,q=v+A+H+u*(-c+p+m-g-y-d+w)+E+S+N,j=E+S+N+F+a*f,X=v+A+H+k+h*x;return e.set(0,0,T),e.set(0,1,O),e.set(0,2,P),e.set(1,0,_),e.set(1,1,L),e.set(1,2,z),e.set(2,0,q),e.set(2,1,j),e.set(2,2,X),e}mmulStrassen(t){t=Matrix.checkMatrix(t);let e=this.clone(),i=e.rows,r=e.columns,o=t.rows,n=t.columns;function s(t,e,i){let r=t.rows,o=t.columns;if(r===e&&o===i)return t;{let r=AbstractMatrix.zeros(e,i);return r=r.setSubMatrix(t,0,0),r}}r!==o&&console.warn(`Multiplying ${i} x ${r} and ${o} x ${n} matrix: dimensions do not match.`);let l=Math.max(i,o),a=Math.max(r,n);return e=s(e,l,a),function t(e,i,r,o){if(r<=512||o<=512)return e.mmul(i);r%2==1&&o%2==1?(e=s(e,r+1,o+1),i=s(i,r+1,o+1)):r%2==1?(e=s(e,r+1,o),i=s(i,r+1,o)):o%2==1&&(e=s(e,r,o+1),i=s(i,r,o+1));let n=parseInt(e.rows/2,10),l=parseInt(e.columns/2,10),a=e.subMatrix(0,n-1,0,l-1),u=i.subMatrix(0,n-1,0,l-1),h=e.subMatrix(0,n-1,l,e.columns-1),c=i.subMatrix(0,n-1,l,i.columns-1),f=e.subMatrix(n,e.rows-1,0,l-1),p=i.subMatrix(n,i.rows-1,0,l-1),m=e.subMatrix(n,e.rows-1,l,e.columns-1),g=i.subMatrix(n,i.rows-1,l,i.columns-1),y=t(AbstractMatrix.add(a,m),AbstractMatrix.add(u,g),n,l),d=t(AbstractMatrix.add(f,m),u,n,l),w=t(a,AbstractMatrix.sub(c,g),n,l),x=t(m,AbstractMatrix.sub(p,u),n,l),b=t(AbstractMatrix.add(a,h),g,n,l),M=t(AbstractMatrix.sub(f,a),AbstractMatrix.add(u,c),n,l),C=t(AbstractMatrix.sub(h,m),AbstractMatrix.add(p,g),n,l),v=AbstractMatrix.add(y,x);v.sub(b),v.add(C);let A=AbstractMatrix.add(w,b),H=AbstractMatrix.add(d,x),k=AbstractMatrix.sub(y,d);k.add(w),k.add(M);let E=AbstractMatrix.zeros(2*v.rows,2*v.columns);return E=E.setSubMatrix(v,0,0),E=E.setSubMatrix(A,v.rows,0),E=E.setSubMatrix(H,0,v.columns),E=E.setSubMatrix(k,v.rows,v.columns),E.subMatrix(0,r-1,0,o-1)}(e,t=s(t,l,a),l,a)}scaleRows(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:i=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(i))throw new TypeError("max must be a number");if(e>=i)throw new RangeError("min must be smaller than max");let r=new Matrix(this.rows,this.columns);for(let t=0;t<this.rows;t++){const o=this.getRow(t);o.length>0&&rescale(o,{min:e,max:i,output:o}),r.setRow(t,o)}return r}scaleColumns(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:i=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(i))throw new TypeError("max must be a number");if(e>=i)throw new RangeError("min must be smaller than max");let r=new Matrix(this.rows,this.columns);for(let t=0;t<this.columns;t++){const o=this.getColumn(t);o.length&&rescale(o,{min:e,max:i,output:o}),r.setColumn(t,o)}return r}flipRows(){const t=Math.ceil(this.columns/2);for(let e=0;e<this.rows;e++)for(let i=0;i<t;i++){let t=this.get(e,i),r=this.get(e,this.columns-1-i);this.set(e,i,r),this.set(e,this.columns-1-i,t)}return this}flipColumns(){const t=Math.ceil(this.rows/2);for(let e=0;e<this.columns;e++)for(let i=0;i<t;i++){let t=this.get(i,e),r=this.get(this.rows-1-i,e);this.set(i,e,r),this.set(this.rows-1-i,e,t)}return this}kroneckerProduct(t){t=Matrix.checkMatrix(t);let e=this.rows,i=this.columns,r=t.rows,o=t.columns,n=new Matrix(e*r,i*o);for(let s=0;s<e;s++)for(let e=0;e<i;e++)for(let i=0;i<r;i++)for(let l=0;l<o;l++)n.set(r*s+i,o*e+l,this.get(s,e)*t.get(i,l));return n}kroneckerSum(t){if(t=Matrix.checkMatrix(t),!this.isSquare()||!t.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let e=this.rows,i=t.rows,r=this.kroneckerProduct(Matrix.eye(i,i)),o=Matrix.eye(e,e).kroneckerProduct(t);return r.add(o)}transpose(){let t=new Matrix(this.columns,this.rows);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)t.set(i,e,this.get(e,i));return t}sortRows(t=compareNumbers){for(let e=0;e<this.rows;e++)this.setRow(e,this.getRow(e).sort(t));return this}sortColumns(t=compareNumbers){for(let e=0;e<this.columns;e++)this.setColumn(e,this.getColumn(e).sort(t));return this}subMatrix(t,e,i,r){checkRange(this,t,e,i,r);let o=new Matrix(e-t+1,r-i+1);for(let n=t;n<=e;n++)for(let e=i;e<=r;e++)o.set(n-t,e-i,this.get(n,e));return o}subMatrixRow(t,e,i){if(void 0===e&&(e=0),void 0===i&&(i=this.columns-1),e>i||e<0||e>=this.columns||i<0||i>=this.columns)throw new RangeError("Argument out of range");let r=new Matrix(t.length,i-e+1);for(let o=0;o<t.length;o++)for(let n=e;n<=i;n++){if(t[o]<0||t[o]>=this.rows)throw new RangeError(`Row index out of range: ${t[o]}`);r.set(o,n-e,this.get(t[o],n))}return r}subMatrixColumn(t,e,i){if(void 0===e&&(e=0),void 0===i&&(i=this.rows-1),e>i||e<0||e>=this.rows||i<0||i>=this.rows)throw new RangeError("Argument out of range");let r=new Matrix(i-e+1,t.length);for(let o=0;o<t.length;o++)for(let n=e;n<=i;n++){if(t[o]<0||t[o]>=this.columns)throw new RangeError(`Column index out of range: ${t[o]}`);r.set(n-e,o,this.get(n,t[o]))}return r}setSubMatrix(t,e,i){if((t=Matrix.checkMatrix(t)).isEmpty())return this;checkRange(this,e,e+t.rows-1,i,i+t.columns-1);for(let r=0;r<t.rows;r++)for(let o=0;o<t.columns;o++)this.set(e+r,i+o,t.get(r,o));return this}selection(t,e){let i=checkIndices(this,t,e),r=new Matrix(t.length,e.length);for(let t=0;t<i.row.length;t++){let e=i.row[t];for(let o=0;o<i.column.length;o++){let n=i.column[o];r.set(t,o,this.get(e,n))}}return r}trace(){let t=Math.min(this.rows,this.columns),e=0;for(let i=0;i<t;i++)e+=this.get(i,i);return e}clone(){let t=new Matrix(this.rows,this.columns);for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)t.set(e,i,this.get(e,i));return t}sum(t){switch(t){case"row":return sumByRow(this);case"column":return sumByColumn(this);case void 0:return sumAll(this);default:throw new Error(`invalid option: ${t}`)}}product(t){switch(t){case"row":return productByRow(this);case"column":return productByColumn(this);case void 0:return productAll(this);default:throw new Error(`invalid option: ${t}`)}}mean(t){const e=this.sum(t);switch(t){case"row":for(let t=0;t<this.rows;t++)e[t]/=this.columns;return e;case"column":for(let t=0;t<this.columns;t++)e[t]/=this.rows;return e;case void 0:return e/this.size;default:throw new Error(`invalid option: ${t}`)}}variance(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{unbiased:i=!0,mean:r=this.mean(t)}=e;if("boolean"!=typeof i)throw new TypeError("unbiased must be a boolean");switch(t){case"row":if(!Array.isArray(r))throw new TypeError("mean must be an array");return varianceByRow(this,i,r);case"column":if(!Array.isArray(r))throw new TypeError("mean must be an array");return varianceByColumn(this,i,r);case void 0:if("number"!=typeof r)throw new TypeError("mean must be a number");return varianceAll(this,i,r);default:throw new Error(`invalid option: ${t}`)}}standardDeviation(t,e){"object"==typeof t&&(e=t,t=void 0);const i=this.variance(t,e);if(void 0===t)return Math.sqrt(i);for(let t=0;t<i.length;t++)i[t]=Math.sqrt(i[t]);return i}center(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{center:i=this.mean(t)}=e;switch(t){case"row":if(!Array.isArray(i))throw new TypeError("center must be an array");return centerByRow(this,i),this;case"column":if(!Array.isArray(i))throw new TypeError("center must be an array");return centerByColumn(this,i),this;case void 0:if("number"!=typeof i)throw new TypeError("center must be a number");return centerAll(this,i),this;default:throw new Error(`invalid option: ${t}`)}}scale(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");let i=e.scale;switch(t){case"row":if(void 0===i)i=getScaleByRow(this);else if(!Array.isArray(i))throw new TypeError("scale must be an array");return scaleByRow(this,i),this;case"column":if(void 0===i)i=getScaleByColumn(this);else if(!Array.isArray(i))throw new TypeError("scale must be an array");return scaleByColumn(this,i),this;case void 0:if(void 0===i)i=getScaleAll(this);else if("number"!=typeof i)throw new TypeError("scale must be a number");return scaleAll(this,i),this;default:throw new Error(`invalid option: ${t}`)}}toString(t){return inspectMatrixWithOptions(this,t)}}function compareNumbers(t,e){return t-e}AbstractMatrix.prototype.klass="Matrix","undefined"!=typeof Symbol&&(AbstractMatrix.prototype[Symbol.for("nodejs.util.inspect.custom")]=inspectMatrix),AbstractMatrix.random=AbstractMatrix.rand,AbstractMatrix.randomInt=AbstractMatrix.randInt,AbstractMatrix.diagonal=AbstractMatrix.diag,AbstractMatrix.prototype.diagonal=AbstractMatrix.prototype.diag,AbstractMatrix.identity=AbstractMatrix.eye,AbstractMatrix.prototype.negate=AbstractMatrix.prototype.neg,AbstractMatrix.prototype.tensorProduct=AbstractMatrix.prototype.kroneckerProduct;class Matrix extends AbstractMatrix{constructor(t,e){if(super(),Matrix.isMatrix(t))return t.clone();if(Number.isInteger(t)&&t>=0){if(this.data=[],!(Number.isInteger(e)&&e>=0))throw new TypeError("nColumns must be a positive integer");for(let i=0;i<t;i++)this.data.push(new Float64Array(e))}else{if(!Array.isArray(t))throw new TypeError("First argument must be a positive number or an array");{const i=t;if("number"!=typeof(e=(t=i.length)?i[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let r=0;r<t;r++){if(i[r].length!==e)throw new RangeError("Inconsistent array dimensions");this.data.push(Float64Array.from(i[r]))}}}this.rows=t,this.columns=e}set(t,e,i){return this.data[t][e]=i,this}get(t,e){return this.data[t][e]}removeRow(t){return checkRowIndex(this,t),this.data.splice(t,1),this.rows-=1,this}addRow(t,e){return void 0===e&&(e=t,t=this.rows),checkRowIndex(this,t,!0),e=Float64Array.from(checkRowVector(this,e)),this.data.splice(t,0,e),this.rows+=1,this}removeColumn(t){checkColumnIndex(this,t);for(let e=0;e<this.rows;e++){const i=new Float64Array(this.columns-1);for(let r=0;r<t;r++)i[r]=this.data[e][r];for(let r=t+1;r<this.columns;r++)i[r-1]=this.data[e][r];this.data[e]=i}return this.columns-=1,this}addColumn(t,e){void 0===e&&(e=t,t=this.columns),checkColumnIndex(this,t,!0),e=checkColumnVector(this,e);for(let i=0;i<this.rows;i++){const r=new Float64Array(this.columns+1);let o=0;for(;o<t;o++)r[o]=this.data[i][o];for(r[o++]=e[i];o<this.columns+1;o++)r[o]=this.data[i][o-1];this.data[i]=r}return this.columns+=1,this}}installMathOperations(AbstractMatrix,Matrix);class WrapperMatrix2D extends AbstractMatrix{constructor(t){super(),this.data=t,this.rows=t.length,this.columns=t[0].length}set(t,e,i){return this.data[t][e]=i,this}get(t,e){return this.data[t][e]}}class LuDecomposition{constructor(t){let e,i,r,o,n,s,l,a,u,h=(t=WrapperMatrix2D.checkMatrix(t)).clone(),c=h.rows,f=h.columns,p=new Float64Array(c),m=1;for(e=0;e<c;e++)p[e]=e;for(a=new Float64Array(c),i=0;i<f;i++){for(e=0;e<c;e++)a[e]=h.get(e,i);for(e=0;e<c;e++){for(u=Math.min(e,i),n=0,r=0;r<u;r++)n+=h.get(e,r)*a[r];a[e]-=n,h.set(e,i,a[e])}for(o=i,e=i+1;e<c;e++)Math.abs(a[e])>Math.abs(a[o])&&(o=e);if(o!==i){for(r=0;r<f;r++)s=h.get(o,r),h.set(o,r,h.get(i,r)),h.set(i,r,s);l=p[o],p[o]=p[i],p[i]=l,m=-m}if(i<c&&0!==h.get(i,i))for(e=i+1;e<c;e++)h.set(e,i,h.get(e,i)/h.get(i,i))}this.LU=h,this.pivotVector=p,this.pivotSign=m}isSingular(){let t=this.LU,e=t.columns;for(let i=0;i<e;i++)if(0===t.get(i,i))return!0;return!1}solve(t){t=Matrix.checkMatrix(t);let e=this.LU;if(e.rows!==t.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let i,r,o,n=t.columns,s=t.subMatrixRow(this.pivotVector,0,n-1),l=e.columns;for(o=0;o<l;o++)for(i=o+1;i<l;i++)for(r=0;r<n;r++)s.set(i,r,s.get(i,r)-s.get(o,r)*e.get(i,o));for(o=l-1;o>=0;o--){for(r=0;r<n;r++)s.set(o,r,s.get(o,r)/e.get(o,o));for(i=0;i<o;i++)for(r=0;r<n;r++)s.set(i,r,s.get(i,r)-s.get(o,r)*e.get(i,o))}return s}get determinant(){let t=this.LU;if(!t.isSquare())throw new Error("Matrix must be square");let e=this.pivotSign,i=t.columns;for(let r=0;r<i;r++)e*=t.get(r,r);return e}get lowerTriangularMatrix(){let t=this.LU,e=t.rows,i=t.columns,r=new Matrix(e,i);for(let o=0;o<e;o++)for(let e=0;e<i;e++)o>e?r.set(o,e,t.get(o,e)):o===e?r.set(o,e,1):r.set(o,e,0);return r}get upperTriangularMatrix(){let t=this.LU,e=t.rows,i=t.columns,r=new Matrix(e,i);for(let o=0;o<e;o++)for(let e=0;e<i;e++)o<=e?r.set(o,e,t.get(o,e)):r.set(o,e,0);return r}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function hypotenuse(t,e){let i=0;return Math.abs(t)>Math.abs(e)?(i=e/t,Math.abs(t)*Math.sqrt(1+i*i)):0!==e?(i=t/e,Math.abs(e)*Math.sqrt(1+i*i)):0}class QrDecomposition{constructor(t){let e,i,r,o,n=(t=WrapperMatrix2D.checkMatrix(t)).clone(),s=t.rows,l=t.columns,a=new Float64Array(l);for(r=0;r<l;r++){let t=0;for(e=r;e<s;e++)t=hypotenuse(t,n.get(e,r));if(0!==t){for(n.get(r,r)<0&&(t=-t),e=r;e<s;e++)n.set(e,r,n.get(e,r)/t);for(n.set(r,r,n.get(r,r)+1),i=r+1;i<l;i++){for(o=0,e=r;e<s;e++)o+=n.get(e,r)*n.get(e,i);for(o=-o/n.get(r,r),e=r;e<s;e++)n.set(e,i,n.get(e,i)+o*n.get(e,r))}}a[r]=-t}this.QR=n,this.Rdiag=a}solve(t){t=Matrix.checkMatrix(t);let e=this.QR,i=e.rows;if(t.rows!==i)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let r,o,n,s,l=t.columns,a=t.clone(),u=e.columns;for(n=0;n<u;n++)for(o=0;o<l;o++){for(s=0,r=n;r<i;r++)s+=e.get(r,n)*a.get(r,o);for(s=-s/e.get(n,n),r=n;r<i;r++)a.set(r,o,a.get(r,o)+s*e.get(r,n))}for(n=u-1;n>=0;n--){for(o=0;o<l;o++)a.set(n,o,a.get(n,o)/this.Rdiag[n]);for(r=0;r<n;r++)for(o=0;o<l;o++)a.set(r,o,a.get(r,o)-a.get(n,o)*e.get(r,n))}return a.subMatrix(0,u-1,0,l-1)}isFullRank(){let t=this.QR.columns;for(let e=0;e<t;e++)if(0===this.Rdiag[e])return!1;return!0}get upperTriangularMatrix(){let t,e,i=this.QR,r=i.columns,o=new Matrix(r,r);for(t=0;t<r;t++)for(e=0;e<r;e++)t<e?o.set(t,e,i.get(t,e)):t===e?o.set(t,e,this.Rdiag[t]):o.set(t,e,0);return o}get orthogonalMatrix(){let t,e,i,r,o=this.QR,n=o.rows,s=o.columns,l=new Matrix(n,s);for(i=s-1;i>=0;i--){for(t=0;t<n;t++)l.set(t,i,0);for(l.set(i,i,1),e=i;e<s;e++)if(0!==o.get(i,i)){for(r=0,t=i;t<n;t++)r+=o.get(t,i)*l.get(t,e);for(r=-r/o.get(i,i),t=i;t<n;t++)l.set(t,e,l.get(t,e)+r*o.get(t,i))}}return l}}class SingularValueDecomposition{constructor(t,e={}){if((t=WrapperMatrix2D.checkMatrix(t)).isEmpty())throw new Error("Matrix must be non-empty");let i=t.rows,r=t.columns;const{computeLeftSingularVectors:o=!0,computeRightSingularVectors:n=!0,autoTranspose:s=!1}=e;let l,a=Boolean(o),u=Boolean(n),h=!1;if(i<r)if(s){l=t.transpose(),i=l.rows,r=l.columns,h=!0;let e=a;a=u,u=e}else l=t.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else l=t.clone();let c=Math.min(i,r),f=Math.min(i+1,r),p=new Float64Array(f),m=new Matrix(i,c),g=new Matrix(r,r),y=new Float64Array(r),d=new Float64Array(i),w=new Float64Array(f);for(let t=0;t<f;t++)w[t]=t;let x=Math.min(i-1,r),b=Math.max(0,Math.min(r-2,i)),M=Math.max(x,b);for(let t=0;t<M;t++){if(t<x){p[t]=0;for(let e=t;e<i;e++)p[t]=hypotenuse(p[t],l.get(e,t));if(0!==p[t]){l.get(t,t)<0&&(p[t]=-p[t]);for(let e=t;e<i;e++)l.set(e,t,l.get(e,t)/p[t]);l.set(t,t,l.get(t,t)+1)}p[t]=-p[t]}for(let e=t+1;e<r;e++){if(t<x&&0!==p[t]){let r=0;for(let o=t;o<i;o++)r+=l.get(o,t)*l.get(o,e);r=-r/l.get(t,t);for(let o=t;o<i;o++)l.set(o,e,l.get(o,e)+r*l.get(o,t))}y[e]=l.get(t,e)}if(a&&t<x)for(let e=t;e<i;e++)m.set(e,t,l.get(e,t));if(t<b){y[t]=0;for(let e=t+1;e<r;e++)y[t]=hypotenuse(y[t],y[e]);if(0!==y[t]){y[t+1]<0&&(y[t]=0-y[t]);for(let e=t+1;e<r;e++)y[e]/=y[t];y[t+1]+=1}if(y[t]=-y[t],t+1<i&&0!==y[t]){for(let e=t+1;e<i;e++)d[e]=0;for(let e=t+1;e<i;e++)for(let i=t+1;i<r;i++)d[e]+=y[i]*l.get(e,i);for(let e=t+1;e<r;e++){let r=-y[e]/y[t+1];for(let o=t+1;o<i;o++)l.set(o,e,l.get(o,e)+r*d[o])}}if(u)for(let e=t+1;e<r;e++)g.set(e,t,y[e])}}let C=Math.min(r,i+1);if(x<r&&(p[x]=l.get(x,x)),i<C&&(p[C-1]=0),b+1<C&&(y[b]=l.get(b,C-1)),y[C-1]=0,a){for(let t=x;t<c;t++){for(let e=0;e<i;e++)m.set(e,t,0);m.set(t,t,1)}for(let t=x-1;t>=0;t--)if(0!==p[t]){for(let e=t+1;e<c;e++){let r=0;for(let o=t;o<i;o++)r+=m.get(o,t)*m.get(o,e);r=-r/m.get(t,t);for(let o=t;o<i;o++)m.set(o,e,m.get(o,e)+r*m.get(o,t))}for(let e=t;e<i;e++)m.set(e,t,-m.get(e,t));m.set(t,t,1+m.get(t,t));for(let e=0;e<t-1;e++)m.set(e,t,0)}else{for(let e=0;e<i;e++)m.set(e,t,0);m.set(t,t,1)}}if(u)for(let t=r-1;t>=0;t--){if(t<b&&0!==y[t])for(let e=t+1;e<r;e++){let i=0;for(let o=t+1;o<r;o++)i+=g.get(o,t)*g.get(o,e);i=-i/g.get(t+1,t);for(let o=t+1;o<r;o++)g.set(o,e,g.get(o,e)+i*g.get(o,t))}for(let e=0;e<r;e++)g.set(e,t,0);g.set(t,t,1)}let v=C-1,A=Number.EPSILON;for(;C>0;){let t,e;for(t=C-2;t>=-1&&-1!==t;t--){const e=Number.MIN_VALUE+A*Math.abs(p[t]+Math.abs(p[t+1]));if(Math.abs(y[t])<=e||Number.isNaN(y[t])){y[t]=0;break}}if(t===C-2)e=4;else{let i;for(i=C-1;i>=t&&i!==t;i--){let e=(i!==C?Math.abs(y[i]):0)+(i!==t+1?Math.abs(y[i-1]):0);if(Math.abs(p[i])<=A*e){p[i]=0;break}}i===t?e=3:i===C-1?e=1:(e=2,t=i)}switch(t++,e){case 1:{let e=y[C-2];y[C-2]=0;for(let i=C-2;i>=t;i--){let o=hypotenuse(p[i],e),n=p[i]/o,s=e/o;if(p[i]=o,i!==t&&(e=-s*y[i-1],y[i-1]=n*y[i-1]),u)for(let t=0;t<r;t++)o=n*g.get(t,i)+s*g.get(t,C-1),g.set(t,C-1,-s*g.get(t,i)+n*g.get(t,C-1)),g.set(t,i,o)}break}case 2:{let e=y[t-1];y[t-1]=0;for(let r=t;r<C;r++){let o=hypotenuse(p[r],e),n=p[r]/o,s=e/o;if(p[r]=o,e=-s*y[r],y[r]=n*y[r],a)for(let e=0;e<i;e++)o=n*m.get(e,r)+s*m.get(e,t-1),m.set(e,t-1,-s*m.get(e,r)+n*m.get(e,t-1)),m.set(e,r,o)}break}case 3:{const e=Math.max(Math.abs(p[C-1]),Math.abs(p[C-2]),Math.abs(y[C-2]),Math.abs(p[t]),Math.abs(y[t])),o=p[C-1]/e,n=p[C-2]/e,s=y[C-2]/e,l=p[t]/e,h=y[t]/e,c=((n+o)*(n-o)+s*s)/2,f=o*s*(o*s);let d=0;0===c&&0===f||(d=c<0?0-Math.sqrt(c*c+f):Math.sqrt(c*c+f),d=f/(c+d));let w=(l+o)*(l-o)+d,x=l*h;for(let e=t;e<C-1;e++){let o=hypotenuse(w,x);0===o&&(o=Number.MIN_VALUE);let n=w/o,s=x/o;if(e!==t&&(y[e-1]=o),w=n*p[e]+s*y[e],y[e]=n*y[e]-s*p[e],x=s*p[e+1],p[e+1]=n*p[e+1],u)for(let t=0;t<r;t++)o=n*g.get(t,e)+s*g.get(t,e+1),g.set(t,e+1,-s*g.get(t,e)+n*g.get(t,e+1)),g.set(t,e,o);if(o=hypotenuse(w,x),0===o&&(o=Number.MIN_VALUE),n=w/o,s=x/o,p[e]=o,w=n*y[e]+s*p[e+1],p[e+1]=-s*y[e]+n*p[e+1],x=s*y[e+1],y[e+1]=n*y[e+1],a&&e<i-1)for(let t=0;t<i;t++)o=n*m.get(t,e)+s*m.get(t,e+1),m.set(t,e+1,-s*m.get(t,e)+n*m.get(t,e+1)),m.set(t,e,o)}y[C-2]=w;break}case 4:if(p[t]<=0&&(p[t]=p[t]<0?-p[t]:0,u))for(let e=0;e<=v;e++)g.set(e,t,-g.get(e,t));for(;t<v&&!(p[t]>=p[t+1]);){let e=p[t];if(p[t]=p[t+1],p[t+1]=e,u&&t<r-1)for(let i=0;i<r;i++)e=g.get(i,t+1),g.set(i,t+1,g.get(i,t)),g.set(i,t,e);if(a&&t<i-1)for(let r=0;r<i;r++)e=m.get(r,t+1),m.set(r,t+1,m.get(r,t)),m.set(r,t,e);t++}C--}}if(h){let t=g;g=m,m=t}this.m=i,this.n=r,this.s=p,this.U=m,this.V=g}solve(t){let e=t,i=this.threshold,r=this.s.length,o=Matrix.zeros(r,r);for(let t=0;t<r;t++)Math.abs(this.s[t])<=i?o.set(t,t,0):o.set(t,t,1/this.s[t]);let n=this.U,s=this.rightSingularVectors,l=s.mmul(o),a=s.rows,u=n.rows,h=Matrix.zeros(a,u);for(let t=0;t<a;t++)for(let e=0;e<u;e++){let i=0;for(let o=0;o<r;o++)i+=l.get(t,o)*n.get(e,o);h.set(t,e,i)}return h.mmul(e)}solveForDiagonal(t){return this.solve(Matrix.diag(t))}inverse(){let t=this.V,e=this.threshold,i=t.rows,r=t.columns,o=new Matrix(i,this.s.length);for(let n=0;n<i;n++)for(let i=0;i<r;i++)Math.abs(this.s[i])>e&&o.set(n,i,t.get(n,i)/this.s[i]);let n=this.U,s=n.rows,l=n.columns,a=new Matrix(i,s);for(let t=0;t<i;t++)for(let e=0;e<s;e++){let i=0;for(let r=0;r<l;r++)i+=o.get(t,r)*n.get(e,r);a.set(t,e,i)}return a}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let t=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,e=0,i=this.s;for(let r=0,o=i.length;r<o;r++)i[r]>t&&e++;return e}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return Matrix.diag(this.s)}}function inverse(t,e=!1){return t=WrapperMatrix2D.checkMatrix(t),e?new SingularValueDecomposition(t).inverse():solve(t,Matrix.eye(t.rows))}function solve(t,e,i=!1){return t=WrapperMatrix2D.checkMatrix(t),e=WrapperMatrix2D.checkMatrix(e),i?new SingularValueDecomposition(t).solve(e):t.isSquare()?new LuDecomposition(t).solve(e):new QrDecomposition(t).solve(e)}class EigenvalueDecomposition{constructor(t,e={}){const{assumeSymmetric:i=!1}=e;if(!(t=WrapperMatrix2D.checkMatrix(t)).isSquare())throw new Error("Matrix is not a square matrix");if(t.isEmpty())throw new Error("Matrix must be non-empty");let r,o,n=t.columns,s=new Matrix(n,n),l=new Float64Array(n),a=new Float64Array(n),u=t,h=!1;if(h=!!i||t.isSymmetric(),h){for(r=0;r<n;r++)for(o=0;o<n;o++)s.set(r,o,u.get(r,o));tred2(n,a,l,s),tql2(n,a,l,s)}else{let t=new Matrix(n,n),e=new Float64Array(n);for(o=0;o<n;o++)for(r=0;r<n;r++)t.set(r,o,u.get(r,o));orthes(n,t,e,s),hqr2(n,a,l,s,t)}this.n=n,this.e=a,this.d=l,this.V=s}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let t,e,i=this.n,r=this.e,o=this.d,n=new Matrix(i,i);for(t=0;t<i;t++){for(e=0;e<i;e++)n.set(t,e,0);n.set(t,t,o[t]),r[t]>0?n.set(t,t+1,r[t]):r[t]<0&&n.set(t,t-1,r[t])}return n}}function tred2(t,e,i,r){let o,n,s,l,a,u,h,c;for(a=0;a<t;a++)i[a]=r.get(t-1,a);for(l=t-1;l>0;l--){for(c=0,s=0,u=0;u<l;u++)c+=Math.abs(i[u]);if(0===c)for(e[l]=i[l-1],a=0;a<l;a++)i[a]=r.get(l-1,a),r.set(l,a,0),r.set(a,l,0);else{for(u=0;u<l;u++)i[u]/=c,s+=i[u]*i[u];for(o=i[l-1],n=Math.sqrt(s),o>0&&(n=-n),e[l]=c*n,s-=o*n,i[l-1]=o-n,a=0;a<l;a++)e[a]=0;for(a=0;a<l;a++){for(o=i[a],r.set(a,l,o),n=e[a]+r.get(a,a)*o,u=a+1;u<=l-1;u++)n+=r.get(u,a)*i[u],e[u]+=r.get(u,a)*o;e[a]=n}for(o=0,a=0;a<l;a++)e[a]/=s,o+=e[a]*i[a];for(h=o/(s+s),a=0;a<l;a++)e[a]-=h*i[a];for(a=0;a<l;a++){for(o=i[a],n=e[a],u=a;u<=l-1;u++)r.set(u,a,r.get(u,a)-(o*e[u]+n*i[u]));i[a]=r.get(l-1,a),r.set(l,a,0)}}i[l]=s}for(l=0;l<t-1;l++){if(r.set(t-1,l,r.get(l,l)),r.set(l,l,1),s=i[l+1],0!==s){for(u=0;u<=l;u++)i[u]=r.get(u,l+1)/s;for(a=0;a<=l;a++){for(n=0,u=0;u<=l;u++)n+=r.get(u,l+1)*r.get(u,a);for(u=0;u<=l;u++)r.set(u,a,r.get(u,a)-n*i[u])}}for(u=0;u<=l;u++)r.set(u,l+1,0)}for(a=0;a<t;a++)i[a]=r.get(t-1,a),r.set(t-1,a,0);r.set(t-1,t-1,1),e[0]=0}function tql2(t,e,i,r){let o,n,s,l,a,u,h,c,f,p,m,g,y,d,w,x;for(s=1;s<t;s++)e[s-1]=e[s];e[t-1]=0;let b=0,M=0,C=Number.EPSILON;for(u=0;u<t;u++){for(M=Math.max(M,Math.abs(i[u])+Math.abs(e[u])),h=u;h<t&&!(Math.abs(e[h])<=C*M);)h++;if(h>u)do{for(o=i[u],c=(i[u+1]-o)/(2*e[u]),f=hypotenuse(c,1),c<0&&(f=-f),i[u]=e[u]/(c+f),i[u+1]=e[u]*(c+f),p=i[u+1],n=o-i[u],s=u+2;s<t;s++)i[s]-=n;for(b+=n,c=i[h],m=1,g=m,y=m,d=e[u+1],w=0,x=0,s=h-1;s>=u;s--)for(y=g,g=m,x=w,o=m*e[s],n=m*c,f=hypotenuse(c,e[s]),e[s+1]=w*f,w=e[s]/f,m=c/f,c=m*i[s]-w*o,i[s+1]=n+w*(m*o+w*i[s]),a=0;a<t;a++)n=r.get(a,s+1),r.set(a,s+1,w*r.get(a,s)+m*n),r.set(a,s,m*r.get(a,s)-w*n);c=-w*x*y*d*e[u]/p,e[u]=w*c,i[u]=m*c}while(Math.abs(e[u])>C*M);i[u]=i[u]+b,e[u]=0}for(s=0;s<t-1;s++){for(a=s,c=i[s],l=s+1;l<t;l++)i[l]<c&&(a=l,c=i[l]);if(a!==s)for(i[a]=i[s],i[s]=c,l=0;l<t;l++)c=r.get(l,s),r.set(l,s,r.get(l,a)),r.set(l,a,c)}}function orthes(t,e,i,r){let o,n,s,l,a,u,h,c=t-1;for(u=1;u<=c-1;u++){for(h=0,l=u;l<=c;l++)h+=Math.abs(e.get(l,u-1));if(0!==h){for(s=0,l=c;l>=u;l--)i[l]=e.get(l,u-1)/h,s+=i[l]*i[l];for(n=Math.sqrt(s),i[u]>0&&(n=-n),s-=i[u]*n,i[u]=i[u]-n,a=u;a<t;a++){for(o=0,l=c;l>=u;l--)o+=i[l]*e.get(l,a);for(o/=s,l=u;l<=c;l++)e.set(l,a,e.get(l,a)-o*i[l])}for(l=0;l<=c;l++){for(o=0,a=c;a>=u;a--)o+=i[a]*e.get(l,a);for(o/=s,a=u;a<=c;a++)e.set(l,a,e.get(l,a)-o*i[a])}i[u]=h*i[u],e.set(u,u-1,h*n)}}for(l=0;l<t;l++)for(a=0;a<t;a++)r.set(l,a,l===a?1:0);for(u=c-1;u>=1;u--)if(0!==e.get(u,u-1)){for(l=u+1;l<=c;l++)i[l]=e.get(l,u-1);for(a=u;a<=c;a++){for(n=0,l=u;l<=c;l++)n+=i[l]*r.get(l,a);for(n=n/i[u]/e.get(u,u-1),l=u;l<=c;l++)r.set(l,a,r.get(l,a)+n*i[l])}}}function hqr2(t,e,i,r,o){let n,s,l,a,u,h,c,f,p,m,g,y,d,w,x,b=t-1,M=t-1,C=Number.EPSILON,v=0,A=0,H=0,k=0,E=0,S=0,N=0,F=0;for(n=0;n<t;n++)for((n<0||n>M)&&(i[n]=o.get(n,n),e[n]=0),s=Math.max(n-1,0);s<t;s++)A+=Math.abs(o.get(n,s));for(;b>=0;){for(a=b;a>0&&(S=Math.abs(o.get(a-1,a-1))+Math.abs(o.get(a,a)),0===S&&(S=A),!(Math.abs(o.get(a,a-1))<C*S));)a--;if(a===b)o.set(b,b,o.get(b,b)+v),i[b]=o.get(b,b),e[b]=0,b--,F=0;else if(a===b-1){if(c=o.get(b,b-1)*o.get(b-1,b),H=(o.get(b-1,b-1)-o.get(b,b))/2,k=H*H+c,N=Math.sqrt(Math.abs(k)),o.set(b,b,o.get(b,b)+v),o.set(b-1,b-1,o.get(b-1,b-1)+v),f=o.get(b,b),k>=0){for(N=H>=0?H+N:H-N,i[b-1]=f+N,i[b]=i[b-1],0!==N&&(i[b]=f-c/N),e[b-1]=0,e[b]=0,f=o.get(b,b-1),S=Math.abs(f)+Math.abs(N),H=f/S,k=N/S,E=Math.sqrt(H*H+k*k),H/=E,k/=E,s=b-1;s<t;s++)N=o.get(b-1,s),o.set(b-1,s,k*N+H*o.get(b,s)),o.set(b,s,k*o.get(b,s)-H*N);for(n=0;n<=b;n++)N=o.get(n,b-1),o.set(n,b-1,k*N+H*o.get(n,b)),o.set(n,b,k*o.get(n,b)-H*N);for(n=0;n<=M;n++)N=r.get(n,b-1),r.set(n,b-1,k*N+H*r.get(n,b)),r.set(n,b,k*r.get(n,b)-H*N)}else i[b-1]=f+H,i[b]=f+H,e[b-1]=N,e[b]=-N;b-=2,F=0}else{if(f=o.get(b,b),p=0,c=0,a<b&&(p=o.get(b-1,b-1),c=o.get(b,b-1)*o.get(b-1,b)),10===F){for(v+=f,n=0;n<=b;n++)o.set(n,n,o.get(n,n)-f);S=Math.abs(o.get(b,b-1))+Math.abs(o.get(b-1,b-2)),f=p=.75*S,c=-.4375*S*S}if(30===F&&(S=(p-f)/2,S=S*S+c,S>0)){for(S=Math.sqrt(S),p<f&&(S=-S),S=f-c/((p-f)/2+S),n=0;n<=b;n++)o.set(n,n,o.get(n,n)-S);v+=S,f=p=c=.964}for(F+=1,u=b-2;u>=a&&(N=o.get(u,u),E=f-N,S=p-N,H=(E*S-c)/o.get(u+1,u)+o.get(u,u+1),k=o.get(u+1,u+1)-N-E-S,E=o.get(u+2,u+1),S=Math.abs(H)+Math.abs(k)+Math.abs(E),H/=S,k/=S,E/=S,u!==a)&&!(Math.abs(o.get(u,u-1))*(Math.abs(k)+Math.abs(E))<C*(Math.abs(H)*(Math.abs(o.get(u-1,u-1))+Math.abs(N)+Math.abs(o.get(u+1,u+1)))));)u--;for(n=u+2;n<=b;n++)o.set(n,n-2,0),n>u+2&&o.set(n,n-3,0);for(l=u;l<=b-1&&(w=l!==b-1,l!==u&&(H=o.get(l,l-1),k=o.get(l+1,l-1),E=w?o.get(l+2,l-1):0,f=Math.abs(H)+Math.abs(k)+Math.abs(E),0!==f&&(H/=f,k/=f,E/=f)),0!==f);l++)if(S=Math.sqrt(H*H+k*k+E*E),H<0&&(S=-S),0!==S){for(l!==u?o.set(l,l-1,-S*f):a!==u&&o.set(l,l-1,-o.get(l,l-1)),H+=S,f=H/S,p=k/S,N=E/S,k/=H,E/=H,s=l;s<t;s++)H=o.get(l,s)+k*o.get(l+1,s),w&&(H+=E*o.get(l+2,s),o.set(l+2,s,o.get(l+2,s)-H*N)),o.set(l,s,o.get(l,s)-H*f),o.set(l+1,s,o.get(l+1,s)-H*p);for(n=0;n<=Math.min(b,l+3);n++)H=f*o.get(n,l)+p*o.get(n,l+1),w&&(H+=N*o.get(n,l+2),o.set(n,l+2,o.get(n,l+2)-H*E)),o.set(n,l,o.get(n,l)-H),o.set(n,l+1,o.get(n,l+1)-H*k);for(n=0;n<=M;n++)H=f*r.get(n,l)+p*r.get(n,l+1),w&&(H+=N*r.get(n,l+2),r.set(n,l+2,r.get(n,l+2)-H*E)),r.set(n,l,r.get(n,l)-H),r.set(n,l+1,r.get(n,l+1)-H*k)}}}if(0!==A){for(b=t-1;b>=0;b--)if(H=i[b],k=e[b],0===k)for(a=b,o.set(b,b,1),n=b-1;n>=0;n--){for(c=o.get(n,n)-H,E=0,s=a;s<=b;s++)E+=o.get(n,s)*o.get(s,b);if(e[n]<0)N=c,S=E;else if(a=n,0===e[n]?o.set(n,b,0!==c?-E/c:-E/(C*A)):(f=o.get(n,n+1),p=o.get(n+1,n),k=(i[n]-H)*(i[n]-H)+e[n]*e[n],h=(f*S-N*E)/k,o.set(n,b,h),o.set(n+1,b,Math.abs(f)>Math.abs(N)?(-E-c*h)/f:(-S-p*h)/N)),h=Math.abs(o.get(n,b)),C*h*h>1)for(s=n;s<=b;s++)o.set(s,b,o.get(s,b)/h)}else if(k<0)for(a=b-1,Math.abs(o.get(b,b-1))>Math.abs(o.get(b-1,b))?(o.set(b-1,b-1,k/o.get(b,b-1)),o.set(b-1,b,-(o.get(b,b)-H)/o.get(b,b-1))):(x=cdiv(0,-o.get(b-1,b),o.get(b-1,b-1)-H,k),o.set(b-1,b-1,x[0]),o.set(b-1,b,x[1])),o.set(b,b-1,0),o.set(b,b,1),n=b-2;n>=0;n--){for(m=0,g=0,s=a;s<=b;s++)m+=o.get(n,s)*o.get(s,b-1),g+=o.get(n,s)*o.get(s,b);if(c=o.get(n,n)-H,e[n]<0)N=c,E=m,S=g;else if(a=n,0===e[n]?(x=cdiv(-m,-g,c,k),o.set(n,b-1,x[0]),o.set(n,b,x[1])):(f=o.get(n,n+1),p=o.get(n+1,n),y=(i[n]-H)*(i[n]-H)+e[n]*e[n]-k*k,d=2*(i[n]-H)*k,0===y&&0===d&&(y=C*A*(Math.abs(c)+Math.abs(k)+Math.abs(f)+Math.abs(p)+Math.abs(N))),x=cdiv(f*E-N*m+k*g,f*S-N*g-k*m,y,d),o.set(n,b-1,x[0]),o.set(n,b,x[1]),Math.abs(f)>Math.abs(N)+Math.abs(k)?(o.set(n+1,b-1,(-m-c*o.get(n,b-1)+k*o.get(n,b))/f),o.set(n+1,b,(-g-c*o.get(n,b)-k*o.get(n,b-1))/f)):(x=cdiv(-E-p*o.get(n,b-1),-S-p*o.get(n,b),N,k),o.set(n+1,b-1,x[0]),o.set(n+1,b,x[1]))),h=Math.max(Math.abs(o.get(n,b-1)),Math.abs(o.get(n,b))),C*h*h>1)for(s=n;s<=b;s++)o.set(s,b-1,o.get(s,b-1)/h),o.set(s,b,o.get(s,b)/h)}for(n=0;n<t;n++)if(n<0||n>M)for(s=n;s<t;s++)r.set(n,s,o.get(n,s));for(s=t-1;s>=0;s--)for(n=0;n<=M;n++){for(N=0,l=0;l<=Math.min(s,M);l++)N+=r.get(n,l)*o.get(l,s);r.set(n,s,N)}}}function cdiv(t,e,i,r){let o,n;return Math.abs(i)>Math.abs(r)?(o=r/i,n=i+o*r,[(t+o*e)/n,(e-o*t)/n]):(o=i/r,n=r+o*i,[(o*t+e)/n,(o*e-t)/n])}function gradientFunction(t,e,i,r,o,n){const s=i.length,l=t.x.length;let a=Matrix.zeros(s,l),u=0;for(let h=0;h<s;h++){if(0===r[h])continue;let s=r[h],c=i.slice();c[h]+=s;let f=o(c);if(n){c=i.slice(),c[h]-=s,s*=2;let e=o(c);for(let i=0;i<l;i++)a.set(u,i,(e(t.x[i])-f(t.x[i]))/s)}else for(let i=0;i<l;i++)a.set(u,i,(e[i]-f(t.x[i]))/s);u++}return a}function matrixFunction(t,e){const i=t.x.length;let r=new Matrix(i,1);for(let o=0;o<i;o++)r.set(o,0,t.y[o]-e[o]);return r}function step(t,e,i,r,o,n,s){let l=i,a=Matrix.eye(e.length,e.length,l);const u=o(e);let h=new Float64Array(t.x.length);for(let e=0;e<t.x.length;e++)h[e]=u(t.x[e]);let c=gradientFunction(t,h,e,r,o,n),f=matrixFunction(t,h),p=inverse(a.add(c.mmul(c.transpose().scale("row",{scale:s})))),m=c.mmul(f.scale("row",{scale:s}));return{perturbations:p.mmul(m),jacobianWeigthResidualError:m}}function levenbergMarquardt(t,e,i={}){let{checkTimeout:r,minValues:o,maxValues:n,parameters:s,weightSquare:l,damping:a,dampingStepUp:u,dampingStepDown:h,maxIterations:c,errorTolerance:f,centralDifference:p,gradientDifference:m,improvementThreshold:g}=checkOptions$1(t,e,i),y=errorCalculation(t,s,e,l),d=y<=f,w=0;for(;w<c&&!d;w++){let c=y,{perturbations:w,jacobianWeigthResidualError:x}=step(t,s,a,m,e,p,l);for(let t=0;t<s.length;t++)s[t]=Math.min(Math.max(o[t],s[t]-w.get(t,0)),n[t]);if(y=errorCalculation(t,s,e,l),isNaN(y))break;if((c-y)/w.transpose().mmul(w.mulS(a).add(x)).get(0,0)>g?a=Math.max(a/h,1e-7):(y=c,a=Math.min(a*u,1e7)),r())throw new Error(`The execution time is over to ${i.timeout} seconds`);d=y<=f}return{parameterValues:s,parameterError:y,iterations:w}}const LEVENBERG_MARQUARDT=1;function selectMethod(t={}){let{kind:e,options:i}=t;switch(e=getKind(e),e){case LEVENBERG_MARQUARDT:return{algorithm:levenbergMarquardt,optimizationOptions:checkOptions(e,i)};default:throw new Error("Unknown kind algorithm")}}function checkOptions(t,e={}){switch(t){case LEVENBERG_MARQUARDT:return Object.assign({},lmOptions,e)}}function getKind(t){if("string"!=typeof t)return t;switch(t.toLowerCase().replace(/[^a-z]/g,"")){case"lm":case"levenbergmarquardt":return LEVENBERG_MARQUARDT;default:throw new Error("Unknown kind algorithm")}}const lmOptions={damping:1.5,maxIterations:100,errorTolerance:1e-8};function optimize(t,e,i={}){const{y:r,x:o,maxY:n,peaks:s,paramsFunc:l,optimization:a}=checkInput(t,e,i);let u=a.parameters,h=s.length,c=Object.keys(u),f=h*c.length,p=new Float64Array(f),m=new Float64Array(f),g=new Float64Array(f),y=new Float64Array(f);for(let t=0;t<h;t++){let e=s[t];for(let i=0;i<c.length;i++){let r=c[i],o=u[r].init,n=u[r].min,s=u[r].max,l=u[r].gradientDifference;g[t+i*h]=o[t%o.length](e),p[t+i*h]=n[t%n.length](e),m[t+i*h]=s[t%s.length](e),y[t+i*h]=l[t%l.length](e)}}let{algorithm:d,optimizationOptions:w}=selectMethod(a);w.minValues=p,w.maxValues=m,w.initialValues=g,w.gradientDifference=y;let x=d({x:o,y:r},l,w),{parameterError:b,iterations:M}=x,C={error:b,iterations:M,peaks:s};for(let t=0;t<h;t++){x.parameterValues[t+h]*=n;for(let e=0;e<c.length;e++)s[t][c[e]]=x.parameterValues[t+e*h]}return C}function xAbsolute(t){let e=t.slice();for(let t=0;t<e.length;t++)e[t]<0&&(e[t]*=-1);return e}var medianQuickselect_min={exports:{}};!function(t){!function(){function e(t){for(var e=0,o=t.length-1,n=void 0,s=void 0,l=void 0,a=r(e,o);;){if(o<=e)return t[a];if(o==e+1)return t[e]>t[o]&&i(t,e,o),t[a];for(t[n=r(e,o)]>t[o]&&i(t,n,o),t[e]>t[o]&&i(t,e,o),t[n]>t[e]&&i(t,n,e),i(t,n,e+1),s=e+1,l=o;;){do{s++}while(t[e]>t[s]);do{l--}while(t[l]>t[e]);if(l<s)break;i(t,s,l)}i(t,e,l),l<=a&&(e=s),l>=a&&(o=l-1)}}var i=function(t,e,i){var r;return r=[t[i],t[e]],t[e]=r[0],t[i]=r[1],r},r=function(t,e){return~~((t+e)/2)};t.exports?t.exports=e:window.median=e}()}(medianQuickselect_min);var quickSelectMedian=medianQuickselect_min.exports;function median(t){if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");return quickSelectMedian(t.slice())}function xAbsoluteMedian(t){return median(xAbsolute(t))}function xFindClosestIndex(t,e){let i=0,r=t.length-1,o=0;for(;r-i>1;)if(o=i+(r-i>>1),t[o]<e)i=o;else{if(!(t[o]>e))return o;r=o}return i<t.length-1?Math.abs(e-t[i])<Math.abs(t[i+1]-e)?i:i+1:i}function xGetFromToIndex(t,e={}){let{fromIndex:i,toIndex:r,from:o,to:n}=e;return void 0===i&&(i=void 0!==o?xFindClosestIndex(t,o):0),void 0===r&&(r=void 0!==n?xFindClosestIndex(t,n):t.length-1),i>r&&([i,r]=[r,i]),{fromIndex:i,toIndex:r}}function _typeof(t){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function sequentialFill(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"!==_typeof(t)||isAnyArray(t)||(e=t,t=[]),!isAnyArray(t))throw new TypeError("input must be an array");var i=e,r=i.from,o=void 0===r?0:r,n=i.to,s=void 0===n?10:n,l=i.size,a=void 0===l?t.length:l,u=i.step;if(0!==a&&u)throw new Error("step is defined by the array size");if(a||(a=u?Math.floor((s-o)/u)+1:s-o+1),!u&&a&&(u=(s-o)/(a-1)),Array.isArray(t)){t.length=0;for(var h=0;h<a;h++)t.push(o),o+=u}else{if(t.length!==a)throw new Error("sequentialFill typed array must have the correct length");for(var c=0;c<a;c++)t[c]=o,o+=u}return t}var d3Array={exports:{}};!function(t,e){!function(t){function e(t,e){return t<e?-1:t>e?1:t>=e?0:NaN}function i(t){return 1===t.length&&(t=r(t)),{left:function(e,i,r,o){for(null==r&&(r=0),null==o&&(o=e.length);r<o;){var n=r+o>>>1;t(e[n],i)<0?r=n+1:o=n}return r},right:function(e,i,r,o){for(null==r&&(r=0),null==o&&(o=e.length);r<o;){var n=r+o>>>1;t(e[n],i)>0?o=n:r=n+1}return r}}}function r(t){return function(i,r){return e(t(i),r)}}var o=i(e),n=o.right,s=o.left;function l(t,e){return e<t?-1:e>t?1:e>=t?0:NaN}function a(t){return null===t?NaN:+t}function u(t,e){var i,r,o=t.length,n=0,s=0,l=-1,u=0;if(null==e)for(;++l<o;)isNaN(i=a(t[l]))||(s+=(r=i-n)*(i-(n+=r/++u)));else for(;++l<o;)isNaN(i=a(e(t[l],l,t)))||(s+=(r=i-n)*(i-(n+=r/++u)));if(u>1)return s/(u-1)}function h(t,e){var i=u(t,e);return i?Math.sqrt(i):i}function c(t,e){var i,r,o,n=-1,s=t.length;if(null==e){for(;++n<s;)if(null!=(r=t[n])&&r>=r){i=o=r;break}for(;++n<s;)null!=(r=t[n])&&(i>r&&(i=r),o<r&&(o=r))}else{for(;++n<s;)if(null!=(r=e(t[n],n,t))&&r>=r){i=o=r;break}for(;++n<s;)null!=(r=e(t[n],n,t))&&(i>r&&(i=r),o<r&&(o=r))}return[i,o]}function f(t){return function(){return t}}function p(t){return t}function m(t,e,i){t=+t,e=+e,i=(o=arguments.length)<2?(e=t,t=0,1):o<3?1:+i;for(var r=-1,o=0|Math.max(0,Math.ceil((e-t)/i)),n=new Array(o);++r<o;)n[r]=t+r*i;return n}var g=Math.sqrt(50),y=Math.sqrt(10),d=Math.sqrt(2);function w(t,e,i){var r=x(t,e,i);return m(Math.ceil(t/r)*r,Math.floor(e/r)*r+r/2,r)}function x(t,e,i){var r=Math.abs(e-t)/Math.max(0,i),o=Math.pow(10,Math.floor(Math.log(r)/Math.LN10)),n=r/o;return n>=g?o*=10:n>=y?o*=5:n>=d&&(o*=2),e<t?-o:o}function b(t){return Math.ceil(Math.log(t.length)/Math.LN2)+1}function M(t){return+t}function C(){var t=p,e=c,i=b;function r(r){var o,s,l=r.length,a=new Array(l);for(o=0;o<l;++o)a[o]=+t(r[o],o,r);var u=e(a),h=+u[0],c=+u[1],f=i(a,h,c);Array.isArray(f)||(f=w(h,c,+f));var p=f.length;for(o=0;o<p;++o)f[o]=+f[o];for(;f[0]<=h;)f.shift(),--p;for(;f[p-1]>=c;)f.pop(),--p;var m,g=new Array(p+1);for(o=0;o<=p;++o)(m=g[o]=[]).x0=o>0?f[o-1]:h,m.x1=o<p?f[o]:c;for(o=0;o<l;++o)h<=(s=a[o])&&s<=c&&g[n(f,s,0,p)].push(r[o]);return g}return r.value=function(e){return arguments.length?(t="function"==typeof e?e:f(+e),r):t},r.domain=function(t){return arguments.length?(e="function"==typeof t?t:f([+t[0],+t[1]]),r):e},r.thresholds=function(t){return arguments.length?(i="function"==typeof t?t:Array.isArray(t)?f(Array.prototype.map.call(t,M)):f(+t),r):i},r}function v(t,e,i){if(null==i&&(i=a),r=t.length){if((e=+e)<=0||r<2)return+i(t[0],0,t);if(e>=1)return+i(t[r-1],r-1,t);var r,o=(r-1)*e,n=Math.floor(o),s=+i(t[n],n,t);return s+(+i(t[n+1],n+1,t)-s)*(o-n)}}function A(t,i,r){return t.sort(e),Math.ceil((r-i)/(2*(v(t,.75)-v(t,.25))*Math.pow(t.length,-1/3)))}function H(t,e,i){return Math.ceil((i-e)/(3.5*h(t)*Math.pow(t.length,-1/3)))}function k(t,e){var i,r,o=-1,n=t.length;if(null==e){for(;++o<n;)if(null!=(r=t[o])&&r>=r){i=r;break}for(;++o<n;)null!=(r=t[o])&&r>i&&(i=r)}else{for(;++o<n;)if(null!=(r=e(t[o],o,t))&&r>=r){i=r;break}for(;++o<n;)null!=(r=e(t[o],o,t))&&r>i&&(i=r)}return i}function E(t,e){var i,r=0,o=t.length,n=-1,s=o;if(null==e)for(;++n<o;)isNaN(i=a(t[n]))?--s:r+=i;else for(;++n<o;)isNaN(i=a(e(t[n],n,t)))?--s:r+=i;if(s)return r/s}function S(t,i){var r,o=[],n=t.length,s=-1;if(null==i)for(;++s<n;)isNaN(r=a(t[s]))||o.push(r);else for(;++s<n;)isNaN(r=a(i(t[s],s,t)))||o.push(r);return v(o.sort(e),.5)}function N(t){for(var e,i,r,o=t.length,n=-1,s=0;++n<o;)s+=t[n].length;for(i=new Array(s);--o>=0;)for(e=(r=t[o]).length;--e>=0;)i[--s]=r[e];return i}function F(t,e){var i,r,o=-1,n=t.length;if(null==e){for(;++o<n;)if(null!=(r=t[o])&&r>=r){i=r;break}for(;++o<n;)null!=(r=t[o])&&i>r&&(i=r)}else{for(;++o<n;)if(null!=(r=e(t[o],o,t))&&r>=r){i=r;break}for(;++o<n;)null!=(r=e(t[o],o,t))&&i>r&&(i=r)}return i}function I(t){for(var e=0,i=t.length-1,r=t[0],o=new Array(i<0?0:i);e<i;)o[e]=[r,r=t[++e]];return o}function D(t,e){for(var i=e.length,r=new Array(i);i--;)r[i]=t[e[i]];return r}function R(t,i){if(r=t.length){var r,o,n=0,s=0,l=t[s];for(i||(i=e);++n<r;)(i(o=t[n],l)<0||0!==i(l,l))&&(l=o,s=n);return 0===i(l,l)?s:void 0}}function T(t,e,i){for(var r,o,n=(null==i?t.length:i)-(e=null==e?0:+e);n;)o=Math.random()*n--|0,r=t[n+e],t[n+e]=t[o+e],t[o+e]=r;return t}function O(t,e){var i,r=0,o=t.length,n=-1;if(null==e)for(;++n<o;)(i=+t[n])&&(r+=i);else for(;++n<o;)(i=+e(t[n],n,t))&&(r+=i);return r}function P(t){if(!(o=t.length))return[];for(var e=-1,i=F(t,_),r=new Array(i);++e<i;)for(var o,n=-1,s=r[e]=new Array(o);++n<o;)s[n]=t[n][e];return r}function _(t){return t.length}function L(){return P(arguments)}var z="0.7.1";t.version=z,t.bisect=n,t.bisectRight=n,t.bisectLeft=s,t.ascending=e,t.bisector=i,t.descending=l,t.deviation=h,t.extent=c,t.histogram=C,t.thresholdFreedmanDiaconis=A,t.thresholdScott=H,t.thresholdSturges=b,t.max=k,t.mean=E,t.median=S,t.merge=N,t.min=F,t.pairs=I,t.permute=D,t.quantile=v,t.range=m,t.scan=R,t.shuffle=T,t.sum=O,t.ticks=w,t.tickStep=x,t.transpose=P,t.variance=u,t.zip=L}(e)}(0,d3Array.exports);const{bisectRight:bisectRight}=d3Array.exports,quincunx=(t,e,i,r)=>{const o=t.length-1;t[0]=0,e[0]=0,i[0]=0,e[1]=e[1]/t[1],i[1]=i[1]/t[1];for(let r=2;r<o;++r)t[r]=t[r]-t[r-2]*i[r-2]*i[r-2]-t[r-1]*e[r-1]*e[r-1],e[r]=(e[r]-t[r-1]*e[r-1]*i[r-1])/t[r],i[r]=i[r]/t[r];for(let t=2;t<o;++t)r[t]=r[t]-e[t-1]*r[t-1]-i[t-2]*r[t-2];for(let e=1;e<o;++e)r[e]=r[e]/t[e];r[o-2]=r[o-2]-e[o-2]*r[o-1];for(let t=o-3;t>0;--t)r[t]=r[t]-e[t]*r[t+1]-i[t]*r[t+2]},smoothingSpline=(t,e,i,r)=>{const o=t.length-1,n=new Array(o+1),s=new Array(o+1),l=new Array(o+1),a=new Array(o+1),u=new Array(o+1),h=new Array(o+1),c=new Array(o+1),f=new Array(o+1),p=t.map((()=>[0,0,0,0]));p.pop();const m=2*(1-r)/(3*r);for(let e=0;e<o;++e)n[e]=t[e+1]-t[e],s[e]=3/n[e];u[0]=0;for(let i=1;i<o;++i)l[i]=-(s[i-1]+s[i]),a[i]=2*(t[i+1]-t[i-1]),u[i]=3*(e[i+1]-e[i])/n[i]-3*(e[i]-e[i-1])/n[i-1];u[o]=0;for(let t=1;t<o;++t)h[t]=s[t-1]*s[t-1]*i[t-1]+l[t]*l[t]*i[t]+s[t]*s[t]*i[t+1],h[t]=m*h[t]+a[t];for(let t=1;t<o-1;++t)c[t]=l[t]*s[t]*i[t]+s[t]*l[t+1]*i[t+1],c[t]=m*c[t]+n[t];for(let t=1;t<o-2;++t)f[t]=m*s[t]*s[t+1]*i[t+1];quincunx(h,c,f,u),p[0][3]=e[0]-m*s[0]*u[1]*i[0],p[1][3]=e[1]-m*(l[1]*u[1]+s[1]*u[2])*i[0],p[0][0]=u[1]/(3*n[0]),p[0][1]=0,p[0][2]=(p[1][3]-p[0][3])/n[0]-u[1]*n[0]/3,s[0]=0;for(let t=1;t<o;++t)p[t][0]=(u[t+1]-u[t])/(3*n[t]),p[t][1]=u[t],p[t][2]=(u[t]+u[t-1])*n[t-1]+p[t-1][2],p[t][3]=s[t-1]*u[t-1]+l[t]*u[t]+s[t]*u[t+1],p[t][3]=e[t]-m*p[t][3]*i[t];return p};class SplineInterpolator{constructor(t,e,i=1){const r=t.map(((t,e)=>e));r.sort(((e,i)=>t[e]-t[i]));const o=r.map((e=>t[e])),n=r.map((t=>e[t])),s=r.length,l=r.map((()=>1));this.n=s,this.x=o,this.y=n,this.params=smoothingSpline(o,n,l,i)}interpolate(t){if(t===this.x[this.n-1])return this.y[this.n-1];const e=Math.min(Math.max(0,bisectRight(this.x,t)-1),this.n-2),[i,r,o,n]=this.params[e];return i*(t-=this.x[e])*t*t+r*t*t+o*t+n}max(t=100){const e=this.x[0],i=(this.x[this.n-1]-e)/t;let r=-1/0;for(let o=0,n=e;o<t;++o,n+=i){const t=this.interpolate(n);t>r&&(r=t)}return r}min(t=100){const e=this.x[0],i=(this.x[this.n-1]-e)/t;let r=1/0;for(let o=0,n=e;o<t;++o,n+=i){const t=this.interpolate(n);t<r&&(r=t)}return r}domain(){return[this.x[0],this.x[this.x.length-1]]}range(){return[this.min(),this.max()]}curve(t,e=null){const i=((e=e||this.domain())[1]-e[0])/(t-1),r=new Array(t);for(let o=0;o<t;++o){const t=i*o+e[0];r[o]=[t,this.interpolate(t)]}return r}}var splineInterpolator=SplineInterpolator;const Y1=.08913147449493408,P1=[-.005387729650712429,.008226878746769157,.02198786811111689,-.03656379714117627,-.012692614766297404,.03348066254097446,-.008368748197417368,-.0005087819496582806],Q1=[.0008862163904564247,-.0023339375937419,.07952836873415717,-.05273963823400997,-.7122890234154284,.662328840472003,1.5622155839842302,-1.5657455823417585,-.9700050433032906,1],Y2=2.249481201171875,P2=[-3.6719225470772936,21.12946554483405,17.445385985570866,-44.6382324441787,-18.851064805871424,17.644729840837403,8.3705032834312,.10526468069939171,-.20243350835593876],Q2=[1.7211476576120028,-22.643693341313973,10.826866735546016,48.560921310873994,-20.14326346804852,-28.66081804998,3.971343795334387,6.242641248542475,1],Y3=.807220458984375,P3=[-6.81149956853777e-10,2.8522533178221704e-8,-6.794655751811263e-7,.0021455899538880526,.029015791000532906,.14286953440815717,.3377855389120359,.38707973897260434,.11703015634199525,-.16379404719331705,-.1311027816799519],Q3=[.011059242293464892,.15226433829533179,.848854343457902,2.5930192162362027,4.778465929458438,5.381683457070069,3.4662540724256723,1],Y4=.9399557113647461,P4=[26633922742578204e-28,-2.304047769118826e-10,460469890584318e-20,.00015754461742496055,.0018712349281955923,.009508047013259196,.018557330651423107,-.0022242652921344794,-.0350353787183178],Q4=[7646752923027944e-20,.00263861676657016,.03415891436709477,.22009110576413124,.7620591645536234,1.3653349817554064,1],Y5=.9836282730102539,P5=[9905570997331033e-32,-2811287356288318e-29,4.625961635228786e-9,4.4969678992770644e-7,14962478375834237e-21,.00020938631748758808,.001056288621524929,-.0011295143874558028,-.016743100507663373],Q5=[2.82243172016108e-7,27533547476472603e-21,.0009640118070051656,.016074608709367652,.1381518657490833,.5914293448864175,1];function polyval(t,e){let i=0;for(const r of t)i=i*e+r;return i}function calc(t,e,i,r,o){const n=t-e;return o*t+polyval(i,n)/polyval(r,n)*t}function erfcinv(t){let e,i,r,o,n=!1;if(Number.isNaN(t))return NaN;if(t<0||t>2)throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${t}\`.`);return 0===t?Number.POSITIVE_INFINITY:2===t?Number.NEGATIVE_INFINITY:1===t?0:(t>1?(i=2-t,t=1-i,n=!0):(i=t,t=1-t),t<=.5?(r=t*(t+10),o=polyval(P1,t)/polyval(Q1,t),e=r*Y1+r*o,n?-e:e):i>=.25?(r=Math.sqrt(-2*Math.log(i)),i-=.25,o=polyval(P2,i)/polyval(Q2,i),e=r/(Y2+o),n?-e:e):(i=Math.sqrt(-Math.log(i)),i<3?calc(i,1.125,P3,Q3,Y3):i<6?calc(i,3,P4,Q4,Y4):calc(i,6,P5,Q5,Y5)))}function rayleighCdf(t,e=1){return t<0?0:-Math.expm1(-Math.pow(t,2)/(2*Math.pow(e,2)))}function xNoiseSanPlot(t,e={}){const{mask:i,cutOff:r,refine:o=!0,magnitudeMode:n=!1,scaleFactor:s=1,factorStd:l=5,fixOffset:a=!0}=e;let u;if(u=Array.isArray(i)&&i.length===t.length?new Float64Array(t.filter(((t,e)=>!i[e]))):new Float64Array(t),s>1)for(let t=0;t<u.length;t++)u[t]*=s;if(u=u.sort().reverse(),a&&!n){let t=Math.floor(u.length/2),e=.5*(u[t]+u[t+1]);for(let t=0;t<u.length;t++)u[t]-=e}let h=u[u.length-1]>=0?u.length:u.findIndex((t=>t<0)),c=h-1;for(let t=c;t>=0;t--)if(u[t]>0){c=t;break}let f,p=u.slice(0,c+1),m=u.slice(h),g=r||determineCutOff(p,{magnitudeMode:n}),y=p[Math.floor(p.length*g)],d=p[0];if(m.length>0){f=-1*m[Math.floor(m.length*(1-g))]}else f=0;let w=y,x=f,b=p.slice(),M=m.slice(),C=0,v=2;if(o){let t=w*l;C=p.findIndex((e=>e<t)),C>-1&&(b=p.slice(C),w=b[Math.floor(b.length*g)]),t=x*l,v=m.findIndex((e=>e<t)),v>-1&&(M=m.slice(v),x=b[Math.floor(M.length*(1-g))])}let A,H,k=-simpleNormInv(g/2,{magnitudeMode:n});return y/=k,f/=k,o&&C>-1?(A=(g*b.length+C)/(b.length+C),H=-1*simpleNormInv(A/2,{magnitudeMode:n}),w/=H,v>-1&&(A=(g*M.length+v)/(M.length+v),H=-1*simpleNormInv(A/2,{magnitudeMode:n}),0!==x&&(x/=H))):(w/=k,x/=k),{positive:w,negative:x,snr:d/w,sanplot:generateSanPlot(u,{fromTo:{positive:{from:0,to:c},negative:{from:h,to:u.length}}})}}function determineCutOff(t,e={}){let{magnitudeMode:i=!1,considerList:r={from:.5,step:.1,to:.9}}=e,o=[],n=t.length-1;for(let e=.01;e<=.99;e+=.01){let r=-t[Math.round(n*e)]/simpleNormInv([e/2],{magnitudeMode:i});o.push([e,r])}let s=Number.MAX_SAFE_INTEGER,{from:l,to:a,step:u}=r,h=u/2,c=.5;for(let t=l;t<=a;t+=u){let e=t-h,i=t+h,r=o.filter((t=>t[0]<i&&t[0]>e)),n=r.reduce(((t,e)=>t+Math.abs(e[1])),0),l=0;for(let t=0;t<r.length;t++)l+=Math.pow(r[t][1]-n,2);l<s&&(s=l,c=t)}return c}function simpleNormInv(t,e={}){const{magnitudeMode:i=!1}=e;Array.isArray(t)||(t=[t]);let r=createArray(0,2,.01),o=new Float64Array(t.length),n=new Float64Array(r.length);if(i){let e=1;for(let t=0;t<n.length;t++){let i=r[t]*e;n[t]=1-rayleighCdf(i)}let i=new splineInterpolator(r,n);for(let e=0;e<o.length;e++){let r=2*t[e];o[e]=-1*i.interpolate(r)}}else for(let e=0;e<o.length;e++)o[e]=-1*Math.SQRT2*erfcinv(2*t[e]);return 1===o.length?o[0]:o}function createArray(t,e,i){let r=new Array(Math.abs((t-e)/i+1));for(let e=0;e<r.length;e++)r[e]=t+e*i;return r}function generateSanPlot(t,e={}){const{fromTo:i,logBaseY:r=2}=e;let o={};for(let e in i){let{from:n,to:s}=i[e];o[e]=n!==s?scale(t.slice(n,s),{logBaseY:r}):{x:[],y:[]},"negative"===e&&o[e].y.reverse()}return o}function scale(t,e={}){const{log10:i,abs:r}=Math,{logBaseY:o}=e;if(o){t=t.slice();const e=i(o);for(let o=0;o<t.length;o++)t[o]=i(r(t[o]))/e}return{x:sequentialFill({from:0,to:t.length-1,size:t.length}),y:t}}function sum(t){if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");for(var e=0,i=0;i<t.length;i++)e+=t[i];return e}function mean(t){return sum(t)/t.length}function xyCheck(t={}){if(!isAnyArray(t.x)||!isAnyArray(t.y))throw new Error("Data must be an object of x and y arrays");if(t.x.length!==t.y.length)throw new Error("The x and y arrays mush have the same length")}function zonesNormalize(t=[],e={}){if(0===t.length)return[];t=JSON.parse(JSON.stringify(t)).map((t=>t.from>t.to?{from:t.to,to:t.from}:t));let{from:i=Number.NEGATIVE_INFINITY,to:r=Number.POSITIVE_INFINITY}=e;if(i>r&&([i,r]=[r,i]),(t=t.sort(((t,e)=>t.from!==e.from?t.from-e.from:t.to-e.to))).forEach((t=>{i>t.from&&(t.from=i),r<t.to&&(t.to=r)})),0===(t=t.filter((t=>t.from<=t.to))).length)return[];let o=t[0],n=[o];for(let e of t)e.from<=o.to?o.to=e.to:(o=e,n.push(o));return n}function xyExtract(t={},e={}){xyCheck(t);const{x:i,y:r}=t;let{zones:o}=e;if(o=zonesNormalize(o),!Array.isArray(o)||0===o.length)return t;let n=[],s=[],l=o[0],a=0;t:for(let t=0;t<i.length;t++){for(;l.to<i[t];)if(a++,l=o[a],!l){t=i.length;break t}i[t]>=l.from&&(n.push(i[t]),s.push(r[t]))}return{x:n,y:s}}function xyIntegration(t={},e={}){xyCheck(t);const{x:i,y:r}=t;if(i.length<2)return 0;const{fromIndex:o,toIndex:n}=xGetFromToIndex(i,e);let s=0;for(let t=o;t<n;t++)s+=(i[t+1]-i[t])*(r[t+1]+r[t])/2;return s}function groupPeaks(t,e=1){if(0===t.length)return[];let i=t.sort(((t,e)=>t.x-e.x)),r={x:Number.NEGATIVE_INFINITY,width:1},o=[r],n=[];for(let t of i)(t.x-r.x)/(t.width+r.width)<=e/2?o.push(t):(o=[t],n.push(o)),t.group=n.length-1,r=t;return n}function optimizePeaks(t,e,i={}){const{factorWidth:r=1,factorLimits:o=2,shape:n={kind:"gaussian"},optimization:s={kind:"lm",options:{timeout:10}}}=i;t.x[0]>t.x[1]&&(t.x.reverse(),t.y.reverse());let l=groupPeaks(e,r),a=[];for(const e of l){const i=e[0],r=e[e.length-1],l=i.x-i.width*o,u=r.x+r.width*o,{fromIndex:h,toIndex:c}=xGetFromToIndex(t.x,{from:l,to:u}),f={x:t.x.slice(h,c),y:t.y.slice(h,c)};if(f.x.length>5){let{peaks:t}=optimize(f,e,{shape:n,optimization:s});a=a.concat(t)}else a=a.concat(e)}return a}function joinBroadPeaks(t,e={}){let{width:i=.25,shape:r={kind:"gaussian"},optimization:o={kind:"lm",timeout:10}}=e,n=[],s=0,l=0,a=1;for(let e=t.length-1;e>=0;e--)t[e].soft&&n.push(t.splice(e,1)[0]);n.push({x:Number.MAX_VALUE});let u={x:[n[0].x],y:[n[0].y]},h=[0];for(let e=1;e<n.length;e++)if(Math.abs(n[e-1].x-n[e].x)<i)u.x.push(n[e].x),u.y.push(n[e].y),n[e].y>s&&(s=n[e].y,l=e),h.push(e),a++;else{if(a>2){let e=optimize(u,[{x:n[l].x,y:s,width:Math.abs(u.x[0]-u.x[u.x.length-1])}],{shape:r,optimization:o}),{peaks:i}=e;i[0].index=Math.floor(h.reduce(((t,e)=>t+e),0)/h.length),i[0].soft=!1,t.push(i[0])}else h.forEach((e=>{t.push(n[e])}));u={x:[n[e].x],y:[n[e].y]},h=[e],s=n[e].y,l=e,a=1}return t.sort((function(t,e){return t.x-e.x})),t}function xyAutoPeaksPicking(t,e={}){const{from:i,to:r,noiseLevel:o,thresholdFactor:n=3,minMaxRatio:s=.05,broadRatio:l=25e-5,useSanPlot:a=!1,smoothY:u=!0,optimize:h=!1,factorWidth:c=4,realTopDetection:f=!0,shape:p={kind:"gaussian"},optimization:m={kind:"lm"},broadWidth:g=.25,lookNegative:y=!1,sgOptions:d={windowSize:9,polynomial:3}}=e;void 0!==i&&void 0!==r&&(t=xyExtract(t,[{from:i,to:r}]));const w=getCutOff(t.y,{noiseLevel:o,useSanPlot:a,thresholdFactor:n});let x={shape:p,broadWidth:g,optimize:h,factorWidth:c,sgOptions:d,minMaxRatio:s,broadRatio:l,noiseLevel:w.positive,smoothY:u,optimization:m,realTopDetection:f},b=getPeakList(t,x);return y&&(x.noiseLevel=w.negative,b.push(...getNegativePeaks(t,x))),b}function getPeakList(t,e){const{shape:i,broadWidth:r,optimize:o,factorWidth:n,sgOptions:s,minMaxRatio:l,broadRatio:a,noiseLevel:u,smoothY:h,optimization:c,realTopDetection:f}=e;let p=gsd(t,{sgOptions:s,minMaxRatio:l,broadRatio:a,noiseLevel:u,smoothY:h,realTopDetection:f});return r&&(p=joinBroadPeaks(p,{width:r,shape:i,optimization:c})),o&&(p=optimizePeaks(t,p,{shape:i,factorWidth:n,optimization:c})),p}function getNegativePeaks(t,e){let{x:i,y:r}=t,o=new Float64Array(t.y.length);for(let t=0;t<o.length;t++)o[t]=-1*r[t];let n=getPeakList({x:i,y:o},e);for(let t=0;t<n.length;t++)n[t].y*=-1;return n}function getCutOff(t,e={}){const{noiseLevel:i,useSanPlot:r,thresholdFactor:o}=e,n=t=>"number"==typeof t?{positive:t,negative:-t}:t;return i?n(i):r?xNoiseSanPlot(t,{factorStd:o}):n(xAbsoluteMedian(t)*o)}const patterns=["s","d","t","q","quint","h","sept","o","n"];let symRatio=1.5,maxErrorIter1=2.5,maxErrorIter2=1,jAxisKeys={jAxis:"x",intensity:"intensity"};var jAnalyzer={compilePattern:function(t,e={}){let{jAxisKey:i=jAxisKeys}=e;if(t.multiplicity="m",t.symRank=symmetrizeChoiseBest(t,{maxError:maxErrorIter1,iteration:1,jAxisKey:i}),t.asymmetric=!0,t.symRank>=.95&&t.peaksComp.length<32){let e,i,r;t.asymmetric=!1;let o=1,n=[];for(let s=0;s<9;s++){let l=normalize(t,s),a=!1;if(1===l.length&&0===s)a=!0;else if(l.length<=1)continue;let u=getRanges(l);i=Math.pow(2,s);let h=null,c=1;for(;!a&&null!==(h=getNextCombination(u,i))&&c<400;){let t=new Array(h.length);o=1;for(let e=0;e<h.length;e++){t[e]=new Array(h[e]);for(let i=0;i<h[e];i++)t[e][i]=o++}n=[];let i=1;n.push(l[1].x-l[0].x),e=l[0].x,t[0].splice(0,1),t[1].splice(0,1),o=1;let u=2;for(r=Math.pow(2,s)-1;n.length<s&&u<r&&o<l.length;){for(c+=1,i++;o<l.length&&0===t[o].length;)o++;if(o<l.length){n.push(l[o].x-l[0].x),t[o].splice(0,1),u++;for(let r=2;r<=i;r++){let i=0;for(let t=0;t<r;t++)i+=n[t];for(let r=1;r<t.length;r++)if(Math.abs(l[r].x-(e+i))<.25){t[r].splice(0,1),u++;break}}}}let f=idealPattern(n);a=!0;for(let t=0;t<f.length;t++)f[t].intensity!==h[t]&&(a=!1)}a&&updateSignal(t,n)}}for(let e=0;e<t.peaksComp.length;e++)t.peaksComp[e].x/=t.observe}};function updateSignal(t,e){let i=t.peaksComp,r=i.length;t.startX=i[0].x/t.observe-i[0].width,t.stopX=i[r-1].x/t.observe+i[r-1].width,t.integralData.from=i[0].x/t.observe-3*i[0].width,t.integralData.to=i[r-1].x/t.observe+3*i[r-1].width,t.maskPattern=t.mask2,t.multiplicity=abstractPattern(t,e),t.pattern=t.multiplicity}function abstractPattern(t,e){let i="",r=1,o=[];if(e&&e.length>0){e.sort((function(t,e){return e-t}));for(let t=0;t<e.length-1;t++)Math.abs(e[t]-e[t+1])<.05?r++:(o.push({coupling:Math.abs(e[t]),multiplicity:patterns[r]}),i+=patterns[r],r=1);let n=e.length-1;o.push({coupling:Math.abs(e[n]),multiplicity:patterns[r]}),i+=patterns[r],t.nmrJs=o}else i="s",Math.abs(t.startX-t.stopX)*t.observe>16&&(i="br s");return i}function idealPattern(t){let e=[{x:0,intensity:Math.pow(2,t.length)}];for(let i=0;i<t.length;i++)for(let r=e.length-1;r>=0;r--)e.push({x:e[r].x+t[i]/2,intensity:e[r].intensity/2}),e[r].x=e[r].x-t[i]/2,e[r].intensity=e[r].intensity/2;e.sort((function(t,e){return t.x-e.x}));for(let t=e.length-2;t>=0;t--)Math.abs(e[t].x-e[t+1].x)<.1&&(e[t].intensity+=e[t+1].intensity,e.splice(t+1,1));return e}function getNextCombination(t,e){let i,r=Math.ceil(.5*t.values.length),o=t.values.length,n=0;for(;n!==e;){for(i=!1;!i;)if(i=!0,t.currentIndex[t.active]++,t.currentIndex[t.active]>=t.values[t.active].length){if(t.active+1===r)return null;t.currentIndex[t.active]=0,i=!1,t.active++}else t.active=0;n=0;for(let e=0;e<r;e++)n+=2*t.values[e][t.currentIndex[e]];t.values.length%2!=0&&(n-=t.values[r-1][t.currentIndex[r-1]])}if(n===e){let e=new Array(o);for(let i=0;i<r;i++)e[i]=t.values[i][t.currentIndex[i]],e[o-i-1]=t.values[i][t.currentIndex[i]];return e}return null}function getRanges(t){let e,i,r=new Array(t.length),o=new Array(t.length);r[0]=[1],r[t.length-1]=[1],o[0]=-1,o[t.length-1]=0;for(let n=1;n<t.length-1;n++){e=Math.round(.85*t[n].intensity),i=Math.round(1.15*t[n].intensity),r[n]=[];for(let t=e;t<=i;t++)r[n].push(t);o[n]=0}return{values:r,currentIndex:o,active:0}}function symmetrizeChoiseBest(t,e={}){let{maxError:i,iteration:r,jAxisKey:o=jAxisKeys}=e,n=symmetrize(t,i,r,o),s=t.peaksComp,l=t.mask,a=t.delta1;t.delta1=(t.peaks[0].x+t.peaks[t.peaks.length-1].x)/2;let u=symmetrize(t,i,r,o);return t.peaksComp.length>s.length?u:(t.delta1=a,t.peaksComp=s,t.mask=l,n)}function symmetrize(t,e,i,r){let o,n,s,l,a,{jAxis:u,intensity:h}=r,c=new Array(t.peaks.length);for(let e=0;e<c.length;e++)c[e]={x:t.peaks[e][u]*t.observe,intensity:t.peaks[e][h],width:t.peaks[e].width};for(let t=c.length-2;t>=0;t--)Math.abs(c[t].x-c[t+1].x)<.25&&(c[t].x=c[t].x*c[t].intensity+c[t+1].x*c[t+1].intensity,c[t].intensity=c[t].intensity+c[t+1].intensity,c[t].x/=c[t].intensity,c[t].intensity/=2,c[t].width+=c[t+1].width,c.splice(t+1,1));t.peaksComp=c;let f=c.length,p=new Array(f);t.mask=p;let m=0,g=c.length-1,y=t.delta1*t.observe,d=[(c[0].x+c[f-1].x)/2,1];e=error(Math.abs(y-d[0]));let w=0;for(let t=0;t<f;t++)p[t]=!0,w+=c[t].intensity;for(;m<=g;){if(p[m]=!0,p[g]=!0,m===g)f>2&&Math.abs(c[m].x-y)>e&&(p[m]=!1);else if(o=Math.max(c[m].intensity,c[g].intensity),n=Math.min(c[m].intensity,c[g].intensity),l=o/n,l>symRatio)c[m].intensity===n?(p[m]=!1,g++):(p[g]=!1,m--);else{let t=Math.abs(c[m].x-y),i=Math.abs(c[g].x-y);Math.abs(t-i)<e?(s=Math.min(c[m].intensity,c[g].intensity),a=Math.min(c[m].width,c[g].width),c[m].intensity=c[g].intensity=s,c[m].width=c[g].width=a,d=[d[0]+(c[g].x+c[m].x)/2,d[1]+1]):Math.max(t,i)===i?(p[g]=!1,m--):(p[m]=!1,g++)}if(m++,g--,1===i&&(y=chemicalShift(c,p),isNaN(y)))return 0;e=error(Math.abs(y-d[0]/d[1]))}for(let t=f-1;t>=0;t--)!1===p[t]&&c.splice(t,1);if(y=chemicalShift(c),isNaN(y))return 0;t.delta1=y/t.observe;let x=0,b=0;if(c.length>1){for(let t=Math.ceil(c.length/2)-1;t>=0;t--)x+=(3+Math.min(Math.abs(c[t].x-y),Math.abs(c[c.length-1-t].x-y)))/(3+Math.max(Math.abs(c[t].x-y),Math.abs(c[c.length-1-t].x-y)))*c[t].intensity,b+=c[t].intensity;x/=b}else 1===c.length&&(x=1);let M=0;for(let t=0;t<c.length;t++)M+=c[t].intensity;if(x-=(w-M)/w*.12,x>.8&&x<.97&&i<2)return symmetrize(t,maxErrorIter2,2,r);if(c.length>1){let t;for(let e=Math.ceil(c.length/2)-1;e>=0;e--)t=(c[e].x-c[c.length-1-e].x)/2,c[e].x=y+t,c[c.length-1-e].x=y-t}return x}function error(t){let e=2.5*t;return e<.75&&(e=.75),e>3&&(e=3),e}function normalize(t,e){let i=JSON.parse(JSON.stringify(t.peaksComp)),r=0,o=0;for(let t=0;t<i.length;t++)r+=i[t].intensity;r=Math.pow(2,e)/r,t.mask2=JSON.parse(JSON.stringify(t.mask));let n=t.mask2.length-1;for(let e=i.length-1;e>=0;e--){for(i[e].intensity*=r;n>=0&&!1===t.mask2[n];)n--;i[e].intensity<.75?(i.splice(e,1),t.mask2[n]=!1):o+=i[e].intensity,n--}o=Math.pow(2,e)/o;for(let t=i.length-1;t>=0;t--)i[t].intensity*=o;return i}function chemicalShift(t,e){let i,r=0,o=0;if(e)for(let n=0;n<t.length;n++)!0===e[n]&&(i=getArea(t[n]),r+=i,o+=i*t[n].x);else for(let e=0;e<t.length;e++)i=getArea(t[e]),r+=i,o+=i*t[e].x;return o/r}function getArea(t){return Math.abs(t.intensity*t.width*1.57)}function joinRanges(t){t.sort(((t,e)=>t.from-e.from));for(let e=0;e<t.length-1;e++)t[e].to>t[e+1].from&&(t[e].to=Math.max(t[e+1].to,t[e].to),t[e].signal=t[e].signal.concat(t[e+1].signal),t[e].integral+=t[e+1].integral,t.splice(e+1,1),e--);return t}function peaksToRanges(t,e,i={}){let{integrationSum:r=100,joinOverlapRanges:o=!0,clean:n=.4,compile:s=!0,integralType:l="sum",frequency:a=400,frequencyCluster:u=16,keepPeaks:h=!1,nucleus:c="1H"}=i,f={integrationSum:r,integralType:l,frequencyCluster:u,frequency:a,nucleus:c};t.x[0]>t.x[1]&&(t.x=t.x.reverse(),t.y=t.y.reverse());let p=detectSignals(t,e,f);if(n)for(let t=0;t<p.length;t++)Math.abs(p[t].integralData.value)<n&&p.splice(t,1);if(s){let e,i;for(let r=0;r<p.length;r++)if(jAnalyzer.compilePattern(p[r]),p[r].maskPattern&&"m"!==p[r].multiplicity&&""!==p[r].multiplicity){e=0,i=0;let o=[];for(let t=p[r].maskPattern.length-1;t>=0;t--)if(i+=computeArea(p[r].peaks[t]),!1===p[r].maskPattern[t]){let i=p[r].peaks.splice(t,1)[0];o.push({x:i.x,y:i.intensity,width:i.width}),p[r].mask.splice(t,1),p[r].mask2.splice(t,1),p[r].maskPattern.splice(t,1),p[r].nbPeaks--,e+=computeArea(i)}if(o.length>0){e=e*p[r].integralData.value/i,p[r].integralData.value-=e;let n=[];for(let t=o.length-1;t>=0;t--)n.push(o[t]);f.integrationSum=Math.abs(e);let s=detectSignals(t,n,f);for(let t=0;t<s.length;t++)p.push(s[t])}}let o=0,n=0;for(let t=0;t<p.length;t++)n+=Math.abs(Math.round(p[t].integralData.value));if(n!==r){o=r/n;for(let t=0;t<p.length;t++)p[t].integralData.value*=o}}if(p.sort(((t,e)=>e.delta1-t.delta1)),n)for(let t=p.length-1;t>=0;t--)Math.abs(p[t].integralData.value)<n&&p.splice(t,1);let m=[];for(let t=0;t<p.length;t++){let e=p[t];m[t]={from:e.integralData.from,to:e.integralData.to,integral:e.integralData.value,signal:[{kind:e.kind||"signal",multiplicity:e.multiplicity}]},h&&(m[t].signal[0].peak=e.peaks),e.nmrJs&&(m[t].signal[0].j=e.nmrJs),e.asymmetric&&"m"!==e.multiplicity||(m[t].signal[0].delta=e.delta1)}return o&&(m=joinRanges(m)),m}function detectSignals(t,e,i={}){let r,o,{integrationSum:n=100,integralType:s="sum",frequencyCluster:l=16,frequency:a=400,nucleus:u="1H"}=i,h=[],c={x:1e5},f=0;l/=a;for(let t=0;t<e.length;t++){if(Math.abs(e[t].x-c.x)>l)r={nbPeaks:1,units:"PPM",startX:e[t].x-e[t].width,stopX:e[t].x+e[t].width,multiplicity:"",pattern:"",observe:a,nucleus:u,integralData:{from:e[t].x-3*e[t].width,to:e[t].x+3*e[t].width},peaks:[{x:e[t].x,intensity:e[t].y,width:e[t].width}]},e[t].kind&&(r.kind=e[t].kind),h.push(r);else{let i=e[t].x+e[t].width;r.stopX=Math.max(r.stopX,i),r.startX=Math.min(r.startX,i),r.nbPeaks++,r.peaks.push({x:e[t].x,intensity:e[t].y,width:e[t].width}),r.integralData.from=Math.min(r.integralData.from,e[t].x-3*e[t].width),r.integralData.to=Math.max(r.integralData.to,e[t].x+3*e[t].width),e[t].kind&&(r.kind=e[t].kind)}c=e[t]}for(let e=0;e<h.length;e++){o=h[e].peaks;let i=h[e].integralData,r=0,n=0;for(let t=0;t<o.length;t++){let e=computeArea(o[t]);r+=o[t].x*e,n+=e}h[e].delta1=r/n,i.value="sum"===s?xyIntegration(t,{from:i.from,to:i.to}):n,f+=i.value}if(n>0){let t=n/f;for(let e=0;e<h.length;e++){h[e].integralData.value*=t}}return h}function computeArea(t){return Math.abs(t.intensity*t.width*1.57)}function xyAutoRangesPicking(t,e={}){let i=xyAutoPeaksPicking(t,e.peakPicking);return i=peaksFilterImpurities(i,e.impurities),peaksToRanges(t,i,e.ranges)}function signalsToRanges(t,e={}){const{tolerance:i=.05,frequency:r=400}=e;let o=t.map((t=>({original:t})));o.forEach((t=>{let e=(t.original.j||[]).reduce(((t,e)=>t+e.coupling/r),0)/2+i;t.from=t.original.delta-e,t.to=t.original.delta+e})),o=o.sort(((t,e)=>t.from-e.from));let n=[],s={};for(let t of o)void 0===s.from||t.from>s.to?(s={from:t.from,to:t.to,integral:t.original.nbAtoms,signal:[t.original]},n.push(s)):(s.integral+=t.original.nbAtoms,t.to>s.to&&(s.to=t.to),s.signal.push(t.original));return n}const defOptions={threshold:0,out:"assignment"};var src$1=function(t,e){const i=Object.assign({},defOptions,e);var r,o;if("number"==typeof t[0])r=fullClusterGeneratorVector(t);else if("object"==typeof t[0]){for(var n=t.length,s=new Array(n*(n+1)/2),l=0,a=0;a<n;a++)for(var u=a;u<n;u++)t[a][u]>i.threshold?s[l++]=1:s[l++]=0;r=fullClusterGeneratorVector(s)}if("indexes"===i.out||"values"===i.out){var h=new Array(r.length);for(a=0;a<r.length;a++)for(h[a]=[],u=0;u<r[a].length;u++)0!=r[a][u]&&h[a].push(u);if("values"===i.out){var c=new Array(h.length);for(a=0;a<h.length;a++)for(c[a]=new Array(h[a].length),u=0;u<h[a].length;u++)for(c[a][u]=new Array(h[a].length),o=0;o<h[a].length;o++)c[a][u][o]=t[h[a][u]][h[a][o]];return c}return h}return r};function fullClusterGeneratorVector(t){var e=Math.sqrt(2*t.length+.25)-.5,i=[],r=new Array(e),o=e,n=0,s=[];for(n=e-1;n>=0;n--)r[n]=1;for(var l=-1,a=[];o>0;){if(0===a.length){for(s=new Array(e),n=0;n<e;n++)s[n]=0;for(i.push(s),l=0;0==r[l];l++);}else l=a.splice(0,1);s[l]=1,r[l]=0,o--;var u=new Array(e);for(n=0;n<e;n++){var h=Math.max(l,n),c=Math.min(l,n);u[n]=t[c*(2*e-c-1)/2+h],1==u[n]&&1==r[n]&&0==s[n]&&(a.push(n),s[n]=1)}}return i}function signalsToSpinSystem(t){const e=t.length,i=new Array(e),r=new Array(e),o=Matrix.zeros(e,e),n={};for(let o=0;o<e;o++)r[o]=2,i[o]=t[o].delta,n[t[o].assignment]=o;for(let i=0;i<e;i++){let{assignment:e,j:r}=t[i];for(let t=0;t<r.length;t++){let{coupling:i,assignment:s}=r[t];o.set(n[e],n[s],i),o.set(n[s],n[e],i)}}const s=Matrix.ones(o.rows,o.rows);for(let t=0;t<o.rows;t++)for(let e=t;e<o.columns;e++)0===o.get(t,e)&&(s.set(t,e,0),s.set(e,t,0));return{clusters:src$1(s.to2DArray(),{out:"indexes"}),couplingConstants:o,chemicalShifts:i,multiplicity:r,connectivity:s}}var binarySearch=function(t,e,i,r,o){var n,s;if(void 0===r)r=0;else if((r|=0)<0||r>=t.length)throw new RangeError("invalid lower bound");if(void 0===o)o=t.length-1;else if((o|=0)<r||o>=t.length)throw new RangeError("invalid upper bound");for(;r<=o;)if((s=+i(t[n=r+(o-r>>>1)],e,n,t))<0)r=n+1;else{if(!(s>0))return n;o=n-1}return~r},numSort={};function assertNumber$1(t){if("number"!=typeof t)throw new TypeError("Expected a number")}var ascending=numSort.ascending=(t,e)=>(assertNumber$1(t),assertNumber$1(e),Number.isNaN(t)?-1:Number.isNaN(e)?1:t-e);numSort.descending=(t,e)=>(assertNumber$1(t),assertNumber$1(e),Number.isNaN(t)?1:Number.isNaN(e)?-1:e-t);const largestPrime=2147483647,primeNumbers=[largestPrime,5,11,23,47,97,197,397,797,1597,3203,6421,12853,25717,51437,102877,205759,411527,823117,1646237,3292489,6584983,13169977,26339969,52679969,105359939,210719881,421439783,842879579,1685759167,433,877,1759,3527,7057,14143,28289,56591,113189,226379,452759,905551,1811107,3622219,7244441,14488931,28977863,57955739,115911563,231823147,463646329,927292699,1854585413,953,1907,3821,7643,15287,30577,61169,122347,244703,489407,978821,1957651,3915341,7830701,15661423,31322867,62645741,125291483,250582987,501165979,1002331963,2004663929,1039,2081,4177,8363,16729,33461,66923,133853,267713,535481,1070981,2141977,4283963,8567929,17135863,34271747,68543509,137087021,274174111,548348231,1096696463,31,67,137,277,557,1117,2237,4481,8963,17929,35863,71741,143483,286973,573953,1147921,2295859,4591721,9183457,18366923,36733847,73467739,146935499,293871013,587742049,1175484103,599,1201,2411,4831,9677,19373,38747,77509,155027,310081,620171,1240361,2480729,4961459,9922933,19845871,39691759,79383533,158767069,317534141,635068283,1270136683,311,631,1277,2557,5119,10243,20507,41017,82037,164089,328213,656429,1312867,2625761,5251529,10503061,21006137,42012281,84024581,168049163,336098327,672196673,1344393353,3,7,17,37,79,163,331,673,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,43,89,179,359,719,1439,2879,5779,11579,23159,46327,92657,185323,370661,741337,1482707,2965421,5930887,11861791,23723597,47447201,94894427,189788857,379577741,759155483,1518310967,379,761,1523,3049,6101,12203,24407,48817,97649,195311,390647,781301,1562611,3125257,6250537,12501169,25002389,50004791,100009607,200019221,400038451,800076929,1600153859,13,29,59,127,257,521,1049,2099,4201,8419,16843,33703,67409,134837,269683,539389,1078787,2157587,4315183,8630387,17260781,34521589,69043189,138086407,276172823,552345671,1104691373,19,41,83,167,337,677,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,53,107,223,449,907,1823,3659,7321,14653,29311,58631,117269,234539,469099,938207,1876417,3752839,7505681,15011389,30022781,60045577,120091177,240182359,480364727,960729461,1921458943];function nextPrime(t){let e=binarySearch(primeNumbers,t,ascending);return e<0&&(e=~e),primeNumbers[e]}primeNumbers.sort(ascending);const FREE=0,FULL=1,REMOVED=2,defaultInitialCapacity=150,defaultMinLoadFactor=1/6,defaultMaxLoadFactor=2/3;class HashTable{constructor(t={}){if(t instanceof HashTable)return this.table=t.table.slice(),this.values=t.values.slice(),this.state=t.state.slice(),this.minLoadFactor=t.minLoadFactor,this.maxLoadFactor=t.maxLoadFactor,this.distinct=t.distinct,this.freeEntries=t.freeEntries,this.lowWaterMark=t.lowWaterMark,void(this.highWaterMark=t.maxLoadFactor);const e=void 0===t.initialCapacity?defaultInitialCapacity:t.initialCapacity;if(e<0)throw new RangeError(`initial capacity must not be less than zero: ${e}`);const i=void 0===t.minLoadFactor?defaultMinLoadFactor:t.minLoadFactor,r=void 0===t.maxLoadFactor?defaultMaxLoadFactor:t.maxLoadFactor;if(i<0||i>=1)throw new RangeError(`invalid minLoadFactor: ${i}`);if(r<=0||r>=1)throw new RangeError(`invalid maxLoadFactor: ${r}`);if(i>=r)throw new RangeError(`minLoadFactor (${i}) must be smaller than maxLoadFactor (${r})`);let o=e;o=o/r|0,o=nextPrime(o),0===o&&(o=1),this.table=newArray(o),this.values=newArray(o),this.state=newArray(o),this.minLoadFactor=i,this.maxLoadFactor=o===largestPrime?1:r,this.distinct=0,this.freeEntries=o,this.lowWaterMark=0,this.highWaterMark=chooseHighWaterMark(o,this.maxLoadFactor)}clone(){return new HashTable(this)}get size(){return this.distinct}get(t){const e=this.indexOfKey(t);return e<0?0:this.values[e]}set(t,e){let i=this.indexOfInsertion(t);if(i<0)return i=-i-1,this.values[i]=e,!1;if(this.distinct>this.highWaterMark){const i=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);return this.rehash(i),this.set(t,e)}if(this.table[i]=t,this.values[i]=e,this.state[i]===FREE&&this.freeEntries--,this.state[i]=FULL,this.distinct++,this.freeEntries<1){const t=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);this.rehash(t)}return!0}remove(t,e){const i=this.indexOfKey(t);return!(i<0)&&(this.state[i]=REMOVED,this.distinct--,e||this.maybeShrinkCapacity(),!0)}delete(t,e){const i=this.indexOfKey(t);return!(i<0)&&(this.state[i]=FREE,this.distinct--,e||this.maybeShrinkCapacity(),!0)}maybeShrinkCapacity(){if(this.distinct<this.lowWaterMark){const t=chooseShrinkCapacity(this.distinct,this.minLoadFactor,this.maxLoadFactor);this.rehash(t)}}containsKey(t){return this.indexOfKey(t)>=0}indexOfKey(t){const e=this.table,i=this.state,r=this.table.length,o=2147483647&t;let n=o%r,s=o%(r-2);for(0===s&&(s=1);i[n]!==FREE&&(i[n]===REMOVED||e[n]!==t);)n-=s,n<0&&(n+=r);return i[n]===FREE?-1:n}containsValue(t){return this.indexOfValue(t)>=0}indexOfValue(t){const e=this.values,i=this.state;for(var r=0;r<i.length;r++)if(i[r]===FULL&&e[r]===t)return r;return-1}indexOfInsertion(t){const e=this.table,i=this.state,r=e.length,o=2147483647&t;let n=o%r,s=o%(r-2);for(0===s&&(s=1);i[n]===FULL&&e[n]!==t;)n-=s,n<0&&(n+=r);if(i[n]===REMOVED){const o=n;for(;i[n]!==FREE&&(i[n]===REMOVED||e[n]!==t);)n-=s,n<0&&(n+=r);i[n]===FREE&&(n=o)}return i[n]===FULL?-n-1:n}ensureCapacity(t){if(this.table.length<t){const e=nextPrime(t);this.rehash(e)}}rehash(t){const e=this.table.length;if(t<=this.distinct)throw new Error("Unexpected");const i=this.table,r=this.values,o=this.state,n=newArray(t),s=newArray(t),l=newArray(t);this.lowWaterMark=chooseLowWaterMark(t,this.minLoadFactor),this.highWaterMark=chooseHighWaterMark(t,this.maxLoadFactor),this.table=n,this.values=s,this.state=l,this.freeEntries=t-this.distinct;for(var a=0;a<e;a++)if(o[a]===FULL){var u=i[a],h=this.indexOfInsertion(u);n[h]=u,s[h]=r[a],l[h]=FULL}}forEachKey(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.table[e]))return!1;return!0}forEachValue(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.values[e]))return!1;return!0}forEachPair(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.table[e],this.values[e]))return!1;return!0}}function chooseLowWaterMark(t,e){return t*e|0}function chooseHighWaterMark(t,e){return Math.min(t-2,t*e|0)}function chooseGrowCapacity(t,e,i){return nextPrime(Math.max(t+1,4*t/(3*e+i)|0))}function chooseShrinkCapacity(t,e,i){return nextPrime(Math.max(t+1,4*t/(e+3*i)|0))}function newArray(t){return Array(t).fill(0)}class SparseMatrix{constructor(t,e,i={}){if(t instanceof SparseMatrix){const e=t;this._init(e.rows,e.columns,e.elements.clone(),e.threshold)}else if(Array.isArray(t)){const r=t;t=r.length,i=e||{},e=r[0].length,this._init(t,e,new HashTable(i),i.threshold);for(let i=0;i<t;i++)for(let t=0;t<e;t++){let o=r[i][t];this.threshold&&Math.abs(o)<this.threshold&&(o=0),0!==o&&this.elements.set(i*e+t,r[i][t])}}else this._init(t,e,new HashTable(i),i.threshold)}_init(t,e,i,r){this.rows=t,this.columns=e,this.elements=i,this.threshold=r||0}static eye(t=1,e=t){const i=Math.min(t,e),r=new SparseMatrix(t,e,{initialCapacity:i});for(let t=0;t<i;t++)r.set(t,t,1);return r}clone(){return new SparseMatrix(this)}to2DArray(){const t=new Array(this.rows);for(let e=0;e<this.rows;e++){t[e]=new Array(this.columns);for(let i=0;i<this.columns;i++)t[e][i]=this.get(e,i)}return t}isSquare(){return this.rows===this.columns}isSymmetric(){if(!this.isSquare())return!1;let t=!0;return this.forEachNonZero(((e,i,r)=>this.get(i,e)!==r?(t=!1,!1):r)),t}bandWidth(){let t=this.columns,e=-1;return this.forEachNonZero(((i,r,o)=>{let n=i-r;return t=Math.min(t,n),e=Math.max(e,n),o})),e-t}isBanded(t){return this.bandWidth()<=t}get cardinality(){return this.elements.size}get size(){return this.rows*this.columns}get(t,e){return this.elements.get(t*this.columns+e)}set(t,e,i){return this.threshold&&Math.abs(i)<this.threshold&&(i=0),0===i?this.elements.remove(t*this.columns+e):this.elements.set(t*this.columns+e,i),this}mmul(t){this.columns!==t.rows&&console.warn("Number of columns of left matrix are not equal to number of rows of right matrix.");const e=this.rows,i=t.columns,r=new SparseMatrix(e,i);return this.forEachNonZero(((e,i,o)=>(t.forEachNonZero(((t,n,s)=>(i===t&&r.set(e,n,r.get(e,n)+o*s),s))),o))),r}kroneckerProduct(t){const e=this.rows,i=this.columns,r=t.rows,o=t.columns,n=new SparseMatrix(e*r,i*o,{initialCapacity:this.cardinality*t.cardinality});return this.forEachNonZero(((e,i,s)=>(t.forEachNonZero(((t,l,a)=>(n.set(r*e+t,o*i+l,s*a),a))),s))),n}forEachNonZero(t){return this.elements.forEachPair(((e,i)=>{const r=e/this.columns|0,o=e%this.columns;let n=t(r,o,i);return!1!==n&&(this.threshold&&Math.abs(n)<this.threshold&&(n=0),n!==i&&(0===n?this.elements.remove(e,!0):this.elements.set(e,n)),!0)})),this.elements.maybeShrinkCapacity(),this}getNonZeros(){const t=this.cardinality,e=new Array(t),i=new Array(t),r=new Array(t);let o=0;return this.forEachNonZero(((t,n,s)=>(e[o]=t,i[o]=n,r[o]=s,o++,s))),{rows:e,columns:i,values:r}}setThreshold(t){return 0!==t&&t!==this.threshold&&(this.threshold=t,this.forEachNonZero(((t,e,i)=>i))),this}transpose(){let t=new SparseMatrix(this.columns,this.rows,{initialCapacity:this.cardinality});return this.forEachNonZero(((e,i,r)=>(t.set(i,e,r),r))),t}isEmpty(){return 0===this.rows||0===this.columns}}SparseMatrix.prototype.klass="Matrix",SparseMatrix.identity=SparseMatrix.eye,SparseMatrix.prototype.tensorProduct=SparseMatrix.prototype.kroneckerProduct;let inplaceOperator="\n(function %name%(value) {\n    if (typeof value === 'number') return this.%name%S(value);\n    return this.%name%M(value);\n})\n",inplaceOperatorScalar="\n(function %name%S(value) {\n    this.forEachNonZero((i, j, v) => v %op% value);\n    return this;\n})\n",inplaceOperatorMatrix="\n(function %name%M(matrix) {\n    matrix.forEachNonZero((i, j, v) => {\n        this.set(i, j, this.get(i, j) %op% v);\n        return v;\n    });\n    return this;\n})\n",staticOperator="\n(function %name%(matrix, value) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%(value);\n})\n",inplaceMethod="\n(function %name%() {\n    this.forEachNonZero((i, j, v) => %method%(v));\n    return this;\n})\n",staticMethod="\n(function %name%(matrix) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%();\n})\n";const operators=[["+","add"],["-","sub","subtract"],["*","mul","multiply"],["/","div","divide"],["%","mod","modulus"],["&","and"],["|","or"],["^","xor"],["<<","leftShift"],[">>","signPropagatingRightShift"],[">>>","rightShift","zeroFillRightShift"]];for(const operator of operators)for(let i=1;i<operator.length;i++)SparseMatrix.prototype[operator[i]]=eval(fillTemplateFunction(inplaceOperator,{name:operator[i],op:operator[0]})),SparseMatrix.prototype[`${operator[i]}S`]=eval(fillTemplateFunction(inplaceOperatorScalar,{name:`${operator[i]}S`,op:operator[0]})),SparseMatrix.prototype[`${operator[i]}M`]=eval(fillTemplateFunction(inplaceOperatorMatrix,{name:`${operator[i]}M`,op:operator[0]})),SparseMatrix[operator[i]]=eval(fillTemplateFunction(staticOperator,{name:operator[i]}));let methods=[["~","not"]];["abs","acos","acosh","asin","asinh","atan","atanh","cbrt","ceil","clz32","cos","cosh","exp","expm1","floor","fround","log","log1p","log10","log2","round","sign","sin","sinh","sqrt","tan","tanh","trunc"].forEach((function(t){methods.push([`Math.${t}`,t])}));for(const method of methods)for(let i=1;i<method.length;i++)SparseMatrix.prototype[method[i]]=eval(fillTemplateFunction(inplaceMethod,{name:method[i],method:method[0]})),SparseMatrix[method[i]]=eval(fillTemplateFunction(staticMethod,{name:method[i]}));function fillTemplateFunction(t,e){for(const i in e)t=t.replace(new RegExp(`%${i}%`,"g"),e[i]);return t}function addBaseline(t,e){if(!e)return t;let i=t.x,r=t.y;for(let t=0;t<i.length;t++)r[t]+=e(i[t]);return t}var defaultSource=Math.random,randomUniform=function t(e){function i(t,i){return t=null==t?0:+t,i=null==i?1:+i,1===arguments.length?(i=t,t=0):i-=t,function(){return e()*i+t}}return i.source=t,i}(defaultSource),randomNormal=function t(e){function i(t,i){var r,o;return t=null==t?0:+t,i=null==i?1:+i,function(){var n;if(null!=r)n=r,r=null;else do{r=2*e()-1,n=2*e()-1,o=r*r+n*n}while(!o||o>1);return t+i*n*Math.sqrt(-2*Math.log(o)/o)}}return i.source=t,i}(defaultSource);const LOOP=8,FLOAT_MUL=1/16777216,sh1=15,sh2=18,sh3=11;function multiply_uint32(t,e){const i=65535&(t>>>=0);return((t-i)*(e>>>=0)>>>0)+i*e>>>0}class XSadd{constructor(t=Date.now()){this.state=new Uint32Array(4),this.init(t),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*FLOAT_MUL}init(t){if(!Number.isInteger(t))throw new TypeError("seed must be an integer");this.state[0]=t,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let t=1;t<LOOP;t++)this.state[3&t]^=t+multiply_uint32(1812433253,this.state[t-1&3]^this.state[t-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let t=0;t<LOOP;t++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let t=this.state[0];t^=t<<sh1,t^=t>>>sh2,t^=this.state[3]<<sh3,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=t}}function addNoise(t,e=0,i={}){const{distribution:r="uniform",seed:o}=i;let n;switch(r){case"uniform":n=getRandom(randomUniform,o,-.5,.5);break;case"normal":n=getRandom(randomNormal,o);break;default:throw new Error(`Unknown distribution ${i.distribution}`)}if(!e)return t;let s=t.y,l=e*findMax(s)/100;for(let t=0;t<s.length;t++)s[t]+=n()*l;return t}function getRandom(t,e,...i){return"number"==typeof e?t.source(new XSadd(e).random)(...i):t(...i)}function findMax(t){let e=Number.MIN_VALUE;for(let i of t)i>e&&(e=i);return e}class SpectrumGenerator{constructor(t={}){t=Object.assign({},{from:0,to:1e3,nbPoints:10001,peakWidthFct:()=>5,shape:{kind:"gaussian"}},t),this.from=t.from,this.to=t.to,this.nbPoints=t.nbPoints,this.interval=(this.to-this.from)/(this.nbPoints-1),this.peakWidthFct=t.peakWidthFct,this.maxPeakHeight=Number.MIN_SAFE_INTEGER;let e=getShapeGenerator(t.shape);if(this.shape=e,assertNumber(this.from,"from"),assertNumber(this.to,"to"),assertInteger(this.nbPoints,"nbPoints"),this.to<=this.from)throw new RangeError("to option must be larger than from");if("function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(t,e){if(!(Array.isArray(t)||"object"==typeof t&&void 0!==t.x&&void 0!==t.y&&Array.isArray(t.x)&&Array.isArray(t.y)&&t.x.length===t.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(t))for(const i of t)this.addPeak(i,e);else for(let i=0;i<t.x.length;i++)this.addPeak([t.x[i],t.y[i]],e);return this}addPeak(t,e={}){if("object"!=typeof t||2!==t.length&&3!==t.length&&(void 0===t.x||void 0===t.y))throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");let i,r,o,n;Array.isArray(t)?[i,r,o,n]=t:(i=t.x,r=t.y,o=t.width,n=t.options),r>this.maxPeakHeight&&(this.maxPeakHeight=r);let{width:s=(void 0===o?this.peakWidthFct(i):o),widthLeft:l,widthRight:a,shape:u}=e;n&&Object.assign(u||{},n||{});let h=u?getShapeGenerator(u):this.shape;l||(l=s),a||(a=s);let c=void 0===e.factor?h.getFactor():e.factor;const f=i-l/2*c,p=i+a/2*c,m=Math.max(0,Math.floor((f-this.from)/this.interval)),g=Math.min(this.nbPoints-1,Math.ceil((p-this.from)/this.interval)),y=Math.round((i-this.from)/this.interval);h.setFWHM(l);for(let t=m;t<Math.max(y,0);t++)this.data.y[t]+=r*h.fct(this.data.x[t]-i);h.setFWHM(a);for(let t=Math.min(y,g);t<=g;t++)this.data.y[t]+=r*h.fct(this.data.x[t]-i);return this}addBaseline(t){return addBaseline(this.data,t),this}addNoise(t,e){return addNoise(this.data,t,e),this}getSpectrum(t={}){"boolean"==typeof t&&(t={copy:t});const{copy:e=!0,threshold:i=0}=t;if(i){let t=this.maxPeakHeight*i,e=[],r=[];for(let i=0;i<this.data.x.length;i++)this.data.y[i]>=t&&(e.push(this.data.x[i]),r.push(this.data.y[i]));return{x:e,y:r}}return e?{x:this.data.x.slice(),y:this.data.y.slice()}:this.data}reset(){const t=this.data={x:new Float64Array(this.nbPoints),y:new Float64Array(this.nbPoints)};for(let e=0;e<this.nbPoints;e++)t.x[e]=this.from+e*this.interval;return this}}function assertInteger(t,e){if(!Number.isInteger(t))throw new TypeError(`${e} option must be an integer`)}function assertNumber(t,e){if(!Number.isFinite(t))throw new TypeError(`${e} option must be a number`)}function createPauli(t){const e=(t-1)/2,i=new Array(t),r=new Array(t);for(let o=0;o<t;o++)i[o]=t-1-o-e,r[o]=Math.sqrt(e*(e+1)-i[o]*(i[o]+1));const o=diag(r,1,t,t);for(let o=0;o<t;o++)r[o]=Math.sqrt(e*(e+1)-i[o]*(i[o]-1));const n=diag(r,-1,t,t);return{x:o.clone().add(n).mul(.5),y:n.clone().mul(-1).add(o).mul(-.5),z:diag(i,0,t,t),m:n,p:o}}function diag(t,e,i,r){const o=new SparseMatrix(i,r,{initialCapacity:20});for(let n=0;n<t.length;n++)n-e>=0&&n-e<i&&n<r&&o.set(n-e,n,t[n]);return o}const pauli2=createPauli(2);function getPauliMatrix(t){return 2===t?pauli2:createPauli(t)}const smallValue=.01;function simulate1D(t,e){let{lineWidth:i=1,maxClusterSize:r=10,frequency:o=400,shape:n={kind:"gaussian",options:{from:0,to:10,nbPoints:1024}}}=e,{options:s}=n,l=i/o;s.peakWidthFct=()=>l;let a=new SpectrumGenerator(s);const u=t.chemicalShifts.slice();for(let t=0;t<u.length;t++)u[t]=u[t]*o;const h=t.multiplicity;for(let e=0;e<t.clusters.length;e++){const n=t.clusters[e];let s=new Array(n.length);for(let t=0;t<n.length;t++)s[t]=n[t]<0?-n[t]-1:n[t];let l=1,c=0,f=[],p=[];if(n.length>r){let e=0;for(;n[e++]<0;);e=n[e-1],f.push(-u[e]);for(let i=0;i<n.length;i++)if(n[i]<0){let r=t.couplingConstants.get(e,s[i])/2,o=f.length;for(let t=0;t<o;t++)f.push(f[t]+r),f[t]-=r}f=Float64Array.from(f).sort(),c=f.length,l=1;for(let t=0;t<c;t++)p.push(1)}else{const e=getHamiltonian(u,t.couplingConstants,h,t.connectivity,s),i=e.rows,r=new EigenvalueDecomposition(e),o=r.eigenvectorMatrix,a=r.realEigenvalues,m=new SparseMatrix(i,i),g=n.length;l=0;for(let t=0;t<g;t++){const e=getPauliMatrix(h[s[t]]);let i=1;for(let e=0;e<t;e++)i*=h[s[e]];const r=SparseMatrix.eye(i);i=1;for(let e=t+1;e<g;e++)i*=h[s[e]];const o=SparseMatrix.eye(i),a=r.kroneckerProduct(e.m).kroneckerProduct(o);n[t]>=0?(m.add(a.mul(n[t]+1)),l++):m.add(a.mul(n[t]))}let y=Matrix.zeros(i,i);m.forEachNonZero(((t,e,i)=>{if(i>0)for(let i=0;i<o.columns;i++){let r=o.get(e,i);0!==r&&y.set(t,i,y.get(t,i)+r)}return i}));let d=y.clone();m.forEachNonZero(((t,e,i)=>{if(i<0)for(let i=0;i<o.columns;i++){let r=o.get(e,i);0!==r&&d.set(t,i,d.get(t,i)+r)}return i}));const w=o.transpose();y=w.mmul(y),y=new SparseMatrix(y.to2DArray(),{threshold:smallValue}),triuTimesAbs(y,smallValue),d=w.mmul(d),d=new SparseMatrix(d.to2DArray(),{threshold:smallValue}),d.forEachNonZero(((t,e,i)=>i)),triuTimesAbs(d,smallValue),d.forEachNonZero(((t,e,i)=>{let r=y.get(t,e);r=Math.min(Math.abs(r),Math.abs(i)),r*=r,c+=r;let o=a[t]-a[e],n=binarySearch(f,o,((t,e)=>t-e));n<0?(f.splice(-1-n,0,o),p.splice(-1-n,0,r)):p[n]+=r}))}const m=f.length;if(m>0){l/=c;const t=i/64;let e=f[0],r=p[0],n=1;for(let i=1;i<m;i++)Math.abs(f[i]-e/n)<t?(r+=p[i],e+=f[i],n++):(a.addPeak({x:-e/n/o,y:r*l}),e=f[i],r=p[i],n=1);a.addPeak({x:-e/n/o,y:r*l})}}return a.data}function triuTimesAbs(t,e){t.forEachNonZero(((t,i,r)=>t>i||Math.abs(r)<=e?0:r))}function getHamiltonian(t,e,i,r,o){let n=1;for(let t=0;t<o.length;t++)n*=i[o[t]];const s=new SparseMatrix(n,n);for(let n=0;n<o.length;n++){let l=o[n];const a=getPauliMatrix(i[l]);let u,h,c=1;for(let t=0;t<n;t++)c*=i[o[t]];u=SparseMatrix.eye(c),c=1;for(let t=n+1;t<o.length;t++)c*=i[o[t]];h=SparseMatrix.eye(c);const f=t[l],p=u.kroneckerProduct(a.z).kroneckerProduct(h);s.add(p.mul(f));for(let t=0;t<o.length;t++){const n=o[t];if(1===r.get(l,n)){const r=getPauliMatrix(i[n]);let c,f,p=1;for(let e=0;e<t;e++)p*=i[o[e]];c=SparseMatrix.eye(p),p=1;for(let e=t+1;e<o.length;e++)p*=i[o[e]];f=SparseMatrix.eye(p);const m=u.kroneckerProduct(a.x).kroneckerProduct(h).mmul(c.kroneckerProduct(r.x).kroneckerProduct(f));m.add(u.kroneckerProduct(a.y).kroneckerProduct(h).mul(-1).mmul(c.kroneckerProduct(r.y).kroneckerProduct(f))),m.add(u.kroneckerProduct(a.z).kroneckerProduct(h).mmul(c.kroneckerProduct(r.z).kroneckerProduct(f))),s.add(m.mul(e.get(l,n)/2))}}}return s}function squaredEuclidean(t,e){let i=0;for(let r=0;r<t.length;r++)i+=(t[r]-e[r])*(t[r]-e[r]);return i}function euclidean(t,e){return Math.sqrt(squaredEuclidean(t,e))}function distanceMatrix(t,e){const i=getMatrix(t.length);for(let r=0;r<t.length;r++)for(let o=0;o<=r;o++)i[r][o]=e(t[r],t[o]),i[o][r]=i[r][o];return i}function getMatrix(t){const e=[];for(let i=0;i<t;i++){const i=[];e.push(i);for(let e=0;e<t;e++)i.push(0)}return e}var heap$1={exports:{}};!function(t,e){(function(){var e,i,r,o,n,s,l,a,u,h,c,f,p,m,g;r=Math.floor,h=Math.min,i=function(t,e){return t<e?-1:t>e?1:0},u=function(t,e,o,n,s){var l;if(null==o&&(o=0),null==s&&(s=i),o<0)throw new Error("lo must be non-negative");for(null==n&&(n=t.length);o<n;)s(e,t[l=r((o+n)/2)])<0?n=l:o=l+1;return[].splice.apply(t,[o,o-o].concat(e)),e},s=function(t,e,r){return null==r&&(r=i),t.push(e),m(t,0,t.length-1,r)},n=function(t,e){var r,o;return null==e&&(e=i),r=t.pop(),t.length?(o=t[0],t[0]=r,g(t,0,e)):o=r,o},a=function(t,e,r){var o;return null==r&&(r=i),o=t[0],t[0]=e,g(t,0,r),o},l=function(t,e,r){var o;return null==r&&(r=i),t.length&&r(t[0],e)<0&&(e=(o=[t[0],e])[0],t[0]=o[1],g(t,0,r)),e},o=function(t,e){var o,n,s,l,a,u;for(null==e&&(e=i),a=[],n=0,s=(l=function(){u=[];for(var e=0,i=r(t.length/2);0<=i?e<i:e>i;0<=i?e++:e--)u.push(e);return u}.apply(this).reverse()).length;n<s;n++)o=l[n],a.push(g(t,o,e));return a},p=function(t,e,r){var o;if(null==r&&(r=i),-1!==(o=t.indexOf(e)))return m(t,0,o,r),g(t,o,r)},c=function(t,e,r){var n,s,a,u,h;if(null==r&&(r=i),!(s=t.slice(0,e)).length)return s;for(o(s,r),a=0,u=(h=t.slice(e)).length;a<u;a++)n=h[a],l(s,n,r);return s.sort(r).reverse()},f=function(t,e,r){var s,l,a,c,f,p,m,g,y;if(null==r&&(r=i),10*e<=t.length){if(!(a=t.slice(0,e).sort(r)).length)return a;for(l=a[a.length-1],c=0,p=(m=t.slice(e)).length;c<p;c++)r(s=m[c],l)<0&&(u(a,s,0,null,r),a.pop(),l=a[a.length-1]);return a}for(o(t,r),y=[],f=0,g=h(e,t.length);0<=g?f<g:f>g;0<=g?++f:--f)y.push(n(t,r));return y},m=function(t,e,r,o){var n,s,l;for(null==o&&(o=i),n=t[r];r>e&&o(n,s=t[l=r-1>>1])<0;)t[r]=s,r=l;return t[r]=n},g=function(t,e,r){var o,n,s,l,a;for(null==r&&(r=i),n=t.length,a=e,s=t[e],o=2*e+1;o<n;)(l=o+1)<n&&!(r(t[o],t[l])<0)&&(o=l),t[e]=t[o],o=2*(e=o)+1;return t[e]=s,m(t,a,e,r)},e=function(){function t(t){this.cmp=null!=t?t:i,this.nodes=[]}return t.push=s,t.pop=n,t.replace=a,t.pushpop=l,t.heapify=o,t.updateItem=p,t.nlargest=c,t.nsmallest=f,t.prototype.push=function(t){return s(this.nodes,t,this.cmp)},t.prototype.pop=function(){return n(this.nodes,this.cmp)},t.prototype.peek=function(){return this.nodes[0]},t.prototype.contains=function(t){return-1!==this.nodes.indexOf(t)},t.prototype.replace=function(t){return a(this.nodes,t,this.cmp)},t.prototype.pushpop=function(t){return l(this.nodes,t,this.cmp)},t.prototype.heapify=function(){return o(this.nodes,this.cmp)},t.prototype.updateItem=function(t){return p(this.nodes,t,this.cmp)},t.prototype.clear=function(){return this.nodes=[]},t.prototype.empty=function(){return 0===this.nodes.length},t.prototype.size=function(){return this.nodes.length},t.prototype.clone=function(){var e;return(e=new t).nodes=this.nodes.slice(0),e},t.prototype.toArray=function(){return this.nodes.slice(0)},t.prototype.insert=t.prototype.push,t.prototype.top=t.prototype.peek,t.prototype.front=t.prototype.peek,t.prototype.has=t.prototype.contains,t.prototype.copy=t.prototype.clone,t}(),t.exports=e}).call(commonjsGlobal)}(heap$1);var heap=heap$1.exports;class Cluster{constructor(){this.children=[],this.height=0,this.size=1,this.index=-1,this.isLeaf=!1}cut(t){if("number"!=typeof t)throw new TypeError("threshold must be a number");if(t<0)throw new RangeError("threshold must be a positive number");let e=[this];const i=[];for(;e.length>0;){const r=e.shift();t>=r.height?i.push(r):e=e.concat(r.children)}return i}group(t){if(!Number.isInteger(t)||t<1)throw new RangeError("groups must be a positive integer");const e=new heap(((t,e)=>e.height-t.height));for(e.push(this);e.size()<t;){var i=e.pop();if(0===i.children.length)break;i.children.forEach((t=>e.push(t)))}var r=new Cluster;return r.children=e.toArray(),r.height=this.height,r}traverse(t){!function t(e,i){if(i(e),e.children)for(const r of e.children)t(r,i)}(this,t)}indices(){const t=[];return this.traverse((e=>{e.isLeaf&&t.push(e.index)})),t}}function singleLink(t,e){return Math.min(t,e)}function completeLink(t,e){return Math.max(t,e)}function averageLink(t,e,i,r,o){return r/(r+o)*t+o/(r+o)*e}function weightedAverageLink(t,e){return(t+e)/2}function centroidLink(t,e,i,r,o){return r/(r+o)*t+o/(r+o)*e+-r*o/(r+o)**2*i}function medianLink(t,e,i){return t/2+e/2-i/4}function wardLink(t,e,i,r,o,n){return(r+n)/(r+o+n)*t+(o+n)/(r+o+n)*e+-n/(r+o+n)*i}function wardLink2(t,e,i,r,o,n){const s=(r+n)/(r+o+n),l=(o+n)/(r+o+n),a=-n/(r+o+n);return Math.sqrt(s*t*t+l*e*e+a*i*i)}function agnes(t,e={}){const{distanceFunction:i=euclidean,method:r="complete",isDistanceMatrix:o=!1}=e;let n;o||(t=distanceMatrix(t,i));let s=new Matrix(t);const l=s.rows;if("string"==typeof r)switch(r.toLowerCase()){case"single":n=singleLink;break;case"complete":n=completeLink;break;case"average":case"upgma":n=averageLink;break;case"wpgma":n=weightedAverageLink;break;case"centroid":case"upgmc":n=centroidLink;break;case"median":case"wpgmc":n=medianLink;break;case"ward":n=wardLink;break;case"ward2":n=wardLink2;break;default:throw new RangeError(`unknown clustering method: ${r}`)}else if("function"!=typeof r)throw new TypeError("method must be a string or function");let a=[];for(let t=0;t<l;t++){const e=new Cluster;e.isLeaf=!0,e.index=t,a.push(e)}for(let t=0;t<l-1;t++){const[t,e,i]=getSmallestDistance(s),r=a[t],o=a[e],l=new Cluster;l.size=r.size+o.size,l.children.push(r,o),l.height=i;const u=[l],h=new Matrix(s.rows-1,s.rows-1),c=i=>getPreviousIndex(i,Math.min(t,e),Math.max(t,e));for(let l=1;l<h.rows;l++){const f=c(l),p=a[f];u.push(p);for(let a=0;a<l;a++)if(0===a){const u=n(s.get(t,f),s.get(f,e),i,r.size,o.size,p.size);h.set(l,a,u),h.set(a,l,u)}else{const t=s.get(f,c(a));h.set(l,a,t),h.set(a,l,t)}}a=u,s=h}return a[0]}function getSmallestDistance(t){let e=1/0,i=0,r=0;for(let o=1;o<t.rows;o++)for(let n=0;n<o;n++)t.get(o,n)<e&&(e=t.get(o,n),i=o,r=n);return[i,r,e]}function getPreviousIndex(t,e,i){return(t-=1)>=e&&t++,t>=i&&t++,t}function splitSpinSystem(t,e={}){let{chemicalShifts:i,couplingConstants:r,connectivity:o}=t,{frequency:n=400,maxClusterSize:s=8}=e,l=agnes(calculateBetas(i,r,n),{method:"single",isDistanceMatrix:!0}),a=[],u=i.length;splitCluster(l,a,{maxClusterSize:s,force:!1,nSpins:u,connectivity:o});let h=mergeClusters(a,s),c=h.length,f=new Array(c);for(let t=0;t<c;t++){f[t]=[];for(let e=0;e<u;e++){let i=h[t][e];0!==i&&f[t].push(i<0?-(e+1):e)}}return f}function splitCluster(t,e,i={}){let{maxClusterSize:r,force:o,nSpins:n,connectivity:s}=i;if(!o&&t.size<=r)e.push(getMembers(t.indices(),n));else for(let i of t.children)if(i.size<=r){let t=getMembers(i.indices(),n),o=0;for(let e=0;e<n;e++)if(1===t[e]){for(let i=0;i<n;i++)1===s.get(e,i)&&0===t[i]&&(t[i]=-1,o++);o++}o<=r?e.push(t):i.index<0?splitCluster(i,e,{maxClusterSize:r,force:!0,nSpins:n,connectivity:s}):(t[i.index]=2,e.push(t))}else splitCluster(i,e,{maxClusterSize:r,force:!1,nSpins:n,connectivity:s})}function calculateBetas(t,e,i){let r=e.rows,o=e.columns,n=Matrix.zeros(r,r);for(let s=0;s<r;s++)for(let r=s;r<o;r++){let o=e.get(s,r);if(t[s]-t[r]!=0){let e=1-Math.abs(o/((t[s]-t[r])*i));n.set(s,r,e),n.set(r,s,e)}else s!==r&&0===o&&(n.set(s,r,1),n.set(r,s,1))}return n.to2DArray()}function mergeClusters(t,e){for(let i=t.length-1;i>=0;i--){let r=t[i],o=r.length,n=0;for(;n<o&&-1!==r[n++];);if(!(n>=o))for(let n=t.length-1;n>=i+1;n--){let i=t[n],s=0,l=0;for(let t=0;t<o;t++)r[t]*i[t]==-1&&l++,0===r[t]&&0===i[t]||s++;if(l>0&&s<=e){for(let t=0;t<o;t++)1===i[t]?r[t]=1:-1===i[t]&&1!==r[t]&&(r[t]=-1);t.splice(n,1)}}}return t}function getMembers(t,e){let i=new Int16Array(e);for(let e of t)i[e]=1;return i}function signalsToXY(t,e={}){let{frequency:i=400,shape:r={kind:"gaussian",options:{from:0,to:10,nbPoints:16384}},maxValue:o=1e8,maxClusterSize:n=8}=e,s=signalsToSpinSystem(t);s.clusters=splitSpinSystem(s,{frequency:i,maxClusterSize:n});let l=simulate1D(s,{frequency:i,shape:r});return o&&(l.y=rescale(l.y,{max:o})),l}const couplingPatterns=["s","d","t","q","quint","h","sept","o","n"],couplingValues={s:0,d:1,t:2,q:3,quint:4,h:5,hex:5,hept:6,sept:6,oct:7,o:7,non:8,n:8};function joinPatterns(t){let e=0;for(let i of t){if(void 0===couplingValues[i])throw new Error(`Unknown multiplicity: ${i}`);e+=couplingValues[i]}return couplingPatterns[e]}function signalNormalize(t){if((t=JSON.parse(JSON.stringify(t))).assignment&&!Array.isArray(t.assignment)&&(t.assignment=[t.assignment]),t.diaID&&!Array.isArray(t.diaID)&&(t.diaID=[t.diaID]),t.j){let e=t.j;for(let t of e)t.assignment&&!Array.isArray(t.assignment)&&(t.assignment=[t.assignment]),t.diaID&&!Array.isArray(t.diaID)&&(t.diaID=[t.diaID]);t.j=t.j.sort(((t,e)=>e.coupling-t.coupling))}return t}function signalJoinCouplings(t,e={}){const{tolerance:i=.05}=e;if(!(t=signalNormalize(t)).j||t.j.length<2)return t;let r=[t.j[0]],o=[r];for(let e=1;e<t.j.length;e++){let n=t.j[e];r[r.length-1].coupling-n.coupling<i?r.push(n):(r=[n],o.push(r))}t.j=[];for(let e of o){let i=sum(e.map((t=>t.coupling)))/e.length,r=distinctValues(e.filter((t=>t.assignment&&t.assignment.length>0)).map((t=>t.assignment)).flat()),o=distinctValues(e.filter((t=>t.diaID&&t.diaID.length>0)).map((t=>t.diaID)).flat()),n=distinctValues(e.map((t=>t.distance))),s={coupling:i,multiplicity:joinPatterns(e.map((t=>t.multiplicity)))};o.length>0&&(s.diaID=o),1===n.length&&n[0]&&(s.distance=n[0]),r.length>0&&(s.assignment=r),t.j.push(s)}return t}function distinctValues(t){return[...new Set(t)]}function signalMultiplicityPattern(t){let e=t.j,i="";if(e&&e.length>0)for(let t of e)i+=t.multiplicity;else i=t.delta?"s":"m";return i}const globalOptions={h:{nucleus:"1H",nbDecimalDelta:2,nbDecimalJ:1,observedFrequency:400},c:{nucleus:"13C",nbDecimalDelta:1,nbDecimalJ:1,observedFrequency:100},f:{nucleus:"19F",nbDecimalDelta:2,nbDecimalJ:1,observedFrequency:400}};function rangesToACS(t,e={}){e.nucleus||(e.nucleus="1H");let i=e.nucleus.toLowerCase().replace(/[0-9]/g,""),r=globalOptions[i];e=Object.assign({},r,{ascending:!1,format:"IMJA"},e),t=JSON.parse(JSON.stringify(t)),!0===e.ascending&&t.sort(((t,e)=>Math.min(t.from,t.to)-Math.min(e.from,e.to)));let o=formatAcs(t,e);return o.length>0&&(o+="."),o}function formatAcs(t,e){let i=spectroInformation(e);0===i.length&&(i="δ ");let r=[];for(let i of t)uselessKind(i.kind,e.filter)||pushDelta(i,r,e);return r.length>0?i+r.join(", "):""}function spectroInformation(t){let e=[],i=`${formatNucleus(t.nucleus)} NMR`;return t.solvent&&e.push(formatMF(t.solvent)),t.frequencyObserved&&e.push(`${(1*t.frequencyObserved).toFixed(0)} MHz`),e.length>0?i+=` (${e.join(", ")}): δ `:i+=": δ ",i}function pushDelta(t,e,i){let r="",o=[],n=[t.from,t.to];if(Array.isArray(t.signal)&&(t.signal=t.signal.filter((t=>!uselessKind(t.kind,i.filter)))),Array.isArray(t.signal)&&t.signal.length>0){let e=t.signal;if(e.length>1){!0===i.ascending&&e.sort(((t,e)=>t.delta-e.delta)),r+=`${Math.min(...n).toFixed(i.nbDecimalDelta)}-${Math.max(...n).toFixed(i.nbDecimalDelta)}`,r+=` (${getIntegral(t,i)}`;for(let t of e)o=[],void 0!==t.delta&&(r=appendSeparator(r),r+=t.delta.toFixed(i.nbDecimalDelta)),switchFormat({},t,o,i),o.length>0&&(r+=` (${o.join(", ")})`);r+=")"}else o=[],void 0!==e[0].delta?(r+=e[0].delta.toFixed(i.nbDecimalDelta),switchFormat(t,e[0],o,i),o.length>0&&(r+=` (${o.join(", ")})`)):(r+=`${Math.min(...n).toFixed(i.nbDecimalDelta)}-${Math.max(...n).toFixed(i.nbDecimalDelta)}`,switchFormat(t,e[0],o,i),o.length>0&&(r+=` (${o})`))}else r+=`${Math.min(...n).toFixed(i.nbDecimalDelta)}-${Math.max(...n).toFixed(i.nbDecimalDelta)}`,switchFormat(t,[],o,i),o.length>0&&(r+=` (${o.join(", ")})`);e.push(r)}function getIntegral(t,e){let i="";return t.pubIntegral?i=t.pubIntegral:t.integral&&(i=t.integral.toFixed(0)+e.nucleus[e.nucleus.length-1]),i}function pushIntegral(t,e,i){let r=getIntegral(t,i);r.length>0&&e.push(r)}function pushMultiplicityFromSignal(t,e){let i=t.multiplicity;if(!i){i=signalMultiplicityPattern(signalJoinCouplings(t,{tolerance:.05}))}i.length>0&&e.push(i)}function switchFormat(t,e,i,r){for(const o of r.format)switch(o.toUpperCase()){case"I":pushIntegral(t,i,r);break;case"M":pushMultiplicityFromSignal(e,i);break;case"A":pushAssignment(e,i);break;case"J":pushCoupling(e,i,r);break;default:throw new Error(`Unknow format letter: ${o}`)}}function formatMF(t){return t.replace(/(?<num>[0-9]+)/g,"<sub>$<num></sub>")}function formatNucleus(t){return t.replace(/(?<num>[0-9]+)/g,"<sup>$<num></sup>")}function appendSeparator(t){return t.length>0&&!t.match(/ $/)&&!t.match(/\($/)&&(t+=", "),t}function formatAssignment(t){return t=(t=t.replace(/(?<num>[0-9]+)/g,"<sub>$<num></sub>")).replace(/"(?<i>[^"]*)"/g,"<i>$<i></i>")}function pushCoupling(t,e,i){if(Array.isArray(t.j)&&t.j.length>0){t.j.sort((function(t,e){return e.coupling-t.coupling}));let r=[];for(let e of t.j)void 0!==e.coupling&&r.push(e.coupling.toFixed(i.nbDecimalJ));r.length>0&&e.push(`<i>J</i> = ${r.join(", ")} Hz`)}}function pushAssignment(t,e){t.pubAssignment?e.push(formatAssignment(t.pubAssignment)):t.assignment&&e.push(formatAssignment(t.assignment))}function uselessKind(t="",e=!0){return t=t.toLowerCase(),!(!e||"impurity"!==t&&"solvent"!==t)}var browserPonyfill={exports:{}};!function(t,e){var i="undefined"!=typeof self?self:commonjsGlobal,r=function(){function t(){this.fetch=!1,this.DOMException=i.DOMException}return t.prototype=i,new t}();!function(t){!function(e){var i="URLSearchParams"in t,r="Symbol"in t&&"iterator"in Symbol,o="FileReader"in t&&"Blob"in t&&function(){try{return new Blob,!0}catch(t){return!1}}(),n="FormData"in t,s="ArrayBuffer"in t;if(s)var l=["[object Int8Array]","[object Uint8Array]","[object Uint8ClampedArray]","[object Int16Array]","[object Uint16Array]","[object Int32Array]","[object Uint32Array]","[object Float32Array]","[object Float64Array]"],a=ArrayBuffer.isView||function(t){return t&&l.indexOf(Object.prototype.toString.call(t))>-1};function u(t){if("string"!=typeof t&&(t=String(t)),/[^a-z0-9\-#$%&'*+.^_`|~]/i.test(t))throw new TypeError("Invalid character in header field name");return t.toLowerCase()}function h(t){return"string"!=typeof t&&(t=String(t)),t}function c(t){var e={next:function(){var e=t.shift();return{done:void 0===e,value:e}}};return r&&(e[Symbol.iterator]=function(){return e}),e}function f(t){this.map={},t instanceof f?t.forEach((function(t,e){this.append(e,t)}),this):Array.isArray(t)?t.forEach((function(t){this.append(t[0],t[1])}),this):t&&Object.getOwnPropertyNames(t).forEach((function(e){this.append(e,t[e])}),this)}function p(t){if(t.bodyUsed)return Promise.reject(new TypeError("Already read"));t.bodyUsed=!0}function m(t){return new Promise((function(e,i){t.onload=function(){e(t.result)},t.onerror=function(){i(t.error)}}))}function g(t){var e=new FileReader,i=m(e);return e.readAsArrayBuffer(t),i}function y(t){if(t.slice)return t.slice(0);var e=new Uint8Array(t.byteLength);return e.set(new Uint8Array(t)),e.buffer}function d(){return this.bodyUsed=!1,this._initBody=function(t){var e;this._bodyInit=t,t?"string"==typeof t?this._bodyText=t:o&&Blob.prototype.isPrototypeOf(t)?this._bodyBlob=t:n&&FormData.prototype.isPrototypeOf(t)?this._bodyFormData=t:i&&URLSearchParams.prototype.isPrototypeOf(t)?this._bodyText=t.toString():s&&o&&((e=t)&&DataView.prototype.isPrototypeOf(e))?(this._bodyArrayBuffer=y(t.buffer),this._bodyInit=new Blob([this._bodyArrayBuffer])):s&&(ArrayBuffer.prototype.isPrototypeOf(t)||a(t))?this._bodyArrayBuffer=y(t):this._bodyText=t=Object.prototype.toString.call(t):this._bodyText="",this.headers.get("content-type")||("string"==typeof t?this.headers.set("content-type","text/plain;charset=UTF-8"):this._bodyBlob&&this._bodyBlob.type?this.headers.set("content-type",this._bodyBlob.type):i&&URLSearchParams.prototype.isPrototypeOf(t)&&this.headers.set("content-type","application/x-www-form-urlencoded;charset=UTF-8"))},o&&(this.blob=function(){var t=p(this);if(t)return t;if(this._bodyBlob)return Promise.resolve(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(new Blob([this._bodyArrayBuffer]));if(this._bodyFormData)throw new Error("could not read FormData body as blob");return Promise.resolve(new Blob([this._bodyText]))},this.arrayBuffer=function(){return this._bodyArrayBuffer?p(this)||Promise.resolve(this._bodyArrayBuffer):this.blob().then(g)}),this.text=function(){var t,e,i,r=p(this);if(r)return r;if(this._bodyBlob)return t=this._bodyBlob,e=new FileReader,i=m(e),e.readAsText(t),i;if(this._bodyArrayBuffer)return Promise.resolve(function(t){for(var e=new Uint8Array(t),i=new Array(e.length),r=0;r<e.length;r++)i[r]=String.fromCharCode(e[r]);return i.join("")}(this._bodyArrayBuffer));if(this._bodyFormData)throw new Error("could not read FormData body as text");return Promise.resolve(this._bodyText)},n&&(this.formData=function(){return this.text().then(b)}),this.json=function(){return this.text().then(JSON.parse)},this}f.prototype.append=function(t,e){t=u(t),e=h(e);var i=this.map[t];this.map[t]=i?i+", "+e:e},f.prototype.delete=function(t){delete this.map[u(t)]},f.prototype.get=function(t){return t=u(t),this.has(t)?this.map[t]:null},f.prototype.has=function(t){return this.map.hasOwnProperty(u(t))},f.prototype.set=function(t,e){this.map[u(t)]=h(e)},f.prototype.forEach=function(t,e){for(var i in this.map)this.map.hasOwnProperty(i)&&t.call(e,this.map[i],i,this)},f.prototype.keys=function(){var t=[];return this.forEach((function(e,i){t.push(i)})),c(t)},f.prototype.values=function(){var t=[];return this.forEach((function(e){t.push(e)})),c(t)},f.prototype.entries=function(){var t=[];return this.forEach((function(e,i){t.push([i,e])})),c(t)},r&&(f.prototype[Symbol.iterator]=f.prototype.entries);var w=["DELETE","GET","HEAD","OPTIONS","POST","PUT"];function x(t,e){var i,r,o=(e=e||{}).body;if(t instanceof x){if(t.bodyUsed)throw new TypeError("Already read");this.url=t.url,this.credentials=t.credentials,e.headers||(this.headers=new f(t.headers)),this.method=t.method,this.mode=t.mode,this.signal=t.signal,o||null==t._bodyInit||(o=t._bodyInit,t.bodyUsed=!0)}else this.url=String(t);if(this.credentials=e.credentials||this.credentials||"same-origin",!e.headers&&this.headers||(this.headers=new f(e.headers)),this.method=(i=e.method||this.method||"GET",r=i.toUpperCase(),w.indexOf(r)>-1?r:i),this.mode=e.mode||this.mode||null,this.signal=e.signal||this.signal,this.referrer=null,("GET"===this.method||"HEAD"===this.method)&&o)throw new TypeError("Body not allowed for GET or HEAD requests");this._initBody(o)}function b(t){var e=new FormData;return t.trim().split("&").forEach((function(t){if(t){var i=t.split("="),r=i.shift().replace(/\+/g," "),o=i.join("=").replace(/\+/g," ");e.append(decodeURIComponent(r),decodeURIComponent(o))}})),e}function M(t,e){e||(e={}),this.type="default",this.status=void 0===e.status?200:e.status,this.ok=this.status>=200&&this.status<300,this.statusText="statusText"in e?e.statusText:"OK",this.headers=new f(e.headers),this.url=e.url||"",this._initBody(t)}x.prototype.clone=function(){return new x(this,{body:this._bodyInit})},d.call(x.prototype),d.call(M.prototype),M.prototype.clone=function(){return new M(this._bodyInit,{status:this.status,statusText:this.statusText,headers:new f(this.headers),url:this.url})},M.error=function(){var t=new M(null,{status:0,statusText:""});return t.type="error",t};var C=[301,302,303,307,308];M.redirect=function(t,e){if(-1===C.indexOf(e))throw new RangeError("Invalid status code");return new M(null,{status:e,headers:{location:t}})},e.DOMException=t.DOMException;try{new e.DOMException}catch(t){e.DOMException=function(t,e){this.message=t,this.name=e;var i=Error(t);this.stack=i.stack},e.DOMException.prototype=Object.create(Error.prototype),e.DOMException.prototype.constructor=e.DOMException}function v(t,i){return new Promise((function(r,n){var s=new x(t,i);if(s.signal&&s.signal.aborted)return n(new e.DOMException("Aborted","AbortError"));var l=new XMLHttpRequest;function a(){l.abort()}l.onload=function(){var t,e,i={status:l.status,statusText:l.statusText,headers:(t=l.getAllResponseHeaders()||"",e=new f,t.replace(/\r?\n[\t ]+/g," ").split(/\r?\n/).forEach((function(t){var i=t.split(":"),r=i.shift().trim();if(r){var o=i.join(":").trim();e.append(r,o)}})),e)};i.url="responseURL"in l?l.responseURL:i.headers.get("X-Request-URL");var o="response"in l?l.response:l.responseText;r(new M(o,i))},l.onerror=function(){n(new TypeError("Network request failed"))},l.ontimeout=function(){n(new TypeError("Network request failed"))},l.onabort=function(){n(new e.DOMException("Aborted","AbortError"))},l.open(s.method,s.url,!0),"include"===s.credentials?l.withCredentials=!0:"omit"===s.credentials&&(l.withCredentials=!1),"responseType"in l&&o&&(l.responseType="blob"),s.headers.forEach((function(t,e){l.setRequestHeader(e,t)})),s.signal&&(s.signal.addEventListener("abort",a),l.onreadystatechange=function(){4===l.readyState&&s.signal.removeEventListener("abort",a)}),l.send(void 0===s._bodyInit?null:s._bodyInit)}))}v.polyfill=!0,t.fetch||(t.fetch=v,t.Headers=f,t.Request=x,t.Response=M),e.Headers=f,e.Request=x,e.Response=M,e.fetch=v,Object.defineProperty(e,"__esModule",{value:!0})}({})}(r),r.fetch.ponyfill=!0,delete r.fetch.polyfill;var o=r;(e=o.fetch).default=o.fetch,e.fetch=o.fetch,e.Headers=o.Headers,e.Request=o.Request,e.Response=o.Response,t.exports=e}(browserPonyfill,browserPonyfill.exports);var fetch=getDefaultExportFromCjs(browserPonyfill.exports),browser="object"==typeof self?self.FormData:window.FormData;let xAtomicNumber=0;function tagAtom(t,e){let i=`${t.getAtomLabel(e)}*`;return t.setAtomCustomLabel(e,i),1===t.getAtomicNo(e)?t.setAtomicNo(e,getXAtomicNumber(t)):t.setAtomMass(e,t.getAtomMass(e)+5),i}function getXAtomicNumber(t){if(!xAtomicNumber){const e=t.getOCL();xAtomicNumber=e.Molecule.getAtomicNoFromLabel("X")}return xAtomicNumber}function addDiastereotopicMissingChirality(t,e={}){const{Molecule:i}=t.getOCL(),{esrType:r=i.cESRTypeAnd}=e;for(let e=0;e<t.getAllAtoms();e++){let o=t.getCompactCopy();tagAtom(o,e),o.ensureHelperArrays(i.cHelperBitsStereo);for(let e=0;e<o.getAtoms();e++)if(o.isAtomStereoCenter(e)&&-1===o.getStereoBond(e)){let n=o.getAtomPreferredStereoBond(e);if(-1!==n){if(t.setBondType(n,i.cBondTypeUp),t.getBondAtom(1,n)===e){let i=t.getBondAtom(0,n);t.setBondAtom(0,n,e),t.setBondAtom(1,n,i)}t.setAtomESR(e,r,0)}}}}function makeRacemic(t){const{Molecule:e}=t.getOCL();t.ensureHelperArrays(e.cHelperCIP);for(let i=0;i<t.getAllAtoms();i++)t.getAtomParity(i)!==e.cAtomParityNone&&t.setAtomESR(i,e.cESRTypeAnd,0)}function getDiastereotopicAtomIDs(t){const e=t.getOCL();addDiastereotopicMissingChirality(t);let i=t.getAllAtoms(),r=[];for(let o=0;o<i;o++){let i=t.getCompactCopy();tagAtom(i,o),makeRacemic(i),r[o]=i.getCanonizedIDCode(e.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS)}return r}function getGroupedDiastereotopicAtomIDs(t,e={}){const{atomLabel:i}=e;let r=getDiastereotopicAtomIDs(t),o={};for(let e=0;e<r.length;e++)if(!i||t.getAtomLabel(e)===i){let i=r[e];o[i]||(o[i]={counter:0,atoms:[],oclID:i,atomLabel:t.getAtomLabel(e)}),o[i].counter++,o[i].atoms.push(e)}return Object.keys(o).map((t=>o[t]))}function isCsp3(t,e){return 6===t.getAtomicNo(e)&&(0===t.getAtomCharge(e)&&t.getImplicitHydrogens(e)+t.getConnAtoms(e)===4)}const FULL_HOSE_CODE=1,HOSE_CODE_CUT_C_SP3_SP3=2;function getHoseCodesForAtom(t,e,i={}){const r=t.getOCL(),{minSphereSize:o=0,maxSphereSize:n=4,kind:s=FULL_HOSE_CODE,isTagged:l=!1}=i,a=t.getCompactCopy();if(!l){let t=tagAtom(a,e);a.addImplicitHydrogens(),a.addMissingChirality(),a.ensureHelperArrays(r.Molecule.cHelperNeighbours);for(let i=0;i<a.getAllAtoms();i++)if(t===a.getAtomCustomLabel(i)){e=i;break}}let u=new r.Molecule(0,0),h=[],c=0,f=0,p=new Array(a.getAllAtoms()),m=new Array(a.getAllAtoms());for(let t=0;t<=n;t++){if(0===f)m[0]=e,p[e]=!0,f=1;else{let t=f;for(let e=c;e<f;e++){let i=m[e];for(let e=0;e<a.getAllConnAtoms(i);e++){let r=a.getConnAtom(i,e);if(!p[r])switch(s){case FULL_HOSE_CODE:p[r]=!0,m[t++]=r;break;case HOSE_CODE_CUT_C_SP3_SP3:isCsp3(a,i)&&isCsp3(a,r)||(p[r]=!0,m[t++]=r);break;default:throw new Error("getHoseCoesForAtom unknown kind")}}}c=f,f=t}a.copyMoleculeByAtoms(u,p,!0,null),t>=o&&(makeRacemic(u),h.push(u.getCanonizedIDCode(r.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS)))}return h}function getHoseCodesFromDiastereotopicID(t,e={}){t.addImplicitHydrogens(),t.addMissingChirality();let i=-1;for(let e=0;e<t.getAllAtoms();e++){const r=t.getAtomCustomLabel(e);if(null!=r&&r.endsWith("*")){i=e;break}}if(i>=0)return e.isTagged=!0,getHoseCodesForAtom(t,i,e)}function floydWarshall(t){if(Matrix.isMatrix(t)&&t.columns!==t.rows)throw new TypeError("The adjacency matrix should be squared");const e=t.columns;let i=new Matrix(e,e);i.apply(((e,r)=>{if(e===r)i.set(e,r,0);else{let o=t.get(e,r);o?i.set(e,r,o):i.set(e,r,Number.POSITIVE_INFINITY)}}));for(let t=0;t<e;++t)for(let r=0;r<e;++r)for(let o=0;o<e;++o){let e=i.get(r,t)+i.get(t,o);i.get(r,o)>e&&i.set(r,o,e)}return i.apply(((t,e)=>{i.get(t,e)===Number.POSITIVE_INFINITY&&i.set(t,e,-1)})),i}function getConnectivityMatrix(t,e={}){const i=t.getOCL();t.ensureHelperArrays(i.Molecule.cHelperNeighbours);let r=t.getAllAtoms(),o=new Array(r).fill();if(o=o.map((()=>new Array(r).fill(0))),!e.pathLength)if(e.atomicNo)for(let e=0;e<r;e++)o[e][e]=t.getAtomicNo(e);else if(e.negativeAtomicNo)for(let e=0;e<r;e++)o[e][e]=-t.getAtomicNo(e);else if(e.mass)for(let e=0;e<r;e++)o[e][e]=i.Molecule.cRoundedMass[t.getAtomicNo(e)];else for(let t=0;t<r;t++)o[t][t]=1;if(e.sdt)for(let e=0;e<r;e++){let i=t.getAllConnAtoms(e);for(let r=0;r<i;r++)o[e][t.getConnAtom(e,r)]=t.getConnBondOrder(e,r)}else if(e.sdta)for(let e=0;e<r;e++){let i=t.getAllConnAtoms(e);for(let r=0;r<i;r++){let i=t.getConnBond(e,r);t.isAromaticBond(i)?o[e][t.getConnAtom(e,r)]=4:o[e][t.getConnAtom(e,r)]=t.getConnBondOrder(e,r)}}else for(let e=0;e<r;e++){let i=t.getAllConnAtoms(e);for(let r=0;r<i;r++)o[e][t.getConnAtom(e,r)]=1}return e.pathLength&&(o=floydWarshall(new Matrix(o)).to2DArray()),o}function signalsJoin(t,e={}){const{tolerance:i=.1}=e;for(let e of t){if(!e.diaID||1===!e.diaID.length)return t;for(let i of e.j)if(!i.diaID||1===!i.diaID.length||"d"!==i.multiplicity)return t}const r={};for(let e of t){e=signalNormalize(e),e.j=e.j.sort(((t,e)=>t.diaID+t.distance<e.diaID+e.distance?1:-1));let t=`${e.diaID[0]} ${e.j.map((t=>`${t.diaID[0]} ${t.distance}`)).sort().join(" ")}`;r[t]||(r[t]=[]),r[t].push(e)}let o=[];for(let t in r){const e=r[t],i=[];for(let t=0;t<e[0].j.length;t++)i.push({diaID:e[0].j[t].diaID,distance:e[0].j[t].distance,multiplicity:e[0].j[t].multiplicity,coupling:mean(e.map((e=>e.j[t].coupling)))});o.push({nbAtoms:sum(e.map((t=>t.nbAtoms))),delta:mean(e.map((t=>t.delta))),diaID:e[0].diaID,assignment:e.map((t=>t.assignment)).flat().filter((t=>t)),j:i})}return o=o.map((t=>((t=signalNormalize(signalJoinCouplings(t,{tolerance:i}))).j&&(t.multiplicity=t.j.reduce(((t,e)=>`${t}${e.multiplicity}`),"")),t))).sort(((t,e)=>t.delta-e.delta)),o}async function predictProton(t,e={}){const{cache:i}=e;(t=t.getCompactCopy()).addImplicitHydrogens(),addDiastereotopicMissingChirality(t);const r=t.toMolfile();let o;if(i&&(o=i(r)),void 0===o){const t=new browser;t.append("molfile",r);const e=await fetch("https://www.nmrdb.org/service/predictor",{method:"POST",body:t});o=await e.text(),i&&i(r,o)}const n=getDiastereotopicAtomIDs(t),s=protonParser(o,t,n),l=signalsJoin(s);return{molfile:r,diaIDs:n,joinedSignals:l,signals:s,ranges:signalsToRanges(l)}}function protonParser(t,e,i){let r=getConnectivityMatrix(e,{pathLength:!0}),o=t.split("\n").filter((t=>t)),n=[];for(let t of o){let e=t.split("\t"),o=e.slice(4),s=e[0]-1,l={assignment:[s],diaID:[i[s]],nbAtoms:1,delta:Number(e[2]),j:[]};for(let t=0;t<o.length;t+=3){let e=Number(o[t]-1);l.j.push({coupling:Number(o[t+2]),assignment:[e],diaID:[i[e]],multiplicity:"d",distance:r[s][e]}),l.j.sort(((t,e)=>e.coupling-t.coupling))}n.push(l)}return n}function createInputJSON(t,e){const{levels:i}=e,r=t.getOCL();let o=getGroupedDiastereotopicAtomIDs(t);o=o.filter((t=>"C"===t.atomLabel)).sort((function(t,e){return t.atomLabel===e.atomLabel?e.counter-t.counter:t.atomLabel<e.atomLabel?1:-1}));const n={};for(const t of o){t.hose=getHoseCodesFromDiastereotopicID(r.Molecule.fromIDCode(t.oclID),{maxSphereSize:i[0]});for(const e of t.atoms)n[e]=t.oclID}return{id:t.getIDCode(),atom:n,diaIDs:o}}function queryByHose(t,e,i){const{levels:r}=i;r.sort(((t,e)=>e-t));const o=[];for(const i of t.diaIDs){let t,n=0;for(;!t&&n<r.length;)e[r[n]]&&(t=e[r[n]][i.hose[r[n]]]),n++;t||(t=[null],n=0);for(const e of i.atoms){let r={diaIDs:[i.oclID]};r.delta=t[0],r.atomIDs=[e],r.nbAtoms=1,o.push(r)}}return o}const cache={};async function loadDB(t="https://www.lactame.com/lib/nmr-processing/data/20210711/carbon.js"){if(cache[t])return cache[t];const e=await fetch(t);return cache[t]=await e.json(),cache[t]}async function predictCarbon(t,e={}){let{levels:i=[3,2,1,0],url:r,database:o}=e;o=o||await loadDB(r),t.addImplicitHydrogens(),t.addMissingChirality(),addDiastereotopicMissingChirality(t);const n=t.toMolfile(),s=createInputJSON(t,{levels:i});const l=formatSignals(queryByHose(s,o,{levels:i})),a=joinSignalByDiaID(l);return{molfile:n,diaIDs:s.diaIDs.map((t=>t.diaId)),joinedSignals:a,signals:l,ranges:signalsToRanges(a)}}function formatSignals(t){let e=[];for(const i of t){const{atomIDs:t,nbAtoms:r,delta:o,diaIDs:n}=i;e.push({delta:o,assignment:t,diaID:n,nbAtoms:r,j:[]})}return e}function joinSignalByDiaID(t){let e={};for(let i of t){let t=i.diaID[0];e[t]?(e[t].nbAtoms+=i.nbAtoms,e[t].assignment.push(...i.assignment)):e[t]=JSON.parse(JSON.stringify(i))}return Object.values(e)}var src={},fftlib={};!function(t){(function(){var e,i="0.3.0",r="2013-03";(e=t).toString=function(){return"version "+i+", released "+r};for(var o=0,n=null,s=null,l={init:function(t){if(0===t||0!=(t&t-1))throw new Error("init: radix-2 required");o=t,l._initArray(),l._makeBitReversalTable(),l._makeCosSinTable()},fft1d:function(t,e){l.fft(t,e,1)},ifft1d:function(t,e){var i=1/o;l.fft(t,e,-1);for(var r=0;r<o;r++)t[r]*=i,e[r]*=i},bt1d:function(t,e){l.fft(t,e,-1)},fft2d:function(t,e){for(var i=[],r=[],n=0,s=0;s<o;s++){n=s*o;for(var a=0;a<o;a++)i[a]=t[a+n],r[a]=e[a+n];l.fft1d(i,r);for(var u=0;u<o;u++)t[u+n]=i[u],e[u+n]=r[u]}for(var h=0;h<o;h++){for(var c=0;c<o;c++)n=h+c*o,i[c]=t[n],r[c]=e[n];l.fft1d(i,r);for(var f=0;f<o;f++)t[n=h+f*o]=i[f],e[n]=r[f]}},ifft2d:function(t,e){for(var i=[],r=[],n=0,s=0;s<o;s++){n=s*o;for(var a=0;a<o;a++)i[a]=t[a+n],r[a]=e[a+n];l.ifft1d(i,r);for(var u=0;u<o;u++)t[u+n]=i[u],e[u+n]=r[u]}for(var h=0;h<o;h++){for(var c=0;c<o;c++)n=h+c*o,i[c]=t[n],r[c]=e[n];l.ifft1d(i,r);for(var f=0;f<o;f++)t[n=h+f*o]=i[f],e[n]=r[f]}},fft:function(t,e,i){for(var r,l,a,u,h,c,f,p,m,g=o>>2,y=0;y<o;y++)y<(u=n[y])&&(h=t[y],t[y]=t[u],t[u]=h,h=e[y],e[y]=e[u],e[u]=h);for(var d=1;d<o;d<<=1){l=0,r=o/(d<<1);for(var w=0;w<d;w++){c=s[l+g],f=i*s[l];for(var x=w;x<o;x+=d<<1)p=c*t[a=x+d]+f*e[a],m=c*e[a]-f*t[a],t[a]=t[x]-p,t[x]+=p,e[a]=e[x]-m,e[x]+=m;l+=r}}},_initArray:function(){n="undefined"!=typeof Uint32Array?new Uint32Array(o):[],s="undefined"!=typeof Float64Array?new Float64Array(1.25*o):[]},_paddingZero:function(){},_makeBitReversalTable:function(){var t=0,e=0,i=0;for(n[0]=0;++t<o;){for(i=o>>1;i<=e;)e-=i,i>>=1;e+=i,n[t]=e}},_makeCosSinTable:function(){var t=o>>1,e=o>>2,i=o>>3,r=t+e,n=Math.sin(Math.PI/o),l=2*n*n,a=Math.sqrt(l*(2-l)),u=s[e]=1,h=s[0]=0;n=2*l;for(var c=1;c<i;c++)l+=n*(u-=l),a-=n*(h+=a),s[c]=h,s[e-c]=u;0!==i&&(s[i]=Math.sqrt(.5));for(var f=0;f<e;f++)s[t-f]=s[f];for(var p=0;p<r;p++)s[p+t]=-s[p]}},a=["init","fft1d","ifft1d","fft2d","ifft2d"],u=0;u<a.length;u++)e[a[u]]=l[a[u]];return e.bt=l.bt1d,e.fft=l.fft1d,e.ifft=l.ifft1d,e}).call(commonjsGlobal)}(fftlib);var FFT=fftlib,FFTUtils$1={DEBUG:!1,ifft2DArray:function(t,e,i){var r=new Array(e*i),o=e/2,n=2*(i-1);FFT.init(o);for(var s={re:new Array(o),im:new Array(o)},l=0;l<i;l++){for(var a=o-1;a>=0;a--)s.re[a]=t[2*a*i+l],s.im[a]=t[(2*a+1)*i+l];FFT.bt(s.re,s.im);for(a=o-1;a>=0;a--)r[2*a*i+l]=s.re[a],r[(2*a+1)*i+l]=s.im[a]}var u=new Array(o*n);FFT.init(n);var h={re:new Array(n),im:new Array(n)},c=n*o;for(a=0;a<e;a+=2){h.re[0]=r[a*i],h.im[0]=r[(a+1)*i];for(l=1;l<i;l++)h.re[l]=r[a*i+l],h.im[l]=r[(a+1)*i+l],h.re[n-l]=r[a*i+l],h.im[n-l]=-r[(a+1)*i+l];FFT.bt(h.re,h.im);var f=a/2*n;for(l=n-1;l>=0;l--)u[f+l]=h.re[l]/c}return u},fft2DArray:function(t,e,i,r){Object.assign({},{inplace:!0});var o=i/2+1,n=2*e,s=new Array(n*o);FFT.init(i);for(var l,a,u,h,c,f={re:new Array(i),im:new Array(i)},p={re:new Array(i),im:new Array(i)},m={re:new Array(i),im:new Array(i)},g=0;g<e/2;g++){l=2*g*i,f.re=t.slice(l,l+i),l=(2*g+1)*i,f.im=t.slice(l,l+i),FFT.fft1d(f.re,f.im),this.reconstructTwoRealFFT(f,p,m),a=4*g*o,u=(4*g+1)*o,h=(4*g+2)*o,c=(4*g+3)*o;for(var y=o-1;y>=0;y--)s[a+y]=p.re[y],s[u+y]=p.im[y],s[h+y]=m.re[y],s[c+y]=m.im[y]}p=null,m=null;var d=new Array(n*o);FFT.init(e);for(var w={re:new Array(e),im:new Array(e)},x=o-1;x>=0;x--){for(g=e-1;g>=0;g--)w.re[g]=s[2*g*o+x],w.im[g]=s[(2*g+1)*o+x],isNaN(w.re[g])&&(w.re[g]=0),isNaN(w.im[g])&&(w.im[g]=0);FFT.fft1d(w.re,w.im);for(g=e-1;g>=0;g--)d[2*g*o+x]=w.re[g],d[(2*g+1)*o+x]=w.im[g]}return d},reconstructTwoRealFFT:function(t,e,i){var r,o,n,s,l,a=t.re.length;e.re[0]=t.re[0],e.im[0]=0,i.re[0]=t.im[0],i.im[0]=0;for(var u=a/2;u>0;u--)l=a-u,r=.5*(t.re[u]-t.re[l]),o=.5*(t.re[u]+t.re[l]),n=.5*(t.im[u]-t.im[l]),s=.5*(t.im[u]+t.im[l]),e.re[u]=o,e.im[u]=n,e.re[l]=o,e.im[l]=-n,i.re[u]=s,i.im[u]=-r,i.re[l]=s,i.im[l]=r},convolute2DI:function(t,e,i,r){for(var o,n,s=0;s<i/2;s++)for(var l=0;l<r;l++)o=t[2*s*r+l]*e[2*s*r+l]-t[(2*s+1)*r+l]*e[(2*s+1)*r+l],n=t[2*s*r+l]*e[(2*s+1)*r+l]+t[(2*s+1)*r+l]*e[2*s*r+l],t[2*s*r+l]=o,t[(2*s+1)*r+l]=n},convolute:function(t,e,i,r,o){for(var n=new Array(r*i),s=0;s<i*r;s++)n[s]=t[s];n=this.fft2DArray(n,i,r);var l,a=e.length,u=e[0].length,h=new Array(r*i);for(s=0;s<r*i;s++)h[s]=0;for(var c=Math.floor((a-1)/2),f=Math.floor((u-1)/2),p=0;p<a;p++){l=(p-c+i)%i;for(var m=0;m<u;m++)h[l*r+(m-f+r)%r]=e[p][m]}h=this.fft2DArray(h,i,r);var g=2*i,y=r/2+1;return this.convolute2DI(n,h,g,y),this.ifft2DArray(n,g,y)},toRadix2:function(t,e,i){var r,o,n,s,l=i,a=e;if(0===i||0!=(i&i-1)){for(l=0;i>>++l!=0;);l=1<<l}if(0===e||0!=(e&e-1)){for(a=0;e>>++a!=0;);a=1<<a}if(a==e&&l==i)return{data:t,rows:e,cols:i};var u=new Array(a*l),h=Math.floor((a-e)/2)-e,c=Math.floor((l-i)/2)-i;for(r=0;r<a;r++)for(n=r*l,s=(r-h)%e*i,o=0;o<l;o++)u[n+o]=t[s+(o-c)%i];return{data:u,rows:a,cols:l}},crop:function(t,e,i,r,o,n){if(e==r&&i==o)return t;Object.assign({},n);var s,l,a,u,h=new Array(o*r),c=Math.floor((e-r)/2),f=Math.floor((i-o)/2);for(a=0;a<r;a++)for(s=a*o,l=(a+c)*i,u=0;u<o;u++)h[s+u]=t[l+(u+f)];return h}},FFTUtils_1=FFTUtils$1,FFTUtils=src.FFTUtils=FFTUtils_1;function matrix2Array(t){let e,i,r=t;if("number"!=typeof t[0]){e=t.length,i=t[0].length,r=new Array(e*i);for(let o=0;o<e;o++)for(let e=0;e<i;e++)r[o*i+e]=t[o][e]}else{let r=Math.sqrt(t.length);Number.isInteger(r)&&(e=r,i=r)}return{data:r,rows:e,cols:i}}function convolutionFFT(t,e,i){let r,o,n=matrix2Array(t),s=n.data,l=Object.assign({normalize:!1,divisor:1,rows:n.rows,cols:n.cols},i);if(!l.rows||!l.cols)throw new Error(`Invalid number of rows or columns ${r} ${o}`);r=l.rows,o=l.cols;let a=l.divisor,u=e.length,h=e[0].length;if(l.normalize){a=0;for(let t=0;t<u;t++)for(let i=0;i<h;i++)a+=e[t][i]}if(0===a)throw new RangeError("convolution: The divisor is equal to zero");let c=FFTUtils.toRadix2(s,r,o),f=FFTUtils.convolute(c.data,e,c.rows,c.cols);if(f=FFTUtils.crop(f,c.rows,c.cols,r,o),0!==a&&1!==a)for(let t=0;t<f.length;t++)f[t]/=a;return f}function convolutionDirect(t,e,i){let r,o,n=matrix2Array(t),s=n.data,l=Object.assign({normalize:!1,divisor:1,rows:n.rows,cols:n.cols},i);if(!l.rows||!l.cols)throw new Error(`Invalid number of rows or columns ${r} ${o}`);r=l.rows,o=l.cols;let a,u,h,c,f,p=l.divisor,m=e.length,g=e[0].length;if(l.normalize){p=0;for(let t=0;t<m;t++)for(let i=0;i<g;i++)p+=e[t][i]}if(0===p)throw new RangeError("convolution: The divisor is equal to zero");let y=new Array(r*o),d=Math.floor(m/2),w=Math.floor(g/2);for(let t=0;t<r;t++)for(let i=0;i<o;i++){u=0;for(let n=0;n<m;n++)for(let l=0;l<g;l++)h=e[m-n-1][g-l-1],c=(t+n-d+r)%r,f=(i+l-w+o)%o,a=c*o+f,u+=s[a]*h;a=t*o+i,y[a]=u/p}return y}src.FFT=fftlib;class DisjointSet{constructor(){this.nodes=new Map}add(t){var e=this.nodes.get(t);return e||(e=new DisjointSetNode(t),this.nodes.set(t,e)),e}union(t,e){const i=this.find(t),r=this.find(e);i!==r&&(i.rank<r.rank?i.parent=r:i.rank>r.rank?r.parent=i:(r.parent=i,i.rank++))}find(t){for(var e=t;null!==e.parent;)e=e.parent;for(var i=t;null!==i.parent;){var r=i;i=i.parent,r.parent=e}return e}connected(t,e){return this.find(t)===this.find(e)}}var DisjointSet_1=DisjointSet;function DisjointSetNode(t){this.value=t,this.parent=null,this.rank=0}const direction8X$2=[-1,-1,0,1,-1,0,1,1],direction8Y$2=[0,-1,-1,-1,1,1,1,0],neighbours8$1=[null,null,null,null,null,null,null,null],direction4X$1=[-1,0,1,0],direction4Y$1=[0,-1,0,1],neighbours4$1=[null,null,null,null];function drainLabelling(t,e,i={}){const{neighbours:r=8,width:o,height:n}=i;let s,l,a;if(8===r)s=direction8X$2,l=direction8Y$2,a=neighbours8$1;else{if(4!==r)throw new RangeError(`unsupported neighbours count: ${r}`);s=direction4X$1,l=direction4Y$1,a=neighbours4$1}let u=new Array(n*o);for(let i=0,r=0;i<n;i++)for(let n=0;n<o;n++,r++)u[r]={value:t[r],row:i,col:n,mask:e[r]};u.sort(((t,e)=>t.value-e.value));const h=e.length,c=new Array(h),f=new Int16Array(h),p=new DisjointSet_1;for(let i=0,r=1;i<e.length;i++){let e=u[i];if(!e.mask)continue;let{row:h,col:f,value:m}=e,g=f+h*o;c[g]||(c[g]=p.add(r++));for(let e=0;e<a.length;e++){let i=f+s[e],r=h+l[e];if(i>=0&&r>=0&&i<o&&r<n){if(!c[i+r*o]){m<t[i+r*o]&&(c[i+r*o]=c[g])}}}}for(let t=0;t<n;t++)for(let i=0;i<o;i++){let r=i+t*o;e[r]&&(f[r]=p.find(c[r]).value)}return f}const direction4X=[-1,0],direction4Y=[0,-1],neighbours4=[null,null],direction8X$1=[-1,-1,0,1],direction8Y$1=[0,-1,-1,-1],neighbours8=[null,null,null,null];function floodFillLabelling(t,e,i,r){const o=(r=r||{}).neighbours||8;let n,s,l;if(8===o)n=direction8X$1,s=direction8Y$1,l=neighbours8;else{if(4!==o)throw new RangeError(`unsupported neighbours count: ${o}`);n=direction4X,s=direction4Y,l=neighbours4}const a=t.length,u=new Array(a),h=new Int16Array(a),c=new DisjointSet_1;let f,p=1;for(let r=0;r<i;r++)for(let o=0;o<e;o++){let a=null;if(f=o+r*e,t[f]){for(let t=0;t<l.length;t++){let h=o+n[t],c=r+s[t];if(h>=0&&c>=0&&h<e&&c<i){let i=u[h+c*e];i?(l[t]=i,(!a||l[t].value<a.value)&&(a=l[t])):l[t]=null}}if(a){u[f]=a;for(let t=0;t<l.length;t++)l[t]&&l[t]!==a&&c.union(a,l[t])}else u[f]=c.add(p++)}}for(let r=0;r<i;r++)for(let i=0;i<e;i++)f=i+r*e,t[f]&&(h[f]=c.find(u[f]).value);return h}const smallFilter$1=[[0,0,1,2,2,2,1,0,0],[0,1,4,7,7,7,4,1,0],[1,4,5,3,0,3,5,4,1],[2,7,3,-12,-23,-12,3,7,2],[2,7,0,-23,-40,-23,0,7,2],[2,7,3,-12,-23,-12,3,7,2],[1,4,5,3,0,3,5,4,1],[0,1,3,7,7,7,3,1,0],[0,0,1,2,2,2,1,0,0]];function findPeaks2DRegion(t,e={}){let{nStdDev:i=3,kernel:r=smallFilter$1,originalData:o=matrix2Array(t).data,filteredData:n,rows:s,cols:l,labelling:a="drain"}=e,u=matrix2Array(t),h=u.data;if(s&&l||(s=u.rows,l=u.cols),!s||!l)throw new Error(`Invalid number of rows or columns ${s} ${l}`);let c=n;c||(c=convolutionFFT(h,r,e));let f=0;for(let t=l*s-2;t>=0;t--)f+=Math.pow(c[t]-c[t+1],2);f=-Math.sqrt(f)*i/s;let p,m=new Uint16Array(l*s);for(let t=c.length-1;t>=0;t--)c[t]<f&&(m[t]=1);switch(a.toLowerCase()){case"drain":p=drainLabelling(c,m,{neighbours:8,width:l,height:s});break;case"floodfill":p=floodFillLabelling(m,l,s,{neighbours:8});break;default:throw new Error(`labelling ${a} does not support`)}return extractPeaks(p,{data:h,nCols:l,originalData:o})}function extractPeaks(t,e){const{data:i,nCols:r,originalData:o}=e;let n,s,l,a={};for(let e=0;e<t.length;e++)0!==t[e]&&(s=e%r,n=(e-s)/r,a[t[e]]?(l=a[t[e]],l.x+=s*i[e],l.y+=n*i[e],l.z+=o[e],s<l.minX&&(l.minX=s),s>l.maxX&&(l.maxX=s),n<l.minY&&(l.minY=n),n>l.maxY&&(l.maxY=n)):a[t[e]]={x:s*i[e],y:n*i[e],z:o[e],minX:s,maxX:s,minY:n,maxY:n});let u=Object.keys(a),h=new Array(u.length);for(let t=0;t<u.length;t++){h[t]=a[u[t]];let e=Math.abs(h[t].z);h[t].x/=e,h[t].y/=e}return h}const direction8X=[-1,-1,-1,0,0,1,1,1],direction8Y=[-1,0,1,-1,1,-1,0,1],direction16X=[-2,-2,-2,-2,-2,-1,-1,0,0,1,1,2,2,2,2,2],direction16Y=[-2,-1,0,1,2,-2,2,-2,2,-2,2,-2,-1,0,1,2];function determineRealTop(t,e){let{nCols:i,absoluteData:r,originalData:o,minX:n,maxX:s,minY:l,maxY:a}=e;for(let e=0;e<t.length;e++){let u=Math.round(t[e].x),h=Math.round(t[e].y),c=u+h*i,{index:f,isMax:p}=determineMax(r,{xIndex:u,yIndex:h,nCols:i,shell:1});c=p?f:determineMax(r,{xIndex:u,yIndex:h,nCols:i,shell:2}).index;let m=fitGaussian(o,{nCols:i,index:c,minY:l,maxY:a,minX:n,maxX:s});t[e]=Object.assign(t[e],m)}return t}function determineMax(t,e){let{xIndex:i,yIndex:r,shell:o,nCols:n}=e,s=i+r*n,[l,a]=o>1?[direction16X,direction16Y]:[direction8X,direction8Y],u=!1;for(let e=0;e<l.length;e++){let o=i+l[e],h=r+a[e];if(t[o+h*n]>=t[s]){u=!0;let e=o+h*n;for(let i=0;i<direction8Y.length;i++){if(t[o+direction8X[i]+(h+direction8Y[i])*n]>t[e]){u=!1;break}}u&&(s=e)}}return{index:s,isMax:u}}function fitGaussian(t,e){let{nCols:i,index:r,minY:o,maxY:n,minX:s,maxX:l}=e,a=(l-s)/(i-1),u=(n-o)/(t.length/i-1),h=r%i,c=(r-h)/i,f=Number.MIN_SAFE_INTEGER,p=new Array(direction8X.length+1),m=new Array(direction8X.length+1);for(let e=-1,r=0;e<2;e++)for(let o=-1;o<2;o++,m[r]=r++){let r=t[h+o+(c+e)*i];f<r&&(f=r),p[1+o+3*(1+e)]=r}for(let t=0;t<p.length;t++)p[t]/=f;let g=[2,2,1.5,1,1],y=[0,0,-1.5,.001,.001],d=[1,1,p[4],.2,.2],w=levenbergMarquardt({x:m,y:p},paramGaussian2D(a,u,3),{damping:1.5,maxIterations:100,errorTolerance:1e-8,initialValues:d,gradientDifference:[1e-4,1e-4,.001,.001,.001],maxValues:g,minValues:y}).parameterValues;return{x:w[0]+h-1,y:w[1]+c-1,z:w[2]*f}}function paramGaussian2D(t,e,i){return function(r){return function(o){let n=r.length/5,s=0,l=o%i,a=(o-l)/i;for(let i=0;i<n;i++)s+=r[i+2*n]*Gaussian2D.fct((l-r[i])*t,(a-r[i+n])*e,r[i+3*n],r[i+4*n]);return s}}}function getKernel(t={}){let{sigma:e=1.4,xLength:i=9,yLength:r=9}=t,o=-40/laplacianOfGaussian(0,0,e);const n=(i-1)/2,s=(r-1)/2;let l=new Array(i);for(let t=0;t<i;t++){l[t]=new Array(r);for(let i=0;i<r;i++)l[t][i]=laplacianOfGaussian(t-n,i-s,e)*o}return l}const laplacianOfGaussian=(t,e,i)=>{let r=-(Math.pow(t,2)+Math.pow(e,2))/2/Math.pow(i,2);return-1/Math.PI/Math.pow(i,4)*(1+r)*Math.exp(r)};let diagonalError=.05,tolerance=.05;function clean(t,e){let i=Number.NEGATIVE_INFINITY;for(let e=t.length-1;e>=0;e--)Math.abs(t[e].z)>i&&(i=Math.abs(t[e].z));i*=e;for(let e=t.length-1;e>=0;e--)Math.abs(t[e].z)<i&&t.splice(e,1);return t}function enhanceSymmetry(t){let e,i=initializeProperties(t),r=t.slice();for(let t=r.length-1;t>=0;t--){let e=r[t];if(e.peaks.length>1&&i[t][1]++,1===i[t][0]){let o=exist(r,i,e,-1,!0);o>=0&&(i[t][1]+=2,i[o][1]+=2)}}for(let t=r.length-1;t>=0;t--){let o=r[t];0===i[t][0]&&(e=checkCrossPeaks(r,i,o,!0),i[t][1]+=e)}let o=0;for(let t=r.length-1;t>=0;t--)0!==i[t][0]&&i[t][1]>2&&(o++,o+=completeMissingIfNeeded(r,i,r[t],i[t])),i[t][1]>=2&&0===i[t][0]&&o++;let n=new Array(o);o--;for(let t=r.length-1;t>=0;t--)(0!==i[t][0]&&i[t][1]>2||0===i[t][0]&&i[t][1]>1)&&(n[o--]=r[t]);return n}function completeMissingIfNeeded(t,e,i,r){let o,n,s=0,l=null,a=null;exist(t,e,i,-r[0],!0)<0&&(l={nucleusX:i.nucleusX,nucleusY:i.nucleusY},l.resolutionX=i.resolutionX,l.resolutionY=i.resolutionY,l.shiftX=i.shiftY,l.shiftY=i.shiftX,l.peaks=[{x:i.shiftY,y:i.shiftX,z:1}],t.push(l),a=[-r[0],r[1]],e.push(a),s++);let u=!1,h=!1;for(o=t.length-1;o>=0;o--)n=t[o],0===e[o][0]&&(Math.abs(n.shiftX-i.shiftX)<diagonalError&&(u=!0),Math.abs(n.shiftY-i.shiftY)<diagonalError&&(h=!0));return!1===u&&(l={nucleusX:i.nucleusX,nucleusY:i.nucleusY},l.resolutionX=i.resolutionX,l.resolutionY=i.resolutionY,l.shiftX=i.shiftX,l.shiftY=i.shiftX,l.peaks=[{x:i.shiftX,y:i.shiftX,z:1}],t.push(l),a=[0,r[1]],e.push(a),s++),!1===h&&(l={nucleusX:i.nucleusX,nucleusY:i.nucleusY},l.resolutionX=i.resolutionX,l.resolutionY=i.resolutionY,l.shiftX=i.shiftY,l.shiftY=i.shiftY,l.peaks=[{x:i.shiftY,y:i.shiftY,z:1}],t.push(l),a=[0,r[1]],e.push(a),s++),s}function checkCrossPeaks(t,e,i,r){let o,n=0,s=4*i.shiftX,l=[],a=[];for(let u=t.length-1;u>=0;u--)o=t[u],0!==e[u][0]&&(Math.abs(o.shiftX-i.shiftX)<diagonalError?(n++,r&&e[u][1]++,l.push(u),s+=o.shiftX):Math.abs(o.shiftY-i.shiftY)<diagonalError&&(n++,r&&e[u][1]++,a.push(u),s+=o.shiftY));if(s/=l.length+a.length+4,l.length>0)for(let e=l.length-1;e>=0;e--)t[l[e]].shiftX=s;if(a.length>0)for(let e=a.length-1;e>=0;e--)t[a[e]].shiftY=s;return i.shiftX=s,i.shiftY=s,n}function exist(t,e,i,r,o){for(let n=t.length-1;n>=0;n--)if(e[n][0]===r&&distanceTo(i,t[n],o)<tolerance){if(o){let e=i.shiftX,r=t[n].shiftX;t[n].shiftY=e,i.shiftY=r}else{let e=(t[n].shiftX+i.shiftX)/2,r=(t[n].shiftY+i.shiftY)/2;t[n].shiftX=e,t[n].shiftY=r,i.shiftX=e,i.shiftY=r}return n}return-1}function initializeProperties(t){let e=new Array(t.length);for(let i=t.length-1;i>=0;i--)if(e[i]=[0,0],Math.abs(t[i].shiftX-t[i].shiftY)<=diagonalError){e[i][1]=1;let r=(2*t[i].shiftX+t[i].shiftY)/3;t[i].shiftX=r,t[i].shiftY=r}else t[i].shiftX-t[i].shiftY>0?e[i][0]=1:e[i][0]=-1;return e}function distanceTo(t,e,i){return i?Math.sqrt(Math.pow(t.shiftX-e.shiftY,2)+Math.pow(t.shiftY-e.shiftX,2)):Math.sqrt(Math.pow(t.shiftX-e.shiftX,2)+Math.pow(t.shiftY-e.shiftY,2))}const smallFilter=[[0,0,1,2,2,2,1,0,0],[0,1,4,7,7,7,4,1,0],[1,4,5,3,0,3,5,4,1],[2,7,3,-12,-23,-12,3,7,2],[2,7,0,-23,-40,-23,0,7,2],[2,7,3,-12,-23,-12,3,7,2],[1,4,5,3,0,3,5,4,1],[0,1,3,7,7,7,3,1,0],[0,0,1,2,2,2,1,0,0]];function xyzAutoPeaksPicking(t,e={}){let{sizeToPad:i=14,realTopDetection:r=!0,thresholdFactor:o=.5,nucleus:n=["1H","1H"],observeFrequencies:s,enhanceSymmetry:l=!1,clean:a=!0,maxPercentCutOff:u=.03,tolerances:h=[24,24],convolutionByFFT:c=!0,kernel:f}=e;o=0===o?1:Math.abs(o);let p=t.z[0].length,m=t.z.length;m<i&&(p=(t=padData(t,{width:i})).z[0].length,m=t.z.length);let g=new Float64Array(p*m),y=new Float64Array(p*m);for(let e=0;e<m;e++){let i=t.z[e];for(let t=0;t<p;t++){let r=e*p+t;g[r]=Math.abs(i[t]),y[r]=i[t]}}let d=f?getKernel(f):smallFilter,w=findPeaks2DRegion(g,{originalData:y,filteredData:c?convolutionFFT(g,d,{rows:m,cols:p}):convolutionDirect(g,d,{rows:m,cols:p}),rows:m,cols:p,nStdDev:o});a&&(w=clean(w,u));let x=createSignals2D$1(w,{nRows:m,nCols:p,minX:t.minX,maxX:t.maxX,minY:t.minY,maxY:t.maxY,absoluteData:g,originalData:y,tolerances:h,nucleus:n,observeFrequencies:s,realTopDetection:r});return l&&(x=enhanceSymmetry(x)),x}const createSignals2D$1=(t,e)=>{let{nCols:i,nRows:r,absoluteData:o,originalData:n,observeFrequencies:s,tolerances:l,nucleus:a,realTopDetection:u,minY:h,maxY:c,minX:f,maxX:p}=e,[m,g]=a,[y,d]=l,[w,x]=s,b=(c-h)/(r-1),M=(p-f)/(i-1);u&&(t=determineRealTop(t,{nCols:i,absoluteData:o,originalData:n,minX:f,maxX:p,minY:h,maxY:c}));for(let e=t.length-1;e>=0;e--){let{x:i,y:r}=t[e];t[e].x=f+M*i,t[e].y=h+b*r,t[e].minX=f+M*t[e].minX,t[e].minY=h+b*t[e].minY,t[e].maxX=f+M*t[e].maxX,t[e].maxY=h+b*t[e].maxY,(t[e].y<-1||t[e].y>=210)&&t.splice(e,1)}let C=[];for(let e=0;e<t.length;e++)for(let i=e;i<t.length;i++)Math.abs(t[e].x-t[i].x)*w<y&&Math.abs(t[e].y-t[i].y)*x<d?C.push(1):C.push(0);let v=src$1(C),A=[];if(v)for(let e=0;e<v.length;e++){let i={nucleusX:m,nucleusY:g};i.resolutionX=M,i.resolutionY=b;let r=[];i.shiftX=0,i.shiftY=0;let o=[Number.MAX_VALUE,0],n=[Number.MAX_VALUE,0],s=0;for(let l=0;l<v[e].length;l++)1===v[e][l]&&(r.push(t[l]),i.shiftX+=t[l].x*t[l].z,i.shiftY+=t[l].y*t[l].z,s+=t[l].z,t[l].minX<o[0]&&(o[0]=t[l].minX),t[l].maxX>o[1]&&(o[1]=t[l].maxX),t[l].minY<n[0]&&(n[0]=t[l].minY),t[l].maxY>n[1]&&(n[1]=t[l].maxY));i.fromTo=[{from:o[0],to:o[1]},{from:n[0],to:n[1]}],i.shiftX/=s,i.shiftY/=s,i.peaks=r,A.push(i)}return A},padData=(t,e={})=>{let{minX:i,maxX:r,minY:o,maxY:n}=t,{width:s}=e,l=t.z[0].length,a=t.z.length,u=(n-o)/(a-1),h=(r-i)/(l-1),c=s-a,f=Math.max(s-l,0);f%2&&f++,c%2&&c++;let p=f/2,m=c/2,g=Matrix.zeros(a+c,l+f);for(let e=0;e<a;e++)for(let i=0;i<l;i++)g.set(e+m,i+p,t.z[e][i]);return{z:g.to2DArray(),minX:i-p*h,maxX:r+p*h,minY:o-m*u,maxY:n+m*u}},gyromagneticRatio={"1H":267522187.44,"2H":41065e3,"3H":285350800,"3He":-203789e3,"7Li":103962e3,"13C":67282840,"14N":19331e3,"15N":-27116e3,"17O":-36264e3,"19F":251662e3,"23Na":70761e3,"27Al":69763e3,"29Si":-5319e4,"31P":108291e3,"57Fe":8681e3,"63Cu":71118e3,"67Zn":16767e3,"129Xe":-73997e3},defaultOptions={reference:0,referenceMaxShiftError:.08,tolerances:[10,100],nucleus:["1H","1H"],observeFrequencies:[400,400],jAnalyzer:{jAxisKey:{jAxis:"y",intensity:"z"}}};function xyzJResAnalyzer(t,e={}){let i=assignDeep({},defaultOptions,e),{reference:r,referenceMaxShiftError:o}=i,n=compilePattern(t,i),s=[];for(let t=0;t<n.length;t++){let e=n[t].shiftY;Math.abs(e-r)>o||s.push(n[t])}return s}function compilePattern(t,e={}){let{observeFrequencies:i,tolerances:r,nucleus:o,jAnalyzer:n}=e,s={observeFrequencies:i,tolerances:r,nucleus:o,dx:t[0].resolutionX,dy:t[0].resolutionY};for(let e=0;e<t.length;e++){let r=t[e],o=r.peaks;r.nbPeaks=r.peaks.length,r.multiplicity="",r.pattern="",r.delta1=r.shiftY,r.observe=i[1],r.integralData={from:Number.MAX_SAFE_INTEGER,to:Number.MIN_SAFE_INTEGER};for(let t=0;t<o.length;t++)o[t].width||(o[t].width=.02);o.sort(((t,e)=>t.y-e.y))}for(let e=0;e<t.length;e++)if(jAnalyzer.compilePattern(t[e],n),t[e].maskPattern&&"m"!==t[e].multiplicity&&""!==t[e].multiplicity){let i=[];for(let r=t[e].maskPattern.length-1;r>=0;r--)if(!1===t[e].maskPattern[r]){let o=t[e].peaks.splice(r,1)[0];i.push(o),t[e].mask.splice(r,1),t[e].mask2.splice(r,1),t[e].maskPattern.splice(r,1),t[e].nbPeaks--}if(i.length>0){i.reverse();let e=createSignals2D(i,s);for(let i=0;i<e.length;i++)t.push(e[i])}}return t.sort(((t,e)=>e.shiftX-t.shiftX)),t}function createSignals2D(t,e){let{observeFrequencies:i,tolerances:r,nucleus:o,dx:n,dy:s}=e,[l,a]=o,[u,h]=r,[c,f]=i,p=[];for(let e=0;e<t.length;e++)for(let i=e;i<t.length;i++)Math.abs(t[e].x-t[i].x)*c<u&&Math.abs(t[e].y-t[i].y)*f<h?p.push(1):p.push(0);let m=src$1(p),g=[];if(m)for(let e=0;e<m.length;e++){let i={nucleusX:l,nucleusY:a,integralData:{from:Number.MAX_SAFE_INTEGER,to:Number.MIN_SAFE_INTEGER},nbPeaks:0,multiplicity:"",pattern:""};i.observe=f,i.resolutionX=n,i.resolutionY=s;let r=[];i.shiftX=0,i.shiftY=0;let o=[Number.MAX_VALUE,0],u=[Number.MAX_VALUE,0],h=0;for(let n=m[e].length-1;n>=0;n--)1===m[e][n]&&(i.nbPeaks++,t[n].width||(t[n].width=.02),r.push(t[n]),i.shiftX+=t[n].x*t[n].z,i.shiftY+=t[n].y*t[n].z,h+=t[n].z,t[n].minX<o[0]&&(o[0]=t[n].minX),t[n].maxX>o[1]&&(o[1]=t[n].maxX),t[n].minY<u[0]&&(u[0]=t[n].minY),t[n].maxY>u[1]&&(u[1]=t[n].maxY));i.fromTo=[{from:o[0],to:o[1]},{from:u[0],to:u[1]}],i.shiftX/=h,i.shiftY/=h,i.delta1=i.shiftY,i.peaks=r,g.push(i)}return g}exports.couplingPatterns=couplingPatterns,exports.gyromagneticRatio=gyromagneticRatio,exports.impurities=impurities,exports.peaksFilterImpurities=peaksFilterImpurities,exports.predictCarbon=predictCarbon,exports.predictProton=predictProton,exports.rangesToACS=rangesToACS,exports.signalsToRanges=signalsToRanges,exports.signalsToXY=signalsToXY,exports.xyAutoPeaksPicking=xyAutoPeaksPicking,exports.xyAutoRangesPicking=xyAutoRangesPicking,exports.xyzAutoPeaksPicking=xyzAutoPeaksPicking,exports.xyzJResAnalyzer=xyzJResAnalyzer,Object.defineProperty(exports,"__esModule",{value:!0})}));
//# sourceMappingURL=nmr-processing.min.js.map
