/**
 * nmr-processing
 * @version v1.5.1
 * @link https://github.com/cheminfo/nmr-processing#readme
 * @license MIT
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.NMRProcessing = {}));
}(this, (function (exports) { 'use strict';

  /* eslint-disable camelcase */
  const impurities = {
    cdcl3: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: 'ds',
        shift: 7.26
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 'bs',
        shift: 1.56
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.1
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.17
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.1
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.36
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.28
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.19
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.22
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.98
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 5.01
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.27
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.43
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.26
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.43
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.73
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 5.3
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.21
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.48
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.65
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.57
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.39
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.4
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.55
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.09
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.02
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.94
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 8.02
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.96
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.88
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.62
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.71
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.25
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.72
      }, {
        proton: 'OH',
        coupling: 5,
        multiplicity: 's,t',
        shift: 1.32
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.05
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.12
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.26
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.14
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.46
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.06
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.76
      }],
      'grease^f': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 'm',
        shift: 0.86
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'br_s',
        shift: 1.26
      }],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.88
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.26
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.65
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.49
      }, {
        proton: 'OH',
        coupling: 0,
        multiplicity: 's',
        shift: 1.09
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.33
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 7
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.27
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.22
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 4.04
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.62
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.29
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.68
      }],
      silicone_greasei: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 0.07
      }],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.85
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.76
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.36
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.17
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.25
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.03
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.53
      }]
    },
    '(cd3)2co': {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 2.05
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 's',
        shift: 2.84
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.96
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.09
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.05
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.36
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.18
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.13
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.13
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.96
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.22
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.41
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 8.02
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.43
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.87
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 5.63
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.11
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.41
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.56
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.47
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.28
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.28
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.46
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.97
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.83
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.96
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.94
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.78
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.52
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.59
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.12
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.57
      }, {
        proton: 'OH',
        coupling: 5,
        multiplicity: 's,t',
        shift: 3.39
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.97
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.05
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.2
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.07
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.45
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.28
      }],
      'grease^f': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 'm',
        shift: 0.87
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'br_s',
        shift: 1.29
      }],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.88
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.28
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.59
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.31
      }, {
        proton: 'OH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.12
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.43
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.88
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.27
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.1
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 3.9
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.58
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.35
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.76
      }],
      silicone_greasei: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 0.13
      }],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.79
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.63
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.32
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.5
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.5
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.45
      }]
    },
    dmso: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: 'quint',
        shift: 2.5
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 's',
        shift: 3.33
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.91
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.09
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.07
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.37
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.11
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 4.19
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.11
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.08
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.87
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 6.65
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.18
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.36
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 8.32
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.4
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.9
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 5.76
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.09
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.38
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.51
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.38
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.24
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.24
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.43
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.96
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.94
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.78
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.95
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.89
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.73
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.54
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.57
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.06
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.44
      }, {
        proton: 'OH',
        coupling: 5,
        multiplicity: 's,t',
        shift: 4.63
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.99
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.03
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.17
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.07
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.43
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.91
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.34
      }],
      'grease^f': [],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.86
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.25
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.53
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.16
      }, {
        proton: 'OH',
        coupling: 0,
        multiplicity: 's',
        shift: 4.01
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.42
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.88
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.27
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.04
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 3.78
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.58
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.39
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.79
      }],
      silicone_greasei: [],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.76
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.6
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.3
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.18
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.25
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.93
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.43
      }]
    },
    c6d6: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 7.16
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 's',
        shift: 0.4
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.55
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.55
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.55
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.15
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.05
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 1.55
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.07
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.04
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.05
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 4.79
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.24
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.38
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.15
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.4
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 2.9
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 4.27
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.11
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.26
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.46
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.34
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.11
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.12
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.33
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.6
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.57
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.05
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.63
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.36
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.86
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.68
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.35
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.34
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.65
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.89
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.92
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.58
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 1.81
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.85
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.41
      }],
      'grease^f': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 'm',
        shift: 0.92
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'br_s',
        shift: 1.36
      }],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.89
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.24
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.4
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.07
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.94
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.86
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.23
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 0.95
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 3.67
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.53
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 6.66
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 6.98
      }],
      silicone_greasei: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 0.29
      }],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.4
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.57
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.11
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.02
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.13
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.4
      }]
    },
    cd3cn: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 1.94
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 's',
        shift: 2.13
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.96
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.08
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.96
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.37
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.16
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 2.18
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.14
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.13
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.97
      }, {
        proton: 'OHc',
        coupling: 0,
        multiplicity: 's',
        shift: 5.2
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.22
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.39
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.58
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.44
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.81
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 5.44
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.12
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.42
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.53
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.45
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.29
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.28
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.45
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.97
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.96
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.83
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.92
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.89
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.77
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.5
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.6
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.12
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.54
      }, {
        proton: 'OH',
        coupling: 5,
        multiplicity: 's,t',
        shift: 2.47
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 1.97
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.06
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.2
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.06
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.43
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.51
      }],
      'grease^f': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 'm',
        shift: 0.86
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'br_s',
        shift: 1.27
      }],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.89
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.28
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.57
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.28
      }, {
        proton: 'OH',
        coupling: 0,
        multiplicity: 's',
        shift: 2.16
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.31
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.87
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.29
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.09
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 3.87
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.57
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.33
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.73
      }],
      silicone_greasei: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 0.08
      }],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.8
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.64
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.33
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.2
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.2
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.96
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.45
      }]
    },
    cd3od: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 3.31
      }],
      h2o: [{
        proton: 'H2O',
        coupling: 0,
        multiplicity: 's',
        shift: 4.87
      }],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.99
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.15
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.03
      }],
      benzene: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.33
      }],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.4
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.15
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.2
      }],
      bhtb: [{
        proton: 'ArH',
        coupling: 0,
        multiplicity: 's',
        shift: 6.92
      }, {
        proton: 'ArCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.21
      }, {
        proton: 'ArC(CH3)3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.4
      }],
      chloroform: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.9
      }],
      cyclohexane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 1.45
      }],
      '1,2-dichloroethane': [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.78
      }],
      dichloromethane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 5.49
      }],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.18
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.49
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.61
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.58
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.35
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.35
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.52
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.07
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.31
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.92
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.97
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.99
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.86
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.65
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.66
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.19
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.6
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.01
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.09
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.24
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.12
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.5
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.01
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.59
      }],
      'grease^f': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 'm',
        shift: 0.88
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'br_s',
        shift: 1.29
      }],
      'n-hexane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 't',
        shift: 0.9
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.29
      }],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.64
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.34
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.34
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.89
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.29
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.5
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 3.92
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.53
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.44
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.85
      }],
      silicone_greasei: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 0.1
      }],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.87
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.71
      }],
      toluene: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.32
      }, {
        proton: 'CH(o/p)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.16
      }, {
        proton: 'CH(m)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.16
      }],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.05
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.58
      }]
    },
    d2o: {
      tms: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 0
      }],
      solvent: [{
        proton: 'X',
        coupling: 0,
        multiplicity: '',
        shift: 4.79
      }],
      h2o: [],
      acetic_acid: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.08
      }],
      acetone: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.22
      }],
      acetonitrile: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.06
      }],
      benzene: [],
      'tert-butyl_alcohol': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.24
      }],
      'tert-butyl_methyl_ether': [{
        proton: 'CCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 1.21
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.22
      }],
      bhtb: [],
      chloroform: [],
      cyclohexane: [],
      '1,2-dichloroethane': [],
      dichloromethane: [],
      diethyl_ether: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.17
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.56
      }],
      diglyme: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.67
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.61
      }, {
        proton: 'OCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.37
      }],
      '1,2-dimethoxyethane': [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.37
      }, {
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.6
      }],
      dimethylacetamide: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.08
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.06
      }, {
        proton: 'NCH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.9
      }],
      dimethylformamide: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 7.92
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.01
      }, {
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.85
      }],
      dimethyl_sulfoxide: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 2.71
      }],
      dioxane: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 's',
        shift: 3.75
      }],
      ethanol: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.17
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.65
      }],
      ethyl_acetate: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.07
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 4.14
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.24
      }],
      ethyl_methyl_ketone: [{
        proton: 'CH3CO',
        coupling: 0,
        multiplicity: 's',
        shift: 2.19
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 'q',
        shift: 3.18
      }, {
        proton: 'CH2CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 1.26
      }],
      ethylene_glycol: [{
        proton: 'CH',
        coupling: 0,
        multiplicity: 's',
        shift: 3.65
      }],
      'grease^f': [],
      'n-hexane': [],
      hmpag: [{
        proton: 'CH3',
        coupling: 9.5,
        multiplicity: 'd',
        shift: 2.61
      }],
      methanol: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 3.34
      }],
      nitromethane: [{
        proton: 'CH3',
        coupling: 0,
        multiplicity: 's',
        shift: 4.4
      }],
      'n-pentane': [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.9
      }],
      '2-propanol': [{
        proton: 'CH3',
        coupling: 6,
        multiplicity: 'd',
        shift: 1.17
      }, {
        proton: 'CH',
        coupling: 6,
        multiplicity: 'sep',
        shift: 4.02
      }],
      pyridine: [{
        proton: 'CH(2)',
        coupling: 0,
        multiplicity: 'm',
        shift: 8.52
      }, {
        proton: 'CH(3)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.45
      }, {
        proton: 'CH(4)',
        coupling: 0,
        multiplicity: 'm',
        shift: 7.87
      }],
      silicone_greasei: [],
      tetrahydrofuran: [{
        proton: 'CH2',
        coupling: 0,
        multiplicity: 'm',
        shift: 1.88
      }, {
        proton: 'CH2O',
        coupling: 0,
        multiplicity: 'm',
        shift: 3.74
      }],
      toluene: [],
      triethylamine: [{
        proton: 'CH3',
        coupling: 7,
        multiplicity: 't',
        shift: 0.99
      }, {
        proton: 'CH2',
        coupling: 7,
        multiplicity: 'q',
        shift: 2.57
      }]
    }
  };

  const toCheck = ['solvent', 'H2O', 'TMS'];
  /**
   * Try to remove peaks of impurities.
   * @param {array} peakList - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
   * @param {object} [options={}] - options
   * @param {string} [options.solvent=''] - solvent name.
   * @param {string} [options.error=0.025] - tolerance in ppm to assign a impurity.
   */

  function peaksFilterImpurities(peakList, options = {}) {
    let {
      solvent = '',
      error = 0.025,
      remove = false
    } = options;
    solvent = solvent.toLowerCase();
    if (solvent === '(cd3)2so') solvent = 'dmso';
    if (solvent === 'meod') solvent = 'cd3od';
    let solventImpurities = impurities[solvent];

    if (solventImpurities) {
      for (let impurity of toCheck) {
        let name = impurity.toLowerCase();
        let impurityShifts = solventImpurities[name];
        checkImpurity(peakList, impurityShifts, {
          error,
          remove,
          name
        });
      }
    }

    return peakList;
  }

  function checkImpurity(peakList, impurity, options) {
    let {
      name,
      error,
      remove
    } = options;
    let j, tolerance, difference;
    let i = impurity.length;

    while (i--) {
      j = peakList.length;

      while (j--) {
        if (!peakList[j].asymmetric) {
          tolerance = error + peakList[j].width;
          difference = Math.abs(impurity[i].shift - peakList[j].x);

          if (difference < tolerance) {
            // && (impurity[i].multiplicity === '' || (impurity[i].multiplicity.indexOf(peakList[j].multiplicity)) { // some impurities has multiplicities like 'bs' but at presents it is unsupported
            if (remove) {
              peakList.splice(j, 1);
            } else {
              peakList[j].kind = name;
            }
          }
        }
      }
    }
  }

  const GAUSSIAN_EXP_FACTOR = -4 * Math.LN2;
  const ROOT_PI_OVER_LN2 = Math.sqrt(Math.PI / Math.LN2);
  const ROOT_THREE = Math.sqrt(3);
  const ROOT_2LN2 = Math.sqrt(2 * Math.LN2);
  const ROOT_2LN2_MINUS_ONE = Math.sqrt(2 * Math.LN2) - 1;

  // https://en.wikipedia.org/wiki/Error_function#Inverse_functions
  // This code yields to a good approximation
  // If needed a better implementation using polynomial can be found on https://en.wikipedia.org/wiki/Error_function#Inverse_functions
  function erfinv(x) {
    let a = 0.147;
    if (x === 0) return 0;
    let ln1MinusXSqrd = Math.log(1 - x * x);
    let lnEtcBy2Plus2 = ln1MinusXSqrd / 2 + 2 / (Math.PI * a);
    let firstSqrt = Math.sqrt(lnEtcBy2Plus2 ** 2 - ln1MinusXSqrd / a);
    let secondSqrt = Math.sqrt(firstSqrt - lnEtcBy2Plus2);
    return secondSqrt * (x > 0 ? 1 : -1);
  }

  class Gaussian {
    /**
     * @param {object} [options = {}]
     * @param {number} [options.height=4*LN2/(PI*FWHM)] Define the height of the peak, by default area=1 (normalized)
     * @param {number} [options.fwhm = 500] - Full Width at Half Maximum in the number of points in FWHM.
     * @param {number} [options.sd] - Standard deviation, if it's defined options.fwhm will be ignored and the value will be computed sd * Math.sqrt(8 * Math.LN2);
     */
    constructor(options = {}) {
      this.fwhm = options.sd ? Gaussian.widthToFWHM(2 * options.sd) : options.fwhm ? options.fwhm : 500;
      this.height = options.height === undefined ? Math.sqrt(-GAUSSIAN_EXP_FACTOR / Math.PI) / this.fwhm : options.height;
    }
    /**
     * Calculate a gaussian shape
     * @param {object} [options = {}]
     * @param {number} [options.factor = 6] - Number of time to take fwhm to calculate length. Default covers 99.99 % of area.
     * @param {number} [options.length = fwhm * factor + 1] - total number of points to calculate
     * @return {Float64Array} y values
     */


    getData(options = {}) {
      let {
        length,
        factor = this.getFactor()
      } = options;

      if (!length) {
        length = Math.min(Math.ceil(this.fwhm * factor), Math.pow(2, 25) - 1);
        if (length % 2 === 0) length++;
      }

      const center = (length - 1) / 2;
      const data = new Float64Array(length);

      for (let i = 0; i <= center; i++) {
        data[i] = this.fct(i - center) * this.height;
        data[length - 1 - i] = data[i];
      }

      return data;
    }
    /**
     * Return a parameterized function of a gaussian shape (see README for equation).
     * @param {number} x - x value to calculate.
     * @returns {number} - the y value of gaussian with the current parameters.
     */


    fct(x) {
      return Gaussian.fct(x, this.fwhm);
    }
    /**
     * Calculate the number of times FWHM allows to reach a specific area coverage
     * @param {number} [area=0.9999]
     * @returns {number}
     */


    getFactor(area = 0.9999) {
      return Gaussian.getFactor(area);
    }
    /**
     * Calculate the area of the shape.
     * @returns {number} - returns the area.
     */


    getArea() {
      return Gaussian.getArea(this.fwhm, {
        height: this.height
      });
    }
    /**
     * Compute the value of Full Width at Half Maximum (FWHM) from the width between the inflection points.
     * //https://mathworld.wolfram.com/GaussianFunction.html
     * @param {number} width - Width between the inflection points
     * @returns {number} fwhm
     */


    widthToFWHM(width) {
      //https://mathworld.wolfram.com/GaussianFunction.html
      return Gaussian.widthToFWHM(width);
    }
    /**
     * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
     * //https://mathworld.wolfram.com/GaussianFunction.html
     * @param {number} fwhm - Full Width at Half Maximum.
     * @returns {number} width
     */


    fwhmToWidth(fwhm = this.fwhm) {
      return Gaussian.fwhmToWidth(fwhm);
    }
    /**
     * set a new full width at half maximum
     * @param {number} fwhm - full width at half maximum
     */


    setFWHM(fwhm) {
      this.fwhm = fwhm;
    }
    /**
     * set a new height
     * @param {number} height - The maximal intensity of the shape.
     */


    setHeight(height) {
      this.height = height;
    }

  }
  /**
   * Return a parameterized function of a gaussian shape (see README for equation).
   * @param {number} x - x value to calculate.
   * @param {number} fwhm - full width half maximum
   * @returns {number} - the y value of gaussian with the current parameters.
   */

  Gaussian.fct = function fct(x, fwhm = 500) {
    return Math.exp(GAUSSIAN_EXP_FACTOR * Math.pow(x / fwhm, 2));
  };
  /**
   * Compute the value of Full Width at Half Maximum (FWHM) from the width between the inflection points.
   * //https://mathworld.wolfram.com/GaussianFunction.html
   * @param {number} width - Width between the inflection points
   * @returns {number} fwhm
   */


  Gaussian.widthToFWHM = function widthToFWHM(width) {
    return width * ROOT_2LN2;
  };
  /**
   * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
   * //https://mathworld.wolfram.com/GaussianFunction.html
   * @param {number} fwhm - Full Width at Half Maximum.
   * @returns {number} width
   */


  Gaussian.fwhmToWidth = function fwhmToWidth(fwhm) {
    return fwhm / ROOT_2LN2;
  };
  /**
   * Calculate the area of a specific shape.
   * @param {number} fwhm - Full width at half maximum.
   * @param {object} [options = {}] - options.
   * @param {number} [options.height = 1] - Maximum y value of the shape.
   * @returns {number} - returns the area of the specific shape and parameters.
   */


  Gaussian.getArea = function getArea(fwhm, options = {}) {
    let {
      height = 1
    } = options;
    return height * ROOT_PI_OVER_LN2 * fwhm / 2;
  };
  /**
   * Calculate the number of times FWHM allows to reach a specific area coverage.
   * @param {number} [area=0.9999]
   * @returns {number}
   */


  Gaussian.getFactor = function getFactor(area = 0.9999) {
    return Math.sqrt(2) * erfinv(area);
  };

  class Lorentzian {
    /**
     * @param {object} [options = {}]
     * @param {number} [options.height=2/(PI*FWHM)] Define the height of the peak, by default area=1 (normalized)
     * @param {number} [options.fwhm = 500] - Full Width at Half Maximum in the number of points in FWHM.
     * @param {number} [options.sd] - Standard deviation, if it's defined options.fwhm will be ignored and the value will be computed sd * Math.sqrt(8 * Math.LN2);
     */
    constructor(options = {}) {
      this.fwhm = options.fwhm === undefined ? 500 : options.fwhm;
      this.height = options.height === undefined ? 2 / Math.PI / this.fwhm : options.height;
    }
    /**
     * Calculate a lorentzian shape
     * @param {object} [options = {}]
     * @param {number} [options.factor = Math.tan(Math.PI * (0.9999 - 0.5))] - Number of time to take fwhm to calculate length. Default covers 99.99 % of area.
     * @param {number} [options.length = fwhm * factor + 1] - total number of points to calculate
     * @return {Float64Array} y values
     */


    getData(options = {}) {
      let {
        length,
        factor = this.getFactor()
      } = options;

      if (!length) {
        length = Math.min(Math.ceil(this.fwhm * factor), Math.pow(2, 25) - 1);
        if (length % 2 === 0) length++;
      }

      const center = (length - 1) / 2;
      const data = new Float64Array(length);

      for (let i = 0; i <= center; i++) {
        data[i] = this.fct(i - center) * this.height;
        data[length - 1 - i] = data[i];
      }

      return data;
    }
    /**
     * Return a parameterized function of a lorentzian shape (see README for equation).
     * @param {number} x - x value to calculate.
     * @returns {number} - the y value of lorentzian with the current parameters.
     */


    fct(x) {
      return Lorentzian.fct(x, this.fwhm);
    }
    /**
     * Calculate the number of times FWHM allows to reach a specific area coverage
     * @param {number} [area=0.9999]
     * @returns {number}
     */


    getFactor(area = 0.9999) {
      return Lorentzian.getFactor(area);
    }
    /**
     * Calculate the area of the shape.
     * @returns {number} - returns the area.
     */


    getArea() {
      return Lorentzian.getArea(this.fwhm, {
        height: this.height
      });
    }
    /**
     * Compute the value of width between the inflection points of a specific shape from Full Width at Half Maximum (FWHM).
     * //https://mathworld.wolfram.com/LorentzianFunction.html
     * @param {number} [fwhm] - Full Width at Half Maximum.
     * @returns {number} width between the inflection points
     */


    fwhmToWidth(fwhm = this.fwhm) {
      return Lorentzian.fwhmToWidth(fwhm);
    }
    /**
     * Compute the value of Full Width at Half Maximum (FWHM) of a specific shape from the width between the inflection points.
     * //https://mathworld.wolfram.com/LorentzianFunction.html
     * @param {number} [width] Width between the inflection points
     * @returns {number} fwhm
     */


    widthToFWHM(width) {
      return Lorentzian.widthToFWHM(width);
    }
    /**
     * set a new full width at half maximum
     * @param {number} fwhm - full width at half maximum
     */


    setFWHM(fwhm) {
      this.fwhm = fwhm;
    }
    /**
     * set a new height
     * @param {number} height - The maximal intensity of the shape.
     */


    setHeight(height) {
      this.height = height;
    }

  }
  /**
   * Return a parameterized function of a gaussian shape (see README for equation).
   * @param {number} x - x value to calculate.
   * @param {number} fwhm - full width half maximum
   * @returns {number} - the y value of gaussian with the current parameters.
   */

  Lorentzian.fct = function fct(x, fwhm) {
    const squareFWHM = fwhm * fwhm;
    return squareFWHM / (4 * Math.pow(x, 2) + squareFWHM);
  };
  /**
   * Compute the value of width between the inflection points of a specific shape from Full Width at Half Maximum (FWHM).
   * //https://mathworld.wolfram.com/LorentzianFunction.html
   * @param {number} [fwhm] - Full Width at Half Maximum.
   * @returns {number} width between the inflection points
   */


  Lorentzian.fwhmToWidth = function fwhmToWidth(fwhm) {
    return fwhm / ROOT_THREE;
  };
  /**
   * Compute the value of Full Width at Half Maximum (FWHM) of a specific shape from the width between the inflection points.
   * //https://mathworld.wolfram.com/LorentzianFunction.html
   * @param {number} [width] Width between the inflection points
   * @returns {number} fwhm
   */


  Lorentzian.widthToFWHM = function widthToFWHM(width) {
    return width * ROOT_THREE;
  };
  /**
   * Calculate the area of a specific shape.
   * @param {number} fwhm - Full width at half maximum.
   * @param {*} [options = {}] - options.
   * @param {number} [options.height = 1] - Maximum y value of the shape.
   * @returns {number} - returns the area of the specific shape and parameters.
   */


  Lorentzian.getArea = function getArea(fwhm, options = {}) {
    let {
      height = 1
    } = options;
    return height * Math.PI * fwhm / 2;
  };
  /**
   * Calculate the number of times FWHM allows to reach a specific area coverage
   * @param {number} [area=0.9999]
   * @returns {number}
   */


  Lorentzian.getFactor = function getFactor(area = 0.9999) {
    return 2 * Math.tan(Math.PI * (area - 0.5));
  };

  class PseudoVoigt {
    /**
     * @param {object} [options={}]
     * @param {number} [options.height=1/(mu*FWHM/sqrt(4*LN2/PI)+(1-mu)*fwhm*PI*0.5)] Define the height of the peak, by default area=1 (normalized)
     * @param {number} [options.fwhm=500] - Full Width at Half Maximum in the number of points in FWHM.
     * @param {number} [options.mu=0.5] - ratio of gaussian contribution.
     */
    constructor(options = {}) {
      this.mu = options.mu === undefined ? 0.5 : options.mu;
      this.fwhm = options.fwhm === undefined ? 500 : options.fwhm;
      this.height = options.height === undefined ? 1 / (this.mu / Math.sqrt(-GAUSSIAN_EXP_FACTOR / Math.PI) * this.fwhm + (1 - this.mu) * this.fwhm * Math.PI / 2) : options.height;
    }
    /**
     * Calculate a linear combination of gaussian and lorentzian function width an same full width at half maximum
     * @param { object } [options = {}]
     * @param { number } [options.factor = 2 * Math.tan(Math.PI * (0.9999 - 0.5))] - Number of time to take fwhm in the calculation of the length.Default covers 99.99 % of area.
     * @param { number } [options.length = fwhm * factor + 1] - total number of points to calculate
     * @return { object } - { fwhm, data<Float64Array>} - An with the number of points at half maximum and the array of y values covering the 99.99 % of the area.
     */


    getData(options = {}) {
      let {
        length,
        factor = this.getFactor()
      } = options;

      if (!length) {
        length = Math.ceil(this.fwhm * factor);
        if (length % 2 === 0) length++;
      }

      const center = (length - 1) / 2;
      let data = new Float64Array(length);

      for (let i = 0; i <= center; i++) {
        data[i] = this.fct(i - center) * this.height;
        data[length - 1 - i] = data[i];
      }

      return data;
    }
    /**
     * Return a parameterized function of a linear combination of Gaussian and Lorentzian shapes where the full width at half maximum are the same for both kind of shapes (see README for equation).
     * @param {number} [x] x value to calculate.
     * @returns {number} - the y value of a pseudo voigt with the current parameters.
     */


    fct(x) {
      return PseudoVoigt.fct(x, this.fwhm, this.mu);
    }
    /**
     * Calculate the number of times FWHM allows to reach a specific area coverage
     * @param {number} [area=0.9999] - required area to be coverage
     * @param {number} [mu=this.mu] - ratio of gaussian contribution.
     * @returns {number}
     */


    getFactor(area = 0.9999, mu = this.mu) {
      return PseudoVoigt.getFactor(area, mu);
    }
    /**
     * Calculate the area of the shape.
     * @returns {number} - returns the area.
     */


    getArea() {
      return PseudoVoigt.getArea(this.fwhm, {
        height: this.height,
        mu: this.mu
      });
    }
    /**
     * Compute the value of Full Width at Half Maximum (FMHM) from width between the inflection points.
     * @param {number} width - width between the inflection points
     * @param {number} [mu = 0.5] - ratio of gaussian contribution.
     * @returns {number} Full Width at Half Maximum (FMHM).
     */


    widthToFWHM(width, mu) {
      return PseudoVoigt.widthToFWHM(width, mu);
    }
    /**
     * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
     * @param {number} fwhm - Full Width at Half Maximum.
     * @param {number} [mu] - ratio of gaussian contribution.
     * @returns {number} width between the inflection points.
     */


    fwhmToWidth(fwhm = this.fwhm, mu = this.mu) {
      return PseudoVoigt.fwhmToWidth(fwhm, mu);
    }
    /**
     * set a new full width at half maximum
     * @param {number} fwhm - full width at half maximum
     */


    setFWHM(fwhm) {
      this.fwhm = fwhm;
    }
    /**
     * set a new height
     * @param {number} height - The maximal intensity of the shape.
     */


    setHeight(height) {
      this.height = height;
    }
    /**
     * set a new mu
     * @param {number} mu - ratio of gaussian contribution.
     */


    setMu(mu) {
      this.mu = mu;
    }

  }
  /**
   * Return a parameterized function of a gaussian shape (see README for equation).
   * @param {number} x - x value to calculate.
   * @param {number} fwhm - full width half maximum
   * @param {number} [mu=0.5] - ratio of gaussian contribution.
   * @returns {number} - the y value of gaussian with the current parameters.
   */

  PseudoVoigt.fct = function fct(x, fwhm, mu = 0.5) {
    return (1 - mu) * Lorentzian.fct(x, fwhm) + mu * Gaussian.fct(x, fwhm);
  };
  /**
   * Compute the value of Full Width at Half Maximum (FMHM) from width between the inflection points.
   * @param {number} width - width between the inflection points
   * @param {number} [mu = 0.5] - ratio of gaussian contribution.
   * @returns {number} Full Width at Half Maximum (FMHM).
   */


  PseudoVoigt.widthToFWHM = function widthToFWHM(width, mu = 0.5) {
    return width * (mu * ROOT_2LN2_MINUS_ONE + 1);
  };
  /**
   * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
   * @param {number} fwhm - Full Width at Half Maximum.
   * @param {number} [mu = 0.5] - ratio of gaussian contribution.
   * @returns {number} width between the inflection points.
   */


  PseudoVoigt.fwhmToWidth = function fwhmToWidth(fwhm, mu = 0.5) {
    return fwhm / (mu * ROOT_2LN2_MINUS_ONE + 1);
  };
  /**
   * Calculate the area of a specific shape.
   * @param {number} fwhm - Full width at half maximum.
   * @param {*} [options = {}] - options.
   * @param {number} [options.height = 1] - Maximum y value of the shape.
   * @param {number} [options.mu = 0.5] - ratio of gaussian contribution.
   * @returns {number} - returns the area of the specific shape and parameters.
   */


  PseudoVoigt.getArea = function getArea(fwhm, options = {}) {
    let {
      height = 1,
      mu = 0.5
    } = options;
    return fwhm * height * (mu * ROOT_PI_OVER_LN2 + (1 - mu) * Math.PI) / 2;
  };
  /**
   * Calculate the number of times FWHM allows to reach a specific area coverage
   * @param {number} [area=0.9999] - required area to be coverage
   * @param {number} [mu=this.mu] - ratio of gaussian contribution.
   * @returns {number}
   */


  PseudoVoigt.getFactor = function getFactor(area = 0.9999, mu = 0.5) {
    return mu < 1 ? Lorentzian.getFactor(area) : Gaussian.getFactor(area);
  };

  let axis = ['x', 'y'];
  class Gaussian2D {
    /**
     * @param {object} [options = {}]
     * @param {number} [options.height=4*LN2/(PI*xFWHM*yFWHM)] Define the height of the peak, by default area=1 (normalized).
     * @param {number} [options.fwhm = 500] - Full Width at Half Maximum in the number of points in FWHM used if x or y has not the fwhm property.
     * @param {object} [options.x] - Options for x axis.
     * @param {number} [options.x.fwhm = fwhm] - Full Width at Half Maximum in the number of points in FWHM for x axis.
     * @param {number} [options.x.sd] - Standard deviation for x axis, if it's defined options.x.fwhm will be ignored and the value will be computed sd * Math.sqrt(8 * Math.LN2);
     * @param {object} [options.y] - Options for y axis.
     * @param {number} [options.y.fwhm = fwhm] - Full Width at Half Maximum in the number of points in FWHM for y axis.
     * @param {number} [options.y.sd] - Standard deviation for y axis, if it's defined options.y.fwhm will be ignored and the value will be computed sd * Math.sqrt(8 * Math.LN2);
     */
    constructor(options = {}) {
      let {
        fwhm: globalFWHM = 500
      } = options;

      for (let i of axis) {
        let fwhm;

        if (!options[i]) {
          fwhm = globalFWHM;
        } else {
          fwhm = options[i].sd ? Gaussian2D.widthToFWHM(2 * options[i].sd) : options[i].fwhm || globalFWHM;
        }

        this[i] = {
          fwhm
        };
      }

      this.height = options.height === undefined ? -GAUSSIAN_EXP_FACTOR / Math.PI / this.x.fwhm / this.y.fwhm : options.height;
    }
    /**
     * Calculate a Gaussian2D shape
     * @param {object} [options = {}]
     * @param {number} [options.factor] - Number of time to take fwhm to calculate length. Default covers 99.99 % of area.
     * @param {object} [options.x] - parameter for x axis.
     * @param {number} [options.x.length=fwhm*factor+1] - length on x axis.
     * @param {number} [options.x.factor=factor] - Number of time to take fwhm to calculate length. Default covers 99.99 % of area.
     * @param {object} [options.y] - parameter for y axis.
     * @param {number} [options.y.length=fwhm*factor+1] - length on y axis.
     * @param {number} [options.y.factor=factor] - Number of time to take fwhm to calculate length. Default covers 99.99 % of area.
     * @return {Array<Float64Array>} - z values.
     */


    getData(options = {}) {
      let {
        x = {},
        y = {},
        factor = this.getFactor(),
        length
      } = options;
      let xLength = x.length || length;

      if (!xLength) {
        let {
          factor: xFactor = factor
        } = x;
        xLength = Math.min(Math.ceil(this.x.fwhm * xFactor), Math.pow(2, 25) - 1);
        if (xLength % 2 === 0) xLength++;
      }

      let yLength = y.length || length;

      if (!yLength) {
        let {
          factor: yFactor = factor
        } = y;
        yLength = Math.min(Math.ceil(this.y.fwhm * yFactor), Math.pow(2, 25) - 1);
        if (yLength % 2 === 0) yLength++;
      }

      const xCenter = (xLength - 1) / 2;
      const yCenter = (yLength - 1) / 2;
      const data = new Array(xLength);

      for (let i = 0; i < xLength; i++) {
        data[i] = new Array(yLength);
      }

      for (let i = 0; i < xLength; i++) {
        for (let j = 0; j < yLength; j++) {
          data[i][j] = this.fct(i - xCenter, j - yCenter) * this.height;
        }
      }

      return data;
    }
    /**
     * Return the intensity value of a 2D gaussian shape (see README for equation).
     * @param {number} x - x value to calculate.
     * @param {number} y - y value to calculate.
     * @returns {number} - the z value of bi-dimensional gaussian with the current parameters.
     */


    fct(x, y) {
      return Gaussian2D.fct(x, y, this.x.fwhm, this.y.fwhm);
    }
    /**
     * Calculate the number of times FWHM allows to reach a specific volume coverage.
     * @param {number} [volume=0.9999]
     * @returns {number}
     */


    getFactor(volume = 0.9999) {
      return Gaussian2D.getFactor(volume);
    }
    /**
     * Calculate the volume of the shape.
     * @returns {number} - returns the volume.
     */


    getVolume() {
      return Gaussian2D.getVolume(this.x.fwhm, this.y.fwhm, {
        height: this.height
      });
    }
    /**
     * Compute the value of Full Width at Half Maximum (FWHM) from the width between the inflection points.
     * //https://mathworld.wolfram.com/Gaussian2DFunction.html
     * @param {number} width - Width between the inflection points
     * @returns {number} fwhm
     */


    widthToFWHM(width) {
      //https://mathworld.wolfram.com/Gaussian2DFunction.html
      return Gaussian2D.widthToFWHM(width);
    }
    /**
     * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
     * //https://mathworld.wolfram.com/Gaussian2DFunction.html
     * @param {number} fwhm - Full Width at Half Maximum.
     * @returns {number} width
     */


    fwhmToWidth(fwhm = this.x.fwhm) {
      return Gaussian2D.fwhmToWidth(fwhm);
    }
    /**
     * set a new full width at half maximum
     * @param {number} fwhm - full width at half maximum
     * @param {string|Array<string>} axisLabel - label of axis, if it is undefined fwhm is set to both axis.
     */


    setFWHM(fwhm, axisLabel) {
      if (!axisLabel) axisLabel = axis;
      if (!Array.isArray(axisLabel)) axisLabel = [axisLabel];

      for (let i of axisLabel) {
        let axisName = i.toLowerCase();

        if (axisName !== 'y' && axisName !== 'x') {
          throw new Error('axis label should be x or y');
        }

        this[axisName].fwhm = fwhm;
      }
    }
    /**
     * set a new height
     * @param {number} height - The maximal intensity of the shape.
     */


    setHeight(height) {
      this.height = height;
    }

  }
  /**
   * Return a parameterized function of a Gaussian2D shape (see README for equation).
   * @param {number} x - x value to calculate.
   * @param {number} y - y value to calculate.
   * @param {number} fwhmX - full width half maximum in the x axis.
   * @param {number} fwhmY - full width half maximum in the y axis.
   * @returns {number} - the z value of bi-dimensional gaussian with the current parameters.
   */

  Gaussian2D.fct = function fct(x, y, xFWHM = 500, yFWHM = 500) {
    return Math.exp(GAUSSIAN_EXP_FACTOR * (Math.pow(x / xFWHM, 2) + Math.pow(y / yFWHM, 2)));
  };
  /**
   * Compute the value of Full Width at Half Maximum (FWHM) from the width between the inflection points.
   * //https://mathworld.wolfram.com/Gaussian2DFunction.html
   * @param {number} width - Width between the inflection points
   * @returns {number} fwhm
   */


  Gaussian2D.widthToFWHM = function widthToFWHM(width) {
    return width * ROOT_2LN2;
  };
  /**
   * Compute the value of width between the inflection points from Full Width at Half Maximum (FWHM).
   * //https://mathworld.wolfram.com/Gaussian2DFunction.html
   * @param {number} fwhm - Full Width at Half Maximum.
   * @returns {number} width
   */


  Gaussian2D.fwhmToWidth = function fwhmToWidth(fwhm) {
    return fwhm / ROOT_2LN2;
  };
  /**
   * Calculate the volume of a specific shape.
   * @param {number} xFWHM - Full width at half maximum for x axis.
   * @param {number} yFWHM - Full width at half maximum for y axis.
   * @param {object} [options = {}] - options.
   * @param {number} [options.height = 1] - Maximum z value of the shape.
   * @returns {number} - returns the area of the specific shape and parameters.
   */


  Gaussian2D.getVolume = function getVolume(xFWHM, yFWHM, options = {}) {
    let {
      height = 1
    } = options;
    return height * Math.PI * xFWHM * yFWHM / Math.LN2 / 4;
  };
  /**@TODO look for a better factor
   * Calculate the number of times FWHM allows to reach a specific volume coverage.
   * @param {number} [volume=0.9999]
   * @returns {number}
   */


  Gaussian2D.getFactor = function getFactor(volume = 0.9999) {
    return Math.sqrt(2) * erfinv(volume);
  };

  function getShapeGenerator(options) {
    let {
      kind = 'Gaussian',
      options: shapeOptions
    } = options;

    switch (kind.toLowerCase().replace(/[^a-z^0-9]/g, '')) {
      case 'gaussian':
        return new Gaussian(shapeOptions);

      case 'lorentzian':
        return new Lorentzian(shapeOptions);

      case 'pseudovoigt':
        return new PseudoVoigt(shapeOptions);

      case 'gaussian2d':
        return new Gaussian2D(shapeOptions);

      default:
        throw new Error(`Unknown kind: ${kind}`);
    }
  }

  /**
   * Apply Savitzky Golay algorithm
   * @param {array} [ys] Array of y values
   * @param {array|number} [xs] Array of X or deltaX
   * @param {object} [options={}]
   * @param {number} [options.windowSize=9]
   * @param {number} [options.derivative=0]
   * @param {number} [options.polynomial=3]
   * @return {array} Array containing the new ys (same length)
   */
  function SavitzkyGolay(ys, xs, options = {}) {
    let {
      windowSize = 9,
      derivative = 0,
      polynomial = 3
    } = options;

    if (windowSize % 2 === 0 || windowSize < 5 || !Number.isInteger(windowSize)) {
      throw new RangeError('Invalid window size (should be odd and at least 5 integer number)');
    }

    if (windowSize > ys.length) {
      throw new RangeError(`Window size is higher than the data length ${windowSize}>${ys.length}`);
    }

    if (derivative < 0 || !Number.isInteger(derivative)) {
      throw new RangeError('Derivative should be a positive integer');
    }

    if (polynomial < 1 || !Number.isInteger(polynomial)) {
      throw new RangeError('Polynomial should be a positive integer');
    }

    if (polynomial >= 6) {
      // eslint-disable-next-line no-console
      console.warn('You should not use polynomial grade higher than 5 if you are' + ' not sure that your data arises from such a model. Possible polynomial oscillation problems');
    }

    let half = Math.floor(windowSize / 2);
    let np = ys.length;
    let ans = new Array(np);
    let weights = fullWeights(windowSize, polynomial, derivative);
    let hs = 0;
    let constantH = true;

    if (Array.isArray(xs)) {
      constantH = false;
    } else {
      hs = Math.pow(xs, derivative);
    } //For the borders


    for (let i = 0; i < half; i++) {
      let wg1 = weights[half - i - 1];
      let wg2 = weights[half + i + 1];
      let d1 = 0;
      let d2 = 0;

      for (let l = 0; l < windowSize; l++) {
        d1 += wg1[l] * ys[l];
        d2 += wg2[l] * ys[np - windowSize + l];
      }

      if (constantH) {
        ans[half - i - 1] = d1 / hs;
        ans[np - half + i] = d2 / hs;
      } else {
        hs = getHs(xs, half - i - 1, half, derivative);
        ans[half - i - 1] = d1 / hs;
        hs = getHs(xs, np - half + i, half, derivative);
        ans[np - half + i] = d2 / hs;
      }
    } //For the internal points


    let wg = weights[half];

    for (let i = windowSize; i <= np; i++) {
      let d = 0;

      for (let l = 0; l < windowSize; l++) d += wg[l] * ys[l + i - windowSize];

      if (!constantH) hs = getHs(xs, i - half - 1, half, derivative);
      ans[i - half - 1] = d / hs;
    }

    return ans;
  }

  function getHs(h, center, half, derivative) {
    let hs = 0;
    let count = 0;

    for (let i = center - half; i < center + half; i++) {
      if (i >= 0 && i < h.length - 1) {
        hs += h[i + 1] - h[i];
        count++;
      }
    }

    return Math.pow(hs / count, derivative);
  }

  function GramPoly(i, m, k, s) {
    let Grampoly = 0;

    if (k > 0) {
      Grampoly = (4 * k - 2) / (k * (2 * m - k + 1)) * (i * GramPoly(i, m, k - 1, s) + s * GramPoly(i, m, k - 1, s - 1)) - (k - 1) * (2 * m + k) / (k * (2 * m - k + 1)) * GramPoly(i, m, k - 2, s);
    } else {
      if (k === 0 && s === 0) {
        Grampoly = 1;
      } else {
        Grampoly = 0;
      }
    }

    return Grampoly;
  }

  function GenFact(a, b) {
    let gf = 1;

    if (a >= b) {
      for (let j = a - b + 1; j <= a; j++) {
        gf *= j;
      }
    }

    return gf;
  }

  function Weight(i, t, m, n, s) {
    let sum = 0;

    for (let k = 0; k <= n; k++) {
      //console.log(k);
      sum += (2 * k + 1) * (GenFact(2 * m, k) / GenFact(2 * m + k + 1, k + 1)) * GramPoly(i, m, k, 0) * GramPoly(t, m, k, s);
    }

    return sum;
  }
  /**
   *
   * @param m  Number of points
   * @param n  Polynomial grade
   * @param s  Derivative
   */


  function fullWeights(m, n, s) {
    let weights = new Array(m);
    let np = Math.floor(m / 2);

    for (let t = -np; t <= np; t++) {
      weights[t + np] = new Array(m);

      for (let j = -np; j <= np; j++) {
        weights[t + np][j + np] = Weight(j, t, np, n, s);
      }
    }

    return weights;
  }
  /*function entropy(data,h,options){
      var trend = SavitzkyGolay(data,h,trendOptions);
      var copy = new Array(data.length);
      var sum = 0;
      var max = 0;
      for(var i=0;i<data.length;i++){
          copy[i] = data[i]-trend[i];
      }

      sum/=data.length;
      console.log(sum+" "+max);
      console.log(stat.array.standardDeviation(copy));
      console.log(Math.abs(stat.array.mean(copy))/stat.array.standardDeviation(copy));
      return sum;

  }



  function guessWindowSize(data, h){
      console.log("entropy "+entropy(data,h,trendOptions));
      return 5;
  }
  */

  /**
   * Global spectra deconvolution
   * @param {object} data - Object data with x and y arrays
   * @param {Array<number>} [data.x] - Independent variable
   * @param {Array<number>} [data.y] - Dependent variable
   * @param {object} [options={}] - Options object
   * @param {object} [options.shape={}] - Object that specified the kind of shape to calculate the FWHM instead of width between inflection points. see https://mljs.github.io/peak-shape-generator/#inflectionpointswidthtofwhm
   * @param {object} [options.shape.kind='gaussian']
   * @param {object} [options.shape.options={}]
   * @param {object} [options.sgOptions] - Options object for Savitzky-Golay filter. See https://github.com/mljs/savitzky-golay-generalized#options
   * @param {number} [options.sgOptions.windowSize = 9] - points to use in the approximations
   * @param {number} [options.sgOptions.polynomial = 3] - degree of the polynomial to use in the approximations
   * @param {number} [options.minMaxRatio = 0.00025] - Threshold to determine if a given peak should be considered as a noise
   * @param {number} [options.broadRatio = 0.00] - If `broadRatio` is higher than 0, then all the peaks which second derivative
   * smaller than `broadRatio * maxAbsSecondDerivative` will be marked with the soft mask equal to true.
   * @param {number} [options.noiseLevel = 0] - Noise threshold in spectrum units
   * @param {boolean} [options.maxCriteria = true] - Peaks are local maximum(true) or minimum(false)
   * @param {boolean} [options.smoothY = true] - Select the peak intensities from a smoothed version of the independent variables
   * @param {boolean} [options.realTopDetection = false] - Use a quadratic optimizations with the peak and its 3 closest neighbors
   * to determine the true x,y values of the peak?
   * @param {number} [options.heightFactor = 0] - Factor to multiply the calculated height (usually 2)
   * @param {number} [options.derivativeThreshold = -1] - Filters based on the amplitude of the first derivative
   * @return {Array<object>}
   */

  function gsd(data, options = {}) {
    let {
      noiseLevel,
      sgOptions = {
        windowSize: 9,
        polynomial: 3
      },
      shape = {},
      smoothY = true,
      heightFactor = 0,
      broadRatio = 0.0,
      maxCriteria = true,
      minMaxRatio = 0.00025,
      derivativeThreshold = -1,
      realTopDetection = false
    } = options;
    let {
      y: yIn,
      x
    } = data;
    const y = yIn.slice();
    let equalSpaced = isEqualSpaced(x);

    if (maxCriteria === false) {
      for (let i = 0; i < y.length; i++) {
        y[i] *= -1;
      }
    }

    if (noiseLevel === undefined) {
      noiseLevel = equalSpaced ? getNoiseLevel(y) : 0;
    }

    for (let i = 0; i < y.length; i++) {
      y[i] -= noiseLevel;
    }

    for (let i = 0; i < y.length; i++) {
      if (y[i] < 0) {
        y[i] = 0;
      }
    } // If the max difference between delta x is less than 5%, then,
    // we can assume it to be equally spaced variable


    let yData = y;
    let dY, ddY;
    const {
      windowSize,
      polynomial
    } = sgOptions;

    if (equalSpaced) {
      if (smoothY) {
        yData = SavitzkyGolay(y, x[1] - x[0], {
          windowSize,
          polynomial,
          derivative: 0
        });
      }

      dY = SavitzkyGolay(y, x[1] - x[0], {
        windowSize,
        polynomial,
        derivative: 1
      });
      ddY = SavitzkyGolay(y, x[1] - x[0], {
        windowSize,
        polynomial,
        derivative: 2
      });
    } else {
      if (smoothY) {
        yData = SavitzkyGolay(y, x, {
          windowSize,
          polynomial,
          derivative: 0
        });
      }

      dY = SavitzkyGolay(y, x, {
        windowSize,
        polynomial,
        derivative: 1
      });
      ddY = SavitzkyGolay(y, x, {
        windowSize,
        polynomial,
        derivative: 2
      });
    }

    const xData = x;
    const dX = x[1] - x[0];
    let maxDdy = 0;
    let maxY = 0;

    for (let i = 0; i < yData.length; i++) {
      if (Math.abs(ddY[i]) > maxDdy) {
        maxDdy = Math.abs(ddY[i]);
      }

      if (Math.abs(yData[i]) > maxY) {
        maxY = Math.abs(yData[i]);
      }
    }

    let lastMax = null;
    let lastMin = null;
    let minddY = [];
    let intervalL = [];
    let intervalR = [];
    let broadMask = []; // By the intermediate value theorem We cannot find 2 consecutive maximum or minimum

    for (let i = 1; i < yData.length - 1; ++i) {
      // filter based on derivativeThreshold
      // console.log('pasa', y[i], dY[i], ddY[i]);
      if (Math.abs(dY[i]) > derivativeThreshold) {
        // Minimum in first derivative
        if (dY[i] < dY[i - 1] && dY[i] <= dY[i + 1] || dY[i] <= dY[i - 1] && dY[i] < dY[i + 1]) {
          lastMin = {
            x: xData[i],
            index: i
          };

          if (dX > 0 && lastMax !== null) {
            intervalL.push(lastMax);
            intervalR.push(lastMin);
          }
        } // Maximum in first derivative


        if (dY[i] >= dY[i - 1] && dY[i] > dY[i + 1] || dY[i] > dY[i - 1] && dY[i] >= dY[i + 1]) {
          lastMax = {
            x: xData[i],
            index: i
          };

          if (dX < 0 && lastMin !== null) {
            intervalL.push(lastMax);
            intervalR.push(lastMin);
          }
        }
      } // Minimum in second derivative


      if (ddY[i] < ddY[i - 1] && ddY[i] < ddY[i + 1]) {
        minddY.push(i);
        broadMask.push(Math.abs(ddY[i]) <= broadRatio * maxDdy);
      }
    }

    let widthProcessor = shape.kind ? getShapeGenerator(shape.kind, shape.options).widthToFWHM : x => x;
    let signals = [];
    let lastK = -1;
    let possible, frequency, distanceJ, minDistance, gettingCloser;

    for (let j = 0; j < minddY.length; ++j) {
      frequency = xData[minddY[j]];
      possible = -1;
      let k = lastK + 1;
      minDistance = Number.MAX_VALUE;
      distanceJ = 0;
      gettingCloser = true;

      while (possible === -1 && k < intervalL.length && gettingCloser) {
        distanceJ = Math.abs(frequency - (intervalL[k].x + intervalR[k].x) / 2); // Still getting closer?

        if (distanceJ < minDistance) {
          minDistance = distanceJ;
        } else {
          gettingCloser = false;
        }

        if (distanceJ < Math.abs(intervalL[k].x - intervalR[k].x) / 2) {
          possible = k;
          lastK = k;
        }

        ++k;
      }

      if (possible !== -1) {
        if (Math.abs(yData[minddY[j]]) > minMaxRatio * maxY) {
          let width = Math.abs(intervalR[possible].x - intervalL[possible].x);
          signals.push({
            index: minddY[j],
            x: frequency,
            y: maxCriteria ? yData[minddY[j]] + noiseLevel : -yData[minddY[j]] - noiseLevel,
            width: widthProcessor(width),
            soft: broadMask[j]
          });
          signals[signals.length - 1].left = intervalL[possible];
          signals[signals.length - 1].right = intervalR[possible];

          if (heightFactor) {
            let yLeft = yData[intervalL[possible].index];
            let yRight = yData[intervalR[possible].index];
            signals[signals.length - 1].height = heightFactor * (signals[signals.length - 1].y - (yLeft + yRight) / 2);
          }
        }
      }
    }

    if (realTopDetection) {
      determineRealTop$1(signals, xData, yData);
    } // Correct the values to fit the original spectra data


    for (let j = 0; j < signals.length; j++) {
      signals[j].base = noiseLevel;
    }

    signals.sort(function (a, b) {
      return a.x - b.x;
    });
    return signals;
  }

  const isEqualSpaced = x => {
    let tmp;
    let maxDx = 0;
    let minDx = Number.MAX_SAFE_INTEGER;

    for (let i = 0; i < x.length - 1; ++i) {
      tmp = Math.abs(x[i + 1] - x[i]);

      if (tmp < minDx) {
        minDx = tmp;
      }

      if (tmp > maxDx) {
        maxDx = tmp;
      }
    }

    return (maxDx - minDx) / maxDx < 0.05;
  };

  const getNoiseLevel = y => {
    let mean = 0;
    let stddev = 0;
    let length = y.length;

    for (let i = 0; i < length; ++i) {
      mean += y[i];
    }

    mean /= length;
    let averageDeviations = new Array(length);

    for (let i = 0; i < length; ++i) {
      averageDeviations[i] = Math.abs(y[i] - mean);
    }

    averageDeviations.sort((a, b) => a - b);

    if (length % 2 === 1) {
      stddev = averageDeviations[(length - 1) / 2] / 0.6745;
    } else {
      stddev = 0.5 * (averageDeviations[length / 2] + averageDeviations[length / 2 - 1]) / 0.6745;
    }

    return stddev;
  };

  const determineRealTop$1 = (peakList, x, y) => {
    let alpha, beta, gamma, p, currentPoint;

    for (let j = 0; j < peakList.length; j++) {
      currentPoint = peakList[j].index; // peakList[j][2];
      // The detected peak could be moved 1 or 2 units to left or right.

      if (y[currentPoint - 1] >= y[currentPoint - 2] && y[currentPoint - 1] >= y[currentPoint]) {
        currentPoint--;
      } else {
        if (y[currentPoint + 1] >= y[currentPoint] && y[currentPoint + 1] >= y[currentPoint + 2]) {
          currentPoint++;
        } else {
          if (y[currentPoint - 2] >= y[currentPoint - 3] && y[currentPoint - 2] >= y[currentPoint - 1]) {
            currentPoint -= 2;
          } else {
            if (y[currentPoint + 2] >= y[currentPoint + 1] && y[currentPoint + 2] >= y[currentPoint + 3]) {
              currentPoint += 2;
            }
          }
        }
      } // interpolation to a sin() function


      if (y[currentPoint - 1] > 0 && y[currentPoint + 1] > 0 && y[currentPoint] >= y[currentPoint - 1] && y[currentPoint] >= y[currentPoint + 1] && (y[currentPoint] !== y[currentPoint - 1] || y[currentPoint] !== y[currentPoint + 1])) {
        alpha = 20 * Math.log10(y[currentPoint - 1]);
        beta = 20 * Math.log10(y[currentPoint]);
        gamma = 20 * Math.log10(y[currentPoint + 1]);
        p = 0.5 * (alpha - gamma) / (alpha - 2 * beta + gamma); // console.log(alpha, beta, gamma, `p: ${p}`);
        // console.log(x[currentPoint]+" "+tmp+" "+currentPoint);

        peakList[j].x = x[currentPoint] + (x[currentPoint] - x[currentPoint - 1]) * p;
        peakList[j].y = y[currentPoint] - 0.25 * (y[currentPoint - 1] - y[currentPoint + 1]) * p;
      }
    }
  };

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function getDefaultExportFromCjs (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  var assignDeep$1 = {exports: {}};

  /*!
   * assign-symbols <https://github.com/jonschlinkert/assign-symbols>
   *
   * Copyright (c) 2015-present, Jon Schlinkert.
   * Licensed under the MIT License.
   */

  const toString$2 = Object.prototype.toString;
  const isEnumerable = Object.prototype.propertyIsEnumerable;
  const getSymbols = Object.getOwnPropertySymbols;

  var assignSymbols$1 = (target, ...args) => {
    if (!isObject$1(target)) {
      throw new TypeError('expected the first argument to be an object');
    }

    if (args.length === 0 || typeof Symbol !== 'function' || typeof getSymbols !== 'function') {
      return target;
    }

    for (let arg of args) {
      let names = getSymbols(arg);

      for (let key of names) {
        if (isEnumerable.call(arg, key)) {
          target[key] = arg[key];
        }
      }
    }

    return target;
  };

  function isObject$1(val) {
    return typeof val === 'function' || toString$2.call(val) === '[object Object]' || Array.isArray(val);
  }

  /*!
   * assign-deep <https://github.com/jonschlinkert/assign-deep>
   *
   * Copyright (c) 2017-present, Jon Schlinkert.
   * Released under the MIT License.
   */

  const toString$1 = Object.prototype.toString;
  const assignSymbols = assignSymbols$1;

  const isValidKey = key => {
    return key !== '__proto__' && key !== 'constructor' && key !== 'prototype';
  };

  const assign = assignDeep$1.exports = (target, ...args) => {
    let i = 0;
    if (isPrimitive(target)) target = args[i++];
    if (!target) target = {};

    for (; i < args.length; i++) {
      if (isObject(args[i])) {
        for (const key of Object.keys(args[i])) {
          if (isValidKey(key)) {
            if (isObject(target[key]) && isObject(args[i][key])) {
              assign(target[key], args[i][key]);
            } else {
              target[key] = args[i][key];
            }
          }
        }

        assignSymbols(target, args[i]);
      }
    }

    return target;
  };

  function isObject(val) {
    return typeof val === 'function' || toString$1.call(val) === '[object Object]';
  }

  function isPrimitive(val) {
    return typeof val === 'object' ? val === null : typeof val !== 'function';
  }

  var assignDeep = assignDeep$1.exports;

  const toString = Object.prototype.toString;
  function isAnyArray(object) {
    return toString.call(object).endsWith('Array]');
  }

  function max(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    }

    if (input.length === 0) {
      throw new TypeError('input must not be empty');
    }

    var _options$fromIndex = options.fromIndex,
        fromIndex = _options$fromIndex === void 0 ? 0 : _options$fromIndex,
        _options$toIndex = options.toIndex,
        toIndex = _options$toIndex === void 0 ? input.length : _options$toIndex;

    if (fromIndex < 0 || fromIndex >= input.length || !Number.isInteger(fromIndex)) {
      throw new Error('fromIndex must be a positive integer smaller than length');
    }

    if (toIndex <= fromIndex || toIndex > input.length || !Number.isInteger(toIndex)) {
      throw new Error('toIndex must be an integer greater than fromIndex and at most equal to length');
    }

    var maxValue = input[fromIndex];

    for (var i = fromIndex + 1; i < toIndex; i++) {
      if (input[i] > maxValue) maxValue = input[i];
    }

    return maxValue;
  }

  /**
   * This function calculates the spectrum as a sum of linear combination of gaussian and lorentzian functions. The pseudo voigt
   * parameters are divided in 4 batches. 1st: centers; 2nd: heights; 3th: widths; 4th: mu's ;
   * @param t Ordinate value
   * @param p Lorentzian parameters
   * @returns {*}
   */

  function sumOfGaussianLorentzians(p) {
    return function (t) {
      let nL = p.length / 4;
      let result = 0;

      for (let i = 0; i < nL; i++) {
        result += p[i + nL] * PseudoVoigt.fct(t - p[i], p[i + nL * 2], p[i + nL * 3]);
      }

      return result;
    };
  }

  /**
   * This function calculates the spectrum as a sum of gaussian functions. The Gaussian
   * parameters are divided in 3 batches. 1st: centers; 2nd: height; 3th: widths;
   * @param t Ordinate values
   * @param p Gaussian parameters
   * @returns {*}
   */

  function sumOfGaussians(p) {
    return function (t) {
      let nL = p.length / 3;
      let result = 0;

      for (let i = 0; i < nL; i++) {
        result += p[i + nL] * Gaussian.fct(t - p[i], p[i + nL * 2]);
      }

      return result;
    };
  }

  /**
   * This function calculates the spectrum as a sum of lorentzian functions. The Lorentzian
   * parameters are divided in 3 batches. 1st: centers; 2nd: heights; 3th: widths;
   * @param t Ordinate values
   * @param p Lorentzian parameters
   * @returns {*}
   */

  function sumOfLorentzians(p) {
    return function (t) {
      let nL = p.length / 3;
      let result = 0;

      for (let i = 0; i < nL; i++) {
        result += p[i + nL] * Lorentzian.fct(t - p[i], p[i + nL * 2]);
      }

      return result;
    };
  }

  function checkInput(data, peaks, options) {
    let {
      shape = {
        kind: 'gaussian'
      },
      optimization = {
        kind: 'lm'
      }
    } = options;

    if (typeof shape.kind !== 'string') {
      throw new Error('kind should be a string');
    }

    let kind = shape.kind.toLowerCase().replace(/[^a-z]/g, '');
    let paramsFunc;
    let defaultParameters;

    switch (kind) {
      case 'gaussian':
        paramsFunc = sumOfGaussians;
        defaultParameters = {
          x: {
            init: peak => peak.x,
            max: peak => peak.x + peak.width * 2,
            min: peak => peak.x - peak.width * 2,
            gradientDifference: peak => peak.width * 2e-3
          },
          y: {
            init: peak => peak.y,
            max: () => 1.5,
            min: () => 0,
            gradientDifference: () => 1e-3
          },
          width: {
            init: peak => peak.width,
            max: peak => peak.width * 4,
            min: peak => peak.width * 0.25,
            gradientDifference: peak => peak.width * 2e-3
          }
        };
        break;

      case 'lorentzian':
        paramsFunc = sumOfLorentzians;
        defaultParameters = {
          x: {
            init: peak => peak.x,
            max: peak => peak.x + peak.width * 2,
            min: peak => peak.x - peak.width * 2,
            gradientDifference: peak => peak.width * 2e-3
          },
          y: {
            init: peak => peak.y,
            max: () => 1.5,
            min: () => 0,
            gradientDifference: () => 1e-3
          },
          width: {
            init: peak => peak.width,
            max: peak => peak.width * 4,
            min: peak => peak.width * 0.25,
            gradientDifference: peak => peak.width * 2e-3
          }
        };
        break;

      case 'pseudovoigt':
        paramsFunc = sumOfGaussianLorentzians;
        defaultParameters = {
          x: {
            init: peak => peak.x,
            max: peak => peak.x + peak.width * 2,
            min: peak => peak.x - peak.width * 2,
            gradientDifference: peak => peak.width * 2e-3
          },
          y: {
            init: peak => peak.y,
            max: () => 1.5,
            min: () => 0,
            gradientDifference: () => 1e-3
          },
          width: {
            init: peak => peak.width,
            max: peak => peak.width * 4,
            min: peak => peak.width * 0.25,
            gradientDifference: peak => peak.width * 2e-3
          },
          mu: {
            init: peak => peak.mu !== undefined ? peak.mu : 0.5,
            min: () => 0,
            max: () => 1,
            gradientDifference: () => 0.01
          }
        };
        break;

      default:
        throw new Error('kind of shape is not supported');
    }

    let x = data.x;
    let maxY = max(data.y);
    let y = new Array(x.length);

    for (let i = 0; i < x.length; i++) {
      y[i] = data.y[i] / maxY;
    }

    for (let i = 0; i < peaks.length; i++) {
      peaks[i].y /= maxY;
    }

    let parameters = assignDeep({}, optimization.parameters, defaultParameters);

    for (let key in parameters) {
      for (let par in parameters[key]) {
        if (!Array.isArray(parameters[key][par])) {
          parameters[key][par] = [parameters[key][par]];
        }

        if (parameters[key][par].length !== 1 && parameters[key][par].length !== peaks.length) {
          throw new Error(`The length of ${key}-${par} is not correct`);
        }

        for (let index = 0; index < parameters[key][par].length; index++) {
          if (typeof parameters[key][par][index] === 'number') {
            let value = parameters[key][par][index];

            parameters[key][par][index] = () => value;
          }
        }
      }
    }

    optimization.parameters = parameters;
    return {
      y,
      x,
      maxY,
      peaks,
      paramsFunc,
      optimization
    };
  }

  function checkOptions$1(data, parameterizedFunction, options) {
    let {
      timeout,
      minValues,
      maxValues,
      initialValues,
      weights = 1,
      damping = 1e-2,
      dampingStepUp = 11,
      dampingStepDown = 9,
      maxIterations = 100,
      errorTolerance = 1e-7,
      centralDifference = false,
      gradientDifference = 10e-2,
      improvementThreshold = 1e-3
    } = options;

    if (damping <= 0) {
      throw new Error('The damping option must be a positive number');
    } else if (!data.x || !data.y) {
      throw new Error('The data parameter must have x and y elements');
    } else if (!isAnyArray(data.x) || data.x.length < 2 || !isAnyArray(data.y) || data.y.length < 2) {
      throw new Error('The data parameter elements must be an array with more than 2 points');
    } else if (data.x.length !== data.y.length) {
      throw new Error('The data parameter elements must have the same size');
    }

    let parameters = initialValues || new Array(parameterizedFunction.length).fill(1);
    let nbPoints = data.y.length;
    let parLen = parameters.length;
    maxValues = maxValues || new Array(parLen).fill(Number.MAX_SAFE_INTEGER);
    minValues = minValues || new Array(parLen).fill(Number.MIN_SAFE_INTEGER);

    if (maxValues.length !== minValues.length) {
      throw new Error('minValues and maxValues must be the same size');
    }

    if (!isAnyArray(parameters)) {
      throw new Error('initialValues must be an array');
    }

    if (typeof gradientDifference === 'number') {
      gradientDifference = new Array(parameters.length).fill(gradientDifference);
    } else if (isAnyArray(gradientDifference)) {
      if (gradientDifference.length !== parLen) {
        gradientDifference = new Array(parLen).fill(gradientDifference[0]);
      }
    } else {
      throw new Error('gradientDifference should be a number or array with length equal to the number of parameters');
    }

    let filler;

    if (typeof weights === 'number') {
      let value = 1 / weights ** 2;

      filler = () => value;
    } else if (isAnyArray(weights)) {
      if (weights.length < data.x.length) {
        let value = 1 / weights[0] ** 2;

        filler = () => value;
      } else {
        filler = i => 1 / weights[i] ** 2;
      }
    } else {
      throw new Error('weights should be a number or array with length equal to the number of data points');
    }

    let checkTimeout;

    if (timeout !== undefined) {
      if (typeof timeout !== 'number') {
        throw new Error('timeout should be a number');
      }

      let endTime = Date.now() + timeout * 1000;

      checkTimeout = () => Date.now() > endTime;
    } else {
      checkTimeout = () => false;
    }

    let weightSquare = new Array(data.x.length);

    for (let i = 0; i < nbPoints; i++) {
      weightSquare[i] = filler(i);
    }

    return {
      checkTimeout,
      minValues,
      maxValues,
      parameters,
      weightSquare,
      damping,
      dampingStepUp,
      dampingStepDown,
      maxIterations,
      errorTolerance,
      centralDifference,
      gradientDifference,
      improvementThreshold
    };
  }

  /**
   * the sum of the weighted squares of the errors (or weighted residuals) between the data.y
   * and the curve-fit function.
   * @ignore
   * @param {{x:Array<number>, y:Array<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
   * @param {Array<number>} parameters - Array of current parameter values
   * @param {function} parameterizedFunction - The parameters and returns a function with the independent variable as a parameter
   * @param {Array} weightSquare - Square of weights
   * @return {number}
   */
  function errorCalculation(data, parameters, parameterizedFunction, weightSquare) {
    let error = 0;
    const func = parameterizedFunction(parameters);

    for (let i = 0; i < data.x.length; i++) {
      error += Math.pow(data.y[i] - func(data.x[i]), 2) / weightSquare[i];
    }

    return error;
  }

  function min(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    }

    if (input.length === 0) {
      throw new TypeError('input must not be empty');
    }

    var _options$fromIndex = options.fromIndex,
        fromIndex = _options$fromIndex === void 0 ? 0 : _options$fromIndex,
        _options$toIndex = options.toIndex,
        toIndex = _options$toIndex === void 0 ? input.length : _options$toIndex;

    if (fromIndex < 0 || fromIndex >= input.length || !Number.isInteger(fromIndex)) {
      throw new Error('fromIndex must be a positive integer smaller than length');
    }

    if (toIndex <= fromIndex || toIndex > input.length || !Number.isInteger(toIndex)) {
      throw new Error('toIndex must be an integer greater than fromIndex and at most equal to length');
    }

    var minValue = input[fromIndex];

    for (var i = fromIndex + 1; i < toIndex; i++) {
      if (input[i] < minValue) minValue = input[i];
    }

    return minValue;
  }

  function rescale(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    } else if (input.length === 0) {
      throw new TypeError('input must not be empty');
    }

    var output;

    if (options.output !== undefined) {
      if (!isAnyArray(options.output)) {
        throw new TypeError('output option must be an array if specified');
      }

      output = options.output;
    } else {
      output = new Array(input.length);
    }

    var currentMin = min(input);
    var currentMax = max(input);

    if (currentMin === currentMax) {
      throw new RangeError('minimum and maximum input values are equal. Cannot rescale a constant array');
    }

    var _options$min = options.min,
        minValue = _options$min === void 0 ? options.autoMinMax ? currentMin : 0 : _options$min,
        _options$max = options.max,
        maxValue = _options$max === void 0 ? options.autoMinMax ? currentMax : 1 : _options$max;

    if (minValue >= maxValue) {
      throw new RangeError('min option must be smaller than max option');
    }

    var factor = (maxValue - minValue) / (currentMax - currentMin);

    for (var i = 0; i < input.length; i++) {
      output[i] = (input[i] - currentMin) * factor + minValue;
    }

    return output;
  }

  const indent = ' '.repeat(2);
  const indentData = ' '.repeat(4);
  function inspectMatrix() {
    return inspectMatrixWithOptions(this);
  }
  function inspectMatrixWithOptions(matrix, options = {}) {
    const {
      maxRows = 15,
      maxColumns = 10,
      maxNumSize = 8
    } = options;
    return `${matrix.constructor.name} {
${indent}[
${indentData}${inspectData(matrix, maxRows, maxColumns, maxNumSize)}
${indent}]
${indent}rows: ${matrix.rows}
${indent}columns: ${matrix.columns}
}`;
  }

  function inspectData(matrix, maxRows, maxColumns, maxNumSize) {
    const {
      rows,
      columns
    } = matrix;
    const maxI = Math.min(rows, maxRows);
    const maxJ = Math.min(columns, maxColumns);
    const result = [];

    for (let i = 0; i < maxI; i++) {
      let line = [];

      for (let j = 0; j < maxJ; j++) {
        line.push(formatNumber(matrix.get(i, j), maxNumSize));
      }

      result.push(`${line.join(' ')}`);
    }

    if (maxJ !== columns) {
      result[result.length - 1] += ` ... ${columns - maxColumns} more columns`;
    }

    if (maxI !== rows) {
      result.push(`... ${rows - maxRows} more rows`);
    }

    return result.join(`\n${indentData}`);
  }

  function formatNumber(num, maxNumSize) {
    const numStr = String(num);

    if (numStr.length <= maxNumSize) {
      return numStr.padEnd(maxNumSize, ' ');
    }

    const precise = num.toPrecision(maxNumSize - 2);

    if (precise.length <= maxNumSize) {
      return precise;
    }

    const exponential = num.toExponential(maxNumSize - 2);
    const eIndex = exponential.indexOf('e');
    const e = exponential.slice(eIndex);
    return exponential.slice(0, maxNumSize - e.length) + e;
  }

  function installMathOperations(AbstractMatrix, Matrix) {
    AbstractMatrix.prototype.add = function add(value) {
      if (typeof value === 'number') return this.addS(value);
      return this.addM(value);
    };

    AbstractMatrix.prototype.addS = function addS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) + value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.addM = function addM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) + matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.add = function add(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.add(value);
    };

    AbstractMatrix.prototype.sub = function sub(value) {
      if (typeof value === 'number') return this.subS(value);
      return this.subM(value);
    };

    AbstractMatrix.prototype.subS = function subS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) - value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.subM = function subM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) - matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.sub = function sub(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.sub(value);
    };

    AbstractMatrix.prototype.subtract = AbstractMatrix.prototype.sub;
    AbstractMatrix.prototype.subtractS = AbstractMatrix.prototype.subS;
    AbstractMatrix.prototype.subtractM = AbstractMatrix.prototype.subM;
    AbstractMatrix.subtract = AbstractMatrix.sub;

    AbstractMatrix.prototype.mul = function mul(value) {
      if (typeof value === 'number') return this.mulS(value);
      return this.mulM(value);
    };

    AbstractMatrix.prototype.mulS = function mulS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) * value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.mulM = function mulM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) * matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.mul = function mul(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.mul(value);
    };

    AbstractMatrix.prototype.multiply = AbstractMatrix.prototype.mul;
    AbstractMatrix.prototype.multiplyS = AbstractMatrix.prototype.mulS;
    AbstractMatrix.prototype.multiplyM = AbstractMatrix.prototype.mulM;
    AbstractMatrix.multiply = AbstractMatrix.mul;

    AbstractMatrix.prototype.div = function div(value) {
      if (typeof value === 'number') return this.divS(value);
      return this.divM(value);
    };

    AbstractMatrix.prototype.divS = function divS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) / value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.divM = function divM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) / matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.div = function div(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.div(value);
    };

    AbstractMatrix.prototype.divide = AbstractMatrix.prototype.div;
    AbstractMatrix.prototype.divideS = AbstractMatrix.prototype.divS;
    AbstractMatrix.prototype.divideM = AbstractMatrix.prototype.divM;
    AbstractMatrix.divide = AbstractMatrix.div;

    AbstractMatrix.prototype.mod = function mod(value) {
      if (typeof value === 'number') return this.modS(value);
      return this.modM(value);
    };

    AbstractMatrix.prototype.modS = function modS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) % value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.modM = function modM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) % matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.mod = function mod(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.mod(value);
    };

    AbstractMatrix.prototype.modulus = AbstractMatrix.prototype.mod;
    AbstractMatrix.prototype.modulusS = AbstractMatrix.prototype.modS;
    AbstractMatrix.prototype.modulusM = AbstractMatrix.prototype.modM;
    AbstractMatrix.modulus = AbstractMatrix.mod;

    AbstractMatrix.prototype.and = function and(value) {
      if (typeof value === 'number') return this.andS(value);
      return this.andM(value);
    };

    AbstractMatrix.prototype.andS = function andS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) & value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.andM = function andM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) & matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.and = function and(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.and(value);
    };

    AbstractMatrix.prototype.or = function or(value) {
      if (typeof value === 'number') return this.orS(value);
      return this.orM(value);
    };

    AbstractMatrix.prototype.orS = function orS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) | value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.orM = function orM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) | matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.or = function or(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.or(value);
    };

    AbstractMatrix.prototype.xor = function xor(value) {
      if (typeof value === 'number') return this.xorS(value);
      return this.xorM(value);
    };

    AbstractMatrix.prototype.xorS = function xorS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) ^ value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.xorM = function xorM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) ^ matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.xor = function xor(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.xor(value);
    };

    AbstractMatrix.prototype.leftShift = function leftShift(value) {
      if (typeof value === 'number') return this.leftShiftS(value);
      return this.leftShiftM(value);
    };

    AbstractMatrix.prototype.leftShiftS = function leftShiftS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) << value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.leftShiftM = function leftShiftM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) << matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.leftShift = function leftShift(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.leftShift(value);
    };

    AbstractMatrix.prototype.signPropagatingRightShift = function signPropagatingRightShift(value) {
      if (typeof value === 'number') return this.signPropagatingRightShiftS(value);
      return this.signPropagatingRightShiftM(value);
    };

    AbstractMatrix.prototype.signPropagatingRightShiftS = function signPropagatingRightShiftS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) >> value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.signPropagatingRightShiftM = function signPropagatingRightShiftM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) >> matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.signPropagatingRightShift = function signPropagatingRightShift(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.signPropagatingRightShift(value);
    };

    AbstractMatrix.prototype.rightShift = function rightShift(value) {
      if (typeof value === 'number') return this.rightShiftS(value);
      return this.rightShiftM(value);
    };

    AbstractMatrix.prototype.rightShiftS = function rightShiftS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) >>> value);
        }
      }

      return this;
    };

    AbstractMatrix.prototype.rightShiftM = function rightShiftM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) >>> matrix.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.rightShift = function rightShift(matrix, value) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.rightShift(value);
    };

    AbstractMatrix.prototype.zeroFillRightShift = AbstractMatrix.prototype.rightShift;
    AbstractMatrix.prototype.zeroFillRightShiftS = AbstractMatrix.prototype.rightShiftS;
    AbstractMatrix.prototype.zeroFillRightShiftM = AbstractMatrix.prototype.rightShiftM;
    AbstractMatrix.zeroFillRightShift = AbstractMatrix.rightShift;

    AbstractMatrix.prototype.not = function not() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, ~this.get(i, j));
        }
      }

      return this;
    };

    AbstractMatrix.not = function not(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.not();
    };

    AbstractMatrix.prototype.abs = function abs() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.abs(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.abs = function abs(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.abs();
    };

    AbstractMatrix.prototype.acos = function acos() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.acos(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.acos = function acos(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.acos();
    };

    AbstractMatrix.prototype.acosh = function acosh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.acosh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.acosh = function acosh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.acosh();
    };

    AbstractMatrix.prototype.asin = function asin() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.asin(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.asin = function asin(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.asin();
    };

    AbstractMatrix.prototype.asinh = function asinh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.asinh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.asinh = function asinh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.asinh();
    };

    AbstractMatrix.prototype.atan = function atan() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.atan(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.atan = function atan(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.atan();
    };

    AbstractMatrix.prototype.atanh = function atanh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.atanh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.atanh = function atanh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.atanh();
    };

    AbstractMatrix.prototype.cbrt = function cbrt() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.cbrt(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.cbrt = function cbrt(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.cbrt();
    };

    AbstractMatrix.prototype.ceil = function ceil() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.ceil(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.ceil = function ceil(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.ceil();
    };

    AbstractMatrix.prototype.clz32 = function clz32() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.clz32(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.clz32 = function clz32(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.clz32();
    };

    AbstractMatrix.prototype.cos = function cos() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.cos(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.cos = function cos(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.cos();
    };

    AbstractMatrix.prototype.cosh = function cosh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.cosh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.cosh = function cosh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.cosh();
    };

    AbstractMatrix.prototype.exp = function exp() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.exp(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.exp = function exp(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.exp();
    };

    AbstractMatrix.prototype.expm1 = function expm1() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.expm1(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.expm1 = function expm1(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.expm1();
    };

    AbstractMatrix.prototype.floor = function floor() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.floor(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.floor = function floor(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.floor();
    };

    AbstractMatrix.prototype.fround = function fround() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.fround(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.fround = function fround(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.fround();
    };

    AbstractMatrix.prototype.log = function log() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.log(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.log = function log(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.log();
    };

    AbstractMatrix.prototype.log1p = function log1p() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.log1p(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.log1p = function log1p(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.log1p();
    };

    AbstractMatrix.prototype.log10 = function log10() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.log10(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.log10 = function log10(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.log10();
    };

    AbstractMatrix.prototype.log2 = function log2() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.log2(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.log2 = function log2(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.log2();
    };

    AbstractMatrix.prototype.round = function round() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.round(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.round = function round(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.round();
    };

    AbstractMatrix.prototype.sign = function sign() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.sign(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.sign = function sign(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.sign();
    };

    AbstractMatrix.prototype.sin = function sin() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.sin(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.sin = function sin(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.sin();
    };

    AbstractMatrix.prototype.sinh = function sinh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.sinh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.sinh = function sinh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.sinh();
    };

    AbstractMatrix.prototype.sqrt = function sqrt() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.sqrt(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.sqrt = function sqrt(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.sqrt();
    };

    AbstractMatrix.prototype.tan = function tan() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.tan(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.tan = function tan(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.tan();
    };

    AbstractMatrix.prototype.tanh = function tanh() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.tanh(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.tanh = function tanh(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.tanh();
    };

    AbstractMatrix.prototype.trunc = function trunc() {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.trunc(this.get(i, j)));
        }
      }

      return this;
    };

    AbstractMatrix.trunc = function trunc(matrix) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.trunc();
    };

    AbstractMatrix.pow = function pow(matrix, arg0) {
      const newMatrix = new Matrix(matrix);
      return newMatrix.pow(arg0);
    };

    AbstractMatrix.prototype.pow = function pow(value) {
      if (typeof value === 'number') return this.powS(value);
      return this.powM(value);
    };

    AbstractMatrix.prototype.powS = function powS(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.pow(this.get(i, j), value));
        }
      }

      return this;
    };

    AbstractMatrix.prototype.powM = function powM(matrix) {
      matrix = Matrix.checkMatrix(matrix);

      if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
        throw new RangeError('Matrices dimensions must be equal');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, Math.pow(this.get(i, j), matrix.get(i, j)));
        }
      }

      return this;
    };
  }

  /**
   * @private
   * Check that a row index is not out of bounds
   * @param {Matrix} matrix
   * @param {number} index
   * @param {boolean} [outer]
   */
  function checkRowIndex(matrix, index, outer) {
    let max = outer ? matrix.rows : matrix.rows - 1;

    if (index < 0 || index > max) {
      throw new RangeError('Row index out of range');
    }
  }
  /**
   * @private
   * Check that a column index is not out of bounds
   * @param {Matrix} matrix
   * @param {number} index
   * @param {boolean} [outer]
   */

  function checkColumnIndex(matrix, index, outer) {
    let max = outer ? matrix.columns : matrix.columns - 1;

    if (index < 0 || index > max) {
      throw new RangeError('Column index out of range');
    }
  }
  /**
   * @private
   * Check that the provided vector is an array with the right length
   * @param {Matrix} matrix
   * @param {Array|Matrix} vector
   * @return {Array}
   * @throws {RangeError}
   */

  function checkRowVector(matrix, vector) {
    if (vector.to1DArray) {
      vector = vector.to1DArray();
    }

    if (vector.length !== matrix.columns) {
      throw new RangeError('vector size must be the same as the number of columns');
    }

    return vector;
  }
  /**
   * @private
   * Check that the provided vector is an array with the right length
   * @param {Matrix} matrix
   * @param {Array|Matrix} vector
   * @return {Array}
   * @throws {RangeError}
   */

  function checkColumnVector(matrix, vector) {
    if (vector.to1DArray) {
      vector = vector.to1DArray();
    }

    if (vector.length !== matrix.rows) {
      throw new RangeError('vector size must be the same as the number of rows');
    }

    return vector;
  }
  function checkIndices(matrix, rowIndices, columnIndices) {
    return {
      row: checkRowIndices(matrix, rowIndices),
      column: checkColumnIndices(matrix, columnIndices)
    };
  }
  function checkRowIndices(matrix, rowIndices) {
    if (typeof rowIndices !== 'object') {
      throw new TypeError('unexpected type for row indices');
    }

    let rowOut = rowIndices.some(r => {
      return r < 0 || r >= matrix.rows;
    });

    if (rowOut) {
      throw new RangeError('row indices are out of range');
    }

    if (!Array.isArray(rowIndices)) rowIndices = Array.from(rowIndices);
    return rowIndices;
  }
  function checkColumnIndices(matrix, columnIndices) {
    if (typeof columnIndices !== 'object') {
      throw new TypeError('unexpected type for column indices');
    }

    let columnOut = columnIndices.some(c => {
      return c < 0 || c >= matrix.columns;
    });

    if (columnOut) {
      throw new RangeError('column indices are out of range');
    }

    if (!Array.isArray(columnIndices)) columnIndices = Array.from(columnIndices);
    return columnIndices;
  }
  function checkRange(matrix, startRow, endRow, startColumn, endColumn) {
    if (arguments.length !== 5) {
      throw new RangeError('expected 4 arguments');
    }

    checkNumber('startRow', startRow);
    checkNumber('endRow', endRow);
    checkNumber('startColumn', startColumn);
    checkNumber('endColumn', endColumn);

    if (startRow > endRow || startColumn > endColumn || startRow < 0 || startRow >= matrix.rows || endRow < 0 || endRow >= matrix.rows || startColumn < 0 || startColumn >= matrix.columns || endColumn < 0 || endColumn >= matrix.columns) {
      throw new RangeError('Submatrix indices are out of range');
    }
  }
  function newArray$1(length, value = 0) {
    let array = [];

    for (let i = 0; i < length; i++) {
      array.push(value);
    }

    return array;
  }

  function checkNumber(name, value) {
    if (typeof value !== 'number') {
      throw new TypeError(`${name} must be a number`);
    }
  }

  function checkNonEmpty(matrix) {
    if (matrix.isEmpty()) {
      throw new Error('Empty matrix has no elements to index');
    }
  }

  function sumByRow(matrix) {
    let sum = newArray$1(matrix.rows);

    for (let i = 0; i < matrix.rows; ++i) {
      for (let j = 0; j < matrix.columns; ++j) {
        sum[i] += matrix.get(i, j);
      }
    }

    return sum;
  }
  function sumByColumn(matrix) {
    let sum = newArray$1(matrix.columns);

    for (let i = 0; i < matrix.rows; ++i) {
      for (let j = 0; j < matrix.columns; ++j) {
        sum[j] += matrix.get(i, j);
      }
    }

    return sum;
  }
  function sumAll(matrix) {
    let v = 0;

    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        v += matrix.get(i, j);
      }
    }

    return v;
  }
  function productByRow(matrix) {
    let sum = newArray$1(matrix.rows, 1);

    for (let i = 0; i < matrix.rows; ++i) {
      for (let j = 0; j < matrix.columns; ++j) {
        sum[i] *= matrix.get(i, j);
      }
    }

    return sum;
  }
  function productByColumn(matrix) {
    let sum = newArray$1(matrix.columns, 1);

    for (let i = 0; i < matrix.rows; ++i) {
      for (let j = 0; j < matrix.columns; ++j) {
        sum[j] *= matrix.get(i, j);
      }
    }

    return sum;
  }
  function productAll(matrix) {
    let v = 1;

    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        v *= matrix.get(i, j);
      }
    }

    return v;
  }
  function varianceByRow(matrix, unbiased, mean) {
    const rows = matrix.rows;
    const cols = matrix.columns;
    const variance = [];

    for (let i = 0; i < rows; i++) {
      let sum1 = 0;
      let sum2 = 0;
      let x = 0;

      for (let j = 0; j < cols; j++) {
        x = matrix.get(i, j) - mean[i];
        sum1 += x;
        sum2 += x * x;
      }

      if (unbiased) {
        variance.push((sum2 - sum1 * sum1 / cols) / (cols - 1));
      } else {
        variance.push((sum2 - sum1 * sum1 / cols) / cols);
      }
    }

    return variance;
  }
  function varianceByColumn(matrix, unbiased, mean) {
    const rows = matrix.rows;
    const cols = matrix.columns;
    const variance = [];

    for (let j = 0; j < cols; j++) {
      let sum1 = 0;
      let sum2 = 0;
      let x = 0;

      for (let i = 0; i < rows; i++) {
        x = matrix.get(i, j) - mean[j];
        sum1 += x;
        sum2 += x * x;
      }

      if (unbiased) {
        variance.push((sum2 - sum1 * sum1 / rows) / (rows - 1));
      } else {
        variance.push((sum2 - sum1 * sum1 / rows) / rows);
      }
    }

    return variance;
  }
  function varianceAll(matrix, unbiased, mean) {
    const rows = matrix.rows;
    const cols = matrix.columns;
    const size = rows * cols;
    let sum1 = 0;
    let sum2 = 0;
    let x = 0;

    for (let i = 0; i < rows; i++) {
      for (let j = 0; j < cols; j++) {
        x = matrix.get(i, j) - mean;
        sum1 += x;
        sum2 += x * x;
      }
    }

    if (unbiased) {
      return (sum2 - sum1 * sum1 / size) / (size - 1);
    } else {
      return (sum2 - sum1 * sum1 / size) / size;
    }
  }
  function centerByRow(matrix, mean) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) - mean[i]);
      }
    }
  }
  function centerByColumn(matrix, mean) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) - mean[j]);
      }
    }
  }
  function centerAll(matrix, mean) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) - mean);
      }
    }
  }
  function getScaleByRow(matrix) {
    const scale = [];

    for (let i = 0; i < matrix.rows; i++) {
      let sum = 0;

      for (let j = 0; j < matrix.columns; j++) {
        sum += Math.pow(matrix.get(i, j), 2) / (matrix.columns - 1);
      }

      scale.push(Math.sqrt(sum));
    }

    return scale;
  }
  function scaleByRow(matrix, scale) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) / scale[i]);
      }
    }
  }
  function getScaleByColumn(matrix) {
    const scale = [];

    for (let j = 0; j < matrix.columns; j++) {
      let sum = 0;

      for (let i = 0; i < matrix.rows; i++) {
        sum += Math.pow(matrix.get(i, j), 2) / (matrix.rows - 1);
      }

      scale.push(Math.sqrt(sum));
    }

    return scale;
  }
  function scaleByColumn(matrix, scale) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) / scale[j]);
      }
    }
  }
  function getScaleAll(matrix) {
    const divider = matrix.size - 1;
    let sum = 0;

    for (let j = 0; j < matrix.columns; j++) {
      for (let i = 0; i < matrix.rows; i++) {
        sum += Math.pow(matrix.get(i, j), 2) / divider;
      }
    }

    return Math.sqrt(sum);
  }
  function scaleAll(matrix, scale) {
    for (let i = 0; i < matrix.rows; i++) {
      for (let j = 0; j < matrix.columns; j++) {
        matrix.set(i, j, matrix.get(i, j) / scale);
      }
    }
  }

  class AbstractMatrix {
    static from1DArray(newRows, newColumns, newData) {
      let length = newRows * newColumns;

      if (length !== newData.length) {
        throw new RangeError('data length does not match given dimensions');
      }

      let newMatrix = new Matrix(newRows, newColumns);

      for (let row = 0; row < newRows; row++) {
        for (let column = 0; column < newColumns; column++) {
          newMatrix.set(row, column, newData[row * newColumns + column]);
        }
      }

      return newMatrix;
    }

    static rowVector(newData) {
      let vector = new Matrix(1, newData.length);

      for (let i = 0; i < newData.length; i++) {
        vector.set(0, i, newData[i]);
      }

      return vector;
    }

    static columnVector(newData) {
      let vector = new Matrix(newData.length, 1);

      for (let i = 0; i < newData.length; i++) {
        vector.set(i, 0, newData[i]);
      }

      return vector;
    }

    static zeros(rows, columns) {
      return new Matrix(rows, columns);
    }

    static ones(rows, columns) {
      return new Matrix(rows, columns).fill(1);
    }

    static rand(rows, columns, options = {}) {
      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        random = Math.random
      } = options;
      let matrix = new Matrix(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          matrix.set(i, j, random());
        }
      }

      return matrix;
    }

    static randInt(rows, columns, options = {}) {
      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        min = 0,
        max = 1000,
        random = Math.random
      } = options;
      if (!Number.isInteger(min)) throw new TypeError('min must be an integer');
      if (!Number.isInteger(max)) throw new TypeError('max must be an integer');
      if (min >= max) throw new RangeError('min must be smaller than max');
      let interval = max - min;
      let matrix = new Matrix(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          let value = min + Math.round(random() * interval);
          matrix.set(i, j, value);
        }
      }

      return matrix;
    }

    static eye(rows, columns, value) {
      if (columns === undefined) columns = rows;
      if (value === undefined) value = 1;
      let min = Math.min(rows, columns);
      let matrix = this.zeros(rows, columns);

      for (let i = 0; i < min; i++) {
        matrix.set(i, i, value);
      }

      return matrix;
    }

    static diag(data, rows, columns) {
      let l = data.length;
      if (rows === undefined) rows = l;
      if (columns === undefined) columns = rows;
      let min = Math.min(l, rows, columns);
      let matrix = this.zeros(rows, columns);

      for (let i = 0; i < min; i++) {
        matrix.set(i, i, data[i]);
      }

      return matrix;
    }

    static min(matrix1, matrix2) {
      matrix1 = this.checkMatrix(matrix1);
      matrix2 = this.checkMatrix(matrix2);
      let rows = matrix1.rows;
      let columns = matrix1.columns;
      let result = new Matrix(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          result.set(i, j, Math.min(matrix1.get(i, j), matrix2.get(i, j)));
        }
      }

      return result;
    }

    static max(matrix1, matrix2) {
      matrix1 = this.checkMatrix(matrix1);
      matrix2 = this.checkMatrix(matrix2);
      let rows = matrix1.rows;
      let columns = matrix1.columns;
      let result = new this(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          result.set(i, j, Math.max(matrix1.get(i, j), matrix2.get(i, j)));
        }
      }

      return result;
    }

    static checkMatrix(value) {
      return AbstractMatrix.isMatrix(value) ? value : new Matrix(value);
    }

    static isMatrix(value) {
      return value != null && value.klass === 'Matrix';
    }

    get size() {
      return this.rows * this.columns;
    }

    apply(callback) {
      if (typeof callback !== 'function') {
        throw new TypeError('callback must be a function');
      }

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          callback.call(this, i, j);
        }
      }

      return this;
    }

    to1DArray() {
      let array = [];

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          array.push(this.get(i, j));
        }
      }

      return array;
    }

    to2DArray() {
      let copy = [];

      for (let i = 0; i < this.rows; i++) {
        copy.push([]);

        for (let j = 0; j < this.columns; j++) {
          copy[i].push(this.get(i, j));
        }
      }

      return copy;
    }

    toJSON() {
      return this.to2DArray();
    }

    isRowVector() {
      return this.rows === 1;
    }

    isColumnVector() {
      return this.columns === 1;
    }

    isVector() {
      return this.rows === 1 || this.columns === 1;
    }

    isSquare() {
      return this.rows === this.columns;
    }

    isEmpty() {
      return this.rows === 0 || this.columns === 0;
    }

    isSymmetric() {
      if (this.isSquare()) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j <= i; j++) {
            if (this.get(i, j) !== this.get(j, i)) {
              return false;
            }
          }
        }

        return true;
      }

      return false;
    }

    isEchelonForm() {
      let i = 0;
      let j = 0;
      let previousColumn = -1;
      let isEchelonForm = true;
      let checked = false;

      while (i < this.rows && isEchelonForm) {
        j = 0;
        checked = false;

        while (j < this.columns && checked === false) {
          if (this.get(i, j) === 0) {
            j++;
          } else if (this.get(i, j) === 1 && j > previousColumn) {
            checked = true;
            previousColumn = j;
          } else {
            isEchelonForm = false;
            checked = true;
          }
        }

        i++;
      }

      return isEchelonForm;
    }

    isReducedEchelonForm() {
      let i = 0;
      let j = 0;
      let previousColumn = -1;
      let isReducedEchelonForm = true;
      let checked = false;

      while (i < this.rows && isReducedEchelonForm) {
        j = 0;
        checked = false;

        while (j < this.columns && checked === false) {
          if (this.get(i, j) === 0) {
            j++;
          } else if (this.get(i, j) === 1 && j > previousColumn) {
            checked = true;
            previousColumn = j;
          } else {
            isReducedEchelonForm = false;
            checked = true;
          }
        }

        for (let k = j + 1; k < this.rows; k++) {
          if (this.get(i, k) !== 0) {
            isReducedEchelonForm = false;
          }
        }

        i++;
      }

      return isReducedEchelonForm;
    }

    echelonForm() {
      let result = this.clone();
      let h = 0;
      let k = 0;

      while (h < result.rows && k < result.columns) {
        let iMax = h;

        for (let i = h; i < result.rows; i++) {
          if (result.get(i, k) > result.get(iMax, k)) {
            iMax = i;
          }
        }

        if (result.get(iMax, k) === 0) {
          k++;
        } else {
          result.swapRows(h, iMax);
          let tmp = result.get(h, k);

          for (let j = k; j < result.columns; j++) {
            result.set(h, j, result.get(h, j) / tmp);
          }

          for (let i = h + 1; i < result.rows; i++) {
            let factor = result.get(i, k) / result.get(h, k);
            result.set(i, k, 0);

            for (let j = k + 1; j < result.columns; j++) {
              result.set(i, j, result.get(i, j) - result.get(h, j) * factor);
            }
          }

          h++;
          k++;
        }
      }

      return result;
    }

    reducedEchelonForm() {
      let result = this.echelonForm();
      let m = result.columns;
      let n = result.rows;
      let h = n - 1;

      while (h >= 0) {
        if (result.maxRow(h) === 0) {
          h--;
        } else {
          let p = 0;
          let pivot = false;

          while (p < n && pivot === false) {
            if (result.get(h, p) === 1) {
              pivot = true;
            } else {
              p++;
            }
          }

          for (let i = 0; i < h; i++) {
            let factor = result.get(i, p);

            for (let j = p; j < m; j++) {
              let tmp = result.get(i, j) - factor * result.get(h, j);
              result.set(i, j, tmp);
            }
          }

          h--;
        }
      }

      return result;
    }

    set() {
      throw new Error('set method is unimplemented');
    }

    get() {
      throw new Error('get method is unimplemented');
    }

    repeat(options = {}) {
      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        rows = 1,
        columns = 1
      } = options;

      if (!Number.isInteger(rows) || rows <= 0) {
        throw new TypeError('rows must be a positive integer');
      }

      if (!Number.isInteger(columns) || columns <= 0) {
        throw new TypeError('columns must be a positive integer');
      }

      let matrix = new Matrix(this.rows * rows, this.columns * columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          matrix.setSubMatrix(this, this.rows * i, this.columns * j);
        }
      }

      return matrix;
    }

    fill(value) {
      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, value);
        }
      }

      return this;
    }

    neg() {
      return this.mulS(-1);
    }

    getRow(index) {
      checkRowIndex(this, index);
      let row = [];

      for (let i = 0; i < this.columns; i++) {
        row.push(this.get(index, i));
      }

      return row;
    }

    getRowVector(index) {
      return Matrix.rowVector(this.getRow(index));
    }

    setRow(index, array) {
      checkRowIndex(this, index);
      array = checkRowVector(this, array);

      for (let i = 0; i < this.columns; i++) {
        this.set(index, i, array[i]);
      }

      return this;
    }

    swapRows(row1, row2) {
      checkRowIndex(this, row1);
      checkRowIndex(this, row2);

      for (let i = 0; i < this.columns; i++) {
        let temp = this.get(row1, i);
        this.set(row1, i, this.get(row2, i));
        this.set(row2, i, temp);
      }

      return this;
    }

    getColumn(index) {
      checkColumnIndex(this, index);
      let column = [];

      for (let i = 0; i < this.rows; i++) {
        column.push(this.get(i, index));
      }

      return column;
    }

    getColumnVector(index) {
      return Matrix.columnVector(this.getColumn(index));
    }

    setColumn(index, array) {
      checkColumnIndex(this, index);
      array = checkColumnVector(this, array);

      for (let i = 0; i < this.rows; i++) {
        this.set(i, index, array[i]);
      }

      return this;
    }

    swapColumns(column1, column2) {
      checkColumnIndex(this, column1);
      checkColumnIndex(this, column2);

      for (let i = 0; i < this.rows; i++) {
        let temp = this.get(i, column1);
        this.set(i, column1, this.get(i, column2));
        this.set(i, column2, temp);
      }

      return this;
    }

    addRowVector(vector) {
      vector = checkRowVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) + vector[j]);
        }
      }

      return this;
    }

    subRowVector(vector) {
      vector = checkRowVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) - vector[j]);
        }
      }

      return this;
    }

    mulRowVector(vector) {
      vector = checkRowVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) * vector[j]);
        }
      }

      return this;
    }

    divRowVector(vector) {
      vector = checkRowVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) / vector[j]);
        }
      }

      return this;
    }

    addColumnVector(vector) {
      vector = checkColumnVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) + vector[i]);
        }
      }

      return this;
    }

    subColumnVector(vector) {
      vector = checkColumnVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) - vector[i]);
        }
      }

      return this;
    }

    mulColumnVector(vector) {
      vector = checkColumnVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) * vector[i]);
        }
      }

      return this;
    }

    divColumnVector(vector) {
      vector = checkColumnVector(this, vector);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          this.set(i, j, this.get(i, j) / vector[i]);
        }
      }

      return this;
    }

    mulRow(index, value) {
      checkRowIndex(this, index);

      for (let i = 0; i < this.columns; i++) {
        this.set(index, i, this.get(index, i) * value);
      }

      return this;
    }

    mulColumn(index, value) {
      checkColumnIndex(this, index);

      for (let i = 0; i < this.rows; i++) {
        this.set(i, index, this.get(i, index) * value);
      }

      return this;
    }

    max() {
      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(0, 0);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          if (this.get(i, j) > v) {
            v = this.get(i, j);
          }
        }
      }

      return v;
    }

    maxIndex() {
      checkNonEmpty(this);
      let v = this.get(0, 0);
      let idx = [0, 0];

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          if (this.get(i, j) > v) {
            v = this.get(i, j);
            idx[0] = i;
            idx[1] = j;
          }
        }
      }

      return idx;
    }

    min() {
      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(0, 0);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          if (this.get(i, j) < v) {
            v = this.get(i, j);
          }
        }
      }

      return v;
    }

    minIndex() {
      checkNonEmpty(this);
      let v = this.get(0, 0);
      let idx = [0, 0];

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          if (this.get(i, j) < v) {
            v = this.get(i, j);
            idx[0] = i;
            idx[1] = j;
          }
        }
      }

      return idx;
    }

    maxRow(row) {
      checkRowIndex(this, row);

      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(row, 0);

      for (let i = 1; i < this.columns; i++) {
        if (this.get(row, i) > v) {
          v = this.get(row, i);
        }
      }

      return v;
    }

    maxRowIndex(row) {
      checkRowIndex(this, row);
      checkNonEmpty(this);
      let v = this.get(row, 0);
      let idx = [row, 0];

      for (let i = 1; i < this.columns; i++) {
        if (this.get(row, i) > v) {
          v = this.get(row, i);
          idx[1] = i;
        }
      }

      return idx;
    }

    minRow(row) {
      checkRowIndex(this, row);

      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(row, 0);

      for (let i = 1; i < this.columns; i++) {
        if (this.get(row, i) < v) {
          v = this.get(row, i);
        }
      }

      return v;
    }

    minRowIndex(row) {
      checkRowIndex(this, row);
      checkNonEmpty(this);
      let v = this.get(row, 0);
      let idx = [row, 0];

      for (let i = 1; i < this.columns; i++) {
        if (this.get(row, i) < v) {
          v = this.get(row, i);
          idx[1] = i;
        }
      }

      return idx;
    }

    maxColumn(column) {
      checkColumnIndex(this, column);

      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(0, column);

      for (let i = 1; i < this.rows; i++) {
        if (this.get(i, column) > v) {
          v = this.get(i, column);
        }
      }

      return v;
    }

    maxColumnIndex(column) {
      checkColumnIndex(this, column);
      checkNonEmpty(this);
      let v = this.get(0, column);
      let idx = [0, column];

      for (let i = 1; i < this.rows; i++) {
        if (this.get(i, column) > v) {
          v = this.get(i, column);
          idx[0] = i;
        }
      }

      return idx;
    }

    minColumn(column) {
      checkColumnIndex(this, column);

      if (this.isEmpty()) {
        return NaN;
      }

      let v = this.get(0, column);

      for (let i = 1; i < this.rows; i++) {
        if (this.get(i, column) < v) {
          v = this.get(i, column);
        }
      }

      return v;
    }

    minColumnIndex(column) {
      checkColumnIndex(this, column);
      checkNonEmpty(this);
      let v = this.get(0, column);
      let idx = [0, column];

      for (let i = 1; i < this.rows; i++) {
        if (this.get(i, column) < v) {
          v = this.get(i, column);
          idx[0] = i;
        }
      }

      return idx;
    }

    diag() {
      let min = Math.min(this.rows, this.columns);
      let diag = [];

      for (let i = 0; i < min; i++) {
        diag.push(this.get(i, i));
      }

      return diag;
    }

    norm(type = 'frobenius') {
      let result = 0;

      if (type === 'max') {
        return this.max();
      } else if (type === 'frobenius') {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            result = result + this.get(i, j) * this.get(i, j);
          }
        }

        return Math.sqrt(result);
      } else {
        throw new RangeError(`unknown norm type: ${type}`);
      }
    }

    cumulativeSum() {
      let sum = 0;

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          sum += this.get(i, j);
          this.set(i, j, sum);
        }
      }

      return this;
    }

    dot(vector2) {
      if (AbstractMatrix.isMatrix(vector2)) vector2 = vector2.to1DArray();
      let vector1 = this.to1DArray();

      if (vector1.length !== vector2.length) {
        throw new RangeError('vectors do not have the same size');
      }

      let dot = 0;

      for (let i = 0; i < vector1.length; i++) {
        dot += vector1[i] * vector2[i];
      }

      return dot;
    }

    mmul(other) {
      other = Matrix.checkMatrix(other);
      let m = this.rows;
      let n = this.columns;
      let p = other.columns;
      let result = new Matrix(m, p);
      let Bcolj = new Float64Array(n);

      for (let j = 0; j < p; j++) {
        for (let k = 0; k < n; k++) {
          Bcolj[k] = other.get(k, j);
        }

        for (let i = 0; i < m; i++) {
          let s = 0;

          for (let k = 0; k < n; k++) {
            s += this.get(i, k) * Bcolj[k];
          }

          result.set(i, j, s);
        }
      }

      return result;
    }

    strassen2x2(other) {
      other = Matrix.checkMatrix(other);
      let result = new Matrix(2, 2);
      const a11 = this.get(0, 0);
      const b11 = other.get(0, 0);
      const a12 = this.get(0, 1);
      const b12 = other.get(0, 1);
      const a21 = this.get(1, 0);
      const b21 = other.get(1, 0);
      const a22 = this.get(1, 1);
      const b22 = other.get(1, 1); // Compute intermediate values.

      const m1 = (a11 + a22) * (b11 + b22);
      const m2 = (a21 + a22) * b11;
      const m3 = a11 * (b12 - b22);
      const m4 = a22 * (b21 - b11);
      const m5 = (a11 + a12) * b22;
      const m6 = (a21 - a11) * (b11 + b12);
      const m7 = (a12 - a22) * (b21 + b22); // Combine intermediate values into the output.

      const c00 = m1 + m4 - m5 + m7;
      const c01 = m3 + m5;
      const c10 = m2 + m4;
      const c11 = m1 - m2 + m3 + m6;
      result.set(0, 0, c00);
      result.set(0, 1, c01);
      result.set(1, 0, c10);
      result.set(1, 1, c11);
      return result;
    }

    strassen3x3(other) {
      other = Matrix.checkMatrix(other);
      let result = new Matrix(3, 3);
      const a00 = this.get(0, 0);
      const a01 = this.get(0, 1);
      const a02 = this.get(0, 2);
      const a10 = this.get(1, 0);
      const a11 = this.get(1, 1);
      const a12 = this.get(1, 2);
      const a20 = this.get(2, 0);
      const a21 = this.get(2, 1);
      const a22 = this.get(2, 2);
      const b00 = other.get(0, 0);
      const b01 = other.get(0, 1);
      const b02 = other.get(0, 2);
      const b10 = other.get(1, 0);
      const b11 = other.get(1, 1);
      const b12 = other.get(1, 2);
      const b20 = other.get(2, 0);
      const b21 = other.get(2, 1);
      const b22 = other.get(2, 2);
      const m1 = (a00 + a01 + a02 - a10 - a11 - a21 - a22) * b11;
      const m2 = (a00 - a10) * (-b01 + b11);
      const m3 = a11 * (-b00 + b01 + b10 - b11 - b12 - b20 + b22);
      const m4 = (-a00 + a10 + a11) * (b00 - b01 + b11);
      const m5 = (a10 + a11) * (-b00 + b01);
      const m6 = a00 * b00;
      const m7 = (-a00 + a20 + a21) * (b00 - b02 + b12);
      const m8 = (-a00 + a20) * (b02 - b12);
      const m9 = (a20 + a21) * (-b00 + b02);
      const m10 = (a00 + a01 + a02 - a11 - a12 - a20 - a21) * b12;
      const m11 = a21 * (-b00 + b02 + b10 - b11 - b12 - b20 + b21);
      const m12 = (-a02 + a21 + a22) * (b11 + b20 - b21);
      const m13 = (a02 - a22) * (b11 - b21);
      const m14 = a02 * b20;
      const m15 = (a21 + a22) * (-b20 + b21);
      const m16 = (-a02 + a11 + a12) * (b12 + b20 - b22);
      const m17 = (a02 - a12) * (b12 - b22);
      const m18 = (a11 + a12) * (-b20 + b22);
      const m19 = a01 * b10;
      const m20 = a12 * b21;
      const m21 = a10 * b02;
      const m22 = a20 * b01;
      const m23 = a22 * b22;
      const c00 = m6 + m14 + m19;
      const c01 = m1 + m4 + m5 + m6 + m12 + m14 + m15;
      const c02 = m6 + m7 + m9 + m10 + m14 + m16 + m18;
      const c10 = m2 + m3 + m4 + m6 + m14 + m16 + m17;
      const c11 = m2 + m4 + m5 + m6 + m20;
      const c12 = m14 + m16 + m17 + m18 + m21;
      const c20 = m6 + m7 + m8 + m11 + m12 + m13 + m14;
      const c21 = m12 + m13 + m14 + m15 + m22;
      const c22 = m6 + m7 + m8 + m9 + m23;
      result.set(0, 0, c00);
      result.set(0, 1, c01);
      result.set(0, 2, c02);
      result.set(1, 0, c10);
      result.set(1, 1, c11);
      result.set(1, 2, c12);
      result.set(2, 0, c20);
      result.set(2, 1, c21);
      result.set(2, 2, c22);
      return result;
    }

    mmulStrassen(y) {
      y = Matrix.checkMatrix(y);
      let x = this.clone();
      let r1 = x.rows;
      let c1 = x.columns;
      let r2 = y.rows;
      let c2 = y.columns;

      if (c1 !== r2) {
        // eslint-disable-next-line no-console
        console.warn(`Multiplying ${r1} x ${c1} and ${r2} x ${c2} matrix: dimensions do not match.`);
      } // Put a matrix into the top left of a matrix of zeros.
      // `rows` and `cols` are the dimensions of the output matrix.


      function embed(mat, rows, cols) {
        let r = mat.rows;
        let c = mat.columns;

        if (r === rows && c === cols) {
          return mat;
        } else {
          let resultat = AbstractMatrix.zeros(rows, cols);
          resultat = resultat.setSubMatrix(mat, 0, 0);
          return resultat;
        }
      } // Make sure both matrices are the same size.
      // This is exclusively for simplicity:
      // this algorithm can be implemented with matrices of different sizes.


      let r = Math.max(r1, r2);
      let c = Math.max(c1, c2);
      x = embed(x, r, c);
      y = embed(y, r, c); // Our recursive multiplication function.

      function blockMult(a, b, rows, cols) {
        // For small matrices, resort to naive multiplication.
        if (rows <= 512 || cols <= 512) {
          return a.mmul(b); // a is equivalent to this
        } // Apply dynamic padding.


        if (rows % 2 === 1 && cols % 2 === 1) {
          a = embed(a, rows + 1, cols + 1);
          b = embed(b, rows + 1, cols + 1);
        } else if (rows % 2 === 1) {
          a = embed(a, rows + 1, cols);
          b = embed(b, rows + 1, cols);
        } else if (cols % 2 === 1) {
          a = embed(a, rows, cols + 1);
          b = embed(b, rows, cols + 1);
        }

        let halfRows = parseInt(a.rows / 2, 10);
        let halfCols = parseInt(a.columns / 2, 10); // Subdivide input matrices.

        let a11 = a.subMatrix(0, halfRows - 1, 0, halfCols - 1);
        let b11 = b.subMatrix(0, halfRows - 1, 0, halfCols - 1);
        let a12 = a.subMatrix(0, halfRows - 1, halfCols, a.columns - 1);
        let b12 = b.subMatrix(0, halfRows - 1, halfCols, b.columns - 1);
        let a21 = a.subMatrix(halfRows, a.rows - 1, 0, halfCols - 1);
        let b21 = b.subMatrix(halfRows, b.rows - 1, 0, halfCols - 1);
        let a22 = a.subMatrix(halfRows, a.rows - 1, halfCols, a.columns - 1);
        let b22 = b.subMatrix(halfRows, b.rows - 1, halfCols, b.columns - 1); // Compute intermediate values.

        let m1 = blockMult(AbstractMatrix.add(a11, a22), AbstractMatrix.add(b11, b22), halfRows, halfCols);
        let m2 = blockMult(AbstractMatrix.add(a21, a22), b11, halfRows, halfCols);
        let m3 = blockMult(a11, AbstractMatrix.sub(b12, b22), halfRows, halfCols);
        let m4 = blockMult(a22, AbstractMatrix.sub(b21, b11), halfRows, halfCols);
        let m5 = blockMult(AbstractMatrix.add(a11, a12), b22, halfRows, halfCols);
        let m6 = blockMult(AbstractMatrix.sub(a21, a11), AbstractMatrix.add(b11, b12), halfRows, halfCols);
        let m7 = blockMult(AbstractMatrix.sub(a12, a22), AbstractMatrix.add(b21, b22), halfRows, halfCols); // Combine intermediate values into the output.

        let c11 = AbstractMatrix.add(m1, m4);
        c11.sub(m5);
        c11.add(m7);
        let c12 = AbstractMatrix.add(m3, m5);
        let c21 = AbstractMatrix.add(m2, m4);
        let c22 = AbstractMatrix.sub(m1, m2);
        c22.add(m3);
        c22.add(m6); // Crop output to the desired size (undo dynamic padding).

        let resultat = AbstractMatrix.zeros(2 * c11.rows, 2 * c11.columns);
        resultat = resultat.setSubMatrix(c11, 0, 0);
        resultat = resultat.setSubMatrix(c12, c11.rows, 0);
        resultat = resultat.setSubMatrix(c21, 0, c11.columns);
        resultat = resultat.setSubMatrix(c22, c11.rows, c11.columns);
        return resultat.subMatrix(0, rows - 1, 0, cols - 1);
      }

      return blockMult(x, y, r, c);
    }

    scaleRows(options = {}) {
      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        min = 0,
        max = 1
      } = options;
      if (!Number.isFinite(min)) throw new TypeError('min must be a number');
      if (!Number.isFinite(max)) throw new TypeError('max must be a number');
      if (min >= max) throw new RangeError('min must be smaller than max');
      let newMatrix = new Matrix(this.rows, this.columns);

      for (let i = 0; i < this.rows; i++) {
        const row = this.getRow(i);

        if (row.length > 0) {
          rescale(row, {
            min,
            max,
            output: row
          });
        }

        newMatrix.setRow(i, row);
      }

      return newMatrix;
    }

    scaleColumns(options = {}) {
      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        min = 0,
        max = 1
      } = options;
      if (!Number.isFinite(min)) throw new TypeError('min must be a number');
      if (!Number.isFinite(max)) throw new TypeError('max must be a number');
      if (min >= max) throw new RangeError('min must be smaller than max');
      let newMatrix = new Matrix(this.rows, this.columns);

      for (let i = 0; i < this.columns; i++) {
        const column = this.getColumn(i);

        if (column.length) {
          rescale(column, {
            min: min,
            max: max,
            output: column
          });
        }

        newMatrix.setColumn(i, column);
      }

      return newMatrix;
    }

    flipRows() {
      const middle = Math.ceil(this.columns / 2);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < middle; j++) {
          let first = this.get(i, j);
          let last = this.get(i, this.columns - 1 - j);
          this.set(i, j, last);
          this.set(i, this.columns - 1 - j, first);
        }
      }

      return this;
    }

    flipColumns() {
      const middle = Math.ceil(this.rows / 2);

      for (let j = 0; j < this.columns; j++) {
        for (let i = 0; i < middle; i++) {
          let first = this.get(i, j);
          let last = this.get(this.rows - 1 - i, j);
          this.set(i, j, last);
          this.set(this.rows - 1 - i, j, first);
        }
      }

      return this;
    }

    kroneckerProduct(other) {
      other = Matrix.checkMatrix(other);
      let m = this.rows;
      let n = this.columns;
      let p = other.rows;
      let q = other.columns;
      let result = new Matrix(m * p, n * q);

      for (let i = 0; i < m; i++) {
        for (let j = 0; j < n; j++) {
          for (let k = 0; k < p; k++) {
            for (let l = 0; l < q; l++) {
              result.set(p * i + k, q * j + l, this.get(i, j) * other.get(k, l));
            }
          }
        }
      }

      return result;
    }

    kroneckerSum(other) {
      other = Matrix.checkMatrix(other);

      if (!this.isSquare() || !other.isSquare()) {
        throw new Error('Kronecker Sum needs two Square Matrices');
      }

      let m = this.rows;
      let n = other.rows;
      let AxI = this.kroneckerProduct(Matrix.eye(n, n));
      let IxB = Matrix.eye(m, m).kroneckerProduct(other);
      return AxI.add(IxB);
    }

    transpose() {
      let result = new Matrix(this.columns, this.rows);

      for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.columns; j++) {
          result.set(j, i, this.get(i, j));
        }
      }

      return result;
    }

    sortRows(compareFunction = compareNumbers) {
      for (let i = 0; i < this.rows; i++) {
        this.setRow(i, this.getRow(i).sort(compareFunction));
      }

      return this;
    }

    sortColumns(compareFunction = compareNumbers) {
      for (let i = 0; i < this.columns; i++) {
        this.setColumn(i, this.getColumn(i).sort(compareFunction));
      }

      return this;
    }

    subMatrix(startRow, endRow, startColumn, endColumn) {
      checkRange(this, startRow, endRow, startColumn, endColumn);
      let newMatrix = new Matrix(endRow - startRow + 1, endColumn - startColumn + 1);

      for (let i = startRow; i <= endRow; i++) {
        for (let j = startColumn; j <= endColumn; j++) {
          newMatrix.set(i - startRow, j - startColumn, this.get(i, j));
        }
      }

      return newMatrix;
    }

    subMatrixRow(indices, startColumn, endColumn) {
      if (startColumn === undefined) startColumn = 0;
      if (endColumn === undefined) endColumn = this.columns - 1;

      if (startColumn > endColumn || startColumn < 0 || startColumn >= this.columns || endColumn < 0 || endColumn >= this.columns) {
        throw new RangeError('Argument out of range');
      }

      let newMatrix = new Matrix(indices.length, endColumn - startColumn + 1);

      for (let i = 0; i < indices.length; i++) {
        for (let j = startColumn; j <= endColumn; j++) {
          if (indices[i] < 0 || indices[i] >= this.rows) {
            throw new RangeError(`Row index out of range: ${indices[i]}`);
          }

          newMatrix.set(i, j - startColumn, this.get(indices[i], j));
        }
      }

      return newMatrix;
    }

    subMatrixColumn(indices, startRow, endRow) {
      if (startRow === undefined) startRow = 0;
      if (endRow === undefined) endRow = this.rows - 1;

      if (startRow > endRow || startRow < 0 || startRow >= this.rows || endRow < 0 || endRow >= this.rows) {
        throw new RangeError('Argument out of range');
      }

      let newMatrix = new Matrix(endRow - startRow + 1, indices.length);

      for (let i = 0; i < indices.length; i++) {
        for (let j = startRow; j <= endRow; j++) {
          if (indices[i] < 0 || indices[i] >= this.columns) {
            throw new RangeError(`Column index out of range: ${indices[i]}`);
          }

          newMatrix.set(j - startRow, i, this.get(j, indices[i]));
        }
      }

      return newMatrix;
    }

    setSubMatrix(matrix, startRow, startColumn) {
      matrix = Matrix.checkMatrix(matrix);

      if (matrix.isEmpty()) {
        return this;
      }

      let endRow = startRow + matrix.rows - 1;
      let endColumn = startColumn + matrix.columns - 1;
      checkRange(this, startRow, endRow, startColumn, endColumn);

      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          this.set(startRow + i, startColumn + j, matrix.get(i, j));
        }
      }

      return this;
    }

    selection(rowIndices, columnIndices) {
      let indices = checkIndices(this, rowIndices, columnIndices);
      let newMatrix = new Matrix(rowIndices.length, columnIndices.length);

      for (let i = 0; i < indices.row.length; i++) {
        let rowIndex = indices.row[i];

        for (let j = 0; j < indices.column.length; j++) {
          let columnIndex = indices.column[j];
          newMatrix.set(i, j, this.get(rowIndex, columnIndex));
        }
      }

      return newMatrix;
    }

    trace() {
      let min = Math.min(this.rows, this.columns);
      let trace = 0;

      for (let i = 0; i < min; i++) {
        trace += this.get(i, i);
      }

      return trace;
    }

    clone() {
      let newMatrix = new Matrix(this.rows, this.columns);

      for (let row = 0; row < this.rows; row++) {
        for (let column = 0; column < this.columns; column++) {
          newMatrix.set(row, column, this.get(row, column));
        }
      }

      return newMatrix;
    }

    sum(by) {
      switch (by) {
        case 'row':
          return sumByRow(this);

        case 'column':
          return sumByColumn(this);

        case undefined:
          return sumAll(this);

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    product(by) {
      switch (by) {
        case 'row':
          return productByRow(this);

        case 'column':
          return productByColumn(this);

        case undefined:
          return productAll(this);

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    mean(by) {
      const sum = this.sum(by);

      switch (by) {
        case 'row':
          {
            for (let i = 0; i < this.rows; i++) {
              sum[i] /= this.columns;
            }

            return sum;
          }

        case 'column':
          {
            for (let i = 0; i < this.columns; i++) {
              sum[i] /= this.rows;
            }

            return sum;
          }

        case undefined:
          return sum / this.size;

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    variance(by, options = {}) {
      if (typeof by === 'object') {
        options = by;
        by = undefined;
      }

      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        unbiased = true,
        mean = this.mean(by)
      } = options;

      if (typeof unbiased !== 'boolean') {
        throw new TypeError('unbiased must be a boolean');
      }

      switch (by) {
        case 'row':
          {
            if (!Array.isArray(mean)) {
              throw new TypeError('mean must be an array');
            }

            return varianceByRow(this, unbiased, mean);
          }

        case 'column':
          {
            if (!Array.isArray(mean)) {
              throw new TypeError('mean must be an array');
            }

            return varianceByColumn(this, unbiased, mean);
          }

        case undefined:
          {
            if (typeof mean !== 'number') {
              throw new TypeError('mean must be a number');
            }

            return varianceAll(this, unbiased, mean);
          }

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    standardDeviation(by, options) {
      if (typeof by === 'object') {
        options = by;
        by = undefined;
      }

      const variance = this.variance(by, options);

      if (by === undefined) {
        return Math.sqrt(variance);
      } else {
        for (let i = 0; i < variance.length; i++) {
          variance[i] = Math.sqrt(variance[i]);
        }

        return variance;
      }
    }

    center(by, options = {}) {
      if (typeof by === 'object') {
        options = by;
        by = undefined;
      }

      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      const {
        center = this.mean(by)
      } = options;

      switch (by) {
        case 'row':
          {
            if (!Array.isArray(center)) {
              throw new TypeError('center must be an array');
            }

            centerByRow(this, center);
            return this;
          }

        case 'column':
          {
            if (!Array.isArray(center)) {
              throw new TypeError('center must be an array');
            }

            centerByColumn(this, center);
            return this;
          }

        case undefined:
          {
            if (typeof center !== 'number') {
              throw new TypeError('center must be a number');
            }

            centerAll(this, center);
            return this;
          }

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    scale(by, options = {}) {
      if (typeof by === 'object') {
        options = by;
        by = undefined;
      }

      if (typeof options !== 'object') {
        throw new TypeError('options must be an object');
      }

      let scale = options.scale;

      switch (by) {
        case 'row':
          {
            if (scale === undefined) {
              scale = getScaleByRow(this);
            } else if (!Array.isArray(scale)) {
              throw new TypeError('scale must be an array');
            }

            scaleByRow(this, scale);
            return this;
          }

        case 'column':
          {
            if (scale === undefined) {
              scale = getScaleByColumn(this);
            } else if (!Array.isArray(scale)) {
              throw new TypeError('scale must be an array');
            }

            scaleByColumn(this, scale);
            return this;
          }

        case undefined:
          {
            if (scale === undefined) {
              scale = getScaleAll(this);
            } else if (typeof scale !== 'number') {
              throw new TypeError('scale must be a number');
            }

            scaleAll(this, scale);
            return this;
          }

        default:
          throw new Error(`invalid option: ${by}`);
      }
    }

    toString(options) {
      return inspectMatrixWithOptions(this, options);
    }

  }
  AbstractMatrix.prototype.klass = 'Matrix';

  if (typeof Symbol !== 'undefined') {
    AbstractMatrix.prototype[Symbol.for('nodejs.util.inspect.custom')] = inspectMatrix;
  }

  function compareNumbers(a, b) {
    return a - b;
  } // Synonyms


  AbstractMatrix.random = AbstractMatrix.rand;
  AbstractMatrix.randomInt = AbstractMatrix.randInt;
  AbstractMatrix.diagonal = AbstractMatrix.diag;
  AbstractMatrix.prototype.diagonal = AbstractMatrix.prototype.diag;
  AbstractMatrix.identity = AbstractMatrix.eye;
  AbstractMatrix.prototype.negate = AbstractMatrix.prototype.neg;
  AbstractMatrix.prototype.tensorProduct = AbstractMatrix.prototype.kroneckerProduct;
  class Matrix extends AbstractMatrix {
    constructor(nRows, nColumns) {
      super();

      if (Matrix.isMatrix(nRows)) {
        // eslint-disable-next-line no-constructor-return
        return nRows.clone();
      } else if (Number.isInteger(nRows) && nRows >= 0) {
        // Create an empty matrix
        this.data = [];

        if (Number.isInteger(nColumns) && nColumns >= 0) {
          for (let i = 0; i < nRows; i++) {
            this.data.push(new Float64Array(nColumns));
          }
        } else {
          throw new TypeError('nColumns must be a positive integer');
        }
      } else if (Array.isArray(nRows)) {
        // Copy the values from the 2D array
        const arrayData = nRows;
        nRows = arrayData.length;
        nColumns = nRows ? arrayData[0].length : 0;

        if (typeof nColumns !== 'number') {
          throw new TypeError('Data must be a 2D array with at least one element');
        }

        this.data = [];

        for (let i = 0; i < nRows; i++) {
          if (arrayData[i].length !== nColumns) {
            throw new RangeError('Inconsistent array dimensions');
          }

          this.data.push(Float64Array.from(arrayData[i]));
        }
      } else {
        throw new TypeError('First argument must be a positive number or an array');
      }

      this.rows = nRows;
      this.columns = nColumns;
    }

    set(rowIndex, columnIndex, value) {
      this.data[rowIndex][columnIndex] = value;
      return this;
    }

    get(rowIndex, columnIndex) {
      return this.data[rowIndex][columnIndex];
    }

    removeRow(index) {
      checkRowIndex(this, index);
      this.data.splice(index, 1);
      this.rows -= 1;
      return this;
    }

    addRow(index, array) {
      if (array === undefined) {
        array = index;
        index = this.rows;
      }

      checkRowIndex(this, index, true);
      array = Float64Array.from(checkRowVector(this, array));
      this.data.splice(index, 0, array);
      this.rows += 1;
      return this;
    }

    removeColumn(index) {
      checkColumnIndex(this, index);

      for (let i = 0; i < this.rows; i++) {
        const newRow = new Float64Array(this.columns - 1);

        for (let j = 0; j < index; j++) {
          newRow[j] = this.data[i][j];
        }

        for (let j = index + 1; j < this.columns; j++) {
          newRow[j - 1] = this.data[i][j];
        }

        this.data[i] = newRow;
      }

      this.columns -= 1;
      return this;
    }

    addColumn(index, array) {
      if (typeof array === 'undefined') {
        array = index;
        index = this.columns;
      }

      checkColumnIndex(this, index, true);
      array = checkColumnVector(this, array);

      for (let i = 0; i < this.rows; i++) {
        const newRow = new Float64Array(this.columns + 1);
        let j = 0;

        for (; j < index; j++) {
          newRow[j] = this.data[i][j];
        }

        newRow[j++] = array[i];

        for (; j < this.columns + 1; j++) {
          newRow[j] = this.data[i][j - 1];
        }

        this.data[i] = newRow;
      }

      this.columns += 1;
      return this;
    }

  }
  installMathOperations(AbstractMatrix, Matrix);

  class WrapperMatrix2D extends AbstractMatrix {
    constructor(data) {
      super();
      this.data = data;
      this.rows = data.length;
      this.columns = data[0].length;
    }

    set(rowIndex, columnIndex, value) {
      this.data[rowIndex][columnIndex] = value;
      return this;
    }

    get(rowIndex, columnIndex) {
      return this.data[rowIndex][columnIndex];
    }

  }

  class LuDecomposition {
    constructor(matrix) {
      matrix = WrapperMatrix2D.checkMatrix(matrix);
      let lu = matrix.clone();
      let rows = lu.rows;
      let columns = lu.columns;
      let pivotVector = new Float64Array(rows);
      let pivotSign = 1;
      let i, j, k, p, s, t, v;
      let LUcolj, kmax;

      for (i = 0; i < rows; i++) {
        pivotVector[i] = i;
      }

      LUcolj = new Float64Array(rows);

      for (j = 0; j < columns; j++) {
        for (i = 0; i < rows; i++) {
          LUcolj[i] = lu.get(i, j);
        }

        for (i = 0; i < rows; i++) {
          kmax = Math.min(i, j);
          s = 0;

          for (k = 0; k < kmax; k++) {
            s += lu.get(i, k) * LUcolj[k];
          }

          LUcolj[i] -= s;
          lu.set(i, j, LUcolj[i]);
        }

        p = j;

        for (i = j + 1; i < rows; i++) {
          if (Math.abs(LUcolj[i]) > Math.abs(LUcolj[p])) {
            p = i;
          }
        }

        if (p !== j) {
          for (k = 0; k < columns; k++) {
            t = lu.get(p, k);
            lu.set(p, k, lu.get(j, k));
            lu.set(j, k, t);
          }

          v = pivotVector[p];
          pivotVector[p] = pivotVector[j];
          pivotVector[j] = v;
          pivotSign = -pivotSign;
        }

        if (j < rows && lu.get(j, j) !== 0) {
          for (i = j + 1; i < rows; i++) {
            lu.set(i, j, lu.get(i, j) / lu.get(j, j));
          }
        }
      }

      this.LU = lu;
      this.pivotVector = pivotVector;
      this.pivotSign = pivotSign;
    }

    isSingular() {
      let data = this.LU;
      let col = data.columns;

      for (let j = 0; j < col; j++) {
        if (data.get(j, j) === 0) {
          return true;
        }
      }

      return false;
    }

    solve(value) {
      value = Matrix.checkMatrix(value);
      let lu = this.LU;
      let rows = lu.rows;

      if (rows !== value.rows) {
        throw new Error('Invalid matrix dimensions');
      }

      if (this.isSingular()) {
        throw new Error('LU matrix is singular');
      }

      let count = value.columns;
      let X = value.subMatrixRow(this.pivotVector, 0, count - 1);
      let columns = lu.columns;
      let i, j, k;

      for (k = 0; k < columns; k++) {
        for (i = k + 1; i < columns; i++) {
          for (j = 0; j < count; j++) {
            X.set(i, j, X.get(i, j) - X.get(k, j) * lu.get(i, k));
          }
        }
      }

      for (k = columns - 1; k >= 0; k--) {
        for (j = 0; j < count; j++) {
          X.set(k, j, X.get(k, j) / lu.get(k, k));
        }

        for (i = 0; i < k; i++) {
          for (j = 0; j < count; j++) {
            X.set(i, j, X.get(i, j) - X.get(k, j) * lu.get(i, k));
          }
        }
      }

      return X;
    }

    get determinant() {
      let data = this.LU;

      if (!data.isSquare()) {
        throw new Error('Matrix must be square');
      }

      let determinant = this.pivotSign;
      let col = data.columns;

      for (let j = 0; j < col; j++) {
        determinant *= data.get(j, j);
      }

      return determinant;
    }

    get lowerTriangularMatrix() {
      let data = this.LU;
      let rows = data.rows;
      let columns = data.columns;
      let X = new Matrix(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          if (i > j) {
            X.set(i, j, data.get(i, j));
          } else if (i === j) {
            X.set(i, j, 1);
          } else {
            X.set(i, j, 0);
          }
        }
      }

      return X;
    }

    get upperTriangularMatrix() {
      let data = this.LU;
      let rows = data.rows;
      let columns = data.columns;
      let X = new Matrix(rows, columns);

      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < columns; j++) {
          if (i <= j) {
            X.set(i, j, data.get(i, j));
          } else {
            X.set(i, j, 0);
          }
        }
      }

      return X;
    }

    get pivotPermutationVector() {
      return Array.from(this.pivotVector);
    }

  }

  function hypotenuse(a, b) {
    let r = 0;

    if (Math.abs(a) > Math.abs(b)) {
      r = b / a;
      return Math.abs(a) * Math.sqrt(1 + r * r);
    }

    if (b !== 0) {
      r = a / b;
      return Math.abs(b) * Math.sqrt(1 + r * r);
    }

    return 0;
  }

  class QrDecomposition {
    constructor(value) {
      value = WrapperMatrix2D.checkMatrix(value);
      let qr = value.clone();
      let m = value.rows;
      let n = value.columns;
      let rdiag = new Float64Array(n);
      let i, j, k, s;

      for (k = 0; k < n; k++) {
        let nrm = 0;

        for (i = k; i < m; i++) {
          nrm = hypotenuse(nrm, qr.get(i, k));
        }

        if (nrm !== 0) {
          if (qr.get(k, k) < 0) {
            nrm = -nrm;
          }

          for (i = k; i < m; i++) {
            qr.set(i, k, qr.get(i, k) / nrm);
          }

          qr.set(k, k, qr.get(k, k) + 1);

          for (j = k + 1; j < n; j++) {
            s = 0;

            for (i = k; i < m; i++) {
              s += qr.get(i, k) * qr.get(i, j);
            }

            s = -s / qr.get(k, k);

            for (i = k; i < m; i++) {
              qr.set(i, j, qr.get(i, j) + s * qr.get(i, k));
            }
          }
        }

        rdiag[k] = -nrm;
      }

      this.QR = qr;
      this.Rdiag = rdiag;
    }

    solve(value) {
      value = Matrix.checkMatrix(value);
      let qr = this.QR;
      let m = qr.rows;

      if (value.rows !== m) {
        throw new Error('Matrix row dimensions must agree');
      }

      if (!this.isFullRank()) {
        throw new Error('Matrix is rank deficient');
      }

      let count = value.columns;
      let X = value.clone();
      let n = qr.columns;
      let i, j, k, s;

      for (k = 0; k < n; k++) {
        for (j = 0; j < count; j++) {
          s = 0;

          for (i = k; i < m; i++) {
            s += qr.get(i, k) * X.get(i, j);
          }

          s = -s / qr.get(k, k);

          for (i = k; i < m; i++) {
            X.set(i, j, X.get(i, j) + s * qr.get(i, k));
          }
        }
      }

      for (k = n - 1; k >= 0; k--) {
        for (j = 0; j < count; j++) {
          X.set(k, j, X.get(k, j) / this.Rdiag[k]);
        }

        for (i = 0; i < k; i++) {
          for (j = 0; j < count; j++) {
            X.set(i, j, X.get(i, j) - X.get(k, j) * qr.get(i, k));
          }
        }
      }

      return X.subMatrix(0, n - 1, 0, count - 1);
    }

    isFullRank() {
      let columns = this.QR.columns;

      for (let i = 0; i < columns; i++) {
        if (this.Rdiag[i] === 0) {
          return false;
        }
      }

      return true;
    }

    get upperTriangularMatrix() {
      let qr = this.QR;
      let n = qr.columns;
      let X = new Matrix(n, n);
      let i, j;

      for (i = 0; i < n; i++) {
        for (j = 0; j < n; j++) {
          if (i < j) {
            X.set(i, j, qr.get(i, j));
          } else if (i === j) {
            X.set(i, j, this.Rdiag[i]);
          } else {
            X.set(i, j, 0);
          }
        }
      }

      return X;
    }

    get orthogonalMatrix() {
      let qr = this.QR;
      let rows = qr.rows;
      let columns = qr.columns;
      let X = new Matrix(rows, columns);
      let i, j, k, s;

      for (k = columns - 1; k >= 0; k--) {
        for (i = 0; i < rows; i++) {
          X.set(i, k, 0);
        }

        X.set(k, k, 1);

        for (j = k; j < columns; j++) {
          if (qr.get(k, k) !== 0) {
            s = 0;

            for (i = k; i < rows; i++) {
              s += qr.get(i, k) * X.get(i, j);
            }

            s = -s / qr.get(k, k);

            for (i = k; i < rows; i++) {
              X.set(i, j, X.get(i, j) + s * qr.get(i, k));
            }
          }
        }
      }

      return X;
    }

  }

  class SingularValueDecomposition {
    constructor(value, options = {}) {
      value = WrapperMatrix2D.checkMatrix(value);

      if (value.isEmpty()) {
        throw new Error('Matrix must be non-empty');
      }

      let m = value.rows;
      let n = value.columns;
      const {
        computeLeftSingularVectors = true,
        computeRightSingularVectors = true,
        autoTranspose = false
      } = options;
      let wantu = Boolean(computeLeftSingularVectors);
      let wantv = Boolean(computeRightSingularVectors);
      let swapped = false;
      let a;

      if (m < n) {
        if (!autoTranspose) {
          a = value.clone(); // eslint-disable-next-line no-console

          console.warn('Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose');
        } else {
          a = value.transpose();
          m = a.rows;
          n = a.columns;
          swapped = true;
          let aux = wantu;
          wantu = wantv;
          wantv = aux;
        }
      } else {
        a = value.clone();
      }

      let nu = Math.min(m, n);
      let ni = Math.min(m + 1, n);
      let s = new Float64Array(ni);
      let U = new Matrix(m, nu);
      let V = new Matrix(n, n);
      let e = new Float64Array(n);
      let work = new Float64Array(m);
      let si = new Float64Array(ni);

      for (let i = 0; i < ni; i++) si[i] = i;

      let nct = Math.min(m - 1, n);
      let nrt = Math.max(0, Math.min(n - 2, m));
      let mrc = Math.max(nct, nrt);

      for (let k = 0; k < mrc; k++) {
        if (k < nct) {
          s[k] = 0;

          for (let i = k; i < m; i++) {
            s[k] = hypotenuse(s[k], a.get(i, k));
          }

          if (s[k] !== 0) {
            if (a.get(k, k) < 0) {
              s[k] = -s[k];
            }

            for (let i = k; i < m; i++) {
              a.set(i, k, a.get(i, k) / s[k]);
            }

            a.set(k, k, a.get(k, k) + 1);
          }

          s[k] = -s[k];
        }

        for (let j = k + 1; j < n; j++) {
          if (k < nct && s[k] !== 0) {
            let t = 0;

            for (let i = k; i < m; i++) {
              t += a.get(i, k) * a.get(i, j);
            }

            t = -t / a.get(k, k);

            for (let i = k; i < m; i++) {
              a.set(i, j, a.get(i, j) + t * a.get(i, k));
            }
          }

          e[j] = a.get(k, j);
        }

        if (wantu && k < nct) {
          for (let i = k; i < m; i++) {
            U.set(i, k, a.get(i, k));
          }
        }

        if (k < nrt) {
          e[k] = 0;

          for (let i = k + 1; i < n; i++) {
            e[k] = hypotenuse(e[k], e[i]);
          }

          if (e[k] !== 0) {
            if (e[k + 1] < 0) {
              e[k] = 0 - e[k];
            }

            for (let i = k + 1; i < n; i++) {
              e[i] /= e[k];
            }

            e[k + 1] += 1;
          }

          e[k] = -e[k];

          if (k + 1 < m && e[k] !== 0) {
            for (let i = k + 1; i < m; i++) {
              work[i] = 0;
            }

            for (let i = k + 1; i < m; i++) {
              for (let j = k + 1; j < n; j++) {
                work[i] += e[j] * a.get(i, j);
              }
            }

            for (let j = k + 1; j < n; j++) {
              let t = -e[j] / e[k + 1];

              for (let i = k + 1; i < m; i++) {
                a.set(i, j, a.get(i, j) + t * work[i]);
              }
            }
          }

          if (wantv) {
            for (let i = k + 1; i < n; i++) {
              V.set(i, k, e[i]);
            }
          }
        }
      }

      let p = Math.min(n, m + 1);

      if (nct < n) {
        s[nct] = a.get(nct, nct);
      }

      if (m < p) {
        s[p - 1] = 0;
      }

      if (nrt + 1 < p) {
        e[nrt] = a.get(nrt, p - 1);
      }

      e[p - 1] = 0;

      if (wantu) {
        for (let j = nct; j < nu; j++) {
          for (let i = 0; i < m; i++) {
            U.set(i, j, 0);
          }

          U.set(j, j, 1);
        }

        for (let k = nct - 1; k >= 0; k--) {
          if (s[k] !== 0) {
            for (let j = k + 1; j < nu; j++) {
              let t = 0;

              for (let i = k; i < m; i++) {
                t += U.get(i, k) * U.get(i, j);
              }

              t = -t / U.get(k, k);

              for (let i = k; i < m; i++) {
                U.set(i, j, U.get(i, j) + t * U.get(i, k));
              }
            }

            for (let i = k; i < m; i++) {
              U.set(i, k, -U.get(i, k));
            }

            U.set(k, k, 1 + U.get(k, k));

            for (let i = 0; i < k - 1; i++) {
              U.set(i, k, 0);
            }
          } else {
            for (let i = 0; i < m; i++) {
              U.set(i, k, 0);
            }

            U.set(k, k, 1);
          }
        }
      }

      if (wantv) {
        for (let k = n - 1; k >= 0; k--) {
          if (k < nrt && e[k] !== 0) {
            for (let j = k + 1; j < n; j++) {
              let t = 0;

              for (let i = k + 1; i < n; i++) {
                t += V.get(i, k) * V.get(i, j);
              }

              t = -t / V.get(k + 1, k);

              for (let i = k + 1; i < n; i++) {
                V.set(i, j, V.get(i, j) + t * V.get(i, k));
              }
            }
          }

          for (let i = 0; i < n; i++) {
            V.set(i, k, 0);
          }

          V.set(k, k, 1);
        }
      }

      let pp = p - 1;
      let eps = Number.EPSILON;

      while (p > 0) {
        let k, kase;

        for (k = p - 2; k >= -1; k--) {
          if (k === -1) {
            break;
          }

          const alpha = Number.MIN_VALUE + eps * Math.abs(s[k] + Math.abs(s[k + 1]));

          if (Math.abs(e[k]) <= alpha || Number.isNaN(e[k])) {
            e[k] = 0;
            break;
          }
        }

        if (k === p - 2) {
          kase = 4;
        } else {
          let ks;

          for (ks = p - 1; ks >= k; ks--) {
            if (ks === k) {
              break;
            }

            let t = (ks !== p ? Math.abs(e[ks]) : 0) + (ks !== k + 1 ? Math.abs(e[ks - 1]) : 0);

            if (Math.abs(s[ks]) <= eps * t) {
              s[ks] = 0;
              break;
            }
          }

          if (ks === k) {
            kase = 3;
          } else if (ks === p - 1) {
            kase = 1;
          } else {
            kase = 2;
            k = ks;
          }
        }

        k++;

        switch (kase) {
          case 1:
            {
              let f = e[p - 2];
              e[p - 2] = 0;

              for (let j = p - 2; j >= k; j--) {
                let t = hypotenuse(s[j], f);
                let cs = s[j] / t;
                let sn = f / t;
                s[j] = t;

                if (j !== k) {
                  f = -sn * e[j - 1];
                  e[j - 1] = cs * e[j - 1];
                }

                if (wantv) {
                  for (let i = 0; i < n; i++) {
                    t = cs * V.get(i, j) + sn * V.get(i, p - 1);
                    V.set(i, p - 1, -sn * V.get(i, j) + cs * V.get(i, p - 1));
                    V.set(i, j, t);
                  }
                }
              }

              break;
            }

          case 2:
            {
              let f = e[k - 1];
              e[k - 1] = 0;

              for (let j = k; j < p; j++) {
                let t = hypotenuse(s[j], f);
                let cs = s[j] / t;
                let sn = f / t;
                s[j] = t;
                f = -sn * e[j];
                e[j] = cs * e[j];

                if (wantu) {
                  for (let i = 0; i < m; i++) {
                    t = cs * U.get(i, j) + sn * U.get(i, k - 1);
                    U.set(i, k - 1, -sn * U.get(i, j) + cs * U.get(i, k - 1));
                    U.set(i, j, t);
                  }
                }
              }

              break;
            }

          case 3:
            {
              const scale = Math.max(Math.abs(s[p - 1]), Math.abs(s[p - 2]), Math.abs(e[p - 2]), Math.abs(s[k]), Math.abs(e[k]));
              const sp = s[p - 1] / scale;
              const spm1 = s[p - 2] / scale;
              const epm1 = e[p - 2] / scale;
              const sk = s[k] / scale;
              const ek = e[k] / scale;
              const b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2;
              const c = sp * epm1 * (sp * epm1);
              let shift = 0;

              if (b !== 0 || c !== 0) {
                if (b < 0) {
                  shift = 0 - Math.sqrt(b * b + c);
                } else {
                  shift = Math.sqrt(b * b + c);
                }

                shift = c / (b + shift);
              }

              let f = (sk + sp) * (sk - sp) + shift;
              let g = sk * ek;

              for (let j = k; j < p - 1; j++) {
                let t = hypotenuse(f, g);
                if (t === 0) t = Number.MIN_VALUE;
                let cs = f / t;
                let sn = g / t;

                if (j !== k) {
                  e[j - 1] = t;
                }

                f = cs * s[j] + sn * e[j];
                e[j] = cs * e[j] - sn * s[j];
                g = sn * s[j + 1];
                s[j + 1] = cs * s[j + 1];

                if (wantv) {
                  for (let i = 0; i < n; i++) {
                    t = cs * V.get(i, j) + sn * V.get(i, j + 1);
                    V.set(i, j + 1, -sn * V.get(i, j) + cs * V.get(i, j + 1));
                    V.set(i, j, t);
                  }
                }

                t = hypotenuse(f, g);
                if (t === 0) t = Number.MIN_VALUE;
                cs = f / t;
                sn = g / t;
                s[j] = t;
                f = cs * e[j] + sn * s[j + 1];
                s[j + 1] = -sn * e[j] + cs * s[j + 1];
                g = sn * e[j + 1];
                e[j + 1] = cs * e[j + 1];

                if (wantu && j < m - 1) {
                  for (let i = 0; i < m; i++) {
                    t = cs * U.get(i, j) + sn * U.get(i, j + 1);
                    U.set(i, j + 1, -sn * U.get(i, j) + cs * U.get(i, j + 1));
                    U.set(i, j, t);
                  }
                }
              }

              e[p - 2] = f;
              break;
            }

          case 4:
            {
              if (s[k] <= 0) {
                s[k] = s[k] < 0 ? -s[k] : 0;

                if (wantv) {
                  for (let i = 0; i <= pp; i++) {
                    V.set(i, k, -V.get(i, k));
                  }
                }
              }

              while (k < pp) {
                if (s[k] >= s[k + 1]) {
                  break;
                }

                let t = s[k];
                s[k] = s[k + 1];
                s[k + 1] = t;

                if (wantv && k < n - 1) {
                  for (let i = 0; i < n; i++) {
                    t = V.get(i, k + 1);
                    V.set(i, k + 1, V.get(i, k));
                    V.set(i, k, t);
                  }
                }

                if (wantu && k < m - 1) {
                  for (let i = 0; i < m; i++) {
                    t = U.get(i, k + 1);
                    U.set(i, k + 1, U.get(i, k));
                    U.set(i, k, t);
                  }
                }

                k++;
              }
              p--;
              break;
            }
          // no default
        }
      }

      if (swapped) {
        let tmp = V;
        V = U;
        U = tmp;
      }

      this.m = m;
      this.n = n;
      this.s = s;
      this.U = U;
      this.V = V;
    }

    solve(value) {
      let Y = value;
      let e = this.threshold;
      let scols = this.s.length;
      let Ls = Matrix.zeros(scols, scols);

      for (let i = 0; i < scols; i++) {
        if (Math.abs(this.s[i]) <= e) {
          Ls.set(i, i, 0);
        } else {
          Ls.set(i, i, 1 / this.s[i]);
        }
      }

      let U = this.U;
      let V = this.rightSingularVectors;
      let VL = V.mmul(Ls);
      let vrows = V.rows;
      let urows = U.rows;
      let VLU = Matrix.zeros(vrows, urows);

      for (let i = 0; i < vrows; i++) {
        for (let j = 0; j < urows; j++) {
          let sum = 0;

          for (let k = 0; k < scols; k++) {
            sum += VL.get(i, k) * U.get(j, k);
          }

          VLU.set(i, j, sum);
        }
      }

      return VLU.mmul(Y);
    }

    solveForDiagonal(value) {
      return this.solve(Matrix.diag(value));
    }

    inverse() {
      let V = this.V;
      let e = this.threshold;
      let vrows = V.rows;
      let vcols = V.columns;
      let X = new Matrix(vrows, this.s.length);

      for (let i = 0; i < vrows; i++) {
        for (let j = 0; j < vcols; j++) {
          if (Math.abs(this.s[j]) > e) {
            X.set(i, j, V.get(i, j) / this.s[j]);
          }
        }
      }

      let U = this.U;
      let urows = U.rows;
      let ucols = U.columns;
      let Y = new Matrix(vrows, urows);

      for (let i = 0; i < vrows; i++) {
        for (let j = 0; j < urows; j++) {
          let sum = 0;

          for (let k = 0; k < ucols; k++) {
            sum += X.get(i, k) * U.get(j, k);
          }

          Y.set(i, j, sum);
        }
      }

      return Y;
    }

    get condition() {
      return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    get norm2() {
      return this.s[0];
    }

    get rank() {
      let tol = Math.max(this.m, this.n) * this.s[0] * Number.EPSILON;
      let r = 0;
      let s = this.s;

      for (let i = 0, ii = s.length; i < ii; i++) {
        if (s[i] > tol) {
          r++;
        }
      }

      return r;
    }

    get diagonal() {
      return Array.from(this.s);
    }

    get threshold() {
      return Number.EPSILON / 2 * Math.max(this.m, this.n) * this.s[0];
    }

    get leftSingularVectors() {
      return this.U;
    }

    get rightSingularVectors() {
      return this.V;
    }

    get diagonalMatrix() {
      return Matrix.diag(this.s);
    }

  }

  function inverse(matrix, useSVD = false) {
    matrix = WrapperMatrix2D.checkMatrix(matrix);

    if (useSVD) {
      return new SingularValueDecomposition(matrix).inverse();
    } else {
      return solve(matrix, Matrix.eye(matrix.rows));
    }
  }
  function solve(leftHandSide, rightHandSide, useSVD = false) {
    leftHandSide = WrapperMatrix2D.checkMatrix(leftHandSide);
    rightHandSide = WrapperMatrix2D.checkMatrix(rightHandSide);

    if (useSVD) {
      return new SingularValueDecomposition(leftHandSide).solve(rightHandSide);
    } else {
      return leftHandSide.isSquare() ? new LuDecomposition(leftHandSide).solve(rightHandSide) : new QrDecomposition(leftHandSide).solve(rightHandSide);
    }
  }

  class EigenvalueDecomposition {
    constructor(matrix, options = {}) {
      const {
        assumeSymmetric = false
      } = options;
      matrix = WrapperMatrix2D.checkMatrix(matrix);

      if (!matrix.isSquare()) {
        throw new Error('Matrix is not a square matrix');
      }

      if (matrix.isEmpty()) {
        throw new Error('Matrix must be non-empty');
      }

      let n = matrix.columns;
      let V = new Matrix(n, n);
      let d = new Float64Array(n);
      let e = new Float64Array(n);
      let value = matrix;
      let i, j;
      let isSymmetric = false;

      if (assumeSymmetric) {
        isSymmetric = true;
      } else {
        isSymmetric = matrix.isSymmetric();
      }

      if (isSymmetric) {
        for (i = 0; i < n; i++) {
          for (j = 0; j < n; j++) {
            V.set(i, j, value.get(i, j));
          }
        }

        tred2(n, e, d, V);
        tql2(n, e, d, V);
      } else {
        let H = new Matrix(n, n);
        let ort = new Float64Array(n);

        for (j = 0; j < n; j++) {
          for (i = 0; i < n; i++) {
            H.set(i, j, value.get(i, j));
          }
        }

        orthes(n, H, ort, V);
        hqr2(n, e, d, V, H);
      }

      this.n = n;
      this.e = e;
      this.d = d;
      this.V = V;
    }

    get realEigenvalues() {
      return Array.from(this.d);
    }

    get imaginaryEigenvalues() {
      return Array.from(this.e);
    }

    get eigenvectorMatrix() {
      return this.V;
    }

    get diagonalMatrix() {
      let n = this.n;
      let e = this.e;
      let d = this.d;
      let X = new Matrix(n, n);
      let i, j;

      for (i = 0; i < n; i++) {
        for (j = 0; j < n; j++) {
          X.set(i, j, 0);
        }

        X.set(i, i, d[i]);

        if (e[i] > 0) {
          X.set(i, i + 1, e[i]);
        } else if (e[i] < 0) {
          X.set(i, i - 1, e[i]);
        }
      }

      return X;
    }

  }

  function tred2(n, e, d, V) {
    let f, g, h, i, j, k, hh, scale;

    for (j = 0; j < n; j++) {
      d[j] = V.get(n - 1, j);
    }

    for (i = n - 1; i > 0; i--) {
      scale = 0;
      h = 0;

      for (k = 0; k < i; k++) {
        scale = scale + Math.abs(d[k]);
      }

      if (scale === 0) {
        e[i] = d[i - 1];

        for (j = 0; j < i; j++) {
          d[j] = V.get(i - 1, j);
          V.set(i, j, 0);
          V.set(j, i, 0);
        }
      } else {
        for (k = 0; k < i; k++) {
          d[k] /= scale;
          h += d[k] * d[k];
        }

        f = d[i - 1];
        g = Math.sqrt(h);

        if (f > 0) {
          g = -g;
        }

        e[i] = scale * g;
        h = h - f * g;
        d[i - 1] = f - g;

        for (j = 0; j < i; j++) {
          e[j] = 0;
        }

        for (j = 0; j < i; j++) {
          f = d[j];
          V.set(j, i, f);
          g = e[j] + V.get(j, j) * f;

          for (k = j + 1; k <= i - 1; k++) {
            g += V.get(k, j) * d[k];
            e[k] += V.get(k, j) * f;
          }

          e[j] = g;
        }

        f = 0;

        for (j = 0; j < i; j++) {
          e[j] /= h;
          f += e[j] * d[j];
        }

        hh = f / (h + h);

        for (j = 0; j < i; j++) {
          e[j] -= hh * d[j];
        }

        for (j = 0; j < i; j++) {
          f = d[j];
          g = e[j];

          for (k = j; k <= i - 1; k++) {
            V.set(k, j, V.get(k, j) - (f * e[k] + g * d[k]));
          }

          d[j] = V.get(i - 1, j);
          V.set(i, j, 0);
        }
      }

      d[i] = h;
    }

    for (i = 0; i < n - 1; i++) {
      V.set(n - 1, i, V.get(i, i));
      V.set(i, i, 1);
      h = d[i + 1];

      if (h !== 0) {
        for (k = 0; k <= i; k++) {
          d[k] = V.get(k, i + 1) / h;
        }

        for (j = 0; j <= i; j++) {
          g = 0;

          for (k = 0; k <= i; k++) {
            g += V.get(k, i + 1) * V.get(k, j);
          }

          for (k = 0; k <= i; k++) {
            V.set(k, j, V.get(k, j) - g * d[k]);
          }
        }
      }

      for (k = 0; k <= i; k++) {
        V.set(k, i + 1, 0);
      }
    }

    for (j = 0; j < n; j++) {
      d[j] = V.get(n - 1, j);
      V.set(n - 1, j, 0);
    }

    V.set(n - 1, n - 1, 1);
    e[0] = 0;
  }

  function tql2(n, e, d, V) {
    let g, h, i, j, k, l, m, p, r, dl1, c, c2, c3, el1, s, s2;

    for (i = 1; i < n; i++) {
      e[i - 1] = e[i];
    }

    e[n - 1] = 0;
    let f = 0;
    let tst1 = 0;
    let eps = Number.EPSILON;

    for (l = 0; l < n; l++) {
      tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
      m = l;

      while (m < n) {
        if (Math.abs(e[m]) <= eps * tst1) {
          break;
        }

        m++;
      }

      if (m > l) {

        do {
          g = d[l];
          p = (d[l + 1] - g) / (2 * e[l]);
          r = hypotenuse(p, 1);

          if (p < 0) {
            r = -r;
          }

          d[l] = e[l] / (p + r);
          d[l + 1] = e[l] * (p + r);
          dl1 = d[l + 1];
          h = g - d[l];

          for (i = l + 2; i < n; i++) {
            d[i] -= h;
          }

          f = f + h;
          p = d[m];
          c = 1;
          c2 = c;
          c3 = c;
          el1 = e[l + 1];
          s = 0;
          s2 = 0;

          for (i = m - 1; i >= l; i--) {
            c3 = c2;
            c2 = c;
            s2 = s;
            g = c * e[i];
            h = c * p;
            r = hypotenuse(p, e[i]);
            e[i + 1] = s * r;
            s = e[i] / r;
            c = p / r;
            p = c * d[i] - s * g;
            d[i + 1] = h + s * (c * g + s * d[i]);

            for (k = 0; k < n; k++) {
              h = V.get(k, i + 1);
              V.set(k, i + 1, s * V.get(k, i) + c * h);
              V.set(k, i, c * V.get(k, i) - s * h);
            }
          }

          p = -s * s2 * c3 * el1 * e[l] / dl1;
          e[l] = s * p;
          d[l] = c * p;
        } while (Math.abs(e[l]) > eps * tst1);
      }

      d[l] = d[l] + f;
      e[l] = 0;
    }

    for (i = 0; i < n - 1; i++) {
      k = i;
      p = d[i];

      for (j = i + 1; j < n; j++) {
        if (d[j] < p) {
          k = j;
          p = d[j];
        }
      }

      if (k !== i) {
        d[k] = d[i];
        d[i] = p;

        for (j = 0; j < n; j++) {
          p = V.get(j, i);
          V.set(j, i, V.get(j, k));
          V.set(j, k, p);
        }
      }
    }
  }

  function orthes(n, H, ort, V) {
    let low = 0;
    let high = n - 1;
    let f, g, h, i, j, m;
    let scale;

    for (m = low + 1; m <= high - 1; m++) {
      scale = 0;

      for (i = m; i <= high; i++) {
        scale = scale + Math.abs(H.get(i, m - 1));
      }

      if (scale !== 0) {
        h = 0;

        for (i = high; i >= m; i--) {
          ort[i] = H.get(i, m - 1) / scale;
          h += ort[i] * ort[i];
        }

        g = Math.sqrt(h);

        if (ort[m] > 0) {
          g = -g;
        }

        h = h - ort[m] * g;
        ort[m] = ort[m] - g;

        for (j = m; j < n; j++) {
          f = 0;

          for (i = high; i >= m; i--) {
            f += ort[i] * H.get(i, j);
          }

          f = f / h;

          for (i = m; i <= high; i++) {
            H.set(i, j, H.get(i, j) - f * ort[i]);
          }
        }

        for (i = 0; i <= high; i++) {
          f = 0;

          for (j = high; j >= m; j--) {
            f += ort[j] * H.get(i, j);
          }

          f = f / h;

          for (j = m; j <= high; j++) {
            H.set(i, j, H.get(i, j) - f * ort[j]);
          }
        }

        ort[m] = scale * ort[m];
        H.set(m, m - 1, scale * g);
      }
    }

    for (i = 0; i < n; i++) {
      for (j = 0; j < n; j++) {
        V.set(i, j, i === j ? 1 : 0);
      }
    }

    for (m = high - 1; m >= low + 1; m--) {
      if (H.get(m, m - 1) !== 0) {
        for (i = m + 1; i <= high; i++) {
          ort[i] = H.get(i, m - 1);
        }

        for (j = m; j <= high; j++) {
          g = 0;

          for (i = m; i <= high; i++) {
            g += ort[i] * V.get(i, j);
          }

          g = g / ort[m] / H.get(m, m - 1);

          for (i = m; i <= high; i++) {
            V.set(i, j, V.get(i, j) + g * ort[i]);
          }
        }
      }
    }
  }

  function hqr2(nn, e, d, V, H) {
    let n = nn - 1;
    let low = 0;
    let high = nn - 1;
    let eps = Number.EPSILON;
    let exshift = 0;
    let norm = 0;
    let p = 0;
    let q = 0;
    let r = 0;
    let s = 0;
    let z = 0;
    let iter = 0;
    let i, j, k, l, m, t, w, x, y;
    let ra, sa, vr, vi;
    let notlast, cdivres;

    for (i = 0; i < nn; i++) {
      if (i < low || i > high) {
        d[i] = H.get(i, i);
        e[i] = 0;
      }

      for (j = Math.max(i - 1, 0); j < nn; j++) {
        norm = norm + Math.abs(H.get(i, j));
      }
    }

    while (n >= low) {
      l = n;

      while (l > low) {
        s = Math.abs(H.get(l - 1, l - 1)) + Math.abs(H.get(l, l));

        if (s === 0) {
          s = norm;
        }

        if (Math.abs(H.get(l, l - 1)) < eps * s) {
          break;
        }

        l--;
      }

      if (l === n) {
        H.set(n, n, H.get(n, n) + exshift);
        d[n] = H.get(n, n);
        e[n] = 0;
        n--;
        iter = 0;
      } else if (l === n - 1) {
        w = H.get(n, n - 1) * H.get(n - 1, n);
        p = (H.get(n - 1, n - 1) - H.get(n, n)) / 2;
        q = p * p + w;
        z = Math.sqrt(Math.abs(q));
        H.set(n, n, H.get(n, n) + exshift);
        H.set(n - 1, n - 1, H.get(n - 1, n - 1) + exshift);
        x = H.get(n, n);

        if (q >= 0) {
          z = p >= 0 ? p + z : p - z;
          d[n - 1] = x + z;
          d[n] = d[n - 1];

          if (z !== 0) {
            d[n] = x - w / z;
          }

          e[n - 1] = 0;
          e[n] = 0;
          x = H.get(n, n - 1);
          s = Math.abs(x) + Math.abs(z);
          p = x / s;
          q = z / s;
          r = Math.sqrt(p * p + q * q);
          p = p / r;
          q = q / r;

          for (j = n - 1; j < nn; j++) {
            z = H.get(n - 1, j);
            H.set(n - 1, j, q * z + p * H.get(n, j));
            H.set(n, j, q * H.get(n, j) - p * z);
          }

          for (i = 0; i <= n; i++) {
            z = H.get(i, n - 1);
            H.set(i, n - 1, q * z + p * H.get(i, n));
            H.set(i, n, q * H.get(i, n) - p * z);
          }

          for (i = low; i <= high; i++) {
            z = V.get(i, n - 1);
            V.set(i, n - 1, q * z + p * V.get(i, n));
            V.set(i, n, q * V.get(i, n) - p * z);
          }
        } else {
          d[n - 1] = x + p;
          d[n] = x + p;
          e[n - 1] = z;
          e[n] = -z;
        }

        n = n - 2;
        iter = 0;
      } else {
        x = H.get(n, n);
        y = 0;
        w = 0;

        if (l < n) {
          y = H.get(n - 1, n - 1);
          w = H.get(n, n - 1) * H.get(n - 1, n);
        }

        if (iter === 10) {
          exshift += x;

          for (i = low; i <= n; i++) {
            H.set(i, i, H.get(i, i) - x);
          }

          s = Math.abs(H.get(n, n - 1)) + Math.abs(H.get(n - 1, n - 2));
          x = y = 0.75 * s;
          w = -0.4375 * s * s;
        }

        if (iter === 30) {
          s = (y - x) / 2;
          s = s * s + w;

          if (s > 0) {
            s = Math.sqrt(s);

            if (y < x) {
              s = -s;
            }

            s = x - w / ((y - x) / 2 + s);

            for (i = low; i <= n; i++) {
              H.set(i, i, H.get(i, i) - s);
            }

            exshift += s;
            x = y = w = 0.964;
          }
        }

        iter = iter + 1;
        m = n - 2;

        while (m >= l) {
          z = H.get(m, m);
          r = x - z;
          s = y - z;
          p = (r * s - w) / H.get(m + 1, m) + H.get(m, m + 1);
          q = H.get(m + 1, m + 1) - z - r - s;
          r = H.get(m + 2, m + 1);
          s = Math.abs(p) + Math.abs(q) + Math.abs(r);
          p = p / s;
          q = q / s;
          r = r / s;

          if (m === l) {
            break;
          }

          if (Math.abs(H.get(m, m - 1)) * (Math.abs(q) + Math.abs(r)) < eps * (Math.abs(p) * (Math.abs(H.get(m - 1, m - 1)) + Math.abs(z) + Math.abs(H.get(m + 1, m + 1))))) {
            break;
          }

          m--;
        }

        for (i = m + 2; i <= n; i++) {
          H.set(i, i - 2, 0);

          if (i > m + 2) {
            H.set(i, i - 3, 0);
          }
        }

        for (k = m; k <= n - 1; k++) {
          notlast = k !== n - 1;

          if (k !== m) {
            p = H.get(k, k - 1);
            q = H.get(k + 1, k - 1);
            r = notlast ? H.get(k + 2, k - 1) : 0;
            x = Math.abs(p) + Math.abs(q) + Math.abs(r);

            if (x !== 0) {
              p = p / x;
              q = q / x;
              r = r / x;
            }
          }

          if (x === 0) {
            break;
          }

          s = Math.sqrt(p * p + q * q + r * r);

          if (p < 0) {
            s = -s;
          }

          if (s !== 0) {
            if (k !== m) {
              H.set(k, k - 1, -s * x);
            } else if (l !== m) {
              H.set(k, k - 1, -H.get(k, k - 1));
            }

            p = p + s;
            x = p / s;
            y = q / s;
            z = r / s;
            q = q / p;
            r = r / p;

            for (j = k; j < nn; j++) {
              p = H.get(k, j) + q * H.get(k + 1, j);

              if (notlast) {
                p = p + r * H.get(k + 2, j);
                H.set(k + 2, j, H.get(k + 2, j) - p * z);
              }

              H.set(k, j, H.get(k, j) - p * x);
              H.set(k + 1, j, H.get(k + 1, j) - p * y);
            }

            for (i = 0; i <= Math.min(n, k + 3); i++) {
              p = x * H.get(i, k) + y * H.get(i, k + 1);

              if (notlast) {
                p = p + z * H.get(i, k + 2);
                H.set(i, k + 2, H.get(i, k + 2) - p * r);
              }

              H.set(i, k, H.get(i, k) - p);
              H.set(i, k + 1, H.get(i, k + 1) - p * q);
            }

            for (i = low; i <= high; i++) {
              p = x * V.get(i, k) + y * V.get(i, k + 1);

              if (notlast) {
                p = p + z * V.get(i, k + 2);
                V.set(i, k + 2, V.get(i, k + 2) - p * r);
              }

              V.set(i, k, V.get(i, k) - p);
              V.set(i, k + 1, V.get(i, k + 1) - p * q);
            }
          }
        }
      }
    }

    if (norm === 0) {
      return;
    }

    for (n = nn - 1; n >= 0; n--) {
      p = d[n];
      q = e[n];

      if (q === 0) {
        l = n;
        H.set(n, n, 1);

        for (i = n - 1; i >= 0; i--) {
          w = H.get(i, i) - p;
          r = 0;

          for (j = l; j <= n; j++) {
            r = r + H.get(i, j) * H.get(j, n);
          }

          if (e[i] < 0) {
            z = w;
            s = r;
          } else {
            l = i;

            if (e[i] === 0) {
              H.set(i, n, w !== 0 ? -r / w : -r / (eps * norm));
            } else {
              x = H.get(i, i + 1);
              y = H.get(i + 1, i);
              q = (d[i] - p) * (d[i] - p) + e[i] * e[i];
              t = (x * s - z * r) / q;
              H.set(i, n, t);
              H.set(i + 1, n, Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z);
            }

            t = Math.abs(H.get(i, n));

            if (eps * t * t > 1) {
              for (j = i; j <= n; j++) {
                H.set(j, n, H.get(j, n) / t);
              }
            }
          }
        }
      } else if (q < 0) {
        l = n - 1;

        if (Math.abs(H.get(n, n - 1)) > Math.abs(H.get(n - 1, n))) {
          H.set(n - 1, n - 1, q / H.get(n, n - 1));
          H.set(n - 1, n, -(H.get(n, n) - p) / H.get(n, n - 1));
        } else {
          cdivres = cdiv(0, -H.get(n - 1, n), H.get(n - 1, n - 1) - p, q);
          H.set(n - 1, n - 1, cdivres[0]);
          H.set(n - 1, n, cdivres[1]);
        }

        H.set(n, n - 1, 0);
        H.set(n, n, 1);

        for (i = n - 2; i >= 0; i--) {
          ra = 0;
          sa = 0;

          for (j = l; j <= n; j++) {
            ra = ra + H.get(i, j) * H.get(j, n - 1);
            sa = sa + H.get(i, j) * H.get(j, n);
          }

          w = H.get(i, i) - p;

          if (e[i] < 0) {
            z = w;
            r = ra;
            s = sa;
          } else {
            l = i;

            if (e[i] === 0) {
              cdivres = cdiv(-ra, -sa, w, q);
              H.set(i, n - 1, cdivres[0]);
              H.set(i, n, cdivres[1]);
            } else {
              x = H.get(i, i + 1);
              y = H.get(i + 1, i);
              vr = (d[i] - p) * (d[i] - p) + e[i] * e[i] - q * q;
              vi = (d[i] - p) * 2 * q;

              if (vr === 0 && vi === 0) {
                vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
              }

              cdivres = cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
              H.set(i, n - 1, cdivres[0]);
              H.set(i, n, cdivres[1]);

              if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                H.set(i + 1, n - 1, (-ra - w * H.get(i, n - 1) + q * H.get(i, n)) / x);
                H.set(i + 1, n, (-sa - w * H.get(i, n) - q * H.get(i, n - 1)) / x);
              } else {
                cdivres = cdiv(-r - y * H.get(i, n - 1), -s - y * H.get(i, n), z, q);
                H.set(i + 1, n - 1, cdivres[0]);
                H.set(i + 1, n, cdivres[1]);
              }
            }

            t = Math.max(Math.abs(H.get(i, n - 1)), Math.abs(H.get(i, n)));

            if (eps * t * t > 1) {
              for (j = i; j <= n; j++) {
                H.set(j, n - 1, H.get(j, n - 1) / t);
                H.set(j, n, H.get(j, n) / t);
              }
            }
          }
        }
      }
    }

    for (i = 0; i < nn; i++) {
      if (i < low || i > high) {
        for (j = i; j < nn; j++) {
          V.set(i, j, H.get(i, j));
        }
      }
    }

    for (j = nn - 1; j >= low; j--) {
      for (i = low; i <= high; i++) {
        z = 0;

        for (k = low; k <= Math.min(j, high); k++) {
          z = z + V.get(i, k) * H.get(k, j);
        }

        V.set(i, j, z);
      }
    }
  }

  function cdiv(xr, xi, yr, yi) {
    let r, d;

    if (Math.abs(yr) > Math.abs(yi)) {
      r = yi / yr;
      d = yr + r * yi;
      return [(xr + r * xi) / d, (xi - r * xr) / d];
    } else {
      r = yr / yi;
      d = yi + r * yr;
      return [(r * xr + xi) / d, (r * xi - xr) / d];
    }
  }

  /**
   * Difference of the matrix function over the parameters
   * @ignore
   * @param {{x:Array<number>, y:Array<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
   * @param {Array<number>} evaluatedData - Array of previous evaluated function values
   * @param {Array<number>} params - Array of previous parameter values
   * @param {number|array} gradientDifference - The step size to approximate the jacobian matrix
   * @param {boolean} centralDifference - If true the jacobian matrix is approximated by central differences otherwise by forward differences
   * @param {function} paramFunction - The parameters and returns a function with the independent variable as a parameter
   * @return {Matrix}
   */

  function gradientFunction(data, evaluatedData, params, gradientDifference, paramFunction, centralDifference) {
    const nbParams = params.length;
    const nbPoints = data.x.length;
    let ans = Matrix.zeros(nbParams, nbPoints);
    let rowIndex = 0;

    for (let param = 0; param < nbParams; param++) {
      if (gradientDifference[param] === 0) continue;
      let delta = gradientDifference[param];
      let auxParams = params.slice();
      auxParams[param] += delta;
      let funcParam = paramFunction(auxParams);

      if (!centralDifference) {
        for (let point = 0; point < nbPoints; point++) {
          ans.set(rowIndex, point, (evaluatedData[point] - funcParam(data.x[point])) / delta);
        }
      } else {
        auxParams = params.slice();
        auxParams[param] -= delta;
        delta *= 2;
        let funcParam2 = paramFunction(auxParams);

        for (let point = 0; point < nbPoints; point++) {
          ans.set(rowIndex, point, (funcParam2(data.x[point]) - funcParam(data.x[point])) / delta);
        }
      }

      rowIndex++;
    }

    return ans;
  }

  /**
   * Matrix function over the samples
   * @ignore
   * @param {{x:Array<number>, y:Array<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
   * @param {Array<number>} evaluatedData - Array of previous evaluated function values
   * @return {Matrix}
   */

  function matrixFunction(data, evaluatedData) {
    const m = data.x.length;
    let ans = new Matrix(m, 1);

    for (let point = 0; point < m; point++) {
      ans.set(point, 0, data.y[point] - evaluatedData[point]);
    }

    return ans;
  }
  /**
   * Iteration for Levenberg-Marquardt
   * @ignore
   * @param {{x:Array<number>, y:Array<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
   * @param {Array<number>} params - Array of previous parameter values
   * @param {number} damping - Levenberg-Marquardt parameter
   * @param {number|array} gradientDifference - The step size to approximate the jacobian matrix
   * @param {boolean} centralDifference - If true the jacobian matrix is approximated by central differences otherwise by forward differences
   * @param {function} parameterizedFunction - The parameters and returns a function with the independent variable as a parameter
   * @return {Array<number>}
   */


  function step(data, params, damping, gradientDifference, parameterizedFunction, centralDifference, weights) {
    let value = damping;
    let identity = Matrix.eye(params.length, params.length, value);
    const func = parameterizedFunction(params);
    let evaluatedData = new Float64Array(data.x.length);

    for (let i = 0; i < data.x.length; i++) {
      evaluatedData[i] = func(data.x[i]);
    }

    let gradientFunc = gradientFunction(data, evaluatedData, params, gradientDifference, parameterizedFunction, centralDifference);
    let residualError = matrixFunction(data, evaluatedData);
    let inverseMatrix = inverse(identity.add(gradientFunc.mmul(gradientFunc.transpose().scale('row', {
      scale: weights
    }))));
    let jacobianWeigthResidualError = gradientFunc.mmul(residualError.scale('row', {
      scale: weights
    }));
    let perturbations = inverseMatrix.mmul(jacobianWeigthResidualError);
    return {
      perturbations,
      jacobianWeigthResidualError
    };
  }

  /**
   * Curve fitting algorithm
   * @param {{x:Array<number>, y:Array<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
   * @param {function} parameterizedFunction - The parameters and returns a function with the independent variable as a parameter
   * @param {object} [options] - Options object
   * @param {number|array} [options.weights = 1] - weighting vector, if the length does not match with the number of data points, the vector is reconstructed with first value.
   * @param {number} [options.damping = 1e-2] - Levenberg-Marquardt parameter, small values of the damping parameter λ result in a Gauss-Newton update and large
  values of λ result in a gradient descent update
   * @param {number} [options.dampingStepDown = 9] - factor to reduce the damping (Levenberg-Marquardt parameter) when there is not an improvement when updating parameters.
   * @param {number} [options.dampingStepUp = 11] - factor to increase the damping (Levenberg-Marquardt parameter) when there is an improvement when updating parameters.
   * @param {number} [options.improvementThreshold = 1e-3] - the threshold to define an improvement through an update of parameters
   * @param {number|array} [options.gradientDifference = 10e-2] - The step size to approximate the jacobian matrix
   * @param {boolean} [options.centralDifference = false] - If true the jacobian matrix is approximated by central differences otherwise by forward differences
   * @param {Array<number>} [options.minValues] - Minimum allowed values for parameters
   * @param {Array<number>} [options.maxValues] - Maximum allowed values for parameters
   * @param {Array<number>} [options.initialValues] - Array of initial parameter values
   * @param {number} [options.maxIterations = 100] - Maximum of allowed iterations
   * @param {number} [options.errorTolerance = 10e-3] - Minimum uncertainty allowed for each point.
   * @param {number} [options.timeout] - maximum time running before throw in seconds.
   * @return {{parameterValues: Array<number>, parameterError: number, iterations: number}}
   */

  function levenbergMarquardt(data, parameterizedFunction, options = {}) {
    let {
      checkTimeout,
      minValues,
      maxValues,
      parameters,
      weightSquare,
      damping,
      dampingStepUp,
      dampingStepDown,
      maxIterations,
      errorTolerance,
      centralDifference,
      gradientDifference,
      improvementThreshold
    } = checkOptions$1(data, parameterizedFunction, options);
    let error = errorCalculation(data, parameters, parameterizedFunction, weightSquare);
    let converged = error <= errorTolerance;
    let iteration = 0;

    for (; iteration < maxIterations && !converged; iteration++) {
      let previousError = error;
      let {
        perturbations,
        jacobianWeigthResidualError
      } = step(data, parameters, damping, gradientDifference, parameterizedFunction, centralDifference, weightSquare);

      for (let k = 0; k < parameters.length; k++) {
        parameters[k] = Math.min(Math.max(minValues[k], parameters[k] - perturbations.get(k, 0)), maxValues[k]);
      }

      error = errorCalculation(data, parameters, parameterizedFunction, weightSquare);
      if (isNaN(error)) break;
      let improvementMetric = (previousError - error) / perturbations.transpose().mmul(perturbations.mulS(damping).add(jacobianWeigthResidualError)).get(0, 0);

      if (improvementMetric > improvementThreshold) {
        damping = Math.max(damping / dampingStepDown, 1e-7);
      } else {
        error = previousError;
        damping = Math.min(damping * dampingStepUp, 1e7);
      }

      if (checkTimeout()) {
        throw new Error(`The execution time is over to ${options.timeout} seconds`);
      }

      converged = error <= errorTolerance;
    }

    return {
      parameterValues: parameters,
      parameterError: error,
      iterations: iteration
    };
  }

  const LEVENBERG_MARQUARDT = 1;
  function selectMethod(optimizationOptions = {}) {
    let {
      kind,
      options
    } = optimizationOptions;
    kind = getKind(kind);

    switch (kind) {
      case LEVENBERG_MARQUARDT:
        return {
          algorithm: levenbergMarquardt,
          optimizationOptions: checkOptions(kind, options)
        };

      default:
        throw new Error(`Unknown kind algorithm`);
    }
  }

  function checkOptions(kind, options = {}) {
    // eslint-disable-next-line default-case
    switch (kind) {
      case LEVENBERG_MARQUARDT:
        return Object.assign({}, lmOptions, options);
    }
  }

  function getKind(kind) {
    if (typeof kind !== 'string') return kind;

    switch (kind.toLowerCase().replace(/[^a-z]/g, '')) {
      case 'lm':
      case 'levenbergmarquardt':
        return LEVENBERG_MARQUARDT;

      default:
        throw new Error(`Unknown kind algorithm`);
    }
  }

  const lmOptions = {
    damping: 1.5,
    maxIterations: 100,
    errorTolerance: 1e-8
  };

  // const STATE_MIN = 1;
  // const STATE_MAX = 2;
  // const STATE_GRADIENT_DIFFERENCE = 3;
  // const X = 0;
  // const Y = 1;
  // const WIDTH = 2;
  // const MU = 3;
  // const keys = ['x', 'y', 'width', 'mu'];

  /**
   * Fits a set of points to the sum of a set of bell functions.
   * @param {object} data - An object containing the x and y data to be fitted.
   * @param {array} peaks - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
   * @param {object} [options = {}]
   * @param {object} [options.shape={}] - it's specify the kind of shape used to fitting.
   * @param {string} [options.shape.kind = 'gaussian'] - kind of shape; lorentzian, gaussian and pseudovoigt are supported.
   * @param {object} [options.optimization = {}] - it's specify the kind and options of the algorithm use to optimize parameters.
   * @param {object} [options.optimization.kind = 'lm'] - kind of algorithm. By default it's levenberg-marquardt.
   * @param {object} [options.optimization.parameters] - options of each parameter to be optimized e.g. For a gaussian shape
   *  it could have x, y and with properties, each of which could contain init, min, max and gradientDifference, those options will define the guess,
   *  the min and max value of the parameter (search space) and the step size to approximate the jacobian matrix respectively. Those options could be a number,
   *  array of numbers, callback, or array of callbacks. Each kind of shape has default parameters so it could be undefined.
   * @param {object} [options.optimization.parameters.x] - options for x parameter.
   * @param {number|callback|array<number|callback>} [options.optimization.parameters.x.init] - definition of the starting point of the parameter (the guess),
   *  if it is a callback the method pass the peak as the unique input, if it is an array the first element define the guess of the first peak and so on.
   * @param {number|callback|array<number|callback>} [options.optimization.parameters.x.min] - definition of the lower limit of the parameter,
   *  if it is a callback the method pass the peak as the unique input, if it is an array the first element define the min of the first peak and so on.
   * @param {number|callback|array<number|callback>} [options.optimization.parameters.x.max] - definition of the upper limit of the parameter,
   *  if it is a callback the method pass the peak as the unique input, if it is an array the first element define the max of the first peak and so on.
   * @param {number|callback|array<number|callback>} [options.optimization.parameters.x.gradientDifference] - definition of  the step size to approximate the jacobian matrix of the parameter,
   *  if it is a callback the method pass the peak as the unique input, if it is an array the first element define the gradientDifference of the first peak and so on.
   * @param {object} [options.optimization.options = {}] - options for the specific kind of algorithm.
   * @param {number} [options.optimization.options.timeout] - maximum time running before break in seconds.
   * @param {number} [options.optimization.options.damping=1.5]
   * @param {number} [options.optimization.options.maxIterations=100]
   * @param {number} [options.optimization.options.errorTolerance=1e-8]
   * @returns {object} - A object with fitting error and the list of optimized parameters { parameters: [ {x, y, width} ], error } if the kind of shape is pseudoVoigt mu parameter is optimized.
   */

  function optimize(data, peakList, options = {}) {
    const {
      y,
      x,
      maxY,
      peaks,
      paramsFunc,
      optimization
    } = checkInput(data, peakList, options);
    let parameters = optimization.parameters;
    let nbShapes = peaks.length;
    let parameterKey = Object.keys(parameters);
    let nbParams = nbShapes * parameterKey.length;
    let pMin = new Float64Array(nbParams);
    let pMax = new Float64Array(nbParams);
    let pInit = new Float64Array(nbParams);
    let gradientDifference = new Float64Array(nbParams);

    for (let i = 0; i < nbShapes; i++) {
      let peak = peaks[i];

      for (let k = 0; k < parameterKey.length; k++) {
        let key = parameterKey[k];
        let init = parameters[key].init;
        let min = parameters[key].min;
        let max = parameters[key].max;
        let gradientDifferenceValue = parameters[key].gradientDifference;
        pInit[i + k * nbShapes] = init[i % init.length](peak);
        pMin[i + k * nbShapes] = min[i % min.length](peak);
        pMax[i + k * nbShapes] = max[i % max.length](peak);
        gradientDifference[i + k * nbShapes] = gradientDifferenceValue[i % gradientDifferenceValue.length](peak);
      }
    }

    let {
      algorithm,
      optimizationOptions
    } = selectMethod(optimization);
    optimizationOptions.minValues = pMin;
    optimizationOptions.maxValues = pMax;
    optimizationOptions.initialValues = pInit;
    optimizationOptions.gradientDifference = gradientDifference;
    let pFit = algorithm({
      x,
      y
    }, paramsFunc, optimizationOptions);
    let {
      parameterError: error,
      iterations
    } = pFit;
    let result = {
      error,
      iterations,
      peaks
    };

    for (let i = 0; i < nbShapes; i++) {
      pFit.parameterValues[i + nbShapes] *= maxY;

      for (let k = 0; k < parameterKey.length; k++) {
        // we modify the optimized parameters
        peaks[i][parameterKey[k]] = pFit.parameterValues[i + k * nbShapes];
      }
    }

    return result;
  }

  /**
   * This function returns an array with absolute values
   * @param {Array<Number>} array
   * @return {Number}
   */
  function xAbsolute(array) {
    let tmpArray = array.slice();

    for (let i = 0; i < tmpArray.length; i++) {
      if (tmpArray[i] < 0) tmpArray[i] *= -1;
    }

    return tmpArray;
  }

  var medianQuickselect_min = {exports: {}};

  (function (module) {
    (function () {
      function a(d) {
        for (var e = 0, f = d.length - 1, g = void 0, h = void 0, i = void 0, j = c(e, f); !0;) {
          if (f <= e) return d[j];
          if (f == e + 1) return d[e] > d[f] && b(d, e, f), d[j];

          for (g = c(e, f), d[g] > d[f] && b(d, g, f), d[e] > d[f] && b(d, e, f), d[g] > d[e] && b(d, g, e), b(d, g, e + 1), h = e + 1, i = f; !0;) {
            do h++; while (d[e] > d[h]);

            do i--; while (d[i] > d[e]);

            if (i < h) break;
            b(d, h, i);
          }

          b(d, e, i), i <= j && (e = h), i >= j && (f = i - 1);
        }
      }

      var b = function b(d, e, f) {
        var _ref;

        return _ref = [d[f], d[e]], d[e] = _ref[0], d[f] = _ref[1], _ref;
      },
          c = function c(d, e) {
        return ~~((d + e) / 2);
      };

      module.exports ? module.exports = a : window.median = a;
    })();
  })(medianQuickselect_min);

  var quickSelectMedian = medianQuickselect_min.exports;

  function median(input) {
    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    }

    if (input.length === 0) {
      throw new TypeError('input must not be empty');
    }

    return quickSelectMedian(input.slice());
  }

  /**
   * This function calculates the median after taking the reimAbsolute values of the points
   * @param {Array<Number>} array - the array that will be rotated
   * @return {Number}
   */

  function xAbsoluteMedian(array) {
    return median(xAbsolute(array));
  }

  /**
   * Returns the closest index of a `target` in an ordered array
   * @param {array<Number>} array
   * @param {number} target
   */
  function xFindClosestIndex(array, target) {
    let low = 0;
    let high = array.length - 1;
    let middle = 0;

    while (high - low > 1) {
      middle = low + (high - low >> 1);

      if (array[middle] < target) {
        low = middle;
      } else if (array[middle] > target) {
        high = middle;
      } else {
        return middle;
      }
    }

    if (low < array.length - 1) {
      if (Math.abs(target - array[low]) < Math.abs(array[low + 1] - target)) {
        return low;
      } else {
        return low + 1;
      }
    } else {
      return low;
    }
  }

  /**
   * Returns an object with {fromIndex, toIndex} for a specific from / to
   * @param {array} x
   * @param {object} [options={}]
   * @param {number} [options.from] - First value for xyIntegration in the X scale
   * @param {number} [options.fromIndex=0] - First point for xyIntegration
   * @param {number} [options.to] - Last value for xyIntegration in the X scale
   * @param {number} [options.toIndex=x.length-1] - Last point for xyIntegration
   */

  function xGetFromToIndex(x, options = {}) {
    let {
      fromIndex,
      toIndex,
      from,
      to
    } = options;

    if (fromIndex === undefined) {
      if (from !== undefined) {
        fromIndex = xFindClosestIndex(x, from);
      } else {
        fromIndex = 0;
      }
    }

    if (toIndex === undefined) {
      if (to !== undefined) {
        toIndex = xFindClosestIndex(x, to);
      } else {
        toIndex = x.length - 1;
      }
    }

    if (fromIndex > toIndex) [fromIndex, toIndex] = [toIndex, fromIndex];
    return {
      fromIndex,
      toIndex
    };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";

    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }
  /**
   * Fill an array with sequential numbers
   * @param {Array<number>} [input] - optional destination array (if not provided a new array will be created)
   * @param {object} [options={}]
   * @param {number} [options.from=0] - first value in the array
   * @param {number} [options.to=10] - last value in the array
   * @param {number} [options.size=input.length] - size of the array (if not provided calculated from step)
   * @param {number} [options.step] - if not provided calculated from size
   * @return {Array<number>}
   */


  function sequentialFill() {
    var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (_typeof(input) === 'object' && !isAnyArray(input)) {
      options = input;
      input = [];
    }

    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    }

    var _options = options,
        _options$from = _options.from,
        from = _options$from === void 0 ? 0 : _options$from,
        _options$to = _options.to,
        to = _options$to === void 0 ? 10 : _options$to,
        _options$size = _options.size,
        size = _options$size === void 0 ? input.length : _options$size,
        step = _options.step;

    if (size !== 0 && step) {
      throw new Error('step is defined by the array size');
    }

    if (!size) {
      if (step) {
        size = Math.floor((to - from) / step) + 1;
      } else {
        size = to - from + 1;
      }
    }

    if (!step && size) {
      step = (to - from) / (size - 1);
    }

    if (Array.isArray(input)) {
      // only works with normal array
      input.length = 0;

      for (var i = 0; i < size; i++) {
        input.push(from);
        from += step;
      }
    } else {
      if (input.length !== size) {
        throw new Error('sequentialFill typed array must have the correct length');
      }

      for (var _i = 0; _i < size; _i++) {
        input[_i] = from;
        from += step;
      }
    }

    return input;
  }

  var d3Array = {exports: {}};

  (function (module, exports) {
    (function (global, factory) {
      factory(exports) ;
    })(commonjsGlobal, function (exports) {

      function ascending(a, b) {
        return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
      }

      function bisector(compare) {
        if (compare.length === 1) compare = ascendingComparator(compare);
        return {
          left: function (a, x, lo, hi) {
            if (lo == null) lo = 0;
            if (hi == null) hi = a.length;

            while (lo < hi) {
              var mid = lo + hi >>> 1;
              if (compare(a[mid], x) < 0) lo = mid + 1;else hi = mid;
            }

            return lo;
          },
          right: function (a, x, lo, hi) {
            if (lo == null) lo = 0;
            if (hi == null) hi = a.length;

            while (lo < hi) {
              var mid = lo + hi >>> 1;
              if (compare(a[mid], x) > 0) hi = mid;else lo = mid + 1;
            }

            return lo;
          }
        };
      }

      function ascendingComparator(f) {
        return function (d, x) {
          return ascending(f(d), x);
        };
      }

      var ascendingBisect = bisector(ascending);
      var bisectRight = ascendingBisect.right;
      var bisectLeft = ascendingBisect.left;

      function descending(a, b) {
        return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
      }

      function number$1(x) {
        return x === null ? NaN : +x;
      }

      function variance(array, f) {
        var n = array.length,
            m = 0,
            a,
            d,
            s = 0,
            i = -1,
            j = 0;

        if (f == null) {
          while (++i < n) {
            if (!isNaN(a = number$1(array[i]))) {
              d = a - m;
              m += d / ++j;
              s += d * (a - m);
            }
          }
        } else {
          while (++i < n) {
            if (!isNaN(a = number$1(f(array[i], i, array)))) {
              d = a - m;
              m += d / ++j;
              s += d * (a - m);
            }
          }
        }

        if (j > 1) return s / (j - 1);
      }

      function deviation(array, f) {
        var v = variance(array, f);
        return v ? Math.sqrt(v) : v;
      }

      function extent(array, f) {
        var i = -1,
            n = array.length,
            a,
            b,
            c;

        if (f == null) {
          while (++i < n) if ((b = array[i]) != null && b >= b) {
            a = c = b;
            break;
          }

          while (++i < n) if ((b = array[i]) != null) {
            if (a > b) a = b;
            if (c < b) c = b;
          }
        } else {
          while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
            a = c = b;
            break;
          }

          while (++i < n) if ((b = f(array[i], i, array)) != null) {
            if (a > b) a = b;
            if (c < b) c = b;
          }
        }

        return [a, c];
      }

      function constant(x) {
        return function () {
          return x;
        };
      }

      function identity(x) {
        return x;
      }

      function range(start, stop, step) {
        start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;
        var i = -1,
            n = Math.max(0, Math.ceil((stop - start) / step)) | 0,
            range = new Array(n);

        while (++i < n) {
          range[i] = start + i * step;
        }

        return range;
      }

      var e10 = Math.sqrt(50);
      var e5 = Math.sqrt(10);
      var e2 = Math.sqrt(2);

      function ticks(start, stop, count) {
        var step = tickStep(start, stop, count);
        return range(Math.ceil(start / step) * step, Math.floor(stop / step) * step + step / 2, // inclusive
        step);
      }

      function tickStep(start, stop, count) {
        var step0 = Math.abs(stop - start) / Math.max(0, count),
            step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),
            error = step0 / step1;
        if (error >= e10) step1 *= 10;else if (error >= e5) step1 *= 5;else if (error >= e2) step1 *= 2;
        return stop < start ? -step1 : step1;
      }

      function sturges(values) {
        return Math.ceil(Math.log(values.length) / Math.LN2) + 1;
      }

      function number(x) {
        return +x;
      }

      function histogram() {
        var value = identity,
            domain = extent,
            threshold = sturges;

        function histogram(data) {
          var i,
              n = data.length,
              x,
              values = new Array(n); // Coerce values to numbers.

          for (i = 0; i < n; ++i) {
            values[i] = +value(data[i], i, data);
          }

          var xz = domain(values),
              x0 = +xz[0],
              x1 = +xz[1],
              tz = threshold(values, x0, x1); // Convert number of thresholds into uniform thresholds.

          if (!Array.isArray(tz)) tz = ticks(x0, x1, +tz); // Coerce thresholds to numbers, ignoring any outside the domain.

          var m = tz.length;

          for (i = 0; i < m; ++i) tz[i] = +tz[i];

          while (tz[0] <= x0) tz.shift(), --m;

          while (tz[m - 1] >= x1) tz.pop(), --m;

          var bins = new Array(m + 1),
              bin; // Initialize bins.

          for (i = 0; i <= m; ++i) {
            bin = bins[i] = [];
            bin.x0 = i > 0 ? tz[i - 1] : x0;
            bin.x1 = i < m ? tz[i] : x1;
          } // Assign data to bins by value, ignoring any outside the domain.


          for (i = 0; i < n; ++i) {
            x = values[i];

            if (x0 <= x && x <= x1) {
              bins[bisectRight(tz, x, 0, m)].push(data[i]);
            }
          }

          return bins;
        }

        histogram.value = function (_) {
          return arguments.length ? (value = typeof _ === "function" ? _ : constant(+_), histogram) : value;
        };

        histogram.domain = function (_) {
          return arguments.length ? (domain = typeof _ === "function" ? _ : constant([+_[0], +_[1]]), histogram) : domain;
        };

        histogram.thresholds = function (_) {
          if (!arguments.length) return threshold;
          threshold = typeof _ === "function" ? _ : Array.isArray(_) ? constant(Array.prototype.map.call(_, number)) : constant(+_);
          return histogram;
        };

        return histogram;
      }

      function quantile(array, p, f) {
        if (f == null) f = number$1;
        if (!(n = array.length)) return;
        if ((p = +p) <= 0 || n < 2) return +f(array[0], 0, array);
        if (p >= 1) return +f(array[n - 1], n - 1, array);
        var n,
            h = (n - 1) * p,
            i = Math.floor(h),
            a = +f(array[i], i, array),
            b = +f(array[i + 1], i + 1, array);
        return a + (b - a) * (h - i);
      }

      function freedmanDiaconis(values, min, max) {
        values.sort(ascending);
        return Math.ceil((max - min) / (2 * (quantile(values, 0.75) - quantile(values, 0.25)) * Math.pow(values.length, -1 / 3)));
      }

      function scott(values, min, max) {
        return Math.ceil((max - min) / (3.5 * deviation(values) * Math.pow(values.length, -1 / 3)));
      }

      function max(array, f) {
        var i = -1,
            n = array.length,
            a,
            b;

        if (f == null) {
          while (++i < n) if ((b = array[i]) != null && b >= b) {
            a = b;
            break;
          }

          while (++i < n) if ((b = array[i]) != null && b > a) a = b;
        } else {
          while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
            a = b;
            break;
          }

          while (++i < n) if ((b = f(array[i], i, array)) != null && b > a) a = b;
        }

        return a;
      }

      function mean(array, f) {
        var s = 0,
            n = array.length,
            a,
            i = -1,
            j = n;

        if (f == null) {
          while (++i < n) if (!isNaN(a = number$1(array[i]))) s += a;else --j;
        } else {
          while (++i < n) if (!isNaN(a = number$1(f(array[i], i, array)))) s += a;else --j;
        }

        if (j) return s / j;
      }

      function median(array, f) {
        var numbers = [],
            n = array.length,
            a,
            i = -1;

        if (f == null) {
          while (++i < n) if (!isNaN(a = number$1(array[i]))) numbers.push(a);
        } else {
          while (++i < n) if (!isNaN(a = number$1(f(array[i], i, array)))) numbers.push(a);
        }

        return quantile(numbers.sort(ascending), 0.5);
      }

      function merge(arrays) {
        var n = arrays.length,
            m,
            i = -1,
            j = 0,
            merged,
            array;

        while (++i < n) j += arrays[i].length;

        merged = new Array(j);

        while (--n >= 0) {
          array = arrays[n];
          m = array.length;

          while (--m >= 0) {
            merged[--j] = array[m];
          }
        }

        return merged;
      }

      function min(array, f) {
        var i = -1,
            n = array.length,
            a,
            b;

        if (f == null) {
          while (++i < n) if ((b = array[i]) != null && b >= b) {
            a = b;
            break;
          }

          while (++i < n) if ((b = array[i]) != null && a > b) a = b;
        } else {
          while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
            a = b;
            break;
          }

          while (++i < n) if ((b = f(array[i], i, array)) != null && a > b) a = b;
        }

        return a;
      }

      function pairs(array) {
        var i = 0,
            n = array.length - 1,
            p = array[0],
            pairs = new Array(n < 0 ? 0 : n);

        while (i < n) pairs[i] = [p, p = array[++i]];

        return pairs;
      }

      function permute(array, indexes) {
        var i = indexes.length,
            permutes = new Array(i);

        while (i--) permutes[i] = array[indexes[i]];

        return permutes;
      }

      function scan(array, compare) {
        if (!(n = array.length)) return;
        var i = 0,
            n,
            j = 0,
            xi,
            xj = array[j];
        if (!compare) compare = ascending;

        while (++i < n) if (compare(xi = array[i], xj) < 0 || compare(xj, xj) !== 0) xj = xi, j = i;

        if (compare(xj, xj) === 0) return j;
      }

      function shuffle(array, i0, i1) {
        var m = (i1 == null ? array.length : i1) - (i0 = i0 == null ? 0 : +i0),
            t,
            i;

        while (m) {
          i = Math.random() * m-- | 0;
          t = array[m + i0];
          array[m + i0] = array[i + i0];
          array[i + i0] = t;
        }

        return array;
      }

      function sum(array, f) {
        var s = 0,
            n = array.length,
            a,
            i = -1;

        if (f == null) {
          while (++i < n) if (a = +array[i]) s += a; // Note: zero and null are equivalent.

        } else {
          while (++i < n) if (a = +f(array[i], i, array)) s += a;
        }

        return s;
      }

      function transpose(matrix) {
        if (!(n = matrix.length)) return [];

        for (var i = -1, m = min(matrix, length), transpose = new Array(m); ++i < m;) {
          for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n;) {
            row[j] = matrix[j][i];
          }
        }

        return transpose;
      }

      function length(d) {
        return d.length;
      }

      function zip() {
        return transpose(arguments);
      }

      var version = "0.7.1";
      exports.version = version;
      exports.bisect = bisectRight;
      exports.bisectRight = bisectRight;
      exports.bisectLeft = bisectLeft;
      exports.ascending = ascending;
      exports.bisector = bisector;
      exports.descending = descending;
      exports.deviation = deviation;
      exports.extent = extent;
      exports.histogram = histogram;
      exports.thresholdFreedmanDiaconis = freedmanDiaconis;
      exports.thresholdScott = scott;
      exports.thresholdSturges = sturges;
      exports.max = max;
      exports.mean = mean;
      exports.median = median;
      exports.merge = merge;
      exports.min = min;
      exports.pairs = pairs;
      exports.permute = permute;
      exports.quantile = quantile;
      exports.range = range;
      exports.scan = scan;
      exports.shuffle = shuffle;
      exports.sum = sum;
      exports.ticks = ticks;
      exports.tickStep = tickStep;
      exports.transpose = transpose;
      exports.variance = variance;
      exports.zip = zip;
    });
  })(d3Array, d3Array.exports);

  const {
    bisectRight
  } = d3Array.exports;

  const quincunx = (u, v, w, q) => {
    const n = u.length - 1;
    u[0] = 0;
    v[0] = 0;
    w[0] = 0;
    v[1] = v[1] / u[1];
    w[1] = w[1] / u[1];

    for (let i = 2; i < n; ++i) {
      u[i] = u[i] - u[i - 2] * w[i - 2] * w[i - 2] - u[i - 1] * v[i - 1] * v[i - 1];
      v[i] = (v[i] - u[i - 1] * v[i - 1] * w[i - 1]) / u[i];
      w[i] = w[i] / u[i];
    }

    for (let i = 2; i < n; ++i) {
      q[i] = q[i] - v[i - 1] * q[i - 1] - w[i - 2] * q[i - 2];
    }

    for (let i = 1; i < n; ++i) {
      q[i] = q[i] / u[i];
    }

    q[n - 2] = q[n - 2] - v[n - 2] * q[n - 1];

    for (let i = n - 3; i > 0; --i) {
      q[i] = q[i] - v[i] * q[i + 1] - w[i] * q[i + 2];
    }
  };

  const smoothingSpline = (x, y, sigma, lambda) => {
    const n = x.length - 1;
    const h = new Array(n + 1);
    const r = new Array(n + 1);
    const f = new Array(n + 1);
    const p = new Array(n + 1);
    const q = new Array(n + 1);
    const u = new Array(n + 1);
    const v = new Array(n + 1);
    const w = new Array(n + 1);
    const params = x.map(() => [0, 0, 0, 0]);
    params.pop();
    const mu = 2 * (1 - lambda) / (3 * lambda);

    for (let i = 0; i < n; ++i) {
      h[i] = x[i + 1] - x[i];
      r[i] = 3 / h[i];
    }

    q[0] = 0;

    for (let i = 1; i < n; ++i) {
      f[i] = -(r[i - 1] + r[i]);
      p[i] = 2 * (x[i + 1] - x[i - 1]);
      q[i] = 3 * (y[i + 1] - y[i]) / h[i] - 3 * (y[i] - y[i - 1]) / h[i - 1];
    }

    q[n] = 0;

    for (let i = 1; i < n; ++i) {
      u[i] = r[i - 1] * r[i - 1] * sigma[i - 1] + f[i] * f[i] * sigma[i] + r[i] * r[i] * sigma[i + 1];
      u[i] = mu * u[i] + p[i];
    }

    for (let i = 1; i < n - 1; ++i) {
      v[i] = f[i] * r[i] * sigma[i] + r[i] * f[i + 1] * sigma[i + 1];
      v[i] = mu * v[i] + h[i];
    }

    for (let i = 1; i < n - 2; ++i) {
      w[i] = mu * r[i] * r[i + 1] * sigma[i + 1];
    }

    quincunx(u, v, w, q);
    params[0][3] = y[0] - mu * r[0] * q[1] * sigma[0];
    params[1][3] = y[1] - mu * (f[1] * q[1] + r[1] * q[2]) * sigma[0];
    params[0][0] = q[1] / (3 * h[0]);
    params[0][1] = 0;
    params[0][2] = (params[1][3] - params[0][3]) / h[0] - q[1] * h[0] / 3;
    r[0] = 0;

    for (let i = 1; i < n; ++i) {
      params[i][0] = (q[i + 1] - q[i]) / (3 * h[i]);
      params[i][1] = q[i];
      params[i][2] = (q[i] + q[i - 1]) * h[i - 1] + params[i - 1][2];
      params[i][3] = r[i - 1] * q[i - 1] + f[i] * q[i] + r[i] * q[i + 1];
      params[i][3] = y[i] - mu * params[i][3] * sigma[i];
    }

    return params;
  };

  class SplineInterpolator {
    constructor(xIn, yIn, lambda = 1) {
      const indices = xIn.map((_, i) => i);
      indices.sort((i, j) => xIn[i] - xIn[j]);
      const x = indices.map(i => xIn[i]);
      const y = indices.map(i => yIn[i]);
      const n = indices.length;
      const sigma = indices.map(() => 1);
      this.n = n;
      this.x = x;
      this.y = y;
      this.params = smoothingSpline(x, y, sigma, lambda);
    }

    interpolate(v) {
      if (v === this.x[this.n - 1]) {
        return this.y[this.n - 1];
      }

      const i = Math.min(Math.max(0, bisectRight(this.x, v) - 1), this.n - 2);
      const [a, b, c, d] = this.params[i];
      v = v - this.x[i];
      return a * v * v * v + b * v * v + c * v + d;
    }

    max(step = 100) {
      const xStart = this.x[0];
      const xStop = this.x[this.n - 1];
      const delta = (xStop - xStart) / step;
      let maxValue = -Infinity;

      for (let i = 0, x = xStart; i < step; ++i, x += delta) {
        const y = this.interpolate(x);

        if (y > maxValue) {
          maxValue = y;
        }
      }

      return maxValue;
    }

    min(step = 100) {
      const xStart = this.x[0];
      const xStop = this.x[this.n - 1];
      const delta = (xStop - xStart) / step;
      let minValue = Infinity;

      for (let i = 0, x = xStart; i < step; ++i, x += delta) {
        const y = this.interpolate(x);

        if (y < minValue) {
          minValue = y;
        }
      }

      return minValue;
    }

    domain() {
      return [this.x[0], this.x[this.x.length - 1]];
    }

    range() {
      return [this.min(), this.max()];
    }

    curve(nInterval, domain = null) {
      domain = domain || this.domain();
      const delta = (domain[1] - domain[0]) / (nInterval - 1);
      const vals = new Array(nInterval);

      for (let i = 0; i < nInterval; ++i) {
        const x = delta * i + domain[0];
        vals[i] = [x, this.interpolate(x)];
      }

      return vals;
    }

  }

  var splineInterpolator = SplineInterpolator;

  /* eslint-disable no-loss-of-precision */

  /*
  Adapted from: https://github.com/compute-io/erfcinv/blob/aa116e23883839359e310ad41a7c42f72815fc1e/lib/number.js

  The MIT License (MIT)

  Copyright (c) 2014-2015 The Compute.io Authors. All rights reserved.

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all
  copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.


  Boost Software License - Version 1.0 - August 17th, 2003

  Permission is hereby granted, free of charge, to any person or organization obtaining a copy of the software and accompanying documentation covered by this license (the "Software") to use, reproduce, display, distribute, execute, and transmit the Software, and to prepare derivative works of the Software, and to permit third-parties to whom the Software is furnished to do so, all subject to the following:

  The copyright notices in the Software and this entire statement, including the above license grant, this restriction and the following disclaimer, must be included in all copies of the Software, in whole or in part, and all derivative works of the Software, unless such copies or derivative works are solely in the form of machine-executable object code generated by a source language processor.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
  */
  // Coefficients for erfcinv on [0, 0.5]:
  const Y1 = 8.91314744949340820313e-2;
  const P1 = [-5.38772965071242932965e-3, 8.22687874676915743155e-3, 2.19878681111168899165e-2, -3.65637971411762664006e-2, -1.26926147662974029034e-2, 3.34806625409744615033e-2, -8.36874819741736770379e-3, -5.08781949658280665617e-4];
  const Q1 = [8.86216390456424707504e-4, -2.33393759374190016776e-3, 7.95283687341571680018e-2, -5.27396382340099713954e-2, -7.1228902341542847553e-1, 6.62328840472002992063e-1, 1.56221558398423026363, -1.56574558234175846809, -9.70005043303290640362e-1, 1]; // Coefficients for erfcinv for 0.5 > 1-x >= 0:

  const Y2 = 2.249481201171875;
  const P2 = [-3.67192254707729348546, 2.11294655448340526258e1, 1.7445385985570866523e1, -4.46382324441786960818e1, -1.88510648058714251895e1, 1.76447298408374015486e1, 8.37050328343119927838, 1.05264680699391713268e-1, -2.02433508355938759655e-1];
  const Q2 = [1.72114765761200282724, -2.26436933413139721736e1, 1.08268667355460159008e1, 4.85609213108739935468e1, -2.01432634680485188801e1, -2.86608180499800029974e1, 3.9713437953343869095, 6.24264124854247537712, 1]; // Coefficients for erfcinv for sqrt( -log(1-x)):

  const Y3 = 8.07220458984375e-1;
  const P3 = [-6.81149956853776992068e-10, 2.85225331782217055858e-8, -6.79465575181126350155e-7, 2.14558995388805277169e-3, 2.90157910005329060432e-2, 1.42869534408157156766e-1, 3.37785538912035898924e-1, 3.87079738972604337464e-1, 1.17030156341995252019e-1, -1.63794047193317060787e-1, -1.31102781679951906451e-1];
  const Q3 = [1.105924229346489121e-2, 1.52264338295331783612e-1, 8.48854343457902036425e-1, 2.59301921623620271374, 4.77846592945843778382, 5.38168345707006855425, 3.46625407242567245975, 1];
  const Y4 = 9.3995571136474609375e-1;
  const P4 = [2.66339227425782031962e-12, -2.30404776911882601748e-10, 4.60469890584317994083e-6, 1.57544617424960554631e-4, 1.87123492819559223345e-3, 9.50804701325919603619e-3, 1.85573306514231072324e-2, -2.22426529213447927281e-3, -3.50353787183177984712e-2];
  const Q4 = [7.64675292302794483503e-5, 2.63861676657015992959e-3, 3.41589143670947727934e-2, 2.20091105764131249824e-1, 7.62059164553623404043e-1, 1.3653349817554063097, 1];
  const Y5 = 9.8362827301025390625e-1;
  const P5 = [9.9055709973310326855e-17, -2.81128735628831791805e-14, 4.62596163522878599135e-9, 4.49696789927706453732e-7, 1.49624783758342370182e-5, 2.09386317487588078668e-4, 1.05628862152492910091e-3, -1.12951438745580278863e-3, -1.67431005076633737133e-2];
  const Q5 = [2.82243172016108031869e-7, 2.75335474764726041141e-5, 9.64011807005165528527e-4, 1.60746087093676504695e-2, 1.38151865749083321638e-1, 5.91429344886417493481e-1, 1];

  function polyval(c, x) {
    let p = 0;

    for (const coef of c) {
      p = p * x + coef;
    }

    return p;
  }
  /**
   * Calculates a rational approximation.
   *
   * @private
   * @param {Number} x
   * @param {Number} v
   * @param {Array} P - array of polynomial coefficients
   * @param {Array} Q - array of polynomial coefficients
   * @param {Number} Y
   * @returns {Number} rational approximation
   */


  function calc(x, v, P, Q, Y) {
    const s = x - v;
    const r = polyval(P, s) / polyval(Q, s);
    return Y * x + r * x;
  }
  /**
   * Evaluates the complementary inverse error function for an input value.
   *
   * @private
   * @param {Number} x - input value
   * @returns {Number} evaluated complementary inverse error function
   */


  function erfcinv(x) {
    let sign = false;
    let val;
    let q;
    let g;
    let r; // [1] Special cases...
    // NaN:

    if (Number.isNaN(x)) {
      return NaN;
    } // x not on the interval: [0,2]


    if (x < 0 || x > 2) {
      throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${x}\`.`);
    }

    if (x === 0) {
      return Number.POSITIVE_INFINITY;
    }

    if (x === 2) {
      return Number.NEGATIVE_INFINITY;
    }

    if (x === 1) {
      return 0;
    } // [2] Get the sign and make use of `erfc` reflection formula: `erfc(-z)=2 - erfc(z)`...


    if (x > 1) {
      q = 2 - x;
      x = 1 - q;
      sign = true;
    } else {
      q = x;
      x = 1 - x;
    } // [3] |x| <= 0.5


    if (x <= 0.5) {
      g = x * (x + 10);
      r = polyval(P1, x) / polyval(Q1, x);
      val = g * Y1 + g * r;
      return sign ? -val : val;
    } // [4] 1-|x| >= 0.25


    if (q >= 0.25) {
      g = Math.sqrt(-2 * Math.log(q));
      q = q - 0.25;
      r = polyval(P2, q) / polyval(Q2, q);
      val = g / (Y2 + r);
      return sign ? -val : val;
    }

    q = Math.sqrt(-Math.log(q)); // [5] q < 3

    if (q < 3) {
      return calc(q, 1.125, P3, Q3, Y3);
    } // [6] q < 6


    if (q < 6) {
      return calc(q, 3, P4, Q4, Y4);
    } // Note that the smallest number in JavaScript is 5e-324. Math.sqrt( -Math.log( 5e-324 ) ) ~27.2844


    return calc(q, 6, P5, Q5, Y5); // Note that in the boost library, they are able to go to much smaller values, as 128 bit long doubles support ~1e-5000; something which JavaScript does not natively support.
  }

  function rayleighCdf(x, sigma = 1) {
    if (x < 0) {
      return 0;
    }

    return -Math.expm1(-Math.pow(x, 2) / (2 * Math.pow(sigma, 2)));
  }

  /**
   * Determine noise level by san plot methodology (https://doi.org/10.1002/mrc.4882)
   * @param {Array} data - real or magnitude spectra data.
   * @param {object} [options = {}]
   * @param {array} [options.mask] - boolean array to filter data, if the i-th element is true then the i-th element of the distribution will be ignored.
   * @param {number} [options.scaleFactor=1] - factor to scale the data input[i]*=scaleFactor.
   * @param {number} [options.cutOff] - percent of positive signal distribution where the noise level will be determined, if it is not defined the program calculate it.
   * @param {number} [options.factorStd=5] - factor times std to determine what will be marked as signals.
   * @param {boolean} [options.refine=true] - if true the noise level will be recalculated get out the signals using factorStd.
   * @param {boolean} [options.fixOffset=true] - If the baseline is correct, the midpoint of distribution should be zero. if true, the distribution will be centered.
   * @param {number} [options.logBaseY=2] - log scale to apply in the intensity axis in order to avoid big numbers.
   */

  function xNoiseSanPlot(data, options = {}) {
    const {
      mask,
      cutOff,
      refine = true,
      magnitudeMode = false,
      scaleFactor = 1,
      factorStd = 5,
      fixOffset = true
    } = options;
    let input;

    if (Array.isArray(mask) && mask.length === data.length) {
      input = new Float64Array(data.filter((_e, i) => !mask[i]));
    } else {
      input = new Float64Array(data);
    }

    if (scaleFactor > 1) {
      for (let i = 0; i < input.length; i++) {
        input[i] *= scaleFactor;
      }
    }

    input = input.sort().reverse();

    if (fixOffset && !magnitudeMode) {
      let medianIndex = Math.floor(input.length / 2);
      let median = 0.5 * (input[medianIndex] + input[medianIndex + 1]);

      for (let i = 0; i < input.length; i++) {
        input[i] -= median;
      }
    }

    let firstNegativeValueIndex = input[input.length - 1] >= 0 ? input.length : input.findIndex(e => e < 0);
    let lastPositiveValueIndex = firstNegativeValueIndex - 1;

    for (let i = lastPositiveValueIndex; i >= 0; i--) {
      if (input[i] > 0) {
        lastPositiveValueIndex = i;
        break;
      }
    }

    let signPositive = input.slice(0, lastPositiveValueIndex + 1);
    let signNegative = input.slice(firstNegativeValueIndex);
    let cutOffDist = cutOff || determineCutOff(signPositive, {
      magnitudeMode
    });
    let pIndex = Math.floor(signPositive.length * cutOffDist);
    let initialNoiseLevelPositive = signPositive[pIndex];
    let skyPoint = signPositive[0];
    let initialNoiseLevelNegative;

    if (signNegative.length > 0) {
      let nIndex = Math.floor(signNegative.length * (1 - cutOffDist));
      initialNoiseLevelNegative = -1 * signNegative[nIndex];
    } else {
      initialNoiseLevelNegative = 0;
    }

    let noiseLevelPositive = initialNoiseLevelPositive;
    let noiseLevelNegative = initialNoiseLevelNegative;
    let cloneSignPositive = signPositive.slice();
    let cloneSignNegative = signNegative.slice();
    let cutOffSignalsIndexPlus = 0;
    let cutOffSignalsIndexNeg = 2;

    if (refine) {
      let cutOffSignals = noiseLevelPositive * factorStd;
      cutOffSignalsIndexPlus = signPositive.findIndex(e => e < cutOffSignals);

      if (cutOffSignalsIndexPlus > -1) {
        cloneSignPositive = signPositive.slice(cutOffSignalsIndexPlus);
        noiseLevelPositive = cloneSignPositive[Math.floor(cloneSignPositive.length * cutOffDist)];
      }

      cutOffSignals = noiseLevelNegative * factorStd;
      cutOffSignalsIndexNeg = signNegative.findIndex(e => e < cutOffSignals);

      if (cutOffSignalsIndexNeg > -1) {
        cloneSignNegative = signNegative.slice(cutOffSignalsIndexNeg);
        noiseLevelNegative = cloneSignPositive[Math.floor(cloneSignNegative.length * (1 - cutOffDist))];
      }
    }

    let correctionFactor = -simpleNormInv(cutOffDist / 2, {
      magnitudeMode
    });
    initialNoiseLevelPositive = initialNoiseLevelPositive / correctionFactor;
    initialNoiseLevelNegative = initialNoiseLevelNegative / correctionFactor;
    let effectiveCutOffDist, refinedCorrectionFactor;

    if (refine && cutOffSignalsIndexPlus > -1) {
      effectiveCutOffDist = (cutOffDist * cloneSignPositive.length + cutOffSignalsIndexPlus) / (cloneSignPositive.length + cutOffSignalsIndexPlus);
      refinedCorrectionFactor = -1 * simpleNormInv(effectiveCutOffDist / 2, {
        magnitudeMode
      });
      noiseLevelPositive /= refinedCorrectionFactor;

      if (cutOffSignalsIndexNeg > -1) {
        effectiveCutOffDist = (cutOffDist * cloneSignNegative.length + cutOffSignalsIndexNeg) / (cloneSignNegative.length + cutOffSignalsIndexNeg);
        refinedCorrectionFactor = -1 * simpleNormInv(effectiveCutOffDist / 2, {
          magnitudeMode
        });

        if (noiseLevelNegative !== 0) {
          noiseLevelNegative /= refinedCorrectionFactor;
        }
      }
    } else {
      noiseLevelPositive /= correctionFactor;
      noiseLevelNegative /= correctionFactor;
    }

    return {
      positive: noiseLevelPositive,
      negative: noiseLevelNegative,
      snr: skyPoint / noiseLevelPositive,
      sanplot: generateSanPlot(input, {
        fromTo: {
          positive: {
            from: 0,
            to: lastPositiveValueIndex
          },
          negative: {
            from: firstNegativeValueIndex,
            to: input.length
          }
        }
      })
    };
  }

  function determineCutOff(signPositive, options = {}) {
    let {
      magnitudeMode = false,
      considerList = {
        from: 0.5,
        step: 0.1,
        to: 0.9
      }
    } = options; //generate a list of values for

    let cutOff = [];
    let indexMax = signPositive.length - 1;

    for (let i = 0.01; i <= 0.99; i += 0.01) {
      let index = Math.round(indexMax * i);
      let value = -signPositive[index] / simpleNormInv([i / 2], {
        magnitudeMode
      });
      cutOff.push([i, value]);
    }

    let minKi = Number.MAX_SAFE_INTEGER;
    let {
      from,
      to,
      step
    } = considerList;
    let delta = step / 2;
    let whereToCutStat = 0.5;

    for (let i = from; i <= to; i += step) {
      let floor = i - delta;
      let top = i + delta;
      let elementsOfCutOff = cutOff.filter(e => e[0] < top && e[0] > floor);
      let averageValue = elementsOfCutOff.reduce((a, b) => a + Math.abs(b[1]), 0);
      let kiSqrt = 0;

      for (let j = 0; j < elementsOfCutOff.length; j++) {
        kiSqrt += Math.pow(elementsOfCutOff[j][1] - averageValue, 2);
      }

      if (kiSqrt < minKi) {
        minKi = kiSqrt;
        whereToCutStat = i;
      }
    }

    return whereToCutStat;
  }

  function simpleNormInv(data, options = {}) {
    const {
      magnitudeMode = false
    } = options;
    if (!Array.isArray(data)) data = [data];
    let from = 0;
    let to = 2;
    let step = 0.01;
    let xTraining = createArray(from, to, step);
    let result = new Float64Array(data.length);
    let yTraining = new Float64Array(xTraining.length);

    if (magnitudeMode) {
      let factor = 1;

      for (let i = 0; i < yTraining.length; i++) {
        let finalInput = xTraining[i] * factor;
        yTraining[i] = 1 - rayleighCdf(finalInput);
      }

      let interp = new splineInterpolator(xTraining, yTraining);

      for (let i = 0; i < result.length; i++) {
        let yValue = 2 * data[i];
        result[i] = -1 * interp.interpolate(yValue);
      }
    } else {
      for (let i = 0; i < result.length; i++) {
        result[i] = -1 * Math.SQRT2 * erfcinv(2 * data[i]);
      }
    }

    return result.length === 1 ? result[0] : result;
  }

  function createArray(from, to, step) {
    let result = new Array(Math.abs((from - to) / step + 1));

    for (let i = 0; i < result.length; i++) {
      result[i] = from + i * step;
    }

    return result;
  }

  function generateSanPlot(array, options = {}) {
    const {
      fromTo,
      logBaseY = 2
    } = options;
    let sanplot = {};

    for (let key in fromTo) {
      let {
        from,
        to
      } = fromTo[key];
      sanplot[key] = from !== to ? scale(array.slice(from, to), {
        logBaseY
      }) : {
        x: [],
        y: []
      };

      if (key === 'negative') {
        sanplot[key].y.reverse();
      }
    }

    return sanplot;
  }

  function scale(array, options = {}) {
    const {
      log10,
      abs
    } = Math;
    const {
      logBaseY
    } = options;

    if (logBaseY) {
      array = array.slice();
      const logOfBase = log10(logBaseY);

      for (let i = 0; i < array.length; i++) {
        array[i] = log10(abs(array[i])) / logOfBase;
      }
    }

    const xAxis = sequentialFill({
      from: 0,
      to: array.length - 1,
      size: array.length
    });
    return {
      x: xAxis,
      y: array
    };
  }

  function sum(input) {
    if (!isAnyArray(input)) {
      throw new TypeError('input must be an array');
    }

    if (input.length === 0) {
      throw new TypeError('input must not be empty');
    }

    var sumValue = 0;

    for (var i = 0; i < input.length; i++) {
      sumValue += input[i];
    }

    return sumValue;
  }

  function mean(input) {
    return sum(input) / input.length;
  }

  /**
   * Throw an error in no an object of x,y arrays
   * @param {DataXY} [data={}]
   */

  function xyCheck(data = {}) {
    if (!isAnyArray(data.x) || !isAnyArray(data.y)) {
      throw new Error('Data must be an object of x and y arrays');
    }

    if (data.x.length !== data.y.length) {
      throw new Error('The x and y arrays mush have the same length');
    }
  }

  /**
   * Normalize an array of zones:
   * - ensure than from < to
   * - merge overlapping zones
   * @param {Array<Zone>} [zones=[]]
   * @param {object} [options={}]
   * @param {number} [options.from=Number.MIN_VALUE]
   * @param {number} [options.to=Number.MAX_VALUE]
   */
  function zonesNormalize(zones = [], options = {}) {
    if (zones.length === 0) return [];
    zones = JSON.parse(JSON.stringify(zones)).map(zone => zone.from > zone.to ? {
      from: zone.to,
      to: zone.from
    } : zone);
    let {
      from = Number.NEGATIVE_INFINITY,
      to = Number.POSITIVE_INFINITY
    } = options;

    if (from > to) {
      [from, to] = [to, from];
    }

    zones = zones.sort((a, b) => {
      if (a.from !== b.from) return a.from - b.from;
      return a.to - b.to;
    });
    zones.forEach(zone => {
      if (from > zone.from) zone.from = from;
      if (to < zone.to) zone.to = to;
    });
    zones = zones.filter(zone => zone.from <= zone.to);
    if (zones.length === 0) return [];
    let currentZone = zones[0];
    let result = [currentZone];

    for (let zone of zones) {
      if (zone.from <= currentZone.to) {
        currentZone.to = zone.to;
      } else {
        currentZone = zone;
        result.push(currentZone);
      }
    }

    return result;
  }

  /**
   * xyExtract zones from a XY data
   * @param {DataXY} [data={}] - Object that contains property x (an ordered increasing array) and y (an array)
   * @param {object} [options={}]
   * @param {Array} [options.zones=[]]
   * @return {Array} Array of points
   */

  function xyExtract(data = {}, options = {}) {
    xyCheck(data);
    const {
      x,
      y
    } = data;
    let {
      zones
    } = options;
    zones = zonesNormalize(zones);
    if (!Array.isArray(zones) || zones.length === 0) return data;
    let newX = [];
    let newY = [];
    let currentZone = zones[0];
    let position = 0;

    loop: for (let i = 0; i < x.length; i++) {
      while (currentZone.to < x[i]) {
        position++;
        currentZone = zones[position];

        if (!currentZone) {
          i = x.length;
          break loop;
        }
      }

      if (x[i] >= currentZone.from) {
        newX.push(x[i]);
        newY.push(y[i]);
      }
    }

    return {
      x: newX,
      y: newY
    };
  }

  /**
   * Calculate integration
   * @param {DataXY} [data={}] - Object that contains property x (an ordered increasing array) and y (an array)
   * @param {object} [options={}]
   * @param {number} [options.from] - First value for xyIntegration in the X scale
   * @param {number} [options.fromIndex=0] - First point for xyIntegration
   * @param {number} [options.to] - Last value for xyIntegration in the X scale
   * @param {number} [options.toIndex=x.length-1] - Last point for xyIntegration
   * @return {number} xyIntegration value on the specified range
   */

  function xyIntegration(data = {}, options = {}) {
    xyCheck(data);
    const {
      x,
      y
    } = data;
    if (x.length < 2) return 0;
    const {
      fromIndex,
      toIndex
    } = xGetFromToIndex(x, options);
    let currentxyIntegration = 0;

    for (let i = fromIndex; i < toIndex; i++) {
      currentxyIntegration += (x[i + 1] - x[i]) * (y[i + 1] + y[i]) / 2;
    }

    return currentxyIntegration;
  }

  /**
   * Group peaks based on factor and add group property in peaks
   * @param {array} peakList
   * @param {number} factor
   */
  function groupPeaks(peakList, factor = 1) {
    if (peakList.length === 0) return [];
    let peaks = peakList.sort((a, b) => a.x - b.x);
    let previousPeak = {
      x: Number.NEGATIVE_INFINITY,
      width: 1
    };
    let currentGroup = [previousPeak];
    let groups = [];

    for (let peak of peaks) {
      if ((peak.x - previousPeak.x) / (peak.width + previousPeak.width) <= factor / 2) {
        currentGroup.push(peak);
      } else {
        currentGroup = [peak];
        groups.push(currentGroup);
      }

      peak.group = groups.length - 1;
      previousPeak = peak;
    }

    return groups;
  }

  /**
   * Optimize the position (x), max intensity (y), full width at half maximum (width)
   * and the ratio of gaussian contribution (mu) if it's required. It supports three kind of shapes: gaussian, lorentzian and pseudovoigt
   * @param {object} data - An object containing the x and y data to be fitted.
   * @param {Array} peakList - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
   * @param {object} [options = {}] -
   * @param {number} [options.factorWidth = 1] - times of width to group peaks.
   * @param {number} [options.factorLimits = 2] - times of width to use to optimize peaks
   * @param {object} [options.shape={}] - it's specify the kind of shape used to fitting.
   * @param {string} [options.shape.kind='gaussian'] - kind of shape; lorentzian, gaussian and pseudovoigt are supported.
   * @param {string} [options.shape.options={}] - options depending the kind of shape
   * @param {object} [options.optimization={}] - it's specify the kind and options of the algorithm use to optimize parameters.
   * @param {string} [options.optimization.kind='lm'] - kind of algorithm. By default it's levenberg-marquardt.
   * @param {object} [options.optimization.options={}] - options for the specific kind of algorithm.
   * @param {number} [options.optimization.options.timeout=10] - maximum time running before break in seconds.
   */

  function optimizePeaks(data, peakList, options = {}) {
    const {
      factorWidth = 1,
      factorLimits = 2,
      shape = {
        kind: 'gaussian'
      },
      optimization = {
        kind: 'lm',
        options: {
          timeout: 10
        }
      }
    } = options;

    if (data.x[0] > data.x[1]) {
      data.x.reverse();
      data.y.reverse();
    }

    let groups = groupPeaks(peakList, factorWidth);
    let results = [];

    for (const peaks of groups) {
      const firstPeak = peaks[0];
      const lastPeak = peaks[peaks.length - 1];
      const from = firstPeak.x - firstPeak.width * factorLimits;
      const to = lastPeak.x + lastPeak.width * factorLimits;
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(data.x, {
        from,
        to
      }); // Multiple peaks

      const currentRange = {
        x: data.x.slice(fromIndex, toIndex),
        y: data.y.slice(fromIndex, toIndex)
      };

      if (currentRange.x.length > 5) {
        let {
          peaks: optimizedPeaks
        } = optimize(currentRange, peaks, {
          shape,
          optimization
        });
        results = results.concat(optimizedPeaks);
      } else {
        results = results.concat(peaks);
      }
    }

    return results;
  }

  /**
   * This function try to join the peaks that seems to belong to a broad signal in a single broad peak.
   * @param {Array} peakList - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
   * @param {object} [options = {}] - options
   * @param {number} [options.width=0.25] - width limit to join peaks.
   * @param {object} [options.shape={}] - it's specify the kind of shape used to fitting.
   * @param {string} [options.shape.kind = 'gaussian'] - kind of shape; lorentzian, gaussian and pseudovoigt are supported.
   * @param {object} [options.optimization = {}] - it's specify the kind and options of the algorithm use to optimize parameters.
   * @param {string} [options.optimization.kind = 'lm'] - kind of algorithm. By default it's levenberg-marquardt.
   * @param {number} [options.optimization.options.timeout = 10] - maximum time running before break in seconds.
   * @param {object} [options.optimization.options = {}] - options for the specific kind of algorithm.
   */

  function joinBroadPeaks(peakList, options = {}) {
    let {
      width = 0.25,
      shape = {
        kind: 'gaussian'
      },
      optimization = {
        kind: 'lm',
        timeout: 10
      }
    } = options;
    let broadLines = []; // Optimize the possible broad lines

    let max = 0;
    let maxI = 0;
    let count = 1;

    for (let i = peakList.length - 1; i >= 0; i--) {
      if (peakList[i].soft) {
        broadLines.push(peakList.splice(i, 1)[0]);
      }
    } // Push a feke peak


    broadLines.push({
      x: Number.MAX_VALUE
    });
    let candidates = {
      x: [broadLines[0].x],
      y: [broadLines[0].y]
    };
    let indexes = [0];

    for (let i = 1; i < broadLines.length; i++) {
      if (Math.abs(broadLines[i - 1].x - broadLines[i].x) < width) {
        candidates.x.push(broadLines[i].x);
        candidates.y.push(broadLines[i].y);

        if (broadLines[i].y > max) {
          max = broadLines[i].y;
          maxI = i;
        }

        indexes.push(i);
        count++;
      } else {
        if (count > 2) {
          let fitted = optimize(candidates, [{
            x: broadLines[maxI].x,
            y: max,
            width: Math.abs(candidates.x[0] - candidates.x[candidates.x.length - 1])
          }], {
            shape,
            optimization
          });
          let {
            peaks: peak
          } = fitted;
          peak[0].index = Math.floor(indexes.reduce((a, b) => a + b, 0) / indexes.length);
          peak[0].soft = false;
          peakList.push(peak[0]);
        } else {
          // Put back the candidates to the signals list
          indexes.forEach(index => {
            peakList.push(broadLines[index]);
          });
        }

        candidates = {
          x: [broadLines[i].x],
          y: [broadLines[i].y]
        };
        indexes = [i];
        max = broadLines[i].y;
        maxI = i;
        count = 1;
      }
    }

    peakList.sort(function (a, b) {
      return a.x - b.x;
    });
    return peakList;
  }

  /**
   * Implementation of the peak picking method described by Cobas in:
   * A new approach to improving automated analysis of proton NMR spectra
   * through Global Spectral Deconvolution (GSD)
   * http://www.spectrosco-pyeurope.com/images/stories/ColumnPDFs/TD_23_1.pdf
   * @param {DataXY} data - Object of kind
   * @param {object} [options={}] - options object with some parameter for GSD.
   * @param {number} [options.minMaxRatio = 0.01] - Threshold to determine if a given peak should be considered as a noise, bases on its relative height compared to the highest peak.
   * @param {number} [options.broadRatio = 0.00025] - If broadRatio is higher than 0, then all the peaks which second derivative smaller than broadRatio * maxAbsSecondDerivative will be marked with the soft mask equal to true.
   * @param {number} [options.broadWidth = 0.25] - Threshold to determine if some peak is candidate to clustering into range.
   * @param {number} [options.thresholdFactor=3] - the factor that multiplies the noise level to set up a threshold to select peaks with respect to the intensity.
   * @param {number} [options.noiseLevel = median(data.y) * (options.thresholdFactor || 3)] - Noise threshold in spectrum y units. Default is three/thresholdFactor times the absolute median of data.y.
   * @param {number} [options.factorWidth = 4] - factor to determine the width at the moment to group the peaks in signals in 'GSD.optimizePeaks' function.
   * @param {object} [options.shape={}] - it's specify the kind of shape used to fitting.
   * @param {string} [options.shape.kind = 'gaussian'] - kind of shape; lorentzian, gaussian and pseudovoigt are supported.
   * @param {object} [options.optimization = {}] - it's specify the kind and options of the algorithm use to optimize parameters.
   * @param {string} [options.optimization.kind = 'lm'] - kind of algorithm. By default it's levenberg-marquardt.
   * @param {object} [options.optimization.options = {}] - options for the specific kind of algorithm.
   * @param {Boolean} [options.smoothY = true] - Select the peak intensities from a smoothed version of the independent variables?
   * @param {Boolean} [options.optimize = true] - if it's true adjust an train of gaussian or lorentzian shapes to spectrum.
   * @return {Array}
   */

  function xyAutoPeaksPicking(data, options = {}) {
    const {
      from,
      to,
      noiseLevel,
      thresholdFactor = 3,
      minMaxRatio = 0.05,
      broadRatio = 0.00025,
      useSanPlot = false,
      smoothY = true,
      optimize = false,
      factorWidth = 4,
      realTopDetection = true,
      shape = {
        kind: 'gaussian'
      },
      optimization = {
        kind: 'lm'
      },
      broadWidth = 0.25,
      lookNegative = false,
      sgOptions = {
        windowSize: 9,
        polynomial: 3
      }
    } = options;

    if (from !== undefined && to !== undefined) {
      data = xyExtract(data, [{
        from,
        to
      }]);
    }

    const cutOff = getCutOff(data.y, {
      noiseLevel,
      useSanPlot,
      thresholdFactor
    });
    let getPeakOptions = {
      shape,
      broadWidth,
      optimize,
      factorWidth,
      sgOptions,
      minMaxRatio,
      broadRatio,
      noiseLevel: cutOff.positive,
      smoothY,
      optimization,
      realTopDetection
    };
    let peaks = getPeakList(data, getPeakOptions);

    if (lookNegative) {
      getPeakOptions.noiseLevel = cutOff.negative;
      peaks.push(...getNegativePeaks(data, getPeakOptions));
    }

    return peaks;
  }

  function getPeakList(data, options) {
    const {
      shape,
      broadWidth,
      optimize,
      factorWidth,
      sgOptions,
      minMaxRatio,
      broadRatio,
      noiseLevel,
      smoothY,
      optimization,
      realTopDetection
    } = options;
    let peakList = gsd(data, {
      sgOptions,
      minMaxRatio,
      broadRatio,
      noiseLevel,
      smoothY,
      realTopDetection
    });

    if (broadWidth) {
      peakList = joinBroadPeaks(peakList, {
        width: broadWidth,
        shape,
        optimization
      });
    }

    if (optimize) {
      peakList = optimizePeaks(data, peakList, {
        shape,
        factorWidth,
        optimization
      });
    }

    return peakList;
  }

  function getNegativePeaks(data, options) {
    let {
      x,
      y
    } = data;
    let negativeDataY = new Float64Array(data.y.length);

    for (let i = 0; i < negativeDataY.length; i++) {
      negativeDataY[i] = -1 * y[i];
    }

    let peakList = getPeakList({
      x,
      y: negativeDataY
    }, options);

    for (let i = 0; i < peakList.length; i++) {
      peakList[i].y *= -1;
    }

    return peakList;
  }

  function getCutOff(data, options = {}) {
    const {
      noiseLevel,
      useSanPlot,
      thresholdFactor
    } = options;

    const formatResult = noiseLevel => typeof noiseLevel === 'number' ? {
      positive: noiseLevel,
      negative: -noiseLevel
    } : noiseLevel;

    if (noiseLevel) {
      return formatResult(noiseLevel);
    } else {
      return useSanPlot ? xNoiseSanPlot(data, {
        factorStd: thresholdFactor
      }) : formatResult(xAbsoluteMedian(data) * thresholdFactor);
    }
  }

  /*
   * This library implements the J analyser described by Cobas et al in the paper:
   * A two-stage approach to automatic determination of 1H NMR coupling constants
   */
  const patterns = ['s', 'd', 't', 'q', 'quint', 'h', 'sept', 'o', 'n'];
  let symRatio = 1.5;
  let maxErrorIter1 = 2.5; // Hz

  let maxErrorIter2 = 1; // Hz

  let jAxisKeys = {
    jAxis: 'x',
    intensity: 'intensity'
  };
  var jAnalyzer = {
    /**
     * The compilation process implements at the first stage a normalization procedure described by Golotvin et al.
     * embedding in peak-component-counting method described by Hoyes et al.
     * @param {object} signal
     * @private
     */
    compilePattern: function (signal, options = {}) {
      let {
        jAxisKey = jAxisKeys
      } = options;
      signal.multiplicity = 'm'; // 1.1 symmetrize
      // It will add a set of peaks(signal.peaksComp) to the signal that will be used during
      // the compilation process. The unit of those peaks will be in Hz

      signal.symRank = symmetrizeChoiseBest(signal, {
        maxError: maxErrorIter1,
        iteration: 1,
        jAxisKey
      });
      signal.asymmetric = true; // Is the signal symmetric?

      if (signal.symRank >= 0.95 && signal.peaksComp.length < 32) {
        signal.asymmetric = false;
        let P1, n2, maxFlagged;
        let k = 1;
        let Jc = []; // Loop over the possible number of coupling contributing to the multiplet

        for (let n = 0; n < 9; n++) {
          // 1.2 Normalize. It makes a deep copy of the peaks before to modify them.
          let peaks = normalize(signal, n); // signal.peaksCompX = peaks;

          let validPattern = false; // It will change to true, when we find the good patter
          // Lets check if the signal could be a singulet.

          if (peaks.length === 1 && n === 0) {
            validPattern = true;
          } else {
            if (peaks.length <= 1) {
              continue;
            }
          } // 1.3 Establish a range for the Heights Hi [peaks.intensity*0.85,peaks.intensity*1.15];


          let ranges = getRanges(peaks);
          n2 = Math.pow(2, n); // 1.4 Find a combination of integer heights Hi, one from each Si, that sums to 2^n.

          let heights = null;
          let counter = 1;

          while (!validPattern && (heights = getNextCombination(ranges, n2)) !== null && counter < 400) {
            // 2.1 Number the components of the multiplet consecutively from 1 to 2n,
            // starting at peak 1
            let numbering = new Array(heights.length);
            k = 1;

            for (let i = 0; i < heights.length; i++) {
              numbering[i] = new Array(heights[i]);

              for (let j = 0; j < heights[i]; j++) {
                numbering[i][j] = k++;
              }
            }

            Jc = []; // The array to store the detected j-coupling
            // 2.2 Set j = 1; J1 = P2 - P1. Flag components 1 and 2 as accounted for.

            let j = 1;
            Jc.push(peaks[1].x - peaks[0].x);
            P1 = peaks[0].x;
            numbering[0].splice(0, 1); // Flagged

            numbering[1].splice(0, 1); // Flagged

            k = 1;
            let nFlagged = 2;
            maxFlagged = Math.pow(2, n) - 1;

            while (Jc.length < n && nFlagged < maxFlagged && k < peaks.length) {
              counter += 1; // 4.1. Increment j. Set k to the number of the first unflagged component.

              j++;

              while (k < peaks.length && numbering[k].length === 0) {
                k++;
              }

              if (k < peaks.length) {
                // 4.2 Jj = Pk - P1.
                Jc.push(peaks[k].x - peaks[0].x); // Flag component k and, for each sum of the...

                numbering[k].splice(0, 1); // Flageed

                nFlagged++; // Flag the other components of the multiplet

                for (let u = 2; u <= j; u++) {
                  let jSum = 0;

                  for (let i = 0; i < u; i++) {
                    jSum += Jc[i];
                  }

                  for (let i = 1; i < numbering.length; i++) {
                    // Maybe 0.25 Hz is too much?
                    if (Math.abs(peaks[i].x - (P1 + jSum)) < 0.25) {
                      numbering[i].splice(0, 1); // Flageed

                      nFlagged++;
                      break;
                    }
                  }
                }
              }
            } // Calculate the ideal patter by using the extracted j-couplings


            let pattern = idealPattern(Jc); // Compare the ideal pattern with the proposed intensities.
            // All the intensities have to match to accept the multiplet

            validPattern = true;

            for (let i = 0; i < pattern.length; i++) {
              if (pattern[i].intensity !== heights[i]) {
                validPattern = false;
              }
            }
          } // If we found a valid pattern we should inform about the pattern.


          if (validPattern) {
            updateSignal(signal, Jc);
          }
        }
      } // Before to return, change the units of peaksComp from Hz to PPM again


      for (let i = 0; i < signal.peaksComp.length; i++) {
        signal.peaksComp[i].x /= signal.observe;
      }
    }
  };
  /**
   * @private
   * update the signal
   * @param {*} signal
   * @param {*} Jc
   */

  function updateSignal(signal, Jc) {
    // Update the limits of the signal
    let peaks = signal.peaksComp; // Always in Hz

    let nbPeaks = peaks.length;
    signal.startX = peaks[0].x / signal.observe - peaks[0].width;
    signal.stopX = peaks[nbPeaks - 1].x / signal.observe + peaks[nbPeaks - 1].width;
    signal.integralData.from = peaks[0].x / signal.observe - peaks[0].width * 3;
    signal.integralData.to = peaks[nbPeaks - 1].x / signal.observe + peaks[nbPeaks - 1].width * 3; // Compile the pattern and format the constant couplings

    signal.maskPattern = signal.mask2;
    signal.multiplicity = abstractPattern(signal, Jc);
    signal.pattern = signal.multiplicity; // Our library depends on this parameter, but it is old
  }
  /**
   * Returns the multiplet in the compact format
   * @param {object} signal
   * @param {object} Jc
   * @return {String}
   * @private
   */


  function abstractPattern(signal, Jc) {
    let tol = 0.05;
    let pattern = '';
    let cont = 1;
    let newNmrJs = [];

    if (Jc && Jc.length > 0) {
      Jc.sort(function (a, b) {
        return b - a;
      });

      for (let i = 0; i < Jc.length - 1; i++) {
        if (Math.abs(Jc[i] - Jc[i + 1]) < tol) {
          cont++;
        } else {
          newNmrJs.push({
            coupling: Math.abs(Jc[i]),
            multiplicity: patterns[cont]
          });
          pattern += patterns[cont];
          cont = 1;
        }
      }

      let index = Jc.length - 1;
      newNmrJs.push({
        coupling: Math.abs(Jc[index]),
        multiplicity: patterns[cont]
      });
      pattern += patterns[cont];
      signal.nmrJs = newNmrJs;
    } else {
      pattern = 's';

      if (Math.abs(signal.startX - signal.stopX) * signal.observe > 16) {
        pattern = 'br s';
      }
    }

    return pattern;
  }
  /**
   * This function creates an ideal pattern from the given J-couplings
   * @private
   * @param {Array} Jc
   * @return {*[]}
   * @private
   */


  function idealPattern(Jc) {
    let hsum = Math.pow(2, Jc.length);
    let pattern = [{
      x: 0,
      intensity: hsum
    }]; // To split the initial height

    for (let i = 0; i < Jc.length; i++) {
      for (let j = pattern.length - 1; j >= 0; j--) {
        pattern.push({
          x: pattern[j].x + Jc[i] / 2,
          intensity: pattern[j].intensity / 2
        });
        pattern[j].x = pattern[j].x - Jc[i] / 2;
        pattern[j].intensity = pattern[j].intensity / 2;
      }
    } // To sum the heights in the same positions


    pattern.sort(function compare(a, b) {
      return a.x - b.x;
    });

    for (let j = pattern.length - 2; j >= 0; j--) {
      if (Math.abs(pattern[j].x - pattern[j + 1].x) < 0.1) {
        pattern[j].intensity += pattern[j + 1].intensity;
        pattern.splice(j + 1, 1);
      }
    }

    return pattern;
  }
  /**
   * Find a combination of integer heights Hi, one from each Si, that sums to 2n.
   * @param {object} ranges
   * @param {Number} value
   * @return {*}
   * @private
   */


  function getNextCombination(ranges, value) {
    let half = Math.ceil(ranges.values.length * 0.5);
    let lng = ranges.values.length;
    let sum = 0;
    let ok;

    while (sum !== value) {
      // Update the indexes to point at the next possible combination
      ok = false;

      while (!ok) {
        ok = true;
        ranges.currentIndex[ranges.active]++;

        if (ranges.currentIndex[ranges.active] >= ranges.values[ranges.active].length) {
          // In this case, there is no more possible combinations
          if (ranges.active + 1 === half) {
            return null;
          } else {
            // If this happens we need to try the next active peak
            ranges.currentIndex[ranges.active] = 0;
            ok = false;
            ranges.active++;
          }
        } else {
          ranges.active = 0;
        }
      } // Sum the heights for this combination


      sum = 0;

      for (let i = 0; i < half; i++) {
        sum += ranges.values[i][ranges.currentIndex[i]] * 2;
      }

      if (ranges.values.length % 2 !== 0) {
        sum -= ranges.values[half - 1][ranges.currentIndex[half - 1]];
      }
    } // If the sum is equal to the expected value, fill the array to return


    if (sum === value) {
      let heights = new Array(lng);

      for (let i = 0; i < half; i++) {
        heights[i] = ranges.values[i][ranges.currentIndex[i]];
        heights[lng - i - 1] = ranges.values[i][ranges.currentIndex[i]];
      }

      return heights;
    }

    return null;
  }
  /**
   * This function generates the possible values that each peak can contribute
   * to the multiplet.
   * @param {Array} peaks Array of objects with peaks information {intensity}
   * @return {{values: Array, currentIndex: Array, active: number}}
   * @private
   */


  function getRanges(peaks) {
    let ranges = new Array(peaks.length);
    let currentIndex = new Array(peaks.length);
    let min, max;
    ranges[0] = [1];
    ranges[peaks.length - 1] = [1];
    currentIndex[0] = -1;
    currentIndex[peaks.length - 1] = 0;

    for (let i = 1; i < peaks.length - 1; i++) {
      min = Math.round(peaks[i].intensity * 0.85);
      max = Math.round(peaks[i].intensity * 1.15);
      ranges[i] = [];

      for (let j = min; j <= max; j++) {
        ranges[i].push(j);
      }

      currentIndex[i] = 0;
    }

    return {
      values: ranges,
      currentIndex: currentIndex,
      active: 0
    };
  }
  /**
   * Performs a symmetrization of the signal by using different aproximations to the center.
   * It will return the result of the symmetrization that removes less peaks from the signal
   * @param {object} signal
   * @param {Number} maxError
   * @param {Number} iteration
   * @return {*}
   * @private
   */


  function symmetrizeChoiseBest(signal, options = {}) {
    let {
      maxError,
      iteration,
      jAxisKey = jAxisKeys
    } = options;
    let symRank1 = symmetrize(signal, maxError, iteration, jAxisKey);
    let tmpPeaks = signal.peaksComp;
    let tmpMask = signal.mask;
    let cs = signal.delta1;
    signal.delta1 = (signal.peaks[0].x + signal.peaks[signal.peaks.length - 1].x) / 2;
    let symRank2 = symmetrize(signal, maxError, iteration, jAxisKey);

    if (signal.peaksComp.length > tmpPeaks.length) {
      return symRank2;
    } else {
      signal.delta1 = cs;
      signal.peaksComp = tmpPeaks;
      signal.mask = tmpMask;
      return symRank1;
    }
  }
  /**
   * This function will return a set of symmetric peaks that will
   * be the enter point for the patter compilation process.
   * @param {object} signal
   * @param {Number} maxError
   * @param {Number} iteration
   * @return {Number}
   * @private
   */


  function symmetrize(signal, maxError, iteration, key) {
    let {
      jAxis,
      intensity
    } = key; // Before to symmetrize we need to keep only the peaks that possibly conforms the multiplete

    let max, min, avg, ratio, avgWidth;
    let peaks = new Array(signal.peaks.length); // Make a deep copy of the peaks and convert PPM ot HZ

    for (let i = 0; i < peaks.length; i++) {
      peaks[i] = {
        x: signal.peaks[i][jAxis] * signal.observe,
        intensity: signal.peaks[i][intensity],
        width: signal.peaks[i].width
      };
    } // Join the peaks that are closer than 0.25 Hz


    for (let i = peaks.length - 2; i >= 0; i--) {
      if (Math.abs(peaks[i].x - peaks[i + 1].x) < 0.25) {
        peaks[i].x = peaks[i].x * peaks[i].intensity + peaks[i + 1].x * peaks[i + 1].intensity;
        peaks[i].intensity = peaks[i].intensity + peaks[i + 1].intensity;
        peaks[i].x /= peaks[i].intensity;
        peaks[i].intensity /= 2;
        peaks[i].width += peaks[i + 1].width;
        peaks.splice(i + 1, 1);
      }
    }

    signal.peaksComp = peaks;
    let nbPeaks = peaks.length;
    let mask = new Array(nbPeaks);
    signal.mask = mask;
    let left = 0;
    let right = peaks.length - 1;
    let cs = signal.delta1 * signal.observe;
    let middle = [(peaks[0].x + peaks[nbPeaks - 1].x) / 2, 1];
    maxError = error(Math.abs(cs - middle[0]));
    let heightSum = 0; // We try to symmetrize the extreme peaks. We consider as candidates for symmetricing those which have
    // ratio smaller than 3

    for (let i = 0; i < nbPeaks; i++) {
      mask[i] = true; // heightSum += signal.peaks[i].intensity;

      heightSum += peaks[i].intensity;
    }

    while (left <= right) {
      mask[left] = true;
      mask[right] = true;

      if (left === right) {
        if (nbPeaks > 2 && Math.abs(peaks[left].x - cs) > maxError) {
          mask[left] = false;
        }
      } else {
        max = Math.max(peaks[left].intensity, peaks[right].intensity);
        min = Math.min(peaks[left].intensity, peaks[right].intensity);
        ratio = max / min;

        if (ratio > symRatio) {
          if (peaks[left].intensity === min) {
            mask[left] = false;
            right++;
          } else {
            mask[right] = false;
            left--;
          }
        } else {
          let diffL = Math.abs(peaks[left].x - cs);
          let diffR = Math.abs(peaks[right].x - cs);

          if (Math.abs(diffL - diffR) < maxError) {
            avg = Math.min(peaks[left].intensity, peaks[right].intensity);
            avgWidth = Math.min(peaks[left].width, peaks[right].width);
            peaks[left].intensity = peaks[right].intensity = avg;
            peaks[left].width = peaks[right].width = avgWidth;
            middle = [middle[0] + (peaks[right].x + peaks[left].x) / 2, middle[1] + 1];
          } else {
            if (Math.max(diffL, diffR) === diffR) {
              mask[right] = false;
              left--;
            } else {
              mask[left] = false;
              right++;
            }
          }
        }
      }

      left++;
      right--; // Only alter cs if it is the first iteration of the sym process.

      if (iteration === 1) {
        cs = chemicalShift(peaks, mask); // There is not more available peaks

        if (isNaN(cs)) {
          return 0;
        }
      }

      maxError = error(Math.abs(cs - middle[0] / middle[1]));
    } // To remove the weak peaks and recalculate the cs


    for (let i = nbPeaks - 1; i >= 0; i--) {
      if (mask[i] === false) {
        peaks.splice(i, 1);
      }
    }

    cs = chemicalShift(peaks);

    if (isNaN(cs)) {
      return 0;
    }

    signal.delta1 = cs / signal.observe; // Now, the peak should be symmetric in heights, but we need to know if it is symmetric in x

    let symFactor = 0;
    let weight = 0;

    if (peaks.length > 1) {
      for (let i = Math.ceil(peaks.length / 2) - 1; i >= 0; i--) {
        symFactor += (3 + Math.min(Math.abs(peaks[i].x - cs), Math.abs(peaks[peaks.length - 1 - i].x - cs))) / (3 + Math.max(Math.abs(peaks[i].x - cs), Math.abs(peaks[peaks.length - 1 - i].x - cs))) * peaks[i].intensity;
        weight += peaks[i].intensity;
      }

      symFactor /= weight;
    } else {
      if (peaks.length === 1) {
        symFactor = 1;
      }
    }

    let newSumHeights = 0;

    for (let i = 0; i < peaks.length; i++) {
      newSumHeights += peaks[i].intensity;
    }

    symFactor -= (heightSum - newSumHeights) / heightSum * 0.12; // Removed peaks penalty
    // Sometimes we need a second opinion after the first symmetrization.

    if (symFactor > 0.8 && symFactor < 0.97 && iteration < 2) {
      return symmetrize(signal, maxErrorIter2, 2, key);
    } else {
      // Center the given pattern at cs and symmetrize x
      if (peaks.length > 1) {
        let dxi;

        for (let i = Math.ceil(peaks.length / 2) - 1; i >= 0; i--) {
          dxi = (peaks[i].x - peaks[peaks.length - 1 - i].x) / 2.0;
          peaks[i].x = cs + dxi;
          peaks[peaks.length - 1 - i].x = cs - dxi;
        }
      }
    }

    return symFactor;
  }
  /**
   * Error validator
   * @param {Number} value
   * @return {Number}
   * @private
   */


  function error(value) {
    let maxError = value * 2.5;

    if (maxError < 0.75) {
      maxError = 0.75;
    }

    if (maxError > 3) {
      maxError = 3;
    }

    return maxError;
  }
  /**
   * @private
   * 2 stages normalizarion of the peaks heights to Math.pow(2,n).
   * Creates a new mask with the peaks that could contribute to the multiplete
   * @param {object} signal
   * @param {Number} n
   * @return {*}
   */


  function normalize(signal, n) {
    // Perhaps this is slow
    let peaks = JSON.parse(JSON.stringify(signal.peaksComp));
    let norm = 0;
    let norm2 = 0;

    for (let i = 0; i < peaks.length; i++) {
      norm += peaks[i].intensity;
    }

    norm = Math.pow(2, n) / norm;
    signal.mask2 = JSON.parse(JSON.stringify(signal.mask));
    let index = signal.mask2.length - 1;

    for (let i = peaks.length - 1; i >= 0; i--) {
      peaks[i].intensity *= norm;

      while (index >= 0 && signal.mask2[index] === false) {
        index--;
      }

      if (peaks[i].intensity < 0.75) {
        peaks.splice(i, 1);
        signal.mask2[index] = false;
      } else {
        norm2 += peaks[i].intensity;
      }

      index--;
    }

    norm2 = Math.pow(2, n) / norm2;

    for (let i = peaks.length - 1; i >= 0; i--) {
      peaks[i].intensity *= norm2;
    }

    return peaks;
  }
  /**
   * @private
   * Calculates the chemical shift as the weighted sum of the peaks
   * @param {Array} peaks
   * @param {Array} mask
   * @return {Number}
   */


  function chemicalShift(peaks, mask) {
    let sum = 0;
    let cs = 0;
    let area;

    if (mask) {
      for (let i = 0; i < peaks.length; i++) {
        if (mask[i] === true) {
          area = getArea(peaks[i]);
          sum += area;
          cs += area * peaks[i].x;
        }
      }
    } else {
      for (let i = 0; i < peaks.length; i++) {
        area = getArea(peaks[i]);
        sum += area;
        cs += area * peaks[i].x;
      }
    }

    return cs / sum;
  }
  /**
   * Return the area of a Lorentzian function
   * @param {object} peak - object with peak information
   * @return {Number}
   * @private
   */


  function getArea(peak) {
    return Math.abs(peak.intensity * peak.width * 1.57); // 1.772453851);
  }

  function joinRanges(ranges) {
    ranges.sort((a, b) => a.from - b.from);

    for (let i = 0; i < ranges.length - 1; i++) {
      if (ranges[i].to > ranges[i + 1].from) {
        ranges[i].to = Math.max(ranges[i + 1].to, ranges[i].to);
        ranges[i].signal = ranges[i].signal.concat(ranges[i + 1].signal);
        ranges[i].integral += ranges[i + 1].integral;
        ranges.splice(i + 1, 1);
        i--;
      }
    }

    return ranges;
  }

  // import { Ranges } from 'spectra-data-ranges';
  /**
   * This function clustering peaks and calculate the integral value for each range from the peak list returned from extractPeaks function.
   * @param {Object} data - spectra data
   * @param {Array} peakList - nmr signals
   * @param {Object} [options={}] - options object with some parameter for GSD, detectSignal functions.
   * @param {Number} [options.integrationSum=100] - Number of hydrogens or some number to normalize the integral data. If it's zero return the absolute integral value
   * @param {String} [options.integralType='sum'] - option to chose between approx area with peaks or the sum of the points of given range ('sum', 'peaks')
   * @param {Number} [options.frequencyCluster=16] - distance limit to clustering peaks.
   * @param {Number} [options.clean=0.4] - If exits it remove all the signals with integration < clean value
   * @param {Boolean} [options.compile=true] - If true, the Janalyzer function is run over signals to compile the patterns.
   * @param {Boolean} [options.keepPeaks=false] - If true each signal will contain an array of peaks.
   * @param {String} [options.nucleus='1H'] - Nucleus
   * @param {String} [options.frequency=400] - Observed frequency
   * @returns {Array}
   */

  function peaksToRanges(data, peakList, options = {}) {
    let {
      integrationSum = 100,
      joinOverlapRanges = true,
      clean = 0.4,
      compile = true,
      integralType = 'sum',
      frequency = 400,
      frequencyCluster = 16,
      keepPeaks = false,
      nucleus = '1H'
    } = options;
    let signalOptions = {
      integrationSum,
      integralType,
      frequencyCluster,
      frequency,
      nucleus
    };

    if (data.x[0] > data.x[1]) {
      data.x = data.x.reverse();
      data.y = data.y.reverse();
    }

    let signals = detectSignals(data, peakList, signalOptions);

    if (clean) {
      for (let i = 0; i < signals.length; i++) {
        if (Math.abs(signals[i].integralData.value) < clean) {
          signals.splice(i, 1);
        }
      }
    }

    if (compile) {
      let nHi, sum;

      for (let i = 0; i < signals.length; i++) {
        jAnalyzer.compilePattern(signals[i]);

        if (signals[i].maskPattern && signals[i].multiplicity !== 'm' && signals[i].multiplicity !== '') {
          // Create a new signal with the removed peaks
          nHi = 0;
          sum = 0;
          let peaksO = [];

          for (let j = signals[i].maskPattern.length - 1; j >= 0; j--) {
            sum += computeArea(signals[i].peaks[j]);

            if (signals[i].maskPattern[j] === false) {
              let peakR = signals[i].peaks.splice(j, 1)[0];
              peaksO.push({
                x: peakR.x,
                y: peakR.intensity,
                width: peakR.width
              });
              signals[i].mask.splice(j, 1);
              signals[i].mask2.splice(j, 1);
              signals[i].maskPattern.splice(j, 1);
              signals[i].nbPeaks--;
              nHi += computeArea(peakR);
            }
          }

          if (peaksO.length > 0) {
            nHi = nHi * signals[i].integralData.value / sum;
            signals[i].integralData.value -= nHi;
            let peaks1 = [];

            for (let j = peaksO.length - 1; j >= 0; j--) {
              peaks1.push(peaksO[j]);
            }

            signalOptions.integrationSum = Math.abs(nHi);
            let ranges = detectSignals(data, peaks1, signalOptions);

            for (let j = 0; j < ranges.length; j++) {
              signals.push(ranges[j]);
            }
          }
        }
      } // it was a updateIntegrals function.


      let sumIntegral = 0;
      let sumObserved = 0;

      for (let i = 0; i < signals.length; i++) {
        sumObserved += Math.abs(Math.round(signals[i].integralData.value));
      }

      if (sumObserved !== integrationSum) {
        sumIntegral = integrationSum / sumObserved;

        for (let i = 0; i < signals.length; i++) {
          signals[i].integralData.value *= sumIntegral;
        }
      }
    }

    signals.sort((a, b) => {
      return b.delta1 - a.delta1;
    });

    if (clean) {
      for (let i = signals.length - 1; i >= 0; i--) {
        if (Math.abs(signals[i].integralData.value) < clean) {
          signals.splice(i, 1);
        }
      }
    }

    let ranges = []; //new Array(signals.length);

    for (let i = 0; i < signals.length; i++) {
      let signal = signals[i];
      ranges[i] = {
        from: signal.integralData.from,
        to: signal.integralData.to,
        integral: signal.integralData.value,
        signal: [{
          kind: signal.kind || 'signal',
          multiplicity: signal.multiplicity
        }]
      };

      if (keepPeaks) {
        ranges[i].signal[0].peak = signal.peaks;
      }

      if (signal.nmrJs) {
        ranges[i].signal[0].j = signal.nmrJs;
      }

      if (!signal.asymmetric || signal.multiplicity === 'm') {
        ranges[i].signal[0].delta = signal.delta1;
      }
    }

    if (joinOverlapRanges) ranges = joinRanges(ranges); // return new Ranges(ranges);

    return ranges;
  }
  /**
   * Extract the signals from the peakList and the given spectrum.
   * @param {object} data - spectra data
   * @param {array} peakList - nmr signals
   * @param {object} [options = {}]
   * @param {number} [options.integrationSum='100'] - Number of hydrogens or some number to normalize the integration data, If it's zero return the absolute integral value
   * @param {string} [options.integralType='sum'] - option to chose between approx area with peaks or the sum of the points of given range
   * @param {number} [options.frequencyCluster=16] - distance limit to clustering the peaks.
   * range = frequencyCluster / observeFrequency -> Peaks withing this range are considered to belongs to the same signal1D
   * @param {string} [options.nucleus='1H'] - - Nucleus
   * @param {String} [options.frequency = 400] - Observed frequency
   * @return {array} nmr signals
   * @private
   */

  function detectSignals(data, peakList, options = {}) {
    let {
      integrationSum = 100,
      integralType = 'sum',
      frequencyCluster = 16,
      frequency = 400,
      nucleus = '1H'
    } = options;
    let signal1D, peaks;
    let signals = [];
    let prevPeak = {
      x: 100000
    };
    let spectrumIntegral = 0;
    frequencyCluster /= frequency;

    for (let i = 0; i < peakList.length; i++) {
      if (Math.abs(peakList[i].x - prevPeak.x) > frequencyCluster) {
        signal1D = {
          nbPeaks: 1,
          units: 'PPM',
          startX: peakList[i].x - peakList[i].width,
          stopX: peakList[i].x + peakList[i].width,
          multiplicity: '',
          pattern: '',
          observe: frequency,
          nucleus,
          integralData: {
            from: peakList[i].x - peakList[i].width * 3,
            to: peakList[i].x + peakList[i].width * 3
          },
          peaks: [{
            x: peakList[i].x,
            intensity: peakList[i].y,
            width: peakList[i].width
          }]
        };
        if (peakList[i].kind) signal1D.kind = peakList[i].kind;
        signals.push(signal1D);
      } else {
        let tmp = peakList[i].x + peakList[i].width;
        signal1D.stopX = Math.max(signal1D.stopX, tmp);
        signal1D.startX = Math.min(signal1D.startX, tmp);
        signal1D.nbPeaks++;
        signal1D.peaks.push({
          x: peakList[i].x,
          intensity: peakList[i].y,
          width: peakList[i].width
        });
        signal1D.integralData.from = Math.min(signal1D.integralData.from, peakList[i].x - peakList[i].width * 3);
        signal1D.integralData.to = Math.max(signal1D.integralData.to, peakList[i].x + peakList[i].width * 3);
        if (peakList[i].kind) signal1D.kind = peakList[i].kind;
      }

      prevPeak = peakList[i];
    }

    for (let i = 0; i < signals.length; i++) {
      peaks = signals[i].peaks;
      let integral = signals[i].integralData;
      let chemicalShift = 0;
      let integralPeaks = 0;

      for (let j = 0; j < peaks.length; j++) {
        let area = computeArea(peaks[j]);
        chemicalShift += peaks[j].x * area;
        integralPeaks += area;
      }

      signals[i].delta1 = chemicalShift / integralPeaks;

      if (integralType === 'sum') {
        integral.value = xyIntegration(data, {
          from: integral.from,
          to: integral.to
        });
      } else {
        integral.value = integralPeaks;
      }

      spectrumIntegral += integral.value;
    }

    if (integrationSum > 0) {
      let integralFactor = integrationSum / spectrumIntegral;

      for (let i = 0; i < signals.length; i++) {
        let integral = signals[i].integralData;
        integral.value *= integralFactor;
      }
    }

    return signals;
  }
  /**
   * Return the area of a Lorentzian function
   * @param {object} peak - object with peak information
   * @return {Number}
   * @private
   */


  function computeArea(peak) {
    return Math.abs(peak.intensity * peak.width * 1.57); // todo add an option with this value: 1.772453851
  }

  /**
   * Detect peaks, optimize parameters and compile multiplicity if required.
   * @param {DataXY}  data - Object of kind
   * @param {object}  [options={}] - options object with some parameter for GSD.
   * @param {object}  [options.peakPicking={}] - options to peak detection and optimization.
   * @param {number}  [options.peakPicking.minMaxRatio=0.01] - Threshold to determine if a given peak should be considered as a noise, bases on its relative height compared to the highest peak.
   * @param {number}  [options.peakPicking.broadRatio=0.00025] - If broadRatio is higher than 0, then all the peaks which second derivative smaller than broadRatio * maxAbsSecondDerivative will be marked with the soft mask equal to true.
   * @param {number}  [options.peakPicking.broadWidth=0.25] - Threshold to determine if some peak is candidate to clustering into range.
   * @param {number}  [options.peakPicking.noiseLevel=median(data.y) * (options.thresholdFactor || 3)] - Noise threshold in spectrum y units. Default is three/thresholdFactor times the absolute median of data.y.
   * @param {number}  [options.peakPicking.factorWidth=4] - factor to determine the width at the moment to group the peaks in signals in 'GSD.optimizePeaks' function.
   * @param {object}  [options.peakPicking.shape={}] - it's specify the kind of shape used to fitting.
   * @param {string}  [options.peakPicking.shape.kind='gaussian'] - kind of shape; lorentzian, gaussian and pseudovoigt are supported.
   * @param {object}  [options.peakPicking.optimization={}] - it's specify the kind and options of the algorithm use to optimize parameters.
   * @param {string}  [options.peakPicking.optimization.kind='lm'] - kind of algorithm. By default it's levenberg-marquardt.
   * @param {object}  [options.peakPicking.optimization.options={}] - options for the specific kind of algorithm.
   * @param {Boolean} [options.peakPicking.compile=true] - If true, the Janalyzer function is run over signals to compile the patterns.
   * @param {Boolean} [options.peakPicking.smoothY=true] - Select the peak intensities from a smoothed version of the independent variables?
   * @param {Boolean} [options.peakPicking.optimize=true] - if it's true adjust an train of gaussian or lorentzian shapes to spectrum.
   * @param {Boolean} [options.peakPicking.optimize=true] - if it's true adjust an train of gaussian or lorentzian shapes to spectrum.
   * @param {Number}  [options.ranges.integrationSum=100] - Number of hydrogens or some number to normalize the integral data. If it's zero return the absolute integral value
   * @param {String}  [options.ranges.integralType='sum'] - option to chose between approx area with peaks or the sum of the points of given range ('sum', 'peaks')
   * @param {Number}  [options.ranges.frequencyCluster=16] - distance limit to clustering peaks.
   * @param {Number}  [options.ranges.clean=0.4] - If exits it remove all the signals with integration < clean value
   * @param {Boolean} [options.ranges.compile=true] - If true, the Janalyzer function is run over signals to compile the patterns.
   * @param {Boolean} [options.ranges.keepPeaks=false] - If true each signal will contain an array of peaks.
   * @param {String}  [options.ranges.nucleus='1H'] - Nucleus
   * @param {String}  [options.ranges.frequency=400] - Observed frequency
   * @param {object}  [options.impurities={}] - impurities options.
   * @param {string}  [options.impurities.solvent=''] - solvent name.
   * @param {string}  [options.impurities.error=0.025] - tolerance in ppm to assign a impurity.
   * @returns {array} - Array of ranges with {from, to, integral, signals: [{delta, j, multiplicity, peaks}]}
   */

  function xyAutoRangesPicking(data, options = {}) {
    let peaks = xyAutoPeaksPicking(data, options.peakPicking);
    peaks = peaksFilterImpurities(peaks, options.impurities);
    return peaksToRanges(data, peaks, options.ranges);
  }

  function signalsToRanges(signals, options = {}) {
    const {
      tolerance = 0.05,
      frequency = 400
    } = options;
    let wrapped = signals.map(signal => ({
      original: signal
    }));
    wrapped.forEach(signal => {
      let halfWidth = (signal.original.j || []).reduce((total, j) => total += j.coupling / frequency, 0) / 2 + tolerance;
      signal.from = signal.original.delta - halfWidth;
      signal.to = signal.original.delta + halfWidth;
    });
    wrapped = wrapped.sort((signal1, signal2) => signal1.from - signal2.from);
    let ranges = [];
    let range = {};

    for (let signal of wrapped) {
      if (range.from === undefined || signal.from > range.to) {
        range = {
          from: signal.from,
          to: signal.to,
          integral: signal.original.nbAtoms,
          signal: [signal.original]
        };
        ranges.push(range);
      } else {
        range.integral += signal.original.nbAtoms;
        if (signal.to > range.to) range.to = signal.to;
        range.signal.push(signal.original);
      }
    }

    return ranges;
  }

  /**
   * Created by acastillo on 8/8/16.
   */

  const defOptions = {
    threshold: 0,
    out: "assignment"
  }; //TODO Consider a matrix of distances too

  var src$1 = function fullClusterGenerator(conMat, opt) {
    const options = Object.assign({}, defOptions, opt);
    var clList, i, j, k;

    if (typeof conMat[0] === "number") {
      clList = fullClusterGeneratorVector(conMat);
    } else {
      if (typeof conMat[0] === "object") {
        var nRows = conMat.length;
        var conn = new Array(nRows * (nRows + 1) / 2);
        var index = 0;

        for (var i = 0; i < nRows; i++) {
          for (var j = i; j < nRows; j++) {
            if (conMat[i][j] > options.threshold) conn[index++] = 1;else conn[index++] = 0;
          }
        }

        clList = fullClusterGeneratorVector(conn);
      }
    }

    if (options.out === "indexes" || options.out === "values") {
      var result = new Array(clList.length);

      for (i = 0; i < clList.length; i++) {
        result[i] = [];

        for (j = 0; j < clList[i].length; j++) {
          if (clList[i][j] != 0) {
            result[i].push(j);
          }
        }
      }

      if (options.out === "values") {
        var resultAsMatrix = new Array(result.length);

        for (i = 0; i < result.length; i++) {
          resultAsMatrix[i] = new Array(result[i].length);

          for (j = 0; j < result[i].length; j++) {
            resultAsMatrix[i][j] = new Array(result[i].length);

            for (k = 0; k < result[i].length; k++) {
              resultAsMatrix[i][j][k] = conMat[result[i][j]][result[i][k]];
            }
          }
        }

        return resultAsMatrix;
      } else {
        return result;
      }
    }

    return clList;
  };

  function fullClusterGeneratorVector(conn) {
    var nRows = Math.sqrt(conn.length * 2 + 0.25) - 0.5;
    var clusterList = [];
    var available = new Array(nRows);
    var remaining = nRows,
        i = 0;
    var cluster = []; //Mark all the elements as available

    for (i = nRows - 1; i >= 0; i--) {
      available[i] = 1;
    }

    var nextAv = -1;
    var toInclude = [];

    while (remaining > 0) {
      if (toInclude.length === 0) {
        //If there is no more elements to include. Start a new cluster
        cluster = new Array(nRows);

        for (i = 0; i < nRows; i++) cluster[i] = 0;

        clusterList.push(cluster);

        for (nextAv = 0; available[nextAv] == 0; nextAv++) {}
      } else {
        nextAv = toInclude.splice(0, 1);
      }

      cluster[nextAv] = 1;
      available[nextAv] = 0;
      remaining--; //Copy the next available row

      var row = new Array(nRows);

      for (i = 0; i < nRows; i++) {
        var c = Math.max(nextAv, i);
        var r = Math.min(nextAv, i); //The element in the conn matrix
        //console.log("index: "+r*(2*nRows-r-1)/2+c)

        row[i] = conn[r * (2 * nRows - r - 1) / 2 + c]; //There is new elements to include in this row?
        //Then, include it to the current cluster

        if (row[i] == 1 && available[i] == 1 && cluster[i] == 0) {
          toInclude.push(i);
          cluster[i] = 1;
        }
      }
    }

    return clusterList;
  }

  function signalsToSpinSystem(signals) {
    const nSpins = signals.length;
    const chemicalShifts = new Array(nSpins);
    const multiplicity = new Array(nSpins);
    const couplingConstants = Matrix.zeros(nSpins, nSpins); //create a list of assignments

    const ids = {};

    for (let i = 0; i < nSpins; i++) {
      multiplicity[i] = 2;
      chemicalShifts[i] = signals[i].delta;
      ids[signals[i].assignment] = i;
    } //create the coupling matrix


    for (let i = 0; i < nSpins; i++) {
      let {
        assignment: signalAssignment,
        j: jCoupling
      } = signals[i];

      for (let k = 0; k < jCoupling.length; k++) {
        let {
          coupling,
          assignment
        } = jCoupling[k];
        couplingConstants.set(ids[signalAssignment], ids[assignment], coupling);
        couplingConstants.set(ids[assignment], ids[signalAssignment], coupling);
      }
    }

    const connectivity = Matrix.ones(couplingConstants.rows, couplingConstants.rows);

    for (let i = 0; i < couplingConstants.rows; i++) {
      for (let j = i; j < couplingConstants.columns; j++) {
        if (couplingConstants.get(i, j) === 0) {
          connectivity.set(i, j, 0);
          connectivity.set(j, i, 0);
        }
      }
    }

    let clusters = src$1(connectivity.to2DArray(), {
      out: 'indexes'
    });
    return {
      clusters,
      couplingConstants,
      chemicalShifts,
      multiplicity,
      connectivity
    };
  }

  var binarySearch = function (haystack, needle, comparator, low, high) {
    var mid, cmp;
    if (low === undefined) low = 0;else {
      low = low | 0;
      if (low < 0 || low >= haystack.length) throw new RangeError("invalid lower bound");
    }
    if (high === undefined) high = haystack.length - 1;else {
      high = high | 0;
      if (high < low || high >= haystack.length) throw new RangeError("invalid upper bound");
    }

    while (low <= high) {
      // The naive `low + high >>> 1` could fail for array lengths > 2**31
      // because `>>>` converts its operands to int32. `low + (high - low >>> 1)`
      // works for array lengths <= 2**32-1 which is also Javascript's max array
      // length.
      mid = low + (high - low >>> 1);
      cmp = +comparator(haystack[mid], needle, mid, haystack); // Too low.

      if (cmp < 0.0) low = mid + 1; // Too high.
      else if (cmp > 0.0) high = mid - 1; // Key found.
        else return mid;
    } // Key not found.


    return ~low;
  };

  var numSort = {};

  function assertNumber$1(number) {
    if (typeof number !== 'number') {
      throw new TypeError('Expected a number');
    }
  }

  var ascending = numSort.ascending = (left, right) => {
    assertNumber$1(left);
    assertNumber$1(right);

    if (Number.isNaN(left)) {
      return -1;
    }

    if (Number.isNaN(right)) {
      return 1;
    }

    return left - right;
  };

  numSort.descending = (left, right) => {
    assertNumber$1(left);
    assertNumber$1(right);

    if (Number.isNaN(left)) {
      return 1;
    }

    if (Number.isNaN(right)) {
      return -1;
    }

    return right - left;
  };

  const largestPrime = 0x7fffffff;
  const primeNumbers = [// chunk #0
  largestPrime, // 2^31-1
  // chunk #1
  5, 11, 23, 47, 97, 197, 397, 797, 1597, 3203, 6421, 12853, 25717, 51437, 102877, 205759, 411527, 823117, 1646237, 3292489, 6584983, 13169977, 26339969, 52679969, 105359939, 210719881, 421439783, 842879579, 1685759167, // chunk #2
  433, 877, 1759, 3527, 7057, 14143, 28289, 56591, 113189, 226379, 452759, 905551, 1811107, 3622219, 7244441, 14488931, 28977863, 57955739, 115911563, 231823147, 463646329, 927292699, 1854585413, // chunk #3
  953, 1907, 3821, 7643, 15287, 30577, 61169, 122347, 244703, 489407, 978821, 1957651, 3915341, 7830701, 15661423, 31322867, 62645741, 125291483, 250582987, 501165979, 1002331963, 2004663929, // chunk #4
  1039, 2081, 4177, 8363, 16729, 33461, 66923, 133853, 267713, 535481, 1070981, 2141977, 4283963, 8567929, 17135863, 34271747, 68543509, 137087021, 274174111, 548348231, 1096696463, // chunk #5
  31, 67, 137, 277, 557, 1117, 2237, 4481, 8963, 17929, 35863, 71741, 143483, 286973, 573953, 1147921, 2295859, 4591721, 9183457, 18366923, 36733847, 73467739, 146935499, 293871013, 587742049, 1175484103, // chunk #6
  599, 1201, 2411, 4831, 9677, 19373, 38747, 77509, 155027, 310081, 620171, 1240361, 2480729, 4961459, 9922933, 19845871, 39691759, 79383533, 158767069, 317534141, 635068283, 1270136683, // chunk #7
  311, 631, 1277, 2557, 5119, 10243, 20507, 41017, 82037, 164089, 328213, 656429, 1312867, 2625761, 5251529, 10503061, 21006137, 42012281, 84024581, 168049163, 336098327, 672196673, 1344393353, // chunk #8
  3, 7, 17, 37, 79, 163, 331, 673, 1361, 2729, 5471, 10949, 21911, 43853, 87719, 175447, 350899, 701819, 1403641, 2807303, 5614657, 11229331, 22458671, 44917381, 89834777, 179669557, 359339171, 718678369, 1437356741, // chunk #9
  43, 89, 179, 359, 719, 1439, 2879, 5779, 11579, 23159, 46327, 92657, 185323, 370661, 741337, 1482707, 2965421, 5930887, 11861791, 23723597, 47447201, 94894427, 189788857, 379577741, 759155483, 1518310967, // chunk #10
  379, 761, 1523, 3049, 6101, 12203, 24407, 48817, 97649, 195311, 390647, 781301, 1562611, 3125257, 6250537, 12501169, 25002389, 50004791, 100009607, 200019221, 400038451, 800076929, 1600153859, // chunk #11
  13, 29, 59, 127, 257, 521, 1049, 2099, 4201, 8419, 16843, 33703, 67409, 134837, 269683, 539389, 1078787, 2157587, 4315183, 8630387, 17260781, 34521589, 69043189, 138086407, 276172823, 552345671, 1104691373, // chunk #12
  19, 41, 83, 167, 337, 677, 1361, 2729, 5471, 10949, 21911, 43853, 87719, 175447, 350899, 701819, 1403641, 2807303, 5614657, 11229331, 22458671, 44917381, 89834777, 179669557, 359339171, 718678369, 1437356741, // chunk #13
  53, 107, 223, 449, 907, 1823, 3659, 7321, 14653, 29311, 58631, 117269, 234539, 469099, 938207, 1876417, 3752839, 7505681, 15011389, 30022781, 60045577, 120091177, 240182359, 480364727, 960729461, 1921458943];
  primeNumbers.sort(ascending);
  function nextPrime(value) {
    let index = binarySearch(primeNumbers, value, ascending);

    if (index < 0) {
      index = ~index;
    }

    return primeNumbers[index];
  }

  const FREE = 0;
  const FULL = 1;
  const REMOVED = 2;
  const defaultInitialCapacity = 150;
  const defaultMinLoadFactor = 1 / 6;
  const defaultMaxLoadFactor = 2 / 3;
  class HashTable {
    constructor(options = {}) {
      if (options instanceof HashTable) {
        this.table = options.table.slice();
        this.values = options.values.slice();
        this.state = options.state.slice();
        this.minLoadFactor = options.minLoadFactor;
        this.maxLoadFactor = options.maxLoadFactor;
        this.distinct = options.distinct;
        this.freeEntries = options.freeEntries;
        this.lowWaterMark = options.lowWaterMark;
        this.highWaterMark = options.maxLoadFactor;
        return;
      }

      const initialCapacity = options.initialCapacity === undefined ? defaultInitialCapacity : options.initialCapacity;

      if (initialCapacity < 0) {
        throw new RangeError(`initial capacity must not be less than zero: ${initialCapacity}`);
      }

      const minLoadFactor = options.minLoadFactor === undefined ? defaultMinLoadFactor : options.minLoadFactor;
      const maxLoadFactor = options.maxLoadFactor === undefined ? defaultMaxLoadFactor : options.maxLoadFactor;

      if (minLoadFactor < 0 || minLoadFactor >= 1) {
        throw new RangeError(`invalid minLoadFactor: ${minLoadFactor}`);
      }

      if (maxLoadFactor <= 0 || maxLoadFactor >= 1) {
        throw new RangeError(`invalid maxLoadFactor: ${maxLoadFactor}`);
      }

      if (minLoadFactor >= maxLoadFactor) {
        throw new RangeError(`minLoadFactor (${minLoadFactor}) must be smaller than maxLoadFactor (${maxLoadFactor})`);
      }

      let capacity = initialCapacity; // User wants to put at least capacity elements. We need to choose the size based on the maxLoadFactor to
      // avoid the need to rehash before this capacity is reached.
      // actualCapacity * maxLoadFactor >= capacity

      capacity = capacity / maxLoadFactor | 0;
      capacity = nextPrime(capacity);
      if (capacity === 0) capacity = 1;
      this.table = newArray(capacity);
      this.values = newArray(capacity);
      this.state = newArray(capacity);
      this.minLoadFactor = minLoadFactor;

      if (capacity === largestPrime) {
        this.maxLoadFactor = 1;
      } else {
        this.maxLoadFactor = maxLoadFactor;
      }

      this.distinct = 0;
      this.freeEntries = capacity;
      this.lowWaterMark = 0;
      this.highWaterMark = chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    clone() {
      return new HashTable(this);
    }

    get size() {
      return this.distinct;
    }

    get(key) {
      const i = this.indexOfKey(key);
      if (i < 0) return 0;
      return this.values[i];
    }

    set(key, value) {
      let i = this.indexOfInsertion(key);

      if (i < 0) {
        i = -i - 1;
        this.values[i] = value;
        return false;
      }

      if (this.distinct > this.highWaterMark) {
        const newCapacity = chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
        this.rehash(newCapacity);
        return this.set(key, value);
      }

      this.table[i] = key;
      this.values[i] = value;
      if (this.state[i] === FREE) this.freeEntries--;
      this.state[i] = FULL;
      this.distinct++;

      if (this.freeEntries < 1) {
        const newCapacity = chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
        this.rehash(newCapacity);
      }

      return true;
    }

    remove(key, noRehash) {
      const i = this.indexOfKey(key);
      if (i < 0) return false;
      this.state[i] = REMOVED;
      this.distinct--;
      if (!noRehash) this.maybeShrinkCapacity();
      return true;
    }

    delete(key, noRehash) {
      const i = this.indexOfKey(key);
      if (i < 0) return false;
      this.state[i] = FREE;
      this.distinct--;
      if (!noRehash) this.maybeShrinkCapacity();
      return true;
    }

    maybeShrinkCapacity() {
      if (this.distinct < this.lowWaterMark) {
        const newCapacity = chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
        this.rehash(newCapacity);
      }
    }

    containsKey(key) {
      return this.indexOfKey(key) >= 0;
    }

    indexOfKey(key) {
      const table = this.table;
      const state = this.state;
      const length = this.table.length;
      const hash = key & 0x7fffffff;
      let i = hash % length;
      let decrement = hash % (length - 2);
      if (decrement === 0) decrement = 1;

      while (state[i] !== FREE && (state[i] === REMOVED || table[i] !== key)) {
        i -= decrement;
        if (i < 0) i += length;
      }

      if (state[i] === FREE) return -1;
      return i;
    }

    containsValue(value) {
      return this.indexOfValue(value) >= 0;
    }

    indexOfValue(value) {
      const values = this.values;
      const state = this.state;

      for (var i = 0; i < state.length; i++) {
        if (state[i] === FULL && values[i] === value) {
          return i;
        }
      }

      return -1;
    }

    indexOfInsertion(key) {
      const table = this.table;
      const state = this.state;
      const length = table.length;
      const hash = key & 0x7fffffff;
      let i = hash % length;
      let decrement = hash % (length - 2);
      if (decrement === 0) decrement = 1;

      while (state[i] === FULL && table[i] !== key) {
        i -= decrement;
        if (i < 0) i += length;
      }

      if (state[i] === REMOVED) {
        const j = i;

        while (state[i] !== FREE && (state[i] === REMOVED || table[i] !== key)) {
          i -= decrement;
          if (i < 0) i += length;
        }

        if (state[i] === FREE) i = j;
      }

      if (state[i] === FULL) {
        return -i - 1;
      }

      return i;
    }

    ensureCapacity(minCapacity) {
      if (this.table.length < minCapacity) {
        const newCapacity = nextPrime(minCapacity);
        this.rehash(newCapacity);
      }
    }

    rehash(newCapacity) {
      const oldCapacity = this.table.length;
      if (newCapacity <= this.distinct) throw new Error('Unexpected');
      const oldTable = this.table;
      const oldValues = this.values;
      const oldState = this.state;
      const newTable = newArray(newCapacity);
      const newValues = newArray(newCapacity);
      const newState = newArray(newCapacity);
      this.lowWaterMark = chooseLowWaterMark(newCapacity, this.minLoadFactor);
      this.highWaterMark = chooseHighWaterMark(newCapacity, this.maxLoadFactor);
      this.table = newTable;
      this.values = newValues;
      this.state = newState;
      this.freeEntries = newCapacity - this.distinct;

      for (var i = 0; i < oldCapacity; i++) {
        if (oldState[i] === FULL) {
          var element = oldTable[i];
          var index = this.indexOfInsertion(element);
          newTable[index] = element;
          newValues[index] = oldValues[i];
          newState[index] = FULL;
        }
      }
    }

    forEachKey(callback) {
      for (var i = 0; i < this.state.length; i++) {
        if (this.state[i] === FULL) {
          if (!callback(this.table[i])) return false;
        }
      }

      return true;
    }

    forEachValue(callback) {
      for (var i = 0; i < this.state.length; i++) {
        if (this.state[i] === FULL) {
          if (!callback(this.values[i])) return false;
        }
      }

      return true;
    }

    forEachPair(callback) {
      for (var i = 0; i < this.state.length; i++) {
        if (this.state[i] === FULL) {
          if (!callback(this.table[i], this.values[i])) return false;
        }
      }

      return true;
    }

  }

  function chooseLowWaterMark(capacity, minLoad) {
    return capacity * minLoad | 0;
  }

  function chooseHighWaterMark(capacity, maxLoad) {
    return Math.min(capacity - 2, capacity * maxLoad | 0);
  }

  function chooseGrowCapacity(size, minLoad, maxLoad) {
    return nextPrime(Math.max(size + 1, 4 * size / (3 * minLoad + maxLoad) | 0));
  }

  function chooseShrinkCapacity(size, minLoad, maxLoad) {
    return nextPrime(Math.max(size + 1, 4 * size / (minLoad + 3 * maxLoad) | 0));
  }

  function newArray(size) {
    return Array(size).fill(0);
  }

  /* eslint-disable no-eval */
  class SparseMatrix {
    constructor(rows, columns, options = {}) {
      if (rows instanceof SparseMatrix) {
        // clone
        const other = rows;

        this._init(other.rows, other.columns, other.elements.clone(), other.threshold);

        return;
      }

      if (Array.isArray(rows)) {
        const matrix = rows;
        rows = matrix.length;
        options = columns || {};
        columns = matrix[0].length;

        this._init(rows, columns, new HashTable(options), options.threshold);

        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            let value = matrix[i][j];
            if (this.threshold && Math.abs(value) < this.threshold) value = 0;

            if (value !== 0) {
              this.elements.set(i * columns + j, matrix[i][j]);
            }
          }
        }
      } else {
        this._init(rows, columns, new HashTable(options), options.threshold);
      }
    }

    _init(rows, columns, elements, threshold) {
      this.rows = rows;
      this.columns = columns;
      this.elements = elements;
      this.threshold = threshold || 0;
    }

    static eye(rows = 1, columns = rows) {
      const min = Math.min(rows, columns);
      const matrix = new SparseMatrix(rows, columns, {
        initialCapacity: min
      });

      for (let i = 0; i < min; i++) {
        matrix.set(i, i, 1);
      }

      return matrix;
    }

    clone() {
      return new SparseMatrix(this);
    }

    to2DArray() {
      const copy = new Array(this.rows);

      for (let i = 0; i < this.rows; i++) {
        copy[i] = new Array(this.columns);

        for (let j = 0; j < this.columns; j++) {
          copy[i][j] = this.get(i, j);
        }
      }

      return copy;
    }

    isSquare() {
      return this.rows === this.columns;
    }

    isSymmetric() {
      if (!this.isSquare()) return false;
      let symmetric = true;
      this.forEachNonZero((i, j, v) => {
        if (this.get(j, i) !== v) {
          symmetric = false;
          return false;
        }

        return v;
      });
      return symmetric;
    }
    /**
     * Search for the wither band in the main diagonals
     * @return {number}
     */


    bandWidth() {
      let min = this.columns;
      let max = -1;
      this.forEachNonZero((i, j, v) => {
        let diff = i - j;
        min = Math.min(min, diff);
        max = Math.max(max, diff);
        return v;
      });
      return max - min;
    }
    /**
     * Test if a matrix is consider banded using a threshold
     * @param {number} width
     * @return {boolean}
     */


    isBanded(width) {
      let bandWidth = this.bandWidth();
      return bandWidth <= width;
    }

    get cardinality() {
      return this.elements.size;
    }

    get size() {
      return this.rows * this.columns;
    }

    get(row, column) {
      return this.elements.get(row * this.columns + column);
    }

    set(row, column, value) {
      if (this.threshold && Math.abs(value) < this.threshold) value = 0;

      if (value === 0) {
        this.elements.remove(row * this.columns + column);
      } else {
        this.elements.set(row * this.columns + column, value);
      }

      return this;
    }

    mmul(other) {
      if (this.columns !== other.rows) {
        // eslint-disable-next-line no-console
        console.warn('Number of columns of left matrix are not equal to number of rows of right matrix.');
      }

      const m = this.rows;
      const p = other.columns;
      const result = new SparseMatrix(m, p);
      this.forEachNonZero((i, j, v1) => {
        other.forEachNonZero((k, l, v2) => {
          if (j === k) {
            result.set(i, l, result.get(i, l) + v1 * v2);
          }

          return v2;
        });
        return v1;
      });
      return result;
    }

    kroneckerProduct(other) {
      const m = this.rows;
      const n = this.columns;
      const p = other.rows;
      const q = other.columns;
      const result = new SparseMatrix(m * p, n * q, {
        initialCapacity: this.cardinality * other.cardinality
      });
      this.forEachNonZero((i, j, v1) => {
        other.forEachNonZero((k, l, v2) => {
          result.set(p * i + k, q * j + l, v1 * v2);
          return v2;
        });
        return v1;
      });
      return result;
    }

    forEachNonZero(callback) {
      this.elements.forEachPair((key, value) => {
        const i = key / this.columns | 0;
        const j = key % this.columns;
        let r = callback(i, j, value);
        if (r === false) return false; // stop iteration

        if (this.threshold && Math.abs(r) < this.threshold) r = 0;

        if (r !== value) {
          if (r === 0) {
            this.elements.remove(key, true);
          } else {
            this.elements.set(key, r);
          }
        }

        return true;
      });
      this.elements.maybeShrinkCapacity();
      return this;
    }

    getNonZeros() {
      const cardinality = this.cardinality;
      const rows = new Array(cardinality);
      const columns = new Array(cardinality);
      const values = new Array(cardinality);
      let idx = 0;
      this.forEachNonZero((i, j, value) => {
        rows[idx] = i;
        columns[idx] = j;
        values[idx] = value;
        idx++;
        return value;
      });
      return {
        rows,
        columns,
        values
      };
    }

    setThreshold(newThreshold) {
      if (newThreshold !== 0 && newThreshold !== this.threshold) {
        this.threshold = newThreshold;
        this.forEachNonZero((i, j, v) => v);
      }

      return this;
    }
    /**
     * @return {SparseMatrix} - New transposed sparse matrix
     */


    transpose() {
      let trans = new SparseMatrix(this.columns, this.rows, {
        initialCapacity: this.cardinality
      });
      this.forEachNonZero((i, j, value) => {
        trans.set(j, i, value);
        return value;
      });
      return trans;
    }

    isEmpty() {
      return this.rows === 0 || this.columns === 0;
    }

  }
  SparseMatrix.prototype.klass = 'Matrix';
  SparseMatrix.identity = SparseMatrix.eye;
  SparseMatrix.prototype.tensorProduct = SparseMatrix.prototype.kroneckerProduct;
  /*
   Add dynamically instance and static methods for mathematical operations
   */

  let inplaceOperator = `
(function %name%(value) {
    if (typeof value === 'number') return this.%name%S(value);
    return this.%name%M(value);
})
`;
  let inplaceOperatorScalar = `
(function %name%S(value) {
    this.forEachNonZero((i, j, v) => v %op% value);
    return this;
})
`;
  let inplaceOperatorMatrix = `
(function %name%M(matrix) {
    matrix.forEachNonZero((i, j, v) => {
        this.set(i, j, this.get(i, j) %op% v);
        return v;
    });
    return this;
})
`;
  let staticOperator = `
(function %name%(matrix, value) {
    var newMatrix = new SparseMatrix(matrix);
    return newMatrix.%name%(value);
})
`;
  let inplaceMethod = `
(function %name%() {
    this.forEachNonZero((i, j, v) => %method%(v));
    return this;
})
`;
  let staticMethod = `
(function %name%(matrix) {
    var newMatrix = new SparseMatrix(matrix);
    return newMatrix.%name%();
})
`;
  const operators = [// Arithmetic operators
  ['+', 'add'], ['-', 'sub', 'subtract'], ['*', 'mul', 'multiply'], ['/', 'div', 'divide'], ['%', 'mod', 'modulus'], // Bitwise operators
  ['&', 'and'], ['|', 'or'], ['^', 'xor'], ['<<', 'leftShift'], ['>>', 'signPropagatingRightShift'], ['>>>', 'rightShift', 'zeroFillRightShift']];

  for (const operator of operators) {
    for (let i = 1; i < operator.length; i++) {
      SparseMatrix.prototype[operator[i]] = eval(fillTemplateFunction(inplaceOperator, {
        name: operator[i],
        op: operator[0]
      }));
      SparseMatrix.prototype[`${operator[i]}S`] = eval(fillTemplateFunction(inplaceOperatorScalar, {
        name: `${operator[i]}S`,
        op: operator[0]
      }));
      SparseMatrix.prototype[`${operator[i]}M`] = eval(fillTemplateFunction(inplaceOperatorMatrix, {
        name: `${operator[i]}M`,
        op: operator[0]
      }));
      SparseMatrix[operator[i]] = eval(fillTemplateFunction(staticOperator, {
        name: operator[i]
      }));
    }
  }

  let methods = [['~', 'not']];
  ['abs', 'acos', 'acosh', 'asin', 'asinh', 'atan', 'atanh', 'cbrt', 'ceil', 'clz32', 'cos', 'cosh', 'exp', 'expm1', 'floor', 'fround', 'log', 'log1p', 'log10', 'log2', 'round', 'sign', 'sin', 'sinh', 'sqrt', 'tan', 'tanh', 'trunc'].forEach(function (mathMethod) {
    methods.push([`Math.${mathMethod}`, mathMethod]);
  });

  for (const method of methods) {
    for (let i = 1; i < method.length; i++) {
      SparseMatrix.prototype[method[i]] = eval(fillTemplateFunction(inplaceMethod, {
        name: method[i],
        method: method[0]
      }));
      SparseMatrix[method[i]] = eval(fillTemplateFunction(staticMethod, {
        name: method[i]
      }));
    }
  }

  function fillTemplateFunction(template, values) {
    for (const i in values) {
      template = template.replace(new RegExp(`%${i}%`, 'g'), values[i]);
    }

    return template;
  }

  function addBaseline(data, baselineFct) {
    if (!baselineFct) return data;
    let xs = data.x;
    let ys = data.y;

    for (let i = 0; i < xs.length; i++) {
      ys[i] += baselineFct(xs[i]);
    }

    return data;
  }

  var defaultSource = Math.random;

  var randomUniform = (function sourceRandomUniform(source) {
    function randomUniform(min, max) {
      min = min == null ? 0 : +min;
      max = max == null ? 1 : +max;
      if (arguments.length === 1) max = min, min = 0;else max -= min;
      return function () {
        return source() * max + min;
      };
    }

    randomUniform.source = sourceRandomUniform;
    return randomUniform;
  })(defaultSource);

  var randomNormal = (function sourceRandomNormal(source) {
    function randomNormal(mu, sigma) {
      var x, r;
      mu = mu == null ? 0 : +mu;
      sigma = sigma == null ? 1 : +sigma;
      return function () {
        var y; // If available, use the second previously-generated uniform random.

        if (x != null) y = x, x = null; // Otherwise, generate a new x and y.
        else do {
            x = source() * 2 - 1;
            y = source() * 2 - 1;
            r = x * x + y * y;
          } while (!r || r > 1);
        return mu + sigma * y * Math.sqrt(-2 * Math.log(r) / r);
      };
    }

    randomNormal.source = sourceRandomNormal;
    return randomNormal;
  })(defaultSource);

  const LOOP = 8;
  const FLOAT_MUL = 1 / 16777216;
  const sh1 = 15;
  const sh2 = 18;
  const sh3 = 11;

  function multiply_uint32(n, m) {
    n >>>= 0;
    m >>>= 0;
    const nlo = n & 0xffff;
    const nhi = n - nlo;
    return (nhi * m >>> 0) + nlo * m >>> 0;
  }

  class XSadd {
    constructor(seed = Date.now()) {
      this.state = new Uint32Array(4);
      this.init(seed);
      this.random = this.getFloat.bind(this);
    }
    /**
     * Returns a 32-bit integer r (0 <= r < 2^32)
     */


    getUint32() {
      this.nextState();
      return this.state[3] + this.state[2] >>> 0;
    }
    /**
     * Returns a floating point number r (0.0 <= r < 1.0)
     */


    getFloat() {
      return (this.getUint32() >>> 8) * FLOAT_MUL;
    }

    init(seed) {
      if (!Number.isInteger(seed)) {
        throw new TypeError('seed must be an integer');
      }

      this.state[0] = seed;
      this.state[1] = 0;
      this.state[2] = 0;
      this.state[3] = 0;

      for (let i = 1; i < LOOP; i++) {
        this.state[i & 3] ^= i + multiply_uint32(1812433253, this.state[i - 1 & 3] ^ this.state[i - 1 & 3] >>> 30 >>> 0) >>> 0;
      }

      this.periodCertification();

      for (let i = 0; i < LOOP; i++) {
        this.nextState();
      }
    }

    periodCertification() {
      if (this.state[0] === 0 && this.state[1] === 0 && this.state[2] === 0 && this.state[3] === 0) {
        this.state[0] = 88; // X

        this.state[1] = 83; // S

        this.state[2] = 65; // A

        this.state[3] = 68; // D
      }
    }

    nextState() {
      let t = this.state[0];
      t ^= t << sh1;
      t ^= t >>> sh2;
      t ^= this.state[3] << sh3;
      this.state[0] = this.state[1];
      this.state[1] = this.state[2];
      this.state[2] = this.state[3];
      this.state[3] = t;
    }

  }

  function addNoise(data, percent = 0, options = {}) {
    const {
      distribution = 'uniform',
      seed
    } = options;
    let generateRandomNumber;

    switch (distribution) {
      case 'uniform':
        {
          generateRandomNumber = getRandom(randomUniform, seed, -0.5, 0.5);
          break;
        }

      case 'normal':
        {
          generateRandomNumber = getRandom(randomNormal, seed);
          break;
        }

      default:
        throw new Error(`Unknown distribution ${options.distribution}`);
    }

    if (!percent) return data;
    let ys = data.y;
    let factor = percent * findMax(ys) / 100;

    for (let i = 0; i < ys.length; i++) {
      ys[i] += generateRandomNumber() * factor;
    }

    return data;
  }

  function getRandom(func, seed, ...args) {
    return typeof seed === 'number' ? func.source(new XSadd(seed).random)(...args) : func(...args);
  }

  function findMax(array) {
    let max = Number.MIN_VALUE;

    for (let item of array) {
      if (item > max) max = item;
    }

    return max;
  }

  class SpectrumGenerator {
    /**
     *
     * @param {object} [options={}]
     * @param {number} [options.from=0]
     * @param {number} [options.to=0]
     * @param {function} [options.nbPoints=10001]
     * @param {number} [options.factor] default value depends of the shape in order to cover 99.99% of the surface
     * @param {object} [options.shape={kind:'gaussian'}]
     * @param {string} [options.shape.kind] kind of shape, gaussian, lorentzian or pseudovoigt
     * @param {object} [options.shape.options] options for the shape (like `mu` for pseudovoigt)
     */
    constructor(options = {}) {
      options = Object.assign({}, {
        from: 0,
        to: 1000,
        nbPoints: 10001,
        peakWidthFct: () => 5,
        shape: {
          kind: 'gaussian'
        }
      }, options);
      this.from = options.from;
      this.to = options.to;
      this.nbPoints = options.nbPoints;
      this.interval = (this.to - this.from) / (this.nbPoints - 1);
      this.peakWidthFct = options.peakWidthFct;
      this.maxPeakHeight = Number.MIN_SAFE_INTEGER;
      let shapeGenerator = getShapeGenerator(options.shape);
      this.shape = shapeGenerator;
      assertNumber(this.from, 'from');
      assertNumber(this.to, 'to');
      assertInteger(this.nbPoints, 'nbPoints');

      if (this.to <= this.from) {
        throw new RangeError('to option must be larger than from');
      }

      if (typeof this.peakWidthFct !== 'function') {
        throw new TypeError('peakWidthFct option must be a function');
      }

      this.reset();
    }

    addPeaks(peaks, options) {
      if (!Array.isArray(peaks) && (typeof peaks !== 'object' || peaks.x === undefined || peaks.y === undefined || !Array.isArray(peaks.x) || !Array.isArray(peaks.y) || peaks.x.length !== peaks.y.length)) {
        throw new TypeError('peaks must be an array or an object containing x[] and y[]');
      }

      if (Array.isArray(peaks)) {
        for (const peak of peaks) {
          this.addPeak(peak, options);
        }
      } else {
        for (let i = 0; i < peaks.x.length; i++) {
          this.addPeak([peaks.x[i], peaks.y[i]], options);
        }
      }

      return this;
    }
    /**
     *
     * @param {[x,y]|[x,y,w]|{x,y,width}} [peak]
     * @param {*} options
     */


    addPeak(peak, options = {}) {
      if (typeof peak !== 'object' || peak.length !== 2 && peak.length !== 3 && (peak.x === undefined || peak.y === undefined)) {
        throw new Error('peak must be an array with two (or three) values or an object with {x,y,width?}');
      }

      let xPosition;
      let intensity;
      let peakWidth;
      let peakOptions;

      if (Array.isArray(peak)) {
        [xPosition, intensity, peakWidth, peakOptions] = peak;
      } else {
        xPosition = peak.x;
        intensity = peak.y;
        peakWidth = peak.width;
        peakOptions = peak.options;
      }

      if (intensity > this.maxPeakHeight) this.maxPeakHeight = intensity;
      let {
        width = peakWidth === undefined ? this.peakWidthFct(xPosition) : peakWidth,
        widthLeft,
        widthRight,
        shape: shapeOptions
      } = options;

      if (peakOptions) {
        Object.assign(shapeOptions || {}, peakOptions || {});
      }

      let shapeGenerator = shapeOptions ? getShapeGenerator(shapeOptions) : this.shape;
      if (!widthLeft) widthLeft = width;
      if (!widthRight) widthRight = width;
      let factor = options.factor === undefined ? shapeGenerator.getFactor() : options.factor;
      const firstValue = xPosition - widthLeft / 2 * factor;
      const lastValue = xPosition + widthRight / 2 * factor;
      const firstPoint = Math.max(0, Math.floor((firstValue - this.from) / this.interval));
      const lastPoint = Math.min(this.nbPoints - 1, Math.ceil((lastValue - this.from) / this.interval));
      const middlePoint = Math.round((xPosition - this.from) / this.interval); // PEAK SHAPE MAY BE ASYMMETRC (widthLeft and widthRight) !
      // we calculate the left part of the shape

      shapeGenerator.setFWHM(widthLeft);

      for (let index = firstPoint; index < Math.max(middlePoint, 0); index++) {
        this.data.y[index] += intensity * shapeGenerator.fct(this.data.x[index] - xPosition);
      } // we calculate the right part of the gaussian


      shapeGenerator.setFWHM(widthRight);

      for (let index = Math.min(middlePoint, lastPoint); index <= lastPoint; index++) {
        this.data.y[index] += intensity * shapeGenerator.fct(this.data.x[index] - xPosition);
      }

      return this;
    }

    addBaseline(baselineFct) {
      addBaseline(this.data, baselineFct);
      return this;
    }

    addNoise(percent, options) {
      addNoise(this.data, percent, options);
      return this;
    }

    getSpectrum(options = {}) {
      if (typeof options === 'boolean') {
        options = {
          copy: options
        };
      }

      const {
        copy = true,
        threshold = 0
      } = options;

      if (threshold) {
        let minPeakHeight = this.maxPeakHeight * threshold;
        let x = [];
        let y = [];

        for (let i = 0; i < this.data.x.length; i++) {
          if (this.data.y[i] >= minPeakHeight) {
            x.push(this.data.x[i]);
            y.push(this.data.y[i]);
          }
        }

        return {
          x,
          y
        };
      }

      if (copy) {
        return {
          x: this.data.x.slice(),
          y: this.data.y.slice()
        };
      } else {
        return this.data;
      }
    }

    reset() {
      const spectrum = this.data = {
        x: new Float64Array(this.nbPoints),
        y: new Float64Array(this.nbPoints)
      };

      for (let i = 0; i < this.nbPoints; i++) {
        spectrum.x[i] = this.from + i * this.interval;
      }

      return this;
    }

  }

  function assertInteger(value, name) {
    if (!Number.isInteger(value)) {
      throw new TypeError(`${name} option must be an integer`);
    }
  }

  function assertNumber(value, name) {
    if (!Number.isFinite(value)) {
      throw new TypeError(`${name} option must be a number`);
    }
  }

  function createPauli(mult) {
    const spin = (mult - 1) / 2;
    const prjs = new Array(mult);
    const temp = new Array(mult);

    for (let i = 0; i < mult; i++) {
      prjs[i] = mult - 1 - i - spin;
      temp[i] = Math.sqrt(spin * (spin + 1) - prjs[i] * (prjs[i] + 1));
    }

    const p = diag(temp, 1, mult, mult);

    for (let i = 0; i < mult; i++) {
      temp[i] = Math.sqrt(spin * (spin + 1) - prjs[i] * (prjs[i] - 1));
    }

    const m = diag(temp, -1, mult, mult);
    const x = p.clone().add(m).mul(0.5);
    const y = m.clone().mul(-1).add(p).mul(-0.5);
    const z = diag(prjs, 0, mult, mult);
    return {
      x,
      y,
      z,
      m,
      p
    };
  }

  function diag(A, d, n, m) {
    const diag = new SparseMatrix(n, m, {
      initialCapacity: 20
    });

    for (let i = 0; i < A.length; i++) {
      if (i - d >= 0 && i - d < n && i < m) {
        diag.set(i - d, i, A[i]);
      }
    }

    return diag;
  }

  const pauli2 = createPauli(2);
  function getPauliMatrix(mult) {
    if (mult === 2) return pauli2;else return createPauli(mult);
  }

  const smallValue = 1e-2;
  /**
   * This function simulates a one dimensional nmr spectrum. This function returns an array containing the relative intensities of the spectrum in the specified simulation window (from-to).
   * @param {object} spinSystem - The SpinSystem object to be simulated
   * @param {object} [options={}] - options.
   * @param {number} [options.frequency=400] - The frequency in Mhz of the fake spectrometer that records the spectrum.
   * @param {number} [options.lineWidth=1] - The linewidth of the output spectrum, expresed in Hz.
   * @param {object} options.shape - options for spectrum-generator.
   * @param {string} [options.shape.kind='gaussian'] - kind of shape to generate the spectrum.
   * @param {object} options.shape.options - spectrum and shape options. See spectrum-generator for more information about shape options.
   * @param {number} [options.from=0] - The low limit of the ordinate variable.
   * @param {number} [options.to=10] - The upper limit of the ordinate variable.
   * @param {number} [options.nbPoints=16*1024] - Number of points of the output spectrum.
   * @param {number} [options.maxClusterSize=8] - Maximum number of atoms on each cluster that can be considered to be simulated together. It affects the the quality and speed of the simulation.
   * @return {object}
   */

  function simulate1D(spinSystem, options) {
    let {
      lineWidth = 1,
      maxClusterSize = 10,
      frequency: frequencyMHz = 400,
      shape = {
        kind: 'gaussian',
        options: {
          from: 0,
          to: 10,
          nbPoints: 1024
        }
      }
    } = options;
    let {
      options: shapeOptions
    } = shape;
    let peakWidth = lineWidth / frequencyMHz;

    shapeOptions.peakWidthFct = () => peakWidth;

    let spectrumGenerator = new SpectrumGenerator(shapeOptions);
    const chemicalShifts = spinSystem.chemicalShifts.slice();

    for (let i = 0; i < chemicalShifts.length; i++) {
      chemicalShifts[i] = chemicalShifts[i] * frequencyMHz;
    }

    const multiplicity = spinSystem.multiplicity;

    for (let h = 0; h < spinSystem.clusters.length; h++) {
      const cluster = spinSystem.clusters[h];
      let clusterFake = new Array(cluster.length);

      for (let i = 0; i < cluster.length; i++) {
        clusterFake[i] = cluster[i] < 0 ? -cluster[i] - 1 : cluster[i];
      }

      let weight = 1;
      let sumI = 0;
      let frequencies = [];
      let intensities = [];

      if (cluster.length > maxClusterSize) {
        // This is a single spin, but the cluster exceeds the maxClusterSize criteria
        // we use the simple multiplicity algorithm
        // Add the central peak. It will be split with every single J coupling.
        let index = 0;

        while (cluster[index++] < 0);

        index = cluster[index - 1];
        frequencies.push(-chemicalShifts[index]);

        for (let i = 0; i < cluster.length; i++) {
          if (cluster[i] < 0) {
            let jc = spinSystem.couplingConstants.get(index, clusterFake[i]) / 2;
            let currentSize = frequencies.length;

            for (let j = 0; j < currentSize; j++) {
              frequencies.push(frequencies[j] + jc);
              frequencies[j] -= jc;
            }
          }
        }

        frequencies = Float64Array.from(frequencies).sort();
        sumI = frequencies.length;
        weight = 1;

        for (let i = 0; i < sumI; i++) {
          intensities.push(1);
        }
      } else {
        const hamiltonian = getHamiltonian(chemicalShifts, spinSystem.couplingConstants, multiplicity, spinSystem.connectivity, clusterFake);
        const hamSize = hamiltonian.rows;
        const evd = new EigenvalueDecomposition(hamiltonian);
        const V = evd.eigenvectorMatrix;
        const diagB = evd.realEigenvalues;
        const assignmentMatrix = new SparseMatrix(hamSize, hamSize);
        const multLen = cluster.length;
        weight = 0;

        for (let n = 0; n < multLen; n++) {
          const L = getPauliMatrix(multiplicity[clusterFake[n]]);
          let temp = 1;

          for (let j = 0; j < n; j++) {
            temp *= multiplicity[clusterFake[j]];
          }

          const A = SparseMatrix.eye(temp);
          temp = 1;

          for (let j = n + 1; j < multLen; j++) {
            temp *= multiplicity[clusterFake[j]];
          }

          const B = SparseMatrix.eye(temp);
          const tempMat = A.kroneckerProduct(L.m).kroneckerProduct(B);

          if (cluster[n] >= 0) {
            assignmentMatrix.add(tempMat.mul(cluster[n] + 1));
            weight++;
          } else {
            assignmentMatrix.add(tempMat.mul(cluster[n]));
          }
        }

        let rhoip = Matrix.zeros(hamSize, hamSize);
        assignmentMatrix.forEachNonZero((i, j, v) => {
          if (v > 0) {
            for (let k = 0; k < V.columns; k++) {
              let element = V.get(j, k);

              if (element !== 0) {
                rhoip.set(i, k, rhoip.get(i, k) + element);
              }
            }
          }

          return v;
        });
        let rhoip2 = rhoip.clone();
        assignmentMatrix.forEachNonZero((i, j, v) => {
          if (v < 0) {
            for (let k = 0; k < V.columns; k++) {
              let element = V.get(j, k);

              if (element !== 0) {
                rhoip2.set(i, k, rhoip2.get(i, k) + element);
              }
            }
          }

          return v;
        });
        const tV = V.transpose();
        rhoip = tV.mmul(rhoip);
        rhoip = new SparseMatrix(rhoip.to2DArray(), {
          threshold: smallValue
        });
        triuTimesAbs(rhoip, smallValue);
        rhoip2 = tV.mmul(rhoip2);
        rhoip2 = new SparseMatrix(rhoip2.to2DArray(), {
          threshold: smallValue
        });
        rhoip2.forEachNonZero((i, j, v) => {
          return v;
        });
        triuTimesAbs(rhoip2, smallValue);
        rhoip2.forEachNonZero((i, j, v) => {
          let val = rhoip.get(i, j);
          val = Math.min(Math.abs(val), Math.abs(v));
          val *= val;
          sumI += val;
          let valFreq = diagB[i] - diagB[j];
          let insertIn = binarySearch(frequencies, valFreq, (a, b) => a - b);

          if (insertIn < 0) {
            frequencies.splice(-1 - insertIn, 0, valFreq);
            intensities.splice(-1 - insertIn, 0, val);
          } else {
            intensities[insertIn] += val;
          }
        });
      }

      const numFreq = frequencies.length;

      if (numFreq > 0) {
        weight /= sumI;
        const diff = lineWidth / 64;
        let valFreq = frequencies[0];
        let inte = intensities[0];
        let count = 1;

        for (let i = 1; i < numFreq; i++) {
          if (Math.abs(frequencies[i] - valFreq / count) < diff) {
            inte += intensities[i];
            valFreq += frequencies[i];
            count++;
          } else {
            spectrumGenerator.addPeak({
              x: -valFreq / count / frequencyMHz,
              y: inte * weight
            });
            valFreq = frequencies[i];
            inte = intensities[i];
            count = 1;
          }
        }

        spectrumGenerator.addPeak({
          x: -valFreq / count / frequencyMHz,
          y: inte * weight
        });
      }
    }

    return spectrumGenerator.data;
  }

  function triuTimesAbs(A, val) {
    A.forEachNonZero((i, j, v) => {
      if (i > j) return 0;
      if (Math.abs(v) <= val) return 0;
      return v;
    });
  }
  /**
   * Create a hamiltonian matrix for the given spinsystem
   * @param {Array} chemicalShifts - An array containing the chemical shift in Hz
   * @param {Array} couplingConstants - An array containing the coupling constants in Hz
   * @param {Array} multiplicity - An array specifiying the multiplicities of each scalar coupling
   * @param {Array} conMatrix - A one step connectivity matrix for the given spin system
   * @param {Array} cluster - An binary array specifiying the spins to be considered for this hamiltonial
   * @return {object}
   */


  function getHamiltonian(chemicalShifts, couplingConstants, multiplicity, conMatrix, cluster) {
    let hamSize = 1;

    for (let i = 0; i < cluster.length; i++) {
      hamSize *= multiplicity[cluster[i]];
    }

    const clusterHam = new SparseMatrix(hamSize, hamSize);

    for (let pos = 0; pos < cluster.length; pos++) {
      let n = cluster[pos];
      const L = getPauliMatrix(multiplicity[n]);
      let A1, B1;
      let temp = 1;

      for (let i = 0; i < pos; i++) {
        temp *= multiplicity[cluster[i]];
      }

      A1 = SparseMatrix.eye(temp);
      temp = 1;

      for (let i = pos + 1; i < cluster.length; i++) {
        temp *= multiplicity[cluster[i]];
      }

      B1 = SparseMatrix.eye(temp);
      const alpha = chemicalShifts[n];
      const kronProd = A1.kroneckerProduct(L.z).kroneckerProduct(B1);
      clusterHam.add(kronProd.mul(alpha));

      for (let pos2 = 0; pos2 < cluster.length; pos2++) {
        const k = cluster[pos2];

        if (conMatrix.get(n, k) === 1) {
          const S = getPauliMatrix(multiplicity[k]);
          let A2, B2;
          let temp = 1;

          for (let i = 0; i < pos2; i++) {
            temp *= multiplicity[cluster[i]];
          }

          A2 = SparseMatrix.eye(temp);
          temp = 1;

          for (let i = pos2 + 1; i < cluster.length; i++) {
            temp *= multiplicity[cluster[i]];
          }

          B2 = SparseMatrix.eye(temp);
          const kron1 = A1.kroneckerProduct(L.x).kroneckerProduct(B1).mmul(A2.kroneckerProduct(S.x).kroneckerProduct(B2));
          kron1.add(A1.kroneckerProduct(L.y).kroneckerProduct(B1).mul(-1).mmul(A2.kroneckerProduct(S.y).kroneckerProduct(B2)));
          kron1.add(A1.kroneckerProduct(L.z).kroneckerProduct(B1).mmul(A2.kroneckerProduct(S.z).kroneckerProduct(B2)));
          clusterHam.add(kron1.mul(couplingConstants.get(n, k) / 2));
        }
      }
    }

    return clusterHam;
  }

  function squaredEuclidean(p, q) {
    let d = 0;

    for (let i = 0; i < p.length; i++) {
      d += (p[i] - q[i]) * (p[i] - q[i]);
    }

    return d;
  }
  function euclidean(p, q) {
    return Math.sqrt(squaredEuclidean(p, q));
  }

  /**
   * Computes a distance/similarity matrix given an array of data and a distance/similarity function.
   * @param {Array} data An array of data
   * @param {function} distanceFn  A function that accepts two arguments and computes a distance/similarity between them
   * @return {Array<Array>} The distance/similarity matrix. The matrix is square and has a size equal to the length of
   * the data array
   */
  function distanceMatrix(data, distanceFn) {
    const result = getMatrix(data.length); // Compute upper distance matrix

    for (let i = 0; i < data.length; i++) {
      for (let j = 0; j <= i; j++) {
        result[i][j] = distanceFn(data[i], data[j]);
        result[j][i] = result[i][j];
      }
    }

    return result;
  }

  function getMatrix(size) {
    const matrix = [];

    for (let i = 0; i < size; i++) {
      const row = [];
      matrix.push(row);

      for (let j = 0; j < size; j++) {
        row.push(0);
      }
    }

    return matrix;
  }

  var heap$1 = {exports: {}};

  (function (module, exports) {
    // Generated by CoffeeScript 1.8.0
    (function () {
      var Heap, defaultCmp, floor, heapify, heappop, heappush, heappushpop, heapreplace, insort, min, nlargest, nsmallest, updateItem, _siftdown, _siftup;

      floor = Math.floor, min = Math.min;
      /*
      Default comparison function to be used
       */

      defaultCmp = function (x, y) {
        if (x < y) {
          return -1;
        }

        if (x > y) {
          return 1;
        }

        return 0;
      };
      /*
      Insert item x in list a, and keep it sorted assuming a is sorted.
      
      If x is already in a, insert it to the right of the rightmost x.
      
      Optional args lo (default 0) and hi (default a.length) bound the slice
      of a to be searched.
       */


      insort = function (a, x, lo, hi, cmp) {
        var mid;

        if (lo == null) {
          lo = 0;
        }

        if (cmp == null) {
          cmp = defaultCmp;
        }

        if (lo < 0) {
          throw new Error('lo must be non-negative');
        }

        if (hi == null) {
          hi = a.length;
        }

        while (lo < hi) {
          mid = floor((lo + hi) / 2);

          if (cmp(x, a[mid]) < 0) {
            hi = mid;
          } else {
            lo = mid + 1;
          }
        }

        return [].splice.apply(a, [lo, lo - lo].concat(x)), x;
      };
      /*
      Push item onto heap, maintaining the heap invariant.
       */


      heappush = function (array, item, cmp) {
        if (cmp == null) {
          cmp = defaultCmp;
        }

        array.push(item);
        return _siftdown(array, 0, array.length - 1, cmp);
      };
      /*
      Pop the smallest item off the heap, maintaining the heap invariant.
       */


      heappop = function (array, cmp) {
        var lastelt, returnitem;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        lastelt = array.pop();

        if (array.length) {
          returnitem = array[0];
          array[0] = lastelt;

          _siftup(array, 0, cmp);
        } else {
          returnitem = lastelt;
        }

        return returnitem;
      };
      /*
      Pop and return the current smallest value, and add the new item.
      
      This is more efficient than heappop() followed by heappush(), and can be
      more appropriate when using a fixed size heap. Note that the value
      returned may be larger than item! That constrains reasonable use of
      this routine unless written as part of a conditional replacement:
          if item > array[0]
            item = heapreplace(array, item)
       */


      heapreplace = function (array, item, cmp) {
        var returnitem;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        returnitem = array[0];
        array[0] = item;

        _siftup(array, 0, cmp);

        return returnitem;
      };
      /*
      Fast version of a heappush followed by a heappop.
       */


      heappushpop = function (array, item, cmp) {
        var _ref;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        if (array.length && cmp(array[0], item) < 0) {
          _ref = [array[0], item], item = _ref[0], array[0] = _ref[1];

          _siftup(array, 0, cmp);
        }

        return item;
      };
      /*
      Transform list into a heap, in-place, in O(array.length) time.
       */


      heapify = function (array, cmp) {
        var i, _i, _len, _ref1, _results, _results1;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        _ref1 = function () {
          _results1 = [];

          for (var _j = 0, _ref = floor(array.length / 2); 0 <= _ref ? _j < _ref : _j > _ref; 0 <= _ref ? _j++ : _j--) {
            _results1.push(_j);
          }

          return _results1;
        }.apply(this).reverse();

        _results = [];

        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
          i = _ref1[_i];

          _results.push(_siftup(array, i, cmp));
        }

        return _results;
      };
      /*
      Update the position of the given item in the heap.
      This function should be called every time the item is being modified.
       */


      updateItem = function (array, item, cmp) {
        var pos;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        pos = array.indexOf(item);

        if (pos === -1) {
          return;
        }

        _siftdown(array, 0, pos, cmp);

        return _siftup(array, pos, cmp);
      };
      /*
      Find the n largest elements in a dataset.
       */


      nlargest = function (array, n, cmp) {
        var elem, result, _i, _len, _ref;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        result = array.slice(0, n);

        if (!result.length) {
          return result;
        }

        heapify(result, cmp);
        _ref = array.slice(n);

        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          elem = _ref[_i];
          heappushpop(result, elem, cmp);
        }

        return result.sort(cmp).reverse();
      };
      /*
      Find the n smallest elements in a dataset.
       */


      nsmallest = function (array, n, cmp) {
        var elem, los, result, _i, _j, _len, _ref, _ref1, _results;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        if (n * 10 <= array.length) {
          result = array.slice(0, n).sort(cmp);

          if (!result.length) {
            return result;
          }

          los = result[result.length - 1];
          _ref = array.slice(n);

          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            elem = _ref[_i];

            if (cmp(elem, los) < 0) {
              insort(result, elem, 0, null, cmp);
              result.pop();
              los = result[result.length - 1];
            }
          }

          return result;
        }

        heapify(array, cmp);
        _results = [];

        for (_j = 0, _ref1 = min(n, array.length); 0 <= _ref1 ? _j < _ref1 : _j > _ref1; 0 <= _ref1 ? ++_j : --_j) {
          _results.push(heappop(array, cmp));
        }

        return _results;
      };

      _siftdown = function (array, startpos, pos, cmp) {
        var newitem, parent, parentpos;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        newitem = array[pos];

        while (pos > startpos) {
          parentpos = pos - 1 >> 1;
          parent = array[parentpos];

          if (cmp(newitem, parent) < 0) {
            array[pos] = parent;
            pos = parentpos;
            continue;
          }

          break;
        }

        return array[pos] = newitem;
      };

      _siftup = function (array, pos, cmp) {
        var childpos, endpos, newitem, rightpos, startpos;

        if (cmp == null) {
          cmp = defaultCmp;
        }

        endpos = array.length;
        startpos = pos;
        newitem = array[pos];
        childpos = 2 * pos + 1;

        while (childpos < endpos) {
          rightpos = childpos + 1;

          if (rightpos < endpos && !(cmp(array[childpos], array[rightpos]) < 0)) {
            childpos = rightpos;
          }

          array[pos] = array[childpos];
          pos = childpos;
          childpos = 2 * pos + 1;
        }

        array[pos] = newitem;
        return _siftdown(array, startpos, pos, cmp);
      };

      Heap = function () {
        Heap.push = heappush;
        Heap.pop = heappop;
        Heap.replace = heapreplace;
        Heap.pushpop = heappushpop;
        Heap.heapify = heapify;
        Heap.updateItem = updateItem;
        Heap.nlargest = nlargest;
        Heap.nsmallest = nsmallest;

        function Heap(cmp) {
          this.cmp = cmp != null ? cmp : defaultCmp;
          this.nodes = [];
        }

        Heap.prototype.push = function (x) {
          return heappush(this.nodes, x, this.cmp);
        };

        Heap.prototype.pop = function () {
          return heappop(this.nodes, this.cmp);
        };

        Heap.prototype.peek = function () {
          return this.nodes[0];
        };

        Heap.prototype.contains = function (x) {
          return this.nodes.indexOf(x) !== -1;
        };

        Heap.prototype.replace = function (x) {
          return heapreplace(this.nodes, x, this.cmp);
        };

        Heap.prototype.pushpop = function (x) {
          return heappushpop(this.nodes, x, this.cmp);
        };

        Heap.prototype.heapify = function () {
          return heapify(this.nodes, this.cmp);
        };

        Heap.prototype.updateItem = function (x) {
          return updateItem(this.nodes, x, this.cmp);
        };

        Heap.prototype.clear = function () {
          return this.nodes = [];
        };

        Heap.prototype.empty = function () {
          return this.nodes.length === 0;
        };

        Heap.prototype.size = function () {
          return this.nodes.length;
        };

        Heap.prototype.clone = function () {
          var heap;
          heap = new Heap();
          heap.nodes = this.nodes.slice(0);
          return heap;
        };

        Heap.prototype.toArray = function () {
          return this.nodes.slice(0);
        };

        Heap.prototype.insert = Heap.prototype.push;
        Heap.prototype.top = Heap.prototype.peek;
        Heap.prototype.front = Heap.prototype.peek;
        Heap.prototype.has = Heap.prototype.contains;
        Heap.prototype.copy = Heap.prototype.clone;
        return Heap;
      }();

      (function (root, factory) {
        {
          return module.exports = factory();
        }
      })(this, function () {
        return Heap;
      });
    }).call(commonjsGlobal);
  })(heap$1);

  var heap = heap$1.exports;

  class Cluster {
    constructor() {
      this.children = [];
      this.height = 0;
      this.size = 1;
      this.index = -1;
      this.isLeaf = false;
    }
    /**
     * Creates an array of clusters where the maximum height is smaller than the threshold
     * @param {number} threshold
     * @return {Array<Cluster>}
     */


    cut(threshold) {
      if (typeof threshold !== 'number') {
        throw new TypeError('threshold must be a number');
      }

      if (threshold < 0) {
        throw new RangeError('threshold must be a positive number');
      }

      let list = [this];
      const ans = [];

      while (list.length > 0) {
        const aux = list.shift();

        if (threshold >= aux.height) {
          ans.push(aux);
        } else {
          list = list.concat(aux.children);
        }
      }

      return ans;
    }
    /**
     * Merge the leaves in the minimum way to have `groups` number of clusters.
     * @param {number} groups - Them number of children the first level of the tree should have.
     * @return {Cluster}
     */


    group(groups) {
      if (!Number.isInteger(groups) || groups < 1) {
        throw new RangeError('groups must be a positive integer');
      }

      const heap$1 = new heap((a, b) => {
        return b.height - a.height;
      });
      heap$1.push(this);

      while (heap$1.size() < groups) {
        var first = heap$1.pop();

        if (first.children.length === 0) {
          break;
        }

        first.children.forEach(child => heap$1.push(child));
      }

      var root = new Cluster();
      root.children = heap$1.toArray();
      root.height = this.height;
      return root;
    }
    /**
     * Traverses the tree depth-first and calls the provided callback with each individual node
     * @param {function} cb - The callback to be called on each node encounter
     */


    traverse(cb) {
      function visit(root, callback) {
        callback(root);

        if (root.children) {
          for (const child of root.children) {
            visit(child, callback);
          }
        }
      }

      visit(this, cb);
    }
    /**
     * Returns a list of indices for all the leaves of this cluster.
     * The list is ordered in such a way that a dendrogram could be drawn without crossing branches.
     * @returns {Array<number>}
     */


    indices() {
      const result = [];
      this.traverse(cluster => {
        if (cluster.isLeaf) {
          result.push(cluster.index);
        }
      });
      return result;
    }

  }

  function singleLink(dKI, dKJ) {
    return Math.min(dKI, dKJ);
  }

  function completeLink(dKI, dKJ) {
    return Math.max(dKI, dKJ);
  }

  function averageLink(dKI, dKJ, dIJ, ni, nj) {
    const ai = ni / (ni + nj);
    const aj = nj / (ni + nj);
    return ai * dKI + aj * dKJ;
  }

  function weightedAverageLink(dKI, dKJ) {
    return (dKI + dKJ) / 2;
  }

  function centroidLink(dKI, dKJ, dIJ, ni, nj) {
    const ai = ni / (ni + nj);
    const aj = nj / (ni + nj);
    const b = -(ni * nj) / (ni + nj) ** 2;
    return ai * dKI + aj * dKJ + b * dIJ;
  }

  function medianLink(dKI, dKJ, dIJ) {
    return dKI / 2 + dKJ / 2 - dIJ / 4;
  }

  function wardLink(dKI, dKJ, dIJ, ni, nj, nk) {
    const ai = (ni + nk) / (ni + nj + nk);
    const aj = (nj + nk) / (ni + nj + nk);
    const b = -nk / (ni + nj + nk);
    return ai * dKI + aj * dKJ + b * dIJ;
  }

  function wardLink2(dKI, dKJ, dIJ, ni, nj, nk) {
    const ai = (ni + nk) / (ni + nj + nk);
    const aj = (nj + nk) / (ni + nj + nk);
    const b = -nk / (ni + nj + nk);
    return Math.sqrt(ai * dKI * dKI + aj * dKJ * dKJ + b * dIJ * dIJ);
  }
  /**
   * Continuously merge nodes that have the least dissimilarity
   * @param {Array<Array<number>>} data - Array of points to be clustered
   * @param {object} [options]
   * @param {Function} [options.distanceFunction]
   * @param {string} [options.method] - Default: `'complete'`
   * @param {boolean} [options.isDistanceMatrix] - Is the input already a distance matrix?
   * @constructor
   */


  function agnes(data, options = {}) {
    const {
      distanceFunction = euclidean,
      method = 'complete',
      isDistanceMatrix = false
    } = options;
    let updateFunc;

    if (!isDistanceMatrix) {
      data = distanceMatrix(data, distanceFunction);
    }

    let distanceMatrix$1 = new Matrix(data);
    const numLeaves = distanceMatrix$1.rows; // allows to use a string or a given function

    if (typeof method === 'string') {
      switch (method.toLowerCase()) {
        case 'single':
          updateFunc = singleLink;
          break;

        case 'complete':
          updateFunc = completeLink;
          break;

        case 'average':
        case 'upgma':
          updateFunc = averageLink;
          break;

        case 'wpgma':
          updateFunc = weightedAverageLink;
          break;

        case 'centroid':
        case 'upgmc':
          updateFunc = centroidLink;
          break;

        case 'median':
        case 'wpgmc':
          updateFunc = medianLink;
          break;

        case 'ward':
          updateFunc = wardLink;
          break;

        case 'ward2':
          updateFunc = wardLink2;
          break;

        default:
          throw new RangeError(`unknown clustering method: ${method}`);
      }
    } else if (typeof method !== 'function') {
      throw new TypeError('method must be a string or function');
    }

    let clusters = [];

    for (let i = 0; i < numLeaves; i++) {
      const cluster = new Cluster();
      cluster.isLeaf = true;
      cluster.index = i;
      clusters.push(cluster);
    }

    for (let n = 0; n < numLeaves - 1; n++) {
      const [row, column, distance] = getSmallestDistance(distanceMatrix$1);
      const cluster1 = clusters[row];
      const cluster2 = clusters[column];
      const newCluster = new Cluster();
      newCluster.size = cluster1.size + cluster2.size;
      newCluster.children.push(cluster1, cluster2);
      newCluster.height = distance;
      const newClusters = [newCluster];
      const newDistanceMatrix = new Matrix(distanceMatrix$1.rows - 1, distanceMatrix$1.rows - 1);

      const previous = newIndex => getPreviousIndex(newIndex, Math.min(row, column), Math.max(row, column));

      for (let i = 1; i < newDistanceMatrix.rows; i++) {
        const prevI = previous(i);
        const prevICluster = clusters[prevI];
        newClusters.push(prevICluster);

        for (let j = 0; j < i; j++) {
          if (j === 0) {
            const dKI = distanceMatrix$1.get(row, prevI);
            const dKJ = distanceMatrix$1.get(prevI, column);
            const val = updateFunc(dKI, dKJ, distance, cluster1.size, cluster2.size, prevICluster.size);
            newDistanceMatrix.set(i, j, val);
            newDistanceMatrix.set(j, i, val);
          } else {
            // Just copy distance from previous matrix
            const val = distanceMatrix$1.get(prevI, previous(j));
            newDistanceMatrix.set(i, j, val);
            newDistanceMatrix.set(j, i, val);
          }
        }
      }

      clusters = newClusters;
      distanceMatrix$1 = newDistanceMatrix;
    }

    return clusters[0];
  }

  function getSmallestDistance(distance) {
    let smallest = Infinity;
    let smallestI = 0;
    let smallestJ = 0;

    for (let i = 1; i < distance.rows; i++) {
      for (let j = 0; j < i; j++) {
        if (distance.get(i, j) < smallest) {
          smallest = distance.get(i, j);
          smallestI = i;
          smallestJ = j;
        }
      }
    }

    return [smallestI, smallestJ, smallest];
  }

  function getPreviousIndex(newIndex, prev1, prev2) {
    newIndex -= 1;
    if (newIndex >= prev1) newIndex++;
    if (newIndex >= prev2) newIndex++;
    return newIndex;
  }

  function splitSpinSystem(spinSystem, options = {}) {
    let {
      chemicalShifts,
      couplingConstants,
      connectivity
    } = spinSystem;
    let {
      frequency = 400,
      maxClusterSize = 8
    } = options;
    let betas = calculateBetas(chemicalShifts, couplingConstants, frequency);
    let initClusters = agnes(betas, {
      method: 'single',
      isDistanceMatrix: true
    });
    let clusterList = [];
    let nSpins = chemicalShifts.length;
    splitCluster(initClusters, clusterList, {
      maxClusterSize,
      force: false,
      nSpins,
      connectivity
    });
    let mergedClusters = mergeClusters(clusterList, maxClusterSize);
    let nClusters = mergedClusters.length;
    let clusters = new Array(nClusters);

    for (let j = 0; j < nClusters; j++) {
      clusters[j] = [];

      for (let i = 0; i < nSpins; i++) {
        let element = mergedClusters[j][i];
        if (element === 0) continue;
        clusters[j].push(element < 0 ? -(i + 1) : i);
      }
    }

    return clusters;
  }

  function splitCluster(cluster, clusterList, options = {}) {
    let {
      maxClusterSize,
      force,
      nSpins,
      connectivity
    } = options;

    if (!force && cluster.size <= maxClusterSize) {
      clusterList.push(getMembers(cluster.indices(), nSpins));
    } else {
      for (let child of cluster.children) {
        if (child.size <= maxClusterSize) {
          let members = getMembers(child.indices(), nSpins); // Add the neighbors that shares at least 1 coupling with the given cluster

          let count = 0;

          for (let i = 0; i < nSpins; i++) {
            if (members[i] === 1) {
              for (let j = 0; j < nSpins; j++) {
                if (connectivity.get(i, j) === 1 && members[j] === 0) {
                  members[j] = -1;
                  count++;
                }
              }

              count++;
            }
          }

          if (count <= maxClusterSize) {
            clusterList.push(members);
          } else {
            if (child.index < 0) {
              splitCluster(child, clusterList, {
                maxClusterSize,
                force: true,
                nSpins,
                connectivity
              });
            } else {
              // We have to threat this spin alone and use the resurrection algorithm instead of the simulation
              members[child.index] = 2;
              clusterList.push(members);
            }
          }
        } else {
          splitCluster(child, clusterList, {
            maxClusterSize,
            force: false,
            nSpins,
            connectivity
          });
        }
      }
    }
  }

  function calculateBetas(chemicalShifts, couplingConstants, frequency) {
    let nRows = couplingConstants.rows;
    let nColumns = couplingConstants.columns;
    let betas = Matrix.zeros(nRows, nRows); // Before clustering, we must add hidden couplingConstants, we could use molecular information if available

    for (let i = 0; i < nRows; i++) {
      for (let j = i; j < nColumns; j++) {
        let element = couplingConstants.get(i, j);

        if (chemicalShifts[i] - chemicalShifts[j] !== 0) {
          let value = 1 - Math.abs(element / ((chemicalShifts[i] - chemicalShifts[j]) * frequency));
          betas.set(i, j, value);
          betas.set(j, i, value);
        } else if (!(i === j || element !== 0)) {
          betas.set(i, j, 1);
          betas.set(j, i, 1);
        }
      }
    }

    return betas.to2DArray();
  }

  function mergeClusters(list, maxClusterSize) {
    for (let i = list.length - 1; i >= 0; i--) {
      let clusterA = list[i];
      let nElements = clusterA.length;
      let index = 0; // Is it a candidate to be merged?

      while (index < nElements && clusterA[index++] !== -1);

      if (index >= nElements) continue;

      for (let j = list.length - 1; j >= i + 1; j--) {
        let clusterB = list[j]; // Do they have common elements?

        let count = 0;
        let common = 0;

        for (let index = 0; index < nElements; index++) {
          if (clusterA[index] * clusterB[index] === -1) common++;
          if (clusterA[index] !== 0 || clusterB[index] !== 0) count++;
        }

        if (common > 0 && count <= maxClusterSize) {
          // Then we can merge those 2 clusters
          for (let index = 0; index < nElements; index++) {
            if (clusterB[index] === 1) {
              clusterA[index] = 1;
            } else if (clusterB[index] === -1 && clusterA[index] !== 1) {
              clusterA[index] = -1;
            }
          }

          list.splice(j, 1);
        }
      }
    }

    return list;
  }

  function getMembers(cluster, nSpins) {
    let members = new Int16Array(nSpins);

    for (let e of cluster) {
      members[e] = 1;
    }

    return members;
  }

  /**
   * Generate a spectrum from an array of singals
   * @param {array} signals
   * @param {object} [options={}]
   * @param {number} [options.frequency=400] Frequency (in MHz) of the simulated spectrum
   * @param {number} [options.maxValue=1e8] Default height of the simulated spectrum
   * @param {number} [options.maxClusterSize=8] Maximal size of a cluster before dividing the problem. Smaller value increase the speed but reduce the quality
   * @param {object} [options.shape] Shape of the peaks, by default gaussian shape
   * @returns  {object} an object of the kind {x:[], y:[]}
   */

  function signalsToXY(signals, options = {}) {
    let {
      frequency = 400,
      shape = {
        kind: 'gaussian',
        options: {
          from: 0,
          to: 10,
          nbPoints: 16 * 1024
        }
      },
      maxValue = 1e8,
      maxClusterSize = 8
    } = options;
    let spinSystem = signalsToSpinSystem(signals);
    spinSystem.clusters = splitSpinSystem(spinSystem, {
      frequency,
      maxClusterSize
    });
    let spectrum = simulate1D(spinSystem, {
      frequency,
      shape
    });

    if (maxValue) {
      spectrum.y = rescale(spectrum.y, {
        max: maxValue
      });
    }

    return spectrum;
  }

  const couplingPatterns = ['s', 'd', 't', 'q', 'quint', 'h', 'sept', 'o', 'n'];

  const couplingValues = {
    s: 0,
    d: 1,
    t: 2,
    q: 3,
    quint: 4,
    h: 5,
    hex: 5,
    hept: 6,
    sept: 6,
    oct: 7,
    o: 7,
    non: 8,
    n: 8
  };

  /**
   *
   * @param {array<string>} patterns
   * @returns
   */

  function joinPatterns(patterns) {
    let sum = 0;

    for (let pattern of patterns) {
      if (couplingValues[pattern] !== undefined) {
        sum += couplingValues[pattern];
      } else {
        throw new Error(`Unknown multiplicity: ${pattern}`);
      }
    }

    return couplingPatterns[sum];
  }

  /**
   * Ensure that assignment and diaID are arrays and coupling are sorted
   * @param {object} signal
   * @returns signal
   */
  function signalNormalize(signal) {
    signal = JSON.parse(JSON.stringify(signal));

    if (signal.assignment && !Array.isArray(signal.assignment)) {
      signal.assignment = [signal.assignment];
    }

    if (signal.diaID && !Array.isArray(signal.diaID)) {
      signal.diaID = [signal.diaID];
    }

    if (signal.j) {
      let couplings = signal.j;

      for (let coupling of couplings) {
        if (coupling.assignment && !Array.isArray(coupling.assignment)) {
          coupling.assignment = [coupling.assignment];
        }

        if (coupling.diaID && !Array.isArray(coupling.diaID)) {
          coupling.diaID = [coupling.diaID];
        }
      }

      signal.j = signal.j.sort((a, b) => b.coupling - a.coupling);
    }

    return signal;
  }

  /**
   * Join couplings smaller than a define tolerance.
   * The resulting coupling should be an average of the existing one.
   * This function will also ensure that assignment and diaID are arrays.
   * If distance is specified and is not always the same this property will be removed.
   * @param {object} signal
   * @param {object} [options={}]
   * @param {number} [options.tolerance=0.05] tolerance to merge the couplings
   * @returns signal
   */

  function signalJoinCouplings(signal, options = {}) {
    const {
      tolerance = 0.05
    } = options;
    signal = signalNormalize(signal);
    if (!signal.j || signal.j.length < 2) return signal; // we group the couplings that are less than the expected tolerance

    let currentGroup = [signal.j[0]];
    let groups = [currentGroup];

    for (let i = 1; i < signal.j.length; i++) {
      let currentJ = signal.j[i];

      if (currentGroup[currentGroup.length - 1].coupling - currentJ.coupling < tolerance) {
        currentGroup.push(currentJ);
      } else {
        currentGroup = [currentJ];
        groups.push(currentGroup);
      }
    }

    signal.j = [];

    for (let group of groups) {
      let coupling = sum(group.map(group => group.coupling)) / group.length;
      let assignment = distinctValues(group.filter(group => group.assignment && group.assignment.length > 0).map(group => group.assignment).flat());
      let diaID = distinctValues(group.filter(group => group.diaID && group.diaID.length > 0).map(group => group.diaID).flat());
      let distances = distinctValues(group.map(group => group.distance));
      let multiplicity = joinPatterns(group.map(group => group.multiplicity));
      let newJ = {
        coupling,
        multiplicity
      };
      if (diaID.length > 0) newJ.diaID = diaID;
      if (distances.length === 1 && distances[0]) newJ.distance = distances[0];
      if (assignment.length > 0) newJ.assignment = assignment;
      signal.j.push(newJ);
    }

    return signal;
  }

  function distinctValues(array) {
    return [...new Set(array)];
  }

  /**
   * Return
   * @param {*} signal
   */
  function signalMultiplicityPattern(signal) {
    let js = signal.j;
    let pattern = '';

    if (js && js.length > 0) {
      for (let coupling of js) {
        pattern += coupling.multiplicity;
      }
    } else if (signal.delta) {
      pattern = 's';
    } else {
      pattern = 'm';
    }

    return pattern;
  }

  const globalOptions = {
    h: {
      nucleus: '1H',
      nbDecimalDelta: 2,
      nbDecimalJ: 1,
      observedFrequency: 400
    },
    c: {
      nucleus: '13C',
      nbDecimalDelta: 1,
      nbDecimalJ: 1,
      observedFrequency: 100
    },
    f: {
      nucleus: '19F',
      nbDecimalDelta: 2,
      nbDecimalJ: 1,
      observedFrequency: 400
    }
  };
  /**
   *
   * @param {array} ranges
   * @param {object} [options={}]
   * @param {boolean} [options.filter=true] remove annotated signals as solvent and impurities
   * @param {number} [options.nucleus]
   * @param {number} [options.nbDecimalDelta] default value depends of nucleus
   * @param {number} [options.nbDecimalJ] default value depends of nucleus
   * @param {number} [options.observedFrequency] default value depends of nucleus 1H: 400MHz
   */

  function rangesToACS(ranges, options = {}) {
    if (!options.nucleus) options.nucleus = '1H';
    let nucleus = options.nucleus.toLowerCase().replace(/[0-9]/g, '');
    let defaultOptions = globalOptions[nucleus];
    options = Object.assign({}, defaultOptions, {
      ascending: false,
      format: 'IMJA'
    }, options);
    ranges = JSON.parse(JSON.stringify(ranges));

    if (options.ascending === true) {
      ranges.sort((a, b) => {
        let fromA = Math.min(a.from, a.to);
        let fromB = Math.min(b.from, b.to);
        return fromA - fromB;
      });
    }

    let acsString = formatAcs(ranges, options);
    if (acsString.length > 0) acsString += '.';
    return acsString;
  }

  function formatAcs(ranges, options) {
    let acs = spectroInformation(options);
    if (acs.length === 0) acs = 'δ ';
    let acsRanges = [];

    for (let range of ranges) {
      if (uselessKind(range.kind, options.filter)) continue;
      pushDelta(range, acsRanges, options);
    }

    if (acsRanges.length > 0) {
      return acs + acsRanges.join(', ');
    } else {
      return '';
    }
  }

  function spectroInformation(options) {
    let parenthesis = [];
    let strings = `${formatNucleus(options.nucleus)} NMR`;

    if (options.solvent) {
      parenthesis.push(formatMF(options.solvent));
    }

    if (options.frequencyObserved) {
      parenthesis.push(`${(options.frequencyObserved * 1).toFixed(0)} MHz`);
    }

    if (parenthesis.length > 0) {
      strings += ` (${parenthesis.join(', ')}): δ `;
    } else {
      strings += ': δ ';
    }

    return strings;
  }

  function pushDelta(range, acsRanges, options) {
    let strings = '';
    let parenthesis = [];
    let fromTo = [range.from, range.to];

    if (Array.isArray(range.signal)) {
      range.signal = range.signal.filter(signal => !uselessKind(signal.kind, options.filter));
    }

    if (Array.isArray(range.signal) && range.signal.length > 0) {
      let signals = range.signal;

      if (signals.length > 1) {
        if (options.ascending === true) {
          signals.sort((a, b) => {
            return a.delta - b.delta;
          });
        }

        strings += `${Math.min(...fromTo).toFixed(options.nbDecimalDelta)}-${Math.max(...fromTo).toFixed(options.nbDecimalDelta)}`;
        strings += ` (${getIntegral(range, options)}`;

        for (let signal of signals) {
          parenthesis = [];

          if (signal.delta !== undefined) {
            strings = appendSeparator(strings);
            strings += signal.delta.toFixed(options.nbDecimalDelta);
          }

          switchFormat({}, signal, parenthesis, options);
          if (parenthesis.length > 0) strings += ` (${parenthesis.join(', ')})`;
        }

        strings += ')';
      } else {
        parenthesis = [];

        if (signals[0].delta !== undefined) {
          strings += signals[0].delta.toFixed(options.nbDecimalDelta);
          switchFormat(range, signals[0], parenthesis, options);
          if (parenthesis.length > 0) strings += ` (${parenthesis.join(', ')})`;
        } else {
          strings += `${Math.min(...fromTo).toFixed(options.nbDecimalDelta)}-${Math.max(...fromTo).toFixed(options.nbDecimalDelta)}`;
          switchFormat(range, signals[0], parenthesis, options);
          if (parenthesis.length > 0) strings += ` (${parenthesis})`;
        }
      }
    } else {
      strings += `${Math.min(...fromTo).toFixed(options.nbDecimalDelta)}-${Math.max(...fromTo).toFixed(options.nbDecimalDelta)}`;
      switchFormat(range, [], parenthesis, options);
      if (parenthesis.length > 0) strings += ` (${parenthesis.join(', ')})`;
    }

    acsRanges.push(strings);
  }

  function getIntegral(range, options) {
    let integral = '';

    if (range.pubIntegral) {
      integral = range.pubIntegral;
    } else if (range.integral) {
      integral = range.integral.toFixed(0) + options.nucleus[options.nucleus.length - 1];
    }

    return integral;
  }

  function pushIntegral(range, parenthesis, options) {
    let integral = getIntegral(range, options);
    if (integral.length > 0) parenthesis.push(integral);
  }

  function pushMultiplicityFromSignal(signal, parenthesis) {
    let multiplicity = signal.multiplicity;

    if (!multiplicity) {
      let joinedCouplings = signalJoinCouplings(signal, {
        tolerance: 0.05
      });
      multiplicity = signalMultiplicityPattern(joinedCouplings);
    }

    if (multiplicity.length > 0) parenthesis.push(multiplicity);
  }

  function switchFormat(range, signal, parenthesis, options) {
    for (const char of options.format) {
      switch (char.toUpperCase()) {
        case 'I':
          pushIntegral(range, parenthesis, options);
          break;

        case 'M':
          pushMultiplicityFromSignal(signal, parenthesis);
          break;

        case 'A':
          pushAssignment(signal, parenthesis);
          break;

        case 'J':
          pushCoupling(signal, parenthesis, options);
          break;

        default:
          throw new Error(`Unknow format letter: ${char}`);
      }
    }
  }

  function formatMF(mf) {
    return mf.replace(/(?<num>[0-9]+)/g, '<sub>$<num></sub>');
  }

  function formatNucleus(nucleus) {
    return nucleus.replace(/(?<num>[0-9]+)/g, '<sup>$<num></sup>');
  }

  function appendSeparator(strings) {
    if (strings.length > 0 && !strings.match(/ $/) && !strings.match(/\($/)) {
      strings += ', ';
    }

    return strings;
  }

  function formatAssignment(assignment) {
    assignment = assignment.replace(/(?<num>[0-9]+)/g, '<sub>$<num></sub>');
    assignment = assignment.replace(/"(?<i>[^"]*)"/g, '<i>$<i></i>');
    return assignment;
  }

  function pushCoupling(signal, parenthesis, options) {
    if (Array.isArray(signal.j) && signal.j.length > 0) {
      signal.j.sort(function (a, b) {
        return b.coupling - a.coupling;
      });
      let values = [];

      for (let j of signal.j) {
        if (j.coupling !== undefined) {
          values.push(j.coupling.toFixed(options.nbDecimalJ));
        }
      }

      if (values.length > 0) {
        parenthesis.push(`<i>J</i> = ${values.join(', ')} Hz`);
      }
    }
  }

  function pushAssignment(signal, parenthesis) {
    if (signal.pubAssignment) {
      parenthesis.push(formatAssignment(signal.pubAssignment));
    } else if (signal.assignment) {
      parenthesis.push(formatAssignment(signal.assignment));
    }
  }

  function uselessKind(kind = '', filter = true) {
    kind = kind.toLowerCase();
    if (filter && (kind === 'impurity' || kind === 'solvent')) return true;
    return false;
  }

  var browserPonyfill = {exports: {}};

  (function (module, exports) {
    var global = typeof self !== 'undefined' ? self : commonjsGlobal;

    var __self__ = function () {
      function F() {
        this.fetch = false;
        this.DOMException = global.DOMException;
      }

      F.prototype = global;
      return new F();
    }();

    (function (self) {
      (function (exports) {
        var support = {
          searchParams: 'URLSearchParams' in self,
          iterable: 'Symbol' in self && 'iterator' in Symbol,
          blob: 'FileReader' in self && 'Blob' in self && function () {
            try {
              new Blob();
              return true;
            } catch (e) {
              return false;
            }
          }(),
          formData: 'FormData' in self,
          arrayBuffer: 'ArrayBuffer' in self
        };

        function isDataView(obj) {
          return obj && DataView.prototype.isPrototypeOf(obj);
        }

        if (support.arrayBuffer) {
          var viewClasses = ['[object Int8Array]', '[object Uint8Array]', '[object Uint8ClampedArray]', '[object Int16Array]', '[object Uint16Array]', '[object Int32Array]', '[object Uint32Array]', '[object Float32Array]', '[object Float64Array]'];

          var isArrayBufferView = ArrayBuffer.isView || function (obj) {
            return obj && viewClasses.indexOf(Object.prototype.toString.call(obj)) > -1;
          };
        }

        function normalizeName(name) {
          if (typeof name !== 'string') {
            name = String(name);
          }

          if (/[^a-z0-9\-#$%&'*+.^_`|~]/i.test(name)) {
            throw new TypeError('Invalid character in header field name');
          }

          return name.toLowerCase();
        }

        function normalizeValue(value) {
          if (typeof value !== 'string') {
            value = String(value);
          }

          return value;
        } // Build a destructive iterator for the value list


        function iteratorFor(items) {
          var iterator = {
            next: function () {
              var value = items.shift();
              return {
                done: value === undefined,
                value: value
              };
            }
          };

          if (support.iterable) {
            iterator[Symbol.iterator] = function () {
              return iterator;
            };
          }

          return iterator;
        }

        function Headers(headers) {
          this.map = {};

          if (headers instanceof Headers) {
            headers.forEach(function (value, name) {
              this.append(name, value);
            }, this);
          } else if (Array.isArray(headers)) {
            headers.forEach(function (header) {
              this.append(header[0], header[1]);
            }, this);
          } else if (headers) {
            Object.getOwnPropertyNames(headers).forEach(function (name) {
              this.append(name, headers[name]);
            }, this);
          }
        }

        Headers.prototype.append = function (name, value) {
          name = normalizeName(name);
          value = normalizeValue(value);
          var oldValue = this.map[name];
          this.map[name] = oldValue ? oldValue + ', ' + value : value;
        };

        Headers.prototype['delete'] = function (name) {
          delete this.map[normalizeName(name)];
        };

        Headers.prototype.get = function (name) {
          name = normalizeName(name);
          return this.has(name) ? this.map[name] : null;
        };

        Headers.prototype.has = function (name) {
          return this.map.hasOwnProperty(normalizeName(name));
        };

        Headers.prototype.set = function (name, value) {
          this.map[normalizeName(name)] = normalizeValue(value);
        };

        Headers.prototype.forEach = function (callback, thisArg) {
          for (var name in this.map) {
            if (this.map.hasOwnProperty(name)) {
              callback.call(thisArg, this.map[name], name, this);
            }
          }
        };

        Headers.prototype.keys = function () {
          var items = [];
          this.forEach(function (value, name) {
            items.push(name);
          });
          return iteratorFor(items);
        };

        Headers.prototype.values = function () {
          var items = [];
          this.forEach(function (value) {
            items.push(value);
          });
          return iteratorFor(items);
        };

        Headers.prototype.entries = function () {
          var items = [];
          this.forEach(function (value, name) {
            items.push([name, value]);
          });
          return iteratorFor(items);
        };

        if (support.iterable) {
          Headers.prototype[Symbol.iterator] = Headers.prototype.entries;
        }

        function consumed(body) {
          if (body.bodyUsed) {
            return Promise.reject(new TypeError('Already read'));
          }

          body.bodyUsed = true;
        }

        function fileReaderReady(reader) {
          return new Promise(function (resolve, reject) {
            reader.onload = function () {
              resolve(reader.result);
            };

            reader.onerror = function () {
              reject(reader.error);
            };
          });
        }

        function readBlobAsArrayBuffer(blob) {
          var reader = new FileReader();
          var promise = fileReaderReady(reader);
          reader.readAsArrayBuffer(blob);
          return promise;
        }

        function readBlobAsText(blob) {
          var reader = new FileReader();
          var promise = fileReaderReady(reader);
          reader.readAsText(blob);
          return promise;
        }

        function readArrayBufferAsText(buf) {
          var view = new Uint8Array(buf);
          var chars = new Array(view.length);

          for (var i = 0; i < view.length; i++) {
            chars[i] = String.fromCharCode(view[i]);
          }

          return chars.join('');
        }

        function bufferClone(buf) {
          if (buf.slice) {
            return buf.slice(0);
          } else {
            var view = new Uint8Array(buf.byteLength);
            view.set(new Uint8Array(buf));
            return view.buffer;
          }
        }

        function Body() {
          this.bodyUsed = false;

          this._initBody = function (body) {
            this._bodyInit = body;

            if (!body) {
              this._bodyText = '';
            } else if (typeof body === 'string') {
              this._bodyText = body;
            } else if (support.blob && Blob.prototype.isPrototypeOf(body)) {
              this._bodyBlob = body;
            } else if (support.formData && FormData.prototype.isPrototypeOf(body)) {
              this._bodyFormData = body;
            } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
              this._bodyText = body.toString();
            } else if (support.arrayBuffer && support.blob && isDataView(body)) {
              this._bodyArrayBuffer = bufferClone(body.buffer); // IE 10-11 can't handle a DataView body.

              this._bodyInit = new Blob([this._bodyArrayBuffer]);
            } else if (support.arrayBuffer && (ArrayBuffer.prototype.isPrototypeOf(body) || isArrayBufferView(body))) {
              this._bodyArrayBuffer = bufferClone(body);
            } else {
              this._bodyText = body = Object.prototype.toString.call(body);
            }

            if (!this.headers.get('content-type')) {
              if (typeof body === 'string') {
                this.headers.set('content-type', 'text/plain;charset=UTF-8');
              } else if (this._bodyBlob && this._bodyBlob.type) {
                this.headers.set('content-type', this._bodyBlob.type);
              } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
                this.headers.set('content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
              }
            }
          };

          if (support.blob) {
            this.blob = function () {
              var rejected = consumed(this);

              if (rejected) {
                return rejected;
              }

              if (this._bodyBlob) {
                return Promise.resolve(this._bodyBlob);
              } else if (this._bodyArrayBuffer) {
                return Promise.resolve(new Blob([this._bodyArrayBuffer]));
              } else if (this._bodyFormData) {
                throw new Error('could not read FormData body as blob');
              } else {
                return Promise.resolve(new Blob([this._bodyText]));
              }
            };

            this.arrayBuffer = function () {
              if (this._bodyArrayBuffer) {
                return consumed(this) || Promise.resolve(this._bodyArrayBuffer);
              } else {
                return this.blob().then(readBlobAsArrayBuffer);
              }
            };
          }

          this.text = function () {
            var rejected = consumed(this);

            if (rejected) {
              return rejected;
            }

            if (this._bodyBlob) {
              return readBlobAsText(this._bodyBlob);
            } else if (this._bodyArrayBuffer) {
              return Promise.resolve(readArrayBufferAsText(this._bodyArrayBuffer));
            } else if (this._bodyFormData) {
              throw new Error('could not read FormData body as text');
            } else {
              return Promise.resolve(this._bodyText);
            }
          };

          if (support.formData) {
            this.formData = function () {
              return this.text().then(decode);
            };
          }

          this.json = function () {
            return this.text().then(JSON.parse);
          };

          return this;
        } // HTTP methods whose capitalization should be normalized


        var methods = ['DELETE', 'GET', 'HEAD', 'OPTIONS', 'POST', 'PUT'];

        function normalizeMethod(method) {
          var upcased = method.toUpperCase();
          return methods.indexOf(upcased) > -1 ? upcased : method;
        }

        function Request(input, options) {
          options = options || {};
          var body = options.body;

          if (input instanceof Request) {
            if (input.bodyUsed) {
              throw new TypeError('Already read');
            }

            this.url = input.url;
            this.credentials = input.credentials;

            if (!options.headers) {
              this.headers = new Headers(input.headers);
            }

            this.method = input.method;
            this.mode = input.mode;
            this.signal = input.signal;

            if (!body && input._bodyInit != null) {
              body = input._bodyInit;
              input.bodyUsed = true;
            }
          } else {
            this.url = String(input);
          }

          this.credentials = options.credentials || this.credentials || 'same-origin';

          if (options.headers || !this.headers) {
            this.headers = new Headers(options.headers);
          }

          this.method = normalizeMethod(options.method || this.method || 'GET');
          this.mode = options.mode || this.mode || null;
          this.signal = options.signal || this.signal;
          this.referrer = null;

          if ((this.method === 'GET' || this.method === 'HEAD') && body) {
            throw new TypeError('Body not allowed for GET or HEAD requests');
          }

          this._initBody(body);
        }

        Request.prototype.clone = function () {
          return new Request(this, {
            body: this._bodyInit
          });
        };

        function decode(body) {
          var form = new FormData();
          body.trim().split('&').forEach(function (bytes) {
            if (bytes) {
              var split = bytes.split('=');
              var name = split.shift().replace(/\+/g, ' ');
              var value = split.join('=').replace(/\+/g, ' ');
              form.append(decodeURIComponent(name), decodeURIComponent(value));
            }
          });
          return form;
        }

        function parseHeaders(rawHeaders) {
          var headers = new Headers(); // Replace instances of \r\n and \n followed by at least one space or horizontal tab with a space
          // https://tools.ietf.org/html/rfc7230#section-3.2

          var preProcessedHeaders = rawHeaders.replace(/\r?\n[\t ]+/g, ' ');
          preProcessedHeaders.split(/\r?\n/).forEach(function (line) {
            var parts = line.split(':');
            var key = parts.shift().trim();

            if (key) {
              var value = parts.join(':').trim();
              headers.append(key, value);
            }
          });
          return headers;
        }

        Body.call(Request.prototype);

        function Response(bodyInit, options) {
          if (!options) {
            options = {};
          }

          this.type = 'default';
          this.status = options.status === undefined ? 200 : options.status;
          this.ok = this.status >= 200 && this.status < 300;
          this.statusText = 'statusText' in options ? options.statusText : 'OK';
          this.headers = new Headers(options.headers);
          this.url = options.url || '';

          this._initBody(bodyInit);
        }

        Body.call(Response.prototype);

        Response.prototype.clone = function () {
          return new Response(this._bodyInit, {
            status: this.status,
            statusText: this.statusText,
            headers: new Headers(this.headers),
            url: this.url
          });
        };

        Response.error = function () {
          var response = new Response(null, {
            status: 0,
            statusText: ''
          });
          response.type = 'error';
          return response;
        };

        var redirectStatuses = [301, 302, 303, 307, 308];

        Response.redirect = function (url, status) {
          if (redirectStatuses.indexOf(status) === -1) {
            throw new RangeError('Invalid status code');
          }

          return new Response(null, {
            status: status,
            headers: {
              location: url
            }
          });
        };

        exports.DOMException = self.DOMException;

        try {
          new exports.DOMException();
        } catch (err) {
          exports.DOMException = function (message, name) {
            this.message = message;
            this.name = name;
            var error = Error(message);
            this.stack = error.stack;
          };

          exports.DOMException.prototype = Object.create(Error.prototype);
          exports.DOMException.prototype.constructor = exports.DOMException;
        }

        function fetch(input, init) {
          return new Promise(function (resolve, reject) {
            var request = new Request(input, init);

            if (request.signal && request.signal.aborted) {
              return reject(new exports.DOMException('Aborted', 'AbortError'));
            }

            var xhr = new XMLHttpRequest();

            function abortXhr() {
              xhr.abort();
            }

            xhr.onload = function () {
              var options = {
                status: xhr.status,
                statusText: xhr.statusText,
                headers: parseHeaders(xhr.getAllResponseHeaders() || '')
              };
              options.url = 'responseURL' in xhr ? xhr.responseURL : options.headers.get('X-Request-URL');
              var body = 'response' in xhr ? xhr.response : xhr.responseText;
              resolve(new Response(body, options));
            };

            xhr.onerror = function () {
              reject(new TypeError('Network request failed'));
            };

            xhr.ontimeout = function () {
              reject(new TypeError('Network request failed'));
            };

            xhr.onabort = function () {
              reject(new exports.DOMException('Aborted', 'AbortError'));
            };

            xhr.open(request.method, request.url, true);

            if (request.credentials === 'include') {
              xhr.withCredentials = true;
            } else if (request.credentials === 'omit') {
              xhr.withCredentials = false;
            }

            if ('responseType' in xhr && support.blob) {
              xhr.responseType = 'blob';
            }

            request.headers.forEach(function (value, name) {
              xhr.setRequestHeader(name, value);
            });

            if (request.signal) {
              request.signal.addEventListener('abort', abortXhr);

              xhr.onreadystatechange = function () {
                // DONE (success or failure)
                if (xhr.readyState === 4) {
                  request.signal.removeEventListener('abort', abortXhr);
                }
              };
            }

            xhr.send(typeof request._bodyInit === 'undefined' ? null : request._bodyInit);
          });
        }

        fetch.polyfill = true;

        if (!self.fetch) {
          self.fetch = fetch;
          self.Headers = Headers;
          self.Request = Request;
          self.Response = Response;
        }

        exports.Headers = Headers;
        exports.Request = Request;
        exports.Response = Response;
        exports.fetch = fetch;
        Object.defineProperty(exports, '__esModule', {
          value: true
        });
        return exports;
      })({});
    })(__self__);

    __self__.fetch.ponyfill = true; // Remove "polyfill" property added by whatwg-fetch

    delete __self__.fetch.polyfill; // Choose between native implementation (global) or custom implementation (__self__)
    // var ctx = global.fetch ? global : __self__;

    var ctx = __self__; // this line disable service worker support temporarily

    exports = ctx.fetch; // To enable: import fetch from 'cross-fetch'

    exports.default = ctx.fetch; // For TypeScript consumers without esModuleInterop.

    exports.fetch = ctx.fetch; // To enable: import {fetch} from 'cross-fetch'

    exports.Headers = ctx.Headers;
    exports.Request = ctx.Request;
    exports.Response = ctx.Response;
    module.exports = exports;
  })(browserPonyfill, browserPonyfill.exports);

  var fetch = /*@__PURE__*/getDefaultExportFromCjs(browserPonyfill.exports);

  /* eslint-env browser */
  var browser = typeof self == 'object' ? self.FormData : window.FormData;

  let xAtomicNumber = 0;
  /**
   * Tag an atom to be able to visualize it
   * @param {OCL.Molecule} molecule
   * @param {number} iAtom
   */

  function tagAtom(molecule, iAtom) {
    let customLabel = `${molecule.getAtomLabel(iAtom)}*`;
    molecule.setAtomCustomLabel(iAtom, customLabel);

    if (molecule.getAtomicNo(iAtom) === 1) {
      molecule.setAtomicNo(iAtom, getXAtomicNumber(molecule));
    } else {
      // we can not use X because we would have problems with valencies if it is
      // expanded hydrogens or not
      // we can not only use a custom label because it does not count for the canonisation
      molecule.setAtomMass(iAtom, molecule.getAtomMass(iAtom) + 5);
    }

    return customLabel;
  }

  function getXAtomicNumber(molecule) {
    if (!xAtomicNumber) {
      const OCL = molecule.getOCL();
      xAtomicNumber = OCL.Molecule.getAtomicNoFromLabel('X');
    }

    return xAtomicNumber;
  }

  /**
   * Add either missing chirality of diastereotopic missing chirality
   * The problem is that sometimes we need to add chiral bond that was not planned because it is the same group
   * This is the case for example for the valine where the 2 C of the methyl groups are diastereotopic
   * @param {OCL.Molecule} molecule
   * @param {object} [options={}]
   * @param {number} [options.esrType=cESRTypeAnd]
   */

  function addDiastereotopicMissingChirality(molecule, options = {}) {
    const {
      Molecule
    } = molecule.getOCL();
    const {
      esrType = Molecule.cESRTypeAnd
    } = options;

    for (let iAtom = 0; iAtom < molecule.getAllAtoms(); iAtom++) {
      let tempMolecule = molecule.getCompactCopy();
      tagAtom(tempMolecule, iAtom); // After copy, helpers must be recalculated

      tempMolecule.ensureHelperArrays(Molecule.cHelperBitsStereo); // We need to have >0 and not >1 because there could be unspecified chirality in racemate

      for (let i = 0; i < tempMolecule.getAtoms(); i++) {
        // changed from from handling below; TLS 9.Nov.2015
        if (tempMolecule.isAtomStereoCenter(i) && tempMolecule.getStereoBond(i) === -1) {
          let stereoBond = tempMolecule.getAtomPreferredStereoBond(i);

          if (stereoBond !== -1) {
            molecule.setBondType(stereoBond, Molecule.cBondTypeUp);

            if (molecule.getBondAtom(1, stereoBond) === i) {
              let connAtom = molecule.getBondAtom(0, stereoBond);
              molecule.setBondAtom(0, stereoBond, i);
              molecule.setBondAtom(1, stereoBond, connAtom);
            } // To me it seems that we have to add all stereo centers into AND group 0. TLS 9.Nov.2015


            molecule.setAtomESR(i, esrType, 0);
          }
        }
      }
    }
  }

  /**
   *
   * @param {OCL.Molecule} [molecule] An instance of a molecule
   * @param {object} [options={}]
   * @param {object} [options.OCL] openchemlib library
   */
  function makeRacemic(molecule) {
    const {
      Molecule
    } = molecule.getOCL(); // if we don't calculate this we have 2 epimers

    molecule.ensureHelperArrays(Molecule.cHelperCIP); // we need to make one group "AND" for chiral (to force to racemic, this means diastereotopic and not enantiotopic)

    for (let i = 0; i < molecule.getAllAtoms(); i++) {
      if (molecule.getAtomParity(i) !== Molecule.cAtomParityNone) {
        molecule.setAtomESR(i, Molecule.cESRTypeAnd, 0); // changed to group 0; TLS 9.Nov.2015
      }
    }
  }

  /**
   * Returns an array of diastereotopic ID (as oclCode)
   * @param {OCL.Molecule} molecule
   */

  function getDiastereotopicAtomIDs(molecule) {
    const OCL = molecule.getOCL();
    addDiastereotopicMissingChirality(molecule);
    let numberAtoms = molecule.getAllAtoms();
    let ids = [];

    for (let iAtom = 0; iAtom < numberAtoms; iAtom++) {
      let tempMolecule = molecule.getCompactCopy();
      tagAtom(tempMolecule, iAtom);
      makeRacemic(tempMolecule); // We need to ensure the helper array in order to get correctly the result of racemisation

      ids[iAtom] = tempMolecule.getCanonizedIDCode(OCL.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS);
    }

    return ids;
  }

  /**
   * This function groups the diasterotopic atomIds of the molecule based on equivalence of atoms. The output object contains
   * a set of chemically equivalent atoms(element.atoms) and the groups of magnetically equivalent atoms (element.magneticGroups)
   * @param {OCL.Molecule} molecule
   * @param {object} [options={}]
   * @param {string} [options.atomLabel] Select atoms of the given atomLabel. By default it returns all the explicit atoms in the molecule
   * @returns {Array}
   */

  function getGroupedDiastereotopicAtomIDs(molecule, options = {}) {
    const {
      atomLabel
    } = options;
    let diaIDs = getDiastereotopicAtomIDs(molecule);
    let diaIDsObject = {};

    for (let i = 0; i < diaIDs.length; i++) {
      if (!atomLabel || molecule.getAtomLabel(i) === atomLabel) {
        let diaID = diaIDs[i];

        if (!diaIDsObject[diaID]) {
          diaIDsObject[diaID] = {
            counter: 0,
            atoms: [],
            oclID: diaID,
            atomLabel: molecule.getAtomLabel(i)
          };
        }

        diaIDsObject[diaID].counter++;
        diaIDsObject[diaID].atoms.push(i);
      }
    }

    return Object.keys(diaIDsObject).map(key => diaIDsObject[key]);
  }

  /**
   * Check if a specific atom is a sp3 carbon
   * @param {OCL.Molecule} molecule
   * @param {number} atomID
   */
  function isCsp3(molecule, atomID) {
    if (molecule.getAtomicNo(atomID) !== 6) return false;
    if (molecule.getAtomCharge(atomID) !== 0) return false;

    if (molecule.getImplicitHydrogens(atomID) + molecule.getConnAtoms(atomID) !== 4) {
      return false;
    }

    return true;
  }

  const FULL_HOSE_CODE = 1;
  const HOSE_CODE_CUT_C_SP3_SP3 = 2;
  /**
   * Returns the hose code for a specific atom number
   * @param {OCL.Molecule} originalMolecule
   * @param {number} rootAtom
   * @param {object} [options={}]
   * @param {boolean} [options.isTagged] Specify is the atom is already tagged
   */

  function getHoseCodesForAtom(originalMolecule, rootAtom, options = {}) {
    const OCL = originalMolecule.getOCL();
    const {
      minSphereSize = 0,
      maxSphereSize = 4,
      kind = FULL_HOSE_CODE,
      isTagged = false
    } = options;
    const molecule = originalMolecule.getCompactCopy();

    if (!isTagged) {
      let tag = tagAtom(molecule, rootAtom);
      molecule.addImplicitHydrogens();
      molecule.addMissingChirality();
      molecule.ensureHelperArrays(OCL.Molecule.cHelperNeighbours); // because ensuring helper reorder atoms we need to look again for it

      for (let i = 0; i < molecule.getAllAtoms(); i++) {
        if (tag === molecule.getAtomCustomLabel(i)) {
          rootAtom = i;
          break;
        }
      }
    }

    let fragment = new OCL.Molecule(0, 0);
    let results = [];
    let min = 0;
    let max = 0;
    let atomMask = new Array(molecule.getAllAtoms());
    let atomList = new Array(molecule.getAllAtoms());

    for (let sphere = 0; sphere <= maxSphereSize; sphere++) {
      if (max === 0) {
        atomList[0] = rootAtom;
        atomMask[rootAtom] = true;
        max = 1;
      } else {
        let newMax = max;

        for (let i = min; i < max; i++) {
          let atom = atomList[i];

          for (let j = 0; j < molecule.getAllConnAtoms(atom); j++) {
            let connAtom = molecule.getConnAtom(atom, j);

            if (!atomMask[connAtom]) {
              switch (kind) {
                case FULL_HOSE_CODE:
                  atomMask[connAtom] = true;
                  atomList[newMax++] = connAtom;
                  break;

                case HOSE_CODE_CUT_C_SP3_SP3:
                  if (!(isCsp3(molecule, atom) && isCsp3(molecule, connAtom))) {
                    atomMask[connAtom] = true;
                    atomList[newMax++] = connAtom;
                  }

                  break;

                default:
                  throw new Error('getHoseCoesForAtom unknown kind');
              }
            }
          }
        }

        min = max;
        max = newMax;
      }

      molecule.copyMoleculeByAtoms(fragment, atomMask, true, null);

      if (sphere >= minSphereSize) {
        makeRacemic(fragment);
        results.push(fragment.getCanonizedIDCode(OCL.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS));
      }
    }

    return results;
  }

  /**
   * Returns the hose code for a specific marked atom
   * @param {OCL.Molecule} diastereotopicID
   * @param {object} options
   */

  function getHoseCodesFromDiastereotopicID(molecule, options = {}) {
    molecule.addImplicitHydrogens();
    molecule.addMissingChirality(); // One of the atom has to be marked !

    let atomID = -1;

    for (let i = 0; i < molecule.getAllAtoms(); i++) {
      // we need to find the marked atom
      const atomCustomLabel = molecule.getAtomCustomLabel(i);

      if (atomCustomLabel != null && atomCustomLabel.endsWith('*')) {
        atomID = i;
        break;
      }
    }

    if (atomID >= 0) {
      options.isTagged = true;
      return getHoseCodesForAtom(molecule, atomID, options);
    }

    return undefined;
  }

  /**
   * Algorithm that finds the shortest distance from one node to the other
   * @param {Matrix} adjMatrix - A squared adjacency matrix
   * @return {Matrix} - Distance from a node to the other, -1 if the node is unreachable
   */

  function floydWarshall(adjMatrix) {
    if (Matrix.isMatrix(adjMatrix) && adjMatrix.columns !== adjMatrix.rows) {
      throw new TypeError('The adjacency matrix should be squared');
    }

    const numVertices = adjMatrix.columns;
    let distMatrix = new Matrix(numVertices, numVertices);
    distMatrix.apply((row, column) => {
      // principal diagonal is 0
      if (row === column) {
        distMatrix.set(row, column, 0);
      } else {
        let val = adjMatrix.get(row, column);

        if (val) {
          // edges values remain the same
          distMatrix.set(row, column, val);
        } else {
          // 0 values become infinity
          distMatrix.set(row, column, Number.POSITIVE_INFINITY);
        }
      }
    });

    for (let k = 0; k < numVertices; ++k) {
      for (let i = 0; i < numVertices; ++i) {
        for (let j = 0; j < numVertices; ++j) {
          let dist = distMatrix.get(i, k) + distMatrix.get(k, j);

          if (distMatrix.get(i, j) > dist) {
            distMatrix.set(i, j, dist);
          }
        }
      }
    } // When there's no connection the value is -1


    distMatrix.apply((row, column) => {
      if (distMatrix.get(row, column) === Number.POSITIVE_INFINITY) {
        distMatrix.set(row, column, -1);
      }
    });
    return distMatrix;
  }

  /**
   * Returns a connectivity matrix
   * @param {OCL.Molecule} molecule
   * @param {object} [options={}]
   * @param {boolean} [options.pathLength=false] get the path length between atoms
   * @param {boolean} [options.mass=false] set the nominal mass of the atoms on diagonal
   * @param {boolean} [options.atomicNo=false] set the atomic number of the atom on diagonal
   * @param {boolean} [options.negativeAtomicNo=false] set the atomic number * -1 of the atom on diagonal
   * @param {boolean} [options.sdt=false] set 1, 2 or 3 depending if single, double or triple bond
   * @param {boolean} [options.sdta=false] set 1, 2, 3 or 4 depending if single, double, triple or aromatic  bond
   */

  function getConnectivityMatrix(molecule, options = {}) {
    const OCL = molecule.getOCL();
    molecule.ensureHelperArrays(OCL.Molecule.cHelperNeighbours);
    let nbAtoms = molecule.getAllAtoms();
    let result = new Array(nbAtoms).fill();
    result = result.map(() => new Array(nbAtoms).fill(0));

    if (!options.pathLength) {
      if (options.atomicNo) {
        for (let i = 0; i < nbAtoms; i++) {
          result[i][i] = molecule.getAtomicNo(i);
        }
      } else if (options.negativeAtomicNo) {
        for (let i = 0; i < nbAtoms; i++) {
          result[i][i] = -molecule.getAtomicNo(i);
        }
      } else if (options.mass) {
        for (let i = 0; i < nbAtoms; i++) {
          result[i][i] = OCL.Molecule.cRoundedMass[molecule.getAtomicNo(i)];
        }
      } else {
        for (let i = 0; i < nbAtoms; i++) {
          result[i][i] = 1;
        }
      }
    }

    if (options.sdt) {
      for (let i = 0; i < nbAtoms; i++) {
        let l = molecule.getAllConnAtoms(i);

        for (let j = 0; j < l; j++) {
          result[i][molecule.getConnAtom(i, j)] = molecule.getConnBondOrder(i, j);
        }
      }
    } else if (options.sdta) {
      for (let i = 0; i < nbAtoms; i++) {
        let l = molecule.getAllConnAtoms(i);

        for (let j = 0; j < l; j++) {
          let bondNumber = molecule.getConnBond(i, j);

          if (molecule.isAromaticBond(bondNumber)) {
            result[i][molecule.getConnAtom(i, j)] = 4;
          } else {
            result[i][molecule.getConnAtom(i, j)] = molecule.getConnBondOrder(i, j);
          }
        }
      }
    } else {
      for (let i = 0; i < nbAtoms; i++) {
        let l = molecule.getAllConnAtoms(i);

        for (let j = 0; j < l; j++) {
          result[i][molecule.getConnAtom(i, j)] = 1;
        }
      }
    }

    if (options.pathLength) {
      result = floydWarshall(new Matrix(result)).to2DArray();
    }

    return result;
  }

  /**
   * Join signals if all the same diaID
   * diaID must be present at the level of the signal and the coupling so practically it only applies on simulated data
   */

  function signalsJoin(signals, options = {}) {
    const {
      tolerance = 0.1
    } = options; // diaIDs is mandatory everywhere

    for (let signal of signals) {
      if (!signal.diaID || !signal.diaID.length === 1) return signals;

      for (let coupling of signal.j) {
        if (!coupling.diaID || !coupling.diaID.length === 1 || coupling.multiplicity !== 'd') {
          return signals;
        }
      }
    } // we group them by diaIDs


    const groupedSignals = {};

    for (let signal of signals) {
      signal = signalNormalize(signal); // we have a copy

      signal.j = signal.j.sort((a, b) => a.diaID + a.distance < b.diaID + b.distance ? 1 : -1);
      let id = `${signal.diaID[0]} ${signal.j.map(j => `${j.diaID[0]} ${j.distance}`).sort().join(' ')}`;

      if (!groupedSignals[id]) {
        groupedSignals[id] = [];
      }

      groupedSignals[id].push(signal);
    } // for each group we need to combine assignments and average couplings


    let newSignals = [];

    for (let key in groupedSignals) {
      const group = groupedSignals[key]; // joining couplings only if diaID and distance are equal

      const j = [];

      for (let i = 0; i < group[0].j.length; i++) {
        j.push({
          diaID: group[0].j[i].diaID,
          distance: group[0].j[i].distance,
          multiplicity: group[0].j[i].multiplicity,
          coupling: mean(group.map(item => item.j[i].coupling))
        });
      }

      newSignals.push({
        nbAtoms: sum(group.map(item => item.nbAtoms)),
        delta: mean(group.map(item => item.delta)),
        diaID: group[0].diaID,
        assignment: group.map(item => item.assignment).flat().filter(item => item),
        j
      });
    }

    newSignals = newSignals.map(signal => {
      signal = signalNormalize(signalJoinCouplings(signal, {
        tolerance
      }));

      if (signal.j) {
        signal.multiplicity = signal.j.reduce((multiplicity, jCoupling) => {
          return `${multiplicity}${jCoupling.multiplicity}`;
        }, '');
      }

      return signal;
    }).sort((a, b) => a.delta - b.delta);
    return newSignals;
  }

  /**
   * Makes a prediction using proton.
   * @param {Molecule} molecule - OCL Molecule instance.
   * @param {object} [options={}]
   * @param {function} [options.cache] A callback receiving a molfile and the result
   * @return {Promise<Array>}
   */

  async function predictProton(molecule, options = {}) {
    const {
      cache
    } = options;
    molecule = molecule.getCompactCopy();
    molecule.addImplicitHydrogens();
    addDiastereotopicMissingChirality(molecule);
    const molfile = molecule.toMolfile();
    let result;

    if (cache) {
      result = cache(molfile);
    }

    if (result === undefined) {
      const formData = new browser();
      formData.append('molfile', molfile);
      const response = await fetch('https://www.nmrdb.org/service/predictor', {
        method: 'POST',
        body: formData
      });
      result = await response.text();

      if (cache) {
        cache(molfile, result);
      }
    }

    const diaIDs = getDiastereotopicAtomIDs(molecule);
    const signals = protonParser(result, molecule, diaIDs);
    const joinedSignals = signalsJoin(signals);
    return {
      molfile,
      diaIDs,
      joinedSignals,
      signals,
      ranges: signalsToRanges(joinedSignals)
    };
  }

  function protonParser(result, molecule, diaIDs) {
    let distanceMatrix = getConnectivityMatrix(molecule, {
      pathLength: true
    });
    let lines = result.split('\n').filter(line => line);
    let signals = [];

    for (let line of lines) {
      let fields = line.split('\t');
      let couplings = fields.slice(4);
      let atom = fields[0] - 1;
      let signal = {
        assignment: [atom],
        diaID: [diaIDs[atom]],
        nbAtoms: 1,
        delta: Number(fields[2]),
        j: []
      };

      for (let i = 0; i < couplings.length; i += 3) {
        let linked = Number(couplings[i] - 1);
        signal.j.push({
          coupling: Number(couplings[i + 2]),
          assignment: [linked],
          diaID: [diaIDs[linked]],
          multiplicity: 'd',
          distance: distanceMatrix[atom][linked]
        });
        signal.j.sort((a, b) => b.coupling - a.coupling);
      }

      signals.push(signal);
    }

    return signals;
  }

  function createInputJSON(molecule, options) {
    const {
      levels
    } = options;
    const OCL = molecule.getOCL();
    let diaIDs = getGroupedDiastereotopicAtomIDs(molecule);
    diaIDs = diaIDs.filter(e => e.atomLabel === 'C').sort(function (a, b) {
      if (a.atomLabel === b.atomLabel) {
        return b.counter - a.counter;
      }

      return a.atomLabel < b.atomLabel ? 1 : -1;
    });
    const atoms = {};

    for (const diaId of diaIDs) {
      diaId.hose = getHoseCodesFromDiastereotopicID(OCL.Molecule.fromIDCode(diaId.oclID), {
        maxSphereSize: levels[0]
      });

      for (const atomID of diaId.atoms) {
        atoms[atomID] = diaId.oclID;
      }
    }

    let toReturn = {
      id: molecule.getIDCode(),
      atom: atoms,
      diaIDs
    };
    return toReturn;
  }

  function queryByHose(input, db, options) {
    const {
      levels
    } = options;
    levels.sort((a, b) => b - a);
    const toReturn = [];

    for (const element of input.diaIDs) {
      let res;
      let k = 0;

      while (!res && k < levels.length) {
        if (db[levels[k]]) {
          res = db[levels[k]][element.hose[levels[k]]];
        }

        k++;
      }

      if (!res) {
        res = [null];
        k = 0;
      }

      for (const atomNumber of element.atoms) {
        let atom = {
          diaIDs: [element.oclID]
        };
        atom.delta = res[0];
        atom.atomIDs = [atomNumber];
        atom.nbAtoms = 1;
        toReturn.push(atom);
      }
    }

    return toReturn;
  }

  const cache = {};

  async function loadDB(url = 'https://www.lactame.com/lib/nmr-processing/data/20210711/carbon.js') {
    if (cache[url]) {
      return cache[url];
    }

    const response = await fetch(url);
    cache[url] = await response.json();
    return cache[url];
  }

  async function predictCarbon(molecule, options = {}) {
    let {
      levels = [3, 2, 1, 0],
      url,
      database
    } = options;
    database = database || (await loadDB(url));
    molecule.addImplicitHydrogens();
    molecule.addMissingChirality();
    addDiastereotopicMissingChirality(molecule);
    const molfile = molecule.toMolfile();
    const inputJSON = createInputJSON(molecule, {
      levels
    });
    let predictions = queryByHose(inputJSON, database, {
      levels
    });
    const signals = formatSignals(predictions);
    const joinedSignals = joinSignalByDiaID(signals);
    return {
      molfile,
      diaIDs: inputJSON.diaIDs.map(e => e.diaId),
      joinedSignals,
      signals,
      ranges: signalsToRanges(joinedSignals)
    };
  }

  function formatSignals(predictions) {
    let signals = [];

    for (const prediction of predictions) {
      const {
        atomIDs,
        nbAtoms,
        delta,
        diaIDs
      } = prediction;
      signals.push({
        delta,
        assignment: atomIDs,
        diaID: diaIDs,
        nbAtoms,
        j: []
      });
    }

    return signals;
  }

  function joinSignalByDiaID(signals) {
    let joinedSignals = {};

    for (let signal of signals) {
      let diaID = signal.diaID[0];

      if (!joinedSignals[diaID]) {
        joinedSignals[diaID] = JSON.parse(JSON.stringify(signal));
      } else {
        joinedSignals[diaID].nbAtoms += signal.nbAtoms;
        joinedSignals[diaID].assignment.push(...signal.assignment);
      }
    }

    return Object.values(joinedSignals);
  }

  var src = {};

  var fftlib = {};

  /**
   * Fast Fourier Transform module
   * 1D-FFT/IFFT, 2D-FFT/IFFT (radix-2)
   */

  (function (exports) {
    (function () {
      var FFT;

      {
        FFT = exports; // for CommonJS
      }

      var version = {
        release: '0.3.0',
        date: '2013-03'
      };

      FFT.toString = function () {
        return "version " + version.release + ", released " + version.date;
      }; // core operations


      var _n = 0,
          // order
      _bitrev = null,
          // bit reversal table
      _cstb = null; // sin/cos table

      var core = {
        init: function (n) {
          if (n !== 0 && (n & n - 1) === 0) {
            _n = n;

            core._initArray();

            core._makeBitReversalTable();

            core._makeCosSinTable();
          } else {
            throw new Error("init: radix-2 required");
          }
        },
        // 1D-FFT
        fft1d: function (re, im) {
          core.fft(re, im, 1);
        },
        // 1D-IFFT
        ifft1d: function (re, im) {
          var n = 1 / _n;
          core.fft(re, im, -1);

          for (var i = 0; i < _n; i++) {
            re[i] *= n;
            im[i] *= n;
          }
        },
        // 1D-IFFT
        bt1d: function (re, im) {
          core.fft(re, im, -1);
        },
        // 2D-FFT Not very useful if the number of rows have to be equal to cols
        fft2d: function (re, im) {
          var tre = [],
              tim = [],
              i = 0; // x-axis

          for (var y = 0; y < _n; y++) {
            i = y * _n;

            for (var x1 = 0; x1 < _n; x1++) {
              tre[x1] = re[x1 + i];
              tim[x1] = im[x1 + i];
            }

            core.fft1d(tre, tim);

            for (var x2 = 0; x2 < _n; x2++) {
              re[x2 + i] = tre[x2];
              im[x2 + i] = tim[x2];
            }
          } // y-axis


          for (var x = 0; x < _n; x++) {
            for (var y1 = 0; y1 < _n; y1++) {
              i = x + y1 * _n;
              tre[y1] = re[i];
              tim[y1] = im[i];
            }

            core.fft1d(tre, tim);

            for (var y2 = 0; y2 < _n; y2++) {
              i = x + y2 * _n;
              re[i] = tre[y2];
              im[i] = tim[y2];
            }
          }
        },
        // 2D-IFFT
        ifft2d: function (re, im) {
          var tre = [],
              tim = [],
              i = 0; // x-axis

          for (var y = 0; y < _n; y++) {
            i = y * _n;

            for (var x1 = 0; x1 < _n; x1++) {
              tre[x1] = re[x1 + i];
              tim[x1] = im[x1 + i];
            }

            core.ifft1d(tre, tim);

            for (var x2 = 0; x2 < _n; x2++) {
              re[x2 + i] = tre[x2];
              im[x2 + i] = tim[x2];
            }
          } // y-axis


          for (var x = 0; x < _n; x++) {
            for (var y1 = 0; y1 < _n; y1++) {
              i = x + y1 * _n;
              tre[y1] = re[i];
              tim[y1] = im[i];
            }

            core.ifft1d(tre, tim);

            for (var y2 = 0; y2 < _n; y2++) {
              i = x + y2 * _n;
              re[i] = tre[y2];
              im[i] = tim[y2];
            }
          }
        },
        // core operation of FFT
        fft: function (re, im, inv) {
          var d,
              h,
              ik,
              m,
              tmp,
              wr,
              wi,
              xr,
              xi,
              n4 = _n >> 2; // bit reversal

          for (var l = 0; l < _n; l++) {
            m = _bitrev[l];

            if (l < m) {
              tmp = re[l];
              re[l] = re[m];
              re[m] = tmp;
              tmp = im[l];
              im[l] = im[m];
              im[m] = tmp;
            }
          } // butterfly operation


          for (var k = 1; k < _n; k <<= 1) {
            h = 0;
            d = _n / (k << 1);

            for (var j = 0; j < k; j++) {
              wr = _cstb[h + n4];
              wi = inv * _cstb[h];

              for (var i = j; i < _n; i += k << 1) {
                ik = i + k;
                xr = wr * re[ik] + wi * im[ik];
                xi = wr * im[ik] - wi * re[ik];
                re[ik] = re[i] - xr;
                re[i] += xr;
                im[ik] = im[i] - xi;
                im[i] += xi;
              }

              h += d;
            }
          }
        },
        // initialize the array (supports TypedArray)
        _initArray: function () {
          if (typeof Uint32Array !== 'undefined') {
            _bitrev = new Uint32Array(_n);
          } else {
            _bitrev = [];
          }

          if (typeof Float64Array !== 'undefined') {
            _cstb = new Float64Array(_n * 1.25);
          } else {
            _cstb = [];
          }
        },
        // zero padding
        _paddingZero: function () {// TODO
        },
        // makes bit reversal table
        _makeBitReversalTable: function () {
          var i = 0,
              j = 0,
              k = 0;
          _bitrev[0] = 0;

          while (++i < _n) {
            k = _n >> 1;

            while (k <= j) {
              j -= k;
              k >>= 1;
            }

            j += k;
            _bitrev[i] = j;
          }
        },
        // makes trigonometiric function table
        _makeCosSinTable: function () {
          var n2 = _n >> 1,
              n4 = _n >> 2,
              n8 = _n >> 3,
              n2p4 = n2 + n4,
              t = Math.sin(Math.PI / _n),
              dc = 2 * t * t,
              ds = Math.sqrt(dc * (2 - dc)),
              c = _cstb[n4] = 1,
              s = _cstb[0] = 0;
          t = 2 * dc;

          for (var i = 1; i < n8; i++) {
            c -= dc;
            dc += t * c;
            s += ds;
            ds -= t * s;
            _cstb[i] = s;
            _cstb[n4 - i] = c;
          }

          if (n8 !== 0) {
            _cstb[n8] = Math.sqrt(0.5);
          }

          for (var j = 0; j < n4; j++) {
            _cstb[n2 - j] = _cstb[j];
          }

          for (var k = 0; k < n2p4; k++) {
            _cstb[k + n2] = -_cstb[k];
          }
        }
      }; // aliases (public APIs)

      var apis = ['init', 'fft1d', 'ifft1d', 'fft2d', 'ifft2d'];

      for (var i = 0; i < apis.length; i++) {
        FFT[apis[i]] = core[apis[i]];
      }

      FFT.bt = core.bt1d;
      FFT.fft = core.fft1d;
      FFT.ifft = core.ifft1d;
      return FFT;
    }).call(commonjsGlobal);
  })(fftlib);

  var FFT = fftlib;
  var FFTUtils$1 = {
    DEBUG: false,

    /**
     * Calculates the inverse of a 2D Fourier transform
     *
     * @param ft
     * @param ftRows
     * @param ftCols
     * @return
     */
    ifft2DArray: function (ft, ftRows, ftCols) {
      var tempTransform = new Array(ftRows * ftCols);
      var nRows = ftRows / 2;
      var nCols = (ftCols - 1) * 2; // reverse transform columns

      FFT.init(nRows);
      var tmpCols = {
        re: new Array(nRows),
        im: new Array(nRows)
      };

      for (var iCol = 0; iCol < ftCols; iCol++) {
        for (var iRow = nRows - 1; iRow >= 0; iRow--) {
          tmpCols.re[iRow] = ft[iRow * 2 * ftCols + iCol];
          tmpCols.im[iRow] = ft[(iRow * 2 + 1) * ftCols + iCol];
        } //Unnormalized inverse transform


        FFT.bt(tmpCols.re, tmpCols.im);

        for (var iRow = nRows - 1; iRow >= 0; iRow--) {
          tempTransform[iRow * 2 * ftCols + iCol] = tmpCols.re[iRow];
          tempTransform[(iRow * 2 + 1) * ftCols + iCol] = tmpCols.im[iRow];
        }
      } // reverse row transform


      var finalTransform = new Array(nRows * nCols);
      FFT.init(nCols);
      var tmpRows = {
        re: new Array(nCols),
        im: new Array(nCols)
      };
      var scale = nCols * nRows;

      for (var iRow = 0; iRow < ftRows; iRow += 2) {
        tmpRows.re[0] = tempTransform[iRow * ftCols];
        tmpRows.im[0] = tempTransform[(iRow + 1) * ftCols];

        for (var iCol = 1; iCol < ftCols; iCol++) {
          tmpRows.re[iCol] = tempTransform[iRow * ftCols + iCol];
          tmpRows.im[iCol] = tempTransform[(iRow + 1) * ftCols + iCol];
          tmpRows.re[nCols - iCol] = tempTransform[iRow * ftCols + iCol];
          tmpRows.im[nCols - iCol] = -tempTransform[(iRow + 1) * ftCols + iCol];
        } //Unnormalized inverse transform


        FFT.bt(tmpRows.re, tmpRows.im);
        var indexB = iRow / 2 * nCols;

        for (var iCol = nCols - 1; iCol >= 0; iCol--) {
          finalTransform[indexB + iCol] = tmpRows.re[iCol] / scale;
        }
      }

      return finalTransform;
    },

    /**
     * Calculates the fourier transform of a matrix of size (nRows,nCols) It is
     * assumed that both nRows and nCols are a power of two
     *
     * On exit the matrix has dimensions (nRows * 2, nCols / 2 + 1) where the
     * even rows contain the real part and the odd rows the imaginary part of the
     * transform
     * @param data
     * @param nRows
     * @param nCols
     * @return
     */
    fft2DArray: function (data, nRows, nCols, opt) {
      Object.assign({}, {
        inplace: true
      });
      var ftCols = nCols / 2 + 1;
      var ftRows = nRows * 2;
      var tempTransform = new Array(ftRows * ftCols);
      FFT.init(nCols); // transform rows

      var tmpRows = {
        re: new Array(nCols),
        im: new Array(nCols)
      };
      var row1 = {
        re: new Array(nCols),
        im: new Array(nCols)
      };
      var row2 = {
        re: new Array(nCols),
        im: new Array(nCols)
      };
      var index, iRow0, iRow1, iRow2, iRow3;

      for (var iRow = 0; iRow < nRows / 2; iRow++) {
        index = iRow * 2 * nCols;
        tmpRows.re = data.slice(index, index + nCols);
        index = (iRow * 2 + 1) * nCols;
        tmpRows.im = data.slice(index, index + nCols);
        FFT.fft1d(tmpRows.re, tmpRows.im);
        this.reconstructTwoRealFFT(tmpRows, row1, row2); //Now lets put back the result into the output array

        iRow0 = iRow * 4 * ftCols;
        iRow1 = (iRow * 4 + 1) * ftCols;
        iRow2 = (iRow * 4 + 2) * ftCols;
        iRow3 = (iRow * 4 + 3) * ftCols;

        for (var k = ftCols - 1; k >= 0; k--) {
          tempTransform[iRow0 + k] = row1.re[k];
          tempTransform[iRow1 + k] = row1.im[k];
          tempTransform[iRow2 + k] = row2.re[k];
          tempTransform[iRow3 + k] = row2.im[k];
        }
      } //console.log(tempTransform);


      row1 = null;
      row2 = null; // transform columns

      var finalTransform = new Array(ftRows * ftCols);
      FFT.init(nRows);
      var tmpCols = {
        re: new Array(nRows),
        im: new Array(nRows)
      };

      for (var iCol = ftCols - 1; iCol >= 0; iCol--) {
        for (var iRow = nRows - 1; iRow >= 0; iRow--) {
          tmpCols.re[iRow] = tempTransform[iRow * 2 * ftCols + iCol];
          tmpCols.im[iRow] = tempTransform[(iRow * 2 + 1) * ftCols + iCol]; //TODO Chech why this happens

          if (isNaN(tmpCols.re[iRow])) {
            tmpCols.re[iRow] = 0;
          }

          if (isNaN(tmpCols.im[iRow])) {
            tmpCols.im[iRow] = 0;
          }
        }

        FFT.fft1d(tmpCols.re, tmpCols.im);

        for (var iRow = nRows - 1; iRow >= 0; iRow--) {
          finalTransform[iRow * 2 * ftCols + iCol] = tmpCols.re[iRow];
          finalTransform[(iRow * 2 + 1) * ftCols + iCol] = tmpCols.im[iRow];
        }
      } //console.log(finalTransform);


      return finalTransform;
    },

    /**
     *
     * @param fourierTransform
     * @param realTransform1
     * @param realTransform2
     *
     * Reconstructs the individual Fourier transforms of two simultaneously
     * transformed series. Based on the Symmetry relationships (the asterisk
     * denotes the complex conjugate)
     *
     * F_{N-n} = F_n^{*} for a purely real f transformed to F
     *
     * G_{N-n} = G_n^{*} for a purely imaginary g transformed to G
     *
     */
    reconstructTwoRealFFT: function (fourierTransform, realTransform1, realTransform2) {
      var length = fourierTransform.re.length; // the components n=0 are trivial

      realTransform1.re[0] = fourierTransform.re[0];
      realTransform1.im[0] = 0.0;
      realTransform2.re[0] = fourierTransform.im[0];
      realTransform2.im[0] = 0.0;
      var rm, rp, im, ip, j;

      for (var i = length / 2; i > 0; i--) {
        j = length - i;
        rm = 0.5 * (fourierTransform.re[i] - fourierTransform.re[j]);
        rp = 0.5 * (fourierTransform.re[i] + fourierTransform.re[j]);
        im = 0.5 * (fourierTransform.im[i] - fourierTransform.im[j]);
        ip = 0.5 * (fourierTransform.im[i] + fourierTransform.im[j]);
        realTransform1.re[i] = rp;
        realTransform1.im[i] = im;
        realTransform1.re[j] = rp;
        realTransform1.im[j] = -im;
        realTransform2.re[i] = ip;
        realTransform2.im[i] = -rm;
        realTransform2.re[j] = ip;
        realTransform2.im[j] = rm;
      }
    },

    /**
     * In place version of convolute 2D
     *
     * @param ftSignal
     * @param ftFilter
     * @param ftRows
     * @param ftCols
     * @return
     */
    convolute2DI: function (ftSignal, ftFilter, ftRows, ftCols) {
      var re, im;

      for (var iRow = 0; iRow < ftRows / 2; iRow++) {
        for (var iCol = 0; iCol < ftCols; iCol++) {
          //
          re = ftSignal[iRow * 2 * ftCols + iCol] * ftFilter[iRow * 2 * ftCols + iCol] - ftSignal[(iRow * 2 + 1) * ftCols + iCol] * ftFilter[(iRow * 2 + 1) * ftCols + iCol];
          im = ftSignal[iRow * 2 * ftCols + iCol] * ftFilter[(iRow * 2 + 1) * ftCols + iCol] + ftSignal[(iRow * 2 + 1) * ftCols + iCol] * ftFilter[iRow * 2 * ftCols + iCol]; //

          ftSignal[iRow * 2 * ftCols + iCol] = re;
          ftSignal[(iRow * 2 + 1) * ftCols + iCol] = im;
        }
      }
    },

    /**
     *
     * @param data
     * @param kernel
     * @param nRows
     * @param nCols
     * @returns {*}
     */
    convolute: function (data, kernel, nRows, nCols, opt) {
      var ftSpectrum = new Array(nCols * nRows);

      for (var i = 0; i < nRows * nCols; i++) {
        ftSpectrum[i] = data[i];
      }

      ftSpectrum = this.fft2DArray(ftSpectrum, nRows, nCols);
      var dimR = kernel.length;
      var dimC = kernel[0].length;
      var ftFilterData = new Array(nCols * nRows);

      for (var i = 0; i < nCols * nRows; i++) {
        ftFilterData[i] = 0;
      }

      var iRow, iCol;
      var shiftR = Math.floor((dimR - 1) / 2);
      var shiftC = Math.floor((dimC - 1) / 2);

      for (var ir = 0; ir < dimR; ir++) {
        iRow = (ir - shiftR + nRows) % nRows;

        for (var ic = 0; ic < dimC; ic++) {
          iCol = (ic - shiftC + nCols) % nCols;
          ftFilterData[iRow * nCols + iCol] = kernel[ir][ic];
        }
      }

      ftFilterData = this.fft2DArray(ftFilterData, nRows, nCols);
      var ftRows = nRows * 2;
      var ftCols = nCols / 2 + 1;
      this.convolute2DI(ftSpectrum, ftFilterData, ftRows, ftCols);
      return this.ifft2DArray(ftSpectrum, ftRows, ftCols);
    },
    toRadix2: function (data, nRows, nCols) {
      var i, j, irow, icol;
      var cols = nCols,
          rows = nRows;

      if (!(nCols !== 0 && (nCols & nCols - 1) === 0)) {
        //Then we have to make a pading to next radix2
        cols = 0;

        while (nCols >> ++cols != 0);

        cols = 1 << cols;
      }

      if (!(nRows !== 0 && (nRows & nRows - 1) === 0)) {
        //Then we have to make a pading to next radix2
        rows = 0;

        while (nRows >> ++rows != 0);

        rows = 1 << rows;
      }

      if (rows == nRows && cols == nCols) //Do nothing. Returns the same input!!! Be careful
        return {
          data: data,
          rows: nRows,
          cols: nCols
        };
      var output = new Array(rows * cols);
      var shiftR = Math.floor((rows - nRows) / 2) - nRows;
      var shiftC = Math.floor((cols - nCols) / 2) - nCols;

      for (i = 0; i < rows; i++) {
        irow = i * cols;
        icol = (i - shiftR) % nRows * nCols;

        for (j = 0; j < cols; j++) {
          output[irow + j] = data[icol + (j - shiftC) % nCols];
        }
      }

      return {
        data: output,
        rows: rows,
        cols: cols
      };
    },

    /**
     * Crop the given matrix to fit the corresponding number of rows and columns
     */
    crop: function (data, rows, cols, nRows, nCols, opt) {
      if (rows == nRows && cols == nCols) //Do nothing. Returns the same input!!! Be careful
        return data;
      Object.assign({}, opt);
      var output = new Array(nCols * nRows);
      var shiftR = Math.floor((rows - nRows) / 2);
      var shiftC = Math.floor((cols - nCols) / 2);
      var destinyRow, sourceRow, i, j;

      for (i = 0; i < nRows; i++) {
        destinyRow = i * nCols;
        sourceRow = (i + shiftR) * cols;

        for (j = 0; j < nCols; j++) {
          output[destinyRow + j] = data[sourceRow + (j + shiftC)];
        }
      }

      return output;
    }
  };
  var FFTUtils_1 = FFTUtils$1;

  var FFTUtils = src.FFTUtils = FFTUtils_1;
  src.FFT = fftlib;

  function matrix2Array(input) {
    let inputData = input;
    let nRows, nCols;

    if (typeof input[0] !== 'number') {
      nRows = input.length;
      nCols = input[0].length;
      inputData = new Array(nRows * nCols);

      for (let i = 0; i < nRows; i++) {
        for (let j = 0; j < nCols; j++) {
          inputData[i * nCols + j] = input[i][j];
        }
      }
    } else {
      let tmp = Math.sqrt(input.length);

      if (Number.isInteger(tmp)) {
        nRows = tmp;
        nCols = tmp;
      }
    }

    return {
      data: inputData,
      rows: nRows,
      cols: nCols
    };
  }

  function convolutionFFT(input, kernel, opt) {
    let tmp = matrix2Array(input);
    let inputData = tmp.data;
    let options = Object.assign({
      normalize: false,
      divisor: 1,
      rows: tmp.rows,
      cols: tmp.cols
    }, opt);
    let nRows, nCols;

    if (options.rows && options.cols) {
      nRows = options.rows;
      nCols = options.cols;
    } else {
      throw new Error(`Invalid number of rows or columns ${nRows} ${nCols}`);
    }

    let divisor = options.divisor;
    let kHeight = kernel.length;
    let kWidth = kernel[0].length;

    if (options.normalize) {
      divisor = 0;

      for (let i = 0; i < kHeight; i++) {
        for (let j = 0; j < kWidth; j++) divisor += kernel[i][j];
      }
    }

    if (divisor === 0) {
      throw new RangeError('convolution: The divisor is equal to zero');
    }

    let radix2Sized = FFTUtils.toRadix2(inputData, nRows, nCols);
    let conv = FFTUtils.convolute(radix2Sized.data, kernel, radix2Sized.rows, radix2Sized.cols);
    conv = FFTUtils.crop(conv, radix2Sized.rows, radix2Sized.cols, nRows, nCols);

    if (divisor !== 0 && divisor !== 1) {
      for (let i = 0; i < conv.length; i++) {
        conv[i] /= divisor;
      }
    }

    return conv;
  }

  function convolutionDirect(input, kernel, opt) {
    let tmp = matrix2Array(input);
    let inputData = tmp.data;
    let options = Object.assign({
      normalize: false,
      divisor: 1,
      rows: tmp.rows,
      cols: tmp.cols
    }, opt);
    let nRows, nCols;

    if (options.rows && options.cols) {
      nRows = options.rows;
      nCols = options.cols;
    } else {
      throw new Error(`Invalid number of rows or columns ${nRows} ${nCols}`);
    }

    let divisor = options.divisor;
    let kHeight = kernel.length;
    let kWidth = kernel[0].length;
    let index, sum, kVal, row, col;

    if (options.normalize) {
      divisor = 0;

      for (let i = 0; i < kHeight; i++) {
        for (let j = 0; j < kWidth; j++) divisor += kernel[i][j];
      }
    }

    if (divisor === 0) {
      throw new RangeError('convolution: The divisor is equal to zero');
    }

    let output = new Array(nRows * nCols);
    let hHeight = Math.floor(kHeight / 2);
    let hWidth = Math.floor(kWidth / 2);

    for (let y = 0; y < nRows; y++) {
      for (let x = 0; x < nCols; x++) {
        sum = 0;

        for (let j = 0; j < kHeight; j++) {
          for (let i = 0; i < kWidth; i++) {
            kVal = kernel[kHeight - j - 1][kWidth - i - 1];
            row = (y + j - hHeight + nRows) % nRows;
            col = (x + i - hWidth + nCols) % nCols;
            index = row * nCols + col;
            sum += inputData[index] * kVal;
          }
        }

        index = y * nCols + x;
        output[index] = sum / divisor;
      }
    }

    return output;
  }

  /**
   * @class DisjointSet
   */


  class DisjointSet {
    constructor() {
      this.nodes = new Map();
    }
    /**
     * Adds an element as a new set
     * @param {*} value
     * @return {DisjointSetNode} Object holding the element
     */


    add(value) {
      var node = this.nodes.get(value);

      if (!node) {
        node = new DisjointSetNode(value);
        this.nodes.set(value, node);
      }

      return node;
    }
    /**
     * Merges the sets that contain x and y
     * @param {DisjointSetNode} x
     * @param {DisjointSetNode} y
     */


    union(x, y) {
      const rootX = this.find(x);
      const rootY = this.find(y);

      if (rootX === rootY) {
        return;
      }

      if (rootX.rank < rootY.rank) {
        rootX.parent = rootY;
      } else if (rootX.rank > rootY.rank) {
        rootY.parent = rootX;
      } else {
        rootY.parent = rootX;
        rootX.rank++;
      }
    }
    /**
     * Finds and returns the root node of the set that contains node
     * @param {DisjointSetNode} node
     * @return {DisjointSetNode}
     */


    find(node) {
      var rootX = node;

      while (rootX.parent !== null) {
        rootX = rootX.parent;
      }

      var toUpdateX = node;

      while (toUpdateX.parent !== null) {
        var toUpdateParent = toUpdateX;
        toUpdateX = toUpdateX.parent;
        toUpdateParent.parent = rootX;
      }

      return rootX;
    }
    /**
     * Returns true if x and y belong to the same set
     * @param {DisjointSetNode} x
     * @param {DisjointSetNode} y
     */


    connected(x, y) {
      return this.find(x) === this.find(y);
    }

  }

  var DisjointSet_1 = DisjointSet;

  function DisjointSetNode(value) {
    this.value = value;
    this.parent = null;
    this.rank = 0;
  }

  const direction8X$2 = [-1, -1, 0, 1, -1, 0, 1, 1];
  const direction8Y$2 = [0, -1, -1, -1, 1, 1, 1, 0];
  const neighbours8$1 = [null, null, null, null, null, null, null, null];
  const direction4X$1 = [-1, 0, 1, 0];
  const direction4Y$1 = [0, -1, 0, 1];
  const neighbours4$1 = [null, null, null, null];
  function drainLabelling(data, mask, options = {}) {
    const {
      neighbours = 8,
      width,
      height
    } = options;
    let directionX;
    let directionY;
    let neighboursList;

    if (neighbours === 8) {
      directionX = direction8X$2;
      directionY = direction8Y$2;
      neighboursList = neighbours8$1;
    } else if (neighbours === 4) {
      directionX = direction4X$1;
      directionY = direction4Y$1;
      neighboursList = neighbours4$1;
    } else {
      throw new RangeError(`unsupported neighbours count: ${neighbours}`);
    }

    let sorted = new Array(height * width);

    for (let i = 0, index = 0; i < height; i++) {
      for (let j = 0; j < width; j++, index++) {
        sorted[index] = {
          value: data[index],
          row: i,
          col: j,
          mask: mask[index]
        };
      }
    }

    sorted.sort((a, b) => a.value - b.value);
    const size = mask.length;
    const labels = new Array(size);
    const pixels = new Int16Array(size);
    const linked = new DisjointSet_1();

    for (let i = 0, currentLabel = 1; i < mask.length; i++) {
      let element = sorted[i];
      if (!element.mask) continue;
      let {
        row,
        col,
        value
      } = element;
      let index = col + row * width;
      let label = labels[index];

      if (!label) {
        labels[index] = linked.add(currentLabel++);
      }

      for (let k = 0; k < neighboursList.length; k++) {
        let ii = col + directionX[k];
        let jj = row + directionY[k];

        if (ii >= 0 && jj >= 0 && ii < width && jj < height) {
          let neighbor = labels[ii + jj * width];

          if (!neighbor) {
            let neighborValue = data[ii + jj * width];

            if (value < neighborValue) {
              labels[ii + jj * width] = labels[index];
            }
          }
        }
      }
    }

    for (let j = 0; j < height; j++) {
      for (let i = 0; i < width; i++) {
        let index = i + j * width;

        if (mask[index]) {
          pixels[index] = linked.find(labels[index]).value;
        }
      }
    }

    return pixels;
  }

  const direction4X = [-1, 0];
  const direction4Y = [0, -1];
  const neighbours4 = [null, null];
  const direction8X$1 = [-1, -1, 0, 1];
  const direction8Y$1 = [0, -1, -1, -1];
  const neighbours8 = [null, null, null, null];
  function floodFillLabelling(mask, width, height, options) {
    options = options || {};
    const neighbours = options.neighbours || 8;
    let directionX;
    let directionY;
    let neighboursList;

    if (neighbours === 8) {
      directionX = direction8X$1;
      directionY = direction8Y$1;
      neighboursList = neighbours8;
    } else if (neighbours === 4) {
      directionX = direction4X;
      directionY = direction4Y;
      neighboursList = neighbours4;
    } else {
      throw new RangeError(`unsupported neighbours count: ${neighbours}`);
    }

    const size = mask.length;
    const labels = new Array(size);
    const pixels = new Int16Array(size);
    const linked = new DisjointSet_1();
    let index;
    let currentLabel = 1;

    for (let j = 0; j < height; j++) {
      for (let i = 0; i < width; i++) {
        // true means out of background
        let smallestNeighbor = null;
        index = i + j * width;

        if (mask[index]) {
          for (let k = 0; k < neighboursList.length; k++) {
            let ii = i + directionX[k];
            let jj = j + directionY[k];

            if (ii >= 0 && jj >= 0 && ii < width && jj < height) {
              let neighbor = labels[ii + jj * width];

              if (!neighbor) {
                neighboursList[k] = null;
              } else {
                neighboursList[k] = neighbor;

                if (!smallestNeighbor || neighboursList[k].value < smallestNeighbor.value) {
                  smallestNeighbor = neighboursList[k];
                }
              }
            }
          }

          if (!smallestNeighbor) {
            labels[index] = linked.add(currentLabel++);
          } else {
            labels[index] = smallestNeighbor;

            for (let k = 0; k < neighboursList.length; k++) {
              if (neighboursList[k] && neighboursList[k] !== smallestNeighbor) {
                linked.union(smallestNeighbor, neighboursList[k]);
              }
            }
          }
        }
      }
    }

    for (let j = 0; j < height; j++) {
      for (let i = 0; i < width; i++) {
        index = i + j * width;

        if (mask[index]) {
          pixels[index] = linked.find(labels[index]).value;
        }
      }
    }

    return pixels;
  }

  const smallFilter$1 = [[0, 0, 1, 2, 2, 2, 1, 0, 0], [0, 1, 4, 7, 7, 7, 4, 1, 0], [1, 4, 5, 3, 0, 3, 5, 4, 1], [2, 7, 3, -12, -23, -12, 3, 7, 2], [2, 7, 0, -23, -40, -23, 0, 7, 2], [2, 7, 3, -12, -23, -12, 3, 7, 2], [1, 4, 5, 3, 0, 3, 5, 4, 1], [0, 1, 3, 7, 7, 7, 3, 1, 0], [0, 0, 1, 2, 2, 2, 1, 0, 0]];
  /**
   * Detects all the 2D-peaks in the given spectrum based on center of mass logic.
   * @param {Array<Array>} input - matrix to get the local maxima
   * @param {Object} [options = {}] - options of the method.
   * @param {Array<Array>} [options.nStdDev = 3] - number of times of the standard deviations for the noise level.Float64Array
   * @param {Array<Array>} [options.kernel] - kernel to the convolution step.
   * @param {string} [options.labelling = 'drain'] - select the labelling algorithm to assign pixels.
   * @param {Array<Array>} [options.originalData] - original data useful when the original matrix has values and the input matrix has absolute ones
   * @param {Array<Array>} [options.filteredData] - convoluted data, if it is defined the convolution step is skipped
   */

  function findPeaks2DRegion(input, options = {}) {
    let {
      nStdDev = 3,
      kernel = smallFilter$1,
      originalData = matrix2Array(input).data,
      filteredData,
      rows: nRows,
      cols: nCols,
      labelling = 'drain'
    } = options;
    let flatten = matrix2Array(input);
    let data = flatten.data;

    if (!nRows || !nCols) {
      nRows = flatten.rows;
      nCols = flatten.cols;
    }

    if (!nRows || !nCols) {
      throw new Error(`Invalid number of rows or columns ${nRows} ${nCols}`);
    }

    let cs = filteredData;
    if (!cs) cs = convolutionFFT(data, kernel, options);
    let threshold = 0;

    for (let i = nCols * nRows - 2; i >= 0; i--) {
      threshold += Math.pow(cs[i] - cs[i + 1], 2);
    }

    threshold = -Math.sqrt(threshold) * nStdDev / nRows;
    let bitmask = new Uint16Array(nCols * nRows);

    for (let i = cs.length - 1; i >= 0; i--) {
      if (cs[i] < threshold) {
        bitmask[i] = 1;
      }
    }

    let pixels;

    switch (labelling.toLowerCase()) {
      case 'drain':
        pixels = drainLabelling(cs, bitmask, {
          neighbours: 8,
          width: nCols,
          height: nRows
        });
        break;

      case 'floodfill':
        pixels = floodFillLabelling(bitmask, nCols, nRows, {
          neighbours: 8
        });
        break;

      default:
        throw new Error(`labelling ${labelling} does not support`);
    }

    return extractPeaks(pixels, {
      data,
      nCols,
      originalData
    });
  }

  function extractPeaks(pixels, options) {
    const {
      data,
      nCols,
      originalData
    } = options; //How many different groups we have?

    let labels = {};
    let row, col, tmp;

    for (let i = 0; i < pixels.length; i++) {
      if (pixels[i] !== 0) {
        col = i % nCols;
        row = (i - col) / nCols;

        if (labels[pixels[i]]) {
          tmp = labels[pixels[i]];
          tmp.x += col * data[i];
          tmp.y += row * data[i];
          tmp.z += originalData[i];
          if (col < tmp.minX) tmp.minX = col;
          if (col > tmp.maxX) tmp.maxX = col;
          if (row < tmp.minY) tmp.minY = row;
          if (row > tmp.maxY) tmp.maxY = row;
        } else {
          labels[pixels[i]] = {
            x: col * data[i],
            y: row * data[i],
            z: originalData[i],
            minX: col,
            maxX: col,
            minY: row,
            maxY: row
          };
        }
      }
    }

    let keys = Object.keys(labels);
    let peakList = new Array(keys.length);

    for (let i = 0; i < keys.length; i++) {
      peakList[i] = labels[keys[i]];
      let zValue = Math.abs(peakList[i].z);
      peakList[i].x /= zValue;
      peakList[i].y /= zValue;
    }

    return peakList;
  }

  const direction8X = [-1, -1, -1, 0, 0, 1, 1, 1];
  const direction8Y = [-1, 0, 1, -1, 1, -1, 0, 1];
  const direction16X = [-2, -2, -2, -2, -2, -1, -1, 0, 0, 1, 1, 2, 2, 2, 2, 2];
  const direction16Y = [-2, -1, 0, 1, 2, -2, 2, -2, 2, -2, 2, -2, -1, 0, 1, 2];
  function determineRealTop(peaks, options) {
    let {
      nCols,
      absoluteData,
      originalData,
      minX,
      maxX,
      minY,
      maxY
    } = options;

    for (let i = 0; i < peaks.length; i++) {
      let xIndex = Math.round(peaks[i].x);
      let yIndex = Math.round(peaks[i].y);
      let currentIndex = xIndex + yIndex * nCols;
      let {
        index,
        isMax
      } = determineMax(absoluteData, {
        xIndex,
        yIndex,
        nCols,
        shell: 1
      });
      currentIndex = isMax ? index : determineMax(absoluteData, {
        xIndex,
        yIndex,
        nCols,
        shell: 2
      }).index;
      let realTopCoordinates = fitGaussian(originalData, {
        nCols,
        index: currentIndex,
        minY,
        maxY,
        minX,
        maxX
      });
      peaks[i] = Object.assign(peaks[i], realTopCoordinates);
    }

    return peaks;
  }

  function determineMax(data, options) {
    let {
      xIndex,
      yIndex,
      shell,
      nCols
    } = options;
    let currentIndex = xIndex + yIndex * nCols;
    let [directionX, directionY] = shell > 1 ? [direction16X, direction16Y] : [direction8X, direction8Y];
    let isMax = false;

    for (let i = 0; i < directionX.length; i++) {
      let c = xIndex + directionX[i];
      let r = yIndex + directionY[i];

      if (data[c + r * nCols] >= data[currentIndex]) {
        isMax = true;
        let candidateIndex = c + r * nCols;

        for (let k = 0; k < direction8Y.length; k++) {
          let nc = c + direction8X[k];
          let nr = r + direction8Y[k];

          if (data[nc + nr * nCols] > data[candidateIndex]) {
            isMax = false;
            break;
          }
        }

        if (isMax) {
          currentIndex = candidateIndex;
        }
      }
    }

    return {
      index: currentIndex,
      isMax
    };
  }

  function fitGaussian(data, options) {
    let {
      nCols,
      index,
      minY,
      maxY,
      minX,
      maxX
    } = options;
    let nRows = data.length / nCols;
    let intervalX = (maxX - minX) / (nCols - 1);
    let intervalY = (maxY - minY) / (nRows - 1);
    let col = index % nCols;
    let row = (index - col) / nCols;
    let newCol = 1;
    let newRow = 1;
    let max = Number.MIN_SAFE_INTEGER;
    let z = new Array(direction8X.length + 1);
    let xAxis = new Array(direction8X.length + 1);

    for (let i = -1, xi = 0; i < 2; i++) {
      for (let j = -1; j < 2; j++, xAxis[xi] = xi++) {
        let value = data[col + j + (row + i) * nCols];
        if (max < value) max = value;
        z[newCol + j + (newRow + i) * 3] = value;
      }
    }

    for (let i = 0; i < z.length; i++) z[i] /= max;

    let maxValues = [newCol + 1, newRow + 1, 1.5, 1, 1];
    let minValues = [newCol - 1, newRow - 1, -1.5, 0.001, 0.001];
    let initialValues = [newCol, newRow, z[newCol + newRow * 3], 0.2, 0.2];
    let gradientDifference = [1e-4, 1e-4, 1e-3, 1e-3, 1e-3];
    let func = paramGaussian2D(intervalX, intervalY, 3);
    let pFit = levenbergMarquardt({
      x: xAxis,
      y: z
    }, func, {
      damping: 1.5,
      maxIterations: 100,
      errorTolerance: 1e-8,
      initialValues,
      gradientDifference,
      maxValues,
      minValues
    }).parameterValues;
    return {
      x: pFit[0] + col - 1,
      y: pFit[1] + row - 1,
      z: pFit[2] * max
    };
  }

  function paramGaussian2D(intervalX, intervalY, nCols) {
    return function (p) {
      return function (t) {
        let nL = p.length / 5;
        let result = 0;
        let xIndex = t % nCols;
        let yIndex = (t - xIndex) / nCols;

        for (let i = 0; i < nL; i++) {
          result += p[i + 2 * nL] * Gaussian2D.fct((xIndex - p[i]) * intervalX, (yIndex - p[i + nL]) * intervalY, p[i + 3 * nL], p[i + 4 * nL]);
        }

        return result;
      };
    };
  }

  function getKernel(options = {}) {
    let {
      sigma = 1.4,
      xLength = 9,
      yLength = 9
    } = options;
    let factor = -40 / laplacianOfGaussian(0, 0, sigma);
    const xCenter = (xLength - 1) / 2;
    const yCenter = (yLength - 1) / 2;
    let matrix = new Array(xLength);

    for (let x = 0; x < xLength; x++) {
      matrix[x] = new Array(yLength);

      for (let y = 0; y < yLength; y++) {
        matrix[x][y] = laplacianOfGaussian(x - xCenter, y - yCenter, sigma) * factor;
      }
    }

    return matrix;
  }

  const laplacianOfGaussian = (x, y, sigma) => {
    let factor = -(Math.pow(x, 2) + Math.pow(y, 2)) / 2 / Math.pow(sigma, 2);
    return -(1 / Math.PI / Math.pow(sigma, 4)) * (1 + factor) * Math.exp(factor);
  };

  let diagonalError = 0.05;
  let tolerance = 0.05;
  function clean(peaks, threshold) {
    let max = Number.NEGATIVE_INFINITY; // double min = Double.MAX_VALUE;

    for (let i = peaks.length - 1; i >= 0; i--) {
      if (Math.abs(peaks[i].z) > max) {
        max = Math.abs(peaks[i].z);
      }
    }

    max *= threshold;

    for (let i = peaks.length - 1; i >= 0; i--) {
      if (Math.abs(peaks[i].z) < max) {
        peaks.splice(i, 1);
      }
    }

    return peaks;
  }
  function enhanceSymmetry(signals) {
    let properties = initializeProperties(signals);
    let output = signals.slice(); // First step of the optimization: Symmetry validation

    let hits;

    for (let i = output.length - 1; i >= 0; i--) {
      let signal = output[i];

      if (signal.peaks.length > 1) {
        properties[i][1]++;
      }

      if (properties[i][0] === 1) {
        let index = exist(output, properties, signal, -1, true);

        if (index >= 0) {
          properties[i][1] += 2;
          properties[index][1] += 2;
        }
      }
    } // Second step of the optimization: Diagonal image existence


    for (let i = output.length - 1; i >= 0; i--) {
      let signal = output[i];

      if (properties[i][0] === 0) {
        hits = checkCrossPeaks(output, properties, signal, true);
        properties[i][1] += hits; // checkCrossPeaks(output, properties, signal, false);
      }
    } // Now, each peak have a score between 0 and 4, we can complete the patterns which
    // contains peaks with high scores, and finally, we can remove peaks with scores 0 and 1


    let count = 0;

    for (let i = output.length - 1; i >= 0; i--) {
      if (properties[i][0] !== 0 && properties[i][1] > 2) {
        count++;
        count += completeMissingIfNeeded(output, properties, output[i], properties[i]);
      }

      if (properties[i][1] >= 2 && properties[i][0] === 0) {
        count++;
      }
    }

    let toReturn = new Array(count);
    count--;

    for (let i = output.length - 1; i >= 0; i--) {
      if (properties[i][0] !== 0 && properties[i][1] > 2 || properties[i][0] === 0 && properties[i][1] > 1) {
        toReturn[count--] = output[i];
      }
    }

    return toReturn;
  }

  function completeMissingIfNeeded(output, properties, thisSignal, thisProp) {
    // Check for symmetry
    let index = exist(output, properties, thisSignal, -thisProp[0], true);
    let addedPeaks = 0;
    let newSignal = null;
    let tmpProp = null;

    if (index < 0) {
      // If this signal have no a symmetry image, we have to include it
      newSignal = {
        nucleusX: thisSignal.nucleusX,
        nucleusY: thisSignal.nucleusY
      };
      newSignal.resolutionX = thisSignal.resolutionX;
      newSignal.resolutionY = thisSignal.resolutionY;
      newSignal.shiftX = thisSignal.shiftY;
      newSignal.shiftY = thisSignal.shiftX;
      newSignal.peaks = [{
        x: thisSignal.shiftY,
        y: thisSignal.shiftX,
        z: 1
      }];
      output.push(newSignal);
      tmpProp = [-thisProp[0], thisProp[1]];
      properties.push(tmpProp);
      addedPeaks++;
    } // Check for diagonal peaks


    let j, signal;
    let diagX = false;
    let diagY = false;

    for (j = output.length - 1; j >= 0; j--) {
      signal = output[j];

      if (properties[j][0] === 0) {
        if (Math.abs(signal.shiftX - thisSignal.shiftX) < diagonalError) {
          diagX = true;
        }

        if (Math.abs(signal.shiftY - thisSignal.shiftY) < diagonalError) {
          diagY = true;
        }
      }
    }

    if (diagX === false) {
      newSignal = {
        nucleusX: thisSignal.nucleusX,
        nucleusY: thisSignal.nucleusY
      };
      newSignal.resolutionX = thisSignal.resolutionX;
      newSignal.resolutionY = thisSignal.resolutionY;
      newSignal.shiftX = thisSignal.shiftX;
      newSignal.shiftY = thisSignal.shiftX;
      newSignal.peaks = [{
        x: thisSignal.shiftX,
        y: thisSignal.shiftX,
        z: 1
      }];
      output.push(newSignal);
      tmpProp = [0, thisProp[1]];
      properties.push(tmpProp);
      addedPeaks++;
    }

    if (diagY === false) {
      newSignal = {
        nucleusX: thisSignal.nucleusX,
        nucleusY: thisSignal.nucleusY
      };
      newSignal.resolutionX = thisSignal.resolutionX;
      newSignal.resolutionY = thisSignal.resolutionY;
      newSignal.shiftX = thisSignal.shiftY;
      newSignal.shiftY = thisSignal.shiftY;
      newSignal.peaks = [{
        x: thisSignal.shiftY,
        y: thisSignal.shiftY,
        z: 1
      }];
      output.push(newSignal);
      tmpProp = [0, thisProp[1]];
      properties.push(tmpProp);
      addedPeaks++;
    }

    return addedPeaks;
  } // Check for any diagonal peak that match this cross peak


  function checkCrossPeaks(output, properties, signal, updateProperties) {
    let hits = 0;
    let shift = signal.shiftX * 4;
    let crossPeaksX = [];
    let crossPeaksY = [];
    let cross;

    for (let i = output.length - 1; i >= 0; i--) {
      cross = output[i];

      if (properties[i][0] !== 0) {
        if (Math.abs(cross.shiftX - signal.shiftX) < diagonalError) {
          hits++;

          if (updateProperties) {
            properties[i][1]++;
          }

          crossPeaksX.push(i);
          shift += cross.shiftX;
        } else {
          if (Math.abs(cross.shiftY - signal.shiftY) < diagonalError) {
            hits++;

            if (updateProperties) {
              properties[i][1]++;
            }

            crossPeaksY.push(i);
            shift += cross.shiftY;
          }
        }
      }
    } // Update found crossPeaks and diagonal peak


    shift /= crossPeaksX.length + crossPeaksY.length + 4;

    if (crossPeaksX.length > 0) {
      for (let i = crossPeaksX.length - 1; i >= 0; i--) {
        output[crossPeaksX[i]].shiftX = shift;
      }
    }

    if (crossPeaksY.length > 0) {
      for (let i = crossPeaksY.length - 1; i >= 0; i--) {
        output[crossPeaksY[i]].shiftY = shift;
      }
    }

    signal.shiftX = shift;
    signal.shiftY = shift;
    return hits;
  }

  function exist(output, properties, signal, type, symmetricSearch) {
    for (let i = output.length - 1; i >= 0; i--) {
      if (properties[i][0] === type) {
        if (distanceTo(signal, output[i], symmetricSearch) < tolerance) {
          if (!symmetricSearch) {
            let shiftX = (output[i].shiftX + signal.shiftX) / 2.0;
            let shiftY = (output[i].shiftY + signal.shiftY) / 2.0;
            output[i].shiftX = shiftX;
            output[i].shiftY = shiftY;
            signal.shiftX = shiftX;
            signal.shiftY = shiftY;
          } else {
            let shiftX = signal.shiftX;
            let shiftY = output[i].shiftX;
            output[i].shiftY = shiftX;
            signal.shiftY = shiftY;
          }

          return i;
        }
      }
    }

    return -1;
  }
  /**
   * Try to determine the position of each signal within the spectrum matrix.
   * Peaks could be of 3 types: upper diagonal, diagonal or under diagonal 1,0,-1
   * respectively.
   * @param {Array} signals
   * @return {*} A matrix containing the properties of each signal
   * @private
   */


  function initializeProperties(signals) {
    let signalsProperties = new Array(signals.length);

    for (let i = signals.length - 1; i >= 0; i--) {
      signalsProperties[i] = [0, 0]; // We check if it is a diagonal peak

      if (Math.abs(signals[i].shiftX - signals[i].shiftY) <= diagonalError) {
        signalsProperties[i][1] = 1;
        let shift = (signals[i].shiftX * 2 + signals[i].shiftY) / 3.0;
        signals[i].shiftX = shift;
        signals[i].shiftY = shift;
      } else {
        if (signals[i].shiftX - signals[i].shiftY > 0) {
          signalsProperties[i][0] = 1;
        } else {
          signalsProperties[i][0] = -1;
        }
      }
    }

    return signalsProperties;
  }
  /**
   * This function calculates the distance between 2 nmr signals . If toImage is true,
   * it will interchange x by y in the distance calculation for the second signal.
   * @param {object} a
   * @param {object} b
   * @param {boolean} toImage
   * @return {number}
   * @private
   */


  function distanceTo(a, b, toImage) {
    if (!toImage) {
      return Math.sqrt(Math.pow(a.shiftX - b.shiftX, 2) + Math.pow(a.shiftY - b.shiftY, 2));
    } else {
      return Math.sqrt(Math.pow(a.shiftX - b.shiftY, 2) + Math.pow(a.shiftY - b.shiftX, 2));
    }
  }

  const smallFilter = [[0, 0, 1, 2, 2, 2, 1, 0, 0], [0, 1, 4, 7, 7, 7, 4, 1, 0], [1, 4, 5, 3, 0, 3, 5, 4, 1], [2, 7, 3, -12, -23, -12, 3, 7, 2], [2, 7, 0, -23, -40, -23, 0, 7, 2], [2, 7, 3, -12, -23, -12, 3, 7, 2], [1, 4, 5, 3, 0, 3, 5, 4, 1], [0, 1, 3, 7, 7, 7, 3, 1, 0], [0, 0, 1, 2, 2, 2, 1, 0, 0]];
  function xyzAutoPeaksPicking(spectraData, options = {}) {
    let {
      sizeToPad = 14,
      realTopDetection = true,
      thresholdFactor = 0.5,
      nucleus = ['1H', '1H'],
      observeFrequencies,
      enhanceSymmetry: enhanceSymmetry$1 = false,
      clean: clean$1 = true,
      maxPercentCutOff = 0.03,
      tolerances = [24, 24],
      convolutionByFFT = true,
      kernel: kernelOptions
    } = options;
    thresholdFactor = thresholdFactor === 0 ? 1 : Math.abs(thresholdFactor);
    let nbPoints = spectraData.z[0].length;
    let nbSubSpectra = spectraData.z.length;

    if (nbSubSpectra < sizeToPad) {
      spectraData = padData(spectraData, {
        width: sizeToPad
      });
      nbPoints = spectraData.z[0].length;
      nbSubSpectra = spectraData.z.length;
    }

    let absoluteData = new Float64Array(nbPoints * nbSubSpectra);
    let originalData = new Float64Array(nbPoints * nbSubSpectra);

    for (let iSubSpectra = 0; iSubSpectra < nbSubSpectra; iSubSpectra++) {
      let spectrum = spectraData.z[iSubSpectra];

      for (let iCol = 0; iCol < nbPoints; iCol++) {
        let index = iSubSpectra * nbPoints + iCol;
        absoluteData[index] = Math.abs(spectrum[iCol]);
        originalData[index] = spectrum[iCol]; //@todo pensar si se puede evitar originalData
      }
    }

    let kernel = kernelOptions ? getKernel(kernelOptions) : smallFilter;
    let convolutedSpectrum = convolutionByFFT ? convolutionFFT(absoluteData, kernel, {
      rows: nbSubSpectra,
      cols: nbPoints
    }) : convolutionDirect(absoluteData, kernel, {
      rows: nbSubSpectra,
      cols: nbPoints
    });
    let peaksMC1 = findPeaks2DRegion(absoluteData, {
      originalData,
      filteredData: convolutedSpectrum,
      rows: nbSubSpectra,
      cols: nbPoints,
      nStdDev: thresholdFactor
    });

    if (clean$1) {
      // Remove peaks with less than x% of the intensity of the highest peak
      peaksMC1 = clean(peaksMC1, maxPercentCutOff);
    }

    let signals = createSignals2D$1(peaksMC1, {
      nRows: nbSubSpectra,
      nCols: nbPoints,
      minX: spectraData.minX,
      maxX: spectraData.maxX,
      minY: spectraData.minY,
      maxY: spectraData.maxY,
      absoluteData,
      originalData,
      tolerances,
      nucleus,
      observeFrequencies,
      realTopDetection
    });

    if (enhanceSymmetry$1) {
      signals = enhanceSymmetry(signals);
    }

    return signals;
  }
  /**
   * This function converts a set of 2D-peaks in 2D-signals. Each signal could be composed
   * of many 2D-peaks, and it has some additional information related to the NMR spectrum.
   * @param {Array} peaks
   * @param {Object} spectraData
   * @param {Object} options
   * @return {Array}
   * @private
   */

  const createSignals2D$1 = (peaks, options) => {
    let {
      nCols,
      nRows,
      absoluteData,
      originalData,
      observeFrequencies,
      tolerances,
      nucleus,
      realTopDetection,
      minY,
      maxY,
      minX,
      maxX
    } = options;
    let [nucleusX, nucleusY] = nucleus;
    let [toleranceX, toleranceY] = tolerances;
    let [observeFrequencyX, observeFrequencyY] = observeFrequencies;
    let dy = (maxY - minY) / (nRows - 1);
    let dx = (maxX - minX) / (nCols - 1);

    if (realTopDetection) {
      peaks = determineRealTop(peaks, {
        nCols,
        absoluteData,
        originalData,
        minX,
        maxX,
        minY,
        maxY
      });
    }

    for (let i = peaks.length - 1; i >= 0; i--) {
      let {
        x,
        y
      } = peaks[i];
      peaks[i].x = minX + dx * x;
      peaks[i].y = minY + dy * y;
      peaks[i].minX = minX + dx * peaks[i].minX;
      peaks[i].minY = minY + dy * peaks[i].minY;
      peaks[i].maxX = minX + dx * peaks[i].maxX;
      peaks[i].maxY = minY + dy * peaks[i].maxY; // Still having problems to correctly detect peaks on those areas. So I'm removing everything there.

      if (peaks[i].y < -1 || peaks[i].y >= 210) {
        peaks.splice(i, 1);
      }
    } // The connectivity matrix is an square and symmetric matrix, so we'll only store the upper diagonal in an
    // array like form


    let connectivity = [];

    for (let i = 0; i < peaks.length; i++) {
      for (let j = i; j < peaks.length; j++) {
        if (Math.abs(peaks[i].x - peaks[j].x) * observeFrequencyX < toleranceX && Math.abs(peaks[i].y - peaks[j].y) * observeFrequencyY < toleranceY) {
          // 24*24Hz We cannot distinguish peaks with less than 20 Hz of separation
          connectivity.push(1);
        } else {
          connectivity.push(0);
        }
      }
    }

    let clusters = src$1(connectivity);
    let signals = [];

    if (clusters) {
      for (let iCluster = 0; iCluster < clusters.length; iCluster++) {
        let signal = {
          nucleusX,
          nucleusY
        };
        signal.resolutionX = dx;
        signal.resolutionY = dy;
        let peaks2D = [];
        signal.shiftX = 0;
        signal.shiftY = 0;
        let minMax1 = [Number.MAX_VALUE, 0];
        let minMax2 = [Number.MAX_VALUE, 0];
        let sumZ = 0; // for (let jPeak = clusters[iCluster].length - 1; jPeak >= 0; jPeak--) {

        for (let jPeak = 0; jPeak < clusters[iCluster].length; jPeak++) {
          if (clusters[iCluster][jPeak] === 1) {
            peaks2D.push(peaks[jPeak]);
            signal.shiftX += peaks[jPeak].x * peaks[jPeak].z;
            signal.shiftY += peaks[jPeak].y * peaks[jPeak].z;
            sumZ += peaks[jPeak].z;

            if (peaks[jPeak].minX < minMax1[0]) {
              minMax1[0] = peaks[jPeak].minX;
            }

            if (peaks[jPeak].maxX > minMax1[1]) {
              minMax1[1] = peaks[jPeak].maxX;
            }

            if (peaks[jPeak].minY < minMax2[0]) {
              minMax2[0] = peaks[jPeak].minY;
            }

            if (peaks[jPeak].maxY > minMax2[1]) {
              minMax2[1] = peaks[jPeak].maxY;
            }
          }
        }

        signal.fromTo = [{
          from: minMax1[0],
          to: minMax1[1]
        }, {
          from: minMax2[0],
          to: minMax2[1]
        }];
        signal.shiftX /= sumZ;
        signal.shiftY /= sumZ;
        signal.peaks = peaks2D;
        signals.push(signal);
      }
    }

    return signals;
  };

  const padData = (spectraData, options = {}) => {
    let {
      minX,
      maxX,
      minY,
      maxY
    } = spectraData;
    let {
      width
    } = options;
    let nbPoints = spectraData.z[0].length;
    let nbSubSpectra = spectraData.z.length;
    let yInterval = (maxY - minY) / (nbSubSpectra - 1);
    let xInterval = (maxX - minX) / (nbPoints - 1);
    let yDiff = width - nbSubSpectra;
    let xDiff = Math.max(width - nbPoints, 0);
    if (xDiff % 2) xDiff++;
    if (yDiff % 2) yDiff++;
    let xOffset = xDiff / 2;
    let yOffset = yDiff / 2;
    let newMatrix = Matrix.zeros(nbSubSpectra + yDiff, nbPoints + xDiff);

    for (let i = 0; i < nbSubSpectra; i++) {
      for (let j = 0; j < nbPoints; j++) {
        newMatrix.set(i + yOffset, j + xOffset, spectraData.z[i][j]);
      }
    }

    return {
      z: newMatrix.to2DArray(),
      minX: minX - xOffset * xInterval,
      maxX: maxX + xOffset * xInterval,
      minY: minY - yOffset * yInterval,
      maxY: maxY + yOffset * yInterval
    };
  };

  // sources:
  // https://en.wikipedia.org/wiki/Gyromagnetic_ratio
  // TODO: #13 can we have a better source and more digits ? @jwist
  const gyromagneticRatio = {
    '1H': 267.52218744e6,
    '2H': 41.065e6,
    '3H': 285.3508e6,
    '3He': -203.789e6,
    '7Li': 103.962e6,
    '13C': 67.28284e6,
    '14N': 19.331e6,
    '15N': -27.116e6,
    '17O': -36.264e6,
    '19F': 251.662e6,
    '23Na': 70.761e6,
    '27Al': 69.763e6,
    '29Si': -53.19e6,
    '31P': 108.291e6,
    '57Fe': 8.681e6,
    '63Cu': 71.118e6,
    '67Zn': 16.767e6,
    '129Xe': -73.997e6
  };

  const defaultOptions = {
    reference: 0,
    referenceMaxShiftError: 0.08,
    tolerances: [10, 100],
    nucleus: ['1H', '1H'],
    observeFrequencies: [400, 400],
    jAnalyzer: {
      jAxisKey: {
        jAxis: 'y',
        intensity: 'z'
      }
    }
  };
  function xyzJResAnalyzer(signals, options = {}) {
    let jresAnalyzerOptions = assignDeep({}, defaultOptions, options);
    let {
      reference,
      referenceMaxShiftError
    } = jresAnalyzerOptions;
    let temporalSignals = compilePattern(signals, jresAnalyzerOptions); //check if the signal are symmetric around the reference

    let result = [];

    for (let i = 0; i < temporalSignals.length; i++) {
      let delta = temporalSignals[i].shiftY;
      if (Math.abs(delta - reference) > referenceMaxShiftError) continue;
      result.push(temporalSignals[i]);
    }

    return result;
  }

  function compilePattern(signals, options = {}) {
    let {
      observeFrequencies,
      tolerances,
      nucleus,
      jAnalyzer: jAnalyzerOptions
    } = options;
    let signalOptions = {
      observeFrequencies,
      tolerances,
      nucleus,
      dx: signals[0].resolutionX,
      dy: signals[0].resolutionY
    }; //adapt to 1D jAnalyzer

    for (let i = 0; i < signals.length; i++) {
      let signal = signals[i];
      let peaks = signal.peaks;
      signal.nbPeaks = signal.peaks.length;
      signal.multiplicity = '';
      signal.pattern = '';
      signal.delta1 = signal.shiftY;
      signal.observe = observeFrequencies[1];
      signal.integralData = {
        from: Number.MAX_SAFE_INTEGER,
        to: Number.MIN_SAFE_INTEGER
      };

      for (let j = 0; j < peaks.length; j++) {
        if (!peaks[j].width) peaks[j].width = 0.02;
      }

      peaks.sort((a, b) => a.y - b.y);
    }

    for (let i = 0; i < signals.length; i++) {
      jAnalyzer.compilePattern(signals[i], jAnalyzerOptions);

      if (signals[i].maskPattern && signals[i].multiplicity !== 'm' && signals[i].multiplicity !== '') {
        // Create a new signal with the removed peaks
        let peaksO = [];

        for (let j = signals[i].maskPattern.length - 1; j >= 0; j--) {
          if (signals[i].maskPattern[j] === false) {
            let peakR = signals[i].peaks.splice(j, 1)[0];
            peaksO.push(peakR);
            signals[i].mask.splice(j, 1);
            signals[i].mask2.splice(j, 1);
            signals[i].maskPattern.splice(j, 1);
            signals[i].nbPeaks--;
          }
        }

        if (peaksO.length > 0) {
          peaksO.reverse();
          let ranges = createSignals2D(peaksO, signalOptions);

          for (let j = 0; j < ranges.length; j++) {
            signals.push(ranges[j]);
          }
        }
      }
    }

    signals.sort((a, b) => {
      return b.shiftX - a.shiftX;
    });
    return signals;
  }

  function createSignals2D(peaks, options) {
    let {
      observeFrequencies,
      tolerances,
      nucleus,
      dx,
      dy
    } = options;
    let [nucleusX, nucleusY] = nucleus;
    let [toleranceX, toleranceY] = tolerances;
    let [observeFrequencyX, observeFrequencyY] = observeFrequencies; // The connectivity matrix is an square and symmetric matrix, so we'll only store the upper diagonal in an
    // array like form

    let connectivity = [];

    for (let i = 0; i < peaks.length; i++) {
      for (let j = i; j < peaks.length; j++) {
        if (Math.abs(peaks[i].x - peaks[j].x) * observeFrequencyX < toleranceX && Math.abs(peaks[i].y - peaks[j].y) * observeFrequencyY < toleranceY) {
          // 24*24Hz We cannot distinguish peaks with less than 20 Hz of separation
          connectivity.push(1);
        } else {
          connectivity.push(0);
        }
      }
    }

    let clusters = src$1(connectivity);
    let signals = [];

    if (clusters) {
      for (let iCluster = 0; iCluster < clusters.length; iCluster++) {
        let signal = {
          nucleusX,
          nucleusY,
          integralData: {
            from: Number.MAX_SAFE_INTEGER,
            to: Number.MIN_SAFE_INTEGER
          }
        };
        signal.nbPeaks = 0;
        signal.multiplicity = '';
        signal.pattern = '';
        signal.observe = observeFrequencyY;
        signal.resolutionX = dx;
        signal.resolutionY = dy;
        let peaks2D = [];
        signal.shiftX = 0;
        signal.shiftY = 0;
        let minMax1 = [Number.MAX_VALUE, 0];
        let minMax2 = [Number.MAX_VALUE, 0];
        let sumZ = 0;

        for (let jPeak = clusters[iCluster].length - 1; jPeak >= 0; jPeak--) {
          if (clusters[iCluster][jPeak] === 1) {
            signal.nbPeaks++;
            if (!peaks[jPeak].width) peaks[jPeak].width = 0.02;
            peaks2D.push(peaks[jPeak]);
            signal.shiftX += peaks[jPeak].x * peaks[jPeak].z;
            signal.shiftY += peaks[jPeak].y * peaks[jPeak].z;
            sumZ += peaks[jPeak].z;

            if (peaks[jPeak].minX < minMax1[0]) {
              minMax1[0] = peaks[jPeak].minX;
            }

            if (peaks[jPeak].maxX > minMax1[1]) {
              minMax1[1] = peaks[jPeak].maxX;
            }

            if (peaks[jPeak].minY < minMax2[0]) {
              minMax2[0] = peaks[jPeak].minY;
            }

            if (peaks[jPeak].maxY > minMax2[1]) {
              minMax2[1] = peaks[jPeak].maxY;
            }
          }
        }

        signal.fromTo = [{
          from: minMax1[0],
          to: minMax1[1]
        }, {
          from: minMax2[0],
          to: minMax2[1]
        }];
        signal.shiftX /= sumZ;
        signal.shiftY /= sumZ;
        signal.delta1 = signal.shiftY;
        signal.peaks = peaks2D;
        signals.push(signal);
      }
    }

    return signals;
  }

  exports.couplingPatterns = couplingPatterns;
  exports.gyromagneticRatio = gyromagneticRatio;
  exports.impurities = impurities;
  exports.peaksFilterImpurities = peaksFilterImpurities;
  exports.predictCarbon = predictCarbon;
  exports.predictProton = predictProton;
  exports.rangesToACS = rangesToACS;
  exports.signalsToRanges = signalsToRanges;
  exports.signalsToXY = signalsToXY;
  exports.xyAutoPeaksPicking = xyAutoPeaksPicking;
  exports.xyAutoRangesPicking = xyAutoRangesPicking;
  exports.xyzAutoPeaksPicking = xyzAutoPeaksPicking;
  exports.xyzJResAnalyzer = xyzJResAnalyzer;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=nmr-processing.js.map
