/**
 * nmr-processing - Pure functions allowing to process NMR spectra.
 * @version v10.0.0
 * @link https://github.com/cheminfo/nmr-processing#readme
 * @license MIT
 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    typeof define === 'function' && define.amd ? define(['exports'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.nmrProcessing = {}));
})(this, (function (exports) { 'use strict';

    const gyromagneticRatio = {
      '1H': 267.52218744e6,
      '2H': 41.065e6,
      '3H': 285.3508e6,
      '3He': -203.789e6,
      '7Li': 103.962e6,
      '13C': 67.28284e6,
      '14N': 19.331e6,
      '15N': -27.116e6,
      '17O': -36.264e6,
      '19F': 251.662e6,
      '23Na': 70.761e6,
      '27Al': 69.763e6,
      '29Si': -53.19e6,
      '31P': 108.291e6,
      '57Fe': 8.681e6,
      '63Cu': 71.118e6,
      '67Zn': 16.767e6,
      '129Xe': -73.997e6
    };

    /* eslint-disable camelcase */
    const impuritiesContent = {
      cdcl3: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: 'ds',
          shift: 7.26
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 'bs',
          shift: 1.56
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.1
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.17
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.1
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.36
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.28
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.19
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.22
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.98
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 5.01
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.27
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.43
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.26
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.43
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.73
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 5.3
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.21
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.48
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.65
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.57
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.39
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.4
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.55
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.09
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.02
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.94
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 8.02
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.96
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.88
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.62
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.71
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.25
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.72
        }, {
          proton: 'OH',
          coupling: 5,
          multiplicity: 's,t',
          shift: 1.32
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.05
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.12
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.26
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.14
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.46
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.06
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.76
        }],
        'grease^f': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 'm',
          shift: 0.86
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'br_s',
          shift: 1.26
        }],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.88
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.26
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.65
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.49
        }, {
          proton: 'OH',
          coupling: 0,
          multiplicity: 's',
          shift: 1.09
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.33
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 7
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.27
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.22
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 4.04
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.62
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.29
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.68
        }],
        silicone_greasei: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 0.07
        }],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.85
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.76
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.36
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.17
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.25
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.03
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.53
        }]
      },
      '(cd3)2co': {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 2.05
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 's',
          shift: 2.84
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.96
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.09
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.05
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.36
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.18
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.13
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.13
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.96
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.22
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.41
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 8.02
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.43
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.87
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 5.63
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.11
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.41
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.56
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.47
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.28
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.28
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.46
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.97
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.83
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.96
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.94
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.78
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.52
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.59
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.12
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.57
        }, {
          proton: 'OH',
          coupling: 5,
          multiplicity: 's,t',
          shift: 3.39
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.97
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.05
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.2
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.07
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.45
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.28
        }],
        'grease^f': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 'm',
          shift: 0.87
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'br_s',
          shift: 1.29
        }],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.88
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.28
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.59
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.31
        }, {
          proton: 'OH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.12
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.43
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.88
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.27
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.1
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 3.9
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.58
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.35
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.76
        }],
        silicone_greasei: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 0.13
        }],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.79
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.63
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.32
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.5
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.5
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.45
        }]
      },
      dmso: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: 'quint',
          shift: 2.5
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 's',
          shift: 3.33
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.91
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.09
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.07
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.37
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.11
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 4.19
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.11
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.08
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.87
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 6.65
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.18
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.36
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 8.32
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.4
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.9
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 5.76
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.09
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.38
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.51
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.38
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.24
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.24
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.43
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.96
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.94
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.78
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.95
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.89
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.73
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.54
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.57
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.06
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.44
        }, {
          proton: 'OH',
          coupling: 5,
          multiplicity: 's,t',
          shift: 4.63
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.99
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.03
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.17
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.07
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.43
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.91
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.34
        }],
        'grease^f': [],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.86
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.25
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.53
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.16
        }, {
          proton: 'OH',
          coupling: 0,
          multiplicity: 's',
          shift: 4.01
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.42
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.88
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.27
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.04
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 3.78
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.58
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.39
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.79
        }],
        silicone_greasei: [],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.76
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.6
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.3
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.18
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.25
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.93
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.43
        }]
      },
      c6d6: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 7.16
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 's',
          shift: 0.4
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.55
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.55
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.55
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.15
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.05
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 1.55
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.07
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.04
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.05
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 4.79
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.24
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.38
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.15
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.4
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 2.9
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 4.27
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.11
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.26
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.46
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.34
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.11
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.12
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.33
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.6
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.57
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.05
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.63
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.36
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.86
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.68
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.35
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.34
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.65
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.89
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.92
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.58
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 1.81
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.85
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.41
        }],
        'grease^f': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 'm',
          shift: 0.92
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'br_s',
          shift: 1.36
        }],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.89
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.24
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.4
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.07
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.94
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.86
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.23
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 0.95
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 3.67
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.53
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 6.66
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 6.98
        }],
        silicone_greasei: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 0.29
        }],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.4
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.57
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.11
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.02
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.13
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.4
        }]
      },
      cd3cn: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 1.94
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 's',
          shift: 2.13
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.96
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.08
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.96
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.37
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.16
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 2.18
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.14
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.13
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.97
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 5.2
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.22
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.39
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.58
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.44
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.81
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 5.44
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.12
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.42
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.53
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.45
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.29
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.28
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.45
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.97
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.96
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.83
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.92
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.89
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.77
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.5
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.6
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.12
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.54
        }, {
          proton: 'OH',
          coupling: 5,
          multiplicity: 's,t',
          shift: 2.47
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.97
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.06
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.2
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.06
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.43
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.51
        }],
        'grease^f': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 'm',
          shift: 0.86
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'br_s',
          shift: 1.27
        }],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.89
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.28
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.57
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.28
        }, {
          proton: 'OH',
          coupling: 0,
          multiplicity: 's',
          shift: 2.16
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.31
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.87
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.29
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.09
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 3.87
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.57
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.33
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.73
        }],
        silicone_greasei: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 0.08
        }],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.8
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.64
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.33
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.2
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.2
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.45
        }]
      },
      cd3od: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 3.31
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 's',
          shift: 4.87
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.99
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.15
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.03
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.33
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.4
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.15
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.2
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.92
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.21
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.4
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.9
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.45
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.78
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 5.49
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.18
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.49
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.61
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.58
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.35
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.35
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.52
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.07
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.31
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.92
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.97
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.99
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.86
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.65
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.66
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.19
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.6
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.01
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.09
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.24
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.12
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.5
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.01
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.59
        }],
        'grease^f': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 'm',
          shift: 0.88
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'br_s',
          shift: 1.29
        }],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.9
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.29
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.64
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.34
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.34
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.89
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.29
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.5
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 3.92
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.53
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.44
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.85
        }],
        silicone_greasei: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 0.1
        }],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.87
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.71
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.32
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.16
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.16
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.05
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.58
        }]
      },
      d2o: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 4.79
        }],
        h2o: [],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.08
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.22
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.06
        }],
        benzene: [],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.24
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.21
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.22
        }],
        bhtb: [],
        chloroform: [],
        cyclohexane: [],
        '1,2-dichloroethane': [],
        dichloromethane: [],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.17
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.56
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.67
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.61
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.37
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.37
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.6
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.08
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.06
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.9
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.92
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.01
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.85
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.71
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.75
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.17
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.65
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.07
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.14
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.24
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.19
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.18
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.26
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.65
        }],
        'grease^f': [],
        'n-hexane': [],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.61
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.34
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.4
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.9
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.17
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 4.02
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.52
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.45
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.87
        }],
        silicone_greasei: [],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.88
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.74
        }],
        toluene: [],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.99
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.57
        }]
      }
    };
    const impurities = impuritiesContent;

    const SignalKinds = [{
      label: 'Signal',
      value: 'signal'
    }, {
      label: 'Reference',
      value: 'reference'
    }, {
      label: 'Solvent',
      value: 'solvent'
    }, {
      label: 'Impurity',
      value: 'impurity'
    }, {
      label: 'Standard',
      value: 'standard'
    }, {
      label: 'P1',
      value: 'p1'
    }, {
      label: 'P2',
      value: 'p2'
    }, {
      label: 'P3',
      value: 'p3'
    }];
    const SignalKindsToInclude = ['signal'];
    const DatumKind = {
      signal: 'signal',
      mixed: 'mixed'
    };

    const MultiplicityPatterns = [{
      label: 'singlet',
      value: 's',
      multiplicity: 1,
      names: ['br s', 'br. s']
    }, {
      label: 'triplet',
      value: 't',
      multiplicity: 3,
      names: []
    }, {
      label: 'doublet',
      value: 'd',
      multiplicity: 2,
      names: []
    }, {
      label: 'quartet',
      value: 'q',
      multiplicity: 4,
      names: []
    }, {
      label: 'quintet',
      value: 'i',
      acs: 'quint',
      multiplicity: 5,
      names: ['quint', 'qui', 'qnt', 'pentet', 'pnt', 'pent']
    }, {
      label: 'sextet',
      value: 'h',
      multiplicity: 6,
      names: ['x', 'sxt', 'sext', 'hexuplet']
    }, {
      label: 'septet',
      value: 'p',
      acs: 'sept',
      multiplicity: 7,
      names: ['sept', 'spt', 'heptet', 'hpt', 'hept']
    }, {
      label: 'octet',
      value: 'o',
      multiplicity: 8,
      names: ['oct']
    }, {
      label: 'nonet',
      value: 'n',
      multiplicity: 9,
      names: ['non']
    }, {
      label: 'massive',
      value: 'm',
      multiplicity: null,
      names: []
    }];

    MultiplicityPatterns.sort((a, b) => a.multiplicity !== null && b.multiplicity !== null ? a.multiplicity - b.multiplicity : Number.MAX_SAFE_INTEGER);
    const couplingPatterns = MultiplicityPatterns.map(m => m.value);
    const couplingACSPatterns = MultiplicityPatterns.map(m => m.acs || m.value);

    const toCheck = ['solvent', 'h2o', 'tms'];
    /**
     * Try to remove peaks of impurities.
     */
    function peaksFilterImpurities(peakList, options = {}) {
      const {
        error = 0.025,
        remove = false
      } = options;
      if (options.solvent) {
        let {
          solvent
        } = options;
        if (solvent === '(cd3)2so') solvent = 'dmso';
        if (solvent === 'meod') solvent = 'cd3od';
        const solventImpurities = impurities[solvent];
        for (const impurity of toCheck) {
          const impurityShifts = solventImpurities[impurity];
          checkImpurity(peakList, impurityShifts, {
            error,
            remove,
            name: impurity
          });
        }
      }
      return peakList;
    }
    function checkImpurity(peakList, impurity, options) {
      const {
        name,
        error,
        remove
      } = options;
      let j, tolerance, difference;
      let i = impurity.length;
      while (i--) {
        j = peakList.length;
        while (j--) {
          tolerance = error + peakList[j].width;
          difference = Math.abs(impurity[i].shift - peakList[j].x);
          if (difference < tolerance) {
            // && (impurity[i].multiplicity === '' || (impurity[i].multiplicity.indexOf(peakList[j].multiplicity)) { // some impurities has multiplicities like 'bs' but at presents it is unsupported
            if (remove) {
              peakList.splice(j, 1);
            } else {
              peakList[j].kind = name;
            }
          }
        }
      }
    }

    const GAUSSIAN_EXP_FACTOR = -4 * Math.LN2;
    const ROOT_PI_OVER_LN2 = Math.sqrt(Math.PI / Math.LN2);
    const ROOT_THREE = Math.sqrt(3);
    const ROOT_2LN2 = Math.sqrt(2 * Math.LN2);
    const ROOT_2LN2_MINUS_ONE = Math.sqrt(2 * Math.LN2) - 1;

    // https://en.wikipedia.org/wiki/Error_function#Inverse_functions
    // This code yields to a good approximation
    // If needed a better implementation using polynomial can be found on https://en.wikipedia.org/wiki/Error_function#Inverse_functions
    function erfinv(x) {
      let a = 0.147;
      if (x === 0) return 0;
      let ln1MinusXSqrd = Math.log(1 - x * x);
      let lnEtcBy2Plus2 = ln1MinusXSqrd / 2 + 2 / (Math.PI * a);
      let firstSqrt = Math.sqrt(lnEtcBy2Plus2 ** 2 - ln1MinusXSqrd / a);
      let secondSqrt = Math.sqrt(firstSqrt - lnEtcBy2Plus2);
      return secondSqrt * (x > 0 ? 1 : -1);
    }

    class Gaussian {
      constructor(options = {}) {
        const {
          fwhm = 500,
          sd
        } = options;
        this.fwhm = sd ? gaussianWidthToFWHM(2 * sd) : fwhm;
      }
      fwhmToWidth(fwhm = this.fwhm) {
        return gaussianFwhmToWidth(fwhm);
      }
      widthToFWHM(width) {
        return gaussianWidthToFWHM(width);
      }
      fct(x) {
        return gaussianFct(x, this.fwhm);
      }
      getArea(height = calculateGaussianHeight({
        fwhm: this.fwhm
      })) {
        return getGaussianArea({
          fwhm: this.fwhm,
          height
        });
      }
      getFactor(area) {
        return getGaussianFactor(area);
      }
      getData(options = {}) {
        return getGaussianData(this, options);
      }
      calculateHeight(area = 1) {
        return calculateGaussianHeight({
          fwhm: this.fwhm,
          area
        });
      }
      getParameters() {
        return ['fwhm'];
      }
    }
    function calculateGaussianHeight(options) {
      let {
        fwhm = 500,
        area = 1,
        sd
      } = options;
      if (sd) fwhm = gaussianWidthToFWHM(2 * sd);
      return 2 * area / ROOT_PI_OVER_LN2 / fwhm;
    }
    /**
     * Calculate the height of the gaussian function of a specific width (fwhm) at a speicifc
     * x position (the gaussian is centered on x=0)
     * @param x
     * @param fwhm
     * @returns y
     */
    function gaussianFct(x, fwhm) {
      return Math.exp(GAUSSIAN_EXP_FACTOR * Math.pow(x / fwhm, 2));
    }
    function gaussianWidthToFWHM(width) {
      return width * ROOT_2LN2;
    }
    function gaussianFwhmToWidth(fwhm) {
      return fwhm / ROOT_2LN2;
    }
    function getGaussianArea(options) {
      let {
        fwhm = 500,
        sd,
        height = 1
      } = options;
      if (sd) fwhm = gaussianWidthToFWHM(2 * sd);
      return height * ROOT_PI_OVER_LN2 * fwhm / 2;
    }
    function getGaussianFactor(area = 0.9999) {
      return Math.sqrt(2) * erfinv(area);
    }
    function getGaussianData(shape = {}, options = {}) {
      let {
        fwhm = 500,
        sd
      } = shape;
      if (sd) fwhm = gaussianWidthToFWHM(2 * sd);
      let {
        length,
        factor = getGaussianFactor(),
        height = calculateGaussianHeight({
          fwhm
        })
      } = options;
      if (!length) {
        length = Math.min(Math.ceil(fwhm * factor), Math.pow(2, 25) - 1);
        if (length % 2 === 0) length++;
      }
      const center = (length - 1) / 2;
      const data = new Float64Array(length);
      for (let i = 0; i <= center; i++) {
        data[i] = gaussianFct(i - center, fwhm) * height;
        data[length - 1 - i] = data[i];
      }
      return data;
    }

    class Lorentzian {
      constructor(options = {}) {
        const {
          fwhm = 500
        } = options;
        this.fwhm = fwhm;
      }
      fwhmToWidth(fwhm = this.fwhm) {
        return lorentzianFwhmToWidth(fwhm);
      }
      widthToFWHM(width) {
        return lorentzianWidthToFWHM(width);
      }
      fct(x) {
        return lorentzianFct(x, this.fwhm);
      }
      getArea(height = 1) {
        return getLorentzianArea({
          fwhm: this.fwhm,
          height
        });
      }
      getFactor(area) {
        return getLorentzianFactor(area);
      }
      getData(options = {}) {
        return getLorentzianData(this, options);
      }
      calculateHeight(area = 1) {
        return calculateLorentzianHeight({
          fwhm: this.fwhm,
          area
        });
      }
      getParameters() {
        return ['fwhm'];
      }
    }
    const calculateLorentzianHeight = ({
      fwhm = 1,
      area = 1
    }) => {
      return 2 * area / Math.PI / fwhm;
    };
    const getLorentzianArea = options => {
      const {
        fwhm = 500,
        height = 1
      } = options;
      return height * Math.PI * fwhm / 2;
    };
    const lorentzianFct = (x, fwhm) => {
      return fwhm ** 2 / (4 * x ** 2 + fwhm ** 2);
    };
    const lorentzianWidthToFWHM = width => {
      return width * ROOT_THREE;
    };
    const lorentzianFwhmToWidth = fwhm => {
      return fwhm / ROOT_THREE;
    };
    const getLorentzianFactor = (area = 0.9999) => {
      if (area >= 1) {
        throw new Error('area should be (0 - 1)');
      }
      const halfResidual = (1 - area) * 0.5;
      const quantileFunction = p => Math.tan(Math.PI * (p - 0.5));
      return (quantileFunction(1 - halfResidual) - quantileFunction(halfResidual)) / 2;
    };
    const getLorentzianData = (shape = {}, options = {}) => {
      let {
        fwhm = 500
      } = shape;
      let {
        length,
        factor = getLorentzianFactor(),
        height = calculateLorentzianHeight({
          fwhm,
          area: 1
        })
      } = options;
      if (!length) {
        length = Math.min(Math.ceil(fwhm * factor), Math.pow(2, 25) - 1);
        if (length % 2 === 0) length++;
      }
      const center = (length - 1) / 2;
      const data = new Float64Array(length);
      for (let i = 0; i <= center; i++) {
        data[i] = lorentzianFct(i - center, fwhm) * height;
        data[length - 1 - i] = data[i];
      }
      return data;
    };

    class PseudoVoigt {
      constructor(options = {}) {
        const {
          fwhm = 500,
          mu = 0.5
        } = options;
        this.mu = mu;
        this.fwhm = fwhm;
      }
      fwhmToWidth(fwhm = this.fwhm, mu = this.mu) {
        return pseudoVoigtFwhmToWidth(fwhm, mu);
      }
      widthToFWHM(width, mu = this.mu) {
        return pseudoVoigtWidthToFWHM(width, mu);
      }
      fct(x) {
        return pseudoVoigtFct(x, this.fwhm, this.mu);
      }
      getArea(height = 1) {
        return getPseudoVoigtArea({
          fwhm: this.fwhm,
          height,
          mu: this.mu
        });
      }
      getFactor(area) {
        return getPseudoVoigtFactor(area);
      }
      getData(options = {}) {
        const {
          length,
          factor,
          height = calculatePseudoVoigtHeight({
            fwhm: this.fwhm,
            mu: this.mu,
            area: 1
          })
        } = options;
        return getPseudoVoigtData(this, {
          factor,
          length,
          height
        });
      }
      calculateHeight(area = 1) {
        return calculatePseudoVoigtHeight({
          fwhm: this.fwhm,
          mu: this.mu,
          area
        });
      }
      getParameters() {
        return ['fwhm', 'mu'];
      }
    }
    const calculatePseudoVoigtHeight = (options = {}) => {
      let {
        fwhm = 1,
        mu = 0.5,
        area = 1
      } = options;
      return 2 * area / (fwhm * (mu * ROOT_PI_OVER_LN2 + (1 - mu) * Math.PI));
    };
    const pseudoVoigtFct = (x, fwhm, mu) => {
      return (1 - mu) * lorentzianFct(x, fwhm) + mu * gaussianFct(x, fwhm);
    };
    const pseudoVoigtWidthToFWHM = (width, mu = 0.5) => {
      return width * (mu * ROOT_2LN2_MINUS_ONE + 1);
    };
    const pseudoVoigtFwhmToWidth = (fwhm, mu = 0.5) => {
      return fwhm / (mu * ROOT_2LN2_MINUS_ONE + 1);
    };
    const getPseudoVoigtArea = options => {
      const {
        fwhm = 500,
        height = 1,
        mu = 0.5
      } = options;
      return fwhm * height * (mu * ROOT_PI_OVER_LN2 + (1 - mu) * Math.PI) / 2;
    };
    const getPseudoVoigtFactor = (area = 0.9999, mu = 0.5) => {
      return mu < 1 ? getLorentzianFactor(area) : getGaussianFactor(area);
    };
    const getPseudoVoigtData = (shape = {}, options = {}) => {
      let {
        fwhm = 500,
        mu = 0.5
      } = shape;
      let {
        length,
        factor = getPseudoVoigtFactor(0.999, mu),
        height = calculatePseudoVoigtHeight({
          fwhm,
          mu,
          area: 1
        })
      } = options;
      if (!height) {
        height = 1 / (mu / Math.sqrt(-GAUSSIAN_EXP_FACTOR / Math.PI) * fwhm + (1 - mu) * fwhm * Math.PI / 2);
      }
      if (!length) {
        length = Math.min(Math.ceil(fwhm * factor), Math.pow(2, 25) - 1);
        if (length % 2 === 0) length++;
      }
      const center = (length - 1) / 2;
      const data = new Float64Array(length);
      for (let i = 0; i <= center; i++) {
        data[i] = pseudoVoigtFct(i - center, fwhm, mu) * height;
        data[length - 1 - i] = data[i];
      }
      return data;
    };

    class Gaussian2D {
      constructor(options = {}) {
        let {
          fwhm = 20,
          sd
        } = options;
        fwhm = ensureFWHM2D(fwhm, sd);
        this.fwhmX = fwhm.x;
        this.fwhmY = fwhm.y;
      }
      fct(x, y) {
        return gaussian2DFct(x, y, this.fwhmX, this.fwhmY);
      }
      getData(options = {}) {
        return getGaussian2DData({
          fwhm: {
            x: this.fwhmX,
            y: this.fwhmY
          }
        }, options);
      }
      getFactor(volume = 1) {
        return getGaussianFactor(volume);
      }
      getVolume(height = calculateGaussian2DHeight({
        fwhm: {
          x: this.fwhmX,
          y: this.fwhmY
        },
        volume: 1
      })) {
        return getGaussian2DVolume({
          fwhm: {
            x: this.fwhmX,
            y: this.fwhmY
          },
          height
        });
      }
      widthToFWHM(width) {
        return gaussianWidthToFWHM(width);
      }
      fwhmToWidth(fwhm) {
        return gaussianFwhmToWidth(fwhm);
      }
      calculateHeight(volume = 1) {
        return calculateGaussian2DHeight({
          volume,
          fwhm: {
            x: this.fwhmX,
            y: this.fwhmY
          }
        });
      }
      set fwhm(fwhm) {
        fwhm = ensureXYNumber$2(fwhm);
        this.fwhmX = fwhm.x;
        this.fwhmY = fwhm.y;
      }
    }
    const gaussian2DFct = (x, y, xFWHM, yFWHM) => {
      return Math.exp(GAUSSIAN_EXP_FACTOR * (Math.pow(x / xFWHM, 2) + Math.pow(y / yFWHM, 2)));
    };
    const getGaussian2DData = (shape, options = {}) => {
      let {
        fwhm = 50,
        sd
      } = shape;
      fwhm = ensureFWHM2D(fwhm, sd);
      let {
        factor = getGaussianFactor(),
        length = {
          x: 0,
          y: 0
        },
        height = calculateGaussian2DHeight({
          fwhm,
          volume: 1
        })
      } = options;
      factor = ensureXYNumber$2(factor);
      length = ensureXYNumber$2(length);
      for (const axis of ['x', 'y']) {
        if (!length[axis]) {
          length[axis] = Math.min(Math.ceil(fwhm[axis] * factor[axis]), Math.pow(2, 25) - 1);
          if (length[axis] % 2 === 0) length[axis]++;
        }
      }
      const xCenter = (length.x - 1) / 2;
      const yCenter = (length.y - 1) / 2;
      const data = new Array(length.x);
      for (let i = 0; i < length.x; i++) {
        data[i] = new Float64Array(length.y);
      }
      for (let i = 0; i < length.x; i++) {
        for (let j = 0; j < length.y; j++) {
          data[i][j] = gaussian2DFct(i - xCenter, j - yCenter, fwhm.x, fwhm.y) * height;
        }
      }
      return data;
    };
    const calculateGaussian2DHeight = (options = {}) => {
      let {
        volume = 1,
        fwhm = 50,
        sd
      } = options;
      fwhm = ensureFWHM2D(fwhm, sd);
      return volume * Math.LN2 * 4 / (Math.PI * fwhm.y * fwhm.x);
    };
    const getGaussian2DVolume = (options = {}) => {
      let {
        fwhm = 50,
        height = 1,
        sd
      } = options;
      fwhm = ensureFWHM2D(fwhm, sd);
      return height * Math.PI * fwhm.y * fwhm.x / Math.LN2 / 4;
    };
    function ensureXYNumber$2(input) {
      return typeof input !== 'object' ? {
        x: input,
        y: input
      } : {
        ...input
      };
    }
    function ensureFWHM2D(fwhm, sd) {
      if (sd !== undefined) {
        let sdObject = ensureXYNumber$2(sd);
        return {
          x: gaussianWidthToFWHM(2 * sdObject.x),
          y: gaussianWidthToFWHM(2 * sdObject.y)
        };
      } else if (fwhm !== undefined) {
        return ensureXYNumber$2(fwhm);
      } else {
        throw new Error('ensureFWHM2D must have either fwhm or sd defined');
      }
    }

    /**
     * Generate a instance of a specific kind of shape.
     */
    function getShape1D(shape) {
      const {
        kind
      } = shape;
      switch (kind) {
        case 'gaussian':
          return new Gaussian(shape);
        case 'lorentzian':
          return new Lorentzian(shape);
        case 'pseudoVoigt':
          return new PseudoVoigt(shape);
        default:
          {
            throw Error(`Unknown distribution ${kind}`);
          }
      }
    }

    /**
     * Generate a instance of a specific kind of shape.
     */
    function getShape2D(shape) {
      const {
        kind
      } = shape;
      switch (kind) {
        case 'gaussian':
          return new Gaussian2D(shape);
        default:
          {
            const unHandled = kind;
            // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
            throw Error(`Unknown distribution ${unHandled}`);
          }
      }
    }

    function addBaseline(data, baselineFct) {
      if (!baselineFct) return data;
      let xs = data.x;
      let ys = data.y;
      for (let i = 0; i < xs.length; i++) {
        ys[i] += baselineFct(xs[i]);
      }
      return data;
    }

    /**
     * Calculates reimAbsolute value of a complex spectrum
     *
     * @param data - complex spectrum
     * @returns - reimAbsolute value
     */
    function reimAbsolute(data) {
      const length = data.re.length;
      const re = data.re;
      const im = data.im;
      const newArray = new Float64Array(length);
      for (let i = 0; i < length; i++) {
        newArray[i] = Math.sqrt(re[i] ** 2 + im[i] ** 2);
      }
      return newArray;
    }

    var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

    var d3Array = {exports: {}};

    (function (module, exports) {
      (function (global, factory) {
        factory(exports) ;
      })(commonjsGlobal, function (exports) {

        function ascending(a, b) {
          return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
        }
        function bisector(compare) {
          if (compare.length === 1) compare = ascendingComparator(compare);
          return {
            left: function (a, x, lo, hi) {
              if (lo == null) lo = 0;
              if (hi == null) hi = a.length;
              while (lo < hi) {
                var mid = lo + hi >>> 1;
                if (compare(a[mid], x) < 0) lo = mid + 1;else hi = mid;
              }
              return lo;
            },
            right: function (a, x, lo, hi) {
              if (lo == null) lo = 0;
              if (hi == null) hi = a.length;
              while (lo < hi) {
                var mid = lo + hi >>> 1;
                if (compare(a[mid], x) > 0) hi = mid;else lo = mid + 1;
              }
              return lo;
            }
          };
        }
        function ascendingComparator(f) {
          return function (d, x) {
            return ascending(f(d), x);
          };
        }
        var ascendingBisect = bisector(ascending);
        var bisectRight = ascendingBisect.right;
        var bisectLeft = ascendingBisect.left;
        function descending(a, b) {
          return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
        }
        function number$1(x) {
          return x === null ? NaN : +x;
        }
        function variance(array, f) {
          var n = array.length,
            m = 0,
            a,
            d,
            s = 0,
            i = -1,
            j = 0;
          if (f == null) {
            while (++i < n) {
              if (!isNaN(a = number$1(array[i]))) {
                d = a - m;
                m += d / ++j;
                s += d * (a - m);
              }
            }
          } else {
            while (++i < n) {
              if (!isNaN(a = number$1(f(array[i], i, array)))) {
                d = a - m;
                m += d / ++j;
                s += d * (a - m);
              }
            }
          }
          if (j > 1) return s / (j - 1);
        }
        function deviation(array, f) {
          var v = variance(array, f);
          return v ? Math.sqrt(v) : v;
        }
        function extent(array, f) {
          var i = -1,
            n = array.length,
            a,
            b,
            c;
          if (f == null) {
            while (++i < n) if ((b = array[i]) != null && b >= b) {
              a = c = b;
              break;
            }
            while (++i < n) if ((b = array[i]) != null) {
              if (a > b) a = b;
              if (c < b) c = b;
            }
          } else {
            while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
              a = c = b;
              break;
            }
            while (++i < n) if ((b = f(array[i], i, array)) != null) {
              if (a > b) a = b;
              if (c < b) c = b;
            }
          }
          return [a, c];
        }
        function constant(x) {
          return function () {
            return x;
          };
        }
        function identity(x) {
          return x;
        }
        function range(start, stop, step) {
          start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;
          var i = -1,
            n = Math.max(0, Math.ceil((stop - start) / step)) | 0,
            range = new Array(n);
          while (++i < n) {
            range[i] = start + i * step;
          }
          return range;
        }
        var e10 = Math.sqrt(50);
        var e5 = Math.sqrt(10);
        var e2 = Math.sqrt(2);
        function ticks(start, stop, count) {
          var step = tickStep(start, stop, count);
          return range(Math.ceil(start / step) * step, Math.floor(stop / step) * step + step / 2,
          // inclusive
          step);
        }
        function tickStep(start, stop, count) {
          var step0 = Math.abs(stop - start) / Math.max(0, count),
            step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),
            error = step0 / step1;
          if (error >= e10) step1 *= 10;else if (error >= e5) step1 *= 5;else if (error >= e2) step1 *= 2;
          return stop < start ? -step1 : step1;
        }
        function sturges(values) {
          return Math.ceil(Math.log(values.length) / Math.LN2) + 1;
        }
        function number(x) {
          return +x;
        }
        function histogram() {
          var value = identity,
            domain = extent,
            threshold = sturges;
          function histogram(data) {
            var i,
              n = data.length,
              x,
              values = new Array(n);

            // Coerce values to numbers.
            for (i = 0; i < n; ++i) {
              values[i] = +value(data[i], i, data);
            }
            var xz = domain(values),
              x0 = +xz[0],
              x1 = +xz[1],
              tz = threshold(values, x0, x1);

            // Convert number of thresholds into uniform thresholds.
            if (!Array.isArray(tz)) tz = ticks(x0, x1, +tz);

            // Coerce thresholds to numbers, ignoring any outside the domain.
            var m = tz.length;
            for (i = 0; i < m; ++i) tz[i] = +tz[i];
            while (tz[0] <= x0) tz.shift(), --m;
            while (tz[m - 1] >= x1) tz.pop(), --m;
            var bins = new Array(m + 1),
              bin;

            // Initialize bins.
            for (i = 0; i <= m; ++i) {
              bin = bins[i] = [];
              bin.x0 = i > 0 ? tz[i - 1] : x0;
              bin.x1 = i < m ? tz[i] : x1;
            }

            // Assign data to bins by value, ignoring any outside the domain.
            for (i = 0; i < n; ++i) {
              x = values[i];
              if (x0 <= x && x <= x1) {
                bins[bisectRight(tz, x, 0, m)].push(data[i]);
              }
            }
            return bins;
          }
          histogram.value = function (_) {
            return arguments.length ? (value = typeof _ === "function" ? _ : constant(+_), histogram) : value;
          };
          histogram.domain = function (_) {
            return arguments.length ? (domain = typeof _ === "function" ? _ : constant([+_[0], +_[1]]), histogram) : domain;
          };
          histogram.thresholds = function (_) {
            if (!arguments.length) return threshold;
            threshold = typeof _ === "function" ? _ : Array.isArray(_) ? constant(Array.prototype.map.call(_, number)) : constant(+_);
            return histogram;
          };
          return histogram;
        }
        function quantile(array, p, f) {
          if (f == null) f = number$1;
          if (!(n = array.length)) return;
          if ((p = +p) <= 0 || n < 2) return +f(array[0], 0, array);
          if (p >= 1) return +f(array[n - 1], n - 1, array);
          var n,
            h = (n - 1) * p,
            i = Math.floor(h),
            a = +f(array[i], i, array),
            b = +f(array[i + 1], i + 1, array);
          return a + (b - a) * (h - i);
        }
        function freedmanDiaconis(values, min, max) {
          values.sort(ascending);
          return Math.ceil((max - min) / (2 * (quantile(values, 0.75) - quantile(values, 0.25)) * Math.pow(values.length, -1 / 3)));
        }
        function scott(values, min, max) {
          return Math.ceil((max - min) / (3.5 * deviation(values) * Math.pow(values.length, -1 / 3)));
        }
        function max(array, f) {
          var i = -1,
            n = array.length,
            a,
            b;
          if (f == null) {
            while (++i < n) if ((b = array[i]) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = array[i]) != null && b > a) a = b;
          } else {
            while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = f(array[i], i, array)) != null && b > a) a = b;
          }
          return a;
        }
        function mean(array, f) {
          var s = 0,
            n = array.length,
            a,
            i = -1,
            j = n;
          if (f == null) {
            while (++i < n) if (!isNaN(a = number$1(array[i]))) s += a;else --j;
          } else {
            while (++i < n) if (!isNaN(a = number$1(f(array[i], i, array)))) s += a;else --j;
          }
          if (j) return s / j;
        }
        function median(array, f) {
          var numbers = [],
            n = array.length,
            a,
            i = -1;
          if (f == null) {
            while (++i < n) if (!isNaN(a = number$1(array[i]))) numbers.push(a);
          } else {
            while (++i < n) if (!isNaN(a = number$1(f(array[i], i, array)))) numbers.push(a);
          }
          return quantile(numbers.sort(ascending), 0.5);
        }
        function merge(arrays) {
          var n = arrays.length,
            m,
            i = -1,
            j = 0,
            merged,
            array;
          while (++i < n) j += arrays[i].length;
          merged = new Array(j);
          while (--n >= 0) {
            array = arrays[n];
            m = array.length;
            while (--m >= 0) {
              merged[--j] = array[m];
            }
          }
          return merged;
        }
        function min(array, f) {
          var i = -1,
            n = array.length,
            a,
            b;
          if (f == null) {
            while (++i < n) if ((b = array[i]) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = array[i]) != null && a > b) a = b;
          } else {
            while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = f(array[i], i, array)) != null && a > b) a = b;
          }
          return a;
        }
        function pairs(array) {
          var i = 0,
            n = array.length - 1,
            p = array[0],
            pairs = new Array(n < 0 ? 0 : n);
          while (i < n) pairs[i] = [p, p = array[++i]];
          return pairs;
        }
        function permute(array, indexes) {
          var i = indexes.length,
            permutes = new Array(i);
          while (i--) permutes[i] = array[indexes[i]];
          return permutes;
        }
        function scan(array, compare) {
          if (!(n = array.length)) return;
          var i = 0,
            n,
            j = 0,
            xi,
            xj = array[j];
          if (!compare) compare = ascending;
          while (++i < n) if (compare(xi = array[i], xj) < 0 || compare(xj, xj) !== 0) xj = xi, j = i;
          if (compare(xj, xj) === 0) return j;
        }
        function shuffle(array, i0, i1) {
          var m = (i1 == null ? array.length : i1) - (i0 = i0 == null ? 0 : +i0),
            t,
            i;
          while (m) {
            i = Math.random() * m-- | 0;
            t = array[m + i0];
            array[m + i0] = array[i + i0];
            array[i + i0] = t;
          }
          return array;
        }
        function sum(array, f) {
          var s = 0,
            n = array.length,
            a,
            i = -1;
          if (f == null) {
            while (++i < n) if (a = +array[i]) s += a; // Note: zero and null are equivalent.
          } else {
            while (++i < n) if (a = +f(array[i], i, array)) s += a;
          }
          return s;
        }
        function transpose(matrix) {
          if (!(n = matrix.length)) return [];
          for (var i = -1, m = min(matrix, length), transpose = new Array(m); ++i < m;) {
            for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n;) {
              row[j] = matrix[j][i];
            }
          }
          return transpose;
        }
        function length(d) {
          return d.length;
        }
        function zip() {
          return transpose(arguments);
        }
        var version = "0.7.1";
        exports.version = version;
        exports.bisect = bisectRight;
        exports.bisectRight = bisectRight;
        exports.bisectLeft = bisectLeft;
        exports.ascending = ascending;
        exports.bisector = bisector;
        exports.descending = descending;
        exports.deviation = deviation;
        exports.extent = extent;
        exports.histogram = histogram;
        exports.thresholdFreedmanDiaconis = freedmanDiaconis;
        exports.thresholdScott = scott;
        exports.thresholdSturges = sturges;
        exports.max = max;
        exports.mean = mean;
        exports.median = median;
        exports.merge = merge;
        exports.min = min;
        exports.pairs = pairs;
        exports.permute = permute;
        exports.quantile = quantile;
        exports.range = range;
        exports.scan = scan;
        exports.shuffle = shuffle;
        exports.sum = sum;
        exports.ticks = ticks;
        exports.tickStep = tickStep;
        exports.transpose = transpose;
        exports.variance = variance;
        exports.zip = zip;
      });
    })(d3Array, d3Array.exports);

    const {
      bisectRight
    } = d3Array.exports;
    const quincunx = (u, v, w, q) => {
      const n = u.length - 1;
      u[0] = 0;
      v[0] = 0;
      w[0] = 0;
      v[1] = v[1] / u[1];
      w[1] = w[1] / u[1];
      for (let i = 2; i < n; ++i) {
        u[i] = u[i] - u[i - 2] * w[i - 2] * w[i - 2] - u[i - 1] * v[i - 1] * v[i - 1];
        v[i] = (v[i] - u[i - 1] * v[i - 1] * w[i - 1]) / u[i];
        w[i] = w[i] / u[i];
      }
      for (let i = 2; i < n; ++i) {
        q[i] = q[i] - v[i - 1] * q[i - 1] - w[i - 2] * q[i - 2];
      }
      for (let i = 1; i < n; ++i) {
        q[i] = q[i] / u[i];
      }
      q[n - 2] = q[n - 2] - v[n - 2] * q[n - 1];
      for (let i = n - 3; i > 0; --i) {
        q[i] = q[i] - v[i] * q[i + 1] - w[i] * q[i + 2];
      }
    };
    const smoothingSpline = (x, y, sigma, lambda) => {
      const n = x.length - 1;
      const h = new Array(n + 1);
      const r = new Array(n + 1);
      const f = new Array(n + 1);
      const p = new Array(n + 1);
      const q = new Array(n + 1);
      const u = new Array(n + 1);
      const v = new Array(n + 1);
      const w = new Array(n + 1);
      const params = x.map(() => [0, 0, 0, 0]);
      params.pop();
      const mu = 2 * (1 - lambda) / (3 * lambda);
      for (let i = 0; i < n; ++i) {
        h[i] = x[i + 1] - x[i];
        r[i] = 3 / h[i];
      }
      q[0] = 0;
      for (let i = 1; i < n; ++i) {
        f[i] = -(r[i - 1] + r[i]);
        p[i] = 2 * (x[i + 1] - x[i - 1]);
        q[i] = 3 * (y[i + 1] - y[i]) / h[i] - 3 * (y[i] - y[i - 1]) / h[i - 1];
      }
      q[n] = 0;
      for (let i = 1; i < n; ++i) {
        u[i] = r[i - 1] * r[i - 1] * sigma[i - 1] + f[i] * f[i] * sigma[i] + r[i] * r[i] * sigma[i + 1];
        u[i] = mu * u[i] + p[i];
      }
      for (let i = 1; i < n - 1; ++i) {
        v[i] = f[i] * r[i] * sigma[i] + r[i] * f[i + 1] * sigma[i + 1];
        v[i] = mu * v[i] + h[i];
      }
      for (let i = 1; i < n - 2; ++i) {
        w[i] = mu * r[i] * r[i + 1] * sigma[i + 1];
      }
      quincunx(u, v, w, q);
      params[0][3] = y[0] - mu * r[0] * q[1] * sigma[0];
      params[1][3] = y[1] - mu * (f[1] * q[1] + r[1] * q[2]) * sigma[0];
      params[0][0] = q[1] / (3 * h[0]);
      params[0][1] = 0;
      params[0][2] = (params[1][3] - params[0][3]) / h[0] - q[1] * h[0] / 3;
      r[0] = 0;
      for (let i = 1; i < n; ++i) {
        params[i][0] = (q[i + 1] - q[i]) / (3 * h[i]);
        params[i][1] = q[i];
        params[i][2] = (q[i] + q[i - 1]) * h[i - 1] + params[i - 1][2];
        params[i][3] = r[i - 1] * q[i - 1] + f[i] * q[i] + r[i] * q[i + 1];
        params[i][3] = y[i] - mu * params[i][3] * sigma[i];
      }
      return params;
    };
    class SplineInterpolator {
      constructor(xIn, yIn, lambda = 1) {
        const indices = xIn.map((_, i) => i);
        indices.sort((i, j) => xIn[i] - xIn[j]);
        const x = indices.map(i => xIn[i]);
        const y = indices.map(i => yIn[i]);
        const n = indices.length;
        const sigma = indices.map(() => 1);
        this.n = n;
        this.x = x;
        this.y = y;
        this.params = smoothingSpline(x, y, sigma, lambda);
      }
      interpolate(v) {
        if (v === this.x[this.n - 1]) {
          return this.y[this.n - 1];
        }
        const i = Math.min(Math.max(0, bisectRight(this.x, v) - 1), this.n - 2);
        const [a, b, c, d] = this.params[i];
        v = v - this.x[i];
        return a * v * v * v + b * v * v + c * v + d;
      }
      max(step = 100) {
        const xStart = this.x[0];
        const xStop = this.x[this.n - 1];
        const delta = (xStop - xStart) / step;
        let maxValue = -Infinity;
        for (let i = 0, x = xStart; i < step; ++i, x += delta) {
          const y = this.interpolate(x);
          if (y > maxValue) {
            maxValue = y;
          }
        }
        return maxValue;
      }
      min(step = 100) {
        const xStart = this.x[0];
        const xStop = this.x[this.n - 1];
        const delta = (xStop - xStart) / step;
        let minValue = Infinity;
        for (let i = 0, x = xStart; i < step; ++i, x += delta) {
          const y = this.interpolate(x);
          if (y < minValue) {
            minValue = y;
          }
        }
        return minValue;
      }
      domain() {
        return [this.x[0], this.x[this.x.length - 1]];
      }
      range() {
        return [this.min(), this.max()];
      }
      curve(nInterval, domain = null) {
        domain = domain || this.domain();
        const delta = (domain[1] - domain[0]) / (nInterval - 1);
        const vals = new Array(nInterval);
        for (let i = 0; i < nInterval; ++i) {
          const x = delta * i + domain[0];
          vals[i] = [x, this.interpolate(x)];
        }
        return vals;
      }
    }
    var splineInterpolator = SplineInterpolator;
    var SplineInterpolator$1 = splineInterpolator;

    /**
     * Create an array with numbers between "from" and "to" of length "length"
     *
     * @param options - options
     * @return - array of distributed numbers between "from" and "to"
     */
    function createFromToArray(options = {}) {
      let {
        from = 0,
        to = 1,
        length = 1000,
        includeFrom = true,
        includeTo = true,
        distribution = 'uniform'
      } = options;
      const array = new Float64Array(length);
      let div = length;
      if (includeFrom && includeTo) {
        div = length - 1;
      } else if (!includeFrom && includeTo || includeFrom && !includeTo) {
        div = length;
      } else if (!includeFrom && !includeTo) {
        div = length + 1;
      }
      let delta = (to - from) / div;
      if (distribution === 'uniform') {
        if (includeFrom) {
          let index = 0;
          while (index < length) {
            array[index] = from + delta * index;
            index++;
          }
        } else {
          let index = 0;
          while (index < length) {
            array[index] = from + delta * (index + 1);
            index++;
          }
        }
      } else if (distribution === 'log') {
        let base = (to / from) ** (1 / div);
        let firstExponent = Math.log(from) / Math.log(base);
        if (includeFrom) {
          let index = 0;
          while (index < length) {
            array[index] = base ** (firstExponent + index);
            index++;
          }
        } else {
          let index = 0;
          while (index < length) {
            array[index] = base ** (firstExponent + index + 1);
            index++;
          }
        }
      } else {
        throw new Error('Please choose for the distribution either uniform or log. By default the distribution chosen is uniform.');
      }
      return array;
    }

    /* eslint-disable @typescript-eslint/no-loss-of-precision */
    /*
    Adapted from: https://github.com/compute-io/erfcinv/blob/aa116e23883839359e310ad41a7c42f72815fc1e/lib/number.js

    The MIT License (MIT)

    Copyright (c) 2014-2015 The Compute.io Authors. All rights reserved.

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.


    Boost Software License - Version 1.0 - August 17th, 2003

    Permission is hereby granted, free of charge, to any person or organization obtaining a copy of the software and accompanying documentation covered by this license (the "Software") to use, reproduce, display, distribute, execute, and transmit the Software, and to prepare derivative works of the Software, and to permit third-parties to whom the Software is furnished to do so, all subject to the following:

    The copyright notices in the Software and this entire statement, including the above license grant, this restriction and the following disclaimer, must be included in all copies of the Software, in whole or in part, and all derivative works of the Software, unless such copies or derivative works are solely in the form of machine-executable object code generated by a source language processor.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
    */
    // Coefficients for erfcinv on [0, 0.5]:
    const Y1 = 8.91314744949340820313e-2;
    const P1 = [-5.38772965071242932965e-3, 8.22687874676915743155e-3, 2.19878681111168899165e-2, -3.65637971411762664006e-2, -1.26926147662974029034e-2, 3.34806625409744615033e-2, -8.36874819741736770379e-3, -5.08781949658280665617e-4];
    const Q1 = [8.86216390456424707504e-4, -2.33393759374190016776e-3, 7.95283687341571680018e-2, -5.27396382340099713954e-2, -7.1228902341542847553e-1, 6.62328840472002992063e-1, 1.56221558398423026363, -1.56574558234175846809, -9.70005043303290640362e-1, 1];
    // Coefficients for erfcinv for 0.5 > 1-x >= 0:
    const Y2 = 2.249481201171875;
    const P2 = [-3.67192254707729348546, 2.11294655448340526258e1, 1.7445385985570866523e1, -4.46382324441786960818e1, -1.88510648058714251895e1, 1.76447298408374015486e1, 8.37050328343119927838, 1.05264680699391713268e-1, -2.02433508355938759655e-1];
    const Q2 = [1.72114765761200282724, -2.26436933413139721736e1, 1.08268667355460159008e1, 4.85609213108739935468e1, -2.01432634680485188801e1, -2.86608180499800029974e1, 3.9713437953343869095, 6.24264124854247537712, 1];
    // Coefficients for erfcinv for sqrt( -log(1-x)):
    const Y3 = 8.07220458984375e-1;
    const P3 = [-6.81149956853776992068e-10, 2.85225331782217055858e-8, -6.79465575181126350155e-7, 2.14558995388805277169e-3, 2.90157910005329060432e-2, 1.42869534408157156766e-1, 3.37785538912035898924e-1, 3.87079738972604337464e-1, 1.17030156341995252019e-1, -1.63794047193317060787e-1, -1.31102781679951906451e-1];
    const Q3 = [1.105924229346489121e-2, 1.52264338295331783612e-1, 8.48854343457902036425e-1, 2.59301921623620271374, 4.77846592945843778382, 5.38168345707006855425, 3.46625407242567245975, 1];
    const Y4 = 9.3995571136474609375e-1;
    const P4 = [2.66339227425782031962e-12, -2.30404776911882601748e-10, 4.60469890584317994083e-6, 1.57544617424960554631e-4, 1.87123492819559223345e-3, 9.50804701325919603619e-3, 1.85573306514231072324e-2, -2.22426529213447927281e-3, -3.50353787183177984712e-2];
    const Q4 = [7.64675292302794483503e-5, 2.63861676657015992959e-3, 3.41589143670947727934e-2, 2.20091105764131249824e-1, 7.62059164553623404043e-1, 1.3653349817554063097, 1];
    const Y5 = 9.8362827301025390625e-1;
    const P5 = [9.9055709973310326855e-17, -2.81128735628831791805e-14, 4.62596163522878599135e-9, 4.49696789927706453732e-7, 1.49624783758342370182e-5, 2.09386317487588078668e-4, 1.05628862152492910091e-3, -1.12951438745580278863e-3, -1.67431005076633737133e-2];
    const Q5 = [2.82243172016108031869e-7, 2.75335474764726041141e-5, 9.64011807005165528527e-4, 1.60746087093676504695e-2, 1.38151865749083321638e-1, 5.91429344886417493481e-1, 1];
    /**
     * Polyval.
     *
     * @param c - Array of Number.
     * @param x - Number.
     * @returns Number.
     */
    function polyval(c, x) {
      let p = 0;
      for (const coef of c) {
        p = p * x + coef;
      }
      return p;
    }
    /**
     * Calculates a rational approximation.
     *
     * @private
     * @param x - Number.
     * @param v - Number.
     * @param P - Array of polynomial coefficients.
     * @param Q - Array of polynomial coefficients.
     * @param Y - Number.
     * @returns Rational approximation.
     */
    function calc(x, v, P, Q, Y) {
      const s = x - v;
      const r = polyval(P, s) / polyval(Q, s);
      return Y * x + r * x;
    }
    /**
     * Evaluates the complementary inverse error function for an input value.
     *
     * @private
     * @param x - Input value.
     * @returns Evaluated complementary inverse error function.
     */
    function erfcinv(x) {
      let sign = false;
      let val;
      let q;
      let g;
      let r;
      // [1] Special cases...
      // NaN:
      if (Number.isNaN(x)) {
        return Number.NaN;
      }
      // x not on the interval: [0,2]
      if (x < 0 || x > 2) {
        throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${x}\`.`);
      }
      if (x === 0) {
        return Number.POSITIVE_INFINITY;
      }
      if (x === 2) {
        return Number.NEGATIVE_INFINITY;
      }
      if (x === 1) {
        return 0;
      }
      // [2] Get the sign and make use of `erfc` reflection formula: `erfc(-z)=2 - erfc(z)`...
      if (x > 1) {
        q = 2 - x;
        x = 1 - q;
        sign = true;
      } else {
        q = x;
        x = 1 - x;
      }
      // [3] |x| <= 0.5
      if (x <= 0.5) {
        g = x * (x + 10);
        r = polyval(P1, x) / polyval(Q1, x);
        val = g * Y1 + g * r;
        return sign ? -val : val;
      }
      // [4] 1-|x| >= 0.25
      if (q >= 0.25) {
        g = Math.sqrt(-2 * Math.log(q));
        q = q - 0.25;
        r = polyval(P2, q) / polyval(Q2, q);
        val = g / (Y2 + r);
        return sign ? -val : val;
      }
      q = Math.sqrt(-Math.log(q));
      // [5] q < 3
      if (q < 3) {
        return calc(q, 1.125, P3, Q3, Y3);
      }
      // [6] q < 6
      if (q < 6) {
        return calc(q, 3, P4, Q4, Y4);
      }
      // Note that the smallest number in JavaScript is 5e-324. Math.sqrt( -Math.log( 5e-324 ) ) ~27.2844
      return calc(q, 6, P5, Q5, Y5);
      // Note that in the boost library, they are able to go to much smaller values, as 128 bit long doubles support ~1e-5000; something which JavaScript does not natively support.
    }

    /**
     * RayleighCdf.
     *
     * @param x - data
     * @param sigma - standard deviation
     * @returns - rayleigh cdf
     */
    function rayleighCdf(x, sigma = 1) {
      if (x < 0) {
        return 0;
      }
      return -Math.expm1(-Math.pow(x, 2) / (2 * Math.pow(sigma, 2)));
    }

    /**
     * Determine noise level by san plot methodology (https://doi.org/10.1002/mrc.4882)
     *
     * @param array - real or magnitude spectra data.
     * @param options - options
     * @returns noise level
     */
    function xNoiseSanPlot(array, options = {}) {
      const {
        mask,
        cutOff,
        refine = true,
        magnitudeMode = false,
        scaleFactor = 1,
        factorStd = 5,
        fixOffset = true
      } = options;
      let input;
      if (Array.isArray(mask) && mask.length === array.length) {
        input = new Float64Array(array.filter((_e, i) => !mask[i]));
      } else {
        input = new Float64Array(array);
      }
      if (scaleFactor > 1) {
        for (let i = 0; i < input.length; i++) {
          input[i] *= scaleFactor;
        }
      }
      input = input.sort().reverse();
      if (fixOffset && !magnitudeMode) {
        let medianIndex = Math.floor(input.length / 2);
        let median = 0.5 * (input[medianIndex] + input[medianIndex + 1]);
        for (let i = 0; i < input.length; i++) {
          input[i] -= median;
        }
      }
      let firstNegativeValueIndex = input[input.length - 1] >= 0 ? input.length : input.findIndex(e => e < 0);
      let lastPositiveValueIndex = firstNegativeValueIndex - 1;
      for (let i = lastPositiveValueIndex; i >= 0; i--) {
        if (input[i] > 0) {
          lastPositiveValueIndex = i;
          break;
        }
      }
      let signPositive = input.slice(0, lastPositiveValueIndex + 1);
      let signNegative = input.slice(firstNegativeValueIndex);
      let cutOffDist = cutOff || determineCutOff(signPositive, {
        magnitudeMode
      });
      let pIndex = Math.floor(signPositive.length * cutOffDist);
      let initialNoiseLevelPositive = signPositive[pIndex];
      let skyPoint = signPositive[0];
      let initialNoiseLevelNegative;
      if (signNegative.length > 0) {
        let nIndex = Math.floor(signNegative.length * (1 - cutOffDist));
        initialNoiseLevelNegative = -1 * signNegative[nIndex];
      } else {
        initialNoiseLevelNegative = 0;
      }
      let noiseLevelPositive = initialNoiseLevelPositive;
      let noiseLevelNegative = initialNoiseLevelNegative;
      let cloneSignPositive = signPositive.slice();
      let cloneSignNegative = signNegative.slice();
      let cutOffSignalsIndexPlus = 0;
      let cutOffSignalsIndexNeg = 2;
      if (refine) {
        let cutOffSignals = noiseLevelPositive * factorStd;
        cutOffSignalsIndexPlus = signPositive.findIndex(e => e < cutOffSignals);
        if (cutOffSignalsIndexPlus > -1) {
          cloneSignPositive = signPositive.slice(cutOffSignalsIndexPlus);
          noiseLevelPositive = cloneSignPositive[Math.floor(cloneSignPositive.length * cutOffDist)];
        }
        cutOffSignals = noiseLevelNegative * factorStd;
        cutOffSignalsIndexNeg = signNegative.findIndex(e => e < cutOffSignals);
        if (cutOffSignalsIndexNeg > -1) {
          cloneSignNegative = signNegative.slice(cutOffSignalsIndexNeg);
          noiseLevelNegative = cloneSignPositive[Math.floor(cloneSignNegative.length * (1 - cutOffDist))];
        }
      }
      let correctionFactor = -simpleNormInv(cutOffDist / 2, {
        magnitudeMode
      });
      initialNoiseLevelPositive = initialNoiseLevelPositive / correctionFactor;
      initialNoiseLevelNegative = initialNoiseLevelNegative / correctionFactor;
      let effectiveCutOffDist, refinedCorrectionFactor;
      if (refine && cutOffSignalsIndexPlus > -1) {
        effectiveCutOffDist = (cutOffDist * cloneSignPositive.length + cutOffSignalsIndexPlus) / (cloneSignPositive.length + cutOffSignalsIndexPlus);
        refinedCorrectionFactor = -1 * simpleNormInv(effectiveCutOffDist / 2, {
          magnitudeMode
        });
        noiseLevelPositive /= refinedCorrectionFactor;
        if (cutOffSignalsIndexNeg > -1) {
          effectiveCutOffDist = (cutOffDist * cloneSignNegative.length + cutOffSignalsIndexNeg) / (cloneSignNegative.length + cutOffSignalsIndexNeg);
          refinedCorrectionFactor = -1 * simpleNormInv(effectiveCutOffDist / 2, {
            magnitudeMode
          });
          if (noiseLevelNegative !== 0) {
            noiseLevelNegative /= refinedCorrectionFactor;
          }
        }
      } else {
        noiseLevelPositive /= correctionFactor;
        noiseLevelNegative /= correctionFactor;
      }
      return {
        positive: noiseLevelPositive,
        negative: noiseLevelNegative,
        snr: skyPoint / noiseLevelPositive,
        sanplot: generateSanPlot(input, {
          fromTo: {
            positive: {
              from: 0,
              to: lastPositiveValueIndex
            },
            negative: {
              from: firstNegativeValueIndex,
              to: input.length
            }
          }
        })
      };
    }
    /**
     * DetermineCutOff.
     *
     * @param signPositive - Array of numbers.
     * @param [options = {}] - Options.
     * @param [options.mask] - Boolean array to filter data, if the i-th element is true then the i-th element of the distribution will be ignored.
     * @param [options.scaleFactor=1] - Factor to scale the data input[i]*=scaleFactor.
     * @param [options.cutOff] - Percent of positive signal distribution where the noise level will be determined, if it is not defined the program calculate it.
     * @param [options.factorStd=5] - Factor times std to determine what will be marked as signals.
     * @param [options.refine=true] - If true the noise level will be recalculated get out the signals using factorStd.
     * @param [options.fixOffset=true] - If the baseline is correct, the midpoint of distribution should be zero. If true, the distribution will be centered.
     * @param [options.logBaseY=2] - Log scale to apply in the intensity axis in order to avoid big numbers.
     * @param options.magnitudeMode -
     * @param options.considerList -
     * @param options.considerList.from -
     * @param options.considerList.step -
     * @param options.considerList.to -
     * @param options.fromTo -
     * @returns Result.
     */
    function determineCutOff(signPositive, options = {}) {
      let {
        magnitudeMode = false,
        considerList = {
          from: 0.5,
          step: 0.1,
          to: 0.9
        }
      } = options;
      //generate a list of values for
      let cutOff = [];
      let indexMax = signPositive.length - 1;
      for (let i = 0.01; i <= 0.99; i += 0.01) {
        let index = Math.round(indexMax * i);
        let value = -signPositive[index] / simpleNormInv([i / 2], {
          magnitudeMode
        });
        cutOff.push([i, value]);
      }
      let minKi = Number.MAX_SAFE_INTEGER;
      let {
        from,
        to,
        step
      } = considerList;
      let delta = step / 2;
      let whereToCutStat = 0.5;
      for (let i = from; i <= to; i += step) {
        let floor = i - delta;
        let top = i + delta;
        let elementsOfCutOff = cutOff.filter(e => e[0] < top && e[0] > floor);
        let averageValue = elementsOfCutOff.reduce((a, b) => a + Math.abs(b[1]), 0);
        let kiSqrt = 0;
        for (const element of elementsOfCutOff) {
          kiSqrt += Math.pow(element[1] - averageValue, 2);
        }
        if (kiSqrt < minKi) {
          minKi = kiSqrt;
          whereToCutStat = i;
        }
      }
      return whereToCutStat;
    }
    /**
     * SimpleNormInvs.
     *
     * @param data - Data array.
     * @param [options = {}] - Options.
     * @param [options.mask] - Boolean array to filter data, if the i-th element is true then the i-th element of the distribution will be ignored.
     * @param [options.scaleFactor=1] - Factor to scale the data input[i]*=scaleFactor.
     * @param [options.cutOff] - Percent of positive signal distribution where the noise level will be determined, if it is not defined the program calculate it.
     * @param [options.factorStd=5] - Factor times std to determine what will be marked as signals.
     * @param [options.refine=true] - If true the noise level will be recalculated get out the signals using factorStd.
     * @param [options.fixOffset=true] - If the baseline is correct, the midpoint of distribution should be zero. If true, the distribution will be centered.
     * @param [options.logBaseY=2] - Log scale to apply in the intensity axis in order to avoid big numbers.
     * @param options.magnitudeMode -
     * @param options.considerList -
     * @param options.considerList.from -
     * @param options.considerList.step -
     * @param options.considerList.to -
     * @param options.fromTo -
     * @returns Result.
     */
    function simpleNormInv(data, options = {}) {
      const {
        magnitudeMode = false
      } = options;
      if (!Array.isArray(data)) data = [data];
      let from = 0;
      let to = 2;
      let step = 0.01;
      let xTraining = Array.from(createArray(from, to, step));
      let result = new Float64Array(data.length);
      let yTraining = new Float64Array(xTraining.length);
      if (magnitudeMode) {
        let factor = 1;
        for (let i = 0; i < yTraining.length; i++) {
          let finalInput = xTraining[i] * factor;
          yTraining[i] = 1 - rayleighCdf(finalInput);
        }
        let interp = new SplineInterpolator$1(xTraining, yTraining);
        for (let i = 0; i < result.length; i++) {
          let yValue = 2 * data[i];
          result[i] = -1 * interp.interpolate(yValue);
        }
      } else {
        for (let i = 0; i < result.length; i++) {
          result[i] = -1 * Math.SQRT2 * erfcinv(2 * data[i]);
        }
      }
      return result.length === 1 ? result[0] : result;
    }
    /**
     * CreateArray.
     *
     * @param from - From.
     * @param to - To.
     * @param step - Step.
     * @returns Array of results.
     */
    function createArray(from, to, step) {
      // Changed Array to Float64Array
      let result = new Float64Array(Math.abs((from - to) / step + 1));
      for (let i = 0; i < result.length; i++) {
        result[i] = from + i * step;
      }
      return result;
    }
    /**
     * GenerateSanPlot.
     *
     * @param array - Array.
     * @param [options = {}] - Options.
     * @param [options.mask] - Boolean array to filter data, if the i-th element is true then the i-th element of the distribution will be ignored.
     * @param [options.scaleFactor=1] - Factor to scale the data input[i]*=scaleFactor.
     * @param [options.cutOff] - Percent of positive signal distribution where the noise level will be determined, if it is not defined the program calculate it.
     * @param [options.factorStd=5] - Factor times std to determine what will be marked as signals.
     * @param [options.refine=true] - If true the noise level will be recalculated get out the signals using factorStd.
     * @param [options.fixOffset=true] - If the baseline is correct, the midpoint of distribution should be zero. If true, the distribution will be centered.
     * @param [options.logBaseY=2] - Log scale to apply in the intensity axis in order to avoid big numbers.
     * @param options.magnitudeMode -
     * @param options.considerList -
     * @param options.considerList.from -
     * @param options.considerList.step -
     * @param options.considerList.to -
     * @param options.fromTo -
     * @returns Results.
     */
    function generateSanPlot(array, options = {}) {
      const {
        fromTo,
        logBaseY = 2
      } = options;
      let sanplot = {};
      for (let key in fromTo) {
        let {
          from,
          to
        } = fromTo[key];
        sanplot[key] = from !== to ? scale(array.slice(from, to), {
          logBaseY
        }) : {
          x: [],
          y: []
        };
        if (key === 'negative') {
          sanplot[key].y.reverse();
        }
      }
      return sanplot;
    }
    /**
     * Scale.
     *
     * @param array - Array.
     * @param [options = {}] - Options.
     * @param [options.mask] - Boolean array to filter data, if the i-th element is true then the i-th element of the distribution will be ignored.
     * @param [options.scaleFactor=1] - Factor to scale the data input[i]*=scaleFactor.
     * @param [options.cutOff] - Percent of positive signal distribution where the noise level will be determined, if it is not defined the program calculate it.
     * @param [options.factorStd=5] - Factor times std to determine what will be marked as signals.
     * @param [options.refine=true] - If true the noise level will be recalculated get out the signals using factorStd.
     * @param [options.fixOffset=true] - If the baseline is correct, the midpoint of distribution should be zero. If true, the distribution will be centered.
     * @param [options.logBaseY=2] - Log scale to apply in the intensity axis in order to avoid big numbers.
     * @param options.magnitudeMode -
     * @param options.considerList -
     * @param options.considerList.from -
     * @param options.considerList.step -
     * @param options.considerList.to -
     * @param options.fromTo -
     * @returns Results.
     */
    function scale(array, options = {}) {
      const {
        log10,
        abs
      } = Math;
      const {
        logBaseY
      } = options;
      if (logBaseY) {
        array = array.slice();
        const logOfBase = log10(logBaseY);
        for (let i = 0; i < array.length; i++) {
          array[i] = log10(abs(array[i])) / logOfBase;
        }
      }
      const xAxis = createFromToArray({
        from: 0,
        to: array.length - 1,
        length: array.length
      });
      return {
        x: xAxis,
        y: array
      };
    }

    /**
     * Phase correction filter
     *
     * @param data - complex spectrum
     * @param phi0 - Angle in radians for zero order phase correction
     * @param phi1 - Angle in radians for first order phase correction
     * @returns - returns a new object {re:[], im:[]}
     */
    function reimPhaseCorrection(data, phi0 = 0, phi1 = 0, options = {}) {
      const {
        reverse = false
      } = options;
      phi0 = Number.isFinite(phi0) ? phi0 : 0;
      phi1 = Number.isFinite(phi1) ? phi1 : 0;
      const re = data.re;
      const im = data.im;
      const length = data.re.length;
      let firstAngle = phi0;
      let delta = phi1 / length;
      if (reverse) {
        delta *= -1;
        firstAngle += phi1;
      }
      const alpha = 2 * Math.pow(Math.sin(delta / 2), 2);
      const beta = Math.sin(delta);
      let cosTheta = Math.cos(firstAngle);
      let sinTheta = Math.sin(firstAngle);
      const newRe = new Float64Array(length);
      const newIm = new Float64Array(length);
      for (let i = 0; i < length; i++) {
        newRe[i] = re[i] * cosTheta - im[i] * sinTheta;
        newIm[i] = im[i] * cosTheta + re[i] * sinTheta;
        // calculate angles i+1 from i
        let newCosTheta = cosTheta - (alpha * cosTheta + beta * sinTheta);
        let newSinTheta = sinTheta - (alpha * sinTheta - beta * cosTheta);
        cosTheta = newCosTheta;
        sinTheta = newSinTheta;
      }
      return {
        re: newRe,
        im: newIm
      };
    }

    /**
     * Implementation of the algorithm for automatic phase correction: A robust, general automatic phase
     * correction algorithm for high-resolution NMR data. 10.1002/mrc.4586
     *
     * @param data - complex spectrum
     * @param options - options
     */
    function reimAutoPhaseCorrection(data, options = {}) {
      const {
        re,
        im
      } = data;
      const length = re.length;
      const {
        magnitudeMode = true,
        minRegSize = 30,
        factorNoise = 3,
        maxDistanceToJoin = 256,
        reverse = false
      } = options;
      let magnitudeData = magnitudeMode ? reimAbsolute(data) : re;
      let ds = holoborodko(magnitudeData);
      let peaksDs = robustBaseLineRegionsDetection(ds, {
        maxDistanceToJoin,
        magnitudeMode,
        factorNoise
      });
      let peaksSp = robustBaseLineRegionsDetection(magnitudeData, {
        maxDistanceToJoin,
        magnitudeMode,
        factorNoise
      });
      let finalPeaks = new Uint8Array(length);
      for (let i = 0; i < length; i++) {
        finalPeaks[i] = peaksSp[i] && peaksDs[i];
      }
      // Once the regions are detected, we auto phase each of them separately.
      // This part can be put inside a function
      const indexMask = reverse ? i => length - i : i => i;
      let i = -1;
      let x0 = 0;
      let res = [];
      while (i < length) {
        //phase first region
        let reTmp = [];
        let imTmp = [];
        //Look for the first 1 in the array
        while (!finalPeaks[++i] && i < length) {
          //Add some extra points(0.1 ppm) at rigth and left sides of the region.
          x0 = indexMask(i);
        }
        for (; finalPeaks[i] && i < length; i++) {
          reTmp.push(re[i]);
          imTmp.push(im[i]);
          i++;
        }
        if (reTmp.length > minRegSize) {
          res.push(autoPhaseRegion(reTmp, imTmp, x0));
        }
      }
      // Still some corrections needed. In the paper they remove the outlayers interatively
      // until they can perform a regression witout bad points. Can someone help here?
      let [ph1, ph0] = weightedLinearRegression(res.map(r => r.x0 / length), res.map(r => r.ph0), res.map(r => r.area / 1e11));
      let phased = reimPhaseCorrection({
        re,
        im
      }, ph0 * Math.PI / 180, ph1 * Math.PI / 180, {
        reverse
      });
      return {
        data: phased,
        ph0,
        ph1
      };
    }
    /**
     * AutoPhaseRegion.
     *
     * @param re - Array of Number.
     * @param im - Array of Number.
     * @param x0 - Number.
     * @returns Region.
     */
    function autoPhaseRegion(re, im, x0) {
      let start = -180;
      let stop = 180;
      let nSteps = 6;
      let maxSteps = 5;
      let bestAng = 0;
      let minArea = Number.MAX_SAFE_INTEGER;
      while (maxSteps > 0) {
        let dAng = (stop - start) / (nSteps + 1);
        for (let i = start; i <= stop; i += dAng) {
          let phased = reimPhaseCorrection({
            re,
            im
          }, toRadians(i), 0);
          let negArea = getNegArea(phased.re);
          if (negArea < minArea) {
            [minArea, bestAng] = [negArea, i];
          }
        }
        start = bestAng - dAng;
        stop = bestAng + dAng;
        maxSteps--;
      }
      // Calculate the area for the best angle
      let phased = reimPhaseCorrection({
        re,
        im
      }, toRadians(bestAng), 0);
      let area = 0;
      let sumX = 0;
      for (let j = 0; j < re.length; j++) {
        area += phased.re[j];
        sumX += phased.re[j] * (j + x0);
      }
      return {
        ph0: bestAng,
        area,
        x0: sumX / area
      };
    }
    /**
     * Holoborodko.
     *
     * @param s - Array of float.
     * @returns Array of float.
     */
    function holoborodko(s) {
      let dk = new Float64Array(s.length);
      for (let i = 5; i < s.length - 5; i++) {
        dk[i] = (42 * (s[i + 1] - s[i - 1]) + 48 * (s[i + 2] - s[i - 2]) + 27 * (s[i + 3] + s[i - 3]) + 8 * (s[i + 4] - s[i - 4]) + s[i + 5] - s[i - 5]) / 512;
      }
      //Fill the borders
      for (let i = 0; i < 5; i++) {
        dk[i] = dk[5];
        dk[s.length - i - 1] = dk[s.length - 6];
      }
      return dk;
    }
    /**
     * RobustBaseLineRegionsDetection.
     *
     * @param s
     * @param options
     * @param options.magnitudeMode
     * @param options.maxDistanceToJoin
     * @param options.factorNoise
     */
    function robustBaseLineRegionsDetection(s, options) {
      const {
        maxDistanceToJoin,
        magnitudeMode,
        factorNoise
      } = options;
      let mask = new Uint8Array(s.length);
      for (let i = 0; i < s.length; i++) {
        mask[i] = 0;
      }
      let change = true;
      while (change) {
        let noiseLevel = xNoiseSanPlot(s, {
          magnitudeMode
        });
        let cutOff = factorNoise * noiseLevel.positive;
        change = false;
        for (let i = 0; i < s.length; i++) {
          if (Math.abs(s[i]) > cutOff && !mask[i]) {
            change = true;
            mask[i] = 1;
          }
        }
      }
      // Clean up mask by merging peaks blocks, separated by just a few points(4??).
      let count = 0;
      let prev = 0;
      for (let i = 0; i < s.length; i++) {
        if (!mask[i]) {
          count++;
        } else {
          if (count < maxDistanceToJoin) {
            for (let j = 0; j <= count; j++) {
              mask[prev + j] = 1;
            }
          }
          while (mask[++i] && i < s.length);
          prev = i;
          count = 0;
        }
      }
      return mask;
    }
    /**
     * WeightedLinearRegression.
     *
     * @param x
     * @param y
     * @param w
     */
    function weightedLinearRegression(x, y, w) {
      let sxtw = 0;
      let swx = 0;
      let sw = 0;
      let sxtwy = 0;
      let swy = 0;
      for (let i = 0; i < x.length; i++) {
        sxtw += x[i] * x[i] * w[i];
        swx += x[i] * w[i];
        sw += w[i];
        sxtwy += x[i] * w[i] * y[i];
        swy += w[i] * y[i];
      }
      /* Just to know what is the matrix system that we solve
       let Mx=[[sxtw, swx], [swx, sw]];
       let My=[[sxtwy], [swy]];
      */
      //Mx inverse
      let detMx = sxtw * sw - swx * swx;
      let inMx = [[sw / detMx, -swx / detMx], [-swx / detMx, sxtw / detMx]];
      return [inMx[0][0] * sxtwy + inMx[0][1] * swy, inMx[1][0] * sxtwy + inMx[1][1] * swy];
    }
    const toRadians = degree => degree * Math.PI / 180;
    const getNegArea = data => {
      let area = 0;
      for (let element of data) {
        if (element < 0) area -= element;
      }
      return area;
    };

    function FFT$1(size) {
      this.size = size | 0;
      if (this.size <= 1 || (this.size & this.size - 1) !== 0) throw new Error('FFT size must be a power of two and bigger than 1');
      this._csize = size << 1;

      // NOTE: Use of `var` is intentional for old V8 versions
      var table = new Array(this.size * 2);
      for (var i = 0; i < table.length; i += 2) {
        const angle = Math.PI * i / this.size;
        table[i] = Math.cos(angle);
        table[i + 1] = -Math.sin(angle);
      }
      this.table = table;

      // Find size's power of two
      var power = 0;
      for (var t = 1; this.size > t; t <<= 1) power++;

      // Calculate initial step's width:
      //   * If we are full radix-4 - it is 2x smaller to give inital len=8
      //   * Otherwise it is the same as `power` to give len=4
      this._width = power % 2 === 0 ? power - 1 : power;

      // Pre-compute bit-reversal patterns
      this._bitrev = new Array(1 << this._width);
      for (var j = 0; j < this._bitrev.length; j++) {
        this._bitrev[j] = 0;
        for (var shift = 0; shift < this._width; shift += 2) {
          var revShift = this._width - shift - 2;
          this._bitrev[j] |= (j >>> shift & 3) << revShift;
        }
      }
      this._out = null;
      this._data = null;
      this._inv = 0;
    }
    var fft$1 = FFT$1;
    FFT$1.prototype.fromComplexArray = function fromComplexArray(complex, storage) {
      var res = storage || new Array(complex.length >>> 1);
      for (var i = 0; i < complex.length; i += 2) res[i >>> 1] = complex[i];
      return res;
    };
    FFT$1.prototype.createComplexArray = function createComplexArray() {
      const res = new Array(this._csize);
      for (var i = 0; i < res.length; i++) res[i] = 0;
      return res;
    };
    FFT$1.prototype.toComplexArray = function toComplexArray(input, storage) {
      var res = storage || this.createComplexArray();
      for (var i = 0; i < res.length; i += 2) {
        res[i] = input[i >>> 1];
        res[i + 1] = 0;
      }
      return res;
    };
    FFT$1.prototype.completeSpectrum = function completeSpectrum(spectrum) {
      var size = this._csize;
      var half = size >>> 1;
      for (var i = 2; i < half; i += 2) {
        spectrum[size - i] = spectrum[i];
        spectrum[size - i + 1] = -spectrum[i + 1];
      }
    };
    FFT$1.prototype.transform = function transform(out, data) {
      if (out === data) throw new Error('Input and output buffers must be different');
      this._out = out;
      this._data = data;
      this._inv = 0;
      this._transform4();
      this._out = null;
      this._data = null;
    };
    FFT$1.prototype.realTransform = function realTransform(out, data) {
      if (out === data) throw new Error('Input and output buffers must be different');
      this._out = out;
      this._data = data;
      this._inv = 0;
      this._realTransform4();
      this._out = null;
      this._data = null;
    };
    FFT$1.prototype.inverseTransform = function inverseTransform(out, data) {
      if (out === data) throw new Error('Input and output buffers must be different');
      this._out = out;
      this._data = data;
      this._inv = 1;
      this._transform4();
      for (var i = 0; i < out.length; i++) out[i] /= this.size;
      this._out = null;
      this._data = null;
    };

    // radix-4 implementation
    //
    // NOTE: Uses of `var` are intentional for older V8 version that do not
    // support both `let compound assignments` and `const phi`
    FFT$1.prototype._transform4 = function _transform4() {
      var out = this._out;
      var size = this._csize;

      // Initial step (permute and transform)
      var width = this._width;
      var step = 1 << width;
      var len = size / step << 1;
      var outOff;
      var t;
      var bitrev = this._bitrev;
      if (len === 4) {
        for (outOff = 0, t = 0; outOff < size; outOff += len, t++) {
          const off = bitrev[t];
          this._singleTransform2(outOff, off, step);
        }
      } else {
        // len === 8
        for (outOff = 0, t = 0; outOff < size; outOff += len, t++) {
          const off = bitrev[t];
          this._singleTransform4(outOff, off, step);
        }
      }

      // Loop through steps in decreasing order
      var inv = this._inv ? -1 : 1;
      var table = this.table;
      for (step >>= 2; step >= 2; step >>= 2) {
        len = size / step << 1;
        var quarterLen = len >>> 2;

        // Loop through offsets in the data
        for (outOff = 0; outOff < size; outOff += len) {
          // Full case
          var limit = outOff + quarterLen;
          for (var i = outOff, k = 0; i < limit; i += 2, k += step) {
            const A = i;
            const B = A + quarterLen;
            const C = B + quarterLen;
            const D = C + quarterLen;

            // Original values
            const Ar = out[A];
            const Ai = out[A + 1];
            const Br = out[B];
            const Bi = out[B + 1];
            const Cr = out[C];
            const Ci = out[C + 1];
            const Dr = out[D];
            const Di = out[D + 1];

            // Middle values
            const MAr = Ar;
            const MAi = Ai;
            const tableBr = table[k];
            const tableBi = inv * table[k + 1];
            const MBr = Br * tableBr - Bi * tableBi;
            const MBi = Br * tableBi + Bi * tableBr;
            const tableCr = table[2 * k];
            const tableCi = inv * table[2 * k + 1];
            const MCr = Cr * tableCr - Ci * tableCi;
            const MCi = Cr * tableCi + Ci * tableCr;
            const tableDr = table[3 * k];
            const tableDi = inv * table[3 * k + 1];
            const MDr = Dr * tableDr - Di * tableDi;
            const MDi = Dr * tableDi + Di * tableDr;

            // Pre-Final values
            const T0r = MAr + MCr;
            const T0i = MAi + MCi;
            const T1r = MAr - MCr;
            const T1i = MAi - MCi;
            const T2r = MBr + MDr;
            const T2i = MBi + MDi;
            const T3r = inv * (MBr - MDr);
            const T3i = inv * (MBi - MDi);

            // Final values
            const FAr = T0r + T2r;
            const FAi = T0i + T2i;
            const FCr = T0r - T2r;
            const FCi = T0i - T2i;
            const FBr = T1r + T3i;
            const FBi = T1i - T3r;
            const FDr = T1r - T3i;
            const FDi = T1i + T3r;
            out[A] = FAr;
            out[A + 1] = FAi;
            out[B] = FBr;
            out[B + 1] = FBi;
            out[C] = FCr;
            out[C + 1] = FCi;
            out[D] = FDr;
            out[D + 1] = FDi;
          }
        }
      }
    };

    // radix-2 implementation
    //
    // NOTE: Only called for len=4
    FFT$1.prototype._singleTransform2 = function _singleTransform2(outOff, off, step) {
      const out = this._out;
      const data = this._data;
      const evenR = data[off];
      const evenI = data[off + 1];
      const oddR = data[off + step];
      const oddI = data[off + step + 1];
      const leftR = evenR + oddR;
      const leftI = evenI + oddI;
      const rightR = evenR - oddR;
      const rightI = evenI - oddI;
      out[outOff] = leftR;
      out[outOff + 1] = leftI;
      out[outOff + 2] = rightR;
      out[outOff + 3] = rightI;
    };

    // radix-4
    //
    // NOTE: Only called for len=8
    FFT$1.prototype._singleTransform4 = function _singleTransform4(outOff, off, step) {
      const out = this._out;
      const data = this._data;
      const inv = this._inv ? -1 : 1;
      const step2 = step * 2;
      const step3 = step * 3;

      // Original values
      const Ar = data[off];
      const Ai = data[off + 1];
      const Br = data[off + step];
      const Bi = data[off + step + 1];
      const Cr = data[off + step2];
      const Ci = data[off + step2 + 1];
      const Dr = data[off + step3];
      const Di = data[off + step3 + 1];

      // Pre-Final values
      const T0r = Ar + Cr;
      const T0i = Ai + Ci;
      const T1r = Ar - Cr;
      const T1i = Ai - Ci;
      const T2r = Br + Dr;
      const T2i = Bi + Di;
      const T3r = inv * (Br - Dr);
      const T3i = inv * (Bi - Di);

      // Final values
      const FAr = T0r + T2r;
      const FAi = T0i + T2i;
      const FBr = T1r + T3i;
      const FBi = T1i - T3r;
      const FCr = T0r - T2r;
      const FCi = T0i - T2i;
      const FDr = T1r - T3i;
      const FDi = T1i + T3r;
      out[outOff] = FAr;
      out[outOff + 1] = FAi;
      out[outOff + 2] = FBr;
      out[outOff + 3] = FBi;
      out[outOff + 4] = FCr;
      out[outOff + 5] = FCi;
      out[outOff + 6] = FDr;
      out[outOff + 7] = FDi;
    };

    // Real input radix-4 implementation
    FFT$1.prototype._realTransform4 = function _realTransform4() {
      var out = this._out;
      var size = this._csize;

      // Initial step (permute and transform)
      var width = this._width;
      var step = 1 << width;
      var len = size / step << 1;
      var outOff;
      var t;
      var bitrev = this._bitrev;
      if (len === 4) {
        for (outOff = 0, t = 0; outOff < size; outOff += len, t++) {
          const off = bitrev[t];
          this._singleRealTransform2(outOff, off >>> 1, step >>> 1);
        }
      } else {
        // len === 8
        for (outOff = 0, t = 0; outOff < size; outOff += len, t++) {
          const off = bitrev[t];
          this._singleRealTransform4(outOff, off >>> 1, step >>> 1);
        }
      }

      // Loop through steps in decreasing order
      var inv = this._inv ? -1 : 1;
      var table = this.table;
      for (step >>= 2; step >= 2; step >>= 2) {
        len = size / step << 1;
        var halfLen = len >>> 1;
        var quarterLen = halfLen >>> 1;
        var hquarterLen = quarterLen >>> 1;

        // Loop through offsets in the data
        for (outOff = 0; outOff < size; outOff += len) {
          for (var i = 0, k = 0; i <= hquarterLen; i += 2, k += step) {
            var A = outOff + i;
            var B = A + quarterLen;
            var C = B + quarterLen;
            var D = C + quarterLen;

            // Original values
            var Ar = out[A];
            var Ai = out[A + 1];
            var Br = out[B];
            var Bi = out[B + 1];
            var Cr = out[C];
            var Ci = out[C + 1];
            var Dr = out[D];
            var Di = out[D + 1];

            // Middle values
            var MAr = Ar;
            var MAi = Ai;
            var tableBr = table[k];
            var tableBi = inv * table[k + 1];
            var MBr = Br * tableBr - Bi * tableBi;
            var MBi = Br * tableBi + Bi * tableBr;
            var tableCr = table[2 * k];
            var tableCi = inv * table[2 * k + 1];
            var MCr = Cr * tableCr - Ci * tableCi;
            var MCi = Cr * tableCi + Ci * tableCr;
            var tableDr = table[3 * k];
            var tableDi = inv * table[3 * k + 1];
            var MDr = Dr * tableDr - Di * tableDi;
            var MDi = Dr * tableDi + Di * tableDr;

            // Pre-Final values
            var T0r = MAr + MCr;
            var T0i = MAi + MCi;
            var T1r = MAr - MCr;
            var T1i = MAi - MCi;
            var T2r = MBr + MDr;
            var T2i = MBi + MDi;
            var T3r = inv * (MBr - MDr);
            var T3i = inv * (MBi - MDi);

            // Final values
            var FAr = T0r + T2r;
            var FAi = T0i + T2i;
            var FBr = T1r + T3i;
            var FBi = T1i - T3r;
            out[A] = FAr;
            out[A + 1] = FAi;
            out[B] = FBr;
            out[B + 1] = FBi;

            // Output final middle point
            if (i === 0) {
              var FCr = T0r - T2r;
              var FCi = T0i - T2i;
              out[C] = FCr;
              out[C + 1] = FCi;
              continue;
            }

            // Do not overwrite ourselves
            if (i === hquarterLen) continue;

            // In the flipped case:
            // MAi = -MAi
            // MBr=-MBi, MBi=-MBr
            // MCr=-MCr
            // MDr=MDi, MDi=MDr
            var ST0r = T1r;
            var ST0i = -T1i;
            var ST1r = T0r;
            var ST1i = -T0i;
            var ST2r = -inv * T3i;
            var ST2i = -inv * T3r;
            var ST3r = -inv * T2i;
            var ST3i = -inv * T2r;
            var SFAr = ST0r + ST2r;
            var SFAi = ST0i + ST2i;
            var SFBr = ST1r + ST3i;
            var SFBi = ST1i - ST3r;
            var SA = outOff + quarterLen - i;
            var SB = outOff + halfLen - i;
            out[SA] = SFAr;
            out[SA + 1] = SFAi;
            out[SB] = SFBr;
            out[SB + 1] = SFBi;
          }
        }
      }
    };

    // radix-2 implementation
    //
    // NOTE: Only called for len=4
    FFT$1.prototype._singleRealTransform2 = function _singleRealTransform2(outOff, off, step) {
      const out = this._out;
      const data = this._data;
      const evenR = data[off];
      const oddR = data[off + step];
      const leftR = evenR + oddR;
      const rightR = evenR - oddR;
      out[outOff] = leftR;
      out[outOff + 1] = 0;
      out[outOff + 2] = rightR;
      out[outOff + 3] = 0;
    };

    // radix-4
    //
    // NOTE: Only called for len=8
    FFT$1.prototype._singleRealTransform4 = function _singleRealTransform4(outOff, off, step) {
      const out = this._out;
      const data = this._data;
      const inv = this._inv ? -1 : 1;
      const step2 = step * 2;
      const step3 = step * 3;

      // Original values
      const Ar = data[off];
      const Br = data[off + step];
      const Cr = data[off + step2];
      const Dr = data[off + step3];

      // Pre-Final values
      const T0r = Ar + Cr;
      const T1r = Ar - Cr;
      const T2r = Br + Dr;
      const T3r = inv * (Br - Dr);

      // Final values
      const FAr = T0r + T2r;
      const FBr = T1r;
      const FBi = -T3r;
      const FCr = T0r - T2r;
      const FDr = T1r;
      const FDi = T3r;
      out[outOff] = FAr;
      out[outOff + 1] = 0;
      out[outOff + 2] = FBr;
      out[outOff + 3] = FBi;
      out[outOff + 4] = FCr;
      out[outOff + 5] = 0;
      out[outOff + 6] = FDr;
      out[outOff + 7] = FDi;
    };
    var FFT$2 = fft$1;

    /**
     * This function performs a circular shift to an array
     * Positive values of shifts will shift to the right and negative values will do to the left
     *
     * @example xRotate([1,2,3,4],1) -> [4,1,2,3]
     * @example xRotate([1,2,3,4],-1) -> [2,3,4,1]
     * @param array - array
     * @param shift - shift
     * @returns - rotated array
     */
    function xRotate(array, shift) {
      shift = shift % array.length;
      if (shift < 0) shift += array.length;
      let result = new Float64Array(array.length);
      result.set(array.slice(array.length - shift));
      result.set(array.slice(0, array.length - shift), shift);
      return result;
    }

    /**
     * ReimFFT.
     *
     * @param data - complex spectrum
     * @param options - options.
     * @returns FFT of complex spectrum.
     */
    function reimFFT(data, options = {}) {
      const {
        inverse = false,
        applyZeroShift = false
      } = options;
      let {
        re,
        im
      } = data;
      const size = re.length;
      const csize = size << 1;
      let complexArray = new Float64Array(csize);
      for (let i = 0; i < csize; i += 2) {
        complexArray[i] = re[i >>> 1];
        complexArray[i + 1] = im[i >>> 1];
      }
      let fft = new FFT$2(size);
      let output = new Float64Array(csize);
      if (inverse) {
        if (applyZeroShift) complexArray = zeroShift(complexArray, true);
        fft.inverseTransform(output, complexArray);
      } else {
        fft.transform(output, complexArray);
        if (applyZeroShift) output = zeroShift(output);
      }
      let newRe = new Float64Array(size);
      let newIm = new Float64Array(size);
      for (let i = 0; i < csize; i += 2) {
        newRe[i >>> 1] = output[i];
        newIm[i >>> 1] = output[i + 1];
      }
      return {
        re: newRe,
        im: newIm
      };
    }
    const zeroShift = (data, inverse) => {
      let middle = inverse ? Math.ceil(data.length / 2) : Math.floor(data.length / 2);
      return xRotate(data, middle);
    };

    /**
     * This function returns an array with absolute values
     *
     * @param array - array of data
     * @returns - array with absolute values
     */
    function xAbsolute(array) {
      let tmpArray = array.slice();
      for (let i = 0; i < tmpArray.length; i++) {
        if (tmpArray[i] < 0) tmpArray[i] *= -1;
      }
      return tmpArray;
    }

    // eslint-disable-next-line @typescript-eslint/unbound-method
    const toString$2 = Object.prototype.toString;
    /**
     * Checks if an object is an instance of an Array (array or typed array, except those that contain bigint values).
     *
     * @param value - Object to check.
     * @returns True if the object is an array or a typed array.
     */
    function isAnyArray(value) {
      const tag = toString$2.call(value);
      return tag.endsWith('Array]') && !tag.includes('Big');
    }

    /**
     * Calculates the median of an array
     *
     * @param input - Array containing values
     * @returns - median
     */
    function xMedian(input) {
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      }
      if (input.length === 0) {
        throw new TypeError('input must not be empty');
      }
      const array = input.slice();
      let low = 0;
      let high = array.length - 1;
      let middle = 0;
      let currentLow = 0;
      let currentHigh = 0;
      let median = calcMiddle(low, high);
      while (true) {
        if (high <= low) {
          return array[median];
        }
        if (high === low + 1) {
          if (array[low] > array[high]) {
            swap(array, low, high);
          }
          return array[median];
        }
        // Find median of low, middle and high items; swap into position low
        middle = calcMiddle(low, high);
        if (array[middle] > array[high]) swap(array, middle, high);
        if (array[low] > array[high]) swap(array, low, high);
        if (array[middle] > array[low]) swap(array, middle, low);
        // Swap low item (now in position middle) into position (low+1)
        swap(array, middle, low + 1);
        // Nibble from each end towards middle, swapping items when stuck
        currentLow = low + 1;
        currentHigh = high;
        while (true) {
          do currentLow++; while (array[low] > array[currentLow]);
          do currentHigh--; while (array[currentHigh] > array[low]);
          if (currentHigh < currentLow) {
            break;
          }
          swap(array, currentLow, currentHigh);
        }
        // Swap middle item (in position low) back into correct position
        swap(array, low, currentHigh);
        // Re-set active partition
        if (currentHigh <= median) {
          low = currentLow;
        }
        if (currentHigh >= median) {
          high = currentHigh - 1;
        }
      }
    }
    function swap(array, i, j) {
      const temp = array[j];
      array[j] = array[i];
      array[i] = temp;
    }
    function calcMiddle(i, j) {
      return Math.floor((i + j) / 2);
    }

    /**
     * This function calculates the median after taking the reimAbsolute values of the points
     *
     * @param array - the array for which we want to calculate the absolute value
     * @returns - median
     */
    function xAbsoluteMedian(array) {
      return xMedian(xAbsolute(array));
    }

    /**
     * This function xAdd the first array by the second array or a constant value to each element of the first array
     *
     * @param array1 - the first array
     * @param array2 - the second array or number
     */
    function xAdd(array1, array2) {
      let isConstant = false;
      let constant = 0;
      if (isAnyArray(array2)) {
        if (array1.length !== array2.length) {
          throw new Error('xAdd: size of array1 and array2 must be identical');
        }
      } else {
        isConstant = true;
        constant = array2;
      }
      let array3 = new Float64Array(array1.length);
      if (isConstant) {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] + constant;
        }
      } else {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] + array2[i];
        }
      }
      return array3;
    }

    /**
     * Will apply a function on each element of the array described as a string
     * By default we will use as variable 'x'
     * In front of sequence of lowercase we will add 'Math.'. This allows to write
     * `sin(x) + cos(x)` and it will be replace internally by (x) => (Math.sin(x) + Math.cos(x))
     * @param array
     * @param options
     * @returns
     */
    function xApplyFunctionStr(array, options = {}) {
      const {
        variableLabel = 'x',
        fctString = variableLabel
      } = options;
      const fct = new Function(variableLabel, `return Number(${fctString.replace(/(?<before>^|\W)(?<after>[\da-z]{2,}\()/g, '$<before>Math.$<after>').replace(/Math\.Math/g, 'Math')})`);
      const toReturn = Float64Array.from(array);
      for (let i = 0; i < array.length; i++) {
        toReturn[i] = fct(array[i]);
        if (Number.isNaN(toReturn[i])) {
          throw new Error(`The callback ${fctString} does not return a number: ${array[i]}`);
        }
      }
      return toReturn;
    }

    /**
     * This function
     * @param output - undefined or a new array
     * @param length - length of the output array
     * @returns
     */
    function getOutputArray(output, length) {
      if (output !== undefined) {
        if (!isAnyArray(output)) {
          throw new TypeError('output option must be an array if specified');
        }
        if (output.length !== length) {
          throw new TypeError('the output array does not have the correct length');
        }
        return output;
      } else {
        return new Float64Array(length);
      }
    }

    /**
     * This function xMultiply the first array by the second array or a constant value to each element of the first array
     *
     * @param array1 - first array
     * @param array2 - second array
     * @param options - options
     */
    function xMultiply(array1, array2, options = {}) {
      let isConstant = false;
      let constant = 0;
      if (isAnyArray(array2)) {
        if (array1.length !== array2.length) {
          throw new Error('xMultiply: size of array1 and array2 must be identical');
        }
      } else {
        isConstant = true;
        constant = Number(array2);
      }
      let array3 = getOutputArray(options.output, array1.length);
      if (isConstant) {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] * constant;
        }
      } else {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] * array2[i];
        }
      }
      return array3;
    }

    /**
     * Checks if input is of type array
     *
     * @param input - input
     */
    function xCheck(input, options = {}) {
      const {
        minLength
      } = options;
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      }
      if (input.length === 0) {
        throw new TypeError('input must not be empty');
      }
      if (minLength && input.length < minLength) {
        throw new Error(`input must have a length of at least ${minLength}`);
      }
    }

    function max(input) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      }
      if (input.length === 0) {
        throw new TypeError('input must not be empty');
      }
      var _options$fromIndex = options.fromIndex,
        fromIndex = _options$fromIndex === void 0 ? 0 : _options$fromIndex,
        _options$toIndex = options.toIndex,
        toIndex = _options$toIndex === void 0 ? input.length : _options$toIndex;
      if (fromIndex < 0 || fromIndex >= input.length || !Number.isInteger(fromIndex)) {
        throw new Error('fromIndex must be a positive integer smaller than length');
      }
      if (toIndex <= fromIndex || toIndex > input.length || !Number.isInteger(toIndex)) {
        throw new Error('toIndex must be an integer greater than fromIndex and at most equal to length');
      }
      var maxValue = input[fromIndex];
      for (var i = fromIndex + 1; i < toIndex; i++) {
        if (input[i] > maxValue) maxValue = input[i];
      }
      return maxValue;
    }

    function min(input) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      }
      if (input.length === 0) {
        throw new TypeError('input must not be empty');
      }
      var _options$fromIndex = options.fromIndex,
        fromIndex = _options$fromIndex === void 0 ? 0 : _options$fromIndex,
        _options$toIndex = options.toIndex,
        toIndex = _options$toIndex === void 0 ? input.length : _options$toIndex;
      if (fromIndex < 0 || fromIndex >= input.length || !Number.isInteger(fromIndex)) {
        throw new Error('fromIndex must be a positive integer smaller than length');
      }
      if (toIndex <= fromIndex || toIndex > input.length || !Number.isInteger(toIndex)) {
        throw new Error('toIndex must be an integer greater than fromIndex and at most equal to length');
      }
      var minValue = input[fromIndex];
      for (var i = fromIndex + 1; i < toIndex; i++) {
        if (input[i] < minValue) minValue = input[i];
      }
      return minValue;
    }

    function rescale$1(input) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      } else if (input.length === 0) {
        throw new TypeError('input must not be empty');
      }
      var output;
      if (options.output !== undefined) {
        if (!isAnyArray(options.output)) {
          throw new TypeError('output option must be an array if specified');
        }
        output = options.output;
      } else {
        output = new Array(input.length);
      }
      var currentMin = min(input);
      var currentMax = max(input);
      if (currentMin === currentMax) {
        throw new RangeError('minimum and maximum input values are equal. Cannot rescale a constant array');
      }
      var _options$min = options.min,
        minValue = _options$min === void 0 ? options.autoMinMax ? currentMin : 0 : _options$min,
        _options$max = options.max,
        maxValue = _options$max === void 0 ? options.autoMinMax ? currentMax : 1 : _options$max;
      if (minValue >= maxValue) {
        throw new RangeError('min option must be smaller than max option');
      }
      var factor = (maxValue - minValue) / (currentMax - currentMin);
      for (var i = 0; i < input.length; i++) {
        output[i] = (input[i] - currentMin) * factor + minValue;
      }
      return output;
    }

    const indent = ' '.repeat(2);
    const indentData = ' '.repeat(4);
    function inspectMatrix() {
      return inspectMatrixWithOptions(this);
    }
    function inspectMatrixWithOptions(matrix, options = {}) {
      const {
        maxRows = 15,
        maxColumns = 10,
        maxNumSize = 8,
        padMinus = 'auto'
      } = options;
      return `${matrix.constructor.name} {
${indent}[
${indentData}${inspectData(matrix, maxRows, maxColumns, maxNumSize, padMinus)}
${indent}]
${indent}rows: ${matrix.rows}
${indent}columns: ${matrix.columns}
}`;
    }
    function inspectData(matrix, maxRows, maxColumns, maxNumSize, padMinus) {
      const {
        rows,
        columns
      } = matrix;
      const maxI = Math.min(rows, maxRows);
      const maxJ = Math.min(columns, maxColumns);
      const result = [];
      if (padMinus === 'auto') {
        padMinus = false;
        loop: for (let i = 0; i < maxI; i++) {
          for (let j = 0; j < maxJ; j++) {
            if (matrix.get(i, j) < 0) {
              padMinus = true;
              break loop;
            }
          }
        }
      }
      for (let i = 0; i < maxI; i++) {
        let line = [];
        for (let j = 0; j < maxJ; j++) {
          line.push(formatNumber(matrix.get(i, j), maxNumSize, padMinus));
        }
        result.push(`${line.join(' ')}`);
      }
      if (maxJ !== columns) {
        result[result.length - 1] += ` ... ${columns - maxColumns} more columns`;
      }
      if (maxI !== rows) {
        result.push(`... ${rows - maxRows} more rows`);
      }
      return result.join(`\n${indentData}`);
    }
    function formatNumber(num, maxNumSize, padMinus) {
      return (num >= 0 && padMinus ? ` ${formatNumber2(num, maxNumSize - 1)}` : formatNumber2(num, maxNumSize)).padEnd(maxNumSize);
    }
    function formatNumber2(num, len) {
      // small.length numbers should be as is
      let str = num.toString();
      if (str.length <= len) return str;

      // (7)'0.00123' is better then (7)'1.23e-2'
      // (8)'0.000123' is worse then (7)'1.23e-3',
      let fix = num.toFixed(len);
      if (fix.length > len) {
        fix = num.toFixed(Math.max(0, len - (fix.length - len)));
      }
      if (fix.length <= len && !fix.startsWith('0.000') && !fix.startsWith('-0.000')) {
        return fix;
      }

      // well, if it's still too long the user should've used longer numbers
      let exp = num.toExponential(len);
      if (exp.length > len) {
        exp = num.toExponential(Math.max(0, len - (exp.length - len)));
      }
      return exp.slice(0);
    }

    function installMathOperations(AbstractMatrix, Matrix) {
      AbstractMatrix.prototype.add = function add(value) {
        if (typeof value === 'number') return this.addS(value);
        return this.addM(value);
      };
      AbstractMatrix.prototype.addS = function addS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) + value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.addM = function addM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) + matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.add = function add(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.add(value);
      };
      AbstractMatrix.prototype.sub = function sub(value) {
        if (typeof value === 'number') return this.subS(value);
        return this.subM(value);
      };
      AbstractMatrix.prototype.subS = function subS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) - value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.subM = function subM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) - matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.sub = function sub(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.sub(value);
      };
      AbstractMatrix.prototype.subtract = AbstractMatrix.prototype.sub;
      AbstractMatrix.prototype.subtractS = AbstractMatrix.prototype.subS;
      AbstractMatrix.prototype.subtractM = AbstractMatrix.prototype.subM;
      AbstractMatrix.subtract = AbstractMatrix.sub;
      AbstractMatrix.prototype.mul = function mul(value) {
        if (typeof value === 'number') return this.mulS(value);
        return this.mulM(value);
      };
      AbstractMatrix.prototype.mulS = function mulS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) * value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.mulM = function mulM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) * matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.mul = function mul(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.mul(value);
      };
      AbstractMatrix.prototype.multiply = AbstractMatrix.prototype.mul;
      AbstractMatrix.prototype.multiplyS = AbstractMatrix.prototype.mulS;
      AbstractMatrix.prototype.multiplyM = AbstractMatrix.prototype.mulM;
      AbstractMatrix.multiply = AbstractMatrix.mul;
      AbstractMatrix.prototype.div = function div(value) {
        if (typeof value === 'number') return this.divS(value);
        return this.divM(value);
      };
      AbstractMatrix.prototype.divS = function divS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) / value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.divM = function divM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) / matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.div = function div(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.div(value);
      };
      AbstractMatrix.prototype.divide = AbstractMatrix.prototype.div;
      AbstractMatrix.prototype.divideS = AbstractMatrix.prototype.divS;
      AbstractMatrix.prototype.divideM = AbstractMatrix.prototype.divM;
      AbstractMatrix.divide = AbstractMatrix.div;
      AbstractMatrix.prototype.mod = function mod(value) {
        if (typeof value === 'number') return this.modS(value);
        return this.modM(value);
      };
      AbstractMatrix.prototype.modS = function modS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) % value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.modM = function modM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) % matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.mod = function mod(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.mod(value);
      };
      AbstractMatrix.prototype.modulus = AbstractMatrix.prototype.mod;
      AbstractMatrix.prototype.modulusS = AbstractMatrix.prototype.modS;
      AbstractMatrix.prototype.modulusM = AbstractMatrix.prototype.modM;
      AbstractMatrix.modulus = AbstractMatrix.mod;
      AbstractMatrix.prototype.and = function and(value) {
        if (typeof value === 'number') return this.andS(value);
        return this.andM(value);
      };
      AbstractMatrix.prototype.andS = function andS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) & value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.andM = function andM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) & matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.and = function and(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.and(value);
      };
      AbstractMatrix.prototype.or = function or(value) {
        if (typeof value === 'number') return this.orS(value);
        return this.orM(value);
      };
      AbstractMatrix.prototype.orS = function orS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) | value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.orM = function orM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) | matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.or = function or(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.or(value);
      };
      AbstractMatrix.prototype.xor = function xor(value) {
        if (typeof value === 'number') return this.xorS(value);
        return this.xorM(value);
      };
      AbstractMatrix.prototype.xorS = function xorS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) ^ value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.xorM = function xorM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) ^ matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.xor = function xor(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.xor(value);
      };
      AbstractMatrix.prototype.leftShift = function leftShift(value) {
        if (typeof value === 'number') return this.leftShiftS(value);
        return this.leftShiftM(value);
      };
      AbstractMatrix.prototype.leftShiftS = function leftShiftS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) << value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.leftShiftM = function leftShiftM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) << matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.leftShift = function leftShift(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.leftShift(value);
      };
      AbstractMatrix.prototype.signPropagatingRightShift = function signPropagatingRightShift(value) {
        if (typeof value === 'number') return this.signPropagatingRightShiftS(value);
        return this.signPropagatingRightShiftM(value);
      };
      AbstractMatrix.prototype.signPropagatingRightShiftS = function signPropagatingRightShiftS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) >> value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.signPropagatingRightShiftM = function signPropagatingRightShiftM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) >> matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.signPropagatingRightShift = function signPropagatingRightShift(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.signPropagatingRightShift(value);
      };
      AbstractMatrix.prototype.rightShift = function rightShift(value) {
        if (typeof value === 'number') return this.rightShiftS(value);
        return this.rightShiftM(value);
      };
      AbstractMatrix.prototype.rightShiftS = function rightShiftS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) >>> value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.rightShiftM = function rightShiftM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) >>> matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.rightShift = function rightShift(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.rightShift(value);
      };
      AbstractMatrix.prototype.zeroFillRightShift = AbstractMatrix.prototype.rightShift;
      AbstractMatrix.prototype.zeroFillRightShiftS = AbstractMatrix.prototype.rightShiftS;
      AbstractMatrix.prototype.zeroFillRightShiftM = AbstractMatrix.prototype.rightShiftM;
      AbstractMatrix.zeroFillRightShift = AbstractMatrix.rightShift;
      AbstractMatrix.prototype.not = function not() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, ~this.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.not = function not(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.not();
      };
      AbstractMatrix.prototype.abs = function abs() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.abs(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.abs = function abs(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.abs();
      };
      AbstractMatrix.prototype.acos = function acos() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.acos(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.acos = function acos(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.acos();
      };
      AbstractMatrix.prototype.acosh = function acosh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.acosh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.acosh = function acosh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.acosh();
      };
      AbstractMatrix.prototype.asin = function asin() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.asin(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.asin = function asin(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.asin();
      };
      AbstractMatrix.prototype.asinh = function asinh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.asinh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.asinh = function asinh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.asinh();
      };
      AbstractMatrix.prototype.atan = function atan() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.atan(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.atan = function atan(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.atan();
      };
      AbstractMatrix.prototype.atanh = function atanh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.atanh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.atanh = function atanh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.atanh();
      };
      AbstractMatrix.prototype.cbrt = function cbrt() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.cbrt(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.cbrt = function cbrt(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.cbrt();
      };
      AbstractMatrix.prototype.ceil = function ceil() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.ceil(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.ceil = function ceil(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.ceil();
      };
      AbstractMatrix.prototype.clz32 = function clz32() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.clz32(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.clz32 = function clz32(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.clz32();
      };
      AbstractMatrix.prototype.cos = function cos() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.cos(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.cos = function cos(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.cos();
      };
      AbstractMatrix.prototype.cosh = function cosh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.cosh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.cosh = function cosh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.cosh();
      };
      AbstractMatrix.prototype.exp = function exp() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.exp(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.exp = function exp(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.exp();
      };
      AbstractMatrix.prototype.expm1 = function expm1() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.expm1(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.expm1 = function expm1(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.expm1();
      };
      AbstractMatrix.prototype.floor = function floor() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.floor(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.floor = function floor(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.floor();
      };
      AbstractMatrix.prototype.fround = function fround() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.fround(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.fround = function fround(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.fround();
      };
      AbstractMatrix.prototype.log = function log() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.log(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.log = function log(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.log();
      };
      AbstractMatrix.prototype.log1p = function log1p() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.log1p(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.log1p = function log1p(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.log1p();
      };
      AbstractMatrix.prototype.log10 = function log10() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.log10(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.log10 = function log10(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.log10();
      };
      AbstractMatrix.prototype.log2 = function log2() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.log2(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.log2 = function log2(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.log2();
      };
      AbstractMatrix.prototype.round = function round() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.round(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.round = function round(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.round();
      };
      AbstractMatrix.prototype.sign = function sign() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.sign(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.sign = function sign(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.sign();
      };
      AbstractMatrix.prototype.sin = function sin() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.sin(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.sin = function sin(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.sin();
      };
      AbstractMatrix.prototype.sinh = function sinh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.sinh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.sinh = function sinh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.sinh();
      };
      AbstractMatrix.prototype.sqrt = function sqrt() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.sqrt(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.sqrt = function sqrt(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.sqrt();
      };
      AbstractMatrix.prototype.tan = function tan() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.tan(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.tan = function tan(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.tan();
      };
      AbstractMatrix.prototype.tanh = function tanh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.tanh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.tanh = function tanh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.tanh();
      };
      AbstractMatrix.prototype.trunc = function trunc() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.trunc(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.trunc = function trunc(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.trunc();
      };
      AbstractMatrix.pow = function pow(matrix, arg0) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.pow(arg0);
      };
      AbstractMatrix.prototype.pow = function pow(value) {
        if (typeof value === 'number') return this.powS(value);
        return this.powM(value);
      };
      AbstractMatrix.prototype.powS = function powS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.pow(this.get(i, j), value));
          }
        }
        return this;
      };
      AbstractMatrix.prototype.powM = function powM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.pow(this.get(i, j), matrix.get(i, j)));
          }
        }
        return this;
      };
    }

    /**
     * @private
     * Check that a row index is not out of bounds
     * @param {Matrix} matrix
     * @param {number} index
     * @param {boolean} [outer]
     */
    function checkRowIndex(matrix, index, outer) {
      let max = outer ? matrix.rows : matrix.rows - 1;
      if (index < 0 || index > max) {
        throw new RangeError('Row index out of range');
      }
    }

    /**
     * @private
     * Check that a column index is not out of bounds
     * @param {Matrix} matrix
     * @param {number} index
     * @param {boolean} [outer]
     */
    function checkColumnIndex(matrix, index, outer) {
      let max = outer ? matrix.columns : matrix.columns - 1;
      if (index < 0 || index > max) {
        throw new RangeError('Column index out of range');
      }
    }

    /**
     * @private
     * Check that the provided vector is an array with the right length
     * @param {Matrix} matrix
     * @param {Array|Matrix} vector
     * @return {Array}
     * @throws {RangeError}
     */
    function checkRowVector(matrix, vector) {
      if (vector.to1DArray) {
        vector = vector.to1DArray();
      }
      if (vector.length !== matrix.columns) {
        throw new RangeError('vector size must be the same as the number of columns');
      }
      return vector;
    }

    /**
     * @private
     * Check that the provided vector is an array with the right length
     * @param {Matrix} matrix
     * @param {Array|Matrix} vector
     * @return {Array}
     * @throws {RangeError}
     */
    function checkColumnVector(matrix, vector) {
      if (vector.to1DArray) {
        vector = vector.to1DArray();
      }
      if (vector.length !== matrix.rows) {
        throw new RangeError('vector size must be the same as the number of rows');
      }
      return vector;
    }
    function checkRowIndices(matrix, rowIndices) {
      if (!isAnyArray(rowIndices)) {
        throw new TypeError('row indices must be an array');
      }
      for (let i = 0; i < rowIndices.length; i++) {
        if (rowIndices[i] < 0 || rowIndices[i] >= matrix.rows) {
          throw new RangeError('row indices are out of range');
        }
      }
    }
    function checkColumnIndices(matrix, columnIndices) {
      if (!isAnyArray(columnIndices)) {
        throw new TypeError('column indices must be an array');
      }
      for (let i = 0; i < columnIndices.length; i++) {
        if (columnIndices[i] < 0 || columnIndices[i] >= matrix.columns) {
          throw new RangeError('column indices are out of range');
        }
      }
    }
    function checkRange$1(matrix, startRow, endRow, startColumn, endColumn) {
      if (arguments.length !== 5) {
        throw new RangeError('expected 4 arguments');
      }
      checkNumber('startRow', startRow);
      checkNumber('endRow', endRow);
      checkNumber('startColumn', startColumn);
      checkNumber('endColumn', endColumn);
      if (startRow > endRow || startColumn > endColumn || startRow < 0 || startRow >= matrix.rows || endRow < 0 || endRow >= matrix.rows || startColumn < 0 || startColumn >= matrix.columns || endColumn < 0 || endColumn >= matrix.columns) {
        throw new RangeError('Submatrix indices are out of range');
      }
    }
    function newArray$1(length, value = 0) {
      let array = [];
      for (let i = 0; i < length; i++) {
        array.push(value);
      }
      return array;
    }
    function checkNumber(name, value) {
      if (typeof value !== 'number') {
        throw new TypeError(`${name} must be a number`);
      }
    }
    function checkNonEmpty(matrix) {
      if (matrix.isEmpty()) {
        throw new Error('Empty matrix has no elements to index');
      }
    }

    function sumByRow(matrix) {
      let sum = newArray$1(matrix.rows);
      for (let i = 0; i < matrix.rows; ++i) {
        for (let j = 0; j < matrix.columns; ++j) {
          sum[i] += matrix.get(i, j);
        }
      }
      return sum;
    }
    function sumByColumn(matrix) {
      let sum = newArray$1(matrix.columns);
      for (let i = 0; i < matrix.rows; ++i) {
        for (let j = 0; j < matrix.columns; ++j) {
          sum[j] += matrix.get(i, j);
        }
      }
      return sum;
    }
    function sumAll(matrix) {
      let v = 0;
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          v += matrix.get(i, j);
        }
      }
      return v;
    }
    function productByRow(matrix) {
      let sum = newArray$1(matrix.rows, 1);
      for (let i = 0; i < matrix.rows; ++i) {
        for (let j = 0; j < matrix.columns; ++j) {
          sum[i] *= matrix.get(i, j);
        }
      }
      return sum;
    }
    function productByColumn(matrix) {
      let sum = newArray$1(matrix.columns, 1);
      for (let i = 0; i < matrix.rows; ++i) {
        for (let j = 0; j < matrix.columns; ++j) {
          sum[j] *= matrix.get(i, j);
        }
      }
      return sum;
    }
    function productAll(matrix) {
      let v = 1;
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          v *= matrix.get(i, j);
        }
      }
      return v;
    }
    function varianceByRow(matrix, unbiased, mean) {
      const rows = matrix.rows;
      const cols = matrix.columns;
      const variance = [];
      for (let i = 0; i < rows; i++) {
        let sum1 = 0;
        let sum2 = 0;
        let x = 0;
        for (let j = 0; j < cols; j++) {
          x = matrix.get(i, j) - mean[i];
          sum1 += x;
          sum2 += x * x;
        }
        if (unbiased) {
          variance.push((sum2 - sum1 * sum1 / cols) / (cols - 1));
        } else {
          variance.push((sum2 - sum1 * sum1 / cols) / cols);
        }
      }
      return variance;
    }
    function varianceByColumn(matrix, unbiased, mean) {
      const rows = matrix.rows;
      const cols = matrix.columns;
      const variance = [];
      for (let j = 0; j < cols; j++) {
        let sum1 = 0;
        let sum2 = 0;
        let x = 0;
        for (let i = 0; i < rows; i++) {
          x = matrix.get(i, j) - mean[j];
          sum1 += x;
          sum2 += x * x;
        }
        if (unbiased) {
          variance.push((sum2 - sum1 * sum1 / rows) / (rows - 1));
        } else {
          variance.push((sum2 - sum1 * sum1 / rows) / rows);
        }
      }
      return variance;
    }
    function varianceAll(matrix, unbiased, mean) {
      const rows = matrix.rows;
      const cols = matrix.columns;
      const size = rows * cols;
      let sum1 = 0;
      let sum2 = 0;
      let x = 0;
      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < cols; j++) {
          x = matrix.get(i, j) - mean;
          sum1 += x;
          sum2 += x * x;
        }
      }
      if (unbiased) {
        return (sum2 - sum1 * sum1 / size) / (size - 1);
      } else {
        return (sum2 - sum1 * sum1 / size) / size;
      }
    }
    function centerByRow(matrix, mean) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) - mean[i]);
        }
      }
    }
    function centerByColumn(matrix, mean) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) - mean[j]);
        }
      }
    }
    function centerAll(matrix, mean) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) - mean);
        }
      }
    }
    function getScaleByRow(matrix) {
      const scale = [];
      for (let i = 0; i < matrix.rows; i++) {
        let sum = 0;
        for (let j = 0; j < matrix.columns; j++) {
          sum += Math.pow(matrix.get(i, j), 2) / (matrix.columns - 1);
        }
        scale.push(Math.sqrt(sum));
      }
      return scale;
    }
    function scaleByRow(matrix, scale) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) / scale[i]);
        }
      }
    }
    function getScaleByColumn(matrix) {
      const scale = [];
      for (let j = 0; j < matrix.columns; j++) {
        let sum = 0;
        for (let i = 0; i < matrix.rows; i++) {
          sum += Math.pow(matrix.get(i, j), 2) / (matrix.rows - 1);
        }
        scale.push(Math.sqrt(sum));
      }
      return scale;
    }
    function scaleByColumn(matrix, scale) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) / scale[j]);
        }
      }
    }
    function getScaleAll(matrix) {
      const divider = matrix.size - 1;
      let sum = 0;
      for (let j = 0; j < matrix.columns; j++) {
        for (let i = 0; i < matrix.rows; i++) {
          sum += Math.pow(matrix.get(i, j), 2) / divider;
        }
      }
      return Math.sqrt(sum);
    }
    function scaleAll(matrix, scale) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) / scale);
        }
      }
    }

    class AbstractMatrix {
      static from1DArray(newRows, newColumns, newData) {
        let length = newRows * newColumns;
        if (length !== newData.length) {
          throw new RangeError('data length does not match given dimensions');
        }
        let newMatrix = new Matrix(newRows, newColumns);
        for (let row = 0; row < newRows; row++) {
          for (let column = 0; column < newColumns; column++) {
            newMatrix.set(row, column, newData[row * newColumns + column]);
          }
        }
        return newMatrix;
      }
      static rowVector(newData) {
        let vector = new Matrix(1, newData.length);
        for (let i = 0; i < newData.length; i++) {
          vector.set(0, i, newData[i]);
        }
        return vector;
      }
      static columnVector(newData) {
        let vector = new Matrix(newData.length, 1);
        for (let i = 0; i < newData.length; i++) {
          vector.set(i, 0, newData[i]);
        }
        return vector;
      }
      static zeros(rows, columns) {
        return new Matrix(rows, columns);
      }
      static ones(rows, columns) {
        return new Matrix(rows, columns).fill(1);
      }
      static rand(rows, columns, options = {}) {
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          random = Math.random
        } = options;
        let matrix = new Matrix(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            matrix.set(i, j, random());
          }
        }
        return matrix;
      }
      static randInt(rows, columns, options = {}) {
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          min = 0,
          max = 1000,
          random = Math.random
        } = options;
        if (!Number.isInteger(min)) throw new TypeError('min must be an integer');
        if (!Number.isInteger(max)) throw new TypeError('max must be an integer');
        if (min >= max) throw new RangeError('min must be smaller than max');
        let interval = max - min;
        let matrix = new Matrix(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            let value = min + Math.round(random() * interval);
            matrix.set(i, j, value);
          }
        }
        return matrix;
      }
      static eye(rows, columns, value) {
        if (columns === undefined) columns = rows;
        if (value === undefined) value = 1;
        let min = Math.min(rows, columns);
        let matrix = this.zeros(rows, columns);
        for (let i = 0; i < min; i++) {
          matrix.set(i, i, value);
        }
        return matrix;
      }
      static diag(data, rows, columns) {
        let l = data.length;
        if (rows === undefined) rows = l;
        if (columns === undefined) columns = rows;
        let min = Math.min(l, rows, columns);
        let matrix = this.zeros(rows, columns);
        for (let i = 0; i < min; i++) {
          matrix.set(i, i, data[i]);
        }
        return matrix;
      }
      static min(matrix1, matrix2) {
        matrix1 = this.checkMatrix(matrix1);
        matrix2 = this.checkMatrix(matrix2);
        let rows = matrix1.rows;
        let columns = matrix1.columns;
        let result = new Matrix(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            result.set(i, j, Math.min(matrix1.get(i, j), matrix2.get(i, j)));
          }
        }
        return result;
      }
      static max(matrix1, matrix2) {
        matrix1 = this.checkMatrix(matrix1);
        matrix2 = this.checkMatrix(matrix2);
        let rows = matrix1.rows;
        let columns = matrix1.columns;
        let result = new this(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            result.set(i, j, Math.max(matrix1.get(i, j), matrix2.get(i, j)));
          }
        }
        return result;
      }
      static checkMatrix(value) {
        return AbstractMatrix.isMatrix(value) ? value : new Matrix(value);
      }
      static isMatrix(value) {
        return value != null && value.klass === 'Matrix';
      }
      get size() {
        return this.rows * this.columns;
      }
      apply(callback) {
        if (typeof callback !== 'function') {
          throw new TypeError('callback must be a function');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            callback.call(this, i, j);
          }
        }
        return this;
      }
      to1DArray() {
        let array = [];
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            array.push(this.get(i, j));
          }
        }
        return array;
      }
      to2DArray() {
        let copy = [];
        for (let i = 0; i < this.rows; i++) {
          copy.push([]);
          for (let j = 0; j < this.columns; j++) {
            copy[i].push(this.get(i, j));
          }
        }
        return copy;
      }
      toJSON() {
        return this.to2DArray();
      }
      isRowVector() {
        return this.rows === 1;
      }
      isColumnVector() {
        return this.columns === 1;
      }
      isVector() {
        return this.rows === 1 || this.columns === 1;
      }
      isSquare() {
        return this.rows === this.columns;
      }
      isEmpty() {
        return this.rows === 0 || this.columns === 0;
      }
      isSymmetric() {
        if (this.isSquare()) {
          for (let i = 0; i < this.rows; i++) {
            for (let j = 0; j <= i; j++) {
              if (this.get(i, j) !== this.get(j, i)) {
                return false;
              }
            }
          }
          return true;
        }
        return false;
      }
      isEchelonForm() {
        let i = 0;
        let j = 0;
        let previousColumn = -1;
        let isEchelonForm = true;
        let checked = false;
        while (i < this.rows && isEchelonForm) {
          j = 0;
          checked = false;
          while (j < this.columns && checked === false) {
            if (this.get(i, j) === 0) {
              j++;
            } else if (this.get(i, j) === 1 && j > previousColumn) {
              checked = true;
              previousColumn = j;
            } else {
              isEchelonForm = false;
              checked = true;
            }
          }
          i++;
        }
        return isEchelonForm;
      }
      isReducedEchelonForm() {
        let i = 0;
        let j = 0;
        let previousColumn = -1;
        let isReducedEchelonForm = true;
        let checked = false;
        while (i < this.rows && isReducedEchelonForm) {
          j = 0;
          checked = false;
          while (j < this.columns && checked === false) {
            if (this.get(i, j) === 0) {
              j++;
            } else if (this.get(i, j) === 1 && j > previousColumn) {
              checked = true;
              previousColumn = j;
            } else {
              isReducedEchelonForm = false;
              checked = true;
            }
          }
          for (let k = j + 1; k < this.rows; k++) {
            if (this.get(i, k) !== 0) {
              isReducedEchelonForm = false;
            }
          }
          i++;
        }
        return isReducedEchelonForm;
      }
      echelonForm() {
        let result = this.clone();
        let h = 0;
        let k = 0;
        while (h < result.rows && k < result.columns) {
          let iMax = h;
          for (let i = h; i < result.rows; i++) {
            if (result.get(i, k) > result.get(iMax, k)) {
              iMax = i;
            }
          }
          if (result.get(iMax, k) === 0) {
            k++;
          } else {
            result.swapRows(h, iMax);
            let tmp = result.get(h, k);
            for (let j = k; j < result.columns; j++) {
              result.set(h, j, result.get(h, j) / tmp);
            }
            for (let i = h + 1; i < result.rows; i++) {
              let factor = result.get(i, k) / result.get(h, k);
              result.set(i, k, 0);
              for (let j = k + 1; j < result.columns; j++) {
                result.set(i, j, result.get(i, j) - result.get(h, j) * factor);
              }
            }
            h++;
            k++;
          }
        }
        return result;
      }
      reducedEchelonForm() {
        let result = this.echelonForm();
        let m = result.columns;
        let n = result.rows;
        let h = n - 1;
        while (h >= 0) {
          if (result.maxRow(h) === 0) {
            h--;
          } else {
            let p = 0;
            let pivot = false;
            while (p < n && pivot === false) {
              if (result.get(h, p) === 1) {
                pivot = true;
              } else {
                p++;
              }
            }
            for (let i = 0; i < h; i++) {
              let factor = result.get(i, p);
              for (let j = p; j < m; j++) {
                let tmp = result.get(i, j) - factor * result.get(h, j);
                result.set(i, j, tmp);
              }
            }
            h--;
          }
        }
        return result;
      }
      set() {
        throw new Error('set method is unimplemented');
      }
      get() {
        throw new Error('get method is unimplemented');
      }
      repeat(options = {}) {
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          rows = 1,
          columns = 1
        } = options;
        if (!Number.isInteger(rows) || rows <= 0) {
          throw new TypeError('rows must be a positive integer');
        }
        if (!Number.isInteger(columns) || columns <= 0) {
          throw new TypeError('columns must be a positive integer');
        }
        let matrix = new Matrix(this.rows * rows, this.columns * columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            matrix.setSubMatrix(this, this.rows * i, this.columns * j);
          }
        }
        return matrix;
      }
      fill(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, value);
          }
        }
        return this;
      }
      neg() {
        return this.mulS(-1);
      }
      getRow(index) {
        checkRowIndex(this, index);
        let row = [];
        for (let i = 0; i < this.columns; i++) {
          row.push(this.get(index, i));
        }
        return row;
      }
      getRowVector(index) {
        return Matrix.rowVector(this.getRow(index));
      }
      setRow(index, array) {
        checkRowIndex(this, index);
        array = checkRowVector(this, array);
        for (let i = 0; i < this.columns; i++) {
          this.set(index, i, array[i]);
        }
        return this;
      }
      swapRows(row1, row2) {
        checkRowIndex(this, row1);
        checkRowIndex(this, row2);
        for (let i = 0; i < this.columns; i++) {
          let temp = this.get(row1, i);
          this.set(row1, i, this.get(row2, i));
          this.set(row2, i, temp);
        }
        return this;
      }
      getColumn(index) {
        checkColumnIndex(this, index);
        let column = [];
        for (let i = 0; i < this.rows; i++) {
          column.push(this.get(i, index));
        }
        return column;
      }
      getColumnVector(index) {
        return Matrix.columnVector(this.getColumn(index));
      }
      setColumn(index, array) {
        checkColumnIndex(this, index);
        array = checkColumnVector(this, array);
        for (let i = 0; i < this.rows; i++) {
          this.set(i, index, array[i]);
        }
        return this;
      }
      swapColumns(column1, column2) {
        checkColumnIndex(this, column1);
        checkColumnIndex(this, column2);
        for (let i = 0; i < this.rows; i++) {
          let temp = this.get(i, column1);
          this.set(i, column1, this.get(i, column2));
          this.set(i, column2, temp);
        }
        return this;
      }
      addRowVector(vector) {
        vector = checkRowVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) + vector[j]);
          }
        }
        return this;
      }
      subRowVector(vector) {
        vector = checkRowVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) - vector[j]);
          }
        }
        return this;
      }
      mulRowVector(vector) {
        vector = checkRowVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) * vector[j]);
          }
        }
        return this;
      }
      divRowVector(vector) {
        vector = checkRowVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) / vector[j]);
          }
        }
        return this;
      }
      addColumnVector(vector) {
        vector = checkColumnVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) + vector[i]);
          }
        }
        return this;
      }
      subColumnVector(vector) {
        vector = checkColumnVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) - vector[i]);
          }
        }
        return this;
      }
      mulColumnVector(vector) {
        vector = checkColumnVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) * vector[i]);
          }
        }
        return this;
      }
      divColumnVector(vector) {
        vector = checkColumnVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) / vector[i]);
          }
        }
        return this;
      }
      mulRow(index, value) {
        checkRowIndex(this, index);
        for (let i = 0; i < this.columns; i++) {
          this.set(index, i, this.get(index, i) * value);
        }
        return this;
      }
      mulColumn(index, value) {
        checkColumnIndex(this, index);
        for (let i = 0; i < this.rows; i++) {
          this.set(i, index, this.get(i, index) * value);
        }
        return this;
      }
      max(by) {
        if (this.isEmpty()) {
          return NaN;
        }
        switch (by) {
          case 'row':
            {
              const max = new Array(this.rows).fill(Number.NEGATIVE_INFINITY);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) > max[row]) {
                    max[row] = this.get(row, column);
                  }
                }
              }
              return max;
            }
          case 'column':
            {
              const max = new Array(this.columns).fill(Number.NEGATIVE_INFINITY);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) > max[column]) {
                    max[column] = this.get(row, column);
                  }
                }
              }
              return max;
            }
          case undefined:
            {
              let max = this.get(0, 0);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) > max) {
                    max = this.get(row, column);
                  }
                }
              }
              return max;
            }
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      maxIndex() {
        checkNonEmpty(this);
        let v = this.get(0, 0);
        let idx = [0, 0];
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            if (this.get(i, j) > v) {
              v = this.get(i, j);
              idx[0] = i;
              idx[1] = j;
            }
          }
        }
        return idx;
      }
      min(by) {
        if (this.isEmpty()) {
          return NaN;
        }
        switch (by) {
          case 'row':
            {
              const min = new Array(this.rows).fill(Number.POSITIVE_INFINITY);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) < min[row]) {
                    min[row] = this.get(row, column);
                  }
                }
              }
              return min;
            }
          case 'column':
            {
              const min = new Array(this.columns).fill(Number.POSITIVE_INFINITY);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) < min[column]) {
                    min[column] = this.get(row, column);
                  }
                }
              }
              return min;
            }
          case undefined:
            {
              let min = this.get(0, 0);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) < min) {
                    min = this.get(row, column);
                  }
                }
              }
              return min;
            }
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      minIndex() {
        checkNonEmpty(this);
        let v = this.get(0, 0);
        let idx = [0, 0];
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            if (this.get(i, j) < v) {
              v = this.get(i, j);
              idx[0] = i;
              idx[1] = j;
            }
          }
        }
        return idx;
      }
      maxRow(row) {
        checkRowIndex(this, row);
        if (this.isEmpty()) {
          return NaN;
        }
        let v = this.get(row, 0);
        for (let i = 1; i < this.columns; i++) {
          if (this.get(row, i) > v) {
            v = this.get(row, i);
          }
        }
        return v;
      }
      maxRowIndex(row) {
        checkRowIndex(this, row);
        checkNonEmpty(this);
        let v = this.get(row, 0);
        let idx = [row, 0];
        for (let i = 1; i < this.columns; i++) {
          if (this.get(row, i) > v) {
            v = this.get(row, i);
            idx[1] = i;
          }
        }
        return idx;
      }
      minRow(row) {
        checkRowIndex(this, row);
        if (this.isEmpty()) {
          return NaN;
        }
        let v = this.get(row, 0);
        for (let i = 1; i < this.columns; i++) {
          if (this.get(row, i) < v) {
            v = this.get(row, i);
          }
        }
        return v;
      }
      minRowIndex(row) {
        checkRowIndex(this, row);
        checkNonEmpty(this);
        let v = this.get(row, 0);
        let idx = [row, 0];
        for (let i = 1; i < this.columns; i++) {
          if (this.get(row, i) < v) {
            v = this.get(row, i);
            idx[1] = i;
          }
        }
        return idx;
      }
      maxColumn(column) {
        checkColumnIndex(this, column);
        if (this.isEmpty()) {
          return NaN;
        }
        let v = this.get(0, column);
        for (let i = 1; i < this.rows; i++) {
          if (this.get(i, column) > v) {
            v = this.get(i, column);
          }
        }
        return v;
      }
      maxColumnIndex(column) {
        checkColumnIndex(this, column);
        checkNonEmpty(this);
        let v = this.get(0, column);
        let idx = [0, column];
        for (let i = 1; i < this.rows; i++) {
          if (this.get(i, column) > v) {
            v = this.get(i, column);
            idx[0] = i;
          }
        }
        return idx;
      }
      minColumn(column) {
        checkColumnIndex(this, column);
        if (this.isEmpty()) {
          return NaN;
        }
        let v = this.get(0, column);
        for (let i = 1; i < this.rows; i++) {
          if (this.get(i, column) < v) {
            v = this.get(i, column);
          }
        }
        return v;
      }
      minColumnIndex(column) {
        checkColumnIndex(this, column);
        checkNonEmpty(this);
        let v = this.get(0, column);
        let idx = [0, column];
        for (let i = 1; i < this.rows; i++) {
          if (this.get(i, column) < v) {
            v = this.get(i, column);
            idx[0] = i;
          }
        }
        return idx;
      }
      diag() {
        let min = Math.min(this.rows, this.columns);
        let diag = [];
        for (let i = 0; i < min; i++) {
          diag.push(this.get(i, i));
        }
        return diag;
      }
      norm(type = 'frobenius') {
        let result = 0;
        if (type === 'max') {
          return this.max();
        } else if (type === 'frobenius') {
          for (let i = 0; i < this.rows; i++) {
            for (let j = 0; j < this.columns; j++) {
              result = result + this.get(i, j) * this.get(i, j);
            }
          }
          return Math.sqrt(result);
        } else {
          throw new RangeError(`unknown norm type: ${type}`);
        }
      }
      cumulativeSum() {
        let sum = 0;
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            sum += this.get(i, j);
            this.set(i, j, sum);
          }
        }
        return this;
      }
      dot(vector2) {
        if (AbstractMatrix.isMatrix(vector2)) vector2 = vector2.to1DArray();
        let vector1 = this.to1DArray();
        if (vector1.length !== vector2.length) {
          throw new RangeError('vectors do not have the same size');
        }
        let dot = 0;
        for (let i = 0; i < vector1.length; i++) {
          dot += vector1[i] * vector2[i];
        }
        return dot;
      }
      mmul(other) {
        other = Matrix.checkMatrix(other);
        let m = this.rows;
        let n = this.columns;
        let p = other.columns;
        let result = new Matrix(m, p);
        let Bcolj = new Float64Array(n);
        for (let j = 0; j < p; j++) {
          for (let k = 0; k < n; k++) {
            Bcolj[k] = other.get(k, j);
          }
          for (let i = 0; i < m; i++) {
            let s = 0;
            for (let k = 0; k < n; k++) {
              s += this.get(i, k) * Bcolj[k];
            }
            result.set(i, j, s);
          }
        }
        return result;
      }
      strassen2x2(other) {
        other = Matrix.checkMatrix(other);
        let result = new Matrix(2, 2);
        const a11 = this.get(0, 0);
        const b11 = other.get(0, 0);
        const a12 = this.get(0, 1);
        const b12 = other.get(0, 1);
        const a21 = this.get(1, 0);
        const b21 = other.get(1, 0);
        const a22 = this.get(1, 1);
        const b22 = other.get(1, 1);

        // Compute intermediate values.
        const m1 = (a11 + a22) * (b11 + b22);
        const m2 = (a21 + a22) * b11;
        const m3 = a11 * (b12 - b22);
        const m4 = a22 * (b21 - b11);
        const m5 = (a11 + a12) * b22;
        const m6 = (a21 - a11) * (b11 + b12);
        const m7 = (a12 - a22) * (b21 + b22);

        // Combine intermediate values into the output.
        const c00 = m1 + m4 - m5 + m7;
        const c01 = m3 + m5;
        const c10 = m2 + m4;
        const c11 = m1 - m2 + m3 + m6;
        result.set(0, 0, c00);
        result.set(0, 1, c01);
        result.set(1, 0, c10);
        result.set(1, 1, c11);
        return result;
      }
      strassen3x3(other) {
        other = Matrix.checkMatrix(other);
        let result = new Matrix(3, 3);
        const a00 = this.get(0, 0);
        const a01 = this.get(0, 1);
        const a02 = this.get(0, 2);
        const a10 = this.get(1, 0);
        const a11 = this.get(1, 1);
        const a12 = this.get(1, 2);
        const a20 = this.get(2, 0);
        const a21 = this.get(2, 1);
        const a22 = this.get(2, 2);
        const b00 = other.get(0, 0);
        const b01 = other.get(0, 1);
        const b02 = other.get(0, 2);
        const b10 = other.get(1, 0);
        const b11 = other.get(1, 1);
        const b12 = other.get(1, 2);
        const b20 = other.get(2, 0);
        const b21 = other.get(2, 1);
        const b22 = other.get(2, 2);
        const m1 = (a00 + a01 + a02 - a10 - a11 - a21 - a22) * b11;
        const m2 = (a00 - a10) * (-b01 + b11);
        const m3 = a11 * (-b00 + b01 + b10 - b11 - b12 - b20 + b22);
        const m4 = (-a00 + a10 + a11) * (b00 - b01 + b11);
        const m5 = (a10 + a11) * (-b00 + b01);
        const m6 = a00 * b00;
        const m7 = (-a00 + a20 + a21) * (b00 - b02 + b12);
        const m8 = (-a00 + a20) * (b02 - b12);
        const m9 = (a20 + a21) * (-b00 + b02);
        const m10 = (a00 + a01 + a02 - a11 - a12 - a20 - a21) * b12;
        const m11 = a21 * (-b00 + b02 + b10 - b11 - b12 - b20 + b21);
        const m12 = (-a02 + a21 + a22) * (b11 + b20 - b21);
        const m13 = (a02 - a22) * (b11 - b21);
        const m14 = a02 * b20;
        const m15 = (a21 + a22) * (-b20 + b21);
        const m16 = (-a02 + a11 + a12) * (b12 + b20 - b22);
        const m17 = (a02 - a12) * (b12 - b22);
        const m18 = (a11 + a12) * (-b20 + b22);
        const m19 = a01 * b10;
        const m20 = a12 * b21;
        const m21 = a10 * b02;
        const m22 = a20 * b01;
        const m23 = a22 * b22;
        const c00 = m6 + m14 + m19;
        const c01 = m1 + m4 + m5 + m6 + m12 + m14 + m15;
        const c02 = m6 + m7 + m9 + m10 + m14 + m16 + m18;
        const c10 = m2 + m3 + m4 + m6 + m14 + m16 + m17;
        const c11 = m2 + m4 + m5 + m6 + m20;
        const c12 = m14 + m16 + m17 + m18 + m21;
        const c20 = m6 + m7 + m8 + m11 + m12 + m13 + m14;
        const c21 = m12 + m13 + m14 + m15 + m22;
        const c22 = m6 + m7 + m8 + m9 + m23;
        result.set(0, 0, c00);
        result.set(0, 1, c01);
        result.set(0, 2, c02);
        result.set(1, 0, c10);
        result.set(1, 1, c11);
        result.set(1, 2, c12);
        result.set(2, 0, c20);
        result.set(2, 1, c21);
        result.set(2, 2, c22);
        return result;
      }
      mmulStrassen(y) {
        y = Matrix.checkMatrix(y);
        let x = this.clone();
        let r1 = x.rows;
        let c1 = x.columns;
        let r2 = y.rows;
        let c2 = y.columns;
        if (c1 !== r2) {
          // eslint-disable-next-line no-console
          console.warn(`Multiplying ${r1} x ${c1} and ${r2} x ${c2} matrix: dimensions do not match.`);
        }

        // Put a matrix into the top left of a matrix of zeros.
        // `rows` and `cols` are the dimensions of the output matrix.
        function embed(mat, rows, cols) {
          let r = mat.rows;
          let c = mat.columns;
          if (r === rows && c === cols) {
            return mat;
          } else {
            let resultat = AbstractMatrix.zeros(rows, cols);
            resultat = resultat.setSubMatrix(mat, 0, 0);
            return resultat;
          }
        }

        // Make sure both matrices are the same size.
        // This is exclusively for simplicity:
        // this algorithm can be implemented with matrices of different sizes.

        let r = Math.max(r1, r2);
        let c = Math.max(c1, c2);
        x = embed(x, r, c);
        y = embed(y, r, c);

        // Our recursive multiplication function.
        function blockMult(a, b, rows, cols) {
          // For small matrices, resort to naive multiplication.
          if (rows <= 512 || cols <= 512) {
            return a.mmul(b); // a is equivalent to this
          }

          // Apply dynamic padding.
          if (rows % 2 === 1 && cols % 2 === 1) {
            a = embed(a, rows + 1, cols + 1);
            b = embed(b, rows + 1, cols + 1);
          } else if (rows % 2 === 1) {
            a = embed(a, rows + 1, cols);
            b = embed(b, rows + 1, cols);
          } else if (cols % 2 === 1) {
            a = embed(a, rows, cols + 1);
            b = embed(b, rows, cols + 1);
          }
          let halfRows = parseInt(a.rows / 2, 10);
          let halfCols = parseInt(a.columns / 2, 10);
          // Subdivide input matrices.
          let a11 = a.subMatrix(0, halfRows - 1, 0, halfCols - 1);
          let b11 = b.subMatrix(0, halfRows - 1, 0, halfCols - 1);
          let a12 = a.subMatrix(0, halfRows - 1, halfCols, a.columns - 1);
          let b12 = b.subMatrix(0, halfRows - 1, halfCols, b.columns - 1);
          let a21 = a.subMatrix(halfRows, a.rows - 1, 0, halfCols - 1);
          let b21 = b.subMatrix(halfRows, b.rows - 1, 0, halfCols - 1);
          let a22 = a.subMatrix(halfRows, a.rows - 1, halfCols, a.columns - 1);
          let b22 = b.subMatrix(halfRows, b.rows - 1, halfCols, b.columns - 1);

          // Compute intermediate values.
          let m1 = blockMult(AbstractMatrix.add(a11, a22), AbstractMatrix.add(b11, b22), halfRows, halfCols);
          let m2 = blockMult(AbstractMatrix.add(a21, a22), b11, halfRows, halfCols);
          let m3 = blockMult(a11, AbstractMatrix.sub(b12, b22), halfRows, halfCols);
          let m4 = blockMult(a22, AbstractMatrix.sub(b21, b11), halfRows, halfCols);
          let m5 = blockMult(AbstractMatrix.add(a11, a12), b22, halfRows, halfCols);
          let m6 = blockMult(AbstractMatrix.sub(a21, a11), AbstractMatrix.add(b11, b12), halfRows, halfCols);
          let m7 = blockMult(AbstractMatrix.sub(a12, a22), AbstractMatrix.add(b21, b22), halfRows, halfCols);

          // Combine intermediate values into the output.
          let c11 = AbstractMatrix.add(m1, m4);
          c11.sub(m5);
          c11.add(m7);
          let c12 = AbstractMatrix.add(m3, m5);
          let c21 = AbstractMatrix.add(m2, m4);
          let c22 = AbstractMatrix.sub(m1, m2);
          c22.add(m3);
          c22.add(m6);

          // Crop output to the desired size (undo dynamic padding).
          let resultat = AbstractMatrix.zeros(2 * c11.rows, 2 * c11.columns);
          resultat = resultat.setSubMatrix(c11, 0, 0);
          resultat = resultat.setSubMatrix(c12, c11.rows, 0);
          resultat = resultat.setSubMatrix(c21, 0, c11.columns);
          resultat = resultat.setSubMatrix(c22, c11.rows, c11.columns);
          return resultat.subMatrix(0, rows - 1, 0, cols - 1);
        }
        return blockMult(x, y, r, c);
      }
      scaleRows(options = {}) {
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          min = 0,
          max = 1
        } = options;
        if (!Number.isFinite(min)) throw new TypeError('min must be a number');
        if (!Number.isFinite(max)) throw new TypeError('max must be a number');
        if (min >= max) throw new RangeError('min must be smaller than max');
        let newMatrix = new Matrix(this.rows, this.columns);
        for (let i = 0; i < this.rows; i++) {
          const row = this.getRow(i);
          if (row.length > 0) {
            rescale$1(row, {
              min,
              max,
              output: row
            });
          }
          newMatrix.setRow(i, row);
        }
        return newMatrix;
      }
      scaleColumns(options = {}) {
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          min = 0,
          max = 1
        } = options;
        if (!Number.isFinite(min)) throw new TypeError('min must be a number');
        if (!Number.isFinite(max)) throw new TypeError('max must be a number');
        if (min >= max) throw new RangeError('min must be smaller than max');
        let newMatrix = new Matrix(this.rows, this.columns);
        for (let i = 0; i < this.columns; i++) {
          const column = this.getColumn(i);
          if (column.length) {
            rescale$1(column, {
              min: min,
              max: max,
              output: column
            });
          }
          newMatrix.setColumn(i, column);
        }
        return newMatrix;
      }
      flipRows() {
        const middle = Math.ceil(this.columns / 2);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < middle; j++) {
            let first = this.get(i, j);
            let last = this.get(i, this.columns - 1 - j);
            this.set(i, j, last);
            this.set(i, this.columns - 1 - j, first);
          }
        }
        return this;
      }
      flipColumns() {
        const middle = Math.ceil(this.rows / 2);
        for (let j = 0; j < this.columns; j++) {
          for (let i = 0; i < middle; i++) {
            let first = this.get(i, j);
            let last = this.get(this.rows - 1 - i, j);
            this.set(i, j, last);
            this.set(this.rows - 1 - i, j, first);
          }
        }
        return this;
      }
      kroneckerProduct(other) {
        other = Matrix.checkMatrix(other);
        let m = this.rows;
        let n = this.columns;
        let p = other.rows;
        let q = other.columns;
        let result = new Matrix(m * p, n * q);
        for (let i = 0; i < m; i++) {
          for (let j = 0; j < n; j++) {
            for (let k = 0; k < p; k++) {
              for (let l = 0; l < q; l++) {
                result.set(p * i + k, q * j + l, this.get(i, j) * other.get(k, l));
              }
            }
          }
        }
        return result;
      }
      kroneckerSum(other) {
        other = Matrix.checkMatrix(other);
        if (!this.isSquare() || !other.isSquare()) {
          throw new Error('Kronecker Sum needs two Square Matrices');
        }
        let m = this.rows;
        let n = other.rows;
        let AxI = this.kroneckerProduct(Matrix.eye(n, n));
        let IxB = Matrix.eye(m, m).kroneckerProduct(other);
        return AxI.add(IxB);
      }
      transpose() {
        let result = new Matrix(this.columns, this.rows);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            result.set(j, i, this.get(i, j));
          }
        }
        return result;
      }
      sortRows(compareFunction = compareNumbers) {
        for (let i = 0; i < this.rows; i++) {
          this.setRow(i, this.getRow(i).sort(compareFunction));
        }
        return this;
      }
      sortColumns(compareFunction = compareNumbers) {
        for (let i = 0; i < this.columns; i++) {
          this.setColumn(i, this.getColumn(i).sort(compareFunction));
        }
        return this;
      }
      subMatrix(startRow, endRow, startColumn, endColumn) {
        checkRange$1(this, startRow, endRow, startColumn, endColumn);
        let newMatrix = new Matrix(endRow - startRow + 1, endColumn - startColumn + 1);
        for (let i = startRow; i <= endRow; i++) {
          for (let j = startColumn; j <= endColumn; j++) {
            newMatrix.set(i - startRow, j - startColumn, this.get(i, j));
          }
        }
        return newMatrix;
      }
      subMatrixRow(indices, startColumn, endColumn) {
        if (startColumn === undefined) startColumn = 0;
        if (endColumn === undefined) endColumn = this.columns - 1;
        if (startColumn > endColumn || startColumn < 0 || startColumn >= this.columns || endColumn < 0 || endColumn >= this.columns) {
          throw new RangeError('Argument out of range');
        }
        let newMatrix = new Matrix(indices.length, endColumn - startColumn + 1);
        for (let i = 0; i < indices.length; i++) {
          for (let j = startColumn; j <= endColumn; j++) {
            if (indices[i] < 0 || indices[i] >= this.rows) {
              throw new RangeError(`Row index out of range: ${indices[i]}`);
            }
            newMatrix.set(i, j - startColumn, this.get(indices[i], j));
          }
        }
        return newMatrix;
      }
      subMatrixColumn(indices, startRow, endRow) {
        if (startRow === undefined) startRow = 0;
        if (endRow === undefined) endRow = this.rows - 1;
        if (startRow > endRow || startRow < 0 || startRow >= this.rows || endRow < 0 || endRow >= this.rows) {
          throw new RangeError('Argument out of range');
        }
        let newMatrix = new Matrix(endRow - startRow + 1, indices.length);
        for (let i = 0; i < indices.length; i++) {
          for (let j = startRow; j <= endRow; j++) {
            if (indices[i] < 0 || indices[i] >= this.columns) {
              throw new RangeError(`Column index out of range: ${indices[i]}`);
            }
            newMatrix.set(j - startRow, i, this.get(j, indices[i]));
          }
        }
        return newMatrix;
      }
      setSubMatrix(matrix, startRow, startColumn) {
        matrix = Matrix.checkMatrix(matrix);
        if (matrix.isEmpty()) {
          return this;
        }
        let endRow = startRow + matrix.rows - 1;
        let endColumn = startColumn + matrix.columns - 1;
        checkRange$1(this, startRow, endRow, startColumn, endColumn);
        for (let i = 0; i < matrix.rows; i++) {
          for (let j = 0; j < matrix.columns; j++) {
            this.set(startRow + i, startColumn + j, matrix.get(i, j));
          }
        }
        return this;
      }
      selection(rowIndices, columnIndices) {
        checkRowIndices(this, rowIndices);
        checkColumnIndices(this, columnIndices);
        let newMatrix = new Matrix(rowIndices.length, columnIndices.length);
        for (let i = 0; i < rowIndices.length; i++) {
          let rowIndex = rowIndices[i];
          for (let j = 0; j < columnIndices.length; j++) {
            let columnIndex = columnIndices[j];
            newMatrix.set(i, j, this.get(rowIndex, columnIndex));
          }
        }
        return newMatrix;
      }
      trace() {
        let min = Math.min(this.rows, this.columns);
        let trace = 0;
        for (let i = 0; i < min; i++) {
          trace += this.get(i, i);
        }
        return trace;
      }
      clone() {
        let newMatrix = new Matrix(this.rows, this.columns);
        for (let row = 0; row < this.rows; row++) {
          for (let column = 0; column < this.columns; column++) {
            newMatrix.set(row, column, this.get(row, column));
          }
        }
        return newMatrix;
      }
      sum(by) {
        switch (by) {
          case 'row':
            return sumByRow(this);
          case 'column':
            return sumByColumn(this);
          case undefined:
            return sumAll(this);
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      product(by) {
        switch (by) {
          case 'row':
            return productByRow(this);
          case 'column':
            return productByColumn(this);
          case undefined:
            return productAll(this);
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      mean(by) {
        const sum = this.sum(by);
        switch (by) {
          case 'row':
            {
              for (let i = 0; i < this.rows; i++) {
                sum[i] /= this.columns;
              }
              return sum;
            }
          case 'column':
            {
              for (let i = 0; i < this.columns; i++) {
                sum[i] /= this.rows;
              }
              return sum;
            }
          case undefined:
            return sum / this.size;
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      variance(by, options = {}) {
        if (typeof by === 'object') {
          options = by;
          by = undefined;
        }
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          unbiased = true,
          mean = this.mean(by)
        } = options;
        if (typeof unbiased !== 'boolean') {
          throw new TypeError('unbiased must be a boolean');
        }
        switch (by) {
          case 'row':
            {
              if (!isAnyArray(mean)) {
                throw new TypeError('mean must be an array');
              }
              return varianceByRow(this, unbiased, mean);
            }
          case 'column':
            {
              if (!isAnyArray(mean)) {
                throw new TypeError('mean must be an array');
              }
              return varianceByColumn(this, unbiased, mean);
            }
          case undefined:
            {
              if (typeof mean !== 'number') {
                throw new TypeError('mean must be a number');
              }
              return varianceAll(this, unbiased, mean);
            }
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      standardDeviation(by, options) {
        if (typeof by === 'object') {
          options = by;
          by = undefined;
        }
        const variance = this.variance(by, options);
        if (by === undefined) {
          return Math.sqrt(variance);
        } else {
          for (let i = 0; i < variance.length; i++) {
            variance[i] = Math.sqrt(variance[i]);
          }
          return variance;
        }
      }
      center(by, options = {}) {
        if (typeof by === 'object') {
          options = by;
          by = undefined;
        }
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          center = this.mean(by)
        } = options;
        switch (by) {
          case 'row':
            {
              if (!isAnyArray(center)) {
                throw new TypeError('center must be an array');
              }
              centerByRow(this, center);
              return this;
            }
          case 'column':
            {
              if (!isAnyArray(center)) {
                throw new TypeError('center must be an array');
              }
              centerByColumn(this, center);
              return this;
            }
          case undefined:
            {
              if (typeof center !== 'number') {
                throw new TypeError('center must be a number');
              }
              centerAll(this, center);
              return this;
            }
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      scale(by, options = {}) {
        if (typeof by === 'object') {
          options = by;
          by = undefined;
        }
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        let scale = options.scale;
        switch (by) {
          case 'row':
            {
              if (scale === undefined) {
                scale = getScaleByRow(this);
              } else if (!isAnyArray(scale)) {
                throw new TypeError('scale must be an array');
              }
              scaleByRow(this, scale);
              return this;
            }
          case 'column':
            {
              if (scale === undefined) {
                scale = getScaleByColumn(this);
              } else if (!isAnyArray(scale)) {
                throw new TypeError('scale must be an array');
              }
              scaleByColumn(this, scale);
              return this;
            }
          case undefined:
            {
              if (scale === undefined) {
                scale = getScaleAll(this);
              } else if (typeof scale !== 'number') {
                throw new TypeError('scale must be a number');
              }
              scaleAll(this, scale);
              return this;
            }
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      toString(options) {
        return inspectMatrixWithOptions(this, options);
      }
    }
    AbstractMatrix.prototype.klass = 'Matrix';
    if (typeof Symbol !== 'undefined') {
      AbstractMatrix.prototype[Symbol.for('nodejs.util.inspect.custom')] = inspectMatrix;
    }
    function compareNumbers(a, b) {
      return a - b;
    }
    function isArrayOfNumbers(array) {
      return array.every(element => {
        return typeof element === 'number';
      });
    }

    // Synonyms
    AbstractMatrix.random = AbstractMatrix.rand;
    AbstractMatrix.randomInt = AbstractMatrix.randInt;
    AbstractMatrix.diagonal = AbstractMatrix.diag;
    AbstractMatrix.prototype.diagonal = AbstractMatrix.prototype.diag;
    AbstractMatrix.identity = AbstractMatrix.eye;
    AbstractMatrix.prototype.negate = AbstractMatrix.prototype.neg;
    AbstractMatrix.prototype.tensorProduct = AbstractMatrix.prototype.kroneckerProduct;
    class Matrix extends AbstractMatrix {
      constructor(nRows, nColumns) {
        super();
        if (Matrix.isMatrix(nRows)) {
          // eslint-disable-next-line no-constructor-return
          return nRows.clone();
        } else if (Number.isInteger(nRows) && nRows >= 0) {
          // Create an empty matrix
          this.data = [];
          if (Number.isInteger(nColumns) && nColumns >= 0) {
            for (let i = 0; i < nRows; i++) {
              this.data.push(new Float64Array(nColumns));
            }
          } else {
            throw new TypeError('nColumns must be a positive integer');
          }
        } else if (isAnyArray(nRows)) {
          // Copy the values from the 2D array
          const arrayData = nRows;
          nRows = arrayData.length;
          nColumns = nRows ? arrayData[0].length : 0;
          if (typeof nColumns !== 'number') {
            throw new TypeError('Data must be a 2D array with at least one element');
          }
          this.data = [];
          for (let i = 0; i < nRows; i++) {
            if (arrayData[i].length !== nColumns) {
              throw new RangeError('Inconsistent array dimensions');
            }
            if (!isArrayOfNumbers(arrayData[i])) {
              throw new TypeError('Input data contains non-numeric values');
            }
            this.data.push(Float64Array.from(arrayData[i]));
          }
        } else {
          throw new TypeError('First argument must be a positive number or an array');
        }
        this.rows = nRows;
        this.columns = nColumns;
      }
      set(rowIndex, columnIndex, value) {
        this.data[rowIndex][columnIndex] = value;
        return this;
      }
      get(rowIndex, columnIndex) {
        return this.data[rowIndex][columnIndex];
      }
      removeRow(index) {
        checkRowIndex(this, index);
        this.data.splice(index, 1);
        this.rows -= 1;
        return this;
      }
      addRow(index, array) {
        if (array === undefined) {
          array = index;
          index = this.rows;
        }
        checkRowIndex(this, index, true);
        array = Float64Array.from(checkRowVector(this, array));
        this.data.splice(index, 0, array);
        this.rows += 1;
        return this;
      }
      removeColumn(index) {
        checkColumnIndex(this, index);
        for (let i = 0; i < this.rows; i++) {
          const newRow = new Float64Array(this.columns - 1);
          for (let j = 0; j < index; j++) {
            newRow[j] = this.data[i][j];
          }
          for (let j = index + 1; j < this.columns; j++) {
            newRow[j - 1] = this.data[i][j];
          }
          this.data[i] = newRow;
        }
        this.columns -= 1;
        return this;
      }
      addColumn(index, array) {
        if (typeof array === 'undefined') {
          array = index;
          index = this.columns;
        }
        checkColumnIndex(this, index, true);
        array = checkColumnVector(this, array);
        for (let i = 0; i < this.rows; i++) {
          const newRow = new Float64Array(this.columns + 1);
          let j = 0;
          for (; j < index; j++) {
            newRow[j] = this.data[i][j];
          }
          newRow[j++] = array[i];
          for (; j < this.columns + 1; j++) {
            newRow[j] = this.data[i][j - 1];
          }
          this.data[i] = newRow;
        }
        this.columns += 1;
        return this;
      }
    }
    installMathOperations(AbstractMatrix, Matrix);

    class BaseView extends AbstractMatrix {
      constructor(matrix, rows, columns) {
        super();
        this.matrix = matrix;
        this.rows = rows;
        this.columns = columns;
      }
    }

    class MatrixTransposeView extends BaseView {
      constructor(matrix) {
        super(matrix, matrix.columns, matrix.rows);
      }
      set(rowIndex, columnIndex, value) {
        this.matrix.set(columnIndex, rowIndex, value);
        return this;
      }
      get(rowIndex, columnIndex) {
        return this.matrix.get(columnIndex, rowIndex);
      }
    }

    class WrapperMatrix2D extends AbstractMatrix {
      constructor(data) {
        super();
        this.data = data;
        this.rows = data.length;
        this.columns = data[0].length;
      }
      set(rowIndex, columnIndex, value) {
        this.data[rowIndex][columnIndex] = value;
        return this;
      }
      get(rowIndex, columnIndex) {
        return this.data[rowIndex][columnIndex];
      }
    }

    class LuDecomposition {
      constructor(matrix) {
        matrix = WrapperMatrix2D.checkMatrix(matrix);
        let lu = matrix.clone();
        let rows = lu.rows;
        let columns = lu.columns;
        let pivotVector = new Float64Array(rows);
        let pivotSign = 1;
        let i, j, k, p, s, t, v;
        let LUcolj, kmax;
        for (i = 0; i < rows; i++) {
          pivotVector[i] = i;
        }
        LUcolj = new Float64Array(rows);
        for (j = 0; j < columns; j++) {
          for (i = 0; i < rows; i++) {
            LUcolj[i] = lu.get(i, j);
          }
          for (i = 0; i < rows; i++) {
            kmax = Math.min(i, j);
            s = 0;
            for (k = 0; k < kmax; k++) {
              s += lu.get(i, k) * LUcolj[k];
            }
            LUcolj[i] -= s;
            lu.set(i, j, LUcolj[i]);
          }
          p = j;
          for (i = j + 1; i < rows; i++) {
            if (Math.abs(LUcolj[i]) > Math.abs(LUcolj[p])) {
              p = i;
            }
          }
          if (p !== j) {
            for (k = 0; k < columns; k++) {
              t = lu.get(p, k);
              lu.set(p, k, lu.get(j, k));
              lu.set(j, k, t);
            }
            v = pivotVector[p];
            pivotVector[p] = pivotVector[j];
            pivotVector[j] = v;
            pivotSign = -pivotSign;
          }
          if (j < rows && lu.get(j, j) !== 0) {
            for (i = j + 1; i < rows; i++) {
              lu.set(i, j, lu.get(i, j) / lu.get(j, j));
            }
          }
        }
        this.LU = lu;
        this.pivotVector = pivotVector;
        this.pivotSign = pivotSign;
      }
      isSingular() {
        let data = this.LU;
        let col = data.columns;
        for (let j = 0; j < col; j++) {
          if (data.get(j, j) === 0) {
            return true;
          }
        }
        return false;
      }
      solve(value) {
        value = Matrix.checkMatrix(value);
        let lu = this.LU;
        let rows = lu.rows;
        if (rows !== value.rows) {
          throw new Error('Invalid matrix dimensions');
        }
        if (this.isSingular()) {
          throw new Error('LU matrix is singular');
        }
        let count = value.columns;
        let X = value.subMatrixRow(this.pivotVector, 0, count - 1);
        let columns = lu.columns;
        let i, j, k;
        for (k = 0; k < columns; k++) {
          for (i = k + 1; i < columns; i++) {
            for (j = 0; j < count; j++) {
              X.set(i, j, X.get(i, j) - X.get(k, j) * lu.get(i, k));
            }
          }
        }
        for (k = columns - 1; k >= 0; k--) {
          for (j = 0; j < count; j++) {
            X.set(k, j, X.get(k, j) / lu.get(k, k));
          }
          for (i = 0; i < k; i++) {
            for (j = 0; j < count; j++) {
              X.set(i, j, X.get(i, j) - X.get(k, j) * lu.get(i, k));
            }
          }
        }
        return X;
      }
      get determinant() {
        let data = this.LU;
        if (!data.isSquare()) {
          throw new Error('Matrix must be square');
        }
        let determinant = this.pivotSign;
        let col = data.columns;
        for (let j = 0; j < col; j++) {
          determinant *= data.get(j, j);
        }
        return determinant;
      }
      get lowerTriangularMatrix() {
        let data = this.LU;
        let rows = data.rows;
        let columns = data.columns;
        let X = new Matrix(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            if (i > j) {
              X.set(i, j, data.get(i, j));
            } else if (i === j) {
              X.set(i, j, 1);
            } else {
              X.set(i, j, 0);
            }
          }
        }
        return X;
      }
      get upperTriangularMatrix() {
        let data = this.LU;
        let rows = data.rows;
        let columns = data.columns;
        let X = new Matrix(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            if (i <= j) {
              X.set(i, j, data.get(i, j));
            } else {
              X.set(i, j, 0);
            }
          }
        }
        return X;
      }
      get pivotPermutationVector() {
        return Array.from(this.pivotVector);
      }
    }

    function hypotenuse(a, b) {
      let r = 0;
      if (Math.abs(a) > Math.abs(b)) {
        r = b / a;
        return Math.abs(a) * Math.sqrt(1 + r * r);
      }
      if (b !== 0) {
        r = a / b;
        return Math.abs(b) * Math.sqrt(1 + r * r);
      }
      return 0;
    }

    class QrDecomposition {
      constructor(value) {
        value = WrapperMatrix2D.checkMatrix(value);
        let qr = value.clone();
        let m = value.rows;
        let n = value.columns;
        let rdiag = new Float64Array(n);
        let i, j, k, s;
        for (k = 0; k < n; k++) {
          let nrm = 0;
          for (i = k; i < m; i++) {
            nrm = hypotenuse(nrm, qr.get(i, k));
          }
          if (nrm !== 0) {
            if (qr.get(k, k) < 0) {
              nrm = -nrm;
            }
            for (i = k; i < m; i++) {
              qr.set(i, k, qr.get(i, k) / nrm);
            }
            qr.set(k, k, qr.get(k, k) + 1);
            for (j = k + 1; j < n; j++) {
              s = 0;
              for (i = k; i < m; i++) {
                s += qr.get(i, k) * qr.get(i, j);
              }
              s = -s / qr.get(k, k);
              for (i = k; i < m; i++) {
                qr.set(i, j, qr.get(i, j) + s * qr.get(i, k));
              }
            }
          }
          rdiag[k] = -nrm;
        }
        this.QR = qr;
        this.Rdiag = rdiag;
      }
      solve(value) {
        value = Matrix.checkMatrix(value);
        let qr = this.QR;
        let m = qr.rows;
        if (value.rows !== m) {
          throw new Error('Matrix row dimensions must agree');
        }
        if (!this.isFullRank()) {
          throw new Error('Matrix is rank deficient');
        }
        let count = value.columns;
        let X = value.clone();
        let n = qr.columns;
        let i, j, k, s;
        for (k = 0; k < n; k++) {
          for (j = 0; j < count; j++) {
            s = 0;
            for (i = k; i < m; i++) {
              s += qr.get(i, k) * X.get(i, j);
            }
            s = -s / qr.get(k, k);
            for (i = k; i < m; i++) {
              X.set(i, j, X.get(i, j) + s * qr.get(i, k));
            }
          }
        }
        for (k = n - 1; k >= 0; k--) {
          for (j = 0; j < count; j++) {
            X.set(k, j, X.get(k, j) / this.Rdiag[k]);
          }
          for (i = 0; i < k; i++) {
            for (j = 0; j < count; j++) {
              X.set(i, j, X.get(i, j) - X.get(k, j) * qr.get(i, k));
            }
          }
        }
        return X.subMatrix(0, n - 1, 0, count - 1);
      }
      isFullRank() {
        let columns = this.QR.columns;
        for (let i = 0; i < columns; i++) {
          if (this.Rdiag[i] === 0) {
            return false;
          }
        }
        return true;
      }
      get upperTriangularMatrix() {
        let qr = this.QR;
        let n = qr.columns;
        let X = new Matrix(n, n);
        let i, j;
        for (i = 0; i < n; i++) {
          for (j = 0; j < n; j++) {
            if (i < j) {
              X.set(i, j, qr.get(i, j));
            } else if (i === j) {
              X.set(i, j, this.Rdiag[i]);
            } else {
              X.set(i, j, 0);
            }
          }
        }
        return X;
      }
      get orthogonalMatrix() {
        let qr = this.QR;
        let rows = qr.rows;
        let columns = qr.columns;
        let X = new Matrix(rows, columns);
        let i, j, k, s;
        for (k = columns - 1; k >= 0; k--) {
          for (i = 0; i < rows; i++) {
            X.set(i, k, 0);
          }
          X.set(k, k, 1);
          for (j = k; j < columns; j++) {
            if (qr.get(k, k) !== 0) {
              s = 0;
              for (i = k; i < rows; i++) {
                s += qr.get(i, k) * X.get(i, j);
              }
              s = -s / qr.get(k, k);
              for (i = k; i < rows; i++) {
                X.set(i, j, X.get(i, j) + s * qr.get(i, k));
              }
            }
          }
        }
        return X;
      }
    }

    class SingularValueDecomposition {
      constructor(value, options = {}) {
        value = WrapperMatrix2D.checkMatrix(value);
        if (value.isEmpty()) {
          throw new Error('Matrix must be non-empty');
        }
        let m = value.rows;
        let n = value.columns;
        const {
          computeLeftSingularVectors = true,
          computeRightSingularVectors = true,
          autoTranspose = false
        } = options;
        let wantu = Boolean(computeLeftSingularVectors);
        let wantv = Boolean(computeRightSingularVectors);
        let swapped = false;
        let a;
        if (m < n) {
          if (!autoTranspose) {
            a = value.clone();
            // eslint-disable-next-line no-console
            console.warn('Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose');
          } else {
            a = value.transpose();
            m = a.rows;
            n = a.columns;
            swapped = true;
            let aux = wantu;
            wantu = wantv;
            wantv = aux;
          }
        } else {
          a = value.clone();
        }
        let nu = Math.min(m, n);
        let ni = Math.min(m + 1, n);
        let s = new Float64Array(ni);
        let U = new Matrix(m, nu);
        let V = new Matrix(n, n);
        let e = new Float64Array(n);
        let work = new Float64Array(m);
        let si = new Float64Array(ni);
        for (let i = 0; i < ni; i++) si[i] = i;
        let nct = Math.min(m - 1, n);
        let nrt = Math.max(0, Math.min(n - 2, m));
        let mrc = Math.max(nct, nrt);
        for (let k = 0; k < mrc; k++) {
          if (k < nct) {
            s[k] = 0;
            for (let i = k; i < m; i++) {
              s[k] = hypotenuse(s[k], a.get(i, k));
            }
            if (s[k] !== 0) {
              if (a.get(k, k) < 0) {
                s[k] = -s[k];
              }
              for (let i = k; i < m; i++) {
                a.set(i, k, a.get(i, k) / s[k]);
              }
              a.set(k, k, a.get(k, k) + 1);
            }
            s[k] = -s[k];
          }
          for (let j = k + 1; j < n; j++) {
            if (k < nct && s[k] !== 0) {
              let t = 0;
              for (let i = k; i < m; i++) {
                t += a.get(i, k) * a.get(i, j);
              }
              t = -t / a.get(k, k);
              for (let i = k; i < m; i++) {
                a.set(i, j, a.get(i, j) + t * a.get(i, k));
              }
            }
            e[j] = a.get(k, j);
          }
          if (wantu && k < nct) {
            for (let i = k; i < m; i++) {
              U.set(i, k, a.get(i, k));
            }
          }
          if (k < nrt) {
            e[k] = 0;
            for (let i = k + 1; i < n; i++) {
              e[k] = hypotenuse(e[k], e[i]);
            }
            if (e[k] !== 0) {
              if (e[k + 1] < 0) {
                e[k] = 0 - e[k];
              }
              for (let i = k + 1; i < n; i++) {
                e[i] /= e[k];
              }
              e[k + 1] += 1;
            }
            e[k] = -e[k];
            if (k + 1 < m && e[k] !== 0) {
              for (let i = k + 1; i < m; i++) {
                work[i] = 0;
              }
              for (let i = k + 1; i < m; i++) {
                for (let j = k + 1; j < n; j++) {
                  work[i] += e[j] * a.get(i, j);
                }
              }
              for (let j = k + 1; j < n; j++) {
                let t = -e[j] / e[k + 1];
                for (let i = k + 1; i < m; i++) {
                  a.set(i, j, a.get(i, j) + t * work[i]);
                }
              }
            }
            if (wantv) {
              for (let i = k + 1; i < n; i++) {
                V.set(i, k, e[i]);
              }
            }
          }
        }
        let p = Math.min(n, m + 1);
        if (nct < n) {
          s[nct] = a.get(nct, nct);
        }
        if (m < p) {
          s[p - 1] = 0;
        }
        if (nrt + 1 < p) {
          e[nrt] = a.get(nrt, p - 1);
        }
        e[p - 1] = 0;
        if (wantu) {
          for (let j = nct; j < nu; j++) {
            for (let i = 0; i < m; i++) {
              U.set(i, j, 0);
            }
            U.set(j, j, 1);
          }
          for (let k = nct - 1; k >= 0; k--) {
            if (s[k] !== 0) {
              for (let j = k + 1; j < nu; j++) {
                let t = 0;
                for (let i = k; i < m; i++) {
                  t += U.get(i, k) * U.get(i, j);
                }
                t = -t / U.get(k, k);
                for (let i = k; i < m; i++) {
                  U.set(i, j, U.get(i, j) + t * U.get(i, k));
                }
              }
              for (let i = k; i < m; i++) {
                U.set(i, k, -U.get(i, k));
              }
              U.set(k, k, 1 + U.get(k, k));
              for (let i = 0; i < k - 1; i++) {
                U.set(i, k, 0);
              }
            } else {
              for (let i = 0; i < m; i++) {
                U.set(i, k, 0);
              }
              U.set(k, k, 1);
            }
          }
        }
        if (wantv) {
          for (let k = n - 1; k >= 0; k--) {
            if (k < nrt && e[k] !== 0) {
              for (let j = k + 1; j < n; j++) {
                let t = 0;
                for (let i = k + 1; i < n; i++) {
                  t += V.get(i, k) * V.get(i, j);
                }
                t = -t / V.get(k + 1, k);
                for (let i = k + 1; i < n; i++) {
                  V.set(i, j, V.get(i, j) + t * V.get(i, k));
                }
              }
            }
            for (let i = 0; i < n; i++) {
              V.set(i, k, 0);
            }
            V.set(k, k, 1);
          }
        }
        let pp = p - 1;
        let eps = Number.EPSILON;
        while (p > 0) {
          let k, kase;
          for (k = p - 2; k >= -1; k--) {
            if (k === -1) {
              break;
            }
            const alpha = Number.MIN_VALUE + eps * Math.abs(s[k] + Math.abs(s[k + 1]));
            if (Math.abs(e[k]) <= alpha || Number.isNaN(e[k])) {
              e[k] = 0;
              break;
            }
          }
          if (k === p - 2) {
            kase = 4;
          } else {
            let ks;
            for (ks = p - 1; ks >= k; ks--) {
              if (ks === k) {
                break;
              }
              let t = (ks !== p ? Math.abs(e[ks]) : 0) + (ks !== k + 1 ? Math.abs(e[ks - 1]) : 0);
              if (Math.abs(s[ks]) <= eps * t) {
                s[ks] = 0;
                break;
              }
            }
            if (ks === k) {
              kase = 3;
            } else if (ks === p - 1) {
              kase = 1;
            } else {
              kase = 2;
              k = ks;
            }
          }
          k++;
          switch (kase) {
            case 1:
              {
                let f = e[p - 2];
                e[p - 2] = 0;
                for (let j = p - 2; j >= k; j--) {
                  let t = hypotenuse(s[j], f);
                  let cs = s[j] / t;
                  let sn = f / t;
                  s[j] = t;
                  if (j !== k) {
                    f = -sn * e[j - 1];
                    e[j - 1] = cs * e[j - 1];
                  }
                  if (wantv) {
                    for (let i = 0; i < n; i++) {
                      t = cs * V.get(i, j) + sn * V.get(i, p - 1);
                      V.set(i, p - 1, -sn * V.get(i, j) + cs * V.get(i, p - 1));
                      V.set(i, j, t);
                    }
                  }
                }
                break;
              }
            case 2:
              {
                let f = e[k - 1];
                e[k - 1] = 0;
                for (let j = k; j < p; j++) {
                  let t = hypotenuse(s[j], f);
                  let cs = s[j] / t;
                  let sn = f / t;
                  s[j] = t;
                  f = -sn * e[j];
                  e[j] = cs * e[j];
                  if (wantu) {
                    for (let i = 0; i < m; i++) {
                      t = cs * U.get(i, j) + sn * U.get(i, k - 1);
                      U.set(i, k - 1, -sn * U.get(i, j) + cs * U.get(i, k - 1));
                      U.set(i, j, t);
                    }
                  }
                }
                break;
              }
            case 3:
              {
                const scale = Math.max(Math.abs(s[p - 1]), Math.abs(s[p - 2]), Math.abs(e[p - 2]), Math.abs(s[k]), Math.abs(e[k]));
                const sp = s[p - 1] / scale;
                const spm1 = s[p - 2] / scale;
                const epm1 = e[p - 2] / scale;
                const sk = s[k] / scale;
                const ek = e[k] / scale;
                const b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2;
                const c = sp * epm1 * (sp * epm1);
                let shift = 0;
                if (b !== 0 || c !== 0) {
                  if (b < 0) {
                    shift = 0 - Math.sqrt(b * b + c);
                  } else {
                    shift = Math.sqrt(b * b + c);
                  }
                  shift = c / (b + shift);
                }
                let f = (sk + sp) * (sk - sp) + shift;
                let g = sk * ek;
                for (let j = k; j < p - 1; j++) {
                  let t = hypotenuse(f, g);
                  if (t === 0) t = Number.MIN_VALUE;
                  let cs = f / t;
                  let sn = g / t;
                  if (j !== k) {
                    e[j - 1] = t;
                  }
                  f = cs * s[j] + sn * e[j];
                  e[j] = cs * e[j] - sn * s[j];
                  g = sn * s[j + 1];
                  s[j + 1] = cs * s[j + 1];
                  if (wantv) {
                    for (let i = 0; i < n; i++) {
                      t = cs * V.get(i, j) + sn * V.get(i, j + 1);
                      V.set(i, j + 1, -sn * V.get(i, j) + cs * V.get(i, j + 1));
                      V.set(i, j, t);
                    }
                  }
                  t = hypotenuse(f, g);
                  if (t === 0) t = Number.MIN_VALUE;
                  cs = f / t;
                  sn = g / t;
                  s[j] = t;
                  f = cs * e[j] + sn * s[j + 1];
                  s[j + 1] = -sn * e[j] + cs * s[j + 1];
                  g = sn * e[j + 1];
                  e[j + 1] = cs * e[j + 1];
                  if (wantu && j < m - 1) {
                    for (let i = 0; i < m; i++) {
                      t = cs * U.get(i, j) + sn * U.get(i, j + 1);
                      U.set(i, j + 1, -sn * U.get(i, j) + cs * U.get(i, j + 1));
                      U.set(i, j, t);
                    }
                  }
                }
                e[p - 2] = f;
                break;
              }
            case 4:
              {
                if (s[k] <= 0) {
                  s[k] = s[k] < 0 ? -s[k] : 0;
                  if (wantv) {
                    for (let i = 0; i <= pp; i++) {
                      V.set(i, k, -V.get(i, k));
                    }
                  }
                }
                while (k < pp) {
                  if (s[k] >= s[k + 1]) {
                    break;
                  }
                  let t = s[k];
                  s[k] = s[k + 1];
                  s[k + 1] = t;
                  if (wantv && k < n - 1) {
                    for (let i = 0; i < n; i++) {
                      t = V.get(i, k + 1);
                      V.set(i, k + 1, V.get(i, k));
                      V.set(i, k, t);
                    }
                  }
                  if (wantu && k < m - 1) {
                    for (let i = 0; i < m; i++) {
                      t = U.get(i, k + 1);
                      U.set(i, k + 1, U.get(i, k));
                      U.set(i, k, t);
                    }
                  }
                  k++;
                }
                p--;
                break;
              }
            // no default
          }
        }

        if (swapped) {
          let tmp = V;
          V = U;
          U = tmp;
        }
        this.m = m;
        this.n = n;
        this.s = s;
        this.U = U;
        this.V = V;
      }
      solve(value) {
        let Y = value;
        let e = this.threshold;
        let scols = this.s.length;
        let Ls = Matrix.zeros(scols, scols);
        for (let i = 0; i < scols; i++) {
          if (Math.abs(this.s[i]) <= e) {
            Ls.set(i, i, 0);
          } else {
            Ls.set(i, i, 1 / this.s[i]);
          }
        }
        let U = this.U;
        let V = this.rightSingularVectors;
        let VL = V.mmul(Ls);
        let vrows = V.rows;
        let urows = U.rows;
        let VLU = Matrix.zeros(vrows, urows);
        for (let i = 0; i < vrows; i++) {
          for (let j = 0; j < urows; j++) {
            let sum = 0;
            for (let k = 0; k < scols; k++) {
              sum += VL.get(i, k) * U.get(j, k);
            }
            VLU.set(i, j, sum);
          }
        }
        return VLU.mmul(Y);
      }
      solveForDiagonal(value) {
        return this.solve(Matrix.diag(value));
      }
      inverse() {
        let V = this.V;
        let e = this.threshold;
        let vrows = V.rows;
        let vcols = V.columns;
        let X = new Matrix(vrows, this.s.length);
        for (let i = 0; i < vrows; i++) {
          for (let j = 0; j < vcols; j++) {
            if (Math.abs(this.s[j]) > e) {
              X.set(i, j, V.get(i, j) / this.s[j]);
            }
          }
        }
        let U = this.U;
        let urows = U.rows;
        let ucols = U.columns;
        let Y = new Matrix(vrows, urows);
        for (let i = 0; i < vrows; i++) {
          for (let j = 0; j < urows; j++) {
            let sum = 0;
            for (let k = 0; k < ucols; k++) {
              sum += X.get(i, k) * U.get(j, k);
            }
            Y.set(i, j, sum);
          }
        }
        return Y;
      }
      get condition() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
      }
      get norm2() {
        return this.s[0];
      }
      get rank() {
        let tol = Math.max(this.m, this.n) * this.s[0] * Number.EPSILON;
        let r = 0;
        let s = this.s;
        for (let i = 0, ii = s.length; i < ii; i++) {
          if (s[i] > tol) {
            r++;
          }
        }
        return r;
      }
      get diagonal() {
        return Array.from(this.s);
      }
      get threshold() {
        return Number.EPSILON / 2 * Math.max(this.m, this.n) * this.s[0];
      }
      get leftSingularVectors() {
        return this.U;
      }
      get rightSingularVectors() {
        return this.V;
      }
      get diagonalMatrix() {
        return Matrix.diag(this.s);
      }
    }

    function inverse(matrix, useSVD = false) {
      matrix = WrapperMatrix2D.checkMatrix(matrix);
      if (useSVD) {
        return new SingularValueDecomposition(matrix).inverse();
      } else {
        return solve(matrix, Matrix.eye(matrix.rows));
      }
    }
    function solve(leftHandSide, rightHandSide, useSVD = false) {
      leftHandSide = WrapperMatrix2D.checkMatrix(leftHandSide);
      rightHandSide = WrapperMatrix2D.checkMatrix(rightHandSide);
      if (useSVD) {
        return new SingularValueDecomposition(leftHandSide).solve(rightHandSide);
      } else {
        return leftHandSide.isSquare() ? new LuDecomposition(leftHandSide).solve(rightHandSide) : new QrDecomposition(leftHandSide).solve(rightHandSide);
      }
    }

    class EigenvalueDecomposition {
      constructor(matrix, options = {}) {
        const {
          assumeSymmetric = false
        } = options;
        matrix = WrapperMatrix2D.checkMatrix(matrix);
        if (!matrix.isSquare()) {
          throw new Error('Matrix is not a square matrix');
        }
        if (matrix.isEmpty()) {
          throw new Error('Matrix must be non-empty');
        }
        let n = matrix.columns;
        let V = new Matrix(n, n);
        let d = new Float64Array(n);
        let e = new Float64Array(n);
        let value = matrix;
        let i, j;
        let isSymmetric = false;
        if (assumeSymmetric) {
          isSymmetric = true;
        } else {
          isSymmetric = matrix.isSymmetric();
        }
        if (isSymmetric) {
          for (i = 0; i < n; i++) {
            for (j = 0; j < n; j++) {
              V.set(i, j, value.get(i, j));
            }
          }
          tred2(n, e, d, V);
          tql2(n, e, d, V);
        } else {
          let H = new Matrix(n, n);
          let ort = new Float64Array(n);
          for (j = 0; j < n; j++) {
            for (i = 0; i < n; i++) {
              H.set(i, j, value.get(i, j));
            }
          }
          orthes(n, H, ort, V);
          hqr2(n, e, d, V, H);
        }
        this.n = n;
        this.e = e;
        this.d = d;
        this.V = V;
      }
      get realEigenvalues() {
        return Array.from(this.d);
      }
      get imaginaryEigenvalues() {
        return Array.from(this.e);
      }
      get eigenvectorMatrix() {
        return this.V;
      }
      get diagonalMatrix() {
        let n = this.n;
        let e = this.e;
        let d = this.d;
        let X = new Matrix(n, n);
        let i, j;
        for (i = 0; i < n; i++) {
          for (j = 0; j < n; j++) {
            X.set(i, j, 0);
          }
          X.set(i, i, d[i]);
          if (e[i] > 0) {
            X.set(i, i + 1, e[i]);
          } else if (e[i] < 0) {
            X.set(i, i - 1, e[i]);
          }
        }
        return X;
      }
    }
    function tred2(n, e, d, V) {
      let f, g, h, i, j, k, hh, scale;
      for (j = 0; j < n; j++) {
        d[j] = V.get(n - 1, j);
      }
      for (i = n - 1; i > 0; i--) {
        scale = 0;
        h = 0;
        for (k = 0; k < i; k++) {
          scale = scale + Math.abs(d[k]);
        }
        if (scale === 0) {
          e[i] = d[i - 1];
          for (j = 0; j < i; j++) {
            d[j] = V.get(i - 1, j);
            V.set(i, j, 0);
            V.set(j, i, 0);
          }
        } else {
          for (k = 0; k < i; k++) {
            d[k] /= scale;
            h += d[k] * d[k];
          }
          f = d[i - 1];
          g = Math.sqrt(h);
          if (f > 0) {
            g = -g;
          }
          e[i] = scale * g;
          h = h - f * g;
          d[i - 1] = f - g;
          for (j = 0; j < i; j++) {
            e[j] = 0;
          }
          for (j = 0; j < i; j++) {
            f = d[j];
            V.set(j, i, f);
            g = e[j] + V.get(j, j) * f;
            for (k = j + 1; k <= i - 1; k++) {
              g += V.get(k, j) * d[k];
              e[k] += V.get(k, j) * f;
            }
            e[j] = g;
          }
          f = 0;
          for (j = 0; j < i; j++) {
            e[j] /= h;
            f += e[j] * d[j];
          }
          hh = f / (h + h);
          for (j = 0; j < i; j++) {
            e[j] -= hh * d[j];
          }
          for (j = 0; j < i; j++) {
            f = d[j];
            g = e[j];
            for (k = j; k <= i - 1; k++) {
              V.set(k, j, V.get(k, j) - (f * e[k] + g * d[k]));
            }
            d[j] = V.get(i - 1, j);
            V.set(i, j, 0);
          }
        }
        d[i] = h;
      }
      for (i = 0; i < n - 1; i++) {
        V.set(n - 1, i, V.get(i, i));
        V.set(i, i, 1);
        h = d[i + 1];
        if (h !== 0) {
          for (k = 0; k <= i; k++) {
            d[k] = V.get(k, i + 1) / h;
          }
          for (j = 0; j <= i; j++) {
            g = 0;
            for (k = 0; k <= i; k++) {
              g += V.get(k, i + 1) * V.get(k, j);
            }
            for (k = 0; k <= i; k++) {
              V.set(k, j, V.get(k, j) - g * d[k]);
            }
          }
        }
        for (k = 0; k <= i; k++) {
          V.set(k, i + 1, 0);
        }
      }
      for (j = 0; j < n; j++) {
        d[j] = V.get(n - 1, j);
        V.set(n - 1, j, 0);
      }
      V.set(n - 1, n - 1, 1);
      e[0] = 0;
    }
    function tql2(n, e, d, V) {
      let g, h, i, j, k, l, m, p, r, dl1, c, c2, c3, el1, s, s2;
      for (i = 1; i < n; i++) {
        e[i - 1] = e[i];
      }
      e[n - 1] = 0;
      let f = 0;
      let tst1 = 0;
      let eps = Number.EPSILON;
      for (l = 0; l < n; l++) {
        tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
        m = l;
        while (m < n) {
          if (Math.abs(e[m]) <= eps * tst1) {
            break;
          }
          m++;
        }
        if (m > l) {
          do {
            g = d[l];
            p = (d[l + 1] - g) / (2 * e[l]);
            r = hypotenuse(p, 1);
            if (p < 0) {
              r = -r;
            }
            d[l] = e[l] / (p + r);
            d[l + 1] = e[l] * (p + r);
            dl1 = d[l + 1];
            h = g - d[l];
            for (i = l + 2; i < n; i++) {
              d[i] -= h;
            }
            f = f + h;
            p = d[m];
            c = 1;
            c2 = c;
            c3 = c;
            el1 = e[l + 1];
            s = 0;
            s2 = 0;
            for (i = m - 1; i >= l; i--) {
              c3 = c2;
              c2 = c;
              s2 = s;
              g = c * e[i];
              h = c * p;
              r = hypotenuse(p, e[i]);
              e[i + 1] = s * r;
              s = e[i] / r;
              c = p / r;
              p = c * d[i] - s * g;
              d[i + 1] = h + s * (c * g + s * d[i]);
              for (k = 0; k < n; k++) {
                h = V.get(k, i + 1);
                V.set(k, i + 1, s * V.get(k, i) + c * h);
                V.set(k, i, c * V.get(k, i) - s * h);
              }
            }
            p = -s * s2 * c3 * el1 * e[l] / dl1;
            e[l] = s * p;
            d[l] = c * p;
          } while (Math.abs(e[l]) > eps * tst1);
        }
        d[l] = d[l] + f;
        e[l] = 0;
      }
      for (i = 0; i < n - 1; i++) {
        k = i;
        p = d[i];
        for (j = i + 1; j < n; j++) {
          if (d[j] < p) {
            k = j;
            p = d[j];
          }
        }
        if (k !== i) {
          d[k] = d[i];
          d[i] = p;
          for (j = 0; j < n; j++) {
            p = V.get(j, i);
            V.set(j, i, V.get(j, k));
            V.set(j, k, p);
          }
        }
      }
    }
    function orthes(n, H, ort, V) {
      let low = 0;
      let high = n - 1;
      let f, g, h, i, j, m;
      let scale;
      for (m = low + 1; m <= high - 1; m++) {
        scale = 0;
        for (i = m; i <= high; i++) {
          scale = scale + Math.abs(H.get(i, m - 1));
        }
        if (scale !== 0) {
          h = 0;
          for (i = high; i >= m; i--) {
            ort[i] = H.get(i, m - 1) / scale;
            h += ort[i] * ort[i];
          }
          g = Math.sqrt(h);
          if (ort[m] > 0) {
            g = -g;
          }
          h = h - ort[m] * g;
          ort[m] = ort[m] - g;
          for (j = m; j < n; j++) {
            f = 0;
            for (i = high; i >= m; i--) {
              f += ort[i] * H.get(i, j);
            }
            f = f / h;
            for (i = m; i <= high; i++) {
              H.set(i, j, H.get(i, j) - f * ort[i]);
            }
          }
          for (i = 0; i <= high; i++) {
            f = 0;
            for (j = high; j >= m; j--) {
              f += ort[j] * H.get(i, j);
            }
            f = f / h;
            for (j = m; j <= high; j++) {
              H.set(i, j, H.get(i, j) - f * ort[j]);
            }
          }
          ort[m] = scale * ort[m];
          H.set(m, m - 1, scale * g);
        }
      }
      for (i = 0; i < n; i++) {
        for (j = 0; j < n; j++) {
          V.set(i, j, i === j ? 1 : 0);
        }
      }
      for (m = high - 1; m >= low + 1; m--) {
        if (H.get(m, m - 1) !== 0) {
          for (i = m + 1; i <= high; i++) {
            ort[i] = H.get(i, m - 1);
          }
          for (j = m; j <= high; j++) {
            g = 0;
            for (i = m; i <= high; i++) {
              g += ort[i] * V.get(i, j);
            }
            g = g / ort[m] / H.get(m, m - 1);
            for (i = m; i <= high; i++) {
              V.set(i, j, V.get(i, j) + g * ort[i]);
            }
          }
        }
      }
    }
    function hqr2(nn, e, d, V, H) {
      let n = nn - 1;
      let low = 0;
      let high = nn - 1;
      let eps = Number.EPSILON;
      let exshift = 0;
      let norm = 0;
      let p = 0;
      let q = 0;
      let r = 0;
      let s = 0;
      let z = 0;
      let iter = 0;
      let i, j, k, l, m, t, w, x, y;
      let ra, sa, vr, vi;
      let notlast, cdivres;
      for (i = 0; i < nn; i++) {
        if (i < low || i > high) {
          d[i] = H.get(i, i);
          e[i] = 0;
        }
        for (j = Math.max(i - 1, 0); j < nn; j++) {
          norm = norm + Math.abs(H.get(i, j));
        }
      }
      while (n >= low) {
        l = n;
        while (l > low) {
          s = Math.abs(H.get(l - 1, l - 1)) + Math.abs(H.get(l, l));
          if (s === 0) {
            s = norm;
          }
          if (Math.abs(H.get(l, l - 1)) < eps * s) {
            break;
          }
          l--;
        }
        if (l === n) {
          H.set(n, n, H.get(n, n) + exshift);
          d[n] = H.get(n, n);
          e[n] = 0;
          n--;
          iter = 0;
        } else if (l === n - 1) {
          w = H.get(n, n - 1) * H.get(n - 1, n);
          p = (H.get(n - 1, n - 1) - H.get(n, n)) / 2;
          q = p * p + w;
          z = Math.sqrt(Math.abs(q));
          H.set(n, n, H.get(n, n) + exshift);
          H.set(n - 1, n - 1, H.get(n - 1, n - 1) + exshift);
          x = H.get(n, n);
          if (q >= 0) {
            z = p >= 0 ? p + z : p - z;
            d[n - 1] = x + z;
            d[n] = d[n - 1];
            if (z !== 0) {
              d[n] = x - w / z;
            }
            e[n - 1] = 0;
            e[n] = 0;
            x = H.get(n, n - 1);
            s = Math.abs(x) + Math.abs(z);
            p = x / s;
            q = z / s;
            r = Math.sqrt(p * p + q * q);
            p = p / r;
            q = q / r;
            for (j = n - 1; j < nn; j++) {
              z = H.get(n - 1, j);
              H.set(n - 1, j, q * z + p * H.get(n, j));
              H.set(n, j, q * H.get(n, j) - p * z);
            }
            for (i = 0; i <= n; i++) {
              z = H.get(i, n - 1);
              H.set(i, n - 1, q * z + p * H.get(i, n));
              H.set(i, n, q * H.get(i, n) - p * z);
            }
            for (i = low; i <= high; i++) {
              z = V.get(i, n - 1);
              V.set(i, n - 1, q * z + p * V.get(i, n));
              V.set(i, n, q * V.get(i, n) - p * z);
            }
          } else {
            d[n - 1] = x + p;
            d[n] = x + p;
            e[n - 1] = z;
            e[n] = -z;
          }
          n = n - 2;
          iter = 0;
        } else {
          x = H.get(n, n);
          y = 0;
          w = 0;
          if (l < n) {
            y = H.get(n - 1, n - 1);
            w = H.get(n, n - 1) * H.get(n - 1, n);
          }
          if (iter === 10) {
            exshift += x;
            for (i = low; i <= n; i++) {
              H.set(i, i, H.get(i, i) - x);
            }
            s = Math.abs(H.get(n, n - 1)) + Math.abs(H.get(n - 1, n - 2));
            x = y = 0.75 * s;
            w = -0.4375 * s * s;
          }
          if (iter === 30) {
            s = (y - x) / 2;
            s = s * s + w;
            if (s > 0) {
              s = Math.sqrt(s);
              if (y < x) {
                s = -s;
              }
              s = x - w / ((y - x) / 2 + s);
              for (i = low; i <= n; i++) {
                H.set(i, i, H.get(i, i) - s);
              }
              exshift += s;
              x = y = w = 0.964;
            }
          }
          iter = iter + 1;
          m = n - 2;
          while (m >= l) {
            z = H.get(m, m);
            r = x - z;
            s = y - z;
            p = (r * s - w) / H.get(m + 1, m) + H.get(m, m + 1);
            q = H.get(m + 1, m + 1) - z - r - s;
            r = H.get(m + 2, m + 1);
            s = Math.abs(p) + Math.abs(q) + Math.abs(r);
            p = p / s;
            q = q / s;
            r = r / s;
            if (m === l) {
              break;
            }
            if (Math.abs(H.get(m, m - 1)) * (Math.abs(q) + Math.abs(r)) < eps * (Math.abs(p) * (Math.abs(H.get(m - 1, m - 1)) + Math.abs(z) + Math.abs(H.get(m + 1, m + 1))))) {
              break;
            }
            m--;
          }
          for (i = m + 2; i <= n; i++) {
            H.set(i, i - 2, 0);
            if (i > m + 2) {
              H.set(i, i - 3, 0);
            }
          }
          for (k = m; k <= n - 1; k++) {
            notlast = k !== n - 1;
            if (k !== m) {
              p = H.get(k, k - 1);
              q = H.get(k + 1, k - 1);
              r = notlast ? H.get(k + 2, k - 1) : 0;
              x = Math.abs(p) + Math.abs(q) + Math.abs(r);
              if (x !== 0) {
                p = p / x;
                q = q / x;
                r = r / x;
              }
            }
            if (x === 0) {
              break;
            }
            s = Math.sqrt(p * p + q * q + r * r);
            if (p < 0) {
              s = -s;
            }
            if (s !== 0) {
              if (k !== m) {
                H.set(k, k - 1, -s * x);
              } else if (l !== m) {
                H.set(k, k - 1, -H.get(k, k - 1));
              }
              p = p + s;
              x = p / s;
              y = q / s;
              z = r / s;
              q = q / p;
              r = r / p;
              for (j = k; j < nn; j++) {
                p = H.get(k, j) + q * H.get(k + 1, j);
                if (notlast) {
                  p = p + r * H.get(k + 2, j);
                  H.set(k + 2, j, H.get(k + 2, j) - p * z);
                }
                H.set(k, j, H.get(k, j) - p * x);
                H.set(k + 1, j, H.get(k + 1, j) - p * y);
              }
              for (i = 0; i <= Math.min(n, k + 3); i++) {
                p = x * H.get(i, k) + y * H.get(i, k + 1);
                if (notlast) {
                  p = p + z * H.get(i, k + 2);
                  H.set(i, k + 2, H.get(i, k + 2) - p * r);
                }
                H.set(i, k, H.get(i, k) - p);
                H.set(i, k + 1, H.get(i, k + 1) - p * q);
              }
              for (i = low; i <= high; i++) {
                p = x * V.get(i, k) + y * V.get(i, k + 1);
                if (notlast) {
                  p = p + z * V.get(i, k + 2);
                  V.set(i, k + 2, V.get(i, k + 2) - p * r);
                }
                V.set(i, k, V.get(i, k) - p);
                V.set(i, k + 1, V.get(i, k + 1) - p * q);
              }
            }
          }
        }
      }
      if (norm === 0) {
        return;
      }
      for (n = nn - 1; n >= 0; n--) {
        p = d[n];
        q = e[n];
        if (q === 0) {
          l = n;
          H.set(n, n, 1);
          for (i = n - 1; i >= 0; i--) {
            w = H.get(i, i) - p;
            r = 0;
            for (j = l; j <= n; j++) {
              r = r + H.get(i, j) * H.get(j, n);
            }
            if (e[i] < 0) {
              z = w;
              s = r;
            } else {
              l = i;
              if (e[i] === 0) {
                H.set(i, n, w !== 0 ? -r / w : -r / (eps * norm));
              } else {
                x = H.get(i, i + 1);
                y = H.get(i + 1, i);
                q = (d[i] - p) * (d[i] - p) + e[i] * e[i];
                t = (x * s - z * r) / q;
                H.set(i, n, t);
                H.set(i + 1, n, Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z);
              }
              t = Math.abs(H.get(i, n));
              if (eps * t * t > 1) {
                for (j = i; j <= n; j++) {
                  H.set(j, n, H.get(j, n) / t);
                }
              }
            }
          }
        } else if (q < 0) {
          l = n - 1;
          if (Math.abs(H.get(n, n - 1)) > Math.abs(H.get(n - 1, n))) {
            H.set(n - 1, n - 1, q / H.get(n, n - 1));
            H.set(n - 1, n, -(H.get(n, n) - p) / H.get(n, n - 1));
          } else {
            cdivres = cdiv(0, -H.get(n - 1, n), H.get(n - 1, n - 1) - p, q);
            H.set(n - 1, n - 1, cdivres[0]);
            H.set(n - 1, n, cdivres[1]);
          }
          H.set(n, n - 1, 0);
          H.set(n, n, 1);
          for (i = n - 2; i >= 0; i--) {
            ra = 0;
            sa = 0;
            for (j = l; j <= n; j++) {
              ra = ra + H.get(i, j) * H.get(j, n - 1);
              sa = sa + H.get(i, j) * H.get(j, n);
            }
            w = H.get(i, i) - p;
            if (e[i] < 0) {
              z = w;
              r = ra;
              s = sa;
            } else {
              l = i;
              if (e[i] === 0) {
                cdivres = cdiv(-ra, -sa, w, q);
                H.set(i, n - 1, cdivres[0]);
                H.set(i, n, cdivres[1]);
              } else {
                x = H.get(i, i + 1);
                y = H.get(i + 1, i);
                vr = (d[i] - p) * (d[i] - p) + e[i] * e[i] - q * q;
                vi = (d[i] - p) * 2 * q;
                if (vr === 0 && vi === 0) {
                  vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                }
                cdivres = cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                H.set(i, n - 1, cdivres[0]);
                H.set(i, n, cdivres[1]);
                if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                  H.set(i + 1, n - 1, (-ra - w * H.get(i, n - 1) + q * H.get(i, n)) / x);
                  H.set(i + 1, n, (-sa - w * H.get(i, n) - q * H.get(i, n - 1)) / x);
                } else {
                  cdivres = cdiv(-r - y * H.get(i, n - 1), -s - y * H.get(i, n), z, q);
                  H.set(i + 1, n - 1, cdivres[0]);
                  H.set(i + 1, n, cdivres[1]);
                }
              }
              t = Math.max(Math.abs(H.get(i, n - 1)), Math.abs(H.get(i, n)));
              if (eps * t * t > 1) {
                for (j = i; j <= n; j++) {
                  H.set(j, n - 1, H.get(j, n - 1) / t);
                  H.set(j, n, H.get(j, n) / t);
                }
              }
            }
          }
        }
      }
      for (i = 0; i < nn; i++) {
        if (i < low || i > high) {
          for (j = i; j < nn; j++) {
            V.set(i, j, H.get(i, j));
          }
        }
      }
      for (j = nn - 1; j >= low; j--) {
        for (i = low; i <= high; i++) {
          z = 0;
          for (k = low; k <= Math.min(j, high); k++) {
            z = z + V.get(i, k) * H.get(k, j);
          }
          V.set(i, j, z);
        }
      }
    }
    function cdiv(xr, xi, yr, yi) {
      let r, d;
      if (Math.abs(yr) > Math.abs(yi)) {
        r = yi / yr;
        d = yr + r * yi;
        return [(xr + r * xi) / d, (xi - r * xr) / d];
      } else {
        r = yr / yi;
        d = yi + r * yr;
        return [(r * xr + xi) / d, (r * xi - xr) / d];
      }
    }

    /**
     * Returns a copy of the data as Float64
     *
     * @param array - array of numbers
     */
    function xEnsureFloat64(array) {
      xCheck(array);
      if (array instanceof Float64Array) {
        return array.slice(0);
      }
      return Float64Array.from(array);
    }

    /**
     * Returns the closest index of a `target`
     *
     * @param array - array of numbers
     * @param target - target
     * @returns - closest index
     */
    function xFindClosestIndex(array, target, options = {}) {
      const {
        sorted = true
      } = options;
      if (sorted) {
        let low = 0;
        let high = array.length - 1;
        let middle = 0;
        while (high - low > 1) {
          middle = low + (high - low >> 1);
          if (array[middle] < target) {
            low = middle;
          } else if (array[middle] > target) {
            high = middle;
          } else {
            return middle;
          }
        }
        if (low < array.length - 1) {
          if (Math.abs(target - array[low]) < Math.abs(array[low + 1] - target)) {
            return low;
          } else {
            return low + 1;
          }
        } else {
          return low;
        }
      } else {
        let index = 0;
        let diff = Number.POSITIVE_INFINITY;
        for (let i = 0; i < array.length; i++) {
          const currentDiff = Math.abs(array[i] - target);
          if (currentDiff < diff) {
            diff = currentDiff;
            index = i;
          }
        }
        return index;
      }
    }

    /**
     * Returns an object with {fromIndex, toIndex} for a specific from / to
     *
     * @param x - array of numbers
     * @param options - Options
     */
    function xGetFromToIndex(x, options = {}) {
      let {
        fromIndex,
        toIndex,
        from,
        to
      } = options;
      if (fromIndex === undefined) {
        if (from !== undefined) {
          fromIndex = xFindClosestIndex(x, from);
        } else {
          fromIndex = 0;
        }
      }
      if (toIndex === undefined) {
        if (to !== undefined) {
          toIndex = xFindClosestIndex(x, to);
        } else {
          toIndex = x.length - 1;
        }
      }
      if (fromIndex < 0) fromIndex = 0;
      if (toIndex < 0) toIndex = 0;
      if (fromIndex >= x.length) fromIndex = x.length - 1;
      if (toIndex >= x.length) toIndex = x.length - 1;
      if (fromIndex > toIndex) [fromIndex, toIndex] = [toIndex, fromIndex];
      return {
        fromIndex,
        toIndex
      };
    }

    /**
     * Computes the maximal value of an array of values
     *
     * @param array - array of numbers
     * @param options - options
     */
    function xMaxValue(array, options = {}) {
      xCheck(array);
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(array, options);
      let maxValue = array[fromIndex];
      for (let i = fromIndex + 1; i <= toIndex; i++) {
        if (array[i] > maxValue) {
          maxValue = array[i];
        }
      }
      return maxValue;
    }

    /**
     * Computes the minimal value of an array of values
     *
     * @param array - array of numbers
     * @param options - options
     */
    function xMinValue(array, options = {}) {
      xCheck(array);
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(array, options);
      let minValue = array[fromIndex];
      for (let i = fromIndex + 1; i <= toIndex; i++) {
        if (array[i] < minValue) {
          minValue = array[i];
        }
      }
      return minValue;
    }

    /**
     * Check if the values are separated always by the same difference
     *
     * @param array - Monotone growing array of number
     */
    function xIsEquallySpaced(array, options = {}) {
      if (array.length < 3) return true;
      const {
        tolerance = 0.05
      } = options;
      let maxDx = 0;
      let minDx = Number.MAX_SAFE_INTEGER;
      for (let i = 0; i < array.length - 1; ++i) {
        let absoluteDifference = array[i + 1] - array[i];
        if (absoluteDifference < minDx) {
          minDx = absoluteDifference;
        }
        if (absoluteDifference > maxDx) {
          maxDx = absoluteDifference;
        }
      }
      return (maxDx - minDx) / maxDx < tolerance;
    }

    /**
     * Returns true if x is monotone
     *
     * @param array - array of numbers
     */
    function xIsMonotonic(array) {
      if (array.length <= 2) {
        return 1;
      }
      if (array[0] === array[1]) {
        // maybe a constant series
        for (let i = 1; i < array.length - 1; i++) {
          if (array[i] !== array[i + 1]) return 0;
        }
        return 1;
      }
      if (array[0] < array[array.length - 1]) {
        for (let i = 0; i < array.length - 1; i++) {
          if (array[i] >= array[i + 1]) return 0;
        }
        return 1;
      } else {
        for (let i = 0; i < array.length - 1; i++) {
          if (array[i] <= array[i + 1]) return 0;
        }
        return -1;
      }
    }

    /**
     * Computes the mean value of an array of values
     *
     * @param array - array of numbers
     * @param options - options
     */
    function xMean(array, options = {}) {
      xCheck(array);
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(array, options);
      let sumValue = array[fromIndex];
      for (let i = fromIndex + 1; i <= toIndex; i++) {
        sumValue += array[i];
      }
      return sumValue / (toIndex - fromIndex + 1);
    }

    /**
     * This function calculates the median absolute deviation (MAD)
     * https://en.wikipedia.org/wiki/Median_absolute_deviation
     * @param array
     */
    function xMedianAbsoluteDeviation(array) {
      const median = xMedian(array);
      const averageDeviations = new Float64Array(array.length);
      for (let i = 0; i < array.length; i++) {
        averageDeviations[i] = Math.abs(array[i] - median);
      }
      return {
        median,
        mad: xMedian(averageDeviations)
      };
    }

    /**
     * Return min and max values of an array
     *
     * @param array - array of number
     * @returns - Object with 2 properties, min and max
     */
    function xMinMaxValues(array) {
      xCheck(array);
      let min = array[0];
      let max = array[0];
      for (let value of array) {
        if (value < min) min = value;
        if (value > max) max = value;
      }
      return {
        min,
        max
      };
    }

    /**
     * Determine noise level using MAD https://en.wikipedia.org/wiki/Median_absolute_deviation
     * Constant to convert mad to sd calculated using https://www.wolframalpha.com/input?i=sqrt%282%29+inverse+erf%280.5%29
     * This assumes a gaussian distribution of the noise
     * @param array
     * @returns noise level corresponding to one standard deviation
     */
    function xNoiseStandardDeviation(array) {
      const {
        mad,
        median
      } = xMedianAbsoluteDeviation(array);
      return {
        sd: mad / 0.6744897501960817,
        mad,
        median
      };
    }

    /**
     * This function calculate the norm of a vector
     *
     * @example xNorm([3, 4]) -> 5
     * @param array - array
     * @returns - calculated norm
     */
    function xNorm(array) {
      let result = 0;
      for (const element of array) {
        result += element ** 2;
      }
      return Math.sqrt(result);
    }

    /**
     * Calculate the sum of the values
     *
     * @param array - Object that contains property x (an ordered increasing array) and y (an array).
     * @param options - Options.
     * @returns XSum value on the specified range.
     */
    function xSum(array, options = {}) {
      xCheck(array);
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(array, options);
      let sumValue = array[fromIndex];
      for (let i = fromIndex + 1; i <= toIndex; i++) {
        sumValue += array[i];
      }
      return sumValue;
    }

    /**
     * Divides the data with either the sum, the absolute sum or the maximum of the data
     * @param array - Array containing values
     * @param options - options
     * @returns - normalized data
     */
    function xNormed(input, options = {}) {
      const {
        algorithm = 'absolute',
        value = 1
      } = options;
      xCheck(input);
      const output = getOutputArray(options.output, input.length);
      if (input.length === 0) {
        throw new Error('input must not be empty');
      }
      switch (algorithm.toLowerCase()) {
        case 'absolute':
          {
            let absoluteSumValue = absoluteSum(input) / value;
            if (absoluteSumValue === 0) {
              throw new Error('xNormed: trying to divide by 0');
            }
            for (let i = 0; i < input.length; i++) {
              output[i] = input[i] / absoluteSumValue;
            }
            return output;
          }
        case 'max':
          {
            let currentMaxValue = xMaxValue(input);
            if (currentMaxValue === 0) {
              throw new Error('xNormed: trying to divide by 0');
            }
            const factor = value / currentMaxValue;
            for (let i = 0; i < input.length; i++) {
              output[i] = input[i] * factor;
            }
            return output;
          }
        case 'sum':
          {
            let sumFactor = xSum(input) / value;
            if (sumFactor === 0) {
              throw new Error('xNormed: trying to divide by 0');
            }
            for (let i = 0; i < input.length; i++) {
              output[i] = input[i] / sumFactor;
            }
            return output;
          }
        default:
          throw new Error(`norm: unknown algorithm: ${algorithm}`);
      }
    }
    function absoluteSum(input) {
      let sumValue = 0;
      for (let i = 0; i < input.length; i++) {
        sumValue += Math.abs(input[i]);
      }
      return sumValue;
    }

    /**
     * This function pads an array
     *s
     * @param array - the array that will be padded
     * @param options - options
     */
    function xPadding(array, options = {}) {
      const {
        size = 0,
        value = 0,
        algorithm = ''
      } = options;
      xCheck(array);
      if (!algorithm) {
        if (array instanceof Float64Array) {
          return array.slice();
        } else {
          return Float64Array.from(array);
        }
      }
      let result = new Float64Array(array.length + size * 2);
      for (let i = 0; i < array.length; i++) {
        result[i + size] = array[i];
      }
      let fromEnd = size + array.length;
      let toEnd = 2 * size + array.length;
      switch (algorithm.toLowerCase()) {
        case 'value':
          for (let i = 0; i < size; i++) {
            result[i] = value;
          }
          for (let i = fromEnd; i < toEnd; i++) {
            result[i] = value;
          }
          break;
        case 'duplicate':
          for (let i = 0; i < size; i++) {
            result[i] = array[0];
          }
          for (let i = fromEnd; i < toEnd; i++) {
            result[i] = array[array.length - 1];
          }
          break;
        case 'circular':
          for (let i = 0; i < size; i++) {
            result[i] = array[(array.length - size % array.length + i) % array.length];
          }
          for (let i = 0; i < size; i++) {
            result[i + fromEnd] = array[i % array.length];
          }
          break;
        default:
          throw new Error('xPadding: unknown algorithm');
      }
      return result;
    }

    /** Finds the variance of the data
     *
     * @param values - the values of the array
     * @param options - options
     * @returns variance
     */
    function xVariance(values, options = {}) {
      if (!isAnyArray(values)) {
        throw new TypeError('input must be an array');
      }
      const {
        unbiased = true,
        mean = xMean(values)
      } = options;
      let sqrError = 0;
      for (let i = 0; i < values.length; i++) {
        let x = values[i] - mean;
        sqrError += x * x;
      }
      if (unbiased) {
        return sqrError / (values.length - 1);
      } else {
        return sqrError / values.length;
      }
    }

    /** Finds the standard deviation for the data at hand
     *
     * @param values - values in the data
     * @param options - options
     * @returns standard deviation
     */
    function xStandardDeviation(values, options = {}) {
      return Math.sqrt(xVariance(values, options));
    }

    /**
     * Pareto scaling, which uses the square root of standard deviation as the scaling factor, circumvents the amplification of noise by retaining a small portion of magnitude information.
     * Noda, I. (2008). Scaling techniques to enhance two-dimensional correlation spectra. Journal of Molecular Structure, 883, 216-227.
     * DOI: 10.1016/j.molstruc.2007.12.026
     *
     * @param array - array of number
     */
    function xParetoNormalization(array) {
      xCheck(array);
      let result = [];
      const sqrtSD = Math.sqrt(xStandardDeviation(array));
      for (let item of array) {
        result.push(item / sqrtSD);
      }
      return result;
    }

    /** Function used to rescale data
     *
     * @param input - input for the rescale
     * @param options - options
     * @returns rescaled data
     */
    function xRescale(input, options = {}) {
      xCheck(input);
      const output = getOutputArray(options.output, input.length);
      const currentMin = xMinValue(input);
      const currentMax = xMaxValue(input);
      if (currentMin === currentMax) {
        throw new RangeError('minimum and maximum input values are equal. Cannot rescale a constant array');
      }
      const {
        min = 0,
        max = 1
      } = options;
      if (min >= max) {
        throw new RangeError('min option must be smaller than max option');
      }
      const factor = (max - min) / (currentMax - currentMin);
      for (let i = 0; i < input.length; i++) {
        output[i] = (input[i] - currentMin) * factor + min;
      }
      return output;
    }

    /**
     * This function calculates a rolling average
     *
     * @param array - array
     * @param fct - callback function that from an array returns a value
     * @param options - options
     */
    function xRolling(array, fct, options = {}) {
      xCheck(array);
      if (typeof fct !== 'function') throw new Error('fct has to be a function');
      const {
        window = 5,
        padding = {}
      } = options;
      const {
        size = window - 1,
        algorithm,
        value
      } = padding;
      array = xPadding(array, {
        size,
        algorithm,
        value
      }); // ensure we get a copy and it is float64
      const newArray = [];
      for (let i = 0; i < array.length - window + 1; i++) {
        // we will send a view to the original buffer
        newArray.push(fct(array.subarray(i, i + window)));
      }
      return newArray;
    }

    /**
     * This function calculates a rolling average
     *
     * @param array - array
     * @param options - option
     */
    function xRollingAverage(array, options = {}) {
      return xRolling(array, xMean, options);
    }

    /**
     * This function calculates a rolling average
     *
     * @param array - array
     * @param options - options
     */
    function xRollingMedian(array, options = {}) {
      return xRolling(array, xMedian, options);
    }

    /** Fill an array with sequential numbers
     *
     * @param input - optional destination array (if not provided a new array will be created)
     * @param options - options
     * @return array with sequential numbers
     */
    function xSequentialFill(input = [], options = {}) {
      if (typeof input === 'object' && !isAnyArray(input)) {
        options = input;
        input = [];
      }
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      }
      // maybe should not specify default step and size
      let {
        from = 0,
        to = 10,
        size = Array.isArray(input) || input.constructor === Float64Array || input.constructor === Uint16Array ? input.length : 0,
        step = null
      } = options;
      if (!size) {
        if (step) {
          size = Math.floor((to - from) / step) + 1;
        } else {
          size = to - from + 1;
        }
      }
      if (!step && size) {
        step = (to - from) / (size - 1);
      }
      if (Array.isArray(input)) {
        // only works with normal array
        input.length = 0;
        for (let i = 0; i < size; i++) {
          input.push(from);
          if (step) from += step;
        }
      } else {
        if (Array.isArray(input) || input.constructor === Float64Array || input.constructor === Uint16Array && input.length !== size) {
          throw new Error('sequentialFill typed array must have the correct length');
        }
        for (let i = 0; i < size; i++) {
          if (Array.isArray(input) || input.constructor === Float64Array || input.constructor === Uint16Array) {
            input[i] = from;
          }
          if (step) {
            from += step;
          }
        }
      }
      return Array.isArray(input) || input.constructor === Float64Array || input.constructor === Uint16Array ? Array.from(input) : [];
    }

    /**
     * This function xSubtract the first array by the second array or a constant value from each element of the first array
     *
     * @param array1 - the array that will be rotated
     * @param array2 - second array or number
     * @returns array after subtraction
     */
    function xSubtract(array1, array2) {
      let isConstant = false;
      let constant = 0;
      if (isAnyArray(array2)) {
        if (array1.length !== array2.length) {
          throw new Error('xSubtract: size of array1 and array2 must be identical');
        }
      } else {
        isConstant = true;
        constant = Number(array2);
      }
      let array3 = new Float64Array(array1.length);
      if (isConstant) {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] - constant;
        }
      } else {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] - array2[i];
        }
      }
      return array3;
    }

    /**
     * Throw an error in no an object of x,y arrays
     *
     * @param data - array of points {x,y,z}
     */
    function xyCheck(data, options = {}) {
      const {
        minLength
      } = options;
      if (typeof data !== 'object' || !isAnyArray(data.x) || !isAnyArray(data.y)) {
        throw new Error('Data must be an object of x and y arrays');
      }
      if (data.x.length !== data.y.length) {
        throw new Error('The x and y arrays must have the same length');
      }
      if (minLength && data.x.length < minLength) {
        throw new Error(`data.x must have a length of at least ${minLength}`);
      }
    }

    /**
     * Finds the closest point
     *
     * @param data - x array should be sorted and ascending
     * @param target - target to search
     * @returns - closest point
     */
    function xyFindClosestPoint( /** points */
    data, target) {
      const {
        x,
        y
      } = data;
      const index = xFindClosestIndex(x, target);
      return {
        x: x[index],
        y: y[index]
      };
    }

    /**
     * Filters x,y values to allow strictly growing values in x axis.
     *
     * @param data - Object that contains property x (an ordered increasing array) and y (an array).
     */
    function xyEnsureGrowingX(data) {
      xyCheck(data);
      if (xIsMonotonic(data.x) === 1) return data;
      const x = Array.from(data.x);
      const y = Array.from(data.y);
      let prevX = Number.NEGATIVE_INFINITY;
      let currentIndex = 0;
      for (let index = 0; index < x.length; index++) {
        if (prevX < x[index]) {
          if (currentIndex < index) {
            x[currentIndex] = x[index];
            y[currentIndex] = y[index];
          }
          currentIndex++;
          prevX = x[index];
        }
      }
      x.length = currentIndex;
      y.length = currentIndex;
      return {
        x,
        y
      };
    }

    /**
     * Normalize an array of zones:
     * - ensure than from < to
     * - merge overlapping zones
     * - deal with exclusions zones
     * - if no zones is specified add one between -Infinity and +Infinity
     * @param zones - array of zones
     * @param options - options
     * @returns array of zones
     */
    function zonesNormalize(zones = [], options = {}) {
      let {
        from = Number.NEGATIVE_INFINITY,
        to = Number.POSITIVE_INFINITY,
        exclusions = []
      } = options;
      if (from > to) [from, to] = [to, from];
      zones = JSON.parse(JSON.stringify(zones)).map(zone => zone.from > zone.to ? {
        from: zone.to,
        to: zone.from
      } : zone);
      zones = zones.sort((a, b) => {
        if (a.from !== b.from) return a.from - b.from;
        return a.to - b.to;
      });
      if (zones.length === 0) {
        zones.push({
          from,
          to
        });
      }
      for (const zone of zones) {
        if (from > zone.from) zone.from = from;
        if (to < zone.to) zone.to = to;
      }
      zones = zones.filter(zone => zone.from <= zone.to);
      if (zones.length === 0) return [];
      let currentZone = zones[0];
      let beforeExclusionsZones = [currentZone];
      for (let i = 1; i < zones.length; i++) {
        let zone = zones[i];
        if (zone.from <= currentZone.to) {
          if (currentZone.to < zone.to) {
            currentZone.to = zone.to;
          }
        } else {
          currentZone = zone;
          beforeExclusionsZones.push(currentZone);
        }
      }
      if (exclusions.length === 0) return beforeExclusionsZones;
      const normalizedExclusions = zonesNormalize(exclusions);
      let currentExclusionIndex = 0;
      const results = [];
      let counter = 0;
      for (let zoneIndex = 0; zoneIndex < beforeExclusionsZones.length; zoneIndex++) {
        if (counter++ > 5) break;
        const zone = beforeExclusionsZones[zoneIndex];
        if (currentExclusionIndex === normalizedExclusions.length) {
          // we analysed all the exclusion zones
          results.push(zone);
          continue;
        }
        while (currentExclusionIndex < normalizedExclusions.length && normalizedExclusions[currentExclusionIndex].to <= zone.from) {
          currentExclusionIndex++;
        }
        if (currentExclusionIndex === normalizedExclusions.length) {
          // we analysed all the exclusion zones
          results.push(zone);
          continue;
        }
        if (zone.to < normalizedExclusions[currentExclusionIndex].from) {
          // no problems, not yet in exclusion
          results.push(zone);
          continue;
        }
        if (normalizedExclusions[currentExclusionIndex].to >= zone.to) {
          // could be totally excluded
          if (normalizedExclusions[currentExclusionIndex].from <= zone.from) {
            continue;
          }
          results.push({
            from: normalizedExclusions[currentExclusionIndex].to,
            to: zone.to
          });
        }
        // we cut in the middle, we need to create more zones, annoying !
        if (normalizedExclusions[currentExclusionIndex].from > zone.from) {
          results.push({
            from: zone.from,
            to: normalizedExclusions[currentExclusionIndex].from
          });
        }
        zone.from = normalizedExclusions[currentExclusionIndex].to;
        zoneIndex--;
      }
      return results;
    }

    /**
     * Add the number of points per zone to reach a specified total
     *
     * @param zones - array of zones
     * @param numberOfPoints - total number of points to distribute between zones
     * @param options - options
     * @returns array of zones with points
     */
    function zonesWithPoints(zones = [],
    /**
     * total number of points to distribute between zones
     * @default 10
     */
    numberOfPoints = 10, options = {}) {
      if (zones.length === 0) return zones;
      let returnZones = zonesNormalize(zones, options);
      const totalSize = returnZones.reduce((previous, current) => {
        return previous + (current.to - current.from);
      }, 0);
      let unitsPerPoint = totalSize / numberOfPoints;
      let currentTotal = 0;
      for (let i = 0; i < returnZones.length - 1; i++) {
        let zone = returnZones[i];
        zone.numberOfPoints = Math.min(Math.round((zone.to - zone.from) / unitsPerPoint), numberOfPoints - currentTotal);
        currentTotal += zone.numberOfPoints;
      }
      let zone = returnZones[returnZones.length - 1];
      zone.numberOfPoints = numberOfPoints - currentTotal;
      return returnZones;
    }

    /**
     * function that retrieves the getEquallySpacedData with the variant "slot"
     *
     * @param x
     * @param y
     * @param from
     * @param to
     * @param numberOfPoints
     * @return Array of y's equally spaced with the variant "slot"
     */
    function equallySpacedSlot( /** x coordinates */
    x, /** y coordinates */
    y, /** from value */
    from, /** to value */
    to, /** number of points */
    numberOfPoints) {
      let xLength = x.length;
      let step = (to - from) / (numberOfPoints > 1 ? numberOfPoints - 1 : 1);
      let halfStep = step / 2;
      let lastStep = x[x.length - 1] - x[x.length - 2];
      let start = from - halfStep;
      // Changed Array to Float64Array
      let output = new Float64Array(numberOfPoints);
      // Init main variables
      let min = start;
      let max = start + step;
      let previousX = -Number.MAX_VALUE;
      let previousY = 0;
      let nextX = x[0];
      let nextY = y[0];
      let frontOutsideSpectra = 0;
      let backOutsideSpectra = true;
      let currentValue = 0;
      // for slot algorithm
      let currentPoints = 0;
      let i = 1; // index of input
      let j = 0; // index of output
      main: while (true) {
        if (previousX >= nextX) throw new Error('x must be a growing series');
        while (previousX - max > 0) {
          // no overlap with original point, just consume current value
          if (backOutsideSpectra) {
            currentPoints++;
            backOutsideSpectra = false;
          }
          output[j] = currentPoints <= 0 ? 0 : currentValue / currentPoints;
          j++;
          if (j === numberOfPoints) {
            break main;
          }
          min = max;
          max += step;
          currentValue = 0;
          currentPoints = 0;
        }
        if (previousX > min) {
          currentValue += previousY;
          currentPoints++;
        }
        if (previousX === -Number.MAX_VALUE || frontOutsideSpectra > 1) {
          currentPoints--;
        }
        previousX = nextX;
        previousY = nextY;
        if (i < xLength) {
          nextX = x[i];
          nextY = y[i];
          i++;
        } else {
          nextX += lastStep;
          nextY = 0;
          frontOutsideSpectra++;
        }
      }
      return output;
    }

    /**
     * Function that calculates the integral of the line between two
     * x-coordinates, given the slope and intercept of the line.
     * @param x0
     * @param x1
     * @param slope
     * @param intercept
     * @return integral value.
     */
    function integral( /** first coordinate of point */
    x0, /** second coordinate of point */
    x1, /** slope of the line */
    slope, /** intercept of the line on the y axis */
    intercept) {
      return 0.5 * slope * x1 * x1 + intercept * x1 - (0.5 * slope * x0 * x0 + intercept * x0);
    }

    /**
     * function that retrieves the getEquallySpacedData with the variant "smooth"
     *
     * @param x
     * @param y
     * @param from
     * @param to
     * @param numberOfPoints
     * @return - Array of y's equally spaced with the variant "smooth"
     */
    function equallySpacedSmooth( /** x coordinates */
    x, /** y coordinates */
    y, /** from value */
    from, /** to value */
    to, /** number of points */
    numberOfPoints) {
      let xLength = x.length;
      let step = (to - from) / (numberOfPoints > 1 ? numberOfPoints - 1 : 1);
      let halfStep = step / 2;
      // Changed Array to Float64Array
      let output = new Float64Array(numberOfPoints);
      let initialOriginalStep = x[1] - x[0];
      let lastOriginalStep = x[xLength - 1] - x[xLength - 2];
      // Init main variables
      let min = from - halfStep;
      let max = from + halfStep;
      let previousX = Number.MIN_SAFE_INTEGER;
      let previousY = 0;
      let nextX = x[0] - initialOriginalStep;
      let nextY = 0;
      let currentValue = 0;
      let slope = 0;
      let intercept = 0;
      let sumAtMin = 0;
      let sumAtMax = 0;
      let i = 0; // index of input
      let j = 0; // index of output
      let add = 0;
      main: while (true) {
        if (previousX >= nextX) throw new Error('x must be a growing series');
        if (previousX <= min && min <= nextX) {
          add = integral(0, min - previousX, slope, previousY);
          sumAtMin = currentValue + add;
        }
        while (nextX - max >= 0) {
          // no overlap with original point, just consume current value
          add = integral(0, max - previousX, slope, previousY);
          sumAtMax = currentValue + add;
          output[j++] = (sumAtMax - sumAtMin) / step;
          if (j === numberOfPoints) {
            break main;
          }
          min = max;
          max += step;
          sumAtMin = sumAtMax;
        }
        currentValue += integral(previousX, nextX, slope, intercept);
        previousX = nextX;
        previousY = nextY;
        if (i < xLength) {
          nextX = x[i];
          nextY = y[i];
          i++;
        } else if (i === xLength) {
          nextX += lastOriginalStep;
          nextY = 0;
        }
        slope = getSlope(previousX, previousY, nextX, nextY);
        intercept = -slope * previousX + previousY;
      }
      return output;
    }
    function getSlope(x0, y0, x1, y1) {
      return (y1 - y0) / (x1 - x0);
    }

    /**
     * Function that returns a Number array of equally spaced numberOfPoints
     * containing a representation of intensities of the spectra arguments x
     * and y.
     *
     * The options parameter contains an object in the following form:
     * from: starting point
     * to: last point
     * numberOfPoints: number of points between from and to
     * variant: "slot" or "smooth" - smooth is the default option
     *
     * The slot variant consist that each point in an array is calculated
     * averaging the existing points between the slot that belongs to the current
     * value. The smooth variant is the same but takes the integral of the range
     * of the slot and divide by the step size between two points in an array.
     *
     * If exclusions zone are present, zones are ignored !
     *
     * @param data - object containing 2 properties x and y
     * @param options - options
     * @return new object with x / y array with the equally spaced data.
     */
    function xyEquallySpaced(data, options = {}) {
      let {
        x,
        y
      } = data;
      let xLength = x.length;
      const {
        from = x[0],
        to = x[xLength - 1],
        variant = 'smooth',
        numberOfPoints = 100,
        exclusions = [],
        zones = [{
          from,
          to
        }]
      } = options;
      if (from > to) {
        throw new RangeError('from should be larger than to');
      }
      xyCheck(data);
      if (numberOfPoints < 2) {
        throw new RangeError("'numberOfPoints' option must be greater than 1");
      }
      const normalizedZones = zonesNormalize(zones, {
        from,
        to,
        exclusions
      });
      const zonesWithPointsRes = zonesWithPoints(normalizedZones, numberOfPoints, {
        from,
        to
      });
      let xResult = [];
      let yResult = [];
      for (let zone of zonesWithPointsRes) {
        if (!zone.numberOfPoints) {
          zone.numberOfPoints = 0;
        }
        let zoneResult = processZone(Array.from(x), Array.from(y), zone.from, zone.to, zone.numberOfPoints, variant);
        xResult = xResult.concat(zoneResult.x);
        yResult = yResult.concat(zoneResult.y);
      }
      return {
        x: xResult,
        y: yResult
      };
    }
    function processZone(x, y, from, to, numberOfPoints, variant) {
      if (numberOfPoints < 1) {
        throw new RangeError('the number of points must be at least 1');
      }
      let output = variant === 'slot' ? Array.from(equallySpacedSlot(x, y, from, to, numberOfPoints)) : Array.from(equallySpacedSmooth(x, y, from, to, numberOfPoints));
      return {
        x: Array.from(createFromToArray({
          from,
          to,
          length: numberOfPoints
        })),
        y: output
      };
    }

    /**
     * XyExtract zones from a XY data
     *
     * @param data - Object that contains property x (an ordered increasing array) and y (an array)
     * @param options - options
     * @returns - Array of points
     */
    function xyExtract(data, options = {}) {
      xyCheck(data);
      const {
        x,
        y
      } = data;
      let {
        zones
      } = options;
      zones = zonesNormalize(zones);
      if (x === undefined || y === undefined || !Array.isArray(zones) || zones.length === 0) {
        return data;
      }
      let newX = [];
      let newY = [];
      let currentZone = zones[0];
      let position = 0;
      loop: for (let i = 0; i < x.length; i++) {
        while (currentZone.to < x[i]) {
          position++;
          currentZone = zones[position];
          if (!currentZone) {
            i = x.length;
            break loop;
          }
        }
        if (x[i] >= currentZone.from) {
          newX.push(x[i]);
          newY.push(y[i]);
        }
      }
      return {
        x: newX,
        y: newY
      };
    }

    /** Filter an array x/y based on various criteria x points are expected to be sorted
     *
     * @param data - object containing 2 properties x and y
     * @param options - options
     * @return filtered array
     */
    function xyFilterX(data, options = {}) {
      const {
        x,
        y
      } = data;
      const {
        from = x[0],
        to = x[x.length - 1],
        zones = [{
          from,
          to
        }],
        exclusions = []
      } = options;
      let normalizedZones = zonesNormalize(zones, {
        from,
        to,
        exclusions
      });
      let currentZoneIndex = 0;
      let newX = [];
      let newY = [];
      let position = 0;
      while (position < x.length) {
        if (x[position] <= normalizedZones[currentZoneIndex].to && x[position] >= normalizedZones[currentZoneIndex].from) {
          newX.push(x[position]);
          newY.push(y[position]);
        } else if (x[position] > normalizedZones[currentZoneIndex].to) {
          currentZoneIndex++;
          if (!normalizedZones[currentZoneIndex]) break;
        }
        position++;
      }
      return {
        x: newX,
        y: newY
      };
    }

    /**
     * Calculate integration
     *
     * @param data - Object that contains property x (an ordered increasing array) and y (an array)
     * @param options - Options
     * @returns - xyIntegration value on the specified range
     */
    function xyIntegration(data, options = {}) {
      xyCheck(data, {
        minLength: 1
      });
      const {
        x,
        y
      } = data;
      if (x.length === 1) return 0;
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(x, options);
      let currentxyIntegration = 0;
      for (let i = fromIndex; i < toIndex; i++) {
        currentxyIntegration += (x[i + 1] - x[i]) * (y[i + 1] + y[i]) / 2;
      }
      return currentxyIntegration;
    }

    /**
     * Set a value (default 0) to specific zones.
     *
     * @param data - Object that contains property x (an ordered increasing array) and y (an array)
     * @param options - options
     * @returns - Array of points
     */
    function xySetYValue(data, options = {}) {
      xyCheck(data);
      const {
        x,
        y
      } = data;
      let {
        zones,
        value = 0
      } = options;
      if (!Array.isArray(zones) || zones.length === 0) {
        return data;
      }
      zones = zonesNormalize(zones);
      const newX = x.slice();
      const newY = y.slice();
      let currentZone = zones[0];
      let position = 0;
      loop: for (let i = 0; i < x.length; i++) {
        while (currentZone.to < x[i]) {
          position++;
          currentZone = zones[position];
          if (!currentZone) {
            i = x.length;
            break loop;
          }
        }
        if (x[i] >= currentZone.from) {
          newY[i] = value;
        }
      }
      return {
        x: newX,
        y: newY
      };
    }

    function matrixCheck(data) {
      if (data.length === 0 || data[0].length === 0) {
        throw new RangeError('matrix should contain data');
      }
      const firstLength = data[0].length;
      for (let i = 1; i < data.length; i++) {
        if (data[i].length !== firstLength) {
          throw new RangeError('All rows should has the same length');
        }
      }
    }

    /**
     * Get min and max Z
     *
     * @param matrix - matrix [rows][cols].
     */
    function matrixMinMaxZ(matrix) {
      matrixCheck(matrix);
      const nbRows = matrix.length;
      const nbColumns = matrix[0].length;
      let min = matrix[0][0];
      let max = matrix[0][0];
      for (let column = 0; column < nbColumns; column++) {
        for (let row = 0; row < nbRows; row++) {
          if (matrix[row][column] < min) min = matrix[row][column];
          if (matrix[row][column] > max) max = matrix[row][column];
        }
      }
      return {
        min,
        max
      };
    }

    const LOOP = 8;
    const FLOAT_MUL = 1 / 16777216;
    const sh1 = 15;
    const sh2 = 18;
    const sh3 = 11;
    function multiply_uint32(n, m) {
      n >>>= 0;
      m >>>= 0;
      const nlo = n & 0xffff;
      const nhi = n - nlo;
      return (nhi * m >>> 0) + nlo * m >>> 0;
    }
    class XSadd {
      constructor(seed = Date.now()) {
        this.state = new Uint32Array(4);
        this.init(seed);
        this.random = this.getFloat.bind(this);
      }
      /**
       * Returns a 32-bit integer r (0 <= r < 2^32)
       */
      getUint32() {
        this.nextState();
        return this.state[3] + this.state[2] >>> 0;
      }
      /**
       * Returns a floating point number r (0.0 <= r < 1.0)
       */
      getFloat() {
        return (this.getUint32() >>> 8) * FLOAT_MUL;
      }
      init(seed) {
        if (!Number.isInteger(seed)) {
          throw new TypeError('seed must be an integer');
        }
        this.state[0] = seed;
        this.state[1] = 0;
        this.state[2] = 0;
        this.state[3] = 0;
        for (let i = 1; i < LOOP; i++) {
          this.state[i & 3] ^= i + multiply_uint32(1812433253, this.state[i - 1 & 3] ^ this.state[i - 1 & 3] >>> 30 >>> 0) >>> 0;
        }
        this.periodCertification();
        for (let i = 0; i < LOOP; i++) {
          this.nextState();
        }
      }
      periodCertification() {
        if (this.state[0] === 0 && this.state[1] === 0 && this.state[2] === 0 && this.state[3] === 0) {
          this.state[0] = 88; // X
          this.state[1] = 83; // S
          this.state[2] = 65; // A
          this.state[3] = 68; // D
        }
      }

      nextState() {
        let t = this.state[0];
        t ^= t << sh1;
        t ^= t >>> sh2;
        t ^= this.state[3] << sh3;
        this.state[0] = this.state[1];
        this.state[1] = this.state[2];
        this.state[2] = this.state[3];
        this.state[3] = t;
      }
    }

    /**
     * Create a random array of numbers of a specific length
     *
     * @return - array of random floats normally distributed
     */
    let spare;
    let hasSpare = false;
    function createRandomArray(options = {}) {
      const {
        mean = 0,
        standardDeviation = 1,
        length = 1000,
        range = 1,
        seed,
        distribution = 'normal'
      } = options;
      const generator = new XSadd(seed);
      let returnArray = new Float64Array(length);
      switch (distribution) {
        case 'normal':
          for (let i = 0; i < length; i++) {
            returnArray[i] = generateGaussian(mean, standardDeviation, generator);
          }
          break;
        case 'uniform':
          for (let i = 0; i < length; i++) {
            returnArray[i] = (generator.random() - 0.5) * range + mean;
          }
          break;
        default:
          // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
          throw new Error(`unknown distribution: ${distribution}`);
      }
      return returnArray;
    }
    function generateGaussian(mean, standardDeviation, generator) {
      let val, u, v, s;
      if (hasSpare) {
        hasSpare = false;
        val = spare * standardDeviation + mean;
      } else {
        do {
          u = generator.random() * 2 - 1;
          v = generator.random() * 2 - 1;
          s = u * u + v * v;
        } while (s >= 1 || s === 0);
        s = Math.sqrt(-2 * Math.log(s) / s);
        spare = v * s;
        hasSpare = true;
        val = mean + standardDeviation * u * s;
      }
      return val;
    }

    function addNoise(data, options = {}) {
      const {
        seed = 0,
        distribution = 'normal',
        percent = 1
      } = options;
      const range = xMaxValue(data.y) * percent / 100;
      const noise = createRandomArray({
        distribution,
        seed,
        mean: 0,
        standardDeviation: range,
        range,
        length: data.x.length
      });
      data.y = xAdd(data.y, noise);
      return data;
    }

    class SpectrumGenerator {
      constructor(options = {}) {
        const {
          from = 0,
          to = 1000,
          nbPoints = 10001,
          peakWidthFct,
          shape = {
            kind: 'gaussian',
            fwhm: 5
          }
        } = options;
        this.from = from;
        this.to = to;
        this.nbPoints = nbPoints;
        this.interval = (this.to - this.from) / (this.nbPoints - 1);
        this.peakWidthFct = peakWidthFct;
        this.maxPeakHeight = Number.MIN_SAFE_INTEGER;
        this.data = {
          x: new Float64Array(this.nbPoints),
          y: new Float64Array(this.nbPoints)
        };
        let shapeGenerator = getShape1D(shape);
        this.shape = shapeGenerator;
        assertNumber$2(this.from, 'from');
        assertNumber$2(this.to, 'to');
        assertInteger$1(this.nbPoints, 'nbPoints');
        if (this.to <= this.from) {
          throw new RangeError('to option must be larger than from');
        }
        if (this.peakWidthFct && typeof this.peakWidthFct !== 'function') {
          throw new TypeError('peakWidthFct option must be a function');
        }
        this.reset();
      }
      /**
       * Add a series of peaks to the spectrum.
       * @param peaks - Peaks to add.
       */
      addPeaks(peaks, options) {
        if (!Array.isArray(peaks) && (typeof peaks !== 'object' || peaks.x === undefined || peaks.y === undefined || !Array.isArray(peaks.x) || !Array.isArray(peaks.y) || peaks.x.length !== peaks.y.length)) {
          throw new TypeError('peaks must be an array or an object containing x[] and y[]');
        }
        if (Array.isArray(peaks)) {
          for (const peak of peaks) {
            this.addPeak(peak, options);
          }
        } else {
          for (let i = 0; i < peaks.x.length; i++) {
            this.addPeak([peaks.x[i], peaks.y[i]], options);
          }
        }
      }
      /**
       * Add a single peak to the spectrum.
       * A peak may be either defined as [x,y,fwhm,...] or as {x, y, shape}
       * @param peak
       * @param options
       */
      addPeak(peak, options = {}) {
        if (Array.isArray(peak) && peak.length < 2) {
          throw new Error('peak must be an array with two (or three) values or an object with {x,y,width?}');
        }
        if (!Array.isArray(peak) && (peak.x === undefined || peak.y === undefined)) {
          throw new Error('peak must be an array with two (or three) values or an object with {x,y,width?}');
        }
        let xPosition;
        let intensity;
        let peakFWHM;
        let peakWidth;
        let peakShapeOptions;
        if (Array.isArray(peak)) {
          [xPosition, intensity, peakFWHM, peakShapeOptions] = peak;
        } else {
          xPosition = peak.x;
          intensity = peak.y;
          peakWidth = peak.width;
          peakShapeOptions = peak.shape;
        }
        if (intensity > this.maxPeakHeight) this.maxPeakHeight = intensity;
        let {
          shape: shapeOptions
        } = options;
        if (peakShapeOptions) {
          shapeOptions = shapeOptions ? {
            ...shapeOptions,
            ...peakShapeOptions
          } : peakShapeOptions;
        }
        const shape = shapeOptions ? getShape1D(shapeOptions) : Object.assign(Object.create(Object.getPrototypeOf(this.shape)), this.shape);
        let {
          width,
          widthLeft,
          widthRight
        } = options;
        /*
         if we don't force the fwhm we just take the one from the shape
         however we have many way to force it:
         - use [x,y,fwhm]
         - define `width` that will be converted to fwhm
         - define `widthLeft` and `widthRight` to define asymmetric peaks
         - have a callback `peakWidthFct`
         This should evolve in the future because we will not always have `fwhm`
         */
        const fwhm = peakFWHM !== undefined ? peakFWHM : peakWidth ? shape.widthToFWHM(peakWidth) : this.peakWidthFct ? this.peakWidthFct(xPosition) : width !== undefined ? width : shape.fwhm;
        if (!widthLeft) widthLeft = fwhm;
        if (!widthRight) widthRight = fwhm;
        if (!widthLeft || !widthRight) {
          throw new Error('Width left or right is undefined or zero');
        }
        let factor = options.factor === undefined ? shape.getFactor() : options.factor;
        const firstValue = xPosition - widthLeft / 2 * factor;
        const lastValue = xPosition + widthRight / 2 * factor;
        const firstPoint = Math.max(0, Math.floor((firstValue - this.from) / this.interval));
        const lastPoint = Math.min(this.nbPoints - 1, Math.ceil((lastValue - this.from) / this.interval));
        const middlePoint = Math.round((xPosition - this.from) / this.interval);
        // PEAK SHAPE MAY BE ASYMMETRC (widthLeft and widthRight) !
        // we calculate the left part of the shape
        shape.fwhm = widthLeft;
        for (let index = firstPoint; index < Math.max(middlePoint, 0); index++) {
          this.data.y[index] += intensity * shape.fct(this.data.x[index] - xPosition);
        }
        // we calculate the right part of the gaussian
        shape.fwhm = widthRight;
        for (let index = Math.min(middlePoint, lastPoint); index <= lastPoint; index++) {
          this.data.y[index] += intensity * shape.fct(this.data.x[index] - xPosition);
        }
      }
      /**
       * Add a baseline to the spectrum.
       * @param baselineFct - Mathematical function producing the baseline you want.
       */
      addBaseline(baselineFct) {
        addBaseline(this.data, baselineFct);
        return this;
      }
      /**
       * Add noise to the spectrum.
       *
       * @param percent - Noise's amplitude in percents of the spectrum max value. Default: 1.
       */
      addNoise(options) {
        addNoise(this.data, options);
        return this;
      }
      /**
       * Get the generated spectrum.
       */
      getSpectrum(options = {}) {
        if (typeof options === 'boolean') {
          options = {
            copy: options
          };
        }
        const {
          copy = true,
          threshold = 0
        } = options;
        if (threshold) {
          let minPeakHeight = this.maxPeakHeight * threshold;
          let x = [];
          let y = [];
          for (let i = 0; i < this.data.x.length; i++) {
            if (this.data.y[i] >= minPeakHeight) {
              x.push(this.data.x[i]);
              y.push(this.data.y[i]);
            }
          }
          return {
            x: Float64Array.from(x),
            y: Float64Array.from(y)
          };
        }
        if (copy) {
          return {
            x: this.data.x.slice(),
            y: this.data.y.slice()
          };
        } else {
          return this.data;
        }
      }
      /**
       * Resets the generator with an empty spectrum.
       */
      reset() {
        const spectrum = this.data;
        for (let i = 0; i < this.nbPoints; i++) {
          spectrum.x[i] = this.from + i * this.interval;
        }
        return this;
      }
    }
    function assertInteger$1(value, name) {
      if (!Number.isInteger(value)) {
        throw new TypeError(`${name} option must be an integer`);
      }
    }
    function assertNumber$2(value, name) {
      if (!Number.isFinite(value)) {
        throw new TypeError(`${name} option must be a number`);
      }
    }
    /**
     * Generates a spectrum and returns it.
     * @param peaks - List of peaks to put in the spectrum.
     * @param options
     */
    function generateSpectrum(peaks, options = {}) {
      const {
        generator: generatorOptions,
        noise,
        baseline,
        threshold,
        peakOptions
      } = options;
      const generator = new SpectrumGenerator(generatorOptions);
      generator.addPeaks(peaks, peakOptions);
      if (baseline) generator.addBaseline(baseline);
      if (noise) {
        generator.addNoise(noise);
      }
      return generator.getSpectrum({
        threshold
      });
    }

    const axis2D = ['x', 'y'];
    const peakCoordinates = ['x', 'y', 'z'];
    const convertWidthToFWHM = (shape, width) => {
      const widthData = ensureXYNumber$1(width);
      for (let key of axis2D) {
        widthData[key] = shape.widthToFWHM(widthData[key]);
      }
      return widthData;
    };
    class Spectrum2DGenerator {
      constructor(options = {}) {
        let {
          from = 0,
          to = 100,
          nbPoints = 1001,
          peakWidthFct = () => 5,
          shape = {
            kind: 'gaussian'
          }
        } = options;
        from = ensureXYNumber$1(from);
        to = ensureXYNumber$1(to);
        nbPoints = ensureXYNumber$1(nbPoints);
        for (const axis of axis2D) {
          assertNumber$1(from[axis], `from-${axis}`);
          assertNumber$1(to[axis], `to-${axis}`);
          assertInteger(nbPoints[axis], `nbPoints-${axis}`);
        }
        this.from = from;
        this.to = to;
        this.nbPoints = nbPoints;
        this.interval = calculeIntervals(from, to, nbPoints);
        this.peakWidthFct = peakWidthFct;
        this.maxPeakHeight = Number.MIN_SAFE_INTEGER;
        let shapeGenerator = getShape2D(shape);
        this.shape = shapeGenerator;
        this.data = {
          x: new Float64Array(nbPoints.x),
          y: new Float64Array(nbPoints.y),
          z: createMatrix(this.nbPoints)
        };
        for (const axis of axis2D) {
          if (this.to[axis] <= this.from[axis]) {
            throw new RangeError('to option must be larger than from');
          }
        }
        if (typeof this.peakWidthFct !== 'function') {
          throw new TypeError('peakWidthFct option must be a function');
        }
        this.reset();
      }
      addPeaks(peaks, options) {
        if (!Array.isArray(peaks) && (typeof peaks !== 'object' || peaks.x === undefined || peaks.y === undefined || !Array.isArray(peaks.x) || !Array.isArray(peaks.y) || peaks.x.length !== peaks.y.length)) {
          throw new TypeError('peaks must be an array or an object containing x[] and y[]');
        }
        if (Array.isArray(peaks)) {
          for (const peak of peaks) {
            this.addPeak(peak, options);
          }
        } else {
          let nbPeaks = peaks.x.length;
          for (const c of peakCoordinates) {
            if (peaks[c] && Array.isArray(peaks[c])) {
              if (nbPeaks !== peaks[c].length) {
                throw new Error('x, y, z should have the same length');
              }
            }
          }
          for (let i = 0; i < peaks.x.length; i++) {
            this.addPeak([peaks.x[i], peaks.y[i], peaks.z[i]], options);
          }
        }
        return this;
      }
      addPeak(peak, options = {}) {
        if (Array.isArray(peak) && peak.length < 3) {
          throw new Error('peak must be an array with three (or four) values or an object with {x,y,z,width?}');
        }
        if (!Array.isArray(peak) && peakCoordinates.some(e => peak[e] === undefined)) {
          throw new Error('peak must be an array with three (or four) values or an object with {x,y,z,width?}');
        }
        let xPosition;
        let yPosition;
        let intensity;
        let peakFWHM;
        let peakWidth;
        let peakShapeOptions;
        if (Array.isArray(peak)) {
          [xPosition, yPosition, intensity, peakFWHM, peakShapeOptions] = peak;
        } else {
          xPosition = peak.x;
          yPosition = peak.y;
          intensity = peak.z;
          peakFWHM = peak.fwhm;
          peakWidth = peak.width;
          peakShapeOptions = peak.shape;
        }
        const position = {
          x: xPosition,
          y: yPosition
        };
        if (intensity > this.maxPeakHeight) this.maxPeakHeight = intensity;
        let {
          shape: shapeOptions,
          width
        } = options;
        if (peakShapeOptions) {
          shapeOptions = shapeOptions ? {
            ...shapeOptions,
            ...peakShapeOptions
          } : peakShapeOptions;
        }
        const shape = shapeOptions ? getShape2D(shapeOptions) : Object.assign(Object.create(Object.getPrototypeOf(this.shape)), JSON.parse(JSON.stringify(this.shape)));
        let {
          fwhm = peakFWHM !== undefined ? peakFWHM : peakWidth ? convertWidthToFWHM(shape, peakWidth) : width ? convertWidthToFWHM(shape, width) : this.peakWidthFct(xPosition, yPosition)
        } = options;
        fwhm = ensureXYNumber$1(fwhm);
        let factor = options.factor === undefined ? shape.getFactor() : options.factor;
        factor = ensureXYNumber$1(factor);
        const firstPoint = {
          x: 0,
          y: 0
        };
        const lastPoint = {
          x: 0,
          y: 0
        };
        for (const axis of axis2D) {
          const first = position[axis] - fwhm[axis] / 2 * factor[axis];
          const last = position[axis] + fwhm[axis] / 2 * factor[axis];
          firstPoint[axis] = Math.max(0, Math.floor((first - this.from[axis]) / this.interval[axis]));
          lastPoint[axis] = Math.min(this.nbPoints[axis], Math.ceil((last - this.from[axis]) / this.interval[axis]));
        }
        shape.fwhm = fwhm;
        for (let xIndex = firstPoint.x; xIndex < lastPoint.x; xIndex++) {
          for (let yIndex = firstPoint.y; yIndex < lastPoint.y; yIndex++) {
            const value = intensity * shape.fct(this.data.x[xIndex] - position.x, this.data.y[yIndex] - position.y);
            if (value > 1e-6) {
              this.data.z[yIndex][xIndex] += value;
            }
          }
        }
        return this;
      }
      getSpectrum(options = {}) {
        if (typeof options === 'boolean') {
          options = {
            copy: options
          };
        }
        const {
          copy = true
        } = options;
        let minMaxZ = matrixMinMaxZ(this.data.z);
        return {
          minX: this.from.x,
          maxX: this.to.x,
          maxY: this.to.y,
          minY: this.from.y,
          minZ: minMaxZ.min,
          maxZ: minMaxZ.max,
          z: copy ? this.data.z.slice() : this.data.z
        };
      }
      reset() {
        const spectrum = this.data;
        for (const axis of axis2D) {
          for (let i = 0; i < this.nbPoints[axis]; i++) {
            spectrum[axis][i] = this.from[axis] + i * this.interval[axis];
          }
        }
        for (let row of spectrum.z) {
          for (let j = 0; j < row.length; j++) {
            row[j] = 0;
          }
        }
        return this;
      }
    }
    function generateSpectrum2D(peaks, options = {}) {
      const {
        generator: generatorOptions,
        peaks: addPeaksOptions
      } = options;
      const generator = new Spectrum2DGenerator(generatorOptions);
      generator.addPeaks(peaks, addPeaksOptions);
      return generator.getSpectrum();
    }
    function ensureXYNumber$1(input) {
      return typeof input !== 'object' ? {
        x: input,
        y: input
      } : {
        ...input
      };
    }
    function calculeIntervals(from, to, nbPoints) {
      return {
        x: (to.x - from.x) / (nbPoints.x - 1),
        y: (to.y - from.y) / (nbPoints.y - 1)
      };
    }
    function assertInteger(value, name) {
      if (!Number.isInteger(value)) {
        throw new TypeError(`${name} option must be an integer`);
      }
    }
    function assertNumber$1(value, name) {
      if (!Number.isFinite(value)) {
        throw new TypeError(`${name} option must be a number`);
      }
    }
    function createMatrix(nbPoints) {
      const zMatrix = new Array(nbPoints.y);
      for (let i = 0; i < nbPoints.y; i++) {
        zMatrix[i] = new Float64Array(nbPoints.x);
      }
      return zMatrix;
    }

    function hasProperty(data, key) {
      return key in data;
    }

    const {
      parse: parse$7,
      stringify: stringify$7
    } = JSON;
    /**
     * convert width and fwhm to ppm
     */
    function convertWidth(peaks, options) {
      const {
        frequency,
        convertTo,
        output = parse$7(stringify$7(peaks))
      } = options;
      const convert = getConverter(convertTo, frequency);
      for (const peak of output) {
        peak.width = convert(peak.width);
        if (hasProperty(peak, 'shape')) {
          const shape = peak.shape;
          if (shape.fwhm) {
            shape.fwhm = convert(shape.fwhm);
          }
        }
      }
      return output;
    }
    function getConverter(convertTo, frequency) {
      switch (convertTo) {
        case 'ppm':
          return x => x / frequency;
        case 'hz':
          return x => x * frequency;
        default:
          throw new Error(`Does not support convert to ${convertTo}`);
      }
    }

    function convertWidthToPPM(peaks, options) {
      return convertWidth(peaks, {
        ...options,
        convertTo: 'ppm'
      });
    }

    function peaksToXY(peaks, options) {
      const {
        frequency,
        nbPoints = 1024,
        shape
      } = options;
      if (!frequency) {
        throw new Error('frequency is mandatory');
      }
      const newPeaks = convertWidthToPPM(peaks, {
        frequency
      });
      return generateSpectrum(newPeaks, {
        generator: {
          ...getFromTo$1(newPeaks, options),
          nbPoints,
          shape
        }
      });
    }
    function getFromTo$1(newPeaks, options) {
      if ('to' in options && 'from' in options) {
        return {
          from: options.from,
          to: options.to
        };
      }
      newPeaks.sort((a, b) => a.x - b.x);
      const firstPeak = newPeaks[0];
      const lastPeak = newPeaks[newPeaks.length - 1];
      const {
        from = firstPeak.x - firstPeak.width * 2 / options.frequency,
        to = lastPeak.x + lastPeak.width * 2 / options.frequency
      } = options;
      return {
        from,
        to
      };
    }

    var IDX = 256,
      HEX = [],
      BUFFER;
    while (IDX--) HEX[IDX] = (IDX + 256).toString(16).substring(1);
    function v4() {
      var i = 0,
        num,
        out = '';
      if (!BUFFER || IDX + 16 > 256) {
        BUFFER = Array(i = 256);
        while (i--) BUFFER[i] = 256 * Math.random() | 0;
        i = IDX = 0;
      }
      for (; i < 16; i++) {
        num = BUFFER[IDX + i];
        if (i == 6) out += HEX[num & 15 | 64];else if (i == 8) out += HEX[num & 63 | 128];else out += HEX[num];
        if (i & 1 && i > 1 && i < 11) out += '-';
      }
      IDX++;
      return out;
    }

    /**
     * Apply Savitzky Golay algorithm
     * @param [ys] Array of y values
     * @param [xs] Array of X or deltaX
     * @return  Array containing the new ys (same length)
     */
    function sgg(ys, xs, options = {}) {
      let {
        windowSize = 9,
        derivative = 0,
        polynomial = 3
      } = options;
      if (windowSize % 2 === 0 || windowSize < 5 || !Number.isInteger(windowSize)) {
        throw new RangeError('Invalid window size (should be odd and at least 5 integer number)');
      }
      if (!isAnyArray(ys)) {
        throw new TypeError('Y values must be an array');
      }
      if (typeof xs === 'undefined') {
        throw new TypeError('X must be defined');
      }
      if (windowSize > ys.length) {
        throw new RangeError(`Window size is higher than the data length ${windowSize}>${ys.length}`);
      }
      if (derivative < 0 || !Number.isInteger(derivative)) {
        throw new RangeError('Derivative should be a positive integer');
      }
      if (polynomial < 1 || !Number.isInteger(polynomial)) {
        throw new RangeError('Polynomial should be a positive integer');
      }
      if (polynomial >= 6) {
        // eslint-disable-next-line no-console
        console.warn('You should not use polynomial grade higher than 5 if you are' + ' not sure that your data arises from such a model. Possible polynomial oscillation problems');
      }
      let half = Math.floor(windowSize / 2);
      let np = ys.length;
      let ans = new Float64Array(np);
      let weights = fullWeights(windowSize, polynomial, derivative);
      let hs = 0;
      let constantH = true;
      if (isAnyArray(xs)) {
        constantH = false;
      } else {
        hs = Math.pow(xs, derivative);
      }
      //For the borders
      for (let i = 0; i < half; i++) {
        let wg1 = weights[half - i - 1];
        let wg2 = weights[half + i + 1];
        let d1 = 0;
        let d2 = 0;
        for (let l = 0; l < windowSize; l++) {
          d1 += wg1[l] * ys[l];
          d2 += wg2[l] * ys[np - windowSize + l];
        }
        if (constantH) {
          ans[half - i - 1] = d1 / hs;
          ans[np - half + i] = d2 / hs;
        } else {
          hs = getHs(xs, half - i - 1, half, derivative);
          ans[half - i - 1] = d1 / hs;
          hs = getHs(xs, np - half + i, half, derivative);
          ans[np - half + i] = d2 / hs;
        }
      }
      //For the internal points
      let wg = weights[half];
      for (let i = windowSize; i <= np; i++) {
        let d = 0;
        for (let l = 0; l < windowSize; l++) d += wg[l] * ys[l + i - windowSize];
        if (!constantH) {
          hs = getHs(xs, i - half - 1, half, derivative);
        }
        ans[i - half - 1] = d / hs;
      }
      return ans;
    }
    function getHs(h, center, half, derivative) {
      let hs = 0;
      let count = 0;
      for (let i = center - half; i < center + half; i++) {
        if (i >= 0 && i < h.length - 1) {
          hs += h[i + 1] - h[i];
          count++;
        }
      }
      return Math.pow(hs / count, derivative);
    }
    function gramPoly(i, m, k, s) {
      let Grampoly = 0;
      if (k > 0) {
        Grampoly = (4 * k - 2) / (k * (2 * m - k + 1)) * (i * gramPoly(i, m, k - 1, s) + s * gramPoly(i, m, k - 1, s - 1)) - (k - 1) * (2 * m + k) / (k * (2 * m - k + 1)) * gramPoly(i, m, k - 2, s);
      } else {
        if (k === 0 && s === 0) {
          Grampoly = 1;
        } else {
          Grampoly = 0;
        }
      }
      return Grampoly;
    }
    function genFact(a, b) {
      let gf = 1;
      if (a >= b) {
        for (let j = a - b + 1; j <= a; j++) {
          gf *= j;
        }
      }
      return gf;
    }
    function weight(i, t, m, n, s) {
      let sum = 0;
      for (let k = 0; k <= n; k++) {
        sum += (2 * k + 1) * (genFact(2 * m, k) / genFact(2 * m + k + 1, k + 1)) * gramPoly(i, m, k, 0) * gramPoly(t, m, k, s);
      }
      return sum;
    }
    /**
     * @private
     * @param m  Number of points
     * @param n  Polynomial grade
     * @param s  Derivative
     */
    function fullWeights(m, n, s) {
      let weights = new Array(m);
      let np = Math.floor(m / 2);
      for (let t = -np; t <= np; t++) {
        weights[t + np] = new Float64Array(m);
        for (let j = -np; j <= np; j++) {
          weights[t + np][j + np] = weight(j, t, np, n, s);
        }
      }
      return weights;
    }

    /**
     * Correction of the x and y coordinates using a quadratic optimizations with the peak and its 3 closest neighbors to determine the true x,y values of the peak.
     * This process is done in place and is very fast.
     * @param data
     * @param peaks
     */
    function optimizeTop(data, peaks) {
      const {
        x,
        y
      } = data;
      for (const peak of peaks) {
        let currentIndex = peak.index;
        // The detected peak could be moved 1 or 2 units to left or right.
        if (y[currentIndex - 1] >= y[currentIndex - 2] && y[currentIndex - 1] >= y[currentIndex]) {
          currentIndex--;
        } else if (y[currentIndex + 1] >= y[currentIndex] && y[currentIndex + 1] >= y[currentIndex + 2]) {
          currentIndex++;
        } else if (y[currentIndex - 2] >= y[currentIndex - 3] && y[currentIndex - 2] >= y[currentIndex - 1]) {
          currentIndex -= 2;
        } else if (y[currentIndex + 2] >= y[currentIndex + 1] && y[currentIndex + 2] >= y[currentIndex + 3]) {
          currentIndex += 2;
        }
        // interpolation to a sin() function
        if (y[currentIndex - 1] > 0 && y[currentIndex + 1] > 0 && y[currentIndex] >= y[currentIndex - 1] && y[currentIndex] >= y[currentIndex + 1] && (y[currentIndex] !== y[currentIndex - 1] || y[currentIndex] !== y[currentIndex + 1])) {
          let alpha = 20 * Math.log10(y[currentIndex - 1]);
          let beta = 20 * Math.log10(y[currentIndex]);
          let gamma = 20 * Math.log10(y[currentIndex + 1]);
          let p = 0.5 * (alpha - gamma) / (alpha - 2 * beta + gamma);
          peak.x = x[currentIndex] + (x[currentIndex] - x[currentIndex - 1]) * p;
          peak.y = y[currentIndex] - 0.25 * (y[currentIndex - 1] - y[currentIndex + 1]) * p;
        }
      }
    }

    /**
     * Global spectra deconvolution
     * @param  data - Object data with x and y arrays. Values in x has to be growing
     * @param {number} [options.broadRatio = 0.00] - If `broadRatio` is higher than 0, then all the peaks which second derivative
     * smaller than `broadRatio * maxAbsSecondDerivative` will be marked with the soft mask equal to true.

     */
    function gsd(data, options = {}) {
      let {
        sgOptions = {
          windowSize: 9,
          polynomial: 3
        },
        noiseLevel,
        smoothY = false,
        maxCriteria = true,
        minMaxRatio = 0.00025,
        realTopDetection = false
      } = options;
      let {
        x,
        y
      } = data;
      if (xIsMonotonic(x) !== 1) {
        throw new Error('GSD only accepts monotone increasing x values');
      }
      //rescale;
      y = y.slice();
      // If the max difference between delta x is less than 5%, then,
      // we can assume it to be equally spaced variable
      let equallySpaced = xIsEquallySpaced(x);
      if (noiseLevel === undefined) {
        if (equallySpaced) {
          const noiseInfo = xNoiseStandardDeviation(y);
          if (maxCriteria) {
            noiseLevel = noiseInfo.median + 1.5 * noiseInfo.sd;
          } else {
            noiseLevel = -noiseInfo.median + 1.5 * noiseInfo.sd;
          }
        } else {
          noiseLevel = 0;
        }
      } else if (!maxCriteria) {
        noiseLevel *= -1;
      }
      if (!maxCriteria) {
        for (let i = 0; i < y.length; i++) {
          y[i] *= -1;
        }
      }
      if (noiseLevel !== undefined) {
        for (let i = 0; i < y.length; i++) {
          if (y[i] < noiseLevel) {
            y[i] = noiseLevel;
          }
        }
      }
      let yData = y;
      let dY, ddY;
      const {
        windowSize,
        polynomial
      } = sgOptions;
      if (equallySpaced) {
        if (smoothY) {
          yData = sgg(y, x[1] - x[0], {
            windowSize,
            polynomial,
            derivative: 0
          });
        }
        dY = sgg(y, x[1] - x[0], {
          windowSize,
          polynomial,
          derivative: 1
        });
        ddY = sgg(y, x[1] - x[0], {
          windowSize,
          polynomial,
          derivative: 2
        });
      } else {
        if (smoothY) {
          yData = sgg(y, x, {
            windowSize,
            polynomial,
            derivative: 0
          });
        }
        dY = sgg(y, x, {
          windowSize,
          polynomial,
          derivative: 1
        });
        ddY = sgg(y, x, {
          windowSize,
          polynomial,
          derivative: 2
        });
      }
      const minY = xMinValue(yData);
      const maxY = xMaxValue(yData);
      if (minY > maxY || minY === maxY) return [];
      const yThreshold = minY + (maxY - minY) * minMaxRatio;
      const dX = x[1] - x[0];
      let lastMax = null;
      let lastMin = null;
      let minddY = [];
      let intervalL = [];
      let intervalR = [];
      // By the intermediate value theorem We cannot find 2 consecutive maximum or minimum
      for (let i = 1; i < yData.length - 1; ++i) {
        if (dY[i] < dY[i - 1] && dY[i] <= dY[i + 1] || dY[i] <= dY[i - 1] && dY[i] < dY[i + 1]) {
          lastMin = {
            x: x[i],
            index: i
          };
          if (dX > 0 && lastMax !== null) {
            intervalL.push(lastMax);
            intervalR.push(lastMin);
          }
        }
        // Maximum in first derivative
        if (dY[i] >= dY[i - 1] && dY[i] > dY[i + 1] || dY[i] > dY[i - 1] && dY[i] >= dY[i + 1]) {
          lastMax = {
            x: x[i],
            index: i
          };
          if (dX < 0 && lastMin !== null) {
            intervalL.push(lastMax);
            intervalR.push(lastMin);
          }
        }
        // Minimum in second derivative
        if (ddY[i] < ddY[i - 1] && ddY[i] < ddY[i + 1]) {
          minddY.push(i);
        }
      }
      let lastK = -1;
      const peaks = [];
      for (const minddYIndex of minddY) {
        let deltaX = x[minddYIndex];
        let possible = -1;
        let k = lastK + 1;
        let minDistance = Number.POSITIVE_INFINITY;
        let currentDistance = 0;
        while (possible === -1 && k < intervalL.length) {
          currentDistance = Math.abs(deltaX - (intervalL[k].x + intervalR[k].x) / 2);
          if (currentDistance < (intervalR[k].x - intervalL[k].x) / 2) {
            possible = k;
            lastK = k;
          }
          ++k;
          // Not getting closer?
          if (currentDistance >= minDistance) {
            break;
          }
          minDistance = currentDistance;
        }
        if (possible !== -1) {
          if (yData[minddYIndex] > yThreshold) {
            let width = Math.abs(intervalR[possible].x - intervalL[possible].x);
            peaks.push({
              id: v4(),
              x: deltaX,
              y: yData[minddYIndex],
              width,
              index: minddYIndex,
              ddY: ddY[minddYIndex],
              inflectionPoints: {
                from: intervalL[possible],
                to: intervalR[possible]
              }
            });
          }
        }
      }
      if (realTopDetection) {
        optimizeTop({
          x,
          y: yData
        }, peaks);
      }
      peaks.forEach(peak => {
        if (!maxCriteria) {
          peak.y *= -1;
          peak.ddY = peak.ddY * -1;
        }
      });
      peaks.sort((a, b) => {
        return a.x - b.x;
      });
      return peaks;
    }

    /**
     * This function returns the sumOfShapes function
     * This function gives sumOfShapes access to the peak list and the associated data
     * @param parameters - parameters
     */
    function getSumOfShapes$1(internalPeaks) {
      return function sumOfShapes(parameters) {
        return x => {
          let totalY = 0;
          for (const peak of internalPeaks) {
            const peakX = parameters[peak.fromIndex];
            const y = parameters[peak.fromIndex + 1];
            for (let i = 2; i < parameters.length; i++) {
              //@ts-expect-error Not simply to solve the issue
              peak.shapeFct[peak.parameters[i]] = parameters[peak.fromIndex + i];
            }
            totalY += y * peak.shapeFct.fct(x - peakX);
          }
          return totalY;
        };
      };
    }

    /**
     * Asserts that value is truthy.
     *
     * @param value - Value to check.
     * @param message - Optional error message to throw.
     */
    function assert(value, message) {
      if (!value) {
        throw new Error(message ? message : 'unreachable');
      }
    }

    const DefaultParameters = {
      x: {
        init: peak => peak.x,
        min: (peak, peakShape) => peak.x - peakShape.fwhm * 2,
        max: (peak, peakShape) => peak.x + peakShape.fwhm * 2,
        gradientDifference: (peak, peakShape) => peakShape.fwhm * 2e-3
      },
      y: {
        init: peak => peak.y,
        min: peak => peak.y < 0 ? -1.1 : 0,
        max: peak => peak.y < 0 ? 0 : 1.1,
        gradientDifference: () => 1e-3
      },
      fwhm: {
        init: (peak, peakShape) => peakShape.fwhm,
        min: (peak, peakShape) => peakShape.fwhm * 0.25,
        max: (peak, peakShape) => peakShape.fwhm * 4,
        gradientDifference: (peak, peakShape) => peakShape.fwhm * 2e-3
      },
      mu: {
        init: (peak, peakShape) => peakShape.mu,
        min: () => 0,
        max: () => 1,
        gradientDifference: () => 0.01
      }
    };

    const properties$1 = ['init', 'min', 'max', 'gradientDifference'];
    /**
     * Return an array of internalPeaks that contains the exact init, min, max values based on the options
     * @param peaks
     * @param options
     * @returns
     */
    function getInternalPeaks(peaks, minMaxY, options = {}) {
      let index = 0;
      let internalPeaks = [];
      const {
        baseline: shiftValue = minMaxY.min
      } = options;
      const normalizedPeaks = peaks.map(peak => {
        return {
          ...peak,
          y: (peak.y - shiftValue) / minMaxY.range
        };
      });
      for (const peak of normalizedPeaks) {
        const {
          id,
          shape = options.shape ? options.shape : {
            kind: 'gaussian'
          }
        } = peak;
        const shapeFct = getShape1D(shape);
        const parameters = ['x', 'y', ...shapeFct.getParameters()];
        const propertiesValues = {
          min: [],
          max: [],
          init: [],
          gradientDifference: []
        };
        for (let parameter of parameters) {
          for (let property of properties$1) {
            // check if the property is specified in the peak
            let propertyValue = peak?.parameters?.[parameter]?.[property];
            if (propertyValue) {
              propertyValue = getNormalizedValue$1(propertyValue, parameter, property, minMaxY, options.baseline);
              propertiesValues[property].push(propertyValue);
              continue;
            }
            // check if there are some global option, it could be a number or a callback
            let generalParameterValue = options?.parameters?.[parameter]?.[property];
            if (generalParameterValue) {
              if (typeof generalParameterValue === 'number') {
                generalParameterValue = getNormalizedValue$1(generalParameterValue, parameter, property, minMaxY, options.baseline);
                propertiesValues[property].push(generalParameterValue);
                continue;
              } else {
                let value = generalParameterValue(peak);
                value = getNormalizedValue$1(value, parameter, property, minMaxY, options.baseline);
                propertiesValues[property].push(value);
                continue;
              }
            }
            // we just need to take the default parameters
            assert(DefaultParameters[parameter], `No default parameter for ${parameter}`);
            const defaultParameterValues = DefaultParameters[parameter][property];
            //@ts-expect-error should never happen
            propertiesValues[property].push(defaultParameterValues(peak, shapeFct));
          }
        }
        const fromIndex = index;
        const toIndex = fromIndex + parameters.length - 1;
        index += toIndex - fromIndex + 1;
        internalPeaks.push({
          id,
          shape,
          shapeFct,
          parameters,
          propertiesValues,
          fromIndex,
          toIndex
        });
      }
      return internalPeaks;
    }
    function getNormalizedValue$1(value, parameter, property, minMaxY, baseline) {
      if (parameter === 'y') {
        if (property === 'gradientDifference') {
          return value;
        } else {
          return baseline !== undefined ? (value - baseline) / minMaxY.range : (value - minMaxY.min) / minMaxY.range;
        }
      }
      return value;
    }

    function checkOptions(data, parameterizedFunction, options) {
      let {
        timeout,
        minValues,
        maxValues,
        initialValues,
        weights = 1,
        damping = 1e-2,
        dampingStepUp = 11,
        dampingStepDown = 9,
        maxIterations = 100,
        errorTolerance = 1e-7,
        centralDifference = false,
        gradientDifference = 10e-2,
        improvementThreshold = 1e-3
      } = options;
      if (damping <= 0) {
        throw new Error('The damping option must be a positive number');
      } else if (!data.x || !data.y) {
        throw new Error('The data parameter must have x and y elements');
      } else if (!isAnyArray(data.x) || data.x.length < 2 || !isAnyArray(data.y) || data.y.length < 2) {
        throw new Error('The data parameter elements must be an array with more than 2 points');
      } else if (data.x.length !== data.y.length) {
        throw new Error('The data parameter elements must have the same size');
      }
      if (!(initialValues && initialValues.length > 0)) {
        throw new Error('The initialValues option is mandatory and must be an array');
      }
      let parameters = initialValues;
      let nbPoints = data.y.length;
      let parLen = parameters.length;
      maxValues = maxValues || new Array(parLen).fill(Number.MAX_SAFE_INTEGER);
      minValues = minValues || new Array(parLen).fill(Number.MIN_SAFE_INTEGER);
      if (maxValues.length !== minValues.length) {
        throw new Error('minValues and maxValues must be the same size');
      }
      if (typeof gradientDifference === 'number') {
        gradientDifference = new Array(parameters.length).fill(gradientDifference);
      } else if (isAnyArray(gradientDifference)) {
        if (gradientDifference.length !== parLen) {
          gradientDifference = new Array(parLen).fill(gradientDifference[0]);
        }
      } else {
        throw new Error('gradientDifference should be a number or array with length equal to the number of parameters');
      }
      let filler;
      if (typeof weights === 'number') {
        let value = 1 / weights ** 2;
        filler = () => value;
      } else if (isAnyArray(weights)) {
        if (weights.length < data.x.length) {
          let value = 1 / weights[0] ** 2;
          filler = () => value;
        } else {
          filler = i => 1 / weights[i] ** 2;
        }
      } else {
        throw new Error('weights should be a number or array with length equal to the number of data points');
      }
      let checkTimeout;
      if (timeout !== undefined) {
        if (typeof timeout !== 'number') {
          throw new Error('timeout should be a number');
        }
        let endTime = Date.now() + timeout * 1000;
        checkTimeout = () => Date.now() > endTime;
      } else {
        checkTimeout = () => false;
      }
      let weightSquare = new Array(data.x.length);
      for (let i = 0; i < nbPoints; i++) {
        weightSquare[i] = filler(i);
      }
      return {
        checkTimeout,
        minValues,
        maxValues,
        parameters,
        weightSquare,
        damping,
        dampingStepUp,
        dampingStepDown,
        maxIterations,
        errorTolerance,
        centralDifference,
        gradientDifference,
        improvementThreshold
      };
    }

    /**
     * the sum of the weighted squares of the errors (or weighted residuals) between the data.y
     * and the curve-fit function.
     * @ignore
     * @param {{x:ArrayLike<number>, y:ArrayLike<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
     * @param {ArrayLike<number>} parameters - Array of current parameter values
     * @param {function} parameterizedFunction - The parameters and returns a function with the independent variable as a parameter
     * @param {ArrayLike<number>} weightSquare - Square of weights
     * @return {number}
     */
    function errorCalculation(data, parameters, parameterizedFunction, weightSquare) {
      let error = 0;
      const func = parameterizedFunction(parameters);
      for (let i = 0; i < data.x.length; i++) {
        error += Math.pow(data.y[i] - func(data.x[i]), 2) / weightSquare[i];
      }
      return error;
    }

    /**
     * Difference of the matrix function over the parameters
     * @ignore
     * @param {{x:ArrayLike<number>, y:ArrayLike<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
     * @param {ArrayLike<number>} evaluatedData - Array of previous evaluated function values
     * @param {Array<number>} params - Array of previous parameter values
     * @param {number|array} gradientDifference - The step size to approximate the jacobian matrix
     * @param {boolean} centralDifference - If true the jacobian matrix is approximated by central differences otherwise by forward differences
     * @param {function} paramFunction - The parameters and returns a function with the independent variable as a parameter
     * @return {Matrix}
     */
    function gradientFunction(data, evaluatedData, params, gradientDifference, paramFunction, centralDifference) {
      const nbParams = params.length;
      const nbPoints = data.x.length;
      let ans = Matrix.zeros(nbParams, nbPoints);
      let rowIndex = 0;
      for (let param = 0; param < nbParams; param++) {
        if (gradientDifference[param] === 0) continue;
        let delta = gradientDifference[param];
        let auxParams = params.slice();
        auxParams[param] += delta;
        let funcParam = paramFunction(auxParams);
        if (!centralDifference) {
          for (let point = 0; point < nbPoints; point++) {
            ans.set(rowIndex, point, (evaluatedData[point] - funcParam(data.x[point])) / delta);
          }
        } else {
          auxParams = params.slice();
          auxParams[param] -= delta;
          delta *= 2;
          let funcParam2 = paramFunction(auxParams);
          for (let point = 0; point < nbPoints; point++) {
            ans.set(rowIndex, point, (funcParam2(data.x[point]) - funcParam(data.x[point])) / delta);
          }
        }
        rowIndex++;
      }
      return ans;
    }

    /**
     * Matrix function over the samples
     * @ignore
     * @param {{x:ArrayLike<number>, y:ArrayLike<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
     * @param {ArrayLike<number>} evaluatedData - Array of previous evaluated function values
     * @return {Matrix}
     */
    function matrixFunction(data, evaluatedData) {
      const m = data.x.length;
      let ans = new Matrix(m, 1);
      for (let point = 0; point < m; point++) {
        ans.set(point, 0, data.y[point] - evaluatedData[point]);
      }
      return ans;
    }
    /**
     * Iteration for Levenberg-Marquardt
     * @ignore
     * @param {{x:ArrayLike<number>, y:ArrayLike<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
     * @param {Array<number>} params - Array of previous parameter values
     * @param {number} damping - Levenberg-Marquardt parameter
     * @param {number|array} gradientDifference - The step size to approximate the jacobian matrix
     * @param {boolean} centralDifference - If true the jacobian matrix is approximated by central differences otherwise by forward differences
     * @param {function} parameterizedFunction - The parameters and returns a function with the independent variable as a parameter
     */
    function step(data, params, damping, gradientDifference, parameterizedFunction, centralDifference, weights) {
      let value = damping;
      let identity = Matrix.eye(params.length, params.length, value);
      const func = parameterizedFunction(params);
      let evaluatedData = new Float64Array(data.x.length);
      for (let i = 0; i < data.x.length; i++) {
        evaluatedData[i] = func(data.x[i]);
      }
      let gradientFunc = gradientFunction(data, evaluatedData, params, gradientDifference, parameterizedFunction, centralDifference);
      let residualError = matrixFunction(data, evaluatedData);
      let inverseMatrix = inverse(identity.add(gradientFunc.mmul(gradientFunc.transpose().scale('row', {
        scale: weights
      }))));
      let jacobianWeightResidualError = gradientFunc.mmul(residualError.scale('row', {
        scale: weights
      }));
      let perturbations = inverseMatrix.mmul(jacobianWeightResidualError);
      return {
        perturbations,
        jacobianWeightResidualError
      };
    }

    /**
     * Curve fitting algorithm
     * @param {{x:ArrayLike<number>, y:ArrayLike<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
     * @param {function} parameterizedFunction - Takes an array of parameters and returns a function with the independent variable as its sole argument
     * @param {object} options - Options object
     * @param {ArrayLike<number>} options.initialValues - Array of initial parameter values
     * @param {number|ArrayLike<number>} [options.weights = 1] - weighting vector, if the length does not match with the number of data points, the vector is reconstructed with first value.
     * @param {number} [options.damping = 1e-2] - Levenberg-Marquardt parameter, small values of the damping parameter λ result in a Gauss-Newton update and large
    values of λ result in a gradient descent update
     * @param {number} [options.dampingStepDown = 9] - factor to reduce the damping (Levenberg-Marquardt parameter) when there is not an improvement when updating parameters.
     * @param {number} [options.dampingStepUp = 11] - factor to increase the damping (Levenberg-Marquardt parameter) when there is an improvement when updating parameters.
     * @param {number} [options.improvementThreshold = 1e-3] - the threshold to define an improvement through an update of parameters
     * @param {number|ArrayLike<number>} [options.gradientDifference = 10e-2] - The step size to approximate the jacobian matrix
     * @param {boolean} [options.centralDifference = false] - If true the jacobian matrix is approximated by central differences otherwise by forward differences
     * @param {ArrayLike<number>} [options.minValues] - Minimum allowed values for parameters
     * @param {ArrayLike<number>} [options.maxValues] - Maximum allowed values for parameters
     * @param {number} [options.maxIterations = 100] - Maximum of allowed iterations
     * @param {number} [options.errorTolerance = 10e-3] - Minimum uncertainty allowed for each point.
     * @param {number} [options.timeout] - maximum time running before throw in seconds.
     * @return {{parameterValues: Array<number>, parameterError: number, iterations: number}}
     */
    function levenbergMarquardt(data, parameterizedFunction, options) {
      let {
        checkTimeout,
        minValues,
        maxValues,
        parameters,
        weightSquare,
        damping,
        dampingStepUp,
        dampingStepDown,
        maxIterations,
        errorTolerance,
        centralDifference,
        gradientDifference,
        improvementThreshold
      } = checkOptions(data, parameterizedFunction, options);
      let error = errorCalculation(data, parameters, parameterizedFunction, weightSquare);
      let optimalError = error;
      let optimalParameters = parameters.slice();
      let converged = error <= errorTolerance;
      let iteration = 0;
      for (; iteration < maxIterations && !converged; iteration++) {
        let previousError = error;
        let {
          perturbations,
          jacobianWeightResidualError
        } = step(data, parameters, damping, gradientDifference, parameterizedFunction, centralDifference, weightSquare);
        for (let k = 0; k < parameters.length; k++) {
          parameters[k] = Math.min(Math.max(minValues[k], parameters[k] - perturbations.get(k, 0)), maxValues[k]);
        }
        error = errorCalculation(data, parameters, parameterizedFunction, weightSquare);
        if (isNaN(error)) break;
        if (error < optimalError - errorTolerance) {
          optimalError = error;
          optimalParameters = parameters.slice();
        }
        let improvementMetric = (previousError - error) / perturbations.transpose().mmul(perturbations.mul(damping).add(jacobianWeightResidualError)).get(0, 0);
        if (improvementMetric > improvementThreshold) {
          damping = Math.max(damping / dampingStepDown, 1e-7);
        } else {
          damping = Math.min(damping * dampingStepUp, 1e7);
        }
        if (checkTimeout()) {
          throw new Error(`The execution time is over to ${options.timeout} seconds`);
        }
        converged = error <= errorTolerance;
      }
      return {
        parameterValues: optimalParameters,
        parameterError: optimalError,
        iterations: iteration
      };
    }

    /**
     * Preparata, F. P., & Shamos, M. I. (2012). Computational geometry: an introduction. Springer Science & Business Media.
     * @param {Array} x - The array with x coordinates of the points.
     * @param {Array} y - The array with y coordinates of the points.
     * @return {Array} The indices of the points of anticlockwise lower convex hull
     * @private
     */
    function antiLowerConvexHull(x, y) {
      if (x.length !== y.length) {
        throw new RangeError('X and Y vectors has different dimensions');
      }
      const nbPoints = x.length - 1;
      if (nbPoints === 0) return [0];
      if (nbPoints === 1) return [0, 1];
      let currentPoint = 0;
      let result = new Array(x.length).fill(true);
      while (true) {
        const a = currentPoint;
        const b = moveOn(currentPoint, nbPoints, result);
        const c = moveOn(moveOn(currentPoint, nbPoints, result), nbPoints, result);
        const det = x[c] * (y[a] - y[b]) + x[a] * (y[b] - y[c]) + x[b] * (y[c] - y[a]);
        const leftTurn = det >= 0;
        if (leftTurn) {
          currentPoint = b;
        } else {
          result[b] = false;
          currentPoint = moveBack(currentPoint, nbPoints, result);
        }
        if (c === nbPoints) break;
      }
      return result.map((item, index) => item === false ? false : index).filter(item => item !== false);
    }

    /**
     * @param {number} currentPoint - The index of the current point to make the move
     * @param {number} nbPoints - The total number of points in the array
     * @param {Array} vector - The array with the points
     * @return {number} the index of the point after the move
     * @private
     */

    function moveBack(currentPoint, nbPoints, vector) {
      let counter = currentPoint - 1;
      while (vector[counter] === false) counter--;
      return currentPoint === 0 ? nbPoints : counter;
    }
    function moveOn(currentPoint, nbPoints, vector) {
      let counter = currentPoint + 1;
      while (vector[counter] === false) counter++;
      return currentPoint === nbPoints ? 0 : counter;
    }

    /**
     * Performs a global optimization of required parameters
     * It will return an object containing:
     * - `minFunctionValue`: The minimum value found for the objetive function
     * - `optima`: Array of Array of values for all the variables where the function reach its minimum value
     * - `iterations`: Number of iterations performed in the process
     * - `finalState`: Internal state allowing to continue optimization (initialState)
     * @param {function} objectiveFunction Function to evaluate. It should accept an array of variables
     * @param {Array} lowerBoundaries Array containing for each variable the lower boundary
     * @param {Array} upperBoundaries Array containing for each variable the higher boundary
     * @param {Object} [options={}]
     * @param {number} [options.iterations] - Number of iterations.
     * @param {number} [options.epsilon] - Tolerance to choose best current value.
     * @param {number} [options.tolerance] - Minimum tollerance of the function.
     * @param {number} [options.tolerance2] - Minimum tollerance of the function.
     * @param {Object} [options.initialState={}}] - finalState of previous optimization.
     * @return {Object} {finalState, iterations, minFunctionValue}
     * */

    function direct(objectiveFunction, lowerBoundaries, upperBoundaries, options = {}) {
      const {
        iterations = 50,
        epsilon = 1e-4,
        tolerance = 1e-16,
        tolerance2 = 1e-12,
        initialState = {}
      } = options;
      if (objectiveFunction === undefined || lowerBoundaries === undefined || upperBoundaries === undefined) {
        throw new RangeError('There is something undefined');
      }
      lowerBoundaries = new Float64Array(lowerBoundaries);
      upperBoundaries = new Float64Array(upperBoundaries);
      if (lowerBoundaries.length !== upperBoundaries.length) {
        throw new Error('Lower bounds and Upper bounds for x are not of the same length');
      }

      //-------------------------------------------------------------------------
      //                        STEP 1. Initialization
      //-------------------------------------------------------------------------
      let n = lowerBoundaries.length;
      let diffBorders = upperBoundaries.map((x, i) => x - lowerBoundaries[i]);
      let {
        numberOfRectangles = 0,
        totalIterations = 0,
        unitaryCoordinates = [new Float64Array(n).fill(0.5)],
        middlePoint = new Float64Array(n).map((value, index) => {
          return lowerBoundaries[index] + unitaryCoordinates[0][index] * diffBorders[index];
        }),
        bestCurrentValue = objectiveFunction(middlePoint),
        fCalls = 1,
        smallerDistance = 0,
        edgeSizes = [new Float64Array(n).fill(0.5)],
        diagonalDistances = [Math.sqrt(n * Math.pow(0.5, 2))],
        functionValues = [bestCurrentValue],
        differentDistances = diagonalDistances,
        smallerValuesByDistance = [bestCurrentValue],
        choiceLimit = undefined
      } = initialState;
      if (initialState.originalCoordinates && initialState.originalCoordinates.length > 0) {
        bestCurrentValue = xMinValue(functionValues);
        choiceLimit = epsilon * Math.abs(bestCurrentValue) > 1e-8 ? epsilon * Math.abs(bestCurrentValue) : 1e-8;
        smallerDistance = getMinIndex(functionValues, diagonalDistances, choiceLimit, bestCurrentValue);
        unitaryCoordinates = initialState.originalCoordinates.slice();
        for (let j = 0; j < unitaryCoordinates.length; j++) {
          for (let i = 0; i < lowerBoundaries.length; i++) {
            unitaryCoordinates[j][i] = (unitaryCoordinates[j][i] - lowerBoundaries[i]) / diffBorders[i];
          }
        }
      }
      let iteration = 0;
      //-------------------------------------------------------------------------
      //                          Iteration loop
      //-------------------------------------------------------------------------

      while (iteration < iterations) {
        //----------------------------------------------------------------------
        //  STEP 2. Identify the set S of all potentially optimal rectangles
        //----------------------------------------------------------------------

        let S1 = [];
        let idx = differentDistances.findIndex(
        // eslint-disable-next-line no-loop-func
        e => e === diagonalDistances[smallerDistance]);
        let counter = 0;
        for (let i = idx; i < differentDistances.length; i++) {
          for (let f = 0; f < functionValues.length; f++) {
            if (functionValues[f] === smallerValuesByDistance[i] & diagonalDistances[f] === differentDistances[i]) {
              S1[counter++] = f;
            }
          }
        }
        let optimumValuesIndex, S3;
        if (differentDistances.length - idx > 1) {
          let a1 = diagonalDistances[smallerDistance];
          let b1 = functionValues[smallerDistance];
          let a2 = differentDistances[differentDistances.length - 1];
          let b2 = smallerValuesByDistance[differentDistances.length - 1];
          let slope = (b2 - b1) / (a2 - a1);
          let constant = b1 - slope * a1;
          let S2 = new Uint32Array(counter);
          counter = 0;
          for (let i = 0; i < S2.length; i++) {
            let j = S1[i];
            if (functionValues[j] <= slope * diagonalDistances[j] + constant + tolerance2) {
              S2[counter++] = j;
            }
          }
          let xHull = [];
          let yHull = [];
          for (let i = 0; i < counter; i++) {
            xHull.push(diagonalDistances[S2[i]]);
            yHull.push(functionValues[S2[i]]);
          }
          let lowerIndexHull = antiLowerConvexHull(xHull, yHull);
          S3 = [];
          for (let i = 0; i < lowerIndexHull.length; i++) {
            S3.push(S2[lowerIndexHull[i]]);
          }
        } else {
          S3 = S1.slice(0, counter);
        }
        optimumValuesIndex = S3;
        //--------------------------------------------------------------
        // STEPS 3,5: Select any rectangle j in S
        //--------------------------------------------------------------
        for (let k = 0; k < optimumValuesIndex.length; k++) {
          let j = optimumValuesIndex[k];
          let largerSide = xMaxValue(edgeSizes[j]);
          let largeSidesIndex = new Uint32Array(edgeSizes[j].length);
          counter = 0;
          for (let i = 0; i < edgeSizes[j].length; i++) {
            if (Math.abs(edgeSizes[j][i] - largerSide) < tolerance) {
              largeSidesIndex[counter++] = i;
            }
          }
          let delta = 2 * largerSide / 3;
          let bestFunctionValues = [];
          for (let r = 0; r < counter; r++) {
            let i = largeSidesIndex[r];
            let firstMiddleCenter = unitaryCoordinates[j].slice();
            let secondMiddleCenter = unitaryCoordinates[j].slice();
            firstMiddleCenter[i] += delta;
            secondMiddleCenter[i] -= delta;
            let firstMiddleValue = new Float64Array(firstMiddleCenter.length);
            let secondMiddleValue = new Float64Array(secondMiddleCenter.length);
            for (let i = 0; i < firstMiddleCenter.length; i++) {
              firstMiddleValue[i] = lowerBoundaries[i] + firstMiddleCenter[i] * diffBorders[i];
              secondMiddleValue[i] = lowerBoundaries[i] + secondMiddleCenter[i] * diffBorders[i];
            }
            let firstMinValue = objectiveFunction(firstMiddleValue);
            let secondMinValue = objectiveFunction(secondMiddleValue);
            fCalls += 2;
            bestFunctionValues.push({
              minValue: Math.min(firstMinValue, secondMinValue),
              index: r
            });
            // [Math.min(firstMinValue, secondMinValue), r];
            unitaryCoordinates.push(firstMiddleCenter, secondMiddleCenter);
            functionValues.push(firstMinValue, secondMinValue);
          }
          let b = bestFunctionValues.sort((a, b) => a.minValue - b.minValue);
          for (let r = 0; r < counter; r++) {
            let u = largeSidesIndex[b[r].index];
            let ix1 = numberOfRectangles + 2 * (b[r].index + 1) - 1;
            let ix2 = numberOfRectangles + 2 * (b[r].index + 1);
            edgeSizes[j][u] = delta / 2;
            edgeSizes[ix1] = edgeSizes[j].slice();
            edgeSizes[ix2] = edgeSizes[j].slice();
            diagonalDistances[j] = xNorm(edgeSizes[j]);
            diagonalDistances[ix1] = diagonalDistances[j];
            diagonalDistances[ix2] = diagonalDistances[j];
          }
          numberOfRectangles += 2 * counter;
        }

        //--------------------------------------------------------------
        //                  Update
        //--------------------------------------------------------------

        bestCurrentValue = xMinValue(functionValues);
        choiceLimit = epsilon * Math.abs(bestCurrentValue) > 1e-8 ? epsilon * Math.abs(bestCurrentValue) : 1e-8;
        smallerDistance = getMinIndex(functionValues, diagonalDistances, choiceLimit, bestCurrentValue);
        differentDistances = Array.from(new Set(diagonalDistances));
        differentDistances = differentDistances.sort((a, b) => a - b);
        smallerValuesByDistance = [];
        for (let i = 0; i < differentDistances.length; i++) {
          let minIndex;
          let minValue = Number.POSITIVE_INFINITY;
          for (let k = 0; k < diagonalDistances.length; k++) {
            if (diagonalDistances[k] === differentDistances[i]) {
              if (functionValues[k] < minValue) {
                minValue = functionValues[k];
                minIndex = k;
              }
            }
          }
          smallerValuesByDistance.push(functionValues[minIndex]);
        }
        for (let j = 0; j < functionValues.length; j++) {
          if (functionValues[j] === bestCurrentValue) {
            let temp = [];
            for (let i = 0; i < lowerBoundaries.length; i++) {
              temp.push(lowerBoundaries[i] + unitaryCoordinates[j][i] * diffBorders[i]);
            }
          }
        }
        iteration += 1;
      }
      //--------------------------------------------------------------
      //                  Saving results
      //--------------------------------------------------------------

      let result = {};
      result.minFunctionValue = bestCurrentValue;
      result.iterations = iteration;
      let originalCoordinates = [];
      for (let j = 0; j < numberOfRectangles + 1; j++) {
        let pair = [];
        for (let i = 0; i < lowerBoundaries.length; i++) {
          pair.push(lowerBoundaries[i] + unitaryCoordinates[j][i] * diffBorders[i]);
        }
        originalCoordinates.push(pair);
      }
      result.finalState = {
        numberOfRectangles,
        totalIterations: totalIterations += iterations,
        originalCoordinates,
        middlePoint,
        fCalls,
        smallerDistance,
        edgeSizes,
        diagonalDistances,
        functionValues,
        differentDistances,
        smallerValuesByDistance,
        choiceLimit
      };
      let minimizer = [];
      for (let i = 0; i < functionValues.length; i++) {
        if (functionValues[i] === bestCurrentValue) {
          minimizer.push(originalCoordinates[i]);
        }
      }
      result.optima = minimizer;
      return result;
    }
    function getMinIndex(functionValues, diagonalDistances, choiceLimit, bestCurrentValue) {
      let item = [];
      for (let i = 0; i < functionValues.length; i++) {
        item[i] = Math.abs(functionValues[i] - (bestCurrentValue + choiceLimit)) / diagonalDistances[i];
      }
      const min = xMinValue(item);
      let result = item.findIndex(x => x === min);
      return result;
    }

    function directOptimization$1(data, sumOfShapes, options) {
      const {
        minValues,
        maxValues,
        maxIterations,
        epsilon,
        tolerance,
        tolerance2,
        initialState
      } = options;
      const objectiveFunction = getObjectiveFunction$1(data, sumOfShapes);
      const result = direct(objectiveFunction, minValues, maxValues, {
        iterations: maxIterations,
        epsilon,
        tolerance,
        tolerance2,
        initialState
      });
      const {
        optima
      } = result;
      return {
        parameterError: result.minFunctionValue,
        iterations: result.iterations,
        parameterValues: optima[0]
      };
    }
    function getObjectiveFunction$1(data, sumOfShapes) {
      const {
        x,
        y
      } = data;
      const nbPoints = x.length;
      return parameters => {
        const fct = sumOfShapes(parameters);
        let error = 0;
        for (let i = 0; i < nbPoints; i++) {
          error += Math.pow(y[i] - fct(x[i]), 2);
        }
        return error;
      };
    }

    /** Algorithm to select the method.
     * @param optimizationOptions - Optimization options
     * @returns - The algorithm and optimization options
     */
    function selectMethod(optimizationOptions = {}) {
      let {
        kind = 'lm',
        options
      } = optimizationOptions;
      switch (kind) {
        case 'lm':
        case 'levenbergMarquardt':
          return {
            algorithm: levenbergMarquardt,
            optimizationOptions: {
              damping: 1.5,
              maxIterations: 100,
              errorTolerance: 1e-8,
              ...options
            }
          };
        case 'direct':
          {
            return {
              algorithm: directOptimization$1,
              optimizationOptions: {
                iterations: 20,
                epsilon: 1e-4,
                tolerance: 1e-16,
                tolerance2: 1e-12,
                initialState: {},
                ...options
              }
            };
          }
        default:
          throw new Error(`Unknown fitting algorithm`);
      }
    }

    /**
     * Fits a set of points to the sum of a set of bell functions.
     *
     * @param data - An object containing the x and y data to be fitted.
     * @param peaks - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
     * @param options - Options for optimize
     * @returns - An object with fitting error and the list of optimized parameters { parameters: [ {x, y, width} ], error } if the kind of shape is pseudoVoigt mu parameter is optimized.
     */
    function optimize(data, peaks, options = {}) {
      // rescale data
      let temp = xMinMaxValues(data.y);
      const minMaxY = {
        ...temp,
        range: temp.max - temp.min
      };
      const internalPeaks = getInternalPeaks(peaks, minMaxY, options);
      // need to rescale what is related to Y
      const {
        baseline: shiftValue = minMaxY.min
      } = options;
      let normalizedY = new Float64Array(data.y.length);
      for (let i = 0; i < data.y.length; i++) {
        normalizedY[i] = (data.y[i] - shiftValue) / minMaxY.range;
      }
      const nbParams = internalPeaks[internalPeaks.length - 1].toIndex + 1;
      const minValues = new Float64Array(nbParams);
      const maxValues = new Float64Array(nbParams);
      const initialValues = new Float64Array(nbParams);
      const gradientDifferences = new Float64Array(nbParams);
      let index = 0;
      for (const peak of internalPeaks) {
        for (let i = 0; i < peak.parameters.length; i++) {
          minValues[index] = peak.propertiesValues.min[i];
          maxValues[index] = peak.propertiesValues.max[i];
          initialValues[index] = peak.propertiesValues.init[i];
          gradientDifferences[index] = peak.propertiesValues.gradientDifference[i];
          index++;
        }
      }
      let {
        algorithm,
        optimizationOptions
      } = selectMethod(options.optimization);
      let sumOfShapes = getSumOfShapes$1(internalPeaks);
      let fitted = algorithm({
        x: data.x,
        y: normalizedY
      }, sumOfShapes, {
        minValues,
        maxValues,
        initialValues,
        gradientDifference: gradientDifferences,
        ...optimizationOptions
      });
      const fittedValues = fitted.parameterValues;
      let newPeaks = [];
      for (let peak of internalPeaks) {
        const {
          id,
          shape,
          parameters,
          fromIndex
        } = peak;
        let newPeak = {
          x: 0,
          y: 0,
          shape
        };
        if (id) {
          newPeak = {
            ...newPeak,
            id
          };
        }
        newPeak.x = fittedValues[fromIndex];
        newPeak.y = fittedValues[fromIndex + 1] * minMaxY.range + shiftValue;
        for (let i = 2; i < parameters.length; i++) {
          //@ts-expect-error should be fixed once
          newPeak.shape[parameters[i]] = fittedValues[fromIndex + i];
        }
        newPeaks.push(newPeak);
      }
      return {
        error: fitted.parameterError,
        iterations: fitted.iterations,
        peaks: newPeaks
      };
    }

    const {
      parse: parse$6,
      stringify: stringify$6
    } = JSON;
    /**
     * add missing property if it does not exist in the peak,
     * if shape exists but fwhm doesn't, it will be calculated from peak.width
     */
    function addMissingShape(peaks, options = {}) {
      const {
        shape = {
          kind: 'gaussian'
        },
        output = parse$6(stringify$6(peaks))
      } = options;
      let shapeInstance = getShape1D(shape);
      return output.map(peak => {
        if (hasShape(peak)) {
          if (!('fwhm' in peak.shape)) {
            const shapeInstance = getShape1D(peak.shape);
            peak.shape.fwhm = shapeInstance.widthToFWHM(peak.width);
          }
          return peak;
        }
        return {
          ...peak,
          shape: {
            fwhm: shapeInstance.widthToFWHM(peak.width),
            ...shape
          }
        };
      });
    }
    function hasShape(peak) {
      return 'shape' in peak;
    }

    /**
     * Group peaks based on factor
     * In order to group peaks we only need the x and width value. This means that
     * in the current implementation we don't take into account the asymmetry of peaks
     */
    function groupPeaks(peaks, options = {}) {
      if (peaks && peaks.length === 0) return [];
      const {
        factor = 1
      } = options;
      peaks = JSON.parse(JSON.stringify(peaks));
      peaks.sort((a, b) => a.x - b.x);
      let previousPeak = peaks[0];
      let currentGroup = [previousPeak];
      let groups = [currentGroup];
      for (let i = 1; i < peaks.length; i++) {
        const peak = peaks[i];
        if ((peak.x - previousPeak.x) / ((peak.width + previousPeak.width) / 2) <= factor) {
          currentGroup.push(peak);
        } else {
          currentGroup = [peak];
          groups.push(currentGroup);
        }
        previousPeak = peak;
      }
      return groups;
    }

    /**
     * Optimize the position (x), max intensity (y), full width at half maximum (fwhm)
     * and the ratio of gaussian contribution (mu) if it's required. It currently supports three kind of shapes: gaussian, lorentzian and pseudovoigt
     * @param data - An object containing the x and y data to be fitted.
     * @param peakList - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
     */
    function optimizePeaksWithLogs(data, peakList, options = {}) {
      const {
        fromTo = {},
        baseline,
        shape = {
          kind: 'gaussian'
        },
        groupingFactor = 1,
        factorLimits = 2,
        optimization = {
          kind: 'lm',
          options: {
            timeout: 10
          }
        }
      } = options;
      /*
      The optimization algorithm will take some group of peaks.
      We can not simply optimize everything because there would be too many variables to optimize
      and it would be too time consuming.
      */
      let groups = groupPeaks(peakList, {
        factor: groupingFactor
      });
      let logs = [];
      let results = [];
      groups.forEach(peakGroup => {
        const start = Date.now();
        // In order to make optimization we will add fwhm and shape on all the peaks
        const peaks = addMissingShape(peakGroup, {
          shape
        });
        const firstPeak = peaks[0];
        const lastPeak = peaks[peaks.length - 1];
        const {
          from = firstPeak.x - firstPeak.width * factorLimits,
          to = lastPeak.x + lastPeak.width * factorLimits
        } = fromTo;
        const {
          fromIndex,
          toIndex
        } = xGetFromToIndex(data.x, {
          from,
          to
        });
        const x = data.x instanceof Float64Array ? data.x.subarray(fromIndex, toIndex) : data.x.slice(fromIndex, toIndex);
        const y = data.y instanceof Float64Array ? data.y.subarray(fromIndex, toIndex) : data.y.slice(fromIndex, toIndex);
        const log = {
          range: {
            from,
            to
          },
          parameters: optimization,
          groupSize: peakGroup.length,
          time: Date.now() - start
        };
        if (x.length > 5) {
          const {
            iterations,
            error,
            peaks: optimizedPeaks
          } = optimize({
            x,
            y
          }, peaks, {
            shape,
            baseline,
            optimization
          });
          for (let i = 0; i < peaks.length; i++) {
            results.push({
              ...optimizedPeaks[i],
              width: getShape1D(peaks[i].shape).fwhmToWidth(optimizedPeaks[i].shape.fwhm)
            });
          }
          logs.push({
            ...log,
            iterations,
            error,
            message: 'optimization successful'
          });
        } else {
          results.push(...peaks);
          logs.push({
            ...log,
            iterations: 0,
            message: 'x length too small for optimization'
          });
        }
      });
      return {
        logs,
        optimizedPeaks: results
      };
    }

    /**
     * Optimize the position (x), max intensity (y), full width at half maximum (fwhm)
     * and the ratio of gaussian contribution (mu) if it's required. It currently supports three kind of shapes: gaussian, lorentzian and pseudovoigt
     * @param data - An object containing the x and y data to be fitted.
     * @param peakList - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
     */
    function optimizePeaks(data, peakList, options = {}) {
      return optimizePeaksWithLogs(data, peakList, options).optimizedPeaks;
    }

    const {
      parse: parse$5,
      stringify: stringify$5
    } = JSON;
    function addMissingIDs$1(peaks, options = {}) {
      const {
        output = parse$5(stringify$5(peaks))
      } = options;
      for (const peak of output) {
        if (!('id' in peak)) {
          peak.id = v4();
        }
      }
      return output;
    }

    function joinBroadPeaks(peakList, options = {}) {
      let {
        shape = {
          kind: 'gaussian'
        },
        optimization = {
          kind: 'lm',
          options: {
            timeout: 10
          }
        },
        broadWidth = 0.25,
        broadRatio = 0.0025
      } = options;
      let max = 0;
      let maxI = 0;
      let count = 1;
      const broadLines = [];
      if (peakList.length < 2) {
        return addMissingIDs$1(addMissingShape(peakList.map(getGSDPeakOptimizedStructure), {
          shape
        }));
      }
      let maxDdy = peakList[0].ddY;
      for (let i = 1; i < peakList.length; i++) {
        if (Math.abs(peakList[i].ddY) > maxDdy) maxDdy = Math.abs(peakList[i].ddY);
      }
      const newPeaks = [];
      for (const peak of peakList) {
        if (Math.abs(peak.ddY) <= broadRatio * maxDdy) {
          broadLines.push(peak);
        } else {
          newPeaks.push(getGSDPeakOptimizedStructure(peak));
        }
      }
      //@ts-expect-error Push a feke peak
      broadLines.push({
        x: Number.MAX_VALUE,
        y: 0
      });
      let candidates = {
        x: [broadLines[0].x],
        y: [broadLines[0].y]
      };
      let indexes = [0];
      for (let i = 1; i < broadLines.length; i++) {
        if (Math.abs(broadLines[i - 1].x - broadLines[i].x) < broadWidth) {
          candidates.x.push(broadLines[i].x);
          candidates.y.push(broadLines[i].y);
          if (broadLines[i].y > max) {
            max = broadLines[i].y;
            maxI = i;
          }
          indexes.push(i);
          count++;
        } else {
          if (count > 2) {
            let fitted = optimizePeaks(candidates, [{
              id: v4(),
              x: broadLines[maxI].x,
              y: max,
              width: candidates.x[0] - candidates.x[candidates.x.length - 1]
            }], {
              shape,
              optimization
            });
            newPeaks.push(fitted[0]);
          } else {
            // Put back the candidates to the peak list
            for (const index of indexes) {
              newPeaks.push(getGSDPeakOptimizedStructure(broadLines[index]));
            }
          }
          candidates = {
            x: [broadLines[i].x],
            y: [broadLines[i].y]
          };
          indexes = [i];
          max = broadLines[i].y;
          maxI = i;
          count = 1;
        }
      }
      newPeaks.sort((a, b) => {
        return a.x - b.x;
      });
      return addMissingIDs$1(newPeaks, {
        output: newPeaks
      });
    }
    function getGSDPeakOptimizedStructure(peak) {
      const {
        id,
        shape,
        x,
        y,
        width
      } = peak;
      let newPeak = {
        x,
        y,
        width,
        shape
      };
      if (id) newPeak.id = id;
      return newPeak;
    }

    const {
      parse: parse$4,
      stringify: stringify$4
    } = JSON;
    /**
     * Append 2 properties to the peaks, shape and fwhm
     */
    function setShape(peaks, options = {}) {
      let {
        shape = {
          kind: 'gaussian'
        },
        output = parse$4(stringify$4(peaks))
      } = options;
      let shapeInstance = getShape1D(shape);
      return output.map(peak => ({
        ...peak,
        shape: {
          fwhm: shapeInstance.widthToFWHM(peak.width),
          ...shape
        }
      }));
    }

    function peakToXY(peak, options) {
      const newPeak = addMissingShape([peak])[0];
      const factor = getShape1D(newPeak.shape).getFactor();
      const {
        from = newPeak.x - peak.width * factor / options.frequency,
        to = newPeak.x + peak.width * factor / options.frequency
      } = options;
      return peaksToXY([peak], {
        ...options,
        from,
        to
      });
    }

    /**
     * Created by acastillo on 9/3/16.
     */

    class TreeSet {
      constructor(compatator) {
        this.length = 0;
        this.elements = [];
        if (compatator) this.compatator = compatator;else this.compatator = function (a, b) {
          return a - b;
        };
      }
      size() {
        return this.elements.length;
      }
      last() {
        return this.elements[this.length - 1];
      }
      first() {
        return this.elements[0];
      }
      isEmpty() {
        return this.size() === 0;
      }
      pollLast() {
        if (this.length > 0) {
          this.length--;
          return this.elements.splice(this.length, 1);
        }
        return null;
      }
      pollFirst() {
        if (this.length > 0) {
          this.length--;
          return this.elements.splice(0, 1);
        }
        return null;
      }
      add(element) {
        let index = this.binarySearch(element);
        if (index < 0) {
          index = -index - 1;
        }
        this.elements.splice(index, 0, element);
        this.length++;
      }

      /**
       * Performs a binary search of value in array
       * @param {number[]} array - Array in which value will be searched. It must be sorted.
       * @param {number} value - Value to search in array
       * @return {number} If value is found, returns its index in array. Otherwise, returns a negative number indicating where the value should be inserted: -(index + 1)
       */
      binarySearch(value) {
        var low = 0;
        var high = this.elements.length - 1;
        while (low <= high) {
          var mid = low + high >>> 1;
          var midValue = this.elements[mid];
          var cmp = this.compatator(midValue, value);
          if (cmp < 0) {
            low = mid + 1;
          } else if (cmp > 0) {
            high = mid - 1;
          } else {
            return mid;
          }
        }
        return -(low + 1);
      }
    }
    var src$2 = TreeSet;
    var TreeSet$1 = src$2;

    function createMapPossibleAssignments(props) {
      const {
        restrictionByCS,
        predictions,
        targets,
        useIntegrationRestriction
      } = props;
      const {
        tolerance: toleranceCS,
        chemicalShiftRestriction
      } = restrictionByCS;
      const errorAbs = Math.abs(toleranceCS);
      const expandMap = {};
      for (const diaID in predictions) {
        const prediction = predictions[diaID];
        if (prediction.error) prediction.error = Math.abs(prediction.error);
        expandMap[diaID] = [];
        if (targets) {
          for (const targetID in targets) {
            const target = targets[targetID];
            const {
              nbAtoms
            } = prediction;
            const {
              integration
            } = target;
            const couldBeAssigned = useIntegrationRestriction ? integration > 0 ? nbAtoms - integration < 1 : true : true;
            if (couldBeAssigned) {
              if (!chemicalShiftRestriction || typeof prediction.delta === 'undefined') {
                // Chemical shift is not a restriction
                expandMap[diaID].push(targetID);
              } else {
                let error = errorAbs;
                if (prediction.error) {
                  error = Math.max(error, prediction.error);
                }
                const delta = target.signals && target.signals.length > 0 ? target.signals[0].delta : (target.to + target.from) / 2;
                const distAfterLimit = Math.abs(prediction.delta - delta - errorAbs);
                if (distAfterLimit < 4 * errorAbs) {
                  expandMap[diaID].push(targetID);
                }
              }
            }
          }
        }
        expandMap[diaID].push('*');
      }
      return expandMap;
    }

    function partialScore$1(partial, options) {
      const {
        useIntegrationRestriction,
        diaIDPeerPossibleAssignment,
        nbAllowedUnAssigned,
        restrictionByCS,
        predictions,
        targets
      } = options;
      const {
        useChemicalShiftScore
      } = restrictionByCS;
      let countStars = 0;
      const totalPartial = partial.length;
      const partialInverse = {};
      for (let i = 0; i < partial.length; i++) {
        const targetID = partial[i];
        if (targetID && targetID !== '*') {
          if (!partialInverse[targetID]) {
            partialInverse[targetID] = [];
          }
          partialInverse[targetID].push(diaIDPeerPossibleAssignment[i]);
        }
        if (targetID === '*') countStars++;
      }
      if (countStars > nbAllowedUnAssigned) return 0;
      const activeDomainOnTarget = Object.keys(partialInverse);
      if (activeDomainOnTarget.length === 0) {
        return 0;
      }
      if (useIntegrationRestriction) {
        for (const targetID of activeDomainOnTarget) {
          const targetToSource = partialInverse[targetID];
          let total = 0;
          for (const diaID of targetToSource) {
            const prediction = predictions[diaID];
            total += prediction.allHydrogens;
          }
          const {
            integration
          } = targets[targetID];
          if (total - integration >= 0.5) {
            return 0;
          }
        }
      }
      //chemical shift score
      const chemicalShiftScore = useChemicalShiftScore ? chemicalShiftScoring(partial, options) : 1;
      const penaltyByStarts = countStars / totalPartial;
      return chemicalShiftScore - penaltyByStarts;
    }
    function chemicalShiftScoring(partial, options) {
      const {
        tolerance
      } = options.restrictionByCS;
      const {
        diaIDPeerPossibleAssignment,
        predictions,
        targets
      } = options;
      let chemicalShiftScore = 0;
      let count = 0;
      for (let index = 0; index < partial.length; index++) {
        const targetID = partial[index];
        if (targetID && targetID !== '*') {
          count++;
          const diaID = diaIDPeerPossibleAssignment[index];
          const source = predictions[diaID];
          const target = targets[targetID];
          let error = tolerance;
          if (source.error) {
            error = Math.max(source.error, tolerance);
          }
          if (typeof source.delta === 'undefined') {
            // Chemical shift is not a restriction
            chemicalShiftScore += 1;
          } else {
            const delta = target.signals && target.signals.length > 0 ? target.signals[0].delta : (target.to + target.from) / 2;
            let diff = Math.abs(source.delta - delta);
            if (diff < error) {
              chemicalShiftScore += 1;
            } else {
              diff = Math.abs(diff - error);
              chemicalShiftScore += -0.25 / error * diff + 1;
            }
          }
        }
      }
      if (count > 0) {
        chemicalShiftScore /= count;
      }
      return chemicalShiftScore;
    }

    function exploreTreeRec(props, currentIndex, partial, store) {
      const {
        nSources,
        restrictionByCS,
        timeout,
        timeStart,
        maxSolutions,
        targets,
        predictions,
        lowerBoundScore,
        nbAllowedUnAssigned,
        possibleAssignmentMap,
        useIntegrationRestriction,
        diaIDPeerPossibleAssignment
      } = props;
      if (Date.now() - timeStart > timeout) {
        return store;
      }
      const diaID = diaIDPeerPossibleAssignment[currentIndex];
      const possibleAssignments = possibleAssignmentMap[diaID];
      for (const targetID of possibleAssignments) {
        partial[currentIndex] = targetID;
        const score = partialScore$1(partial, {
          useIntegrationRestriction,
          diaIDPeerPossibleAssignment,
          nbAllowedUnAssigned,
          restrictionByCS,
          predictions,
          targets
        });
        if (score === 0) {
          if (targetID === '*') {
            partial[currentIndex] = null;
          }
          continue;
        }
        if (currentIndex === nSources - 1 && score >= lowerBoundScore) {
          addSolution$1(store, {
            predictions,
            partial,
            score,
            maxSolutions
          });
        } else if (currentIndex < nSources - 1) {
          exploreTreeRec({
            nSources,
            restrictionByCS,
            timeout,
            timeStart,
            maxSolutions,
            targets,
            predictions,
            lowerBoundScore,
            nbAllowedUnAssigned,
            possibleAssignmentMap,
            useIntegrationRestriction,
            diaIDPeerPossibleAssignment
          }, currentIndex + 1, JSON.parse(JSON.stringify(partial)), store);
        }
      }
    }
    function addSolution$1(store, props) {
      const {
        score,
        maxSolutions,
        partial,
        predictions
      } = props;
      store.nSolutions++;
      const solution = {
        assignment: JSON.parse(JSON.stringify(partial)),
        score: score / doubleAssignmentPenalty$1(partial, predictions)
      };
      if (store.nSolutions >= maxSolutions) {
        if (solution.score > store.solutions.last().score) {
          store.solutions.pollLast();
          store.solutions.add(solution);
        }
      } else {
        store.solutions.add(solution);
        store.nSolutions++;
      }
    }
    function doubleAssignmentPenalty$1(partial, predictions) {
      const nbSources = Object.keys(predictions).length;
      const assignments = new Set(partial);
      const nbDoubleAssignment = nbSources - assignments.size;
      return nbDoubleAssignment > 0 ? 2 * nbDoubleAssignment : 1;
    }

    const comparator$1 = (a, b) => {
      return b.score - a.score;
    };
    async function buildAssignments$1(props) {
      const {
        restrictionByCS = {},
        useIntegrationRestriction,
        timeout,
        minScore,
        nbAllowedUnAssigned,
        maxSolutions,
        targets,
        joinedSignals
      } = props;
      const {
        tolerance = 1,
        useChemicalShiftScore = false,
        chemicalShiftRestriction = true
      } = restrictionByCS;
      let store = {
        solutions: new TreeSet$1(comparator$1),
        nSolutions: 0
      };
      const nSources = joinedSignals.length;
      const predictions = {};
      for (const prediction of joinedSignals) {
        const diaID = prediction.diaIDs[0];
        const index = prediction.atoms[0];
        predictions[diaID] = {
          ...prediction,
          diaIDIndex: index,
          allHydrogens: prediction.nbAtoms
        };
      }
      const possibleAssignmentMap = createMapPossibleAssignments({
        restrictionByCS: {
          tolerance,
          useChemicalShiftScore,
          chemicalShiftRestriction
        },
        useIntegrationRestriction,
        predictions,
        targets
      });
      const diaIDPeerPossibleAssignment = Object.keys(possibleAssignmentMap);
      const partial = fillPartial$1(nSources);
      store = {
        solutions: new TreeSet$1(comparator$1),
        nSolutions: 0
      };
      const timeStart = Date.now();
      exploreTreeRec({
        nSources,
        restrictionByCS: {
          tolerance,
          useChemicalShiftScore,
          chemicalShiftRestriction
        },
        timeout,
        timeStart,
        targets,
        predictions,
        maxSolutions,
        lowerBoundScore: minScore,
        nbAllowedUnAssigned,
        possibleAssignmentMap,
        diaIDPeerPossibleAssignment,
        useIntegrationRestriction
      }, 0, partial, store);
      const assignments = [];
      for (const solution of store.solutions.elements) {
        const {
          assignment,
          score
        } = solution;
        const currentAssignment = JSON.parse(JSON.stringify(targets));
        for (let i = 0; i < assignment.length; i++) {
          const range = currentAssignment[assignment[i]];
          if (!range.diaIDs) range.diaIDs = [];
          if (assignment[i]) range.diaIDs.push(diaIDPeerPossibleAssignment[i]);
        }
        assignments.push({
          score,
          assignment: Object.values(currentAssignment)
        });
      }
      return assignments;
    }
    function fillPartial$1(nSources, value = null) {
      const partial = new Array(nSources);
      for (let i = 0; i < nSources; i++) {
        partial[i] = value;
      }
      return partial;
    }

    function checkAtomsAndDiaIDs$1(signals) {
      for (const signal of signals) {
        if (!signal.atoms) throw new Error('signal has not atoms property');
        if (!signal.diaIDs) throw new Error('signal has not diaIDs property');
        if (!signal.nbAtoms) throw new Error('signal has not nbAtoms property');
      }
    }
    function checkForIntegration(ranges) {
      for (const range of ranges) {
        if (range.integration === undefined) {
          throw new Error('ranges has not integration property');
        }
      }
    }
    async function get1HAssignments(ranges, molecule, options = {}) {
      const {
        restrictionByCS,
        minScore = 1,
        maxSolutions = 10,
        nbAllowedUnAssigned = 0,
        timeout = 6000,
        predictionOptions = {}
      } = options;
      if (!molecule) {
        throw new Error('It is needed a OCL molecule instance to assign');
      }
      const {
        spectra
      } = await predict(molecule, {
        predictOptions: {
          H: predictionOptions
        }
      });
      const joinedSignals = spectra.proton?.joinedSignals || [];
      checkForIntegration(ranges);
      checkAtomsAndDiaIDs$1(joinedSignals);
      const targets = {};
      for (const range of ranges) {
        const {
          id = v4()
        } = range;
        targets[id] = JSON.parse(JSON.stringify(range));
      }
      return buildAssignments$1({
        restrictionByCS,
        timeout,
        minScore,
        nbAllowedUnAssigned,
        maxSolutions,
        targets,
        joinedSignals,
        useIntegrationRestriction: true
      });
    }

    function checkAtomsAndDiaIDs(signals) {
      for (const signal of signals) {
        if (!signal.atoms) throw new Error('signal has not atoms property');
        if (!signal.diaIDs) throw new Error('signal has not diaIDs property');
        if (!signal.nbAtoms) throw new Error('signal has not nbAtoms property');
      }
    }
    function checkIntegration(ranges) {
      for (const range of ranges) {
        if (range.integration === undefined) range.integration = 0;
      }
      return ranges;
    }
    async function get13CAssignments(ranges, molecule, options = {}) {
      const {
        restrictionByCS = {},
        minScore = 1,
        maxSolutions = 10,
        nbAllowedUnAssigned = 0,
        timeout = 6000,
        predictionOptions = {}
      } = options;
      if (!molecule) {
        throw new Error('It is needed a OCL molecule instance to assign');
      }
      const {
        spectra
      } = await predict(molecule, {
        predictOptions: {
          C: predictionOptions
        }
      });
      const joinedSignals = spectra.carbon?.joinedSignals || [];
      checkAtomsAndDiaIDs(joinedSignals);
      const copyRanges = checkIntegration(ranges);
      const targets = {};
      for (const range of copyRanges) {
        const {
          id = v4()
        } = range;
        targets[id] = JSON.parse(JSON.stringify(range));
      }
      return buildAssignments$1({
        restrictionByCS,
        timeout,
        minScore,
        nbAllowedUnAssigned,
        maxSolutions,
        targets,
        joinedSignals,
        useIntegrationRestriction: false
      });
    }

    let xAtomicNumber = 0;
    /**
     * Returns the atomic number of the X atom
     * @param {import('openchemlib').Molecule} molecule An instance of a molecule
     * @returns
     */
    function getXAtomicNumber(molecule) {
      if (!xAtomicNumber) {
        const OCL = molecule.getOCL();
        xAtomicNumber = OCL.Molecule.getAtomicNoFromLabel('X', OCL.Molecule.cPseudoAtomX);
      }
      return xAtomicNumber;
    }

    /**
     * Returns the atoms that are chiral or pseudo chiral.
     * There could be some issues if the original molecule lacks chiral bonds.
     * The function will add them and this could lead to some issues in the case of pseudochiral atoms.
     * @param {import('openchemlib').Molecule} molecule
     * @returns {number[]}
     */
    function getChiralOrHeterotopicCarbons(molecule) {
      const {
        Molecule
      } = molecule.getOCL();
      const xAtomicNumber = getXAtomicNumber(molecule);
      const internalMolecule = molecule.getCompactCopy();
      // hydrogens may be diastereotopic, we need to add them
      internalMolecule.addImplicitHydrogens();
      for (let i = 0; i < internalMolecule.getAllAtoms(); i++) {
        // hydrogens are not taken into account during canonization, we need to change them with an atom with a valence of 1
        if (internalMolecule.getAtomicNo(i) === 1) {
          internalMolecule.setAtomicNo(i, xAtomicNumber);
        }
      }
      addPossibleChiralBonds(internalMolecule);
      internalMolecule.ensureHelperArrays(Molecule.cHelperSymmetryStereoHeterotopicity);
      const atoms = [];
      for (let i = 0; i < molecule.getAllAtoms(); i++) {
        if (internalMolecule.getAtomicNo(i) === xAtomicNumber) {
          continue;
        }
        if (molecule.getAtomicNo(i) !== internalMolecule.getAtomicNo(i)) {
          throw new Error('getChiralOrHeterotopicCarbons: mismatching atomic numbers');
        }
        if (internalMolecule.getAtomicNo(i) !== 6) {
          continue;
        }
        const neighbourSymmetries = getNeighbourSymmetries(internalMolecule, i);
        if (neighbourSymmetries.length === 4) {
          atoms.push(i);
        }
      }
      return atoms;
    }
    function addPossibleChiralBonds(molecule) {
      const {
        Molecule
      } = molecule.getOCL();
      molecule.ensureHelperArrays(Molecule.cHelperSymmetryStereoHeterotopicity);
      for (let i = 0; i < molecule.getAtoms(); i++) {
        if (molecule.getAtomicNo(i) !== 6) continue;
        if (molecule.getStereoBond(i) >= 0) continue;
        const neighbourSymmetries = getNeighbourSymmetries(molecule, i);
        if (neighbourSymmetries.length <= 2) continue;
        const stereoBond = molecule.getAtomPreferredStereoBond(i);
        if (stereoBond !== -1) {
          molecule.setBondType(stereoBond, Molecule.cBondTypeUp);
          if (molecule.getBondAtom(1, stereoBond) === i) {
            const connAtom = molecule.getBondAtom(0, stereoBond);
            molecule.setBondAtom(0, stereoBond, i);
            molecule.setBondAtom(1, stereoBond, connAtom);
          }
          // To me it seems that we have to add all stereo centers into AND group 0. TLS 9.Nov.2015
          molecule.setAtomESR(i, Molecule.cESRTypeAnd, 0);
        }
      }
    }
    function getNeighbourSymmetries(molecule, iAtom) {
      const neighbourSymmetries = [];
      for (let j = 0; j < molecule.getAllConnAtoms(iAtom); j++) {
        const connAtom = molecule.getConnAtom(iAtom, j);
        const symmetryRank = molecule.getSymmetryRank(connAtom);
        if (!neighbourSymmetries.includes(symmetryRank)) {
          neighbourSymmetries.push(molecule.getSymmetryRank(connAtom));
        }
      }
      return neighbourSymmetries;
    }

    /**
     * This function will add missing chiral bonds on carbons ensure that all enantiotopic
     * or diastereotopic atoms can be identified uniquely
     * @param {import('openchemlib').Molecule} molecule
     * @param {object} [options={}]
     * @param {number} [options.esrType=Molecule.cESRTypeAnd]
     * @param {boolean} [options.atLeastThreeAtoms=true] - if true, only carbons with at least three atoms will be considered
     */
    function ensureHeterotopicChiralBonds(molecule, options = {}) {
      const {
        Molecule
      } = molecule.getOCL();
      const {
        esrType = Molecule.cESRTypeAnd,
        atLeastThreeAtoms = true
      } = options;
      molecule.ensureHelperArrays(Molecule.cHelperBitNeighbours);
      const heterotopicCarbons = getChiralOrHeterotopicCarbons(molecule);
      for (const i of heterotopicCarbons) {
        if (atLeastThreeAtoms && molecule.getAllConnAtoms(i) < 3) continue;
        if (molecule.getStereoBond(i) === -1) {
          const stereoBond = molecule.getAtomPreferredStereoBond(i);
          if (stereoBond !== -1) {
            molecule.setBondType(stereoBond, Molecule.cBondTypeUp);
            if (molecule.getBondAtom(1, stereoBond) === i) {
              const connAtom = molecule.getBondAtom(0, stereoBond);
              molecule.setBondAtom(0, stereoBond, i);
              molecule.setBondAtom(1, stereoBond, connAtom);
            }
            // To me it seems that we have to add all stereo centers into AND group 0. TLS 9.Nov.2015
            molecule.setAtomESR(i, esrType, 0);
          }
        }
      }
    }

    /**
     * Returns an array of symmetry ranks.
     * @param {import('openchemlib').Molecule} molecule An instance of a molecule
     * @returns
     */
    function getSymmetryRanks(molecule) {
      const {
        Molecule
      } = molecule.getOCL();
      const xAtomNumber = getXAtomicNumber(molecule);
      // most of the molecules have some symetry
      const internalMolecule = molecule.getCompactCopy();
      for (let i = 0; i < internalMolecule.getAllAtoms(); i++) {
        // hydrogens are not taken into account during canonization, we need to change them with an atom with a valence of 1
        if (internalMolecule.getAtomicNo(i) === 1) {
          internalMolecule.setAtomicNo(i, xAtomNumber);
        }
      }
      internalMolecule.ensureHelperArrays(Molecule.cHelperSymmetryStereoHeterotopicity);
      const symmetryRanks = [];
      for (let i = 0; i < molecule.getAllAtoms(); i++) {
        symmetryRanks.push(internalMolecule.getSymmetryRank(i));
      }
      return symmetryRanks;
    }

    /**
     *
     * @param {import('openchemlib').Molecule} molecule An instance of a molecule
     * @param {object} [options={}]
     * @param {object} [options.OCL] openchemlib library
     */
    function makeRacemic(molecule) {
      const {
        Molecule
      } = molecule.getOCL();
      // if we don't calculate this we have 2 epimers
      molecule.ensureHelperArrays(Molecule.cHelperCIP);
      // we need to make one group "AND" for chiral (to force to racemic, this means diastereotopic and not enantiotopic)
      for (let i = 0; i < molecule.getAllAtoms(); i++) {
        if (molecule.getAtomParity(i) !== Molecule.cAtomParityNone) {
          molecule.setAtomESR(i, Molecule.cESRTypeAnd, 0); // changed to group 0; TLS 9.Nov.2015
        }
      }
      // after the change we need to recalculate the CIP
      molecule.ensureHelperArrays(Molecule.cHelperCIP);
    }

    /**
     * Tag an atom to be able to visualize it
     * @param {import('openchemlib').Molecule} molecule
     * @param {number} iAtom
     */
    function tagAtom(molecule, iAtom) {
      const customLabel = `${molecule.getAtomLabel(iAtom)}*`;
      molecule.setAtomCustomLabel(iAtom, customLabel);
      if (molecule.getAtomicNo(iAtom) === 1) {
        molecule.setAtomicNo(iAtom, getXAtomicNumber(molecule));
      } else {
        // we can not use X because we would have problems with valencies if it is
        // expanded hydrogens or not
        // we can not only use a custom label because it does not count for the canonisation
        molecule.setAtomMass(iAtom, molecule.getAtomMass(iAtom) + 5);
      }
      return customLabel;
    }

    function groupDiastereotopicAtomIDs(diaIDs, molecule, options = {}) {
      const {
        atomLabel
      } = options;
      const diaIDsObject = {};
      for (let i = 0; i < diaIDs.length; i++) {
        if (!atomLabel || molecule.getAtomLabel(i) === atomLabel) {
          const diaID = diaIDs[i];
          if (!diaIDsObject[diaID]) {
            diaIDsObject[diaID] = {
              counter: 0,
              atoms: [],
              oclID: diaID,
              atomLabel: molecule.getAtomLabel(i)
            };
          }
          diaIDsObject[diaID].counter++;
          diaIDsObject[diaID].atoms.push(i);
        }
      }
      return Object.keys(diaIDsObject).map(key => diaIDsObject[key]);
    }

    /**
     * Check if a specific atom is a sp3 carbon
     * @param {import('openchemlib').Molecule} molecule
     * @param {number} atomID
     */
    function isCsp3(molecule, atomID) {
      if (molecule.getAtomicNo(atomID) !== 6) return false;
      if (molecule.getAtomCharge(atomID) !== 0) return false;
      if (molecule.getImplicitHydrogens(atomID) + molecule.getConnAtoms(atomID) !== 4) {
        return false;
      }
      return true;
    }

    const FULL_HOSE_CODE = 1;
    const HOSE_CODE_CUT_C_SP3_SP3 = 2;
    /**
     * Returns the hose code for specific atom numbers
     * @param {import('openchemlib').Molecule} molecule - The OCL molecule with expandedImplicitHydrogens and ensureHeterotopicChiralBonds
     * @param {object} [options={}]
     * @param {string[]} [options.allowedCustomLabels] Array of the custom labels that are considered as root atoms. By default all atoms having a customLabel
     * @param {number} [options.minSphereSize=0] Smallest hose code sphere
     * @param {number} [options.maxSphereSize=4] Largest hose code sphere
     * @param {number} [options.kind=FULL_HOSE_CODE] Kind of hose code, default usual sphere
     */
    function getHoseCodesForAtomsInternal(molecule, options = {}) {
      const OCL = molecule.getOCL();
      const {
        allowedCustomLabels,
        minSphereSize = 0,
        maxSphereSize = 4,
        kind = FULL_HOSE_CODE
      } = options;
      // this force reordering of atoms in order to have hydrogens at the end
      molecule.ensureHelperArrays(OCL.Molecule.cHelperNeighbours);
      const rootAtoms = [];
      for (let j = 0; j < molecule.getAllAtoms(); j++) {
        if (allowedCustomLabels?.includes(molecule.getAtomCustomLabel(j)) || molecule.getAtomCustomLabel(j)) {
          rootAtoms.push(j);
        }
      }
      const fragment = new OCL.Molecule(0, 0);
      const results = [];
      let min = 0;
      let max = 0;
      const atomMask = new Array(molecule.getAllAtoms());
      const atomList = new Array(molecule.getAllAtoms());
      for (let sphere = 0; sphere <= maxSphereSize; sphere++) {
        if (max === 0) {
          for (const rootAtom of rootAtoms) {
            atomList[max] = rootAtom;
            atomMask[rootAtom] = true;
            max++;
          }
        } else {
          let newMax = max;
          for (let i = min; i < max; i++) {
            const atom = atomList[i];
            for (let j = 0; j < molecule.getAllConnAtoms(atom); j++) {
              const connAtom = molecule.getConnAtom(atom, j);
              if (!atomMask[connAtom]) {
                switch (kind) {
                  case FULL_HOSE_CODE:
                    atomMask[connAtom] = true;
                    atomList[newMax++] = connAtom;
                    break;
                  case HOSE_CODE_CUT_C_SP3_SP3:
                    if (!(isCsp3(molecule, atom) && isCsp3(molecule, connAtom))) {
                      atomMask[connAtom] = true;
                      atomList[newMax++] = connAtom;
                    }
                    break;
                  default:
                    throw new Error('getHoseCoesForAtom unknown kind');
                }
              }
            }
          }
          min = max;
          max = newMax;
        }
        molecule.copyMoleculeByAtoms(fragment, atomMask, true, null);
        if (sphere >= minSphereSize) {
          makeRacemic(fragment);
          results.push(fragment.getCanonizedIDCode(OCL.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS));
        }
      }
      return results;
    }

    /**
     * Algorithm that finds the shortest distance from one node to the other
     * @param {Matrix} adjMatrix - A squared adjacency matrix
     * @return {Matrix} - Distance from a node to the other, -1 if the node is unreachable
     */
    function floydWarshall(adjMatrix) {
      if (Matrix.isMatrix(adjMatrix) && adjMatrix.columns !== adjMatrix.rows) {
        throw new TypeError('The adjacency matrix should be squared');
      }
      const numVertices = adjMatrix.columns;
      let distMatrix = new Matrix(numVertices, numVertices);
      distMatrix.apply((row, column) => {
        // principal diagonal is 0
        if (row === column) {
          distMatrix.set(row, column, 0);
        } else {
          let val = adjMatrix.get(row, column);
          if (val || Object.is(val, -0)) {
            // edges values remain the same
            distMatrix.set(row, column, val);
          } else {
            // 0 values become infinity
            distMatrix.set(row, column, Number.POSITIVE_INFINITY);
          }
        }
      });
      for (let k = 0; k < numVertices; ++k) {
        for (let i = 0; i < numVertices; ++i) {
          for (let j = 0; j < numVertices; ++j) {
            let dist = distMatrix.get(i, k) + distMatrix.get(k, j);
            if (distMatrix.get(i, j) > dist) {
              distMatrix.set(i, j, dist);
            }
          }
        }
      }
      // When there's no connection the value is -1
      distMatrix.apply((row, column) => {
        if (distMatrix.get(row, column) === Number.POSITIVE_INFINITY) {
          distMatrix.set(row, column, -1);
        }
      });
      return distMatrix;
    }

    /**
     * Returns a connectivity matrix
     * @param {import('openchemlib').Molecule} molecule
     * @param {object} [options={}]
     * @param {boolean} [options.pathLength=false] get the path length between atoms
     * @param {boolean} [options.mass=false] set the nominal mass of the atoms on diagonal
     * @param {boolean} [options.atomicNo=false] set the atomic number of the atom on diagonal
     * @param {boolean} [options.negativeAtomicNo=false] set the atomic number * -1 of the atom on diagonal
     * @param {boolean} [options.sdt=false] set 1, 2 or 3 depending if single, double or triple bond
     * @param {boolean} [options.sdta=false] set 1, 2, 3 or 4 depending if single, double, triple or aromatic  bond
     */
    function getConnectivityMatrix(molecule, options = {}) {
      const OCL = molecule.getOCL();
      molecule.ensureHelperArrays(OCL.Molecule.cHelperNeighbours);
      const nbAtoms = molecule.getAllAtoms();
      let result = new Array(nbAtoms).fill();
      result = result.map(() => new Array(nbAtoms).fill(0));
      if (!options.pathLength) {
        if (options.atomicNo) {
          for (let i = 0; i < nbAtoms; i++) {
            result[i][i] = molecule.getAtomicNo(i);
          }
        } else if (options.negativeAtomicNo) {
          for (let i = 0; i < nbAtoms; i++) {
            result[i][i] = -molecule.getAtomicNo(i);
          }
        } else if (options.mass) {
          for (let i = 0; i < nbAtoms; i++) {
            result[i][i] = OCL.Molecule.cRoundedMass[molecule.getAtomicNo(i)];
          }
        } else {
          for (let i = 0; i < nbAtoms; i++) {
            result[i][i] = 1;
          }
        }
      }
      if (options.sdt) {
        for (let i = 0; i < nbAtoms; i++) {
          const l = molecule.getAllConnAtoms(i);
          for (let j = 0; j < l; j++) {
            result[i][molecule.getConnAtom(i, j)] = molecule.getConnBondOrder(i, j);
          }
        }
      } else if (options.sdta) {
        for (let i = 0; i < nbAtoms; i++) {
          const l = molecule.getAllConnAtoms(i);
          for (let j = 0; j < l; j++) {
            const bondNumber = molecule.getConnBond(i, j);
            if (molecule.isAromaticBond(bondNumber)) {
              result[i][molecule.getConnAtom(i, j)] = 4;
            } else {
              result[i][molecule.getConnAtom(i, j)] = molecule.getConnBondOrder(i, j);
            }
          }
        }
      } else {
        for (let i = 0; i < nbAtoms; i++) {
          const l = molecule.getAllConnAtoms(i);
          for (let j = 0; j < l; j++) {
            result[i][molecule.getConnAtom(i, j)] = 1;
          }
        }
      }
      if (options.pathLength) {
        result = floydWarshall(new Matrix(result)).to2DArray();
      }
      return result;
    }

    /**
     * Returns an object containing a molfile, molfile with hydrogens, hoses codes and optionally the diaIDs
     * and the diaIDs
     * The map allows to reload properties assigned to the atom molfile
     * Please take care than numbering of atoms starts at 0 !
     * @param {import('openchemlib').Molecule} molecule
     * @param {object} [options={}]
     * @param {string[]} [options.atomLabels]
     * @param {boolean} [options.calculateDiastereotopicIDs=true]
     * @param {number} [options.minSphereSize=0]
     * @param {number} [options.maxSphereSize=4]
     * @returns
     */
    function getHoseCodesAndInfo(molecule, options = {}) {
      const {
        minSphereSize,
        maxSphereSize,
        calculateDiastereotopicIDs = true
      } = options;
      const {
        Molecule
      } = molecule.getOCL();
      molecule = molecule.getCompactCopy();
      // this will force reordering of the hydrogens to the end, just to have the same order as in the molfile
      molecule.ensureHelperArrays(Molecule.cHelperNeighbours);
      const newMolfile = molecule.toMolfile();
      molecule.addImplicitHydrogens();
      ensureHeterotopicChiralBonds(molecule);
      molecule.ensureHelperArrays(Molecule.cHelperSymmetryStereoHeterotopicity);
      const newMolfileWithH = molecule.toMolfile();
      const symmetryRanks = getSymmetryRanks(molecule);
      const cache = {};
      const hoses = [];
      const diaIDs = [];
      for (let i = 0; i < molecule.getAllAtoms(); i++) {
        const rank = symmetryRanks[i];
        if (rank && cache[rank]) {
          diaIDs.push(cache[rank].diaID);
          hoses.push(cache[rank].hose);
          continue;
        }
        const tempMolecule = molecule.getCompactCopy();
        tagAtom(tempMolecule, i);
        let diaID;
        if (calculateDiastereotopicIDs) {
          makeRacemic(tempMolecule);
          diaID = tempMolecule.getCanonizedIDCode(Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS);
          diaIDs.push(diaID);
        }
        const hose = getHoseCodesForAtomsInternal(tempMolecule, {
          minSphereSize,
          maxSphereSize
        });
        hoses.push(hose);
        cache[rank] = {
          diaID,
          hose
        };
      }
      const distanceMatrix = getConnectivityMatrix(molecule, {
        pathLength: true
      });
      return {
        molfile: newMolfile,
        molfileWithH: newMolfileWithH,
        hoses,
        diaIDs: calculateDiastereotopicIDs ? diaIDs : undefined,
        moleculeWithHydrogens: molecule,
        distanceMatrix
      };
    }

    function squaredEuclidean(p, q) {
      let d = 0;
      for (let i = 0; i < p.length; i++) {
        d += (p[i] - q[i]) * (p[i] - q[i]);
      }
      return d;
    }
    function euclidean(p, q) {
      return Math.sqrt(squaredEuclidean(p, q));
    }

    /**
     * Computes a distance/similarity matrix given an array of data and a distance/similarity function.
     * @param {Array} data An array of data
     * @param {function} distanceFn  A function that accepts two arguments and computes a distance/similarity between them
     * @return {Array<Array>} The distance/similarity matrix. The matrix is square and has a size equal to the length of
     * the data array
     */
    function distanceMatrix(data, distanceFn) {
      const result = getMatrix(data.length);

      // Compute upper distance matrix
      for (let i = 0; i < data.length; i++) {
        for (let j = 0; j <= i; j++) {
          result[i][j] = distanceFn(data[i], data[j]);
          result[j][i] = result[i][j];
        }
      }
      return result;
    }
    function getMatrix(size) {
      const matrix = [];
      for (let i = 0; i < size; i++) {
        const row = [];
        matrix.push(row);
        for (let j = 0; j < size; j++) {
          row.push(0);
        }
      }
      return matrix;
    }

    var heap$1 = {exports: {}};

    (function (module, exports) {
      // Generated by CoffeeScript 1.8.0
      (function () {
        var Heap, defaultCmp, floor, heapify, heappop, heappush, heappushpop, heapreplace, insort, min, nlargest, nsmallest, updateItem, _siftdown, _siftup;
        floor = Math.floor, min = Math.min;

        /*
        Default comparison function to be used
         */

        defaultCmp = function (x, y) {
          if (x < y) {
            return -1;
          }
          if (x > y) {
            return 1;
          }
          return 0;
        };

        /*
        Insert item x in list a, and keep it sorted assuming a is sorted.
        
        If x is already in a, insert it to the right of the rightmost x.
        
        Optional args lo (default 0) and hi (default a.length) bound the slice
        of a to be searched.
         */

        insort = function (a, x, lo, hi, cmp) {
          var mid;
          if (lo == null) {
            lo = 0;
          }
          if (cmp == null) {
            cmp = defaultCmp;
          }
          if (lo < 0) {
            throw new Error('lo must be non-negative');
          }
          if (hi == null) {
            hi = a.length;
          }
          while (lo < hi) {
            mid = floor((lo + hi) / 2);
            if (cmp(x, a[mid]) < 0) {
              hi = mid;
            } else {
              lo = mid + 1;
            }
          }
          return [].splice.apply(a, [lo, lo - lo].concat(x)), x;
        };

        /*
        Push item onto heap, maintaining the heap invariant.
         */

        heappush = function (array, item, cmp) {
          if (cmp == null) {
            cmp = defaultCmp;
          }
          array.push(item);
          return _siftdown(array, 0, array.length - 1, cmp);
        };

        /*
        Pop the smallest item off the heap, maintaining the heap invariant.
         */

        heappop = function (array, cmp) {
          var lastelt, returnitem;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          lastelt = array.pop();
          if (array.length) {
            returnitem = array[0];
            array[0] = lastelt;
            _siftup(array, 0, cmp);
          } else {
            returnitem = lastelt;
          }
          return returnitem;
        };

        /*
        Pop and return the current smallest value, and add the new item.
        
        This is more efficient than heappop() followed by heappush(), and can be
        more appropriate when using a fixed size heap. Note that the value
        returned may be larger than item! That constrains reasonable use of
        this routine unless written as part of a conditional replacement:
            if item > array[0]
              item = heapreplace(array, item)
         */

        heapreplace = function (array, item, cmp) {
          var returnitem;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          returnitem = array[0];
          array[0] = item;
          _siftup(array, 0, cmp);
          return returnitem;
        };

        /*
        Fast version of a heappush followed by a heappop.
         */

        heappushpop = function (array, item, cmp) {
          var _ref;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          if (array.length && cmp(array[0], item) < 0) {
            _ref = [array[0], item], item = _ref[0], array[0] = _ref[1];
            _siftup(array, 0, cmp);
          }
          return item;
        };

        /*
        Transform list into a heap, in-place, in O(array.length) time.
         */

        heapify = function (array, cmp) {
          var i, _i, _len, _ref1, _results, _results1;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          _ref1 = function () {
            _results1 = [];
            for (var _j = 0, _ref = floor(array.length / 2); 0 <= _ref ? _j < _ref : _j > _ref; 0 <= _ref ? _j++ : _j--) {
              _results1.push(_j);
            }
            return _results1;
          }.apply(this).reverse();
          _results = [];
          for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
            i = _ref1[_i];
            _results.push(_siftup(array, i, cmp));
          }
          return _results;
        };

        /*
        Update the position of the given item in the heap.
        This function should be called every time the item is being modified.
         */

        updateItem = function (array, item, cmp) {
          var pos;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          pos = array.indexOf(item);
          if (pos === -1) {
            return;
          }
          _siftdown(array, 0, pos, cmp);
          return _siftup(array, pos, cmp);
        };

        /*
        Find the n largest elements in a dataset.
         */

        nlargest = function (array, n, cmp) {
          var elem, result, _i, _len, _ref;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          result = array.slice(0, n);
          if (!result.length) {
            return result;
          }
          heapify(result, cmp);
          _ref = array.slice(n);
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            elem = _ref[_i];
            heappushpop(result, elem, cmp);
          }
          return result.sort(cmp).reverse();
        };

        /*
        Find the n smallest elements in a dataset.
         */

        nsmallest = function (array, n, cmp) {
          var elem, los, result, _i, _j, _len, _ref, _ref1, _results;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          if (n * 10 <= array.length) {
            result = array.slice(0, n).sort(cmp);
            if (!result.length) {
              return result;
            }
            los = result[result.length - 1];
            _ref = array.slice(n);
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              elem = _ref[_i];
              if (cmp(elem, los) < 0) {
                insort(result, elem, 0, null, cmp);
                result.pop();
                los = result[result.length - 1];
              }
            }
            return result;
          }
          heapify(array, cmp);
          _results = [];
          for (_j = 0, _ref1 = min(n, array.length); 0 <= _ref1 ? _j < _ref1 : _j > _ref1; 0 <= _ref1 ? ++_j : --_j) {
            _results.push(heappop(array, cmp));
          }
          return _results;
        };
        _siftdown = function (array, startpos, pos, cmp) {
          var newitem, parent, parentpos;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          newitem = array[pos];
          while (pos > startpos) {
            parentpos = pos - 1 >> 1;
            parent = array[parentpos];
            if (cmp(newitem, parent) < 0) {
              array[pos] = parent;
              pos = parentpos;
              continue;
            }
            break;
          }
          return array[pos] = newitem;
        };
        _siftup = function (array, pos, cmp) {
          var childpos, endpos, newitem, rightpos, startpos;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          endpos = array.length;
          startpos = pos;
          newitem = array[pos];
          childpos = 2 * pos + 1;
          while (childpos < endpos) {
            rightpos = childpos + 1;
            if (rightpos < endpos && !(cmp(array[childpos], array[rightpos]) < 0)) {
              childpos = rightpos;
            }
            array[pos] = array[childpos];
            pos = childpos;
            childpos = 2 * pos + 1;
          }
          array[pos] = newitem;
          return _siftdown(array, startpos, pos, cmp);
        };
        Heap = function () {
          Heap.push = heappush;
          Heap.pop = heappop;
          Heap.replace = heapreplace;
          Heap.pushpop = heappushpop;
          Heap.heapify = heapify;
          Heap.updateItem = updateItem;
          Heap.nlargest = nlargest;
          Heap.nsmallest = nsmallest;
          function Heap(cmp) {
            this.cmp = cmp != null ? cmp : defaultCmp;
            this.nodes = [];
          }
          Heap.prototype.push = function (x) {
            return heappush(this.nodes, x, this.cmp);
          };
          Heap.prototype.pop = function () {
            return heappop(this.nodes, this.cmp);
          };
          Heap.prototype.peek = function () {
            return this.nodes[0];
          };
          Heap.prototype.contains = function (x) {
            return this.nodes.indexOf(x) !== -1;
          };
          Heap.prototype.replace = function (x) {
            return heapreplace(this.nodes, x, this.cmp);
          };
          Heap.prototype.pushpop = function (x) {
            return heappushpop(this.nodes, x, this.cmp);
          };
          Heap.prototype.heapify = function () {
            return heapify(this.nodes, this.cmp);
          };
          Heap.prototype.updateItem = function (x) {
            return updateItem(this.nodes, x, this.cmp);
          };
          Heap.prototype.clear = function () {
            return this.nodes = [];
          };
          Heap.prototype.empty = function () {
            return this.nodes.length === 0;
          };
          Heap.prototype.size = function () {
            return this.nodes.length;
          };
          Heap.prototype.clone = function () {
            var heap;
            heap = new Heap();
            heap.nodes = this.nodes.slice(0);
            return heap;
          };
          Heap.prototype.toArray = function () {
            return this.nodes.slice(0);
          };
          Heap.prototype.insert = Heap.prototype.push;
          Heap.prototype.top = Heap.prototype.peek;
          Heap.prototype.front = Heap.prototype.peek;
          Heap.prototype.has = Heap.prototype.contains;
          Heap.prototype.copy = Heap.prototype.clone;
          return Heap;
        }();
        (function (root, factory) {
          {
            return module.exports = factory();
          }
        })(this, function () {
          return Heap;
        });
      }).call(commonjsGlobal);
    })(heap$1);

    var heap = heap$1.exports;
    var Heap = heap;

    class Cluster {
      constructor() {
        this.children = [];
        this.height = 0;
        this.size = 1;
        this.index = -1;
        this.isLeaf = false;
      }

      /**
       * Creates an array of clusters where the maximum height is smaller than the threshold
       * @param {number} threshold
       * @return {Array<Cluster>}
       */
      cut(threshold) {
        if (typeof threshold !== 'number') {
          throw new TypeError('threshold must be a number');
        }
        if (threshold < 0) {
          throw new RangeError('threshold must be a positive number');
        }
        let list = [this];
        const ans = [];
        while (list.length > 0) {
          const aux = list.shift();
          if (threshold >= aux.height) {
            ans.push(aux);
          } else {
            list = list.concat(aux.children);
          }
        }
        return ans;
      }

      /**
       * Merge the leaves in the minimum way to have `groups` number of clusters.
       * @param {number} groups - Them number of children the first level of the tree should have.
       * @return {Cluster}
       */
      group(groups) {
        if (!Number.isInteger(groups) || groups < 1) {
          throw new RangeError('groups must be a positive integer');
        }
        const heap = new Heap((a, b) => {
          return b.height - a.height;
        });
        heap.push(this);
        while (heap.size() < groups) {
          const first = heap.pop();
          if (first.children.length === 0) {
            break;
          }
          first.children.forEach(child => heap.push(child));
        }
        const root = new Cluster();
        root.children = heap.toArray();
        root.height = this.height;
        return root;
      }

      /**
       * Traverses the tree depth-first and calls the provided callback with each individual node
       * @param {function} cb - The callback to be called on each node encounter
       */
      traverse(cb) {
        function visit(root, callback) {
          callback(root);
          if (root.children) {
            for (const child of root.children) {
              visit(child, callback);
            }
          }
        }
        visit(this, cb);
      }

      /**
       * Returns a list of indices for all the leaves of this cluster.
       * The list is ordered in such a way that a dendrogram could be drawn without crossing branches.
       * @returns {Array<number>}
       */
      indices() {
        const result = [];
        this.traverse(cluster => {
          if (cluster.isLeaf) {
            result.push(cluster.index);
          }
        });
        return result;
      }
    }

    function singleLink(dKI, dKJ) {
      return Math.min(dKI, dKJ);
    }
    function completeLink(dKI, dKJ) {
      return Math.max(dKI, dKJ);
    }
    function averageLink(dKI, dKJ, dIJ, ni, nj) {
      const ai = ni / (ni + nj);
      const aj = nj / (ni + nj);
      return ai * dKI + aj * dKJ;
    }
    function weightedAverageLink(dKI, dKJ) {
      return (dKI + dKJ) / 2;
    }
    function centroidLink(dKI, dKJ, dIJ, ni, nj) {
      const ai = ni / (ni + nj);
      const aj = nj / (ni + nj);
      const b = -(ni * nj) / (ni + nj) ** 2;
      return ai * dKI + aj * dKJ + b * dIJ;
    }
    function medianLink(dKI, dKJ, dIJ) {
      return dKI / 2 + dKJ / 2 - dIJ / 4;
    }
    function wardLink(dKI, dKJ, dIJ, ni, nj, nk) {
      const ai = (ni + nk) / (ni + nj + nk);
      const aj = (nj + nk) / (ni + nj + nk);
      const b = -nk / (ni + nj + nk);
      return ai * dKI + aj * dKJ + b * dIJ;
    }
    function wardLink2(dKI, dKJ, dIJ, ni, nj, nk) {
      const ai = (ni + nk) / (ni + nj + nk);
      const aj = (nj + nk) / (ni + nj + nk);
      const b = -nk / (ni + nj + nk);
      return Math.sqrt(ai * dKI * dKI + aj * dKJ * dKJ + b * dIJ * dIJ);
    }

    /**
     * Continuously merge nodes that have the least dissimilarity
     * @param {Array<Array<number>>} data - Array of points to be clustered
     * @param {object} [options]
     * @param {Function} [options.distanceFunction]
     * @param {string} [options.method] - Default: `'complete'`
     * @param {boolean} [options.isDistanceMatrix] - Is the input already a distance matrix?
     * @constructor
     */
    function agnes(data, options = {}) {
      const {
        distanceFunction = euclidean,
        method = 'complete',
        isDistanceMatrix = false
      } = options;
      let updateFunc;
      if (!isDistanceMatrix) {
        data = distanceMatrix(data, distanceFunction);
      }
      let distanceMatrix$1 = new Matrix(data);
      const numLeaves = distanceMatrix$1.rows;

      // allows to use a string or a given function
      if (typeof method === 'string') {
        switch (method.toLowerCase()) {
          case 'single':
            updateFunc = singleLink;
            break;
          case 'complete':
            updateFunc = completeLink;
            break;
          case 'average':
          case 'upgma':
            updateFunc = averageLink;
            break;
          case 'wpgma':
            updateFunc = weightedAverageLink;
            break;
          case 'centroid':
          case 'upgmc':
            updateFunc = centroidLink;
            break;
          case 'median':
          case 'wpgmc':
            updateFunc = medianLink;
            break;
          case 'ward':
            updateFunc = wardLink;
            break;
          case 'ward2':
            updateFunc = wardLink2;
            break;
          default:
            throw new RangeError(`unknown clustering method: ${method}`);
        }
      } else if (typeof method !== 'function') {
        throw new TypeError('method must be a string or function');
      }
      let clusters = [];
      for (let i = 0; i < numLeaves; i++) {
        const cluster = new Cluster();
        cluster.isLeaf = true;
        cluster.index = i;
        clusters.push(cluster);
      }
      for (let n = 0; n < numLeaves - 1; n++) {
        const [row, column, distance] = getSmallestDistance(distanceMatrix$1);
        const cluster1 = clusters[row];
        const cluster2 = clusters[column];
        const newCluster = new Cluster();
        newCluster.size = cluster1.size + cluster2.size;
        newCluster.children.push(cluster1, cluster2);
        newCluster.height = distance;
        const newClusters = [newCluster];
        const newDistanceMatrix = new Matrix(distanceMatrix$1.rows - 1, distanceMatrix$1.rows - 1);
        const previous = newIndex => getPreviousIndex(newIndex, Math.min(row, column), Math.max(row, column));
        for (let i = 1; i < newDistanceMatrix.rows; i++) {
          const prevI = previous(i);
          const prevICluster = clusters[prevI];
          newClusters.push(prevICluster);
          for (let j = 0; j < i; j++) {
            if (j === 0) {
              const dKI = distanceMatrix$1.get(row, prevI);
              const dKJ = distanceMatrix$1.get(prevI, column);
              const val = updateFunc(dKI, dKJ, distance, cluster1.size, cluster2.size, prevICluster.size);
              newDistanceMatrix.set(i, j, val);
              newDistanceMatrix.set(j, i, val);
            } else {
              // Just copy distance from previous matrix
              const val = distanceMatrix$1.get(prevI, previous(j));
              newDistanceMatrix.set(i, j, val);
              newDistanceMatrix.set(j, i, val);
            }
          }
        }
        clusters = newClusters;
        distanceMatrix$1 = newDistanceMatrix;
      }
      return clusters[0];
    }
    function getSmallestDistance(distance) {
      let smallest = Infinity;
      let smallestI = 0;
      let smallestJ = 0;
      for (let i = 1; i < distance.rows; i++) {
        for (let j = 0; j < i; j++) {
          if (distance.get(i, j) < smallest) {
            smallest = distance.get(i, j);
            smallestI = i;
            smallestJ = j;
          }
        }
      }
      return [smallestI, smallestJ, smallest];
    }
    function getPreviousIndex(newIndex, prev1, prev2) {
      newIndex -= 1;
      if (newIndex >= prev1) newIndex++;
      if (newIndex >= prev2) newIndex++;
      return newIndex;
    }

    var openchemlibFull = {};

    (function(exports){(function(root){function getExports($wnd){var $doc=$wnd.document;var $gwt={};var navigator={userAgent:'webkit'};function noop(){}var __gwtModuleFunction=noop;__gwtModuleFunction.__moduleStartupDone=noop;var XYb='object',YYb='anonymous',ZYb='fnStack',$Yb='\n',_Yb={4:1,9:1,5:1,7:1},aZb='Unknown',bZb='boolean',cZb='number',dZb='string',eZb='function',fZb=2147483647,gZb='For input string: "',hZb='null',iZb='__noinit__',jZb={4:1,5:1,7:1},kZb={4:1,19:1,28:1},lZb=' (copy)',mZb={4:1,9:1,15:1,5:1,11:1,7:1,14:1},nZb=65536,oZb=65535,pZb=10000,qZb=', length: ',rZb='Index: ',sZb=', Size: ',tZb='fromIndex: ',uZb=', toIndex: ',vZb={13:1,4:1,5:1},wZb={4:1},xZb={8:1,4:1,5:1},yZb=16777215,zZb=65280,AZb=0.30000001192092896,BZb=545460846592,CZb=4294967296,DZb=8589934592,EZb=17179869184,FZb=34359738368,GZb=68719476736,HZb=137438953472,IZb=274877906944,JZb={12:1,4:1,5:1},KZb=536870912,LZb=2.617993878,MZb=3.665191429,NZb=6.283185307179586,OZb=3.141592653589793,PZb=1.5707963267948966,QZb=16384,RZb=4096,SZb={l:0,m:0,h:1},TZb={l:0,m:0,h:2},UZb={l:0,m:0,h:4},VZb=1920,WZb=1024,XZb=234881024,YZb=167772160,ZZb=100663296,$Zb=201326592,_Zb=114688,a$b=4063232,b$b=3801088,c$b=3538944,d$b=3014656,e$b=3145728,f$b=2097152,g$b=393216,h$b=917504,i$b=1966080,j$b=17042430230528,k$b=16492674416640,l$b=15942918602752,m$b=14843406974976,n$b=12644383719424,o$b=8796093022208,p$b=549755813888,q$b=1649267441664,r$b=3848290697216,s$b=8246337208320,t$b=29360128,u$b=268435456,v$b=8192,w$b=2048,x$b=-1.5707963267948966,y$b=130560,z$b=6291456,A$b=-2.0943951023931953,B$b=1.0471975511965976,C$b=0.5235987755982988,D$b=786432,E$b=524288,F$b=262144,G$b=-16777216,H$b=-65536,I$b=-32768,J$b='<DrawingObject type="',K$b='><\/DrawingObject>',L$b={4:1,5:1,16:1},M$b={4:1,5:1},N$b='unsupported atomicNo:',O$b=2.8415926535897933,P$b={41:1,4:1,9:1,5:1,7:1},Q$b={4:1,5:1,11:1,7:1},R$b={10:1,4:1,5:1},S$b=131072,T$b=196608,U$b={l:6,m:0,h:4},V$b=1048576,W$b=3221225472,X$b={l:0,m:0,h:3},Y$b=8388608,Z$b=4.9E-324,$$b=1.7976931348623157E308,_$b={90:1,84:1,4:1,9:1,5:1,7:1},a_b='text',b_b={30:1,60:1,62:1},c_b={30:1,60:1,104:1,62:1,121:1},d_b={4:1,5:1,30:1,60:1,104:1,21:1,62:1,121:1,193:1},e_b='??',f_b=2013265920,g_b=32505856,h_b=31744,i_b={152:1,4:1,9:1,5:1,11:1,7:1},j_b=33554432,k_b=67108864,l_b=32768,m_b=-33554433,n_b=-33292289,o_b=-3.141592653589793,p_b=4194303,q_b=3072,r_b={59:1,4:1,5:1},s_b=0.7853981633974483,t_b=3.061592653589793,u_b=1073741824,v_b=541165879296,w_b={17:1,4:1,5:1,7:1},x_b=281.17,y_b=289.19,z_b=294.21,A_b='0.0000',B_b='M  END\n',C_b='ATOMS',D_b=-2147483648,E_b='M  END',F_b='$$$$',G_b='M  V30 ',H_b='M  V30 COUNTS ',I_b=')\n',J_b='M  V30 MDLV30/STEREL',K_b='M  V30 MDLV30/STERAC',L_b=3.4028234663852886E38,M_b={l:2,m:0,h:4},N_b=4194304,O_b={l:4179966,m:4063288,h:7},P_b={l:4194302,m:4193343,h:7},Q_b={90:1,84:1,98:1,4:1,9:1,5:1,7:1},R_b='" ',S_b='stroke="',T_b='stroke-width="',U_b='" />',V_b='class="event" ',W_b='opacity="0" />',X_b=16711680,Y_b='Assignment of aromatic double bonds failed',Z_b=1099511627776,$_b=2199023255552,__b=4398046511104,a0b={115:1,4:1},b0b='Members of ESR groups must only be stereo centers with known configuration.',c0b='Over- or under-specified stereo feature or more than one racemic type bond',d0b='Ambiguous configuration at stereo center because of 2 parallel bonds',e0b={97:1,113:1,24:1,4:1},f0b=100000,g0b='style',h0b=3.1415927410125732,i0b=1.5707963705062866,j0b=0.029999999329447746,k0b=6.2831854820251465,l0b=1.9106119871139526,m0b=2.2639999389648438,n0b=2.16759991645813,o0b=2.0662999153137207,p0b=2.3561999797821045,q0b=2.2844998836517334,r0b=1.9106120066311025,s0b=2.094395160675049,t0b=0.6000000238418579,u0b=1.7999999523162842,v0b=0.05000000074505806,w0b={4:1,9:1,5:1,7:1,48:1},x0b=0.2617993950843811,y0b=2.0943951023931953,z0b=1.2000000476837158,A0b=1.4299999475479126,B0b=1.659999966621399,C0b=1.4600000381469727,D0b=1.8200000524520874,E0b=2.4600000381469727,F0b=2.4200000762939453,G0b=2.450000047683716,H0b=2.440000057220459,I0b=2.4000000953674316,J0b=2.319999933242798,K0b=2.2899999618530273,L0b=1.8600000143051147,M0b=2.5299999713897705,N0b=2.490000009536743,O0b=2.4700000286102295,P0b=2.880000114440918,Q0b=2.9200000762939453,R0b=2.869999885559082,S0b=2.8299999237060547,T0b=2.7899999618530273,U0b=2.809999942779541,V0b=2.799999952316284,W0b=3.049999952316284,X0b=0.3199999928474426,Y0b=1.3300000429153442,Z0b=1.3899999856948853,$0b=1.159999966621399,_0b=1.1100000143051147,a1b=1.0700000524520874,b1b=1.9600000381469727,c1b=1.7100000381469727,d1b=1.3600000143051147,e1b=1.340000033378601,f1b=1.2200000286102295,g1b=1.2400000095367432,h1b=1.2100000381469727,i1b=1.850000023841858,j1b=1.6299999952316284,k1b=1.4700000286102295,l1b=1.2799999713897705,m1b=1.440000057220459,n1b=1.399999976158142,o1b=1.7599999904632568,p1b=1.7300000190734863,q1b=1.7200000286102295,r1b=1.6799999475479126,s1b=1.690000057220459,t1b=1.6699999570846558,u1b=1.649999976158142,v1b=1.7000000476837158,w1b=1.6200000047683716,x1b=1.3700000047683716,y1b=1.2899999618530273,z1b=1.4500000476837158,A1b=1.5700000524520874,B1b=-0.5235987755982988,C1b=-1.0471975511965976,D1b=-0.7853981633974483,E1b=0.017453292519943295,F1b=0.17453292519943295,G1b=1.0E-4,H1b={168:1},I1b=57.29577951308232,J1b=0.021922173386725217,K1b=1.0E-8,L1b=2.5120960256267386,M1b=1.0E-5,N1b='MMFF94s+',O1b='nonbonded cutoff',P1b='dielectric constant',Q1b='dielectric model',R1b='angle bend',S1b='bond stretch',T1b='electrostatic',U1b='out of plane',V1b='stretch bend',W1b='torsion angle',X1b='van der waals',Y1b={4:1,9:1,5:1,11:1,7:1},Z1b=0.07000000000000006,$1b=0.1200000000000001,_1b=-7.840000000000001,a2b='OCL_RXN_V1.0:',b2b="'$MOL' tag not found",c2b="'M  END' not found",d2b='\nActelion Java MolfileCreator 2.0\n\n  0  0  0  0  0  0              0 V3000\n',e2b='M  V30 END CTAB',f2b=2475109711874,g2b=2475109711875,h2b=2887426572290,i2b=2887426572291,j2b=2887627898882,k2b=2887627898883,l2b=2887627997186,m2b=3437182386178,n2b=3437182386179,o2b=3437383712770,p2b=3437383811074,q2b=3437652148226,r2b=3437652377602,s2b=4674132967426,t2b=4674334294018,u2b=4674334392322,v2b=4674602729474,w2b=4674602958850,x2b=5086449827842,y2b=5086449827848,z2b=5086651154434,A2b=5086651252738,B2b=5086651252743,C2b=5086919589890,D2b=5086919688194,E2b=5636406968322,F2b=5636407066626,G2b=5636675502082,H2b={l:589826,m:590112,h:4},I2b={l:589827,m:590112,h:4},J2b={l:589826,m:590160,h:4},K2b={l:589827,m:590160,h:4},L2b={l:688130,m:590160,h:4},M2b={l:589826,m:590224,h:4},N2b={l:589827,m:590224,h:4},O2b={l:819203,m:590224,h:4},P2b={l:589826,m:590368,h:4},Q2b={l:688130,m:590368,h:4},R2b={l:819202,m:590368,h:4},S2b={l:819208,m:590368,h:4},T2b={l:589826,m:590416,h:4},U2b={l:589832,m:590416,h:4},V2b={l:688130,m:590416,h:4},W2b={l:819202,m:590416,h:4},X2b={l:589826,m:598304,h:4},Y2b={l:589827,m:598304,h:4},Z2b={l:688130,m:598304,h:4},$2b={l:1114114,m:598304,h:4},_2b={l:1212418,m:598304,h:4},a3b={l:589826,m:598308,h:4},b3b={l:589826,m:688416,h:4},c3b={l:589826,m:688464,h:4},d3b={l:589826,m:688720,h:4},e3b={l:688130,m:688720,h:4},f3b={l:589826,m:590112,h:288},g3b={l:589826,m:590112,h:336},h3b={l:589826,m:688416,h:336},i3b={l:589826,m:688464,h:336},j3b={l:688130,m:688464,h:336},k3b={l:589826,m:590112,h:400},l3b={l:589826,m:688416,h:400},m3b={l:589826,m:688464,h:400},n3b={l:688130,m:688464,h:400},o3b={l:589826,m:819488,h:400},p3b={l:589826,m:819536,h:400},q3b={l:589826,m:819600,h:400},r3b={l:688130,m:819600,h:400},s3b={l:819202,m:819600,h:400},t3b={l:589831,m:688416,h:592},u3b={l:589831,m:688464,h:592},v3b={l:688135,m:688464,h:592},w3b={l:589831,m:819536,h:592},x3b={l:688135,m:819536,h:592},y3b={l:688135,m:819600,h:592},z3b={l:589832,m:1212704,h:592},A3b={l:589832,m:1212752,h:592},B3b={l:688136,m:1212752,h:592},C3b={l:589831,m:688464,h:656},D3b={l:589826,m:590112,h:8480},E3b={l:589826,m:688416,h:8480},F3b={l:589826,m:688464,h:8480},G3b={l:688130,m:688464,h:8480},H3b={l:819202,m:819600,h:8480},I3b={l:688135,m:1212752,h:8480},J3b={l:589832,m:1213008,h:8480},K3b={l:688136,m:1213008,h:8480},L3b={l:589826,m:590112,h:8484},M3b={l:589826,m:590160,h:8484},N3b={l:688130,m:598304,h:8484},O3b=0.6262000203132629,P3b=-1.3825000524520874,Q3b=0.33169999718666077,R3b=-1.4915000200271606,S3b=0.3540000021457672,T3b=0.38179999589920044,U3b=-0.6019999980926514,V3b=0.07999999821186066,W3b=-0.7379999756813049,X3b='Atom-types are 64-bit numbers describing atoms and their near surrounding.',Y3b='Recognized atom types and their contributions are:',Z3b='Druglikeness predictor not properly initialized.',$3b=3.009999990463257,_3b=-0.17000000178813934,a4b=-0.1809999942779541,b4b=-0.2029999941587448,c4b=2147483648,d4b='MMFF94',e4b='MMFF94s',f4b='117\nint,int,int,int,float\n0,2,0,0,0.020\n1,2,1,2,0.030\n1,2,2,2,0.027\n1,2,2,3,0.026\n1,2,2,5,0.013\n1,2,2,37,0.032\n2,2,2,5,0.013\n2,2,3,5,0.012\n2,2,5,5,0.006\n2,2,5,6,0.027\n2,2,5,37,0.017\n2,2,5,40,0.012\n2,2,5,41,0.008\n0,3,0,0,0.130\n1,3,1,7,0.146\n1,3,2,7,0.138\n1,3,3,7,0.134\n1,3,5,7,0.122\n1,3,6,7,0.141\n1,3,7,10,0.129\n1,3,7,37,0.138\n2,3,5,7,0.113\n2,3,5,9,0.081\n2,3,6,7,0.127\n2,3,7,10,0.116\n3,3,5,7,0.113\n3,3,6,7,0.127\n5,3,5,7,0.103\n5,3,5,9,0.074\n5,3,5,54,0.078\n5,3,6,7,0.119\n5,3,7,10,0.102\n5,3,9,40,0.067\n6,3,7,37,0.127\n7,3,10,10,0.113\n7,3,20,20,0.151\n9,3,40,40,0.057\n0,8,0,0,0.000\n0,10,0,0,0.015\n1,10,1,3,0.015\n1,10,3,6,0.015\n1,10,3,28,0.015\n3,10,3,28,0.015\n3,10,28,28,0.015\n0,17,0,0,0.000\n0,26,0,0,0.000\n0,30,0,0,0.010\n5,30,20,30,0.008\n0,37,0,0,0.035\n1,37,37,37,0.040\n2,37,37,37,0.031\n3,37,37,37,0.027\n5,37,37,37,0.015\n5,37,37,38,0.046\n5,37,37,63,0.008\n5,37,37,64,0.012\n5,37,37,69,0.016\n5,37,38,38,0.084\n6,37,37,37,0.048\n15,37,37,37,0.025\n37,37,37,40,0.046\n0,39,0,0,0.020\n1,39,63,63,0.012\n23,39,63,63,-0.014\n23,39,63,65,0.021\n23,39,65,65,0.062\n0,40,0,0,0.030\n1,40,28,37,0.030\n2,40,28,28,0.030\n3,40,28,28,0.030\n28,40,28,37,0.030\n0,41,0,0,0.180\n1,41,32,32,0.178\n2,41,32,32,0.161\n5,41,32,32,0.158\n0,43,0,0,0.000\n0,45,0,0,0.150\n0,49,0,0,0.000\n50,49,50,50,0.000\n0,54,0,0,0.020\n1,54,3,36,0.016\n3,54,36,36,0.018\n0,55,0,0,0.020\n1,55,36,57,0.020\n36,55,36,57,0.020\n0,56,0,0,0.020\n1,56,36,57,0.020\n36,56,36,57,0.020\n0,57,0,0,0.080\n5,57,55,55,0.038\n56,57,56,56,0.158\n0,58,0,0,0.025\n0,63,0,0,0.050\n5,63,39,64,0.019\n5,63,39,66,0.068\n5,63,44,64,0.014\n5,63,44,66,0.055\n5,63,59,64,0.033\n5,63,59,66,0.085\n37,63,39,64,0.010\n0,64,0,0,0.040\n5,64,63,64,0.006\n5,64,63,66,0.043\n5,64,64,65,0.052\n5,64,65,66,0.094\n37,64,63,64,-0.01\n0,67,0,0,0.070\n0,69,0,0,0.070\n32,69,37,37,0.067\n0,73,0,0,0.000\n0,78,0,0,0.045\n5,78,78,81,0.046\n0,80,0,0,0.080\n5,80,81,81,0.057\n0,81,0,0,0.025\n36,81,78,80,0.016\n0,82,0,0,0.000\n',g4b={330:1,4:1,5:1,7:1},h4b='div',i4b='position:absolute;left:',j4b='px;',k4b='rgba(',l4b=4278190080,m4b='px',n4b={202:1},o4b={378:1,27:1},p4b={379:1,27:1},q4b='position:absolute;width:',r4b='px;height:',s4b={46:1,4:1,5:1,7:1},t4b=22.5,u4b=21.176470588235293,v4b={204:1,27:1},w4b={205:1,27:1},x4b={250:1,27:1},y4b={365:1,27:1},z4b='true',A4b='data-idcode',B4b='MutationObserver',C4b='Parse exception ',D4b='error setting idcode data ',E4b={248:1,27:1},F4b={102:1,27:1},G4b='data:image/gif;base64,R0lGODlhHABGANUAAISChPLx8ubl5uDf4NLR0s/OzwAA//Hx8tHR0svLzMXFxuvs7OXm5t/g4MvMzAD/APf49+vs6+Xm5dfY18vMy/j49/Ly8enp6ODg38bGxdbTzv8AAPj39+zr68bFxcC/v/////39/fr6+vf39/T09PHx8e7u7uzs7Obm5uPj4+Dg4N3d3dra2tfX19TU1NHR0czMzMvLy8nJycbGxsPDw8DAwL29vbq6uqqqqiEhIQAAAAAAAAAAAAAAAAAAAAAAACwAAAAAHABGAAAG/0CQcEgsGo0AkGbJbDqfzqQGQK1ar1iqUgrIeb/gsFi33eZAp7R6zV6Tp+bTzfahzWSUAsLVYq02KQIXEThvXDknNjU0GTIxBS98fhuUFwsmhWVTiIsKjpCSf5SUJhaZcJsnNJ4OeqEqo6Mkp4cnHp+RE36wsaO0cTIwrn0rDb2jIr+pCQUEoQPHlCIhyl0nw34DKccc0yDViLl+GNu9I97fhnGv5bHdIUPgJ8Qq5To6GyTn8PHqqbspJFC6pw9dP03Wit27t2GhDngO0yFEVI9BQx0H7omIeBCVtRQoHJK4F+IeiIVC5Am4Z+IeBJMmhZiUd8Ghjo0oOco7YeIACf8IBo9I9IgIh9GjSJMi9ddFjFOnTM+0mdomqhw6dvBgW2Eg0CB5ihjhCmWgrCVMVjuNJVa2bSl5q2S02kOvbdtZVm89ErdChV278oJtbfC3bTKrzJwRG1C47DR5W7UVfje0Fl9yhfeltMpuskF59FL8Lchv88QTACXYJV1EXrFAq1GenGm1YlufJGGSqRwH5IWyAfTpnm2a6AlBHUyU+ImTeEyaPJdX8Cb7uVWePoGWFipPqXelUZ+K/xIVDdXzJ6zOqXMnD10/D7wSshq20d5QD/Kflaf2PrH8AL5lVVxzvQIggHidphcouvR14IGBCfNeMQ8CeNhpiT1TYX6PWRVvWQoVUibPZSA+qBlvqbAT4mdWhfbgSLKhaE1qB8JY0m4yIvKaADUCFWOOJ1QEoE/n/Aikb/kFVyQZNgGJnHLM3SiTdaddEB0J0/FjE22nYRelUB3V8t2YRjG15Zlo+gPmmkWgAsWbcMKRxZx0VhEEADs=',H4b='data:image/gif;base64,R0lGODlhHABGANUAAISChH59fnt6e3h3eHRzdMTDxLi3uJiXmAAAw3d3eLe3uKamp5eXmI+PkIaGh4ODhH1+fsPExLe4uJGSkgDDAM/Qz8DBwHh4d76+vZ6enZiYl4qKidbTzsMAANDPz8fGxqSjo5KRkYqJiYSDg////9LS0svLy76+vru7u7i4uLW1tbKysq+vr6ysrKmpqaOjo6GhoZubm5iYmJWVlZKSko+Pj4yMjImJiYSEhIODg4CAgHh4eG9vb19fXyEhIQAAACwAAAAAHABGAAAG/0CScEgsGo0AEmfJbDqfziQHQK1ar1iqUgrweb/gsPi33YrPaF956qXx3vC4PL7u+t4EQkIQ0AEcNzY1NB0HMRkwPXVePHk7fDojgIKEHR2IL4pTZncEAwIQOjkOIpSWpyALmlyMF5A4k4Mzp6cuq5w8kA+xNLO0p7dsd6GjgbK/pyzBdjyRvL7ILCvLjLvGEzMayC3SKtR3DhuCITMy290p3zzGvQznKyoKKOqU2ZY/Px0u3PAGKCfqGvSSEePej33d/J2woK4XPnwdHv6AJ7GAunIF8S3Ax0IiBgsFPqjTEEOiC3wr8KF4+MGEupI/XuBrgU8FvoUR8LlcdCeDxP8fHR9ikGjCgzoYLxYghCcBxceQJkxUKKGuh9WrWLNi5Zmmq5pNwtzMGSuHJx49kP6wQ2AIkTpHkCStRYAA09tHxEhRoss3lTpXfWCxm8GXry2zup4VLqwu7+DFfJWZdfYYMgJp6qwJwqYBMj9vZsONK+cZnbrBDErDk0dPVufCS1UoDDgwBuzPChmarQ37oYoUDy2axchXKUqV+EKOPERXKc0fNn+cwNfyJSbnQQ3gs6BzJ1hmiFLFfghSp1GzSLEzdQqypVSqZrXK18rVKxqeYsnqN9sIbR+1lFDQViJmwdWHXAFSQIFdBX6SVymDKCihX2YBpoNg9Ugo4WHfMZKO2GAaatiYKM+EKKFkHd5BWYYmUoCZWZrVwJmJn6kjWg3kyECjaWahtuNq85hVjwYhnvTQbGYJhJGGRqb0wz+6pchDbUxy8xB7wkm5pILYXfmUSGaRlAGXCOEDHFHWpbeUStN1p0546v32Ez7nSanmZ019GdVUy/xwx3yAWrXGEYQWChYUiCa6SRaMNlpFEAA7',I4b=21.333333333333332,J4b={237:1,27:1},K4b='width',L4b='height',M4b='offsetHeight',N4b='offsetWidth',O4b='Null widget handle. If you are creating a composite, ensure that initWidget() has been called.',P4b='Style names cannot be empty',Q4b='aria-hidden',R4b={43:1,37:1,40:1,39:1,44:1,35:1,34:1},S4b={43:1,37:1,40:1,39:1,44:1,35:1,34:1,30:1},T4b='left',U4b='visibility',V4b='hidden',W4b='visible',X4b='popupContent',Y4b=1281818470,Z4b={25:1},$4b={167:1,25:1},_4b=23.333333333333332,a5b=4294967295,b5b='font: 12px sans-serif',c5b='Atom Properties',d5b='cellPadding',e5b='Cancel',f5b='excluded atoms:',g5b='allowed atoms:',h5b='200px',i5b='any ring state',j5b={323:1,27:1},k5b='disabled',l5b='px Helvetica',m5b='Helvetica',n5b='canvas',o5b='undefined',p5b=0.08726646502812703,q5b=4278190335,r5b=0.003921568859368563,s5b='CENTER',t5b='position',u5b='absolute',v5b='CSS1Compat',w5b={38:1,31:1,4:1,18:1,20:1},x5b={36:1,31:1,4:1,18:1,20:1},y5b={31:1,85:1,4:1,18:1,20:1},z5b={58:1,4:1,18:1,20:1},A5b='load',B5b={146:1,4:1,19:1,28:1},C5b='Too many percent/per mille characters in pattern "',D5b=1048575,E5b=17592186044416,F5b=1000000000,G5b=-17592186044416,H5b=16777216,I5b='__gwtLastUnhandledEvent',J5b='__uiObjectID',K5b='cellSpacing',L5b='Column index: ',M5b=', Column size: ',N5b='Row index: ',O5b=', Row size: ',P5b='overflow',Q5b={43:1,37:1,40:1,39:1,44:1,182:1,35:1,34:1,30:1},R5b={88:1,4:1,18:1,20:1},S5b=5.56,T5b=11.12,U5b=13.34,V5b=14.44,W5b=0.3010299956639812,X5b='BigInteger divide by zero',Y5b={l:0,m:0,h:524288},Z5b={18:1,133:1},$5b={149:1},_5b={30:1,60:1,62:1,131:1},a6b='delete',b6b=15525485,c6b=5.9604644775390625E-8,d6b={4:1,149:1},e6b={4:1,18:1,20:1,93:1},f6b='Invalid UTF8 sequence',g6b=0.20000000298023224,h6b=' distance:',i6b='gGP`@dfyjidNcGI[WQCP`<',j6b={65:1};var TXb={};var UXb={};var VXb={};var WXb={};var XXb={};var YXb={};var ZXb={};var $Xb={};var _Xb={};var aYb={};var bYb={};var cYb={};var dYb={};var eYb={};var fYb={};var gYb={};var hYb={};var iYb={};var jYb={};var kYb={};var lYb={};var mYb={};var nYb={};var oYb={};var pYb={};var qYb={};var rYb={};var sYb={};var tYb={};var uYb={};var vYb={};var wYb={};var xYb={};var yYb={};var zYb={};var AYb={};var BYb={};var CYb={};var DYb={};var EYb={};var FYb={};var GYb={};var HYb={};var IYb={};var JYb={};var KYb={};var LYb={};var MYb={};var NYb={};var OYb={};var PYb={};var QYb={};var RYb={};var SYb={};var TYb={};var UYb={};var VYb={};var WYb={};var _;var txb;var nxb;TXb.Dwb=function Dwb(){};function sxb(a,b){typeof window===XYb&&typeof window['$gwt']===XYb&&(window['$gwt'][a]=b);}function rxb(b,c,d,e){TXb.qxb();var f=nxb;function g(){for(var a=0;a<f.length;a++){f[a]();}}if(b){try{SXb(g)();}catch(a){b(c,a);}}else {SXb(g)();}}TXb.qxb=function qxb(){nxb==null&&(nxb=[]);};function pxb(){TXb.qxb();var a=nxb;for(var b=0;b<arguments.length;b++){a.push(arguments[b]);}}TXb.oxb=function oxb(){};function Exb(){}function Dxb(a){if(Array.isArray(a)&&a.he===Exb){return UXb.Mc(a);}return a.toString();}function Cxb(a,b){var c=$wnd;if(a===''){return c;}var d=a.split('.');!(d[0]in c)&&c.execScript&&c.execScript('var '+d[0]);if(b){var e=b.prototype.fe;e.e=b;}for(var f;d.length&&(f=d.shift());){c=c[f]=c[f]||!d.length&&b||{};}return c;}TXb.Bxb=function Bxb(a){function b(){}b.prototype=a||{};return new b();};TXb.Axb=function Axb(a){return a instanceof Array?a[0]:null;};function zxb(a,b,c){var d=function(){return a.apply(d,arguments);};b.apply(d,c);return d;}function yxb(){}function xxb(a,b){for(var c in b){b[c]['configurable']=true;}Object.defineProperties(a,b);}function wxb(a,b,c){var d=txb;var e=d[a];var f=TXb.Axb(e);if(e&&!f){_=e;}else {_=TXb.vxb(b);_.ge=c;!b&&(_.he=Exb);d[a]=_;}for(var g=3;g<arguments.length;++g){arguments[g].prototype=_;}f&&(_.fe=f);}TXb.vxb=function vxb(a){var b=a&&a.prototype;!b&&(b=txb[a]);return TXb.Bxb(b);};TXb.uxb=function uxb(){};$wnd.goog=$wnd.goog||{};$wnd.goog.global=$wnd.goog.global||$wnd;txb={};UXb.Bc=function Bc(a,b){return elb(a)===elb(b);};UXb.Cc=function Cc(a){return a.fe;};UXb.Dc=function Dc(a){return XXb.rTb(a);};function Ec(){}UXb.Gc=function Gc(a,b){return blb(a)?UXb.CHb(a,b):$kb(a)?UXb.sGb(a,b):Zkb(a)?UXb.lFb(a,b):Xkb(a)?a.ib(b):Tjb(a)?UXb.Bc(a,b):VXb.v7(a,b);};UXb.Ic=function Ic(a){return blb(a)?UXb.EHb():$kb(a)?UXb.tGb():Zkb(a)?UXb.mFb():Xkb(a)?a.fe:Tjb(a)?UXb.Cc(a):VXb.w7(a);};UXb.Kc=function Kc(a){return blb(a)?UXb.FHb(a):$kb(a)?UXb.uGb(a):Zkb(a)?UXb.nFb(a):Xkb(a)?a.kb():Tjb(a)?UXb.Dc(a):VXb.x7(a);};UXb.Mc=function Mc(a){var b;return UXb.OFb(UXb.Ic(a))+'@'+(b=XXb.KTb(XXb.JTb(UXb.Kc(a))),b.toString(16));};wxb(1,null,{},Ec);_.ib=function Fc(a){return UXb.Bc(this,a);};_.jb=function Hc(){return UXb.Cc(this);};_.kb=function Jc(){return UXb.Dc(this);};_.lb=function Lc(){var a;return UXb.OFb(UXb.Ic(this))+'@'+(a=XXb.KTb(XXb.JTb(UXb.Kc(this))),a.toString(16));};_.equals=function(a){return this.ib(a);};_.hashCode=function(){return this.kb();};_.toString=function(){return this.lb();};VXb.v7=function v7(a,b){return VXb.B7(a)?VXb.y7(a,b):elb(a)===elb(b);};VXb.w7=function w7(a){return a.fe||Array.isArray(a)&&Ljb(TXb.wqb,1)||TXb.wqb;};VXb.x7=function x7(a){return VXb.C7(a)?VXb.z7(a):XXb.rTb(a);};VXb.y7=function y7(a,b){return a.equals(b);};VXb.z7=function z7(a){return a.hashCode();};VXb.A7=function A7(){return [];};VXb.B7=function B7(a){return !!a&&!!a.equals;};VXb.C7=function C7(a){return !!a&&!!a.hashCode;};VXb.D7=function D7(a){return a.toString?a.toString():'[JavaScriptObject]';};WXb.Q9=function Q9(){WXb.Q9=yxb;var a,b;b=!WXb.Z9();a=new WXb.gab();WXb.P9=b?new WXb.$9():a;};WXb.R9=function R9(a){WXb.Q9();WXb.P9.td(a);};WXb.S9=function S9(a){WXb.Q9();var b;b=WXb.P9.ud(a);return WXb.T9(b);};WXb.T9=function T9(a){var b,c,d,e;b='R9';c='Xz';e=$wnd.Math.min(a.length,5);for(d=e-1;d>=0;d--){if(UXb.CHb(a[d].d,b)||UXb.CHb(a[d].d,c)){a.length>=d+1&&XXb.KTb(a).splice(0,d+1);break;}}return a;};WXb.U9=function U9(a){var b=/function(?:\s+([\w$]+))?\s*\(/;var c=b.exec(a);return c&&c[1]||YYb;};WXb.V9=function V9(a){WXb.Q9();return a&&a[ZYb]?a[ZYb]:[];};WXb.W9=function W9(a){WXb.Q9();return a.name||(a.name=WXb.U9(a.toString()));};WXb.X9=function X9(a){WXb.Q9();return parseInt(a)||-1;};WXb.Y9=function Y9(a){WXb.Q9();var b=a.backingJsObject;if(b&&b.stack){var c=b.stack;var d=b+$Yb;c.substring(0,d.length)==d&&(c=c.substring(d.length));return c.split($Yb);}return [];};WXb.Z9=function Z9(){if(Error.stackTraceLimit>0){$wnd.Error.stackTraceLimit=Error.stackTraceLimit=64;return true;}return 'stack'in new Error();};wxb(653,1,{});WXb.$9=function $9(){};wxb(388,653,{},WXb.$9);_.td=function _9(a){var b={};var c=[];a[ZYb]=c;var d=arguments.callee.caller;while(d){var e=WXb.W9(d);c.push(e);var f=':'+e;var g=b[f];if(g){var h,i;for(h=0,i=g.length;h<i;h++){if(g[h]===d){return;}}}(g||(b[f]=[])).push(d);d=d.caller;}};_.ud=function aab(a){var b,c,d,e;d=WXb.V9(a);c=VXb.d9(d);e=Rjb(TXb.Jub,_Yb,96,c,0,1);for(b=0;b<c;b++){e[b]=new UXb.rHb(VXb.c9(d,b),null,-1);}return e;};WXb.bab=function bab(a,b){var c,d,e,f,g,h,i,j,k;j='';if(XXb.KTb(b).length==0){return a.vd(aZb,YYb,-1,-1);}k=UXb.RHb(b);UXb.CHb(XXb.KTb(k).substr(0,3),'at ')&&(k=(XXb.FTb(3,XXb.KTb(k).length+1),XXb.KTb(k).substr(3)));k=WXb.cab(k);g=XXb.KTb(k).indexOf('(');if(g==-1){g=XXb.KTb(k).indexOf('@');if(g==-1){j=k;k='';}else {j=UXb.RHb((XXb.FTb(g+1,XXb.KTb(k).length+1),XXb.KTb(k).substr(g+1)));k=UXb.RHb((XXb.ETb(0,g,XXb.KTb(k).length),XXb.KTb(k).substr(0,g)));}}else {c=XXb.KTb(k).indexOf(')',g);j=(XXb.ETb(g+1,c,XXb.KTb(k).length),XXb.KTb(k).substr(g+1,c-(g+1)));k=UXb.RHb((XXb.ETb(0,g,XXb.KTb(k).length),XXb.KTb(k).substr(0,g)));}g=UXb.GHb(k,THb(46));g!=-1&&(k=(XXb.FTb(g+1,XXb.KTb(k).length+1),XXb.KTb(k).substr(g+1)));(XXb.KTb(k).length==0||UXb.CHb(k,'Anonymous function'))&&(k=YYb);h=UXb.JHb(j,THb(58));e=UXb.KHb(j,THb(58),h-1);i=-1;d=-1;f=aZb;if(h!=-1&&e!=-1){f=(XXb.ETb(0,e,XXb.KTb(j).length),XXb.KTb(j).substr(0,e));i=WXb.X9((XXb.ETb(e+1,h,XXb.KTb(j).length),XXb.KTb(j).substr(e+1,h-(e+1))));d=WXb.X9((XXb.FTb(h+1,XXb.KTb(j).length+1),XXb.KTb(j).substr(h+1)));}return a.vd(f,k,i,d);};WXb.cab=function cab(a){return a.replace(/\[.*?\]/g,'');};wxb(654,653,{});_.td=function dab(a){};_.vd=function eab(a,b,c,d){return new UXb.rHb(b,a+'@'+d,c<0?-1:c);};_.ud=function fab(a){var b,c,d,e,f,g;e=WXb.Y9(a);f=Rjb(TXb.Jub,_Yb,96,0,0,1);b=0;d=VXb.d9(e);if(d==0){return f;}g=WXb.bab(this,VXb.c9(e,0));UXb.CHb(g.d,YYb)||(f[b++]=g);for(c=1;c<d;c++){f[b++]=WXb.bab(this,VXb.c9(e,c));}return f;};WXb.gab=function gab(){};wxb(389,654,{},WXb.gab);_.vd=function hab(a,b,c,d){return new UXb.rHb(b,a,-1);};TXb.Kjb=function Kjb(a){return a;};function Ljb(a,b){return TXb.Mjb(a,b);}TXb.Mjb=function Mjb(a,b){return UXb.ZFb(a,b);};TXb.Njb=function Njb(a){return a.__elementTypeCategory$==null?10:a.__elementTypeCategory$;};TXb.Ojb=function Ojb(a){return a.__elementTypeId$;};function Pjb(a,b,c,d,e,f){return TXb.Qjb(a,b,c,d,e,0,f);}TXb.Qjb=function Qjb(a,b,c,d,e,f,g){var h,i,j,k,l;k=e[f];j=f==g-1;h=j?d:0;l=TXb.Sjb(h,k);d!=10&&Zjb(Ljb(a,g-f),b[f],c[f],h,l);if(!j){++f;for(i=0;i<k;++i){TXb.Ujb(l,i,TXb.Qjb(a,b,c,d,e,f,g));}}return l;};function Rjb(a,b,c,d,e,f){var g;g=TXb.Sjb(e,d);e!=10&&Zjb(Ljb(a,f),b,c,e,g);return g;}TXb.Sjb=function Sjb(a,b){var c=new Array(b);var d;switch(a){case 14:case 15:d=0;break;case 16:d=false;break;default:return c;}for(var e=0;e<b;++e){c[e]=d;}return c;};function Tjb(a){return Array.isArray(a)&&a.he===Exb;}TXb.Ujb=function Ujb(a,b,c){return a[b]=c;};function Vjb(a,b,c){return TXb.Ujb(a,b,c);}TXb.Wjb=function Wjb(a,b){a.fe=b;};TXb.Xjb=function Xjb(a,b){a.__elementTypeCategory$=b;};TXb.Yjb=function Yjb(a,b){a.__elementTypeId$=b;};function Zjb(a,b,c,d,e){TXb.Wjb(e,a);e.ge=b;e.he=Exb;TXb.Yjb(e,c);TXb.Xjb(e,d);return e;}TXb.$jb=function $jb(a,b){TXb.Njb(b)!=10&&Zjb(UXb.Ic(b),b.ge,TXb.Ojb(b),TXb.Njb(b),a);return TXb.Kjb(a);};function Vkb(a,b){if(blb(a)){return !!Ukb[b];}else if(a.ge){return !!a.ge[b];}else if($kb(a)){return !!Tkb[b];}else if(Zkb(a)){return !!Skb[b];}return false;}function Wkb(a){return String.fromCharCode(a);}function Xkb(a){return !Array.isArray(a)&&a.he===Exb;}function Ykb(a,b){return a!=null&&Vkb(a,b);}function Zkb(a){return typeof a===bZb;}function $kb(a){return typeof a===cZb;}function _kb(a){return a!=null&&TXb.clb(a)&&!(a.he===Exb);}function alb(a,b){return TXb.dlb(a,b);}function blb(a){return typeof a===dZb;}TXb.clb=function clb(a){return typeof a===XYb||typeof a===eZb;};TXb.dlb=function dlb(a,b){return a&&b&&a instanceof b;};function elb(a){return a==null?null:a;}function flb(a){return Math.max(Math.min(a,fZb),-2147483648)|0;}var Skb;var Tkb;var Ukb;TXb.Ewb=function Ewb(a){return a&&a.__java$exception;};function Fwb(a){var b;if(Ykb(a,28)){return a;}b=TXb.Ewb(a);if(!b){b=new VXb.U8(a);WXb.R9(b);}return b;}function Gwb(a){return a.backingJsObject;}function QEb(a){var b;if(a==null){return false;}b=typeof a;return UXb.CHb(b,bZb)||UXb.CHb(b,cZb)||UXb.CHb(b,dZb)||a.$implements__java_io_Serializable||Array.isArray(a);}function iGb(a){var b;b=typeof a;if(UXb.CHb(b,bZb)||UXb.CHb(b,cZb)||UXb.CHb(b,dZb)){return true;}return a!=null&&a.$implements__java_lang_Comparable;}UXb.hFb=function hFb(){UXb.hFb=yxb;gFb=XXb.KTb(false);XXb.KTb(true);};UXb.iFb=function iFb(a){return XXb.LTb((XXb.zTb(a),a));};UXb.jFb=function jFb(a,b){return pFb(XXb.LTb((XXb.zTb(a),a)),XXb.LTb((XXb.zTb(b),b)));};UXb.kFb=function kFb(a,b){return UXb.jFb(a,b);};UXb.lFb=function lFb(a,b){return XXb.zTb(a),a===b;};UXb.mFb=function mFb(){return TXb.qub;};UXb.nFb=function nFb(a){return XXb.LTb((XXb.zTb(a),a))?1231:1237;};function oFb(a){UXb.hFb();return UXb.CHb(bZb,typeof a);}function pFb(a,b){UXb.hFb();return a==b?0:a?1:-1;}UXb.qFb=function qFb(a,b){UXb.hFb();return blb(a)?UXb.wHb(a,b):$kb(a)?UXb.qGb(a,b):Zkb(a)?UXb.kFb(a,b):a.Eb(b);};Skb={4:1,380:1,18:1};var gFb;function rFb(a){if(UXb.CHb(typeof a,dZb)){return true;}return a!=null&&a.$implements__java_lang_CharSequence;}UXb.MFb=function MFb(a){a.i=LFb++;};UXb.NFb=function NFb(a){if(a.n!=null){return;}UXb.bGb(a);};UXb.OFb=function OFb(a){UXb.NFb(a);return a.n;};UXb.PFb=function PFb(a){return (a.f&4)!=0;};UXb.QFb=function QFb(a){return (a.f&1)!=0;};UXb.RFb=function RFb(){UXb.MFb(this);this.n=null;this.j=null;this.g=null;this.d=null;this.b=null;this.k=null;this.a=null;};UXb.TFb=function TFb(a){var b;b=new UXb.RFb();b.n='Class$'+(a?'S'+a:''+b.i);b.b=b.n;b.j=b.n;return b;};function UFb(a){var b;b=UXb.TFb(a);UXb.fGb(a,b);return b;}function VFb(a,b){var c;c=UXb.TFb(a);UXb.fGb(a,c);c.f=b?8:0;return c;}function WFb(){var a;a=UXb.TFb(null);a.f=2;return a;}function XFb(a){var b;b=UXb.TFb(a);b.k=a;b.f=1;return b;}UXb.ZFb=function ZFb(a,b){var c=a.a=a.a||[];return c[b]||(c[b]=a.Kd(b));};function _Fb(a){if(a.Pd()){return null;}var b=a.k;return txb[b];}UXb.bGb=function bGb(a){if(a.Od()){var b=a.c;b.Pd()?a.n='['+b.k:!b.Od()?a.n='[L'+b.Md()+';':a.n='['+b.Md();a.b=b.Ld()+'[]';a.j=b.Nd()+'[]';return;}var c=a.g;var d=a.d;d=d.split('/');a.n=UXb.eGb('.',[c,UXb.eGb('$',d)]);a.b=UXb.eGb('.',[c,UXb.eGb('.',d)]);a.j=d[d.length-1];};UXb.eGb=function eGb(a,b){var c=0;while(!b[c]||b[c]==''){c++;}var d=b[c++];for(;c<b.length;c++){if(!b[c]||b[c]==''){continue;}d+=a+b[c];}return d;};UXb.fGb=function fGb(a,b){if(!a){return;}b.k=a;var d=_Fb(b);if(!d){txb[a]=[b];return;}d.fe=b;};wxb(238,1,{},UXb.RFb);_.Kd=function SFb(a){var b;b=new UXb.RFb();b.f=4;a>1?b.c=UXb.ZFb(this,a-1):b.c=this;return b;};_.Ld=function YFb(){UXb.NFb(this);return this.b;};_.Md=function $Fb(){return UXb.OFb(this);};_.Nd=function aGb(){UXb.NFb(this);return this.j;};_.Od=function cGb(){return UXb.PFb(this);};_.Pd=function dGb(){return UXb.QFb(this);};_.lb=function gGb(){return ((this.f&2)!=0?'interface ':(this.f&1)!=0?'':'class ')+(UXb.NFb(this),this.n);};_.f=0;_.i=0;var LFb=1;UXb.kGb=function kGb(a){return UXb.CHb(cZb,typeof a)||alb(a,$wnd.java.lang.Number$impl);};UXb.lGb=function lGb(a){UXb.jGb==null&&(UXb.jGb=new RegExp('^\\s*[+-]?(NaN|Infinity|((\\d+\\.?\\d*)|(\\.\\d+))([eE][+-]?\\d+)?[dDfF]?)\\s*$'));if(!UXb.jGb.test(a)){throw Gwb(new UXb.qHb(gZb+a+'"'));}return parseFloat(a);};UXb.mGb=function mGb(a,b,c){var d,e,f,g,h;if(a==null){throw Gwb(new UXb.qHb(hZb));}f=XXb.KTb(a).length;g=f>0&&(XXb.FTb(0,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(0)==45||(XXb.FTb(0,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(0)==43))?1:0;for(d=g;d<f;d++){if(xFb((XXb.FTb(d,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(d)))==-1){throw Gwb(new UXb.qHb(gZb+a+'"'));}}h=parseInt(a,10);e=h<b;if(isNaN(h)){throw Gwb(new UXb.qHb(gZb+a+'"'));}else if(e||h>c){throw Gwb(new UXb.qHb(gZb+a+'"'));}return h;};UXb.nGb=function nGb(a){return $kb(a)?UXb.rGb(a):a.Qd();};UXb.oGb=function oGb(a){return $kb(a)?UXb.vGb(a):a.Rd();};wxb(142,1,{4:1,142:1});UXb.pGb=function pGb(a,b){return xGb(XXb.MTb((XXb.zTb(a),a)),XXb.MTb((XXb.zTb(b),b)));};UXb.qGb=function qGb(a,b){return UXb.pGb(a,b);};UXb.rGb=function rGb(a){return XXb.MTb((XXb.zTb(a),a));};UXb.sGb=function sGb(a,b){return XXb.zTb(a),elb(a)===elb(b);};UXb.tGb=function tGb(){return TXb.uub;};UXb.uGb=function uGb(a){return flb(XXb.MTb((XXb.zTb(a),a)));};UXb.vGb=function vGb(a){return flb(XXb.MTb((XXb.zTb(a),a)));};function wGb(a){return UXb.CHb(cZb,typeof a);}function xGb(a,b){if(a<b){return -1;}if(a>b){return 1;}if(a==b){return a==0?xGb(1/a,1/b):0;}return isNaN(a)?isNaN(b)?0:1:-1;}function yGb(a){if(isNaN(a)){return {l:0,m:0,h:524160};}return XXb.GTb(a);}Tkb={4:1,18:1,386:1,142:1};UXb.Cz=function Cz(a){a.i=Rjb(TXb.Jub,_Yb,96,0,0,1);};UXb.Dz=function Dz(a,b){XXb.ATb(b,'Cannot suppress a null exception.');XXb.tTb(b!=a,'Exception can not suppress itself.');if(a.g){return;}a.j==null?a.j=Zjb(Ljb(TXb.Oub,1),_Yb,28,0,[b]):a.j[a.j.length]=b;};UXb.Ez=function Ez(a){WXb.R9(a);};UXb.Fz=function Fz(a){return WXb.S9(a);};UXb.Gz=function Gz(a){if(a.k){a.backingJsObject!==iZb&&a.Xb();a.i=null;}return a;};UXb.Hz=function Hz(a){return a.e;};UXb.Iz=function Iz(d,b){if(b instanceof Object){try{b.__java$exception=d;if(navigator.userAgent.toLowerCase().indexOf('msie')!=-1&&$doc.documentMode<9){return;}var c=d;Object.defineProperties(b,{cause:{get:function(){var a=c.Vb();return a&&a.Tb();}},suppressed:{get:function(){return c.Ub();}}});}catch(a){}}};UXb.Jz=function Jz(a,b,c){var d,e,f,g,h;UXb.Kz(a);for(e=(a.j==null&&(a.j=Rjb(TXb.Oub,_Yb,28,0,0,1)),a.j),f=0,g=e.length;f<g;++f){d=e[f];UXb.Jz(d,b,'\t'+c);}h=a.e;!!h&&UXb.Jz(h,b,c);};UXb.Kz=function Kz(a){var b,c,d;for(b=(a.i==null&&(a.i=UXb.Fz(a)),a.i),c=0,d=b.length;c<d;++c){}};UXb.Lz=function Lz(a,b){a.backingJsObject=b;UXb.Iz(a,b);};UXb.Mz=function Mz(a){return UXb.Nz(a,a.Wb());};UXb.Nz=function Nz(a,b){var c;c=UXb.OFb(a.fe);return b==null?c:c+': '+b;};UXb.Oz=function Oz(){UXb.Cz(this);UXb.Gz(this);this.Xb();};UXb.Pz=function Pz(a){UXb.Cz(this);this.f=a;UXb.Gz(this);this.Xb();};UXb.Qz=function Qz(a,b){UXb.Cz(this);this.e=b;this.f=a;UXb.Gz(this);this.Xb();};UXb.Sz=function Sz(b){if(!('stack'in b)){try{throw b;}catch(a){}}return b;};function Yz(a){var b;if(a!=null){b=a.__java$exception;if(b){return b;}}return alb(a,TypeError)?new UXb.nHb(a):new UXb.M8(a);}wxb(28,1,{4:1,28:1});_.Sb=function Rz(a){return new Error(a);};_.Tb=function Tz(){return this.backingJsObject;};_.Ub=function Uz(){var a,b,c;c=(this.j==null&&(this.j=Rjb(TXb.Oub,_Yb,28,0,0,1)),this.j);b=Rjb(TXb.Hub,jZb,1,c.length,5,1);for(a=0;a<c.length;a++){b[a]=c[a].backingJsObject;}return b;};_.Vb=function Vz(){return UXb.Hz(this);};_.Wb=function Wz(){return this.f;};_.Xb=function Xz(){UXb.Lz(this,UXb.Sz(this.Sb(UXb.Nz(this,this.f))));UXb.Ez(this);};_.lb=function Zz(){return UXb.Mz(this);};_.backingJsObject=iZb;_.g=false;_.k=true;UXb.$z=function $z(){UXb.Oz.call(this);};UXb._z=function _z(a){UXb.Cz(this);UXb.Gz(this);this.backingJsObject=a;UXb.Iz(this,a);this.f=a==null?hZb:Dxb(a);};UXb.aA=function aA(a){UXb.Pz.call(this,a);};UXb.bA=function bA(a,b){UXb.Qz.call(this,a,b);};wxb(19,28,kZb,UXb.aA);UXb.cA=function cA(){UXb.$z.call(this);};UXb.dA=function dA(a){UXb._z.call(this,a);};UXb.eA=function eA(a){UXb.aA.call(this,a);};UXb.fA=function fA(a,b){UXb.bA.call(this,a,b);};wxb(55,19,kZb,UXb.eA);UXb.cFb=function cFb(){UXb.cA.call(this);};UXb.dFb=function dFb(a){UXb.eA.call(this,a);};wxb(56,55,kZb,UXb.cFb,UXb.dFb);UXb.L8=function L8(){UXb.cA.call(this);};UXb.M8=function M8(a){UXb.dA.call(this,a);};UXb.N8=function N8(a){UXb.eA.call(this,a);};wxb(150,55,kZb,UXb.M8);UXb.mHb=function mHb(){UXb.L8.call(this);};UXb.nHb=function nHb(a){UXb.M8.call(this,a);};UXb.oHb=function oHb(a){UXb.N8.call(this,a);};wxb(74,150,kZb,UXb.mHb,UXb.nHb,UXb.oHb);_.Sb=function pHb(a){return new TypeError(a);};UXb.vHb=function vHb(a,b){XXb.FTb(b,XXb.KTb(a).length);return XXb.KTb(a).charCodeAt(b);};UXb.wHb=function wHb(a,b){return UXb.xHb(a,b);};UXb.xHb=function xHb(a,b){var c,d;c=UXb.rGb(XXb.KTb(a));d=UXb.rGb(XXb.KTb(b));return c==d?0:c<d?-1:1;};UXb.yHb=function yHb(a,b){return UXb.xHb(XXb.KTb(a).toLowerCase(),XXb.KTb(b).toLowerCase());};UXb.zHb=function zHb(a,b){return XXb.zTb(a),a+(''+(XXb.zTb(b),b));};UXb.AHb=function AHb(a){var b;return UXb.VHb(XXb.jTb(a,0,(b=a.length,XXb.gTb(),b)));};UXb.BHb=function BHb(a){var b;b=XXb.KTb(lZb).length;return UXb.CHb(XXb.KTb(a).substr(XXb.KTb(a).length-b,b),lZb);};UXb.CHb=function CHb(a,b){return XXb.zTb(a),elb(a)===elb(b);};UXb.DHb=function DHb(a,b){XXb.zTb(a);if(b==null){return false;}if(UXb.CHb(a,b)){return true;}return XXb.KTb(a).length==XXb.KTb(b).length&&UXb.CHb(XXb.KTb(a).toLowerCase(),XXb.KTb(b).toLowerCase());};UXb.EHb=function EHb(){return TXb.Nub;};UXb.FHb=function FHb(a){var b,c;b=0;for(c=0;c<XXb.KTb(a).length;c++){b=(b<<5)-b+(XXb.FTb(c,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(c))|0;}return b;};UXb.GHb=function GHb(a,b){return XXb.KTb(a).indexOf(b);};UXb.HHb=function HHb(a,b,c){return XXb.KTb(a).indexOf(b,c);};function IHb(a){return UXb.CHb(dZb,typeof a);}UXb.JHb=function JHb(a,b){return XXb.KTb(a).lastIndexOf(b);};UXb.KHb=function KHb(a,b,c){return XXb.KTb(a).lastIndexOf(b,c);};UXb.LHb=function LHb(a,b){var c;c=UXb.MHb(b,'([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])','\\\\$1');return UXb.MHb(a,c,'');};UXb.MHb=function MHb(a,b,c){c=UXb.UHb(c);return XXb.KTb(a).replace(new RegExp(b,'g'),c);};UXb.NHb=function NHb(a,b){var c,d,e,f,g,h,i,j;c=new RegExp(b,'g');i=Rjb(TXb.Nub,mZb,2,0,6,1);d=0;j=a;f=null;while(true){h=c.exec(j);if(h==null||j==''){i[d]=j;break;}else {g=h.index;i[d]=(XXb.ETb(0,g,XXb.KTb(j).length),XXb.KTb(j).substr(0,g));j=UXb.QHb(j,g+XXb.KTb(XXb.KTb(h)[0]).length,XXb.KTb(j).length);c.lastIndex=0;if(f==j){i[d]=(XXb.ETb(0,1,XXb.KTb(j).length),XXb.KTb(j).substr(0,1));j=(XXb.FTb(1,XXb.KTb(j).length+1),XXb.KTb(j).substr(1));}f=j;++d;}}if(XXb.KTb(a).length>0){e=i.length;while(e>0&&i[e-1]==''){--e;}e<i.length&&(XXb.KTb(i).length=e);}return i;};UXb.OHb=function OHb(a,b){return UXb.CHb(XXb.KTb(a).substr(0,XXb.KTb(b).length),b);};UXb.PHb=function PHb(a,b){XXb.FTb(b,XXb.KTb(a).length+1);return XXb.KTb(a).substr(b);};UXb.QHb=function QHb(a,b,c){XXb.ETb(b,c,XXb.KTb(a).length);return XXb.KTb(a).substr(b,c-b);};UXb.RHb=function RHb(a){var b,c,d;c=XXb.KTb(a).length;d=0;while(d<c&&(XXb.FTb(d,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(d)<=32)){++d;}b=c;while(b>d&&(XXb.FTb(b-1,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(b-1)<=32)){--b;}return d>0||b<c?(XXb.ETb(d,b,XXb.KTb(a).length),XXb.KTb(a).substr(d,b-d)):a;};UXb.SHb=function SHb(a){return String.fromCharCode.apply(null,a);};function THb(a){var b,c;if(a>=nZb){b=55296+(a-nZb>>10&1023)&oZb;c=56320+(a-nZb&1023)&oZb;return String.fromCharCode(b)+(''+String.fromCharCode(c));}else {return String.fromCharCode(a&oZb);}}UXb.UHb=function UHb(a){var b;b=0;while(0<=(b=XXb.KTb(a).indexOf('\\',b))){XXb.FTb(b+1,XXb.KTb(a).length);XXb.KTb(a).charCodeAt(b+1)==36?a=(XXb.ETb(0,b,XXb.KTb(a).length),XXb.KTb(a).substr(0,b)+'$'+UXb.PHb(a,++b)):a=(XXb.ETb(0,b,XXb.KTb(a).length),XXb.KTb(a).substr(0,b)+(''+UXb.PHb(a,++b)));}return a;};UXb.VHb=function VHb(a){return UXb.WHb(a,0,a.length);};UXb.WHb=function WHb(a,b,c){var d,e,f,g;f=b+c;XXb.ETb(b,f,a.length);g='';for(e=b;e<f;){d=$wnd.Math.min(e+pZb,f);g+=UXb.SHb(XXb.KTb(a).slice(e,d));e=d;}return g;};Ukb={4:1,240:1,18:1,2:1};UXb.lIb=function lIb(a){UXb.dFb.call(this,a);};wxb(262,56,kZb,UXb.lIb);XXb.XSb=function XSb(a){var b;b=XXb.KTb(a).slice();return XXb.fTb(b,a);};XXb.YSb=function YSb(a,b,c,d,e,f){var g,h,i,j,k;if(e==0){return;}if(elb(a)===elb(c)){a=XXb.KTb(a).slice(b,b+e);b=0;}i=XXb.KTb(c);for(h=b,j=b+e;h<j;){g=$wnd.Math.min(h+pZb,j);e=g-h;k=XXb.KTb(a).slice(h,g);XXb.KTb(k).splice(0,0,XXb.KTb(d),XXb.KTb(f?e:0));Array.prototype.splice.apply(i,k);h=g;d+=e;}};XXb.ZSb=function ZSb(a,b){return XXb.fTb(new Array(b),a);};XXb.$Sb=function $Sb(a,b,c){XXb.KTb(a).splice(b,0,c);};XXb._Sb=function _Sb(a,b,c){XXb.YSb(c,0,a,b,c.length,false);};XXb.aTb=function aTb(a,b){XXb.KTb(a).push(b);};XXb.bTb=function bTb(a,b){XXb.KTb(a).push(b);};XXb.cTb=function cTb(a,b,c){XXb.KTb(a).splice(b,c);};XXb.dTb=function dTb(a,b){XXb.KTb(a).length=b;};XXb.eTb=function eTb(a,b){XXb.KTb(a).sort(b);};wxb(741,1,{});XXb.oTb=function oTb(){};XXb.pTb=function pTb(a){switch(typeof a){case dZb:return UXb.FHb(XXb.KTb(a));case cZb:return UXb.uGb(XXb.KTb(a));case bZb:return UXb.nFb(XXb.KTb(a));default:return a==null?0:XXb.rTb(a);}};XXb.qTb=function qTb(){return ++XXb.nTb;};XXb.rTb=function rTb(a){return a.$H||(a.$H=XXb.qTb());};wxb(651,1,{},XXb.oTb);XXb.nTb=0;XXb.sTb=function sTb(a){if(!a){throw Gwb(new UXb.AGb());}};XXb.tTb=function tTb(a,b){if(!a){throw Gwb(new UXb.BGb(b));}};XXb.uTb=function uTb(a,b){if(0>a){throw Gwb(new UXb.BGb('fromIndex: 0 > toIndex: '+a));}if(a>b){throw Gwb(new UXb.fFb('fromIndex: 0, toIndex: '+a+qZb+b));}};XXb.vTb=function vTb(a){if(a<0){throw Gwb(new UXb.lHb('Negative array size: '+a));}};XXb.wTb=function wTb(a,b){if(a!=b){throw Gwb(new $Xb.APb());}};XXb.xTb=function xTb(a){if(!a){throw Gwb(new $Xb.IQb());}};XXb.yTb=function yTb(a,b){if(a<0||a>=b){throw Gwb(new UXb.dFb(rZb+a+sZb+b));}};XXb.zTb=function zTb(a){if(a==null){throw Gwb(new UXb.mHb());}return a;};XXb.ATb=function ATb(a,b){if(a==null){throw Gwb(new UXb.oHb(b));}};XXb.BTb=function BTb(a,b){if(a<0||a>b){throw Gwb(new UXb.dFb(rZb+a+sZb+b));}};XXb.CTb=function CTb(a,b,c){if(a<0||b>c){throw Gwb(new UXb.dFb(tZb+a+uZb+b+', size: '+c));}if(a>b){throw Gwb(new UXb.BGb(tZb+a+' > toIndex: '+b));}};XXb.DTb=function DTb(a){if(!a){throw Gwb(new UXb.CGb());}};XXb.ETb=function ETb(a,b,c){if(a<0||b>c||b<a){throw Gwb(new UXb.lIb(tZb+a+uZb+b+qZb+c));}};XXb.FTb=function FTb(a,b){if(a<0||a>=b){throw Gwb(new UXb.lIb(rZb+a+sZb+b));}};XXb.GTb=function GTb(a){var b,c;b=new ArrayBuffer(8);XXb.KTb(new Float64Array(b))[0]=a;c=XXb.KTb(new Uint32Array(b));return XXb.NTb(c[0]|0,c[1]|0);};XXb.HTb=function HTb(a,b){return a[b];};XXb.ITb=function ITb(a){return a===undefined;};XXb.JTb=function JTb(a){return a>>>0;};XXb.KTb=function KTb(a){return a;};XXb.LTb=function LTb(a){return a;};XXb.MTb=function MTb(a){return a;};wxb(652,1,{});TXb.Hub=UFb(1);TXb.wqb=UFb(0);TXb.Fqb=UFb(653);TXb.Cqb=UFb(388);TXb.Eqb=UFb(654);TXb.Dqb=UFb(389);TXb.qub=UFb(380);TXb.tub=UFb(238);TXb.Gub=UFb(142);TXb.uub=UFb(386);TXb.Oub=UFb(28);TXb.wub=UFb(19);TXb.Iub=UFb(55);TXb.zub=UFb(56);TXb.Bub=UFb(150);TXb.Eub=UFb(74);TXb.Nub=UFb(2);TXb.Mub=UFb(262);TXb.Xvb=UFb(651);TXb.Yvb=UFb(652);YXb.Nc=function Nc(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q;this.c=a.length;this.d=a[0].length;G=$wnd.Math.min(this.c,this.d);this.e=Rjb(TXb.ilb,vZb,6,$wnd.Math.min(this.c+1,this.d),15,1);this.a=Pjb(TXb.ilb,[_Yb,vZb],[13,6],15,[this.c,G],2);this.b=Pjb(TXb.ilb,[_Yb,vZb],[13,6],15,[this.d,this.d],2);e=Rjb(TXb.ilb,vZb,6,this.d,15,1);Q=Rjb(TXb.ilb,vZb,6,this.c,15,1);D=$wnd.Math.min(this.c-1,this.d);F=$wnd.Math.max(0,$wnd.Math.min(this.d-2,this.c));for(v=0;v<$wnd.Math.max(D,F);v++){if(v<D){this.e[v]=0;for(l=v;l<this.c;l++){this.e[v]=YXb.Oc(this.e[v],a[l][v]);}if(this.e[v]!=0){a[v][v]<0&&(this.e[v]=-this.e[v]);for(k=v;k<this.c;k++){a[k][v]/=this.e[v];}a[v][v]+=1;}this.e[v]=-this.e[v];}for(q=v+1;q<this.d;q++){if(v<D&this.e[v]!=0){P=0;for(l=v;l<this.c;l++){P+=a[l][v]*a[l][q];}P=-P/a[v][v];for(k=v;k<this.c;k++){a[k][q]+=P*a[k][v];}}e[q]=a[v][q];}if(true&v<D){for(k=v;k<this.c;k++){this.a[k][v]=a[k][v];}}if(v<F){e[v]=0;for(l=v+1;l<this.d;l++){e[v]=YXb.Oc(e[v],e[l]);}if(e[v]!=0){e[v+1]<0&&(e[v]=-e[v]);for(m=v+1;m<this.d;m++){e[m]/=e[v];}e[v+1]+=1;}e[v]=-e[v];if(v+1<this.c&e[v]!=0){for(m=v+1;m<this.c;m++){Q[m]=0;}for(r=v+1;r<this.d;r++){for(n=v+1;n<this.c;n++){Q[n]+=e[r]*a[n][r];}}for(s=v+1;s<this.d;s++){P=-e[s]/e[v+1];for(n=v+1;n<this.c;n++){a[n][s]+=P*Q[n];}}}for(k=v+1;k<this.d;k++){this.b[k][v]=e[k];}}}H=$wnd.Math.min(this.d,this.c+1);D<this.d&&(this.e[D]=a[D][D]);this.c<H&&(this.e[H-1]=0);F+1<H&&(e[F]=a[F][H-1]);e[H-1]=0;for(t=D;t<G;t++){for(k=0;k<this.c;k++){this.a[k][t]=0;}this.a[t][t]=1;}for(w=D-1;w>=0;w--){if(this.e[w]!=0){for(p=w+1;p<G;p++){P=0;for(l=w;l<this.c;l++){P+=this.a[l][w]*this.a[l][p];}P=-P/this.a[w][w];for(m=w;m<this.c;m++){this.a[m][p]+=P*this.a[m][w];}}for(n=w;n<this.c;n++){this.a[n][w]=-this.a[n][w];}this.a[w][w]=1+this.a[w][w];for(k=0;k<w-1;k++){this.a[k][w]=0;}}else {for(k=0;k<this.c;k++){this.a[k][w]=0;}this.a[w][w]=1;}}for(A=this.d-1;A>=0;A--){if(A<F&e[A]!=0){for(p=A+1;p<G;p++){P=0;for(l=A+1;l<this.d;l++){P+=this.b[l][A]*this.b[l][p];}P=-P/this.b[A+1][A];for(m=A+1;m<this.d;m++){this.b[m][p]+=P*this.b[m][A];}}}for(k=0;k<this.d;k++){this.b[k][A]=0;}this.b[A][A]=1;}I=H-1;h=$wnd.Math.pow(2,-52);while(H>0){for(u=H-2;u>=-1;u--){if(u==-1){break;}if($wnd.Math.abs(e[u])<=h*($wnd.Math.abs(this.e[u])+$wnd.Math.abs(this.e[u+1]))){e[u]=0;break;}}if(u==H-2){B=4;}else {for(C=H-1;C>=u;C--){if(C==u){break;}P=(C!=H?$wnd.Math.abs(e[C]):0)+(C!=u+1?$wnd.Math.abs(e[C-1]):0);if($wnd.Math.abs(this.e[C])<=h*P){this.e[C]=0;break;}}if(C==u){B=3;}else if(C==H-1){B=1;}else {B=2;u=C;}}++u;switch(B){case 1:{i=e[H-2];e[H-2]=0;for(p=H-2;p>=u;p--){P=YXb.Oc(this.e[p],i);d=this.e[p]/P;M=i/P;this.e[p]=P;if(p!=u){i=-M*e[p-1];e[p-1]=d*e[p-1];}for(k=0;k<this.d;k++){P=d*this.b[k][p]+M*this.b[k][H-1];this.b[k][H-1]=-M*this.b[k][p]+d*this.b[k][H-1];this.b[k][p]=P;}}}break;case 2:{i=e[u-1];e[u-1]=0;for(p=u;p<H;p++){P=YXb.Oc(this.e[p],i);d=this.e[p]/P;M=i/P;this.e[p]=P;i=-M*e[p];e[p]=d*e[p];for(k=0;k<this.c;k++){P=d*this.a[k][p]+M*this.a[k][u-1];this.a[k][u-1]=-M*this.a[k][p]+d*this.a[k][u-1];this.a[k][p]=P;}}}break;case 3:{J=$wnd.Math.max($wnd.Math.max($wnd.Math.max($wnd.Math.max($wnd.Math.abs(this.e[H-1]),$wnd.Math.abs(this.e[H-2])),$wnd.Math.abs(e[H-2])),$wnd.Math.abs(this.e[u])),$wnd.Math.abs(e[u]));N=this.e[H-1]/J;O=this.e[H-2]/J;g=e[H-2]/J;L=this.e[u]/J;f=e[u]/J;b=((O+N)*(O-N)+g*g)/2;c=N*g*(N*g);K=0;if(b!=0|c!=0){K=$wnd.Math.sqrt(b*b+c);b<0&&(K=-K);K=c/(b+K);}i=(L+N)*(L-N)+K;j=L*f;for(p=u;p<H-1;p++){P=YXb.Oc(i,j);d=i/P;M=j/P;p!=u&&(e[p-1]=P);i=d*this.e[p]+M*e[p];e[p]=d*e[p]-M*this.e[p];j=M*this.e[p+1];this.e[p+1]=d*this.e[p+1];for(l=0;l<this.d;l++){P=d*this.b[l][p]+M*this.b[l][p+1];this.b[l][p+1]=-M*this.b[l][p]+d*this.b[l][p+1];this.b[l][p]=P;}P=YXb.Oc(i,j);d=i/P;M=j/P;this.e[p]=P;i=d*e[p]+M*this.e[p+1];this.e[p+1]=-M*e[p]+d*this.e[p+1];j=M*e[p+1];e[p+1]=d*e[p+1];if(p<this.c-1){for(k=0;k<this.c;k++){P=d*this.a[k][p]+M*this.a[k][p+1];this.a[k][p+1]=-M*this.a[k][p]+d*this.a[k][p+1];this.a[k][p]=P;}}}e[H-2]=i;}break;case 4:{if(this.e[u]<=0){this.e[u]=this.e[u]<0?-this.e[u]:0;for(k=0;k<=I;k++){this.b[k][u]=-this.b[k][u];}}while(u<I){if(this.e[u]>=this.e[u+1]){break;}P=this.e[u];this.e[u]=this.e[u+1];this.e[u+1]=P;if(u<this.d-1){for(k=0;k<this.d;k++){P=this.b[k][u+1];this.b[k][u+1]=this.b[k][u];this.b[k][u]=P;}}if(u<this.c-1){for(k=0;k<this.c;k++){P=this.a[k][u+1];this.a[k][u+1]=this.a[k][u];this.a[k][u]=P;}}++u;}--H;}}}};YXb.Oc=function Oc(a,b){var c;if($wnd.Math.abs(a)>$wnd.Math.abs(b)){c=b/a;c=$wnd.Math.abs(a)*$wnd.Math.sqrt(1+c*c);}else if(b!=0){c=a/b;c=$wnd.Math.abs(b)*$wnd.Math.sqrt(1+c*c);}else {c=0;}return c;};wxb(231,1,wZb,YXb.Nc);_.c=0;_.d=0;TXb.mlb=UFb(231);ZXb.Qc=function Qc(){ZXb.Qc=yxb;ZXb.Pc=Zjb(Ljb(TXb.klb,1),xZb,6,15,[0,yZb,14286847,13402367,12779264,16758197,9474192,3166456,16715021,9494608,11789301,11230450,9109248,12560038,15780000,16744448,16777008,2093087,8442339,9388244,4062976,15132390,12567239,10921643,9083335,10255047,14706227,15765664,5296208,13140019,8224944,12750735,6721423,12419299,16752896,10889513,6076625,7351984,zZb,9764863,9756896,7586505,5551541,3907230,2396047,687500,27013,12632256,16767375,10909043,6717568,10380213,13924864,9699476,4366000,5707663,51456,7394559,16777159,14286791,13107143,10747847,9437127,6422471,4587463,3211207,2097095,65436,58997,54354,48952,43812,5096191,5089023,2200790,2522539,2516630,1528967,13684960,16765219,12105936,10900557,5724513,10375093,11230208,7688005,4358806,4325478,32000,7384058,47871,41471,36863,33023,27647,5528818,7888099,9064419,10565332,11739092,11739066,11734438,12389767,13041766,13369433,13697103,14221381,14680120,15073326,15400998,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13158600,1334015,56540,15075850,15132160,56540,15075850,15461355,8553170,1016335,1016335,1334015,15132160,3289770,14456450,16422400,16422400,11819700,3289770,1016335]);};ZXb.Rc=function Rc(a){a.v=new kYb.JG();};ZXb.Sc=function Sc(a){var b,c;if((a.F&32)!=0)return;c=ZXb.qu(a.K);if(c!=null){if(a.w.a==0&&a.w.b==0){b=a.Q.c*ZXb.Rk(a.K);a.v=ZXb.Od(a);ZXb.cd(a,b);ZXb.Kd(a,null,b,0);}a.yb(flb(a.A));a.K.O!=1&&ZXb.Ld(a,448);a.pb(c,a.w.a,a.w.b+AZb*a.A);}};ZXb.Tc=function Tc(a,b){return a==null?b:b==null?a:a+','+b;};ZXb.Uc=function Uc(a,b){ZXb.Xh(b,a.Q);ZXb.$h(b,a.v);ZXb.Zh(b,a.w);};ZXb.Vc=function Vc(a){var b;b=a.Q.c*ZXb.Rk(a.K);a.X=b*0.06;a.S=b*0.15;a.R=b*0.38;a.V=b*0.47;a.W=flb(b*a.I*0.6+0.5);a.U=b*0.12;a.Y=b*0.4;a.A=b*0.5+0.5;};ZXb.Wc=function Wc(a){var b,c;a=Iwb(a,BZb);for(c=0;c<(jYb.yG(),jYb.xG).length;c++)if(Swb(a,jYb.xG[c]))return jYb.wG[c];b=new UXb.kIb('R');bxb(Iwb(a,CZb),0)&&(b.a+='0',b);bxb(Iwb(a,DZb),0)&&(b.a+='3',b);bxb(Iwb(a,EZb),0)&&(b.a+='4',b);bxb(Iwb(a,FZb),0)&&(b.a+='5',b);bxb(Iwb(a,GZb),0)&&(b.a+='6',b);bxb(Iwb(a,HZb),0)&&(b.a+='7',b);bxb(Iwb(a,IZb),0)&&(b.a+='8',b);return b.a;};ZXb.Xc=function Xc(a,b,c,d){var e,f;e=new ZXb.Zd();f=new ZXb.Zd();e.a=b.a;e.c=b.c;e.b=(b.a+b.b)/2;e.d=(b.c+b.d)/2;f.a=e.b;f.c=e.d;f.b=b.b;f.d=b.d;if(ZXb.Hd(a,e)){ZXb.Ld(a,a.p[c]);a.mb(e);}if(ZXb.Hd(a,f)){ZXb.Ld(a,a.p[d]);a.mb(f);}ZXb.Ld(a,a.P);};ZXb.Yc=function Yc(a,b,c,d){var e,f,g,h,i;h=(b.b-b.a)/10;i=(b.d-b.c)/10;e=new ZXb.Zd();if(ZXb.yl(a.K,ZXb.Pn(a.K,c,d))){f=-3;g=-3;}else {f=a.p[c];g=a.p[d];}ZXb.Ld(a,f);e.a=b.a;e.c=b.c;e.b=b.a+h*2;e.d=b.c+i*2;a.mb(e);e.a=b.a+h*4;e.c=b.c+i*4;e.b=b.a+h*5;e.d=b.c+i*5;a.mb(e);ZXb.Ld(a,g);e.a=b.a+h*5;e.c=b.c+i*5;e.b=b.a+h*6;e.d=b.c+i*6;a.mb(e);e.a=b.a+h*8;e.c=b.c+i*8;e.b=b.b;e.d=b.d;a.mb(e);ZXb.Ld(a,a.P);};ZXb.Zc=function Zc(a,b,c){a.qb(b-a.U/2,c-a.U/2,a.U);};ZXb.$c=function $c(a,b,c,d){if(ZXb.yl(a.K,ZXb.Pn(a.K,c,d))){ZXb.Ld(a,-3);a.mb(b);ZXb.Ld(a,a.P);}else if(a.p[c]!=a.p[d]){ZXb.Xc(a,b,c,d);}else if(a.p[c]!=0){ZXb.Ld(a,a.p[c]);a.mb(b);ZXb.Ld(a,a.P);}else {a.mb(b);}};ZXb._c=function _c(a,b,c,d,e,f,g){g.a=b.a+e;g.c=b.c+f;g.b=b.b+e;g.d=b.d+f;ZXb.$c(a,g,c,d);};ZXb.ad=function ad(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p;l=b.b-b.a;o=b.d-b.c;i=$wnd.Math.sqrt(l*l+o*o);j=2*kxb(Twb($wnd.Math.round(i/(4*a.X))));m=l/(j-1);p=o/(j-1);if(ZXb.yl(a.K,ZXb.Pn(a.K,c,d))){e=-3;f=-3;}else {e=a.p[c];f=a.p[d];}k=b.a-a.X/2;n=b.c-a.X/2;ZXb.Ld(a,e);for(h=0;h<(j/2|0);h++){a.qb(k,n,a.X);k+=m;n+=p;}ZXb.Ld(a,f);for(g=0;g<(j/2|0);g++){a.qb(k,n,a.X);k+=m;n+=p;}ZXb.Ld(a,a.P);};ZXb.bd=function bd(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r;i=(b.c-b.d)/9;n=(b.b-b.a)/9;j=b.b+i;o=b.d+n;k=b.b-i;p=b.d-n;l=(b.a+j)/2;q=(b.c+o)/2;m=(b.a+k)/2;r=(b.c+p)/2;g=new kYb.EG(3);h=new kYb.EG(4);kYb.DG(g,b.a,b.c);kYb.DG(g,l,q);kYb.DG(g,m,r);kYb.DG(h,m,r);kYb.DG(h,l,q);kYb.DG(h,j,o);kYb.DG(h,k,p);if(ZXb.yl(a.K,ZXb.Pn(a.K,c,d))){e=-3;f=-3;}else {e=a.p[c];f=a.p[d];if(a.K.O!=1){f=ZXb.fd(a,c);e==ZXb.Ak(a.K,c)&&(e=f);}}ZXb.Ld(a,e);a.ob(g);ZXb.Ld(a,f);a.ob(h);ZXb.Ld(a,a.P);};ZXb.cd=function cd(a,b){var c,d;for(d=0;d<a.Z.a.length;d++)a.v=kYb.IG(a.v,$Xb.Xi(a.Z,d));ZXb.dd(a,b);c=0.1*b;a.v.c-=c;a.v.d-=c;a.v.b+=2*c;a.v.a+=2*c;};ZXb.dd=function dd(a,b){var c,d,e,f,g,h,i;e=Rjb(TXb.Bwb,JZb,6,a.K.q,16,1);for(d=0;d<a.K.r;d++){if(ZXb.wl(a.K,d)){e[ZXb.Vk(a.K,0,d)]=true;e[ZXb.Vk(a.K,1,d)]=true;}}g=new kYb.JG();for(c=0;c<a.K.q;c++){f=bxb(Iwb(ZXb.Lk(a.K,c),KZb),0)?b*0.47:e[c]?b*0.38:0;if(f!=0){h=ZXb.bi(a.Q,ZXb.Nk(a.K,c));i=ZXb.ci(a.Q,ZXb.Ok(a.K,c));kYb.HG(g,h-f,i-f,f*2,f*2);a.v=kYb.IG(a.v,g);}}};ZXb.ed=function ed(a,b){var c;c=a.L!=0?a.L:a.C!=0?a.C:-1;return xYb.n6(b,c);};ZXb.fd=function fd(a,b){var c,d;if((a.F&4224)!=0)return a.p[b];d=ZXb.gd(a,b);if(d==-1){c=ZXb.xn(a.K,b);if(c!=-1){b=c;d=ZXb.gd(a,b);}}if(d==-1)return a.p[b];switch(d&255){case 1:return 384;case 2:return 64;default:return 448;}};ZXb.gd=function gd(a,b){var c,d,e;e=-1;d=-1;if((a.F&128)!=0)return e;if(ZXb.ul(a.K,b)){e=ZXb.Ek(a.K,b);d=ZXb.Dk(a.K,b);}c=ZXb.zn(a.K,b);if(c!=-1){e=ZXb.$k(a.K,c);d=ZXb.Zk(a.K,c);}e!=-1&&e!=0&&(e|=d<<8);return e;};ZXb.hd=function hd(a){var b,c,d,e;a.wb(2*a.R);e=new ZXb.Zd();for(d=0;d<a.K.r;d++){b=ZXb.Vk(a.K,0,d);c=ZXb.Vk(a.K,1,d);if(ZXb.wl(a.K,d)){e.a=ZXb.bi(a.Q,ZXb.Nk(a.K,b));e.c=ZXb.ci(a.Q,ZXb.Ok(a.K,b));e.b=ZXb.bi(a.Q,ZXb.Nk(a.K,c));e.d=ZXb.ci(a.Q,ZXb.Ok(a.K,c));ZXb.Ld(a,-2);a.mb(e);}}};ZXb.jd=function jd(a){var b,c,d,e,f,g;if(a.K.K){g=a.V;ZXb.Ld(a,-7);for(b=0;b<a.K.f;b++)bxb(Iwb(ZXb.Lk(a.K,b),KZb),0)&&a.qb(ZXb.bi(a.Q,ZXb.Nk(a.K,b))-g,ZXb.ci(a.Q,ZXb.Ok(a.K,b))-g,2*g);a.wb(2*a.V);f=new ZXb.Zd();for(e=0;e<a.K.r;e++){c=ZXb.Vk(a.K,0,e);d=ZXb.Vk(a.K,1,e);if(bxb(Iwb(Iwb(ZXb.Lk(a.K,c),ZXb.Lk(a.K,d)),KZb),0)){f.a=ZXb.bi(a.Q,ZXb.Nk(a.K,c));f.c=ZXb.ci(a.Q,ZXb.Ok(a.K,c));f.b=ZXb.bi(a.Q,ZXb.Nk(a.K,d));f.d=ZXb.ci(a.Q,ZXb.Ok(a.K,d));a.mb(f);}}}};ZXb.kd=function kd(a){var b,c,d,e;if(a.K.K){ZXb.Ld(a,320);if((a.F&8)!=0)for(b=0;b<a.K.f;b++)bxb(Iwb(ZXb.Lk(a.K,b),-536870913),0)&&a.qb(ZXb.bi(a.Q,ZXb.Nk(a.K,b))-a.Y/2,ZXb.ci(a.Q,ZXb.Ok(a.K,b))-a.Y/2,a.Y);for(e=0;e<a.K.g;e++){if(ZXb.dl(a.K,e)!=0){c=ZXb.Vk(a.K,0,e);d=ZXb.Vk(a.K,1,e);a.qb((ZXb.bi(a.Q,ZXb.Nk(a.K,c))+ZXb.bi(a.Q,ZXb.Nk(a.K,d))-a.Y)/2,(ZXb.ci(a.Q,ZXb.Ok(a.K,c))+ZXb.ci(a.Q,ZXb.Ok(a.K,d))-a.Y)/2,a.Y);}}}};ZXb.ld=function ld(a){a.I=1;a.Q=new ZXb.di();a.Z=new $Xb.kj();a.T=new $Xb.kj();a.r=Rjb(TXb.Bwb,JZb,6,a.K.q,16,1);a.w=new kYb.AG();a.P=0;a.B=-1;ZXb.Qd(a);};ZXb.md=function md(a,b){var c;if(ZXb.Dn(a.K,b)==0)return false;for(c=0;c<ZXb.Dn(a.K,b);c++)if(!ZXb.yl(a.K,ZXb.Tn(a.K,b,c)))return false;return true;};ZXb.nd=function nd(a){var b;a.q=Rjb(TXb.Bwb,JZb,6,a.K.q,16,1);for(b=0;b<a.K.r;b++){a.q[ZXb.Vk(a.K,0,b)]=true;a.q[ZXb.Vk(a.K,1,b)]=true;}};ZXb.od=function od(a,b){var c;if(ZXb.Sn(a.K,b)!=2)return false;for(c=0;c<2;c++)if(ZXb.Un(a.K,b,c)!=2)return false;return true;};ZXb.pd=function pd(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o;m=false;e.a=0;e.b=0;d>0?f=LZb:f=MZb;o=ZXb.Uk(a.K,b,c);for(k=0;k<ZXb.Sn(a.K,b);k++){g=ZXb.Tn(a.K,b,k);h=o;ZXb.Vk(a.K,0,g)==b?l=ZXb.Vk(a.K,1,g):l=ZXb.Vk(a.K,0,g);if(l==c)continue;n=ZXb.Uk(a.K,b,l);h<n&&(h+=NZb);i=h-n;if(d>0){i<OZb&&(m=true);i>LZb&&(i=LZb);i<0.523598776&&(i=0.523598776);if(i<=f){f=i;j=a.S*$wnd.Math.tan(f-PZb)/2;e.a=-(j*$wnd.Math.sin(h));e.b=-(j*$wnd.Math.cos(h));}}else {i>=OZb&&(m=true);i<MZb&&(i=MZb);i>5.759586531&&(i=5.759586531);if(i>=f){f=i;j=a.S*$wnd.Math.tan(4.712388981-f)/2;e.a=-(j*$wnd.Math.sin(h));e.b=-(j*$wnd.Math.cos(h));}}}return m;};ZXb.qd=function qd(a,b,c,d){var e;if(b==0){c<0?d.a=a.S:d.a=-a.S;d.b=0;return;}e=$wnd.Math.atan(c/b);b<0&&(e+=OZb);d.a=-(a.S*$wnd.Math.sin(e));d.b=a.S*$wnd.Math.cos(e);};ZXb.rd=function rd(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p;e=new ZXb.Zd();i=new ZXb.Zd();k=new kYb.AG();j=new kYb.AG();g=ZXb.Vk(a.K,0,c);h=ZXb.Vk(a.K,1,c);if(d){m=b.a;b.a=b.b;b.b=m;m=b.c;b.c=b.d;b.d=m;n=g;g=h;h=n;}if(!ZXb.Hd(a,b))return;if(ZXb.Vo(a.K,c)){e.a=b.a;e.c=b.c;e.b=b.b;e.d=b.d;l=d?-ZXb.ro(a.K,c):ZXb.ro(a.K,c);l==0&&(l=1);ZXb.qd(a,b.b-b.a,b.d-b.c,k);if(l>0){i.a=b.a+k.a;i.c=b.c+k.b;i.b=b.b+k.a;i.d=b.d+k.b;if(ZXb.pd(a,g,h,1,j)||ZXb.Sn(a.K,g)>1){i.a+=j.a+k.b;i.c+=j.b-k.a;}}else {i.a=b.a-k.a;i.c=b.c-k.b;i.b=b.b-k.a;i.d=b.d-k.b;if(ZXb.pd(a,g,h,-1,j)||ZXb.Sn(a.K,g)>1){i.a+=j.a+k.b;i.c+=j.b-k.a;}}ZXb.el(a.K,c)==386&&ZXb.Gd(e,i);ZXb.Hd(a,e)&&ZXb.$c(a,e,g,h);ZXb.el(a.K,c)==64?ZXb.Hd(a,i)&&ZXb.Yc(a,i,g,h):ZXb.Hd(a,i)&&ZXb.$c(a,i,g,h);}else {ZXb.qd(a,b.b-b.a,b.d-b.c,k);o=k.a/2;p=k.b/2;f=false;e.a=b.a+o;e.c=b.c+p;e.b=b.b+o;e.d=b.d+p;if(ZXb.Sn(a.K,g)>1){if(ZXb.pd(a,g,h,1,j)){e.a+=j.a;e.c+=j.b;if(ZXb.Sn(a.K,g)==2){if(j.a!=0||j.b!=0){e.a+=k.b;e.c-=k.a;}}}else {a.o[g]=new kYb.BG(e.a,e.c);}}i.a=b.a-o;i.c=b.c-p;i.b=b.b-o;i.d=b.d-p;if(ZXb.Sn(a.K,g)>1){if(ZXb.pd(a,g,h,0,j)){i.a+=j.a;i.c+=j.b;if(ZXb.Sn(a.K,g)==2){if(j.a!=0||j.b!=0){i.a+=k.b;i.c-=k.a;}}}else {a.o[g]=new kYb.BG(i.a,i.c);f=true;}}ZXb.el(a.K,c)==386&&ZXb.Gd(e,i);if(ZXb.el(a.K,c)==64){if(f){ZXb.Yc(a,e,g,h);ZXb.$c(a,i,g,h);}else {ZXb.$c(a,e,g,h);ZXb.Yc(a,i,g,h);}}else {ZXb.$c(a,e,g,h);ZXb.$c(a,i,g,h);}}};ZXb.sd=function sd(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;k=a.P;l=a.D;if((a.F&QZb)!=0){a.P=-6;a.D=-8355712;ZXb.Ld(a,1);}a.o=Rjb(TXb.Anb,jZb,33,a.K.q,0,1);for(i=0;i<a.K.r;i++)(ZXb.el(a.K,i)==2||ZXb.el(a.K,i)==386||ZXb.el(a.K,i)==64)&&ZXb.vd(a,i);for(j=0;j<a.K.r;j++)ZXb.el(a.K,j)!=2&&ZXb.el(a.K,j)!=386&&ZXb.el(a.K,j)!=64&&ZXb.vd(a,j);if((a.F&64)==0){for(h=0;h<a.K.r;h++){if(ZXb.Yk(a.K,h)!=0){e=null;ZXb.Yk(a.K,h)==1||ZXb.Yk(a.K,h)==2?(ZXb.bl(a.K,h)==2||ZXb.$k(a.K,h)==0||b[ZXb.$k(a.K,h)][ZXb.Zk(a.K,h)]>1)&&(ZXb.Yk(a.K,h)==1?e=ZXb.bl(a.K,h)==2?'E':ZXb.Al(a.K,h)?'p':'P':e=ZXb.bl(a.K,h)==2?'Z':ZXb.Al(a.K,h)?'m':'M'):e='?';if(e!=null){a.yb((a.W*2+1)/3|0);ZXb.Ld(a,ZXb.yl(a.K,h)?-3:a.K.O==1||(a.F&RZb)!=0?a.P:448);c=ZXb.Vk(a.K,0,h);d=ZXb.Vk(a.K,1,h);n=(ZXb.bi(a.Q,ZXb.Nk(a.K,c))+ZXb.bi(a.Q,ZXb.Nk(a.K,d)))/2;o=(ZXb.ci(a.Q,ZXb.Ok(a.K,c))+ZXb.ci(a.Q,ZXb.Ok(a.K,d)))/2;f=(ZXb.bi(a.Q,ZXb.Nk(a.K,c))-ZXb.bi(a.Q,ZXb.Nk(a.K,d)))/3;g=(ZXb.ci(a.Q,ZXb.Ok(a.K,c))-ZXb.ci(a.Q,ZXb.Ok(a.K,d)))/3;ZXb.yd(a,n+g,o-f,e,true);ZXb.Ld(a,a.P);a.yb(a.W);}}}}if((a.F&4)!=0){a.yb((a.W*2+1)/3|0);ZXb.Ld(a,384);for(h=0;h<a.K.r;h++){c=ZXb.Vk(a.K,0,h);d=ZXb.Vk(a.K,1,h);m=ZXb.Mo(a.K,h)?'d':ZXb.Io(a.K,h)?'a':'';n=(ZXb.bi(a.Q,ZXb.Nk(a.K,c))+ZXb.bi(a.Q,ZXb.Nk(a.K,d)))/2;o=(ZXb.ci(a.Q,ZXb.Ok(a.K,c))+ZXb.ci(a.Q,ZXb.Ok(a.K,d)))/2;ZXb.yd(a,n,o,m+(''+h),true);}ZXb.Ld(a,a.P);a.yb(a.W);}if((a.F&QZb)!=0){a.P=k;a.D=l;}};ZXb.td=function td(a){var b,c;for(c=new $Xb.qOb(a.T);c.a<c.c.a.length;){b=$Xb.pOb(c);ZXb.Ld(a,b.a);ZXb.Zc(a,b.b,b.c);}ZXb.Ld(a,a.P);};ZXb.ud=function ud(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W;a.J||a.tb(b,ZXb.Fk(a.K,b),ZXb.bi(a.Q,ZXb.Nk(a.K,b)),ZXb.ci(a.Q,ZXb.Ok(a.K,b)));M=null;if(ZXb.zk(a.K,b)!=0){S=$wnd.Math.abs(ZXb.zk(a.K,b))==1?'':''+$wnd.Math.abs(ZXb.zk(a.K,b));M=ZXb.zk(a.K,b)<0?S+'-':S+'+';}a.s!=null&&b<a.s.length&&a.s[b]!=null&&XXb.KTb(a.s[b]).length>0&&(M=ZXb.Tc(M,a.s[b]));D=null;N=ZXb.Lk(a.K,b);if(Nwb(N,0)!=0){bxb(Iwb(N,SZb),0)&&(D=D==null?'*':D+','+'*');bxb(Iwb(N,TZb),0)&&(D=D==null?'!*':D+','+'!*');bxb(Iwb(N,UZb),0)?D=D==null?'ha':D+','+'ha':bxb(Iwb(N,2),0)?D=D==null?'a':D+','+'a':bxb(Iwb(N,4),0)&&(D=D==null?'!a':D+','+'!a');bxb(Iwb(N,RZb),0)&&(D=D==null?'s':D+','+'s');if(bxb(Iwb(N,VZb),0)){w=Iwb(N,VZb);Nwb(w,1792)==0?D=D==null?'h0':D+','+'h0':Nwb(w,1664)==0?D=D==null?'h1':D+','+'h1':Nwb(w,1408)==0?D=D==null?'h2':D+','+'h2':Nwb(w,128)==0?D=D==null?'h>0':D+','+'h>0':Nwb(w,384)==0?D=D==null?'h>1':D+','+'h>1':Nwb(w,896)==0?D=D==null?'h>2':D+','+'h>2':Nwb(w,WZb)==0?D=D==null?'h<3':D+','+'h<3':Nwb(w,1536)==0&&(D=D==null?'h<2':D+','+'h<2');}if(bxb(Iwb(N,XZb),0)){i=Iwb(N,XZb);Nwb(i,YZb)==0?D=D==null?'c0':D+','+'c0':Nwb(i,ZZb)==0?D=D==null?'c+':D+','+'c+':Nwb(i,$Zb)==0&&(D=D==null?'c-':D+','+'c-');}if(bxb(Iwb(N,_Zb),0)){L=Iwb(N,_Zb);Nwb(L,98304)==0?D=D==null?'pi0':D+','+'pi0':Nwb(L,81920)==0?D=D==null?'pi1':D+','+'pi1':Nwb(L,49152)==0?D=D==null?'pi2':D+','+'pi2':Nwb(L,QZb)==0&&(D=D==null?'pi>0':D+','+'pi>0');}if(bxb(Iwb(N,a$b),0)){K=Iwb(N,a$b);Nwb(K,b$b)==0?D=D==null?'n1':D+','+'n1':Nwb(K,c$b)==0?D=D==null?'n2':D+','+'n2':Nwb(K,d$b)==0?D=D==null?'n3':D+','+'n3':Nwb(K,e$b)==0?D=D==null?'n<3':D+','+'n<3':Nwb(K,f$b)==0?D=D==null?'n<4':D+','+'n<4':Nwb(K,g$b)==0?D=D==null?'n>1':D+','+'n>1':Nwb(K,h$b)==0?D=D==null?'n>2':D+','+'n>2':Nwb(K,i$b)==0&&(D=D==null?'n>3':D+','+'n>3');}if(bxb(Iwb(N,j$b),0)){o=Iwb(N,j$b);Nwb(o,k$b)==0?D=D==null?'e0':D+','+'e0':Nwb(o,l$b)==0?D=D==null?'e1':D+','+'e1':Nwb(o,m$b)==0?D=D==null?'e2':D+','+'e2':Nwb(o,n$b)==0?D=D==null?'e3':D+','+'e3':Nwb(o,15393162788864)==0?D=D==null?'e<2':D+','+'e<2':Nwb(o,13194139533312)==0?D=D==null?'e<3':D+','+'e<3':Nwb(o,o$b)==0?D=D==null?'e<4':D+','+'e<4':Nwb(o,p$b)==0?D=D==null?'e>0':D+','+'e>0':Nwb(o,q$b)==0?D=D==null?'e>1':D+','+'e>1':Nwb(o,r$b)==0?D=D==null?'e>2':D+','+'e>2':Nwb(o,s$b)==0?D=D==null?'e>3':D+','+'e>3':Nwb(o,4947802324992)==0?D=D==null?'e1-2':D+','+'e1-2':Nwb(o,9345848836096)==0?D=D==null?'e1-3':D+','+'e1-3':Nwb(o,10445360463872)==0&&(D=D==null?'e2-3':D+','+'e2-3');}if(bxb(Iwb(N,120),0)){O=Iwb(N,120);Nwb(O,112)==0?D=D==null?'!r':D+','+'!r':Nwb(O,8)==0?D=D==null?'r':D+','+'r':Nwb(O,96)==0?D=D==null?'rb<3':D+','+'rb<3':Nwb(O,104)==0?D=D==null?'rb2':D+','+'rb2':Nwb(O,88)==0?D=D==null?'rb3':D+','+'rb3':Nwb(O,56)==0&&(D=D==null?'rb4':D+','+'rb4');}bxb(Iwb(N,t$b),0)&&(D=D==null?'r'+lxb(fxb(Iwb(N,t$b),22)):D+','+('r'+lxb(fxb(Iwb(N,t$b),22))));bxb(Iwb(N,BZb),0)&&(D=ZXb.Tc(D,ZXb.Wc(N)));bxb(Iwb(N,u$b),0)&&(D=D==null?'f':D+','+'f');}ZXb.Jk(a.K,b)!=0&&(D=ZXb.Tc(D,''+ZXb.Jk(a.K,b)));R=0;if(ZXb.Mk(a.K,b)!=0){switch(ZXb.Mk(a.K,b)){case 16:M=M==null?'|':M+','+'|';break;case 32:R=1;break;case 48:R=2;}}l=null;if((a.F&64)==0){if(ZXb.rl(a.K,b))l='?';else if(ZXb.yk(a.K,b)!=0){if(ZXb.Ek(a.K,b)==0||c==null||c[ZXb.Ek(a.K,b)][ZXb.Dk(a.K,b)]>1){if(ZXb.Sn(a.K,b)==2){switch(ZXb.yk(a.K,b)){case 2:l=ZXb.tl(a.K,b)?'p':'P';break;case 1:l=ZXb.tl(a.K,b)?'m':'M';break;default:l='*';}}else {switch(ZXb.yk(a.K,b)){case 1:l=ZXb.tl(a.K,b)?'r':'R';break;case 2:l=ZXb.tl(a.K,b)?'s':'S';break;default:l='*';}}}}}(a.F&768)!=0&&(l=ZXb.Tc(l,''+ZXb.yu(a.K,b)));I=null;(a.F&16)!=0&&ZXb.Ik(a.K,b)!=0&&(I=''+ZXb.Ik(a.K,b));q=null;if(ZXb.wo(a.K,b)!=-1){p=ZXb.gd(a,b);p!=-1&&(q=p==0?'abs':((p&255)==1?'&':'or')+(1+(p>>8)));}A=0;(a.F&v$b)==0&&(a.K.K?bxb(Iwb(ZXb.Lk(a.K,b),w$b),0)&&(A=ZXb.fo(a.K,b)):(ZXb.Qk(a.K,b)!=6||ZXb.Jk(a.K,b)!=0||!a.q[b]||ZXb.Mk(a.K,b)!=0)&&(A=ZXb.fo(a.K,b)));H=false;f=ZXb.Bk(a.K,b);if(f!=null&&UXb.CHb(XXb.KTb(f).substr(0,1),']')){D=ZXb.Tc((XXb.FTb(1,XXb.KTb(f).length+1),XXb.KTb(f).substr(1)),D);f=null;H=true;}if(f!=null){A=0;}else if(ZXb.Gk(a.K,b)!=null){e=bxb(Iwb(ZXb.Lk(a.K,b),1),0)?'[!':'[';f=e+ZXb.Hk(a.K,b)+']';XXb.KTb(f).length>5&&(f=e+ZXb.Gk(a.K,b).length+']');bxb(Iwb(ZXb.Lk(a.K,b),w$b),0)&&(A=-1);}else if(bxb(Iwb(ZXb.Lk(a.K,b),1),0)){f='?';bxb(Iwb(ZXb.Lk(a.K,b),w$b),0)&&(A=-1);}else (ZXb.Qk(a.K,b)!=6||M!=null||D!=null||A>0||!a.q[b])&&(f=ZXb.Fk(a.K,b));G=0;!ZXb.Jl(a.K,b)&bxb(Iwb(ZXb.Lk(a.K,b),KZb),0)&&ZXb.Ld(a,-8);if(f!=null){G=a.rb(f);ZXb.yd(a,ZXb.bi(a.Q,ZXb.Nk(a.K,b)),ZXb.ci(a.Q,ZXb.Ok(a.K,b)),f,true);a.r[b]=true;}else ZXb.od(a,b)&&ZXb.xd(a,ZXb.bi(a.Q,ZXb.Nk(a.K,b)),ZXb.ci(a.Q,ZXb.Ok(a.K,b)),b);if(M!=null){a.yb((a.W*2+1)/3|0);T=ZXb.bi(a.Q,ZXb.Nk(a.K,b))+((G+a.rb(M))/2+1);V=ZXb.ci(a.Q,ZXb.Ok(a.K,b))-((a.sb()*4-4)/8|0);ZXb.yd(a,T,V,M,true);a.yb(a.W);}(a.F&2)!=0&&(D=''+b);if(D!=null){H?a.yb((a.W*5+1)/6|0):a.yb((a.W*2+1)/3|0);T=ZXb.bi(a.Q,ZXb.Nk(a.K,b))-(G+a.rb(D))/2;V=ZXb.ci(a.Q,ZXb.Ok(a.K,b))-((a.sb()*4-4)/8|0);ZXb.yd(a,T,V,D,true);a.yb(a.W);}if(l!=null){a.yb((a.W*2+1)/3|0);T=ZXb.bi(a.Q,ZXb.Nk(a.K,b))-(G+a.rb(l))/2;V=ZXb.ci(a.Q,ZXb.Ok(a.K,b))+((a.sb()*4+4)/8|0);Q=a.B;a.K.O!=1&&(a.F&RZb)==0&&ZXb.Ld(a,448);ZXb.yd(a,T,V,l,false);ZXb.Ld(a,Q);a.yb(a.W);}if(I!=null){a.yb((a.W*2+1)/3|0);T=ZXb.bi(a.Q,ZXb.Nk(a.K,b))+((G+a.rb(I))/2+1);V=ZXb.ci(a.Q,ZXb.Ok(a.K,b))+((a.sb()*4+4)/8|0);Q=a.B;ZXb.Ld(a,ZXb.vl(a.K,b)?384:448);ZXb.yd(a,T,V,I,true);ZXb.Ld(a,Q);a.yb(a.W);}if(q!=null){d=ZXb.Cd(a,b);a.yb((a.W*2+1)/3|0);T=ZXb.bi(a.Q,ZXb.Nk(a.K,b))+0.7*a.sb()*$wnd.Math.sin(d);V=ZXb.ci(a.Q,ZXb.Ok(a.K,b))+0.7*a.sb()*$wnd.Math.cos(d);Q=a.B;!a.J&&a.K.O!=1&&ZXb.Ld(a,ZXb.fd(a,b));ZXb.yd(a,T,V,q,false);ZXb.Ld(a,Q);a.yb(a.W);}if(A==0&&R==0){a.B==-8&&ZXb.Ld(a,-9);return;}u=Rjb(TXb.ilb,vZb,6,4,15,1);for(C=0;C<ZXb.En(a.K,b);C++){h=ZXb.Tn(a.K,b,C);for(F=0;F<2;F++){if(ZXb.Vk(a.K,F,h)==b){P=ZXb.Uk(a.K,ZXb.Vk(a.K,F,h),ZXb.Vk(a.K,1-F,h));if(P<x$b){u[0]-=P+PZb;u[3]+=P+OZb;}else if(P<0){u[2]+=P+PZb;u[3]-=P;}else if(P<PZb){u[1]+=P;u[2]+=PZb-P;}else {u[0]+=P-PZb;u[1]+=OZb-P;}}}}ZXb.Sn(a.K,b)==0?ZXb.Cl(a.K,b)?u[3]-=0.2:u[1]-=0.2:u[1]-=0.1;(M!=null||I!=null)&&(u[1]+=10);(D!=null||l!=null)&&(u[3]+=10);s='';if(A!=0){v=a.rb('H');t=0;r=a.sb();if(A==-1){s='n';a.yb((a.W*2+1)/3|0);t=a.rb(s);}else if(A>1){s=''+A;a.yb((a.W*2+1)/3|0);t=a.rb(s);}if(u[1]<0.6||u[3]<0.6){k=ZXb.ci(a.Q,ZXb.Ok(a.K,b));if(u[1]<=u[3]){u[1]+=10;j=ZXb.bi(a.Q,ZXb.Nk(a.K,b))+(G+v)/2;}else {u[3]+=10;j=ZXb.bi(a.Q,ZXb.Nk(a.K,b))-(G+v)/2-t;}}else {j=ZXb.bi(a.Q,ZXb.Nk(a.K,b));if(u[0]<u[2]){u[0]+=10;k=ZXb.ci(a.Q,ZXb.Ok(a.K,b))-r;}else {u[2]+=10;k=ZXb.ci(a.Q,ZXb.Ok(a.K,b))+r;}}if(t>0){T=j+(v+t)/2;V=k+((a.sb()*4+4)/8|0);ZXb.yd(a,T,V,s,true);a.yb(a.W);}ZXb.yd(a,j,k,'H',true);}g=0;if(R!=0){J=50;m=0;for(B=0;B<4;B++){n=B>1?B-2:B+2;if(u[B]<J){g=B;J=u[B];m=u[n];}else if(u[B]==J){if(u[n]>m){g=B;m=u[n];}}}switch(g){case 0:j=ZXb.bi(a.Q,ZXb.Nk(a.K,b));k=ZXb.ci(a.Q,ZXb.Ok(a.K,b))-a.U-G/2;break;case 1:j=ZXb.bi(a.Q,ZXb.Nk(a.K,b))+a.U+G/2;k=ZXb.ci(a.Q,ZXb.Ok(a.K,b));break;case 2:j=ZXb.bi(a.Q,ZXb.Nk(a.K,b));k=ZXb.ci(a.Q,ZXb.Ok(a.K,b))+a.U+G/2;break;default:j=ZXb.bi(a.Q,ZXb.Nk(a.K,b))-a.U-G/2;k=ZXb.ci(a.Q,ZXb.Ok(a.K,b));}if(R==1){$Xb.Si(a.Z,new kYb.KG(j-a.U,k-a.U,2*a.U,2*a.U));a.J||$Xb.Si(a.T,new ZXb.Yd(j,k,ZXb.md(a,b)?-3:a.p[b]));}else {switch(g){case 2:case 0:U=2*a.U;W=0;j-=a.U;break;case 1:U=0;W=2*a.U;k-=a.U;break;default:U=0;W=2*a.U;k-=a.U;}$Xb.Si(a.Z,new kYb.KG(j-a.U,k-a.U,2*a.U,2*a.U));a.J||$Xb.Si(a.T,new ZXb.Yd(j,k,ZXb.md(a,b)?-3:a.p[b]));$Xb.Si(a.Z,new kYb.KG(j+U-a.U,k+W-a.U,2*a.U,2*a.U));a.J||$Xb.Si(a.T,new ZXb.Yd(j+U,k+W,ZXb.md(a,b)?-3:a.p[b]));}}a.B==-8&&ZXb.Ld(a,-9);};ZXb.vd=function vd(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;t=new ZXb.Zd();c=new ZXb.Zd();g=new ZXb.Zd();q=new kYb.AG();p=new kYb.AG();e=ZXb.Vk(a.K,0,b);f=ZXb.Vk(a.K,1,b);a.ub(b,ZXb.bi(a.Q,ZXb.Nk(a.K,e)),ZXb.ci(a.Q,ZXb.Ok(a.K,e)),ZXb.bi(a.Q,ZXb.Nk(a.K,f)),ZXb.ci(a.Q,ZXb.Ok(a.K,f)));!ZXb.Jl(a.K,e)&&!ZXb.Jl(a.K,f)&&bxb(Iwb(dxb(ZXb.Lk(a.K,e),ZXb.Lk(a.K,f)),KZb),0)&&ZXb.Ld(a,-8);if(!a.o[e]){t.a=ZXb.bi(a.Q,ZXb.Nk(a.K,e));t.c=ZXb.ci(a.Q,ZXb.Ok(a.K,e));}else {t.a=a.o[e].a;t.c=a.o[e].b;}if(!a.o[f]){t.b=ZXb.bi(a.Q,ZXb.Nk(a.K,f));t.d=ZXb.ci(a.Q,ZXb.Ok(a.K,f));}else {t.b=a.o[f].a;t.d=a.o[f].b;}if((ZXb.dl(a.K,b)&y$b)!=0){ZXb.Hd(a,t)&&a.nb(t);ZXb.Ld(a,-9);return;}h=ZXb.el(a.K,b)==64?0:ZXb.el(a.K,b)==32?1:ZXb.bl(a.K,b);switch(h){case 1:i=ZXb.el(a.K,b);if((a.F&128)!=0&&(i==257||i==129)){s=ZXb.Vk(a.K,0,b);n=ZXb.Ek(a.K,s);if(n!=0){m=ZXb.Dk(a.K,s);l=0;for(d=0;d<a.K.f;d++)ZXb.Ek(a.K,d)==n&&ZXb.Dk(a.K,d)==m&&++l;l==1&&(i=1);}}switch(i){case 1:ZXb.Hd(a,t)&&ZXb.$c(a,t,e,f);break;case 257:ZXb.Ed(a,t,e,f);break;case 129:u=t.b-t.a;v=t.d-t.c;if(ZXb.yl(a.K,ZXb.Pn(a.K,e,f))){j=-3;k=-3;}else {j=a.p[e];k=ZXb.fd(a,e);j==ZXb.Ak(a.K,e)&&(j=k);}for(o=2;o<17;o+=2){c.a=t.a+o*u/17-o*v/128;c.c=t.c+o*v/17+o*u/128;c.b=t.a+o*u/17+o*v/128;c.d=t.c+o*v/17-o*u/128;if(ZXb.Hd(a,c)){ZXb.Ld(a,o<9?j:k);a.mb(c);ZXb.Ld(a,a.P);}}break;case 32:ZXb.Hd(a,t)&&ZXb.ad(a,t,e,f);}break;case 0:case 2:if((a.r[e]||ZXb.In(a.K,e)==2)&&(a.r[f]||ZXb.In(a.K,f)==2)&&!ZXb.Vo(a.K,b)&&h==2){if(!ZXb.Hd(a,t))break;ZXb.qd(a,t.b-t.a,t.d-t.c,q);u=q.a/2;v=q.b/2;c.a=t.a+u;c.c=t.c+v;c.b=t.b+u;c.d=t.d+v;g.a=t.a-u;g.c=t.c-v;g.b=t.b-u;g.d=t.d-v;ZXb.el(a.K,b)==386&&ZXb.Gd(c,g);ZXb.$c(a,c,e,f);h==2?ZXb.$c(a,g,e,f):ZXb.Yc(a,g,e,f);}else if((a.r[f]||ZXb.In(a.K,f)==2)&&h==2){ZXb.rd(a,t,b,false);}else if((a.r[e]||ZXb.In(a.K,e)==2)&&h==2){ZXb.rd(a,t,b,true);}else {r=ZXb.ro(a.K,b);r==0&&(r=1);c.a=t.a;c.c=t.c;c.b=t.b;c.d=t.d;ZXb.qd(a,t.b-t.a,t.d-t.c,q);if(r>0){g.a=t.a+q.a;g.c=t.c+q.b;g.b=t.b+q.a;g.d=t.d+q.b;if(ZXb.pd(a,e,f,1,p)||ZXb.Sn(a.K,e)>1){g.a+=p.a+q.b;g.c+=p.b-q.a;}if(ZXb.pd(a,f,e,-1,p)||ZXb.Sn(a.K,f)>1){g.b+=p.a-q.b;g.d+=p.b+q.a;}}else {g.a=t.a-q.a;g.c=t.c-q.b;g.b=t.b-q.a;g.d=t.d-q.b;if(ZXb.pd(a,e,f,-1,p)||ZXb.Sn(a.K,e)>1){g.a+=p.a+q.b;g.c+=p.b-q.a;}if(ZXb.pd(a,f,e,1,p)||ZXb.Sn(a.K,f)>1){g.b+=p.a-q.b;g.d+=p.b+q.a;}}ZXb.el(a.K,b)==386&&ZXb.Gd(c,g);ZXb.Hd(a,c)&&ZXb.$c(a,c,e,f);h==2?ZXb.Hd(a,g)&&ZXb.$c(a,g,e,f):ZXb.Hd(a,g)&&ZXb.Yc(a,g,e,f);}break;case 3:if(ZXb.Hd(a,t)){ZXb.$c(a,t,e,f);ZXb.qd(a,t.b-t.a,t.d-t.c,q);ZXb._c(a,t,e,f,q.a,q.b,c);ZXb._c(a,t,e,f,-q.a,-q.b,c);}break;case 4:if(ZXb.Hd(a,t)){ZXb.qd(a,t.b-t.a,t.d-t.c,q);ZXb._c(a,t,e,f,1.5*q.a,1.5*q.b,c);ZXb._c(a,t,e,f,0.5*q.a,0.5*q.b,c);ZXb._c(a,t,e,f,-0.5*q.a,-0.5*q.b,c);ZXb._c(a,t,e,f,-1.5*q.a,-1.5*q.b,c);}break;case 5:if(ZXb.Hd(a,t)){ZXb.$c(a,t,e,f);ZXb.qd(a,t.b-t.a,t.d-t.c,q);ZXb._c(a,t,e,f,2*q.a,2*q.b,c);ZXb._c(a,t,e,f,q.a,q.b,c);ZXb._c(a,t,e,f,-q.a,-q.b,c);ZXb._c(a,t,e,f,-2*q.a,-2*q.b,c);}}a.B==-8&&ZXb.Ld(a,-9);};ZXb.wd=function wd(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p;n=false;for(d=0;d<a.K.g;d++){j=null;if(ZXb.xl(a.K,d)){l=ZXb.Xk(a.K,d);k=ZXb.Wk(a.K,d);j=l==k?'['+l+']':'['+l+':'+k+']';}else (ZXb.dl(a.K,d)&z$b)!=0?j=(ZXb.dl(a.K,d)&z$b)==f$b?'a':(ZXb.dl(a.K,d)&384)==256?'r!a':'!a':(ZXb.dl(a.K,d)&384)!=0&&(j=(ZXb.dl(a.K,d)&384)==256?'r':'!r');m=(ZXb.dl(a.K,d)&h$b)>>17;m!=0&&(j=(j==null?'':j)+m);if(j!=null){b=ZXb.Vk(a.K,0,d);c=ZXb.Vk(a.K,1,d);if(!n){a.yb((a.W*2+1)/3|0);n=true;}o=(ZXb.bi(a.Q,ZXb.Nk(a.K,b))+ZXb.bi(a.Q,ZXb.Nk(a.K,c)))/2;p=(ZXb.ci(a.Q,ZXb.Ok(a.K,b))+ZXb.ci(a.Q,ZXb.Ok(a.K,c)))/2;f=ZXb.bi(a.Q,ZXb.Nk(a.K,c))-ZXb.bi(a.Q,ZXb.Nk(a.K,b));g=ZXb.ci(a.Q,ZXb.Ok(a.K,c))-ZXb.ci(a.Q,ZXb.Ok(a.K,b));e=$wnd.Math.sqrt(f*f+g*g);i=0.6*a.rb(j);h=0.55*a.sb();e!=0&&(f>0?ZXb.yd(a,o+i*g/e,p-h*f/e,j,true):ZXb.yd(a,o-i*g/e,p+h*f/e,j,true));}}n&&a.yb(a.W);};ZXb.xd=function xd(a,b,c,d){$Xb.Si(a.Z,new kYb.KG(b-a.U,c-a.U,2*a.U,2*a.U));a.J||$Xb.Si(a.T,new ZXb.Yd(b,c,ZXb.md(a,d)?-3:a.p[d]));};ZXb.yd=function yd(a,b,c,d,e){var f,g,h;if(e){f=a.rb(d);g=f/2+(a.sb()/8|0);h=a.sb()/2|0;(d=='+'||d=='-')&&(h=h*2/3);$Xb.Si(a.Z,new kYb.KG(b-g,c-h,2*g,2*h));}a.J||a.pb(d,b,c);};ZXb.zd=function zd(a){var b;b=a.a;a.a=a.b;a.b=b;b=a.c;a.c=a.d;a.d=b;};ZXb.Ad=function Ad(a,b,c){var d;d=b==0?NZb+a[0]-a[a.length-1]:a[b]-a[b-1];c>A$b&&c<B$b?d-=2*$wnd.Math.cos(c+C$b):d-=0.5*$wnd.Math.cos(c+C$b);return d;};ZXb.Bd=function Bd(a){var b;b=new kYb.JG();if(a.a<=a.b){b.c=a.a;b.b=a.b-a.a;}else {b.c=a.b;b.b=a.a-a.b;}if(a.c<=a.d){b.d=a.c;b.a=a.d-a.c;}else {b.d=a.d;b.a=a.c-a.d;}return b;};ZXb.Cd=function Cd(a,b){var c,d,e,f,g,h,i;c=Rjb(TXb.ilb,vZb,6,ZXb.Dn(a.K,b),15,1);for(e=0;e<ZXb.Dn(a.K,b);e++)c[e]=ZXb.Uk(a.K,b,ZXb.Rn(a.K,b,e));XXb.eTb(c,XXb.KTb(zxb($Xb.SOb.prototype.Zd,$Xb.SOb,[])));f=ZXb.Dd(c,0);g=ZXb.Ad(c,0,f);for(d=1;d<c.length;d++){h=ZXb.Dd(c,d);i=ZXb.Ad(c,d,h);if(g<i){g=i;f=h;}}return f;};ZXb.Dd=function Dd(a,b){var c;if(b>0)return (a[b]+a[b-1])/2;c=OZb+(a[0]+a[a.length-1])/2;return c>OZb?c-NZb:c;};ZXb.Ed=function Ed(a,b,c,d){var e,f,g,h;h=new ZXb.Zd();if(b.a==b.b&&b.c==b.d)return;h.a=b.a;h.c=b.c;h.b=b.b;h.d=b.d;g=ZXb.Bd(h);for(e=0;e<a.Z.a.length;e++){f=$Xb.Xi(a.Z,e);if(f.c>g.c+g.b||f.d>g.d+g.a||g.c>f.c+f.b||g.d>f.d+f.a)continue;if(ZXb.Fd(a,h.a,h.c,e)){if(ZXb.Fd(a,h.b,h.d,e))return;ZXb.Id(a,h,0,e);ZXb.Ed(a,h,c,d);return;}if(ZXb.Fd(a,h.b,h.d,e)){ZXb.Id(a,h,1,e);ZXb.Ed(a,h,c,d);return;}}ZXb.bd(a,h,c,d);};ZXb.Fd=function Fd(a,b,c,d){var e;if((a.F&1)!=0)return false;e=$Xb.Xi(a.Z,d);return b>e.c&&b<e.c+e.b&&c>e.d&&c<e.d+e.a;};ZXb.Gd=function Gd(a,b){var c;c=a.b;a.b=b.b;b.b=c;c=a.d;a.d=b.d;b.d=c;};ZXb.Hd=function Hd(a,b){var c,d,e,f,g,h;if(b.a==b.b&&b.c==b.d){for(g=new $Xb.qOb(a.Z);g.a<g.c.a.length;){f=$Xb.pOb(g);if(kYb.FG(f,b.a,b.c))return false;}return true;}h=ZXb.Bd(b);c=false;if(b.a>b.b){ZXb.zd(b);c=true;}for(d=0;d<a.Z.a.length;d++){f=$Xb.Xi(a.Z,d);if(f.c>h.c+h.b||f.d>h.d+h.a||h.c>f.c+f.b||h.d>f.d+f.a)continue;if(ZXb.Fd(a,b.a,b.c,d)){if(ZXb.Fd(a,b.b,b.d,d)){c&&ZXb.zd(b);return false;}ZXb.Id(a,b,0,d);e=ZXb.Hd(a,b);c&&ZXb.zd(b);return e;}if(ZXb.Fd(a,b.b,b.d,d)){ZXb.Id(a,b,1,d);e=ZXb.Hd(a,b);c&&ZXb.zd(b);return e;}}c&&ZXb.zd(b);return true;};ZXb.Id=function Id(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o;if(c==0){l=b.a;n=b.c;m=b.b;o=b.d;}else {l=b.b;n=b.d;m=b.a;o=b.c;}k=$Xb.Xi(a.Z,d);i=m>l?k.c+k.b:k.c;j=o>n?k.d+k.a:k.d;e=m-l;f=o-n;if($wnd.Math.abs(e)>$wnd.Math.abs(f)){if(n==o){g=i;h=n;}else {g=l+e*(j-n)/f;if(m>l==i>g){h=j;}else {g=i;h=n+f*(i-l)/e;}}}else {if(l==m){g=l;h=j;}else {h=n+f*(i-l)/e;if(o>n==j>h){g=i;}else {g=l+e*(j-n)/f;h=j;}}}if(c==0){b.a=g;b.c=h;}else {b.b=g;b.d=h;}};ZXb.Jd=function Jd(a){var b,c,d,e;if(a.K.q==0)return;ZXb.nu(a.K,(a.F&256)!=0?63:(a.F&512)!=0?95:31);ZXb.Vc(a);c=ZXb.su(a.K);d=false;a.p=Rjb(TXb.klb,xZb,6,a.K.q,15,1);for(b=0;b<a.K.q;b++){a.p[b]=ZXb.Ak(a.K,b);a.p[b]!=0&&(d=true);ZXb.Jl(a.K,b)&&(a.p[b]=128);ZXb.ml(a.K,b)&&(a.F&w$b)==0&&(a.p[b]=256);}ZXb.Ld(a,-10);ZXb.jd(a);ZXb.hd(a);ZXb.kd(a);ZXb.Sc(a);a.yb(a.W);a.wb(a.X);ZXb.Ld(a,a.P);ZXb.nd(a);XXb.dTb(a.T.a,0);XXb.dTb(a.Z.a,0);if((a.F&1)!=0){ZXb.sd(a,c);ZXb.td(a);ZXb.wd(a);}for(e=0;e<a.K.q;e++){if(ZXb.md(a,e)){ZXb.Ld(a,-3);ZXb.ud(a,e,c);ZXb.Ld(a,a.P);}else if(a.p[e]!=0){ZXb.Ld(a,a.p[e]);ZXb.ud(a,e,c);ZXb.Ld(a,a.P);}else if(!d&&a.K.O!=1&&ZXb.Qk(a.K,e)!=1&&ZXb.Qk(a.K,e)!=6&&(a.F&WZb)==0&&ZXb.Gk(a.K,e)==null&&ZXb.Qk(a.K,e)<ZXb.Pc.length){ZXb.Nd(a,ZXb.ed(a,ZXb.Pc[ZXb.Qk(a.K,e)]));ZXb.ud(a,e,c);ZXb.Ld(a,a.P);}else {ZXb.ud(a,e,c);}}if((a.F&1)==0){ZXb.td(a);ZXb.wd(a);ZXb.sd(a,c);}};ZXb.Kd=function Kd(a,b,c,d){var e;e=c/2;switch(d&D$b){case D$b:if(b){a.w.a=b.c+b.b/2;a.w.b=b.d+b.a-e;break;}case 0:a.w.a=a.v.c+a.v.b/2;a.w.b=a.v.d+a.v.a+e;!!b&&a.w.b>b.d+b.a-e&&(a.w.b=b.d+b.a-e);break;case E$b:if(b){a.w.a=b.c+b.b/2;a.w.b=b.d+e;break;}case F$b:a.w.a=a.v.c+a.v.b/2;a.w.b=a.v.d-e;!!b&&a.w.b<b.d+e&&(a.w.b=b.d+e);}};ZXb.Ld=function Ld(a,b){if(a.J)return;if(b==-10){a.B=-999;b=a.P;}b!=-2&&b!=-7&&a.M!=0&&(b=-4);if(b==a.B)return;if(a.B==-8&&b!=-9)return;b==-8&&(a.N=a.B);b==-9&&(b=a.N);a.B=b;switch(b){case 0:a.xb(a.D==0?G$b:a.D);break;case-6:a.xb(a.D);break;case-4:a.xb(a.M);break;case-2:a.xb(a.t);break;case-3:a.xb(a.u);break;case-7:a.xb(a.G);break;case-8:a.xb(a.H);break;case-5:a.xb(a.O);break;case 64:a.xb(-14655233);break;case 128:a.xb(H$b);break;case 256:a.xb(-4194049);break;case 192:a.xb(-16711936);break;case 320:a.xb(-24576);break;case 384:a.xb(-16744448);break;case 448:a.xb(-6291456);break;case 1:a.xb(-8355712);break;default:a.xb(G$b);}};ZXb.Md=function Md(a,b){a.F=b;};ZXb.Nd=function Nd(a,b){if(a.M!=0){if(a.B!=-4){a.B=-4;a.xb(a.M);}return;}a.B=-5;a.O=b;a.xb(b);};ZXb.Od=function Od(a){var b,c,d,e,f;e=ZXb.bi(a.Q,ZXb.Nk(a.K,0));c=ZXb.bi(a.Q,ZXb.Nk(a.K,0));f=ZXb.ci(a.Q,ZXb.Ok(a.K,0));d=ZXb.ci(a.Q,ZXb.Ok(a.K,0));for(b=0;b<a.K.q;b++){e>ZXb.bi(a.Q,ZXb.Nk(a.K,b))&&(e=ZXb.bi(a.Q,ZXb.Nk(a.K,b)));c<ZXb.bi(a.Q,ZXb.Nk(a.K,b))&&(c=ZXb.bi(a.Q,ZXb.Nk(a.K,b)));f>ZXb.ci(a.Q,ZXb.Ok(a.K,b))&&(f=ZXb.ci(a.Q,ZXb.Ok(a.K,b)));d<ZXb.ci(a.Q,ZXb.Ok(a.K,b))&&(d=ZXb.ci(a.Q,ZXb.Ok(a.K,b)));}return new kYb.KG(e,f,c-e,d-f);};ZXb.Pd=function Pd(a,b,c){var d,e;if(a.K.q==0)return null;a.v=ZXb.Od(a);d=a.Q.c*ZXb.Rk(a.K);e=new ZXb.fi(a.v,b,d,c);if(e.c==1&&e.a==0&&e.b==0){e=null;}else {ZXb.Xh(e,a.Q);ZXb.$h(e,a.v);}ZXb.Kd(a,b,d,c);return e;};ZXb.Qd=function Qd(a){var b;b=a.L!=0?a.L:a.C!=0?a.C:-1;a.t=xYb.o6(b);a.u=xYb.n6(I$b,b);a.G=-24321;a.H=-6291392;};ZXb.Rd=function Rd(a,b){var c;ZXb.Sd(a,b,nZb);if(ZXb.ai(a.Q)){return null;}else {c=a.Q;ZXb.Yh(a.Q,a.K);a.Q=new ZXb.di();return c;}};ZXb.Sd=function Sd(a,b,c){var d,e,f,g;if(a.K.q==0)return null;f=a.zb(b,c);ZXb.nu(a.K,(a.F&256)!=0?63:(a.F&512)!=0?95:31);ZXb.nd(a);XXb.dTb(a.T.a,0);XXb.dTb(a.Z.a,0);ZXb.Vc(a);a.yb(a.W);a.J=true;for(e=0;e<a.K.q;e++)ZXb.ud(a,e,null);a.J=false;d=a.Q.c*ZXb.Rk(a.K);ZXb.cd(a,d);ZXb.Kd(a,b,d,c);if(!b||kYb.GG(b,a.v))return f;g=new ZXb.fi(a.v,b,d,c);ZXb.Xh(g,a.Q);ZXb.$h(g,a.v);ZXb.Zh(g,a.w);if(!f)return g;ZXb.Xh(g,f);return f;};ZXb.Td=function Td(a,b){ZXb.Qc();ZXb.Rc(this);this.K=a;this.F=b;ZXb.ld(this);};wxb(144,1,{144:1});_.tb=function Ud(a,b,c,d){};_.ub=function Vd(a,b,c,d,e){};_.vb=function Wd(a){ZXb.Jd(this);};_.zb=function Xd(a,b){return ZXb.Pd(this,a,b);};_.t=0;_.u=0;_.A=0;_.B=0;_.C=0;_.D=0;_.F=0;_.G=0;_.H=0;_.I=0;_.J=false;_.L=0;_.M=0;_.N=0;_.O=0;_.P=0;_.R=0;_.S=0;_.U=0;_.V=0;_.W=0;_.X=0;_.Y=0;TXb.plb=UFb(144);ZXb.Yd=function Yd(a,b,c){this.b=a;this.c=b;this.a=c;};wxb(161,1,{161:1},ZXb.Yd);_.a=0;_.b=0;_.c=0;TXb.nlb=UFb(161);ZXb.Zd=function Zd(){};wxb(81,1,{},ZXb.Zd);_.a=0;_.b=0;_.c=0;_.d=0;TXb.olb=UFb(81);ZXb.$d=function $d(a){return J$b+a.Cb()+'"'+a.Bb()+K$b;};wxb(229,1,{229:1});_.lb=function _d(){var a;a=new UXb.$Hb();UXb.ZHb(a,J$b+this.Cb()+'"'+this.Bb()+K$b);return a.a;};_.d=false;TXb.qlb=UFb(229);ZXb.ae=function ae(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X;J=Rjb(TXb.Bwb,JZb,6,b.i.a.length,16,1);A=Rjb(TXb.klb,xZb,6,a.f.f,15,1);for(T=0;T<b.i.a.length;T++){J[T]=true;for(q=$Xb.Xi(b.j,T),r=0,s=q.length;r<s;++r){t=q[r];if(!a.e[t]){J[T]=false;break;}}if(J[T])for(d=$Xb.Xi(b.i,T),g=0,j=d.length;g<j;++g){c=d[g];++A[c];}}I=Rjb(TXb.Bwb,JZb,6,a.f.f,16,1);for(U=0;U<b.i.a.length;U++){V=$Xb.Xi(b.j,U).length;if(V==3||V==5||V==6||V==7){if(J[U]){for(e=$Xb.Xi(b.i,U),h=0,k=e.length;h<k;++h){c=e[h];I[c]=true;}Q=true;M=-1;N=0;for(f=$Xb.Xi(b.i,U),i=0,l=f.length;i<l;++i){c=f[i];if(V==6||A[c]>1){if(!ZXb.ee(a,c,false)){Q=false;break;}}else {S=V==5?ZXb.be(a,c,false):ZXb.ce(a,c,false);if(ZXb.ee(a,c,false)){if(N<S){N=S;M=c;}}else {if(N==10){Q=false;break;}M=c;N=20;}}}if(Q){for(d=$Xb.Xi(b.i,U),g=0,j=d.length;g<j;++g){c=d[g];if(c==M){V==5?ZXb.be(a,c,true):ZXb.ce(a,c,true);ZXb.pe(a,c);}else {ZXb.ee(a,c,true);}}}}}}w=Rjb(TXb.klb,xZb,6,a.f.f,15,1);C=Rjb(TXb.Bwb,JZb,6,a.f.f,16,1);for(p=0;p<a.f.g;p++){m=ZXb.Vk(a.f,0,p);n=ZXb.Vk(a.f,1,p);if(!I[m]&&!I[n]){if(a.e[p]){++w[m];++w[n];}if(ZXb.el(a.f,p)==32){C[m]=true;C[n]=true;}}}R=Rjb(TXb.klb,xZb,6,a.f.f,15,1);B=Rjb(TXb.klb,xZb,6,a.f.f,15,1);for(X=0;X<a.f.f;X++){if(w[X]==1){B[0]=X;v=0;D=0;while(v<=D){for(F=0;F<ZXb.Sn(a.f,B[v]);F++){if(a.e[ZXb.Tn(a.f,B[v],F)]){u=ZXb.Rn(a.f,B[v],F);if((v==0||u!=B[v-1])&&w[u]!=0){B[++D]=u;if((w[u]&1)!=0){for(L=1;L<D;L+=2)R[B[L]]=-1;D=0;}break;}}}++v;}}}o=Rjb(TXb.Bwb,JZb,6,a.f.f,16,1);for(W=0;W<a.f.f;W++){if(!o[W]&&w[W]!=0){B[0]=W;o[W]=true;v=0;D=0;while(v<=D){for(F=0;F<ZXb.Sn(a.f,B[v]);F++){if(a.e[ZXb.Tn(a.f,B[v],F)]){u=ZXb.Rn(a.f,B[v],F);if(!o[u]){B[++D]=u;o[u]=true;}}}++v;}if((D&1)==0){for(G=0;G<=D;G++)R[B[G]]==0&&(R[B[G]]=ZXb.de(a,B[G],false));K=true;for(H=0;H<=D;H++){if(R[B[H]]<=0){if(!ZXb.ee(a,B[H],false)){K=false;break;}}}if(K){P=0;O=-1;for(F=0;F<=D;F++){if(P<R[B[F]]){P=R[B[F]];O=B[F];}}if(P>0){ZXb.de(a,O,true);ZXb.pe(a,O);}}}}}};ZXb.be=function be(a,b,c){if(ZXb.Qk(a.f,b)==7){if(ZXb.Dn(a.f,b)==3)return 6;else if(ZXb.Sn(a.f,b)==2)return 4;}else if(ZXb.Qk(a.f,b)==8){return 10;}else if(ZXb.Qk(a.f,b)==15||ZXb.Qk(a.f,b)==33){if(ZXb.Sn(a.f,b)==3)return 8;}else if(ZXb.Qk(a.f,b)==16||ZXb.Qk(a.f,b)==34||ZXb.Qk(a.f,b)==52){if(ZXb.Sn(a.f,b)==2)return 12;}else if(ZXb.Qk(a.f,b)==6){c&&ZXb.cm(a.f,b,-1);return ZXb.Dn(a.f,b)!=ZXb.En(a.f,b)?2:3;}return 0;};ZXb.ce=function ce(a,b,c){if(a.a){if(ZXb.Dn(a.f,b)!=3)return 0;}else {if(ZXb.Dn(a.f,b)>3)return 0;}if(ZXb.Qk(a.f,b)==6){c&&ZXb.cm(a.f,b,1);return 2;}if(ZXb.Qk(a.f,b)==5){return 4;}return 0;};ZXb.de=function de(a,b,c){if(ZXb.zk(a.f,b)!=0)return 0;if(a.a){if(ZXb.Qk(a.f,b)==5){if(ZXb.ko(a.f,b)!=2)return 0;c&&ZXb.cm(a.f,b,1);return 1;}if(ZXb.Qk(a.f,b)==7){if(ZXb.ko(a.f,b)!=2)return 0;c&&ZXb.cm(a.f,b,-1);return ZXb.ge(a,b)?6:3;}if(ZXb.Qk(a.f,b)==8){if(ZXb.ko(a.f,b)!=1)return 0;c&&ZXb.cm(a.f,b,-1);return ZXb.ge(a,b)?7:4;}if(ZXb.Qk(a.f,b)==16){if(ZXb.ko(a.f,b)!=1)return 0;c&&ZXb.cm(a.f,b,-1);return ZXb.ge(a,b)?5:2;}if(ZXb.Qk(a.f,b)==34){if(ZXb.ko(a.f,b)!=1)return 0;c&&ZXb.cm(a.f,b,-1);return ZXb.ge(a,b)?4:1;}}else {if(ZXb.Qk(a.f,b)==5){if(ZXb.ko(a.f,b)>2)return 0;c&&ZXb.cm(a.f,b,1);return 1;}if(ZXb.Qk(a.f,b)==7){if(ZXb.ko(a.f,b)>2)return 0;c&&ZXb.cm(a.f,b,-1);return ZXb.ge(a,b)?5:3;}if(ZXb.Qk(a.f,b)==8){if(ZXb.ko(a.f,b)>1)return 0;c&&ZXb.cm(a.f,b,-1);return ZXb.ge(a,b)?7:4;}if(ZXb.Qk(a.f,b)==16){if(ZXb.ko(a.f,b)>1)return 0;c&&ZXb.cm(a.f,b,-1);return ZXb.ge(a,b)?5:2;}}return 0;};ZXb.ee=function ee(a,b,c){var d,e,f;d=ZXb.Qk(a.f,b);if(d>=5&&d<=8||d==15||d==16||d==33||d==34||d==52){f=ZXb.go(a.f,b);if(f!=0)return true;e=ZXb.zk(a.f,b);if(d==5&&e>=0){c&&ZXb.cm(a.f,b,e-1);return true;}if(d!=5&&e<=0){c&&ZXb.cm(a.f,b,e+1);return true;}}return false;};ZXb.fe=function fe(a,b,c,d){var e;for(e=0;e<ZXb.Sn(a.f,b);e++)if(d[ZXb.Tn(a.f,b,e)]==1&&ZXb.Rn(a.f,b,e)!=c)return e;return -1;};ZXb.ge=function ge(a,b){var c;for(c=0;c<ZXb.Sn(a.f,b);c++)if(ZXb.Fl(a.f,ZXb.Rn(a.f,b,c)))return true;return false;};ZXb.he=function he(a,b,c){var d;for(d=0;d<ZXb.Sn(a.f,b);d++)if(c[ZXb.Tn(a.f,b,d)]>1)return true;return false;};ZXb.ie=function ie(a,b){var c;for(c=0;c<ZXb.Sn(a.f,b);c++)if(a.e[ZXb.Tn(a.f,b,c)])return true;return false;};ZXb.je=function je(a,b,c){var d,e,f,g,h,i,j,k,l,m;ZXb.nu(a.f,1);if(b!=null){a.e=b;}else {a.e=Rjb(TXb.Bwb,JZb,6,a.f.g,16,1);for(e=0;e<a.f.g;e++){if(ZXb.el(a.f,e)==64){a.e[e]=true;ZXb.Fm(a.f,e,1);}}}a.g=0;a.d=Rjb(TXb.Bwb,JZb,6,a.f.f,16,1);for(f=0;f<a.f.g;f++){if(a.e[f]){++a.c;for(h=0;h<2;h++){if(!a.d[ZXb.Vk(a.f,h,f)]){a.d[ZXb.Vk(a.f,h,f)]=true;++a.b;}}}}if(a.c==0)return true;a.a=false;ZXb.re(a,c);a.f.K&&ZXb.le(a);m=new ZXb.gs(a.f,1);c&&ZXb.ae(a,m);ZXb.se(a,m);ZXb.oe(a,m);ZXb.qe(a);ZXb.me(a);while(ZXb.ne(a,m))ZXb.me(a);while(a.c!=0){g=false;if(!g){for(k=0;k<m.i.a.length;k++){if($Xb.Xi(m.j,k).length==6){j=true;l=$Xb.Xi(m.j,k);for(i=0;i<6;i++){if(!a.e[l[i]]){j=false;break;}}if(j){for(h=0;h<6;h+=2)ZXb.ke(a,l[h]);g=true;break;}}}}if(!g){for(d=0;d<a.f.g;d++){if(a.e[d]){ZXb.ke(a,d);ZXb.me(a);g=true;break;}}}}return a.b==a.g;};ZXb.ke=function ke(a,b){var c,d,e,f;if(ZXb.el(a.f,b)==1){ZXb.Fm(a.f,b,2);a.g+=2;}for(e=0;e<2;e++){c=ZXb.Vk(a.f,e,b);a.d[c]=false;for(f=0;f<ZXb.Sn(a.f,c);f++){d=ZXb.Tn(a.f,c,f);if(a.e[d]){a.e[d]=false;--a.c;}}}};ZXb.le=function le(a){var b,c,d,e,f,g,h,i;for(c=0;c<a.f.g;c++){if(a.e[c]){for(e=0;e<2;e++){h=ZXb.Vk(a.f,e,c);b=false;for(g=0;g<ZXb.Sn(a.f,h);g++){if(c!=ZXb.Tn(a.f,h,g)&&a.e[ZXb.Tn(a.f,h,g)]){b=true;break;}}if(!b){i=c;d=ZXb.Vk(a.f,1-e,c);while(i!=-1){a.e[i]=false;--a.c;ZXb.Fm(a.f,i,64);i=-1;h=d;for(f=0;f<ZXb.Sn(a.f,h);f++){if(a.e[ZXb.Tn(a.f,h,f)]){if(i==-1){i=ZXb.Tn(a.f,h,f);d=ZXb.Rn(a.f,h,f);}else {h=-1;i=-1;break;}}}}break;}}}}};ZXb.me=function me(a){var b,c,d,e,f,g,h;do{h=false;for(c=0;c<a.f.g;c++){if(a.e[c]){f=false;for(e=0;e<2;e++){d=ZXb.Vk(a.f,e,c);b=false;for(g=0;g<ZXb.Sn(a.f,d);g++){if(c!=ZXb.Tn(a.f,d,g)&&a.e[ZXb.Tn(a.f,d,g)]){b=true;break;}}if(!b){f=true;break;}}if(f){h=true;ZXb.ke(a,c);}}}}while(h);};ZXb.ne=function ne(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;o=Rjb(TXb.klb,xZb,6,a.f.g,15,1);for(m=0;m<b.i.a.length;m++){n=$Xb.Xi(b.j,m);l=true;for(k=0;k<n.length;k++){if(!a.e[n[k]]){l=false;break;}}if(l)for(j=0;j<n.length;j++)++o[n[j]];}i=a.c;for(f=0;f<a.f.g;f++){if(o[f]==1){for(j=0;j<2&&a.e[f];j++){c=ZXb.Vk(a.f,j,f);d=ZXb.Vk(a.f,1-j,f);if(ZXb.he(a,c,o)&&!ZXb.he(a,d,o)){while(-1!=(h=ZXb.fe(a,d,c,o))){e=ZXb.Rn(a.f,d,h);g=ZXb.Tn(a.f,d,h);if(!a.e[g])break;ZXb.ke(a,g);h=ZXb.fe(a,e,d,o);if(h==-1)break;c=e;d=ZXb.Rn(a.f,e,h);}}}}}return i!=a.c;};ZXb.oe=function oe(a,b){var c;for(c=0;c<a.f.g;c++){if(a.e[c]&&ZXb._r(b,c)){ZXb.pe(a,ZXb.Vk(a.f,0,c));ZXb.pe(a,ZXb.Vk(a.f,1,c));}}};ZXb.pe=function pe(a,b){var c,d;if(a.d[b]){a.d[b]=false;--a.b;}for(d=0;d<ZXb.Sn(a.f,b);d++){c=ZXb.Tn(a.f,b,d);if(a.e[c]){a.e[c]=false;--a.c;}}};ZXb.qe=function qe(a){var b,c,d,e,f;for(c=0;c<a.f.g;c++){if(ZXb.bl(a.f,c)==2){for(e=0;e<2;e++){b=ZXb.Vk(a.f,e,c);if(ZXb.Qk(a.f,b)<=8){for(f=0;f<ZXb.Sn(a.f,b);f++){d=ZXb.Tn(a.f,b,f);if(a.e[d]){ZXb.pe(a,b);break;}}}}}}};ZXb.re=function re(a,b){var c;for(c=0;c<a.f.f;c++)a.d[c]&&ZXb.go(a.f,c)==0&&(!b||ZXb.Qk(a.f,c)==5&&ZXb.zk(a.f,c)<0||ZXb.Qk(a.f,c)==6||ZXb.Qk(a.f,c)==14||ZXb.Cl(a.f,c)&&ZXb.zk(a.f,c)>0)&&ZXb.pe(a,c);};ZXb.se=function se(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;for(k=0;k<b.i.a.length;k++){n=$Xb.Xi(b.j,k).length;if(n==3||n==5||n==7){l=$Xb.Xi(b.i,k);for(d=0;d<n;d++){c=l[d];ZXb.ie(a,c)&&(n==5?(ZXb.Qk(a.f,c)==6&&ZXb.zk(a.f,c)==-1&&ZXb.Dn(a.f,c)==3||ZXb.Qk(a.f,c)==7&&ZXb.zk(a.f,c)==0&&ZXb.Dn(a.f,c)==3||ZXb.Qk(a.f,c)==8&&ZXb.zk(a.f,c)==0&&ZXb.Sn(a.f,c)==2||ZXb.Qk(a.f,c)==16&&ZXb.zk(a.f,c)==0&&ZXb.Sn(a.f,c)==2||ZXb.Qk(a.f,c)==34&&ZXb.zk(a.f,c)==0&&ZXb.Sn(a.f,c)==2)&&ZXb.pe(a,c):(ZXb.Qk(a.f,c)==5&&ZXb.zk(a.f,c)==0&&ZXb.Dn(a.f,c)==3||ZXb.Qk(a.f,c)==6&&ZXb.zk(a.f,c)==1)&&ZXb.pe(a,c));}}}for(j=0;j<b.i.a.length;j++){if($Xb.Xi(b.j,j).length==5){m=$Xb.Xi(b.j,j);f=true;for(e=0;e<m.length;e++){if(!a.e[m[e]]){f=false;break;}}if(f){l=$Xb.Xi(b.i,j);h=0;g=-1;for(d=0;d<m.length;d++){if(ZXb.zk(a.f,l[d])==-1&&ZXb.Qk(a.f,l[d])==6){i=ZXb.Dn(a.f,l[d])==3?3:ZXb.En(a.f,l[d])==3?2:1;if(h<i){h=i;g=l[d];}}}g!=-1&&ZXb.pe(a,g);}}}};ZXb.te=function te(a){this.f=a;};wxb(114,1,{},ZXb.te);_.a=false;_.b=0;_.c=0;_.g=0;TXb.rlb=UFb(114);ZXb.ue=function ue(a,b){var c,d;c=0;for(d=0;d<a.j[b];d++)a.n[b][d]==2&&(ZXb.Qk(a,a.i[b][d])==7||ZXb.Qk(a,a.i[b][d])==8||ZXb.Qk(a,a.i[b][d])==16)&&++c;return c;};ZXb.ve=function ve(a,b){var c,d,e,f,g,h;if(a.s[b]==0){return false;}h=true;c=a.s[b];f=a.j[b];g=0;for(d=0;d<f;d++){e=a.i[b][d];g+=a.s[e];}$wnd.Math.abs(c)<=$wnd.Math.abs(g)&&UXb.kHb(c)!=UXb.kHb(g)&&(h=false);return h;};ZXb.we=function we(a,b){var c,d,e,f,g,h,i;if(a.C[b]!=8||a.s[b]!=0||a.j[b]!=1||a.n[b][0]!=1)return false;c=a.i[b][0];if(a.C[c]==6){g=a.j[c];for(d=0;d<g;d++){e=a.i[c][d];if(e==b){continue;}if(a.C[e]!=8){continue;}f=ZXb.Pn(a,c,e);if(a.H[f]==2)return true;}}else if(a.C[c]==7){if(a.s[c]==1)return true;}else if(a.C[c]==16){h=a.j[c];i=0;for(d=0;d<h;d++){e=a.i[c][d];if(e==b)continue;if(a.C[e]!=8)continue;f=ZXb.Pn(a,c,e);a.H[f]==2&&++i;}if(i==2)return true;}else if(ZXb.xe(a,b))return true;return false;};ZXb.xe=function xe(a,b){var c,d,e,f,g;if(a.C[b]!=8)return false;if(a.j[b]!=1)return false;c=a.i[b][0];if(a.C[c]==15){g=a.j[c];for(d=0;d<g;d++){e=a.i[c][d];if(e==b)continue;if(a.C[e]!=8)continue;f=ZXb.Pn(a,c,e);if(a.H[f]==2)return true;}}return false;};ZXb.ye=function ye(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;if(a.C[b]!=7||a.s[b]!=0||a.j[b]+a.o[b]>3)return false;if(b<a.f&&ZXb.Ur(a.p,b)){if(a.o[b]!=1)return false;if(ZXb.Ln(a,b,7)!=1)return false;u=(ZXb.nu(a,7),a.p);for(s=0;s<u.i.a.length;s++){if(ZXb.Wr(u,s,b)){if($Xb.Xi(u.j,s).length==5||$Xb.Xi(u.j,s).length==6){v=$Xb.Xi(u.i,s);q=-1;for(i=0;i<v.length;i++){if(v[i]==b){q=i;break;}}e=0;r=null;p=null;if(v.length==5){r=Rjb(TXb.klb,xZb,6,2,15,1);r[0]=v[q-1<0?q+4:q-1];r[1]=v[q-4<0?q+1:q-4];p=Rjb(TXb.klb,xZb,6,2,15,1);p[0]=v[q-2<0?q+3:q-2];p[1]=v[q-3<0?q+2:q-3];}if(v.length==6){r=Rjb(TXb.klb,xZb,6,3,15,1);r[0]=v[q-1<0?q+5:q-1];r[1]=v[q-3<0?q+3:q-3];r[2]=v[q-5<0?q+1:q-5];p=Rjb(TXb.klb,xZb,6,2,15,1);p[0]=v[q-2<0?q+4:q-2];p[1]=v[q-4<0?q+2:q-4];}for(j=0;j<v.length;j++)b!=v[j]&&ZXb.Qk(a,v[j])==7&&ZXb.In(a,v[j])==1&&--e;for(k=0;k<r.length;k++){f=-1;g=-1;for(o=0;o<ZXb.Sn(a,r[k]);o++){if(!ZXb.Io(a,ZXb.Tn(a,r[k],o))){f=ZXb.Rn(a,r[k],o);g=ZXb.Tn(a,r[k],o);break;}}if(f!=-1){if(a.C[f]==7&&a.o[f]==0&&a.j[f]+a.o[f]<=3&&!ZXb.ze(a,f,false)){++e;continue;}if(a.C[f]==8&&a.j[f]==1){e+=2;continue;}if(g<a.g&&ZXb.Vr(a.p,g)){for(w=0;w<u.i.a.length;w++){if(u.d[w]&&ZXb.Wr(u,w,f)){t=$Xb.Xi(u.i,w);for(n=0;n<t.length;n++){if(ZXb.Qk(a,t[n])==7&&ZXb.In(a,t[n])==1){--e;break;}}break;}}}}}for(l=0;l<p.length;l++){f=-1;for(n=0;n<ZXb.Sn(a,p[l]);n++)ZXb.Io(a,ZXb.Tn(a,p[l],n))||(f=ZXb.Rn(a,p[l],n));ZXb.Qk(a,p[l])==6?f!=-1&&ZXb.ue(a,f)!=0&&--e:ZXb.Qk(a,p[l])==7&&ZXb.In(a,p[l])==0&&(f==-1||!(f<a.f&&ZXb.Ur(a.p,f))&&ZXb.ue(a,f)==0)&&++e;}return e>0;}break;}}return false;}if(a.o[b]>1)return false;if(a.o[b]==1){m=-1;A=0;for(i=0;i<a.j[b];i++){d=a.i[b][i];if(a.n[b][i]==2){if(a.C[d]!=6)return false;m=d;continue;}if(a.C[d]==8)return false;if(a.C[d]==7){--A;ZXb.ze(a,d,false)&&--A;continue;}d<a.f&&ZXb.Ur(a.p,d)&&--A;}if(m==-1)return false;c=0;for(j=0;j<a.j[m];j++){if(a.n[m][j]==1){d=a.i[m][j];if(ZXb.ue(a,d)!=0)return false;d<a.f&&ZXb.Ur(a.p,d)&&++c;a.C[d]==7&&!ZXb.ze(a,d,true)&&++A;(a.C[d]==8||a.C[d]==16)&&--A;}}c==2&&--A;return A>=0;}for(h=0;h<a.j[b];h++){d=a.i[b][h];if(d<a.f&&ZXb.Ur(a.p,d))return false;if(a.C[d]!=6)return false;if(ZXb.ue(a,d)!=0)return false;if(a.o[d]!=0&&ZXb.Ae(a,d))return false;}return true;};ZXb.ze=function ze(a,b,c){var d,e,f;d=false;for(f=0;f<a.j[b];f++){if(!ZXb.Io(a,a.k[b][f])&&a.n[b][f]==1){e=a.i[b][f];if(!(e<a.f&&ZXb.Ur(a.p,e))&&(a.C[e]==6&&ZXb.ue(a,e)==1||a.C[e]==16&&ZXb.ue(a,e)==2)){if(d||!c)return true;d=true;}}}return false;};ZXb.Ae=function Ae(a,b){var c,d,e;for(d=0;d<a.j[b];d++){if(a.n[b][d]!=1){c=a.i[b][d];for(e=0;e<a.j[c];e++)if(a.n[c][e]==1&&ZXb.ue(a,a.i[c][e])!=0)return true;}}return false;};ZXb.De=function De(){ZXb.De=yxb;ZXb.Be=Zjb(Ljb(TXb.Awb,1),L$b,6,15,[-1,-1,-1,0,0,1,2,3,4,5,-1,0,0,0,6,7,8,9,-1,0,0,10,10,10,10,10,10,10,10,10,10,1,11,11,12,13,-1,0,0,10,10,10,10,10,10,10,10,10,10,0,0,0,11,14,-1,0,0,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,10,10,10,10,10,10,10,10,1,1,1,1,-1,-1,-1,-1,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);ZXb.Ce=Zjb(Ljb(TXb.Awb,1),L$b,6,15,[-1,-1,-1,0,0,0,2,5,5,5,-1,0,0,0,0,9,9,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);};ZXb.Ee=function Ee(a,b,c){ZXb.De();var d,e,f,g,h,i,j,k,l,m,n,o,p,q;ZXb.nu(a,7);n=Rjb(TXb.llb,M$b,6,a.j[b],14,1);m=0;for(i=0;i<a.j[b];i++){e=a.i[b][i];if(a.C[e]==1)continue;g=0;if((c&32)!=0){f=Uwb(a.n[b][i]);c==32190?Nwb(f,3)<0&&ZXb.Mo(a,a.k[b][i])&&a.o[b]==1&&(f=0):Nwb(f,3)<0&&ZXb.Io(a,a.k[b][i])&&(f=0);g=dxb(g,exb(f,4));}if((c&128)!=0){if(ZXb.Be[a.C[e]]==-1)throw Gwb(new UXb.aA(N$b+a.C[e]));g=Hwb(g,Uwb(ZXb.Be[a.C[e]]));}else if((c&64)!=0){if(ZXb.Ce[a.C[e]]==-1)throw Gwb(new UXb.aA(N$b+a.C[e]));g=Hwb(g,Uwb(ZXb.Ce[a.C[e]]));}if((c&256)!=0){o=a.j[e]-1;o>3&&(o=3);(c&512)==0&&o>1&&(o=1);g=dxb(g,TXb.Qwb(o<<6));}(c&WZb)!=0&&(a.u[e]&8)!=0&&(g=dxb(g,256));(c&w$b)!=0&&e<a.f&&ZXb.Ur(a.p,e)&&(g=dxb(g,512));(c&QZb)!=0&&(a.u[e]&v$b)!=0&&(g=dxb(g,WZb));k=0;while(Nwb(g,n[k])<0)++k;for(l=i;l>k;l--)n[l]=n[l-1];n[k]=g;++m;}m>4&&(m=4);d=0;for(j=0;j<m;j++){d=exb(d,11);d=dxb(d,n[j]);}d=exb(d,15);if(ZXb.Be[a.C[b]]==-1)throw Gwb(new UXb.aA(N$b+a.C[b]));d=dxb(d,Uwb(ZXb.Be[a.C[b]]));if((c&2)!=0){q=!!a.p&&b<a.f?ZXb.Jr(a.p,b):0;q>9&&(q=9);q>2&&(q-=2);d=dxb(d,TXb.Qwb(q<<4));}else (c&1)!=0&&(a.u[b]&8)!=0&&(d=dxb(d,64));(c&4)!=0&&b<a.f&&ZXb.Ur(a.p,b)&&(d=dxb(d,WZb));(c&8)!=0&&(a.u[b]&RZb)!=0&&(d=dxb(d,w$b));(c&16)!=0&&(a.u[b]&v$b)!=0&&(d=dxb(d,RZb));if((c&RZb)!=0){ZXb.ve(a,b)&&(d=dxb(d,v$b));if(ZXb.ye(a,b)){for(h=0;h<a.f;h++){if(ZXb.we(a,h)){d=dxb(d,QZb);break;}}}}if((c&v$b)!=0){p=Uwb(ZXb.Ln(a,b,10));d=dxb(d,exb(p,7));}return d;};ZXb.Fe=function Fe(a,b,c,d,e,f){var g,h,i,j;i=0;for(h=0;h<a.P.f;h++)bxb(Iwb(ZXb.Lk(a.P,a.w[h]),d),0)&&++i;if(i==0)return;ZXb.Df(a,b);ZXb.yf(a,TXb.Qwb(i),c);for(g=0;g<a.P.f;g++){j=Iwb(ZXb.Lk(a.P,a.w[g]),d);if(Nwb(j,0)!=0){ZXb.yf(a,TXb.Qwb(g),c);e!=1&&ZXb.yf(a,fxb(j,f),e);}}};ZXb.Ge=function Ge(a,b,c,d,e,f){var g,h,i,j;i=0;for(h=0;h<a.P.g;h++)(ZXb.dl(a.P,a.A[h])&d)!=0&&++i;if(i==0)return;ZXb.Df(a,b);ZXb.yf(a,TXb.Qwb(i),c);for(g=0;g<a.P.g;g++){j=ZXb.dl(a.P,a.A[g])&d;if(j!=0){ZXb.yf(a,TXb.Qwb(g),c);e!=1&&ZXb.yf(a,TXb.Qwb(j>>f),e);}}};ZXb.He=function He(a){var b,c,d,e,f,g;while(true){f=Rjb(TXb.Bwb,JZb,6,a.S+1,16,1);d=-1;for(c=0;c<a.P.f;c++){if(ZXb.go(a.P,c)!=0){f[a.d[c]]&&d<a.d[c]&&(d=a.d[c]);f[a.d[c]]=true;}}if(d==-1)break;e=0;for(b=0;b<a.P.f;b++){g=0;a.d[b]==d&&(g=++e);ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],a.b,Uwb(a.d[b]));ZXb.wg(a.c[b],8,TXb.Qwb(g));}a.S=ZXb.gf(a);}};ZXb.Ie=function Ie(a){var b,c,d,e;for(c=0;c<a.P.f;c++){ZXb.zg(a.c[c],c);ZXb.wg(a.c[c],2*a.b+4,exb(Uwb(a.d[c]),a.b+4));}e=false;for(b=0;b<a.P.f;b++)e=e|ZXb.Ve(a,b,3);for(d=0;d<a.P.g;d++)e=e|ZXb.Qe(a,d,3);if(!e)return false;while(a.S<a.P.f){e=ZXb.df(a);if(!e)break;ZXb.ff(a);!!a.N&&ZXb.Pg(a.N,a.d);}return true;};ZXb.Je=function Je(a){var b,c,d,e,f;for(c=0;c<a.P.f;c++){ZXb.zg(a.c[c],c);ZXb.wg(a.c[c],a.b+1,Uwb(2*a.d[c]));}f=Rjb(TXb.klb,xZb,6,a.S+1,15,1);for(d=0;d<a.P.f;d++)++f[a.d[d]];e=1;while(f[e]==1)++e;for(b=0;b<a.P.f;b++){if(a.d[b]==e){ZXb.xg(a.c[b],1);break;}}a.S=ZXb.gf(a);};ZXb.Ke=function Ke(a,b,c){var d,e,f,g,h;if(ZXb.Qk(a.P,b)!=6&&ZXb.Qk(a.P,b)!=7)return false;e=ZXb.Rn(a.P,b,0);f=ZXb.Rn(a.P,b,1);if(ZXb.In(a.P,e)!=1||ZXb.In(a.P,f)!=1)return false;if(ZXb.Sn(a.P,e)==1||ZXb.Sn(a.P,f)==1)return false;if(ZXb.Dn(a.P,e)>3||ZXb.Dn(a.P,f)>3)return false;g=new ZXb.Kj(a.P,a.d,b,e);if(g.f&&c==1)return false;h=new ZXb.Kj(a.P,a.d,b,f);if(h.f&&c==1)return false;if(g.f&&h.f)return false;if(c==3){g.f&&g.c&&(a.U[b]=true);h.f&&h.c&&(a.U[b]=true);}d=a.hb?ZXb.Me(a,g,h):ZXb.Le(g,h);if(c==1){a.bb[b]=d;}else if(c==2){g.f&&(d==1?ZXb.xg(a.c[g.b],Uwb(a.d[e])):ZXb.xg(a.c[g.d],Uwb(a.d[e])));h.f&&(d==2?ZXb.xg(a.c[h.b],Uwb(a.d[f])):ZXb.xg(a.c[h.d],Uwb(a.d[f])));}return true;};ZXb.Le=function Le(a,b){var c,d,e;d=ZXb.Jj(a);e=ZXb.Jj(b);if(d==-1||e==-1||(d+e&1)==0)return 3;c=0;switch(d+e){case 3:case 7:c=2;break;case 5:c=1;}return c;};ZXb.Me=function Me(a,b,c){var d,e;d=Rjb(TXb.klb,xZb,6,4,15,1);d[0]=b.b;d[1]=b.a;d[2]=c.a;d[3]=c.b;e=ZXb.dk(a.P,d);if($wnd.Math.abs(e)<0.3||$wnd.Math.abs(e)>O$b)return 3;return e<0?2:1;};ZXb.Ne=function Ne(a,b,c){var d,e,f,g,h;if(!ZXb.Jo(a.P,b))return false;d=ZXb.Vk(a.P,0,b);e=ZXb.Vk(a.P,1,b);g=new ZXb.Kj(a.P,a.d,d,e);if(g.f&&c==1)return false;h=new ZXb.Kj(a.P,a.d,e,d);if(h.f&&c==1)return false;if(g.f&&h.f)return false;if(c==3){g.f&&(a.T[b]=ZXb.Tf(a,e));h.f&&(a.T[b]=ZXb.Tf(a,d));}f=a.hb?ZXb.Pe(a,g,h):ZXb.Oe(g,h);if(c==1){a.k[b]=f;}else if(c==2){g.f&&(f==2?ZXb.xg(a.c[g.b],Uwb(a.d[e])):ZXb.xg(a.c[g.d],Uwb(a.d[e])));h.f&&(f==2?ZXb.xg(a.c[h.b],Uwb(a.d[d])):ZXb.xg(a.c[h.d],Uwb(a.d[d])));}return true;};ZXb.Oe=function Oe(a,b){var c,d,e;d=ZXb.Jj(a);e=ZXb.Jj(b);if(d==-1||e==-1||(d+e&1)==0)return 3;c=0;switch(d+e){case 3:case 7:c=1;break;case 5:c=2;}return c;};ZXb.Pe=function Pe(a,b,c){var d,e;d=Rjb(TXb.klb,xZb,6,4,15,1);d[0]=b.b;d[1]=b.a;d[2]=c.a;d[3]=c.b;e=ZXb.dk(a.P,d);if($wnd.Math.abs(e)<0.3||$wnd.Math.abs(e)>O$b)return 3;return e<0?1:2;};ZXb.Qe=function Qe(a,b,c){var d,e,f,g,h;if(a.k[b]!=0)return false;if(ZXb.bl(a.P,b)==1)return ZXb.Ne(a,b,c);if(ZXb.bl(a.P,b)!=2)return false;if(ZXb.Io(a.P,b))return false;e=ZXb.Vk(a.P,0,b);f=ZXb.Vk(a.P,1,b);if(ZXb.Sn(a.P,e)==1||ZXb.Sn(a.P,f)==1)return false;if(ZXb.Sn(a.P,e)>3||ZXb.Sn(a.P,f)>3)return false;if(ZXb.In(a.P,e)==2||ZXb.In(a.P,f)==2)return false;g=new ZXb.Kj(a.P,a.d,f,e);if(g.f&&c==1)return false;h=new ZXb.Kj(a.P,a.d,e,f);if(h.f&&c==1)return false;if(g.f&&h.f)return false;if(c==3){g.f&&g.c&&(a.T[b]=true);h.f&&h.c&&(a.T[b]=true);}d=ZXb.Bl(a.P,b)?3:a.hb?ZXb.Se(a,g,h):ZXb.Re(g,h);if(c==1){a.k[b]=d;}else if(c==2){g.f&&(d==1?ZXb.xg(a.c[g.b],Uwb(a.d[e])):d==2&&ZXb.xg(a.c[g.d],Uwb(a.d[e])));h.f&&(d==1?ZXb.xg(a.c[h.b],Uwb(a.d[f])):d==2&&ZXb.xg(a.c[h.d],Uwb(a.d[f])));}return true;};ZXb.Re=function Re(a,b){if(ZXb.Jj(a)==-1||ZXb.Jj(b)==-1)return 3;if(((ZXb.Jj(a)|ZXb.Jj(b))&1)!=0)return 3;return ZXb.Jj(a)==ZXb.Jj(b)?1:2;};ZXb.Se=function Se(a,b,c){var d,e,f,g,h,i,j;f=Rjb(TXb.ilb,vZb,6,3,15,1);f[0]=ZXb.Nk(a.P,c.a)-ZXb.Nk(a.P,b.a);f[1]=ZXb.Ok(a.P,c.a)-ZXb.Ok(a.P,b.a);f[2]=ZXb.Pk(a.P,c.a)-ZXb.Pk(a.P,b.a);i=Rjb(TXb.ilb,vZb,6,3,15,1);i[0]=ZXb.Nk(a.P,b.b)-ZXb.Nk(a.P,b.a);i[1]=ZXb.Ok(a.P,b.b)-ZXb.Ok(a.P,b.a);i[2]=ZXb.Pk(a.P,b.b)-ZXb.Pk(a.P,b.a);j=Rjb(TXb.ilb,vZb,6,3,15,1);j[0]=ZXb.Nk(a.P,c.b)-ZXb.Nk(a.P,c.a);j[1]=ZXb.Ok(a.P,c.b)-ZXb.Ok(a.P,c.a);j[2]=ZXb.Pk(a.P,c.b)-ZXb.Pk(a.P,c.a);g=Rjb(TXb.ilb,vZb,6,3,15,1);g[0]=f[1]*i[2]-f[2]*i[1];g[1]=f[2]*i[0]-f[0]*i[2];g[2]=f[0]*i[1]-f[1]*i[0];h=Rjb(TXb.ilb,vZb,6,3,15,1);h[0]=f[1]*g[2]-f[2]*g[1];h[1]=f[2]*g[0]-f[0]*g[2];h[2]=f[0]*g[1]-f[1]*g[0];d=(i[0]*h[0]+i[1]*h[1]+i[2]*h[2])/($wnd.Math.sqrt(i[0]*i[0]+i[1]*i[1]+i[2]*i[2])*$wnd.Math.sqrt(h[0]*h[0]+h[1]*h[1]+h[2]*h[2]));e=(j[0]*h[0]+j[1]*h[1]+j[2]*h[2])/($wnd.Math.sqrt(j[0]*j[0]+j[1]*j[1]+j[2]*j[2])*$wnd.Math.sqrt(h[0]*h[0]+h[1]*h[1]+h[2]*h[2]));return d<0^e<0?1:2;};ZXb.Te=function Te(a,b){var c,d,e,f;c=ZXb.xk(a.P,b);d=ZXb.eo(a.P,b,false);e=ZXb.eo(a.P,b,true);f=-1;if(d!=e){c!=-1&&c>d?f=c<<24>>24:f=d<<24>>24;}else if(c!=-1){(c>e||c<e&&c>=ZXb.ko(a.P,b))&&(f=c<<24>>24);}else if(!ZXb.lp(a.P,b)&&ZXb.Wn(a.P,b)!=0){f=ZXb.ko(a.P,b);f-=ZXb.il(a.P,b,f);}ZXb.of(a,b,f);return f;};ZXb.Ue=function Ue(a){var b,c,d,e,f,g,h,i,j,k,l;d=Rjb(TXb.klb,xZb,6,a.M,15,1);for(b=0;b<a.P.f;b++){k=ZXb.Sn(a.P,b)+ZXb.ho(a.P,b);j=0;for(f=0;f<ZXb.En(a.P,b);f++){if(f<ZXb.Sn(a.P,b)||f>=ZXb.Dn(a.P,b)){l=2*a.d[ZXb.Rn(a.P,b,f)];c=ZXb.Tn(a.P,b,f);ZXb.bl(a.P,c)==2&&(ZXb.Io(a.P,c)||++l);for(h=0;h<j;h++)if(l<d[h])break;for(i=j;i>h;i--)d[i]=d[i-1];d[h]=l;++j;}}ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],a.b,Uwb(a.d[b]));for(g=k;g<a.M;g++)ZXb.wg(a.c[b],a.b+1,0);for(e=0;e<k;e++)ZXb.wg(a.c[b],a.b+1,TXb.Qwb(d[e]));}};ZXb.Ve=function Ve(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;if(a.bb[b]!=0)return false;if(ZXb.Qk(a.P,b)!=5&&ZXb.Qk(a.P,b)!=6&&ZXb.Qk(a.P,b)!=7&&ZXb.Qk(a.P,b)!=14&&ZXb.Qk(a.P,b)!=15&&ZXb.Qk(a.P,b)!=16)return false;if(ZXb.In(a.P,b)!=0){if(ZXb.Ko(a.P,b))return ZXb.Ke(a,b,c);if(ZXb.Qk(a.P,b)!=15&&ZXb.Qk(a.P,b)!=16)return false;}if(ZXb.Sn(a.P,b)<3||ZXb.Dn(a.P,b)>4)return false;if(ZXb.zk(a.P,b)>0&&ZXb.Qk(a.P,b)==6)return false;if(ZXb.Qk(a.P,b)==5&&ZXb.Dn(a.P,b)!=4)return false;if(ZXb.Qk(a.P,b)==7&&!a.Q[b])return false;n=Rjb(TXb.klb,xZb,6,4,15,1);o=Rjb(TXb.klb,xZb,6,4,15,1);j=Rjb(TXb.Bwb,JZb,6,4,16,1);for(h=0;h<ZXb.Dn(a.P,b);h++){f=-1;e=0;for(i=0;i<ZXb.Dn(a.P,b);i++){if(!j[i]){if(f<a.d[ZXb.Rn(a.P,b,i)]){f=a.d[ZXb.Rn(a.P,b,i)];e=i;}}}n[h]=e;o[h]=f;j[e]=true;}if(ZXb.Dn(a.P,b)==4&&o[0]==o[1]&&o[2]==o[3])return false;if(ZXb.Dn(a.P,b)==4&&(o[0]==o[2]||o[1]==o[3]))return false;if(ZXb.Dn(a.P,b)==3&&o[0]==o[2])return false;k=0;l=0;m=false;for(g=1;g<ZXb.Dn(a.P,b);g++){if(o[g-1]==o[g]){if(c==1||o[g]==0)return false;k=ZXb.Rn(a.P,b,n[g-1]);l=ZXb.Rn(a.P,b,n[g]);c==3&&ZXb.Vo(a.P,ZXb.Tn(a.P,b,n[g]))&&(a.U[b]=true);m=true;}}if(c!=1&&!m)return false;d=a.hb?ZXb.Xe(a,b,n):ZXb.We(a,b,n);c==1?a.bb[b]=d:c==2&&(d==1?ZXb.xg(a.c[k],Uwb(a.d[b])):d==2&&ZXb.xg(a.c[l],Uwb(a.d[b])));return true;};ZXb.We=function We(a,b,c){var d,e,f,g,h,i,j,k,l,m;m=Zjb(Ljb(TXb.klb,2),P$b,8,0,[Zjb(Ljb(TXb.klb,1),xZb,6,15,[2,1,2,1]),Zjb(Ljb(TXb.klb,1),xZb,6,15,[1,2,2,1]),Zjb(Ljb(TXb.klb,1),xZb,6,15,[1,1,2,2]),Zjb(Ljb(TXb.klb,1),xZb,6,15,[2,1,1,2]),Zjb(Ljb(TXb.klb,1),xZb,6,15,[2,2,1,1]),Zjb(Ljb(TXb.klb,1),xZb,6,15,[1,2,1,2])]);d=Rjb(TXb.ilb,vZb,6,ZXb.Dn(a.P,b),15,1);for(g=0;g<ZXb.Dn(a.P,b);g++)d[g]=ZXb.Uk(a.P,ZXb.Rn(a.P,b,c[g]),b);j=ZXb.Yn(a.P,b,c,d,null)<<24>>24;if(j!=3)return j;k=0;l=0;for(h=0;h<ZXb.Dn(a.P,b);h++){e=ZXb.Tn(a.P,b,c[h]);if(ZXb.Vk(a.P,0,e)==b){if(ZXb.el(a.P,e)==129){l!=0&&ZXb.Om(a.P,b);k=h;l=1;}if(ZXb.el(a.P,e)==257){l!=0&&ZXb.Om(a.P,b);k=h;l=2;}}}if(l==0)return 3;for(f=1;f<ZXb.Dn(a.P,b);f++)d[f]<d[0]&&(d[f]+=NZb);if(ZXb.Dn(a.P,b)==3){switch(k){case 0:(d[1]<d[2]&&d[2]-d[1]<OZb||d[1]>d[2]&&d[1]-d[2]>OZb)&&(l=3-l);break;case 1:d[2]-d[0]>OZb&&(l=3-l);break;case 2:d[1]-d[0]<OZb&&(l=3-l);}return l==1?2:1;}i=0;d[1]<=d[2]&&d[2]<=d[3]?i=0:d[1]<=d[3]&&d[3]<=d[2]?i=1:d[2]<=d[1]&&d[1]<=d[3]?i=2:d[2]<=d[3]&&d[3]<=d[1]?i=3:d[3]<=d[1]&&d[1]<=d[2]?i=4:d[3]<=d[2]&&d[2]<=d[1]&&(i=5);return m[i][k]==l?2:1;};ZXb.Xe=function Xe(a,b,c){var d,e,f,g,h,i;d=Rjb(TXb.klb,xZb,6,4,15,1);for(h=0;h<ZXb.Dn(a.P,b);h++)d[h]=ZXb.Rn(a.P,b,c[h]);ZXb.Dn(a.P,b)==3&&(d[3]=b);e=Pjb(TXb.ilb,[_Yb,vZb],[13,6],15,[3,3],2);for(g=0;g<3;g++){e[g][0]=ZXb.Nk(a.P,d[g+1])-ZXb.Nk(a.P,d[0]);e[g][1]=ZXb.Ok(a.P,d[g+1])-ZXb.Ok(a.P,d[0]);e[g][2]=ZXb.Pk(a.P,d[g+1])-ZXb.Pk(a.P,d[0]);}i=Rjb(TXb.ilb,vZb,6,3,15,1);i[0]=e[0][1]*e[1][2]-e[0][2]*e[1][1];i[1]=e[0][2]*e[1][0]-e[0][0]*e[1][2];i[2]=e[0][0]*e[1][1]-e[0][1]*e[1][0];f=(e[2][0]*i[0]+e[2][1]*i[1]+e[2][2]*i[2])/($wnd.Math.sqrt(e[2][0]*e[2][0]+e[2][1]*e[2][1]+e[2][2]*e[2][2])*$wnd.Math.sqrt(i[0]*i[0]+i[1]*i[1]+i[2]*i[2]));return f>0?1:2;};ZXb.Ye=function Ye(a){var b,c;b=0;$Xb.OOb(a.c);for(c=0;c<a.c.length;c++){(c==0||ZXb.yg(a.c[c],a.c[c-1])!=0)&&++b;a.d[a.c[c].a]=b;}return b;};ZXb.Ze=function Ze(a){var b,c,d,e,f,g,h,i,j,k,l,m;if(a.v)return;a.v=new $Xb.kj();k=0;l=Rjb(TXb.klb,xZb,6,a.P.f,15,1);g=Rjb(TXb.klb,xZb,6,a.P.f,15,1);i=Rjb(TXb.klb,xZb,6,a.P.g,15,1);for(b=0;b<a.P.f;b++){if(l[b]==0&&(ZXb.Uo(a.P,b)||ZXb.In(a.P,b)==1)){g[0]=b;h=1;j=0;l[b]=++k;c=Rjb(TXb.Bwb,JZb,6,a.P.g,16,1);for(f=0;f<h;f++){for(m=0;m<ZXb.Sn(a.P,g[f]);m++){e=ZXb.Tn(a.P,g[f],m);if(ZXb.Vo(a.P,e)||ZXb.bl(a.P,e)==2||ZXb.Jo(a.P,e)){d=ZXb.Rn(a.P,g[f],m);if(!c[e]){i[j++]=e;c[e]=true;}if(l[d]==0){g[h++]=d;l[d]=k;}}}}$Xb.Si(a.v,new ZXb.Fg(g,h,i,j));}}};ZXb.$e=function $e(a){var b;a.Q=Rjb(TXb.Bwb,JZb,6,a.P.f,16,1);for(b=0;b<a.P.f;b++){if(ZXb.Qk(a.P,b)==7){if(ZXb.Sn(a.P,b)==4){a.Q[b]=true;continue;}if(ZXb.Sn(a.P,b)==3){if(ZXb.Mn(a.P,b)==3){a.Q[b]=true;continue;}if(ZXb.zk(a.P,b)==1){a.Q[b]=true;continue;}if(ZXb.Oo(a.P,b,true))continue;if((a.O&32)!=0){a.Q[b]=true;continue;}if(ZXb.To(a.P,b)){a.Q[b]=true;continue;}}}}};ZXb._e=function _e(a,b){var c,d,e,f;e=false;for(d=0;d<a.P.g;d++)if(ZXb.Qe(a,d,1)){a.o[d]=a.J;b&&ZXb.pf(a,d);e=true;}f=false;for(c=0;c<a.P.f;c++)if(ZXb.Ve(a,c,1)){a.gb[c]=a.J;b&&ZXb.qf(a,c);f=true;}f&&(a.J=!a.J);return e||f;};ZXb.af=function af(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B;s=Rjb(TXb.Bwb,JZb,6,a.P.f,16,1);t=Rjb(TXb.Bwb,JZb,6,a.P.g,16,1);b=0;v=false;if((a.O&128)!=0){a.W=Rjb(TXb.klb,xZb,6,a.P.f,15,1);a.V=Rjb(TXb.klb,xZb,6,a.P.g,15,1);}for(d=0;d<a.P.f;d++){if(a.U[d]){if(!a.db[d]){if(ZXb.Ve(a,d,1)){a.db[d]=true;s[d]=true;++b;}}}}for(f=0;f<a.P.g;f++){if(a.T[f]){if(!a.n[f]){if(ZXb.Qe(a,f,1)){a.n[f]=true;t[f]=true;++b;}}}}if(b==1){for(c=0;c<a.P.f;c++){if(s[c]){a.bb[c]=0;break;}}for(e=0;e<a.P.g;e++){if(t[e]){a.k[e]=0;break;}}}else if(b>1){ZXb.Ze(a);a.R=0;for(h=new $Xb.qOb(a.v);h.a<h.c.a.length;){g=$Xb.pOb(h);u=0;w=0;k=0;j=0;l=-1;i=-1;for(o=0;o<g.a.length;o++){if(s[g.a[o]]){++u;if(a.bb[g.a[o]]==1||a.bb[g.a[o]]==2){++w;v=true;if(l<a.d[g.a[o]]){l=a.d[g.a[o]];k=g.a[o];}}}}for(p=0;p<g.b.length;p++){if(t[g.b[p]]){++u;A=a.d[ZXb.Vk(a.P,0,g.b[p])];B=a.d[ZXb.Vk(a.P,1,g.b[p])];m=A>B?(A<<16)+B:(B<<16)+A;if(a.k[g.b[p]]==1||a.k[g.b[p]]==2){++w;v=true;if(i<m){i=m;j=g.b[p];}}}}if(u==0)continue;if(u==1){for(q=0;q<g.a.length;q++)s[g.a[q]]&&(a.bb[g.a[q]]=0);for(n=0;n<g.b.length;n++)t[g.b[n]]&&(a.k[g.b[n]]=0);}else {if(w==1){for(q=0;q<g.a.length;q++)s[g.a[q]]&&(a.bb[g.a[q]]=3);for(n=0;n<g.b.length;n++)t[g.b[n]]&&(a.k[g.b[n]]=3);}else {if((a.O&128)!=0){++a.R;for(q=0;q<g.a.length;q++)s[g.a[q]]&&(a.W[g.a[q]]=a.R);for(n=0;n<g.b.length;n++)t[g.b[n]]&&(a.V[g.b[n]]=a.R);}r=false;l!=-1?a.bb[k]==2&&(r=true):a.k[j]==2&&(r=true);if(r){for(q=0;q<g.a.length;q++){if(s[g.a[q]]){switch(a.bb[g.a[q]]){case 1:a.bb[g.a[q]]=2;break;case 2:a.bb[g.a[q]]=1;}}}for(n=0;n<g.b.length;n++){if(t[g.b[n]]){switch(a.k[g.b[n]]){case 1:a.k[g.b[n]]=2;break;case 2:a.k[g.b[n]]=1;}}}}}}}}return v;};ZXb.bf=function bf(a,b){var c,d,e,f,g,h,i,j,k,l,m;f=Pjb(TXb.klb,[P$b,xZb],[8,6],15,[2,32],2);for(g=0;g<2;g++){c=Rjb(TXb.klb,P$b,8,32,0,2);m=0;for(e=0;e<32;e++){if(b[g][e]!=null){k=b[g][e].length;c[e]=Rjb(TXb.klb,xZb,6,k,15,1);for(h=0;h<k;h++)c[e][h]=a.d[b[g][e][h]];XXb.eTb(c[e],XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));++m;}}for(l=m;l>0;l--){j=0;i=null;for(d=0;d<32;d++){if(c[d]!=null){if(i==null||i.length<c[d].length){i=c[d];j=d;}else if(i.length==c[d].length){for(h=i.length-1;h>=0;h--){if(i[h]<c[d][h]){i=c[d];j=d;break;}}}}}f[g][j]=l;c[j]=null;}}return f;};ZXb.cf=function cf(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;l=false;if(a.P.K){for(j=0;j<a.P.g;j++){if(ZXb.dl(a.P,j)!=0){l=true;break;}}}a.M=2;for(c=0;c<a.P.f;c++)a.M=$wnd.Math.max(a.M,ZXb.Sn(a.P,c)+ZXb.ho(a.P,c));i=$wnd.Math.max(2,l?(62+a.b+a.M*(a.b+23))/63|0:(62+a.b+a.M*(a.b+5))/63|0);a.d=Rjb(TXb.klb,xZb,6,a.P.q,15,1);a.c=Rjb(TXb.wlb,Q$b,160,a.P.f,0,1);for(d=0;d<a.P.f;d++)a.c[d]=new ZXb.Ag(i);h=false;for(e=0;e<a.P.f;e++){ZXb.zg(a.c[e],e);bxb(Iwb(ZXb.Lk(a.P,e),1),0)||ZXb.Gk(a.P,e)!=null?ZXb.wg(a.c[e],8,6):ZXb.wg(a.c[e],8,Uwb(ZXb.Qk(a.P,e)));ZXb.wg(a.c[e],8,Uwb(ZXb.Jk(a.P,e)));ZXb.wg(a.c[e],2,Uwb(ZXb.In(a.P,e)));ZXb.wg(a.c[e],4,Uwb(ZXb.Sn(a.P,e)+ZXb.ho(a.P,e)));bxb(Iwb(ZXb.Lk(a.P,e),1),0)?ZXb.wg(a.c[e],4,8):ZXb.wg(a.c[e],4,Uwb(8+ZXb.zk(a.P,e)));ZXb.wg(a.c[e],5,Uwb($wnd.Math.min(31,ZXb.Mn(a.P,e))));ZXb.wg(a.c[e],4,Uwb(ZXb.Te(a,e)+1));ZXb.wg(a.c[e],2,Uwb(ZXb.Mk(a.P,e)>>4));if(a.P.K){ZXb.wg(a.c[e],46,ZXb.Lk(a.P,e));ZXb.Gk(a.P,e)!=null&&(h=true);}}a.S=ZXb.gf(a);if(a.S<a.P.f){for(b=0;b<a.P.f;b++){ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],a.b,Uwb(a.d[b]));m=Rjb(TXb.klb,xZb,6,ZXb.Sn(a.P,b),15,1);for(o=0;o<ZXb.Sn(a.P,b);o++){m[o]=a.d[ZXb.Rn(a.P,b,o)]<<5;m[o]|=$wnd.Math.min(31,ZXb.Qn(a.P,ZXb.Tn(a.P,b,o)));}XXb.eTb(m,XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));for(p=a.M;p>m.length;p--)ZXb.wg(a.c[b],a.b+5,0);for(n=m.length-1;n>=0;n--)ZXb.wg(a.c[b],a.b+5,TXb.Qwb(m[n]));}a.S=ZXb.gf(a);}if(h&&a.S<a.P.f){for(b=0;b<a.P.f;b++){ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],a.b,Uwb(a.d[b]));g=ZXb.Gk(a.P,b);s=g==null?0:$wnd.Math.min(12,g.length);for(o=12;o>s;o--)ZXb.wg(a.c[b],8,0);for(n=s-1;n>=0;n--)ZXb.wg(a.c[b],8,TXb.Qwb(g[n]));}a.S=ZXb.gf(a);}if(l&&a.S<a.P.f){for(b=0;b<a.P.f;b++){ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],a.b,Uwb(a.d[b]));k=Rjb(TXb.llb,M$b,6,ZXb.Sn(a.P,b)+ZXb.ho(a.P,b),14,1);q=0;for(o=0;o<ZXb.En(a.P,b);o++){if(o<ZXb.Sn(a.P,b)||o>=ZXb.Dn(a.P,b)){k[q]=Uwb(a.d[ZXb.Rn(a.P,b,o)]);k[q]=exb(k[q],23);k[q]=dxb(k[q],Uwb(ZXb.dl(a.P,ZXb.Tn(a.P,b,o))));++q;}}XXb.eTb(k,XXb.KTb(zxb($Xb.VOb.prototype.$d,$Xb.VOb,[])));for(p=a.M;p>k.length;p--)ZXb.wg(a.c[b],a.b+23,0);for(n=k.length-1;n>=0;n--)ZXb.wg(a.c[b],a.b+23,k[n]);}a.S=ZXb.gf(a);}if((a.O&8)!=0&&a.S<a.P.f){r=new ZXb.ku();for(f=0;f<a.P.f;f++)ZXb.Bk(a.P,f)!=null&&ZXb.iu(r,ZXb.Bk(a.P,f));for(b=0;b<a.P.f;b++){t=ZXb.Bk(a.P,b)==null?0:1+ZXb.ju(r,ZXb.Bk(a.P,b));ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],a.b,Uwb(a.d[b]));ZXb.wg(a.c[b],a.b,TXb.Qwb(t));}a.S=ZXb.gf(a);}if((a.O&16)!=0&&a.S<a.P.f){for(b=0;b<a.P.f;b++){ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],a.b,Uwb(a.d[b]));ZXb.wg(a.c[b],1,Uwb(ZXb.Jl(a.P,b)?1:0));}a.S=ZXb.gf(a);}(a.O&512)!=0&&a.P.K&&ZXb.He(a);};ZXb.df=function df(a){var b,c,d,e,f,g,h,i,j;for(c=0;c<a.P.f;c++){ZXb.zg(a.c[c],c);ZXb.wg(a.c[c],2*a.b+4,exb(Uwb(a.d[c]),a.b+4));}for(i=1;i<=a.S;i++){e=false;for(d=0;d<a.P.f;d++)a.d[d]==i&&(e=e|ZXb.Ve(a,d,2));if(e){h=a.S;a.S=ZXb.gf(a);if(a.S!=h)return true;for(b=0;b<a.P.f;b++){ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],2*a.b+4,exb(Uwb(a.d[b]),a.b+4));}}}j=Rjb(TXb.xlb,Q$b,211,a.P.g,0,1);for(g=0;g<j.length;g++)j[g]=new ZXb.Dg(a.d[ZXb.Vk(a.P,0,g)],a.d[ZXb.Vk(a.P,1,g)],g);$Xb.MOb(j,0,j.length,null);for(f=0;f<j.length;f++){if(ZXb.Qe(a,j[f].a,2)){while(f+1<j.length&&ZXb.Cg(j[f],j[f+1])==0)ZXb.Qe(a,j[++f].a,2);h=a.S;a.S=ZXb.gf(a);if(a.S!=h)return true;for(b=0;b<a.P.f;b++){ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],2*a.b+4,exb(Uwb(a.d[b]),a.b+4));}}}return false;};ZXb.ef=function ef(a){var b,c,d,e,f,g,h,i,j,k;f=0;for(c=0;c<a.P.f;c++)a._[c]!=0&&(a._[c]!=2||(a.O&256)==0)&&++f;if(f==0)return;k=Rjb(TXb.klb,xZb,6,f,15,1);f=0;for(d=0;d<a.P.f;d++){if(a._[d]!=0&&(a._[d]!=2||(a.O&256)==0)){k[f]=a._[d]<<29|a.$[d]<<24|a.d[d]<<12|d;++f;}}XXb.eTb(k,XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));g=0;j=0;h=k[0]&G$b;while(true){++j;if(j==k.length||h!=(k[j]&G$b)){e=Rjb(TXb.klb,xZb,6,j-g,15,1);for(i=g;i<j;i++){b=k[i]&4095;e[i-g]=b;a.eb[b]=true;}$Xb.Si(a.fb,e);if(j==k.length)break;h=k[j]&G$b;g=j;}}};ZXb.ff=function ff(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;h=false;for(i=0;i<a.fb.a.length;i++){g=$Xb.Xi(a.fb,i);b=true;n=-1;j=false;for(l=0;l<g.length;l++){c=g[l];if(a.bb[c]==0){b=false;break;}if(a.bb[c]!=3){k=true;for(m=0;m<g.length;m++){if(m!=l&&a.d[c]==a.d[g[m]]){k=false;break;}}if(k&&n<a.d[c]){n=a.d[c];j=a.bb[c]==1;}}}if(b&&n!=-1){for(d=g,e=0,f=d.length;e<f;++e){c=d[e];(a.bb[c]==1||a.bb[c]==2)&&(a.cb[c]=j);a.eb[c]=false;}$Xb.dj(a.fb,g);h=true;--i;}}return h;};ZXb.gf=function gf(a){var b,c;b=ZXb.Ye(a);do{c=b;ZXb.Ue(a);b=ZXb.Ye(a);}while(c!=b);return b;};ZXb.hf=function hf(a){(a.O&1)!=0&&(a.O&2)==0&&(a.e=$Xb.wOb(a.d,a.P.f));if((a.O&w$b)==0){a.U=Rjb(TXb.Bwb,JZb,6,a.P.f,16,1);a.T=Rjb(TXb.Bwb,JZb,6,a.P.g,16,1);if(a.S<a.P.f){ZXb.Ie(a);if((a.O&w$b)==0){ZXb.ff(a);!!a.N&&ZXb.Pg(a.N,a.d);}}}a.e==null&&(a.O&1)!=0&&(a.O&2)!=0&&(a.e=$Xb.wOb(a.d,a.P.f));while(a.S<a.P.f){ZXb.Je(a);if((a.O&w$b)==0){ZXb.ff(a);!!a.N&&ZXb.Pg(a.N,a.d);}}if((a.O&w$b)==0){ZXb.ff(a);ZXb.af(a);ZXb.Gf(a);}};ZXb.jf=function jf(a){var b,c,d,e,f;f=a.S;e=$Xb.wOb(a.d,a.P.f);if(!a.P.K){ZXb.lf(a);ZXb.Yf(a,f,e);}a._=Rjb(TXb.glb,R$b,6,a.P.f,15,1);a.$=Rjb(TXb.glb,R$b,6,a.P.f,15,1);for(c=0;c<a.P.f;c++){a._[c]=ZXb.Ek(a.P,c)<<24>>24;a.$[c]=ZXb.Dk(a.P,c)<<24>>24;}a.j=Rjb(TXb.glb,R$b,6,a.P.g,15,1);a.i=Rjb(TXb.glb,R$b,6,a.P.g,15,1);for(d=0;d<a.P.g;d++){a.j[d]=ZXb.$k(a.P,d)<<24>>24;a.i[d]=ZXb.Zk(a.P,d)<<24>>24;}ZXb.kf(a);a.X=false;a.K=Rjb(TXb.Bwb,JZb,6,a.P.f,16,1);for(b=0;b<a.P.f;b++){if(a.bb[b]!=0){a.K[b]=true;a.X=true;}}ZXb.nf(a);a.N=null;a.ab=Rjb(TXb.Bwb,JZb,6,a.P.f,16,1);if(a.X){a.N=new ZXb.Vg(a.P,e,a.K,a.bb,a.k,a._,a.$,a.gb,a.o,a.ab);ZXb.Qg(a.N);}a.cb=Rjb(TXb.Bwb,JZb,6,a.P.f,16,1);a.eb=Rjb(TXb.Bwb,JZb,6,a.P.f,16,1);a.fb=new $Xb.kj();!!a.N&&ZXb.Pg(a.N,a.d);ZXb.ef(a);ZXb.Yf(a,f,e);ZXb.mf(a);!!a.N&&(a.I=ZXb.Mg(a.N));ZXb.xf(a);};ZXb.kf=function kf(a){var b,c,d,e,f,g;a.J=true;f=ZXb._e(a,false);while(a.S<a.P.f&&f){for(b=0;b<a.P.f;b++){ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],a.b,Uwb(a.d[b]));g=a.bb[b]<<7;if((a.bb[b]==1||a.bb[b]==2)&&a._[b]!=0){g|=a._[b]<<5;g|=a.$[b];}ZXb.wg(a.c[b],18,TXb.Qwb(g<<9));}for(c=0;c<a.P.g;c++){d=a.k[c]<<7;if((a.k[c]==1||a.k[c]==2)&&ZXb.el(a.P,c)==1&&a.j[c]!=0){d|=a.j[c]<<5;d|=a.i[c];}ZXb.xg(a.c[ZXb.Vk(a.P,0,c)],TXb.Qwb(d));ZXb.xg(a.c[ZXb.Vk(a.P,1,c)],TXb.Qwb(d));}e=ZXb.gf(a);if(a.S==e)break;a.S=e;f=ZXb._e(a,false);}};ZXb.lf=function lf(a){var b,c,d,e;a.J=true;a.Y=Rjb(TXb.glb,R$b,6,a.P.f,15,1);a.f=Rjb(TXb.glb,R$b,6,a.P.g,15,1);e=ZXb._e(a,true);while(a.S<a.P.f&&e){for(b=0;b<a.P.f;b++){ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],a.b+4,Uwb(a.d[b]<<4|a.bb[b]<<2));}for(c=0;c<a.P.g;c++){ZXb.xg(a.c[ZXb.Vk(a.P,0,c)],Uwb(a.k[c]));ZXb.xg(a.c[ZXb.Vk(a.P,1,c)],Uwb(a.k[c]));}d=ZXb.gf(a);if(a.S==d)break;a.S=d;e=ZXb._e(a,true);}};ZXb.mf=function mf(a){var b,c,d,e,f,g,h;a.J=true;d=ZXb.wf(a);!!a.N&&ZXb.Pg(a.N,a.d)&&(d=ZXb.wf(a));ZXb._e(a,false)&&ZXb.ff(a);g=true;while(a.S<a.P.f&&g){e=ZXb.bf(a,d);for(b=0;b<a.P.f;b++){ZXb.zg(a.c[b],b);ZXb.wg(a.c[b],a.b,Uwb(a.d[b]));ZXb.wg(a.c[b],20,0);!a.ab[b]&&a._[b]!=0&&ZXb.xg(a.c[b],Uwb((a._[b]<<18)+(e[a._[b]==1?0:1][a.$[b]]<<8)));h=a.bb[b];a.cb[b]&&(h==1?h=2:h==2&&(h=1));ZXb.xg(a.c[b],TXb.Qwb(h<<4));}for(c=0;c<a.P.g;c++){ZXb.xg(a.c[ZXb.Vk(a.P,0,c)],Uwb(a.k[c]));ZXb.xg(a.c[ZXb.Vk(a.P,1,c)],Uwb(a.k[c]));}f=ZXb.gf(a);if(a.S==f)break;a.S=f;g=false;if(!!a.N&&ZXb.Pg(a.N,a.d)){g=true;d=ZXb.wf(a);}if(ZXb._e(a,false)){g=true;ZXb.ff(a);}}};ZXb.nf=function nf(a){var b,c;for(b=0;b<a.P.f;b++)(!a.K[b]||a.bb[b]==3)&&(a._[b]=0);for(c=0;c<a.P.g;c++)(ZXb.el(a.P,c)!=1||a.k[c]==0||a.k[c]==3)&&(a.j[c]=0);};ZXb.of=function of(a,b,c){if(a.a==null){a.a=Rjb(TXb.glb,R$b,6,a.P.f,15,1);$Xb.zOb(a.a);}a.a[b]=c<<24>>24;};ZXb.pf=function pf(b,c){var d,e,f,g,h,i;if((b.k[c]==1||b.k[c]==2)&&!ZXb.Yo(b.P,c)){h=false;try{for(g=0;g<2;g++){d=ZXb.Vk(b.P,g,c);if(ZXb.Sn(b.P,d)==3){e=Rjb(TXb.klb,xZb,6,2,15,1);f=0;for(i=0;i<ZXb.Sn(b.P,d);i++)ZXb.Tn(b.P,d,i)!=c&&(e[f++]=ZXb.Rn(b.P,d,i));b.d[e[0]]>b.d[e[1]]^ZXb.rf(b,d,e[0],e[1])&&(h=!h);}}}catch(a){a=Fwb(a);if(Ykb(a,19)){b.f[c]=3;return;}else throw Gwb(a);}b.k[c]==1^h?b.f[c]=1:b.f[c]=2;}};ZXb.qf=function qf(b,c){var d,e,f,g,h,i,j;if(b.bb[c]==1||b.bb[c]==2){i=false;if(ZXb.In(b.P,c)==2){try{for(h=0;h<2;h++){d=ZXb.Rn(b.P,c,h);if(ZXb.Sn(b.P,d)==3){f=Rjb(TXb.klb,xZb,6,2,15,1);g=0;for(j=0;j<ZXb.Sn(b.P,d);j++)ZXb.Un(b.P,d,j)==1&&(f[g++]=ZXb.Rn(b.P,d,j));b.d[f[0]]>b.d[f[1]]^ZXb.rf(b,d,f[0],f[1])&&(i=!i);}}}catch(a){a=Fwb(a);if(Ykb(a,19)){b.Y[c]=3;return;}else throw Gwb(a);}}else {try{e=ZXb.tf(b,c);}catch(a){a=Fwb(a);if(Ykb(a,19)){b.Y[c]=3;return;}else throw Gwb(a);}for(h=1;h<e.length;h++)for(j=0;j<h;j++)b.d[e[h]]<b.d[e[j]]&&(i=!i);}b.bb[c]==1^i?b.Y[c]=1:b.Y[c]=2;}};ZXb.rf=function rf(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L;if(ZXb.Qk(a.P,c)!=ZXb.Qk(a.P,d))return ZXb.Qk(a.P,c)>ZXb.Qk(a.P,d);if(ZXb.Jk(a.P,c)!=ZXb.Jk(a.P,d)){H=ZXb.Gl(a.P,c)?(ZXb.Sj(),ZXb.Qj)[ZXb.Qk(a.P,c)]:ZXb.Jk(a.P,c);I=ZXb.Gl(a.P,d)?(ZXb.Sj(),ZXb.Qj)[ZXb.Qk(a.P,d)]:ZXb.Jk(a.P,d);return H>I;}w=a.P.f;s=Rjb(TXb.klb,xZb,6,w,15,1);u=Rjb(TXb.klb,xZb,6,w,15,1);v=Rjb(TXb.klb,xZb,6,w,15,1);t=Rjb(TXb.Bwb,JZb,6,w,16,1);i=Rjb(TXb.Bwb,JZb,6,a.P.q,16,1);s[0]=b;s[1]=c;s[2]=d;u[0]=-1;u[1]=0;u[2]=0;i[b]=true;i[c]=true;i[d]=true;m=1;A=2;G=Rjb(TXb.klb,xZb,6,64,15,1);G[1]=1;G[2]=3;o=2;while(m<=A){while(m<G[o]){n=s[m];if(!t[m]){p=0;q=0;for(C=0;C<ZXb.Sn(a.P,n);C++){k=ZXb.Rn(a.P,n,C);if(A+ZXb.Un(a.P,n,C)+1>=w){w+=a.P.f;s=ZXb.ag(s,w);u=ZXb.ag(u,w);v=ZXb.ag(v,w);t=ZXb.bg(t,w);}if(ZXb.Mo(a.P,ZXb.Tn(a.P,n,C))){++p;q+=ZXb.Qk(a.P,k);}else {for(F=1;F<ZXb.Un(a.P,n,C);F++){++A;s[A]=k;u[A]=m;t[A]=true;}}K=u[m];if(k==s[K])continue;h=false;if(i[k]){J=u[K];while(J!=-1){if(k==s[J]){h=true;break;}J=u[J];}}if(h){++A;s[A]=k;u[A]=m;t[A]=true;}else {++A;s[A]=k;u[A]=m;i[k]=true;}}if(p!=0){++A;v[A]=(q<<2)/p|0;u[A]=m;t[A]=true;}}++m;if(m==pZb){throw Gwb(new UXb.aA('Emergency break in while loop.'));}}G.length==o+1&&(G=ZXb.ag(G,G.length+64));G[o+1]=A+1;for(B=G[o];B<G[o+1];B++){v[B]==0&&(v[B]=(ZXb.Qk(a.P,s[B])==151?1:ZXb.Qk(a.P,s[B])==152?1:ZXb.Qk(a.P,s[B]))<<2);v[B]+=v[u[B]]<<16;}ZXb.vf(a,t,v,u,s,G,o);if(v[1]!=v[2])return v[1]>v[2];o>1&&ZXb.sf(v,u,G,o);++o;}l=Rjb(TXb.klb,xZb,6,a.P.f,15,1);D=false;for(f=0;f<a.P.f;f++){if(i[f]&&!ZXb.Gl(a.P,f)){D=true;break;}}if(D){for(g=0;g<a.P.f;g++)l[g]=ZXb.Gl(a.P,g)?(ZXb.Sj(),ZXb.Qj)[ZXb.Qk(a.P,g)]:ZXb.Jk(a.P,g);if(ZXb.uf(a,t,v,u,s,l,G,o))return v[1]>v[2];}$Xb.FOb(l,l.length,0);r=false;for(j=0;j<a.P.g;j++){if(i[ZXb.Vk(a.P,0,j)]||i[ZXb.Vk(a.P,1,j)]){if(a.f[j]==1){l[ZXb.Vk(a.P,0,j)]=1;l[ZXb.Vk(a.P,1,j)]=1;r=true;}else if(a.f[j]==2){l[ZXb.Vk(a.P,0,j)]=2;l[ZXb.Vk(a.P,1,j)]=2;r=true;}}}if(r&&ZXb.uf(a,t,v,u,s,l,G,o))return v[1]>v[2];$Xb.FOb(l,l.length,0);L=false;for(e=0;e<a.P.f;e++){if(i[e]){if(a.Y[e]==2){l[e]=1;L=true;}else if(a.Y[e]==1){l[e]=2;L=true;}}}if(L&&ZXb.uf(a,t,v,u,s,l,G,o))return v[1]>v[2];throw Gwb(new UXb.aA('no distinction applying CIP rules'));};ZXb.sf=function sf(a,b,c,d){var e,f,g,h,i,j,k,l,m;l=c[d];g=c[d+1]-l;m=Rjb(TXb.ulb,jZb,213,g,0,1);for(i=0;i<g;i++){m[i]=new ZXb.vg();m[i].c=a[i+l];m[i].b=b[i+l];m[i].a=i+l;}e=new ZXb.sg();for(k=d;k>1;k--){for(j=0;j<g;j++){m[j].c+=a[m[j].b]<<16;m[j].b=b[m[j].b];}$Xb.MOb(m,0,m.length,e);f=1;for(h=0;h<g;h++){a[m[h].a]=f;h!=g-1&&ZXb.rg(m[h],m[h+1])!=0&&++f;}}};ZXb.tf=function tf(a,b){var c,d,e,f,g,h,i;g=ZXb.Dn(a.P,b);h=Rjb(TXb.klb,xZb,6,g,15,1);for(e=0;e<g;e++)h[e]=ZXb.Rn(a.P,b,e);for(d=g;d>1;d--){c=false;for(f=1;f<d;f++){if(ZXb.rf(a,b,h[f-1],h[f])){c=true;i=h[f-1];h[f-1]=h[f];h[f]=i;}}if(!c)break;}return h;};ZXb.uf=function uf(a,b,c,d,e,f,g,h){var i,j;for(j=1;j<h;j++){for(i=g[j];i<g[j+1];i++)c[i]=f[e[i]]+(c[d[i]]<<8);ZXb.vf(a,b,c,d,e,g,j);if(c[1]!=c[2])return true;j>1&&ZXb.sf(c,d,g,j);}return false;};ZXb.vf=function vf(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p,q,r;for(l=g;l>1;l--){p=f[l]-f[l-1];r=Rjb(TXb.slb,jZb,212,p,0,1);h=f[l];for(o=0;o<p;o++){q=f[l-1]+o;m=h;while(m<f[l+1]&&d[m]==q)++m;r[o]=new ZXb.pg();r[o].c=q;r[o].d=c[q];r[o].b=b[q]?0:ZXb.qo(a.P,e[q]);r[o].a=Rjb(TXb.klb,xZb,6,m-h,15,1);for(k=h;k<m;k++)r[o].a[k-h]=c[k];XXb.eTb(r[o].a,XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));h=m;}i=new ZXb.mg();$Xb.MOb(r,0,r.length,i);j=1;for(n=0;n<p;n++){c[r[n].c]=j;n!=p-1&&ZXb.lg(r[n],r[n+1])!=0&&++j;}}};ZXb.wf=function wf(a){var b,c;c=Pjb(TXb.klb,[_Yb,P$b],[41,8],0,[2,32],2);for(b=0;b<a.P.f;b++){a.K[b]&&(a._[b]==1?c[0][a.$[b]]=ZXb.Wg(c[0][a.$[b]],b):a._[b]==2&&(c[1][a.$[b]]=ZXb.Wg(c[0][a.$[b]],b)));}return c;};ZXb.xf=function xf(a){var b,c,d,e,f,g,h,i,j,k,l,m;f=0;k=0;g=0;h=0;i=0;j=0;l=0;m=false;b=Rjb(TXb.Bwb,JZb,6,32,16,1);for(c=0;c<a.P.f;c++){if(a.bb[c]!=0){++f;if(a.bb[c]==3){++k;}else {if(a._[c]==0){++g;!!a.N&&ZXb.Lg(a.N,c)&&++h;}else if(a._[c]==2){a.$[c]==0&&++j;}else if(a._[c]==1){e=a.$[c];if(!b[e]){++l;b[e]=true;}a.$[c]==0&&++i;!!a.N&&ZXb.Lg(a.N,c)&&(m=true);}}}}for(d=0;d<a.P.g;d++){if(a.k[d]!=0&&ZXb.el(a.P,d)==1){++f;if(a.k[d]==3){++k;}else {if(a.j[d]==0){++g;!!a.N&&ZXb.Lg(a.N,ZXb.Vk(a.P,0,d))&&ZXb.Lg(a.N,ZXb.Vk(a.P,1,d))&&++h;}else if(a.j[d]==2){a.i[d]==0&&++j;}else if(a.j[d]==1){e=a.i[d];if(!b[e]){++l;b[e]=true;}a.i[d]==0&&++i;!!a.N&&ZXb.Lg(a.N,ZXb.Vk(a.P,0,d))&&ZXb.Lg(a.N,ZXb.Vk(a.P,1,d))&&(m=true);}}}}if(f==0){ZXb.Gm(a.P,nZb);return;}if(k!=0){ZXb.Gm(a.P,0);return;}if(a.I){ZXb.Gm(a.P,S$b+(1<<l));return;}i+h==f&&!m?ZXb.Gm(a.P,T$b):g==f?ZXb.Gm(a.P,F$b):j==f?ZXb.Gm(a.P,327680):g==f-1&&i==1?ZXb.Gm(a.P,g$b):ZXb.Gm(a.P,458752+(1<<l));};ZXb.yf=function yf(a,b,c){while(c!=0){if(a.r==0){(!a.p||a.t!=63)&&(a.t+=64);UXb.bIb(a.s,a.t&oZb);a.r=6;a.t=0;}a.t<<=1;a.t=kxb(dxb(Uwb(a.t),Iwb(b,1)));b=fxb(b,1);--c;--a.r;}};ZXb.zf=function zf(a){a.t<<=a.r;(!a.p||a.t!=63)&&(a.t+=64);UXb.bIb(a.s,a.t&oZb);return a.s.a;};ZXb.Af=function Af(a,b){a.s=new UXb.iIb();a.r=6;a.t=0;a.p=b;};ZXb.Bf=function Bf(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q;if(a.P.f==0){a.q='';return;}l=false;if(a.hb&&a.P.q>a.P.f&&!a.P.K){l=true;for(i=0;i<a.P.f;i++){if(ZXb.fo(a.P,i)!=0){l=false;break;}}}q=a.hb?16:8;ZXb.Af(a,true);UXb.bIb(a.s,l?35:33);ZXb.yf(a,Uwb(a.hb?1:0),1);ZXb.yf(a,TXb.Qwb(b?1:0),1);ZXb.yf(a,TXb.Qwb(q/2|0),4);o=0;for(j=1;j<a.P.f;j++)o=ZXb.Of(a,a.w[j],a.C[j]==-1?-1:a.w[a.C[j]],o,c);if(l){for(i=0;i<a.P.f;i++){d=a.w[i];for(n=ZXb.Sn(a.P,d);n<ZXb.Dn(a.P,d);n++)o=ZXb.Of(a,ZXb.Rn(a.P,d,n),d,o,c);}}if(a.P.f>1&&o==0){a.q='';return;}g=1<<q;m=o/(g/2-1);p=o+m/2;for(k=1;k<a.P.f;k++)ZXb.Cf(a,a.w[k],a.C[k]==-1?-1:a.w[a.C[k]],p,m,q,c);if(l){for(h=0;h<a.P.f;h++){d=a.w[h];for(n=ZXb.Sn(a.P,d);n<ZXb.Dn(a.P,d);n++)ZXb.Cf(a,ZXb.Rn(a.P,d,n),d,p,m,q,c);}}if(b){f=a.hb?1.5:(ZXb.Sj(),ZXb.Sj(),ZXb.Rj);e=ZXb.Tk(a.P,l?a.P.q:a.P.f,l?a.P.r:a.P.g,f,c);ZXb.yf(a,Uwb($wnd.Math.min(g-1,$wnd.Math.max(0,flb(0.5+$wnd.Math.log(e/0.1)*$wnd.Math.LOG10E/($wnd.Math.log(2000)*$wnd.Math.LOG10E)*(g-1))))),q);ZXb.yf(a,Uwb(ZXb.Ff(c[a.w[0]].a/e,g)),q);ZXb.yf(a,Uwb(ZXb.Ff(c[a.w[0]].b/e,g)),q);a.hb&&ZXb.yf(a,Uwb(ZXb.Ff(c[a.w[0]].c/e,g)),q);}a.q=ZXb.zf(a);};ZXb.Cf=function Cf(a,b,c,d,e,f,g){var h,i,j;h=c==-1?(g[b].a-g[a.w[0]].a)/8:g[b].a-g[c].a;i=c==-1?(g[b].b-g[a.w[0]].b)/8:g[b].b-g[c].b;ZXb.yf(a,Uwb(flb((d+h)/e)),f);ZXb.yf(a,Uwb(flb((d+i)/e)),f);if(a.hb){j=c==-1?(g[b].c-g[a.w[0]].c)/8:g[b].c-g[c].c;ZXb.yf(a,Uwb(flb((d+j)/e)),f);}};ZXb.Df=function Df(a,b){var c;for(c=0;c<a.u;c++)b-=16;b<0&&(UXb.nIb(),String.fromCharCode(10));while(b>15){ZXb.yf(a,1,1);ZXb.yf(a,15,4);b-=16;++a.u;}ZXb.yf(a,1,1);ZXb.yf(a,TXb.Qwb(b),4);};ZXb.Ef=function Ef(a){var b,c,d,e,f,g;if(a.P.f==0){a.L='';return;}f=0;d=false;e=false;for(c=0;c<a.P.f;c++){f<ZXb.Ik(a.P,c)&&(f=ZXb.Ik(a.P,c));ZXb.vl(a.P,c)?d=true:e=true;}if(f==0){a.L='';return;}g=ZXb.jg(f);ZXb.Af(a,true);ZXb.yf(a,TXb.Qwb(g),4);ZXb.yf(a,TXb.Qwb(d?1:0),1);ZXb.yf(a,TXb.Qwb(e?1:0),1);for(b=0;b<a.P.f;b++){ZXb.yf(a,Uwb(ZXb.Ik(a.P,a.w[b])),g);d&&e&&ZXb.yf(a,Uwb(ZXb.vl(a.P,a.w[b])?1:0),1);}a.L=ZXb.zf(a);};ZXb.Ff=function Ff(a,b){var c,d,e,f;c=b/2|0;e=a<0;a=$wnd.Math.abs(a);f=b/32|0;d=$wnd.Math.min(c-1,kxb(Twb($wnd.Math.round(a*c/(a+f)))));return e?c+d:d;};ZXb.Gf=function Gf(a){var b,c,d;for(b=0;b<a.P.f;b++){a.bb[b]==3&&!ZXb.rl(a.P,b)&&ZXb.Om(a.P,b);(ZXb.Ek(a.P,b)==1||ZXb.Ek(a.P,b)==2)&&a.bb[b]==3&&ZXb.Om(a.P,b);ZXb.rl(a.P,b)&&a.bb[b]!=3&&!ZXb.$f(a,b)&&ZXb.Om(a.P,b);}for(d=0;d<a.P.r;d++)ZXb.Ll(a.P,d)&&!ZXb.Zf(a,d)&&ZXb.Om(a.P,ZXb.Vk(a.P,0,d));for(c=0;c<a.P.g;c++){if(ZXb.bl(a.P,c)==2){if(ZXb.Bl(a.P,c)&&(a.k[c]==1||a.k[c]==2)){a.k[c]=3;ZXb.Fm(a.P,c,386);}if(a.k[c]==3&&!a.n[c]){if(ZXb.el(a.P,c)!=386){ZXb.Om(a.P,ZXb.Vk(a.P,0,c));ZXb.Om(a.P,ZXb.Vk(a.P,1,c));}}}if(ZXb.el(a.P,c)==1&&a.k[c]==3&&!ZXb.rl(a.P,ZXb.Vk(a.P,0,c))&&!ZXb.rl(a.P,ZXb.Vk(a.P,1,c))){ZXb.Om(a.P,ZXb.Vk(a.P,0,c));ZXb.Om(a.P,ZXb.Vk(a.P,1,c));}if((ZXb.$k(a.P,c)==1||ZXb.$k(a.P,c)==2)&&(ZXb.el(a.P,c)!=1||a.k[c]!=1&&a.k[c]!=2)){ZXb.Om(a.P,ZXb.Vk(a.P,0,c));ZXb.Om(a.P,ZXb.Vk(a.P,1,c));}}};ZXb.Hf=function Hf(a){var b,c,d,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;if(a.P.f==0)return;if(a.D)return;a.G=0;v=0;for(c=1;c<a.P.f;c++)a.d[c]>a.d[v]&&(v=c);d=Rjb(TXb.Bwb,JZb,6,a.P.f,16,1);g=Rjb(TXb.Bwb,JZb,6,a.P.g,16,1);a.F=Rjb(TXb.klb,xZb,6,a.P.f,15,1);a.w=Rjb(TXb.klb,xZb,6,a.P.f,15,1);a.C=Rjb(TXb.klb,xZb,6,a.P.f,15,1);a.A=Rjb(TXb.klb,xZb,6,a.P.g,15,1);a.w[0]=v;a.F[v]=0;d[v]=true;i=0;j=1;k=0;while(i<a.P.f){if(i<j){while(true){o=0;p=0;m=-1;b=a.w[i];for(q=0;q<ZXb.En(a.P,b);q++){if(q<ZXb.Sn(a.P,b)||q>=ZXb.Dn(a.P,b)){h=ZXb.Rn(a.P,b,q);if(!d[h]&&a.d[h]>m){o=h;p=ZXb.Tn(a.P,b,q);m=a.d[h];}}}if(m==-1)break;a.F[o]=j;a.C[j]=i;a.w[j++]=o;a.A[k++]=p;d[o]=true;g[p]=true;}++i;}else {n=0;m=-1;for(b=0;b<a.P.f;b++){if(!d[b]&&a.d[b]>m){n=b;m=a.d[b];}}a.F[n]=j;a.C[j]=-1;a.w[j++]=n;d[n]=true;}}a.B=Rjb(TXb.klb,xZb,6,2*(a.P.g-k),15,1);while(true){s=a.P.M;t=a.P.M;u=-1;for(f=0;f<a.P.g;f++){if(!g[f]){if(a.F[ZXb.Vk(a.P,0,f)]<a.F[ZXb.Vk(a.P,1,f)]){r=a.F[ZXb.Vk(a.P,0,f)];l=a.F[ZXb.Vk(a.P,1,f)];}else {r=a.F[ZXb.Vk(a.P,1,f)];l=a.F[ZXb.Vk(a.P,0,f)];}if(r<s||r==s&&l<t){s=r;t=l;u=f;}}}if(u==-1)break;g[u]=true;a.A[k++]=u;a.B[2*a.G]=s;a.B[2*a.G+1]=t;++a.G;}a.D=true;};ZXb.If=function If(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o;i=null;o=ZXb.so(a.P);for(l=0;l<o.i.a.length;l++){if(o.e[l]){f=0;m=$Xb.Xi(o.i,l);for(c=m,d=0,e=c.length;d<e;++d){b=c[d];ZXb.Uf(a,b)&&++f;}if(f!=0){n=$Xb.Xi(o.j,l);i==null&&(i=Rjb(TXb.Bwb,JZb,6,a.P.g,16,1));if(f==m.length){j=-1;k=fZb;for(g=0;g<m.length;g++){if(k>a.w[n[g]]){k=a.w[n[g]];j=g;}}while(f>0){i[n[j]]=true;j=ZXb.gg(j+2,m.length);f-=2;}}else {h=0;while(ZXb.Uf(a,m[h]))++h;while(!ZXb.Uf(a,m[h]))h=ZXb.gg(h+1,m.length);while(f>0){i[n[h]]=true;h=ZXb.gg(h+2,m.length);f-=2;while(!ZXb.Uf(a,m[h]))h=ZXb.gg(h+1,m.length);}}}}}return i;};ZXb.Jf=function Jf(a,b){return a.k[b];};ZXb.Kf=function Kf(a){return ZXb.Lf(a,a.hb);};ZXb.Lf=function Lf(a,b){if(a.q==null){ZXb.Hf(a);ZXb.Bf(a,b,a.P.J);}return a.q;};ZXb.Mf=function Mf(a){if(a.L==null){ZXb.Hf(a);ZXb.Ef(a);}return a.L;};ZXb.Nf=function Nf(a){if(a.H==null){ZXb.Hf(a);if((a.O&w$b)==0){ZXb.Wf(a);ZXb.Xf(a,1);ZXb.Xf(a,2);}ZXb.Vf(a);}return a.H;};ZXb.Of=function Of(a,b,c,d,e){var f,g,h;f=c==-1?$wnd.Math.abs(e[b].a-e[a.w[0]].a)/8:$wnd.Math.abs(e[b].a-e[c].a);d<f&&(d=f);g=c==-1?$wnd.Math.abs(e[b].b-e[a.w[0]].b)/8:$wnd.Math.abs(e[b].b-e[c].b);d<g&&(d=g);if(a.hb){h=c==-1?$wnd.Math.abs(e[b].c-e[a.w[0]].c)/8:$wnd.Math.abs(e[b].c-e[c].c);d<h&&(d=h);}return d;};ZXb.Pf=function Pf(a,b){return a.V[b];};ZXb.Qf=function Qf(a,b){return a.W[b];};ZXb.Rf=function Rf(a,b){return a.e==null?-1:a.e[b];};ZXb.Sf=function Sf(a,b){return a.bb[b];};ZXb.Tf=function Tf(a,b){var c,d,e,f,g,h,i;i=ZXb.so(a.P);for(c=0;c<i.i.a.length;c++){if(i.d[c]&&ZXb.Wr(i,c,b)){for(e=$Xb.Xi(i.i,c),f=0,g=e.length;f<g;++f){d=e[f];if(d!=b)for(h=0;h<ZXb.Sn(a.P,d);h++)if(ZXb.Jo(a.P,ZXb.Tn(a.P,d,h)))return true;}return false;}}return false;};ZXb.Uf=function Uf(a,b){var c,d,e;if(ZXb.In(a.P,b)<2)return false;if(ZXb.Sn(a.P,b)==2)return true;c=0;for(e=0;e<ZXb.Sn(a.P,b);e++){d=ZXb.Tn(a.P,b,e);ZXb.Io(a.P,d)&&(c+=ZXb.bl(a.P,d)-1);}return c>1;};ZXb.Vf=function Vf(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X;ZXb.Af(a,false);ZXb.yf(a,9,4);T=$wnd.Math.max(ZXb.jg(a.P.f),ZXb.jg(a.P.g));ZXb.yf(a,TXb.Qwb(T),4);if(T==0){ZXb.yf(a,Uwb(a.P.K?1:0),1);ZXb.yf(a,0,1);a.H=ZXb.zf(a);return;}U=W=V=H=0;for(i=0;i<a.P.f;i++){if(Swb(Iwb(ZXb.Lk(a.P,i),1),0)){switch(ZXb.Qk(a.P,i)){case 6:break;case 7:++U;break;case 8:++W;break;default:++V;}ZXb.zk(a.P,i)!=0&&++H;}}ZXb.yf(a,Uwb(a.P.f),T);ZXb.yf(a,Uwb(a.P.g),T);ZXb.yf(a,TXb.Qwb(U),T);ZXb.yf(a,TXb.Qwb(W),T);ZXb.yf(a,TXb.Qwb(V),T);ZXb.yf(a,TXb.Qwb(H),T);for(j=0;j<a.P.f;j++)ZXb.Qk(a.P,a.w[j])==7&&Swb(Iwb(ZXb.Lk(a.P,a.w[j]),1),0)&&ZXb.yf(a,TXb.Qwb(j),T);for(m=0;m<a.P.f;m++)ZXb.Qk(a.P,a.w[m])==8&&Swb(Iwb(ZXb.Lk(a.P,a.w[m]),1),0)&&ZXb.yf(a,TXb.Qwb(m),T);for(n=0;n<a.P.f;n++)if(ZXb.Qk(a.P,a.w[n])!=6&&ZXb.Qk(a.P,a.w[n])!=7&&ZXb.Qk(a.P,a.w[n])!=8&&Swb(Iwb(ZXb.Lk(a.P,a.w[n]),1),0)){ZXb.yf(a,TXb.Qwb(n),T);ZXb.yf(a,Uwb(ZXb.Qk(a.P,a.w[n])),8);}for(o=0;o<a.P.f;o++)if(ZXb.zk(a.P,a.w[o])!=0&&Swb(Iwb(ZXb.Lk(a.P,a.w[o]),1),0)){ZXb.yf(a,TXb.Qwb(o),T);ZXb.yf(a,Uwb(8+ZXb.zk(a.P,a.w[o])),4);}S=0;v=0;for(p=1;p<a.P.f;p++){if(a.C[p]==-1){L=0;}else {L=1+a.C[p]-v;v=a.C[p];}S<L&&(S=L);}K=ZXb.jg(S);ZXb.yf(a,TXb.Qwb(K),4);v=0;for(q=1;q<a.P.f;q++){if(a.C[q]==-1){L=0;}else {L=1+a.C[q]-v;v=a.C[q];}ZXb.yf(a,TXb.Qwb(L),K);}for(N=0;N<2*a.G;N++)ZXb.yf(a,Uwb(a.B[N]),T);for(A=0;A<a.P.g;A++){G=(ZXb.dl(a.P,a.A[A])&y$b)!=0||ZXb.el(a.P,a.A[A])==32?1:ZXb.Mo(a.P,a.A[A])?0:$wnd.Math.min(3,ZXb.bl(a.P,a.A[A]));ZXb.yf(a,TXb.Qwb(G),2);}c=0;if((a.O&w$b)==0){for(r=0;r<a.P.f;r++)a.Z[a.w[r]]!=0&&a.Z[a.w[r]]!=3&&++c;}ZXb.yf(a,TXb.Qwb(c),T);if((a.O&w$b)==0){for(r=0;r<a.P.f;r++){if(a.Z[a.w[r]]!=0&&a.Z[a.w[r]]!=3){ZXb.yf(a,TXb.Qwb(r),T);if(a._[a.w[r]]==0){ZXb.yf(a,Uwb(a.Z[a.w[r]]),3);}else {X=a.Z[a.w[r]]==1?a._[a.w[r]]==1?4:6:a._[a.w[r]]==1?5:7;ZXb.yf(a,TXb.Qwb(X),3);ZXb.yf(a,Uwb(a.$[a.w[r]]),3);}}}}b=0;if((a.O&w$b)==0){for(B=0;B<a.P.g;B++)a.g[a.A[B]]!=0&&a.g[a.A[B]]!=3&&(!ZXb.Yo(a.P,a.A[B])||ZXb.el(a.P,a.A[B])==1)&&++b;}ZXb.yf(a,TXb.Qwb(b),T);if((a.O&w$b)==0){for(B=0;B<a.P.g;B++){if(a.g[a.A[B]]!=0&&a.g[a.A[B]]!=3&&(!ZXb.Yo(a.P,a.A[B])||ZXb.el(a.P,a.A[B])==1)){ZXb.yf(a,TXb.Qwb(B),T);if(ZXb.el(a.P,a.A[B])==1){if(a.j[a.A[B]]==0){ZXb.yf(a,Uwb(a.g[a.A[B]]),3);}else {X=a.g[a.A[B]]==1?a.j[a.A[B]]==1?4:6:a.j[a.A[B]]==1?5:7;ZXb.yf(a,TXb.Qwb(X),3);ZXb.yf(a,Uwb(a.i[a.A[B]]),3);}}else {ZXb.yf(a,Uwb(a.g[a.A[B]]),2);}}}}ZXb.yf(a,Uwb(a.P.K?1:0),1);I=0;for(s=0;s<a.P.f;s++)ZXb.Jk(a.P,a.w[s])!=0&&++I;if(I!=0){ZXb.Df(a,1);ZXb.yf(a,TXb.Qwb(I),T);for(r=0;r<a.P.f;r++){if(ZXb.Jk(a.P,a.w[r])!=0){ZXb.yf(a,TXb.Qwb(r),T);ZXb.yf(a,Uwb(ZXb.Jk(a.P,a.w[r])),8);}}}a.u=0;if(a.P.K){ZXb.Fe(a,0,T,w$b,1,-1);ZXb.Fe(a,3,T,RZb,1,-1);ZXb.Fe(a,4,T,120,4,3);ZXb.Fe(a,5,T,U$b,2,1);ZXb.Fe(a,6,T,1,1,-1);ZXb.Fe(a,7,T,VZb,4,7);I=0;for(r=0;r<a.P.f;r++)ZXb.Gk(a.P,a.w[r])!=null&&++I;if(I>0){ZXb.Df(a,8);ZXb.yf(a,TXb.Qwb(I),T);for(t=0;t<a.P.f;t++){u=ZXb.Gk(a.P,a.w[t]);if(u!=null){ZXb.yf(a,TXb.Qwb(t),T);ZXb.yf(a,Uwb(u.length),4);for(e=u,f=0,g=e.length;f<g;++f){d=e[f];ZXb.yf(a,TXb.Qwb(d),8);}}}}ZXb.Ge(a,9,T,384,2,7);ZXb.Ge(a,10,T,31,5,0);ZXb.Fe(a,11,T,v$b,1,-1);ZXb.Ge(a,12,T,y$b,8,9);ZXb.Fe(a,13,T,_Zb,3,14);ZXb.Fe(a,14,T,a$b,5,17);ZXb.Fe(a,16,T,t$b,3,22);}I=0;for(k=0;k<a.P.f;k++)a.a!=null&&a.a[a.w[k]]!=-1&&++I;if(I!=0){ZXb.Df(a,17);ZXb.yf(a,TXb.Qwb(I),T);for(r=0;r<a.P.f;r++){if(a.a!=null&&a.a[a.w[r]]!=-1){ZXb.yf(a,TXb.Qwb(r),T);ZXb.yf(a,Uwb(a.a[a.w[r]]),4);}}}if((a.O&8)!=0||(a.O&WZb)!=0){I=0;R=0;for(r=0;r<a.P.f;r++){P=ZXb.Bk(a.P,a.w[r]);if(P!=null){++I;R=$wnd.Math.max(R,XXb.KTb(P).length);}}if(I!=0){Q=ZXb.jg(R);ZXb.Df(a,18);ZXb.yf(a,TXb.Qwb(I),T);ZXb.yf(a,TXb.Qwb(Q),4);for(t=0;t<a.P.f;t++){J=ZXb.Bk(a.P,a.w[t]);if(J!=null){ZXb.yf(a,TXb.Qwb(t),T);ZXb.yf(a,Uwb(XXb.KTb(J).length),Q);for(M=0;M<XXb.KTb(J).length;M++)ZXb.yf(a,(XXb.FTb(M,XXb.KTb(J).length),Uwb(XXb.KTb(J).charCodeAt(M))),7);}}}}if(a.P.K){ZXb.Fe(a,19,T,XZb,3,25);ZXb.Ge(a,20,T,h$b,3,17);}I=0;for(l=0;l<a.P.f;l++)ZXb.Mk(a.P,a.w[l])!=0&&++I;if(I!=0){ZXb.Df(a,21);ZXb.yf(a,TXb.Qwb(I),T);for(h=0;h<a.P.f;h++){if(ZXb.Mk(a.P,a.w[h])!=0){ZXb.yf(a,TXb.Qwb(h),T);ZXb.yf(a,Uwb(ZXb.Mk(a.P,a.w[h])>>4),2);}}}if(a.P.K){ZXb.Fe(a,22,T,u$b,1,-1);ZXb.Ge(a,23,T,V$b,1,-1);ZXb.Ge(a,24,T,z$b,2,21);}if((a.O&16)!=0){for(h=0;h<a.P.f;h++){if(ZXb.Jl(a.P,a.w[h])){ZXb.Df(a,25);for(d=0;d<a.P.f;d++)ZXb.yf(a,Uwb(ZXb.Jl(a.P,a.w[d])?1:0),1);break;}}}O=ZXb.If(a);if(O!=null){I=0;for(B=0;B<a.P.g;B++)O[a.A[B]]&&++I;ZXb.Df(a,26);ZXb.yf(a,TXb.Qwb(I),T);for(C=0;C<a.P.g;C++)O[a.A[C]]&&ZXb.yf(a,TXb.Qwb(C),T);}a.P.K&&ZXb.Fe(a,27,T,KZb,1,-1);I=0;for(D=0;D<a.P.g;D++)ZXb.el(a.P,a.A[D])==32&&++I;if(I!=0){ZXb.Df(a,28);ZXb.yf(a,TXb.Qwb(I),T);for(B=0;B<a.P.g;B++)ZXb.el(a.P,a.A[B])==32&&ZXb.yf(a,TXb.Qwb(B),T);}if(a.P.K){ZXb.Fe(a,29,T,W$b,2,30);ZXb.Fe(a,30,T,BZb,7,32);ZXb.Fe(a,32,T,X$b,2,44);ZXb.Fe(a,33,T,j$b,5,39);ZXb.Fe(a,34,T,UZb,1,-1);ZXb.Ge(a,35,T,Y$b,1,-1);ZXb.Ge(a,36,T,96,2,5);}I=0;for(F=0;F<a.P.g;F++)(ZXb.el(a.P,a.A[F])==8||ZXb.el(a.P,a.A[F])==16)&&++I;if(I!=0){ZXb.Df(a,37);ZXb.yf(a,TXb.Qwb(I),T);for(w=0;w<a.P.g;w++){if(ZXb.el(a.P,a.A[w])==8||ZXb.el(a.P,a.A[w])==16){ZXb.yf(a,TXb.Qwb(w),T);ZXb.yf(a,Uwb(ZXb.el(a.P,a.A[w])==8?0:1),1);}}}ZXb.yf(a,0,1);a.H=ZXb.zf(a);};ZXb.Wf=function Wf(a){var b,c,d,e,f,g,h,i,j,k,l;a.Z=Rjb(TXb.glb,R$b,6,a.P.f,15,1);for(b=0;b<a.P.f;b++){if(a.bb[b]==1||a.bb[b]==2){i=a.cb[b];if(ZXb.Ko(a.P,b)){for(h=0;h<ZXb.Sn(a.P,b);h++){e=ZXb.Rn(a.P,b,h);l=0;k=Rjb(TXb.klb,xZb,6,3,15,1);for(j=0;j<ZXb.Sn(a.P,e);j++){k[l]=ZXb.Rn(a.P,e,j);k[l]!=b&&++l;}l==2&&a.d[k[0]]>a.d[k[1]]^a.F[k[0]]<a.F[k[1]]&&(i=!i);}}else {for(h=1;h<ZXb.Sn(a.P,b);h++){for(j=0;j<h;j++){f=ZXb.Rn(a.P,b,h);g=ZXb.Rn(a.P,b,j);a.d[f]>a.d[g]&&(i=!i);a.F[f]<a.F[g]&&(i=!i);}}}a.Z[b]=a.bb[b]==1^i?1:2;}else {a.Z[b]=a.bb[b];}}a.g=Rjb(TXb.glb,R$b,6,a.P.g,15,1);for(c=0;c<a.P.g;c++){if(a.k[c]==1||a.k[c]==2){i=false;for(h=0;h<2;h++){d=ZXb.Vk(a.P,h,c);if(ZXb.Sn(a.P,d)==3){k=Rjb(TXb.klb,xZb,6,2,15,1);l=0;for(j=0;j<3;j++)ZXb.Rn(a.P,d,j)!=ZXb.Vk(a.P,1-h,c)&&(k[l++]=ZXb.Rn(a.P,d,j));a.d[k[0]]>a.d[k[1]]&&(i=!i);a.F[k[0]]<a.F[k[1]]&&(i=!i);}}a.g[c]=a.k[c]==1^i?1:2;}else {a.g[c]=a.k[c];}}};ZXb.Xf=function Xf(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;i=Rjb(TXb.klb,xZb,6,32,15,1);j=0;for(d=0;d<a.P.f;d++){if((a.Z[d]==1||a.Z[d]==2)&&a._[d]==b){h=a.$[d];if(i[h]<a.d[d]){i[h]==0&&++j;i[h]=a.d[d];}}}for(f=0;f<a.P.g;f++){if((a.g[f]==1||a.g[f]==2)&&a.j[f]==b&&ZXb.el(a.P,f)==1){h=a.i[f];o=$wnd.Math.max(a.d[ZXb.Vk(a.P,0,f)],a.d[ZXb.Vk(a.P,1,f)]);if(i[h]<o){i[h]==0&&++j;i[h]=o;}}}g=Rjb(TXb.glb,R$b,6,32,15,1);for(k=0;k<j;k++){m=-1;n=0;for(l=0;l<32;l++){if(n<i[l]){n=i[l];m=l;}}i[m]=0;g[m]=k<<24>>24;}for(c=0;c<a.P.f;c++)(a.Z[c]==1||a.Z[c]==2)&&a._[c]==b&&(a.$[c]=g[a.$[c]]);for(e=0;e<a.P.g;e++)(a.g[e]==1||a.g[e]==2)&&a.j[e]==b&&ZXb.el(a.P,e)==1&&(a.i[e]=g[a.i[e]]);};ZXb.Yf=function Yf(a,b,c){var d,e;a.S=b;for(d=0;d<a.P.f;d++){a.d[d]=c[d];a.bb[d]=0;a.gb[d]=false;}for(e=0;e<a.P.g;e++){a.k[e]=0;a.o[e]=false;}};ZXb.Zf=function Zf(a,b){var c,d,e;c=ZXb.Vk(a.P,0,b);if(c>=a.P.f)return false;if(a.bb[c]==1||a.bb[c]==2)return true;if(a.bb[c]==3)return false;d=ZXb.zn(a.P,c);if(d!=-1)return a.k[d]==1||a.k[d]==2;for(e=0;e<ZXb.Sn(a.P,c);e++){if(ZXb.Un(a.P,c,e)==2){if(a.bb[ZXb.Rn(a.P,c,e)]==1||a.bb[ZXb.Rn(a.P,c,e)]==2)return true;}}return false;};ZXb.$f=function $f(a,b){var c;for(c=0;c<ZXb.Sn(a.P,b);c++)if(a.k[ZXb.Tn(a.P,b,c)]==3&&ZXb.Un(a.P,b,c)==1)return true;return false;};ZXb._f=function _f(a){var b,c,d,e,f,g,h;g=Rjb(TXb.klb,xZb,6,a.S+1,15,1);for(c=0;c<a.P.f;c++){ZXb.Ek(a.P,c)==0&&(a.bb[c]==1?++g[a.d[c]]:a.bb[c]==2&&--g[a.d[c]]);}for(e=0;e<a.P.g;e++){if(ZXb.bl(a.P,e)==1&&ZXb.$k(a.P,e)==0){if(a.k[e]==1){++g[a.d[ZXb.Vk(a.P,0,e)]];++g[a.d[ZXb.Vk(a.P,1,e)]];}else if(a.k[e]==2){--g[a.d[ZXb.Vk(a.P,0,e)]];--g[a.d[ZXb.Vk(a.P,1,e)]];}}}for(h=1;h<=a.S;h++){if(g[h]!=0){f=g[h]<0;if(f){for(b=0;b<a.P.f;b++){ZXb.Ek(a.P,b)==0&&(a.bb[b]==1?a.bb[b]=2:a.bb[b]==2&&(a.bb[b]=1));}for(d=0;d<a.P.g;d++){ZXb.bl(a.P,d)==1&&ZXb.$k(a.P,d)==0&&(a.k[d]==1?a.k[d]=2:a.k[d]==2&&(a.k[d]=1));}}return f;}}return false;};ZXb.ag=function ag(a,b){var c;c=Rjb(TXb.klb,xZb,6,b,15,1);UXb.oIb(a,0,c,0,a.length);return c;};ZXb.bg=function bg(a,b){var c;c=Rjb(TXb.Bwb,JZb,6,b,16,1);UXb.oIb(a,0,c,0,a.length);return c;};ZXb.cg=function cg(a){var b,c;if(a.Y!=null)for(b=0;b<a.P.f;b++)ZXb.bm(a.P,b,a.Y[b]);if(a.f!=null)for(c=0;c<a.P.g;c++)ZXb.ym(a.P,c,a.f[c]);};ZXb.dg=function dg(a){var b,c,d,e,f,g,h,i,j,k,l;for(b=0;b<a.P.f;b++){if(a.bb[b]==1||a.bb[b]==2){i=false;if(ZXb.Ko(a.P,b)){for(h=0;h<ZXb.Sn(a.P,b);h++){e=ZXb.Rn(a.P,b,h);l=0;k=Rjb(TXb.klb,xZb,6,3,15,1);for(j=0;j<ZXb.Sn(a.P,e);j++){k[l]=ZXb.Rn(a.P,e,j);k[l]!=b&&++l;}l==2&&a.d[k[0]]>a.d[k[1]]^k[0]<k[1]&&(i=!i);}}else {for(h=1;h<ZXb.Sn(a.P,b);h++){for(j=0;j<h;j++){f=ZXb.Rn(a.P,b,h);g=ZXb.Rn(a.P,b,j);a.d[f]>a.d[g]&&(i=!i);f<g&&(i=!i);}}}ZXb.nm(a.P,b,a.bb[b]==1^i?1:2,a.db[b]);}else {ZXb.nm(a.P,b,a.bb[b],a.db[b]);}}for(c=0;c<a.P.g;c++){if(a.k[c]==1||a.k[c]==2){i=false;for(h=0;h<2;h++){d=ZXb.Vk(a.P,h,c);if(ZXb.Sn(a.P,d)==3){k=Rjb(TXb.klb,xZb,6,2,15,1);l=0;for(j=0;j<3;j++)ZXb.Rn(a.P,d,j)!=ZXb.Vk(a.P,1-h,c)&&(k[l++]=ZXb.Rn(a.P,d,j));a.d[k[0]]>a.d[k[1]]&&(i=!i);k[0]<k[1]&&(i=!i);}}ZXb.Cm(a.P,c,a.k[c]==1^i?1:2,a.n[c]);}else {ZXb.Cm(a.P,c,a.k[c],a.n[c]);}}};ZXb.eg=function eg(a){var b;for(b=0;b<a.P.f;b++){ZXb.rm(a.P,b,a.K[b]);}};ZXb.fg=function fg(a){var b,c,d;for(b=0;b<a.P.f;b++)!ZXb.rl(a.P,b)&&a.bb[b]==3&&ZXb.em(a.P,b,true);for(c=0;c<a.P.g;c++){if(a.k[c]==3){d=ZXb.bl(a.P,c);d==1?ZXb.em(a.P,ZXb.Vk(a.P,0,c),true):d==2&&ZXb.Fm(a.P,c,386);}}};ZXb.gg=function gg(a,b){return a<b?a:a-b;};ZXb.hg=function hg(a){ZXb.ig.call(this,a,0);};ZXb.ig=function ig(a,b){this.P=a;this.O=b;ZXb.nu(this.P,7);this.b=ZXb.jg(this.P.f);(this.O&w$b)==0&&ZXb.$e(this);this.hb=(b&64)!=0||ZXb.ql(this.P);if((this.O&w$b)==0){this.bb=Rjb(TXb.glb,R$b,6,this.P.f,15,1);this.db=Rjb(TXb.Bwb,JZb,6,this.P.f,16,1);this.gb=Rjb(TXb.Bwb,JZb,6,this.P.f,16,1);this.k=Rjb(TXb.glb,R$b,6,this.P.g,15,1);this.o=Rjb(TXb.Bwb,JZb,6,this.P.g,16,1);this.n=Rjb(TXb.Bwb,JZb,6,this.P.g,16,1);}ZXb.cf(this);(this.O&w$b)==0&&ZXb.jf(this);ZXb.hf(this);};ZXb.jg=function jg(a){var b;b=0;while(a>0){a>>=1;++b;}return b;};wxb(47,1,{},ZXb.hg,ZXb.ig);_.b=0;_.p=false;_.r=0;_.t=0;_.u=0;_.D=false;_.G=0;_.I=false;_.J=false;_.M=0;_.O=0;_.R=0;_.S=0;_.X=false;_.hb=false;TXb.Clb=UFb(47);ZXb.kg=function kg(a,b){var c,d,e,f;if(a.d!=b.d)return a.d>b.d?1:-1;e=a.a.length;f=b.a.length;c=$wnd.Math.min(e,f);for(d=0;d<c;d++){--e;--f;if(a.a[e]!=b.a[f])return a.a[e]>b.a[f]?1:-1;}if(e!=f)return e>f?1:-1;if(a.b!=b.b)return a.b>b.b?1:-1;return 0;};ZXb.lg=function lg(a,b){return ZXb.kg(a,b);};ZXb.mg=function mg(){};wxb(390,1,{},ZXb.mg);_.Db=function ng(a,b){return ZXb.lg(a,b);};_.ib=function og(a){return this===a;};TXb.tlb=UFb(390);ZXb.pg=function pg(){};wxb(212,1,{212:1},ZXb.pg);_.b=0;_.c=0;_.d=0;TXb.slb=UFb(212);ZXb.qg=function qg(a,b){if(a.c!=b.c)return a.c>b.c?1:-1;return 0;};ZXb.rg=function rg(a,b){return ZXb.qg(a,b);};ZXb.sg=function sg(){};wxb(391,1,{},ZXb.sg);_.Db=function tg(a,b){return ZXb.rg(a,b);};_.ib=function ug(a){return this===a;};TXb.vlb=UFb(391);ZXb.vg=function vg(){};wxb(213,1,{213:1},ZXb.vg);_.a=0;_.b=0;_.c=0;TXb.ulb=UFb(213);ZXb.wg=function wg(a,b,c){if(a.b==0){++a.c;a.b=63;}if(a.b==63){a.d[a.c]=dxb(a.d[a.c],c);a.b-=b;}else {if(a.b>=b){a.d[a.c]=exb(a.d[a.c],b);a.d[a.c]=dxb(a.d[a.c],c);a.b-=b;}else {a.d[a.c]=exb(a.d[a.c],a.b);a.d[a.c]=dxb(a.d[a.c],fxb(c,b-a.b));b-=a.b;++a.c;a.b=63-b;a.d[a.c]=dxb(a.d[a.c],Iwb(c,TXb.Qwb((1<<b)-1)));}}};ZXb.xg=function xg(a,b){a.d[a.c]=Hwb(a.d[a.c],b);};ZXb.yg=function yg(a,b){var c;for(c=0;c<a.c;c++)if(bxb(a.d[c],b.d[c]))return Ywb(a.d[c],b.d[c])?-1:1;return Swb(a.d[a.c],b.d[a.c])?0:Ywb(a.d[a.c],b.d[a.c])?-1:1;};ZXb.zg=function zg(a,b){a.a=b;a.c=0;a.b=63;$Xb.BOb(a.d);};ZXb.Ag=function Ag(a){this.d=Rjb(TXb.llb,M$b,6,a,14,1);};wxb(160,1,{160:1,18:1},ZXb.Ag);_.Eb=function Bg(a){return ZXb.yg(this,a);};_.a=0;_.b=0;_.c=0;TXb.wlb=UFb(160);ZXb.Cg=function Cg(a,b){if(a.b!=b.b)return a.b>b.b?-1:1;if(a.c!=b.c)return a.c>b.c?-1:1;return 0;};ZXb.Dg=function Dg(a,b,c){this.b=$wnd.Math.max(a,b);this.c=$wnd.Math.min(a,b);this.a=c;};wxb(211,1,{211:1,18:1},ZXb.Dg);_.Eb=function Eg(a){return ZXb.Cg(this,a);};_.a=0;_.b=0;_.c=0;TXb.xlb=UFb(211);ZXb.Fg=function Fg(a,b,c,d){this.a=(XXb.vTb(b),$Xb.yOb(a,Rjb(TXb.klb,xZb,6,b,15,1),b));this.b=(XXb.vTb(d),$Xb.yOb(c,Rjb(TXb.klb,xZb,6,d,15,1),d));};wxb(255,1,{255:1},ZXb.Fg);TXb.ylb=UFb(255);ZXb.Gg=function Gg(a,b){var c,d;for(d=0;d<a.g[b].length;d++){c=a.g[b][d];if(a.f[c]&&(a.o[c]==1||a.o[c]==2)&&a.k[c]==0)return true;}return false;};ZXb.Hg=function Hg(a,b,c){var d,e,f,g,h;e=0;g=0;for(h=0;h<a.g[b].length;h++){d=a.g[b][h];if(a.k[d]==c){f=1<<a.j[d];if((g&f)==0){g|=f;++e;}}}return e;};ZXb.Ig=function Ig(a){var b,c,d,e,f,g,h,i,j,k,l,m;k=new $Xb.cSb();for(l=0;l<a.i.f;l++){if(ZXb.In(a.i,l)<2||ZXb.Sn(a.i,l)>2){for(g=1;g<ZXb.Sn(a.i,l);g++){b=ZXb.Rn(a.i,l,g);for(h=0;h<g;h++){c=ZXb.Rn(a.i,l,h);ZXb.Ng(a,b,c)&&(i=ZXb.Ug(a,b,c),!!i&&ZXb.qq(i,a.f)&&$Xb.fRb(k.a,i,(UXb.hFb(),gFb))==null);}}}}for(m=0;m<a.i.g;m++){if(a.c[m]!=0){if(ZXb.bl(a.i,m)!=2||a.c[m]!=2)continue;}b=ZXb.Vk(a.i,0,m);c=ZXb.Vk(a.i,1,m);ZXb.Ng(a,b,c)&&(i=ZXb.Ug(a,b,c),!!i&&ZXb.qq(i,a.f)&&$Xb.fRb(k.a,i,(UXb.hFb(),gFb))==null);}a.g=Rjb(TXb.klb,P$b,8,k.a.c,0,2);a.e=Rjb(TXb.Bwb,JZb,6,a.i.f,16,1);f=0;for(j=(e=new $Xb.xRb(new $Xb.CRb(new $Xb.yNb(k.a).a).b),new $Xb.GNb(e));$Xb.gMb(j.a.a);){i=(d=$Xb.vRb(j.a),d.Wd());a.g[f++]=i.b;for(g=0;g<i.b.length;g++)a.e[i.b[g]]=true;}};ZXb.Jg=function Jg(a,b,c,d){var e,f,g,h,i,j,k;e=Rjb(TXb.klb,xZb,6,ZXb.Sn(a.i,c),15,1);h=0;for(g=0;g<ZXb.Sn(a.i,c);g++){e[h]=ZXb.Rn(a.i,c,g);!d[e[h]]&&ZXb.Ng(a,b,e[h])&&++h;}if(h==0)return -1;if(h==1)return e[0];i=-1;j=fZb;for(f=0;f<h;f++){k=ZXb.po(a.i,b,e[f],fZb,d);if(k<j){j=k;i=e[f];}}return i;};ZXb.Kg=function Kg(a,b){return a.f[b]&&(a.o[b]==1||a.o[b]==2);};ZXb.Lg=function Lg(a,b){return a.e[b];};ZXb.Mg=function Mg(a){var b,c;c=true;for(b=0;b<a.i.f;b++){if(a.o[b]!=0&&!a.e[b]){c=false;break;}}return c;};ZXb.Ng=function Ng(a,b,c){var d,e,f,g,h;if(b==c)return false;if(a.a[b]!=a.a[c])return false;if(a.o[b]!=0){if(a.o[b]==3||a.o[c]==3)return false;if(a.p[b]^a.o[b]!==a.o[c])return false;if(a.k[b]!==a.k[c]||a.j[b]!==a.j[c])return false;}d=ZXb.Pn(a.i,b,c);if(d!=-1){if(ZXb.bl(a.i,d)==1&&a.c[d]!=0)return false;if(ZXb.bl(a.i,d)==2&&a.c[d]==1)return false;}if(ZXb.In(a.i,b)==1&&!ZXb.Ho(a.i,b)){e=-1;for(h=0;h<ZXb.Sn(a.i,b);h++){if(ZXb.Rn(a.i,b,h)!=c&&ZXb.Un(a.i,b,h)==2){e=ZXb.Tn(a.i,b,h);break;}}f=-1;for(g=0;g<ZXb.Sn(a.i,c);g++){if(ZXb.Rn(a.i,c,g)!=b&&ZXb.Un(a.i,c,g)==2){f=ZXb.Tn(a.i,c,g);break;}}if(e!=-1&&a.c[e]!=0&&a.d[e]^a.c[e]===a.c[f])return false;}return true;};ZXb.Og=function Og(a,b,c,d,e){var f,g,h,i,j,k;i=null;f=null;for(k=0;k<a.g[b].length;k++){g=a.g[b][k];a.f[g]&&(a.o[g]==1||a.o[g]==2)&&(a.k[g]==0?f=ZXb.Wg(f,(e[g]<<16)+g):a.k[g]==d&&a.j[g]==c&&(i=ZXb.Wg(i,(e[g]<<16)+g)));}h=ZXb.jh(i,f);if(h==0)return false;if(h<0){for(j=0;j<a.g[b].length;j++){g=a.g[b][j];if(a.f[g]&&(a.o[g]==1||a.o[g]==2)){if(a.k[g]==0){a.k[g]=d<<24>>24;a.j[g]=c<<24>>24;}else if(a.k[g]==d&&a.j[g]==c){a.k[g]=0;a.j[g]=-1;}}}}return true;};ZXb.Pg=function Pg(a,b){var c,d,e,f,g,h;if(!a.b)return false;e=false;for(f=a.b.a.length-1;f>=0;f--){d=false;g=$Xb.Xi(a.b,f);g.a==2?d=ZXb.Og(a,g.b,g.c,g.d,b):g.a==1&&(d=ZXb.Tg(a,g.b,b));if(d){$Xb.dj(a.b,g);for(h=0;h<a.g[g.b].length;h++){c=a.g[g.b][h];a.n[c]=false;}e=true;}}return e;};ZXb.Qg=function Qg(a){var b,c,d,e,f,g,h,i;if(a.g!=null){g=new ZXb.ih(a);a.b=new $Xb.kj();for(e=0;e<a.g.length;e++){d=ZXb._g(g,e);if(d==0){ZXb.Xg(g,e);h=ZXb.Hg(a,e,2);b=ZXb.Hg(a,e,1);c=ZXb.Gg(a,e);if(h==1&&b==1&&!c){ZXb.Sg(a,e,g.a+g.f++);$Xb.Si(a.b,new ZXb.Ij(e,1,-1,-1));}if(h>0){if(c){ZXb.Rg(a,e,g.i+g.g++,2);++h;}$Xb.Si(a.b,new ZXb.Ij(e,1,-1,-1));}else if(b>0){c&&ZXb.Rg(a,e,g.a+g.f++,1);$Xb.Si(a.b,new ZXb.Ij(e,1,-1,-1));}else if(c){ZXb.Rg(a,e,g.a+g.f++,1);$Xb.Si(a.b,new ZXb.Ij(e,1,-1,-1));}}else if(d==1){if(ZXb.Gg(a,e)){f=ZXb.$g(g,e);i=ZXb.ah(g,e);$Xb.Si(a.b,new ZXb.Ij(e,2,f,i));}else {ZXb.Xg(g,e);$Xb.Si(a.b,new ZXb.Ij(e,1,-1,-1));}}}}};ZXb.Rg=function Rg(a,b,c,d){var e,f;for(f=0;f<a.g[b].length;f++){e=a.g[b][f];if(a.f[e]&&(a.o[e]==1||a.o[e]==2)&&a.k[e]==0){a.k[e]=d<<24>>24;a.j[e]=c<<24>>24;}}};ZXb.Sg=function Sg(a,b,c){var d,e;for(e=0;e<a.g[b].length;e++){d=a.g[b][e];if(a.k[d]==2){a.k[d]=1;a.j[d]=c<<24>>24;}}};ZXb.Tg=function Tg(a,b,c){var d,e,f,g,h,i,j,k;f=a.g[b];e=1;for(i=0;i<f.length;i++){d=f[i];if(a.f[d]&&a.k[d]==2){e=2;break;}}g=Rjb(TXb.klb,P$b,8,32,0,2);for(j=0;j<f.length;j++){d=f[j];a.f[d]&&a.k[d]==e&&(g[a.j[d]]=ZXb.Wg(g[a.j[d]],(c[d]<<16)+d));}for(k=0;k<32;k++)g[k]!=null&&XXb.eTb(g[k],XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));$Xb.QOb(g,new ZXb.kh());if(ZXb.jh(g[0],g[1])==0)return false;for(h=0;h<g[0].length;h++){d=g[0][h]&oZb;a.k[d]=0;a.j[d]=-1;}return true;};ZXb.Ug=function Ug(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;i=Rjb(TXb.klb,xZb,6,a.i.f,15,1);r=Rjb(TXb.klb,xZb,6,a.i.f,15,1);o=Rjb(TXb.Bwb,JZb,6,a.i.f,16,1);j=Rjb(TXb.Bwb,JZb,6,a.i.f,16,1);s=new ZXb.rq(a.i.f);i[0]=b;r[b]=c;r[c]=-2;s.a[b]=true;s.a[c]=true;f=0;k=0;while(f<=k){g=i[f];if(r[g]==g){for(l=0;l<ZXb.Sn(a.i,g);l++){d=ZXb.Rn(a.i,g,l);if(!s.a[d]){if(ZXb.Un(a.i,g,l)==2&&ZXb.Qk(a.i,d)<10){i[++k]=d;r[d]=d;j[d]=j[g]||ZXb.In(a.i,d)==2;o[d]=j[g]&&!o[g];s.a[d]=true;}else if(j[g]&&o[g]){t=ZXb.Jg(a,d,r[g],s.a);if(t==-1)return null;i[++k]=d;r[d]=t;r[t]=-2;j[d]=false;s.a[d]=true;s.a[t]=true;}else if(ZXb.Vo(a.i,ZXb.Tn(a.i,g,l))){i[++k]=d;r[d]=d;j[d]=false;s.a[d]=true;if((ZXb.Qk(a.i,d)==6&&ZXb.In(a.i,d)==0||ZXb.Qk(a.i,d)==7&&ZXb.zk(a.i,d)==1||ZXb.Qk(a.i,d)==14||ZXb.Qk(a.i,d)==15&&ZXb.Sn(a.i,d)>2||ZXb.Qk(a.i,d)==16&&ZXb.Sn(a.i,d)>2)&&ZXb.Sn(a.i,d)>2){h=false;for(p=1;p<ZXb.Sn(a.i,d);p++){u=ZXb.Rn(a.i,d,p);if(!s.a[u]){for(q=0;q<p;q++){v=ZXb.Rn(a.i,d,q);if(!s.a[v]){if(ZXb.Ng(a,u,v)){i[++k]=u;r[u]=v;r[v]=-2;j[u]=false;s.a[u]=true;s.a[v]=true;h=true;}}}}}if(!h)return null;}}}}}else {e=Rjb(TXb.Bwb,JZb,6,ZXb.Sn(a.i,g),16,1);for(m=0;m<ZXb.Sn(a.i,g);m++){d=ZXb.Rn(a.i,g,m);if(s.a[d]){e[m]=r[d]==d;}else {for(p=0;p<ZXb.Sn(a.i,d);p++){if(ZXb.Rn(a.i,d,p)==r[g]){e[m]=true;break;}}}}for(n=0;n<ZXb.Sn(a.i,g);n++){if(e[n]){d=ZXb.Rn(a.i,g,n);if(s.a[d]){if(ZXb.Pn(a.i,d,r[g])==-1)return null;}else {i[++k]=d;r[d]=d;o[d]=false;j[d]=true;s.a[d]=true;}}}for(l=0;l<ZXb.Sn(a.i,g);l++){if(!e[l]){d=ZXb.Rn(a.i,g,l);if(!s.a[d]){t=ZXb.Jg(a,d,r[g],s.a);if(t==-1)return null;i[++k]=d;r[d]=t;r[t]=-2;j[d]=false;s.a[d]=true;s.a[t]=true;}}}}++f;}return s;};ZXb.Vg=function Vg(a,b,c,d,e,f,g,h,i,j){this.i=a;this.a=b;this.f=c;this.o=d;this.c=e;this.k=f;this.j=g;this.p=h;this.d=i;this.n=j;ZXb.Ig(this);};ZXb.Wg=function Wg(a,b){var c,d;d=Rjb(TXb.klb,xZb,6,a==null?1:a.length+1,15,1);for(c=0;c<d.length-1;c++)d[c]=a[c];d[d.length-1]=b;return d;};wxb(492,1,{},ZXb.Vg);TXb.Alb=UFb(492);ZXb.Xg=function Xg(a,b){var c,d,e,f,g,h;for(e=0;e<a.b;e++){if(a.e[e][b]&&a.c[e]!=-3){for(d=0;d<=a.j.g.length;d++){if(d!=b&&a.e[e][d]){a.e[e][b]=false;h=e<a.a?e:e<a.b?e-a.a:-1;g=ZXb.gh(a,e<a.a?1:e<a.b?2:0);for(f=0;f<a.j.g[b].length;f++){c=a.j.g[b][f];ZXb.Kg(a.j,c)&&a.j.j[c]==h&&(a.j.j[c]=g<<24>>24);}}}}}};ZXb.Yg=function Yg(a,b,c){var d,e,f,g,h;h=false;g=1;b[c]=g;d=true;while(d){d=false;for(e=0;e<a.b;e++){if(b[e]==g){for(f=0;f<a.b;f++){if(b[f]==0&&ZXb.fh(a,e,f)){if(a.c[f]==-2){b[f]=g+1;d=true;}else if(a.c[f]!=a.c[c]){b[f]=g+1;h=true;}}}}}++g;}return h;};ZXb.Zg=function Zg(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o;for(i=d+1;i<a.j.g.length;i++){if(i!=d&&a.e[b][i]&&a.e[c][i]){g=Rjb(TXb.klb,xZb,6,2,15,1);g[0]=c;g[1]=b;return g;}}o=Rjb(TXb.klb,xZb,6,a.b,15,1);k=Rjb(TXb.klb,xZb,6,a.b,15,1);j=Rjb(TXb.klb,xZb,6,a.b,15,1);f=0;l=0;j[0]=b;k[b]=1;while(f<=l){for(m=0;m<a.d[j[f]].length;m++){e=a.d[j[f]][m];if(e==c){if(f==0)continue;h=k[j[f]]+1;g=Rjb(TXb.klb,xZb,6,h,15,1);g[0]=e;g[1]=j[f];for(n=2;n<h;n++)g[n]=o[g[n-1]];return g;}if(k[e]==0&&a.c[e]!=-3){k[e]=k[j[f]]+1;j[++l]=e;o[e]=j[f];}}++f;}return null;};ZXb.$g=function $g(a,b){var c;for(c=0;c<a.b;c++)if(a.e[c][b]&&a.c[c]==-3)return c<a.a?c:c<a.b?c-a.a:-1;return -1;};ZXb._g=function _g(a,b){var c,d;c=0;for(d=0;d<a.b;d++)a.e[d][b]&&a.c[d]==-3&&++c;return c;};ZXb.ah=function ah(a,b){var c;for(c=0;c<a.b;c++)if(a.e[c][b]&&a.c[c]==-3)return c<a.a?1:c<a.b?2:0;return -1;};ZXb.bh=function bh(a,b){return b<a.a?b:b<a.b?b-a.a:-1;};ZXb.dh=function dh(a,b){return b<a.a?1:b<a.b?2:0;};ZXb.eh=function eh(a,b){var c,d;d=a.j.k[b];c=a.j.j[b];return d==0?a.b:d==1?c:a.a+c;};ZXb.fh=function fh(a,b,c){var d;for(d=0;d<a.j.g.length;d++)if(a.e[b][d]&&a.e[c][d])return true;return false;};ZXb.gh=function gh(a,b){return b==1?a.a+a.f++:a.i+a.g++;};ZXb.hh=function hh(a,b){var c,d,e,f,g,h,i,j,k,l;k=fZb;i=-1;l=-1;j=-1;for(d=0;d<a.j.i.f;d++){if(ZXb.Kg(a.j,d)&&a.j.k[d]!=0){for(h=0;h<b.length;h++){e=ZXb.bh(a,b[h]);f=ZXb.dh(a,b[h]);if(a.j.k[d]==f&&a.j.j[d]==e){if(k>a.j.a[d]+(f==1?nZb:0)){k=a.j.a[d]+(f==1?nZb:0);i=e;l=f;j=b[h];}}}}}for(c=0;c<a.j.i.f;c++){if(ZXb.Kg(a.j,c)&&a.j.k[c]==l&&a.j.j[c]==i){a.j.k[c]=0;a.j.j[c]=-1;}}for(g=0;g<a.j.g.length;g++)a.e[j][g]=false;};ZXb.ih=function ih(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;this.j=a;for(d=0;d<a.i.f;d++){a.f[d]&&(a.o[d]==1||a.o[d]==2)&&(a.k[d]==1?this.a<=a.j[d]&&(this.a=1+a.j[d]):a.k[d]==2&&this.i<=a.j[d]&&(this.i=1+a.j[d]));}this.b=this.a+this.i;this.e=Pjb(TXb.Bwb,[_Yb,JZb],[12,6],16,[this.b+1,a.g.length+1],2);for(e=0;e<a.i.f;e++)a.f[e]&&(a.o[e]==1||a.o[e]==2)&&!a.e[e]&&(this.e[ZXb.eh(this,e)][a.g.length]=true);for(i=0;i<a.g.length;i++){for(q=0;q<a.g[i].length;q++){c=a.g[i][q];a.f[c]&&(a.o[c]==1||a.o[c]==2)&&(this.e[ZXb.eh(this,c)][i]=true);}}this.d=Rjb(TXb.klb,P$b,8,this.b,0,2);for(j=0;j<a.g.length;j++){for(n=1;n<this.b;n++){if(this.e[n][j]){for(o=0;o<n;o++){if(this.e[o][j]){this.d[n]=ZXb.Wg(this.d[n],o);this.d[o]=ZXb.Wg(this.d[o],n);}}}}}this.c=Rjb(TXb.klb,xZb,6,this.b+1,15,1);for(m=0;m<this.b;m++){this.e[m][a.g.length]?this.c[m]=-1:this.c[m]=-2;}for(k=0;k<a.g.length;k++){if(this.e[this.b][k]){for(l=0;l<this.b;l++){this.e[l][k]&&this.c[l]!=k&&(this.c[l]==-2?this.c[l]=k:this.c[l]=-3);}}}for(b=0;b<this.b;b++){if(this.c[b]>=-1){f=Rjb(TXb.klb,xZb,6,this.b,15,1);if(ZXb.Yg(this,f,b)){for(l=0;l<this.b;l++){f[l]!=0&&(this.c[l]=-3);}}}}for(h=0;h<a.g.length-1;h++){for(n=1;n<this.b;n++){if(this.e[n][h]&&this.c[n]!=-3){for(o=0;o<n;o++){if(this.e[o][h]&&this.c[o]!=-3){g=ZXb.Zg(this,n,o,h);if(g!=null){for(p=0;p<g.length;p++)this.c[g[p]]=-3;ZXb.hh(this,g);break;}}}}}}};wxb(493,1,{},ZXb.ih);_.a=0;_.b=0;_.f=0;_.g=0;_.i=0;TXb.zlb=UFb(493);ZXb.jh=function jh(a,b){var c,d;if(a==null)return b==null?0:1;if(b==null)return -1;c=$wnd.Math.min(a.length,b.length);for(d=0;d<c;d++)if((a[d]&H$b)!=(b[d]&H$b))return (a[d]&H$b)<(b[d]&H$b)?-1:1;return a.length==b.length?0:a.length<b.length?-1:1;};ZXb.kh=function kh(){};wxb(494,1,{},ZXb.kh);_.Db=function lh(a,b){return ZXb.jh(a,b);};_.ib=function mh(a){return this===a;};TXb.Blb=UFb(494);ZXb.nh=function nh(a,b){switch(b){case 0:return ZXb.oh(a,false);case 1:return ZXb.qh(a);case 2:return ZXb.ph(a);case 3:return ZXb.sh(a);case 4:return ZXb.rh(a);}return null;};ZXb.oh=function oh(b,c){try{if(!c)return ZXb.Nf(new ZXb.hg(b));b=ZXb.ru(b);ZXb.kp(b,true);ZXb.Dq(b);return ZXb.Nf(new ZXb.hg(b));}catch(a){a=Fwb(a);if(Ykb(a,28)){UXb.nIb();return null;}else throw Gwb(a);}};ZXb.ph=function ph(b){var c,d;try{b=ZXb.ru(b);ZXb.Bu(b);c=b.r;for(d=0;d<c;d++){b.H[d]=1;b.T=0;}return ZXb.Nf(new ZXb.hg(b));}catch(a){a=Fwb(a);if(Ykb(a,28)){UXb.nIb();return null;}else throw Gwb(a);}};ZXb.qh=function qh(b){try{b=ZXb.ru(b);ZXb.Bu(b);return ZXb.Nf(new ZXb.hg(b));}catch(a){a=Fwb(a);if(Ykb(a,28)){UXb.nIb();return null;}else throw Gwb(a);}};ZXb.rh=function rh(b){var c;try{b=ZXb.ru(b);ZXb.Bu(b);c=ZXb.Tu(new ZXb.Wu(b));return ZXb.Nf(new ZXb.ig(c,8));}catch(a){a=Fwb(a);if(Ykb(a,28)){UXb.nIb();return null;}else throw Gwb(a);}};ZXb.sh=function sh(b){var c;try{c=ZXb.Tu(new ZXb.Wu(b));return ZXb.Nf(new ZXb.ig(c,8));}catch(a){a=Fwb(a);if(Ykb(a,28)){UXb.nIb();return null;}else throw Gwb(a);}};ZXb.th=function th(a){var b,c,d,e;d=a.g.a.length+a.f.a.length;e=0;for(b=0;b<d;b++){c=b<a.g.a.length?$Xb.Xi(a.g,b):$Xb.Xi(a.f,b-a.g.a.length);c.q>1&&(e+=ZXb.Sk(c,c.q,c.r,(ZXb.Sj(),ZXb.Rj)));}return d>0?e/d:0;};ZXb.uh=function uh(a){var b,c,d,e,f,g,h;e=Z$b;g=Z$b;f=$$b;h=$$b;if(!a)return null;d=a.q;b=0;b=ZXb.Sk(a,a.q,a.r,(ZXb.Sj(),ZXb.Rj));for(c=0;c<d;c++){e=$wnd.Math.max(e,a.J[c].a);f=$wnd.Math.min(f,a.J[c].a);g=$wnd.Math.max(g,a.J[c].b);h=$wnd.Math.min(h,a.J[c].b);}return d>0?new kYb.KG(f,h,$wnd.Math.max(e-f,b),$wnd.Math.max(g-h,b)):null;};ZXb.vh=function vh(a){var b,c,d;if(a.length==0){return new kYb.KG(0,0,0,0);}c=ZXb.uh(a[0]);for(b=1;b<a.length;b++){d=ZXb.uh(a[b]);!!d&&(!c?c=d:c=kYb.IG(c,ZXb.uh(a[b])));}!c&&(c=new kYb.KG(0,0,0,0));return c;};ZXb.wh=function wh(a){var b,c;c=Rjb(TXb.Ilb,_$b,97,a.f.a.length,0,1);for(b=0;b<c.length;b++){c[b]=$Xb.Xi(a.f,b);}return c;};ZXb.xh=function xh(a){var b,c;c=Rjb(TXb.Ilb,_$b,97,a.g.a.length,0,1);for(b=0;b<c.length;b++){c[b]=$Xb.Xi(a.g,b);}return c;};ZXb.yh=function yh(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;if(b>d*2){p=ZXb.xh(a);m=ZXb.wh(a);u=0;t=0;k=a.g.a.length+a.f.a.length;for(i=0;i<k;i++){j=i<a.g.a.length?$Xb.Xi(a.g,i):$Xb.Xi(a.f,i-a.g.a.length);if(j.q>1){n=ZXb.uh(j);if(n){t+=n.a;u+=n.b;}}}if(t==0||u==0)return;q=b/u;r=c/t;s=q;q>r&&(s=r);e=ZXb.th(a);v=(b-d)/2;h=c;s=$wnd.Math.min(24/e,s);o=ZXb.vh(p);ZXb.Ah(p,0,0,s);o=ZXb.vh(p);f=0-o.c+(v-o.b)/2;g=0-o.d+(h-o.a)/2;ZXb.Ah(p,f,g,1);l=ZXb.vh(m);ZXb.Ah(m,0,0,s);l=ZXb.vh(m);f=v+d-l.c+(v-l.b)/2;g=0-l.d+(h-l.a)/2;ZXb.Ah(m,f,g,1);}};ZXb.zh=function zh(a,b,c,d){var e,f;e=a.q;for(f=0;f<e;f++){ZXb.sm(a,f,(a.J[f].a+b)*d);ZXb.tm(a,f,(a.J[f].b+c)*d);}};ZXb.Ah=function Ah(a,b,c,d){var e,f,g,h;for(f=a,g=0,h=f.length;g<h;++g){e=f[g];ZXb.zh(e,b,c,d);}};ZXb.Bh=function Bh(a,b,c,d){a.a+=b;a.b+=c;a.c+=d;};ZXb.Ch=function Ch(a,b){a.a+=b.a;a.b+=b.b;a.c+=b.c;return a;};ZXb.Dh=function Dh(a,b){return new ZXb.Sh(a.a+b.a,a.b+b.b,a.c+b.c);};ZXb.Eh=function Eh(a,b){a.a=(a.a+b.a)/2;a.b=(a.b+b.b)/2;a.c=(a.c+b.c)/2;return a;};ZXb.Fh=function Fh(a,b){if(a.a!=b.a)return a.a<b.a?-1:1;if(a.b!=b.b)return a.b<b.b?-1:1;if(a.c!=b.c)return a.c<b.c?-1:1;return 0;};ZXb.Gh=function Gh(a,b){return new ZXb.Sh(a.b*b.c-a.c*b.b,-(a.a*b.c-a.c*b.a),a.a*b.b-a.b*b.a);};ZXb.Hh=function Hh(a,b){return $wnd.Math.sqrt((b.a-a.a)*(b.a-a.a)+(b.b-a.b)*(b.b-a.b)+(b.c-a.c)*(b.c-a.c));};ZXb.Ih=function Ih(a,b){var c;if(b==null||!Ykb(b,32))return false;c=b;return $wnd.Math.abs(c.a-a.a)+$wnd.Math.abs(c.b-a.b)+$wnd.Math.abs(c.c-a.c)<1.0E-6;};ZXb.Jh=function Jh(a,b){var c,d,e;d=a.a*a.a+a.b*a.b+a.c*a.c;e=b.a*b.a+b.b*b.b+b.c*b.c;if(d==0||e==0)return 0;c=(a.a*b.a+a.b*b.b+a.c*b.c)/$wnd.Math.sqrt(d*e);if(c>=1)return 0;if(c<=-1)return OZb;return $wnd.Math.acos(c);};ZXb.Kh=function Kh(a,b){var c,d,e;c=a.a;d=a.b;e=a.c;a.a=c*b[0][0]+d*b[1][0]+e*b[2][0];a.b=c*b[0][1]+d*b[1][1]+e*b[2][1];a.c=c*b[0][2]+d*b[1][2]+e*b[2][2];return a;};ZXb.Lh=function Lh(a,b){a.a*=b;a.b*=b;a.c*=b;return a;};ZXb.Mh=function Mh(a,b,c,d){a.a=b;a.b=c;a.c=d;};ZXb.Nh=function Nh(a,b){ZXb.Mh(a,b.a,b.b,b.c);return a;};ZXb.Oh=function Oh(a,b){a.a-=b.a;a.b-=b.b;a.c-=b.c;return a;};ZXb.Ph=function Ph(a,b){return new ZXb.Sh(a.a-b.a,a.b-b.b,a.c-b.c);};ZXb.Qh=function Qh(a){var b;b=$wnd.Math.sqrt(a.a*a.a+a.b*a.b+a.c*a.c);if(b==0){UXb.nIb();a.a=1;a.b=0;a.c=0;return a;}a.a/=b;a.b/=b;a.c/=b;return a;};ZXb.Rh=function Rh(){};ZXb.Sh=function Sh(a,b,c){this.a=a;this.b=b;this.c=c;};ZXb.Th=function Th(a){ZXb.Sh.call(this,a.a,a.b,a.c);};wxb(32,1,{32:1,4:1,18:1},ZXb.Rh,ZXb.Sh,ZXb.Th);_.Eb=function Uh(a){return ZXb.Fh(this,a);};_.ib=function Vh(a){return ZXb.Ih(this,a);};_.lb=function Wh(){var a;a=new TYb.RKb('0.00');return '['+TYb.PKb(a,this.a)+', '+TYb.PKb(a,this.b)+', '+TYb.PKb(a,this.c)+']';};_.a=0;_.b=0;_.c=0;TXb.Dlb=UFb(32);ZXb.Xh=function Xh(a,b){b.c*=a.c;b.a=b.a*a.c+a.a;b.b=b.b*a.c+a.b;};ZXb.Yh=function Yh(a,b){ZXb.Zl(b,a.c);ZXb.Um(b,a.a,a.b);};ZXb.Zh=function Zh(a,b){b.a=b.a*a.c+a.a;b.b=b.b*a.c+a.b;};ZXb.$h=function $h(a,b){b.c=b.c*a.c+a.a;b.d=b.d*a.c+a.b;b.b*=a.c;b.a*=a.c;};ZXb._h=function _h(a){a.a=0;a.b=0;a.c=1;};ZXb.ai=function ai(a){return a.c==1&&a.a==0&&a.b==0;};ZXb.bi=function bi(a,b){return b*a.c+a.a;};ZXb.ci=function ci(a,b){return b*a.c+a.b;};ZXb.di=function di(){ZXb._h(this);};ZXb.ei=function ei(a,b){this.c=1;this.a=a;this.b=b;};ZXb.fi=function fi(a,b,c,d){var e,f,g,h;ZXb._h(this);if(b){if((d&T$b)==0){if(!(kYb.FG(b,a.c,a.d)&&kYb.FG(b,a.c+a.b,a.d+a.a))){if(a.b>b.b||a.a>b.a){f=b.b/a.b;h=b.a/a.a;this.c=$wnd.Math.min(f,h);}a.c*this.c<b.c?this.a=b.c-a.c*this.c:(a.c+a.b)*this.c>b.c+b.b&&(this.a=b.c+b.b-(a.c+a.b)*this.c);a.d*this.c<b.d?this.b=b.d-a.d*this.c:(a.d+a.a)*this.c>b.d+b.a&&(this.b=b.d+b.a-(a.d+a.a)*this.c);}}else {f=b.b/a.b;h=b.a/a.a;g=d&oZb;g==0?g=24:(d&S$b)!=0&&(g/=256);e=g/c;this.c=$wnd.Math.min(e,$wnd.Math.min(f,h));this.a=b.c+b.b/2-this.c*(a.c+a.b/2);this.b=b.d+b.a/2-this.c*(a.d+a.a/2);}}else if((d&nZb)!=0){g=(d&oZb)!=0?d&oZb:24;this.c=g/c;}};wxb(106,1,{},ZXb.di,ZXb.ei,ZXb.fi);_.lb=function gi(){return 'DepictorTransformation Offset: '+this.a+','+this.b+' Scaling: '+this.c;};_.a=0;_.b=0;_.c=0;TXb.Elb=UFb(106);ZXb.hi=function hi(a){var b,c,d,e;if(!UXb.CHb(XXb.KTb(a).substr(0,21),J$b)||(d=XXb.KTb(K$b).length,!UXb.CHb(XXb.KTb(a).substr(XXb.KTb(a).length-d,d),K$b)))return null;c=UXb.HHb(a,THb(34),21);if(c==-1)return null;e=(XXb.ETb(21,c,XXb.KTb(a).length),XXb.KTb(a).substr(21,c-21));b=UXb.QHb(a,21+XXb.KTb(e).length+1,XXb.KTb(a).length-17);if(UXb.CHb(e,'arrow'))return new iYb.IF(b);if(UXb.CHb(e,a_b))return new ZXb.jv(b);return null;};$Xb.ii=function ii(a,b,c){var d,e;for(e=a.Fb();e.Fd();){d=e.Gd();if(elb(b)===elb(d)||b!=null&&UXb.Gc(b,d)){c&&e.Hd();return true;}}return false;};$Xb.ji=function ji(a,b){var c,d;XXb.zTb(b);for(d=b.Fb();d.Fd();){c=d.Gd();if(!a.contains(c)){return false;}}return true;};$Xb.ki=function ki(a,b){var c,d,e;XXb.zTb(b);c=false;for(d=a.Fb();d.Fd();){e=d.Gd();if(b.contains(e)){d.Hd();c=true;}}return c;};$Xb.li=function li(a){var b,c,d;d=new $Xb.XQb('[',']');for(c=a.Fb();c.Fd();){b=c.Gd();$Xb.VQb(d,elb(b)===elb(a)?'(this Collection)':b==null?hZb:Dxb(b));}return !d.a?d.c:XXb.KTb(d.e).length==0?d.a.a:d.a.a+(''+d.e);};wxb(60,1,b_b);_.add=function mi(a){throw Gwb(new UXb.rIb('Add not supported on this collection'));};_.addAll=function ni(a){var b,c,d;XXb.zTb(a);b=false;for(d=a.Fb();d.Fd();){c=d.Gd();b=b|this.add(c);}return b;};_.clear=function oi(){var a;for(a=this.Fb();a.Fd();){a.Gd();a.Hd();}};_.contains=function pi(a){return $Xb.ii(this,a,false);};_.containsAll=function qi(a){return $Xb.ji(this,a);};_.isEmpty=function ri(){return this.size()==0;};_.remove=function si(a){return $Xb.ii(this,a,true);};_.removeAll=function ti(a){return $Xb.ki(this,a);};_.retainAll=function ui(a){var b,c,d;XXb.zTb(a);b=false;for(c=this.Fb();c.Fd();){d=c.Gd();if(!a.contains(d)){c.Hd();b=true;}}return b;};_.toArray=function vi(){return this.Gb(Rjb(TXb.Hub,jZb,1,this.size(),5,1));};_.Gb=function wi(a){var b,c,d,e;e=this.size();a.length<e&&(a=XXb.fTb(new Array(e),a));d=a;c=this.Fb();for(b=0;b<e;++b){Vjb(d,b,c.Gd());}a.length>e&&TXb.Ujb(a,e,null);return a;};_.lb=function xi(){return $Xb.li(this);};TXb.Wub=UFb(60);$Xb.yi=function yi(a){return new $Xb.pMb(a,0);};$Xb.zi=function zi(a,b){return new $Xb.pMb(a,b);};$Xb.Ai=function Ai(a,b,c){return new $Xb.tMb(a,b,c);};wxb(104,60,c_b);_.addAtIndex=function Bi(a,b){throw Gwb(new UXb.rIb('Add not supported on this list'));};_.add=function Ci(a){this.addAtIndex(this.size(),a);return true;};_.addAllAtIndex=function Di(a,b){var c,d,e;XXb.zTb(b);c=false;for(e=b.Fb();e.Fd();){d=e.Gd();this.addAtIndex(a++,d);c=true;}return c;};_.clear=function Ei(){this.Jb(0,this.size());};_.ib=function Fi(a){var b,c,d,e,f;if(a===this){return true;}if(!Ykb(a,121)){return false;}f=a;if(this.size()!=f.size()){return false;}e=f.Fb();for(c=this.Fb();c.Fd();){b=c.Gd();d=e.Gd();if(!(elb(b)===elb(d)||b!=null&&UXb.Gc(b,d))){return false;}}return true;};_.kb=function Gi(){return $Xb.bPb(this);};_.indexOf=function Hi(a){var b,c;for(b=0,c=this.size();b<c;++b){if($Xb.JQb(a,this.getAtIndex(b))){return b;}}return -1;};_.Fb=function Ii(){return new $Xb.jMb(this);};_.lastIndexOf=function Ji(a){var b;for(b=this.size()-1;b>-1;--b){if($Xb.JQb(a,this.getAtIndex(b))){return b;}}return -1;};_.Hb=function Ki(){return $Xb.yi(this);};_.Ib=function Li(a){return $Xb.zi(this,a);};_.removeAtIndex=function Mi(a){throw Gwb(new UXb.rIb('Remove not supported on this list'));};_.Jb=function Ni(a,b){var c,d;d=new $Xb.pMb(this,a);for(c=a;c<b;++c){XXb.xTb(d.b<d.d.size());d.d.getAtIndex(d.c=d.b++);$Xb.iMb(d);}};_.setAtIndex=function Oi(a,b){throw Gwb(new UXb.rIb('Set not supported on this list'));};_.subList=function Pi(a,b){return $Xb.Ai(this,a,b);};TXb.bvb=UFb(104);function hGb(a){if(a==null){return false;}return a.$implements__java_lang_Cloneable||Array.isArray(a);}$Xb.Qi=function Qi(a){a.a=Rjb(TXb.Hub,jZb,1,0,5,1);};$Xb.Ri=function Ri(a,b,c){XXb.BTb(b,a.a.length);XXb.$Sb(a.a,b,c);};$Xb.Si=function Si(a,b){XXb.bTb(a.a,b);return true;};$Xb.Ti=function Ti(a,b,c){var d,e;XXb.BTb(b,a.a.length);d=c.toArray();e=d.length;if(e==0){return false;}XXb._Sb(a.a,b,d);return true;};$Xb.Ui=function Ui(a,b){var c,d;c=b.toArray();d=c.length;if(d==0){return false;}XXb._Sb(a.a,a.a.length,c);return true;};$Xb.Vi=function Vi(a){XXb.dTb(a.a,0);};$Xb.Wi=function Wi(a,b){return $Xb.Zi(a,b,0)!=-1;};$Xb.Xi=function Xi(a,b){XXb.yTb(b,a.a.length);return a.a[b];};$Xb.Yi=function Yi(a,b){return $Xb.Zi(a,b,0);};$Xb.Zi=function Zi(a,b,c){for(;c<a.a.length;++c){if($Xb.JQb(b,a.a[c])){return c;}}return -1;};$Xb.$i=function $i(a){return a.a.length==0;};$Xb._i=function _i(a){return new $Xb.qOb(a);};$Xb.aj=function aj(a,b){return $Xb.bj(a,b,a.a.length-1);};$Xb.bj=function bj(a,b,c){for(;c>=0;--c){if($Xb.JQb(b,a.a[c])){return c;}}return -1;};$Xb.cj=function cj(a,b){var c;c=(XXb.yTb(b,a.a.length),a.a[b]);XXb.cTb(a.a,b,1);return c;};$Xb.dj=function dj(a,b){var c;c=$Xb.Zi(a,b,0);if(c==-1){return false;}$Xb.cj(a,c);return true;};$Xb.ej=function ej(a,b,c){var d;XXb.CTb(b,c,a.a.length);d=c-b;XXb.cTb(a.a,b,d);};$Xb.fj=function fj(a,b,c){var d;d=(XXb.yTb(b,a.a.length),a.a[b]);a.a[b]=c;return d;};$Xb.gj=function gj(a){return a.a.length;};$Xb.hj=function hj(a,b){$Xb.POb(a.a,a.a.length,b);};$Xb.ij=function ij(a){return XXb.XSb(a.a);};$Xb.jj=function jj(a,b){var c,d;d=a.a.length;b.length<d&&(b=XXb.fTb(new Array(d),b));for(c=0;c<d;++c){Vjb(b,c,a.a[c]);}b.length>d&&TXb.Ujb(b,d,null);return b;};$Xb.kj=function kj(){$Xb.Qi(this);};$Xb.lj=function lj(a){$Xb.Qi(this);XXb.tTb(a>=0,'Initial capacity must not be negative');};wxb(21,104,d_b,$Xb.kj,$Xb.lj);_.addAtIndex=function mj(a,b){$Xb.Ri(this,a,b);};_.add=function nj(a){return $Xb.Si(this,a);};_.addAllAtIndex=function oj(a,b){return $Xb.Ti(this,a,b);};_.addAll=function pj(a){return $Xb.Ui(this,a);};_.clear=function qj(){$Xb.Vi(this);};_.contains=function rj(a){return $Xb.Wi(this,a);};_.getAtIndex=function sj(a){return $Xb.Xi(this,a);};_.indexOf=function tj(a){return $Xb.Yi(this,a);};_.isEmpty=function uj(){return $Xb.$i(this);};_.Fb=function vj(){return $Xb._i(this);};_.lastIndexOf=function wj(a){return $Xb.aj(this,a);};_.removeAtIndex=function xj(a){return $Xb.cj(this,a);};_.remove=function yj(a){return $Xb.dj(this,a);};_.Jb=function zj(a,b){$Xb.ej(this,a,b);};_.setAtIndex=function Aj(a,b){return $Xb.fj(this,a,b);};_.size=function Bj(){return $Xb.gj(this);};_.toArray=function Cj(){return $Xb.ij(this);};_.Gb=function Dj(a){return $Xb.jj(this,a);};TXb.svb=UFb(21);ZXb.Ej=function Ej(a){var b,c;c=new UXb.$Hb();for(b=0;b<a.a.length;b++)UXb.ZHb(c,ZXb.$d((XXb.yTb(b,a.a.length),a.a[b]))+$Yb);return c.a;};ZXb.Fj=function Fj(b){var c;$Xb.kj.call(this);try{if(b){for(c=0;c<b.a.length;c++)$Xb.Si(this,(XXb.yTb(c,b.a.length),b.a[c]).Ab());}}catch(a){a=Fwb(a);if(!Ykb(a,19))throw Gwb(a);}};ZXb.Gj=function Gj(a){var b,c,d;$Xb.kj.call(this);if(a==null||XXb.KTb(a).length==0)return;b=0;c=UXb.GHb(a,THb(10));while(c!=-1){d=ZXb.hi((XXb.ETb(b,c,XXb.KTb(a).length),XXb.KTb(a).substr(b,c-b)));!!d&&(XXb.bTb(this.a,d),true);b=c+1;c=UXb.HHb(a,THb(10),b);}};wxb(246,21,d_b,ZXb.Fj,ZXb.Gj);_.lb=function Hj(){return ZXb.Ej(this);};TXb.Flb=UFb(246);ZXb.Ij=function Ij(a,b,c,d){this.b=a;this.a=b;this.c=c;this.d=d;};wxb(125,1,{125:1},ZXb.Ij);_.a=0;_.b=0;_.c=0;_.d=0;TXb.Glb=UFb(125);ZXb.Jj=function Jj(a){var b,c,d,e,f,g;if(a.j!=0)return a.j;if(a.i&&ZXb.Qk(a.e,a.a)!=15&&ZXb.Qk(a.e,a.a)!=16){for(g=0;g<ZXb.Dn(a.e,a.a);g++){f=ZXb.Tn(a.e,a.a,g);if(ZXb.Ml(a.e,f,a.a)){ZXb.Rn(a.e,a.a,g)==a.b?a.j=ZXb.el(a.e,f)==257?3:1:a.j=ZXb.el(a.e,f)==257?1:3;return a.j;}}}b=ZXb.Uk(a.e,a.a,a.g);d=ZXb.Uk(a.e,a.a,a.b);d<b&&(d+=NZb);if(ZXb.Dn(a.e,a.a)==2){c=d-b;if(c>3.0915926535897933&&c<3.191592653589793){a.j=-1;return a.j;}a.j=c<OZb?4:2;return a.j;}else {e=ZXb.Uk(a.e,a.a,a.d);e<b&&(e+=NZb);a.j=e<d?2:4;return a.j;}};ZXb.Kj=function Kj(a,b,c,d){var e,f,g,h;this.e=a;this.g=c;this.a=d;g=-1;for(h=0;h<ZXb.Dn(this.e,this.a);h++){e=ZXb.Rn(this.e,this.a,h);f=ZXb.Tn(this.e,this.a,h);if(e==this.g){ZXb.el(this.e,f)==386&&(this.j=-1);continue;}if(ZXb.Ml(this.e,f,this.a)){this.i&&(a.u[d]|=nZb);this.i=true;}if(g==b[e]){this.d=e;this.f=true;this.c=ZXb.Vo(this.e,f);}else if(g<b[e]){g=b[e];this.d=this.b;this.b=e;}else {this.d=e;}}};wxb(143,1,{},ZXb.Kj);_.a=0;_.b=0;_.c=false;_.d=0;_.f=false;_.g=0;_.i=false;_.j=0;TXb.Hlb=UFb(143);ZXb.Sj=function Sj(){ZXb.Sj=yxb;ZXb.Mj=Zjb(Ljb(TXb.Nub,1),mZb,2,6,['?','H','He','Li','Be','B','C','N','O','F','Ne','Na','Mg','Al','Si','P','S','Cl','Ar','K','Ca','Sc','Ti','V','Cr','Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As','Se','Br','Kr','Rb','Sr','Y','Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn','Sb','Te','I','Xe','Cs','Ba','La','Ce','Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb','Lu','Hf','Ta','W','Re','Os','Ir','Pt','Au','Hg','Tl','Pb','Bi','Po','At','Rn','Fr','Ra','Ac','Th','Pa','U','Np','Pu','Am','Cm','Bk','Cf','Es','Fm','Md','No','Lr','Rf','Db','Sg','Bh','Hs','Mt','Ds','Rg','Cn','Nh','Fl','Mc','Lv','Ts','Og',e_b,e_b,e_b,e_b,e_b,e_b,e_b,e_b,e_b,e_b,'R4','R5','R6','R7','R8','R9','R10','R11','R12','R13','R14','R15','R16','R1','R2','R3','A','A1','A2','A3',e_b,e_b,'D','T','X','R','H2','H+','Nnn','HYD','Pol',e_b,e_b,e_b,e_b,e_b,e_b,e_b,e_b,e_b,e_b,e_b,'Ala','Arg','Asn','Asp','Cys','Gln','Glu','Gly','His','Ile','Leu','Lys','Met','Phe','Pro','Ser','Thr','Trp','Tyr','Val']);ZXb.Qj=Zjb(Ljb(TXb.Awb,1),L$b,6,15,[0,1,4,7,9,11,12,14,16,19,20,23,24,27,28,31,32,35,40,39,40,45,48,51,52,55,56,59,58,63,64,69,74,75,80,79,84,85,88,89,90,93,98,0,102,103,106,107,114,115,120,121,130,127,132,133,138,139,140,141,142,0,152,153,158,159,164,165,166,169,174,175,180,181,184,187,192,193,195,197,202,205,208,209,209,210,222,223,226,227,232,231,238,237,244,243,247,247,251,252,257,258,259,262,267,268,271,270,277,276,281,281,283,285,289,289,293,294,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,156,114,115,103,128,129,57,137,113,113,128,131,147,97,87,101,186,163,99]);ZXb.Pj=Zjb(Ljb(TXb.glb,1),R$b,6,15,[6]);ZXb.Lj=Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]);ZXb.Nj=Zjb(Ljb(TXb.glb,2),_Yb,10,0,[null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[0]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[0]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,5]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,4,6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1,3,5,7]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[0]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),null,null,null,null,null,null,null,null,null,null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,5]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,4,6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1,3,5,7]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[0,2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),null,null,null,null,null,null,null,null,null,null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[1,2,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,5]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,4,6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1,3,5,7]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[0,2,4,6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2])]);ZXb.Oj=Zjb(Ljb(TXb.glb,2),_Yb,10,0,[null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),null,null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[-3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-1]),null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[-3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-1]),null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3,4,5]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3,6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3,4,7]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1,2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-3,3,5]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-1]),null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,5]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[4,6,7]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-3,3,5]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-2,4,6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-1]),null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[5]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[4,6,7]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1,2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[1,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,5]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-2,2,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[-1,1]),null,Zjb(Ljb(TXb.glb,1),R$b,6,15,[1]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[4,5]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,4,5,6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,4,5,6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,4,5,6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,4,5,6]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3,4]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[2,3]),Zjb(Ljb(TXb.glb,1),R$b,6,15,[3])]);};ZXb.Tj=function Tj(a,b,c,d){var e;e=ZXb.Uj(a,6);ZXb.Mh(a.J[e],b,c,d);return e;};ZXb.Uj=function Uj(a,b){a.q>=a.M&&ZXb.Km(a,a.M*2);a.C[a.q]=0;ZXb.vm(a,a.q,b);a.s[a.q]=0;a.u[a.q]=0;a.B[a.q]=0;a.w[a.q]=0;ZXb.Mh(a.J[a.q],0,0,0);a.v!=null&&(a.v[a.q]=null);a.t!=null&&(a.t[a.q]=null);a.T=0;return a.q++;};ZXb.Vj=function Vj(a,b,c){return ZXb.Wj(a,b,c,ZXb.Fl(a,b)||ZXb.Fl(a,c)?32:1);};ZXb.Wj=function Wj(a,b,c,d){var e;if(b==c)return -1;for(e=0;e<a.r;e++){if(a.D[0][e]==b&&a.D[1][e]==c||a.D[0][e]==c&&a.D[1][e]==b){a.H[e]<d&&(a.H[e]=d);return e;}}a.r>=a.N&&ZXb.Lm(a,a.N*2);a.D[0][a.r]=b;a.D[1][a.r]=c;a.H[a.r]=d;a.F[a.r]=0;a.G[a.r]=0;a.T=0;return a.r++;};ZXb.Xj=function Xj(a,b){return ZXb.Yj(a,b,b.q,b.r);};ZXb.Yj=function Yj(a,b,c,d){var e,f,g,h,i;a.K=a.K|b.K;f=Rjb(TXb.klb,xZb,6,b.q,15,1);h=ZXb.Yl(a,1);i=ZXb.Yl(a,2);for(e=0;e<c;e++){f[e]=ZXb.jk(b,a,e,h,i);}for(g=0;g<d;g++){ZXb.kk(b,a,g,h,i,f[b.D[0][g]],f[b.D[1][g]],false);}a.L=a.L&&b.L;a.I=0;a.T=0;return f;};ZXb.Zj=function Zj(a,b,c,d,e,f,g,h){var i,j;i=ZXb.vk(a,b,c);if(i==-1){a.q>=a.M&&ZXb.Km(a,a.M*2);i=ZXb.Uj(a,d);ZXb.Mh(a.J[i],b,c,0);a.A[i]=e;ZXb.am(a,i,f);ZXb.pm(a,i,g);ZXb.fm(a,i,h);return true;}j=ZXb.ek(a,i,d,e,f,g);ZXb.fm(a,i,h);return j;};ZXb.$j=function $j(a,b,c,d){var e;for(e=0;e<a.r;e++){if(a.D[0][e]==b&&a.D[1][e]==c||a.D[0][e]==c&&a.D[1][e]==b){ZXb.gk(a,e,d);a.T=0;return e;}}a.r>=a.N&&ZXb.Lm(a,a.N*2);a.D[0][a.r]=b;a.D[1][a.r]=c;a.H[a.r]=d;a.F[a.r]=0;a.G[a.r]=0;a.T=0;return a.r++;};ZXb._j=function _j(a,b,c,d,e,f){var g,h,i;while(a.q+d>a.M)ZXb.Km(a,a.M*2);while(a.r+d>a.N)ZXb.Lm(a,a.N*2);g=ZXb.vk(a,b,c);if(g!=-1)return ZXb.ak(a,g,d,e,f);h=ZXb.wk(a,b,c);if(h!=-1)return ZXb.bk(a,h,d,e,f);g=ZXb.Tj(a,b,c,0);i=OZb*(d-2)/d;ZXb.Ql(a,g,d,g,e,0,OZb-i,f);a.T=0;return true;};ZXb.ak=function ak(a,b,c,d,e){var f,g,h,i,j,k;if(d&&ZXb.ko(a,b)>1||!d&&ZXb.ko(a,b)>2)return false;g=0;f=Rjb(TXb.ilb,vZb,6,4,15,1);for(i=0;i<a.r;i++){for(j=0;j<2;j++){if(a.D[j][i]==b){if(g==2){g=3;break;}f[g++]=ZXb.Uk(a,b,a.D[1-j][i]);}}if(g==3)break;}if(g==3)return false;k=g==1?f[0]+OZb:$wnd.Math.abs(f[0]-f[1])>OZb?(f[0]+f[1])/2:(f[0]+f[1])/2+OZb;h=OZb*(c-2)/c;ZXb.Ql(a,b,c,b,d,k-h/2,OZb-h,e);a.T=0;return true;};ZXb.bk=function bk(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p;j=Rjb(TXb.klb,xZb,6,2,15,1);i=Rjb(TXb.ilb,vZb,6,2,15,1);j[0]=a.D[0][b];j[1]=a.D[1][b];if(ZXb.ko(a,j[0])>3)return false;if(ZXb.ko(a,j[1])>3)return false;g=0;f=Rjb(TXb.ilb,vZb,6,4,15,1);for(m=0;m<a.r;m++){if(m==b)continue;for(n=0;n<2;n++){for(o=0;o<2;o++){if(a.D[n][m]==j[o]){if(g==4){g=5;break;}f[g++]=ZXb.Uk(a,j[o],a.D[1-n][m]);}}if(g==5)break;}if(g==5)break;}if(g==5)return false;i[0]=ZXb.Uk(a,j[0],j[1]);if(i[0]<0){i[1]=i[0]+OZb;h=0;}else {i[1]=i[0];i[0]=i[1]-OZb;h=1;}p=0;for(l=0;l<g;l++){f[l]>i[0]&&f[l]<i[1]?--p:++p;}h=p>0?1-h:h;k=OZb*(c-2)/c;ZXb.Ql(a,j[h],c-1,j[1-h],d,i[p>0?0:1]+OZb-k,OZb-k,e);a.T=0;return true;};ZXb.ck=function ck(a,b,c){var d,e,f,g,h;e=Rjb(TXb.klb,xZb,6,b.q,15,1);g=ZXb.Yl(a,1);h=ZXb.Yl(a,2);for(d=0;d<b.q;d++){b.C[d]!=0?e[d]=ZXb.jk(b,a,d,g,h):e[d]=c;}for(f=0;f<b.r;f++){ZXb.kk(b,a,f,g,h,e[b.D[0][f]],e[b.D[1][f]],false);}a.L=a.L&&b.L;a.I=0;a.T=0;return e;};ZXb.dk=function dk(a,b){var c,d,e,f,g,h,i,j,k;c=a.J[b[0]];d=a.J[b[1]];e=a.J[b[2]];f=a.J[b[3]];i=new ZXb.Sh(d.a-c.a,d.b-c.b,d.c-c.c);j=new ZXb.Sh(e.a-d.a,e.b-d.b,e.c-d.c);k=new ZXb.Sh(f.a-e.a,f.b-e.b,f.c-e.c);g=new ZXb.Sh(i.b*j.c-i.c*j.b,-(i.a*j.c-i.c*j.a),i.a*j.b-i.b*j.a);h=new ZXb.Sh(j.b*k.c-j.c*k.b,-(j.a*k.c-j.c*k.a),j.a*k.b-j.b*k.a);return -$wnd.Math.atan2($wnd.Math.sqrt(j.a*j.a+j.b*j.b+j.c*j.c)*(i.a*h.a+i.b*h.b+i.c*h.c),g.a*h.a+g.b*h.b+g.c*h.c);};ZXb.ek=function ek(a,b,c,d,e,f){if((c==1||c==151||c==152)&&ZXb.ko(a,b)>1)return false;a.B[b]=Iwb(a.B[b],-2);a.v!=null&&(a.v[b]=null);a.t!=null&&(a.t[b]=null);if(c==a.C[b]&&d==a.A[b]&&e==((a.u[b]&f_b)>>>27)-1&&f==(a.u[b]&48))return false;if(c==151||c==152){d=c-149;c=1;}a.u[b]&=960;a.C[b]=c;a.A[b]=d;a.s[b]=0;a.B[b]=0;ZXb.am(a,b,e);ZXb.pm(a,b,f);ZXb.Wl(a,a.w[b]);a.T=0;return true;};ZXb.fk=function fk(a,b,c){if(c){if(a.s[b]>8)return false;++a.s[b];}else {if(a.s[b]<-8)return false;--a.s[b];}a.T=0;return true;};ZXb.gk=function gk(a,b,c){var d,e,f,g,h;f=false;g=a.H[b];if(c==511){f=ZXb.nl(a,b);}else if(ZXb.np(a,b,c)){if(c==257||c==129){d=ZXb.Rl(a,b,a.D[0][b]);e=ZXb.Rl(a,b,a.D[1][b]);if(c==g){if(d==e||e){h=a.D[0][b];a.D[0][b]=a.D[1][b];a.D[1][b]=h;f=true;}}else {if(!d&&e){h=a.D[0][b];a.D[0][b]=a.D[1][b];a.D[1][b]=h;}a.H[b]=c;f=true;}}else {a.H[b]=c;f=true;}}if(f){a.T=(g&127)==(c&127)?a.T&7:0;a.G[b]=0;}return f;};ZXb.hk=function hk(a){a.q=0;a.r=0;a.K=false;a.L=false;a.I=0;a.v=null;a.t=null;a.P=null;a.T=0;};ZXb.ik=function ik(a){var b,c,d,e,f,g,h,i;for(g=0;g<a.r;g++){if(a.H[g]==512){c=a.D[0][g];d=a.D[1][g];if(a.C[c]==-1^a.C[d]==-1){if(a.s[c]!=0&&a.s[d]!=0){if(a.s[c]<0^a.s[d]<0){if(a.s[c]<0){++a.s[c];--a.s[d];}else {--a.s[c];++a.s[d];}}}}}}i=Rjb(TXb.klb,xZb,6,a.q,15,1);e=0;for(b=0;b<a.q;b++){if(a.C[b]==-1){i[b]=-1;continue;}if(e<b){a.C[e]=a.C[b];a.s[e]=a.s[b];a.A[e]=a.A[b];a.u[e]=a.u[b];a.B[e]=a.B[b];a.w[e]=a.w[b];ZXb.Nh(a.J[e],a.J[b]);a.v!=null&&(a.v[e]=a.v[b]);a.t!=null&&(a.t[e]=a.t[b]);}i[b]=e;++e;}a.q=e;h=0;for(f=0;f<a.r;f++){if(a.H[f]==512)continue;a.H[h]=a.H[f];a.F[h]=a.F[f];a.G[h]=a.G[f];a.D[0][h]=i[a.D[0][f]];a.D[1][h]=i[a.D[1][f]];++h;}a.r=h;return i;};ZXb.jk=function jk(a,b,c,d,e){var f,g,h;f=b.q;f>=b.M&&ZXb.Km(b,b.M*2);h=(a.u[c]&D$b)>>18;g=-1;h==1?d==-1?g=ZXb.Yl(b,h):g=$wnd.Math.min(31,d+((a.u[c]&D$b)>>18!=1&&(a.u[c]&D$b)>>18!=2?-1:(a.u[c]&g_b)>>20)):h==2&&(e==-1?g=ZXb.Yl(b,h):g=$wnd.Math.min(31,e+((a.u[c]&D$b)>>18!=1&&(a.u[c]&D$b)>>18!=2?-1:(a.u[c]&g_b)>>20)));b.C[f]=a.C[c];b.s[f]=a.s[c];b.A[f]=a.A[c];b.u[f]=a.u[c];b.B[f]=b.K?a.B[c]:0;ZXb.Nh(b.J[f],a.J[c]);b.w[f]=a.w[c];b.v!=null&&(b.v[f]=null);if(a.v!=null&&a.v[c]!=null&&b.K){b.v==null&&(b.v=Rjb(TXb.klb,P$b,8,b.C.length,0,2));b.v[f]=$Xb.wOb(a.v[c],a.v[c].length);}b.t!=null&&(b.t[f]=null);if(a.t!=null&&a.t[c]!=null){b.t==null&&(b.t=Rjb(TXb.glb,_Yb,10,b.C.length,0,2));b.t[f]=$Xb.uOb(a.t[c],a.t[c].length);}if(g!=-1){b.u[f]&=-32505857;b.u[f]|=g<<20;}++b.q;b.T=0;return f;};ZXb.kk=function kk(a,b,c,d,e,f,g,h){var i,j,k,l;j=b.r;j>=b.N&&ZXb.Lm(b,b.N*2);l=(a.F[c]&768)>>8;k=-1;l==1&&(d==-1?k=ZXb.Yl(b,l):k=$wnd.Math.min(32,d+((a.F[c]&768)>>8!=1&&(a.F[c]&768)>>8!=2?-1:(a.F[c]&h_b)>>10)));l==2&&(e==-1?k=ZXb.Yl(b,l):k=$wnd.Math.min(32,e+((a.F[c]&768)>>8!=1&&(a.F[c]&768)>>8!=2?-1:(a.F[c]&h_b)>>10)));b.D[0][j]=f;b.D[1][j]=g;i=h&&a.Lb(c)?64:a.H[c];b.H[j]=i;b.F[j]=a.F[c];b.G[j]=b.K?a.G[c]:0;if(k!=-1){b.F[j]&=-31745;b.F[j]|=k<<10;}++b.r;b.T=0;return j;};ZXb.lk=function lk(a,b,c,d,e,f,g){return ZXb.kk(a,b,c,d,e,f==null?a.D[0][c]:f[a.D[0][c]],f==null?a.D[1][c]:f[a.D[1][c]],g);};ZXb.mk=function mk(a,b){var c,d;b.v=null;b.t=null;b.K=a.K;b.q=0;for(c=0;c<a.q;c++)ZXb.jk(a,b,c,0,0);b.r=0;for(d=0;d<a.r;d++)ZXb.kk(a,b,d,0,0,a.D[0][d],a.D[1][d],false);a.Kb(b);};ZXb.nk=function nk(a,b){b.K=a.K;b.L=a.L;b.S=a.S;b.I=a.I;b.P=a.P;b.T=a.T&24;};ZXb.ok=function ok(a,b){var c,d,e,f;for(c=0;c<a.r;c++){for(e=0;e<2;e++){if(a.D[e][c]==b){a.H[c]=512;d=0;for(f=0;f<a.r;f++){if(f==c)continue;(a.D[0][f]===a.D[1-e][c]||a.D[1][f]===a.D[1-e][c])&&++d;}if(d==0){ZXb.Wl(a,a.w[a.D[1-e][c]]);a.C[a.D[1-e][c]]=-1;}}}}ZXb.Wl(a,a.w[b]);a.C[b]=-1;a.v!=null&&(a.v[b]=null);a.t!=null&&(a.t[b]=null);ZXb.ik(a);a.T=0;};ZXb.pk=function pk(a,b,c){var d,e;d=ZXb.vk(a,b,c);if(d!=-1){(a.u[d]&512)!=0?ZXb.uk(a):ZXb.ok(a,d);a.T=0;return true;}e=ZXb.wk(a,b,c);if(e!=-1){(a.u[a.D[0][e]]&a.u[a.D[1][e]]&512)!=0?ZXb.uk(a):ZXb.sk(a,e);a.T=0;return true;}return false;};ZXb.qk=function qk(a,b){var c,d,e,f;if(b.length==0)return null;for(d=b,e=0,f=d.length;e<f;++e){c=d[e];a.C[c]=-1;}return ZXb.tk(a);};ZXb.rk=function rk(a,b){a.H[b]=512;ZXb.ik(a);a.T=0;};ZXb.sk=function sk(a,b){var c,d,e;for(d=0;d<2;d++){c=0;for(e=0;e<a.r;e++){if(e==b)continue;(a.D[0][e]===a.D[d][b]||a.D[1][e]===a.D[d][b])&&++c;}if(c==0){ZXb.Wl(a,a.w[a.D[d][b]]);a.C[a.D[d][b]]=-1;}}a.H[b]=512;ZXb.ik(a);a.T=0;};ZXb.tk=function tk(a){var b,c,d;d=false;for(b=0;b<a.q;b++){if(a.C[b]==-1){d=true;ZXb.Wl(a,a.w[b]);}}for(c=0;c<a.r;c++){if(a.H[c]==512){d=true;}else if(a.C[a.D[0][c]]==-1||a.C[a.D[1][c]]==-1){a.H[c]=512;d=true;}}if(d){a.T=0;return ZXb.ik(a);}return null;};ZXb.uk=function uk(a){var b,c;c=false;for(b=0;b<a.q;b++){if((a.u[b]&512)!=0){a.C[b]=-1;c=true;}}return c&&ZXb.tk(a)!=null;};ZXb.vk=function vk(a,b,c){var d,e,f,g,h,i,j,k;g=-1;e=ZXb.Sk(a,a.q,a.r,ZXb.Rj);h=$$b;i=e*e/12;for(d=0;d<a.q;d++){j=a.J[d].a;k=a.J[d].b;f=(b-j)*(b-j)+(c-k)*(c-k);if(f<i&&f<h){h=f;g=d;}}return g;};ZXb.wk=function wk(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;m=-1;o=ZXb.Sk(a,a.q,a.r,ZXb.Rj);n=$$b;for(d=0;d<a.r;d++){p=a.J[a.D[0][d]].a;r=a.J[a.D[0][d]].b;q=a.J[a.D[1][d]].a;s=a.J[a.D[1][d]].b;k=q-p;l=s-r;e=$wnd.Math.sqrt(k*k+l*l);f=(p+q)/2;g=(r+s)/2;k=b-f;l=c-g;if($wnd.Math.sqrt(k*k+l*l)>e/2)continue;if(q==p)j=$wnd.Math.abs(p-b);else {h=(s-r)/(p-q);i=-h*p-r;j=$wnd.Math.abs((h*b+c+i)/$wnd.Math.sqrt(h*h+1));}if(j<o&&j<n){n=j;m=d;}}return m;};ZXb.xk=function xk(a,b){return ((a.u[b]&f_b)>>>27)-1;};ZXb.yk=function yk(a,b){return (a.u[b]&49152)>>14;};ZXb.zk=function zk(a,b){return a.s[b];};ZXb.Ak=function Ak(a,b){return a.u[b]&448;};ZXb.Bk=function Bk(a,b){return a.t==null?null:a.t[b]==null?null:UXb.AHb(a.t[b]);};ZXb.Ck=function Ck(a,b){return a.t==null?null:a.t[b];};ZXb.Dk=function Dk(a,b){return (a.u[b]&D$b)>>18!=1&&(a.u[b]&D$b)>>18!=2?-1:(a.u[b]&g_b)>>20;};ZXb.Ek=function Ek(a,b){return (a.u[b]&D$b)>>18;};ZXb.Fk=function Fk(a,b){return ZXb.Mj[a.C[b]];};ZXb.Gk=function Gk(a,b){return a.v==null?null:a.v[b];};ZXb.Hk=function Hk(a,b){var c,d,e;if(a.v==null||a.v[b]==null)return bxb(Iwb(a.B[b],1),0)?'':ZXb.Mj[a.C[b]];e='';for(d=0;d<a.v[b].length;d++){d>0&&(e=(XXb.zTb(e),e+(XXb.zTb(','),',')));c=a.v[b][d];e=UXb.zHb(e,ZXb.Mj[c]);}return e;};ZXb.Ik=function Ik(a,b){return $wnd.Math.abs(a.w[b]);};ZXb.Jk=function Jk(a,b){return a.A[b];};ZXb.Kk=function Kk(a,b){return a.u[b]&3;};ZXb.Lk=function Lk(a,b){return a.B[b];};ZXb.Mk=function Mk(a,b){return a.u[b]&48;};ZXb.Nk=function Nk(a,b){return a.J[b].a;};ZXb.Ok=function Ok(a,b){return a.J[b].b;};ZXb.Pk=function Pk(a,b){return a.J[b].c;};ZXb.Qk=function Qk(a,b){return a.C[b];};ZXb.Rk=function Rk(a){return ZXb.Sk(a,a.q,a.r,ZXb.Rj);};ZXb.Sk=function Sk(a,b,c,d){return ZXb.Tk(a,b,c,d,a.J);};ZXb.Tk=function Tk(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o;l=false;m=0;for(j=0;j<c;j++)a.H[j]!=32&&(a.G[j]&y$b)==0&&++m;if(m==0){for(k=0;k<c;k++)(a.G[k]&y$b)==0&&++m;l=true;}if(m==0){if(b<2)return d;o=$$b;for(f=1;f<b;f++){for(g=0;g<f;g++){n=ZXb.Hh(e[f],e[g]);n>0&&n<o&&(o=n);}}return o!=$$b?0.6*o:d;}h=0;for(i=0;i<c;i++){(l||a.H[i]!=32)&&(a.G[i]&y$b)==0&&(h+=ZXb.Hh(e[a.D[1][i]],e[a.D[0][i]]));}return h/m;};ZXb.Uk=function Uk(a,b,c){return ZXb.fn(a.J[b].a,a.J[b].b,a.J[c].a,a.J[c].b);};ZXb.Vk=function Vk(a,b,c){return a.D[b][c];};ZXb.Wk=function Wk(a,b){return ((a.G[b]&7680)>>9)+((a.G[b]&122880)>>13);};ZXb.Xk=function Xk(a,b){return (a.G[b]&7680)>>9;};ZXb.Yk=function Yk(a,b){return (a.F[b]&48)>>4;};ZXb.Zk=function Zk(a,b){return (a.F[b]&768)>>8!=1&&(a.F[b]&768)>>8!=2?-1:(a.F[b]&h_b)>>10;};ZXb.$k=function $k(a,b){return (a.F[b]&768)>>8;};ZXb._k=function _k(a,b){var c,d,e,f;c=a.D[0][b];d=a.D[1][b];e=a.J[d].a-a.J[c].a;f=a.J[d].b-a.J[c].b;return $wnd.Math.sqrt(e*e+f*f);};ZXb.al=function al(a,b,c){var d;for(d=0;d<a.r;d++)if(a.D[0][d]==b&&a.D[1][d]==c||a.D[0][d]==c&&a.D[1][d]==b)if(a.H[d]!=512)return d;return -1;};ZXb.bl=function bl(a,b){switch(a.H[b]&127){case 1:case 64:return 1;case 2:return 2;case 4:return 3;case 8:return 4;case 16:return 5;default:return 0;}};ZXb.cl=function cl(a,b){return a.F[b]&3;};ZXb.dl=function dl(a,b){return a.G[b];};ZXb.el=function el(a,b){return a.H[b];};ZXb.fl=function fl(a,b){return a.H[b]&127;};ZXb.gl=function gl(a,b){var c,d,e,f,g;if(a.q==0)return null;d=a.J[0].a;f=a.J[0].b;e=a.J[0].a;g=a.J[0].b;for(c=1;c<a.q;c++){d>a.J[c].a?d=a.J[c].a:e<a.J[c].a&&(e=a.J[c].a);f>a.J[c].b?f=a.J[c].b:g<a.J[c].b&&(g=a.J[c].b);}if(!b){b=new kYb.KG(d,f,e-d,g-f);}else {b.c=d;b.d=f;b.b=e-d;b.a=g-f;}return b;};ZXb.hl=function hl(a,b){var c;c=a.C[b]<ZXb.Nj.length?ZXb.Nj[a.C[b]]:null;return c==null?6:c[c.length-1];};ZXb.il=function il(a,b,c){var d,e;if(a.C[b]>=171&&a.C[b]<=190)return 0;e=0;(a.u[b]&48)==32&&(e-=1);((a.u[b]&48)==16||(a.u[b]&48)==48)&&(e-=2);d=a.s[b];if(d==0&&a.K){Swb(Iwb(a.B[b],XZb),$Zb)&&(d=-1);Swb(Iwb(a.B[b],XZb),ZZb)&&(d=1);}a.C[b]==7||a.C[b]==8||a.C[b]==9?e+=d:a.C[b]==6||a.C[b]==14||a.C[b]==32?e-=$wnd.Math.abs(d):a.C[b]==15||a.C[b]==33?c-e-d<=3?e+=d:e-=d:a.C[b]==16||a.C[b]==34||a.C[b]==52?c-e-d<=4?e+=d:e-=$wnd.Math.abs(d):a.C[b]==17||a.C[b]==35||a.C[b]==53?c-e-d<=5?e+=d:e-=$wnd.Math.abs(d):e-=d;return e;};ZXb.jl=function jl(a,b){var c;c=ZXb.kl(a,b);return c+ZXb.il(a,b,c);};ZXb.kl=function kl(a,b){var c,d;c=((a.u[b]&f_b)>>>27)-1;c==-1&&(c=(d=a.C[b]<ZXb.Nj.length?ZXb.Nj[a.C[b]]:null,d==null?6:d[d.length-1]));return c;};ZXb.ll=function ll(a,b){var c,d,e,f,g;f=ZXb.Nl(a,a.D[0][b])||ZXb.Nl(a,a.D[1][b])?5:3;for(d=0;d<2;d++){c=a.D[d][b];e=ZXb.bl(a,b)+(g=ZXb.kl(a,c),g+ZXb.il(a,c,g))-ZXb.ko(a,c);f>e&&(f=e);}return f;};ZXb.ml=function ml(a,b){return (a.u[b]&nZb)!=0;};ZXb.nl=function nl(a,b){var c,d,e;d=ZXb.ll(a,b);c=ZXb.Fl(a,a.D[0][b])||ZXb.Fl(a,a.D[1][b]);e=c?32:1;if(a.H[b]==16){a.H[b]=e;a.T=0;return true;}if(a.H[b]==8){a.H[b]=d>4?16:e;a.T=0;return true;}if(a.H[b]==4){a.H[b]=d>3?8:e;a.T=0;return true;}if(a.H[b]==2){a.H[b]=386;a.T&=7;if((a.F[b]&128)==0)return true;}if(a.H[b]==386){d>2?a.H[b]=4:a.H[b]=e;a.T=0;return true;}if((384&a.H[b])!=0){a.H[b]=1;a.T&=7;return true;}if(!c&&d<2)return false;if(a.H[b]==1){a.H[b]=2;a.T=0;return true;}if(d<1)return false;if(a.H[b]==32){a.H[b]=1;a.T=0;return true;}return false;};ZXb.ol=function ol(a){var b;a.T=0;a.C=Rjb(TXb.klb,xZb,6,a.M,15,1);a.s=Rjb(TXb.klb,xZb,6,a.M,15,1);a.w=Rjb(TXb.klb,xZb,6,a.M,15,1);a.J=Rjb(TXb.Dlb,i_b,32,a.M,0,1);for(b=0;b<a.M;b++)a.J[b]=new ZXb.Rh();a.A=Rjb(TXb.klb,xZb,6,a.M,15,1);a.u=Rjb(TXb.klb,xZb,6,a.M,15,1);a.B=Rjb(TXb.llb,M$b,6,a.M,14,1);a.v=null;a.t=null;a.D=Pjb(TXb.klb,[P$b,xZb],[8,6],15,[2,a.N],2);a.H=Rjb(TXb.klb,xZb,6,a.N,15,1);a.F=Rjb(TXb.klb,xZb,6,a.N,15,1);a.G=Rjb(TXb.klb,xZb,6,a.N,15,1);};ZXb.pl=function pl(a,b){a.T&=~b;};ZXb.ql=function ql(a){var b;for(b=0;b<a.q;b++)if(a.J[b].c!=0)return true;return false;};ZXb.rl=function rl(a,b){return (a.u[b]&j_b)!=0;};ZXb.sl=function sl(a,b){return a.C[b]==-1;};ZXb.tl=function tl(a,b){return (a.u[b]&4)!=0;};ZXb.ul=function ul(a,b){return (a.u[b]&k_b)!=0;};ZXb.vl=function vl(a,b){return a.w[b]<0;};ZXb.wl=function wl(a,b){return (a.F[b]&l_b)!=0;};ZXb.xl=function xl(a,b){return (a.G[b]&y$b)!=0;};ZXb.yl=function yl(a,b){return (a.F[b]&nZb)!=0;};ZXb.zl=function zl(a,b){return a.H[b]==512;};ZXb.Al=function Al(a,b){return (a.F[b]&4)!=0;};ZXb.Bl=function Bl(a,b){return (a.F[b]&S$b)!=0;};ZXb.Cl=function Cl(a,b){var c,d,e,f;if(a.K){if(bxb(Iwb(a.B[b],1),0))return false;if(a.v!=null&&a.v[b]!=null)for(d=a.v[b],e=0,f=d.length;e<f;++e){c=d[e];if(!ZXb.jn(c))return false;}}return ZXb.jn(a.C[b]);};ZXb.Dl=function Dl(a,b){var c,d,e,f;if(a.K){if(bxb(Iwb(a.B[b],1),0))return false;if(a.v!=null&&a.v[b]!=null)for(d=a.v[b],e=0,f=d.length;e<f;++e){c=d[e];if(!ZXb.kn(c))return false;}}return ZXb.kn(a.C[b]);};ZXb.El=function El(a,b){return (a.u[b]&S$b)!=0;};ZXb.Fl=function Fl(a,b){var c,d,e,f;if(a.K){if(bxb(Iwb(a.B[b],1),0))return false;if(a.v!=null&&a.v[b]!=null)for(d=a.v[b],e=0,f=d.length;e<f;++e){c=d[e];if(!(c>=3&&c<=4||c>=11&&c<=13||c>=19&&c<=31||c>=37&&c<=51||c>=55&&c<=84||c>=87&&c<=103))return false;}}return ZXb.ln(a.C[b]);};ZXb.Gl=function Gl(a,b){return a.A[b]==0;};ZXb.Hl=function Hl(a,b){var c,d,e,f;if(a.K){if(bxb(Iwb(a.B[b],1),0))return false;if(a.v!=null&&a.v[b]!=null)for(d=a.v[b],e=0,f=d.length;e<f;++e){c=d[e];if(!(c==1||c>=5&&c<=9||c>=14&&c<=17||c>=32&&c<=35||c>=52&&c<=53))return false;}}return ZXb.mn(a.C[b]);};ZXb.Il=function Il(a){var b;for(b=0;b<a.q;b++){switch(a.C[b]){case 1:case 5:case 6:case 7:case 8:case 9:case 14:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:continue;default:return false;}}return true;};ZXb.Jl=function Jl(a,b){return (a.u[b]&512)!=0;};ZXb.Kl=function Kl(a,b){return (a.u[a.D[0][b]]&a.u[a.D[1][b]]&512)!=0;};ZXb.Ll=function Ll(a,b){return a.H[b]==257||a.H[b]==129;};ZXb.Ml=function Ml(a,b,c){return (a.H[b]==257||a.H[b]==129)&&a.D[0][b]==c;};ZXb.Nl=function Nl(a,b){var c,d,e,f;if(a.K){if(bxb(Iwb(a.B[b],1),0))return false;if(a.v!=null&&a.v[b]!=null)for(d=a.v[b],e=0,f=d.length;e<f;++e){c=d[e];if(!(c>=3&&c<=4||c>=11&&c<=13||c>=19&&c<=31||c>=37&&c<=51||c>=55&&c<=84||c>=87&&c<=103))return false;}}return ZXb.nn(a.C[b]);};ZXb.Ol=function Ol(a,b){a.C[b]=-1;};ZXb.Pl=function Pl(a,b){a.H[b]=512;};ZXb.Ql=function Ql(a,b,c,d,e,f,g,h){var i,j,k,l,m,n,o,p,q,r;if(b!=d){q=a.J[b].a-a.J[d].a;r=a.J[b].b-a.J[d].b;h=$wnd.Math.sqrt(q*q+r*r);}i=b;k=ZXb.Pm(a,b)!=3;for(p=1;p<c;p++){m=a.J[i].a+h*$wnd.Math.sin(f);n=a.J[i].b+h*$wnd.Math.cos(f);o=-1;for(l=0;l<a.q;l++){if($wnd.Math.abs(m-a.J[l].a)<4&&$wnd.Math.abs(n-a.J[l].b)<4){o=l;break;}}if(o==-1){o=ZXb.Tj(a,m,n,0);a.J[o].a=m;a.J[o].b=n;a.J[o].c=0;}j=ZXb.al(a,i,o);if(j==-1){j=ZXb.Wj(a,i,o,ZXb.Fl(a,i)||ZXb.Fl(a,o)?32:1);if(e){k&&ZXb.Pm(a,a.D[0][j])<4&&ZXb.Pm(a,a.D[1][j])<3&&(a.H[j]=2);k=!k;}}i=o;f+=g;}j=ZXb.al(a,i,d);j==-1&&(j=ZXb.Wj(a,i,d,ZXb.Fl(a,i)||ZXb.Fl(a,d)?32:1));e&&k&&ZXb.Pm(a,a.D[0][j])<4&&ZXb.Pm(a,a.D[1][j])<4&&(a.H[j]=2);};ZXb.Rl=function Rl(a,b,c){var d,e;if(ZXb.bl(a,b)!=1)return false;if((a.u[c]&3)!=0)return true;for(e=0;e<a.r;e++)if(e!=b&&a.H[e]==2&&(a.D[0][e]==c&&(a.u[a.D[1][e]]&3)!=0||a.D[1][e]==c&&(a.u[a.D[0][e]]&3)!=0))return true;for(d=0;d<a.r;d++)if(d!=b&&a.H[d]==1&&(a.D[0][d]==c||a.D[1][d]==c)&&(a.F[d]&3)!=0)return true;return false;};ZXb.Sl=function Sl(a){var b;for(b=0;b<a.q;b++)a.u[b]&=-449;};ZXb.Tl=function Tl(a){var b;for(b=0;b<a.q;b++)a.u[b]&=-131073;};ZXb.Ul=function Ul(a){var b;for(b=0;b<a.q;b++)a.u[b]&=-513;};ZXb.Vl=function Vl(a){var b;for(b=0;b<a.r;b++)a.F[b]&=-98305;};ZXb.Wl=function Wl(a,b){var c;for(c=0;c<a.q;c++)$wnd.Math.abs(a.w[c])==$wnd.Math.abs(b)&&(a.w[c]=0);};ZXb.Xl=function Xl(a){var b,c,d,e;e=false;for(c=0;c<a.q;c++){if(bxb(Iwb(a.B[c],KZb),0)){a.C[c]=-1;e=true;}}e&&ZXb.tk(a);if(a.v!=null){a.v=null;e=true;}for(b=0;b<a.q;b++){if(bxb(a.B[b],0)){a.B[b]=0;e=true;}}for(d=0;d<a.r;d++){if(a.G[d]!=0){a.G[d]=0;e=true;}if(a.H[d]==64){a.H[d]=1;e=true;}}e&&(a.T=0);return e;};ZXb.Yl=function Yl(a,b){var c,d,e,f,g,h,i,j,k;if(b==0)return 0;h=null;for(d=0;d<a.q;d++){if((a.u[d]&D$b)>>18==b){h==null&&(h=Rjb(TXb.Bwb,JZb,6,32,16,1));h[(a.u[d]&D$b)>>18!=1&&(a.u[d]&D$b)>>18!=2?-1:(a.u[d]&g_b)>>20]=true;}}for(f=0;f<a.r;f++){if((a.F[f]&768)>>8==b){h==null&&(h=Rjb(TXb.Bwb,JZb,6,32,16,1));h[(a.F[f]&768)>>8!=1&&(a.F[f]&768)>>8!=2?-1:(a.F[f]&h_b)>>10]=true;}}k=0;if(h!=null){j=Rjb(TXb.klb,xZb,6,32,15,1);for(i=0;i<32;i++)h[i]&&(j[i]=k++);for(c=0;c<a.q;c++){if((a.u[c]&D$b)>>18==b){g=j[(a.u[c]&D$b)>>18!=1&&(a.u[c]&D$b)>>18!=2?-1:(a.u[c]&g_b)>>20];a.u[c]&=-32505857;a.u[c]|=g<<20;}}for(e=0;e<a.r;e++){if((a.F[e]&768)>>8==b){g=j[(a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&h_b)>>10];a.F[e]&=-31745;a.F[e]|=g<<10;}}}return k;};ZXb.Zl=function Zl(a,b){var c;for(c=0;c<a.q;c++){a.J[c].a*=b;a.J[c].b*=b;}};ZXb.$l=function $l(a,b){a.q=b;a.T=0;};ZXb._l=function _l(a,b){a.r=b;a.T=0;};ZXb.am=function am(a,b,c){if(c>=-1&&c<=14){a.u[b]&=-2013265921;a.u[b]|=1+c<<27;if(a.C[b]==6){if(c==-1||c==0||c==2||c==4){a.u[b]&=-49;c==2&&(a.u[b]|=16);}}}};ZXb.bm=function bm(a,b,c){a.u[b]&=-49153;a.u[b]|=c<<14;};ZXb.cm=function cm(a,b,c){a.s[b]=c;a.T=0;};ZXb.dm=function dm(a,b,c){a.u[b]&=-449;a.u[b]|=c;};ZXb.em=function em(a,b,c){c?a.u[b]|=j_b:a.u[b]&=m_b;a.T&=7;};ZXb.fm=function fm(a,b,c){var d,e;if(c!=null){if(XXb.KTb(c).length==0)c=null;else {d=ZXb.hn(c,321);if(d!=0&&UXb.CHb(c,ZXb.Mj[d])||UXb.CHb(c,'?')){ZXb.vm(a,b,d);c=null;}}}if(c==null){a.t!=null&&(a.t[b]=null);}else {a.t==null&&(a.t=Rjb(TXb.glb,_Yb,10,a.M,0,2));a.t[b]=XXb.lTb((e=c,XXb.gTb(),e));}};ZXb.gm=function gm(a,b,c){c!=null&&c.length==0&&(c=null);if(c==null){a.t!=null&&(a.t[b]=null);}else {a.t==null&&(a.t=Rjb(TXb.glb,_Yb,10,a.M,0,2));a.t[b]=c;}};ZXb.hm=function hm(a,b,c,d){var e,f,g;if(c==0){a.u[b]&=n_b;a.u[b]|=c<<18;}else {if(d>=32)return;if(d==-1){g=-1;for(f=0;f<a.q;f++)f!=b&&c==(a.u[f]&D$b)>>18&&g<((a.u[f]&D$b)>>18!=1&&(a.u[f]&D$b)>>18!=2?-1:(a.u[f]&g_b)>>20)&&(g=(a.u[f]&D$b)>>18!=1&&(a.u[f]&D$b)>>18!=2?-1:(a.u[f]&g_b)>>20);for(e=0;e<a.r;e++)c==(a.F[e]&768)>>8&&g<((a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&h_b)>>10)&&(g=(a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&h_b)>>10);d=g+1;if(d>=32)return;}a.u[b]&=n_b;a.u[b]|=c<<18|d<<20;}a.T&=7;};ZXb.im=function im(a,b,c){a.v==null&&(a.v=Rjb(TXb.klb,P$b,8,a.M,0,2));XXb.eTb(c,XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));a.v[b]=c;a.T=0;a.K=true;};ZXb.jm=function jm(a,b,c,d){var e;if(c==null){a.v!=null&&(a.v[b]=null);return;}if(c.length==1&&!d){e=c[0];a.C[b]!=e&&ZXb.ek(a,b,e,0,-1,0);a.v!=null&&(a.v[b]=null);return;}a.v==null&&(a.v=Rjb(TXb.klb,P$b,8,a.M,0,2));a.v[b]=c;d&&(a.B[b]=dxb(a.B[b],1));a.T=0;a.K=true;};ZXb.km=function km(a,b,c,d){a.w[b]=d?-c:c;};ZXb.lm=function lm(a,b,c){c?a.u[b]|=S$b:a.u[b]&=-131073;};ZXb.mm=function mm(a,b,c){a.A[b]=c;a.T&=7;};ZXb.nm=function nm(a,b,c,d){a.u[b]&=-33554440;a.u[b]|=c;d&&(a.u[b]|=4);};ZXb.om=function om(a,b,c,d){d?a.B[b]=dxb(a.B[b],c):a.B[b]=Iwb(a.B[b],cxb(c));a.T=0;a.K=true;};ZXb.pm=function pm(a,b,c){a.u[b]&=-49;a.u[b]|=c;a.T&=7;};ZXb.qm=function qm(a,b,c){c?a.u[b]|=512:a.u[b]&=-513;};ZXb.rm=function rm(a,b,c){a.u[b]&=-67108865;c&&(a.u[b]|=k_b);};ZXb.sm=function sm(a,b,c){a.J[b].a=c;a.T&=7;};ZXb.tm=function tm(a,b,c){a.J[b].b=c;a.T&=7;};ZXb.um=function um(a,b,c){a.J[b].c=c;a.T&=7;};ZXb.vm=function vm(a,b,c){if(c>=0&&c<=190){if(c==151||c==152){a.C[b]=1;a.A[b]=c-149;}else {a.C[b]=c;a.A[b]=0;}a.u[b]&=-2013265921;a.T=0;}};ZXb.wm=function wm(a,b,c,d){a.D[b][c]=d;a.T=0;};ZXb.xm=function xm(a,b,c){c?a.F[b]|=l_b:a.F[b]&=-32769;};ZXb.ym=function ym(a,b,c){a.F[b]&=-49;a.F[b]|=c<<4;};ZXb.zm=function zm(a,b,c,d){var e,f,g;if(c==0){a.F[b]&=-32513;a.F[b]|=c<<8;}else {if(d>=32)return;if(d==-1){g=-1;for(f=0;f<a.q;f++)c==(a.u[f]&D$b)>>18&&g<((a.u[f]&D$b)>>18!=1&&(a.u[f]&D$b)>>18!=2?-1:(a.u[f]&g_b)>>20)&&(g=(a.u[f]&D$b)>>18!=1&&(a.u[f]&D$b)>>18!=2?-1:(a.u[f]&g_b)>>20);for(e=0;e<a.r;e++)e!=b&&c==(a.F[e]&768)>>8&&g<((a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&h_b)>>10)&&(g=(a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&h_b)>>10);d=g+1;if(d>=32)return;}a.F[b]&=-32513;a.F[b]|=c<<8|d<<10;}a.T&=7;};ZXb.Am=function Am(a,b,c){c?a.F[b]|=nZb:a.F[b]&=-65537;};ZXb.Bm=function Bm(a,b,c){a.H[b]=c==1?1:c==2?2:c==3?4:32;a.T=0;};ZXb.Cm=function Cm(a,b,c,d){a.F[b]&=-131080;a.F[b]|=c;d&&(a.F[b]|=4);};ZXb.Dm=function Dm(a,b){a.F[b]|=S$b;};ZXb.Em=function Em(a,b,c,d){d?a.G[b]|=c:a.G[b]&=~c;a.T=0;a.K=true;};ZXb.Fm=function Fm(a,b,c){a.H[b]=c;a.T=0;};ZXb.Gm=function Gm(a,b){a.I=b;};ZXb.Hm=function Hm(a,b){if(a.K!=b){a.K=b;b||ZXb.Xl(a);a.T=0;}};ZXb.Im=function Im(a,b){a.T=b;};ZXb.Jm=function Jm(a,b){a.S=b;};ZXb.Km=function Km(a,b){var c,d;a.C=ZXb._m(a.C,b);a.s=ZXb._m(a.s,b);a.w=ZXb._m(a.w,b);d=a.J.length;a.J=ZXb.bn(a.J,b);for(c=d;c<b;c++)a.J[c]=new ZXb.Rh();a.A=ZXb._m(a.A,b);a.u=ZXb._m(a.u,b);a.B=ZXb.an(a.B,b);a.v!=null&&(a.v=ZXb.dn(a.v,b));a.t!=null&&(a.t=ZXb.cn(a.t,b));a.M=b;};ZXb.Lm=function Lm(a,b){a.D[0]=ZXb._m(a.D[0],b);a.D[1]=ZXb._m(a.D[1],b);a.H=ZXb._m(a.H,b);a.F=ZXb._m(a.F,b);a.G=ZXb._m(a.G,b);a.N=b;};ZXb.Mm=function Mm(a,b){a.O=b;};ZXb.Nm=function Nm(a,b){a.P=b;};ZXb.Om=function Om(a,b){a.u[b]|=nZb;};ZXb.Pm=function Pm(a,b){var c,d;d=0;for(c=0;c<a.r;c++)(a.D[0][c]==b||a.D[1][c]==b)&&(d+=ZXb.bl(a,c));return d;};ZXb.Qm=function Qm(a){var b,c,d;c=false;d=false;for(b=0;b<a.q;b++){if(a.A[b]!=0){a.A[b]=0;c=true;a.C[b]==1&&(d=true);}}d&&(a.T=0);return c;};ZXb.Rm=function Rm(a,b,c){return ZXb.Fl(a,b)||ZXb.Fl(a,c)?32:1;};ZXb.Sm=function Sm(a,b,c){var d,e,f,g,h,i;g=a.C[b];a.C[b]=a.C[c];a.C[c]=g;g=a.s[b];a.s[b]=a.s[c];a.s[c]=g;g=a.A[b];a.A[b]=a.A[c];a.A[c]=g;g=a.u[b];a.u[b]=a.u[c];a.u[c]=g;i=a.B[b];a.B[b]=a.B[c];a.B[c]=i;g=a.w[b];a.w[b]=a.w[c];a.w[c]=g;f=a.J[b];a.J[b]=a.J[c];a.J[c]=f;if(a.v!=null){h=a.v[b];a.v[b]=a.v[c];a.v[c]=h;}if(a.t!=null){h=a.t[b];a.t[b]=a.t[c];a.t[c]=h;}for(d=0;d<a.r;d++){for(e=0;e<2;e++){a.D[e][d]==b?a.D[e][d]=c:a.D[e][d]==c&&(a.D[e][d]=b);}}a.T=0;};ZXb.Tm=function Tm(a,b,c){var d;d=a.D[0][b];a.D[0][b]=a.D[0][c];a.D[0][c]=d;d=a.D[1][b];a.D[1][b]=a.D[1][c];a.D[1][c]=d;d=a.H[b];a.H[b]=a.H[c];a.H[c]=d;d=a.F[b];a.F[b]=a.F[c];a.F[c]=d;d=a.G[b];a.G[b]=a.G[c];a.G[c]=d;a.T=0;};ZXb.Um=function Um(a,b,c){var d;for(d=0;d<a.q;d++){a.J[d].a+=b;a.J[d].b+=c;}a.U+=b;a.V+=c;};ZXb.Vm=function Vm(a,b,c){var d,e;e=c&127;d=ZXb.ll(a,b);switch(e){case 1:case 64:return d>=1;case 2:return d>=2;case 4:return d>=3;case 8:return d>=4;case 16:return d>=5;case 32:return true;default:return false;}};ZXb.Wm=function Wm(a,b,c,d){var e,f,g;for(e=0;e<a.q;e++){if(!d||(a.u[e]&512)!=0){g=a.R[e]*b;f=a.Q[e]-c;a.J[e].a=a.U+g*$wnd.Math.sin(f);a.J[e].b=a.V+g*$wnd.Math.cos(f);}}d&&(a.T&=7);};ZXb.Xm=function Xm(a,b,c){var d,e,f;a.U=b;a.V=c;a.Q=Rjb(TXb.ilb,vZb,6,a.q,15,1);a.R=Rjb(TXb.ilb,vZb,6,a.q,15,1);for(d=0;d<a.q;d++){e=b-a.J[d].a;f=c-a.J[d].b;a.R[d]=$wnd.Math.sqrt(e*e+f*f);a.Q[d]=ZXb.fn(b,c,a.J[d].a,a.J[d].b);}};ZXb.Ym=function Ym(){this.M=this.N=256;ZXb.ol(this);};ZXb.Zm=function Zm(a,b){this.M=$wnd.Math.max(1,a);this.N=$wnd.Math.max(1,b);ZXb.ol(this);};ZXb._m=function _m(a,b){var c;c=Rjb(TXb.klb,xZb,6,b,15,1);UXb.oIb(a,0,c,0,$wnd.Math.min(a.length,b));return c;};ZXb.an=function an(a,b){var c;c=Rjb(TXb.llb,M$b,6,b,14,1);UXb.oIb(a,0,c,0,$wnd.Math.min(a.length,b));return c;};ZXb.bn=function bn(a,b){var c,d;c=Rjb(TXb.Dlb,i_b,32,b,0,1);for(d=0;d<a.length;d++)!!a[d]&&(c[d]=new ZXb.Th(a[d]));return c;};ZXb.cn=function cn(a,b){var c,d;c=Rjb(TXb.glb,_Yb,10,b,0,2);for(d=0;d<a.length;d++){if(a[d]!=null){c[d]=Rjb(TXb.glb,R$b,6,a[d].length,15,1);UXb.oIb(a[d],0,c[d],0,a[d].length);}}return c;};ZXb.dn=function dn(a,b){var c,d;c=Rjb(TXb.klb,P$b,8,b,0,2);for(d=0;d<a.length;d++){if(a[d]!=null){c[d]=Rjb(TXb.klb,xZb,6,a[d].length,15,1);UXb.oIb(a[d],0,c[d],0,a[d].length);}}return c;};ZXb.en=function en(a){ZXb.Sj();return a>=0&&a<ZXb.Nj.length&&ZXb.Nj[a]!=null?ZXb.Nj[a]:a>=171&&a<=190?ZXb.Lj:ZXb.Pj;};ZXb.fn=function fn(a,b,c,d){ZXb.Sj();var e,f,g;f=c-a;g=d-b;if(g!=0){e=$wnd.Math.atan(f/g);g<0&&(f<0?e-=OZb:e+=OZb);}else e=f>0?PZb:x$b;return e;};ZXb.gn=function gn(a,b){ZXb.Sj();var c;c=a-b;while(c<o_b)c+=NZb;while(c>OZb)c-=NZb;return c;};ZXb.hn=function hn(a,b){ZXb.Sj();var c,d,e,f,g;if((b&256)!=0&&UXb.CHb(a,'?'))return 0;for(d=1;d<=128;d++)if(!UXb.CHb(a,e_b)&&UXb.DHb(a,ZXb.Mj[d]))return d;if((b&2)!=0)for(e=129;e<=144;e++)if(UXb.DHb(a,ZXb.Mj[e]))return e;if((b&4)!=0)for(f=146;f<=148;f++)if(UXb.DHb(a,ZXb.Mj[f]))return f;if((b&1)!=0)for(g=151;g<=152;g++)if(UXb.DHb(a,ZXb.Mj[g]))return g;if((b&32)!=0)if(UXb.DHb(a,ZXb.Mj[153]))return 153;if((b&8)!=0)if(UXb.DHb(a,ZXb.Mj[154]))return 154;if((b&16)!=0)if(UXb.DHb(a,ZXb.Mj[145]))return 145;if((b&128)!=0)if(UXb.DHb(a,ZXb.Mj[159]))return 159;if((b&64)!=0)for(c=171;c<=190;c++)if(UXb.DHb(a,ZXb.Mj[c]))return c;return 0;};ZXb.jn=function jn(a){ZXb.Sj();switch(a){case 7:case 8:case 9:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:return true;}return false;};ZXb.kn=function kn(a){ZXb.Sj();if(a==1||a==6)return false;if(ZXb.jn(a))return false;if(a==2||a==10||a==18||a==36||a==54)return false;if(a>103)return false;return true;};ZXb.ln=function ln(a){return a>=3&&a<=4||a>=11&&a<=13||a>=19&&a<=31||a>=37&&a<=51||a>=55&&a<=84||a>=87&&a<=103;};ZXb.mn=function mn(a){return a==1||a>=5&&a<=9||a>=14&&a<=17||a>=32&&a<=35||a>=52&&a<=53;};ZXb.nn=function nn(a){return a>=21&&a<=30||a>=39&&a<=48||a==57||a>=72&&a<=80||a==89||a>=104&&a<=112;};wxb(113,1,{113:1,4:1});_.Kb=function $m(a){ZXb.nk(this,a);};_.Lb=function on(a){return this.H[a]==64;};_.q=0;_.r=0;_.I=0;_.K=false;_.L=false;_.M=0;_.N=0;_.O=0;_.S=false;_.T=0;_.U=0;_.V=0;ZXb.Rj=24;TXb.Plb=UFb(113);ZXb.pn=function pn(a,b,c,d){var e,f,g,h,i,j,k,l,m;ZXb.nu(b,1);d==null&&(d=Rjb(TXb.klb,xZb,6,b.q,15,1));h=ZXb.Yl(a,1);i=ZXb.Yl(a,2);m=Rjb(TXb.Bwb,JZb,6,b.q,16,1);j=Rjb(TXb.klb,xZb,6,b.q,15,1);j[0]=c;m[c]=true;d[c]=ZXb.jk(b,a,c,h,i);g=0;k=0;while(g<=k){for(l=0;l<ZXb.Dn(b,j[g]);l++){f=b.i[j[g]][l];if(!m[f]){j[++k]=f;m[f]=true;d[f]=ZXb.jk(b,a,f,h,i);}}++g;}for(e=0;e<b.r;e++)m[b.D[0][e]]&&ZXb.kk(b,a,e,h,i,d==null?b.D[0][e]:d[b.D[0][e]],d==null?b.D[1][e]:d[b.D[1][e]],false);ZXb.Yl(a,1);ZXb.Yl(a,2);a.T=0;};ZXb.qn=function qn(a){var b,c,d,e,f,g,h,i,j,k,l,m;a.j=Rjb(TXb.klb,xZb,6,a.q,15,1);a.e=Rjb(TXb.klb,xZb,6,a.q,15,1);a.i=Rjb(TXb.klb,P$b,8,a.q,0,2);a.k=Rjb(TXb.klb,P$b,8,a.q,0,2);a.n=Rjb(TXb.klb,P$b,8,a.q,0,2);a.o=Rjb(TXb.klb,xZb,6,a.f,15,1);j=Rjb(TXb.klb,xZb,6,a.q,15,1);for(g=0;g<a.r;g++){++j[a.D[0][g]];++j[a.D[1][g]];}for(d=0;d<a.q;d++){a.i[d]=Rjb(TXb.klb,xZb,6,j[d],15,1);a.k[d]=Rjb(TXb.klb,xZb,6,j[d],15,1);a.n[d]=Rjb(TXb.klb,xZb,6,j[d],15,1);}l=false;for(h=0;h<a.g;h++){m=ZXb.bl(a,h);if(m==0){l=true;continue;}for(k=0;k<2;k++){c=a.D[k][h];b=a.e[c];a.n[c][b]=m;a.i[c][b]=a.D[1-k][h];a.k[c][b]=h;++a.e[c];++a.j[c];c<a.f&&(m>1?a.o[c]+=m-1:a.H[h]==64&&(a.o[c]=1));}}for(i=a.g;i<a.r;i++){m=ZXb.bl(a,i);if(m==0){l=true;continue;}for(k=0;k<2;k++){c=a.D[k][i];b=a.e[c];a.n[c][b]=m;a.i[c][b]=a.D[1-k][i];a.k[c][b]=i;++a.e[c];a.D[1-k][i]<a.f&&++a.j[c];}}if(l){b=Rjb(TXb.klb,xZb,6,a.q,15,1);for(e=0;e<a.q;e++)b[e]=a.e[e];for(f=0;f<a.r;f++){m=ZXb.bl(a,f);if(m==0){for(k=0;k<2;k++){c=a.D[k][f];a.n[c][b[c]]=m;a.i[c][b[c]]=a.D[1-k][f];a.k[c][b[c]]=f;++b[c];}}}}};ZXb.rn=function rn(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w;ZXb.nu(a,1);c&&(b=true);for(i=0;i<a.r;i++){j=ZXb.bl(a,i);if(j==1||j==2){if(a.s[a.D[0][i]]>0&&a.s[a.D[1][i]]<0){f=a.D[0][i];g=a.D[1][i];}else if(a.s[a.D[0][i]]<0&&a.s[a.D[1][i]]>0){f=a.D[1][i];g=a.D[0][i];}else continue;if(ZXb.Fl(a,f)||ZXb.Fl(a,g))continue;if(a.C[f]<9&&ZXb.ko(a,f)>3||a.C[g]<9&&ZXb.ko(a,g)>3)continue;l=ZXb.fo(a,f)!=0;a.s[f]-=1;a.s[g]+=1;if(!l){s=a.H[i];j==1?a.H[i]=2:a.H[i]=4;if(s==129||s==257){w=a.D[0][i];r=ZXb.cp(a,w,false);if(a.D[0][r]!=w){a.D[1][r]=a.D[0][r];a.D[1][r]=w;}}}a.T=0;}}t=0;p=0;n=0;for(e=0;e<a.q;e++){t+=a.s[e];if(a.s[e]<0&&!ZXb.Do(a,e)){++p;ZXb.Cl(a,e)&&(n-=a.s[e]);}}if(!b&&t!=0)throw Gwb(new UXb.aA("molecule's overall charges are not balanced"));ZXb.nu(a,1);u=0;v=c?t+n:n;for(h=0;h<a.q;h++){if(a.s[h]>0){if(!ZXb.Co(a,h)&&ZXb.Cl(a,h)){k=$wnd.Math.min(ZXb.fo(a,h),a.s[h]);if(k!=0&&v>=k){t-=k;u-=k;v-=k;a.s[h]-=k;a.T&=1;}}}}q=c?t:u;if(q<0){o=Rjb(TXb.klb,xZb,6,p,15,1);p=0;for(f=0;f<a.q;f++){a.s[f]<0&&!ZXb.Do(a,f)&&(o[p++]=(a.C[f]<<22)+f);}XXb.eTb(o,XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));for(m=o.length-1;q<0&&m>=o.length-p;m--){d=o[m]&p_b;if(ZXb.Cl(a,d)){k=$wnd.Math.min(-q,-a.s[d]);t+=k;q+=k;a.s[d]+=k;a.T&=1;}}}return t;};ZXb.sn=function sn(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;if(!a.K)return false;for(c=0;c<a.q;c++){n=ZXb.kl(a,c);n+ZXb.il(a,c,n)-ZXb.ko(a,c)<=0&&!(a.s[c]==0&&(a.C[c]==5||(e=a.C[c],e==7||e==15||e==33)||(d=a.C[c],d==8||d==16||d==34||d==52)))&&(a.B[c]=Iwb(a.B[c],-6145));}g=false;for(b=0;b<a.f;b++){h=a.e[b]-a.j[b];if(!a.S&&h>0){if(Swb(Iwb(a.B[b],w$b),0)){k=Swb(Iwb(a.B[b],VZb),896)?3:Swb(Iwb(a.B[b],VZb),384)?2:Swb(Iwb(a.B[b],128),128)?1:0;i=(n=ZXb.kl(a,b),n+ZXb.il(a,b,n)-ZXb.ko(a,b));a.s[b]==0&&Swb(Iwb(a.B[b],XZb),0)&&a.C[b]!=6&&++i;l=h;l>3-k&&(l=3-k);l>i+h-k&&(l=i+h-k);if(l>0){m=k==0?0:exb(Iwb(a.B[b],VZb),l);m=dxb(m,TXb.Qwb((l==3?7:h==2?3:1)<<7));a.B[b]=Iwb(a.B[b],-1921);a.B[b]=dxb(a.B[b],Iwb(VZb,m));}}for(j=a.j[b];j<a.e[b];j++){f=a.k[b][j];if(a.H[f]==1){a.C[a.i[b][j]]=-1;a.H[f]=512;g=true;}}}}g&&ZXb.ik(a);return g;};ZXb.tn=function tn(a,b){var c,d,e,f;if(a.o[b]==2&&a.j[b]==2&&a.n[b][0]==2){for(e=0;e<2;e++){c=ZXb.yn(a,b,a.i[b][e]);if(c!=-1){for(f=0;f<a.j[c];f++){d=a.k[c][f];(a.H[d]==257||a.H[d]==129)&&a.D[0][d]==c&&(a.H[a.k[c][f]]=1);}}}return;}if(a.o[b]==0||a.C[b]>=15){for(e=0;e<a.e[b];e++){d=a.k[b][e];(a.H[d]==257||a.H[d]==129)&&a.D[0][d]==b&&a.D[0][d]==b&&(a.H[d]=1);}}};ZXb.un=function un(a,b,c,d,e){var f,g,h,i,j;d&&ZXb.nu(a,7);b.v=null;a.K&&ZXb.Hm(b,true);i=c.length;e==null&&(e=Rjb(TXb.klb,xZb,6,i,15,1));b.q=0;for(f=0;f<i;f++)e[f]=c[f]?ZXb.jk(a,b,f,0,0):-1;b.r=0;for(j=0;j<a.r;j++){g=a.D[0][j];h=a.D[1][j];if(g<i&&h<i){if(c[g]&&c[h])ZXb.kk(a,b,j,0,0,e==null?a.D[0][j]:e[a.D[0][j]],e==null?a.D[1][j]:e[a.D[1][j]],d);else if(a.s[g]!=0&&a.s[h]!=0&&a.s[g]<0^a.s[h]<0){c[g]&&(b.s[e[g]]+=a.s[g]<0?1:-1);c[h]&&(b.s[e[h]]+=a.s[h]<0?1:-1);}}}ZXb.nk(a,b);!!a.d&&(b.T=0);b.T=0;ZXb.Yl(b,1);ZXb.Yl(b,2);b.q!=i&&ZXb.Hm(b,true);d&&ZXb.je(new ZXb.te(b),null,false);};ZXb.vn=function vn(a,b,c,d,e){var f,g,h,i,j;d&&ZXb.nu(a,7);b.v=null;a.K&&ZXb.Hm(b,true);e==null&&(e=Rjb(TXb.klb,xZb,6,a.q,15,1));b.q=0;for(f=0;f<a.q;f++){e[f]=-1;for(j=0;j<a.j[f];j++){if(c[a.k[f][j]]){e[f]=ZXb.jk(a,b,f,0,0);break;}}}b.r=0;for(i=0;i<a.r;i++)if(c[i]){ZXb.kk(a,b,i,0,0,e==null?a.D[0][i]:e[a.D[0][i]],e==null?a.D[1][i]:e[a.D[1][i]],d);}else {g=a.D[0][i];h=a.D[1][i];if(e[g]==-1^e[h]==-1){if(a.s[g]!=0&&a.s[h]!=0&&a.s[g]<0^a.s[h]<0){e[g]!=-1&&(b.s[e[g]]+=a.s[g]<0?1:-1);e[h]!=-1&&(b.s[e[h]]+=a.s[h]<0?1:-1);}}}ZXb.nk(a,b);!!a.d&&(b.T=0);b.T=0;ZXb.Yl(b,1);ZXb.Yl(b,2);b.q!=a.q&&ZXb.Hm(b,true);d&&ZXb.je(new ZXb.te(b),null,false);return e;};ZXb.wn=function wn(a,b){var c,d,e,f,g,h,i,j,k,l;if((b&~a.T)==0)return;if((a.T&1)==0){ZXb.Bo(a);ZXb.qn(a);a.T|=1;if(ZXb.sn(a)){ZXb.Bo(a);ZXb.qn(a);}}if((b&~a.T)==0)return;if((a.T&-7)!=0){for(d=0;d<a.f;d++)a.u[d]&=-15369;for(f=0;f<a.g;f++)a.F[f]&=-705;if((b&4)==0){ZXb.Bn(a,1);a.T|=2;return;}ZXb.Bn(a,7);for(e=0;e<a.f;e++){for(k=0;k<a.j[e];k++){i=a.k[e][k];if(i<a.g&&ZXb.Vr(a.p,i))continue;h=a.i[e][k];for(l=0;l<a.j[h];l++){if(a.k[h][l]==i)continue;a.n[h][l]>1&&(a.C[a.i[h][l]]==6?a.u[e]|=RZb:!ZXb.Io(a,a.k[h][l])&&ZXb.Cl(a,a.i[h][l])&&(a.u[e]|=v$b));}}}while(true){j=false;for(c=0;c<a.f;c++){if(a.o[c]>0&&(a.u[c]&v$b)!=0&&!ZXb.Ur(a.p,c)){for(k=0;k<a.j[c];k++){if(a.n[c][k]>1){h=a.i[c][k];i=a.k[c][k];for(l=0;l<a.j[h];l++){if(a.k[h][l]!=i){g=a.i[h][l];if((a.u[g]&v$b)==0){a.u[g]|=v$b;j=true;}}}}}}}if(!j)break;}}a.T|=6;};ZXb.xn=function xn(a,b){var c,d,e,f,g;c=-1;if(a.o[b]==1){for(f=0;f<a.j[b];f++){if(a.n[b][f]==2){d=a.i[b][f];if(a.j[d]==2&&a.o[d]==2){for(g=0;g<2;g++){e=a.i[d][g];if(e!=b&&a.o[e]==1){c=d;break;}}}break;}}}return c;};ZXb.yn=function yn(a,b,c){var d,e;d=b;while(a.j[c]==2&&a.o[c]==2&&c!=d){e=c;c=a.i[c][0]==b?a.i[c][1]:a.i[c][0];b=e;}return c==d?-1:c;};ZXb.zn=function zn(a,b){var c;if(a.j[b]==3&&b<a.f&&ZXb.Ur(a.p,b)&&(!!a.p&&b<a.f?ZXb.Jr(a.p,b):0)>=5)for(c=0;c<a.j[b];c++)if(ZXb.Jo(a,a.k[b][c]))return a.k[b][c];return -1;};ZXb.An=function An(a,b,c,d,e){var f,g,h,i,j,k;ZXb.nu(a,7);if((a.u[b]&q_b)==0||c&&!(b<a.f&&ZXb.Ur(a.p,b)))return;i=Rjb(TXb.klb,xZb,6,a.f,15,1);i[0]=b;d[b]=true;h=0;j=0;while(h<=j){for(k=0;k<a.j[i[h]];k++){g=a.k[i[h]][k];if(!e[g]&&(a.F[g]&64)!=0&&(!c||g<a.g&&ZXb.Vr(a.p,g))){e[g]=true;f=a.i[i[h]][k];if(!d[f]){d[f]=true;i[++j]=f;}}}++h;}};ZXb.Bn=function Bn(a,b){var c,d,e,f,g,h,i,j;a.p=new ZXb.gs(a,b);d=Rjb(TXb.klb,xZb,6,a.f,15,1);for(e=0;e<a.g;e++){if(ZXb.Lr(a.p,e)!=0){a.F[e]|=64;++d[a.D[0][e]];++d[a.D[1][e]];}}for(c=0;c<a.f;c++){d[c]==2?a.u[c]|=WZb:d[c]==3?a.u[c]|=w$b:d[c]>3&&(a.u[c]|=q_b);}for(j=0;j<a.p.i.a.length;j++){g=ZXb.Nr(a.p,j);i=ZXb.Or(a.p,j);h=g.length;for(f=0;f<h;f++){a.u[g[f]]|=8;a.F[i[f]]|=128;a.H[i[f]]==386&&(a.H[i[f]]=2);}}};ZXb.Cn=function Cn(a){var b,c,d,e,f,g,h,i;h=Rjb(TXb.Bwb,JZb,6,a.q,16,1);for(c=0;c<a.q;c++)h[c]=a.C[c]==1&&a.A[c]==0&&a.s[c]==0&&(a.t==null||a.t[c]==null);i=Rjb(TXb.Bwb,JZb,6,a.q,16,1);for(g=0;g<a.r;g++){d=a.D[0][g];e=a.D[1][g];if(ZXb.bl(a,g)!=1){h[d]=false;h[e]=false;continue;}i[d]&&(h[d]=false);i[e]&&(h[e]=false);h[d]&&ZXb.Fl(a,e)&&a.C[e]!=13&&(h[d]=false);h[e]&&ZXb.Fl(a,d)&&a.C[d]!=13&&(h[e]=false);i[d]=true;i[e]=true;}for(f=0;f<a.r;f++){if(h[a.D[0][f]]&&h[a.D[1][f]]){h[a.D[0][f]]=false;h[a.D[1][f]]=false;}}for(b=0;b<a.q;b++)i[b]||(h[b]=false);return h;};ZXb.Dn=function Dn(a,b){return a.e[b];};ZXb.En=function En(a,b){return a.i[b].length;};ZXb.Fn=function Fn(a,b){return a.e[b]-ZXb.jo(a,b)+ZXb.fo(a,b);};ZXb.Gn=function Gn(a){var b,c;ZXb.nu(a,7);b=0;for(c=0;c<a.p.i.a.length;c++)ZXb.Tr(a.p,c)&&++b;return b;};ZXb.Hn=function Hn(a,b){var c,d;c=0;for(d=0;d<a.j[b];d++)ZXb.Cl(a,a.i[b][d])&&!ZXb.xl(a,a.k[b][d])&&++c;return c;};ZXb.In=function In(a,b){return a.o[b];};ZXb.Jn=function Jn(a,b){ZXb.nu(a,7);return a.o[b]==2&&a.j[b]==2?ZXb.ap(a,b,false):ZXb.cp(a,b,false);};ZXb.Kn=function Kn(a,b){var c;c=a.u[b]&q_b;return c==0?0:c==WZb?2:c==w$b?3:4;};ZXb.Ln=function Ln(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;ZXb.nu(a,7);f=Rjb(TXb.Bwb,JZb,6,a.g,16,1);l=Rjb(TXb.Bwb,JZb,6,a.g,16,1);o=Rjb(TXb.klb,xZb,6,a.f,15,1);g=0;for(h=1;h<a.j[b];h++){d=a.k[b][h];if((a.F[d]&64)!=0){for(j=0;j<h;j++){e=a.k[b][j];if((a.F[e]&64)!=0){l[d]=true;l[e]=true;n=ZXb.mo(a,o,a.i[b][h],a.i[b][j],c-2,null,l);l[d]=false;l[e]=false;if(n!=-1){i=false;m=Rjb(TXb.klb,xZb,6,n,15,1);ZXb.no(a,o,m,n);for(k=0;k<n;k++){if(!f[m[k]]){f[m[k]]=true;i=true;}}i&&++g;}}}}}return g;};ZXb.Mn=function Mn(a,b){return !!a.p&&b<a.f?ZXb.Jr(a.p,b):0;};ZXb.Nn=function Nn(a,b){if(b){ZXb.nu(a,1);return ZXb.Sk(a,a.f,a.g,ZXb.Rj);}else {return ZXb.Sk(a,a.q,a.r,ZXb.Rj);}};ZXb.On=function On(a){var b,c,d,e,f,g,h,i;ZXb.nu(a,1);h=Rjb(TXb.jlb,r_b,6,a.f,15,1);d=Rjb(TXb.klb,xZb,6,a.f,15,1);for(i=0;i<a.f;i++){d[0]=i;e=Rjb(TXb.klb,xZb,6,a.f,15,1);e[i]=1;c=0;f=0;while(c<=f){for(g=0;g<a.j[d[c]];g++){b=a.i[d[c]][g];if(e[b]==0){e[b]=e[d[c]]+1;d[++f]=b;h[i]+=e[b]-1;}}++c;}h[i]/=f;}return h;};ZXb.Pn=function Pn(a,b,c){var d;for(d=0;d<a.i[b].length;d++)if(a.i[b][d]==c)return a.k[b][d];return -1;};ZXb.Qn=function Qn(a,b){return !!a.p&&b<a.g?ZXb.Lr(a.p,b):0;};ZXb.Rn=function Rn(a,b,c){return a.i[b][c];};ZXb.Sn=function Sn(a,b){return a.j[b];};ZXb.Tn=function Tn(a,b,c){return a.k[b][c];};ZXb.Un=function Un(a,b,c){return a.n[b][c];};ZXb.Vn=function Vn(a,b){var c,d;c=0;for(d=0;d<a.j[b];d++)bxb(Iwb(a.B[d],KZb),0)&&++c;return c;};ZXb.Wn=function Wn(a,b){return a.e[b]-a.j[b];};ZXb.Xn=function Xn(a,b,c,d,e){var f,g,h,i;g=a.e[b];if(a.o[b]!=0||b<a.f&&ZXb.Ur(a.p,b)||a.j[b]<3||g>4)return false;i=Rjb(TXb.Bwb,JZb,6,4,16,1);for(h=0;h<g;h++){f=3.9269908169872414-d[h];if($wnd.Math.abs(s_b-f%PZb)>0.0872664675116539)return false;e[h]=3&flb(f/PZb);if(i[e[h]])return false;i[e[h]]=true;if((e[h]&1)==0){if(a.H[a.k[b][c[h]]]!=1)return false;}else {if(!ZXb.Ml(a,a.k[b][c[h]],b))return false;}}return i[0]&&i[2];};ZXb.Yn=function Yn(a,b,c,d,e){var f,g,h,i,j,k,l,m;if((!!a.p&&b<a.f?ZXb.Jr(a.p,b):0)>24)return 3;f=a.e[b];e==null&&(e=Rjb(TXb.klb,xZb,6,f,15,1));if(!ZXb.Xn(a,b,c,d,e))return 3;i=-1;for(j=0;j<f;j++){if((e[j]&1)==1){g=a.H[a.k[b][c[j]]];if(i!=-1&&i!=g)return 3;i=g;}}k=$wnd.Math.abs(e[0]-e[1])==2?1:0;h=e[k]-e[k+1];m=$wnd.Math.abs(h)==3^e[k]<e[k+1];l=f==3||(e[3]&1)==1;return m^l^i==129?1:2;};ZXb.Zn=function Zn(a,b,c){var d,e,f,g,h,i,j,k,l,m;ZXb.nu(a,1);m=Rjb(TXb.Bwb,JZb,6,a.q,16,1);j=Rjb(TXb.klb,xZb,6,a.q,15,1);j[0]=b;m[b]=true;g=0;k=0;i=1;while(g<=k){f=c?ZXb.En(a,j[g]):a.e[j[g]];for(l=0;l<f;l++){e=a.i[j[g]][l];if(!m[e]){j[++k]=e;m[e]=true;++i;}}++g;}h=Rjb(TXb.klb,xZb,6,i,15,1);i=0;for(d=0;d<a.q;d++)m[d]&&(h[i++]=d);return h;};ZXb.$n=function $n(a,b,c,d){var e,f,g,h,i,j,k,l,m;ZXb.nu(a,1);for(f=0;f<a.q;f++)b[f]=-1;j=0;for(e=0;e<a.q;e++){if(b[e]==-1&&(!c||(a.u[e]&S$b)!=0)){b[e]=j;k=Rjb(TXb.klb,xZb,6,a.q,15,1);k[0]=e;i=0;l=0;while(i<=l){h=d?ZXb.En(a,k[i]):a.e[k[i]];for(m=0;m<h;m++){g=a.i[k[i]][m];if(b[g]==-1&&(!c||(a.u[g]&S$b)!=0)){k[++l]=g;b[g]=j;}}++i;}++j;}}return j;};ZXb._n=function _n(a,b,c,d){var e,f,g,h,i,j,k,l,m;ZXb.nu(a,1);for(f=0;f<a.q;f++)b[f]=-1;j=0;for(e=0;e<a.q;e++){if(b[e]==-1){b[e]=j;k=Rjb(TXb.klb,xZb,6,a.q,15,1);k[0]=e;i=0;l=0;while(i<=l){h=d?ZXb.En(a,k[i]):a.e[k[i]];for(m=0;m<h;m++){g=a.i[k[i]][m];if(b[g]==-1&&!c[a.k[k[i]][m]]){k[++l]=g;b[g]=j;}}++i;}++j;}}return j;};ZXb.ao=function ao(a,b){var c;return c=ZXb.kl(a,b),c+ZXb.il(a,b,c)-ZXb.ko(a,b);};ZXb.bo=function bo(a,b){var c,d,e,f,g,h;f=Rjb(TXb.klb,xZb,6,a.q,15,1);for(d=0;d<a.q;d++)f[d]=d;e=a.q;do--e;while(e>=0&&b[e]);for(c=0;c<e;c++){if(b[f[c]]){h=f[c];f[c]=f[e];f[e]=h;g=b[c];b[c]=b[e];b[e]=g;do--e;while(b[e]);}}return f;};ZXb.co=function co(a){return ZXb.bo(a,ZXb.Cn(a));};ZXb.eo=function eo(a,b,c){var d,e,f;e=ZXb.ko(a,b);e-=ZXb.il(a,b,e);c&&(e-=a.e[b]-a.j[b]);f=ZXb.en(a.C[b]);if(e<=f[0])return -1;for(d=1;d<f.length;d++)if(f[d]>=e)return f[d];return e;};ZXb.fo=function fo(a,b){var c,d,e,f,g,h;if(a.K&&Swb(Iwb(a.B[b],w$b),0))return 0;if(!ZXb.lp(a,b))return 0;ZXb.nu(a,1);g=0;for(e=0;e<a.e[b];e++)g+=a.n[b][e];if(a.K){c=1;for(d=0;d<a.j[b];d++)a.H[a.k[b][d]]==64&&++c;g+=c>>1;}g-=ZXb.il(a,b,g);f=((a.u[b]&f_b)>>>27)-1;if(f==-1){h=ZXb.en(a.C[b]);f=h[0];for(d=1;f<g&&d<h.length;d++)f=h[d];}return $wnd.Math.max(0,f-g);};ZXb.go=function go(a,b){var c,d,e,f,g;e=ZXb.ko(a,b);c=ZXb.il(a,b,e);f=((a.u[b]&f_b)>>>27)-1;if(f==-1){g=ZXb.en(a.C[b]);d=0;while(e>g[d]+c&&d<g.length-1)++d;f=g[d];}return f+c-e;};ZXb.ho=function ho(a,b){return a.i[b].length-a.e[b];};ZXb.io=function io(a){var b,c,d,e;ZXb.nu(a,1);e=0;for(b=0;b<a.q;b++){d=a.A[b]!=0?a.A[b]:ZXb.Qj[a.C[b]];e+=d+ZXb.fo(a,b)*ZXb.Qj[1];if(a.C[b]>=171&&a.C[b]<=190){c=a.e[b];c>2&&(e-=(c-2)*ZXb.Qj[1]);}}return e;};ZXb.jo=function jo(a,b){var c,d;c=a.j[b];for(d=0;d<a.j[b];d++)a.C[a.i[b][d]]==1&&--c;return c;};ZXb.ko=function ko(a,b){var c,d,e,f,g,h;a.Mb(1);g=false;d=false;h=0;for(e=0;e<a.e[b];e++){if(!a.K||Swb(Iwb(a.B[a.i[b][e]],KZb),0)){f=a.n[b][e];h+=f;f>1&&(g=true);c=a.k[b][e];a.H[c]==64&&(d=true);}}d&&!g&&++h;return h;};ZXb.lo=function lo(a,b,c){var d,e,f;e=0;for(f=0;f<a.j[b];f++){d=a.i[b][f];d!=c&&a.j[d]>2&&++e;}return e;};ZXb.mo=function mo(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p;if(c==d){b[0]=c;return 0;}a.Mb(1);k=Rjb(TXb.klb,xZb,6,a.q,15,1);j=Rjb(TXb.klb,xZb,6,a.q,15,1);p=Rjb(TXb.klb,xZb,6,a.q,15,1);j[0]=c;k[c]=1;i=0;l=0;while(i<=l&&k[j[i]]<=e){o=j[i];for(m=0;m<a.e[o];m++){if(g==null||g.length<=a.k[o][m]||!g[a.k[o][m]]){h=a.i[o][m];if(h==d){n=k[o];b[n]=h;b[--n]=o;while(n>0){b[n-1]=p[b[n]];--n;}return k[o];}if(k[h]==0&&(f==null||f.length<=h||!f[h])){j[++l]=h;k[h]=k[o]+1;p[h]=o;}}}++i;}return -1;};ZXb.no=function no(a,b,c,d){var e,f;ZXb.nu(a,1);for(e=0;e<d;e++){for(f=0;f<a.e[b[e]];f++){if(a.i[b[e]][f]==b[e+1]){c[e]=a.k[b[e]][f];break;}}}};ZXb.oo=function oo(a,b,c){var d,e,f,g,h,i;if(b==c)return 0;ZXb.nu(a,1);g=Rjb(TXb.klb,xZb,6,a.q,15,1);f=Rjb(TXb.klb,xZb,6,a.q,15,1);f[0]=b;g[b]=1;e=0;h=0;while(e<=h){for(i=0;i<a.e[f[e]];i++){d=a.i[f[e]][i];if(d==c)return g[f[e]];if(g[d]==0){f[++h]=d;g[d]=g[f[e]]+1;}}++e;}return -1;};ZXb.po=function po(a,b,c,d,e){var f,g,h,i,j,k;if(b==c)return 0;a.Mb(1);i=Rjb(TXb.klb,xZb,6,a.q,15,1);h=Rjb(TXb.klb,xZb,6,a.q,15,1);h[0]=b;i[b]=1;g=0;j=0;while(g<=j&&i[h[g]]<=d){for(k=0;k<a.e[h[g]];k++){f=a.i[h[g]][k];if(f==c)return i[h[g]];if(i[f]==0&&(e==null||e.length<=f||!e[f])){h[++j]=f;i[f]=i[h[g]]+1;}}++g;}return -1;};ZXb.qo=function qo(a,b){return a.e[b]-a.j[b]+ZXb.fo(a,b);};ZXb.ro=function ro(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;o=Rjb(TXb.klb,xZb,6,16,15,1);c=Rjb(TXb.ilb,vZb,6,16,15,1);f=Rjb(TXb.ilb,vZb,6,2,15,1);d=0;for(k=0;k<2;k++){e=a.D[k][b];for(l=0;l<a.j[e];l++){i=a.k[e][l];if(i==b)continue;if(d==4)return 0;h=a.i[e][l];o[d]=16;a.o[h]!=0&&(o[d]+=(a.u[h]&q_b)!=0?1:4);if((a.F[b]&64)!=0&&(a.F[i]&64)!=0){m=ZXb.Rr(a.p,b,i);m!=-1&&(o[d]+=ZXb.Tr(a.p,m)?64:6);}c[d++]=ZXb.fn(a.J[e].a,a.J[e].b,a.J[h].a,a.J[h].b);}}f[0]=ZXb.Uk(a,a.D[0][b],a.D[1][b]);if(f[0]<0){f[1]=f[0]+OZb;g=false;}else {f[1]=f[0];f[0]=f[1]-OZb;g=true;}n=0;for(j=0;j<d;j++){c[j]>f[0]&&c[j]<f[1]?n-=o[j]:n+=o[j];}return g?-n:n;};ZXb.so=function so(a){ZXb.nu(a,7);return a.p;};ZXb.to=function to(a){var b,c,d,e,f,g,h,i,j;j=0;ZXb.nu(a,7);for(d=0;d<a.g;d++){if(ZXb.bl(a,d)==1&&(a.F[d]&64)==0){h=true;for(g=0;g<2;g++){b=a.D[g][d];if(a.j[b]==1){h=false;break;}if(a.C[b]==7&&!(b<a.f&&ZXb.Ur(a.p,b))){c=a.D[1-g][d];for(i=0;i<a.j[c];i++){e=a.i[c][i];f=a.k[c][i];if(f!=d&&ZXb.bl(a,f)>1&&!(e<a.f&&ZXb.Ur(a.p,e))&&ZXb.Cl(a,e)){h=false;break;}}}}h&&!ZXb.Ro(a,d)&&++j;}}return j;};ZXb.uo=function uo(a,b,c){var d,e,f,g,h,i;e=0;for(f=0;f<a.j[b];f++){d=a.i[b][f];if(d!=c){g=0;for(h=0;h<a.j[d];h++){i=a.i[d][h];i!=b&&ZXb.Io(a,a.k[d][h])&&a.j[i]>2&&++g;}g==2&&++e;}}return e;};ZXb.vo=function vo(a,b){var c,d,e,f;c=a.e[b];f=Rjb(TXb.klb,xZb,6,c,15,1);for(e=0;e<c;e++)f[e]=(a.i[b][e]<<16)+e;XXb.eTb(f,XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));for(d=0;d<c;d++)f[d]&=oZb;return f;};ZXb.wo=function wo(a,b){var c,d;ZXb.nu(a,1);if(a.j[b]==2&&a.n[b][0]==2&&a.n[b][1]==2){for(c=0;c<2;c++)for(d=0;d<a.e[a.i[b][c]];d++)if(ZXb.Ml(a,a.k[a.i[b][c]][d],a.i[b][c]))return a.k[a.i[b][c]][d];}else {for(c=0;c<a.e[b];c++)if(ZXb.Ml(a,a.k[b][c],b))return a.k[b][c];}return -1;};ZXb.xo=function xo(a,b,c){if(ZXb.bl(a,b)!=1)return 0;return 16-a.e[c]+((a.H[b]&384)==0||a.D[0][b]!=c?l_b:0)+(a.C[c]==1?RZb:0)+(a.e[c]==1?w$b:0)+((a.u[c]&3)==0?WZb:0)+((a.F[b]&64)!=0?0:512)+(a.C[c]!=6?256:0);};ZXb.yo=function yo(a,b,c,d,e,f){var g,h,i,j,k;ZXb.nu(a,1);if(e){ZXb.hk(e);e.K=false;}i=Rjb(TXb.klb,xZb,6,a.q,15,1);d==null?d=Rjb(TXb.Bwb,JZb,6,a.q,16,1):$Xb.IOb(d,d.length);i[0]=b;i[1]=c;d[b]=true;d[c]=true;h=1;j=1;while(h<=j){for(k=0;k<a.e[i[h]];k++){g=a.i[i[h]][k];if(g==b){if(h!=1)return -1;}if(!d[g]){d[g]=true;i[++j]=g;}}++h;}if(e){f==null&&(f=Rjb(TXb.klb,xZb,6,d.length,15,1));ZXb.un(a,e,d,false,f);ZXb.ek(e,f[b],0,0,-1,0);}d[b]=false;return j;};ZXb.zo=function zo(a,b,c){var d,e,f,g,h,i;ZXb.nu(a,1);f=Rjb(TXb.klb,xZb,6,a.f,15,1);i=Rjb(TXb.Bwb,JZb,6,a.f,16,1);f[0]=b;f[1]=c;i[b]=true;i[c]=true;e=1;g=1;while(e<=g){for(h=0;h<a.j[f[e]];h++){d=a.i[f[e]][h];if(d==b){if(e!=1)return -1;}if(!i[d]){i[d]=true;f[++g]=d;}}++e;}return g;};ZXb.Ao=function Ao(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;if(ZXb.bl(a,c)!=2&&!(c<a.g&&ZXb.Vr(a.p,c)))return -1;n=a.F[c]&3;if(n!=1&&n!=2)return -1;for(i=0;i<2;i++){d=a.D[i][c];e=a.D[1-i][c];m=-1;g=false;for(k=0;k<a.j[d];k++){f=a.i[d][k];f!=e&&(f==b?g=true:m=f);}if(g){l=-1;h=-1;for(j=0;j<a.j[e];j++){f=a.i[e][j];if(f!=d){if(l==-1)l=f;else if(f>l)h=f;else {h=l;l=f;}}}if(a.j[d]==2){if(a.j[e]==2)return n==2?l:-1;return n==2?l:h;}else {if(a.j[e]==2)return n==2^b<m?-1:l;return n==2^b<m?h:l;}}}return -1;};ZXb.Bo=function Bo(a){var b,c,d,e,f,g,h,i,j,k;g=ZXb.Cn(a);i=a.q;do--i;while(i>=0&&g[i]);for(b=0;b<i;b++){if(g[b]){ZXb.Sm(a,b,i);k=g[b];g[b]=g[i];g[i]=k;do--i;while(g[i]);}}a.f=i+1;if(a.q==a.f){a.g=a.r;return;}h=Rjb(TXb.Bwb,JZb,6,a.r,16,1);for(f=0;f<a.r;f++){c=a.D[0][f];d=a.D[1][f];(g[c]||g[d])&&(h[f]=true);}j=a.r;do--j;while(j>=0&&h[j]);for(e=0;e<j;e++){if(h[e]){ZXb.Tm(a,e,j);h[e]=false;do--j;while(h[j]);}}a.g=j+1;};ZXb.Co=function Co(a,b){var c;for(c=0;c<a.j[b];c++)if(a.s[a.i[b][c]]<0)return true;return false;};ZXb.Do=function Do(a,b){var c;for(c=0;c<a.j[b];c++)if(a.s[a.i[b][c]]>0)return true;return false;};ZXb.Eo=function Eo(a,b){var c;c=a.C[b];return c==3||c==11||c==19||c==37||c==55;};ZXb.Fo=function Fo(a,b){return (a.u[b]&RZb)!=0;};ZXb.Go=function Go(a,b){var c,d,e,f,g,h;ZXb.nu(a,1);for(g=0;g<2;g++){c=a.D[g][b];if(a.C[c]==7){d=a.D[1-g][b];for(h=0;h<a.j[d];h++){e=a.i[d][h];f=a.k[d][h];if((a.C[e]==7||a.C[e]==8||a.C[e]==16)&&ZXb.bl(a,f)>=2)return true;}}}return false;};ZXb.Ho=function Ho(a,b){return b<a.f&&ZXb.Ur(a.p,b);};ZXb.Io=function Io(a,b){return b<a.g&&ZXb.Vr(a.p,b);};ZXb.Jo=function Jo(a,b){var c,d,e,f,g,h;if(a.H[b]!=1||b<a.g&&ZXb.Vr(a.p,b)||(a.F[b]&64)!=0&&(!!a.p&&b<a.g?ZXb.Lr(a.p,b):0)<7)return false;c=a.D[0][b];if(!(c<a.f&&ZXb.Ur(a.p,c))||(!!a.p&&c<a.f?ZXb.Jr(a.p,c):0)<5)return false;d=a.D[1][b];if(!(d<a.f&&ZXb.Ur(a.p,d))||(!!a.p&&d<a.f?ZXb.Jr(a.p,d):0)<5)return false;e=ZXb.lo(a,c,d);f=ZXb.lo(a,d,c);if((!!a.p&&c<a.f?ZXb.Jr(a.p,c):0)>5&&(!!a.p&&d<a.f?ZXb.Jr(a.p,d):0)>5)return e+f>2;g=ZXb.uo(a,c,d);h=ZXb.uo(a,d,c);if(e==2&&h>=1)return true;if(f==2&&g>=1)return true;if(g==2&&(f>=1||h>=1))return true;if(h==2&&(e>=1||g>=1))return true;return false;};ZXb.Ko=function Ko(a,b){return a.o[b]==2&&a.j[b]==2&&a.n[b][0]==2&&a.n[b][1]==2&&a.C[b]<=7;};ZXb.Lo=function Lo(a,b){var c;c=a.C[b];return c==8||c==16||c==34||c==52;};ZXb.Mo=function Mo(a,b){return b<a.g&&(ZXb.Zr(a.p,b)||a.H[b]==64);};ZXb.No=function No(a,b){var c;c=a.C[b];return c==12||c==20||c==38||c==56;};ZXb.Oo=function Oo(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;if(a.C[b]!=7||a.j[b]==4)return false;if(b<a.f&&ZXb.Ur(a.p,b)||a.o[b]!=0||bxb(Iwb(a.B[b],u$b),0))return true;if(a.s[b]==1)return false;for(i=0;i<a.j[b];i++)if(ZXb.Qn(a,a.k[b][i])==3)return false;g=0;for(j=0;j<a.j[b];j++){if(a.n[b][j]==1){d=a.C[a.i[b][j]];(d==8||d==9||d==17)&&++g;}}if(g==0){for(h=0;h<a.j[b];h++){e=a.i[b][h];if(a.o[e]!=0){if(e<a.f&&ZXb.Ur(a.p,e)){if((!!a.p&&e<a.f?ZXb.Jr(a.p,e):0)>=5){p=0;for(m=0;m<a.j[e];m++){o=a.i[e][m];o!=b&&ZXb.jo(a,o)>=3&&++p;}n=ZXb.jo(a,b);if(p==2&&n>=2||p==1&&n==3)continue;}return !c||!ZXb.To(a,b);}for(l=0;l<a.j[e];l++){if(a.n[e][l]==2||ZXb.Io(a,a.k[e][l]))return !c||!ZXb.To(a,b);}}}}if(g<2){for(h=0;h<a.j[b];h++){e=a.i[b][h];k=false;f=false;for(l=0;l<a.j[e];l++){if(a.i[e][l]!=b){a.n[e][l]!=1&&(a.C[a.i[e][l]]==7||a.C[a.i[e][l]]==8||a.C[a.i[e][l]]==16)&&(k=true);a.n[e][l]==1&&a.C[a.i[e][l]]==7&&(f=true);}}if(k&&(!f||g==0))return !c||!ZXb.To(a,b);}}return false;};ZXb.Po=function Po(a,b){var c;c=a.C[b];return c==9||c==17||c==35||c==53;};ZXb.Qo=function Qo(a,b){var c;c=a.C[b];return c==7||c==15||c==33;};ZXb.Ro=function Ro(a,b){var c,d,e,f,g,h;if(ZXb.bl(a,b)!=1)return false;for(f=0;f<2;f++){c=a.D[f][b];h=a.D[1-f][b];while(a.o[c]==2&&a.j[c]==2&&a.C[c]<10){for(g=0;g<2;g++){d=a.i[c][g];if(d!=h){if(a.j[d]==1)return true;e=a.k[c][g];if(ZXb.bl(a,e)==1&&e<b)return true;h=c;c=d;break;}}}if(a.j[c]==1)return true;}return false;};ZXb.So=function So(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q,r,s;m=Rjb(TXb.Bwb,JZb,6,a.g,16,1);m[e]=true;n=Rjb(TXb.klb,xZb,6,11,15,1);o=ZXb.mo(a,n,d,b,10,null,m);if(o==-1)return false;g=1;while(!ZXb.Wr(a.p,c,n[g]))++g;f=o-g;h=n[g];s=ZXb.Qr(a.p,c);if(s==6&&f==2&&g==3){if(ZXb.Kn(a,n[1])>=3){r=ZXb.Nr(a.p,c);for(l=0;l<6;l++){if(b==r[l]){q=ZXb.fs(a.p,c,h==r[ZXb.fs(a.p,c,l+2)]?l-2:l+2);p=r[q];k=a.u[p]&q_b;if((k==0?0:k==WZb?2:k==w$b?3:4)>=3&&ZXb.po(a,n[1],p,2,null)==2)return true;break;}}}}i=a.o[h]==1||h<a.f&&ZXb.Ur(a.p,h)||ZXb.Oo(a,h,false);j=!i&&a.C[h]==7&&a.s[h]!=1;if(f==1&&!i&&!j&&s<=4&&g<=3)return true;switch(s){case 4:if(!i&&!j&&g<=4)return true;break;case 5:if(j){if(g<=3)return true;}else if(!i){if(g<=4)return true;}break;case 6:if(f==2){if(i){if(g<=4)return true;}else if(!j){if(g<=3)return true;}}else if(f==3){if(i){if(g<=6)return true;}else {if(g<=4)return true;}}break;case 7:if(f==3){if(g<=3)return true;}}return false;};ZXb.To=function To(a,b){var c,d,e,f,g;if(b<a.f&&ZXb.Ur(a.p,b)||a.o[b]!=0||bxb(Iwb(a.B[b],u$b),0)||(d=a.u[b]&q_b,(d==0?0:d==WZb?2:d==w$b?3:4)<3))return false;g=!!a.p&&b<a.f?ZXb.Jr(a.p,b):0;if(g>7)return false;f=0;while(f<a.p.i.a.length){if(ZXb.Qr(a.p,f)==g&&ZXb.Wr(a.p,f,b))break;++f;}if(f>=WZb&&f==a.p.i.a.length)return false;for(e=0;e<a.j[b];e++){c=a.k[b][e];if(!ZXb.Xr(a.p,f,c)&&ZXb.So(a,b,f,a.i[b][e],c))return true;}return false;};ZXb.Uo=function Uo(a,b){return (a.u[b]&q_b)!=0;};ZXb.Vo=function Vo(a,b){return (a.F[b]&64)!=0;};ZXb.Wo=function Wo(a,b){return a.C[b]==1&&a.A[b]==0&&a.s[b]==0&&(a.t==null||a.t[b]==null);};ZXb.Xo=function Xo(a,b){return (a.u[b]&8)!=0;};ZXb.Yo=function Yo(a,b){return (a.F[b]&128)!=0;};ZXb.Zo=function Zo(a,b){return (a.u[b]&v$b)!=0;};ZXb.$o=function $o(a){var b,c,d,e,f,g,h,i,j,k,l;ZXb.nu(a,1);ZXb._o(a);j=false;for(c=0;c<a.f;c++){if(a.C[c]==7&&a.s[c]==0){l=ZXb.ko(a,c);if(l==4){for(k=0;k<a.j[c];k++){h=a.i[c][k];if(a.n[c][k]==1&&a.C[h]==8&&a.j[h]==1&&a.s[h]==0){j=true;++a.s[c];--a.s[h];break;}}}else if(l==5){for(k=0;k<a.j[c];k++){h=a.i[c][k];i=a.k[c][k];if(a.n[c][k]==2&&a.C[h]==8){j=true;++a.s[c];--a.s[h];a.H[i]=1;break;}if(a.n[c][k]==3&&a.C[h]==7){j=true;++a.s[c];--a.s[h];a.H[i]=2;break;}}}}}g=false;for(f=0;f<a.g;f++){for(k=0;k<2;k++){if(ZXb.Cl(a,a.D[k][f])){b=a.D[1-k][f];e=a.C[b];if(e==3||e==11||e==19||e==37||e==55||(d=a.C[b],d==12||d==20||d==38||d==56)){if(ZXb.bl(a,f)==1){++a.s[b];--a.s[a.D[k][f]];a.H[f]=512;g=true;}else if(a.H[f]==32){a.H[f]=512;g=true;}}break;}}}if(g){ZXb.ik(a);j=true;}j&&(a.T=0);return j;};ZXb._o=function _o(a){var b;for(b=0;b<a.g;b++)if(a.H[b]==64)return ZXb.je(new ZXb.te(a),null,false);return false;};ZXb.ap=function ap(a,b,c){var d,e,f,g,h,i,j,k;j=-1;e=0;for(h=0;h<2;h++){d=a.i[b][h];for(i=0;i<a.e[d];i++){f=a.i[d][i];if(f!=b){g=a.k[d][i];k=ZXb.xo(a,g,f);if(e<k&&(!c||!(a.H[g]==257||a.H[g]==129))){e=k;j=g;}}}}return j;};ZXb.bp=function bp(a,b){var c,d,e,f,g,h,i,j;i=-1;d=0;for(g=0;g<2;g++){c=a.D[g][b];for(h=0;h<a.e[c];h++){e=a.i[c][h];if(e!=a.D[1-g][b]){f=a.k[c][h];j=ZXb.xo(a,f,e);if(d<j){d=j;i=f;}}}}return i;};ZXb.cp=function cp(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;d=a.e[b];e=Rjb(TXb.ilb,vZb,6,d,15,1);for(q=0;q<d;q++)e[q]=ZXb.Uk(a,b,a.i[b][q]);for(r=1;r<d;r++){for(u=0;u<r;u++){f=$wnd.Math.abs(ZXb.gn(e[r],e[u]));if(f<0.08||f>t_b){g=0;h=0;for(v=0;v<d;v++){if(v!=r&&v!=u){g+=$wnd.Math.abs(xYb.h6(e[r],e[v]));h+=$wnd.Math.abs(xYb.h6(e[u],e[v]));}}j=g<h?a.k[b][r]:a.k[b][u];if(ZXb.bl(a,j)==1&&(!c||!(a.H[j]==257||a.H[j]==129)))return j;}}}t=Rjb(TXb.Bwb,JZb,6,d,16,1);for(s=0;s<d;s++){k=-10;l=10;for(u=0;u<d;u++){if(u!=s){o=xYb.h6(e[s],e[u]);o<0?k<o&&(k=o):l>o&&(l=o);}t[s]=l-k<OZb;}}w=-1;i=0;for(p=0;p<d;p++){m=a.i[b][p];n=a.k[b][p];A=ZXb.xo(a,n,m);t[p]&&(A+=QZb);if(i<A&&(!c||!(a.H[n]==257||a.H[n]==129))){i=A;w=n;}}return w;};ZXb.dp=function dp(a,b){var c,d,e,f;ZXb.nu(a,b?15:1);a.q=a.f;a.r=a.g;for(d=0;d<a.f;d++){if(a.e[d]!=a.j[d]){c=ZXb.eo(a,d,false);a.e[d]=a.j[d];if(c!=-1){f=ZXb.eo(a,d,true);if(c!=f){e=((a.u[d]&f_b)>>>27)-1;(e==-1||e<c)&&ZXb.am(a,d,c);}}}}b&&ZXb.jp(a);a.T=0;};ZXb.ep=function ep(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;if(a.j[b]!=2||a.n[b][0]!=2||a.n[b][1]!=2||a.j[a.i[b][0]]<2||a.j[a.i[b][1]]<2||a.o[a.i[b][0]]!=1||a.o[a.i[b][1]]!=1){ZXb.nm(a,b,0,false);return;}v=-1;u=-1;t=-1;q=-1;f=0;for(l=0;l<2;l++){d=a.i[b][l];for(o=0;o<a.e[d];o++){g=a.i[d][o];if(g!=b){h=a.k[d][o];w=ZXb.xo(a,h,g);if(f<w){f=w;u=g;v=h;t=d;q=a.i[b][1-l];}}}}if(u==-1)return;for(m=0;m<2;m++){d=a.i[b][m];for(o=0;o<a.e[d];o++){g=a.i[d][o];h=a.k[d][o];g!=b&&a.D[0][h]==d&&(a.H[h]=1);}}if(a.D[1][v]!=u){a.D[0][v]=a.D[1][v];a.D[1][v]=u;}i=fZb;for(n=0;n<a.j[t];n++){g=a.i[t][n];g!=b&&i>g&&(i=g);}r=Rjb(TXb.klb,xZb,6,2,15,1);s=0;for(k=0;k<a.j[q];k++){g=a.i[q][k];g!=b&&(r[s++]=g);}c=ZXb.fn(a.J[b].a,a.J[b].b,a.J[q].a,a.J[q].b);e=0;if(s==2){if(r[0]>r[1]){A=r[0];r[0]=r[1];r[1]=A;}j=ZXb.gn(c,ZXb.Uk(a,q,r[0]));p=ZXb.gn(c,ZXb.Uk(a,q,r[1]));e=j-p;}else {e=ZXb.gn(c,ZXb.Uk(a,q,r[0]));}e<0^(a.u[b]&3)==1^i==u?a.H[v]=257:a.H[v]=129;};ZXb.fp=function fp(a,b,c,d){var e,f,g,h,i,j;e=a.e[b];h=Rjb(TXb.klb,xZb,6,e,15,1);j=ZXb.Yn(a,b,c,d,h);if(j==3)return false;g=(a.u[b]&3)==j?257:129;for(i=0;i<e;i++){if((h[i]&1)==1){f=a.k[b][c[i]];a.H[f]=g;if(a.D[0][f]!=b){a.D[1][f]=a.D[0][f];a.D[0][f]=b;}}}return true;};ZXb.gp=function gp(a,b){a.T|=248&(8|b);};ZXb.hp=function hp(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;ZXb.tn(a,b);if((a.u[b]&3)==0||(a.u[b]&3)==3)return;if(a.o[b]==2&&a.j[b]==2){ZXb.ep(a,b);return;}if(a.j[b]<3||a.j[b]>4){ZXb.nm(a,b,0,false);return;}c=a.e[b];o=false;for(g=0;g<c;g++){if(ZXb.bl(a,a.k[b][g])==1){o=true;break;}}if(!o)return;p=ZXb.vo(a,b);d=Rjb(TXb.ilb,vZb,6,c,15,1);for(h=0;h<c;h++)d[h]=ZXb.Uk(a,a.i[b][p[h]],b);for(i=0;i<c;i++)a.D[0][a.k[b][i]]==b&&ZXb.bl(a,a.k[b][i])==1&&(a.H[a.k[b][i]]=1);if((!!a.p&&b<a.f?ZXb.Jr(a.p,b):0)<=24&&ZXb.fp(a,b,p,d))return;m=ZXb.cp(a,b,true);if(a.D[0][m]!=b){a.D[1][m]=a.D[0][m];a.D[0][m]=b;}n=-1;for(j=0;j<c;j++){if(m==a.k[b][p[j]]){n=j;break;}}q=Zjb(Ljb(TXb.klb,2),P$b,8,0,[Zjb(Ljb(TXb.klb,1),xZb,6,15,[2,1,2,1]),Zjb(Ljb(TXb.klb,1),xZb,6,15,[1,2,2,1]),Zjb(Ljb(TXb.klb,1),xZb,6,15,[1,1,2,2]),Zjb(Ljb(TXb.klb,1),xZb,6,15,[2,1,1,2]),Zjb(Ljb(TXb.klb,1),xZb,6,15,[2,2,1,1]),Zjb(Ljb(TXb.klb,1),xZb,6,15,[1,2,1,2])]);for(f=1;f<c;f++)d[f]<d[0]&&(d[f]+=NZb);if(c==3){k=false;switch(n){case 0:k=d[1]<d[2]&&d[2]-d[1]<OZb||d[1]>d[2]&&d[1]-d[2]>OZb;break;case 1:k=d[2]-d[0]>OZb;break;case 2:k=d[1]-d[0]<OZb;}e=(a.u[b]&3)==1^k?257:129;}else {l=0;d[1]<=d[2]&&d[2]<=d[3]?l=0:d[1]<=d[3]&&d[3]<=d[2]?l=1:d[2]<=d[1]&&d[1]<=d[3]?l=2:d[2]<=d[3]&&d[3]<=d[1]?l=3:d[3]<=d[1]&&d[1]<=d[2]?l=4:d[3]<=d[2]&&d[2]<=d[1]&&(l=5);e=(a.u[b]&3)==1^q[l][n]==1?129:257;}a.H[m]=e;};ZXb.ip=function ip(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;if((a.F[b]&3)==0||(a.F[b]&3)==3||!ZXb.Jo(a,b))return;v=-1;t=-1;u=-1;s=-1;e=0;for(l=0;l<2;l++){d=a.D[l][b];for(o=0;o<a.e[d];o++){h=a.k[d][o];if(h!=b&&ZXb.bl(a,h)==1){g=a.i[d][o];w=ZXb.xo(a,h,g);if(e<w){e=w;t=g;v=h;u=d;s=a.D[1-l][b];}}}}if(t==-1)return;for(m=0;m<2;m++){for(o=0;o<a.e[a.D[m][b]];o++){h=a.k[a.D[m][b]][o];h!=b&&ZXb.bl(a,h)==1&&(a.H[h]=1);}}if(a.D[1][v]!=t){a.D[0][v]=a.D[1][v];a.D[1][v]=t;}i=fZb;for(n=0;n<a.j[u];n++){g=a.i[u][n];a.k[u][n]!=b&&i>g&&(i=g);}q=Rjb(TXb.klb,xZb,6,2,15,1);r=0;for(k=0;k<a.j[s];k++)a.k[s][k]!=b&&(q[r++]=a.i[s][k]);f=ZXb.fn(a.J[u].a,a.J[u].b,a.J[s].a,a.J[s].b);c=0;if(r==2){if(q[0]>q[1]){A=q[0];q[0]=q[1];q[1]=A;}j=ZXb.gn(f,ZXb.Uk(a,s,q[0]));p=ZXb.gn(f,ZXb.Uk(a,s,q[1]));c=j-p;}else {c=ZXb.gn(f,ZXb.Uk(a,s,q[0]));}c<0^(a.F[b]&3)==2^i==t?a.H[v]=257:a.H[v]=129;};ZXb.jp=function jp(a){var b,c,d,e;ZXb.nu(a,7);for(d=0;d<a.g;d++)(a.H[d]==257||a.H[d]==129)&&(a.H[d]=1);for(b=0;b<a.f;b++)ZXb.hp(a,b);for(e=0;e<a.g;e++)ZXb.ip(a,e);for(c=0;c<a.g;c++)a.H[c]==2&&(a.F[c]&3)==3&&(a.H[c]=386);};ZXb.kp=function kp(b,c){var d,e,f,g,h,i,j,k,l,m;i=Rjb(TXb.klb,xZb,6,b.q,15,1);h=ZXb.$n(b,i,false,c);if(h<=1)return null;j=Rjb(TXb.klb,xZb,6,h,15,1);for(e=0;e<b.f;e++)++j[i[e]];l=0;m=j[0];for(k=1;k<h;k++){if(m<j[k]){m=j[k];l=k;}}for(d=0;d<b.q;d++)i[d]!=l&&(b.C[d]=-1);for(g=0;g<b.r;g++)(!c&&b.H[g]==32||i[b.D[0][g]]!=l)&&(b.H[g]=512);f=ZXb.ik(b);b.T=0;try{ZXb.rn(b,true,true);}catch(a){a=Fwb(a);if(!Ykb(a,19))throw Gwb(a);}return f;};ZXb.lp=function lp(a,b){if((a.u[b]&f_b)!=0)return true;if(a.C[b]==1)return false;return ZXb.Hl(a,b)||a.C[b]==13||a.C[b]>=171;};ZXb.mp=function mp(a){var b,c,d,e,f,g,h,i,j,k;f=ZXb.Sk(a,a.q,a.r,ZXb.Rj);g=f*f/16;for(d=1;d<a.q;d++){for(e=0;e<d;e++){i=a.J[e].a-a.J[d].a;j=a.J[e].b-a.J[d].b;k=a.J[e].c-a.J[d].c;if(i*i+j*j+k*k<g)throw Gwb(new UXb.aA('The distance between two atoms is too close.'));}}ZXb.nu(a,1);b=0;for(c=0;c<a.f;c++){if(ZXb.ko(a,c)>(h=ZXb.kl(a,c),h+ZXb.il(a,c,h)))throw Gwb(new UXb.aA('atom valence exceeded'));b+=a.s[c];}if(b!=0)throw Gwb(new UXb.aA('unbalanced atom charge'));};ZXb.np=function np(a,b,c){var d;d=ZXb.Vm(a,b,c);if(d&&c==386){ZXb.nu(a,7);d=d&(a.F[b]&128)==0;}return d;};ZXb.op=function op(){ZXb.Ym.call(this);};ZXb.pp=function pp(a,b){ZXb.Zm.call(this,a,b);};ZXb.qp=function qp(a){ZXb.Zm.call(this,!a?256:a.M,!a?256:a.N);!!a&&ZXb.mk(a,this);};wxb(97,113,{97:1,113:1,4:1});_.Mb=function rp(a){ZXb.wn(this,a);};_.Lb=function sp(a){return ZXb.Mo(this,a);};_.f=0;_.g=0;TXb.Ilb=UFb(97);ZXb.tp=function tp(a,b){return $wnd.Math.pow(10,$wnd.Math.log(2000)*$wnd.Math.LOG10E*a/(b-1)-1);};ZXb.up=function up(a,b){var c,d;c=b;d=0;while(b!=0){if(a.d==0){a.f=(a.c[++a.e]&63)<<11;a.d=6;}d|=(nZb&a.f)>>16-c+b;a.f<<=1;--b;--a.d;}return d;};ZXb.vp=function vp(a,b,c){a.d=6;a.e=c;a.c=b;a.f=(b[a.e]&63)<<11;};ZXb.wp=function wp(a,b){var c,d,e,f;d=b/2|0;e=a>=d;e&&(a-=d);f=b/32|0;c=f*a/(d-a);return e?-c:c;};ZXb.xp=function xp(a,b){var c;return b==null||XXb.KTb(b).length==0?null:ZXb.zp(a,XXb.lTb((c=b,XXb.gTb(),c)),null);};ZXb.yp=function yp(a,b,c){var d,e;return b==null?null:ZXb.zp(a,XXb.lTb((e=b,XXb.gTb(),e)),c==null?null:XXb.lTb((d=c,d)));};ZXb.zp=function zp(a,b,c){var d,e,f,g,h;ZXb.vp(a,b,0);d=ZXb.up(a,4);g=ZXb.up(a,4);d>8&&(d=g);e=ZXb.up(a,d);f=ZXb.up(a,g);h=new ZXb.Gu(e,f);ZXb.Dp(a,h,b,c,0);return h;};ZXb.Ap=function Ap(a,b,c){var d,e,f,g;if(c==null||XXb.KTb(c).length==0){ZXb.Cp(a,b,null,null);return;}d=UXb.GHb(c,THb(32));d>0&&d<XXb.KTb(c).length-1?ZXb.Cp(a,b,XXb.lTb((f=(XXb.ETb(0,d,XXb.KTb(c).length),XXb.KTb(c).substr(0,d)),XXb.gTb(),f)),XXb.lTb((g=(XXb.FTb(d+1,XXb.KTb(c).length+1),XXb.KTb(c).substr(d+1)),g))):ZXb.Cp(a,b,XXb.lTb((e=c,XXb.gTb(),e)),null);};ZXb.Bp=function Bp(a,b,c,d){var e,f,g,h;f=c==null?null:XXb.lTb((h=c,XXb.gTb(),h));e=d==null?null:XXb.lTb((g=d,XXb.gTb(),g));ZXb.Cp(a,b,f,e);};ZXb.Cp=function Cp(a,b,c,d){if(c==null||c.length==0){ZXb.hk(b);return;}ZXb.Dp(a,b,c,d,0);};ZXb.Dp=function Dp(b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab,bb,cb,db,eb,fb,gb,hb,ib,jb,kb,lb,mb,nb,ob,pb,qb,rb,sb,tb,ub,vb,wb,xb,yb,zb,Ab,Bb,Cb,Db,Eb,Fb,Gb,Hb,Ib,Jb,Kb,Lb,Mb,Nb,Ob,Pb,Qb,Rb,Sb,Tb,Ub,Vb,Wb,Xb,Yb,Zb,$b,_b,ac,bc,cc,dc,ec,fc,gc,hc,ic,jc,kc,lc,mc,nc,oc,pc,qc,rc,sc,tc,uc,vc,wc,xc,yc,zc,Ac;ZXb.hk(c);if(d==null||0>=d.length)return;b.g=c;uc=8;e!=null&&(f<0||f>=e.length)&&(e=null);ZXb.vp(b,d,0);i=ZXb.up(b,4);B=ZXb.up(b,4);if(i>8){uc=i;i=B;}if(i==0){ZXb.Hm(b.g,ZXb.up(b,1)==1);return;}j=ZXb.up(b,i);k=ZXb.up(b,B);ic=ZXb.up(b,i);mc=ZXb.up(b,i);lc=ZXb.up(b,i);O=ZXb.up(b,i);for(o=0;o<j;o++)ZXb.Uj(b.g,6);for(kb=0;kb<ic;kb++)ZXb.vm(b.g,ZXb.up(b,i),7);for(lb=0;lb<mc;lb++)ZXb.vm(b.g,ZXb.up(b,i),8);for(wb=0;wb<lc;wb++)ZXb.vm(b.g,ZXb.up(b,i),ZXb.up(b,8));for(Hb=0;Hb<O;Hb++)ZXb.cm(b.g,ZXb.up(b,i),ZXb.up(b,4)-8);P=1+k-j;V=ZXb.up(b,4);A=0;ZXb.sm(b.g,0,0);ZXb.tm(b.g,0,0);ZXb.um(b.g,0,0);W=e!=null&&e[f]>=39;tc=0;wc=0;yc=0;Ac=0;R=false;S=false;if(W){if(e.length>2*j-2&&e[2*j-2]==39||e.length>3*j-3&&e[3*j-3]==39){S=true;R=e.length==3*j-3+9;_b=R?3*j-3:2*j-2;w=86*(e[_b+1]-40)+e[_b+2]-40;tc=$wnd.Math.pow(10,w/2000-1);_b+=2;vc=86*(e[_b+1]-40)+e[_b+2]-40;wc=$wnd.Math.pow(10,vc/1500-1);_b+=2;xc=86*(e[_b+1]-40)+e[_b+2]-40;yc=$wnd.Math.pow(10,xc/1500-1);if(R){_b+=2;zc=86*(e[_b+1]-40)+e[_b+2]-40;Ac=$wnd.Math.pow(10,zc/1500-1);}}else {R=e.length==3*j-3;}}if(b.Nb()&&R){e=null;W=false;}for(Sb=1;Sb<j;Sb++){X=ZXb.up(b,V);if(X==0){if(W){ZXb.sm(b.g,Sb,ZXb.Nk(b.g,0)+8*(e[Sb*2-2]-83));ZXb.tm(b.g,Sb,ZXb.Ok(b.g,0)+8*(e[Sb*2-1]-83));R&&ZXb.um(b.g,Sb,ZXb.Pk(b.g,0)+8*(e[2*j-3+Sb]-83));}++P;continue;}A+=X-1;if(W){ZXb.sm(b.g,Sb,ZXb.Nk(b.g,A)+e[Sb*2-2]-83);ZXb.tm(b.g,Sb,ZXb.Ok(b.g,A)+e[Sb*2-1]-83);R&&ZXb.um(b.g,Sb,ZXb.Pk(b.g,A)+(e[2*j-3+Sb]-83));}ZXb.Wj(b.g,A,Sb,1);}for(Wb=0;Wb<P;Wb++)ZXb.Wj(b.g,ZXb.up(b,i),ZXb.up(b,i),1);ac=Rjb(TXb.Bwb,JZb,6,k,16,1);for(I=0;I<k;I++){J=ZXb.up(b,2);switch(J){case 0:ac[I]=true;break;case 2:ZXb.Fm(b.g,I,2);break;case 3:ZXb.Fm(b.g,I,4);}}h=ZXb.up(b,i);for(Xb=0;Xb<h;Xb++){n=ZXb.up(b,i);if(uc==8){nc=ZXb.up(b,2);if(nc==3){ZXb.hm(b.g,n,1,0);ZXb.nm(b.g,n,1,false);}else {ZXb.nm(b.g,n,nc,false);}}else {nc=ZXb.up(b,3);switch(nc){case 4:ZXb.nm(b.g,n,1,false);ZXb.hm(b.g,n,1,ZXb.up(b,3));break;case 5:ZXb.nm(b.g,n,2,false);ZXb.hm(b.g,n,1,ZXb.up(b,3));break;case 6:ZXb.nm(b.g,n,1,false);ZXb.hm(b.g,n,2,ZXb.up(b,3));break;case 7:ZXb.nm(b.g,n,2,false);ZXb.hm(b.g,n,2,ZXb.up(b,3));break;default:ZXb.nm(b.g,n,nc,false);}}}uc==8&&ZXb.up(b,1)==0&&(b.g.L=true);g=ZXb.up(b,B);for(Yb=0;Yb<g;Yb++){D=ZXb.up(b,B);if(ZXb.el(b.g,D)==1){nc=ZXb.up(b,3);switch(nc){case 4:ZXb.Cm(b.g,D,1,false);ZXb.zm(b.g,D,1,ZXb.up(b,3));break;case 5:ZXb.Cm(b.g,D,2,false);ZXb.zm(b.g,D,1,ZXb.up(b,3));break;case 6:ZXb.Cm(b.g,D,1,false);ZXb.zm(b.g,D,2,ZXb.up(b,3));break;case 7:ZXb.Cm(b.g,D,2,false);ZXb.zm(b.g,D,2,ZXb.up(b,3));break;default:ZXb.Cm(b.g,D,nc,false);}}else {ZXb.Cm(b.g,D,ZXb.up(b,2),false);}}ZXb.Hm(b.g,ZXb.up(b,1)==1);m=null;kc=0;while(ZXb.up(b,1)==1){U=kc+ZXb.up(b,4);switch(U){case 0:jc=ZXb.up(b,i);for(Zb=0;Zb<jc;Zb++){n=ZXb.up(b,i);ZXb.om(b.g,n,w$b,true);}break;case 1:jc=ZXb.up(b,i);for($b=0;$b<jc;$b++){n=ZXb.up(b,i);gc=ZXb.up(b,8);ZXb.mm(b.g,n,gc);}break;case 2:jc=ZXb.up(b,B);for(mb=0;mb<jc;mb++){ZXb.up(b,B);}break;case 3:jc=ZXb.up(b,i);for(nb=0;nb<jc;nb++){n=ZXb.up(b,i);ZXb.om(b.g,n,RZb,true);}break;case 4:jc=ZXb.up(b,i);for(ob=0;ob<jc;ob++){n=ZXb.up(b,i);rc=exb(Uwb(ZXb.up(b,4)),3);ZXb.om(b.g,n,rc,true);}break;case 5:jc=ZXb.up(b,i);for(pb=0;pb<jc;pb++){n=ZXb.up(b,i);l=exb(Uwb(ZXb.up(b,2)),1);ZXb.om(b.g,n,l,true);}break;case 6:jc=ZXb.up(b,i);for(qb=0;qb<jc;qb++){n=ZXb.up(b,i);ZXb.om(b.g,n,1,true);}break;case 7:jc=ZXb.up(b,i);for(rb=0;rb<jc;rb++){n=ZXb.up(b,i);hb=exb(Uwb(ZXb.up(b,4)),7);ZXb.om(b.g,n,hb,true);}break;case 8:jc=ZXb.up(b,i);for(sb=0;sb<jc;sb++){n=ZXb.up(b,i);t=ZXb.up(b,4);r=Rjb(TXb.klb,xZb,6,t,15,1);for(bc=0;bc<t;bc++){s=ZXb.up(b,8);r[bc]=s;}ZXb.im(b.g,n,r);}break;case 9:jc=ZXb.up(b,B);for(tb=0;tb<jc;tb++){D=ZXb.up(b,B);rc=ZXb.up(b,2)<<7;ZXb.Em(b.g,D,rc,true);}break;case 10:jc=ZXb.up(b,B);for(ub=0;ub<jc;ub++){D=ZXb.up(b,B);L=ZXb.up(b,5);ZXb.Em(b.g,D,L,true);}break;case 11:jc=ZXb.up(b,i);for(vb=0;vb<jc;vb++){n=ZXb.up(b,i);ZXb.om(b.g,n,v$b,true);}break;case 12:jc=ZXb.up(b,B);for(xb=0;xb<jc;xb++){D=ZXb.up(b,B);M=ZXb.up(b,8)<<9;ZXb.Em(b.g,D,M,true);}break;case 13:jc=ZXb.up(b,i);for(yb=0;yb<jc;yb++){n=ZXb.up(b,i);oc=exb(Uwb(ZXb.up(b,3)),14);ZXb.om(b.g,n,oc,true);}break;case 14:jc=ZXb.up(b,i);for(zb=0;zb<jc;zb++){n=ZXb.up(b,i);hc=exb(Uwb(ZXb.up(b,5)),17);ZXb.om(b.g,n,hc,true);}break;case 15:case 31:kc+=16;break;case 16:jc=ZXb.up(b,i);for(Ab=0;Ab<jc;Ab++){n=ZXb.up(b,i);qc=exb(Uwb(ZXb.up(b,3)),22);ZXb.om(b.g,n,qc,true);}break;case 17:jc=ZXb.up(b,i);for(Bb=0;Bb<jc;Bb++){n=ZXb.up(b,i);ZXb.am(b.g,n,ZXb.up(b,4));}break;case 18:jc=ZXb.up(b,i);fc=ZXb.up(b,4);for(Cb=0;Cb<jc;Cb++){n=ZXb.up(b,i);T=ZXb.up(b,fc);cc=Rjb(TXb.glb,R$b,6,T,15,1);for(bc=0;bc<T;bc++)cc[bc]=ZXb.up(b,7)<<24>>24;ZXb.fm(b.g,n,UXb.VHb(XXb.jTb(cc,0,(dc=cc.length,XXb.gTb(),dc))));}break;case 19:jc=ZXb.up(b,i);for(Db=0;Db<jc;Db++){n=ZXb.up(b,i);N=exb(Uwb(ZXb.up(b,3)),25);ZXb.om(b.g,n,N,true);}break;case 20:jc=ZXb.up(b,B);for(Eb=0;Eb<jc;Eb++){D=ZXb.up(b,B);qc=ZXb.up(b,3)<<17;ZXb.Em(b.g,D,qc,true);}break;case 21:jc=ZXb.up(b,i);for(Fb=0;Fb<jc;Fb++){n=ZXb.up(b,i);ZXb.pm(b.g,n,ZXb.up(b,2)<<4);}break;case 22:jc=ZXb.up(b,i);for(Gb=0;Gb<jc;Gb++){n=ZXb.up(b,i);ZXb.om(b.g,n,u$b,true);}break;case 23:jc=ZXb.up(b,B);for(Ib=0;Ib<jc;Ib++){D=ZXb.up(b,B);ZXb.Em(b.g,D,V$b,true);}break;case 24:jc=ZXb.up(b,B);for(Jb=0;Jb<jc;Jb++){D=ZXb.up(b,B);l=ZXb.up(b,2)<<21;ZXb.Em(b.g,D,l,true);}break;case 25:for(Kb=0;Kb<j;Kb++)ZXb.up(b,1)==1&&ZXb.qm(b.g,Kb,true);break;case 26:jc=ZXb.up(b,B);m=Rjb(TXb.klb,xZb,6,jc,15,1);for(Lb=0;Lb<jc;Lb++)m[Lb]=ZXb.up(b,B);break;case 27:jc=ZXb.up(b,i);for(Mb=0;Mb<jc;Mb++){n=ZXb.up(b,i);ZXb.om(b.g,n,KZb,true);}break;case 28:jc=ZXb.up(b,B);for(Nb=0;Nb<jc;Nb++)ZXb.Fm(b.g,ZXb.up(b,B),32);break;case 29:jc=ZXb.up(b,i);for(Ob=0;Ob<jc;Ob++){n=ZXb.up(b,i);gb=exb(Uwb(ZXb.up(b,2)),30);ZXb.om(b.g,n,gb,true);}break;case 30:jc=ZXb.up(b,i);for(Pb=0;Pb<jc;Pb++){n=ZXb.up(b,i);qc=exb(Uwb(ZXb.up(b,7)),32);ZXb.om(b.g,n,qc,true);}break;case 32:jc=ZXb.up(b,i);for(Qb=0;Qb<jc;Qb++){n=ZXb.up(b,i);sc=exb(Uwb(ZXb.up(b,2)),44);ZXb.om(b.g,n,sc,true);}break;case 33:jc=ZXb.up(b,i);for(Rb=0;Rb<jc;Rb++){n=ZXb.up(b,i);bb=exb(Uwb(ZXb.up(b,5)),39);ZXb.om(b.g,n,bb,true);}break;case 34:jc=ZXb.up(b,i);for(Tb=0;Tb<jc;Tb++){n=ZXb.up(b,i);ZXb.om(b.g,n,UZb,true);}break;case 35:jc=ZXb.up(b,B);for(Ub=0;Ub<jc;Ub++){D=ZXb.up(b,B);ZXb.Em(b.g,D,Y$b,true);}break;case 36:jc=ZXb.up(b,B);for(Vb=0;Vb<jc;Vb++){D=ZXb.up(b,B);K=ZXb.up(b,2)<<5;ZXb.Em(b.g,D,K,true);}break;case 37:jc=ZXb.up(b,B);for(jb=0;jb<jc;jb++){D=ZXb.up(b,B);K=ZXb.up(b,1)==0?8:16;ZXb.Fm(b.g,D,K);}}}ZXb.je(new ZXb.te(b.g),ac,false);if(m!=null)for(F=m,G=0,H=F.length;G<H;++G){D=F[G];ZXb.Fm(b.g,D,ZXb.el(b.g,D)==2?4:2);}if(e==null&&!b.i&&d.length>b.e+1&&(d[b.e+1]==32||d[b.e+1]==9)){e=d;f=b.e+2;}if(e!=null){try{if(e[f]==33||e[f]==35){ZXb.vp(b,e,f+1);R=ZXb.up(b,1)==1;S=ZXb.up(b,1)==1;pc=2*ZXb.up(b,4);C=1<<pc;eb=0;D=0;for(p=1;p<j;p++){if(D<k&&ZXb.Vk(b.g,1,D)==p){eb=ZXb.Vk(b.g,0,D++);db=1;}else {eb=0;db=8;}ZXb.sm(b.g,p,ZXb.Nk(b.g,eb)+db*(ZXb.up(b,pc)-(C/2|0)));ZXb.tm(b.g,p,ZXb.Ok(b.g,eb)+db*(ZXb.up(b,pc)-(C/2|0)));R&&ZXb.um(b.g,p,ZXb.Pk(b.g,eb)+db*(ZXb.up(b,pc)-(C/2|0)));}if(e[f]==35){ib=0;fb=Rjb(TXb.klb,xZb,6,j,15,1);for(q=0;q<j;q++)ib+=fb[q]=ZXb.fo(b.g,q);for(n=0;n<j;n++){for(jb=0;jb<fb[n];jb++){hb=ZXb.Uj(b.g,1);ZXb.Wj(b.g,n,hb,1);ZXb.sm(b.g,hb,ZXb.Nk(b.g,n)+(ZXb.up(b,pc)-(C/2|0)));ZXb.tm(b.g,hb,ZXb.Ok(b.g,n)+(ZXb.up(b,pc)-(C/2|0)));R&&ZXb.um(b.g,hb,ZXb.Pk(b.g,n)+(ZXb.up(b,pc)-(C/2|0)));}}j+=ib;k+=ib;}v=R?1.5:(ZXb.Sj(),ZXb.Sj(),ZXb.Rj);u=ZXb.Sk(b.g,j,k,v);if(S){tc=ZXb.tp(ZXb.up(b,pc),C);wc=tc*ZXb.wp(ZXb.up(b,pc),C);yc=tc*ZXb.wp(ZXb.up(b,pc),C);R&&(Ac=tc*ZXb.wp(ZXb.up(b,pc),C));db=tc/u;for(n=0;n<j;n++){ZXb.sm(b.g,n,wc+db*ZXb.Nk(b.g,n));ZXb.tm(b.g,n,yc+db*ZXb.Ok(b.g,n));R&&ZXb.um(b.g,n,Ac+db*ZXb.Pk(b.g,n));}}else {tc=1.5;db=tc/u;for(n=0;n<j;n++){ZXb.sm(b.g,n,db*ZXb.Nk(b.g,n));ZXb.tm(b.g,n,db*ZXb.Ok(b.g,n));R&&ZXb.um(b.g,n,db*ZXb.Pk(b.g,n));}}}else {R&&!S&&tc==0&&(tc=1.5);if(tc!=0&&b.g.r!=0){u=0;for(D=0;D<b.g.r;D++){Y=ZXb.Nk(b.g,ZXb.Vk(b.g,0,D))-ZXb.Nk(b.g,ZXb.Vk(b.g,1,D));Z=ZXb.Ok(b.g,ZXb.Vk(b.g,0,D))-ZXb.Ok(b.g,ZXb.Vk(b.g,1,D));$=R?ZXb.Pk(b.g,ZXb.Vk(b.g,0,D))-ZXb.Pk(b.g,ZXb.Vk(b.g,1,D)):0;u+=$wnd.Math.sqrt(Y*Y+Z*Z+$*$);}u/=b.g.r;cb=tc/u;for(n=0;n<b.g.q;n++){ZXb.sm(b.g,n,ZXb.Nk(b.g,n)*cb+wc);ZXb.tm(b.g,n,ZXb.Ok(b.g,n)*cb+yc);R&&ZXb.um(b.g,n,ZXb.Pk(b.g,n)*cb+Ac);}}}}catch(a){a=Fwb(a);if(Ykb(a,19)){ab=a;UXb.Jz(ab,(UXb.nIb(),UXb.mIb),'');'Faulty id-coordinates:'+UXb.Nz(ab,ab.Wb())+' '+UXb.VHb(XXb.jTb(d,0,(ec=d.length,XXb.gTb(),ec)))+' '+UXb.VHb(XXb.jTb(e,0,(dc=e.length,dc)));e=null;R=false;}else throw Gwb(a);}}Q=e!=null&&!R;if(Q||b.Nb()){ZXb.nu(b.g,7);for(D=0;D<b.g.g;D++)ZXb.bl(b.g,D)==2&&!ZXb.Yo(b.g,D)&&ZXb.cl(b.g,D)==0&&ZXb.Dm(b.g,D);}ZXb.gp(b.g,0);if(!Q&&b.Nb()){try{b.Ob(b.g);Q=true;}catch(a){a=Fwb(a);if(Ykb(a,19)){ab=a;UXb.Jz(ab,(UXb.nIb(),UXb.mIb),'');'2D-coordinate creation failed:'+UXb.Nz(ab,ab.Wb())+' '+UXb.VHb(XXb.jTb(d,0,(dc=d.length,XXb.gTb(),dc)));}else throw Gwb(a);}}if(Q){ZXb.jp(b.g);ZXb.Au(b.g);}else R||ZXb.gp(b.g,0);};ZXb.Ep=function Ep(a,b){var c,d,e,f,g,h;if(b.length<=0||b[0]<64)return;ZXb.vp(a,b,0);h=ZXb.up(a,4);e=ZXb.up(a,1)==1;f=ZXb.up(a,1)==1;for(c=0;c<a.g.f;c++){g=ZXb.up(a,h);d=e;e&&f&&(d=ZXb.up(a,1)==1);ZXb.km(a.g,c,g,d);}};ZXb.Fp=function Fp(){};wxb(396,1,{},ZXb.Fp);_.Nb=function Gp(){return false;};_.Ob=function Hp(a){throw Gwb(new UXb.aA('Unexpected request to invent coordinates. Check source code logic!'));};_.d=0;_.e=0;_.f=0;_.i=false;TXb.Jlb=UFb(396);ZXb.Ip=function Ip(a){};ZXb.Jp=function Jp(){ZXb.Kp.call(this,true);};ZXb.Kp=function Kp(a){ZXb.Ip(this);this.b=a;};wxb(50,396,{},ZXb.Jp,ZXb.Kp);_.Nb=function Lp(){return this.b;};_.Ob=function Mp(a){var b;b=new bYb.yy(this.a);b.g=new $Xb.UQb(78187493520);bYb.fy(b,a);};_.a=2;_.b=false;TXb.Klb=UFb(50);ZXb.Np=function Np(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r;e=b.a;n=b.g;j=bxb(Iwb(ZXb.Lk(a.k,e),1),0);f=ZXb.Gk(a.k,e);l=f!=null?ZXb.Up(a,e,f,d):j?'*':ZXb.Fk(a.k,e);!j&&f==null&&ZXb.Ho(a.k,e)&&(a.j&4)==0&&(ZXb.In(a.k,e)!=0||ZXb.xk(a.k,e)==-1&&ZXb.Mk(a.k,e)==0)&&(l=XXb.KTb(l).toLowerCase());b.f&&(c.a+='(',c);n!=-1&&ZXb.Rp(a,ZXb.Pn(a.k,b.a,b.g),b.g,c);g=ZXb.zk(a.k,e);if(g==0&&(a.j&1)!=0){h=Iwb(ZXb.Lk(a.k,e),XZb);Nwb(h,$Zb)==0?g=-1:Nwb(h,ZZb)==0&&(g=1);}k=ZXb.Jk(a.k,e);m=(a.j&2)!=0?ZXb.Ik(a.k,e):0;o=(a.j&1)!=0?ZXb.$p(a,e,d):null;r=!j&&!ZXb.fq(ZXb.Qk(a.k,e))||f!=null||(ZXb.Kk(a.k,e)==1||ZXb.Kk(a.k,e)==2)&&(q=ZXb.Ek(a.k,e)-1,!(q!=-1&&a.i[q][ZXb.Dk(a.k,e)]<=1))&&(ZXb.Qk(a.k,e)!=7||ZXb.zk(a.k,e)>0)||ZXb.Ho(a.k,e)&&ZXb.In(a.k,e)==0&&(a.j&4)==0||g!=0||k!=0||m!=0||ZXb.xk(a.k,e)!=-1||ZXb.Mk(a.k,e)!=0||o!=null;r&&(c.a+='[',c);k!=0&&(c.a+=k,c);c.a+=''+l;(ZXb.Kk(a.k,e)==1||ZXb.Kk(a.k,e)==2)&&(p=ZXb.Ek(a.k,e)-1,!(p!=-1&&a.i[p][ZXb.Dk(a.k,e)]<=1))&&(ZXb.Qk(a.k,e)!=7||ZXb.zk(a.k,e)>0)&&UXb.fIb(c,ZXb.Zp(a,e,n));if((a.j&1)==0&&r){i=ZXb.qo(a.k,e);i==1?(c.a+='H',c):i>1&&(c.a+='H'+i,c);}if(g!=0){c.a+=String.fromCharCode(g>0?43:45);$wnd.Math.abs(g)>1&&UXb.cIb(c,$wnd.Math.abs(g));}o!=null&&(c.a+=''+o,c);if(m!=0){c.a+=':';c.a+=m;}r&&(c.a+=']',c);ZXb.Sp(a,b,c);b.e&&(c.a+=')',c);};ZXb.Op=function Op(a,b,c){var d,e,f,g,h;f=true;h=$Xb.Xi(a.g,b).a;g=ZXb.bq(a,h);while(g!=-1){d=ZXb.Rn(a.k,h,g);e=ZXb.Tn(a.k,h,g);g=ZXb.bq(a,d);ZXb.Qp(a,new ZXb.Ct(d,e,h,c&&f,c&&g==-1),++b);h=d;f=false;}};ZXb.Pp=function Pp(a,b,c){var d,e,f,g;for(e=b,f=0,g=e.length;f<g;++f){d=e[f];a.f[d&1073741823]=(d&u_b)!=0^c?2:1;}};ZXb.Qp=function Qp(a,b,c){$Xb.Ri(a.g,c,b);a.b[b.a]=true;b.g!=-1&&(a.c[ZXb.Pn(a.k,b.a,b.g)]=true);};ZXb.Rp=function Rp(a,b,c,d){var e,f,g,h,i;i=XXb.KTb(d.a).length;a.f[b]!=0&&UXb.bIb(d,a.f[b]==1?47:92);if(a.j==1){f=ZXb.dl(a.k,127);if(f!=0){(f&1)!=0&&a.f[b]==0&&(d.a+='-',d);if((f&2)!=0){XXb.KTb(d.a).length!=i&&(d.a+=',',d);d.a+='=';}if((f&4)!=0){XXb.KTb(d.a).length!=i&&(d.a+=',',d);d.a+='#';}if((f&8)!=0){XXb.KTb(d.a).length!=i&&(d.a+=',',d);d.a+='$';}if((f&16)!=0){XXb.KTb(d.a).length!=i&&(d.a+=',',d);d.a+='$';}if((f&64)!=0){XXb.KTb(d.a).length!=i&&(d.a+=',',d);d.a+=':';}if((f&32)!=0){XXb.KTb(d.a).length!=i&&(d.a+=',',d);UXb.fIb(d,ZXb.Fl(a.k,c)?'<-':'->');}}}if(i==XXb.KTb(d.a).length&&(!ZXb.Io(a.k,b)||(a.j&4)!=0)){e=ZXb.el(a.k,b)&127;e==1?ZXb.Ho(a.k,ZXb.Vk(a.k,0,b))&&ZXb.Ho(a.k,ZXb.Vk(a.k,1,b))&&(a.j&4)==0&&a.f[b]==0&&(d.a+='-',d):e==2?(d.a+='=',d):e==4?(d.a+='#',d):e==8?(d.a+='$',d):e==16?(d.a+='$',d):e==64?(d.a+=':',d):e==32&&UXb.fIb(d,ZXb.Fl(a.k,c)?'<-':'->');}if(a.j==1){g=i==XXb.KTb(d.a).length?'':';';h=ZXb.dl(a.k,b)&384;h==256?(d.a+=g+'@',d):h==128&&(d.a+=g+'!@',d);}};ZXb.Sp=function Sp(a,b,c){var d,e,f;if(b.c!=null){for(e=0;e<b.c.length;e++){for(f=0;f<ZXb.Sn(a.k,b.a);f++){if(b.c[e]==ZXb.Rn(a.k,b.a,f)){d=ZXb.Tn(a.k,b.a,f);b.d[e]||ZXb.Rp(a,d,b.a,c);a.e[d]>9&&(c.a+='%',c);UXb.cIb(c,a.e[d]);}}}}};ZXb.Tp=function Tp(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O;M=new $Xb.kj();for(r=new $Xb.qOb(a.g);r.a<r.c.a.length;){q=$Xb.pOb(r);if(q.g!=-1){t=ZXb.Pn(a.k,q.a,q.g);if(!ZXb.Jo(a.k,t)&&!ZXb.Yo(a.k,t)&&(ZXb.cl(a.k,t)==1||ZXb.cl(a.k,t)==2)){K=$Xb.Xi(a.g,a.q[q.g]);c=Rjb(TXb.klb,xZb,6,ZXb.Sn(a.k,q.a)+ZXb.Sn(a.k,K.a)-2,15,1);B=0;L=false;if(K.g!=-1){c[B++]=K.b;}else {u=-1;N=-1;v=fZb;for(D=0;D<ZXb.Sn(a.k,K.a);D++){l=ZXb.Rn(a.k,K.a,D);if(l!=q.a){if(u==-1){u=D;v=a.q[l];}else {if(v<a.q[l]){N=D;}else {N=u;u=D;}}}}if(N==-1){H=ZXb.Rn(a.k,K.a,u);I=ZXb.Tn(a.k,K.a,u);c[B++]=I|(ZXb.dq(a,K.a,H)?u_b:0);}else {m=ZXb.Rn(a.k,K.a,u);o=ZXb.Tn(a.k,K.a,u);n=ZXb.Rn(a.k,K.a,N);p=ZXb.Tn(a.k,K.a,N);c[B++]=o|(ZXb.dq(a,K.a,m)?u_b:0);c[B++]=p|(ZXb.dq(a,K.a,n)?0:u_b);}}if(ZXb.Sn(a.k,K.a)==3&&K.g!=-1){for(D=0;D<ZXb.Sn(a.k,K.a);D++){l=ZXb.Rn(a.k,K.a,D);if(l!=K.g&&l!=q.a){d=ZXb.Tn(a.k,K.a,D);c[B++]=d|(ZXb.dq(a,K.a,l)?u_b:0);l<K.g&&(L=!L);break;}}}ZXb.cl(a.k,t)==2&&(L=!L);for(C=0;C<ZXb.Sn(a.k,q.a);C++){i=ZXb.Rn(a.k,q.a,C);if(i!=q.g){A=L;if(ZXb.Sn(a.k,q.a)==3){for(G=0;G<ZXb.Sn(a.k,q.a);G++){l=ZXb.Rn(a.k,q.a,G);if(l!=q.g&&l!=i){l<i&&(A=!A);break;}}}if(ZXb.Al(a.k,t)){w=ZXb.Pf(a.d,t);if(!a.n[w]){a.n[w]=true;a.o[w]=A;}a.o[w]&&(A=!A);}j=ZXb.Pn(a.k,q.a,i);c[B++]=j|(A^ZXb.dq(a,q.a,i)?0:u_b);}}XXb.bTb(M.a,c);}}}a.f=Rjb(TXb.klb,xZb,6,a.k.g,15,1);M.a.length!=0&&ZXb.Pp(a,$Xb.cj(M,0),false);while(M.a.length!=0){O=M.a.length;for(C=M.a.length-1;C>=0;C--){c=(XXb.yTb(C,M.a.length),M.a[C]);J=0;F=false;k=false;for(f=c,g=0,h=f.length;g<h;++g){e=f[g];b=e&1073741823;if(a.f[b]!=0){s=(e&u_b)!=0^a.f[b]==2;J==0?F=s:F!=s&&(k=true);++J;}}if(J!=0){c=$Xb.cj(M,C);k||ZXb.Pp(a,c,F);}}O==M.a.length&&ZXb.Pp(a,$Xb.cj(M,0),false);}};ZXb.Up=function Up(a,b,c,d){var e,f,g,h,i,j,k;k=XXb.KTb(d.a).length;0<k?d.a=UXb.QHb(d.a,0,0):0>k&&(d.a+=UXb.VHb(Rjb(TXb.hlb,M$b,6,-k,15,1)));i=ZXb.Ho(a.k,b)&&(a.j&4)==0;for(f=c,g=0,h=f.length;g<h;++g){e=f[g];XXb.KTb(d.a).length!=0&&(d.a+=',',d);j=(ZXb.Sj(),ZXb.Mj)[e];UXb.fIb(d,i?XXb.KTb(j).toLowerCase():j);}return d.a;};ZXb.Vp=function Vp(a){var b,c,d,e,f,g,h,i;if(!a.k||a.k.q==0)return '';ZXb.nu(a.k,15);a.d=new ZXb.ig(a.k,129);e=a.d.R;a.o=Rjb(TXb.Bwb,JZb,6,e+1,16,1);a.n=Rjb(TXb.Bwb,JZb,6,e+1,16,1);a.i=Pjb(TXb.klb,[P$b,xZb],[8,6],15,[2,32],2);for(b=0;b<a.k.f;b++){i=ZXb.Ek(a.k,b)-1;i!=-1&&++a.i[i][ZXb.Dk(a.k,b)];}ZXb.Yp(a);ZXb.Wp(a);ZXb.Tp(a);d=new UXb.iIb();c=new UXb.iIb();f=true;for(h=new $Xb.qOb(a.g);h.a<h.c.a.length;){g=$Xb.pOb(h);g.g==-1&&(f?f=false:(d.a+='.',d));ZXb.Np(a,g,d,c);}return d.a;};ZXb.Wp=function Wp(a){var b,c,d,e,f,g,h,i,j,k,l;for(l=new $Xb.qOb(a.g);l.a<l.c.a.length;){j=$Xb.pOb(l);c=0;for(f=0;f<ZXb.Sn(a.k,j.a);f++)a.c[ZXb.Tn(a.k,j.a,f)]||++c;if(c!=0){j.c=Rjb(TXb.klb,xZb,6,c,15,1);c=0;for(g=0;g<ZXb.Sn(a.k,j.a);g++){if(!a.c[ZXb.Tn(a.k,j.a,g)]){i=ZXb.Rn(a.k,j.a,g);j.c[c++]=a.q[i]<<16|i;}}XXb.eTb(j.c,XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));for(e=0;e<j.c.length;e++)j.c[e]=oZb&j.c[e];}}d=Rjb(TXb.Bwb,JZb,6,a.k.g,16,1);a.e=Rjb(TXb.klb,xZb,6,a.k.g,15,1);for(k=new $Xb.qOb(a.g);k.a<k.c.a.length;){j=$Xb.pOb(k);if(j.c!=null){j.d=Rjb(TXb.Bwb,JZb,6,j.c.length,16,1);for(e=0;e<j.c.length;e++){for(h=0;h<ZXb.Sn(a.k,j.a);h++){if(j.c[e]==ZXb.Rn(a.k,j.a,h)){b=ZXb.Tn(a.k,j.a,h);if(a.c[b]){d[a.e[b]]=false;}else {a.c[b]=true;j.d[e]=true;a.e[b]=1;while(d[a.e[b]])++a.e[b];d[a.e[b]]=true;}}}}}}};ZXb.Xp=function Xp(a){var b,c,d,e;d=-1;e=fZb;for(b=0;b<a.k.f;b++){if(!a.b[b]){c=a.a[b];bxb(Iwb(ZXb.Lk(a.k,b),KZb),0)&&(c+=u_b);ZXb.Sn(a.k,b)==0?c+=1056964608:c+=ZXb.Sn(a.k,b)<<24;if(e>c){e=c;d=b;}}}return d;};ZXb.Yp=function Yp(a){var b,c,d,e,f;a.a=a.d.d;a.b=Rjb(TXb.Bwb,JZb,6,a.k.f,16,1);a.c=Rjb(TXb.Bwb,JZb,6,a.k.g,16,1);a.g=new $Xb.kj();b=ZXb.Xp(a);while(b!=-1){c=a.g.a.length;ZXb.Qp(a,new ZXb.Ct(b,-1,-1,false,false),c);if(ZXb.Sn(a.k,b)!=0){ZXb.Op(a,c,false);while(c<a.g.a.length-1){while(ZXb.cq(a,$Xb.Xi(a.g,c).a))ZXb.Op(a,c,true);++c;}}b=ZXb.Xp(a);}a.q=Rjb(TXb.klb,xZb,6,a.k.f,15,1);d=0;for(f=new $Xb.qOb(a.g);f.a<f.c.a.length;){e=$Xb.pOb(f);a.q[e.a]=d++;}};ZXb.Zp=function Zp(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;h=false;if(ZXb.In(a.k,b)!=0&&ZXb.Sn(a.k,b)==2&&ZXb.Un(a.k,b,0)==2&&ZXb.Un(a.k,b,1)==2){for(f=0;f<ZXb.Sn(a.k,b);f++){d=ZXb.Rn(a.k,b,f);n=0;m=Rjb(TXb.klb,xZb,6,3,15,1);for(j=0;j<ZXb.Sn(a.k,d);j++){m[n]=ZXb.Rn(a.k,d,j);m[n]!=b&&++n;}n==2&&a.q[m[0]]<a.q[m[1]]^m[0]<m[1]&&(h=!h);}}else {k=Rjb(TXb.klb,xZb,6,4,15,1);l=Rjb(TXb.klb,xZb,6,4,15,1);g=0;if(c!=-1){k[g]=c;l[g++]=8*a.q[c];}if(ZXb.fo(a.k,b)!=0){k[g]=fZb;l[g++]=8*a.q[b];}else if(ZXb.Sn(a.k,b)==3){k[g]=fZb;l[g++]=8*a.q[b];}for(f=0;f<ZXb.Sn(a.k,b);f++){d=ZXb.Rn(a.k,b,f);if(d!=c){k[g]=d;l[g++]=ZXb.aq(a,b,f);}}h=ZXb.eq(k,l);}i=ZXb.Kk(a.k,b)==1^h;if(ZXb.tl(a.k,b)){e=ZXb.Qf(a.d,b);if(!a.n[e]){a.n[e]=true;a.o[e]=i;}a.o[e]&&(i=!i);}return i?'@@':'@';};ZXb.$p=function $p(a,b,c){var d,e,f,g,h,i,j,k;h=XXb.KTb(c.a).length;0<h?c.a=UXb.QHb(c.a,0,0):0>h&&(c.a+=UXb.VHb(Rjb(TXb.hlb,M$b,6,-h,15,1)));i=ZXb.Lk(a.k,b);e=kxb(fxb(Iwb(i,XZb),3));switch(e){case 20971520:c.a+='+0';break;case 25165824:ZXb.zk(a.k,b)==0&&(c.a+='-',c);break;case 12582912:ZXb.zk(a.k,b)==0&&(c.a+='+',c);}d=Iwb(i,U$b);Nwb(d,2)==0?(c.a+=';a',c):Nwb(d,4)==0&&(c.a+=';A',c);f=Iwb(i,VZb);Nwb(f,0)!=0&&(Nwb(f,1792)==0?(c.a+=';H0',c):Nwb(f,1664)==0?(c.a+=';H1',c):Nwb(f,1408)==0?(c.a+=';H2',c):Nwb(f,896)==0?(c.a+=';H3',c):Nwb(f,128)==0?(c.a+=';!H0',c):Nwb(f,384)==0?(c.a+=';!H0;!H1',c):Nwb(f,1536)==0?(c.a+=';!H2;!H3',c):Nwb(f,WZb)==0&&(c.a+=';!H3',c));k=Iwb(i,120);Nwb(k,8)==0?(c.a+=';!R0',c):Nwb(k,16)==0?(c.a+=';!R1',c):Nwb(k,32)==0?(c.a+=';!R2',c):Nwb(k,64)==0?(c.a+=';!R3',c):Nwb(k,112)==0?(c.a+=';R0',c):Nwb(k,104)==0?(c.a+=';R1',c):Nwb(k,88)==0?(c.a+=';R2',c):Nwb(k,56)==0&&(c.a+=';R3',c);j=Iwb(i,BZb);if(Nwb(j,CZb)==0)c.a+=';!r'+lxb(j);else if(Nwb(j,v_b)==0)c.a+=';r'+lxb(j);else if(Nwb(j,0)!=0){if(bxb(Iwb(j,IZb),0)){Swb(Iwb(j,CZb),0)&&(c.a+=';!r0'+lxb(j),c);Swb(Iwb(j,DZb),0)&&(c.a+=';!r3'+lxb(j),c);Swb(Iwb(j,EZb),0)&&(c.a+=';!r4'+lxb(j),c);Swb(Iwb(j,FZb),0)&&(c.a+=';!r5'+lxb(j),c);Swb(Iwb(j,GZb),0)&&(c.a+=';!r6'+lxb(j),c);Swb(Iwb(j,HZb),0)&&(c.a+=';!r7'+lxb(j),c);}else {c.a+=';';bxb(Iwb(j,CZb),0)&&(c.a+='r0,'+lxb(j),c);bxb(Iwb(j,DZb),0)&&(c.a+='r3,'+lxb(j),c);bxb(Iwb(j,EZb),0)&&(c.a+='r4,'+lxb(j),c);bxb(Iwb(j,FZb),0)&&(c.a+='r5,'+lxb(j),c);bxb(Iwb(j,GZb),0)&&(c.a+='r6,'+lxb(j),c);bxb(Iwb(j,HZb),0)&&(c.a+='r7,'+lxb(j),c);UXb.ZEb(c,XXb.KTb(c.a).length-1);}}if(Nwb(j,0)==0){j=fxb(Iwb(i,t$b),22);Nwb(j,0)!=0&&(c.a+=';r'+lxb(j),c);}g=Iwb(i,a$b);Nwb(g,b$b)==0&&(c.a+=';D1',c);Nwb(g,c$b)==0&&(c.a+=';D2',c);Nwb(g,d$b)==0&&(c.a+=';D3',c);Nwb(g,e$b)==0&&(c.a+=';!D3;!D4',c);Nwb(g,f$b)==0&&(c.a+=';!D4',c);Nwb(g,g$b)==0&&(c.a+=';!D0;!D1',c);Nwb(g,h$b)==0&&(c.a+=';!D0;!D1;!D2',c);Nwb(g,i$b)==0&&(c.a+=';!D0;!D1;!D2;!D3',c);bxb(Iwb(i,w$b),0)&&UXb.fIb(c,';D'+ZXb.Sn(a.k,b));bxb(Iwb(i,RZb),0)&&UXb.fIb(c,';!D'+ZXb.Sn(a.k,b));return XXb.KTb(c.a).length==0?null:c.a;};ZXb._p=function _p(a){a.p==null&&(a.p=ZXb.Vp(a));return a.p;};ZXb.aq=function aq(a,b,c){var d,e,f,g,h;d=ZXb.Tn(a.k,b,c);g=ZXb.Rn(a.k,b,c);if(a.e[d]!=0){h=8*a.q[b]+1;e=$Xb.Xi(a.g,a.q[b]).c;for(f=0;f<e.length&&g!=e[f];f++)++h;return h;}return 8*a.q[g];};ZXb.bq=function bq(a,b){var c,d,e,f,g;c=-1;d=-1;for(f=0;f<ZXb.Sn(a.k,b);f++){e=ZXb.Rn(a.k,b,f);g=(ZXb.Un(a.k,b,f)<<24)+a.a[e];if(!a.b[e]&&(c==-1||d<g)){c=f;d=g;}}return c;};ZXb.cq=function cq(a,b){var c;for(c=0;c<ZXb.Sn(a.k,b);c++)if(!a.b[ZXb.Rn(a.k,b,c)])return true;return false;};ZXb.dq=function dq(a,b,c){var d,e;d=$Xb.Xi(a.g,a.q[b]);if(d.g==c)return false;e=$Xb.Xi(a.g,a.q[c]);if(e.g==b)return true;return ZXb.Bt(e,b);};ZXb.eq=function eq(a,b){var c,d,e;d=false;for(c=1;c<4;c++){for(e=0;e<c;e++){a[e]>a[c]&&(d=!d);b[e]>b[c]&&(d=!d);}}return d;};ZXb.fq=function fq(a){return a>=5&&a<=9||a>=15&&a<=17||a==35||a==53;};ZXb.gq=function gq(a){ZXb.iq.call(this,a,false);};ZXb.hq=function hq(a,b){this.k=a;this.j=b;};ZXb.iq=function iq(a,b){ZXb.hq.call(this,a,b?2:0);};ZXb.jq=function jq(a){var b,c,d,e;e=new UXb.iIb();for(c=0;c<a.g.a.length;c++){c!=0&&(e.a+='.',e);UXb.fIb(e,ZXb._p(new ZXb.hq($Xb.Xi(a.g,c),2)));}e.a+='>';for(d=0;d<a.a.a.length;d++){d!=0&&(e.a+='.',e);UXb.fIb(e,ZXb._p(new ZXb.gq($Xb.Xi(a.a,d))));}e.a+='>';for(b=0;b<a.f.a.length;b++){b!=0&&(e.a+='.',e);UXb.fIb(e,ZXb._p(new ZXb.hq($Xb.Xi(a.f,b),2)));}return e.a;};wxb(112,1,{},ZXb.gq,ZXb.hq,ZXb.iq);_.j=0;TXb.Llb=UFb(112);ZXb.kq=function kq(a,b){this.b=a;this.a=b;};wxb(3,1,{3:1},ZXb.kq);_.a=0;_.b=0;TXb.Mlb=UFb(3);ZXb.mq=function mq(){ZXb.mq=yxb;ZXb.lq=Zjb(Ljb(TXb.Mlb,2),_Yb,17,0,[null,Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(0,1.007825032),new ZXb.kq(1,2.014101778),new ZXb.kq(2,3.016049268),new ZXb.kq(3,4.027834627),new ZXb.kq(4,5.039542911),new ZXb.kq(5,6.044942608)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(1,3.01602931),new ZXb.kq(2,4.00260325),new ZXb.kq(3,5.012223628),new ZXb.kq(4,6.018888072),new ZXb.kq(5,7.028030527),new ZXb.kq(6,8.033921838),new ZXb.kq(7,9.043820323),new ZXb.kq(8,10.052399713)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(1,4.027182329),new ZXb.kq(2,5.012537796),new ZXb.kq(3,6.015122281),new ZXb.kq(4,7.016004049),new ZXb.kq(5,8.02248667),new ZXb.kq(6,9.026789122),new ZXb.kq(7,10.035480884),new ZXb.kq(8,11.043796166),new ZXb.kq(9,12.05378)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(1,5.04079),new ZXb.kq(2,6.019725804),new ZXb.kq(3,7.016929246),new ZXb.kq(4,8.005305094),new ZXb.kq(5,9.012182135),new ZXb.kq(6,10.01353372),new ZXb.kq(7,11.021657653),new ZXb.kq(8,12.026920631),new ZXb.kq(9,13.036133834),new ZXb.kq(10,14.042815522)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(2,7.029917389),new ZXb.kq(3,8.024606713),new ZXb.kq(4,9.013328806),new ZXb.kq(5,10.012937027),new ZXb.kq(6,11.009305466),new ZXb.kq(7,12.014352109),new ZXb.kq(8,13.017780267),new ZXb.kq(9,14.025404064),new ZXb.kq(10,15.031097291),new ZXb.kq(11,16.039808836),new ZXb.kq(12,17.046931399),new ZXb.kq(13,18.05617),new ZXb.kq(14,19.06373)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(2,8.037675026),new ZXb.kq(3,9.031040087),new ZXb.kq(4,10.01685311),new ZXb.kq(5,11.011433818),new ZXb.kq(6,12),new ZXb.kq(7,13.003354838),new ZXb.kq(8,14.003241988),new ZXb.kq(9,15.010599258),new ZXb.kq(10,16.014701243),new ZXb.kq(11,17.022583712),new ZXb.kq(12,18.026757058),new ZXb.kq(13,19.035248094),new ZXb.kq(14,20.040322395),new ZXb.kq(15,21.04934),new ZXb.kq(16,22.05645)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(3,10.042618),new ZXb.kq(4,11.026796226),new ZXb.kq(5,12.018613202),new ZXb.kq(6,13.005738584),new ZXb.kq(7,14.003074005),new ZXb.kq(8,15.000108898),new ZXb.kq(9,16.006101417),new ZXb.kq(10,17.008449673),new ZXb.kq(11,18.014081827),new ZXb.kq(12,19.017026896),new ZXb.kq(13,20.023367295),new ZXb.kq(14,21.027087574),new ZXb.kq(15,22.034440259),new ZXb.kq(16,23.04051),new ZXb.kq(17,24.0505)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(4,12.034404776),new ZXb.kq(5,13.0248104),new ZXb.kq(6,14.008595285),new ZXb.kq(7,15.003065386),new ZXb.kq(8,15.994914622),new ZXb.kq(9,16.999131501),new ZXb.kq(10,17.999160419),new ZXb.kq(11,19.00357873),new ZXb.kq(12,20.00407615),new ZXb.kq(13,21.008654631),new ZXb.kq(14,22.009967157),new ZXb.kq(15,23.015691325),new ZXb.kq(16,24.020369922),new ZXb.kq(17,25.02914),new ZXb.kq(18,26.03775)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(5,14.03608),new ZXb.kq(6,15.018010856),new ZXb.kq(7,16.01146573),new ZXb.kq(8,17.002095238),new ZXb.kq(9,18.000937667),new ZXb.kq(10,18.998403205),new ZXb.kq(11,19.999981324),new ZXb.kq(12,20.999948921),new ZXb.kq(13,22.00299925),new ZXb.kq(14,23.003574385),new ZXb.kq(15,24.008099371),new ZXb.kq(16,25.012094963),new ZXb.kq(17,26.019633157),new ZXb.kq(18,27.026892316),new ZXb.kq(19,28.03567),new ZXb.kq(20,29.04326)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(6,16.025756907),new ZXb.kq(7,17.017697565),new ZXb.kq(8,18.005697066),new ZXb.kq(9,19.001879839),new ZXb.kq(10,19.992440176),new ZXb.kq(11,20.993846744),new ZXb.kq(12,21.99138551),new ZXb.kq(13,22.994467337),new ZXb.kq(14,23.993615074),new ZXb.kq(15,24.997789899),new ZXb.kq(16,26.000461498),new ZXb.kq(17,27.0076152),new ZXb.kq(18,28.012108072),new ZXb.kq(19,29.019345902),new ZXb.kq(20,30.023872),new ZXb.kq(21,31.03311),new ZXb.kq(22,32.03991)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(7,18.02718),new ZXb.kq(8,19.01387945),new ZXb.kq(9,20.00734826),new ZXb.kq(10,20.997655099),new ZXb.kq(11,21.994436782),new ZXb.kq(12,22.989769675),new ZXb.kq(13,23.990963332),new ZXb.kq(14,24.989954352),new ZXb.kq(15,25.992589898),new ZXb.kq(16,26.994008702),new ZXb.kq(17,27.99889041),new ZXb.kq(18,29.002811301),new ZXb.kq(19,30.009226487),new ZXb.kq(20,31.013595108),new ZXb.kq(21,32.019649792),new ZXb.kq(22,33.027386),new ZXb.kq(23,34.0349),new ZXb.kq(24,35.04418)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(8,20.018862744),new ZXb.kq(9,21.011714174),new ZXb.kq(10,21.999574055),new ZXb.kq(11,22.99412485),new ZXb.kq(12,23.985041898),new ZXb.kq(13,24.985837023),new ZXb.kq(14,25.98259304),new ZXb.kq(15,26.984340742),new ZXb.kq(16,27.983876703),new ZXb.kq(17,28.988554743),new ZXb.kq(18,29.990464529),new ZXb.kq(19,30.996548459),new ZXb.kq(20,31.999145889),new ZXb.kq(21,33.005586975),new ZXb.kq(22,34.00907244),new ZXb.kq(23,35.018669),new ZXb.kq(24,36.02245),new ZXb.kq(25,37.03124)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(8,21.02804),new ZXb.kq(9,22.01952),new ZXb.kq(10,23.0072649),new ZXb.kq(11,23.999940911),new ZXb.kq(12,24.990428555),new ZXb.kq(13,25.986891659),new ZXb.kq(14,26.981538441),new ZXb.kq(15,27.981910184),new ZXb.kq(16,28.980444848),new ZXb.kq(17,29.982960304),new ZXb.kq(18,30.983946023),new ZXb.kq(19,31.988124379),new ZXb.kq(20,32.990869587),new ZXb.kq(21,33.996927255),new ZXb.kq(22,34.99993765),new ZXb.kq(23,36.006351501),new ZXb.kq(24,37.01031),new ZXb.kq(25,38.0169),new ZXb.kq(26,39.0219)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(8,22.03453),new ZXb.kq(9,23.02552),new ZXb.kq(10,24.011545711),new ZXb.kq(11,25.00410664),new ZXb.kq(12,25.992329935),new ZXb.kq(13,26.986704764),new ZXb.kq(14,27.976926533),new ZXb.kq(15,28.976494719),new ZXb.kq(16,29.973770218),new ZXb.kq(17,30.975363275),new ZXb.kq(18,31.974148129),new ZXb.kq(19,32.97800052),new ZXb.kq(20,33.978575745),new ZXb.kq(21,34.984584158),new ZXb.kq(22,35.986687363),new ZXb.kq(23,36.99299599),new ZXb.kq(24,37.99598),new ZXb.kq(25,39.0023),new ZXb.kq(26,40.0058),new ZXb.kq(27,41.0127),new ZXb.kq(28,42.0161)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(9,24.03435),new ZXb.kq(10,25.02026),new ZXb.kq(11,26.01178),new ZXb.kq(12,26.999191645),new ZXb.kq(13,27.99231233),new ZXb.kq(14,28.981801376),new ZXb.kq(15,29.978313807),new ZXb.kq(16,30.973761512),new ZXb.kq(17,31.973907163),new ZXb.kq(18,32.971725281),new ZXb.kq(19,33.973636381),new ZXb.kq(20,34.973314249),new ZXb.kq(21,35.978259824),new ZXb.kq(22,36.979608338),new ZXb.kq(23,37.98447),new ZXb.kq(24,38.98642),new ZXb.kq(25,39.99105),new ZXb.kq(26,40.9948),new ZXb.kq(27,42.00009),new ZXb.kq(28,43.00331),new ZXb.kq(29,44.00988),new ZXb.kq(30,45.01514),new ZXb.kq(31,46.02383)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(10,26.02788),new ZXb.kq(11,27.018795),new ZXb.kq(12,28.004372661),new ZXb.kq(13,28.996608805),new ZXb.kq(14,29.984902954),new ZXb.kq(15,30.979554421),new ZXb.kq(16,31.97207069),new ZXb.kq(17,32.971458497),new ZXb.kq(18,33.967866831),new ZXb.kq(19,34.96903214),new ZXb.kq(20,35.96708088),new ZXb.kq(21,36.971125716),new ZXb.kq(22,37.971163443),new ZXb.kq(23,38.975135275),new ZXb.kq(24,39.97547),new ZXb.kq(25,40.98003),new ZXb.kq(26,41.98149),new ZXb.kq(27,42.9866),new ZXb.kq(28,43.98832),new ZXb.kq(29,44.99482),new ZXb.kq(30,45.99957),new ZXb.kq(31,47.00762),new ZXb.kq(32,48.01299),new ZXb.kq(33,49.02201)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(11,28.02851),new ZXb.kq(12,29.01411),new ZXb.kq(13,30.00477),new ZXb.kq(14,30.992416014),new ZXb.kq(15,31.985688908),new ZXb.kq(16,32.977451798),new ZXb.kq(17,33.973761967),new ZXb.kq(18,34.968852707),new ZXb.kq(19,35.968306945),new ZXb.kq(20,36.9659026),new ZXb.kq(21,37.96801055),new ZXb.kq(22,38.968007677),new ZXb.kq(23,39.970415555),new ZXb.kq(24,40.970650212),new ZXb.kq(25,41.973174994),new ZXb.kq(26,42.974203385),new ZXb.kq(27,43.978538712),new ZXb.kq(28,44.9797),new ZXb.kq(29,45.98412),new ZXb.kq(30,46.98795),new ZXb.kq(31,47.99485),new ZXb.kq(32,48.99989),new ZXb.kq(33,50.00773),new ZXb.kq(34,51.01353)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(12,30.02156),new ZXb.kq(13,31.012126),new ZXb.kq(14,31.99766066),new ZXb.kq(15,32.989928719),new ZXb.kq(16,33.980270118),new ZXb.kq(17,34.975256726),new ZXb.kq(18,35.967546282),new ZXb.kq(19,36.966775912),new ZXb.kq(20,37.962732161),new ZXb.kq(21,38.964313413),new ZXb.kq(22,39.962383123),new ZXb.kq(23,40.964500828),new ZXb.kq(24,41.963046386),new ZXb.kq(25,42.965670701),new ZXb.kq(26,43.965365269),new ZXb.kq(27,44.968094979),new ZXb.kq(28,45.968093467),new ZXb.kq(29,46.972186238),new ZXb.kq(30,47.97507),new ZXb.kq(31,48.98218),new ZXb.kq(32,49.98594),new ZXb.kq(33,50.99324),new ZXb.kq(34,51.99817),new ZXb.kq(35,53.006227)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(13,32.02192),new ZXb.kq(14,33.00726),new ZXb.kq(15,33.99841),new ZXb.kq(16,34.988011615),new ZXb.kq(17,35.981293405),new ZXb.kq(18,36.973376915),new ZXb.kq(19,37.969080107),new ZXb.kq(20,38.963706861),new ZXb.kq(21,39.963998672),new ZXb.kq(22,40.961825972),new ZXb.kq(23,41.962403059),new ZXb.kq(24,42.960715746),new ZXb.kq(25,43.961556146),new ZXb.kq(26,44.960699658),new ZXb.kq(27,45.961976203),new ZXb.kq(28,46.961677807),new ZXb.kq(29,47.965512946),new ZXb.kq(30,48.967450084),new ZXb.kq(31,49.972782832),new ZXb.kq(32,50.97638),new ZXb.kq(33,51.98261),new ZXb.kq(34,52.98712),new ZXb.kq(35,53.99399),new ZXb.kq(36,54.999388)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(14,34.01412),new ZXb.kq(15,35.004765),new ZXb.kq(16,35.993087234),new ZXb.kq(17,36.985871505),new ZXb.kq(18,37.976318637),new ZXb.kq(19,38.970717729),new ZXb.kq(20,39.962591155),new ZXb.kq(21,40.962278349),new ZXb.kq(22,41.958618337),new ZXb.kq(23,42.958766833),new ZXb.kq(24,43.955481094),new ZXb.kq(25,44.956185938),new ZXb.kq(26,45.953692759),new ZXb.kq(27,46.954546459),new ZXb.kq(28,47.952533512),new ZXb.kq(29,48.955673302),new ZXb.kq(30,49.957518286),new ZXb.kq(31,50.961474238),new ZXb.kq(32,51.9651),new ZXb.kq(33,52.97005),new ZXb.kq(34,53.97468),new ZXb.kq(35,54.98055),new ZXb.kq(36,55.98579),new ZXb.kq(37,56.992356)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(15,36.01492),new ZXb.kq(16,37.00305),new ZXb.kq(17,37.9947),new ZXb.kq(18,38.984790009),new ZXb.kq(19,39.977964014),new ZXb.kq(20,40.969251316),new ZXb.kq(21,41.965516761),new ZXb.kq(22,42.96115098),new ZXb.kq(23,43.959403048),new ZXb.kq(24,44.955910243),new ZXb.kq(25,45.95517025),new ZXb.kq(26,46.952408027),new ZXb.kq(27,47.952234991),new ZXb.kq(28,48.950024065),new ZXb.kq(29,49.952187008),new ZXb.kq(30,50.9536027),new ZXb.kq(31,51.95665),new ZXb.kq(32,52.95817),new ZXb.kq(33,53.963),new ZXb.kq(34,54.9694),new ZXb.kq(35,55.97266),new ZXb.kq(36,56.97704),new ZXb.kq(37,57.98307),new ZXb.kq(38,58.988041)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(16,38.00977),new ZXb.kq(17,39.001323),new ZXb.kq(18,39.990498907),new ZXb.kq(19,40.983131),new ZXb.kq(20,41.973031622),new ZXb.kq(21,42.968523342),new ZXb.kq(22,43.959690235),new ZXb.kq(23,44.958124349),new ZXb.kq(24,45.952629491),new ZXb.kq(25,46.951763792),new ZXb.kq(26,47.947947053),new ZXb.kq(27,48.947870789),new ZXb.kq(28,49.944792069),new ZXb.kq(29,50.946616017),new ZXb.kq(30,51.946898175),new ZXb.kq(31,52.949731709),new ZXb.kq(32,53.95087),new ZXb.kq(33,54.95512),new ZXb.kq(34,55.95799),new ZXb.kq(35,56.9643),new ZXb.kq(36,57.96611),new ZXb.kq(37,58.97196),new ZXb.kq(38,59.97564),new ZXb.kq(39,60.982018)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(17,40.01109),new ZXb.kq(18,40.99974),new ZXb.kq(19,41.99123),new ZXb.kq(20,42.98065),new ZXb.kq(21,43.9744),new ZXb.kq(22,44.965782286),new ZXb.kq(23,45.960199491),new ZXb.kq(24,46.954906918),new ZXb.kq(25,47.95225448),new ZXb.kq(26,48.948516914),new ZXb.kq(27,49.947162792),new ZXb.kq(28,50.943963675),new ZXb.kq(29,51.944779658),new ZXb.kq(30,52.944342517),new ZXb.kq(31,53.946444381),new ZXb.kq(32,54.947238194),new ZXb.kq(33,55.95036),new ZXb.kq(34,56.95236),new ZXb.kq(35,57.95665),new ZXb.kq(36,58.9593),new ZXb.kq(37,59.9645),new ZXb.kq(38,60.96741),new ZXb.kq(39,61.97314),new ZXb.kq(40,62.97675)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(18,42.00643),new ZXb.kq(19,42.997707),new ZXb.kq(20,43.98547),new ZXb.kq(21,44.97916),new ZXb.kq(22,45.968361649),new ZXb.kq(23,46.962906512),new ZXb.kq(24,47.954035861),new ZXb.kq(25,48.951341135),new ZXb.kq(26,49.946049607),new ZXb.kq(27,50.944771767),new ZXb.kq(28,51.940511904),new ZXb.kq(29,52.940653781),new ZXb.kq(30,53.938884921),new ZXb.kq(31,54.940844164),new ZXb.kq(32,55.940645238),new ZXb.kq(33,56.9437538),new ZXb.kq(34,57.94425),new ZXb.kq(35,58.94863),new ZXb.kq(36,59.94973),new ZXb.kq(37,60.95409),new ZXb.kq(38,61.9558),new ZXb.kq(39,62.96186),new ZXb.kq(40,63.9642),new ZXb.kq(41,64.97037)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(19,44.00687),new ZXb.kq(20,44.99451),new ZXb.kq(21,45.98672),new ZXb.kq(22,46.9761),new ZXb.kq(23,47.96887),new ZXb.kq(24,48.959623415),new ZXb.kq(25,49.95424396),new ZXb.kq(26,50.948215487),new ZXb.kq(27,51.945570079),new ZXb.kq(28,52.941294702),new ZXb.kq(29,53.940363247),new ZXb.kq(30,54.938049636),new ZXb.kq(31,55.938909366),new ZXb.kq(32,56.938287458),new ZXb.kq(33,57.939986451),new ZXb.kq(34,58.940447166),new ZXb.kq(35,59.943193998),new ZXb.kq(36,60.94446),new ZXb.kq(37,61.94797),new ZXb.kq(38,62.94981),new ZXb.kq(39,63.95373),new ZXb.kq(40,64.9561),new ZXb.kq(41,65.96082),new ZXb.kq(42,66.96382)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(19,45.01456),new ZXb.kq(20,46.00081),new ZXb.kq(21,46.99289),new ZXb.kq(22,47.98056),new ZXb.kq(23,48.97361),new ZXb.kq(24,49.962993316),new ZXb.kq(25,50.956824936),new ZXb.kq(26,51.948116526),new ZXb.kq(27,52.945312282),new ZXb.kq(28,53.939614836),new ZXb.kq(29,54.938298029),new ZXb.kq(30,55.934942133),new ZXb.kq(31,56.935398707),new ZXb.kq(32,57.933280458),new ZXb.kq(33,58.934880493),new ZXb.kq(34,59.934076943),new ZXb.kq(35,60.936749461),new ZXb.kq(36,61.936770495),new ZXb.kq(37,62.940118442),new ZXb.kq(38,63.94087),new ZXb.kq(39,64.94494),new ZXb.kq(40,65.94598),new ZXb.kq(41,66.95),new ZXb.kq(42,67.95251),new ZXb.kq(43,68.9577)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(21,48.00176),new ZXb.kq(22,48.98972),new ZXb.kq(23,49.98154),new ZXb.kq(24,50.97072),new ZXb.kq(25,51.96359),new ZXb.kq(26,52.954224985),new ZXb.kq(27,53.948464147),new ZXb.kq(28,54.942003149),new ZXb.kq(29,55.939843937),new ZXb.kq(30,56.936296235),new ZXb.kq(31,57.935757571),new ZXb.kq(32,58.933200194),new ZXb.kq(33,59.933822196),new ZXb.kq(34,60.932479381),new ZXb.kq(35,61.934054212),new ZXb.kq(36,62.933615218),new ZXb.kq(37,63.935813523),new ZXb.kq(38,64.936484581),new ZXb.kq(39,65.939825412),new ZXb.kq(40,66.94061),new ZXb.kq(41,67.94436),new ZXb.kq(42,68.9452),new ZXb.kq(43,69.94981),new ZXb.kq(44,70.95173),new ZXb.kq(45,71.95641)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(22,49.99593),new ZXb.kq(23,50.98772),new ZXb.kq(24,51.97568),new ZXb.kq(25,52.96846),new ZXb.kq(26,53.957910508),new ZXb.kq(27,54.951336329),new ZXb.kq(28,55.942136339),new ZXb.kq(29,56.939800489),new ZXb.kq(30,57.935347922),new ZXb.kq(31,58.934351553),new ZXb.kq(32,59.930790633),new ZXb.kq(33,60.931060442),new ZXb.kq(34,61.928348763),new ZXb.kq(35,62.929672948),new ZXb.kq(36,63.927969574),new ZXb.kq(37,64.930088013),new ZXb.kq(38,65.929115232),new ZXb.kq(39,66.931569638),new ZXb.kq(40,67.931844932),new ZXb.kq(41,68.935181837),new ZXb.kq(42,69.93614),new ZXb.kq(43,70.94),new ZXb.kq(44,71.9413),new ZXb.kq(45,72.94608),new ZXb.kq(46,73.94791),new ZXb.kq(47,74.95297),new ZXb.kq(48,75.95533),new ZXb.kq(49,76.96083),new ZXb.kq(50,77.9638)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(23,51.99718),new ZXb.kq(24,52.98555),new ZXb.kq(25,53.97671),new ZXb.kq(26,54.96605),new ZXb.kq(27,55.95856),new ZXb.kq(28,56.949215695),new ZXb.kq(29,57.944540734),new ZXb.kq(30,58.939504114),new ZXb.kq(31,59.937368123),new ZXb.kq(32,60.933462181),new ZXb.kq(33,61.932587299),new ZXb.kq(34,62.929601079),new ZXb.kq(35,63.929767865),new ZXb.kq(36,64.927793707),new ZXb.kq(37,65.928873041),new ZXb.kq(38,66.927750294),new ZXb.kq(39,67.929637875),new ZXb.kq(40,68.929425281),new ZXb.kq(41,69.932409287),new ZXb.kq(42,70.932619818),new ZXb.kq(43,71.93552),new ZXb.kq(44,72.93649),new ZXb.kq(45,73.9402),new ZXb.kq(46,74.9417),new ZXb.kq(47,75.94599),new ZXb.kq(48,76.94795),new ZXb.kq(49,77.95281),new ZXb.kq(50,78.95528),new ZXb.kq(51,79.96189)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(24,53.99295),new ZXb.kq(25,54.98398),new ZXb.kq(26,55.97238),new ZXb.kq(27,56.96491),new ZXb.kq(28,57.954596465),new ZXb.kq(29,58.949267074),new ZXb.kq(30,59.941832031),new ZXb.kq(31,60.939513907),new ZXb.kq(32,61.934334132),new ZXb.kq(33,62.933215563),new ZXb.kq(34,63.929146578),new ZXb.kq(35,64.929245079),new ZXb.kq(36,65.926036763),new ZXb.kq(37,66.927130859),new ZXb.kq(38,67.924847566),new ZXb.kq(39,68.926553538),new ZXb.kq(40,69.92532487),new ZXb.kq(41,70.927727195),new ZXb.kq(42,71.926861122),new ZXb.kq(43,72.929779469),new ZXb.kq(44,73.929458261),new ZXb.kq(45,74.932937379),new ZXb.kq(46,75.933394207),new ZXb.kq(47,76.937085857),new ZXb.kq(48,77.938569576),new ZXb.kq(49,78.942095175),new ZXb.kq(50,79.944414722),new ZXb.kq(51,80.95048),new ZXb.kq(52,81.95484)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(25,55.99491),new ZXb.kq(26,56.98293),new ZXb.kq(27,57.97425),new ZXb.kq(28,58.96337),new ZXb.kq(29,59.95706),new ZXb.kq(30,60.94917),new ZXb.kq(31,61.944179608),new ZXb.kq(32,62.939141527),new ZXb.kq(33,63.936838307),new ZXb.kq(34,64.932739322),new ZXb.kq(35,65.931592355),new ZXb.kq(36,66.928204915),new ZXb.kq(37,67.927983497),new ZXb.kq(38,68.925580912),new ZXb.kq(39,69.926027741),new ZXb.kq(40,70.92470501),new ZXb.kq(41,71.92636935),new ZXb.kq(42,72.925169832),new ZXb.kq(43,73.926940999),new ZXb.kq(44,74.926500645),new ZXb.kq(45,75.928928262),new ZXb.kq(46,76.929281189),new ZXb.kq(47,77.93165595),new ZXb.kq(48,78.932916371),new ZXb.kq(49,79.936588154),new ZXb.kq(50,80.937752955),new ZXb.kq(51,81.94316),new ZXb.kq(52,82.94687),new ZXb.kq(53,83.95234)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(26,57.99101),new ZXb.kq(27,58.98175),new ZXb.kq(28,59.97019),new ZXb.kq(29,60.96379),new ZXb.kq(30,61.95465),new ZXb.kq(31,62.94964),new ZXb.kq(32,63.941572638),new ZXb.kq(33,64.939440762),new ZXb.kq(34,65.933846798),new ZXb.kq(35,66.932738415),new ZXb.kq(36,67.928097266),new ZXb.kq(37,68.927972002),new ZXb.kq(38,69.924250365),new ZXb.kq(39,70.924953991),new ZXb.kq(40,71.922076184),new ZXb.kq(41,72.923459361),new ZXb.kq(42,73.921178213),new ZXb.kq(43,74.922859494),new ZXb.kq(44,75.921402716),new ZXb.kq(45,76.923548462),new ZXb.kq(46,77.922852886),new ZXb.kq(47,78.92540156),new ZXb.kq(48,79.925444764),new ZXb.kq(49,80.928821065),new ZXb.kq(50,81.929550326),new ZXb.kq(51,82.93451),new ZXb.kq(52,83.93731),new ZXb.kq(53,84.94269),new ZXb.kq(54,85.94627)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(27,59.99313),new ZXb.kq(28,60.98062),new ZXb.kq(29,61.9732),new ZXb.kq(30,62.96369),new ZXb.kq(31,63.957572),new ZXb.kq(32,64.949484),new ZXb.kq(33,65.944099147),new ZXb.kq(34,66.939190417),new ZXb.kq(35,67.936792976),new ZXb.kq(36,68.932280154),new ZXb.kq(37,69.930927811),new ZXb.kq(38,70.927114724),new ZXb.kq(39,71.926752647),new ZXb.kq(40,72.923825288),new ZXb.kq(41,73.923929076),new ZXb.kq(42,74.921596417),new ZXb.kq(43,75.922393933),new ZXb.kq(44,76.920647703),new ZXb.kq(45,77.921828577),new ZXb.kq(46,78.920948498),new ZXb.kq(47,79.922578162),new ZXb.kq(48,80.922132884),new ZXb.kq(49,81.924504668),new ZXb.kq(50,82.924980625),new ZXb.kq(51,83.92906),new ZXb.kq(52,84.93181),new ZXb.kq(53,85.93623),new ZXb.kq(54,86.93958),new ZXb.kq(55,87.94456),new ZXb.kq(56,88.94923)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(31,64.96466),new ZXb.kq(32,65.95521),new ZXb.kq(33,66.95009),new ZXb.kq(34,67.94187),new ZXb.kq(35,68.939562155),new ZXb.kq(36,69.933504),new ZXb.kq(37,70.931868378),new ZXb.kq(38,71.927112313),new ZXb.kq(39,72.9267668),new ZXb.kq(40,73.922476561),new ZXb.kq(41,74.922523571),new ZXb.kq(42,75.919214107),new ZXb.kq(43,76.91991461),new ZXb.kq(44,77.917309522),new ZXb.kq(45,78.918499802),new ZXb.kq(46,79.916521828),new ZXb.kq(47,80.917992931),new ZXb.kq(48,81.9167),new ZXb.kq(49,82.919119072),new ZXb.kq(50,83.918464523),new ZXb.kq(51,84.922244678),new ZXb.kq(52,85.924271165),new ZXb.kq(53,86.928520749),new ZXb.kq(54,87.931423982),new ZXb.kq(55,88.93602),new ZXb.kq(56,89.93942),new ZXb.kq(57,90.94537),new ZXb.kq(58,91.94933)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(32,66.96479),new ZXb.kq(33,67.958248),new ZXb.kq(34,68.950178),new ZXb.kq(35,69.944208),new ZXb.kq(36,70.939246),new ZXb.kq(37,71.936496876),new ZXb.kq(38,72.931794889),new ZXb.kq(39,73.929891152),new ZXb.kq(40,74.92577641),new ZXb.kq(41,75.924541974),new ZXb.kq(42,76.921380123),new ZXb.kq(43,77.92114613),new ZXb.kq(44,78.918337647),new ZXb.kq(45,79.918529952),new ZXb.kq(46,80.91629106),new ZXb.kq(47,81.916804666),new ZXb.kq(48,82.915180219),new ZXb.kq(49,83.916503685),new ZXb.kq(50,84.915608027),new ZXb.kq(51,85.918797162),new ZXb.kq(52,86.920710713),new ZXb.kq(53,87.924065908),new ZXb.kq(54,88.92638726),new ZXb.kq(55,89.930634988),new ZXb.kq(56,90.9339653),new ZXb.kq(57,91.939255258),new ZXb.kq(58,92.9431),new ZXb.kq(59,93.94868)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(33,68.96532),new ZXb.kq(34,69.95601),new ZXb.kq(35,70.95051),new ZXb.kq(36,71.94190754),new ZXb.kq(37,72.938931115),new ZXb.kq(38,73.933258225),new ZXb.kq(39,74.931033794),new ZXb.kq(40,75.925948304),new ZXb.kq(41,76.92466788),new ZXb.kq(42,77.920386271),new ZXb.kq(43,78.920082992),new ZXb.kq(44,79.91637804),new ZXb.kq(45,80.916592419),new ZXb.kq(46,81.913484601),new ZXb.kq(47,82.914135952),new ZXb.kq(48,83.911506627),new ZXb.kq(49,84.912526954),new ZXb.kq(50,85.910610313),new ZXb.kq(51,86.913354251),new ZXb.kq(52,87.914446951),new ZXb.kq(53,88.917632505),new ZXb.kq(54,89.919523803),new ZXb.kq(55,90.923442418),new ZXb.kq(56,91.926152752),new ZXb.kq(57,92.931265246),new ZXb.kq(58,93.934362),new ZXb.kq(59,94.93984),new ZXb.kq(60,95.94307),new ZXb.kq(61,96.94856)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(34,70.96532),new ZXb.kq(35,71.95908),new ZXb.kq(36,72.950366),new ZXb.kq(37,73.944470376),new ZXb.kq(38,74.938569199),new ZXb.kq(39,75.935071448),new ZXb.kq(40,76.930406599),new ZXb.kq(41,77.928141485),new ZXb.kq(42,78.923996719),new ZXb.kq(43,79.922519322),new ZXb.kq(44,80.918994165),new ZXb.kq(45,81.918207691),new ZXb.kq(46,82.915111951),new ZXb.kq(47,83.914384676),new ZXb.kq(48,84.911789341),new ZXb.kq(49,85.91116708),new ZXb.kq(50,86.909183465),new ZXb.kq(51,87.911318556),new ZXb.kq(52,88.912279939),new ZXb.kq(53,89.914808941),new ZXb.kq(54,90.91653416),new ZXb.kq(55,91.919725442),new ZXb.kq(56,92.922032765),new ZXb.kq(57,93.926407326),new ZXb.kq(58,94.92931926),new ZXb.kq(59,95.934283962),new ZXb.kq(60,96.937342863),new ZXb.kq(61,97.941703557),new ZXb.kq(62,98.945420616),new ZXb.kq(63,99.94987),new ZXb.kq(64,100.953195994),new ZXb.kq(65,101.95921)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(35,72.96597),new ZXb.kq(36,73.95631),new ZXb.kq(37,74.94992),new ZXb.kq(38,75.94161),new ZXb.kq(39,76.937761511),new ZXb.kq(40,77.932179362),new ZXb.kq(41,78.929707076),new ZXb.kq(42,79.924524588),new ZXb.kq(43,80.923213095),new ZXb.kq(44,81.918401258),new ZXb.kq(45,82.917555029),new ZXb.kq(46,83.913424778),new ZXb.kq(47,84.912932689),new ZXb.kq(48,85.909262351),new ZXb.kq(49,86.908879316),new ZXb.kq(50,87.905614339),new ZXb.kq(51,88.907452906),new ZXb.kq(52,89.907737596),new ZXb.kq(53,90.910209845),new ZXb.kq(54,91.911029895),new ZXb.kq(55,92.91402241),new ZXb.kq(56,93.915359856),new ZXb.kq(57,94.919358213),new ZXb.kq(58,95.921680473),new ZXb.kq(59,96.926148757),new ZXb.kq(60,97.928471177),new ZXb.kq(61,98.933315038),new ZXb.kq(62,99.935351729),new ZXb.kq(63,100.940517434),new ZXb.kq(64,101.943018795),new ZXb.kq(65,102.94895),new ZXb.kq(66,103.95233)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(38,76.94962),new ZXb.kq(39,77.9435),new ZXb.kq(40,78.937350712),new ZXb.kq(41,79.931982402),new ZXb.kq(42,80.929128719),new ZXb.kq(43,81.926792071),new ZXb.kq(44,82.922352572),new ZXb.kq(45,83.920387768),new ZXb.kq(46,84.916427076),new ZXb.kq(47,85.914887724),new ZXb.kq(48,86.910877833),new ZXb.kq(49,87.909503361),new ZXb.kq(50,88.905847902),new ZXb.kq(51,89.907151443),new ZXb.kq(52,90.907303415),new ZXb.kq(53,91.908946832),new ZXb.kq(54,92.909581582),new ZXb.kq(55,93.911594008),new ZXb.kq(56,94.912823709),new ZXb.kq(57,95.915897787),new ZXb.kq(58,96.918131017),new ZXb.kq(59,97.922219525),new ZXb.kq(60,98.924634736),new ZXb.kq(61,99.927756402),new ZXb.kq(62,100.930313395),new ZXb.kq(63,101.933555501),new ZXb.kq(64,102.93694),new ZXb.kq(65,103.94145),new ZXb.kq(66,104.94509),new ZXb.kq(67,105.95022)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(39,78.94916),new ZXb.kq(40,79.94055),new ZXb.kq(41,80.936815296),new ZXb.kq(42,81.931086249),new ZXb.kq(43,82.92865213),new ZXb.kq(44,83.92325),new ZXb.kq(45,84.92146522),new ZXb.kq(46,85.916472851),new ZXb.kq(47,86.914816578),new ZXb.kq(48,87.910226179),new ZXb.kq(49,88.908888916),new ZXb.kq(50,89.904703679),new ZXb.kq(51,90.905644968),new ZXb.kq(52,91.905040106),new ZXb.kq(53,92.906475627),new ZXb.kq(54,93.906315765),new ZXb.kq(55,94.908042739),new ZXb.kq(56,95.908275675),new ZXb.kq(57,96.910950716),new ZXb.kq(58,97.912746366),new ZXb.kq(59,98.916511084),new ZXb.kq(60,99.917761704),new ZXb.kq(61,100.921139958),new ZXb.kq(62,101.922981089),new ZXb.kq(63,102.926597062),new ZXb.kq(64,103.92878),new ZXb.kq(65,104.93305),new ZXb.kq(66,105.93591),new ZXb.kq(67,106.94086),new ZXb.kq(68,107.94428)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(40,80.94905),new ZXb.kq(41,81.94313),new ZXb.kq(42,82.936703713),new ZXb.kq(43,83.93357),new ZXb.kq(44,84.927906486),new ZXb.kq(45,85.925037588),new ZXb.kq(46,86.920361435),new ZXb.kq(47,87.91833144),new ZXb.kq(48,88.913495503),new ZXb.kq(49,89.911264109),new ZXb.kq(50,90.906990538),new ZXb.kq(51,91.907193214),new ZXb.kq(52,92.906377543),new ZXb.kq(53,93.907283457),new ZXb.kq(54,94.906835178),new ZXb.kq(55,95.908100076),new ZXb.kq(56,96.908097144),new ZXb.kq(57,97.91033069),new ZXb.kq(58,98.911617864),new ZXb.kq(59,99.914181434),new ZXb.kq(60,100.915251567),new ZXb.kq(61,101.918037417),new ZXb.kq(62,102.919141297),new ZXb.kq(63,103.922459464),new ZXb.kq(64,104.923934023),new ZXb.kq(65,105.92819),new ZXb.kq(66,106.93031),new ZXb.kq(67,107.93501),new ZXb.kq(68,108.93763),new ZXb.kq(69,109.94268)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(41,82.94874),new ZXb.kq(42,83.94009),new ZXb.kq(43,84.93659),new ZXb.kq(44,85.930695167),new ZXb.kq(45,86.92732683),new ZXb.kq(46,87.921952728),new ZXb.kq(47,88.919480562),new ZXb.kq(48,89.913936161),new ZXb.kq(49,90.911750754),new ZXb.kq(50,91.90681048),new ZXb.kq(51,92.906812213),new ZXb.kq(52,93.905087578),new ZXb.kq(53,94.905841487),new ZXb.kq(54,95.904678904),new ZXb.kq(55,96.906021033),new ZXb.kq(56,97.905407846),new ZXb.kq(57,98.907711598),new ZXb.kq(58,99.907477149),new ZXb.kq(59,100.910346543),new ZXb.kq(60,101.910297162),new ZXb.kq(61,102.913204596),new ZXb.kq(62,103.913758387),new ZXb.kq(63,104.916972087),new ZXb.kq(64,105.918134284),new ZXb.kq(65,106.921694724),new ZXb.kq(66,107.923973837),new ZXb.kq(67,108.92781),new ZXb.kq(68,109.92973),new ZXb.kq(69,110.93451),new ZXb.kq(70,111.93684),new ZXb.kq(71,112.94203)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(42,84.94894),new ZXb.kq(43,85.94288),new ZXb.kq(44,86.93653),new ZXb.kq(45,87.93283),new ZXb.kq(46,88.92754288),new ZXb.kq(47,89.92355583),new ZXb.kq(48,90.9184282),new ZXb.kq(49,91.915259655),new ZXb.kq(50,92.910248473),new ZXb.kq(51,93.909656309),new ZXb.kq(52,94.907656454),new ZXb.kq(53,95.907870803),new ZXb.kq(54,96.906364843),new ZXb.kq(55,97.907215692),new ZXb.kq(56,98.906254554),new ZXb.kq(57,99.907657594),new ZXb.kq(58,100.90731438),new ZXb.kq(59,101.909212938),new ZXb.kq(60,102.909178805),new ZXb.kq(61,103.911444898),new ZXb.kq(62,104.911658043),new ZXb.kq(63,105.914355408),new ZXb.kq(64,106.915081691),new ZXb.kq(65,107.918479973),new ZXb.kq(66,108.919980998),new ZXb.kq(67,109.92339),new ZXb.kq(68,110.92505),new ZXb.kq(69,111.92924),new ZXb.kq(70,112.93133),new ZXb.kq(71,113.93588),new ZXb.kq(72,114.93828)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(43,86.94918),new ZXb.kq(44,87.94042),new ZXb.kq(45,88.93611),new ZXb.kq(46,89.92978),new ZXb.kq(47,90.926377434),new ZXb.kq(48,91.92012),new ZXb.kq(49,92.917051523),new ZXb.kq(50,93.911359569),new ZXb.kq(51,94.910412729),new ZXb.kq(52,95.907597681),new ZXb.kq(53,96.907554546),new ZXb.kq(54,97.905287111),new ZXb.kq(55,98.905939307),new ZXb.kq(56,99.904219664),new ZXb.kq(57,100.905582219),new ZXb.kq(58,101.904349503),new ZXb.kq(59,102.906323677),new ZXb.kq(60,103.905430145),new ZXb.kq(61,104.907750341),new ZXb.kq(62,105.907326913),new ZXb.kq(63,106.909907207),new ZXb.kq(64,107.910192211),new ZXb.kq(65,108.913201565),new ZXb.kq(66,109.913966185),new ZXb.kq(67,110.91756),new ZXb.kq(68,111.918821673),new ZXb.kq(69,112.92254),new ZXb.kq(70,113.923891981),new ZXb.kq(71,114.92831),new ZXb.kq(72,115.93016),new ZXb.kq(73,116.93479),new ZXb.kq(74,117.93703)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(44,88.94938),new ZXb.kq(45,89.94287),new ZXb.kq(46,90.93655),new ZXb.kq(47,91.93198),new ZXb.kq(48,92.92574),new ZXb.kq(49,93.921698),new ZXb.kq(50,94.915898541),new ZXb.kq(51,95.914518212),new ZXb.kq(52,96.911336643),new ZXb.kq(53,97.910716431),new ZXb.kq(54,98.908132101),new ZXb.kq(55,99.90811663),new ZXb.kq(56,100.906163526),new ZXb.kq(57,101.906842845),new ZXb.kq(58,102.905504182),new ZXb.kq(59,103.906655315),new ZXb.kq(60,104.905692444),new ZXb.kq(61,105.907284615),new ZXb.kq(62,106.90675054),new ZXb.kq(63,107.908730768),new ZXb.kq(64,108.908735621),new ZXb.kq(65,109.910949525),new ZXb.kq(66,110.91166),new ZXb.kq(67,111.913969253),new ZXb.kq(68,112.91542),new ZXb.kq(69,113.91734336),new ZXb.kq(70,114.920124676),new ZXb.kq(71,115.922746643),new ZXb.kq(72,116.92535),new ZXb.kq(73,117.92943),new ZXb.kq(74,118.93136),new ZXb.kq(75,119.93578),new ZXb.kq(76,120.93808)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(45,90.94948),new ZXb.kq(46,91.94042),new ZXb.kq(47,92.93591),new ZXb.kq(48,93.92877),new ZXb.kq(49,94.92469),new ZXb.kq(50,95.91822194),new ZXb.kq(51,96.916478921),new ZXb.kq(52,97.912720751),new ZXb.kq(53,98.911767757),new ZXb.kq(54,99.908504596),new ZXb.kq(55,100.908289144),new ZXb.kq(56,101.905607716),new ZXb.kq(57,102.906087204),new ZXb.kq(58,103.904034912),new ZXb.kq(59,104.905084046),new ZXb.kq(60,105.903483087),new ZXb.kq(61,106.905128453),new ZXb.kq(62,107.903894451),new ZXb.kq(63,108.905953535),new ZXb.kq(64,109.905152385),new ZXb.kq(65,110.907643952),new ZXb.kq(66,111.907313277),new ZXb.kq(67,112.910151346),new ZXb.kq(68,113.910365322),new ZXb.kq(69,114.91368341),new ZXb.kq(70,115.914158288),new ZXb.kq(71,116.91784),new ZXb.kq(72,117.918983915),new ZXb.kq(73,118.92268),new ZXb.kq(74,119.92403),new ZXb.kq(75,120.92818),new ZXb.kq(76,121.9298),new ZXb.kq(77,122.93426)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(47,93.94278),new ZXb.kq(48,94.93548),new ZXb.kq(49,95.93068),new ZXb.kq(50,96.924),new ZXb.kq(51,97.921759995),new ZXb.kq(52,98.917597103),new ZXb.kq(53,99.916069387),new ZXb.kq(54,100.912802135),new ZXb.kq(55,101.911999996),new ZXb.kq(56,102.908972453),new ZXb.kq(57,103.908628228),new ZXb.kq(58,104.906528234),new ZXb.kq(59,105.906666431),new ZXb.kq(60,106.90509302),new ZXb.kq(61,107.905953705),new ZXb.kq(62,108.904755514),new ZXb.kq(63,109.90611046),new ZXb.kq(64,110.905294679),new ZXb.kq(65,111.907004132),new ZXb.kq(66,112.906565708),new ZXb.kq(67,113.908807907),new ZXb.kq(68,114.908762282),new ZXb.kq(69,115.911359558),new ZXb.kq(70,116.911684187),new ZXb.kq(71,117.914582383),new ZXb.kq(72,118.915666045),new ZXb.kq(73,119.918788609),new ZXb.kq(74,120.919851074),new ZXb.kq(75,121.92332),new ZXb.kq(76,122.9249),new ZXb.kq(77,123.92853),new ZXb.kq(78,124.93054),new ZXb.kq(79,125.9345),new ZXb.kq(80,126.93688)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(48,95.93977),new ZXb.kq(49,96.93494),new ZXb.kq(50,97.927579),new ZXb.kq(51,98.92501),new ZXb.kq(52,99.920230232),new ZXb.kq(53,100.918681442),new ZXb.kq(54,101.914777255),new ZXb.kq(55,102.913418952),new ZXb.kq(56,103.909848091),new ZXb.kq(57,104.909467818),new ZXb.kq(58,105.906458007),new ZXb.kq(59,106.906614232),new ZXb.kq(60,107.904183403),new ZXb.kq(61,108.904985569),new ZXb.kq(62,109.903005578),new ZXb.kq(63,110.904181628),new ZXb.kq(64,111.902757226),new ZXb.kq(65,112.904400947),new ZXb.kq(66,113.903358121),new ZXb.kq(67,114.905430553),new ZXb.kq(68,115.904755434),new ZXb.kq(69,116.907218242),new ZXb.kq(70,117.906914144),new ZXb.kq(71,118.909922582),new ZXb.kq(72,119.909851352),new ZXb.kq(73,120.91298039),new ZXb.kq(74,121.9135),new ZXb.kq(75,122.917003675),new ZXb.kq(76,123.917648302),new ZXb.kq(77,124.92124717),new ZXb.kq(78,125.922353996),new ZXb.kq(79,126.926434822),new ZXb.kq(80,127.927760617),new ZXb.kq(81,128.93226),new ZXb.kq(82,129.93398)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(49,97.94224),new ZXb.kq(50,98.93461),new ZXb.kq(51,99.931149033),new ZXb.kq(52,100.92656),new ZXb.kq(53,101.924707541),new ZXb.kq(54,102.919913896),new ZXb.kq(55,103.918338416),new ZXb.kq(56,104.914673434),new ZXb.kq(57,105.913461134),new ZXb.kq(58,106.910292195),new ZXb.kq(59,107.909719683),new ZXb.kq(60,108.907154078),new ZXb.kq(61,109.907168783),new ZXb.kq(62,110.905110677),new ZXb.kq(63,111.905533338),new ZXb.kq(64,112.904061223),new ZXb.kq(65,113.904916758),new ZXb.kq(66,114.903878328),new ZXb.kq(67,115.905259995),new ZXb.kq(68,116.904515731),new ZXb.kq(69,117.906354623),new ZXb.kq(70,118.905846334),new ZXb.kq(71,119.907961505),new ZXb.kq(72,120.907848847),new ZXb.kq(73,121.910277103),new ZXb.kq(74,122.910438951),new ZXb.kq(75,123.913175916),new ZXb.kq(76,124.913601387),new ZXb.kq(77,125.916464532),new ZXb.kq(78,126.917344048),new ZXb.kq(79,127.920170658),new ZXb.kq(80,128.921657958),new ZXb.kq(81,129.924854941),new ZXb.kq(82,130.926767408),new ZXb.kq(83,131.932919005),new ZXb.kq(84,132.93834),new ZXb.kq(85,133.94466)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(50,99.938954),new ZXb.kq(51,100.93606),new ZXb.kq(52,101.93049),new ZXb.kq(53,102.92813),new ZXb.kq(54,103.923185469),new ZXb.kq(55,104.921390409),new ZXb.kq(56,105.916880472),new ZXb.kq(57,106.915666702),new ZXb.kq(58,107.911965339),new ZXb.kq(59,108.911286879),new ZXb.kq(60,109.907852688),new ZXb.kq(61,110.907735404),new ZXb.kq(62,111.90482081),new ZXb.kq(63,112.905173373),new ZXb.kq(64,113.902781816),new ZXb.kq(65,114.903345973),new ZXb.kq(66,115.901744149),new ZXb.kq(67,116.902953765),new ZXb.kq(68,117.901606328),new ZXb.kq(69,118.90330888),new ZXb.kq(70,119.902196571),new ZXb.kq(71,120.904236867),new ZXb.kq(72,121.903440138),new ZXb.kq(73,122.905721901),new ZXb.kq(74,123.90527463),new ZXb.kq(75,124.907784924),new ZXb.kq(76,125.907653953),new ZXb.kq(77,126.91035098),new ZXb.kq(78,127.910534953),new ZXb.kq(79,128.913439976),new ZXb.kq(80,129.913852185),new ZXb.kq(81,130.916919144),new ZXb.kq(82,131.917744455),new ZXb.kq(83,132.923814085),new ZXb.kq(84,133.928463576),new ZXb.kq(85,134.93473),new ZXb.kq(86,135.93934),new ZXb.kq(87,136.94579)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(52,102.94012),new ZXb.kq(53,103.936287),new ZXb.kq(54,104.931528593),new ZXb.kq(55,105.928183134),new ZXb.kq(56,106.92415),new ZXb.kq(57,107.92216),new ZXb.kq(58,108.918136092),new ZXb.kq(59,109.917533911),new ZXb.kq(60,110.912534147),new ZXb.kq(61,111.91239464),new ZXb.kq(62,112.909377941),new ZXb.kq(63,113.909095876),new ZXb.kq(64,114.906598812),new ZXb.kq(65,115.906797235),new ZXb.kq(66,116.90483959),new ZXb.kq(67,117.905531885),new ZXb.kq(68,118.90394646),new ZXb.kq(69,119.905074315),new ZXb.kq(70,120.903818044),new ZXb.kq(71,121.905175415),new ZXb.kq(72,122.904215696),new ZXb.kq(73,123.905937525),new ZXb.kq(74,124.905247804),new ZXb.kq(75,125.907248153),new ZXb.kq(76,126.906914564),new ZXb.kq(77,127.90916733),new ZXb.kq(78,128.909150092),new ZXb.kq(79,129.911546459),new ZXb.kq(80,130.911946487),new ZXb.kq(81,131.914413247),new ZXb.kq(82,132.915236466),new ZXb.kq(83,133.920551554),new ZXb.kq(84,134.925167962),new ZXb.kq(85,135.93066),new ZXb.kq(86,136.93531),new ZXb.kq(87,137.94096),new ZXb.kq(88,138.94571)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(54,105.937702),new ZXb.kq(55,106.935036),new ZXb.kq(56,107.929486838),new ZXb.kq(57,108.927456483),new ZXb.kq(58,109.922407164),new ZXb.kq(59,110.921120589),new ZXb.kq(60,111.917061617),new ZXb.kq(61,112.915452551),new ZXb.kq(62,113.912498025),new ZXb.kq(63,114.911578627),new ZXb.kq(64,115.908420253),new ZXb.kq(65,116.90863418),new ZXb.kq(66,117.905825187),new ZXb.kq(67,118.90640811),new ZXb.kq(68,119.904019891),new ZXb.kq(69,120.904929815),new ZXb.kq(70,121.903047064),new ZXb.kq(71,122.904272951),new ZXb.kq(72,123.902819466),new ZXb.kq(73,124.904424718),new ZXb.kq(74,125.903305543),new ZXb.kq(75,126.90521729),new ZXb.kq(76,127.904461383),new ZXb.kq(77,128.906595593),new ZXb.kq(78,129.906222753),new ZXb.kq(79,130.90852188),new ZXb.kq(80,131.908523782),new ZXb.kq(81,132.910939068),new ZXb.kq(82,133.911540546),new ZXb.kq(83,134.916450782),new ZXb.kq(84,135.920103155),new ZXb.kq(85,136.925324769),new ZXb.kq(86,137.92922),new ZXb.kq(87,138.93473),new ZXb.kq(88,139.9387),new ZXb.kq(89,140.94439),new ZXb.kq(90,141.9485)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(55,107.943291),new ZXb.kq(56,108.938191658),new ZXb.kq(57,109.934634181),new ZXb.kq(58,110.930276),new ZXb.kq(59,111.92797),new ZXb.kq(60,112.923644245),new ZXb.kq(61,113.92185),new ZXb.kq(62,114.918272),new ZXb.kq(63,115.916735014),new ZXb.kq(64,116.913647692),new ZXb.kq(65,117.91337523),new ZXb.kq(66,118.910180837),new ZXb.kq(67,119.910047843),new ZXb.kq(68,120.907366063),new ZXb.kq(69,121.907592451),new ZXb.kq(70,122.905597944),new ZXb.kq(71,123.906211423),new ZXb.kq(72,124.90462415),new ZXb.kq(73,125.905619387),new ZXb.kq(74,126.90446842),new ZXb.kq(75,127.905805254),new ZXb.kq(76,128.904987487),new ZXb.kq(77,129.906674018),new ZXb.kq(78,130.906124168),new ZXb.kq(79,131.907994525),new ZXb.kq(80,132.907806465),new ZXb.kq(81,133.909876552),new ZXb.kq(82,134.91005031),new ZXb.kq(83,135.914655105),new ZXb.kq(84,136.917872653),new ZXb.kq(85,137.922383666),new ZXb.kq(86,138.926093402),new ZXb.kq(87,139.93121),new ZXb.kq(88,140.93483),new ZXb.kq(89,141.94018),new ZXb.kq(90,142.94407),new ZXb.kq(91,143.94961)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(56,109.944476),new ZXb.kq(57,110.941632),new ZXb.kq(58,111.93566535),new ZXb.kq(59,112.933382836),new ZXb.kq(60,113.928145),new ZXb.kq(61,114.926979032),new ZXb.kq(62,115.921394197),new ZXb.kq(63,116.920564355),new ZXb.kq(64,117.91657092),new ZXb.kq(65,118.915554295),new ZXb.kq(66,119.91215199),new ZXb.kq(67,120.911386497),new ZXb.kq(68,121.908548396),new ZXb.kq(69,122.908470748),new ZXb.kq(70,123.905895774),new ZXb.kq(71,124.906398236),new ZXb.kq(72,125.904268868),new ZXb.kq(73,126.905179581),new ZXb.kq(74,127.903530436),new ZXb.kq(75,128.904779458),new ZXb.kq(76,129.903507903),new ZXb.kq(77,130.90508192),new ZXb.kq(78,131.904154457),new ZXb.kq(79,132.90590566),new ZXb.kq(80,133.905394504),new ZXb.kq(81,134.907207499),new ZXb.kq(82,135.907219526),new ZXb.kq(83,136.911562939),new ZXb.kq(84,137.913988549),new ZXb.kq(85,138.918786859),new ZXb.kq(86,139.921635665),new ZXb.kq(87,140.926646282),new ZXb.kq(88,141.929702981),new ZXb.kq(89,142.93489),new ZXb.kq(90,143.93823),new ZXb.kq(91,144.94367),new ZXb.kq(92,145.9473),new ZXb.kq(93,146.95301)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(57,111.950331),new ZXb.kq(58,112.944535512),new ZXb.kq(59,113.940841319),new ZXb.kq(60,114.935939),new ZXb.kq(61,115.932914152),new ZXb.kq(62,116.928639484),new ZXb.kq(63,117.926554883),new ZXb.kq(64,118.922370879),new ZXb.kq(65,119.920678219),new ZXb.kq(66,120.917183637),new ZXb.kq(67,121.916121946),new ZXb.kq(68,122.912990168),new ZXb.kq(69,123.912245731),new ZXb.kq(70,124.909724871),new ZXb.kq(71,125.909447953),new ZXb.kq(72,126.9074176),new ZXb.kq(73,127.907747919),new ZXb.kq(74,128.906063369),new ZXb.kq(75,129.906706163),new ZXb.kq(76,130.905460232),new ZXb.kq(77,131.906429799),new ZXb.kq(78,132.90544687),new ZXb.kq(79,133.906713419),new ZXb.kq(80,134.905971903),new ZXb.kq(81,135.907305741),new ZXb.kq(82,136.907083505),new ZXb.kq(83,137.911010537),new ZXb.kq(84,138.913357921),new ZXb.kq(85,139.917277075),new ZXb.kq(86,140.920043984),new ZXb.kq(87,141.924292317),new ZXb.kq(88,142.927330292),new ZXb.kq(89,143.932027373),new ZXb.kq(90,144.935388226),new ZXb.kq(91,145.940162028),new ZXb.kq(92,146.943864435),new ZXb.kq(93,147.948899539),new ZXb.kq(94,148.95272),new ZXb.kq(95,149.95797),new ZXb.kq(96,150.962)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(58,113.950941),new ZXb.kq(59,114.94771),new ZXb.kq(60,115.94168),new ZXb.kq(61,116.937700229),new ZXb.kq(62,117.93344),new ZXb.kq(63,118.931051927),new ZXb.kq(64,119.926045941),new ZXb.kq(65,120.924485908),new ZXb.kq(66,121.92026),new ZXb.kq(67,122.91885),new ZXb.kq(68,123.915088437),new ZXb.kq(69,124.914620234),new ZXb.kq(70,125.911244146),new ZXb.kq(71,126.911121328),new ZXb.kq(72,127.90830887),new ZXb.kq(73,128.908673749),new ZXb.kq(74,129.906310478),new ZXb.kq(75,130.906930798),new ZXb.kq(76,131.905056152),new ZXb.kq(77,132.906002368),new ZXb.kq(78,133.904503347),new ZXb.kq(79,134.905682749),new ZXb.kq(80,135.904570109),new ZXb.kq(81,136.905821414),new ZXb.kq(82,137.905241273),new ZXb.kq(83,138.908835384),new ZXb.kq(84,139.910599485),new ZXb.kq(85,140.914406439),new ZXb.kq(86,141.916448175),new ZXb.kq(87,142.920617184),new ZXb.kq(88,143.922940468),new ZXb.kq(89,144.926923807),new ZXb.kq(90,145.930106645),new ZXb.kq(91,146.933992519),new ZXb.kq(92,147.937682377),new ZXb.kq(93,148.94246),new ZXb.kq(94,149.94562),new ZXb.kq(95,150.9507),new ZXb.kq(96,151.95416),new ZXb.kq(97,152.95961)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(60,116.95001),new ZXb.kq(61,117.94657),new ZXb.kq(62,118.94099),new ZXb.kq(63,119.93807),new ZXb.kq(64,120.93301),new ZXb.kq(65,121.93071),new ZXb.kq(66,122.92624),new ZXb.kq(67,123.92453),new ZXb.kq(68,124.92067),new ZXb.kq(69,125.91937),new ZXb.kq(70,126.91616),new ZXb.kq(71,127.91544794),new ZXb.kq(72,128.912667334),new ZXb.kq(73,129.91232),new ZXb.kq(74,130.910108489),new ZXb.kq(75,131.910110399),new ZXb.kq(76,132.908396372),new ZXb.kq(77,133.908489607),new ZXb.kq(78,134.906971003),new ZXb.kq(79,135.907651181),new ZXb.kq(80,136.906465656),new ZXb.kq(81,137.907106826),new ZXb.kq(82,138.90634816),new ZXb.kq(83,139.909472552),new ZXb.kq(84,140.910957016),new ZXb.kq(85,141.914074489),new ZXb.kq(86,142.916058646),new ZXb.kq(87,143.919591666),new ZXb.kq(88,144.92163837),new ZXb.kq(89,145.925700146),new ZXb.kq(90,146.927819639),new ZXb.kq(91,147.932191197),new ZXb.kq(92,148.93437),new ZXb.kq(93,149.93857),new ZXb.kq(94,150.94156),new ZXb.kq(95,151.94611),new ZXb.kq(96,152.94945),new ZXb.kq(97,153.9544),new ZXb.kq(98,154.95813)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(61,118.95276),new ZXb.kq(62,119.94664),new ZXb.kq(63,120.94367),new ZXb.kq(64,121.93801),new ZXb.kq(65,122.93551),new ZXb.kq(66,123.93052),new ZXb.kq(67,124.92854),new ZXb.kq(68,125.9241),new ZXb.kq(69,126.92275),new ZXb.kq(70,127.91887),new ZXb.kq(71,128.918679183),new ZXb.kq(72,129.914339361),new ZXb.kq(73,130.914424137),new ZXb.kq(74,131.91149),new ZXb.kq(75,132.91155),new ZXb.kq(76,133.909026379),new ZXb.kq(77,134.909145555),new ZXb.kq(78,135.907143574),new ZXb.kq(79,136.907777634),new ZXb.kq(80,137.905985574),new ZXb.kq(81,138.906646605),new ZXb.kq(82,139.905434035),new ZXb.kq(83,140.908271103),new ZXb.kq(84,141.909239733),new ZXb.kq(85,142.912381158),new ZXb.kq(86,143.913642686),new ZXb.kq(87,144.917227871),new ZXb.kq(88,145.918689722),new ZXb.kq(89,146.922510962),new ZXb.kq(90,147.924394738),new ZXb.kq(91,148.928289207),new ZXb.kq(92,149.930226399),new ZXb.kq(93,150.93404),new ZXb.kq(94,151.93638),new ZXb.kq(95,152.94058),new ZXb.kq(96,153.94332),new ZXb.kq(97,154.94804),new ZXb.kq(98,155.95126),new ZXb.kq(99,156.95634)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(62,120.955364),new ZXb.kq(63,121.95165),new ZXb.kq(64,122.94596),new ZXb.kq(65,123.94296),new ZXb.kq(66,124.93783),new ZXb.kq(67,125.93531),new ZXb.kq(68,126.93083),new ZXb.kq(69,127.9288),new ZXb.kq(70,128.92486),new ZXb.kq(71,129.92338),new ZXb.kq(72,130.920060245),new ZXb.kq(73,131.91912),new ZXb.kq(74,132.9162),new ZXb.kq(75,133.915672),new ZXb.kq(76,134.91313914),new ZXb.kq(77,135.912646935),new ZXb.kq(78,136.910678351),new ZXb.kq(79,137.910748891),new ZXb.kq(80,138.908932181),new ZXb.kq(81,139.909071204),new ZXb.kq(82,140.907647726),new ZXb.kq(83,141.910039865),new ZXb.kq(84,142.910812233),new ZXb.kq(85,143.913300595),new ZXb.kq(86,144.914506897),new ZXb.kq(87,145.917588016),new ZXb.kq(88,146.918979001),new ZXb.kq(89,147.922183237),new ZXb.kq(90,148.923791056),new ZXb.kq(91,149.926995031),new ZXb.kq(92,150.928227869),new ZXb.kq(93,151.9316),new ZXb.kq(94,152.93365),new ZXb.kq(95,153.93739),new ZXb.kq(96,154.93999),new ZXb.kq(97,155.94412),new ZXb.kq(98,156.94717),new ZXb.kq(99,157.95178),new ZXb.kq(100,158.95523)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(66,125.94307),new ZXb.kq(67,126.9405),new ZXb.kq(68,127.93539),new ZXb.kq(69,128.932385),new ZXb.kq(70,129.92878),new ZXb.kq(71,130.927102697),new ZXb.kq(72,131.92312),new ZXb.kq(73,132.92221),new ZXb.kq(74,133.918645),new ZXb.kq(75,134.91824),new ZXb.kq(76,135.915020542),new ZXb.kq(77,136.91463973),new ZXb.kq(78,137.91291745),new ZXb.kq(79,138.91192415),new ZXb.kq(80,139.909309824),new ZXb.kq(81,140.9096048),new ZXb.kq(82,141.907718643),new ZXb.kq(83,142.909809626),new ZXb.kq(84,143.910082629),new ZXb.kq(85,144.912568847),new ZXb.kq(86,145.913112139),new ZXb.kq(87,146.916095794),new ZXb.kq(88,147.916888516),new ZXb.kq(89,148.92014419),new ZXb.kq(90,149.920886563),new ZXb.kq(91,150.923824739),new ZXb.kq(92,151.924682428),new ZXb.kq(93,152.927694534),new ZXb.kq(94,153.929483295),new ZXb.kq(95,154.932629551),new ZXb.kq(96,155.9352),new ZXb.kq(97,156.93927),new ZXb.kq(98,157.94187),new ZXb.kq(99,158.94639),new ZXb.kq(100,159.94939),new ZXb.kq(101,160.95433)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(67,127.94826),new ZXb.kq(68,128.94316),new ZXb.kq(69,129.94045),new ZXb.kq(70,130.9358),new ZXb.kq(71,131.93375),new ZXb.kq(72,132.92972),new ZXb.kq(73,133.92849),new ZXb.kq(74,134.924617),new ZXb.kq(75,135.923447865),new ZXb.kq(76,136.920713),new ZXb.kq(77,137.920432261),new ZXb.kq(78,138.916759814),new ZXb.kq(79,139.915801649),new ZXb.kq(80,140.913606636),new ZXb.kq(81,141.912950738),new ZXb.kq(82,142.910927571),new ZXb.kq(83,143.912585768),new ZXb.kq(84,144.912743879),new ZXb.kq(85,145.914692165),new ZXb.kq(86,146.915133898),new ZXb.kq(87,147.917467786),new ZXb.kq(88,148.918329195),new ZXb.kq(89,149.920979477),new ZXb.kq(90,150.921202693),new ZXb.kq(91,151.923490557),new ZXb.kq(92,152.924113189),new ZXb.kq(93,153.926547019),new ZXb.kq(94,154.928097047),new ZXb.kq(95,155.931060357),new ZXb.kq(96,156.9332),new ZXb.kq(97,157.93669),new ZXb.kq(98,158.93913),new ZXb.kq(99,159.94299),new ZXb.kq(100,160.94586),new ZXb.kq(101,161.95029),new ZXb.kq(102,162.95352)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(68,129.94863),new ZXb.kq(69,130.94589),new ZXb.kq(70,131.94082),new ZXb.kq(71,132.93873),new ZXb.kq(72,133.93402),new ZXb.kq(73,134.93235),new ZXb.kq(74,135.9283),new ZXb.kq(75,136.927046709),new ZXb.kq(76,137.92354),new ZXb.kq(77,138.922302),new ZXb.kq(78,139.918991),new ZXb.kq(79,140.918468512),new ZXb.kq(80,141.915193274),new ZXb.kq(81,142.914623555),new ZXb.kq(82,143.91199473),new ZXb.kq(83,144.913405611),new ZXb.kq(84,145.91303676),new ZXb.kq(85,146.914893275),new ZXb.kq(86,147.914817914),new ZXb.kq(87,148.917179521),new ZXb.kq(88,149.917271454),new ZXb.kq(89,150.919928351),new ZXb.kq(90,151.919728244),new ZXb.kq(91,152.922093907),new ZXb.kq(92,153.922205303),new ZXb.kq(93,154.92463594),new ZXb.kq(94,155.925526236),new ZXb.kq(95,156.928354506),new ZXb.kq(96,157.929987938),new ZXb.kq(97,158.9332),new ZXb.kq(98,159.93514),new ZXb.kq(99,160.93883),new ZXb.kq(100,161.94122),new ZXb.kq(101,162.94536),new ZXb.kq(102,163.94828),new ZXb.kq(103,164.95298)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(69,131.95416),new ZXb.kq(70,132.9489),new ZXb.kq(71,133.94632),new ZXb.kq(72,134.94172),new ZXb.kq(73,135.9395),new ZXb.kq(74,136.93521),new ZXb.kq(75,137.93345),new ZXb.kq(76,138.92882915),new ZXb.kq(77,139.928083921),new ZXb.kq(78,140.924885867),new ZXb.kq(79,141.923400033),new ZXb.kq(80,142.920286634),new ZXb.kq(81,143.918774116),new ZXb.kq(82,144.916261285),new ZXb.kq(83,145.917199714),new ZXb.kq(84,146.916741206),new ZXb.kq(85,147.918153775),new ZXb.kq(86,148.917925922),new ZXb.kq(87,149.919698294),new ZXb.kq(88,150.919846022),new ZXb.kq(89,151.921740399),new ZXb.kq(90,152.921226219),new ZXb.kq(91,153.922975386),new ZXb.kq(92,154.922889429),new ZXb.kq(93,155.924750855),new ZXb.kq(94,156.925419435),new ZXb.kq(95,157.927841923),new ZXb.kq(96,158.9290845),new ZXb.kq(97,159.931460406),new ZXb.kq(98,160.93368),new ZXb.kq(99,161.93704),new ZXb.kq(100,162.93921),new ZXb.kq(101,163.94299),new ZXb.kq(102,164.94572),new ZXb.kq(103,165.94997),new ZXb.kq(104,166.95305)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(72,135.94707),new ZXb.kq(73,136.94465),new ZXb.kq(74,137.93997),new ZXb.kq(75,138.93808),new ZXb.kq(76,139.933236934),new ZXb.kq(77,140.93221),new ZXb.kq(78,141.927908919),new ZXb.kq(79,142.926738636),new ZXb.kq(80,143.923390357),new ZXb.kq(81,144.921687498),new ZXb.kq(82,145.918305344),new ZXb.kq(83,146.919089446),new ZXb.kq(84,147.918109771),new ZXb.kq(85,148.919336427),new ZXb.kq(86,149.918655455),new ZXb.kq(87,150.920344273),new ZXb.kq(88,151.919787882),new ZXb.kq(89,152.921746283),new ZXb.kq(90,153.920862271),new ZXb.kq(91,154.922618801),new ZXb.kq(92,155.922119552),new ZXb.kq(93,156.923956686),new ZXb.kq(94,157.924100533),new ZXb.kq(95,158.926385075),new ZXb.kq(96,159.927050616),new ZXb.kq(97,160.929665688),new ZXb.kq(98,161.930981211),new ZXb.kq(99,162.93399),new ZXb.kq(100,163.93586),new ZXb.kq(101,164.93938),new ZXb.kq(102,165.9416),new ZXb.kq(103,166.94557),new ZXb.kq(104,167.94836),new ZXb.kq(105,168.95287)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(73,137.95287),new ZXb.kq(74,138.94803),new ZXb.kq(75,139.945367985),new ZXb.kq(76,140.94116),new ZXb.kq(77,141.939073781),new ZXb.kq(78,142.93475),new ZXb.kq(79,143.93253),new ZXb.kq(80,144.92888),new ZXb.kq(81,145.927180629),new ZXb.kq(82,146.924037176),new ZXb.kq(83,147.924298636),new ZXb.kq(84,148.92324163),new ZXb.kq(85,149.923654158),new ZXb.kq(86,150.923098169),new ZXb.kq(87,151.924071324),new ZXb.kq(88,152.923430858),new ZXb.kq(89,153.924686236),new ZXb.kq(90,154.923500411),new ZXb.kq(91,155.924743749),new ZXb.kq(92,156.924021155),new ZXb.kq(93,157.92541026),new ZXb.kq(94,158.925343135),new ZXb.kq(95,159.927164021),new ZXb.kq(96,160.927566289),new ZXb.kq(97,161.929484803),new ZXb.kq(98,162.930643942),new ZXb.kq(99,163.933347253),new ZXb.kq(100,164.93488),new ZXb.kq(101,165.93805),new ZXb.kq(102,166.94005),new ZXb.kq(103,167.94364),new ZXb.kq(104,168.94622),new ZXb.kq(105,169.95025),new ZXb.kq(106,170.9533)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(74,139.95379),new ZXb.kq(75,140.95119),new ZXb.kq(76,141.946695946),new ZXb.kq(77,142.94383),new ZXb.kq(78,143.93907),new ZXb.kq(79,144.936717),new ZXb.kq(80,145.932720118),new ZXb.kq(81,146.930878496),new ZXb.kq(82,147.927177882),new ZXb.kq(83,148.927333981),new ZXb.kq(84,149.925579728),new ZXb.kq(85,150.92617963),new ZXb.kq(86,151.924713874),new ZXb.kq(87,152.925760865),new ZXb.kq(88,153.924422046),new ZXb.kq(89,154.92574895),new ZXb.kq(90,155.924278273),new ZXb.kq(91,156.925461256),new ZXb.kq(92,157.924404637),new ZXb.kq(93,158.92573566),new ZXb.kq(94,159.925193718),new ZXb.kq(95,160.926929595),new ZXb.kq(96,161.926794731),new ZXb.kq(97,162.928727532),new ZXb.kq(98,163.929171165),new ZXb.kq(99,164.931699828),new ZXb.kq(100,165.932803241),new ZXb.kq(101,166.935649025),new ZXb.kq(102,167.93723),new ZXb.kq(103,168.940303648),new ZXb.kq(104,169.94267),new ZXb.kq(105,170.94648),new ZXb.kq(106,171.94911),new ZXb.kq(107,172.95344)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(75,141.95986),new ZXb.kq(76,142.95469),new ZXb.kq(77,143.95164),new ZXb.kq(78,144.94688),new ZXb.kq(79,145.9441),new ZXb.kq(80,146.93984),new ZXb.kq(81,147.937269),new ZXb.kq(82,148.933789944),new ZXb.kq(83,149.932760914),new ZXb.kq(84,150.931680791),new ZXb.kq(85,151.931740598),new ZXb.kq(86,152.930194506),new ZXb.kq(87,153.930596268),new ZXb.kq(88,154.929079084),new ZXb.kq(89,155.929001869),new ZXb.kq(90,156.928188059),new ZXb.kq(91,157.92894573),new ZXb.kq(92,158.927708537),new ZXb.kq(93,159.928725679),new ZXb.kq(94,160.927851662),new ZXb.kq(95,161.92909242),new ZXb.kq(96,162.928730286),new ZXb.kq(97,163.930230577),new ZXb.kq(98,164.930319169),new ZXb.kq(99,165.932281267),new ZXb.kq(100,166.933126195),new ZXb.kq(101,167.935496424),new ZXb.kq(102,168.936868306),new ZXb.kq(103,169.939614951),new ZXb.kq(104,170.941461227),new ZXb.kq(105,171.94482),new ZXb.kq(106,172.94729),new ZXb.kq(107,173.95115),new ZXb.kq(108,174.95405)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(76,143.96059),new ZXb.kq(77,144.95746),new ZXb.kq(78,145.95212),new ZXb.kq(79,146.94931),new ZXb.kq(80,147.94444),new ZXb.kq(81,148.942780527),new ZXb.kq(82,149.937171034),new ZXb.kq(83,150.93746),new ZXb.kq(84,151.935078452),new ZXb.kq(85,152.935093125),new ZXb.kq(86,153.932777294),new ZXb.kq(87,154.933204273),new ZXb.kq(88,155.931015001),new ZXb.kq(89,156.931945517),new ZXb.kq(90,157.929912),new ZXb.kq(91,158.930680718),new ZXb.kq(92,159.929078924),new ZXb.kq(93,160.930001348),new ZXb.kq(94,161.928774923),new ZXb.kq(95,162.930029273),new ZXb.kq(96,163.929196996),new ZXb.kq(97,164.9307228),new ZXb.kq(98,165.93028997),new ZXb.kq(99,166.932045448),new ZXb.kq(100,167.932367781),new ZXb.kq(101,168.934588082),new ZXb.kq(102,169.935460334),new ZXb.kq(103,170.938025885),new ZXb.kq(104,171.939352149),new ZXb.kq(105,172.9424),new ZXb.kq(106,173.94434),new ZXb.kq(107,174.94793),new ZXb.kq(108,175.95029),new ZXb.kq(109,176.95437)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(77,145.966495),new ZXb.kq(78,146.961081),new ZXb.kq(79,147.95755),new ZXb.kq(80,148.95265),new ZXb.kq(81,149.94967),new ZXb.kq(82,150.944842),new ZXb.kq(83,151.9443),new ZXb.kq(84,152.942027631),new ZXb.kq(85,153.940832325),new ZXb.kq(86,154.939191562),new ZXb.kq(87,155.939006895),new ZXb.kq(88,156.936756069),new ZXb.kq(89,157.936996),new ZXb.kq(90,158.934808966),new ZXb.kq(91,159.935090772),new ZXb.kq(92,160.933398042),new ZXb.kq(93,161.933970147),new ZXb.kq(94,162.932647648),new ZXb.kq(95,163.933450972),new ZXb.kq(96,164.932432463),new ZXb.kq(97,165.933553133),new ZXb.kq(98,166.932848844),new ZXb.kq(99,167.934170375),new ZXb.kq(100,168.934211117),new ZXb.kq(101,169.935797877),new ZXb.kq(102,170.936425817),new ZXb.kq(103,171.938396118),new ZXb.kq(104,172.939600336),new ZXb.kq(105,173.942164618),new ZXb.kq(106,174.943832897),new ZXb.kq(107,175.946991412),new ZXb.kq(108,176.94904),new ZXb.kq(109,177.95264),new ZXb.kq(110,178.95534)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(78,147.96676),new ZXb.kq(79,148.96348),new ZXb.kq(80,149.95799),new ZXb.kq(81,150.954657965),new ZXb.kq(82,151.950167),new ZXb.kq(83,152.94921),new ZXb.kq(84,153.945651145),new ZXb.kq(85,154.945792),new ZXb.kq(86,155.942847109),new ZXb.kq(87,156.94265865),new ZXb.kq(88,157.939857897),new ZXb.kq(89,158.940153735),new ZXb.kq(90,159.93756),new ZXb.kq(91,160.937357719),new ZXb.kq(92,161.93575),new ZXb.kq(93,162.936265492),new ZXb.kq(94,163.93452),new ZXb.kq(95,164.935397592),new ZXb.kq(96,165.933879623),new ZXb.kq(97,166.934946862),new ZXb.kq(98,167.933894465),new ZXb.kq(99,168.93518712),new ZXb.kq(100,169.934758652),new ZXb.kq(101,170.936322297),new ZXb.kq(102,171.936377696),new ZXb.kq(103,172.938206756),new ZXb.kq(104,173.938858101),new ZXb.kq(105,174.941272494),new ZXb.kq(106,175.942568409),new ZXb.kq(107,176.945257126),new ZXb.kq(108,177.946643396),new ZXb.kq(109,178.95017),new ZXb.kq(110,179.95233),new ZXb.kq(111,180.95615)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(79,149.972668),new ZXb.kq(80,150.967147),new ZXb.kq(81,151.96361),new ZXb.kq(82,152.95869),new ZXb.kq(83,153.9571),new ZXb.kq(84,154.953641324),new ZXb.kq(85,155.952907),new ZXb.kq(86,156.950101536),new ZXb.kq(87,157.948577981),new ZXb.kq(88,158.946615113),new ZXb.kq(89,159.945383),new ZXb.kq(90,160.943047504),new ZXb.kq(91,161.943222),new ZXb.kq(92,162.941203796),new ZXb.kq(93,163.941215),new ZXb.kq(94,164.939605886),new ZXb.kq(95,165.939762646),new ZXb.kq(96,166.938307056),new ZXb.kq(97,167.938698576),new ZXb.kq(98,168.937648757),new ZXb.kq(99,169.93847219),new ZXb.kq(100,170.937909903),new ZXb.kq(101,171.939082239),new ZXb.kq(102,172.938926901),new ZXb.kq(103,173.940333522),new ZXb.kq(104,174.940767904),new ZXb.kq(105,175.942682399),new ZXb.kq(106,176.943754987),new ZXb.kq(107,177.945951366),new ZXb.kq(108,178.947324216),new ZXb.kq(109,179.949879968),new ZXb.kq(110,180.95197),new ZXb.kq(111,181.95521),new ZXb.kq(112,182.95757),new ZXb.kq(113,183.96117)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(82,153.96425),new ZXb.kq(83,154.96276),new ZXb.kq(84,155.959247),new ZXb.kq(85,156.958127),new ZXb.kq(86,157.95405528),new ZXb.kq(87,158.954003),new ZXb.kq(88,159.950713588),new ZXb.kq(89,160.950330852),new ZXb.kq(90,161.947202977),new ZXb.kq(91,162.947057),new ZXb.kq(92,163.944422),new ZXb.kq(93,164.94454),new ZXb.kq(94,165.94225),new ZXb.kq(95,166.9426),new ZXb.kq(96,167.94063),new ZXb.kq(97,168.941158567),new ZXb.kq(98,169.93965),new ZXb.kq(99,170.94049),new ZXb.kq(100,171.93945798),new ZXb.kq(101,172.94065),new ZXb.kq(102,173.940040159),new ZXb.kq(103,174.941502991),new ZXb.kq(104,175.941401828),new ZXb.kq(105,176.943220013),new ZXb.kq(106,177.943697732),new ZXb.kq(107,178.945815073),new ZXb.kq(108,179.94654876),new ZXb.kq(109,180.949099124),new ZXb.kq(110,181.950552893),new ZXb.kq(111,182.953531012),new ZXb.kq(112,183.95544788),new ZXb.kq(113,184.95878),new ZXb.kq(114,185.96092)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(83,155.971689),new ZXb.kq(84,156.968145),new ZXb.kq(85,157.966368),new ZXb.kq(86,158.96232309),new ZXb.kq(87,159.961358),new ZXb.kq(88,160.958372992),new ZXb.kq(89,161.956556553),new ZXb.kq(90,162.95431665),new ZXb.kq(91,163.95357),new ZXb.kq(92,164.950817),new ZXb.kq(93,165.95047),new ZXb.kq(94,166.948639),new ZXb.kq(95,167.947787),new ZXb.kq(96,168.94592),new ZXb.kq(97,169.94609),new ZXb.kq(98,170.94446),new ZXb.kq(99,171.944739818),new ZXb.kq(100,172.94459),new ZXb.kq(101,173.944167937),new ZXb.kq(102,174.94365),new ZXb.kq(103,175.944740551),new ZXb.kq(104,176.944471766),new ZXb.kq(105,177.945750349),new ZXb.kq(106,178.945934113),new ZXb.kq(107,179.947465655),new ZXb.kq(108,180.947996346),new ZXb.kq(109,181.950152414),new ZXb.kq(110,182.951373188),new ZXb.kq(111,183.954009331),new ZXb.kq(112,184.955559086),new ZXb.kq(113,185.9585501),new ZXb.kq(114,186.96041),new ZXb.kq(115,187.96371)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(84,157.973939),new ZXb.kq(85,158.97228),new ZXb.kq(86,159.968369),new ZXb.kq(87,160.967089),new ZXb.kq(88,161.962750303),new ZXb.kq(89,162.962532),new ZXb.kq(90,163.95898381),new ZXb.kq(91,164.958335962),new ZXb.kq(92,165.955019896),new ZXb.kq(93,166.954672),new ZXb.kq(94,167.951863),new ZXb.kq(95,168.951759),new ZXb.kq(96,169.948473988),new ZXb.kq(97,170.94946),new ZXb.kq(98,171.948228837),new ZXb.kq(99,172.948884),new ZXb.kq(100,173.94616),new ZXb.kq(101,174.94677),new ZXb.kq(102,175.94559),new ZXb.kq(103,176.94662),new ZXb.kq(104,177.945848364),new ZXb.kq(105,178.947071733),new ZXb.kq(106,179.946705734),new ZXb.kq(107,180.948198054),new ZXb.kq(108,181.948205519),new ZXb.kq(109,182.950224458),new ZXb.kq(110,183.950932553),new ZXb.kq(111,184.953420586),new ZXb.kq(112,185.954362204),new ZXb.kq(113,186.957158365),new ZXb.kq(114,187.958486954),new ZXb.kq(115,188.96191222),new ZXb.kq(116,189.963179541)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(85,159.981485),new ZXb.kq(86,160.977661),new ZXb.kq(87,161.975707),new ZXb.kq(88,162.971375872),new ZXb.kq(89,163.970319),new ZXb.kq(90,164.967050268),new ZXb.kq(91,165.965211372),new ZXb.kq(92,166.962564),new ZXb.kq(93,167.961609),new ZXb.kq(94,168.95883),new ZXb.kq(95,169.958163),new ZXb.kq(96,170.955547),new ZXb.kq(97,171.955285),new ZXb.kq(98,172.953062),new ZXb.kq(99,173.952114),new ZXb.kq(100,174.951393),new ZXb.kq(101,175.95157),new ZXb.kq(102,176.95027),new ZXb.kq(103,177.950851081),new ZXb.kq(104,178.949981038),new ZXb.kq(105,179.95078768),new ZXb.kq(106,180.950064596),new ZXb.kq(107,181.951211444),new ZXb.kq(108,182.950821349),new ZXb.kq(109,183.952524289),new ZXb.kq(110,184.952955747),new ZXb.kq(111,185.954986529),new ZXb.kq(112,186.955750787),new ZXb.kq(113,187.958112287),new ZXb.kq(114,188.959228359),new ZXb.kq(115,189.961816139),new ZXb.kq(116,190.963123592),new ZXb.kq(117,191.96596)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(86,161.983819),new ZXb.kq(87,162.982048),new ZXb.kq(88,163.977927),new ZXb.kq(89,164.976475),new ZXb.kq(90,165.971934911),new ZXb.kq(91,166.971554),new ZXb.kq(92,167.967832911),new ZXb.kq(93,168.967076205),new ZXb.kq(94,169.963569716),new ZXb.kq(95,170.96304),new ZXb.kq(96,171.960078),new ZXb.kq(97,172.959791),new ZXb.kq(98,173.956307704),new ZXb.kq(99,174.95708),new ZXb.kq(100,175.953757941),new ZXb.kq(101,176.955045),new ZXb.kq(102,177.953348225),new ZXb.kq(103,178.953951),new ZXb.kq(104,179.952308241),new ZXb.kq(105,180.953274494),new ZXb.kq(106,181.952186222),new ZXb.kq(107,182.95311),new ZXb.kq(108,183.952490808),new ZXb.kq(109,184.954043023),new ZXb.kq(110,185.953838355),new ZXb.kq(111,186.955747928),new ZXb.kq(112,187.955835993),new ZXb.kq(113,188.958144866),new ZXb.kq(114,189.95844521),new ZXb.kq(115,190.960927951),new ZXb.kq(116,191.961479047),new ZXb.kq(117,192.964148083),new ZXb.kq(118,193.965179314),new ZXb.kq(119,194.968123889),new ZXb.kq(120,195.96962255)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(88,164.98758),new ZXb.kq(89,165.985506),new ZXb.kq(90,166.980951577),new ZXb.kq(91,167.979966),new ZXb.kq(92,168.976390868),new ZXb.kq(93,169.974441697),new ZXb.kq(94,170.971779),new ZXb.kq(95,171.970643),new ZXb.kq(96,172.967707),new ZXb.kq(97,173.966804),new ZXb.kq(98,174.964279),new ZXb.kq(99,175.963511),new ZXb.kq(100,176.96117),new ZXb.kq(101,177.960084944),new ZXb.kq(102,178.95915),new ZXb.kq(103,179.958555615),new ZXb.kq(104,180.957642156),new ZXb.kq(105,181.958127689),new ZXb.kq(106,182.956814),new ZXb.kq(107,183.957388318),new ZXb.kq(108,184.95659),new ZXb.kq(109,185.957951104),new ZXb.kq(110,186.95736083),new ZXb.kq(111,187.958851962),new ZXb.kq(112,188.958716473),new ZXb.kq(113,189.960592299),new ZXb.kq(114,190.960591191),new ZXb.kq(115,191.962602198),new ZXb.kq(116,192.9629237),new ZXb.kq(117,193.96507561),new ZXb.kq(118,194.9659768),new ZXb.kq(119,195.968379906),new ZXb.kq(120,196.969636496),new ZXb.kq(121,197.97228),new ZXb.kq(122,198.973787159)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(90,167.988035),new ZXb.kq(91,168.986421),new ZXb.kq(92,169.981734918),new ZXb.kq(93,170.981251),new ZXb.kq(94,171.977376138),new ZXb.kq(95,172.976499642),new ZXb.kq(96,173.972811276),new ZXb.kq(97,174.972276),new ZXb.kq(98,175.969),new ZXb.kq(99,176.968453),new ZXb.kq(100,177.964894223),new ZXb.kq(101,178.965475),new ZXb.kq(102,179.962023729),new ZXb.kq(103,180.963177),new ZXb.kq(104,181.961267637),new ZXb.kq(105,182.961729),new ZXb.kq(106,183.959851685),new ZXb.kq(107,184.960753782),new ZXb.kq(108,185.959432346),new ZXb.kq(109,186.960697),new ZXb.kq(110,187.959395697),new ZXb.kq(111,188.9608319),new ZXb.kq(112,189.959930073),new ZXb.kq(113,190.961684653),new ZXb.kq(114,191.961035158),new ZXb.kq(115,192.962984504),new ZXb.kq(116,193.962663581),new ZXb.kq(117,194.964774449),new ZXb.kq(118,195.964934884),new ZXb.kq(119,196.967323401),new ZXb.kq(120,197.967876009),new ZXb.kq(121,198.970576213),new ZXb.kq(122,199.971423885),new ZXb.kq(123,200.974496467),new ZXb.kq(124,201.97574)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(92,170.991183),new ZXb.kq(93,171.990109),new ZXb.kq(94,172.986398138),new ZXb.kq(95,173.984325861),new ZXb.kq(96,174.981552),new ZXb.kq(97,175.980269),new ZXb.kq(98,176.977215),new ZXb.kq(99,177.975975),new ZXb.kq(100,178.973412),new ZXb.kq(101,179.972396),new ZXb.kq(102,180.969948),new ZXb.kq(103,181.968621416),new ZXb.kq(104,182.96762),new ZXb.kq(105,183.966776046),new ZXb.kq(106,184.965806956),new ZXb.kq(107,185.965997671),new ZXb.kq(108,186.964562),new ZXb.kq(109,187.965321662),new ZXb.kq(110,188.9642243),new ZXb.kq(111,189.964698757),new ZXb.kq(112,190.963649239),new ZXb.kq(113,191.964810107),new ZXb.kq(114,192.964131745),new ZXb.kq(115,193.96533889),new ZXb.kq(116,194.965017928),new ZXb.kq(117,195.966551315),new ZXb.kq(118,196.966551609),new ZXb.kq(119,197.968225244),new ZXb.kq(120,198.968748016),new ZXb.kq(121,199.970717886),new ZXb.kq(122,200.971640839),new ZXb.kq(123,201.973788431),new ZXb.kq(124,202.975137256),new ZXb.kq(125,203.977705),new ZXb.kq(126,204.97961)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(95,174.991411),new ZXb.kq(96,175.987413248),new ZXb.kq(97,176.986336874),new ZXb.kq(98,177.982476325),new ZXb.kq(99,178.981783),new ZXb.kq(100,179.978322),new ZXb.kq(101,180.977806),new ZXb.kq(102,181.97393546),new ZXb.kq(103,182.974561),new ZXb.kq(104,183.970705219),new ZXb.kq(105,184.971983),new ZXb.kq(106,185.969460021),new ZXb.kq(107,186.969785),new ZXb.kq(108,187.967511693),new ZXb.kq(109,188.968733187),new ZXb.kq(110,189.966958568),new ZXb.kq(111,190.96706311),new ZXb.kq(112,191.965921572),new ZXb.kq(113,192.966644169),new ZXb.kq(114,193.965381832),new ZXb.kq(115,194.966638981),new ZXb.kq(116,195.965814846),new ZXb.kq(117,196.967195333),new ZXb.kq(118,197.96675183),new ZXb.kq(119,198.968262489),new ZXb.kq(120,199.968308726),new ZXb.kq(121,200.970285275),new ZXb.kq(122,201.970625604),new ZXb.kq(123,202.972857096),new ZXb.kq(124,203.97347564),new ZXb.kq(125,204.976056104),new ZXb.kq(126,205.977498672),new ZXb.kq(127,206.982577025),new ZXb.kq(128,207.98594)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(96,176.996881),new ZXb.kq(97,177.994637),new ZXb.kq(98,178.991466),new ZXb.kq(99,179.990194),new ZXb.kq(100,180.986904),new ZXb.kq(101,181.98561),new ZXb.kq(102,182.982697),new ZXb.kq(103,183.98176),new ZXb.kq(104,184.9791),new ZXb.kq(105,185.977549881),new ZXb.kq(106,186.97617),new ZXb.kq(107,187.97592),new ZXb.kq(108,188.974290451),new ZXb.kq(109,189.974473379),new ZXb.kq(110,190.972261952),new ZXb.kq(111,191.972770785),new ZXb.kq(112,192.970548),new ZXb.kq(113,193.971053),new ZXb.kq(114,194.96965),new ZXb.kq(115,195.970515),new ZXb.kq(116,196.9695362),new ZXb.kq(117,197.970466294),new ZXb.kq(118,198.969813837),new ZXb.kq(119,199.970945394),new ZXb.kq(120,200.97080377),new ZXb.kq(121,201.972090569),new ZXb.kq(122,202.972329088),new ZXb.kq(123,203.973848646),new ZXb.kq(124,204.97441227),new ZXb.kq(125,205.976095321),new ZXb.kq(126,206.977407908),new ZXb.kq(127,207.982004653),new ZXb.kq(128,208.985349125),new ZXb.kq(129,209.990065574)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(99,180.996714),new ZXb.kq(100,181.992676101),new ZXb.kq(101,182.99193),new ZXb.kq(102,183.988198),new ZXb.kq(103,184.98758),new ZXb.kq(104,185.983485388),new ZXb.kq(105,186.98403),new ZXb.kq(106,187.979869108),new ZXb.kq(107,188.98088),new ZXb.kq(108,189.978180008),new ZXb.kq(109,190.9782),new ZXb.kq(110,191.975719811),new ZXb.kq(111,192.97608),new ZXb.kq(112,193.974648056),new ZXb.kq(113,194.975920279),new ZXb.kq(114,195.97271),new ZXb.kq(115,196.97338),new ZXb.kq(116,197.97198),new ZXb.kq(117,198.972909384),new ZXb.kq(118,199.97181556),new ZXb.kq(119,200.972846589),new ZXb.kq(120,201.972143786),new ZXb.kq(121,202.973375491),new ZXb.kq(122,203.973028761),new ZXb.kq(123,204.974467112),new ZXb.kq(124,205.974449002),new ZXb.kq(125,206.975880605),new ZXb.kq(126,207.97663585),new ZXb.kq(127,208.981074801),new ZXb.kq(128,209.984173129),new ZXb.kq(129,210.988731474),new ZXb.kq(130,211.991887495),new ZXb.kq(131,212.9965),new ZXb.kq(132,213.999798147)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(102,184.997708),new ZXb.kq(103,185.99648),new ZXb.kq(104,186.993458),new ZXb.kq(105,187.992173),new ZXb.kq(106,188.989505),new ZXb.kq(107,189.987520007),new ZXb.kq(108,190.986053),new ZXb.kq(109,191.985368),new ZXb.kq(110,192.983662229),new ZXb.kq(111,193.983430186),new ZXb.kq(112,194.98112697),new ZXb.kq(113,195.981236107),new ZXb.kq(114,196.978934287),new ZXb.kq(115,197.979024396),new ZXb.kq(116,198.977576953),new ZXb.kq(117,199.978141983),new ZXb.kq(118,200.976970721),new ZXb.kq(119,201.977674504),new ZXb.kq(120,202.976868118),new ZXb.kq(121,203.977805161),new ZXb.kq(122,204.977374688),new ZXb.kq(123,205.978482854),new ZXb.kq(124,206.978455217),new ZXb.kq(125,207.979726699),new ZXb.kq(126,208.980383241),new ZXb.kq(127,209.984104944),new ZXb.kq(128,210.987258139),new ZXb.kq(129,211.991271542),new ZXb.kq(130,212.994374836),new ZXb.kq(131,213.998698664),new ZXb.kq(132,215.001832349),new ZXb.kq(133,216.006199)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(106,189.994293888),new ZXb.kq(107,190.994653),new ZXb.kq(108,191.99033039),new ZXb.kq(109,192.991102),new ZXb.kq(110,193.988284107),new ZXb.kq(111,194.988045),new ZXb.kq(112,195.985469432),new ZXb.kq(113,196.985567),new ZXb.kq(114,197.984024384),new ZXb.kq(115,198.985044507),new ZXb.kq(116,199.981735),new ZXb.kq(117,200.982209),new ZXb.kq(118,201.980704),new ZXb.kq(119,202.981412863),new ZXb.kq(120,203.980307113),new ZXb.kq(121,204.981165396),new ZXb.kq(122,205.980465241),new ZXb.kq(123,206.981578228),new ZXb.kq(124,207.981231059),new ZXb.kq(125,208.982415788),new ZXb.kq(126,209.982857396),new ZXb.kq(127,210.986636869),new ZXb.kq(128,211.988851755),new ZXb.kq(129,212.992842522),new ZXb.kq(130,213.995185949),new ZXb.kq(131,214.999414609),new ZXb.kq(132,216.001905198),new ZXb.kq(133,217.006253),new ZXb.kq(134,218.008965773)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(108,193.000188),new ZXb.kq(109,193.997973),new ZXb.kq(110,194.996554),new ZXb.kq(111,195.995702),new ZXb.kq(112,196.993891293),new ZXb.kq(113,197.99343368),new ZXb.kq(114,198.991008569),new ZXb.kq(115,199.990920883),new ZXb.kq(116,200.988486908),new ZXb.kq(117,201.988448629),new ZXb.kq(118,202.986847216),new ZXb.kq(119,203.987261559),new ZXb.kq(120,204.986036352),new ZXb.kq(121,205.986599242),new ZXb.kq(122,206.985775861),new ZXb.kq(123,207.986582508),new ZXb.kq(124,208.986158678),new ZXb.kq(125,209.987131308),new ZXb.kq(126,210.987480806),new ZXb.kq(127,211.990734657),new ZXb.kq(128,212.99292115),new ZXb.kq(129,213.996356412),new ZXb.kq(130,214.998641245),new ZXb.kq(131,216.002408839),new ZXb.kq(132,217.004709619),new ZXb.kq(133,218.008681458),new ZXb.kq(134,219.011296478),new ZXb.kq(135,220.015301),new ZXb.kq(136,221.01814),new ZXb.kq(137,222.02233),new ZXb.kq(138,223.02534)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(110,196.001117268),new ZXb.kq(111,197.001661),new ZXb.kq(112,197.998779978),new ZXb.kq(113,198.998309),new ZXb.kq(114,199.995634148),new ZXb.kq(115,200.995535),new ZXb.kq(116,201.993899382),new ZXb.kq(117,202.994765192),new ZXb.kq(118,203.991365),new ZXb.kq(119,204.991668),new ZXb.kq(120,205.99016),new ZXb.kq(121,206.990726826),new ZXb.kq(122,207.989631237),new ZXb.kq(123,208.990376634),new ZXb.kq(124,209.989679862),new ZXb.kq(125,210.99058541),new ZXb.kq(126,211.990688899),new ZXb.kq(127,212.993868354),new ZXb.kq(128,213.995346275),new ZXb.kq(129,214.998729195),new ZXb.kq(130,216.000258153),new ZXb.kq(131,217.003914555),new ZXb.kq(132,218.005586315),new ZXb.kq(133,219.009474831),new ZXb.kq(134,220.011384149),new ZXb.kq(135,221.015455),new ZXb.kq(136,222.017570472),new ZXb.kq(137,223.02179),new ZXb.kq(138,224.02409),new ZXb.kq(139,225.02844),new ZXb.kq(140,226.03089),new ZXb.kq(141,227.035407),new ZXb.kq(142,228.038084)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(113,200.006499),new ZXb.kq(114,201.00458692),new ZXb.kq(115,202.00396885),new ZXb.kq(116,203.001423829),new ZXb.kq(117,204.001221209),new ZXb.kq(118,204.998663961),new ZXb.kq(119,205.998486886),new ZXb.kq(120,206.996859385),new ZXb.kq(121,207.997133849),new ZXb.kq(122,208.995915421),new ZXb.kq(123,209.996398327),new ZXb.kq(124,210.995529332),new ZXb.kq(125,211.996194988),new ZXb.kq(126,212.996174845),new ZXb.kq(127,213.99895474),new ZXb.kq(128,215.000326029),new ZXb.kq(129,216.003187873),new ZXb.kq(130,217.004616452),new ZXb.kq(131,218.007563326),new ZXb.kq(132,219.009240843),new ZXb.kq(133,220.012312978),new ZXb.kq(134,221.014245654),new ZXb.kq(135,222.017543957),new ZXb.kq(136,223.019730712),new ZXb.kq(137,224.023235513),new ZXb.kq(138,225.025606914),new ZXb.kq(139,226.029343423),new ZXb.kq(140,227.031833167),new ZXb.kq(141,228.034776087),new ZXb.kq(142,229.038426),new ZXb.kq(143,230.04251),new ZXb.kq(144,231.045407),new ZXb.kq(145,232.049654)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(115,203.00921),new ZXb.kq(116,204.006434513),new ZXb.kq(117,205.006187),new ZXb.kq(118,206.004463814),new ZXb.kq(119,207.005176607),new ZXb.kq(120,208.001776),new ZXb.kq(121,209.001944),new ZXb.kq(122,210.000446),new ZXb.kq(123,211.000893996),new ZXb.kq(124,211.999783492),new ZXb.kq(125,213.000345847),new ZXb.kq(126,214.000091141),new ZXb.kq(127,215.002704195),new ZXb.kq(128,216.003518402),new ZXb.kq(129,217.00630601),new ZXb.kq(130,218.007123948),new ZXb.kq(131,219.010068787),new ZXb.kq(132,220.011014669),new ZXb.kq(133,221.013907762),new ZXb.kq(134,222.01536182),new ZXb.kq(135,223.01849714),new ZXb.kq(136,224.020202004),new ZXb.kq(137,225.023604463),new ZXb.kq(138,226.025402555),new ZXb.kq(139,227.029170677),new ZXb.kq(140,228.031064101),new ZXb.kq(141,229.034820309),new ZXb.kq(142,230.037084774),new ZXb.kq(143,231.04122),new ZXb.kq(144,232.043693),new ZXb.kq(145,233.047995),new ZXb.kq(146,234.050547)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(118,207.012469754),new ZXb.kq(119,208.012112949),new ZXb.kq(120,209.009568736),new ZXb.kq(121,210.009256802),new ZXb.kq(122,211.007648196),new ZXb.kq(123,212.007811441),new ZXb.kq(124,213.006573689),new ZXb.kq(125,214.006893072),new ZXb.kq(126,215.006450832),new ZXb.kq(127,216.008721268),new ZXb.kq(128,217.009332676),new ZXb.kq(129,218.011625045),new ZXb.kq(130,219.012404918),new ZXb.kq(131,220.014752105),new ZXb.kq(132,221.015575746),new ZXb.kq(133,222.017828852),new ZXb.kq(134,223.01912603),new ZXb.kq(135,224.021708435),new ZXb.kq(136,225.023220576),new ZXb.kq(137,226.026089848),new ZXb.kq(138,227.027746979),new ZXb.kq(139,228.031014825),new ZXb.kq(140,229.032930871),new ZXb.kq(141,230.036025144),new ZXb.kq(142,231.038551503),new ZXb.kq(143,232.042022474),new ZXb.kq(144,233.04455),new ZXb.kq(145,234.04842),new ZXb.kq(146,235.051102),new ZXb.kq(147,236.055178)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(120,210.015711883),new ZXb.kq(121,211.016306912),new ZXb.kq(122,212.012916),new ZXb.kq(123,213.012962),new ZXb.kq(124,214.011451),new ZXb.kq(125,215.011726597),new ZXb.kq(126,216.011050963),new ZXb.kq(127,217.013066169),new ZXb.kq(128,218.013267744),new ZXb.kq(129,219.015521253),new ZXb.kq(130,220.015733126),new ZXb.kq(131,221.018171499),new ZXb.kq(132,222.018454131),new ZXb.kq(133,223.020795153),new ZXb.kq(134,224.02145925),new ZXb.kq(135,225.023941441),new ZXb.kq(136,226.024890681),new ZXb.kq(137,227.027698859),new ZXb.kq(138,228.028731348),new ZXb.kq(139,229.03175534),new ZXb.kq(140,230.033126574),new ZXb.kq(141,231.03629706),new ZXb.kq(142,232.03805036),new ZXb.kq(143,233.041576923),new ZXb.kq(144,234.043595497),new ZXb.kq(145,235.04750442),new ZXb.kq(146,236.04971),new ZXb.kq(147,237.053894),new ZXb.kq(148,238.056243)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(122,213.021183209),new ZXb.kq(123,214.02073923),new ZXb.kq(124,215.019097612),new ZXb.kq(125,216.019109649),new ZXb.kq(126,217.018288571),new ZXb.kq(127,218.020007906),new ZXb.kq(128,219.019880348),new ZXb.kq(129,220.021876493),new ZXb.kq(130,221.021863742),new ZXb.kq(131,222.023726),new ZXb.kq(132,223.023963748),new ZXb.kq(133,224.025614854),new ZXb.kq(134,225.026115172),new ZXb.kq(135,226.02793275),new ZXb.kq(136,227.028793151),new ZXb.kq(137,228.031036942),new ZXb.kq(138,229.032088601),new ZXb.kq(139,230.034532562),new ZXb.kq(140,231.035878898),new ZXb.kq(141,232.03858172),new ZXb.kq(142,233.040240235),new ZXb.kq(143,234.043302325),new ZXb.kq(144,235.045436759),new ZXb.kq(145,236.048675176),new ZXb.kq(146,237.05113943),new ZXb.kq(147,238.054497046),new ZXb.kq(148,239.05713),new ZXb.kq(149,240.06098)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(126,218.023487),new ZXb.kq(127,219.024915423),new ZXb.kq(128,220.024712),new ZXb.kq(129,221.026351),new ZXb.kq(130,222.02607),new ZXb.kq(131,223.027722956),new ZXb.kq(132,224.027590139),new ZXb.kq(133,225.029384369),new ZXb.kq(134,226.02933975),new ZXb.kq(135,227.031140069),new ZXb.kq(136,228.031366357),new ZXb.kq(137,229.033496137),new ZXb.kq(138,230.033927392),new ZXb.kq(139,231.036289158),new ZXb.kq(140,232.03714628),new ZXb.kq(141,233.039628196),new ZXb.kq(142,234.040945606),new ZXb.kq(143,235.043923062),new ZXb.kq(144,236.045561897),new ZXb.kq(145,237.048723955),new ZXb.kq(146,238.050782583),new ZXb.kq(147,239.054287777),new ZXb.kq(148,240.056585734),new ZXb.kq(149,241.06033),new ZXb.kq(150,242.062925)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(132,225.033899689),new ZXb.kq(133,226.035129),new ZXb.kq(134,227.034958261),new ZXb.kq(135,228.03618),new ZXb.kq(136,229.036246866),new ZXb.kq(137,230.037812591),new ZXb.kq(138,231.038233161),new ZXb.kq(139,232.040099),new ZXb.kq(140,233.04073235),new ZXb.kq(141,234.042888556),new ZXb.kq(142,235.044055876),new ZXb.kq(143,236.046559724),new ZXb.kq(144,237.048167253),new ZXb.kq(145,238.050940464),new ZXb.kq(146,239.052931399),new ZXb.kq(147,240.056168828),new ZXb.kq(148,241.058246266),new ZXb.kq(149,242.061635),new ZXb.kq(150,243.064273),new ZXb.kq(151,244.06785)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(134,228.038727686),new ZXb.kq(135,229.040138934),new ZXb.kq(136,230.039645603),new ZXb.kq(137,231.041258),new ZXb.kq(138,232.041179445),new ZXb.kq(139,233.04298757),new ZXb.kq(140,234.043304681),new ZXb.kq(141,235.0452815),new ZXb.kq(142,236.046048088),new ZXb.kq(143,237.048403774),new ZXb.kq(144,238.0495534),new ZXb.kq(145,239.052156519),new ZXb.kq(146,240.05380746),new ZXb.kq(147,241.056845291),new ZXb.kq(148,242.058736847),new ZXb.kq(149,243.061997013),new ZXb.kq(150,244.06419765),new ZXb.kq(151,245.067738657),new ZXb.kq(152,246.070198429),new ZXb.kq(153,247.07407)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(136,231.04556),new ZXb.kq(137,232.04659),new ZXb.kq(138,233.046472),new ZXb.kq(139,234.047794),new ZXb.kq(140,235.048029),new ZXb.kq(141,236.049569),new ZXb.kq(142,237.049970748),new ZXb.kq(143,238.051977839),new ZXb.kq(144,239.053018481),new ZXb.kq(145,240.055287826),new ZXb.kq(146,241.056822944),new ZXb.kq(147,242.059543039),new ZXb.kq(148,243.061372686),new ZXb.kq(149,244.064279429),new ZXb.kq(150,245.066445398),new ZXb.kq(151,246.069768438),new ZXb.kq(152,247.072086),new ZXb.kq(153,248.075745),new ZXb.kq(154,249.07848)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(137,233.0508),new ZXb.kq(138,234.05024),new ZXb.kq(139,235.051591),new ZXb.kq(140,236.051405),new ZXb.kq(141,237.052891),new ZXb.kq(142,238.053016298),new ZXb.kq(143,239.054951),new ZXb.kq(144,240.055519046),new ZXb.kq(145,241.057646736),new ZXb.kq(146,242.058829326),new ZXb.kq(147,243.061382249),new ZXb.kq(148,244.062746349),new ZXb.kq(149,245.065485586),new ZXb.kq(150,246.067217551),new ZXb.kq(151,247.070346811),new ZXb.kq(152,248.072342247),new ZXb.kq(153,249.075947062),new ZXb.kq(154,250.078350687),new ZXb.kq(155,251.082277873),new ZXb.kq(156,252.08487)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(138,235.05658),new ZXb.kq(139,236.05733),new ZXb.kq(140,237.057127),new ZXb.kq(141,238.058266),new ZXb.kq(142,239.058362),new ZXb.kq(143,240.059749),new ZXb.kq(144,241.060223),new ZXb.kq(145,242.06205),new ZXb.kq(146,243.06300157),new ZXb.kq(147,244.065167882),new ZXb.kq(148,245.066355386),new ZXb.kq(149,246.068666836),new ZXb.kq(150,247.070298533),new ZXb.kq(151,248.07308),new ZXb.kq(152,249.074979937),new ZXb.kq(153,250.078310529),new ZXb.kq(154,251.08075344),new ZXb.kq(155,252.084303),new ZXb.kq(156,253.08688),new ZXb.kq(157,254.0906)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(139,237.06207),new ZXb.kq(140,238.06141),new ZXb.kq(141,239.062579),new ZXb.kq(142,240.062295),new ZXb.kq(143,241.063716),new ZXb.kq(144,242.063688713),new ZXb.kq(145,243.065421),new ZXb.kq(146,244.06599039),new ZXb.kq(147,245.068039),new ZXb.kq(148,246.068798807),new ZXb.kq(149,247.070992043),new ZXb.kq(150,248.07217808),new ZXb.kq(151,249.074846818),new ZXb.kq(152,250.076399951),new ZXb.kq(153,251.079580056),new ZXb.kq(154,252.081619582),new ZXb.kq(155,253.085126791),new ZXb.kq(156,254.087316198),new ZXb.kq(157,255.091039),new ZXb.kq(158,256.09344)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(141,240.06892),new ZXb.kq(142,241.068662),new ZXb.kq(143,242.069699),new ZXb.kq(144,243.069631),new ZXb.kq(145,244.070969),new ZXb.kq(146,245.071317),new ZXb.kq(147,246.072965),new ZXb.kq(148,247.07365),new ZXb.kq(149,248.075458),new ZXb.kq(150,249.076405),new ZXb.kq(151,250.078654),new ZXb.kq(152,251.079983592),new ZXb.kq(153,252.082972247),new ZXb.kq(154,253.084817974),new ZXb.kq(155,254.088016026),new ZXb.kq(156,255.090266386),new ZXb.kq(157,256.093592),new ZXb.kq(158,257.095979)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(142,242.07343),new ZXb.kq(143,243.07451),new ZXb.kq(144,244.074077),new ZXb.kq(145,245.075375),new ZXb.kq(146,246.075281634),new ZXb.kq(147,247.076819),new ZXb.kq(148,248.077184411),new ZXb.kq(149,249.079024),new ZXb.kq(150,250.079514759),new ZXb.kq(151,251.081566467),new ZXb.kq(152,252.082460071),new ZXb.kq(153,253.085176259),new ZXb.kq(154,254.086847795),new ZXb.kq(155,255.089955466),new ZXb.kq(156,256.091766522),new ZXb.kq(157,257.095098635),new ZXb.kq(158,258.097069),new ZXb.kq(159,259.100588)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(144,245.081017),new ZXb.kq(145,246.081933),new ZXb.kq(146,247.081804),new ZXb.kq(147,248.082909),new ZXb.kq(148,249.083002),new ZXb.kq(149,250.084488),new ZXb.kq(150,251.084919),new ZXb.kq(151,252.08663),new ZXb.kq(152,253.08728),new ZXb.kq(153,254.089725),new ZXb.kq(154,255.091075196),new ZXb.kq(155,256.094052757),new ZXb.kq(156,257.095534643),new ZXb.kq(157,258.098425321),new ZXb.kq(158,259.100503),new ZXb.kq(159,260.103645)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(147,249.087823),new ZXb.kq(148,250.087493),new ZXb.kq(149,251.08896),new ZXb.kq(150,252.088965909),new ZXb.kq(151,253.090649),new ZXb.kq(152,254.090948746),new ZXb.kq(153,255.093232449),new ZXb.kq(154,256.094275879),new ZXb.kq(155,257.096852778),new ZXb.kq(156,258.0982),new ZXb.kq(157,259.101024),new ZXb.kq(158,260.102636),new ZXb.kq(159,261.105743),new ZXb.kq(160,262.10752)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(148,251.09436),new ZXb.kq(149,252.09533),new ZXb.kq(150,253.095258),new ZXb.kq(151,254.096587),new ZXb.kq(152,255.096769),new ZXb.kq(153,256.098763),new ZXb.kq(154,257.099606),new ZXb.kq(155,258.101883),new ZXb.kq(156,259.10299),new ZXb.kq(157,260.105572),new ZXb.kq(158,261.106941),new ZXb.kq(159,262.109692),new ZXb.kq(160,263.111394)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(149,253.100679),new ZXb.kq(150,254.100166),new ZXb.kq(151,255.101492),new ZXb.kq(152,256.101179573),new ZXb.kq(153,257.103072),new ZXb.kq(154,258.103568),new ZXb.kq(155,259.105628),new ZXb.kq(156,260.106434),new ZXb.kq(157,261.108752),new ZXb.kq(158,262.109918),new ZXb.kq(159,263.11254),new ZXb.kq(160,264.113978)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(150,255.107398),new ZXb.kq(151,256.10811),new ZXb.kq(152,257.107858),new ZXb.kq(153,258.109438),new ZXb.kq(154,259.109721),new ZXb.kq(155,260.111427),new ZXb.kq(156,261.112106),new ZXb.kq(157,262.114153),new ZXb.kq(158,263.115078),new ZXb.kq(159,264.117473),new ZXb.kq(160,265.118659)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(152,258.113151),new ZXb.kq(153,259.114652),new ZXb.kq(154,260.114435447),new ZXb.kq(155,261.116199),new ZXb.kq(156,262.116477),new ZXb.kq(157,263.118313),new ZXb.kq(158,264.118924),new ZXb.kq(159,265.121066),new ZXb.kq(160,266.121928)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(153,260.121803),new ZXb.kq(154,261.1218),new ZXb.kq(155,262.123009),new ZXb.kq(156,263.123146),new ZXb.kq(157,264.12473),new ZXb.kq(158,265.125198),new ZXb.kq(159,266.127009),new ZXb.kq(160,267.12774)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(155,263.12871),new ZXb.kq(156,264.128408258),new ZXb.kq(157,265.130001),new ZXb.kq(158,266.130042),new ZXb.kq(159,267.131774),new ZXb.kq(160,268.132156),new ZXb.kq(161,269.134114)]),Zjb(Ljb(TXb.Mlb,1),w_b,3,0,[new ZXb.kq(156,265.136567),new ZXb.kq(157,266.13794),new ZXb.kq(158,267.137526),new ZXb.kq(159,268.138816),new ZXb.kq(160,269.139106),new ZXb.kq(161,270.140723),new ZXb.kq(162,271.141229)])]);};ZXb.nq=function nq(a,b){ZXb.mq();var c,d;d=b-a;for(c=0;c<ZXb.lq[a].length;c++)if(ZXb.lq[a][c].b==d)return ZXb.lq[a][c].a;return NaN;};ZXb.oq=function oq(a,b){var c;if(a.b.length!=b.b.length)return a.b.length<b.b.length?-1:1;for(c=0;c<a.b.length;c++)if(a.b[c]!=b.b[c])return a.b[c]<b.b[c]?-1:1;return 0;};ZXb.pq=function pq(a){var b,c,d,e,f,g;c=0;for(e=a.a,f=0,g=e.length;f<g;++f){d=e[f];d&&++c;}a.b=Rjb(TXb.klb,xZb,6,c,15,1);c=0;for(b=0;b<a.a.length;b++)a.a[b]&&(a.b[c++]=b);};ZXb.qq=function qq(a,b){var c;ZXb.pq(a);for(c=0;c<a.b.length;c++)if(b[a.b[c]])return true;return false;};ZXb.rq=function rq(a){this.a=Rjb(TXb.Bwb,JZb,6,a,16,1);};wxb(272,1,{272:1,18:1},ZXb.rq);_.Eb=function sq(a){return ZXb.oq(this,a);};TXb.Nlb=UFb(272);ZXb.wq=function wq(){ZXb.wq=yxb;ZXb.vq=Zjb(Ljb(TXb.ilb,1),vZb,6,15,[0,1.00794,4.0026,6.941,9.0122,10.811,12.011,14.007,15.999,18.998,20.18,22.99,24.305,26.982,28.086,30.974,32.066,35.453,39.948,39.098,40.078,44.956,47.867,50.942,51.996,54.938,55.845,58.933,58.693,63.546,65.39,69.723,72.61,74.922,78.96,79.904,83.8,85.468,87.62,88.906,91.224,92.906,95.94,98.906,101.07,102.91,106.42,107.87,112.41,114.82,118.71,121.76,127.6,126.9,131.29,132.91,137.33,138.91,140.12,140.91,144.24,146.92,150.36,151.96,157.25,158.93,162.5,164.93,167.26,168.93,173.04,174.97,178.49,180.95,183.84,186.21,190.23,192.22,195.08,196.97,200.59,204.38,207.2,208.98,209.98,209.99,222.02,223.02,226.03,227.03,232.04,231.04,238.03,237.05,239.05,241.06,244.06,249.08,252.08,252.08,257.1,258.1,259.1,262.11,267.12,268.13,271.13,270.13,277.15,276.15,x_b,x_b,283.17,285.18,y_b,y_b,293.2,z_b,z_b,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.0141,3.016,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71.0787,156.18828,114.10364,115.0877,103.1447,128.13052,129.11458,57.05182,137.14158,113.15934,113.15934,128.17428,131.19846,147.17646,97.11658,87.0777,101.10458,186.2134,163.17546,99.13246]);ZXb.tq=Zjb(Ljb(TXb.ilb,1),vZb,6,15,[0,1.007825,4.0026,7.016003,9.012182,11.009305,12,14.003074,15.994915,18.998403,19.992435,22.989767,23.985042,26.98153,27.976927,30.973762,31.97207,34.968852,39.962384,38.963707,39.962591,44.95591,47.947947,50.943962,51.940509,54.938047,55.934939,58.933198,57.935346,62.939598,63.929145,68.92558,73.921177,74.921594,79.91652,78.918336,83.911507,84.911794,87.905619,88.905849,89.904703,92.906377,97.905406,89.92381,101.904348,102.9055,105.903478,106.905092,113.903357,114.90388,119.9022,120.903821,129.906229,126.904473,131.904144,132.905429,137.905232,138.906346,139.905433,140.907647,141.907719,135.92398,151.919729,152.921225,157.924099,158.925342,163.929171,164.930319,165.93029,168.934212,173.938859,174.94077,179.946545,180.947992,183.950928,186.955744,191.961467,192.962917,194.964766,196.966543,201.970617,204.974401,207.976627,208.980374,193.98818,195.99573,199.9957,201.00411,206.0038,210.00923,232.038054,216.01896,238.050784,229.03623,232.041169,237.05005,238.05302,242.06194,240.06228,243.06947,243.07446,248.08275,251.08887,253.09515,257.10295,257.10777,271.13,270.13,277.15,276.15,x_b,x_b,283.17,285.18,y_b,y_b,291.2,z_b,z_b,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.014,3.01605,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]);ZXb.uq=Zjb(Ljb(TXb.klb,1),xZb,6,15,[6,1,7,8]);};ZXb.xq=function xq(a){var b,c;c=a.a;for(b=0;b<a.b.length;b++)c+=a.b[b]*ZXb.tq[a.c[b]];return c;};ZXb.yq=function yq(a){var b,c;b=new UXb.$Hb();for(c=0;c<a.b.length;c++){UXb.ZHb(b,(ZXb.Sj(),ZXb.Mj)[a.c[c]]);a.b[c]>1&&UXb.YHb(b,a.b[c]);}return b.a;};ZXb.zq=function zq(a){var b,c;c=a.d;for(b=0;b<a.b.length;b++)c+=a.b[b]*ZXb.vq[a.c[b]];return c;};ZXb.Aq=function Aq(a){var b,c,d,e,f,g,h,i,j,k,l;ZXb.nu(a,1);e=Rjb(TXb.klb,xZb,6,191,15,1);for(c=0;c<a.q;c++){switch(a.C[c]){case 171:e[1]+=5;e[6]+=3;e[7]+=1;e[8]+=1;break;case 172:e[1]+=12;e[6]+=6;e[7]+=4;e[8]+=1;break;case 173:e[1]+=6;e[6]+=4;e[7]+=2;e[8]+=2;break;case 174:e[1]+=5;e[6]+=4;e[7]+=1;e[8]+=3;break;case 175:e[1]+=5;e[6]+=3;e[7]+=1;e[8]+=1;e[16]+=1;break;case 176:e[1]+=8;e[6]+=5;e[7]+=2;e[8]+=2;break;case 177:e[1]+=7;e[6]+=5;e[7]+=1;e[8]+=3;break;case 178:e[1]+=3;e[6]+=2;e[7]+=1;e[8]+=1;break;case 179:e[1]+=7;e[6]+=6;e[7]+=3;e[8]+=1;break;case 181:case 180:e[1]+=11;e[6]+=6;e[7]+=1;e[8]+=1;break;case 182:e[1]+=12;e[6]+=6;e[7]+=2;e[8]+=1;break;case 183:e[1]+=9;e[6]+=5;e[7]+=1;e[8]+=1;e[16]+=1;break;case 184:e[1]+=9;e[6]+=9;e[7]+=1;e[8]+=1;break;case 185:e[1]+=7;e[6]+=5;e[7]+=1;e[8]+=1;break;case 186:e[1]+=5;e[6]+=3;e[7]+=1;e[8]+=2;break;case 187:e[1]+=7;e[6]+=4;e[7]+=1;e[8]+=2;break;case 188:e[1]+=10;e[6]+=11;e[7]+=2;e[8]+=1;break;case 189:e[1]+=9;e[6]+=9;e[7]+=1;e[8]+=2;break;case 190:e[1]+=9;e[6]+=5;e[7]+=1;e[8]+=1;break;case 1:switch(a.A[c]){case 0:case 1:++e[1];break;case 2:++e[151];break;case 3:++e[152];}break;default:++e[a.C[c]];}}for(d=0;d<a.q;d++)a.C[d]>=171&&a.C[d]<=190?e[1]+=2-ZXb.ko(a,d):e[1]+=ZXb.fo(a,d);h=0;for(j=1;j<=190;j++)e[j]!=0&&++h;this.b=Rjb(TXb.klb,xZb,6,h,15,1);this.c=Rjb(TXb.klb,xZb,6,h,15,1);h=0;for(i=0;i<ZXb.uq.length;i++){if(e[ZXb.uq[i]]!=0){this.b[h]=e[ZXb.uq[i]];this.c[h]=ZXb.uq[i];++h;e[ZXb.uq[i]]=0;}}while(true){l='zzz';k=-1;for(g=1;g<=190;g++)if(e[g]>0&&UXb.xHb(l,(ZXb.Sj(),ZXb.Mj)[g])>0){l=(ZXb.Sj(),ZXb.Mj)[g];k=g;}if(k==-1)break;this.b[h]=e[k];this.c[h]=k;++h;e[k]=0;}this.a=0;this.d=0;for(b=0;b<a.f;b++){if(a.C[b]!=1&&a.A[b]!=0){g=a.C[b];f=a.A[b];this.a+=ZXb.nq(g,f)-ZXb.tq[g];this.d+=ZXb.nq(g,f)-ZXb.vq[g];}}};wxb(170,1,{170:1});_.ib=function Bq(a){var b;if(a===this)return true;if(!Ykb(a,170))return false;for(b=0;b<this.b.length;b++)if(this.b[b]!=a.b[b])return false;return true;};_.a=0;_.d=0;TXb.Olb=UFb(170);ZXb.Cq=function Cq(a){switch(a){case 6:return 1;case 53:return 2;case 33:return 3;case 34:return 4;case 35:return 5;case 15:return 6;case 16:return 7;case 17:return 8;case 7:return 9;case 8:return 10;case 9:return 11;}return 0;};ZXb.Dq=function Dq(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C;ZXb.nu(a,7);B=0;n=Rjb(TXb.Bwb,JZb,6,a.f,16,1);C=Rjb(TXb.klb,xZb,6,a.f,15,1);for(f=0;f<a.g;f++){c=a.D[0][f];d=a.D[1][f];g=a.s[c];h=a.s[d];if(g!=0&&h!=0&&g<0^h<0){n[c]=true;n[d]=true;}C[c]+=ZXb.bl(a,f);C[d]+=ZXb.bl(a,f);}for(i=0;i<a.f;i++){B+=a.s[i];if(a.s[i]==1){if(a.C[i]==7){if(!n[i]){if(C[i]<=3){B-=1;a.s[i]=0;a.T=0;if(a.j[i]!=a.e[i]){ZXb.ok(a,ZXb.Rn(a,i,a.e[i]-1));ZXb.nu(a,7);}}else if(i<a.f&&ZXb.Ur(a.p,i)){r=Rjb(TXb.Bwb,JZb,6,a.f,16,1);s=Rjb(TXb.Bwb,JZb,6,a.g,16,1);ZXb.An(a,i,true,r,s);for(k=0;k<a.f;k++){if(r[k]&&a.C[k]==7&&a.s[k]==0&&C[k]==2){if(ZXb.Gq(a,s,i,k)){B-=1;break;}}}}}}}else if(a.s[i]<0){if(a.C[i]==6||a.C[i]==7||a.C[i]==8||a.C[i]==16){if(n[i]){v=Rjb(TXb.klb,xZb,6,16,15,1);v[0]=i;A=1;w=0;while(w<A){for(e=0;e<a.r;e++){b=-1;a.D[0][e]==v[w]?b=a.D[1][e]:a.D[1][e]==v[w]&&(b=a.D[0][e]);if(b==-1)continue;if(a.s[b]!=0){l=false;for(p=0;p<A;p++){if(b==v[p]){l=true;break;}}if(!l){if(A==v.length){j=Rjb(TXb.klb,xZb,6,2*v.length,15,1);UXb.oIb(v,0,j,0,v.length);v=j;}v[A++]=b;}}}++w;}m=0;for(q=0;q<A;q++){m+=ZXb.zk(a,v[q]);}if(m<0){t=-1;u=99;for(o=0;o<A;o++){if(ZXb.zk(a,v[o])<0){if(u>ZXb.Cq(ZXb.Qk(a,v[o]))){u=ZXb.Cq(ZXb.Qk(a,v[o]));t=v[o];}}}if(t!=-1){B-=a.s[t];a.s[t]=0;a.T=0;}}}else {B-=a.s[i];a.s[i]=0;a.T=0;}}}}B>0&&(B=ZXb.Eq(a,B));return B;};ZXb.Eq=function Eq(a,b){var c,d,e,f;b>0&&(b=ZXb.Hq(a,b,9));b>0&&(b=ZXb.Hq(a,b,17));b>0&&(b=ZXb.Hq(a,b,35));b>0&&(b=ZXb.Hq(a,b,53));if(b>0){for(c=0;c<a.f;c++){if(a.s[c]>0){e=false;for(f=0;f<a.j[c];f++){d=a.i[c][f];if(a.s[d]==0&&ZXb.Cl(a,d)&&ZXb.fo(a,d)>0){a.s[d]=-1;a.T=0;--b;if(b==0)return 0;e=true;break;}}if(e)continue;}}}b>0&&(b=ZXb.Fq(a,b,8,16));b>0&&(b=ZXb.Fq(a,b,8,15));b>0&&(b=ZXb.Fq(a,b,8,6));b>0&&(b=ZXb.Fq(a,b,7,16));return b;};ZXb.Fq=function Fq(a,b,c,d){var e,f,g,h,i,j,k,l;for(e=0;e<a.f;e++){if(a.C[e]==c&&a.s[e]==0&&ZXb.fo(a,e)>0){h=false;for(j=0;j<a.j[e];j++){if(a.n[e][j]==1){f=a.i[e][j];if(a.C[f]==d){l=false;i=false;for(k=0;k<a.j[f];k++){g=a.i[f][k];if(a.s[g]<0){i=true;break;}g!=e&&a.C[g]==8&&a.n[f][k]==2&&(l=true);}if(!i&&l){a.s[e]=-1;a.T=0;--b;if(b==0)return 0;h=true;}}}if(h)break;}}}return b;};ZXb.Gq=function Gq(a,b,c,d){var e,f,g,h,i,j,k,l;l=Rjb(TXb.klb,xZb,6,a.g,15,1);i=Rjb(TXb.Bwb,JZb,6,a.g,16,1);for(g=0;g<a.g;g++){l[g]=a.H[g];if(b[g]){i[g]=true;a.H[g]=1;a.T=0;}}for(e=0;e<a.f;e++){if(e!=d&&a.o[e]==0&&i[a.k[d][0]]){for(k=0;k<a.j[e];k++){h=a.k[e][k];a.H[h]=1;a.T=0;i[h]=false;}}}for(j=0;j<a.j[c];j++){h=a.k[c][j];a.H[h]=1;a.T=0;i[h]=false;}if(ZXb.je(new ZXb.te(a),i,false)){a.s[c]=0;a.T=0;a.j[d]!=a.e[d]&&ZXb.ok(a,ZXb.Rn(a,d,a.e[d]-1));ZXb.nu(a,7);return true;}for(f=0;f<a.g;f++){ZXb.Fm(a,f,l[f]);}return false;};ZXb.Hq=function Hq(a,b,c){var d;for(d=0;d<a.f;d++){if(a.C[d]==c&&a.s[d]==0&&a.j[d]==0){a.s[d]=-1;a.T=0;--b;if(b==0)return 0;}}return b;};ZXb.Iq=function Iq(a,b){var c,d;d=TYb.PKb(a.b,b);for(c=XXb.KTb(d).length;c<10;c++)UXb.bIb(a.a,32);UXb.fIb(a.a,d);};ZXb.Jq=function Jq(a,b){var c,d,e;if(b<0||b>999){UXb.fIb(a.a,'  ?');return;}c=false;for(d=0;d<3;d++){e=b/100|0;if(e==0){d==2||c?UXb.bIb(a.a,48):UXb.bIb(a.a,32);}else {UXb.bIb(a.a,48+e&oZb);c=true;}b=10*(b%100);}};ZXb.Kq=function Kq(a,b){QYb.TEb(b,a.a.a);};ZXb.Lq=function Lq(a){ZXb.Mq.call(this,a);};ZXb.Mq=function Mq(a){ZXb.Oq.call(this,a,new UXb.jIb());};ZXb.Nq=function Nq(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z;this.b=new TYb.SKb((N=A_b,N));ZXb.nu(a,15);L=true;for(e=0;e<a.f;e++){if((a.u[e]&3)!=0&&(a.u[e]&3)!=3&&(a.u[e]&D$b)>>18!=1){L=false;break;}}O=-1;if(L){F=Rjb(TXb.klb,xZb,6,32,15,1);P=0;for(f=0;f<a.f;f++){if((a.u[f]&3)!=0&&(a.u[f]&3)!=3&&(a.u[f]&D$b)>>18==1){H=(a.u[f]&D$b)>>18!=1&&(a.u[f]&D$b)>>18!=2?-1:(a.u[f]&g_b)>>20;++F[H];if(P<F[H]){P=F[H];O=H;}break;}}}this.a=!c?new UXb.iIb():c;R=a.P!=null?a.P:'';UXb.fIb(this.a,R+$Yb);UXb.fIb(this.a,'Actelion Java MolfileCreator 1.0\n\n');ZXb.Jq(this,a.q);ZXb.Jq(this,a.r);UXb.fIb(this.a,'  0  0');ZXb.Jq(this,L?0:1);UXb.fIb(this.a,'  0  0  0  0  0999 V2000\n');I=a.q==1;for(i=1;i<a.q;i++){if(a.J[i].a!=a.J[0].a||a.J[i].b!=a.J[0].b||a.J[i].c!=a.J[0].c){I=true;break;}}G=1;if(I){if(b!=0){G=b;}else {s=ZXb.Sk(a,a.q,a.r,(ZXb.Sj(),ZXb.Rj));if(s!=0){(s<1||s>3)&&(G=1.5/s);}else {Q=$$b;for(f=1;f<a.q;f++){for(h=0;h<f;h++){B=a.J[h].a-a.J[f].a;C=a.J[h].b-a.J[f].b;D=a.J[h].c-a.J[f].c;A=B*B+C*C+D*D;Q>A&&(Q=A);}}G=3/Q;}}}for(j=0;j<a.q;j++){if(I){ZXb.Iq(this,G*a.J[j].a);ZXb.Iq(this,G*-a.J[j].b);ZXb.Iq(this,G*-a.J[j].c);}else {UXb.fIb(this.a,'    0.0000    0.0000    0.0000');}if((a.v==null?null:a.v[j])!=null)UXb.fIb(this.a,' L  ');else if(bxb(Iwb(a.B[j],1),0))UXb.fIb(this.a,' A  ');else if(a.C[j]>=129&&a.C[j]<=144||a.C[j]==154)UXb.fIb(this.a,' R# ');else {p=(ZXb.Sj(),ZXb.Mj)[a.C[j]];UXb.fIb(this.a,' '+p);XXb.KTb(p).length==1?UXb.fIb(this.a,'  '):XXb.KTb(p).length==2&&UXb.fIb(this.a,' ');}UXb.fIb(this.a,' 0  0  0');J=Iwb(VZb,a.B[j]);Nwb(J,0)==0?UXb.fIb(this.a,'  0'):Nwb(J,384)==0?UXb.fIb(this.a,'  3'):Nwb(J,128)==0?UXb.fIb(this.a,'  2'):Nwb(J,1792)==0?UXb.fIb(this.a,'  1'):Nwb(J,1664)==0&&UXb.fIb(this.a,'  2');UXb.fIb(this.a,bxb(Iwb(a.B[j],v$b),0)?'  1':'  0');Z=((a.u[j]&f_b)>>>27)-1;Z==-1?UXb.fIb(this.a,'  0'):Z==0?UXb.fIb(this.a,' 15'):ZXb.Jq(this,Z);UXb.fIb(this.a,'  0  0  0');ZXb.Jq(this,$wnd.Math.abs(a.w[j]));UXb.fIb(this.a,'  0  0\n');}for(t=0;t<a.r;t++){switch(a.H[t]){case 1:T=1;W=0;break;case 2:T=2;W=0;break;case 4:T=3;W=0;break;case 129:T=1;W=6;break;case 257:T=1;W=1;break;case 386:T=2;W=3;break;case 64:T=4;W=0;break;case 32:T=8;W=0;break;default:T=1;W=0;}if(L&&(W==1||W==6)){f=a.D[0][t];(a.u[f]&D$b)>>18==2?W=0:(a.u[f]&D$b)>>18==1&&((a.u[f]&D$b)>>18!=1&&(a.u[f]&D$b)>>18!=2?-1:(a.u[f]&g_b)>>20)!=O&&(W=4);}u=a.G[t]&31;u!=0&&(u==8?T=4:u==3?T=5:u==9?T=6:u==10?T=7:T=8);V=a.G[t]&384;Y=V==0?0:V==256?1:2;ZXb.Jq(this,1+a.D[0][t]);ZXb.Jq(this,1+a.D[1][t]);ZXb.Jq(this,T);ZXb.Jq(this,W);UXb.fIb(this.a,'  0');ZXb.Jq(this,Y);UXb.fIb(this.a,'  0\n');}S=0;for(k=0;k<a.q;k++)a.s[k]!=0&&++S;if(S!=0){w=0;for(f=0;f<a.q;f++){if(a.s[f]!=0){if(w==0){UXb.fIb(this.a,'M  CHG');ZXb.Jq(this,$wnd.Math.min(8,S));}UXb.fIb(this.a,' ');ZXb.Jq(this,f+1);v=a.s[f];if(v<0){UXb.fIb(this.a,'  -');v=-v;}else UXb.fIb(this.a,'   ');UXb.bIb(this.a,48+v&oZb);--S;if(++w==8||S==0){w=0;UXb.fIb(this.a,$Yb);}}}}S=0;for(l=0;l<a.q;l++)a.A[l]==0||++S;if(S!=0){w=0;for(f=0;f<a.q;f++){if(a.A[f]!=0){if(w==0){UXb.fIb(this.a,'M  ISO');ZXb.Jq(this,$wnd.Math.min(8,S));}UXb.fIb(this.a,' ');ZXb.Jq(this,f+1);UXb.fIb(this.a,' ');ZXb.Jq(this,a.A[f]);--S;if(++w==8||S==0){w=0;UXb.fIb(this.a,$Yb);}}}}S=0;for(m=0;m<a.q;m++)(a.u[m]&48)!=0&&++S;if(S!=0){w=0;for(f=0;f<a.q;f++){if((a.u[f]&48)!=0){if(w==0){UXb.fIb(this.a,'M  RAD');ZXb.Jq(this,$wnd.Math.min(8,S));}UXb.fIb(this.a,' ');ZXb.Jq(this,f+1);switch(a.u[f]&48){case 16:UXb.fIb(this.a,'   1');break;case 32:UXb.fIb(this.a,'   2');break;case 48:UXb.fIb(this.a,'   3');}--S;if(++w==8||S==0){w=0;UXb.fIb(this.a,$Yb);}}}}S=0;for(n=0;n<a.q;n++)(a.C[n]>=129&&a.C[n]<=144||a.C[n]==154)&&++S;if(S!=0){w=0;for(d=0;d<a.q;d++){r=a.C[d];if(r>=129&&r<=144||r==154){if(w==0){UXb.fIb(this.a,'M  RGP');ZXb.Jq(this,$wnd.Math.min(8,S));}UXb.fIb(this.a,' ');ZXb.Jq(this,d+1);UXb.fIb(this.a,' ');ZXb.Jq(this,r==154?0:r>=142?r-141:r-125);--S;if(++w==8||S==0){w=0;UXb.fIb(this.a,$Yb);}}}}if(a.K){S=0;for(f=0;f<a.q;f++)bxb(Iwb(a.B[f],120),0)&&++S;if(S!=0){w=0;for(h=0;h<a.q;h++){U=Iwb(a.B[h],120);if(Nwb(U,0)!=0){if(w==0){UXb.fIb(this.a,'M  RBC');ZXb.Jq(this,$wnd.Math.min(8,S));}UXb.fIb(this.a,' ');ZXb.Jq(this,h+1);Nwb(U,112)==0?UXb.fIb(this.a,'  -1'):Nwb(U,8)==0?UXb.fIb(this.a,'   1'):Nwb(U,104)==0?UXb.fIb(this.a,'   2'):Nwb(U,88)==0?UXb.fIb(this.a,'   3'):Nwb(U,56)==0&&UXb.fIb(this.a,'   4');--S;if(++w==8||S==0){w=0;UXb.fIb(this.a,$Yb);}}}}for(o=0;o<a.q;o++){q=a.v==null?null:a.v[o];if(q!=null){UXb.fIb(this.a,'M  ALS ');ZXb.Jq(this,o+1);ZXb.Jq(this,q.length);UXb.fIb(this.a,bxb(Iwb(a.B[o],1),0)?' T ':' F ');for(K=0;K<q.length;K++){M=(ZXb.Sj(),ZXb.Mj)[q[K]];switch(XXb.KTb(M).length){case 1:UXb.fIb(this.a,M+'   ');break;case 2:UXb.fIb(this.a,M+'  ');break;case 3:UXb.fIb(this.a,M+' ');break;default:UXb.fIb(this.a,'   ?');}}UXb.fIb(this.a,$Yb);}}S=0;for(g=0;g<a.q;g++)bxb(Iwb(a.B[g],6144),0)&&++S;if(S!=0){w=0;for(d=0;d<a.q;d++){X=Iwb(a.B[d],6144);if(Nwb(X,0)!=0){if(w==0){UXb.fIb(this.a,'M  SUB');ZXb.Jq(this,$wnd.Math.min(8,S));}UXb.fIb(this.a,' ');ZXb.Jq(this,d+1);bxb(Iwb(X,RZb),0)?UXb.fIb(this.a,'   '+(a.e[d]+1)):UXb.fIb(this.a,'  -2');--S;if(++w==8||S==0){w=0;UXb.fIb(this.a,$Yb);}}}}}UXb.fIb(this.a,B_b);};ZXb.Oq=function Oq(a,b){ZXb.Nq.call(this,a,0,b);};wxb(135,1,{},ZXb.Lq,ZXb.Nq);TXb.Qlb=UFb(135);ZXb.Pq=function Pq(a,b,c,d,e,f){var g,h,i,j;j=1;h=false;switch(e){case 1:j=257;break;case 3:j=386;break;case 4:j=257;h=true;break;case 6:j=129;break;default:switch(d){case 1:j=1;break;case 2:j=2;break;case 3:j=4;break;case 4:j=64;break;case 9:j=32;}}g=ZXb.Wj(a.j,b,c,j);i=0;h&&ZXb.hm(a.j,b,1,-1);if(d>4){switch(d){case 5:i|=3;break;case 6:i|=9;break;case 7:i|=10;break;case 8:j!=32&&(i|=31);}}f==1&&(i|=256);f==2&&(i|=128);i!=0&&ZXb.Em(a.j,g,i,true);return g;};ZXb.Qq=function Qq(a){var b,c,d,e,f,g,h,i,j,k,l;g=Rjb(TXb.klb,xZb,6,a.j.q,15,1);for(c=0;c<a.j.q;c++)g[c]=-ZXb.zk(a.j,c);ZXb.je(new ZXb.te(a.j),null,true);for(d=0;d<a.j.q;d++)g[d]+=ZXb.zk(a.j,d);for(b=0;b<a.j.q;b++){if(g[b]!=0){h=-g[b];for(e=0;e<a.j.r;e++){for(j=0;j<2;j++){if(h>0&&ZXb.el(a.j,e)==32&&ZXb.Vk(a.j,1-j,e)==b){l=ZXb.Vk(a.j,j,e);if(ZXb.Fl(a.j,l)){k=ZXb.Sq(a,l);f=ZXb.zk(a.j,l);if(f<k){i=$wnd.Math.min(h,k-f);ZXb.cm(a.j,l,f+i);h-=i;}}}}}}}};ZXb.Rq=function Rq(a,b){a.j=null;return ZXb.hr(a,new QYb.OEb(new QYb.SEb(b)))?a.j:null;};ZXb.Sq=function Sq(a,b){var c,d;c=ZXb.Qk(a.j,b);d=c<(ZXb.Sj(),ZXb.Oj).length?ZXb.Oj[c]:null;return d==null?0:d[d.length-1];};ZXb.Tq=function Tq(a,b){var c;c=!a.b?null:$Xb.kNb(a.b,new UXb.HGb(b));return !c?b-1:c.a;};ZXb.Uq=function Uq(a,b){var c;c=!a.c?null:$Xb.kNb(a.c,new UXb.HGb(b));return !c?b-1:c.a;};ZXb.Vq=function Vq(a,b){var c,d;if(b!=null){ZXb.nu(a.j,1);for(c=0;c<a.j.f;c++){if(b[c]!=0){d=ZXb.il(a.j,c,ZXb.ko(a.j,c));b[c]==15?d>=0&&ZXb.am(a.j,c,0):b[c]!=ZXb.jl(a.j,c)&&ZXb.am(a.j,c,b[c]-d);}}}};ZXb.Wq=function Wq(a,b){var c;if(b==-1){return -1;}for(c=b+1;c<XXb.KTb(a).length;c++){XXb.FTb(c,XXb.KTb(a).length);if(XXb.KTb(a).charCodeAt(c)!=32&&(XXb.FTb(c,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(c)!=9)){return c;}}return -1;};ZXb.Xq=function Xq(a,b){var c;for(c=b;c<XXb.KTb(a).length;c++){XXb.FTb(c,XXb.KTb(a).length);if(XXb.KTb(a).charCodeAt(c)==32||(XXb.FTb(c,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(c)==9)){return c;}}return -1;};ZXb.Yq=function Yq(a){if(XXb.KTb(a).indexOf('ATOMS=(')!=-1)return C_b;if(XXb.KTb(a).indexOf('BONDS=(')!=-1)return 'BONDS';return null;};ZXb.Zq=function Zq(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F;p=0;q=(h=ZXb.Xq(b,p+1),h==-1?XXb.KTb(b).length:h);d=UXb.mGb((XXb.ETb(p,q,XXb.KTb(b).length),XXb.KTb(b).substr(p,q-p)),D_b,fZb);p=ZXb.Wq(b,q);q=(i=ZXb.Xq(b,p+1),i==-1?XXb.KTb(b).length:i);s=(XXb.ETb(p,q,XXb.KTb(b).length),XXb.KTb(b).substr(p,q-p));A=null;e=false;r=ZXb.er(b);if(r!=0){A=ZXb.$q(b);r<0&&(e=true);q=$wnd.Math.abs(r);}p=ZXb.Wq(b,q);q=(j=ZXb.Xq(b,p+1),j==-1?XXb.KTb(b).length:j);C=zGb((XXb.ETb(p,q,XXb.KTb(b).length),XXb.KTb(b).substr(p,q-p)));p=ZXb.Wq(b,q);q=(k=ZXb.Xq(b,p+1),k==-1?XXb.KTb(b).length:k);D=zGb((XXb.ETb(p,q,XXb.KTb(b).length),XXb.KTb(b).substr(p,q-p)));p=ZXb.Wq(b,q);q=(l=ZXb.Xq(b,p+1),l==-1?XXb.KTb(b).length:l);F=zGb((XXb.ETb(p,q,XXb.KTb(b).length),XXb.KTb(b).substr(p,q-p)));p=ZXb.Wq(b,q);q=(m=ZXb.Xq(b,p+1),m==-1?XXb.KTb(b).length:m);u=UXb.mGb((XXb.ETb(p,q,XXb.KTb(b).length),XXb.KTb(b).substr(p,q-p)),D_b,fZb);c=ZXb.Tj(a.j,C,-D,-F);c+1!=d&&(!a.b&&(a.b=new $Xb.nRb()),$Xb.fRb(a.b,new UXb.HGb(d),new UXb.HGb(c)));if(A!=null){ZXb.vm(a.j,c,6);ZXb.jm(a.j,c,A,e);}u!=0&&ZXb.km(a.j,c,u,false);if(UXb.CHb(s,'A')||UXb.CHb(s,'*')){ZXb.om(a.j,c,1,true);}else if(UXb.CHb(s,'Q')){t=Rjb(TXb.klb,xZb,6,1,15,1);t[0]=6;ZXb.jm(a.j,c,t,true);}else {ZXb.vm(a.j,c,ZXb.hn(s,67));}while((p=ZXb.Wq(b,q))!=-1){q=(g=ZXb.Xq(b,p+1),g==-1?XXb.KTb(b).length:g);v=(XXb.ETb(p,q,XXb.KTb(b).length),XXb.KTb(b).substr(p,q-p));o=UXb.GHb(v,THb(61));n=(XXb.ETb(0,o,XXb.KTb(v).length),XXb.KTb(v).substr(0,o));B=UXb.mGb((XXb.FTb(o+1,XXb.KTb(v).length+1),XXb.KTb(v).substr(o+1)),D_b,fZb);if(UXb.CHb(n,'CHG')){ZXb.cm(a.j,c,B);}else if(UXb.CHb(n,'RAD')){switch(B){case 1:ZXb.pm(a.j,c,16);break;case 2:ZXb.pm(a.j,c,32);break;case 3:ZXb.pm(a.j,c,48);}}else if(UXb.CHb(n,'CFG'));else if(UXb.CHb(n,'MASS')){ZXb.mm(a.j,c,B);}else if(UXb.CHb(n,'VAL')){ZXb.am(a.j,c,B==-1?0:B==0?-1:B);}else if(UXb.CHb(n,'HCOUNT')){switch(B){case 0:break;case-1:ZXb.om(a.j,c,1792,true);break;case 1:ZXb.om(a.j,c,128,true);break;case 2:ZXb.om(a.j,c,384,true);break;default:ZXb.om(a.j,c,896,true);}}else if(UXb.CHb(n,'SUBST')){if(B==-1){ZXb.om(a.j,c,w$b,true);}else if(B>0){w=0;for(f=0;f<a.j.r;f++){(ZXb.Vk(a.j,0,f)==c||ZXb.Vk(a.j,1,f)==c)&&++w;}B>w&&ZXb.om(a.j,c,RZb,true);}}else if(UXb.CHb(n,'RBCNT')){switch(B){case 3:case-1:ZXb.om(a.j,c,112,true);break;case 1:ZXb.om(a.j,c,8,true);break;case 2:ZXb.om(a.j,c,104,true);break;case 4:ZXb.om(a.j,c,56,true);}}}};ZXb.$q=function $q(a){var b,c,d,e,f,g,h,i;h=null;c=XXb.KTb(a).indexOf('[');d=XXb.KTb(a).indexOf(']',c);if(c>=0&&d>0){b=Rjb(TXb.klb,xZb,6,16,15,1);i=(XXb.ETb(c+1,d,XXb.KTb(a).length),XXb.KTb(a).substr(c+1,d-(c+1)));e=0;g=true;while(g&&e<16){c=XXb.KTb(i).indexOf(',');f=null;if(c==-1){f=i;g=false;}else {f=(XXb.ETb(0,c,XXb.KTb(i).length),XXb.KTb(i).substr(0,c));i=(XXb.FTb(c+1,XXb.KTb(i).length+1),XXb.KTb(i).substr(c+1));}b[e++]=ZXb.hn(f,1);}h=Rjb(TXb.klb,xZb,6,e,15,1);UXb.oIb(b,0,h,0,e);}return h;};ZXb._q=function _q(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;o=0;p=(i=ZXb.Xq(b,o+1),i==-1?XXb.KTb(b).length:i);f=UXb.mGb((XXb.ETb(o,p,XXb.KTb(b).length),XXb.KTb(b).substr(o,p-o)),D_b,fZb);o=ZXb.Wq(b,p);p=(j=ZXb.Xq(b,o+1),j==-1?XXb.KTb(b).length:j);g=UXb.mGb((XXb.ETb(o,p,XXb.KTb(b).length),XXb.KTb(b).substr(o,p-o)),D_b,fZb);o=ZXb.Wq(b,p);p=(k=ZXb.Xq(b,o+1),k==-1?XXb.KTb(b).length:k);c=ZXb.Tq(a,UXb.mGb((XXb.ETb(o,p,XXb.KTb(b).length),XXb.KTb(b).substr(o,p-o)),D_b,fZb));o=ZXb.Wq(b,p);p=(l=ZXb.Xq(b,o+1),l==-1?XXb.KTb(b).length:l);d=ZXb.Tq(a,UXb.mGb((XXb.ETb(o,p,XXb.KTb(b).length),XXb.KTb(b).substr(o,p-o)),D_b,fZb));r=0;s=0;while((o=ZXb.Wq(b,p))!=-1){p=(h=ZXb.Xq(b,o+1),h==-1?XXb.KTb(b).length:h);q=(XXb.ETb(o,p,XXb.KTb(b).length),XXb.KTb(b).substr(o,p-o));n=UXb.GHb(q,THb(61));m=(XXb.ETb(0,n,XXb.KTb(q).length),XXb.KTb(q).substr(0,n));t=UXb.mGb((XXb.FTb(n+1,XXb.KTb(q).length+1),XXb.KTb(q).substr(n+1)),D_b,fZb);if(UXb.CHb(m,'CFG')){switch(t){case 1:r=1;break;case 2:r=g==2?3:4;break;case 3:r=6;}}else UXb.CHb(m,'TOPO')?s=t:undefined;}e=ZXb.Pq(a,c,d,g,r,s);e+1!=f&&(!a.c&&(a.c=new $Xb.nRb()),$Xb.fRb(a.c,new UXb.HGb(f),new UXb.HGb(e)));};ZXb.ar=function ar(a,b){var c,d,e,f,g,h;h=ZXb.Yq(b);if(h!=null){g=ZXb.cr(b,h);if(UXb.CHb(XXb.KTb(b).substr(0,13),'MDLV30/STEABS')){if(UXb.CHb(h,C_b))for(f=0;f<g.length;f++)ZXb.hm(a.j,ZXb.Tq(a,g[f]),0,-1);else for(e=0;e<g.length;e++)ZXb.zm(a.j,ZXb.Uq(a,g[e]),0,-1);}else if(UXb.CHb(XXb.KTb(b).substr(0,13),'MDLV30/STERAC')){d=UXb.mGb(UXb.QHb(b,13,ZXb.Xq(b,13)),D_b,fZb);if(UXb.CHb(h,C_b))for(f=0;f<g.length;f++)ZXb.hm(a.j,ZXb.Tq(a,g[f]),1,d-1);else for(e=0;e<g.length;e++)ZXb.zm(a.j,ZXb.Uq(a,g[e]),1,d-1);}else if(UXb.CHb(XXb.KTb(b).substr(0,13),'MDLV30/STEREL')){d=UXb.mGb(UXb.QHb(b,13,ZXb.Xq(b,13)),D_b,fZb);if(UXb.CHb(h,C_b))for(f=0;f<g.length;f++)ZXb.hm(a.j,ZXb.Tq(a,g[f]),2,d-1);else for(e=0;e<g.length;e++)ZXb.zm(a.j,ZXb.Uq(a,g[e]),2,d-1);}else if(UXb.CHb(XXb.KTb(b).substr(0,13),'MDLV30/HILITE')){if(UXb.CHb(h,C_b)){for(e=0;e<g.length;e++)ZXb.dm(a.j,ZXb.Tq(a,g[e]),448);}else {for(e=0;e<g.length;e++){c=ZXb.Uq(a,g[e]);ZXb.dm(a.j,ZXb.Vk(a.j,0,c),448);ZXb.dm(a.j,ZXb.Vk(a.j,1,c),448);}}}}};ZXb.br=function br(a,b){var c,d,e;if(!a.j){if(UXb.CHb(XXb.KTb(b).substr(0,6),'COUNTS')){c=ZXb.Wq(b,ZXb.Xq(b,7));d=UXb.mGb(UXb.QHb(b,7,ZXb.Xq(b,7)),D_b,fZb);e=UXb.mGb(UXb.QHb(b,c,ZXb.Xq(b,c)),D_b,fZb);a.j=new ZXb.Gu(d,e);}}};ZXb.cr=function cr(a,b){var c,d,e,f,g,h;f=XXb.KTb(a).indexOf(b+'=(')+XXb.KTb(b).length+2;g=UXb.HHb(a,THb(41),f);e=ZXb.Xq(a,f);c=UXb.mGb((XXb.ETb(f,e,XXb.KTb(a).length),XXb.KTb(a).substr(f,e-f)),D_b,fZb);h=Rjb(TXb.klb,xZb,6,c,15,1);for(d=0;d<c;d++){f=ZXb.Wq(a,e);e=ZXb.Xq(a,f);(e==-1||e>g)&&(e=g);h[d]=UXb.mGb((XXb.ETb(f,e,XXb.KTb(a).length),XXb.KTb(a).substr(f,e-f)),D_b,fZb);}return h;};ZXb.dr=function dr(a){var b,c,d,e,f,g,h,i,j;i=Rjb(TXb.klb,xZb,6,a.j.q,15,1);for(d=0;d<a.j.r;d++)if(ZXb.el(a.j,d)==64)for(g=0;g<2;g++)i[ZXb.Vk(a.j,g,d)]=1;for(e=0;e<a.j.r;e++){j=ZXb.bl(a.j,e);for(f=0;f<2;f++)i[ZXb.Vk(a.j,f,e)]+=j;}for(c=0;c<a.j.r;c++){if(ZXb.bl(a.j,c)==1){for(f=0;f<2;f++){h=ZXb.Vk(a.j,1-f,c);if(ZXb.Fl(a.j,h)){b=ZXb.Vk(a.j,f,c);if(ZXb.Cl(a.j,b)&&i[b]>ZXb.jl(a.j,b)){ZXb.Fm(a.j,c,32);continue;}}}}}};ZXb.er=function er(a){var b,c;if(XXb.KTb(a).indexOf('[')>=0){b=XXb.KTb(a).indexOf(' NOT[');c=XXb.KTb(a).indexOf(']',b);if(b>=0&&c>0){return -(c+1);}else {b=XXb.KTb(a).indexOf(' [');c=XXb.KTb(a).indexOf(']',b);if(b>=0&&c>0){return c+1;}}b=XXb.KTb(a).indexOf(" 'NOT[");c=XXb.KTb(a).indexOf("]'",b);if(b>=0&&c>0){return -(c+2);}else {b=XXb.KTb(a).indexOf(" '[");c=XXb.KTb(a).indexOf("]'",b);if(b>=0&&c>0){return c+2;}}UXb.nIb();}return 0;};ZXb.fr=function fr(a,b,c){a.j=b;return ZXb.hr(a,c);};ZXb.gr=function gr(a){return XXb.KTb(a).length==0?0:UXb.mGb(a,D_b,fZb);};ZXb.hr=function hr(b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X;T=null;try{b.f=null;if(b.j){ZXb.hk(b.j);ZXb.Hm(b.j,false);}D=v=QYb.NEb(c);if(null==D){return false;}if(null==(v=QYb.NEb(c))){return false;}if(null==(v=QYb.NEb(c))){return false;}b.k=XXb.KTb(v).indexOf("From CSD data. Using bond type 'Any'")!=-1;b.e=XXb.KTb(v).indexOf('From CSD data.')!=-1;if(null==(v=QYb.NEb(c))){return false;}b.g=false;b.d=b.a;try{F=UXb.mGb(UXb.RHb((XXb.ETb(0,3,XXb.KTb(v).length),XXb.KTb(v).substr(0,3))),D_b,fZb);G=UXb.mGb(UXb.RHb((XXb.ETb(3,6,XXb.KTb(v).length),XXb.KTb(v).substr(3,3))),D_b,fZb);H=ZXb.gr(UXb.RHb((XXb.ETb(6,9,XXb.KTb(v).length),XXb.KTb(v).substr(6,3))));b.d=b.d|1==ZXb.gr(UXb.RHb((XXb.ETb(12,15,XXb.KTb(v).length),XXb.KTb(v).substr(12,3))));b.g=XXb.KTb(v).length>=39&&UXb.CHb(XXb.KTb(v).substr(34,XXb.KTb('V3000').length),'V3000');}catch(a){a=Fwb(a);if(Ykb(a,19)){return false;}else throw Gwb(a);}if(b.g){K=ZXb.ir(b,c);ZXb.Nm(b.j,D);return K;}!b.j&&(b.j=new ZXb.Gu(F,G));ZXb.Nm(b.j,D);b.d||(b.j.L=true);if(0==F){while(v!=null&&!(UXb.CHb(v,E_b)||UXb.CHb(v,F_b)||UXb.CHb((XXb.FTb(1,XXb.KTb(v).length+1),XXb.KTb(v).substr(1)),'$'))){v=QYb.NEb(c);}return true;}for(q=0;q<F;q++){if(null==(v=QYb.NEb(c))){return false;}V=zGb(UXb.RHb((XXb.ETb(0,10,XXb.KTb(v).length),XXb.KTb(v).substr(0,10))));W=zGb(UXb.RHb((XXb.ETb(10,20,XXb.KTb(v).length),XXb.KTb(v).substr(10,10))));X=zGb(UXb.RHb((XXb.ETb(20,30,XXb.KTb(v).length),XXb.KTb(v).substr(20,10))));e=ZXb.Tj(b.j,V,-W,-X);u=UXb.RHb((XXb.ETb(31,34,XXb.KTb(v).length),XXb.KTb(v).substr(31,3)));if(UXb.CHb(u,'A')||UXb.CHb(u,'*')){ZXb.om(b.j,e,1,true);}else if(UXb.CHb(u,'Q')){w=Rjb(TXb.klb,xZb,6,1,15,1);w[0]=6;ZXb.jm(b.j,e,w,true);}else {h=ZXb.hn(u,67);ZXb.vm(b.j,e,h);}C=ZXb.gr(UXb.RHb((XXb.ETb(34,36,XXb.KTb(v).length),XXb.KTb(v).substr(34,2))));C!=0&&ZXb.mm(b.j,e,(ZXb.Sj(),ZXb.Qj)[ZXb.Qk(b.j,e)]+C);m=ZXb.gr(UXb.RHb((XXb.ETb(36,39,XXb.KTb(v).length),XXb.KTb(v).substr(36,3))));m!=0&&(m==4?ZXb.pm(b.j,e,32):ZXb.cm(b.j,e,4-m));A=XXb.KTb(v).length<63?0:ZXb.gr(UXb.RHb((XXb.ETb(60,63,XXb.KTb(v).length),XXb.KTb(v).substr(60,3))));ZXb.km(b.j,e,A,false);o=XXb.KTb(v).length<45?0:ZXb.gr(UXb.RHb((XXb.ETb(42,45,XXb.KTb(v).length),XXb.KTb(v).substr(42,3))));switch(o){case 0:break;case 1:ZXb.om(b.j,e,768,true);break;case 2:ZXb.om(b.j,e,128,true);break;case 3:ZXb.om(b.j,e,384,true);break;default:ZXb.om(b.j,e,896,true);}XXb.KTb(v).length>=48&&(XXb.FTb(47,XXb.KTb(v).length),XXb.KTb(v).charCodeAt(47)==49)&&ZXb.om(b.j,e,v$b,true);S=XXb.KTb(v).length<51?0:ZXb.gr(UXb.RHb((XXb.ETb(48,51,XXb.KTb(v).length),XXb.KTb(v).substr(48,3))));if(S!=0){T==null&&(T=Rjb(TXb.klb,xZb,6,F,15,1));T[e]=S;}}for(r=0;r<G;r++){if(null==(v=QYb.NEb(c))){return false;}f=UXb.mGb(UXb.RHb((XXb.ETb(0,3,XXb.KTb(v).length),XXb.KTb(v).substr(0,3))),D_b,fZb)-1;g=UXb.mGb(UXb.RHb((XXb.ETb(3,6,XXb.KTb(v).length),XXb.KTb(v).substr(3,3))),D_b,fZb)-1;k=UXb.mGb(UXb.RHb((XXb.ETb(6,9,XXb.KTb(v).length),XXb.KTb(v).substr(6,3))),D_b,fZb);N=XXb.KTb(v).length<12?0:ZXb.gr(UXb.RHb((XXb.ETb(9,12,XXb.KTb(v).length),XXb.KTb(v).substr(9,3))));R=XXb.KTb(v).length<18?0:ZXb.gr(UXb.RHb((XXb.ETb(15,18,XXb.KTb(v).length),XXb.KTb(v).substr(15,3))));k==8&&(b.k||ZXb.Fl(b.j,f)||ZXb.Fl(b.j,g))&&(k=9);ZXb.Pq(b,f,g,k,N,R);}for(p=0;p<H;p++){if(null==(v=QYb.NEb(c))){return false;}}if(null==(v=QYb.NEb(c))){(b.i&1)!=0&&(b.f=ZXb.co(b.j));ZXb.Vq(b,T);b.d||ZXb.nu(b.j,15);return true;}while(v!=null&&!(UXb.CHb(v,E_b)||UXb.CHb(v,F_b))){if(UXb.CHb(XXb.KTb(v).substr(0,6),'M  CHG')){s=UXb.mGb(UXb.RHb((XXb.ETb(6,9,XXb.KTb(v).length),XXb.KTb(v).substr(6,3))),D_b,fZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=UXb.mGb(UXb.RHb((XXb.ETb(d,d+3,XXb.KTb(v).length),XXb.KTb(v).substr(d,d+3-d))),D_b,fZb)-1;l=UXb.mGb(UXb.RHb((XXb.ETb(U,U+3,XXb.KTb(v).length),XXb.KTb(v).substr(U,U+3-U))),D_b,fZb);ZXb.cm(b.j,e,l);}}}if(UXb.CHb(XXb.KTb(v).substr(0,6),'M  ISO')){s=UXb.mGb(UXb.RHb((XXb.ETb(6,9,XXb.KTb(v).length),XXb.KTb(v).substr(6,3))),D_b,fZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=UXb.mGb(UXb.RHb((XXb.ETb(d,d+3,XXb.KTb(v).length),XXb.KTb(v).substr(d,d+3-d))),D_b,fZb)-1;B=UXb.mGb(UXb.RHb((XXb.ETb(U,U+3,XXb.KTb(v).length),XXb.KTb(v).substr(U,U+3-U))),D_b,fZb);ZXb.mm(b.j,e,B);}}}if(UXb.CHb(XXb.KTb(v).substr(0,6),'M  RAD')){s=UXb.mGb(UXb.RHb((XXb.ETb(6,9,XXb.KTb(v).length),XXb.KTb(v).substr(6,3))),D_b,fZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=UXb.mGb(UXb.RHb((XXb.ETb(d,d+3,XXb.KTb(v).length),XXb.KTb(v).substr(d,d+3-d))),D_b,fZb)-1;J=UXb.mGb(UXb.RHb((XXb.ETb(U,U+3,XXb.KTb(v).length),XXb.KTb(v).substr(U,U+3-U))),D_b,fZb);switch(J){case 1:ZXb.pm(b.j,e,16);break;case 2:ZXb.pm(b.j,e,32);break;case 3:ZXb.pm(b.j,e,48);}}}}if(UXb.CHb(XXb.KTb(v).substr(0,6),'M  RBC')||UXb.CHb(XXb.KTb(v).substr(0,6),'M  RBD')){s=UXb.mGb(UXb.RHb((XXb.ETb(6,9,XXb.KTb(v).length),XXb.KTb(v).substr(6,3))),D_b,fZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=UXb.mGb(UXb.RHb((XXb.ETb(d,d+3,XXb.KTb(v).length),XXb.KTb(v).substr(d,d+3-d))),D_b,fZb)-1;L=UXb.mGb(UXb.RHb((XXb.ETb(U,U+3,XXb.KTb(v).length),XXb.KTb(v).substr(U,U+3-U))),D_b,fZb);switch(L){case 3:case-1:ZXb.om(b.j,e,112,true);break;case 1:ZXb.om(b.j,e,8,true);break;case 2:ZXb.om(b.j,e,104,true);break;case 4:ZXb.om(b.j,e,56,true);}}}}if(UXb.CHb(XXb.KTb(v).substr(0,6),'M  ALS')){e=UXb.mGb(UXb.RHb((XXb.ETb(7,10,XXb.KTb(v).length),XXb.KTb(v).substr(7,3))),D_b,fZb)-1;if(e>=0){I=UXb.mGb(UXb.RHb((XXb.ETb(10,13,XXb.KTb(v).length),XXb.KTb(v).substr(10,3))),D_b,fZb);i=(XXb.FTb(14,XXb.KTb(v).length),XXb.KTb(v).charCodeAt(14)==84);S=Rjb(TXb.klb,xZb,6,I,15,1);d=16;for(t=0;t<I;++t,d+=4){Q=UXb.RHb((XXb.ETb(d,d+4,XXb.KTb(v).length),XXb.KTb(v).substr(d,d+4-d)));S[t]=ZXb.hn(Q,1);}ZXb.vm(b.j,e,6);ZXb.jm(b.j,e,S,i);}}if(UXb.CHb(XXb.KTb(v).substr(0,6),'M  SUB')){s=UXb.mGb(UXb.RHb((XXb.ETb(6,9,XXb.KTb(v).length),XXb.KTb(v).substr(6,3))),D_b,fZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=UXb.mGb(UXb.RHb((XXb.ETb(d,d+3,XXb.KTb(v).length),XXb.KTb(v).substr(d,d+3-d))),D_b,fZb)-1;O=UXb.mGb(UXb.RHb((XXb.ETb(U,U+3,XXb.KTb(v).length),XXb.KTb(v).substr(U,U+3-U))),D_b,fZb);if(O==-2){ZXb.om(b.j,e,w$b,true);}else if(O>0){P=0;for(j=0;j<b.j.r;j++){(ZXb.Vk(b.j,0,j)==e||ZXb.Vk(b.j,1,j)==e)&&++P;}O>P&&ZXb.om(b.j,e,RZb,true);}}}}if(UXb.CHb(XXb.KTb(v).substr(0,6),'M  RGP')){s=UXb.mGb(UXb.RHb((XXb.ETb(6,9,XXb.KTb(v).length),XXb.KTb(v).substr(6,3))),D_b,fZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=UXb.mGb(UXb.RHb((XXb.ETb(d,d+3,XXb.KTb(v).length),XXb.KTb(v).substr(d,d+3-d))),D_b,fZb)-1;M=UXb.mGb(UXb.RHb((XXb.ETb(U,U+3,XXb.KTb(v).length),XXb.KTb(v).substr(U,U+3-U))),D_b,fZb);M>=1&&M<=20&&ZXb.vm(b.j,e,ZXb.hn('R'+M,2));}}}v=QYb.NEb(c);}}catch(a){a=Fwb(a);if(Ykb(a,19)){n=a;UXb.Jz(n,(UXb.nIb(),UXb.mIb),'');return false;}else throw Gwb(a);}if(b.e){ZXb.dr(b);ZXb.Qq(b);}(b.i&1)!=0&&(b.f=ZXb.co(b.j));ZXb.Vq(b,T);ZXb.nu(b.j,15);return true;};ZXb.ir=function ir(a,b){var c,d,e,f,g;!!a.b&&$Xb.$Qb(a.b);!!a.c&&$Xb.$Qb(a.c);e=0;d=QYb.NEb(b);while(d!=null&&UXb.CHb(XXb.KTb(d).substr(0,7),G_b)){d=UXb.RHb((XXb.FTb(7,XXb.KTb(d).length+1),XXb.KTb(d).substr(7)));while(g=XXb.KTb('-').length,UXb.CHb(XXb.KTb(d).substr(XXb.KTb(d).length-g,g),'-')){c=QYb.NEb(b);if(!UXb.CHb(XXb.KTb(c).substr(0,7),G_b)){return false;}d=UXb.RHb(UXb.zHb(UXb.QHb(d,0,XXb.KTb(d).length-1),(XXb.FTb(7,XXb.KTb(c).length+1),XXb.KTb(c).substr(7))));}if(UXb.CHb(XXb.KTb(d).substr(0,5),'BEGIN')){f=UXb.RHb((XXb.FTb(6,XXb.KTb(d).length+1),XXb.KTb(d).substr(6)));if(UXb.CHb(XXb.KTb(f).substr(0,4),'CTAB')){e=1;}else if(UXb.CHb(XXb.KTb(f).substr(0,4),'ATOM')){e=2;}else if(UXb.CHb(XXb.KTb(f).substr(0,4),'BOND')){e=3;}else if(UXb.CHb(XXb.KTb(f).substr(0,10),'COLLECTION')){e=4;}else {return false;}}else if(UXb.CHb(XXb.KTb(d).substr(0,3),'END')){e=0;}else if(e==1){ZXb.br(a,d);}else if(e==2){ZXb.Zq(a,d);}else if(e==3){ZXb._q(a,d);}else if(e==4){ZXb.ar(a,d);}else {return false;}d=QYb.NEb(b);}while(d!=null&&!(UXb.CHb(XXb.KTb(d).substr(0,6),E_b)||UXb.CHb(d,F_b))){d=QYb.NEb(b);}return true;};ZXb.jr=function jr(){this.i=0;};ZXb.kr=function kr(){this.i=1;};wxb(111,1,{},ZXb.jr,ZXb.kr);_.a=false;_.d=false;_.e=false;_.g=false;_.i=0;_.k=false;TXb.Rlb=UFb(111);ZXb.lr=function lr(a){};ZXb.mr=function mr(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J;UXb.fIb(a.a,'M  V30 BEGIN CTAB\n');UXb.fIb(a.a,H_b+b.q+' '+b.r+' 0 0 0'+$Yb);UXb.fIb(a.a,'M  V30 BEGIN ATOM\n');for(i=0;i<b.q;i++){UXb.fIb(a.a,G_b+(i+1));if((b.v==null?null:b.v[i])!=null){k=b.v==null?null:b.v[i];u=bxb(Iwb(b.B[i],1),0);UXb.fIb(a.a,u?' NOT[':' [');for(s=0;s<k.length;s++){s>0&&UXb.fIb(a.a,',');t=(ZXb.Sj(),ZXb.Mj)[k[s]];switch(XXb.KTb(t).length){case 2:case 3:case 1:UXb.fIb(a.a,t);break;default:UXb.fIb(a.a,'?');}}UXb.fIb(a.a,']');}else bxb(Iwb(b.B[i],1),0)?UXb.fIb(a.a,' A'):b.C[i]>=129&&b.C[i]<=144||b.C[i]==154?UXb.fIb(a.a,' R#'):UXb.fIb(a.a,' '+(ZXb.Sj(),ZXb.Mj)[b.C[i]]);if(c){UXb.fIb(a.a,' '+flb(pZb*a.b*b.J[i].a)/pZb);UXb.fIb(a.a,' '+flb(pZb*a.b*-b.J[i].b)/pZb);UXb.fIb(a.a,' '+flb(pZb*a.b*-b.J[i].c)/pZb);}else {UXb.fIb(a.a,' 0 0 0');}UXb.fIb(a.a,' '+$wnd.Math.abs(b.w[i]));b.s[i]!=0&&UXb.fIb(a.a,' CHG='+b.s[i]);if((b.u[i]&48)!=0){UXb.fIb(a.a,' RAD=');switch(b.u[i]&48){case 16:UXb.fIb(a.a,'1');break;case 32:UXb.fIb(a.a,'2');break;case 48:UXb.fIb(a.a,'3');}}if((b.u[i]&3)==1||(b.u[i]&3)==2){UXb.fIb(a.a,' CFG=');(b.u[i]&3)==1?UXb.fIb(a.a,'1'):UXb.fIb(a.a,'2');}b.A[i]!=0&&UXb.fIb(a.a,' MASS='+b.A[i]);J=((b.u[i]&f_b)>>>27)-1;J!=-1&&UXb.fIb(a.a,' VAL='+(J==0?'-1':UXb.TGb(J)));l=b.C[i];(l>=129&&l<=144||l==154)&&UXb.fIb(a.a,' RGROUPS=(1 '+(l==154?0:l>=142?l-141:l-125)+')');r=Iwb(VZb,b.B[i]);Nwb(r,384)==0?UXb.fIb(a.a,' HCOUNT=2'):Nwb(r,128)==0?UXb.fIb(a.a,' HCOUNT=1'):Nwb(r,1792)==0?UXb.fIb(a.a,' HCOUNT=-1'):Nwb(r,1664)==0&&UXb.fIb(a.a,' HCOUNT=1');G=Iwb(b.B[i],6144);Nwb(G,0)!=0&&(bxb(Iwb(G,RZb),0)?UXb.fIb(a.a,' SUBST='+(b.e[i]+1)):UXb.fIb(a.a,' SUBST=-1'));C=Iwb(b.B[i],120);Nwb(C,0)!=0&&(Nwb(C,112)==0?UXb.fIb(a.a,' RBCNT=-1'):Nwb(C,8)==0?UXb.fIb(a.a,' RBCNT=2'):Nwb(C,104)==0?UXb.fIb(a.a,' RBCNT=2'):Nwb(C,88)==0?UXb.fIb(a.a,' RBCNT=3'):Nwb(C,56)==0&&UXb.fIb(a.a,' RBCNT=4'));UXb.fIb(a.a,$Yb);}UXb.fIb(a.a,'M  V30 END ATOM\n');UXb.fIb(a.a,'M  V30 BEGIN BOND\n');for(n=0;n<b.r;n++){UXb.fIb(a.a,G_b+(n+1));switch(b.H[n]){case 1:A=1;F=0;break;case 2:A=2;F=0;break;case 4:A=3;F=0;break;case 129:A=1;F=3;break;case 257:A=1;F=1;break;case 386:A=2;F=2;break;case 64:A=4;F=0;break;case 32:A=9;F=0;break;default:A=1;F=0;}p=b.G[n]&31;p!=0&&(p==8?A=4:p==3?A=5:p==9?A=6:p==10?A=7:A=8);UXb.fIb(a.a,' '+A+' '+(b.D[0][n]+1)+' '+(b.D[1][n]+1));F!=0&&UXb.fIb(a.a,' CFG='+F);D=b.G[n]&384;H=D==0?0:D==256?1:2;H!=0&&UXb.fIb(a.a,' TOPO='+H);UXb.fIb(a.a,$Yb);}UXb.fIb(a.a,'M  V30 END BOND\n');B=false;d=0;v=Rjb(TXb.klb,xZb,6,32,15,1);f=Rjb(TXb.klb,xZb,6,32,15,1);for(j=0;j<b.f;j++){if((b.u[j]&3)==1||(b.u[j]&3)==2){B=true;I=(b.u[j]&D$b)>>18;I==1?++f[(b.u[j]&D$b)>>18!=1&&(b.u[j]&D$b)>>18!=2?-1:(b.u[j]&g_b)>>20]:I==2?++v[(b.u[j]&D$b)>>18!=1&&(b.u[j]&D$b)>>18!=2?-1:(b.u[j]&g_b)>>20]:++d;}}e=0;w=Rjb(TXb.klb,xZb,6,32,15,1);g=Rjb(TXb.klb,xZb,6,32,15,1);for(o=0;o<b.g;o++){if(ZXb.bl(b,o)!=2&&((b.F[o]&3)==1||(b.F[o]&3)==2)){B=true;I=(b.F[o]&768)>>8;I==1?++g[(b.F[o]&768)>>8!=1&&(b.F[o]&768)>>8!=2?-1:(b.F[o]&h_b)>>10]:I==2?++w[(b.F[o]&768)>>8!=1&&(b.F[o]&768)>>8!=2?-1:(b.F[o]&h_b)>>10]:++e;}}if(B){UXb.fIb(a.a,'M  V30 BEGIN COLLECTION\n');if(d!=0){UXb.fIb(a.a,'M  V30 MDLV30/STEABS ATOMS=('+d);for(h=0;h<b.f;h++){((b.u[h]&3)==1||(b.u[h]&3)==2)&&(b.u[h]&D$b)>>18==0&&UXb.fIb(a.a,' '+(h+1));}UXb.fIb(a.a,I_b);}if(e!=0){UXb.fIb(a.a,'M  V30 MDLV30/STEABS BONDS=('+e);for(m=0;m<b.g;m++){ZXb.bl(b,m)!=2&&((b.F[m]&3)==1||(b.F[m]&3)==2)&&(b.F[m]&768)>>8==0&&UXb.fIb(a.a,' '+(m+1));}UXb.fIb(a.a,I_b);}for(q=0;q<32;q++){if(v[q]!=0){UXb.fIb(a.a,J_b+(q+1)+' ATOMS=('+v[q]);for(h=0;h<b.f;h++){((b.u[h]&3)==1||(b.u[h]&3)==2)&&(b.u[h]&D$b)>>18==2&&((b.u[h]&D$b)>>18!=1&&(b.u[h]&D$b)>>18!=2?-1:(b.u[h]&g_b)>>20)==q&&UXb.fIb(a.a,' '+(h+1));}UXb.fIb(a.a,I_b);}if(f[q]!=0){UXb.fIb(a.a,K_b+(q+1)+' ATOMS=('+f[q]);for(h=0;h<b.f;h++){((b.u[h]&3)==1||(b.u[h]&3)==2)&&(b.u[h]&D$b)>>18==1&&((b.u[h]&D$b)>>18!=1&&(b.u[h]&D$b)>>18!=2?-1:(b.u[h]&g_b)>>20)==q&&UXb.fIb(a.a,' '+(h+1));}UXb.fIb(a.a,I_b);}if(w[q]!=0){UXb.fIb(a.a,J_b+(q+1)+' BONDS=('+w[q]);for(m=0;m<b.g;m++){ZXb.bl(b,m)!=2&&((b.F[m]&3)==1||(b.F[m]&3)==2)&&(b.F[m]&768)>>8==2&&((b.F[m]&768)>>8!=1&&(b.F[m]&768)>>8!=2?-1:(b.F[m]&h_b)>>10)==q&&UXb.fIb(a.a,' '+(m+1));}UXb.fIb(a.a,I_b);}if(g[q]!=0){UXb.fIb(a.a,K_b+(q+1)+' BONDS=('+g[q]);for(m=0;m<b.g;m++){ZXb.bl(b,m)!=2&&((b.F[m]&3)==1||(b.F[m]&3)==2)&&(b.F[m]&768)>>8==1&&((b.F[m]&768)>>8!=1&&(b.F[m]&768)>>8!=2?-1:(b.F[m]&h_b)>>10)==q&&UXb.fIb(a.a,' '+(m+1));}UXb.fIb(a.a,I_b);}}UXb.fIb(a.a,'M  V30 END COLLECTION\n');}UXb.fIb(a.a,'M  V30 END CTAB\n');};ZXb.nr=function nr(){ZXb.lr(this);this.a=new UXb.jIb();};ZXb.or=function or(a){ZXb.pr.call(this,a);};ZXb.pr=function pr(a){ZXb.qr.call(this,a,new UXb.jIb());};ZXb.qr=function qr(a,b){var c,d;ZXb.lr(this);ZXb.nu(a,15);this.a=b;d=a.P!=null?a.P:'';UXb.fIb(this.a,d+$Yb);UXb.fIb(this.a,'Actelion Java MolfileCreator 2.0\n\n');UXb.fIb(this.a,'  0  0  0  0  0  0              0 V3000\n');this.b=1;c=ZXb.sr(a);c&&(this.b=ZXb.rr(a));ZXb.mr(this,a,c);UXb.fIb(this.a,B_b);};ZXb.rr=function rr(a){var b,c,d,e,f,g,h,i,j;j=1;d=ZXb.Sk(a,a.q,a.r,(ZXb.Sj(),ZXb.Rj));if(d!=0){(d<1||d>3)&&(j=1.5/d);}else {i=L_b;for(b=1;b<a.q;b++){for(c=0;c<b;c++){f=a.J[c].a-a.J[b].a;g=a.J[c].b-a.J[b].b;h=a.J[c].c-a.J[b].c;e=f*f+g*g+h*h;i>e&&(i=e);}}j=3/$wnd.Math.max(0.75,i);}return j;};ZXb.sr=function sr(a){var b;if(a.q==1)return true;for(b=1;b<a.q;b++){if(a.J[b].a!=a.J[0].a||a.J[b].b!=a.J[0].b||a.J[b].c!=a.J[0].c){return true;}}return false;};ZXb.tr=function tr(a,b){var c;c=new ZXb.nr();c.b=b;ZXb.nu(a,15);ZXb.mr(c,a,true);return c.a.a;};wxb(136,1,{},ZXb.nr,ZXb.or);_.b=1;TXb.Slb=UFb(136);ZXb.wr=function wr(){ZXb.wr=yxb;ZXb.ur=Zjb(Ljb(TXb.Nub,2),_Yb,14,0,[Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Acyl','gCaHA`AIf`@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Alloc','gNph@l@ILzuR@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Allyl','Al']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Benzyl;Bn','daD@`F@DjUZxHH@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Boc','daxD`@S@AIgijj@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['BOM;BzOM','deTH`@H@Re[TYj`@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Bs','dmtDpAdLS`aPAIe]jf`@e`@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Bt','dew@`@aJ@DiY]paej`@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Btm','did@P@BJ@Die_ahH@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Butyl;nButyl','gJPHB@IRuP@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Benzoyl;Bz','didH`@p@RYm^Eh@@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Bzh','dg|@`N@LdbRbtJUB]aAP@@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Cbz','dmtD`@S@AIgYVUZh@@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['cButyl','gKPHL@IThuT@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['cHeptyl','daD@`L@DjWVzjj`@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['cHexyl','gOpHL@IToWUU@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['cOctyl','did@`L@DjWWajjj@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['cPentyl','gFpHL@ITimUP@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['cPropyl','gBPHL@Qxjh@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['COOH','gC`h@l@ILt@@ !Bb@K~@Hc}']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['DEAE','daz@`@x@RiUjj`@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['DEIPS','diD@P@\\B@DjfVjj`@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['DMIPS','gNpD@xD@RjZjh@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['DMPM','dcLD`@kPCIEMDdcttDDT@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['DMPS','deT@P@\\B@LddTjPsU@@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['DMTr','fak@b@@Mt@ISZ{SMjo{NQKfm@AU@@@E@@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['DNP','dkmB`hdDt~@HeNfS{HihheCAUhBHX@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['DNS;Dan','fhi`a@KPP@HH@YIHYheEhYKQgKP@@QP@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['DPIPS','fdyAA@H@\\B@FRRIQSQIHzp_Qjh@h@@@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['DPTBS','fleAA@H@\\B@FRRIQSRIIWNbEMU@EP@@@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['DTBMS','dmT@P@\\B@Djffjjjh@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Ethyl','eMBD@ch@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Fmoc','fde@b@@Hp@IL{LrjxeVCzKUT@@@P@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['iAmyl','gGPHJ@YIDZj@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['iButyl','gJPHB@ITuP@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Im','gFtHAj@IRnKSP@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['iPropyl','gC`HL@Qz`@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['MDIPS','diD@P@\\B@DjfZjj`@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['MDPS','foA@A@@NA@CIIEEBdeeVLzj@@@@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Methyl','eFBH@c@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['MEM','gNphAR@IRoUT@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Mes','deT@`J@DjY{[`bB`@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['MMTr','ffcAB@@Z@Dim]ifuWYrI\\uh@Jh@@@@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['MOM','gCaHA`AJZ`@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['MPM;PMB','deTH`@d@Rfuunh@J@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Ms','gJPdH`DD@cuh@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['MTM','gC`D@DX@Rfh@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['mTolyl','daD@`N@DjWjXHB@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['N3','gClHaE`@RnReX@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['nAmyl;Amyl','gGPHJ@IRmU@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['neoAm','gGPHJ@IUMU@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['NO2,Nitro','gChhhE`BRnRYh@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Np','deVDaHAI@HeNR[e_aZ@B@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['nPropyl;Propyl','gC`HL@IST@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['oTolyl','daD@`J@DjYvxH`@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Phenyl','gOpHL@IToVD@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Pht','dcLL`@RU@Dfyed]ZBA`@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Piv;Pv','gNqHA`AIffj`@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['PMBM','dcLD`@T`AJUm]FZh@J@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['PNB','dcNLaHAEt@bTyInUvxV`@f@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Poc','didD`@S@AIgexVjj`@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['PPi','diDFsHSB[`|J|A@Lxn{lddqdZih@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['pTolyl','daD@`N@DjWzXHB@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['sAmyl','gGPHL@YIDZj@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['sButyl','gJPHL@ITuP@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['SEM','diDHPFApD@rRQUJjj`@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['SES','dedDpHP@``AgCIICeHmUT@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['SO3H','gJQdHl@``D^m@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['tAmyl','gGPHB@IUMU@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['TBDMS;TBS','dax@P@\\B@Djfjjh@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['TBDPS','fdy@A@@NA@CIIEEEIde]XOhuPAT@@@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['TBMPS','dg\\HPHApH@rRQJJPjg]UAT@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['tButyl,tBu','gJPHB@Q}T@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['TDS','ded@P@\\B@LddTeeUUP@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Tf','daxDhHP@``BiAiCiCIICHmU@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['TFA','gNqBJIARFdF@YEHYUL@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Thexyl','gNpHB@IUMUT@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['THF','gFqH@PAJYujj@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['THP','gOqH@PAJYZzjh@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['TIPS','dmT@P@\\B@DjfYjjjh@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['TMS','gJPD@xD@czh@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Tosyl;Ts','dmtDPHP@``CIICLeaeZ@B@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Troc','diDDHJxHaHcH`PCHiBeJjf@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Trt','fbm@B@A@FRQIRKQPiIZdoIcdHJ`@@@@@@']),Zjb(Ljb(TXb.Nub,1),mZb,2,6,['Xyl','did@`J@DjYynBHH@@'])]);};ZXb.xr=function xr(){ZXb.wr();var a,b,c,d,e,f,g,h,i;ZXb.vr=new $Xb.nRb();for(g=ZXb.ur,h=0,i=g.length;h<i;++h){f=g[h];e=UXb.NHb(f[0],';');for(b=e,c=0,d=b.length;c<d;++c){a=b[c];$Xb.fRb(ZXb.vr,UXb.LHb(XXb.KTb(a).toLowerCase(),'-'),f[1]);}}};ZXb.yr=function yr(a){ZXb.wr();var b,c,d,e;!ZXb.vr&&ZXb.xr();a=UXb.LHb(XXb.KTb(a).toLowerCase(),'-');for(e=(c=new $Xb.xRb(new $Xb.CRb(new $Xb.yNb(ZXb.vr).a).b),new $Xb.GNb(c));$Xb.gMb(e.a.a);){d=(b=$Xb.vRb(e.a),b.Wd());if(UXb.CHb(XXb.KTb(d).substr(0,XXb.KTb(a).length),a))return true;}return false;};ZXb.vr=null;ZXb.zr=function zr(a){var b,c;c=0;for(b=0;b<a.a.q;b++)(ZXb.Qk(a.a,b)==7||ZXb.Qk(a.a,b)==8)&&++c;return c;};ZXb.Ar=function Ar(a){var b,c;c=0;for(b=0;b<a.a.q;b++)(ZXb.Qk(a.a,b)==7||ZXb.Qk(a.a,b)==8)&&ZXb.Fn(a.a,b)>0&&++c;return c;};ZXb.Br=function Br(b){var c;try{return hYb.cE((new hYb.eE(),b.a));}catch(a){a=Fwb(a);if(Ykb(a,19)){c=a;UXb.Jz(c,(UXb.nIb(),UXb.mIb),'');return -999;}else throw Gwb(a);}};ZXb.Cr=function Cr(a){this.a=a;ZXb.$o(a);};wxb(341,1,{});TXb.Tlb=UFb(341);ZXb.Dr=function Dr(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;k=a.g.M;l=0;for(f=0;f<c;f++){if(k>b[f]){k=b[f];l=f;}}p=Rjb(TXb.klb,xZb,6,c,15,1);j=l>0?l-1:c-1;m=l<c-1?l+1:0;h=b[j]<b[m];for(g=0;g<c;g++){p[g]=b[l];h?--l<0&&(l=c-1):++l==c&&(l=0);}for(e=0;e<a.i.a.length;e++){o=$Xb.Xi(a.i,e);if(o.length!=c)continue;d=true;for(i=0;i<c;i++){if(o[i]!=p[i]){d=false;break;}}if(d)return;}$Xb.Si(a.i,p);n=ZXb.Pr(a,p);$Xb.Si(a.j,n);ZXb.es(a,p,n);};ZXb.Er=function Er(a,b,c){var d,e,f,g,h,i,j;i=Rjb(TXb.klb,xZb,6,a.f,15,1);g=Rjb(TXb.klb,xZb,6,a.f,15,1);j=Rjb(TXb.Bwb,JZb,6,a.g.f,16,1);d=ZXb.Vk(a.g,0,b);e=ZXb.Vk(a.g,1,b);i[0]=d;i[1]=e;g[1]=-1;j[e]=true;h=1;while(h>=1){++g[h];if(g[h]==ZXb.Sn(a.g,i[h])){j[i[h]]=false;--h;continue;}f=ZXb.Rn(a.g,i[h],g[h]);if(j[f]||c[f])continue;if(f==d&&h>1){ZXb.Dr(a,i,h+1);if(a.i.a.length>=WZb)return;continue;}if(h+1<a.f){++h;i[h]=f;j[f]=true;g[h]=-1;}}};ZXb.Fr=function Fr(a,b,c,d,e,f,g,h){var i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D;A=$Xb.Xi(a.i,b);for(l=A,m=0,n=l.length;m<n;++m){k=l[m];if(!ZXb.as(a,k))return true;}B=$Xb.Xi(a.j,b);C=B.length;o=0;j=0;D=false;for(v=0;v<C;v++){o<<=1;j<<=1;if(ZXb.cs(a,B[v])){o|=1;}else if(h&&ZXb._r(a,B[v])){o|=1;j|=1;}else {i=c[b][v];if(i!=-1){if(d[i]){if(e[i]){o|=1;f[i]||(j|=1);}}else {D=true;}}}}u=false;switch(C){case 3:p=Zjb(Ljb(TXb.klb,1),xZb,6,15,[2,1,4]);u=true;for(t=0;t<3;t++){if((o&p[t])==p[t]){if(ZXb.Qk(a.g,A[t])==6&&ZXb.zk(a.g,A[t])==1||ZXb.Qk(a.g,A[t])==5&&ZXb.zk(a.g,A[t])==0){e[b]=true;g[b]=t;(j&p[t])==0&&(u=false);}}}break;case 5:q=Zjb(Ljb(TXb.klb,1),xZb,6,15,[10,5,18,9,20]);u=true;for(w=0;w<5;w++){if((o&q[w])==q[w]){switch(ZXb.Qk(a.g,A[w])){case 6:if(ZXb.zk(a.g,A[w])==-1){e[b]=true;g[b]=w;(j&q[w])==0&&(u=false);}break;case 7:if(ZXb.zk(a.g,A[w])<=0){e[b]=true;g[b]=w;}break;case 8:e[b]=true;g[b]=w;break;case 16:case 34:case 52:if(ZXb.Sn(a.g,A[w])==2){e[b]=true;g[b]=w;}}}}break;case 6:u=true;if((o&21)==21){e[b]=true;(j&21)==0&&(u=false);}if((o&42)==42){e[b]=true;(j&42)==0&&(u=false);}break;case 7:r=Zjb(Ljb(TXb.klb,1),xZb,6,15,[42,21,74,37,82,41,84]);u=true;for(s=0;s<7;s++){if((o&r[s])==r[s]){if(ZXb.Qk(a.g,A[s])==6&&(ZXb.zk(a.g,A[s])==1||h&&ZXb.Sr(a,A[s]))||ZXb.Qk(a.g,A[s])==5&&ZXb.zk(a.g,A[s])==0){e[b]=true;g[b]=s;(j&r[s])==0&&(u=false);}}}}e[b]&&!u&&(f[b]=true);if(e[b])return true;return !D;};ZXb.Gr=function Gr(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q;f=Rjb(TXb.klb,P$b,8,a.i.a.length,0,2);for(j=0;j<a.i.a.length;j++){f[j]=Rjb(TXb.klb,xZb,6,$Xb.Xi(a.i,j).length,15,1);for(k=0;k<$Xb.Xi(a.i,j).length;k++)f[j][k]=-1;}p=Rjb(TXb.klb,xZb,6,a.g.g,15,1);for(n=0;n<a.j.a.length;n++){o=$Xb.Xi(a.j,n);if(o.length==3||o.length>=5&&o.length<=7){for(i=0;i<o.length;i++){h=o[i];if(ZXb.Sn(a.g,ZXb.Vk(a.g,0,h))==3&&ZXb.Sn(a.g,ZXb.Vk(a.g,1,h))==3){if(p[h]>0){f[p[h]>>>16][p[h]&32767]=n;f[n][i]=p[h]>>>16;}else {p[h]=(n<<16)+l_b+i;}}}}}g=Rjb(TXb.Bwb,JZb,6,a.i.a.length,16,1);q=0;l=-1;while(q>l){l=q;for(m=0;m<a.i.a.length;m++){if(!g[m]){if(ZXb.Fr(a,m,f,g,b,c,d,e)){g[m]=true;++q;}}}}};ZXb.Hr=function Hr(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;e=ZXb.Vk(a.g,0,b);f=ZXb.Vk(a.g,1,b);i=Rjb(TXb.klb,xZb,6,a.g.f,15,1);j=Rjb(TXb.klb,xZb,6,a.g.f,15,1);k=Rjb(TXb.klb,xZb,6,a.g.f,15,1);i[0]=e;i[1]=f;j[e]=1;j[f]=2;k[e]=-1;k[f]=e;h=1;l=1;while(h<=l){for(m=0;m<ZXb.Sn(a.g,i[h]);m++){g=ZXb.Rn(a.g,i[h],m);if(h>1&&g==e){o=Rjb(TXb.klb,xZb,6,j[i[h]],15,1);d=i[h];for(n=0;n<o.length;n++){o[n]=d;d=k[d];}return o;}if(j[g]==0&&!c[g]){i[++l]=g;j[g]=j[i[h]]+1;k[g]=i[h];}}++h;}return null;};ZXb.Ir=function Ir(a,b,c){var d,e;e=$Xb.Xi(a.i,b);for(d=0;d<e.length;d++)if(c==e[d])return d;return -1;};ZXb.Jr=function Jr(a,b){return a.a[b]&oZb;};ZXb.Kr=function Kr(a,b,c){var d,e;e=$Xb.Xi(a.j,b);for(d=0;d<e.length;d++)if(c==e[d])return d;return -1;};ZXb.Lr=function Lr(a,b){return a.b[b]&oZb;};ZXb.Mr=function Mr(a,b){return a.c[b];};ZXb.Nr=function Nr(a,b){return $Xb.Xi(a.i,b);};ZXb.Or=function Or(a,b){return $Xb.Xi(a.j,b);};ZXb.Pr=function Pr(a,b){var c,d,e,f,g;f=b.length;g=Rjb(TXb.klb,xZb,6,f,15,1);for(d=0;d<f;d++){c=d==f-1?b[0]:b[d+1];for(e=0;e<ZXb.Sn(a.g,b[d]);e++){if(ZXb.Rn(a.g,b[d],e)==c){g[d]=ZXb.Tn(a.g,b[d],e);break;}}}return g;};ZXb.Qr=function Qr(a,b){return $Xb.Xi(a.j,b).length;};ZXb.Rr=function Rr(a,b,c){var d;for(d=0;d<a.j.a.length;d++)if(ZXb.Xr(a,d,b)&&ZXb.Xr(a,d,c))return d;return -1;};ZXb.Sr=function Sr(a,b){var c;for(c=0;c<ZXb.Sn(a.g,b);c++)if(ZXb.Un(a.g,b,c)==2&&ZXb.Qk(a.g,ZXb.Rn(a.g,b,c))==8)return true;return false;};ZXb.Tr=function Tr(a,b){return a.d[b];};ZXb.Ur=function Ur(a,b){return (a.a[b]&nZb)!=0;};ZXb.Vr=function Vr(a,b){return (a.b[b]&nZb)!=0;};ZXb.Wr=function Wr(a,b,c){var d,e;e=$Xb.Xi(a.i,b);for(d=0;d<e.length;d++)if(c==e[d])return true;return false;};ZXb.Xr=function Xr(a,b,c){var d,e;e=$Xb.Xi(a.j,b);for(d=0;d<e.length;d++)if(c==e[d])return true;return false;};ZXb.Yr=function Yr(a,b){return a.e[b];};ZXb.Zr=function Zr(a,b){return (a.b[b]&S$b)!=0;};ZXb.$r=function $r(a,b){return (a.a[b]&F$b)!=0;};ZXb._r=function _r(a,b){var c,d,e,f,g,h;for(g=0;g<2;g++){c=ZXb.Vk(a.g,g,b);if(ZXb.Qk(a.g,c)==7&&ZXb.Sn(a.g,c)==2){d=ZXb.Vk(a.g,1-g,b);if(ZXb.Qk(a.g,d)==6){for(h=0;h<ZXb.Sn(a.g,d);h++){e=ZXb.Rn(a.g,d,h);f=ZXb.Tn(a.g,d,h);if((ZXb.Qk(a.g,e)==8||ZXb.Qk(a.g,e)==16)&&ZXb.bl(a.g,f)==2&&ZXb.Sn(a.g,e)==1)return true;}}}}return false;};ZXb.as=function as(a,b){var c,d,e,f,g;if(a.g.K){if(bxb(Iwb(ZXb.Lk(a.g,b),1),0)){return true;}else {g=ZXb.Gk(a.g,b);if(g!=null){for(d=g,e=0,f=d.length;e<f;++e){c=d[e];if(c==5||c==6||c==7||c==8||c==15||c==16||c==33||c==34)return true;}return false;}}}return ZXb.is(ZXb.Qk(a.g,b));};ZXb.bs=function bs(a,b){var c,d,e,f,g;if(a.g.K){if(bxb(Iwb(ZXb.Lk(a.g,b),1),0))return false;c=ZXb.Gk(a.g,b);if(c!=null){for(e=c,f=0,g=e.length;f<g;++f){d=e[f];if(!ZXb.jn(d))return false;}return true;}}return ZXb.jn(ZXb.Qk(a.g,b));};ZXb.cs=function cs(a,b){return ZXb.bl(a.g,b)>1||ZXb.el(a.g,b)==64;};ZXb.ds=function ds(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;for(q=0;q<a.d.length;q++){if(a.d[q]){p=false;for(d=$Xb.Xi(a.i,q),f=0,h=d.length;f<h;++f){b=d[f];a.a[b]|=nZb;ZXb.bs(a,b)&&(p=true);}for(k=$Xb.Xi(a.j,q),m=0,o=k.length;m<o;++m){i=k[m];a.b[i]|=nZb;}if(a.e[q]){for(c=$Xb.Xi(a.i,q),e=0,g=c.length;e<g;++e){b=c[e];a.a[b]|=S$b;}for(j=$Xb.Xi(a.j,q),l=0,n=j.length;l<n;++l){i=j[l];a.b[i]|=S$b;}}if(p){for(c=$Xb.Xi(a.i,q),e=0,g=c.length;e<g;++e){b=c[e];a.a[b]|=F$b;}for(j=$Xb.Xi(a.j,q),l=0,n=j.length;l<n;++l){i=j[l];a.b[i]|=F$b;}}}}};ZXb.es=function es(a,b,c){var d,e,f,g;g=b.length;for(f=0;f<g;f++){d=a.a[b[f]]&oZb;if(d==0||d>g){a.a[b[f]]&=H$b;a.a[b[f]]|=g;}}for(e=0;e<g;e++){d=a.b[c[e]]&oZb;if(d==0||d>g){a.b[c[e]]&=H$b;a.b[c[e]]|=g;}}};ZXb.fs=function fs(a,b,c){var d;d=$Xb.Xi(a.j,b).length;while(c>=d)c-=d;while(c<0)c+=d;return c;};ZXb.gs=function gs(a,b){ZXb.hs.call(this,a,b);};ZXb.hs=function hs(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;this.g=a;this.f=7;this.i=new $Xb.kj();this.j=new $Xb.kj();this.a=Rjb(TXb.klb,xZb,6,this.g.f,15,1);this.b=Rjb(TXb.klb,xZb,6,this.g.g,15,1);this.g.Mb(1);m=Rjb(TXb.Bwb,JZb,6,this.g.f,16,1);n=Rjb(TXb.Bwb,JZb,6,this.g.g,16,1);do{g=false;for(c=0;c<this.g.f;c++){if(!m[c]){q=0;for(l=0;l<ZXb.Sn(this.g,c);l++)m[ZXb.Rn(this.g,c,l)]||++q;if(q<2){m[c]=true;for(k=0;k<ZXb.Sn(this.g,c);k++)n[ZXb.Tn(this.g,c,k)]=true;g=true;}}}}while(g);s=0;while(s<this.g.f&&m[s])++s;if(s==this.g.f)return;i=Rjb(TXb.klb,xZb,6,this.g.f,15,1);i[0]=s;p=Rjb(TXb.klb,xZb,6,this.g.f,15,1);p[0]=-1;h=Rjb(TXb.klb,xZb,6,this.g.f,15,1);h[s]=1;f=0;j=0;o=1;while(f<=j){for(k=0;k<ZXb.Sn(this.g,i[f]);k++){e=ZXb.Rn(this.g,i[f],k);if(e==p[i[f]])continue;if(h[e]!=0){ZXb.Er(this,ZXb.Tn(this.g,i[f],k),m);continue;}if(!m[e]){h[e]=o;p[e]=i[f];i[++j]=e;}}++f;if(f>j){for(c=0;c<this.g.f;c++){if(h[c]==0&&!m[c]){h[c]=++o;i[++j]=c;p[c]=-1;break;}}}}if((b&4)!=0){this.d=Rjb(TXb.Bwb,JZb,6,this.i.a.length,16,1);this.e=Rjb(TXb.Bwb,JZb,6,this.i.a.length,16,1);this.c=Rjb(TXb.klb,xZb,6,this.i.a.length,15,1);ZXb.Gr(this,this.d,this.e,this.c,(b&8)!=0);ZXb.ds(this);}if((b&2)!=0){for(d=0;d<this.g.g;d++){if(!n[d]&&ZXb.bl(this.g,d)!=0){r=ZXb.Hr(this,d,m);r!=null&&ZXb.es(this,r,ZXb.Pr(this,r));}}}};ZXb.is=function is(a){return a==5||a==6||a==7||a==8||a==15||a==16||a==33||a==34;};wxb(169,1,{},ZXb.gs);_.f=0;TXb.Ulb=UFb(169);ZXb.js=function js(a,b){var c,d,e,f,g,h,i,j,k,l,m;if(b==2||b==5){$Xb.Si(a.D,ZXb.Os(a.F,a.F.length));!!a.b&&$Xb.Si(a.a,ZXb.Ps(a.B,a.B.length));}else if(b==4){m=ZXb.vs(ZXb.Os(a.F,a.F.length));if(!$Xb._Rb(a.N,m)){$Xb.ZRb(a.N,m);$Xb.Si(a.D,ZXb.Os(a.F,a.F.length));!!a.b&&$Xb.Si(a.a,ZXb.Ps(a.B,a.B.length));}}else if(b==3){m=ZXb.vs(ZXb.Os(a.F,a.F.length));if(!$Xb._Rb(a.N,m)){l=false;for(j=(h=new $Xb.xRb(new $Xb.CRb(new $Xb.yNb(a.N.a).a).b),new $Xb.GNb(h));$Xb.gMb(j.a.a);){i=(g=$Xb.vRb(j.a),g.Wd());k=0;for(d=m,e=0,f=d.length;e<f;++e){c=d[e];while(k<i.length&&i[k]<c)++k;if(k<i.length){if(c==i[k]){l=true;break;}}}if(l)break;}if(!l){$Xb.ZRb(a.N,m);$Xb.Si(a.D,ZXb.Os(a.F,a.F.length));!!a.b&&$Xb.Si(a.a,ZXb.Ps(a.B,a.B.length));}}}else if(b==6){m=ZXb.ws(a,ZXb.Os(a.F,a.F.length));if(!$Xb._Rb(a.N,m)){$Xb.ZRb(a.N,m);$Xb.Si(a.D,ZXb.Os(a.F,a.F.length));!!a.b&&$Xb.Si(a.a,ZXb.Ps(a.B,a.B.length));}}};ZXb.ks=function ks(a,b,c){var d,e,f,g,h,i,j,k,l,m;h=ZXb.Sn(a.G,b);d=a.n[c];if(d>h)return false;j=ZXb.Lk(a.G,b);f=ZXb.Lk(a.g,c);e=ZXb.Gk(a.g,c);i=ZXb.Gk(a.G,b);if(bxb(Iwb(f,1),0)){if(e!=null){if(bxb(Iwb(j,1),0)){if(i==null)return false;if(!ZXb.Bs(e,i))return false;}else {if(i!=null){if(ZXb.Ds(i,e))return false;}else {if(ZXb.As(ZXb.Qk(a.G,b),e))return false;}}}}else {if(bxb(Iwb(j,1),0))return false;if(e!=null){if(i!=null){if(!ZXb.Bs(i,e))return false;}else {if(!ZXb.As(ZXb.Qk(a.G,b),e))return false;}}else {if(i!=null)return false;if(a.I[b]!=a.j[c])return false;}}if(bxb(dxb(j,f),0)){if(bxb(Iwb(f,w$b),0)){if(a.G.K&&Swb(Iwb(j,w$b),0))return false;else if(d!=h)return false;}if(bxb(Iwb(f,RZb),0)){if(d>=h&&Swb(Iwb(j,RZb),0))return false;}}if(bxb(Iwb(a.H[b],cxb(a.i[c])),0))return false;if(bxb(Iwb(a.A[c],cxb(a.L[b])),0))return false;g=Iwb(f,BZb);if(a.G.K){k=Iwb(f,BZb);if(Nwb(k,0)!=0&&(Nwb(g,0)==0||bxb(Iwb(g,cxb(k)),0)))return false;}else {if(Nwb(g,0)!=0&&Swb(Iwb(g,a.L[b]),0))return false;}if(ZXb.zk(a.g,c)!=0&&ZXb.zk(a.g,c)!=ZXb.zk(a.G,b))return false;if(ZXb.Jk(a.g,c)!=0&&ZXb.Jk(a.g,c)!=ZXb.Jk(a.G,b))return false;if(ZXb.Mk(a.g,c)!=0&&ZXb.Mk(a.g,c)!=ZXb.Mk(a.G,b))return false;l=kxb(fxb(Iwb(ZXb.Lk(a.g,c),t$b),22));if(l!=0){if(a.G.K){m=kxb(fxb(Iwb(ZXb.Lk(a.G,b),t$b),22));if(l!=m)return false;}else {if(ZXb.Mn(a.G,b)!=l)return false;}}return true;};ZXb.ls=function ls(a,b,c){var d,e,f,g,h,i,j,k,l;j=a.J[b];g=a.k[c];if((ZXb.dl(a.g,c)&Y$b)!=0){i=ZXb.fl(a.G,b);e=ZXb.fl(a.g,c);f=ZXb.dl(a.g,c)&31;if(i!=e&&!(i==1&&(f&1)!=0)&&!(i==2&&(f&2)!=0)&&!(i==4&&(f&4)!=0)&&!(i==8&&(f&32)!=0)&&!(i==16&&(f&64)!=0)&&!(i==32&&(f&16)!=0)&&!(i==64&&(f&8)!=0))return false;j&=-32;g&=-32;}if((j&~g)!=0)return false;l=(ZXb.dl(a.g,c)&h$b)>>17;if(l!=0){if(a.G.K&&l==(ZXb.dl(a.G,c)&h$b)>>17)return true;d=false;k=ZXb.so(a.G);for(h=0;h<k.i.a.length;h++){if($Xb.Xi(k.j,h).length==l){if(ZXb.Xr(k,h,b)){d=true;break;}}}if(!d)return false;}return true;};ZXb.ms=function ms(a){var b,c;a.b=null;for(b=0;b<a.g.g;b++){if(ZXb.xl(a.g,b)){!a.b&&(a.b=new $Xb.kj());c=new ZXb.Qs();c.a=ZXb.Vk(a.g,0,b);c.b=ZXb.Vk(a.g,1,b);c.d=ZXb.Xk(a.g,b);c.c=ZXb.Wk(a.g,b);$Xb.Si(a.b,c);}}};ZXb.ns=function ns(a){var b,c,d,e,f,g,h,i,j,k,l,m;ZXb.nu(a.g,a.M);i=$wnd.Math.max(a.g.f,a.g.g)+16;a.r=Rjb(TXb.klb,xZb,6,i,15,1);a.t=Rjb(TXb.klb,xZb,6,i,15,1);a.u=Rjb(TXb.klb,xZb,6,i,15,1);a.s=Rjb(TXb.Bwb,JZb,6,i+1,16,1);g=Rjb(TXb.Bwb,JZb,6,a.g.f,16,1);h=Rjb(TXb.Bwb,JZb,6,a.g.g,16,1);d=0;for(c=0;c<a.g.f;c++){if(!a.C[c]&&!g[c]){a.r[d]=c;a.u[d]=-1;a.t[d]=-1;j=d;while(d<=j){for(k=0;k<ZXb.En(a.g,a.r[d]);k++)j=ZXb.Ls(a,d,j,k,g,h,-1);while(a.s[++d]);}}}a.v=d;if(a.o!=0){j=a.v-1;for(f=0;f<a.d;f++){d=0;while(d<=j){for(l=0;l<ZXb.En(a.g,a.r[d]);l++)j=ZXb.Ls(a,d,j,l,g,h,f);while(a.s[++d]);}}for(b=0;b<a.g.f;b++){if(a.C[b]&&!g[b]){a.r[d]=b;a.u[d]=-1;a.t[d]=-1;j=d;while(d<=j){for(l=0;l<ZXb.En(a.g,a.r[d]);l++)ZXb.Rn(a.g,a.r[d],l)<a.g.f&&(j=ZXb.Ls(a,d,j,l,g,h,a.f[b]));while(a.s[++d]);}}}a.e=Rjb(TXb.klb,xZb,6,a.d,15,1);for(m=0;m<a.d;m++)a.e[m]=-1;for(k=a.v;k<d;k++){e=a.f[a.r[k]];a.e[e]==-1&&(a.e[e]=k);}}a.w=d;};ZXb.os=function os(a,b){var c,d,e,f,g,h,i,j;j=ZXb.so(a.G);for(h=0;h<j.i.a.length;h++){if(ZXb.Xr(j,h,b)){i=Rjb(TXb.klb,xZb,6,2,15,1);for(e=0;e<2;e++){i[e]=fZb;d=ZXb.Vk(a.G,e,b);for(f=0;f<ZXb.Sn(a.G,d);f++){c=ZXb.Rn(a.G,d,f);c!=ZXb.Vk(a.G,1-e,b)&&i[e]>c&&(i[e]=c);}}g=0;ZXb.Wr(j,h,i[0])&&++g;ZXb.Wr(j,h,i[1])&&++g;if(g==2)return 2;if(g==1)return 1;return 2;}}return 0;};ZXb.ps=function ps(a,b,c){var d,e,f,g,h;if(a.b){a.B=Rjb(TXb.Bwb,JZb,6,b.length,16,1);for(e=new $Xb.qOb(a.b);e.a<e.c.a.length;){d=$Xb.pOb(e);if(a.f==null||c==-1&&a.f[d.a]==-1&&a.f[d.b]==-1||c!=-1&&(a.f[d.a]==c||a.f[d.b]==c)){h=Rjb(TXb.klb,xZb,6,d.c+2,15,1);f=ZXb.mo(a.G,h,a.F[d.a],a.F[d.b],d.c+1,b,null)-1;if(f<d.d||f>d.c)return false;for(g=1;g<=f;g++)a.B[h[g]]=true;}}}return true;};ZXb.qs=function qs(a,b){var c,d,e,f,g,h,i,j;for(e=0;e<a.g.g;e++){if((ZXb.dl(a.g,e)&V$b)!=0){f=ZXb.cl(a.g,e);if(f==0)continue;c=ZXb.Vk(a.g,0,e);d=ZXb.Vk(a.g,1,e);if(a.f==null||b==-1&&a.f[c]==-1&&a.f[d]==-1||b!=-1&&(a.f[c]==b||a.f[d]==b)){g=a.F[c];h=a.F[d];i=ZXb.Pn(a.G,g,h);j=ZXb.cl(a.G,i);if(j==0){ZXb.Yo(a.G,i)&&(j=ZXb.os(a,i));if(j==0)continue;}if(f==3)continue;if(j==3)continue;if(ZXb.xs(a,e)==(f==j))return false;}}}return true;};ZXb.rs=function rs(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p;g=0;for(i=0;i<a.g.f;i++){if((a.f==null||a.f[i]==b)&&bxb(Iwb(ZXb.Lk(a.g,i),v$b),0)){m=a.F[i];l=ZXb.Kk(a.g,i);o=ZXb.Kk(a.G,m);if(l==0)continue;if(l==3)continue;if(o==0||o==3)return false;if(ZXb.Ek(a.g,i)==1){++g;continue;}if(ZXb.Ek(a.G,m)==1)return false;if(ZXb.Ek(a.g,i)==2){++g;continue;}if(ZXb.Ek(a.G,m)==2)return false;if(ZXb.Cs(a,i)==(l==o))return false;}}if(g!=0){e=Rjb(TXb.klb,xZb,6,g,15,1);f=0;for(j=0;j<a.g.f;j++){if((a.f==null||a.f[j]==b)&&bxb(Iwb(ZXb.Lk(a.g,j),v$b),0)){l=ZXb.Kk(a.g,j);l!=0&&l!=3&&(e[f++]=ZXb.Dk(a.g,j)<<24|ZXb.Ek(a.g,j)<<22|j);}}XXb.eTb(e,XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));f=0;while(f<e.length){k=e[f]&p_b;n=a.F[k];c=e[f]&-4194304;d=ZXb.Cs(a,k)^ZXb.Kk(a.g,k)==ZXb.Kk(a.G,n);for(++f;f<e.length&&(e[f]&-4194304)==c;f++){h=e[f]&p_b;m=a.F[h];if(ZXb.Ek(a.G,m)!=ZXb.Ek(a.G,n)||ZXb.Dk(a.G,m)!=ZXb.Dk(a.G,n))return false;p=ZXb.Cs(a,h)^ZXb.Kk(a.g,h)==ZXb.Kk(a.G,m);if(p!=d)return false;}}}return true;};ZXb.ss=function ss(a,b,c){var d,e,f,g,h,i,j;a.O=false;a.D=new $Xb.kj();a.a=new $Xb.kj();$Xb.$Qb(a.N.a);if(!a.G||!a.g)return 0;if(a.g.f-a.o>a.G.f||a.g.g-a.p>a.G.g)return 0;if(a.g.f==0)return 0;b==6&&(a.M=63);ZXb.Hs(a,c);d=Rjb(TXb.Bwb,JZb,6,a.G.f,16,1);a.F=Rjb(TXb.klb,xZb,6,a.g.f,15,1);$Xb.AOb(a.F);h=Rjb(TXb.klb,xZb,6,a.w,15,1);$Xb.FOb(h,h.length,-1);f=0;while(!a.O){if(a.v!=0){j=a.t[f]==-1?a.G.f:ZXb.En(a.G,a.F[a.t[f]]);++h[f];if(h[f]==j){h[f]=-1;if(f==0)break;--f;a.s[f]||(d[a.F[a.r[f]]]=false);continue;}if(a.t[f]==-1){if(!d[h[f]]){if(ZXb.ks(a,h[f],a.r[f])){a.F[a.r[f]]=h[f];d[h[f]]=true;++f;}}}else {if(ZXb.Rn(a.G,a.F[a.t[f]],h[f])>=a.G.f)continue;e=ZXb.Rn(a.G,a.F[a.t[f]],h[f]);if(a.s[f]){e==a.F[a.r[f]]&&ZXb.ls(a,ZXb.Tn(a.G,a.F[a.t[f]],h[f]),a.u[f])&&++f;}else {if(!d[e]){if(ZXb.ks(a,e,a.r[f])&&ZXb.ls(a,ZXb.Tn(a.G,a.F[a.t[f]],h[f]),a.u[f])){d[e]=true;a.F[a.r[f]]=e;++f;}}}}}if(f==a.v){if(ZXb.rs(a,-1)&&ZXb.qs(a,-1)&&ZXb.ps(a,d,-1)){i=false;for(g=0;g<a.d;g++){if(ZXb.ys(a,d,h,g)){i=true;break;}}if(b==1&&!i)return 1;if(!i){ZXb.js(a,b);if(b==2)return 1;}}if(f==0)break;--f;a.s[f]||(d[a.F[a.r[f]]]=false);}}return a.D.a.length;};ZXb.ts=function ts(a,b){var c,d,e,f,g,h,i,j;i=0;if(a.K){b<a.f&&ZXb.$r(a.p,b)?i=dxb(i,M_b):b<a.f&&ZXb.Ur(a.p,b)&&(i=dxb(i,2));j=(e=a.u[b]&q_b,e==0?0:e==WZb?2:e==w$b?3:4);if(j!=0){i=dxb(i,8);j>2&&(i=dxb(i,16));j>3&&(i=dxb(i,32));}c=a.s[b];c<0?i=dxb(i,$Zb):c>0&&(i=dxb(i,ZZb));g=a.j[b];switch(g){case 0:break;case 1:i=dxb(i,S$b);break;case 2:i=dxb(i,g$b);break;case 3:i=dxb(i,h$b);break;default:i=dxb(i,i$b);}d=ZXb.Hn(a,b);switch(d){case 0:break;case 1:i=dxb(i,p$b);break;case 2:i=dxb(i,q$b);break;case 3:i=dxb(i,r$b);break;default:i=dxb(i,s$b);}h=a.o[b];h>0&&(i=dxb(i,QZb));h>1&&(i=dxb(i,l_b));}else {b<a.f&&ZXb.$r(a.p,b)?i=dxb(i,M_b):b<a.f&&ZXb.Ur(a.p,b)?i=dxb(i,2):i=dxb(i,4);(a.u[b]&k_b)!=0?i=dxb(i,SZb):i=dxb(i,TZb);j=(e=a.u[b]&q_b,e==0?0:e==WZb?2:e==w$b?3:4);j==0?i=dxb(i,112):j==2?i=dxb(i,104):j==3?i=dxb(i,88):i=dxb(i,56);c=a.s[b];c==0?i=dxb(i,YZb):c<0?i=dxb(i,$Zb):c>0&&(i=dxb(i,ZZb));f=a.e[b]-ZXb.jo(a,b)+ZXb.fo(a,b);switch(f){case 0:i=dxb(i,1792);break;case 1:i=dxb(i,1664);break;case 2:i=dxb(i,1408);break;default:i=dxb(i,896);}g=a.j[b];switch(g){case 0:i=dxb(i,3932160);break;case 1:i=dxb(i,b$b);break;case 2:i=dxb(i,c$b);break;case 3:i=dxb(i,d$b);break;default:i=dxb(i,i$b);}d=ZXb.Hn(a,b);switch(d){case 0:i=dxb(i,k$b);break;case 1:i=dxb(i,l$b);break;case 2:i=dxb(i,m$b);break;case 3:i=dxb(i,n$b);break;default:i=dxb(i,s$b);}h=a.o[b];switch(h){case 0:i=dxb(i,98304);break;case 1:i=dxb(i,81920);break;default:i=dxb(i,49152);}}return i;};ZXb.us=function us(a,b){var c;c=0;if(b<a.g&&(ZXb.Zr(a.p,b)||a.H[b]==64)||a.H[b]==64)c|=8;else switch(ZXb.bl(a,b)){case 4:case 0:c|=32;break;case 1:c|=1;break;case 2:c|=2;break;case 3:c|=4;break;case 5:c|=64;}(a.F[b]&64)!=0?c|=256:a.K||(c|=128);b<a.g&&ZXb.Vr(a.p,b)?c|=f$b:a.K||(c|=N_b);return c;};ZXb.vs=function vs(a){var b,c,d,e,f,g,h,i,j,k;i=0;for(d=a,f=0,h=d.length;f<h;++f){b=d[f];b==-1&&++i;}if(i!=0){k=a;a=Rjb(TXb.klb,xZb,6,k.length-i,15,1);j=0;for(c=k,e=0,g=c.length;e<g;++e){b=c[e];b!=-1&&(a[j++]=b);}}XXb.eTb(a,XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));return a;};ZXb.ws=function ws(a,b){var c,d,e,f,g,h,i,j;g=0;for(d=b,e=0,f=d.length;e<f;++e){c=d[e];c==-1&&++g;}j=Rjb(TXb.klb,xZb,6,b.length-g,15,1);i=0;for(h=0;h<b.length;h++){if(b[h]!=-1){j[i]=ZXb.yu(a.g,h)<<16|ZXb.yu(a.G,b[h]);++i;}}XXb.eTb(j,XXb.KTb(zxb($Xb.YOb.prototype.Zd,$Xb.YOb,[])));return j;};ZXb.xs=function xs(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;f=false;for(e=0;e<2;e++){c=ZXb.Vk(a.g,e,b);k=a.F[c];if(ZXb.Sn(a.G,k)>2){m=ZXb.Vk(a.g,1-e,b);i=fZb;for(h=0;h<ZXb.Sn(a.g,c);h++){d=ZXb.Rn(a.g,c,h);d!=m&&i>d&&(i=d);}n=a.F[m];j=fZb;for(g=0;g<ZXb.Sn(a.G,k);g++){l=ZXb.Rn(a.G,k,g);l!=n&&j>l&&(j=l);}a.F[i]!=j&&(f=!f);}}return f;};ZXb.ys=function ys(a,b,c,d){var e,f,g,h,i,j,k,l;h=a.e[d];i=h+1;while(i<a.w&&a.f[a.r[i]]==d)++i;for(k=h;k<i;k++)c[k]=-1;g=h;while(true){l=a.t[g]==-1?a.G.f:ZXb.En(a.G,a.F[a.t[g]]);++c[g];if(c[g]==l){c[g]=-1;if(g==h)break;--g;if(!a.s[g]){b[a.F[a.r[g]]]=false;a.F[a.r[g]]=-1;}continue;}if(a.t[g]==-1){if(!b[c[g]]){if(ZXb.ks(a,c[g],a.r[g])){a.F[a.r[g]]=c[g];b[c[g]]=true;++g;}}}else {if(ZXb.Rn(a.G,a.F[a.t[g]],c[g])>=a.G.f){++c[g];continue;}f=ZXb.Rn(a.G,a.F[a.t[g]],c[g]);if(a.s[g]){f==a.F[a.r[g]]&&ZXb.ls(a,ZXb.Tn(a.G,a.F[a.t[g]],c[g]),a.u[g])&&++g;}else {if(!b[f]){if(ZXb.ks(a,f,a.r[g])&&ZXb.ls(a,ZXb.Tn(a.G,a.F[a.t[g]],c[g]),a.u[g])){b[f]=true;a.F[a.r[g]]=f;++g;}}}}if(g==i){if(ZXb.rs(a,d)&&ZXb.qs(a,d)&&ZXb.ps(a,b,d)){for(j=h;j<i;j++){if(!a.s[j]){e=a.r[j];b[a.F[e]]=false;a.F[e]=-1;}}return true;}--g;if(!a.s[g]){b[a.F[a.r[g]]]=false;a.F[a.r[g]]=-1;}}}return false;};ZXb.zs=function zs(a){return ZXb.ss(a,1,a.c)>0;};ZXb.As=function As(a,b){var c;for(c=0;c<b.length;c++)if(b[c]==a)return true;return false;};ZXb.Bs=function Bs(a,b){var c,d,e;e=0;for(d=0;d<a.length;d++){c=a[d];while(b[e]<c){++e;if(e==b.length)return false;}if(b[e]>c)return false;}return true;};ZXb.Cs=function Cs(a,b){var c,d,e,f,g,h,i,j;g=false;if(ZXb.In(a.g,b)==0){for(f=1;f<ZXb.Sn(a.g,b);f++){for(h=0;h<f;h++){d=ZXb.Rn(a.g,b,f);e=ZXb.Rn(a.g,b,h);a.F[d]>a.F[e]^d>e&&(g=!g);}}}else {for(f=0;f<ZXb.Sn(a.g,b);f++){c=ZXb.Rn(a.g,b,f);j=0;i=Rjb(TXb.klb,xZb,6,3,15,1);for(h=0;h<ZXb.Sn(a.g,c);h++){i[j]=ZXb.Rn(a.g,c,h);i[j]!=b&&++j;}j==2&&a.F[i[0]]>a.F[i[1]]^i[0]>i[1]&&(g=!g);}}return g;};ZXb.Ds=function Ds(a,b){var c,d,e,f;e=0;f=0;while(e<a.length&&f<b.length){c=a[e];d=b[f];if(c==d)return true;c<d?++e:++f;}return false;};ZXb.Es=function Es(a,b){var c,d,e,f,g;if(!b||b.q==0||!b.K){a.g=null;return;}a.g=b;a.q=false;ZXb.nu(a.g,1);a.M=7;for(d=0;d<a.g.f;d++)bxb(Iwb(ZXb.Lk(a.g,d),{l:v$b,m:0,h:3}),0)&&(a.M=15);for(g=0;g<a.g.g;g++)(ZXb.dl(a.g,g)&V$b)!=0&&(a.M=15);a.K&&a.M!=7&&ZXb.nu(a.G,a.M);a.o=0;a.p=0;a.C=Rjb(TXb.Bwb,JZb,6,a.g.f,16,1);for(e=0;e<a.g.f;e++){a.C[e]=bxb(Iwb(ZXb.Lk(a.g,e),KZb),0);a.C[e]&&++a.o;}a.d=0;a.f=null;if(a.o!=0){if(a.o!=0)for(f=0;f<a.g.g;f++)(a.C[ZXb.Vk(a.g,0,f)]||a.C[ZXb.Vk(a.g,1,f)])&&++a.p;for(c=0;c<a.g.q;c++)ZXb.lm(a.g,c,a.C[c]);a.f=Rjb(TXb.klb,xZb,6,a.g.q,15,1);a.d=ZXb.$n(a.g,a.f,true,false);}};ZXb.Fs=function Fs(a,b,c){ZXb.Gs(a,c);ZXb.Es(a,b);};ZXb.Gs=function Gs(a,b){if(!b||b.q==0){a.G=null;return;}a.G=b;a.K=false;ZXb.nu(a.G,1);};ZXb.Hs=function Hs(a,b){if(!a.K){ZXb.Ks(a,b);a.K=true;}if(!a.q){ZXb.Is(a,b);ZXb.ns(a);ZXb.ms(a);a.q=true;}};ZXb.Is=function Is(a,b){var c,d,e,f,g,h,i,j,k,l;f=null;i=null;g=null;ZXb.nu(a.g,a.M);a.n=Rjb(TXb.klb,xZb,6,a.g.f,15,1);for(d=0;d<a.g.f;d++)a.n[d]=ZXb.Sn(a.g,d);if(a.o!=0){j=new ZXb.Gu(a.g.q,a.g.r);l=Rjb(TXb.Bwb,JZb,6,a.g.q,16,1);for(e=0;e<a.g.q;e++)l[e]=!a.C[e];ZXb.un(a.g,j,l,true,null);ZXb.nu(j,a.M);ZXb.Js(a,j,b);f=a.i;i=a.k;g=a.j;k=0;for(c=0;c<a.g.f;c++)a.C[c]||(a.n[c]=ZXb.Sn(j,k++));}ZXb.Js(a,a.g,b);if(a.o!=0){k=0;for(c=0;c<a.g.q;c++){if(!a.C[c]){a.i[c]=f[k];a.j[c]=g[k++];}}k=0;for(h=0;h<a.g.r;h++){!a.C[ZXb.Vk(a.g,0,h)]&&!a.C[ZXb.Vk(a.g,1,h)]&&(a.k[h]=i[k++]);}}};ZXb.Js=function Js(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;p=b.f;a.i=Rjb(TXb.llb,M$b,6,b.f,14,1);a.j=Rjb(TXb.klb,xZb,6,b.f,15,1);for(h=0;h<p;h++){a.i[h]=mxb(Iwb(dxb(ZXb.ts(b,h),b.B[h]),O_b),P_b);a.j[h]=b.C[h];(c&1)!=0&&(a.j[h]+=b.s[h]+16<<8);(c&2)!=0&&(a.j[h]+=b.A[h]<<16);}a.A=Rjb(TXb.llb,M$b,6,b.f,14,1);r=(ZXb.nu(b,7),b.p);for(o=0;o<r.i.a.length;o++){n=false;for(j=$Xb.Xi(r.j,o),k=0,l=j.length;k<l;++k){m=j[k];if((b.G[m]&y$b)!=0){n=true;break;}}if(!n){s=$Xb.Xi(r.j,o).length;for(e=$Xb.Xi(r.i,o),f=0,g=e.length;f<g;++f){d=e[f];s==3?a.A[d]=dxb(a.A[d],DZb):s==4?a.A[d]=dxb(a.A[d],EZb):s==5?a.A[d]=dxb(a.A[d],FZb):s==6?a.A[d]=dxb(a.A[d],GZb):s==7&&(a.A[d]=dxb(a.A[d],HZb));}}}q=b.g;a.k=Rjb(TXb.klb,xZb,6,b.g,15,1);for(i=0;i<q;i++){a.k[i]=(ZXb.us(b,i)|b.G[i])&6291967^6291840;(c&4)!=0?(a.k[i]&2)!=0&&(a.k[i]|=8):(c&8)!=0&&(a.k[i]&2)!=0&&i<b.g&&ZXb.Vr(b.p,i)&&(a.k[i]|=8);}};ZXb.Ks=function Ks(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;ZXb.nu(a.G,a.M);k=a.G.f;a.I=Rjb(TXb.klb,xZb,6,k,15,1);a.H=Rjb(TXb.llb,M$b,6,k,14,1);for(g=0;g<k;g++){a.H[g]=mxb(Iwb(dxb(ZXb.ts(a.G,g),ZXb.Lk(a.G,g)),O_b),P_b);a.I[g]=ZXb.Qk(a.G,g);(b&1)!=0&&(a.I[g]+=ZXb.zk(a.G,g)+16<<8);(b&2)!=0&&(a.I[g]+=ZXb.Jk(a.G,g)<<16);}a.L=Rjb(TXb.llb,M$b,6,k,14,1);m=ZXb.so(a.G);for(j=0;j<m.i.a.length;j++){n=$Xb.Xi(m.j,j).length;for(d=$Xb.Xi(m.i,j),e=0,f=d.length;e<f;++e){h=d[e];n==3?a.L[h]=dxb(a.L[h],DZb):n==4?a.L[h]=dxb(a.L[h],EZb):n==5?a.L[h]=dxb(a.L[h],FZb):n==6?a.L[h]=dxb(a.L[h],GZb):n==7&&(a.L[h]=dxb(a.L[h],HZb));}}for(c=0;c<k;c++){n=ZXb.Mn(a.G,c);n==0?a.L[c]=dxb(a.L[c],CZb):n>7&&(a.L[c]=dxb(a.L[c],IZb));}l=a.G.g;a.J=Rjb(TXb.klb,xZb,6,l,15,1);for(i=0;i<l;i++)a.J[i]=(ZXb.us(a.G,i)|ZXb.dl(a.G,i))&6422527^6291840;};ZXb.Ls=function Ls(a,b,c,d,e,f,g){var h,i;h=ZXb.Rn(a.g,a.r[b],d);if((!a.C[h]||a.f[h]==g)&&h!=a.t[b]){i=ZXb.Tn(a.g,a.r[b],d);if(!f[i]&&!ZXb.xl(a.g,i)){a.r[++c]=h;a.t[c]=a.r[b];a.u[c]=i;f[i]=true;e[h]?a.s[c]=true:e[h]=true;}}return c;};ZXb.Ms=function Ms(){this.c=8;this.N=new $Xb.dSb(new xYb.v6());};ZXb.Ns=function Ns(){this.c=1;this.N=new $Xb.dSb(new xYb.v6());};ZXb.Os=function Os(a,b){var c;c=Rjb(TXb.klb,xZb,6,b,15,1);UXb.oIb(a,0,c,0,$wnd.Math.min(a.length,b));return c;};ZXb.Ps=function Ps(a,b){var c;c=Rjb(TXb.Bwb,JZb,6,b,16,1);UXb.oIb(a,0,c,0,$wnd.Math.min(a.length,b));return c;};wxb(91,1,{},ZXb.Ms,ZXb.Ns);_.c=0;_.d=0;_.o=0;_.p=0;_.q=false;_.v=0;_.w=0;_.K=false;_.M=0;_.O=false;TXb.Xlb=UFb(91);ZXb.Qs=function Qs(){};wxb(249,1,{249:1},ZXb.Qs);_.a=0;_.b=0;_.c=0;_.d=0;TXb.Vlb=UFb(249);ZXb.Ts=function Ts(){ZXb.Ts=yxb;ZXb.Rs=Zjb(Ljb(TXb.Nub,1),mZb,2,6,['QM@HzAmdqjF@','RF@Q``','qC`@ISTAlQE`','`J@H','QM@HzAmdqbF@','qC`@ISTAlQEhqPp@','sJP@DiZhAmQEb','RF@QPvR@','QM@HzA@','qC`@ISTAlQEhpPp@','qC`@Qz`MbHl','sJP@DiZhAmQEcFZF@','RFPDXH','qC`@IVtAlQE`','QM@HvAmdqfF@','sGP@DiVj`FsDVM@','`L@H','sJP@DizhAmQEcFBF@','sJP@DjvhAmQEb','sFp@DiTt@@AlqEcP','sGP@LdbMU@MfHlZ','QMHAIhD','QM@HzAy@','sJP@DkVhAmQEb','sNp@DiUjj@[\\QXu`','sJP@DiZhAmQEcFBF@','sGP@DjVj`FsDVM@','RFPDTH','RG@DXOH@','sGP@Divj`FsDVMcAC@','sGP@Dj}j`FsDVM@','qC`@Qz`MbHmFRF@','sNp@LdbJjj@[\\QXu`','QMHAIhGe@','QM@HzAyd`','QM`AIhD','qC`@ISTA@','sGP@DkUj`FsDVM@','qC`@IVtAlQEhqPp@','sNp@DiUjj@[\\QXuqea`@','KAx@@IRjuUPAlHPfES\\','QM`BN`P','sJP@DjZhAmQEcFJF@','Hid@@DjU^nBBH@FtaBXUMp`','sNp@Diujj@[\\QXuq`a`@','sJP@DjvhAmQEcFZF@','sJP@DjZhAmQEcFFF@','sOp@DjWkB@@FwDVM\\YhX@','sNp@Dj}Zj@[\\QXu`','sNp@DiWjj@[\\QXuq`a`@','sOp@DjWkB@@D','KAx@@ITouUPAlHPfES\\','KAx@@YIDTjjh@vDHSBin@','sNp@DkUZj@[\\QXu`','RFPDXOH@','QM`BN`^L`','qC`@ISTAy@','sGP@LdbMU@MfHl[FVF@','qCb@AIZ`H','KAx@@IRjuUPAlHPfES]FFa`@','KAx@@ITnuUPAlHPfES\\','HiD@@DiUVjj`AmHPfES\\H','sNp@DjUjj@[\\QXu`','sJP@DkVhAmQEcFJF@','sGP@DjVj`FsDVMcCC@','qC`@Qz`MbHmFBF@','sJP@DkfhAmQEb','qC`@IVtAlQEhsPp@','sGP@Djuj`FsDVM@','sGP@Dj}j`FsDVMcMC@','sJP@DiZhA@','KAx@@ISjuUPAlHPfES]F@a`@','sJP@DjZhAmQEcFRF@','KAx@@IRnuUPAlHPfES]F@a`@','HiD@@DjWvjj`AmHPfES\\H','QMHAIhGd@','sNp@DiUjj@[\\QXuq`a`@','KAx@@IVjmUPAlHPfES\\','sGP@DjVj`FsDVMcMC@','QM`AIhGe@','HiD@@LdbJRjjh@[RDIaTwB','qCp@AIZ`H','sGP@LdbMU@MfHl[FFF@','QMDARVA@','sNp@LdbJjj@[\\QXuqba`@','sNp@LdbJjj@[\\QXuqca`@','sGP@Dkej`FsDVM@','qCb@AIZ`OI@','HaD@@DjUZxHH@AlHPfES]FLa`@','sGP@DkYj`FsDVM@','qCb@AIV`H','sNp@LdbJjj@[\\QXuqea`@','sGP@DkUj`FsDVMcEC@','sFp@DiTt@@Axa@','Hmt@@DjU_ZxHHj@AmhPfES\\Lj','QM`BN`^P','qCb@AIZ`OH`','sFp@DiTt@@AxaP','sGP@Djuj`FsDVMcEC@','sGP@Djuj`FsDVMcIC@','sGP@DkUj`FsDVMcKC@','sJP@DkfhAmQEcFRF@','sGP@DjVj`FsDVMcIC@','HaD@@DjUZxHH@AlHPfES]FFa`@','qC`@IRtDVqDV@','sNp@Dj}Zj@[\\QXuqfa`@','KAx@@ITnuUPAlHPfES]FFa`@','HiD@@DkUUjj`AmHPfES\\H','sJQ@@dkU@H','qC`@Qz`H','KAx@@IUkmUPAlHPfES\\','KAx@@ITouUPAlHPfES]FJa`@','sJP@H~j@[TQX`','sGP@DjZj`FsDVM@','sJP@DkVhAmQEcFFF@','sJX@@eKU@H','sJP@DizhAy@','QMHAIhGbP','KAx@@ITouUPAlHPfES]FNa`@','HaD@@DjUZxHD@AlHPfES\\','HaD@@DjUZxHH@A@','sNp@LdbJjj@[\\QXuqaa`@','Hed@@LdbRQUUUP@vTHSBinFP','KAx@@ITouUPAlHPfES]FLa`@','sNp@DkUZj@[\\QXuqba`@','KAx@@ITjuUPAlHPfES]FNa`@','KAx@@YIDTjjh@vDHSBincGPp@','HaD@@DjYvxH`@AlHPfES]FLa`@','RF@QP`','qCb@AIj`H','sNp@DjUjj@[\\QXuqaa`@','sNp@DkVZj@[\\QXu`','KAx@@YIDUJjh@vDHSBin@','sGP@DkYj`FsDVMcIC@','sGP@DjVj`FsDVMcAC@','sGP@DiVj`D','sJP@DkVhAmQEcFZF@','sNp@LdbLjj@[\\QXu`','QM@HvAmdqbF@','HaD@@DjWjXHB@AlHPfES\\','sNp@DjwZj@[\\QXuqba`@','sNp@LdbJjj@[\\QXuqda`@','sFp@DiTt@@Axa`','HiD@@Djuujj`AmHPfES\\H','sNp@DkUZj@[\\QXuqca`@','sJP@DiZhAy@','KAx@@YIDTjjh@vDHSBincCPp@','KAx@@IWNmUPAlHPfES\\','KAx@@IVkMUPAlHPfES\\','sJQ@@dju@H','qCb@AIZ`OH@','qC`@ISTAxa@','sNp@DjyZj@[\\QXu`','Hid@@DjUfaBB`@FtaBXUMp`','HiD@@DiUVjj`AmHPfES\\LXBF@','KAx@@IUjmUPAlHPfES\\','HiD@@DjWvjj`AmHPfES\\LXjF@','sJP@DjVhAmQEb','qCb@AIV`OH`','HiD@@LdbJRjjh@[RDIaTwCFDa`@','KAx@@YIDTjjh@vDHSBinc@Pp@','sNp@DjUjj@[\\QXuqda`@','qC`@Qz`OED','sJP@DkfhAmQEcFZF@','KAx@@YIDbjjh@vDHSBincDPp@','sGP@Djyj`FsDVMcMC@','KAx@@IVrmUPAlHPfES\\','qCp@AIZ`OI@','sJX@@dkU@H','sJQ@@dkU@OH`','sNp@Di]ZjBBvxbqk@','Hkl@@DjU_Uk``bj`@[VDIaTwCJzX','sGP@DjZj`FsDVMcEC@','Hid@@DjU^nBBH@FtaBXUMpqcHX@','sNp@DkeZj@[\\QXu`','sNp@DjYjj@[\\QXuqca`@','sGQ@@djuT@`','HiD@@LdbJTjjh@[RDIaTwB','sOp@DjWkB@@Gd`','HeT@@LdbbRKBDQD@CYPaLJfxY@','qCr@XIKTA@','HiD@@DjW^jj`AmHPfES\\LXJF@','HeT@@DjU]k``b`@[JDIaTwCH','sGP@Djuj`FsDVMcCC@','`IH`B','sOp@DjWkB@@GdX','sJQ@@eKU@H','KAx@@YIDUJjh@vDHSBincBPp@','sJX@@eKU@OH@','KAx@@YIDTjjh@vDHSBincAPp@','sOq@@drm\\@@@`','KAx@@IUkMUPAlHPfES\\','qCp@AIj`H','Hed@@DjUUjjj@FraBXUMpr','sGX@@eJuT@`','sGP@DkUj`FsDVMcCC@','HiD@@Dj}Ujj`AmHPfES\\LXrF@','KAx@@ITouUPAlHPfES]FHa`@','Hed@@DjWujjj@FraBXUMpsFIa`@','sGP@DiUj``mfHlZ','sFp@DiTvjhAlqEcP','Hid@@DjU^nBBH@FtaBXUMpq`XX@','sJP@DkVdAmQEb','qCp@AIZ`OH`','QMhDRVA@','qC`@ISJAlQE`','qCp@BOTAyhl','sJX@@eOU@ODB','sFp@DiTt@@AyaB','sGP@DkUj`FsDVMcMC@','Hid@@DjYUaBH`@FtaBXUMpqcHX@','qC`@Qz`OH@','HiD@@DjUVjj`AmHPfES\\LXZF@','sJP@H~j@[TQXqda`@','sJX@@eKU@OI@','sNp@Djejj@[\\QXu`','sJQ@@dsU@H','sJQ@@dkU@OI`','KAx@@YIMDVjh@vDHSBin@','Hid@@DjU^nBBD@FtaBXUMp`','sNp@DkgZj@[\\QXuqca`@','qC`@IRtDVqDVcEC@','Hed@@LdbRQeUUP@vTHSBinFP','sNp@DiUjj@P','qC`@IRtDT','sNp@DkYZj@[\\QXuqca`@','KAx@@IUkmUPAlHPfES]FDa`@','KAx@@IVjmUPAlHPfES]FNa`@','sOx@@drm\\@@@`','KAx@@ITjuUPAlHPfES]FBa`@','QMDARVAyH','sJP`@dfvhA@','HeT@@DjU_k``b`@[JDIaTwCLXfF@','KAx@@IToUUPAlHPfES]FJa`@','sGP@DkYj`FsDVMcEC@','qCb@AIZ`ODH','`I@`B','KAx@@IUzmUPAlHPfES]FFa`@','sNp@DkfZj@[\\QXu`','KAx@@ITnuUPAlHPfES]F@a`@','HiD@@LddURjjh@[RDIaTwB','sNp@Dj~Zj@[\\QXuqfa`@','Hed@@Dj{uZjj@FraBXUMpr','KAx@@ITsUUPAlHPfES\\','Hid@@LdbRQk``b@AmHPfES\\LXrF@','sOp@DjWkB@@GdH','sJQ@@dkU@OH@','Hid@@DjU^nBBH@FtaBXUMpqahX@','sGP@DiYj``mfHlZ','KAx@@IToUUPAlHPfES]FLa`@','qCp@AJZ`ODH','Hmt@@DjU]ZxHHj@AmhPfES\\Lj','sGP@DkUjPFsDVM@','qC`@IVtA@','Hed@@LdbJReUUP@vTHSBinFP','sNp@DjuZj@[\\QXuqea`@','KAx@@IUkmUPAlHPfES]FNa`@','HiD@@DkVUjj`AmHPfES\\H','Hed@@DkUeZjj@FraBXUMpr','sNp@DkVZj@[\\QXuqea`@','sJP@DiVhHKZbKFLLL@','HiD@@Djuyjj`AmHPfES\\H','sNp@DjUjj@[\\QXuq`a`@','HeT@@DjYUXPbH`@[JDIaTwCH','HiD@@DjwUjj`AmHPfES\\LXRF@','sNq@@djmUPB','KAx@@YIEEZjh@vDHSBincCPp@','sGP@Di^V`dmfHlZ','Hid@@DjYUaBHP@FtaBXUMp`','sNp@DjYjj@[\\QXuqba`@','sGP@Dkej`FsDVMcKC@','HeT@@DjU^k``b`@[JDIaTwCH','qC`@Qv`MbHmFBF@','sGQ@@djmT@`','qCr@XIKTAyH','qC`@IVtAlQEhpPp@','Hid@@LdbbQxXF@@AmHPfES\\LXjF@','sGP@DkYj`FsDVMcCC@','KAx@@IVsMUPAlHPfES\\','qCp@AIj`ODl','HiD@@DkeUjj`AmHPfES\\H','deT@@DjU[k``b`@vTHSBinFP','sJP@DkVdAmQEcFRF@','HiD@@LdbJTjjh@[RDIaTwCFDa`@','HiD@@DkYyjj`AmHPfES\\H','sJP@DjZhAyH','KAx@@IVkMUPAlHPfES]FDa`@','sJX@@dkU@OI@','Hed@@LdbRQUUUP@vTHSBinFXpLL@','Hed@@DjuUZjj@FraBXUMpr','sGP@Djfj`FsDVMcKC@','sNp@DkVZj@[\\QXuqba`@','sNp@DjyZj@[\\QXuqfa`@','qCb@AIj`OH@','sNp@DjUZj@[\\QXu`','KAx@@IWOMUPAlHPfES\\','Hid@@DjU^nBBH@D','Hed@@DjuvZjj@FraBXUMpr','sJP@DiVhHKZbKFLtL@','dmt@@DjU_ZxHHj@C[PaLJfxYVLKC@','sNp@DjuZj@[\\QXuqca`@','sJP@DkfhAmQEcFJF@','sNp@LdbJZj@[\\QXu`','HeT@@DjU_k``b`@[JDIaTwCLXFF@','KAx@@IVlmUPAlHPfES]FNa`@','HeT@@LdbbRKBDQD@CYPaLJfxYcEPp@','Hid@@DjUZnBBH@FtaBXUMpqcHX@','qCa@CIKTA@','HiD@@Dj~]jj`AmHPfES\\LXFF@','sKP@Di\\Zj@[TQX`','sGP@Djfj`FsDVMcEC@','HiD@@DkgYjj`AmHPfES\\H','sNp@DjuZj@[\\QXuqaa`@','KAx@@YIMDVjh@vDHSBincDPp@','sJP@DjVhHKZbKFLTL@','Hid@@LdbRQk``b@AmHPfES\\LXZF@','HiD@@Dj}Ujj`AmHPfES\\LXzF@','HeT@@DjU_k``bP@[JDIaTwCH','sNp@DkUZi@[\\QXu`','HiD@@DjYfjj`AmHPfES\\H','sGP@DjZj`FsDVMcAC@','Hmt@@DjU_jxHHj@AmhPfES\\Lj','Hid@@LdbRQk``R@AmHPfES\\H','KAx@@YIDUJjh@vDHSBincDPp@','qCr@XIKTAyD','sOq@@drm\\@@@|`@','Hed@@DjW^jjj@FraBXUMpsFBa`@','HeT@@DjY]zXFB@@[JDIaTwCH','Hkl@@DjU_Vk``bj`@[VDIaTwCJzX','Hid@@DjY}nBHH@FtaBXUMpqcHX@','sGX@@eKuT@|d@','sGP@Dj^Y`FsDVM@','HcL@@DjU_ZnBBJh@FqaBXUMprn`','sJP@DkVdAmQEcFJF@','sOq@@drm\\@@@|b@','sNp@DjyZj@[\\QXuqaa`@','HaD@@DjUZxHH@AyD@','qC`@Qv`H','dmt@@DjU_ZxHHj@C[PaLJfxYVLYC@','sGP@Dkej`FsDVMcMC@','Hed@@DjUUjjj@FraBXUMpsFHa`@','HeT@@LdbbRkBDQD@CYPaLJfxY@','KAx@@IU{MUPAlHPfES]FLa`@','RG@DTH','sJY@DDeVhA@','KAx@@YIDUJjh@vDHSBinc@Pp@','sJX@@dkU@OI`','sJQ@@dju@OI`','HeT@@LdbbRKBDQD@CYPaLJfxYcFPp@','sFp@DiTvjhAlqEcXpPp@','HaD@@DjUZxHH@AyG@','sNx@@eJ}UPB','sNp@LddUjj@[\\QXuqca`@','HaDH@@RVU[j@@@D','sNp@DkgZi@[\\QXu`','sGY@LDeVj`D','sNp@LdbJfZBZvxbqk@','sJP`@dfvhAyL','sGX@AddQjhAxe`','Hmt@@DjU_ZxHHj@AmhPfES\\LkFIa`@','qCh@CIKTA@','sNp@LdbLjj@[\\QXuq`a`@','sOq@@drm\\@@@|a@','KAx@@IUzmUPAlHPfES]FJa`@','sNx@AddQUUPB','sGP@Di]jP`mfHlZ','sJP`@TeZhA@','KAx@@IRjmUPHKXPaLJfx','HeT@@LdbRTM\\DDT@CYPaLJfxY@','HaF@@@Rfu[j@@@D','Hid@@DjYUaBH`@FtaBXUMpqchX@','KAx@@IUjmTpAlHPfES\\','Hid@@DjU^nBBD@FtaBXUMpqcHX@','sGP@DiUj``mfHl[FFF@','KAx@@IUvmUPAlHPfES]FLa`@','Hed@@LdbQTUUUP@vTHSBinFXqDL@','sJP@DkVhA@','sOx@@drm\\@@@|b@','KAx@@IUkMUPAlHPfES]FDa`@','HeT@@LdbRQU\\DDT@CYPaLJfxY@','HiD@@Dj}Yjj`AmHPfES\\LXrF@','HiD@@Dj{ujj`AmHPfES\\LXFF@','KAx@@IWNmUPAlHPfES]FFa`@','KAx@@IRkMUPHKXPaLJfx','sJP@DjYdAmQEcFZF@','sJY@LDeZhAyL','HaDH@@RVU[f@@@D','sJP`@deVhAyB','HaD@@DjWjZjj`AlHPfES\\','sGP@DkYj`FsDVMcMC@','sNp@DkgZj@[\\QXuqea`@','sJQ@@dlu@H','HeT@@DjU]k``b`@[JDIaTwCLXrF@','sJX@@dkU@OH`','RFDDQFCr`','sJP@DiYXIKZbKFLLL@','KAx@@YIHjjjh@vDHSBincGPp@','Hk\\@@DjU^ukmLHH@@@AmXPfES\\Lki`','sGQ@@djmT@|b@','Hid@@DjUfaBB`@FtaBXUMpqahX@','sNx@@eRmUPB','Hmt@@LdbRVak``ah@FvaBXUMprh','qCr@XIJtA@','KAx@@IWMmUPAlHPfES]FNa`@','HeT@@DjYYZPbJ@@[JDIaTwCH','sNp@DkfZj@[\\QXuqea`@','Hid@@DjU^nBAHAEVtaBXUMp`','dmt@@DjUgZDHJJ@C[PaLJfxYT','sGP@DkejPFsDVM@','sNx@@eJmUPB','qCb@AIf`H','HcL@@DjU_VnBBJh@FqaBXUMprnqcXX@','Hid@@DjUZnBBH@FtaBXUMpqahX@','sNp@LdbQZjBBvxbqkcGC@','sOx@@drm\\@@@|c@','sJP@H~j@^R@','KAx@@YIDcFjhDElHPfES\\','Hid@@DjUZnBAH@FtaBXUMp`','sNp@LddUji@[\\QXu`','sGP@DjfjPFsDVM@','HeT@@DjYUXPbD`@[JDIaTwCH','KAx@@IUoMUPAlHPfES]FDa`@','sFp@DiTt@@AyaD','Hed@@DjuuZjj@FraBXUMpsFIa`@','HeT@@DjUghP`h`@[JDIaTwCLXfF@','sOp@DjWkjj`FwDVM\\YhX@','sGP@Djfj`FsDVMcIC@','KAx@@IRkmUPHKXPaLJfzL]C@','sNx@@djmUPB','QM`AIdD','sOp@DjWkB@@Gbe@','sNp@DjyZj@[\\QXuqca`@','QM@HuAmd`','sNp@LddUjj@[\\QXuqea`@','daD@@DjUZxHD@CXPaLJfzLYC@','qCb@AIZPH','HiD@@LdbJTjjh@[RDIaTwCF@a`@','Hmt@@DjU_ZxHHi@AmhPfES\\Lj','HaDH@@RYWih@H@D','HiD@@LdbJTjjh@[RDIaTwCFHa`@','sGX@@djuT@|a@','sNp@DkfZj@[\\QXuqaa`@','Hid@@DjU^nBBH@GdL','KAx@@IVkMUPAlHPfES]FJa`@','qCr@XIKTAy@','HmT@@Dj{uVjjh@[ZDIaTwCJqaXX@','dmt@@DjYWVDHbJ@C[PaLJfxYT','Hif@@@RUe^Fh@@@P','HaDH@@Rfu[j@@@GdH','KAx@@IVsMUPAlHPfES]FDa`@','sKP@Di\\Zj@[TQXq`a`@','sJX@@eMU@OH@','HeT@@DjU^k``b`@[JDIaTwCLXFF@','Hmt@@LdbbRJXPbHh@FvaBXUMprh','sJP@DjvhAmQEcFBF@','dmt@@LdbbRNXPbHh@MmBDpj[aeXplL@','sJP`@dfvhAyD','sGP@Di^V`dmfHl[FVF@','KAx@@IVsmUPAlHPfES]FBa`@','sOq@@drm\\@@@|PP','sJY@BDeZhA@','HeT@@LdbRbmBDED@CYPaLJfxY@','Hed@@Djy[Zjj@FraBXUMpr','HeT@@DjU]k``b`@[JDIaTwCLXFF@','Hid@@DjUfaBB`@D','qCa@CIJtA@','QMPARVA@','Hid@@DjUfaBB`@FtaBXUMpqcHX@','sJY@BDfZhA@','HeT@@DjUghP`hP@[JDIaTwCH','Hed@@Dj{uZjj@FraBXUMpsFIa`@','dmt@@DjYUvDHbJ@C[PaLJfxYVLUC@','sNp`@dfuZj@P','sJQ@@dmU@OH@','sJX@@dmU@H','HeT@@DjU]k``b`@[JDIaTwCLXZF@','HiD@@LdfbJZjh@[RDIaTwCFAa`@','sOx@@drm\\@@@|a@','deT@@DjUfhP`h`@vTHSBinFP','dmt@@DjU]ZxHHj@C[PaLJfxYVLKC@','sOp@DjWkjj`FwDVM\\XHX@','HcL@@LdbbRNSBDQEP@McBDpj[ae]cFpp@','HiD@@Dj}Yji`AmHPfES\\H','HaDH@@RYe[hB@@D','Hid@@DjU^njjj@FtaBXUMpq`XX@','deT@@LdbbRKBDQB@FraBXUMpr','QMPARZA@','sOq@@drm\\@@@|QX','HaD@@DjYvxH`@A@','HcL@@LdbbRNcBDQEP@McBDpj[ae]@','QMhDRZA@','RG@DXLHmP','QM`BN`XQYd','RG@DTLHmP','QMHAIXFEVd','QMDARVAaH','RFPDXLHmP','RF@Q`vRbdLEC@','RF@QpvR@','QO@HyjAmd`','`II@B','`II@CFspqJp','`II@CF[@hM@prB`','`H@[T[|B`XN@PdM@p|@bHrBcDk@','RG@DXMj}F@','QM`BN`[L~b@','RG@DTMj}D@','QMHAIXFt~j@','QMDARVA}L@','RFPDXMj}D@','sKP@Di\\YZ@[TQXqaa`@','eF`BHD']);};ZXb.Us=function Us(a,b){var c,d;if(!b)return null;d=Rjb(TXb.klb,xZb,6,(ZXb.Rs.length+31)/32|0,15,1);b=ZXb.Zs(b);ZXb.Gs(a.e,b);for(c=0;c<ZXb.Rs.length;c++){ZXb.Es(a.e,ZXb.Ss[c]);ZXb.ss(a.e,1,4)>0&&(d[c/32|0]|=1<<31-c%32);}return d;};ZXb.Vs=function Vs(a,b){var c,d;if(!b)return null;d=Rjb(TXb.llb,M$b,6,(ZXb.Rs.length+63)/64|0,14,1);b=ZXb.Zs(b);ZXb.Gs(a.e,b);for(c=0;c<ZXb.Rs.length;c++){ZXb.Es(a.e,ZXb.Ss[c]);ZXb.ss(a.e,1,4)>0&&(d[c/64|0]=dxb(d[c/64|0],exb(1,63-c%64)));}return d;};ZXb.Ws=function Ws(){var a,b;if(ZXb.Ss==null){b=new ZXb.Kp(false);ZXb.Ss=Rjb(TXb.emb,Q_b,24,ZXb.Rs.length,0,1);for(a=0;a<ZXb.Rs.length;a++){ZXb.Ss[a]=ZXb.xp(b,ZXb.Rs[a]);ZXb.nu(ZXb.Ss[a],1);}}};ZXb.Xs=function Xs(a){var b;if(a.d!=null){for(b=0;b<a.d.length;b++)if((a.b[b]&~a.d[b])!=0)return false;}else {return false;}return ZXb.Ys(a);};ZXb.Ys=function Ys(a){!a.c&&(a.c=(new ZXb.Kp(false),null));!a.a&&(a.a=(new ZXb.Kp(false),null));ZXb.Gs(a.e,a.c);ZXb.Es(a.e,a.a);return ZXb.zs(a.e);};ZXb.Zs=function Zs(a){var b,c;if(a.K){for(b=0;b<a.q;b++){if(bxb(Iwb(a.B[b],KZb),0)){a=new ZXb.Hu(a);for(c=b;c<a.q;c++)bxb(Iwb(a.B[c],KZb),0)&&(a.C[c]=-1);ZXb.tk(a);}}}return a;};ZXb.$s=function $s(a,b,c){a.a=b;c==null?a.b=ZXb.Us(a,b):a.b=c;};ZXb._s=function _s(a,b,c){a.c=b;c==null?a.d=ZXb.Us(a,b):a.d=c;};ZXb.at=function at(){ZXb.Ts();this.e=new ZXb.Ms();ZXb.Ws();};ZXb.bt=function bt(a){ZXb.Ts();var b,c,d,e,f,g;if(a==null)return null;b=Rjb(TXb.glb,R$b,6,a.length*8,15,1);for(d=0;d<a.length;d++){g=a[d];for(e=7;e>=0;e--){c=g&15;c>9&&(c+=7);b[d*8+e]=48+c<<24>>24;g>>=4;}}return UXb.VHb(XXb.jTb(b,0,(f=b.length,XXb.gTb(),f)));};ZXb.ct=function ct(a){ZXb.Ts();var b,c,d,e;if(XXb.KTb(a).length==0||(XXb.KTb(a).length&7)!=0)return null;d=Rjb(TXb.klb,xZb,6,XXb.KTb(a).length/8|0,15,1);for(c=0;c<XXb.KTb(a).length;c++){e=c/8|0;b=(XXb.FTb(c,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(c)-48);b>16&&(b-=7);d[e]<<=4;d[e]+=b;}return d;};ZXb.dt=function dt(a,b){ZXb.Ts();var c,d,e,f;f=0;d=0;e=0;for(c=0;c<a.length;c++){f+=IGb(a[c]&b[c]);d+=IGb(a[c]);e+=IGb(b[c]);}return f/$wnd.Math.sqrt(d*e);};ZXb.et=function et(a,b){ZXb.Ts();var c,d,e;e=0;c=0;for(d=0;d<a.length;d++){e+=IGb(a[d]&b[d]);c+=IGb(a[d]|b[d]);}return e/c;};wxb(196,1,{},ZXb.at);TXb.Wlb=UFb(196);ZXb.gt=function gt(a){a.j=1;a.k=10;a.n=400;a.f=400;a.i=true;a.d='black';a.b=new $Xb.kj();a.a=new $Xb.kj();a.c=new UXb.iIb();a.e=new OYb.rEb(12);};ZXb.ht=function ht(a,b){var c,d;c=(d=OYb.pEb(a.e,b),new PYb.LEb(d)).b;return c;};ZXb.it=function it(a){return a.k;};ZXb.jt=function jt(a){var b,c,d,e,f,g;f='<svg id="'+(a.g!=null?a.g:'mol'+ZXb.ft)+R_b+'xmlns="http://www.w3.org/2000/svg" version="1.1" '+'width="'+a.n+'px" '+'height="'+a.f+'px" '+'viewBox="0 0 '+a.n+' '+a.f+'">\n';g=a.i?'<style> #'+(a.g!=null?a.g:'mol'+ZXb.ft)+' { pointer-events:none; }'+' #'+(a.g!=null?a.g:'mol'+ZXb.ft)+' .event '+' { pointer-events:all; }'+' line { stroke-linecap:round; }'+' polygon { stroke-linejoin:round; }'+' <\/style>\n':'<g style="font-size:'+a.k+'px; fill-opacity:1; stroke-opacity:1; fill:black; stroke:black;'+' font-weight:normal; text-rendering:optimizeLegibility; font-family:sans-serif;'+' stroke-linejoin:round; stroke-linecap:round; stroke-dashoffset:0;">';f+='  ';f+=g;if(a.i){for(e=new $Xb.qOb(a.b);e.a<e.c.a.length;){d=$Xb.pOb(e);ZXb.kt(a,d);}for(c=new $Xb.qOb(a.a);c.a<c.c.a.length;){b=$Xb.pOb(c);ZXb.kt(a,b);}}a.i||ZXb.kt(a,'<\/g>');return f+a.c.a+'<\/svg>';};ZXb.kt=function kt(a,b){UXb.fIb(a.c,'  ');UXb.fIb(a.c,b);UXb.fIb(a.c,$Yb);};ZXb.lt=function lt(a,b,c){ZXb.Qc();ZXb.Td.call(this,a,b);ZXb.gt(this);this.g=c;++ZXb.ft;};ZXb.mt=function mt(a){ZXb.Qc();ZXb.lt.call(this,a,0,null);};wxb(195,144,{144:1},ZXb.lt,ZXb.mt);_.mb=function nt(a){var b;b='<line x1="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(a.a),(RYb.GKb(),RYb.CKb))))+R_b+'y1="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(a.c),RYb.CKb)))+R_b+'x2="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(a.b),RYb.CKb)))+R_b+'y2="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(a.d),RYb.CKb)))+R_b+S_b+this.d+R_b+T_b+this.j+U_b;ZXb.kt(this,b);};_.nb=function ot(a){var b,c;b=UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(3*this.j),(RYb.GKb(),RYb.CKb))));c='<line stroke-dasharray="'+b+','+b+R_b+'x1="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(a.a),RYb.CKb)))+R_b+'y1="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(a.c),RYb.CKb)))+R_b+'x2="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(a.b),RYb.CKb)))+R_b+'y2="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(a.d),RYb.CKb)))+R_b+S_b+this.d+R_b+'stroke-width:'+this.j+U_b;ZXb.kt(this,c);};_.ob=function pt(a){var b,c;c=new UXb.kIb('<polygon points="');for(b=0;b<a.a;b++){UXb.dIb(c,Twb($wnd.Math.round(a.b[b])));c.a+=',';UXb.dIb(c,Twb($wnd.Math.round(a.c[b])));c.a+=' ';}UXb.fIb(c,'" fill="'+this.d+R_b+S_b+this.d+R_b+T_b+this.j+U_b);ZXb.kt(this,c.a);};_.pb=function qt(a,b,c){var d,e,f,g;f=(d=(g=OYb.pEb(this.e,a),new PYb.LEb(g)).b,d);e='<text x="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(b-f/2),(RYb.GKb(),RYb.CKb))))+R_b+'y="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(c+this.k/3),RYb.CKb)))+R_b+'stroke="none" '+'font-size="'+this.e.b+R_b+'fill="'+this.d+'">'+a+'<\/text>';ZXb.kt(this,e);};_.qb=function rt(a,b,c){var d;d='<circle cx="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(a+c/2),(RYb.GKb(),RYb.CKb))))+R_b+'cy="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(b+c/2),RYb.CKb)))+R_b+'r="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(c/2),RYb.CKb)))+R_b+'fill="'+this.d+U_b;ZXb.kt(this,d);};_.rb=function st(a){return ZXb.ht(this,a);};_.sb=function tt(){return ZXb.it(this);};_.tb=function ut(a,b,c,d){var e;e='<circle id="'+(this.g!=null?this.g:'mol'+ZXb.ft)+':Atom:'+a+R_b+V_b+'data-atom-map-no="'+ZXb.Ik(this.K,a)+R_b+'cx="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(c),(RYb.GKb(),RYb.CKb))))+R_b+'cy="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(d),RYb.CKb)))+R_b+'r="'+8+R_b+W_b;$Xb.Si(this.a,e);};_.ub=function vt(a,b,c,d,e){var f;f='<line id="'+(this.g!=null?this.g:'mol'+ZXb.ft)+':Bond:'+a+R_b+V_b+'x1="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(b),(RYb.GKb(),RYb.CKb))))+R_b+'y1="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(c),RYb.CKb)))+R_b+'x2="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(d),RYb.CKb)))+R_b+'y2="'+UXb.lGb(RYb.HIb(RYb.EIb(new RYb.IIb(e),RYb.CKb)))+R_b+T_b+8+R_b+W_b;$Xb.Si(this.b,f);};_.wb=function wt(a){this.j=jxb(Twb($wnd.Math.round(100*$wnd.Math.max(a,1))))/100;};_.xb=function xt(a){this.d='rgb('+((a&X_b)>>16)+','+((a&zZb)>>8)+','+(a&255)+')';};_.yb=function yt(a){if(this.k!=a){this.k=a;this.e=new OYb.rEb(a);}};_.zb=function zt(a,b){this.n=kxb(Twb($wnd.Math.round(a.b)));this.f=kxb(Twb($wnd.Math.round(a.a)));return ZXb.Pd(this,a,b);};_.lb=function At(){return ZXb.jt(this);};_.f=0;_.i=false;_.j=0;_.k=0;_.n=0;ZXb.ft=0;TXb.Ylb=UFb(195);ZXb.Bt=function Bt(a,b){var c;if(a.c!=null)for(c=0;c<a.c.length;c++)if(b==a.c[c]&&a.d[c])return true;return false;};ZXb.Ct=function Ct(a,b,c,d,e){this.a=a;this.b=b;this.g=c;this.f=d;this.e=e;};wxb(210,1,{210:1},ZXb.Ct);_.a=0;_.b=0;_.e=false;_.f=false;_.g=0;TXb.Zlb=UFb(210);ZXb.Dt=function Dt(a,b){var c,d,e,f;f=false;a.b=b;ZXb.nu(a.b,15);c=a.b.f;d=a.b.g;a.j=Rjb(TXb.Bwb,JZb,6,d,16,1);for(e=0;e<d;++e)a.j[e]=false;a.g=Rjb(TXb.Bwb,JZb,6,c,16,1);a.c=Rjb(TXb.klb,xZb,6,c,15,1);for(e=0;e<c;++e){a.g[e]=false;a.c[e]=-1;}a.e=Rjb(TXb.Nub,mZb,2,3*c,6,1);a.i=0;a.d=0;a.a=0;while(!f){for(e=0;e<c;++e){if(!a.g[e]){a.a>0&&(a.e[a.i++]='.');ZXb.Ft(a,e,-1);++a.a;break;}}e==c&&(f=true);}a.f='';for(e=0;e<a.i;++e)a.f+=''+a.e[e];return a.f;};ZXb.Et=function Et(a){switch(a){case 5:case 6:case 7:case 8:case 9:case 15:case 16:case 17:case 35:case 53:return true;default:return false;}};ZXb.Ft=function Ft(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;d=true;i=0;p=0;m=a.i;a.c[b]=m;h=ZXb.Qk(a.b,b);g=ZXb.Fk(a.b,b);e=ZXb.zk(a.b,b);f=ZXb.Jk(a.b,b);k=ZXb.Sn(a.b,b);e==0&&f==0&&ZXb.Et(h)&&(d=false);a.e[m]='';if(c!=-1){switch(ZXb.bl(a.b,c)){case 0:a.e[m]+='~';break;case 2:a.e[m]+='=';break;case 3:a.e[m]+='#';}}d&&(a.e[m]+='[');f!=0&&(a.e[m]+=''+f);a.e[m]+=''+g;if(d){if(0<(o=ZXb.fo(a.b,b))){a.e[m]+='H';1<o&&(a.e[m]+=o);}}if(e!=0){e>0?a.e[m]+='+':a.e[m]+='-';$wnd.Math.abs(e)>1&&(a.e[m]+=''+$wnd.Math.abs(e));}d&&(a.e[m]+=']');c!=-1&&(a.j[c]=true);a.g[b]=true;++a.i;for(n=0;n<k;++n)a.j[ZXb.Tn(a.b,b,n)]||++i;for(n=0;n<k;++n){j=ZXb.Rn(a.b,b,n);l=ZXb.Tn(a.b,b,n);if(a.j[l]){++p;continue;}if(a.g[j]){++a.d;a.j[l]=true;switch(ZXb.bl(a.b,l)){case 0:a.e[a.c[j]]+='~';a.e[m]+='~';break;case 2:a.e[a.c[j]]+='=';a.e[m]+='=';break;case 3:a.e[a.c[j]]+='#';a.e[m]+='3';}if(a.d>9){a.e[a.c[j]]+='%';a.e[m]+='%';}a.e[a.c[j]]+=''+a.d;a.e[m]+=''+a.d;continue;}n-p<i-1&&(a.e[a.i++]='(');ZXb.Ft(a,j,l);n-p<i-1&&(a.e[a.i++]=')');}};ZXb.Gt=function Gt(){};wxb(327,1,{},ZXb.Gt);_.a=0;_.d=0;_.i=0;TXb.$lb=UFb(327);ZXb.Ht=function Ht(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;j=Rjb(TXb.klb,xZb,6,a.i.f,15,1);h=Rjb(TXb.klb,xZb,6,a.i.f,15,1);i=Rjb(TXb.klb,xZb,6,a.i.f,15,1);k=Rjb(TXb.klb,xZb,6,a.i.f,15,1);c=ZXb.Vk(a.i,0,b);d=ZXb.Vk(a.i,1,b);h[0]=c;h[1]=d;i[0]=-1;i[1]=b;j[c]=1;j[d]=2;k[c]=-1;k[d]=c;g=1;l=1;while(g<=l&&j[h[g]]<15){o=h[g];for(m=0;m<ZXb.Sn(a.i,o);m++){e=ZXb.Rn(a.i,o,m);if(e!=k[o]){f=ZXb.Tn(a.i,o,m);if(e==c){i[0]=f;for(n=0;n<=l;n++){if(!a.f[i[m]]){a.f[i[m]]=true;++a.c;}}return;}if(ZXb.El(a.i,e)&&j[e]==0){++l;h[l]=e;i[l]=f;j[e]=j[o]+1;k[e]=o;}}}++g;}return;};ZXb.It=function It(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;ZXb.nu(a.i,7);l=false;m=Rjb(TXb.klb,xZb,6,2,15,1);n=Rjb(TXb.klb,xZb,6,2,15,1);k=Rjb(TXb.klb,xZb,6,2,15,1);for(d=0;d<a.i.g;d++){if(!ZXb.Yo(a.i,d)&&ZXb.el(a.i,d)==2){for(g=0;g<2;g++){m[g]=-1;k[g]=-1;b=ZXb.Vk(a.i,g,d);for(j=0;j<ZXb.Sn(a.i,b);j++){e=ZXb.Tn(a.i,b,j);if(e!=d){if(m[g]==-1&&(ZXb.el(a.i,e)==257||ZXb.el(a.i,e)==129)){m[g]=ZXb.Rn(a.i,b,j);n[g]=e;}else {k[g]=ZXb.Rn(a.i,b,j);}}}if(m[g]==-1)break;}if(m[0]!=-1&&m[1]!=-1){i=ZXb.el(a.i,n[0])==ZXb.el(a.i,n[1]);for(h=0;h<2;h++)m[h]==ZXb.Vk(a.i,0,n[h])&&(i=!i);for(f=0;f<2;f++)k[f]!=-1&&k[f]<m[f]&&(i=!i);ZXb.Cm(a.i,d,i?2:1,false);l=true;}}}for(c=0;c<a.i.g;c++)(ZXb.el(a.i,c)==257||ZXb.el(a.i,c)==129)&&ZXb.Fm(a.i,c,1);return l;};ZXb.Jt=function Jt(a){return a==61?2:a==35?4:a==36?32:a==58?8:a==62?16:a==126?31:1;};ZXb.Kt=function Kt(a,b){var c,d,e,f,g,h,i,j,k,l,m;for(c=0;c<a.i.f;c++){if(ZXb.El(a.i,c)){i=Rjb(TXb.klb,xZb,6,a.i.f,15,1);h=Rjb(TXb.klb,xZb,6,a.i.f,15,1);j=Rjb(TXb.klb,xZb,6,a.i.f,15,1);h[0]=c;i[c]=1;j[c]=-1;g=0;k=0;while(g<=k){e=(i[h[g]]&1)==1?1:2;for(l=0;l<ZXb.Sn(a.i,h[g]);l++){d=ZXb.Tn(a.i,h[g],l);if(ZXb.bl(a.i,d)==e&&b[d]){f=ZXb.Rn(a.i,h[g],l);if(i[f]==0){if(e==1&&ZXb.El(a.i,f)){m=h[g];while(m!=-1){ZXb.Fm(a.i,ZXb.Pn(a.i,f,m),e==1?2:1);e=3-e;f=m;m=j[m];}ZXb.lm(a.i,c,false);ZXb.lm(a.i,f,false);a.b-=2;return true;}h[++k]=f;j[f]=h[g];i[f]=i[h[g]]+1;}}}++g;}}}return false;};ZXb.Lt=function Lt(a){var b,c,d,e;for(b=0;b<a.i.f;b++){if(ZXb.Qk(a.i,b)==7&&ZXb.zk(a.i,b)==0&&ZXb.ko(a.i,b)>3&&ZXb.In(a.i,b)>0){for(e=0;e<ZXb.Sn(a.i,b);e++){c=ZXb.Rn(a.i,b,e);d=ZXb.Tn(a.i,b,e);if(ZXb.bl(a.i,d)>1&&ZXb.Cl(a.i,c)){ZXb.el(a.i,d)==4?ZXb.Fm(a.i,d,2):ZXb.Fm(a.i,d,1);ZXb.cm(a.i,b,ZXb.zk(a.i,b)+1);ZXb.cm(a.i,c,ZXb.zk(a.i,c)-1);ZXb.am(a.i,b,-1);break;}}}}};ZXb.Mt=function Mt(a){return !a.n?'':'Unresolved SMARTS features:'+a.n;};ZXb.Nt=function Nt(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K;ZXb.nu(a.i,1);a.f=Rjb(TXb.Bwb,JZb,6,a.i.g,16,1);a.c=0;for(k=0;k<a.i.g;k++){if(ZXb.el(a.i,k)==64){ZXb.Fm(a.i,k,1);a.f[k]=true;++a.c;}}w=Rjb(TXb.Bwb,JZb,6,a.i.f,16,1);K=new ZXb.gs(a.i,3);v=Rjb(TXb.Bwb,JZb,6,K.i.a.length,16,1);for(G=0;G<K.i.a.length;G++){I=$Xb.Xi(K.i,G);v[G]=true;for(q=0;q<I.length;q++){if(!ZXb.El(a.i,I[q])){v[G]=false;break;}}if(v[G]){for(r=0;r<I.length;r++)w[I[r]]=true;J=$Xb.Xi(K.j,G);for(s=0;s<J.length;s++){if(!a.f[J[s]]){a.f[J[s]]=true;++a.c;}}}}for(l=0;l<a.i.g;l++){!a.f[l]&&(K.b[l]&oZb)!=0&&ZXb.El(a.i,ZXb.Vk(a.i,0,l))&&ZXb.El(a.i,ZXb.Vk(a.i,1,l))&&ZXb.Ht(a,l);}for(m=0;m<a.i.g;m++){if(!a.f[m]){e=ZXb.Vk(a.i,0,m);f=ZXb.Vk(a.i,1,m);if(!w[e]&&!w[f]&&ZXb.El(a.i,e)&&ZXb.El(a.i,f)){a.f[m]=true;++a.c;}}}ZXb.nu(a.i,7);u=Rjb(TXb.Bwb,JZb,6,a.i.g,16,1);for(t=0;t<a.i.g;t++)u[t]=a.f[t];for(H=0;H<K.i.a.length;H++){if(v[H]){I=$Xb.Xi(K.i,H);for(p=0;p<I.length;p++){if(!ZXb.Ut(a,I[p])){if(ZXb.El(a.i,I[p])){ZXb.lm(a.i,I[p],false);--a.b;}for(B=0;B<ZXb.Sn(a.i,I[p]);B++){o=ZXb.Tn(a.i,I[p],B);if(a.f[o]){a.f[o]=false;--a.c;}}}}}}ZXb.Tt(a);for(F=0;F<K.i.a.length;F++){if(v[F]&&$Xb.Xi(K.j,F).length==6){J=$Xb.Xi(K.j,F);A=true;for(h=J,i=0,j=h.length;i<j;++i){g=h[i];if(!a.f[g]){A=false;break;}}if(A){ZXb.St(a,J[0]);ZXb.St(a,J[2]);ZXb.St(a,J[4]);ZXb.Tt(a);}}}for(D=5;D>=4;D--){do{C=false;for(g=0;g<a.i.g;g++){if(a.f[g]){c=0;for(p=0;p<2;p++){n=ZXb.Vk(a.i,p,g);for(B=0;B<ZXb.Sn(a.i,n);B++)a.f[ZXb.Tn(a.i,n,B)]&&++c;}if(c==D){ZXb.St(a,g);ZXb.Tt(a);C=true;break;}}}}while(C);}while(a.b>=2)if(!ZXb.Kt(a,u))break;if(b){if(a.b!=0){for(d=0;d<a.i.f;d++){if(ZXb.El(a.i,d)){ZXb.lm(a.i,d,false);ZXb.om(a.i,d,2,true);--a.b;}}}if(a.c!=0){for(g=0;g<a.i.g;g++){if(a.f[g]){a.f[g]=false;ZXb.Fm(a.i,g,64);--a.c;}}}}else {for(d=0;d<a.i.f;d++){if(ZXb.El(a.i,d)&&ZXb.fo(a.i,d)!=0){ZXb.lm(a.i,d,false);ZXb.pm(a.i,d,32);--a.b;}}}if(a.b!=0)throw Gwb(new UXb.aA(Y_b));if(a.c!=0)throw Gwb(new UXb.aA(Y_b));};ZXb.Ot=function Ot(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab,bb,cb,db,eb,fb,gb,hb,ib,jb,kb,lb,mb,nb,ob,pb,qb,rb,sb,tb,ub,vb,wb,xb,yb,zb,Ab;a.i=b;ZXb.hk(a.i);!!a.n&&UXb.ZEb(a.n,0);a.b=0;i=a.k!=0;fb=null;p=Rjb(TXb.klb,xZb,6,32,15,1);p[0]=-1;lb=Rjb(TXb.klb,xZb,6,16,15,1);ob=Rjb(TXb.klb,xZb,6,16,15,1);nb=Rjb(TXb.klb,xZb,6,16,15,1);mb=Rjb(TXb.klb,xZb,6,16,15,1);for(M=0;M<16;M++)lb[M]=-1;m=0;H=-1;rb=false;P=false;qb=false;u=0;s=1;r=0;l=new xYb.E6();gb=new ZXb.fu(c);while(c[d]<=32)++d;while(d<e){tb=c[d++]&oZb;if(CFb(tb)||tb==42||tb==63||tb==33&&i&&rb||tb==35&&i&&rb){o=-1;w=0;W=0;h=-1;F=-1;eb=false;O=false;n=0;if(rb){if(tb==42){o=6;n=kxb(dxb(TXb.Qwb(n),1));}else if(tb==63){o=0;}else if(tb==35){Z=0;while(d<e&&BFb(c[d]&oZb)){Z=10*Z+c[d]-48;++d;}if(Z<1||Z>=(ZXb.Sj(),ZXb.Mj).length)throw Gwb(new UXb.aA('SmilesParser: Atomic number out of range.'));o=Z;}else {Q=tb==33;if(Q){qb=true;n=kxb(dxb(TXb.Qwb(n),1));++d;}if(c[d-1]==82&&i&&(BFb(c[d]&oZb)||a.a&&c[d]==123)){o=6;n=kxb(dxb(TXb.Qwb(n),1));--d;Q&&--d;}else {R=FFb(c[d]&oZb)==(c[d]&oZb)&&CFb(c[d]&oZb)?2:1;o=(ZXb.Sj(),ZXb.hn(UXb.VHb(XXb.jTb(c,d-1,(T=R,XXb.gTb(),T))),321));if(o==-1){o=6;n=kxb(dxb(TXb.Qwb(n),1));--d;}else {d+=R-1;F=9;if(i&&(c[d]==44||Q)){ub=false;V=false;sb=d-R;for(bb=sb;bb<c.length;bb++){if(!CFb(c[bb]&oZb)){Y=ZXb.hn(UXb.VHb(XXb.jTb(c,sb,(S=bb-sb,S))),321);if(Y!=0){xYb.z6(l,UXb.TGb(Y));HFb(c[sb]&oZb)==(c[sb]&oZb)&&CFb(c[sb]&oZb)?ub=true:V=true;}sb=bb+1;if(c[bb]!=44)break;if(c[bb+1]==33){if(!Q)throw Gwb(new UXb.aA("SmilesParser: inconsistent '!' in atom list."));++bb;++sb;}}}if(l.d.a.length>1){F=-1;ub?V||(n=kxb(dxb(TXb.Qwb(n),4))):n=kxb(dxb(TXb.Qwb(n),2));}d=sb-1;}}}}while(rb){if(c[d]==64){++d;if(c[d]==64){O=true;++d;}eb=true;continue;}if(c[d]==58){++d;while(BFb(c[d]&oZb)){W=10*W+c[d]-48;++d;}continue;}if(c[d]==91)throw Gwb(new UXb.aA('SmilesParser: nested square brackets found'));if(c[d]==93){++d;rb=false;continue;}if(c[d]==43){w=1;++d;while(c[d]==43){++w;++d;}if(w==1&&BFb(c[d]&oZb)){w=c[d]-48;++d;}w==0&&(n=kxb(dxb(TXb.Qwb(n),YZb)));continue;}if(c[d]==45){w=-1;++d;while(c[d]==45){--w;++d;}if(w==-1&&BFb(c[d]&oZb)){w=48-c[d];++d;}w==0&&(n=kxb(dxb(TXb.Qwb(n),YZb)));continue;}Q=c[d]==33;Q&&++d;if(c[d]==72){++d;d+=ZXb.cu(gb,c,d,1);F=gb.c;G=0;gb.c<=0&&gb.b>=0&&(G=kxb(dxb(TXb.Qwb(G),128)));gb.c<=1&&gb.b>=1&&(G=kxb(dxb(TXb.Qwb(G),256)));gb.c<=2&&gb.b>=2&&(G=kxb(dxb(TXb.Qwb(G),512)));gb.c<=3&&gb.b>=3&&(G=kxb(dxb(TXb.Qwb(G),WZb)));if(Q){n|=G;F=-1;}else {if(gb.b==gb.c){F=gb.c;}else {n=kxb(dxb(TXb.Qwb(n),Iwb(VZb,TXb.Qwb(~G))));F=-1;}}continue;}if(c[d]==68){++d;d+=ZXb.cu(gb,c,d,1);G=0;gb.c<=0&&gb.b>=0&&(G=dxb(G,S$b));gb.c<=1&&gb.b>=1&&(G=dxb(G,F$b));gb.c<=2&&gb.b>=2&&(G=dxb(G,E$b));gb.c<=3&&gb.b>=3&&(G=dxb(G,V$b));gb.c<=4&&gb.b>=4&&(G=dxb(G,f$b));if(Nwb(G,0)!=0){Q||(G=mxb(G,a$b));n=kxb(dxb(TXb.Qwb(n),G));}continue;}if(c[d]==122&&a.a){++d;d+=ZXb.cu(gb,c,d,4);G=0;gb.c<=0&&gb.b>=0&&(G=dxb(G,p$b));gb.c<=1&&gb.b>=1&&(G=dxb(G,Z_b));gb.c<=2&&gb.b>=2&&(G=dxb(G,$_b));gb.c<=3&&gb.b>=3&&(G=dxb(G,__b));gb.c<=4&&gb.b>=4&&(G=dxb(G,o$b));if(Nwb(G,0)!=0){Q||(G=mxb(G,j$b));n=kxb(dxb(TXb.Qwb(n),G));}continue;}if(c[d]==88){++d;d+=ZXb.cu(gb,c,d,1);Ab=(ZXb.Sj(),ZXb.Nj)[o];if(Ab==null)continue;wb=Ab[0];G=0;wb-gb.c<=0&&wb-gb.b>=0&&(G=dxb(G,QZb));wb-gb.c<=1&&wb-gb.b>=1&&(G=dxb(G,l_b));wb-gb.c<=2&&wb-gb.b>=2&&(G=dxb(G,nZb));if(Nwb(G,0)!=0){Q||(G=mxb(G,_Zb));n=kxb(dxb(TXb.Qwb(n),G));}continue;}if(c[d]==65||c[d]==97){++d;n=kxb(dxb(TXb.Qwb(n),Q^c[d]==65?4:2));continue;}if(c[d]==82){++d;d+=ZXb.cu(gb,c,d,3);G=0;gb.c<=0&&gb.b>=0&&(G=dxb(G,8));gb.c<=1&&gb.b>=1&&(G=dxb(G,16));gb.c<=2&&gb.b>=2&&(G=dxb(G,32));gb.c<=3&&gb.b>=3&&(G=dxb(G,64));gb.b>3&&ZXb.Wt(a,(Q?'!R':'R')+gb.b);if(Nwb(G,0)!=0){Q||(G=mxb(G,120));n=kxb(dxb(TXb.Qwb(n),G));}continue;}if(c[d]==114){++d;d+=ZXb.cu(gb,c,d,1);if(gb.a){Q?n=kxb(dxb(TXb.Qwb(n),384)):n=kxb(dxb(TXb.Qwb(n),8));continue;}pb=gb.c;gb.b>gb.c&&ZXb.Wt(a,(Q?'!r':'r')+('{'+gb.c+'-'+gb.b+'}'));!Q&&pb>=3&&pb<=7?n|=pb<<22:gb.b>gb.c||ZXb.Wt(a,(Q?'!r':'r')+pb);continue;}if(c[d]==118){++d;d+=ZXb.cu(gb,c,d,1);wb=gb.c;gb.b>gb.c&&ZXb.Wt(a,(Q?'!v':'v')+('{'+gb.c+'-'+gb.b+'}'));!Q&&wb<=14?h=wb:gb.b>gb.c||ZXb.Wt(a,(Q?'!v':'v')+wb);continue;}if(i&&(c[d]==59||c[d]==38)){qb=true;++d;continue;}throw Gwb(new UXb.aA("SmilesParser: unexpected character inside brackets: '"+String.fromCharCode(c[d]&oZb)+"'"));}}else if(tb==42){o=6;n=kxb(dxb(TXb.Qwb(n),1));}else if(tb==63){o=0;}else if((tb==65||tb==97)&&i){o=6;n=kxb(dxb(TXb.Qwb(n),1));n=kxb(dxb(TXb.Qwb(n),tb==65?4:2));qb=true;}else {switch(HFb(tb)){case 66:if(d<e&&c[d]==114){o=35;++d;}else o=5;break;case 67:if(d<e&&c[d]==108){o=17;++d;}else o=6;break;case 70:o=9;break;case 73:o=53;break;case 78:o=7;break;case 79:o=8;break;case 80:o=15;break;case 83:o=16;}}if(o==-1&&tb!=63)throw Gwb(new UXb.aA('SmilesParser: unknown element label found'));k=ZXb.Uj(a.i,o);ZXb.cm(a.i,k,w);ZXb.km(a.i,k,W,false);ZXb.am(a.i,k,h);if(n!=0){qb=true;if(bxb(Iwb(TXb.Qwb(n),2),0)){n=kxb(Iwb(TXb.Qwb(n),-3));ZXb.lm(a.i,k,true);++a.b;}else {ZXb.lm(a.i,k,false);}ZXb.om(a.i,k,TXb.Qwb(n),true);}if(l.d.a.length!=0){qb=true;U=Rjb(TXb.klb,xZb,6,l.d.a.length,15,1);for(L=0;L<l.d.a.length;L++)U[L]=(L<0?null:$Xb.Xi(l.d,L)).a;ZXb.im(a.i,k,U);XXb.dTb(l.d.a,0);}else {if(FFb(tb)==tb&&CFb(tb)){if(o!=5&&o!=6&&o!=7&&o!=8&&o!=15&&o!=16&&o!=33&&o!=34)throw Gwb(new UXb.aA('SmilesParser: atomicNo '+o+' must not be aromatic'));ZXb.lm(a.i,k,true);++a.b;}else {ZXb.lm(a.i,k,false);}}if(F!=-1&&o!=1){v=Rjb(TXb.glb,R$b,6,1,15,1);v[0]=(F==9?0:F)<<24>>24;ZXb.gm(a.i,k,v);}H=p[u];if(p[u]!=-1&&s!=512){q=ZXb.Wj(a.i,p[u],k,s);if(r!=0){qb=true;ZXb.Em(a.i,q,r,true);}}s=1;r=0;p[u]=k;if(m!=0){ZXb.mm(a.i,k,m);m=0;}if(g){cb=!fb?null:$Xb.kNb(fb,UXb.TGb(H));!!cb&&ZXb.$t(cb,k,d);if(eb){!fb&&(fb=new $Xb.nRb());K=F==9?0:F;$Xb.fRb(fb,UXb.TGb(k),new ZXb.bu(k,d-2,H,K,O));}}continue;}if(tb==46){p[u]=-1;s=512;continue;}if(tb==45||tb==61||tb==35||tb==36||tb==58||tb==47||tb==92||tb==60||tb==126||tb==33||tb==64){if(rb)throw Gwb(new UXb.aA("SmilesParser: unexpected bond symbol inside square brackets: '"+String.fromCharCode(tb)+"'"));C=0;while(tb==45||tb==61||tb==35||tb==36||tb==58||tb==47||tb==92||tb==60||tb==126||tb==33||tb==64){if(tb==33){tb=c[d++]&oZb;tb==64&&(r|=128);if(tb==45&&c[d]==62||tb==60&&c[d]==45){C|=32;++d;}else if(tb==45)C|=1;else if(tb==61)C|=2;else if(tb==35)C|=4;else if(tb==36)C|=32;else if(tb==58)C|=8;else throw Gwb(new UXb.aA("SmilesParser: bond symbol '"+String.fromCharCode(tb)+"' not allowed after '!'."));}else {if(tb==64)r|=256;else if(tb==61)s=2;else if(tb==35)s=4;else if(tb==36)s=8;else if(tb==58)s=64;else if(tb==126)r|=31;else if(tb==47){g&&(s=257);}else if(tb==92){g&&(s=129);}else if(tb==45&&c[d]==62||tb==60&&c[d]==45){s=32;++d;}if(c[d]==44){r|=(s==32?62:tb)==61?2:(s==32?62:tb)==35?4:(s==32?62:tb)==36?32:(s==32?62:tb)==58?8:(s==32?62:tb)==62?16:(s==32?62:tb)==126?31:1;while(c[d]==44){if(c[d+1]==60&&c[d+2]==45||c[d+1]==45&&c[d+2]==62){r|=16;d+=3;}else {r|=ZXb.Jt(c[d+1]&oZb);d+=2;}}}}if(c[d]==59){++d;tb=c[d++]&oZb;continue;}C!=0&&(r|=31&~C);break;}continue;}if(tb<=32){d=e;continue;}if(BFb(tb)){Z=tb-48;if(rb){while(d<e&&BFb(c[d]&oZb)){Z=10*Z+c[d]-48;++d;}m=Z;}else {t=P?d-3:d-2;J=c[t]==45||c[t]==47||c[t]==92||c[t]==61||c[t]==35||c[t]==36||c[t]==58||c[t]==62||c[t]==126;if(P&&d<e&&BFb(c[d]&oZb)){Z=10*Z+c[d]-48;P=false;++d;}if(Z>=lb.length){if(Z>=100)throw Gwb(new UXb.aA('SmilesParser: ringClosureAtom number out of range'));$=lb.length;X=lb.length;while(X<=Z)X=$wnd.Math.min(100,X+16);lb=(XXb.vTb(X),$Xb.yOb(lb,Rjb(TXb.klb,xZb,6,X,15,1),X));ob=(XXb.vTb(X),$Xb.yOb(ob,Rjb(TXb.klb,xZb,6,X,15,1),X));nb=(XXb.vTb(X),$Xb.yOb(nb,Rjb(TXb.klb,xZb,6,X,15,1),X));mb=(XXb.vTb(X),$Xb.yOb(mb,Rjb(TXb.klb,xZb,6,X,15,1),X));for(L=$;L<X;L++)lb[L]=-1;}if(lb[Z]==-1){lb[Z]=p[u];ob[Z]=d-1;nb[Z]=J?s:-1;mb[Z]=J?r:0;}else {if(lb[Z]==p[u])throw Gwb(new UXb.aA('SmilesParser: ring closure to same atom'));if(g&&!!fb){cb=$Xb.kNb(fb,UXb.TGb(lb[Z]));!!cb&&ZXb.$t(cb,p[u],ob[Z]);cb=$Xb.kNb(fb,UXb.TGb(p[u]));!!cb&&ZXb.$t(cb,lb[Z],d-1);}nb[Z]!=-1?s=nb[Z]:s==257?s=129:s==129&&(s=257);q=ZXb.Wj(a.i,lb[Z],p[u],s);mb[Z]!=0&&(r=mb[Z]);if(r!=0){qb=true;ZXb.Em(a.i,q,mb[Z],true);}lb[Z]=-1;}s=1;r=0;}continue;}if(tb==43){throw Gwb(new UXb.aA("SmilesParser: '+' found outside brackets"));}if(tb==40){if(p[u]==-1)throw Gwb(new UXb.aA('Smiles with leading parenthesis are not supported'));++u;p.length==u&&(p=$Xb.wOb(p,p.length+32));p[u]=p[u-1];continue;}if(tb==41){--u;continue;}if(tb==91){rb=true;continue;}if(tb==93){throw Gwb(new UXb.aA('SmilesParser: closing bracket at unexpected position'));}if(tb==37){P=true;continue;}throw Gwb(new UXb.aA("SmilesParser: unexpected character outside brackets: '"+String.fromCharCode(tb)+"'"));}if(s!=1)throw Gwb(new UXb.aA('SmilesParser: dangling open bond'));for(ib=lb,jb=0,kb=ib.length;jb<kb;++jb){hb=ib[jb];if(hb!=-1)throw Gwb(new UXb.aA('SmilesParser: dangling ring closure'));}I=ZXb.co(a.i);ZXb.Jm(a.i,true);ZXb.nu(a.i,1);for(j=0;j<a.i.q;j++){if(ZXb.Bk(a.i,j)!=null){D=ZXb.Ck(a.i,j)[0];if(qb||a.k==2){if(a.g){for(L=0;L<D;L++)ZXb.Wj(a.i,j,ZXb.Uj(a.i,1),1);}else {D==0&&ZXb.om(a.i,j,1792,true);D==1&&ZXb.om(a.i,j,1664,true);D==2&&ZXb.om(a.i,j,1408,true);D==3&&ZXb.om(a.i,j,896,true);}}else {if(!ZXb.Fl(a.i,j)&&(!ZXb.El(a.i,j)||ZXb.Qk(a.i,j)==6&&ZXb.zk(a.i,j)==0)){Ab=ZXb.en(ZXb.Qk(a.i,j));A=false;vb=ZXb.ko(a.i,j);vb-=ZXb.il(a.i,j,vb);vb+=D;ZXb.El(a.i,j)&&++vb;for(xb=Ab,yb=0,zb=xb.length;yb<zb;++yb){wb=xb[yb];if(vb<=wb){A=true;wb==vb+2?ZXb.pm(a.i,j,48):wb==vb+1?ZXb.pm(a.i,j,32):(wb!=vb||wb!=Ab[0])&&ZXb.am(a.i,j,vb);break;}}A||ZXb.am(a.i,j,vb);}if(a.g||!ZXb.lp(a.i,j))for(L=0;L<D;L++)ZXb.Wj(a.i,j,ZXb.Uj(a.i,1),1);}}else if(!a.g&&(qb||a.k==2)){D=ZXb.Wn(a.i,j);D>=1&&ZXb.om(a.i,j,128,true);D>=2&&ZXb.om(a.i,j,256,true);D>=3&&ZXb.om(a.i,j,512,true);D>=4&&ZXb.om(a.i,j,WZb,true);}}!a.g&&(qb||a.k==2)&&ZXb.dp(a.i,true);ZXb.nu(a.i,1);ZXb.Lt(a);ZXb.Nt(a,i);a.i.t=null;ZXb.Jm(a.i,false);if(g){ZXb.It(a);if(fb){for(db=(ab=new $Xb.LMb(fb).a.Td().Fb(),new $Xb.SMb(ab));db.a.Fd();){cb=(B=db.a.Gd(),B.Xd());ZXb.nm(a.i,cb.a,ZXb._t(cb,I),false);}ZXb.gp(a.i,0);}}ZXb.gp(a.i,0);if(f){N=new bYb.yy(a.d);bxb(a.j,0)&&bYb.uy(N,a.j);bYb.fy(N,a.i);g&&ZXb.Au(a.i);}(qb||a.k==2)&&ZXb.Hm(a.i,true);};ZXb.Pt=function Pt(a,b,c,d,e){ZXb.Ot(a,b,c,0,c.length,d,e);};ZXb.Qt=function Qt(a,b){var c;return b==null?null:ZXb.Rt(a,XXb.lTb((c=b,XXb.gTb(),c)));};ZXb.Rt=function Rt(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;h=xYb.i6(b,0);i=h==-1?-1:xYb.i6(b,h+1);if(i==-1)throw Gwb(new UXb.aA("Missing one or both separators ('>')."));if(xYb.i6(b,i+1)!=-1)throw Gwb(new UXb.aA("Found more than 2 separators ('>')."));n=new iYb.EF();o=0;for(f=o;f<h-1;f++){if(b[f]==46&&b[f+1]==46){if(f>o){l=new ZXb.Fu();ZXb.Ot(a,l,b,o,f,true,true);$Xb.Si(n.g,l);n.d=-1;}o=f+2;}}m=new ZXb.Fu();ZXb.Ot(a,m,b,o,h,true,true);$Xb.Si(n.g,m);n.d=-1;if(i-h>1){o=h+1;for(g=o;g<i-1;g++){if(b[g]==46&&b[g+1]==46){if(g>o){c=new ZXb.Fu();ZXb.Ot(a,c,b,o,g,true,true);$Xb.Si(n.a,c);}o=g+2;}}d=new ZXb.Fu();ZXb.Ot(a,d,b,o,i,true,true);$Xb.Si(n.a,d);}o=i+1;for(e=o;e<b.length-1;e++){if(b[e]==46&&b[e+1]==46){if(e>o){j=new ZXb.Fu();ZXb.Ot(a,j,b,o,e,true,true);$Xb.Si(n.f,j);n.d=-1;}o=e+2;}}k=new ZXb.Fu();ZXb.Ot(a,k,b,o,b.length,true,true);$Xb.Si(n.f,k);n.d=-1;return n;};ZXb.St=function St(a,b){var c,d,e,f;ZXb.el(a.i,b)==1&&ZXb.Fm(a.i,b,2);for(e=0;e<2;e++){c=ZXb.Vk(a.i,e,b);if(ZXb.El(a.i,c)){ZXb.lm(a.i,c,false);--a.b;}for(f=0;f<ZXb.Sn(a.i,c);f++){d=ZXb.Tn(a.i,c,f);if(a.f[d]){a.f[d]=false;--a.c;}}}};ZXb.Tt=function Tt(a){var b,c,d,e,f,g,h;do{h=false;for(c=0;c<a.i.g;c++){if(a.f[c]){f=false;for(e=0;e<2;e++){b=false;d=ZXb.Vk(a.i,e,c);for(g=0;g<ZXb.Sn(a.i,d);g++){if(c!=ZXb.Tn(a.i,d,g)&&a.f[ZXb.Tn(a.i,d,g)]){b=true;break;}}if(!b){f=true;break;}}if(f){h=true;ZXb.St(a,c);}}}}while(h);};ZXb.Ut=function Ut(a,b){var c,d;if(!ZXb.is(ZXb.Qk(a.i,b)))return false;if(ZXb.Qk(a.i,b)==6){if(!ZXb.El(a.i,b))return false;if(ZXb.zk(a.i,b)>0)return false;}c=ZXb.Bk(a.i,b)==null?0:ZXb.Ck(a.i,b)[0];d=ZXb.ao(a.i,b)-c;if(d<1)return false;if(ZXb.Qk(a.i,b)==16||ZXb.Qk(a.i,b)==34||ZXb.Qk(a.i,b)==52){if(ZXb.Sn(a.i,b)==2&&ZXb.zk(a.i,b)<=0)return false;if(d==2)return false;}return true;};ZXb.Vt=function Vt(a,b){a.j=b;};ZXb.Wt=function Wt(a,b){if(a.e){!a.n&&(a.n=new UXb.iIb());UXb.fIb(a.n,' ');UXb.fIb(a.n,b);}};ZXb.Xt=function Xt(){ZXb.Yt.call(this,0,false);};ZXb.Yt=function Yt(a,b){this.k=a&3;this.a=(a&16)==0;this.e=b;this.g=(a&8)!=0;this.d=2;(a&4)!=0&&(this.d|=1);this.g&&(this.d&=-3);};wxb(151,1,{},ZXb.Xt,ZXb.Yt);_.a=false;_.b=0;_.c=0;_.d=0;_.e=false;_.g=false;_.j=0;_.k=0;TXb.bmb=UFb(151);ZXb.Zt=function Zt(a,b){this.a=a;this.b=b;};wxb(209,1,{209:1},ZXb.Zt);_.a=0;_.b=0;TXb._lb=UFb(209);ZXb.$t=function $t(a,b,c){if(!a.c){if(a.e.a.length==4){a.c=true;return;}$Xb.Si(a.e,new ZXb.Zt(b,c));}};ZXb._t=function _t(a,b){var c,d,e;if(a.c)return 3;for(d=new $Xb.qOb(a.e);d.a<d.c.a.length;){c=$Xb.pOb(d);c.a!=2147483646&&c.a!=fZb&&(c.a=b[c.a]);}if(a.e.a.length==3)$Xb.Si(a.e,new ZXb.Zt(fZb,a.b));else if(a.e.a.length!=4)return 3;e=a.d^ZXb.au(a)?1:2;return e;};ZXb.au=function au(a){var b,c,d;c=false;for(b=1;b<a.e.a.length;b++){for(d=0;d<b;d++){$Xb.Xi(a.e,d).a>$Xb.Xi(a.e,b).a&&(c=!c);$Xb.Xi(a.e,d).b>$Xb.Xi(a.e,b).b&&(c=!c);}}return c;};ZXb.bu=function bu(a,b,c,d,e){if(d!=0&&d!=1){this.c=true;}else {this.a=a;this.b=b;this.d=e;this.e=new $Xb.kj();c!=-1&&ZXb.$t(this,c,b-1);c!=-1&&d==1&&ZXb.$t(this,2147483646,b+1);}};wxb(251,1,{251:1},ZXb.bu);_.a=0;_.b=0;_.c=false;_.d=false;TXb.amb=UFb(251);ZXb.cu=function cu(a,b,c,d){a.a=false;a.d=c;if(BFb(b[c]&oZb)){a.c=a.b=ZXb.du(a);return a.d-c;}if(b[c]==123&&BFb(b[c+1]&oZb)){++a.d;a.c=ZXb.du(a);if(b[a.d++]!=45)return 0;if(!BFb(b[a.d]&oZb))return 0;a.b=ZXb.du(a);if(b[a.d++]!=125)return 0;return a.d-c;}a.c=1;a.b=d;a.a=true;return 0;};ZXb.du=function du(a){var b;b=a.e[a.d++]-48;BFb(a.e[a.d]&oZb)&&(b=10*b+(a.e[a.d++]-48));return b;};ZXb.eu=function eu(a){return '{'+a.c+'-'+a.b+'}';};ZXb.fu=function fu(a){this.e=a;};wxb(385,1,{},ZXb.fu);_.lb=function gu(){return ZXb.eu(this);};_.a=false;_.b=0;_.c=0;_.d=0;TXb.cmb=UFb(385);ZXb.hu=function hu(a){a.c=new $Xb.kj();};ZXb.iu=function iu(a,b){var c,d,e,f;f=a.c.a.length;if(f==0){$Xb.Ri(a.c,0,b);return 0;}e=1;while(2*e<=f)e<<=1;d=e;--e;while(d!=0){d>>=1;if(e>=f){e-=d;continue;}c=UXb.xHb(b,$Xb.Xi(a.c,e));if(c==0)return -1;if(d==0)break;c<0?e-=d:e+=d;}e<f&&UXb.xHb(b,$Xb.Xi(a.c,e))>0&&++e;$Xb.Ri(a.c,e,b);return e;};ZXb.ju=function ju(a,b){var c,d,e,f;f=a.c.a.length;if(f==0)return -1;e=1;while(2*e<=f)e<<=1;d=e;--e;while(d!=0){d>>=1;if(e>=f){e-=d;continue;}c=UXb.xHb(b,$Xb.Xi(a.c,e));if(c==0)return e;if(d==0)break;c<0?e-=d:e+=d;}return -1;};ZXb.ku=function ku(){ZXb.hu(this);};wxb(115,1,a0b,ZXb.ku);_.Pb=function lu(a){return ZXb.ju(this,a);};TXb.dmb=UFb(115);ZXb.mu=function mu(a,b){ZXb.nk(a,b);!!a.d&&(b.T=0);};ZXb.nu=function nu(a,b){var c,d,e,f;ZXb.wn(a,b);if((b&~a.T)==0)return;(a.T&15)!=0&&a.q>1&&ZXb.Ih(a.J[0],a.J[1])&&bYb.fy(new bYb.yy(0),a);a.c&&(b|=128);for(c=0;c<a.q;c++)a.u[c]&=-67223560;for(d=0;d<a.g;d++)a.F[d]&=-64;e=0;f=0;if((b&32)!=0){e=32;f=1;}else if((b&64)!=0){e=64;f=3;}if((b&128)!=0){e|=128;f|=32;}a.d=new ZXb.ig(a,f);ZXb.dg(a.d);ZXb.eg(a.d);ZXb.cg(a.d);ZXb.Eu(a)&&(a.d=new ZXb.ig(a,f));a.T|=24|e;};ZXb.ou=function ou(a,b){return ZXb.Sf(a.d,b);};ZXb.pu=function pu(a,b){return ZXb.Jf(a.d,b);};ZXb.qu=function qu(a){var b;ZXb.nu(a,31);b=a.I&oZb;switch(a.I&H$b){case nZb:return null;case S$b:return b==1?'meso':''+b+' meso diastereomers';case 0:return 'unknown chirality';case T$b:return 'both enantiomers';case F$b:return 'this enantiomer';case 327680:return 'this or other enantiomer';case g$b:return 'two epimers';default:return b==1?'one stereo isomer':''+b+' stereo isomers';}};ZXb.ru=function ru(a){var b;b=new ZXb.Gu(a.q,a.r);ZXb.mk(a,b);return b;};ZXb.su=function su(a){var b,c,d,e,f,g,h;ZXb.nu(a,15);g=Rjb(TXb.klb,xZb,6,3,15,1);for(c=0;c<a.f;c++){if((a.u[c]&k_b)!=0){h=(a.u[c]&D$b)>>18;h!=0&&(g[h]=$wnd.Math.max(g[h],(a.u[c]&D$b)>>18!=1&&(a.u[c]&D$b)>>18!=2?-1:(a.u[c]&g_b)>>20));}}for(e=0;e<a.g;e++){if(((a.F[e]&3)==1||(a.F[e]&3)==2)&&a.H[e]==1){h=(a.F[e]&768)>>8;h!=0&&(g[h]=$wnd.Math.max(g[h],(a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&h_b)>>10));}}f=Rjb(TXb.klb,P$b,8,3,0,2);f[1]=Rjb(TXb.klb,xZb,6,1+g[1],15,1);f[2]=Rjb(TXb.klb,xZb,6,1+g[2],15,1);for(b=0;b<a.f;b++){if((a.u[b]&k_b)!=0){h=(a.u[b]&D$b)>>18;h!=0&&++f[h][(a.u[b]&D$b)>>18!=1&&(a.u[b]&D$b)>>18!=2?-1:(a.u[b]&g_b)>>20];}}for(d=0;d<a.g;d++){if(((a.F[d]&3)==1||(a.F[d]&3)==2)&&a.H[d]==1){h=(a.F[d]&768)>>8;h!=0&&++f[h][(a.F[d]&768)>>8!=1&&(a.F[d]&768)>>8!=2?-1:(a.F[d]&h_b)>>10];}}return f;};ZXb.tu=function tu(a){var b,c;b=Rjb(TXb.klb,xZb,6,a.q,15,1);c=ZXb.$n(a,b,false,false);return ZXb.uu(a,b,c);};ZXb.uu=function uu(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;q=Rjb(TXb.emb,Q_b,24,c,0,1);g=Rjb(TXb.klb,xZb,6,c,15,1);j=Rjb(TXb.klb,xZb,6,c,15,1);f=Rjb(TXb.klb,xZb,6,a.q,15,1);for(e=0;e<a.q;e++)b[e]!=-1&&(f[e]=g[b[e]]++);for(i=0;i<a.r;i++){o=b[a.D[0][i]];p=b[a.D[1][i]];o==p&&o!=-1&&++j[o];}for(r=0;r<c;r++){q[r]=new ZXb.Gu(g[r],j[r]);ZXb.mu(a,q[r]);}for(d=0;d<a.q;d++)b[d]!=-1&&ZXb.jk(a,q[b[d]],d,0,0);for(h=0;h<a.r;h++){o=b[a.D[0][h]];p=b[a.D[1][h]];o==p&&o!=-1&&ZXb.lk(a,q[o],h,0,0,f,false);}for(l=q,m=0,n=l.length;m<n;++m){k=l[m];ZXb.Yl(k,1);ZXb.Yl(k,2);}return q;};ZXb.vu=function vu(a){ZXb.nu(a,15);!a.d&&(a.f<2||!ZXb.Ih(a.J[0],a.J[1]))&&(a.d=new ZXb.hg(a));return !a.d?null:ZXb.Nf(a.d);};ZXb.wu=function wu(a){ZXb.nu(a,15);!a.d&&(a.f<2||!ZXb.Ih(a.J[0],a.J[1]))&&(a.d=new ZXb.hg(a));return !a.d?null:ZXb.Kf(a.d);};ZXb.xu=function xu(a){var b,c;ZXb.nu(a,31);c=0;for(b=0;b<a.f;b++)(a.u[b]&3)!=0&&(a.u[b]&4)==0&&++c;return c;};ZXb.yu=function yu(a,b){return ZXb.Rf(a.d,b);};ZXb.zu=function zu(a,b){a.c=b;a.T&=-144;};ZXb.Au=function Au(a){ZXb.nu(a,31);!!a.d&&ZXb.fg(a.d);};ZXb.Bu=function Bu(a){var b,c;ZXb.nu(a,15);a.L=false;for(b=0;b<a.q;b++){a.u[b]&=n_b;(a.u[b]&3)!=0?a.u[b]|=j_b:a.u[b]&=m_b;}for(c=0;c<a.r;c++)(a.F[c]&3)!=0&&ZXb.bl(a,c)==2?a.H[c]=386:a.H[c]&=-385;a.T&=-249;};ZXb.Cu=function Cu(a,b,c){var d,e,f,g,h,i,j,k,l;l=a.u[b]&3;if(l==1||l==2){h=false;if(a.o[b]==2&&a.j[b]==2&&a.n[b][0]==2&&a.n[b][1]==2&&a.C[b]<=7){for(g=0;g<a.j[b];g++){d=a.i[b][g];k=0;j=Rjb(TXb.klb,xZb,6,3,15,1);for(i=0;i<a.j[d];i++){j[k]=a.i[d][i];j[k]!=b&&++k;}k==2&&j[0]<j[1]^c[j[0]]<c[j[1]]&&(h=!h);}}else {for(g=1;g<a.j[b];g++){for(i=0;i<g;i++){e=a.i[b][g];f=a.i[b][i];e<f^c[e]<c[f]&&(h=!h);}}}h&&(l=l==1?2:1);}return l;};ZXb.Du=function Du(a){var b,c,d,e,f,g;ZXb.mp(a);ZXb.nu(a,31);for(d=0;d<a.f;d++){if(((a.u[d]&D$b)>>18==1||(a.u[d]&D$b)>>18==2)&&((a.u[d]&k_b)==0||(a.u[d]&3)==3))throw Gwb(new UXb.aA(b0b));if((a.u[d]&nZb)!=0)throw Gwb(new UXb.aA(c0b));if(((a.u[d]&3)==1||(a.u[d]&3)==2)&&a.o[d]==0){b=Rjb(TXb.ilb,vZb,6,a.j[d],15,1);for(f=0;f<a.j[d];f++)b[f]=ZXb.Uk(a,d,a.i[d][f]);for(e=1;e<a.j[d];e++)if(!ZXb.Ml(a,a.k[d][e],d))for(g=0;g<e;g++)if(!ZXb.Ml(a,a.k[d][g],d)){c=$wnd.Math.abs(ZXb.gn(b[e],b[g]));if(c<0.08||c>t_b)throw Gwb(new UXb.aA(d0b));}}}};ZXb.Eu=function Eu(a){var b,c,d,e,f,g,h;h=false;for(c=0;c<a.f;c++)((a.u[c]&k_b)==0||(a.u[c]&3)==3)&&(a.u[c]&=n_b);for(f=0;f<a.g;f++)(ZXb.bl(a,f)!=1||(a.F[f]&3)==0||(a.F[f]&3)==3)&&(a.F[f]&=-32513);if(a.L){if((a.I&H$b)!=S$b){g=Rjb(TXb.Bwb,JZb,6,a.f,16,1);for(d=0;d<a.f;d++)(a.u[d]&k_b)!=0&&(a.u[d]&3)!=3&&(a.u[d]&D$b)>>18==1&&(g[d]=true);for(e=0;e<a.f;e++){if((a.u[e]&k_b)!=0&&(a.u[e]&3)!=3){ZXb.hm(a,e,1,0);h=true;}}for(b=0;b<a.f;b++){if(g[b]){ZXb.nm(a,b,1,false);ZXb.hm(a,b,1,-1);h=true;}}}a.L=false;}ZXb.Yl(a,1);ZXb.Yl(a,2);return h;};ZXb.Fu=function Fu(){ZXb.Sj();ZXb.op.call(this);};ZXb.Gu=function Gu(a,b){ZXb.Sj();ZXb.pp.call(this,a,b);};ZXb.Hu=function Hu(a){ZXb.Sj();ZXb.qp.call(this,a);};wxb(24,97,e0b,ZXb.Fu,ZXb.Gu,ZXb.Hu);_.Kb=function Iu(a){ZXb.mu(this,a);};_.Mb=function Ju(a){ZXb.nu(this,a);};_.c=false;TXb.emb=UFb(24);ZXb.Lu=function Lu(a,b){var c,d,e,f,g,h,i,j,k,l,m;h=new $Xb.kj();ZXb.nu(b,1);j=Rjb(TXb.Bwb,JZb,6,b.f,16,1);for(c=0;c<b.f;c++){if(a.f[c]&&(ZXb.Qk(a.i,c)==7||ZXb.Qk(a.i,c)==8||ZXb.Qk(a.i,c)==16||ZXb.Qk(a.i,c)==34||ZXb.Qk(a.i,c)==52)){j[c]=true;for(i=0;i<b.j[c];i++){d=b.i[c][i];f=b.k[c][i];l=b.n[c][i];if(b.o[d]!=0&&b.o[c]<l){j[d]=true;$Xb.Si(h,UXb.TGb(f));for(k=0;k<b.j[d];k++){e=b.i[d][k];if(!j[e]){j[e]=true;g=b.k[d][k];m=b.n[d][k];if(b.o[d]+2==l+m){$Xb.Si(h,UXb.TGb(g));l>=m&&(b.o[e]<m?ZXb.Uu(b,e)&&ZXb.Ou(a,b,e,true,false,j,h):ZXb.Ou(a,b,e,true,true,j,h));m>=l&&ZXb.Uu(b,c)&&ZXb.Ou(a,b,e,false,false,j,h);if(a.f[e]&&(ZXb.Qk(a.i,e)==5||ZXb.Qk(a.i,e)==6||ZXb.Qk(a.i,e)==7||ZXb.Qk(a.i,e)==8||ZXb.Qk(a.i,e)==16||ZXb.Qk(a.i,e)==34||ZXb.Qk(a.i,e)==52)&&b.o[e]<m){l<=2&&m>=2&&ZXb.Uu(b,c)&&ZXb.Mu(a,b,f,g);l>=2&&m<=2&&ZXb.Uu(b,e)&&ZXb.Mu(a,b,g,f);}$Xb.cj(h,h.a.length-1);}j[e]=false;}}$Xb.cj(h,h.a.length-1);j[d]=false;}}j[c]=false;}}};ZXb.Mu=function Mu(a,b,c,d){var e;e=new ZXb.$u(a,b);ZXb.Zu(e,c,ZXb.bl(b,c)==1?2:3);ZXb.Zu(e,d,ZXb.bl(b,d)==2?1:2);a.g[c]=true;a.g[d]=true;$Xb.ZRb(a.e,e)&&($Xb.LNb(a.d,e),true);};ZXb.Nu=function Nu(a,b){$Xb.ZRb(a.e,b)&&($Xb.LNb(a.d,b),true);};ZXb.Ou=function Ou(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p,q,r,s;for(n=0;n<b.j[c];n++){h=b.i[c][n];if(!f[h]){k=b.k[c][n];r=ZXb.bl(b,k);if(d&&r>=2||!d&&r<=2){f[h]=true;g.add(UXb.TGb(k));for(o=0;o<b.j[h];o++){i=b.i[h][o];if(!f[i]){l=b.k[h][o];s=ZXb.bl(b,l);if(b.o[h]+2==r+s&&(d&&s<=2||!d&&s>=2)){f[i]=true;g.add(UXb.TGb(l));if(a.f[i]&&(ZXb.Qk(a.i,i)==5||ZXb.Qk(a.i,i)==6||ZXb.Qk(a.i,i)==7||ZXb.Qk(a.i,i)==8||ZXb.Qk(a.i,i)==16||ZXb.Qk(a.i,i)==34||ZXb.Qk(a.i,i)==52)&&(!d||ZXb.Uu(b,i))){m=new ZXb.$u(a,b);for(p=0;p<g.a.length;p++){j=(XXb.yTb(p,g.a.length),g.a[p]).a;q=p<2?d^(p&1)==0:e^(p&1)==0;q?ZXb.Zu(m,j,ZXb.bl(b,j)==1?2:3):ZXb.Zu(m,j,ZXb.bl(b,j)==2?1:2);a.g[j]=true;}$Xb.ZRb(a.e,m)&&($Xb.LNb(a.d,m),true);}else {ZXb.Ou(a,b,i,d,e,f,g);}$Xb.cj(g,g.a.length-1);f[i]=false;}}}$Xb.cj(g,g.a.length-1);f[h]=false;}}}return false;};ZXb.Pu=function Pu(a){var b,c,d,e,f,g,h,i,j,k,l;a.b=Rjb(TXb.klb,xZb,6,a.i.f,15,1);h=Rjb(TXb.klb,xZb,6,a.i.f,15,1);d=Rjb(TXb.Bwb,JZb,6,a.i.g,16,1);l=0;for(c=0;c<a.i.g;c++){if(!d[c]&&a.g[c]){++l;a.b[ZXb.Vk(a.i,0,c)]=l;a.b[ZXb.Vk(a.i,1,c)]=l;d[c]=true;for(j=0;j<2;j++){b=ZXb.Vk(a.i,j,c);a.b[b]=l;g=0;i=0;h[0]=b;while(g<=i){for(k=0;k<ZXb.Sn(a.i,h[g]);k++){f=ZXb.Tn(a.i,h[g],k);if(!d[f]&&a.g[f]){d[f]=true;e=ZXb.Rn(a.i,h[g],k);if(a.b[e]==0){a.b[e]=l;h[++i]=e;}}}++g;}}}}a.j=l;};ZXb.Qu=function Qu(a){var b,c,d;a.n=Rjb(TXb.klb,xZb,6,a.j,15,1);a.k=Rjb(TXb.klb,xZb,6,a.j,15,1);a.o=Rjb(TXb.klb,xZb,6,a.j,15,1);for(b=0;b<a.i.f;b++){if(a.b[b]!=0){d=a.b[b]-1;a.a!=null&&(a.k[d]+=a.a[b]);a.c!=null&&(a.o[d]+=a.c[b]);}}for(c=0;c<a.i.g;c++){a.g[c]&&ZXb.bl(a.i,c)==2&&(a.n[a.b[ZXb.Vk(a.i,0,c)]-1]+=2);}};ZXb.Ru=function Ru(a){var b,c,d,e;for(d=0;d<a.i.r;d++){for(e=0;e<2;e++){b=ZXb.Vk(a.i,e,d);c=ZXb.Vk(a.i,1-e,d);if(ZXb.Qk(a.i,b)==1&&ZXb.Jk(a.i,b)>1&&ZXb.Qk(a.i,c)>1&&a.b[c]!=0){if(ZXb.Jk(a.i,b)==2){a.a==null&&(a.a=Rjb(TXb.klb,xZb,6,a.i.q,15,1));++a.a[c];}else {a.c==null&&(a.c=Rjb(TXb.klb,xZb,6,a.i.q,15,1));++a.c[c];}ZXb.Ol(a.i,b);}}}(a.a!=null||a.c!=null)&&ZXb.tk(a.i);};ZXb.Su=function Su(a){var b;a.e=new $Xb.cSb();a.d=new $Xb.XNb();ZXb.Nu(a,new ZXb.$u(a,a.i));b=ZXb.ru(a.i);while(!$Xb.PNb(a.d)){ZXb.Yu($Xb.RNb(a.d),b);ZXb.Lu(a,b);if(a.e.a.c>=ZXb.Ku){UXb.nIb();'Tautomer count exceeds maximum: '+ZXb.Nf(new ZXb.hg(a.i));break;}}};ZXb.Tu=function Tu(a){var b,c,d,e,f,g,h,i,j,k;if(a.e.a.c==1)return a.i;j=ZXb.ru(a.i);ZXb.Hm(j,true);ZXb.nu(j,7);for(e=0;e<j.g;e++){if(a.g[e]){j.H[e]=1;j.T=0;ZXb.Em(j,e,3,true);}}for(c=0;c<j.f;c++){if(a.b[c]!=0&&ZXb.jo(a.i,c)<4){ZXb.tn(j,c);j.u[c]&=m_b;j.T&=7;ZXb.hm(j,c,0,-1);}}h=Rjb(TXb.klb,xZb,6,a.j,15,1);i=Rjb(TXb.klb,xZb,6,a.j,15,1);d=new ZXb.hg(j).d;for(b=0;b<j.f;b++){if(a.b[b]!=0){k=a.b[b]-1;if(i[k]<d[b]){i[k]=d[b];h[k]=b;}}}for(f=0;f<a.j;f++){g=''+a.n[f]+'|'+a.k[f]+'|'+a.o[f];ZXb.fm(j,h[f],g);}return j;};ZXb.Uu=function Uu(a,b){if(a.e[b]-ZXb.jo(a,b)+ZXb.fo(a,b)<=0)return false;if(ZXb.Cl(a,b))return true;if(a.o[b]!=0)return false;return true;};ZXb.Vu=function Vu(a){var b,c,d,e,f,g,h,i;ZXb.nu(a.i,1);h=a.i.f;do--h;while(h>=0&&ZXb.Qk(a.i,h)==1);for(b=0;b<h;b++){if(ZXb.Qk(a.i,b)==1){ZXb.Sm(a.i,b,h);do--h;while(ZXb.Qk(a.i,h)==1);}}if(h==a.i.f-1)return;g=Rjb(TXb.Bwb,JZb,6,a.i.g,16,1);for(f=0;f<a.i.g;f++){c=ZXb.Vk(a.i,0,f);d=ZXb.Vk(a.i,1,f);(ZXb.Qk(a.i,c)==1||ZXb.Qk(a.i,d)==1)&&(g[f]=true);}i=a.i.g;do--i;while(i>=0&&g[i]);for(e=0;e<i;e++){if(g[e]){ZXb.Tm(a.i,e,i);g[e]=false;do--i;while(g[i]);}}};ZXb.Wu=function Wu(a){var b,c;this.i=ZXb.ru(a);ZXb.Vu(this);ZXb.nu(this.i,7);this.g=Rjb(TXb.Bwb,JZb,6,this.i.g,16,1);this.f=Rjb(TXb.Bwb,JZb,6,this.i.f,16,1);for(b=0;b<this.i.f;b++){c=ZXb.en(ZXb.Qk(this.i,b))[0];this.f[b]=ZXb.jo(this.i,b)<c;}ZXb.Su(this);ZXb.Pu(this);ZXb.Ru(this);ZXb.Qu(this);};wxb(274,1,{},ZXb.Wu);_.j=0;ZXb.Ku=f0b;TXb.gmb=UFb(274);ZXb.Xu=function Xu(a,b){return xYb.u6(a.a,b.a);};ZXb.Yu=function Yu(a,b){var c,d;for(d=0;d<a.b.i.g;d++){if(a.b.g[d]){c=3&a.a[d>>4]>>2*(d&15);ZXb.Fm(b,d,c==1?1:c==2?a.b.g[d]&&!ZXb.Yo(a.b.i,d)?386:2:c==3?4:32);}}};ZXb.Zu=function Zu(a,b,c){var d,e;d=b>>4;e=2*(b&15);a.a[d]&=~(3<<e);a.a[d]|=c<<e;};ZXb.$u=function $u(a,b){var c;this.b=a;this.a=Rjb(TXb.klb,xZb,6,(a.i.g+15)/16|0,15,1);for(c=0;c<a.i.g;c++)this.a[c>>4]|=$wnd.Math.min(3,ZXb.bl(b,c))<<2*(c&15);};wxb(183,1,{183:1,18:1},ZXb.$u);_.Eb=function _u(a){return ZXb.Xu(this,a);};TXb.fmb=UFb(183);ZXb.av=function av(a){var b,c,d,e,f;c=UXb.GHb(a,THb(38));if(c==-1)return a;e=0;f=new UXb.$Hb();while(c!=-1){UXb.ZHb(f,(XXb.ETb(e,c,XXb.KTb(a).length),XXb.KTb(a).substr(e,c-e)));XXb.FTb(c+1,XXb.KTb(a).length);if(XXb.KTb(a).charCodeAt(c+1)==38){f.a+='&';e=c+2;}else {b=(XXb.FTb(c+1,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(c+1));b=b-(b<65?48:b<97?65:97);d=(XXb.FTb(c+2,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(c+2));d=d-(d<65?48:d<97?65:97);UXb.XHb(f,16*b+d&oZb);e=c+3;}c=UXb.HHb(a,THb(38),e);}UXb.ZHb(f,(XXb.FTb(e,XXb.KTb(a).length+1),XXb.KTb(a).substr(e)));return f.a;};ZXb.bv=function bv(a){var b,c;c=new UXb.$Hb();for(b=0;b<XXb.KTb(a).length;b++){switch(XXb.FTb(b,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(b)){case 38:c.a+='&&';break;case 9:c.a+='&09';break;case 10:c.a+='&0A';break;case 32:c.a+='&20';break;default:UXb.XHb(c,(XXb.FTb(b,XXb.KTb(a).length),XXb.KTb(a).charCodeAt(b)));}}return c.a;};ZXb.cv=function cv(a,b,c){a.e[0].a=b;a.e[0].b=c;};ZXb.dv=function dv(b,c){try{b.a=zGb(c);}catch(a){a=Fwb(a);if(!Ykb(a,52))throw Gwb(a);}};ZXb.ev=function ev(b,c){try{b.b=UXb.mGb(c,D_b,fZb);}catch(a){a=Fwb(a);if(!Ykb(a,52))throw Gwb(a);}};ZXb.fv=function fv(a,b,c,d){a.c=b;a.a=c;a.b=d;};ZXb.gv=function gv(b,c){try{b.e[0].a=zGb(c);}catch(a){a=Fwb(a);if(!Ykb(a,52))throw Gwb(a);}};ZXb.hv=function hv(b,c){try{b.e[0].b=zGb(c);}catch(a){a=Fwb(a);if(!Ykb(a,52))throw Gwb(a);}};ZXb.iv=function iv(){ZXb.kv.call(this,new kYb.AG());};ZXb.jv=function jv(a){var b,c,d,e;ZXb.iv.call(this);b=0;while(b!=-1){c=XXb.KTb(a).indexOf('="',b);if(c==-1)break;d=(XXb.ETb(b+1,c,XXb.KTb(a).length),XXb.KTb(a).substr(b+1,c-(b+1)));b=XXb.KTb(a).indexOf('"',c+2);e=b==-1?(XXb.FTb(c+1,XXb.KTb(a).length+1),XXb.KTb(a).substr(c+1)):(XXb.ETb(c+1,b,XXb.KTb(a).length),XXb.KTb(a).substr(c+1,b-(c+1)));UXb.CHb(d,a_b)?this.c=ZXb.av(e):UXb.CHb(d,'x')?ZXb.gv(this,e):UXb.CHb(d,'y')?ZXb.hv(this,e):UXb.CHb(d,'size')?ZXb.dv(this,e):UXb.CHb(d,g0b)&&ZXb.ev(this,e);}};ZXb.kv=function kv(a){this.c='';this.a=9;this.b=0;this.e=Rjb(TXb.Anb,jZb,33,1,0,1);this.e[0]=a;};wxb(188,229,{229:1},ZXb.iv,ZXb.jv);_.Ab=function lv(){var a;a=new ZXb.iv();ZXb.fv(a,this.c,this.a,this.b);ZXb.cv(a,this.e[0].a,this.e[0].b);a.d=this.d;return a;};_.Bb=function mv(){var a;a=new UXb.iIb();UXb.fIb(a,' text="'+ZXb.bv(this.c)+'"');UXb.fIb(a,' x="'+this.e[0].a+'"');UXb.fIb(a,' y="'+this.e[0].b+'"');this.a!=9&&UXb.fIb(a,' size="'+this.a+'"');this.b!=0&&UXb.fIb(a,' style="'+this.b+'"');return a.a;};_.Cb=function nv(){return a_b;};_.a=0;_.b=0;TXb.hmb=UFb(188);ZXb.ov=function ov(a){a.b=new $Xb.kj();a.a=new $Xb.kj();};ZXb.pv=function pv(a,b){var c,d;c=ZXb.iu(a,b);if(c==-1)return -1;d=a.b.a.length;$Xb.Si(a.b,b);$Xb.Ri(a.a,c,new UXb.HGb(d));return d;};ZXb.qv=function qv(){ZXb.ku.call(this);ZXb.ov(this);};wxb(384,115,a0b,ZXb.qv);_.Pb=function rv(a){var b;b=ZXb.ju(this,a);if(b==-1)return -1;return $Xb.Xi(this.a,b).a;};TXb.imb=UFb(384);_Xb.sv=function sv(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N;K=ZXb.so(a.e);L=$Xb.Xi(K.j,b).length;I=$Xb.Xi(K.i,b);J=$Xb.Xi(K.j,b);C=true;for(r=1;r<L;r++){if(_Xb.Hv(a.b,J[r])!=_Xb.Hv(a.b,J[0])){C=false;break;}}if(C){f=(L-2)*h0b/L;for(s=0;s<L;s++)_Xb.xv(a,I[s],J[s],J[s==0?L-1:s-1],f);return;}G=Rjb(TXb.jlb,r_b,6,L,15,1);e=0;for(t=0;t<L;t++){G[t]=ZXb.In(a.e,I[t])==0?1.9106119386631804:ZXb.In(a.e,I[t])==1?2.094499897810209:h0b;e+=G[t];}d=((L-2)*h0b-e)/L;for(u=0;u<L;u++)G[u]+=d;k=Rjb(TXb.jlb,r_b,6,L,15,1);for(v=1;v<L;v++)k[v]=k[v-1]+h0b-G[v];h=Rjb(TXb.jlb,r_b,6,L,15,1);for(g=0;g<100;g++){M=0;N=0;for(s=0;s<L;s++){M+=_Xb.Hv(a.b,J[s])*$wnd.Math.sin(k[s]);N+=_Xb.Hv(a.b,J[s])*$wnd.Math.cos(k[s]);}n=ZXb.fn(0,0,M,N);p=$wnd.Math.sqrt(M*M+N*N);F=-1;D=0;for(w=0;w<L;w++){A=w==0?L-1:w-1;B=w+1==L?0:w+1;i=ZXb.gn(k[w],k[A]);j=ZXb.gn(k[B],k[w]);H=ZXb.gn(G[w],G[B]);h[w]=2*i-2*j+2*H;o=$wnd.Math.cos(k[w]-i0b-n);m=p*o-j0b*h[w];if($wnd.Math.abs(m)>$wnd.Math.abs(D)){D=m;F=w;}}l=$wnd.Math.exp(-5*g/100);k[F]+=l*D;}for(q=0;q<L;q++){A=q==0?L-1:q-1;c=k[A]+h0b-k[q];c>NZb&&(c-=NZb);_Xb.xv(a,I[q],J[A],J[q],c);}};_Xb.tv=function tv(a,b){var c,d,e,f,g,h,i,j,k;i=ZXb.so(a.e);j=$Xb.Xi(i.j,b).length;h=$Xb.Xi(i.j,b);k=false;for(e=0;e<j;e++){if(a.f[h[e]]==0){k=true;break;}}if(k){c=(180*j-360)/j*0.01745329238474369;g=$Xb.Xi(i.i,b);for(f=0;f<j;f++){_Xb.xv(a,g[f],h[f==0?j-1:f-1],h[f],c);}if(j<=4){for(d=0;d<j;d++)a.f[h[d]]+=j;}}};_Xb.uv=function uv(a,b,c,d){var e,f,g,h;f=-1;g=-1;for(h=0;h<ZXb.Dn(a.e,b);h++){e=ZXb.Rn(a.e,b,h);if(e==c||e==d){if(g==-1){g=h;}else {f=h;break;}}}return a.a[b][f][g];};_Xb.vv=function vv(a,b,c,d){return c<d?a.a[b][d][c]:a.a[b][c][d];};_Xb.wv=function wv(a,b){var c,d,e,f,g,h,i;d=Rjb(TXb.Bwb,JZb,6,ZXb.Sn(a.e,b),16,1);i=0;for(e=0;e<ZXb.Sn(a.e,b);e++){h=0;g=-1;for(f=0;f<ZXb.Sn(a.e,b);f++){if(!d[f]){c=ZXb.Tn(a.e,b,f);if(h<a.f[c]){h=a.f[c];g=f;}}}if(h==0)return i;i<<=8;i+=h;d[g]=true;}return i;};_Xb.xv=function xv(a,b,c,d,e){var f,g,h,i;f=-1;g=-1;for(i=0;i<ZXb.Dn(a.e,b);i++){h=ZXb.Tn(a.e,b,i);if(h==c||h==d){if(f==-1){f=i;}else {g=i;break;}}}if(a.a[b][g][f]==0){a.a[b][g][f]=e;a.d[b]+=e;++a.c[b];}};_Xb.yv=function yv(a,b,c,d,e){var f,g,h,i,j,k;f=ZXb.Dn(a.e,b);i=ZXb.Sn(a.e,b);for(j=1;j<f;j++){g=j<i?a.f[ZXb.Tn(a.e,b,j)]:0;for(k=0;k<j;k++){if(a.a[b][j][k]==0){h=k<i?a.f[ZXb.Tn(a.e,b,k)]:0;(g==c&&h==d||g==d&&h==c)&&(a.a[b][j][k]=e);}}}};_Xb.zv=function zv(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;this.b=b;this.e=a;this.a=Rjb(TXb.jlb,_Yb,679,this.e.f,0,3);for(e=0;e<this.e.f;e++){this.a[e]=Rjb(TXb.jlb,{679:1,4:1,9:1,5:1,7:1},59,ZXb.Dn(this.e,e),0,2);for(i=1;i<ZXb.Dn(this.e,e);i++)this.a[e][i]=Rjb(TXb.jlb,r_b,6,i,15,1);}this.c=Rjb(TXb.klb,xZb,6,this.e.f,15,1);this.d=Rjb(TXb.jlb,r_b,6,this.e.f,15,1);this.f=Rjb(TXb.klb,xZb,6,this.e.g,15,1);w=ZXb.so(this.e);m=Rjb(TXb.Bwb,JZb,6,w.i.a.length,16,1);ZXb.Gr(w,m,Rjb(TXb.Bwb,JZb,6,w.i.a.length,16,1),Rjb(TXb.klb,xZb,6,w.i.a.length,15,1),true);for(h=3;h<=7;h++){for(r=0;r<w.i.a.length;r++){A=$Xb.Xi(w.j,r).length;A==h&&(m[r]?_Xb.sv(this,r):A<=4&&_Xb.tv(this,r));}}l=Rjb(TXb.Bwb,JZb,6,this.e.f,16,1);for(q=0;q<w.i.a.length;q++)if(m[q])for(t=$Xb.Xi(w.i,q),u=0,v=t.length;u<v;++u){s=t[u];l[s]=true;}f=Zjb(Ljb(TXb.klb,1),xZb,6,15,[0,0,1,3,6,10,15,21]);for(d=0;d<this.e.f;d++){g=ZXb.Dn(this.e,d);if(g>4){for(i=1;i<g;i++)for(o=0;o<i;o++)this.a[d][i][o]=i0b;this.c[d]=f[g];continue;}if(this.c[d]==f[g])continue;if(ZXb.Xo(this.e,d)&&(l[d]||ZXb.Mn(this.e,d)<=4&&ZXb.In(this.e,d)>0)){if(g>2){if(this.c[d]==1){ZXb.Qk(this.e,d)<=14?c=(k0b-this.d[d])/2:c=l0b+(l0b-this.d[d])*0.18000000715255737;}else {c=k0b-this.d[d];if(g>3){if(this.c[d]==2){n=Rjb(TXb.Bwb,JZb,6,ZXb.Dn(this.e,d),16,1);for(j=1;j<g;j++){for(p=0;p<j;p++){if(this.a[d][j][p]!=0){n[j]=!n[j];n[p]=!n[p];}}}for(k=0;k<g;k++){if(n[k]){for(p=k+1;p<g;p++){if(n[p]){this.a[d][p][k]=c;break;}}break;}}}c=i0b;}}for(i=1;i<g;i++)for(o=0;o<i;o++)this.a[d][i][o]==0&&(this.a[d][i][o]=c);}}else if(ZXb.Xo(this.e,d)&&ZXb.Mn(this.e,d)<=4){switch(_Xb.wv(this,d)){case 771:_Xb.yv(this,d,0,3,2.0653998851776123);_Xb.yv(this,d,0,0,1.9814722631346626);break;case 1028:_Xb.yv(this,d,0,4,1.9797999858856201);_Xb.yv(this,d,0,0,1.94691481878138);break;case 393987:_Xb.yv(this,d,0,3,m0b);_Xb.yv(this,d,0,6,m0b);_Xb.yv(this,d,3,3,1.7229016938441077);break;case 459779:_Xb.yv(this,d,0,3,n0b);_Xb.yv(this,d,0,4,n0b);_Xb.yv(this,d,0,7,n0b);_Xb.yv(this,d,3,4,1.9322539839360076);break;case 525316:_Xb.yv(this,d,0,4,o0b);_Xb.yv(this,d,0,8,o0b);_Xb.yv(this,d,4,4,1.99944913298566);case 394758:_Xb.yv(this,d,0,6,2.526099920272827);break;case 460550:_Xb.yv(this,d,0,6,p0b);_Xb.yv(this,d,0,7,p0b);break;case 526087:_Xb.yv(this,d,0,7,q0b);_Xb.yv(this,d,0,8,q0b);break;case 526344:_Xb.yv(this,d,0,8,2.186300039291382);break;case 50529027:_Xb.yv(this,d,3,3,2.4189000129699707);break;case 67371779:_Xb.yv(this,d,3,4,2.2298998832702637);break;case 67372036:_Xb.yv(this,d,4,4,2.094399929046631);break;case 101057283:_Xb.yv(this,d,3,6,1.839926051241747);_Xb.yv(this,d,3,3,2.9061476191098734);break;case 117834755:_Xb.yv(this,d,3,4,2.812249087174905);_Xb.yv(this,d,3,7,1.7910569124592968);_Xb.yv(this,d,4,6,2.1224948975613245);break;case 134677507:_Xb.yv(this,d,3,4,2.642428360523752);_Xb.yv(this,d,3,8,2.027723514585844);_Xb.yv(this,d,4,7,2.251474717631936);break;case 117900035:_Xb.yv(this,d,3,7,2.109753935530918);_Xb.yv(this,d,3,3,3.1052897491356646);break;case 117900292:_Xb.yv(this,d,4,7,2.090729910747413);_Xb.yv(this,d,4,4,2.551671293386306);break;case 134743044:_Xb.yv(this,d,4,8,2.139250042271712);_Xb.yv(this,d,4,4,2.3520055858942612);}}else {c=ZXb.Qk(this.e,d)>10?r0b:ZXb.In(this.e,d)==2?h0b:ZXb.Oo(this.e,d,true)?s0b:ZXb.In(this.e,d)==0?r0b:s0b;for(i=1;i<g;i++)for(o=0;o<i;o++)this.a[d][i][o]=c;}}};wxb(525,1,{},_Xb.zv);TXb.jmb=UFb(525);_Xb.Gv=function Gv(){_Xb.Gv=yxb;_Xb.Ev=Zjb(Ljb(TXb.Bwb,1),JZb,6,16,[false,false,false,false,false,true,true,true,true,false,false,false,false,false,false,true,true]);};_Xb.Hv=function Hv(a,b){return a.a[b];};_Xb.Iv=function Iv(a){_Xb.Gv();var b,c;ZXb.nu(a,7);this.a=Rjb(TXb.jlb,r_b,6,a.r,15,1);this.b=Rjb(TXb.jlb,r_b,6,a.r,15,1);for(b=0;b<a.r;b++){c=_Xb.Lv(a,b);if(c==-1){this.a[b]=_Xb.Mv(a,b);this.b[b]=_Xb.Nv(a,b);}else {this.a[b]=c==-1?2.000499963760376:_Xb.Cv[c];this.b[b]=c==-1?1:_Xb.Dv[c];}}};_Xb.Jv=function Jv(a,b){if(b>=a.f)return 0;if(b<a.f&&ZXb.Ur(a.p,b)&&a.C[b]==6&&a.s[b]!=0)return 1;return a.o[b];};_Xb.Kv=function Kv(a,b,c,d,e,f,g){var h,i,j,k,l;k=d<_Xb.Ev.length&&_Xb.Ev[d]?f<<8:0;l=e<_Xb.Ev.length&&_Xb.Ev[e]?g<<8:0;h=k+d;i=l+e;j=c?0:b?4+a:a;return (j<<24)+(h<i?(h<<12)+i:(i<<12)+h);};_Xb.Lv=function Lv(a,b){var c,d,e,f;c=a.D[0][b];d=a.D[1][b];e=a.C[c];f=a.C[d];return _Xb.Pv(_Xb.Kv(ZXb.bl(a,b),b<a.g&&ZXb.Vr(a.p,b),b<a.g&&(ZXb.Zr(a.p,b)||a.H[b]==64),e,f,_Xb.Jv(a,c),_Xb.Jv(a,d)));};_Xb.Mv=function Mv(a,b){var c,d;c=ZXb.Qk(a,a.D[0][b]);d=ZXb.Qk(a,a.D[1][b]);return (c<(_Xb.mx(),_Xb.kx).length?_Xb.kx[c]:c<_Xb.lx.length?t0b*_Xb.lx[c]:u0b)+(d<_Xb.kx.length?_Xb.kx[d]:d<_Xb.lx.length?t0b*_Xb.lx[d]:u0b);};_Xb.Nv=function Nv(a,b){var c,d;c=ZXb.Qk(a,a.D[0][b]);d=ZXb.Qk(a,a.D[1][b]);return (c<(_Xb.mx(),_Xb.kx).length?v0b:0.125)+(d<_Xb.kx.length?v0b:0.125);};_Xb.Ov=function Ov(){var b,c,d,e,f,g,h;if(!_Xb.Fv){b=(h=UXb.NHb('2312\n4099\t2.403\t0.282\t466\n4100\t1.407\t0.2\t28\n4103\t1.561\t0.023\t5\n4104\t1.42\t0.092\t491\n4105\t1.313\t0.149\t32\n4107\t2.677\t0.401\t190\n4108\t2.118\t0.244\t325\n4109\t1.978\t0.26\t968\n4113\t1.819\t0.033\t4\n4115\t3.194\t0.482\t381\n4116\t2.771\t0.32\t198\n4117\t2.398\t0.235\t145\n4118\t2.317\t0.22\t208\n4119\t2.034\t0.212\t34\n4120\t2.033\t0.286\t103\n4121\t1.959\t0.264\t122\n4122\t1.918\t0.267\t664\n4123\t1.893\t0.257\t185\n4124\t1.877\t0.218\t259\n4125\t2.05\t0.257\t556\n4126\t2.012\t0.239\t129\n4127\t1.979\t0.292\t196\n4133\t3.305\t0.429\t34\n4134\t2.593\t0.367\t83\n4135\t2.74\t0.174\t706\n4136\t2.462\t0.196\t611\n4137\t2.207\t0.264\t78\n4138\t2.16\t0.225\t359\n4140\t2.004\t0.188\t2204\n4141\t1.916\t0.256\t610\n4142\t1.95\t0.234\t126\n4143\t2.3\t0.213\t81\n4144\t2.187\t0.116\t6\n4145\t2.103\t0.153\t21\n4146\t2.031\t0.308\t83\n4147\t1.752\t0.443\t21\n4151\t3.49\t0.4\t83\n4152\t3.017\t0.331\t40\n4153\t2.932\t0.276\t176\n4154\t2.39\t0.34\t24\n4155\t3.124\t0.377\t16\n4156\t2.907\t0.232\t198\n4158\t2.857\t0.237\t142\n4159\t2.687\t0.244\t49\n4160\t2.787\t0.359\t29\n4161\t2.785\t0.306\t37\n4162\t2.623\t0.298\t175\n4163\t2.812\t0.154\t70\n4164\t2.745\t0.281\t100\n4165\t2.719\t0.184\t37\n4166\t2.683\t0.361\t231\n4167\t2.655\t0.253\t198\n4168\t2.546\t0.208\t37\n4169\t2.259\t0.231\t190\n4170\t2.043\t0.289\t251\n4171\t2.001\t0.221\t391\n4172\t1.984\t0.164\t885\n4173\t1.904\t0.228\t1074\n4174\t2.036\t0.224\t250\n4175\t1.955\t0.184\t6\n4176\t2.35\t0.15\t12\n4177\t2.367\t0.216\t7\n4178\t2.47\t0.186\t11\n4179\t0.95\t-1.0\t1\n4186\t2.88\t0.309\t39\n4188\t2.804\t0.289\t136\n4189\t2.172\t0.082\t12\n4190\t2.321\t0.0\t2\n4359\t1.503\t0.106\t24\n4360\t1.425\t0.052\t40\n12291\t2.861\t0.27\t1069\n12292\t2.773\t0.086\t4\n12293\t2.507\t0.251\t27\n12294\t2.769\t0.373\t370\n12299\t3.1\t0.221\t116\n12300\t2.844\t0.146\t9\n12301\t3.636\t0.002\t3\n12302\t2.779\t0.318\t189\n12307\t3.639\t0.518\t25\n12308\t3.205\t0.245\t16\n12317\t3.036\t0.064\t4\n12318\t2.88\t-1.0\t1\n12319\t2.615\t0.864\t3\n12320\t2.857\t0.129\t247\n12325\t3.557\t0.41\t18\n12326\t3.273\t0.208\t23\n12330\t3.496\t0.025\t2\n12333\t3.012\t0.276\t2\n12334\t2.679\t0.0\t2\n12338\t2.886\t0.196\t80\n12339\t2.871\t0.221\t18\n12343\t3.628\t0.266\t9\n12344\t3.37\t0.145\t35\n12346\t2.859\t0.0\t4\n12352\t2.722\t0.017\t4\n12354\t3.317\t0.016\t4\n12355\t2.714\t0.006\t2\n12357\t2.703\t0.005\t2\n12365\t2.615\t-1.0\t1\n12367\t2.729\t0.0\t2\n12368\t2.841\t0.0\t2\n12369\t2.889\t0.082\t5\n12370\t2.913\t0.126\t64\n12549\t3.003\t0.175\t18\n12550\t2.797\t0.21\t1156\n12805\t2.63\t0.0\t2\n12806\t2.939\t0.243\t85\n16388\t2.29\t0.104\t57\n16389\t2.022\t0.097\t6\n16390\t2.097\t0.127\t21\n16391\t1.771\t0.395\t281\n16392\t1.648\t0.242\t634\n16393\t1.567\t0.555\t264\n16395\t2.926\t0.104\t14\n16397\t2.368\t-1.0\t1\n16398\t3.269\t-1.0\t1\n16399\t2.211\t0.15\t6\n16400\t2.1\t-1.0\t1\n16401\t2.065\t0.622\t37\n16403\t3.355\t0.087\t11\n16404\t2.9\t0.136\t2\n16416\t2.399\t0.154\t3\n16417\t2.06\t0.0\t2\n16418\t2.195\t-1.0\t1\n16419\t2.167\t0.95\t16\n16421\t3.378\t-1.0\t1\n16422\t2.886\t0.031\t2\n16429\t2.375\t0.124\t6\n16435\t2.635\t-1.0\t1\n16436\t2.399\t-1.0\t1\n16437\t2.417\t0.96\t23\n16439\t3.716\t0.078\t2\n16442\t3.052\t0.0\t4\n16463\t2.64\t-1.0\t1\n16466\t2.23\t-1.0\t1\n16474\t3.061\t0.0\t4\n16476\t3.017\t0.004\t8\n16645\t1.954\t-1.0\t1\n16646\t2.276\t0.281\t56\n16647\t1.966\t0.14\t51\n16648\t1.843\t0.124\t41\n16902\t1.739\t0.003\t2\n16903\t2.003\t-1.0\t1\n20491\t2.681\t-1.0\t1\n20492\t2.402\t0.287\t12\n20493\t2.373\t0.17\t6\n20499\t3.054\t0.395\t11\n20500\t3.076\t0.081\t2\n20501\t2.3\t1.168\t20\n20502\t2.221\t0.057\t3\n20503\t1.964\t-1.0\t1\n20504\t2.515\t0.236\t21\n20505\t1.97\t0.231\t70\n20506\t2.056\t0.352\t138\n20507\t2.553\t0.302\t81\n20508\t2.489\t0.321\t24\n20509\t2.215\t0.363\t36\n20510\t2.786\t0.026\t6\n20511\t2.418\t0.106\t10\n20517\t3.193\t0.063\t3\n20519\t2.598\t0.187\t9\n20520\t2.376\t0.309\t9\n20522\t2.708\t0.265\t154\n20524\t2.526\t0.319\t123\n20525\t2.262\t0.289\t122\n20526\t2.502\t0.287\t18\n20527\t2.365\t0.284\t11\n20528\t2.966\t0.038\t6\n20529\t2.584\t0.061\t7\n20530\t2.771\t0.387\t5\n20531\t1.29\t0.001\t12\n20535\t3.368\t0.154\t5\n20536\t3.023\t0.074\t6\n20537\t2.913\t0.0\t2\n20538\t3.021\t0.331\t2\n20540\t2.651\t0.201\t5\n20543\t2.735\t0.344\t5\n20546\t2.531\t0.277\t7\n20549\t3.267\t-1.0\t1\n20550\t2.329\t0.34\t7\n20552\t2.499\t0.02\t6\n20553\t2.703\t0.218\t20\n20554\t2.693\t0.292\t46\n20555\t2.639\t0.27\t40\n20556\t2.066\t0.059\t39\n20557\t2.599\t0.324\t183\n20558\t2.048\t0.149\t134\n20559\t2.327\t0.386\t34\n20560\t2.179\t-1.0\t1\n20561\t2.619\t-1.0\t1\n20562\t2.967\t-1.0\t1\n20570\t2.665\t0.007\t2\n20572\t2.63\t0.19\t9\n20742\t1.87\t0.155\t40\n24587\t3.525\t0.393\t28\n24588\t2.763\t0.313\t380\n24589\t2.462\t0.308\t5373\n24595\t4.077\t0.356\t19\n24596\t3.17\t0.362\t45\n24597\t2.829\t0.525\t432\n24598\t2.656\t0.164\t627\n24599\t2.654\t0.158\t57\n24600\t2.57\t0.26\t309\n24601\t2.625\t0.288\t208\n24602\t2.45\t0.223\t1004\n24603\t2.182\t0.257\t1071\n24604\t2.355\t0.185\t1159\n24605\t2.384\t0.162\t130\n24606\t2.479\t0.188\t1375\n24607\t2.547\t0.23\t805\n24613\t3.789\t0.188\t2\n24614\t3.484\t0.291\t8\n24615\t3.089\t0.34\t499\n24616\t2.809\t0.177\t912\n24617\t2.665\t0.147\t106\n24618\t2.632\t0.3\t598\n24620\t2.419\t0.207\t1127\n24621\t2.466\t0.217\t582\n24622\t2.456\t0.168\t1672\n24623\t2.573\t0.135\t12\n24624\t2.753\t0.503\t34\n24625\t2.695\t0.487\t478\n24626\t2.644\t0.444\t4321\n24627\t2.655\t0.961\t518\n24631\t3.712\t0.709\t3\n24632\t3.745\t0.575\t6\n24633\t3.382\t0.306\t128\n24634\t3.417\t0.336\t41\n24635\t3.236\t0.278\t27\n24636\t3.365\t0.272\t72\n24638\t3.236\t0.316\t52\n24639\t3.097\t0.0\t2\n24640\t2.718\t0.258\t39\n24641\t3.353\t0.103\t6\n24642\t3.087\t0.178\t51\n24643\t2.988\t0.348\t31\n24644\t2.995\t0.182\t58\n24645\t3.221\t0.798\t58\n24646\t3.104\t0.353\t86\n24647\t3.019\t0.515\t320\n24648\t2.735\t0.176\t341\n24649\t2.703\t0.204\t299\n24650\t2.595\t0.331\t829\n24651\t2.536\t0.58\t227\n24652\t2.472\t0.25\t206\n24653\t2.534\t0.168\t933\n24654\t2.491\t0.326\t1889\n24655\t2.445\t0.168\t254\n24656\t2.51\t0.162\t95\n24657\t3.004\t0.801\t27\n24658\t2.961\t0.516\t71\n24659\t3.105\t0.444\t106\n24666\t3.114\t0.326\t123\n24668\t3.098\t0.303\t230\n28685\t2.353\t0.307\t3006\n28693\t2.684\t0.241\t703\n28694\t2.452\t0.242\t3992\n28695\t2.409\t0.319\t1209\n28696\t2.464\t0.534\t2219\n28697\t2.577\t0.289\t2590\n28698\t2.456\t0.2\t6911\n28699\t2.41\t0.36\t7053\n28700\t2.487\t0.231\t7446\n28701\t2.406\t0.194\t9772\n28702\t2.479\t0.227\t5502\n28703\t2.471\t0.309\t929\n28711\t2.921\t0.239\t1714\n28712\t2.679\t0.232\t2798\n28713\t2.442\t0.272\t911\n28714\t2.445\t0.293\t2412\n28716\t2.475\t0.298\t2904\n28717\t2.428\t0.335\t1207\n28718\t2.458\t0.222\t3289\n28719\t2.487\t0.247\t1033\n28720\t2.81\t0.231\t768\n28721\t2.785\t0.35\t616\n28722\t2.606\t0.37\t1703\n28723\t2.599\t0.29\t531\n28729\t3.125\t0.329\t626\n28730\t3.082\t0.337\t728\n28731\t3.179\t0.249\t153\n28732\t3.022\t0.208\t458\n28734\t3.032\t0.245\t890\n28735\t3.194\t0.258\t616\n28736\t3.148\t0.29\t455\n28737\t3.124\t0.266\t301\n28738\t3.028\t0.263\t602\n28739\t2.987\t0.306\t159\n28740\t2.919\t0.28\t496\n28741\t3.182\t0.365\t119\n28742\t2.892\t0.229\t1179\n28743\t2.821\t0.212\t549\n28744\t2.607\t0.225\t683\n28745\t2.503\t0.227\t1194\n28746\t2.395\t0.326\t1012\n28747\t2.447\t0.267\t941\n28748\t2.383\t0.233\t326\n28749\t2.511\t0.279\t970\n28750\t2.457\t0.24\t1884\n28751\t2.393\t0.172\t533\n28752\t2.849\t0.285\t194\n28753\t2.973\t0.272\t62\n28754\t2.876\t0.236\t326\n28755\t2.753\t0.232\t424\n28762\t3.088\t0.249\t588\n28764\t2.972\t0.34\t2780\n28765\t3.016\t0.335\t10\n28766\t3.297\t0.204\t7\n32781\t2.145\t0.448\t7124\n32789\t2.625\t0.845\t799\n32790\t2.338\t0.282\t13095\n32791\t2.352\t0.77\t18035\n32792\t2.299\t0.427\t5228\n32793\t2.387\t0.292\t15567\n32794\t2.358\t0.225\t12153\n32795\t2.38\t0.29\t13623\n32796\t2.421\t0.301\t14996\n32797\t2.272\t0.223\t19019\n32798\t2.378\t0.357\t12982\n32799\t2.317\t0.208\t831\n32807\t2.796\t0.315\t3153\n32808\t2.497\t0.249\t4631\n32809\t2.375\t0.365\t1523\n32810\t2.347\t0.467\t31965\n32812\t2.419\t0.158\t3311\n32813\t2.436\t0.193\t2109\n32814\t2.4\t0.154\t2649\n32815\t2.661\t0.256\t865\n32816\t2.694\t0.218\t2847\n32817\t2.616\t0.276\t949\n32818\t2.579\t0.438\t4702\n32819\t2.309\t0.553\t1993\n32825\t2.994\t0.343\t2113\n32826\t2.856\t0.3\t2621\n32827\t2.93\t0.228\t1218\n32828\t2.905\t0.207\t2518\n32830\t2.869\t0.237\t2353\n32831\t2.827\t0.209\t3697\n32832\t2.834\t0.197\t5222\n32833\t2.78\t0.177\t4383\n32834\t2.738\t0.205\t8482\n32835\t2.747\t0.193\t1707\n32836\t2.742\t0.193\t2196\n32837\t2.798\t0.21\t502\n32838\t2.734\t0.235\t2716\n32839\t2.767\t0.212\t885\n32840\t2.498\t0.29\t774\n32841\t2.373\t0.261\t1221\n32842\t2.285\t0.417\t9618\n32843\t2.218\t0.348\t3304\n32844\t2.411\t0.2\t303\n32845\t2.462\t0.304\t1297\n32846\t2.393\t0.203\t1953\n32847\t2.305\t0.24\t286\n32848\t2.736\t0.309\t162\n32849\t2.822\t0.336\t202\n32850\t2.624\t0.233\t1404\n32851\t2.579\t0.268\t1906\n32858\t2.759\t0.291\t759\n32860\t2.611\t0.412\t7083\n32861\t2.503\t0.425\t287\n32862\t2.802\t0.399\t255\n32863\t2.837\t0.483\t20\n32864\t3.097\t0.448\t5\n32865\t2.94\t0.02\t3\n32866\t2.916\t0.021\t3\n36877\t1.811\t0.461\t1163\n36885\t2.022\t0.295\t129\n36886\t2.262\t0.492\t1106\n36887\t2.576\t0.889\t536\n36888\t1.937\t0.267\t474\n36889\t2.093\t0.73\t296\n36890\t1.929\t0.743\t373\n36891\t2.283\t0.257\t113\n36892\t2.221\t0.196\t116\n36893\t2.345\t0.817\t110\n36894\t2.065\t0.336\t75\n36895\t2.412\t0.358\t76\n36903\t2.125\t0.259\t44\n36904\t2.154\t1.055\t667\n36905\t2.12\t0.459\t502\n36906\t2.031\t0.453\t512\n36908\t2.395\t0.388\t43\n36909\t2.339\t0.338\t54\n36910\t2.361\t0.307\t101\n36911\t2.57\t0.191\t9\n36912\t2.427\t0.207\t26\n36913\t2.059\t1.008\t121\n36914\t2.126\t0.626\t419\n36915\t2.193\t0.262\t8674\n36921\t2.731\t0.286\t10\n36922\t2.995\t1.207\t51\n36923\t2.406\t0.044\t8\n36924\t2.742\t0.246\t33\n36926\t2.795\t0.182\t52\n36927\t2.799\t0.303\t24\n36928\t2.454\t0.018\t4\n36929\t1.96\t0.0\t6\n36930\t2.434\t0.192\t19\n36931\t2.857\t-1.0\t1\n36932\t2.747\t0.211\t25\n36934\t2.687\t0.139\t19\n36935\t2.806\t0.003\t4\n36936\t2.107\t0.444\t90\n36937\t2.149\t0.225\t250\n36938\t1.882\t0.247\t232\n36939\t2.0\t0.93\t274\n36940\t2.276\t0.144\t56\n36941\t2.293\t1.188\t69\n36942\t2.356\t0.364\t53\n36943\t1.893\t0.555\t149\n36944\t2.373\t0.0\t2\n36945\t2.015\t0.261\t45\n36946\t2.333\t0.203\t37\n36947\t2.152\t0.196\t94\n36954\t2.666\t0.268\t30\n36955\t2.205\t0.007\t16\n36956\t2.285\t0.379\t153\n36957\t2.26\t0.017\t10\n45067\t3.369\t0.477\t389\n45068\t3.242\t-1.0\t1\n45069\t3.524\t0.425\t2\n45070\t3.558\t0.0\t2\n45075\t3.592\t0.346\t36\n45076\t3.383\t0.133\t22\n45081\t3.221\t0.182\t3\n45082\t2.923\t0.336\t4\n45083\t3.382\t-1.0\t1\n45084\t2.961\t0.097\t3\n45087\t3.136\t-1.0\t1\n45088\t3.161\t0.174\t9\n45093\t3.645\t0.249\t17\n45094\t3.529\t0.167\t10\n45101\t3.618\t-1.0\t1\n45106\t3.243\t0.311\t72\n45107\t3.33\t0.219\t17\n45111\t3.704\t0.248\t22\n45112\t3.585\t0.155\t9\n45134\t3.136\t-1.0\t1\n45136\t3.234\t0.09\t7\n45137\t3.405\t0.105\t12\n45138\t3.441\t0.118\t15\n45139\t3.281\t0.068\t7\n45317\t3.245\t0.017\t2\n45318\t3.261\t0.178\t294\n45573\t2.685\t-1.0\t1\n45574\t3.187\t0.261\t35\n49164\t3.052\t0.123\t490\n49165\t3.401\t-1.0\t1\n49166\t2.887\t0.569\t39\n49171\t4.275\t0.055\t2\n49172\t3.412\t0.019\t8\n49177\t3.408\t-1.0\t1\n49178\t3.072\t0.063\t8\n49181\t3.334\t0.086\t3\n49182\t3.217\t0.061\t2\n49183\t2.836\t0.772\t13\n49184\t2.807\t0.438\t17\n49190\t3.648\t0.307\t28\n49191\t2.187\t0.0\t6\n49194\t2.466\t0.0\t2\n49197\t2.818\t0.099\t91\n49202\t2.927\t0.036\t9\n49203\t2.862\t0.432\t19\n49207\t3.807\t0.0\t2\n49208\t3.659\t0.045\t20\n49209\t3.53\t0.075\t16\n49210\t3.447\t0.003\t12\n49211\t3.506\t0.0\t3\n49212\t3.54\t0.0\t3\n49214\t3.463\t0.0\t3\n49215\t3.48\t0.014\t8\n49216\t3.364\t0.0\t3\n49221\t3.144\t0.0\t12\n49229\t2.7\t0.086\t48\n49230\t3.087\t0.019\t2\n49233\t3.145\t0.004\t2\n49413\t2.826\t0.154\t5\n49414\t2.811\t0.216\t411\n49670\t2.681\t0.238\t49\n53261\t3.147\t0.471\t69\n53262\t3.263\t0.176\t31\n53263\t3.143\t0.346\t218\n53264\t2.983\t0.385\t264\n53265\t2.601\t0.322\t2017\n53268\t3.669\t-1.0\t1\n53272\t2.557\t-1.0\t1\n53273\t2.309\t-1.0\t1\n53274\t2.908\t0.179\t18\n53275\t2.828\t0.234\t10\n53276\t2.655\t0.245\t6\n53277\t2.352\t0.06\t13\n53278\t3.3\t0.187\t3\n53279\t3.414\t0.37\t3\n53280\t2.499\t0.185\t12\n53281\t2.448\t0.051\t41\n53282\t2.875\t0.469\t72\n53283\t2.741\t0.288\t381\n53286\t3.495\t0.045\t15\n53292\t2.999\t-1.0\t1\n53293\t3.023\t0.354\t19\n53294\t2.951\t0.089\t21\n53295\t3.08\t-1.0\t1\n53297\t3.715\t-1.0\t1\n53298\t3.418\t0.0\t2\n53299\t2.655\t0.502\t19\n53300\t2.915\t0.495\t30\n53301\t3.049\t0.382\t137\n53303\t2.804\t1.394\t2\n53304\t3.582\t0.06\t4\n53305\t3.584\t0.347\t3\n53308\t3.56\t0.086\t2\n53322\t3.218\t0.048\t2\n53325\t3.468\t0.243\t2\n53326\t3.202\t0.139\t4\n53331\t3.74\t0.255\t4\n53340\t4.01\t0.006\t2\n53509\t2.605\t0.31\t8\n53510\t2.407\t0.249\t1700\n53511\t2.374\t0.163\t1982\n53512\t2.216\t0.23\t533\n53519\t2.935\t0.196\t5\n53520\t2.843\t0.186\t40\n53766\t2.468\t0.199\t96\n53767\t2.448\t0.135\t44\n53768\t1.978\t0.199\t4\n57363\t4.548\t0.464\t19\n57364\t3.083\t0.417\t13\n57366\t3.671\t0.019\t4\n57367\t3.246\t0.035\t4\n57368\t2.795\t0.193\t8\n57369\t2.811\t0.292\t27\n57370\t2.847\t0.192\t233\n57371\t2.715\t0.262\t77\n57372\t2.749\t0.228\t147\n57373\t2.884\t0.306\t43\n57374\t3.288\t0.273\t42\n57375\t3.561\t0.36\t4\n57382\t3.347\t0.097\t2\n57384\t3.775\t0.176\t18\n57385\t3.436\t0.115\t26\n57386\t3.224\t0.255\t49\n57388\t2.956\t0.338\t151\n57389\t2.78\t0.227\t106\n57390\t2.921\t0.275\t97\n57391\t3.357\t0.302\t20\n57393\t3.19\t0.085\t14\n57394\t3.662\t0.527\t210\n57395\t3.917\t0.191\t58\n57399\t3.91\t0.0\t4\n57400\t3.327\t0.062\t5\n57402\t3.01\t0.585\t8\n57406\t4.511\t0.25\t17\n57407\t4.503\t0.08\t6\n57409\t3.926\t0.003\t2\n57411\t3.905\t0.012\t2\n57414\t4.362\t0.205\t19\n57416\t3.87\t0.205\t13\n57417\t3.437\t0.24\t5\n57418\t3.085\t0.21\t66\n57419\t2.96\t0.12\t14\n57420\t3.028\t0.125\t7\n57421\t2.797\t0.286\t150\n57422\t2.978\t0.215\t175\n57423\t2.761\t0.465\t12\n57424\t3.53\t0.211\t22\n57426\t3.874\t0.316\t17\n57427\t4.031\t0.321\t9\n61461\t3.38\t0.299\t100\n61462\t3.21\t0.369\t276\n61463\t3.131\t0.207\t110\n61464\t2.873\t0.244\t730\n61465\t2.696\t0.32\t774\n61466\t2.697\t0.243\t4802\n61467\t2.679\t0.235\t3056\n61468\t2.676\t0.196\t4702\n61469\t2.64\t0.179\t5253\n61470\t2.912\t0.244\t119\n61471\t3.023\t0.242\t152\n61479\t3.617\t0.27\t57\n61480\t3.41\t0.235\t240\n61481\t3.284\t0.297\t129\n61482\t3.002\t0.261\t2058\n61484\t2.758\t0.203\t6616\n61485\t2.714\t0.205\t4052\n61486\t2.713\t0.193\t6710\n61487\t2.863\t0.16\t1964\n61488\t3.199\t0.271\t42\n61489\t3.285\t0.255\t93\n61490\t3.243\t0.31\t221\n61491\t3.183\t0.277\t77\n61497\t3.201\t0.305\t27\n61498\t2.934\t0.476\t9\n61500\t3.451\t0.1\t14\n61502\t3.794\t0.117\t26\n61506\t3.579\t0.083\t13\n61507\t3.584\t0.109\t8\n61508\t3.774\t0.0\t2\n61510\t3.577\t0.217\t22\n61511\t3.739\t0.336\t7\n61512\t3.408\t0.222\t72\n61513\t3.244\t0.257\t147\n61514\t3.003\t0.256\t1665\n61515\t2.906\t0.239\t1623\n61516\t2.798\t0.241\t1057\n61517\t2.754\t0.215\t2863\n61518\t2.714\t0.201\t6668\n61519\t2.668\t0.172\t4216\n61520\t2.879\t0.203\t76\n61521\t3.471\t0.204\t33\n61522\t3.487\t0.164\t39\n61523\t3.141\t0.234\t30\n61530\t3.726\t0.298\t60\n61532\t3.891\t0.328\t80\n65557\t3.412\t0.368\t35\n65558\t2.901\t0.267\t387\n65559\t2.852\t0.348\t489\n65560\t2.881\t0.289\t268\n65561\t2.726\t0.281\t883\n65562\t2.718\t0.226\t7921\n65563\t2.724\t0.272\t1489\n65564\t2.606\t0.234\t5975\n65565\t2.755\t0.225\t5038\n65566\t2.788\t0.225\t1360\n65567\t2.767\t0.214\t227\n65575\t3.418\t0.184\t159\n65576\t3.376\t0.277\t123\n65577\t2.954\t0.528\t373\n65578\t2.911\t0.288\t3355\n65580\t2.816\t0.192\t1907\n65581\t2.839\t0.173\t765\n65582\t2.775\t0.192\t2485\n65583\t3.093\t0.232\t4438\n65584\t3.087\t0.238\t609\n65585\t3.111\t0.393\t484\n65586\t2.949\t0.477\t1247\n65587\t2.995\t0.415\t696\n65593\t3.611\t0.276\t65\n65594\t3.5\t0.164\t59\n65595\t3.551\t0.145\t18\n65596\t3.459\t0.169\t45\n65598\t3.453\t0.18\t175\n65599\t3.683\t0.232\t44\n65600\t3.412\t0.05\t10\n65601\t3.114\t0.282\t6\n65602\t3.516\t0.333\t73\n65603\t3.018\t0.572\t5\n65604\t3.488\t0.196\t81\n65605\t3.266\t0.272\t10\n65606\t3.254\t0.188\t179\n65607\t3.336\t0.194\t34\n65608\t3.554\t0.326\t21\n65609\t2.461\t0.31\t329\n65610\t2.919\t0.288\t2082\n65611\t2.8\t0.267\t1996\n65612\t2.475\t0.252\t240\n65613\t2.833\t0.153\t655\n65614\t2.73\t0.196\t2208\n65615\t2.776\t0.277\t3697\n65616\t2.944\t0.23\t538\n65617\t3.031\t0.277\t17\n65618\t3.147\t0.26\t222\n65619\t3.099\t0.284\t350\n65626\t3.319\t0.35\t170\n65628\t3.382\t0.265\t290\n65629\t3.399\t0.077\t8\n65630\t2.931\t0.387\t17\n65631\t3.438\t0.046\t3\n65632\t3.441\t0.047\t3\n69653\t3.008\t0.308\t233\n69654\t2.799\t0.246\t2597\n69655\t2.789\t0.215\t490\n69656\t2.8\t0.199\t1394\n69657\t2.875\t0.267\t1182\n69658\t2.712\t0.238\t3474\n69659\t2.694\t0.227\t2713\n69660\t2.758\t0.28\t2082\n69661\t2.701\t0.25\t5780\n69662\t2.642\t0.425\t3822\n69663\t2.661\t0.254\t1485\n69671\t3.218\t0.274\t409\n69672\t2.991\t0.248\t1900\n69673\t2.903\t0.356\t1449\n69674\t2.907\t0.475\t2267\n69676\t2.885\t0.203\t5377\n69677\t2.863\t0.235\t2604\n69678\t2.776\t0.213\t6900\n69679\t3.032\t0.245\t617\n69680\t2.974\t0.221\t1026\n69681\t2.957\t0.377\t932\n69682\t2.928\t0.391\t2452\n69683\t2.872\t0.46\t1745\n69689\t3.393\t0.345\t120\n69690\t3.542\t0.471\t133\n69691\t3.384\t0.328\t54\n69692\t3.319\t0.289\t122\n69694\t3.354\t0.248\t151\n69695\t3.179\t0.349\t113\n69696\t3.251\t0.372\t116\n69697\t3.069\t0.3\t85\n69698\t3.114\t0.336\t295\n69699\t3.273\t0.344\t35\n69700\t3.214\t0.336\t160\n69701\t2.947\t0.43\t25\n69702\t3.224\t0.207\t183\n69703\t3.182\t0.198\t73\n69704\t2.972\t0.302\t357\n69705\t2.911\t0.327\t1000\n69706\t2.885\t0.369\t1787\n69707\t2.801\t0.257\t2221\n69708\t2.851\t0.255\t681\n69709\t2.879\t0.222\t2186\n69710\t2.757\t0.265\t4336\n69711\t2.675\t0.201\t2687\n69712\t2.804\t0.27\t1229\n69713\t2.554\t0.473\t192\n69714\t3.224\t0.457\t625\n69715\t3.107\t0.371\t1402\n69722\t3.417\t0.306\t157\n69723\t2.64\t0.0\t4\n69724\t3.21\t0.343\t893\n69725\t3.181\t0.284\t122\n69726\t3.088\t0.296\t154\n69727\t2.915\t-1.0\t1\n69728\t2.915\t-1.0\t1\n69729\t2.465\t0.0\t6\n77843\t3.904\t0.444\t476\n77844\t3.931\t0.219\t13\n77847\t3.213\t0.001\t2\n77848\t3.318\t0.114\t5\n77849\t3.574\t0.313\t3\n77850\t3.205\t-1.0\t1\n77851\t3.463\t0.411\t4\n77852\t3.491\t0.534\t2\n77853\t3.822\t0.039\t3\n77854\t3.511\t0.765\t6\n77856\t3.502\t0.647\t78\n77861\t3.9\t0.078\t12\n77862\t3.806\t0.091\t8\n77864\t3.807\t-1.0\t1\n77865\t3.535\t0.137\t7\n77870\t3.386\t0.218\t17\n77871\t3.245\t0.006\t2\n77874\t3.754\t0.595\t67\n77875\t3.655\t0.42\t25\n77879\t3.899\t0.365\t31\n77880\t4.729\t0.676\t2\n77898\t4.496\t0.606\t3\n77902\t3.48\t0.0\t4\n77905\t3.736\t0.08\t11\n77906\t3.724\t0.099\t26\n77907\t3.562\t0.045\t4\n77917\t4.592\t-1.0\t1\n78085\t3.76\t0.113\t8\n78086\t3.713\t0.29\t1287\n78342\t3.557\t0.28\t73\n81940\t3.661\t0.289\t176\n81943\t3.019\t-1.0\t1\n81944\t2.85\t-1.0\t1\n81945\t3.324\t0.0\t2\n81951\t3.151\t-1.0\t1\n81952\t3.185\t0.116\t25\n81957\t3.75\t0.247\t3\n81958\t3.579\t0.106\t3\n81967\t3.517\t0.128\t5\n81969\t3.26\t0.128\t3\n81970\t3.346\t0.13\t71\n81971\t3.246\t0.132\t128\n81975\t3.895\t0.219\t5\n81976\t3.719\t0.202\t10\n81997\t3.133\t0.007\t2\n81999\t3.088\t0.086\t20\n82000\t3.26\t0.098\t4\n82001\t3.332\t-1.0\t1\n82002\t3.427\t0.083\t10\n82003\t3.25\t0.171\t45\n82012\t3.805\t-1.0\t1\n82182\t3.212\t0.212\t411\n82438\t2.973\t0.227\t13\n86044\t2.357\t-1.0\t1\n86050\t3.301\t0.106\t5\n86051\t3.223\t0.408\t15\n86053\t3.906\t-1.0\t1\n86062\t2.711\t0.034\t2\n86068\t3.534\t0.111\t4\n86069\t3.014\t0.266\t86\n86277\t3.132\t0.206\t3\n86278\t3.08\t0.205\t1002\n86279\t2.704\t0.168\t460\n86280\t2.561\t0.163\t44\n86287\t3.292\t0.078\t26\n86288\t3.128\t0.068\t7\n86534\t2.902\t0.101\t13\n86535\t2.446\t0.18\t5\n90134\t3.158\t0.093\t9\n90138\t2.576\t0.185\t3\n90139\t2.835\t0.161\t13\n90140\t2.925\t0.174\t8\n90141\t3.761\t-1.0\t1\n90143\t3.058\t0.0\t2\n90144\t2.522\t0.784\t3\n90145\t2.482\t0.209\t46\n90146\t3.164\t0.558\t44\n90147\t2.774\t0.281\t113\n90150\t3.233\t0.034\t7\n90156\t3.193\t-1.0\t1\n90157\t2.921\t-1.0\t1\n90161\t3.271\t0.0\t2\n90162\t3.869\t0.023\t3\n90163\t3.573\t0.143\t28\n90164\t3.347\t0.022\t18\n90165\t2.62\t0.414\t54\n90168\t3.427\t0.036\t8\n90194\t3.897\t-1.0\t1\n90373\t3.171\t0.268\t3\n90374\t2.926\t0.185\t13105\n90375\t2.587\t0.178\t1875\n90376\t2.456\t0.185\t917\n90383\t3.113\t0.322\t22\n90384\t3.044\t0.167\t14\n90630\t2.624\t0.183\t73\n90631\t2.431\t0.217\t59\n90632\t2.541\t0.214\t13\n94231\t2.269\t0.138\t9\n94234\t2.503\t0.095\t6\n94235\t2.637\t0.592\t3\n94236\t3.236\t0.203\t2\n94242\t2.529\t0.487\t29\n94243\t2.969\t0.254\t17\n94264\t3.486\t-1.0\t1\n94286\t2.784\t0.083\t10\n94470\t2.664\t0.196\t1656\n94471\t2.46\t0.141\t1730\n94472\t2.373\t0.21\t563\n94479\t3.002\t0.084\t9\n94480\t2.809\t0.211\t72\n94726\t2.339\t0.204\t93\n94727\t2.461\t0.173\t28\n94728\t2.22\t0.033\t36\n98328\t2.585\t0.33\t139\n98329\t3.026\t0.483\t6\n98330\t3.053\t0.116\t7\n98331\t2.861\t0.157\t7\n98332\t3.016\t0.06\t2\n98333\t2.906\t-1.0\t1\n98334\t3.171\t-1.0\t1\n98335\t2.778\t0.078\t6\n98336\t2.83\t0.006\t4\n98337\t2.984\t0.301\t63\n98338\t3.557\t0.536\t97\n98339\t2.852\t0.31\t66\n98341\t3.47\t0.104\t3\n98349\t3.572\t-1.0\t1\n98350\t3.259\t0.092\t4\n98354\t3.11\t0.137\t19\n98355\t3.017\t0.193\t20\n98356\t3.203\t0.219\t43\n98357\t3.129\t0.376\t67\n98378\t3.04\t-1.0\t1\n98381\t3.568\t-1.0\t1\n98382\t3.15\t0.188\t5\n98383\t3.133\t0.037\t3\n98384\t3.045\t0.0\t2\n98386\t3.121\t0.097\t12\n98387\t3.325\t0.016\t2\n98565\t2.688\t0.12\t18\n98566\t2.619\t0.153\t6878\n98567\t2.404\t0.141\t2515\n98568\t2.41\t0.174\t638\n98575\t3.098\t0.146\t259\n98576\t2.876\t0.25\t37\n98822\t2.158\t0.152\t4143\n98823\t2.42\t0.131\t56\n98824\t2.468\t0.236\t5\n102425\t3.087\t0.258\t19\n102426\t2.867\t0.103\t4\n102427\t3.03\t0.131\t2\n102428\t2.886\t-1.0\t1\n102431\t3.326\t0.375\t7\n102432\t2.775\t0.168\t35\n102433\t2.737\t0.092\t14\n102434\t3.052\t0.275\t320\n102435\t2.947\t0.279\t501\n102438\t3.136\t0.442\t2\n102442\t3.198\t-1.0\t1\n102444\t2.998\t0.081\t3\n102445\t2.848\t0.318\t2\n102447\t3.116\t0.312\t4\n102449\t2.668\t0.007\t12\n102450\t2.65\t0.156\t37\n102451\t2.804\t0.128\t97\n102452\t3.71\t0.389\t143\n102453\t3.196\t0.352\t77\n102476\t2.993\t0.038\t4\n102478\t3.256\t-1.0\t1\n102479\t3.089\t0.272\t5\n102480\t2.61\t0.003\t4\n102481\t3.397\t-1.0\t1\n102482\t2.754\t0.035\t4\n102483\t2.878\t0.096\t25\n102661\t2.718\t0.111\t3\n102662\t2.482\t0.226\t2788\n102663\t2.511\t0.177\t8370\n102664\t2.493\t0.179\t2602\n102671\t2.643\t0.184\t45\n102672\t2.962\t0.176\t53\n102918\t2.052\t0.149\t4796\n102919\t2.51\t0.179\t433\n102920\t2.374\t0.161\t19\n106522\t2.941\t0.371\t219\n106523\t2.892\t0.261\t5\n106524\t2.877\t0.111\t7\n106525\t2.863\t0.149\t85\n106526\t2.98\t0.096\t34\n106527\t2.834\t0.242\t89\n106528\t2.743\t0.335\t128\n106529\t2.701\t0.254\t143\n106530\t2.739\t0.223\t715\n106531\t2.904\t0.242\t866\n106536\t3.002\t0.349\t8\n106537\t2.799\t0.229\t2\n106538\t3.086\t0.144\t4\n106540\t2.735\t0.302\t14\n106541\t2.768\t0.387\t2\n106542\t3.159\t0.157\t17\n106543\t2.781\t0.205\t11\n106545\t3.031\t0.266\t33\n106546\t3.013\t0.266\t96\n106547\t2.844\t0.229\t38\n106548\t2.92\t0.185\t202\n106549\t3.146\t0.267\t200\n106551\t3.701\t0.004\t2\n106552\t3.508\t0.08\t2\n106554\t3.692\t-1.0\t1\n106556\t3.882\t-1.0\t1\n106566\t3.665\t0.215\t7\n106570\t3.257\t0.114\t4\n106571\t2.863\t0.015\t4\n106572\t2.976\t0.164\t5\n106574\t3.224\t0.085\t11\n106575\t2.779\t0.247\t4\n106576\t2.981\t0.124\t18\n106577\t3.014\t0.072\t10\n106579\t3.124\t0.117\t28\n106757\t2.221\t0.408\t15\n106758\t2.401\t0.141\t81624\n106759\t2.351\t0.184\t21226\n106760\t2.431\t0.13\t2185\n106767\t2.782\t0.218\t230\n106768\t2.742\t0.183\t221\n107014\t2.077\t0.157\t13871\n107015\t2.286\t0.144\t1126\n107016\t2.261\t0.186\t6\n107023\t2.555\t-1.0\t1\n110619\t2.657\t0.367\t240\n110620\t2.816\t0.234\t12\n110621\t2.849\t0.093\t2\n110622\t2.914\t0.068\t12\n110623\t2.683\t0.337\t23\n110624\t2.349\t0.547\t34\n110625\t2.914\t0.287\t44\n110626\t2.37\t0.334\t254\n110627\t2.823\t0.245\t593\n110629\t3.216\t-1.0\t1\n110632\t3.168\t0.262\t18\n110633\t3.517\t-1.0\t1\n110634\t3.188\t-1.0\t1\n110636\t2.935\t0.025\t5\n110637\t2.659\t0.073\t4\n110638\t2.964\t0.14\t43\n110641\t2.808\t0.245\t6\n110642\t2.669\t0.36\t18\n110643\t2.899\t0.004\t2\n110644\t2.907\t0.266\t28\n110645\t3.111\t0.233\t239\n110654\t3.746\t0.042\t4\n110664\t3.213\t0.095\t2\n110665\t3.535\t-1.0\t1\n110666\t3.211\t-1.0\t1\n110669\t2.652\t-1.0\t1\n110670\t3.108\t0.335\t20\n110671\t3.078\t0.114\t48\n110672\t2.505\t0.007\t4\n110673\t2.66\t0.009\t3\n110674\t2.75\t0.014\t4\n110675\t2.821\t0.241\t50\n110682\t3.786\t-1.0\t1\n110684\t3.602\t0.211\t2\n110853\t2.51\t0.032\t24\n110854\t2.424\t0.18\t7855\n110855\t2.35\t0.165\t15280\n110856\t2.397\t0.151\t2600\n110863\t2.753\t0.315\t114\n110864\t2.718\t0.212\t256\n111110\t2.057\t0.162\t5916\n111111\t2.347\t0.183\t580\n111120\t3.119\t-1.0\t1\n114716\t2.861\t0.204\t423\n114717\t2.956\t0.144\t62\n114718\t3.07\t0.105\t55\n114719\t2.884\t0.235\t61\n114720\t2.67\t0.388\t26\n114721\t2.959\t0.219\t18\n114722\t2.832\t0.233\t173\n114723\t2.869\t0.229\t1269\n114727\t2.635\t0.109\t4\n114728\t2.753\t-1.0\t1\n114730\t2.796\t0.0\t2\n114733\t2.529\t0.017\t3\n114737\t2.923\t0.325\t25\n114738\t3.191\t0.145\t154\n114739\t3.085\t0.122\t9\n114740\t3.439\t0.421\t52\n114741\t3.061\t0.179\t190\n114743\t3.288\t-1.0\t1\n114745\t2.617\t0.062\t2\n114759\t3.289\t0.325\t3\n114760\t2.798\t-1.0\t1\n114762\t2.961\t-1.0\t1\n114765\t2.702\t-1.0\t1\n114766\t3.089\t0.135\t10\n114767\t3.047\t0.066\t62\n114768\t3.431\t0.011\t4\n114769\t3.198\t-1.0\t1\n114770\t3.331\t0.009\t16\n114771\t3.287\t0.091\t62\n114780\t3.048\t-1.0\t1\n114949\t2.438\t0.289\t13\n114950\t2.447\t0.207\t5143\n114951\t2.359\t0.153\t15318\n114952\t2.422\t0.153\t2635\n114959\t2.635\t0.231\t43\n114960\t2.669\t0.201\t795\n115206\t2.167\t0.159\t1651\n115207\t2.384\t0.147\t685\n115208\t2.377\t-1.0\t1\n118813\t2.913\t0.463\t3054\n118814\t2.839\t0.079\t11\n118815\t2.711\t0.001\t4\n118816\t2.916\t0.195\t36\n118817\t2.906\t0.257\t48\n118818\t3.003\t0.19\t1185\n118819\t2.89\t0.233\t2162\n118821\t4.015\t-1.0\t1\n118826\t2.96\t-1.0\t1\n118828\t2.952\t0.11\t39\n118829\t2.507\t0.024\t3\n118830\t2.938\t0.19\t22\n118831\t2.849\t0.2\t37\n118834\t2.765\t0.134\t305\n118835\t3.108\t0.155\t31\n118836\t3.39\t0.219\t189\n118837\t3.139\t0.235\t3644\n118839\t3.839\t-1.0\t1\n118858\t2.994\t-1.0\t1\n118861\t2.937\t0.024\t4\n118862\t2.749\t0.231\t11\n118863\t3.089\t0.14\t128\n118864\t2.73\t0.419\t10\n118867\t4.236\t-1.0\t1\n119046\t2.301\t0.205\t1784\n119047\t2.304\t0.132\t28601\n119048\t2.278\t0.16\t3943\n119055\t2.752\t0.18\t205\n119056\t2.764\t0.209\t1501\n119302\t2.425\t0.207\t1326\n119303\t2.302\t0.163\t1333\n119304\t2.514\t0.012\t2\n122910\t2.933\t0.511\t46\n122911\t2.702\t0.368\t7\n122912\t2.663\t0.513\t47\n122913\t2.561\t0.197\t22\n122914\t2.985\t0.238\t269\n122915\t2.799\t0.235\t1020\n122917\t3.448\t-1.0\t1\n122920\t3.428\t0.0\t2\n122922\t3.262\t0.063\t13\n122924\t3.141\t0.257\t36\n122925\t3.024\t0.038\t68\n122926\t3.08\t0.273\t30\n122929\t3.163\t0.018\t2\n122930\t2.751\t0.402\t11\n122932\t3.359\t0.441\t18\n122933\t3.021\t0.24\t382\n122935\t3.714\t-1.0\t1\n122955\t3.014\t0.026\t6\n122957\t3.238\t0.02\t4\n122958\t3.092\t0.105\t29\n122960\t3.074\t0.0\t2\n122961\t2.928\t0.007\t10\n122962\t3.518\t0.023\t8\n122963\t2.553\t0.0\t2\n123142\t2.737\t0.301\t850\n123143\t2.41\t0.137\t13630\n123144\t2.395\t0.157\t2260\n123151\t2.989\t0.176\t11\n123152\t2.86\t0.169\t504\n123398\t2.392\t0.233\t92\n123399\t2.348\t0.155\t241\n127007\t3.02\t0.246\t86\n127008\t2.974\t0.088\t8\n127009\t3.494\t0.451\t21\n127010\t2.829\t0.38\t37\n127011\t2.708\t0.245\t196\n127014\t3.469\t0.079\t7\n127016\t3.23\t0.0\t2\n127018\t3.049\t0.131\t23\n127020\t2.953\t0.101\t22\n127021\t3.009\t0.238\t45\n127022\t3.086\t0.158\t56\n127023\t3.058\t0.009\t4\n127025\t3.335\t0.196\t5\n127026\t3.283\t0.062\t7\n127027\t2.651\t0.769\t24\n127028\t3.434\t0.203\t18\n127029\t3.123\t0.373\t261\n127031\t3.789\t0.084\t6\n127032\t4.457\t-1.0\t1\n127033\t3.667\t-1.0\t1\n127036\t4.074\t0.0\t2\n127039\t4.048\t-1.0\t1\n127046\t4.093\t-1.0\t1\n127050\t2.953\t0.101\t7\n127052\t3.076\t0.218\t4\n127053\t3.176\t0.156\t3\n127054\t2.924\t0.124\t38\n127055\t2.909\t0.082\t10\n127059\t4.205\t0.525\t4\n127068\t3.948\t0.013\t2\n127237\t2.513\t0.281\t7\n127238\t2.422\t0.173\t417\n127239\t2.418\t0.176\t782\n127240\t2.39\t0.178\t153\n127247\t2.978\t0.075\t57\n127248\t2.775\t0.184\t61\n127494\t2.47\t0.44\t42\n127495\t2.406\t0.044\t2\n131109\t3.618\t0.424\t54\n131110\t3.321\t0.053\t36\n131111\t2.973\t0.025\t4\n131112\t3.771\t0.94\t5\n131113\t3.619\t0.341\t9\n131114\t3.143\t0.38\t30\n131116\t2.916\t0.159\t157\n131117\t2.917\t0.159\t121\n131118\t3.04\t0.268\t107\n131119\t2.922\t0.222\t15\n131120\t3.307\t0.038\t4\n131122\t3.411\t0.477\t35\n131123\t3.351\t-1.0\t1\n131127\t3.814\t0.114\t37\n131128\t3.49\t0.107\t29\n131130\t2.988\t0.0\t6\n131137\t2.864\t-1.0\t1\n131138\t3.615\t0.013\t2\n131144\t3.909\t0.169\t5\n131146\t3.079\t0.227\t59\n131147\t2.946\t0.309\t17\n131148\t2.938\t0.152\t48\n131149\t2.889\t0.075\t105\n131150\t2.932\t0.142\t86\n131151\t2.965\t0.315\t19\n131154\t4.158\t0.0\t3\n131155\t3.469\t0.0\t2\n135208\t3.392\t0.193\t9\n135209\t2.553\t0.506\t113\n135210\t2.846\t0.341\t42\n135212\t2.866\t0.212\t135\n135213\t2.927\t0.123\t16\n135214\t2.871\t0.163\t78\n135215\t2.95\t0.206\t41\n135216\t2.799\t0.488\t10\n135217\t2.858\t0.374\t47\n135218\t3.171\t0.414\t88\n135219\t3.525\t0.292\t6\n135226\t2.999\t0.0\t6\n135230\t3.926\t0.069\t11\n135234\t3.555\t0.069\t7\n135237\t4.014\t0.007\t2\n135240\t2.589\t0.032\t8\n135241\t2.464\t0.036\t10\n135242\t2.986\t0.141\t77\n135243\t2.924\t-1.0\t1\n135244\t2.773\t0.037\t5\n135245\t3.046\t0.0\t2\n135246\t2.825\t0.185\t175\n135247\t2.784\t0.162\t65\n135248\t3.475\t0.422\t13\n135249\t3.243\t0.492\t4\n135250\t3.627\t0.385\t15\n135251\t3.822\t0.36\t16\n135258\t3.001\t0.0\t2\n135260\t3.608\t0.228\t9\n135430\t2.312\t0.051\t4\n139303\t3.535\t0.292\t31\n139304\t3.38\t0.183\t24\n139305\t2.623\t0.529\t104\n139306\t3.083\t0.33\t321\n139308\t2.96\t0.162\t229\n139309\t2.923\t0.274\t63\n139310\t2.882\t0.149\t259\n139311\t3.27\t0.202\t438\n139312\t2.668\t0.417\t260\n139313\t3.241\t0.429\t63\n139314\t3.163\t0.399\t546\n139315\t3.191\t0.461\t290\n139321\t3.855\t0.226\t50\n139322\t3.709\t0.138\t100\n139323\t3.684\t0.123\t46\n139324\t3.633\t0.072\t70\n139326\t3.545\t0.123\t112\n139327\t3.991\t0.038\t4\n139328\t3.786\t0.526\t8\n139329\t3.979\t0.001\t4\n139330\t3.537\t0.014\t6\n139331\t3.355\t0.108\t12\n139332\t3.159\t0.173\t21\n139333\t3.624\t0.136\t27\n139334\t3.334\t0.167\t126\n139336\t3.239\t0.487\t10\n139337\t2.614\t0.35\t62\n139338\t3.123\t0.251\t218\n139339\t3.229\t0.309\t1334\n139340\t3.562\t0.717\t14\n139341\t2.945\t0.19\t49\n139342\t2.914\t0.165\t139\n139343\t2.866\t0.183\t165\n139344\t3.14\t0.274\t105\n139345\t3.078\t0.295\t50\n139346\t3.558\t0.371\t43\n139347\t3.512\t0.445\t86\n139354\t3.623\t0.348\t57\n139356\t3.581\t0.414\t207\n139357\t3.553\t0.26\t12\n139358\t3.738\t0.14\t26\n139526\t2.278\t0.056\t6\n143399\t2.881\t0.269\t29\n143400\t3.289\t0.207\t165\n143401\t2.903\t0.415\t136\n143402\t2.928\t0.263\t822\n143404\t2.981\t0.274\t225\n143405\t3.002\t0.373\t123\n143406\t2.929\t0.211\t1350\n143407\t3.15\t0.245\t392\n143408\t3.115\t0.214\t390\n143409\t2.892\t0.454\t277\n143410\t3.152\t0.327\t288\n143411\t3.118\t0.344\t421\n143417\t3.489\t0.306\t26\n143418\t3.66\t0.441\t102\n143419\t2.889\t0.02\t3\n143420\t3.311\t0.239\t14\n143422\t3.519\t0.117\t10\n143423\t3.405\t0.182\t14\n143424\t3.622\t0.201\t10\n143425\t2.902\t0.279\t14\n143426\t3.441\t0.397\t31\n143427\t2.869\t0.248\t16\n143428\t2.769\t0.111\t12\n143430\t3.342\t0.101\t8\n143433\t3.029\t0.413\t218\n143434\t2.63\t0.358\t237\n143435\t2.974\t0.223\t787\n143436\t2.871\t0.256\t91\n143437\t3.02\t0.255\t120\n143438\t2.97\t0.262\t730\n143439\t2.839\t0.219\t570\n143440\t2.939\t0.303\t600\n143441\t2.709\t0.226\t130\n143442\t3.393\t0.358\t470\n143443\t3.237\t0.326\t869\n143450\t3.569\t0.067\t21\n143452\t3.3\t0.463\t144\n143453\t2.771\t0.0\t6\n143454\t3.655\t0.021\t3\n143455\t2.882\t0.023\t3\n151589\t4.027\t0.433\t171\n151590\t3.818\t0.355\t2\n151594\t3.871\t0.0\t2\n151598\t3.586\t0.162\t20\n151599\t3.353\t0.049\t2\n151601\t3.937\t0.0\t2\n151602\t3.839\t0.296\t15\n151603\t3.859\t0.378\t36\n151607\t4.188\t0.029\t2\n151631\t3.626\t0.064\t26\n151633\t3.814\t0.025\t4\n151634\t3.849\t0.071\t10\n151635\t4.057\t0.0\t2\n151814\t3.815\t0.247\t64\n152069\t3.392\t0.0\t2\n152070\t3.728\t0.185\t7\n155686\t3.715\t0.263\t197\n155692\t3.291\t0.0\t2\n155693\t3.275\t0.0\t2\n155695\t3.371\t-1.0\t1\n155696\t3.544\t0.083\t4\n155697\t3.415\t0.077\t36\n155698\t3.446\t0.074\t26\n155699\t3.346\t0.137\t70\n155703\t4.039\t0.114\t2\n155704\t3.785\t-1.0\t1\n155725\t3.3\t0.0\t4\n155726\t3.174\t0.064\t8\n155727\t3.236\t0.051\t4\n155728\t3.411\t0.02\t2\n155729\t3.492\t0.006\t3\n155730\t3.53\t0.066\t10\n155731\t3.424\t0.132\t88\n155740\t3.534\t-1.0\t1\n155910\t3.584\t0.272\t112\n156166\t2.793\t0.019\t4\n159783\t4.713\t0.009\t2\n159790\t3.627\t0.388\t4\n159795\t3.832\t0.039\t12\n159797\t3.719\t0.347\t56\n159799\t4.168\t0.0\t2\n159822\t3.558\t0.003\t2\n160005\t3.476\t0.074\t35\n160006\t3.258\t0.191\t4054\n160007\t2.913\t0.142\t1412\n160008\t2.796\t0.249\t708\n160015\t3.636\t0.026\t3\n160016\t3.367\t0.408\t27\n160262\t2.99\t0.127\t72\n160263\t3.031\t0.264\t24\n163884\t3.712\t0.084\t3\n163885\t3.713\t0.26\t5\n163889\t3.399\t0.0\t2\n163890\t3.989\t0.377\t5\n163892\t3.476\t0.0\t2\n163893\t3.302\t0.424\t87\n163917\t3.364\t0.045\t5\n163918\t3.314\t0.355\t6\n163922\t4.034\t-1.0\t1\n164101\t3.255\t0.125\t9\n164102\t3.029\t0.219\t13290\n164103\t2.812\t0.186\t1007\n164104\t2.599\t0.231\t718\n164111\t3.355\t0.275\t19\n164112\t3.184\t0.119\t22\n164358\t2.805\t0.151\t103\n164359\t2.642\t0.21\t22\n164360\t2.844\t0.216\t9\n167977\t2.746\t0.433\t12\n167986\t3.166\t-1.0\t1\n167988\t3.668\t0.819\t15\n167989\t2.936\t0.216\t20\n168198\t2.975\t0.237\t953\n168199\t2.749\t0.24\t450\n168200\t2.532\t0.296\t44\n168207\t3.165\t0.13\t49\n168208\t3.318\t0.08\t14\n168454\t2.601\t0.169\t111\n168455\t2.727\t0.161\t25\n172074\t2.912\t0.373\t1298\n172076\t3.157\t0.34\t9\n172078\t3.301\t0.025\t5\n172079\t3.222\t0.067\t8\n172082\t3.28\t0.259\t30\n172083\t3.177\t0.165\t15\n172084\t3.327\t0.193\t23\n172085\t3.272\t0.292\t557\n172087\t3.799\t-1.0\t1\n172088\t3.528\t-1.0\t1\n172106\t2.727\t0.462\t6\n172107\t3.735\t-1.0\t1\n172109\t3.252\t0.082\t43\n172110\t3.239\t0.183\t9\n172111\t3.197\t0.132\t22\n172112\t3.584\t0.076\t4\n172114\t3.693\t0.232\t12\n172115\t3.359\t0.28\t40\n172124\t3.744\t0.013\t2\n172293\t3.03\t0.256\t14\n172294\t2.789\t0.167\t9278\n172295\t2.577\t0.18\t3098\n172296\t2.467\t0.259\t1296\n172303\t2.908\t0.239\t150\n172304\t2.957\t0.217\t165\n172550\t2.341\t0.159\t4663\n172551\t2.511\t0.149\t218\n172559\t2.202\t0.279\t10\n180268\t3.063\t0.299\t1102\n180269\t2.945\t0.515\t10\n180270\t3.082\t0.36\t14\n180271\t3.086\t-1.0\t1\n180272\t3.242\t0.131\t2\n180273\t3.439\t0.268\t6\n180274\t3.072\t0.196\t129\n180275\t3.213\t0.211\t24\n180276\t3.091\t0.153\t98\n180277\t3.22\t0.208\t173\n180295\t3.709\t0.109\t4\n180296\t3.674\t0.024\t2\n180298\t3.338\t0.368\t8\n180299\t3.08\t0.02\t2\n180300\t3.051\t0.136\t6\n180301\t3.2\t0.237\t31\n180302\t3.182\t0.186\t59\n180303\t2.975\t0.164\t24\n180304\t3.255\t-1.0\t1\n180306\t2.931\t0.041\t12\n180307\t2.734\t0.077\t20\n180485\t2.755\t0.204\t14\n180486\t2.611\t0.146\t28221\n180487\t2.363\t0.139\t11820\n180488\t2.408\t0.153\t1326\n180495\t2.75\t0.202\t77\n180496\t2.828\t0.175\t621\n180742\t2.163\t0.16\t10524\n180743\t2.394\t0.13\t880\n180744\t2.447\t0.224\t6\n180751\t2.688\t0.012\t5\n180752\t2.464\t0.284\t5\n184365\t2.871\t0.285\t392\n184366\t3.302\t0.52\t4\n184367\t2.634\t0.029\t2\n184368\t2.701\t-1.0\t1\n184369\t3.216\t0.427\t13\n184370\t3.333\t0.264\t124\n184371\t3.063\t0.086\t29\n184372\t3.343\t0.188\t5\n184373\t3.193\t0.194\t327\n184396\t2.794\t0.148\t26\n184397\t2.962\t0.816\t2\n184398\t2.985\t0.39\t19\n184399\t3.255\t0.176\t61\n184400\t3.215\t0.059\t6\n184402\t3.402\t0.003\t2\n184403\t3.348\t0.247\t21\n184412\t3.283\t0.005\t3\n184581\t2.634\t0.295\t6\n184582\t2.568\t0.171\t12855\n184583\t2.441\t0.153\t3081\n184584\t2.416\t0.166\t1225\n184591\t2.739\t0.094\t61\n184592\t2.805\t0.202\t148\n184837\t2.886\t-1.0\t1\n184838\t2.196\t0.199\t2670\n184839\t2.45\t0.148\t279\n184848\t2.287\t0.009\t6\n188462\t3.197\t0.284\t549\n188463\t3.567\t0.174\t71\n188465\t3.129\t0.275\t2\n188466\t3.378\t0.343\t81\n188467\t3.278\t0.49\t122\n188468\t3.121\t0.318\t140\n188469\t3.118\t0.179\t936\n188472\t3.155\t0.189\t11\n188486\t2.788\t-1.0\t1\n188487\t3.697\t0.043\t2\n188490\t3.361\t-1.0\t1\n188491\t3.319\t0.01\t2\n188492\t3.071\t0.101\t16\n188494\t3.253\t0.286\t17\n188495\t3.308\t0.347\t126\n188496\t3.082\t0.313\t5\n188497\t3.342\t0.379\t39\n188498\t3.685\t0.035\t11\n188499\t2.981\t0.028\t91\n188508\t3.265\t0.257\t3\n188677\t2.545\t0.218\t11\n188678\t2.381\t0.169\t6266\n188679\t2.365\t0.135\t7580\n188680\t2.446\t0.147\t1073\n188687\t2.778\t0.159\t82\n188688\t2.732\t0.177\t615\n188934\t2.405\t0.21\t1341\n188935\t2.38\t0.131\t281\n188936\t2.152\t0.004\t2\n188944\t2.657\t0.082\t9\n192559\t3.554\t0.226\t4083\n192561\t2.716\t-1.0\t1\n192562\t3.443\t0.292\t14\n192563\t3.163\t0.241\t12\n192564\t3.698\t0.229\t62\n192565\t3.522\t0.275\t796\n192572\t3.827\t0.068\t3\n192587\t3.3\t0.096\t6\n192588\t3.119\t0.06\t30\n192589\t3.417\t0.237\t27\n192590\t3.436\t0.273\t279\n192591\t3.326\t0.24\t399\n192592\t2.823\t0.436\t7\n192774\t2.472\t0.2\t1611\n192775\t2.535\t0.173\t5301\n192776\t2.731\t0.17\t305\n192783\t2.898\t0.163\t18\n192784\t3.194\t0.23\t847\n193030\t2.719\t0.257\t1011\n193031\t2.571\t0.187\t351\n196656\t2.962\t0.143\t4\n196659\t2.984\t0.064\t32\n196660\t3.488\t0.2\t53\n196661\t3.212\t0.24\t422\n196664\t3.568\t0.009\t4\n196686\t3.302\t0.12\t162\n196687\t3.375\t0.136\t15\n196690\t3.639\t0.028\t8\n196691\t3.016\t0.052\t32\n196870\t2.546\t0.218\t32\n196871\t2.669\t0.125\t3379\n196872\t2.711\t0.152\t719\n196880\t3.123\t0.225\t349\n197126\t2.828\t0.381\t77\n197127\t2.606\t0.119\t56\n197128\t2.751\t-1.0\t1\n200753\t2.968\t0.291\t109\n200754\t3.781\t0.18\t17\n200755\t2.926\t0.006\t4\n200756\t3.55\t0.394\t50\n200757\t3.215\t0.314\t179\n200759\t3.813\t0.152\t8\n200760\t3.68\t0.079\t15\n200778\t3.2\t0.021\t2\n200779\t2.798\t0.024\t24\n200781\t2.816\t0.38\t2\n200782\t3.146\t0.138\t51\n200783\t3.783\t-1.0\t1\n200784\t3.608\t0.06\t2\n200787\t3.701\t0.063\t13\n200966\t2.737\t0.248\t164\n200967\t2.638\t0.193\t666\n200968\t2.735\t0.196\t128\n200975\t3.61\t0.145\t5\n200976\t2.787\t0.336\t60\n201222\t2.754\t0.18\t12\n201223\t2.897\t0.149\t12\n204850\t3.629\t0.476\t976\n204851\t2.793\t0.054\t34\n204852\t3.367\t0.645\t98\n204853\t3.325\t0.463\t310\n204855\t3.996\t0.344\t33\n204856\t3.682\t0.08\t11\n204857\t3.947\t0.023\t6\n204858\t3.186\t0.0\t6\n204863\t3.44\t0.0\t11\n204866\t3.929\t-1.0\t1\n204870\t3.525\t0.118\t8\n204872\t4.135\t0.14\t3\n204874\t3.301\t0.205\t57\n204875\t3.121\t0.234\t55\n204876\t3.203\t0.168\t70\n204877\t3.061\t0.08\t42\n204878\t3.284\t0.173\t281\n204879\t4.309\t0.589\t23\n204881\t3.669\t0.346\t5\n204882\t3.46\t0.055\t10\n204883\t3.636\t0.704\t18\n204892\t4.537\t-1.0\t1\n205061\t2.753\t0.308\t17\n205062\t2.528\t0.15\t3869\n205063\t2.708\t0.199\t1070\n205064\t2.716\t0.2\t545\n205071\t3.421\t0.246\t38\n205072\t3.123\t0.212\t212\n205318\t2.574\t0.174\t88\n205319\t2.626\t0.158\t25\n208947\t2.969\t0.506\t259\n208948\t3.77\t0.671\t12\n208949\t3.392\t0.45\t229\n208951\t3.952\t0.118\t44\n208952\t3.545\t0.115\t138\n208953\t3.197\t0.0\t6\n208954\t3.176\t0.0\t6\n208962\t3.825\t0.039\t12\n208968\t3.44\t-1.0\t1\n208970\t3.273\t0.166\t30\n208971\t3.245\t0.214\t83\n208972\t2.968\t0.115\t113\n208973\t3.43\t0.067\t4\n208974\t3.1\t0.205\t80\n208975\t3.122\t0.204\t60\n208976\t3.551\t0.081\t6\n208977\t4.668\t0.032\t6\n208978\t4.088\t0.033\t12\n208979\t2.917\t0.271\t11\n209158\t2.495\t0.15\t1844\n209159\t2.721\t0.28\t225\n209160\t2.668\t0.436\t78\n209167\t3.017\t0.046\t5\n209168\t3.149\t0.165\t38\n209414\t2.509\t0.24\t10\n209415\t2.427\t0.146\t6\n213050\t4.433\t0.045\t6\n213054\t4.024\t0.099\t10\n213065\t5.027\t-1.0\t1\n213066\t2.704\t0.455\t23\n213067\t3.276\t0.286\t165\n213068\t3.025\t0.034\t20\n213070\t3.155\t0.284\t48\n213071\t3.03\t0.209\t38\n213072\t3.343\t0.249\t92\n213073\t4.446\t0.01\t2\n213074\t4.01\t0.314\t16\n213075\t3.489\t0.653\t32\n213084\t3.85\t0.333\t22\n213086\t4.355\t0.043\t6\n217145\t3.893\t0.312\t115\n217146\t4.057\t0.272\t72\n217147\t3.309\t0.409\t38\n217148\t3.875\t0.23\t104\n217150\t3.913\t0.338\t122\n217151\t4.078\t0.166\t14\n217152\t3.772\t0.324\t18\n217153\t3.606\t0.456\t25\n217154\t3.192\t0.524\t27\n217156\t3.103\t0.413\t22\n217157\t3.863\t0.489\t46\n217158\t3.761\t0.157\t82\n217159\t3.66\t0.413\t6\n217160\t3.35\t0.322\t22\n217161\t2.816\t0.4\t52\n217162\t2.801\t0.247\t341\n217163\t2.814\t0.353\t94\n217164\t2.999\t0.191\t26\n217165\t3.222\t0.232\t233\n217166\t3.234\t0.277\t811\n217167\t3.066\t0.296\t281\n217168\t3.131\t0.252\t665\n217169\t2.89\t0.413\t19\n217170\t3.801\t0.427\t565\n217171\t3.582\t0.409\t827\n217178\t3.927\t0.242\t20\n217180\t3.819\t0.264\t406\n217182\t3.899\t0.189\t7\n217183\t3.278\t-1.0\t1\n225335\t4.276\t0.49\t265\n225336\t4.479\t0.154\t3\n225338\t4.3\t0.0\t2\n225345\t4.243\t-1.0\t1\n225346\t4.182\t-1.0\t1\n225354\t3.789\t-1.0\t1\n225359\t3.687\t0.153\t5\n225360\t4.965\t0.0\t3\n225361\t4.086\t0.077\t5\n225362\t3.938\t0.124\t17\n225363\t4.209\t0.153\t5\n225542\t4.026\t0.331\t148\n225797\t3.377\t0.162\t3\n225798\t3.864\t0.248\t33\n229432\t4.077\t0.334\t194\n229450\t3.552\t0.0\t2\n229455\t3.61\t0.0\t2\n229458\t3.779\t0.076\t5\n229459\t3.62\t0.105\t15\n229638\t3.726\t0.142\t169\n229893\t2.88\t0.148\t17\n233547\t3.663\t0.041\t4\n233733\t3.661\t0.127\t9\n233734\t3.511\t0.169\t1320\n233735\t3.103\t0.143\t699\n233736\t2.952\t0.191\t544\n233743\t4.137\t0.779\t6\n233744\t3.541\t0.191\t21\n233990\t3.356\t0.17\t18\n233991\t3.128\t0.157\t55\n237830\t3.517\t0.262\t866\n237831\t3.053\t0.238\t780\n237832\t2.942\t0.272\t364\n237839\t3.058\t0.078\t3\n237840\t3.557\t0.208\t14\n238086\t3.309\t0.197\t15\n238087\t3.084\t0.184\t40\n241926\t3.477\t0.124\t197\n241927\t3.016\t0.163\t300\n241928\t2.871\t0.151\t320\n241936\t3.545\t0.074\t6\n242182\t3.213\t0.142\t3\n242183\t3.034\t0.049\t17\n246021\t3.749\t-1.0\t1\n246022\t3.442\t0.199\t803\n246023\t3.027\t0.153\t733\n246024\t2.83\t0.16\t737\n246031\t3.715\t0.509\t10\n246032\t3.489\t0.117\t10\n246278\t3.07\t0.175\t7\n246279\t3.018\t0.113\t65\n254014\t3.621\t0.145\t11\n254027\t3.568\t0.017\t3\n254214\t3.39\t0.158\t2671\n254215\t2.996\t0.161\t998\n254216\t2.805\t0.192\t556\n254223\t3.737\t0.252\t40\n254224\t3.439\t0.148\t13\n254470\t3.227\t0.142\t6\n254471\t3.139\t0.173\t24\n254472\t2.911\t0.206\t20\n258111\t2.215\t0.23\t2\n258310\t3.466\t0.262\t271\n258311\t2.927\t0.187\t1239\n258312\t2.76\t0.166\t1083\n258320\t3.383\t0.05\t12\n258566\t3.457\t0.042\t4\n258567\t2.819\t0.112\t11\n262406\t3.329\t0.213\t453\n262407\t2.926\t0.184\t889\n262408\t2.796\t0.186\t1231\n262416\t3.355\t0.381\t10\n262662\t2.919\t0.044\t2\n262663\t2.999\t0.226\t11\n266502\t3.401\t0.179\t388\n266503\t2.89\t0.17\t992\n266504\t2.734\t0.193\t1159\n266511\t3.732\t-1.0\t1\n266512\t3.445\t0.0\t2\n266758\t2.926\t-1.0\t1\n266759\t2.857\t0.231\t31\n270597\t3.404\t0.076\t3\n270598\t3.222\t0.253\t1595\n270599\t2.866\t0.193\t2042\n270600\t2.707\t0.189\t2073\n270607\t3.718\t-1.0\t1\n270608\t3.41\t0.38\t13\n270854\t2.9\t-1.0\t1\n270855\t2.794\t0.192\t30\n274510\t4.001\t0.0\t2\n274694\t3.388\t0.171\t354\n274695\t2.87\t0.172\t416\n274696\t2.724\t0.185\t439\n274950\t2.925\t0.039\t8\n274951\t2.479\t0.253\t12\n278789\t3.409\t0.069\t2\n278790\t3.158\t0.169\t1145\n278791\t2.849\t0.175\t801\n278792\t2.672\t0.179\t577\n278799\t3.625\t-1.0\t1\n278800\t3.474\t0.092\t7\n279046\t2.934\t0.097\t12\n279047\t2.89\t0.09\t12\n282693\t3.553\t0.0\t4\n282886\t3.443\t0.178\t536\n282887\t2.879\t0.209\t168\n282888\t2.725\t0.147\t129\n282895\t3.631\t0.142\t21\n282896\t3.222\t0.01\t8\n283143\t2.527\t0.136\t9\n286981\t3.507\t0.084\t5\n286982\t3.184\t0.155\t3390\n286983\t2.859\t0.153\t1245\n286984\t2.682\t0.159\t499\n286991\t3.54\t0.155\t13\n286992\t3.365\t0.159\t9\n287238\t3.019\t0.138\t24\n287239\t2.855\t0.076\t16\n287240\t2.979\t0.21\t26\n290891\t3.455\t0.011\t2\n290894\t3.514\t-1.0\t1\n291077\t3.476\t0.16\t11\n291078\t3.284\t0.204\t878\n291079\t2.84\t0.187\t460\n291080\t2.635\t0.193\t132\n291088\t3.528\t0.062\t2\n291334\t2.883\t0.06\t12\n291335\t2.948\t0.137\t14\n294994\t3.999\t-1.0\t1\n295173\t3.165\t0.193\t2\n295174\t3.107\t0.177\t2432\n295175\t2.774\t0.182\t341\n295176\t2.652\t0.204\t104\n295184\t3.109\t0.166\t9\n295430\t2.767\t0.112\t12\n295431\t2.657\t0.278\t12\n299081\t2.935\t0.369\t17\n299085\t3.119\t0.214\t10\n299270\t2.918\t0.218\t1400\n299271\t2.737\t0.199\t305\n299272\t2.492\t0.248\t40\n299279\t2.559\t0.037\t4\n299526\t2.488\t0.241\t28\n299527\t2.804\t0.155\t6\n303178\t2.675\t0.417\t434\n303181\t3.222\t0.078\t41\n303182\t3.654\t-1.0\t1\n303183\t3.21\t0.023\t4\n303186\t3.733\t0.044\t8\n303187\t3.128\t0.192\t8\n303365\t2.968\t0.028\t2\n303366\t2.8\t0.213\t3774\n303367\t2.584\t0.227\t2258\n303368\t2.49\t0.297\t312\n303375\t2.904\t0.202\t124\n303376\t3.053\t0.272\t32\n303622\t2.342\t0.159\t6180\n303623\t2.471\t0.154\t65\n307275\t3.127\t0.383\t1161\n307276\t3.076\t0.401\t28\n307277\t3.191\t0.02\t2\n307278\t3.567\t0.117\t38\n307279\t3.269\t0.094\t25\n307280\t3.228\t0.038\t20\n307281\t3.587\t0.03\t2\n307283\t3.205\t0.081\t30\n307292\t3.713\t0.164\t4\n307462\t2.629\t0.197\t1542\n307463\t2.457\t0.127\t3999\n307464\t2.435\t0.206\t207\n307471\t2.732\t0.251\t11\n307472\t2.825\t0.122\t121\n307718\t2.178\t0.135\t8471\n307719\t2.383\t0.156\t157\n307720\t2.299\t0.121\t3\n307728\t2.409\t0.014\t6\n311372\t3.106\t0.207\t804\n311373\t3.181\t-1.0\t1\n311374\t3.548\t0.146\t32\n311375\t3.12\t0.036\t62\n311379\t2.887\t0.06\t22\n311558\t2.597\t0.187\t2089\n311559\t2.357\t0.157\t1187\n311560\t2.486\t0.163\t95\n311567\t3.048\t0.26\t4\n311568\t3.082\t0.291\t44\n311814\t2.108\t0.152\t4572\n311815\t2.428\t0.139\t86\n311824\t2.543\t0.001\t4\n315469\t3.151\t0.278\t365\n315470\t3.549\t0.122\t63\n315471\t3.157\t0.118\t31\n315475\t3.22\t0.061\t39\n315653\t2.65\t0.215\t20\n315654\t2.552\t0.195\t16080\n315655\t2.382\t0.126\t6084\n315656\t2.483\t0.127\t418\n315663\t2.762\t0.14\t37\n315664\t2.816\t0.196\t162\n315910\t2.215\t0.168\t2203\n315911\t2.436\t0.105\t204\n315920\t2.977\t-1.0\t1\n319566\t3.225\t0.248\t552\n319567\t3.367\t0.293\t115\n319568\t3.169\t0.205\t20\n319569\t3.36\t0.238\t50\n319570\t3.392\t0.286\t42\n319571\t2.929\t0.286\t8\n319580\t2.758\t-1.0\t1\n319749\t2.528\t0.434\t19\n319750\t2.374\t0.187\t4743\n319751\t2.364\t0.145\t6282\n319752\t2.404\t0.169\t399\n319759\t2.743\t0.15\t63\n319760\t2.674\t0.189\t638\n320005\t2.585\t0.095\t3\n320006\t2.331\t0.173\t2612\n320007\t2.357\t0.121\t135\n320015\t2.781\t0.006\t2\n320016\t2.898\t0.124\t6\n323663\t3.245\t0.336\t4562\n323664\t3.526\t0.142\t2\n323665\t3.286\t0.102\t22\n323666\t3.306\t0.022\t2\n323667\t2.881\t0.196\t25\n323846\t2.35\t0.15\t3014\n323847\t2.354\t0.137\t1158\n323848\t2.403\t0.253\t6\n323855\t2.769\t0.169\t45\n323856\t2.739\t0.213\t222\n324102\t2.337\t0.19\t1691\n324103\t2.388\t0.156\t45\n327760\t2.694\t0.474\t53\n327941\t2.577\t-1.0\t1\n327942\t2.266\t0.136\t922\n327943\t2.741\t0.157\t953\n327944\t2.741\t0.235\t37\n327951\t2.904\t0.093\t8\n327952\t2.866\t0.242\t158\n328198\t2.38\t0.168\t94\n328199\t2.875\t0.15\t3\n331857\t3.111\t0.21\t60\n332038\t2.542\t0.227\t19\n332039\t2.984\t0.13\t175\n332040\t2.942\t0.295\t20\n332048\t3.399\t0.21\t18\n332294\t2.174\t0.0\t4\n335954\t3.231\t0.429\t436\n336134\t2.776\t0.248\t252\n336135\t2.833\t0.135\t693\n336136\t2.76\t0.196\t207\n336143\t3.678\t0.123\t15\n336144\t3.263\t0.218\t66\n336390\t2.874\t0.122\t4\n336391\t2.699\t0.147\t7\n340051\t3.126\t0.27\t404\n340229\t2.797\t-1.0\t1\n340230\t2.623\t0.24\t807\n340231\t2.807\t0.169\t491\n340232\t2.771\t0.212\t269\n340239\t3.206\t0.012\t2\n340240\t3.325\t0.293\t98\n340486\t2.701\t0.167\t16\n340487\t3.129\t0.34\t2\n368902\t3.528\t0.229\t2516\n368903\t3.077\t0.237\t337\n368904\t2.966\t0.304\t84\n368911\t3.616\t0.121\t7\n368912\t3.535\t0.376\t64\n369158\t3.14\t0.113\t14\n369159\t3.146\t0.323\t8\n369160\t3.179\t0.006\t2\n376924\t3.747\t0.0\t2\n377094\t3.44\t0.227\t3394\n377095\t2.982\t0.201\t1971\n377096\t2.826\t0.242\t770\n377103\t2.998\t0.426\t10\n377104\t3.462\t0.179\t110\n377350\t3.258\t0.302\t74\n377351\t3.02\t0.219\t96\n377352\t3.011\t0.211\t9\n381190\t3.595\t0.186\t49\n381191\t3.016\t0.171\t33\n381192\t3.071\t0.23\t47\n381200\t3.429\t0.053\t8\n385286\t3.676\t0.046\t15\n385287\t3.005\t0.218\t31\n385288\t3.065\t0.263\t47\n385296\t3.84\t0.251\t6\n389383\t3.107\t0.032\t5\n389384\t2.858\t0.234\t18\n389392\t3.517\t0.038\t3\n393479\t3.128\t0.008\t2\n393488\t3.419\t0.064\t3\n397575\t3.05\t0.029\t3\n397576\t2.942\t0.008\t3\n401671\t3.038\t0.025\t3\n401672\t2.931\t0.016\t3\n1073414\t1.594\t0.077\t2000853\n1073415\t1.527\t0.071\t91806\n1073423\t2.001\t0.161\t74\n1073424\t1.981\t0.067\t42\n1073679\t2.05\t0.093\t4\n1073680\t1.992\t0.039\t7\n1077511\t1.504\t0.087\t791\n1077519\t1.839\t0.106\t1862\n1077520\t1.811\t0.097\t38\n1077776\t1.753\t0.11\t23\n1110287\t2.325\t0.221\t8\n16781317\t1.299\t0.138\t2655\n16781318\t1.157\t0.073\t2154155\n16781319\t1.027\t0.087\t120477\n16781320\t1.0\t0.102\t99234\n16781321\t1.229\t0.768\t39\n16781326\t1.698\t0.206\t492\n16781327\t1.491\t0.16\t461\n16781328\t1.414\t0.148\t260\n16781329\t1.46\t0.267\t16\n16781344\t1.768\t0.207\t170\n16781345\t1.64\t0.233\t13\n16781346\t1.184\t0.24\t11\n16781347\t1.193\t0.14\t10\n16781365\t1.612\t0.001\t2\n16781573\t1.266\t-1.0\t1\n16781574\t1.083\t0.054\t1399983\n16781575\t1.026\t0.08\t10086\n16781576\t1.035\t0.083\t62\n16781583\t1.555\t0.169\t170\n16781830\t1.082\t0.064\t1503\n16781831\t1.012\t0.075\t9\n16797701\t2.055\t0.175\t200\n16797702\t1.917\t0.136\t1968\n16797703\t1.74\t0.145\t4307\n16797704\t1.627\t0.111\t7838\n16797705\t1.579\t0.095\t5410\n16797710\t2.643\t0.184\t32\n16797711\t2.367\t0.191\t736\n16797712\t2.279\t0.266\t207\n16797713\t2.22\t0.188\t513\n16797728\t2.564\t0.128\t21\n16797729\t2.481\t0.101\t5\n16797730\t2.577\t0.148\t48\n16797731\t2.401\t0.231\t244\n16797748\t2.725\t0.14\t4\n16797749\t2.87\t0.374\t77\n16797958\t1.838\t0.106\t11969\n16797959\t1.825\t0.108\t1915\n16797967\t2.268\t0.255\t20\n16798214\t1.868\t0.127\t268\n16798215\t1.772\t0.141\t42\n16798224\t2.259\t-1.0\t1\n16801798\t1.819\t0.111\t650683\n16801799\t1.721\t0.104\t153277\n16801800\t1.674\t0.089\t194202\n16801801\t1.483\t0.083\t37441\n16801806\t2.363\t0.237\t31159\n16801807\t2.243\t0.189\t5173\n16801808\t2.128\t0.132\t11654\n16801809\t2.024\t0.124\t15529\n16801824\t2.527\t0.248\t999\n16801825\t2.422\t0.325\t206\n16801826\t2.378\t0.18\t872\n16801827\t2.279\t0.155\t2704\n16801844\t2.666\t0.308\t172\n16801845\t2.522\t0.166\t717\n16802054\t1.762\t0.092\t352183\n16802055\t1.72\t0.097\t14388\n16802056\t1.688\t0.108\t6\n16802063\t2.207\t0.172\t3307\n16802064\t2.105\t0.131\t3350\n16802310\t1.696\t0.091\t7665\n16802311\t1.656\t0.128\t75\n16802320\t2.082\t0.116\t4919\n16805895\t1.623\t0.108\t3208\n16805896\t1.666\t0.126\t2100\n16805897\t1.415\t0.162\t17\n16805902\t2.205\t0.191\t1967\n16805903\t2.079\t0.152\t1682\n16805904\t1.93\t0.103\t249\n16805905\t1.958\t0.111\t24\n16805920\t2.362\t0.195\t1315\n16805921\t2.241\t0.173\t128\n16805922\t2.3\t0.193\t96\n16805923\t2.162\t0.118\t32\n16805940\t2.674\t0.201\t118\n16805941\t2.473\t0.194\t38\n16806150\t1.59\t0.082\t164495\n16806151\t1.574\t0.081\t7627\n16806159\t1.986\t0.139\t3197\n16806160\t2.009\t0.09\t401\n16806406\t1.512\t0.069\t153\n16806407\t1.394\t0.086\t533\n16806416\t1.9\t0.093\t9234\n16809992\t1.741\t0.264\t647\n16809998\t1.995\t0.155\t7813\n16809999\t1.925\t0.144\t1208\n16810000\t1.916\t0.201\t51\n16810001\t1.673\t0.087\t998\n16810016\t2.152\t0.242\t1021\n16810017\t1.796\t0.244\t670\n16810018\t2.006\t0.2\t174\n16810019\t1.965\t0.381\t4\n16810036\t2.404\t0.302\t460\n16810037\t2.386\t0.22\t205\n16810246\t1.562\t0.08\t163577\n16810247\t1.393\t0.102\t21110\n16810255\t1.861\t0.129\t9068\n16810256\t1.926\t0.104\t123\n16810502\t1.408\t0.07\t41\n16810503\t1.354\t0.073\t7\n16810512\t1.734\t0.114\t5958\n16814089\t1.446\t0.064\t5\n16814094\t1.979\t0.162\t679\n16814095\t1.82\t0.095\t9307\n16814096\t1.773\t0.108\t625\n16814097\t1.615\t0.213\t20\n16814112\t2.054\t0.303\t209\n16814113\t1.845\t0.169\t415\n16814114\t2.218\t0.193\t16\n16814115\t1.836\t0.098\t23\n16814132\t1.837\t0.254\t287\n16814133\t2.14\t0.294\t84\n16814342\t1.478\t0.072\t44091\n16814343\t1.246\t0.169\t3\n16814351\t1.618\t0.194\t150\n16814352\t1.613\t0.103\t16\n16814608\t1.556\t0.127\t44\n16834574\t3.378\t0.364\t2682\n16834575\t2.882\t0.272\t162\n16834576\t2.626\t0.23\t157\n16834577\t2.549\t0.274\t1011\n16834592\t3.473\t0.286\t507\n16834593\t3.314\t0.371\t24\n16834594\t2.897\t0.327\t42\n16834595\t2.87\t0.389\t169\n16834612\t3.665\t0.536\t15\n16834613\t3.09\t0.417\t78\n16834822\t2.235\t0.149\t6897\n16834823\t2.299\t0.166\t545\n16835078\t2.237\t0.123\t1405\n16835079\t2.102\t0.162\t46\n16838671\t2.751\t0.246\t664\n16838672\t2.368\t0.224\t165\n16838673\t2.447\t0.27\t425\n16838688\t3.18\t0.313\t89\n16838689\t2.773\t0.119\t26\n16838690\t2.582\t0.333\t127\n16838691\t2.563\t0.288\t58\n16838708\t3.027\t0.178\t12\n16838709\t2.915\t0.394\t101\n16838918\t2.115\t0.115\t8657\n16838919\t1.855\t0.183\t439\n16838927\t2.715\t0.169\t135\n16838928\t2.658\t0.069\t6\n16839174\t1.936\t0.185\t23\n16839175\t2.101\t0.064\t2\n16839184\t2.948\t-1.0\t1\n16842768\t2.281\t0.201\t1234\n16842769\t2.015\t0.03\t13\n16842784\t2.754\t0.331\t616\n16842785\t2.241\t0.25\t917\n16842786\t2.475\t0.266\t49\n16842787\t2.694\t0.214\t14\n16842804\t3.261\t0.399\t44\n16842805\t3.241\t0.251\t46\n16843014\t2.01\t0.115\t20813\n16843015\t1.834\t0.133\t156\n16843023\t2.464\t0.209\t339\n16843024\t2.494\t0.161\t19\n16843270\t1.935\t0.13\t225\n16843280\t2.489\t0.19\t50\n16846865\t1.992\t0.399\t44\n16846880\t2.745\t0.286\t511\n16846881\t2.728\t0.235\t235\n16846882\t2.384\t0.337\t109\n16846900\t3.03\t0.369\t277\n16846901\t2.906\t0.468\t87\n16847110\t1.969\t0.095\t20992\n16847111\t1.77\t0.177\t16\n16847119\t2.289\t0.187\t1133\n16847120\t2.181\t0.113\t8\n16847366\t1.923\t0.203\t4\n16847376\t2.231\t0.165\t28\n16908320\t3.119\t0.561\t1100\n16908321\t2.481\t0.4\t70\n16908322\t2.624\t0.585\t344\n16908323\t2.911\t0.375\t127\n16908340\t3.181\t0.424\t124\n16908341\t3.271\t0.469\t73\n16908550\t2.342\t0.169\t2233\n16908551\t2.432\t0.175\t414\n16908552\t2.284\t0.062\t14\n16908559\t3.148\t0.384\t31\n16908806\t2.273\t0.193\t233\n16912417\t2.568\t0.286\t226\n16912418\t2.384\t0.277\t52\n16912419\t2.383\t0.526\t37\n16912436\t2.868\t0.102\t3\n16912437\t3.175\t0.376\t43\n16912646\t2.247\t0.155\t563\n16912647\t2.196\t0.137\t13\n16912655\t2.8\t0.063\t13\n16912902\t1.902\t0.429\t4\n16912903\t2.164\t0.088\t7\n16916514\t2.705\t0.288\t257\n16916515\t2.826\t0.329\t129\n16916532\t3.054\t0.385\t17\n16916533\t3.596\t0.24\t25\n16916742\t2.215\t0.127\t1635\n16916743\t1.989\t0.141\t55\n16916751\t2.686\t0.173\t226\n16916752\t2.64\t-1.0\t1\n16916998\t2.197\t0.154\t196\n16920611\t3.015\t0.264\t187\n16920628\t3.279\t0.255\t239\n16920629\t3.195\t0.403\t63\n16920838\t2.164\t0.108\t13670\n16920839\t2.524\t0.134\t43\n16920847\t2.176\t0.207\t50\n16920848\t2.785\t0.214\t9\n16921094\t2.117\t0.097\t16\n16990260\t3.228\t0.382\t40\n16990261\t3.606\t0.35\t107\n16990470\t2.49\t0.154\t812\n16990471\t2.273\t0.267\t50\n16990472\t3.042\t-1.0\t1\n16990479\t3.31\t0.124\t16\n16990726\t2.535\t0.253\t17\n16994357\t3.54\t0.331\t863\n16994566\t2.373\t0.134\t5123\n16994567\t2.597\t0.154\t114\n16994575\t3.258\t0.143\t18\n16994822\t2.308\t0.108\t265\n16994823\t2.683\t0.0\t2\n17846534\t1.807\t0.004\t6\n17850630\t1.686\t0.082\t194786\n17850631\t1.634\t0.082\t26774\n17850632\t1.542\t0.034\t5\n17850639\t2.101\t0.105\t7379\n17850640\t2.077\t0.073\t1123\n17850886\t1.624\t0.087\t18128\n17850887\t1.587\t0.111\t90\n17850896\t2.041\t0.093\t13784\n17854727\t1.605\t0.077\t739\n17854735\t1.988\t0.193\t481\n17854736\t2.01\t0.157\t103\n17854982\t1.518\t0.05\t118\n17854983\t1.299\t0.035\t2\n17854991\t2.079\t0.0\t2\n17854992\t1.872\t0.081\t564\n17858824\t1.212\t0.0\t2\n17887503\t2.816\t0.232\t70\n17887504\t2.775\t-1.0\t1\n17887750\t2.038\t0.159\t42\n17887760\t2.72\t0.033\t2\n17891600\t2.75\t0.187\t12\n17891856\t2.984\t-1.0\t1\n18899462\t1.586\t0.08\t708\n18899472\t2.099\t0.117\t10\n18940432\t2.57\t0.156\t5\n33611790\t2.862\t0.219\t107\n33611809\t3.023\t-1.0\t1\n33611810\t1.697\t0.952\t3\n33611828\t3.382\t-1.0\t1\n33612038\t2.267\t0.06\t19\n33612039\t2.076\t0.084\t9\n33612040\t2.213\t0.116\t7\n33612047\t3.299\t0.356\t32\n33612048\t2.829\t-1.0\t1\n33612294\t2.498\t0.086\t4\n33624117\t2.68\t0.0\t2\n33624326\t2.051\t0.166\t7\n33624328\t1.644\t0.085\t2970\n33685536\t3.587\t0.192\t22\n33685537\t3.362\t0.618\t7\n33685539\t2.768\t-1.0\t1\n33685766\t2.418\t0.096\t23\n33685767\t2.3\t-1.0\t1\n33685768\t1.911\t0.307\t75\n33685775\t3.061\t0.334\t74\n33685776\t3.159\t0.258\t11\n33686022\t2.244\t-1.0\t1\n33689633\t2.268\t0.368\t3\n33689634\t3.2\t0.0\t2\n33689653\t3.142\t0.113\t4\n33689862\t1.874\t0.13\t10\n33689863\t1.999\t-1.0\t1\n33689864\t2.138\t0.163\t58\n33689871\t2.766\t0.099\t11\n33689872\t2.702\t0.904\t6\n33693731\t3.211\t0.049\t4\n33693748\t3.96\t0.381\t8\n33693749\t3.32\t0.198\t7\n33693958\t2.081\t0.047\t6\n33693959\t2.112\t0.21\t9\n33693960\t1.88\t0.205\t162\n33693967\t2.503\t0.176\t332\n33697844\t3.872\t0.0\t2\n33698055\t1.967\t-1.0\t1\n33698056\t1.612\t0.028\t8\n33767476\t2.657\t-1.0\t1\n33767477\t3.446\t-1.0\t1\n33767686\t2.131\t0.005\t3\n33767687\t2.1\t-1.0\t1\n33767688\t2.267\t0.518\t6\n33767695\t2.857\t0.194\t7\n33767696\t3.719\t0.957\t3\n33771573\t3.614\t0.457\t10\n33771783\t2.249\t0.088\t5\n33771784\t2.127\t0.16\t106\n33771791\t3.098\t-1.0\t1\n33771792\t3.166\t0.428\t3\n34623750\t1.78\t0.012\t7\n34627846\t1.55\t0.083\t65623\n34627847\t1.486\t0.077\t27424\n34627848\t1.404\t0.071\t156637\n34627855\t2.044\t0.135\t373\n34627856\t1.945\t0.103\t4751\n34628102\t1.526\t0.109\t716\n34628112\t1.965\t0.141\t8\n34631943\t1.436\t0.08\t1641\n34631944\t1.371\t0.063\t17326\n34631951\t1.879\t0.175\t1347\n34631952\t1.901\t0.158\t89\n34632198\t1.396\t0.123\t200\n34632199\t1.374\t0.136\t116\n34632207\t2.095\t0.0\t2\n34632208\t1.812\t0.114\t109\n34636040\t1.131\t0.253\t79\n34636047\t1.751\t0.123\t5003\n34636048\t1.76\t0.092\t2467\n34636294\t1.228\t0.157\t96\n34636295\t1.111\t0.035\t20\n34636304\t1.661\t0.085\t34493\n34664719\t2.605\t0.159\t86\n34664720\t2.299\t0.162\t912\n34664966\t1.951\t0.174\t35\n34664967\t1.804\t0.217\t28\n34664975\t2.749\t0.0\t2\n34664976\t2.399\t-1.0\t1\n34668816\t2.417\t0.111\t4\n34669062\t1.893\t0.17\t143\n34669071\t2.291\t0.138\t2\n35676678\t1.475\t0.093\t37\n52453894\t1.376\t0.081\t8518\n52453895\t1.293\t0.068\t14577\n52453896\t1.593\t0.165\t45\n52453903\t1.768\t0.204\t5\n52457991\t1.263\t0.085\t581\n52458000\t1.392\t0.156\t3\n83914759\t1.547\t0.085\t5\n83915013\t1.739\t0.204\t7\n83915014\t1.572\t0.079\t50584\n83915015\t1.539\t0.074\t8699\n83915023\t1.977\t0.137\t53\n83919110\t1.558\t0.068\t8984\n83919111\t1.575\t0.101\t961\n83919119\t2.014\t0.019\t9\n83951650\t2.389\t0.04\t4\n83951878\t1.973\t0.109\t22593\n83951879\t1.799\t0.11\t991\n83951887\t2.464\t-1.0\t1\n83951888\t2.672\t0.158\t11\n84025378\t2.575\t0.005\t2\n84025606\t2.151\t0.135\t549\n84025607\t2.077\t0.132\t184\n84959494\t1.626\t0.085\t32317\n84959495\t1.575\t0.081\t14689\n84959503\t2.111\t0.074\t20\n84959504\t2.015\t0.127\t36\n84963591\t1.557\t0.073\t2345\n84963599\t1.935\t0.256\t2\n84963600\t2.2\t0.296\t11\n100802822\t2.071\t0.051\t5\n100802823\t1.97\t0.021\t4\n101732615\t1.731\t0.197\t7\n101736710\t1.567\t0.082\t49304\n101736711\t1.502\t0.079\t23379\n101736719\t2.028\t0.119\t39\n101736720\t1.978\t0.107\t31\n101740807\t1.481\t0.072\t2974\n101740815\t1.989\t0.139\t38\n101740816\t1.737\t0.078\t11\n101773584\t2.915\t0.094\t4',$Yb),h);d=b[0];c=UXb.mGb(d,D_b,fZb);_Xb.Bv=Rjb(TXb.klb,xZb,6,c,15,1);_Xb.Cv=Rjb(TXb.jlb,r_b,6,c,15,1);_Xb.Dv=Rjb(TXb.jlb,r_b,6,c,15,1);_Xb.Av=Rjb(TXb.klb,xZb,6,c,15,1);for(e=0;e<c;e++){g=b[e+1];f=UXb.NHb(g,'\t');if(f.length==4){try{_Xb.Bv[e]=UXb.mGb(f[0],D_b,fZb);_Xb.Cv[e]=zGb(f[1]);_Xb.Dv[e]=zGb(f[2]);_Xb.Av[e]=UXb.mGb(f[3],D_b,fZb);}catch(a){a=Fwb(a);if(Ykb(a,52)){break;}else throw Gwb(a);}}}_Xb.Fv=true;}};_Xb.Pv=function Pv(a){var b,c,d,e;_Xb.Fv||_Xb.Ov();e=w$b;d=WZb;for(c=0;c<12;c++){b=e>=_Xb.Bv.length||a<_Xb.Bv[e]?-1:a==_Xb.Bv[e]?0:1;if(b==0)return e;e=b<0?e-d:e+d;d=d/2|0;}return -1;};wxb(524,1,{},_Xb.Iv);_Xb.Fv=false;TXb.kmb=UFb(524);_Xb.Qv=function Qv(a,b){a.q=_Xb.Nw(new _Xb.Qw(a.o,b),a);};_Xb.Rv=function Rv(a,b){var c,d,e,f,g,h,i,j,k;c=_Xb.Xv(a,b[0]);d=_Xb.Xv(a,b[1]);e=_Xb.Xv(a,b[2]);f=_Xb.Xv(a,b[3]);i=new ZXb.Sh(d.a-c.a,d.b-c.b,d.c-c.c);j=new ZXb.Sh(e.a-d.a,e.b-d.b,e.c-d.c);k=new ZXb.Sh(f.a-e.a,f.b-e.b,f.c-e.c);g=new ZXb.Sh(i.b*j.c-i.c*j.b,-(i.a*j.c-i.c*j.a),i.a*j.b-i.b*j.a);h=new ZXb.Sh(j.b*k.c-j.c*k.b,-(j.a*k.c-j.c*k.a),j.a*k.b-j.b*k.a);return -$wnd.Math.atan2($wnd.Math.sqrt(j.a*j.a+j.b*j.b+j.c*j.c)*(i.a*h.a+i.b*h.b+i.c*h.c),g.a*h.a+g.b*h.b+g.c*h.c);};_Xb.Sv=function Sv(a,b){_Xb.Vv(a,b);return _Xb.Bw(a.q,b.q);};_Xb.Tv=function Tv(a,b){var c;for(c=0;c<b.q;c++)ZXb.Nh(a.k[c],b.J[c]);};_Xb.Uv=function Uv(a,b){var c;for(c=0;c<b.k.length;c++)ZXb.Nh(a.k[c],b.k[c]);b.j==null?a.j=null:a.j=$Xb.xOb(b.j,b.j.length);};_Xb.Vv=function Vv(a,b){var c;if(!a.q||!b.q){c=new _Xb.Pw(a.o);!a.q&&(a.q=_Xb.Nw(c,a));!b.q&&(b.q=_Xb.Nw(c,b));}};_Xb.Wv=function Wv(a,b){return a.j==null?-1:a.j[b];};_Xb.Xv=function Xv(a,b){return a.k[b];};_Xb.Yv=function Yv(a){return a.p==null?a.o.P:a.p;};_Xb.Zv=function Zv(a,b){return a.k[b].a;};_Xb.$v=function $v(a,b){return a.k[b].b;};_Xb._v=function _v(a,b){return a.k[b].c;};_Xb.aw=function aw(a,b,c){if(a.j==null){a.j=Rjb(TXb.Awb,L$b,6,a.o.r,15,1);$Xb.COb(a.j);}while(c<0)c=c+360<<16>>16;while(c>=360)c=c-360<<16>>16;a.j[b]=c;};_Xb.bw=function bw(a,b,c){ZXb.Nh(a.k[b],c);};_Xb.cw=function cw(a,b,c){a.k[b]=c;};_Xb.dw=function dw(a,b){a.p=b;};_Xb.ew=function ew(a,b,c){a.k[b].a=c;};_Xb.fw=function fw(a,b,c){a.k[b].b=c;};_Xb.gw=function gw(a,b,c){a.k[b].c=c;};_Xb.hw=function hw(a,b){var c;!b&&(b=ZXb.ru(a.o));for(c=0;c<b.q;c++)ZXb.Nh(b.J[c],a.k[c]);a.p!=null&&ZXb.Nm(b,a.p);return b;};_Xb.iw=function iw(a){var b;this.o=a;this.k=Rjb(TXb.Dlb,i_b,32,a.q,0,1);for(b=0;b<a.q;b++)this.k[b]=new ZXb.Th(a.J[b]);this.n=NaN;};_Xb.jw=function jw(a){_Xb.kw.call(this,a,a.o);};_Xb.kw=function kw(a,b){var c;this.o=b;this.k=Rjb(TXb.Dlb,i_b,32,a.k.length,0,1);for(c=0;c<this.k.length;c++)this.k[c]=new ZXb.Th(a.k[c]);a.j!=null&&(this.j=$Xb.xOb(a.j,a.j.length));this.p=a.p==null||UXb.BHb(a.p)?a.p:UXb.zHb(a.p,lZb);this.n=NaN;};wxb(79,1,{79:1,18:1},_Xb.jw);_.Eb=function lw(a){return _Xb.Sv(this,a);};_.n=0;TXb.lmb=UFb(79);_Xb.nw=function nw(a,b){var c,d,e,f,g;if(b==null)return null;g=$Xb.kNb(a.c,b);if(g)return g;d=XXb.KTb('<').length;if(UXb.CHb(XXb.KTb(b).substr(XXb.KTb(b).length-d,d),'<')||(e=XXb.KTb('-').length,UXb.CHb(XXb.KTb(b).substr(XXb.KTb(b).length-e,e),'-'))){g=$Xb.kNb(a.c,(f=XXb.KTb('<').length,UXb.CHb(XXb.KTb(b).substr(XXb.KTb(b).length-f,f),'<')?UXb.QHb(b,0,XXb.KTb(b).length-1)+'>':(c=XXb.KTb('-').length,UXb.CHb(XXb.KTb(b).substr(XXb.KTb(b).length-c,c),'-')?UXb.QHb(b,0,XXb.KTb(b).length-1)+'+':b)));if(g){g=new _Xb.ix(g);$Xb.fRb(a.c,b,g);return g;}}return null;};_Xb.ow=function ow(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C;a.b|=b;A=(m=UXb.NHb('daD@h@\\H\\D\\L\\B\\Djfdrjj`Cj`XZV^[lgl|WjBp^C~RQdp\ndaDD`HP@cIICISKUT@]LCbURss\\bCPVCp_rPmV@\ndaDH@@RfzaJjjbHGWPhxdtl|yXEGDfgf}HDoTE`|G|dC]`<\ndaDH@@RfzaJjjbHGWPhxdtl|yqGDf}HDoTE`|G|dC]`<\ndaDH@@RfzaJjjbHGWPhxdtl|yqGDf}HDoTE`|G|dC]`>\ndaT@`@\\DjfjZn[jjjkJcKhGP`phxdtl|wY@xD`uyo]{|lKUfp\ndax@@DiU[zh@zHfegfzLG``\ndax@@DiYn`@@wHmumm}l=\ndax@@DiYn`@@wHmumm}t=\ndax@@DiYn`@@wHmumn}t=\ndax@@DiYn`@@wHmuum}t\ndax@@DiYn`@@wHmuun}t=\ndax@@DiYn`@@wHnuun}t=\ndax@@DiYn`h@zsEgfyEnmlG``=\ndax@@DiYnf@@zaJyEnnmom`=\ndax@@DiYnf@@zaJyEvnmom`=\ndax@@DiYnf@@zqDffyEv`mom`=\ndax@@DiYnf@@zqDffyEv`mon`\ndax@@DiYnf@@zqDff~TEm}l=\ndax@@DiYnf@@zqDff~Uyn}t=\ndax@@DiYnf@@zqDfjyEv`mom`=\ndax@@DiYnf@@zqDfj~TEm}l=\ndax@@Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@@Djfjjh@zDFEGDfeggI@phdwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggM@phdtwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggN@pdwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggN@plwY@xD`tE`}x\ndax@@Djfjjh@zDFEGDjegj{HG@dF`lG``\ndax@@DjfjjjHP]BCBcbSRssd`XRV[l`\\BPZBp^|>\ndax@@DjfjjjHP]BCBcbSRsug@XR[l`\\BPZBp^B<\ndax@@DjfjjjHP]BCBcbSRsug@XR[l`\\BPZBp^B>\ndax@D@bH\\DbL\\B\\JbFbN\\Dfnjjh@zRGGNHxlwPo]x\ndax@H@\\H\\D\\J\\Djfjjh@zXFGDegf{I{@dFoLG``\ndax@H@\\H\\D\\J\\Djfjjh@zXFGDeggN@pdwYOXD`uy`|D\ndax@H@\\H\\D\\L\\Djfjjh@zXFDfegf{I{ODF`lG``\ndax@H@\\H\\J\\F\\Djfjjh@zXFEGDgj{HG@dFoM{``\ndax@H@\\J\\F\\N\\Djfjjh@zhFEGDf{HG@dFoM{o@\ndax@H@\\J\\F\\N\\Djfjjh@zhFEGDf}HG@dFoMx\ndax@H@dDdJdFdDfnjjh@zJGDgfzDGo@\ndax@H@dDdJdFdDfnjjh@zJGDgfzE{o@\ndax@H@dDdJdFdDfnjjh@zJGDggNHxlwP`|D\ndax@H@dDdJdFdDfnjjh@zJGDggNHxlwPo]x\ndax@H@dDdJdFdDfnjjh@zJGDkfzDGo@\ndax@H@dDdJdFdDfnjjh@zJGDkgNHxlwP`}x\ndax@H@dDdJdFdDfnjjh@zJGDkjzDG``\ndax@H@dDdLdJdLbdLeUT@]EBRss]F}w`\ndax@H@dDdLdJdLbdLeUUAPNbaIZyncA{p<\ndax@H@dDdLdJdLbdLeUUAPNbaIZyncA{p>\ndax@P@BFBDiuZ{h@zHEEgfzHG``\ndax@P@QFQDiuZ{h@zHEEgfzHG``\ndax@P@\\H\\Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@P@\\H\\Djfjjh@zDFEGDjegj{HG@dF`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf{Q{@dF`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf{Q{OEz`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf}YxoTE`|D\ndax@P@\\H\\Djnjjj@P]\\BcbSRss]h}`R}PVCpP<\ndax@P@\\H\\Djnjjj@P]\\BcbSRss]h}`R}PVCpP>\ndax@P@\\H\\Djnjjj@P]\\BcbSRss^lBWjBp^B<\ndax@P@\\H\\Djnjjj@P]\\BcbSRss^lBWjBp^B>\ndax@Q@|Bh@dnRjZjj`Ck`XT\\ZV^[t`\\CPVCpP\ndax@R@BH|HeIijjj@NnaQqIiYyoV^KuAXOA@\ndax@R@QH|HeIijjj@NnaQqIiYyoV^KuAXOA@\ndax@R@\\H\\HyJkjjj@NnAQqIiYyoV^KuAXOA@\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEgf{I{OEzoLG``\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEggI@phdwYOYxoUy`|D\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEggN@pdwYOYxoUy`|D\ndax@X@kDdLdJkFdNdLbdLeUT@]IBR\ndax@`@BDf]j^@@zbJyAoMmom`=\ndax@`@BDf]j^@@zbJyAoNmom`=\ndax@`@BDf]j^@@zbJyAoNmwn`=\ndax@`@\\Df]j^@@zRGFyA{Nmom`=\ndax@`@\\Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEGDfegf{HG@ez`lG``\ndax@`@\\Djfjjh@zDFEGDjegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEGHjegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEKHjegf{HG@dF`lG``\ndax@`@\\LddUUUr@]LBcbRss\\dC`RCwP\ndax@`@dDffjjjHP]]BcbSRssgHTR[u`RCPVCpP<\ndax@b@|@eJijjj@NaAaQqIiYynrApI^hKAxH\ndax@b@|@eJijjj@NaAaQqIiYynrAsq^hKAxH\ndax@b@|@eJijjj`DGP`phyDtl|wY@xDoTE`|D<\ndax@b@|@eJijjj`DGP`phyDtl|wY@xDoTE`|D>\ndax@h@BDdLdJdFdLbdLeUT@]YBSs]@}w`\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf{I{OEz`lG``\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf{I{OEz`lG`\x7FddEB\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf}I{OTE`|D\ndax@h@\\H\\D\\L\\J\\Djfjjh@zhFDegf{I{ODFoLG``\ndax@h@\\H\\D\\L\\J\\Djfjjh@zhFDeggI@phdwYOYx`uy`|D\ndax@h@\\H\\D\\L\\J\\Djfjjj@P]TCBRssg@XR[lgl|PZ|p^B<\ndax@h@\\H\\D\\L\\J\\Djfjjj@P]TCBRssg@XR[lgl|PZ|p^B>\ndax@h@dDdLdJdFdLbdLeUT@]YBSs^NB\ndax@h@dDdLdJdFdLbdLeUT@]YBSs^N|\ndax@h@dDdLdJdFdLbdLeUT@]YBSu^NB\ndax@h@kDdLdJdFdLbdLeUT@]YBSs^N|\ndax@p@\\H\\D\\Djfjjh@zxFGDfegf{I{@dF`lG``\ndax@p@\\H\\D\\Djfjjh@zxFGDfegj{I{@dF`lG``\ndax@p@\\J\\F\\Djfjjh@zXFEGDgf{HG@dFoM{``\ndax@p@\\J\\F\\Djfjjh@zXFEGDgj{HG@dFoM{``\ndax@p@\\J\\F\\DjfjjjHP]LCBcbSs^dC`RCWnB<\ndax@p@\\J\\F\\DjfjjjHP]LCBcbSs^dC`RCWnB>\ndax@p@dDdLdLbdLeUT@]UBSRss_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSRss_JBp^|\ndax@p@dDdLdLbdLeUT@]UBSRsu_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSRuu_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSTus_JBp^|\ndax@p@|D\\L\\DffjjjHP]MBbSRss^l|PZBp^B<\ndax@p@|D\\L\\DffjjjHP]MBbSRss^l|PZBp^B>\ndaxB@@RfRZzjjdaX`zJGDggN@hdwP`|D<\ndaxB@@RfRZzjjdaX`zJGDggN@hdwP`|D>\ndaxBRHSFCpkpslddlcUT`HdGV@d|wRo\\D>\ndaxB`HSJCprRRrMUPAtPIKOMtXOA@\ndaxD@@QIkjjj@NfaqIiYysbNIMrHMAXOA@\ndaxD@@QIkjjjbDGSPxdtl|yHEGDfyDF`lG``<\ndaxD@@QImYk`@Nhanc[{X=\ndaxD@@iIijjj@NfaQqIYynVAHKAxH\ndaxD@@iIijjj@NfaQqIYysTJNMKMrpIAXOA@\ndaxD@@iIijjjRDbCihT\\RV^\\yBcS\\lBPVCpP\ndaxD@@iIijjjRDdCihT\\RV^\\yBbs\\lBPVCw`>\ndaxD@@iIijjjRDdCihT\\RV^\\yBcS\\lBPVCpP<\ndaxD@@yIUVnz@NdaY@\ndaxDHHP@biAiCiCIICHmU@GV@xdw```\ndaxDPHP@b`cIICHmU@GU@xeL|wH`uy`|D\ndaxD`HP@cIICHmU@GS@xdtl|wH`tE`|D\ndaxD`HP@cIICHmU@GS@xeTl|wH`tE`|D\ndaxD`HPGCIICIUU@GS@xdtl|wHoTE`|D\ndaxDpJXIAICICHiCIUU@GVPd|wc``\ndaxDpJXIAICICHiCIUU@GVPd|wco@\ndaxH@@RYvjxHaAtdNM|pK[{X+\ndaxH@@RZZjj`CkhT\\RZV^[u`RCPVCpP\ndaxH@@RZZjj`CkhT\\RZV^\\lCBcbSS^lBPZBp^B\ndaxH@@RZZjj`CkhT\\RZV^\\uBcbSS^lBPZBp^B\ndaxH@@RZZjj`CkhT\\RZV^lmBcbSRs^lBPZBp^B\ndaxH@@RZZjjhQAutJNIMKONZaQqIYoVAHMAXO^@<\ndaxH@@RZZjjhaAutJNIMKONVAaQqIioVAKuAXOA@<\ndaxH@@RZZjjhaAutJNIMKONZAaQIioVAHMAXOA@<\ndaxH@@RZZjjhaAutJNIMKONZaQqIioVAKuAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aQIoVAHMAXOA@<\ndaxH@@RZZjjhaAutJNIMKON\\aQIoVAHMAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aQYoVAHMAXO^@>\ndaxH@@RZZjjhaAutJNIMKON\\aqIoVAKuAXOA@<\ndaxH@@RZZjjhaAutJNIMKON\\aqIoVAKuAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aqYoVAKuAXO^@<\ndaxHHBApapQpqpRjZjj`Cj`XZV^[tgl}PVCpP\ndaxHPJBPRPRZzjjhrAuTNIKWM|KsA{p<\ndaxHPJBPRPRZzjjhrAuTNIKWM|KsA{p>\ndaxH`HApRjzjj`Ck`T\\RZV^[u`RCPVCpP\ndaxH`HApRjzjj`Ck`T\\RZV^[ugb}PVCpP\ndaxH`HApRjzjj`Ck`T\\bjV^[u`RCPVCpP\ndaxH`HApRjzjjhAAupJNIMKOMzpI^hKAxH<\ndaxH`HApRjzjjhAAupJNIMKOMzpI^hKAxH>\ndaxH`JBHRZZjjhaAttJNIKONRaQiYnVAHKAxH>\ndaxHpJBHRHrHrJPrUUPAtTIKOMtXOA@\ndaxHpJBPRPrPrJPrUUPAtTIKOMtXOA@\ndaxHpJBPRPrPrJPrUUPAtTIKOMt[w^@\ndaxHpJBPRPrPrJPrUUTE@zJDegfzLGo@<\ndaxHpJBPRPrPrJPrUUTE@zJDegfzLGo@>\ndaxHpJBPRPrPrJPrUUTE@zJDegjzLG``<\ndaxHpJBPRPrPrJPrUUTE@zJDegjzLG``>\ndaxHpJBPRPrPrJPrUUTE@zJDekfzLGo@<\ndaxHpJBPRPrPrJPrUUTE@zJDekfzLGo@>\ndaxL@@RdfnjjjHP]UCbRsse`T\\RZV[xPVCpP<\ndaxLHHS@BJdFdNdLddlbuT@]HBR\ndaxLJHS@BJdFdNdL{IIKHmU@GR@d`\ndaxL`HS@\\LddleUT@]TBSRss_JBp^B\ndaxLhJ[`\\H\\D\\L\\B\\Djfjjh@zPFF~I{OEx\nday@@@QIkjjj@NfaqIiYysPLJIMMrHMAXOA@\ndayDaLJD@HrR{IICHmU@GU@xtl|wr`lG``\ndaz@@@RYvHx@C\\`wfvwvp=\ndaz@@@RYvHx@C\\`wfvwwP\ndaz@@@RYvHx@C\\`wgVwvp=\ndaz@@@RYvix@CjHkdF|zv~v=\ndaz@@@RYvix@CjHkdG\\zv~v=\ndaz@B@BTf]bN@@wHMymm}t\ndaz@HBApapQpqpRjZjj`Cj`XZV^[tgl}PVCpP\ndaz@bHCpBTjnjjh@zxEGDfegf}YxoTE`|D\ndaz@pJBPRPrPrJPrUUPAtTIKOMtXOA@\ndaz@pJBPRPrPrJPrUUTE@zJDegjzLG``>\ndazDHLa@BJdFdNdLddlbuT@]HBR\ndazDJLa@BJdFdNdL{IIKHmU@GR@d`\ndazD`La@BLddlbuT@]TBSRss_JBp^B\ndazH`D`OCIICHuUPBCi`\\RZV^[dWjBp^B<\ndazH`D`OCIICHuUPBCi`\\RZV^[dWjBp^B>\ndazHpFhIAICICHiCIUUPRCkHR^[qpP<\ndazHpFhIAICICHiCIUUPRCkHR^[qpP>\ndazLQFaLCpkpsfgIIKHuUHBIAu`IOMtkwA@<\ndazLQFaLCpkpsfgIIKHuUHBIAu`IOMtkwA@>\ndctD@@gHiDTeIU]uPAttNIHjnmrpIATNa@\ndctD@@gHiDTeIU]uPAttNQPjvurpIATNa@\nded@@DiUfoh@@Mr[_[G\\{@=\nded@@DiUfoh@@Mr[_]G\\}@\nded@P@\\F\\LddUTeUuPAtHJNIKOHlmvPNAHOADLa@\ndedD@@{HiDUIU]T@]MCdTrMM\\lBPQCHP\ndiD@@DiYkhJ`ChlV^Q[tVzvp^BHP=\ndiD@@DiYkhJ`ChlV^Q[tVzzp^BHP\ndiD@@DiYkhJ`ChlV^aktVzvp^BHP=\ndiD@@DiYkhJ`ChlVnaktVzvp^BHP=\ndiD@@DiYkhJ`ChlVnaktVzzp^BHP\ndiD@H@\\H\\D\\L\\LddjTjn@@z`F}QyOY{nct=\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGmcl=\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGmct\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGnct=\ndiD@`@\\LddUTjnX@zhEGDej}HG@dGnct\ndiD@`@\\LddUTjnX@zxEGDegdV}HG@dGnbD\ndiD@`@\\LddUTjnX@zxEGDegdZ}HG@dGnbD\ndiDH@@rJQERjx@CkH\\R[e`RCvqv=\ndiDH@@rJQERjx@CkH\\R[e`RCvqz\ndiDH@@rJQERjx@CkH\\bke`RCvqv=\ndiDH@@rJQERjx@CkH\\bke`RCvqz\ndiDH@@rJQERjxHaAudNIMrpI^{X{@+\ndiDH@@rJQERjxHaAudNIMrpI^{X{@-\ndiDH@@rJQERjxHaAudNIMrpI^{X}@<\ndiDH@@rJQERjy`Cih\\RV^Q[y`RBO`\ndiDH@@rJQERjy`Cih\\bf^Q[e`RCwQB\ndiF@@@rJQERjx@CkH\\R[e`RCvqv=\ndiF@`NAprRQURjx@Ch`T\\R[t`\\BP^vNp\ndiF@a@b`BX{HiDUJk`@NlarJnVAHO[Gh\ndiFH@NCHiDUJk`@NlaqInVAHO[GX\ngC`@Die@zHXir\ngC`@Die@zHXis]Knz\ngC`@Die@zHXis^Kh\ngC`@Die@zHXisgAbd\ngC`@Die@zHXisgAbfzW]t\ngC`@Die@zHXisgAbf|WP\ngC`@Dij@zHXis]HNB\ngC`@Dij@zHXis]HN|\ngC`@Dij@zHXis]Kv|\ngC`@Dij@zHXisgAbfzP\\D\ngC`@Dij@zHXisgAbfzP]x\ngC`@Dij@zHXisgAbfzWmx\ngC`@Dij@zHXiu]HNB\ngC`@Dij@zHXiugAbfzP\\D\ngC`@Dij@zHXjs]HN|\ngC`@Dij@zHXjsgAbfzP]x\ngC`@Dij@zHXju]HNB\ngC`@Dij@zHXjugAbfzP\\D\ngC`@DkZ@zHXis]SnB\ngC`@DkZ@zHXis]Sn|\ngC`@DkZ@zHXis^XH\ngC`@DkZ@zHXis^[p\ngC`@DkZ@zHXisgAbfzg\\D\ngC`@DkZ@zHXisgAbfzg]x\ngC`@DkZ@zHXisgAbf|pP\ngC`@DkZ@zHXisgAbf|w`\ngC`@DkZ@zHXiu]SnB\ngC`@DkZ@zHXiu^XH\ngC`@DkZ@zHXiugAbfzg\\D\ngC`@DkZ@zHXiugAbf|pP\ngC`B@DPHPQ`aJZ`NdFH\ngC`B@DPHPQ`aJZ`NdFN\\FJP\ngC`B@DPHWaoAJZ`NdFMto[p\ngC`D@DPHRfhChabgMt`xH\ngC`D@DPHRfhChabgN\\FJ[iApP\ngC`D@DPHRfhChabgN\\FJ[i^w`\ngC`D@DPHRfhChabkUt`xH\ngC`D@DPHRnhCkASf|pP\ngC`D@DPHRnhCkASj|pP\ngC`D@DXHRVhCiQR\ngC`D@DXHRVhCiQSgAbd\ngC`D@DXHRfhCkAbf|PP\ngC`D@DXHRfhCkAbgNCEMx``\ngC`D@DXHRfhCkAbj|PP\ngC`D@DYpRVhCiQS]Cv|\ngC`D@VPlRfhChabkUt`xH\ngC`D@VYpRfhCkAbfzP]x\ngC`D@bQDRfhChabgMt`xH\ngC`D@bQDRfhChabkUt`xH\ngC`D@bSpRnhCkASfzglD\ngC`D@xYpRVhCiQS]Cv|\ngC`D@xYpRVhCiQSgAbfzGmx\ngC`DABPHRVhCkQSj|pP\ngC`DADZHRVhCiQR\ngC`DAb[DRVhCiQR\ngC`DAx[pRVhCiQR\ngC`DAx[pRVhCiQS]Cv|\ngC`Dax[pDzTej@zTTwP}o@\ngC`H@DIKRAuhir\ngC`H@DIKTAuhis]CvB\ngC`H@DIKTAuhis^XH\ngC`H@DIKTAuhis^[p\ngC`H@DIKTAuhisgAbfzGlD\ngC`H@DIKTAuhisgAbf|pP\ngC`H@DIKTAuhisgAbf|w`\ngC`H@DIKTAuhiu]CvB\ngC`H@DIKTAuhiu^XH\ngC`H@DISRAtPqSfzP]t\ngC`H@DISRAtPqSf|PP\ngC`H@DISRAtPqSgNCEMt`{h\ngC`H@DISRAtPqSgNCEMx``\ngC`H@DISRAtPqUfzP]t\ngC`H@DISRAtPqUgNCEMt`{h\ngC`H@DISTAtPqSfzP\\D\ngC`H@DISTAtPqSfzP]x\ngC`H@DISTAtPqSfzWlD\ngC`H@DISTAtPqSgNCEMt`xH\ngC`H@DISTAtPqSgNCEMt`{p\ngC`H@DISTAtPqSgNCEMtoXH\ngC`H@DISTAtPqSjzP\\D\ngC`H@DISTAtPqSjzWlD\ngC`H@DISTAtPqSkNCEMt`xH\ngC`H@DISTAtPqUfzP\\D\ngC`H@DISTAtPqUfzP]x\ngC`H@DISTAtPqUgNCEMt`xH\ngC`H@DISTAtPqUjzP\\D\ngC`H@VIKTAuhis]CvB\ngC`H@bIKTAuhis^XH\ngC`H@bISRAtPqSf|PP\ngC`H@bISTAtPqSfzP\\D\ngC`H@bISTAtPqSgNCEMt`xH\ngC`H@bISTAtPqSjzP\\D\ngC`H@bISTAtPqUfzP\\D\ngC`H@bISTAtPqUjzP\\D\ngC`H@xIKRAuhis^Cp\ngC`H@xIKTAuhis]CvB\ngC`H@xIKTAuhis]Cv|\ngC`H@xIKTAuhis^XH\ngC`H@xIKTAuhisgAbfzGlD\ngC`H@xIKTAuhiu]CvB\ngC`HADIKTAuhis^XH\ngC`HAVIKTAuhis^XH\ngC`HAbIKTAuhis^XH\ngC`HAxIKTAuhis]CvB\ngC`HAxIKTAuhis^XH\ngC`HAxIKTAuhisgAbfzGlD\ngC`HAxIKTAuhiu]CvB\ngC`HMPISTAu`qS]HN|\ngC`HMPISTAu`qS^HH\ngC`IAVBTii@zHXjs]HNz\ngC`IAxBTej@ztTyna{A@\ngC`IAxBTej@ztTys`qS]CvB\ngC`IMP[dij@zpXindG^@\ngC`L@DPHPPeMPGVCGMy``\ngC`L@DPHPPeMPGVCGMyo@\ngC`L@DPHPPeMPGVCGUy``\ngC`L@DPHPPeMPGVCGV\\FJ[sA@\ngC`L@VPHPPeMPGVCGMy``\ngC`L@bPHPPeMPGVCGMy``\ngC`PAEdij@zPXypXi@\ngC``@deZ@ztTyoLD\ngC``ADij@zHXis]HN|\ngC``ADij@zHXis]Kv|\ngC``ADij@zHXisgAbfzP\\D\ngC``ADij@zHXisgAbfzP]x\ngC``ADij@zHXisgAbfzWmx\ngC``Adej@zTT`\ngC``Adej@zTTypXi@\ngC``Adij@zpXioDD\ngC``Adij@zpXioEx\ngC``Adij@zpXis`qS^HH\ngC``Adij@zpXjoDD\ngC``Adij@zpXjs`qS^HH\ngC`hH`xIKTAuhis]Cv|\ngCa@@dkHGVbgH\ngCa@@dkHGVbgMyn`\ngCa@@dkPGVbgMy``\ngCa@@dmHGVbgH\ngCa@@dmHGVbgMyn`\ngCa@@dmHGVbgN\\FJP\ngCa@@dmHGVbgN\\FJ[s]@\ngCa@@dmPGVbgMy``\ngCa@@dmPGVbgMyo@\ngCa@@dmPGVbgN\\FJ[sA@\ngCa@@dmPGVbgN\\FJ[s^@\ngCa@@dmPGVbgUy``\ngCa@@dmPGVbgV\\FJ[sA@\ngCa@@eMHGQCEN[iAwP\ngCa@@eMHGQCEN[qA@\ngCa@@eMHGQCEN[q^@\ngCa@@eMHGQCEN\\xLTwRCn`\ngCa@@eMHGQCEN\\xLTwbB\ngCa@@eMHGQCEV[iAwP\ngCa@@eMHGQCEV\\xLTwRCn`\ngCa@@eMHGQCEV\\xLTwbB\ngCa@@eMPGQCEN[iApP\ngCa@@eMPGQCEN[iAw`\ngCa@@eMPGQCEN[i^pP\ngCa@@eMPGQCEN[i^w`\ngCa@@eMPGQCEN\\xLTwRC``\ngCa@@eMPGQCEN\\xLTwRCo@\ngCa@@eMPGQCEN\\xLTwR}``\ngCa@@eMPGQCEN\\xLTwR}o@\ngCa@@eMPGQCENkiApP\ngCa@@eMPGQCENki^pP\ngCa@@eMPGQCENlxLTwRC``\ngCa@@eMPGQCENlxLTwR}``\ngCa@@eMPGQCEV[iApP\ngCa@@eMPGQCEV[iAw`\ngCa@@eMPGQCEV\\xLTwRC``\ngCa@@eMPGQCEV\\xLTwRCo@\ngCa@@eMPGQCEVkiApP\ngCa@@eMPGQCEVlxLTwRC``\ngCaH@jAJZ`NlFN[i^pP\ngCaH@jAJZ`NlFN\\xLTwR}``\ngCaH@jAJZ`NlFN\\xLTwfB\ngCaH@jAJZ`NlFN\\xLTwf|\ngCaHDGAIZ`NmEN[h^pP\ngCaHH@aIZ`NmEN[h^pP\ngCaHH@aIZ`NmEN[h^w`\ngCaHH@aIZ`NmEN\\xLTwP}``\ngCaHHGAIZ`NmEN[h^pP\ngCaHHGAIZ`NmEN[h^w`\ngCaHHGAIZ`NmEN\\xLTwP}``\ngCaHHGAIZ`NmENkh^pP\ngCaHHOAIZ`NmEN[h^pP\ngCaHHOAIZ`NmEN[h^w`\ngCaHHOAIZ`NmEN[sA@\ngCaHHOAIZ`NmEN\\xLTwP}``\ngCaHHOAIZ`NmEN\\xLTwP}o@\ngCaHHOAIZ`NmEN\\xLTwf|\ngCaHHOAIZ`NmENkh^pP\ngCaHHOAIZ`NmENlxLTwP}``\ngCaHL@aIZ`NeEH\ngCaHL@aIZ`NeEN\\FJP\ngCaHLDQIZ`NeEH\ngCaHLGAIZ`NeEMxO@\ngCaHLHaIZ`NeEH\ngCaHLLQIZ`NeEH\ngCaHLOAIZ`NeEMxO@\ngCaI@jA\\eMPGVCGMtoXH\ngCaIHO@RdmPGVbgMtOXH\ngCaIHO@RdmPGVbgN\\FJ[h^pP\ngCaIL@`RdmPGRbd\ngCd@@deZ@ztTyoLG}h`\ngCd@@deZ@ztTys`qS^XO{Q@\ngCd@@deZ@ztTzoLG}h`\ngCd@@deZ@ztTzs`qS^XO{Q@\ngCd@ADie@zHXis]Kn{~rD@\ngCd@ADie@zHXis^Ko{HP\ngCd@ADie@zHXisgAbfzW]w}dH\ngCd@ADie@zHXis~rD@\ngCd@ADif@zHXis]KnC~rD@\ngCd@ADif@zHXis^XO{HP\ngCd@ADif@zHXisgAbfzW\\G}dH\ngCd@ADif@zHXisgAbf|p_vP`\ngCd@ADif@zHXiu]KnC~rD@\ngCd@ADif@zHXiu^XO{HP\ngCd@ADij@zHXis]HNC~rD@\ngCd@ADij@zHXis]HNC~t@\ngCd@ADij@zHXiu]HNC~rD@\ngCd@ADij@zHXju]HNC~rD@\ngCd@ADkj@zpTzoLD\ngCd@AdeY@zTT`\ngCd@Adej@zTT`\ngCd@Adej@zTTypXi@\ngCd@Adij@zpXioDG}h@\ngCd@Adij@zpXis`qS^HO{P@\ngCd@Adij@zpXjoDG}h@\ngCd@Adij@zpXjs`qS^HO{P@\ngCd@aAteJz`NlEN[sA\x7FZ@\ngCd@aAteJz`NlEN[s^\x7FZ@\ngCd@aaNeIZ`NeEH\ngCd@aaNeIZ`NeEN\\FJP\ngCd@aaNeIZ`NeEN\\FJ[h^w`\ngCd@aaNeIZ`NeEN\\FJ[p^@\ngCdAAIrTs@]DLTznewA\x7FYB@\ngCdAAaJRu@]JJP\ngCdAAaJRu@]JJ[p^@\ngCdAAaJRu@]JJ\\xLT`\ngCdAAaJRu@]JJ\\xLTw`|\ngCdDE`DPHRfhCiAb\ngCdHH`DIKRAuhis]Cv{~rb@\ngCdHH`DIKRAuhis^Cw{JH\ngCdHI`DIKTAthis`qS^Cw{R@\ngCe@E`dkPGRbg}h`\ngCh@@dkHGVbgH\ngCh@@dkPGVbgMy``\ngCh@@dmHGVbgH\ngCh@@dmHGVbgMyn`\ngCh@@dmHGVbgN\\FJP\ngCh@@dmHGVbgN\\FJ[s]@\ngCh@@dmPGVbgMtOXH\ngCh@@dmPGVbgMy``\ngCh@@dmPGVbgMyo@\ngCh@@dmPGVbgN\\FJ[h^pP\ngCh@@dmPGVbgN\\FJ[sA@\ngCh@@dmPGVbgN\\FJ[s^@\ngCh@@dmPGVbgUy``\ngCh@@dmPGVbgV\\FJ[sA@\ngCh@@eLhGQCEN\\xLTwR{n\x7Fm@\ngCh@@eLhGQCEN\\xLTwb{~t@\ngCh@@eMHGQCEN[iAw_v`@\ngCh@@eMHGQCEN[i^w_v`@\ngCh@@eMHGQCEN[qA\x7FZ@\ngCh@@eMHGQCEN\\xLTwRCn\x7Fm@\ngCh@@eMHGQCEN\\xLTwbC~t@\ngCh@@eMHGQCEV[iAw_v`@\ngCh@@eMHGQCEV[qA\x7FZ@\ngCh@@eMPGQCEN[iApP\ngCh@@eMPGQCEN[iAp_v`@\ngCh@@eMPGQCEN[iAw`\ngCh@@eMPGQCEN[iAwov`@\ngCh@@eMPGQCEN[i^pP\ngCh@@eMPGQCEN\\xLTwRC``\ngCh@@eMPGQCEN\\xLTwRC`\x7Fm@\ngCh@@eMPGQCEN\\xLTwRCo@\ngCh@@eMPGQCEN\\xLTwRCo_m@\ngCh@@eMPGQCEN\\xLTwR}``\ngCh@@eMPGQCENkiApP\ngCh@@eMPGQCENkiAp_v`@\ngCh@@eMPGQCENki^pP\ngCh@@eMPGQCENlxLTwRC``\ngCh@@eMPGQCEV[iApP\ngCh@@eMPGQCEV[iAp_v`@\ngCh@@eMPGQCEV[iAwov`@\ngCh@@eMPGQCEV\\xLTwRC``\ngCh@@eMPGQCEV\\xLTwRC`\x7Fm@\ngCh@@eMPGQCEVkiApP\ngCh@@eMPGQCEVkiAp_v`@\ngCh@@e[PGQCEN[j]p_v`@\ngCh@@e[PGQCEN[sA\x7FZ@\ngCh@@e[PGQCEN[s^\x7FZ@\ngCh@@e[PGQCEN\\xLTwT{`\x7Fm@\ngCh@@e[PGQCENkj]p_v`@\ngCh@@e[PGQCENksA\x7FZ@\ngCh@@e[PGQCENlxLTwT{`\x7Fm@\ngChA@IRUdCkQSf|GP\ngChA@IRVdCkQSd\ngChA@IRVhCkQSfzGlD\ngChA@IRVhCkQSf|pP\ngChA@IRVhCkQSf|w`\ngChA@IRVhCkQSgNCEMtOXH\ngChA@IRVhCkQSgNCEMy``\ngChA@IRVhCkQSgNCEMyo@\ngChA@IRVhCkQSj|pP\ngChA@IRVhCkQSkNCEMy``\ngChA@IRfhChabgMt`xH\ngChA@IRfhChabgMt`{p\ngChA@IRfhChabgMtoXH\ngChA@IRfhChabgN\\FJ[iApP\ngChA@IRfhChabgUt`xH\ngChA@IRfhChabgUtoXH\ngChA@IRfhChabgV\\FJ[iApP\ngChA@IRfhChabkUt`xH\ngChA@IRmhChabgMuNxO{P@\ngChA@IRmhChabgMy`\x7Fm@\ngChA@IRmhChabgN\\FJ[j]p_v`@\ngChA@IRmhChabgUuNxO{P@\ngChDD@bABUt`]XJ\\wf{~tP\ngChDDDRHbUt`]XJ\\wf{~tP\ngChHD@aIZ`NmEN[h^p_vb@\ngChHDOAIZ`NmENkh^p_vb@\ngChHH@aIZPNmEN[h^w_vd@\ngChHH@aIZ`NmEN[h^p_vd@\ngChHH@aIZ`NmEN[h^wovd@\ngChHH@aIZ`NmEN\\xLTwP}`\x7FmH\ngChHH@aIZ`NmENkh^p_vd@\ngChHH@aJZPNbFJlypXindG]\x7FZP\ngChHHOAIZ`NmEN[h^p_vd@\ngChHHOAIZ`NmEN\\xLTwP}`\x7FmH\ngChHHOAIZ`NmENkh^p_vd@\ngChHL@aIZ`NeEH\ngChHL@aIZ`NeEMxO@\ngChHL@aIZ`NeEN\\FJP\ngChHL@aJZ`NlFJ[qA@\ngChHL@aJZ`NlFJ\\xLTwbB\ngChHLHaIZ`NeEH\ngChHLLQIZ`NeEH\ngChHLOAIZ`NeEH\ngChIDOARdmPGVbgMtOXH\ngChIHOBRdkPGVbgMy`\x7FmH\ngChIL@cRdmPGRbd\ngChIL@cRdmPGRbf|G`\ngChILLSRdmPGRbd\ngCh`LHe]PGRBd\ngCi@DDeZ@ztTyoLG}h`\ngCi@DDeZ@ztTyoM{}h`\ngCi@DDeZ@ztTzoLG}h`\ngCi@HDii@zHXis]HN{~t`\ngCi@HDii@zHXis^HO{R@\ngCi@HDii@zHXisgAbfzP]w}i@\ngCi@HDii@zHXjs]HN{~t`\ngCi@HDij@zHXis]HNB\ngCi@HDij@zHXis]HNC~t`\ngCi@HDkj@zpTyoLD\ngCi@HDkj@zpTyoMx\ngCi@HDkj@zpTys`qS^XH\ngCi@HDkj@zpTzoLD\ngCi@LDej@zTT`\ngCi@LDej@zTTypXi@\ngCi@LDej@zTTypXioMx\ngCi@LDij@zpXioDD\ngCi@LDij@zpXis`qS^HH\ngCi@LDij@zpXjs`qS^HH\ngCiALMJRu@]JJP\ngCiALMJRu@]JJ[s^@\ngCiALMJRu@]JJ\\xLT`\ngCiALMJRu@]JJ\\xLTwf|\ngCl@ADe[PGVBgUy`\x7Fl``\ngClAADnRmhCkASj|p_vPP\ngFp@DjYZXHCkASfyW]x{n\x7FrTrp=\ngFp@DjYZjjQCiabgIZyHXis\\kv|_WwyJYX<\ngFp@DjxujhCiabgIZwL{`dMC~RvN@\ngFp@LdaahUPGVrVmsMkYCP\x7Fdmc`=\ngFp@LdaahUPGVrVmsMkY}__dmc`=\ngFp@LdaahUPGVrVmsMkiCP\x7Fdmc`\ngFp@LdaahUTrGVrVmsMkYC__dmc`+\ngFp@LdaahUTrGVrVmsMkYC__dmc`-\ngFp@LdaahUTrGVrVmsMkiC__dmc`<\ngFp@LdaahUTrGVrVmsMkiC__dmc`>\ngFp@LddLUUPGSCENRusdyK\\pJBPtOyHZX\ngFp@LddLUUPGSCENRusdyK\\sr|PtOyHZX\ngFp@LddLUUTBGSCENRurPqRVy`Uxah_rPtp>\ngFp@LddLUUTBGSCENRus`iK\\sr|PtOyHZX>\ngFp@LddLUUTBGSCENRusdyK\\pJ|PtOyHZX<\ngFp@LddLUUTBGSCENRusdyK\\pJ|PtOyHZX>\ngFp@LddLUUTBGSCENRushiK\\pJ|PtOyHZX<\ngFp`@TfXujjJChqSfnSENRwVCP\x7Fdmc`<\ngFp`@TizJjiRYChqSfn\\dm[iAh_rPup<\ngFp`@TizJjiRZChqSfmtoTOyHZx<\ngFp`@TizJjiRZChqSfmtoTOyHZx>\ngFp`@TizJjiRZChqSfn\\dm[iAh_rPup<\ngFp`@TizJjiRZChqSfn\\dm[iAh_rPup>\ngFp`@dfxujhChqrVmtPtOyKXx\ngFp`@dfxujhChqrVmt_WwyKXx\ngFp`@dfxujjYChqrVmtPwwyKXx<\ngFp`@dfxujjYChqrVmtPwwyKXx>\ngFq@@dmXuU@]VJ\\ek_XICP\x7Fdem`\ngFq@@dsFmU@]VJ\\ek_XICP\x7Fdmc`\ngFq@@dsFmU@]VJ]Ek_XICP\x7Fdmc`\ngFq@@dsFmUQH]VJ]Ek_XIC__dmc`<\ngFq@@dsFmUQH]VJ]Ek_XIC__dmc`>\ngFq@@dsFuURH]VJ\\ek_XICP\x7Fdmc`<\ngFq@@dsFuURH]VJ\\ek_XICP\x7Fdmc`>\ngFq@@eMXuURH]LLTyKVyP\\D~h_rRvp<\ngFq@@eMqUURH]VJ\\ek_HICP\x7Fdak`<\ngFq@@eMqUURH]VJ\\ek_HICP\x7Fdak`>\ngFq@@eMqUURH]VJ\\ek_KqCP\x7Fdak`<\ngFq@@eMqUURH]VJ\\ekdaRVm|oDMC~RFn@>\ngFq@@eMqUURH]VJ\\ekgIKV~WbFa\x7FICW@<\ngFq@@eMqUURH]VJ\\ekgIKV~WbFa\x7FICW@>\ngFq@@eMqUURH]VJ\\ekgIrV~PRFa\x7FICW@<\ngFq@@eMqUURH]VJ\\ekgIrV~PRFa\x7FICW@>\ngFq@@eMqUURH]VJ\\ekgIrV~PSza\x7FICW@<\ngFq@@eOQUARP]JJ[yAN{o|dM\\+\ngFq@@eOQUARP]JJ[yAN{o|dM\\-\ngFq@@eOQUARP]JJ[y^N{o|dM\\+\ngFq@@eOQUARP]JJ[y^N{o|dM\\-\ngFq`@bdwFmUSP]ZNZweC~RvN@>\ngFq`ALe\\qUU@]ENRunbFa\x7FISW@\ngFx@@eMXuU@]LLTyKVyP\\Dah_rRvuh@\ngFx@@eOQMA@]JJ[y^N{o|dM\\=\ngFx@@eOQUARP]JJ[yAN{o|dM\\+\ngFx@@eOQUARP]JJ[yAN{o|dM\\-\ngFx@@eOQUARP]JJ[y^N{o|dM\\+\ngFx@@eOQUARP]JJ[y^N{o|dM\\-\ngFx@@eSFuU@]LLTyKVyP\\Dah_rVquh@=\ngFx@@eSFuU@]LLTzKVyP\\Dah_rVquh@\ngFx@@eSFuU@]LLUZKVyP\\Dah_rVqp\ngFxAAIRicZ`@NbFR\\wJC`gm{~RvN@=\ngFxAAYRicZ`@NbFR\\wJC`gm{~RvNm@=\ngFx`DBdwFmUSP]ZNZweC~RvN@<\ngFy@DDfxujhChqrVmtPtOyKXx\ngFy@DDfxujjYChqrVmtPwwyKXx<\ngFy@DDfxujjYChqrVmtPwwyKXx>\ngGP@DiWj`NbgIZwQCP`\ngGP@DjZ@@Mrm{Yw]`=\ngGP@DjZ@@Mrm{Yw^`=\ngGP@DjZ@@Mrm{Y{^`=\ngGP@DjZ@@Mrm{iw^`\ngGP@DjZ@@Mrm{i{^`=\ngGP@DjZ@@Mrn{i{^`=\ngGP@DjZ@@NZFJ\\enUw]O[t=\ngGP@DjZ@@N\\EI[e[wSn}@\ngGP@DjZ@@N\\EN[e[wSv}@\ngGP@DjZ@@N\\FN[e]wSv}@\ngGP@DjZX@NhJyV}l{np=\ngGP@DjZX@NhJyV}l{oP\ngGP@DjZX@NhJyV}l}oP=\ngGP@DjZX@NhJyV}t{np=\ngGP@DjZX@NhJyV}t{oP\ngGP@DjZX@NhJyW]l{np=\ngGP@DjZX@NhJyW]l{oP\ngGP@DjZX@NhJyW]l}oP=\ngGP@DjZX@NhJyW]t{np=\ngGP@DjZX@NhJyW]t{oP\ngGP@DjZX@NhJyW]t}oP=\ngGP@DjZX@NhKNBdmrn{iw^`\ngGP@DjZX@NhKNCDmrn{Yw^`\ngGP@DjZX@NhKNCDmrn{iw^`\ngGP@DjZX@NlEN[e]pSn{@=\ngGP@DjZX@NlEN[e]pSn{\x7FIPh`=\ngGP@DjZX@NlEN[e]pSn}@\ngGP@DjZX@NlEN[e]pSv}@=\ngGP@DjZX@NlEN[e]wcn{@=\ngGP@DjZX@NlEN[e]wcn{\x7FIPh`=\ngGP@DjZX@NlEN[e]wcn}@\ngGP@DjZX@NlEN[e]wcv}@=\ngGP@DjZX@NlEN[{AN{l=\ngGP@DjZX@NlEN[{AN{t\ngGP@DjZX@NlEN[{AO[t=\ngGP@DjZX@NlEN[{^N{l=\ngGP@DjZX@NlEN[{^N{t\ngGP@DjZX@NlEN\\xJRwJ{`g]z\ngGP@DjZX@NlEN\\xJRwJ{oG]z\ngGP@DjZX@NlEN\\xJRwvB]wh\ngGP@DjZX@NlEN\\xJRwv|]wh\ngGP@DjZX@NlEN\\xJ\\wJ{`gmz\ngGP@DjZX@NlEN\\xJ\\wvB^wh\ngGP@DjZX@NlEN\\xLRwJ{`g]z\ngGP@DjZX@NlEN\\xLRwvB]wh\ngGP@DjZX@NlEN\\xLRwv|]wh\ngGP@DjZX@NlEN\\xL\\wJ{`gmz\ngGP@DjZX@NlEN\\xL\\wvB^wh\ngGP@DjZX@NlENke]pSn{@=\ngGP@DjZX@NlENke]pSn}@\ngGP@DjZX@NlENke]pSv}@=\ngGP@DjZX@NlENk{AN{l=\ngGP@DjZX@NlENk{AN{t\ngGP@DjZX@NlENk{AO[t=\ngGP@DjZX@NlENlxJRwJ{`g]z\ngGP@DjZX@NlENlxJRwvB]wh\ngGP@DjZX@NlENlxLRwJ{`g]z\ngGP@DjZX@NlENlxLRwvB]wh\ngGP@DjZX@NlENlxL\\wJ{`gmz\ngGP@DjZX@NlENlxL\\wvB^wh\ngGP@DjZY`NbFR\\wJ{`g]z\ngGP@DjZY`NbFR\\wJ{`gmv\ngGP@DjZY`NbFR\\wJ{`gmz\ngGP@DjZY`NbFR\\wJ{oGmv\ngGP@DjZY`NbFR\\wJ{oGmz\ngGP@DjZY`NbFR\\wvB]wX\ngGP@DjZY`NbFR\\wvB^wh\ngGP@DjZY`NbFR]WJ{`gmv\ngGP@DjZY`NbFR]WJ{`gmz\ngGP@DjZY`NdJUrm{Yw]`\ngGP@DjZY`NdJUrm{iw^`\ngGP@DjZY`NdJUrn{Y{]`\ngGP@DjZY`NdJUrn{i{^`\ngGP@DjZY`NfFJ\\ek\\knB^tH\ngGP@DjZY`NfFJ\\ek]XMB\ngGP@DjZY`NfFJ\\ek_KnCP`\ngGP@DjZY`NfFJ\\ek_XI{_@\ngGP@DjZY`NfFJ\\ekfabgI[e]pSva@\ngGP@DjZY`NfFJ\\ekfabgI[kAhP\ngGP@DjZY`NfFJ\\ekfabgI[y]pZD\ngGP@DjZY`NfFJ\\ekgARVyW\\D}hP\ngGP@DjZY`NfFJ\\ekgARV~W\\Fa@\ngGP@DjZY`NfFJ\\ekgASf~W\\Fa@\ngGP@DjZY`NfFJ\\ekgAbVzpZD\ngGP@DjZY`NfFJ\\ekgAbV~W\\Fa@\ngGP@DjZY`NfFJ\\ekgAcfyW\\D}hP\ngGP@DjZY`NfFJ\\ekgAcf~W\\Fa@\ngGP@DjZY`NfFJ\\em\\knB^tH\ngGP@DjZY`NfFJ\\em]XMB\ngGP@DjZY`NfFJ\\em_KnCP`\ngGP@DjZY`NfFJ\\em_XI{P`\ngGP@DjZY`NfFJ\\emgAcfyW\\D}hP\ngGP@DjZY`NfFJ\\emgAcf~W\\Fa@\ngGP@DjZY`NfFJ]Em\\knB^tH\ngGP@DjZY`NfFJ]Em]XMB\ngGP@DjZY`NfFJ]Em_KnCP`\ngGP@DjZY`NfFJ]EmgAcfyW\\D}hP\ngGP@DjZj`NfFJ\\ek\\hNBPtH\ngGP@DjZj`NfFJ\\ekfabgI[eApRFa@\ngGP@DjZj`NfFJ\\fm\\hNBPtH\ngGP@DjZj`NfFJmFm\\hNBPtH\ngGP@DjZjdEDNfFJ\\ekdacdmr`xIC_@<\ngGP@DjZjdEDNfFJ\\ekdacdmr`xIC_@>\ngGP@DjZjdEDNfFJ\\ekfabgI[eAwbF~@<\ngGP@DjZjdEDNfFJ\\ekfabgI[eAwbF~@>\ngGP@DjZjdEDNfFJ\\ekgARVyP]xao`<\ngGP@DjZjdEDNfFJ\\ekgARVyP]xao`>\ngGP@DjZjdEDNfFJ\\ekgAbVyP\\Dao`<\ngGP@DjZjdEDNfFJ\\ekgAbVyP\\Dao`>\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\Dao`<\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\Dao`>\ngGP@DjZjdEDNfFJ\\emgAbVyP\\DahP<\ngGP@DjZjdEDNfFJ\\emgAbVyP\\DahP>\ngGP@DjZjdEDNfFJ\\emgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\emgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ\\fmgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\fmgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ]EkfabgI[eApRF~@<\ngGP@DjZjdEDNfFJ]EkfabgI[eApRF~@>\ngGP@DjZjdEDNfFJ]Em\\hNBPtH<\ngGP@DjZjdEDNfFJ]Em\\hNBPtH>\ngGP@DjZjdEDNfFJ]EmgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ]EmgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ]FmgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\ekfabgI[eAwbF~@\ngGP@DjZjdEHNfFJ\\ekgARVyP]xao`\ngGP@DjZjdEHNfFJ\\ekgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ\\ekgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ\\ekgAcfyP\\DahP\ngGP@DjZjdEHNfFJ\\emgAbVyP\\DahP<\ngGP@DjZjdEHNfFJ\\emgAbVyP\\DahP>\ngGP@DjZjdEHNfFJ\\emgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\emgAcfyP\\DahP>\ngGP@DjZjdEHNfFJ\\fkgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ\\fkgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ\\fmgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\fmgAcfyP\\DahP>\ngGP@DjZjdEHNfFJ]EkfabgI[eApRF~@>\ngGP@DjZjdEHNfFJ]EkgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ]EkgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ]Em\\hNBPtH\ngGP@DjZjdEHNfFJ]EmgAbVyP\\DahP<\ngGP@DjZjdEHNfFJ]EmgAbVyP\\DahP>\ngGP@DjZjhDNfFJ\\fmdacdmr`xICP`<\ngGP@DjZjhDNfFJ\\fmdacdmr`xICP`>\ngGP@DjZjhDNfFJ]Fm\\hNBPtH>\ngGP@DjZjiDNfFJ\\ek\\hNBPwp<\ngGP@DjZjiDNfFJ\\ek\\hNBPwp>\ngGP@DjZjiDNfFJ\\ekdabdmr`xIC_@<\ngGP@DjZjiDNfFJ\\ekdabdmr`xIC_@>\ngGP@DjZjiDNfFJ\\ekdabgMr`xICP`<\ngGP@DjZjiDNfFJ\\ekdabgMr`xICP`>\ngGP@DjZjiDNfFJ\\ekfabgI[eApRF~@<\ngGP@DjZjiDNfFJ\\ekfabgI[eApRF~@>\ngGP@DjZjiDNfFJ\\em\\hNBPtH<\ngGP@DjZjiDNfFJ\\em\\hNBPtH>\ngGP@DjZjiDNfFJ\\emdabgMr`xICP`<\ngGP@DjZjiDNfFJ\\emdabgMr`xICP`>\ngGP@DjZjiDNfFJ\\emfabgI[eApRFa@<\ngGP@DjZjiDNfFJ\\emfabgI[eApRFa@>\ngGP@Djfj`NfFJ\\ek\\hNBPtH\ngGP@Djfj`NfFJ\\ek\\hNBPtOyJED\ngGP@Djfj`NfFJ\\ek\\hNBPwp\ngGP@Djfj`NfFJ\\ek\\hNB_TH\ngGP@Djfj`NfFJ\\ek\\hNB_Wp\ngGP@Djfj`NfFJ\\ek\\hN|_TH\ngGP@Djfj`NfFJ\\ekdaSdmr`{q}P`\ngGP@Djfj`NfFJ\\ekdaSdmr`{q}_@\ngGP@Djfj`NfFJ\\ekdabdmr`xICP`\ngGP@Djfj`NfFJ\\ekdabdmr`xIC_@\ngGP@Djfj`NfFJ\\ekdabdmr`xI}P`\ngGP@Djfj`NfFJ\\ekgAbVyP\\DahP\ngGP@Djfj`NfFJ\\ekgAbVyP\\Dao`\ngGP@Djfj`NfFJ\\ekgArVyP\\Dah_rTJH\ngGP@Djfj`NfFJ\\ekgArVyP\\D~hP\ngGP@Djfj`NfFJ\\ekgArVyP\\D~o`\ngGP@Djfj`NfFJ\\em\\hNBPtH\ngGP@Djfj`NfFJ\\em\\hNB_TH\ngGP@Djfj`NfFJ\\emgAbVyP\\DahP\ngGP@Djfj`NfFJ\\emgArVyP\\D~hP\ngGP@Djfj`NfFJ\\fk\\hNBPtH\ngGP@Djfj`NfFJ\\fk\\hNBPwp\ngGP@Djfj`NfFJ\\fkdabdmr`xICP`\ngGP@Djfj`NfFJ\\fkdabdmr`xIC_@\ngGP@Djfj`NfFJ\\fkgArVyP\\DahP\ngGP@Djfj`NfFJ\\fkgArVyP\\Dao`\ngGP@Djfj`NfFJ\\fm\\hNBPtH\ngGP@Djfj`NfFJ]Fk\\hNBPtH\ngGP@Djfj`NfFJ]Fk\\hNBPwp\ngGP@Djfj`NfFJ]FkgAbVyP\\DahP\ngGP@Djfj`NfFJ]Fm\\hNBPtH\ngGP@Djfj`NfFJmEk\\hNB_TH\ngGP@Djfj`NfFJmFk\\hNBPtH\ngGP@DjfjhDNfFJ\\ekdabdmr`{q}P`<\ngGP@DjfjhDNfFJ\\ekdabdmr`{q}P`>\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}P`<\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}P`>\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}_@<\ngGP@DjfjhDN