!function(n,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((n="undefined"!=typeof globalThis?globalThis:n||self).nmrProcessing={})}(this,(function(exports){"use strict";const gyromagneticRatio={"1H":267522187.44,"2H":41065e3,"3H":285350800,"3He":-203789e3,"7Li":103962e3,"13C":67282840,"14N":19331e3,"15N":-27116e3,"17O":-36264e3,"19F":251662e3,"23Na":70761e3,"27Al":69763e3,"29Si":-5319e4,"31P":108291e3,"57Fe":8681e3,"63Cu":71118e3,"67Zn":16767e3,"129Xe":-73997e3};function getGyromagneticRatio(n){if(gyromagneticRatio[n])return gyromagneticRatio[n];if("proton"===(n=n.toLowerCase()))return gyromagneticRatio["1H"];const t=n.replace(/[^0-9]/g,"");if(!t)return null;for(const n in gyromagneticRatio)if(n.includes(t))return gyromagneticRatio[n];return null}const impuritiesContent={cdcl3:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"ds",shift:7.26}],h2o:[{proton:"H2O",coupling:0,multiplicity:"bs",shift:1.56}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.17}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.28}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.19},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.98},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.01},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.27},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.43}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.26}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.73}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.3}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.21},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.48}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.65},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.57},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.39}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.4},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.55}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.09},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.02},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.88}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.62}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.71}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.25},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.72},{proton:"OH",coupling:5,multiplicity:"s,t",shift:1.32}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.05},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.12},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.14},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.46},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.06}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.76}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.26}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.26}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.65}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.49},{proton:"OH",coupling:0,multiplicity:"s",shift:1.09}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.33}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:7},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.22},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.04}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.62},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.29},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.68}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.07}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.85},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.76}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.17},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.03},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.53}]},"(cd3)2co":{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:2.05}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.84}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.05}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.13},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.96},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.41}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.87}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.63}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.41}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.56},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.47},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.28}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.46}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.78}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.52}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.59}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.57},{proton:"OH",coupling:5,multiplicity:"s,t",shift:3.39}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.05},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.45},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.28}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.87},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.59}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"OH",coupling:0,multiplicity:"s",shift:3.12}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.43}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.1},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.9}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.35},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.76}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.13}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.79},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.63}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.5},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.5}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},dmso:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"quint",shift:2.5}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:3.33}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.91}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.07}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.19}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.08}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.87},{proton:"OHc",coupling:0,multiplicity:"s",shift:6.65},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.18},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.36}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.32}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.76}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.09},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.38}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.51},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.38},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.24}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.24},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.43}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.78}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.95},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.73}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.54}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.57}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.06},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.44},{proton:"OH",coupling:5,multiplicity:"s,t",shift:4.63}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.99},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.03},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.17}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.91}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.34}],"grease^f":[],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.25}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.53}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.16},{proton:"OH",coupling:0,multiplicity:"s",shift:4.01}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.42}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.04},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.78}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.39},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.79}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.76},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.6}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.3},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.18},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.93},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.43}]},c6d6:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:7.16}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:.4}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.15}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:1.55}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.07},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.04}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:7.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.79},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.24},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.38}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:6.15}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:2.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:4.27}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.26}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.46},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.34},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.11}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.12},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.33}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.6},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.57},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.05}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.63},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH3",coupling:0,multiplicity:"s",shift:1.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.68}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.35}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.34}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.65},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.89},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.92}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.58},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:1.81},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.85}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.41}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.92},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.36}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.24}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.4}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.07}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.23}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:.95},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.67}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:6.66},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:6.98}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.29}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.4},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.57}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.11},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.02},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.13}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.4}]},cd3cn:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:1.94}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.13}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.16},{proton:"OHc",coupling:0,multiplicity:"s",shift:2.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.14},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.97},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.2},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.39}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.58}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.44}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.81}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.44}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.42}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.53},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.45},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.29}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.45}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.77}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.5}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.54},{proton:"OH",coupling:5,multiplicity:"s,t",shift:2.47}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.06},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.06},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.51}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.27}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.57}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"OH",coupling:0,multiplicity:"s",shift:2.16}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.31}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.87},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.09},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.87}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.57},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.33},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.73}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.08}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.8},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.64}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.33},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.2},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.2}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},cd3od:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:3.31}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:4.87}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.99}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.15}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.03}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.33}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.4}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.15},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.2}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.92},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.21},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.4}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.9}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.45}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.78}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.49}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.18},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.49}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.58},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.35}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.35},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.52}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.92}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.97},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.99},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.65}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.66}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.19},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.6}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.01},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.09},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.12},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.5},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.01}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.59}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.88},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.9},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.64}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.34}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.5},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.92}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.44},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.85}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.1}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.87},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.71}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.16},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.16}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.05},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.58}]},d2o:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:4.79}],h2o:[],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.22}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.06}],benzene:[],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.24}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.21},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[],chloroform:[],cyclohexane:[],"1,2-dichloroethane":[],dichloromethane:[],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.56}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.67},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.37}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.37},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.08},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.06},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.9}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:3.01},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.85}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.71}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.75}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.65}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.14},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.19},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.18},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.65}],"grease^f":[],"n-hexane":[],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.61}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.4}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.9}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.17},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.02}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.52},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.45},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.87}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.88},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.74}],toluene:[],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.99},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.57}]}},impurities=impuritiesContent,SignalKinds=[{label:"Signal",value:"signal"},{label:"Reference",value:"reference"},{label:"Solvent",value:"solvent"},{label:"Impurity",value:"impurity"},{label:"Standard",value:"standard"},{label:"P1",value:"p1"},{label:"P2",value:"p2"},{label:"P3",value:"p3"}],SignalKindsToInclude=["signal"],DatumKind={signal:"signal",mixed:"mixed"},MultiplicityPatterns=[{label:"singlet",value:"s",multiplicity:1,names:["br s","br. s"]},{label:"triplet",value:"t",multiplicity:3,names:[]},{label:"doublet",value:"d",multiplicity:2,names:[]},{label:"quartet",value:"q",multiplicity:4,names:[]},{label:"quintet",value:"i",acs:"quint",multiplicity:5,names:["quint","qui","qnt","pentet","pnt","pent"]},{label:"sextet",value:"h",multiplicity:6,names:["x","sxt","sext","hexuplet"]},{label:"septet",value:"p",acs:"sept",multiplicity:7,names:["sept","spt","heptet","hpt","hept"]},{label:"octet",value:"o",multiplicity:8,names:["oct"]},{label:"nonet",value:"n",multiplicity:9,names:["non"]},{label:"massive",value:"m",multiplicity:null,names:[]}];MultiplicityPatterns.sort(((n,t)=>null!==n.multiplicity&&null!==t.multiplicity?n.multiplicity-t.multiplicity:Number.MAX_SAFE_INTEGER));const couplingPatterns=MultiplicityPatterns.map((n=>n.value)),couplingACSPatterns=MultiplicityPatterns.map((n=>n.acs||n.value)),toCheck=["solvent","h2o","tms"];function peaksFilterImpurities(n,t={}){const{error:e=.025,remove:i=!1}=t;if(t.solvent){let{solvent:s}=t;"(cd3)2so"===s&&(s="dmso"),"meod"===s&&(s="cd3od");const a=impurities[s];for(const t of toCheck){checkImpurity(n,a[t],{error:e,remove:i,name:t})}}return n}function checkImpurity(n,t,e){const{name:i,error:s,remove:a}=e;let r,o,l,f=t.length;for(;f--;)for(r=n.length;r--;)o=s+n[r].width,l=Math.abs(t[f].shift-n[r].x),l<o&&(a?n.splice(r,1):n[r].kind=i)}const GAUSSIAN_EXP_FACTOR=-4*Math.LN2,ROOT_PI_OVER_LN2=Math.sqrt(Math.PI/Math.LN2),ROOT_THREE=Math.sqrt(3),ROOT_2LN2=Math.sqrt(2*Math.LN2),ROOT_2LN2_MINUS_ONE=Math.sqrt(2*Math.LN2)-1;function erfinv(n){if(0===n)return 0;let t=Math.log(1-n*n),e=t/2+2/(.147*Math.PI),i=Math.sqrt(e**2-t/.147);return Math.sqrt(i-e)*(n>0?1:-1)}class Gaussian{constructor(n={}){const{fwhm:t=500,sd:e}=n;this.fwhm=e?gaussianWidthToFWHM(2*e):t}fwhmToWidth(n=this.fwhm){return gaussianFwhmToWidth(n)}widthToFWHM(n){return gaussianWidthToFWHM(n)}fct(n){return gaussianFct(n,this.fwhm)}getArea(n=calculateGaussianHeight({fwhm:this.fwhm})){return getGaussianArea({fwhm:this.fwhm,height:n})}getFactor(n){return getGaussianFactor(n)}getData(n={}){return getGaussianData(this,n)}calculateHeight(n=1){return calculateGaussianHeight({fwhm:this.fwhm,area:n})}getParameters(){return["fwhm"]}}function calculateGaussianHeight(n){let{fwhm:t=500,area:e=1,sd:i}=n;return i&&(t=gaussianWidthToFWHM(2*i)),2*e/ROOT_PI_OVER_LN2/t}function gaussianFct(n,t){return Math.exp(GAUSSIAN_EXP_FACTOR*Math.pow(n/t,2))}function gaussianWidthToFWHM(n){return n*ROOT_2LN2}function gaussianFwhmToWidth(n){return n/ROOT_2LN2}function getGaussianArea(n){let{fwhm:t=500,sd:e,height:i=1}=n;return e&&(t=gaussianWidthToFWHM(2*e)),i*ROOT_PI_OVER_LN2*t/2}function getGaussianFactor(n=.9999){return Math.sqrt(2)*erfinv(n)}function getGaussianData(n={},t={}){let{fwhm:e=500,sd:i}=n;i&&(e=gaussianWidthToFWHM(2*i));let{length:s,factor:a=getGaussianFactor(),height:r=calculateGaussianHeight({fwhm:e})}=t;s||(s=Math.min(Math.ceil(e*a),Math.pow(2,25)-1),s%2==0&&s++);const o=(s-1)/2,l=new Float64Array(s);for(let n=0;n<=o;n++)l[n]=gaussianFct(n-o,e)*r,l[s-1-n]=l[n];return l}class Lorentzian{constructor(n={}){const{fwhm:t=500}=n;this.fwhm=t}fwhmToWidth(n=this.fwhm){return lorentzianFwhmToWidth(n)}widthToFWHM(n){return lorentzianWidthToFWHM(n)}fct(n){return lorentzianFct(n,this.fwhm)}getArea(n=1){return getLorentzianArea({fwhm:this.fwhm,height:n})}getFactor(n){return getLorentzianFactor(n)}getData(n={}){return getLorentzianData(this,n)}calculateHeight(n=1){return calculateLorentzianHeight({fwhm:this.fwhm,area:n})}getParameters(){return["fwhm"]}}const calculateLorentzianHeight=({fwhm:n=1,area:t=1})=>2*t/Math.PI/n,getLorentzianArea=n=>{const{fwhm:t=500,height:e=1}=n;return e*Math.PI*t/2},lorentzianFct=(n,t)=>t**2/(4*n**2+t**2),lorentzianWidthToFWHM=n=>n*ROOT_THREE,lorentzianFwhmToWidth=n=>n/ROOT_THREE,getLorentzianFactor=(n=.9999)=>{if(n>=1)throw new Error("area should be (0 - 1)");const t=.5*(1-n),e=n=>Math.tan(Math.PI*(n-.5));return(e(1-t)-e(t))/2},getLorentzianData=(n={},t={})=>{let{fwhm:e=500}=n,{length:i,factor:s=getLorentzianFactor(),height:a=calculateLorentzianHeight({fwhm:e,area:1})}=t;i||(i=Math.min(Math.ceil(e*s),Math.pow(2,25)-1),i%2==0&&i++);const r=(i-1)/2,o=new Float64Array(i);for(let n=0;n<=r;n++)o[n]=lorentzianFct(n-r,e)*a,o[i-1-n]=o[n];return o};class PseudoVoigt{constructor(n={}){const{fwhm:t=500,mu:e=.5}=n;this.mu=e,this.fwhm=t}fwhmToWidth(n=this.fwhm,t=this.mu){return pseudoVoigtFwhmToWidth(n,t)}widthToFWHM(n,t=this.mu){return pseudoVoigtWidthToFWHM(n,t)}fct(n){return pseudoVoigtFct(n,this.fwhm,this.mu)}getArea(n=1){return getPseudoVoigtArea({fwhm:this.fwhm,height:n,mu:this.mu})}getFactor(n){return getPseudoVoigtFactor(n)}getData(n={}){const{length:t,factor:e,height:i=calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:1})}=n;return getPseudoVoigtData(this,{factor:e,length:t,height:i})}calculateHeight(n=1){return calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:n})}getParameters(){return["fwhm","mu"]}}const calculatePseudoVoigtHeight=(n={})=>{let{fwhm:t=1,mu:e=.5,area:i=1}=n;return 2*i/(t*(e*ROOT_PI_OVER_LN2+(1-e)*Math.PI))},pseudoVoigtFct=(n,t,e)=>(1-e)*lorentzianFct(n,t)+e*gaussianFct(n,t),pseudoVoigtWidthToFWHM=(n,t=.5)=>n*(t*ROOT_2LN2_MINUS_ONE+1),pseudoVoigtFwhmToWidth=(n,t=.5)=>n/(t*ROOT_2LN2_MINUS_ONE+1),getPseudoVoigtArea=n=>{const{fwhm:t=500,height:e=1,mu:i=.5}=n;return t*e*(i*ROOT_PI_OVER_LN2+(1-i)*Math.PI)/2},getPseudoVoigtFactor=(n=.9999,t=.5)=>t<1?getLorentzianFactor(n):getGaussianFactor(n),getPseudoVoigtData=(n={},t={})=>{let{fwhm:e=500,mu:i=.5}=n,{length:s,factor:a=getPseudoVoigtFactor(.999,i),height:r=calculatePseudoVoigtHeight({fwhm:e,mu:i,area:1})}=t;r||(r=1/(i/Math.sqrt(-GAUSSIAN_EXP_FACTOR/Math.PI)*e+(1-i)*e*Math.PI/2)),s||(s=Math.min(Math.ceil(e*a),Math.pow(2,25)-1),s%2==0&&s++);const o=(s-1)/2,l=new Float64Array(s);for(let n=0;n<=o;n++)l[n]=pseudoVoigtFct(n-o,e,i)*r,l[s-1-n]=l[n];return l};class Gaussian2D{constructor(n={}){let{fwhm:t=20,sd:e}=n;t=ensureFWHM2D(t,e),this.fwhmX=t.x,this.fwhmY=t.y}fct(n,t){return gaussian2DFct(n,t,this.fwhmX,this.fwhmY)}getData(n={}){return getGaussian2DData({fwhm:{x:this.fwhmX,y:this.fwhmY}},n)}getFactor(n=1){return getGaussianFactor(n)}getVolume(n=calculateGaussian2DHeight({fwhm:{x:this.fwhmX,y:this.fwhmY},volume:1})){return getGaussian2DVolume({fwhm:{x:this.fwhmX,y:this.fwhmY},height:n})}widthToFWHM(n){return gaussianWidthToFWHM(n)}fwhmToWidth(n){return gaussianFwhmToWidth(n)}calculateHeight(n=1){return calculateGaussian2DHeight({volume:n,fwhm:{x:this.fwhmX,y:this.fwhmY}})}set fwhm(n){n=ensureXYNumber$2(n),this.fwhmX=n.x,this.fwhmY=n.y}}const gaussian2DFct=(n,t,e,i)=>Math.exp(GAUSSIAN_EXP_FACTOR*(Math.pow(n/e,2)+Math.pow(t/i,2))),getGaussian2DData=(n,t={})=>{let{fwhm:e=50,sd:i}=n;e=ensureFWHM2D(e,i);let{factor:s=getGaussianFactor(),length:a={x:0,y:0},height:r=calculateGaussian2DHeight({fwhm:e,volume:1})}=t;s=ensureXYNumber$2(s),a=ensureXYNumber$2(a);for(const n of["x","y"])a[n]||(a[n]=Math.min(Math.ceil(e[n]*s[n]),Math.pow(2,25)-1),a[n]%2==0&&a[n]++);const o=(a.x-1)/2,l=(a.y-1)/2,f=new Array(a.x);for(let n=0;n<a.x;n++)f[n]=new Float64Array(a.y);for(let n=0;n<a.x;n++)for(let t=0;t<a.y;t++)f[n][t]=gaussian2DFct(n-o,t-l,e.x,e.y)*r;return f},calculateGaussian2DHeight=(n={})=>{let{volume:t=1,fwhm:e=50,sd:i}=n;return e=ensureFWHM2D(e,i),t*Math.LN2*4/(Math.PI*e.y*e.x)},getGaussian2DVolume=(n={})=>{let{fwhm:t=50,height:e=1,sd:i}=n;return t=ensureFWHM2D(t,i),e*Math.PI*t.y*t.x/Math.LN2/4};function ensureXYNumber$2(n){return"object"!=typeof n?{x:n,y:n}:{...n}}function ensureFWHM2D(n,t){if(void 0!==t){let n=ensureXYNumber$2(t);return{x:gaussianWidthToFWHM(2*n.x),y:gaussianWidthToFWHM(2*n.y)}}if(void 0!==n)return ensureXYNumber$2(n);throw new Error("ensureFWHM2D must have either fwhm or sd defined")}function getShape1D(n){const{kind:t}=n;switch(t){case"gaussian":return new Gaussian(n);case"lorentzian":return new Lorentzian(n);case"pseudoVoigt":return new PseudoVoigt(n);default:throw Error(`Unknown distribution ${t}`)}}function getShape2D(n){const{kind:t}=n;if("gaussian"===t)return new Gaussian2D(n);throw Error(`Unknown distribution ${t}`)}function addBaseline(n,t){if(!t)return n;let e=n.x,i=n.y;for(let n=0;n<e.length;n++)i[n]+=t(e[n]);return n}function reimAbsolute(n){const t=n.re.length,e=n.re,i=n.im,s=new Float64Array(t);for(let n=0;n<t;n++)s[n]=Math.sqrt(e[n]**2+i[n]**2);return s}var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function getAugmentedNamespace(n){if(n.__esModule)return n;var t=Object.defineProperty({},"__esModule",{value:!0});return Object.keys(n).forEach((function(e){var i=Object.getOwnPropertyDescriptor(n,e);Object.defineProperty(t,e,i.get?i:{enumerable:!0,get:function(){return n[e]}})})),t}var d3Array={exports:{}};!function(n,t){!function(n){function t(n,t){return n<t?-1:n>t?1:n>=t?0:NaN}function e(n){return 1===n.length&&(n=i(n)),{left:function(t,e,i,s){for(null==i&&(i=0),null==s&&(s=t.length);i<s;){var a=i+s>>>1;n(t[a],e)<0?i=a+1:s=a}return i},right:function(t,e,i,s){for(null==i&&(i=0),null==s&&(s=t.length);i<s;){var a=i+s>>>1;n(t[a],e)>0?s=a:i=a+1}return i}}}function i(n){return function(e,i){return t(n(e),i)}}var s=e(t),a=s.right,r=s.left;function o(n,t){return t<n?-1:t>n?1:t>=n?0:NaN}function l(n){return null===n?NaN:+n}function f(n,t){var e,i,s=n.length,a=0,r=0,o=-1,f=0;if(null==t)for(;++o<s;)isNaN(e=l(n[o]))||(r+=(i=e-a)*(e-(a+=i/++f)));else for(;++o<s;)isNaN(e=l(t(n[o],o,n)))||(r+=(i=e-a)*(e-(a+=i/++f)));if(f>1)return r/(f-1)}function g(n,t){var e=f(n,t);return e?Math.sqrt(e):e}function u(n,t){var e,i,s,a=-1,r=n.length;if(null==t){for(;++a<r;)if(null!=(i=n[a])&&i>=i){e=s=i;break}for(;++a<r;)null!=(i=n[a])&&(e>i&&(e=i),s<i&&(s=i))}else{for(;++a<r;)if(null!=(i=t(n[a],a,n))&&i>=i){e=s=i;break}for(;++a<r;)null!=(i=t(n[a],a,n))&&(e>i&&(e=i),s<i&&(s=i))}return[e,s]}function d(n){return function(){return n}}function c(n){return n}function h(n,t,e){n=+n,t=+t,e=(s=arguments.length)<2?(t=n,n=0,1):s<3?1:+e;for(var i=-1,s=0|Math.max(0,Math.ceil((t-n)/e)),a=new Array(s);++i<s;)a[i]=n+i*e;return a}var b=Math.sqrt(50),D=Math.sqrt(10),H=Math.sqrt(2);function j(n,t,e){var i=m(n,t,e);return h(Math.ceil(n/i)*i,Math.floor(t/i)*i+i/2,i)}function m(n,t,e){var i=Math.abs(t-n)/Math.max(0,e),s=Math.pow(10,Math.floor(Math.log(i)/Math.LN10)),a=i/s;return a>=b?s*=10:a>=D?s*=5:a>=H&&(s*=2),t<n?-s:s}function A(n){return Math.ceil(Math.log(n.length)/Math.LN2)+1}function C(n){return+n}function T(){var n=c,t=u,e=A;function i(i){var s,r,o=i.length,l=new Array(o);for(s=0;s<o;++s)l[s]=+n(i[s],s,i);var f=t(l),g=+f[0],u=+f[1],d=e(l,g,u);Array.isArray(d)||(d=j(g,u,+d));var c=d.length;for(s=0;s<c;++s)d[s]=+d[s];for(;d[0]<=g;)d.shift(),--c;for(;d[c-1]>=u;)d.pop(),--c;var h,b=new Array(c+1);for(s=0;s<=c;++s)(h=b[s]=[]).x0=s>0?d[s-1]:g,h.x1=s<c?d[s]:u;for(s=0;s<o;++s)g<=(r=l[s])&&r<=u&&b[a(d,r,0,c)].push(i[s]);return b}return i.value=function(t){return arguments.length?(n="function"==typeof t?t:d(+t),i):n},i.domain=function(n){return arguments.length?(t="function"==typeof n?n:d([+n[0],+n[1]]),i):t},i.thresholds=function(n){return arguments.length?(e="function"==typeof n?n:Array.isArray(n)?d(Array.prototype.map.call(n,C)):d(+n),i):e},i}function p(n,t,e){if(null==e&&(e=l),i=n.length){if((t=+t)<=0||i<2)return+e(n[0],0,n);if(t>=1)return+e(n[i-1],i-1,n);var i,s=(i-1)*t,a=Math.floor(s),r=+e(n[a],a,n);return r+(+e(n[a+1],a+1,n)-r)*(s-a)}}function I(n,e,i){return n.sort(t),Math.ceil((i-e)/(2*(p(n,.75)-p(n,.25))*Math.pow(n.length,-1/3)))}function P(n,t,e){return Math.ceil((e-t)/(3.5*g(n)*Math.pow(n.length,-1/3)))}function M(n,t){var e,i,s=-1,a=n.length;if(null==t){for(;++s<a;)if(null!=(i=n[s])&&i>=i){e=i;break}for(;++s<a;)null!=(i=n[s])&&i>e&&(e=i)}else{for(;++s<a;)if(null!=(i=t(n[s],s,n))&&i>=i){e=i;break}for(;++s<a;)null!=(i=t(n[s],s,n))&&i>e&&(e=i)}return e}function w(n,t){var e,i=0,s=n.length,a=-1,r=s;if(null==t)for(;++a<s;)isNaN(e=l(n[a]))?--r:i+=e;else for(;++a<s;)isNaN(e=l(t(n[a],a,n)))?--r:i+=e;if(r)return i/r}function N(n,e){var i,s=[],a=n.length,r=-1;if(null==e)for(;++r<a;)isNaN(i=l(n[r]))||s.push(i);else for(;++r<a;)isNaN(i=l(e(n[r],r,n)))||s.push(i);return p(s.sort(t),.5)}function L(n){for(var t,e,i,s=n.length,a=-1,r=0;++a<s;)r+=n[a].length;for(e=new Array(r);--s>=0;)for(t=(i=n[s]).length;--t>=0;)e[--r]=i[t];return e}function U(n,t){var e,i,s=-1,a=n.length;if(null==t){for(;++s<a;)if(null!=(i=n[s])&&i>=i){e=i;break}for(;++s<a;)null!=(i=n[s])&&e>i&&(e=i)}else{for(;++s<a;)if(null!=(i=t(n[s],s,n))&&i>=i){e=i;break}for(;++s<a;)null!=(i=t(n[s],s,n))&&e>i&&(e=i)}return e}function k(n){for(var t=0,e=n.length-1,i=n[0],s=new Array(e<0?0:e);t<e;)s[t]=[i,i=n[++t]];return s}function J(n,t){for(var e=t.length,i=new Array(e);e--;)i[e]=n[t[e]];return i}function y(n,e){if(i=n.length){var i,s,a=0,r=0,o=n[r];for(e||(e=t);++a<i;)(e(s=n[a],o)<0||0!==e(o,o))&&(o=s,r=a);return 0===e(o,o)?r:void 0}}function B(n,t,e){for(var i,s,a=(null==e?n.length:e)-(t=null==t?0:+t);a;)s=Math.random()*a--|0,i=n[a+t],n[a+t]=n[s+t],n[s+t]=i;return n}function R(n,t){var e,i=0,s=n.length,a=-1;if(null==t)for(;++a<s;)(e=+n[a])&&(i+=e);else for(;++a<s;)(e=+t(n[a],a,n))&&(i+=e);return i}function E(n){if(!(s=n.length))return[];for(var t=-1,e=U(n,x),i=new Array(e);++t<e;)for(var s,a=-1,r=i[t]=new Array(s);++a<s;)r[a]=n[a][t];return i}function x(n){return n.length}function F(){return E(arguments)}var Q="0.7.1";n.version=Q,n.bisect=a,n.bisectRight=a,n.bisectLeft=r,n.ascending=t,n.bisector=e,n.descending=o,n.deviation=g,n.extent=u,n.histogram=T,n.thresholdFreedmanDiaconis=I,n.thresholdScott=P,n.thresholdSturges=A,n.max=M,n.mean=w,n.median=N,n.merge=L,n.min=U,n.pairs=k,n.permute=J,n.quantile=p,n.range=h,n.scan=y,n.shuffle=B,n.sum=R,n.ticks=j,n.tickStep=m,n.transpose=E,n.variance=f,n.zip=F}(t)}(0,d3Array.exports);const{bisectRight:bisectRight}=d3Array.exports,quincunx=(n,t,e,i)=>{const s=n.length-1;n[0]=0,t[0]=0,e[0]=0,t[1]=t[1]/n[1],e[1]=e[1]/n[1];for(let i=2;i<s;++i)n[i]=n[i]-n[i-2]*e[i-2]*e[i-2]-n[i-1]*t[i-1]*t[i-1],t[i]=(t[i]-n[i-1]*t[i-1]*e[i-1])/n[i],e[i]=e[i]/n[i];for(let n=2;n<s;++n)i[n]=i[n]-t[n-1]*i[n-1]-e[n-2]*i[n-2];for(let t=1;t<s;++t)i[t]=i[t]/n[t];i[s-2]=i[s-2]-t[s-2]*i[s-1];for(let n=s-3;n>0;--n)i[n]=i[n]-t[n]*i[n+1]-e[n]*i[n+2]},smoothingSpline=(n,t,e,i)=>{const s=n.length-1,a=new Array(s+1),r=new Array(s+1),o=new Array(s+1),l=new Array(s+1),f=new Array(s+1),g=new Array(s+1),u=new Array(s+1),d=new Array(s+1),c=n.map((()=>[0,0,0,0]));c.pop();const h=2*(1-i)/(3*i);for(let t=0;t<s;++t)a[t]=n[t+1]-n[t],r[t]=3/a[t];f[0]=0;for(let e=1;e<s;++e)o[e]=-(r[e-1]+r[e]),l[e]=2*(n[e+1]-n[e-1]),f[e]=3*(t[e+1]-t[e])/a[e]-3*(t[e]-t[e-1])/a[e-1];f[s]=0;for(let n=1;n<s;++n)g[n]=r[n-1]*r[n-1]*e[n-1]+o[n]*o[n]*e[n]+r[n]*r[n]*e[n+1],g[n]=h*g[n]+l[n];for(let n=1;n<s-1;++n)u[n]=o[n]*r[n]*e[n]+r[n]*o[n+1]*e[n+1],u[n]=h*u[n]+a[n];for(let n=1;n<s-2;++n)d[n]=h*r[n]*r[n+1]*e[n+1];quincunx(g,u,d,f),c[0][3]=t[0]-h*r[0]*f[1]*e[0],c[1][3]=t[1]-h*(o[1]*f[1]+r[1]*f[2])*e[0],c[0][0]=f[1]/(3*a[0]),c[0][1]=0,c[0][2]=(c[1][3]-c[0][3])/a[0]-f[1]*a[0]/3,r[0]=0;for(let n=1;n<s;++n)c[n][0]=(f[n+1]-f[n])/(3*a[n]),c[n][1]=f[n],c[n][2]=(f[n]+f[n-1])*a[n-1]+c[n-1][2],c[n][3]=r[n-1]*f[n-1]+o[n]*f[n]+r[n]*f[n+1],c[n][3]=t[n]-h*c[n][3]*e[n];return c};class SplineInterpolator{constructor(n,t,e=1){const i=n.map(((n,t)=>t));i.sort(((t,e)=>n[t]-n[e]));const s=i.map((t=>n[t])),a=i.map((n=>t[n])),r=i.length,o=i.map((()=>1));this.n=r,this.x=s,this.y=a,this.params=smoothingSpline(s,a,o,e)}interpolate(n){if(n===this.x[this.n-1])return this.y[this.n-1];const t=Math.min(Math.max(0,bisectRight(this.x,n)-1),this.n-2),[e,i,s,a]=this.params[t];return e*(n-=this.x[t])*n*n+i*n*n+s*n+a}max(n=100){const t=this.x[0],e=(this.x[this.n-1]-t)/n;let i=-1/0;for(let s=0,a=t;s<n;++s,a+=e){const n=this.interpolate(a);n>i&&(i=n)}return i}min(n=100){const t=this.x[0],e=(this.x[this.n-1]-t)/n;let i=1/0;for(let s=0,a=t;s<n;++s,a+=e){const n=this.interpolate(a);n<i&&(i=n)}return i}domain(){return[this.x[0],this.x[this.x.length-1]]}range(){return[this.min(),this.max()]}curve(n,t=null){const e=((t=t||this.domain())[1]-t[0])/(n-1),i=new Array(n);for(let s=0;s<n;++s){const n=e*s+t[0];i[s]=[n,this.interpolate(n)]}return i}}var splineInterpolator=SplineInterpolator,SplineInterpolator$1=splineInterpolator;function createFromToArray(n={}){const{from:t=0,to:e=1,length:i=1e3,includeFrom:s=!0,includeTo:a=!0,distribution:r="uniform"}=n,o=new Float64Array(i);let l=i;s&&a?l=i-1:!s&&a||s&&!a?l=i:s||a||(l=i+1);const f=(e-t)/l;if("uniform"===r)if(s){let n=0;for(;n<i;)o[n]=t+f*n,n++}else{let n=0;for(;n<i;)o[n]=t+f*(n+1),n++}else{if("log"!==r)throw new Error("Please choose for the distribution either uniform or log. By default the distribution chosen is uniform.");{const n=(e/t)**(1/l),a=Math.log(t)/Math.log(n);if(s){let t=0;for(;t<i;)o[t]=n**(a+t),t++}else{let t=0;for(;t<i;)o[t]=n**(a+t+1),t++}}}return o}const Y1=.08913147449493408,P1=[-.005387729650712429,.008226878746769157,.02198786811111689,-.03656379714117627,-.012692614766297404,.03348066254097446,-.008368748197417368,-.0005087819496582806],Q1=[.0008862163904564247,-.0023339375937419,.07952836873415717,-.05273963823400997,-.7122890234154284,.662328840472003,1.5622155839842302,-1.5657455823417585,-.9700050433032906,1],Y2=2.249481201171875,P2=[-3.6719225470772936,21.12946554483405,17.445385985570866,-44.6382324441787,-18.851064805871424,17.644729840837403,8.3705032834312,.10526468069939171,-.20243350835593876],Q2=[1.7211476576120028,-22.643693341313973,10.826866735546016,48.560921310873994,-20.14326346804852,-28.66081804998,3.971343795334387,6.242641248542475,1],Y3=.807220458984375,P3=[-6.81149956853777e-10,2.8522533178221704e-8,-6.794655751811263e-7,.0021455899538880526,.029015791000532906,.14286953440815717,.3377855389120359,.38707973897260434,.11703015634199525,-.16379404719331705,-.1311027816799519],Q3=[.011059242293464892,.15226433829533179,.848854343457902,2.5930192162362027,4.778465929458438,5.381683457070069,3.4662540724256723,1],Y4=.9399557113647461,P4=[26633922742578204e-28,-2.304047769118826e-10,460469890584318e-20,.00015754461742496055,.0018712349281955923,.009508047013259196,.018557330651423107,-.0022242652921344794,-.0350353787183178],Q4=[7646752923027944e-20,.00263861676657016,.03415891436709477,.22009110576413124,.7620591645536234,1.3653349817554064,1],Y5=.9836282730102539,P5=[9905570997331033e-32,-2811287356288318e-29,4.625961635228786e-9,4.4969678992770644e-7,14962478375834237e-21,.00020938631748758808,.001056288621524929,-.0011295143874558028,-.016743100507663373],Q5=[2.82243172016108e-7,27533547476472603e-21,.0009640118070051656,.016074608709367652,.1381518657490833,.5914293448864175,1];function polyval(n,t){let e=0;for(const i of n)e=e*t+i;return e}function calc(n,t,e,i,s){const a=n-t;return s*n+polyval(e,a)/polyval(i,a)*n}function erfcinv(n){let t,e,i,s,a=!1;if(Number.isNaN(n))return Number.NaN;if(n<0||n>2)throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${n}\`.`);return 0===n?Number.POSITIVE_INFINITY:2===n?Number.NEGATIVE_INFINITY:1===n?0:(n>1?(e=2-n,n=1-e,a=!0):(e=n,n=1-n),n<=.5?(i=n*(n+10),s=polyval(P1,n)/polyval(Q1,n),t=i*Y1+i*s,a?-t:t):e>=.25?(i=Math.sqrt(-2*Math.log(e)),e-=.25,s=polyval(P2,e)/polyval(Q2,e),t=i/(Y2+s),a?-t:t):(e=Math.sqrt(-Math.log(e)),e<3?calc(e,1.125,P3,Q3,Y3):e<6?calc(e,3,P4,Q4,Y4):calc(e,6,P5,Q5,Y5)))}function rayleighCdf(n,t=1){return n<0?0:-Math.expm1(-Math.pow(n,2)/(2*Math.pow(t,2)))}function xNoiseSanPlot(n,t={}){const{mask:e,cutOff:i,refine:s=!0,magnitudeMode:a=!1,scaleFactor:r=1,factorStd:o=5,fixOffset:l=!0}=t;let f;if(f=Array.isArray(e)&&e.length===n.length?new Float64Array(n.filter(((n,t)=>!e[t]))):new Float64Array(n),r>1)for(let n=0;n<f.length;n++)f[n]*=r;if(f=f.sort().reverse(),l&&!a){const n=Math.floor(f.length/2),t=.5*(f[n]+f[n+1]);for(let n=0;n<f.length;n++)f[n]-=t}const g=f[f.length-1]>=0?f.length:f.findIndex((n=>n<0));let u=g-1;for(let n=u;n>=0;n--)if(f[n]>0){u=n;break}const d=f.slice(0,u+1),c=f.slice(g),h=i||determineCutOff(d,{magnitudeMode:a});let b=d[Math.floor(d.length*h)];const D=d[0];let H;if(c.length>0){H=-1*c[Math.floor(c.length*(1-h))]}else H=0;let j=b,m=H,A=d.slice(),C=c.slice(),T=0,p=2;if(s){let n=j*o;T=d.findIndex((t=>t<n)),T>-1&&(A=d.slice(T),j=A[Math.floor(A.length*h)]),n=m*o,p=c.findIndex((t=>t<n)),p>-1&&(C=c.slice(p),m=A[Math.floor(C.length*(1-h))])}const I=-simpleNormInv(h/2,{magnitudeMode:a});let P,M;return b/=I,H/=I,s&&T>-1?(P=(h*A.length+T)/(A.length+T),M=-1*simpleNormInv(P/2,{magnitudeMode:a}),j/=M,p>-1&&(P=(h*C.length+p)/(C.length+p),M=-1*simpleNormInv(P/2,{magnitudeMode:a}),0!==m&&(m/=M))):(j/=I,m/=I),{positive:j,negative:m,snr:D/j,sanplot:generateSanPlot(f,{fromTo:{positive:{from:0,to:u},negative:{from:g,to:f.length}}})}}function determineCutOff(n,t={}){const{magnitudeMode:e=!1,considerList:i={from:.5,step:.1,to:.9}}=t,s=[],a=n.length-1;for(let t=.01;t<=.99;t+=.01){const i=-n[Math.round(a*t)]/simpleNormInv([t/2],{magnitudeMode:e});s.push([t,i])}let r=Number.MAX_SAFE_INTEGER;const{from:o,to:l,step:f}=i,g=f/2;let u=.5;for(let n=o;n<=l;n+=f){const t=n-g,e=n+g,i=s.filter((n=>n[0]<e&&n[0]>t)),a=i.reduce(((n,t)=>n+Math.abs(t[1])),0);let o=0;for(const n of i)o+=Math.pow(n[1]-a,2);o<r&&(r=o,u=n)}return u}function simpleNormInv(n,t={}){const{magnitudeMode:e=!1}=t;Array.isArray(n)||(n=[n]);const i=Array.from(createArray(0,2,.01)),s=new Float64Array(n.length),a=new Float64Array(i.length);if(e){const t=1;for(let n=0;n<a.length;n++){const e=i[n]*t;a[n]=1-rayleighCdf(e)}const e=new SplineInterpolator$1(i,a);for(let t=0;t<s.length;t++){const i=2*n[t];s[t]=-1*e.interpolate(i)}}else for(let t=0;t<s.length;t++)s[t]=-1*Math.SQRT2*erfcinv(2*n[t]);return 1===s.length?s[0]:s}function createArray(n,t,e){const i=new Float64Array(Math.abs((n-t)/e+1));for(let t=0;t<i.length;t++)i[t]=n+t*e;return i}function generateSanPlot(n,t={}){const{fromTo:e,logBaseY:i=2}=t,s={};for(const t in e){const{from:a,to:r}=e[t];s[t]=a!==r?scale(n.slice(a,r),{logBaseY:i}):{x:[],y:[]},"negative"===t&&s[t].y.reverse()}return s}function scale(n,t={}){const{log10:e,abs:i}=Math,{logBaseY:s}=t;if(s){n=n.slice();const t=e(s);for(let s=0;s<n.length;s++)n[s]=e(i(n[s]))/t}return{x:createFromToArray({from:0,to:n.length-1,length:n.length}),y:n}}function reimPhaseCorrection(n,t=0,e=0,i={}){const{reverse:s=!1}=i;t=Number.isFinite(t)?t:0,e=Number.isFinite(e)?e:0;const a=n.re,r=n.im,o=n.re.length;let l=t,f=e/o;s&&(f*=-1,l+=e);const g=2*Math.pow(Math.sin(f/2),2),u=Math.sin(f);let d=Math.cos(l),c=Math.sin(l);const h=new Float64Array(o),b=new Float64Array(o);for(let n=0;n<o;n++){h[n]=a[n]*d-r[n]*c,b[n]=r[n]*d+a[n]*c;const t=c-(g*c-u*d);d=d-(g*d+u*c),c=t}return{re:h,im:b}}function reimAutoPhaseCorrection(n,t={}){const{magnitudeMode:e=!0,minRegSize:i=30,factorNoise:s=3,maxDistanceToJoin:a=256,reverse:r=!1}=t,o=detectBaselineRegions(n,{maxDistanceToJoin:a,magnitudeMode:e,factorNoise:s}),{re:l,im:f}=n,g=l.length,u=r?n=>g-1-n:n=>n;let d=0,c=-1;const h=[];for(;c<g;){const n=[],t=[];for(;!o[u(++c)]&&c<g;)d=c;for(;o[u(c)]&&c<g;c+=2)n.push(l[u(c)]),t.push(f[u(c)]);n.length>i&&h.push(autoPhaseRegion(n,t,d))}const{ph1:b,ph0:D}=determiningGlobalValues(h.map((n=>n.x0/g)),h.map((n=>n.ph0)),h.map((n=>n.area/1e11)));return{data:reimPhaseCorrection({re:l,im:f},toRadians(D),toRadians(b),{reverse:r}),ph0:D,ph1:b}}function determiningGlobalValues(n,t,e){const[i,s]=weightedLinearRegression(n,t,e);let a=-1,r=Number.MIN_SAFE_INTEGER;for(let e=0;e<n.length;e++){const o=n[e]*i+s,l=Math.abs(t[e]-o);l>34&&r<l&&(a=e,r=l)}return a>-1?(n.splice(a,1),t.splice(a,1),e.splice(a,1),determiningGlobalValues(n,t,e)):{ph0:s,ph1:i}}function detectBaselineRegions(n,t){const e=t.magnitudeMode?reimAbsolute(n):n.re,i=robustBaseLineRegionsDetection(holoborodko(e),t);return robustBaseLineRegionsDetection(e,t).map(((n,t)=>n&&i[t]))}function autoPhaseRegion(n,t,e){let i=-180,s=180;let a=10,r=0,o=Number.MAX_SAFE_INTEGER;for(;a>0;){const e=(s-i)/7;for(let a=i;a<=s;a+=e){const e=reimPhaseCorrection({re:n,im:t},toRadians(a),0),i=getNegArea(e.re);i<o&&([o,r]=[i,a])}i=r-e,s=r+e,a--}const l=reimPhaseCorrection({re:n,im:t},toRadians(r),0);let f=0,g=0;for(let t=0;t<n.length;t++)f+=l.re[t],g+=l.re[t]*(t+e);return{ph0:r,area:f,x0:g/f}}function holoborodko(n){const t=new Float64Array(n.length);for(let e=5;e<n.length-5;e++)t[e]=(42*(n[e+1]-n[e-1])+48*(n[e+2]-n[e-2])+27*(n[e+3]+n[e-3])+8*(n[e+4]-n[e-4])+n[e+5]-n[e-5])/512;for(let e=0;e<5;e++)t[e]=t[5],t[n.length-e-1]=t[n.length-6];return t}function robustBaseLineRegionsDetection(n,t){const{maxDistanceToJoin:e,magnitudeMode:i,factorNoise:s}=t,a=new Uint8Array(n.length);for(let t=0;t<n.length;t++)a[t]=0;let r=!0;for(;r;){const t=s*xNoiseSanPlot(n,{magnitudeMode:i}).positive;r=!1;for(let e=0;e<n.length;e++)Math.abs(n[e])>t&&!a[e]&&(r=!0,a[e]=1)}let o=0,l=0;for(let t=0;t<n.length;t++)if(a[t]){if(o<e)for(let n=0;n<=o;n++)a[l+n]=1;for(;a[++t]&&t<n.length;);l=t,o=0}else o++;return a}function weightedLinearRegression(n,t,e){let i=0,s=0,a=0,r=0,o=0;for(let l=0;l<n.length;l++)i+=n[l]*n[l]*e[l],s+=n[l]*e[l],a+=e[l],r+=n[l]*e[l]*t[l],o+=e[l]*t[l];const l=i*a-s*s,f=[[a/l,-s/l],[-s/l,i/l]];return[f[0][0]*r+f[0][1]*o,f[1][0]*r+f[1][1]*o]}const toRadians=n=>n*Math.PI/180,getNegArea=n=>{let t=0;for(const e of n)e<0&&(t-=e);return t};function FFT$1(n){if(this.size=0|n,this.size<=1||0!=(this.size&this.size-1))throw new Error("FFT size must be a power of two and bigger than 1");this._csize=n<<1;for(var t=new Array(2*this.size),e=0;e<t.length;e+=2){const n=Math.PI*e/this.size;t[e]=Math.cos(n),t[e+1]=-Math.sin(n)}this.table=t;for(var i=0,s=1;this.size>s;s<<=1)i++;this._width=i%2==0?i-1:i,this._bitrev=new Array(1<<this._width);for(var a=0;a<this._bitrev.length;a++){this._bitrev[a]=0;for(var r=0;r<this._width;r+=2){var o=this._width-r-2;this._bitrev[a]|=(a>>>r&3)<<o}}this._out=null,this._data=null,this._inv=0}var fft$1=FFT$1;FFT$1.prototype.fromComplexArray=function(n,t){for(var e=t||new Array(n.length>>>1),i=0;i<n.length;i+=2)e[i>>>1]=n[i];return e},FFT$1.prototype.createComplexArray=function(){const n=new Array(this._csize);for(var t=0;t<n.length;t++)n[t]=0;return n},FFT$1.prototype.toComplexArray=function(n,t){for(var e=t||this.createComplexArray(),i=0;i<e.length;i+=2)e[i]=n[i>>>1],e[i+1]=0;return e},FFT$1.prototype.completeSpectrum=function(n){for(var t=this._csize,e=t>>>1,i=2;i<e;i+=2)n[t-i]=n[i],n[t-i+1]=-n[i+1]},FFT$1.prototype.transform=function(n,t){if(n===t)throw new Error("Input and output buffers must be different");this._out=n,this._data=t,this._inv=0,this._transform4(),this._out=null,this._data=null},FFT$1.prototype.realTransform=function(n,t){if(n===t)throw new Error("Input and output buffers must be different");this._out=n,this._data=t,this._inv=0,this._realTransform4(),this._out=null,this._data=null},FFT$1.prototype.inverseTransform=function(n,t){if(n===t)throw new Error("Input and output buffers must be different");this._out=n,this._data=t,this._inv=1,this._transform4();for(var e=0;e<n.length;e++)n[e]/=this.size;this._out=null,this._data=null},FFT$1.prototype._transform4=function(){var n,t,e=this._out,i=this._csize,s=1<<this._width,a=i/s<<1,r=this._bitrev;if(4===a)for(n=0,t=0;n<i;n+=a,t++){const e=r[t];this._singleTransform2(n,e,s)}else for(n=0,t=0;n<i;n+=a,t++){const e=r[t];this._singleTransform4(n,e,s)}var o=this._inv?-1:1,l=this.table;for(s>>=2;s>=2;s>>=2){var f=(a=i/s<<1)>>>2;for(n=0;n<i;n+=a)for(var g=n+f,u=n,d=0;u<g;u+=2,d+=s){const n=u,t=n+f,i=t+f,s=i+f,a=e[n],r=e[n+1],g=e[t],c=e[t+1],h=e[i],b=e[i+1],D=e[s],H=e[s+1],j=a,m=r,A=l[d],C=o*l[d+1],T=g*A-c*C,p=g*C+c*A,I=l[2*d],P=o*l[2*d+1],M=h*I-b*P,w=h*P+b*I,N=l[3*d],L=o*l[3*d+1],U=D*N-H*L,k=D*L+H*N,J=j+M,y=m+w,B=j-M,R=m-w,E=T+U,x=p+k,F=o*(T-U),Q=o*(p-k),S=J+E,X=y+x,z=J-E,G=y-x,q=B+Q,Y=R-F,v=B-Q,Z=R+F;e[n]=S,e[n+1]=X,e[t]=q,e[t+1]=Y,e[i]=z,e[i+1]=G,e[s]=v,e[s+1]=Z}}},FFT$1.prototype._singleTransform2=function(n,t,e){const i=this._out,s=this._data,a=s[t],r=s[t+1],o=s[t+e],l=s[t+e+1],f=a+o,g=r+l,u=a-o,d=r-l;i[n]=f,i[n+1]=g,i[n+2]=u,i[n+3]=d},FFT$1.prototype._singleTransform4=function(n,t,e){const i=this._out,s=this._data,a=this._inv?-1:1,r=2*e,o=3*e,l=s[t],f=s[t+1],g=s[t+e],u=s[t+e+1],d=s[t+r],c=s[t+r+1],h=s[t+o],b=s[t+o+1],D=l+d,H=f+c,j=l-d,m=f-c,A=g+h,C=u+b,T=a*(g-h),p=a*(u-b),I=D+A,P=H+C,M=j+p,w=m-T,N=D-A,L=H-C,U=j-p,k=m+T;i[n]=I,i[n+1]=P,i[n+2]=M,i[n+3]=w,i[n+4]=N,i[n+5]=L,i[n+6]=U,i[n+7]=k},FFT$1.prototype._realTransform4=function(){var n,t,e=this._out,i=this._csize,s=1<<this._width,a=i/s<<1,r=this._bitrev;if(4===a)for(n=0,t=0;n<i;n+=a,t++){const e=r[t];this._singleRealTransform2(n,e>>>1,s>>>1)}else for(n=0,t=0;n<i;n+=a,t++){const e=r[t];this._singleRealTransform4(n,e>>>1,s>>>1)}var o=this._inv?-1:1,l=this.table;for(s>>=2;s>=2;s>>=2){var f=(a=i/s<<1)>>>1,g=f>>>1,u=g>>>1;for(n=0;n<i;n+=a)for(var d=0,c=0;d<=u;d+=2,c+=s){var h=n+d,b=h+g,D=b+g,H=D+g,j=e[h],m=e[h+1],A=e[b],C=e[b+1],T=e[D],p=e[D+1],I=e[H],P=e[H+1],M=j,w=m,N=l[c],L=o*l[c+1],U=A*N-C*L,k=A*L+C*N,J=l[2*c],y=o*l[2*c+1],B=T*J-p*y,R=T*y+p*J,E=l[3*c],x=o*l[3*c+1],F=I*E-P*x,Q=I*x+P*E,S=M+B,X=w+R,z=M-B,G=w-R,q=U+F,Y=k+Q,v=o*(U-F),Z=o*(k-Q),O=S+q,V=X+Y,K=z+Z,W=G-v;if(e[h]=O,e[h+1]=V,e[b]=K,e[b+1]=W,0!==d){if(d!==u){var _=z+-o*Z,$=-G+-o*v,nn=S+-o*q,tn=-X- -o*Y,en=n+g-d,sn=n+f-d;e[en]=_,e[en+1]=$,e[sn]=nn,e[sn+1]=tn}}else{var an=S-q,rn=X-Y;e[D]=an,e[D+1]=rn}}}},FFT$1.prototype._singleRealTransform2=function(n,t,e){const i=this._out,s=this._data,a=s[t],r=s[t+e],o=a+r,l=a-r;i[n]=o,i[n+1]=0,i[n+2]=l,i[n+3]=0},FFT$1.prototype._singleRealTransform4=function(n,t,e){const i=this._out,s=this._data,a=this._inv?-1:1,r=2*e,o=3*e,l=s[t],f=s[t+e],g=s[t+r],u=s[t+o],d=l+g,c=l-g,h=f+u,b=a*(f-u),D=d+h,H=c,j=-b,m=d-h,A=c,C=b;i[n]=D,i[n+1]=0,i[n+2]=H,i[n+3]=j,i[n+4]=m,i[n+5]=0,i[n+6]=A,i[n+7]=C};var FFT$2=fft$1;function xRotate(n,t){(t%=n.length)<0&&(t+=n.length);const e=new Float64Array(n.length);return e.set(n.slice(n.length-t)),e.set(n.slice(0,n.length-t),t),e}function reimFFT(n,t={}){const{inverse:e=!1,applyZeroShift:i=!1}=t,{re:s,im:a}=n,r=s.length,o=r<<1;let l=new Float64Array(o);for(let n=0;n<o;n+=2)l[n]=s[n>>>1],l[n+1]=a[n>>>1];const f=new FFT$2(r);let g=new Float64Array(o);e?(i&&(l=zeroShift(l,!0)),f.inverseTransform(g,l)):(f.transform(g,l),i&&(g=zeroShift(g)));const u=new Float64Array(r),d=new Float64Array(r);for(let n=0;n<o;n+=2)u[n>>>1]=g[n],d[n>>>1]=g[n+1];return{re:u,im:d}}const zeroShift=(n,t)=>xRotate(n,t?Math.ceil(n.length/2):Math.floor(n.length/2));function xAbsolute(n){const t=n.slice();for(let n=0;n<t.length;n++)t[n]<0&&(t[n]*=-1);return t}const toString$2=Object.prototype.toString;function isAnyArray$1(n){const t=toString$2.call(n);return t.endsWith("Array]")&&!t.includes("Big")}var libEsm=Object.freeze({__proto__:null,isAnyArray:isAnyArray$1});function xMedian(n){if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");const t=n.slice();let e=0,i=t.length-1,s=0,a=0,r=0;const o=calcMiddle(e,i);for(;;){if(i<=e)return t[o];if(i===e+1)return t[e]>t[i]&&swap(t,e,i),t[o];for(s=calcMiddle(e,i),t[s]>t[i]&&swap(t,s,i),t[e]>t[i]&&swap(t,e,i),t[s]>t[e]&&swap(t,s,e),swap(t,s,e+1),a=e+1,r=i;;){do{a++}while(t[e]>t[a]);do{r--}while(t[r]>t[e]);if(r<a)break;swap(t,a,r)}swap(t,e,r),r<=o&&(e=a),r>=o&&(i=r-1)}}function swap(n,t,e){const i=n[e];n[e]=n[t],n[t]=i}function calcMiddle(n,t){return Math.floor((n+t)/2)}function xAbsoluteMedian(n){return xMedian(xAbsolute(n))}function xAdd(n,t){let e=!1,i=0;if(isAnyArray$1(t)){if(n.length!==t.length)throw new Error("xAdd: size of array1 and array2 must be identical")}else e=!0,i=t;const s=new Float64Array(n.length);if(e)for(let t=0;t<n.length;t++)s[t]=n[t]+i;else for(let e=0;e<n.length;e++)s[e]=n[e]+t[e];return s}function xApplyFunctionStr(n,t={}){const{variableLabel:e="x",fctString:i=e}=t,s=new Function(e,`return Number(${i.replace(/(?<before>^|\W)(?<after>[\da-z]{2,}\()/g,"$<before>Math.$<after>").replace(/Math\.Math/g,"Math")})`),a=Float64Array.from(n);for(let t=0;t<n.length;t++)if(a[t]=s(n[t]),Number.isNaN(a[t]))throw new Error(`The callback ${i} does not return a number: ${n[t]}`);return a}function getOutputArray(n,t){if(void 0!==n){if(!isAnyArray$1(n))throw new TypeError("output option must be an array if specified");if(n.length!==t)throw new TypeError("the output array does not have the correct length");return n}return new Float64Array(t)}function xMultiply(n,t,e={}){let i=!1,s=0;if(isAnyArray$1(t)){if(n.length!==t.length)throw new Error("xMultiply: size of array1 and array2 must be identical")}else i=!0,s=Number(t);const a=getOutputArray(e.output,n.length);if(i)for(let t=0;t<n.length;t++)a[t]=n[t]*s;else for(let e=0;e<n.length;e++)a[e]=n[e]*t[e];return a}function xCheck(n,t={}){const{minLength:e}=t;if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");if(e&&n.length<e)throw new Error(`input must have a length of at least ${e}`)}var matrix={},require$$0=getAugmentedNamespace(libEsm);function max(n){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");var e=t.fromIndex,i=void 0===e?0:e,s=t.toIndex,a=void 0===s?n.length:s;if(i<0||i>=n.length||!Number.isInteger(i))throw new Error("fromIndex must be a positive integer smaller than length");if(a<=i||a>n.length||!Number.isInteger(a))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var r=n[i],o=i+1;o<a;o++)n[o]>r&&(r=n[o]);return r}function min(n){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");var e=t.fromIndex,i=void 0===e?0:e,s=t.toIndex,a=void 0===s?n.length:s;if(i<0||i>=n.length||!Number.isInteger(i))throw new Error("fromIndex must be a positive integer smaller than length");if(a<=i||a>n.length||!Number.isInteger(a))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var r=n[i],o=i+1;o<a;o++)n[o]<r&&(r=n[o]);return r}function rescale$2(n){var t,e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");if(void 0!==e.output){if(!isAnyArray$1(e.output))throw new TypeError("output option must be an array if specified");t=e.output}else t=new Array(n.length);var i=min(n),s=max(n);if(i===s)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var a=e.min,r=void 0===a?e.autoMinMax?i:0:a,o=e.max,l=void 0===o?e.autoMinMax?s:1:o;if(r>=l)throw new RangeError("min option must be smaller than max option");for(var f=(l-r)/(s-i),g=0;g<n.length;g++)t[g]=(n[g]-i)*f+r;return t}var libEs6=Object.freeze({__proto__:null,default:rescale$2}),require$$1=getAugmentedNamespace(libEs6);Object.defineProperty(matrix,"__esModule",{value:!0});var isAnyArray=require$$0,rescale$1=require$$1;const indent=" ".repeat(2),indentData=" ".repeat(4);function inspectMatrix(){return inspectMatrixWithOptions(this)}function inspectMatrixWithOptions(n,t={}){const{maxRows:e=15,maxColumns:i=10,maxNumSize:s=8,padMinus:a="auto"}=t;return`${n.constructor.name} {\n${indent}[\n${indentData}${inspectData(n,e,i,s,a)}\n${indent}]\n${indent}rows: ${n.rows}\n${indent}columns: ${n.columns}\n}`}function inspectData(n,t,e,i,s){const{rows:a,columns:r}=n,o=Math.min(a,t),l=Math.min(r,e),f=[];if("auto"===s){s=!1;n:for(let t=0;t<o;t++)for(let e=0;e<l;e++)if(n.get(t,e)<0){s=!0;break n}}for(let t=0;t<o;t++){let e=[];for(let a=0;a<l;a++)e.push(formatNumber(n.get(t,a),i,s));f.push(`${e.join(" ")}`)}return l!==r&&(f[f.length-1]+=` ... ${r-e} more columns`),o!==a&&f.push(`... ${a-t} more rows`),f.join(`\n${indentData}`)}function formatNumber(n,t,e){return(n>=0&&e?` ${formatNumber2(n,t-1)}`:formatNumber2(n,t)).padEnd(t)}function formatNumber2(n,t){let e=n.toString();if(e.length<=t)return e;let i=n.toFixed(t);if(i.length>t&&(i=n.toFixed(Math.max(0,t-(i.length-t)))),i.length<=t&&!i.startsWith("0.000")&&!i.startsWith("-0.000"))return i;let s=n.toExponential(t);return s.length>t&&(s=n.toExponential(Math.max(0,t-(s.length-t)))),s.slice(0)}function installMathOperations(n,t){n.prototype.add=function(n){return"number"==typeof n?this.addS(n):this.addM(n)},n.prototype.addS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n);return this},n.prototype.addM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n.get(t,e));return this},n.add=function(n,e){return new t(n).add(e)},n.prototype.sub=function(n){return"number"==typeof n?this.subS(n):this.subM(n)},n.prototype.subS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n);return this},n.prototype.subM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n.get(t,e));return this},n.sub=function(n,e){return new t(n).sub(e)},n.prototype.subtract=n.prototype.sub,n.prototype.subtractS=n.prototype.subS,n.prototype.subtractM=n.prototype.subM,n.subtract=n.sub,n.prototype.mul=function(n){return"number"==typeof n?this.mulS(n):this.mulM(n)},n.prototype.mulS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n);return this},n.prototype.mulM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n.get(t,e));return this},n.mul=function(n,e){return new t(n).mul(e)},n.prototype.multiply=n.prototype.mul,n.prototype.multiplyS=n.prototype.mulS,n.prototype.multiplyM=n.prototype.mulM,n.multiply=n.mul,n.prototype.div=function(n){return"number"==typeof n?this.divS(n):this.divM(n)},n.prototype.divS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n);return this},n.prototype.divM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n.get(t,e));return this},n.div=function(n,e){return new t(n).div(e)},n.prototype.divide=n.prototype.div,n.prototype.divideS=n.prototype.divS,n.prototype.divideM=n.prototype.divM,n.divide=n.div,n.prototype.mod=function(n){return"number"==typeof n?this.modS(n):this.modM(n)},n.prototype.modS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)%n);return this},n.prototype.modM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)%n.get(t,e));return this},n.mod=function(n,e){return new t(n).mod(e)},n.prototype.modulus=n.prototype.mod,n.prototype.modulusS=n.prototype.modS,n.prototype.modulusM=n.prototype.modM,n.modulus=n.mod,n.prototype.and=function(n){return"number"==typeof n?this.andS(n):this.andM(n)},n.prototype.andS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)&n);return this},n.prototype.andM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)&n.get(t,e));return this},n.and=function(n,e){return new t(n).and(e)},n.prototype.or=function(n){return"number"==typeof n?this.orS(n):this.orM(n)},n.prototype.orS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)|n);return this},n.prototype.orM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)|n.get(t,e));return this},n.or=function(n,e){return new t(n).or(e)},n.prototype.xor=function(n){return"number"==typeof n?this.xorS(n):this.xorM(n)},n.prototype.xorS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)^n);return this},n.prototype.xorM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)^n.get(t,e));return this},n.xor=function(n,e){return new t(n).xor(e)},n.prototype.leftShift=function(n){return"number"==typeof n?this.leftShiftS(n):this.leftShiftM(n)},n.prototype.leftShiftS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)<<n);return this},n.prototype.leftShiftM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)<<n.get(t,e));return this},n.leftShift=function(n,e){return new t(n).leftShift(e)},n.prototype.signPropagatingRightShift=function(n){return"number"==typeof n?this.signPropagatingRightShiftS(n):this.signPropagatingRightShiftM(n)},n.prototype.signPropagatingRightShiftS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>n);return this},n.prototype.signPropagatingRightShiftM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>n.get(t,e));return this},n.signPropagatingRightShift=function(n,e){return new t(n).signPropagatingRightShift(e)},n.prototype.rightShift=function(n){return"number"==typeof n?this.rightShiftS(n):this.rightShiftM(n)},n.prototype.rightShiftS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>>n);return this},n.prototype.rightShiftM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>>n.get(t,e));return this},n.rightShift=function(n,e){return new t(n).rightShift(e)},n.prototype.zeroFillRightShift=n.prototype.rightShift,n.prototype.zeroFillRightShiftS=n.prototype.rightShiftS,n.prototype.zeroFillRightShiftM=n.prototype.rightShiftM,n.zeroFillRightShift=n.rightShift,n.prototype.not=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,~this.get(n,t));return this},n.not=function(n){return new t(n).not()},n.prototype.abs=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.abs(this.get(n,t)));return this},n.abs=function(n){return new t(n).abs()},n.prototype.acos=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.acos(this.get(n,t)));return this},n.acos=function(n){return new t(n).acos()},n.prototype.acosh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.acosh(this.get(n,t)));return this},n.acosh=function(n){return new t(n).acosh()},n.prototype.asin=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.asin(this.get(n,t)));return this},n.asin=function(n){return new t(n).asin()},n.prototype.asinh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.asinh(this.get(n,t)));return this},n.asinh=function(n){return new t(n).asinh()},n.prototype.atan=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.atan(this.get(n,t)));return this},n.atan=function(n){return new t(n).atan()},n.prototype.atanh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.atanh(this.get(n,t)));return this},n.atanh=function(n){return new t(n).atanh()},n.prototype.cbrt=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.cbrt(this.get(n,t)));return this},n.cbrt=function(n){return new t(n).cbrt()},n.prototype.ceil=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.ceil(this.get(n,t)));return this},n.ceil=function(n){return new t(n).ceil()},n.prototype.clz32=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.clz32(this.get(n,t)));return this},n.clz32=function(n){return new t(n).clz32()},n.prototype.cos=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.cos(this.get(n,t)));return this},n.cos=function(n){return new t(n).cos()},n.prototype.cosh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.cosh(this.get(n,t)));return this},n.cosh=function(n){return new t(n).cosh()},n.prototype.exp=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.exp(this.get(n,t)));return this},n.exp=function(n){return new t(n).exp()},n.prototype.expm1=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.expm1(this.get(n,t)));return this},n.expm1=function(n){return new t(n).expm1()},n.prototype.floor=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.floor(this.get(n,t)));return this},n.floor=function(n){return new t(n).floor()},n.prototype.fround=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.fround(this.get(n,t)));return this},n.fround=function(n){return new t(n).fround()},n.prototype.log=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log(this.get(n,t)));return this},n.log=function(n){return new t(n).log()},n.prototype.log1p=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log1p(this.get(n,t)));return this},n.log1p=function(n){return new t(n).log1p()},n.prototype.log10=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log10(this.get(n,t)));return this},n.log10=function(n){return new t(n).log10()},n.prototype.log2=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log2(this.get(n,t)));return this},n.log2=function(n){return new t(n).log2()},n.prototype.round=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.round(this.get(n,t)));return this},n.round=function(n){return new t(n).round()},n.prototype.sign=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sign(this.get(n,t)));return this},n.sign=function(n){return new t(n).sign()},n.prototype.sin=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sin(this.get(n,t)));return this},n.sin=function(n){return new t(n).sin()},n.prototype.sinh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sinh(this.get(n,t)));return this},n.sinh=function(n){return new t(n).sinh()},n.prototype.sqrt=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sqrt(this.get(n,t)));return this},n.sqrt=function(n){return new t(n).sqrt()},n.prototype.tan=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.tan(this.get(n,t)));return this},n.tan=function(n){return new t(n).tan()},n.prototype.tanh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.tanh(this.get(n,t)));return this},n.tanh=function(n){return new t(n).tanh()},n.prototype.trunc=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.trunc(this.get(n,t)));return this},n.trunc=function(n){return new t(n).trunc()},n.pow=function(n,e){return new t(n).pow(e)},n.prototype.pow=function(n){return"number"==typeof n?this.powS(n):this.powM(n)},n.prototype.powS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.pow(this.get(t,e),n));return this},n.prototype.powM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.pow(this.get(t,e),n.get(t,e)));return this}}function checkRowIndex(n,t,e){let i=e?n.rows:n.rows-1;if(t<0||t>i)throw new RangeError("Row index out of range")}function checkColumnIndex(n,t,e){let i=e?n.columns:n.columns-1;if(t<0||t>i)throw new RangeError("Column index out of range")}function checkRowVector(n,t){if(t.to1DArray&&(t=t.to1DArray()),t.length!==n.columns)throw new RangeError("vector size must be the same as the number of columns");return t}function checkColumnVector(n,t){if(t.to1DArray&&(t=t.to1DArray()),t.length!==n.rows)throw new RangeError("vector size must be the same as the number of rows");return t}function checkRowIndices(n,t){if(!isAnyArray.isAnyArray(t))throw new TypeError("row indices must be an array");for(let e=0;e<t.length;e++)if(t[e]<0||t[e]>=n.rows)throw new RangeError("row indices are out of range")}function checkColumnIndices(n,t){if(!isAnyArray.isAnyArray(t))throw new TypeError("column indices must be an array");for(let e=0;e<t.length;e++)if(t[e]<0||t[e]>=n.columns)throw new RangeError("column indices are out of range")}function checkRange$1(n,t,e,i,s){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(checkNumber("startRow",t),checkNumber("endRow",e),checkNumber("startColumn",i),checkNumber("endColumn",s),t>e||i>s||t<0||t>=n.rows||e<0||e>=n.rows||i<0||i>=n.columns||s<0||s>=n.columns)throw new RangeError("Submatrix indices are out of range")}function newArray$1(n,t=0){let e=[];for(let i=0;i<n;i++)e.push(t);return e}function checkNumber(n,t){if("number"!=typeof t)throw new TypeError(`${n} must be a number`)}function checkNonEmpty(n){if(n.isEmpty())throw new Error("Empty matrix has no elements to index")}function sumByRow(n){let t=newArray$1(n.rows);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[e]+=n.get(e,i);return t}function sumByColumn(n){let t=newArray$1(n.columns);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[i]+=n.get(e,i);return t}function sumAll(n){let t=0;for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)t+=n.get(e,i);return t}function productByRow(n){let t=newArray$1(n.rows,1);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[e]*=n.get(e,i);return t}function productByColumn(n){let t=newArray$1(n.columns,1);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[i]*=n.get(e,i);return t}function productAll(n){let t=1;for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)t*=n.get(e,i);return t}function varianceByRow(n,t,e){const i=n.rows,s=n.columns,a=[];for(let r=0;r<i;r++){let i=0,o=0,l=0;for(let t=0;t<s;t++)l=n.get(r,t)-e[r],i+=l,o+=l*l;t?a.push((o-i*i/s)/(s-1)):a.push((o-i*i/s)/s)}return a}function varianceByColumn(n,t,e){const i=n.rows,s=n.columns,a=[];for(let r=0;r<s;r++){let s=0,o=0,l=0;for(let t=0;t<i;t++)l=n.get(t,r)-e[r],s+=l,o+=l*l;t?a.push((o-s*s/i)/(i-1)):a.push((o-s*s/i)/i)}return a}function varianceAll(n,t,e){const i=n.rows,s=n.columns,a=i*s;let r=0,o=0,l=0;for(let t=0;t<i;t++)for(let i=0;i<s;i++)l=n.get(t,i)-e,r+=l,o+=l*l;return t?(o-r*r/a)/(a-1):(o-r*r/a)/a}function centerByRow(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)-t[e])}function centerByColumn(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)-t[i])}function centerAll(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)-t)}function getScaleByRow(n){const t=[];for(let e=0;e<n.rows;e++){let i=0;for(let t=0;t<n.columns;t++)i+=Math.pow(n.get(e,t),2)/(n.columns-1);t.push(Math.sqrt(i))}return t}function scaleByRow(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)/t[e])}function getScaleByColumn(n){const t=[];for(let e=0;e<n.columns;e++){let i=0;for(let t=0;t<n.rows;t++)i+=Math.pow(n.get(t,e),2)/(n.rows-1);t.push(Math.sqrt(i))}return t}function scaleByColumn(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)/t[i])}function getScaleAll(n){const t=n.size-1;let e=0;for(let i=0;i<n.columns;i++)for(let s=0;s<n.rows;s++)e+=Math.pow(n.get(s,i),2)/t;return Math.sqrt(e)}function scaleAll(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)/t)}class AbstractMatrix{static from1DArray(n,t,e){if(n*t!==e.length)throw new RangeError("data length does not match given dimensions");let i=new Matrix$2(n,t);for(let s=0;s<n;s++)for(let n=0;n<t;n++)i.set(s,n,e[s*t+n]);return i}static rowVector(n){let t=new Matrix$2(1,n.length);for(let e=0;e<n.length;e++)t.set(0,e,n[e]);return t}static columnVector(n){let t=new Matrix$2(n.length,1);for(let e=0;e<n.length;e++)t.set(e,0,n[e]);return t}static zeros(n,t){return new Matrix$2(n,t)}static ones(n,t){return new Matrix$2(n,t).fill(1)}static rand(n,t,e={}){if("object"!=typeof e)throw new TypeError("options must be an object");const{random:i=Math.random}=e;let s=new Matrix$2(n,t);for(let e=0;e<n;e++)for(let n=0;n<t;n++)s.set(e,n,i());return s}static randInt(n,t,e={}){if("object"!=typeof e)throw new TypeError("options must be an object");const{min:i=0,max:s=1e3,random:a=Math.random}=e;if(!Number.isInteger(i))throw new TypeError("min must be an integer");if(!Number.isInteger(s))throw new TypeError("max must be an integer");if(i>=s)throw new RangeError("min must be smaller than max");let r=s-i,o=new Matrix$2(n,t);for(let e=0;e<n;e++)for(let n=0;n<t;n++){let t=i+Math.round(a()*r);o.set(e,n,t)}return o}static eye(n,t,e){void 0===t&&(t=n),void 0===e&&(e=1);let i=Math.min(n,t),s=this.zeros(n,t);for(let n=0;n<i;n++)s.set(n,n,e);return s}static diag(n,t,e){let i=n.length;void 0===t&&(t=i),void 0===e&&(e=t);let s=Math.min(i,t,e),a=this.zeros(t,e);for(let t=0;t<s;t++)a.set(t,t,n[t]);return a}static min(n,t){n=this.checkMatrix(n),t=this.checkMatrix(t);let e=n.rows,i=n.columns,s=new Matrix$2(e,i);for(let a=0;a<e;a++)for(let e=0;e<i;e++)s.set(a,e,Math.min(n.get(a,e),t.get(a,e)));return s}static max(n,t){n=this.checkMatrix(n),t=this.checkMatrix(t);let e=n.rows,i=n.columns,s=new this(e,i);for(let a=0;a<e;a++)for(let e=0;e<i;e++)s.set(a,e,Math.max(n.get(a,e),t.get(a,e)));return s}static checkMatrix(n){return AbstractMatrix.isMatrix(n)?n:new Matrix$2(n)}static isMatrix(n){return null!=n&&"Matrix"===n.klass}get size(){return this.rows*this.columns}apply(n){if("function"!=typeof n)throw new TypeError("callback must be a function");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n.call(this,t,e);return this}to1DArray(){let n=[];for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n.push(this.get(t,e));return n}to2DArray(){let n=[];for(let t=0;t<this.rows;t++){n.push([]);for(let e=0;e<this.columns;e++)n[t].push(this.get(t,e))}return n}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let n=0;n<this.rows;n++)for(let t=0;t<=n;t++)if(this.get(n,t)!==this.get(t,n))return!1;return!0}return!1}isDistance(){if(!this.isSymmetric())return!1;for(let n=0;n<this.rows;n++)if(0!==this.get(n,n))return!1;return!0}isEchelonForm(){let n=0,t=0,e=-1,i=!0,s=!1;for(;n<this.rows&&i;){for(t=0,s=!1;t<this.columns&&!1===s;)0===this.get(n,t)?t++:1===this.get(n,t)&&t>e?(s=!0,e=t):(i=!1,s=!0);n++}return i}isReducedEchelonForm(){let n=0,t=0,e=-1,i=!0,s=!1;for(;n<this.rows&&i;){for(t=0,s=!1;t<this.columns&&!1===s;)0===this.get(n,t)?t++:1===this.get(n,t)&&t>e?(s=!0,e=t):(i=!1,s=!0);for(let e=t+1;e<this.rows;e++)0!==this.get(n,e)&&(i=!1);n++}return i}echelonForm(){let n=this.clone(),t=0,e=0;for(;t<n.rows&&e<n.columns;){let i=t;for(let s=t;s<n.rows;s++)n.get(s,e)>n.get(i,e)&&(i=s);if(0===n.get(i,e))e++;else{n.swapRows(t,i);let s=n.get(t,e);for(let i=e;i<n.columns;i++)n.set(t,i,n.get(t,i)/s);for(let i=t+1;i<n.rows;i++){let s=n.get(i,e)/n.get(t,e);n.set(i,e,0);for(let a=e+1;a<n.columns;a++)n.set(i,a,n.get(i,a)-n.get(t,a)*s)}t++,e++}}return n}reducedEchelonForm(){let n=this.echelonForm(),t=n.columns,e=n.rows,i=e-1;for(;i>=0;)if(0===n.maxRow(i))i--;else{let s=0,a=!1;for(;s<e&&!1===a;)1===n.get(i,s)?a=!0:s++;for(let e=0;e<i;e++){let a=n.get(e,s);for(let r=s;r<t;r++){let t=n.get(e,r)-a*n.get(i,r);n.set(e,r,t)}}i--}return n}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(n={}){if("object"!=typeof n)throw new TypeError("options must be an object");const{rows:t=1,columns:e=1}=n;if(!Number.isInteger(t)||t<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(e)||e<=0)throw new TypeError("columns must be a positive integer");let i=new Matrix$2(this.rows*t,this.columns*e);for(let n=0;n<t;n++)for(let t=0;t<e;t++)i.setSubMatrix(this,this.rows*n,this.columns*t);return i}fill(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,n);return this}neg(){return this.mulS(-1)}getRow(n){checkRowIndex(this,n);let t=[];for(let e=0;e<this.columns;e++)t.push(this.get(n,e));return t}getRowVector(n){return Matrix$2.rowVector(this.getRow(n))}setRow(n,t){checkRowIndex(this,n),t=checkRowVector(this,t);for(let e=0;e<this.columns;e++)this.set(n,e,t[e]);return this}swapRows(n,t){checkRowIndex(this,n),checkRowIndex(this,t);for(let e=0;e<this.columns;e++){let i=this.get(n,e);this.set(n,e,this.get(t,e)),this.set(t,e,i)}return this}getColumn(n){checkColumnIndex(this,n);let t=[];for(let e=0;e<this.rows;e++)t.push(this.get(e,n));return t}getColumnVector(n){return Matrix$2.columnVector(this.getColumn(n))}setColumn(n,t){checkColumnIndex(this,n),t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)this.set(e,n,t[e]);return this}swapColumns(n,t){checkColumnIndex(this,n),checkColumnIndex(this,t);for(let e=0;e<this.rows;e++){let i=this.get(e,n);this.set(e,n,this.get(e,t)),this.set(e,t,i)}return this}addRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n[e]);return this}subRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n[e]);return this}mulRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n[e]);return this}divRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n[e]);return this}addColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n[t]);return this}subColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n[t]);return this}mulColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n[t]);return this}divColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n[t]);return this}mulRow(n,t){checkRowIndex(this,n);for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)*t);return this}mulColumn(n,t){checkColumnIndex(this,n);for(let e=0;e<this.rows;e++)this.set(e,n,this.get(e,n)*t);return this}max(n){if(this.isEmpty())return NaN;switch(n){case"row":{const n=new Array(this.rows).fill(Number.NEGATIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)>n[t]&&(n[t]=this.get(t,e));return n}case"column":{const n=new Array(this.columns).fill(Number.NEGATIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)>n[e]&&(n[e]=this.get(t,e));return n}case void 0:{let n=this.get(0,0);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)>n&&(n=this.get(t,e));return n}default:throw new Error(`invalid option: ${n}`)}}maxIndex(){checkNonEmpty(this);let n=this.get(0,0),t=[0,0];for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.get(e,i)>n&&(n=this.get(e,i),t[0]=e,t[1]=i);return t}min(n){if(this.isEmpty())return NaN;switch(n){case"row":{const n=new Array(this.rows).fill(Number.POSITIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)<n[t]&&(n[t]=this.get(t,e));return n}case"column":{const n=new Array(this.columns).fill(Number.POSITIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)<n[e]&&(n[e]=this.get(t,e));return n}case void 0:{let n=this.get(0,0);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)<n&&(n=this.get(t,e));return n}default:throw new Error(`invalid option: ${n}`)}}minIndex(){checkNonEmpty(this);let n=this.get(0,0),t=[0,0];for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.get(e,i)<n&&(n=this.get(e,i),t[0]=e,t[1]=i);return t}maxRow(n){if(checkRowIndex(this,n),this.isEmpty())return NaN;let t=this.get(n,0);for(let e=1;e<this.columns;e++)this.get(n,e)>t&&(t=this.get(n,e));return t}maxRowIndex(n){checkRowIndex(this,n),checkNonEmpty(this);let t=this.get(n,0),e=[n,0];for(let i=1;i<this.columns;i++)this.get(n,i)>t&&(t=this.get(n,i),e[1]=i);return e}minRow(n){if(checkRowIndex(this,n),this.isEmpty())return NaN;let t=this.get(n,0);for(let e=1;e<this.columns;e++)this.get(n,e)<t&&(t=this.get(n,e));return t}minRowIndex(n){checkRowIndex(this,n),checkNonEmpty(this);let t=this.get(n,0),e=[n,0];for(let i=1;i<this.columns;i++)this.get(n,i)<t&&(t=this.get(n,i),e[1]=i);return e}maxColumn(n){if(checkColumnIndex(this,n),this.isEmpty())return NaN;let t=this.get(0,n);for(let e=1;e<this.rows;e++)this.get(e,n)>t&&(t=this.get(e,n));return t}maxColumnIndex(n){checkColumnIndex(this,n),checkNonEmpty(this);let t=this.get(0,n),e=[0,n];for(let i=1;i<this.rows;i++)this.get(i,n)>t&&(t=this.get(i,n),e[0]=i);return e}minColumn(n){if(checkColumnIndex(this,n),this.isEmpty())return NaN;let t=this.get(0,n);for(let e=1;e<this.rows;e++)this.get(e,n)<t&&(t=this.get(e,n));return t}minColumnIndex(n){checkColumnIndex(this,n),checkNonEmpty(this);let t=this.get(0,n),e=[0,n];for(let i=1;i<this.rows;i++)this.get(i,n)<t&&(t=this.get(i,n),e[0]=i);return e}diag(){let n=Math.min(this.rows,this.columns),t=[];for(let e=0;e<n;e++)t.push(this.get(e,e));return t}norm(n="frobenius"){switch(n){case"max":return this.max();case"frobenius":return Math.sqrt(this.dot(this));default:throw new RangeError(`unknown norm type: ${n}`)}}cumulativeSum(){let n=0;for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n+=this.get(t,e),this.set(t,e,n);return this}dot(n){AbstractMatrix.isMatrix(n)&&(n=n.to1DArray());let t=this.to1DArray();if(t.length!==n.length)throw new RangeError("vectors do not have the same size");let e=0;for(let i=0;i<t.length;i++)e+=t[i]*n[i];return e}mmul(n){n=Matrix$2.checkMatrix(n);let t=this.rows,e=this.columns,i=n.columns,s=new Matrix$2(t,i),a=new Float64Array(e);for(let r=0;r<i;r++){for(let t=0;t<e;t++)a[t]=n.get(t,r);for(let n=0;n<t;n++){let t=0;for(let i=0;i<e;i++)t+=this.get(n,i)*a[i];s.set(n,r,t)}}return s}strassen2x2(n){n=Matrix$2.checkMatrix(n);let t=new Matrix$2(2,2);const e=this.get(0,0),i=n.get(0,0),s=this.get(0,1),a=n.get(0,1),r=this.get(1,0),o=n.get(1,0),l=this.get(1,1),f=n.get(1,1),g=(e+l)*(i+f),u=(r+l)*i,d=e*(a-f),c=l*(o-i),h=(e+s)*f,b=g+c-h+(s-l)*(o+f),D=d+h,H=u+c,j=g-u+d+(r-e)*(i+a);return t.set(0,0,b),t.set(0,1,D),t.set(1,0,H),t.set(1,1,j),t}strassen3x3(n){n=Matrix$2.checkMatrix(n);let t=new Matrix$2(3,3);const e=this.get(0,0),i=this.get(0,1),s=this.get(0,2),a=this.get(1,0),r=this.get(1,1),o=this.get(1,2),l=this.get(2,0),f=this.get(2,1),g=this.get(2,2),u=n.get(0,0),d=n.get(0,1),c=n.get(0,2),h=n.get(1,0),b=n.get(1,1),D=n.get(1,2),H=n.get(2,0),j=n.get(2,1),m=n.get(2,2),A=(e-a)*(-d+b),C=(-e+a+r)*(u-d+b),T=(a+r)*(-u+d),p=e*u,I=(-e+l+f)*(u-c+D),P=(-e+l)*(c-D),M=(l+f)*(-u+c),w=(-s+f+g)*(b+H-j),N=(s-g)*(b-j),L=s*H,U=(f+g)*(-H+j),k=(-s+r+o)*(D+H-m),J=(s-o)*(D-m),y=(r+o)*(-H+m),B=p+L+i*h,R=(e+i+s-a-r-f-g)*b+C+T+p+w+L+U,E=p+I+M+(e+i+s-r-o-l-f)*D+L+k+y,x=A+r*(-u+d+h-b-D-H+m)+C+p+L+k+J,F=A+C+T+p+o*j,Q=L+k+J+y+a*c,S=p+I+P+f*(-u+c+h-b-D-H+j)+w+N+L,X=w+N+L+U+l*d,z=p+I+P+M+g*m;return t.set(0,0,B),t.set(0,1,R),t.set(0,2,E),t.set(1,0,x),t.set(1,1,F),t.set(1,2,Q),t.set(2,0,S),t.set(2,1,X),t.set(2,2,z),t}mmulStrassen(n){n=Matrix$2.checkMatrix(n);let t=this.clone(),e=t.rows,i=t.columns,s=n.rows,a=n.columns;function r(n,t,e){let i=n.rows,s=n.columns;if(i===t&&s===e)return n;{let i=AbstractMatrix.zeros(t,e);return i=i.setSubMatrix(n,0,0),i}}i!==s&&console.warn(`Multiplying ${e} x ${i} and ${s} x ${a} matrix: dimensions do not match.`);let o=Math.max(e,s),l=Math.max(i,a);return t=r(t,o,l),function n(t,e,i,s){if(i<=512||s<=512)return t.mmul(e);i%2==1&&s%2==1?(t=r(t,i+1,s+1),e=r(e,i+1,s+1)):i%2==1?(t=r(t,i+1,s),e=r(e,i+1,s)):s%2==1&&(t=r(t,i,s+1),e=r(e,i,s+1));let a=parseInt(t.rows/2,10),o=parseInt(t.columns/2,10),l=t.subMatrix(0,a-1,0,o-1),f=e.subMatrix(0,a-1,0,o-1),g=t.subMatrix(0,a-1,o,t.columns-1),u=e.subMatrix(0,a-1,o,e.columns-1),d=t.subMatrix(a,t.rows-1,0,o-1),c=e.subMatrix(a,e.rows-1,0,o-1),h=t.subMatrix(a,t.rows-1,o,t.columns-1),b=e.subMatrix(a,e.rows-1,o,e.columns-1),D=n(AbstractMatrix.add(l,h),AbstractMatrix.add(f,b),a,o),H=n(AbstractMatrix.add(d,h),f,a,o),j=n(l,AbstractMatrix.sub(u,b),a,o),m=n(h,AbstractMatrix.sub(c,f),a,o),A=n(AbstractMatrix.add(l,g),b,a,o),C=n(AbstractMatrix.sub(d,l),AbstractMatrix.add(f,u),a,o),T=n(AbstractMatrix.sub(g,h),AbstractMatrix.add(c,b),a,o),p=AbstractMatrix.add(D,m);p.sub(A),p.add(T);let I=AbstractMatrix.add(j,A),P=AbstractMatrix.add(H,m),M=AbstractMatrix.sub(D,H);M.add(j),M.add(C);let w=AbstractMatrix.zeros(2*p.rows,2*p.columns);return w=w.setSubMatrix(p,0,0),w=w.setSubMatrix(I,p.rows,0),w=w.setSubMatrix(P,0,p.columns),w=w.setSubMatrix(M,p.rows,p.columns),w.subMatrix(0,i-1,0,s-1)}(t,n=r(n,o,l),o,l)}scaleRows(n={}){if("object"!=typeof n)throw new TypeError("options must be an object");const{min:t=0,max:e=1}=n;if(!Number.isFinite(t))throw new TypeError("min must be a number");if(!Number.isFinite(e))throw new TypeError("max must be a number");if(t>=e)throw new RangeError("min must be smaller than max");let i=new Matrix$2(this.rows,this.columns);for(let n=0;n<this.rows;n++){const s=this.getRow(n);s.length>0&&rescale$1(s,{min:t,max:e,output:s}),i.setRow(n,s)}return i}scaleColumns(n={}){if("object"!=typeof n)throw new TypeError("options must be an object");const{min:t=0,max:e=1}=n;if(!Number.isFinite(t))throw new TypeError("min must be a number");if(!Number.isFinite(e))throw new TypeError("max must be a number");if(t>=e)throw new RangeError("min must be smaller than max");let i=new Matrix$2(this.rows,this.columns);for(let n=0;n<this.columns;n++){const s=this.getColumn(n);s.length&&rescale$1(s,{min:t,max:e,output:s}),i.setColumn(n,s)}return i}flipRows(){const n=Math.ceil(this.columns/2);for(let t=0;t<this.rows;t++)for(let e=0;e<n;e++){let n=this.get(t,e),i=this.get(t,this.columns-1-e);this.set(t,e,i),this.set(t,this.columns-1-e,n)}return this}flipColumns(){const n=Math.ceil(this.rows/2);for(let t=0;t<this.columns;t++)for(let e=0;e<n;e++){let n=this.get(e,t),i=this.get(this.rows-1-e,t);this.set(e,t,i),this.set(this.rows-1-e,t,n)}return this}kroneckerProduct(n){n=Matrix$2.checkMatrix(n);let t=this.rows,e=this.columns,i=n.rows,s=n.columns,a=new Matrix$2(t*i,e*s);for(let r=0;r<t;r++)for(let t=0;t<e;t++)for(let e=0;e<i;e++)for(let o=0;o<s;o++)a.set(i*r+e,s*t+o,this.get(r,t)*n.get(e,o));return a}kroneckerSum(n){if(n=Matrix$2.checkMatrix(n),!this.isSquare()||!n.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let t=this.rows,e=n.rows,i=this.kroneckerProduct(Matrix$2.eye(e,e)),s=Matrix$2.eye(t,t).kroneckerProduct(n);return i.add(s)}transpose(){let n=new Matrix$2(this.columns,this.rows);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n.set(e,t,this.get(t,e));return n}sortRows(n=compareNumbers){for(let t=0;t<this.rows;t++)this.setRow(t,this.getRow(t).sort(n));return this}sortColumns(n=compareNumbers){for(let t=0;t<this.columns;t++)this.setColumn(t,this.getColumn(t).sort(n));return this}subMatrix(n,t,e,i){checkRange$1(this,n,t,e,i);let s=new Matrix$2(t-n+1,i-e+1);for(let a=n;a<=t;a++)for(let t=e;t<=i;t++)s.set(a-n,t-e,this.get(a,t));return s}subMatrixRow(n,t,e){if(void 0===t&&(t=0),void 0===e&&(e=this.columns-1),t>e||t<0||t>=this.columns||e<0||e>=this.columns)throw new RangeError("Argument out of range");let i=new Matrix$2(n.length,e-t+1);for(let s=0;s<n.length;s++)for(let a=t;a<=e;a++){if(n[s]<0||n[s]>=this.rows)throw new RangeError(`Row index out of range: ${n[s]}`);i.set(s,a-t,this.get(n[s],a))}return i}subMatrixColumn(n,t,e){if(void 0===t&&(t=0),void 0===e&&(e=this.rows-1),t>e||t<0||t>=this.rows||e<0||e>=this.rows)throw new RangeError("Argument out of range");let i=new Matrix$2(e-t+1,n.length);for(let s=0;s<n.length;s++)for(let a=t;a<=e;a++){if(n[s]<0||n[s]>=this.columns)throw new RangeError(`Column index out of range: ${n[s]}`);i.set(a-t,s,this.get(a,n[s]))}return i}setSubMatrix(n,t,e){if((n=Matrix$2.checkMatrix(n)).isEmpty())return this;checkRange$1(this,t,t+n.rows-1,e,e+n.columns-1);for(let i=0;i<n.rows;i++)for(let s=0;s<n.columns;s++)this.set(t+i,e+s,n.get(i,s));return this}selection(n,t){checkRowIndices(this,n),checkColumnIndices(this,t);let e=new Matrix$2(n.length,t.length);for(let i=0;i<n.length;i++){let s=n[i];for(let n=0;n<t.length;n++){let a=t[n];e.set(i,n,this.get(s,a))}}return e}trace(){let n=Math.min(this.rows,this.columns),t=0;for(let e=0;e<n;e++)t+=this.get(e,e);return t}clone(){return this.constructor.copy(this,new Matrix$2(this.rows,this.columns))}static copy(n,t){for(const[e,i,s]of n.entries())t.set(e,i,s);return t}sum(n){switch(n){case"row":return sumByRow(this);case"column":return sumByColumn(this);case void 0:return sumAll(this);default:throw new Error(`invalid option: ${n}`)}}product(n){switch(n){case"row":return productByRow(this);case"column":return productByColumn(this);case void 0:return productAll(this);default:throw new Error(`invalid option: ${n}`)}}mean(n){const t=this.sum(n);switch(n){case"row":for(let n=0;n<this.rows;n++)t[n]/=this.columns;return t;case"column":for(let n=0;n<this.columns;n++)t[n]/=this.rows;return t;case void 0:return t/this.size;default:throw new Error(`invalid option: ${n}`)}}variance(n,t={}){if("object"==typeof n&&(t=n,n=void 0),"object"!=typeof t)throw new TypeError("options must be an object");const{unbiased:e=!0,mean:i=this.mean(n)}=t;if("boolean"!=typeof e)throw new TypeError("unbiased must be a boolean");switch(n){case"row":if(!isAnyArray.isAnyArray(i))throw new TypeError("mean must be an array");return varianceByRow(this,e,i);case"column":if(!isAnyArray.isAnyArray(i))throw new TypeError("mean must be an array");return varianceByColumn(this,e,i);case void 0:if("number"!=typeof i)throw new TypeError("mean must be a number");return varianceAll(this,e,i);default:throw new Error(`invalid option: ${n}`)}}standardDeviation(n,t){"object"==typeof n&&(t=n,n=void 0);const e=this.variance(n,t);if(void 0===n)return Math.sqrt(e);for(let n=0;n<e.length;n++)e[n]=Math.sqrt(e[n]);return e}center(n,t={}){if("object"==typeof n&&(t=n,n=void 0),"object"!=typeof t)throw new TypeError("options must be an object");const{center:e=this.mean(n)}=t;switch(n){case"row":if(!isAnyArray.isAnyArray(e))throw new TypeError("center must be an array");return centerByRow(this,e),this;case"column":if(!isAnyArray.isAnyArray(e))throw new TypeError("center must be an array");return centerByColumn(this,e),this;case void 0:if("number"!=typeof e)throw new TypeError("center must be a number");return centerAll(this,e),this;default:throw new Error(`invalid option: ${n}`)}}scale(n,t={}){if("object"==typeof n&&(t=n,n=void 0),"object"!=typeof t)throw new TypeError("options must be an object");let e=t.scale;switch(n){case"row":if(void 0===e)e=getScaleByRow(this);else if(!isAnyArray.isAnyArray(e))throw new TypeError("scale must be an array");return scaleByRow(this,e),this;case"column":if(void 0===e)e=getScaleByColumn(this);else if(!isAnyArray.isAnyArray(e))throw new TypeError("scale must be an array");return scaleByColumn(this,e),this;case void 0:if(void 0===e)e=getScaleAll(this);else if("number"!=typeof e)throw new TypeError("scale must be a number");return scaleAll(this,e),this;default:throw new Error(`invalid option: ${n}`)}}toString(n){return inspectMatrixWithOptions(this,n)}[Symbol.iterator](){return this.entries()}*entries(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)yield[n,t,this.get(n,t)]}*values(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)yield this.get(n,t)}}function compareNumbers(n,t){return n-t}function isArrayOfNumbers(n){return n.every((n=>"number"==typeof n))}AbstractMatrix.prototype.klass="Matrix","undefined"!=typeof Symbol&&(AbstractMatrix.prototype[Symbol.for("nodejs.util.inspect.custom")]=inspectMatrix),AbstractMatrix.random=AbstractMatrix.rand,AbstractMatrix.randomInt=AbstractMatrix.randInt,AbstractMatrix.diagonal=AbstractMatrix.diag,AbstractMatrix.prototype.diagonal=AbstractMatrix.prototype.diag,AbstractMatrix.identity=AbstractMatrix.eye,AbstractMatrix.prototype.negate=AbstractMatrix.prototype.neg,AbstractMatrix.prototype.tensorProduct=AbstractMatrix.prototype.kroneckerProduct;class Matrix$2 extends AbstractMatrix{data;#n(n,t){if(this.data=[],!(Number.isInteger(t)&&t>=0))throw new TypeError("nColumns must be a positive integer");for(let e=0;e<n;e++)this.data.push(new Float64Array(t));this.rows=n,this.columns=t}constructor(n,t){if(super(),Matrix$2.isMatrix(n))this.#n(n.rows,n.columns),Matrix$2.copy(n,this);else if(Number.isInteger(n)&&n>=0)this.#n(n,t);else{if(!isAnyArray.isAnyArray(n))throw new TypeError("First argument must be a positive number or an array");{const e=n;if("number"!=typeof(t=(n=e.length)?e[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let i=0;i<n;i++){if(e[i].length!==t)throw new RangeError("Inconsistent array dimensions");if(!isArrayOfNumbers(e[i]))throw new TypeError("Input data contains non-numeric values");this.data.push(Float64Array.from(e[i]))}this.rows=n,this.columns=t}}}set(n,t,e){return this.data[n][t]=e,this}get(n,t){return this.data[n][t]}removeRow(n){return checkRowIndex(this,n),this.data.splice(n,1),this.rows-=1,this}addRow(n,t){return void 0===t&&(t=n,n=this.rows),checkRowIndex(this,n,!0),t=Float64Array.from(checkRowVector(this,t)),this.data.splice(n,0,t),this.rows+=1,this}removeColumn(n){checkColumnIndex(this,n);for(let t=0;t<this.rows;t++){const e=new Float64Array(this.columns-1);for(let i=0;i<n;i++)e[i]=this.data[t][i];for(let i=n+1;i<this.columns;i++)e[i-1]=this.data[t][i];this.data[t]=e}return this.columns-=1,this}addColumn(n,t){void 0===t&&(t=n,n=this.columns),checkColumnIndex(this,n,!0),t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++){const i=new Float64Array(this.columns+1);let s=0;for(;s<n;s++)i[s]=this.data[e][s];for(i[s++]=t[e];s<this.columns+1;s++)i[s]=this.data[e][s-1];this.data[e]=i}return this.columns+=1,this}}installMathOperations(AbstractMatrix,Matrix$2);class SymmetricMatrix extends AbstractMatrix{#t;get size(){return this.#t.size}get rows(){return this.#t.rows}get columns(){return this.#t.columns}get diagonalSize(){return this.rows}static isSymmetricMatrix(n){return Matrix$2.isMatrix(n)&&"SymmetricMatrix"===n.klassType}static zeros(n){return new this(n)}static ones(n){return new this(n).fill(1)}constructor(n){if(super(),Matrix$2.isMatrix(n)){if(!n.isSymmetric())throw new TypeError("not symmetric data");this.#t=Matrix$2.copy(n,new Matrix$2(n.rows,n.rows))}else if(Number.isInteger(n)&&n>=0)this.#t=new Matrix$2(n,n);else if(this.#t=new Matrix$2(n),!this.isSymmetric())throw new TypeError("not symmetric data")}clone(){const n=new SymmetricMatrix(this.diagonalSize);for(const[t,e,i]of this.upperRightEntries())n.set(t,e,i);return n}toMatrix(){return new Matrix$2(this)}get(n,t){return this.#t.get(n,t)}set(n,t,e){return this.#t.set(n,t,e),this.#t.set(t,n,e),this}removeCross(n){return this.#t.removeRow(n),this.#t.removeColumn(n),this}addCross(n,t){void 0===t&&(t=n,n=this.diagonalSize);const e=t.slice();return e.splice(n,1),this.#t.addRow(n,e),this.#t.addColumn(n,t),this}applyMask(n){if(n.length!==this.diagonalSize)throw new RangeError("Mask size do not match with matrix size");const t=[];for(const[e,i]of n.entries())i||t.push(e);t.reverse();for(const n of t)this.removeCross(n);return this}toCompact(){const{diagonalSize:n}=this,t=new Array(n*(n+1)/2);for(let e=0,i=0,s=0;s<t.length;s++)t[s]=this.get(i,e),++e>=n&&(e=++i);return t}static fromCompact(n){const t=n.length,e=(Math.sqrt(8*t+1)-1)/2;if(!Number.isInteger(e))throw new TypeError(`This array is not a compact representation of a Symmetric Matrix, ${JSON.stringify(n)}`);const i=new SymmetricMatrix(e);for(let s=0,a=0,r=0;r<t;r++)i.set(s,a,n[r]),++s>=e&&(s=++a);return i}*upperRightEntries(){for(let n=0,t=0;n<this.diagonalSize;void 0){const e=this.get(n,t);yield[n,t,e],++t>=this.diagonalSize&&(t=++n)}}*upperRightValues(){for(let n=0,t=0;n<this.diagonalSize;void 0){const e=this.get(n,t);yield e,++t>=this.diagonalSize&&(t=++n)}}}SymmetricMatrix.prototype.klassType="SymmetricMatrix";class DistanceMatrix extends SymmetricMatrix{static isDistanceMatrix(n){return SymmetricMatrix.isSymmetricMatrix(n)&&"DistanceMatrix"===n.klassSubType}constructor(n){if(super(n),!this.isDistance())throw new TypeError("Provided arguments do no produce a distance matrix")}set(n,t,e){return n===t&&(e=0),super.set(n,t,e)}addCross(n,t){return void 0===t&&(t=n,n=this.diagonalSize),(t=t.slice())[n]=0,super.addCross(n,t)}toSymmetricMatrix(){return new SymmetricMatrix(this)}clone(){const n=new DistanceMatrix(this.diagonalSize);for(const[t,e,i]of this.upperRightEntries())t!==e&&n.set(t,e,i);return n}toCompact(){const{diagonalSize:n}=this,t=new Array((n-1)*n/2);for(let e=1,i=0,s=0;s<t.length;s++)t[s]=this.get(i,e),++e>=n&&(e=1+ ++i);return t}static fromCompact(n){const t=n.length,e=(Math.sqrt(8*t+1)+1)/2;if(!Number.isInteger(e))throw new TypeError(`This array is not a compact representation of a DistanceMatrix, ${JSON.stringify(n)}`);const i=new this(e);for(let s=1,a=0,r=0;r<t;r++)i.set(s,a,n[r]),++s>=e&&(s=1+ ++a);return i}}DistanceMatrix.prototype.klassSubType="DistanceMatrix";class BaseView extends AbstractMatrix{constructor(n,t,e){super(),this.matrix=n,this.rows=t,this.columns=e}}class MatrixColumnView extends BaseView{constructor(n,t){checkColumnIndex(n,t),super(n,n.rows,1),this.column=t}set(n,t,e){return this.matrix.set(n,this.column,e),this}get(n){return this.matrix.get(n,this.column)}}class MatrixColumnSelectionView extends BaseView{constructor(n,t){checkColumnIndices(n,t),super(n,n.rows,t.length),this.columnIndices=t}set(n,t,e){return this.matrix.set(n,this.columnIndices[t],e),this}get(n,t){return this.matrix.get(n,this.columnIndices[t])}}class MatrixFlipColumnView extends BaseView{constructor(n){super(n,n.rows,n.columns)}set(n,t,e){return this.matrix.set(n,this.columns-t-1,e),this}get(n,t){return this.matrix.get(n,this.columns-t-1)}}class MatrixFlipRowView extends BaseView{constructor(n){super(n,n.rows,n.columns)}set(n,t,e){return this.matrix.set(this.rows-n-1,t,e),this}get(n,t){return this.matrix.get(this.rows-n-1,t)}}class MatrixRowView extends BaseView{constructor(n,t){checkRowIndex(n,t),super(n,1,n.columns),this.row=t}set(n,t,e){return this.matrix.set(this.row,t,e),this}get(n,t){return this.matrix.get(this.row,t)}}class MatrixRowSelectionView extends BaseView{constructor(n,t){checkRowIndices(n,t),super(n,t.length,n.columns),this.rowIndices=t}set(n,t,e){return this.matrix.set(this.rowIndices[n],t,e),this}get(n,t){return this.matrix.get(this.rowIndices[n],t)}}class MatrixSelectionView extends BaseView{constructor(n,t,e){checkRowIndices(n,t),checkColumnIndices(n,e),super(n,t.length,e.length),this.rowIndices=t,this.columnIndices=e}set(n,t,e){return this.matrix.set(this.rowIndices[n],this.columnIndices[t],e),this}get(n,t){return this.matrix.get(this.rowIndices[n],this.columnIndices[t])}}class MatrixSubView extends BaseView{constructor(n,t,e,i,s){checkRange$1(n,t,e,i,s),super(n,e-t+1,s-i+1),this.startRow=t,this.startColumn=i}set(n,t,e){return this.matrix.set(this.startRow+n,this.startColumn+t,e),this}get(n,t){return this.matrix.get(this.startRow+n,this.startColumn+t)}}class MatrixTransposeView$1 extends BaseView{constructor(n){super(n,n.columns,n.rows)}set(n,t,e){return this.matrix.set(t,n,e),this}get(n,t){return this.matrix.get(t,n)}}class WrapperMatrix1D extends AbstractMatrix{constructor(n,t={}){const{rows:e=1}=t;if(n.length%e!=0)throw new Error("the data length is not divisible by the number of rows");super(),this.rows=e,this.columns=n.length/e,this.data=n}set(n,t,e){let i=this._calculateIndex(n,t);return this.data[i]=e,this}get(n,t){let e=this._calculateIndex(n,t);return this.data[e]}_calculateIndex(n,t){return n*this.columns+t}}class WrapperMatrix2D extends AbstractMatrix{constructor(n){super(),this.data=n,this.rows=n.length,this.columns=n[0].length}set(n,t,e){return this.data[n][t]=e,this}get(n,t){return this.data[n][t]}}function wrap(n,t){if(isAnyArray.isAnyArray(n))return n[0]&&isAnyArray.isAnyArray(n[0])?new WrapperMatrix2D(n):new WrapperMatrix1D(n,t);throw new Error("the argument is not an array")}class LuDecomposition{constructor(n){let t,e,i,s,a,r,o,l,f,g=(n=WrapperMatrix2D.checkMatrix(n)).clone(),u=g.rows,d=g.columns,c=new Float64Array(u),h=1;for(t=0;t<u;t++)c[t]=t;for(l=new Float64Array(u),e=0;e<d;e++){for(t=0;t<u;t++)l[t]=g.get(t,e);for(t=0;t<u;t++){for(f=Math.min(t,e),a=0,i=0;i<f;i++)a+=g.get(t,i)*l[i];l[t]-=a,g.set(t,e,l[t])}for(s=e,t=e+1;t<u;t++)Math.abs(l[t])>Math.abs(l[s])&&(s=t);if(s!==e){for(i=0;i<d;i++)r=g.get(s,i),g.set(s,i,g.get(e,i)),g.set(e,i,r);o=c[s],c[s]=c[e],c[e]=o,h=-h}if(e<u&&0!==g.get(e,e))for(t=e+1;t<u;t++)g.set(t,e,g.get(t,e)/g.get(e,e))}this.LU=g,this.pivotVector=c,this.pivotSign=h}isSingular(){let n=this.LU,t=n.columns;for(let e=0;e<t;e++)if(0===n.get(e,e))return!0;return!1}solve(n){n=Matrix$2.checkMatrix(n);let t=this.LU;if(t.rows!==n.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let e,i,s,a=n.columns,r=n.subMatrixRow(this.pivotVector,0,a-1),o=t.columns;for(s=0;s<o;s++)for(e=s+1;e<o;e++)for(i=0;i<a;i++)r.set(e,i,r.get(e,i)-r.get(s,i)*t.get(e,s));for(s=o-1;s>=0;s--){for(i=0;i<a;i++)r.set(s,i,r.get(s,i)/t.get(s,s));for(e=0;e<s;e++)for(i=0;i<a;i++)r.set(e,i,r.get(e,i)-r.get(s,i)*t.get(e,s))}return r}get determinant(){let n=this.LU;if(!n.isSquare())throw new Error("Matrix must be square");let t=this.pivotSign,e=n.columns;for(let i=0;i<e;i++)t*=n.get(i,i);return t}get lowerTriangularMatrix(){let n=this.LU,t=n.rows,e=n.columns,i=new Matrix$2(t,e);for(let s=0;s<t;s++)for(let t=0;t<e;t++)s>t?i.set(s,t,n.get(s,t)):s===t?i.set(s,t,1):i.set(s,t,0);return i}get upperTriangularMatrix(){let n=this.LU,t=n.rows,e=n.columns,i=new Matrix$2(t,e);for(let s=0;s<t;s++)for(let t=0;t<e;t++)s<=t?i.set(s,t,n.get(s,t)):i.set(s,t,0);return i}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function hypotenuse(n,t){let e=0;return Math.abs(n)>Math.abs(t)?(e=t/n,Math.abs(n)*Math.sqrt(1+e*e)):0!==t?(e=n/t,Math.abs(t)*Math.sqrt(1+e*e)):0}class QrDecomposition{constructor(n){let t,e,i,s,a=(n=WrapperMatrix2D.checkMatrix(n)).clone(),r=n.rows,o=n.columns,l=new Float64Array(o);for(i=0;i<o;i++){let n=0;for(t=i;t<r;t++)n=hypotenuse(n,a.get(t,i));if(0!==n){for(a.get(i,i)<0&&(n=-n),t=i;t<r;t++)a.set(t,i,a.get(t,i)/n);for(a.set(i,i,a.get(i,i)+1),e=i+1;e<o;e++){for(s=0,t=i;t<r;t++)s+=a.get(t,i)*a.get(t,e);for(s=-s/a.get(i,i),t=i;t<r;t++)a.set(t,e,a.get(t,e)+s*a.get(t,i))}}l[i]=-n}this.QR=a,this.Rdiag=l}solve(n){n=Matrix$2.checkMatrix(n);let t=this.QR,e=t.rows;if(n.rows!==e)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let i,s,a,r,o=n.columns,l=n.clone(),f=t.columns;for(a=0;a<f;a++)for(s=0;s<o;s++){for(r=0,i=a;i<e;i++)r+=t.get(i,a)*l.get(i,s);for(r=-r/t.get(a,a),i=a;i<e;i++)l.set(i,s,l.get(i,s)+r*t.get(i,a))}for(a=f-1;a>=0;a--){for(s=0;s<o;s++)l.set(a,s,l.get(a,s)/this.Rdiag[a]);for(i=0;i<a;i++)for(s=0;s<o;s++)l.set(i,s,l.get(i,s)-l.get(a,s)*t.get(i,a))}return l.subMatrix(0,f-1,0,o-1)}isFullRank(){let n=this.QR.columns;for(let t=0;t<n;t++)if(0===this.Rdiag[t])return!1;return!0}get upperTriangularMatrix(){let n,t,e=this.QR,i=e.columns,s=new Matrix$2(i,i);for(n=0;n<i;n++)for(t=0;t<i;t++)n<t?s.set(n,t,e.get(n,t)):n===t?s.set(n,t,this.Rdiag[n]):s.set(n,t,0);return s}get orthogonalMatrix(){let n,t,e,i,s=this.QR,a=s.rows,r=s.columns,o=new Matrix$2(a,r);for(e=r-1;e>=0;e--){for(n=0;n<a;n++)o.set(n,e,0);for(o.set(e,e,1),t=e;t<r;t++)if(0!==s.get(e,e)){for(i=0,n=e;n<a;n++)i+=s.get(n,e)*o.get(n,t);for(i=-i/s.get(e,e),n=e;n<a;n++)o.set(n,t,o.get(n,t)+i*s.get(n,e))}}return o}}class SingularValueDecomposition{constructor(n,t={}){if((n=WrapperMatrix2D.checkMatrix(n)).isEmpty())throw new Error("Matrix must be non-empty");let e=n.rows,i=n.columns;const{computeLeftSingularVectors:s=!0,computeRightSingularVectors:a=!0,autoTranspose:r=!1}=t;let o,l=Boolean(s),f=Boolean(a),g=!1;if(e<i)if(r){o=n.transpose(),e=o.rows,i=o.columns,g=!0;let t=l;l=f,f=t}else o=n.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else o=n.clone();let u=Math.min(e,i),d=Math.min(e+1,i),c=new Float64Array(d),h=new Matrix$2(e,u),b=new Matrix$2(i,i),D=new Float64Array(i),H=new Float64Array(e),j=new Float64Array(d);for(let n=0;n<d;n++)j[n]=n;let m=Math.min(e-1,i),A=Math.max(0,Math.min(i-2,e)),C=Math.max(m,A);for(let n=0;n<C;n++){if(n<m){c[n]=0;for(let t=n;t<e;t++)c[n]=hypotenuse(c[n],o.get(t,n));if(0!==c[n]){o.get(n,n)<0&&(c[n]=-c[n]);for(let t=n;t<e;t++)o.set(t,n,o.get(t,n)/c[n]);o.set(n,n,o.get(n,n)+1)}c[n]=-c[n]}for(let t=n+1;t<i;t++){if(n<m&&0!==c[n]){let i=0;for(let s=n;s<e;s++)i+=o.get(s,n)*o.get(s,t);i=-i/o.get(n,n);for(let s=n;s<e;s++)o.set(s,t,o.get(s,t)+i*o.get(s,n))}D[t]=o.get(n,t)}if(l&&n<m)for(let t=n;t<e;t++)h.set(t,n,o.get(t,n));if(n<A){D[n]=0;for(let t=n+1;t<i;t++)D[n]=hypotenuse(D[n],D[t]);if(0!==D[n]){D[n+1]<0&&(D[n]=0-D[n]);for(let t=n+1;t<i;t++)D[t]/=D[n];D[n+1]+=1}if(D[n]=-D[n],n+1<e&&0!==D[n]){for(let t=n+1;t<e;t++)H[t]=0;for(let t=n+1;t<e;t++)for(let e=n+1;e<i;e++)H[t]+=D[e]*o.get(t,e);for(let t=n+1;t<i;t++){let i=-D[t]/D[n+1];for(let s=n+1;s<e;s++)o.set(s,t,o.get(s,t)+i*H[s])}}if(f)for(let t=n+1;t<i;t++)b.set(t,n,D[t])}}let T=Math.min(i,e+1);if(m<i&&(c[m]=o.get(m,m)),e<T&&(c[T-1]=0),A+1<T&&(D[A]=o.get(A,T-1)),D[T-1]=0,l){for(let n=m;n<u;n++){for(let t=0;t<e;t++)h.set(t,n,0);h.set(n,n,1)}for(let n=m-1;n>=0;n--)if(0!==c[n]){for(let t=n+1;t<u;t++){let i=0;for(let s=n;s<e;s++)i+=h.get(s,n)*h.get(s,t);i=-i/h.get(n,n);for(let s=n;s<e;s++)h.set(s,t,h.get(s,t)+i*h.get(s,n))}for(let t=n;t<e;t++)h.set(t,n,-h.get(t,n));h.set(n,n,1+h.get(n,n));for(let t=0;t<n-1;t++)h.set(t,n,0)}else{for(let t=0;t<e;t++)h.set(t,n,0);h.set(n,n,1)}}if(f)for(let n=i-1;n>=0;n--){if(n<A&&0!==D[n])for(let t=n+1;t<i;t++){let e=0;for(let s=n+1;s<i;s++)e+=b.get(s,n)*b.get(s,t);e=-e/b.get(n+1,n);for(let s=n+1;s<i;s++)b.set(s,t,b.get(s,t)+e*b.get(s,n))}for(let t=0;t<i;t++)b.set(t,n,0);b.set(n,n,1)}let p=T-1,I=Number.EPSILON;for(;T>0;){let n,t;for(n=T-2;n>=-1&&-1!==n;n--){const t=Number.MIN_VALUE+I*Math.abs(c[n]+Math.abs(c[n+1]));if(Math.abs(D[n])<=t||Number.isNaN(D[n])){D[n]=0;break}}if(n===T-2)t=4;else{let e;for(e=T-1;e>=n&&e!==n;e--){let t=(e!==T?Math.abs(D[e]):0)+(e!==n+1?Math.abs(D[e-1]):0);if(Math.abs(c[e])<=I*t){c[e]=0;break}}e===n?t=3:e===T-1?t=1:(t=2,n=e)}switch(n++,t){case 1:{let t=D[T-2];D[T-2]=0;for(let e=T-2;e>=n;e--){let s=hypotenuse(c[e],t),a=c[e]/s,r=t/s;if(c[e]=s,e!==n&&(t=-r*D[e-1],D[e-1]=a*D[e-1]),f)for(let n=0;n<i;n++)s=a*b.get(n,e)+r*b.get(n,T-1),b.set(n,T-1,-r*b.get(n,e)+a*b.get(n,T-1)),b.set(n,e,s)}break}case 2:{let t=D[n-1];D[n-1]=0;for(let i=n;i<T;i++){let s=hypotenuse(c[i],t),a=c[i]/s,r=t/s;if(c[i]=s,t=-r*D[i],D[i]=a*D[i],l)for(let t=0;t<e;t++)s=a*h.get(t,i)+r*h.get(t,n-1),h.set(t,n-1,-r*h.get(t,i)+a*h.get(t,n-1)),h.set(t,i,s)}break}case 3:{const t=Math.max(Math.abs(c[T-1]),Math.abs(c[T-2]),Math.abs(D[T-2]),Math.abs(c[n]),Math.abs(D[n])),s=c[T-1]/t,a=c[T-2]/t,r=D[T-2]/t,o=c[n]/t,g=D[n]/t,u=((a+s)*(a-s)+r*r)/2,d=s*r*(s*r);let H=0;0===u&&0===d||(H=u<0?0-Math.sqrt(u*u+d):Math.sqrt(u*u+d),H=d/(u+H));let j=(o+s)*(o-s)+H,m=o*g;for(let t=n;t<T-1;t++){let s=hypotenuse(j,m);0===s&&(s=Number.MIN_VALUE);let a=j/s,r=m/s;if(t!==n&&(D[t-1]=s),j=a*c[t]+r*D[t],D[t]=a*D[t]-r*c[t],m=r*c[t+1],c[t+1]=a*c[t+1],f)for(let n=0;n<i;n++)s=a*b.get(n,t)+r*b.get(n,t+1),b.set(n,t+1,-r*b.get(n,t)+a*b.get(n,t+1)),b.set(n,t,s);if(s=hypotenuse(j,m),0===s&&(s=Number.MIN_VALUE),a=j/s,r=m/s,c[t]=s,j=a*D[t]+r*c[t+1],c[t+1]=-r*D[t]+a*c[t+1],m=r*D[t+1],D[t+1]=a*D[t+1],l&&t<e-1)for(let n=0;n<e;n++)s=a*h.get(n,t)+r*h.get(n,t+1),h.set(n,t+1,-r*h.get(n,t)+a*h.get(n,t+1)),h.set(n,t,s)}D[T-2]=j;break}case 4:if(c[n]<=0&&(c[n]=c[n]<0?-c[n]:0,f))for(let t=0;t<=p;t++)b.set(t,n,-b.get(t,n));for(;n<p&&!(c[n]>=c[n+1]);){let t=c[n];if(c[n]=c[n+1],c[n+1]=t,f&&n<i-1)for(let e=0;e<i;e++)t=b.get(e,n+1),b.set(e,n+1,b.get(e,n)),b.set(e,n,t);if(l&&n<e-1)for(let i=0;i<e;i++)t=h.get(i,n+1),h.set(i,n+1,h.get(i,n)),h.set(i,n,t);n++}T--}}if(g){let n=b;b=h,h=n}this.m=e,this.n=i,this.s=c,this.U=h,this.V=b}solve(n){let t=n,e=this.threshold,i=this.s.length,s=Matrix$2.zeros(i,i);for(let n=0;n<i;n++)Math.abs(this.s[n])<=e?s.set(n,n,0):s.set(n,n,1/this.s[n]);let a=this.U,r=this.rightSingularVectors,o=r.mmul(s),l=r.rows,f=a.rows,g=Matrix$2.zeros(l,f);for(let n=0;n<l;n++)for(let t=0;t<f;t++){let e=0;for(let s=0;s<i;s++)e+=o.get(n,s)*a.get(t,s);g.set(n,t,e)}return g.mmul(t)}solveForDiagonal(n){return this.solve(Matrix$2.diag(n))}inverse(){let n=this.V,t=this.threshold,e=n.rows,i=n.columns,s=new Matrix$2(e,this.s.length);for(let a=0;a<e;a++)for(let e=0;e<i;e++)Math.abs(this.s[e])>t&&s.set(a,e,n.get(a,e)/this.s[e]);let a=this.U,r=a.rows,o=a.columns,l=new Matrix$2(e,r);for(let n=0;n<e;n++)for(let t=0;t<r;t++){let e=0;for(let i=0;i<o;i++)e+=s.get(n,i)*a.get(t,i);l.set(n,t,e)}return l}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let n=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,t=0,e=this.s;for(let i=0,s=e.length;i<s;i++)e[i]>n&&t++;return t}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return Matrix$2.diag(this.s)}}function inverse$1(n,t=!1){return n=WrapperMatrix2D.checkMatrix(n),t?new SingularValueDecomposition(n).inverse():solve$1(n,Matrix$2.eye(n.rows))}function solve$1(n,t,e=!1){return n=WrapperMatrix2D.checkMatrix(n),t=WrapperMatrix2D.checkMatrix(t),e?new SingularValueDecomposition(n).solve(t):n.isSquare()?new LuDecomposition(n).solve(t):new QrDecomposition(n).solve(t)}function determinant(n){if((n=Matrix$2.checkMatrix(n)).isSquare()){if(0===n.columns)return 1;let t,e,i,s;if(2===n.columns)return t=n.get(0,0),e=n.get(0,1),i=n.get(1,0),s=n.get(1,1),t*s-e*i;if(3===n.columns){let s,a,r;return s=new MatrixSelectionView(n,[1,2],[1,2]),a=new MatrixSelectionView(n,[1,2],[0,2]),r=new MatrixSelectionView(n,[1,2],[0,1]),t=n.get(0,0),e=n.get(0,1),i=n.get(0,2),t*determinant(s)-e*determinant(a)+i*determinant(r)}return new LuDecomposition(n).determinant}throw Error("determinant can only be calculated for a square matrix")}function xrange(n,t){let e=[];for(let i=0;i<n;i++)i!==t&&e.push(i);return e}function dependenciesOneRow(n,t,e,i=1e-9,s=1e-9){if(n>s)return new Array(t.rows+1).fill(0);{let n=t.addRow(e,[0]);for(let t=0;t<n.rows;t++)Math.abs(n.get(t,0))<i&&n.set(t,0,0);return n.to1DArray()}}function linearDependencies(n,t={}){const{thresholdValue:e=1e-9,thresholdError:i=1e-9}=t;let s=(n=Matrix$2.checkMatrix(n)).rows,a=new Matrix$2(s,s);for(let t=0;t<s;t++){let r=Matrix$2.columnVector(n.getRow(t)),o=n.subMatrixRow(xrange(s,t)).transpose(),l=new SingularValueDecomposition(o).solve(r),f=Matrix$2.sub(r,o.mmul(l)).abs().max();a.setRow(t,dependenciesOneRow(f,l,t,e,i))}return a}function pseudoInverse(n,t=Number.EPSILON){if((n=Matrix$2.checkMatrix(n)).isEmpty())return n.transpose();let e=new SingularValueDecomposition(n,{autoTranspose:!0}),i=e.leftSingularVectors,s=e.rightSingularVectors,a=e.diagonal;for(let n=0;n<a.length;n++)Math.abs(a[n])>t?a[n]=1/a[n]:a[n]=0;return s.mmul(Matrix$2.diag(a).mmul(i.transpose()))}function covariance(n,t=n,e={}){n=new Matrix$2(n);let i=!1;if("object"!=typeof t||Matrix$2.isMatrix(t)||isAnyArray.isAnyArray(t)?t=new Matrix$2(t):(e=t,t=n,i=!0),n.rows!==t.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:s=!0}=e;s&&(n=n.center("column"),i||(t=t.center("column")));const a=n.transpose().mmul(t);for(let t=0;t<a.rows;t++)for(let e=0;e<a.columns;e++)a.set(t,e,a.get(t,e)*(1/(n.rows-1)));return a}function correlation(n,t=n,e={}){n=new Matrix$2(n);let i=!1;if("object"!=typeof t||Matrix$2.isMatrix(t)||isAnyArray.isAnyArray(t)?t=new Matrix$2(t):(e=t,t=n,i=!0),n.rows!==t.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:s=!0,scale:a=!0}=e;s&&(n.center("column"),i||t.center("column")),a&&(n.scale("column"),i||t.scale("column"));const r=n.standardDeviation("column",{unbiased:!0}),o=i?r:t.standardDeviation("column",{unbiased:!0}),l=n.transpose().mmul(t);for(let t=0;t<l.rows;t++)for(let e=0;e<l.columns;e++)l.set(t,e,l.get(t,e)*(1/(r[t]*o[e]))*(1/(n.rows-1)));return l}class EigenvalueDecomposition{constructor(n,t={}){const{assumeSymmetric:e=!1}=t;if(!(n=WrapperMatrix2D.checkMatrix(n)).isSquare())throw new Error("Matrix is not a square matrix");if(n.isEmpty())throw new Error("Matrix must be non-empty");let i,s,a=n.columns,r=new Matrix$2(a,a),o=new Float64Array(a),l=new Float64Array(a),f=n,g=!1;if(g=!!e||n.isSymmetric(),g){for(i=0;i<a;i++)for(s=0;s<a;s++)r.set(i,s,f.get(i,s));tred2(a,l,o,r),tql2(a,l,o,r)}else{let n=new Matrix$2(a,a),t=new Float64Array(a);for(s=0;s<a;s++)for(i=0;i<a;i++)n.set(i,s,f.get(i,s));orthes(a,n,t,r),hqr2(a,l,o,r,n)}this.n=a,this.e=l,this.d=o,this.V=r}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let n,t,e=this.n,i=this.e,s=this.d,a=new Matrix$2(e,e);for(n=0;n<e;n++){for(t=0;t<e;t++)a.set(n,t,0);a.set(n,n,s[n]),i[n]>0?a.set(n,n+1,i[n]):i[n]<0&&a.set(n,n-1,i[n])}return a}}function tred2(n,t,e,i){let s,a,r,o,l,f,g,u;for(l=0;l<n;l++)e[l]=i.get(n-1,l);for(o=n-1;o>0;o--){for(u=0,r=0,f=0;f<o;f++)u+=Math.abs(e[f]);if(0===u)for(t[o]=e[o-1],l=0;l<o;l++)e[l]=i.get(o-1,l),i.set(o,l,0),i.set(l,o,0);else{for(f=0;f<o;f++)e[f]/=u,r+=e[f]*e[f];for(s=e[o-1],a=Math.sqrt(r),s>0&&(a=-a),t[o]=u*a,r-=s*a,e[o-1]=s-a,l=0;l<o;l++)t[l]=0;for(l=0;l<o;l++){for(s=e[l],i.set(l,o,s),a=t[l]+i.get(l,l)*s,f=l+1;f<=o-1;f++)a+=i.get(f,l)*e[f],t[f]+=i.get(f,l)*s;t[l]=a}for(s=0,l=0;l<o;l++)t[l]/=r,s+=t[l]*e[l];for(g=s/(r+r),l=0;l<o;l++)t[l]-=g*e[l];for(l=0;l<o;l++){for(s=e[l],a=t[l],f=l;f<=o-1;f++)i.set(f,l,i.get(f,l)-(s*t[f]+a*e[f]));e[l]=i.get(o-1,l),i.set(o,l,0)}}e[o]=r}for(o=0;o<n-1;o++){if(i.set(n-1,o,i.get(o,o)),i.set(o,o,1),r=e[o+1],0!==r){for(f=0;f<=o;f++)e[f]=i.get(f,o+1)/r;for(l=0;l<=o;l++){for(a=0,f=0;f<=o;f++)a+=i.get(f,o+1)*i.get(f,l);for(f=0;f<=o;f++)i.set(f,l,i.get(f,l)-a*e[f])}}for(f=0;f<=o;f++)i.set(f,o+1,0)}for(l=0;l<n;l++)e[l]=i.get(n-1,l),i.set(n-1,l,0);i.set(n-1,n-1,1),t[0]=0}function tql2(n,t,e,i){let s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m;for(r=1;r<n;r++)t[r-1]=t[r];t[n-1]=0;let A=0,C=0,T=Number.EPSILON;for(f=0;f<n;f++){for(C=Math.max(C,Math.abs(e[f])+Math.abs(t[f])),g=f;g<n&&!(Math.abs(t[g])<=T*C);)g++;if(g>f)do{for(s=e[f],u=(e[f+1]-s)/(2*t[f]),d=hypotenuse(u,1),u<0&&(d=-d),e[f]=t[f]/(u+d),e[f+1]=t[f]*(u+d),c=e[f+1],a=s-e[f],r=f+2;r<n;r++)e[r]-=a;for(A+=a,u=e[g],h=1,b=h,D=h,H=t[f+1],j=0,m=0,r=g-1;r>=f;r--)for(D=b,b=h,m=j,s=h*t[r],a=h*u,d=hypotenuse(u,t[r]),t[r+1]=j*d,j=t[r]/d,h=u/d,u=h*e[r]-j*s,e[r+1]=a+j*(h*s+j*e[r]),l=0;l<n;l++)a=i.get(l,r+1),i.set(l,r+1,j*i.get(l,r)+h*a),i.set(l,r,h*i.get(l,r)-j*a);u=-j*m*D*H*t[f]/c,t[f]=j*u,e[f]=h*u}while(Math.abs(t[f])>T*C);e[f]=e[f]+A,t[f]=0}for(r=0;r<n-1;r++){for(l=r,u=e[r],o=r+1;o<n;o++)e[o]<u&&(l=o,u=e[o]);if(l!==r)for(e[l]=e[r],e[r]=u,o=0;o<n;o++)u=i.get(o,r),i.set(o,r,i.get(o,l)),i.set(o,l,u)}}function orthes(n,t,e,i){let s,a,r,o,l,f,g,u=n-1;for(f=1;f<=u-1;f++){for(g=0,o=f;o<=u;o++)g+=Math.abs(t.get(o,f-1));if(0!==g){for(r=0,o=u;o>=f;o--)e[o]=t.get(o,f-1)/g,r+=e[o]*e[o];for(a=Math.sqrt(r),e[f]>0&&(a=-a),r-=e[f]*a,e[f]=e[f]-a,l=f;l<n;l++){for(s=0,o=u;o>=f;o--)s+=e[o]*t.get(o,l);for(s/=r,o=f;o<=u;o++)t.set(o,l,t.get(o,l)-s*e[o])}for(o=0;o<=u;o++){for(s=0,l=u;l>=f;l--)s+=e[l]*t.get(o,l);for(s/=r,l=f;l<=u;l++)t.set(o,l,t.get(o,l)-s*e[l])}e[f]=g*e[f],t.set(f,f-1,g*a)}}for(o=0;o<n;o++)for(l=0;l<n;l++)i.set(o,l,o===l?1:0);for(f=u-1;f>=1;f--)if(0!==t.get(f,f-1)){for(o=f+1;o<=u;o++)e[o]=t.get(o,f-1);for(l=f;l<=u;l++){for(a=0,o=f;o<=u;o++)a+=e[o]*i.get(o,l);for(a=a/e[f]/t.get(f,f-1),o=f;o<=u;o++)i.set(o,l,i.get(o,l)+a*e[o])}}}function hqr2(n,t,e,i,s){let a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A=n-1,C=n-1,T=Number.EPSILON,p=0,I=0,P=0,M=0,w=0,N=0,L=0,U=0;for(a=0;a<n;a++)for((a<0||a>C)&&(e[a]=s.get(a,a),t[a]=0),r=Math.max(a-1,0);r<n;r++)I+=Math.abs(s.get(a,r));for(;A>=0;){for(l=A;l>0&&(N=Math.abs(s.get(l-1,l-1))+Math.abs(s.get(l,l)),0===N&&(N=I),!(Math.abs(s.get(l,l-1))<T*N));)l--;if(l===A)s.set(A,A,s.get(A,A)+p),e[A]=s.get(A,A),t[A]=0,A--,U=0;else if(l===A-1){if(u=s.get(A,A-1)*s.get(A-1,A),P=(s.get(A-1,A-1)-s.get(A,A))/2,M=P*P+u,L=Math.sqrt(Math.abs(M)),s.set(A,A,s.get(A,A)+p),s.set(A-1,A-1,s.get(A-1,A-1)+p),d=s.get(A,A),M>=0){for(L=P>=0?P+L:P-L,e[A-1]=d+L,e[A]=e[A-1],0!==L&&(e[A]=d-u/L),t[A-1]=0,t[A]=0,d=s.get(A,A-1),N=Math.abs(d)+Math.abs(L),P=d/N,M=L/N,w=Math.sqrt(P*P+M*M),P/=w,M/=w,r=A-1;r<n;r++)L=s.get(A-1,r),s.set(A-1,r,M*L+P*s.get(A,r)),s.set(A,r,M*s.get(A,r)-P*L);for(a=0;a<=A;a++)L=s.get(a,A-1),s.set(a,A-1,M*L+P*s.get(a,A)),s.set(a,A,M*s.get(a,A)-P*L);for(a=0;a<=C;a++)L=i.get(a,A-1),i.set(a,A-1,M*L+P*i.get(a,A)),i.set(a,A,M*i.get(a,A)-P*L)}else e[A-1]=d+P,e[A]=d+P,t[A-1]=L,t[A]=-L;A-=2,U=0}else{if(d=s.get(A,A),c=0,u=0,l<A&&(c=s.get(A-1,A-1),u=s.get(A,A-1)*s.get(A-1,A)),10===U){for(p+=d,a=0;a<=A;a++)s.set(a,a,s.get(a,a)-d);N=Math.abs(s.get(A,A-1))+Math.abs(s.get(A-1,A-2)),d=c=.75*N,u=-.4375*N*N}if(30===U&&(N=(c-d)/2,N=N*N+u,N>0)){for(N=Math.sqrt(N),c<d&&(N=-N),N=d-u/((c-d)/2+N),a=0;a<=A;a++)s.set(a,a,s.get(a,a)-N);p+=N,d=c=u=.964}for(U+=1,f=A-2;f>=l&&(L=s.get(f,f),w=d-L,N=c-L,P=(w*N-u)/s.get(f+1,f)+s.get(f,f+1),M=s.get(f+1,f+1)-L-w-N,w=s.get(f+2,f+1),N=Math.abs(P)+Math.abs(M)+Math.abs(w),P/=N,M/=N,w/=N,f!==l)&&!(Math.abs(s.get(f,f-1))*(Math.abs(M)+Math.abs(w))<T*(Math.abs(P)*(Math.abs(s.get(f-1,f-1))+Math.abs(L)+Math.abs(s.get(f+1,f+1)))));)f--;for(a=f+2;a<=A;a++)s.set(a,a-2,0),a>f+2&&s.set(a,a-3,0);for(o=f;o<=A-1&&(j=o!==A-1,o!==f&&(P=s.get(o,o-1),M=s.get(o+1,o-1),w=j?s.get(o+2,o-1):0,d=Math.abs(P)+Math.abs(M)+Math.abs(w),0!==d&&(P/=d,M/=d,w/=d)),0!==d);o++)if(N=Math.sqrt(P*P+M*M+w*w),P<0&&(N=-N),0!==N){for(o!==f?s.set(o,o-1,-N*d):l!==f&&s.set(o,o-1,-s.get(o,o-1)),P+=N,d=P/N,c=M/N,L=w/N,M/=P,w/=P,r=o;r<n;r++)P=s.get(o,r)+M*s.get(o+1,r),j&&(P+=w*s.get(o+2,r),s.set(o+2,r,s.get(o+2,r)-P*L)),s.set(o,r,s.get(o,r)-P*d),s.set(o+1,r,s.get(o+1,r)-P*c);for(a=0;a<=Math.min(A,o+3);a++)P=d*s.get(a,o)+c*s.get(a,o+1),j&&(P+=L*s.get(a,o+2),s.set(a,o+2,s.get(a,o+2)-P*w)),s.set(a,o,s.get(a,o)-P),s.set(a,o+1,s.get(a,o+1)-P*M);for(a=0;a<=C;a++)P=d*i.get(a,o)+c*i.get(a,o+1),j&&(P+=L*i.get(a,o+2),i.set(a,o+2,i.get(a,o+2)-P*w)),i.set(a,o,i.get(a,o)-P),i.set(a,o+1,i.get(a,o+1)-P*M)}}}if(0!==I){for(A=n-1;A>=0;A--)if(P=e[A],M=t[A],0===M)for(l=A,s.set(A,A,1),a=A-1;a>=0;a--){for(u=s.get(a,a)-P,w=0,r=l;r<=A;r++)w+=s.get(a,r)*s.get(r,A);if(t[a]<0)L=u,N=w;else if(l=a,0===t[a]?s.set(a,A,0!==u?-w/u:-w/(T*I)):(d=s.get(a,a+1),c=s.get(a+1,a),M=(e[a]-P)*(e[a]-P)+t[a]*t[a],g=(d*N-L*w)/M,s.set(a,A,g),s.set(a+1,A,Math.abs(d)>Math.abs(L)?(-w-u*g)/d:(-N-c*g)/L)),g=Math.abs(s.get(a,A)),T*g*g>1)for(r=a;r<=A;r++)s.set(r,A,s.get(r,A)/g)}else if(M<0)for(l=A-1,Math.abs(s.get(A,A-1))>Math.abs(s.get(A-1,A))?(s.set(A-1,A-1,M/s.get(A,A-1)),s.set(A-1,A,-(s.get(A,A)-P)/s.get(A,A-1))):(m=cdiv(0,-s.get(A-1,A),s.get(A-1,A-1)-P,M),s.set(A-1,A-1,m[0]),s.set(A-1,A,m[1])),s.set(A,A-1,0),s.set(A,A,1),a=A-2;a>=0;a--){for(h=0,b=0,r=l;r<=A;r++)h+=s.get(a,r)*s.get(r,A-1),b+=s.get(a,r)*s.get(r,A);if(u=s.get(a,a)-P,t[a]<0)L=u,w=h,N=b;else if(l=a,0===t[a]?(m=cdiv(-h,-b,u,M),s.set(a,A-1,m[0]),s.set(a,A,m[1])):(d=s.get(a,a+1),c=s.get(a+1,a),D=(e[a]-P)*(e[a]-P)+t[a]*t[a]-M*M,H=2*(e[a]-P)*M,0===D&&0===H&&(D=T*I*(Math.abs(u)+Math.abs(M)+Math.abs(d)+Math.abs(c)+Math.abs(L))),m=cdiv(d*w-L*h+M*b,d*N-L*b-M*h,D,H),s.set(a,A-1,m[0]),s.set(a,A,m[1]),Math.abs(d)>Math.abs(L)+Math.abs(M)?(s.set(a+1,A-1,(-h-u*s.get(a,A-1)+M*s.get(a,A))/d),s.set(a+1,A,(-b-u*s.get(a,A)-M*s.get(a,A-1))/d)):(m=cdiv(-w-c*s.get(a,A-1),-N-c*s.get(a,A),L,M),s.set(a+1,A-1,m[0]),s.set(a+1,A,m[1]))),g=Math.max(Math.abs(s.get(a,A-1)),Math.abs(s.get(a,A))),T*g*g>1)for(r=a;r<=A;r++)s.set(r,A-1,s.get(r,A-1)/g),s.set(r,A,s.get(r,A)/g)}for(a=0;a<n;a++)if(a<0||a>C)for(r=a;r<n;r++)i.set(a,r,s.get(a,r));for(r=n-1;r>=0;r--)for(a=0;a<=C;a++){for(L=0,o=0;o<=Math.min(r,C);o++)L+=i.get(a,o)*s.get(o,r);i.set(a,r,L)}}}function cdiv(n,t,e,i){let s,a;return Math.abs(e)>Math.abs(i)?(s=i/e,a=e+s*i,[(n+s*t)/a,(t-s*n)/a]):(s=e/i,a=i+s*e,[(s*n+t)/a,(s*t-n)/a])}class CholeskyDecomposition{constructor(n){if(!(n=WrapperMatrix2D.checkMatrix(n)).isSymmetric())throw new Error("Matrix is not symmetric");let t,e,i,s=n,a=s.rows,r=new Matrix$2(a,a),o=!0;for(e=0;e<a;e++){let n=0;for(i=0;i<e;i++){let a=0;for(t=0;t<i;t++)a+=r.get(i,t)*r.get(e,t);a=(s.get(e,i)-a)/r.get(i,i),r.set(e,i,a),n+=a*a}for(n=s.get(e,e)-n,o&=n>0,r.set(e,e,Math.sqrt(Math.max(n,0))),i=e+1;i<a;i++)r.set(e,i,0)}this.L=r,this.positiveDefinite=Boolean(o)}isPositiveDefinite(){return this.positiveDefinite}solve(n){n=WrapperMatrix2D.checkMatrix(n);let t=this.L,e=t.rows;if(n.rows!==e)throw new Error("Matrix dimensions do not match");if(!1===this.isPositiveDefinite())throw new Error("Matrix is not positive definite");let i,s,a,r=n.columns,o=n.clone();for(a=0;a<e;a++)for(s=0;s<r;s++){for(i=0;i<a;i++)o.set(a,s,o.get(a,s)-o.get(i,s)*t.get(a,i));o.set(a,s,o.get(a,s)/t.get(a,a))}for(a=e-1;a>=0;a--)for(s=0;s<r;s++){for(i=a+1;i<e;i++)o.set(a,s,o.get(a,s)-o.get(i,s)*t.get(i,a));o.set(a,s,o.get(a,s)/t.get(a,a))}return o}get lowerTriangularMatrix(){return this.L}}class nipals{constructor(n,t={}){n=WrapperMatrix2D.checkMatrix(n);let{Y:e}=t;const{scaleScores:i=!1,maxIterations:s=1e3,terminationCriteria:a=1e-10}=t;let r;if(e){if(e=isAnyArray.isAnyArray(e)&&"number"==typeof e[0]?Matrix$2.columnVector(e):WrapperMatrix2D.checkMatrix(e),e.rows!==n.rows)throw new Error("Y should have the same number of rows as X");r=e.getColumnVector(0)}else r=n.getColumnVector(0);let o,l,f,g,u=1;for(let t=0;t<s&&u>a;t++)f=n.transpose().mmul(r).div(r.transpose().mmul(r).get(0,0)),f=f.div(f.norm()),o=n.mmul(f).div(f.transpose().mmul(f).get(0,0)),t>0&&(u=o.clone().sub(g).pow(2).sum()),g=o.clone(),e?(l=e.transpose().mmul(o).div(o.transpose().mmul(o).get(0,0)),l=l.div(l.norm()),r=e.mmul(l).div(l.transpose().mmul(l).get(0,0))):r=o;if(e){let t=n.transpose().mmul(o).div(o.transpose().mmul(o).get(0,0));t=t.div(t.norm());let i=n.clone().sub(o.clone().mmul(t.transpose())),s=r.transpose().mmul(o).div(o.transpose().mmul(o).get(0,0)),a=e.clone().sub(o.clone().mulS(s.get(0,0)).mmul(l.transpose()));this.t=o,this.p=t.transpose(),this.w=f.transpose(),this.q=l,this.u=r,this.s=o.transpose().mmul(o),this.xResidual=i,this.yResidual=a,this.betas=s}else this.w=f.transpose(),this.s=o.transpose().mmul(o).sqrt(),this.t=i?o.clone().div(this.s.get(0,0)):o,this.xResidual=n.sub(o.mmul(f.transpose()))}}matrix.AbstractMatrix=AbstractMatrix,matrix.CHO=CholeskyDecomposition,matrix.CholeskyDecomposition=CholeskyDecomposition,matrix.DistanceMatrix=DistanceMatrix;var EVD$1=matrix.EVD=EigenvalueDecomposition;matrix.EigenvalueDecomposition=EigenvalueDecomposition,matrix.LU=LuDecomposition,matrix.LuDecomposition=LuDecomposition;var Matrix_1=matrix.Matrix=Matrix$2;matrix.MatrixColumnSelectionView=MatrixColumnSelectionView,matrix.MatrixColumnView=MatrixColumnView,matrix.MatrixFlipColumnView=MatrixFlipColumnView,matrix.MatrixFlipRowView=MatrixFlipRowView,matrix.MatrixRowSelectionView=MatrixRowSelectionView,matrix.MatrixRowView=MatrixRowView,matrix.MatrixSelectionView=MatrixSelectionView,matrix.MatrixSubView=MatrixSubView;var MatrixTransposeView_1=matrix.MatrixTransposeView=MatrixTransposeView$1;matrix.NIPALS=nipals,matrix.Nipals=nipals,matrix.QR=QrDecomposition,matrix.QrDecomposition=QrDecomposition;var SVD$1=matrix.SVD=SingularValueDecomposition;matrix.SingularValueDecomposition=SingularValueDecomposition,matrix.SymmetricMatrix=SymmetricMatrix,matrix.WrapperMatrix1D=WrapperMatrix1D,matrix.WrapperMatrix2D=WrapperMatrix2D,matrix.correlation=correlation,matrix.covariance=covariance;var _default=matrix.default=Matrix$2;matrix.determinant=determinant;var inverse_1=matrix.inverse=inverse$1;matrix.linearDependencies=linearDependencies,matrix.pseudoInverse=pseudoInverse;var solve_1=matrix.solve=solve$1;matrix.wrap=wrap;const EVD=EVD$1,Matrix=Matrix_1,MatrixTransposeView=MatrixTransposeView_1,SVD=SVD$1;var Matrix$1=_default.Matrix?_default.Matrix:Matrix_1;const inverse=inverse_1,solve=solve_1;function xEnsureFloat64(n){return xCheck(n),n instanceof Float64Array?n.slice(0):Float64Array.from(n)}function xFindClosestIndex(n,t,e={}){const{sorted:i=!0}=e;if(i){let e=0,i=n.length-1,s=0;for(;i-e>1;)if(s=e+(i-e>>1),n[s]<t)e=s;else{if(!(n[s]>t))return s;i=s}return e<n.length-1?Math.abs(t-n[e])<Math.abs(n[e+1]-t)?e:e+1:e}{let e=0,i=Number.POSITIVE_INFINITY;for(let s=0;s<n.length;s++){const a=Math.abs(n[s]-t);a<i&&(i=a,e=s)}return e}}function xGetFromToIndex(n,t={}){let{fromIndex:e,toIndex:i}=t;const{from:s,to:a}=t;return void 0===e&&(e=void 0!==s?xFindClosestIndex(n,s):0),void 0===i&&(i=void 0!==a?xFindClosestIndex(n,a):n.length-1),e<0&&(e=0),i<0&&(i=0),e>=n.length&&(e=n.length-1),i>=n.length&&(i=n.length-1),e>i&&([e,i]=[i,e]),{fromIndex:e,toIndex:i}}function xMaxValue(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let s=n[e];for(let t=e+1;t<=i;t++)n[t]>s&&(s=n[t]);return s}function xMinValue(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let s=n[e];for(let t=e+1;t<=i;t++)n[t]<s&&(s=n[t]);return s}function xIsEquallySpaced(n,t={}){if(n.length<3)return!0;const{tolerance:e=.05}=t;let i=0,s=Number.MAX_SAFE_INTEGER;for(let t=0;t<n.length-1;++t){const e=n[t+1]-n[t];e<s&&(s=e),e>i&&(i=e)}return(i-s)/i<e}function xIsMonotonic(n){if(n.length<=2)return 1;if(n[0]===n[1]){for(let t=1;t<n.length-1;t++)if(n[t]!==n[t+1])return 0;return 1}if(n[0]<n[n.length-1]){for(let t=0;t<n.length-1;t++)if(n[t]>=n[t+1])return 0;return 1}for(let t=0;t<n.length-1;t++)if(n[t]<=n[t+1])return 0;return-1}function xMean(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let s=n[e];for(let t=e+1;t<=i;t++)s+=n[t];return s/(i-e+1)}function xMedianAbsoluteDeviation(n){const t=xMedian(n),e=new Float64Array(n.length);for(let i=0;i<n.length;i++)e[i]=Math.abs(n[i]-t);return{median:t,mad:xMedian(e)}}function xMinMaxValues(n){xCheck(n);let t=n[0],e=n[0];for(const i of n)i<t&&(t=i),i>e&&(e=i);return{min:t,max:e}}function xNoiseStandardDeviation(n){const{mad:t,median:e}=xMedianAbsoluteDeviation(n);return{sd:t/.6744897501960817,mad:t,median:e}}function xNorm(n){let t=0;for(const e of n)t+=e**2;return Math.sqrt(t)}function xSum(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let s=n[e];for(let t=e+1;t<=i;t++)s+=n[t];return s}function xNormed(n,t={}){const{algorithm:e="absolute",value:i=1}=t;xCheck(n);const s=getOutputArray(t.output,n.length);if(0===n.length)throw new Error("input must not be empty");switch(e.toLowerCase()){case"absolute":{const t=absoluteSum(n)/i;if(0===t)throw new Error("xNormed: trying to divide by 0");for(let e=0;e<n.length;e++)s[e]=n[e]/t;return s}case"max":{const t=xMaxValue(n);if(0===t)throw new Error("xNormed: trying to divide by 0");const e=i/t;for(let t=0;t<n.length;t++)s[t]=n[t]*e;return s}case"sum":{const t=xSum(n)/i;if(0===t)throw new Error("xNormed: trying to divide by 0");for(let e=0;e<n.length;e++)s[e]=n[e]/t;return s}default:throw new Error(`norm: unknown algorithm: ${e}`)}}function absoluteSum(n){let t=0;for(let e=0;e<n.length;e++)t+=Math.abs(n[e]);return t}function xPadding(n,t={}){const{size:e=0,value:i=0,algorithm:s=""}=t;if(xCheck(n),!s)return n instanceof Float64Array?n.slice():Float64Array.from(n);const a=new Float64Array(n.length+2*e);for(let t=0;t<n.length;t++)a[t+e]=n[t];const r=e+n.length,o=2*e+n.length;switch(s.toLowerCase()){case"value":for(let n=0;n<e;n++)a[n]=i;for(let n=r;n<o;n++)a[n]=i;break;case"duplicate":for(let t=0;t<e;t++)a[t]=n[0];for(let t=r;t<o;t++)a[t]=n[n.length-1];break;case"circular":for(let t=0;t<e;t++)a[t]=n[(n.length-e%n.length+t)%n.length];for(let t=0;t<e;t++)a[t+r]=n[t%n.length];break;default:throw new Error("xPadding: unknown algorithm")}return a}function xVariance(n,t={}){if(!isAnyArray$1(n))throw new TypeError("input must be an array");const{unbiased:e=!0,mean:i=xMean(n)}=t;let s=0;for(let t=0;t<n.length;t++){const e=n[t]-i;s+=e*e}return e?s/(n.length-1):s/n.length}function xStandardDeviation(n,t={}){return Math.sqrt(xVariance(n,t))}function xParetoNormalization(n){xCheck(n);const t=[],e=Math.sqrt(xStandardDeviation(n));for(const i of n)t.push(i/e);return t}function xRescale(n,t={}){xCheck(n);const e=getOutputArray(t.output,n.length),i=xMinValue(n),s=xMaxValue(n);if(i===s)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");const{min:a=0,max:r=1}=t;if(a>=r)throw new RangeError("min option must be smaller than max option");const o=(r-a)/(s-i);for(let t=0;t<n.length;t++)e[t]=(n[t]-i)*o+a;return e}function xRolling(n,t,e={}){if(xCheck(n),"function"!=typeof t)throw new Error("fct has to be a function");const{window:i=5,padding:s={}}=e,{size:a=i-1,algorithm:r,value:o}=s;n=xPadding(n,{size:a,algorithm:r,value:o});const l=[];for(let e=0;e<n.length-i+1;e++)l.push(t(n.subarray(e,e+i)));return l}function xRollingAverage(n,t={}){return xRolling(n,xMean,t)}function xRollingMedian(n,t={}){return xRolling(n,xMedian,t)}function xSequentialFill(n=[],t={}){if("object"!=typeof n||isAnyArray$1(n)||(t=n,n=[]),!isAnyArray$1(n))throw new TypeError("input must be an array");const{to:e=10}=t;let{from:i=0,size:s=(Array.isArray(n)||n.constructor===Float64Array||n.constructor===Uint16Array?n.length:0),step:a=null}=t;if(s||(s=a?Math.floor((e-i)/a)+1:e-i+1),!a&&s&&(a=(e-i)/(s-1)),Array.isArray(n)){n.length=0;for(let t=0;t<s;t++)n.push(i),a&&(i+=a)}else{if(Array.isArray(n)||n.constructor===Float64Array||n.constructor===Uint16Array&&n.length!==s)throw new Error("sequentialFill typed array must have the correct length");for(let t=0;t<s;t++)(Array.isArray(n)||n.constructor===Float64Array||n.constructor===Uint16Array)&&(n[t]=i),a&&(i+=a)}return Array.isArray(n)||n.constructor===Float64Array||n.constructor===Uint16Array?Array.from(n):[]}function xSubtract(n,t){let e=!1,i=0;if(isAnyArray$1(t)){if(n.length!==t.length)throw new Error("xSubtract: size of array1 and array2 must be identical")}else e=!0,i=Number(t);const s=new Float64Array(n.length);if(e)for(let t=0;t<n.length;t++)s[t]=n[t]-i;else for(let e=0;e<n.length;e++)s[e]=n[e]-t[e];return s}function xyCheck(n,t={}){const{minLength:e}=t;if("object"!=typeof n||!isAnyArray$1(n.x)||!isAnyArray$1(n.y))throw new Error("Data must be an object of x and y arrays");if(n.x.length!==n.y.length)throw new Error("The x and y arrays must have the same length");if(e&&n.x.length<e)throw new Error(`data.x must have a length of at least ${e}`)}function xyFindClosestPoint(n,t){const{x:e,y:i}=n,s=xFindClosestIndex(e,t);return{x:e[s],y:i[s]}}function xyEnsureGrowingX(n){if(xyCheck(n),1===xIsMonotonic(n.x))return n;const t=Array.from(n.x),e=Array.from(n.y);let i=Number.NEGATIVE_INFINITY,s=0;for(let n=0;n<t.length;n++)i<t[n]&&(s<n&&(t[s]=t[n],e[s]=e[n]),s++,i=t[n]);return t.length=s,e.length=s,{x:t,y:e}}function zonesNormalize(n=[],t={}){const{exclusions:e=[]}=t;let{from:i=Number.NEGATIVE_INFINITY,to:s=Number.POSITIVE_INFINITY}=t;i>s&&([i,s]=[s,i]),0===(n=(n=JSON.parse(JSON.stringify(n)).map((n=>n.from>n.to?{from:n.to,to:n.from}:n))).sort(((n,t)=>n.from!==t.from?n.from-t.from:n.to-t.to))).length&&n.push({from:i,to:s});for(const t of n)i>t.from&&(t.from=i),s<t.to&&(t.to=s);if(0===(n=n.filter((n=>n.from<=n.to))).length)return[];let a=n[0];const r=[a];for(let t=1;t<n.length;t++){const e=n[t];e.from<=a.to?a.to<e.to&&(a.to=e.to):(a=e,r.push(a))}if(0===e.length)return r;const o=zonesNormalize(e);let l=0;const f=[];let g=0;for(let n=0;n<r.length&&!(g++>5);n++){const t=r[n];if(l!==o.length){for(;l<o.length&&o[l].to<=t.from;)l++;if(l!==o.length)if(t.to<o[l].from)f.push(t);else{if(o[l].to>=t.to){if(o[l].from<=t.from)continue;f.push({from:o[l].to,to:t.to})}o[l].from>t.from&&f.push({from:t.from,to:o[l].from}),t.from=o[l].to,n--}else f.push(t)}else f.push(t)}return f}function zonesWithPoints(n=[],t=10,e={}){if(0===n.length)return n;const i=zonesNormalize(n,e),s=i.reduce(((n,t)=>n+(t.to-t.from)),0)/t;let a=0;for(let n=0;n<i.length-1;n++){const e=i[n];e.numberOfPoints=Math.min(Math.round((e.to-e.from)/s),t-a),a+=e.numberOfPoints}return i[i.length-1].numberOfPoints=t-a,i}function equallySpacedSlot(n,t,e,i,s){const a=n.length,r=(i-e)/(s>1?s-1:1),o=r/2,l=n[n.length-1]-n[n.length-2],f=e-o,g=new Float64Array(s);let u=f,d=f+r,c=-Number.MAX_VALUE,h=0,b=n[0],D=t[0],H=0,j=!0,m=0,A=0,C=1,T=0;n:for(;;){if(c>=b)throw new Error("x must be a growing series");for(;c-d>0;){if(j&&(A++,j=!1),g[T]=A<=0?0:m/A,T++,T===s)break n;u=d,d+=r,m=0,A=0}c>u&&(m+=h,A++),(c===-Number.MAX_VALUE||H>1)&&A--,c=b,h=D,C<a?(b=n[C],D=t[C],C++):(b+=l,D=0,H++)}return g}function integral(n,t,e,i){return.5*e*t*t+i*t-(.5*e*n*n+i*n)}function equallySpacedSmooth(n,t,e,i,s){const a=n.length,r=(i-e)/(s>1?s-1:1),o=r/2,l=new Float64Array(s),f=n[1]-n[0],g=n[a-1]-n[a-2];let u=e-o,d=e+o,c=Number.MIN_SAFE_INTEGER,h=0,b=n[0]-f,D=0,H=0,j=0,m=0,A=0,C=0,T=0,p=0,I=0;n:for(;;){if(c>=b)throw new Error("x must be a growing series");for(c<=u&&u<=b&&(I=integral(0,u-c,j,h),A=H+I);b-d>=0;){if(I=integral(0,d-c,j,h),C=H+I,l[p++]=(C-A)/r,p===s)break n;u=d,d+=r,A=C}H+=integral(c,b,j,m),c=b,h=D,T<a?(b=n[T],D=t[T],T++):T===a&&(b+=g,D=0),j=getSlope(c,h,b,D),m=-j*c+h}return l}function getSlope(n,t,e,i){return(i-t)/(e-n)}function xyEquallySpaced(n,t={}){const{x:e,y:i}=n,s=e.length,{from:a=e[0],to:r=e[s-1],variant:o="smooth",numberOfPoints:l=100,exclusions:f=[],zones:g=[{from:a,to:r}]}=t;if(a>r)throw new RangeError("from should be larger than to");if(xyCheck(n),l<2)throw new RangeError("'numberOfPoints' option must be greater than 1");const u=zonesWithPoints(zonesNormalize(g,{from:a,to:r,exclusions:f}),l,{from:a,to:r});let d=[],c=[];for(const n of u){n.numberOfPoints||(n.numberOfPoints=0);const t=processZone(Array.from(e),Array.from(i),n.from,n.to,n.numberOfPoints,o);d=d.concat(t.x),c=c.concat(t.y)}return{x:d,y:c}}function processZone(n,t,e,i,s,a){if(s<1)throw new RangeError("the number of points must be at least 1");const r="slot"===a?Array.from(equallySpacedSlot(n,t,e,i,s)):Array.from(equallySpacedSmooth(n,t,e,i,s));return{x:Array.from(createFromToArray({from:e,to:i,length:s})),y:r}}function xyExtract(n,t={}){xyCheck(n);const{x:e,y:i}=n;let{zones:s}=t;if(s=zonesNormalize(s),void 0===e||void 0===i||!Array.isArray(s)||0===s.length)return n;const a=[],r=[];let o=s[0],l=0;n:for(let n=0;n<e.length;n++){for(;o.to<e[n];)if(l++,o=s[l],!o){n=e.length;break n}e[n]>=o.from&&(a.push(e[n]),r.push(i[n]))}return{x:a,y:r}}function xyFilterX(n,t={}){const{x:e,y:i}=n,{from:s=e[0],to:a=e[e.length-1],zones:r=[{from:s,to:a}],exclusions:o=[]}=t,l=zonesNormalize(r,{from:s,to:a,exclusions:o});let f=0;const g=[],u=[];let d=0;for(;d<e.length;){if(e[d]<=l[f].to&&e[d]>=l[f].from)g.push(e[d]),u.push(i[d]);else if(e[d]>l[f].to&&(f++,!l[f]))break;d++}return{x:g,y:u}}function xyIntegration(n,t={}){xyCheck(n,{minLength:1});const{x:e,y:i}=n;if(1===e.length)return 0;const{fromIndex:s,toIndex:a}=xGetFromToIndex(e,t);let r=0;for(let n=s;n<a;n++)r+=(e[n+1]-e[n])*(i[n+1]+i[n])/2;return r}function xySetYValue(n,t={}){xyCheck(n);const{x:e,y:i}=n,{value:s=0}=t;let{zones:a}=t;if(!Array.isArray(a)||0===a.length)return n;a=zonesNormalize(a);const r=e.slice(),o=i.slice();let l=a[0],f=0;n:for(let n=0;n<e.length;n++){for(;l.to<e[n];)if(f++,l=a[f],!l){n=e.length;break n}e[n]>=l.from&&(o[n]=s)}return{x:r,y:o}}function matrixCreateEmpty(n){const{matrix:t,nbRows:e=t?.length||1,nbColumns:i=t?.[0].length||1,ArrayConstructor:s=Float64Array}=n,a=new Array(e);for(let n=0;n<e;n++)a[n]=new s(i);return a}function matrixCheck(n){if(0===n.length||0===n[0].length)throw new RangeError("matrix should contain data");const t=n[0].length;for(let e=1;e<n.length;e++)if(n[e].length!==t)throw new RangeError("All rows should has the same length")}function matrixMinMaxZ(n){matrixCheck(n);const t=n.length,e=n[0].length;let i=n[0][0],s=n[0][0];for(let a=0;a<e;a++)for(let e=0;e<t;e++)n[e][a]<i&&(i=n[e][a]),n[e][a]>s&&(s=n[e][a]);return{min:i,max:s}}const LOOP=8,FLOAT_MUL=1/16777216,sh1=15,sh2=18,sh3=11;function multiply_uint32(n,t){const e=65535&(n>>>=0);return((n-e)*(t>>>=0)>>>0)+e*t>>>0}class XSadd{constructor(n=Date.now()){this.state=new Uint32Array(4),this.init(n),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*FLOAT_MUL}init(n){if(!Number.isInteger(n))throw new TypeError("seed must be an integer");this.state[0]=n,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let n=1;n<LOOP;n++)this.state[3&n]^=n+multiply_uint32(1812433253,this.state[n-1&3]^this.state[n-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let n=0;n<LOOP;n++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let n=this.state[0];n^=n<<sh1,n^=n>>>sh2,n^=this.state[3]<<sh3,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=n}}let spare,hasSpare=!1;function createRandomArray(n={}){const{mean:t=0,standardDeviation:e=1,length:i=1e3,range:s=1,seed:a,distribution:r="normal"}=n,o=new XSadd(a),l=new Float64Array(i);switch(r){case"normal":for(let n=0;n<i;n++)l[n]=generateGaussian(t,e,o);break;case"uniform":for(let n=0;n<i;n++)l[n]=(o.random()-.5)*s+t;break;default:throw new Error(`unknown distribution: ${r}`)}return l}function generateGaussian(n,t,e){let i,s,a,r;if(hasSpare)hasSpare=!1,i=spare*t+n;else{do{s=2*e.random()-1,a=2*e.random()-1,r=s*s+a*a}while(r>=1||0===r);r=Math.sqrt(-2*Math.log(r)/r),spare=a*r,hasSpare=!0,i=n+t*s*r}return i}function addNoise(n,t={}){const{seed:e=0,distribution:i="normal",percent:s=1}=t,a=xMaxValue(n.y)*s/100,r=createRandomArray({distribution:i,seed:e,mean:0,standardDeviation:a,range:a,length:n.x.length});return n.y=xAdd(n.y,r),n}class SpectrumGenerator{constructor(n={}){const{from:t=0,to:e=1e3,nbPoints:i=10001,peakWidthFct:s,shape:a={kind:"gaussian",fwhm:5}}=n;this.from=t,this.to=e,this.nbPoints=i,this.interval=(this.to-this.from)/(this.nbPoints-1),this.peakWidthFct=s,this.maxPeakHeight=Number.MIN_SAFE_INTEGER,this.data={x:new Float64Array(this.nbPoints),y:new Float64Array(this.nbPoints)};let r=getShape1D(a);if(this.shape=r,assertNumber$2(this.from,"from"),assertNumber$2(this.to,"to"),assertInteger$1(this.nbPoints,"nbPoints"),this.to<=this.from)throw new RangeError("to option must be larger than from");if(this.peakWidthFct&&"function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(n,t){if(!(Array.isArray(n)||"object"==typeof n&&void 0!==n.x&&void 0!==n.y&&Array.isArray(n.x)&&Array.isArray(n.y)&&n.x.length===n.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(n))for(const e of n)this.addPeak(e,t);else for(let e=0;e<n.x.length;e++)this.addPeak([n.x[e],n.y[e]],t)}addPeak(n,t={}){if(Array.isArray(n)&&n.length<2)throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");if(!Array.isArray(n)&&(void 0===n.x||void 0===n.y))throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");let e,i,s,a,r;Array.isArray(n)?[e,i,s,r]=n:(e=n.x,i=n.y,a=n.width,r=n.shape),i>this.maxPeakHeight&&(this.maxPeakHeight=i);let{shape:o}=t;r&&(o=o?{...o,...r}:r);const l=o?getShape1D(o):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),this.shape);let{width:f,widthLeft:g,widthRight:u}=t;const d=void 0!==s?s:a?l.widthToFWHM(a):this.peakWidthFct?this.peakWidthFct(e):void 0!==f?f:l.fwhm;if(g||(g=d),u||(u=d),!g||!u)throw new Error("Width left or right is undefined or zero");let c=void 0===t.factor?l.getFactor():t.factor;const h=e-g/2*c,b=e+u/2*c,D=Math.max(0,Math.floor((h-this.from)/this.interval)),H=Math.min(this.nbPoints-1,Math.ceil((b-this.from)/this.interval)),j=Math.round((e-this.from)/this.interval);l.fwhm=g;for(let n=D;n<Math.max(j,0);n++)this.data.y[n]+=i*l.fct(this.data.x[n]-e);l.fwhm=u;for(let n=Math.min(j,H);n<=H;n++)this.data.y[n]+=i*l.fct(this.data.x[n]-e)}addBaseline(n){return addBaseline(this.data,n),this}addNoise(n){return addNoise(this.data,n),this}getSpectrum(n={}){"boolean"==typeof n&&(n={copy:n});const{copy:t=!0,threshold:e=0}=n;if(e){let n=this.maxPeakHeight*e,t=[],i=[];for(let e=0;e<this.data.x.length;e++)this.data.y[e]>=n&&(t.push(this.data.x[e]),i.push(this.data.y[e]));return{x:Float64Array.from(t),y:Float64Array.from(i)}}return t?{x:this.data.x.slice(),y:this.data.y.slice()}:this.data}reset(){const n=this.data;for(let t=0;t<this.nbPoints;t++)n.x[t]=this.from+t*this.interval;return this}}function assertInteger$1(n,t){if(!Number.isInteger(n))throw new TypeError(`${t} option must be an integer`)}function assertNumber$2(n,t){if(!Number.isFinite(n))throw new TypeError(`${t} option must be a number`)}function generateSpectrum(n,t={}){const{generator:e,noise:i,baseline:s,threshold:a,peakOptions:r}=t,o=new SpectrumGenerator(e);return o.addPeaks(n,r),s&&o.addBaseline(s),i&&o.addNoise(i),o.getSpectrum({threshold:a})}const axis2D=["x","y"],peakCoordinates=["x","y","z"],convertWidthToFWHM=(n,t)=>{const e=ensureXYNumber$1(t);for(let t of axis2D)e[t]=n.widthToFWHM(e[t]);return e};class Spectrum2DGenerator{constructor(n={}){let{from:t=0,to:e=100,nbPoints:i=1001,peakWidthFct:s=(()=>5),shape:a={kind:"gaussian"}}=n;t=ensureXYNumber$1(t),e=ensureXYNumber$1(e),i=ensureXYNumber$1(i);for(const n of axis2D)assertNumber$1(t[n],`from-${n}`),assertNumber$1(e[n],`to-${n}`),assertInteger(i[n],`nbPoints-${n}`);this.from=t,this.to=e,this.nbPoints=i,this.interval=calculeIntervals(t,e,i),this.peakWidthFct=s,this.maxPeakHeight=Number.MIN_SAFE_INTEGER;let r=getShape2D(a);this.shape=r,this.data={x:new Float64Array(i.x),y:new Float64Array(i.y),z:createMatrix(this.nbPoints)};for(const n of axis2D)if(this.to[n]<=this.from[n])throw new RangeError("to option must be larger than from");if("function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(n,t){if(!(Array.isArray(n)||"object"==typeof n&&void 0!==n.x&&void 0!==n.y&&Array.isArray(n.x)&&Array.isArray(n.y)&&n.x.length===n.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(n))for(const e of n)this.addPeak(e,t);else{let e=n.x.length;for(const t of peakCoordinates)if(n[t]&&Array.isArray(n[t])&&e!==n[t].length)throw new Error("x, y, z should have the same length");for(let e=0;e<n.x.length;e++)this.addPeak([n.x[e],n.y[e],n.z[e]],t)}return this}addPeak(n,t={}){if(Array.isArray(n)&&n.length<3)throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");if(!Array.isArray(n)&&peakCoordinates.some((t=>void 0===n[t])))throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");let e,i,s,a,r,o;Array.isArray(n)?[e,i,s,a,o]=n:(e=n.x,i=n.y,s=n.z,a=n.fwhm,r=n.width,o=n.shape);const l={x:e,y:i};s>this.maxPeakHeight&&(this.maxPeakHeight=s);let{shape:f,width:g}=t;o&&(f=f?{...f,...o}:o);const u=f?getShape2D(f):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),JSON.parse(JSON.stringify(this.shape)));let{fwhm:d=(void 0!==a?a:r?convertWidthToFWHM(u,r):g?convertWidthToFWHM(u,g):this.peakWidthFct(e,i))}=t;d=ensureXYNumber$1(d);let c=void 0===t.factor?u.getFactor():t.factor;c=ensureXYNumber$1(c);const h={x:0,y:0},b={x:0,y:0};for(const n of axis2D){const t=l[n]-d[n]/2*c[n],e=l[n]+d[n]/2*c[n];h[n]=Math.max(0,Math.floor((t-this.from[n])/this.interval[n])),b[n]=Math.min(this.nbPoints[n],Math.ceil((e-this.from[n])/this.interval[n]))}u.fwhm=d;for(let n=h.x;n<b.x;n++)for(let t=h.y;t<b.y;t++){const e=s*u.fct(this.data.x[n]-l.x,this.data.y[t]-l.y);e>1e-6&&(this.data.z[t][n]+=e)}return this}getSpectrum(n={}){"boolean"==typeof n&&(n={copy:n});const{copy:t=!0}=n;let e=matrixMinMaxZ(this.data.z);return{minX:this.from.x,maxX:this.to.x,maxY:this.to.y,minY:this.from.y,minZ:e.min,maxZ:e.max,z:t?this.data.z.slice():this.data.z}}reset(){const n=this.data;for(const t of axis2D)for(let e=0;e<this.nbPoints[t];e++)n[t][e]=this.from[t]+e*this.interval[t];for(let t of n.z)for(let n=0;n<t.length;n++)t[n]=0;return this}}function generateSpectrum2D(n,t={}){const{generator:e,peaks:i}=t,s=new Spectrum2DGenerator(e);return s.addPeaks(n,i),s.getSpectrum()}function ensureXYNumber$1(n){return"object"!=typeof n?{x:n,y:n}:{...n}}function calculeIntervals(n,t,e){return{x:(t.x-n.x)/(e.x-1),y:(t.y-n.y)/(e.y-1)}}function assertInteger(n,t){if(!Number.isInteger(n))throw new TypeError(`${t} option must be an integer`)}function assertNumber$1(n,t){if(!Number.isFinite(n))throw new TypeError(`${t} option must be a number`)}function createMatrix(n){const t=new Array(n.y);for(let e=0;e<n.y;e++)t[e]=new Float64Array(n.x);return t}function hasProperty(n,t){return t in n}const{parse:parse$7,stringify:stringify$7}=JSON;function convertWidth(n,t){const{frequency:e,convertTo:i,output:s=parse$7(stringify$7(n))}=t,a=getConverter(i,e);for(const n of s)if(n.width=a(n.width),hasProperty(n,"shape")){const t=n.shape;t.fwhm&&(t.fwhm=a(t.fwhm))}return s}function getConverter(n,t){switch(n){case"ppm":return n=>n/t;case"hz":return n=>n*t;default:throw new Error(`Does not support convert to ${n}`)}}function convertWidthToPPM(n,t){return convertWidth(n,{...t,convertTo:"ppm"})}function peaksToXY(n,t){const{frequency:e,nbPoints:i=1024,shape:s}=t;if(!e)throw new Error("frequency is mandatory");const a=convertWidthToPPM(n,{frequency:e});return generateSpectrum(a,{generator:{...getFromTo$1(a,t),nbPoints:i,shape:s}})}function getFromTo$1(n,t){if("to"in t&&"from"in t)return{from:t.from,to:t.to};n.sort(((n,t)=>n.x-t.x));const e=n[0],i=n[n.length-1],{from:s=e.x-2*e.width/t.frequency,to:a=i.x+2*i.width/t.frequency}=t;return{from:s,to:a}}for(var IDX=256,HEX=[],BUFFER;IDX--;)HEX[IDX]=(IDX+256).toString(16).substring(1);function v4(){var n,t=0,e="";if(!BUFFER||IDX+16>256){for(BUFFER=Array(t=256);t--;)BUFFER[t]=256*Math.random()|0;t=IDX=0}for(;t<16;t++)n=BUFFER[IDX+t],e+=6==t?HEX[15&n|64]:8==t?HEX[63&n|128]:HEX[n],1&t&&t>1&&t<11&&(e+="-");return IDX++,e}function sgg(n,t,e={}){let{windowSize:i=9,derivative:s=0,polynomial:a=3}=e;if(i%2==0||i<5||!Number.isInteger(i))throw new RangeError("Invalid window size (should be odd and at least 5 integer number)");if(!isAnyArray$1(n))throw new TypeError("Y values must be an array");if(void 0===t)throw new TypeError("X must be defined");if(i>n.length)throw new RangeError(`Window size is higher than the data length ${i}>${n.length}`);if(s<0||!Number.isInteger(s))throw new RangeError("Derivative should be a positive integer");if(a<1||!Number.isInteger(a))throw new RangeError("Polynomial should be a positive integer");a>=6&&console.warn("You should not use polynomial grade higher than 5 if you are not sure that your data arises from such a model. Possible polynomial oscillation problems");let r=Math.floor(i/2),o=n.length,l=new Float64Array(o),f=fullWeights(i,a,s),g=0,u=!0;isAnyArray$1(t)?u=!1:g=Math.pow(t,s);for(let e=0;e<r;e++){let a=f[r-e-1],d=f[r+e+1],c=0,h=0;for(let t=0;t<i;t++)c+=a[t]*n[t],h+=d[t]*n[o-i+t];u?(l[r-e-1]=c/g,l[o-r+e]=h/g):(g=getHs(t,r-e-1,r,s),l[r-e-1]=c/g,g=getHs(t,o-r+e,r,s),l[o-r+e]=h/g)}let d=f[r];for(let e=i;e<=o;e++){let a=0;for(let t=0;t<i;t++)a+=d[t]*n[t+e-i];u||(g=getHs(t,e-r-1,r,s)),l[e-r-1]=a/g}return l}function getHs(n,t,e,i){let s=0,a=0;for(let i=t-e;i<t+e;i++)i>=0&&i<n.length-1&&(s+=n[i+1]-n[i],a++);return Math.pow(s/a,i)}function gramPoly(n,t,e,i){let s=0;return s=e>0?(4*e-2)/(e*(2*t-e+1))*(n*gramPoly(n,t,e-1,i)+i*gramPoly(n,t,e-1,i-1))-(e-1)*(2*t+e)/(e*(2*t-e+1))*gramPoly(n,t,e-2,i):0===e&&0===i?1:0,s}function genFact(n,t){let e=1;if(n>=t)for(let i=n-t+1;i<=n;i++)e*=i;return e}function weight(n,t,e,i,s){let a=0;for(let r=0;r<=i;r++)a+=(2*r+1)*(genFact(2*e,r)/genFact(2*e+r+1,r+1))*gramPoly(n,e,r,0)*gramPoly(t,e,r,s);return a}function fullWeights(n,t,e){let i=new Array(n),s=Math.floor(n/2);for(let a=-s;a<=s;a++){i[a+s]=new Float64Array(n);for(let n=-s;n<=s;n++)i[a+s][n+s]=weight(n,a,s,t,e)}return i}function optimizeTop(n,t){const{x:e,y:i}=n;for(const n of t){let t=n.index;if(i[t-1]>=i[t-2]&&i[t-1]>=i[t]?t--:i[t+1]>=i[t]&&i[t+1]>=i[t+2]?t++:i[t-2]>=i[t-3]&&i[t-2]>=i[t-1]?t-=2:i[t+2]>=i[t+1]&&i[t+2]>=i[t+3]&&(t+=2),i[t-1]>0&&i[t+1]>0&&i[t]>=i[t-1]&&i[t]>=i[t+1]&&(i[t]!==i[t-1]||i[t]!==i[t+1])){let s=20*Math.log10(i[t-1]),a=20*Math.log10(i[t]),r=20*Math.log10(i[t+1]),o=.5*(s-r)/(s-2*a+r);n.x=e[t]+(e[t]-e[t-1])*o,n.y=i[t]-.25*(i[t-1]-i[t+1])*o}}}function gsd(n,t={}){let{sgOptions:e={windowSize:9,polynomial:3},noiseLevel:i,smoothY:s=!1,maxCriteria:a=!0,minMaxRatio:r=25e-5,realTopDetection:o=!1}=t,{x:l,y:f}=n;if(1!==xIsMonotonic(l))throw new Error("GSD only accepts monotone increasing x values");f=f.slice();let g=xIsEquallySpaced(l);if(void 0===i)if(g){const n=xNoiseStandardDeviation(f);i=a?n.median+1.5*n.sd:-n.median+1.5*n.sd}else i=0;else a||(i*=-1);if(!a)for(let n=0;n<f.length;n++)f[n]*=-1;if(void 0!==i)for(let n=0;n<f.length;n++)f[n]<i&&(f[n]=i);let u,d,c=f;const{windowSize:h,polynomial:b}=e;g?(s&&(c=sgg(f,l[1]-l[0],{windowSize:h,polynomial:b,derivative:0})),u=sgg(f,l[1]-l[0],{windowSize:h,polynomial:b,derivative:1}),d=sgg(f,l[1]-l[0],{windowSize:h,polynomial:b,derivative:2})):(s&&(c=sgg(f,l,{windowSize:h,polynomial:b,derivative:0})),u=sgg(f,l,{windowSize:h,polynomial:b,derivative:1}),d=sgg(f,l,{windowSize:h,polynomial:b,derivative:2}));const D=xMinValue(c),H=xMaxValue(c);if(D>H||D===H)return[];const j=D+(H-D)*r,m=l[1]-l[0];let A=null,C=null,T=[],p=[],I=[];for(let n=1;n<c.length-1;++n)(u[n]<u[n-1]&&u[n]<=u[n+1]||u[n]<=u[n-1]&&u[n]<u[n+1])&&(C={x:l[n],index:n},m>0&&null!==A&&(p.push(A),I.push(C))),(u[n]>=u[n-1]&&u[n]>u[n+1]||u[n]>u[n-1]&&u[n]>=u[n+1])&&(A={x:l[n],index:n},m<0&&null!==C&&(p.push(A),I.push(C))),d[n]<d[n-1]&&d[n]<d[n+1]&&T.push(n);let P=-1;const M=[];for(const n of T){let t=l[n],e=-1,i=P+1,s=Number.POSITIVE_INFINITY,a=0;for(;-1===e&&i<p.length&&(a=Math.abs(t-(p[i].x+I[i].x)/2),a<(I[i].x-p[i].x)/2&&(e=i,P=i),++i,!(a>=s));)s=a;if(-1!==e&&c[n]>j){let i=Math.abs(I[e].x-p[e].x);M.push({id:v4(),x:t,y:c[n],width:i,index:n,ddY:d[n],inflectionPoints:{from:p[e],to:I[e]}})}}return o&&optimizeTop({x:l,y:c},M),M.forEach((n=>{a||(n.y*=-1,n.ddY=-1*n.ddY)})),M.sort(((n,t)=>n.x-t.x)),M}function getSumOfShapes$1(n){return function(t){return e=>{let i=0;for(const s of n){const n=t[s.fromIndex],a=t[s.fromIndex+1];for(let n=2;n<t.length;n++)s.shapeFct[s.parameters[n]]=t[s.fromIndex+n];i+=a*s.shapeFct.fct(e-n)}return i}}}function assert(n,t){if(!n)throw new Error(t||"unreachable")}const DefaultParameters={x:{init:n=>n.x,min:(n,t)=>n.x-2*t.fwhm,max:(n,t)=>n.x+2*t.fwhm,gradientDifference:(n,t)=>.002*t.fwhm},y:{init:n=>n.y,min:n=>n.y<0?-1.1:0,max:n=>n.y<0?0:1.1,gradientDifference:()=>.001},fwhm:{init:(n,t)=>t.fwhm,min:(n,t)=>.25*t.fwhm,max:(n,t)=>4*t.fwhm,gradientDifference:(n,t)=>.002*t.fwhm},mu:{init:(n,t)=>t.mu,min:()=>0,max:()=>1,gradientDifference:()=>.01}},properties$1=["init","min","max","gradientDifference"];function getInternalPeaks(n,t,e={}){let i=0,s=[];const{baseline:a=t.min}=e,r=n.map((n=>({...n,y:(n.y-a)/t.range})));for(const n of r){const{id:a,shape:r=(e.shape?e.shape:{kind:"gaussian"})}=n,o=getShape1D(r),l=["x","y",...o.getParameters()],f={min:[],max:[],init:[],gradientDifference:[]};for(let i of l)for(let s of properties$1){let a=n?.parameters?.[i]?.[s];if(a){a=getNormalizedValue$1(a,i,s,t,e.baseline),f[s].push(a);continue}let r=e?.parameters?.[i]?.[s];if(r){if("number"==typeof r){r=getNormalizedValue$1(r,i,s,t,e.baseline),f[s].push(r);continue}{let a=r(n);a=getNormalizedValue$1(a,i,s,t,e.baseline),f[s].push(a);continue}}assert(DefaultParameters[i],`No default parameter for ${i}`);const l=DefaultParameters[i][s];f[s].push(l(n,o))}const g=i,u=g+l.length-1;i+=u-g+1,s.push({id:a,shape:r,shapeFct:o,parameters:l,propertiesValues:f,fromIndex:g,toIndex:u})}return s}function getNormalizedValue$1(n,t,e,i,s){return"y"===t?"gradientDifference"===e?n:void 0!==s?(n-s)/i.range:(n-i.min)/i.range:n}function checkOptions(n,t,e){let{timeout:i,minValues:s,maxValues:a,initialValues:r,weights:o=1,damping:l=.01,dampingStepUp:f=11,dampingStepDown:g=9,maxIterations:u=100,errorTolerance:d=1e-7,centralDifference:c=!1,gradientDifference:h=.1,improvementThreshold:b=.001}=e;if(l<=0)throw new Error("The damping option must be a positive number");if(!n.x||!n.y)throw new Error("The data parameter must have x and y elements");if(!isAnyArray$1(n.x)||n.x.length<2||!isAnyArray$1(n.y)||n.y.length<2)throw new Error("The data parameter elements must be an array with more than 2 points");if(n.x.length!==n.y.length)throw new Error("The data parameter elements must have the same size");if(!(r&&r.length>0))throw new Error("The initialValues option is mandatory and must be an array");let D,H,j=r,m=n.y.length,A=j.length;if(a=a||new Array(A).fill(Number.MAX_SAFE_INTEGER),s=s||new Array(A).fill(Number.MIN_SAFE_INTEGER),a.length!==s.length)throw new Error("minValues and maxValues must be the same size");if("number"==typeof h)h=new Array(j.length).fill(h);else{if(!isAnyArray$1(h))throw new Error("gradientDifference should be a number or array with length equal to the number of parameters");h.length!==A&&(h=new Array(A).fill(h[0]))}if("number"==typeof o){let n=1/o**2;D=()=>n}else{if(!isAnyArray$1(o))throw new Error("weights should be a number or array with length equal to the number of data points");if(o.length<n.x.length){let n=1/o[0]**2;D=()=>n}else D=n=>1/o[n]**2}if(void 0!==i){if("number"!=typeof i)throw new Error("timeout should be a number");let n=Date.now()+1e3*i;H=()=>Date.now()>n}else H=()=>!1;let C=new Array(n.x.length);for(let n=0;n<m;n++)C[n]=D(n);return{checkTimeout:H,minValues:s,maxValues:a,parameters:j,weightSquare:C,damping:l,dampingStepUp:f,dampingStepDown:g,maxIterations:u,errorTolerance:d,centralDifference:c,gradientDifference:h,improvementThreshold:b}}function errorCalculation(n,t,e,i){let s=0;const a=e(t);for(let t=0;t<n.x.length;t++)s+=Math.pow(n.y[t]-a(n.x[t]),2)/i[t];return s}function gradientFunction(n,t,e,i,s,a){const r=e.length,o=n.x.length;let l=Matrix.zeros(r,o),f=0;for(let g=0;g<r;g++){if(0===i[g])continue;let r=i[g],u=e.slice();u[g]+=r;let d=s(u);if(a){u=e.slice(),u[g]-=r,r*=2;let t=s(u);for(let e=0;e<o;e++)l.set(f,e,(t(n.x[e])-d(n.x[e]))/r)}else for(let e=0;e<o;e++)l.set(f,e,(t[e]-d(n.x[e]))/r);f++}return l}function matrixFunction(n,t){const e=n.x.length;let i=new Matrix(e,1);for(let s=0;s<e;s++)i.set(s,0,n.y[s]-t[s]);return i}function step(n,t,e,i,s,a,r){let o=e,l=Matrix.eye(t.length,t.length,o);const f=s(t);let g=new Float64Array(n.x.length);for(let t=0;t<n.x.length;t++)g[t]=f(n.x[t]);let u=gradientFunction(n,g,t,i,s,a),d=matrixFunction(n,g),c=inverse(l.add(u.mmul(u.transpose().scale("row",{scale:r})))),h=u.mmul(d.scale("row",{scale:r}));return{perturbations:c.mmul(h),jacobianWeightResidualError:h}}function levenbergMarquardt(n,t,e){let{checkTimeout:i,minValues:s,maxValues:a,parameters:r,weightSquare:o,damping:l,dampingStepUp:f,dampingStepDown:g,maxIterations:u,errorTolerance:d,centralDifference:c,gradientDifference:h,improvementThreshold:b}=checkOptions(n,t,e),D=errorCalculation(n,r,t,o),H=D,j=r.slice(),m=D<=d,A=0;for(;A<u&&!m;A++){let u=D,{perturbations:A,jacobianWeightResidualError:C}=step(n,r,l,h,t,c,o);for(let n=0;n<r.length;n++)r[n]=Math.min(Math.max(s[n],r[n]-A.get(n,0)),a[n]);if(D=errorCalculation(n,r,t,o),isNaN(D))break;if(D<H-d&&(H=D,j=r.slice()),l=(u-D)/A.transpose().mmul(A.mul(l).add(C)).get(0,0)>b?Math.max(l/g,1e-7):Math.min(l*f,1e7),i())throw new Error(`The execution time is over to ${e.timeout} seconds`);m=D<=d}return{parameterValues:j,parameterError:H,iterations:A}}function antiLowerConvexHull(n,t){if(n.length!==t.length)throw new RangeError("X and Y vectors has different dimensions");const e=n.length-1;if(0===e)return[0];if(1===e)return[0,1];let i=0,s=new Array(n.length).fill(!0);for(;;){const a=i,r=moveOn(i,e,s),o=moveOn(moveOn(i,e,s),e,s);if(n[o]*(t[a]-t[r])+n[a]*(t[r]-t[o])+n[r]*(t[o]-t[a])>=0?i=r:(s[r]=!1,i=moveBack(i,e,s)),o===e)break}return s.map(((n,t)=>!1!==n&&t)).filter((n=>!1!==n))}function moveBack(n,t,e){let i=n-1;for(;!1===e[i];)i--;return 0===n?t:i}function moveOn(n,t,e){let i=n+1;for(;!1===e[i];)i++;return n===t?0:i}function direct(n,t,e,i={}){const{iterations:s=50,epsilon:a=1e-4,tolerance:r=1e-16,tolerance2:o=1e-12,initialState:l={}}=i;if(void 0===n||void 0===t||void 0===e)throw new RangeError("There is something undefined");if(t=new Float64Array(t),e=new Float64Array(e),t.length!==e.length)throw new Error("Lower bounds and Upper bounds for x are not of the same length");let f=t.length,g=e.map(((n,e)=>n-t[e])),{numberOfRectangles:u=0,totalIterations:d=0,unitaryCoordinates:c=[new Float64Array(f).fill(.5)],middlePoint:h=new Float64Array(f).map(((n,e)=>t[e]+c[0][e]*g[e])),bestCurrentValue:b=n(h),fCalls:D=1,smallerDistance:H=0,edgeSizes:j=[new Float64Array(f).fill(.5)],diagonalDistances:m=[Math.sqrt(f*Math.pow(.5,2))],functionValues:A=[b],differentDistances:C=m,smallerValuesByDistance:T=[b],choiceLimit:p}=l;if(l.originalCoordinates&&l.originalCoordinates.length>0){b=xMinValue(A),p=a*Math.abs(b)>1e-8?a*Math.abs(b):1e-8,H=getMinIndex(A,m,p,b),c=l.originalCoordinates.slice();for(let n=0;n<c.length;n++)for(let e=0;e<t.length;e++)c[n][e]=(c[n][e]-t[e])/g[e]}let I=0;for(;I<s;){let e,i,s=[],l=C.findIndex((n=>n===m[H])),f=0;for(let n=l;n<C.length;n++)for(let t=0;t<A.length;t++)A[t]===T[n]&m[t]===C[n]&&(s[f++]=t);if(C.length-l>1){let n=m[H],t=A[H],e=C[C.length-1],a=(T[C.length-1]-t)/(e-n),r=t-a*n,l=new Uint32Array(f);f=0;for(let n=0;n<l.length;n++){let t=s[n];A[t]<=a*m[t]+r+o&&(l[f++]=t)}let g=[],u=[];for(let n=0;n<f;n++)g.push(m[l[n]]),u.push(A[l[n]]);let d=antiLowerConvexHull(g,u);i=[];for(let n=0;n<d.length;n++)i.push(l[d[n]])}else i=s.slice(0,f);e=i;for(let i=0;i<e.length;i++){let s=e[i],a=xMaxValue(j[s]),o=new Uint32Array(j[s].length);f=0;for(let n=0;n<j[s].length;n++)Math.abs(j[s][n]-a)<r&&(o[f++]=n);let l=2*a/3,d=[];for(let e=0;e<f;e++){let i=o[e],a=c[s].slice(),r=c[s].slice();a[i]+=l,r[i]-=l;let f=new Float64Array(a.length),u=new Float64Array(r.length);for(let n=0;n<a.length;n++)f[n]=t[n]+a[n]*g[n],u[n]=t[n]+r[n]*g[n];let h=n(f),b=n(u);D+=2,d.push({minValue:Math.min(h,b),index:e}),c.push(a,r),A.push(h,b)}let h=d.sort(((n,t)=>n.minValue-t.minValue));for(let n=0;n<f;n++){let t=o[h[n].index],e=u+2*(h[n].index+1)-1,i=u+2*(h[n].index+1);j[s][t]=l/2,j[e]=j[s].slice(),j[i]=j[s].slice(),m[s]=xNorm(j[s]),m[e]=m[s],m[i]=m[s]}u+=2*f}b=xMinValue(A),p=a*Math.abs(b)>1e-8?a*Math.abs(b):1e-8,H=getMinIndex(A,m,p,b),C=Array.from(new Set(m)),C=C.sort(((n,t)=>n-t)),T=[];for(let n=0;n<C.length;n++){let t,e=Number.POSITIVE_INFINITY;for(let i=0;i<m.length;i++)m[i]===C[n]&&A[i]<e&&(e=A[i],t=i);T.push(A[t])}for(let n=0;n<A.length;n++)if(A[n]===b){let e=[];for(let i=0;i<t.length;i++)e.push(t[i]+c[n][i]*g[i])}I+=1}let P={};P.minFunctionValue=b,P.iterations=I;let M=[];for(let n=0;n<u+1;n++){let e=[];for(let i=0;i<t.length;i++)e.push(t[i]+c[n][i]*g[i]);M.push(e)}P.finalState={numberOfRectangles:u,totalIterations:d+=s,originalCoordinates:M,middlePoint:h,fCalls:D,smallerDistance:H,edgeSizes:j,diagonalDistances:m,functionValues:A,differentDistances:C,smallerValuesByDistance:T,choiceLimit:p};let w=[];for(let n=0;n<A.length;n++)A[n]===b&&w.push(M[n]);return P.optima=w,P}function getMinIndex(n,t,e,i){let s=[];for(let a=0;a<n.length;a++)s[a]=Math.abs(n[a]-(i+e))/t[a];const a=xMinValue(s);return s.findIndex((n=>n===a))}function directOptimization$1(n,t,e){const{minValues:i,maxValues:s,maxIterations:a,epsilon:r,tolerance:o,tolerance2:l,initialState:f}=e,g=direct(getObjectiveFunction$1(n,t),i,s,{iterations:a,epsilon:r,tolerance:o,tolerance2:l,initialState:f}),{optima:u}=g;return{parameterError:g.minFunctionValue,iterations:g.iterations,parameterValues:u[0]}}function getObjectiveFunction$1(n,t){const{x:e,y:i}=n,s=e.length;return n=>{const a=t(n);let r=0;for(let n=0;n<s;n++)r+=Math.pow(i[n]-a(e[n]),2);return r}}function selectMethod(n={}){let{kind:t="lm",options:e}=n;switch(t){case"lm":case"levenbergMarquardt":return{algorithm:levenbergMarquardt,optimizationOptions:{damping:1.5,maxIterations:100,errorTolerance:1e-8,...e}};case"direct":return{algorithm:directOptimization$1,optimizationOptions:{iterations:20,epsilon:1e-4,tolerance:1e-16,tolerance2:1e-12,initialState:{},...e}};default:throw new Error("Unknown fitting algorithm")}}function optimize(n,t,e={}){let i=xMinMaxValues(n.y);const s={...i,range:i.max-i.min},a=getInternalPeaks(t,s,e),{baseline:r=s.min}=e;let o=new Float64Array(n.y.length);for(let t=0;t<n.y.length;t++)o[t]=(n.y[t]-r)/s.range;const l=a[a.length-1].toIndex+1,f=new Float64Array(l),g=new Float64Array(l),u=new Float64Array(l),d=new Float64Array(l);let c=0;for(const n of a)for(let t=0;t<n.parameters.length;t++)f[c]=n.propertiesValues.min[t],g[c]=n.propertiesValues.max[t],u[c]=n.propertiesValues.init[t],d[c]=n.propertiesValues.gradientDifference[t],c++;let{algorithm:h,optimizationOptions:b}=selectMethod(e.optimization),D=getSumOfShapes$1(a),H=h({x:n.x,y:o},D,{minValues:f,maxValues:g,initialValues:u,gradientDifference:d,...b});const j=H.parameterValues;let m=[];for(let n of a){const{id:t,shape:e,parameters:i,fromIndex:a}=n;let o={x:0,y:0,shape:e};t&&(o={...o,id:t}),o.x=j[a],o.y=j[a+1]*s.range+r;for(let n=2;n<i.length;n++)o.shape[i[n]]=j[a+n];m.push(o)}return{error:H.parameterError,iterations:H.iterations,peaks:m}}const{parse:parse$6,stringify:stringify$6}=JSON;function addMissingShape(n,t={}){const{shape:e={kind:"gaussian"},output:i=parse$6(stringify$6(n))}=t;let s=getShape1D(e);return i.map((n=>{if(hasShape(n)){if(!("fwhm"in n.shape)){const t=getShape1D(n.shape);n.shape.fwhm=t.widthToFWHM(n.width)}return n}return{...n,shape:{fwhm:s.widthToFWHM(n.width),...e}}}))}function hasShape(n){return"shape"in n}function groupPeaks(n,t={}){if(n&&0===n.length)return[];const{factor:e=1}=t;(n=JSON.parse(JSON.stringify(n))).sort(((n,t)=>n.x-t.x));let i=n[0],s=[i],a=[s];for(let t=1;t<n.length;t++){const r=n[t];(r.x-i.x)/((r.width+i.width)/2)<=e?s.push(r):(s=[r],a.push(s)),i=r}return a}function optimizePeaksWithLogs(n,t,e={}){const{fromTo:i={},baseline:s,shape:a={kind:"gaussian"},groupingFactor:r=1,factorLimits:o=2,optimization:l={kind:"lm",options:{timeout:10}}}=e;let f=groupPeaks(t,{factor:r}),g=[],u=[];return f.forEach((t=>{const e=Date.now(),r=addMissingShape(t,{shape:a}),f=r[0],d=r[r.length-1],{from:c=f.x-f.width*o,to:h=d.x+d.width*o}=i,{fromIndex:b,toIndex:D}=xGetFromToIndex(n.x,{from:c,to:h}),H=n.x instanceof Float64Array?n.x.subarray(b,D):n.x.slice(b,D),j=n.y instanceof Float64Array?n.y.subarray(b,D):n.y.slice(b,D),m={range:{from:c,to:h},parameters:l,groupSize:t.length,time:Date.now()-e};if(H.length>5){const{iterations:n,error:t,peaks:e}=optimize({x:H,y:j},r,{shape:a,baseline:s,optimization:l});for(let n=0;n<r.length;n++)u.push({...e[n],width:getShape1D(r[n].shape).fwhmToWidth(e[n].shape.fwhm)});g.push({...m,iterations:n,error:t,message:"optimization successful"})}else u.push(...r),g.push({...m,iterations:0,message:"x length too small for optimization"})})),{logs:g,optimizedPeaks:u}}function optimizePeaks(n,t,e={}){return optimizePeaksWithLogs(n,t,e).optimizedPeaks}const{parse:parse$5,stringify:stringify$5}=JSON;function addMissingIDs$1(n,t={}){const{output:e=parse$5(stringify$5(n))}=t;for(const n of e)"id"in n||(n.id=v4());return e}function joinBroadPeaks(n,t={}){let{shape:e={kind:"gaussian"},optimization:i={kind:"lm",options:{timeout:10}},broadWidth:s=.25,broadRatio:a=.0025}=t,r=0,o=0,l=1;const f=[];if(n.length<2)return addMissingIDs$1(addMissingShape(n.map(getGSDPeakOptimizedStructure),{shape:e}));let g=n[0].ddY;for(let t=1;t<n.length;t++)Math.abs(n[t].ddY)>g&&(g=Math.abs(n[t].ddY));const u=[];for(const t of n)Math.abs(t.ddY)<=a*g?f.push(t):u.push(getGSDPeakOptimizedStructure(t));f.push({x:Number.MAX_VALUE,y:0});let d={x:[f[0].x],y:[f[0].y]},c=[0];for(let n=1;n<f.length;n++)if(Math.abs(f[n-1].x-f[n].x)<s)d.x.push(f[n].x),d.y.push(f[n].y),f[n].y>r&&(r=f[n].y,o=n),c.push(n),l++;else{if(l>2){let n=optimizePeaks(d,[{id:v4(),x:f[o].x,y:r,width:d.x[0]-d.x[d.x.length-1]}],{shape:e,optimization:i});u.push(n[0])}else for(const n of c)u.push(getGSDPeakOptimizedStructure(f[n]));d={x:[f[n].x],y:[f[n].y]},c=[n],r=f[n].y,o=n,l=1}return u.sort(((n,t)=>n.x-t.x)),addMissingIDs$1(u,{output:u})}function getGSDPeakOptimizedStructure(n){const{id:t,shape:e,x:i,y:s,width:a}=n;let r={x:i,y:s,width:a,shape:e};return t&&(r.id=t),r}const{parse:parse$4,stringify:stringify$4}=JSON;function setShape(n,t={}){let{shape:e={kind:"gaussian"},output:i=parse$4(stringify$4(n))}=t,s=getShape1D(e);return i.map((n=>({...n,shape:{fwhm:s.widthToFWHM(n.width),...e}})))}function peakToXY(n,t){const e=addMissingShape([n])[0],i=getShape1D(e.shape).getFactor(),{from:s=e.x-n.width*i/t.frequency,to:a=e.x+n.width*i/t.frequency}=t;return peaksToXY([n],{...t,from:s,to:a})}class TreeSet{constructor(n){this.length=0,this.elements=[],this.compatator=n||function(n,t){return n-t}}size(){return this.elements.length}last(){return this.elements[this.length-1]}first(){return this.elements[0]}isEmpty(){return 0===this.size()}pollLast(){return this.length>0?(this.length--,this.elements.splice(this.length,1)):null}pollFirst(){return this.length>0?(this.length--,this.elements.splice(0,1)):null}add(n){let t=this.binarySearch(n);t<0&&(t=-t-1),this.elements.splice(t,0,n),this.length++}binarySearch(n){for(var t=0,e=this.elements.length-1;t<=e;){var i=t+e>>>1,s=this.elements[i],a=this.compatator(s,n);if(a<0)t=i+1;else{if(!(a>0))return i;e=i-1}}return-(t+1)}}var src$2=TreeSet,TreeSet$1=src$2;function createMapPossibleAssignments(n){const{restrictionByCS:t,predictions:e,targets:i,useIntegrationRestriction:s}=n,{tolerance:a,chemicalShiftRestriction:r}=t,o=Math.abs(a),l={};for(const n in e){const t=e[n];if(t.error&&(t.error=Math.abs(t.error)),l[n]=[],i)for(const e in i){const a=i[e],{nbAtoms:f}=t,{integration:g}=a;if(!s||(!(g>0)||f-g<1))if(r&&void 0!==t.delta){let i=o;t.error&&(i=Math.max(i,t.error));const s=a.signals&&a.signals.length>0?a.signals[0].delta:(a.to+a.from)/2;Math.abs(t.delta-s-o)<4*o&&l[n].push(e)}else l[n].push(e)}l[n].push("*")}return l}function partialScore$1(n,t){const{useIntegrationRestriction:e,diaIDPeerPossibleAssignment:i,nbAllowedUnAssigned:s,restrictionByCS:a,predictions:r,targets:o}=t,{useChemicalShiftScore:l}=a;let f=0;const g=n.length,u={};for(let t=0;t<n.length;t++){const e=n[t];e&&"*"!==e&&(u[e]||(u[e]=[]),u[e].push(i[t])),"*"===e&&f++}if(f>s)return 0;const d=Object.keys(u);if(0===d.length)return 0;if(e)for(const n of d){const t=u[n];let e=0;for(const n of t){e+=r[n].allHydrogens}const{integration:i}=o[n];if(e-i>=.5)return 0}return(l?chemicalShiftScoring(n,t):1)-f/g}function chemicalShiftScoring(n,t){const{tolerance:e}=t.restrictionByCS,{diaIDPeerPossibleAssignment:i,predictions:s,targets:a}=t;let r=0,o=0;for(let t=0;t<n.length;t++){const l=n[t];if(l&&"*"!==l){o++;const n=s[i[t]],f=a[l];let g=e;if(n.error&&(g=Math.max(n.error,e)),void 0===n.delta)r+=1;else{const t=f.signals&&f.signals.length>0?f.signals[0].delta:(f.to+f.from)/2;let e=Math.abs(n.delta-t);e<g?r+=1:(e=Math.abs(e-g),r+=-.25/g*e+1)}}}return o>0&&(r/=o),r}function exploreTreeRec(n,t,e,i){const{nSources:s,restrictionByCS:a,timeout:r,timeStart:o,maxSolutions:l,targets:f,predictions:g,lowerBoundScore:u,nbAllowedUnAssigned:d,possibleAssignmentMap:c,useIntegrationRestriction:h,diaIDPeerPossibleAssignment:b}=n;if(Date.now()-o>r)return i;const D=c[b[t]];for(const n of D){e[t]=n;const D=partialScore$1(e,{useIntegrationRestriction:h,diaIDPeerPossibleAssignment:b,nbAllowedUnAssigned:d,restrictionByCS:a,predictions:g,targets:f});0!==D?t===s-1&&D>=u?addSolution$1(i,{predictions:g,partial:e,score:D,maxSolutions:l}):t<s-1&&exploreTreeRec({nSources:s,restrictionByCS:a,timeout:r,timeStart:o,maxSolutions:l,targets:f,predictions:g,lowerBoundScore:u,nbAllowedUnAssigned:d,possibleAssignmentMap:c,useIntegrationRestriction:h,diaIDPeerPossibleAssignment:b},t+1,JSON.parse(JSON.stringify(e)),i):"*"===n&&(e[t]=null)}}function addSolution$1(n,t){const{score:e,maxSolutions:i,partial:s,predictions:a}=t;n.nSolutions++;const r={assignment:JSON.parse(JSON.stringify(s)),score:e/doubleAssignmentPenalty$1(s,a)};n.nSolutions>=i?r.score>n.solutions.last().score&&(n.solutions.pollLast(),n.solutions.add(r)):(n.solutions.add(r),n.nSolutions++)}function doubleAssignmentPenalty$1(n,t){const e=Object.keys(t).length-new Set(n).size;return e>0?2*e:1}const comparator$1=(n,t)=>t.score-n.score;async function buildAssignments$1(n){const{restrictionByCS:t={},useIntegrationRestriction:e,timeout:i,minScore:s,nbAllowedUnAssigned:a,maxSolutions:r,targets:o,joinedSignals:l}=n,{tolerance:f=1,useChemicalShiftScore:g=!1,chemicalShiftRestriction:u=!0}=t;let d={solutions:new TreeSet$1(comparator$1),nSolutions:0};const c=l.length,h={};for(const n of l){const t=n.diaIDs[0],e=n.atoms[0];h[t]={...n,diaIDIndex:e,allHydrogens:n.nbAtoms}}const b=createMapPossibleAssignments({restrictionByCS:{tolerance:f,useChemicalShiftScore:g,chemicalShiftRestriction:u},useIntegrationRestriction:e,predictions:h,targets:o}),D=Object.keys(b),H=fillPartial$1(c);d={solutions:new TreeSet$1(comparator$1),nSolutions:0};exploreTreeRec({nSources:c,restrictionByCS:{tolerance:f,useChemicalShiftScore:g,chemicalShiftRestriction:u},timeout:i,timeStart:Date.now(),targets:o,predictions:h,maxSolutions:r,lowerBoundScore:s,nbAllowedUnAssigned:a,possibleAssignmentMap:b,diaIDPeerPossibleAssignment:D,useIntegrationRestriction:e},0,H,d);const j=[];for(const n of d.solutions.elements){const{assignment:t,score:e}=n,i=JSON.parse(JSON.stringify(o));for(let n=0;n<t.length;n++){const e=i[t[n]];e.diaIDs||(e.diaIDs=[]),t[n]&&e.diaIDs.push(D[n])}j.push({score:e,assignment:Object.values(i)})}return j}function fillPartial$1(n,t=null){const e=new Array(n);for(let i=0;i<n;i++)e[i]=t;return e}function checkAtomsAndDiaIDs$1(n){for(const t of n){if(!t.atoms)throw new Error("signal has not atoms property");if(!t.diaIDs)throw new Error("signal has not diaIDs property");if(!t.nbAtoms)throw new Error("signal has not nbAtoms property")}}function checkForIntegration(n){for(const t of n)if(void 0===t.integration)throw new Error("ranges has not integration property")}async function get1HAssignments(n,t,e={}){const{restrictionByCS:i,minScore:s=1,maxSolutions:a=10,nbAllowedUnAssigned:r=0,timeout:o=6e3,predictionOptions:l={}}=e;if(!t)throw new Error("It is needed a OCL molecule instance to assign");const{spectra:f}=await predict(t,{predictOptions:{H:l}}),g=f.proton?.joinedSignals||[];checkForIntegration(n),checkAtomsAndDiaIDs$1(g);const u={};for(const t of n){const{id:n=v4()}=t;u[n]=JSON.parse(JSON.stringify(t))}return buildAssignments$1({restrictionByCS:i,timeout:o,minScore:s,nbAllowedUnAssigned:r,maxSolutions:a,targets:u,joinedSignals:g,useIntegrationRestriction:!0})}function checkAtomsAndDiaIDs(n){for(const t of n){if(!t.atoms)throw new Error("signal has not atoms property");if(!t.diaIDs)throw new Error("signal has not diaIDs property");if(!t.nbAtoms)throw new Error("signal has not nbAtoms property")}}function checkIntegration(n){for(const t of n)void 0===t.integration&&(t.integration=0);return n}async function get13CAssignments(n,t,e={}){const{restrictionByCS:i={},minScore:s=1,maxSolutions:a=10,nbAllowedUnAssigned:r=0,timeout:o=6e3,predictionOptions:l={}}=e;if(!t)throw new Error("It is needed a OCL molecule instance to assign");const{spectra:f}=await predict(t,{predictOptions:{C:l}}),g=f.carbon?.joinedSignals||[];checkAtomsAndDiaIDs(g);const u=checkIntegration(n),d={};for(const n of u){const{id:t=v4()}=n;d[t]=JSON.parse(JSON.stringify(n))}return buildAssignments$1({restrictionByCS:i,timeout:o,minScore:s,nbAllowedUnAssigned:r,maxSolutions:a,targets:d,joinedSignals:g,useIntegrationRestriction:!1})}function floydWarshall(n){if(Matrix.isMatrix(n)&&n.columns!==n.rows)throw new TypeError("The adjacency matrix should be squared");const t=n.columns;let e=new Matrix(t,t);e.apply(((t,i)=>{if(t===i)e.set(t,i,0);else{let s=n.get(t,i);s||Object.is(s,-0)?e.set(t,i,s):e.set(t,i,Number.POSITIVE_INFINITY)}}));for(let n=0;n<t;++n)for(let i=0;i<t;++i)for(let s=0;s<t;++s){let t=e.get(i,n)+e.get(n,s);e.get(i,s)>t&&e.set(i,s,t)}return e.apply(((n,t)=>{e.get(n,t)===Number.POSITIVE_INFINITY&&e.set(n,t,-1)})),e}function getConnectivityMatrix(n,t={}){const e=n.getOCL();n.ensureHelperArrays(e.Molecule.cHelperNeighbours);const i=n.getAllAtoms();let s=new Array(i).fill();if(s=s.map((()=>new Array(i).fill(0))),!t.pathLength)if(t.atomicNo)for(let t=0;t<i;t++)s[t][t]=n.getAtomicNo(t);else if(t.negativeAtomicNo)for(let t=0;t<i;t++)s[t][t]=-n.getAtomicNo(t);else if(t.mass)for(let t=0;t<i;t++)s[t][t]=e.Molecule.cRoundedMass[n.getAtomicNo(t)];else for(let n=0;n<i;n++)s[n][n]=1;if(t.sdt)for(let t=0;t<i;t++){const e=n.getAllConnAtoms(t);for(let i=0;i<e;i++)s[t][n.getConnAtom(t,i)]=n.getConnBondOrder(t,i)}else if(t.sdta)for(let t=0;t<i;t++){const e=n.getAllConnAtoms(t);for(let i=0;i<e;i++){const e=n.getConnBond(t,i);n.isAromaticBond(e)?s[t][n.getConnAtom(t,i)]=4:s[t][n.getConnAtom(t,i)]=n.getConnBondOrder(t,i)}}else for(let t=0;t<i;t++){const e=n.getAllConnAtoms(t);for(let i=0;i<e;i++)s[t][n.getConnAtom(t,i)]=1}return t.pathLength&&(s=floydWarshall(new Matrix(s)).to2DArray()),s}function makeRacemic(n){const{Molecule:t}=n.getOCL();n.ensureHelperArrays(t.cHelperCIP);for(let e=0;e<n.getAllAtoms();e++)n.getAtomParity(e)!==t.cAtomParityNone&&n.setAtomESR(e,t.cESRTypeAnd,0);n.ensureHelperArrays(t.cHelperCIP)}let xAtomicNumber=0;function getXAtomicNumber(n){if(!xAtomicNumber){const t=n.getOCL();xAtomicNumber=t.Molecule.getAtomicNoFromLabel("X",t.Molecule.cPseudoAtomX)}return xAtomicNumber}function tagAtom(n,t){const e=`${n.getAtomLabel(t)}*`;return n.setAtomCustomLabel(t,e),1===n.getAtomicNo(t)?n.setAtomicNo(t,getXAtomicNumber(n)):n.setAtomMass(t,n.getAtomMass(t)+5),e}function getCanonizedDiaIDs(n){const t=n.heterotopicSymmetryRanks,e=n.moleculeWithH,i=n.finalRanks,s=new Array(e.getAllAtoms());e.ensureHelperArrays(n.Molecule.cHelperSymmetryStereoHeterotopicity);const a={};for(let e=0;e<n.moleculeWithH.getAllAtoms();e++){const r=t[e];if(r&&a[r]){s[i[e]]=a[r].diaID;continue}const o=n.moleculeWithH.getCompactCopy();tagAtom(o,e),makeRacemic(o);const l=o.getCanonizedIDCode(n.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS);s[i[e]]=l}return s}function isCsp3(n,t){return 6===n.getAtomicNo(t)&&(0===n.getAtomCharge(t)&&n.getImplicitHydrogens(t)+n.getConnAtoms(t)===4)}const FULL_HOSE_CODE=1,HOSE_CODE_CUT_C_SP3_SP3=2;function getHoseCodesForAtomsInternal(n,t={}){const e=n.getOCL(),{allowedCustomLabels:i,minSphereSize:s=0,maxSphereSize:a=4,kind:r=FULL_HOSE_CODE}=t;n.ensureHelperArrays(e.Molecule.cHelperNeighbours);const o=[];for(let t=0;t<n.getAllAtoms();t++)(i?.includes(n.getAtomCustomLabel(t))||n.getAtomCustomLabel(t))&&o.push(t);const l=new e.Molecule(0,0),f=[];let g=0,u=0;const d=new Array(n.getAllAtoms()),c=new Array(n.getAllAtoms());for(let t=0;t<=a;t++){if(0===u)for(const n of o)c[u]=n,d[n]=!0,u++;else{let t=u;for(let e=g;e<u;e++){const i=c[e];for(let e=0;e<n.getAllConnAtoms(i);e++){const s=n.getConnAtom(i,e);if(!d[s])switch(r){case FULL_HOSE_CODE:d[s]=!0,c[t++]=s;break;case HOSE_CODE_CUT_C_SP3_SP3:isCsp3(n,i)&&isCsp3(n,s)||(d[s]=!0,c[t++]=s);break;default:throw new Error("getHoseCoesForAtom unknown kind")}}}g=u,u=t}n.copyMoleculeByAtoms(l,d,!0,null),t>=s&&(makeRacemic(l),f.push(l.getCanonizedIDCode(e.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS)))}return f}function getCanonizedHoseCodes(n,t={}){const e=n.heterotopicSymmetryRanks,i=n.moleculeWithH,s=n.finalRanks,a=new Array(i.getAllAtoms());i.ensureHelperArrays(n.Molecule.cHelperSymmetryStereoHeterotopicity);const r={};for(let i=0;i<n.moleculeWithH.getAllAtoms();i++){const o=e[i];if(o&&r[o]){a[s[i]]=r[o].diaID;continue}const l=n.moleculeWithH.getCompactCopy();tagAtom(l,i);const f=getHoseCodesForAtomsInternal(l,t);a[s[i]]=f}return a}function getDiaIDsAndInfo(n,t){const e=[],i=n.moleculeWithH,s={};for(const n of t)s[n]||(s[n]=0),s[n]++;for(let a=0;a<t.length;a++){const r=t[n.finalRanks[a]],o={idCode:r,attachedHydrogensIDCodes:[],nbAttachedHydrogens:0,atomLabel:i.getAtomLabel(a),nbEquivalentAtoms:s[r],heavyAtom:void 0,atomMapNo:i.getAtomMapNo(a)};if(1===i.getAtomicNo(a)){const e=i.getConnAtom(a,0);o.heavyAtom=t[n.finalRanks[e]]}for(let e=0;e<i.getAllConnAtoms(a);e++){const s=i.getConnAtom(a,e);if(1===i.getAtomicNo(s)){o.nbAttachedHydrogens++;const e=t[n.finalRanks[s]];o.attachedHydrogensIDCodes.includes(e)||o.attachedHydrogensIDCodes.push(e)}}e.push(o)}return e}function getHeterotopicSymmetryRanks(n){n.ensureHelperArrays(n.getOCL().Molecule.cHelperSymmetryStereoHeterotopicity);const t=[];for(let e=0;e<n.getAllAtoms();e++)t.push(n.getSymmetryRank(e));return t}function getFinalRanks(n){return n.ensureHelperArrays(n.getOCL().Molecule.cHelperSymmetryStereoHeterotopicity),n.getFinalRanks(0).map((n=>n-1))}function getChiralOrHeterotopicCarbons(n){const{Molecule:t}=n.getOCL(),e=getXAtomicNumber(n),i=n.getCompactCopy();i.addImplicitHydrogens();for(let n=0;n<i.getAllAtoms();n++)1===i.getAtomicNo(n)&&i.setAtomicNo(n,e);addPossibleChiralBonds(i),i.ensureHelperArrays(t.cHelperSymmetryStereoHeterotopicity);const s=[];for(let t=0;t<n.getAllAtoms();t++){if(i.getAtomicNo(t)===e)continue;if(n.getAtomicNo(t)!==i.getAtomicNo(t))throw new Error("getChiralOrHeterotopicCarbons: mismatching atomic numbers");if(6!==i.getAtomicNo(t))continue;4===getNeighbourSymmetries(i,t).length&&s.push(t)}return s}function addPossibleChiralBonds(n){const{Molecule:t}=n.getOCL();n.ensureHelperArrays(t.cHelperSymmetryStereoHeterotopicity);for(let e=0;e<n.getAtoms();e++){if(6!==n.getAtomicNo(e))continue;if(n.getStereoBond(e)>=0)continue;if(getNeighbourSymmetries(n,e).length<=2)continue;const i=n.getAtomPreferredStereoBond(e);if(-1!==i){if(n.setBondType(i,t.cBondTypeUp),n.getBondAtom(1,i)===e){const t=n.getBondAtom(0,i);n.setBondAtom(0,i,e),n.setBondAtom(1,i,t)}n.setAtomESR(e,t.cESRTypeAnd,0)}}}function getNeighbourSymmetries(n,t){const e=[];for(let i=0;i<n.getAllConnAtoms(t);i++){const s=n.getConnAtom(t,i),a=n.getSymmetryRank(s);e.includes(a)||e.push(n.getSymmetryRank(s))}return e}function ensureHeterotopicChiralBonds(n,t={}){const{Molecule:e}=n.getOCL(),{esrType:i=e.cESRTypeAnd,atLeastThreeAtoms:s=!0}=t;n.ensureHelperArrays(e.cHelperBitNeighbours);const a=getChiralOrHeterotopicCarbons(n);for(const t of a)if(!(s&&n.getAllConnAtoms(t)<3)&&-1===n.getStereoBond(t)){const s=n.getAtomPreferredStereoBond(t);if(-1!==s){if(n.setBondType(s,e.cBondTypeUp),n.getBondAtom(1,s)===t){const e=n.getBondAtom(0,s);n.setBondAtom(0,s,t),n.setBondAtom(1,s,e)}n.setAtomESR(t,i,0)}}}const MAX_NB_ATOMS=250;function getMoleculeWithH(n){const t=n.getCompactCopy();if(t.addImplicitHydrogens(),t.getAllAtoms()>MAX_NB_ATOMS)throw new Error(`Too many atoms to add hydrogens: ${t.getAllAtoms()} > ${MAX_NB_ATOMS}`);return ensureHeterotopicChiralBonds(t),t}function getXMolecule(n){const t=getXAtomicNumber(n),e=n.getCompactCopy();for(let n=0;n<e.getAllAtoms();n++)1===e.getAtomicNo(n)&&e.setAtomicNo(n,t);return e}class TopicMolecule{constructor(n){this.originalMolecule=n,this.idCode=n.getIDCode(),this.molecule=this.originalMolecule.getCompactCopy(),this.molecule.ensureHelperArrays(n.getOCL().Molecule.cHelperNeighbours),this.Molecule=this.molecule.getOCL().Molecule,this.molecule.ensureHelperArrays(this.Molecule.cHelperNeighbours),this.cache={}}ensureMapNo(){const n={};for(let t=0;t<this.molecule.getAllAtoms();t++){const e=this.molecule.getAtomMapNo(t);if(e){if(n[e])throw new Error("The molecule contains several atoms with the same mapNo");n[e]=!0}}let t=1;for(let e=0;e<this.molecule.getAllAtoms();e++){if(!this.molecule.getAtomMapNo(e)){for(;n[t];)t++;n[t]=!0,this.molecule.setAtomMapNo(e,t,!1)}}}toMolfile(n={}){const{version:t=2}=n;return 2===t?this.molecule.toMolfile():this.molecule.toMolfileV3()}getMolecule(){return this.molecule}fromMolecule(n){if(n.getIDCode()!==this.idCode)return new TopicMolecule(n);const t=new TopicMolecule(n);return t.cache={canonizedDiaIDs:this.cache.canonizedDiaIDs,canonizedHoseCodes:this.cache.canonizedHoseCodes},t}get moleculeWithH(){return this.cache.moleculeWithH||(this.cache.moleculeWithH=getMoleculeWithH(this.molecule)),this.cache.moleculeWithH}get xMolecule(){return this.cache.xMolecule||(this.cache.xMolecule=getXMolecule(this.moleculeWithH)),this.cache.xMolecule}get diaIDs(){if(this.cache.diaIDs)return this.cache.diaIDs;const n=[];for(let t=0;t<this.moleculeWithH.getAllAtoms();t++)n.push(this.canonizedDiaIDs[this.finalRanks[t]]);return this.cache.diaIDs=n,n}get hoseCodes(){if(this.cache.hoseCodes)return this.cache.hoseCodes;const n=[];for(let t=0;t<this.moleculeWithH.getAllAtoms();t++)n.push(this.canonizedHoseCodes[this.finalRanks[t]]);return this.cache.hoseCodes=n,n}get canonizedDiaIDs(){return this.cache.canonizedDiaIDs||(this.cache.canonizedDiaIDs=getCanonizedDiaIDs(this)),this.cache.canonizedDiaIDs}get canonizedHoseCodes(){return this.cache.canonizedHoseCodes||(this.cache.canonizedHoseCodes=getCanonizedHoseCodes(this)),this.cache.canonizedHoseCodes}get distanceMatrix(){return getConnectivityMatrix(this.moleculeWithH,{pathLength:!0})}get diaIDsAndInfo(){return this.cache.diaIDsAndInfo||(this.cache.diaIDsAndInfo=getDiaIDsAndInfo(this,this.canonizedDiaIDs)),this.cache.diaIDsAndInfo}get heterotopicSymmetryRanks(){return this.cache.heterotopicSymmetryRanks?this.cache.heterotopicSymmetryRanks:(this.cache.heterotopicSymmetryRanks=getHeterotopicSymmetryRanks(this.xMolecule),[...this.cache.heterotopicSymmetryRanks])}get finalRanks(){return this.cache.finalRanks||(this.cache.finalRanks=getFinalRanks(this.xMolecule)),this.cache.finalRanks}toMolfileWithH(n={}){const{version:t=2}=n;return 2===t?this.moleculeWithH.toMolfile():this.moleculeWithH.toMolfileV3()}getGroupedDiastereotopicAtomIDs(n={}){return groupDiastereotopicAtomIDs(this.diaIDs,this.moleculeWithH,n)}getDiaIDsMapping(n){const t=new TopicMolecule(n),e=this.diaIDsAndInfo.filter((n=>n.atomMapNo)),i=t.diaIDsAndInfo.filter((n=>n.atomMapNo)),s={};for(const n of i){const t=e.find((t=>t.atomMapNo===n.atomMapNo)),i=n.idCode,a=t.idCode;a in s?s[a]!==i&&(s[a]=void 0):s[a]=i;for(let e=0;e<t.attachedHydrogensIDCodes.length;e++){const i=t.attachedHydrogensIDCodes[e],a=n.attachedHydrogensIDCodes[e];i&&a&&(i in s?s[i]!==a&&(s[i]=void 0):s[i]=a)}}return s}}function groupDiastereotopicAtomIDs(n,t,e={}){const{atomLabel:i}=e,s={};for(let e=0;e<n.length;e++)if(!i||t.getAtomLabel(e)===i){const i=n[e];s[i]||(s[i]={counter:0,atoms:[],oclID:i,atomLabel:t.getAtomLabel(e)}),s[i].counter++,s[i].atoms.push(e)}return Object.keys(s).map((n=>s[n]))}function squaredEuclidean(n,t){let e=0;for(let i=0;i<n.length;i++)e+=(n[i]-t[i])*(n[i]-t[i]);return e}function euclidean(n,t){return Math.sqrt(squaredEuclidean(n,t))}function distanceMatrix(n,t){const e=getMatrix(n.length);for(let i=0;i<n.length;i++)for(let s=0;s<=i;s++)e[i][s]=t(n[i],n[s]),e[s][i]=e[i][s];return e}function getMatrix(n){const t=[];for(let e=0;e<n;e++){const e=[];t.push(e);for(let t=0;t<n;t++)e.push(0)}return t}var heap$1={exports:{}};!function(n,t){(function(){var t,e,i,s,a,r,o,l,f,g,u,d,c,h,b;i=Math.floor,g=Math.min,e=function(n,t){return n<t?-1:n>t?1:0},f=function(n,t,s,a,r){var o;if(null==s&&(s=0),null==r&&(r=e),s<0)throw new Error("lo must be non-negative");for(null==a&&(a=n.length);s<a;)r(t,n[o=i((s+a)/2)])<0?a=o:s=o+1;return[].splice.apply(n,[s,s-s].concat(t)),t},r=function(n,t,i){return null==i&&(i=e),n.push(t),h(n,0,n.length-1,i)},a=function(n,t){var i,s;return null==t&&(t=e),i=n.pop(),n.length?(s=n[0],n[0]=i,b(n,0,t)):s=i,s},l=function(n,t,i){var s;return null==i&&(i=e),s=n[0],n[0]=t,b(n,0,i),s},o=function(n,t,i){var s;return null==i&&(i=e),n.length&&i(n[0],t)<0&&(t=(s=[n[0],t])[0],n[0]=s[1],b(n,0,i)),t},s=function(n,t){var s,a,r,o,l,f;for(null==t&&(t=e),l=[],a=0,r=(o=function(){f=[];for(var t=0,e=i(n.length/2);0<=e?t<e:t>e;0<=e?t++:t--)f.push(t);return f}.apply(this).reverse()).length;a<r;a++)s=o[a],l.push(b(n,s,t));return l},c=function(n,t,i){var s;if(null==i&&(i=e),-1!==(s=n.indexOf(t)))return h(n,0,s,i),b(n,s,i)},u=function(n,t,i){var a,r,l,f,g;if(null==i&&(i=e),!(r=n.slice(0,t)).length)return r;for(s(r,i),l=0,f=(g=n.slice(t)).length;l<f;l++)a=g[l],o(r,a,i);return r.sort(i).reverse()},d=function(n,t,i){var r,o,l,u,d,c,h,b,D;if(null==i&&(i=e),10*t<=n.length){if(!(l=n.slice(0,t).sort(i)).length)return l;for(o=l[l.length-1],u=0,c=(h=n.slice(t)).length;u<c;u++)i(r=h[u],o)<0&&(f(l,r,0,null,i),l.pop(),o=l[l.length-1]);return l}for(s(n,i),D=[],d=0,b=g(t,n.length);0<=b?d<b:d>b;0<=b?++d:--d)D.push(a(n,i));return D},h=function(n,t,i,s){var a,r,o;for(null==s&&(s=e),a=n[i];i>t&&s(a,r=n[o=i-1>>1])<0;)n[i]=r,i=o;return n[i]=a},b=function(n,t,i){var s,a,r,o,l;for(null==i&&(i=e),a=n.length,l=t,r=n[t],s=2*t+1;s<a;)(o=s+1)<a&&!(i(n[s],n[o])<0)&&(s=o),n[t]=n[s],s=2*(t=s)+1;return n[t]=r,h(n,l,t,i)},t=function(){function n(n){this.cmp=null!=n?n:e,this.nodes=[]}return n.push=r,n.pop=a,n.replace=l,n.pushpop=o,n.heapify=s,n.updateItem=c,n.nlargest=u,n.nsmallest=d,n.prototype.push=function(n){return r(this.nodes,n,this.cmp)},n.prototype.pop=function(){return a(this.nodes,this.cmp)},n.prototype.peek=function(){return this.nodes[0]},n.prototype.contains=function(n){return-1!==this.nodes.indexOf(n)},n.prototype.replace=function(n){return l(this.nodes,n,this.cmp)},n.prototype.pushpop=function(n){return o(this.nodes,n,this.cmp)},n.prototype.heapify=function(){return s(this.nodes,this.cmp)},n.prototype.updateItem=function(n){return c(this.nodes,n,this.cmp)},n.prototype.clear=function(){return this.nodes=[]},n.prototype.empty=function(){return 0===this.nodes.length},n.prototype.size=function(){return this.nodes.length},n.prototype.clone=function(){var t;return(t=new n).nodes=this.nodes.slice(0),t},n.prototype.toArray=function(){return this.nodes.slice(0)},n.prototype.insert=n.prototype.push,n.prototype.top=n.prototype.peek,n.prototype.front=n.prototype.peek,n.prototype.has=n.prototype.contains,n.prototype.copy=n.prototype.clone,n}(),n.exports=t}).call(commonjsGlobal)}(heap$1);var heap=heap$1.exports,Heap=heap;class Cluster{constructor(){this.children=[],this.height=0,this.size=1,this.index=-1,this.isLeaf=!1}cut(n){if("number"!=typeof n)throw new TypeError("threshold must be a number");if(n<0)throw new RangeError("threshold must be a positive number");let t=[this];const e=[];for(;t.length>0;){const i=t.shift();n>=i.height?e.push(i):t=t.concat(i.children)}return e}group(n){if(!Number.isInteger(n)||n<1)throw new RangeError("groups must be a positive integer");const t=new Heap(((n,t)=>t.height-n.height));for(t.push(this);t.size()<n;){const n=t.pop();if(0===n.children.length)break;n.children.forEach((n=>t.push(n)))}const e=new Cluster;return e.children=t.toArray(),e.height=this.height,e}traverse(n){!function n(t,e){if(e(t),t.children)for(const i of t.children)n(i,e)}(this,n)}indices(){const n=[];return this.traverse((t=>{t.isLeaf&&n.push(t.index)})),n}}function singleLink(n,t){return Math.min(n,t)}function completeLink(n,t){return Math.max(n,t)}function averageLink(n,t,e,i,s){return i/(i+s)*n+s/(i+s)*t}function weightedAverageLink(n,t){return(n+t)/2}function centroidLink(n,t,e,i,s){return i/(i+s)*n+s/(i+s)*t+-i*s/(i+s)**2*e}function medianLink(n,t,e){return n/2+t/2-e/4}function wardLink(n,t,e,i,s,a){return(i+a)/(i+s+a)*n+(s+a)/(i+s+a)*t+-a/(i+s+a)*e}function wardLink2(n,t,e,i,s,a){const r=(i+a)/(i+s+a),o=(s+a)/(i+s+a),l=-a/(i+s+a);return Math.sqrt(r*n*n+o*t*t+l*e*e)}function agnes(n,t={}){const{distanceFunction:e=euclidean,method:i="complete",isDistanceMatrix:s=!1}=t;let a;s||(n=distanceMatrix(n,e));let r=new Matrix(n);const o=r.rows;if("string"==typeof i)switch(i.toLowerCase()){case"single":a=singleLink;break;case"complete":a=completeLink;break;case"average":case"upgma":a=averageLink;break;case"wpgma":a=weightedAverageLink;break;case"centroid":case"upgmc":a=centroidLink;break;case"median":case"wpgmc":a=medianLink;break;case"ward":a=wardLink;break;case"ward2":a=wardLink2;break;default:throw new RangeError(`unknown clustering method: ${i}`)}else if("function"!=typeof i)throw new TypeError("method must be a string or function");let l=[];for(let n=0;n<o;n++){const t=new Cluster;t.isLeaf=!0,t.index=n,l.push(t)}for(let n=0;n<o-1;n++){const[n,t,e]=getSmallestDistance(r),i=l[n],s=l[t],o=new Cluster;o.size=i.size+s.size,o.children.push(i,s),o.height=e;const f=[o],g=new Matrix(r.rows-1,r.rows-1),u=e=>getPreviousIndex(e,Math.min(n,t),Math.max(n,t));for(let o=1;o<g.rows;o++){const d=u(o),c=l[d];f.push(c);for(let l=0;l<o;l++)if(0===l){const f=a(r.get(n,d),r.get(d,t),e,i.size,s.size,c.size);g.set(o,l,f),g.set(l,o,f)}else{const n=r.get(d,u(l));g.set(o,l,n),g.set(l,o,n)}}l=f,r=g}return l[0]}function getSmallestDistance(n){let t=1/0,e=0,i=0;for(let s=1;s<n.rows;s++)for(let a=0;a<s;a++)n.get(s,a)<t&&(t=n.get(s,a),e=s,i=a);return[e,i,t]}function getPreviousIndex(n,t,e){return(n-=1)>=t&&n++,n>=e&&n++,n}var full={},openchemlibFull={};!function(n){!function(t){var e,i;"undefined"!=typeof self?(e=!0,i=self):void 0!==commonjsGlobal?(e=!1,i=commonjsGlobal):(e=!1,i=t);var s,a=i.document||{};a.compatMode||(a.compatMode="CSS1Compat"),e?s=i:((s={}).setTimeout=i.setTimeout?i.setTimeout.bind(i):o,s.clearTimeout=i.clearTimeout?i.clearTimeout.bind(i):o,s.setInterval=i.setInterval?i.setInterval.bind(i):o,s.clearInterval=i.clearInterval?i.clearInterval.bind(i):o,s.Error=i.Error,s.Math=i.Math,s.RegExp=i.RegExp,s.TypeError=i.TypeError),s.document||(s.document=a);var r=function(n){var t=n.document,e={},i={userAgent:"webkit"};function s(){}var r=s;r.__moduleStartupDone=s;var o,l,f,g,u,d,c,h="object",b="anonymous",D="fnStack",H="\n",j={4:1,9:1,5:1,7:1},m="Unknown",A="boolean",C="number",T="string",p="function",I=2147483647,P='For input string: "',M="null",w="__noinit__",N={4:1,5:1,7:1},L={4:1,19:1,28:1},U=" (copy)",k={4:1,9:1,15:1,5:1,11:1,7:1,14:1},J=65536,y=65535,B=1e4,R=", length: ",E="Index: ",x=", Size: ",F="fromIndex: ",Q=", toIndex: ",S={13:1,4:1,5:1},X={4:1},z={8:1,4:1,5:1},G=16777215,q=65280,Y=.30000001192092896,v=545460846592,Z=4294967296,O=8589934592,V=17179869184,K=34359738368,W=68719476736,_=137438953472,$=274877906944,nn={12:1,4:1,5:1},tn=536870912,en=2.617993878,sn=3.665191429,an=6.283185307179586,rn=3.141592653589793,on=1.5707963267948966,ln=16384,fn=4096,gn={l:0,m:0,h:1},un={l:0,m:0,h:2},dn={l:0,m:0,h:4},cn=1920,hn=1024,bn=234881024,Dn=167772160,Hn=100663296,jn=201326592,mn=114688,An=4063232,Cn=3801088,Tn=3538944,pn=3014656,In=3145728,Pn=2097152,Mn=393216,wn=917504,Nn=1966080,Ln=0xf8000000000,Un=0xf0000000000,kn=0xe8000000000,Jn=0xd8000000000,yn=0xb8000000000,Bn=8796093022208,Rn=549755813888,En=1649267441664,xn=3848290697216,Fn=8246337208320,Qn=29360128,Sn=268435456,Xn=8192,zn=2048,Gn=-1.5707963267948966,qn=130560,Yn=6291456,vn=-2.0943951023931953,Zn=1.0471975511965976,On=.5235987755982988,Vn=786432,Kn=524288,Wn=262144,_n=-16777216,$n=-65536,nt=-32768,tt='<DrawingObject type="',et="></DrawingObject>",it={4:1,5:1,16:1},st={4:1,5:1},at="unsupported atomicNo:",rt=2.8415926535897933,ot={41:1,4:1,9:1,5:1,7:1},lt={4:1,5:1,11:1,7:1},ft={10:1,4:1,5:1},gt=131072,ut=196608,dt={l:6,m:0,h:4},ct=1048576,ht=3221225472,bt={l:0,m:0,h:3},Dt=8388608,Ht=5e-324,jt=17976931348623157e292,mt={90:1,85:1,4:1,9:1,5:1,7:1},At="text",Ct={30:1,60:1,62:1},Tt={30:1,60:1,104:1,62:1,121:1},pt={4:1,5:1,30:1,60:1,104:1,21:1,62:1,121:1,193:1},It="??",Pt=2013265920,Mt=32505856,wt=31744,Nt={152:1,4:1,9:1,5:1,11:1,7:1},Lt=33554432,Ut=67108864,kt=32768,Jt=-33554433,yt=-33292289,Bt=-3.141592653589793,Rt=4194303,Et=3072,xt={59:1,4:1,5:1},Ft=.7853981633974483,Qt=3.061592653589793,St=1073741824,Xt=541165879296,zt={17:1,4:1,5:1,7:1},Gt=281.17,qt=289.19,Yt=294.21,vt="0.0000",Zt="M  END\n",Ot="ATOMS",Vt=-2147483648,Kt="M  END",Wt="$$$$",_t="M  V30 ",$t="M  V30 COUNTS ",ne=")\n",te="M  V30 MDLV30/STEREL",ee="M  V30 MDLV30/STERAC",ie=34028234663852886e22,se={l:2,m:0,h:4},ae=4194304,re={l:4179966,m:4063288,h:7},oe={l:4194302,m:4193343,h:7},le={90:1,85:1,98:1,4:1,9:1,5:1,7:1},fe='" ',ge='stroke="',ue='stroke-width="',de='" />',ce='class="event" ',he='opacity="0" />',be=16711680,De="Assignment of aromatic double bonds failed",He=1099511627776,je=2199023255552,me=4398046511104,Ae={115:1,4:1},Ce="Members of ESR groups must only be stereo centers with known configuration.",Te="Over- or under-specified stereo feature or more than one racemic type bond",pe="Ambiguous configuration at stereo center because of 2 parallel bonds",Ie={97:1,113:1,24:1,4:1},Pe=1e5,Me="style",we=3.1415927410125732,Ne=1.5707963705062866,Le=.029999999329447746,Ue=6.2831854820251465,ke=1.9106119871139526,Je=2.2639999389648438,ye=2.16759991645813,Be=2.0662999153137207,Re=2.3561999797821045,Ee=2.2844998836517334,xe=1.9106120066311025,Fe=2.094395160675049,Qe=.6000000238418579,Se=1.7999999523162842,Xe=.05000000074505806,ze={4:1,9:1,5:1,7:1,48:1},Ge=.2617993950843811,qe=2.0943951023931953,Ye=1.2000000476837158,ve=1.4299999475479126,Ze=1.659999966621399,Oe=1.4600000381469727,Ve=1.8200000524520874,Ke=2.4600000381469727,We=2.4200000762939453,_e=2.450000047683716,$e=2.440000057220459,ni=2.4000000953674316,ti=2.319999933242798,ei=2.2899999618530273,ii=1.8600000143051147,si=2.5299999713897705,ai=2.490000009536743,ri=2.4700000286102295,oi=2.880000114440918,li=2.9200000762939453,fi=2.869999885559082,gi=2.8299999237060547,ui=2.7899999618530273,di=2.809999942779541,ci=2.799999952316284,hi=3.049999952316284,bi=.3199999928474426,Di=1.3300000429153442,Hi=1.3899999856948853,ji=1.159999966621399,mi=1.1100000143051147,Ai=1.0700000524520874,Ci=1.9600000381469727,Ti=1.7100000381469727,pi=1.3600000143051147,Ii=1.340000033378601,Pi=1.2200000286102295,Mi=1.2400000095367432,wi=1.2100000381469727,Ni=1.850000023841858,Li=1.6299999952316284,Ui=1.4700000286102295,ki=1.2799999713897705,Ji=1.440000057220459,yi=1.399999976158142,Bi=1.7599999904632568,Ri=1.7300000190734863,Ei=1.7200000286102295,xi=1.6799999475479126,Fi=1.690000057220459,Qi=1.6699999570846558,Si=1.649999976158142,Xi=1.7000000476837158,zi=1.6200000047683716,Gi=1.3700000047683716,qi=1.2899999618530273,Yi=1.4500000476837158,vi=1.5700000524520874,Zi=-.5235987755982988,Oi=-1.0471975511965976,Vi=-.7853981633974483,Ki=.017453292519943295,Wi=.17453292519943295,_i=1e-4,$i={168:1},ns=57.29577951308232,ts=.021922173386725217,es=1e-8,is=2.5120960256267386,ss=1e-5,as="MMFF94s+",rs="nonbonded cutoff",os="dielectric constant",ls="dielectric model",fs="angle bend",gs="bond stretch",us="electrostatic",ds="out of plane",cs="stretch bend",hs="torsion angle",bs="van der waals",Ds={4:1,9:1,5:1,11:1,7:1},Hs=.07000000000000006,js=.1200000000000001,ms=-7.840000000000001,As="OCL_RXN_V1.0:",Cs="'$MOL' tag not found",Ts="'M  END' not found",ps="\nActelion Java MolfileCreator 2.0\n\n  0  0  0  0  0  0              0 V3000\n",Is="M  V30 END CTAB",Ps=2475109711874,Ms=2475109711875,ws=2887426572290,Ns=2887426572291,Ls=2887627898882,Us=2887627898883,ks=2887627997186,Js=3437182386178,ys=3437182386179,Bs=3437383712770,Rs=3437383811074,Es=3437652148226,xs=3437652377602,Fs=4674132967426,Qs=4674334294018,Ss=4674334392322,Xs=4674602729474,zs=4674602958850,Gs=5086449827842,qs=5086449827848,Ys=5086651154434,vs=5086651252738,Zs=5086651252743,Os=5086919589890,Vs=5086919688194,Ks=5636406968322,Ws=5636407066626,_s=5636675502082,$s={l:589826,m:590112,h:4},na={l:589827,m:590112,h:4},ta={l:589826,m:590160,h:4},ea={l:589827,m:590160,h:4},ia={l:688130,m:590160,h:4},sa={l:589826,m:590224,h:4},aa={l:589827,m:590224,h:4},ra={l:819203,m:590224,h:4},oa={l:589826,m:590368,h:4},la={l:688130,m:590368,h:4},fa={l:819202,m:590368,h:4},ga={l:819208,m:590368,h:4},ua={l:589826,m:590416,h:4},da={l:589832,m:590416,h:4},ca={l:688130,m:590416,h:4},ha={l:819202,m:590416,h:4},ba={l:589826,m:598304,h:4},Da={l:589827,m:598304,h:4},Ha={l:688130,m:598304,h:4},ja={l:1114114,m:598304,h:4},ma={l:1212418,m:598304,h:4},Aa={l:589826,m:598308,h:4},Ca={l:589826,m:688416,h:4},Ta={l:589826,m:688464,h:4},pa={l:589826,m:688720,h:4},Ia={l:688130,m:688720,h:4},Pa={l:589826,m:590112,h:288},Ma={l:589826,m:590112,h:336},wa={l:589826,m:688416,h:336},Na={l:589826,m:688464,h:336},La={l:688130,m:688464,h:336},Ua={l:589826,m:590112,h:400},ka={l:589826,m:688416,h:400},Ja={l:589826,m:688464,h:400},ya={l:688130,m:688464,h:400},Ba={l:589826,m:819488,h:400},Ra={l:589826,m:819536,h:400},Ea={l:589826,m:819600,h:400},xa={l:688130,m:819600,h:400},Fa={l:819202,m:819600,h:400},Qa={l:589831,m:688416,h:592},Sa={l:589831,m:688464,h:592},Xa={l:688135,m:688464,h:592},za={l:589831,m:819536,h:592},Ga={l:688135,m:819536,h:592},qa={l:688135,m:819600,h:592},Ya={l:589832,m:1212704,h:592},va={l:589832,m:1212752,h:592},Za={l:688136,m:1212752,h:592},Oa={l:589831,m:688464,h:656},Va={l:589826,m:590112,h:8480},Ka={l:589826,m:688416,h:8480},Wa={l:589826,m:688464,h:8480},_a={l:688130,m:688464,h:8480},$a={l:819202,m:819600,h:8480},nr={l:688135,m:1212752,h:8480},tr={l:589832,m:1213008,h:8480},er={l:688136,m:1213008,h:8480},ir={l:589826,m:590112,h:8484},sr={l:589826,m:590160,h:8484},ar={l:688130,m:598304,h:8484},rr=.6262000203132629,or=-1.3825000524520874,lr=.33169999718666077,fr=-1.4915000200271606,gr=.3540000021457672,ur=.38179999589920044,dr=-.6019999980926514,cr=.07999999821186066,hr=-.7379999756813049,br="Atom-types are 64-bit numbers describing atoms and their near surrounding.",Dr="Recognized atom types and their contributions are:",Hr="Druglikeness predictor not properly initialized.",jr=3.009999990463257,mr=-.17000000178813934,Ar=-.1809999942779541,Cr=-.2029999941587448,Tr=2147483648,pr="MMFF94",Ir="MMFF94s",Pr="117\nint,int,int,int,float\n0,2,0,0,0.020\n1,2,1,2,0.030\n1,2,2,2,0.027\n1,2,2,3,0.026\n1,2,2,5,0.013\n1,2,2,37,0.032\n2,2,2,5,0.013\n2,2,3,5,0.012\n2,2,5,5,0.006\n2,2,5,6,0.027\n2,2,5,37,0.017\n2,2,5,40,0.012\n2,2,5,41,0.008\n0,3,0,0,0.130\n1,3,1,7,0.146\n1,3,2,7,0.138\n1,3,3,7,0.134\n1,3,5,7,0.122\n1,3,6,7,0.141\n1,3,7,10,0.129\n1,3,7,37,0.138\n2,3,5,7,0.113\n2,3,5,9,0.081\n2,3,6,7,0.127\n2,3,7,10,0.116\n3,3,5,7,0.113\n3,3,6,7,0.127\n5,3,5,7,0.103\n5,3,5,9,0.074\n5,3,5,54,0.078\n5,3,6,7,0.119\n5,3,7,10,0.102\n5,3,9,40,0.067\n6,3,7,37,0.127\n7,3,10,10,0.113\n7,3,20,20,0.151\n9,3,40,40,0.057\n0,8,0,0,0.000\n0,10,0,0,0.015\n1,10,1,3,0.015\n1,10,3,6,0.015\n1,10,3,28,0.015\n3,10,3,28,0.015\n3,10,28,28,0.015\n0,17,0,0,0.000\n0,26,0,0,0.000\n0,30,0,0,0.010\n5,30,20,30,0.008\n0,37,0,0,0.035\n1,37,37,37,0.040\n2,37,37,37,0.031\n3,37,37,37,0.027\n5,37,37,37,0.015\n5,37,37,38,0.046\n5,37,37,63,0.008\n5,37,37,64,0.012\n5,37,37,69,0.016\n5,37,38,38,0.084\n6,37,37,37,0.048\n15,37,37,37,0.025\n37,37,37,40,0.046\n0,39,0,0,0.020\n1,39,63,63,0.012\n23,39,63,63,-0.014\n23,39,63,65,0.021\n23,39,65,65,0.062\n0,40,0,0,0.030\n1,40,28,37,0.030\n2,40,28,28,0.030\n3,40,28,28,0.030\n28,40,28,37,0.030\n0,41,0,0,0.180\n1,41,32,32,0.178\n2,41,32,32,0.161\n5,41,32,32,0.158\n0,43,0,0,0.000\n0,45,0,0,0.150\n0,49,0,0,0.000\n50,49,50,50,0.000\n0,54,0,0,0.020\n1,54,3,36,0.016\n3,54,36,36,0.018\n0,55,0,0,0.020\n1,55,36,57,0.020\n36,55,36,57,0.020\n0,56,0,0,0.020\n1,56,36,57,0.020\n36,56,36,57,0.020\n0,57,0,0,0.080\n5,57,55,55,0.038\n56,57,56,56,0.158\n0,58,0,0,0.025\n0,63,0,0,0.050\n5,63,39,64,0.019\n5,63,39,66,0.068\n5,63,44,64,0.014\n5,63,44,66,0.055\n5,63,59,64,0.033\n5,63,59,66,0.085\n37,63,39,64,0.010\n0,64,0,0,0.040\n5,64,63,64,0.006\n5,64,63,66,0.043\n5,64,64,65,0.052\n5,64,65,66,0.094\n37,64,63,64,-0.01\n0,67,0,0,0.070\n0,69,0,0,0.070\n32,69,37,37,0.067\n0,73,0,0,0.000\n0,78,0,0,0.045\n5,78,78,81,0.046\n0,80,0,0,0.080\n5,80,81,81,0.057\n0,81,0,0,0.025\n36,81,78,80,0.016\n0,82,0,0,0.000\n",Mr={196:1,4:1,5:1,7:1},wr="div",Nr="position:absolute;left:",Lr="px;",Ur="rgba(",kr=4278190080,Jr="px",yr={203:1},Br={378:1,27:1},Rr={379:1,27:1},Er="position:absolute;width:",xr="px;height:",Fr={46:1,4:1,5:1,7:1},Qr=22.5,Sr=21.176470588235293,Xr={205:1,27:1},zr={206:1,27:1},Gr={251:1,27:1},qr={365:1,27:1},Yr="true",vr="data-idcode",Zr="MutationObserver",Or="Parse exception ",Vr="error setting idcode data ",Kr={249:1,27:1},Wr={102:1,27:1},_r="data:image/gif;base64,R0lGODlhHABGANUAAISChPLx8ubl5uDf4NLR0s/OzwAA//Hx8tHR0svLzMXFxuvs7OXm5t/g4MvMzAD/APf49+vs6+Xm5dfY18vMy/j49/Ly8enp6ODg38bGxdbTzv8AAPj39+zr68bFxcC/v/////39/fr6+vf39/T09PHx8e7u7uzs7Obm5uPj4+Dg4N3d3dra2tfX19TU1NHR0czMzMvLy8nJycbGxsPDw8DAwL29vbq6uqqqqiEhIQAAAAAAAAAAAAAAAAAAAAAAACwAAAAAHABGAAAG/0CQcEgsGo0AkGbJbDqfzqQGQK1ar1iqUgrIeb/gsFi33eZAp7R6zV6Tp+bTzfahzWSUAsLVYq02KQIXEThvXDknNjU0GTIxBS98fhuUFwsmhWVTiIsKjpCSf5SUJhaZcJsnNJ4OeqEqo6Mkp4cnHp+RE36wsaO0cTIwrn0rDb2jIr+pCQUEoQPHlCIhyl0nw34DKccc0yDViLl+GNu9I97fhnGv5bHdIUPgJ8Qq5To6GyTn8PHqqbspJFC6pw9dP03Wit27t2GhDngO0yFEVI9BQx0H7omIeBCVtRQoHJK4F+IeiIVC5Am4Z+IeBJMmhZiUd8Ghjo0oOco7YeIACf8IBo9I9IgIh9GjSJMi9ddFjFOnTM+0mdomqhw6dvBgW2Eg0CB5ihjhCmWgrCVMVjuNJVa2bSl5q2S02kOvbdtZVm89ErdChV278oJtbfC3bTKrzJwRG1C47DR5W7UVfje0Fl9yhfeltMpuskF59FL8Lchv88QTACXYJV1EXrFAq1GenGm1YlufJGGSqRwH5IWyAfTpnm2a6AlBHUyU+ImTeEyaPJdX8Cb7uVWePoGWFipPqXelUZ+K/xIVDdXzJ6zOqXMnD10/D7wSshq20d5QD/Kflaf2PrH8AL5lVVxzvQIggHidphcouvR14IGBCfNeMQ8CeNhpiT1TYX6PWRVvWQoVUibPZSA+qBlvqbAT4mdWhfbgSLKhaE1qB8JY0m4yIvKaADUCFWOOJ1QEoE/n/Aikb/kFVyQZNgGJnHLM3SiTdaddEB0J0/FjE22nYRelUB3V8t2YRjG15Zlo+gPmmkWgAsWbcMKRxZx0VhEEADs=",$r="data:image/gif;base64,R0lGODlhHABGANUAAISChH59fnt6e3h3eHRzdMTDxLi3uJiXmAAAw3d3eLe3uKamp5eXmI+PkIaGh4ODhH1+fsPExLe4uJGSkgDDAM/Qz8DBwHh4d76+vZ6enZiYl4qKidbTzsMAANDPz8fGxqSjo5KRkYqJiYSDg////9LS0svLy76+vru7u7i4uLW1tbKysq+vr6ysrKmpqaOjo6GhoZubm5iYmJWVlZKSko+Pj4yMjImJiYSEhIODg4CAgHh4eG9vb19fXyEhIQAAACwAAAAAHABGAAAG/0CScEgsGo0AEmfJbDqfziQHQK1ar1iqUgrweb/gsPi33YrPaF956qXx3vC4PL7u+t4EQkIQ0AEcNzY1NB0HMRkwPXVePHk7fDojgIKEHR2IL4pTZncEAwIQOjkOIpSWpyALmlyMF5A4k4Mzp6cuq5w8kA+xNLO0p7dsd6GjgbK/pyzBdjyRvL7ILCvLjLvGEzMayC3SKtR3DhuCITMy290p3zzGvQznKyoKKOqU2ZY/Px0u3PAGKCfqGvSSEePej33d/J2woK4XPnwdHv6AJ7GAunIF8S3Ax0IiBgsFPqjTEEOiC3wr8KF4+MGEupI/XuBrgU8FvoUR8LlcdCeDxP8fHR9ikGjCgzoYLxYghCcBxceQJkxUKKGuh9WrWLNi5Zmmq5pNwtzMGSuHJx49kP6wQ2AIkTpHkCStRYAA09tHxEhRoss3lTpXfWCxm8GXry2zup4VLqwu7+DFfJWZdfYYMgJp6qwJwqYBMj9vZsONK+cZnbrBDErDk0dPVufCS1UoDDgwBuzPChmarQ37oYoUDy2axchXKUqV+EKOPERXKc0fNn+cwNfyJSbnQQ3gs6BzJ1hmiFLFfghSp1GzSLEzdQqypVSqZrXK18rVKxqeYsnqN9sIbR+1lFDQViJmwdWHXAFSQIFdBX6SVymDKCihX2YBpoNg9Ugo4WHfMZKO2GAaatiYKM+EKKFkHd5BWYYmUoCZWZrVwJmJn6kjWg3kyECjaWahtuNq85hVjwYhnvTQbGYJhJGGRqb0wz+6pchDbUxy8xB7wkm5pILYXfmUSGaRlAGXCOEDHFHWpbeUStN1p0546v32Ez7nSanmZ019GdVUy/xwx3yAWrXGEYQWChYUiCa6SRaMNlpFEAA7",no=21.333333333333332,to={238:1,27:1},eo="width",io="height",so="offsetHeight",ao="offsetWidth",ro="Null widget handle. If you are creating a composite, ensure that initWidget() has been called.",oo="Style names cannot be empty",lo="aria-hidden",fo={43:1,37:1,40:1,39:1,44:1,35:1,34:1},go={43:1,37:1,40:1,39:1,44:1,35:1,34:1,30:1},uo="left",co="visibility",ho="hidden",bo="visible",Do="popupContent",Ho=1281818470,jo={25:1},mo={167:1,25:1},Ao=23.333333333333332,Co=4294967295,To="font: 12px sans-serif",po="Atom Properties",Io="cellPadding",Po="Cancel",Mo="excluded atoms:",wo="allowed atoms:",No="200px",Lo="any ring state",Uo={324:1,27:1},ko="disabled",Jo="px Helvetica",yo="Helvetica",Bo="canvas",Ro="undefined",Eo=.08726646502812703,xo=4278190335,Fo=.003921568859368563,Qo="CENTER",So="position",Xo="absolute",zo="CSS1Compat",Go={38:1,31:1,4:1,18:1,20:1},qo={36:1,31:1,4:1,18:1,20:1},Yo={31:1,86:1,4:1,18:1,20:1},vo={58:1,4:1,18:1,20:1},Zo="load",Oo={146:1,4:1,19:1,28:1},Vo='Too many percent/per mille characters in pattern "',Ko=1048575,Wo=17592186044416,_o=1e9,$o=-17592186044416,nl=16777216,tl="__gwtLastUnhandledEvent",el="__uiObjectID",il="cellSpacing",sl="Column index: ",al=", Column size: ",rl="Row index: ",ol=", Row size: ",ll="overflow",fl={43:1,37:1,40:1,39:1,44:1,182:1,35:1,34:1,30:1},gl={89:1,4:1,18:1,20:1},ul=5.56,dl=11.12,cl=13.34,hl=14.44,bl=.3010299956639812,Dl="BigInteger divide by zero",Hl={l:0,m:0,h:524288},jl={18:1,133:1},ml={149:1},Al={30:1,60:1,62:1,131:1},Cl="delete",Tl=15525485,pl=5.960464477539063e-8,Il={4:1,149:1},Pl={4:1,18:1,20:1,93:1},Ml="Invalid UTF8 sequence",wl=.20000000298023224,Nl=" distance:",Ll="gGP`@dfyjidNcGI[WQCP`<",Ul={65:1},kl={},Jl={},yl={},Bl={},Rl={},El={},xl={},Fl={},Ql={},Sl={},Xl={},zl={},Gl={},ql={},Yl={},vl={},Zl={},Ol={},Vl={},Kl={},Wl={},_l={},$l={},nf={},tf={},ef={},sf={},af={},rf={},of={},lf={},ff={},gf={},uf={},df={},cf={},hf={},bf={},Df={},Hf={},jf={},mf={},Af={},Cf={},Tf={},pf={},If={},Pf={},Mf={},wf={},Nf={},Lf={},Uf={},kf={},Jf={},yf={},Bf={},Rf={};function Ef(){}function xf(n){return Array.isArray(n)&&n.he===Ef?Jl.Mc(n):n.toString()}function Ff(t,e){var i=n;if(""===t)return i;var s,a=t.split(".");(!(a[0]in i)&&i.execScript&&i.execScript("var "+a[0]),e)&&(e.prototype.fe.e=e);for(;a.length&&(s=a.shift());)i=i[s]=i[s]||!a.length&&e||{};return i}function Qf(n,t,e){var i=function(){return n.apply(i,arguments)};return t.apply(i,e),i}function Sf(){}function Xf(n,t){for(var e in t)t[e].configurable=!0;Object.defineProperties(n,t)}function zf(n,t,e){var i=l,s=i[n],a=kl.Bxb(s);s&&!a?o=s:((o=kl.wxb(t)).ge=e,!t&&(o.he=Ef),i[n]=o);for(var r=3;r<arguments.length;++r)arguments[r].prototype=o;a&&(o.fe=a)}function Gf(){}function qf(n,t){return kl.Njb(n,t)}function Yf(n,t,e,i,s,a){return kl.Rjb(n,t,e,i,s,0,a)}function vf(n,t,e,i,s,a){var r;return r=kl.Tjb(s,i),10!=s&&Vf(qf(n,a),t,e,s,r),r}function Zf(n){return Array.isArray(n)&&n.he===Ef}function Of(n,t,e){return kl.Vjb(n,t,e)}function Vf(n,t,e,i,s){return kl.Xjb(s,n),s.ge=t,s.he=Ef,kl.Zjb(s,e),kl.Yjb(s,i),s}function Kf(n){return String.fromCharCode(n)}function Wf(n){return!Array.isArray(n)&&n.he===Ef}function _f(n,t){return null!=n&&function(n,t){return ig(n)?!!d[t]:n.ge?!!n.ge[t]:ng(n)?!!u[t]:!!$f(n)&&!!g[t]}(n,t)}function $f(n){return typeof n===A}function ng(n){return typeof n===C}function tg(n){return null!=n&&kl.dlb(n)&&!(n.he===Ef)}function eg(n,t){return kl.elb(n,t)}function ig(n){return typeof n===T}function sg(n){return null==n?null:n}function ag(n){return 0|Math.max(Math.min(n,I),-2147483648)}function rg(n){var t;return _f(n,28)?n:((t=kl.Fwb(n))||(t=new yl.V8(n),Bl.S9(t)),t)}function og(n){return n.backingJsObject}function lg(n){var t;return t=Jl.UFb(n),Jl.gGb(n,t),t}function fg(n,t){var e;return e=Jl.UFb(n),Jl.gGb(n,e),e.f=t?8:0,e}function gg(n){var t;return(t=Jl.UFb(n)).k=n,t.f=1,t}kl.Ewb=function(){},kl.rxb=function(){null==f&&(f=[])},kl.pxb=function(){},kl.Cxb=function(n){function t(){}return t.prototype=n||{},new t},kl.Bxb=function(n){return n instanceof Array?n[0]:null},kl.wxb=function(n){var t=n&&n.prototype;return!t&&(t=l[n]),kl.Cxb(t)},kl.vxb=function(){},n.goog=n.goog||{},n.goog.global=n.goog.global||n,l={},Jl.Bc=function(n,t){return sg(n)===sg(t)},Jl.Cc=function(n){return n.fe},Jl.Dc=function(n){return Rl.sTb(n)},Jl.Gc=function(n,t){return ig(n)?Jl.DHb(n,t):ng(n)?Jl.tGb(n,t):$f(n)?Jl.mFb(n,t):Wf(n)?n.ib(t):Zf(n)?Jl.Bc(n,t):yl.w7(n,t)},Jl.Ic=function(n){return ig(n)?Jl.FHb():ng(n)?Jl.uGb():$f(n)?Jl.nFb():Wf(n)?n.fe:Zf(n)?Jl.Cc(n):yl.x7(n)},Jl.Kc=function(n){return ig(n)?Jl.GHb(n):ng(n)?Jl.vGb(n):$f(n)?Jl.oFb(n):Wf(n)?n.kb():Zf(n)?Jl.Dc(n):yl.y7(n)},Jl.Mc=function(n){return Jl.PFb(Jl.Ic(n))+"@"+Rl.LTb(Rl.KTb(Jl.Kc(n))).toString(16)},zf(1,null,{},Gf),o.ib=function(n){return Jl.Bc(this,n)},o.jb=function(){return Jl.Cc(this)},o.kb=function(){return Jl.Dc(this)},o.lb=function(){return Jl.PFb(Jl.Ic(this))+"@"+Rl.LTb(Rl.KTb(Jl.Kc(this))).toString(16)},o.equals=function(n){return this.ib(n)},o.hashCode=function(){return this.kb()},o.toString=function(){return this.lb()},yl.w7=function(n,t){return yl.C7(n)?yl.z7(n,t):sg(n)===sg(t)},yl.x7=function(n){return n.fe||Array.isArray(n)&&qf(kl.xqb,1)||kl.xqb},yl.y7=function(n){return yl.D7(n)?yl.A7(n):Rl.sTb(n)},yl.z7=function(n,t){return n.equals(t)},yl.A7=function(n){return n.hashCode()},yl.B7=function(){return[]},yl.C7=function(n){return!!n&&!!n.equals},yl.D7=function(n){return!!n&&!!n.hashCode},yl.E7=function(n){return n.toString?n.toString():"[JavaScriptObject]"},Bl.R9=function(){var n,t;Bl.R9=Sf,t=!Bl.$9(),n=new Bl.hab,Bl.Q9=t?new Bl._9:n},Bl.S9=function(n){Bl.R9(),Bl.Q9.td(n)},Bl.T9=function(n){var t;return Bl.R9(),t=Bl.Q9.ud(n),Bl.U9(t)},Bl.U9=function(t){var e;for("S9","Xz",e=n.Math.min(t.length,5)-1;e>=0;e--)if(Jl.DHb(t[e].d,"S9")||Jl.DHb(t[e].d,"Xz")){t.length>=e+1&&Rl.LTb(t).splice(0,e+1);break}return t},Bl.V9=function(n){var t=/function(?:\s+([\w$]+))?\s*\(/.exec(n);return t&&t[1]||b},Bl.W9=function(n){return Bl.R9(),n&&n[D]?n[D]:[]},Bl.X9=function(n){return Bl.R9(),n.name||(n.name=Bl.V9(n.toString()))},Bl.Y9=function(n){return Bl.R9(),parseInt(n)||-1},Bl.Z9=function(n){Bl.R9();var t=n.backingJsObject;if(t&&t.stack){var e=t.stack,i=t+H;return e.substring(0,i.length)==i&&(e=e.substring(i.length)),e.split(H)}return[]},Bl.$9=function(){return Error.stackTraceLimit>0?(n.Error.stackTraceLimit=Error.stackTraceLimit=64,!0):"stack"in new Error},zf(653,1,{}),Bl._9=function(){},zf(388,653,{},Bl._9),o.td=function(n){var t={},e=[];n[D]=e;for(var i=arguments.callee.caller;i;){var s=Bl.X9(i);e.push(s);var a,r,o=":"+s,l=t[o];if(l)for(a=0,r=l.length;a<r;a++)if(l[a]===i)return;(l||(t[o]=[])).push(i),i=i.caller}},o.ud=function(n){var t,e,i,s;for(i=Bl.W9(n),e=yl.e9(i),s=vf(kl.Kub,j,96,e,0,1),t=0;t<e;t++)s[t]=new Jl.sHb(yl.d9(i,t),null,-1);return s},Bl.cab=function(n,t){var e,i,s,a,r,o,l,f,g;return f="",0==Rl.LTb(t).length?n.vd(m,b,-1,-1):(g=Jl.SHb(t),Jl.DHb(Rl.LTb(g).substr(0,3),"at ")&&(Rl.GTb(3,Rl.LTb(g).length+1),g=Rl.LTb(g).substr(3)),g=Bl.dab(g),-1==(r=Rl.LTb(g).indexOf("("))?-1==(r=Rl.LTb(g).indexOf("@"))?(f=g,g=""):(f=Jl.SHb((Rl.GTb(r+1,Rl.LTb(g).length+1),Rl.LTb(g).substr(r+1))),g=Jl.SHb((Rl.FTb(0,r,Rl.LTb(g).length),Rl.LTb(g).substr(0,r)))):(e=Rl.LTb(g).indexOf(")",r),Rl.FTb(r+1,e,Rl.LTb(g).length),f=Rl.LTb(g).substr(r+1,e-(r+1)),g=Jl.SHb((Rl.FTb(0,r,Rl.LTb(g).length),Rl.LTb(g).substr(0,r)))),-1!=(r=Jl.HHb(g,bg(46)))&&(Rl.GTb(r+1,Rl.LTb(g).length+1),g=Rl.LTb(g).substr(r+1)),(0==Rl.LTb(g).length||Jl.DHb(g,"Anonymous function"))&&(g=b),o=Jl.KHb(f,bg(58)),s=Jl.LHb(f,bg(58),o-1),l=-1,i=-1,a=m,-1!=o&&-1!=s&&(Rl.FTb(0,s,Rl.LTb(f).length),a=Rl.LTb(f).substr(0,s),l=Bl.Y9((Rl.FTb(s+1,o,Rl.LTb(f).length),Rl.LTb(f).substr(s+1,o-(s+1)))),i=Bl.Y9((Rl.GTb(o+1,Rl.LTb(f).length+1),Rl.LTb(f).substr(o+1)))),n.vd(a,g,l,i))},Bl.dab=function(n){return n.replace(/\[.*?\]/g,"")},zf(654,653,{}),o.td=function(n){},o.vd=function(n,t,e,i){return new Jl.sHb(t,n+"@"+i,e<0?-1:e)},o.ud=function(n){var t,e,i,s,a,r;if(s=Bl.Z9(n),a=vf(kl.Kub,j,96,0,0,1),t=0,0==(i=yl.e9(s)))return a;for(r=Bl.cab(this,yl.d9(s,0)),Jl.DHb(r.d,b)||(a[t++]=r),e=1;e<i;e++)a[t++]=Bl.cab(this,yl.d9(s,e));return a},Bl.hab=function(){},zf(389,654,{},Bl.hab),o.vd=function(n,t,e,i){return new Jl.sHb(t,n,-1)},kl.Ljb=function(n){return n},kl.Njb=function(n,t){return Jl.$Fb(n,t)},kl.Ojb=function(n){return null==n.__elementTypeCategory$?10:n.__elementTypeCategory$},kl.Pjb=function(n){return n.__elementTypeId$},kl.Rjb=function(n,t,e,i,s,a,r){var o,l,f,g,u;if(g=s[a],o=(f=a==r-1)?i:0,u=kl.Tjb(o,g),10!=i&&Vf(qf(n,r-a),t[a],e[a],o,u),!f)for(++a,l=0;l<g;++l)kl.Vjb(u,l,kl.Rjb(n,t,e,i,s,a,r));return u},kl.Tjb=function(n,t){var e,i=new Array(t);switch(n){case 14:case 15:e=0;break;case 16:e=!1;break;default:return i}for(var s=0;s<t;++s)i[s]=e;return i},kl.Vjb=function(n,t,e){return n[t]=e},kl.Xjb=function(n,t){n.fe=t},kl.Yjb=function(n,t){n.__elementTypeCategory$=t},kl.Zjb=function(n,t){n.__elementTypeId$=t},kl._jb=function(n,t){return 10!=kl.Ojb(t)&&Vf(Jl.Ic(t),t.ge,kl.Pjb(t),kl.Ojb(t),n),kl.Ljb(n)},kl.dlb=function(n){return typeof n===h||typeof n===p},kl.elb=function(n,t){return n&&t&&n instanceof t},kl.Fwb=function(n){return n&&n.__java$exception},Jl.iFb=function(){Jl.iFb=Sf,c=Rl.LTb(!1),Rl.LTb(!0)},Jl.jFb=function(n){return Rl.MTb((Rl.ATb(n),n))},Jl.kFb=function(n,t){return function(n,t){return Jl.iFb(),n==t?0:n?1:-1}(Rl.MTb((Rl.ATb(n),n)),Rl.MTb((Rl.ATb(t),t)))},Jl.lFb=function(n,t){return Jl.kFb(n,t)},Jl.mFb=function(n,t){return Rl.ATb(n),n===t},Jl.nFb=function(){return kl.rub},Jl.oFb=function(n){return Rl.MTb((Rl.ATb(n),n))?1231:1237},Jl.rFb=function(n,t){return Jl.iFb(),ig(n)?Jl.xHb(n,t):ng(n)?Jl.rGb(n,t):$f(n)?Jl.lFb(n,t):n.Eb(t)},g={4:1,380:1,18:1},Jl.NFb=function(n){n.i=dg++},Jl.OFb=function(n){null==n.n&&Jl.cGb(n)},Jl.PFb=function(n){return Jl.OFb(n),n.n},Jl.QFb=function(n){return 0!=(4&n.f)},Jl.RFb=function(n){return 0!=(1&n.f)},Jl.SFb=function(){Jl.NFb(this),this.n=null,this.j=null,this.g=null,this.d=null,this.b=null,this.k=null,this.a=null},Jl.UFb=function(n){var t;return(t=new Jl.SFb).n="Class$"+(n?"S"+n:""+t.i),t.b=t.n,t.j=t.n,t},Jl.$Fb=function(n,t){var e=n.a=n.a||[];return e[t]||(e[t]=n.Kd(t))},Jl.cGb=function(n){if(n.Od()){var t=n.c;return t.Pd()?n.n="["+t.k:t.Od()?n.n="["+t.Md():n.n="[L"+t.Md()+";",n.b=t.Ld()+"[]",void(n.j=t.Nd()+"[]")}var e=n.g,i=n.d;i=i.split("/"),n.n=Jl.fGb(".",[e,Jl.fGb("$",i)]),n.b=Jl.fGb(".",[e,Jl.fGb(".",i)]),n.j=i[i.length-1]},Jl.fGb=function(n,t){for(var e=0;!t[e]||""==t[e];)e++;for(var i=t[e++];e<t.length;e++)t[e]&&""!=t[e]&&(i+=n+t[e]);return i},Jl.gGb=function(n,t){if(n){t.k=n;var e=function(n){if(n.Pd())return null;var t=n.k;return l[t]}(t);e?e.fe=t:l[n]=[t]}},zf(239,1,{},Jl.SFb),o.Kd=function(n){var t;return(t=new Jl.SFb).f=4,t.c=n>1?Jl.$Fb(this,n-1):this,t},o.Ld=function(){return Jl.OFb(this),this.b},o.Md=function(){return Jl.PFb(this)},o.Nd=function(){return Jl.OFb(this),this.j},o.Od=function(){return Jl.QFb(this)},o.Pd=function(){return Jl.RFb(this)},o.lb=function(){return(0!=(2&this.f)?"interface ":0!=(1&this.f)?"":"class ")+(Jl.OFb(this),this.n)},o.f=0,o.i=0;var ug,dg=1;function cg(n,t){return n<t?-1:n>t?1:n==t?0==n?cg(1/n,1/t):0:isNaN(n)?isNaN(t)?0:1:-1}function hg(n){return isNaN(n)?{l:0,m:0,h:524160}:Rl.HTb(n)}function bg(n){var t,e;return n>=J?(t=55296+(n-J>>10&1023)&y,e=56320+(n-J&1023)&y,String.fromCharCode(t)+""+String.fromCharCode(e)):String.fromCharCode(n&y)}function Dg(n,t){this.b=n,this.c=t}Jl.lGb=function(t){return Jl.DHb(C,typeof t)||eg(t,n.java.lang.Number$impl)},Jl.mGb=function(n){if(null==Jl.kGb&&(Jl.kGb=new RegExp("^\\s*[+-]?(NaN|Infinity|((\\d+\\.?\\d*)|(\\.\\d+))([eE][+-]?\\d+)?[dDfF]?)\\s*$")),!Jl.kGb.test(n))throw og(new Jl.rHb(P+n+'"'));return parseFloat(n)},Jl.nGb=function(n,t,e){var i,s,a,r;if(null==n)throw og(new Jl.rHb(M));for(i=(a=Rl.LTb(n).length)>0&&(Rl.GTb(0,Rl.LTb(n).length),45==Rl.LTb(n).charCodeAt(0)||(Rl.GTb(0,Rl.LTb(n).length),43==Rl.LTb(n).charCodeAt(0)))?1:0;i<a;i++)if(-1==Zg((Rl.GTb(i,Rl.LTb(n).length),Rl.LTb(n).charCodeAt(i))))throw og(new Jl.rHb(P+n+'"'));if(s=(r=parseInt(n,10))<t,isNaN(r))throw og(new Jl.rHb(P+n+'"'));if(s||r>e)throw og(new Jl.rHb(P+n+'"'));return r},Jl.oGb=function(n){return ng(n)?Jl.sGb(n):n.Qd()},Jl.pGb=function(n){return ng(n)?Jl.wGb(n):n.Rd()},zf(142,1,{4:1,142:1}),Jl.qGb=function(n,t){return cg(Rl.NTb((Rl.ATb(n),n)),Rl.NTb((Rl.ATb(t),t)))},Jl.rGb=function(n,t){return Jl.qGb(n,t)},Jl.sGb=function(n){return Rl.NTb((Rl.ATb(n),n))},Jl.tGb=function(n,t){return Rl.ATb(n),sg(n)===sg(t)},Jl.uGb=function(){return kl.vub},Jl.vGb=function(n){return ag(Rl.NTb((Rl.ATb(n),n)))},Jl.wGb=function(n){return ag(Rl.NTb((Rl.ATb(n),n)))},u={4:1,18:1,386:1,142:1},Jl.Cz=function(n){n.i=vf(kl.Kub,j,96,0,0,1)},Jl.Dz=function(n,t){Rl.BTb(t,"Cannot suppress a null exception."),Rl.uTb(t!=n,"Exception can not suppress itself."),n.g||(null==n.j?n.j=Vf(qf(kl.Pub,1),j,28,0,[t]):n.j[n.j.length]=t)},Jl.Ez=function(n){Bl.S9(n)},Jl.Fz=function(n){return Bl.T9(n)},Jl.Gz=function(n){return n.k&&(n.backingJsObject!==w&&n.Xb(),n.i=null),n},Jl.Hz=function(n){return n.e},Jl.Iz=function(n,e){if(e instanceof Object)try{if(e.__java$exception=n,-1!=i.userAgent.toLowerCase().indexOf("msie")&&t.documentMode<9)return;var s=n;Object.defineProperties(e,{cause:{get:function(){var n=s.Vb();return n&&n.Tb()}},suppressed:{get:function(){return s.Ub()}}})}catch(n){}},Jl.Jz=function(n,t,e){var i,s,a,r,o;for(Jl.Kz(n),null==n.j&&(n.j=vf(kl.Pub,j,28,0,0,1)),a=0,r=(s=n.j).length;a<r;++a)i=s[a],Jl.Jz(i,t,"\t"+e);(o=n.e)&&Jl.Jz(o,t,e)},Jl.Kz=function(n){var t,e;for(null==n.i&&(n.i=Jl.Fz(n)),t=0,e=n.i.length;t<e;++t);},Jl.Lz=function(n,t){n.backingJsObject=t,Jl.Iz(n,t)},Jl.Mz=function(n){return Jl.Nz(n,n.Wb())},Jl.Nz=function(n,t){var e;return e=Jl.PFb(n.fe),null==t?e:e+": "+t},Jl.Oz=function(){Jl.Cz(this),Jl.Gz(this),this.Xb()},Jl.Pz=function(n){Jl.Cz(this),this.f=n,Jl.Gz(this),this.Xb()},Jl.Qz=function(n,t){Jl.Cz(this),this.e=t,this.f=n,Jl.Gz(this),this.Xb()},Jl.Sz=function(n){if(!("stack"in n))try{throw n}catch(n){}return n},zf(28,1,{4:1,28:1}),o.Sb=function(n){return new Error(n)},o.Tb=function(){return this.backingJsObject},o.Ub=function(){var n,t,e;for(null==this.j&&(this.j=vf(kl.Pub,j,28,0,0,1)),e=this.j,t=vf(kl.Iub,N,1,e.length,5,1),n=0;n<e.length;n++)t[n]=e[n].backingJsObject;return t},o.Vb=function(){return Jl.Hz(this)},o.Wb=function(){return this.f},o.Xb=function(){Jl.Lz(this,Jl.Sz(this.Sb(Jl.Nz(this,this.f)))),Jl.Ez(this)},o.lb=function(){return Jl.Mz(this)},o.backingJsObject=w,o.g=!1,o.k=!0,Jl.$z=function(){Jl.Oz.call(this)},Jl._z=function(n){Jl.Cz(this),Jl.Gz(this),this.backingJsObject=n,Jl.Iz(this,n),this.f=null==n?M:xf(n)},Jl.aA=function(n){Jl.Pz.call(this,n)},Jl.bA=function(n,t){Jl.Qz.call(this,n,t)},zf(19,28,L,Jl.aA),Jl.cA=function(){Jl.$z.call(this)},Jl.dA=function(n){Jl._z.call(this,n)},Jl.eA=function(n){Jl.aA.call(this,n)},Jl.fA=function(n,t){Jl.bA.call(this,n,t)},zf(55,19,L,Jl.eA),Jl.dFb=function(){Jl.cA.call(this)},Jl.eFb=function(n){Jl.eA.call(this,n)},zf(56,55,L,Jl.dFb,Jl.eFb),Jl.M8=function(){Jl.cA.call(this)},Jl.N8=function(n){Jl.dA.call(this,n)},Jl.O8=function(n){Jl.eA.call(this,n)},zf(150,55,L,Jl.N8),Jl.nHb=function(){Jl.M8.call(this)},Jl.oHb=function(n){Jl.N8.call(this,n)},Jl.pHb=function(n){Jl.O8.call(this,n)},zf(74,150,L,Jl.nHb,Jl.oHb,Jl.pHb),o.Sb=function(n){return new TypeError(n)},Jl.wHb=function(n,t){return Rl.GTb(t,Rl.LTb(n).length),Rl.LTb(n).charCodeAt(t)},Jl.xHb=function(n,t){return Jl.yHb(n,t)},Jl.yHb=function(n,t){var e,i;return(e=Jl.sGb(Rl.LTb(n)))==(i=Jl.sGb(Rl.LTb(t)))?0:e<i?-1:1},Jl.zHb=function(n,t){return Jl.yHb(Rl.LTb(n).toLowerCase(),Rl.LTb(t).toLowerCase())},Jl.AHb=function(n,t){return Rl.ATb(n),n+""+(Rl.ATb(t),t)},Jl.BHb=function(n){var t;return Jl.WHb(Rl.kTb(n,0,(t=n.length,Rl.hTb(),t)))},Jl.CHb=function(n){var t;return t=Rl.LTb(U).length,Jl.DHb(Rl.LTb(n).substr(Rl.LTb(n).length-t,t),U)},Jl.DHb=function(n,t){return Rl.ATb(n),sg(n)===sg(t)},Jl.EHb=function(n,t){return Rl.ATb(n),null!=t&&(!!Jl.DHb(n,t)||Rl.LTb(n).length==Rl.LTb(t).length&&Jl.DHb(Rl.LTb(n).toLowerCase(),Rl.LTb(t).toLowerCase()))},Jl.FHb=function(){return kl.Oub},Jl.GHb=function(n){var t,e;for(t=0,e=0;e<Rl.LTb(n).length;e++)t=(t<<5)-t+(Rl.GTb(e,Rl.LTb(n).length),Rl.LTb(n).charCodeAt(e))|0;return t},Jl.HHb=function(n,t){return Rl.LTb(n).indexOf(t)},Jl.IHb=function(n,t,e){return Rl.LTb(n).indexOf(t,e)},Jl.KHb=function(n,t){return Rl.LTb(n).lastIndexOf(t)},Jl.LHb=function(n,t,e){return Rl.LTb(n).lastIndexOf(t,e)},Jl.MHb=function(n,t){var e;return e=Jl.NHb(t,"([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])","\\\\$1"),Jl.NHb(n,e,"")},Jl.NHb=function(n,t,e){return e=Jl.VHb(e),Rl.LTb(n).replace(new RegExp(t,"g"),e)},Jl.OHb=function(n,t){var e,i,s,a,r,o,l,f;for(e=new RegExp(t,"g"),l=vf(kl.Oub,k,2,0,6,1),i=0,f=n,a=null;;){if(null==(o=e.exec(f))||""==f){l[i]=f;break}r=o.index,l[i]=(Rl.FTb(0,r,Rl.LTb(f).length),Rl.LTb(f).substr(0,r)),f=Jl.RHb(f,r+Rl.LTb(Rl.LTb(o)[0]).length,Rl.LTb(f).length),e.lastIndex=0,a==f&&(l[i]=(Rl.FTb(0,1,Rl.LTb(f).length),Rl.LTb(f).substr(0,1)),Rl.GTb(1,Rl.LTb(f).length+1),f=Rl.LTb(f).substr(1)),a=f,++i}if(Rl.LTb(n).length>0){for(s=l.length;s>0&&""==l[s-1];)--s;s<l.length&&(Rl.LTb(l).length=s)}return l},Jl.PHb=function(n,t){return Jl.DHb(Rl.LTb(n).substr(0,Rl.LTb(t).length),t)},Jl.QHb=function(n,t){return Rl.GTb(t,Rl.LTb(n).length+1),Rl.LTb(n).substr(t)},Jl.RHb=function(n,t,e){return Rl.FTb(t,e,Rl.LTb(n).length),Rl.LTb(n).substr(t,e-t)},Jl.SHb=function(n){var t,e,i;for(e=Rl.LTb(n).length,i=0;i<e&&(Rl.GTb(i,Rl.LTb(n).length),Rl.LTb(n).charCodeAt(i)<=32);)++i;for(t=e;t>i&&(Rl.GTb(t-1,Rl.LTb(n).length),Rl.LTb(n).charCodeAt(t-1)<=32);)--t;return i>0||t<e?(Rl.FTb(i,t,Rl.LTb(n).length),Rl.LTb(n).substr(i,t-i)):n},Jl.THb=function(n){return String.fromCharCode.apply(null,n)},Jl.VHb=function(n){var t;for(t=0;0<=(t=Rl.LTb(n).indexOf("\\",t));)Rl.GTb(t+1,Rl.LTb(n).length),36==Rl.LTb(n).charCodeAt(t+1)?(Rl.FTb(0,t,Rl.LTb(n).length),n=Rl.LTb(n).substr(0,t)+"$"+Jl.QHb(n,++t)):(Rl.FTb(0,t,Rl.LTb(n).length),n=Rl.LTb(n).substr(0,t)+""+Jl.QHb(n,++t));return n},Jl.WHb=function(n){return Jl.XHb(n,0,n.length)},Jl.XHb=function(t,e,i){var s,a,r,o;for(r=e+i,Rl.FTb(e,r,t.length),o="",a=e;a<r;)s=n.Math.min(a+B,r),o+=Jl.THb(Rl.LTb(t).slice(a,s)),a=s;return o},d={4:1,241:1,18:1,2:1},Jl.mIb=function(n){Jl.eFb.call(this,n)},zf(263,56,L,Jl.mIb),Rl.YSb=function(n){var t;return t=Rl.LTb(n).slice(),Rl.gTb(t,n)},Rl.ZSb=function(t,e,i,s,a,r){var o,l,f,g,u;if(0!=a)for(sg(t)===sg(i)&&(t=Rl.LTb(t).slice(e,e+a),e=0),f=Rl.LTb(i),l=e,g=e+a;l<g;)a=(o=n.Math.min(l+B,g))-l,u=Rl.LTb(t).slice(l,o),Rl.LTb(u).splice(0,0,Rl.LTb(s),Rl.LTb(r?a:0)),Array.prototype.splice.apply(f,u),l=o,s+=a},Rl.$Sb=function(n,t){return Rl.gTb(new Array(t),n)},Rl._Sb=function(n,t,e){Rl.LTb(n).splice(t,0,e)},Rl.aTb=function(n,t,e){Rl.ZSb(e,0,n,t,e.length,!1)},Rl.bTb=function(n,t){Rl.LTb(n).push(t)},Rl.cTb=function(n,t){Rl.LTb(n).push(t)},Rl.dTb=function(n,t,e){Rl.LTb(n).splice(t,e)},Rl.eTb=function(n,t){Rl.LTb(n).length=t},Rl.fTb=function(n,t){Rl.LTb(n).sort(t)},zf(741,1,{}),Rl.pTb=function(){},Rl.qTb=function(n){switch(typeof n){case T:return Jl.GHb(Rl.LTb(n));case C:return Jl.vGb(Rl.LTb(n));case A:return Jl.oFb(Rl.LTb(n));default:return null==n?0:Rl.sTb(n)}},Rl.rTb=function(){return++Rl.oTb},Rl.sTb=function(n){return n.$H||(n.$H=Rl.rTb())},zf(651,1,{},Rl.pTb),Rl.oTb=0,Rl.tTb=function(n){if(!n)throw og(new Jl.BGb)},Rl.uTb=function(n,t){if(!n)throw og(new Jl.CGb(t))},Rl.vTb=function(n,t){if(0>n)throw og(new Jl.CGb("fromIndex: 0 > toIndex: "+n));if(n>t)throw og(new Jl.gFb("fromIndex: 0, toIndex: "+n+R+t))},Rl.wTb=function(n){if(n<0)throw og(new Jl.mHb("Negative array size: "+n))},Rl.xTb=function(n,t){if(n!=t)throw og(new Fl.BPb)},Rl.yTb=function(n){if(!n)throw og(new Fl.JQb)},Rl.zTb=function(n,t){if(n<0||n>=t)throw og(new Jl.eFb(E+n+x+t))},Rl.ATb=function(n){if(null==n)throw og(new Jl.nHb);return n},Rl.BTb=function(n,t){if(null==n)throw og(new Jl.pHb(t))},Rl.CTb=function(n,t){if(n<0||n>t)throw og(new Jl.eFb(E+n+x+t))},Rl.DTb=function(n,t,e){if(n<0||t>e)throw og(new Jl.eFb(F+n+Q+t+", size: "+e));if(n>t)throw og(new Jl.CGb(F+n+" > toIndex: "+t))},Rl.ETb=function(n){if(!n)throw og(new Jl.DGb)},Rl.FTb=function(n,t,e){if(n<0||t>e||t<n)throw og(new Jl.mIb(F+n+Q+t+R+e))},Rl.GTb=function(n,t){if(n<0||n>=t)throw og(new Jl.mIb(E+n+x+t))},Rl.HTb=function(n){var t,e;return t=new ArrayBuffer(8),Rl.LTb(new Float64Array(t))[0]=n,e=Rl.LTb(new Uint32Array(t)),Rl.OTb(0|e[0],0|e[1])},Rl.ITb=function(n,t){return n[t]},Rl.JTb=function(n){return void 0===n},Rl.KTb=function(n){return n>>>0},Rl.LTb=function(n){return n},Rl.MTb=function(n){return n},Rl.NTb=function(n){return n},zf(652,1,{}),kl.Iub=lg(1),kl.xqb=lg(0),kl.Gqb=lg(653),kl.Dqb=lg(388),kl.Fqb=lg(654),kl.Eqb=lg(389),kl.rub=lg(380),kl.uub=lg(239),kl.Hub=lg(142),kl.vub=lg(386),kl.Pub=lg(28),kl.xub=lg(19),kl.Jub=lg(55),kl.Aub=lg(56),kl.Cub=lg(150),kl.Fub=lg(74),kl.Oub=lg(2),kl.Nub=lg(263),kl.Yvb=lg(651),kl.Zvb=lg(652),El.Nc=function(t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,m,A,C,T,p,I,P,M,w,N,L,U,k,J,y,B,R,E,x,F,Q;for(this.c=t.length,this.d=t[0].length,L=n.Math.min(this.c,this.d),this.e=vf(kl.jlb,S,6,n.Math.min(this.c+1,this.d),15,1),this.a=Yf(kl.jlb,[j,S],[13,6],15,[this.c,L],2),this.b=Yf(kl.jlb,[j,S],[13,6],15,[this.d,this.d],2),a=vf(kl.jlb,S,6,this.d,15,1),Q=vf(kl.jlb,S,6,this.c,15,1),w=n.Math.min(this.c-1,this.d),N=n.Math.max(0,n.Math.min(this.d-2,this.c)),T=0;T<n.Math.max(w,N);T++){if(T<w){for(this.e[T]=0,d=T;d<this.c;d++)this.e[T]=El.Oc(this.e[T],t[d][T]);if(0!=this.e[T]){for(t[T][T]<0&&(this.e[T]=-this.e[T]),u=T;u<this.c;u++)t[u][T]/=this.e[T];t[T][T]+=1}this.e[T]=-this.e[T]}for(D=T+1;D<this.d;D++){if(T<w&0!=this.e[T]){for(F=0,d=T;d<this.c;d++)F+=t[d][T]*t[d][D];for(F=-F/t[T][T],u=T;u<this.c;u++)t[u][D]+=F*t[u][T]}a[D]=t[T][D]}if(!0&T<w)for(u=T;u<this.c;u++)this.a[u][T]=t[u][T];if(T<N){for(a[T]=0,d=T+1;d<this.d;d++)a[T]=El.Oc(a[T],a[d]);if(0!=a[T]){for(a[T+1]<0&&(a[T]=-a[T]),c=T+1;c<this.d;c++)a[c]/=a[T];a[T+1]+=1}if(a[T]=-a[T],T+1<this.c&0!=a[T]){for(c=T+1;c<this.c;c++)Q[c]=0;for(H=T+1;H<this.d;H++)for(h=T+1;h<this.c;h++)Q[h]+=a[H]*t[h][H];for(m=T+1;m<this.d;m++)for(F=-a[m]/a[T+1],h=T+1;h<this.c;h++)t[h][m]+=F*Q[h]}for(u=T+1;u<this.d;u++)this.b[u][T]=a[u]}}for(U=n.Math.min(this.d,this.c+1),w<this.d&&(this.e[w]=t[w][w]),this.c<U&&(this.e[U-1]=0),N+1<U&&(a[N]=t[N][U-1]),a[U-1]=0,A=w;A<L;A++){for(u=0;u<this.c;u++)this.a[u][A]=0;this.a[A][A]=1}for(p=w-1;p>=0;p--)if(0!=this.e[p]){for(b=p+1;b<L;b++){for(F=0,d=p;d<this.c;d++)F+=this.a[d][p]*this.a[d][b];for(F=-F/this.a[p][p],c=p;c<this.c;c++)this.a[c][b]+=F*this.a[c][p]}for(h=p;h<this.c;h++)this.a[h][p]=-this.a[h][p];for(this.a[p][p]=1+this.a[p][p],u=0;u<p-1;u++)this.a[u][p]=0}else{for(u=0;u<this.c;u++)this.a[u][p]=0;this.a[p][p]=1}for(I=this.d-1;I>=0;I--){if(I<N&0!=a[I])for(b=I+1;b<L;b++){for(F=0,d=I+1;d<this.d;d++)F+=this.b[d][I]*this.b[d][b];for(F=-F/this.b[I+1][I],c=I+1;c<this.d;c++)this.b[c][b]+=F*this.b[c][I]}for(u=0;u<this.d;u++)this.b[u][I]=0;this.b[I][I]=1}for(k=U-1,l=n.Math.pow(2,-52);U>0;){for(C=U-2;C>=-1&&-1!=C;C--)if(n.Math.abs(a[C])<=l*(n.Math.abs(this.e[C])+n.Math.abs(this.e[C+1]))){a[C]=0;break}if(C==U-2)P=4;else{for(M=U-1;M>=C&&M!=C;M--)if(F=(M!=U?n.Math.abs(a[M]):0)+(M!=C+1?n.Math.abs(a[M-1]):0),n.Math.abs(this.e[M])<=l*F){this.e[M]=0;break}M==C?P=3:M==U-1?P=1:(P=2,C=M)}switch(++C,P){case 1:for(f=a[U-2],a[U-2]=0,b=U-2;b>=C;b--)for(F=El.Oc(this.e[b],f),s=this.e[b]/F,R=f/F,this.e[b]=F,b!=C&&(f=-R*a[b-1],a[b-1]=s*a[b-1]),u=0;u<this.d;u++)F=s*this.b[u][b]+R*this.b[u][U-1],this.b[u][U-1]=-R*this.b[u][b]+s*this.b[u][U-1],this.b[u][b]=F;break;case 2:for(f=a[C-1],a[C-1]=0,b=C;b<U;b++)for(F=El.Oc(this.e[b],f),s=this.e[b]/F,R=f/F,this.e[b]=F,f=-R*a[b],a[b]=s*a[b],u=0;u<this.c;u++)F=s*this.a[u][b]+R*this.a[u][C-1],this.a[u][C-1]=-R*this.a[u][b]+s*this.a[u][C-1],this.a[u][b]=F;break;case 3:for(J=n.Math.max(n.Math.max(n.Math.max(n.Math.max(n.Math.abs(this.e[U-1]),n.Math.abs(this.e[U-2])),n.Math.abs(a[U-2])),n.Math.abs(this.e[C])),n.Math.abs(a[C])),E=this.e[U-1]/J,x=this.e[U-2]/J,o=a[U-2]/J,B=this.e[C]/J,r=a[C]/J,y=0,0!=(e=((x+E)*(x-E)+o*o)/2)|0!=(i=E*o*(E*o))&&(y=n.Math.sqrt(e*e+i),e<0&&(y=-y),y=i/(e+y)),f=(B+E)*(B-E)+y,g=B*r,b=C;b<U-1;b++){for(s=f/(F=El.Oc(f,g)),R=g/F,b!=C&&(a[b-1]=F),f=s*this.e[b]+R*a[b],a[b]=s*a[b]-R*this.e[b],g=R*this.e[b+1],this.e[b+1]=s*this.e[b+1],d=0;d<this.d;d++)F=s*this.b[d][b]+R*this.b[d][b+1],this.b[d][b+1]=-R*this.b[d][b]+s*this.b[d][b+1],this.b[d][b]=F;if(s=f/(F=El.Oc(f,g)),R=g/F,this.e[b]=F,f=s*a[b]+R*this.e[b+1],this.e[b+1]=-R*a[b]+s*this.e[b+1],g=R*a[b+1],a[b+1]=s*a[b+1],b<this.c-1)for(u=0;u<this.c;u++)F=s*this.a[u][b]+R*this.a[u][b+1],this.a[u][b+1]=-R*this.a[u][b]+s*this.a[u][b+1],this.a[u][b]=F}a[U-2]=f;break;case 4:if(this.e[C]<=0)for(this.e[C]=this.e[C]<0?-this.e[C]:0,u=0;u<=k;u++)this.b[u][C]=-this.b[u][C];for(;C<k&&!(this.e[C]>=this.e[C+1]);){if(F=this.e[C],this.e[C]=this.e[C+1],this.e[C+1]=F,C<this.d-1)for(u=0;u<this.d;u++)F=this.b[u][C+1],this.b[u][C+1]=this.b[u][C],this.b[u][C]=F;if(C<this.c-1)for(u=0;u<this.c;u++)F=this.a[u][C+1],this.a[u][C+1]=this.a[u][C],this.a[u][C]=F;++C}--U}}},El.Oc=function(t,e){var i;return n.Math.abs(t)>n.Math.abs(e)?(i=e/t,i=n.Math.abs(t)*n.Math.sqrt(1+i*i)):0!=e?(i=t/e,i=n.Math.abs(e)*n.Math.sqrt(1+i*i)):i=0,i},zf(232,1,X,El.Nc),o.c=0,o.d=0,kl.nlb=lg(232),xl.Qc=function(){xl.Qc=Sf,xl.Pc=Vf(qf(kl.llb,1),z,6,15,[0,G,14286847,13402367,12779264,16758197,9474192,3166456,16715021,9494608,11789301,11230450,9109248,12560038,1578e4,16744448,16777008,2093087,8442339,9388244,4062976,15132390,12567239,10921643,9083335,10255047,14706227,15765664,5296208,13140019,8224944,12750735,6721423,12419299,16752896,10889513,6076625,7351984,q,9764863,9756896,7586505,5551541,3907230,2396047,687500,27013,12632256,16767375,10909043,6717568,10380213,13924864,9699476,4366e3,5707663,51456,7394559,16777159,14286791,13107143,10747847,9437127,6422471,4587463,3211207,2097095,65436,58997,54354,48952,43812,5096191,5089023,2200790,2522539,2516630,1528967,13684960,16765219,12105936,10900557,5724513,10375093,11230208,7688005,4358806,4325478,32e3,7384058,47871,41471,36863,33023,27647,5528818,7888099,9064419,10565332,11739092,11739066,11734438,12389767,13041766,13369433,13697103,14221381,14680120,15073326,15400998,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13158600,1334015,56540,15075850,15132160,56540,15075850,15461355,8553170,1016335,1016335,1334015,15132160,3289770,14456450,16422400,16422400,11819700,3289770,1016335])},xl.Rc=function(n){n.v=new Kl.JG},xl.Sc=function(n){var t,e;0==(32&n.F)&&null!=(e=xl.qu(n.K))&&(0==n.w.a&&0==n.w.b&&(t=n.Q.c*xl.Rk(n.K),n.v=xl.Od(n),xl.cd(n,t),xl.Kd(n,null,t,0)),n.yb(ag(n.A)),1!=n.K.O&&xl.Ld(n,448),n.pb(e,n.w.a,n.w.b+Y*n.A))},xl.Tc=function(n,t){return null==n?t:null==t?n:n+","+t},xl.Uc=function(n,t){xl.Xh(t,n.Q),xl.$h(t,n.v),xl.Zh(t,n.w)},xl.Vc=function(n){var t;t=n.Q.c*xl.Rk(n.K),n.X=.06*t,n.S=.15*t,n.R=.38*t,n.V=.47*t,n.W=ag(t*n.I*.6+.5),n.U=.12*t,n.Y=.4*t,n.A=.5*t+.5},xl.Wc=function(n){var t,e;for(n=Cg(n,v),e=0;e<(Vl.yG(),Vl.xG).length;e++)if(Ig(n,Vl.xG[e]))return Vl.wG[e];return t=new Jl.lIb("R"),Bg(Cg(n,Z),0)&&(t.a+="0"),Bg(Cg(n,O),0)&&(t.a+="3"),Bg(Cg(n,V),0)&&(t.a+="4"),Bg(Cg(n,K),0)&&(t.a+="5"),Bg(Cg(n,W),0)&&(t.a+="6"),Bg(Cg(n,_),0)&&(t.a+="7"),Bg(Cg(n,$),0)&&(t.a+="8"),t.a},xl.Xc=function(n,t,e,i){var s,a;s=new xl.Zd,a=new xl.Zd,s.a=t.a,s.c=t.c,s.b=(t.a+t.b)/2,s.d=(t.c+t.d)/2,a.a=s.b,a.c=s.d,a.b=t.b,a.d=t.d,xl.Hd(n,s)&&(xl.Ld(n,n.p[e]),n.mb(s)),xl.Hd(n,a)&&(xl.Ld(n,n.p[i]),n.mb(a)),xl.Ld(n,n.P)},xl.Yc=function(n,t,e,i){var s,a,r,o,l;o=(t.b-t.a)/10,l=(t.d-t.c)/10,s=new xl.Zd,xl.yl(n.K,xl.Pn(n.K,e,i))?(a=-3,r=-3):(a=n.p[e],r=n.p[i]),xl.Ld(n,a),s.a=t.a,s.c=t.c,s.b=t.a+2*o,s.d=t.c+2*l,n.mb(s),s.a=t.a+4*o,s.c=t.c+4*l,s.b=t.a+5*o,s.d=t.c+5*l,n.mb(s),xl.Ld(n,r),s.a=t.a+5*o,s.c=t.c+5*l,s.b=t.a+6*o,s.d=t.c+6*l,n.mb(s),s.a=t.a+8*o,s.c=t.c+8*l,s.b=t.b,s.d=t.d,n.mb(s),xl.Ld(n,n.P)},xl.Zc=function(n,t,e){n.qb(t-n.U/2,e-n.U/2,n.U)},xl.$c=function(n,t,e,i){xl.yl(n.K,xl.Pn(n.K,e,i))?(xl.Ld(n,-3),n.mb(t),xl.Ld(n,n.P)):n.p[e]!=n.p[i]?xl.Xc(n,t,e,i):0!=n.p[e]?(xl.Ld(n,n.p[e]),n.mb(t),xl.Ld(n,n.P)):n.mb(t)},xl._c=function(n,t,e,i,s,a,r){r.a=t.a+s,r.c=t.c+a,r.b=t.b+s,r.d=t.d+a,xl.$c(n,r,e,i)},xl.ad=function(t,e,i,s){var a,r,o,l,f,g,u,d,c,h,b,D;for(d=e.b-e.a,b=e.d-e.c,f=n.Math.sqrt(d*d+b*b),c=d/((g=2*zg(Pg(n.Math.round(f/(4*t.X)))))-1),D=b/(g-1),xl.yl(t.K,xl.Pn(t.K,i,s))?(a=-3,r=-3):(a=t.p[i],r=t.p[s]),u=e.a-t.X/2,h=e.c-t.X/2,xl.Ld(t,a),l=0;l<(g/2|0);l++)t.qb(u,h,t.X),u+=c,h+=D;for(xl.Ld(t,r),o=0;o<(g/2|0);o++)t.qb(u,h,t.X),u+=c,h+=D;xl.Ld(t,t.P)},xl.bd=function(n,t,e,i){var s,a,r,o,l,f,g,u,d,c,h,b,D,H;l=(t.c-t.d)/9,c=(t.b-t.a)/9,f=t.b+l,h=t.d+c,g=t.b-l,b=t.d-c,u=(t.a+f)/2,D=(t.c+h)/2,d=(t.a+g)/2,H=(t.c+b)/2,r=new Kl.EG(3),o=new Kl.EG(4),Kl.DG(r,t.a,t.c),Kl.DG(r,u,D),Kl.DG(r,d,H),Kl.DG(o,d,H),Kl.DG(o,u,D),Kl.DG(o,f,h),Kl.DG(o,g,b),xl.yl(n.K,xl.Pn(n.K,e,i))?(s=-3,a=-3):(s=n.p[e],a=n.p[i],1!=n.K.O&&(a=xl.fd(n,e),s==xl.Ak(n.K,e)&&(s=a))),xl.Ld(n,s),n.ob(r),xl.Ld(n,a),n.ob(o),xl.Ld(n,n.P)},xl.cd=function(n,t){var e,i;for(i=0;i<n.Z.a.length;i++)n.v=Kl.IG(n.v,Fl.Xi(n.Z,i));xl.dd(n,t),e=.1*t,n.v.c-=e,n.v.d-=e,n.v.b+=2*e,n.v.a+=2*e},xl.dd=function(n,t){var e,i,s,a,r,o,l;for(s=vf(kl.Cwb,nn,6,n.K.q,16,1),i=0;i<n.K.r;i++)xl.wl(n.K,i)&&(s[xl.Vk(n.K,0,i)]=!0,s[xl.Vk(n.K,1,i)]=!0);for(r=new Kl.JG,e=0;e<n.K.q;e++)0!=(a=Bg(Cg(xl.Lk(n.K,e),tn),0)?.47*t:s[e]?.38*t:0)&&(o=xl.bi(n.Q,xl.Nk(n.K,e)),l=xl.ci(n.Q,xl.Ok(n.K,e)),Kl.HG(r,o-a,l-a,2*a,2*a),n.v=Kl.IG(n.v,r))},xl.ed=function(n,t){var e;return e=0!=n.L?n.L:0!=n.C?n.C:-1,gf.o6(t,e)},xl.fd=function(n,t){var e,i;if(0!=(4224&n.F))return n.p[t];if(-1==(i=xl.gd(n,t))&&-1!=(e=xl.xn(n.K,t))&&(t=e,i=xl.gd(n,t)),-1==i)return n.p[t];switch(255&i){case 1:return 384;case 2:return 64;default:return 448}},xl.gd=function(n,t){var e,i,s;return s=-1,i=-1,0!=(128&n.F)||(xl.ul(n.K,t)&&(s=xl.Ek(n.K,t),i=xl.Dk(n.K,t)),-1!=(e=xl.zn(n.K,t))&&(s=xl.$k(n.K,e),i=xl.Zk(n.K,e)),-1!=s&&0!=s&&(s|=i<<8)),s},xl.hd=function(n){var t,e,i,s;for(n.wb(2*n.R),s=new xl.Zd,i=0;i<n.K.r;i++)t=xl.Vk(n.K,0,i),e=xl.Vk(n.K,1,i),xl.wl(n.K,i)&&(s.a=xl.bi(n.Q,xl.Nk(n.K,t)),s.c=xl.ci(n.Q,xl.Ok(n.K,t)),s.b=xl.bi(n.Q,xl.Nk(n.K,e)),s.d=xl.ci(n.Q,xl.Ok(n.K,e)),xl.Ld(n,-2),n.mb(s))},xl.jd=function(n){var t,e,i,s,a,r;if(n.K.K){for(r=n.V,xl.Ld(n,-7),t=0;t<n.K.f;t++)Bg(Cg(xl.Lk(n.K,t),tn),0)&&n.qb(xl.bi(n.Q,xl.Nk(n.K,t))-r,xl.ci(n.Q,xl.Ok(n.K,t))-r,2*r);for(n.wb(2*n.V),a=new xl.Zd,s=0;s<n.K.r;s++)e=xl.Vk(n.K,0,s),i=xl.Vk(n.K,1,s),Bg(Cg(Cg(xl.Lk(n.K,e),xl.Lk(n.K,i)),tn),0)&&(a.a=xl.bi(n.Q,xl.Nk(n.K,e)),a.c=xl.ci(n.Q,xl.Ok(n.K,e)),a.b=xl.bi(n.Q,xl.Nk(n.K,i)),a.d=xl.ci(n.Q,xl.Ok(n.K,i)),n.mb(a))}},xl.kd=function(n){var t,e,i,s;if(n.K.K){if(xl.Ld(n,320),0!=(8&n.F))for(t=0;t<n.K.f;t++)Bg(Cg(xl.Lk(n.K,t),-536870913),0)&&n.qb(xl.bi(n.Q,xl.Nk(n.K,t))-n.Y/2,xl.ci(n.Q,xl.Ok(n.K,t))-n.Y/2,n.Y);for(s=0;s<n.K.g;s++)0!=xl.dl(n.K,s)&&(e=xl.Vk(n.K,0,s),i=xl.Vk(n.K,1,s),n.qb((xl.bi(n.Q,xl.Nk(n.K,e))+xl.bi(n.Q,xl.Nk(n.K,i))-n.Y)/2,(xl.ci(n.Q,xl.Ok(n.K,e))+xl.ci(n.Q,xl.Ok(n.K,i))-n.Y)/2,n.Y))}},xl.ld=function(n){n.I=1,n.Q=new xl.di,n.Z=new Fl.kj,n.T=new Fl.kj,n.r=vf(kl.Cwb,nn,6,n.K.q,16,1),n.w=new Kl.AG,n.P=0,n.B=-1,xl.Qd(n)},xl.md=function(n,t){var e;if(0==xl.Dn(n.K,t))return!1;for(e=0;e<xl.Dn(n.K,t);e++)if(!xl.yl(n.K,xl.Tn(n.K,t,e)))return!1;return!0},xl.nd=function(n){var t;for(n.q=vf(kl.Cwb,nn,6,n.K.q,16,1),t=0;t<n.K.r;t++)n.q[xl.Vk(n.K,0,t)]=!0,n.q[xl.Vk(n.K,1,t)]=!0},xl.od=function(n,t){var e;if(2!=xl.Sn(n.K,t))return!1;for(e=0;e<2;e++)if(2!=xl.Un(n.K,t,e))return!1;return!0},xl.pd=function(t,e,i,s,a){var r,o,l,f,g,u,d,c,h,b;for(c=!1,a.a=0,a.b=0,r=s>0?en:sn,b=xl.Uk(t.K,e,i),u=0;u<xl.Sn(t.K,e);u++)o=xl.Tn(t.K,e,u),l=b,(d=xl.Vk(t.K,0,o)==e?xl.Vk(t.K,1,o):xl.Vk(t.K,0,o))!=i&&(l<(h=xl.Uk(t.K,e,d))&&(l+=an),f=l-h,s>0?(f<rn&&(c=!0),f>en&&(f=en),f<.523598776&&(f=.523598776),f<=r&&(r=f,g=t.S*n.Math.tan(r-on)/2,a.a=-g*n.Math.sin(l),a.b=-g*n.Math.cos(l))):(f>=rn&&(c=!0),f<sn&&(f=sn),f>5.759586531&&(f=5.759586531),f>=r&&(r=f,g=t.S*n.Math.tan(4.712388981-r)/2,a.a=-g*n.Math.sin(l),a.b=-g*n.Math.cos(l))));return c},xl.qd=function(t,e,i,s){var a;if(0==e)return s.a=i<0?t.S:-t.S,void(s.b=0);a=n.Math.atan(i/e),e<0&&(a+=rn),s.a=-t.S*n.Math.sin(a),s.b=t.S*n.Math.cos(a)},xl.rd=function(n,t,e,i){var s,a,r,o,l,f,g,u,d,c,h,b;s=new xl.Zd,l=new xl.Zd,g=new Kl.AG,f=new Kl.AG,r=xl.Vk(n.K,0,e),o=xl.Vk(n.K,1,e),i&&(d=t.a,t.a=t.b,t.b=d,d=t.c,t.c=t.d,t.d=d,c=r,r=o,o=c),xl.Hd(n,t)&&(xl.Vo(n.K,e)?(s.a=t.a,s.c=t.c,s.b=t.b,s.d=t.d,0==(u=i?-xl.ro(n.K,e):xl.ro(n.K,e))&&(u=1),xl.qd(n,t.b-t.a,t.d-t.c,g),u>0?(l.a=t.a+g.a,l.c=t.c+g.b,l.b=t.b+g.a,l.d=t.d+g.b,(xl.pd(n,r,o,1,f)||xl.Sn(n.K,r)>1)&&(l.a+=f.a+g.b,l.c+=f.b-g.a)):(l.a=t.a-g.a,l.c=t.c-g.b,l.b=t.b-g.a,l.d=t.d-g.b,(xl.pd(n,r,o,-1,f)||xl.Sn(n.K,r)>1)&&(l.a+=f.a+g.b,l.c+=f.b-g.a)),386==xl.el(n.K,e)&&xl.Gd(s,l),xl.Hd(n,s)&&xl.$c(n,s,r,o),64==xl.el(n.K,e)?xl.Hd(n,l)&&xl.Yc(n,l,r,o):xl.Hd(n,l)&&xl.$c(n,l,r,o)):(xl.qd(n,t.b-t.a,t.d-t.c,g),h=g.a/2,b=g.b/2,a=!1,s.a=t.a+h,s.c=t.c+b,s.b=t.b+h,s.d=t.d+b,xl.Sn(n.K,r)>1&&(xl.pd(n,r,o,1,f)?(s.a+=f.a,s.c+=f.b,2==xl.Sn(n.K,r)&&(0==f.a&&0==f.b||(s.a+=g.b,s.c-=g.a))):n.o[r]=new Kl.BG(s.a,s.c)),l.a=t.a-h,l.c=t.c-b,l.b=t.b-h,l.d=t.d-b,xl.Sn(n.K,r)>1&&(xl.pd(n,r,o,0,f)?(l.a+=f.a,l.c+=f.b,2==xl.Sn(n.K,r)&&(0==f.a&&0==f.b||(l.a+=g.b,l.c-=g.a))):(n.o[r]=new Kl.BG(l.a,l.c),a=!0)),386==xl.el(n.K,e)&&xl.Gd(s,l),64==xl.el(n.K,e)?a?(xl.Yc(n,s,r,o),xl.$c(n,l,r,o)):(xl.$c(n,s,r,o),xl.Yc(n,l,r,o)):(xl.$c(n,s,r,o),xl.$c(n,l,r,o))))},xl.sd=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h;for(g=n.P,u=n.D,0!=(n.F&ln)&&(n.P=-6,n.D=-8355712,xl.Ld(n,1)),n.o=vf(kl.Bnb,N,33,n.K.q,0,1),l=0;l<n.K.r;l++)(2==xl.el(n.K,l)||386==xl.el(n.K,l)||64==xl.el(n.K,l))&&xl.vd(n,l);for(f=0;f<n.K.r;f++)2!=xl.el(n.K,f)&&386!=xl.el(n.K,f)&&64!=xl.el(n.K,f)&&xl.vd(n,f);if(0==(64&n.F))for(o=0;o<n.K.r;o++)0!=xl.Yk(n.K,o)&&(s=null,1==xl.Yk(n.K,o)||2==xl.Yk(n.K,o)?(2==xl.bl(n.K,o)||0==xl.$k(n.K,o)||t[xl.$k(n.K,o)][xl.Zk(n.K,o)]>1)&&(s=1==xl.Yk(n.K,o)?2==xl.bl(n.K,o)?"E":xl.Al(n.K,o)?"p":"P":2==xl.bl(n.K,o)?"Z":xl.Al(n.K,o)?"m":"M"):s="?",null!=s&&(n.yb((2*n.W+1)/3|0),xl.Ld(n,xl.yl(n.K,o)?-3:1==n.K.O||0!=(n.F&fn)?n.P:448),e=xl.Vk(n.K,0,o),i=xl.Vk(n.K,1,o),c=(xl.bi(n.Q,xl.Nk(n.K,e))+xl.bi(n.Q,xl.Nk(n.K,i)))/2,h=(xl.ci(n.Q,xl.Ok(n.K,e))+xl.ci(n.Q,xl.Ok(n.K,i)))/2,a=(xl.bi(n.Q,xl.Nk(n.K,e))-xl.bi(n.Q,xl.Nk(n.K,i)))/3,r=(xl.ci(n.Q,xl.Ok(n.K,e))-xl.ci(n.Q,xl.Ok(n.K,i)))/3,xl.yd(n,c+r,h-a,s,!0),xl.Ld(n,n.P),n.yb(n.W)));if(0!=(4&n.F)){for(n.yb((2*n.W+1)/3|0),xl.Ld(n,384),o=0;o<n.K.r;o++)e=xl.Vk(n.K,0,o),i=xl.Vk(n.K,1,o),d=xl.Mo(n.K,o)?"d":xl.Io(n.K,o)?"a":"",c=(xl.bi(n.Q,xl.Nk(n.K,e))+xl.bi(n.Q,xl.Nk(n.K,i)))/2,h=(xl.ci(n.Q,xl.Ok(n.K,e))+xl.ci(n.Q,xl.Ok(n.K,i)))/2,xl.yd(n,c,h,d+""+o,!0);xl.Ld(n,n.P),n.yb(n.W)}0!=(n.F&ln)&&(n.P=g,n.D=u)},xl.td=function(n){var t,e;for(e=new Fl.rOb(n.T);e.a<e.c.a.length;)t=Fl.qOb(e),xl.Ld(n,t.a),xl.Zc(n,t.b,t.c);xl.Ld(n,n.P)},xl.ud=function(t,e,i){var s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I,P,M,w,N,L,U,k,J,y,B,R,E,x,F,Q,X,z,G,q,Y,Z;if(t.J||t.tb(e,xl.Fk(t.K,e),xl.bi(t.Q,xl.Nk(t.K,e)),xl.ci(t.Q,xl.Ok(t.K,e))),R=null,0!=xl.zk(t.K,e)&&(z=1==n.Math.abs(xl.zk(t.K,e))?"":""+n.Math.abs(xl.zk(t.K,e)),R=xl.zk(t.K,e)<0?z+"-":z+"+"),null!=t.s&&e<t.s.length&&null!=t.s[e]&&Rl.LTb(t.s[e]).length>0&&(R=xl.Tc(R,t.s[e])),w=null,0!=Tg(E=xl.Lk(t.K,e),0)&&(Bg(Cg(E,gn),0)&&(w=null==w?"*":w+",*"),Bg(Cg(E,un),0)&&(w=null==w?"!*":w+",!*"),Bg(Cg(E,dn),0)?w=null==w?"ha":w+",ha":Bg(Cg(E,2),0)?w=null==w?"a":w+",a":Bg(Cg(E,4),0)&&(w=null==w?"!a":w+",!a"),Bg(Cg(E,fn),0)&&(w=null==w?"s":w+",s"),Bg(Cg(E,cn),0)&&(0==Tg(p=Cg(E,cn),1792)?w=null==w?"h0":w+",h0":0==Tg(p,1664)?w=null==w?"h1":w+",h1":0==Tg(p,1408)?w=null==w?"h2":w+",h2":0==Tg(p,128)?w=null==w?"h>0":w+",h>0":0==Tg(p,384)?w=null==w?"h>1":w+",h>1":0==Tg(p,896)?w=null==w?"h>2":w+",h>2":0==Tg(p,hn)?w=null==w?"h<3":w+",h<3":0==Tg(p,1536)&&(w=null==w?"h<2":w+",h<2")),Bg(Cg(E,bn),0)&&(0==Tg(f=Cg(E,bn),Dn)?w=null==w?"c0":w+",c0":0==Tg(f,Hn)?w=null==w?"c+":w+",c+":0==Tg(f,jn)&&(w=null==w?"c-":w+",c-")),Bg(Cg(E,mn),0)&&(0==Tg(B=Cg(E,mn),98304)?w=null==w?"pi0":w+",pi0":0==Tg(B,81920)?w=null==w?"pi1":w+",pi1":0==Tg(B,49152)?w=null==w?"pi2":w+",pi2":0==Tg(B,ln)&&(w=null==w?"pi>0":w+",pi>0")),Bg(Cg(E,An),0)&&(0==Tg(y=Cg(E,An),Cn)?w=null==w?"n1":w+",n1":0==Tg(y,Tn)?w=null==w?"n2":w+",n2":0==Tg(y,pn)?w=null==w?"n3":w+",n3":0==Tg(y,In)?w=null==w?"n<3":w+",n<3":0==Tg(y,Pn)?w=null==w?"n<4":w+",n<4":0==Tg(y,Mn)?w=null==w?"n>1":w+",n>1":0==Tg(y,wn)?w=null==w?"n>2":w+",n>2":0==Tg(y,Nn)&&(w=null==w?"n>3":w+",n>3")),Bg(Cg(E,Ln),0)&&(0==Tg(b=Cg(E,Ln),Un)?w=null==w?"e0":w+",e0":0==Tg(b,kn)?w=null==w?"e1":w+",e1":0==Tg(b,Jn)?w=null==w?"e2":w+",e2":0==Tg(b,yn)?w=null==w?"e3":w+",e3":0==Tg(b,0xe0000000000)?w=null==w?"e<2":w+",e<2":0==Tg(b,0xc0000000000)?w=null==w?"e<3":w+",e<3":0==Tg(b,Bn)?w=null==w?"e<4":w+",e<4":0==Tg(b,Rn)?w=null==w?"e>0":w+",e>0":0==Tg(b,En)?w=null==w?"e>1":w+",e>1":0==Tg(b,xn)?w=null==w?"e>2":w+",e>2":0==Tg(b,Fn)?w=null==w?"e>3":w+",e>3":0==Tg(b,4947802324992)?w=null==w?"e1-2":w+",e1-2":0==Tg(b,9345848836096)?w=null==w?"e1-3":w+",e1-3":0==Tg(b,0x98000000000)&&(w=null==w?"e2-3":w+",e2-3")),Bg(Cg(E,120),0)&&(0==Tg(x=Cg(E,120),112)?w=null==w?"!r":w+",!r":0==Tg(x,8)?w=null==w?"r":w+",r":0==Tg(x,96)?w=null==w?"rb<3":w+",rb<3":0==Tg(x,104)?w=null==w?"rb2":w+",rb2":0==Tg(x,88)?w=null==w?"rb3":w+",rb3":0==Tg(x,56)&&(w=null==w?"rb4":w+",rb4")),Bg(Cg(E,Qn),0)&&(w=null==w?"r"+Gg(Fg(Cg(E,Qn),22)):w+",r"+Gg(Fg(Cg(E,Qn),22))),Bg(Cg(E,v),0)&&(w=xl.Tc(w,xl.Wc(E))),Bg(Cg(E,Sn),0)&&(w=null==w?"f":w+",f")),0!=xl.Jk(t.K,e)&&(w=xl.Tc(w,""+xl.Jk(t.K,e))),X=0,0!=xl.Mk(t.K,e))switch(xl.Mk(t.K,e)){case 16:R=null==R?"|":R+",|";break;case 32:X=1;break;case 48:X=2}if(d=null,0==(64&t.F))if(xl.rl(t.K,e))d="?";else if(0!=xl.yk(t.K,e)&&(0==xl.Ek(t.K,e)||null==i||i[xl.Ek(t.K,e)][xl.Dk(t.K,e)]>1))if(2==xl.Sn(t.K,e))switch(xl.yk(t.K,e)){case 2:d=xl.tl(t.K,e)?"p":"P";break;case 1:d=xl.tl(t.K,e)?"m":"M";break;default:d="*"}else switch(xl.yk(t.K,e)){case 1:d=xl.tl(t.K,e)?"r":"R";break;case 2:d=xl.tl(t.K,e)?"s":"S";break;default:d="*"}if(0!=(768&t.F)&&(d=xl.Tc(d,""+xl.yu(t.K,e))),k=null,0!=(16&t.F)&&0!=xl.Ik(t.K,e)&&(k=""+xl.Ik(t.K,e)),H=null,-1!=xl.wo(t.K,e)&&-1!=(D=xl.gd(t,e))&&(H=0==D?"abs":(1==(255&D)?"&":"or")+(1+(D>>8))),I=0,0==(t.F&Xn)&&(t.K.K?Bg(Cg(xl.Lk(t.K,e),zn),0)&&(I=xl.fo(t.K,e)):(6!=xl.Qk(t.K,e)||0!=xl.Jk(t.K,e)||!t.q[e]||0!=xl.Mk(t.K,e))&&(I=xl.fo(t.K,e))),U=!1,null!=(r=xl.Bk(t.K,e))&&Jl.DHb(Rl.LTb(r).substr(0,1),"]")&&(w=xl.Tc((Rl.GTb(1,Rl.LTb(r).length+1),Rl.LTb(r).substr(1)),w),r=null,U=!0),null!=r?I=0:null!=xl.Gk(t.K,e)?(r=(a=Bg(Cg(xl.Lk(t.K,e),1),0)?"[!":"[")+xl.Hk(t.K,e)+"]",Rl.LTb(r).length>5&&(r=a+xl.Gk(t.K,e).length+"]"),Bg(Cg(xl.Lk(t.K,e),zn),0)&&(I=-1)):Bg(Cg(xl.Lk(t.K,e),1),0)?(r="?",Bg(Cg(xl.Lk(t.K,e),zn),0)&&(I=-1)):(6!=xl.Qk(t.K,e)||null!=R||null!=w||I>0||!t.q[e])&&(r=xl.Fk(t.K,e)),L=0,!xl.Jl(t.K,e)&Bg(Cg(xl.Lk(t.K,e),tn),0)&&xl.Ld(t,-8),null!=r?(L=t.rb(r),xl.yd(t,xl.bi(t.Q,xl.Nk(t.K,e)),xl.ci(t.Q,xl.Ok(t.K,e)),r,!0),t.r[e]=!0):xl.od(t,e)&&xl.xd(t,xl.bi(t.Q,xl.Nk(t.K,e)),xl.ci(t.Q,xl.Ok(t.K,e)),e),null!=R&&(t.yb((2*t.W+1)/3|0),G=xl.bi(t.Q,xl.Nk(t.K,e))+((L+t.rb(R))/2+1),Y=xl.ci(t.Q,xl.Ok(t.K,e))-((4*t.sb()-4)/8|0),xl.yd(t,G,Y,R,!0),t.yb(t.W)),0!=(2&t.F)&&(w=""+e),null!=w&&(U?t.yb((5*t.W+1)/6|0):t.yb((2*t.W+1)/3|0),G=xl.bi(t.Q,xl.Nk(t.K,e))-(L+t.rb(w))/2,Y=xl.ci(t.Q,xl.Ok(t.K,e))-((4*t.sb()-4)/8|0),xl.yd(t,G,Y,w,!0),t.yb(t.W)),null!=d&&(t.yb((2*t.W+1)/3|0),G=xl.bi(t.Q,xl.Nk(t.K,e))-(L+t.rb(d))/2,Y=xl.ci(t.Q,xl.Ok(t.K,e))+((4*t.sb()+4)/8|0),Q=t.B,1!=t.K.O&&0==(t.F&fn)&&xl.Ld(t,448),xl.yd(t,G,Y,d,!1),xl.Ld(t,Q),t.yb(t.W)),null!=k&&(t.yb((2*t.W+1)/3|0),G=xl.bi(t.Q,xl.Nk(t.K,e))+((L+t.rb(k))/2+1),Y=xl.ci(t.Q,xl.Ok(t.K,e))+((4*t.sb()+4)/8|0),Q=t.B,xl.Ld(t,xl.vl(t.K,e)?384:448),xl.yd(t,G,Y,k,!0),xl.Ld(t,Q),t.yb(t.W)),null!=H&&(s=xl.Cd(t,e),t.yb((2*t.W+1)/3|0),G=xl.bi(t.Q,xl.Nk(t.K,e))+.7*t.sb()*n.Math.sin(s),Y=xl.ci(t.Q,xl.Ok(t.K,e))+.7*t.sb()*n.Math.cos(s),Q=t.B,!t.J&&1!=t.K.O&&xl.Ld(t,xl.fd(t,e)),xl.yd(t,G,Y,H,!1),xl.Ld(t,Q),t.yb(t.W)),0!=I||0!=X){for(C=vf(kl.jlb,S,6,4,15,1),M=0;M<xl.En(t.K,e);M++)for(l=xl.Tn(t.K,e,M),N=0;N<2;N++)xl.Vk(t.K,N,l)==e&&((F=xl.Uk(t.K,xl.Vk(t.K,N,l),xl.Vk(t.K,1-N,l)))<Gn?(C[0]-=F+on,C[3]+=F+rn):F<0?(C[2]+=F+on,C[3]-=F):F<on?(C[1]+=F,C[2]+=on-F):(C[0]+=F-on,C[1]+=rn-F));if(0==xl.Sn(t.K,e)?xl.Cl(t.K,e)?C[3]-=.2:C[1]-=.2:C[1]-=.1,(null!=R||null!=k)&&(C[1]+=10),(null!=w||null!=d)&&(C[3]+=10),m="",0!=I&&(T=t.rb("H"),A=0,j=t.sb(),-1==I?(m="n",t.yb((2*t.W+1)/3|0),A=t.rb(m)):I>1&&(m=""+I,t.yb((2*t.W+1)/3|0),A=t.rb(m)),C[1]<.6||C[3]<.6?(u=xl.ci(t.Q,xl.Ok(t.K,e)),C[1]<=C[3]?(C[1]+=10,g=xl.bi(t.Q,xl.Nk(t.K,e))+(L+T)/2):(C[3]+=10,g=xl.bi(t.Q,xl.Nk(t.K,e))-(L+T)/2-A)):(g=xl.bi(t.Q,xl.Nk(t.K,e)),C[0]<C[2]?(C[0]+=10,u=xl.ci(t.Q,xl.Ok(t.K,e))-j):(C[2]+=10,u=xl.ci(t.Q,xl.Ok(t.K,e))+j)),A>0&&(G=g+(T+A)/2,Y=u+((4*t.sb()+4)/8|0),xl.yd(t,G,Y,m,!0),t.yb(t.W)),xl.yd(t,g,u,"H",!0)),o=0,0!=X){for(J=50,c=0,P=0;P<4;P++)h=P>1?P-2:P+2,C[P]<J?(o=P,J=C[P],c=C[h]):C[P]==J&&C[h]>c&&(o=P,c=C[h]);switch(o){case 0:g=xl.bi(t.Q,xl.Nk(t.K,e)),u=xl.ci(t.Q,xl.Ok(t.K,e))-t.U-L/2;break;case 1:g=xl.bi(t.Q,xl.Nk(t.K,e))+t.U+L/2,u=xl.ci(t.Q,xl.Ok(t.K,e));break;case 2:g=xl.bi(t.Q,xl.Nk(t.K,e)),u=xl.ci(t.Q,xl.Ok(t.K,e))+t.U+L/2;break;default:g=xl.bi(t.Q,xl.Nk(t.K,e))-t.U-L/2,u=xl.ci(t.Q,xl.Ok(t.K,e))}if(1==X)Fl.Si(t.Z,new Kl.KG(g-t.U,u-t.U,2*t.U,2*t.U)),t.J||Fl.Si(t.T,new xl.Yd(g,u,xl.md(t,e)?-3:t.p[e]));else{switch(o){case 2:case 0:q=2*t.U,Z=0,g-=t.U;break;default:q=0,Z=2*t.U,u-=t.U}Fl.Si(t.Z,new Kl.KG(g-t.U,u-t.U,2*t.U,2*t.U)),t.J||Fl.Si(t.T,new xl.Yd(g,u,xl.md(t,e)?-3:t.p[e])),Fl.Si(t.Z,new Kl.KG(g+q-t.U,u+Z-t.U,2*t.U,2*t.U)),t.J||Fl.Si(t.T,new xl.Yd(g+q,u+Z,xl.md(t,e)?-3:t.p[e]))}}-8==t.B&&xl.Ld(t,-9)}else-8==t.B&&xl.Ld(t,-9)},xl.vd=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C;if(m=new xl.Zd,e=new xl.Zd,r=new xl.Zd,D=new Kl.AG,b=new Kl.AG,s=xl.Vk(n.K,0,t),a=xl.Vk(n.K,1,t),n.ub(t,xl.bi(n.Q,xl.Nk(n.K,s)),xl.ci(n.Q,xl.Ok(n.K,s)),xl.bi(n.Q,xl.Nk(n.K,a)),xl.ci(n.Q,xl.Ok(n.K,a))),!xl.Jl(n.K,s)&&!xl.Jl(n.K,a)&&Bg(Cg(Eg(xl.Lk(n.K,s),xl.Lk(n.K,a)),tn),0)&&xl.Ld(n,-8),n.o[s]?(m.a=n.o[s].a,m.c=n.o[s].b):(m.a=xl.bi(n.Q,xl.Nk(n.K,s)),m.c=xl.ci(n.Q,xl.Ok(n.K,s))),n.o[a]?(m.b=n.o[a].a,m.d=n.o[a].b):(m.b=xl.bi(n.Q,xl.Nk(n.K,a)),m.d=xl.ci(n.Q,xl.Ok(n.K,a))),0!=(xl.dl(n.K,t)&qn))return xl.Hd(n,m)&&n.nb(m),void xl.Ld(n,-9);switch(o=64==xl.el(n.K,t)?0:32==xl.el(n.K,t)?1:xl.bl(n.K,t)){case 1:if(l=xl.el(n.K,t),0!=(128&n.F)&&(257==l||129==l)&&(j=xl.Vk(n.K,0,t),0!=(c=xl.Ek(n.K,j)))){for(d=xl.Dk(n.K,j),u=0,i=0;i<n.K.f;i++)xl.Ek(n.K,i)==c&&xl.Dk(n.K,i)==d&&++u;1==u&&(l=1)}switch(l){case 1:xl.Hd(n,m)&&xl.$c(n,m,s,a);break;case 257:xl.Ed(n,m,s,a);break;case 129:for(A=m.b-m.a,C=m.d-m.c,xl.yl(n.K,xl.Pn(n.K,s,a))?(f=-3,g=-3):(f=n.p[s],g=xl.fd(n,s),f==xl.Ak(n.K,s)&&(f=g)),h=2;h<17;h+=2)e.a=m.a+h*A/17-h*C/128,e.c=m.c+h*C/17+h*A/128,e.b=m.a+h*A/17+h*C/128,e.d=m.c+h*C/17-h*A/128,xl.Hd(n,e)&&(xl.Ld(n,h<9?f:g),n.mb(e),xl.Ld(n,n.P));break;case 32:xl.Hd(n,m)&&xl.ad(n,m,s,a)}break;case 0:case 2:if(!n.r[s]&&2!=xl.In(n.K,s)||!n.r[a]&&2!=xl.In(n.K,a)||xl.Vo(n.K,t)||2!=o)!n.r[a]&&2!=xl.In(n.K,a)||2!=o?!n.r[s]&&2!=xl.In(n.K,s)||2!=o?(0==(H=xl.ro(n.K,t))&&(H=1),e.a=m.a,e.c=m.c,e.b=m.b,e.d=m.d,xl.qd(n,m.b-m.a,m.d-m.c,D),H>0?(r.a=m.a+D.a,r.c=m.c+D.b,r.b=m.b+D.a,r.d=m.d+D.b,(xl.pd(n,s,a,1,b)||xl.Sn(n.K,s)>1)&&(r.a+=b.a+D.b,r.c+=b.b-D.a),(xl.pd(n,a,s,-1,b)||xl.Sn(n.K,a)>1)&&(r.b+=b.a-D.b,r.d+=b.b+D.a)):(r.a=m.a-D.a,r.c=m.c-D.b,r.b=m.b-D.a,r.d=m.d-D.b,(xl.pd(n,s,a,-1,b)||xl.Sn(n.K,s)>1)&&(r.a+=b.a+D.b,r.c+=b.b-D.a),(xl.pd(n,a,s,1,b)||xl.Sn(n.K,a)>1)&&(r.b+=b.a-D.b,r.d+=b.b+D.a)),386==xl.el(n.K,t)&&xl.Gd(e,r),xl.Hd(n,e)&&xl.$c(n,e,s,a),2==o?xl.Hd(n,r)&&xl.$c(n,r,s,a):xl.Hd(n,r)&&xl.Yc(n,r,s,a)):xl.rd(n,m,t,!0):xl.rd(n,m,t,!1);else{if(!xl.Hd(n,m))break;xl.qd(n,m.b-m.a,m.d-m.c,D),A=D.a/2,C=D.b/2,e.a=m.a+A,e.c=m.c+C,e.b=m.b+A,e.d=m.d+C,r.a=m.a-A,r.c=m.c-C,r.b=m.b-A,r.d=m.d-C,386==xl.el(n.K,t)&&xl.Gd(e,r),xl.$c(n,e,s,a),2==o?xl.$c(n,r,s,a):xl.Yc(n,r,s,a)}break;case 3:xl.Hd(n,m)&&(xl.$c(n,m,s,a),xl.qd(n,m.b-m.a,m.d-m.c,D),xl._c(n,m,s,a,D.a,D.b,e),xl._c(n,m,s,a,-D.a,-D.b,e));break;case 4:xl.Hd(n,m)&&(xl.qd(n,m.b-m.a,m.d-m.c,D),xl._c(n,m,s,a,1.5*D.a,1.5*D.b,e),xl._c(n,m,s,a,.5*D.a,.5*D.b,e),xl._c(n,m,s,a,-.5*D.a,-.5*D.b,e),xl._c(n,m,s,a,-1.5*D.a,-1.5*D.b,e));break;case 5:xl.Hd(n,m)&&(xl.$c(n,m,s,a),xl.qd(n,m.b-m.a,m.d-m.c,D),xl._c(n,m,s,a,2*D.a,2*D.b,e),xl._c(n,m,s,a,D.a,D.b,e),xl._c(n,m,s,a,-D.a,-D.b,e),xl._c(n,m,s,a,-2*D.a,-2*D.b,e))}-8==n.B&&xl.Ld(n,-9)},xl.wd=function(t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D;for(h=!1,s=0;s<t.K.g;s++)g=null,xl.xl(t.K,s)?g=(d=xl.Xk(t.K,s))==(u=xl.Wk(t.K,s))?"["+d+"]":"["+d+":"+u+"]":0!=(xl.dl(t.K,s)&Yn)?g=(xl.dl(t.K,s)&Yn)==Pn?"a":256==(384&xl.dl(t.K,s))?"r!a":"!a":0!=(384&xl.dl(t.K,s))&&(g=256==(384&xl.dl(t.K,s))?"r":"!r"),0!=(c=(xl.dl(t.K,s)&wn)>>17)&&(g=(null==g?"":g)+c),null!=g&&(e=xl.Vk(t.K,0,s),i=xl.Vk(t.K,1,s),h||(t.yb((2*t.W+1)/3|0),h=!0),b=(xl.bi(t.Q,xl.Nk(t.K,e))+xl.bi(t.Q,xl.Nk(t.K,i)))/2,D=(xl.ci(t.Q,xl.Ok(t.K,e))+xl.ci(t.Q,xl.Ok(t.K,i)))/2,r=xl.bi(t.Q,xl.Nk(t.K,i))-xl.bi(t.Q,xl.Nk(t.K,e)),o=xl.ci(t.Q,xl.Ok(t.K,i))-xl.ci(t.Q,xl.Ok(t.K,e)),a=n.Math.sqrt(r*r+o*o),f=.6*t.rb(g),l=.55*t.sb(),0!=a&&(r>0?xl.yd(t,b+f*o/a,D-l*r/a,g,!0):xl.yd(t,b-f*o/a,D+l*r/a,g,!0)));h&&t.yb(t.W)},xl.xd=function(n,t,e,i){Fl.Si(n.Z,new Kl.KG(t-n.U,e-n.U,2*n.U,2*n.U)),n.J||Fl.Si(n.T,new xl.Yd(t,e,xl.md(n,i)?-3:n.p[i]))},xl.yd=function(n,t,e,i,s){var a,r;s&&(a=n.rb(i)/2+(n.sb()/8|0),r=n.sb()/2|0,("+"==i||"-"==i)&&(r=2*r/3),Fl.Si(n.Z,new Kl.KG(t-a,e-r,2*a,2*r))),n.J||n.pb(i,t,e)},xl.zd=function(n){var t;t=n.a,n.a=n.b,n.b=t,t=n.c,n.c=n.d,n.d=t},xl.Ad=function(t,e,i){var s;return s=0==e?an+t[0]-t[t.length-1]:t[e]-t[e-1],s-=i>vn&&i<Zn?2*n.Math.cos(i+On):.5*n.Math.cos(i+On)},xl.Bd=function(n){var t;return t=new Kl.JG,n.a<=n.b?(t.c=n.a,t.b=n.b-n.a):(t.c=n.b,t.b=n.a-n.b),n.c<=n.d?(t.d=n.c,t.a=n.d-n.c):(t.d=n.d,t.a=n.c-n.d),t},xl.Cd=function(n,t){var e,i,s,a,r,o,l;for(e=vf(kl.jlb,S,6,xl.Dn(n.K,t),15,1),s=0;s<xl.Dn(n.K,t);s++)e[s]=xl.Uk(n.K,t,xl.Rn(n.K,t,s));for(Rl.fTb(e,Rl.LTb(Qf(Fl.TOb.prototype.Zd,Fl.TOb,[]))),a=xl.Dd(e,0),r=xl.Ad(e,0,a),i=1;i<e.length;i++)o=xl.Dd(e,i),r<(l=xl.Ad(e,i,o))&&(r=l,a=o);return a},xl.Dd=function(n,t){var e;return t>0?(n[t]+n[t-1])/2:(e=rn+(n[0]+n[n.length-1])/2)>rn?e-an:e},xl.Ed=function(n,t,e,i){var s,a,r,o;if(o=new xl.Zd,t.a!=t.b||t.c!=t.d){for(o.a=t.a,o.c=t.c,o.b=t.b,o.d=t.d,r=xl.Bd(o),s=0;s<n.Z.a.length;s++)if(!((a=Fl.Xi(n.Z,s)).c>r.c+r.b||a.d>r.d+r.a||r.c>a.c+a.b||r.d>a.d+a.a)){if(xl.Fd(n,o.a,o.c,s)){if(xl.Fd(n,o.b,o.d,s))return;return xl.Id(n,o,0,s),void xl.Ed(n,o,e,i)}if(xl.Fd(n,o.b,o.d,s))return xl.Id(n,o,1,s),void xl.Ed(n,o,e,i)}xl.bd(n,o,e,i)}},xl.Fd=function(n,t,e,i){var s;return 0==(1&n.F)&&(t>(s=Fl.Xi(n.Z,i)).c&&t<s.c+s.b&&e>s.d&&e<s.d+s.a)},xl.Gd=function(n,t){var e;e=n.b,n.b=t.b,t.b=e,e=n.d,n.d=t.d,t.d=e},xl.Hd=function(n,t){var e,i,s,a,r,o;if(t.a==t.b&&t.c==t.d){for(r=new Fl.rOb(n.Z);r.a<r.c.a.length;)if(a=Fl.qOb(r),Kl.FG(a,t.a,t.c))return!1;return!0}for(o=xl.Bd(t),e=!1,t.a>t.b&&(xl.zd(t),e=!0),i=0;i<n.Z.a.length;i++)if(!((a=Fl.Xi(n.Z,i)).c>o.c+o.b||a.d>o.d+o.a||o.c>a.c+a.b||o.d>a.d+a.a)){if(xl.Fd(n,t.a,t.c,i))return xl.Fd(n,t.b,t.d,i)?(e&&xl.zd(t),!1):(xl.Id(n,t,0,i),s=xl.Hd(n,t),e&&xl.zd(t),s);if(xl.Fd(n,t.b,t.d,i))return xl.Id(n,t,1,i),s=xl.Hd(n,t),e&&xl.zd(t),s}return e&&xl.zd(t),!0},xl.Id=function(t,e,i,s){var a,r,o,l,f,g,u,d,c,h,b;0==i?(d=e.a,h=e.c,c=e.b,b=e.d):(d=e.b,h=e.d,c=e.a,b=e.c),u=Fl.Xi(t.Z,s),f=c>d?u.c+u.b:u.c,g=b>h?u.d+u.a:u.d,a=c-d,r=b-h,n.Math.abs(a)>n.Math.abs(r)?h==b?(o=f,l=h):c>d==f>(o=d+a*(g-h)/r)?l=g:(o=f,l=h+r*(f-d)/a):d==c?(o=d,l=g):b>h==g>(l=h+r*(f-d)/a)?o=f:(o=d+a*(g-h)/r,l=g),0==i?(e.a=o,e.c=l):(e.b=o,e.d=l)},xl.Jd=function(n){var t,e,i,s;if(0!=n.K.q){for(xl.nu(n.K,0!=(256&n.F)?63:0!=(512&n.F)?95:31),xl.Vc(n),e=xl.su(n.K),i=!1,n.p=vf(kl.llb,z,6,n.K.q,15,1),t=0;t<n.K.q;t++)n.p[t]=xl.Ak(n.K,t),0!=n.p[t]&&(i=!0),xl.Jl(n.K,t)&&(n.p[t]=128),xl.ml(n.K,t)&&0==(n.F&zn)&&(n.p[t]=256);for(xl.Ld(n,-10),xl.jd(n),xl.hd(n),xl.kd(n),xl.Sc(n),n.yb(n.W),n.wb(n.X),xl.Ld(n,n.P),xl.nd(n),Rl.eTb(n.T.a,0),Rl.eTb(n.Z.a,0),0!=(1&n.F)&&(xl.sd(n,e),xl.td(n),xl.wd(n)),s=0;s<n.K.q;s++)xl.md(n,s)?(xl.Ld(n,-3),xl.ud(n,s,e),xl.Ld(n,n.P)):0!=n.p[s]?(xl.Ld(n,n.p[s]),xl.ud(n,s,e),xl.Ld(n,n.P)):!i&&1!=n.K.O&&1!=xl.Qk(n.K,s)&&6!=xl.Qk(n.K,s)&&0==(n.F&hn)&&null==xl.Gk(n.K,s)&&xl.Qk(n.K,s)<xl.Pc.length?(xl.Nd(n,xl.ed(n,xl.Pc[xl.Qk(n.K,s)])),xl.ud(n,s,e),xl.Ld(n,n.P)):xl.ud(n,s,e);0==(1&n.F)&&(xl.td(n),xl.wd(n),xl.sd(n,e))}},xl.Kd=function(n,t,e,i){var s;switch(s=e/2,i&Vn){case Vn:if(t){n.w.a=t.c+t.b/2,n.w.b=t.d+t.a-s;break}case 0:n.w.a=n.v.c+n.v.b/2,n.w.b=n.v.d+n.v.a+s,t&&n.w.b>t.d+t.a-s&&(n.w.b=t.d+t.a-s);break;case Kn:if(t){n.w.a=t.c+t.b/2,n.w.b=t.d+s;break}case Wn:n.w.a=n.v.c+n.v.b/2,n.w.b=n.v.d-s,t&&n.w.b<t.d+s&&(n.w.b=t.d+s)}},xl.Ld=function(n,t){if(!n.J&&(-10==t&&(n.B=-999,t=n.P),-2!=t&&-7!=t&&0!=n.M&&(t=-4),t!=n.B&&(-8!=n.B||-9==t)))switch(-8==t&&(n.N=n.B),-9==t&&(t=n.N),n.B=t,t){case 0:n.xb(0==n.D?_n:n.D);break;case-6:n.xb(n.D);break;case-4:n.xb(n.M);break;case-2:n.xb(n.t);break;case-3:n.xb(n.u);break;case-7:n.xb(n.G);break;case-8:n.xb(n.H);break;case-5:n.xb(n.O);break;case 64:n.xb(-14655233);break;case 128:n.xb($n);break;case 256:n.xb(-4194049);break;case 192:n.xb(-16711936);break;case 320:n.xb(-24576);break;case 384:n.xb(-16744448);break;case 448:n.xb(-6291456);break;case 1:n.xb(-8355712);break;default:n.xb(_n)}},xl.Md=function(n,t){n.F=t},xl.Nd=function(n,t){0==n.M?(n.B=-5,n.O=t,n.xb(t)):-4!=n.B&&(n.B=-4,n.xb(n.M))},xl.Od=function(n){var t,e,i,s,a;for(s=xl.bi(n.Q,xl.Nk(n.K,0)),e=xl.bi(n.Q,xl.Nk(n.K,0)),a=xl.ci(n.Q,xl.Ok(n.K,0)),i=xl.ci(n.Q,xl.Ok(n.K,0)),t=0;t<n.K.q;t++)s>xl.bi(n.Q,xl.Nk(n.K,t))&&(s=xl.bi(n.Q,xl.Nk(n.K,t))),e<xl.bi(n.Q,xl.Nk(n.K,t))&&(e=xl.bi(n.Q,xl.Nk(n.K,t))),a>xl.ci(n.Q,xl.Ok(n.K,t))&&(a=xl.ci(n.Q,xl.Ok(n.K,t))),i<xl.ci(n.Q,xl.Ok(n.K,t))&&(i=xl.ci(n.Q,xl.Ok(n.K,t)));return new Kl.KG(s,a,e-s,i-a)},xl.Pd=function(n,t,e){var i,s;return 0==n.K.q?null:(n.v=xl.Od(n),i=n.Q.c*xl.Rk(n.K),1==(s=new xl.fi(n.v,t,i,e)).c&&0==s.a&&0==s.b?s=null:(xl.Xh(s,n.Q),xl.$h(s,n.v)),xl.Kd(n,t,i,e),s)},xl.Qd=function(n){var t;t=0!=n.L?n.L:0!=n.C?n.C:-1,n.t=gf.p6(t),n.u=gf.o6(nt,t),n.G=-24321,n.H=-6291392},xl.Rd=function(n,t){var e;return xl.Sd(n,t,J),xl.ai(n.Q)?null:(e=n.Q,xl.Yh(n.Q,n.K),n.Q=new xl.di,e)},xl.Sd=function(n,t,e){var i,s,a,r;if(0==n.K.q)return null;for(a=n.zb(t,e),xl.nu(n.K,0!=(256&n.F)?63:0!=(512&n.F)?95:31),xl.nd(n),Rl.eTb(n.T.a,0),Rl.eTb(n.Z.a,0),xl.Vc(n),n.yb(n.W),n.J=!0,s=0;s<n.K.q;s++)xl.ud(n,s,null);return n.J=!1,i=n.Q.c*xl.Rk(n.K),xl.cd(n,i),xl.Kd(n,t,i,e),!t||Kl.GG(t,n.v)?a:(r=new xl.fi(n.v,t,i,e),xl.Xh(r,n.Q),xl.$h(r,n.v),xl.Zh(r,n.w),a?(xl.Xh(r,a),a):r)},xl.Td=function(n,t){xl.Qc(),xl.Rc(this),this.K=n,this.F=t,xl.ld(this)},zf(144,1,{144:1}),o.tb=function(n,t,e,i){},o.ub=function(n,t,e,i,s){},o.vb=function(n){xl.Jd(this)},o.zb=function(n,t){return xl.Pd(this,n,t)},o.t=0,o.u=0,o.A=0,o.B=0,o.C=0,o.D=0,o.F=0,o.G=0,o.H=0,o.I=0,o.J=!1,o.L=0,o.M=0,o.N=0,o.O=0,o.P=0,o.R=0,o.S=0,o.U=0,o.V=0,o.W=0,o.X=0,o.Y=0,kl.qlb=lg(144),xl.Yd=function(n,t,e){this.b=n,this.c=t,this.a=e},zf(161,1,{161:1},xl.Yd),o.a=0,o.b=0,o.c=0,kl.olb=lg(161),xl.Zd=function(){},zf(81,1,{},xl.Zd),o.a=0,o.b=0,o.c=0,o.d=0,kl.plb=lg(81),xl.$d=function(n){return tt+n.Cb()+'"'+n.Bb()+et},zf(230,1,{230:1}),o.lb=function(){var n;return n=new Jl._Hb,Jl.$Hb(n,tt+this.Cb()+'"'+this.Bb()+et),n.a},o.d=!1,kl.rlb=lg(230),xl.ae=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I,P,M,w,N,L,U,k,J,y,B,R,E,x,F,Q,S,X,G,q,Y,v;for(k=vf(kl.Cwb,nn,6,t.i.a.length,16,1),p=vf(kl.llb,z,6,n.f.f,15,1),X=0;X<t.i.a.length;X++){for(k[X]=!0,H=0,j=(D=Fl.Xi(t.j,X)).length;H<j;++H)if(m=D[H],!n.e[m]){k[X]=!1;break}if(k[X])for(r=0,f=(i=Fl.Xi(t.i,X)).length;r<f;++r)++p[e=i[r]]}for(U=vf(kl.Cwb,nn,6,n.f.f,16,1),G=0;G<t.i.a.length;G++)if((3==(q=Fl.Xi(t.j,G).length)||5==q||6==q||7==q)&&k[G]){for(o=0,g=(s=Fl.Xi(t.i,G)).length;o<g;++o)U[e=s[o]]=!0;for(F=!0,B=-1,R=0,l=0,u=(a=Fl.Xi(t.i,G)).length;l<u;++l)if(e=a[l],6==q||p[e]>1){if(!xl.ee(n,e,!1)){F=!1;break}}else if(S=5==q?xl.be(n,e,!1):xl.ce(n,e,!1),xl.ee(n,e,!1))R<S&&(R=S,B=e);else{if(10==R){F=!1;break}B=e,R=20}if(F)for(r=0,f=(i=Fl.Xi(t.i,G)).length;r<f;++r)(e=i[r])==B?(5==q?xl.be(n,e,!0):xl.ce(n,e,!0),xl.pe(n,e)):xl.ee(n,e,!0)}for(T=vf(kl.llb,z,6,n.f.f,15,1),P=vf(kl.Cwb,nn,6,n.f.f,16,1),b=0;b<n.f.g;b++)d=xl.Vk(n.f,0,b),c=xl.Vk(n.f,1,b),U[d]||U[c]||(n.e[b]&&(++T[d],++T[c]),32==xl.el(n.f,b)&&(P[d]=!0,P[c]=!0));for(Q=vf(kl.llb,z,6,n.f.f,15,1),I=vf(kl.llb,z,6,n.f.f,15,1),v=0;v<n.f.f;v++)if(1==T[v])for(I[0]=v,C=0,M=0;C<=M;){for(w=0;w<xl.Sn(n.f,I[C]);w++)if(n.e[xl.Tn(n.f,I[C],w)]&&(A=xl.Rn(n.f,I[C],w),(0==C||A!=I[C-1])&&0!=T[A])){if(I[++M]=A,0!=(1&T[A])){for(y=1;y<M;y+=2)Q[I[y]]=-1;M=0}break}++C}for(h=vf(kl.Cwb,nn,6,n.f.f,16,1),Y=0;Y<n.f.f;Y++)if(!h[Y]&&0!=T[Y]){for(I[0]=Y,h[Y]=!0,C=0,M=0;C<=M;){for(w=0;w<xl.Sn(n.f,I[C]);w++)n.e[xl.Tn(n.f,I[C],w)]&&(h[A=xl.Rn(n.f,I[C],w)]||(I[++M]=A,h[A]=!0));++C}if(0==(1&M)){for(N=0;N<=M;N++)0==Q[I[N]]&&(Q[I[N]]=xl.de(n,I[N],!1));for(J=!0,L=0;L<=M;L++)if(Q[I[L]]<=0&&!xl.ee(n,I[L],!1)){J=!1;break}if(J){for(x=0,E=-1,w=0;w<=M;w++)x<Q[I[w]]&&(x=Q[I[w]],E=I[w]);x>0&&(xl.de(n,E,!0),xl.pe(n,E))}}}},xl.be=function(n,t,e){if(7==xl.Qk(n.f,t)){if(3==xl.Dn(n.f,t))return 6;if(2==xl.Sn(n.f,t))return 4}else{if(8==xl.Qk(n.f,t))return 10;if(15==xl.Qk(n.f,t)||33==xl.Qk(n.f,t)){if(3==xl.Sn(n.f,t))return 8}else if(16==xl.Qk(n.f,t)||34==xl.Qk(n.f,t)||52==xl.Qk(n.f,t)){if(2==xl.Sn(n.f,t))return 12}else if(6==xl.Qk(n.f,t))return e&&xl.cm(n.f,t,-1),xl.Dn(n.f,t)!=xl.En(n.f,t)?2:3}return 0},xl.ce=function(n,t,e){if(n.a){if(3!=xl.Dn(n.f,t))return 0}else if(xl.Dn(n.f,t)>3)return 0;return 6==xl.Qk(n.f,t)?(e&&xl.cm(n.f,t,1),2):5==xl.Qk(n.f,t)?4:0},xl.de=function(n,t,e){if(0!=xl.zk(n.f,t))return 0;if(n.a){if(5==xl.Qk(n.f,t))return 2!=xl.ko(n.f,t)?0:(e&&xl.cm(n.f,t,1),1);if(7==xl.Qk(n.f,t))return 2!=xl.ko(n.f,t)?0:(e&&xl.cm(n.f,t,-1),xl.ge(n,t)?6:3);if(8==xl.Qk(n.f,t))return 1!=xl.ko(n.f,t)?0:(e&&xl.cm(n.f,t,-1),xl.ge(n,t)?7:4);if(16==xl.Qk(n.f,t))return 1!=xl.ko(n.f,t)?0:(e&&xl.cm(n.f,t,-1),xl.ge(n,t)?5:2);if(34==xl.Qk(n.f,t))return 1!=xl.ko(n.f,t)?0:(e&&xl.cm(n.f,t,-1),xl.ge(n,t)?4:1)}else{if(5==xl.Qk(n.f,t))return xl.ko(n.f,t)>2?0:(e&&xl.cm(n.f,t,1),1);if(7==xl.Qk(n.f,t))return xl.ko(n.f,t)>2?0:(e&&xl.cm(n.f,t,-1),xl.ge(n,t)?5:3);if(8==xl.Qk(n.f,t))return xl.ko(n.f,t)>1?0:(e&&xl.cm(n.f,t,-1),xl.ge(n,t)?7:4);if(16==xl.Qk(n.f,t))return xl.ko(n.f,t)>1?0:(e&&xl.cm(n.f,t,-1),xl.ge(n,t)?5:2)}return 0},xl.ee=function(n,t,e){var i,s;if((i=xl.Qk(n.f,t))>=5&&i<=8||15==i||16==i||33==i||34==i||52==i){if(0!=xl.go(n.f,t))return!0;if(s=xl.zk(n.f,t),5==i&&s>=0)return e&&xl.cm(n.f,t,s-1),!0;if(5!=i&&s<=0)return e&&xl.cm(n.f,t,s+1),!0}return!1},xl.fe=function(n,t,e,i){var s;for(s=0;s<xl.Sn(n.f,t);s++)if(1==i[xl.Tn(n.f,t,s)]&&xl.Rn(n.f,t,s)!=e)return s;return-1},xl.ge=function(n,t){var e;for(e=0;e<xl.Sn(n.f,t);e++)if(xl.Fl(n.f,xl.Rn(n.f,t,e)))return!0;return!1},xl.he=function(n,t,e){var i;for(i=0;i<xl.Sn(n.f,t);i++)if(e[xl.Tn(n.f,t,i)]>1)return!0;return!1},xl.ie=function(n,t){var e;for(e=0;e<xl.Sn(n.f,t);e++)if(n.e[xl.Tn(n.f,t,e)])return!0;return!1},xl.je=function(n,t,e){var i,s,a,r,o,l,f,g,u,d;if(xl.nu(n.f,1),null!=t)n.e=t;else for(n.e=vf(kl.Cwb,nn,6,n.f.g,16,1),s=0;s<n.f.g;s++)64==xl.el(n.f,s)&&(n.e[s]=!0,xl.Fm(n.f,s,1));for(n.g=0,n.d=vf(kl.Cwb,nn,6,n.f.f,16,1),a=0;a<n.f.g;a++)if(n.e[a])for(++n.c,o=0;o<2;o++)n.d[xl.Vk(n.f,o,a)]||(n.d[xl.Vk(n.f,o,a)]=!0,++n.b);if(0==n.c)return!0;for(n.a=!1,xl.re(n,e),n.f.K&&xl.le(n),d=new xl.gs(n.f,1),e&&xl.ae(n,d),xl.se(n,d),xl.oe(n,d),xl.qe(n),xl.me(n);xl.ne(n,d);)xl.me(n);for(;0!=n.c;){if(!(r=!1))for(g=0;g<d.i.a.length;g++)if(6==Fl.Xi(d.j,g).length){for(f=!0,u=Fl.Xi(d.j,g),l=0;l<6;l++)if(!n.e[u[l]]){f=!1;break}if(f){for(o=0;o<6;o+=2)xl.ke(n,u[o]);r=!0;break}}if(!r)for(i=0;i<n.f.g;i++)if(n.e[i]){xl.ke(n,i),xl.me(n),r=!0;break}}return n.b==n.g},xl.ke=function(n,t){var e,i,s,a;for(1==xl.el(n.f,t)&&(xl.Fm(n.f,t,2),n.g+=2),s=0;s<2;s++)for(e=xl.Vk(n.f,s,t),n.d[e]=!1,a=0;a<xl.Sn(n.f,e);a++)i=xl.Tn(n.f,e,a),n.e[i]&&(n.e[i]=!1,--n.c)},xl.le=function(n){var t,e,i,s,a,r,o,l;for(e=0;e<n.f.g;e++)if(n.e[e])for(s=0;s<2;s++){for(o=xl.Vk(n.f,s,e),t=!1,r=0;r<xl.Sn(n.f,o);r++)if(e!=xl.Tn(n.f,o,r)&&n.e[xl.Tn(n.f,o,r)]){t=!0;break}if(!t){for(l=e,i=xl.Vk(n.f,1-s,e);-1!=l;)for(n.e[l]=!1,--n.c,xl.Fm(n.f,l,64),l=-1,o=i,a=0;a<xl.Sn(n.f,o);a++)if(n.e[xl.Tn(n.f,o,a)]){if(-1!=l){o=-1,l=-1;break}l=xl.Tn(n.f,o,a),i=xl.Rn(n.f,o,a)}break}}},xl.me=function(n){var t,e,i,s,a,r,o;do{for(o=!1,e=0;e<n.f.g;e++)if(n.e[e]){for(a=!1,s=0;s<2;s++){for(i=xl.Vk(n.f,s,e),t=!1,r=0;r<xl.Sn(n.f,i);r++)if(e!=xl.Tn(n.f,i,r)&&n.e[xl.Tn(n.f,i,r)]){t=!0;break}if(!t){a=!0;break}}a&&(o=!0,xl.ke(n,e))}}while(o)},xl.ne=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h;for(h=vf(kl.llb,z,6,n.f.g,15,1),d=0;d<t.i.a.length;d++){for(c=Fl.Xi(t.j,d),u=!0,g=0;g<c.length;g++)if(!n.e[c[g]]){u=!1;break}if(u)for(f=0;f<c.length;f++)++h[c[f]]}for(l=n.c,a=0;a<n.f.g;a++)if(1==h[a])for(f=0;f<2&&n.e[a];f++)if(e=xl.Vk(n.f,f,a),i=xl.Vk(n.f,1-f,a),xl.he(n,e,h)&&!xl.he(n,i,h))for(;-1!=(o=xl.fe(n,i,e,h))&&(s=xl.Rn(n.f,i,o),r=xl.Tn(n.f,i,o),n.e[r])&&(xl.ke(n,r),-1!=(o=xl.fe(n,s,i,h)));)e=s,i=xl.Rn(n.f,s,o);return l!=n.c},xl.oe=function(n,t){var e;for(e=0;e<n.f.g;e++)n.e[e]&&xl._r(t,e)&&(xl.pe(n,xl.Vk(n.f,0,e)),xl.pe(n,xl.Vk(n.f,1,e)))},xl.pe=function(n,t){var e,i;for(n.d[t]&&(n.d[t]=!1,--n.b),i=0;i<xl.Sn(n.f,t);i++)e=xl.Tn(n.f,t,i),n.e[e]&&(n.e[e]=!1,--n.c)},xl.qe=function(n){var t,e,i,s,a;for(e=0;e<n.f.g;e++)if(2==xl.bl(n.f,e))for(s=0;s<2;s++)if(t=xl.Vk(n.f,s,e),xl.Qk(n.f,t)<=8)for(a=0;a<xl.Sn(n.f,t);a++)if(i=xl.Tn(n.f,t,a),n.e[i]){xl.pe(n,t);break}},xl.re=function(n,t){var e;for(e=0;e<n.f.f;e++)n.d[e]&&0==xl.go(n.f,e)&&(!t||5==xl.Qk(n.f,e)&&xl.zk(n.f,e)<0||6==xl.Qk(n.f,e)||14==xl.Qk(n.f,e)||xl.Cl(n.f,e)&&xl.zk(n.f,e)>0)&&xl.pe(n,e)},xl.se=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c;for(g=0;g<t.i.a.length;g++)if(3==(c=Fl.Xi(t.j,g).length)||5==c||7==c)for(u=Fl.Xi(t.i,g),i=0;i<c;i++)e=u[i],xl.ie(n,e)&&(5==c?(6==xl.Qk(n.f,e)&&-1==xl.zk(n.f,e)&&3==xl.Dn(n.f,e)||7==xl.Qk(n.f,e)&&0==xl.zk(n.f,e)&&3==xl.Dn(n.f,e)||8==xl.Qk(n.f,e)&&0==xl.zk(n.f,e)&&2==xl.Sn(n.f,e)||16==xl.Qk(n.f,e)&&0==xl.zk(n.f,e)&&2==xl.Sn(n.f,e)||34==xl.Qk(n.f,e)&&0==xl.zk(n.f,e)&&2==xl.Sn(n.f,e))&&xl.pe(n,e):(5==xl.Qk(n.f,e)&&0==xl.zk(n.f,e)&&3==xl.Dn(n.f,e)||6==xl.Qk(n.f,e)&&1==xl.zk(n.f,e))&&xl.pe(n,e));for(f=0;f<t.i.a.length;f++)if(5==Fl.Xi(t.j,f).length){for(d=Fl.Xi(t.j,f),a=!0,s=0;s<d.length;s++)if(!n.e[d[s]]){a=!1;break}if(a){for(u=Fl.Xi(t.i,f),o=0,r=-1,i=0;i<d.length;i++)-1==xl.zk(n.f,u[i])&&6==xl.Qk(n.f,u[i])&&o<(l=3==xl.Dn(n.f,u[i])?3:3==xl.En(n.f,u[i])?2:1)&&(o=l,r=u[i]);-1!=r&&xl.pe(n,r)}}},xl.te=function(n){this.f=n},zf(114,1,{},xl.te),o.a=!1,o.b=0,o.c=0,o.g=0,kl.slb=lg(114),xl.ue=function(n,t){var e,i;for(e=0,i=0;i<n.j[t];i++)2==n.n[t][i]&&(7==xl.Qk(n,n.i[t][i])||8==xl.Qk(n,n.i[t][i])||16==xl.Qk(n,n.i[t][i]))&&++e;return e},xl.ve=function(t,e){var i,s,a,r,o,l;if(0==t.s[e])return!1;for(l=!0,i=t.s[e],r=t.j[e],o=0,s=0;s<r;s++)a=t.i[e][s],o+=t.s[a];return n.Math.abs(i)<=n.Math.abs(o)&&Jl.lHb(i)!=Jl.lHb(o)&&(l=!1),l},xl.we=function(n,t){var e,i,s,a,r,o,l;if(8!=n.C[t]||0!=n.s[t]||1!=n.j[t]||1!=n.n[t][0])return!1;if(e=n.i[t][0],6==n.C[e]){for(r=n.j[e],i=0;i<r;i++)if((s=n.i[e][i])!=t&&8==n.C[s]&&(a=xl.Pn(n,e,s),2==n.H[a]))return!0}else if(7==n.C[e]){if(1==n.s[e])return!0}else if(16==n.C[e]){for(o=n.j[e],l=0,i=0;i<o;i++)(s=n.i[e][i])!=t&&8==n.C[s]&&(a=xl.Pn(n,e,s),2==n.H[a]&&++l);if(2==l)return!0}else if(xl.xe(n,t))return!0;return!1},xl.xe=function(n,t){var e,i,s,a,r;if(8!=n.C[t])return!1;if(1!=n.j[t])return!1;if(e=n.i[t][0],15==n.C[e])for(r=n.j[e],i=0;i<r;i++)if((s=n.i[e][i])!=t&&8==n.C[s]&&(a=xl.Pn(n,e,s),2==n.H[a]))return!0;return!1},xl.ye=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p;if(7!=n.C[t]||0!=n.s[t]||n.j[t]+n.o[t]>3)return!1;if(t<n.f&&xl.Ur(n.p,t)){if(1!=n.o[t])return!1;if(1!=xl.Ln(n,t,7))return!1;for(xl.nu(n,7),A=n.p,j=0;j<A.i.a.length;j++)if(xl.Wr(A,j,t)){if(5==Fl.Xi(A.j,j).length||6==Fl.Xi(A.j,j).length){for(C=Fl.Xi(A.i,j),D=-1,l=0;l<C.length;l++)if(C[l]==t){D=l;break}for(s=0,H=null,b=null,5==C.length&&((H=vf(kl.llb,z,6,2,15,1))[0]=C[D-1<0?D+4:D-1],H[1]=C[D-4<0?D+1:D-4],(b=vf(kl.llb,z,6,2,15,1))[0]=C[D-2<0?D+3:D-2],b[1]=C[D-3<0?D+2:D-3]),6==C.length&&((H=vf(kl.llb,z,6,3,15,1))[0]=C[D-1<0?D+5:D-1],H[1]=C[D-3<0?D+3:D-3],H[2]=C[D-5<0?D+1:D-5],(b=vf(kl.llb,z,6,2,15,1))[0]=C[D-2<0?D+4:D-2],b[1]=C[D-4<0?D+2:D-4]),f=0;f<C.length;f++)t!=C[f]&&7==xl.Qk(n,C[f])&&1==xl.In(n,C[f])&&--s;for(g=0;g<H.length;g++){for(a=-1,r=-1,h=0;h<xl.Sn(n,H[g]);h++)if(!xl.Io(n,xl.Tn(n,H[g],h))){a=xl.Rn(n,H[g],h),r=xl.Tn(n,H[g],h);break}if(-1!=a){if(7==n.C[a]&&0==n.o[a]&&n.j[a]+n.o[a]<=3&&!xl.ze(n,a,!1)){++s;continue}if(8==n.C[a]&&1==n.j[a]){s+=2;continue}if(r<n.g&&xl.Vr(n.p,r))for(T=0;T<A.i.a.length;T++)if(A.d[T]&&xl.Wr(A,T,a)){for(m=Fl.Xi(A.i,T),c=0;c<m.length;c++)if(7==xl.Qk(n,m[c])&&1==xl.In(n,m[c])){--s;break}break}}}for(u=0;u<b.length;u++){for(a=-1,c=0;c<xl.Sn(n,b[u]);c++)xl.Io(n,xl.Tn(n,b[u],c))||(a=xl.Rn(n,b[u],c));6==xl.Qk(n,b[u])?-1!=a&&0!=xl.ue(n,a)&&--s:7==xl.Qk(n,b[u])&&0==xl.In(n,b[u])&&(-1==a||!(a<n.f&&xl.Ur(n.p,a))&&0==xl.ue(n,a))&&++s}return s>0}break}return!1}if(n.o[t]>1)return!1;if(1==n.o[t]){for(d=-1,p=0,l=0;l<n.j[t];l++)if(i=n.i[t][l],2!=n.n[t][l]){if(8==n.C[i])return!1;7!=n.C[i]?i<n.f&&xl.Ur(n.p,i)&&--p:(--p,xl.ze(n,i,!1)&&--p)}else{if(6!=n.C[i])return!1;d=i}if(-1==d)return!1;for(e=0,f=0;f<n.j[d];f++)if(1==n.n[d][f]){if(i=n.i[d][f],0!=xl.ue(n,i))return!1;i<n.f&&xl.Ur(n.p,i)&&++e,7==n.C[i]&&!xl.ze(n,i,!0)&&++p,(8==n.C[i]||16==n.C[i])&&--p}return 2==e&&--p,p>=0}for(o=0;o<n.j[t];o++){if((i=n.i[t][o])<n.f&&xl.Ur(n.p,i))return!1;if(6!=n.C[i])return!1;if(0!=xl.ue(n,i))return!1;if(0!=n.o[i]&&xl.Ae(n,i))return!1}return!0},xl.ze=function(n,t,e){var i,s,a;for(i=!1,a=0;a<n.j[t];a++)if(!xl.Io(n,n.k[t][a])&&1==n.n[t][a]&&!((s=n.i[t][a])<n.f&&xl.Ur(n.p,s))&&(6==n.C[s]&&1==xl.ue(n,s)||16==n.C[s]&&2==xl.ue(n,s))){if(i||!e)return!0;i=!0}return!1},xl.Ae=function(n,t){var e,i,s;for(i=0;i<n.j[t];i++)if(1!=n.n[t][i])for(e=n.i[t][i],s=0;s<n.j[e];s++)if(1==n.n[e][s]&&0!=xl.ue(n,n.i[e][s]))return!0;return!1},xl.De=function(){xl.De=Sf,xl.Be=Vf(qf(kl.Bwb,1),it,6,15,[-1,-1,-1,0,0,1,2,3,4,5,-1,0,0,0,6,7,8,9,-1,0,0,10,10,10,10,10,10,10,10,10,10,1,11,11,12,13,-1,0,0,10,10,10,10,10,10,10,10,10,10,0,0,0,11,14,-1,0,0,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,10,10,10,10,10,10,10,10,1,1,1,1,-1,-1,-1,-1,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]),xl.Ce=Vf(qf(kl.Bwb,1),it,6,15,[-1,-1,-1,0,0,0,2,5,5,5,-1,0,0,0,0,9,9,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])},xl.Ee=function(n,t,e){var i,s,a,r,o,l,f,g,u,d,c,h,b;for(xl.De(),xl.nu(n,7),c=vf(kl.mlb,st,6,n.j[t],14,1),d=0,l=0;l<n.j[t];l++)if(s=n.i[t][l],1!=n.C[s]){if(r=0,0!=(32&e)&&(a=Mg(n.n[t][l]),32190==e?Tg(a,3)<0&&xl.Mo(n,n.k[t][l])&&1==n.o[t]&&(a=0):Tg(a,3)<0&&xl.Io(n,n.k[t][l])&&(a=0),r=Eg(r,xg(a,4))),0!=(128&e)){if(-1==xl.Be[n.C[s]])throw og(new Jl.aA(at+n.C[s]));r=Ag(r,Mg(xl.Be[n.C[s]]))}else if(0!=(64&e)){if(-1==xl.Ce[n.C[s]])throw og(new Jl.aA(at+n.C[s]));r=Ag(r,Mg(xl.Ce[n.C[s]]))}for(0!=(256&e)&&((h=n.j[s]-1)>3&&(h=3),0==(512&e)&&h>1&&(h=1),r=Eg(r,kl.Rwb(h<<6))),0!=(e&hn)&&0!=(8&n.u[s])&&(r=Eg(r,256)),0!=(e&zn)&&s<n.f&&xl.Ur(n.p,s)&&(r=Eg(r,512)),0!=(e&ln)&&0!=(n.u[s]&Xn)&&(r=Eg(r,hn)),g=0;Tg(r,c[g])<0;)++g;for(u=l;u>g;u--)c[u]=c[u-1];c[g]=r,++d}for(d>4&&(d=4),i=0,f=0;f<d;f++)i=Eg(i=xg(i,11),c[f]);if(i=xg(i,15),-1==xl.Be[n.C[t]])throw og(new Jl.aA(at+n.C[t]));if(i=Eg(i,Mg(xl.Be[n.C[t]])),0!=(2&e)?((b=n.p&&t<n.f?xl.Jr(n.p,t):0)>9&&(b=9),b>2&&(b-=2),i=Eg(i,kl.Rwb(b<<4))):0!=(1&e)&&0!=(8&n.u[t])&&(i=Eg(i,64)),0!=(4&e)&&t<n.f&&xl.Ur(n.p,t)&&(i=Eg(i,hn)),0!=(8&e)&&0!=(n.u[t]&fn)&&(i=Eg(i,zn)),0!=(16&e)&&0!=(n.u[t]&Xn)&&(i=Eg(i,fn)),0!=(e&fn)&&(xl.ve(n,t)&&(i=Eg(i,Xn)),xl.ye(n,t)))for(o=0;o<n.f;o++)if(xl.we(n,o)){i=Eg(i,ln);break}return 0!=(e&Xn)&&(i=Eg(i,xg(Mg(xl.Ln(n,t,10)),7))),i},xl.Fe=function(n,t,e,i,s,a){var r,o,l,f;for(l=0,o=0;o<n.P.f;o++)Bg(Cg(xl.Lk(n.P,n.w[o]),i),0)&&++l;if(0!=l)for(xl.Df(n,t),xl.yf(n,kl.Rwb(l),e),r=0;r<n.P.f;r++)0!=Tg(f=Cg(xl.Lk(n.P,n.w[r]),i),0)&&(xl.yf(n,kl.Rwb(r),e),1!=s&&xl.yf(n,Fg(f,a),s))},xl.Ge=function(n,t,e,i,s,a){var r,o,l,f;for(l=0,o=0;o<n.P.g;o++)0!=(xl.dl(n.P,n.A[o])&i)&&++l;if(0!=l)for(xl.Df(n,t),xl.yf(n,kl.Rwb(l),e),r=0;r<n.P.g;r++)0!=(f=xl.dl(n.P,n.A[r])&i)&&(xl.yf(n,kl.Rwb(r),e),1!=s&&xl.yf(n,kl.Rwb(f>>a),s))},xl.He=function(n){for(var t,e,i,s,a,r;;){for(a=vf(kl.Cwb,nn,6,n.S+1,16,1),i=-1,e=0;e<n.P.f;e++)0!=xl.go(n.P,e)&&(a[n.d[e]]&&i<n.d[e]&&(i=n.d[e]),a[n.d[e]]=!0);if(-1==i)break;for(s=0,t=0;t<n.P.f;t++)r=0,n.d[t]==i&&(r=++s),xl.zg(n.c[t],t),xl.wg(n.c[t],n.b,Mg(n.d[t])),xl.wg(n.c[t],8,kl.Rwb(r));n.S=xl.gf(n)}},xl.Ie=function(n){var t,e,i,s;for(e=0;e<n.P.f;e++)xl.zg(n.c[e],e),xl.wg(n.c[e],2*n.b+4,xg(Mg(n.d[e]),n.b+4));for(s=!1,t=0;t<n.P.f;t++)s|=xl.Ve(n,t,3);for(i=0;i<n.P.g;i++)s|=xl.Qe(n,i,3);if(!s)return!1;for(;n.S<n.P.f&&(s=xl.df(n));)xl.ff(n),n.N&&xl.Pg(n.N,n.d);return!0},xl.Je=function(n){var t,e,i,s,a;for(e=0;e<n.P.f;e++)xl.zg(n.c[e],e),xl.wg(n.c[e],n.b+1,Mg(2*n.d[e]));for(a=vf(kl.llb,z,6,n.S+1,15,1),i=0;i<n.P.f;i++)++a[n.d[i]];for(s=1;1==a[s];)++s;for(t=0;t<n.P.f;t++)if(n.d[t]==s){xl.xg(n.c[t],1);break}n.S=xl.gf(n)},xl.Ke=function(n,t,e){var i,s,a,r,o;return(6==xl.Qk(n.P,t)||7==xl.Qk(n.P,t))&&(s=xl.Rn(n.P,t,0),a=xl.Rn(n.P,t,1),1==xl.In(n.P,s)&&1==xl.In(n.P,a)&&(1!=xl.Sn(n.P,s)&&1!=xl.Sn(n.P,a)&&(!(xl.Dn(n.P,s)>3||xl.Dn(n.P,a)>3)&&((!(r=new xl.Kj(n.P,n.d,t,s)).f||1!=e)&&((!(o=new xl.Kj(n.P,n.d,t,a)).f||1!=e)&&((!r.f||!o.f)&&(3==e&&(r.f&&r.c&&(n.U[t]=!0),o.f&&o.c&&(n.U[t]=!0)),i=n.hb?xl.Me(n,r,o):xl.Le(r,o),1==e?n.bb[t]=i:2==e&&(r.f&&(1==i?xl.xg(n.c[r.b],Mg(n.d[s])):xl.xg(n.c[r.d],Mg(n.d[s]))),o.f&&(2==i?xl.xg(n.c[o.b],Mg(n.d[a])):xl.xg(n.c[o.d],Mg(n.d[a])))),!0)))))))},xl.Le=function(n,t){var e,i,s;if(i=xl.Jj(n),s=xl.Jj(t),-1==i||-1==s||0==(i+s&1))return 3;switch(e=0,i+s){case 3:case 7:e=2;break;case 5:e=1}return e},xl.Me=function(t,e,i){var s,a;return(s=vf(kl.llb,z,6,4,15,1))[0]=e.b,s[1]=e.a,s[2]=i.a,s[3]=i.b,a=xl.dk(t.P,s),n.Math.abs(a)<.3||n.Math.abs(a)>rt?3:a<0?2:1},xl.Ne=function(n,t,e){var i,s,a,r,o;return!!xl.Jo(n.P,t)&&(i=xl.Vk(n.P,0,t),s=xl.Vk(n.P,1,t),(!(r=new xl.Kj(n.P,n.d,i,s)).f||1!=e)&&((!(o=new xl.Kj(n.P,n.d,s,i)).f||1!=e)&&((!r.f||!o.f)&&(3==e&&(r.f&&(n.T[t]=xl.Tf(n,s)),o.f&&(n.T[t]=xl.Tf(n,i))),a=n.hb?xl.Pe(n,r,o):xl.Oe(r,o),1==e?n.k[t]=a:2==e&&(r.f&&(2==a?xl.xg(n.c[r.b],Mg(n.d[s])):xl.xg(n.c[r.d],Mg(n.d[s]))),o.f&&(2==a?xl.xg(n.c[o.b],Mg(n.d[i])):xl.xg(n.c[o.d],Mg(n.d[i])))),!0))))},xl.Oe=function(n,t){var e,i,s;if(i=xl.Jj(n),s=xl.Jj(t),-1==i||-1==s||0==(i+s&1))return 3;switch(e=0,i+s){case 3:case 7:e=1;break;case 5:e=2}return e},xl.Pe=function(t,e,i){var s,a;return(s=vf(kl.llb,z,6,4,15,1))[0]=e.b,s[1]=e.a,s[2]=i.a,s[3]=i.b,a=xl.dk(t.P,s),n.Math.abs(a)<.3||n.Math.abs(a)>rt?3:a<0?1:2},xl.Qe=function(n,t,e){var i,s,a,r,o;return 0==n.k[t]&&(1==xl.bl(n.P,t)?xl.Ne(n,t,e):2==xl.bl(n.P,t)&&(!xl.Io(n.P,t)&&(s=xl.Vk(n.P,0,t),a=xl.Vk(n.P,1,t),1!=xl.Sn(n.P,s)&&1!=xl.Sn(n.P,a)&&(!(xl.Sn(n.P,s)>3||xl.Sn(n.P,a)>3)&&(2!=xl.In(n.P,s)&&2!=xl.In(n.P,a)&&((!(r=new xl.Kj(n.P,n.d,a,s)).f||1!=e)&&((!(o=new xl.Kj(n.P,n.d,s,a)).f||1!=e)&&((!r.f||!o.f)&&(3==e&&(r.f&&r.c&&(n.T[t]=!0),o.f&&o.c&&(n.T[t]=!0)),i=xl.Bl(n.P,t)?3:n.hb?xl.Se(n,r,o):xl.Re(r,o),1==e?n.k[t]=i:2==e&&(r.f&&(1==i?xl.xg(n.c[r.b],Mg(n.d[s])):2==i&&xl.xg(n.c[r.d],Mg(n.d[s]))),o.f&&(1==i?xl.xg(n.c[o.b],Mg(n.d[a])):2==i&&xl.xg(n.c[o.d],Mg(n.d[a])))),!0)))))))))},xl.Re=function(n,t){return-1==xl.Jj(n)||-1==xl.Jj(t)||0!=(1&(xl.Jj(n)|xl.Jj(t)))?3:xl.Jj(n)==xl.Jj(t)?1:2},xl.Se=function(t,e,i){var s,a,r,o,l;return(s=vf(kl.jlb,S,6,3,15,1))[0]=xl.Nk(t.P,i.a)-xl.Nk(t.P,e.a),s[1]=xl.Ok(t.P,i.a)-xl.Ok(t.P,e.a),s[2]=xl.Pk(t.P,i.a)-xl.Pk(t.P,e.a),(o=vf(kl.jlb,S,6,3,15,1))[0]=xl.Nk(t.P,e.b)-xl.Nk(t.P,e.a),o[1]=xl.Ok(t.P,e.b)-xl.Ok(t.P,e.a),o[2]=xl.Pk(t.P,e.b)-xl.Pk(t.P,e.a),(l=vf(kl.jlb,S,6,3,15,1))[0]=xl.Nk(t.P,i.b)-xl.Nk(t.P,i.a),l[1]=xl.Ok(t.P,i.b)-xl.Ok(t.P,i.a),l[2]=xl.Pk(t.P,i.b)-xl.Pk(t.P,i.a),(a=vf(kl.jlb,S,6,3,15,1))[0]=s[1]*o[2]-s[2]*o[1],a[1]=s[2]*o[0]-s[0]*o[2],a[2]=s[0]*o[1]-s[1]*o[0],(r=vf(kl.jlb,S,6,3,15,1))[0]=s[1]*a[2]-s[2]*a[1],r[1]=s[2]*a[0]-s[0]*a[2],r[2]=s[0]*a[1]-s[1]*a[0],(o[0]*r[0]+o[1]*r[1]+o[2]*r[2])/(n.Math.sqrt(o[0]*o[0]+o[1]*o[1]+o[2]*o[2])*n.Math.sqrt(r[0]*r[0]+r[1]*r[1]+r[2]*r[2]))<0^(l[0]*r[0]+l[1]*r[1]+l[2]*r[2])/(n.Math.sqrt(l[0]*l[0]+l[1]*l[1]+l[2]*l[2])*n.Math.sqrt(r[0]*r[0]+r[1]*r[1]+r[2]*r[2]))<0?1:2},xl.Te=function(n,t){var e,i,s,a;return e=xl.xk(n.P,t),a=-1,(i=xl.eo(n.P,t,!1))!=(s=xl.eo(n.P,t,!0))?a=-1!=e&&e>i?e<<24>>24:i<<24>>24:-1!=e?(e>s||e<s&&e>=xl.ko(n.P,t))&&(a=e<<24>>24):xl.lp(n.P,t)||0==xl.Wn(n.P,t)||(a=xl.ko(n.P,t),a-=xl.il(n.P,t,a)),xl.of(n,t,a),a},xl.Ue=function(n){var t,e,i,s,a,r,o,l,f,g,u;for(i=vf(kl.llb,z,6,n.M,15,1),t=0;t<n.P.f;t++){for(g=xl.Sn(n.P,t)+xl.ho(n.P,t),f=0,a=0;a<xl.En(n.P,t);a++)if(a<xl.Sn(n.P,t)||a>=xl.Dn(n.P,t)){for(u=2*n.d[xl.Rn(n.P,t,a)],e=xl.Tn(n.P,t,a),2==xl.bl(n.P,e)&&(xl.Io(n.P,e)||++u),o=0;o<f&&!(u<i[o]);o++);for(l=f;l>o;l--)i[l]=i[l-1];i[o]=u,++f}for(xl.zg(n.c[t],t),xl.wg(n.c[t],n.b,Mg(n.d[t])),r=g;r<n.M;r++)xl.wg(n.c[t],n.b+1,0);for(s=0;s<g;s++)xl.wg(n.c[t],n.b+1,kl.Rwb(i[s]))}},xl.Ve=function(n,t,e){var i,s,a,r,o,l,f,g,u,d,c,h;if(0!=n.bb[t])return!1;if(5!=xl.Qk(n.P,t)&&6!=xl.Qk(n.P,t)&&7!=xl.Qk(n.P,t)&&14!=xl.Qk(n.P,t)&&15!=xl.Qk(n.P,t)&&16!=xl.Qk(n.P,t))return!1;if(0!=xl.In(n.P,t)){if(xl.Ko(n.P,t))return xl.Ke(n,t,e);if(15!=xl.Qk(n.P,t)&&16!=xl.Qk(n.P,t))return!1}if(xl.Sn(n.P,t)<3||xl.Dn(n.P,t)>4)return!1;if(xl.zk(n.P,t)>0&&6==xl.Qk(n.P,t))return!1;if(5==xl.Qk(n.P,t)&&4!=xl.Dn(n.P,t))return!1;if(7==xl.Qk(n.P,t)&&!n.Q[t])return!1;for(c=vf(kl.llb,z,6,4,15,1),h=vf(kl.llb,z,6,4,15,1),f=vf(kl.Cwb,nn,6,4,16,1),o=0;o<xl.Dn(n.P,t);o++){for(a=-1,s=0,l=0;l<xl.Dn(n.P,t);l++)f[l]||a<n.d[xl.Rn(n.P,t,l)]&&(a=n.d[xl.Rn(n.P,t,l)],s=l);c[o]=s,h[o]=a,f[s]=!0}if(4==xl.Dn(n.P,t)&&h[0]==h[1]&&h[2]==h[3])return!1;if(4==xl.Dn(n.P,t)&&(h[0]==h[2]||h[1]==h[3]))return!1;if(3==xl.Dn(n.P,t)&&h[0]==h[2])return!1;for(g=0,u=0,d=!1,r=1;r<xl.Dn(n.P,t);r++)if(h[r-1]==h[r]){if(1==e||0==h[r])return!1;g=xl.Rn(n.P,t,c[r-1]),u=xl.Rn(n.P,t,c[r]),3==e&&xl.Vo(n.P,xl.Tn(n.P,t,c[r]))&&(n.U[t]=!0),d=!0}return!(1!=e&&!d)&&(i=n.hb?xl.Xe(n,t,c):xl.We(n,t,c),1==e?n.bb[t]=i:2==e&&(1==i?xl.xg(n.c[g],Mg(n.d[t])):2==i&&xl.xg(n.c[u],Mg(n.d[t]))),!0)},xl.We=function(n,t,e){var i,s,a,r,o,l,f,g,u,d;for(d=Vf(qf(kl.llb,2),ot,8,0,[Vf(qf(kl.llb,1),z,6,15,[2,1,2,1]),Vf(qf(kl.llb,1),z,6,15,[1,2,2,1]),Vf(qf(kl.llb,1),z,6,15,[1,1,2,2]),Vf(qf(kl.llb,1),z,6,15,[2,1,1,2]),Vf(qf(kl.llb,1),z,6,15,[2,2,1,1]),Vf(qf(kl.llb,1),z,6,15,[1,2,1,2])]),i=vf(kl.jlb,S,6,xl.Dn(n.P,t),15,1),r=0;r<xl.Dn(n.P,t);r++)i[r]=xl.Uk(n.P,xl.Rn(n.P,t,e[r]),t);if(3!=(f=xl.Yn(n.P,t,e,i,null)<<24>>24))return f;for(g=0,u=0,o=0;o<xl.Dn(n.P,t);o++)s=xl.Tn(n.P,t,e[o]),xl.Vk(n.P,0,s)==t&&(129==xl.el(n.P,s)&&(0!=u&&xl.Om(n.P,t),g=o,u=1),257==xl.el(n.P,s)&&(0!=u&&xl.Om(n.P,t),g=o,u=2));if(0==u)return 3;for(a=1;a<xl.Dn(n.P,t);a++)i[a]<i[0]&&(i[a]+=an);if(3==xl.Dn(n.P,t)){switch(g){case 0:(i[1]<i[2]&&i[2]-i[1]<rn||i[1]>i[2]&&i[1]-i[2]>rn)&&(u=3-u);break;case 1:i[2]-i[0]>rn&&(u=3-u);break;case 2:i[1]-i[0]<rn&&(u=3-u)}return 1==u?2:1}return l=0,i[1]<=i[2]&&i[2]<=i[3]?l=0:i[1]<=i[3]&&i[3]<=i[2]?l=1:i[2]<=i[1]&&i[1]<=i[3]?l=2:i[2]<=i[3]&&i[3]<=i[1]?l=3:i[3]<=i[1]&&i[1]<=i[2]?l=4:i[3]<=i[2]&&i[2]<=i[1]&&(l=5),d[l][g]==u?2:1},xl.Xe=function(t,e,i){var s,a,r,o,l;for(s=vf(kl.llb,z,6,4,15,1),o=0;o<xl.Dn(t.P,e);o++)s[o]=xl.Rn(t.P,e,i[o]);for(3==xl.Dn(t.P,e)&&(s[3]=e),a=Yf(kl.jlb,[j,S],[13,6],15,[3,3],2),r=0;r<3;r++)a[r][0]=xl.Nk(t.P,s[r+1])-xl.Nk(t.P,s[0]),a[r][1]=xl.Ok(t.P,s[r+1])-xl.Ok(t.P,s[0]),a[r][2]=xl.Pk(t.P,s[r+1])-xl.Pk(t.P,s[0]);return(l=vf(kl.jlb,S,6,3,15,1))[0]=a[0][1]*a[1][2]-a[0][2]*a[1][1],l[1]=a[0][2]*a[1][0]-a[0][0]*a[1][2],l[2]=a[0][0]*a[1][1]-a[0][1]*a[1][0],(a[2][0]*l[0]+a[2][1]*l[1]+a[2][2]*l[2])/(n.Math.sqrt(a[2][0]*a[2][0]+a[2][1]*a[2][1]+a[2][2]*a[2][2])*n.Math.sqrt(l[0]*l[0]+l[1]*l[1]+l[2]*l[2]))>0?1:2},xl.Ye=function(n){var t,e;for(t=0,Fl.POb(n.c),e=0;e<n.c.length;e++)(0==e||0!=xl.yg(n.c[e],n.c[e-1]))&&++t,n.d[n.c[e].a]=t;return t},xl.Ze=function(n){var t,e,i,s,a,r,o,l,f,g,u,d;if(!n.v)for(n.v=new Fl.kj,g=0,u=vf(kl.llb,z,6,n.P.f,15,1),r=vf(kl.llb,z,6,n.P.f,15,1),l=vf(kl.llb,z,6,n.P.g,15,1),t=0;t<n.P.f;t++)if(0==u[t]&&(xl.Uo(n.P,t)||1==xl.In(n.P,t))){for(r[0]=t,o=1,f=0,u[t]=++g,e=vf(kl.Cwb,nn,6,n.P.g,16,1),a=0;a<o;a++)for(d=0;d<xl.Sn(n.P,r[a]);d++)s=xl.Tn(n.P,r[a],d),(xl.Vo(n.P,s)||2==xl.bl(n.P,s)||xl.Jo(n.P,s))&&(i=xl.Rn(n.P,r[a],d),e[s]||(l[f++]=s,e[s]=!0),0==u[i]&&(r[o++]=i,u[i]=g));Fl.Si(n.v,new xl.Fg(r,o,l,f))}},xl.$e=function(n){var t;for(n.Q=vf(kl.Cwb,nn,6,n.P.f,16,1),t=0;t<n.P.f;t++)if(7==xl.Qk(n.P,t)){if(4==xl.Sn(n.P,t)){n.Q[t]=!0;continue}if(3==xl.Sn(n.P,t)){if(3==xl.Mn(n.P,t)){n.Q[t]=!0;continue}if(1==xl.zk(n.P,t)){n.Q[t]=!0;continue}if(xl.Oo(n.P,t,!0))continue;if(0!=(32&n.O)){n.Q[t]=!0;continue}if(xl.To(n.P,t)){n.Q[t]=!0;continue}}}},xl._e=function(n,t){var e,i,s,a;for(s=!1,i=0;i<n.P.g;i++)xl.Qe(n,i,1)&&(n.o[i]=n.J,t&&xl.pf(n,i),s=!0);for(a=!1,e=0;e<n.P.f;e++)xl.Ve(n,e,1)&&(n.gb[e]=n.J,t&&xl.qf(n,e),a=!0);return a&&(n.J=!n.J),s||a},xl.af=function(n){var t,e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I;for(j=vf(kl.Cwb,nn,6,n.P.f,16,1),m=vf(kl.Cwb,nn,6,n.P.g,16,1),t=0,C=!1,0!=(128&n.O)&&(n.W=vf(kl.llb,z,6,n.P.f,15,1),n.V=vf(kl.llb,z,6,n.P.g,15,1)),i=0;i<n.P.f;i++)n.U[i]&&(n.db[i]||xl.Ve(n,i,1)&&(n.db[i]=!0,j[i]=!0,++t));for(a=0;a<n.P.g;a++)n.T[a]&&(n.n[a]||xl.Qe(n,a,1)&&(n.n[a]=!0,m[a]=!0,++t));if(1==t){for(e=0;e<n.P.f;e++)if(j[e]){n.bb[e]=0;break}for(s=0;s<n.P.g;s++)if(m[s]){n.k[s]=0;break}}else if(t>1)for(xl.Ze(n),n.R=0,o=new Fl.rOb(n.v);o.a<o.c.a.length;){for(r=Fl.qOb(o),A=0,T=0,g=0,f=0,u=-1,l=-1,h=0;h<r.a.length;h++)j[r.a[h]]&&(++A,1!=n.bb[r.a[h]]&&2!=n.bb[r.a[h]]||(++T,C=!0,u<n.d[r.a[h]]&&(u=n.d[r.a[h]],g=r.a[h])));for(b=0;b<r.b.length;b++)m[r.b[b]]&&(++A,d=(p=n.d[xl.Vk(n.P,0,r.b[b])])>(I=n.d[xl.Vk(n.P,1,r.b[b])])?(p<<16)+I:(I<<16)+p,1!=n.k[r.b[b]]&&2!=n.k[r.b[b]]||(++T,C=!0,l<d&&(l=d,f=r.b[b])));if(0!=A)if(1==A){for(D=0;D<r.a.length;D++)j[r.a[D]]&&(n.bb[r.a[D]]=0);for(c=0;c<r.b.length;c++)m[r.b[c]]&&(n.k[r.b[c]]=0)}else if(1==T){for(D=0;D<r.a.length;D++)j[r.a[D]]&&(n.bb[r.a[D]]=3);for(c=0;c<r.b.length;c++)m[r.b[c]]&&(n.k[r.b[c]]=3)}else{if(0!=(128&n.O)){for(++n.R,D=0;D<r.a.length;D++)j[r.a[D]]&&(n.W[r.a[D]]=n.R);for(c=0;c<r.b.length;c++)m[r.b[c]]&&(n.V[r.b[c]]=n.R)}if(H=!1,-1!=u?2==n.bb[g]&&(H=!0):2==n.k[f]&&(H=!0),H){for(D=0;D<r.a.length;D++)if(j[r.a[D]])switch(n.bb[r.a[D]]){case 1:n.bb[r.a[D]]=2;break;case 2:n.bb[r.a[D]]=1}for(c=0;c<r.b.length;c++)if(m[r.b[c]])switch(n.k[r.b[c]]){case 1:n.k[r.b[c]]=2;break;case 2:n.k[r.b[c]]=1}}}}return C},xl.bf=function(n,t){var e,i,s,a,r,o,l,f,g,u,d;for(a=Yf(kl.llb,[ot,z],[8,6],15,[2,32],2),r=0;r<2;r++){for(e=vf(kl.llb,ot,8,32,0,2),d=0,s=0;s<32;s++)if(null!=t[r][s]){for(g=t[r][s].length,e[s]=vf(kl.llb,z,6,g,15,1),o=0;o<g;o++)e[s][o]=n.d[t[r][s][o]];Rl.fTb(e[s],Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[]))),++d}for(u=d;u>0;u--){for(f=0,l=null,i=0;i<32;i++)if(null!=e[i])if(null==l||l.length<e[i].length)l=e[i],f=i;else if(l.length==e[i].length)for(o=l.length-1;o>=0;o--)if(l[o]<e[i][o]){l=e[i],f=i;break}a[r][f]=u,e[f]=null}}return a},xl.cf=function(t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A;if(d=!1,t.P.K)for(g=0;g<t.P.g;g++)if(0!=xl.dl(t.P,g)){d=!0;break}for(t.M=2,i=0;i<t.P.f;i++)t.M=n.Math.max(t.M,xl.Sn(t.P,i)+xl.ho(t.P,i));for(f=n.Math.max(2,d?(62+t.b+t.M*(t.b+23))/63|0:(62+t.b+t.M*(t.b+5))/63|0),t.d=vf(kl.llb,z,6,t.P.q,15,1),t.c=vf(kl.xlb,lt,160,t.P.f,0,1),s=0;s<t.P.f;s++)t.c[s]=new xl.Ag(f);for(l=!1,a=0;a<t.P.f;a++)xl.zg(t.c[a],a),Bg(Cg(xl.Lk(t.P,a),1),0)||null!=xl.Gk(t.P,a)?xl.wg(t.c[a],8,6):xl.wg(t.c[a],8,Mg(xl.Qk(t.P,a))),xl.wg(t.c[a],8,Mg(xl.Jk(t.P,a))),xl.wg(t.c[a],2,Mg(xl.In(t.P,a))),xl.wg(t.c[a],4,Mg(xl.Sn(t.P,a)+xl.ho(t.P,a))),Bg(Cg(xl.Lk(t.P,a),1),0)?xl.wg(t.c[a],4,8):xl.wg(t.c[a],4,Mg(8+xl.zk(t.P,a))),xl.wg(t.c[a],5,Mg(n.Math.min(31,xl.Mn(t.P,a)))),xl.wg(t.c[a],4,Mg(xl.Te(t,a)+1)),xl.wg(t.c[a],2,Mg(xl.Mk(t.P,a)>>4)),t.P.K&&(xl.wg(t.c[a],46,xl.Lk(t.P,a)),null!=xl.Gk(t.P,a)&&(l=!0));if(t.S=xl.gf(t),t.S<t.P.f){for(e=0;e<t.P.f;e++){for(xl.zg(t.c[e],e),xl.wg(t.c[e],t.b,Mg(t.d[e])),c=vf(kl.llb,z,6,xl.Sn(t.P,e),15,1),b=0;b<xl.Sn(t.P,e);b++)c[b]=t.d[xl.Rn(t.P,e,b)]<<5,c[b]|=n.Math.min(31,xl.Qn(t.P,xl.Tn(t.P,e,b)));for(Rl.fTb(c,Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[]))),D=t.M;D>c.length;D--)xl.wg(t.c[e],t.b+5,0);for(h=c.length-1;h>=0;h--)xl.wg(t.c[e],t.b+5,kl.Rwb(c[h]))}t.S=xl.gf(t)}if(l&&t.S<t.P.f){for(e=0;e<t.P.f;e++){for(xl.zg(t.c[e],e),xl.wg(t.c[e],t.b,Mg(t.d[e])),m=null==(o=xl.Gk(t.P,e))?0:n.Math.min(12,o.length),b=12;b>m;b--)xl.wg(t.c[e],8,0);for(h=m-1;h>=0;h--)xl.wg(t.c[e],8,kl.Rwb(o[h]))}t.S=xl.gf(t)}if(d&&t.S<t.P.f){for(e=0;e<t.P.f;e++){for(xl.zg(t.c[e],e),xl.wg(t.c[e],t.b,Mg(t.d[e])),u=vf(kl.mlb,st,6,xl.Sn(t.P,e)+xl.ho(t.P,e),14,1),H=0,b=0;b<xl.En(t.P,e);b++)(b<xl.Sn(t.P,e)||b>=xl.Dn(t.P,e))&&(u[H]=Mg(t.d[xl.Rn(t.P,e,b)]),u[H]=xg(u[H],23),u[H]=Eg(u[H],Mg(xl.dl(t.P,xl.Tn(t.P,e,b)))),++H);for(Rl.fTb(u,Rl.LTb(Qf(Fl.WOb.prototype.$d,Fl.WOb,[]))),D=t.M;D>u.length;D--)xl.wg(t.c[e],t.b+23,0);for(h=u.length-1;h>=0;h--)xl.wg(t.c[e],t.b+23,u[h])}t.S=xl.gf(t)}if(0!=(8&t.O)&&t.S<t.P.f){for(j=new xl.ku,r=0;r<t.P.f;r++)null!=xl.Bk(t.P,r)&&xl.iu(j,xl.Bk(t.P,r));for(e=0;e<t.P.f;e++)A=null==xl.Bk(t.P,e)?0:1+xl.ju(j,xl.Bk(t.P,e)),xl.zg(t.c[e],e),xl.wg(t.c[e],t.b,Mg(t.d[e])),xl.wg(t.c[e],t.b,kl.Rwb(A));t.S=xl.gf(t)}if(0!=(16&t.O)&&t.S<t.P.f){for(e=0;e<t.P.f;e++)xl.zg(t.c[e],e),xl.wg(t.c[e],t.b,Mg(t.d[e])),xl.wg(t.c[e],1,Mg(xl.Jl(t.P,e)?1:0));t.S=xl.gf(t)}0!=(512&t.O)&&t.P.K&&xl.He(t)},xl.df=function(n){var t,e,i,s,a,r,o,l,f;for(e=0;e<n.P.f;e++)xl.zg(n.c[e],e),xl.wg(n.c[e],2*n.b+4,xg(Mg(n.d[e]),n.b+4));for(l=1;l<=n.S;l++){for(s=!1,i=0;i<n.P.f;i++)n.d[i]==l&&(s|=xl.Ve(n,i,2));if(s){if(o=n.S,n.S=xl.gf(n),n.S!=o)return!0;for(t=0;t<n.P.f;t++)xl.zg(n.c[t],t),xl.wg(n.c[t],2*n.b+4,xg(Mg(n.d[t]),n.b+4))}}for(f=vf(kl.ylb,lt,212,n.P.g,0,1),r=0;r<f.length;r++)f[r]=new xl.Dg(n.d[xl.Vk(n.P,0,r)],n.d[xl.Vk(n.P,1,r)],r);for(Fl.NOb(f,0,f.length,null),a=0;a<f.length;a++)if(xl.Qe(n,f[a].a,2)){for(;a+1<f.length&&0==xl.Cg(f[a],f[a+1]);)xl.Qe(n,f[++a].a,2);if(o=n.S,n.S=xl.gf(n),n.S!=o)return!0;for(t=0;t<n.P.f;t++)xl.zg(n.c[t],t),xl.wg(n.c[t],2*n.b+4,xg(Mg(n.d[t]),n.b+4))}return!1},xl.ef=function(n){var t,e,i,s,a,r,o,l,f,g;for(a=0,e=0;e<n.P.f;e++)0!=n._[e]&&(2!=n._[e]||0==(256&n.O))&&++a;if(0!=a){for(g=vf(kl.llb,z,6,a,15,1),a=0,i=0;i<n.P.f;i++)0==n._[i]||2==n._[i]&&0!=(256&n.O)||(g[a]=n._[i]<<29|n.$[i]<<24|n.d[i]<<12|i,++a);for(Rl.fTb(g,Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[]))),r=0,f=0,o=g[0]&_n;;)if(++f==g.length||o!=(g[f]&_n)){for(s=vf(kl.llb,z,6,f-r,15,1),l=r;l<f;l++)t=4095&g[l],s[l-r]=t,n.eb[t]=!0;if(Fl.Si(n.fb,s),f==g.length)break;o=g[f]&_n,r=f}}},xl.ff=function(n){var t,e,i,s,a,r,o,l,f,g,u,d,c;for(o=!1,l=0;l<n.fb.a.length;l++){for(r=Fl.Xi(n.fb,l),t=!0,c=-1,f=!1,u=0;u<r.length;u++){if(e=r[u],0==n.bb[e]){t=!1;break}if(3!=n.bb[e]){for(g=!0,d=0;d<r.length;d++)if(d!=u&&n.d[e]==n.d[r[d]]){g=!1;break}g&&c<n.d[e]&&(c=n.d[e],f=1==n.bb[e])}}if(t&&-1!=c){for(s=0,a=(i=r).length;s<a;++s)e=i[s],(1==n.bb[e]||2==n.bb[e])&&(n.cb[e]=f),n.eb[e]=!1;Fl.dj(n.fb,r),o=!0,--l}}return o},xl.gf=function(n){var t,e;t=xl.Ye(n);do{e=t,xl.Ue(n),t=xl.Ye(n)}while(e!=t);return t},xl.hf=function(n){for(0!=(1&n.O)&&0==(2&n.O)&&(n.e=Fl.xOb(n.d,n.P.f)),0==(n.O&zn)&&(n.U=vf(kl.Cwb,nn,6,n.P.f,16,1),n.T=vf(kl.Cwb,nn,6,n.P.g,16,1),n.S<n.P.f&&(xl.Ie(n),0==(n.O&zn)&&(xl.ff(n),n.N&&xl.Pg(n.N,n.d)))),null==n.e&&0!=(1&n.O)&&0!=(2&n.O)&&(n.e=Fl.xOb(n.d,n.P.f));n.S<n.P.f;)xl.Je(n),0==(n.O&zn)&&(xl.ff(n),n.N&&xl.Pg(n.N,n.d));0==(n.O&zn)&&(xl.ff(n),xl.af(n),xl.Gf(n))},xl.jf=function(n){var t,e,i,s,a;for(a=n.S,s=Fl.xOb(n.d,n.P.f),n.P.K||(xl.lf(n),xl.Yf(n,a,s)),n._=vf(kl.hlb,ft,6,n.P.f,15,1),n.$=vf(kl.hlb,ft,6,n.P.f,15,1),e=0;e<n.P.f;e++)n._[e]=xl.Ek(n.P,e)<<24>>24,n.$[e]=xl.Dk(n.P,e)<<24>>24;for(n.j=vf(kl.hlb,ft,6,n.P.g,15,1),n.i=vf(kl.hlb,ft,6,n.P.g,15,1),i=0;i<n.P.g;i++)n.j[i]=xl.$k(n.P,i)<<24>>24,n.i[i]=xl.Zk(n.P,i)<<24>>24;for(xl.kf(n),n.X=!1,n.K=vf(kl.Cwb,nn,6,n.P.f,16,1),t=0;t<n.P.f;t++)0!=n.bb[t]&&(n.K[t]=!0,n.X=!0);xl.nf(n),n.N=null,n.ab=vf(kl.Cwb,nn,6,n.P.f,16,1),n.X&&(n.N=new xl.Vg(n.P,s,n.K,n.bb,n.k,n._,n.$,n.gb,n.o,n.ab),xl.Qg(n.N)),n.cb=vf(kl.Cwb,nn,6,n.P.f,16,1),n.eb=vf(kl.Cwb,nn,6,n.P.f,16,1),n.fb=new Fl.kj,n.N&&xl.Pg(n.N,n.d),xl.ef(n),xl.Yf(n,a,s),xl.mf(n),n.N&&(n.I=xl.Mg(n.N)),xl.xf(n)},xl.kf=function(n){var t,e,i,s,a,r;for(n.J=!0,a=xl._e(n,!1);n.S<n.P.f&&a;){for(t=0;t<n.P.f;t++)xl.zg(n.c[t],t),xl.wg(n.c[t],n.b,Mg(n.d[t])),r=n.bb[t]<<7,1!=n.bb[t]&&2!=n.bb[t]||0==n._[t]||(r|=n._[t]<<5,r|=n.$[t]),xl.wg(n.c[t],18,kl.Rwb(r<<9));for(e=0;e<n.P.g;e++)i=n.k[e]<<7,1!=n.k[e]&&2!=n.k[e]||1!=xl.el(n.P,e)||0==n.j[e]||(i|=n.j[e]<<5,i|=n.i[e]),xl.xg(n.c[xl.Vk(n.P,0,e)],kl.Rwb(i)),xl.xg(n.c[xl.Vk(n.P,1,e)],kl.Rwb(i));if(s=xl.gf(n),n.S==s)break;n.S=s,a=xl._e(n,!1)}},xl.lf=function(n){var t,e,i,s;for(n.J=!0,n.Y=vf(kl.hlb,ft,6,n.P.f,15,1),n.f=vf(kl.hlb,ft,6,n.P.g,15,1),s=xl._e(n,!0);n.S<n.P.f&&s;){for(t=0;t<n.P.f;t++)xl.zg(n.c[t],t),xl.wg(n.c[t],n.b+4,Mg(n.d[t]<<4|n.bb[t]<<2));for(e=0;e<n.P.g;e++)xl.xg(n.c[xl.Vk(n.P,0,e)],Mg(n.k[e])),xl.xg(n.c[xl.Vk(n.P,1,e)],Mg(n.k[e]));if(i=xl.gf(n),n.S==i)break;n.S=i,s=xl._e(n,!0)}},xl.mf=function(n){var t,e,i,s,a,r,o;for(n.J=!0,i=xl.wf(n),n.N&&xl.Pg(n.N,n.d)&&(i=xl.wf(n)),xl._e(n,!1)&&xl.ff(n),r=!0;n.S<n.P.f&&r;){for(s=xl.bf(n,i),t=0;t<n.P.f;t++)xl.zg(n.c[t],t),xl.wg(n.c[t],n.b,Mg(n.d[t])),xl.wg(n.c[t],20,0),!n.ab[t]&&0!=n._[t]&&xl.xg(n.c[t],Mg((n._[t]<<18)+(s[1==n._[t]?0:1][n.$[t]]<<8))),o=n.bb[t],n.cb[t]&&(1==o?o=2:2==o&&(o=1)),xl.xg(n.c[t],kl.Rwb(o<<4));for(e=0;e<n.P.g;e++)xl.xg(n.c[xl.Vk(n.P,0,e)],Mg(n.k[e])),xl.xg(n.c[xl.Vk(n.P,1,e)],Mg(n.k[e]));if(a=xl.gf(n),n.S==a)break;n.S=a,r=!1,n.N&&xl.Pg(n.N,n.d)&&(r=!0,i=xl.wf(n)),xl._e(n,!1)&&(r=!0,xl.ff(n))}},xl.nf=function(n){var t,e;for(t=0;t<n.P.f;t++)(!n.K[t]||3==n.bb[t])&&(n._[t]=0);for(e=0;e<n.P.g;e++)(1!=xl.el(n.P,e)||0==n.k[e]||3==n.k[e])&&(n.j[e]=0)},xl.of=function(n,t,e){null==n.a&&(n.a=vf(kl.hlb,ft,6,n.P.f,15,1),Fl.AOb(n.a)),n.a[t]=e<<24>>24},xl.pf=function(n,t){var e,i,s,a,r,o;if((1==n.k[t]||2==n.k[t])&&!xl.Yo(n.P,t)){r=!1;try{for(a=0;a<2;a++)if(e=xl.Vk(n.P,a,t),3==xl.Sn(n.P,e)){for(i=vf(kl.llb,z,6,2,15,1),s=0,o=0;o<xl.Sn(n.P,e);o++)xl.Tn(n.P,e,o)!=t&&(i[s++]=xl.Rn(n.P,e,o));n.d[i[0]]>n.d[i[1]]^xl.rf(n,e,i[0],i[1])&&(r=!r)}}catch(e){if(_f(e=rg(e),19))return void(n.f[t]=3);throw og(e)}1==n.k[t]^r?n.f[t]=1:n.f[t]=2}},xl.qf=function(n,t){var e,i,s,a,r,o,l;if(1==n.bb[t]||2==n.bb[t]){if(o=!1,2==xl.In(n.P,t))try{for(r=0;r<2;r++)if(e=xl.Rn(n.P,t,r),3==xl.Sn(n.P,e)){for(s=vf(kl.llb,z,6,2,15,1),a=0,l=0;l<xl.Sn(n.P,e);l++)1==xl.Un(n.P,e,l)&&(s[a++]=xl.Rn(n.P,e,l));n.d[s[0]]>n.d[s[1]]^xl.rf(n,e,s[0],s[1])&&(o=!o)}}catch(e){if(_f(e=rg(e),19))return void(n.Y[t]=3);throw og(e)}else{try{i=xl.tf(n,t)}catch(e){if(_f(e=rg(e),19))return void(n.Y[t]=3);throw og(e)}for(r=1;r<i.length;r++)for(l=0;l<r;l++)n.d[i[r]]<n.d[i[l]]&&(o=!o)}1==n.bb[t]^o?n.Y[t]=1:n.Y[t]=2}},xl.rf=function(n,t,e,i){var s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I,P,M,w,N,L,U,k;if(xl.Qk(n.P,e)!=xl.Qk(n.P,i))return xl.Qk(n.P,e)>xl.Qk(n.P,i);if(xl.Jk(n.P,e)!=xl.Jk(n.P,i))return(xl.Gl(n.P,e)?(xl.Sj(),xl.Qj)[xl.Qk(n.P,e)]:xl.Jk(n.P,e))>(xl.Gl(n.P,i)?(xl.Sj(),xl.Qj)[xl.Qk(n.P,i)]:xl.Jk(n.P,i));for(T=n.P.f,j=vf(kl.llb,z,6,T,15,1),A=vf(kl.llb,z,6,T,15,1),C=vf(kl.llb,z,6,T,15,1),m=vf(kl.Cwb,nn,6,T,16,1),l=vf(kl.Cwb,nn,6,n.P.q,16,1),j[0]=t,j[1]=e,j[2]=i,A[0]=-1,A[1]=0,A[2]=0,l[t]=!0,l[e]=!0,l[i]=!0,d=1,p=2,(N=vf(kl.llb,z,6,64,15,1))[1]=1,N[2]=3,h=2;d<=p;){for(;d<N[h];){if(c=j[d],!m[d]){for(b=0,D=0,P=0;P<xl.Sn(n.P,c);P++){if(g=xl.Rn(n.P,c,P),p+xl.Un(n.P,c,P)+1>=T&&(T+=n.P.f,j=xl.ag(j,T),A=xl.ag(A,T),C=xl.ag(C,T),m=xl.bg(m,T)),xl.Mo(n.P,xl.Tn(n.P,c,P)))++b,D+=xl.Qk(n.P,g);else for(w=1;w<xl.Un(n.P,c,P);w++)j[++p]=g,A[p]=d,m[p]=!0;if(g!=j[U=A[d]]){if(o=!1,l[g])for(L=A[U];-1!=L;){if(g==j[L]){o=!0;break}L=A[L]}o?(j[++p]=g,A[p]=d,m[p]=!0):(j[++p]=g,A[p]=d,l[g]=!0)}}0!=b&&(C[++p]=(D<<2)/b|0,A[p]=d,m[p]=!0)}if(++d==B)throw og(new Jl.aA("Emergency break in while loop."))}for(N.length==h+1&&(N=xl.ag(N,N.length+64)),N[h+1]=p+1,I=N[h];I<N[h+1];I++)0==C[I]&&(C[I]=(151==xl.Qk(n.P,j[I])||152==xl.Qk(n.P,j[I])?1:xl.Qk(n.P,j[I]))<<2),C[I]+=C[A[I]]<<16;if(xl.vf(n,m,C,A,j,N,h),C[1]!=C[2])return C[1]>C[2];h>1&&xl.sf(C,A,N,h),++h}for(u=vf(kl.llb,z,6,n.P.f,15,1),M=!1,a=0;a<n.P.f;a++)if(l[a]&&!xl.Gl(n.P,a)){M=!0;break}if(M){for(r=0;r<n.P.f;r++)u[r]=xl.Gl(n.P,r)?(xl.Sj(),xl.Qj)[xl.Qk(n.P,r)]:xl.Jk(n.P,r);if(xl.uf(n,m,C,A,j,u,N,h))return C[1]>C[2]}for(Fl.GOb(u,u.length,0),H=!1,f=0;f<n.P.g;f++)(l[xl.Vk(n.P,0,f)]||l[xl.Vk(n.P,1,f)])&&(1==n.f[f]?(u[xl.Vk(n.P,0,f)]=1,u[xl.Vk(n.P,1,f)]=1,H=!0):2==n.f[f]&&(u[xl.Vk(n.P,0,f)]=2,u[xl.Vk(n.P,1,f)]=2,H=!0));if(H&&xl.uf(n,m,C,A,j,u,N,h))return C[1]>C[2];for(Fl.GOb(u,u.length,0),k=!1,s=0;s<n.P.f;s++)l[s]&&(2==n.Y[s]?(u[s]=1,k=!0):1==n.Y[s]&&(u[s]=2,k=!0));if(k&&xl.uf(n,m,C,A,j,u,N,h))return C[1]>C[2];throw og(new Jl.aA("no distinction applying CIP rules"))},xl.sf=function(n,t,e,i){var s,a,r,o,l,f,g,u,d;for(u=e[i],r=e[i+1]-u,d=vf(kl.vlb,N,214,r,0,1),l=0;l<r;l++)d[l]=new xl.vg,d[l].c=n[l+u],d[l].b=t[l+u],d[l].a=l+u;for(s=new xl.sg,g=i;g>1;g--){for(f=0;f<r;f++)d[f].c+=n[d[f].b]<<16,d[f].b=t[d[f].b];for(Fl.NOb(d,0,d.length,s),a=1,o=0;o<r;o++)n[d[o].a]=a,o!=r-1&&0!=xl.rg(d[o],d[o+1])&&++a}},xl.tf=function(n,t){var e,i,s,a,r,o,l;for(r=xl.Dn(n.P,t),o=vf(kl.llb,z,6,r,15,1),s=0;s<r;s++)o[s]=xl.Rn(n.P,t,s);for(i=r;i>1;i--){for(e=!1,a=1;a<i;a++)xl.rf(n,t,o[a-1],o[a])&&(e=!0,l=o[a-1],o[a-1]=o[a],o[a]=l);if(!e)break}return o},xl.uf=function(n,t,e,i,s,a,r,o){var l,f;for(f=1;f<o;f++){for(l=r[f];l<r[f+1];l++)e[l]=a[s[l]]+(e[i[l]]<<8);if(xl.vf(n,t,e,i,s,r,f),e[1]!=e[2])return!0;f>1&&xl.sf(e,i,r,f)}return!1},xl.vf=function(n,t,e,i,s,a,r){var o,l,f,g,u,d,c,h,b,D,H;for(u=r;u>1;u--){for(b=a[u]-a[u-1],H=vf(kl.tlb,N,213,b,0,1),o=a[u],h=0;h<b;h++){for(D=a[u-1]+h,d=o;d<a[u+1]&&i[d]==D;)++d;for(H[h]=new xl.pg,H[h].c=D,H[h].d=e[D],H[h].b=t[D]?0:xl.qo(n.P,s[D]),H[h].a=vf(kl.llb,z,6,d-o,15,1),g=o;g<d;g++)H[h].a[g-o]=e[g];Rl.fTb(H[h].a,Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[]))),o=d}for(l=new xl.mg,Fl.NOb(H,0,H.length,l),f=1,c=0;c<b;c++)e[H[c].c]=f,c!=b-1&&0!=xl.lg(H[c],H[c+1])&&++f}},xl.wf=function(n){var t,e;for(e=Yf(kl.llb,[j,ot],[41,8],0,[2,32],2),t=0;t<n.P.f;t++)n.K[t]&&(1==n._[t]?e[0][n.$[t]]=xl.Wg(e[0][n.$[t]],t):2==n._[t]&&(e[1][n.$[t]]=xl.Wg(e[0][n.$[t]],t)));return e},xl.xf=function(n){var t,e,i,s,a,r,o,l,f,g,u,d;for(a=0,g=0,r=0,o=0,l=0,f=0,u=0,d=!1,t=vf(kl.Cwb,nn,6,32,16,1),e=0;e<n.P.f;e++)0!=n.bb[e]&&(++a,3==n.bb[e]?++g:0==n._[e]?(++r,n.N&&xl.Lg(n.N,e)&&++o):2==n._[e]?0==n.$[e]&&++f:1==n._[e]&&(t[s=n.$[e]]||(++u,t[s]=!0),0==n.$[e]&&++l,n.N&&xl.Lg(n.N,e)&&(d=!0)));for(i=0;i<n.P.g;i++)0!=n.k[i]&&1==xl.el(n.P,i)&&(++a,3==n.k[i]?++g:0==n.j[i]?(++r,n.N&&xl.Lg(n.N,xl.Vk(n.P,0,i))&&xl.Lg(n.N,xl.Vk(n.P,1,i))&&++o):2==n.j[i]?0==n.i[i]&&++f:1==n.j[i]&&(t[s=n.i[i]]||(++u,t[s]=!0),0==n.i[i]&&++l,n.N&&xl.Lg(n.N,xl.Vk(n.P,0,i))&&xl.Lg(n.N,xl.Vk(n.P,1,i))&&(d=!0)));0!=a?0==g?n.I?xl.Gm(n.P,gt+(1<<u)):l+o!=a||d?r==a?xl.Gm(n.P,Wn):f==a?xl.Gm(n.P,327680):r==a-1&&1==l?xl.Gm(n.P,Mn):xl.Gm(n.P,458752+(1<<u)):xl.Gm(n.P,ut):xl.Gm(n.P,0):xl.Gm(n.P,J)},xl.yf=function(n,t,e){for(;0!=e;)0==n.r&&((!n.p||63!=n.t)&&(n.t+=64),Jl.cIb(n.s,n.t&y),n.r=6,n.t=0),n.t<<=1,n.t=zg(Eg(Mg(n.t),Cg(t,1))),t=Fg(t,1),--e,--n.r},xl.zf=function(n){return n.t<<=n.r,(!n.p||63!=n.t)&&(n.t+=64),Jl.cIb(n.s,n.t&y),n.s.a},xl.Af=function(n,t){n.s=new Jl.jIb,n.r=6,n.t=0,n.p=t},xl.Bf=function(t,e,i){var s,a,r,o,l,f,g,u,d,c,h,b,D,H;if(0!=t.P.f){if(d=!1,t.hb&&t.P.q>t.P.f&&!t.P.K)for(d=!0,f=0;f<t.P.f;f++)if(0!=xl.fo(t.P,f)){d=!1;break}for(H=t.hb?16:8,xl.Af(t,!0),Jl.cIb(t.s,d?35:33),xl.yf(t,Mg(t.hb?1:0),1),xl.yf(t,kl.Rwb(e?1:0),1),xl.yf(t,kl.Rwb(H/2|0),4),b=0,g=1;g<t.P.f;g++)b=xl.Of(t,t.w[g],-1==t.C[g]?-1:t.w[t.C[g]],b,i);if(d)for(f=0;f<t.P.f;f++)for(s=t.w[f],h=xl.Sn(t.P,s);h<xl.Dn(t.P,s);h++)b=xl.Of(t,xl.Rn(t.P,s,h),s,b,i);if(t.P.f>1&&0==b)t.q="";else{for(D=b+(c=b/((o=1<<H)/2-1))/2,u=1;u<t.P.f;u++)xl.Cf(t,t.w[u],-1==t.C[u]?-1:t.w[t.C[u]],D,c,H,i);if(d)for(l=0;l<t.P.f;l++)for(s=t.w[l],h=xl.Sn(t.P,s);h<xl.Dn(t.P,s);h++)xl.Cf(t,xl.Rn(t.P,s,h),s,D,c,H,i);e&&(r=t.hb?1.5:(xl.Sj(),xl.Sj(),xl.Rj),a=xl.Tk(t.P,d?t.P.q:t.P.f,d?t.P.r:t.P.g,r,i),xl.yf(t,Mg(n.Math.min(o-1,n.Math.max(0,ag(.5+n.Math.log(a/.1)*n.Math.LOG10E/(n.Math.log(2e3)*n.Math.LOG10E)*(o-1))))),H),xl.yf(t,Mg(xl.Ff(i[t.w[0]].a/a,o)),H),xl.yf(t,Mg(xl.Ff(i[t.w[0]].b/a,o)),H),t.hb&&xl.yf(t,Mg(xl.Ff(i[t.w[0]].c/a,o)),H)),t.q=xl.zf(t)}}else t.q=""},xl.Cf=function(n,t,e,i,s,a,r){var o,l,f;o=-1==e?(r[t].a-r[n.w[0]].a)/8:r[t].a-r[e].a,l=-1==e?(r[t].b-r[n.w[0]].b)/8:r[t].b-r[e].b,xl.yf(n,Mg(ag((i+o)/s)),a),xl.yf(n,Mg(ag((i+l)/s)),a),n.hb&&(f=-1==e?(r[t].c-r[n.w[0]].c)/8:r[t].c-r[e].c,xl.yf(n,Mg(ag((i+f)/s)),a))},xl.Df=function(n,t){var e;for(e=0;e<n.u;e++)t-=16;for(t<0&&(Jl.oIb(),String.fromCharCode(10));t>15;)xl.yf(n,1,1),xl.yf(n,15,4),t-=16,++n.u;xl.yf(n,1,1),xl.yf(n,kl.Rwb(t),4)},xl.Ef=function(n){var t,e,i,s,a,r;if(0!=n.P.f){for(a=0,i=!1,s=!1,e=0;e<n.P.f;e++)a<xl.Ik(n.P,e)&&(a=xl.Ik(n.P,e)),xl.vl(n.P,e)?i=!0:s=!0;if(0!=a){for(r=xl.jg(a),xl.Af(n,!0),xl.yf(n,kl.Rwb(r),4),xl.yf(n,kl.Rwb(i?1:0),1),xl.yf(n,kl.Rwb(s?1:0),1),t=0;t<n.P.f;t++)xl.yf(n,Mg(xl.Ik(n.P,n.w[t])),r),i&&s&&xl.yf(n,Mg(xl.vl(n.P,n.w[t])?1:0),1);n.L=xl.zf(n)}else n.L=""}else n.L=""},xl.Ff=function(t,e){var i,s,a,r;return i=e/2|0,a=t<0,t=n.Math.abs(t),r=e/32|0,s=n.Math.min(i-1,zg(Pg(n.Math.round(t*i/(t+r))))),a?i+s:s},xl.Gf=function(n){var t,e,i;for(t=0;t<n.P.f;t++)3==n.bb[t]&&!xl.rl(n.P,t)&&xl.Om(n.P,t),(1==xl.Ek(n.P,t)||2==xl.Ek(n.P,t))&&3==n.bb[t]&&xl.Om(n.P,t),xl.rl(n.P,t)&&3!=n.bb[t]&&!xl.$f(n,t)&&xl.Om(n.P,t);for(i=0;i<n.P.r;i++)xl.Ll(n.P,i)&&!xl.Zf(n,i)&&xl.Om(n.P,xl.Vk(n.P,0,i));for(e=0;e<n.P.g;e++)2==xl.bl(n.P,e)&&(!xl.Bl(n.P,e)||1!=n.k[e]&&2!=n.k[e]||(n.k[e]=3,xl.Fm(n.P,e,386)),3!=n.k[e]||n.n[e]||386!=xl.el(n.P,e)&&(xl.Om(n.P,xl.Vk(n.P,0,e)),xl.Om(n.P,xl.Vk(n.P,1,e)))),1!=xl.el(n.P,e)||3!=n.k[e]||xl.rl(n.P,xl.Vk(n.P,0,e))||xl.rl(n.P,xl.Vk(n.P,1,e))||(xl.Om(n.P,xl.Vk(n.P,0,e)),xl.Om(n.P,xl.Vk(n.P,1,e))),1!=xl.$k(n.P,e)&&2!=xl.$k(n.P,e)||1==xl.el(n.P,e)&&(1==n.k[e]||2==n.k[e])||(xl.Om(n.P,xl.Vk(n.P,0,e)),xl.Om(n.P,xl.Vk(n.P,1,e)))},xl.Hf=function(n){var t,e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A;if(0!=n.P.f&&!n.D){for(n.G=0,A=0,e=1;e<n.P.f;e++)n.d[e]>n.d[A]&&(A=e);for(i=vf(kl.Cwb,nn,6,n.P.f,16,1),a=vf(kl.Cwb,nn,6,n.P.g,16,1),n.F=vf(kl.llb,z,6,n.P.f,15,1),n.w=vf(kl.llb,z,6,n.P.f,15,1),n.C=vf(kl.llb,z,6,n.P.f,15,1),n.A=vf(kl.llb,z,6,n.P.g,15,1),n.w[0]=A,n.F[A]=0,i[A]=!0,o=0,l=1,f=0;o<n.P.f;)if(o<l){for(;;){for(c=0,h=0,u=-1,t=n.w[o],b=0;b<xl.En(n.P,t);b++)(b<xl.Sn(n.P,t)||b>=xl.Dn(n.P,t))&&!i[r=xl.Rn(n.P,t,b)]&&n.d[r]>u&&(c=r,h=xl.Tn(n.P,t,b),u=n.d[r]);if(-1==u)break;n.F[c]=l,n.C[l]=o,n.w[l++]=c,n.A[f++]=h,i[c]=!0,a[h]=!0}++o}else{for(d=0,u=-1,t=0;t<n.P.f;t++)!i[t]&&n.d[t]>u&&(d=t,u=n.d[t]);n.F[d]=l,n.C[l]=-1,n.w[l++]=d,i[d]=!0}for(n.B=vf(kl.llb,z,6,2*(n.P.g-f),15,1);;){for(H=n.P.M,j=n.P.M,m=-1,s=0;s<n.P.g;s++)a[s]||(n.F[xl.Vk(n.P,0,s)]<n.F[xl.Vk(n.P,1,s)]?(D=n.F[xl.Vk(n.P,0,s)],g=n.F[xl.Vk(n.P,1,s)]):(D=n.F[xl.Vk(n.P,1,s)],g=n.F[xl.Vk(n.P,0,s)]),(D<H||D==H&&g<j)&&(H=D,j=g,m=s));if(-1==m)break;a[m]=!0,n.A[f++]=m,n.B[2*n.G]=H,n.B[2*n.G+1]=j,++n.G}n.D=!0}},xl.If=function(n){var t,e,i,s,a,r,o,l,f,g,u,d,c,h;for(l=null,h=xl.so(n.P),u=0;u<h.i.a.length;u++)if(h.e[u]){for(a=0,i=0,s=(e=d=Fl.Xi(h.i,u)).length;i<s;++i)t=e[i],xl.Uf(n,t)&&++a;if(0!=a)if(c=Fl.Xi(h.j,u),null==l&&(l=vf(kl.Cwb,nn,6,n.P.g,16,1)),a==d.length){for(f=-1,g=I,r=0;r<d.length;r++)g>n.w[c[r]]&&(g=n.w[c[r]],f=r);for(;a>0;)l[c[f]]=!0,f=xl.gg(f+2,d.length),a-=2}else{for(o=0;xl.Uf(n,d[o]);)++o;for(;!xl.Uf(n,d[o]);)o=xl.gg(o+1,d.length);for(;a>0;)for(l[c[o]]=!0,o=xl.gg(o+2,d.length),a-=2;!xl.Uf(n,d[o]);)o=xl.gg(o+1,d.length)}}return l},xl.Jf=function(n,t){return n.k[t]},xl.Kf=function(n){return xl.Lf(n,n.hb)},xl.Lf=function(n,t){return null==n.q&&(xl.Hf(n),xl.Bf(n,t,n.P.J)),n.q},xl.Mf=function(n){return null==n.L&&(xl.Hf(n),xl.Ef(n)),n.L},xl.Nf=function(n){return null==n.H&&(xl.Hf(n),0==(n.O&zn)&&(xl.Wf(n),xl.Xf(n,1),xl.Xf(n,2)),xl.Vf(n)),n.H},xl.Of=function(t,e,i,s,a){var r,o,l;return s<(r=-1==i?n.Math.abs(a[e].a-a[t.w[0]].a)/8:n.Math.abs(a[e].a-a[i].a))&&(s=r),s<(o=-1==i?n.Math.abs(a[e].b-a[t.w[0]].b)/8:n.Math.abs(a[e].b-a[i].b))&&(s=o),t.hb&&s<(l=-1==i?n.Math.abs(a[e].c-a[t.w[0]].c)/8:n.Math.abs(a[e].c-a[i].c))&&(s=l),s},xl.Pf=function(n,t){return n.V[t]},xl.Qf=function(n,t){return n.W[t]},xl.Rf=function(n,t){return null==n.e?-1:n.e[t]},xl.Sf=function(n,t){return n.bb[t]},xl.Tf=function(n,t){var e,i,s,a,r,o,l;for(l=xl.so(n.P),e=0;e<l.i.a.length;e++)if(l.d[e]&&xl.Wr(l,e,t)){for(a=0,r=(s=Fl.Xi(l.i,e)).length;a<r;++a)if((i=s[a])!=t)for(o=0;o<xl.Sn(n.P,i);o++)if(xl.Jo(n.P,xl.Tn(n.P,i,o)))return!0;return!1}return!1},xl.Uf=function(n,t){var e,i,s;if(xl.In(n.P,t)<2)return!1;if(2==xl.Sn(n.P,t))return!0;for(e=0,s=0;s<xl.Sn(n.P,t);s++)i=xl.Tn(n.P,t,s),xl.Io(n.P,i)&&(e+=xl.bl(n.P,i)-1);return e>1},xl.Vf=function(t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I,P,M,w,N,L,U,k,J,y,B,R,E,x,F,Q,S,X,z,G,q,Y,Z;if(xl.Af(t,!1),xl.yf(t,9,4),z=n.Math.max(xl.jg(t.P.f),xl.jg(t.P.g)),xl.yf(t,kl.Rwb(z),4),0==z)return xl.yf(t,Mg(t.P.K?1:0),1),xl.yf(t,0,1),void(t.H=xl.zf(t));for(G=Y=q=U=0,f=0;f<t.P.f;f++)if(Ig(Cg(xl.Lk(t.P,f),1),0)){switch(xl.Qk(t.P,f)){case 6:break;case 7:++G;break;case 8:++Y;break;default:++q}0!=xl.zk(t.P,f)&&++U}for(xl.yf(t,Mg(t.P.f),z),xl.yf(t,Mg(t.P.g),z),xl.yf(t,kl.Rwb(G),z),xl.yf(t,kl.Rwb(Y),z),xl.yf(t,kl.Rwb(q),z),xl.yf(t,kl.Rwb(U),z),g=0;g<t.P.f;g++)7==xl.Qk(t.P,t.w[g])&&Ig(Cg(xl.Lk(t.P,t.w[g]),1),0)&&xl.yf(t,kl.Rwb(g),z);for(c=0;c<t.P.f;c++)8==xl.Qk(t.P,t.w[c])&&Ig(Cg(xl.Lk(t.P,t.w[c]),1),0)&&xl.yf(t,kl.Rwb(c),z);for(h=0;h<t.P.f;h++)6!=xl.Qk(t.P,t.w[h])&&7!=xl.Qk(t.P,t.w[h])&&8!=xl.Qk(t.P,t.w[h])&&Ig(Cg(xl.Lk(t.P,t.w[h]),1),0)&&(xl.yf(t,kl.Rwb(h),z),xl.yf(t,Mg(xl.Qk(t.P,t.w[h])),8));for(b=0;b<t.P.f;b++)0!=xl.zk(t.P,t.w[b])&&Ig(Cg(xl.Lk(t.P,t.w[b]),1),0)&&(xl.yf(t,kl.Rwb(b),z),xl.yf(t,Mg(8+xl.zk(t.P,t.w[b])),4));for(X=0,T=0,D=1;D<t.P.f;D++)-1==t.C[D]?B=0:(B=1+t.C[D]-T,T=t.C[D]),X<B&&(X=B);for(y=xl.jg(X),xl.yf(t,kl.Rwb(y),4),T=0,H=1;H<t.P.f;H++)-1==t.C[H]?B=0:(B=1+t.C[H]-T,T=t.C[H]),xl.yf(t,kl.Rwb(B),y);for(E=0;E<2*t.G;E++)xl.yf(t,Mg(t.B[E]),z);for(I=0;I<t.P.g;I++)L=0!=(xl.dl(t.P,t.A[I])&qn)||32==xl.el(t.P,t.A[I])?1:xl.Mo(t.P,t.A[I])?0:n.Math.min(3,xl.bl(t.P,t.A[I])),xl.yf(t,kl.Rwb(L),2);if(i=0,0==(t.O&zn))for(j=0;j<t.P.f;j++)0!=t.Z[t.w[j]]&&3!=t.Z[t.w[j]]&&++i;if(xl.yf(t,kl.Rwb(i),z),0==(t.O&zn))for(j=0;j<t.P.f;j++)0!=t.Z[t.w[j]]&&3!=t.Z[t.w[j]]&&(xl.yf(t,kl.Rwb(j),z),0==t._[t.w[j]]?xl.yf(t,Mg(t.Z[t.w[j]]),3):(Z=1==t.Z[t.w[j]]?1==t._[t.w[j]]?4:6:1==t._[t.w[j]]?5:7,xl.yf(t,kl.Rwb(Z),3),xl.yf(t,Mg(t.$[t.w[j]]),3)));if(e=0,0==(t.O&zn))for(P=0;P<t.P.g;P++)0!=t.g[t.A[P]]&&3!=t.g[t.A[P]]&&(!xl.Yo(t.P,t.A[P])||1==xl.el(t.P,t.A[P]))&&++e;if(xl.yf(t,kl.Rwb(e),z),0==(t.O&zn))for(P=0;P<t.P.g;P++)0==t.g[t.A[P]]||3==t.g[t.A[P]]||xl.Yo(t.P,t.A[P])&&1!=xl.el(t.P,t.A[P])||(xl.yf(t,kl.Rwb(P),z),1==xl.el(t.P,t.A[P])?0==t.j[t.A[P]]?xl.yf(t,Mg(t.g[t.A[P]]),3):(Z=1==t.g[t.A[P]]?1==t.j[t.A[P]]?4:6:1==t.j[t.A[P]]?5:7,xl.yf(t,kl.Rwb(Z),3),xl.yf(t,Mg(t.i[t.A[P]]),3)):xl.yf(t,Mg(t.g[t.A[P]]),2));for(xl.yf(t,Mg(t.P.K?1:0),1),k=0,m=0;m<t.P.f;m++)0!=xl.Jk(t.P,t.w[m])&&++k;if(0!=k)for(xl.Df(t,1),xl.yf(t,kl.Rwb(k),z),j=0;j<t.P.f;j++)0!=xl.Jk(t.P,t.w[j])&&(xl.yf(t,kl.Rwb(j),z),xl.yf(t,Mg(xl.Jk(t.P,t.w[j])),8));if(t.u=0,t.P.K){for(xl.Fe(t,0,z,zn,1,-1),xl.Fe(t,3,z,fn,1,-1),xl.Fe(t,4,z,120,4,3),xl.Fe(t,5,z,dt,2,1),xl.Fe(t,6,z,1,1,-1),xl.Fe(t,7,z,cn,4,7),k=0,j=0;j<t.P.f;j++)null!=xl.Gk(t.P,t.w[j])&&++k;if(k>0)for(xl.Df(t,8),xl.yf(t,kl.Rwb(k),z),A=0;A<t.P.f;A++)if(null!=(C=xl.Gk(t.P,t.w[A])))for(xl.yf(t,kl.Rwb(A),z),xl.yf(t,Mg(C.length),4),r=0,o=(a=C).length;r<o;++r)s=a[r],xl.yf(t,kl.Rwb(s),8);xl.Ge(t,9,z,384,2,7),xl.Ge(t,10,z,31,5,0),xl.Fe(t,11,z,Xn,1,-1),xl.Ge(t,12,z,qn,8,9),xl.Fe(t,13,z,mn,3,14),xl.Fe(t,14,z,An,5,17),xl.Fe(t,16,z,Qn,3,22)}for(k=0,u=0;u<t.P.f;u++)null!=t.a&&-1!=t.a[t.w[u]]&&++k;if(0!=k)for(xl.Df(t,17),xl.yf(t,kl.Rwb(k),z),j=0;j<t.P.f;j++)null!=t.a&&-1!=t.a[t.w[j]]&&(xl.yf(t,kl.Rwb(j),z),xl.yf(t,Mg(t.a[t.w[j]]),4));if(0!=(8&t.O)||0!=(t.O&hn)){for(k=0,S=0,j=0;j<t.P.f;j++)null!=(F=xl.Bk(t.P,t.w[j]))&&(++k,S=n.Math.max(S,Rl.LTb(F).length));if(0!=k)for(Q=xl.jg(S),xl.Df(t,18),xl.yf(t,kl.Rwb(k),z),xl.yf(t,kl.Rwb(Q),4),A=0;A<t.P.f;A++)if(null!=(J=xl.Bk(t.P,t.w[A])))for(xl.yf(t,kl.Rwb(A),z),xl.yf(t,Mg(Rl.LTb(J).length),Q),R=0;R<Rl.LTb(J).length;R++)xl.yf(t,(Rl.GTb(R,Rl.LTb(J).length),Mg(Rl.LTb(J).charCodeAt(R))),7)}for(t.P.K&&(xl.Fe(t,19,z,bn,3,25),xl.Ge(t,20,z,wn,3,17)),k=0,d=0;d<t.P.f;d++)0!=xl.Mk(t.P,t.w[d])&&++k;if(0!=k)for(xl.Df(t,21),xl.yf(t,kl.Rwb(k),z),l=0;l<t.P.f;l++)0!=xl.Mk(t.P,t.w[l])&&(xl.yf(t,kl.Rwb(l),z),xl.yf(t,Mg(xl.Mk(t.P,t.w[l])>>4),2));if(t.P.K&&(xl.Fe(t,22,z,Sn,1,-1),xl.Ge(t,23,z,ct,1,-1),xl.Ge(t,24,z,Yn,2,21)),0!=(16&t.O))for(l=0;l<t.P.f;l++)if(xl.Jl(t.P,t.w[l])){for(xl.Df(t,25),s=0;s<t.P.f;s++)xl.yf(t,Mg(xl.Jl(t.P,t.w[s])?1:0),1);break}if(null!=(x=xl.If(t))){for(k=0,P=0;P<t.P.g;P++)x[t.A[P]]&&++k;for(xl.Df(t,26),xl.yf(t,kl.Rwb(k),z),M=0;M<t.P.g;M++)x[t.A[M]]&&xl.yf(t,kl.Rwb(M),z)}for(t.P.K&&xl.Fe(t,27,z,tn,1,-1),k=0,w=0;w<t.P.g;w++)32==xl.el(t.P,t.A[w])&&++k;if(0!=k)for(xl.Df(t,28),xl.yf(t,kl.Rwb(k),z),P=0;P<t.P.g;P++)32==xl.el(t.P,t.A[P])&&xl.yf(t,kl.Rwb(P),z);for(t.P.K&&(xl.Fe(t,29,z,ht,2,30),xl.Fe(t,30,z,v,7,32),xl.Fe(t,32,z,bt,2,44),xl.Fe(t,33,z,Ln,5,39),xl.Fe(t,34,z,dn,1,-1),xl.Ge(t,35,z,Dt,1,-1),xl.Ge(t,36,z,96,2,5)),k=0,N=0;N<t.P.g;N++)(8==xl.el(t.P,t.A[N])||16==xl.el(t.P,t.A[N]))&&++k;if(0!=k)for(xl.Df(t,37),xl.yf(t,kl.Rwb(k),z),p=0;p<t.P.g;p++)8!=xl.el(t.P,t.A[p])&&16!=xl.el(t.P,t.A[p])||(xl.yf(t,kl.Rwb(p),z),xl.yf(t,Mg(8==xl.el(t.P,t.A[p])?0:1),1));xl.yf(t,0,1),t.H=xl.zf(t)},xl.Wf=function(n){var t,e,i,s,a,r,o,l,f,g,u;for(n.Z=vf(kl.hlb,ft,6,n.P.f,15,1),t=0;t<n.P.f;t++)if(1==n.bb[t]||2==n.bb[t]){if(l=n.cb[t],xl.Ko(n.P,t))for(o=0;o<xl.Sn(n.P,t);o++){for(s=xl.Rn(n.P,t,o),u=0,g=vf(kl.llb,z,6,3,15,1),f=0;f<xl.Sn(n.P,s);f++)g[u]=xl.Rn(n.P,s,f),g[u]!=t&&++u;2==u&&n.d[g[0]]>n.d[g[1]]^n.F[g[0]]<n.F[g[1]]&&(l=!l)}else for(o=1;o<xl.Sn(n.P,t);o++)for(f=0;f<o;f++)a=xl.Rn(n.P,t,o),r=xl.Rn(n.P,t,f),n.d[a]>n.d[r]&&(l=!l),n.F[a]<n.F[r]&&(l=!l);n.Z[t]=1==n.bb[t]^l?1:2}else n.Z[t]=n.bb[t];for(n.g=vf(kl.hlb,ft,6,n.P.g,15,1),e=0;e<n.P.g;e++)if(1==n.k[e]||2==n.k[e]){for(l=!1,o=0;o<2;o++)if(i=xl.Vk(n.P,o,e),3==xl.Sn(n.P,i)){for(g=vf(kl.llb,z,6,2,15,1),u=0,f=0;f<3;f++)xl.Rn(n.P,i,f)!=xl.Vk(n.P,1-o,e)&&(g[u++]=xl.Rn(n.P,i,f));n.d[g[0]]>n.d[g[1]]&&(l=!l),n.F[g[0]]<n.F[g[1]]&&(l=!l)}n.g[e]=1==n.k[e]^l?1:2}else n.g[e]=n.k[e]},xl.Xf=function(t,e){var i,s,a,r,o,l,f,g,u,d,c,h,b;for(f=vf(kl.llb,z,6,32,15,1),g=0,s=0;s<t.P.f;s++)1!=t.Z[s]&&2!=t.Z[s]||t._[s]!=e||f[l=t.$[s]]<t.d[s]&&(0==f[l]&&++g,f[l]=t.d[s]);for(r=0;r<t.P.g;r++)1!=t.g[r]&&2!=t.g[r]||t.j[r]!=e||1!=xl.el(t.P,r)||(l=t.i[r],b=n.Math.max(t.d[xl.Vk(t.P,0,r)],t.d[xl.Vk(t.P,1,r)]),f[l]<b&&(0==f[l]&&++g,f[l]=b));for(o=vf(kl.hlb,ft,6,32,15,1),u=0;u<g;u++){for(c=-1,h=0,d=0;d<32;d++)h<f[d]&&(h=f[d],c=d);f[c]=0,o[c]=u<<24>>24}for(i=0;i<t.P.f;i++)(1==t.Z[i]||2==t.Z[i])&&t._[i]==e&&(t.$[i]=o[t.$[i]]);for(a=0;a<t.P.g;a++)(1==t.g[a]||2==t.g[a])&&t.j[a]==e&&1==xl.el(t.P,a)&&(t.i[a]=o[t.i[a]])},xl.Yf=function(n,t,e){var i,s;for(n.S=t,i=0;i<n.P.f;i++)n.d[i]=e[i],n.bb[i]=0,n.gb[i]=!1;for(s=0;s<n.P.g;s++)n.k[s]=0,n.o[s]=!1},xl.Zf=function(n,t){var e,i,s;if((e=xl.Vk(n.P,0,t))>=n.P.f)return!1;if(1==n.bb[e]||2==n.bb[e])return!0;if(3==n.bb[e])return!1;if(-1!=(i=xl.zn(n.P,e)))return 1==n.k[i]||2==n.k[i];for(s=0;s<xl.Sn(n.P,e);s++)if(2==xl.Un(n.P,e,s)&&(1==n.bb[xl.Rn(n.P,e,s)]||2==n.bb[xl.Rn(n.P,e,s)]))return!0;return!1},xl.$f=function(n,t){var e;for(e=0;e<xl.Sn(n.P,t);e++)if(3==n.k[xl.Tn(n.P,t,e)]&&1==xl.Un(n.P,t,e))return!0;return!1},xl._f=function(n){var t,e,i,s,a,r,o;for(r=vf(kl.llb,z,6,n.S+1,15,1),e=0;e<n.P.f;e++)0==xl.Ek(n.P,e)&&(1==n.bb[e]?++r[n.d[e]]:2==n.bb[e]&&--r[n.d[e]]);for(s=0;s<n.P.g;s++)1==xl.bl(n.P,s)&&0==xl.$k(n.P,s)&&(1==n.k[s]?(++r[n.d[xl.Vk(n.P,0,s)]],++r[n.d[xl.Vk(n.P,1,s)]]):2==n.k[s]&&(--r[n.d[xl.Vk(n.P,0,s)]],--r[n.d[xl.Vk(n.P,1,s)]]));for(o=1;o<=n.S;o++)if(0!=r[o]){if(a=r[o]<0){for(t=0;t<n.P.f;t++)0==xl.Ek(n.P,t)&&(1==n.bb[t]?n.bb[t]=2:2==n.bb[t]&&(n.bb[t]=1));for(i=0;i<n.P.g;i++)1==xl.bl(n.P,i)&&0==xl.$k(n.P,i)&&(1==n.k[i]?n.k[i]=2:2==n.k[i]&&(n.k[i]=1))}return a}return!1},xl.ag=function(n,t){var e;return e=vf(kl.llb,z,6,t,15,1),Jl.pIb(n,0,e,0,n.length),e},xl.bg=function(n,t){var e;return e=vf(kl.Cwb,nn,6,t,16,1),Jl.pIb(n,0,e,0,n.length),e},xl.cg=function(n){var t,e;if(null!=n.Y)for(t=0;t<n.P.f;t++)xl.bm(n.P,t,n.Y[t]);if(null!=n.f)for(e=0;e<n.P.g;e++)xl.ym(n.P,e,n.f[e])},xl.dg=function(n){var t,e,i,s,a,r,o,l,f,g,u;for(t=0;t<n.P.f;t++)if(1==n.bb[t]||2==n.bb[t]){if(l=!1,xl.Ko(n.P,t))for(o=0;o<xl.Sn(n.P,t);o++){for(s=xl.Rn(n.P,t,o),u=0,g=vf(kl.llb,z,6,3,15,1),f=0;f<xl.Sn(n.P,s);f++)g[u]=xl.Rn(n.P,s,f),g[u]!=t&&++u;2==u&&n.d[g[0]]>n.d[g[1]]^g[0]<g[1]&&(l=!l)}else for(o=1;o<xl.Sn(n.P,t);o++)for(f=0;f<o;f++)a=xl.Rn(n.P,t,o),r=xl.Rn(n.P,t,f),n.d[a]>n.d[r]&&(l=!l),a<r&&(l=!l);xl.nm(n.P,t,1==n.bb[t]^l?1:2,n.db[t])}else xl.nm(n.P,t,n.bb[t],n.db[t]);for(e=0;e<n.P.g;e++)if(1==n.k[e]||2==n.k[e]){for(l=!1,o=0;o<2;o++)if(i=xl.Vk(n.P,o,e),3==xl.Sn(n.P,i)){for(g=vf(kl.llb,z,6,2,15,1),u=0,f=0;f<3;f++)xl.Rn(n.P,i,f)!=xl.Vk(n.P,1-o,e)&&(g[u++]=xl.Rn(n.P,i,f));n.d[g[0]]>n.d[g[1]]&&(l=!l),g[0]<g[1]&&(l=!l)}xl.Cm(n.P,e,1==n.k[e]^l?1:2,n.n[e])}else xl.Cm(n.P,e,n.k[e],n.n[e])},xl.eg=function(n){var t;for(t=0;t<n.P.f;t++)xl.rm(n.P,t,n.K[t])},xl.fg=function(n){var t,e,i;for(t=0;t<n.P.f;t++)!xl.rl(n.P,t)&&3==n.bb[t]&&xl.em(n.P,t,!0);for(e=0;e<n.P.g;e++)3==n.k[e]&&(1==(i=xl.bl(n.P,e))?xl.em(n.P,xl.Vk(n.P,0,e),!0):2==i&&xl.Fm(n.P,e,386))},xl.gg=function(n,t){return n<t?n:n-t},xl.hg=function(n){xl.ig.call(this,n,0)},xl.ig=function(n,t){this.P=n,this.O=t,xl.nu(this.P,7),this.b=xl.jg(this.P.f),0==(this.O&zn)&&xl.$e(this),this.hb=0!=(64&t)||xl.ql(this.P),0==(this.O&zn)&&(this.bb=vf(kl.hlb,ft,6,this.P.f,15,1),this.db=vf(kl.Cwb,nn,6,this.P.f,16,1),this.gb=vf(kl.Cwb,nn,6,this.P.f,16,1),this.k=vf(kl.hlb,ft,6,this.P.g,15,1),this.o=vf(kl.Cwb,nn,6,this.P.g,16,1),this.n=vf(kl.Cwb,nn,6,this.P.g,16,1)),xl.cf(this),0==(this.O&zn)&&xl.jf(this),xl.hf(this)},xl.jg=function(n){var t;for(t=0;n>0;)n>>=1,++t;return t},zf(47,1,{},xl.hg,xl.ig),o.b=0,o.p=!1,o.r=0,o.t=0,o.u=0,o.D=!1,o.G=0,o.I=!1,o.J=!1,o.M=0,o.O=0,o.R=0,o.S=0,o.X=!1,o.hb=!1,kl.Dlb=lg(47),xl.kg=function(t,e){var i,s,a,r;if(t.d!=e.d)return t.d>e.d?1:-1;for(a=t.a.length,r=e.a.length,i=n.Math.min(a,r),s=0;s<i;s++)if(--a,--r,t.a[a]!=e.a[r])return t.a[a]>e.a[r]?1:-1;return a!=r?a>r?1:-1:t.b!=e.b?t.b>e.b?1:-1:0},xl.lg=function(n,t){return xl.kg(n,t)},xl.mg=function(){},zf(390,1,{},xl.mg),o.Db=function(n,t){return xl.lg(n,t)},o.ib=function(n){return this===n},kl.ulb=lg(390),xl.pg=function(){},zf(213,1,{213:1},xl.pg),o.b=0,o.c=0,o.d=0,kl.tlb=lg(213),xl.qg=function(n,t){return n.c!=t.c?n.c>t.c?1:-1:0},xl.rg=function(n,t){return xl.qg(n,t)},xl.sg=function(){},zf(391,1,{},xl.sg),o.Db=function(n,t){return xl.rg(n,t)},o.ib=function(n){return this===n},kl.wlb=lg(391),xl.vg=function(){},zf(214,1,{214:1},xl.vg),o.a=0,o.b=0,o.c=0,kl.vlb=lg(214),xl.wg=function(n,t,e){0==n.b&&(++n.c,n.b=63),63==n.b?(n.d[n.c]=Eg(n.d[n.c],e),n.b-=t):n.b>=t?(n.d[n.c]=xg(n.d[n.c],t),n.d[n.c]=Eg(n.d[n.c],e),n.b-=t):(n.d[n.c]=xg(n.d[n.c],n.b),n.d[n.c]=Eg(n.d[n.c],Fg(e,t-n.b)),t-=n.b,++n.c,n.b=63-t,n.d[n.c]=Eg(n.d[n.c],Cg(e,kl.Rwb((1<<t)-1))))},xl.xg=function(n,t){n.d[n.c]=Ag(n.d[n.c],t)},xl.yg=function(n,t){var e;for(e=0;e<n.c;e++)if(Bg(n.d[e],t.d[e]))return Lg(n.d[e],t.d[e])?-1:1;return Ig(n.d[n.c],t.d[n.c])?0:Lg(n.d[n.c],t.d[n.c])?-1:1},xl.zg=function(n,t){n.a=t,n.c=0,n.b=63,Fl.COb(n.d)},xl.Ag=function(n){this.d=vf(kl.mlb,st,6,n,14,1)},zf(160,1,{160:1,18:1},xl.Ag),o.Eb=function(n){return xl.yg(this,n)},o.a=0,o.b=0,o.c=0,kl.xlb=lg(160),xl.Cg=function(n,t){return n.b!=t.b?n.b>t.b?-1:1:n.c!=t.c?n.c>t.c?-1:1:0},xl.Dg=function(t,e,i){this.b=n.Math.max(t,e),this.c=n.Math.min(t,e),this.a=i},zf(212,1,{212:1,18:1},xl.Dg),o.Eb=function(n){return xl.Cg(this,n)},o.a=0,o.b=0,o.c=0,kl.ylb=lg(212),xl.Fg=function(n,t,e,i){this.a=(Rl.wTb(t),Fl.zOb(n,vf(kl.llb,z,6,t,15,1),t)),this.b=(Rl.wTb(i),Fl.zOb(e,vf(kl.llb,z,6,i,15,1),i))},zf(256,1,{256:1},xl.Fg),kl.zlb=lg(256),xl.Gg=function(n,t){var e,i;for(i=0;i<n.g[t].length;i++)if(e=n.g[t][i],n.f[e]&&(1==n.o[e]||2==n.o[e])&&0==n.k[e])return!0;return!1},xl.Hg=function(n,t,e){var i,s,a,r,o;for(s=0,r=0,o=0;o<n.g[t].length;o++)i=n.g[t][o],n.k[i]==e&&0==(r&(a=1<<n.j[i]))&&(r|=a,++s);return s},xl.Ig=function(n){var t,e,i,s,a,r,o,l,f,g,u;for(f=new Fl.dSb,g=0;g<n.i.f;g++)if(xl.In(n.i,g)<2||xl.Sn(n.i,g)>2)for(a=1;a<xl.Sn(n.i,g);a++)for(t=xl.Rn(n.i,g,a),r=0;r<a;r++)e=xl.Rn(n.i,g,r),xl.Ng(n,t,e)&&((o=xl.Ug(n,t,e))&&xl.qq(o,n.f)&&Fl.gRb(f.a,o,(Jl.iFb(),c)));for(u=0;u<n.i.g;u++)(0==n.c[u]||2==xl.bl(n.i,u)&&2==n.c[u])&&(t=xl.Vk(n.i,0,u),e=xl.Vk(n.i,1,u),xl.Ng(n,t,e)&&((o=xl.Ug(n,t,e))&&xl.qq(o,n.f)&&Fl.gRb(f.a,o,(Jl.iFb(),c))));for(n.g=vf(kl.llb,ot,8,f.a.c,0,2),n.e=vf(kl.Cwb,nn,6,n.i.f,16,1),s=0,i=new Fl.yRb(new Fl.DRb(new Fl.zNb(f.a).a).b),l=new Fl.HNb(i);Fl.hMb(l.a.a);)for(o=Fl.wRb(l.a).Wd(),n.g[s++]=o.b,a=0;a<o.b.length;a++)n.e[o.b[a]]=!0},xl.Jg=function(n,t,e,i){var s,a,r,o,l,f,g;for(s=vf(kl.llb,z,6,xl.Sn(n.i,e),15,1),o=0,r=0;r<xl.Sn(n.i,e);r++)s[o]=xl.Rn(n.i,e,r),!i[s[o]]&&xl.Ng(n,t,s[o])&&++o;if(0==o)return-1;if(1==o)return s[0];for(l=-1,f=I,a=0;a<o;a++)(g=xl.po(n.i,t,s[a],I,i))<f&&(f=g,l=s[a]);return l},xl.Kg=function(n,t){return n.f[t]&&(1==n.o[t]||2==n.o[t])},xl.Lg=function(n,t){return n.e[t]},xl.Mg=function(n){var t,e;for(e=!0,t=0;t<n.i.f;t++)if(0!=n.o[t]&&!n.e[t]){e=!1;break}return e},xl.Ng=function(n,t,e){var i,s,a,r,o;if(t==e)return!1;if(n.a[t]!=n.a[e])return!1;if(0!=n.o[t]){if(3==n.o[t]||3==n.o[e])return!1;if(n.p[t]^n.o[t]!==n.o[e])return!1;if(n.k[t]!==n.k[e]||n.j[t]!==n.j[e])return!1}if(-1!=(i=xl.Pn(n.i,t,e))){if(1==xl.bl(n.i,i)&&0!=n.c[i])return!1;if(2==xl.bl(n.i,i)&&1==n.c[i])return!1}if(1==xl.In(n.i,t)&&!xl.Ho(n.i,t)){for(s=-1,o=0;o<xl.Sn(n.i,t);o++)if(xl.Rn(n.i,t,o)!=e&&2==xl.Un(n.i,t,o)){s=xl.Tn(n.i,t,o);break}for(a=-1,r=0;r<xl.Sn(n.i,e);r++)if(xl.Rn(n.i,e,r)!=t&&2==xl.Un(n.i,e,r)){a=xl.Tn(n.i,e,r);break}if(-1!=s&&0!=n.c[s]&&n.d[s]^n.c[s]===n.c[a])return!1}return!0},xl.Og=function(n,t,e,i,s){var a,r,o,l,f,g;for(l=null,a=null,g=0;g<n.g[t].length;g++)r=n.g[t][g],n.f[r]&&(1==n.o[r]||2==n.o[r])&&(0==n.k[r]?a=xl.Wg(a,(s[r]<<16)+r):n.k[r]==i&&n.j[r]==e&&(l=xl.Wg(l,(s[r]<<16)+r)));if(0==(o=xl.jh(l,a)))return!1;if(o<0)for(f=0;f<n.g[t].length;f++)r=n.g[t][f],!n.f[r]||1!=n.o[r]&&2!=n.o[r]||(0==n.k[r]?(n.k[r]=i<<24>>24,n.j[r]=e<<24>>24):n.k[r]==i&&n.j[r]==e&&(n.k[r]=0,n.j[r]=-1));return!0},xl.Pg=function(n,t){var e,i,s,a,r,o;if(!n.b)return!1;for(s=!1,a=n.b.a.length-1;a>=0;a--)if(i=!1,2==(r=Fl.Xi(n.b,a)).a?i=xl.Og(n,r.b,r.c,r.d,t):1==r.a&&(i=xl.Tg(n,r.b,t)),i){for(Fl.dj(n.b,r),o=0;o<n.g[r.b].length;o++)e=n.g[r.b][o],n.n[e]=!1;s=!0}return s},xl.Qg=function(n){var t,e,i,s,a,r,o,l;if(null!=n.g)for(r=new xl.ih(n),n.b=new Fl.kj,s=0;s<n.g.length;s++)0==(i=xl._g(r,s))?(xl.Xg(r,s),o=xl.Hg(n,s,2),t=xl.Hg(n,s,1),e=xl.Gg(n,s),1!=o||1!=t||e||(xl.Sg(n,s,r.a+r.f++),Fl.Si(n.b,new xl.Ij(s,1,-1,-1))),o>0?(e&&(xl.Rg(n,s,r.i+r.g++,2),++o),Fl.Si(n.b,new xl.Ij(s,1,-1,-1))):t>0?(e&&xl.Rg(n,s,r.a+r.f++,1),Fl.Si(n.b,new xl.Ij(s,1,-1,-1))):e&&(xl.Rg(n,s,r.a+r.f++,1),Fl.Si(n.b,new xl.Ij(s,1,-1,-1)))):1==i&&(xl.Gg(n,s)?(a=xl.$g(r,s),l=xl.ah(r,s),Fl.Si(n.b,new xl.Ij(s,2,a,l))):(xl.Xg(r,s),Fl.Si(n.b,new xl.Ij(s,1,-1,-1))))},xl.Rg=function(n,t,e,i){var s,a;for(a=0;a<n.g[t].length;a++)s=n.g[t][a],!n.f[s]||1!=n.o[s]&&2!=n.o[s]||0!=n.k[s]||(n.k[s]=i<<24>>24,n.j[s]=e<<24>>24)},xl.Sg=function(n,t,e){var i,s;for(s=0;s<n.g[t].length;s++)i=n.g[t][s],2==n.k[i]&&(n.k[i]=1,n.j[i]=e<<24>>24)},xl.Tg=function(n,t,e){var i,s,a,r,o,l,f,g;for(a=n.g[t],s=1,l=0;l<a.length;l++)if(i=a[l],n.f[i]&&2==n.k[i]){s=2;break}for(r=vf(kl.llb,ot,8,32,0,2),f=0;f<a.length;f++)i=a[f],n.f[i]&&n.k[i]==s&&(r[n.j[i]]=xl.Wg(r[n.j[i]],(e[i]<<16)+i));for(g=0;g<32;g++)null!=r[g]&&Rl.fTb(r[g],Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[])));if(Fl.ROb(r,new xl.kh),0==xl.jh(r[0],r[1]))return!1;for(o=0;o<r[0].length;o++)i=r[0][o]&y,n.k[i]=0,n.j[i]=-1;return!0},xl.Ug=function(n,t,e){var i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C;for(l=vf(kl.llb,z,6,n.i.f,15,1),H=vf(kl.llb,z,6,n.i.f,15,1),h=vf(kl.Cwb,nn,6,n.i.f,16,1),f=vf(kl.Cwb,nn,6,n.i.f,16,1),j=new xl.rq(n.i.f),l[0]=t,H[t]=e,H[e]=-2,j.a[t]=!0,j.a[e]=!0,a=0,g=0;a<=g;){if(H[r=l[a]]==r){for(u=0;u<xl.Sn(n.i,r);u++)if(i=xl.Rn(n.i,r,u),!j.a[i])if(2==xl.Un(n.i,r,u)&&xl.Qk(n.i,i)<10)l[++g]=i,H[i]=i,f[i]=f[r]||2==xl.In(n.i,i),h[i]=f[r]&&!h[r],j.a[i]=!0;else if(f[r]&&h[r]){if(-1==(m=xl.Jg(n,i,H[r],j.a)))return null;l[++g]=i,H[i]=m,H[m]=-2,f[i]=!1,j.a[i]=!0,j.a[m]=!0}else if(xl.Vo(n.i,xl.Tn(n.i,r,u))&&(l[++g]=i,H[i]=i,f[i]=!1,j.a[i]=!0,(6==xl.Qk(n.i,i)&&0==xl.In(n.i,i)||7==xl.Qk(n.i,i)&&1==xl.zk(n.i,i)||14==xl.Qk(n.i,i)||15==xl.Qk(n.i,i)&&xl.Sn(n.i,i)>2||16==xl.Qk(n.i,i)&&xl.Sn(n.i,i)>2)&&xl.Sn(n.i,i)>2)){for(o=!1,b=1;b<xl.Sn(n.i,i);b++)if(A=xl.Rn(n.i,i,b),!j.a[A])for(D=0;D<b;D++)C=xl.Rn(n.i,i,D),j.a[C]||xl.Ng(n,A,C)&&(l[++g]=A,H[A]=C,H[C]=-2,f[A]=!1,j.a[A]=!0,j.a[C]=!0,o=!0);if(!o)return null}}else{for(s=vf(kl.Cwb,nn,6,xl.Sn(n.i,r),16,1),d=0;d<xl.Sn(n.i,r);d++)if(i=xl.Rn(n.i,r,d),j.a[i])s[d]=H[i]==i;else for(b=0;b<xl.Sn(n.i,i);b++)if(xl.Rn(n.i,i,b)==H[r]){s[d]=!0;break}for(c=0;c<xl.Sn(n.i,r);c++)if(s[c])if(i=xl.Rn(n.i,r,c),j.a[i]){if(-1==xl.Pn(n.i,i,H[r]))return null}else l[++g]=i,H[i]=i,h[i]=!1,f[i]=!0,j.a[i]=!0;for(u=0;u<xl.Sn(n.i,r);u++)if(!s[u]&&(i=xl.Rn(n.i,r,u),!j.a[i])){if(-1==(m=xl.Jg(n,i,H[r],j.a)))return null;l[++g]=i,H[i]=m,H[m]=-2,f[i]=!1,j.a[i]=!0,j.a[m]=!0}}++a}return j},xl.Vg=function(n,t,e,i,s,a,r,o,l,f){this.i=n,this.a=t,this.f=e,this.o=i,this.c=s,this.k=a,this.j=r,this.p=o,this.d=l,this.n=f,xl.Ig(this)},xl.Wg=function(n,t){var e,i;for(i=vf(kl.llb,z,6,null==n?1:n.length+1,15,1),e=0;e<i.length-1;e++)i[e]=n[e];return i[i.length-1]=t,i},zf(492,1,{},xl.Vg),kl.Blb=lg(492),xl.Xg=function(n,t){var e,i,s,a,r,o;for(s=0;s<n.b;s++)if(n.e[s][t]&&-3!=n.c[s])for(i=0;i<=n.j.g.length;i++)if(i!=t&&n.e[s][i])for(n.e[s][t]=!1,o=s<n.a?s:s<n.b?s-n.a:-1,r=xl.gh(n,s<n.a?1:s<n.b?2:0),a=0;a<n.j.g[t].length;a++)e=n.j.g[t][a],xl.Kg(n.j,e)&&n.j.j[e]==o&&(n.j.j[e]=r<<24>>24)},xl.Yg=function(n,t,e){var i,s,a,r,o;for(o=!1,r=1,t[e]=r,i=!0;i;){for(i=!1,s=0;s<n.b;s++)if(t[s]==r)for(a=0;a<n.b;a++)0==t[a]&&xl.fh(n,s,a)&&(-2==n.c[a]?(t[a]=r+1,i=!0):n.c[a]!=n.c[e]&&(t[a]=r+1,o=!0));++r}return o},xl.Zg=function(n,t,e,i){var s,a,r,o,l,f,g,u,d,c,h;for(l=i+1;l<n.j.g.length;l++)if(l!=i&&n.e[t][l]&&n.e[e][l])return(r=vf(kl.llb,z,6,2,15,1))[0]=e,r[1]=t,r;for(h=vf(kl.llb,z,6,n.b,15,1),g=vf(kl.llb,z,6,n.b,15,1),a=0,u=0,(f=vf(kl.llb,z,6,n.b,15,1))[0]=t,g[t]=1;a<=u;){for(d=0;d<n.d[f[a]].length;d++){if((s=n.d[f[a]][d])==e){if(0==a)continue;for(o=g[f[a]]+1,(r=vf(kl.llb,z,6,o,15,1))[0]=s,r[1]=f[a],c=2;c<o;c++)r[c]=h[r[c-1]];return r}0==g[s]&&-3!=n.c[s]&&(g[s]=g[f[a]]+1,f[++u]=s,h[s]=f[a])}++a}return null},xl.$g=function(n,t){var e;for(e=0;e<n.b;e++)if(n.e[e][t]&&-3==n.c[e])return e<n.a?e:e<n.b?e-n.a:-1;return-1},xl._g=function(n,t){var e,i;for(e=0,i=0;i<n.b;i++)n.e[i][t]&&-3==n.c[i]&&++e;return e},xl.ah=function(n,t){var e;for(e=0;e<n.b;e++)if(n.e[e][t]&&-3==n.c[e])return e<n.a?1:e<n.b?2:0;return-1},xl.bh=function(n,t){return t<n.a?t:t<n.b?t-n.a:-1},xl.dh=function(n,t){return t<n.a?1:t<n.b?2:0},xl.eh=function(n,t){var e,i;return i=n.j.k[t],e=n.j.j[t],0==i?n.b:1==i?e:n.a+e},xl.fh=function(n,t,e){var i;for(i=0;i<n.j.g.length;i++)if(n.e[t][i]&&n.e[e][i])return!0;return!1},xl.gh=function(n,t){return 1==t?n.a+n.f++:n.i+n.g++},xl.hh=function(n,t){var e,i,s,a,r,o,l,f,g,u;for(g=I,l=-1,u=-1,f=-1,i=0;i<n.j.i.f;i++)if(xl.Kg(n.j,i)&&0!=n.j.k[i])for(o=0;o<t.length;o++)s=xl.bh(n,t[o]),a=xl.dh(n,t[o]),n.j.k[i]==a&&n.j.j[i]==s&&g>n.j.a[i]+(1==a?J:0)&&(g=n.j.a[i]+(1==a?J:0),l=s,u=a,f=t[o]);for(e=0;e<n.j.i.f;e++)xl.Kg(n.j,e)&&n.j.k[e]==u&&n.j.j[e]==l&&(n.j.k[e]=0,n.j.j[e]=-1);for(r=0;r<n.j.g.length;r++)n.e[f][r]=!1},xl.ih=function(n){var t,e,i,s,a,r,o,l,f,g,u,d,c,h,b,D;for(this.j=n,i=0;i<n.i.f;i++)n.f[i]&&(1==n.o[i]||2==n.o[i])&&(1==n.k[i]?this.a<=n.j[i]&&(this.a=1+n.j[i]):2==n.k[i]&&this.i<=n.j[i]&&(this.i=1+n.j[i]));for(this.b=this.a+this.i,this.e=Yf(kl.Cwb,[j,nn],[12,6],16,[this.b+1,n.g.length+1],2),s=0;s<n.i.f;s++)n.f[s]&&(1==n.o[s]||2==n.o[s])&&!n.e[s]&&(this.e[xl.eh(this,s)][n.g.length]=!0);for(l=0;l<n.g.length;l++)for(D=0;D<n.g[l].length;D++)e=n.g[l][D],n.f[e]&&(1==n.o[e]||2==n.o[e])&&(this.e[xl.eh(this,e)][l]=!0);for(this.d=vf(kl.llb,ot,8,this.b,0,2),f=0;f<n.g.length;f++)for(c=1;c<this.b;c++)if(this.e[c][f])for(h=0;h<c;h++)this.e[h][f]&&(this.d[c]=xl.Wg(this.d[c],h),this.d[h]=xl.Wg(this.d[h],c));for(this.c=vf(kl.llb,z,6,this.b+1,15,1),d=0;d<this.b;d++)this.e[d][n.g.length]?this.c[d]=-1:this.c[d]=-2;for(g=0;g<n.g.length;g++)if(this.e[this.b][g])for(u=0;u<this.b;u++)this.e[u][g]&&this.c[u]!=g&&(-2==this.c[u]?this.c[u]=g:this.c[u]=-3);for(t=0;t<this.b;t++)if(this.c[t]>=-1&&(a=vf(kl.llb,z,6,this.b,15,1),xl.Yg(this,a,t)))for(u=0;u<this.b;u++)0!=a[u]&&(this.c[u]=-3);for(o=0;o<n.g.length-1;o++)for(c=1;c<this.b;c++)if(this.e[c][o]&&-3!=this.c[c])for(h=0;h<c;h++)if(this.e[h][o]&&-3!=this.c[h]&&null!=(r=xl.Zg(this,c,h,o))){for(b=0;b<r.length;b++)this.c[r[b]]=-3;xl.hh(this,r);break}},zf(493,1,{},xl.ih),o.a=0,o.b=0,o.f=0,o.g=0,o.i=0,kl.Alb=lg(493),xl.jh=function(t,e){var i,s;if(null==t)return null==e?0:1;if(null==e)return-1;for(i=n.Math.min(t.length,e.length),s=0;s<i;s++)if((t[s]&$n)!=(e[s]&$n))return(t[s]&$n)<(e[s]&$n)?-1:1;return t.length==e.length?0:t.length<e.length?-1:1},xl.kh=function(){},zf(494,1,{},xl.kh),o.Db=function(n,t){return xl.jh(n,t)},o.ib=function(n){return this===n},kl.Clb=lg(494),xl.nh=function(n,t){switch(t){case 0:return xl.oh(n,!1);case 1:return xl.qh(n);case 2:return xl.ph(n);case 3:return xl.sh(n);case 4:return xl.rh(n)}return null},xl.oh=function(n,t){try{return t?(n=xl.ru(n),xl.kp(n,!0),xl.Dq(n),xl.Nf(new xl.hg(n))):xl.Nf(new xl.hg(n))}catch(n){if(_f(n=rg(n),28))return Jl.oIb(),null;throw og(n)}},xl.ph=function(n){var t,e;try{for(n=xl.ru(n),xl.Bu(n),t=n.r,e=0;e<t;e++)n.H[e]=1,n.T=0;return xl.Nf(new xl.hg(n))}catch(n){if(_f(n=rg(n),28))return Jl.oIb(),null;throw og(n)}},xl.qh=function(n){try{return n=xl.ru(n),xl.Bu(n),xl.Nf(new xl.hg(n))}catch(n){if(_f(n=rg(n),28))return Jl.oIb(),null;throw og(n)}},xl.rh=function(n){var t;try{return n=xl.ru(n),xl.Bu(n),t=xl.Tu(new xl.Wu(n)),xl.Nf(new xl.ig(t,8))}catch(n){if(_f(n=rg(n),28))return Jl.oIb(),null;throw og(n)}},xl.sh=function(n){var t;try{return t=xl.Tu(new xl.Wu(n)),xl.Nf(new xl.ig(t,8))}catch(n){if(_f(n=rg(n),28))return Jl.oIb(),null;throw og(n)}},xl.th=function(n){var t,e,i,s;for(i=n.g.a.length+n.f.a.length,s=0,t=0;t<i;t++)(e=t<n.g.a.length?Fl.Xi(n.g,t):Fl.Xi(n.f,t-n.g.a.length)).q>1&&(s+=xl.Sk(e,e.q,e.r,(xl.Sj(),xl.Rj)));return i>0?s/i:0},xl.uh=function(t){var e,i,s,a,r,o,l;if(a=Ht,o=Ht,r=jt,l=jt,!t)return null;for(s=t.q,0,e=xl.Sk(t,t.q,t.r,(xl.Sj(),xl.Rj)),i=0;i<s;i++)a=n.Math.max(a,t.J[i].a),r=n.Math.min(r,t.J[i].a),o=n.Math.max(o,t.J[i].b),l=n.Math.min(l,t.J[i].b);return s>0?new Kl.KG(r,l,n.Math.max(a-r,e),n.Math.max(o-l,e)):null},xl.vh=function(n){var t,e,i;if(0==n.length)return new Kl.KG(0,0,0,0);for(e=xl.uh(n[0]),t=1;t<n.length;t++)(i=xl.uh(n[t]))&&(e=e?Kl.IG(e,xl.uh(n[t])):i);return!e&&(e=new Kl.KG(0,0,0,0)),e},xl.wh=function(n){var t,e;for(e=vf(kl.Jlb,mt,97,n.f.a.length,0,1),t=0;t<e.length;t++)e[t]=Fl.Xi(n.f,t);return e},xl.xh=function(n){var t,e;for(e=vf(kl.Jlb,mt,97,n.g.a.length,0,1),t=0;t<e.length;t++)e[t]=Fl.Xi(n.g,t);return e},xl.yh=function(t,e,i,s){var a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T;if(e>2*s){for(D=xl.xh(t),c=xl.wh(t),C=0,A=0,u=t.g.a.length+t.f.a.length,f=0;f<u;f++)(g=f<t.g.a.length?Fl.Xi(t.g,f):Fl.Xi(t.f,f-t.g.a.length)).q>1&&(h=xl.uh(g))&&(A+=h.a,C+=h.b);if(0==A||0==C)return;m=H=e/C,H>(j=i/A)&&(m=j),a=xl.th(t),T=(e-s)/2,l=i,m=n.Math.min(24/a,m),xl.vh(D),xl.Ah(D,0,0,m),r=0-(b=xl.vh(D)).c+(T-b.b)/2,o=0-b.d+(l-b.a)/2,xl.Ah(D,r,o,1),xl.vh(c),xl.Ah(c,0,0,m),r=T+s-(d=xl.vh(c)).c+(T-d.b)/2,o=0-d.d+(l-d.a)/2,xl.Ah(c,r,o,1)}},xl.zh=function(n,t,e,i){var s,a;for(s=n.q,a=0;a<s;a++)xl.sm(n,a,(n.J[a].a+t)*i),xl.tm(n,a,(n.J[a].b+e)*i)},xl.Ah=function(n,t,e,i){var s,a,r,o;for(r=0,o=(a=n).length;r<o;++r)s=a[r],xl.zh(s,t,e,i)},xl.Bh=function(n,t,e,i){n.a+=t,n.b+=e,n.c+=i},xl.Ch=function(n,t){return n.a+=t.a,n.b+=t.b,n.c+=t.c,n},xl.Dh=function(n,t){return new xl.Sh(n.a+t.a,n.b+t.b,n.c+t.c)},xl.Eh=function(n,t){return n.a=(n.a+t.a)/2,n.b=(n.b+t.b)/2,n.c=(n.c+t.c)/2,n},xl.Fh=function(n,t){return n.a!=t.a?n.a<t.a?-1:1:n.b!=t.b?n.b<t.b?-1:1:n.c!=t.c?n.c<t.c?-1:1:0},xl.Gh=function(n,t){return new xl.Sh(n.b*t.c-n.c*t.b,-(n.a*t.c-n.c*t.a),n.a*t.b-n.b*t.a)},xl.Hh=function(t,e){return n.Math.sqrt((e.a-t.a)*(e.a-t.a)+(e.b-t.b)*(e.b-t.b)+(e.c-t.c)*(e.c-t.c))},xl.Ih=function(t,e){var i;return!(null==e||!_f(e,32))&&(i=e,n.Math.abs(i.a-t.a)+n.Math.abs(i.b-t.b)+n.Math.abs(i.c-t.c)<1e-6)},xl.Jh=function(t,e){var i,s,a;return s=t.a*t.a+t.b*t.b+t.c*t.c,a=e.a*e.a+e.b*e.b+e.c*e.c,0==s||0==a||(i=(t.a*e.a+t.b*e.b+t.c*e.c)/n.Math.sqrt(s*a))>=1?0:i<=-1?rn:n.Math.acos(i)},xl.Kh=function(n,t){var e,i,s;return e=n.a,i=n.b,s=n.c,n.a=e*t[0][0]+i*t[1][0]+s*t[2][0],n.b=e*t[0][1]+i*t[1][1]+s*t[2][1],n.c=e*t[0][2]+i*t[1][2]+s*t[2][2],n},xl.Lh=function(n,t){return n.a*=t,n.b*=t,n.c*=t,n},xl.Mh=function(n,t,e,i){n.a=t,n.b=e,n.c=i},xl.Nh=function(n,t){return xl.Mh(n,t.a,t.b,t.c),n},xl.Oh=function(n,t){return n.a-=t.a,n.b-=t.b,n.c-=t.c,n},xl.Ph=function(n,t){return new xl.Sh(n.a-t.a,n.b-t.b,n.c-t.c)},xl.Qh=function(t){var e;return 0==(e=n.Math.sqrt(t.a*t.a+t.b*t.b+t.c*t.c))?(Jl.oIb(),t.a=1,t.b=0,t.c=0,t):(t.a/=e,t.b/=e,t.c/=e,t)},xl.Rh=function(){},xl.Sh=function(n,t,e){this.a=n,this.b=t,this.c=e},xl.Th=function(n){xl.Sh.call(this,n.a,n.b,n.c)},zf(32,1,{32:1,4:1,18:1},xl.Rh,xl.Sh,xl.Th),o.Eb=function(n){return xl.Fh(this,n)},o.ib=function(n){return xl.Ih(this,n)},o.lb=function(){var n;return n=new Jf.SKb("0.00"),"["+Jf.QKb(n,this.a)+", "+Jf.QKb(n,this.b)+", "+Jf.QKb(n,this.c)+"]"},o.a=0,o.b=0,o.c=0,kl.Elb=lg(32),xl.Xh=function(n,t){t.c*=n.c,t.a=t.a*n.c+n.a,t.b=t.b*n.c+n.b},xl.Yh=function(n,t){xl.Zl(t,n.c),xl.Um(t,n.a,n.b)},xl.Zh=function(n,t){t.a=t.a*n.c+n.a,t.b=t.b*n.c+n.b},xl.$h=function(n,t){t.c=t.c*n.c+n.a,t.d=t.d*n.c+n.b,t.b*=n.c,t.a*=n.c},xl._h=function(n){n.a=0,n.b=0,n.c=1},xl.ai=function(n){return 1==n.c&&0==n.a&&0==n.b},xl.bi=function(n,t){return t*n.c+n.a},xl.ci=function(n,t){return t*n.c+n.b},xl.di=function(){xl._h(this)},xl.ei=function(n,t){this.c=1,this.a=n,this.b=t},xl.fi=function(t,e,i,s){var a,r,o,l;xl._h(this),e?0==(s&ut)?Kl.FG(e,t.c,t.d)&&Kl.FG(e,t.c+t.b,t.d+t.a)||((t.b>e.b||t.a>e.a)&&(r=e.b/t.b,l=e.a/t.a,this.c=n.Math.min(r,l)),t.c*this.c<e.c?this.a=e.c-t.c*this.c:(t.c+t.b)*this.c>e.c+e.b&&(this.a=e.c+e.b-(t.c+t.b)*this.c),t.d*this.c<e.d?this.b=e.d-t.d*this.c:(t.d+t.a)*this.c>e.d+e.a&&(this.b=e.d+e.a-(t.d+t.a)*this.c)):(r=e.b/t.b,l=e.a/t.a,0==(o=s&y)?o=24:0!=(s&gt)&&(o/=256),a=o/i,this.c=n.Math.min(a,n.Math.min(r,l)),this.a=e.c+e.b/2-this.c*(t.c+t.b/2),this.b=e.d+e.a/2-this.c*(t.d+t.a/2)):0!=(s&J)&&(o=0!=(s&y)?s&y:24,this.c=o/i)},zf(106,1,{},xl.di,xl.ei,xl.fi),o.lb=function(){return"DepictorTransformation Offset: "+this.a+","+this.b+" Scaling: "+this.c},o.a=0,o.b=0,o.c=0,kl.Flb=lg(106),xl.hi=function(n){var t,e,i,s;return Jl.DHb(Rl.LTb(n).substr(0,21),tt)&&(i=Rl.LTb(et).length,Jl.DHb(Rl.LTb(n).substr(Rl.LTb(n).length-i,i),et))?-1==(e=Jl.IHb(n,bg(34),21))?null:(Rl.FTb(21,e,Rl.LTb(n).length),s=Rl.LTb(n).substr(21,e-21),t=Jl.RHb(n,21+Rl.LTb(s).length+1,Rl.LTb(n).length-17),Jl.DHb(s,"arrow")?new Ol.IF(t):Jl.DHb(s,At)?new xl.jv(t):null):null},Fl.ii=function(n,t,e){var i,s;for(s=n.Fb();s.Fd();)if(i=s.Gd(),sg(t)===sg(i)||null!=t&&Jl.Gc(t,i))return e&&s.Hd(),!0;return!1},Fl.ji=function(n,t){var e,i;for(Rl.ATb(t),i=t.Fb();i.Fd();)if(e=i.Gd(),!n.contains(e))return!1;return!0},Fl.ki=function(n,t){var e,i,s;for(Rl.ATb(t),e=!1,i=n.Fb();i.Fd();)s=i.Gd(),t.contains(s)&&(i.Hd(),e=!0);return e},Fl.li=function(n){var t,e,i;for(i=new Fl.YQb("[","]"),e=n.Fb();e.Fd();)t=e.Gd(),Fl.WQb(i,sg(t)===sg(n)?"(this Collection)":null==t?M:xf(t));return i.a?0==Rl.LTb(i.e).length?i.a.a:i.a.a+""+i.e:i.c},zf(60,1,Ct),o.add=function(n){throw og(new Jl.sIb("Add not supported on this collection"))},o.addAll=function(n){var t,e,i;for(Rl.ATb(n),t=!1,i=n.Fb();i.Fd();)e=i.Gd(),t|=this.add(e);return t},o.clear=function(){var n;for(n=this.Fb();n.Fd();)n.Gd(),n.Hd()},o.contains=function(n){return Fl.ii(this,n,!1)},o.containsAll=function(n){return Fl.ji(this,n)},o.isEmpty=function(){return 0==this.size()},o.remove=function(n){return Fl.ii(this,n,!0)},o.removeAll=function(n){return Fl.ki(this,n)},o.retainAll=function(n){var t,e,i;for(Rl.ATb(n),t=!1,e=this.Fb();e.Fd();)i=e.Gd(),n.contains(i)||(e.Hd(),t=!0);return t},o.toArray=function(){return this.Gb(vf(kl.Iub,N,1,this.size(),5,1))},o.Gb=function(n){var t,e,i,s;for(s=this.size(),n.length<s&&(n=Rl.gTb(new Array(s),n)),i=n,e=this.Fb(),t=0;t<s;++t)Of(i,t,e.Gd());return n.length>s&&kl.Vjb(n,s,null),n},o.lb=function(){return Fl.li(this)},kl.Xub=lg(60),Fl.yi=function(n){return new Fl.qMb(n,0)},Fl.zi=function(n,t){return new Fl.qMb(n,t)},Fl.Ai=function(n,t,e){return new Fl.uMb(n,t,e)},zf(104,60,Tt),o.addAtIndex=function(n,t){throw og(new Jl.sIb("Add not supported on this list"))},o.add=function(n){return this.addAtIndex(this.size(),n),!0},o.addAllAtIndex=function(n,t){var e,i,s;for(Rl.ATb(t),e=!1,s=t.Fb();s.Fd();)i=s.Gd(),this.addAtIndex(n++,i),e=!0;return e},o.clear=function(){this.Jb(0,this.size())},o.ib=function(n){var t,e,i,s,a;if(n===this)return!0;if(!_f(n,121))return!1;if(a=n,this.size()!=a.size())return!1;for(s=a.Fb(),e=this.Fb();e.Fd();)if(t=e.Gd(),i=s.Gd(),!(sg(t)===sg(i)||null!=t&&Jl.Gc(t,i)))return!1;return!0},o.kb=function(){return Fl.cPb(this)},o.indexOf=function(n){var t,e;for(t=0,e=this.size();t<e;++t)if(Fl.KQb(n,this.getAtIndex(t)))return t;return-1},o.Fb=function(){return new Fl.kMb(this)},o.lastIndexOf=function(n){var t;for(t=this.size()-1;t>-1;--t)if(Fl.KQb(n,this.getAtIndex(t)))return t;return-1},o.Hb=function(){return Fl.yi(this)},o.Ib=function(n){return Fl.zi(this,n)},o.removeAtIndex=function(n){throw og(new Jl.sIb("Remove not supported on this list"))},o.Jb=function(n,t){var e,i;for(i=new Fl.qMb(this,n),e=n;e<t;++e)Rl.yTb(i.b<i.d.size()),i.d.getAtIndex(i.c=i.b++),Fl.jMb(i)},o.setAtIndex=function(n,t){throw og(new Jl.sIb("Set not supported on this list"))},o.subList=function(n,t){return Fl.Ai(this,n,t)},kl.cvb=lg(104),Fl.Qi=function(n){n.a=vf(kl.Iub,N,1,0,5,1)},Fl.Ri=function(n,t,e){Rl.CTb(t,n.a.length),Rl._Sb(n.a,t,e)},Fl.Si=function(n,t){return Rl.cTb(n.a,t),!0},Fl.Ti=function(n,t,e){var i;return Rl.CTb(t,n.a.length),0!=(i=e.toArray()).length&&(Rl.aTb(n.a,t,i),!0)},Fl.Ui=function(n,t){var e;return 0!=(e=t.toArray()).length&&(Rl.aTb(n.a,n.a.length,e),!0)},Fl.Vi=function(n){Rl.eTb(n.a,0)},Fl.Wi=function(n,t){return-1!=Fl.Zi(n,t,0)},Fl.Xi=function(n,t){return Rl.zTb(t,n.a.length),n.a[t]},Fl.Yi=function(n,t){return Fl.Zi(n,t,0)},Fl.Zi=function(n,t,e){for(;e<n.a.length;++e)if(Fl.KQb(t,n.a[e]))return e;return-1},Fl.$i=function(n){return 0==n.a.length},Fl._i=function(n){return new Fl.rOb(n)},Fl.aj=function(n,t){return Fl.bj(n,t,n.a.length-1)},Fl.bj=function(n,t,e){for(;e>=0;--e)if(Fl.KQb(t,n.a[e]))return e;return-1},Fl.cj=function(n,t){var e;return Rl.zTb(t,n.a.length),e=n.a[t],Rl.dTb(n.a,t,1),e},Fl.dj=function(n,t){var e;return-1!=(e=Fl.Zi(n,t,0))&&(Fl.cj(n,e),!0)},Fl.ej=function(n,t,e){var i;Rl.DTb(t,e,n.a.length),i=e-t,Rl.dTb(n.a,t,i)},Fl.fj=function(n,t,e){var i;return Rl.zTb(t,n.a.length),i=n.a[t],n.a[t]=e,i},Fl.gj=function(n){return n.a.length},Fl.hj=function(n,t){Fl.QOb(n.a,n.a.length,t)},Fl.ij=function(n){return Rl.YSb(n.a)},Fl.jj=function(n,t){var e,i;for(i=n.a.length,t.length<i&&(t=Rl.gTb(new Array(i),t)),e=0;e<i;++e)Of(t,e,n.a[e]);return t.length>i&&kl.Vjb(t,i,null),t},Fl.kj=function(){Fl.Qi(this)},Fl.lj=function(n){Fl.Qi(this),Rl.uTb(n>=0,"Initial capacity must not be negative")},zf(21,104,pt,Fl.kj,Fl.lj),o.addAtIndex=function(n,t){Fl.Ri(this,n,t)},o.add=function(n){return Fl.Si(this,n)},o.addAllAtIndex=function(n,t){return Fl.Ti(this,n,t)},o.addAll=function(n){return Fl.Ui(this,n)},o.clear=function(){Fl.Vi(this)},o.contains=function(n){return Fl.Wi(this,n)},o.getAtIndex=function(n){return Fl.Xi(this,n)},o.indexOf=function(n){return Fl.Yi(this,n)},o.isEmpty=function(){return Fl.$i(this)},o.Fb=function(){return Fl._i(this)},o.lastIndexOf=function(n){return Fl.aj(this,n)},o.removeAtIndex=function(n){return Fl.cj(this,n)},o.remove=function(n){return Fl.dj(this,n)},o.Jb=function(n,t){Fl.ej(this,n,t)},o.setAtIndex=function(n,t){return Fl.fj(this,n,t)},o.size=function(){return Fl.gj(this)},o.toArray=function(){return Fl.ij(this)},o.Gb=function(n){return Fl.jj(this,n)},kl.tvb=lg(21),xl.Ej=function(n){var t,e;for(e=new Jl._Hb,t=0;t<n.a.length;t++)Jl.$Hb(e,xl.$d((Rl.zTb(t,n.a.length),n.a[t]))+H);return e.a},xl.Fj=function(n){var t;Fl.kj.call(this);try{if(n)for(t=0;t<n.a.length;t++)Fl.Si(this,(Rl.zTb(t,n.a.length),n.a[t]).Ab())}catch(n){if(!_f(n=rg(n),19))throw og(n)}},xl.Gj=function(n){var t,e,i;if(Fl.kj.call(this),null!=n&&0!=Rl.LTb(n).length)for(t=0,e=Jl.HHb(n,bg(10));-1!=e;)(i=xl.hi((Rl.FTb(t,e,Rl.LTb(n).length),Rl.LTb(n).substr(t,e-t))))&&Rl.cTb(this.a,i),t=e+1,e=Jl.IHb(n,bg(10),t)},zf(247,21,pt,xl.Fj,xl.Gj),o.lb=function(){return xl.Ej(this)},kl.Glb=lg(247),xl.Ij=function(n,t,e,i){this.b=n,this.a=t,this.c=e,this.d=i},zf(125,1,{125:1},xl.Ij),o.a=0,o.b=0,o.c=0,o.d=0,kl.Hlb=lg(125),xl.Jj=function(n){var t,e,i,s,a,r;if(0!=n.j)return n.j;if(n.i&&15!=xl.Qk(n.e,n.a)&&16!=xl.Qk(n.e,n.a))for(r=0;r<xl.Dn(n.e,n.a);r++)if(a=xl.Tn(n.e,n.a,r),xl.Ml(n.e,a,n.a))return xl.Rn(n.e,n.a,r)==n.b?n.j=257==xl.el(n.e,a)?3:1:n.j=257==xl.el(n.e,a)?1:3,n.j;return t=xl.Uk(n.e,n.a,n.g),(i=xl.Uk(n.e,n.a,n.b))<t&&(i+=an),2==xl.Dn(n.e,n.a)?(e=i-t)>3.0915926535897933&&e<3.191592653589793?(n.j=-1,n.j):(n.j=e<rn?4:2,n.j):((s=xl.Uk(n.e,n.a,n.d))<t&&(s+=an),n.j=s<i?2:4,n.j)},xl.Kj=function(n,t,e,i){var s,a,r,o;for(this.e=n,this.g=e,this.a=i,r=-1,o=0;o<xl.Dn(this.e,this.a);o++)s=xl.Rn(this.e,this.a,o),a=xl.Tn(this.e,this.a,o),s!=this.g?(xl.Ml(this.e,a,this.a)&&(this.i&&(n.u[i]|=J),this.i=!0),r==t[s]?(this.d=s,this.f=!0,this.c=xl.Vo(this.e,a)):r<t[s]?(r=t[s],this.d=this.b,this.b=s):this.d=s):386==xl.el(this.e,a)&&(this.j=-1)},zf(143,1,{},xl.Kj),o.a=0,o.b=0,o.c=!1,o.d=0,o.f=!1,o.g=0,o.i=!1,o.j=0,kl.Ilb=lg(143),xl.Sj=function(){xl.Sj=Sf,xl.Mj=Vf(qf(kl.Oub,1),k,2,6,["?","H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og",It,It,It,It,It,It,It,It,It,It,"R4","R5","R6","R7","R8","R9","R10","R11","R12","R13","R14","R15","R16","R1","R2","R3","A","A1","A2","A3",It,It,"D","T","X","R","H2","H+","Nnn","HYD","Pol",It,It,It,It,It,It,It,It,It,It,It,"Ala","Arg","Asn","Asp","Cys","Gln","Glu","Gly","His","Ile","Leu","Lys","Met","Phe","Pro","Ser","Thr","Trp","Tyr","Val"]),xl.Qj=Vf(qf(kl.Bwb,1),it,6,15,[0,1,4,7,9,11,12,14,16,19,20,23,24,27,28,31,32,35,40,39,40,45,48,51,52,55,56,59,58,63,64,69,74,75,80,79,84,85,88,89,90,93,98,0,102,103,106,107,114,115,120,121,130,127,132,133,138,139,140,141,142,0,152,153,158,159,164,165,166,169,174,175,180,181,184,187,192,193,195,197,202,205,208,209,209,210,222,223,226,227,232,231,238,237,244,243,247,247,251,252,257,258,259,262,267,268,271,270,277,276,281,281,283,285,289,289,293,294,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,156,114,115,103,128,129,57,137,113,113,128,131,147,97,87,101,186,163,99]),xl.Pj=Vf(qf(kl.hlb,1),ft,6,15,[6]),xl.Lj=Vf(qf(kl.hlb,1),ft,6,15,[2]),xl.Nj=Vf(qf(kl.hlb,2),j,10,0,[null,Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[0]),Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[4]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[0]),Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[4]),Vf(qf(kl.hlb,1),ft,6,15,[3,5]),Vf(qf(kl.hlb,1),ft,6,15,[2,4,6]),Vf(qf(kl.hlb,1),ft,6,15,[1,3,5,7]),Vf(qf(kl.hlb,1),ft,6,15,[0]),Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),null,null,null,null,null,null,null,null,null,null,Vf(qf(kl.hlb,1),ft,6,15,[2,3]),Vf(qf(kl.hlb,1),ft,6,15,[2,4]),Vf(qf(kl.hlb,1),ft,6,15,[3,5]),Vf(qf(kl.hlb,1),ft,6,15,[2,4,6]),Vf(qf(kl.hlb,1),ft,6,15,[1,3,5,7]),Vf(qf(kl.hlb,1),ft,6,15,[0,2]),Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),null,null,null,null,null,null,null,null,null,null,Vf(qf(kl.hlb,1),ft,6,15,[1,2,3]),Vf(qf(kl.hlb,1),ft,6,15,[2,4]),Vf(qf(kl.hlb,1),ft,6,15,[3,5]),Vf(qf(kl.hlb,1),ft,6,15,[2,4,6]),Vf(qf(kl.hlb,1),ft,6,15,[1,3,5,7]),Vf(qf(kl.hlb,1),ft,6,15,[0,2,4,6]),Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[2])]),xl.Oj=Vf(qf(kl.hlb,2),j,10,0,[null,Vf(qf(kl.hlb,1),ft,6,15,[1]),null,Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),null,null,Vf(qf(kl.hlb,1),ft,6,15,[-3]),Vf(qf(kl.hlb,1),ft,6,15,[-2]),Vf(qf(kl.hlb,1),ft,6,15,[-1]),null,Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[3]),null,Vf(qf(kl.hlb,1),ft,6,15,[-3]),Vf(qf(kl.hlb,1),ft,6,15,[-2]),Vf(qf(kl.hlb,1),ft,6,15,[-1]),null,Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[2,3,4]),Vf(qf(kl.hlb,1),ft,6,15,[2,3,4,5]),Vf(qf(kl.hlb,1),ft,6,15,[2,3,6]),Vf(qf(kl.hlb,1),ft,6,15,[2,3,4,7]),Vf(qf(kl.hlb,1),ft,6,15,[2,3]),Vf(qf(kl.hlb,1),ft,6,15,[2,3]),Vf(qf(kl.hlb,1),ft,6,15,[2,3]),Vf(qf(kl.hlb,1),ft,6,15,[1,2]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[2,4]),Vf(qf(kl.hlb,1),ft,6,15,[-3,3,5]),Vf(qf(kl.hlb,1),ft,6,15,[-2]),Vf(qf(kl.hlb,1),ft,6,15,[-1]),null,Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[4]),Vf(qf(kl.hlb,1),ft,6,15,[3,5]),Vf(qf(kl.hlb,1),ft,6,15,[6]),Vf(qf(kl.hlb,1),ft,6,15,[4,6,7]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[2,4]),Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[2,4]),Vf(qf(kl.hlb,1),ft,6,15,[-3,3,5]),Vf(qf(kl.hlb,1),ft,6,15,[-2,4,6]),Vf(qf(kl.hlb,1),ft,6,15,[-1]),null,Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3,4]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[2,3]),Vf(qf(kl.hlb,1),ft,6,15,[2,3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[2,3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[4]),Vf(qf(kl.hlb,1),ft,6,15,[5]),Vf(qf(kl.hlb,1),ft,6,15,[6]),Vf(qf(kl.hlb,1),ft,6,15,[4,6,7]),Vf(qf(kl.hlb,1),ft,6,15,[3,4]),Vf(qf(kl.hlb,1),ft,6,15,[3,4]),Vf(qf(kl.hlb,1),ft,6,15,[2,4]),Vf(qf(kl.hlb,1),ft,6,15,[1,3]),Vf(qf(kl.hlb,1),ft,6,15,[1,2]),Vf(qf(kl.hlb,1),ft,6,15,[1,3]),Vf(qf(kl.hlb,1),ft,6,15,[2,4]),Vf(qf(kl.hlb,1),ft,6,15,[3,5]),Vf(qf(kl.hlb,1),ft,6,15,[-2,2,4]),Vf(qf(kl.hlb,1),ft,6,15,[-1,1]),null,Vf(qf(kl.hlb,1),ft,6,15,[1]),Vf(qf(kl.hlb,1),ft,6,15,[2]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[4]),Vf(qf(kl.hlb,1),ft,6,15,[4,5]),Vf(qf(kl.hlb,1),ft,6,15,[3,4,5,6]),Vf(qf(kl.hlb,1),ft,6,15,[3,4,5,6]),Vf(qf(kl.hlb,1),ft,6,15,[3,4,5,6]),Vf(qf(kl.hlb,1),ft,6,15,[3,4,5,6]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3,4]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[3]),Vf(qf(kl.hlb,1),ft,6,15,[2,3]),Vf(qf(kl.hlb,1),ft,6,15,[2,3]),Vf(qf(kl.hlb,1),ft,6,15,[3])])},xl.Tj=function(n,t,e,i){var s;return s=xl.Uj(n,6),xl.Mh(n.J[s],t,e,i),s},xl.Uj=function(n,t){return n.q>=n.M&&xl.Km(n,2*n.M),n.C[n.q]=0,xl.vm(n,n.q,t),n.s[n.q]=0,n.u[n.q]=0,n.B[n.q]=0,n.w[n.q]=0,xl.Mh(n.J[n.q],0,0,0),null!=n.v&&(n.v[n.q]=null),null!=n.t&&(n.t[n.q]=null),n.T=0,n.q++},xl.Vj=function(n,t,e){return xl.Wj(n,t,e,xl.Fl(n,t)||xl.Fl(n,e)?32:1)},xl.Wj=function(n,t,e,i){var s;if(t==e)return-1;for(s=0;s<n.r;s++)if(n.D[0][s]==t&&n.D[1][s]==e||n.D[0][s]==e&&n.D[1][s]==t)return n.H[s]<i&&(n.H[s]=i),s;return n.r>=n.N&&xl.Lm(n,2*n.N),n.D[0][n.r]=t,n.D[1][n.r]=e,n.H[n.r]=i,n.F[n.r]=0,n.G[n.r]=0,n.T=0,n.r++},xl.Xj=function(n,t){return xl.Yj(n,t,t.q,t.r)},xl.Yj=function(n,t,e,i){var s,a,r,o,l;for(n.K=n.K|t.K,a=vf(kl.llb,z,6,t.q,15,1),o=xl.Yl(n,1),l=xl.Yl(n,2),s=0;s<e;s++)a[s]=xl.jk(t,n,s,o,l);for(r=0;r<i;r++)xl.kk(t,n,r,o,l,a[t.D[0][r]],a[t.D[1][r]],!1);return n.L=n.L&&t.L,n.I=0,n.T=0,a},xl.Zj=function(n,t,e,i,s,a,r,o){var l,f;return-1==(l=xl.vk(n,t,e))?(n.q>=n.M&&xl.Km(n,2*n.M),l=xl.Uj(n,i),xl.Mh(n.J[l],t,e,0),n.A[l]=s,xl.am(n,l,a),xl.pm(n,l,r),xl.fm(n,l,o),!0):(f=xl.ek(n,l,i,s,a,r),xl.fm(n,l,o),f)},xl.$j=function(n,t,e,i){var s;for(s=0;s<n.r;s++)if(n.D[0][s]==t&&n.D[1][s]==e||n.D[0][s]==e&&n.D[1][s]==t)return xl.gk(n,s,i),n.T=0,s;return n.r>=n.N&&xl.Lm(n,2*n.N),n.D[0][n.r]=t,n.D[1][n.r]=e,n.H[n.r]=i,n.F[n.r]=0,n.G[n.r]=0,n.T=0,n.r++},xl._j=function(n,t,e,i,s,a){for(var r,o,l;n.q+i>n.M;)xl.Km(n,2*n.M);for(;n.r+i>n.N;)xl.Lm(n,2*n.N);return-1!=(r=xl.vk(n,t,e))?xl.ak(n,r,i,s,a):-1!=(o=xl.wk(n,t,e))?xl.bk(n,o,i,s,a):(r=xl.Tj(n,t,e,0),l=rn*(i-2)/i,xl.Ql(n,r,i,r,s,0,rn-l,a),n.T=0,!0)},xl.ak=function(t,e,i,s,a){var r,o,l,f,g,u;if(s&&xl.ko(t,e)>1||!s&&xl.ko(t,e)>2)return!1;for(o=0,r=vf(kl.jlb,S,6,4,15,1),f=0;f<t.r;f++){for(g=0;g<2;g++)if(t.D[g][f]==e){if(2==o){o=3;break}r[o++]=xl.Uk(t,e,t.D[1-g][f])}if(3==o)break}return 3!=o&&(u=1==o?r[0]+rn:n.Math.abs(r[0]-r[1])>rn?(r[0]+r[1])/2:(r[0]+r[1])/2+rn,l=rn*(i-2)/i,xl.Ql(t,e,i,e,s,u-l/2,rn-l,a),t.T=0,!0)},xl.bk=function(n,t,e,i,s){var a,r,o,l,f,g,u,d,c,h,b;if(f=vf(kl.llb,z,6,2,15,1),l=vf(kl.jlb,S,6,2,15,1),f[0]=n.D[0][t],f[1]=n.D[1][t],xl.ko(n,f[0])>3)return!1;if(xl.ko(n,f[1])>3)return!1;for(r=0,a=vf(kl.jlb,S,6,4,15,1),d=0;d<n.r;d++)if(d!=t){for(c=0;c<2;c++){for(h=0;h<2;h++)if(n.D[c][d]==f[h]){if(4==r){r=5;break}a[r++]=xl.Uk(n,f[h],n.D[1-c][d])}if(5==r)break}if(5==r)break}if(5==r)return!1;for(l[0]=xl.Uk(n,f[0],f[1]),l[0]<0?(l[1]=l[0]+rn,o=0):(l[1]=l[0],l[0]=l[1]-rn,o=1),b=0,u=0;u<r;u++)a[u]>l[0]&&a[u]<l[1]?--b:++b;return o=b>0?1-o:o,g=rn*(e-2)/e,xl.Ql(n,f[o],e-1,f[1-o],i,l[b>0?0:1]+rn-g,rn-g,s),n.T=0,!0},xl.ck=function(n,t,e){var i,s,a,r,o;for(s=vf(kl.llb,z,6,t.q,15,1),r=xl.Yl(n,1),o=xl.Yl(n,2),i=0;i<t.q;i++)0!=t.C[i]?s[i]=xl.jk(t,n,i,r,o):s[i]=e;for(a=0;a<t.r;a++)xl.kk(t,n,a,r,o,s[t.D[0][a]],s[t.D[1][a]],!1);return n.L=n.L&&t.L,n.I=0,n.T=0,s},xl.dk=function(t,e){var i,s,a,r,o,l,f,g,u;return i=t.J[e[0]],s=t.J[e[1]],a=t.J[e[2]],r=t.J[e[3]],f=new xl.Sh(s.a-i.a,s.b-i.b,s.c-i.c),g=new xl.Sh(a.a-s.a,a.b-s.b,a.c-s.c),u=new xl.Sh(r.a-a.a,r.b-a.b,r.c-a.c),o=new xl.Sh(f.b*g.c-f.c*g.b,-(f.a*g.c-f.c*g.a),f.a*g.b-f.b*g.a),l=new xl.Sh(g.b*u.c-g.c*u.b,-(g.a*u.c-g.c*u.a),g.a*u.b-g.b*u.a),-n.Math.atan2(n.Math.sqrt(g.a*g.a+g.b*g.b+g.c*g.c)*(f.a*l.a+f.b*l.b+f.c*l.c),o.a*l.a+o.b*l.b+o.c*l.c)},xl.ek=function(n,t,e,i,s,a){return(1!=e&&151!=e&&152!=e||!(xl.ko(n,t)>1))&&(n.B[t]=Cg(n.B[t],-2),null!=n.v&&(n.v[t]=null),null!=n.t&&(n.t[t]=null),(e!=n.C[t]||i!=n.A[t]||s!=((n.u[t]&Pt)>>>27)-1||a!=(48&n.u[t]))&&(151!=e&&152!=e||(i=e-149,e=1),n.u[t]&=960,n.C[t]=e,n.A[t]=i,n.s[t]=0,n.B[t]=0,xl.am(n,t,s),xl.pm(n,t,a),xl.Wl(n,n.w[t]),n.T=0,!0))},xl.fk=function(n,t,e){if(e){if(n.s[t]>8)return!1;++n.s[t]}else{if(n.s[t]<-8)return!1;--n.s[t]}return n.T=0,!0},xl.gk=function(n,t,e){var i,s,a,r,o;return a=!1,r=n.H[t],511==e?a=xl.nl(n,t):xl.np(n,t,e)&&(257==e||129==e?(i=xl.Rl(n,t,n.D[0][t]),s=xl.Rl(n,t,n.D[1][t]),e==r?(i==s||s)&&(o=n.D[0][t],n.D[0][t]=n.D[1][t],n.D[1][t]=o,a=!0):(!i&&s&&(o=n.D[0][t],n.D[0][t]=n.D[1][t],n.D[1][t]=o),n.H[t]=e,a=!0)):(n.H[t]=e,a=!0)),a&&(n.T=(127&r)==(127&e)?7&n.T:0,n.G[t]=0),a},xl.hk=function(n){n.q=0,n.r=0,n.K=!1,n.L=!1,n.I=0,n.v=null,n.t=null,n.P=null,n.T=0},xl.ik=function(n){var t,e,i,s,a,r,o,l;for(r=0;r<n.r;r++)512==n.H[r]&&(e=n.D[0][r],i=n.D[1][r],-1==n.C[e]^-1==n.C[i]&&0!=n.s[e]&&0!=n.s[i]&&n.s[e]<0^n.s[i]<0&&(n.s[e]<0?(++n.s[e],--n.s[i]):(--n.s[e],++n.s[i])));for(l=vf(kl.llb,z,6,n.q,15,1),s=0,t=0;t<n.q;t++)-1!=n.C[t]?(s<t&&(n.C[s]=n.C[t],n.s[s]=n.s[t],n.A[s]=n.A[t],n.u[s]=n.u[t],n.B[s]=n.B[t],n.w[s]=n.w[t],xl.Nh(n.J[s],n.J[t]),null!=n.v&&(n.v[s]=n.v[t]),null!=n.t&&(n.t[s]=n.t[t])),l[t]=s,++s):l[t]=-1;for(n.q=s,o=0,a=0;a<n.r;a++)512!=n.H[a]&&(n.H[o]=n.H[a],n.F[o]=n.F[a],n.G[o]=n.G[a],n.D[0][o]=l[n.D[0][a]],n.D[1][o]=l[n.D[1][a]],++o);return n.r=o,l},xl.jk=function(t,e,i,s,a){var r,o,l;return(r=e.q)>=e.M&&xl.Km(e,2*e.M),o=-1,1==(l=(t.u[i]&Vn)>>18)?o=-1==s?xl.Yl(e,l):n.Math.min(31,s+((t.u[i]&Vn)>>18!=1&&(t.u[i]&Vn)>>18!=2?-1:(t.u[i]&Mt)>>20)):2==l&&(o=-1==a?xl.Yl(e,l):n.Math.min(31,a+((t.u[i]&Vn)>>18!=1&&(t.u[i]&Vn)>>18!=2?-1:(t.u[i]&Mt)>>20))),e.C[r]=t.C[i],e.s[r]=t.s[i],e.A[r]=t.A[i],e.u[r]=t.u[i],e.B[r]=e.K?t.B[i]:0,xl.Nh(e.J[r],t.J[i]),e.w[r]=t.w[i],null!=e.v&&(e.v[r]=null),null!=t.v&&null!=t.v[i]&&e.K&&(null==e.v&&(e.v=vf(kl.llb,ot,8,e.C.length,0,2)),e.v[r]=Fl.xOb(t.v[i],t.v[i].length)),null!=e.t&&(e.t[r]=null),null!=t.t&&null!=t.t[i]&&(null==e.t&&(e.t=vf(kl.hlb,j,10,e.C.length,0,2)),e.t[r]=Fl.vOb(t.t[i],t.t[i].length)),-1!=o&&(e.u[r]&=-32505857,e.u[r]|=o<<20),++e.q,e.T=0,r},xl.kk=function(t,e,i,s,a,r,o,l){var f,g,u,d;return(g=e.r)>=e.N&&xl.Lm(e,2*e.N),u=-1,1==(d=(768&t.F[i])>>8)&&(u=-1==s?xl.Yl(e,d):n.Math.min(32,s+((768&t.F[i])>>8!=1&&(768&t.F[i])>>8!=2?-1:(t.F[i]&wt)>>10))),2==d&&(u=-1==a?xl.Yl(e,d):n.Math.min(32,a+((768&t.F[i])>>8!=1&&(768&t.F[i])>>8!=2?-1:(t.F[i]&wt)>>10))),e.D[0][g]=r,e.D[1][g]=o,f=l&&t.Lb(i)?64:t.H[i],e.H[g]=f,e.F[g]=t.F[i],e.G[g]=e.K?t.G[i]:0,-1!=u&&(e.F[g]&=-31745,e.F[g]|=u<<10),++e.r,e.T=0,g},xl.lk=function(n,t,e,i,s,a,r){return xl.kk(n,t,e,i,s,null==a?n.D[0][e]:a[n.D[0][e]],null==a?n.D[1][e]:a[n.D[1][e]],r)},xl.mk=function(n,t){var e,i;for(t.v=null,t.t=null,t.K=n.K,t.q=0,e=0;e<n.q;e++)xl.jk(n,t,e,0,0);for(t.r=0,i=0;i<n.r;i++)xl.kk(n,t,i,0,0,n.D[0][i],n.D[1][i],!1);n.Kb(t)},xl.nk=function(n,t){t.K=n.K,t.L=n.L,t.S=n.S,t.I=n.I,t.P=n.P,t.T=24&n.T},xl.ok=function(n,t){var e,i,s,a;for(e=0;e<n.r;e++)for(s=0;s<2;s++)if(n.D[s][e]==t){for(n.H[e]=512,i=0,a=0;a<n.r;a++)a!=e&&(n.D[0][a]===n.D[1-s][e]||n.D[1][a]===n.D[1-s][e])&&++i;0==i&&(xl.Wl(n,n.w[n.D[1-s][e]]),n.C[n.D[1-s][e]]=-1)}xl.Wl(n,n.w[t]),n.C[t]=-1,null!=n.v&&(n.v[t]=null),null!=n.t&&(n.t[t]=null),xl.ik(n),n.T=0},xl.pk=function(n,t,e){var i,s;return-1!=(i=xl.vk(n,t,e))?(0!=(512&n.u[i])?xl.uk(n):xl.ok(n,i),n.T=0,!0):-1!=(s=xl.wk(n,t,e))&&(0!=(n.u[n.D[0][s]]&n.u[n.D[1][s]]&512)?xl.uk(n):xl.sk(n,s),n.T=0,!0)},xl.qk=function(n,t){var e,i,s,a;if(0==t.length)return null;for(s=0,a=(i=t).length;s<a;++s)e=i[s],n.C[e]=-1;return xl.tk(n)},xl.rk=function(n,t){n.H[t]=512,xl.ik(n),n.T=0},xl.sk=function(n,t){var e,i,s;for(i=0;i<2;i++){for(e=0,s=0;s<n.r;s++)s!=t&&(n.D[0][s]===n.D[i][t]||n.D[1][s]===n.D[i][t])&&++e;0==e&&(xl.Wl(n,n.w[n.D[i][t]]),n.C[n.D[i][t]]=-1)}n.H[t]=512,xl.ik(n),n.T=0},xl.tk=function(n){var t,e,i;for(i=!1,t=0;t<n.q;t++)-1==n.C[t]&&(i=!0,xl.Wl(n,n.w[t]));for(e=0;e<n.r;e++)512==n.H[e]?i=!0:-1!=n.C[n.D[0][e]]&&-1!=n.C[n.D[1][e]]||(n.H[e]=512,i=!0);return i?(n.T=0,xl.ik(n)):null},xl.uk=function(n){var t,e;for(e=!1,t=0;t<n.q;t++)0!=(512&n.u[t])&&(n.C[t]=-1,e=!0);return e&&null!=xl.tk(n)},xl.vk=function(n,t,e){var i,s,a,r,o,l,f,g;for(r=-1,s=xl.Sk(n,n.q,n.r,xl.Rj),o=jt,l=s*s/12,i=0;i<n.q;i++)(a=(t-(f=n.J[i].a))*(t-f)+(e-(g=n.J[i].b))*(e-g))<l&&a<o&&(o=a,r=i);return r},xl.wk=function(t,e,i){var s,a,r,o,l,f,g,u,d,c,h,b,D,H;for(u=-1,c=xl.Sk(t,t.q,t.r,xl.Rj),d=jt,s=0;s<t.r;s++)h=t.J[t.D[0][s]].a,D=t.J[t.D[0][s]].b,f=(b=t.J[t.D[1][s]].a)-h,g=(H=t.J[t.D[1][s]].b)-D,a=n.Math.sqrt(f*f+g*g),f=e-(h+b)/2,g=i-(D+H)/2,n.Math.sqrt(f*f+g*g)>a/2||(b==h?l=n.Math.abs(h-e):(o=-(r=(H-D)/(h-b))*h-D,l=n.Math.abs((r*e+i+o)/n.Math.sqrt(r*r+1))),l<c&&l<d&&(d=l,u=s));return u},xl.xk=function(n,t){return((n.u[t]&Pt)>>>27)-1},xl.yk=function(n,t){return(49152&n.u[t])>>14},xl.zk=function(n,t){return n.s[t]},xl.Ak=function(n,t){return 448&n.u[t]},xl.Bk=function(n,t){return null==n.t||null==n.t[t]?null:Jl.BHb(n.t[t])},xl.Ck=function(n,t){return null==n.t?null:n.t[t]},xl.Dk=function(n,t){return(n.u[t]&Vn)>>18!=1&&(n.u[t]&Vn)>>18!=2?-1:(n.u[t]&Mt)>>20},xl.Ek=function(n,t){return(n.u[t]&Vn)>>18},xl.Fk=function(n,t){return xl.Mj[n.C[t]]},xl.Gk=function(n,t){return null==n.v?null:n.v[t]},xl.Hk=function(n,t){var e,i,s;if(null==n.v||null==n.v[t])return Bg(Cg(n.B[t],1),0)?"":xl.Mj[n.C[t]];for(s="",i=0;i<n.v[t].length;i++)i>0&&(Rl.ATb(s),s+=(Rl.ATb(","),",")),e=n.v[t][i],s=Jl.AHb(s,xl.Mj[e]);return s},xl.Ik=function(t,e){return n.Math.abs(t.w[e])},xl.Jk=function(n,t){return n.A[t]},xl.Kk=function(n,t){return 3&n.u[t]},xl.Lk=function(n,t){return n.B[t]},xl.Mk=function(n,t){return 48&n.u[t]},xl.Nk=function(n,t){return n.J[t].a},xl.Ok=function(n,t){return n.J[t].b},xl.Pk=function(n,t){return n.J[t].c},xl.Qk=function(n,t){return n.C[t]},xl.Rk=function(n){return xl.Sk(n,n.q,n.r,xl.Rj)},xl.Sk=function(n,t,e,i){return xl.Tk(n,t,e,i,n.J)},xl.Tk=function(n,t,e,i,s){var a,r,o,l,f,g,u,d,c,h;for(u=!1,d=0,f=0;f<e;f++)32!=n.H[f]&&0==(n.G[f]&qn)&&++d;if(0==d){for(g=0;g<e;g++)0==(n.G[g]&qn)&&++d;u=!0}if(0==d){if(t<2)return i;for(h=jt,a=1;a<t;a++)for(r=0;r<a;r++)(c=xl.Hh(s[a],s[r]))>0&&c<h&&(h=c);return h!=jt?.6*h:i}for(o=0,l=0;l<e;l++)(u||32!=n.H[l])&&0==(n.G[l]&qn)&&(o+=xl.Hh(s[n.D[1][l]],s[n.D[0][l]]));return o/d},xl.Uk=function(n,t,e){return xl.fn(n.J[t].a,n.J[t].b,n.J[e].a,n.J[e].b)},xl.Vk=function(n,t,e){return n.D[t][e]},xl.Wk=function(n,t){return((7680&n.G[t])>>9)+((122880&n.G[t])>>13)},xl.Xk=function(n,t){return(7680&n.G[t])>>9},xl.Yk=function(n,t){return(48&n.F[t])>>4},xl.Zk=function(n,t){return(768&n.F[t])>>8!=1&&(768&n.F[t])>>8!=2?-1:(n.F[t]&wt)>>10},xl.$k=function(n,t){return(768&n.F[t])>>8},xl._k=function(t,e){var i,s,a,r;return i=t.D[0][e],s=t.D[1][e],a=t.J[s].a-t.J[i].a,r=t.J[s].b-t.J[i].b,n.Math.sqrt(a*a+r*r)},xl.al=function(n,t,e){var i;for(i=0;i<n.r;i++)if((n.D[0][i]==t&&n.D[1][i]==e||n.D[0][i]==e&&n.D[1][i]==t)&&512!=n.H[i])return i;return-1},xl.bl=function(n,t){switch(127&n.H[t]){case 1:case 64:return 1;case 2:return 2;case 4:return 3;case 8:return 4;case 16:return 5;default:return 0}},xl.cl=function(n,t){return 3&n.F[t]},xl.dl=function(n,t){return n.G[t]},xl.el=function(n,t){return n.H[t]},xl.fl=function(n,t){return 127&n.H[t]},xl.gl=function(n,t){var e,i,s,a,r;if(0==n.q)return null;for(i=n.J[0].a,a=n.J[0].b,s=n.J[0].a,r=n.J[0].b,e=1;e<n.q;e++)i>n.J[e].a?i=n.J[e].a:s<n.J[e].a&&(s=n.J[e].a),a>n.J[e].b?a=n.J[e].b:r<n.J[e].b&&(r=n.J[e].b);return t?(t.c=i,t.d=a,t.b=s-i,t.a=r-a):t=new Kl.KG(i,a,s-i,r-a),t},xl.hl=function(n,t){var e;return null==(e=n.C[t]<xl.Nj.length?xl.Nj[n.C[t]]:null)?6:e[e.length-1]},xl.il=function(t,e,i){var s,a;return t.C[e]>=171&&t.C[e]<=190?0:(a=0,32==(48&t.u[e])&&(a-=1),(16==(48&t.u[e])||48==(48&t.u[e]))&&(a-=2),0==(s=t.s[e])&&t.K&&(Ig(Cg(t.B[e],bn),jn)&&(s=-1),Ig(Cg(t.B[e],bn),Hn)&&(s=1)),7==t.C[e]||8==t.C[e]||9==t.C[e]?a+=s:6==t.C[e]||14==t.C[e]||32==t.C[e]?a-=n.Math.abs(s):15==t.C[e]||33==t.C[e]?i-a-s<=3?a+=s:a-=s:16==t.C[e]||34==t.C[e]||52==t.C[e]?i-a-s<=4?a+=s:a-=n.Math.abs(s):17==t.C[e]||35==t.C[e]||53==t.C[e]?i-a-s<=5?a+=s:a-=n.Math.abs(s):a-=s,a)},xl.jl=function(n,t){var e;return(e=xl.kl(n,t))+xl.il(n,t,e)},xl.kl=function(n,t){var e,i;return-1==(e=((n.u[t]&Pt)>>>27)-1)&&(e=null==(i=n.C[t]<xl.Nj.length?xl.Nj[n.C[t]]:null)?6:i[i.length-1]),e},xl.ll=function(n,t){var e,i,s,a,r;for(a=xl.Nl(n,n.D[0][t])||xl.Nl(n,n.D[1][t])?5:3,i=0;i<2;i++)e=n.D[i][t],a>(s=xl.bl(n,t)+((r=xl.kl(n,e))+xl.il(n,e,r))-xl.ko(n,e))&&(a=s);return a},xl.ml=function(n,t){return 0!=(n.u[t]&J)},xl.nl=function(n,t){var e,i,s;return i=xl.ll(n,t),s=(e=xl.Fl(n,n.D[0][t])||xl.Fl(n,n.D[1][t]))?32:1,16==n.H[t]?(n.H[t]=s,n.T=0,!0):8==n.H[t]?(n.H[t]=i>4?16:s,n.T=0,!0):4==n.H[t]?(n.H[t]=i>3?8:s,n.T=0,!0):2==n.H[t]&&(n.H[t]=386,n.T&=7,0==(128&n.F[t]))||(386==n.H[t]?(n.H[t]=i>2?4:s,n.T=0,!0):0!=(384&n.H[t])?(n.H[t]=1,n.T&=7,!0):!(!e&&i<2)&&(1==n.H[t]?(n.H[t]=2,n.T=0,!0):!(i<1)&&(32==n.H[t]&&(n.H[t]=1,n.T=0,!0))))},xl.ol=function(n){var t;for(n.T=0,n.C=vf(kl.llb,z,6,n.M,15,1),n.s=vf(kl.llb,z,6,n.M,15,1),n.w=vf(kl.llb,z,6,n.M,15,1),n.J=vf(kl.Elb,Nt,32,n.M,0,1),t=0;t<n.M;t++)n.J[t]=new xl.Rh;n.A=vf(kl.llb,z,6,n.M,15,1),n.u=vf(kl.llb,z,6,n.M,15,1),n.B=vf(kl.mlb,st,6,n.M,14,1),n.v=null,n.t=null,n.D=Yf(kl.llb,[ot,z],[8,6],15,[2,n.N],2),n.H=vf(kl.llb,z,6,n.N,15,1),n.F=vf(kl.llb,z,6,n.N,15,1),n.G=vf(kl.llb,z,6,n.N,15,1)},xl.pl=function(n,t){n.T&=~t},xl.ql=function(n){var t;for(t=0;t<n.q;t++)if(0!=n.J[t].c)return!0;return!1},xl.rl=function(n,t){return 0!=(n.u[t]&Lt)},xl.sl=function(n,t){return-1==n.C[t]},xl.tl=function(n,t){return 0!=(4&n.u[t])},xl.ul=function(n,t){return 0!=(n.u[t]&Ut)},xl.vl=function(n,t){return n.w[t]<0},xl.wl=function(n,t){return 0!=(n.F[t]&kt)},xl.xl=function(n,t){return 0!=(n.G[t]&qn)},xl.yl=function(n,t){return 0!=(n.F[t]&J)},xl.zl=function(n,t){return 512==n.H[t]},xl.Al=function(n,t){return 0!=(4&n.F[t])},xl.Bl=function(n,t){return 0!=(n.F[t]&gt)},xl.Cl=function(n,t){var e,i,s,a;if(n.K){if(Bg(Cg(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(s=0,a=(i=n.v[t]).length;s<a;++s)if(e=i[s],!xl.jn(e))return!1}return xl.jn(n.C[t])},xl.Dl=function(n,t){var e,i,s,a;if(n.K){if(Bg(Cg(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(s=0,a=(i=n.v[t]).length;s<a;++s)if(e=i[s],!xl.kn(e))return!1}return xl.kn(n.C[t])},xl.El=function(n,t){return 0!=(n.u[t]&gt)},xl.Fl=function(n,t){var e,i,s,a;if(n.K){if(Bg(Cg(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(s=0,a=(i=n.v[t]).length;s<a;++s)if(!((e=i[s])>=3&&e<=4||e>=11&&e<=13||e>=19&&e<=31||e>=37&&e<=51||e>=55&&e<=84||e>=87&&e<=103))return!1}return xl.ln(n.C[t])},xl.Gl=function(n,t){return 0==n.A[t]},xl.Hl=function(n,t){var e,i,s,a;if(n.K){if(Bg(Cg(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(s=0,a=(i=n.v[t]).length;s<a;++s)if(!(1==(e=i[s])||e>=5&&e<=9||e>=14&&e<=17||e>=32&&e<=35||e>=52&&e<=53))return!1}return xl.mn(n.C[t])},xl.Il=function(n){var t;for(t=0;t<n.q;t++)switch(n.C[t]){case 1:case 5:case 6:case 7:case 8:case 9:case 14:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:continue;default:return!1}return!0},xl.Jl=function(n,t){return 0!=(512&n.u[t])},xl.Kl=function(n,t){return 0!=(n.u[n.D[0][t]]&n.u[n.D[1][t]]&512)},xl.Ll=function(n,t){return 257==n.H[t]||129==n.H[t]},xl.Ml=function(n,t,e){return(257==n.H[t]||129==n.H[t])&&n.D[0][t]==e},xl.Nl=function(n,t){var e,i,s,a;if(n.K){if(Bg(Cg(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(s=0,a=(i=n.v[t]).length;s<a;++s)if(!((e=i[s])>=3&&e<=4||e>=11&&e<=13||e>=19&&e<=31||e>=37&&e<=51||e>=55&&e<=84||e>=87&&e<=103))return!1}return xl.nn(n.C[t])},xl.Ol=function(n,t){n.C[t]=-1},xl.Pl=function(n,t){n.H[t]=512},xl.Ql=function(t,e,i,s,a,r,o,l){var f,g,u,d,c,h,b,D,H,j;for(e!=s&&(H=t.J[e].a-t.J[s].a,j=t.J[e].b-t.J[s].b,l=n.Math.sqrt(H*H+j*j)),f=e,u=3!=xl.Pm(t,e),D=1;D<i;D++){for(c=t.J[f].a+l*n.Math.sin(r),h=t.J[f].b+l*n.Math.cos(r),b=-1,d=0;d<t.q;d++)if(n.Math.abs(c-t.J[d].a)<4&&n.Math.abs(h-t.J[d].b)<4){b=d;break}-1==b&&(b=xl.Tj(t,c,h,0),t.J[b].a=c,t.J[b].b=h,t.J[b].c=0),-1==(g=xl.al(t,f,b))&&(g=xl.Wj(t,f,b,xl.Fl(t,f)||xl.Fl(t,b)?32:1),a&&(u&&xl.Pm(t,t.D[0][g])<4&&xl.Pm(t,t.D[1][g])<3&&(t.H[g]=2),u=!u)),f=b,r+=o}-1==(g=xl.al(t,f,s))&&(g=xl.Wj(t,f,s,xl.Fl(t,f)||xl.Fl(t,s)?32:1)),a&&u&&xl.Pm(t,t.D[0][g])<4&&xl.Pm(t,t.D[1][g])<4&&(t.H[g]=2)},xl.Rl=function(n,t,e){var i,s;if(1!=xl.bl(n,t))return!1;if(0!=(3&n.u[e]))return!0;for(s=0;s<n.r;s++)if(s!=t&&2==n.H[s]&&(n.D[0][s]==e&&0!=(3&n.u[n.D[1][s]])||n.D[1][s]==e&&0!=(3&n.u[n.D[0][s]])))return!0;for(i=0;i<n.r;i++)if(i!=t&&1==n.H[i]&&(n.D[0][i]==e||n.D[1][i]==e)&&0!=(3&n.F[i]))return!0;return!1},xl.Sl=function(n){var t;for(t=0;t<n.q;t++)n.u[t]&=-449},xl.Tl=function(n){var t;for(t=0;t<n.q;t++)n.u[t]&=-131073},xl.Ul=function(n){var t;for(t=0;t<n.q;t++)n.u[t]&=-513},xl.Vl=function(n){var t;for(t=0;t<n.r;t++)n.F[t]&=-98305},xl.Wl=function(t,e){var i;for(i=0;i<t.q;i++)n.Math.abs(t.w[i])==n.Math.abs(e)&&(t.w[i]=0)},xl.Xl=function(n){var t,e,i,s;for(s=!1,e=0;e<n.q;e++)Bg(Cg(n.B[e],tn),0)&&(n.C[e]=-1,s=!0);for(s&&xl.tk(n),null!=n.v&&(n.v=null,s=!0),t=0;t<n.q;t++)Bg(n.B[t],0)&&(n.B[t]=0,s=!0);for(i=0;i<n.r;i++)0!=n.G[i]&&(n.G[i]=0,s=!0),64==n.H[i]&&(n.H[i]=1,s=!0);return s&&(n.T=0),s},xl.Yl=function(n,t){var e,i,s,a,r,o,l,f,g;if(0==t)return 0;for(o=null,i=0;i<n.q;i++)(n.u[i]&Vn)>>18==t&&(null==o&&(o=vf(kl.Cwb,nn,6,32,16,1)),o[(n.u[i]&Vn)>>18!=1&&(n.u[i]&Vn)>>18!=2?-1:(n.u[i]&Mt)>>20]=!0);for(a=0;a<n.r;a++)(768&n.F[a])>>8==t&&(null==o&&(o=vf(kl.Cwb,nn,6,32,16,1)),o[(768&n.F[a])>>8!=1&&(768&n.F[a])>>8!=2?-1:(n.F[a]&wt)>>10]=!0);if(g=0,null!=o){for(f=vf(kl.llb,z,6,32,15,1),l=0;l<32;l++)o[l]&&(f[l]=g++);for(e=0;e<n.q;e++)(n.u[e]&Vn)>>18==t&&(r=f[(n.u[e]&Vn)>>18!=1&&(n.u[e]&Vn)>>18!=2?-1:(n.u[e]&Mt)>>20],n.u[e]&=-32505857,n.u[e]|=r<<20);for(s=0;s<n.r;s++)(768&n.F[s])>>8==t&&(r=f[(768&n.F[s])>>8!=1&&(768&n.F[s])>>8!=2?-1:(n.F[s]&wt)>>10],n.F[s]&=-31745,n.F[s]|=r<<10)}return g},xl.Zl=function(n,t){var e;for(e=0;e<n.q;e++)n.J[e].a*=t,n.J[e].b*=t},xl.$l=function(n,t){n.q=t,n.T=0},xl._l=function(n,t){n.r=t,n.T=0},xl.am=function(n,t,e){e>=-1&&e<=14&&(n.u[t]&=-2013265921,n.u[t]|=1+e<<27,6==n.C[t]&&(-1!=e&&0!=e&&2!=e&&4!=e||(n.u[t]&=-49,2==e&&(n.u[t]|=16))))},xl.bm=function(n,t,e){n.u[t]&=-49153,n.u[t]|=e<<14},xl.cm=function(n,t,e){n.s[t]=e,n.T=0},xl.dm=function(n,t,e){n.u[t]&=-449,n.u[t]|=e},xl.em=function(n,t,e){e?n.u[t]|=Lt:n.u[t]&=Jt,n.T&=7},xl.fm=function(n,t,e){var i,s;null!=e&&(0==Rl.LTb(e).length?e=null:(0!=(i=xl.hn(e,321))&&Jl.DHb(e,xl.Mj[i])||Jl.DHb(e,"?"))&&(xl.vm(n,t,i),e=null)),null==e?null!=n.t&&(n.t[t]=null):(null==n.t&&(n.t=vf(kl.hlb,j,10,n.M,0,2)),n.t[t]=Rl.mTb((s=e,Rl.hTb(),s)))},xl.gm=function(n,t,e){null!=e&&0==e.length&&(e=null),null==e?null!=n.t&&(n.t[t]=null):(null==n.t&&(n.t=vf(kl.hlb,j,10,n.M,0,2)),n.t[t]=e)},xl.hm=function(n,t,e,i){var s,a,r;if(0==e)n.u[t]&=yt,n.u[t]|=e<<18;else{if(i>=32)return;if(-1==i){for(r=-1,a=0;a<n.q;a++)a!=t&&e==(n.u[a]&Vn)>>18&&r<((n.u[a]&Vn)>>18!=1&&(n.u[a]&Vn)>>18!=2?-1:(n.u[a]&Mt)>>20)&&(r=(n.u[a]&Vn)>>18!=1&&(n.u[a]&Vn)>>18!=2?-1:(n.u[a]&Mt)>>20);for(s=0;s<n.r;s++)e==(768&n.F[s])>>8&&r<((768&n.F[s])>>8!=1&&(768&n.F[s])>>8!=2?-1:(n.F[s]&wt)>>10)&&(r=(768&n.F[s])>>8!=1&&(768&n.F[s])>>8!=2?-1:(n.F[s]&wt)>>10);if((i=r+1)>=32)return}n.u[t]&=yt,n.u[t]|=e<<18|i<<20}n.T&=7},xl.im=function(n,t,e){null==n.v&&(n.v=vf(kl.llb,ot,8,n.M,0,2)),Rl.fTb(e,Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[]))),n.v[t]=e,n.T=0,n.K=!0},xl.jm=function(n,t,e,i){var s;if(null!=e){if(1==e.length&&!i)return s=e[0],n.C[t]!=s&&xl.ek(n,t,s,0,-1,0),void(null!=n.v&&(n.v[t]=null));null==n.v&&(n.v=vf(kl.llb,ot,8,n.M,0,2)),n.v[t]=e,i&&(n.B[t]=Eg(n.B[t],1)),n.T=0,n.K=!0}else null!=n.v&&(n.v[t]=null)},xl.km=function(n,t,e,i){n.w[t]=i?-e:e},xl.lm=function(n,t,e){e?n.u[t]|=gt:n.u[t]&=-131073},xl.mm=function(n,t,e){n.A[t]=e,n.T&=7},xl.nm=function(n,t,e,i){n.u[t]&=-33554440,n.u[t]|=e,i&&(n.u[t]|=4)},xl.om=function(n,t,e,i){n.B[t]=i?Eg(n.B[t],e):Cg(n.B[t],Rg(e)),n.T=0,n.K=!0},xl.pm=function(n,t,e){n.u[t]&=-49,n.u[t]|=e,n.T&=7},xl.qm=function(n,t,e){e?n.u[t]|=512:n.u[t]&=-513},xl.rm=function(n,t,e){n.u[t]&=-67108865,e&&(n.u[t]|=Ut)},xl.sm=function(n,t,e){n.J[t].a=e,n.T&=7},xl.tm=function(n,t,e){n.J[t].b=e,n.T&=7},xl.um=function(n,t,e){n.J[t].c=e,n.T&=7},xl.vm=function(n,t,e){e>=0&&e<=190&&(151==e||152==e?(n.C[t]=1,n.A[t]=e-149):(n.C[t]=e,n.A[t]=0),n.u[t]&=-2013265921,n.T=0)},xl.wm=function(n,t,e,i){n.D[t][e]=i,n.T=0},xl.xm=function(n,t,e){e?n.F[t]|=kt:n.F[t]&=-32769};xl.ym=function(n,t,e){n.F[t]&=-49,n.F[t]|=e<<4},xl.zm=function(n,t,e,i){var s,a,r;if(0==e)n.F[t]&=-32513,n.F[t]|=e<<8;else{if(i>=32)return;if(-1==i){for(r=-1,a=0;a<n.q;a++)e==(n.u[a]&Vn)>>18&&r<((n.u[a]&Vn)>>18!=1&&(n.u[a]&Vn)>>18!=2?-1:(n.u[a]&Mt)>>20)&&(r=(n.u[a]&Vn)>>18!=1&&(n.u[a]&Vn)>>18!=2?-1:(n.u[a]&Mt)>>20);for(s=0;s<n.r;s++)s!=t&&e==(768&n.F[s])>>8&&r<((768&n.F[s])>>8!=1&&(768&n.F[s])>>8!=2?-1:(n.F[s]&wt)>>10)&&(r=(768&n.F[s])>>8!=1&&(768&n.F[s])>>8!=2?-1:(n.F[s]&wt)>>10);if((i=r+1)>=32)return}n.F[t]&=-32513,n.F[t]|=e<<8|i<<10}n.T&=7},xl.Am=function(n,t,e){e?n.F[t]|=J:n.F[t]&=-65537},xl.Bm=function(n,t,e){n.H[t]=1==e?1:2==e?2:3==e?4:32,n.T=0},xl.Cm=function(n,t,e,i){n.F[t]&=-131080,n.F[t]|=e,i&&(n.F[t]|=4)},xl.Dm=function(n,t){n.F[t]|=gt},xl.Em=function(n,t,e,i){i?n.G[t]|=e:n.G[t]&=~e,n.T=0,n.K=!0},xl.Fm=function(n,t,e){n.H[t]=e,n.T=0},xl.Gm=function(n,t){n.I=t},xl.Hm=function(n,t){n.K!=t&&(n.K=t,t||xl.Xl(n),n.T=0)},xl.Im=function(n,t){n.T=t},xl.Jm=function(n,t){n.S=t},xl.Km=function(n,t){var e,i;for(n.C=xl._m(n.C,t),n.s=xl._m(n.s,t),n.w=xl._m(n.w,t),i=n.J.length,n.J=xl.bn(n.J,t),e=i;e<t;e++)n.J[e]=new xl.Rh;n.A=xl._m(n.A,t),n.u=xl._m(n.u,t),n.B=xl.an(n.B,t),null!=n.v&&(n.v=xl.dn(n.v,t)),null!=n.t&&(n.t=xl.cn(n.t,t)),n.M=t},xl.Lm=function(n,t){n.D[0]=xl._m(n.D[0],t),n.D[1]=xl._m(n.D[1],t),n.H=xl._m(n.H,t),n.F=xl._m(n.F,t),n.G=xl._m(n.G,t),n.N=t},xl.Mm=function(n,t){n.O=t},xl.Nm=function(n,t){n.P=t},xl.Om=function(n,t){n.u[t]|=J},xl.Pm=function(n,t){var e,i;for(i=0,e=0;e<n.r;e++)(n.D[0][e]==t||n.D[1][e]==t)&&(i+=xl.bl(n,e));return i},xl.Qm=function(n){var t,e,i;for(e=!1,i=!1,t=0;t<n.q;t++)0!=n.A[t]&&(n.A[t]=0,e=!0,1==n.C[t]&&(i=!0));return i&&(n.T=0),e},xl.Rm=function(n,t,e){return xl.Fl(n,t)||xl.Fl(n,e)?32:1},xl.Sm=function(n,t,e){var i,s,a,r,o,l;for(r=n.C[t],n.C[t]=n.C[e],n.C[e]=r,r=n.s[t],n.s[t]=n.s[e],n.s[e]=r,r=n.A[t],n.A[t]=n.A[e],n.A[e]=r,r=n.u[t],n.u[t]=n.u[e],n.u[e]=r,l=n.B[t],n.B[t]=n.B[e],n.B[e]=l,r=n.w[t],n.w[t]=n.w[e],n.w[e]=r,a=n.J[t],n.J[t]=n.J[e],n.J[e]=a,null!=n.v&&(o=n.v[t],n.v[t]=n.v[e],n.v[e]=o),null!=n.t&&(o=n.t[t],n.t[t]=n.t[e],n.t[e]=o),i=0;i<n.r;i++)for(s=0;s<2;s++)n.D[s][i]==t?n.D[s][i]=e:n.D[s][i]==e&&(n.D[s][i]=t);n.T=0},xl.Tm=function(n,t,e){var i;i=n.D[0][t],n.D[0][t]=n.D[0][e],n.D[0][e]=i,i=n.D[1][t],n.D[1][t]=n.D[1][e],n.D[1][e]=i,i=n.H[t],n.H[t]=n.H[e],n.H[e]=i,i=n.F[t],n.F[t]=n.F[e],n.F[e]=i,i=n.G[t],n.G[t]=n.G[e],n.G[e]=i,n.T=0},xl.Um=function(n,t,e){var i;for(i=0;i<n.q;i++)n.J[i].a+=t,n.J[i].b+=e;n.U+=t,n.V+=e},xl.Vm=function(n,t,e){var i,s;switch(s=127&e,i=xl.ll(n,t),s){case 1:case 64:return i>=1;case 2:return i>=2;case 4:return i>=3;case 8:return i>=4;case 16:return i>=5;case 32:return!0;default:return!1}},xl.Wm=function(t,e,i,s){var a,r,o;for(a=0;a<t.q;a++)s&&0==(512&t.u[a])||(o=t.R[a]*e,r=t.Q[a]-i,t.J[a].a=t.U+o*n.Math.sin(r),t.J[a].b=t.V+o*n.Math.cos(r));s&&(t.T&=7)},xl.Xm=function(t,e,i){var s,a,r;for(t.U=e,t.V=i,t.Q=vf(kl.jlb,S,6,t.q,15,1),t.R=vf(kl.jlb,S,6,t.q,15,1),s=0;s<t.q;s++)a=e-t.J[s].a,r=i-t.J[s].b,t.R[s]=n.Math.sqrt(a*a+r*r),t.Q[s]=xl.fn(e,i,t.J[s].a,t.J[s].b)},xl.Ym=function(){this.M=this.N=256,xl.ol(this)},xl.Zm=function(t,e){this.M=n.Math.max(1,t),this.N=n.Math.max(1,e),xl.ol(this)},xl._m=function(t,e){var i;return i=vf(kl.llb,z,6,e,15,1),Jl.pIb(t,0,i,0,n.Math.min(t.length,e)),i},xl.an=function(t,e){var i;return i=vf(kl.mlb,st,6,e,14,1),Jl.pIb(t,0,i,0,n.Math.min(t.length,e)),i},xl.bn=function(n,t){var e,i;for(e=vf(kl.Elb,Nt,32,t,0,1),i=0;i<n.length;i++)n[i]&&(e[i]=new xl.Th(n[i]));return e},xl.cn=function(n,t){var e,i;for(e=vf(kl.hlb,j,10,t,0,2),i=0;i<n.length;i++)null!=n[i]&&(e[i]=vf(kl.hlb,ft,6,n[i].length,15,1),Jl.pIb(n[i],0,e[i],0,n[i].length));return e},xl.dn=function(n,t){var e,i;for(e=vf(kl.llb,ot,8,t,0,2),i=0;i<n.length;i++)null!=n[i]&&(e[i]=vf(kl.llb,z,6,n[i].length,15,1),Jl.pIb(n[i],0,e[i],0,n[i].length));return e},xl.en=function(n){return xl.Sj(),n>=0&&n<xl.Nj.length&&null!=xl.Nj[n]?xl.Nj[n]:n>=171&&n<=190?xl.Lj:xl.Pj},xl.fn=function(t,e,i,s){var a,r,o;return xl.Sj(),r=i-t,0!=(o=s-e)?(a=n.Math.atan(r/o),o<0&&(r<0?a-=rn:a+=rn)):a=r>0?on:Gn,a},xl.gn=function(n,t){var e;for(xl.Sj(),e=n-t;e<Bt;)e+=an;for(;e>rn;)e-=an;return e},xl.hn=function(n,t){var e,i,s,a,r;if(xl.Sj(),0!=(256&t)&&Jl.DHb(n,"?"))return 0;for(i=1;i<=128;i++)if(!Jl.DHb(n,It)&&Jl.EHb(n,xl.Mj[i]))return i;if(0!=(2&t))for(s=129;s<=144;s++)if(Jl.EHb(n,xl.Mj[s]))return s;if(0!=(4&t))for(a=146;a<=148;a++)if(Jl.EHb(n,xl.Mj[a]))return a;if(0!=(1&t))for(r=151;r<=152;r++)if(Jl.EHb(n,xl.Mj[r]))return r;if(0!=(32&t)&&Jl.EHb(n,xl.Mj[153]))return 153;if(0!=(8&t)&&Jl.EHb(n,xl.Mj[154]))return 154;if(0!=(16&t)&&Jl.EHb(n,xl.Mj[145]))return 145;if(0!=(128&t)&&Jl.EHb(n,xl.Mj[159]))return 159;if(0!=(64&t))for(e=171;e<=190;e++)if(Jl.EHb(n,xl.Mj[e]))return e;return 0},xl.jn=function(n){switch(xl.Sj(),n){case 7:case 8:case 9:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:return!0}return!1},xl.kn=function(n){return xl.Sj(),1!=n&&6!=n&&(!xl.jn(n)&&(2!=n&&10!=n&&18!=n&&36!=n&&54!=n&&!(n>103)))},xl.ln=function(n){return n>=3&&n<=4||n>=11&&n<=13||n>=19&&n<=31||n>=37&&n<=51||n>=55&&n<=84||n>=87&&n<=103},xl.mn=function(n){return 1==n||n>=5&&n<=9||n>=14&&n<=17||n>=32&&n<=35||n>=52&&n<=53},xl.nn=function(n){return n>=21&&n<=30||n>=39&&n<=48||57==n||n>=72&&n<=80||89==n||n>=104&&n<=112},zf(113,1,{113:1,4:1}),o.Kb=function(n){xl.nk(this,n)},o.Lb=function(n){return 64==this.H[n]},o.q=0,o.r=0,o.I=0,o.K=!1,o.L=!1,o.M=0,o.N=0,o.O=0,o.S=!1,o.T=0,o.U=0,o.V=0,xl.Rj=24,kl.Qlb=lg(113),xl.pn=function(n,t,e,i){var s,a,r,o,l,f,g,u,d;for(xl.nu(t,1),null==i&&(i=vf(kl.llb,z,6,t.q,15,1)),o=xl.Yl(n,1),l=xl.Yl(n,2),d=vf(kl.Cwb,nn,6,t.q,16,1),(f=vf(kl.llb,z,6,t.q,15,1))[0]=e,d[e]=!0,i[e]=xl.jk(t,n,e,o,l),r=0,g=0;r<=g;){for(u=0;u<xl.Dn(t,f[r]);u++)d[a=t.i[f[r]][u]]||(f[++g]=a,d[a]=!0,i[a]=xl.jk(t,n,a,o,l));++r}for(s=0;s<t.r;s++)d[t.D[0][s]]&&xl.kk(t,n,s,o,l,null==i?t.D[0][s]:i[t.D[0][s]],null==i?t.D[1][s]:i[t.D[1][s]],!1);xl.Yl(n,1),xl.Yl(n,2),n.T=0},xl.qn=function(n){var t,e,i,s,a,r,o,l,f,g,u,d;for(n.j=vf(kl.llb,z,6,n.q,15,1),n.e=vf(kl.llb,z,6,n.q,15,1),n.i=vf(kl.llb,ot,8,n.q,0,2),n.k=vf(kl.llb,ot,8,n.q,0,2),n.n=vf(kl.llb,ot,8,n.q,0,2),n.o=vf(kl.llb,z,6,n.f,15,1),f=vf(kl.llb,z,6,n.q,15,1),r=0;r<n.r;r++)++f[n.D[0][r]],++f[n.D[1][r]];for(i=0;i<n.q;i++)n.i[i]=vf(kl.llb,z,6,f[i],15,1),n.k[i]=vf(kl.llb,z,6,f[i],15,1),n.n[i]=vf(kl.llb,z,6,f[i],15,1);for(u=!1,o=0;o<n.g;o++)if(0!=(d=xl.bl(n,o)))for(g=0;g<2;g++)e=n.D[g][o],t=n.e[e],n.n[e][t]=d,n.i[e][t]=n.D[1-g][o],n.k[e][t]=o,++n.e[e],++n.j[e],e<n.f&&(d>1?n.o[e]+=d-1:64==n.H[o]&&(n.o[e]=1));else u=!0;for(l=n.g;l<n.r;l++)if(0!=(d=xl.bl(n,l)))for(g=0;g<2;g++)e=n.D[g][l],t=n.e[e],n.n[e][t]=d,n.i[e][t]=n.D[1-g][l],n.k[e][t]=l,++n.e[e],n.D[1-g][l]<n.f&&++n.j[e];else u=!0;if(u){for(t=vf(kl.llb,z,6,n.q,15,1),s=0;s<n.q;s++)t[s]=n.e[s];for(a=0;a<n.r;a++)if(0==(d=xl.bl(n,a)))for(g=0;g<2;g++)e=n.D[g][a],n.n[e][t[e]]=d,n.i[e][t[e]]=n.D[1-g][a],n.k[e][t[e]]=a,++t[e]}},xl.rn=function(t,e,i){var s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p;for(xl.nu(t,1),i&&(e=!0),f=0;f<t.r;f++)if(1==(g=xl.bl(t,f))||2==g){if(t.s[t.D[0][f]]>0&&t.s[t.D[1][f]]<0)r=t.D[0][f],o=t.D[1][f];else{if(!(t.s[t.D[0][f]]<0&&t.s[t.D[1][f]]>0))continue;r=t.D[1][f],o=t.D[0][f]}if(xl.Fl(t,r)||xl.Fl(t,o))continue;if(t.C[r]<9&&xl.ko(t,r)>3||t.C[o]<9&&xl.ko(t,o)>3)continue;d=0!=xl.fo(t,r),t.s[r]-=1,t.s[o]+=1,d||(m=t.H[f],t.H[f]=1==g?2:4,129!=m&&257!=m||(p=t.D[0][f],j=xl.cp(t,p,!1),t.D[0][j]!=p&&(t.D[1][j]=t.D[0][j],t.D[1][j]=p))),t.T=0}for(A=0,D=0,h=0,a=0;a<t.q;a++)A+=t.s[a],t.s[a]<0&&!xl.Do(t,a)&&(++D,xl.Cl(t,a)&&(h-=t.s[a]));if(!e&&0!=A)throw og(new Jl.aA("molecule's overall charges are not balanced"));for(xl.nu(t,1),C=0,T=i?A+h:h,l=0;l<t.q;l++)t.s[l]>0&&!xl.Co(t,l)&&xl.Cl(t,l)&&0!=(u=n.Math.min(xl.fo(t,l),t.s[l]))&&T>=u&&(A-=u,C-=u,T-=u,t.s[l]-=u,t.T&=1);if((H=i?A:C)<0){for(b=vf(kl.llb,z,6,D,15,1),D=0,r=0;r<t.q;r++)t.s[r]<0&&!xl.Do(t,r)&&(b[D++]=(t.C[r]<<22)+r);for(Rl.fTb(b,Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[]))),c=b.length-1;H<0&&c>=b.length-D;c--)s=b[c]&Rt,xl.Cl(t,s)&&(A+=u=n.Math.min(-H,-t.s[s]),H+=u,t.s[s]+=u,t.T&=1)}return A},xl.sn=function(n){var t,e,i,s,a,r,o,l,f,g,u,d,c;if(!n.K)return!1;for(e=0;e<n.q;e++)(c=xl.kl(n,e))+xl.il(n,e,c)-xl.ko(n,e)<=0&&(0!=n.s[e]||5!=n.C[e]&&(7!=(s=n.C[e])&&15!=s&&33!=s)&&(8!=(i=n.C[e])&&16!=i&&34!=i&&52!=i))&&(n.B[e]=Cg(n.B[e],-6145));for(r=!1,t=0;t<n.f;t++)if(o=n.e[t]-n.j[t],!n.S&&o>0)for(Ig(Cg(n.B[t],zn),0)&&(g=Ig(Cg(n.B[t],cn),896)?3:Ig(Cg(n.B[t],cn),384)?2:Ig(Cg(n.B[t],128),128)?1:0,l=(c=xl.kl(n,t))+xl.il(n,t,c)-xl.ko(n,t),0==n.s[t]&&Ig(Cg(n.B[t],bn),0)&&6!=n.C[t]&&++l,(u=o)>3-g&&(u=3-g),u>l+o-g&&(u=l+o-g),u>0&&(d=Eg(d=0==g?0:xg(Cg(n.B[t],cn),u),kl.Rwb((3==u?7:2==o?3:1)<<7)),n.B[t]=Cg(n.B[t],-1921),n.B[t]=Eg(n.B[t],Cg(cn,d)))),f=n.j[t];f<n.e[t];f++)a=n.k[t][f],1==n.H[a]&&(n.C[n.i[t][f]]=-1,n.H[a]=512,r=!0);return r&&xl.ik(n),r},xl.tn=function(n,t){var e,i,s,a;if(2!=n.o[t]||2!=n.j[t]||2!=n.n[t][0]){if(0==n.o[t]||n.C[t]>=15)for(s=0;s<n.e[t];s++)i=n.k[t][s],(257==n.H[i]||129==n.H[i])&&n.D[0][i]==t&&n.D[0][i]==t&&(n.H[i]=1)}else for(s=0;s<2;s++)if(-1!=(e=xl.yn(n,t,n.i[t][s])))for(a=0;a<n.j[e];a++)i=n.k[e][a],(257==n.H[i]||129==n.H[i])&&n.D[0][i]==e&&(n.H[n.k[e][a]]=1)},xl.un=function(n,t,e,i,s){var a,r,o,l,f;for(i&&xl.nu(n,7),t.v=null,n.K&&xl.Hm(t,!0),l=e.length,null==s&&(s=vf(kl.llb,z,6,l,15,1)),t.q=0,a=0;a<l;a++)s[a]=e[a]?xl.jk(n,t,a,0,0):-1;for(t.r=0,f=0;f<n.r;f++)r=n.D[0][f],o=n.D[1][f],r<l&&o<l&&(e[r]&&e[o]?xl.kk(n,t,f,0,0,null==s?n.D[0][f]:s[n.D[0][f]],null==s?n.D[1][f]:s[n.D[1][f]],i):0!=n.s[r]&&0!=n.s[o]&&n.s[r]<0^n.s[o]<0&&(e[r]&&(t.s[s[r]]+=n.s[r]<0?1:-1),e[o]&&(t.s[s[o]]+=n.s[o]<0?1:-1)));xl.nk(n,t),n.d&&(t.T=0),t.T=0,xl.Yl(t,1),xl.Yl(t,2),t.q!=l&&xl.Hm(t,!0),i&&xl.je(new xl.te(t),null,!1)},xl.vn=function(n,t,e,i,s){var a,r,o,l,f;for(i&&xl.nu(n,7),t.v=null,n.K&&xl.Hm(t,!0),null==s&&(s=vf(kl.llb,z,6,n.q,15,1)),t.q=0,a=0;a<n.q;a++)for(s[a]=-1,f=0;f<n.j[a];f++)if(e[n.k[a][f]]){s[a]=xl.jk(n,t,a,0,0);break}for(t.r=0,l=0;l<n.r;l++)e[l]?xl.kk(n,t,l,0,0,null==s?n.D[0][l]:s[n.D[0][l]],null==s?n.D[1][l]:s[n.D[1][l]],i):(r=n.D[0][l],o=n.D[1][l],-1==s[r]^-1==s[o]&&0!=n.s[r]&&0!=n.s[o]&&n.s[r]<0^n.s[o]<0&&(-1!=s[r]&&(t.s[s[r]]+=n.s[r]<0?1:-1),-1!=s[o]&&(t.s[s[o]]+=n.s[o]<0?1:-1)));return xl.nk(n,t),n.d&&(t.T=0),t.T=0,xl.Yl(t,1),xl.Yl(t,2),t.q!=n.q&&xl.Hm(t,!0),i&&xl.je(new xl.te(t),null,!1),s},xl.wn=function(n,t){var e,i,s,a,r,o,l,f,g,u;if(0!=(t&~n.T)&&(0==(1&n.T)&&(xl.Bo(n),xl.qn(n),n.T|=1,xl.sn(n)&&(xl.Bo(n),xl.qn(n))),0!=(t&~n.T))){if(0!=(-7&n.T)){for(i=0;i<n.f;i++)n.u[i]&=-15369;for(a=0;a<n.g;a++)n.F[a]&=-705;if(0==(4&t))return xl.Bn(n,1),void(n.T|=2);for(xl.Bn(n,7),s=0;s<n.f;s++)for(g=0;g<n.j[s];g++)if(!((l=n.k[s][g])<n.g&&xl.Vr(n.p,l)))for(o=n.i[s][g],u=0;u<n.j[o];u++)n.k[o][u]!=l&&n.n[o][u]>1&&(6==n.C[n.i[o][u]]?n.u[s]|=fn:!xl.Io(n,n.k[o][u])&&xl.Cl(n,n.i[o][u])&&(n.u[s]|=Xn));for(;;){for(f=!1,e=0;e<n.f;e++)if(n.o[e]>0&&0!=(n.u[e]&Xn)&&!xl.Ur(n.p,e))for(g=0;g<n.j[e];g++)if(n.n[e][g]>1)for(o=n.i[e][g],l=n.k[e][g],u=0;u<n.j[o];u++)n.k[o][u]!=l&&(r=n.i[o][u],0==(n.u[r]&Xn)&&(n.u[r]|=Xn,f=!0));if(!f)break}}n.T|=6}},xl.xn=function(n,t){var e,i,s,a,r;if(e=-1,1==n.o[t])for(a=0;a<n.j[t];a++)if(2==n.n[t][a]){if(i=n.i[t][a],2==n.j[i]&&2==n.o[i])for(r=0;r<2;r++)if((s=n.i[i][r])!=t&&1==n.o[s]){e=i;break}break}return e},xl.yn=function(n,t,e){var i,s;for(i=t;2==n.j[e]&&2==n.o[e]&&e!=i;)s=e,e=n.i[e][0]==t?n.i[e][1]:n.i[e][0],t=s;return e==i?-1:e},xl.zn=function(n,t){var e;if(3==n.j[t]&&t<n.f&&xl.Ur(n.p,t)&&(n.p&&t<n.f?xl.Jr(n.p,t):0)>=5)for(e=0;e<n.j[t];e++)if(xl.Jo(n,n.k[t][e]))return n.k[t][e];return-1},xl.An=function(n,t,e,i,s){var a,r,o,l,f,g;if(xl.nu(n,7),0!=(n.u[t]&Et)&&(!e||t<n.f&&xl.Ur(n.p,t)))for((l=vf(kl.llb,z,6,n.f,15,1))[0]=t,i[t]=!0,o=0,f=0;o<=f;){for(g=0;g<n.j[l[o]];g++)s[r=n.k[l[o]][g]]||0==(64&n.F[r])||e&&!(r<n.g&&xl.Vr(n.p,r))||(s[r]=!0,i[a=n.i[l[o]][g]]||(i[a]=!0,l[++f]=a));++o}},xl.Bn=function(n,t){var e,i,s,a,r,o,l,f;for(n.p=new xl.gs(n,t),i=vf(kl.llb,z,6,n.f,15,1),s=0;s<n.g;s++)0!=xl.Lr(n.p,s)&&(n.F[s]|=64,++i[n.D[0][s]],++i[n.D[1][s]]);for(e=0;e<n.f;e++)2==i[e]?n.u[e]|=hn:3==i[e]?n.u[e]|=zn:i[e]>3&&(n.u[e]|=Et);for(f=0;f<n.p.i.a.length;f++)for(r=xl.Nr(n.p,f),l=xl.Or(n.p,f),o=r.length,a=0;a<o;a++)n.u[r[a]]|=8,n.F[l[a]]|=128,386==n.H[l[a]]&&(n.H[l[a]]=2)},xl.Cn=function(n){var t,e,i,s,a,r,o,l;for(o=vf(kl.Cwb,nn,6,n.q,16,1),e=0;e<n.q;e++)o[e]=1==n.C[e]&&0==n.A[e]&&0==n.s[e]&&(null==n.t||null==n.t[e]);for(l=vf(kl.Cwb,nn,6,n.q,16,1),r=0;r<n.r;r++)i=n.D[0][r],s=n.D[1][r],1==xl.bl(n,r)?(l[i]&&(o[i]=!1),l[s]&&(o[s]=!1),o[i]&&xl.Fl(n,s)&&13!=n.C[s]&&(o[i]=!1),o[s]&&xl.Fl(n,i)&&13!=n.C[i]&&(o[s]=!1),l[i]=!0,l[s]=!0):(o[i]=!1,o[s]=!1);for(a=0;a<n.r;a++)o[n.D[0][a]]&&o[n.D[1][a]]&&(o[n.D[0][a]]=!1,o[n.D[1][a]]=!1);for(t=0;t<n.q;t++)l[t]||(o[t]=!1);return o},xl.Dn=function(n,t){return n.e[t]},xl.En=function(n,t){return n.i[t].length},xl.Fn=function(n,t){return n.e[t]-xl.jo(n,t)+xl.fo(n,t)},xl.Gn=function(n){var t,e;for(xl.nu(n,7),t=0,e=0;e<n.p.i.a.length;e++)xl.Tr(n.p,e)&&++t;return t},xl.Hn=function(n,t){var e,i;for(e=0,i=0;i<n.j[t];i++)xl.Cl(n,n.i[t][i])&&!xl.xl(n,n.k[t][i])&&++e;return e},xl.In=function(n,t){return n.o[t]},xl.Jn=function(n,t){return xl.nu(n,7),2==n.o[t]&&2==n.j[t]?xl.ap(n,t,!1):xl.cp(n,t,!1)},xl.Kn=function(n,t){var e;return 0==(e=n.u[t]&Et)?0:e==hn?2:e==zn?3:4},xl.Ln=function(n,t,e){var i,s,a,r,o,l,f,g,u,d,c,h;for(xl.nu(n,7),a=vf(kl.Cwb,nn,6,n.g,16,1),u=vf(kl.Cwb,nn,6,n.g,16,1),h=vf(kl.llb,z,6,n.f,15,1),r=0,o=1;o<n.j[t];o++)if(i=n.k[t][o],0!=(64&n.F[i]))for(f=0;f<o;f++)if(s=n.k[t][f],0!=(64&n.F[s])&&(u[i]=!0,u[s]=!0,c=xl.mo(n,h,n.i[t][o],n.i[t][f],e-2,null,u),u[i]=!1,u[s]=!1,-1!=c)){for(l=!1,d=vf(kl.llb,z,6,c,15,1),xl.no(n,h,d,c),g=0;g<c;g++)a[d[g]]||(a[d[g]]=!0,l=!0);l&&++r}return r},xl.Mn=function(n,t){return n.p&&t<n.f?xl.Jr(n.p,t):0},xl.Nn=function(n,t){return t?(xl.nu(n,1),xl.Sk(n,n.f,n.g,xl.Rj)):xl.Sk(n,n.q,n.r,xl.Rj)},xl.On=function(n){var t,e,i,s,a,r,o,l;for(xl.nu(n,1),o=vf(kl.klb,xt,6,n.f,15,1),i=vf(kl.llb,z,6,n.f,15,1),l=0;l<n.f;l++){for(i[0]=l,(s=vf(kl.llb,z,6,n.f,15,1))[l]=1,e=0,a=0;e<=a;){for(r=0;r<n.j[i[e]];r++)0==s[t=n.i[i[e]][r]]&&(s[t]=s[i[e]]+1,i[++a]=t,o[l]+=s[t]-1);++e}o[l]/=a}return o},xl.Pn=function(n,t,e){var i;for(i=0;i<n.i[t].length;i++)if(n.i[t][i]==e)return n.k[t][i];return-1},xl.Qn=function(n,t){return n.p&&t<n.g?xl.Lr(n.p,t):0},xl.Rn=function(n,t,e){return n.i[t][e]},xl.Sn=function(n,t){return n.j[t]},xl.Tn=function(n,t,e){return n.k[t][e]},xl.Un=function(n,t,e){return n.n[t][e]},xl.Vn=function(n,t){var e,i;for(e=0,i=0;i<n.j[t];i++)Bg(Cg(n.B[i],tn),0)&&++e;return e},xl.Wn=function(n,t){return n.e[t]-n.j[t]},xl.Xn=function(t,e,i,s,a){var r,o,l,f;if(o=t.e[e],0!=t.o[e]||e<t.f&&xl.Ur(t.p,e)||t.j[e]<3||o>4)return!1;for(f=vf(kl.Cwb,nn,6,4,16,1),l=0;l<o;l++){if(r=3.9269908169872414-s[l],n.Math.abs(Ft-r%on)>.0872664675116539)return!1;if(a[l]=3&ag(r/on),f[a[l]])return!1;if(f[a[l]]=!0,0==(1&a[l])){if(1!=t.H[t.k[e][i[l]]])return!1}else if(!xl.Ml(t,t.k[e][i[l]],e))return!1}return f[0]&&f[2]},xl.Yn=function(t,e,i,s,a){var r,o,l,f,g,u;if((t.p&&e<t.f?xl.Jr(t.p,e):0)>24)return 3;if(r=t.e[e],null==a&&(a=vf(kl.llb,z,6,r,15,1)),!xl.Xn(t,e,i,s,a))return 3;for(f=-1,g=0;g<r;g++)if(1==(1&a[g])){if(o=t.H[t.k[e][i[g]]],-1!=f&&f!=o)return 3;f=o}return l=a[u=2==n.Math.abs(a[0]-a[1])?1:0]-a[u+1],3==n.Math.abs(l)^a[u]<a[u+1]^(3==r||1==(1&a[3]))^129==f?1:2},xl.Zn=function(n,t,e){var i,s,a,r,o,l,f,g,u,d;for(xl.nu(n,1),d=vf(kl.Cwb,nn,6,n.q,16,1),(f=vf(kl.llb,z,6,n.q,15,1))[0]=t,d[t]=!0,r=0,g=0,l=1;r<=g;){for(a=e?xl.En(n,f[r]):n.e[f[r]],u=0;u<a;u++)d[s=n.i[f[r]][u]]||(f[++g]=s,d[s]=!0,++l);++r}for(o=vf(kl.llb,z,6,l,15,1),l=0,i=0;i<n.q;i++)d[i]&&(o[l++]=i);return o},xl.$n=function(n,t,e,i){var s,a,r,o,l,f,g,u,d;for(xl.nu(n,1),a=0;a<n.q;a++)t[a]=-1;for(f=0,s=0;s<n.q;s++)if(-1==t[s]&&(!e||0!=(n.u[s]&gt))){for(t[s]=f,(g=vf(kl.llb,z,6,n.q,15,1))[0]=s,l=0,u=0;l<=u;){for(o=i?xl.En(n,g[l]):n.e[g[l]],d=0;d<o;d++)-1!=t[r=n.i[g[l]][d]]||e&&0==(n.u[r]&gt)||(g[++u]=r,t[r]=f);++l}++f}return f},xl._n=function(n,t,e,i){var s,a,r,o,l,f,g,u,d;for(xl.nu(n,1),a=0;a<n.q;a++)t[a]=-1;for(f=0,s=0;s<n.q;s++)if(-1==t[s]){for(t[s]=f,(g=vf(kl.llb,z,6,n.q,15,1))[0]=s,l=0,u=0;l<=u;){for(o=i?xl.En(n,g[l]):n.e[g[l]],d=0;d<o;d++)-1!=t[r=n.i[g[l]][d]]||e[n.k[g[l]][d]]||(g[++u]=r,t[r]=f);++l}++f}return f},xl.ao=function(n,t){var e;return(e=xl.kl(n,t))+xl.il(n,t,e)-xl.ko(n,t)},xl.bo=function(n,t){var e,i,s,a,r,o;for(a=vf(kl.llb,z,6,n.q,15,1),i=0;i<n.q;i++)a[i]=i;s=n.q;do{--s}while(s>=0&&t[s]);for(e=0;e<s;e++)if(t[a[e]]){o=a[e],a[e]=a[s],a[s]=o,r=t[e],t[e]=t[s],t[s]=r;do{--s}while(t[s])}return a},xl.co=function(n){return xl.bo(n,xl.Cn(n))},xl.eo=function(n,t,e){var i,s,a;if(s=xl.ko(n,t),s-=xl.il(n,t,s),e&&(s-=n.e[t]-n.j[t]),s<=(a=xl.en(n.C[t]))[0])return-1;for(i=1;i<a.length;i++)if(a[i]>=s)return a[i];return s},xl.fo=function(t,e){var i,s,a,r,o,l;if(t.K&&Ig(Cg(t.B[e],zn),0))return 0;if(!xl.lp(t,e))return 0;for(xl.nu(t,1),o=0,a=0;a<t.e[e];a++)o+=t.n[e][a];if(t.K){for(i=1,s=0;s<t.j[e];s++)64==t.H[t.k[e][s]]&&++i;o+=i>>1}if(o-=xl.il(t,e,o),-1==(r=((t.u[e]&Pt)>>>27)-1))for(r=(l=xl.en(t.C[e]))[0],s=1;r<o&&s<l.length;s++)r=l[s];return n.Math.max(0,r-o)},xl.go=function(n,t){var e,i,s,a,r;if(s=xl.ko(n,t),e=xl.il(n,t,s),-1==(a=((n.u[t]&Pt)>>>27)-1)){for(r=xl.en(n.C[t]),i=0;s>r[i]+e&&i<r.length-1;)++i;a=r[i]}return a+e-s},xl.ho=function(n,t){return n.i[t].length-n.e[t]},xl.io=function(n){var t,e,i;for(xl.nu(n,1),i=0,t=0;t<n.q;t++)i+=(0!=n.A[t]?n.A[t]:xl.Qj[n.C[t]])+xl.fo(n,t)*xl.Qj[1],n.C[t]>=171&&n.C[t]<=190&&(e=n.e[t])>2&&(i-=(e-2)*xl.Qj[1]);return i},xl.jo=function(n,t){var e,i;for(e=n.j[t],i=0;i<n.j[t];i++)1==n.C[n.i[t][i]]&&--e;return e},xl.ko=function(n,t){var e,i,s,a,r,o;for(n.Mb(1),r=!1,i=!1,o=0,s=0;s<n.e[t];s++)n.K&&!Ig(Cg(n.B[n.i[t][s]],tn),0)||(o+=a=n.n[t][s],a>1&&(r=!0),e=n.k[t][s],64==n.H[e]&&(i=!0));return i&&!r&&++o,o},xl.lo=function(n,t,e){var i,s,a;for(s=0,a=0;a<n.j[t];a++)(i=n.i[t][a])!=e&&n.j[i]>2&&++s;return s},xl.mo=function(n,t,e,i,s,a,r){var o,l,f,g,u,d,c,h,b;if(e==i)return t[0]=e,0;for(n.Mb(1),g=vf(kl.llb,z,6,n.q,15,1),f=vf(kl.llb,z,6,n.q,15,1),b=vf(kl.llb,z,6,n.q,15,1),f[0]=e,g[e]=1,l=0,u=0;l<=u&&g[f[l]]<=s;){for(h=f[l],d=0;d<n.e[h];d++)if(null==r||r.length<=n.k[h][d]||!r[n.k[h][d]]){if((o=n.i[h][d])==i){for(t[c=g[h]]=o,t[--c]=h;c>0;)t[c-1]=b[t[c]],--c;return g[h]}0==g[o]&&(null==a||a.length<=o||!a[o])&&(f[++u]=o,g[o]=g[h]+1,b[o]=h)}++l}return-1},xl.no=function(n,t,e,i){var s,a;for(xl.nu(n,1),s=0;s<i;s++)for(a=0;a<n.e[t[s]];a++)if(n.i[t[s]][a]==t[s+1]){e[s]=n.k[t[s]][a];break}},xl.oo=function(n,t,e){var i,s,a,r,o,l;if(t==e)return 0;for(xl.nu(n,1),r=vf(kl.llb,z,6,n.q,15,1),(a=vf(kl.llb,z,6,n.q,15,1))[0]=t,r[t]=1,s=0,o=0;s<=o;){for(l=0;l<n.e[a[s]];l++){if((i=n.i[a[s]][l])==e)return r[a[s]];0==r[i]&&(a[++o]=i,r[i]=r[a[s]]+1)}++s}return-1},xl.po=function(n,t,e,i,s){var a,r,o,l,f,g;if(t==e)return 0;for(n.Mb(1),l=vf(kl.llb,z,6,n.q,15,1),(o=vf(kl.llb,z,6,n.q,15,1))[0]=t,l[t]=1,r=0,f=0;r<=f&&l[o[r]]<=i;){for(g=0;g<n.e[o[r]];g++){if((a=n.i[o[r]][g])==e)return l[o[r]];0==l[a]&&(null==s||s.length<=a||!s[a])&&(o[++f]=a,l[a]=l[o[r]]+1)}++r}return-1},xl.qo=function(n,t){return n.e[t]-n.j[t]+xl.fo(n,t)},xl.ro=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h;for(h=vf(kl.llb,z,6,16,15,1),e=vf(kl.jlb,S,6,16,15,1),a=vf(kl.jlb,S,6,2,15,1),i=0,g=0;g<2;g++)for(s=n.D[g][t],u=0;u<n.j[s];u++)if((l=n.k[s][u])!=t){if(4==i)return 0;o=n.i[s][u],h[i]=16,0!=n.o[o]&&(h[i]+=0!=(n.u[o]&Et)?1:4),0!=(64&n.F[t])&&0!=(64&n.F[l])&&-1!=(d=xl.Rr(n.p,t,l))&&(h[i]+=xl.Tr(n.p,d)?64:6),e[i++]=xl.fn(n.J[s].a,n.J[s].b,n.J[o].a,n.J[o].b)}for(a[0]=xl.Uk(n,n.D[0][t],n.D[1][t]),a[0]<0?(a[1]=a[0]+rn,r=!1):(a[1]=a[0],a[0]=a[1]-rn,r=!0),c=0,f=0;f<i;f++)e[f]>a[0]&&e[f]<a[1]?c-=h[f]:c+=h[f];return r?-c:c},xl.so=function(n){return xl.nu(n,7),n.p},xl.to=function(n){var t,e,i,s,a,r,o,l,f;for(f=0,xl.nu(n,7),i=0;i<n.g;i++)if(1==xl.bl(n,i)&&0==(64&n.F[i])){for(o=!0,r=0;r<2;r++){if(t=n.D[r][i],1==n.j[t]){o=!1;break}if(7==n.C[t]&&!(t<n.f&&xl.Ur(n.p,t)))for(e=n.D[1-r][i],l=0;l<n.j[e];l++)if(s=n.i[e][l],(a=n.k[e][l])!=i&&xl.bl(n,a)>1&&!(s<n.f&&xl.Ur(n.p,s))&&xl.Cl(n,s)){o=!1;break}}o&&!xl.Ro(n,i)&&++f}return f},xl.uo=function(n,t,e){var i,s,a,r,o,l;for(s=0,a=0;a<n.j[t];a++)if((i=n.i[t][a])!=e){for(r=0,o=0;o<n.j[i];o++)(l=n.i[i][o])!=t&&xl.Io(n,n.k[i][o])&&n.j[l]>2&&++r;2==r&&++s}return s},xl.vo=function(n,t){var e,i,s,a;for(e=n.e[t],a=vf(kl.llb,z,6,e,15,1),s=0;s<e;s++)a[s]=(n.i[t][s]<<16)+s;for(Rl.fTb(a,Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[]))),i=0;i<e;i++)a[i]&=y;return a},xl.wo=function(n,t){var e,i;if(xl.nu(n,1),2==n.j[t]&&2==n.n[t][0]&&2==n.n[t][1]){for(e=0;e<2;e++)for(i=0;i<n.e[n.i[t][e]];i++)if(xl.Ml(n,n.k[n.i[t][e]][i],n.i[t][e]))return n.k[n.i[t][e]][i]}else for(e=0;e<n.e[t];e++)if(xl.Ml(n,n.k[t][e],t))return n.k[t][e];return-1},xl.xo=function(n,t,e){return 1!=xl.bl(n,t)?0:16-n.e[e]+(0==(384&n.H[t])||n.D[0][t]!=e?kt:0)+(1==n.C[e]?fn:0)+(1==n.e[e]?zn:0)+(0==(3&n.u[e])?hn:0)+(0!=(64&n.F[t])?0:512)+(6!=n.C[e]?256:0)},xl.yo=function(n,t,e,i,s,a){var r,o,l,f,g;for(xl.nu(n,1),s&&(xl.hk(s),s.K=!1),l=vf(kl.llb,z,6,n.q,15,1),null==i?i=vf(kl.Cwb,nn,6,n.q,16,1):Fl.JOb(i,i.length),l[0]=t,l[1]=e,i[t]=!0,i[e]=!0,o=1,f=1;o<=f;){for(g=0;g<n.e[l[o]];g++){if((r=n.i[l[o]][g])==t&&1!=o)return-1;i[r]||(i[r]=!0,l[++f]=r)}++o}return s&&(null==a&&(a=vf(kl.llb,z,6,i.length,15,1)),xl.un(n,s,i,!1,a),xl.ek(s,a[t],0,0,-1,0)),i[t]=!1,f},xl.zo=function(n,t,e){var i,s,a,r,o,l;for(xl.nu(n,1),a=vf(kl.llb,z,6,n.f,15,1),l=vf(kl.Cwb,nn,6,n.f,16,1),a[0]=t,a[1]=e,l[t]=!0,l[e]=!0,s=1,r=1;s<=r;){for(o=0;o<n.j[a[s]];o++){if((i=n.i[a[s]][o])==t&&1!=s)return-1;l[i]||(l[i]=!0,a[++r]=i)}++s}return r},xl.Ao=function(n,t,e){var i,s,a,r,o,l,f,g,u,d,c;if(2!=xl.bl(n,e)&&!(e<n.g&&xl.Vr(n.p,e)))return-1;if(1!=(c=3&n.F[e])&&2!=c)return-1;for(l=0;l<2;l++){for(i=n.D[l][e],s=n.D[1-l][e],d=-1,r=!1,g=0;g<n.j[i];g++)(a=n.i[i][g])!=s&&(a==t?r=!0:d=a);if(r){for(u=-1,o=-1,f=0;f<n.j[s];f++)(a=n.i[s][f])!=i&&(-1==u?u=a:a>u?o=a:(o=u,u=a));return 2==n.j[i]?2==n.j[s]?2==c?u:-1:2==c?u:o:2==n.j[s]?2==c^t<d?-1:u:2==c^t<d?o:u}}return-1},xl.Bo=function(n){var t,e,i,s,a,r,o,l,f,g;r=xl.Cn(n),l=n.q;do{--l}while(l>=0&&r[l]);for(t=0;t<l;t++)if(r[t]){xl.Sm(n,t,l),g=r[t],r[t]=r[l],r[l]=g;do{--l}while(r[l])}if(n.f=l+1,n.q!=n.f){for(o=vf(kl.Cwb,nn,6,n.r,16,1),a=0;a<n.r;a++)e=n.D[0][a],i=n.D[1][a],(r[e]||r[i])&&(o[a]=!0);f=n.r;do{--f}while(f>=0&&o[f]);for(s=0;s<f;s++)if(o[s]){xl.Tm(n,s,f),o[s]=!1;do{--f}while(o[f])}n.g=f+1}else n.g=n.r},xl.Co=function(n,t){var e;for(e=0;e<n.j[t];e++)if(n.s[n.i[t][e]]<0)return!0;return!1},xl.Do=function(n,t){var e;for(e=0;e<n.j[t];e++)if(n.s[n.i[t][e]]>0)return!0;return!1},xl.Eo=function(n,t){var e;return 3==(e=n.C[t])||11==e||19==e||37==e||55==e},xl.Fo=function(n,t){return 0!=(n.u[t]&fn)},xl.Go=function(n,t){var e,i,s,a,r,o;for(xl.nu(n,1),r=0;r<2;r++)if(e=n.D[r][t],7==n.C[e])for(i=n.D[1-r][t],o=0;o<n.j[i];o++)if(s=n.i[i][o],a=n.k[i][o],(7==n.C[s]||8==n.C[s]||16==n.C[s])&&xl.bl(n,a)>=2)return!0;return!1},xl.Ho=function(n,t){return t<n.f&&xl.Ur(n.p,t)},xl.Io=function(n,t){return t<n.g&&xl.Vr(n.p,t)},xl.Jo=function(n,t){var e,i,s,a,r,o;return!(1!=n.H[t]||t<n.g&&xl.Vr(n.p,t)||0!=(64&n.F[t])&&(n.p&&t<n.g?xl.Lr(n.p,t):0)<7)&&(!(!((e=n.D[0][t])<n.f&&xl.Ur(n.p,e))||(n.p&&e<n.f?xl.Jr(n.p,e):0)<5)&&(!(!((i=n.D[1][t])<n.f&&xl.Ur(n.p,i))||(n.p&&i<n.f?xl.Jr(n.p,i):0)<5)&&(s=xl.lo(n,e,i),a=xl.lo(n,i,e),(n.p&&e<n.f?xl.Jr(n.p,e):0)>5&&(n.p&&i<n.f?xl.Jr(n.p,i):0)>5?s+a>2:(r=xl.uo(n,e,i),o=xl.uo(n,i,e),2==s&&o>=1||(2==a&&r>=1||(2==r&&(a>=1||o>=1)||2==o&&(s>=1||r>=1)))))))},xl.Ko=function(n,t){return 2==n.o[t]&&2==n.j[t]&&2==n.n[t][0]&&2==n.n[t][1]&&n.C[t]<=7},xl.Lo=function(n,t){var e;return 8==(e=n.C[t])||16==e||34==e||52==e},xl.Mo=function(n,t){return t<n.g&&(xl.Zr(n.p,t)||64==n.H[t])},xl.No=function(n,t){var e;return 12==(e=n.C[t])||20==e||38==e||56==e},xl.Oo=function(n,t,e){var i,s,a,r,o,l,f,g,u,d,c,h,b;if(7!=n.C[t]||4==n.j[t])return!1;if(t<n.f&&xl.Ur(n.p,t)||0!=n.o[t]||Bg(Cg(n.B[t],Sn),0))return!0;if(1==n.s[t])return!1;for(l=0;l<n.j[t];l++)if(3==xl.Qn(n,n.k[t][l]))return!1;for(r=0,f=0;f<n.j[t];f++)1==n.n[t][f]&&(8==(i=n.C[n.i[t][f]])||9==i||17==i)&&++r;if(0==r)for(o=0;o<n.j[t];o++)if(s=n.i[t][o],0!=n.o[s]){if(s<n.f&&xl.Ur(n.p,s)){if((n.p&&s<n.f?xl.Jr(n.p,s):0)>=5){for(b=0,d=0;d<n.j[s];d++)(h=n.i[s][d])!=t&&xl.jo(n,h)>=3&&++b;if(c=xl.jo(n,t),2==b&&c>=2||1==b&&3==c)continue}return!e||!xl.To(n,t)}for(u=0;u<n.j[s];u++)if(2==n.n[s][u]||xl.Io(n,n.k[s][u]))return!e||!xl.To(n,t)}if(r<2)for(o=0;o<n.j[t];o++){for(s=n.i[t][o],g=!1,a=!1,u=0;u<n.j[s];u++)n.i[s][u]!=t&&(1!=n.n[s][u]&&(7==n.C[n.i[s][u]]||8==n.C[n.i[s][u]]||16==n.C[n.i[s][u]])&&(g=!0),1==n.n[s][u]&&7==n.C[n.i[s][u]]&&(a=!0));if(g&&(!a||0==r))return!e||!xl.To(n,t)}return!1},xl.Po=function(n,t){var e;return 9==(e=n.C[t])||17==e||35==e||53==e},xl.Qo=function(n,t){var e;return 7==(e=n.C[t])||15==e||33==e},xl.Ro=function(n,t){var e,i,s,a,r,o;if(1!=xl.bl(n,t))return!1;for(a=0;a<2;a++){for(e=n.D[a][t],o=n.D[1-a][t];2==n.o[e]&&2==n.j[e]&&n.C[e]<10;)for(r=0;r<2;r++)if((i=n.i[e][r])!=o){if(1==n.j[i])return!0;if(s=n.k[e][r],1==xl.bl(n,s)&&s<t)return!0;o=e,e=i;break}if(1==n.j[e])return!0}return!1},xl.So=function(n,t,e,i,s){var a,r,o,l,f,g,u,d,c,h,b,D,H;if((d=vf(kl.Cwb,nn,6,n.g,16,1))[s]=!0,c=vf(kl.llb,z,6,11,15,1),-1==(h=xl.mo(n,c,i,t,10,null,d)))return!1;for(r=1;!xl.Wr(n.p,e,c[r]);)++r;if(a=h-r,o=c[r],6==(H=xl.Qr(n.p,e))&&2==a&&3==r&&xl.Kn(n,c[1])>=3)for(D=xl.Nr(n.p,e),u=0;u<6;u++)if(t==D[u]){if(b=D[xl.fs(n.p,e,o==D[xl.fs(n.p,e,u+2)]?u-2:u+2)],(0==(g=n.u[b]&Et)?0:g==hn?2:g==zn?3:4)>=3&&2==xl.po(n,c[1],b,2,null))return!0;break}if(f=!(l=1==n.o[o]||o<n.f&&xl.Ur(n.p,o)||xl.Oo(n,o,!1))&&7==n.C[o]&&1!=n.s[o],1==a&&!l&&!f&&H<=4&&r<=3)return!0;switch(H){case 4:if(!l&&!f&&r<=4)return!0;break;case 5:if(f){if(r<=3)return!0}else if(!l&&r<=4)return!0;break;case 6:if(2==a){if(l){if(r<=4)return!0}else if(!f&&r<=3)return!0}else if(3==a)if(l){if(r<=6)return!0}else if(r<=4)return!0;break;case 7:if(3==a&&r<=3)return!0}return!1},xl.To=function(n,t){var e,i,s,a,r;if(t<n.f&&xl.Ur(n.p,t)||0!=n.o[t]||Bg(Cg(n.B[t],Sn),0)||(0==(i=n.u[t]&Et)?0:i==hn?2:i==zn?3:4)<3)return!1;if((r=n.p&&t<n.f?xl.Jr(n.p,t):0)>7)return!1;for(a=0;a<n.p.i.a.length&&(xl.Qr(n.p,a)!=r||!xl.Wr(n.p,a,t));)++a;if(a>=hn&&a==n.p.i.a.length)return!1;for(s=0;s<n.j[t];s++)if(e=n.k[t][s],!xl.Xr(n.p,a,e)&&xl.So(n,t,a,n.i[t][s],e))return!0;return!1},xl.Uo=function(n,t){return 0!=(n.u[t]&Et)},xl.Vo=function(n,t){return 0!=(64&n.F[t])},xl.Wo=function(n,t){return 1==n.C[t]&&0==n.A[t]&&0==n.s[t]&&(null==n.t||null==n.t[t])},xl.Xo=function(n,t){return 0!=(8&n.u[t])},xl.Yo=function(n,t){return 0!=(128&n.F[t])},xl.Zo=function(n,t){return 0!=(n.u[t]&Xn)},xl.$o=function(n){var t,e,i,s,a,r,o,l,f,g,u;for(xl.nu(n,1),xl._o(n),f=!1,e=0;e<n.f;e++)if(7==n.C[e]&&0==n.s[e])if(4==(u=xl.ko(n,e))){for(g=0;g<n.j[e];g++)if(o=n.i[e][g],1==n.n[e][g]&&8==n.C[o]&&1==n.j[o]&&0==n.s[o]){f=!0,++n.s[e],--n.s[o];break}}else if(5==u)for(g=0;g<n.j[e];g++){if(o=n.i[e][g],l=n.k[e][g],2==n.n[e][g]&&8==n.C[o]){f=!0,++n.s[e],--n.s[o],n.H[l]=1;break}if(3==n.n[e][g]&&7==n.C[o]){f=!0,++n.s[e],--n.s[o],n.H[l]=2;break}}for(r=!1,a=0;a<n.g;a++)for(g=0;g<2;g++)if(xl.Cl(n,n.D[g][a])){t=n.D[1-g][a],3!=(s=n.C[t])&&11!=s&&19!=s&&37!=s&&55!=s&&(12!=(i=n.C[t])&&20!=i&&38!=i&&56!=i)||(1==xl.bl(n,a)?(++n.s[t],--n.s[n.D[g][a]],n.H[a]=512,r=!0):32==n.H[a]&&(n.H[a]=512,r=!0));break}return r&&(xl.ik(n),f=!0),f&&(n.T=0),f},xl._o=function(n){var t;for(t=0;t<n.g;t++)if(64==n.H[t])return xl.je(new xl.te(n),null,!1);return!1},xl.ap=function(n,t,e){var i,s,a,r,o,l,f,g;for(f=-1,s=0,o=0;o<2;o++)for(i=n.i[t][o],l=0;l<n.e[i];l++)(a=n.i[i][l])!=t&&(r=n.k[i][l],s<(g=xl.xo(n,r,a))&&(!e||257!=n.H[r]&&129!=n.H[r])&&(s=g,f=r));return f},xl.bp=function(n,t){var e,i,s,a,r,o,l,f;for(l=-1,i=0,r=0;r<2;r++)for(e=n.D[r][t],o=0;o<n.e[e];o++)(s=n.i[e][o])!=n.D[1-r][t]&&(a=n.k[e][o],i<(f=xl.xo(n,a,s))&&(i=f,l=a));return l},xl.cp=function(t,e,i){var s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I;for(s=t.e[e],a=vf(kl.jlb,S,6,s,15,1),H=0;H<s;H++)a[H]=xl.Uk(t,e,t.i[e][H]);for(j=1;j<s;j++)for(C=0;C<j;C++)if((r=n.Math.abs(xl.gn(a[j],a[C])))<.08||r>Qt){for(o=0,l=0,T=0;T<s;T++)T!=j&&T!=C&&(o+=n.Math.abs(gf.i6(a[j],a[T])),l+=n.Math.abs(gf.i6(a[C],a[T])));if(g=o<l?t.k[e][j]:t.k[e][C],1==xl.bl(t,g)&&(!i||257!=t.H[g]&&129!=t.H[g]))return g}for(A=vf(kl.Cwb,nn,6,s,16,1),m=0;m<s;m++)for(u=-10,d=10,C=0;C<s;C++)C!=m&&((b=gf.i6(a[m],a[C]))<0?u<b&&(u=b):d>b&&(d=b)),A[m]=d-u<rn;for(p=-1,f=0,D=0;D<s;D++)c=t.i[e][D],h=t.k[e][D],I=xl.xo(t,h,c),A[D]&&(I+=ln),f<I&&(!i||257!=t.H[h]&&129!=t.H[h])&&(f=I,p=h);return p},xl.dp=function(n,t){var e,i,s;for(xl.nu(n,t?15:1),n.q=n.f,n.r=n.g,i=0;i<n.f;i++)n.e[i]!=n.j[i]&&(e=xl.eo(n,i,!1),n.e[i]=n.j[i],-1!=e&&e!=xl.eo(n,i,!0)&&(-1==(s=((n.u[i]&Pt)>>>27)-1)||s<e)&&xl.am(n,i,e));t&&xl.jp(n),n.T=0},xl.ep=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C;if(2!=n.j[t]||2!=n.n[t][0]||2!=n.n[t][1]||n.j[n.i[t][0]]<2||n.j[n.i[t][1]]<2||1!=n.o[n.i[t][0]]||1!=n.o[n.i[t][1]])xl.nm(n,t,0,!1);else{for(m=-1,j=-1,H=-1,h=-1,a=0,g=0;g<2;g++)for(i=n.i[t][g],c=0;c<n.e[i];c++)(r=n.i[i][c])!=t&&(o=n.k[i][c],a<(A=xl.xo(n,o,r))&&(a=A,j=r,m=o,H=i,h=n.i[t][1-g]));if(-1!=j){for(u=0;u<2;u++)for(i=n.i[t][u],c=0;c<n.e[i];c++)r=n.i[i][c],o=n.k[i][c],r!=t&&n.D[0][o]==i&&(n.H[o]=1);for(n.D[1][m]!=j&&(n.D[0][m]=n.D[1][m],n.D[1][m]=j),l=I,d=0;d<n.j[H];d++)(r=n.i[H][d])!=t&&l>r&&(l=r);for(b=vf(kl.llb,z,6,2,15,1),D=0,f=0;f<n.j[h];f++)(r=n.i[h][f])!=t&&(b[D++]=r);e=xl.fn(n.J[t].a,n.J[t].b,n.J[h].a,n.J[h].b),s=0,2==D?(b[0]>b[1]&&(C=b[0],b[0]=b[1],b[1]=C),s=xl.gn(e,xl.Uk(n,h,b[0]))-xl.gn(e,xl.Uk(n,h,b[1]))):s=xl.gn(e,xl.Uk(n,h,b[0])),s<0^1==(3&n.u[t])^l==j?n.H[m]=257:n.H[m]=129}}},xl.fp=function(n,t,e,i){var s,a,r,o,l,f;if(s=n.e[t],o=vf(kl.llb,z,6,s,15,1),3==(f=xl.Yn(n,t,e,i,o)))return!1;for(r=(3&n.u[t])==f?257:129,l=0;l<s;l++)1==(1&o[l])&&(a=n.k[t][e[l]],n.H[a]=r,n.D[0][a]!=t&&(n.D[1][a]=n.D[0][a],n.D[0][a]=t));return!0},xl.gp=function(n,t){n.T|=248&(8|t)},xl.hp=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D;if(xl.tn(n,t),0!=(3&n.u[t])&&3!=(3&n.u[t]))if(2!=n.o[t]||2!=n.j[t])if(n.j[t]<3||n.j[t]>4)xl.nm(n,t,0,!1);else{for(e=n.e[t],h=!1,r=0;r<e;r++)if(1==xl.bl(n,n.k[t][r])){h=!0;break}if(h){for(b=xl.vo(n,t),i=vf(kl.jlb,S,6,e,15,1),o=0;o<e;o++)i[o]=xl.Uk(n,n.i[t][b[o]],t);for(l=0;l<e;l++)n.D[0][n.k[t][l]]==t&&1==xl.bl(n,n.k[t][l])&&(n.H[n.k[t][l]]=1);if(!((n.p&&t<n.f?xl.Jr(n.p,t):0)<=24&&xl.fp(n,t,b,i))){for(d=xl.cp(n,t,!0),n.D[0][d]!=t&&(n.D[1][d]=n.D[0][d],n.D[0][d]=t),c=-1,f=0;f<e;f++)if(d==n.k[t][b[f]]){c=f;break}for(D=Vf(qf(kl.llb,2),ot,8,0,[Vf(qf(kl.llb,1),z,6,15,[2,1,2,1]),Vf(qf(kl.llb,1),z,6,15,[1,2,2,1]),Vf(qf(kl.llb,1),z,6,15,[1,1,2,2]),Vf(qf(kl.llb,1),z,6,15,[2,1,1,2]),Vf(qf(kl.llb,1),z,6,15,[2,2,1,1]),Vf(qf(kl.llb,1),z,6,15,[1,2,1,2])]),a=1;a<e;a++)i[a]<i[0]&&(i[a]+=an);if(3==e){switch(g=!1,c){case 0:g=i[1]<i[2]&&i[2]-i[1]<rn||i[1]>i[2]&&i[1]-i[2]>rn;break;case 1:g=i[2]-i[0]>rn;break;case 2:g=i[1]-i[0]<rn}s=1==(3&n.u[t])^g?257:129}else u=0,i[1]<=i[2]&&i[2]<=i[3]?u=0:i[1]<=i[3]&&i[3]<=i[2]?u=1:i[2]<=i[1]&&i[1]<=i[3]?u=2:i[2]<=i[3]&&i[3]<=i[1]?u=3:i[3]<=i[1]&&i[1]<=i[2]?u=4:i[3]<=i[2]&&i[2]<=i[1]&&(u=5),s=1==(3&n.u[t])^1==D[u][c]?129:257;n.H[d]=s}}}else xl.ep(n,t)},xl.ip=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C;if(0!=(3&n.F[t])&&3!=(3&n.F[t])&&xl.Jo(n,t)){for(m=-1,H=-1,j=-1,D=-1,s=0,g=0;g<2;g++)for(i=n.D[g][t],c=0;c<n.e[i];c++)(o=n.k[i][c])!=t&&1==xl.bl(n,o)&&(r=n.i[i][c],s<(A=xl.xo(n,o,r))&&(s=A,H=r,m=o,j=i,D=n.D[1-g][t]));if(-1!=H){for(u=0;u<2;u++)for(c=0;c<n.e[n.D[u][t]];c++)(o=n.k[n.D[u][t]][c])!=t&&1==xl.bl(n,o)&&(n.H[o]=1);for(n.D[1][m]!=H&&(n.D[0][m]=n.D[1][m],n.D[1][m]=H),l=I,d=0;d<n.j[j];d++)r=n.i[j][d],n.k[j][d]!=t&&l>r&&(l=r);for(h=vf(kl.llb,z,6,2,15,1),b=0,f=0;f<n.j[D];f++)n.k[D][f]!=t&&(h[b++]=n.i[D][f]);a=xl.fn(n.J[j].a,n.J[j].b,n.J[D].a,n.J[D].b),e=0,2==b?(h[0]>h[1]&&(C=h[0],h[0]=h[1],h[1]=C),e=xl.gn(a,xl.Uk(n,D,h[0]))-xl.gn(a,xl.Uk(n,D,h[1]))):e=xl.gn(a,xl.Uk(n,D,h[0])),e<0^2==(3&n.F[t])^l==H?n.H[m]=257:n.H[m]=129}}},xl.jp=function(n){var t,e,i,s;for(xl.nu(n,7),i=0;i<n.g;i++)(257==n.H[i]||129==n.H[i])&&(n.H[i]=1);for(t=0;t<n.f;t++)xl.hp(n,t);for(s=0;s<n.g;s++)xl.ip(n,s);for(e=0;e<n.g;e++)2==n.H[e]&&3==(3&n.F[e])&&(n.H[e]=386)},xl.kp=function(n,t){var e,i,s,a,r,o,l,f,g,u;if(o=vf(kl.llb,z,6,n.q,15,1),(r=xl.$n(n,o,!1,t))<=1)return null;for(l=vf(kl.llb,z,6,r,15,1),i=0;i<n.f;i++)++l[o[i]];for(g=0,u=l[0],f=1;f<r;f++)u<l[f]&&(u=l[f],g=f);for(e=0;e<n.q;e++)o[e]!=g&&(n.C[e]=-1);for(a=0;a<n.r;a++)(!t&&32==n.H[a]||o[n.D[0][a]]!=g)&&(n.H[a]=512);s=xl.ik(n),n.T=0;try{xl.rn(n,!0,!0)}catch(n){if(!_f(n=rg(n),19))throw og(n)}return s},xl.lp=function(n,t){return 0!=(n.u[t]&Pt)||1!=n.C[t]&&(xl.Hl(n,t)||13==n.C[t]||n.C[t]>=171)},xl.mp=function(n){var t,e,i,s,a,r,o,l,f,g;for(r=(a=xl.Sk(n,n.q,n.r,xl.Rj))*a/16,i=1;i<n.q;i++)for(s=0;s<i;s++)if((l=n.J[s].a-n.J[i].a)*l+(f=n.J[s].b-n.J[i].b)*f+(g=n.J[s].c-n.J[i].c)*g<r)throw og(new Jl.aA("The distance between two atoms is too close."));for(xl.nu(n,1),t=0,e=0;e<n.f;e++){if(xl.ko(n,e)>(o=xl.kl(n,e))+xl.il(n,e,o))throw og(new Jl.aA("atom valence exceeded"));t+=n.s[e]}if(0!=t)throw og(new Jl.aA("unbalanced atom charge"))},xl.np=function(n,t,e){var i;return(i=xl.Vm(n,t,e))&&386==e&&(xl.nu(n,7),i&=0==(128&n.F[t])),i},xl.op=function(){xl.Ym.call(this)},xl.pp=function(n,t){xl.Zm.call(this,n,t)},xl.qp=function(n){xl.Zm.call(this,n?n.M:256,n?n.N:256),n&&xl.mk(n,this)},zf(97,113,{97:1,113:1,4:1}),o.Mb=function(n){xl.wn(this,n)},o.Lb=function(n){return xl.Mo(this,n)},o.f=0,o.g=0,kl.Jlb=lg(97),xl.tp=function(t,e){return n.Math.pow(10,n.Math.log(2e3)*n.Math.LOG10E*t/(e-1)-1)},xl.up=function(n,t){var e,i;for(e=t,i=0;0!=t;)0==n.d&&(n.f=(63&n.c[++n.e])<<11,n.d=6),i|=(J&n.f)>>16-e+t,n.f<<=1,--t,--n.d;return i},xl.vp=function(n,t,e){n.d=6,n.e=e,n.c=t,n.f=(63&t[n.e])<<11},xl.wp=function(n,t){var e,i,s;return(s=n>=(i=t/2|0))&&(n-=i),e=(t/32|0)*n/(i-n),s?-e:e},xl.xp=function(n,t){var e;return null==t||0==Rl.LTb(t).length?null:xl.zp(n,Rl.mTb((e=t,Rl.hTb(),e)),null)},xl.yp=function(n,t,e){var i;return null==t?null:xl.zp(n,Rl.mTb((i=t,Rl.hTb(),i)),null==e?null:Rl.mTb(e))},xl.zp=function(n,t,e){var i,s,a,r,o;return xl.vp(n,t,0),i=xl.up(n,4),r=xl.up(n,4),i>8&&(i=r),s=xl.up(n,i),a=xl.up(n,r),o=new xl.Gu(s,a),xl.Dp(n,o,t,e,0),o},xl.Ap=function(n,t,e){var i,s,a;null!=e&&0!=Rl.LTb(e).length?(i=Jl.HHb(e,bg(32)))>0&&i<Rl.LTb(e).length-1?xl.Cp(n,t,Rl.mTb((Rl.FTb(0,i,Rl.LTb(e).length),a=Rl.LTb(e).substr(0,i),Rl.hTb(),a)),Rl.mTb((Rl.GTb(i+1,Rl.LTb(e).length+1),Rl.LTb(e).substr(i+1)))):xl.Cp(n,t,Rl.mTb((s=e,Rl.hTb(),s)),null):xl.Cp(n,t,null,null)},xl.Bp=function(n,t,e,i){var s,a,r,o;a=null==e?null:Rl.mTb((o=e,Rl.hTb(),o)),s=null==i?null:Rl.mTb((r=i,Rl.hTb(),r)),xl.Cp(n,t,a,s)},xl.Cp=function(n,t,e,i){null!=e&&0!=e.length?xl.Dp(n,t,e,i,0):xl.hk(t)},xl.Dp=function(t,e,i,s,a){var r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I,P,M,w,N,L,U,k,J,y,B,R,E,x,F,Q,S,X,G,q,Y,v,Z,O,V,K,W,_,$,en,sn,an,rn,on,ln,gn,un,cn,hn,bn,Dn,Hn,jn,mn,An,Cn,Tn,pn,In,Pn,Mn,wn,Nn,Ln,Un,kn,Jn,yn,Bn,Rn,En,xn,Fn,Qn,Gn,qn,Yn,vn,Zn,On,Vn,Kn,Wn,_n,$n,nt,tt,et,it,st,at,rt,ot,lt,gt,ut,dt,ht,bt,Ht,jt,mt,At,Ct,Tt,pt,It,Pt,Mt,wt,Nt,Lt,Ut,kt;if(xl.hk(e),!(null==i||0>=i.length))if(t.g=e,Pt=8,null!=s&&(a<0||a>=s.length)&&(s=null),xl.vp(t,i,0),l=xl.up(t,4),I=xl.up(t,4),l>8&&(Pt=l,l=I),0!=l){for(f=xl.up(t,l),g=xl.up(t,I),ut=xl.up(t,l),Ht=xl.up(t,l),bt=xl.up(t,l),R=xl.up(t,l),h=0;h<f;h++)xl.Uj(t.g,6);for(on=0;on<ut;on++)xl.vm(t.g,xl.up(t,l),7);for(ln=0;ln<Ht;ln++)xl.vm(t.g,xl.up(t,l),8);for(Cn=0;Cn<bt;Cn++)xl.vm(t.g,xl.up(t,l),xl.up(t,8));for(Jn=0;Jn<R;Jn++)xl.cm(t.g,xl.up(t,l),xl.up(t,4)-8);for(E=1+g-f,X=xl.up(t,4),p=0,xl.sm(t.g,0,0),xl.tm(t.g,0,0),xl.um(t.g,0,0),It=0,wt=0,Lt=0,kt=0,F=!1,Q=!1,(G=null!=s&&s[a]>=39)&&(s.length>2*f-2&&39==s[2*f-2]||s.length>3*f-3&&39==s[3*f-3]?(Q=!0,T=86*(s[(tt=(F=s.length==3*f-3+9)?3*f-3:2*f-2)+1]-40)+s[tt+2]-40,It=n.Math.pow(10,T/2e3-1),Mt=86*(s[(tt+=2)+1]-40)+s[tt+2]-40,wt=n.Math.pow(10,Mt/1500-1),Nt=86*(s[(tt+=2)+1]-40)+s[tt+2]-40,Lt=n.Math.pow(10,Nt/1500-1),F&&(Ut=86*(s[(tt+=2)+1]-40)+s[tt+2]-40,kt=n.Math.pow(10,Ut/1500-1))):F=s.length==3*f-3),t.Nb()&&F&&(s=null,G=!1),vn=1;vn<f;vn++)0!=(q=xl.up(t,X))?(p+=q-1,G&&(xl.sm(t.g,vn,xl.Nk(t.g,p)+s[2*vn-2]-83),xl.tm(t.g,vn,xl.Ok(t.g,p)+s[2*vn-1]-83),F&&xl.um(t.g,vn,xl.Pk(t.g,p)+(s[2*f-3+vn]-83))),xl.Wj(t.g,p,vn,1)):(G&&(xl.sm(t.g,vn,xl.Nk(t.g,0)+8*(s[2*vn-2]-83)),xl.tm(t.g,vn,xl.Ok(t.g,0)+8*(s[2*vn-1]-83)),F&&xl.um(t.g,vn,xl.Pk(t.g,0)+8*(s[2*f-3+vn]-83))),++E);for(Kn=0;Kn<E;Kn++)xl.Wj(t.g,xl.up(t,l),xl.up(t,l),1);for(et=vf(kl.Cwb,nn,6,g,16,1),U=0;U<g;U++)switch(xl.up(t,2)){case 0:et[U]=!0;break;case 2:xl.Fm(t.g,U,2);break;case 3:xl.Fm(t.g,U,4)}for(o=xl.up(t,l),Wn=0;Wn<o;Wn++)if(c=xl.up(t,l),8==Pt)3==(jt=xl.up(t,2))?(xl.hm(t.g,c,1,0),xl.nm(t.g,c,1,!1)):xl.nm(t.g,c,jt,!1);else switch(jt=xl.up(t,3)){case 4:xl.nm(t.g,c,1,!1),xl.hm(t.g,c,1,xl.up(t,3));break;case 5:xl.nm(t.g,c,2,!1),xl.hm(t.g,c,1,xl.up(t,3));break;case 6:xl.nm(t.g,c,1,!1),xl.hm(t.g,c,2,xl.up(t,3));break;case 7:xl.nm(t.g,c,2,!1),xl.hm(t.g,c,2,xl.up(t,3));break;default:xl.nm(t.g,c,jt,!1)}for(8==Pt&&0==xl.up(t,1)&&(t.g.L=!0),r=xl.up(t,I),_n=0;_n<r;_n++)if(M=xl.up(t,I),1==xl.el(t.g,M))switch(jt=xl.up(t,3)){case 4:xl.Cm(t.g,M,1,!1),xl.zm(t.g,M,1,xl.up(t,3));break;case 5:xl.Cm(t.g,M,2,!1),xl.zm(t.g,M,1,xl.up(t,3));break;case 6:xl.Cm(t.g,M,1,!1),xl.zm(t.g,M,2,xl.up(t,3));break;case 7:xl.Cm(t.g,M,2,!1),xl.zm(t.g,M,2,xl.up(t,3));break;default:xl.Cm(t.g,M,jt,!1)}else xl.Cm(t.g,M,xl.up(t,2),!1);for(xl.Hm(t.g,1==xl.up(t,1)),d=null,ht=0;1==xl.up(t,1);)switch(ht+xl.up(t,4)){case 0:for(dt=xl.up(t,l),$n=0;$n<dt;$n++)c=xl.up(t,l),xl.om(t.g,c,zn,!0);break;case 1:for(dt=xl.up(t,l),nt=0;nt<dt;nt++)c=xl.up(t,l),lt=xl.up(t,8),xl.mm(t.g,c,lt);break;case 2:for(dt=xl.up(t,I),gn=0;gn<dt;gn++)xl.up(t,I);break;case 3:for(dt=xl.up(t,l),un=0;un<dt;un++)c=xl.up(t,l),xl.om(t.g,c,fn,!0);break;case 4:for(dt=xl.up(t,l),cn=0;cn<dt;cn++)c=xl.up(t,l),Tt=xg(Mg(xl.up(t,4)),3),xl.om(t.g,c,Tt,!0);break;case 5:for(dt=xl.up(t,l),hn=0;hn<dt;hn++)c=xl.up(t,l),u=xg(Mg(xl.up(t,2)),1),xl.om(t.g,c,u,!0);break;case 6:for(dt=xl.up(t,l),bn=0;bn<dt;bn++)c=xl.up(t,l),xl.om(t.g,c,1,!0);break;case 7:for(dt=xl.up(t,l),Dn=0;Dn<dt;Dn++)c=xl.up(t,l),sn=xg(Mg(xl.up(t,4)),7),xl.om(t.g,c,sn,!0);break;case 8:for(dt=xl.up(t,l),Hn=0;Hn<dt;Hn++){for(c=xl.up(t,l),m=xl.up(t,4),H=vf(kl.llb,z,6,m,15,1),it=0;it<m;it++)j=xl.up(t,8),H[it]=j;xl.im(t.g,c,H)}break;case 9:for(dt=xl.up(t,I),jn=0;jn<dt;jn++)M=xl.up(t,I),Tt=xl.up(t,2)<<7,xl.Em(t.g,M,Tt,!0);break;case 10:for(dt=xl.up(t,I),mn=0;mn<dt;mn++)M=xl.up(t,I),J=xl.up(t,5),xl.Em(t.g,M,J,!0);break;case 11:for(dt=xl.up(t,l),An=0;An<dt;An++)c=xl.up(t,l),xl.om(t.g,c,Xn,!0);break;case 12:for(dt=xl.up(t,I),Tn=0;Tn<dt;Tn++)M=xl.up(t,I),y=xl.up(t,8)<<9,xl.Em(t.g,M,y,!0);break;case 13:for(dt=xl.up(t,l),pn=0;pn<dt;pn++)c=xl.up(t,l),mt=xg(Mg(xl.up(t,3)),14),xl.om(t.g,c,mt,!0);break;case 14:for(dt=xl.up(t,l),In=0;In<dt;In++)c=xl.up(t,l),gt=xg(Mg(xl.up(t,5)),17),xl.om(t.g,c,gt,!0);break;case 15:case 31:ht+=16;break;case 16:for(dt=xl.up(t,l),Pn=0;Pn<dt;Pn++)c=xl.up(t,l),Ct=xg(Mg(xl.up(t,3)),22),xl.om(t.g,c,Ct,!0);break;case 17:for(dt=xl.up(t,l),Mn=0;Mn<dt;Mn++)c=xl.up(t,l),xl.am(t.g,c,xl.up(t,4));break;case 18:for(dt=xl.up(t,l),ot=xl.up(t,4),wn=0;wn<dt;wn++){for(c=xl.up(t,l),S=xl.up(t,ot),st=vf(kl.hlb,ft,6,S,15,1),it=0;it<S;it++)st[it]=xl.up(t,7)<<24>>24;xl.fm(t.g,c,Jl.WHb(Rl.kTb(st,0,(at=st.length,Rl.hTb(),at))))}break;case 19:for(dt=xl.up(t,l),Nn=0;Nn<dt;Nn++)c=xl.up(t,l),B=xg(Mg(xl.up(t,3)),25),xl.om(t.g,c,B,!0);break;case 20:for(dt=xl.up(t,I),Ln=0;Ln<dt;Ln++)M=xl.up(t,I),Ct=xl.up(t,3)<<17,xl.Em(t.g,M,Ct,!0);break;case 21:for(dt=xl.up(t,l),Un=0;Un<dt;Un++)c=xl.up(t,l),xl.pm(t.g,c,xl.up(t,2)<<4);break;case 22:for(dt=xl.up(t,l),kn=0;kn<dt;kn++)c=xl.up(t,l),xl.om(t.g,c,Sn,!0);break;case 23:for(dt=xl.up(t,I),yn=0;yn<dt;yn++)M=xl.up(t,I),xl.Em(t.g,M,ct,!0);break;case 24:for(dt=xl.up(t,I),Bn=0;Bn<dt;Bn++)M=xl.up(t,I),u=xl.up(t,2)<<21,xl.Em(t.g,M,u,!0);break;case 25:for(Rn=0;Rn<f;Rn++)1==xl.up(t,1)&&xl.qm(t.g,Rn,!0);break;case 26:for(dt=xl.up(t,I),d=vf(kl.llb,z,6,dt,15,1),En=0;En<dt;En++)d[En]=xl.up(t,I);break;case 27:for(dt=xl.up(t,l),xn=0;xn<dt;xn++)c=xl.up(t,l),xl.om(t.g,c,tn,!0);break;case 28:for(dt=xl.up(t,I),Fn=0;Fn<dt;Fn++)xl.Fm(t.g,xl.up(t,I),32);break;case 29:for(dt=xl.up(t,l),Qn=0;Qn<dt;Qn++)c=xl.up(t,l),en=xg(Mg(xl.up(t,2)),30),xl.om(t.g,c,en,!0);break;case 30:for(dt=xl.up(t,l),Gn=0;Gn<dt;Gn++)c=xl.up(t,l),Ct=xg(Mg(xl.up(t,7)),32),xl.om(t.g,c,Ct,!0);break;case 32:for(dt=xl.up(t,l),qn=0;qn<dt;qn++)c=xl.up(t,l),pt=xg(Mg(xl.up(t,2)),44),xl.om(t.g,c,pt,!0);break;case 33:for(dt=xl.up(t,l),Yn=0;Yn<dt;Yn++)c=xl.up(t,l),V=xg(Mg(xl.up(t,5)),39),xl.om(t.g,c,V,!0);break;case 34:for(dt=xl.up(t,l),Zn=0;Zn<dt;Zn++)c=xl.up(t,l),xl.om(t.g,c,dn,!0);break;case 35:for(dt=xl.up(t,I),On=0;On<dt;On++)M=xl.up(t,I),xl.Em(t.g,M,Dt,!0);break;case 36:for(dt=xl.up(t,I),Vn=0;Vn<dt;Vn++)M=xl.up(t,I),k=xl.up(t,2)<<5,xl.Em(t.g,M,k,!0);break;case 37:for(dt=xl.up(t,I),rn=0;rn<dt;rn++)M=xl.up(t,I),k=0==xl.up(t,1)?8:16,xl.Fm(t.g,M,k)}if(xl.je(new xl.te(t.g),et,!1),null!=d)for(N=0,L=(w=d).length;N<L;++N)M=w[N],xl.Fm(t.g,M,2==xl.el(t.g,M)?4:2);if(null==s&&!t.i&&i.length>t.e+1&&(32==i[t.e+1]||9==i[t.e+1])&&(s=i,a=t.e+2),null!=s)try{if(33==s[a]||35==s[a]){for(xl.vp(t,s,a+1),F=1==xl.up(t,1),Q=1==xl.up(t,1),P=1<<(At=2*xl.up(t,4)),_=0,M=0,b=1;b<f;b++)M<g&&xl.Vk(t.g,1,M)==b?(_=xl.Vk(t.g,0,M++),W=1):(_=0,W=8),xl.sm(t.g,b,xl.Nk(t.g,_)+W*(xl.up(t,At)-(P/2|0))),xl.tm(t.g,b,xl.Ok(t.g,_)+W*(xl.up(t,At)-(P/2|0))),F&&xl.um(t.g,b,xl.Pk(t.g,_)+W*(xl.up(t,At)-(P/2|0)));if(35==s[a]){for(an=0,$=vf(kl.llb,z,6,f,15,1),D=0;D<f;D++)an+=$[D]=xl.fo(t.g,D);for(c=0;c<f;c++)for(rn=0;rn<$[c];rn++)sn=xl.Uj(t.g,1),xl.Wj(t.g,c,sn,1),xl.sm(t.g,sn,xl.Nk(t.g,c)+(xl.up(t,At)-(P/2|0))),xl.tm(t.g,sn,xl.Ok(t.g,c)+(xl.up(t,At)-(P/2|0))),F&&xl.um(t.g,sn,xl.Pk(t.g,c)+(xl.up(t,At)-(P/2|0)));f+=an,g+=an}if(C=F?1.5:(xl.Sj(),xl.Sj(),xl.Rj),A=xl.Sk(t.g,f,g,C),Q)for(wt=(It=xl.tp(xl.up(t,At),P))*xl.wp(xl.up(t,At),P),Lt=It*xl.wp(xl.up(t,At),P),F&&(kt=It*xl.wp(xl.up(t,At),P)),W=It/A,c=0;c<f;c++)xl.sm(t.g,c,wt+W*xl.Nk(t.g,c)),xl.tm(t.g,c,Lt+W*xl.Ok(t.g,c)),F&&xl.um(t.g,c,kt+W*xl.Pk(t.g,c));else for(W=(It=1.5)/A,c=0;c<f;c++)xl.sm(t.g,c,W*xl.Nk(t.g,c)),xl.tm(t.g,c,W*xl.Ok(t.g,c)),F&&xl.um(t.g,c,W*xl.Pk(t.g,c))}else if(F&&!Q&&0==It&&(It=1.5),0!=It&&0!=t.g.r){for(A=0,M=0;M<t.g.r;M++)Y=xl.Nk(t.g,xl.Vk(t.g,0,M))-xl.Nk(t.g,xl.Vk(t.g,1,M)),v=xl.Ok(t.g,xl.Vk(t.g,0,M))-xl.Ok(t.g,xl.Vk(t.g,1,M)),Z=F?xl.Pk(t.g,xl.Vk(t.g,0,M))-xl.Pk(t.g,xl.Vk(t.g,1,M)):0,A+=n.Math.sqrt(Y*Y+v*v+Z*Z);for(K=It/(A/=t.g.r),c=0;c<t.g.q;c++)xl.sm(t.g,c,xl.Nk(t.g,c)*K+wt),xl.tm(t.g,c,xl.Ok(t.g,c)*K+Lt),F&&xl.um(t.g,c,xl.Pk(t.g,c)*K+kt)}}catch(n){if(!_f(n=rg(n),19))throw og(n);O=n,Jl.Jz(O,(Jl.oIb(),Jl.nIb),""),Jl.Nz(O,O.Wb()),Jl.WHb(Rl.kTb(i,0,(rt=i.length,Rl.hTb(),rt))),Jl.WHb(Rl.kTb(s,0,at=s.length)),s=null,F=!1}if((x=null!=s&&!F)||t.Nb())for(xl.nu(t.g,7),M=0;M<t.g.g;M++)2==xl.bl(t.g,M)&&!xl.Yo(t.g,M)&&0==xl.cl(t.g,M)&&xl.Dm(t.g,M);if(xl.gp(t.g,0),!x&&t.Nb())try{t.Ob(t.g),x=!0}catch(n){if(!_f(n=rg(n),19))throw og(n);O=n,Jl.Jz(O,(Jl.oIb(),Jl.nIb),""),Jl.Nz(O,O.Wb()),Jl.WHb(Rl.kTb(i,0,(at=i.length,Rl.hTb(),at)))}x?(xl.jp(t.g),xl.Au(t.g)):F||xl.gp(t.g,0)}else xl.Hm(t.g,1==xl.up(t,1))},xl.Ep=function(n,t){var e,i,s,a,r,o;if(!(t.length<=0||t[0]<64))for(xl.vp(n,t,0),o=xl.up(n,4),s=1==xl.up(n,1),a=1==xl.up(n,1),e=0;e<n.g.f;e++)r=xl.up(n,o),i=s,s&&a&&(i=1==xl.up(n,1)),xl.km(n.g,e,r,i)},xl.Fp=function(){},zf(396,1,{},xl.Fp),o.Nb=function(){return!1},o.Ob=function(n){throw og(new Jl.aA("Unexpected request to invent coordinates. Check source code logic!"))},o.d=0,o.e=0,o.f=0,o.i=!1,kl.Klb=lg(396),xl.Ip=function(n){},xl.Jp=function(){xl.Kp.call(this,!0)},xl.Kp=function(n){xl.Ip(this),this.b=n},zf(51,396,{},xl.Jp,xl.Kp),o.Nb=function(){return this.b},o.Ob=function(n){var t;(t=new Xl.yy(this.a)).g=new Fl.VQb(78187493520),Xl.fy(t,n)},o.a=2,o.b=!1,kl.Llb=lg(51),xl.Np=function(t,e,i,s){var a,r,o,l,f,g,u,d,c,h,b,D,H,j;a=e.a,h=e.g,g=Bg(Cg(xl.Lk(t.k,a),1),0),d=null!=(r=xl.Gk(t.k,a))?xl.Up(t,a,r,s):g?"*":xl.Fk(t.k,a),!g&&null==r&&xl.Ho(t.k,a)&&0==(4&t.j)&&(0!=xl.In(t.k,a)||-1==xl.xk(t.k,a)&&0==xl.Mk(t.k,a))&&(d=Rl.LTb(d).toLowerCase()),e.f&&(i.a+="("),-1!=h&&xl.Rp(t,xl.Pn(t.k,e.a,e.g),e.g,i),0==(o=xl.zk(t.k,a))&&0!=(1&t.j)&&(0==Tg(l=Cg(xl.Lk(t.k,a),bn),jn)?o=-1:0==Tg(l,Hn)&&(o=1)),u=xl.Jk(t.k,a),c=0!=(2&t.j)?xl.Ik(t.k,a):0,b=0!=(1&t.j)?xl.$p(t,a,s):null,(j=!g&&!xl.fq(xl.Qk(t.k,a))||null!=r||(1==xl.Kk(t.k,a)||2==xl.Kk(t.k,a))&&!(-1!=(H=xl.Ek(t.k,a)-1)&&t.i[H][xl.Dk(t.k,a)]<=1)&&(7!=xl.Qk(t.k,a)||xl.zk(t.k,a)>0)||xl.Ho(t.k,a)&&0==xl.In(t.k,a)&&0==(4&t.j)||0!=o||0!=u||0!=c||-1!=xl.xk(t.k,a)||0!=xl.Mk(t.k,a)||null!=b)&&(i.a+="["),0!=u&&(i.a+=u),i.a+=""+d,(1==xl.Kk(t.k,a)||2==xl.Kk(t.k,a))&&!(-1!=(D=xl.Ek(t.k,a)-1)&&t.i[D][xl.Dk(t.k,a)]<=1)&&(7!=xl.Qk(t.k,a)||xl.zk(t.k,a)>0)&&Jl.gIb(i,xl.Zp(t,a,h)),0==(1&t.j)&&j&&(1==(f=xl.qo(t.k,a))?i.a+="H":f>1&&(i.a+="H"+f)),0!=o&&(i.a+=String.fromCharCode(o>0?43:45),n.Math.abs(o)>1&&Jl.dIb(i,n.Math.abs(o))),null!=b&&(i.a+=""+b),0!=c&&(i.a+=":",i.a+=c),j&&(i.a+="]"),xl.Sp(t,e,i),e.e&&(i.a+=")")},xl.Op=function(n,t,e){var i,s,a,r,o;for(a=!0,o=Fl.Xi(n.g,t).a,r=xl.bq(n,o);-1!=r;)i=xl.Rn(n.k,o,r),s=xl.Tn(n.k,o,r),r=xl.bq(n,i),xl.Qp(n,new xl.Ct(i,s,o,e&&a,e&&-1==r),++t),o=i,a=!1},xl.Pp=function(n,t,e){var i,s,a,r;for(a=0,r=(s=t).length;a<r;++a)i=s[a],n.f[1073741823&i]=0!=(i&St)^e?2:1},xl.Qp=function(n,t,e){Fl.Ri(n.g,e,t),n.b[t.a]=!0,-1!=t.g&&(n.c[xl.Pn(n.k,t.a,t.g)]=!0)},xl.Rp=function(n,t,e,i){var s,a,r,o,l;l=Rl.LTb(i.a).length,0!=n.f[t]&&Jl.cIb(i,1==n.f[t]?47:92),1==n.j&&0!=(a=xl.dl(n.k,127))&&(0!=(1&a)&&0==n.f[t]&&(i.a+="-"),0!=(2&a)&&(Rl.LTb(i.a).length!=l&&(i.a+=","),i.a+="="),0!=(4&a)&&(Rl.LTb(i.a).length!=l&&(i.a+=","),i.a+="#"),0!=(8&a)&&(Rl.LTb(i.a).length!=l&&(i.a+=","),i.a+="$"),0!=(16&a)&&(Rl.LTb(i.a).length!=l&&(i.a+=","),i.a+="$"),0!=(64&a)&&(Rl.LTb(i.a).length!=l&&(i.a+=","),i.a+=":"),0!=(32&a)&&(Rl.LTb(i.a).length!=l&&(i.a+=","),Jl.gIb(i,xl.Fl(n.k,e)?"<-":"->"))),l!=Rl.LTb(i.a).length||xl.Io(n.k,t)&&0==(4&n.j)||(1==(s=127&xl.el(n.k,t))?xl.Ho(n.k,xl.Vk(n.k,0,t))&&xl.Ho(n.k,xl.Vk(n.k,1,t))&&0==(4&n.j)&&0==n.f[t]&&(i.a+="-"):2==s?i.a+="=":4==s?i.a+="#":8==s||16==s?i.a+="$":64==s?i.a+=":":32==s&&Jl.gIb(i,xl.Fl(n.k,e)?"<-":"->")),1==n.j&&(r=l==Rl.LTb(i.a).length?"":";",256==(o=384&xl.dl(n.k,t))?i.a+=r+"@":128==o&&(i.a+=r+"!@"))},xl.Sp=function(n,t,e){var i,s,a;if(null!=t.c)for(s=0;s<t.c.length;s++)for(a=0;a<xl.Sn(n.k,t.a);a++)t.c[s]==xl.Rn(n.k,t.a,a)&&(i=xl.Tn(n.k,t.a,a),t.d[s]||xl.Rp(n,i,t.a,e),n.e[i]>9&&(e.a+="%"),Jl.dIb(e,n.e[i]))},xl.Tp=function(n){var t,e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,P,M,w,N,L,U,k,J,y,B,R,E,x;for(R=new Fl.kj,H=new Fl.rOb(n.g);H.a<H.c.a.length;)if(-1!=(D=Fl.qOb(H)).g&&(m=xl.Pn(n.k,D.a,D.g),!(xl.Jo(n.k,m)||xl.Yo(n.k,m)||1!=xl.cl(n.k,m)&&2!=xl.cl(n.k,m)))){if(y=Fl.Xi(n.g,n.q[D.g]),e=vf(kl.llb,z,6,xl.Sn(n.k,D.a)+xl.Sn(n.k,y.a)-2,15,1),P=0,B=!1,-1!=y.g)e[P++]=y.b;else{for(A=-1,E=-1,C=I,w=0;w<xl.Sn(n.k,y.a);w++)(u=xl.Rn(n.k,y.a,w))!=D.a&&(-1==A?(A=w,C=n.q[u]):C<n.q[u]?E=w:(E=A,A=w));-1==E?(U=xl.Rn(n.k,y.a,A),k=xl.Tn(n.k,y.a,A),e[P++]=k|(xl.dq(n,y.a,U)?St:0)):(d=xl.Rn(n.k,y.a,A),h=xl.Tn(n.k,y.a,A),c=xl.Rn(n.k,y.a,E),b=xl.Tn(n.k,y.a,E),e[P++]=h|(xl.dq(n,y.a,d)?St:0),e[P++]=b|(xl.dq(n,y.a,c)?0:St))}if(3==xl.Sn(n.k,y.a)&&-1!=y.g)for(w=0;w<xl.Sn(n.k,y.a);w++)if((u=xl.Rn(n.k,y.a,w))!=y.g&&u!=D.a){i=xl.Tn(n.k,y.a,w),e[P++]=i|(xl.dq(n,y.a,u)?St:0),u<y.g&&(B=!B);break}for(2==xl.cl(n.k,m)&&(B=!B),M=0;M<xl.Sn(n.k,D.a);M++)if((l=xl.Rn(n.k,D.a,M))!=D.g){if(p=B,3==xl.Sn(n.k,D.a))for(L=0;L<xl.Sn(n.k,D.a);L++)if((u=xl.Rn(n.k,D.a,L))!=D.g&&u!=l){u<l&&(p=!p);break}xl.Al(n.k,m)&&(T=xl.Pf(n.d,m),n.n[T]||(n.n[T]=!0,n.o[T]=p),n.o[T]&&(p=!p)),f=xl.Pn(n.k,D.a,l),e[P++]=f|(p^xl.dq(n,D.a,l)?0:St)}Rl.cTb(R.a,e)}for(n.f=vf(kl.llb,z,6,n.k.g,15,1),0!=R.a.length&&xl.Pp(n,Fl.cj(R,0),!1);0!=R.a.length;){for(x=R.a.length,M=R.a.length-1;M>=0;M--){for(Rl.zTb(M,R.a.length),J=0,N=!1,g=!1,r=0,o=(a=e=R.a[M]).length;r<o;++r)t=1073741823&(s=a[r]),0!=n.f[t]&&(j=0!=(s&St)^2==n.f[t],0==J?N=j:N!=j&&(g=!0),++J);0!=J&&(e=Fl.cj(R,M),g||xl.Pp(n,e,N))}x==R.a.length&&xl.Pp(n,Fl.cj(R,0),!1)}},xl.Up=function(n,t,e,i){var s,a,r,o,l,f,g;for(0<(g=Rl.LTb(i.a).length)?i.a=Jl.RHb(i.a,0,0):0>g&&(i.a+=Jl.WHb(vf(kl.ilb,st,6,-g,15,1))),l=xl.Ho(n.k,t)&&0==(4&n.j),r=0,o=(a=e).length;r<o;++r)s=a[r],0!=Rl.LTb(i.a).length&&(i.a+=","),f=(xl.Sj(),xl.Mj)[s],Jl.gIb(i,l?Rl.LTb(f).toLowerCase():f);return i.a},xl.Vp=function(n){var t,e,i,s,a,r,o,l;if(!n.k||0==n.k.q)return"";for(xl.nu(n.k,15),n.d=new xl.ig(n.k,129),s=n.d.R,n.o=vf(kl.Cwb,nn,6,s+1,16,1),n.n=vf(kl.Cwb,nn,6,s+1,16,1),n.i=Yf(kl.llb,[ot,z],[8,6],15,[2,32],2),t=0;t<n.k.f;t++)-1!=(l=xl.Ek(n.k,t)-1)&&++n.i[l][xl.Dk(n.k,t)];for(xl.Yp(n),xl.Wp(n),xl.Tp(n),i=new Jl.jIb,e=new Jl.jIb,a=!0,o=new Fl.rOb(n.g);o.a<o.c.a.length;)-1==(r=Fl.qOb(o)).g&&(a?a=!1:i.a+="."),xl.Np(n,r,i,e);return i.a},xl.Wp=function(n){var t,e,i,s,a,r,o,l,f,g,u;for(u=new Fl.rOb(n.g);u.a<u.c.a.length;){for(f=Fl.qOb(u),e=0,a=0;a<xl.Sn(n.k,f.a);a++)n.c[xl.Tn(n.k,f.a,a)]||++e;if(0!=e){for(f.c=vf(kl.llb,z,6,e,15,1),e=0,r=0;r<xl.Sn(n.k,f.a);r++)n.c[xl.Tn(n.k,f.a,r)]||(l=xl.Rn(n.k,f.a,r),f.c[e++]=n.q[l]<<16|l);for(Rl.fTb(f.c,Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[]))),s=0;s<f.c.length;s++)f.c[s]=y&f.c[s]}}for(i=vf(kl.Cwb,nn,6,n.k.g,16,1),n.e=vf(kl.llb,z,6,n.k.g,15,1),g=new Fl.rOb(n.g);g.a<g.c.a.length;)if(null!=(f=Fl.qOb(g)).c)for(f.d=vf(kl.Cwb,nn,6,f.c.length,16,1),s=0;s<f.c.length;s++)for(o=0;o<xl.Sn(n.k,f.a);o++)if(f.c[s]==xl.Rn(n.k,f.a,o))if(t=xl.Tn(n.k,f.a,o),n.c[t])i[n.e[t]]=!1;else{for(n.c[t]=!0,f.d[s]=!0,n.e[t]=1;i[n.e[t]];)++n.e[t];i[n.e[t]]=!0}},xl.Xp=function(n){var t,e,i,s;for(i=-1,s=I,t=0;t<n.k.f;t++)n.b[t]||(e=n.a[t],Bg(Cg(xl.Lk(n.k,t),tn),0)&&(e+=St),0==xl.Sn(n.k,t)?e+=1056964608:e+=xl.Sn(n.k,t)<<24,s>e&&(s=e,i=t));return i},xl.Yp=function(n){var t,e,i,s,a;for(n.a=n.d.d,n.b=vf(kl.Cwb,nn,6,n.k.f,16,1),n.c=vf(kl.Cwb,nn,6,n.k.g,16,1),n.g=new Fl.kj,t=xl.Xp(n);-1!=t;){if(e=n.g.a.length,xl.Qp(n,new xl.Ct(t,-1,-1,!1,!1),e),0!=xl.Sn(n.k,t))for(xl.Op(n,e,!1);e<n.g.a.length-1;){for(;xl.cq(n,Fl.Xi(n.g,e).a);)xl.Op(n,e,!0);++e}t=xl.Xp(n)}for(n.q=vf(kl.llb,z,6,n.k.f,15,1),i=0,a=new Fl.rOb(n.g);a.a<a.c.a.length;)s=Fl.qOb(a),n.q[s.a]=i++},xl.Zp=function(n,t,e){var i,s,a,r,o,l,f,g,u,d,c;if(o=!1,0!=xl.In(n.k,t)&&2==xl.Sn(n.k,t)&&2==xl.Un(n.k,t,0)&&2==xl.Un(n.k,t,1))for(a=0;a<xl.Sn(n.k,t);a++){for(i=xl.Rn(n.k,t,a),c=0,d=vf(kl.llb,z,6,3,15,1),f=0;f<xl.Sn(n.k,i);f++)d[c]=xl.Rn(n.k,i,f),d[c]!=t&&++c;2==c&&n.q[d[0]]<n.q[d[1]]^d[0]<d[1]&&(o=!o)}else{for(g=vf(kl.llb,z,6,4,15,1),u=vf(kl.llb,z,6,4,15,1),r=0,-1!=e&&(g[r]=e,u[r++]=8*n.q[e]),(0!=xl.fo(n.k,t)||3==xl.Sn(n.k,t))&&(g[r]=I,u[r++]=8*n.q[t]),a=0;a<xl.Sn(n.k,t);a++)(i=xl.Rn(n.k,t,a))!=e&&(g[r]=i,u[r++]=xl.aq(n,t,a));o=xl.eq(g,u)}return l=1==xl.Kk(n.k,t)^o,xl.tl(n.k,t)&&(s=xl.Qf(n.d,t),n.n[s]||(n.n[s]=!0,n.o[s]=l),n.o[s]&&(l=!l)),l?"@@":"@"},xl.$p=function(n,t,e){var i,s,a,r,o,l,f;switch(0<(r=Rl.LTb(e.a).length)?e.a=Jl.RHb(e.a,0,0):0>r&&(e.a+=Jl.WHb(vf(kl.ilb,st,6,-r,15,1))),zg(Fg(Cg(o=xl.Lk(n.k,t),bn),3))){case 20971520:e.a+="+0";break;case 25165824:0==xl.zk(n.k,t)&&(e.a+="-");break;case 12582912:0==xl.zk(n.k,t)&&(e.a+="+")}return 0==Tg(i=Cg(o,dt),2)?e.a+=";a":0==Tg(i,4)&&(e.a+=";A"),0!=Tg(s=Cg(o,cn),0)&&(0==Tg(s,1792)?e.a+=";H0":0==Tg(s,1664)?e.a+=";H1":0==Tg(s,1408)?e.a+=";H2":0==Tg(s,896)?e.a+=";H3":0==Tg(s,128)?e.a+=";!H0":0==Tg(s,384)?e.a+=";!H0;!H1":0==Tg(s,1536)?e.a+=";!H2;!H3":0==Tg(s,hn)&&(e.a+=";!H3")),0==Tg(f=Cg(o,120),8)?e.a+=";!R0":0==Tg(f,16)?e.a+=";!R1":0==Tg(f,32)?e.a+=";!R2":0==Tg(f,64)?e.a+=";!R3":0==Tg(f,112)?e.a+=";R0":0==Tg(f,104)?e.a+=";R1":0==Tg(f,88)?e.a+=";R2":0==Tg(f,56)&&(e.a+=";R3"),0==Tg(l=Cg(o,v),Z)?e.a+=";!r"+Gg(l):0==Tg(l,Xt)?e.a+=";r"+Gg(l):0!=Tg(l,0)&&(Bg(Cg(l,$),0)?(Ig(Cg(l,Z),0)&&(e.a+=";!r0"+Gg(l)),Ig(Cg(l,O),0)&&(e.a+=";!r3"+Gg(l)),Ig(Cg(l,V),0)&&(e.a+=";!r4"+Gg(l)),Ig(Cg(l,K),0)&&(e.a+=";!r5"+Gg(l)),Ig(Cg(l,W),0)&&(e.a+=";!r6"+Gg(l)),Ig(Cg(l,_),0)&&(e.a+=";!r7"+Gg(l))):(e.a+=";",Bg(Cg(l,Z),0)&&(e.a+="r0,"+Gg(l)),Bg(Cg(l,O),0)&&(e.a+="r3,"+Gg(l)),Bg(Cg(l,V),0)&&(e.a+="r4,"+Gg(l)),Bg(Cg(l,K),0)&&(e.a+="r5,"+Gg(l)),Bg(Cg(l,W),0)&&(e.a+="r6,"+Gg(l)),Bg(Cg(l,_),0)&&(e.a+="r7,"+Gg(l)),Jl.$Eb(e,Rl.LTb(e.a).length-1))),0==Tg(l,0)&&0!=Tg(l=Fg(Cg(o,Qn),22),0)&&(e.a+=";r"+Gg(l)),0==Tg(a=Cg(o,An),Cn)&&(e.a+=";D1"),0==Tg(a,Tn)&&(e.a+=";D2"),0==Tg(a,pn)&&(e.a+=";D3"),0==Tg(a,In)&&(e.a+=";!D3;!D4"),0==Tg(a,Pn)&&(e.a+=";!D4"),0==Tg(a,Mn)&&(e.a+=";!D0;!D1"),0==Tg(a,wn)&&(e.a+=";!D0;!D1;!D2"),0==Tg(a,Nn)&&(e.a+=";!D0;!D1;!D2;!D3"),Bg(Cg(o,zn),0)&&Jl.gIb(e,";D"+xl.Sn(n.k,t)),Bg(Cg(o,fn),0)&&Jl.gIb(e,";!D"+xl.Sn(n.k,t)),0==Rl.LTb(e.a).length?null:e.a},xl._p=function(n){return null==n.p&&(n.p=xl.Vp(n)),n.p},xl.aq=function(n,t,e){var i,s,a,r,o;if(i=xl.Tn(n.k,t,e),r=xl.Rn(n.k,t,e),0!=n.e[i]){for(o=8*n.q[t]+1,s=Fl.Xi(n.g,n.q[t]).c,a=0;a<s.length&&r!=s[a];a++)++o;return o}return 8*n.q[r]},xl.bq=function(n,t){var e,i,s,a,r;for(e=-1,i=-1,a=0;a<xl.Sn(n.k,t);a++)s=xl.Rn(n.k,t,a),r=(xl.Un(n.k,t,a)<<24)+n.a[s],!n.b[s]&&(-1==e||i<r)&&(e=a,i=r);return e},xl.cq=function(n,t){var e;for(e=0;e<xl.Sn(n.k,t);e++)if(!n.b[xl.Rn(n.k,t,e)])return!0;return!1},xl.dq=function(n,t,e){var i;return Fl.Xi(n.g,n.q[t]).g!=e&&((i=Fl.Xi(n.g,n.q[e])).g==t||xl.Bt(i,t))},xl.eq=function(n,t){var e,i,s;for(i=!1,e=1;e<4;e++)for(s=0;s<e;s++)n[s]>n[e]&&(i=!i),t[s]>t[e]&&(i=!i);return i},xl.fq=function(n){return n>=5&&n<=9||n>=15&&n<=17||35==n||53==n},xl.gq=function(n){xl.iq.call(this,n,!1)},xl.hq=function(n,t){this.k=n,this.j=t},xl.iq=function(n,t){xl.hq.call(this,n,t?2:0)},xl.jq=function(n){var t,e,i,s;for(s=new Jl.jIb,e=0;e<n.g.a.length;e++)0!=e&&(s.a+="."),Jl.gIb(s,xl._p(new xl.hq(Fl.Xi(n.g,e),2)));for(s.a+=">",i=0;i<n.a.a.length;i++)0!=i&&(s.a+="."),Jl.gIb(s,xl._p(new xl.gq(Fl.Xi(n.a,i))));for(s.a+=">",t=0;t<n.f.a.length;t++)0!=t&&(s.a+="."),Jl.gIb(s,xl._p(new xl.hq(Fl.Xi(n.f,t),2)));return s.a},zf(112,1,{},xl.gq,xl.hq,xl.iq),o.j=0,kl.Mlb=lg(112),xl.kq=function(n,t){this.b=n,this.a=t},zf(3,1,{3:1},xl.kq),o.a=0,o.b=0,kl.Nlb=lg(3),xl.mq=function(){xl.mq=Sf,xl.lq=Vf(qf(kl.Nlb,2),j,17,0,[null,Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(0,1.007825032),new xl.kq(1,2.014101778),new xl.kq(2,3.016049268),new xl.kq(3,4.027834627),new xl.kq(4,5.039542911),new xl.kq(5,6.044942608)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(1,3.01602931),new xl.kq(2,4.00260325),new xl.kq(3,5.012223628),new xl.kq(4,6.018888072),new xl.kq(5,7.028030527),new xl.kq(6,8.033921838),new xl.kq(7,9.043820323),new xl.kq(8,10.052399713)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(1,4.027182329),new xl.kq(2,5.012537796),new xl.kq(3,6.015122281),new xl.kq(4,7.016004049),new xl.kq(5,8.02248667),new xl.kq(6,9.026789122),new xl.kq(7,10.035480884),new xl.kq(8,11.043796166),new xl.kq(9,12.05378)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(1,5.04079),new xl.kq(2,6.019725804),new xl.kq(3,7.016929246),new xl.kq(4,8.005305094),new xl.kq(5,9.012182135),new xl.kq(6,10.01353372),new xl.kq(7,11.021657653),new xl.kq(8,12.026920631),new xl.kq(9,13.036133834),new xl.kq(10,14.042815522)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(2,7.029917389),new xl.kq(3,8.024606713),new xl.kq(4,9.013328806),new xl.kq(5,10.012937027),new xl.kq(6,11.009305466),new xl.kq(7,12.014352109),new xl.kq(8,13.017780267),new xl.kq(9,14.025404064),new xl.kq(10,15.031097291),new xl.kq(11,16.039808836),new xl.kq(12,17.046931399),new xl.kq(13,18.05617),new xl.kq(14,19.06373)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(2,8.037675026),new xl.kq(3,9.031040087),new xl.kq(4,10.01685311),new xl.kq(5,11.011433818),new xl.kq(6,12),new xl.kq(7,13.003354838),new xl.kq(8,14.003241988),new xl.kq(9,15.010599258),new xl.kq(10,16.014701243),new xl.kq(11,17.022583712),new xl.kq(12,18.026757058),new xl.kq(13,19.035248094),new xl.kq(14,20.040322395),new xl.kq(15,21.04934),new xl.kq(16,22.05645)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(3,10.042618),new xl.kq(4,11.026796226),new xl.kq(5,12.018613202),new xl.kq(6,13.005738584),new xl.kq(7,14.003074005),new xl.kq(8,15.000108898),new xl.kq(9,16.006101417),new xl.kq(10,17.008449673),new xl.kq(11,18.014081827),new xl.kq(12,19.017026896),new xl.kq(13,20.023367295),new xl.kq(14,21.027087574),new xl.kq(15,22.034440259),new xl.kq(16,23.04051),new xl.kq(17,24.0505)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(4,12.034404776),new xl.kq(5,13.0248104),new xl.kq(6,14.008595285),new xl.kq(7,15.003065386),new xl.kq(8,15.994914622),new xl.kq(9,16.999131501),new xl.kq(10,17.999160419),new xl.kq(11,19.00357873),new xl.kq(12,20.00407615),new xl.kq(13,21.008654631),new xl.kq(14,22.009967157),new xl.kq(15,23.015691325),new xl.kq(16,24.020369922),new xl.kq(17,25.02914),new xl.kq(18,26.03775)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(5,14.03608),new xl.kq(6,15.018010856),new xl.kq(7,16.01146573),new xl.kq(8,17.002095238),new xl.kq(9,18.000937667),new xl.kq(10,18.998403205),new xl.kq(11,19.999981324),new xl.kq(12,20.999948921),new xl.kq(13,22.00299925),new xl.kq(14,23.003574385),new xl.kq(15,24.008099371),new xl.kq(16,25.012094963),new xl.kq(17,26.019633157),new xl.kq(18,27.026892316),new xl.kq(19,28.03567),new xl.kq(20,29.04326)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(6,16.025756907),new xl.kq(7,17.017697565),new xl.kq(8,18.005697066),new xl.kq(9,19.001879839),new xl.kq(10,19.992440176),new xl.kq(11,20.993846744),new xl.kq(12,21.99138551),new xl.kq(13,22.994467337),new xl.kq(14,23.993615074),new xl.kq(15,24.997789899),new xl.kq(16,26.000461498),new xl.kq(17,27.0076152),new xl.kq(18,28.012108072),new xl.kq(19,29.019345902),new xl.kq(20,30.023872),new xl.kq(21,31.03311),new xl.kq(22,32.03991)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(7,18.02718),new xl.kq(8,19.01387945),new xl.kq(9,20.00734826),new xl.kq(10,20.997655099),new xl.kq(11,21.994436782),new xl.kq(12,22.989769675),new xl.kq(13,23.990963332),new xl.kq(14,24.989954352),new xl.kq(15,25.992589898),new xl.kq(16,26.994008702),new xl.kq(17,27.99889041),new xl.kq(18,29.002811301),new xl.kq(19,30.009226487),new xl.kq(20,31.013595108),new xl.kq(21,32.019649792),new xl.kq(22,33.027386),new xl.kq(23,34.0349),new xl.kq(24,35.04418)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(8,20.018862744),new xl.kq(9,21.011714174),new xl.kq(10,21.999574055),new xl.kq(11,22.99412485),new xl.kq(12,23.985041898),new xl.kq(13,24.985837023),new xl.kq(14,25.98259304),new xl.kq(15,26.984340742),new xl.kq(16,27.983876703),new xl.kq(17,28.988554743),new xl.kq(18,29.990464529),new xl.kq(19,30.996548459),new xl.kq(20,31.999145889),new xl.kq(21,33.005586975),new xl.kq(22,34.00907244),new xl.kq(23,35.018669),new xl.kq(24,36.02245),new xl.kq(25,37.03124)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(8,21.02804),new xl.kq(9,22.01952),new xl.kq(10,23.0072649),new xl.kq(11,23.999940911),new xl.kq(12,24.990428555),new xl.kq(13,25.986891659),new xl.kq(14,26.981538441),new xl.kq(15,27.981910184),new xl.kq(16,28.980444848),new xl.kq(17,29.982960304),new xl.kq(18,30.983946023),new xl.kq(19,31.988124379),new xl.kq(20,32.990869587),new xl.kq(21,33.996927255),new xl.kq(22,34.99993765),new xl.kq(23,36.006351501),new xl.kq(24,37.01031),new xl.kq(25,38.0169),new xl.kq(26,39.0219)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(8,22.03453),new xl.kq(9,23.02552),new xl.kq(10,24.011545711),new xl.kq(11,25.00410664),new xl.kq(12,25.992329935),new xl.kq(13,26.986704764),new xl.kq(14,27.976926533),new xl.kq(15,28.976494719),new xl.kq(16,29.973770218),new xl.kq(17,30.975363275),new xl.kq(18,31.974148129),new xl.kq(19,32.97800052),new xl.kq(20,33.978575745),new xl.kq(21,34.984584158),new xl.kq(22,35.986687363),new xl.kq(23,36.99299599),new xl.kq(24,37.99598),new xl.kq(25,39.0023),new xl.kq(26,40.0058),new xl.kq(27,41.0127),new xl.kq(28,42.0161)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(9,24.03435),new xl.kq(10,25.02026),new xl.kq(11,26.01178),new xl.kq(12,26.999191645),new xl.kq(13,27.99231233),new xl.kq(14,28.981801376),new xl.kq(15,29.978313807),new xl.kq(16,30.973761512),new xl.kq(17,31.973907163),new xl.kq(18,32.971725281),new xl.kq(19,33.973636381),new xl.kq(20,34.973314249),new xl.kq(21,35.978259824),new xl.kq(22,36.979608338),new xl.kq(23,37.98447),new xl.kq(24,38.98642),new xl.kq(25,39.99105),new xl.kq(26,40.9948),new xl.kq(27,42.00009),new xl.kq(28,43.00331),new xl.kq(29,44.00988),new xl.kq(30,45.01514),new xl.kq(31,46.02383)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(10,26.02788),new xl.kq(11,27.018795),new xl.kq(12,28.004372661),new xl.kq(13,28.996608805),new xl.kq(14,29.984902954),new xl.kq(15,30.979554421),new xl.kq(16,31.97207069),new xl.kq(17,32.971458497),new xl.kq(18,33.967866831),new xl.kq(19,34.96903214),new xl.kq(20,35.96708088),new xl.kq(21,36.971125716),new xl.kq(22,37.971163443),new xl.kq(23,38.975135275),new xl.kq(24,39.97547),new xl.kq(25,40.98003),new xl.kq(26,41.98149),new xl.kq(27,42.9866),new xl.kq(28,43.98832),new xl.kq(29,44.99482),new xl.kq(30,45.99957),new xl.kq(31,47.00762),new xl.kq(32,48.01299),new xl.kq(33,49.02201)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(11,28.02851),new xl.kq(12,29.01411),new xl.kq(13,30.00477),new xl.kq(14,30.992416014),new xl.kq(15,31.985688908),new xl.kq(16,32.977451798),new xl.kq(17,33.973761967),new xl.kq(18,34.968852707),new xl.kq(19,35.968306945),new xl.kq(20,36.9659026),new xl.kq(21,37.96801055),new xl.kq(22,38.968007677),new xl.kq(23,39.970415555),new xl.kq(24,40.970650212),new xl.kq(25,41.973174994),new xl.kq(26,42.974203385),new xl.kq(27,43.978538712),new xl.kq(28,44.9797),new xl.kq(29,45.98412),new xl.kq(30,46.98795),new xl.kq(31,47.99485),new xl.kq(32,48.99989),new xl.kq(33,50.00773),new xl.kq(34,51.01353)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(12,30.02156),new xl.kq(13,31.012126),new xl.kq(14,31.99766066),new xl.kq(15,32.989928719),new xl.kq(16,33.980270118),new xl.kq(17,34.975256726),new xl.kq(18,35.967546282),new xl.kq(19,36.966775912),new xl.kq(20,37.962732161),new xl.kq(21,38.964313413),new xl.kq(22,39.962383123),new xl.kq(23,40.964500828),new xl.kq(24,41.963046386),new xl.kq(25,42.965670701),new xl.kq(26,43.965365269),new xl.kq(27,44.968094979),new xl.kq(28,45.968093467),new xl.kq(29,46.972186238),new xl.kq(30,47.97507),new xl.kq(31,48.98218),new xl.kq(32,49.98594),new xl.kq(33,50.99324),new xl.kq(34,51.99817),new xl.kq(35,53.006227)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(13,32.02192),new xl.kq(14,33.00726),new xl.kq(15,33.99841),new xl.kq(16,34.988011615),new xl.kq(17,35.981293405),new xl.kq(18,36.973376915),new xl.kq(19,37.969080107),new xl.kq(20,38.963706861),new xl.kq(21,39.963998672),new xl.kq(22,40.961825972),new xl.kq(23,41.962403059),new xl.kq(24,42.960715746),new xl.kq(25,43.961556146),new xl.kq(26,44.960699658),new xl.kq(27,45.961976203),new xl.kq(28,46.961677807),new xl.kq(29,47.965512946),new xl.kq(30,48.967450084),new xl.kq(31,49.972782832),new xl.kq(32,50.97638),new xl.kq(33,51.98261),new xl.kq(34,52.98712),new xl.kq(35,53.99399),new xl.kq(36,54.999388)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(14,34.01412),new xl.kq(15,35.004765),new xl.kq(16,35.993087234),new xl.kq(17,36.985871505),new xl.kq(18,37.976318637),new xl.kq(19,38.970717729),new xl.kq(20,39.962591155),new xl.kq(21,40.962278349),new xl.kq(22,41.958618337),new xl.kq(23,42.958766833),new xl.kq(24,43.955481094),new xl.kq(25,44.956185938),new xl.kq(26,45.953692759),new xl.kq(27,46.954546459),new xl.kq(28,47.952533512),new xl.kq(29,48.955673302),new xl.kq(30,49.957518286),new xl.kq(31,50.961474238),new xl.kq(32,51.9651),new xl.kq(33,52.97005),new xl.kq(34,53.97468),new xl.kq(35,54.98055),new xl.kq(36,55.98579),new xl.kq(37,56.992356)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(15,36.01492),new xl.kq(16,37.00305),new xl.kq(17,37.9947),new xl.kq(18,38.984790009),new xl.kq(19,39.977964014),new xl.kq(20,40.969251316),new xl.kq(21,41.965516761),new xl.kq(22,42.96115098),new xl.kq(23,43.959403048),new xl.kq(24,44.955910243),new xl.kq(25,45.95517025),new xl.kq(26,46.952408027),new xl.kq(27,47.952234991),new xl.kq(28,48.950024065),new xl.kq(29,49.952187008),new xl.kq(30,50.9536027),new xl.kq(31,51.95665),new xl.kq(32,52.95817),new xl.kq(33,53.963),new xl.kq(34,54.9694),new xl.kq(35,55.97266),new xl.kq(36,56.97704),new xl.kq(37,57.98307),new xl.kq(38,58.988041)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(16,38.00977),new xl.kq(17,39.001323),new xl.kq(18,39.990498907),new xl.kq(19,40.983131),new xl.kq(20,41.973031622),new xl.kq(21,42.968523342),new xl.kq(22,43.959690235),new xl.kq(23,44.958124349),new xl.kq(24,45.952629491),new xl.kq(25,46.951763792),new xl.kq(26,47.947947053),new xl.kq(27,48.947870789),new xl.kq(28,49.944792069),new xl.kq(29,50.946616017),new xl.kq(30,51.946898175),new xl.kq(31,52.949731709),new xl.kq(32,53.95087),new xl.kq(33,54.95512),new xl.kq(34,55.95799),new xl.kq(35,56.9643),new xl.kq(36,57.96611),new xl.kq(37,58.97196),new xl.kq(38,59.97564),new xl.kq(39,60.982018)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(17,40.01109),new xl.kq(18,40.99974),new xl.kq(19,41.99123),new xl.kq(20,42.98065),new xl.kq(21,43.9744),new xl.kq(22,44.965782286),new xl.kq(23,45.960199491),new xl.kq(24,46.954906918),new xl.kq(25,47.95225448),new xl.kq(26,48.948516914),new xl.kq(27,49.947162792),new xl.kq(28,50.943963675),new xl.kq(29,51.944779658),new xl.kq(30,52.944342517),new xl.kq(31,53.946444381),new xl.kq(32,54.947238194),new xl.kq(33,55.95036),new xl.kq(34,56.95236),new xl.kq(35,57.95665),new xl.kq(36,58.9593),new xl.kq(37,59.9645),new xl.kq(38,60.96741),new xl.kq(39,61.97314),new xl.kq(40,62.97675)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(18,42.00643),new xl.kq(19,42.997707),new xl.kq(20,43.98547),new xl.kq(21,44.97916),new xl.kq(22,45.968361649),new xl.kq(23,46.962906512),new xl.kq(24,47.954035861),new xl.kq(25,48.951341135),new xl.kq(26,49.946049607),new xl.kq(27,50.944771767),new xl.kq(28,51.940511904),new xl.kq(29,52.940653781),new xl.kq(30,53.938884921),new xl.kq(31,54.940844164),new xl.kq(32,55.940645238),new xl.kq(33,56.9437538),new xl.kq(34,57.94425),new xl.kq(35,58.94863),new xl.kq(36,59.94973),new xl.kq(37,60.95409),new xl.kq(38,61.9558),new xl.kq(39,62.96186),new xl.kq(40,63.9642),new xl.kq(41,64.97037)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(19,44.00687),new xl.kq(20,44.99451),new xl.kq(21,45.98672),new xl.kq(22,46.9761),new xl.kq(23,47.96887),new xl.kq(24,48.959623415),new xl.kq(25,49.95424396),new xl.kq(26,50.948215487),new xl.kq(27,51.945570079),new xl.kq(28,52.941294702),new xl.kq(29,53.940363247),new xl.kq(30,54.938049636),new xl.kq(31,55.938909366),new xl.kq(32,56.938287458),new xl.kq(33,57.939986451),new xl.kq(34,58.940447166),new xl.kq(35,59.943193998),new xl.kq(36,60.94446),new xl.kq(37,61.94797),new xl.kq(38,62.94981),new xl.kq(39,63.95373),new xl.kq(40,64.9561),new xl.kq(41,65.96082),new xl.kq(42,66.96382)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(19,45.01456),new xl.kq(20,46.00081),new xl.kq(21,46.99289),new xl.kq(22,47.98056),new xl.kq(23,48.97361),new xl.kq(24,49.962993316),new xl.kq(25,50.956824936),new xl.kq(26,51.948116526),new xl.kq(27,52.945312282),new xl.kq(28,53.939614836),new xl.kq(29,54.938298029),new xl.kq(30,55.934942133),new xl.kq(31,56.935398707),new xl.kq(32,57.933280458),new xl.kq(33,58.934880493),new xl.kq(34,59.934076943),new xl.kq(35,60.936749461),new xl.kq(36,61.936770495),new xl.kq(37,62.940118442),new xl.kq(38,63.94087),new xl.kq(39,64.94494),new xl.kq(40,65.94598),new xl.kq(41,66.95),new xl.kq(42,67.95251),new xl.kq(43,68.9577)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(21,48.00176),new xl.kq(22,48.98972),new xl.kq(23,49.98154),new xl.kq(24,50.97072),new xl.kq(25,51.96359),new xl.kq(26,52.954224985),new xl.kq(27,53.948464147),new xl.kq(28,54.942003149),new xl.kq(29,55.939843937),new xl.kq(30,56.936296235),new xl.kq(31,57.935757571),new xl.kq(32,58.933200194),new xl.kq(33,59.933822196),new xl.kq(34,60.932479381),new xl.kq(35,61.934054212),new xl.kq(36,62.933615218),new xl.kq(37,63.935813523),new xl.kq(38,64.936484581),new xl.kq(39,65.939825412),new xl.kq(40,66.94061),new xl.kq(41,67.94436),new xl.kq(42,68.9452),new xl.kq(43,69.94981),new xl.kq(44,70.95173),new xl.kq(45,71.95641)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(22,49.99593),new xl.kq(23,50.98772),new xl.kq(24,51.97568),new xl.kq(25,52.96846),new xl.kq(26,53.957910508),new xl.kq(27,54.951336329),new xl.kq(28,55.942136339),new xl.kq(29,56.939800489),new xl.kq(30,57.935347922),new xl.kq(31,58.934351553),new xl.kq(32,59.930790633),new xl.kq(33,60.931060442),new xl.kq(34,61.928348763),new xl.kq(35,62.929672948),new xl.kq(36,63.927969574),new xl.kq(37,64.930088013),new xl.kq(38,65.929115232),new xl.kq(39,66.931569638),new xl.kq(40,67.931844932),new xl.kq(41,68.935181837),new xl.kq(42,69.93614),new xl.kq(43,70.94),new xl.kq(44,71.9413),new xl.kq(45,72.94608),new xl.kq(46,73.94791),new xl.kq(47,74.95297),new xl.kq(48,75.95533),new xl.kq(49,76.96083),new xl.kq(50,77.9638)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(23,51.99718),new xl.kq(24,52.98555),new xl.kq(25,53.97671),new xl.kq(26,54.96605),new xl.kq(27,55.95856),new xl.kq(28,56.949215695),new xl.kq(29,57.944540734),new xl.kq(30,58.939504114),new xl.kq(31,59.937368123),new xl.kq(32,60.933462181),new xl.kq(33,61.932587299),new xl.kq(34,62.929601079),new xl.kq(35,63.929767865),new xl.kq(36,64.927793707),new xl.kq(37,65.928873041),new xl.kq(38,66.927750294),new xl.kq(39,67.929637875),new xl.kq(40,68.929425281),new xl.kq(41,69.932409287),new xl.kq(42,70.932619818),new xl.kq(43,71.93552),new xl.kq(44,72.93649),new xl.kq(45,73.9402),new xl.kq(46,74.9417),new xl.kq(47,75.94599),new xl.kq(48,76.94795),new xl.kq(49,77.95281),new xl.kq(50,78.95528),new xl.kq(51,79.96189)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(24,53.99295),new xl.kq(25,54.98398),new xl.kq(26,55.97238),new xl.kq(27,56.96491),new xl.kq(28,57.954596465),new xl.kq(29,58.949267074),new xl.kq(30,59.941832031),new xl.kq(31,60.939513907),new xl.kq(32,61.934334132),new xl.kq(33,62.933215563),new xl.kq(34,63.929146578),new xl.kq(35,64.929245079),new xl.kq(36,65.926036763),new xl.kq(37,66.927130859),new xl.kq(38,67.924847566),new xl.kq(39,68.926553538),new xl.kq(40,69.92532487),new xl.kq(41,70.927727195),new xl.kq(42,71.926861122),new xl.kq(43,72.929779469),new xl.kq(44,73.929458261),new xl.kq(45,74.932937379),new xl.kq(46,75.933394207),new xl.kq(47,76.937085857),new xl.kq(48,77.938569576),new xl.kq(49,78.942095175),new xl.kq(50,79.944414722),new xl.kq(51,80.95048),new xl.kq(52,81.95484)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(25,55.99491),new xl.kq(26,56.98293),new xl.kq(27,57.97425),new xl.kq(28,58.96337),new xl.kq(29,59.95706),new xl.kq(30,60.94917),new xl.kq(31,61.944179608),new xl.kq(32,62.939141527),new xl.kq(33,63.936838307),new xl.kq(34,64.932739322),new xl.kq(35,65.931592355),new xl.kq(36,66.928204915),new xl.kq(37,67.927983497),new xl.kq(38,68.925580912),new xl.kq(39,69.926027741),new xl.kq(40,70.92470501),new xl.kq(41,71.92636935),new xl.kq(42,72.925169832),new xl.kq(43,73.926940999),new xl.kq(44,74.926500645),new xl.kq(45,75.928928262),new xl.kq(46,76.929281189),new xl.kq(47,77.93165595),new xl.kq(48,78.932916371),new xl.kq(49,79.936588154),new xl.kq(50,80.937752955),new xl.kq(51,81.94316),new xl.kq(52,82.94687),new xl.kq(53,83.95234)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(26,57.99101),new xl.kq(27,58.98175),new xl.kq(28,59.97019),new xl.kq(29,60.96379),new xl.kq(30,61.95465),new xl.kq(31,62.94964),new xl.kq(32,63.941572638),new xl.kq(33,64.939440762),new xl.kq(34,65.933846798),new xl.kq(35,66.932738415),new xl.kq(36,67.928097266),new xl.kq(37,68.927972002),new xl.kq(38,69.924250365),new xl.kq(39,70.924953991),new xl.kq(40,71.922076184),new xl.kq(41,72.923459361),new xl.kq(42,73.921178213),new xl.kq(43,74.922859494),new xl.kq(44,75.921402716),new xl.kq(45,76.923548462),new xl.kq(46,77.922852886),new xl.kq(47,78.92540156),new xl.kq(48,79.925444764),new xl.kq(49,80.928821065),new xl.kq(50,81.929550326),new xl.kq(51,82.93451),new xl.kq(52,83.93731),new xl.kq(53,84.94269),new xl.kq(54,85.94627)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(27,59.99313),new xl.kq(28,60.98062),new xl.kq(29,61.9732),new xl.kq(30,62.96369),new xl.kq(31,63.957572),new xl.kq(32,64.949484),new xl.kq(33,65.944099147),new xl.kq(34,66.939190417),new xl.kq(35,67.936792976),new xl.kq(36,68.932280154),new xl.kq(37,69.930927811),new xl.kq(38,70.927114724),new xl.kq(39,71.926752647),new xl.kq(40,72.923825288),new xl.kq(41,73.923929076),new xl.kq(42,74.921596417),new xl.kq(43,75.922393933),new xl.kq(44,76.920647703),new xl.kq(45,77.921828577),new xl.kq(46,78.920948498),new xl.kq(47,79.922578162),new xl.kq(48,80.922132884),new xl.kq(49,81.924504668),new xl.kq(50,82.924980625),new xl.kq(51,83.92906),new xl.kq(52,84.93181),new xl.kq(53,85.93623),new xl.kq(54,86.93958),new xl.kq(55,87.94456),new xl.kq(56,88.94923)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(31,64.96466),new xl.kq(32,65.95521),new xl.kq(33,66.95009),new xl.kq(34,67.94187),new xl.kq(35,68.939562155),new xl.kq(36,69.933504),new xl.kq(37,70.931868378),new xl.kq(38,71.927112313),new xl.kq(39,72.9267668),new xl.kq(40,73.922476561),new xl.kq(41,74.922523571),new xl.kq(42,75.919214107),new xl.kq(43,76.91991461),new xl.kq(44,77.917309522),new xl.kq(45,78.918499802),new xl.kq(46,79.916521828),new xl.kq(47,80.917992931),new xl.kq(48,81.9167),new xl.kq(49,82.919119072),new xl.kq(50,83.918464523),new xl.kq(51,84.922244678),new xl.kq(52,85.924271165),new xl.kq(53,86.928520749),new xl.kq(54,87.931423982),new xl.kq(55,88.93602),new xl.kq(56,89.93942),new xl.kq(57,90.94537),new xl.kq(58,91.94933)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(32,66.96479),new xl.kq(33,67.958248),new xl.kq(34,68.950178),new xl.kq(35,69.944208),new xl.kq(36,70.939246),new xl.kq(37,71.936496876),new xl.kq(38,72.931794889),new xl.kq(39,73.929891152),new xl.kq(40,74.92577641),new xl.kq(41,75.924541974),new xl.kq(42,76.921380123),new xl.kq(43,77.92114613),new xl.kq(44,78.918337647),new xl.kq(45,79.918529952),new xl.kq(46,80.91629106),new xl.kq(47,81.916804666),new xl.kq(48,82.915180219),new xl.kq(49,83.916503685),new xl.kq(50,84.915608027),new xl.kq(51,85.918797162),new xl.kq(52,86.920710713),new xl.kq(53,87.924065908),new xl.kq(54,88.92638726),new xl.kq(55,89.930634988),new xl.kq(56,90.9339653),new xl.kq(57,91.939255258),new xl.kq(58,92.9431),new xl.kq(59,93.94868)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(33,68.96532),new xl.kq(34,69.95601),new xl.kq(35,70.95051),new xl.kq(36,71.94190754),new xl.kq(37,72.938931115),new xl.kq(38,73.933258225),new xl.kq(39,74.931033794),new xl.kq(40,75.925948304),new xl.kq(41,76.92466788),new xl.kq(42,77.920386271),new xl.kq(43,78.920082992),new xl.kq(44,79.91637804),new xl.kq(45,80.916592419),new xl.kq(46,81.913484601),new xl.kq(47,82.914135952),new xl.kq(48,83.911506627),new xl.kq(49,84.912526954),new xl.kq(50,85.910610313),new xl.kq(51,86.913354251),new xl.kq(52,87.914446951),new xl.kq(53,88.917632505),new xl.kq(54,89.919523803),new xl.kq(55,90.923442418),new xl.kq(56,91.926152752),new xl.kq(57,92.931265246),new xl.kq(58,93.934362),new xl.kq(59,94.93984),new xl.kq(60,95.94307),new xl.kq(61,96.94856)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(34,70.96532),new xl.kq(35,71.95908),new xl.kq(36,72.950366),new xl.kq(37,73.944470376),new xl.kq(38,74.938569199),new xl.kq(39,75.935071448),new xl.kq(40,76.930406599),new xl.kq(41,77.928141485),new xl.kq(42,78.923996719),new xl.kq(43,79.922519322),new xl.kq(44,80.918994165),new xl.kq(45,81.918207691),new xl.kq(46,82.915111951),new xl.kq(47,83.914384676),new xl.kq(48,84.911789341),new xl.kq(49,85.91116708),new xl.kq(50,86.909183465),new xl.kq(51,87.911318556),new xl.kq(52,88.912279939),new xl.kq(53,89.914808941),new xl.kq(54,90.91653416),new xl.kq(55,91.919725442),new xl.kq(56,92.922032765),new xl.kq(57,93.926407326),new xl.kq(58,94.92931926),new xl.kq(59,95.934283962),new xl.kq(60,96.937342863),new xl.kq(61,97.941703557),new xl.kq(62,98.945420616),new xl.kq(63,99.94987),new xl.kq(64,100.953195994),new xl.kq(65,101.95921)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(35,72.96597),new xl.kq(36,73.95631),new xl.kq(37,74.94992),new xl.kq(38,75.94161),new xl.kq(39,76.937761511),new xl.kq(40,77.932179362),new xl.kq(41,78.929707076),new xl.kq(42,79.924524588),new xl.kq(43,80.923213095),new xl.kq(44,81.918401258),new xl.kq(45,82.917555029),new xl.kq(46,83.913424778),new xl.kq(47,84.912932689),new xl.kq(48,85.909262351),new xl.kq(49,86.908879316),new xl.kq(50,87.905614339),new xl.kq(51,88.907452906),new xl.kq(52,89.907737596),new xl.kq(53,90.910209845),new xl.kq(54,91.911029895),new xl.kq(55,92.91402241),new xl.kq(56,93.915359856),new xl.kq(57,94.919358213),new xl.kq(58,95.921680473),new xl.kq(59,96.926148757),new xl.kq(60,97.928471177),new xl.kq(61,98.933315038),new xl.kq(62,99.935351729),new xl.kq(63,100.940517434),new xl.kq(64,101.943018795),new xl.kq(65,102.94895),new xl.kq(66,103.95233)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(38,76.94962),new xl.kq(39,77.9435),new xl.kq(40,78.937350712),new xl.kq(41,79.931982402),new xl.kq(42,80.929128719),new xl.kq(43,81.926792071),new xl.kq(44,82.922352572),new xl.kq(45,83.920387768),new xl.kq(46,84.916427076),new xl.kq(47,85.914887724),new xl.kq(48,86.910877833),new xl.kq(49,87.909503361),new xl.kq(50,88.905847902),new xl.kq(51,89.907151443),new xl.kq(52,90.907303415),new xl.kq(53,91.908946832),new xl.kq(54,92.909581582),new xl.kq(55,93.911594008),new xl.kq(56,94.912823709),new xl.kq(57,95.915897787),new xl.kq(58,96.918131017),new xl.kq(59,97.922219525),new xl.kq(60,98.924634736),new xl.kq(61,99.927756402),new xl.kq(62,100.930313395),new xl.kq(63,101.933555501),new xl.kq(64,102.93694),new xl.kq(65,103.94145),new xl.kq(66,104.94509),new xl.kq(67,105.95022)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(39,78.94916),new xl.kq(40,79.94055),new xl.kq(41,80.936815296),new xl.kq(42,81.931086249),new xl.kq(43,82.92865213),new xl.kq(44,83.92325),new xl.kq(45,84.92146522),new xl.kq(46,85.916472851),new xl.kq(47,86.914816578),new xl.kq(48,87.910226179),new xl.kq(49,88.908888916),new xl.kq(50,89.904703679),new xl.kq(51,90.905644968),new xl.kq(52,91.905040106),new xl.kq(53,92.906475627),new xl.kq(54,93.906315765),new xl.kq(55,94.908042739),new xl.kq(56,95.908275675),new xl.kq(57,96.910950716),new xl.kq(58,97.912746366),new xl.kq(59,98.916511084),new xl.kq(60,99.917761704),new xl.kq(61,100.921139958),new xl.kq(62,101.922981089),new xl.kq(63,102.926597062),new xl.kq(64,103.92878),new xl.kq(65,104.93305),new xl.kq(66,105.93591),new xl.kq(67,106.94086),new xl.kq(68,107.94428)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(40,80.94905),new xl.kq(41,81.94313),new xl.kq(42,82.936703713),new xl.kq(43,83.93357),new xl.kq(44,84.927906486),new xl.kq(45,85.925037588),new xl.kq(46,86.920361435),new xl.kq(47,87.91833144),new xl.kq(48,88.913495503),new xl.kq(49,89.911264109),new xl.kq(50,90.906990538),new xl.kq(51,91.907193214),new xl.kq(52,92.906377543),new xl.kq(53,93.907283457),new xl.kq(54,94.906835178),new xl.kq(55,95.908100076),new xl.kq(56,96.908097144),new xl.kq(57,97.91033069),new xl.kq(58,98.911617864),new xl.kq(59,99.914181434),new xl.kq(60,100.915251567),new xl.kq(61,101.918037417),new xl.kq(62,102.919141297),new xl.kq(63,103.922459464),new xl.kq(64,104.923934023),new xl.kq(65,105.92819),new xl.kq(66,106.93031),new xl.kq(67,107.93501),new xl.kq(68,108.93763),new xl.kq(69,109.94268)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(41,82.94874),new xl.kq(42,83.94009),new xl.kq(43,84.93659),new xl.kq(44,85.930695167),new xl.kq(45,86.92732683),new xl.kq(46,87.921952728),new xl.kq(47,88.919480562),new xl.kq(48,89.913936161),new xl.kq(49,90.911750754),new xl.kq(50,91.90681048),new xl.kq(51,92.906812213),new xl.kq(52,93.905087578),new xl.kq(53,94.905841487),new xl.kq(54,95.904678904),new xl.kq(55,96.906021033),new xl.kq(56,97.905407846),new xl.kq(57,98.907711598),new xl.kq(58,99.907477149),new xl.kq(59,100.910346543),new xl.kq(60,101.910297162),new xl.kq(61,102.913204596),new xl.kq(62,103.913758387),new xl.kq(63,104.916972087),new xl.kq(64,105.918134284),new xl.kq(65,106.921694724),new xl.kq(66,107.923973837),new xl.kq(67,108.92781),new xl.kq(68,109.92973),new xl.kq(69,110.93451),new xl.kq(70,111.93684),new xl.kq(71,112.94203)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(42,84.94894),new xl.kq(43,85.94288),new xl.kq(44,86.93653),new xl.kq(45,87.93283),new xl.kq(46,88.92754288),new xl.kq(47,89.92355583),new xl.kq(48,90.9184282),new xl.kq(49,91.915259655),new xl.kq(50,92.910248473),new xl.kq(51,93.909656309),new xl.kq(52,94.907656454),new xl.kq(53,95.907870803),new xl.kq(54,96.906364843),new xl.kq(55,97.907215692),new xl.kq(56,98.906254554),new xl.kq(57,99.907657594),new xl.kq(58,100.90731438),new xl.kq(59,101.909212938),new xl.kq(60,102.909178805),new xl.kq(61,103.911444898),new xl.kq(62,104.911658043),new xl.kq(63,105.914355408),new xl.kq(64,106.915081691),new xl.kq(65,107.918479973),new xl.kq(66,108.919980998),new xl.kq(67,109.92339),new xl.kq(68,110.92505),new xl.kq(69,111.92924),new xl.kq(70,112.93133),new xl.kq(71,113.93588),new xl.kq(72,114.93828)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(43,86.94918),new xl.kq(44,87.94042),new xl.kq(45,88.93611),new xl.kq(46,89.92978),new xl.kq(47,90.926377434),new xl.kq(48,91.92012),new xl.kq(49,92.917051523),new xl.kq(50,93.911359569),new xl.kq(51,94.910412729),new xl.kq(52,95.907597681),new xl.kq(53,96.907554546),new xl.kq(54,97.905287111),new xl.kq(55,98.905939307),new xl.kq(56,99.904219664),new xl.kq(57,100.905582219),new xl.kq(58,101.904349503),new xl.kq(59,102.906323677),new xl.kq(60,103.905430145),new xl.kq(61,104.907750341),new xl.kq(62,105.907326913),new xl.kq(63,106.909907207),new xl.kq(64,107.910192211),new xl.kq(65,108.913201565),new xl.kq(66,109.913966185),new xl.kq(67,110.91756),new xl.kq(68,111.918821673),new xl.kq(69,112.92254),new xl.kq(70,113.923891981),new xl.kq(71,114.92831),new xl.kq(72,115.93016),new xl.kq(73,116.93479),new xl.kq(74,117.93703)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(44,88.94938),new xl.kq(45,89.94287),new xl.kq(46,90.93655),new xl.kq(47,91.93198),new xl.kq(48,92.92574),new xl.kq(49,93.921698),new xl.kq(50,94.915898541),new xl.kq(51,95.914518212),new xl.kq(52,96.911336643),new xl.kq(53,97.910716431),new xl.kq(54,98.908132101),new xl.kq(55,99.90811663),new xl.kq(56,100.906163526),new xl.kq(57,101.906842845),new xl.kq(58,102.905504182),new xl.kq(59,103.906655315),new xl.kq(60,104.905692444),new xl.kq(61,105.907284615),new xl.kq(62,106.90675054),new xl.kq(63,107.908730768),new xl.kq(64,108.908735621),new xl.kq(65,109.910949525),new xl.kq(66,110.91166),new xl.kq(67,111.913969253),new xl.kq(68,112.91542),new xl.kq(69,113.91734336),new xl.kq(70,114.920124676),new xl.kq(71,115.922746643),new xl.kq(72,116.92535),new xl.kq(73,117.92943),new xl.kq(74,118.93136),new xl.kq(75,119.93578),new xl.kq(76,120.93808)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(45,90.94948),new xl.kq(46,91.94042),new xl.kq(47,92.93591),new xl.kq(48,93.92877),new xl.kq(49,94.92469),new xl.kq(50,95.91822194),new xl.kq(51,96.916478921),new xl.kq(52,97.912720751),new xl.kq(53,98.911767757),new xl.kq(54,99.908504596),new xl.kq(55,100.908289144),new xl.kq(56,101.905607716),new xl.kq(57,102.906087204),new xl.kq(58,103.904034912),new xl.kq(59,104.905084046),new xl.kq(60,105.903483087),new xl.kq(61,106.905128453),new xl.kq(62,107.903894451),new xl.kq(63,108.905953535),new xl.kq(64,109.905152385),new xl.kq(65,110.907643952),new xl.kq(66,111.907313277),new xl.kq(67,112.910151346),new xl.kq(68,113.910365322),new xl.kq(69,114.91368341),new xl.kq(70,115.914158288),new xl.kq(71,116.91784),new xl.kq(72,117.918983915),new xl.kq(73,118.92268),new xl.kq(74,119.92403),new xl.kq(75,120.92818),new xl.kq(76,121.9298),new xl.kq(77,122.93426)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(47,93.94278),new xl.kq(48,94.93548),new xl.kq(49,95.93068),new xl.kq(50,96.924),new xl.kq(51,97.921759995),new xl.kq(52,98.917597103),new xl.kq(53,99.916069387),new xl.kq(54,100.912802135),new xl.kq(55,101.911999996),new xl.kq(56,102.908972453),new xl.kq(57,103.908628228),new xl.kq(58,104.906528234),new xl.kq(59,105.906666431),new xl.kq(60,106.90509302),new xl.kq(61,107.905953705),new xl.kq(62,108.904755514),new xl.kq(63,109.90611046),new xl.kq(64,110.905294679),new xl.kq(65,111.907004132),new xl.kq(66,112.906565708),new xl.kq(67,113.908807907),new xl.kq(68,114.908762282),new xl.kq(69,115.911359558),new xl.kq(70,116.911684187),new xl.kq(71,117.914582383),new xl.kq(72,118.915666045),new xl.kq(73,119.918788609),new xl.kq(74,120.919851074),new xl.kq(75,121.92332),new xl.kq(76,122.9249),new xl.kq(77,123.92853),new xl.kq(78,124.93054),new xl.kq(79,125.9345),new xl.kq(80,126.93688)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(48,95.93977),new xl.kq(49,96.93494),new xl.kq(50,97.927579),new xl.kq(51,98.92501),new xl.kq(52,99.920230232),new xl.kq(53,100.918681442),new xl.kq(54,101.914777255),new xl.kq(55,102.913418952),new xl.kq(56,103.909848091),new xl.kq(57,104.909467818),new xl.kq(58,105.906458007),new xl.kq(59,106.906614232),new xl.kq(60,107.904183403),new xl.kq(61,108.904985569),new xl.kq(62,109.903005578),new xl.kq(63,110.904181628),new xl.kq(64,111.902757226),new xl.kq(65,112.904400947),new xl.kq(66,113.903358121),new xl.kq(67,114.905430553),new xl.kq(68,115.904755434),new xl.kq(69,116.907218242),new xl.kq(70,117.906914144),new xl.kq(71,118.909922582),new xl.kq(72,119.909851352),new xl.kq(73,120.91298039),new xl.kq(74,121.9135),new xl.kq(75,122.917003675),new xl.kq(76,123.917648302),new xl.kq(77,124.92124717),new xl.kq(78,125.922353996),new xl.kq(79,126.926434822),new xl.kq(80,127.927760617),new xl.kq(81,128.93226),new xl.kq(82,129.93398)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(49,97.94224),new xl.kq(50,98.93461),new xl.kq(51,99.931149033),new xl.kq(52,100.92656),new xl.kq(53,101.924707541),new xl.kq(54,102.919913896),new xl.kq(55,103.918338416),new xl.kq(56,104.914673434),new xl.kq(57,105.913461134),new xl.kq(58,106.910292195),new xl.kq(59,107.909719683),new xl.kq(60,108.907154078),new xl.kq(61,109.907168783),new xl.kq(62,110.905110677),new xl.kq(63,111.905533338),new xl.kq(64,112.904061223),new xl.kq(65,113.904916758),new xl.kq(66,114.903878328),new xl.kq(67,115.905259995),new xl.kq(68,116.904515731),new xl.kq(69,117.906354623),new xl.kq(70,118.905846334),new xl.kq(71,119.907961505),new xl.kq(72,120.907848847),new xl.kq(73,121.910277103),new xl.kq(74,122.910438951),new xl.kq(75,123.913175916),new xl.kq(76,124.913601387),new xl.kq(77,125.916464532),new xl.kq(78,126.917344048),new xl.kq(79,127.920170658),new xl.kq(80,128.921657958),new xl.kq(81,129.924854941),new xl.kq(82,130.926767408),new xl.kq(83,131.932919005),new xl.kq(84,132.93834),new xl.kq(85,133.94466)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(50,99.938954),new xl.kq(51,100.93606),new xl.kq(52,101.93049),new xl.kq(53,102.92813),new xl.kq(54,103.923185469),new xl.kq(55,104.921390409),new xl.kq(56,105.916880472),new xl.kq(57,106.915666702),new xl.kq(58,107.911965339),new xl.kq(59,108.911286879),new xl.kq(60,109.907852688),new xl.kq(61,110.907735404),new xl.kq(62,111.90482081),new xl.kq(63,112.905173373),new xl.kq(64,113.902781816),new xl.kq(65,114.903345973),new xl.kq(66,115.901744149),new xl.kq(67,116.902953765),new xl.kq(68,117.901606328),new xl.kq(69,118.90330888),new xl.kq(70,119.902196571),new xl.kq(71,120.904236867),new xl.kq(72,121.903440138),new xl.kq(73,122.905721901),new xl.kq(74,123.90527463),new xl.kq(75,124.907784924),new xl.kq(76,125.907653953),new xl.kq(77,126.91035098),new xl.kq(78,127.910534953),new xl.kq(79,128.913439976),new xl.kq(80,129.913852185),new xl.kq(81,130.916919144),new xl.kq(82,131.917744455),new xl.kq(83,132.923814085),new xl.kq(84,133.928463576),new xl.kq(85,134.93473),new xl.kq(86,135.93934),new xl.kq(87,136.94579)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(52,102.94012),new xl.kq(53,103.936287),new xl.kq(54,104.931528593),new xl.kq(55,105.928183134),new xl.kq(56,106.92415),new xl.kq(57,107.92216),new xl.kq(58,108.918136092),new xl.kq(59,109.917533911),new xl.kq(60,110.912534147),new xl.kq(61,111.91239464),new xl.kq(62,112.909377941),new xl.kq(63,113.909095876),new xl.kq(64,114.906598812),new xl.kq(65,115.906797235),new xl.kq(66,116.90483959),new xl.kq(67,117.905531885),new xl.kq(68,118.90394646),new xl.kq(69,119.905074315),new xl.kq(70,120.903818044),new xl.kq(71,121.905175415),new xl.kq(72,122.904215696),new xl.kq(73,123.905937525),new xl.kq(74,124.905247804),new xl.kq(75,125.907248153),new xl.kq(76,126.906914564),new xl.kq(77,127.90916733),new xl.kq(78,128.909150092),new xl.kq(79,129.911546459),new xl.kq(80,130.911946487),new xl.kq(81,131.914413247),new xl.kq(82,132.915236466),new xl.kq(83,133.920551554),new xl.kq(84,134.925167962),new xl.kq(85,135.93066),new xl.kq(86,136.93531),new xl.kq(87,137.94096),new xl.kq(88,138.94571)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(54,105.937702),new xl.kq(55,106.935036),new xl.kq(56,107.929486838),new xl.kq(57,108.927456483),new xl.kq(58,109.922407164),new xl.kq(59,110.921120589),new xl.kq(60,111.917061617),new xl.kq(61,112.915452551),new xl.kq(62,113.912498025),new xl.kq(63,114.911578627),new xl.kq(64,115.908420253),new xl.kq(65,116.90863418),new xl.kq(66,117.905825187),new xl.kq(67,118.90640811),new xl.kq(68,119.904019891),new xl.kq(69,120.904929815),new xl.kq(70,121.903047064),new xl.kq(71,122.904272951),new xl.kq(72,123.902819466),new xl.kq(73,124.904424718),new xl.kq(74,125.903305543),new xl.kq(75,126.90521729),new xl.kq(76,127.904461383),new xl.kq(77,128.906595593),new xl.kq(78,129.906222753),new xl.kq(79,130.90852188),new xl.kq(80,131.908523782),new xl.kq(81,132.910939068),new xl.kq(82,133.911540546),new xl.kq(83,134.916450782),new xl.kq(84,135.920103155),new xl.kq(85,136.925324769),new xl.kq(86,137.92922),new xl.kq(87,138.93473),new xl.kq(88,139.9387),new xl.kq(89,140.94439),new xl.kq(90,141.9485)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(55,107.943291),new xl.kq(56,108.938191658),new xl.kq(57,109.934634181),new xl.kq(58,110.930276),new xl.kq(59,111.92797),new xl.kq(60,112.923644245),new xl.kq(61,113.92185),new xl.kq(62,114.918272),new xl.kq(63,115.916735014),new xl.kq(64,116.913647692),new xl.kq(65,117.91337523),new xl.kq(66,118.910180837),new xl.kq(67,119.910047843),new xl.kq(68,120.907366063),new xl.kq(69,121.907592451),new xl.kq(70,122.905597944),new xl.kq(71,123.906211423),new xl.kq(72,124.90462415),new xl.kq(73,125.905619387),new xl.kq(74,126.90446842),new xl.kq(75,127.905805254),new xl.kq(76,128.904987487),new xl.kq(77,129.906674018),new xl.kq(78,130.906124168),new xl.kq(79,131.907994525),new xl.kq(80,132.907806465),new xl.kq(81,133.909876552),new xl.kq(82,134.91005031),new xl.kq(83,135.914655105),new xl.kq(84,136.917872653),new xl.kq(85,137.922383666),new xl.kq(86,138.926093402),new xl.kq(87,139.93121),new xl.kq(88,140.93483),new xl.kq(89,141.94018),new xl.kq(90,142.94407),new xl.kq(91,143.94961)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(56,109.944476),new xl.kq(57,110.941632),new xl.kq(58,111.93566535),new xl.kq(59,112.933382836),new xl.kq(60,113.928145),new xl.kq(61,114.926979032),new xl.kq(62,115.921394197),new xl.kq(63,116.920564355),new xl.kq(64,117.91657092),new xl.kq(65,118.915554295),new xl.kq(66,119.91215199),new xl.kq(67,120.911386497),new xl.kq(68,121.908548396),new xl.kq(69,122.908470748),new xl.kq(70,123.905895774),new xl.kq(71,124.906398236),new xl.kq(72,125.904268868),new xl.kq(73,126.905179581),new xl.kq(74,127.903530436),new xl.kq(75,128.904779458),new xl.kq(76,129.903507903),new xl.kq(77,130.90508192),new xl.kq(78,131.904154457),new xl.kq(79,132.90590566),new xl.kq(80,133.905394504),new xl.kq(81,134.907207499),new xl.kq(82,135.907219526),new xl.kq(83,136.911562939),new xl.kq(84,137.913988549),new xl.kq(85,138.918786859),new xl.kq(86,139.921635665),new xl.kq(87,140.926646282),new xl.kq(88,141.929702981),new xl.kq(89,142.93489),new xl.kq(90,143.93823),new xl.kq(91,144.94367),new xl.kq(92,145.9473),new xl.kq(93,146.95301)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(57,111.950331),new xl.kq(58,112.944535512),new xl.kq(59,113.940841319),new xl.kq(60,114.935939),new xl.kq(61,115.932914152),new xl.kq(62,116.928639484),new xl.kq(63,117.926554883),new xl.kq(64,118.922370879),new xl.kq(65,119.920678219),new xl.kq(66,120.917183637),new xl.kq(67,121.916121946),new xl.kq(68,122.912990168),new xl.kq(69,123.912245731),new xl.kq(70,124.909724871),new xl.kq(71,125.909447953),new xl.kq(72,126.9074176),new xl.kq(73,127.907747919),new xl.kq(74,128.906063369),new xl.kq(75,129.906706163),new xl.kq(76,130.905460232),new xl.kq(77,131.906429799),new xl.kq(78,132.90544687),new xl.kq(79,133.906713419),new xl.kq(80,134.905971903),new xl.kq(81,135.907305741),new xl.kq(82,136.907083505),new xl.kq(83,137.911010537),new xl.kq(84,138.913357921),new xl.kq(85,139.917277075),new xl.kq(86,140.920043984),new xl.kq(87,141.924292317),new xl.kq(88,142.927330292),new xl.kq(89,143.932027373),new xl.kq(90,144.935388226),new xl.kq(91,145.940162028),new xl.kq(92,146.943864435),new xl.kq(93,147.948899539),new xl.kq(94,148.95272),new xl.kq(95,149.95797),new xl.kq(96,150.962)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(58,113.950941),new xl.kq(59,114.94771),new xl.kq(60,115.94168),new xl.kq(61,116.937700229),new xl.kq(62,117.93344),new xl.kq(63,118.931051927),new xl.kq(64,119.926045941),new xl.kq(65,120.924485908),new xl.kq(66,121.92026),new xl.kq(67,122.91885),new xl.kq(68,123.915088437),new xl.kq(69,124.914620234),new xl.kq(70,125.911244146),new xl.kq(71,126.911121328),new xl.kq(72,127.90830887),new xl.kq(73,128.908673749),new xl.kq(74,129.906310478),new xl.kq(75,130.906930798),new xl.kq(76,131.905056152),new xl.kq(77,132.906002368),new xl.kq(78,133.904503347),new xl.kq(79,134.905682749),new xl.kq(80,135.904570109),new xl.kq(81,136.905821414),new xl.kq(82,137.905241273),new xl.kq(83,138.908835384),new xl.kq(84,139.910599485),new xl.kq(85,140.914406439),new xl.kq(86,141.916448175),new xl.kq(87,142.920617184),new xl.kq(88,143.922940468),new xl.kq(89,144.926923807),new xl.kq(90,145.930106645),new xl.kq(91,146.933992519),new xl.kq(92,147.937682377),new xl.kq(93,148.94246),new xl.kq(94,149.94562),new xl.kq(95,150.9507),new xl.kq(96,151.95416),new xl.kq(97,152.95961)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(60,116.95001),new xl.kq(61,117.94657),new xl.kq(62,118.94099),new xl.kq(63,119.93807),new xl.kq(64,120.93301),new xl.kq(65,121.93071),new xl.kq(66,122.92624),new xl.kq(67,123.92453),new xl.kq(68,124.92067),new xl.kq(69,125.91937),new xl.kq(70,126.91616),new xl.kq(71,127.91544794),new xl.kq(72,128.912667334),new xl.kq(73,129.91232),new xl.kq(74,130.910108489),new xl.kq(75,131.910110399),new xl.kq(76,132.908396372),new xl.kq(77,133.908489607),new xl.kq(78,134.906971003),new xl.kq(79,135.907651181),new xl.kq(80,136.906465656),new xl.kq(81,137.907106826),new xl.kq(82,138.90634816),new xl.kq(83,139.909472552),new xl.kq(84,140.910957016),new xl.kq(85,141.914074489),new xl.kq(86,142.916058646),new xl.kq(87,143.919591666),new xl.kq(88,144.92163837),new xl.kq(89,145.925700146),new xl.kq(90,146.927819639),new xl.kq(91,147.932191197),new xl.kq(92,148.93437),new xl.kq(93,149.93857),new xl.kq(94,150.94156),new xl.kq(95,151.94611),new xl.kq(96,152.94945),new xl.kq(97,153.9544),new xl.kq(98,154.95813)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(61,118.95276),new xl.kq(62,119.94664),new xl.kq(63,120.94367),new xl.kq(64,121.93801),new xl.kq(65,122.93551),new xl.kq(66,123.93052),new xl.kq(67,124.92854),new xl.kq(68,125.9241),new xl.kq(69,126.92275),new xl.kq(70,127.91887),new xl.kq(71,128.918679183),new xl.kq(72,129.914339361),new xl.kq(73,130.914424137),new xl.kq(74,131.91149),new xl.kq(75,132.91155),new xl.kq(76,133.909026379),new xl.kq(77,134.909145555),new xl.kq(78,135.907143574),new xl.kq(79,136.907777634),new xl.kq(80,137.905985574),new xl.kq(81,138.906646605),new xl.kq(82,139.905434035),new xl.kq(83,140.908271103),new xl.kq(84,141.909239733),new xl.kq(85,142.912381158),new xl.kq(86,143.913642686),new xl.kq(87,144.917227871),new xl.kq(88,145.918689722),new xl.kq(89,146.922510962),new xl.kq(90,147.924394738),new xl.kq(91,148.928289207),new xl.kq(92,149.930226399),new xl.kq(93,150.93404),new xl.kq(94,151.93638),new xl.kq(95,152.94058),new xl.kq(96,153.94332),new xl.kq(97,154.94804),new xl.kq(98,155.95126),new xl.kq(99,156.95634)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(62,120.955364),new xl.kq(63,121.95165),new xl.kq(64,122.94596),new xl.kq(65,123.94296),new xl.kq(66,124.93783),new xl.kq(67,125.93531),new xl.kq(68,126.93083),new xl.kq(69,127.9288),new xl.kq(70,128.92486),new xl.kq(71,129.92338),new xl.kq(72,130.920060245),new xl.kq(73,131.91912),new xl.kq(74,132.9162),new xl.kq(75,133.915672),new xl.kq(76,134.91313914),new xl.kq(77,135.912646935),new xl.kq(78,136.910678351),new xl.kq(79,137.910748891),new xl.kq(80,138.908932181),new xl.kq(81,139.909071204),new xl.kq(82,140.907647726),new xl.kq(83,141.910039865),new xl.kq(84,142.910812233),new xl.kq(85,143.913300595),new xl.kq(86,144.914506897),new xl.kq(87,145.917588016),new xl.kq(88,146.918979001),new xl.kq(89,147.922183237),new xl.kq(90,148.923791056),new xl.kq(91,149.926995031),new xl.kq(92,150.928227869),new xl.kq(93,151.9316),new xl.kq(94,152.93365),new xl.kq(95,153.93739),new xl.kq(96,154.93999),new xl.kq(97,155.94412),new xl.kq(98,156.94717),new xl.kq(99,157.95178),new xl.kq(100,158.95523)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(66,125.94307),new xl.kq(67,126.9405),new xl.kq(68,127.93539),new xl.kq(69,128.932385),new xl.kq(70,129.92878),new xl.kq(71,130.927102697),new xl.kq(72,131.92312),new xl.kq(73,132.92221),new xl.kq(74,133.918645),new xl.kq(75,134.91824),new xl.kq(76,135.915020542),new xl.kq(77,136.91463973),new xl.kq(78,137.91291745),new xl.kq(79,138.91192415),new xl.kq(80,139.909309824),new xl.kq(81,140.9096048),new xl.kq(82,141.907718643),new xl.kq(83,142.909809626),new xl.kq(84,143.910082629),new xl.kq(85,144.912568847),new xl.kq(86,145.913112139),new xl.kq(87,146.916095794),new xl.kq(88,147.916888516),new xl.kq(89,148.92014419),new xl.kq(90,149.920886563),new xl.kq(91,150.923824739),new xl.kq(92,151.924682428),new xl.kq(93,152.927694534),new xl.kq(94,153.929483295),new xl.kq(95,154.932629551),new xl.kq(96,155.9352),new xl.kq(97,156.93927),new xl.kq(98,157.94187),new xl.kq(99,158.94639),new xl.kq(100,159.94939),new xl.kq(101,160.95433)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(67,127.94826),new xl.kq(68,128.94316),new xl.kq(69,129.94045),new xl.kq(70,130.9358),new xl.kq(71,131.93375),new xl.kq(72,132.92972),new xl.kq(73,133.92849),new xl.kq(74,134.924617),new xl.kq(75,135.923447865),new xl.kq(76,136.920713),new xl.kq(77,137.920432261),new xl.kq(78,138.916759814),new xl.kq(79,139.915801649),new xl.kq(80,140.913606636),new xl.kq(81,141.912950738),new xl.kq(82,142.910927571),new xl.kq(83,143.912585768),new xl.kq(84,144.912743879),new xl.kq(85,145.914692165),new xl.kq(86,146.915133898),new xl.kq(87,147.917467786),new xl.kq(88,148.918329195),new xl.kq(89,149.920979477),new xl.kq(90,150.921202693),new xl.kq(91,151.923490557),new xl.kq(92,152.924113189),new xl.kq(93,153.926547019),new xl.kq(94,154.928097047),new xl.kq(95,155.931060357),new xl.kq(96,156.9332),new xl.kq(97,157.93669),new xl.kq(98,158.93913),new xl.kq(99,159.94299),new xl.kq(100,160.94586),new xl.kq(101,161.95029),new xl.kq(102,162.95352)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(68,129.94863),new xl.kq(69,130.94589),new xl.kq(70,131.94082),new xl.kq(71,132.93873),new xl.kq(72,133.93402),new xl.kq(73,134.93235),new xl.kq(74,135.9283),new xl.kq(75,136.927046709),new xl.kq(76,137.92354),new xl.kq(77,138.922302),new xl.kq(78,139.918991),new xl.kq(79,140.918468512),new xl.kq(80,141.915193274),new xl.kq(81,142.914623555),new xl.kq(82,143.91199473),new xl.kq(83,144.913405611),new xl.kq(84,145.91303676),new xl.kq(85,146.914893275),new xl.kq(86,147.914817914),new xl.kq(87,148.917179521),new xl.kq(88,149.917271454),new xl.kq(89,150.919928351),new xl.kq(90,151.919728244),new xl.kq(91,152.922093907),new xl.kq(92,153.922205303),new xl.kq(93,154.92463594),new xl.kq(94,155.925526236),new xl.kq(95,156.928354506),new xl.kq(96,157.929987938),new xl.kq(97,158.9332),new xl.kq(98,159.93514),new xl.kq(99,160.93883),new xl.kq(100,161.94122),new xl.kq(101,162.94536),new xl.kq(102,163.94828),new xl.kq(103,164.95298)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(69,131.95416),new xl.kq(70,132.9489),new xl.kq(71,133.94632),new xl.kq(72,134.94172),new xl.kq(73,135.9395),new xl.kq(74,136.93521),new xl.kq(75,137.93345),new xl.kq(76,138.92882915),new xl.kq(77,139.928083921),new xl.kq(78,140.924885867),new xl.kq(79,141.923400033),new xl.kq(80,142.920286634),new xl.kq(81,143.918774116),new xl.kq(82,144.916261285),new xl.kq(83,145.917199714),new xl.kq(84,146.916741206),new xl.kq(85,147.918153775),new xl.kq(86,148.917925922),new xl.kq(87,149.919698294),new xl.kq(88,150.919846022),new xl.kq(89,151.921740399),new xl.kq(90,152.921226219),new xl.kq(91,153.922975386),new xl.kq(92,154.922889429),new xl.kq(93,155.924750855),new xl.kq(94,156.925419435),new xl.kq(95,157.927841923),new xl.kq(96,158.9290845),new xl.kq(97,159.931460406),new xl.kq(98,160.93368),new xl.kq(99,161.93704),new xl.kq(100,162.93921),new xl.kq(101,163.94299),new xl.kq(102,164.94572),new xl.kq(103,165.94997),new xl.kq(104,166.95305)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(72,135.94707),new xl.kq(73,136.94465),new xl.kq(74,137.93997),new xl.kq(75,138.93808),new xl.kq(76,139.933236934),new xl.kq(77,140.93221),new xl.kq(78,141.927908919),new xl.kq(79,142.926738636),new xl.kq(80,143.923390357),new xl.kq(81,144.921687498),new xl.kq(82,145.918305344),new xl.kq(83,146.919089446),new xl.kq(84,147.918109771),new xl.kq(85,148.919336427),new xl.kq(86,149.918655455),new xl.kq(87,150.920344273),new xl.kq(88,151.919787882),new xl.kq(89,152.921746283),new xl.kq(90,153.920862271),new xl.kq(91,154.922618801),new xl.kq(92,155.922119552),new xl.kq(93,156.923956686),new xl.kq(94,157.924100533),new xl.kq(95,158.926385075),new xl.kq(96,159.927050616),new xl.kq(97,160.929665688),new xl.kq(98,161.930981211),new xl.kq(99,162.93399),new xl.kq(100,163.93586),new xl.kq(101,164.93938),new xl.kq(102,165.9416),new xl.kq(103,166.94557),new xl.kq(104,167.94836),new xl.kq(105,168.95287)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(73,137.95287),new xl.kq(74,138.94803),new xl.kq(75,139.945367985),new xl.kq(76,140.94116),new xl.kq(77,141.939073781),new xl.kq(78,142.93475),new xl.kq(79,143.93253),new xl.kq(80,144.92888),new xl.kq(81,145.927180629),new xl.kq(82,146.924037176),new xl.kq(83,147.924298636),new xl.kq(84,148.92324163),new xl.kq(85,149.923654158),new xl.kq(86,150.923098169),new xl.kq(87,151.924071324),new xl.kq(88,152.923430858),new xl.kq(89,153.924686236),new xl.kq(90,154.923500411),new xl.kq(91,155.924743749),new xl.kq(92,156.924021155),new xl.kq(93,157.92541026),new xl.kq(94,158.925343135),new xl.kq(95,159.927164021),new xl.kq(96,160.927566289),new xl.kq(97,161.929484803),new xl.kq(98,162.930643942),new xl.kq(99,163.933347253),new xl.kq(100,164.93488),new xl.kq(101,165.93805),new xl.kq(102,166.94005),new xl.kq(103,167.94364),new xl.kq(104,168.94622),new xl.kq(105,169.95025),new xl.kq(106,170.9533)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(74,139.95379),new xl.kq(75,140.95119),new xl.kq(76,141.946695946),new xl.kq(77,142.94383),new xl.kq(78,143.93907),new xl.kq(79,144.936717),new xl.kq(80,145.932720118),new xl.kq(81,146.930878496),new xl.kq(82,147.927177882),new xl.kq(83,148.927333981),new xl.kq(84,149.925579728),new xl.kq(85,150.92617963),new xl.kq(86,151.924713874),new xl.kq(87,152.925760865),new xl.kq(88,153.924422046),new xl.kq(89,154.92574895),new xl.kq(90,155.924278273),new xl.kq(91,156.925461256),new xl.kq(92,157.924404637),new xl.kq(93,158.92573566),new xl.kq(94,159.925193718),new xl.kq(95,160.926929595),new xl.kq(96,161.926794731),new xl.kq(97,162.928727532),new xl.kq(98,163.929171165),new xl.kq(99,164.931699828),new xl.kq(100,165.932803241),new xl.kq(101,166.935649025),new xl.kq(102,167.93723),new xl.kq(103,168.940303648),new xl.kq(104,169.94267),new xl.kq(105,170.94648),new xl.kq(106,171.94911),new xl.kq(107,172.95344)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(75,141.95986),new xl.kq(76,142.95469),new xl.kq(77,143.95164),new xl.kq(78,144.94688),new xl.kq(79,145.9441),new xl.kq(80,146.93984),new xl.kq(81,147.937269),new xl.kq(82,148.933789944),new xl.kq(83,149.932760914),new xl.kq(84,150.931680791),new xl.kq(85,151.931740598),new xl.kq(86,152.930194506),new xl.kq(87,153.930596268),new xl.kq(88,154.929079084),new xl.kq(89,155.929001869),new xl.kq(90,156.928188059),new xl.kq(91,157.92894573),new xl.kq(92,158.927708537),new xl.kq(93,159.928725679),new xl.kq(94,160.927851662),new xl.kq(95,161.92909242),new xl.kq(96,162.928730286),new xl.kq(97,163.930230577),new xl.kq(98,164.930319169),new xl.kq(99,165.932281267),new xl.kq(100,166.933126195),new xl.kq(101,167.935496424),new xl.kq(102,168.936868306),new xl.kq(103,169.939614951),new xl.kq(104,170.941461227),new xl.kq(105,171.94482),new xl.kq(106,172.94729),new xl.kq(107,173.95115),new xl.kq(108,174.95405)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(76,143.96059),new xl.kq(77,144.95746),new xl.kq(78,145.95212),new xl.kq(79,146.94931),new xl.kq(80,147.94444),new xl.kq(81,148.942780527),new xl.kq(82,149.937171034),new xl.kq(83,150.93746),new xl.kq(84,151.935078452),new xl.kq(85,152.935093125),new xl.kq(86,153.932777294),new xl.kq(87,154.933204273),new xl.kq(88,155.931015001),new xl.kq(89,156.931945517),new xl.kq(90,157.929912),new xl.kq(91,158.930680718),new xl.kq(92,159.929078924),new xl.kq(93,160.930001348),new xl.kq(94,161.928774923),new xl.kq(95,162.930029273),new xl.kq(96,163.929196996),new xl.kq(97,164.9307228),new xl.kq(98,165.93028997),new xl.kq(99,166.932045448),new xl.kq(100,167.932367781),new xl.kq(101,168.934588082),new xl.kq(102,169.935460334),new xl.kq(103,170.938025885),new xl.kq(104,171.939352149),new xl.kq(105,172.9424),new xl.kq(106,173.94434),new xl.kq(107,174.94793),new xl.kq(108,175.95029),new xl.kq(109,176.95437)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(77,145.966495),new xl.kq(78,146.961081),new xl.kq(79,147.95755),new xl.kq(80,148.95265),new xl.kq(81,149.94967),new xl.kq(82,150.944842),new xl.kq(83,151.9443),new xl.kq(84,152.942027631),new xl.kq(85,153.940832325),new xl.kq(86,154.939191562),new xl.kq(87,155.939006895),new xl.kq(88,156.936756069),new xl.kq(89,157.936996),new xl.kq(90,158.934808966),new xl.kq(91,159.935090772),new xl.kq(92,160.933398042),new xl.kq(93,161.933970147),new xl.kq(94,162.932647648),new xl.kq(95,163.933450972),new xl.kq(96,164.932432463),new xl.kq(97,165.933553133),new xl.kq(98,166.932848844),new xl.kq(99,167.934170375),new xl.kq(100,168.934211117),new xl.kq(101,169.935797877),new xl.kq(102,170.936425817),new xl.kq(103,171.938396118),new xl.kq(104,172.939600336),new xl.kq(105,173.942164618),new xl.kq(106,174.943832897),new xl.kq(107,175.946991412),new xl.kq(108,176.94904),new xl.kq(109,177.95264),new xl.kq(110,178.95534)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(78,147.96676),new xl.kq(79,148.96348),new xl.kq(80,149.95799),new xl.kq(81,150.954657965),new xl.kq(82,151.950167),new xl.kq(83,152.94921),new xl.kq(84,153.945651145),new xl.kq(85,154.945792),new xl.kq(86,155.942847109),new xl.kq(87,156.94265865),new xl.kq(88,157.939857897),new xl.kq(89,158.940153735),new xl.kq(90,159.93756),new xl.kq(91,160.937357719),new xl.kq(92,161.93575),new xl.kq(93,162.936265492),new xl.kq(94,163.93452),new xl.kq(95,164.935397592),new xl.kq(96,165.933879623),new xl.kq(97,166.934946862),new xl.kq(98,167.933894465),new xl.kq(99,168.93518712),new xl.kq(100,169.934758652),new xl.kq(101,170.936322297),new xl.kq(102,171.936377696),new xl.kq(103,172.938206756),new xl.kq(104,173.938858101),new xl.kq(105,174.941272494),new xl.kq(106,175.942568409),new xl.kq(107,176.945257126),new xl.kq(108,177.946643396),new xl.kq(109,178.95017),new xl.kq(110,179.95233),new xl.kq(111,180.95615)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(79,149.972668),new xl.kq(80,150.967147),new xl.kq(81,151.96361),new xl.kq(82,152.95869),new xl.kq(83,153.9571),new xl.kq(84,154.953641324),new xl.kq(85,155.952907),new xl.kq(86,156.950101536),new xl.kq(87,157.948577981),new xl.kq(88,158.946615113),new xl.kq(89,159.945383),new xl.kq(90,160.943047504),new xl.kq(91,161.943222),new xl.kq(92,162.941203796),new xl.kq(93,163.941215),new xl.kq(94,164.939605886),new xl.kq(95,165.939762646),new xl.kq(96,166.938307056),new xl.kq(97,167.938698576),new xl.kq(98,168.937648757),new xl.kq(99,169.93847219),new xl.kq(100,170.937909903),new xl.kq(101,171.939082239),new xl.kq(102,172.938926901),new xl.kq(103,173.940333522),new xl.kq(104,174.940767904),new xl.kq(105,175.942682399),new xl.kq(106,176.943754987),new xl.kq(107,177.945951366),new xl.kq(108,178.947324216),new xl.kq(109,179.949879968),new xl.kq(110,180.95197),new xl.kq(111,181.95521),new xl.kq(112,182.95757),new xl.kq(113,183.96117)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(82,153.96425),new xl.kq(83,154.96276),new xl.kq(84,155.959247),new xl.kq(85,156.958127),new xl.kq(86,157.95405528),new xl.kq(87,158.954003),new xl.kq(88,159.950713588),new xl.kq(89,160.950330852),new xl.kq(90,161.947202977),new xl.kq(91,162.947057),new xl.kq(92,163.944422),new xl.kq(93,164.94454),new xl.kq(94,165.94225),new xl.kq(95,166.9426),new xl.kq(96,167.94063),new xl.kq(97,168.941158567),new xl.kq(98,169.93965),new xl.kq(99,170.94049),new xl.kq(100,171.93945798),new xl.kq(101,172.94065),new xl.kq(102,173.940040159),new xl.kq(103,174.941502991),new xl.kq(104,175.941401828),new xl.kq(105,176.943220013),new xl.kq(106,177.943697732),new xl.kq(107,178.945815073),new xl.kq(108,179.94654876),new xl.kq(109,180.949099124),new xl.kq(110,181.950552893),new xl.kq(111,182.953531012),new xl.kq(112,183.95544788),new xl.kq(113,184.95878),new xl.kq(114,185.96092)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(83,155.971689),new xl.kq(84,156.968145),new xl.kq(85,157.966368),new xl.kq(86,158.96232309),new xl.kq(87,159.961358),new xl.kq(88,160.958372992),new xl.kq(89,161.956556553),new xl.kq(90,162.95431665),new xl.kq(91,163.95357),new xl.kq(92,164.950817),new xl.kq(93,165.95047),new xl.kq(94,166.948639),new xl.kq(95,167.947787),new xl.kq(96,168.94592),new xl.kq(97,169.94609),new xl.kq(98,170.94446),new xl.kq(99,171.944739818),new xl.kq(100,172.94459),new xl.kq(101,173.944167937),new xl.kq(102,174.94365),new xl.kq(103,175.944740551),new xl.kq(104,176.944471766),new xl.kq(105,177.945750349),new xl.kq(106,178.945934113),new xl.kq(107,179.947465655),new xl.kq(108,180.947996346),new xl.kq(109,181.950152414),new xl.kq(110,182.951373188),new xl.kq(111,183.954009331),new xl.kq(112,184.955559086),new xl.kq(113,185.9585501),new xl.kq(114,186.96041),new xl.kq(115,187.96371)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(84,157.973939),new xl.kq(85,158.97228),new xl.kq(86,159.968369),new xl.kq(87,160.967089),new xl.kq(88,161.962750303),new xl.kq(89,162.962532),new xl.kq(90,163.95898381),new xl.kq(91,164.958335962),new xl.kq(92,165.955019896),new xl.kq(93,166.954672),new xl.kq(94,167.951863),new xl.kq(95,168.951759),new xl.kq(96,169.948473988),new xl.kq(97,170.94946),new xl.kq(98,171.948228837),new xl.kq(99,172.948884),new xl.kq(100,173.94616),new xl.kq(101,174.94677),new xl.kq(102,175.94559),new xl.kq(103,176.94662),new xl.kq(104,177.945848364),new xl.kq(105,178.947071733),new xl.kq(106,179.946705734),new xl.kq(107,180.948198054),new xl.kq(108,181.948205519),new xl.kq(109,182.950224458),new xl.kq(110,183.950932553),new xl.kq(111,184.953420586),new xl.kq(112,185.954362204),new xl.kq(113,186.957158365),new xl.kq(114,187.958486954),new xl.kq(115,188.96191222),new xl.kq(116,189.963179541)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(85,159.981485),new xl.kq(86,160.977661),new xl.kq(87,161.975707),new xl.kq(88,162.971375872),new xl.kq(89,163.970319),new xl.kq(90,164.967050268),new xl.kq(91,165.965211372),new xl.kq(92,166.962564),new xl.kq(93,167.961609),new xl.kq(94,168.95883),new xl.kq(95,169.958163),new xl.kq(96,170.955547),new xl.kq(97,171.955285),new xl.kq(98,172.953062),new xl.kq(99,173.952114),new xl.kq(100,174.951393),new xl.kq(101,175.95157),new xl.kq(102,176.95027),new xl.kq(103,177.950851081),new xl.kq(104,178.949981038),new xl.kq(105,179.95078768),new xl.kq(106,180.950064596),new xl.kq(107,181.951211444),new xl.kq(108,182.950821349),new xl.kq(109,183.952524289),new xl.kq(110,184.952955747),new xl.kq(111,185.954986529),new xl.kq(112,186.955750787),new xl.kq(113,187.958112287),new xl.kq(114,188.959228359),new xl.kq(115,189.961816139),new xl.kq(116,190.963123592),new xl.kq(117,191.96596)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(86,161.983819),new xl.kq(87,162.982048),new xl.kq(88,163.977927),new xl.kq(89,164.976475),new xl.kq(90,165.971934911),new xl.kq(91,166.971554),new xl.kq(92,167.967832911),new xl.kq(93,168.967076205),new xl.kq(94,169.963569716),new xl.kq(95,170.96304),new xl.kq(96,171.960078),new xl.kq(97,172.959791),new xl.kq(98,173.956307704),new xl.kq(99,174.95708),new xl.kq(100,175.953757941),new xl.kq(101,176.955045),new xl.kq(102,177.953348225),new xl.kq(103,178.953951),new xl.kq(104,179.952308241),new xl.kq(105,180.953274494),new xl.kq(106,181.952186222),new xl.kq(107,182.95311),new xl.kq(108,183.952490808),new xl.kq(109,184.954043023),new xl.kq(110,185.953838355),new xl.kq(111,186.955747928),new xl.kq(112,187.955835993),new xl.kq(113,188.958144866),new xl.kq(114,189.95844521),new xl.kq(115,190.960927951),new xl.kq(116,191.961479047),new xl.kq(117,192.964148083),new xl.kq(118,193.965179314),new xl.kq(119,194.968123889),new xl.kq(120,195.96962255)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(88,164.98758),new xl.kq(89,165.985506),new xl.kq(90,166.980951577),new xl.kq(91,167.979966),new xl.kq(92,168.976390868),new xl.kq(93,169.974441697),new xl.kq(94,170.971779),new xl.kq(95,171.970643),new xl.kq(96,172.967707),new xl.kq(97,173.966804),new xl.kq(98,174.964279),new xl.kq(99,175.963511),new xl.kq(100,176.96117),new xl.kq(101,177.960084944),new xl.kq(102,178.95915),new xl.kq(103,179.958555615),new xl.kq(104,180.957642156),new xl.kq(105,181.958127689),new xl.kq(106,182.956814),new xl.kq(107,183.957388318),new xl.kq(108,184.95659),new xl.kq(109,185.957951104),new xl.kq(110,186.95736083),new xl.kq(111,187.958851962),new xl.kq(112,188.958716473),new xl.kq(113,189.960592299),new xl.kq(114,190.960591191),new xl.kq(115,191.962602198),new xl.kq(116,192.9629237),new xl.kq(117,193.96507561),new xl.kq(118,194.9659768),new xl.kq(119,195.968379906),new xl.kq(120,196.969636496),new xl.kq(121,197.97228),new xl.kq(122,198.973787159)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(90,167.988035),new xl.kq(91,168.986421),new xl.kq(92,169.981734918),new xl.kq(93,170.981251),new xl.kq(94,171.977376138),new xl.kq(95,172.976499642),new xl.kq(96,173.972811276),new xl.kq(97,174.972276),new xl.kq(98,175.969),new xl.kq(99,176.968453),new xl.kq(100,177.964894223),new xl.kq(101,178.965475),new xl.kq(102,179.962023729),new xl.kq(103,180.963177),new xl.kq(104,181.961267637),new xl.kq(105,182.961729),new xl.kq(106,183.959851685),new xl.kq(107,184.960753782),new xl.kq(108,185.959432346),new xl.kq(109,186.960697),new xl.kq(110,187.959395697),new xl.kq(111,188.9608319),new xl.kq(112,189.959930073),new xl.kq(113,190.961684653),new xl.kq(114,191.961035158),new xl.kq(115,192.962984504),new xl.kq(116,193.962663581),new xl.kq(117,194.964774449),new xl.kq(118,195.964934884),new xl.kq(119,196.967323401),new xl.kq(120,197.967876009),new xl.kq(121,198.970576213),new xl.kq(122,199.971423885),new xl.kq(123,200.974496467),new xl.kq(124,201.97574)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(92,170.991183),new xl.kq(93,171.990109),new xl.kq(94,172.986398138),new xl.kq(95,173.984325861),new xl.kq(96,174.981552),new xl.kq(97,175.980269),new xl.kq(98,176.977215),new xl.kq(99,177.975975),new xl.kq(100,178.973412),new xl.kq(101,179.972396),new xl.kq(102,180.969948),new xl.kq(103,181.968621416),new xl.kq(104,182.96762),new xl.kq(105,183.966776046),new xl.kq(106,184.965806956),new xl.kq(107,185.965997671),new xl.kq(108,186.964562),new xl.kq(109,187.965321662),new xl.kq(110,188.9642243),new xl.kq(111,189.964698757),new xl.kq(112,190.963649239),new xl.kq(113,191.964810107),new xl.kq(114,192.964131745),new xl.kq(115,193.96533889),new xl.kq(116,194.965017928),new xl.kq(117,195.966551315),new xl.kq(118,196.966551609),new xl.kq(119,197.968225244),new xl.kq(120,198.968748016),new xl.kq(121,199.970717886),new xl.kq(122,200.971640839),new xl.kq(123,201.973788431),new xl.kq(124,202.975137256),new xl.kq(125,203.977705),new xl.kq(126,204.97961)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(95,174.991411),new xl.kq(96,175.987413248),new xl.kq(97,176.986336874),new xl.kq(98,177.982476325),new xl.kq(99,178.981783),new xl.kq(100,179.978322),new xl.kq(101,180.977806),new xl.kq(102,181.97393546),new xl.kq(103,182.974561),new xl.kq(104,183.970705219),new xl.kq(105,184.971983),new xl.kq(106,185.969460021),new xl.kq(107,186.969785),new xl.kq(108,187.967511693),new xl.kq(109,188.968733187),new xl.kq(110,189.966958568),new xl.kq(111,190.96706311),new xl.kq(112,191.965921572),new xl.kq(113,192.966644169),new xl.kq(114,193.965381832),new xl.kq(115,194.966638981),new xl.kq(116,195.965814846),new xl.kq(117,196.967195333),new xl.kq(118,197.96675183),new xl.kq(119,198.968262489),new xl.kq(120,199.968308726),new xl.kq(121,200.970285275),new xl.kq(122,201.970625604),new xl.kq(123,202.972857096),new xl.kq(124,203.97347564),new xl.kq(125,204.976056104),new xl.kq(126,205.977498672),new xl.kq(127,206.982577025),new xl.kq(128,207.98594)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(96,176.996881),new xl.kq(97,177.994637),new xl.kq(98,178.991466),new xl.kq(99,179.990194),new xl.kq(100,180.986904),new xl.kq(101,181.98561),new xl.kq(102,182.982697),new xl.kq(103,183.98176),new xl.kq(104,184.9791),new xl.kq(105,185.977549881),new xl.kq(106,186.97617),new xl.kq(107,187.97592),new xl.kq(108,188.974290451),new xl.kq(109,189.974473379),new xl.kq(110,190.972261952),new xl.kq(111,191.972770785),new xl.kq(112,192.970548),new xl.kq(113,193.971053),new xl.kq(114,194.96965),new xl.kq(115,195.970515),new xl.kq(116,196.9695362),new xl.kq(117,197.970466294),new xl.kq(118,198.969813837),new xl.kq(119,199.970945394),new xl.kq(120,200.97080377),new xl.kq(121,201.972090569),new xl.kq(122,202.972329088),new xl.kq(123,203.973848646),new xl.kq(124,204.97441227),new xl.kq(125,205.976095321),new xl.kq(126,206.977407908),new xl.kq(127,207.982004653),new xl.kq(128,208.985349125),new xl.kq(129,209.990065574)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(99,180.996714),new xl.kq(100,181.992676101),new xl.kq(101,182.99193),new xl.kq(102,183.988198),new xl.kq(103,184.98758),new xl.kq(104,185.983485388),new xl.kq(105,186.98403),new xl.kq(106,187.979869108),new xl.kq(107,188.98088),new xl.kq(108,189.978180008),new xl.kq(109,190.9782),new xl.kq(110,191.975719811),new xl.kq(111,192.97608),new xl.kq(112,193.974648056),new xl.kq(113,194.975920279),new xl.kq(114,195.97271),new xl.kq(115,196.97338),new xl.kq(116,197.97198),new xl.kq(117,198.972909384),new xl.kq(118,199.97181556),new xl.kq(119,200.972846589),new xl.kq(120,201.972143786),new xl.kq(121,202.973375491),new xl.kq(122,203.973028761),new xl.kq(123,204.974467112),new xl.kq(124,205.974449002),new xl.kq(125,206.975880605),new xl.kq(126,207.97663585),new xl.kq(127,208.981074801),new xl.kq(128,209.984173129),new xl.kq(129,210.988731474),new xl.kq(130,211.991887495),new xl.kq(131,212.9965),new xl.kq(132,213.999798147)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(102,184.997708),new xl.kq(103,185.99648),new xl.kq(104,186.993458),new xl.kq(105,187.992173),new xl.kq(106,188.989505),new xl.kq(107,189.987520007),new xl.kq(108,190.986053),new xl.kq(109,191.985368),new xl.kq(110,192.983662229),new xl.kq(111,193.983430186),new xl.kq(112,194.98112697),new xl.kq(113,195.981236107),new xl.kq(114,196.978934287),new xl.kq(115,197.979024396),new xl.kq(116,198.977576953),new xl.kq(117,199.978141983),new xl.kq(118,200.976970721),new xl.kq(119,201.977674504),new xl.kq(120,202.976868118),new xl.kq(121,203.977805161),new xl.kq(122,204.977374688),new xl.kq(123,205.978482854),new xl.kq(124,206.978455217),new xl.kq(125,207.979726699),new xl.kq(126,208.980383241),new xl.kq(127,209.984104944),new xl.kq(128,210.987258139),new xl.kq(129,211.991271542),new xl.kq(130,212.994374836),new xl.kq(131,213.998698664),new xl.kq(132,215.001832349),new xl.kq(133,216.006199)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(106,189.994293888),new xl.kq(107,190.994653),new xl.kq(108,191.99033039),new xl.kq(109,192.991102),new xl.kq(110,193.988284107),new xl.kq(111,194.988045),new xl.kq(112,195.985469432),new xl.kq(113,196.985567),new xl.kq(114,197.984024384),new xl.kq(115,198.985044507),new xl.kq(116,199.981735),new xl.kq(117,200.982209),new xl.kq(118,201.980704),new xl.kq(119,202.981412863),new xl.kq(120,203.980307113),new xl.kq(121,204.981165396),new xl.kq(122,205.980465241),new xl.kq(123,206.981578228),new xl.kq(124,207.981231059),new xl.kq(125,208.982415788),new xl.kq(126,209.982857396),new xl.kq(127,210.986636869),new xl.kq(128,211.988851755),new xl.kq(129,212.992842522),new xl.kq(130,213.995185949),new xl.kq(131,214.999414609),new xl.kq(132,216.001905198),new xl.kq(133,217.006253),new xl.kq(134,218.008965773)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(108,193.000188),new xl.kq(109,193.997973),new xl.kq(110,194.996554),new xl.kq(111,195.995702),new xl.kq(112,196.993891293),new xl.kq(113,197.99343368),new xl.kq(114,198.991008569),new xl.kq(115,199.990920883),new xl.kq(116,200.988486908),new xl.kq(117,201.988448629),new xl.kq(118,202.986847216),new xl.kq(119,203.987261559),new xl.kq(120,204.986036352),new xl.kq(121,205.986599242),new xl.kq(122,206.985775861),new xl.kq(123,207.986582508),new xl.kq(124,208.986158678),new xl.kq(125,209.987131308),new xl.kq(126,210.987480806),new xl.kq(127,211.990734657),new xl.kq(128,212.99292115),new xl.kq(129,213.996356412),new xl.kq(130,214.998641245),new xl.kq(131,216.002408839),new xl.kq(132,217.004709619),new xl.kq(133,218.008681458),new xl.kq(134,219.011296478),new xl.kq(135,220.015301),new xl.kq(136,221.01814),new xl.kq(137,222.02233),new xl.kq(138,223.02534)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(110,196.001117268),new xl.kq(111,197.001661),new xl.kq(112,197.998779978),new xl.kq(113,198.998309),new xl.kq(114,199.995634148),new xl.kq(115,200.995535),new xl.kq(116,201.993899382),new xl.kq(117,202.994765192),new xl.kq(118,203.991365),new xl.kq(119,204.991668),new xl.kq(120,205.99016),new xl.kq(121,206.990726826),new xl.kq(122,207.989631237),new xl.kq(123,208.990376634),new xl.kq(124,209.989679862),new xl.kq(125,210.99058541),new xl.kq(126,211.990688899),new xl.kq(127,212.993868354),new xl.kq(128,213.995346275),new xl.kq(129,214.998729195),new xl.kq(130,216.000258153),new xl.kq(131,217.003914555),new xl.kq(132,218.005586315),new xl.kq(133,219.009474831),new xl.kq(134,220.011384149),new xl.kq(135,221.015455),new xl.kq(136,222.017570472),new xl.kq(137,223.02179),new xl.kq(138,224.02409),new xl.kq(139,225.02844),new xl.kq(140,226.03089),new xl.kq(141,227.035407),new xl.kq(142,228.038084)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(113,200.006499),new xl.kq(114,201.00458692),new xl.kq(115,202.00396885),new xl.kq(116,203.001423829),new xl.kq(117,204.001221209),new xl.kq(118,204.998663961),new xl.kq(119,205.998486886),new xl.kq(120,206.996859385),new xl.kq(121,207.997133849),new xl.kq(122,208.995915421),new xl.kq(123,209.996398327),new xl.kq(124,210.995529332),new xl.kq(125,211.996194988),new xl.kq(126,212.996174845),new xl.kq(127,213.99895474),new xl.kq(128,215.000326029),new xl.kq(129,216.003187873),new xl.kq(130,217.004616452),new xl.kq(131,218.007563326),new xl.kq(132,219.009240843),new xl.kq(133,220.012312978),new xl.kq(134,221.014245654),new xl.kq(135,222.017543957),new xl.kq(136,223.019730712),new xl.kq(137,224.023235513),new xl.kq(138,225.025606914),new xl.kq(139,226.029343423),new xl.kq(140,227.031833167),new xl.kq(141,228.034776087),new xl.kq(142,229.038426),new xl.kq(143,230.04251),new xl.kq(144,231.045407),new xl.kq(145,232.049654)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(115,203.00921),new xl.kq(116,204.006434513),new xl.kq(117,205.006187),new xl.kq(118,206.004463814),new xl.kq(119,207.005176607),new xl.kq(120,208.001776),new xl.kq(121,209.001944),new xl.kq(122,210.000446),new xl.kq(123,211.000893996),new xl.kq(124,211.999783492),new xl.kq(125,213.000345847),new xl.kq(126,214.000091141),new xl.kq(127,215.002704195),new xl.kq(128,216.003518402),new xl.kq(129,217.00630601),new xl.kq(130,218.007123948),new xl.kq(131,219.010068787),new xl.kq(132,220.011014669),new xl.kq(133,221.013907762),new xl.kq(134,222.01536182),new xl.kq(135,223.01849714),new xl.kq(136,224.020202004),new xl.kq(137,225.023604463),new xl.kq(138,226.025402555),new xl.kq(139,227.029170677),new xl.kq(140,228.031064101),new xl.kq(141,229.034820309),new xl.kq(142,230.037084774),new xl.kq(143,231.04122),new xl.kq(144,232.043693),new xl.kq(145,233.047995),new xl.kq(146,234.050547)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(118,207.012469754),new xl.kq(119,208.012112949),new xl.kq(120,209.009568736),new xl.kq(121,210.009256802),new xl.kq(122,211.007648196),new xl.kq(123,212.007811441),new xl.kq(124,213.006573689),new xl.kq(125,214.006893072),new xl.kq(126,215.006450832),new xl.kq(127,216.008721268),new xl.kq(128,217.009332676),new xl.kq(129,218.011625045),new xl.kq(130,219.012404918),new xl.kq(131,220.014752105),new xl.kq(132,221.015575746),new xl.kq(133,222.017828852),new xl.kq(134,223.01912603),new xl.kq(135,224.021708435),new xl.kq(136,225.023220576),new xl.kq(137,226.026089848),new xl.kq(138,227.027746979),new xl.kq(139,228.031014825),new xl.kq(140,229.032930871),new xl.kq(141,230.036025144),new xl.kq(142,231.038551503),new xl.kq(143,232.042022474),new xl.kq(144,233.04455),new xl.kq(145,234.04842),new xl.kq(146,235.051102),new xl.kq(147,236.055178)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(120,210.015711883),new xl.kq(121,211.016306912),new xl.kq(122,212.012916),new xl.kq(123,213.012962),new xl.kq(124,214.011451),new xl.kq(125,215.011726597),new xl.kq(126,216.011050963),new xl.kq(127,217.013066169),new xl.kq(128,218.013267744),new xl.kq(129,219.015521253),new xl.kq(130,220.015733126),new xl.kq(131,221.018171499),new xl.kq(132,222.018454131),new xl.kq(133,223.020795153),new xl.kq(134,224.02145925),new xl.kq(135,225.023941441),new xl.kq(136,226.024890681),new xl.kq(137,227.027698859),new xl.kq(138,228.028731348),new xl.kq(139,229.03175534),new xl.kq(140,230.033126574),new xl.kq(141,231.03629706),new xl.kq(142,232.03805036),new xl.kq(143,233.041576923),new xl.kq(144,234.043595497),new xl.kq(145,235.04750442),new xl.kq(146,236.04971),new xl.kq(147,237.053894),new xl.kq(148,238.056243)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(122,213.021183209),new xl.kq(123,214.02073923),new xl.kq(124,215.019097612),new xl.kq(125,216.019109649),new xl.kq(126,217.018288571),new xl.kq(127,218.020007906),new xl.kq(128,219.019880348),new xl.kq(129,220.021876493),new xl.kq(130,221.021863742),new xl.kq(131,222.023726),new xl.kq(132,223.023963748),new xl.kq(133,224.025614854),new xl.kq(134,225.026115172),new xl.kq(135,226.02793275),new xl.kq(136,227.028793151),new xl.kq(137,228.031036942),new xl.kq(138,229.032088601),new xl.kq(139,230.034532562),new xl.kq(140,231.035878898),new xl.kq(141,232.03858172),new xl.kq(142,233.040240235),new xl.kq(143,234.043302325),new xl.kq(144,235.045436759),new xl.kq(145,236.048675176),new xl.kq(146,237.05113943),new xl.kq(147,238.054497046),new xl.kq(148,239.05713),new xl.kq(149,240.06098)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(126,218.023487),new xl.kq(127,219.024915423),new xl.kq(128,220.024712),new xl.kq(129,221.026351),new xl.kq(130,222.02607),new xl.kq(131,223.027722956),new xl.kq(132,224.027590139),new xl.kq(133,225.029384369),new xl.kq(134,226.02933975),new xl.kq(135,227.031140069),new xl.kq(136,228.031366357),new xl.kq(137,229.033496137),new xl.kq(138,230.033927392),new xl.kq(139,231.036289158),new xl.kq(140,232.03714628),new xl.kq(141,233.039628196),new xl.kq(142,234.040945606),new xl.kq(143,235.043923062),new xl.kq(144,236.045561897),new xl.kq(145,237.048723955),new xl.kq(146,238.050782583),new xl.kq(147,239.054287777),new xl.kq(148,240.056585734),new xl.kq(149,241.06033),new xl.kq(150,242.062925)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(132,225.033899689),new xl.kq(133,226.035129),new xl.kq(134,227.034958261),new xl.kq(135,228.03618),new xl.kq(136,229.036246866),new xl.kq(137,230.037812591),new xl.kq(138,231.038233161),new xl.kq(139,232.040099),new xl.kq(140,233.04073235),new xl.kq(141,234.042888556),new xl.kq(142,235.044055876),new xl.kq(143,236.046559724),new xl.kq(144,237.048167253),new xl.kq(145,238.050940464),new xl.kq(146,239.052931399),new xl.kq(147,240.056168828),new xl.kq(148,241.058246266),new xl.kq(149,242.061635),new xl.kq(150,243.064273),new xl.kq(151,244.06785)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(134,228.038727686),new xl.kq(135,229.040138934),new xl.kq(136,230.039645603),new xl.kq(137,231.041258),new xl.kq(138,232.041179445),new xl.kq(139,233.04298757),new xl.kq(140,234.043304681),new xl.kq(141,235.0452815),new xl.kq(142,236.046048088),new xl.kq(143,237.048403774),new xl.kq(144,238.0495534),new xl.kq(145,239.052156519),new xl.kq(146,240.05380746),new xl.kq(147,241.056845291),new xl.kq(148,242.058736847),new xl.kq(149,243.061997013),new xl.kq(150,244.06419765),new xl.kq(151,245.067738657),new xl.kq(152,246.070198429),new xl.kq(153,247.07407)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(136,231.04556),new xl.kq(137,232.04659),new xl.kq(138,233.046472),new xl.kq(139,234.047794),new xl.kq(140,235.048029),new xl.kq(141,236.049569),new xl.kq(142,237.049970748),new xl.kq(143,238.051977839),new xl.kq(144,239.053018481),new xl.kq(145,240.055287826),new xl.kq(146,241.056822944),new xl.kq(147,242.059543039),new xl.kq(148,243.061372686),new xl.kq(149,244.064279429),new xl.kq(150,245.066445398),new xl.kq(151,246.069768438),new xl.kq(152,247.072086),new xl.kq(153,248.075745),new xl.kq(154,249.07848)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(137,233.0508),new xl.kq(138,234.05024),new xl.kq(139,235.051591),new xl.kq(140,236.051405),new xl.kq(141,237.052891),new xl.kq(142,238.053016298),new xl.kq(143,239.054951),new xl.kq(144,240.055519046),new xl.kq(145,241.057646736),new xl.kq(146,242.058829326),new xl.kq(147,243.061382249),new xl.kq(148,244.062746349),new xl.kq(149,245.065485586),new xl.kq(150,246.067217551),new xl.kq(151,247.070346811),new xl.kq(152,248.072342247),new xl.kq(153,249.075947062),new xl.kq(154,250.078350687),new xl.kq(155,251.082277873),new xl.kq(156,252.08487)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(138,235.05658),new xl.kq(139,236.05733),new xl.kq(140,237.057127),new xl.kq(141,238.058266),new xl.kq(142,239.058362),new xl.kq(143,240.059749),new xl.kq(144,241.060223),new xl.kq(145,242.06205),new xl.kq(146,243.06300157),new xl.kq(147,244.065167882),new xl.kq(148,245.066355386),new xl.kq(149,246.068666836),new xl.kq(150,247.070298533),new xl.kq(151,248.07308),new xl.kq(152,249.074979937),new xl.kq(153,250.078310529),new xl.kq(154,251.08075344),new xl.kq(155,252.084303),new xl.kq(156,253.08688),new xl.kq(157,254.0906)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(139,237.06207),new xl.kq(140,238.06141),new xl.kq(141,239.062579),new xl.kq(142,240.062295),new xl.kq(143,241.063716),new xl.kq(144,242.063688713),new xl.kq(145,243.065421),new xl.kq(146,244.06599039),new xl.kq(147,245.068039),new xl.kq(148,246.068798807),new xl.kq(149,247.070992043),new xl.kq(150,248.07217808),new xl.kq(151,249.074846818),new xl.kq(152,250.076399951),new xl.kq(153,251.079580056),new xl.kq(154,252.081619582),new xl.kq(155,253.085126791),new xl.kq(156,254.087316198),new xl.kq(157,255.091039),new xl.kq(158,256.09344)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(141,240.06892),new xl.kq(142,241.068662),new xl.kq(143,242.069699),new xl.kq(144,243.069631),new xl.kq(145,244.070969),new xl.kq(146,245.071317),new xl.kq(147,246.072965),new xl.kq(148,247.07365),new xl.kq(149,248.075458),new xl.kq(150,249.076405),new xl.kq(151,250.078654),new xl.kq(152,251.079983592),new xl.kq(153,252.082972247),new xl.kq(154,253.084817974),new xl.kq(155,254.088016026),new xl.kq(156,255.090266386),new xl.kq(157,256.093592),new xl.kq(158,257.095979)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(142,242.07343),new xl.kq(143,243.07451),new xl.kq(144,244.074077),new xl.kq(145,245.075375),new xl.kq(146,246.075281634),new xl.kq(147,247.076819),new xl.kq(148,248.077184411),new xl.kq(149,249.079024),new xl.kq(150,250.079514759),new xl.kq(151,251.081566467),new xl.kq(152,252.082460071),new xl.kq(153,253.085176259),new xl.kq(154,254.086847795),new xl.kq(155,255.089955466),new xl.kq(156,256.091766522),new xl.kq(157,257.095098635),new xl.kq(158,258.097069),new xl.kq(159,259.100588)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(144,245.081017),new xl.kq(145,246.081933),new xl.kq(146,247.081804),new xl.kq(147,248.082909),new xl.kq(148,249.083002),new xl.kq(149,250.084488),new xl.kq(150,251.084919),new xl.kq(151,252.08663),new xl.kq(152,253.08728),new xl.kq(153,254.089725),new xl.kq(154,255.091075196),new xl.kq(155,256.094052757),new xl.kq(156,257.095534643),new xl.kq(157,258.098425321),new xl.kq(158,259.100503),new xl.kq(159,260.103645)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(147,249.087823),new xl.kq(148,250.087493),new xl.kq(149,251.08896),new xl.kq(150,252.088965909),new xl.kq(151,253.090649),new xl.kq(152,254.090948746),new xl.kq(153,255.093232449),new xl.kq(154,256.094275879),new xl.kq(155,257.096852778),new xl.kq(156,258.0982),new xl.kq(157,259.101024),new xl.kq(158,260.102636),new xl.kq(159,261.105743),new xl.kq(160,262.10752)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(148,251.09436),new xl.kq(149,252.09533),new xl.kq(150,253.095258),new xl.kq(151,254.096587),new xl.kq(152,255.096769),new xl.kq(153,256.098763),new xl.kq(154,257.099606),new xl.kq(155,258.101883),new xl.kq(156,259.10299),new xl.kq(157,260.105572),new xl.kq(158,261.106941),new xl.kq(159,262.109692),new xl.kq(160,263.111394)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(149,253.100679),new xl.kq(150,254.100166),new xl.kq(151,255.101492),new xl.kq(152,256.101179573),new xl.kq(153,257.103072),new xl.kq(154,258.103568),new xl.kq(155,259.105628),new xl.kq(156,260.106434),new xl.kq(157,261.108752),new xl.kq(158,262.109918),new xl.kq(159,263.11254),new xl.kq(160,264.113978)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(150,255.107398),new xl.kq(151,256.10811),new xl.kq(152,257.107858),new xl.kq(153,258.109438),new xl.kq(154,259.109721),new xl.kq(155,260.111427),new xl.kq(156,261.112106),new xl.kq(157,262.114153),new xl.kq(158,263.115078),new xl.kq(159,264.117473),new xl.kq(160,265.118659)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(152,258.113151),new xl.kq(153,259.114652),new xl.kq(154,260.114435447),new xl.kq(155,261.116199),new xl.kq(156,262.116477),new xl.kq(157,263.118313),new xl.kq(158,264.118924),new xl.kq(159,265.121066),new xl.kq(160,266.121928)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(153,260.121803),new xl.kq(154,261.1218),new xl.kq(155,262.123009),new xl.kq(156,263.123146),new xl.kq(157,264.12473),new xl.kq(158,265.125198),new xl.kq(159,266.127009),new xl.kq(160,267.12774)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(155,263.12871),new xl.kq(156,264.128408258),new xl.kq(157,265.130001),new xl.kq(158,266.130042),new xl.kq(159,267.131774),new xl.kq(160,268.132156),new xl.kq(161,269.134114)]),Vf(qf(kl.Nlb,1),zt,3,0,[new xl.kq(156,265.136567),new xl.kq(157,266.13794),new xl.kq(158,267.137526),new xl.kq(159,268.138816),new xl.kq(160,269.139106),new xl.kq(161,270.140723),new xl.kq(162,271.141229)])])},xl.nq=function(n,t){var e,i;for(xl.mq(),i=t-n,e=0;e<xl.lq[n].length;e++)if(xl.lq[n][e].b==i)return xl.lq[n][e].a;return NaN},xl.oq=function(n,t){var e;if(n.b.length!=t.b.length)return n.b.length<t.b.length?-1:1;for(e=0;e<n.b.length;e++)if(n.b[e]!=t.b[e])return n.b[e]<t.b[e]?-1:1;return 0},xl.pq=function(n){var t,e,i,s,a;for(e=0,s=0,a=(i=n.a).length;s<a;++s)i[s]&&++e;for(n.b=vf(kl.llb,z,6,e,15,1),e=0,t=0;t<n.a.length;t++)n.a[t]&&(n.b[e++]=t)},xl.qq=function(n,t){var e;for(xl.pq(n),e=0;e<n.b.length;e++)if(t[n.b[e]])return!0;return!1},xl.rq=function(n){this.a=vf(kl.Cwb,nn,6,n,16,1)},zf(273,1,{273:1,18:1},xl.rq),o.Eb=function(n){return xl.oq(this,n)},kl.Olb=lg(273),xl.wq=function(){xl.wq=Sf,xl.vq=Vf(qf(kl.jlb,1),S,6,15,[0,1.00794,4.0026,6.941,9.0122,10.811,12.011,14.007,15.999,18.998,20.18,22.99,24.305,26.982,28.086,30.974,32.066,35.453,39.948,39.098,40.078,44.956,47.867,50.942,51.996,54.938,55.845,58.933,58.693,63.546,65.39,69.723,72.61,74.922,78.96,79.904,83.8,85.468,87.62,88.906,91.224,92.906,95.94,98.906,101.07,102.91,106.42,107.87,112.41,114.82,118.71,121.76,127.6,126.9,131.29,132.91,137.33,138.91,140.12,140.91,144.24,146.92,150.36,151.96,157.25,158.93,162.5,164.93,167.26,168.93,173.04,174.97,178.49,180.95,183.84,186.21,190.23,192.22,195.08,196.97,200.59,204.38,207.2,208.98,209.98,209.99,222.02,223.02,226.03,227.03,232.04,231.04,238.03,237.05,239.05,241.06,244.06,249.08,252.08,252.08,257.1,258.1,259.1,262.11,267.12,268.13,271.13,270.13,277.15,276.15,Gt,Gt,283.17,285.18,qt,qt,293.2,Yt,Yt,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.0141,3.016,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71.0787,156.18828,114.10364,115.0877,103.1447,128.13052,129.11458,57.05182,137.14158,113.15934,113.15934,128.17428,131.19846,147.17646,97.11658,87.0777,101.10458,186.2134,163.17546,99.13246]),xl.tq=Vf(qf(kl.jlb,1),S,6,15,[0,1.007825,4.0026,7.016003,9.012182,11.009305,12,14.003074,15.994915,18.998403,19.992435,22.989767,23.985042,26.98153,27.976927,30.973762,31.97207,34.968852,39.962384,38.963707,39.962591,44.95591,47.947947,50.943962,51.940509,54.938047,55.934939,58.933198,57.935346,62.939598,63.929145,68.92558,73.921177,74.921594,79.91652,78.918336,83.911507,84.911794,87.905619,88.905849,89.904703,92.906377,97.905406,89.92381,101.904348,102.9055,105.903478,106.905092,113.903357,114.90388,119.9022,120.903821,129.906229,126.904473,131.904144,132.905429,137.905232,138.906346,139.905433,140.907647,141.907719,135.92398,151.919729,152.921225,157.924099,158.925342,163.929171,164.930319,165.93029,168.934212,173.938859,174.94077,179.946545,180.947992,183.950928,186.955744,191.961467,192.962917,194.964766,196.966543,201.970617,204.974401,207.976627,208.980374,193.98818,195.99573,199.9957,201.00411,206.0038,210.00923,232.038054,216.01896,238.050784,229.03623,232.041169,237.05005,238.05302,242.06194,240.06228,243.06947,243.07446,248.08275,251.08887,253.09515,257.10295,257.10777,271.13,270.13,277.15,276.15,Gt,Gt,283.17,285.18,qt,qt,291.2,Yt,Yt,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.014,3.01605,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]),xl.uq=Vf(qf(kl.llb,1),z,6,15,[6,1,7,8])},xl.xq=function(n){var t,e;for(e=n.a,t=0;t<n.b.length;t++)e+=n.b[t]*xl.tq[n.c[t]];return e},xl.yq=function(n){var t,e;for(t=new Jl._Hb,e=0;e<n.b.length;e++)Jl.$Hb(t,(xl.Sj(),xl.Mj)[n.c[e]]),n.b[e]>1&&Jl.ZHb(t,n.b[e]);return t.a},xl.zq=function(n){var t,e;for(e=n.d,t=0;t<n.b.length;t++)e+=n.b[t]*xl.vq[n.c[t]];return e},xl.Aq=function(n){var t,e,i,s,a,r,o,l,f,g,u;for(xl.nu(n,1),s=vf(kl.llb,z,6,191,15,1),e=0;e<n.q;e++)switch(n.C[e]){case 171:s[1]+=5,s[6]+=3,s[7]+=1,s[8]+=1;break;case 172:s[1]+=12,s[6]+=6,s[7]+=4,s[8]+=1;break;case 173:s[1]+=6,s[6]+=4,s[7]+=2,s[8]+=2;break;case 174:s[1]+=5,s[6]+=4,s[7]+=1,s[8]+=3;break;case 175:s[1]+=5,s[6]+=3,s[7]+=1,s[8]+=1,s[16]+=1;break;case 176:s[1]+=8,s[6]+=5,s[7]+=2,s[8]+=2;break;case 177:s[1]+=7,s[6]+=5,s[7]+=1,s[8]+=3;break;case 178:s[1]+=3,s[6]+=2,s[7]+=1,s[8]+=1;break;case 179:s[1]+=7,s[6]+=6,s[7]+=3,s[8]+=1;break;case 181:case 180:s[1]+=11,s[6]+=6,s[7]+=1,s[8]+=1;break;case 182:s[1]+=12,s[6]+=6,s[7]+=2,s[8]+=1;break;case 183:s[1]+=9,s[6]+=5,s[7]+=1,s[8]+=1,s[16]+=1;break;case 184:s[1]+=9,s[6]+=9,s[7]+=1,s[8]+=1;break;case 185:s[1]+=7,s[6]+=5,s[7]+=1,s[8]+=1;break;case 186:s[1]+=5,s[6]+=3,s[7]+=1,s[8]+=2;break;case 187:s[1]+=7,s[6]+=4,s[7]+=1,s[8]+=2;break;case 188:s[1]+=10,s[6]+=11,s[7]+=2,s[8]+=1;break;case 189:s[1]+=9,s[6]+=9,s[7]+=1,s[8]+=2;break;case 190:s[1]+=9,s[6]+=5,s[7]+=1,s[8]+=1;break;case 1:switch(n.A[e]){case 0:case 1:++s[1];break;case 2:++s[151];break;case 3:++s[152]}break;default:++s[n.C[e]]}for(i=0;i<n.q;i++)n.C[i]>=171&&n.C[i]<=190?s[1]+=2-xl.ko(n,i):s[1]+=xl.fo(n,i);for(o=0,f=1;f<=190;f++)0!=s[f]&&++o;for(this.b=vf(kl.llb,z,6,o,15,1),this.c=vf(kl.llb,z,6,o,15,1),o=0,l=0;l<xl.uq.length;l++)0!=s[xl.uq[l]]&&(this.b[o]=s[xl.uq[l]],this.c[o]=xl.uq[l],++o,s[xl.uq[l]]=0);for(;;){for(u="zzz",g=-1,r=1;r<=190;r++)s[r]>0&&Jl.yHb(u,(xl.Sj(),xl.Mj)[r])>0&&(u=(xl.Sj(),xl.Mj)[r],g=r);if(-1==g)break;this.b[o]=s[g],this.c[o]=g,++o,s[g]=0}for(this.a=0,this.d=0,t=0;t<n.f;t++)1!=n.C[t]&&0!=n.A[t]&&(r=n.C[t],a=n.A[t],this.a+=xl.nq(r,a)-xl.tq[r],this.d+=xl.nq(r,a)-xl.vq[r])},zf(170,1,{170:1}),o.ib=function(n){var t;if(n===this)return!0;if(!_f(n,170))return!1;for(t=0;t<this.b.length;t++)if(this.b[t]!=n.b[t])return!1;return!0},o.a=0,o.d=0,kl.Plb=lg(170),xl.Cq=function(n){switch(n){case 6:return 1;case 53:return 2;case 33:return 3;case 34:return 4;case 35:return 5;case 15:return 6;case 16:return 7;case 17:return 8;case 7:return 9;case 8:return 10;case 9:return 11}return 0},xl.Dq=function(n){var t,e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I,P;for(xl.nu(n,7),I=0,c=vf(kl.Cwb,nn,6,n.f,16,1),P=vf(kl.llb,z,6,n.f,15,1),a=0;a<n.g;a++)e=n.D[0][a],i=n.D[1][a],r=n.s[e],o=n.s[i],0!=r&&0!=o&&r<0^o<0&&(c[e]=!0,c[i]=!0),P[e]+=xl.bl(n,a),P[i]+=xl.bl(n,a);for(l=0;l<n.f;l++)if(I+=n.s[l],1==n.s[l]){if(7==n.C[l]&&!c[l])if(P[l]<=3)I-=1,n.s[l]=0,n.T=0,n.j[l]!=n.e[l]&&(xl.ok(n,xl.Rn(n,l,n.e[l]-1)),xl.nu(n,7));else if(l<n.f&&xl.Ur(n.p,l))for(H=vf(kl.Cwb,nn,6,n.f,16,1),j=vf(kl.Cwb,nn,6,n.g,16,1),xl.An(n,l,!0,H,j),g=0;g<n.f;g++)if(H[g]&&7==n.C[g]&&0==n.s[g]&&2==P[g]&&xl.Gq(n,j,l,g)){I-=1;break}}else if(n.s[l]<0&&(6==n.C[l]||7==n.C[l]||8==n.C[l]||16==n.C[l]))if(c[l]){for((C=vf(kl.llb,z,6,16,15,1))[0]=l,p=1,T=0;T<p;){for(s=0;s<n.r;s++)if(t=-1,n.D[0][s]==C[T]?t=n.D[1][s]:n.D[1][s]==C[T]&&(t=n.D[0][s]),-1!=t&&0!=n.s[t]){for(u=!1,b=0;b<p;b++)if(t==C[b]){u=!0;break}u||(p==C.length&&(f=vf(kl.llb,z,6,2*C.length,15,1),Jl.pIb(C,0,f,0,C.length),C=f),C[p++]=t)}++T}for(d=0,D=0;D<p;D++)d+=xl.zk(n,C[D]);if(d<0){for(m=-1,A=99,h=0;h<p;h++)xl.zk(n,C[h])<0&&A>xl.Cq(xl.Qk(n,C[h]))&&(A=xl.Cq(xl.Qk(n,C[h])),m=C[h]);-1!=m&&(I-=n.s[m],n.s[m]=0,n.T=0)}}else I-=n.s[l],n.s[l]=0,n.T=0;return I>0&&(I=xl.Eq(n,I)),I},xl.Eq=function(n,t){var e,i,s,a;if(t>0&&(t=xl.Hq(n,t,9)),t>0&&(t=xl.Hq(n,t,17)),t>0&&(t=xl.Hq(n,t,35)),t>0&&(t=xl.Hq(n,t,53)),t>0)for(e=0;e<n.f;e++)if(n.s[e]>0){for(s=!1,a=0;a<n.j[e];a++)if(i=n.i[e][a],0==n.s[i]&&xl.Cl(n,i)&&xl.fo(n,i)>0){if(n.s[i]=-1,n.T=0,0==--t)return 0;s=!0;break}if(s)continue}return t>0&&(t=xl.Fq(n,t,8,16)),t>0&&(t=xl.Fq(n,t,8,15)),t>0&&(t=xl.Fq(n,t,8,6)),t>0&&(t=xl.Fq(n,t,7,16)),t},xl.Fq=function(n,t,e,i){var s,a,r,o,l,f,g,u;for(s=0;s<n.f;s++)if(n.C[s]==e&&0==n.s[s]&&xl.fo(n,s)>0)for(o=!1,f=0;f<n.j[s];f++){if(1==n.n[s][f]&&(a=n.i[s][f],n.C[a]==i)){for(u=!1,l=!1,g=0;g<n.j[a];g++){if(r=n.i[a][g],n.s[r]<0){l=!0;break}r!=s&&8==n.C[r]&&2==n.n[a][g]&&(u=!0)}if(!l&&u){if(n.s[s]=-1,n.T=0,0==--t)return 0;o=!0}}if(o)break}return t},xl.Gq=function(n,t,e,i){var s,a,r,o,l,f,g,u;for(u=vf(kl.llb,z,6,n.g,15,1),l=vf(kl.Cwb,nn,6,n.g,16,1),r=0;r<n.g;r++)u[r]=n.H[r],t[r]&&(l[r]=!0,n.H[r]=1,n.T=0);for(s=0;s<n.f;s++)if(s!=i&&0==n.o[s]&&l[n.k[i][0]])for(g=0;g<n.j[s];g++)o=n.k[s][g],n.H[o]=1,n.T=0,l[o]=!1;for(f=0;f<n.j[e];f++)o=n.k[e][f],n.H[o]=1,n.T=0,l[o]=!1;if(xl.je(new xl.te(n),l,!1))return n.s[e]=0,n.T=0,n.j[i]!=n.e[i]&&xl.ok(n,xl.Rn(n,i,n.e[i]-1)),xl.nu(n,7),!0;for(a=0;a<n.g;a++)xl.Fm(n,a,u[a]);return!1},xl.Hq=function(n,t,e){var i;for(i=0;i<n.f;i++)if(n.C[i]==e&&0==n.s[i]&&0==n.j[i]&&(n.s[i]=-1,n.T=0,0==--t))return 0;return t},xl.Iq=function(n,t){var e,i;for(i=Jf.QKb(n.b,t),e=Rl.LTb(i).length;e<10;e++)Jl.cIb(n.a,32);Jl.gIb(n.a,i)},xl.Jq=function(n,t){var e,i,s;if(t<0||t>999)Jl.gIb(n.a,"  ?");else for(e=!1,i=0;i<3;i++)0==(s=t/100|0)?2==i||e?Jl.cIb(n.a,48):Jl.cIb(n.a,32):(Jl.cIb(n.a,48+s&y),e=!0),t=t%100*10},xl.Kq=function(n,t){Lf.UEb(t,n.a.a)},xl.Lq=function(n){xl.Mq.call(this,n)},xl.Mq=function(n){xl.Oq.call(this,n,new Jl.kIb)},xl.Nq=function(t,e,i){var s,a,r,o,l,f,g,u,d,c,h,b,D,j,m,A,C,T,p,I,P,M,w,N,L,U,k,J,B,R,E,x,F,Q,S,X,G,q,Y,v,Z,O,V,K;for(this.b=new Jf.TKb(vt),xl.nu(t,15),E=!0,a=0;a<t.f;a++)if(0!=(3&t.u[a])&&3!=(3&t.u[a])&&(t.u[a]&Vn)>>18!=1){E=!1;break}if(F=-1,E)for(L=vf(kl.llb,z,6,32,15,1),Q=0,r=0;r<t.f;r++)if(0!=(3&t.u[r])&&3!=(3&t.u[r])&&(t.u[r]&Vn)>>18==1){++L[k=(t.u[r]&Vn)>>18!=1&&(t.u[r]&Vn)>>18!=2?-1:(t.u[r]&Mt)>>20],Q<L[k]&&(Q=L[k],F=k);break}for(this.a=i||new Jl.jIb,X=null!=t.P?t.P:"",Jl.gIb(this.a,X+H),Jl.gIb(this.a,"Actelion Java MolfileCreator 1.0\n\n"),xl.Jq(this,t.q),xl.Jq(this,t.r),Jl.gIb(this.a,"  0  0"),xl.Jq(this,E?0:1),Jl.gIb(this.a,"  0  0  0  0  0999 V2000\n"),J=1==t.q,f=1;f<t.q;f++)if(t.J[f].a!=t.J[0].a||t.J[f].b!=t.J[0].b||t.J[f].c!=t.J[0].c){J=!0;break}if(U=1,J)if(0!=e)U=e;else if(0!=(A=xl.Sk(t,t.q,t.r,(xl.Sj(),xl.Rj))))(A<1||A>3)&&(U=1.5/A);else{for(S=jt,r=1;r<t.q;r++)for(l=0;l<r;l++)S>(P=(M=t.J[l].a-t.J[r].a)*M+(w=t.J[l].b-t.J[r].b)*w+(N=t.J[l].c-t.J[r].c)*N)&&(S=P);U=3/S}for(g=0;g<t.q;g++)J?(xl.Iq(this,U*t.J[g].a),xl.Iq(this,U*-t.J[g].b),xl.Iq(this,U*-t.J[g].c)):Jl.gIb(this.a,"    0.0000    0.0000    0.0000"),null!=(null==t.v?null:t.v[g])?Jl.gIb(this.a," L  "):Bg(Cg(t.B[g],1),0)?Jl.gIb(this.a," A  "):t.C[g]>=129&&t.C[g]<=144||154==t.C[g]?Jl.gIb(this.a," R# "):(D=(xl.Sj(),xl.Mj)[t.C[g]],Jl.gIb(this.a," "+D),1==Rl.LTb(D).length?Jl.gIb(this.a,"  "):2==Rl.LTb(D).length&&Jl.gIb(this.a," ")),Jl.gIb(this.a," 0  0  0"),0==Tg(B=Cg(cn,t.B[g]),0)?Jl.gIb(this.a,"  0"):0==Tg(B,384)?Jl.gIb(this.a,"  3"):0==Tg(B,128)?Jl.gIb(this.a,"  2"):0==Tg(B,1792)?Jl.gIb(this.a,"  1"):0==Tg(B,1664)&&Jl.gIb(this.a,"  2"),Jl.gIb(this.a,Bg(Cg(t.B[g],Xn),0)?"  1":"  0"),-1==(K=((t.u[g]&Pt)>>>27)-1)?Jl.gIb(this.a,"  0"):0==K?Jl.gIb(this.a," 15"):xl.Jq(this,K),Jl.gIb(this.a,"  0  0  0"),xl.Jq(this,n.Math.abs(t.w[g])),Jl.gIb(this.a,"  0  0\n");for(C=0;C<t.r;C++){switch(t.H[C]){case 1:default:q=1,Z=0;break;case 2:q=2,Z=0;break;case 4:q=3,Z=0;break;case 129:q=1,Z=6;break;case 257:q=1,Z=1;break;case 386:q=2,Z=3;break;case 64:q=4,Z=0;break;case 32:q=8,Z=0}!E||1!=Z&&6!=Z||(r=t.D[0][C],(t.u[r]&Vn)>>18==2?Z=0:(t.u[r]&Vn)>>18==1&&((t.u[r]&Vn)>>18!=1&&(t.u[r]&Vn)>>18!=2?-1:(t.u[r]&Mt)>>20)!=F&&(Z=4)),0!=(T=31&t.G[C])&&(q=8==T?4:3==T?5:9==T?6:10==T?7:8),V=0==(v=384&t.G[C])?0:256==v?1:2,xl.Jq(this,1+t.D[0][C]),xl.Jq(this,1+t.D[1][C]),xl.Jq(this,q),xl.Jq(this,Z),Jl.gIb(this.a,"  0"),xl.Jq(this,V),Jl.gIb(this.a,"  0\n")}for(G=0,u=0;u<t.q;u++)0!=t.s[u]&&++G;if(0!=G)for(I=0,r=0;r<t.q;r++)0!=t.s[r]&&(0==I&&(Jl.gIb(this.a,"M  CHG"),xl.Jq(this,n.Math.min(8,G))),Jl.gIb(this.a," "),xl.Jq(this,r+1),(p=t.s[r])<0?(Jl.gIb(this.a,"  -"),p=-p):Jl.gIb(this.a,"   "),Jl.cIb(this.a,48+p&y),--G,8!=++I&&0!=G||(I=0,Jl.gIb(this.a,H)));for(G=0,d=0;d<t.q;d++)0==t.A[d]||++G;if(0!=G)for(I=0,r=0;r<t.q;r++)0!=t.A[r]&&(0==I&&(Jl.gIb(this.a,"M  ISO"),xl.Jq(this,n.Math.min(8,G))),Jl.gIb(this.a," "),xl.Jq(this,r+1),Jl.gIb(this.a," "),xl.Jq(this,t.A[r]),--G,8!=++I&&0!=G||(I=0,Jl.gIb(this.a,H)));for(G=0,c=0;c<t.q;c++)0!=(48&t.u[c])&&++G;if(0!=G)for(I=0,r=0;r<t.q;r++)if(0!=(48&t.u[r])){switch(0==I&&(Jl.gIb(this.a,"M  RAD"),xl.Jq(this,n.Math.min(8,G))),Jl.gIb(this.a," "),xl.Jq(this,r+1),48&t.u[r]){case 16:Jl.gIb(this.a,"   1");break;case 32:Jl.gIb(this.a,"   2");break;case 48:Jl.gIb(this.a,"   3")}--G,8!=++I&&0!=G||(I=0,Jl.gIb(this.a,H))}for(G=0,h=0;h<t.q;h++)(t.C[h]>=129&&t.C[h]<=144||154==t.C[h])&&++G;if(0!=G)for(I=0,s=0;s<t.q;s++)((m=t.C[s])>=129&&m<=144||154==m)&&(0==I&&(Jl.gIb(this.a,"M  RGP"),xl.Jq(this,n.Math.min(8,G))),Jl.gIb(this.a," "),xl.Jq(this,s+1),Jl.gIb(this.a," "),xl.Jq(this,154==m?0:m>=142?m-141:m-125),--G,8!=++I&&0!=G||(I=0,Jl.gIb(this.a,H)));if(t.K){for(G=0,r=0;r<t.q;r++)Bg(Cg(t.B[r],120),0)&&++G;if(0!=G)for(I=0,l=0;l<t.q;l++)0!=Tg(Y=Cg(t.B[l],120),0)&&(0==I&&(Jl.gIb(this.a,"M  RBC"),xl.Jq(this,n.Math.min(8,G))),Jl.gIb(this.a," "),xl.Jq(this,l+1),0==Tg(Y,112)?Jl.gIb(this.a,"  -1"):0==Tg(Y,8)?Jl.gIb(this.a,"   1"):0==Tg(Y,104)?Jl.gIb(this.a,"   2"):0==Tg(Y,88)?Jl.gIb(this.a,"   3"):0==Tg(Y,56)&&Jl.gIb(this.a,"   4"),--G,8!=++I&&0!=G||(I=0,Jl.gIb(this.a,H)));for(b=0;b<t.q;b++)if(null!=(j=null==t.v?null:t.v[b])){for(Jl.gIb(this.a,"M  ALS "),xl.Jq(this,b+1),xl.Jq(this,j.length),Jl.gIb(this.a,Bg(Cg(t.B[b],1),0)?" T ":" F "),R=0;R<j.length;R++)switch(x=(xl.Sj(),xl.Mj)[j[R]],Rl.LTb(x).length){case 1:Jl.gIb(this.a,x+"   ");break;case 2:Jl.gIb(this.a,x+"  ");break;case 3:Jl.gIb(this.a,x+" ");break;default:Jl.gIb(this.a,"   ?")}Jl.gIb(this.a,H)}for(G=0,o=0;o<t.q;o++)Bg(Cg(t.B[o],6144),0)&&++G;if(0!=G)for(I=0,s=0;s<t.q;s++)0!=Tg(O=Cg(t.B[s],6144),0)&&(0==I&&(Jl.gIb(this.a,"M  SUB"),xl.Jq(this,n.Math.min(8,G))),Jl.gIb(this.a," "),xl.Jq(this,s+1),Bg(Cg(O,fn),0)?Jl.gIb(this.a,"   "+(t.e[s]+1)):Jl.gIb(this.a,"  -2"),--G,8!=++I&&0!=G||(I=0,Jl.gIb(this.a,H)))}Jl.gIb(this.a,Zt)},xl.Oq=function(n,t){xl.Nq.call(this,n,0,t)},zf(135,1,{},xl.Lq,xl.Nq),kl.Rlb=lg(135),xl.Pq=function(n,t,e,i,s,a){var r,o,l,f;switch(f=1,o=!1,s){case 1:f=257;break;case 3:f=386;break;case 4:f=257,o=!0;break;case 6:f=129;break;default:switch(i){case 1:f=1;break;case 2:f=2;break;case 3:f=4;break;case 4:f=64;break;case 9:f=32}}if(r=xl.Wj(n.j,t,e,f),l=0,o&&xl.hm(n.j,t,1,-1),i>4)switch(i){case 5:l|=3;break;case 6:l|=9;break;case 7:l|=10;break;case 8:32!=f&&(l|=31)}return 1==a&&(l|=256),2==a&&(l|=128),0!=l&&xl.Em(n.j,r,l,!0),r},xl.Qq=function(t){var e,i,s,a,r,o,l,f,g,u,d;for(o=vf(kl.llb,z,6,t.j.q,15,1),i=0;i<t.j.q;i++)o[i]=-xl.zk(t.j,i);for(xl.je(new xl.te(t.j),null,!0),s=0;s<t.j.q;s++)o[s]+=xl.zk(t.j,s);for(e=0;e<t.j.q;e++)if(0!=o[e])for(l=-o[e],a=0;a<t.j.r;a++)for(g=0;g<2;g++)l>0&&32==xl.el(t.j,a)&&xl.Vk(t.j,1-g,a)==e&&(d=xl.Vk(t.j,g,a),xl.Fl(t.j,d)&&(u=xl.Sq(t,d),(r=xl.zk(t.j,d))<u&&(f=n.Math.min(l,u-r),xl.cm(t.j,d,r+f),l-=f)))},xl.Rq=function(n,t){return n.j=null,xl.hr(n,new Lf.PEb(new Lf.TEb(t)))?n.j:null},xl.Sq=function(n,t){var e,i;return null==(i=(e=xl.Qk(n.j,t))<(xl.Sj(),xl.Oj).length?xl.Oj[e]:null)?0:i[i.length-1]},xl.Tq=function(n,t){var e;return(e=n.b?Fl.lNb(n.b,new Jl.IGb(t)):null)?e.a:t-1},xl.Uq=function(n,t){var e;return(e=n.c?Fl.lNb(n.c,new Jl.IGb(t)):null)?e.a:t-1},xl.Vq=function(n,t){var e,i;if(null!=t)for(xl.nu(n.j,1),e=0;e<n.j.f;e++)0!=t[e]&&(i=xl.il(n.j,e,xl.ko(n.j,e)),15==t[e]?i>=0&&xl.am(n.j,e,0):t[e]!=xl.jl(n.j,e)&&xl.am(n.j,e,t[e]-i))},xl.Wq=function(n,t){var e;if(-1==t)return-1;for(e=t+1;e<Rl.LTb(n).length;e++)if(Rl.GTb(e,Rl.LTb(n).length),32!=Rl.LTb(n).charCodeAt(e)&&(Rl.GTb(e,Rl.LTb(n).length),9!=Rl.LTb(n).charCodeAt(e)))return e;return-1},xl.Xq=function(n,t){var e;for(e=t;e<Rl.LTb(n).length;e++)if(Rl.GTb(e,Rl.LTb(n).length),32==Rl.LTb(n).charCodeAt(e)||(Rl.GTb(e,Rl.LTb(n).length),9==Rl.LTb(n).charCodeAt(e)))return e;return-1},xl.Yq=function(n){return-1!=Rl.LTb(n).indexOf("ATOMS=(")?Ot:-1!=Rl.LTb(n).indexOf("BONDS=(")?"BONDS":null},xl.Zq=function(t,e){var i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,P,M,w,N,L;for(D=0,H=-1==(l=xl.Xq(e,D+1))?Rl.LTb(e).length:l,s=Jl.nGb((Rl.FTb(D,H,Rl.LTb(e).length),Rl.LTb(e).substr(D,H-D)),Vt,I),D=xl.Wq(e,H),H=-1==(f=xl.Xq(e,D+1))?Rl.LTb(e).length:f,Rl.FTb(D,H,Rl.LTb(e).length),m=Rl.LTb(e).substr(D,H-D),P=null,a=!1,0!=(j=xl.er(e))&&(P=xl.$q(e),j<0&&(a=!0),H=n.Math.abs(j)),D=xl.Wq(e,H),H=-1==(g=xl.Xq(e,D+1))?Rl.LTb(e).length:g,w=tu((Rl.FTb(D,H,Rl.LTb(e).length),Rl.LTb(e).substr(D,H-D))),D=xl.Wq(e,H),H=-1==(u=xl.Xq(e,D+1))?Rl.LTb(e).length:u,N=tu((Rl.FTb(D,H,Rl.LTb(e).length),Rl.LTb(e).substr(D,H-D))),D=xl.Wq(e,H),H=-1==(d=xl.Xq(e,D+1))?Rl.LTb(e).length:d,L=tu((Rl.FTb(D,H,Rl.LTb(e).length),Rl.LTb(e).substr(D,H-D))),D=xl.Wq(e,H),H=-1==(c=xl.Xq(e,D+1))?Rl.LTb(e).length:c,C=Jl.nGb((Rl.FTb(D,H,Rl.LTb(e).length),Rl.LTb(e).substr(D,H-D)),Vt,I),(i=xl.Tj(t.j,w,-N,-L))+1!=s&&(!t.b&&(t.b=new Fl.oRb),Fl.gRb(t.b,new Jl.IGb(s),new Jl.IGb(i))),null!=P&&(xl.vm(t.j,i,6),xl.jm(t.j,i,P,a)),0!=C&&xl.km(t.j,i,C,!1),Jl.DHb(m,"A")||Jl.DHb(m,"*")?xl.om(t.j,i,1,!0):Jl.DHb(m,"Q")?((A=vf(kl.llb,z,6,1,15,1))[0]=6,xl.jm(t.j,i,A,!0)):xl.vm(t.j,i,xl.hn(m,67));-1!=(D=xl.Wq(e,H));)if(H=-1==(o=xl.Xq(e,D+1))?Rl.LTb(e).length:o,Rl.FTb(D,H,Rl.LTb(e).length),T=Rl.LTb(e).substr(D,H-D),b=Jl.HHb(T,bg(61)),Rl.FTb(0,b,Rl.LTb(T).length),h=Rl.LTb(T).substr(0,b),M=Jl.nGb((Rl.GTb(b+1,Rl.LTb(T).length+1),Rl.LTb(T).substr(b+1)),Vt,I),Jl.DHb(h,"CHG"))xl.cm(t.j,i,M);else if(Jl.DHb(h,"RAD"))switch(M){case 1:xl.pm(t.j,i,16);break;case 2:xl.pm(t.j,i,32);break;case 3:xl.pm(t.j,i,48)}else if(Jl.DHb(h,"CFG"));else if(Jl.DHb(h,"MASS"))xl.mm(t.j,i,M);else if(Jl.DHb(h,"VAL"))xl.am(t.j,i,-1==M?0:0==M?-1:M);else if(Jl.DHb(h,"HCOUNT"))switch(M){case 0:break;case-1:xl.om(t.j,i,1792,!0);break;case 1:xl.om(t.j,i,128,!0);break;case 2:xl.om(t.j,i,384,!0);break;default:xl.om(t.j,i,896,!0)}else if(Jl.DHb(h,"SUBST")){if(-1==M)xl.om(t.j,i,zn,!0);else if(M>0){for(p=0,r=0;r<t.j.r;r++)(xl.Vk(t.j,0,r)==i||xl.Vk(t.j,1,r)==i)&&++p;M>p&&xl.om(t.j,i,fn,!0)}}else if(Jl.DHb(h,"RBCNT"))switch(M){case 3:case-1:xl.om(t.j,i,112,!0);break;case 1:xl.om(t.j,i,8,!0);break;case 2:xl.om(t.j,i,104,!0);break;case 4:xl.om(t.j,i,56,!0)}},xl.$q=function(n){var t,e,i,s,a,r,o,l;if(o=null,e=Rl.LTb(n).indexOf("["),i=Rl.LTb(n).indexOf("]",e),e>=0&&i>0){for(t=vf(kl.llb,z,6,16,15,1),Rl.FTb(e+1,i,Rl.LTb(n).length),l=Rl.LTb(n).substr(e+1,i-(e+1)),s=0,r=!0;r&&s<16;)a=null,-1==(e=Rl.LTb(l).indexOf(","))?(a=l,r=!1):(Rl.FTb(0,e,Rl.LTb(l).length),a=Rl.LTb(l).substr(0,e),Rl.GTb(e+1,Rl.LTb(l).length+1),l=Rl.LTb(l).substr(e+1)),t[s++]=xl.hn(a,1);o=vf(kl.llb,z,6,s,15,1),Jl.pIb(t,0,o,0,s)}return o},xl._q=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m;for(h=0,b=-1==(l=xl.Xq(t,h+1))?Rl.LTb(t).length:l,a=Jl.nGb((Rl.FTb(h,b,Rl.LTb(t).length),Rl.LTb(t).substr(h,b-h)),Vt,I),h=xl.Wq(t,b),b=-1==(f=xl.Xq(t,h+1))?Rl.LTb(t).length:f,r=Jl.nGb((Rl.FTb(h,b,Rl.LTb(t).length),Rl.LTb(t).substr(h,b-h)),Vt,I),h=xl.Wq(t,b),b=-1==(g=xl.Xq(t,h+1))?Rl.LTb(t).length:g,e=xl.Tq(n,Jl.nGb((Rl.FTb(h,b,Rl.LTb(t).length),Rl.LTb(t).substr(h,b-h)),Vt,I)),h=xl.Wq(t,b),b=-1==(u=xl.Xq(t,h+1))?Rl.LTb(t).length:u,i=xl.Tq(n,Jl.nGb((Rl.FTb(h,b,Rl.LTb(t).length),Rl.LTb(t).substr(h,b-h)),Vt,I)),H=0,j=0;-1!=(h=xl.Wq(t,b));)if(b=-1==(o=xl.Xq(t,h+1))?Rl.LTb(t).length:o,Rl.FTb(h,b,Rl.LTb(t).length),D=Rl.LTb(t).substr(h,b-h),c=Jl.HHb(D,bg(61)),Rl.FTb(0,c,Rl.LTb(D).length),d=Rl.LTb(D).substr(0,c),m=Jl.nGb((Rl.GTb(c+1,Rl.LTb(D).length+1),Rl.LTb(D).substr(c+1)),Vt,I),Jl.DHb(d,"CFG"))switch(m){case 1:H=1;break;case 2:H=2==r?3:4;break;case 3:H=6}else Jl.DHb(d,"TOPO")&&(j=m);(s=xl.Pq(n,e,i,r,H,j))+1!=a&&(!n.c&&(n.c=new Fl.oRb),Fl.gRb(n.c,new Jl.IGb(a),new Jl.IGb(s)))},xl.ar=function(n,t){var e,i,s,a,r,o;if(null!=(o=xl.Yq(t)))if(r=xl.cr(t,o),Jl.DHb(Rl.LTb(t).substr(0,13),"MDLV30/STEABS"))if(Jl.DHb(o,Ot))for(a=0;a<r.length;a++)xl.hm(n.j,xl.Tq(n,r[a]),0,-1);else for(s=0;s<r.length;s++)xl.zm(n.j,xl.Uq(n,r[s]),0,-1);else if(Jl.DHb(Rl.LTb(t).substr(0,13),"MDLV30/STERAC"))if(i=Jl.nGb(Jl.RHb(t,13,xl.Xq(t,13)),Vt,I),Jl.DHb(o,Ot))for(a=0;a<r.length;a++)xl.hm(n.j,xl.Tq(n,r[a]),1,i-1);else for(s=0;s<r.length;s++)xl.zm(n.j,xl.Uq(n,r[s]),1,i-1);else if(Jl.DHb(Rl.LTb(t).substr(0,13),"MDLV30/STEREL"))if(i=Jl.nGb(Jl.RHb(t,13,xl.Xq(t,13)),Vt,I),Jl.DHb(o,Ot))for(a=0;a<r.length;a++)xl.hm(n.j,xl.Tq(n,r[a]),2,i-1);else for(s=0;s<r.length;s++)xl.zm(n.j,xl.Uq(n,r[s]),2,i-1);else if(Jl.DHb(Rl.LTb(t).substr(0,13),"MDLV30/HILITE"))if(Jl.DHb(o,Ot))for(s=0;s<r.length;s++)xl.dm(n.j,xl.Tq(n,r[s]),448);else for(s=0;s<r.length;s++)e=xl.Uq(n,r[s]),xl.dm(n.j,xl.Vk(n.j,0,e),448),xl.dm(n.j,xl.Vk(n.j,1,e),448)},xl.br=function(n,t){var e,i,s;n.j||Jl.DHb(Rl.LTb(t).substr(0,6),"COUNTS")&&(e=xl.Wq(t,xl.Xq(t,7)),i=Jl.nGb(Jl.RHb(t,7,xl.Xq(t,7)),Vt,I),s=Jl.nGb(Jl.RHb(t,e,xl.Xq(t,e)),Vt,I),n.j=new xl.Gu(i,s))},xl.cr=function(n,t){var e,i,s,a,r,o;for(a=Rl.LTb(n).indexOf(t+"=(")+Rl.LTb(t).length+2,r=Jl.IHb(n,bg(41),a),s=xl.Xq(n,a),e=Jl.nGb((Rl.FTb(a,s,Rl.LTb(n).length),Rl.LTb(n).substr(a,s-a)),Vt,I),o=vf(kl.llb,z,6,e,15,1),i=0;i<e;i++)a=xl.Wq(n,s),(-1==(s=xl.Xq(n,a))||s>r)&&(s=r),o[i]=Jl.nGb((Rl.FTb(a,s,Rl.LTb(n).length),Rl.LTb(n).substr(a,s-a)),Vt,I);return o},xl.dr=function(n){var t,e,i,s,a,r,o,l,f;for(l=vf(kl.llb,z,6,n.j.q,15,1),i=0;i<n.j.r;i++)if(64==xl.el(n.j,i))for(r=0;r<2;r++)l[xl.Vk(n.j,r,i)]=1;for(s=0;s<n.j.r;s++)for(f=xl.bl(n.j,s),a=0;a<2;a++)l[xl.Vk(n.j,a,s)]+=f;for(e=0;e<n.j.r;e++)if(1==xl.bl(n.j,e))for(a=0;a<2;a++)o=xl.Vk(n.j,1-a,e),xl.Fl(n.j,o)&&(t=xl.Vk(n.j,a,e),xl.Cl(n.j,t)&&l[t]>xl.jl(n.j,t))&&xl.Fm(n.j,e,32)},xl.er=function(n){var t,e;if(Rl.LTb(n).indexOf("[")>=0){if(t=Rl.LTb(n).indexOf(" NOT["),e=Rl.LTb(n).indexOf("]",t),t>=0&&e>0)return-(e+1);if(t=Rl.LTb(n).indexOf(" ["),e=Rl.LTb(n).indexOf("]",t),t>=0&&e>0)return e+1;if(t=Rl.LTb(n).indexOf(" 'NOT["),e=Rl.LTb(n).indexOf("]'",t),t>=0&&e>0)return-(e+2);if(t=Rl.LTb(n).indexOf(" '["),e=Rl.LTb(n).indexOf("]'",t),t>=0&&e>0)return e+2;Jl.oIb()}return 0},xl.fr=function(n,t,e){return n.j=t,xl.hr(n,e)},xl.gr=function(n){return 0==Rl.LTb(n).length?0:Jl.nGb(n,Vt,I)},xl.hr=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,P,M,w,N,L,U,k,J,y,B,R,E,x,F,Q,S,X,G;F=null;try{if(n.f=null,n.j&&(xl.hk(n.j),xl.Hm(n.j,!1)),null==(P=m=Lf.OEb(t)))return!1;if(null==(m=Lf.OEb(t)))return!1;if(null==(m=Lf.OEb(t)))return!1;if(n.k=-1!=Rl.LTb(m).indexOf("From CSD data. Using bond type 'Any'"),n.e=-1!=Rl.LTb(m).indexOf("From CSD data."),null==(m=Lf.OEb(t)))return!1;n.g=!1,n.d=n.a;try{M=Jl.nGb(Jl.SHb((Rl.FTb(0,3,Rl.LTb(m).length),Rl.LTb(m).substr(0,3))),Vt,I),w=Jl.nGb(Jl.SHb((Rl.FTb(3,6,Rl.LTb(m).length),Rl.LTb(m).substr(3,3))),Vt,I),N=xl.gr(Jl.SHb((Rl.FTb(6,9,Rl.LTb(m).length),Rl.LTb(m).substr(6,3)))),n.d=n.d|1==xl.gr(Jl.SHb((Rl.FTb(12,15,Rl.LTb(m).length),Rl.LTb(m).substr(12,3)))),n.g=Rl.LTb(m).length>=39&&Jl.DHb(Rl.LTb(m).substr(34,Rl.LTb("V3000").length),"V3000")}catch(n){if(_f(n=rg(n),19))return!1;throw og(n)}if(n.g)return U=xl.ir(n,t),xl.Nm(n.j,P),U;if(!n.j&&(n.j=new xl.Gu(M,w)),xl.Nm(n.j,P),n.d||(n.j.L=!0),0==M){for(;null!=m&&!(Jl.DHb(m,Kt)||Jl.DHb(m,Wt)||Jl.DHb((Rl.GTb(1,Rl.LTb(m).length+1),Rl.LTb(m).substr(1)),"$"));)m=Lf.OEb(t);return!0}for(h=0;h<M;h++){if(null==(m=Lf.OEb(t)))return!1;switch(S=tu(Jl.SHb((Rl.FTb(0,10,Rl.LTb(m).length),Rl.LTb(m).substr(0,10)))),X=tu(Jl.SHb((Rl.FTb(10,20,Rl.LTb(m).length),Rl.LTb(m).substr(10,10)))),G=tu(Jl.SHb((Rl.FTb(20,30,Rl.LTb(m).length),Rl.LTb(m).substr(20,10)))),i=xl.Tj(n.j,S,-X,-G),j=Jl.SHb((Rl.FTb(31,34,Rl.LTb(m).length),Rl.LTb(m).substr(31,3))),Jl.DHb(j,"A")||Jl.DHb(j,"*")?xl.om(n.j,i,1,!0):Jl.DHb(j,"Q")?((A=vf(kl.llb,z,6,1,15,1))[0]=6,xl.jm(n.j,i,A,!0)):(r=xl.hn(j,67),xl.vm(n.j,i,r)),0!=(p=xl.gr(Jl.SHb((Rl.FTb(34,36,Rl.LTb(m).length),Rl.LTb(m).substr(34,2)))))&&xl.mm(n.j,i,(xl.Sj(),xl.Qj)[xl.Qk(n.j,i)]+p),0!=(u=xl.gr(Jl.SHb((Rl.FTb(36,39,Rl.LTb(m).length),Rl.LTb(m).substr(36,3)))))&&(4==u?xl.pm(n.j,i,32):xl.cm(n.j,i,4-u)),C=Rl.LTb(m).length<63?0:xl.gr(Jl.SHb((Rl.FTb(60,63,Rl.LTb(m).length),Rl.LTb(m).substr(60,3)))),xl.km(n.j,i,C,!1),Rl.LTb(m).length<45?0:xl.gr(Jl.SHb((Rl.FTb(42,45,Rl.LTb(m).length),Rl.LTb(m).substr(42,3))))){case 0:break;case 1:xl.om(n.j,i,768,!0);break;case 2:xl.om(n.j,i,128,!0);break;case 3:xl.om(n.j,i,384,!0);break;default:xl.om(n.j,i,896,!0)}Rl.LTb(m).length>=48&&(Rl.GTb(47,Rl.LTb(m).length),49==Rl.LTb(m).charCodeAt(47))&&xl.om(n.j,i,Xn,!0),0!=(x=Rl.LTb(m).length<51?0:xl.gr(Jl.SHb((Rl.FTb(48,51,Rl.LTb(m).length),Rl.LTb(m).substr(48,3)))))&&(null==F&&(F=vf(kl.llb,z,6,M,15,1)),F[i]=x)}for(b=0;b<w;b++){if(null==(m=Lf.OEb(t)))return!1;s=Jl.nGb(Jl.SHb((Rl.FTb(0,3,Rl.LTb(m).length),Rl.LTb(m).substr(0,3))),Vt,I)-1,a=Jl.nGb(Jl.SHb((Rl.FTb(3,6,Rl.LTb(m).length),Rl.LTb(m).substr(3,3))),Vt,I)-1,f=Jl.nGb(Jl.SHb((Rl.FTb(6,9,Rl.LTb(m).length),Rl.LTb(m).substr(6,3))),Vt,I),J=Rl.LTb(m).length<12?0:xl.gr(Jl.SHb((Rl.FTb(9,12,Rl.LTb(m).length),Rl.LTb(m).substr(9,3)))),E=Rl.LTb(m).length<18?0:xl.gr(Jl.SHb((Rl.FTb(15,18,Rl.LTb(m).length),Rl.LTb(m).substr(15,3)))),8==f&&(n.k||xl.Fl(n.j,s)||xl.Fl(n.j,a))&&(f=9),xl.Pq(n,s,a,f,J,E)}for(c=0;c<N;c++)if(null==(m=Lf.OEb(t)))return!1;if(null==(m=Lf.OEb(t)))return 0!=(1&n.i)&&(n.f=xl.co(n.j)),xl.Vq(n,F),n.d||xl.nu(n.j,15),!0;for(;null!=m&&!Jl.DHb(m,Kt)&&!Jl.DHb(m,Wt);){if(Jl.DHb(Rl.LTb(m).substr(0,6),"M  CHG")&&(D=Jl.nGb(Jl.SHb((Rl.FTb(6,9,Rl.LTb(m).length),Rl.LTb(m).substr(6,3))),Vt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)i=Jl.nGb(Jl.SHb((Rl.FTb(e,e+3,Rl.LTb(m).length),Rl.LTb(m).substr(e,e+3-e))),Vt,I)-1,g=Jl.nGb(Jl.SHb((Rl.FTb(Q,Q+3,Rl.LTb(m).length),Rl.LTb(m).substr(Q,Q+3-Q))),Vt,I),xl.cm(n.j,i,g);if(Jl.DHb(Rl.LTb(m).substr(0,6),"M  ISO")&&(D=Jl.nGb(Jl.SHb((Rl.FTb(6,9,Rl.LTb(m).length),Rl.LTb(m).substr(6,3))),Vt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)i=Jl.nGb(Jl.SHb((Rl.FTb(e,e+3,Rl.LTb(m).length),Rl.LTb(m).substr(e,e+3-e))),Vt,I)-1,T=Jl.nGb(Jl.SHb((Rl.FTb(Q,Q+3,Rl.LTb(m).length),Rl.LTb(m).substr(Q,Q+3-Q))),Vt,I),xl.mm(n.j,i,T);if(Jl.DHb(Rl.LTb(m).substr(0,6),"M  RAD")&&(D=Jl.nGb(Jl.SHb((Rl.FTb(6,9,Rl.LTb(m).length),Rl.LTb(m).substr(6,3))),Vt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)switch(i=Jl.nGb(Jl.SHb((Rl.FTb(e,e+3,Rl.LTb(m).length),Rl.LTb(m).substr(e,e+3-e))),Vt,I)-1,Jl.nGb(Jl.SHb((Rl.FTb(Q,Q+3,Rl.LTb(m).length),Rl.LTb(m).substr(Q,Q+3-Q))),Vt,I)){case 1:xl.pm(n.j,i,16);break;case 2:xl.pm(n.j,i,32);break;case 3:xl.pm(n.j,i,48)}if((Jl.DHb(Rl.LTb(m).substr(0,6),"M  RBC")||Jl.DHb(Rl.LTb(m).substr(0,6),"M  RBD"))&&(D=Jl.nGb(Jl.SHb((Rl.FTb(6,9,Rl.LTb(m).length),Rl.LTb(m).substr(6,3))),Vt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)switch(i=Jl.nGb(Jl.SHb((Rl.FTb(e,e+3,Rl.LTb(m).length),Rl.LTb(m).substr(e,e+3-e))),Vt,I)-1,Jl.nGb(Jl.SHb((Rl.FTb(Q,Q+3,Rl.LTb(m).length),Rl.LTb(m).substr(Q,Q+3-Q))),Vt,I)){case 3:case-1:xl.om(n.j,i,112,!0);break;case 1:xl.om(n.j,i,8,!0);break;case 2:xl.om(n.j,i,104,!0);break;case 4:xl.om(n.j,i,56,!0)}if(Jl.DHb(Rl.LTb(m).substr(0,6),"M  ALS")&&(i=Jl.nGb(Jl.SHb((Rl.FTb(7,10,Rl.LTb(m).length),Rl.LTb(m).substr(7,3))),Vt,I)-1)>=0){for(L=Jl.nGb(Jl.SHb((Rl.FTb(10,13,Rl.LTb(m).length),Rl.LTb(m).substr(10,3))),Vt,I),Rl.GTb(14,Rl.LTb(m).length),o=84==Rl.LTb(m).charCodeAt(14),x=vf(kl.llb,z,6,L,15,1),e=16,H=0;H<L;++H,e+=4)R=Jl.SHb((Rl.FTb(e,e+4,Rl.LTb(m).length),Rl.LTb(m).substr(e,e+4-e))),x[H]=xl.hn(R,1);xl.vm(n.j,i,6),xl.jm(n.j,i,x,o)}if(Jl.DHb(Rl.LTb(m).substr(0,6),"M  SUB")&&(D=Jl.nGb(Jl.SHb((Rl.FTb(6,9,Rl.LTb(m).length),Rl.LTb(m).substr(6,3))),Vt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)if(i=Jl.nGb(Jl.SHb((Rl.FTb(e,e+3,Rl.LTb(m).length),Rl.LTb(m).substr(e,e+3-e))),Vt,I)-1,-2==(y=Jl.nGb(Jl.SHb((Rl.FTb(Q,Q+3,Rl.LTb(m).length),Rl.LTb(m).substr(Q,Q+3-Q))),Vt,I)))xl.om(n.j,i,zn,!0);else if(y>0){for(B=0,l=0;l<n.j.r;l++)(xl.Vk(n.j,0,l)==i||xl.Vk(n.j,1,l)==i)&&++B;y>B&&xl.om(n.j,i,fn,!0)}if(Jl.DHb(Rl.LTb(m).substr(0,6),"M  RGP")&&(D=Jl.nGb(Jl.SHb((Rl.FTb(6,9,Rl.LTb(m).length),Rl.LTb(m).substr(6,3))),Vt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)i=Jl.nGb(Jl.SHb((Rl.FTb(e,e+3,Rl.LTb(m).length),Rl.LTb(m).substr(e,e+3-e))),Vt,I)-1,(k=Jl.nGb(Jl.SHb((Rl.FTb(Q,Q+3,Rl.LTb(m).length),Rl.LTb(m).substr(Q,Q+3-Q))),Vt,I))>=1&&k<=20&&xl.vm(n.j,i,xl.hn("R"+k,2));m=Lf.OEb(t)}}catch(n){if(_f(n=rg(n),19))return d=n,Jl.Jz(d,(Jl.oIb(),Jl.nIb),""),!1;throw og(n)}return n.e&&(xl.dr(n),xl.Qq(n)),0!=(1&n.i)&&(n.f=xl.co(n.j)),xl.Vq(n,F),xl.nu(n.j,15),!0},xl.ir=function(n,t){var e,i,s,a,r;for(n.b&&Fl._Qb(n.b),n.c&&Fl._Qb(n.c),s=0,i=Lf.OEb(t);null!=i&&Jl.DHb(Rl.LTb(i).substr(0,7),_t);){for(i=Jl.SHb((Rl.GTb(7,Rl.LTb(i).length+1),Rl.LTb(i).substr(7)));r=Rl.LTb("-").length,Jl.DHb(Rl.LTb(i).substr(Rl.LTb(i).length-r,r),"-");){if(e=Lf.OEb(t),!Jl.DHb(Rl.LTb(e).substr(0,7),_t))return!1;i=Jl.SHb(Jl.AHb(Jl.RHb(i,0,Rl.LTb(i).length-1),(Rl.GTb(7,Rl.LTb(e).length+1),Rl.LTb(e).substr(7))))}if(Jl.DHb(Rl.LTb(i).substr(0,5),"BEGIN"))if(a=Jl.SHb((Rl.GTb(6,Rl.LTb(i).length+1),Rl.LTb(i).substr(6))),Jl.DHb(Rl.LTb(a).substr(0,4),"CTAB"))s=1;else if(Jl.DHb(Rl.LTb(a).substr(0,4),"ATOM"))s=2;else if(Jl.DHb(Rl.LTb(a).substr(0,4),"BOND"))s=3;else{if(!Jl.DHb(Rl.LTb(a).substr(0,10),"COLLECTION"))return!1;s=4}else if(Jl.DHb(Rl.LTb(i).substr(0,3),"END"))s=0;else if(1==s)xl.br(n,i);else if(2==s)xl.Zq(n,i);else if(3==s)xl._q(n,i);else{if(4!=s)return!1;xl.ar(n,i)}i=Lf.OEb(t)}for(;null!=i&&!Jl.DHb(Rl.LTb(i).substr(0,6),Kt)&&!Jl.DHb(i,Wt);)i=Lf.OEb(t);return!0},xl.jr=function(){this.i=0},xl.kr=function(){this.i=1},zf(111,1,{},xl.jr,xl.kr),o.a=!1,o.d=!1,o.e=!1,o.g=!1,o.i=0,o.k=!1,kl.Slb=lg(111),xl.lr=function(n){},xl.mr=function(t,e,i){var s,a,r,o,l,f,g,u,d,c,h,b,D,j,m,A,C,T,p,I,P,M,w,N,L,U,k,J,y;for(Jl.gIb(t.a,"M  V30 BEGIN CTAB\n"),Jl.gIb(t.a,$t+e.q+" "+e.r+" 0 0 0"+H),Jl.gIb(t.a,"M  V30 BEGIN ATOM\n"),f=0;f<e.q;f++){if(Jl.gIb(t.a,_t+(f+1)),null!=(null==e.v?null:e.v[f])){for(u=null==e.v?null:e.v[f],T=Bg(Cg(e.B[f],1),0),Jl.gIb(t.a,T?" NOT[":" ["),A=0;A<u.length;A++)switch(A>0&&Jl.gIb(t.a,","),C=(xl.Sj(),xl.Mj)[u[A]],Rl.LTb(C).length){case 2:case 3:case 1:Jl.gIb(t.a,C);break;default:Jl.gIb(t.a,"?")}Jl.gIb(t.a,"]")}else Bg(Cg(e.B[f],1),0)?Jl.gIb(t.a," A"):e.C[f]>=129&&e.C[f]<=144||154==e.C[f]?Jl.gIb(t.a," R#"):Jl.gIb(t.a," "+(xl.Sj(),xl.Mj)[e.C[f]]);if(i?(Jl.gIb(t.a," "+ag(B*t.b*e.J[f].a)/B),Jl.gIb(t.a," "+ag(B*t.b*-e.J[f].b)/B),Jl.gIb(t.a," "+ag(B*t.b*-e.J[f].c)/B)):Jl.gIb(t.a," 0 0 0"),Jl.gIb(t.a," "+n.Math.abs(e.w[f])),0!=e.s[f]&&Jl.gIb(t.a," CHG="+e.s[f]),0!=(48&e.u[f]))switch(Jl.gIb(t.a," RAD="),48&e.u[f]){case 16:Jl.gIb(t.a,"1");break;case 32:Jl.gIb(t.a,"2");break;case 48:Jl.gIb(t.a,"3")}1!=(3&e.u[f])&&2!=(3&e.u[f])||(Jl.gIb(t.a," CFG="),1==(3&e.u[f])?Jl.gIb(t.a,"1"):Jl.gIb(t.a,"2")),0!=e.A[f]&&Jl.gIb(t.a," MASS="+e.A[f]),-1!=(y=((e.u[f]&Pt)>>>27)-1)&&Jl.gIb(t.a," VAL="+(0==y?"-1":Jl.UGb(y))),((d=e.C[f])>=129&&d<=144||154==d)&&Jl.gIb(t.a," RGROUPS=(1 "+(154==d?0:d>=142?d-141:d-125)+")"),0==Tg(m=Cg(cn,e.B[f]),384)?Jl.gIb(t.a," HCOUNT=2"):0==Tg(m,128)?Jl.gIb(t.a," HCOUNT=1"):0==Tg(m,1792)?Jl.gIb(t.a," HCOUNT=-1"):0==Tg(m,1664)&&Jl.gIb(t.a," HCOUNT=1"),0!=Tg(U=Cg(e.B[f],6144),0)&&(Bg(Cg(U,fn),0)?Jl.gIb(t.a," SUBST="+(e.e[f]+1)):Jl.gIb(t.a," SUBST=-1")),0!=Tg(w=Cg(e.B[f],120),0)&&(0==Tg(w,112)?Jl.gIb(t.a," RBCNT=-1"):0==Tg(w,8)||0==Tg(w,104)?Jl.gIb(t.a," RBCNT=2"):0==Tg(w,88)?Jl.gIb(t.a," RBCNT=3"):0==Tg(w,56)&&Jl.gIb(t.a," RBCNT=4")),Jl.gIb(t.a,H)}for(Jl.gIb(t.a,"M  V30 END ATOM\n"),Jl.gIb(t.a,"M  V30 BEGIN BOND\n"),h=0;h<e.r;h++){switch(Jl.gIb(t.a,_t+(h+1)),e.H[h]){case 1:default:P=1,L=0;break;case 2:P=2,L=0;break;case 4:P=3,L=0;break;case 129:P=1,L=3;break;case 257:P=1,L=1;break;case 386:P=2,L=2;break;case 64:P=4,L=0;break;case 32:P=9,L=0}0!=(D=31&e.G[h])&&(P=8==D?4:3==D?5:9==D?6:10==D?7:8),Jl.gIb(t.a," "+P+" "+(e.D[0][h]+1)+" "+(e.D[1][h]+1)),0!=L&&Jl.gIb(t.a," CFG="+L),0!=(k=0==(N=384&e.G[h])?0:256==N?1:2)&&Jl.gIb(t.a," TOPO="+k),Jl.gIb(t.a,H)}for(Jl.gIb(t.a,"M  V30 END BOND\n"),M=!1,s=0,p=vf(kl.llb,z,6,32,15,1),r=vf(kl.llb,z,6,32,15,1),g=0;g<e.f;g++)1!=(3&e.u[g])&&2!=(3&e.u[g])||(M=!0,1==(J=(e.u[g]&Vn)>>18)?++r[(e.u[g]&Vn)>>18!=1&&(e.u[g]&Vn)>>18!=2?-1:(e.u[g]&Mt)>>20]:2==J?++p[(e.u[g]&Vn)>>18!=1&&(e.u[g]&Vn)>>18!=2?-1:(e.u[g]&Mt)>>20]:++s);for(a=0,I=vf(kl.llb,z,6,32,15,1),o=vf(kl.llb,z,6,32,15,1),b=0;b<e.g;b++)2==xl.bl(e,b)||1!=(3&e.F[b])&&2!=(3&e.F[b])||(M=!0,1==(J=(768&e.F[b])>>8)?++o[(768&e.F[b])>>8!=1&&(768&e.F[b])>>8!=2?-1:(e.F[b]&wt)>>10]:2==J?++I[(768&e.F[b])>>8!=1&&(768&e.F[b])>>8!=2?-1:(e.F[b]&wt)>>10]:++a);if(M){if(Jl.gIb(t.a,"M  V30 BEGIN COLLECTION\n"),0!=s){for(Jl.gIb(t.a,"M  V30 MDLV30/STEABS ATOMS=("+s),l=0;l<e.f;l++)(1==(3&e.u[l])||2==(3&e.u[l]))&&(e.u[l]&Vn)>>18==0&&Jl.gIb(t.a," "+(l+1));Jl.gIb(t.a,ne)}if(0!=a){for(Jl.gIb(t.a,"M  V30 MDLV30/STEABS BONDS=("+a),c=0;c<e.g;c++)2!=xl.bl(e,c)&&(1==(3&e.F[c])||2==(3&e.F[c]))&&(768&e.F[c])>>8==0&&Jl.gIb(t.a," "+(c+1));Jl.gIb(t.a,ne)}for(j=0;j<32;j++){if(0!=p[j]){for(Jl.gIb(t.a,te+(j+1)+" ATOMS=("+p[j]),l=0;l<e.f;l++)(1==(3&e.u[l])||2==(3&e.u[l]))&&(e.u[l]&Vn)>>18==2&&((e.u[l]&Vn)>>18!=1&&(e.u[l]&Vn)>>18!=2?-1:(e.u[l]&Mt)>>20)==j&&Jl.gIb(t.a," "+(l+1));Jl.gIb(t.a,ne)}if(0!=r[j]){for(Jl.gIb(t.a,ee+(j+1)+" ATOMS=("+r[j]),l=0;l<e.f;l++)(1==(3&e.u[l])||2==(3&e.u[l]))&&(e.u[l]&Vn)>>18==1&&((e.u[l]&Vn)>>18!=1&&(e.u[l]&Vn)>>18!=2?-1:(e.u[l]&Mt)>>20)==j&&Jl.gIb(t.a," "+(l+1));Jl.gIb(t.a,ne)}if(0!=I[j]){for(Jl.gIb(t.a,te+(j+1)+" BONDS=("+I[j]),c=0;c<e.g;c++)2!=xl.bl(e,c)&&(1==(3&e.F[c])||2==(3&e.F[c]))&&(768&e.F[c])>>8==2&&((768&e.F[c])>>8!=1&&(768&e.F[c])>>8!=2?-1:(e.F[c]&wt)>>10)==j&&Jl.gIb(t.a," "+(c+1));Jl.gIb(t.a,ne)}if(0!=o[j]){for(Jl.gIb(t.a,ee+(j+1)+" BONDS=("+o[j]),c=0;c<e.g;c++)2!=xl.bl(e,c)&&(1==(3&e.F[c])||2==(3&e.F[c]))&&(768&e.F[c])>>8==1&&((768&e.F[c])>>8!=1&&(768&e.F[c])>>8!=2?-1:(e.F[c]&wt)>>10)==j&&Jl.gIb(t.a," "+(c+1));Jl.gIb(t.a,ne)}}Jl.gIb(t.a,"M  V30 END COLLECTION\n")}Jl.gIb(t.a,"M  V30 END CTAB\n")},xl.nr=function(){xl.lr(this),this.a=new Jl.kIb},xl.or=function(n){xl.pr.call(this,n)},xl.pr=function(n){xl.qr.call(this,n,new Jl.kIb)},xl.qr=function(n,t){var e,i;xl.lr(this),xl.nu(n,15),this.a=t,i=null!=n.P?n.P:"",Jl.gIb(this.a,i+H),Jl.gIb(this.a,"Actelion Java MolfileCreator 2.0\n\n"),Jl.gIb(this.a,"  0  0  0  0  0  0              0 V3000\n"),this.b=1,(e=xl.sr(n))&&(this.b=xl.rr(n)),xl.mr(this,n,e),Jl.gIb(this.a,Zt)},xl.rr=function(t){var e,i,s,a,r,o,l,f,g;if(g=1,0!=(s=xl.Sk(t,t.q,t.r,(xl.Sj(),xl.Rj))))(s<1||s>3)&&(g=1.5/s);else{for(f=ie,e=1;e<t.q;e++)for(i=0;i<e;i++)f>(a=(r=t.J[i].a-t.J[e].a)*r+(o=t.J[i].b-t.J[e].b)*o+(l=t.J[i].c-t.J[e].c)*l)&&(f=a);g=3/n.Math.max(.75,f)}return g},xl.sr=function(n){var t;if(1==n.q)return!0;for(t=1;t<n.q;t++)if(n.J[t].a!=n.J[0].a||n.J[t].b!=n.J[0].b||n.J[t].c!=n.J[0].c)return!0;return!1},xl.tr=function(n,t){var e;return(e=new xl.nr).b=t,xl.nu(n,15),xl.mr(e,n,!0),e.a.a},zf(136,1,{},xl.nr,xl.or),o.b=1,kl.Tlb=lg(136),xl.wr=function(){xl.wr=Sf,xl.ur=Vf(qf(kl.Oub,2),j,14,0,[Vf(qf(kl.Oub,1),k,2,6,["Acyl","gCaHA`AIf`@"]),Vf(qf(kl.Oub,1),k,2,6,["Alloc","gNph@l@ILzuR@@"]),Vf(qf(kl.Oub,1),k,2,6,["Allyl","Al"]),Vf(qf(kl.Oub,1),k,2,6,["Benzyl;Bn","daD@`F@DjUZxHH@@"]),Vf(qf(kl.Oub,1),k,2,6,["Boc","daxD`@S@AIgijj@@"]),Vf(qf(kl.Oub,1),k,2,6,["BOM;BzOM","deTH`@H@Re[TYj`@@@"]),Vf(qf(kl.Oub,1),k,2,6,["Bs","dmtDpAdLS`aPAIe]jf`@e`@@"]),Vf(qf(kl.Oub,1),k,2,6,["Bt","dew@`@aJ@DiY]paej`@@@"]),Vf(qf(kl.Oub,1),k,2,6,["Btm","did@P@BJ@Die_ahH@@@"]),Vf(qf(kl.Oub,1),k,2,6,["Butyl;nButyl","gJPHB@IRuP@"]),Vf(qf(kl.Oub,1),k,2,6,["Benzoyl;Bz","didH`@p@RYm^Eh@@@@"]),Vf(qf(kl.Oub,1),k,2,6,["Bzh","dg|@`N@LdbRbtJUB]aAP@@@@"]),Vf(qf(kl.Oub,1),k,2,6,["Cbz","dmtD`@S@AIgYVUZh@@@@"]),Vf(qf(kl.Oub,1),k,2,6,["cButyl","gKPHL@IThuT@@"]),Vf(qf(kl.Oub,1),k,2,6,["cHeptyl","daD@`L@DjWVzjj`@"]),Vf(qf(kl.Oub,1),k,2,6,["cHexyl","gOpHL@IToWUU@@"]),Vf(qf(kl.Oub,1),k,2,6,["cOctyl","did@`L@DjWWajjj@@"]),Vf(qf(kl.Oub,1),k,2,6,["cPentyl","gFpHL@ITimUP@"]),Vf(qf(kl.Oub,1),k,2,6,["cPropyl","gBPHL@Qxjh@"]),Vf(qf(kl.Oub,1),k,2,6,["COOH","gC`h@l@ILt@@ !Bb@K~@Hc}"]),Vf(qf(kl.Oub,1),k,2,6,["DEAE","daz@`@x@RiUjj`@"]),Vf(qf(kl.Oub,1),k,2,6,["DEIPS","diD@P@\\B@DjfVjj`@"]),Vf(qf(kl.Oub,1),k,2,6,["DMIPS","gNpD@xD@RjZjh@"]),Vf(qf(kl.Oub,1),k,2,6,["DMPM","dcLD`@kPCIEMDdcttDDT@@"]),Vf(qf(kl.Oub,1),k,2,6,["DMPS","deT@P@\\B@LddTjPsU@@@@"]),Vf(qf(kl.Oub,1),k,2,6,["DMTr","fak@b@@Mt@ISZ{SMjo{NQKfm@AU@@@E@@@@"]),Vf(qf(kl.Oub,1),k,2,6,["DNP","dkmB`hdDt~@HeNfS{HihheCAUhBHX@@"]),Vf(qf(kl.Oub,1),k,2,6,["DNS;Dan","fhi`a@KPP@HH@YIHYheEhYKQgKP@@QP@@@"]),Vf(qf(kl.Oub,1),k,2,6,["DPIPS","fdyAA@H@\\B@FRRIQSQIHzp_Qjh@h@@@@@"]),Vf(qf(kl.Oub,1),k,2,6,["DPTBS","fleAA@H@\\B@FRRIQSRIIWNbEMU@EP@@@@@"]),Vf(qf(kl.Oub,1),k,2,6,["DTBMS","dmT@P@\\B@Djffjjjh@@"]),Vf(qf(kl.Oub,1),k,2,6,["Ethyl","eMBD@ch@"]),Vf(qf(kl.Oub,1),k,2,6,["Fmoc","fde@b@@Hp@IL{LrjxeVCzKUT@@@P@@@"]),Vf(qf(kl.Oub,1),k,2,6,["iAmyl","gGPHJ@YIDZj@@"]),Vf(qf(kl.Oub,1),k,2,6,["iButyl","gJPHB@ITuP@"]),Vf(qf(kl.Oub,1),k,2,6,["Im","gFtHAj@IRnKSP@"]),Vf(qf(kl.Oub,1),k,2,6,["iPropyl","gC`HL@Qz`@"]),Vf(qf(kl.Oub,1),k,2,6,["MDIPS","diD@P@\\B@DjfZjj`@"]),Vf(qf(kl.Oub,1),k,2,6,["MDPS","foA@A@@NA@CIIEEBdeeVLzj@@@@@@"]),Vf(qf(kl.Oub,1),k,2,6,["Methyl","eFBH@c@@"]),Vf(qf(kl.Oub,1),k,2,6,["MEM","gNphAR@IRoUT@@"]),Vf(qf(kl.Oub,1),k,2,6,["Mes","deT@`J@DjY{[`bB`@@"]),Vf(qf(kl.Oub,1),k,2,6,["MMTr","ffcAB@@Z@Dim]ifuWYrI\\uh@Jh@@@@@@"]),Vf(qf(kl.Oub,1),k,2,6,["MOM","gCaHA`AJZ`@"]),Vf(qf(kl.Oub,1),k,2,6,["MPM;PMB","deTH`@d@Rfuunh@J@@"]),Vf(qf(kl.Oub,1),k,2,6,["Ms","gJPdH`DD@cuh@"]),Vf(qf(kl.Oub,1),k,2,6,["MTM","gC`D@DX@Rfh@"]),Vf(qf(kl.Oub,1),k,2,6,["mTolyl","daD@`N@DjWjXHB@@"]),Vf(qf(kl.Oub,1),k,2,6,["N3","gClHaE`@RnReX@"]),Vf(qf(kl.Oub,1),k,2,6,["nAmyl;Amyl","gGPHJ@IRmU@@"]),Vf(qf(kl.Oub,1),k,2,6,["neoAm","gGPHJ@IUMU@@"]),Vf(qf(kl.Oub,1),k,2,6,["NO2,Nitro","gChhhE`BRnRYh@"]),Vf(qf(kl.Oub,1),k,2,6,["Np","deVDaHAI@HeNR[e_aZ@B@@"]),Vf(qf(kl.Oub,1),k,2,6,["nPropyl;Propyl","gC`HL@IST@@"]),Vf(qf(kl.Oub,1),k,2,6,["oTolyl","daD@`J@DjYvxH`@@"]),Vf(qf(kl.Oub,1),k,2,6,["Phenyl","gOpHL@IToVD@@@"]),Vf(qf(kl.Oub,1),k,2,6,["Pht","dcLL`@RU@Dfyed]ZBA`@@"]),Vf(qf(kl.Oub,1),k,2,6,["Piv;Pv","gNqHA`AIffj`@"]),Vf(qf(kl.Oub,1),k,2,6,["PMBM","dcLD`@T`AJUm]FZh@J@@"]),Vf(qf(kl.Oub,1),k,2,6,["PNB","dcNLaHAEt@bTyInUvxV`@f@@"]),Vf(qf(kl.Oub,1),k,2,6,["Poc","didD`@S@AIgexVjj`@"]),Vf(qf(kl.Oub,1),k,2,6,["PPi","diDFsHSB[`|J|A@Lxn{lddqdZih@@"]),Vf(qf(kl.Oub,1),k,2,6,["pTolyl","daD@`N@DjWzXHB@@"]),Vf(qf(kl.Oub,1),k,2,6,["sAmyl","gGPHL@YIDZj@@"]),Vf(qf(kl.Oub,1),k,2,6,["sButyl","gJPHL@ITuP@"]),Vf(qf(kl.Oub,1),k,2,6,["SEM","diDHPFApD@rRQUJjj`@"]),Vf(qf(kl.Oub,1),k,2,6,["SES","dedDpHP@``AgCIICeHmUT@@"]),Vf(qf(kl.Oub,1),k,2,6,["SO3H","gJQdHl@``D^m@@"]),Vf(qf(kl.Oub,1),k,2,6,["tAmyl","gGPHB@IUMU@@"]),Vf(qf(kl.Oub,1),k,2,6,["TBDMS;TBS","dax@P@\\B@Djfjjh@@"]),Vf(qf(kl.Oub,1),k,2,6,["TBDPS","fdy@A@@NA@CIIEEEIde]XOhuPAT@@@@@"]),Vf(qf(kl.Oub,1),k,2,6,["TBMPS","dg\\HPHApH@rRQJJPjg]UAT@@@"]),Vf(qf(kl.Oub,1),k,2,6,["tButyl,tBu","gJPHB@Q}T@@"]),Vf(qf(kl.Oub,1),k,2,6,["TDS","ded@P@\\B@LddTeeUUP@@"]),Vf(qf(kl.Oub,1),k,2,6,["Tf","daxDhHP@``BiAiCiCIICHmU@@"]),Vf(qf(kl.Oub,1),k,2,6,["TFA","gNqBJIARFdF@YEHYUL@@"]),Vf(qf(kl.Oub,1),k,2,6,["Thexyl","gNpHB@IUMUT@@"]),Vf(qf(kl.Oub,1),k,2,6,["THF","gFqH@PAJYujj@@"]),Vf(qf(kl.Oub,1),k,2,6,["THP","gOqH@PAJYZzjh@"]),Vf(qf(kl.Oub,1),k,2,6,["TIPS","dmT@P@\\B@DjfYjjjh@@"]),Vf(qf(kl.Oub,1),k,2,6,["TMS","gJPD@xD@czh@"]),Vf(qf(kl.Oub,1),k,2,6,["Tosyl;Ts","dmtDPHP@``CIICLeaeZ@B@@"]),Vf(qf(kl.Oub,1),k,2,6,["Troc","diDDHJxHaHcH`PCHiBeJjf@@"]),Vf(qf(kl.Oub,1),k,2,6,["Trt","fbm@B@A@FRQIRKQPiIZdoIcdHJ`@@@@@@"]),Vf(qf(kl.Oub,1),k,2,6,["Xyl","did@`J@DjYynBHH@@"])])},xl.xr=function(){var n,t,e,i,s,a,r,o;for(xl.wr(),xl.vr=new Fl.oRb,r=0,o=(a=xl.ur).length;r<o;++r)for(s=a[r],e=0,i=(t=Jl.OHb(s[0],";")).length;e<i;++e)n=t[e],Fl.gRb(xl.vr,Jl.MHb(Rl.LTb(n).toLowerCase(),"-"),s[1])},xl.yr=function(n){var t,e,i;for(xl.wr(),!xl.vr&&xl.xr(),n=Jl.MHb(Rl.LTb(n).toLowerCase(),"-"),t=new Fl.yRb(new Fl.DRb(new Fl.zNb(xl.vr).a).b),i=new Fl.HNb(t);Fl.hMb(i.a.a);)if(e=Fl.wRb(i.a).Wd(),Jl.DHb(Rl.LTb(e).substr(0,Rl.LTb(n).length),n))return!0;return!1},xl.vr=null,xl.zr=function(n){var t,e;for(e=0,t=0;t<n.a.q;t++)(7==xl.Qk(n.a,t)||8==xl.Qk(n.a,t))&&++e;return e},xl.Ar=function(n){var t,e;for(e=0,t=0;t<n.a.q;t++)(7==xl.Qk(n.a,t)||8==xl.Qk(n.a,t))&&xl.Fn(n.a,t)>0&&++e;return e},xl.Br=function(n){var t;try{return Zl.cE((new Zl.eE,n.a))}catch(n){if(_f(n=rg(n),19))return t=n,Jl.Jz(t,(Jl.oIb(),Jl.nIb),""),-999;throw og(n)}},xl.Cr=function(n){this.a=n,xl.$o(n)},zf(341,1,{}),kl.Ulb=lg(341),xl.Dr=function(n,t,e){var i,s,a,r,o,l,f,g,u,d,c,h;for(f=n.g.M,g=0,a=0;a<e;a++)f>t[a]&&(f=t[a],g=a);for(h=vf(kl.llb,z,6,e,15,1),u=g<e-1?g+1:0,o=t[g>0?g-1:e-1]<t[u],r=0;r<e;r++)h[r]=t[g],o?--g<0&&(g=e-1):++g==e&&(g=0);for(s=0;s<n.i.a.length;s++)if((c=Fl.Xi(n.i,s)).length==e){for(i=!0,l=0;l<e;l++)if(c[l]!=h[l]){i=!1;break}if(i)return}Fl.Si(n.i,h),d=xl.Pr(n,h),Fl.Si(n.j,d),xl.es(n,h,d)},xl.Er=function(n,t,e){var i,s,a,r,o,l,f;for(l=vf(kl.llb,z,6,n.f,15,1),r=vf(kl.llb,z,6,n.f,15,1),f=vf(kl.Cwb,nn,6,n.g.f,16,1),i=xl.Vk(n.g,0,t),s=xl.Vk(n.g,1,t),l[0]=i,l[1]=s,r[1]=-1,f[s]=!0,o=1;o>=1;)if(++r[o],r[o]!=xl.Sn(n.g,l[o])){if(!f[a=xl.Rn(n.g,l[o],r[o])]&&!e[a])if(a==i&&o>1){if(xl.Dr(n,l,o+1),n.i.a.length>=hn)return}else o+1<n.f&&(l[++o]=a,f[a]=!0,r[o]=-1)}else f[l[o]]=!1,--o},xl.Fr=function(n,t,e,i,s,a,r,o){var l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I,P,M;for(d=0,c=(u=p=Fl.Xi(n.i,t)).length;d<c;++d)if(g=u[d],!xl.as(n,g))return!0;for(P=(I=Fl.Xi(n.j,t)).length,h=0,f=0,M=!1,C=0;C<P;C++)h<<=1,f<<=1,xl.cs(n,I[C])?h|=1:o&&xl._r(n,I[C])?(h|=1,f|=1):-1!=(l=e[t][C])&&(i[l]?s[l]&&(h|=1,a[l]||(f|=1)):M=!0);switch(A=!1,P){case 3:for(b=Vf(qf(kl.llb,1),z,6,15,[2,1,4]),A=!0,m=0;m<3;m++)(h&b[m])==b[m]&&(6==xl.Qk(n.g,p[m])&&1==xl.zk(n.g,p[m])||5==xl.Qk(n.g,p[m])&&0==xl.zk(n.g,p[m]))&&(s[t]=!0,r[t]=m,0==(f&b[m])&&(A=!1));break;case 5:for(D=Vf(qf(kl.llb,1),z,6,15,[10,5,18,9,20]),A=!0,T=0;T<5;T++)if((h&D[T])==D[T])switch(xl.Qk(n.g,p[T])){case 6:-1==xl.zk(n.g,p[T])&&(s[t]=!0,r[t]=T,0==(f&D[T])&&(A=!1));break;case 7:xl.zk(n.g,p[T])<=0&&(s[t]=!0,r[t]=T);break;case 8:s[t]=!0,r[t]=T;break;case 16:case 34:case 52:2==xl.Sn(n.g,p[T])&&(s[t]=!0,r[t]=T)}break;case 6:A=!0,21==(21&h)&&(s[t]=!0,0==(21&f)&&(A=!1)),42==(42&h)&&(s[t]=!0,0==(42&f)&&(A=!1));break;case 7:for(H=Vf(qf(kl.llb,1),z,6,15,[42,21,74,37,82,41,84]),A=!0,j=0;j<7;j++)(h&H[j])==H[j]&&(6==xl.Qk(n.g,p[j])&&(1==xl.zk(n.g,p[j])||o&&xl.Sr(n,p[j]))||5==xl.Qk(n.g,p[j])&&0==xl.zk(n.g,p[j]))&&(s[t]=!0,r[t]=j,0==(f&H[j])&&(A=!1))}return s[t]&&!A&&(a[t]=!0),!!s[t]||!M},xl.Gr=function(n,t,e,i,s){var a,r,o,l,f,g,u,d,c,h,b,D;for(a=vf(kl.llb,ot,8,n.i.a.length,0,2),f=0;f<n.i.a.length;f++)for(a[f]=vf(kl.llb,z,6,Fl.Xi(n.i,f).length,15,1),g=0;g<Fl.Xi(n.i,f).length;g++)a[f][g]=-1;for(b=vf(kl.llb,z,6,n.g.g,15,1),c=0;c<n.j.a.length;c++)if(3==(h=Fl.Xi(n.j,c)).length||h.length>=5&&h.length<=7)for(l=0;l<h.length;l++)o=h[l],3==xl.Sn(n.g,xl.Vk(n.g,0,o))&&3==xl.Sn(n.g,xl.Vk(n.g,1,o))&&(b[o]>0?(a[b[o]>>>16][32767&b[o]]=c,a[c][l]=b[o]>>>16):b[o]=(c<<16)+kt+l);for(r=vf(kl.Cwb,nn,6,n.i.a.length,16,1),D=0,u=-1;D>u;)for(u=D,d=0;d<n.i.a.length;d++)r[d]||xl.Fr(n,d,a,r,t,e,i,s)&&(r[d]=!0,++D)},xl.Hr=function(n,t,e){var i,s,a,r,o,l,f,g,u,d,c,h;for(s=xl.Vk(n.g,0,t),a=xl.Vk(n.g,1,t),l=vf(kl.llb,z,6,n.g.f,15,1),f=vf(kl.llb,z,6,n.g.f,15,1),g=vf(kl.llb,z,6,n.g.f,15,1),l[0]=s,l[1]=a,f[s]=1,f[a]=2,g[s]=-1,g[a]=s,o=1,u=1;o<=u;){for(d=0;d<xl.Sn(n.g,l[o]);d++){if(r=xl.Rn(n.g,l[o],d),o>1&&r==s){for(h=vf(kl.llb,z,6,f[l[o]],15,1),i=l[o],c=0;c<h.length;c++)h[c]=i,i=g[i];return h}0!=f[r]||e[r]||(l[++u]=r,f[r]=f[l[o]]+1,g[r]=l[o])}++o}return null},xl.Ir=function(n,t,e){var i,s;for(s=Fl.Xi(n.i,t),i=0;i<s.length;i++)if(e==s[i])return i;return-1},xl.Jr=function(n,t){return n.a[t]&y},xl.Kr=function(n,t,e){var i,s;for(s=Fl.Xi(n.j,t),i=0;i<s.length;i++)if(e==s[i])return i;return-1},xl.Lr=function(n,t){return n.b[t]&y},xl.Mr=function(n,t){return n.c[t]},xl.Nr=function(n,t){return Fl.Xi(n.i,t)},xl.Or=function(n,t){return Fl.Xi(n.j,t)},xl.Pr=function(n,t){var e,i,s,a,r;for(a=t.length,r=vf(kl.llb,z,6,a,15,1),i=0;i<a;i++)for(e=i==a-1?t[0]:t[i+1],s=0;s<xl.Sn(n.g,t[i]);s++)if(xl.Rn(n.g,t[i],s)==e){r[i]=xl.Tn(n.g,t[i],s);break}return r},xl.Qr=function(n,t){return Fl.Xi(n.j,t).length},xl.Rr=function(n,t,e){var i;for(i=0;i<n.j.a.length;i++)if(xl.Xr(n,i,t)&&xl.Xr(n,i,e))return i;return-1},xl.Sr=function(n,t){var e;for(e=0;e<xl.Sn(n.g,t);e++)if(2==xl.Un(n.g,t,e)&&8==xl.Qk(n.g,xl.Rn(n.g,t,e)))return!0;return!1},xl.Tr=function(n,t){return n.d[t]},xl.Ur=function(n,t){return 0!=(n.a[t]&J)},xl.Vr=function(n,t){return 0!=(n.b[t]&J)},xl.Wr=function(n,t,e){var i,s;for(s=Fl.Xi(n.i,t),i=0;i<s.length;i++)if(e==s[i])return!0;return!1},xl.Xr=function(n,t,e){var i,s;for(s=Fl.Xi(n.j,t),i=0;i<s.length;i++)if(e==s[i])return!0;return!1},xl.Yr=function(n,t){return n.e[t]},xl.Zr=function(n,t){return 0!=(n.b[t]&gt)},xl.$r=function(n,t){return 0!=(n.a[t]&Wn)},xl._r=function(n,t){var e,i,s,a,r,o;for(r=0;r<2;r++)if(e=xl.Vk(n.g,r,t),7==xl.Qk(n.g,e)&&2==xl.Sn(n.g,e)&&(i=xl.Vk(n.g,1-r,t),6==xl.Qk(n.g,i)))for(o=0;o<xl.Sn(n.g,i);o++)if(s=xl.Rn(n.g,i,o),a=xl.Tn(n.g,i,o),(8==xl.Qk(n.g,s)||16==xl.Qk(n.g,s))&&2==xl.bl(n.g,a)&&1==xl.Sn(n.g,s))return!0;return!1},xl.as=function(n,t){var e,i,s,a,r;if(n.g.K){if(Bg(Cg(xl.Lk(n.g,t),1),0))return!0;if(null!=(r=xl.Gk(n.g,t))){for(s=0,a=(i=r).length;s<a;++s)if(5==(e=i[s])||6==e||7==e||8==e||15==e||16==e||33==e||34==e)return!0;return!1}}return xl.is(xl.Qk(n.g,t))},xl.bs=function(n,t){var e,i,s,a,r;if(n.g.K){if(Bg(Cg(xl.Lk(n.g,t),1),0))return!1;if(null!=(e=xl.Gk(n.g,t))){for(a=0,r=(s=e).length;a<r;++a)if(i=s[a],!xl.jn(i))return!1;return!0}}return xl.jn(xl.Qk(n.g,t))},xl.cs=function(n,t){return xl.bl(n.g,t)>1||64==xl.el(n.g,t)},xl.ds=function(n){var t,e,i,s,a,r,o,l,f,g,u,d,c,h,b,D;for(D=0;D<n.d.length;D++)if(n.d[D]){for(b=!1,a=0,o=(i=Fl.Xi(n.i,D)).length;a<o;++a)t=i[a],n.a[t]|=J,xl.bs(n,t)&&(b=!0);for(d=0,h=(g=Fl.Xi(n.j,D)).length;d<h;++d)l=g[d],n.b[l]|=J;if(n.e[D]){for(s=0,r=(e=Fl.Xi(n.i,D)).length;s<r;++s)t=e[s],n.a[t]|=gt;for(u=0,c=(f=Fl.Xi(n.j,D)).length;u<c;++u)l=f[u],n.b[l]|=gt}if(b){for(s=0,r=(e=Fl.Xi(n.i,D)).length;s<r;++s)t=e[s],n.a[t]|=Wn;for(u=0,c=(f=Fl.Xi(n.j,D)).length;u<c;++u)l=f[u],n.b[l]|=Wn}}},xl.es=function(n,t,e){var i,s,a,r;for(r=t.length,a=0;a<r;a++)(0==(i=n.a[t[a]]&y)||i>r)&&(n.a[t[a]]&=$n,n.a[t[a]]|=r);for(s=0;s<r;s++)(0==(i=n.b[e[s]]&y)||i>r)&&(n.b[e[s]]&=$n,n.b[e[s]]|=r)},xl.fs=function(n,t,e){var i;for(i=Fl.Xi(n.j,t).length;e>=i;)e-=i;for(;e<0;)e+=i;return e},xl.gs=function(n,t){xl.hs.call(this,n,t)},xl.hs=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j;this.g=n,this.f=7,this.i=new Fl.kj,this.j=new Fl.kj,this.a=vf(kl.llb,z,6,this.g.f,15,1),this.b=vf(kl.llb,z,6,this.g.g,15,1),this.g.Mb(1),d=vf(kl.Cwb,nn,6,this.g.f,16,1),c=vf(kl.Cwb,nn,6,this.g.g,16,1);do{for(r=!1,e=0;e<this.g.f;e++)if(!d[e]){for(D=0,u=0;u<xl.Sn(this.g,e);u++)d[xl.Rn(this.g,e,u)]||++D;if(D<2){for(d[e]=!0,g=0;g<xl.Sn(this.g,e);g++)c[xl.Tn(this.g,e,g)]=!0;r=!0}}}while(r);for(j=0;j<this.g.f&&d[j];)++j;if(j!=this.g.f){for((l=vf(kl.llb,z,6,this.g.f,15,1))[0]=j,(b=vf(kl.llb,z,6,this.g.f,15,1))[0]=-1,(o=vf(kl.llb,z,6,this.g.f,15,1))[j]=1,a=0,f=0,h=1;a<=f;){for(g=0;g<xl.Sn(this.g,l[a]);g++)(s=xl.Rn(this.g,l[a],g))!=b[l[a]]&&(0==o[s]?d[s]||(o[s]=h,b[s]=l[a],l[++f]=s):xl.Er(this,xl.Tn(this.g,l[a],g),d));if(++a>f)for(e=0;e<this.g.f;e++)if(0==o[e]&&!d[e]){o[e]=++h,l[++f]=e,b[e]=-1;break}}if(0!=(4&t)&&(this.d=vf(kl.Cwb,nn,6,this.i.a.length,16,1),this.e=vf(kl.Cwb,nn,6,this.i.a.length,16,1),this.c=vf(kl.llb,z,6,this.i.a.length,15,1),xl.Gr(this,this.d,this.e,this.c,0!=(8&t)),xl.ds(this)),0!=(2&t))for(i=0;i<this.g.g;i++)c[i]||0==xl.bl(this.g,i)||null!=(H=xl.Hr(this,i,d))&&xl.es(this,H,xl.Pr(this,H))}},xl.is=function(n){return 5==n||6==n||7==n||8==n||15==n||16==n||33==n||34==n},zf(169,1,{},xl.gs),o.f=0,kl.Vlb=lg(169),xl.js=function(n,t){var e,i,s,a,r,o,l,f,g,u;if(2==t||5==t)Fl.Si(n.D,xl.Os(n.F,n.F.length)),n.b&&Fl.Si(n.a,xl.Ps(n.B,n.B.length));else if(4==t)u=xl.vs(xl.Os(n.F,n.F.length)),Fl.aSb(n.N,u)||(Fl.$Rb(n.N,u),Fl.Si(n.D,xl.Os(n.F,n.F.length)),n.b&&Fl.Si(n.a,xl.Ps(n.B,n.B.length)));else if(3==t){if(u=xl.vs(xl.Os(n.F,n.F.length)),!Fl.aSb(n.N,u)){for(g=!1,r=new Fl.yRb(new Fl.DRb(new Fl.zNb(n.N.a).a).b),l=new Fl.HNb(r);Fl.hMb(l.a.a);){for(o=Fl.wRb(l.a).Wd(),f=0,s=0,a=(i=u).length;s<a;++s){for(e=i[s];f<o.length&&o[f]<e;)++f;if(f<o.length&&e==o[f]){g=!0;break}}if(g)break}g||(Fl.$Rb(n.N,u),Fl.Si(n.D,xl.Os(n.F,n.F.length)),n.b&&Fl.Si(n.a,xl.Ps(n.B,n.B.length)))}}else 6==t&&(u=xl.ws(n,xl.Os(n.F,n.F.length)),Fl.aSb(n.N,u)||(Fl.$Rb(n.N,u),Fl.Si(n.D,xl.Os(n.F,n.F.length)),n.b&&Fl.Si(n.a,xl.Ps(n.B,n.B.length))))},xl.ks=function(n,t,e){var i,s,a,r,o,l,f,g,u;if(o=xl.Sn(n.G,t),(i=n.n[e])>o)return!1;if(f=xl.Lk(n.G,t),a=xl.Lk(n.g,e),s=xl.Gk(n.g,e),l=xl.Gk(n.G,t),Bg(Cg(a,1),0)){if(null!=s)if(Bg(Cg(f,1),0)){if(null==l)return!1;if(!xl.Bs(s,l))return!1}else if(null!=l){if(xl.Ds(l,s))return!1}else if(xl.As(xl.Qk(n.G,t),s))return!1}else{if(Bg(Cg(f,1),0))return!1;if(null!=s){if(null!=l){if(!xl.Bs(l,s))return!1}else if(!xl.As(xl.Qk(n.G,t),s))return!1}else{if(null!=l)return!1;if(n.I[t]!=n.j[e])return!1}}if(Bg(Eg(f,a),0)){if(Bg(Cg(a,zn),0)){if(n.G.K&&Ig(Cg(f,zn),0))return!1;if(i!=o)return!1}if(Bg(Cg(a,fn),0)&&i>=o&&Ig(Cg(f,fn),0))return!1}if(Bg(Cg(n.H[t],Rg(n.i[e])),0))return!1;if(Bg(Cg(n.A[e],Rg(n.L[t])),0))return!1;if(r=Cg(a,v),n.G.K){if(0!=Tg(g=Cg(a,v),0)&&(0==Tg(r,0)||Bg(Cg(r,Rg(g)),0)))return!1}else if(0!=Tg(r,0)&&Ig(Cg(r,n.L[t]),0))return!1;if(0!=xl.zk(n.g,e)&&xl.zk(n.g,e)!=xl.zk(n.G,t))return!1;if(0!=xl.Jk(n.g,e)&&xl.Jk(n.g,e)!=xl.Jk(n.G,t))return!1;if(0!=xl.Mk(n.g,e)&&xl.Mk(n.g,e)!=xl.Mk(n.G,t))return!1;if(0!=(u=zg(Fg(Cg(xl.Lk(n.g,e),Qn),22))))if(n.G.K){if(u!=zg(Fg(Cg(xl.Lk(n.G,t),Qn),22)))return!1}else if(xl.Mn(n.G,t)!=u)return!1;return!0},xl.ls=function(n,t,e){var i,s,a,r,o,l,f,g,u;if(f=n.J[t],r=n.k[e],0!=(xl.dl(n.g,e)&Dt)){if(l=xl.fl(n.G,t),s=xl.fl(n.g,e),a=31&xl.dl(n.g,e),!(l==s||1==l&&0!=(1&a)||2==l&&0!=(2&a)||4==l&&0!=(4&a)||8==l&&0!=(32&a)||16==l&&0!=(64&a)||32==l&&0!=(16&a)||64==l&&0!=(8&a)))return!1;f&=-32,r&=-32}if(0!=(f&~r))return!1;if(0!=(u=(xl.dl(n.g,e)&wn)>>17)){if(n.G.K&&u==(xl.dl(n.G,e)&wn)>>17)return!0;for(i=!1,g=xl.so(n.G),o=0;o<g.i.a.length;o++)if(Fl.Xi(g.j,o).length==u&&xl.Xr(g,o,t)){i=!0;break}if(!i)return!1}return!0},xl.ms=function(n){var t,e;for(n.b=null,t=0;t<n.g.g;t++)xl.xl(n.g,t)&&(!n.b&&(n.b=new Fl.kj),(e=new xl.Qs).a=xl.Vk(n.g,0,t),e.b=xl.Vk(n.g,1,t),e.d=xl.Xk(n.g,t),e.c=xl.Wk(n.g,t),Fl.Si(n.b,e))},xl.ns=function(t){var e,i,s,a,r,o,l,f,g,u,d,c;for(xl.nu(t.g,t.M),f=n.Math.max(t.g.f,t.g.g)+16,t.r=vf(kl.llb,z,6,f,15,1),t.t=vf(kl.llb,z,6,f,15,1),t.u=vf(kl.llb,z,6,f,15,1),t.s=vf(kl.Cwb,nn,6,f+1,16,1),o=vf(kl.Cwb,nn,6,t.g.f,16,1),l=vf(kl.Cwb,nn,6,t.g.g,16,1),s=0,i=0;i<t.g.f;i++)if(!t.C[i]&&!o[i])for(t.r[s]=i,t.u[s]=-1,t.t[s]=-1,g=s;s<=g;){for(u=0;u<xl.En(t.g,t.r[s]);u++)g=xl.Ls(t,s,g,u,o,l,-1);for(;t.s[++s];);}if(t.v=s,0!=t.o){for(g=t.v-1,r=0;r<t.d;r++)for(s=0;s<=g;){for(d=0;d<xl.En(t.g,t.r[s]);d++)g=xl.Ls(t,s,g,d,o,l,r);for(;t.s[++s];);}for(e=0;e<t.g.f;e++)if(t.C[e]&&!o[e])for(t.r[s]=e,t.u[s]=-1,t.t[s]=-1,g=s;s<=g;){for(d=0;d<xl.En(t.g,t.r[s]);d++)xl.Rn(t.g,t.r[s],d)<t.g.f&&(g=xl.Ls(t,s,g,d,o,l,t.f[e]));for(;t.s[++s];);}for(t.e=vf(kl.llb,z,6,t.d,15,1),c=0;c<t.d;c++)t.e[c]=-1;for(u=t.v;u<s;u++)a=t.f[t.r[u]],-1==t.e[a]&&(t.e[a]=u)}t.w=s},xl.os=function(n,t){var e,i,s,a,r,o,l,f;for(f=xl.so(n.G),o=0;o<f.i.a.length;o++)if(xl.Xr(f,o,t)){for(l=vf(kl.llb,z,6,2,15,1),s=0;s<2;s++)for(l[s]=I,i=xl.Vk(n.G,s,t),a=0;a<xl.Sn(n.G,i);a++)(e=xl.Rn(n.G,i,a))!=xl.Vk(n.G,1-s,t)&&l[s]>e&&(l[s]=e);return r=0,xl.Wr(f,o,l[0])&&++r,xl.Wr(f,o,l[1])&&++r,2==r?2:1==r?1:2}return 0},xl.ps=function(n,t,e){var i,s,a,r,o;if(n.b)for(n.B=vf(kl.Cwb,nn,6,t.length,16,1),s=new Fl.rOb(n.b);s.a<s.c.a.length;)if(i=Fl.qOb(s),null==n.f||-1==e&&-1==n.f[i.a]&&-1==n.f[i.b]||-1!=e&&(n.f[i.a]==e||n.f[i.b]==e)){if(o=vf(kl.llb,z,6,i.c+2,15,1),(a=xl.mo(n.G,o,n.F[i.a],n.F[i.b],i.c+1,t,null)-1)<i.d||a>i.c)return!1;for(r=1;r<=a;r++)n.B[o[r]]=!0}return!0},xl.qs=function(n,t){var e,i,s,a,r,o,l,f;for(s=0;s<n.g.g;s++)if(0!=(xl.dl(n.g,s)&ct)){if(0==(a=xl.cl(n.g,s)))continue;if(e=xl.Vk(n.g,0,s),i=xl.Vk(n.g,1,s),null==n.f||-1==t&&-1==n.f[e]&&-1==n.f[i]||-1!=t&&(n.f[e]==t||n.f[i]==t)){if(r=n.F[e],o=n.F[i],l=xl.Pn(n.G,r,o),0==(f=xl.cl(n.G,l))&&(xl.Yo(n.G,l)&&(f=xl.os(n,l)),0==f))continue;if(3==a)continue;if(3==f)continue;if(xl.xs(n,s)==(a==f))return!1}}return!0},xl.rs=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h;for(r=0,l=0;l<n.g.f;l++)if((null==n.f||n.f[l]==t)&&Bg(Cg(xl.Lk(n.g,l),Xn),0)){if(d=n.F[l],u=xl.Kk(n.g,l),h=xl.Kk(n.G,d),0==u)continue;if(3==u)continue;if(0==h||3==h)return!1;if(1==xl.Ek(n.g,l)){++r;continue}if(1==xl.Ek(n.G,d))return!1;if(2==xl.Ek(n.g,l)){++r;continue}if(2==xl.Ek(n.G,d))return!1;if(xl.Cs(n,l)==(u==h))return!1}if(0!=r){for(s=vf(kl.llb,z,6,r,15,1),a=0,f=0;f<n.g.f;f++)null!=n.f&&n.f[f]!=t||!Bg(Cg(xl.Lk(n.g,f),Xn),0)||0!=(u=xl.Kk(n.g,f))&&3!=u&&(s[a++]=xl.Dk(n.g,f)<<24|xl.Ek(n.g,f)<<22|f);for(Rl.fTb(s,Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[]))),a=0;a<s.length;)for(g=s[a]&Rt,c=n.F[g],e=-4194304&s[a],i=xl.Cs(n,g)^xl.Kk(n.g,g)==xl.Kk(n.G,c),++a;a<s.length&&(-4194304&s[a])==e;a++){if(o=s[a]&Rt,d=n.F[o],xl.Ek(n.G,d)!=xl.Ek(n.G,c)||xl.Dk(n.G,d)!=xl.Dk(n.G,c))return!1;if((xl.Cs(n,o)^xl.Kk(n.g,o)==xl.Kk(n.G,d))!=i)return!1}}return!0},xl.ss=function(n,t,e){var i,s,a,r,o,l,f;if(n.O=!1,n.D=new Fl.kj,n.a=new Fl.kj,Fl._Qb(n.N.a),!n.G||!n.g)return 0;if(n.g.f-n.o>n.G.f||n.g.g-n.p>n.G.g)return 0;if(0==n.g.f)return 0;for(6==t&&(n.M=63),xl.Hs(n,e),i=vf(kl.Cwb,nn,6,n.G.f,16,1),n.F=vf(kl.llb,z,6,n.g.f,15,1),Fl.BOb(n.F),o=vf(kl.llb,z,6,n.w,15,1),Fl.GOb(o,o.length,-1),a=0;!n.O;){if(0!=n.v){if(f=-1==n.t[a]?n.G.f:xl.En(n.G,n.F[n.t[a]]),++o[a],o[a]==f){if(o[a]=-1,0==a)break;--a,n.s[a]||(i[n.F[n.r[a]]]=!1);continue}if(-1==n.t[a])i[o[a]]||xl.ks(n,o[a],n.r[a])&&(n.F[n.r[a]]=o[a],i[o[a]]=!0,++a);else{if(xl.Rn(n.G,n.F[n.t[a]],o[a])>=n.G.f)continue;s=xl.Rn(n.G,n.F[n.t[a]],o[a]),n.s[a]?s==n.F[n.r[a]]&&xl.ls(n,xl.Tn(n.G,n.F[n.t[a]],o[a]),n.u[a])&&++a:i[s]||xl.ks(n,s,n.r[a])&&xl.ls(n,xl.Tn(n.G,n.F[n.t[a]],o[a]),n.u[a])&&(i[s]=!0,n.F[n.r[a]]=s,++a)}}if(a==n.v){if(xl.rs(n,-1)&&xl.qs(n,-1)&&xl.ps(n,i,-1)){for(l=!1,r=0;r<n.d;r++)if(xl.ys(n,i,o,r)){l=!0;break}if(1==t&&!l)return 1;if(!l&&(xl.js(n,t),2==t))return 1}if(0==a)break;--a,n.s[a]||(i[n.F[n.r[a]]]=!1)}}return n.D.a.length},xl.ts=function(n,t){var e,i,s,a,r;if(a=0,n.K){switch(t<n.f&&xl.$r(n.p,t)?a=Eg(a,se):t<n.f&&xl.Ur(n.p,t)&&(a=Eg(a,2)),0!=(r=0==(i=n.u[t]&Et)?0:i==hn?2:i==zn?3:4)&&(a=Eg(a,8),r>2&&(a=Eg(a,16)),r>3&&(a=Eg(a,32))),(e=n.s[t])<0?a=Eg(a,jn):e>0&&(a=Eg(a,Hn)),n.j[t]){case 0:break;case 1:a=Eg(a,gt);break;case 2:a=Eg(a,Mn);break;case 3:a=Eg(a,wn);break;default:a=Eg(a,Nn)}switch(xl.Hn(n,t)){case 0:break;case 1:a=Eg(a,Rn);break;case 2:a=Eg(a,En);break;case 3:a=Eg(a,xn);break;default:a=Eg(a,Fn)}(s=n.o[t])>0&&(a=Eg(a,ln)),s>1&&(a=Eg(a,kt))}else{switch(a=t<n.f&&xl.$r(n.p,t)?Eg(a,se):t<n.f&&xl.Ur(n.p,t)?Eg(a,2):Eg(a,4),a=0!=(n.u[t]&Ut)?Eg(a,gn):Eg(a,un),a=Eg(a,0==(r=0==(i=n.u[t]&Et)?0:i==hn?2:i==zn?3:4)?112:2==r?104:3==r?88:56),0==(e=n.s[t])?a=Eg(a,Dn):e<0?a=Eg(a,jn):e>0&&(a=Eg(a,Hn)),n.e[t]-xl.jo(n,t)+xl.fo(n,t)){case 0:a=Eg(a,1792);break;case 1:a=Eg(a,1664);break;case 2:a=Eg(a,1408);break;default:a=Eg(a,896)}switch(n.j[t]){case 0:a=Eg(a,3932160);break;case 1:a=Eg(a,Cn);break;case 2:a=Eg(a,Tn);break;case 3:a=Eg(a,pn);break;default:a=Eg(a,Nn)}switch(xl.Hn(n,t)){case 0:a=Eg(a,Un);break;case 1:a=Eg(a,kn);break;case 2:a=Eg(a,Jn);break;case 3:a=Eg(a,yn);break;default:a=Eg(a,Fn)}switch(s=n.o[t]){case 0:a=Eg(a,98304);break;case 1:a=Eg(a,81920);break;default:a=Eg(a,49152)}}return a},xl.us=function(n,t){var e;if(e=0,t<n.g&&(xl.Zr(n.p,t)||64==n.H[t])||64==n.H[t])e|=8;else switch(xl.bl(n,t)){case 4:case 0:e|=32;break;case 1:e|=1;break;case 2:e|=2;break;case 3:e|=4;break;case 5:e|=64}return 0!=(64&n.F[t])?e|=256:n.K||(e|=128),t<n.g&&xl.Vr(n.p,t)?e|=Pn:n.K||(e|=ae),e},xl.vs=function(n){var t,e,i,s,a,r,o,l,f,g;for(l=0,a=0,o=(i=n).length;a<o;++a)-1==(t=i[a])&&++l;if(0!=l)for(g=n,n=vf(kl.llb,z,6,g.length-l,15,1),f=0,s=0,r=(e=g).length;s<r;++s)-1!=(t=e[s])&&(n[f++]=t);return Rl.fTb(n,Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[]))),n},xl.ws=function(n,t){var e,i,s,a,r,o,l;for(a=0,i=0,s=(e=t).length;i<s;++i)-1==e[i]&&++a;for(l=vf(kl.llb,z,6,t.length-a,15,1),o=0,r=0;r<t.length;r++)-1!=t[r]&&(l[o]=xl.yu(n.g,r)<<16|xl.yu(n.G,t[r]),++o);return Rl.fTb(l,Rl.LTb(Qf(Fl.ZOb.prototype.Zd,Fl.ZOb,[]))),l},xl.xs=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c;for(a=!1,s=0;s<2;s++)if(e=xl.Vk(n.g,s,t),g=n.F[e],xl.Sn(n.G,g)>2){for(d=xl.Vk(n.g,1-s,t),l=I,o=0;o<xl.Sn(n.g,e);o++)(i=xl.Rn(n.g,e,o))!=d&&l>i&&(l=i);for(c=n.F[d],f=I,r=0;r<xl.Sn(n.G,g);r++)(u=xl.Rn(n.G,g,r))!=c&&f>u&&(f=u);n.F[l]!=f&&(a=!a)}return a},xl.ys=function(n,t,e,i){var s,a,r,o,l,f,g,u;for(l=(o=n.e[i])+1;l<n.w&&n.f[n.r[l]]==i;)++l;for(g=o;g<l;g++)e[g]=-1;for(r=o;;)if(u=-1==n.t[r]?n.G.f:xl.En(n.G,n.F[n.t[r]]),++e[r],e[r]!=u){if(-1==n.t[r])t[e[r]]||xl.ks(n,e[r],n.r[r])&&(n.F[n.r[r]]=e[r],t[e[r]]=!0,++r);else{if(xl.Rn(n.G,n.F[n.t[r]],e[r])>=n.G.f){++e[r];continue}a=xl.Rn(n.G,n.F[n.t[r]],e[r]),n.s[r]?a==n.F[n.r[r]]&&xl.ls(n,xl.Tn(n.G,n.F[n.t[r]],e[r]),n.u[r])&&++r:t[a]||xl.ks(n,a,n.r[r])&&xl.ls(n,xl.Tn(n.G,n.F[n.t[r]],e[r]),n.u[r])&&(t[a]=!0,n.F[n.r[r]]=a,++r)}if(r==l){if(xl.rs(n,i)&&xl.qs(n,i)&&xl.ps(n,t,i)){for(f=o;f<l;f++)n.s[f]||(s=n.r[f],t[n.F[s]]=!1,n.F[s]=-1);return!0}--r,n.s[r]||(t[n.F[n.r[r]]]=!1,n.F[n.r[r]]=-1)}}else{if(e[r]=-1,r==o)break;--r,n.s[r]||(t[n.F[n.r[r]]]=!1,n.F[n.r[r]]=-1)}return!1},xl.zs=function(n){return xl.ss(n,1,n.c)>0},xl.As=function(n,t){var e;for(e=0;e<t.length;e++)if(t[e]==n)return!0;return!1},xl.Bs=function(n,t){var e,i,s;for(s=0,i=0;i<n.length;i++){for(e=n[i];t[s]<e;)if(++s==t.length)return!1;if(t[s]>e)return!1}return!0},xl.Cs=function(n,t){var e,i,s,a,r,o,l,f;if(r=!1,0==xl.In(n.g,t))for(a=1;a<xl.Sn(n.g,t);a++)for(o=0;o<a;o++)i=xl.Rn(n.g,t,a),s=xl.Rn(n.g,t,o),n.F[i]>n.F[s]^i>s&&(r=!r);else for(a=0;a<xl.Sn(n.g,t);a++){for(e=xl.Rn(n.g,t,a),f=0,l=vf(kl.llb,z,6,3,15,1),o=0;o<xl.Sn(n.g,e);o++)l[f]=xl.Rn(n.g,e,o),l[f]!=t&&++f;2==f&&n.F[l[0]]>n.F[l[1]]^l[0]>l[1]&&(r=!r)}return r},xl.Ds=function(n,t){var e,i,s,a;for(s=0,a=0;s<n.length&&a<t.length;){if((e=n[s])==(i=t[a]))return!0;e<i?++s:++a}return!1},xl.Es=function(n,t){var e,i,s,a,r;if(t&&0!=t.q&&t.K){for(n.g=t,n.q=!1,xl.nu(n.g,1),n.M=7,i=0;i<n.g.f;i++)Bg(Cg(xl.Lk(n.g,i),{l:Xn,m:0,h:3}),0)&&(n.M=15);for(r=0;r<n.g.g;r++)0!=(xl.dl(n.g,r)&ct)&&(n.M=15);for(n.K&&7!=n.M&&xl.nu(n.G,n.M),n.o=0,n.p=0,n.C=vf(kl.Cwb,nn,6,n.g.f,16,1),s=0;s<n.g.f;s++)n.C[s]=Bg(Cg(xl.Lk(n.g,s),tn),0),n.C[s]&&++n.o;if(n.d=0,n.f=null,0!=n.o){if(0!=n.o)for(a=0;a<n.g.g;a++)(n.C[xl.Vk(n.g,0,a)]||n.C[xl.Vk(n.g,1,a)])&&++n.p;for(e=0;e<n.g.q;e++)xl.lm(n.g,e,n.C[e]);n.f=vf(kl.llb,z,6,n.g.q,15,1),n.d=xl.$n(n.g,n.f,!0,!1)}}else n.g=null},xl.Fs=function(n,t,e){xl.Gs(n,e),xl.Es(n,t)},xl.Gs=function(n,t){t&&0!=t.q?(n.G=t,n.K=!1,xl.nu(n.G,1)):n.G=null},xl.Hs=function(n,t){n.K||(xl.Ks(n,t),n.K=!0),n.q||(xl.Is(n,t),xl.ns(n),xl.ms(n),n.q=!0)},xl.Is=function(n,t){var e,i,s,a,r,o,l,f,g,u;for(a=null,l=null,r=null,xl.nu(n.g,n.M),n.n=vf(kl.llb,z,6,n.g.f,15,1),i=0;i<n.g.f;i++)n.n[i]=xl.Sn(n.g,i);if(0!=n.o){for(f=new xl.Gu(n.g.q,n.g.r),u=vf(kl.Cwb,nn,6,n.g.q,16,1),s=0;s<n.g.q;s++)u[s]=!n.C[s];for(xl.un(n.g,f,u,!0,null),xl.nu(f,n.M),xl.Js(n,f,t),a=n.i,l=n.k,r=n.j,g=0,e=0;e<n.g.f;e++)n.C[e]||(n.n[e]=xl.Sn(f,g++))}if(xl.Js(n,n.g,t),0!=n.o){for(g=0,e=0;e<n.g.q;e++)n.C[e]||(n.i[e]=a[g],n.j[e]=r[g++]);for(g=0,o=0;o<n.g.r;o++)!n.C[xl.Vk(n.g,0,o)]&&!n.C[xl.Vk(n.g,1,o)]&&(n.k[o]=l[g++])}},xl.Js=function(n,t,e){var i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j;for(b=t.f,n.i=vf(kl.mlb,st,6,t.f,14,1),n.j=vf(kl.llb,z,6,t.f,15,1),o=0;o<b;o++)n.i[o]=qg(Cg(Eg(xl.ts(t,o),t.B[o]),re),oe),n.j[o]=t.C[o],0!=(1&e)&&(n.j[o]+=t.s[o]+16<<8),0!=(2&e)&&(n.j[o]+=t.A[o]<<16);for(n.A=vf(kl.mlb,st,6,t.f,14,1),xl.nu(t,7),H=t.p,h=0;h<H.i.a.length;h++){for(c=!1,g=0,u=(f=Fl.Xi(H.j,h)).length;g<u;++g)if(d=f[g],0!=(t.G[d]&qn)){c=!0;break}if(!c)for(j=Fl.Xi(H.j,h).length,a=0,r=(s=Fl.Xi(H.i,h)).length;a<r;++a)i=s[a],3==j?n.A[i]=Eg(n.A[i],O):4==j?n.A[i]=Eg(n.A[i],V):5==j?n.A[i]=Eg(n.A[i],K):6==j?n.A[i]=Eg(n.A[i],W):7==j&&(n.A[i]=Eg(n.A[i],_))}for(D=t.g,n.k=vf(kl.llb,z,6,t.g,15,1),l=0;l<D;l++)n.k[l]=6291967&(xl.us(t,l)|t.G[l])^6291840,0!=(4&e)?0!=(2&n.k[l])&&(n.k[l]|=8):0!=(8&e)&&0!=(2&n.k[l])&&l<t.g&&xl.Vr(t.p,l)&&(n.k[l]|=8)},xl.Ks=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c;for(xl.nu(n.G,n.M),g=n.G.f,n.I=vf(kl.llb,z,6,g,15,1),n.H=vf(kl.mlb,st,6,g,14,1),r=0;r<g;r++)n.H[r]=qg(Cg(Eg(xl.ts(n.G,r),xl.Lk(n.G,r)),re),oe),n.I[r]=xl.Qk(n.G,r),0!=(1&t)&&(n.I[r]+=xl.zk(n.G,r)+16<<8),0!=(2&t)&&(n.I[r]+=xl.Jk(n.G,r)<<16);for(n.L=vf(kl.mlb,st,6,g,14,1),d=xl.so(n.G),f=0;f<d.i.a.length;f++)for(c=Fl.Xi(d.j,f).length,s=0,a=(i=Fl.Xi(d.i,f)).length;s<a;++s)o=i[s],3==c?n.L[o]=Eg(n.L[o],O):4==c?n.L[o]=Eg(n.L[o],V):5==c?n.L[o]=Eg(n.L[o],K):6==c?n.L[o]=Eg(n.L[o],W):7==c&&(n.L[o]=Eg(n.L[o],_));for(e=0;e<g;e++)0==(c=xl.Mn(n.G,e))?n.L[e]=Eg(n.L[e],Z):c>7&&(n.L[e]=Eg(n.L[e],$));for(u=n.G.g,n.J=vf(kl.llb,z,6,u,15,1),l=0;l<u;l++)n.J[l]=6422527&(xl.us(n.G,l)|xl.dl(n.G,l))^6291840},xl.Ls=function(n,t,e,i,s,a,r){var o,l;return o=xl.Rn(n.g,n.r[t],i),n.C[o]&&n.f[o]!=r||o==n.t[t]||a[l=xl.Tn(n.g,n.r[t],i)]||xl.xl(n.g,l)||(n.r[++e]=o,n.t[e]=n.r[t],n.u[e]=l,a[l]=!0,s[o]?n.s[e]=!0:s[o]=!0),e},xl.Ms=function(){this.c=8,this.N=new Fl.eSb(new gf.w6)},xl.Ns=function(){this.c=1,this.N=new Fl.eSb(new gf.w6)},xl.Os=function(t,e){var i;return i=vf(kl.llb,z,6,e,15,1),Jl.pIb(t,0,i,0,n.Math.min(t.length,e)),i},xl.Ps=function(t,e){var i;return i=vf(kl.Cwb,nn,6,e,16,1),Jl.pIb(t,0,i,0,n.Math.min(t.length,e)),i},zf(91,1,{},xl.Ms,xl.Ns),o.c=0,o.d=0,o.o=0,o.p=0,o.q=!1,o.v=0,o.w=0,o.K=!1,o.M=0,o.O=!1,kl.Ylb=lg(91),xl.Qs=function(){},zf(250,1,{250:1},xl.Qs),o.a=0,o.b=0,o.c=0,o.d=0,kl.Wlb=lg(250),xl.Ts=function(){xl.Ts=Sf,xl.Rs=Vf(qf(kl.Oub,1),k,2,6,["QM@HzAmdqjF@","RF@Q``","qC`@ISTAlQE`","`J@H","QM@HzAmdqbF@","qC`@ISTAlQEhqPp@","sJP@DiZhAmQEb","RF@QPvR@","QM@HzA@","qC`@ISTAlQEhpPp@","qC`@Qz`MbHl","sJP@DiZhAmQEcFZF@","RFPDXH","qC`@IVtAlQE`","QM@HvAmdqfF@","sGP@DiVj`FsDVM@","`L@H","sJP@DizhAmQEcFBF@","sJP@DjvhAmQEb","sFp@DiTt@@AlqEcP","sGP@LdbMU@MfHlZ","QMHAIhD","QM@HzAy@","sJP@DkVhAmQEb","sNp@DiUjj@[\\QXu`","sJP@DiZhAmQEcFBF@","sGP@DjVj`FsDVM@","RFPDTH","RG@DXOH@","sGP@Divj`FsDVMcAC@","sGP@Dj}j`FsDVM@","qC`@Qz`MbHmFRF@","sNp@LdbJjj@[\\QXu`","QMHAIhGe@","QM@HzAyd`","QM`AIhD","qC`@ISTA@","sGP@DkUj`FsDVM@","qC`@IVtAlQEhqPp@","sNp@DiUjj@[\\QXuqea`@","KAx@@IRjuUPAlHPfES\\","QM`BN`P","sJP@DjZhAmQEcFJF@","Hid@@DjU^nBBH@FtaBXUMp`","sNp@Diujj@[\\QXuq`a`@","sJP@DjvhAmQEcFZF@","sJP@DjZhAmQEcFFF@","sOp@DjWkB@@FwDVM\\YhX@","sNp@Dj}Zj@[\\QXu`","sNp@DiWjj@[\\QXuq`a`@","sOp@DjWkB@@D","KAx@@ITouUPAlHPfES\\","KAx@@YIDTjjh@vDHSBin@","sNp@DkUZj@[\\QXu`","RFPDXOH@","QM`BN`^L`","qC`@ISTAy@","sGP@LdbMU@MfHl[FVF@","qCb@AIZ`H","KAx@@IRjuUPAlHPfES]FFa`@","KAx@@ITnuUPAlHPfES\\","HiD@@DiUVjj`AmHPfES\\H","sNp@DjUjj@[\\QXu`","sJP@DkVhAmQEcFJF@","sGP@DjVj`FsDVMcCC@","qC`@Qz`MbHmFBF@","sJP@DkfhAmQEb","qC`@IVtAlQEhsPp@","sGP@Djuj`FsDVM@","sGP@Dj}j`FsDVMcMC@","sJP@DiZhA@","KAx@@ISjuUPAlHPfES]F@a`@","sJP@DjZhAmQEcFRF@","KAx@@IRnuUPAlHPfES]F@a`@","HiD@@DjWvjj`AmHPfES\\H","QMHAIhGd@","sNp@DiUjj@[\\QXuq`a`@","KAx@@IVjmUPAlHPfES\\","sGP@DjVj`FsDVMcMC@","QM`AIhGe@","HiD@@LdbJRjjh@[RDIaTwB","qCp@AIZ`H","sGP@LdbMU@MfHl[FFF@","QMDARVA@","sNp@LdbJjj@[\\QXuqba`@","sNp@LdbJjj@[\\QXuqca`@","sGP@Dkej`FsDVM@","qCb@AIZ`OI@","HaD@@DjUZxHH@AlHPfES]FLa`@","sGP@DkYj`FsDVM@","qCb@AIV`H","sNp@LdbJjj@[\\QXuqea`@","sGP@DkUj`FsDVMcEC@","sFp@DiTt@@Axa@","Hmt@@DjU_ZxHHj@AmhPfES\\Lj","QM`BN`^P","qCb@AIZ`OH`","sFp@DiTt@@AxaP","sGP@Djuj`FsDVMcEC@","sGP@Djuj`FsDVMcIC@","sGP@DkUj`FsDVMcKC@","sJP@DkfhAmQEcFRF@","sGP@DjVj`FsDVMcIC@","HaD@@DjUZxHH@AlHPfES]FFa`@","qC`@IRtDVqDV@","sNp@Dj}Zj@[\\QXuqfa`@","KAx@@ITnuUPAlHPfES]FFa`@","HiD@@DkUUjj`AmHPfES\\H","sJQ@@dkU@H","qC`@Qz`H","KAx@@IUkmUPAlHPfES\\","KAx@@ITouUPAlHPfES]FJa`@","sJP@H~j@[TQX`","sGP@DjZj`FsDVM@","sJP@DkVhAmQEcFFF@","sJX@@eKU@H","sJP@DizhAy@","QMHAIhGbP","KAx@@ITouUPAlHPfES]FNa`@","HaD@@DjUZxHD@AlHPfES\\","HaD@@DjUZxHH@A@","sNp@LdbJjj@[\\QXuqaa`@","Hed@@LdbRQUUUP@vTHSBinFP","KAx@@ITouUPAlHPfES]FLa`@","sNp@DkUZj@[\\QXuqba`@","KAx@@ITjuUPAlHPfES]FNa`@","KAx@@YIDTjjh@vDHSBincGPp@","HaD@@DjYvxH`@AlHPfES]FLa`@","RF@QP`","qCb@AIj`H","sNp@DjUjj@[\\QXuqaa`@","sNp@DkVZj@[\\QXu`","KAx@@YIDUJjh@vDHSBin@","sGP@DkYj`FsDVMcIC@","sGP@DjVj`FsDVMcAC@","sGP@DiVj`D","sJP@DkVhAmQEcFZF@","sNp@LdbLjj@[\\QXu`","QM@HvAmdqbF@","HaD@@DjWjXHB@AlHPfES\\","sNp@DjwZj@[\\QXuqba`@","sNp@LdbJjj@[\\QXuqda`@","sFp@DiTt@@Axa`","HiD@@Djuujj`AmHPfES\\H","sNp@DkUZj@[\\QXuqca`@","sJP@DiZhAy@","KAx@@YIDTjjh@vDHSBincCPp@","KAx@@IWNmUPAlHPfES\\","KAx@@IVkMUPAlHPfES\\","sJQ@@dju@H","qCb@AIZ`OH@","qC`@ISTAxa@","sNp@DjyZj@[\\QXu`","Hid@@DjUfaBB`@FtaBXUMp`","HiD@@DiUVjj`AmHPfES\\LXBF@","KAx@@IUjmUPAlHPfES\\","HiD@@DjWvjj`AmHPfES\\LXjF@","sJP@DjVhAmQEb","qCb@AIV`OH`","HiD@@LdbJRjjh@[RDIaTwCFDa`@","KAx@@YIDTjjh@vDHSBinc@Pp@","sNp@DjUjj@[\\QXuqda`@","qC`@Qz`OED","sJP@DkfhAmQEcFZF@","KAx@@YIDbjjh@vDHSBincDPp@","sGP@Djyj`FsDVMcMC@","KAx@@IVrmUPAlHPfES\\","qCp@AIZ`OI@","sJX@@dkU@H","sJQ@@dkU@OH`","sNp@Di]ZjBBvxbqk@","Hkl@@DjU_Uk``bj`@[VDIaTwCJzX","sGP@DjZj`FsDVMcEC@","Hid@@DjU^nBBH@FtaBXUMpqcHX@","sNp@DkeZj@[\\QXu`","sNp@DjYjj@[\\QXuqca`@","sGQ@@djuT@`","HiD@@LdbJTjjh@[RDIaTwB","sOp@DjWkB@@Gd`","HeT@@LdbbRKBDQD@CYPaLJfxY@","qCr@XIKTA@","HiD@@DjW^jj`AmHPfES\\LXJF@","HeT@@DjU]k``b`@[JDIaTwCH","sGP@Djuj`FsDVMcCC@","`IH`B","sOp@DjWkB@@GdX","sJQ@@eKU@H","KAx@@YIDUJjh@vDHSBincBPp@","sJX@@eKU@OH@","KAx@@YIDTjjh@vDHSBincAPp@","sOq@@drm\\@@@`","KAx@@IUkMUPAlHPfES\\","qCp@AIj`H","Hed@@DjUUjjj@FraBXUMpr","sGX@@eJuT@`","sGP@DkUj`FsDVMcCC@","HiD@@Dj}Ujj`AmHPfES\\LXrF@","KAx@@ITouUPAlHPfES]FHa`@","Hed@@DjWujjj@FraBXUMpsFIa`@","sGP@DiUj``mfHlZ","sFp@DiTvjhAlqEcP","Hid@@DjU^nBBH@FtaBXUMpq`XX@","sJP@DkVdAmQEb","qCp@AIZ`OH`","QMhDRVA@","qC`@ISJAlQE`","qCp@BOTAyhl","sJX@@eOU@ODB","sFp@DiTt@@AyaB","sGP@DkUj`FsDVMcMC@","Hid@@DjYUaBH`@FtaBXUMpqcHX@","qC`@Qz`OH@","HiD@@DjUVjj`AmHPfES\\LXZF@","sJP@H~j@[TQXqda`@","sJX@@eKU@OI@","sNp@Djejj@[\\QXu`","sJQ@@dsU@H","sJQ@@dkU@OI`","KAx@@YIMDVjh@vDHSBin@","Hid@@DjU^nBBD@FtaBXUMp`","sNp@DkgZj@[\\QXuqca`@","qC`@IRtDVqDVcEC@","Hed@@LdbRQeUUP@vTHSBinFP","sNp@DiUjj@P","qC`@IRtDT","sNp@DkYZj@[\\QXuqca`@","KAx@@IUkmUPAlHPfES]FDa`@","KAx@@IVjmUPAlHPfES]FNa`@","sOx@@drm\\@@@`","KAx@@ITjuUPAlHPfES]FBa`@","QMDARVAyH","sJP`@dfvhA@","HeT@@DjU_k``b`@[JDIaTwCLXfF@","KAx@@IToUUPAlHPfES]FJa`@","sGP@DkYj`FsDVMcEC@","qCb@AIZ`ODH","`I@`B","KAx@@IUzmUPAlHPfES]FFa`@","sNp@DkfZj@[\\QXu`","KAx@@ITnuUPAlHPfES]F@a`@","HiD@@LddURjjh@[RDIaTwB","sNp@Dj~Zj@[\\QXuqfa`@","Hed@@Dj{uZjj@FraBXUMpr","KAx@@ITsUUPAlHPfES\\","Hid@@LdbRQk``b@AmHPfES\\LXrF@","sOp@DjWkB@@GdH","sJQ@@dkU@OH@","Hid@@DjU^nBBH@FtaBXUMpqahX@","sGP@DiYj``mfHlZ","KAx@@IToUUPAlHPfES]FLa`@","qCp@AJZ`ODH","Hmt@@DjU]ZxHHj@AmhPfES\\Lj","sGP@DkUjPFsDVM@","qC`@IVtA@","Hed@@LdbJReUUP@vTHSBinFP","sNp@DjuZj@[\\QXuqea`@","KAx@@IUkmUPAlHPfES]FNa`@","HiD@@DkVUjj`AmHPfES\\H","Hed@@DkUeZjj@FraBXUMpr","sNp@DkVZj@[\\QXuqea`@","sJP@DiVhHKZbKFLLL@","HiD@@Djuyjj`AmHPfES\\H","sNp@DjUjj@[\\QXuq`a`@","HeT@@DjYUXPbH`@[JDIaTwCH","HiD@@DjwUjj`AmHPfES\\LXRF@","sNq@@djmUPB","KAx@@YIEEZjh@vDHSBincCPp@","sGP@Di^V`dmfHlZ","Hid@@DjYUaBHP@FtaBXUMp`","sNp@DjYjj@[\\QXuqba`@","sGP@Dkej`FsDVMcKC@","HeT@@DjU^k``b`@[JDIaTwCH","qC`@Qv`MbHmFBF@","sGQ@@djmT@`","qCr@XIKTAyH","qC`@IVtAlQEhpPp@","Hid@@LdbbQxXF@@AmHPfES\\LXjF@","sGP@DkYj`FsDVMcCC@","KAx@@IVsMUPAlHPfES\\","qCp@AIj`ODl","HiD@@DkeUjj`AmHPfES\\H","deT@@DjU[k``b`@vTHSBinFP","sJP@DkVdAmQEcFRF@","HiD@@LdbJTjjh@[RDIaTwCFDa`@","HiD@@DkYyjj`AmHPfES\\H","sJP@DjZhAyH","KAx@@IVkMUPAlHPfES]FDa`@","sJX@@dkU@OI@","Hed@@LdbRQUUUP@vTHSBinFXpLL@","Hed@@DjuUZjj@FraBXUMpr","sGP@Djfj`FsDVMcKC@","sNp@DkVZj@[\\QXuqba`@","sNp@DjyZj@[\\QXuqfa`@","qCb@AIj`OH@","sNp@DjUZj@[\\QXu`","KAx@@IWOMUPAlHPfES\\","Hid@@DjU^nBBH@D","Hed@@DjuvZjj@FraBXUMpr","sJP@DiVhHKZbKFLtL@","dmt@@DjU_ZxHHj@C[PaLJfxYVLKC@","sNp@DjuZj@[\\QXuqca`@","sJP@DkfhAmQEcFJF@","sNp@LdbJZj@[\\QXu`","HeT@@DjU_k``b`@[JDIaTwCLXFF@","KAx@@IVlmUPAlHPfES]FNa`@","HeT@@LdbbRKBDQD@CYPaLJfxYcEPp@","Hid@@DjUZnBBH@FtaBXUMpqcHX@","qCa@CIKTA@","HiD@@Dj~]jj`AmHPfES\\LXFF@","sKP@Di\\Zj@[TQX`","sGP@Djfj`FsDVMcEC@","HiD@@DkgYjj`AmHPfES\\H","sNp@DjuZj@[\\QXuqaa`@","KAx@@YIMDVjh@vDHSBincDPp@","sJP@DjVhHKZbKFLTL@","Hid@@LdbRQk``b@AmHPfES\\LXZF@","HiD@@Dj}Ujj`AmHPfES\\LXzF@","HeT@@DjU_k``bP@[JDIaTwCH","sNp@DkUZi@[\\QXu`","HiD@@DjYfjj`AmHPfES\\H","sGP@DjZj`FsDVMcAC@","Hmt@@DjU_jxHHj@AmhPfES\\Lj","Hid@@LdbRQk``R@AmHPfES\\H","KAx@@YIDUJjh@vDHSBincDPp@","qCr@XIKTAyD","sOq@@drm\\@@@|`@","Hed@@DjW^jjj@FraBXUMpsFBa`@","HeT@@DjY]zXFB@@[JDIaTwCH","Hkl@@DjU_Vk``bj`@[VDIaTwCJzX","Hid@@DjY}nBHH@FtaBXUMpqcHX@","sGX@@eKuT@|d@","sGP@Dj^Y`FsDVM@","HcL@@DjU_ZnBBJh@FqaBXUMprn`","sJP@DkVdAmQEcFJF@","sOq@@drm\\@@@|b@","sNp@DjyZj@[\\QXuqaa`@","HaD@@DjUZxHH@AyD@","qC`@Qv`H","dmt@@DjU_ZxHHj@C[PaLJfxYVLYC@","sGP@Dkej`FsDVMcMC@","Hed@@DjUUjjj@FraBXUMpsFHa`@","HeT@@LdbbRkBDQD@CYPaLJfxY@","KAx@@IU{MUPAlHPfES]FLa`@","RG@DTH","sJY@DDeVhA@","KAx@@YIDUJjh@vDHSBinc@Pp@","sJX@@dkU@OI`","sJQ@@dju@OI`","HeT@@LdbbRKBDQD@CYPaLJfxYcFPp@","sFp@DiTvjhAlqEcXpPp@","HaD@@DjUZxHH@AyG@","sNx@@eJ}UPB","sNp@LddUjj@[\\QXuqca`@","HaDH@@RVU[j@@@D","sNp@DkgZi@[\\QXu`","sGY@LDeVj`D","sNp@LdbJfZBZvxbqk@","sJP`@dfvhAyL","sGX@AddQjhAxe`","Hmt@@DjU_ZxHHj@AmhPfES\\LkFIa`@","qCh@CIKTA@","sNp@LdbLjj@[\\QXuq`a`@","sOq@@drm\\@@@|a@","KAx@@IUzmUPAlHPfES]FJa`@","sNx@AddQUUPB","sGP@Di]jP`mfHlZ","sJP`@TeZhA@","KAx@@IRjmUPHKXPaLJfx","HeT@@LdbRTM\\DDT@CYPaLJfxY@","HaF@@@Rfu[j@@@D","Hid@@DjYUaBH`@FtaBXUMpqchX@","KAx@@IUjmTpAlHPfES\\","Hid@@DjU^nBBD@FtaBXUMpqcHX@","sGP@DiUj``mfHl[FFF@","KAx@@IUvmUPAlHPfES]FLa`@","Hed@@LdbQTUUUP@vTHSBinFXqDL@","sJP@DkVhA@","sOx@@drm\\@@@|b@","KAx@@IUkMUPAlHPfES]FDa`@","HeT@@LdbRQU\\DDT@CYPaLJfxY@","HiD@@Dj}Yjj`AmHPfES\\LXrF@","HiD@@Dj{ujj`AmHPfES\\LXFF@","KAx@@IWNmUPAlHPfES]FFa`@","KAx@@IRkMUPHKXPaLJfx","sJP@DjYdAmQEcFZF@","sJY@LDeZhAyL","HaDH@@RVU[f@@@D","sJP`@deVhAyB","HaD@@DjWjZjj`AlHPfES\\","sGP@DkYj`FsDVMcMC@","sNp@DkgZj@[\\QXuqea`@","sJQ@@dlu@H","HeT@@DjU]k``b`@[JDIaTwCLXrF@","sJX@@dkU@OH`","RFDDQFCr`","sJP@DiYXIKZbKFLLL@","KAx@@YIHjjjh@vDHSBincGPp@","Hk\\@@DjU^ukmLHH@@@AmXPfES\\Lki`","sGQ@@djmT@|b@","Hid@@DjUfaBB`@FtaBXUMpqahX@","sNx@@eRmUPB","Hmt@@LdbRVak``ah@FvaBXUMprh","qCr@XIJtA@","KAx@@IWMmUPAlHPfES]FNa`@","HeT@@DjYYZPbJ@@[JDIaTwCH","sNp@DkfZj@[\\QXuqea`@","Hid@@DjU^nBAHAEVtaBXUMp`","dmt@@DjUgZDHJJ@C[PaLJfxYT","sGP@DkejPFsDVM@","sNx@@eJmUPB","qCb@AIf`H","HcL@@DjU_VnBBJh@FqaBXUMprnqcXX@","Hid@@DjUZnBBH@FtaBXUMpqahX@","sNp@LdbQZjBBvxbqkcGC@","sOx@@drm\\@@@|c@","sJP@H~j@^R@","KAx@@YIDcFjhDElHPfES\\","Hid@@DjUZnBAH@FtaBXUMp`","sNp@LddUji@[\\QXu`","sGP@DjfjPFsDVM@","HeT@@DjYUXPbD`@[JDIaTwCH","KAx@@IUoMUPAlHPfES]FDa`@","sFp@DiTt@@AyaD","Hed@@DjuuZjj@FraBXUMpsFIa`@","HeT@@DjUghP`h`@[JDIaTwCLXfF@","sOp@DjWkjj`FwDVM\\YhX@","sGP@Djfj`FsDVMcIC@","KAx@@IRkmUPHKXPaLJfzL]C@","sNx@@djmUPB","QM`AIdD","sOp@DjWkB@@Gbe@","sNp@DjyZj@[\\QXuqca`@","QM@HuAmd`","sNp@LddUjj@[\\QXuqea`@","daD@@DjUZxHD@CXPaLJfzLYC@","qCb@AIZPH","HiD@@LdbJTjjh@[RDIaTwCF@a`@","Hmt@@DjU_ZxHHi@AmhPfES\\Lj","HaDH@@RYWih@H@D","HiD@@LdbJTjjh@[RDIaTwCFHa`@","sGX@@djuT@|a@","sNp@DkfZj@[\\QXuqaa`@","Hid@@DjU^nBBH@GdL","KAx@@IVkMUPAlHPfES]FJa`@","qCr@XIKTAy@","HmT@@Dj{uVjjh@[ZDIaTwCJqaXX@","dmt@@DjYWVDHbJ@C[PaLJfxYT","Hif@@@RUe^Fh@@@P","HaDH@@Rfu[j@@@GdH","KAx@@IVsMUPAlHPfES]FDa`@","sKP@Di\\Zj@[TQXq`a`@","sJX@@eMU@OH@","HeT@@DjU^k``b`@[JDIaTwCLXFF@","Hmt@@LdbbRJXPbHh@FvaBXUMprh","sJP@DjvhAmQEcFBF@","dmt@@LdbbRNXPbHh@MmBDpj[aeXplL@","sJP`@dfvhAyD","sGP@Di^V`dmfHl[FVF@","KAx@@IVsmUPAlHPfES]FBa`@","sOq@@drm\\@@@|PP","sJY@BDeZhA@","HeT@@LdbRbmBDED@CYPaLJfxY@","Hed@@Djy[Zjj@FraBXUMpr","HeT@@DjU]k``b`@[JDIaTwCLXFF@","Hid@@DjUfaBB`@D","qCa@CIJtA@","QMPARVA@","Hid@@DjUfaBB`@FtaBXUMpqcHX@","sJY@BDfZhA@","HeT@@DjUghP`hP@[JDIaTwCH","Hed@@Dj{uZjj@FraBXUMpsFIa`@","dmt@@DjYUvDHbJ@C[PaLJfxYVLUC@","sNp`@dfuZj@P","sJQ@@dmU@OH@","sJX@@dmU@H","HeT@@DjU]k``b`@[JDIaTwCLXZF@","HiD@@LdfbJZjh@[RDIaTwCFAa`@","sOx@@drm\\@@@|a@","deT@@DjUfhP`h`@vTHSBinFP","dmt@@DjU]ZxHHj@C[PaLJfxYVLKC@","sOp@DjWkjj`FwDVM\\XHX@","HcL@@LdbbRNSBDQEP@McBDpj[ae]cFpp@","HiD@@Dj}Yji`AmHPfES\\H","HaDH@@RYe[hB@@D","Hid@@DjU^njjj@FtaBXUMpq`XX@","deT@@LdbbRKBDQB@FraBXUMpr","QMPARZA@","sOq@@drm\\@@@|QX","HaD@@DjYvxH`@A@","HcL@@LdbbRNcBDQEP@McBDpj[ae]@","QMhDRZA@","RG@DXLHmP","QM`BN`XQYd","RG@DTLHmP","QMHAIXFEVd","QMDARVAaH","RFPDXLHmP","RF@Q`vRbdLEC@","RF@QpvR@","QO@HyjAmd`","`II@B","`II@CFspqJp","`II@CF[@hM@prB`","`H@[T[|B`XN@PdM@p|@bHrBcDk@","RG@DXMj}F@","QM`BN`[L~b@","RG@DTMj}D@","QMHAIXFt~j@","QMDARVA}L@","RFPDXMj}D@","sKP@Di\\YZ@[TQXqaa`@","eF`BHD"])},xl.Us=function(n,t){var e,i;if(!t)return null;for(i=vf(kl.llb,z,6,(xl.Rs.length+31)/32|0,15,1),t=xl.Zs(t),xl.Gs(n.e,t),e=0;e<xl.Rs.length;e++)xl.Es(n.e,xl.Ss[e]),xl.ss(n.e,1,4)>0&&(i[e/32|0]|=1<<31-e%32);return i},xl.Vs=function(n,t){var e,i;if(!t)return null;for(i=vf(kl.mlb,st,6,(xl.Rs.length+63)/64|0,14,1),t=xl.Zs(t),xl.Gs(n.e,t),e=0;e<xl.Rs.length;e++)xl.Es(n.e,xl.Ss[e]),xl.ss(n.e,1,4)>0&&(i[e/64|0]=Eg(i[e/64|0],xg(1,63-e%64)));return i},xl.Ws=function(){var n,t;if(null==xl.Ss)for(t=new xl.Kp(!1),xl.Ss=vf(kl.fmb,le,24,xl.Rs.length,0,1),n=0;n<xl.Rs.length;n++)xl.Ss[n]=xl.xp(t,xl.Rs[n]),xl.nu(xl.Ss[n],1)},xl.Xs=function(n){var t;if(null==n.d)return!1;for(t=0;t<n.d.length;t++)if(0!=(n.b[t]&~n.d[t]))return!1;return xl.Ys(n)},xl.Ys=function(n){return!n.c&&(n.c=(new xl.Kp(!1),null)),!n.a&&(n.a=(new xl.Kp(!1),null)),xl.Gs(n.e,n.c),xl.Es(n.e,n.a),xl.zs(n.e)},xl.Zs=function(n){var t,e;if(n.K)for(t=0;t<n.q;t++)if(Bg(Cg(n.B[t],tn),0)){for(n=new xl.Hu(n),e=t;e<n.q;e++)Bg(Cg(n.B[e],tn),0)&&(n.C[e]=-1);xl.tk(n)}return n},xl.$s=function(n,t,e){n.a=t,n.b=null==e?xl.Us(n,t):e},xl._s=function(n,t,e){n.c=t,n.d=null==e?xl.Us(n,t):e},xl.at=function(){xl.Ts(),this.e=new xl.Ms,xl.Ws()},xl.bt=function(n){var t,e,i,s,a,r;if(xl.Ts(),null==n)return null;for(t=vf(kl.hlb,ft,6,8*n.length,15,1),i=0;i<n.length;i++)for(r=n[i],s=7;s>=0;s--)(e=15&r)>9&&(e+=7),t[8*i+s]=48+e<<24>>24,r>>=4;return Jl.WHb(Rl.kTb(t,0,(a=t.length,Rl.hTb(),a)))},xl.ct=function(n){var t,e,i,s;if(xl.Ts(),0==Rl.LTb(n).length||0!=(7&Rl.LTb(n).length))return null;for(i=vf(kl.llb,z,6,Rl.LTb(n).length/8|0,15,1),e=0;e<Rl.LTb(n).length;e++)s=e/8|0,Rl.GTb(e,Rl.LTb(n).length),(t=Rl.LTb(n).charCodeAt(e)-48)>16&&(t-=7),i[s]<<=4,i[s]+=t;return i},xl.dt=function(t,e){var i,s,a,r;for(xl.Ts(),r=0,s=0,a=0,i=0;i<t.length;i++)r+=eu(t[i]&e[i]),s+=eu(t[i]),a+=eu(e[i]);return r/n.Math.sqrt(s*a)},xl.et=function(n,t){var e,i,s;for(xl.Ts(),s=0,e=0,i=0;i<n.length;i++)s+=eu(n[i]&t[i]),e+=eu(n[i]|t[i]);return s/e},zf(197,1,{},xl.at),kl.Xlb=lg(197),xl.gt=function(n){n.j=1,n.k=10,n.n=400,n.f=400,n.i=!0,n.d="black",n.b=new Fl.kj,n.a=new Fl.kj,n.c=new Jl.jIb,n.e=new wf.sEb(12)},xl.ht=function(n,t){var e;return(e=wf.qEb(n.e,t),new Nf.MEb(e)).b},xl.it=function(n){return n.k},xl.jt=function(n){var t,e,i,s,a;if(a='<svg id="'+(null!=n.g?n.g:"mol"+xl.ft)+'" xmlns="http://www.w3.org/2000/svg" version="1.1" width="'+n.n+'px" height="'+n.f+'px" viewBox="0 0 '+n.n+" "+n.f+'">\n',a+="  ",a+=n.i?"<style> #"+(null!=n.g?n.g:"mol"+xl.ft)+" { pointer-events:none; } #"+(null!=n.g?n.g:"mol"+xl.ft)+" .event  { pointer-events:all; } line { stroke-linecap:round; } polygon { stroke-linejoin:round; } </style>\n":'<g style="font-size:'+n.k+'px; fill-opacity:1; stroke-opacity:1; fill:black; stroke:black; font-weight:normal; text-rendering:optimizeLegibility; font-family:sans-serif; stroke-linejoin:round; stroke-linecap:round; stroke-dashoffset:0;">',n.i){for(s=new Fl.rOb(n.b);s.a<s.c.a.length;)i=Fl.qOb(s),xl.kt(n,i);for(e=new Fl.rOb(n.a);e.a<e.c.a.length;)t=Fl.qOb(e),xl.kt(n,t)}return n.i||xl.kt(n,"</g>"),a+n.c.a+"</svg>"},xl.kt=function(n,t){Jl.gIb(n.c,"  "),Jl.gIb(n.c,t),Jl.gIb(n.c,H)},xl.lt=function(n,t,e){xl.Qc(),xl.Td.call(this,n,t),xl.gt(this),this.g=e,++xl.ft},xl.mt=function(n){xl.Qc(),xl.lt.call(this,n,0,null)},zf(195,144,{144:1},xl.lt,xl.mt),o.mb=function(n){var t;t='<line x1="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(n.a),(Uf.HKb(),Uf.DKb))))+'" y1="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(n.c),Uf.DKb)))+'" x2="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(n.b),Uf.DKb)))+'" y2="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(n.d),Uf.DKb)))+fe+ge+this.d+fe+ue+this.j+de,xl.kt(this,t)},o.nb=function(n){var t,e;e='<line stroke-dasharray="'+(t=Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(3*this.j),(Uf.HKb(),Uf.DKb)))))+","+t+'" x1="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(n.a),Uf.DKb)))+'" y1="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(n.c),Uf.DKb)))+'" x2="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(n.b),Uf.DKb)))+'" y2="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(n.d),Uf.DKb)))+fe+ge+this.d+'" stroke-width:'+this.j+de,xl.kt(this,e)},o.ob=function(t){var e,i;for(i=new Jl.lIb('<polygon points="'),e=0;e<t.a;e++)Jl.eIb(i,Pg(n.Math.round(t.b[e]))),i.a+=",",Jl.eIb(i,Pg(n.Math.round(t.c[e]))),i.a+=" ";Jl.gIb(i,'" fill="'+this.d+fe+ge+this.d+fe+ue+this.j+de),xl.kt(this,i.a)},o.pb=function(n,t,e){var i,s,a;s=(a=wf.qEb(this.e,n),new Nf.MEb(a)).b,i='<text x="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(t-s/2),(Uf.HKb(),Uf.DKb))))+'" y="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(e+this.k/3),Uf.DKb)))+'" stroke="none" font-size="'+this.e.b+'" fill="'+this.d+'">'+n+"</text>",xl.kt(this,i)},o.qb=function(n,t,e){var i;i='<circle cx="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(n+e/2),(Uf.HKb(),Uf.DKb))))+'" cy="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(t+e/2),Uf.DKb)))+'" r="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(e/2),Uf.DKb)))+'" fill="'+this.d+de,xl.kt(this,i)},o.rb=function(n){return xl.ht(this,n)},o.sb=function(){return xl.it(this)},o.tb=function(n,t,e,i){var s;s='<circle id="'+(null!=this.g?this.g:"mol"+xl.ft)+":Atom:"+n+fe+ce+'data-atom-map-no="'+xl.Ik(this.K,n)+'" cx="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(e),(Uf.HKb(),Uf.DKb))))+'" cy="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(i),Uf.DKb)))+'" r="8'+fe+he,Fl.Si(this.a,s)},o.ub=function(n,t,e,i,s){var a;a='<line id="'+(null!=this.g?this.g:"mol"+xl.ft)+":Bond:"+n+fe+ce+'x1="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(t),(Uf.HKb(),Uf.DKb))))+'" y1="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(e),Uf.DKb)))+'" x2="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(i),Uf.DKb)))+'" y2="'+Jl.mGb(Uf.IIb(Uf.FIb(new Uf.JIb(s),Uf.DKb)))+fe+ue+8+fe+he,Fl.Si(this.b,a)},o.wb=function(t){this.j=Xg(Pg(n.Math.round(100*n.Math.max(t,1))))/100},o.xb=function(n){this.d="rgb("+((n&be)>>16)+","+((n&q)>>8)+","+(255&n)+")"},o.yb=function(n){this.k!=n&&(this.k=n,this.e=new wf.sEb(n))},o.zb=function(t,e){return this.n=zg(Pg(n.Math.round(t.b))),this.f=zg(Pg(n.Math.round(t.a))),xl.Pd(this,t,e)},o.lb=function(){return xl.jt(this)},o.f=0,o.i=!1,o.j=0,o.k=0,o.n=0,xl.ft=0,kl.Zlb=lg(195),xl.Bt=function(n,t){var e;if(null!=n.c)for(e=0;e<n.c.length;e++)if(t==n.c[e]&&n.d[e])return!0;return!1},xl.Ct=function(n,t,e,i,s){this.a=n,this.b=t,this.g=e,this.f=i,this.e=s},zf(211,1,{211:1},xl.Ct),o.a=0,o.b=0,o.e=!1,o.f=!1,o.g=0,kl.$lb=lg(211),xl.Dt=function(n,t){var e,i,s,a;for(a=!1,n.b=t,xl.nu(n.b,15),e=n.b.f,i=n.b.g,n.j=vf(kl.Cwb,nn,6,i,16,1),s=0;s<i;++s)n.j[s]=!1;for(n.g=vf(kl.Cwb,nn,6,e,16,1),n.c=vf(kl.llb,z,6,e,15,1),s=0;s<e;++s)n.g[s]=!1,n.c[s]=-1;for(n.e=vf(kl.Oub,k,2,3*e,6,1),n.i=0,n.d=0,n.a=0;!a;){for(s=0;s<e;++s)if(!n.g[s]){n.a>0&&(n.e[n.i++]="."),xl.Ft(n,s,-1),++n.a;break}s==e&&(a=!0)}for(n.f="",s=0;s<n.i;++s)n.f+=""+n.e[s];return n.f},xl.Et=function(n){switch(n){case 5:case 6:case 7:case 8:case 9:case 15:case 16:case 17:case 35:case 53:return!0;default:return!1}},xl.Ft=function(t,e,i){var s,a,r,o,l,f,g,u,d,c,h,b,D;if(s=!0,f=0,D=0,c=t.i,t.c[e]=c,l=xl.Qk(t.b,e),o=xl.Fk(t.b,e),a=xl.zk(t.b,e),r=xl.Jk(t.b,e),u=xl.Sn(t.b,e),0==a&&0==r&&xl.Et(l)&&(s=!1),t.e[c]="",-1!=i)switch(xl.bl(t.b,i)){case 0:t.e[c]+="~";break;case 2:t.e[c]+="=";break;case 3:t.e[c]+="#"}for(s&&(t.e[c]+="["),0!=r&&(t.e[c]+=""+r),t.e[c]+=""+o,s&&0<(b=xl.fo(t.b,e))&&(t.e[c]+="H",1<b&&(t.e[c]+=b)),0!=a&&(t.e[c]+=a>0?"+":"-",n.Math.abs(a)>1&&(t.e[c]+=""+n.Math.abs(a))),s&&(t.e[c]+="]"),-1!=i&&(t.j[i]=!0),t.g[e]=!0,++t.i,h=0;h<u;++h)t.j[xl.Tn(t.b,e,h)]||++f;for(h=0;h<u;++h)if(g=xl.Rn(t.b,e,h),d=xl.Tn(t.b,e,h),t.j[d])++D;else if(t.g[g]){switch(++t.d,t.j[d]=!0,xl.bl(t.b,d)){case 0:t.e[t.c[g]]+="~",t.e[c]+="~";break;case 2:t.e[t.c[g]]+="=",t.e[c]+="=";break;case 3:t.e[t.c[g]]+="#",t.e[c]+="3"}t.d>9&&(t.e[t.c[g]]+="%",t.e[c]+="%"),t.e[t.c[g]]+=""+t.d,t.e[c]+=""+t.d}else h-D<f-1&&(t.e[t.i++]="("),xl.Ft(t,g,d),h-D<f-1&&(t.e[t.i++]=")")},xl.Gt=function(){},zf(328,1,{},xl.Gt),o.a=0,o.d=0,o.i=0,kl._lb=lg(328),xl.Ht=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h;for(f=vf(kl.llb,z,6,n.i.f,15,1),o=vf(kl.llb,z,6,n.i.f,15,1),l=vf(kl.llb,z,6,n.i.f,15,1),g=vf(kl.llb,z,6,n.i.f,15,1),e=xl.Vk(n.i,0,t),i=xl.Vk(n.i,1,t),o[0]=e,o[1]=i,l[0]=-1,l[1]=t,f[e]=1,f[i]=2,g[e]=-1,g[i]=e,r=1,u=1;r<=u&&f[o[r]]<15;){for(h=o[r],d=0;d<xl.Sn(n.i,h);d++)if((s=xl.Rn(n.i,h,d))!=g[h]){if(a=xl.Tn(n.i,h,d),s==e){for(l[0]=a,c=0;c<=u;c++)n.f[l[d]]||(n.f[l[d]]=!0,++n.c);return}xl.El(n.i,s)&&0==f[s]&&(o[++u]=s,l[u]=a,f[s]=f[h]+1,g[s]=h)}++r}},xl.It=function(n){var t,e,i,s,a,r,o,l,f,g,u,d,c;for(xl.nu(n.i,7),u=!1,d=vf(kl.llb,z,6,2,15,1),c=vf(kl.llb,z,6,2,15,1),g=vf(kl.llb,z,6,2,15,1),i=0;i<n.i.g;i++)if(!xl.Yo(n.i,i)&&2==xl.el(n.i,i)){for(r=0;r<2;r++){for(d[r]=-1,g[r]=-1,t=xl.Vk(n.i,r,i),f=0;f<xl.Sn(n.i,t);f++)(s=xl.Tn(n.i,t,f))!=i&&(-1!=d[r]||257!=xl.el(n.i,s)&&129!=xl.el(n.i,s)?g[r]=xl.Rn(n.i,t,f):(d[r]=xl.Rn(n.i,t,f),c[r]=s));if(-1==d[r])break}if(-1!=d[0]&&-1!=d[1]){for(l=xl.el(n.i,c[0])==xl.el(n.i,c[1]),o=0;o<2;o++)d[o]==xl.Vk(n.i,0,c[o])&&(l=!l);for(a=0;a<2;a++)-1!=g[a]&&g[a]<d[a]&&(l=!l);xl.Cm(n.i,i,l?2:1,!1),u=!0}}for(e=0;e<n.i.g;e++)(257==xl.el(n.i,e)||129==xl.el(n.i,e))&&xl.Fm(n.i,e,1);return u},xl.Jt=function(n){return 61==n?2:35==n?4:36==n?32:58==n?8:62==n?16:126==n?31:1},xl.Kt=function(n,t){var e,i,s,a,r,o,l,f,g,u,d;for(e=0;e<n.i.f;e++)if(xl.El(n.i,e))for(l=vf(kl.llb,z,6,n.i.f,15,1),o=vf(kl.llb,z,6,n.i.f,15,1),f=vf(kl.llb,z,6,n.i.f,15,1),o[0]=e,l[e]=1,f[e]=-1,r=0,g=0;r<=g;){for(s=1==(1&l[o[r]])?1:2,u=0;u<xl.Sn(n.i,o[r]);u++)if(i=xl.Tn(n.i,o[r],u),xl.bl(n.i,i)==s&&t[i]&&0==l[a=xl.Rn(n.i,o[r],u)]){if(1==s&&xl.El(n.i,a)){for(d=o[r];-1!=d;)xl.Fm(n.i,xl.Pn(n.i,a,d),1==s?2:1),s=3-s,a=d,d=f[d];return xl.lm(n.i,e,!1),xl.lm(n.i,a,!1),n.b-=2,!0}o[++g]=a,f[a]=o[r],l[a]=l[o[r]]+1}++r}return!1},xl.Lt=function(n){var t,e,i,s;for(t=0;t<n.i.f;t++)if(7==xl.Qk(n.i,t)&&0==xl.zk(n.i,t)&&xl.ko(n.i,t)>3&&xl.In(n.i,t)>0)for(s=0;s<xl.Sn(n.i,t);s++)if(e=xl.Rn(n.i,t,s),i=xl.Tn(n.i,t,s),xl.bl(n.i,i)>1&&xl.Cl(n.i,e)){4==xl.el(n.i,i)?xl.Fm(n.i,i,2):xl.Fm(n.i,i,1),xl.cm(n.i,t,xl.zk(n.i,t)+1),xl.cm(n.i,e,xl.zk(n.i,e)-1),xl.am(n.i,t,-1);break}},xl.Mt=function(n){return n.n?"Unresolved SMARTS features:"+n.n:""},xl.Nt=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I,P,M,w,N,L,U,k,J;for(xl.nu(n.i,1),n.f=vf(kl.Cwb,nn,6,n.i.g,16,1),n.c=0,g=0;g<n.i.g;g++)64==xl.el(n.i,g)&&(xl.Fm(n.i,g,1),n.f[g]=!0,++n.c);for(T=vf(kl.Cwb,nn,6,n.i.f,16,1),J=new xl.gs(n.i,3),C=vf(kl.Cwb,nn,6,J.i.a.length,16,1),N=0;N<J.i.a.length;N++){for(U=Fl.Xi(J.i,N),C[N]=!0,D=0;D<U.length;D++)if(!xl.El(n.i,U[D])){C[N]=!1;break}if(C[N]){for(H=0;H<U.length;H++)T[U[H]]=!0;for(k=Fl.Xi(J.j,N),j=0;j<k.length;j++)n.f[k[j]]||(n.f[k[j]]=!0,++n.c)}}for(u=0;u<n.i.g;u++)!n.f[u]&&0!=(J.b[u]&y)&&xl.El(n.i,xl.Vk(n.i,0,u))&&xl.El(n.i,xl.Vk(n.i,1,u))&&xl.Ht(n,u);for(d=0;d<n.i.g;d++)n.f[d]||(s=xl.Vk(n.i,0,d),a=xl.Vk(n.i,1,d),!T[s]&&!T[a]&&xl.El(n.i,s)&&xl.El(n.i,a)&&(n.f[d]=!0,++n.c));for(xl.nu(n.i,7),A=vf(kl.Cwb,nn,6,n.i.g,16,1),m=0;m<n.i.g;m++)A[m]=n.f[m];for(L=0;L<J.i.a.length;L++)if(C[L])for(U=Fl.Xi(J.i,L),b=0;b<U.length;b++)if(!xl.Ut(n,U[b]))for(xl.El(n.i,U[b])&&(xl.lm(n.i,U[b],!1),--n.b),I=0;I<xl.Sn(n.i,U[b]);I++)h=xl.Tn(n.i,U[b],I),n.f[h]&&(n.f[h]=!1,--n.c);for(xl.Tt(n),w=0;w<J.i.a.length;w++)if(C[w]&&6==Fl.Xi(J.j,w).length){for(p=!0,l=0,f=(o=k=Fl.Xi(J.j,w)).length;l<f;++l)if(r=o[l],!n.f[r]){p=!1;break}p&&(xl.St(n,k[0]),xl.St(n,k[2]),xl.St(n,k[4]),xl.Tt(n))}for(M=5;M>=4;M--)do{for(P=!1,r=0;r<n.i.g;r++)if(n.f[r]){for(e=0,b=0;b<2;b++)for(c=xl.Vk(n.i,b,r),I=0;I<xl.Sn(n.i,c);I++)n.f[xl.Tn(n.i,c,I)]&&++e;if(e==M){xl.St(n,r),xl.Tt(n),P=!0;break}}}while(P);for(;n.b>=2&&xl.Kt(n,A););if(t){if(0!=n.b)for(i=0;i<n.i.f;i++)xl.El(n.i,i)&&(xl.lm(n.i,i,!1),xl.om(n.i,i,2,!0),--n.b);if(0!=n.c)for(r=0;r<n.i.g;r++)n.f[r]&&(n.f[r]=!1,xl.Fm(n.i,r,64),--n.c)}else for(i=0;i<n.i.f;i++)xl.El(n.i,i)&&0!=xl.fo(n.i,i)&&(xl.lm(n.i,i,!1),xl.pm(n.i,i,32),--n.b);if(0!=n.b)throw og(new Jl.aA(De));if(0!=n.c)throw og(new Jl.aA(De))},xl.Ot=function(t,e,i,s,a,r,o){var l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I,P,M,w,N,L,U,k,B,R,E,x,F,Q,S,X,G,q,Y,v,Z,O,V,K,W,_,$,nn,tn,en,sn,an,rn,on,fn,gn,un,dn,bn,Hn,jn,Cn,Tn,pn,In,Mn,wn,Nn,Un,kn;for(t.i=e,xl.hk(t.i),t.n&&Jl.$Eb(t.n,0),t.b=0,f=0!=t.k,en=null,(D=vf(kl.llb,z,6,32,15,1))[0]=-1,fn=vf(kl.llb,z,6,16,15,1),dn=vf(kl.llb,z,6,16,15,1),un=vf(kl.llb,z,6,16,15,1),gn=vf(kl.llb,z,6,16,15,1),E=0;E<16;E++)fn[E]=-1;for(c=0,L=-1,jn=!1,Q=!1,Hn=!1,C=0,m=1,j=0,d=new gf.F6,sn=new xl.fu(i);i[s]<=32;)++s;for(;s<a;)if(Kg(Tn=i[s++]&y)||42==Tn||63==Tn||33==Tn&&f&&jn||35==Tn&&f&&jn){if(b=-1,p=0,v=0,l=-1,w=-1,tn=!1,F=!1,h=0,jn){if(42==Tn)b=6,h=zg(Eg(kl.Rwb(h),1));else if(63==Tn)b=0;else if(35==Tn){for(V=0;s<a&&Vg(i[s]&y);)V=10*V+i[s]-48,++s;if(V<1||V>=(xl.Sj(),xl.Mj).length)throw og(new Jl.aA("SmilesParser: Atomic number out of range."));b=V}else if((S=33==Tn)&&(Hn=!0,h=zg(Eg(kl.Rwb(h),1)),++s),82==i[s-1]&&f&&(Vg(i[s]&y)||t.a&&123==i[s]))b=6,h=zg(Eg(kl.Rwb(h),1)),--s,S&&--s;else if(X=_g(i[s]&y)==(i[s]&y)&&Kg(i[s]&y)?2:1,xl.Sj(),-1==(b=xl.hn(Jl.WHb(Rl.kTb(i,s-1,(G=X,Rl.hTb(),G))),321)))b=6,h=zg(Eg(kl.Rwb(h),1)),--s;else if(s+=X-1,w=9,f&&(44==i[s]||S)){for(pn=!1,Y=!1,_=Cn=s-X;_<i.length;_++)if(!Kg(i[_]&y)){if(0!=(O=xl.hn(Jl.WHb(Rl.kTb(i,Cn,_-Cn)),321))&&(gf.A6(d,Jl.UGb(O)),$g(i[Cn]&y)==(i[Cn]&y)&&Kg(i[Cn]&y)?pn=!0:Y=!0),Cn=_+1,44!=i[_])break;if(33==i[_+1]){if(!S)throw og(new Jl.aA("SmilesParser: inconsistent '!' in atom list."));++_,++Cn}}d.d.a.length>1&&(w=-1,pn?Y||(h=zg(Eg(kl.Rwb(h),4))):h=zg(Eg(kl.Rwb(h),2))),s=Cn-1}for(;jn;)if(64!=i[s])if(58!=i[s]){if(91==i[s])throw og(new Jl.aA("SmilesParser: nested square brackets found"));if(93!=i[s])if(43!=i[s])if(45!=i[s])if((S=33==i[s])&&++s,72!=i[s])if(68!=i[s])if(122==i[s]&&t.a)++s,s+=xl.cu(sn,i,s,4),N=0,sn.c<=0&&sn.b>=0&&(N=Eg(N,Rn)),sn.c<=1&&sn.b>=1&&(N=Eg(N,He)),sn.c<=2&&sn.b>=2&&(N=Eg(N,je)),sn.c<=3&&sn.b>=3&&(N=Eg(N,me)),sn.c<=4&&sn.b>=4&&(N=Eg(N,Bn)),0!=Tg(N,0)&&(S||(N=qg(N,Ln)),h=zg(Eg(kl.Rwb(h),N)));else if(88!=i[s])if(65!=i[s]&&97!=i[s])if(82!=i[s])if(114!=i[s])if(118!=i[s]){if(!f||59!=i[s]&&38!=i[s])throw og(new Jl.aA("SmilesParser: unexpected character inside brackets: '"+String.fromCharCode(i[s]&y)+"'"));Hn=!0,++s}else++s,s+=xl.cu(sn,i,s,1),Mn=sn.c,sn.b>sn.c&&xl.Wt(t,(S?"!v":"v")+"{"+sn.c+"-"+sn.b+"}"),!S&&Mn<=14?l=Mn:sn.b>sn.c||xl.Wt(t,(S?"!v":"v")+Mn);else{if(++s,s+=xl.cu(sn,i,s,1),sn.a){h=zg(Eg(kl.Rwb(h),S?384:8));continue}bn=sn.c,sn.b>sn.c&&xl.Wt(t,(S?"!r":"r")+"{"+sn.c+"-"+sn.b+"}"),!S&&bn>=3&&bn<=7?h|=bn<<22:sn.b>sn.c||xl.Wt(t,(S?"!r":"r")+bn)}else++s,s+=xl.cu(sn,i,s,3),N=0,sn.c<=0&&sn.b>=0&&(N=Eg(N,8)),sn.c<=1&&sn.b>=1&&(N=Eg(N,16)),sn.c<=2&&sn.b>=2&&(N=Eg(N,32)),sn.c<=3&&sn.b>=3&&(N=Eg(N,64)),sn.b>3&&xl.Wt(t,(S?"!R":"R")+sn.b),0!=Tg(N,0)&&(S||(N=qg(N,120)),h=zg(Eg(kl.Rwb(h),N)));else++s,h=zg(Eg(kl.Rwb(h),S^65==i[s]?4:2));else{if(++s,s+=xl.cu(sn,i,s,1),null==(kn=(xl.Sj(),xl.Nj)[b]))continue;N=0,(Mn=kn[0])-sn.c<=0&&Mn-sn.b>=0&&(N=Eg(N,ln)),Mn-sn.c<=1&&Mn-sn.b>=1&&(N=Eg(N,kt)),Mn-sn.c<=2&&Mn-sn.b>=2&&(N=Eg(N,J)),0!=Tg(N,0)&&(S||(N=qg(N,mn)),h=zg(Eg(kl.Rwb(h),N)))}else++s,s+=xl.cu(sn,i,s,1),N=0,sn.c<=0&&sn.b>=0&&(N=Eg(N,gt)),sn.c<=1&&sn.b>=1&&(N=Eg(N,Wn)),sn.c<=2&&sn.b>=2&&(N=Eg(N,Kn)),sn.c<=3&&sn.b>=3&&(N=Eg(N,ct)),sn.c<=4&&sn.b>=4&&(N=Eg(N,Pn)),0!=Tg(N,0)&&(S||(N=qg(N,An)),h=zg(Eg(kl.Rwb(h),N)));else++s,s+=xl.cu(sn,i,s,1),w=sn.c,N=0,sn.c<=0&&sn.b>=0&&(N=zg(Eg(kl.Rwb(N),128))),sn.c<=1&&sn.b>=1&&(N=zg(Eg(kl.Rwb(N),256))),sn.c<=2&&sn.b>=2&&(N=zg(Eg(kl.Rwb(N),512))),sn.c<=3&&sn.b>=3&&(N=zg(Eg(kl.Rwb(N),hn))),S?(h|=N,w=-1):sn.b==sn.c?w=sn.c:(h=zg(Eg(kl.Rwb(h),Cg(cn,kl.Rwb(~N)))),w=-1);else{for(p=-1,++s;45==i[s];)--p,++s;-1==p&&Vg(i[s]&y)&&(p=48-i[s],++s),0==p&&(h=zg(Eg(kl.Rwb(h),Dn)))}else{for(p=1,++s;43==i[s];)++p,++s;1==p&&Vg(i[s]&y)&&(p=i[s]-48,++s),0==p&&(h=zg(Eg(kl.Rwb(h),Dn)))}else++s,jn=!1}else for(++s;Vg(i[s]&y);)v=10*v+i[s]-48,++s;else 64==i[++s]&&(F=!0,++s),tn=!0}else if(42==Tn)b=6,h=zg(Eg(kl.Rwb(h),1));else if(63==Tn)b=0;else if(65!=Tn&&97!=Tn||!f)switch($g(Tn)){case 66:s<a&&114==i[s]?(b=35,++s):b=5;break;case 67:s<a&&108==i[s]?(b=17,++s):b=6;break;case 70:b=9;break;case 73:b=53;break;case 78:b=7;break;case 79:b=8;break;case 80:b=15;break;case 83:b=16}else b=6,h=zg(Eg(kl.Rwb(h),1)),h=zg(Eg(kl.Rwb(h),65==Tn?4:2)),Hn=!0;if(-1==b&&63!=Tn)throw og(new Jl.aA("SmilesParser: unknown element label found"));if(u=xl.Uj(t.i,b),xl.cm(t.i,u,p),xl.km(t.i,u,v,!1),xl.am(t.i,u,l),0!=h&&(Hn=!0,Bg(Cg(kl.Rwb(h),2),0)?(h=zg(Cg(kl.Rwb(h),-3)),xl.lm(t.i,u,!0),++t.b):xl.lm(t.i,u,!1),xl.om(t.i,u,kl.Rwb(h),!0)),0!=d.d.a.length){for(Hn=!0,q=vf(kl.llb,z,6,d.d.a.length,15,1),R=0;R<d.d.a.length;R++)q[R]=(R<0?null:Fl.Xi(d.d,R)).a;xl.im(t.i,u,q),Rl.eTb(d.d.a,0)}else if(_g(Tn)==Tn&&Kg(Tn)){if(5!=b&&6!=b&&7!=b&&8!=b&&15!=b&&16!=b&&33!=b&&34!=b)throw og(new Jl.aA("SmilesParser: atomicNo "+b+" must not be aromatic"));xl.lm(t.i,u,!0),++t.b}else xl.lm(t.i,u,!1);-1!=w&&1!=b&&((T=vf(kl.hlb,ft,6,1,15,1))[0]=(9==w?0:w)<<24>>24,xl.gm(t.i,u,T)),L=D[C],-1!=D[C]&&512!=m&&(H=xl.Wj(t.i,D[C],u,m),0!=j&&(Hn=!0,xl.Em(t.i,H,j,!0))),m=1,j=0,D[C]=u,0!=c&&(xl.mm(t.i,u,c),c=0),o&&(($=en?Fl.lNb(en,Jl.UGb(L)):null)&&xl.$t($,u,s),tn&&(!en&&(en=new Fl.oRb),B=9==w?0:w,Fl.gRb(en,Jl.UGb(u),new xl.bu(u,s-2,L,B,F))))}else if(46!=Tn)if(45!=Tn&&61!=Tn&&35!=Tn&&36!=Tn&&58!=Tn&&47!=Tn&&92!=Tn&&60!=Tn&&126!=Tn&&33!=Tn&&64!=Tn)if(Tn<=32)s=a;else if(Vg(Tn))if(V=Tn-48,jn){for(;s<a&&Vg(i[s]&y);)V=10*V+i[s]-48,++s;c=V}else{if(k=45==i[A=Q?s-3:s-2]||47==i[A]||92==i[A]||61==i[A]||35==i[A]||36==i[A]||58==i[A]||62==i[A]||126==i[A],Q&&s<a&&Vg(i[s]&y)&&(V=10*V+i[s]-48,Q=!1,++s),V>=fn.length){if(V>=100)throw og(new Jl.aA("SmilesParser: ringClosureAtom number out of range"));for(K=fn.length,Z=fn.length;Z<=V;)Z=n.Math.min(100,Z+16);for(Rl.wTb(Z),fn=Fl.zOb(fn,vf(kl.llb,z,6,Z,15,1),Z),Rl.wTb(Z),dn=Fl.zOb(dn,vf(kl.llb,z,6,Z,15,1),Z),Rl.wTb(Z),un=Fl.zOb(un,vf(kl.llb,z,6,Z,15,1),Z),Rl.wTb(Z),gn=Fl.zOb(gn,vf(kl.llb,z,6,Z,15,1),Z),R=K;R<Z;R++)fn[R]=-1}if(-1==fn[V])fn[V]=D[C],dn[V]=s-1,un[V]=k?m:-1,gn[V]=k?j:0;else{if(fn[V]==D[C])throw og(new Jl.aA("SmilesParser: ring closure to same atom"));o&&en&&(($=Fl.lNb(en,Jl.UGb(fn[V])))&&xl.$t($,D[C],dn[V]),($=Fl.lNb(en,Jl.UGb(D[C])))&&xl.$t($,fn[V],s-1)),-1!=un[V]?m=un[V]:257==m?m=129:129==m&&(m=257),H=xl.Wj(t.i,fn[V],D[C],m),0!=gn[V]&&(j=gn[V]),0!=j&&(Hn=!0,xl.Em(t.i,H,gn[V],!0)),fn[V]=-1}m=1,j=0}else{if(43==Tn)throw og(new Jl.aA("SmilesParser: '+' found outside brackets"));if(40!=Tn)if(41!=Tn)if(91!=Tn){if(93==Tn)throw og(new Jl.aA("SmilesParser: closing bracket at unexpected position"));if(37!=Tn)throw og(new Jl.aA("SmilesParser: unexpected character outside brackets: '"+String.fromCharCode(Tn)+"'"));Q=!0}else jn=!0;else--C;else{if(-1==D[C])throw og(new Jl.aA("Smiles with leading parenthesis are not supported"));++C,D.length==C&&(D=Fl.xOb(D,D.length+32)),D[C]=D[C-1]}}else{if(jn)throw og(new Jl.aA("SmilesParser: unexpected bond symbol inside square brackets: '"+String.fromCharCode(Tn)+"'"));for(P=0;45==Tn||61==Tn||35==Tn||36==Tn||58==Tn||47==Tn||92==Tn||60==Tn||126==Tn||33==Tn||64==Tn;){if(33==Tn)if(64==(Tn=i[s++]&y)&&(j|=128),45==Tn&&62==i[s]||60==Tn&&45==i[s])P|=32,++s;else if(45==Tn)P|=1;else if(61==Tn)P|=2;else if(35==Tn)P|=4;else if(36==Tn)P|=32;else{if(58!=Tn)throw og(new Jl.aA("SmilesParser: bond symbol '"+String.fromCharCode(Tn)+"' not allowed after '!'."));P|=8}else if(64==Tn?j|=256:61==Tn?m=2:35==Tn?m=4:36==Tn?m=8:58==Tn?m=64:126==Tn?j|=31:47==Tn?o&&(m=257):92==Tn?o&&(m=129):(45==Tn&&62==i[s]||60==Tn&&45==i[s])&&(m=32,++s),44==i[s])for(j|=61==(32==m?62:Tn)?2:35==(32==m?62:Tn)?4:36==(32==m?62:Tn)?32:58==(32==m?62:Tn)?8:62==(32==m?62:Tn)?16:126==(32==m?62:Tn)?31:1;44==i[s];)60==i[s+1]&&45==i[s+2]||45==i[s+1]&&62==i[s+2]?(j|=16,s+=3):(j|=xl.Jt(i[s+1]&y),s+=2);if(59!=i[s]){0!=P&&(j|=31&~P);break}++s,Tn=i[s++]&y}}else D[C]=-1,m=512;if(1!=m)throw og(new Jl.aA("SmilesParser: dangling open bond"));for(rn=0,on=(an=fn).length;rn<on;++rn)if(-1!=an[rn])throw og(new Jl.aA("SmilesParser: dangling ring closure"));for(U=xl.co(t.i),xl.Jm(t.i,!0),xl.nu(t.i,1),g=0;g<t.i.q;g++)if(null!=xl.Bk(t.i,g))if(M=xl.Ck(t.i,g)[0],Hn||2==t.k)if(t.g)for(R=0;R<M;R++)xl.Wj(t.i,g,xl.Uj(t.i,1),1);else 0==M&&xl.om(t.i,g,1792,!0),1==M&&xl.om(t.i,g,1664,!0),2==M&&xl.om(t.i,g,1408,!0),3==M&&xl.om(t.i,g,896,!0);else{if(!xl.Fl(t.i,g)&&(!xl.El(t.i,g)||6==xl.Qk(t.i,g)&&0==xl.zk(t.i,g))){for(kn=xl.en(xl.Qk(t.i,g)),I=!1,In=xl.ko(t.i,g),In-=xl.il(t.i,g,In),In+=M,xl.El(t.i,g)&&++In,Nn=0,Un=(wn=kn).length;Nn<Un;++Nn)if(In<=(Mn=wn[Nn])){I=!0,Mn==In+2?xl.pm(t.i,g,48):Mn==In+1?xl.pm(t.i,g,32):(Mn!=In||Mn!=kn[0])&&xl.am(t.i,g,In);break}I||xl.am(t.i,g,In)}if(t.g||!xl.lp(t.i,g))for(R=0;R<M;R++)xl.Wj(t.i,g,xl.Uj(t.i,1),1)}else t.g||!Hn&&2!=t.k||((M=xl.Wn(t.i,g))>=1&&xl.om(t.i,g,128,!0),M>=2&&xl.om(t.i,g,256,!0),M>=3&&xl.om(t.i,g,512,!0),M>=4&&xl.om(t.i,g,hn,!0));if(!t.g&&(Hn||2==t.k)&&xl.dp(t.i,!0),xl.nu(t.i,1),xl.Lt(t),xl.Nt(t,f),t.i.t=null,xl.Jm(t.i,!1),o&&(xl.It(t),en)){for(W=new Fl.MMb(en).a.Td().Fb(),nn=new Fl.TMb(W);nn.a.Fd();)$=nn.a.Gd().Xd(),xl.nm(t.i,$.a,xl._t($,U),!1);xl.gp(t.i,0)}xl.gp(t.i,0),r&&(x=new Xl.yy(t.d),Bg(t.j,0)&&Xl.uy(x,t.j),Xl.fy(x,t.i),o&&xl.Au(t.i)),(Hn||2==t.k)&&xl.Hm(t.i,!0)},xl.Pt=function(n,t,e,i,s){xl.Ot(n,t,e,0,e.length,i,s)},xl.Qt=function(n,t){var e;return null==t?null:xl.Rt(n,Rl.mTb((e=t,Rl.hTb(),e)))},xl.Rt=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h;if(-1==(l=-1==(o=gf.j6(t,0))?-1:gf.j6(t,o+1)))throw og(new Jl.aA("Missing one or both separators ('>')."));if(-1!=gf.j6(t,l+1))throw og(new Jl.aA("Found more than 2 separators ('>')."));for(c=new Ol.EF,a=h=0;a<o-1;a++)46==t[a]&&46==t[a+1]&&(a>h&&(u=new xl.Fu,xl.Ot(n,u,t,h,a,!0,!0),Fl.Si(c.g,u),c.d=-1),h=a+2);if(d=new xl.Fu,xl.Ot(n,d,t,h,o,!0,!0),Fl.Si(c.g,d),c.d=-1,l-o>1){for(r=h=o+1;r<l-1;r++)46==t[r]&&46==t[r+1]&&(r>h&&(e=new xl.Fu,xl.Ot(n,e,t,h,r,!0,!0),Fl.Si(c.a,e)),h=r+2);i=new xl.Fu,xl.Ot(n,i,t,h,l,!0,!0),Fl.Si(c.a,i)}for(s=h=l+1;s<t.length-1;s++)46==t[s]&&46==t[s+1]&&(s>h&&(f=new xl.Fu,xl.Ot(n,f,t,h,s,!0,!0),Fl.Si(c.f,f),c.d=-1),h=s+2);return g=new xl.Fu,xl.Ot(n,g,t,h,t.length,!0,!0),Fl.Si(c.f,g),c.d=-1,c},xl.St=function(n,t){var e,i,s,a;for(1==xl.el(n.i,t)&&xl.Fm(n.i,t,2),s=0;s<2;s++)for(e=xl.Vk(n.i,s,t),xl.El(n.i,e)&&(xl.lm(n.i,e,!1),--n.b),a=0;a<xl.Sn(n.i,e);a++)i=xl.Tn(n.i,e,a),n.f[i]&&(n.f[i]=!1,--n.c)},xl.Tt=function(n){var t,e,i,s,a,r,o;do{for(o=!1,e=0;e<n.i.g;e++)if(n.f[e]){for(a=!1,s=0;s<2;s++){for(t=!1,i=xl.Vk(n.i,s,e),r=0;r<xl.Sn(n.i,i);r++)if(e!=xl.Tn(n.i,i,r)&&n.f[xl.Tn(n.i,i,r)]){t=!0;break}if(!t){a=!0;break}}a&&(o=!0,xl.St(n,e))}}while(o)},xl.Ut=function(n,t){var e,i;if(!xl.is(xl.Qk(n.i,t)))return!1;if(6==xl.Qk(n.i,t)){if(!xl.El(n.i,t))return!1;if(xl.zk(n.i,t)>0)return!1}if(e=null==xl.Bk(n.i,t)?0:xl.Ck(n.i,t)[0],(i=xl.ao(n.i,t)-e)<1)return!1;if(16==xl.Qk(n.i,t)||34==xl.Qk(n.i,t)||52==xl.Qk(n.i,t)){if(2==xl.Sn(n.i,t)&&xl.zk(n.i,t)<=0)return!1;if(2==i)return!1}return!0},xl.Vt=function(n,t){n.j=t},xl.Wt=function(n,t){n.e&&(!n.n&&(n.n=new Jl.jIb),Jl.gIb(n.n," "),Jl.gIb(n.n,t))},xl.Xt=function(){xl.Yt.call(this,0,!1)},xl.Yt=function(n,t){this.k=3&n,this.a=0==(16&n),this.e=t,this.g=0!=(8&n),this.d=2,0!=(4&n)&&(this.d|=1),this.g&&(this.d&=-3)},zf(151,1,{},xl.Xt,xl.Yt),o.a=!1,o.b=0,o.c=0,o.d=0,o.e=!1,o.g=!1,o.j=0,o.k=0,kl.cmb=lg(151),xl.Zt=function(n,t){this.a=n,this.b=t},zf(210,1,{210:1},xl.Zt),o.a=0,o.b=0,kl.amb=lg(210),xl.$t=function(n,t,e){if(!n.c){if(4==n.e.a.length)return void(n.c=!0);Fl.Si(n.e,new xl.Zt(t,e))}},xl._t=function(n,t){var e,i;if(n.c)return 3;for(i=new Fl.rOb(n.e);i.a<i.c.a.length;)2147483646!=(e=Fl.qOb(i)).a&&e.a!=I&&(e.a=t[e.a]);if(3==n.e.a.length)Fl.Si(n.e,new xl.Zt(I,n.b));else if(4!=n.e.a.length)return 3;return n.d^xl.au(n)?1:2},xl.au=function(n){var t,e,i;for(e=!1,t=1;t<n.e.a.length;t++)for(i=0;i<t;i++)Fl.Xi(n.e,i).a>Fl.Xi(n.e,t).a&&(e=!e),Fl.Xi(n.e,i).b>Fl.Xi(n.e,t).b&&(e=!e);return e},xl.bu=function(n,t,e,i,s){0!=i&&1!=i?this.c=!0:(this.a=n,this.b=t,this.d=s,this.e=new Fl.kj,-1!=e&&xl.$t(this,e,t-1),-1!=e&&1==i&&xl.$t(this,2147483646,t+1))},zf(252,1,{252:1},xl.bu),o.a=0,o.b=0,o.c=!1,o.d=!1,kl.bmb=lg(252),xl.cu=function(n,t,e,i){return n.a=!1,n.d=e,Vg(t[e]&y)?(n.c=n.b=xl.du(n),n.d-e):123==t[e]&&Vg(t[e+1]&y)?(++n.d,n.c=xl.du(n),45!=t[n.d++]?0:Vg(t[n.d]&y)?(n.b=xl.du(n),125!=t[n.d++]?0:n.d-e):0):(n.c=1,n.b=i,n.a=!0,0)},xl.du=function(n){var t;return t=n.e[n.d++]-48,Vg(n.e[n.d]&y)&&(t=10*t+(n.e[n.d++]-48)),t},xl.eu=function(n){return"{"+n.c+"-"+n.b+"}"},xl.fu=function(n){this.e=n},zf(385,1,{},xl.fu),o.lb=function(){return xl.eu(this)},o.a=!1,o.b=0,o.c=0,o.d=0,kl.dmb=lg(385),xl.hu=function(n){n.c=new Fl.kj},xl.iu=function(n,t){var e,i,s,a;if(0==(a=n.c.a.length))return Fl.Ri(n.c,0,t),0;for(s=1;2*s<=a;)s<<=1;for(i=s,--s;0!=i;)if(i>>=1,s>=a)s-=i;else{if(0==(e=Jl.yHb(t,Fl.Xi(n.c,s))))return-1;if(0==i)break;e<0?s-=i:s+=i}return s<a&&Jl.yHb(t,Fl.Xi(n.c,s))>0&&++s,Fl.Ri(n.c,s,t),s},xl.ju=function(n,t){var e,i,s,a;if(0==(a=n.c.a.length))return-1;for(s=1;2*s<=a;)s<<=1;for(i=s,--s;0!=i;)if(i>>=1,s>=a)s-=i;else{if(0==(e=Jl.yHb(t,Fl.Xi(n.c,s))))return s;if(0==i)break;e<0?s-=i:s+=i}return-1},xl.ku=function(){xl.hu(this)},zf(115,1,Ae,xl.ku),o.Pb=function(n){return xl.ju(this,n)},kl.emb=lg(115),xl.mu=function(n,t){xl.nk(n,t),n.d&&(t.T=0)},xl.nu=function(n,t){var e,i,s,a;if(xl.wn(n,t),0!=(t&~n.T)){for(0!=(15&n.T)&&n.q>1&&xl.Ih(n.J[0],n.J[1])&&Xl.fy(new Xl.yy(0),n),n.c&&(t|=128),e=0;e<n.q;e++)n.u[e]&=-67223560;for(i=0;i<n.g;i++)n.F[i]&=-64;s=0,a=0,0!=(32&t)?(s=32,a=1):0!=(64&t)&&(s=64,a=3),0!=(128&t)&&(s|=128,a|=32),n.d=new xl.ig(n,a),xl.dg(n.d),xl.eg(n.d),xl.cg(n.d),xl.Eu(n)&&(n.d=new xl.ig(n,a)),n.T|=24|s}},xl.ou=function(n,t){return xl.Sf(n.d,t)},xl.pu=function(n,t){return xl.Jf(n.d,t)},xl.qu=function(n){var t;switch(xl.nu(n,31),t=n.I&y,n.I&$n){case J:return null;case gt:return 1==t?"meso":t+" meso diastereomers";case 0:return"unknown chirality";case ut:return"both enantiomers";case Wn:return"this enantiomer";case 327680:return"this or other enantiomer";case Mn:return"two epimers";default:return 1==t?"one stereo isomer":t+" stereo isomers"}},xl.ru=function(n){var t;return t=new xl.Gu(n.q,n.r),xl.mk(n,t),t},xl.su=function(t){var e,i,s,a,r,o,l;for(xl.nu(t,15),o=vf(kl.llb,z,6,3,15,1),i=0;i<t.f;i++)0!=(t.u[i]&Ut)&&0!=(l=(t.u[i]&Vn)>>18)&&(o[l]=n.Math.max(o[l],(t.u[i]&Vn)>>18!=1&&(t.u[i]&Vn)>>18!=2?-1:(t.u[i]&Mt)>>20));for(a=0;a<t.g;a++)1!=(3&t.F[a])&&2!=(3&t.F[a])||1!=t.H[a]||0!=(l=(768&t.F[a])>>8)&&(o[l]=n.Math.max(o[l],(768&t.F[a])>>8!=1&&(768&t.F[a])>>8!=2?-1:(t.F[a]&wt)>>10));for((r=vf(kl.llb,ot,8,3,0,2))[1]=vf(kl.llb,z,6,1+o[1],15,1),r[2]=vf(kl.llb,z,6,1+o[2],15,1),e=0;e<t.f;e++)0!=(t.u[e]&Ut)&&0!=(l=(t.u[e]&Vn)>>18)&&++r[l][(t.u[e]&Vn)>>18!=1&&(t.u[e]&Vn)>>18!=2?-1:(t.u[e]&Mt)>>20];for(s=0;s<t.g;s++)1!=(3&t.F[s])&&2!=(3&t.F[s])||1!=t.H[s]||0!=(l=(768&t.F[s])>>8)&&++r[l][(768&t.F[s])>>8!=1&&(768&t.F[s])>>8!=2?-1:(t.F[s]&wt)>>10];return r},xl.tu=function(n){var t,e;return t=vf(kl.llb,z,6,n.q,15,1),e=xl.$n(n,t,!1,!1),xl.uu(n,t,e)},xl.uu=function(n,t,e){var i,s,a,r,o,l,f,g,u,d,c,h,b,D;for(b=vf(kl.fmb,le,24,e,0,1),r=vf(kl.llb,z,6,e,15,1),f=vf(kl.llb,z,6,e,15,1),a=vf(kl.llb,z,6,n.q,15,1),s=0;s<n.q;s++)-1!=t[s]&&(a[s]=r[t[s]]++);for(l=0;l<n.r;l++)(h=t[n.D[0][l]])==t[n.D[1][l]]&&-1!=h&&++f[h];for(D=0;D<e;D++)b[D]=new xl.Gu(r[D],f[D]),xl.mu(n,b[D]);for(i=0;i<n.q;i++)-1!=t[i]&&xl.jk(n,b[t[i]],i,0,0);for(o=0;o<n.r;o++)(h=t[n.D[0][o]])==t[n.D[1][o]]&&-1!=h&&xl.lk(n,b[h],o,0,0,a,!1);for(d=0,c=(u=b).length;d<c;++d)g=u[d],xl.Yl(g,1),xl.Yl(g,2);return b},xl.vu=function(n){return xl.nu(n,15),!n.d&&(n.f<2||!xl.Ih(n.J[0],n.J[1]))&&(n.d=new xl.hg(n)),n.d?xl.Nf(n.d):null},xl.wu=function(n){return xl.nu(n,15),!n.d&&(n.f<2||!xl.Ih(n.J[0],n.J[1]))&&(n.d=new xl.hg(n)),n.d?xl.Kf(n.d):null},xl.xu=function(n){var t,e;for(xl.nu(n,31),e=0,t=0;t<n.f;t++)0!=(3&n.u[t])&&0==(4&n.u[t])&&++e;return e},xl.yu=function(n,t){return xl.Rf(n.d,t)},xl.zu=function(n,t){n.c=t,n.T&=-144},xl.Au=function(n){xl.nu(n,31),n.d&&xl.fg(n.d)},xl.Bu=function(n){var t,e;for(xl.nu(n,15),n.L=!1,t=0;t<n.q;t++)n.u[t]&=yt,0!=(3&n.u[t])?n.u[t]|=Lt:n.u[t]&=Jt;for(e=0;e<n.r;e++)0!=(3&n.F[e])&&2==xl.bl(n,e)?n.H[e]=386:n.H[e]&=-385;n.T&=-249},xl.Cu=function(n,t,e){var i,s,a,r,o,l,f,g,u;if(1==(u=3&n.u[t])||2==u){if(o=!1,2==n.o[t]&&2==n.j[t]&&2==n.n[t][0]&&2==n.n[t][1]&&n.C[t]<=7)for(r=0;r<n.j[t];r++){for(i=n.i[t][r],g=0,f=vf(kl.llb,z,6,3,15,1),l=0;l<n.j[i];l++)f[g]=n.i[i][l],f[g]!=t&&++g;2==g&&f[0]<f[1]^e[f[0]]<e[f[1]]&&(o=!o)}else for(r=1;r<n.j[t];r++)for(l=0;l<r;l++)(s=n.i[t][r])<(a=n.i[t][l])^e[s]<e[a]&&(o=!o);o&&(u=1==u?2:1)}return u},xl.Du=function(t){var e,i,s,a,r,o;for(xl.mp(t),xl.nu(t,31),s=0;s<t.f;s++){if(!((t.u[s]&Vn)>>18!=1&&(t.u[s]&Vn)>>18!=2||0!=(t.u[s]&Ut)&&3!=(3&t.u[s])))throw og(new Jl.aA(Ce));if(0!=(t.u[s]&J))throw og(new Jl.aA(Te));if((1==(3&t.u[s])||2==(3&t.u[s]))&&0==t.o[s]){for(e=vf(kl.jlb,S,6,t.j[s],15,1),r=0;r<t.j[s];r++)e[r]=xl.Uk(t,s,t.i[s][r]);for(a=1;a<t.j[s];a++)if(!xl.Ml(t,t.k[s][a],s))for(o=0;o<a;o++)if(!xl.Ml(t,t.k[s][o],s)&&((i=n.Math.abs(xl.gn(e[a],e[o])))<.08||i>Qt))throw og(new Jl.aA(pe))}}},xl.Eu=function(n){var t,e,i,s,a,r,o;for(o=!1,e=0;e<n.f;e++)(0==(n.u[e]&Ut)||3==(3&n.u[e]))&&(n.u[e]&=yt);for(a=0;a<n.g;a++)(1!=xl.bl(n,a)||0==(3&n.F[a])||3==(3&n.F[a]))&&(n.F[a]&=-32513);if(n.L){if((n.I&$n)!=gt){for(r=vf(kl.Cwb,nn,6,n.f,16,1),i=0;i<n.f;i++)0!=(n.u[i]&Ut)&&3!=(3&n.u[i])&&(n.u[i]&Vn)>>18==1&&(r[i]=!0);for(s=0;s<n.f;s++)0!=(n.u[s]&Ut)&&3!=(3&n.u[s])&&(xl.hm(n,s,1,0),o=!0);for(t=0;t<n.f;t++)r[t]&&(xl.nm(n,t,1,!1),xl.hm(n,t,1,-1),o=!0)}n.L=!1}return xl.Yl(n,1),xl.Yl(n,2),o},xl.Fu=function(){xl.Sj(),xl.op.call(this)},xl.Gu=function(n,t){xl.Sj(),xl.pp.call(this,n,t)},xl.Hu=function(n){xl.Sj(),xl.qp.call(this,n)},zf(24,97,Ie,xl.Fu,xl.Gu,xl.Hu),o.Kb=function(n){xl.mu(this,n)},o.Mb=function(n){xl.nu(this,n)},o.c=!1,kl.fmb=lg(24),xl.Lu=function(n,t){var e,i,s,a,r,o,l,f,g,u,d;for(o=new Fl.kj,xl.nu(t,1),f=vf(kl.Cwb,nn,6,t.f,16,1),e=0;e<t.f;e++)if(n.f[e]&&(7==xl.Qk(n.i,e)||8==xl.Qk(n.i,e)||16==xl.Qk(n.i,e)||34==xl.Qk(n.i,e)||52==xl.Qk(n.i,e))){for(f[e]=!0,l=0;l<t.j[e];l++)if(i=t.i[e][l],a=t.k[e][l],u=t.n[e][l],0!=t.o[i]&&t.o[e]<u){for(f[i]=!0,Fl.Si(o,Jl.UGb(a)),g=0;g<t.j[i];g++)f[s=t.i[i][g]]||(f[s]=!0,r=t.k[i][g],d=t.n[i][g],t.o[i]+2==u+d&&(Fl.Si(o,Jl.UGb(r)),u>=d&&(t.o[s]<d?xl.Uu(t,s)&&xl.Ou(n,t,s,!0,!1,f,o):xl.Ou(n,t,s,!0,!0,f,o)),d>=u&&xl.Uu(t,e)&&xl.Ou(n,t,s,!1,!1,f,o),n.f[s]&&(5==xl.Qk(n.i,s)||6==xl.Qk(n.i,s)||7==xl.Qk(n.i,s)||8==xl.Qk(n.i,s)||16==xl.Qk(n.i,s)||34==xl.Qk(n.i,s)||52==xl.Qk(n.i,s))&&t.o[s]<d&&(u<=2&&d>=2&&xl.Uu(t,e)&&xl.Mu(n,t,a,r),u>=2&&d<=2&&xl.Uu(t,s)&&xl.Mu(n,t,r,a)),Fl.cj(o,o.a.length-1)),f[s]=!1);Fl.cj(o,o.a.length-1),f[i]=!1}f[e]=!1}},xl.Mu=function(n,t,e,i){var s;s=new xl.$u(n,t),xl.Zu(s,e,1==xl.bl(t,e)?2:3),xl.Zu(s,i,2==xl.bl(t,i)?1:2),n.g[e]=!0,n.g[i]=!0,Fl.$Rb(n.e,s)&&Fl.MNb(n.d,s)},xl.Nu=function(n,t){Fl.$Rb(n.e,t)&&Fl.MNb(n.d,t)},xl.Ou=function(n,t,e,i,s,a,r){var o,l,f,g,u,d,c,h,b,D,H;for(c=0;c<t.j[e];c++)if(!a[o=t.i[e][c]]&&(g=t.k[e][c],D=xl.bl(t,g),i&&D>=2||!i&&D<=2)){for(a[o]=!0,r.add(Jl.UGb(g)),h=0;h<t.j[o];h++)if(!a[l=t.i[o][h]]&&(u=t.k[o][h],H=xl.bl(t,u),t.o[o]+2==D+H&&(i&&H<=2||!i&&H>=2))){if(a[l]=!0,r.add(Jl.UGb(u)),!n.f[l]||5!=xl.Qk(n.i,l)&&6!=xl.Qk(n.i,l)&&7!=xl.Qk(n.i,l)&&8!=xl.Qk(n.i,l)&&16!=xl.Qk(n.i,l)&&34!=xl.Qk(n.i,l)&&52!=xl.Qk(n.i,l)||i&&!xl.Uu(t,l))xl.Ou(n,t,l,i,s,a,r);else{for(d=new xl.$u(n,t),b=0;b<r.a.length;b++)f=(Rl.zTb(b,r.a.length),r.a[b]).a,(b<2?i^0==(1&b):s^0==(1&b))?xl.Zu(d,f,1==xl.bl(t,f)?2:3):xl.Zu(d,f,2==xl.bl(t,f)?1:2),n.g[f]=!0;Fl.$Rb(n.e,d)&&Fl.MNb(n.d,d)}Fl.cj(r,r.a.length-1),a[l]=!1}Fl.cj(r,r.a.length-1),a[o]=!1}return!1},xl.Pu=function(n){var t,e,i,s,a,r,o,l,f,g,u;for(n.b=vf(kl.llb,z,6,n.i.f,15,1),o=vf(kl.llb,z,6,n.i.f,15,1),i=vf(kl.Cwb,nn,6,n.i.g,16,1),u=0,e=0;e<n.i.g;e++)if(!i[e]&&n.g[e])for(++u,n.b[xl.Vk(n.i,0,e)]=u,n.b[xl.Vk(n.i,1,e)]=u,i[e]=!0,f=0;f<2;f++)for(t=xl.Vk(n.i,f,e),n.b[t]=u,r=0,l=0,o[0]=t;r<=l;){for(g=0;g<xl.Sn(n.i,o[r]);g++)!i[a=xl.Tn(n.i,o[r],g)]&&n.g[a]&&(i[a]=!0,s=xl.Rn(n.i,o[r],g),0==n.b[s]&&(n.b[s]=u,o[++l]=s));++r}n.j=u},xl.Qu=function(n){var t,e,i;for(n.n=vf(kl.llb,z,6,n.j,15,1),n.k=vf(kl.llb,z,6,n.j,15,1),n.o=vf(kl.llb,z,6,n.j,15,1),t=0;t<n.i.f;t++)0!=n.b[t]&&(i=n.b[t]-1,null!=n.a&&(n.k[i]+=n.a[t]),null!=n.c&&(n.o[i]+=n.c[t]));for(e=0;e<n.i.g;e++)n.g[e]&&2==xl.bl(n.i,e)&&(n.n[n.b[xl.Vk(n.i,0,e)]-1]+=2)},xl.Ru=function(n){var t,e,i,s;for(i=0;i<n.i.r;i++)for(s=0;s<2;s++)t=xl.Vk(n.i,s,i),e=xl.Vk(n.i,1-s,i),1==xl.Qk(n.i,t)&&xl.Jk(n.i,t)>1&&xl.Qk(n.i,e)>1&&0!=n.b[e]&&(2==xl.Jk(n.i,t)?(null==n.a&&(n.a=vf(kl.llb,z,6,n.i.q,15,1)),++n.a[e]):(null==n.c&&(n.c=vf(kl.llb,z,6,n.i.q,15,1)),++n.c[e]),xl.Ol(n.i,t));(null!=n.a||null!=n.c)&&xl.tk(n.i)},xl.Su=function(n){var t;for(n.e=new Fl.dSb,n.d=new Fl.YNb,xl.Nu(n,new xl.$u(n,n.i)),t=xl.ru(n.i);!Fl.QNb(n.d);)if(xl.Yu(Fl.SNb(n.d),t),xl.Lu(n,t),n.e.a.c>=xl.Ku){Jl.oIb(),xl.Nf(new xl.hg(n.i));break}},xl.Tu=function(n){var t,e,i,s,a,r,o,l,f,g;if(1==n.e.a.c)return n.i;for(f=xl.ru(n.i),xl.Hm(f,!0),xl.nu(f,7),s=0;s<f.g;s++)n.g[s]&&(f.H[s]=1,f.T=0,xl.Em(f,s,3,!0));for(e=0;e<f.f;e++)0!=n.b[e]&&xl.jo(n.i,e)<4&&(xl.tn(f,e),f.u[e]&=Jt,f.T&=7,xl.hm(f,e,0,-1));for(o=vf(kl.llb,z,6,n.j,15,1),l=vf(kl.llb,z,6,n.j,15,1),i=new xl.hg(f).d,t=0;t<f.f;t++)0!=n.b[t]&&l[g=n.b[t]-1]<i[t]&&(l[g]=i[t],o[g]=t);for(a=0;a<n.j;a++)r=n.n[a]+"|"+n.k[a]+"|"+n.o[a],xl.fm(f,o[a],r);return f},xl.Uu=function(n,t){return!(n.e[t]-xl.jo(n,t)+xl.fo(n,t)<=0)&&(!!xl.Cl(n,t)||0==n.o[t])},xl.Vu=function(n){var t,e,i,s,a,r,o,l;xl.nu(n.i,1),o=n.i.f;do{--o}while(o>=0&&1==xl.Qk(n.i,o));for(t=0;t<o;t++)if(1==xl.Qk(n.i,t)){xl.Sm(n.i,t,o);do{--o}while(1==xl.Qk(n.i,o))}if(o!=n.i.f-1){for(r=vf(kl.Cwb,nn,6,n.i.g,16,1),a=0;a<n.i.g;a++)e=xl.Vk(n.i,0,a),i=xl.Vk(n.i,1,a),(1==xl.Qk(n.i,e)||1==xl.Qk(n.i,i))&&(r[a]=!0);l=n.i.g;do{--l}while(l>=0&&r[l]);for(s=0;s<l;s++)if(r[s]){xl.Tm(n.i,s,l),r[s]=!1;do{--l}while(r[l])}}},xl.Wu=function(n){var t,e;for(this.i=xl.ru(n),xl.Vu(this),xl.nu(this.i,7),this.g=vf(kl.Cwb,nn,6,this.i.g,16,1),this.f=vf(kl.Cwb,nn,6,this.i.f,16,1),t=0;t<this.i.f;t++)e=xl.en(xl.Qk(this.i,t))[0],this.f[t]=xl.jo(this.i,t)<e;xl.Su(this),xl.Pu(this),xl.Ru(this),xl.Qu(this)},zf(275,1,{},xl.Wu),o.j=0,xl.Ku=Pe,kl.hmb=lg(275),xl.Xu=function(n,t){return gf.v6(n.a,t.a)},xl.Yu=function(n,t){var e,i;for(i=0;i<n.b.i.g;i++)n.b.g[i]&&(e=3&n.a[i>>4]>>2*(15&i),xl.Fm(t,i,1==e?1:2==e?n.b.g[i]&&!xl.Yo(n.b.i,i)?386:2:3==e?4:32))},xl.Zu=function(n,t,e){var i,s;i=t>>4,s=2*(15&t),n.a[i]&=~(3<<s),n.a[i]|=e<<s},xl.$u=function(t,e){var i;for(this.b=t,this.a=vf(kl.llb,z,6,(t.i.g+15)/16|0,15,1),i=0;i<t.i.g;i++)this.a[i>>4]|=n.Math.min(3,xl.bl(e,i))<<2*(15&i)},zf(183,1,{183:1,18:1},xl.$u),o.Eb=function(n){return xl.Xu(this,n)},kl.gmb=lg(183),xl.av=function(n){var t,e,i,s,a;if(-1==(e=Jl.HHb(n,bg(38))))return n;for(s=0,a=new Jl._Hb;-1!=e;)Jl.$Hb(a,(Rl.FTb(s,e,Rl.LTb(n).length),Rl.LTb(n).substr(s,e-s))),Rl.GTb(e+1,Rl.LTb(n).length),38==Rl.LTb(n).charCodeAt(e+1)?(a.a+="&",s=e+2):(Rl.GTb(e+1,Rl.LTb(n).length),t=Rl.LTb(n).charCodeAt(e+1),t-=t<65?48:t<97?65:97,Rl.GTb(e+2,Rl.LTb(n).length),i=Rl.LTb(n).charCodeAt(e+2),i-=i<65?48:i<97?65:97,Jl.YHb(a,16*t+i&y),s=e+3),e=Jl.IHb(n,bg(38),s);return Jl.$Hb(a,(Rl.GTb(s,Rl.LTb(n).length+1),Rl.LTb(n).substr(s))),a.a},xl.bv=function(n){var t,e;for(e=new Jl._Hb,t=0;t<Rl.LTb(n).length;t++)switch(Rl.GTb(t,Rl.LTb(n).length),Rl.LTb(n).charCodeAt(t)){case 38:e.a+="&&";break;case 9:e.a+="&09";break;case 10:e.a+="&0A";break;case 32:e.a+="&20";break;default:Jl.YHb(e,(Rl.GTb(t,Rl.LTb(n).length),Rl.LTb(n).charCodeAt(t)))}return e.a},xl.cv=function(n,t,e){n.e[0].a=t,n.e[0].b=e},xl.dv=function(n,t){try{n.a=tu(t)}catch(n){if(!_f(n=rg(n),53))throw og(n)}},xl.ev=function(n,t){try{n.b=Jl.nGb(t,Vt,I)}catch(n){if(!_f(n=rg(n),53))throw og(n)}},xl.fv=function(n,t,e,i){n.c=t,n.a=e,n.b=i},xl.gv=function(n,t){try{n.e[0].a=tu(t)}catch(n){if(!_f(n=rg(n),53))throw og(n)}},xl.hv=function(n,t){try{n.e[0].b=tu(t)}catch(n){if(!_f(n=rg(n),53))throw og(n)}},xl.iv=function(){xl.kv.call(this,new Kl.AG)},xl.jv=function(n){var t,e,i,s;for(xl.iv.call(this),t=0;-1!=t&&-1!=(e=Rl.LTb(n).indexOf('="',t));)Rl.FTb(t+1,e,Rl.LTb(n).length),i=Rl.LTb(n).substr(t+1,e-(t+1)),s=-1==(t=Rl.LTb(n).indexOf('"',e+2))?(Rl.GTb(e+1,Rl.LTb(n).length+1),Rl.LTb(n).substr(e+1)):(Rl.FTb(e+1,t,Rl.LTb(n).length),Rl.LTb(n).substr(e+1,t-(e+1))),Jl.DHb(i,At)?this.c=xl.av(s):Jl.DHb(i,"x")?xl.gv(this,s):Jl.DHb(i,"y")?xl.hv(this,s):Jl.DHb(i,"size")?xl.dv(this,s):Jl.DHb(i,Me)&&xl.ev(this,s)},xl.kv=function(n){this.c="",this.a=9,this.b=0,this.e=vf(kl.Bnb,N,33,1,0,1),this.e[0]=n},zf(188,230,{230:1},xl.iv,xl.jv),o.Ab=function(){var n;return n=new xl.iv,xl.fv(n,this.c,this.a,this.b),xl.cv(n,this.e[0].a,this.e[0].b),n.d=this.d,n},o.Bb=function(){var n;return n=new Jl.jIb,Jl.gIb(n,' text="'+xl.bv(this.c)+'"'),Jl.gIb(n,' x="'+this.e[0].a+'"'),Jl.gIb(n,' y="'+this.e[0].b+'"'),9!=this.a&&Jl.gIb(n,' size="'+this.a+'"'),0!=this.b&&Jl.gIb(n,' style="'+this.b+'"'),n.a},o.Cb=function(){return At},o.a=0,o.b=0,kl.imb=lg(188),xl.ov=function(n){n.b=new Fl.kj,n.a=new Fl.kj},xl.pv=function(n,t){var e,i;return-1==(e=xl.iu(n,t))?-1:(i=n.b.a.length,Fl.Si(n.b,t),Fl.Ri(n.a,e,new Jl.IGb(i)),i)},xl.qv=function(){xl.ku.call(this),xl.ov(this)},zf(384,115,Ae,xl.qv),o.Pb=function(n){var t;return-1==(t=xl.ju(this,n))?-1:Fl.Xi(this.a,t).a},kl.jmb=lg(384),Ql.sv=function(t,e){var i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,j,m,A,C,T,p,I,P,M,w,N,L,U,k,J,y,B,R;for(J=xl.so(t.e),y=Fl.Xi(J.j,e).length,U=Fl.Xi(J.i,e),k=Fl.Xi(J.j,e),P=!0,H=1;H<y;H++)if(Ql.Hv(t.b,k[H])!=Ql.Hv(t.b,k[0])){P=!1;break}if(P)for(r=(y-2)*we/y,j=0;j<y;j++)Ql.xv(t,U[j],k[j],k[0==j?y-1:j-1],r);else{for(N=vf(kl.klb,xt,6,y,15,1),a=0,m=0;m<y;m++)N[m]=0==xl.In(t.e,U[m])?1.9106119386631804:1==xl.In(t.e,U[m])?2.094499897810209:we,a+=N[m];for(s=((y-2)*we-a)/y,A=0;A<y;A++)N[A]+=s;for(u=vf(kl.klb,xt,6,y,15,1),C=1;C<y;C++)u[C]=u[C-1]+we-N[C];for(l=vf(kl.klb,xt,6,y,15,1),o=0;o<100;o++){for(B=0,R=0,j=0;j<y;j++)B+=Ql.Hv(t.b,k[j])*n.Math.sin(u[j]),R+=Ql.Hv(t.b,k[j])*n.Math.cos(u[j]);for(h=xl.fn(0,0,B,R),b=n.Math.sqrt(B*B+R*R),w=-1,M=0,T=0;T<y;T++)p=0==T?y-1:T-1,I=T+1==y?0:T+1,f=xl.gn(u[T],u[p]),g=xl.gn(u[I],u[T]),L=xl.gn(N[T],N[I]),l[T]=2*f-2*g+2*L,c=b*n.Math.cos(u[T]-Ne-h)-Le*l[T],n.Math.abs(c)>n.Math.abs(M)&&(M=c,w=T);d=n.Math.exp(-5*o/100),u[w]+=d*M}for(D=0;D<y;D++)(i=u[p=0==D?y-1:D-1]+we-u[D])>an&&(i-=an),Ql.xv(t,U[D],k[p],k[D],i)}},Ql.tv=function(n,t){var e,i,s,a,r,o,l,f,g;for(l=xl.so(n.e),f=Fl.Xi(l.j,t).length,o=Fl.Xi(l.j,t),g=!1,s=0;s<f;s++)if(0==n.f[o[s]]){g=!0;break}if(g){for(e=(180*f-360)/f*.01745329238474369,r=Fl.Xi(l.i,t),a=0;a<f;a++)Ql.xv(n,r[a],o[0==a?f-1:a-1],o[a],e);if(f<=4)for(i=0;i<f;i++)n.f[o[i]]+=f}},Ql.uv=function(n,t,e,i){var s,a,r,o;for(a=-1,r=-1,o=0;o<xl.Dn(n.e,t);o++)if((s=xl.Rn(n.e,t,o))==e||s==i){if(-1!=r){a=o;break}r=o}return n.a[t][a][r]},Ql.vv=function(n,t,e,i){return e<i?n.a[t][i][e]:n.a[t][e][i]},Ql.wv=function(n,t){var e,i,s,a,r,o,l;for(i=vf(kl.Cwb,nn,6,xl.Sn(n.e,t),16,1),l=0,s=0;s<xl.Sn(n.e,t);s++){for(o=0,r=-1,a=0;a<xl.Sn(n.e,t);a++)i[a]||(e=xl.Tn(n.e,t,a),o<n.f[e]&&(o=n.f[e],r=a));if(0==o)return l;l<<=8,l+=o,i[r]=!0}return l},Ql.xv=function(n,t,e,i,s){var a,r,o,l;for(a=-1,r=-1,l=0;l<xl.Dn(n.e,t);l++)if((o=xl.Tn(n.e,t,l))==e||o==i){if(-1!=a){r=l;break}a=l}0==n.a[t][r][a]&&(n.a[t][r][a]=s,n.d[t]+=s,++n.c[t])},Ql.yv=function(n,t,e,i,s){var a,r,o,l,f,g;for(a=xl.Dn(n.e,t),l=xl.Sn(n.e,t),f=1;f<a;f++)for(r=f<l?n.f[xl.Tn(n.e,t,f)]:0,g=0;g<f;g++)0==n.a[t][f][g]&&(o=g<l?n.f[xl.Tn(n.e,t,g)]:0,(r==e&&o==i||r==i&&o==e)&&(n.a[t][f][g]=s))},Ql.zv=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,H,m,A,C,T,p;for(this.b=t,this.e=n,this.a=vf(kl.klb,j,679,this.e.f,0,3),s=0;s<this.e.f;s++)for(this.a[s]=vf(kl.klb,{679:1,4:1,9:1,5:1,7:1},59,xl.Dn(this.e,s),0,2),l=1;l<xl.Dn(this.e,s);l++)this.a[s][l]=vf(kl.klb,xt,6,l,15,1);for(this.c=vf(kl.llb,z,6,this.e.f,15,1),this.d=vf(kl.klb,xt,6,this.e.f,15,1),this.f=vf(kl.llb,z,6,this.e.g,15,1),T=xl.so(this.e),d=vf(kl.Cwb,nn,6,T.i.a.length,16,1),xl.Gr(T,d,vf(kl.Cwb,nn,6,T.i.a.length,16,1),vf(kl.llb,z,6,T.i.a.length,15,1),!0),o=3;o<=7;o++)for(H=0;H<T.i.a.length;H++)(p=Fl.Xi(T.j,H).length)==o&&(d[H]?Ql.sv(this,H):p<=4&&Ql.tv(this,H));for(u=vf(kl.Cwb,nn,6,this.e.f,16,1),D=0;D<T.i.a.length;D++)if(d[D])for(A=0,C=(m=Fl.Xi(T.i,D)).length;A<C;++A)u[m[A]]=!0;for(a=Vf(qf(kl.llb,1),z,6,15,[0,0,1,3,6,10,15,21]),i=0;i<this.e.f;i++)if((r=xl.Dn(this.e,i))>4){for(l=1;l<r;l++)for(h=0;h<l;h++)this.a[i][l][h]=Ne;this.c[i]=a[r]}else if(this.c[i]!=a[r])if(xl.Xo(this.e,i)&&(u[i]||xl.Mn(this.e,i)<=4&&xl.In(this.e,i)>0)){if(r>2){if(1==this.c[i])e=xl.Qk(this.e,i)<=14?(Ue-this.d[i])/2:ke+.18000000715255737*(ke-this.d[i]);else if(e=Ue-this.d[i],r>3){if(2==this.c[i]){for(c=vf(kl.Cwb,nn,6,xl.Dn(this.e,i),16,1),f=1;f<r;f++)for(b=0;b<f;b++)0!=this.a[i][f][b]&&(c[f]=!c[f],c[b]=!c[b]);for(g=0;g<r;g++)if(c[g]){for(b=g+1;b<r;b++)if(c[b]){this.a[i][b][g]=e;break}break}}e=Ne}for(l=1;l<r;l++)for(h=0;h<l;h++)0==this.a[i][l][h]&&(this.a[i][l][h]=e)}}else if(xl.Xo(this.e,i)&&xl.Mn(this.e,i)<=4)switch(Ql.wv(this,i)){case 771:Ql.yv(this,i,0,3,2.0653998851776123),Ql.yv(this,i,0,0,1.9814722631346626);break;case 1028:Ql.yv(this,i,0,4,1.9797999858856201),Ql.yv(this,i,0,0,1.94691481878138);break;case 393987:Ql.yv(this,i,0,3,Je),Ql.yv(this,i,0,6,Je),Ql.yv(this,i,3,3,1.7229016938441077);break;case 459779:Ql.yv(this,i,0,3,ye),Ql.yv(this,i,0,4,ye),Ql.yv(this,i,0,7,ye),Ql.yv(this,i,3,4,1.9322539839360076);break;case 525316:Ql.yv(this,i,0,4,Be),Ql.yv(this,i,0,8,Be),Ql.yv(this,i,4,4,1.99944913298566);case 394758:Ql.yv(this,i,0,6,2.526099920272827);break;case 460550:Ql.yv(this,i,0,6,Re),Ql.yv(this,i,0,7,Re);break;case 526087:Ql.yv(this,i,0,7,Ee),Ql.yv(this,i,0,8,Ee);break;case 526344:Ql.yv(this,i,0,8,2.186300039291382);break;case 50529027:Ql.yv(this,i,3,3,2.4189000129699707);break;case 67371779:Ql.yv(this,i,3,4,2.2298998832702637);break;case 67372036:Ql.yv(this,i,4,4,2.094399929046631);break;case 101057283:Ql.yv(this,i,3,6,1.839926051241747),Ql.yv(this,i,3,3,2.9061476191098734);break;case 117834755:Ql.yv(this,i,3,4,2.812249087174905),Ql.yv(this,i,3,7,1.7910569124592968),Ql.yv(this,i,4,6,2.1224948975613245);break;case 134677507:Ql.yv(this,i,3,4,2.642428360523752),Ql.yv(this,i,3,8,2.027723514585844),Ql.yv(this,i,4,7,2.251474717631936);break;case 117900035:Ql.yv(this,i,3,7,2.109753935530918),Ql.yv(this,i,3,3,3.1052897491356646);break;case 117900292:Ql.yv(this,i,4,7,2.090729910747413),Ql.yv(this,i,4,4,2.551671293386306);break;case 134743044:Ql.yv(this,i,4,8,2.139250042271712),Ql.yv(this,i,4,4,2.3520055858942612)}else for(e=xl.Qk(this.e,i)>10?xe:2==xl.In(this.e,i)?we:xl.Oo(this.e,i,!0)?Fe:0==xl.In(this.e,i)?xe:Fe,l=1;l<r;l++)for(h=0;h<l;h++)this.a[i][l][h]=e},zf(525,1,{},Ql.zv),kl.kmb=lg(525),Ql.Gv=function(){Ql.Gv=Sf,Ql.Ev=Vf(qf(kl.Cwb,1),nn,6,16,[!1,!1,!1,!1,!1,!0,!0,!0,!0,!1,!1,!1,!1,!1,!1,!0,!0])},Ql.Hv=function(n,t){return n.a[t]},Ql.Iv=function(n){var t,e;for(Ql.Gv(),xl.nu(n,7),this.a=vf(kl.klb,xt,6,n.r,15,1),this.b=vf(kl.klb,xt,6,n.r,15,1),t=0;t<n.r;t++)-1==(e=Ql.Lv(n,t))?(this.a[t]=Ql.Mv(n,t),this.b[t]=Ql.Nv(n,t)):(this.a[t]=-1==e?2.000499963760376:Ql.Cv[e],this.b[t]=-1==e?1:Ql.Dv[e])},Ql.Jv=function(n,t){return t>=n.f?0:t<n.f&&xl.Ur(n.p,t)&&6==n.C[t]&&0!=n.s[t]?1:n.o[t]},Ql.Kv=function(n,t,e,i,s,a,r){var o,l;return((e?0:t?4+n:n)<<24)+((o=(i<Ql.Ev.length&&Ql.Ev[i]?a<<8:0)+i)<(l=(s<Ql.Ev.length&&Ql.Ev[s]?r<<8:0)+s)?(o<<12)+l:(l<<12)+o)},Ql.Lv=function(n,t){var e,i,s,a;return e=n.D[0][t],i=n.D[1][t],s=n.C[e],a=n.C[i],Ql.Pv(Ql.Kv(xl.bl(n,t),t<n.g&&xl.Vr(n.p,t),t<n.g&&(xl.Zr(n.p,t)||64==n.H[t]),s,a,Ql.Jv(n,e),Ql.Jv(n,i)))},Ql.Mv=function(n,t){var e,i;return e=xl.Qk(n,n.D[0][t]),i=xl.Qk(n,n.D[1][t]),(e<(Ql.mx(),Ql.kx).length?Ql.kx[e]:e<Ql.lx.length?Qe*Ql.lx[e]:Se)+(i<Ql.kx.length?Ql.kx[i]:i<Ql.lx.length?Qe*Ql.lx[i]:Se)},Ql.Nv=function(n,t){var e,i;return e=xl.Qk(n,n.D[0][t]),i=xl.Qk(n,n.D[1][t]),(e<(Ql.mx(),Ql.kx).length?Xe:.125)+(i<Ql.kx.length?Xe:.125)},Ql.Ov=function(){var n,t,e,i,s,a;if(!Ql.Fv){for(e=(n=Jl.OHb("2312\n4099\t2.403\t0.282\t466\n4100\t1.407\t0.2\t28\n4103\t1.561\t0.023\t5\n4104\t1.42\t0.092\t491\n4105\t1.313\t0.149\t32\n4107\t2.677\t0.401\t190\n4108\t2.118\t0.244\t325\n4109\t1.978\t0.26\t968\n4113\t1.819\t0.033\t4\n4115\t3.194\t0.482\t381\n4116\t2.771\t0.32\t198\n4117\t2.398\t0.235\t145\n4118\t2.317\t0.22\t208\n4119\t2.034\t0.212\t34\n4120\t2.033\t0.286\t103\n4121\t1.959\t0.264\t122\n4122\t1.918\t0.267\t664\n4123\t1.893\t0.257\t185\n4124\t1.877\t0.218\t259\n4125\t2.05\t0.257\t556\n4126\t2.012\t0.239\t129\n4127\t1.979\t0.292\t196\n4133\t3.305\t0.429\t34\n4134\t2.593\t0.367\t83\n4135\t2.74\t0.174\t706\n4136\t2.462\t0.196\t611\n4137\t2.207\t0.264\t78\n4138\t2.16\t0.225\t359\n4140\t2.004\t0.188\t2204\n4141\t1.916\t0.256\t610\n4142\t1.95\t0.234\t126\n4143\t2.3\t0.213\t81\n4144\t2.187\t0.116\t6\n4145\t2.103\t0.153\t21\n4146\t2.031\t0.308\t83\n4147\t1.752\t0.443\t21\n4151\t3.49\t0.4\t83\n4152\t3.017\t0.331\t40\n4153\t2.932\t0.276\t176\n4154\t2.39\t0.34\t24\n4155\t3.124\t0.377\t16\n4156\t2.907\t0.232\t198\n4158\t2.857\t0.237\t142\n4159\t2.687\t0.244\t49\n4160\t2.787\t0.359\t29\n4161\t2.785\t0.306\t37\n4162\t2.623\t0.298\t175\n4163\t2.812\t0.154\t70\n4164\t2.745\t0.281\t100\n4165\t2.719\t0.184\t37\n4166\t2.683\t0.361\t231\n4167\t2.655\t0.253\t198\n4168\t2.546\t0.208\t37\n4169\t2.259\t0.231\t190\n4170\t2.043\t0.289\t251\n4171\t2.001\t0.221\t391\n4172\t1.984\t0.164\t885\n4173\t1.904\t0.228\t1074\n4174\t2.036\t0.224\t250\n4175\t1.955\t0.184\t6\n4176\t2.35\t0.15\t12\n4177\t2.367\t0.216\t7\n4178\t2.47\t0.186\t11\n4179\t0.95\t-1.0\t1\n4186\t2.88\t0.309\t39\n4188\t2.804\t0.289\t136\n4189\t2.172\t0.082\t12\n4190\t2.321\t0.0\t2\n4359\t1.503\t0.106\t24\n4360\t1.425\t0.052\t40\n12291\t2.861\t0.27\t1069\n12292\t2.773\t0.086\t4\n12293\t2.507\t0.251\t27\n12294\t2.769\t0.373\t370\n12299\t3.1\t0.221\t116\n12300\t2.844\t0.146\t9\n12301\t3.636\t0.002\t3\n12302\t2.779\t0.318\t189\n12307\t3.639\t0.518\t25\n12308\t3.205\t0.245\t16\n12317\t3.036\t0.064\t4\n12318\t2.88\t-1.0\t1\n12319\t2.615\t0.864\t3\n12320\t2.857\t0.129\t247\n12325\t3.557\t0.41\t18\n12326\t3.273\t0.208\t23\n12330\t3.496\t0.025\t2\n12333\t3.012\t0.276\t2\n12334\t2.679\t0.0\t2\n12338\t2.886\t0.196\t80\n12339\t2.871\t0.221\t18\n12343\t3.628\t0.266\t9\n12344\t3.37\t0.145\t35\n12346\t2.859\t0.0\t4\n12352\t2.722\t0.017\t4\n12354\t3.317\t0.016\t4\n12355\t2.714\t0.006\t2\n12357\t2.703\t0.005\t2\n12365\t2.615\t-1.0\t1\n12367\t2.729\t0.0\t2\n12368\t2.841\t0.0\t2\n12369\t2.889\t0.082\t5\n12370\t2.913\t0.126\t64\n12549\t3.003\t0.175\t18\n12550\t2.797\t0.21\t1156\n12805\t2.63\t0.0\t2\n12806\t2.939\t0.243\t85\n16388\t2.29\t0.104\t57\n16389\t2.022\t0.097\t6\n16390\t2.097\t0.127\t21\n16391\t1.771\t0.395\t281\n16392\t1.648\t0.242\t634\n16393\t1.567\t0.555\t264\n16395\t2.926\t0.104\t14\n16397\t2.368\t-1.0\t1\n16398\t3.269\t-1.0\t1\n16399\t2.211\t0.15\t6\n16400\t2.1\t-1.0\t1\n16401\t2.065\t0.622\t37\n16403\t3.355\t0.087\t11\n16404\t2.9\t0.136\t2\n16416\t2.399\t0.154\t3\n16417\t2.06\t0.0\t2\n16418\t2.195\t-1.0\t1\n16419\t2.167\t0.95\t16\n16421\t3.378\t-1.0\t1\n16422\t2.886\t0.031\t2\n16429\t2.375\t0.124\t6\n16435\t2.635\t-1.0\t1\n16436\t2.399\t-1.0\t1\n16437\t2.417\t0.96\t23\n16439\t3.716\t0.078\t2\n16442\t3.052\t0.0\t4\n16463\t2.64\t-1.0\t1\n16466\t2.23\t-1.0\t1\n16474\t3.061\t0.0\t4\n16476\t3.017\t0.004\t8\n16645\t1.954\t-1.0\t1\n16646\t2.276\t0.281\t56\n16647\t1.966\t0.14\t51\n16648\t1.843\t0.124\t41\n16902\t1.739\t0.003\t2\n16903\t2.003\t-1.0\t1\n20491\t2.681\t-1.0\t1\n20492\t2.402\t0.287\t12\n20493\t2.373\t0.17\t6\n20499\t3.054\t0.395\t11\n20500\t3.076\t0.081\t2\n20501\t2.3\t1.168\t20\n20502\t2.221\t0.057\t3\n20503\t1.964\t-1.0\t1\n20504\t2.515\t0.236\t21\n20505\t1.97\t0.231\t70\n20506\t2.056\t0.352\t138\n20507\t2.553\t0.302\t81\n20508\t2.489\t0.321\t24\n20509\t2.215\t0.363\t36\n20510\t2.786\t0.026\t6\n20511\t2.418\t0.106\t10\n20517\t3.193\t0.063\t3\n20519\t2.598\t0.187\t9\n20520\t2.376\t0.309\t9\n20522\t2.708\t0.265\t154\n20524\t2.526\t0.319\t123\n20525\t2.262\t0.289\t122\n20526\t2.502\t0.287\t18\n20527\t2.365\t0.284\t11\n20528\t2.966\t0.038\t6\n20529\t2.584\t0.061\t7\n20530\t2.771\t0.387\t5\n20531\t1.29\t0.001\t12\n20535\t3.368\t0.154\t5\n20536\t3.023\t0.074\t6\n20537\t2.913\t0.0\t2\n20538\t3.021\t0.331\t2\n20540\t2.651\t0.201\t5\n20543\t2.735\t0.344\t5\n20546\t2.531\t0.277\t7\n20549\t3.267\t-1.0\t1\n20550\t2.329\t0.34\t7\n20552\t2.499\t0.02\t6\n20553\t2.703\t0.218\t20\n20554\t2.693\t0.292\t46\n20555\t2.639\t0.27\t40\n20556\t2.066\t0.059\t39\n20557\t2.599\t0.324\t183\n20558\t2.048\t0.149\t134\n20559\t2.327\t0.386\t34\n20560\t2.179\t-1.0\t1\n20561\t2.619\t-1.0\t1\n20562\t2.967\t-1.0\t1\n20570\t2.665\t0.007\t2\n20572\t2.63\t0.19\t9\n20742\t1.87\t0.155\t40\n24587\t3.525\t0.393\t28\n24588\t2.763\t0.313\t380\n24589\t2.462\t0.308\t5373\n24595\t4.077\t0.356\t19\n24596\t3.17\t0.362\t45\n24597\t2.829\t0.525\t432\n24598\t2.656\t0.164\t627\n24599\t2.654\t0.158\t57\n24600\t2.57\t0.26\t309\n24601\t2.625\t0.288\t208\n24602\t2.45\t0.223\t1004\n24603\t2.182\t0.257\t1071\n24604\t2.355\t0.185\t1159\n24605\t2.384\t0.162\t130\n24606\t2.479\t0.188\t1375\n24607\t2.547\t0.23\t805\n24613\t3.789\t0.188\t2\n24614\t3.484\t0.291\t8\n24615\t3.089\t0.34\t499\n24616\t2.809\t0.177\t912\n24617\t2.665\t0.147\t106\n24618\t2.632\t0.3\t598\n24620\t2.419\t0.207\t1127\n24621\t2.466\t0.217\t582\n24622\t2.456\t0.168\t1672\n24623\t2.573\t0.135\t12\n24624\t2.753\t0.503\t34\n24625\t2.695\t0.487\t478\n24626\t2.644\t0.444\t4321\n24627\t2.655\t0.961\t518\n24631\t3.712\t0.709\t3\n24632\t3.745\t0.575\t6\n24633\t3.382\t0.306\t128\n24634\t3.417\t0.336\t41\n24635\t3.236\t0.278\t27\n24636\t3.365\t0.272\t72\n24638\t3.236\t0.316\t52\n24639\t3.097\t0.0\t2\n24640\t2.718\t0.258\t39\n24641\t3.353\t0.103\t6\n24642\t3.087\t0.178\t51\n24643\t2.988\t0.348\t31\n24644\t2.995\t0.182\t58\n24645\t3.221\t0.798\t58\n24646\t3.104\t0.353\t86\n24647\t3.019\t0.515\t320\n24648\t2.735\t0.176\t341\n24649\t2.703\t0.204\t299\n24650\t2.595\t0.331\t829\n24651\t2.536\t0.58\t227\n24652\t2.472\t0.25\t206\n24653\t2.534\t0.168\t933\n24654\t2.491\t0.326\t1889\n24655\t2.445\t0.168\t254\n24656\t2.51\t0.162\t95\n24657\t3.004\t0.801\t27\n24658\t2.961\t0.516\t71\n24659\t3.105\t0.444\t106\n24666\t3.114\t0.326\t123\n24668\t3.098\t0.303\t230\n28685\t2.353\t0.307\t3006\n28693\t2.684\t0.241\t703\n28694\t2.452\t0.242\t3992\n28695\t2.409\t0.319\t1209\n28696\t2.464\t0.534\t2219\n28697\t2.577\t0.289\t2590\n28698\t2.456\t0.2\t6911\n28699\t2.41\t0.36\t7053\n28700\t2.487\t0.231\t7446\n28701\t2.406\t0.194\t9772\n28702\t2.479\t0.227\t5502\n28703\t2.471\t0.309\t929\n28711\t2.921\t0.239\t1714\n28712\t2.679\t0.232\t2798\n28713\t2.442\t0.272\t911\n28714\t2.445\t0.293\t2412\n28716\t2.475\t0.298\t2904\n28717\t2.428\t0.335\t1207\n28718\t2.458\t0.222\t3289\n28719\t2.487\t0.247\t1033\n28720\t2.81\t0.231\t768\n28721\t2.785\t0.35\t616\n28722\t2.606\t0.37\t1703\n28723\t2.599\t0.29\t531\n28729\t3.125\t0.329\t626\n28730\t3.082\t0.337\t728\n28731\t3.179\t0.249\t153\n28732\t3.022\t0.208\t458\n28734\t3.032\t0.245\t890\n28735\t3.194\t0.258\t616\n28736\t3.148\t0.29\t455\n28737\t3.124\t0.266\t301\n28738\t3.028\t0.263\t602\n28739\t2.987\t0.306\t159\n28740\t2.919\t0.28\t496\n28741\t3.182\t0.365\t119\n28742\t2.892\t0.229\t1179\n28743\t2.821\t0.212\t549\n28744\t2.607\t0.225\t683\n28745\t2.503\t0.227\t1194\n28746\t2.395\t0.326\t1012\n28747\t2.447\t0.267\t941\n28748\t2.383\t0.233\t326\n28749\t2.511\t0.279\t970\n28750\t2.457\t0.24\t1884\n28751\t2.393\t0.172\t533\n28752\t2.849\t0.285\t194\n28753\t2.973\t0.272\t62\n28754\t2.876\t0.236\t326\n28755\t2.753\t0.232\t424\n28762\t3.088\t0.249\t588\n28764\t2.972\t0.34\t2780\n28765\t3.016\t0.335\t10\n28766\t3.297\t0.204\t7\n32781\t2.145\t0.448\t7124\n32789\t2.625\t0.845\t799\n32790\t2.338\t0.282\t13095\n32791\t2.352\t0.77\t18035\n32792\t2.299\t0.427\t5228\n32793\t2.387\t0.292\t15567\n32794\t2.358\t0.225\t12153\n32795\t2.38\t0.29\t13623\n32796\t2.421\t0.301\t14996\n32797\t2.272\t0.223\t19019\n32798\t2.378\t0.357\t12982\n32799\t2.317\t0.208\t831\n32807\t2.796\t0.315\t3153\n32808\t2.497\t0.249\t4631\n32809\t2.375\t0.365\t1523\n32810\t2.347\t0.467\t31965\n32812\t2.419\t0.158\t3311\n32813\t2.436\t0.193\t2109\n32814\t2.4\t0.154\t2649\n32815\t2.661\t0.256\t865\n32816\t2.694\t0.218\t2847\n32817\t2.616\t0.276\t949\n32818\t2.579\t0.438\t4702\n32819\t2.309\t0.553\t1993\n32825\t2.994\t0.343\t2113\n32826\t2.856\t0.3\t2621\n32827\t2.93\t0.228\t1218\n32828\t2.905\t0.207\t2518\n32830\t2.869\t0.237\t2353\n32831\t2.827\t0.209\t3697\n32832\t2.834\t0.197\t5222\n32833\t2.78\t0.177\t4383\n32834\t2.738\t0.205\t8482\n32835\t2.747\t0.193\t1707\n32836\t2.742\t0.193\t2196\n32837\t2.798\t0.21\t502\n32838\t2.734\t0.235\t2716\n32839\t2.767\t0.212\t885\n32840\t2.498\t0.29\t774\n32841\t2.373\t0.261\t1221\n32842\t2.285\t0.417\t9618\n32843\t2.218\t0.348\t3304\n32844\t2.411\t0.2\t303\n32845\t2.462\t0.304\t1297\n32846\t2.393\t0.203\t1953\n32847\t2.305\t0.24\t286\n32848\t2.736\t0.309\t162\n32849\t2.822\t0.336\t202\n32850\t2.624\t0.233\t1404\n32851\t2.579\t0.268\t1906\n32858\t2.759\t0.291\t759\n32860\t2.611\t0.412\t7083\n32861\t2.503\t0.425\t287\n32862\t2.802\t0.399\t255\n32863\t2.837\t0.483\t20\n32864\t3.097\t0.448\t5\n32865\t2.94\t0.02\t3\n32866\t2.916\t0.021\t3\n36877\t1.811\t0.461\t1163\n36885\t2.022\t0.295\t129\n36886\t2.262\t0.492\t1106\n36887\t2.576\t0.889\t536\n36888\t1.937\t0.267\t474\n36889\t2.093\t0.73\t296\n36890\t1.929\t0.743\t373\n36891\t2.283\t0.257\t113\n36892\t2.221\t0.196\t116\n36893\t2.345\t0.817\t110\n36894\t2.065\t0.336\t75\n36895\t2.412\t0.358\t76\n36903\t2.125\t0.259\t44\n36904\t2.154\t1.055\t667\n36905\t2.12\t0.459\t502\n36906\t2.031\t0.453\t512\n36908\t2.395\t0.388\t43\n36909\t2.339\t0.338\t54\n36910\t2.361\t0.307\t101\n36911\t2.57\t0.191\t9\n36912\t2.427\t0.207\t26\n36913\t2.059\t1.008\t121\n36914\t2.126\t0.626\t419\n36915\t2.193\t0.262\t8674\n36921\t2.731\t0.286\t10\n36922\t2.995\t1.207\t51\n36923\t2.406\t0.044\t8\n36924\t2.742\t0.246\t33\n36926\t2.795\t0.182\t52\n36927\t2.799\t0.303\t24\n36928\t2.454\t0.018\t4\n36929\t1.96\t0.0\t6\n36930\t2.434\t0.192\t19\n36931\t2.857\t-1.0\t1\n36932\t2.747\t0.211\t25\n36934\t2.687\t0.139\t19\n36935\t2.806\t0.003\t4\n36936\t2.107\t0.444\t90\n36937\t2.149\t0.225\t250\n36938\t1.882\t0.247\t232\n36939\t2.0\t0.93\t274\n36940\t2.276\t0.144\t56\n36941\t2.293\t1.188\t69\n36942\t2.356\t0.364\t53\n36943\t1.893\t0.555\t149\n36944\t2.373\t0.0\t2\n36945\t2.015\t0.261\t45\n36946\t2.333\t0.203\t37\n36947\t2.152\t0.196\t94\n36954\t2.666\t0.268\t30\n36955\t2.205\t0.007\t16\n36956\t2.285\t0.379\t153\n36957\t2.26\t0.017\t10\n45067\t3.369\t0.477\t389\n45068\t3.242\t-1.0\t1\n45069\t3.524\t0.425\t2\n45070\t3.558\t0.0\t2\n45075\t3.592\t0.346\t36\n45076\t3.383\t0.133\t22\n45081\t3.221\t0.182\t3\n45082\t2.923\t0.336\t4\n45083\t3.382\t-1.0\t1\n45084\t2.961\t0.097\t3\n45087\t3.136\t-1.0\t1\n45088\t3.161\t0.174\t9\n45093\t3.645\t0.249\t17\n45094\t3.529\t0.167\t10\n45101\t3.618\t-1.0\t1\n45106\t3.243\t0.311\t72\n45107\t3.33\t0.219\t17\n45111\t3.704\t0.248\t22\n45112\t3.585\t0.155\t9\n45134\t3.136\t-1.0\t1\n45136\t3.234\t0.09\t7\n45137\t3.405\t0.105\t12\n45138\t3.441\t0.118\t15\n45139\t3.281\t0.068\t7\n45317\t3.245\t0.017\t2\n45318\t3.261\t0.178\t294\n45573\t2.685\t-1.0\t1\n45574\t3.187\t0.261\t35\n49164\t3.052\t0.123\t490\n49165\t3.401\t-1.0\t1\n49166\t2.887\t0.569\t39\n49171\t4.275\t0.055\t2\n49172\t3.412\t0.019\t8\n49177\t3.408\t-1.0\t1\n49178\t3.072\t0.063\t8\n49181\t3.334\t0.086\t3\n49182\t3.217\t0.061\t2\n49183\t2.836\t0.772\t13\n49184\t2.807\t0.438\t17\n49190\t3.648\t0.307\t28\n49191\t2.187\t0.0\t6\n49194\t2.466\t0.0\t2\n49197\t2.818\t0.099\t91\n49202\t2.927\t0.036\t9\n49203\t2.862\t0.432\t19\n49207\t3.807\t0.0\t2\n49208\t3.659\t0.045\t20\n49209\t3.53\t0.075\t16\n49210\t3.447\t0.003\t12\n49211\t3.506\t0.0\t3\n49212\t3.54\t0.0\t3\n49214\t3.463\t0.0\t3\n49215\t3.48\t0.014\t8\n49216\t3.364\t0.0\t3\n49221\t3.144\t0.0\t12\n49229\t2.7\t0.086\t48\n49230\t3.087\t0.019\t2\n49233\t3.145\t0.004\t2\n49413\t2.826\t0.154\t5\n49414\t2.811\t0.216\t411\n49670\t2.681\t0.238\t49\n53261\t3.147\t0.471\t69\n53262\t3.263\t0.176\t31\n53263\t3.143\t0.346\t218\n53264\t2.983\t0.385\t264\n53265\t2.601\t0.322\t2017\n53268\t3.669\t-1.0\t1\n53272\t2.557\t-1.0\t1\n53273\t2.309\t-1.0\t1\n53274\t2.908\t0.179\t18\n53275\t2.828\t0.234\t10\n53276\t2.655\t0.245\t6\n53277\t2.352\t0.06\t13\n53278\t3.3\t0.187\t3\n53279\t3.414\t0.37\t3\n53280\t2.499\t0.185\t12\n53281\t2.448\t0.051\t41\n53282\t2.875\t0.469\t72\n53283\t2.741\t0.288\t381\n53286\t3.495\t0.045\t15\n53292\t2.999\t-1.0\t1\n53293\t3.023\t0.354\t19\n53294\t2.951\t0.089\t21\n53295\t3.08\t-1.0\t1\n53297\t3.715\t-1.0\t1\n53298\t3.418\t0.0\t2\n53299\t2.655\t0.502\t19\n53300\t2.915\t0.495\t30\n53301\t3.049\t0.382\t137\n53303\t2.804\t1.394\t2\n53304\t3.582\t0.06\t4\n53305\t3.584\t0.347\t3\n53308\t3.56\t0.086\t2\n53322\t3.218\t0.048\t2\n53325\t3.468\t0.243\t2\n53326\t3.202\t0.139\t4\n53331\t3.74\t0.255\t4\n53340\t4.01\t0.006\t2\n53509\t2.605\t0.31\t8\n53510\t2.407\t0.249\t1700\n53511\t2.374\t0.163\t1982\n53512\t2.216\t0.23\t533\n53519\t2.935\t0.196\t5\n53520\t2.843\t0.186\t40\n53766\t2.468\t0.199\t96\n53767\t2.448\t0.135\t44\n53768\t1.978\t0.199\t4\n57363\t4.548\t0.464\t19\n57364\t3.083\t0.417\t13\n57366\t3.671\t0.019\t4\n57367\t3.246\t0.035\t4\n57368\t2.795\t0.193\t8\n57369\t2.811\t0.292\t27\n57370\t2.847\t0.192\t233\n57371\t2.715\t0.262\t77\n57372\t2.749\t0.228\t147\n57373\t2.884\t0.306\t43\n57374\t3.288\t0.273\t42\n57375\t3.561\t0.36\t4\n57382\t3.347\t0.097\t2\n57384\t3.775\t0.176\t18\n57385\t3.436\t0.115\t26\n57386\t3.224\t0.255\t49\n57388\t2.956\t0.338\t151\n57389\t2.78\t0.227\t106\n57390\t2.921\t0.275\t97\n57391\t3.357\t0.302\t20\n57393\t3.19\t0.085\t14\n57394\t3.662\t0.527\t210\n57395\t3.917\t0.191\t58\n57399\t3.91\t0.0\t4\n57400\t3.327\t0.062\t5\n57402\t3.01\t0.585\t8\n57406\t4.511\t0.25\t17\n57407\t4.503\t0.08\t6\n57409\t3.926\t0.003\t2\n57411\t3.905\t0.012\t2\n57414\t4.362\t0.205\t19\n57416\t3.87\t0.205\t13\n57417\t3.437\t0.24\t5\n57418\t3.085\t0.21\t66\n57419\t2.96\t0.12\t14\n57420\t3.028\t0.125\t7\n57421\t2.797\t0.286\t150\n57422\t2.978\t0.215\t175\n57423\t2.761\t0.465\t12\n57424\t3.53\t0.211\t22\n57426\t3.874\t0.316\t17\n57427\t4.031\t0.321\t9\n61461\t3.38\t0.299\t100\n61462\t3.21\t0.369\t276\n61463\t3.131\t0.207\t110\n61464\t2.873\t0.244\t730\n61465\t2.696\t0.32\t774\n61466\t2.697\t0.243\t4802\n61467\t2.679\t0.235\t3056\n61468\t2.676\t0.196\t4702\n61469\t2.64\t0.179\t5253\n61470\t2.912\t0.244\t119\n61471\t3.023\t0.242\t152\n61479\t3.617\t0.27\t57\n61480\t3.41\t0.235\t240\n61481\t3.284\t0.297\t129\n61482\t3.002\t0.261\t2058\n61484\t2.758\t0.203\t6616\n61485\t2.714\t0.205\t4052\n61486\t2.713\t0.193\t6710\n61487\t2.863\t0.16\t1964\n61488\t3.199\t0.271\t42\n61489\t3.285\t0.255\t93\n61490\t3.243\t0.31\t221\n61491\t3.183\t0.277\t77\n61497\t3.201\t0.305\t27\n61498\t2.934\t0.476\t9\n61500\t3.451\t0.1\t14\n61502\t3.794\t0.117\t26\n61506\t3.579\t0.083\t13\n61507\t3.584\t0.109\t8\n61508\t3.774\t0.0\t2\n61510\t3.577\t0.217\t22\n61511\t3.739\t0.336\t7\n61512\t3.408\t0.222\t72\n61513\t3.244\t0.257\t147\n61514\t3.003\t0.256\t1665\n61515\t2.906\t0.239\t1623\n61516\t2.798\t0.241\t1057\n61517\t2.754\t0.215\t2863\n61518\t2.714\t0.201\t6668\n61519\t2.668\t0.172\t4216\n61520\t2.879\t0.203\t76\n61521\t3.471\t0.204\t33\n61522\t3.487\t0.164\t39\n61523\t3.141\t0.234\t30\n61530\t3.726\t0.298\t60\n61532\t3.891\t0.328\t80\n65557\t3.412\t0.368\t35\n65558\t2.901\t0.267\t387\n65559\t2.852\t0.348\t489\n65560\t2.881\t0.289\t268\n65561\t2.726\t0.281\t883\n65562\t2.718\t0.226\t7921\n65563\t2.724\t0.272\t1489\n65564\t2.606\t0.234\t5975\n65565\t2.755\t0.225\t5038\n65566\t2.788\t0.225\t1360\n65567\t2.767\t0.214\t227\n65575\t3.418\t0.184\t159\n65576\t3.376\t0.277\t123\n65577\t2.954\t0.528\t373\n65578\t2.911\t0.288\t3355\n65580\t2.816\t0.192\t1907\n65581\t2.839\t0.173\t765\n65582\t2.775\t0.192\t2485\n65583\t3.093\t0.232\t4438\n65584\t3.087\t0.238\t609\n65585\t3.111\t0.393\t484\n65586\t2.949\t0.477\t1247\n65587\t2.995\t0.415\t696\n65593\t3.611\t0.276\t65\n65594\t3.5\t0.164\t59\n65595\t3.551\t0.145\t18\n65596\t3.459\t0.169\t45\n65598\t3.453\t0.18\t175\n65599\t3.683\t0.232\t44\n65600\t3.412\t0.05\t10\n65601\t3.114\t0.282\t6\n65602\t3.516\t0.333\t73\n65603\t3.018\t0.572\t5\n65604\t3.488\t0.196\t81\n65605\t3.266\t0.272\t10\n65606\t3.254\t0.188\t179\n65607\t3.336\t0.194\t34\n65608\t3.554\t0.326\t21\n65609\t2.461\t0.31\t329\n65610\t2.919\t0.288\t2082\n65611\t2.8\t0.267\t1996\n65612\t2.475\t0.252\t240\n65613\t2.833\t0.153\t655\n65614\t2.73\t0.196\t2208\n65615\t2.776\t0.277\t3697\n65616\t2.944\t0.23\t538\n65617\t3.031\t0.277\t17\n65618\t3.147\t0.26\t222\n65619\t3.099\t0.284\t350\n65626\t3.319\t0.35\t170\n65628\t3.382\t0.265\t290\n65629\t3.399\t0.077\t8\n65630\t2.931\t0.387\t17\n65631\t3.438\t0.046\t3\n65632\t3.441\t0.047\t3\n69653\t3.008\t0.308\t233\n69654\t2.799\t0.246\t2597\n69655\t2.789\t0.215\t490\n69656\t2.8\t0.199\t1394\n69657\t2.875\t0.267\t1182\n69658\t2.712\t0.238\t3474\n69659\t2.694\t0.227\t2713\n69660\t2.758\t0.28\t2082\n69661\t2.701\t0.25\t5780\n69662\t2.642\t0.425\t3822\n69663\t2.661\t0.254\t1485\n69671\t3.218\t0.274\t409\n69672\t2.991\t0.248\t1900\n69673\t2.903\t0.356\t1449\n69674\t2.907\t0.475\t2267\n69676\t2.885\t0.203\t5377\n69677\t2.863\t0.235\t2604\n69678\t2.776\t0.213\t6900\n69679\t3.032\t0.245\t617\n69680\t2.974\t0.221\t1026\n69681\t2.957\t0.377\t932\n69682\t2.928\t0.391\t2452\n69683\t2.872\t0.46\t1745\n69689\t3.393\t0.345\t120\n69690\t3.542\t0.471\t133\n69691\t3.384\t0.328\t54\n69692\t3.319\t0.289\t122\n69694\t3.354\t0.248\t151\n69695\t3.179\t0.349\t113\n69696\t3.251\t0.372\t116\n69697\t3.069\t0.3\t85\n69698\t3.114\t0.336\t295\n69699\t3.273\t0.344\t35\n69700\t3.214\t0.336\t160\n69701\t2.947\t0.43\t25\n69702\t3.224\t0.207\t183\n69703\t3.182\t0.198\t73\n69704\t2.972\t0.302\t357\n69705\t2.911\t0.327\t1000\n69706\t2.885\t0.369\t1787\n69707\t2.801\t0.257\t2221\n69708\t2.851\t0.255\t681\n69709\t2.879\t0.222\t2186\n69710\t2.757\t0.265\t4336\n69711\t2.675\t0.201\t2687\n69712\t2.804\t0.27\t1229\n69713\t2.554\t0.473\t192\n69714\t3.224\t0.457\t625\n69715\t3.107\t0.371\t1402\n69722\t3.417\t0.306\t157\n69723\t2.64\t0.0\t4\n69724\t3.21\t0.343\t893\n69725\t3.181\t0.284\t122\n69726\t3.088\t0.296\t154\n69727\t2.915\t-1.0\t1\n69728\t2.915\t-1.0\t1\n69729\t2.465\t0.0\t6\n77843\t3.904\t0.444\t476\n77844\t3.931\t0.219\t13\n77847\t3.213\t0.001\t2\n77848\t3.318\t0.114\t5\n77849\t3.574\t0.313\t3\n77850\t3.205\t-1.0\t1\n77851\t3.463\t0.411\t4\n77852\t3.491\t0.534\t2\n77853\t3.822\t0.039\t3\n77854\t3.511\t0.765\t6\n77856\t3.502\t0.647\t78\n77861\t3.9\t0.078\t12\n77862\t3.806\t0.091\t8\n77864\t3.807\t-1.0\t1\n77865\t3.535\t0.137\t7\n77870\t3.386\t0.218\t17\n77871\t3.245\t0.006\t2\n77874\t3.754\t0.595\t67\n77875\t3.655\t0.42\t25\n77879\t3.899\t0.365\t31\n77880\t4.729\t0.676\t2\n77898\t4.496\t0.606\t3\n77902\t3.48\t0.0\t4\n77905\t3.736\t0.08\t11\n77906\t3.724\t0.099\t26\n77907\t3.562\t0.045\t4\n77917\t4.592\t-1.0\t1\n78085\t3.76\t0.113\t8\n78086\t3.713\t0.29\t1287\n78342\t3.557\t0.28\t73\n81940\t3.661\t0.289\t176\n81943\t3.019\t-1.0\t1\n81944\t2.85\t-1.0\t1\n81945\t3.324\t0.0\t2\n81951\t3.151\t-1.0\t1\n81952\t3.185\t0.116\t25\n81957\t3.75\t0.247\t3\n81958\t3.579\t0.106\t3\n81967\t3.517\t0.128\t5\n81969\t3.26\t0.128\t3\n81970\t3.346\t0.13\t71\n81971\t3.246\t0.132\t128\n81975\t3.895\t0.219\t5\n81976\t3.719\t0.202\t10\n81997\t3.133\t0.007\t2\n81999\t3.088\t0.086\t20\n82000\t3.26\t0.098\t4\n82001\t3.332\t-1.0\t1\n82002\t3.427\t0.083\t10\n82003\t3.25\t0.171\t45\n82012\t3.805\t-1.0\t1\n82182\t3.212\t0.212\t411\n82438\t2.973\t0.227\t13\n86044\t2.357\t-1.0\t1\n86050\t3.301\t0.106\t5\n86051\t3.223\t0.408\t15\n86053\t3.906\t-1.0\t1\n86062\t2.711\t0.034\t2\n86068\t3.534\t0.111\t4\n86069\t3.014\t0.266\t86\n86277\t3.132\t0.206\t3\n86278\t3.08\t0.205\t1002\n86279\t2.704\t0.168\t460\n86280\t2.561\t0.163\t44\n86287\t3.292\t0.078\t26\n86288\t3.128\t0.068\t7\n86534\t2.902\t0.101\t13\n86535\t2.446\t0.18\t5\n90134\t3.158\t0.093\t9\n90138\t2.576\t0.185\t3\n90139\t2.835\t0.161\t13\n90140\t2.925\t0.174\t8\n90141\t3.761\t-1.0\t1\n90143\t3.058\t0.0\t2\n90144\t2.522\t0.784\t3\n90145\t2.482\t0.209\t46\n90146\t3.164\t0.558\t44\n90147\t2.774\t0.281\t113\n90150\t3.233\t0.034\t7\n90156\t3.193\t-1.0\t1\n90157\t2.921\t-1.0\t1\n90161\t3.271\t0.0\t2\n90162\t3.869\t0.023\t3\n90163\t3.573\t0.143\t28\n90164\t3.347\t0.022\t18\n90165\t2.62\t0.414\t54\n90168\t3.427\t0.036\t8\n90194\t3.897\t-1.0\t1\n90373\t3.171\t0.268\t3\n90374\t2.926\t0.185\t13105\n90375\t2.587\t0.178\t1875\n90376\t2.456\t0.185\t917\n90383\t3.113\t0.322\t22\n90384\t3.044\t0.167\t14\n90630\t2.624\t0.183\t73\n90631\t2.431\t0.217\t59\n90632\t2.541\t0.214\t13\n94231\t2.269\t0.138\t9\n94234\t2.503\t0.095\t6\n94235\t2.637\t0.592\t3\n94236\t3.236\t0.203\t2\n94242\t2.529\t0.487\t29\n94243\t2.969\t0.254\t17\n94264\t3.486\t-1.0\t1\n94286\t2.784\t0.083\t10\n94470\t2.664\t0.196\t1656\n94471\t2.46\t0.141\t1730\n94472\t2.373\t0.21\t563\n94479\t3.002\t0.084\t9\n94480\t2.809\t0.211\t72\n94726\t2.339\t0.204\t93\n94727\t2.461\t0.173\t28\n94728\t2.22\t0.033\t36\n98328\t2.585\t0.33\t139\n98329\t3.026\t0.483\t6\n98330\t3.053\t0.116\t7\n98331\t2.861\t0.157\t7\n98332\t3.016\t0.06\t2\n98333\t2.906\t-1.0\t1\n98334\t3.171\t-1.0\t1\n98335\t2.778\t0.078\t6\n98336\t2.83\t0.006\t4\n98337\t2.984\t0.301\t63\n98338\t3.557\t0.536\t97\n98339\t2.852\t0.31\t66\n98341\t3.47\t0.104\t3\n98349\t3.572\t-1.0\t1\n98350\t3.259\t0.092\t4\n98354\t3.11\t0.137\t19\n98355\t3.017\t0.193\t20\n98356\t3.203\t0.219\t43\n98357\t3.129\t0.376\t67\n98378\t3.04\t-1.0\t1\n98381\t3.568\t-1.0\t1\n98382\t3.15\t0.188\t5\n98383\t3.133\t0.037\t3\n98384\t3.045\t0.0\t2\n98386\t3.121\t0.097\t12\n98387\t3.325\t0.016\t2\n98565\t2.688\t0.12\t18\n98566\t2.619\t0.153\t6878\n98567\t2.404\t0.141\t2515\n98568\t2.41\t0.174\t638\n98575\t3.098\t0.146\t259\n98576\t2.876\t0.25\t37\n98822\t2.158\t0.152\t4143\n98823\t2.42\t0.131\t56\n98824\t2.468\t0.236\t5\n102425\t3.087\t0.258\t19\n102426\t2.867\t0.103\t4\n102427\t3.03\t0.131\t2\n102428\t2.886\t-1.0\t1\n102431\t3.326\t0.375\t7\n102432\t2.775\t0.168\t35\n102433\t2.737\t0.092\t14\n102434\t3.052\t0.275\t320\n102435\t2.947\t0.279\t501\n102438\t3.136\t0.442\t2\n102442\t3.198\t-1.0\t1\n102444\t2.998\t0.081\t3\n102445\t2.848\t0.318\t2\n102447\t3.116\t0.312\t4\n102449\t2.668\t0.007\t12\n102450\t2.65\t0.156\t37\n102451\t2.804\t0.128\t97\n102452\t3.71\t0.389\t143\n102453\t3.196\t0.352\t77\n102476\t2.993\t0.038\t4\n102478\t3.256\t-1.0\t1\n102479\t3.089\t0.272\t5\n102480\t2.61\t0.003\t4\n102481\t3.397\t-1.0\t1\n102482\t2.754\t0.035\t4\n102483\t2.878\t0.096\t25\n102661\t2.718\t0.111\t3\n102662\t2.482\t0.226\t2788\n102663\t2.511\t0.177\t8370\n102664\t2.493\t0.179\t2602\n102671\t2.643\t0.184\t45\n102672\t2.962\t0.176\t53\n102918\t2.052\t0.149\t4796\n102919\t2.51\t0.179\t433\n102920\t2.374\t0.161\t19\n106522\t2.941\t0.371\t219\n106523\t2.892\t0.261\t5\n106524\t2.877\t0.111\t7\n106525\t2.863\t0.149\t85\n106526\t2.98\t0.096\t34\n106527\t2.834\t0.242\t89\n106528\t2.743\t0.335\t128\n106529\t2.701\t0.254\t143\n106530\t2.739\t0.223\t715\n106531\t2.904\t0.242\t866\n106536\t3.002\t0.349\t8\n106537\t2.799\t0.229\t2\n106538\t3.086\t0.144\t4\n106540\t2.735\t0.302\t14\n106541\t2.768\t0.387\t2\n106542\t3.159\t0.157\t17\n106543\t2.781\t0.205\t11\n106545\t3.031\t0.266\t33\n106546\t3.013\t0.266\t96\n106547\t2.844\t0.229\t38\n106548\t2.92\t0.185\t202\n106549\t3.146\t0.267\t200\n106551\t3.701\t0.004\t2\n106552\t3.508\t0.08\t2\n106554\t3.692\t-1.0\t1\n106556\t3.882\t-1.0\t1\n106566\t3.665\t0.215\t7\n106570\t3.257\t0.114\t4\n106571\t2.863\t0.015\t4\n106572\t2.976\t0.164\t5\n106574\t3.224\t0.085\t11\n106575\t2.779\t0.247\t4\n106576\t2.981\t0.124\t18\n106577\t3.014\t0.072\t10\n106579\t3.124\t0.117\t28\n106757\t2.221\t0.408\t15\n106758\t2.401\t0.141\t81624\n106759\t2.351\t0.184\t21226\n106760\t2.431\t0.13\t2185\n106767\t2.782\t0.218\t230\n106768\t2.742\t0.183\t221\n107014\t2.077\t0.157\t13871\n107015\t2.286\t0.144\t1126\n107016\t2.261\t0.186\t6\n107023\t2.555\t-1.0\t1\n110619\t2.657\t0.367\t240\n110620\t2.816\t0.234\t12\n110621\t2.849\t0.093\t2\n110622\t2.914\t0.068\t12\n110623\t2.683\t0.337\t23\n110624\t2.349\t0.547\t34\n110625\t2.914\t0.287\t44\n110626\t2.37\t0.334\t254\n110627\t2.823\t0.245\t593\n110629\t3.216\t-1.0\t1\n110632\t3.168\t0.262\t18\n110633\t3.517\t-1.0\t1\n110634\t3.188\t-1.0\t1\n110636\t2.935\t0.025\t5\n110637\t2.659\t0.073\t4\n110638\t2.964\t0.14\t43\n110641\t2.808\t0.245\t6\n110642\t2.669\t0.36\t18\n110643\t2.899\t0.004\t2\n110644\t2.907\t0.266\t28\n110645\t3.111\t0.233\t239\n110654\t3.746\t0.042\t4\n110664\t3.213\t0.095\t2\n110665\t3.535\t-1.0\t1\n110666\t3.211\t-1.0\t1\n110669\t2.652\t-1.0\t1\n110670\t3.108\t0.335\t20\n110671\t3.078\t0.114\t48\n110672\t2.505\t0.007\t4\n110673\t2.66\t0.009\t3\n110674\t2.75\t0.014\t4\n110675\t2.821\t0.241\t50\n110682\t3.786\t-1.0\t1\n110684\t3.602\t0.211\t2\n110853\t2.51\t0.032\t24\n110854\t2.424\t0.18\t7855\n110855\t2.35\t0.165\t15280\n110856\t2.397\t0.151\t2600\n110863\t2.753\t0.315\t114\n110864\t2.718\t0.212\t256\n111110\t2.057\t0.162\t5916\n111111\t2.347\t0.183\t580\n111120\t3.119\t-1.0\t1\n114716\t2.861\t0.204\t423\n114717\t2.956\t0.144\t62\n114718\t3.07\t0.105\t55\n114719\t2.884\t0.235\t61\n114720\t2.67\t0.388\t26\n114721\t2.959\t0.219\t18\n114722\t2.832\t0.233\t173\n114723\t2.869\t0.229\t1269\n114727\t2.635\t0.109\t4\n114728\t2.753\t-1.0\t1\n114730\t2.796\t0.0\t2\n114733\t2.529\t0.017\t3\n114737\t2.923\t0.325\t25\n114738\t3.191\t0.145\t154\n114739\t3.085\t0.122\t9\n114740\t3.439\t0.421\t52\n114741\t3.061\t0.179\t190\n114743\t3.288\t-1.0\t1\n114745\t2.617\t0.062\t2\n114759\t3.289\t0.325\t3\n114760\t2.798\t-1.0\t1\n114762\t2.961\t-1.0\t1\n114765\t2.702\t-1.0\t1\n114766\t3.089\t0.135\t10\n114767\t3.047\t0.066\t62\n114768\t3.431\t0.011\t4\n114769\t3.198\t-1.0\t1\n114770\t3.331\t0.009\t16\n114771\t3.287\t0.091\t62\n114780\t3.048\t-1.0\t1\n114949\t2.438\t0.289\t13\n114950\t2.447\t0.207\t5143\n114951\t2.359\t0.153\t15318\n114952\t2.422\t0.153\t2635\n114959\t2.635\t0.231\t43\n114960\t2.669\t0.201\t795\n115206\t2.167\t0.159\t1651\n115207\t2.384\t0.147\t685\n115208\t2.377\t-1.0\t1\n118813\t2.913\t0.463\t3054\n118814\t2.839\t0.079\t11\n118815\t2.711\t0.001\t4\n118816\t2.916\t0.195\t36\n118817\t2.906\t0.257\t48\n118818\t3.003\t0.19\t1185\n118819\t2.89\t0.233\t2162\n118821\t4.015\t-1.0\t1\n118826\t2.96\t-1.0\t1\n118828\t2.952\t0.11\t39\n118829\t2.507\t0.024\t3\n118830\t2.938\t0.19\t22\n118831\t2.849\t0.2\t37\n118834\t2.765\t0.134\t305\n118835\t3.108\t0.155\t31\n118836\t3.39\t0.219\t189\n118837\t3.139\t0.235\t3644\n118839\t3.839\t-1.0\t1\n118858\t2.994\t-1.0\t1\n118861\t2.937\t0.024\t4\n118862\t2.749\t0.231\t11\n118863\t3.089\t0.14\t128\n118864\t2.73\t0.419\t10\n118867\t4.236\t-1.0\t1\n119046\t2.301\t0.205\t1784\n119047\t2.304\t0.132\t28601\n119048\t2.278\t0.16\t3943\n119055\t2.752\t0.18\t205\n119056\t2.764\t0.209\t1501\n119302\t2.425\t0.207\t1326\n119303\t2.302\t0.163\t1333\n119304\t2.514\t0.012\t2\n122910\t2.933\t0.511\t46\n122911\t2.702\t0.368\t7\n122912\t2.663\t0.513\t47\n122913\t2.561\t0.197\t22\n122914\t2.985\t0.238\t269\n122915\t2.799\t0.235\t1020\n122917\t3.448\t-1.0\t1\n122920\t3.428\t0.0\t2\n122922\t3.262\t0.063\t13\n122924\t3.141\t0.257\t36\n122925\t3.024\t0.038\t68\n122926\t3.08\t0.273\t30\n122929\t3.163\t0.018\t2\n122930\t2.751\t0.402\t11\n122932\t3.359\t0.441\t18\n122933\t3.021\t0.24\t382\n122935\t3.714\t-1.0\t1\n122955\t3.014\t0.026\t6\n122957\t3.238\t0.02\t4\n122958\t3.092\t0.105\t29\n122960\t3.074\t0.0\t2\n122961\t2.928\t0.007\t10\n122962\t3.518\t0.023\t8\n122963\t2.553\t0.0\t2\n123142\t2.737\t0.301\t850\n123143\t2.41\t0.137\t13630\n123144\t2.395\t0.157\t2260\n123151\t2.989\t0.176\t11\n123152\t2.86\t0.169\t504\n123398\t2.392\t0.233\t92\n123399\t2.348\t0.155\t241\n127007\t3.02\t0.246\t86\n127008\t2.974\t0.088\t8\n127009\t3.494\t0.451\t21\n127010\t2.829\t0.38\t37\n127011\t2.708\t0.245\t196\n127014\t3.469\t0.079\t7\n127016\t3.23\t0.0\t2\n127018\t3.049\t0.131\t23\n127020\t2.953\t0.101\t22\n127021\t3.009\t0.238\t45\n127022\t3.086\t0.158\t56\n127023\t3.058\t0.009\t4\n127025\t3.335\t0.196\t5\n127026\t3.283\t0.062\t7\n127027\t2.651\t0.769\t24\n127028\t3.434\t0.203\t18\n127029\t3.123\t0.373\t261\n127031\t3.789\t0.084\t6\n127032\t4.457\t-1.0\t1\n127033\t3.667\t-1.0\t1\n127036\t4.074\t0.0\t2\n127039\t4.048\t-1.0\t1\n127046\t4.093\t-1.0\t1\n127050\t2.953\t0.101\t7\n127052\t3.076\t0.218\t4\n127053\t3.176\t0.156\t3\n127054\t2.924\t0.124\t38\n127055\t2.909\t0.082\t10\n127059\t4.205\t0.525\t4\n127068\t3.948\t0.013\t2\n127237\t2.513\t0.281\t7\n127238\t2.422\t0.173\t417\n127239\t2.418\t0.176\t782\n127240\t2.39\t0.178\t153\n127247\t2.978\t0.075\t57\n127248\t2.775\t0.184\t61\n127494\t2.47\t0.44\t42\n127495\t2.406\t0.044\t2\n131109\t3.618\t0.424\t54\n131110\t3.321\t0.053\t36\n131111\t2.973\t0.025\t4\n131112\t3.771\t0.94\t5\n131113\t3.619\t0.341\t9\n131114\t3.143\t0.38\t30\n131116\t2.916\t0.159\t157\n131117\t2.917\t0.159\t121\n131118\t3.04\t0.268\t107\n131119\t2.922\t0.222\t15\n131120\t3.307\t0.038\t4\n131122\t3.411\t0.477\t35\n131123\t3.351\t-1.0\t1\n131127\t3.814\t0.114\t37\n131128\t3.49\t0.107\t29\n131130\t2.988\t0.0\t6\n131137\t2.864\t-1.0\t1\n131138\t3.615\t0.013\t2\n131144\t3.909\t0.169\t5\n131146\t3.079\t0.227\t59\n131147\t2.946\t0.309\t17\n131148\t2.938\t0.152\t48\n131149\t2.889\t0.075\t105\n131150\t2.932\t0.142\t86\n131151\t2.965\t0.315\t19\n131154\t4.158\t0.0\t3\n131155\t3.469\t0.0\t2\n135208\t3.392\t0.193\t9\n135209\t2.553\t0.506\t113\n135210\t2.846\t0.341\t42\n135212\t2.866\t0.212\t135\n135213\t2.927\t0.123\t16\n135214\t2.871\t0.163\t78\n135215\t2.95\t0.206\t41\n135216\t2.799\t0.488\t10\n135217\t2.858\t0.374\t47\n135218\t3.171\t0.414\t88\n135219\t3.525\t0.292\t6\n135226\t2.999\t0.0\t6\n135230\t3.926\t0.069\t11\n135234\t3.555\t0.069\t7\n135237\t4.014\t0.007\t2\n135240\t2.589\t0.032\t8\n135241\t2.464\t0.036\t10\n135242\t2.986\t0.141\t77\n135243\t2.924\t-1.0\t1\n135244\t2.773\t0.037\t5\n135245\t3.046\t0.0\t2\n135246\t2.825\t0.185\t175\n135247\t2.784\t0.162\t65\n135248\t3.475\t0.422\t13\n135249\t3.243\t0.492\t4\n135250\t3.627\t0.385\t15\n135251\t3.822\t0.36\t16\n135258\t3.001\t0.0\t2\n135260\t3.608\t0.228\t9\n135430\t2.312\t0.051\t4\n139303\t3.535\t0.292\t31\n139304\t3.38\t0.183\t24\n139305\t2.623\t0.529\t104\n139306\t3.083\t0.33\t321\n139308\t2.96\t0.162\t229\n139309\t2.923\t0.274\t63\n139310\t2.882\t0.149\t259\n139311\t3.27\t0.202\t438\n139312\t2.668\t0.417\t260\n139313\t3.241\t0.429\t63\n139314\t3.163\t0.399\t546\n139315\t3.191\t0.461\t290\n139321\t3.855\t0.226\t50\n139322\t3.709\t0.138\t100\n139323\t3.684\t0.123\t46\n139324\t3.633\t0.072\t70\n139326\t3.545\t0.123\t112\n139327\t3.991\t0.038\t4\n139328\t3.786\t0.526\t8\n139329\t3.979\t0.001\t4\n139330\t3.537\t0.014\t6\n139331\t3.355\t0.108\t12\n139332\t3.159\t0.173\t21\n139333\t3.624\t0.136\t27\n139334\t3.334\t0.167\t126\n139336\t3.239\t0.487\t10\n139337\t2.614\t0.35\t62\n139338\t3.123\t0.251\t218\n139339\t3.229\t0.309\t1334\n139340\t3.562\t0.717\t14\n139341\t2.945\t0.19\t49\n139342\t2.914\t0.165\t139\n139343\t2.866\t0.183\t165\n139344\t3.14\t0.274\t105\n139345\t3.078\t0.295\t50\n139346\t3.558\t0.371\t43\n139347\t3.512\t0.445\t86\n139354\t3.623\t0.348\t57\n139356\t3.581\t0.414\t207\n139357\t3.553\t0.26\t12\n139358\t3.738\t0.14\t26\n139526\t2.278\t0.056\t6\n143399\t2.881\t0.269\t29\n143400\t3.289\t0.207\t165\n143401\t2.903\t0.415\t136\n143402\t2.928\t0.263\t822\n143404\t2.981\t0.274\t225\n143405\t3.002\t0.373\t123\n143406\t2.929\t0.211\t1350\n143407\t3.15\t0.245\t392\n143408\t3.115\t0.214\t390\n143409\t2.892\t0.454\t277\n143410\t3.152\t0.327\t288\n143411\t3.118\t0.344\t421\n143417\t3.489\t0.306\t26\n143418\t3.66\t0.441\t102\n143419\t2.889\t0.02\t3\n143420\t3.311\t0.239\t14\n143422\t3.519\t0.117\t10\n143423\t3.405\t0.182\t14\n143424\t3.622\t0.201\t10\n143425\t2.902\t0.279\t14\n143426\t3.441\t0.397\t31\n143427\t2.869\t0.248\t16\n143428\t2.769\t0.111\t12\n143430\t3.342\t0.101\t8\n143433\t3.029\t0.413\t218\n143434\t2.63\t0.358\t237\n143435\t2.974\t0.223\t787\n143436\t2.871\t0.256\t91\n143437\t3.02\t0.255\t120\n143438\t2.97\t0.262\t730\n143439\t2.839\t0.219\t570\n143440\t2.939\t0.303\t600\n143441\t2.709\t0.226\t130\n143442\t3.393\t0.358\t470\n143443\t3.237\t0.326\t869\n143450\t3.569\t0.067\t21\n143452\t3.3\t0.463\t144\n143453\t2.771\t0.0\t6\n143454\t3.655\t0.021\t3\n143455\t2.882\t0.023\t3\n151589\t4.027\t0.433\t171\n151590\t3.818\t0.355\t2\n151594\t3.871\t0.0\t2\n151598\t3.586\t0.162\t20\n151599\t3.353\t0.049\t2\n151601\t3.937\t0.0\t2\n151602\t3.839\t0.296\t15\n151603\t3.859\t0.378\t36\n151607\t4.188\t0.029\t2\n151631\t3.626\t0.064\t26\n151633\t3.814\t0.025\t4\n151634\t3.849\t0.071\t10\n151635\t4.057\t0.0\t2\n151814\t3.815\t0.247\t64\n152069\t3.392\t0.0\t2\n152070\t3.728\t0.185\t7\n155686\t3.715\t0.263\t197\n155692\t3.291\t0.0\t2\n155693\t3.275\t0.0\t2\n155695\t3.371\t-1.0\t1\n155696\t3.544\t0.083\t4\n155697\t3.415\t0.077\t36\n155698\t3.446\t0.074\t26\n155699\t3.346\t0.137\t70\n155703\t4.039\t0.114\t2\n155704\t3.785\t-1.0\t1\n155725\t3.3\t0.0\t4\n155726\t3.174\t0.064\t8\n155727\t3.236\t0.051\t4\n155728\t3.411\t0.02\t2\n155729\t3.492\t0.006\t3\n155730\t3.53\t0.066\t10\n155731\t3.424\t0.132\t88\n155740\t3.534\t-1.0\t1\n155910\t3.584\t0.272\t112\n156166\t2.793\t0.019\t4\n159783\t4.713\t0.009\t2\n159790\t3.627\t0.388\t4\n159795\t3.832\t0.039\t12\n159797\t3.719\t0.347\t56\n159799\t4.168\t0.0\t2\n159822\t3.558\t0.003\t2\n160005\t3.476\t0.074\t35\n160006\t3.258\t0.191\t4054\n160007\t2.913\t0.142\t1412\n160008\t2.796\t0.249\t708\n160015\t3.636\t0.026\t3\n160016\t3.367\t0.408\t27\n160262\t2.99\t0.127\t72\n160263\t3.031\t0.264\t24\n163884\t3.712\t0.084\t3\n163885\t3.713\t0.26\t5\n163889\t3.399\t0.0\t2\n163890\t3.989\t0.377\t5\n163892\t3.476\t0.0\t2\n163893\t3.302\t0.424\t87\n163917\t3.364\t0.045\t5\n163918\t3.314\t0.355\t6\n163922\t4.034\t-1.0\t1\n164101\t3.255\t0.125\t9\n164102\t3.029\t0.219\t13290\n164103\t2.812\t0.186\t1007\n164104\t2.599\t0.231\t718\n164111\t3.355\t0.275\t19\n164112\t3.184\t0.119\t22\n164358\t2.805\t0.151\t103\n164359\t2.642\t0.21\t22\n164360\t2.844\t0.216\t9\n167977\t2.746\t0.433\t12\n167986\t3.166\t-1.0\t1\n167988\t3.668\t0.819\t15\n167989\t2.936\t0.216\t20\n168198\t2.975\t0.237\t953\n168199\t2.749\t0.24\t450\n168200\t2.532\t0.296\t44\n168207\t3.165\t0.13\t49\n168208\t3.318\t0.08\t14\n168454\t2.601\t0.169\t111\n168455\t2.727\t0.161\t25\n172074\t2.912\t0.373\t1298\n172076\t3.157\t0.34\t9\n172078\t3.301\t0.025\t5\n172079\t3.222\t0.067\t8\n172082\t3.28\t0.259\t30\n172083\t3.177\t0.165\t15\n172084\t3.327\t0.193\t23\n172085\t3.272\t0.292\t557\n172087\t3.799\t-1.0\t1\n172088\t3.528\t-1.0\t1\n172106\t2.727\t0.462\t6\n172107\t3.735\t-1.0\t1\n172109\t3.252\t0.082\t43\n172110\t3.239\t0.183\t9\n172111\t3.197\t0.132\t22\n172112\t3.584\t0.076\t4\n172114\t3.693\t0.232\t12\n172115\t3.359\t0.28\t40\n172124\t3.744\t0.013\t2\n172293\t3.03\t0.256\t14\n172294\t2.789\t0.167\t9278\n172295\t2.577\t0.18\t3098\n172296\t2.467\t0.259\t1296\n172303\t2.908\t0.239\t150\n172304\t2.957\t0.217\t165\n172550\t2.341\t0.159\t4663\n172551\t2.511\t0.149\t218\n172559\t2.202\t0.279\t10\n180268\t3.063\t0.299\t1102\n180269\t2.945\t0.515\t10\n180270\t3.082\t0.36\t14\n180271\t3.086\t-1.0\t1\n180272\t3.242\t0.131\t2\n180273\t3.439\t0.268\t6\n180274\t3.072\t0.196\t129\n180275\t3.213\t0.211\t24\n180276\t3.091\t0.153\t98\n180277\t3.22\t0.208\t173\n180295\t3.709\t0.109\t4\n180296\t3.674\t0.024\t2\n180298\t3.338\t0.368\t8\n180299\t3.08\t0.02\t2\n180300\t3.051\t0.136\t6\n180301\t3.2\t0.237\t31\n180302\t3.182\t0.186\t59\n180303\t2.975\t0.164\t24\n180304\t3.255\t-1.0\t1\n180306\t2.931\t0.041\t12\n180307\t2.734\t0.077\t20\n180485\t2.755\t0.204\t14\n180486\t2.611\t0.146\t28221\n180487\t2.363\t0.139\t11820\n180488\t2.408\t0.153\t1326\n180495\t2.75\t0.202\t77\n180496\t2.828\t0.175\t621\n180742\t2.163\t0.16\t10524\n180743\t2.394\t0.13\t880\n180744\t2.447\t0.224\t6\n180751\t2.688\t0.012\t5\n180752\t2.464\t0.284\t5\n184365\t2.871\t0.285\t392\n184366\t3.302\t0.52\t4\n184367\t2.634\t0.029\t2\n184368\t2.701\t-1.0\t1\n184369\t3.216\t0.427\t13\n184370\t3.333\t0.264\t124\n184371\t3.063\t0.086\t29\n184372\t3.343\t0.188\t5\n184373\t3.193\t0.194\t327\n184396\t2.794\t0.148\t26\n184397\t2.962\t0.816\t2\n184398\t2.985\t0.39\t19\n184399\t3.255\t0.176\t61\n184400\t3.215\t0.059\t6\n184402\t3.402\t0.003\t2\n184403\t3.348\t0.247\t21\n184412\t3.283\t0.005\t3\n184581\t2.634\t0.295\t6\n184582\t2.568\t0.171\t12855\n184583\t2.441\t0.153\t3081\n184584\t2.416\t0.166\t1225\n184591\t2.739\t0.094\t61\n184592\t2.805\t0.202\t148\n184837\t2.886\t-1.0\t1\n184838\t2.196\t0.199\t2670\n184839\t2.45\t0.148\t279\n184848\t2.287\t0.009\t6\n188462\t3.197\t0.284\t549\n188463\t3.567\t0.174\t71\n188465\t3.129\t0.275\t2\n188466\t3.378\t0.343\t81\n188467\t3.278\t0.49\t122\n188468\t3.121\t0.318\t140\n188469\t3.118\t0.179\t936\n188472\t3.155\t0.189\t11\n188486\t2.788\t-1.0\t1\n188487\t3.697\t0.043\t2\n188490\t3.361\t-1.0\t1\n188491\t3.319\t0.01\t2\n188492\t3.071\t0.101\t16\n188494\t3.253\t0.286\t17\n188495\t3.308\t0.347\t126\n188496\t3.082\t0.313\t5\n188497\t3.342\t0.379\t39\n188498\t3.685\t0.035\t11\n188499\t2.981\t0.028\t91\n188508\t3.265\t0.257\t3\n188677\t2.545\t0.218\t11\n188678\t2.381\t0.169\t6266\n188679\t2.365\t0.135\t7580\n188680\t2.446\t0.147\t1073\n188687\t2.778\t0.159\t82\n188688\t2.732\t0.177\t615\n188934\t2.405\t0.21\t1341\n188935\t2.38\t0.131\t281\n188936\t2.152\t0.004\t2\n188944\t2.657\t0.082\t9\n192559\t3.554\t0.226\t4083\n192561\t2.716\t-1.0\t1\n192562\t3.443\t0.292\t14\n192563\t3.163\t0.241\t12\n192564\t3.698\t0.229\t62\n192565\t3.522\t0.275\t796\n192572\t3.827\t0.068\t3\n192587\t3.3\t0.096\t6\n192588\t3.119\t0.06\t30\n192589\t3.417\t0.237\t27\n192590\t3.436\t0.273\t279\n192591\t3.326\t0.24\t399\n192592\t2.823\t0.436\t7\n192774\t2.472\t0.2\t1611\n192775\t2.535\t0.173\t5301\n192776\t2.731\t0.17\t305\n192783\t2.898\t0.163\t18\n192784\t3.194\t0.23\t847\n193030\t2.719\t0.257\t1011\n193031\t2.571\t0.187\t351\n196656\t2.962\t0.143\t4\n196659\t2.984\t0.064\t32\n196660\t3.488\t0.2\t53\n196661\t3.212\t0.24\t422\n196664\t3.568\t0.009\t4\n196686\t3.302\t0.12\t162\n196687\t3.375\t0.136\t15\n196690\t3.639\t0.028\t8\n196691\t3.016\t0.052\t32\n196870\t2.546\t0.218\t32\n196871\t2.669\t0.125\t3379\n196872\t2.711\t0.152\t719\n196880\t3.123\t0.225\t349\n197126\t2.828\t0.381\t77\n197127\t2.606\t0.119\t56\n197128\t2.751\t-1.0\t1\n200753\t2.968\t0.291\t109\n200754\t3.781\t0.18\t17\n200755\t2.926\t0.006\t4\n200756\t3.55\t0.394\t50\n200757\t3.215\t0.314\t179\n200759\t3.813\t0.152\t8\n200760\t3.68\t0.079\t15\n200778\t3.2\t0.021\t2\n200779\t2.798\t0.024\t24\n200781\t2.816\t0.38\t2\n200782\t3.146\t0.138\t51\n200783\t3.783\t-1.0\t1\n200784\t3.608\t0.06\t2\n200787\t3.701\t0.063\t13\n200966\t2.737\t0.248\t164\n200967\t2.638\t0.193\t666\n200968\t2.735\t0.196\t128\n200975\t3.61\t0.145\t5\n200976\t2.787\t0.336\t60\n201222\t2.754\t0.18\t12\n201223\t2.897\t0.149\t12\n204850\t3.629\t0.476\t976\n204851\t2.793\t0.054\t34\n204852\t3.367\t0.645\t98\n204853\t3.325\t0.463\t310\n204855\t3.996\t0.344\t33\n204856\t3.682\t0.08\t11\n204857\t3.947\t0.023\t6\n204858\t3.186\t0.0\t6\n204863\t3.44\t0.0\t11\n204866\t3.929\t-1.0\t1\n204870\t3.525\t0.118\t8\n204872\t4.135\t0.14\t3\n204874\t3.301\t0.205\t57\n204875\t3.121\t0.234\t55\n204876\t3.203\t0.168\t70\n204877\t3.061\t0.08\t42\n204878\t3.284\t0.173\t281\n204879\t4.309\t0.589\t23\n204881\t3.669\t0.346\t5\n204882\t3.46\t0.055\t10\n204883\t3.636\t0.704\t18\n204892\t4.537\t-1.0\t1\n205061\t2.753\t0.308\t17\n205062\t2.528\t0.15\t3869\n205063\t2.708\t0.199\t1070\n205064\t2.716\t0.2\t545\n205071\t3.421\t0.246\t38\n205072\t3.123\t0.212\t212\n205318\t2.574\t0.174\t88\n205319\t2.626\t0.158\t25\n208947\t2.969\t0.506\t259\n208948\t3.77\t0.671\t12\n208949\t3.392\t0.45\t229\n208951\t3.952\t0.118\t44\n208952\t3.545\t0.115\t138\n208953\t3.197\t0.0\t6\n208954\t3.176\t0.0\t6\n208962\t3.825\t0.039\t12\n208968\t3.44\t-1.0\t1\n208970\t3.273\t0.166\t30\n208971\t3.245\t0.214\t83\n208972\t2.968\t0.115\t113\n208973\t3.43\t0.067\t4\n208974\t3.1\t0.205\t80\n208975\t3.122\t0.204\t60\n208976\t3.551\t0.081\t6\n208977\t4.668\t0.032\t6\n208978\t4.088\t0.033\t12\n208979\t2.917\t0.271\t11\n209158\t2.495\t0.15\t1844\n209159\t2.721\t0.28\t225\n209160\t2.668\t0.436\t78\n209167\t3.017\t0.046\t5\n209168\t3.149\t0.165\t38\n209414\t2.509\t0.24\t10\n209415\t2.427\t0.146\t6\n213050\t4.433\t0.045\t6\n213054\t4.024\t0.099\t10\n213065\t5.027\t-1.0\t1\n213066\t2.704\t0.455\t23\n213067\t3.276\t0.286\t165\n213068\t3.025\t0.034\t20\n213070\t3.155\t0.284\t48\n213071\t3.03\t0.209\t38\n213072\t3.343\t0.249\t92\n213073\t4.446\t0.01\t2\n213074\t4.01\t0.314\t16\n213075\t3.489\t0.653\t32\n213084\t3.85\t0.333\t22\n213086\t4.355\t0.043\t6\n217145\t3.893\t0.312\t115\n217146\t4.057\t0.272\t72\n217147\t3.309\t0.409\t38\n217148\t3.875\t0.23\t104\n217150\t3.913\t0.338\t122\n217151\t4.078\t0.166\t14\n217152\t3.772\t0.324\t18\n217153\t3.606\t0.456\t25\n217154\t3.192\t0.524\t27\n217156\t3.103\t0.413\t22\n217157\t3.863\t0.489\t46\n217158\t3.761\t0.157\t82\n217159\t3.66\t0.413\t6\n217160\t3.35\t0.322\t22\n217161\t2.816\t0.4\t52\n217162\t2.801\t0.247\t341\n217163\t2.814\t0.353\t94\n217164\t2.999\t0.191\t26\n217165\t3.222\t0.232\t233\n217166\t3.234\t0.277\t811\n217167\t3.066\t0.296\t281\n217168\t3.131\t0.252\t665\n217169\t2.89\t0.413\t19\n217170\t3.801\t0.427\t565\n217171\t3.582\t0.409\t827\n217178\t3.927\t0.242\t20\n217180\t3.819\t0.264\t406\n217182\t3.899\t0.189\t7\n217183\t3.278\t-1.0\t1\n225335\t4.276\t0.49\t265\n225336\t4.479\t0.154\t3\n225338\t4.3\t0.0\t2\n225345\t4.243\t-1.0\t1\n225346\t4.182\t-1.0\t1\n225354\t3.789\t-1.0\t1\n225359\t3.687\t0.153\t5\n225360\t4.965\t0.0\t3\n225361\t4.086\t0.077\t5\n225362\t3.938\t0.124\t17\n225363\t4.209\t0.153\t5\n225542\t4.026\t0.331\t148\n225797\t3.377\t0.162\t3\n225798\t3.864\t0.248\t33\n229432\t4.077\t0.334\t194\n229450\t3.552\t0.0\t2\n229455\t3.61\t0.0\t2\n229458\t3.779\t0.076\t5\n229459\t3.62\t0.105\t15\n229638\t3.726\t0.142\t169\n229893\t2.88\t0.148\t17\n233547\t3.663\t0.041\t4\n233733\t3.661\t0.127\t9\n233734\t3.511\t0.169\t1320\n233735\t3.103\t0.143\t699\n233736\t2.952\t0.191\t544\n233743\t4.137\t0.779\t6\n233744\t3.541\t0.191\t21\n233990\t3.356\t0.17\t18\n233991\t3.128\t0.157\t55\n237830\t3.517\t0.262\t866\n237831\t3.053\t0.238\t780\n237832\t2.942\t0.272\t364\n237839\t3.058\t0.078\t3\n237840\t3.557\t0.208\t14\n238086\t3.309\t0.197\t15\n238087\t3.084\t0.184\t40\n241926\t3.477\t0.124\t197\n241927\t3.016\t0.163\t300\n241928\t2.871\t0.151\t320\n241936\t3.545\t0.074\t6\n242182\t3.213\t0.142\t3\n242183\t3.034\t0.049\t17\n246021\t3.749\t-1.0\t1\n246022\t3.442\t0.199\t803\n246023\t3.027\t0.153\t733\n246024\t2.83\t0.16\t737\n246031\t3.715\t0.509\t10\n246032\t3.489\t0.117\t10\n246278\t3.07\t0.175\t7\n246279\t3.018\t0.113\t65\n254014\t3.621\t0.145\t11\n254027\t3.568\t0.017\t3\n254214\t3.39\t0.158\t2671\n254215\t2.996\t0.161\t998\n254216\t2.805\t0.192\t556\n254223\t3.737\t0.252\t40\n254224\t3.439\t0.148\t13\n254470\t3.227\t0.142\t6\n254471\t3.139\t0.173\t24\n254472\t2.911\t0.206\t20\n258111\t2.215\t0.23\t2\n258310\t3.466\t0.262\t271\n258311\t2.927\t0.187\t1239\n258312\t2.76\t0.166\t1083\n258320\t3.383\t0.05\t12\n258566\t3.457\t0.042\t4\n258567\t2.819\t0.112\t11\n262406\t3.329\t0.213\t453\n262407\t2.926\t0.184\t889\n262408\t2.796\t0.186\t1231\n262416\t3.355\t0.381\t10\n262662\t2.919\t0.044\t2\n262663\t2.999\t0.226\t11\n266502\t3.401\t0.179\t388\n266503\t2.89\t0.17\t992\n266504\t2.734\t0.193\t1159\n266511\t3.732\t-1.0\t1\n266512\t3.445\t0.0\t2\n266758\t2.926\t-1.0\t1\n266759\t2.857\t0.231\t31\n270597\t3.404\t0.076\t3\n270598\t3.222\t0.253\t1595\n270599\t2.866\t0.193\t2042\n270600\t2.707\t0.189\t2073\n270607\t3.718\t-1.0\t1\n270608\t3.41\t0.38\t13\n270854\t2.9\t-1.0\t1\n270855\t2.794\t0.192\t30\n274510\t4.001\t0.0\t2\n274694\t3.388\t0.171\t354\n274695\t2.87\t0.172\t416\n274696\t2.724\t0.185\t439\n274950\t2.925\t0.039\t8\n274951\t2.479\t0.253\t12\n278789\t3.409\t0.069\t2\n278790\t3.158\t0.169\t1145\n278791\t2.849\t0.175\t801\n278792\t2.672\t0.179\t577\n278799\t3.625\t-1.0\t1\n278800\t3.474\t0.092\t7\n279046\t2.934\t0.097\t12\n279047\t2.89\t0.09\t12\n282693\t3.553\t0.0\t4\n282886\t3.443\t0.178\t536\n282887\t2.879\t0.209\t168\n282888\t2.725\t0.147\t129\n282895\t3.631\t0.142\t21\n282896\t3.222\t0.01\t8\n283143\t2.527\t0.136\t9\n286981\t3.507\t0.084\t5\n286982\t3.184\t0.155\t3390\n286983\t2.859\t0.153\t1245\n286984\t2.682\t0.159\t499\n286991\t3.54\t0.155\t13\n286992\t3.365\t0.159\t9\n287238\t3.019\t0.138\t24\n287239\t2.855\t0.076\t16\n287240\t2.979\t0.21\t26\n290891\t3.455\t0.011\t2\n290894\t3.514\t-1.0\t1\n291077\t3.476\t0.16\t11\n291078\t3.284\t0.204\t878\n291079\t2.84\t0.187\t460\n291080\t2.635\t0.193\t132\n291088\t3.528\t0.062\t2\n291334\t2.883\t0.06\t12\n291335\t2.948\t0.137\t14\n294994\t3.999\t-1.0\t1\n295173\t3.165\t0.193\t2\n295174\t3.107\t0.177\t2432\n295175\t2.774\t0.182\t341\n295176\t2.652\t0.204\t104\n295184\t3.109\t0.166\t9\n295430\t2.767\t0.112\t12\n295431\t2.657\t0.278\t12\n299081\t2.935\t0.369\t17\n299085\t3.119\t0.214\t10\n299270\t2.918\t0.218\t1400\n299271\t2.737\t0.199\t305\n299272\t2.492\t0.248\t40\n299279\t2.559\t0.037\t4\n299526\t2.488\t0.241\t28\n299527\t2.804\t0.155\t6\n303178\t2.675\t0.417\t434\n303181\t3.222\t0.078\t41\n303182\t3.654\t-1.0\t1\n303183\t3.21\t0.023\t4\n303186\t3.733\t0.044\t8\n303187\t3.128\t0.192\t8\n303365\t2.968\t0.028\t2\n303366\t2.8\t0.213\t3774\n303367\t2.584\t0.227\t2258\n303368\t2.49\t0.297\t312\n303375\t2.904\t0.202\t124\n303376\t3.053\t0.272\t32\n303622\t2.342\t0.159\t6180\n303623\t2.471\t0.154\t65\n307275\t3.127\t0.383\t1161\n307276\t3.076\t0.401\t28\n307277\t3.191\t0.02\t2\n307278\t3.567\t0.117\t38\n307279\t3.269\t0.094\t25\n307280\t3.228\t0.038\t20\n307281\t3.587\t0.03\t2\n307283\t3.205\t0.081\t30\n307292\t3.713\t0.164\t4\n307462\t2.629\t0.197\t1542\n307463\t2.457\t0.127\t3999\n307464\t2.435\t0.206\t207\n307471\t2.732\t0.251\t11\n307472\t2.825\t0.122\t121\n307718\t2.178\t0.135\t8471\n307719\t2.383\t0.156\t157\n307720\t2.299\t0.121\t3\n307728\t2.409\t0.014\t6\n311372\t3.106\t0.207\t804\n311373\t3.181\t-1.0\t1\n311374\t3.548\t0.146\t32\n311375\t3.12\t0.036\t62\n311379\t2.887\t0.06\t22\n311558\t2.597\t0.187\t2089\n311559\t2.357\t0.157\t1187\n311560\t2.486\t0.163\t95\n311567\t3.048\t0.26\t4\n311568\t3.082\t0.291\t44\n311814\t2.108\t0.152\t4572\n311815\t2.428\t0.139\t86\n311824\t2.543\t0.001\t4\n315469\t3.151\t0.278\t365\n315470\t3.549\t0.122\t63\n315471\t3.157\t0.118\t31\n315475\t3.22\t0.061\t39\n315653\t2.65\t0.215\t20\n315654\t2.552\t0.195\t16080\n315655\t2.382\t0.126\t6084\n315656\t2.483\t0.127\t418\n315663\t2.762\t0.14\t37\n315664\t2.816\t0.196\t162\n315910\t2.215\t0.168\t2203\n315911\t2.436\t0.105\t204\n315920\t2.977\t-1.0\t1\n319566\t3.225\t0.248\t552\n319567\t3.367\t0.293\t115\n319568\t3.169\t0.205\t20\n319569\t3.36\t0.238\t50\n319570\t3.392\t0.286\t42\n319571\t2.929\t0.286\t8\n319580\t2.758\t-1.0\t1\n319749\t2.528\t0.434\t19\n319750\t2.374\t0.187\t4743\n319751\t2.364\t0.145\t6282\n319752\t2.404\t0.169\t399\n319759\t2.743\t0.15\t63\n319760\t2.674\t0.189\t638\n320005\t2.585\t0.095\t3\n320006\t2.331\t0.173\t2612\n320007\t2.357\t0.121\t135\n320015\t2.781\t0.006\t2\n320016\t2.898\t0.124\t6\n323663\t3.245\t0.336\t4562\n323664\t3.526\t0.142\t2\n323665\t3.286\t0.102\t22\n323666\t3.306\t0.022\t2\n323667\t2.881\t0.196\t25\n323846\t2.35\t0.15\t3014\n323847\t2.354\t0.137\t1158\n323848\t2.403\t0.253\t6\n323855\t2.769\t0.169\t45\n323856\t2.739\t0.213\t222\n324102\t2.337\t0.19\t1691\n324103\t2.388\t0.156\t45\n327760\t2.694\t0.474\t53\n327941\t2.577\t-1.0\t1\n327942\t2.266\t0.136\t922\n327943\t2.741\t0.157\t953\n327944\t2.741\t0.235\t37\n327951\t2.904\t0.093\t8\n327952\t2.866\t0.242\t158\n328198\t2.38\t0.168\t94\n328199\t2.875\t0.15\t3\n331857\t3.111\t0.21\t60\n332038\t2.542\t0.227\t19\n332039\t2.984\t0.13\t175\n332040\t2.942\t0.295\t20\n332048\t3.399\t0.21\t18\n332294\t2.174\t0.0\t4\n335954\t3.231\t0.429\t436\n336134\t2.776\t0.248\t252\n336135\t2.833\t0.135\t693\n336136\t2.76\t0.196\t207\n336143\t3.678\t0.123\t15\n336144\t3.263\t0.218\t66\n336390\t2.874\t0.122\t4\n336391\t2.699\t0.147\t7\n340051\t3.126\t0.27\t404\n340229\t2.797\t-1.0\t1\n340230\t2.623\t0.24\t807\n340231\t2.807\t0.169\t491\n340232\t2.771\t0.212\t269\n340239\t3.206\t0.012\t2\n340240\t3.325\t0.293\t98\n340486\t2.701\t0.167\t16\n340487\t3.129\t0.34\t2\n368902\t3.528\t0.229\t2516\n368903\t3.077\t0.237\t337\n368904\t2.966\t0.304\t84\n368911\t3.616\t0.121\t7\n368912\t3.535\t0.376\t64\n369158\t3.14\t0.113\t14\n369159\t3.146\t0.323\t8\n369160\t3.179\t0.006\t2\n376924\t3.747\t0.0\t2\n377094\t3.44\t0.227\t3394\n377095\t2.982\t0.201\t1971\n377096\t2.826\t0.242\t770\n377103\t2.998\t0.426\t10\n377104\t3.462\t0.179\t110\n377350\t3.258\t0.302\t74\n377351\t3.02\t0.219\t96\n377352\t3.011\t0.211\t9\n381190\t3.595\t0.186\t49\n381191\t3.016\t0.171\t33\n381192\t3.071\t0.23\t47\n381200\t3.429\t0.053\t8\n385286\t3.676\t0.046\t15\n385287\t3.005\t0.218\t31\n385288\t3.065\t0.263\t47\n385296\t3.84\t0.251\t6\n389383\t3.107\t0.032\t5\n389384\t2.858\t0.234\t18\n389392\t3.517\t0.038\t3\n393479\t3.128\t0.008\t2\n393488\t3.419\t0.064\t3\n397575\t3.05\t0.029\t3\n397576\t2.942\t0.008\t3\n401671\t3.038\t0.025\t3\n401672\t2.931\t0.016\t3\n1073414\t1.594\t0.077\t2000853\n1073415\t1.527\t0.071\t91806\n1073423\t2.001\t0.161\t74\n1073424\t1.981\t0.067\t42\n1073679\t2.05\t0.093\t4\n1073680\t1.992\t0.039\t7\n1077511\t1.504\t0.087\t791\n1077519\t1.839\t0.106\t1862\n1077520\t1.811\t0.097\t38\n1077776\t1.753\t0.11\t23\n1110287\t2.325\t0.221\t8\n16781317\t1.299\t0.138\t2655\n16781318\t1.157\t0.073\t2154155\n16781319\t1.027\t0.087\t120477\n16781320\t1.0\t0.102\t99234\n16781321\t1.229\t0.768\t39\n16781326\t1.698\t0.206\t492\n16781327\t1.491\t0.16\t461\n16781328\t1.414\t0.148\t260\n16781329\t1.46\t0.267\t16\n16781344\t1.768\t0.207\t170\n16781345\t1.64\t0.233\t13\n16781346\t1.184\t0.24\t11\n16781347\t1.193\t0.14\t10\n16781365\t1.612\t0.001\t2\n16781573\t1.266\t-1.0\t1\n16781574\t1.083\t0.054\t1399983\n16781575\t1.026\t0.08\t10086\n16781576\t1.035\t0.083\t62\n16781583\t1.555\t0.169\t170\n16781830\t1.082\t0.064\t1503\n16781831\t1.012\t0.075\t9\n16797701\t2.055\t0.175\t200\n16797702\t1.917\t0.136\t1968\n16797703\t1.74\t0.145\t4307\n16797704\t1.627\t0.111\t7838\n16797705\t1.579\t0.095\t5410\n16797710\t2.643\t0.184\t32\n16797711\t2.367\t0.191\t736\n16797712\t2.279\t0.266\t207\n16797713\t2.22\t0.188\t513\n16797728\t2.564\t0.128\t21\n16797729\t2.481\t0.101\t5\n16797730\t2.577\t0.148\t48\n16797731\t2.401\t0.231\t244\n16797748\t2.725\t0.14\t4\n16797749\t2.87\t0.374\t77\n16797958\t1.838\t0.106\t11969\n16797959\t1.825\t0.108\t1915\n16797967\t2.268\t0.255\t20\n16798214\t1.868\t0.127\t268\n16798215\t1.772\t0.141\t42\n16798224\t2.259\t-1.0\t1\n16801798\t1.819\t0.111\t650683\n16801799\t1.721\t0.104\t153277\n16801800\t1.674\t0.089\t194202\n16801801\t1.483\t0.083\t37441\n16801806\t2.363\t0.237\t31159\n16801807\t2.243\t0.189\t5173\n16801808\t2.128\t0.132\t11654\n16801809\t2.024\t0.124\t15529\n16801824\t2.527\t0.248\t999\n16801825\t2.422\t0.325\t206\n16801826\t2.378\t0.18\t872\n16801827\t2.279\t0.155\t2704\n16801844\t2.666\t0.308\t172\n16801845\t2.522\t0.166\t717\n16802054\t1.762\t0.092\t352183\n16802055\t1.72\t0.097\t14388\n16802056\t1.688\t0.108\t6\n16802063\t2.207\t0.172\t3307\n16802064\t2.105\t0.131\t3350\n16802310\t1.696\t0.091\t7665\n16802311\t1.656\t0.128\t75\n16802320\t2.082\t0.116\t4919\n16805895\t1.623\t0.108\t3208\n16805896\t1.666\t0.126\t2100\n16805897\t1.415\t0.162\t17\n16805902\t2.205\t0.191\t1967\n16805903\t2.079\t0.152\t1682\n16805904\t1.93\t0.103\t249\n16805905\t1.958\t0.111\t24\n16805920\t2.362\t0.195\t1315\n16805921\t2.241\t0.173\t128\n16805922\t2.3\t0.193\t96\n16805923\t2.162\t0.118\t32\n16805940\t2.674\t0.201\t118\n16805941\t2.473\t0.194\t38\n16806150\t1.59\t0.082\t164495\n16806151\t1.574\t0.081\t7627\n16806159\t1.986\t0.139\t3197\n16806160\t2.009\t0.09\t401\n16806406\t1.512\t0.069\t153\n16806407\t1.394\t0.086\t533\n16806416\t1.9\t0.093\t9234\n16809992\t1.741\t0.264\t647\n16809998\t1.995\t0.155\t7813\n16809999\t1.925\t0.144\t1208\n16810000\t1.916\t0.201\t51\n16810001\t1.673\t0.087\t998\n16810016\t2.152\t0.242\t1021\n16810017\t1.796\t0.244\t670\n16810018\t2.006\t0.2\t174\n16810019\t1.965\t0.381\t4\n16810036\t2.404\t0.302\t460\n16810037\t2.386\t0.22\t205\n16810246\t1.562\t0.08\t163577\n16810247\t1.393\t0.102\t21110\n16810255\t1.861\t0.129\t9068\n16810256\t1.926\t0.104\t123\n16810502\t1.408\t0.07\t41\n16810503\t1.354\t0.073\t7\n16810512\t1.734\t0.114\t5958\n16814089\t1.446\t0.064\t5\n16814094\t1.979\t0.162\t679\n16814095\t1.82\t0.095\t9307\n16814096\t1.773\t0.108\t625\n16814097\t1.615\t0.213\t20\n16814112\t2.054\t0.303\t209\n16814113\t1.845\t0.169\t415\n16814114\t2.218\t0.193\t16\n16814115\t1.836\t0.098\t23\n16814132\t1.837\t0.254\t287\n16814133\t2.14\t0.294\t84\n16814342\t1.478\t0.072\t44091\n16814343\t1.246\t0.169\t3\n16814351\t1.618\t0.194\t150\n16814352\t1.613\t0.103\t16\n16814608\t1.556\t0.127\t44\n16834574\t3.378\t0.364\t2682\n16834575\t2.882\t0.272\t162\n16834576\t2.626\t0.23\t157\n16834577\t2.549\t0.274\t1011\n16834592\t3.473\t0.286\t507\n16834593\t3.314\t0.371\t24\n16834594\t2.897\t0.327\t42\n16834595\t2.87\t0.389\t169\n16834612\t3.665\t0.536\t15\n16834613\t3.09\t0.417\t78\n16834822\t2.235\t0.149\t6897\n16834823\t2.299\t0.166\t545\n16835078\t2.237\t0.123\t1405\n16835079\t2.102\t0.162\t46\n16838671\t2.751\t0.246\t664\n16838672\t2.368\t0.224\t165\n16838673\t2.447\t0.27\t425\n16838688\t3.18\t0.313\t89\n16838689\t2.773\t0.119\t26\n16838690\t2.582\t0.333\t127\n16838691\t2.563\t0.288\t58\n16838708\t3.027\t0.178\t12\n16838709\t2.915\t0.394\t101\n16838918\t2.115\t0.115\t8657\n16838919\t1.855\t0.183\t439\n16838927\t2.715\t0.169\t135\n16838928\t2.658\t0.069\t6\n16839174\t1.936\t0.185\t23\n16839175\t2.101\t0.064\t2\n16839184\t2.948\t-1.0\t1\n16842768\t2.281\t0.201\t1234\n16842769\t2.015\t0.03\t13\n16842784\t2.754\t0.331\t616\n16842785\t2.241\t0.25\t917\n16842786\t2.475\t0.266\t49\n16842787\t2.694\t0.214\t14\n16842804\t3.261\t0.399\t44\n16842805\t3.241\t0.251\t46\n16843014\t2.01\t0.115\t20813\n16843015\t1.834\t0.133\t156\n16843023\t2.464\t0.209\t339\n16843024\t2.494\t0.161\t19\n16843270\t1.935\t0.13\t225\n16843280\t2.489\t0.19\t50\n16846865\t1.992\t0.399\t44\n16846880\t2.745\t0.286\t511\n16846881\t2.728\t0.235\t235\n16846882\t2.384\t0.337\t109\n16846900\t3.03\t0.369\t277\n16846901\t2.906\t0.468\t87\n16847110\t1.969\t0.095\t20992\n16847111\t1.77\t0.177\t16\n16847119\t2.289\t0.187\t1133\n16847120\t2.181\t0.113\t8\n16847366\t1.923\t0.203\t4\n16847376\t2.231\t0.165\t28\n16908320\t3.119\t0.561\t1100\n16908321\t2.481\t0.4\t70\n16908322\t2.624\t0.585\t344\n16908323\t2.911\t0.375\t127\n16908340\t3.181\t0.424\t124\n16908341\t3.271\t0.469\t73\n16908550\t2.342\t0.169\t2233\n16908551\t2.432\t0.175\t414\n16908552\t2.284\t0.062\t14\n16908559\t3.148\t0.384\t31\n16908806\t2.273\t0.193\t233\n16912417\t2.568\t0.286\t226\n16912418\t2.384\t0.277\t52\n16912419\t2.383\t0.526\t37\n16912436\t2.868\t0.102\t3\n16912437\t3.175\t0.376\t43\n16912646\t2.247\t0.155\t563\n16912647\t2.196\t0.137\t13\n16912655\t2.8\t0.063\t13\n16912902\t1.902\t0.429\t4\n16912903\t2.164\t0.088\t7\n16916514\t2.705\t0.288\t257\n16916515\t2.826\t0.329\t129\n16916532\t3.054\t0.385\t17\n16916533\t3.596\t0.24\t25\n16916742\t2.215\t0.127\t1635\n16916743\t1.989\t0.141\t55\n16916751\t2.686\t0.173\t226\n16916752\t2.64\t-1.0\t1\n16916998\t2.197\t0.154\t196\n16920611\t3.015\t0.264\t187\n16920628\t3.279\t0.255\t239\n16920629\t3.195\t0.403\t63\n16920838\t2.164\t0.108\t13670\n16920839\t2.524\t0.134\t43\n16920847\t2.176\t0.207\t50\n16920848\t2.785\t0.214\t9\n16921094\t2.117\t0.097\t16\n16990260\t3.228\t0.382\t40\n16990261\t3.606\t0.35\t107\n16990470\t2.49\t0.154\t812\n16990471\t2.273\t0.267\t50\n16990472\t3.042\t-1.0\t1\n16990479\t3.31\t0.124\t16\n16990726\t2.535\t0.253\t17\n16994357\t3.54\t0.331\t863\n16994566\t2.373\t0.134\t5123\n16994567\t2.597\t0.154\t114\n16994575\t3.258\t0.143\t18\n16994822\t2.308\t0.108\t265\n16994823\t2.683\t0.0\t2\n17846534\t1.807\t0.004\t6\n17850630\t1.686\t0.082\t194786\n17850631\t1.634\t0.082\t26774\n17850632\t1.542\t0.034\t5\n17850639\t2.101\t0.105\t7379\n17850640\t2.077\t0.073\t1123\n17850886\t1.624\t0.087\t18128\n17850887\t1.587\t0.111\t90\n17850896\t2.041\t0.093\t13784\n17854727\t1.605\t0.077\t739\n17854735\t1.988\t0.193\t481\n17854736\t2.01\t0.157\t103\n17854982\t1.518\t0.05\t118\n17854983\t1.299\t0.035\t2\n17854991\t2.079\t0.0\t2\n17854992\t1.872\t0.081\t564\n17858824\t1.212\t0.0\t2\n17887503\t2.816\t0.232\t70\n17887504\t2.775\t-1.0\t1\n17887750\t2.038\t0.159\t42\n17887760\t2.72\t0.033\t2\n17891600\t2.75\t0.187\t12\n17891856\t2.984\t-1.0\t1\n18899462\t1.586\t0.08\t708\n18899472\t2.099\t0.117\t10\n18940432\t2.57\t0.156\t5\n33611790\t2.862\t0.219\t107\n33611809\t3.023\t-1.0\t1\n33611810\t1.697\t0.952\t3\n33611828\t3.382\t-1.0\t1\n33612038\t2.267\t0.06\t19\n33612039\t2.076\t0.084\t9\n33612040\t2.213\t0.116\t7\n33612047\t3.299\t0.356\t32\n33612048\t2.829\t-1.0\t1\n33612294\t2.498\t0.086\t4\n33624117\t2.68\t0.0\t2\n33624326\t2.051\t0.166\t7\n33624328\t1.644\t0.085\t2970\n33685536\t3.587\t0.192\t22\n33685537\t3.362\t0.618\t7\n33685539\t2.768\t-1.0\t1\n33685766\t2.418\t0.096\t23\n33685767\t2.3\t-1.0\t1\n33685768\t1.911\t0.307\t75\n33685775\t3.061\t0.334\t74\n33685776\t3.159\t0.258\t11\n33686022\t2.244\t-1.0\t1\n33689633\t2.268\t0.368\t3\n33689634\t3.2\t0.0\t2\n33689653\t3.142\t0.113\t4\n33689862\t1.874\t0.13\t10\n33689863\t1.999\t-1.0\t1\n33689864\t2.138\t0.163\t58\n33689871\t2.766\t0.099\t11\n33689872\t2.702\t0.904\t6\n33693731\t3.211\t0.049\t4\n33693748\t3.96\t0.381\t8\n33693749\t3.32\t0.198\t7\n33693958\t2.081\t0.047\t6\n33693959\t2.112\t0.21\t9\n33693960\t1.88\t0.205\t162\n33693967\t2.503\t0.176\t332\n33697844\t3.872\t0.0\t2\n33698055\t1.967\t-1.0\t1\n33698056\t1.612\t0.028\t8\n33767476\t2.657\t-1.0\t1\n33767477\t3.446\t-1.0\t1\n33767686\t2.131\t0.005\t3\n33767687\t2.1\t-1.0\t1\n33767688\t2.267\t0.518\t6\n33767695\t2.857\t0.194\t7\n33767696\t3.719\t0.957\t3\n33771573\t3.614\t0.457\t10\n33771783\t2.249\t0.088\t5\n33771784\t2.127\t0.16\t106\n33771791\t3.098\t-1.0\t1\n33771792\t3.166\t0.428\t3\n34623750\t1.78\t0.012\t7\n34627846\t1.55\t0.083\t65623\n34627847\t1.486\t0.077\t27424\n34627848\t1.404\t0.071\t156637\n34627855\t2.044\t0.135\t373\n34627856\t1.945\t0.103\t4751\n34628102\t1.526\t0.109\t716\n34628112\t1.965\t0.141\t8\n34631943\t1.436\t0.08\t1641\n34631944\t1.371\t0.063\t17326\n34631951\t1.879\t0.175\t1347\n34631952\t1.901\t0.158\t89\n34632198\t1.396\t0.123\t200\n34632199\t1.374\t0.136\t116\n34632207\t2.095\t0.0\t2\n34632208\t1.812\t0.114\t109\n34636040\t1.131\t0.253\t79\n34636047\t1.751\t0.123\t5003\n34636048\t1.76\t0.092\t2467\n34636294\t1.228\t0.157\t96\n34636295\t1.111\t0.035\t20\n34636304\t1.661\t0.085\t34493\n34664719\t2.605\t0.159\t86\n34664720\t2.299\t0.162\t912\n34664966\t1.951\t0.174\t35\n34664967\t1.804\t0.217\t28\n34664975\t2.749\t0.0\t2\n34664976\t2.399\t-1.0\t1\n34668816\t2.417\t0.111\t4\n34669062\t1.893\t0.17\t143\n34669071\t2.291\t0.138\t2\n35676678\t1.475\t0.093\t37\n52453894\t1.376\t0.081\t8518\n52453895\t1.293\t0.068\t14577\n52453896\t1.593\t0.165\t45\n52453903\t1.768\t0.204\t5\n52457991\t1.263\t0.085\t581\n52458000\t1.392\t0.156\t3\n83914759\t1.547\t0.085\t5\n83915013\t1.739\t0.204\t7\n83915014\t1.572\t0.079\t50584\n83915015\t1.539\t0.074\t8699\n83915023\t1.977\t0.137\t53\n83919110\t1.558\t0.068\t8984\n83919111\t1.575\t0.101\t961\n83919119\t2.014\t0.019\t9\n83951650\t2.389\t0.04\t4\n83951878\t1.973\t0.109\t22593\n83951879\t1.799\t0.11\t991\n83951887\t2.464\t-1.0\t1\n83951888\t2.672\t0.158\t11\n84025378\t2.575\t0.005\t2\n84025606\t2.151\t0.135\t549\n84025607\t2.077\t0.132\t184\n84959494\t1.626\t0.085\t32317\n84959495\t1.575\t0.081\t14689\n84959503\t2.111\t0.074\t20\n84959504\t2.015\t0.127\t36\n84963591\t1.557\t0.073\t2345\n84963599\t1.935\t0.256\t2\n84963600\t2.2\t0.296\t11\n100802822\t2.071\t0.051\t5\n100802823\t1.97\t0.021\t4\n101732615\t1.731\t0.197\t7\n101736710\t1.567\t0.082\t49304\n101736711\t1.502\t0.079\t23379\n101736719\t2.028\t0.119\t39\n101736720\t1.978\t0.107\t31\n101740807\t1.481\t0.072\t2974\n101740815\t1.989\t0.139\t38\n101740816\t1.737\t0.078\t11\n101773584\t2.915\t0.094\t4",H))[0],t=Jl.nGb(e,Vt,I),Ql.Bv=vf(kl.llb,z,6,t,15,1),Ql.Cv=vf(kl.klb,xt,6,t,15,1),Ql.Dv=vf(kl.klb,xt,6,t,15,1),Ql.Av=vf(kl.llb,z,6,t,15,1),i=0;i<t;i++)if(a=n[i+1],4==(s=Jl.OHb(a,"\t")).length)try{Ql.Bv[i]=Jl.nGb(s[0],Vt,I),Ql.Cv[i]=tu(s[1]),Ql.Dv[i]=tu(s[2]),Ql.Av[i]=Jl.nGb(s[3],Vt,I)}catch(n){if(_f(n=rg(n),53))break;throw og(n)}Ql.Fv=!0}},Ql.Pv=function(n){var t,e,i,s;for(Ql.Fv||Ql.Ov(),s=zn,i=hn,e=0;e<12;e++){if(0==(t=s>=Ql.Bv.length||n<Ql.Bv[s]?-1:n==Ql.Bv[s]?0:1))return s;s=t<0?s-i:s+i,i=i/2|0}return-1},zf(524,1,{},Ql.Iv),Ql.Fv=!1,kl.lmb=lg(524),Ql.Qv=function(n,t){n.q=Ql.Nw(new Ql.Qw(n.o,t),n)},Ql.Rv=function(t,e){var i,s,a,r,o,l,f,g,u;return i=Ql.Xv(t,e[0]),s=Ql.Xv(t,e[1]),a=Ql.Xv(t,e[2]),r=Ql.Xv(t,e[3]),f=new xl.Sh(s.a-i.a,s.b-i.b,s.c-i.c),g=new xl.Sh(a.a-s.a,a.b-s.b,a.c-s.c),u=new xl.Sh(r.a-a.a,r.b-a.b,r.c-a.c),o=new xl.Sh(f.b*g.c-f.c*g.b,-(f.a*g.c-f.c*g.a),f.a*g.b-f.b*g.a),l=new xl.Sh(g.b*u.c-g.c*u.b,-(g.a*u.c-g.c*u.a),g.a*u.b-g.b*u.a),-n.Math.atan2(n.Math.sqrt(g.a*g.a+g.b*g.b+g.c*g.c)*(f.a*l.a+f.b*l.b+f.c*l.c),o.a*l.a+o.b*l.b+o.c*l.c)},Ql.Sv=function(n,t){return Ql.Vv(n,t),Ql.Bw(n.q,t.q)},Ql.Tv=function(n,t){var e;for(e=0;e<t.q;e++)xl.Nh(n.k[e],t.J[e])},Ql.Uv=function(n,t){var e;for(e=0;e<t.k.length;e++)xl.Nh(n.k[e],t.k[e]);null==t.j?n.j=null:n.j=Fl.yOb(t.j,t.j.length)},Ql.Vv=function(n,t){var e;n.q&&t.q||(e=new Ql.Pw(n.o),!n.q&&(n.q=Ql.Nw(e,n)),!t.q&&(t.q=Ql.Nw(e,t)))},Ql.Wv=function(n,t){return null==n.j?-1:n.j[t]},Ql.Xv=function(n,t){return n.k[t]},Ql.Yv=function(n){return null==n.p?n.o.P:n.p},Ql.Zv=function(n,t){return n.k[t].a},Ql.$v=function(n,t){return n.k[t].b},Ql._v=function(n,t){return n.k[t].c},Ql.aw=function(n,t,e){for(null==n.j&&(n.j=vf(kl.Bwb,it,6,n.o.r,15,1),Fl.DOb(n.j));e<0;)e=e+360<<16>>16;for(;e>=360;)e=e-360<<16>>16;n.j[t]=e},Ql.bw=function(n,t,e){xl.Nh(n.k[t],e)},Ql.cw=function(n,t,e){n.k[t]=e},Ql.dw=function(n,t){n.p=t},Ql.ew=function(n,t,e){n.k[t].a=e},Ql.fw=function(n,t,e){n.k[t].b=e},Ql.gw=function(n,t,e){n.k[t].c=e},Ql.hw=function(n,t){var e;for(!t&&(t=xl.ru(n.o)),e=0;e<t.q;e++)xl.Nh(t.J[e],n.k[e]);return null!=n.p&&xl.Nm(t,n.p),t},Ql.iw=function(n){var t;for(this.o=n,this.k=vf(kl.Elb,Nt,32,n.q,0,1),t=0;t<n.q;t++)this.k[t]=new xl.Th(n.J[t]);this.n=NaN},Ql.jw=function(n){Ql.kw.call(this,n,n.o)},Ql.kw=function(n,t){var e;for(this.o=t,this.k=vf(kl.Elb,Nt,32,n.k.length,0,1),e=0;e<this.k.length;e++)this.k[e]=new xl.Th(n.k[e]);null!=n.j&&(this.j=Fl.yOb(n.j,n.j.length)),this.p=null==n.p||Jl.CHb(n.p)?n.p:Jl.AHb(n.p,U),this.n=NaN},zf(79,1,{79:1,18:1},Ql.jw),o.Eb=function(n){return Ql.Sv(this,n)},o.n=0,kl.mmb=lg(79),Ql.nw=function(n,t){var e,i,s,a,r;return null==t?null:(r=Fl.lNb(n.c,t))?r:(i=Rl.LTb("<").length,(Jl.DHb(Rl.LTb(t).substr(Rl.LTb(t).length-i,i),"<")||(s=Rl.LTb("-").length,Jl.DHb(Rl.LTb(t).substr(Rl.LTb(t).length-s,s),"-")))&&(r=Fl.lNb(n.c,(a=Rl.LTb("<").length,Jl.DHb(Rl.LTb(t).substr(Rl.LTb(t).length-a,a),"<")?Jl.RHb(t,0,Rl.LTb(t).length-1)+">":(e=Rl.LTb("-").length,Jl.DHb(Rl.LTb(t).substr(Rl.LTb(t).length-e,e),"-")?Jl.RHb(t,0,Rl.LTb(t).length-1)+"+":t))))?(r=new Ql.ix(r),Fl.gRb(n.c,t,r),r):null)},Ql.ow=function(n,t){var e,i,s,a,r,o,l,f,g,u,d,c,h,b,D,j,m,A,C;for(n.b|=t,m=Jl.OHb("daD@h@\\H\\D\\L\\B\\Djfdrjj`Cj`XZV^[lgl|WjBp^C~RQdp\ndaDD`HP@cIICISKUT@]LCbURss\\bCPVCp_rPmV@\ndaDH@@RfzaJjjbHGWPhxdtl|yXEGDfgf}HDoTE`|G|dC]`<\ndaDH@@RfzaJjjbHGWPhxdtl|yqGDf}HDoTE`|G|dC]`<\ndaDH@@RfzaJjjbHGWPhxdtl|yqGDf}HDoTE`|G|dC]`>\ndaT@`@\\DjfjZn[jjjkJcKhGP`phxdtl|wY@xD`uyo]{|lKUfp\ndax@@DiU[zh@zHfegfzLG``\ndax@@DiYn`@@wHmumm}l=\ndax@@DiYn`@@wHmumm}t=\ndax@@DiYn`@@wHmumn}t=\ndax@@DiYn`@@wHmuum}t\ndax@@DiYn`@@wHmuun}t=\ndax@@DiYn`@@wHnuun}t=\ndax@@DiYn`h@zsEgfyEnmlG``=\ndax@@DiYnf@@zaJyEnnmom`=\ndax@@DiYnf@@zaJyEvnmom`=\ndax@@DiYnf@@zqDffyEv`mom`=\ndax@@DiYnf@@zqDffyEv`mon`\ndax@@DiYnf@@zqDff~TEm}l=\ndax@@DiYnf@@zqDff~Uyn}t=\ndax@@DiYnf@@zqDfjyEv`mom`=\ndax@@DiYnf@@zqDfj~TEm}l=\ndax@@Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@@Djfjjh@zDFEGDfeggI@phdwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggM@phdtwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggN@pdwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggN@plwY@xD`tE`}x\ndax@@Djfjjh@zDFEGDjegj{HG@dF`lG``\ndax@@DjfjjjHP]BCBcbSRssd`XRV[l`\\BPZBp^|>\ndax@@DjfjjjHP]BCBcbSRsug@XR[l`\\BPZBp^B<\ndax@@DjfjjjHP]BCBcbSRsug@XR[l`\\BPZBp^B>\ndax@D@bH\\DbL\\B\\JbFbN\\Dfnjjh@zRGGNHxlwPo]x\ndax@H@\\H\\D\\J\\Djfjjh@zXFGDegf{I{@dFoLG``\ndax@H@\\H\\D\\J\\Djfjjh@zXFGDeggN@pdwYOXD`uy`|D\ndax@H@\\H\\D\\L\\Djfjjh@zXFDfegf{I{ODF`lG``\ndax@H@\\H\\J\\F\\Djfjjh@zXFEGDgj{HG@dFoM{``\ndax@H@\\J\\F\\N\\Djfjjh@zhFEGDf{HG@dFoM{o@\ndax@H@\\J\\F\\N\\Djfjjh@zhFEGDf}HG@dFoMx\ndax@H@dDdJdFdDfnjjh@zJGDgfzDGo@\ndax@H@dDdJdFdDfnjjh@zJGDgfzE{o@\ndax@H@dDdJdFdDfnjjh@zJGDggNHxlwP`|D\ndax@H@dDdJdFdDfnjjh@zJGDggNHxlwPo]x\ndax@H@dDdJdFdDfnjjh@zJGDkfzDGo@\ndax@H@dDdJdFdDfnjjh@zJGDkgNHxlwP`}x\ndax@H@dDdJdFdDfnjjh@zJGDkjzDG``\ndax@H@dDdLdJdLbdLeUT@]EBRss]F}w`\ndax@H@dDdLdJdLbdLeUUAPNbaIZyncA{p<\ndax@H@dDdLdJdLbdLeUUAPNbaIZyncA{p>\ndax@P@BFBDiuZ{h@zHEEgfzHG``\ndax@P@QFQDiuZ{h@zHEEgfzHG``\ndax@P@\\H\\Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@P@\\H\\Djfjjh@zDFEGDjegj{HG@dF`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf{Q{@dF`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf{Q{OEz`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf}YxoTE`|D\ndax@P@\\H\\Djnjjj@P]\\BcbSRss]h}`R}PVCpP<\ndax@P@\\H\\Djnjjj@P]\\BcbSRss]h}`R}PVCpP>\ndax@P@\\H\\Djnjjj@P]\\BcbSRss^lBWjBp^B<\ndax@P@\\H\\Djnjjj@P]\\BcbSRss^lBWjBp^B>\ndax@Q@|Bh@dnRjZjj`Ck`XT\\ZV^[t`\\CPVCpP\ndax@R@BH|HeIijjj@NnaQqIiYyoV^KuAXOA@\ndax@R@QH|HeIijjj@NnaQqIiYyoV^KuAXOA@\ndax@R@\\H\\HyJkjjj@NnAQqIiYyoV^KuAXOA@\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEgf{I{OEzoLG``\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEggI@phdwYOYxoUy`|D\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEggN@pdwYOYxoUy`|D\ndax@X@kDdLdJkFdNdLbdLeUT@]IBR\ndax@`@BDf]j^@@zbJyAoMmom`=\ndax@`@BDf]j^@@zbJyAoNmom`=\ndax@`@BDf]j^@@zbJyAoNmwn`=\ndax@`@\\Df]j^@@zRGFyA{Nmom`=\ndax@`@\\Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEGDfegf{HG@ez`lG``\ndax@`@\\Djfjjh@zDFEGDjegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEGHjegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEKHjegf{HG@dF`lG``\ndax@`@\\LddUUUr@]LBcbRss\\dC`RCwP\ndax@`@dDffjjjHP]]BcbSRssgHTR[u`RCPVCpP<\ndax@b@|@eJijjj@NaAaQqIiYynrApI^hKAxH\ndax@b@|@eJijjj@NaAaQqIiYynrAsq^hKAxH\ndax@b@|@eJijjj`DGP`phyDtl|wY@xDoTE`|D<\ndax@b@|@eJijjj`DGP`phyDtl|wY@xDoTE`|D>\ndax@h@BDdLdJdFdLbdLeUT@]YBSs]@}w`\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf{I{OEz`lG``\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf{I{OEz`lG`ddEB\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf}I{OTE`|D\ndax@h@\\H\\D\\L\\J\\Djfjjh@zhFDegf{I{ODFoLG``\ndax@h@\\H\\D\\L\\J\\Djfjjh@zhFDeggI@phdwYOYx`uy`|D\ndax@h@\\H\\D\\L\\J\\Djfjjj@P]TCBRssg@XR[lgl|PZ|p^B<\ndax@h@\\H\\D\\L\\J\\Djfjjj@P]TCBRssg@XR[lgl|PZ|p^B>\ndax@h@dDdLdJdFdLbdLeUT@]YBSs^NB\ndax@h@dDdLdJdFdLbdLeUT@]YBSs^N|\ndax@h@dDdLdJdFdLbdLeUT@]YBSu^NB\ndax@h@kDdLdJdFdLbdLeUT@]YBSs^N|\ndax@p@\\H\\D\\Djfjjh@zxFGDfegf{I{@dF`lG``\ndax@p@\\H\\D\\Djfjjh@zxFGDfegj{I{@dF`lG``\ndax@p@\\J\\F\\Djfjjh@zXFEGDgf{HG@dFoM{``\ndax@p@\\J\\F\\Djfjjh@zXFEGDgj{HG@dFoM{``\ndax@p@\\J\\F\\DjfjjjHP]LCBcbSs^dC`RCWnB<\ndax@p@\\J\\F\\DjfjjjHP]LCBcbSs^dC`RCWnB>\ndax@p@dDdLdLbdLeUT@]UBSRss_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSRss_JBp^|\ndax@p@dDdLdLbdLeUT@]UBSRsu_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSRuu_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSTus_JBp^|\ndax@p@|D\\L\\DffjjjHP]MBbSRss^l|PZBp^B<\ndax@p@|D\\L\\DffjjjHP]MBbSRss^l|PZBp^B>\ndaxB@@RfRZzjjdaX`zJGDggN@hdwP`|D<\ndaxB@@RfRZzjjdaX`zJGDggN@hdwP`|D>\ndaxBRHSFCpkpslddlcUT`HdGV@d|wRo\\D>\ndaxB`HSJCprRRrMUPAtPIKOMtXOA@\ndaxD@@QIkjjj@NfaqIiYysbNIMrHMAXOA@\ndaxD@@QIkjjjbDGSPxdtl|yHEGDfyDF`lG``<\ndaxD@@QImYk`@Nhanc[{X=\ndaxD@@iIijjj@NfaQqIYynVAHKAxH\ndaxD@@iIijjj@NfaQqIYysTJNMKMrpIAXOA@\ndaxD@@iIijjjRDbCihT\\RV^\\yBcS\\lBPVCpP\ndaxD@@iIijjjRDdCihT\\RV^\\yBbs\\lBPVCw`>\ndaxD@@iIijjjRDdCihT\\RV^\\yBcS\\lBPVCpP<\ndaxD@@yIUVnz@NdaY@\ndaxDHHP@biAiCiCIICHmU@GV@xdw```\ndaxDPHP@b`cIICHmU@GU@xeL|wH`uy`|D\ndaxD`HP@cIICHmU@GS@xdtl|wH`tE`|D\ndaxD`HP@cIICHmU@GS@xeTl|wH`tE`|D\ndaxD`HPGCIICIUU@GS@xdtl|wHoTE`|D\ndaxDpJXIAICICHiCIUU@GVPd|wc``\ndaxDpJXIAICICHiCIUU@GVPd|wco@\ndaxH@@RYvjxHaAtdNM|pK[{X+\ndaxH@@RZZjj`CkhT\\RZV^[u`RCPVCpP\ndaxH@@RZZjj`CkhT\\RZV^\\lCBcbSS^lBPZBp^B\ndaxH@@RZZjj`CkhT\\RZV^\\uBcbSS^lBPZBp^B\ndaxH@@RZZjj`CkhT\\RZV^lmBcbSRs^lBPZBp^B\ndaxH@@RZZjjhQAutJNIMKONZaQqIYoVAHMAXO^@<\ndaxH@@RZZjjhaAutJNIMKONVAaQqIioVAKuAXOA@<\ndaxH@@RZZjjhaAutJNIMKONZAaQIioVAHMAXOA@<\ndaxH@@RZZjjhaAutJNIMKONZaQqIioVAKuAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aQIoVAHMAXOA@<\ndaxH@@RZZjjhaAutJNIMKON\\aQIoVAHMAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aQYoVAHMAXO^@>\ndaxH@@RZZjjhaAutJNIMKON\\aqIoVAKuAXOA@<\ndaxH@@RZZjjhaAutJNIMKON\\aqIoVAKuAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aqYoVAKuAXO^@<\ndaxHHBApapQpqpRjZjj`Cj`XZV^[tgl}PVCpP\ndaxHPJBPRPRZzjjhrAuTNIKWM|KsA{p<\ndaxHPJBPRPRZzjjhrAuTNIKWM|KsA{p>\ndaxH`HApRjzjj`Ck`T\\RZV^[u`RCPVCpP\ndaxH`HApRjzjj`Ck`T\\RZV^[ugb}PVCpP\ndaxH`HApRjzjj`Ck`T\\bjV^[u`RCPVCpP\ndaxH`HApRjzjjhAAupJNIMKOMzpI^hKAxH<\ndaxH`HApRjzjjhAAupJNIMKOMzpI^hKAxH>\ndaxH`JBHRZZjjhaAttJNIKONRaQiYnVAHKAxH>\ndaxHpJBHRHrHrJPrUUPAtTIKOMtXOA@\ndaxHpJBPRPrPrJPrUUPAtTIKOMtXOA@\ndaxHpJBPRPrPrJPrUUPAtTIKOMt[w^@\ndaxHpJBPRPrPrJPrUUTE@zJDegfzLGo@<\ndaxHpJBPRPrPrJPrUUTE@zJDegfzLGo@>\ndaxHpJBPRPrPrJPrUUTE@zJDegjzLG``<\ndaxHpJBPRPrPrJPrUUTE@zJDegjzLG``>\ndaxHpJBPRPrPrJPrUUTE@zJDekfzLGo@<\ndaxHpJBPRPrPrJPrUUTE@zJDekfzLGo@>\ndaxL@@RdfnjjjHP]UCbRsse`T\\RZV[xPVCpP<\ndaxLHHS@BJdFdNdLddlbuT@]HBR\ndaxLJHS@BJdFdNdL{IIKHmU@GR@d`\ndaxL`HS@\\LddleUT@]TBSRss_JBp^B\ndaxLhJ[`\\H\\D\\L\\B\\Djfjjh@zPFF~I{OEx\nday@@@QIkjjj@NfaqIiYysPLJIMMrHMAXOA@\ndayDaLJD@HrR{IICHmU@GU@xtl|wr`lG``\ndaz@@@RYvHx@C\\`wfvwvp=\ndaz@@@RYvHx@C\\`wfvwwP\ndaz@@@RYvHx@C\\`wgVwvp=\ndaz@@@RYvix@CjHkdF|zv~v=\ndaz@@@RYvix@CjHkdG\\zv~v=\ndaz@B@BTf]bN@@wHMymm}t\ndaz@HBApapQpqpRjZjj`Cj`XZV^[tgl}PVCpP\ndaz@bHCpBTjnjjh@zxEGDfegf}YxoTE`|D\ndaz@pJBPRPrPrJPrUUPAtTIKOMtXOA@\ndaz@pJBPRPrPrJPrUUTE@zJDegjzLG``>\ndazDHLa@BJdFdNdLddlbuT@]HBR\ndazDJLa@BJdFdNdL{IIKHmU@GR@d`\ndazD`La@BLddlbuT@]TBSRss_JBp^B\ndazH`D`OCIICHuUPBCi`\\RZV^[dWjBp^B<\ndazH`D`OCIICHuUPBCi`\\RZV^[dWjBp^B>\ndazHpFhIAICICHiCIUUPRCkHR^[qpP<\ndazHpFhIAICICHiCIUUPRCkHR^[qpP>\ndazLQFaLCpkpsfgIIKHuUHBIAu`IOMtkwA@<\ndazLQFaLCpkpsfgIIKHuUHBIAu`IOMtkwA@>\ndctD@@gHiDTeIU]uPAttNIHjnmrpIATNa@\ndctD@@gHiDTeIU]uPAttNQPjvurpIATNa@\nded@@DiUfoh@@Mr[_[G\\{@=\nded@@DiUfoh@@Mr[_]G\\}@\nded@P@\\F\\LddUTeUuPAtHJNIKOHlmvPNAHOADLa@\ndedD@@{HiDUIU]T@]MCdTrMM\\lBPQCHP\ndiD@@DiYkhJ`ChlV^Q[tVzvp^BHP=\ndiD@@DiYkhJ`ChlV^Q[tVzzp^BHP\ndiD@@DiYkhJ`ChlV^aktVzvp^BHP=\ndiD@@DiYkhJ`ChlVnaktVzvp^BHP=\ndiD@@DiYkhJ`ChlVnaktVzzp^BHP\ndiD@H@\\H\\D\\L\\LddjTjn@@z`F}QyOY{nct=\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGmcl=\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGmct\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGnct=\ndiD@`@\\LddUTjnX@zhEGDej}HG@dGnct\ndiD@`@\\LddUTjnX@zxEGDegdV}HG@dGnbD\ndiD@`@\\LddUTjnX@zxEGDegdZ}HG@dGnbD\ndiDH@@rJQERjx@CkH\\R[e`RCvqv=\ndiDH@@rJQERjx@CkH\\R[e`RCvqz\ndiDH@@rJQERjx@CkH\\bke`RCvqv=\ndiDH@@rJQERjx@CkH\\bke`RCvqz\ndiDH@@rJQERjxHaAudNIMrpI^{X{@+\ndiDH@@rJQERjxHaAudNIMrpI^{X{@-\ndiDH@@rJQERjxHaAudNIMrpI^{X}@<\ndiDH@@rJQERjy`Cih\\RV^Q[y`RBO`\ndiDH@@rJQERjy`Cih\\bf^Q[e`RCwQB\ndiF@@@rJQERjx@CkH\\R[e`RCvqv=\ndiF@`NAprRQURjx@Ch`T\\R[t`\\BP^vNp\ndiF@a@b`BX{HiDUJk`@NlarJnVAHO[Gh\ndiFH@NCHiDUJk`@NlaqInVAHO[GX\ngC`@Die@zHXir\ngC`@Die@zHXis]Knz\ngC`@Die@zHXis^Kh\ngC`@Die@zHXisgAbd\ngC`@Die@zHXisgAbfzW]t\ngC`@Die@zHXisgAbf|WP\ngC`@Dij@zHXis]HNB\ngC`@Dij@zHXis]HN|\ngC`@Dij@zHXis]Kv|\ngC`@Dij@zHXisgAbfzP\\D\ngC`@Dij@zHXisgAbfzP]x\ngC`@Dij@zHXisgAbfzWmx\ngC`@Dij@zHXiu]HNB\ngC`@Dij@zHXiugAbfzP\\D\ngC`@Dij@zHXjs]HN|\ngC`@Dij@zHXjsgAbfzP]x\ngC`@Dij@zHXju]HNB\ngC`@Dij@zHXjugAbfzP\\D\ngC`@DkZ@zHXis]SnB\ngC`@DkZ@zHXis]Sn|\ngC`@DkZ@zHXis^XH\ngC`@DkZ@zHXis^[p\ngC`@DkZ@zHXisgAbfzg\\D\ngC`@DkZ@zHXisgAbfzg]x\ngC`@DkZ@zHXisgAbf|pP\ngC`@DkZ@zHXisgAbf|w`\ngC`@DkZ@zHXiu]SnB\ngC`@DkZ@zHXiu^XH\ngC`@DkZ@zHXiugAbfzg\\D\ngC`@DkZ@zHXiugAbf|pP\ngC`B@DPHPQ`aJZ`NdFH\ngC`B@DPHPQ`aJZ`NdFN\\FJP\ngC`B@DPHWaoAJZ`NdFMto[p\ngC`D@DPHRfhChabgMt`xH\ngC`D@DPHRfhChabgN\\FJ[iApP\ngC`D@DPHRfhChabgN\\FJ[i^w`\ngC`D@DPHRfhChabkUt`xH\ngC`D@DPHRnhCkASf|pP\ngC`D@DPHRnhCkASj|pP\ngC`D@DXHRVhCiQR\ngC`D@DXHRVhCiQSgAbd\ngC`D@DXHRfhCkAbf|PP\ngC`D@DXHRfhCkAbgNCEMx``\ngC`D@DXHRfhCkAbj|PP\ngC`D@DYpRVhCiQS]Cv|\ngC`D@VPlRfhChabkUt`xH\ngC`D@VYpRfhCkAbfzP]x\ngC`D@bQDRfhChabgMt`xH\ngC`D@bQDRfhChabkUt`xH\ngC`D@bSpRnhCkASfzglD\ngC`D@xYpRVhCiQS]Cv|\ngC`D@xYpRVhCiQSgAbfzGmx\ngC`DABPHRVhCkQSj|pP\ngC`DADZHRVhCiQR\ngC`DAb[DRVhCiQR\ngC`DAx[pRVhCiQR\ngC`DAx[pRVhCiQS]Cv|\ngC`Dax[pDzTej@zTTwP}o@\ngC`H@DIKRAuhir\ngC`H@DIKTAuhis]CvB\ngC`H@DIKTAuhis^XH\ngC`H@DIKTAuhis^[p\ngC`H@DIKTAuhisgAbfzGlD\ngC`H@DIKTAuhisgAbf|pP\ngC`H@DIKTAuhisgAbf|w`\ngC`H@DIKTAuhiu]CvB\ngC`H@DIKTAuhiu^XH\ngC`H@DISRAtPqSfzP]t\ngC`H@DISRAtPqSf|PP\ngC`H@DISRAtPqSgNCEMt`{h\ngC`H@DISRAtPqSgNCEMx``\ngC`H@DISRAtPqUfzP]t\ngC`H@DISRAtPqUgNCEMt`{h\ngC`H@DISTAtPqSfzP\\D\ngC`H@DISTAtPqSfzP]x\ngC`H@DISTAtPqSfzWlD\ngC`H@DISTAtPqSgNCEMt`xH\ngC`H@DISTAtPqSgNCEMt`{p\ngC`H@DISTAtPqSgNCEMtoXH\ngC`H@DISTAtPqSjzP\\D\ngC`H@DISTAtPqSjzWlD\ngC`H@DISTAtPqSkNCEMt`xH\ngC`H@DISTAtPqUfzP\\D\ngC`H@DISTAtPqUfzP]x\ngC`H@DISTAtPqUgNCEMt`xH\ngC`H@DISTAtPqUjzP\\D\ngC`H@VIKTAuhis]CvB\ngC`H@bIKTAuhis^XH\ngC`H@bISRAtPqSf|PP\ngC`H@bISTAtPqSfzP\\D\ngC`H@bISTAtPqSgNCEMt`xH\ngC`H@bISTAtPqSjzP\\D\ngC`H@bISTAtPqUfzP\\D\ngC`H@bISTAtPqUjzP\\D\ngC`H@xIKRAuhis^Cp\ngC`H@xIKTAuhis]CvB\ngC`H@xIKTAuhis]Cv|\ngC`H@xIKTAuhis^XH\ngC`H@xIKTAuhisgAbfzGlD\ngC`H@xIKTAuhiu]CvB\ngC`HADIKTAuhis^XH\ngC`HAVIKTAuhis^XH\ngC`HAbIKTAuhis^XH\ngC`HAxIKTAuhis]CvB\ngC`HAxIKTAuhis^XH\ngC`HAxIKTAuhisgAbfzGlD\ngC`HAxIKTAuhiu]CvB\ngC`HMPISTAu`qS]HN|\ngC`HMPISTAu`qS^HH\ngC`IAVBTii@zHXjs]HNz\ngC`IAxBTej@ztTyna{A@\ngC`IAxBTej@ztTys`qS]CvB\ngC`IMP[dij@zpXindG^@\ngC`L@DPHPPeMPGVCGMy``\ngC`L@DPHPPeMPGVCGMyo@\ngC`L@DPHPPeMPGVCGUy``\ngC`L@DPHPPeMPGVCGV\\FJ[sA@\ngC`L@VPHPPeMPGVCGMy``\ngC`L@bPHPPeMPGVCGMy``\ngC`PAEdij@zPXypXi@\ngC``@deZ@ztTyoLD\ngC``ADij@zHXis]HN|\ngC``ADij@zHXis]Kv|\ngC``ADij@zHXisgAbfzP\\D\ngC``ADij@zHXisgAbfzP]x\ngC``ADij@zHXisgAbfzWmx\ngC``Adej@zTT`\ngC``Adej@zTTypXi@\ngC``Adij@zpXioDD\ngC``Adij@zpXioEx\ngC``Adij@zpXis`qS^HH\ngC``Adij@zpXjoDD\ngC``Adij@zpXjs`qS^HH\ngC`hH`xIKTAuhis]Cv|\ngCa@@dkHGVbgH\ngCa@@dkHGVbgMyn`\ngCa@@dkPGVbgMy``\ngCa@@dmHGVbgH\ngCa@@dmHGVbgMyn`\ngCa@@dmHGVbgN\\FJP\ngCa@@dmHGVbgN\\FJ[s]@\ngCa@@dmPGVbgMy``\ngCa@@dmPGVbgMyo@\ngCa@@dmPGVbgN\\FJ[sA@\ngCa@@dmPGVbgN\\FJ[s^@\ngCa@@dmPGVbgUy``\ngCa@@dmPGVbgV\\FJ[sA@\ngCa@@eMHGQCEN[iAwP\ngCa@@eMHGQCEN[qA@\ngCa@@eMHGQCEN[q^@\ngCa@@eMHGQCEN\\xLTwRCn`\ngCa@@eMHGQCEN\\xLTwbB\ngCa@@eMHGQCEV[iAwP\ngCa@@eMHGQCEV\\xLTwRCn`\ngCa@@eMHGQCEV\\xLTwbB\ngCa@@eMPGQCEN[iApP\ngCa@@eMPGQCEN[iAw`\ngCa@@eMPGQCEN[i^pP\ngCa@@eMPGQCEN[i^w`\ngCa@@eMPGQCEN\\xLTwRC``\ngCa@@eMPGQCEN\\xLTwRCo@\ngCa@@eMPGQCEN\\xLTwR}``\ngCa@@eMPGQCEN\\xLTwR}o@\ngCa@@eMPGQCENkiApP\ngCa@@eMPGQCENki^pP\ngCa@@eMPGQCENlxLTwRC``\ngCa@@eMPGQCENlxLTwR}``\ngCa@@eMPGQCEV[iApP\ngCa@@eMPGQCEV[iAw`\ngCa@@eMPGQCEV\\xLTwRC``\ngCa@@eMPGQCEV\\xLTwRCo@\ngCa@@eMPGQCEVkiApP\ngCa@@eMPGQCEVlxLTwRC``\ngCaH@jAJZ`NlFN[i^pP\ngCaH@jAJZ`NlFN\\xLTwR}``\ngCaH@jAJZ`NlFN\\xLTwfB\ngCaH@jAJZ`NlFN\\xLTwf|\ngCaHDGAIZ`NmEN[h^pP\ngCaHH@aIZ`NmEN[h^pP\ngCaHH@aIZ`NmEN[h^w`\ngCaHH@aIZ`NmEN\\xLTwP}``\ngCaHHGAIZ`NmEN[h^pP\ngCaHHGAIZ`NmEN[h^w`\ngCaHHGAIZ`NmEN\\xLTwP}``\ngCaHHGAIZ`NmENkh^pP\ngCaHHOAIZ`NmEN[h^pP\ngCaHHOAIZ`NmEN[h^w`\ngCaHHOAIZ`NmEN[sA@\ngCaHHOAIZ`NmEN\\xLTwP}``\ngCaHHOAIZ`NmEN\\xLTwP}o@\ngCaHHOAIZ`NmEN\\xLTwf|\ngCaHHOAIZ`NmENkh^pP\ngCaHHOAIZ`NmENlxLTwP}``\ngCaHL@aIZ`NeEH\ngCaHL@aIZ`NeEN\\FJP\ngCaHLDQIZ`NeEH\ngCaHLGAIZ`NeEMxO@\ngCaHLHaIZ`NeEH\ngCaHLLQIZ`NeEH\ngCaHLOAIZ`NeEMxO@\ngCaI@jA\\eMPGVCGMtoXH\ngCaIHO@RdmPGVbgMtOXH\ngCaIHO@RdmPGVbgN\\FJ[h^pP\ngCaIL@`RdmPGRbd\ngCd@@deZ@ztTyoLG}h`\ngCd@@deZ@ztTys`qS^XO{Q@\ngCd@@deZ@ztTzoLG}h`\ngCd@@deZ@ztTzs`qS^XO{Q@\ngCd@ADie@zHXis]Kn{~rD@\ngCd@ADie@zHXis^Ko{HP\ngCd@ADie@zHXisgAbfzW]w}dH\ngCd@ADie@zHXis~rD@\ngCd@ADif@zHXis]KnC~rD@\ngCd@ADif@zHXis^XO{HP\ngCd@ADif@zHXisgAbfzW\\G}dH\ngCd@ADif@zHXisgAbf|p_vP`\ngCd@ADif@zHXiu]KnC~rD@\ngCd@ADif@zHXiu^XO{HP\ngCd@ADij@zHXis]HNC~rD@\ngCd@ADij@zHXis]HNC~t@\ngCd@ADij@zHXiu]HNC~rD@\ngCd@ADij@zHXju]HNC~rD@\ngCd@ADkj@zpTzoLD\ngCd@AdeY@zTT`\ngCd@Adej@zTT`\ngCd@Adej@zTTypXi@\ngCd@Adij@zpXioDG}h@\ngCd@Adij@zpXis`qS^HO{P@\ngCd@Adij@zpXjoDG}h@\ngCd@Adij@zpXjs`qS^HO{P@\ngCd@aAteJz`NlEN[sAZ@\ngCd@aAteJz`NlEN[s^Z@\ngCd@aaNeIZ`NeEH\ngCd@aaNeIZ`NeEN\\FJP\ngCd@aaNeIZ`NeEN\\FJ[h^w`\ngCd@aaNeIZ`NeEN\\FJ[p^@\ngCdAAIrTs@]DLTznewAYB@\ngCdAAaJRu@]JJP\ngCdAAaJRu@]JJ[p^@\ngCdAAaJRu@]JJ\\xLT`\ngCdAAaJRu@]JJ\\xLTw`|\ngCdDE`DPHRfhCiAb\ngCdHH`DIKRAuhis]Cv{~rb@\ngCdHH`DIKRAuhis^Cw{JH\ngCdHI`DIKTAthis`qS^Cw{R@\ngCe@E`dkPGRbg}h`\ngCh@@dkHGVbgH\ngCh@@dkPGVbgMy``\ngCh@@dmHGVbgH\ngCh@@dmHGVbgMyn`\ngCh@@dmHGVbgN\\FJP\ngCh@@dmHGVbgN\\FJ[s]@\ngCh@@dmPGVbgMtOXH\ngCh@@dmPGVbgMy``\ngCh@@dmPGVbgMyo@\ngCh@@dmPGVbgN\\FJ[h^pP\ngCh@@dmPGVbgN\\FJ[sA@\ngCh@@dmPGVbgN\\FJ[s^@\ngCh@@dmPGVbgUy``\ngCh@@dmPGVbgV\\FJ[sA@\ngCh@@eLhGQCEN\\xLTwR{nm@\ngCh@@eLhGQCEN\\xLTwb{~t@\ngCh@@eMHGQCEN[iAw_v`@\ngCh@@eMHGQCEN[i^w_v`@\ngCh@@eMHGQCEN[qAZ@\ngCh@@eMHGQCEN\\xLTwRCnm@\ngCh@@eMHGQCEN\\xLTwbC~t@\ngCh@@eMHGQCEV[iAw_v`@\ngCh@@eMHGQCEV[qAZ@\ngCh@@eMPGQCEN[iApP\ngCh@@eMPGQCEN[iAp_v`@\ngCh@@eMPGQCEN[iAw`\ngCh@@eMPGQCEN[iAwov`@\ngCh@@eMPGQCEN[i^pP\ngCh@@eMPGQCEN\\xLTwRC``\ngCh@@eMPGQCEN\\xLTwRC`m@\ngCh@@eMPGQCEN\\xLTwRCo@\ngCh@@eMPGQCEN\\xLTwRCo_m@\ngCh@@eMPGQCEN\\xLTwR}``\ngCh@@eMPGQCENkiApP\ngCh@@eMPGQCENkiAp_v`@\ngCh@@eMPGQCENki^pP\ngCh@@eMPGQCENlxLTwRC``\ngCh@@eMPGQCEV[iApP\ngCh@@eMPGQCEV[iAp_v`@\ngCh@@eMPGQCEV[iAwov`@\ngCh@@eMPGQCEV\\xLTwRC``\ngCh@@eMPGQCEV\\xLTwRC`m@\ngCh@@eMPGQCEVkiApP\ngCh@@eMPGQCEVkiAp_v`@\ngCh@@e[PGQCEN[j]p_v`@\ngCh@@e[PGQCEN[sAZ@\ngCh@@e[PGQCEN[s^Z@\ngCh@@e[PGQCEN\\xLTwT{`m@\ngCh@@e[PGQCENkj]p_v`@\ngCh@@e[PGQCENksAZ@\ngCh@@e[PGQCENlxLTwT{`m@\ngChA@IRUdCkQSf|GP\ngChA@IRVdCkQSd\ngChA@IRVhCkQSfzGlD\ngChA@IRVhCkQSf|pP\ngChA@IRVhCkQSf|w`\ngChA@IRVhCkQSgNCEMtOXH\ngChA@IRVhCkQSgNCEMy``\ngChA@IRVhCkQSgNCEMyo@\ngChA@IRVhCkQSj|pP\ngChA@IRVhCkQSkNCEMy``\ngChA@IRfhChabgMt`xH\ngChA@IRfhChabgMt`{p\ngChA@IRfhChabgMtoXH\ngChA@IRfhChabgN\\FJ[iApP\ngChA@IRfhChabgUt`xH\ngChA@IRfhChabgUtoXH\ngChA@IRfhChabgV\\FJ[iApP\ngChA@IRfhChabkUt`xH\ngChA@IRmhChabgMuNxO{P@\ngChA@IRmhChabgMy`m@\ngChA@IRmhChabgN\\FJ[j]p_v`@\ngChA@IRmhChabgUuNxO{P@\ngChDD@bABUt`]XJ\\wf{~tP\ngChDDDRHbUt`]XJ\\wf{~tP\ngChHD@aIZ`NmEN[h^p_vb@\ngChHDOAIZ`NmENkh^p_vb@\ngChHH@aIZPNmEN[h^w_vd@\ngChHH@aIZ`NmEN[h^p_vd@\ngChHH@aIZ`NmEN[h^wovd@\ngChHH@aIZ`NmEN\\xLTwP}`mH\ngChHH@aIZ`NmENkh^p_vd@\ngChHH@aJZPNbFJlypXindG]ZP\ngChHHOAIZ`NmEN[h^p_vd@\ngChHHOAIZ`NmEN\\xLTwP}`mH\ngChHHOAIZ`NmENkh^p_vd@\ngChHL@aIZ`NeEH\ngChHL@aIZ`NeEMxO@\ngChHL@aIZ`NeEN\\FJP\ngChHL@aJZ`NlFJ[qA@\ngChHL@aJZ`NlFJ\\xLTwbB\ngChHLHaIZ`NeEH\ngChHLLQIZ`NeEH\ngChHLOAIZ`NeEH\ngChIDOARdmPGVbgMtOXH\ngChIHOBRdkPGVbgMy`mH\ngChIL@cRdmPGRbd\ngChIL@cRdmPGRbf|G`\ngChILLSRdmPGRbd\ngCh`LHe]PGRBd\ngCi@DDeZ@ztTyoLG}h`\ngCi@DDeZ@ztTyoM{}h`\ngCi@DDeZ@ztTzoLG}h`\ngCi@HDii@zHXis]HN{~t`\ngCi@HDii@zHXis^HO{R@\ngCi@HDii@zHXisgAbfzP]w}i@\ngCi@HDii@zHXjs]HN{~t`\ngCi@HDij@zHXis]HNB\ngCi@HDij@zHXis]HNC~t`\ngCi@HDkj@zpTyoLD\ngCi@HDkj@zpTyoMx\ngCi@HDkj@zpTys`qS^XH\ngCi@HDkj@zpTzoLD\ngCi@LDej@zTT`\ngCi@LDej@zTTypXi@\ngCi@LDej@zTTypXioMx\ngCi@LDij@zpXioDD\ngCi@LDij@zpXis`qS^HH\ngCi@LDij@zpXjs`qS^HH\ngCiALMJRu@]JJP\ngCiALMJRu@]JJ[s^@\ngCiALMJRu@]JJ\\xLT`\ngCiALMJRu@]JJ\\xLTwf|\ngCl@ADe[PGVBgUy`l``\ngClAADnRmhCkASj|p_vPP\ngFp@DjYZXHCkASfyW]x{nrTrp=\ngFp@DjYZjjQCiabgIZyHXis\\kv|_WwyJYX<\ngFp@DjxujhCiabgIZwL{`dMC~RvN@\ngFp@LdaahUPGVrVmsMkYCPdmc`=\ngFp@LdaahUPGVrVmsMkY}__dmc`=\ngFp@LdaahUPGVrVmsMkiCPdmc`\ngFp@LdaahUTrGVrVmsMkYC__dmc`+\ngFp@LdaahUTrGVrVmsMkYC__dmc`-\ngFp@LdaahUTrGVrVmsMkiC__dmc`<\ngFp@LdaahUTrGVrVmsMkiC__dmc`>\ngFp@LddLUUPGSCENRusdyK\\pJBPtOyHZX\ngFp@LddLUUPGSCENRusdyK\\sr|PtOyHZX\ngFp@LddLUUTBGSCENRurPqRVy`Uxah_rPtp>\ngFp@LddLUUTBGSCENRus`iK\\sr|PtOyHZX>\ngFp@LddLUUTBGSCENRusdyK\\pJ|PtOyHZX<\ngFp@LddLUUTBGSCENRusdyK\\pJ|PtOyHZX>\ngFp@LddLUUTBGSCENRushiK\\pJ|PtOyHZX<\ngFp`@TfXujjJChqSfnSENRwVCPdmc`<\ngFp`@TizJjiRYChqSfn\\dm[iAh_rPup<\ngFp`@TizJjiRZChqSfmtoTOyHZx<\ngFp`@TizJjiRZChqSfmtoTOyHZx>\ngFp`@TizJjiRZChqSfn\\dm[iAh_rPup<\ngFp`@TizJjiRZChqSfn\\dm[iAh_rPup>\ngFp`@dfxujhChqrVmtPtOyKXx\ngFp`@dfxujhChqrVmt_WwyKXx\ngFp`@dfxujjYChqrVmtPwwyKXx<\ngFp`@dfxujjYChqrVmtPwwyKXx>\ngFq@@dmXuU@]VJ\\ek_XICPdem`\ngFq@@dsFmU@]VJ\\ek_XICPdmc`\ngFq@@dsFmU@]VJ]Ek_XICPdmc`\ngFq@@dsFmUQH]VJ]Ek_XIC__dmc`<\ngFq@@dsFmUQH]VJ]Ek_XIC__dmc`>\ngFq@@dsFuURH]VJ\\ek_XICPdmc`<\ngFq@@dsFuURH]VJ\\ek_XICPdmc`>\ngFq@@eMXuURH]LLTyKVyP\\D~h_rRvp<\ngFq@@eMqUURH]VJ\\ek_HICPdak`<\ngFq@@eMqUURH]VJ\\ek_HICPdak`>\ngFq@@eMqUURH]VJ\\ek_KqCPdak`<\ngFq@@eMqUURH]VJ\\ekdaRVm|oDMC~RFn@>\ngFq@@eMqUURH]VJ\\ekgIKV~WbFaICW@<\ngFq@@eMqUURH]VJ\\ekgIKV~WbFaICW@>\ngFq@@eMqUURH]VJ\\ekgIrV~PRFaICW@<\ngFq@@eMqUURH]VJ\\ekgIrV~PRFaICW@>\ngFq@@eMqUURH]VJ\\ekgIrV~PSzaICW@<\ngFq@@eOQUARP]JJ[yAN{o|dM\\+\ngFq@@eOQUARP]JJ[yAN{o|dM\\-\ngFq@@eOQUARP]JJ[y^N{o|dM\\+\ngFq@@eOQUARP]JJ[y^N{o|dM\\-\ngFq`@bdwFmUSP]ZNZweC~RvN@>\ngFq`ALe\\qUU@]ENRunbFaISW@\ngFx@@eMXuU@]LLTyKVyP\\Dah_rRvuh@\ngFx@@eOQMA@]JJ[y^N{o|dM\\=\ngFx@@eOQUARP]JJ[yAN{o|dM\\+\ngFx@@eOQUARP]JJ[yAN{o|dM\\-\ngFx@@eOQUARP]JJ[y^N{o|dM\\+\ngFx@@eOQUARP]JJ[y^N{o|dM\\-\ngFx@@eSFuU@]LLTyKVyP\\Dah_rVquh@=\ngFx@@eSFuU@]LLTzKVyP\\Dah_rVquh@\ngFx@@eSFuU@]LLUZKVyP\\Dah_rVqp\ngFxAAIRicZ`@NbFR\\wJC`gm{~RvN@=\ngFxAAYRicZ`@NbFR\\wJC`gm{~RvNm@=\ngFx`DBdwFmUSP]ZNZweC~RvN@<\ngFy@DDfxujhChqrVmtPtOyKXx\ngFy@DDfxujjYChqrVmtPwwyKXx<\ngFy@DDfxujjYChqrVmtPwwyKXx>\ngGP@DiWj`NbgIZwQCP`\ngGP@DjZ@@Mrm{Yw]`=\ngGP@DjZ@@Mrm{Yw^`=\ngGP@DjZ@@Mrm{Y{^`=\ngGP@DjZ@@Mrm{iw^`\ngGP@DjZ@@Mrm{i{^`=\ngGP@DjZ@@Mrn{i{^`=\ngGP@DjZ@@NZFJ\\enUw]O[t=\ngGP@DjZ@@N\\EI[e[wSn}@\ngGP@DjZ@@N\\EN[e[wSv}@\ngGP@DjZ@@N\\FN[e]wSv}@\ngGP@DjZX@NhJyV}l{np=\ngGP@DjZX@NhJyV}l{oP\ngGP@DjZX@NhJyV}l}oP=\ngGP@DjZX@NhJyV}t{np=\ngGP@DjZX@NhJyV}t{oP\ngGP@DjZX@NhJyW]l{np=\ngGP@DjZX@NhJyW]l{oP\ngGP@DjZX@NhJyW]l}oP=\ngGP@DjZX@NhJyW]t{np=\ngGP@DjZX@NhJyW]t{oP\ngGP@DjZX@NhJyW]t}oP=\ngGP@DjZX@NhKNBdmrn{iw^`\ngGP@DjZX@NhKNCDmrn{Yw^`\ngGP@DjZX@NhKNCDmrn{iw^`\ngGP@DjZX@NlEN[e]pSn{@=\ngGP@DjZX@NlEN[e]pSn{IPh`=\ngGP@DjZX@NlEN[e]pSn}@\ngGP@DjZX@NlEN[e]pSv}@=\ngGP@DjZX@NlEN[e]wcn{@=\ngGP@DjZX@NlEN[e]wcn{IPh`=\ngGP@DjZX@NlEN[e]wcn}@\ngGP@DjZX@NlEN[e]wcv}@=\ngGP@DjZX@NlEN[{AN{l=\ngGP@DjZX@NlEN[{AN{t\ngGP@DjZX@NlEN[{AO[t=\ngGP@DjZX@NlEN[{^N{l=\ngGP@DjZX@NlEN[{^N{t\ngGP@DjZX@NlEN\\xJRwJ{`g]z\ngGP@DjZX@NlEN\\xJRwJ{oG]z\ngGP@DjZX@NlEN\\xJRwvB]wh\ngGP@DjZX@NlEN\\xJRwv|]wh\ngGP@DjZX@NlEN\\xJ\\wJ{`gmz\ngGP@DjZX@NlEN\\xJ\\wvB^wh\ngGP@DjZX@NlEN\\xLRwJ{`g]z\ngGP@DjZX@NlEN\\xLRwvB]wh\ngGP@DjZX@NlEN\\xLRwv|]wh\ngGP@DjZX@NlEN\\xL\\wJ{`gmz\ngGP@DjZX@NlEN\\xL\\wvB^wh\ngGP@DjZX@NlENke]pSn{@=\ngGP@DjZX@NlENke]pSn}@\ngGP@DjZX@NlENke]pSv}@=\ngGP@DjZX@NlENk{AN{l=\ngGP@DjZX@NlENk{AN{t\ngGP@DjZX@NlENk{AO[t=\ngGP@DjZX@NlENlxJRwJ{`g]z\ngGP@DjZX@NlENlxJRwvB]wh\ngGP@DjZX@NlENlxLRwJ{`g]z\ngGP@DjZX@NlENlxLRwvB]wh\ngGP@DjZX@NlENlxL\\wJ{`gmz\ngGP@DjZX@NlENlxL\\wvB^wh\ngGP@DjZY`NbFR\\wJ{`g]z\ngGP@DjZY`NbFR\\wJ{`gmv\ngGP@DjZY`NbFR\\wJ{`gmz\ngGP@DjZY`NbFR\\wJ{oGmv\ngGP@DjZY`NbFR\\wJ{oGmz\ngGP@DjZY`NbFR\\wvB]wX\ngGP@DjZY`NbFR\\wvB^wh\ngGP@DjZY`NbFR]WJ{`gmv\ngGP@DjZY`NbFR]WJ{`gmz\ngGP@DjZY`NdJUrm{Yw]`\ngGP@DjZY`NdJUrm{iw^`\ngGP@DjZY`NdJUrn{Y{]`\ngGP@DjZY`NdJUrn{i{^`\ngGP@DjZY`NfFJ\\ek\\knB^tH\ngGP@DjZY`NfFJ\\ek]XMB\ngGP@DjZY`NfFJ\\ek_KnCP`\ngGP@DjZY`NfFJ\\ek_XI{_@\ngGP@DjZY`NfFJ\\ekfabgI[e]pSva@\ngGP@DjZY`NfFJ\\ekfabgI[kAhP\ngGP@DjZY`NfFJ\\ekfabgI[y]pZD\ngGP@DjZY`NfFJ\\ekgARVyW\\D}hP\ngGP@DjZY`NfFJ\\ekgARV~W\\Fa@\ngGP@DjZY`NfFJ\\ekgASf~W\\Fa@\ngGP@DjZY`NfFJ\\ekgAbVzpZD\ngGP@DjZY`NfFJ\\ekgAbV~W\\Fa@\ngGP@DjZY`NfFJ\\ekgAcfyW\\D}hP\ngGP@DjZY`NfFJ\\ekgAcf~W\\Fa@\ngGP@DjZY`NfFJ\\em\\knB^tH\ngGP@DjZY`NfFJ\\em]XMB\ngGP@DjZY`NfFJ\\em_KnCP`\ngGP@DjZY`NfFJ\\em_XI{P`\ngGP@DjZY`NfFJ\\emgAcfyW\\D}hP\ngGP@DjZY`NfFJ\\emgAcf~W\\Fa@\ngGP@DjZY`NfFJ]Em\\knB^tH\ngGP@DjZY`NfFJ]Em]XMB\ngGP@DjZY`NfFJ]Em_KnCP`\ngGP@DjZY`NfFJ]EmgAcfyW\\D}hP\ngGP@DjZj`NfFJ\\ek\\hNBPtH\ngGP@DjZj`NfFJ\\ekfabgI[eApRFa@\ngGP@DjZj`NfFJ\\fm\\hNBPtH\ngGP@DjZj`NfFJmFm\\hNBPtH\ngGP@DjZjdEDNfFJ\\ekdacdmr`xIC_@<\ngGP@DjZjdEDNfFJ\\ekdacdmr`xIC_@>\ngGP@DjZjdEDNfFJ\\ekfabgI[eAwbF~@<\ngGP@DjZjdEDNfFJ\\ekfabgI[eAwbF~@>\ngGP@DjZjdEDNfFJ\\ekgARVyP]xao`<\ngGP@DjZjdEDNfFJ\\ekgARVyP]xao`>\ngGP@DjZjdEDNfFJ\\ekgAbVyP\\Dao`<\ngGP@DjZjdEDNfFJ\\ekgAbVyP\\Dao`>\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\Dao`<\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\Dao`>\ngGP@DjZjdEDNfFJ\\emgAbVyP\\DahP<\ngGP@DjZjdEDNfFJ\\emgAbVyP\\DahP>\ngGP@DjZjdEDNfFJ\\emgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\emgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ\\fmgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\fmgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ]EkfabgI[eApRF~@<\ngGP@DjZjdEDNfFJ]EkfabgI[eApRF~@>\ngGP@DjZjdEDNfFJ]Em\\hNBPtH<\ngGP@DjZjdEDNfFJ]Em\\hNBPtH>\ngGP@DjZjdEDNfFJ]EmgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ]EmgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ]FmgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\ekfabgI[eAwbF~@\ngGP@DjZjdEHNfFJ\\ekgARVyP]xao`\ngGP@DjZjdEHNfFJ\\ekgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ\\ekgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ\\ekgAcfyP\\DahP\ngGP@DjZjdEHNfFJ\\emgAbVyP\\DahP<\ngGP@DjZjdEHNfFJ\\emgAbVyP\\DahP>\ngGP@DjZjdEHNfFJ\\emgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\emgAcfyP\\DahP>\ngGP@DjZjdEHNfFJ\\fkgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ\\fkgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ\\fmgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\fmgAcfyP\\DahP>\ngGP@DjZjdEHNfFJ]EkfabgI[eApRF~@>\ngGP@DjZjdEHNfFJ]EkgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ]EkgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ]Em\\hNBPtH\ngGP@DjZjdEHNfFJ]EmgAbVyP\\DahP<\ngGP@DjZjdEHNfFJ]EmgAbVyP\\DahP>\ngGP@DjZjhDNfFJ\\fmdacdmr`xICP`<\ngGP@DjZjhDNfFJ\\fmdacdmr`xICP`>\ngGP@DjZjhDNfFJ]Fm\\hNBPtH>\ngGP@DjZjiDNfFJ\\ek\\hNBPwp<\ngGP@DjZjiDNfFJ\\ek\\hNBPwp>\ngGP@DjZjiDNfFJ\\ekdabdmr`xIC_@<\ngGP@DjZjiDNfFJ\\ekdabdmr`xIC_@>\ngGP@DjZjiDNfFJ\\ekdabgMr`xICP`<\ngGP@DjZjiDNfFJ\\ekdabgMr`xICP`>\ngGP@DjZjiDNfFJ\\ekfabgI[eApRF~@<\ngGP@DjZjiDNfFJ\\ekfabgI[eApRF~@>\ngGP@DjZjiDNfFJ\\em\\hNBPtH<\ngGP@DjZjiDNfFJ\\em\\hNBPtH>\ngGP@DjZjiDNfFJ\\emdabgMr`xICP`<\ngGP@DjZjiDNfFJ\\emdabgMr`xICP`>\ngGP@DjZjiDNfFJ\\emfabgI[eApRFa@<\ngGP@DjZjiDNfFJ\\emfabgI[eApRFa@>\ngGP@Djfj`NfFJ\\ek\\hNBPtH\ngGP@Djfj`NfFJ\\ek\\hNBPtOyJED\ngGP@Djfj`NfFJ\\ek\\hNBPwp\ngGP@Djfj`NfFJ\\ek\\hNB_TH\ngGP@Djfj`NfFJ\\ek\\hNB_Wp\ngGP@Djfj`NfFJ\\ek\\hN|_TH\ngGP@Djfj`NfFJ\\ekdaSdmr`{q}P`\ngGP@Djfj`NfFJ\\ekdaSdmr`{q}_@\ngGP@Djfj`NfFJ\\ekdabdmr`xICP`\ngGP@Djfj`NfFJ\\ekdabdmr`xIC_@\ngGP@Djfj`NfFJ\\ekdabdmr`xI}P`\ngGP@Djfj`NfFJ\\ekgAbVyP\\DahP\ngGP@Djfj`NfFJ\\ekgAbVyP\\Dao`\ngGP@Djfj`NfFJ\\ekgArVyP\\Dah_rTJH\ngGP@Djfj`NfFJ\\ekgArVyP\\D~hP\ngGP@Djfj`NfFJ\\ekgArVyP\\D~o`\ngGP@Djfj`NfFJ\\em\\hNBPtH\ngGP@Djfj`NfFJ\\em\\hNB_TH\ngGP@Djfj`NfFJ\\emgAbVyP\\DahP\ngGP@Djfj`NfFJ\\emgArVyP\\D~hP\ngGP@Djfj`NfFJ\\fk\\hNBPtH\ngGP@Djfj`NfFJ\\fk\\hNBPwp\ngGP@Djfj`NfFJ\\fkdabdmr`xICP`\ngGP@Djfj`NfFJ\\fkdabdmr`xIC_@\ngGP@Djfj`NfFJ\\fkgArVyP\\DahP\ngGP@Djfj`NfFJ\\fkgArVyP\\Dao`\ngGP@Djfj`NfFJ\\fm\\hNBPtH\ngGP@Djfj`NfFJ]Fk\\hNBPtH\ngGP@Djfj`NfFJ]Fk\\hNBPwp\ngGP@Djfj`NfFJ]FkgAbVyP\\DahP\ngGP@Djfj`NfFJ]Fm\\hNBPtH\ngGP@Djfj`NfFJmEk\\hNB_TH\ngGP@Djfj`NfFJmFk\\hNBPtH\ngGP@DjfjhDNfFJ\\ekdabdmr`{q}P`<\ngGP@DjfjhDNfFJ\\ekdabdmr`{q}P`>\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}P`<\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}P`>\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}_@<\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}_@>\ngGP@DjfjhDNfFJ\\ekgARVyP]x~hP<\ngGP@DjfjhDNfFJ\\ekgARVyP]x~hP>\ngGP@DjfjhDNfFJ\\ekgAbVyP\\D~hP<\ngGP@DjfjhDNfFJ\\ekgAbVyP\\D~hP>\ngGP@DjfjhDNfFJ\\fkgAbVyP\\DahP<\ngGP@DjfjhDNfFJ\\fkgAbVyP\\DahP>\ngGP@DjfjhDNfFJ]Ek\\hNB_TH<\ngGP@DjfjhDNfFJ]Ek\\hNB_TH>\ngGP@DjfjhDNfFJ]EkgAbVyP\\D~hP<\ngGP@DjfjhDNfFJ]EkgArVyP\\D~hP<\ngGP@DjfjhDNfFJ]EkgArVyP\\D~hP>\ngGP@DjfjhDNfFJ]FkgARVyP\\DahP<\ngGP@DjfjhDNfFJ]FkgARVyP\\DahP>\ngGP@DjfjhDNfFJ]FkgARVyP\\Dao`<\ngGP@DjfjhDNfFJ]FkgARVyP\\Dao`>\ngGP@Djyj`NbIIZwLwmdMB\ngGP@Djyj`NbIIZwLwndMB\ngGP@Djyj`NbIIZwL{mdMB\ngGP@Djyj`NbIIZwL{ndMB\ngGP@Djyj`NbIIkWLwmdMB\ngGP@Djyj`NbIIkWLwndMB\ngGP@Djyj`NbIIkWL{ndMB\ngGP@Djyj`NbIIkYLTyK\\s^zPtH\ngGP@Djyj`NfFJ\\ek\\snBPtH\ngGP@Djyj`NfFJ\\ek_XICP`\ngGP@Djyj`NfFJ\\ek_XICPdlRP\ngGP@Djyj`NfFJ\\ekdacdmsNxICP`\ngGP@Djyj`NfFJ\\ekdacdm}`dMB\ngGP@Djyj`NfFJ\\ekdqSdmsNxICP`\ngGP@Djyj`NfFJ\\ekdqSdmsN{qCP`\ngGP@Djyj`NfFJ\\ekdqSdm}`dMB\ngGP@Djyj`NfFJ\\ekfabgI[f]pRFa@\ngGP@Djyj`NfFJ\\ekfabgI[{AHZD\ngGP@Djyj`NfFJ\\ekfabgI[{^HZD\ngGP@Djyj`NfFJ\\fm\\snBPtH\ngGP@Djyj`NfFJ\\fm_XICP`\ngGP@Djyj`NfFJ\\fmdacdmsNxICP`\ngGP@Djyj`NfFJ]Ek\\snBPtH\ngGP@Djyj`NfFJ]Ek_XICP`\ngGP@Djyj`NfFJ]Ekdacdm}`dMB\ngGP@Djyj`NfFJ]EkfabgI[f]pRFa@\ngGP@Djyj`NfFJ]EkfabgI[{AHZD\ngGP@Djyj`NfFJ]FmdacdmsNxICP`\ngGP@DjyjhdNbIIZwLwmdM|>\ngGP@DjyjhdNbIIZwLwndM|<\ngGP@DjyjhdNbIIZypXynYw[HZD<\ngGP@DjyjhdNbIIZypXynYw[HZD>\ngGP@DjyjhdNbIIZypXynYw]HZD<\ngGP@DjyjhdNbIIZypXynYw]HZD>\ngGP@DjyjhdNbII[WLwndMB<\ngGP@DjyjhdNbII[WLwndMB>\ngGP@DjyjhdNbII[WL{ndMB<\ngGP@DjyjhdNbII[WL{ndMB>\ngGP@DjyjhdNbII[YpXynYw]HZD<\ngGP@DjyjhdNbII[YpXynYw]HZD>\ngGP@DjyjhdNbII[YtTynYw]HZD<\ngGP@DjyjhdNbIIjypXenYw]H[x<\ngGP@DjyjhdNfFJ\\ek_XIC_@<\ngGP@DjyjhdNfFJ\\ek_XIC_@>\ngGP@DjyjhdNfFJ\\ekdacdm}`dM|<\ngGP@DjyjhdNfFJ\\ekdacdm}`dM|>\ngGP@DjyjhdNfFJ\\ekdacdm}`dM}~RqI@>\ngGP@DjyjhdNfFJ\\ekfabgI[f]pRF~@>\ngGP@DjyjhdNfFJ\\ekfabgI[{AH[x<\ngGP@DjyjhdNfFJ\\ekfabgI[{AH[x>\ngGP@DjyjhdNfFJ\\ekfabgI[{^H[x<\ngGP@DjyjhdNfFJ\\ekfabgI[{^H[x>\ngGP@DjyjhdNfFJ\\ekgAbVyg\\Dao`<\ngGP@DjyjhdNfFJ\\ekgAbVyg\\Dao`>\ngGP@DjyjhdNfFJ\\ekgAbV~pRF~@<\ngGP@DjyjhdNfFJ\\ekgAbV~pRF~@>\ngGP@DjyjhdNfFJ\\ekgAcfyg\\DahP<\ngGP@DjyjhdNfFJ\\ekgAcfyg\\DahP>\ngGP@DjyjhdNfFJ\\ekgAcf~pRFa@<\ngGP@DjyjhdNfFJ\\ekgAcf~pRFa@>\ngGP@DjyjhdNfFJ\\ekgQRV~pRF~@<\ngGP@DjyjhdNfFJ\\ekgQRV~pRF~@>\ngGP@DjyjhdNfFJ\\ekgQRV~wbF~@<\ngGP@DjyjhdNfFJ\\ekgQRV~wbF~@>\ngGP@DjyjhdNfFJ\\ekgQSfyg\\DahP<\ngGP@DjyjhdNfFJ\\ekgQSfyg\\DahP>\ngGP@DjyjhdNfFJ\\ekgQSf~pRFa@<\ngGP@DjyjhdNfFJ\\ekgQSf~pRFa@>\ngGP@DjyjhdNfFJ\\ekgQSf~wbFa@<\ngGP@DjyjhdNfFJ\\ekgQSf~wbFa@>\ngGP@DjyjhdNfFJ\\em\\snBPtH<\ngGP@DjyjhdNfFJ\\em\\snBPtH>\ngGP@DjyjhdNfFJ\\em_XICP`<\ngGP@DjyjhdNfFJ\\em_XICP`>\ngGP@DjyjhdNfFJ\\emdacdmsNxICP`<\ngGP@DjyjhdNfFJ\\emdacdmsNxICP`>\ngGP@DjyjhdNfFJ\\emgAbVyg\\DahP<\ngGP@DjyjhdNfFJ\\emgAbVyg\\DahP>\ngGP@DjyjhdNfFJ\\emgAbV~pRFa@<\ngGP@DjyjhdNfFJ\\emgAcfyg\\DahP<\ngGP@DjyjhdNfFJ\\emgAcfyg\\DahP>\ngGP@DjyjhdNfFJ\\emgAcf~pRFa@<\ngGP@DjyjhdNfFJ\\emgAcf~pRFa@>\ngGP@DjyjhdNfFJ\\emgQSfyg\\DahP<\ngGP@DjyjhdNfFJ\\emgQSf~pRFa@>\ngGP@DjyjhdNfFJ\\fkgAbVyg\\Dao`<\ngGP@DjyjhdNfFJ\\fkgAbVyg\\Dao`>\ngGP@DjyjhdNfFJ\\fkgAbV~pRF~@<\ngGP@DjyjhdNfFJ\\fmgAcfyg\\DahP<\ngGP@DjyjhdNfFJ\\fmgAcfyg\\DahP>\ngGP@DjyjhdNfFJ]EkgAcfyg\\DahP<\ngGP@DjyjhdNfFJ]EkgAcfyg\\DahP>\ngGP@DjyjhdNfFJ]EkgAcf~pRFa@<\ngGP@DjyjhdNfFJ]EkgQSfyg\\DahP<\ngGP@DjyjhdNfFJ]EkgQSfyg\\DahP>\ngGP@DjyjhdNfFJ]EmgAcf~pRFa@>\ngGP@Dkij`NfFJ\\ek\\snBPtH\ngGP@Dkij`NfFJ\\ek_XICP`\ngGP@Dkij`NfFJ\\ek_XIC_@\ngGP@Dkij`NfFJ\\ekdabgMsNxICP`\ngGP@Dkij`NfFJ\\ekdabgM}`dMB\ngGP@Dkij`NfFJ\\ekgAbVyg\\Dao`\ngGP@Dkij`NfFJ\\ekgAbV~pRF~@\ngGP@Dkij`NfFJ\\ekgAbfyg\\DahP\ngGP@Dkij`NfFJ\\ekgAbf~pRFa@\ngGP@Dkij`NfFJ\\em_XICP`\ngGP@Dkij`NfFJ\\fmgAbfyg\\DahP\ngGP@Dkij`NfFJ\\fmgAbf~pRFa@\ngGP@DkijhdNfFJ\\ekdabdm}`dM|<\ngGP@DkijhdNfFJ\\ekgAbfyg\\Dao`>\ngGP@DkijhdNfFJ\\ekgAbf~pRF~@<\ngGP@DkijhdNfFJ\\ekgAbf~pRF~@>\ngGP@DkijhdNfFJ\\emgAbfyg\\DahP<\ngGP@DkijhdNfFJ\\emgAbfyg\\DahP>\ngGP@DkijhdNfFJ\\emgAbf~pRFa@<\ngGP@DkijhdNfFJ\\emgAbf~pRFa@>\ngGP@Lda`U@][IZwLvmdMB=\ngGP@Lda`U@][IZwLvmdMC~RqI@=\ngGP@Lda`U@][IZwLvmgu|=\ngGP@Lda`U@][IZwLvmgu}~RqI@=\ngGP@Lda`U@][IZwLvndMB\ngGP@Lda`U@][IZwLvndMC~RqI@\ngGP@Lda`U@][IZwLzndMB=\ngGP@Lda`U@][IZwLzndMC~RqI@=\ngGP@Lda`U@][IZyHTyK\\sjzPtH\ngGP@Lda`U@][IZyLTyK\\sZzPtH\ngGP@Lda`U@][IZyhXirVygUtahP=\ngGP@Lda`U@][IkWLvmdMB=\ngGP@Lda`U@][IkWLvndMB\ngGP@Lda`U@][IkWLzndMB=\ngGP@Lda`U@][IkYHTyK\\sjzPtH\ngGP@Lda`U@][IkYLTyK\\sZzPtH\ngGP@Lda`USH][IZwLvmdM|+\ngGP@Lda`USH][IZwLvmdM|-\ngGP@Lda`USH][IZwLvmdM}~RqI@+\ngGP@Lda`USH][IZwLvmdM}~RqI@-\ngGP@Lda`USH][IZwLvndM|<\ngGP@Lda`USH][IZwLvndM|>\ngGP@Lda`USH][IZyHTyK\\sjzPwp>\ngGP@Lda`USH][IZyLTyK\\sZzPwp>\ngGP@Lda`USH][IZyLTyK\\sZzPwwyKDd>\ngGP@Lda`USH][IZypTynYu]HZD<\ngGP@Lda`USH][IZypTynYu]HZD>\ngGP@Lda`USH][IZytTenYm]H[x<\ngGP@Lda`USH][IZytTenYm]H[x>\ngGP@Lda`USH][IZytTenYm]H[{|ebR<\ngGP@Lda`USH][IZytTenYm]H[{|ebR>\ngGP@Lda`USH][IZytTynYm]HZD<\ngGP@Lda`USH][IZytTynYm]HZD>\ngGP@Lda`USH][IZytTynYm]HZG|ebR<\ngGP@Lda`USH][IZytTynYm]HZG|ebR>\ngGP@Lda`USH][IZytTynYm]H[x<\ngGP@Lda`USH][IZytTynYm]H[x>\ngGP@Lda`USH][IZytTynYm]Okx<\ngGP@Lda`USH][IZytTynYm]Okx>\ngGP@Lda`USH][I[WLvmdMB+\ngGP@Lda`USH][I[WLvmdMB-\ngGP@Lda`USH][I[WLvndMB<\ngGP@Lda`USH][I[WLvndMB>\ngGP@Lda`USH][I[WLzndMB+\ngGP@Lda`USH][I[WLzndMB-\ngGP@Lda`USH][I[YHTyK\\sjzPtH<\ngGP@Lda`USH][I[YHTyK\\sjzPtH>\ngGP@Lda`USH][I[YLTyK\\sZzPtH<\ngGP@Lda`USH][I[YLTyK\\sZzPtH>\ngGP@Lda`USH][I[YpTenYu]HZD<\ngGP@Lda`USH][I[YpTenYu]HZD>\ngGP@Lda`USH][I[YpTynYu]HZD<\ngGP@Lda`USH][I[YpTynYu]HZD>\ngGP@Lda`USH][I[YtTenYm]HZD<\ngGP@Lda`USH][I[YtTenYm]HZD>\ngGP@Lda`USH][I[YtTynYm]HZD<\ngGP@Lda`USH][I[YtTynYm]HZD>\ngGP@Lda`USH][IjwLvmdM|+\ngGP@Lda`USH][IjwLvmdM|-\ngGP@Lda`USH][IjwLvndM|<\ngGP@Lda`USH][IjwLvndM|>\ngGP@Lda`USH][IjyHTyK\\sjzPwp<\ngGP@Lda`USH][IjyHTyK\\sjzPwp>\ngGP@Lda`USH][IjyLTyK\\sZzPwp<\ngGP@Lda`USH][IjyLTyK\\sZzPwp>\ngGP@Lda`USH][IjytTenYm]H[x<\ngGP@Lda`USH][IjytTenYm]H[x>\ngGP@Lda`USH][IjytTynYm]H[x<\ngGP@Lda`USH][IjytTynYm]H[x>\ngGP@Lda`USH][IkYpTynYu]HZD<\ngGP@Lda`USH][IkYpTynYu]HZD>\ngGP@Lda`USH][IkYtTynYm]HZD<\ngGP@Lda`USH][IkYtTynYm]HZD>\ngGPAEJU\\uPGSCENRusPqSdmsNxICP`\ngGPAEJU\\uPGSCENRusPqSdm}`dMB\ngGPAKrUM@@FyV}l}oP=\ngGPAMJUML@GVBgN\\EI[{AN{t\ngGPAMNRPpJ`Nmdm[f]WRFa@=\ngGPAMNRPpJ`Nmdukf[VrFa@=\ngGPAMNRPpJ`Nmdukf[WRFa@\ngGPAMNRPpJ`Nmdukf]WRFa@=\ngGPAMNRPpJ`NmdultLTyK\\sjzPtH=\ngGPAMNRPpJ`NmdulxJ\\wLzndMB>\ngGPAMNRPpJ`NmdulzJ\\wLvndMB>\ngGPAMvRPpJ`Nijyful}oP=\ngGPB@DZPLaYAJZjhCkAbf|PP\ngGPB@DZPLaYAJZjhCkAbj|PP\ngGPBABRDKaWAJnjhCkASf~pSz~@>\ngGPBADJHLQXaInjhCiQr\ngGPD@DDHRYjY@zTeWHwmg]v\ngGPD@DDHRYjY@zTeWHwmg]z\ngGPD@DDHRYjY@zTeWHwng]z\ngGPD@DDHRYjY@zTeYtTenQo]N{t\ngGPD@DDHRYjY@ztdunao[@\ngGPD@DDHRYjjTR`zLTykgAcfzpZD>\ngGPD@DFPRYfi@zLTykgQRVzp[t\ngGPD@DGpRYjY@ztduoao[oP\ngGPD@DHHRZzj@zL\\ek]DMB\ngGPD@DHHRZzj@zL\\ekgIrVyGexahP\ngGPD@DHHRZzj@zL\\ekgIrVzHZD\ngGPD@DHHR[f`@zd[h{np=\ngGPD@DHHR[ff@zL\\ek]GmB\ngGPD@DHHR[j`@zd[h{np=\ngGPD@DHHR[j`@zd[h{oP\ngGPD@DKpRYjZ@zLdfm\\c^vPtH\ngGPD@DSpRZVj@zlTyKV~pRFa@\ngGPD@DXHRfjj@zhXiKV~PRFa@\ngGPD@DXHRfjj@zhXiKWNCEM|`dMB\ngGPD@DXHRfjj@zhXjKV~PRFa@\ngGPD@DXHRfjjdPzhXiK[NCEM|`dMB<\ngGPD@DXHRfjjdPzhXiK[NCEM|`dMB>\ngGPD@DZ`R[ij@zLlfm\\cZvPtH\ngGPD@VIpRVjj@zlTyKV~pRFa@\ngGPD@bSpRZVj@zlTzMV~pRFa@\ngGPD@xIpR[j`@zd[d^Wcn{@=\ngGPD@xIpR[j`@zd[d^Wcn}@\ngGPD@xQpRjzj@zhTyKVyglDahP\ngGPD@xQpRkf`@zP\\wL{`gmz+\ngGPD@xQpRkf`@zP]WL{`g]v+\ngGPD@xQpRkf`@zP]WL{`gmz+\ngGPD@xUpRjZj@zhXirVyP\\Dao`\ngGPDADFHRYjY@zLTykgQRVzw[t\ngGPDADFHRYjjTRPzLTyk]XMB\ngGPDAHFPRYjjTRPzLTykgQRVzpZD\ngGPDAHFPRYjjTRPzLTykgQRVzp[x<\ngGPDAHFPRYjjTRPzLTykgQRVzp[x>\ngGPDAHJPRZzj@zL\\ek]DMB\ngGPDAHJPRZzj@zL\\ek]DM|\ngGPDAHJPRZzj@zL\\ek]GuB\ngGPDAbGDRYjjTRPzLTyk]XMB\ngGPDAbGDRYjjTRPzLTym]XMB>\ngGPDAbR`RYj`@zT]YtTeolD{oP>\ngGPDAxKpRYfj@zlTyKV~pRFa@\ngGPDAxSpRijj@zXXirVmr`xICP`\ngGPDAxSpRkj``PzP]WL}`g]v+\ngGPDAxSpRkj``PzP]WL}`g]v-\ngGPDAxSpRkj``PzP]WvB]wX+\ngGPDAxSpRkj``PzP]WvB]wX-\ngGPDAxSpRkjj`PzhTyKV~pRFa@<\ngGPDAxSpRkjj`PzhTyKV~pRFa@>\ngGPDaxF`Dgdjfj`NjFJ\\unTGAOjD\ngGPDaxF`Dgdjfj`NjFJ\\uodGAhP\ngGPDaxF`DgdjfjhDNjFJ]UodGAhP<\ngGPDaxF`DgdjfjhDNjFJ]UodGAhP>\ngGPEAxSpdiUuPPH]HNkf^pSn{@+\ngGPEAxSpdiUuPPH]HNkf^pSn{@-\ngGPFAVRDTIhPueaDfZj`NeEN]EIP>\ngGPH@DIJm]@]ZIZweB\ngGPH@DIKUU@]VJ\\ek\\cvBPtH\ngGPH@DIKUU@]VJ\\ek\\cvBPwp\ngGPH@DIKUU@]VJ\\ek_XICP`\ngGPH@DIKUU@]VJ\\ekgAbf~pRFa@\ngGPH@DILsP@]JNlzJRwvB]wh\ngGPH@DILuH@]JN[d^wSn{@=\ngGPH@DILuH@]JN[h{np=\ngGPH@DILuH@]JN[x^N{l=\ngGPH@DILuH@]JN[{]N{l=\ngGPH@DILuH@]RUrM{Yw]`=\ngGPH@DILuH@]RUrM{Yw^`\ngGPH@DILuH@]RUrM{Y{^`=\ngGPH@DILuH@]RUrM{iw]`=\ngGPH@DILuH@]RUrM{iw^`\ngGPH@DILuH@]RV]EI[d[wSn}@\ngGPH@DILuK@]FRRunQo[OZD\ngGPH@DILuK@]FRRunQo]OZD\ngGPH@DILuK@]FRRunQo]O[x\ngGPH@DILuK@]FRRuoao[hP\ngGPH@DILuK@]FRRvnQo[OZD\ngGPH@DILuK@]JRkd[vsn}@\ngGPH@DILuK@]JRkd[vsv}@\ngGPH@DILuPRH]JN[d^pSn{@+\ngGPH@DILuPRH]JN[d^pSn{@-\ngGPH@DILuPRH]JN[{AN{l+\ngGPH@DILuPRH]JN[{AN{l-\ngGPH@DILuPRH]JN[{AN{t>\ngGPH@DILuPRH]JNk{AN{l-\ngGPH@DIMMU@]VJ\\ekdqSdm}`dMB\ngGPH@DIMMU@]VJ\\ekgAbV~pRFa@\ngGPH@DIMMURH]VJ\\ekgQRV~pRFa@<\ngGPH@DIMMURH]VJ\\ekgQRV~pRFa@>\ngGPH@DIMtu@]FVRunQm[HZD\ngGPH@DIMtu@]FVRunQm]HZD\ngGPH@DISUU@]LLTyKVyP\\DahP\ngGPH@DISUU@]LLTyKWNCDmr`xIC_@\ngGPH@DISUU@]LLTyKWNCEMr`xICP`\ngGPH@DISUU@]LLTzMZyP\\DahP\ngGPH@DISUU@]LLUYKVyP\\DahP\ngGPH@DISUU@]LLUYKWNCEMr`xICP`\ngGPH@DISUU@]LLUYKZyP\\DahP\ngGPH@DISm]@]DJRundFa@\ngGPH@VILuH@]JN[h{np=\ngGPH@VILuH@]JN[x^N{l=\ngGPH@VILuH@]JN[{]N{l=\ngGPH@bILuH@]JN[h{np=\ngGPH@bILuH@]JN[{]N{l=\ngGPH@bILuH@]RUrM{Yw]`=\ngGPH@bILuH@]RUrM{iw]`=\ngGPH@bISUU@]LLUYKVyP\\DahP\ngGPH@xIKUU@]VJ\\ek\\cvBPtH\ngGPH@xILuH@]JN[d^wSn{@=\ngGPH@xILuH@]JN[x^N{l=\ngGPH@xIMMU@]VJ\\ek\\cvBPtH\ngGPH@xITuP@]XJ\\wJC`g]z\ngGPH@xITuP@]XJmWJC`g]v=\ngGPH@xITuP@]XJmWJC`g]z\ngGPH@xITuPPH]XJ]WJC`g]v+\ngGPH@xITuPPH]XJ]WJC`g]v-\ngGPH@xITuU@]LLTyKVyP\\DahP\ngGPH@xIUMT`]LLTyKVyP\\DaoP\ngGPH@xIUMT`]LLTyKV~P\\Da@\ngGPH@xIUMT`]LLTyMV~P\\Da@\ngGPH@xIUMT`]LLTzMV~P\\Da@\ngGPH@xIUMU@]LLTyKVyP\\DahP\ngGPH@xIUMU@]LLTyKVyP\\Dao`\ngGPH@xIUMU@]LLTyKVyP\\D~hP\ngGPH@xIUMU@]LLTyKWNCDmr`xICP`\ngGPH@xIUMU@]LLTyKZyP\\DahP\ngGPH@xIUMU@]LLTyMVyP\\DahP\ngGPH@xIUMU@]LLTzMVyP\\DahP\ngGPH@xIUMU@]LLTzMWNCDmr`xICP`\ngGPH@xIUMU@]LLTzMZyP\\DahP\ngGPHABILuH@]JN[h{np=\ngGPHABITuP@]XJmWJC`g]v=\ngGPHABITuP@]XJmWJC`g]z\ngGPHABITuP@]XJmWJC`gmz=\ngGPHABITuS@]LLTyKWNCGMr`xI{P`>\ngGPHADILuH@]JN[h{np=\ngGPHADILuH@]JN[{]N{l=\ngGPHADILuH@]JN\\zJRwvz]wh\ngGPHADILuPRH]JN[{AN{l+\ngGPHADILuPRH]JN[{AN{l-\ngGPHADILuUJIP]VJ\\ekgQRV~pRF~@<\ngGPHADIMMU@]VJ\\ek_XICP`\ngGPHADIMMU@]VJ\\ekdqSdm}`dMB\ngGPHADIMMURH]VJ\\ekgQRV~pRFa@<\ngGPHADIMMURH]VJ\\ekgQRV~pRFa@>\ngGPHADIMMURH]VJ\\ekgQrV~pSza@>\ngGPHAHILuH@]JN[{]N{l=\ngGPHAHILuK@]VJ\\ekgQRVzOZD\ngGPHAHILuK@]VJ\\ekgQRV~wSva@\ngGPHAHILuPRH]JN[{AN{l-\ngGPHAHIMMU@]VJ\\ekdqSdm}`dMB\ngGPHAHIMMURH]VJ\\ekgQRV~pRFa@<\ngGPHAHIMMURH]VJ\\ekgQRV~pRFa@>\ngGPHAVILuH@]JN[{]N{l=\ngGPHAVILuH@]JN\\zJRwvz]wh\ngGPHAVIMMU@]VJ\\ekdqSdm}`dMB\ngGPHAbIKUU@]VJ\\ek_XICP`\ngGPHAbILuH@]JN[{]N{l=\ngGPHAbILuPRH]JN[{AN{l+\ngGPHAbILuPRH]JN[{AN{l-\ngGPHAbILuPRH]JN\\zJ\\wvB^wh<\ngGPHAbILuUJIH]VJ]EmgQSf~pRFa@>\ngGPHAbIMMU@]VJ\\ekdqSdm}`dM|\ngGPHAxILsP@]JNk{AN{l=\ngGPHAxILuH@]JN[d^wSn{@=\ngGPHAxILuH@]JN[h{np=\ngGPHAxILuH@]JN[x^N{l=\ngGPHAxILuH@]JN[x^N{t\ngGPHAxILuH@]JN[{]N{l=\ngGPHAxILuPRH]JN[d^pSn{@+\ngGPHAxILuPRH]JN[d^pSn{@-\ngGPHAxILuUJIH]VJ\\ekgQSfyGlDahP<\ngGPHAxIMMU@]VJ\\ekdqSdmrOXICP`\ngGPHAxIMMU@]VJ\\ekdqSdm}`dMB\ngGPHAxITuP@]XJ\\wJC`g]v=\ngGPHAxITuP@]XJ\\wJC`g]z\ngGPHAxITuP@]XJ\\wJC`gmz=\ngGPHAxITuP@]XJmWJC`g]v=\ngGPHAxITuP@]XJmWJC`g]z\ngGPHAxITuP@]XJmWJC`gmz=\ngGPHAxITuP@]XJmYHXiK\\hNB]wh\ngGPHAxITuP@]XJmYhXirVyP\\D}oP=\ngGPHAxITuPPH]XJ]WJC`g]v+\ngGPHAxITuPPH]XJ]WJC`g]v-\ngGPHAxITuPPH]XJ]WJC`g]z<\ngGPHAxITuPPH]XJ]WJC`g]z>\ngGPHAxITuPPH]XJ]WJC`gmz+\ngGPHAxITuPPH]XJ]WJC`gmz-\ngGPHAxITuPPH]XJlwJCoG]v+\ngGPHAxITuPPH]XJlwJCoG]v-\ngGPHAxITuS@]LLUZKVyP\\D}hP\ngGPHAxITuU@]LLTyKVyP\\DahP\ngGPHAxITuU@]LLUZKVyP\\DahP\ngGPHAxITuUPH]LLTzKVyP\\DahP<\ngGPHAxITuUPH]LLTzKVyP\\DahP>\ngGPHKPITuURH]TLTyM\\hNBPwp<\ngGPHKPYIC@jfPzVRwtvmdH+\ngGPHKPYIC@jfPzVRwtvmdH-\ngGPHKPYIC@jfPzVRytTenYm]H[x>\ngGPHMPITtp@]HJ[e]wcn{@=\ngGPHMPITtp@]HJ[e]wcv}@=\ngGPHMPITtp@]HJ[h{np=\ngGPHMPITtp@]HJ[y]N{l=\ngGPHMPITtp@]HJ[y]O[t=\ngGPHMPYIC@j@zvRunYu]HZD=\ngGPHMPYIC@j@zvRvnYu]HZD+\ngGPHMPYIC@j@zvRvshis\\sZzPtH>\ngGPHMPYIC@j@zvSVnYm[HZD=\ngGPHMPYIC@j@zvSVnYm]HZD\ngGPHMPYIC@j@zvSVnYu]HZD=\ngGPHMPYIC@j@zvSVsPqSdmsNkiCP`=\ngGPHMPYIC@j@zvSVshis\\sZzPtH>\ngGPHMPYICFj@zXXjrVv\\EN[f]PRFa@>\ngGPHMPYICFj@zXXjrZusNhICP`\ngGPHMPYICJj@zXXirVnRFJ\\wLB`dMB>\ngGPHaxCeJSLuPGUbgI[YtTynQwAHZD>\ngGPI@DBTjZh@NlEVkeApSn{@=\ngGPI@DBTjZhHDNlENkeApSn}@<\ngGPI@DBTjZhHDNlENlxJRwJC`g]z<\ngGPI@DBTjZhHDNlENlxJRwJC`g]z>\ngGPI@DZTfzZ`NcKIkWHvmdMB\ngGPI@VBTjZh@NlEVkeApSn{@=\ngGPIAxBTfZd@NeGMrO[iw]`=\ngGPIAxBTfZhIDNeGMrOXIw]`+\ngGPIAxBTfZhIDNeGMrOXIw]`-\ngGPIAxBTffj`NkENRurXirVyGlDahP\ngGPIAxBTffj`NkENRurXirV~pRFa@\ngGPIAxBTijj`NfFJ\\ek\\kvBPtH\ngGPIAxBTjZh@NlEN[eApSn}@\ngGPIAxBTjZh@NlEVkeApSn{@=\ngGPIAxBTjZh@NlEVkeApSn}@\ngGPIAxBTjZh@NlEVkeApSv}@=\ngGPIAxBTjZhHDNlENkeApSv}@+\ngGPIAxBTjZhHDNlENkeApSv}@-\ngGPIAxBTjZj`NfFJ\\ek\\hNBPtH\ngGPIAxBTjZjhDNfFJ]Ek\\hNBPtH<\ngGPIAxBTjZjhDNfFJ]Ek\\hNBPtH>\ngGPIAxBTjfjPNfFJmFk\\hNBPwh\ngGPIAxBTjfj`NfFJ\\ek\\hNBPtH\ngGPIAxBTjfj`NfFJ\\em\\hNBPtH\ngGPIAxBTjfj`NfFJ\\fk\\hNBPtH\ngGPIAxBTjfj`NfFJ]Fk\\hNBPtH\ngGPIAxBTjfj`NfFJ]FkgAbVyP\\DahP\ngGPIAxBTjfj`NfFJmFk\\hNBPtH\ngGPIAxBTjfj`NfFJmFm\\hNBPtH\ngGPIEPKdkij`NfFJ]Fm\\snBPtH\ngGPIEPKdkjj`NfFJ\\em\\pNBPtH\ngGPIEPKdkjj`NfFJ\\fm\\pNBPtH\ngGPIEPKdkjj`NfFJ\\fmgAbfy`\\DahP\ngGPIEPKdkjj`NfFJ]Fm\\pNBPtH\ngGPIMP[djZX@NdEMrn{qw]`=\ngGPIMP[djZX@NdEMrn{q{^`=\ngGPIMP[lda`U@][I[WLzndMB+\ngGPIMP[lda`U@][IkWLvndMB\ngGPIMP[lda`U@][IkWLzndMB=\ngGPIMP[ldaeU@]LLTyK[ICEN[fAPRFa@>\ngGPIMP[ldaeU@]LLTyMZy`TDahP\ngGPJ@DQpSa``aBTuUPGVCFvRFJ\\wR}P`\ngGPJ@xQpSagBnFRRVj`NdDmsOKv}_@\ngGPL@DXHHPeMUTAtPqSWICEN[i^hP\ngGPL@xIpsadTajhCkQKWNSdm|OKuB\ngGPL@xQpSaddLZ@CjAnYu^O[t+\ngGPL@xQpSaddajhCharVmsOKqCP`\ngGPL@xQpSaddajhCharVmsOKqC__d`XP\ngGPLADHHhPdtuTAtXirVzwc{|dcb\ngGPLAHJPtadTajdCkQKT\ngGPLAHJPtadTajdCkQKV|oP\ngGPLAHJPtadTajhCkQKV|hP\ngGPLAHJPtadTajhCkQKV|o`\ngGPLAHJPtadTajhCkQKZ|hP\ngGPP@cTfyi`NeGH\ngGPPAcTijj`NlFJ\\xLTwbB\ngGPP`cUuyInZXCiQr\ngGPQ@c[rS\\tpGRcd\ngGPT@cYPZ`R[jj@zT\\`\ngGPTHlPxUpRjZj@zPXwe|\ngGPTHlPxUpRjZj@zPXypXeoKx\ngGPTHlQxUpRjvj@zPTwe|\ngGPTHlQxWpRjvj@zPTwe|\ngGPTIcQxIpRVjj@zTTw`|\ngGPUHlQxWpOIU[UPH]HJ[r~@<\ngGPUHlQxWpOIU[UPH]HJ[r~@>\ngGPXHlPDYIHUj@zp\\uoJD\ngGPXHlPDYIHUj@zp\\usdyK^TH\ngGPXHlPxIUMU@]XLZweB\ngGPXHlPxIUMU@]XL[WeB\ngGPXHlQxIU[U@]XJZweB\ngGPXHlQxIU[U@]XJZyLTyK^TH\ngGPXHlQxIU[U@]XJ[WeB\ngGPXHlQxIU[UPH]XJZytTeoJD<\ngGPXHlQxIU[UPH]XJZytTeoJD>\ngGPXHlQxIU[UPH]XJ[YtTeoJD<\ngGPXHlQxIU[UPH]XJ[YtTeoJD>\ngGPXIcPVIKUU@]JJP\ngGPXhlQx[crUVuPGVBfmyP`\ngGPYAcUPKdkjj`NlFJ[rA@\ngGPYAcUPKdkjj`NlFJ\\xLTwdB\ngGPYAcUPKdkjj`NlFR\\xLTwdB\ngGPYHlPDGlddJu@]XNZweB\ngGPYHlQxGdjmjhDNlEM[ra@<\ngGPYHlQxGdjmjhDNlEM[ra@>\ngGPYHlQxGdjmjhDNlEM\\zJRweB<\ngGPYHlQxGdjmjhDNlEM\\zJRweB>\ngGPYHlQxGdjmjhDNlEMkra@<\ngGPYHlQxGdjmjhDNlEMkra@>\ngGPYHlQxGdjmjhDNlEMlzJRweB<\ngGPYHlQxGdjmjhDNlEMlzJRweB>\ngGP`@TfYi`NcENZytTenlFa@\ngGP`@TfYi`NcEN[YtTenlFa@\ngGP`@TfYi`NcENkWVCP`\ngGP`@TfYi`NcENkYtTenlFa@\ngGP`@TfYjPNcENZytTenlF}@\ngGP`@TfYjPNcENZytTenmz}@\ngGP`@TfYjPNcENZytTeoLD\ngGP`@TfYjPNcENjytTenlF}@\ngGP`@TfYjPNcENjytTeoLD\ngGP`@TfYjPNmEV[{AN{l\ngGP`@TfYjPNmEV[{AN{t\ngGP`@TfYjPNmEVk{AN{l\ngGP`@TfYjPNmEVk{AN{t\ngGP`@TfYjPNmEVlzJRwvB]wh\ngGP`@TfYjhhNcENZwVCP`<\ngGP`@TfYjhhNcENZwVCP`>\ngGP`@TfYjhhNcENZwV}P`<\ngGP`@TfYjhhNcENZyLTyK]XMB<\ngGP`@TfYjhhNcENZyLTyK]XMB>\ngGP`@TfYjhhNcENZytTenlFa@<\ngGP`@TfYjhhNcENZytTenlFa@>\ngGP`@TfYjhhNcENZytTenlF~@<\ngGP`@TfYjhhNcENZytTenlF~@>\ngGP`@TfYjhhNcENZytTenmza@<\ngGP`@TfYjhhNcENjwVCP`<\ngGP`@TfYjhhNcENjwVCP`>\ngGP`@TfZfPNeIUrM{Yw]`\ngGP`@TfZfPNeIV]EI[d[wSn}@\ngGP`@TfZjeDdNcENZwVCP`\ngGP`@TfZjeDdNcENZwVC_@<\ngGP`@TfZjeDdNcENZyHXiK]XMB<\ngGP`@TfZjeDdNcENZyHXiK]XMB>\ngGP`@TfZjeDdNcENZyHXiK]XM|<\ngGP`@TfZjeDdNcENZyhXirVzpZD\ngGP`@TfZjeDdNcENZypXenlFa@<\ngGP`@TfZjeDdNcENZypXenlFa@>\ngGP`@TfZjeDdNcENZypXenlF~@>\ngGP`@TfZjeDdNcENZytTenlFa@\ngGP`@TfZjeDdNcENZytTenlF~@<\ngGP`@TfZjeDdNcENZytTenlF~@>\ngGP`@TfZjeDdNcEN[WVCP`<\ngGP`@TfZjeDdNcEN[WVCP`>\ngGP`@TfZjeDdNcEN[YtTynlFa@<\ngGP`@TfZjeDdNcEN[YtTynlFa@>\ngGP`@TfZjeDdNcENkWVCP`\ngGP`@TfZjeDhNcENZwVCP`<\ngGP`@TfZjeDhNcENZwVCP`>\ngGP`@TfZjeDhNcENZwVC_@<\ngGP`@TfZjeDhNcENZwVC_@>\ngGP`@TfZjeDhNcENZyHXiK]XMB<\ngGP`@TfZjeDhNcENZyHXiK]XMB>\ngGP`@TfZjeDhNcENZyhXirVzpZD<\ngGP`@TfZjeDhNcENZyhXirVzpZD>\ngGP`@TfZjeDhNcENZypXenlFa@<\ngGP`@TfZjeDhNcENZypXenlFa@>\ngGP`@TfZjeDhNcENZypXynlFa@>\ngGP`@TfZjeDhNcENZytTenlFa@<\ngGP`@TfZjeDhNcENZytTenlFa@>\ngGP`@TfZjeDhNcENZytTenlF~@<\ngGP`@TfZjeDhNcENZytTenlF~@>\ngGP`@TfZjeDhNcENZytTenmz~@<\ngGP`@TfZjeDhNcEN[WVCP`<\ngGP`@TfZjeDhNcEN[WVCP`>\ngGP`@TfZjeDhNcEN[YpXenlFa@<\ngGP`@TfZjeDhNcENkWVCP`<\ngGP`@TfZjeDhNcENkWVCP`>\ngGP`@TfzZihNcENZweB>\ngGP`@TfzZihNcENZytTeneva@>\ngGP`@TfzZihNmKM[x[VzD<\ngGP`@TfzZihNmKM[x[VzD>\ngGP`@dfnjPNcGIZyr\\enbF}@\ngGP`@dfnjPNcGIZyr\\eoBD\ngGP`@dfnj`NcGIZwQCP`\ngGP`@dfnj`NcGIZyHXiK]DMB\ngGP`@dfnj`NcGIZyHXiK]DM|\ngGP`@dfnj`NcGIZyr\\enbFa@\ngGP`@dfnj`NcGIZyr\\enbF~@\ngGP`@dfnj`NcGIZyr\\encza@\ngGP`@dfnj`NcGI[WQCP`\ngGP`@dfnj`NcGIjyHXiK]DMB\ngGP`@dfnjiDNcGIZyHTyK]DMB<\ngGP`@dfnjiDNcGIZyHTyK]DMB>\ngGP`@dfnjiDNcGIZypTenbFa@<\ngGP`@dfnjiDNcGIZypTenbFa@>\ngGP`@dfnjiDNcGIZypTenbF~@<\ngGP`@dfnjiDNcGIZypTencza@<\ngGP`@dfnjiDNcGIZypTencza@>\ngGP`@dfyh@NiFzN{l=\ngGP`@dfyh@NiFzN{t\ngGP`@dfyh@NiFzO[t=\ngGP`@dfyh@NiGNbdmt]wh\ngGP`@dfyh@NiGNbgMt^wh\ngGP`@dfyi`NcGIZwQ{P`\ngGP`@dfyi`NcGIZwQ{PdlRP\ngGP`@dfyi`NcGIZwQ{_@\ngGP`@dfyi`NcGIZweB\ngGP`@dfyi`NcGIZwe|\ngGP`@dfyi`NcGIZytTencva@\ngGP`@dfyi`NcGIZytTeoJD\ngGP`@dfyi`NcGIZytTyncva@\ngGP`@dfyi`NcGIZytTyncv~@\ngGP`@dfyi`NcGIZytTyoJD\ngGP`@dfyi`NcGI[WQ{P`\ngGP`@dfyi`NcGI[WeB\ngGP`@dfyi`NcGI[YtTyncva@\ngGP`@dfyi`NcGI[YtTyoJD\ngGP`@dfyi`NeGUt]wX\ngGP`@dfyi`NeGUt]wh\ngGP`@dfyi`NeGUt^wX\ngGP`@dfyi`NeGUt^wh\ngGP`@dfyi`NeGV]EN[h}oP\ngGP`@dfyj`NcGIZwQCP`\ngGP`@dfyj`NcGIZwQCPdlRP\ngGP`@dfyj`NcGIZwQ}_@\ngGP`@dfyj`NcGIkWQCP`\ngGP`@dfyjidNcGIZwQC_@<\ngGP`@dfyjidNcGIZwQC_@>\ngGP`@dfyjidNcGIZyLTyK]DM|>\ngGP`@dfyjidNcGIZytTenbF~@<\ngGP`@dfyjidNcGIZytTenbF~@>\ngGP`@dfyjidNcGIZytTynbFa@<\ngGP`@dfyjidNcGIZytTynbFa@>\ngGP`@dfyjidNcGIZytTynbF~@<\ngGP`@dfyjidNcGIZytTynbF~@>\ngGP`@dfyjidNcGI[WQCP`<\ngGP`@dfyjidNcGI[WQCP`>\ngGP`@dfyjidNcGI[YtTynbFa@>\ngGP`@dfyjidNcGIjwQC_@<\ngGP`@dfyjidNcGIjwQC_@>\ngGP`@dfzh@NiFzN{l=\ngGP`@dfzh@NiFzN{t\ngGP`@dfzh@NiGICEI[h{oP\ngGP`@dfzhIDNiGNBdmt]wh<\ngGP`@dfzhIDNiGNBdmt]wh>\ngGP`@dfzj`NcGIZwQCP`\ngGP`@dfzj`NcGIZyhXirVzHZD\ngGP`@dfzjeEdNcGIZypTynbFa@<\ngGP`@dfzjeEdNcGIZypTynbFa@>\ngGP`@dfzjeEhNcGIZypTynbFa@>\ngGP`ADkjj`NjENRuolDahP\ngGP`ADkjj`NjENRurPqSf~pRFa@\ngGP`ADkjj`NjENRus`qK_XIC_@\ngGP`ADkjj`NjENRus`qS_XICP`\ngGP`ADkjj`NjENRvolDahP\ngGP`ADkjj`NjENcVolDahP\ngGP`ADkjj`NjENcVrPqSf~pRFa@\ngGP`ATeVn`NeDh\ngGP`ATffj`NcENRwVBP`\ngGP`ATffjiDNcENRwVB_@<\ngGP`ATffjiDNcENRwVB_@>\ngGP`ATffjiDNcENRytTenlDa@<\ngGP`ATffjiDNcENRytTenlDa@>\ngGP`ATffjiDNcENSWVBP`>\ngGP`Adeij`NcEIZwQCP`\ngGP`Adijj`NjFJRuodDahP\ngGP`Adijj`NjFJRuodD~o`\ngGP`Adijj`NjFJRurPqrV~WbFa@\ngGP`Adijj`NjFJRus`qS_HICP`\ngGP`Adijj`NjFJRus`qS_KqCP`\ngGP`Adijj`NjFJSVs`qS_HICP`\ngGP`Adijj`NjFJbus`qS_HICP`\ngGP`AdijjiDNjFJRuodDao`<\ngGP`AdijjiDNjFJRuodDao`>\ngGP`AdijjiDNjFJRurPqSf~PRFa@>\ngGP`AdijjiDNjFJRurPqSf~WbFa@<\ngGP`AdijjiDNjFJRurPqSf~WbFa@>\ngGP`AdijjiDNjFJRurPqrV~PRF~@>\ngGP`AdijjiDNjFJRus`qK_HIC_@<\ngGP`AdijjiDNjFJRus`qK_HIC_@>\ngGP`AdijjiDNjFJRus`qK_KqC_@>\ngGP`AdijjiDNjFJRus`qS_HIC_@<\ngGP`AdijjiDNjFJRus`qs_HICP`<\ngGP`AdijjiDNjFJRus`qs_HICP`>\ngGP`AdijjiDNjFJRus`qs_HIC_@<\ngGP`AdijjiDNjFJRus`qs_HIC_@>\ngGP`AdijjiDNjFJRus`qs_KqCP`<\ngGP`AdijjiDNjFJRus`qs_KqCP`>\ngGP`AdijjiDNjFJRvodDahP<\ngGP`AdijjiDNjFJRvodDahP>\ngGP`AdijjiDNjFJRvs`qS_HICP`<\ngGP`AdijjiDNjFJRvs`qS_HICP`>\ngGP`AdijjiDNjFJRvs`qs_HICP`<\ngGP`AdijjiDNjFJRvs`qs_HICP`>\ngGP`AdijjiDNjFJSUs`qK_HIC_@<\ngGP`AdijjiDNjFJSUs`qK_HIC_@>\ngGP`AdijjiDNjFJbus`qK_HIC_@<\ngGP`AdijjiDNjFJbus`qs_HICP`<\ngGP`AdijjiDNjFJbus`qs_HICP`>\ngGP`AdijjiDNjFJbvs`qs_HICP`<\ngGP`AdijjiDNjFJbvs`qs_HICP`>\ngGPa@SrSLuHGQbgM\\zJRwVC^`\ngGPa@SrSMSHGQbgM\\zJRwV{^`\ngGPa@erS\\t@GTc]G]v=\ngGPa@erS\\t@GTc]G]z\ngGPa@erS\\t@GTc]Gmz=\ngGPa@erS\\tpGQcdm[ra@\ngGPa@erS\\uPGQcdm[hahP\ngGPa@erS\\uPGQcdm[hah_rVIH\ngGPa@erS\\uTrGQcdmkhahP<\ngGPa@iJS]T@GTc]G]v=\ngGPa@krS\\t@GTc]Gmz\ngGPa@mrS\\uPGRcjzO[t\ngGPdCPVZ`R[ij@ztTyoEt\ngGPdE`DRPrRRrtAu`ek^TH\ngGPdH`DTHrRPkTAu`yK]DM|\ngGPdH`DWprRPkTAu`yK]DM|\ngGPdH`VTlRjZj@zHXzM_XIC_@\ngGPdH`VUpRjZj@zHXzM_XIC_@\ngGPdH`xUpRjZj@zHXyK_XIC_@\ngGPdH`xUpRjZj@zHXyKgAbV~pRF~@\ngGPdH`xUpRjZj@zHXzM_XIC_@\ngGPdH`xUpRjZj@zHXzMgAbV~pRF~@\ngGPdH`xUpRjZj`PzHXyM_XIC_@<\ngGPdH`xUpRjZj`PzHXyM_XIC_@>\ngGPdH`xV`RjZj@zHXzM]XIB\ngGPdI`VIpRVjj@zLTfm_CqCP`\ngGPeE`DSpGIM\\uRH]FNSUnbFa@>\ngGPeH`VUDliUMU@]DL]FnlDa@\ngGPh@iPIMuP@]RMt]wX=\ngGPh@iPIMuP@]RMt]wh\ngGPh@iPIMuP@]RMt^wh=\ngGPh@iPIMuP@]RN\\EI[h{oP>\ngGPh@iPIMuS@]FNRuncva@\ngGPh@iPIMuS@]FNRuoJD\ngGPh@iPIMuS@]FNRvncva@\ngGPh@iPIMuS@]FNRvoJD\ngGPh@iPIMuS@]JNkh{oP\ngGPh@iPIMuU@]FNRunbFa@\ngGPh@iPIMuUSH]FNRvnbFa@>\ngGPhCPDILuK@]JR[h[vp\ngGPhCPDILuK@]JR[h[wP\ngGPhCPDILuK@]ZJ\\`\ngGPhCPDILuK@]ZJ\\wfz\ngGPhCPDILuSRH]ZJ\\wP}``>\ngGPhCPDILuSRH]ZJ\\wfB<\ngGPhCPDILuSRH]ZJ\\wfB>\ngGPhCQBILuK@]ZJ\\wfz\ngGPhCQDILuSRH]ZJ\\wfB>\ngGPhCQbILuSRH]ZJ\\wfB>\ngGPhCQxILsS@]ZJ\\wfB\ngGPhCQxILuK@]ZJ\\wP}n`\ngGPhCQxILuK@]ZJ\\wfz\ngGPhDPDIMuUJKH]ZNZytTeoJD<\ngGPhDPDIMuUJKH]ZNZytTeoJD>\ngGPhH`DYIHUi@zH\\ek^DH\ngGPhH`DYIHUi@zH\\ekgIrVzH[t\ngGPhH`DYIHUi@zH\\fk]DMz\ngGPhH`DYIHUi@zH\\fk^DH\ngGPhH`DYIHUj@zH\\ek]DMB\ngGPhH`DYIHUj@zH\\ekgIrVzHZD\ngGPhH`DYIHUj@zH\\em]DMB\ngGPhH`DYIHUj@zH\\fk]DMB\ngGPhH`DYIHUj@zH\\fk]DM|\ngGPhH`DYIHUj@zH\\fm]DMB\ngGPhH`xIUMU@]TL\\ek_XICP`\ngGPhH`xIUMU@]TL\\ek_[q}P`\ngGPhH`xIUMU@]TL\\ekgAbV~pRF~@\ngGPhH`xIUMU@]TL\\ekgAbV~wcza@\ngGPhH`xIUMU@]TL\\em_XICP`\ngGPhH`xIUMU@]TL]Fm_XICP`\ngGPhH`xYIHZj@zH\\ek]DMB\ngGPhHaVYICE`@z`[h{oP\ngGPhHaVYICJ`@z`[h{np=\ngGPhHaxIU[U@]TJ\\ek_XICP`\ngGPhHaxIU[U@]TJ]Fm_XICP`\ngGPhHaxIU[UPH]TJ\\fk_XICP`<\ngGPhHaxYICJ`@z`[h{oP\ngGPhI`xIKUU@]FJRuoaxahP\ngGPhaePRUrUuUPGUCEIkWtBPtH\ngGPhaePRUrUuUPGUCEIkYpXiohDahP\ngGPiAePKdkjj`NjFJSVs`qS_PICP`\ngGPiCPDWdfZe`NeIMtM{X\ngGPllQHR`TaNliM]U@]ZNZyr\\eoJD\ngGPmLQHR`TaNRZzj@zt\\usdyK^TH\ngGQ@@dmMTAuXirVm}`dMB\ngGQ@@dmMTAuXirVm}`dM|\ngGQ@@dmMTAuXirVu}`dMB\ngGQ@@dmMTAuXirZu}`dMB\ngGQ@@dmUTAuXirVm}`dMB\ngGQ@@dmUTAuXirVm}`dM|\ngGQ@@dmUTAuXirVnRFJ\\wvBPtH\ngGQ@@dmUTAuXirVn\\FJ[{AHZD\ngGQ@@dmUTAuXirVu}`dMB\ngGQ@@dsM@AthyolD{np=\ngGQ@@dsM@AthyolD{oP\ngGQ@@dsM@AthyolD}oP=\ngGQ@@dsM@Athyomx{np=\ngGQ@@dsM@Athyomx{oP\ngGQ@@dsM@AthyshiK_XIw^`\ngGQ@@dsM@AthyshiK_[qw^`\ngGQ@@dsM@Athyshis_XI{^`\ngGQ@@dsM@Athyshis_[q{^`\ngGQ@@dsM@AthzolD{np=\ngGQ@@dsM@AthzolD{oP\ngGQ@@dsM@AthzolD}oP=\ngGQ@@dsM@AthzshiK_XIw^`\ngGQ@@dsM@Athzshis_XI{^`\ngGQ@@dsMLAuXirVmu`tH\ngGQ@@dsMLAuXirVmu`wp\ngGQ@@dsMLAuXirVmuoTH\ngGQ@@dsMLAuXirVm}`gmB\ngGQ@@dsMLAuXirVm}`gm|\ngGQ@@dsMLAuXirVn]EI[kAhP\ngGQ@@dsMLAuXirVn]EI[kAo`\ngGQ@@dsMLAuXirVn]EI[k^hP\ngGQ@@dsMLAuXirVn]EI[{AOZD\ngGQ@@dsMLAuXirVn]EI[{AO[x\ngGQ@@dsMLAuXirVn]EI[{^OZD\ngGQ@@dsMLAuXirVn]EN[kAhP\ngGQ@@dsMLAuXirVn]EN[kAo`\ngGQ@@dsMLAuXirVn]EN[k^hP\ngGQ@@dsMLAuXirVn]EN[{AOZD\ngGQ@@dsMLAuXirVn]EN[{AO[x\ngGQ@@dsMLAuXirVn]EN[{^OZD\ngGQ@@dsMLAuXirVu}`gmB\ngGQ@@dsMLAuXirVv]EI[{AOZD\ngGQ@@dsMLAuXirVv]EN[kAhP\ngGQ@@dsMLAuXirVv]EN[{AOZD\ngGQ@@dsMLAuXitVmu`tH\ngGQ@@dsMLAuXitVmu`wp\ngGQ@@dsMLAuXitVm}`gmB\ngGQ@@dsMLAuXitVm}`gm|\ngGQ@@dsMLAuXitVn]EI[kAhP\ngGQ@@dsMLAuXitVn]EI[kAo`\ngGQ@@dsMLAuXitVn]EI[{AOZD\ngGQ@@dsMLAuXitVn]EI[{AO[x\ngGQ@@dsMLAuXitVn]EN[kAhP\ngGQ@@dsMLAuXitVn]EN[kAo`\ngGQ@@dsMLAuXitVn]EN[{AOZD\ngGQ@@dsMLAuXitVn]EN[{AO[x\ngGQ@@dsMLAuXitVuu`tH\ngGQ@@dsMLAuXitVu}`gmB\ngGQ@@dsMLAuXitVv]EN[kAhP\ngGQ@@dsMLAuXitVv]EN[{AOZD\ngGQ@@dsMLAuhjs_XIw]`\ngGQ@@dsMLAuhjs_XIw^`\ngGQ@@dsMLAuhjs_XI{]`\ngGQ@@dsMLAuhjs_XI{^`\ngGQ@@dsMLAuhjs_[qw^`\ngGQ@@dsMLAuhjsgQSf~pSv{@\ngGQ@@dsMLAuhjsgQSf~pSv}@\ngGQ@@dsMLAuhju_XIw^`\ngGQ@@dsMLAuhju_XI{]`\ngGQ@@dsMLAuhju_XI{^`\ngGQ@@dsMLAuhjugQSf~pSv{@\ngGQ@@dsMLAuhjugQSf~pSv}@\ngGQ@@dsMTAuXirVm}`dMB\ngGQ@@dsMTAuXirVm}`dMC~RqI@\ngGQ@@dsMTAuXirVm}oDMB\ngGQ@@dsMTAuXirVnSENRwvBPtH\ngGQ@@dsMTAuXirVnSENRwv|PtH\ngGQ@@dsMTAuXirZvSENRwvBPtH\ngGQ@@dsMTAuXitVm}`dMB\ngGQ@@dsMTAuXitVm}`dMC~RqI@\ngGQ@@dsMTAuXitVm}`gu|\ngGQ@@dsMTAuXitZu}`dMB\ngGQ@@dsMUDauXirVm}`dM|<\ngGQ@@dsMUDauXirVm}`dM|>\ngGQ@@dsMUDauXirVnSENRwvBPwp<\ngGQ@@dsMUDauXirVnSENRwvBPwp>\ngGQ@@dsMUDauXirVnSENRwv|Pwp>\ngGQ@@dsMUDauXirVn]EI[{AH[x<\ngGQ@@dsMUDauXirVn]EI[{AH[x>\ngGQ@@dsMUDauXirVn]EI[{AH[{|ebR>\ngGQ@@dsMUDauXirVn]EN[{AHZD<\ngGQ@@dsMUDauXirVn]EN[{AHZD>\ngGQ@@dsMUDauXirVn]EN[{AHZG|ebR<\ngGQ@@dsMUDauXirVn]EN[{AHZG|ebR>\ngGQ@@dsMUDauXirVn]EN[{AH[x<\ngGQ@@dsMUDauXirVn]EN[{AH[x>\ngGQ@@dsMUDauXirVn]EN[{AOkx<\ngGQ@@dsMUDauXirVn]EN[{AOkx>\ngGQ@@dsMUDauXirVn]EN[{^HZD<\ngGQ@@dsMUDauXirVn]EN[{^HZD>\ngGQ@@dsMUDauXirVv]EN[{AHZD<\ngGQ@@dsMUDauXirVv]EN[{AHZD>\ngGQ@@dsMUDauXitVm}`dM|<\ngGQ@@dsMUDauXitVm}`dM|>\ngGQ@@dsMUDauXitVn]EI[{AH[x<\ngGQ@@dsMUDauXitVn]EN[{AHZD<\ngGQ@@dsMUDauXitVn]EN[{AHZD>\ngGQ@@dsMUDauXitVu}`dMB<\ngGQ@@dsMUDauXitVu}`dMB>\ngGQ@@dsT`Athyncn{@=\ngGQ@@dsT`Athyncn}@\ngGQ@@dsT`Athyncv}@=\ngGQ@@dsT`Athyomt{np=\ngGQ@@dsT`Athyomt{oP\ngGQ@@dsT`Athys`qK]G]z\ngGQ@@dsT`Athys`qK_[iw^`\ngGQ@@dsT`AthyshiK]G]z\ngGQ@@dsT`AthyshiK_[iw^`\ngGQ@@dsT`Athyshis_[i{^`\ngGQ@@dsT`AuIWHwmg]v=\ngGQ@@dsT`AuIWHwmg]z\ngGQ@@dsT`AuIWHwmgmz=\ngGQ@@dsT`AuIWHwng]v=\ngGQ@@dsT`AuIWHwng]z\ngGQ@@dsT`AuIYtTenQo]N{t\ngGQ@@dsTlAtYIKV~F}na@\ngGQ@@dsTlAtYIKZyF}l}hP\ngGQ@@dsTlAuXirVnZFJ\\encva@\ngGQ@@dsTlAuXirVn]EN[{]OZD\ngGQ@@dsUAHathyolD{np+\ngGQ@@dsUAHathyolD{np-\ngGQ@@dsUAHathyolD{oP<\ngGQ@@dsUAHathyolD{oP>\ngGQ@@dsUAHathyolD}oP+\ngGQ@@dsUAHathyolD}oP-\ngGQ@@dsUAHathyomx{np+\ngGQ@@dsUAHathyomx{np-\ngGQ@@dsUAHathyomx{oP<\ngGQ@@dsUAHathyomx{oP>\ngGQ@@dsUAHathyrPqRV~pSn}@<\ngGQ@@dsUAHathyrPqRV~pSn}@>\ngGQ@@dsUAHathys`qK_XIw^`<\ngGQ@@dsUAHathys`qK_XIw^`>\ngGQ@@dsUAHathyshiK_XIw^`<\ngGQ@@dsUAHathyshiK_XIw^`>\ngGQ@@dsUAHathyshiK_[qw^`<\ngGQ@@dsUAHathyshiK_[qw^`>\ngGQ@@dsUAHathyshis_XI{^`<\ngGQ@@dsUAHathyshis_XI{^`>\ngGQ@@dsUAHathyshis_[q{^`<\ngGQ@@dsUAHathyshis_[q{^`>\ngGQ@@dsUAHathzolD{np+\ngGQ@@dsUAHathzolD{np-\ngGQ@@dsUAHathzolD{oP<\ngGQ@@dsUAHathzolD{oP>\ngGQ@@dsUAHathzolD}oP-\ngGQ@@dsUAHathzs`qK_XIw^`<\ngGQ@@dsUAHathzs`qK_XIw^`>\ngGQ@@dsUMHauXirVmu`tH<\ngGQ@@dsUMHauXirVmu`tH>\ngGQ@@dsUMHauXirVm}`gmB<\ngGQ@@dsUMHauXirVm}`gmB>\ngGQ@@dsUMHauXirVm}`gm|>\ngGQ@@dsUMHauXirVnRFJ\\wVCP`<\ngGQ@@dsUMHauXirVnZFJ\\enlFa@>\ngGQ@@dsUMHauXirVn\\FN[{AOZD<\ngGQ@@dsUMHauXirVn\\FN[{AOZD>\ngGQ@@dsUMHauXirVn]EI[kAhP<\ngGQ@@dsUMHauXirVn]EI[kAhP>\ngGQ@@dsUMHauXirVn]EI[kAo`<\ngGQ@@dsUMHauXirVn]EI[kAo`>\ngGQ@@dsUMHauXirVn]EI[k^hP>\ngGQ@@dsUMHauXirVn]EI[{AO[x>\ngGQ@@dsUMHauXirVn]EI[{^OZD<\ngGQ@@dsUMHauXirVn]EN[kAhP<\ngGQ@@dsUMHauXirVn]EN[kAhP>\ngGQ@@dsUMHauXirVn]EN[{AOZD<\ngGQ@@dsUMHauXirVn]EN[{AOZD>\ngGQ@@dsUMHauXirVuu`tH<\ngGQ@@dsUMHauXitVmu`tH<\ngGQ@@dsUMHauXitVmu`tH>\ngGQ@@dsUMHauhjs_XIw]`<\ngGQ@@dsUMHauhjs_XIw]`>\ngGQ@@dsUMHauhjs_[qw]`<\ngGQ@@dsUMHauhjs_[qw]`>\ngGQ@@dsUThdauXirVm}`dM|<\ngGQ@@dsUThdauXirVm}`dM|>\ngGQ@@dsUThdauXirVnRFJRwvBPwp<\ngGQ@@dsUThdauXirVnRFJ\\wvBPtH>\ngGQ@@dsUThdauXirVnSENRwvBPwp>\ngGQ@@dsUThdauXirVn\\FN[{AHZD<\ngGQ@@dsUThdauXirVn\\FN[{AHZD>\ngGQ@@dsUThdauXirVn]EI[{AH[x<\ngGQ@@dsUThdauXirVn]EI[{AH[x>\ngGQ@@dsUThdauXirVn]EN[{AHZD<\ngGQ@@dsUThdauXirVn]EN[{AHZD>\ngGQ@@dsUThdauXirVn]EN[{AH[x<\ngGQ@@dsUThdauXirVn]EN[{AH[x>\ngGQ@@dsUThdauXirVn]EN[{AOkx<\ngGQ@@dsUThdauXirVn]EN[{AOkx>\ngGQ@@dsUThdauXirVn]EN[{^HZD<\ngGQ@@dsUThdauXirVn]EN[{^HZD>\ngGQ@@dsUThdauXirVn]EN[{^Okx<\ngGQ@@dsUThdauXirVu}`dMB<\ngGQ@@dsUThdauXirVv]EN[{AHZD<\ngGQ@@dsUThdauXirVv]EN[{AHZD>\ngGQ@@dsUThdauXitVn]EN[{AHZD<\ngGQ@@dsUThdauXitVn]EN[{AHZD>\ngGQ@@dsUTheAuXirVm}`dM|<\ngGQ@@dsUTheAuXirVm}`dM|>\ngGQ@@dsUTheAuXirVm}oDM|<\ngGQ@@dsUTheAuXirVnRFJRwvBPwp>\ngGQ@@dsUTheAuXirVnRFJ\\wvBPtH<\ngGQ@@dsUTheAuXirVnRFJ\\wvBPtH>\ngGQ@@dsUTheAuXirVn\\FN[{AHZD<\ngGQ@@dsUTheAuXirVn\\FN[{AHZD>\ngGQ@@dsUTheAuXirVn]EI[{AH[x<\ngGQ@@dsUTheAuXirVn]EI[{AH[x>\ngGQ@@dsUTheAuXirVn]EI[{^H[x>\ngGQ@@dsUTheAuXirVn]EN[{AHZD<\ngGQ@@dsUTheAuXirVn]EN[{AHZD>\ngGQ@@dsUTheAuXirVn]EN[{AH[x<\ngGQ@@dsUTheAuXirVn]EN[{AH[x>\ngGQ@@dsUTheAuXirVn]EN[{AOkx<\ngGQ@@dsUTheAuXirVn]EN[{AOkx>\ngGQ@@dsUTheAuXirVu}`dMB<\ngGQ@@dsUTheAuXirVu}`dMB>\ngGQ@@dsUTheAuXirVv]EN[{AHZD<\ngGQ@@dsUTheAuXitVm}`dM|>\ngGQ@@dsUTiDauXirVn]EN[{^HZD<\ngGQ@@dsUTiDauXirVn]EN[{^HZD>\ngGQ@@dsUTiDauXitVn\\FN[{AHZD<\ngGQ@@dsUTiDauXitVn\\FN[{AHZD>\ngGQ@@dsUTiDauXitVn]EN[{AHZD>\ngGQ@@dsUUHauXirVm}`dMB<\ngGQ@@dsUUHauXirVm}`dMB>\ngGQ@@dsUUHauXirVm}`dMC~RqI@<\ngGQ@@dsUUHauXirVm}`gu|>\ngGQ@@dsUUHauXirVm}oDMB<\ngGQ@@dsUUHauXirVm}oDMB>\ngGQ@@dsUUHauXirVm}oGu|<\ngGQ@@dsUUHauXirVnSENRwvBPtH<\ngGQ@@dsUUHauXirVnSENRwvBPtH>\ngGQ@@dsUUHauXirVnSENRwv|PtH<\ngGQ@@dsUUHauXirVnZFJ\\eolDahP<\ngGQ@@dsUUHauXirVnZFJ\\eolDahP>\ngGQ@@dsUUHauXirVnZFJ\\eomxahP<\ngGQ@@dsUUHauXitVm}`dMB<\ngGQ@@dsUUHauXitVm}`dMB>\ngGQ@@dtuRAuXirVmu`dH\ngGQ@@dtuRAuXirVnSENRwVBP`\ngGQ@@dtuRAuXirVn\\FI[kAHP\ngGQ@@dtuRAuXirVn\\FI[{AH[t\ngGQ@@dtuRAuXitZn\\FI[kAHP\ngGQ@@dtuSHauXirVmu`gp>\ngGQ@@dtuSHauXirVnRFJRwVBP`<\ngGQ@@dtuSHauXirVnRFNRwVB_@<\ngGQ@@dtuSHauXirVnSENRwVB_@>\ngGQ@@dtuSHauXirVn]EI[kAHP<\ngGQ@@dtuSHauXirVn]EI[kAHP>\ngGQ@@dtuSHauXirVn]EI[{AH[t<\ngGQ@@dtuSHauXirVn]EI[{AH[t>\ngGQ@@dtuSHauXirVn]GI[kAO`<\ngGQ@@dtuSHauXirZn]EI[kAHP<\ngGQ@@dtuSHauXirZn]EI[kAHP>\ngGQ@@dtuTAuXirVm}`dMB\ngGQ@@dtuTAuXirVm}oGuB\ngGQ@@dtuTAuXirVnSENRwvBPtH\ngGQ@@dtuTAuXirVnSENRwvBPwp\ngGQ@@dtuTAuXirVn\\FI[{AHZD\ngGQ@@dtuTAuXirVn\\FI[{AH[x\ngGQ@@dtuTAuXirVu}`dMB\ngGQ@@dtuTAuXitZm}`dMB\ngGQ@@dtuUHauXirVm}`guB<\ngGQ@@dtuUHauXirVm}`guB>\ngGQ@@dtuUHauXirVnRFJRwvBPtH<\ngGQ@@dtuUHauXirVnRFJRwvBPtH>\ngGQ@@dtuUHauXirVnRFNRwvB_TH<\ngGQ@@dtuUHauXirVnRFNRwvB_TH>\ngGQ@@dtuUHauXirVnSENRwvB_TH<\ngGQ@@dtuUHauXirVn]EI[{AHZD<\ngGQ@@dtuUHauXirVn]EI[{AHZD>\ngGQ@@dtuUHauXirVn]EI[{AHZG|dcb>\ngGQ@@dtuUHauXirVn]EI[{AH[x<\ngGQ@@dtuUHauXirVn]EI[{AH[x>\ngGQ@@dtuUHauXirVn]EI[{AOjD<\ngGQ@@dtuUHauXirVn]EI[{AOjD>\ngGQ@@dtuUHauXirVn]EI[{^OjD<\ngGQ@@dtuUHauXirVn]EI[{^OjD>\ngGQ@@dtuUHauXirVn]GI[{AOjD<\ngGQ@@dtuUHauXirVn]GI[{AOjD>\ngGQ@@dtuUHauXirVn]GI[{AOkx<\ngGQ@@dtuUHauXirVn]GI[{AOkx>\ngGQ@@dtuUHauXirVv]EI[{AHZD<\ngGQ@@dtuUHauXirZm}`dMB<\ngGQ@@dtuUHauXirZm}`dMB>\ngGQ@@dtuUHauXirZm}`dM|<\ngGQ@@dtuUHauXirZn\\FI[{AHZD<\ngGQ@@dtuUHauXirZn\\FI[{AHZD>\ngGQ@@dtuUHauXirZn]EI[{AHZD<\ngGQ@@dtuUHauXirZn]EI[{AHZD>\ngGQ@@dtuUHauXirZu}`dMB<\ngGQ@@dtuUHauXirZu}`dMB>\ngGQ@@dtuUHauXitVm}`guB<\ngGQ@@dtuUHauXitVm}`guB>\ngGQ@@dtuUHauXitVn]GI[{AOjD>\ngGQ@@dwSTAtYYKVyFulahP\ngGQ@@dwSTAuXirVmtPtH\ngGQ@@dwSTAuXirVm|ndMB\ngGQ@@dwSULauXirVn]EN[hahP>\ngGQ@@dwSULauXirVn]EN[y]HZD<\ngGQ@@eMUTAtpqSdm[eApRFa@\ngGQ@@eMUTAtpqSdm[eApRFaIHx`\ngGQ@@eMUTAtpqSdm[eApRF~@\ngGQ@@eMUTAtpqSdm[eApSz~@\ngGQ@@eMUTAtpqSdm\\dLTynTGAHZD\ngGQ@@eMUTAtpqSdm\\dLTynU{AHZD\ngGQ@@eMUTAtpqSdm\\xLRwJC`dM|\ngGQ@@eMUTAtpqSdm\\xLRwJ}`dM|\ngGQ@@eMUTAtpqSdm\\xLTwJC`dMB\ngGQ@@eMUTAtpqSdm\\xLTwJ}`dMB\ngGQ@@eMUTAtpqSdmkeApRFa@\ngGQ@@eMUTAtpqSdmkeApRFaIHx`\ngGQ@@eMUTAtpqSdukeApRFa@\ngGQ@@eMUTAtpqShukeApRFa@\ngGQ@@eMUTAtpqShulxLTwJ}`dMB\ngGQ@@eMUTAtpqUdm[eApRFa@\ngGQ@@eMUTAtpqUdm\\xLRwJC`dM|\ngGQ@@eMUTAtpqUdm\\xLTwJC`dMB\ngGQ@@eMUTAtpqUdulxLTwJC`dMB\ngGQ@@eMUUHatpqSdm\\dLTenU{AH[x>\ngGQ@@eMUUHatpqSdm\\xLTwJC`dM|<\ngGQ@@eMUUHatpqSdm\\xLTwJC`dM|>\ngGQ@@eMUUHatpqSdmlxLTwJC`dMB<\ngGQ@@eMUUHatpqSdmlxLTwJC`dMB>\ngGQ@@eMUUHatpqSdu[eApRF~@<\ngGQ@@eMUUHatpqSdu[eApRF~@>\ngGQ@@eMUUHatpqUdmlxLTwJC`dMB>\ngGQA@NRYjP@zT\\wQw]`=\ngGQA@NRYjP@zT\\wvz]wX=\ngGQA@NRYjP@zT\\ytTeomt{oP\ngGQAAIRYj`@zT\\wvB]wX+\ngGQAAIRYjf@zlTyK[Nbdm}`gmB>\ngGQBBGBNB\\LxYIIZj@zpRunYy^wjD\ngGQDHGBnBUSUPGUCENRwJC`dM|\ngGQDHGBnBUSUPGUCENRwJC`gu|\ngGQDHGBnBUSUPGUCENRypXenTGAH[x\ngGQDHGBnBUSUPGUCENSWJC`dM|\ngGQDHGBnBUSUPGUCEVcWJC`dM|\ngGQDJ@aABSWUPGVcdmxP`\ngGQDJIARBSWUPGVcdmx_@\ngGQDJIARBSWUPGVcdn\\gI[p~@\ngGQDLOA^FQRFj`NmDm[x^WjD\ngGQHAJAIfj@CiQs_XIw]`+\ngGQHAJAIfj@CiQs_XI{^`+\ngGQHAJAIfj@CiQu_XIw^`>\ngGQHAJAIfj@CiQu_XI{^`+\ngGQHAJAIfj@CiQugQRV~pSn}@>\ngGQHAJAIfj@CiQugQSf~pSv}@>\ngGQHAJAIfjXCjqShmk{AOZD>\ngGQHAJAIfjhCjqSdm[{AHZD>\ngGQHAjAInfhChrrZurMkYCP`\ngGQHB@aIfiXChqSfn]EI[k]hP\ngGQHB@aIfiXChqSfuyP`\ngGQHB@aIfiXChqSfv]EI[k]hP\ngGQHB@aIfiXCkRSV~F}na@\ngGQHB@aIfiXCkRSV~F}va@\ngGQHB@aIfiXCkRSWNbdm|M{mB\ngGQHB@aIfiXCkRSZ~F}na@\ngGQHB@aIfiXCkRSZ~F}va@\ngGQHB@aIfiXCkRS[Nbdm|M{mB\ngGQHB@aIfidCiRU\\c^v]wX\ngGQHB@aIfjiQJChqSjn\\FI[kAhP>\ngGQHB@aInfjZCkRsV~Fuva@<\ngGQHBGAIfiXChqSfn]EI[h^hP\ngGQHBHaIfiXChqSfn]EI[k]hP\ngGQHBHaIfiXChqSfn]EI[k]o`\ngGQHBHaIfiXChqSfn]EI[ra@\ngGQHBHaIfiXChqSfv]EI[k]hP\ngGQHBHaIfjiQIChqSfmu`tH<\ngGQHBHaIfjiQJChqSfmu`tH>\ngGQHBHaIfjiQJChqSfn]EI[kAhP<\ngGQHBHaIfjiQJChqSfn]EI[kAhP>\ngGQHBIAIfiXChqSfn]EI[k]hP\ngGQHBIAIfjiQIChqSfnSENRwVCP`>\ngGQHBIAIfjiQIChqSfn]EI[kAhP>\ngGQHBIAIfjiQJChqSfn]EI[kAhP<\ngGQHBIAIfjiQJChqSfn]EI[kAhP>\ngGQHBJqIfiXChqSfn]EI[k]hP\ngGQHBJqIfiXChqSfn]EI[ra@\ngGQHBJqIfjiQJChqSfn]EI[kAhP<\ngGQHBLQIfiXChqSfn]EI[k]hP\ngGQHBLQIfiXChqSfn]EI[ra@\ngGQHBLQIfiXChqSfv]EI[k]hP\ngGQHBLQIfjZQChqSfuu`tH<\ngGQHBLQIfjZQChqSfuu`tH>\ngGQHBLQIfjiQIChqSfmu`tH>\ngGQHBLQIfjiQJChqSfmu`tH>\ngGQHBLQInfjZChqSfn]EI[ra@>\ngGQHD@aInZ@CjQshiK]G]z\ngGQHD@aInf@CjQncn{@=\ngGQHD@aInfhChqrVmtPtH\ngGQHDHaInf@CjQncn{@=\ngGQHDOAIijjQCjqSdm\\dLTenQ{AH[x<\ngGQHDOAIijjQCjqSdm\\dLTeolDao`<\ngGQHDOAIkjjQChqrVnRFJRwQC_@<\ngGQHDOAIkjjQChqrVnRFJRwp|Pwp<\ngGQHDOAInf@CjQncn{@=\ngGQHDOAInjBQCjQoax{np+\ngGQHDOAInjBQCjQoax{np-\ngGQHH@aJnZBACiAs_XIw]`+\ngGQHH@aJnZBACiAs_XIw]`-\ngGQHH@aJnZBACiAs_XIw^`>\ngGQHH@aJnZBACiAs_[qw]`-\ngGQHH@aJnZBACiAu_XIw]`+\ngGQHH@aJnZBACiAu_XIw]`-\ngGQHH@aJnZBACiAu_XIw^`<\ngGQHH@aJnZBACiAu_XIw^`>\ngGQHH@aJnZBACiAugQRV~pSn}@<\ngGQHH@aJnZBACiAugQRV~pSn}@>\ngGQHH@aJnZZACkAUf~pSv}@<\ngGQHH@aJnZZACkAUf~pSv}@>\ngGQHH@aJnZZACkAUj~pSv}@<\ngGQHH@aJnZZACkAUj~pSv}@>\ngGQHH@aJnZjACjaShm[{AHZD>\ngGQHHDQJnZ@CiAu_XIw^`>\ngGQHHGAIZjhCjqSdm[d^pRFa@\ngGQHHGAIZjhCjqSdm[d^pRF~@\ngGQHHGAIZjhCjqSdm\\xLTwH}`dMB\ngGQHHGAIZjhCjqSdmkd^pRFa@\ngGQHHGAIZjhCjqSdukd^pRFa@\ngGQHHGAJijhCiabgIZwJC`dMB\ngGQHHGAJijhCiabgIZwJC`dM|\ngGQHHGAJijhCiabgIZwJC`guB\ngGQHHGAJijhCiabgIZwJC`gu|\ngGQHHGAJijhCiabgI[WJC`dMB\ngGQHHGAJijhCiabgI[WJC`guB\ngGQHHGAJijhCiabkQZwJC`guB\ngGQHHGAJijhCiabkQ[WJC`guB\ngGQHHGAJijhCiabkQjwJC`dMB\ngGQHHGAJkjdCjaSdm[kAHP\ngGQHHGAJkjhCjaSdm[{AHZD\ngGQHHOAJkZhCjaSdm[{AHZD\ngGQHHOAJkZhCjaShu[{AHZD\ngGQHHOAJkZhCjaShuk{AHZD\ngGQHJGAJijhCjabgI[yApRD\ngGQH`jBRnRnjj@zXXitZus@xICP`\ngGQI@jA\\e]UTAtpqSdukfApRFa@\ngGQI@jA\\e]UTAtpqSdulxLTwLC`dMB\ngGQI@jA\\e]UTAtpqShukfApRFa@\ngGQIAJB\\dsU@AthzolD}oP+\ngGQIAJB\\dtuTAuXirVm}`dMB\ngGQIAJB\\dtuTAuXitZn\\FI[{AHZD\ngGQIB@`|dsTrAuiIkgQRV~F}v}@\ngGQIHBpReWU@At`zolD{oP>\ngGQIHO@ReUuTAuPirVm}`dMB\ngGQIJO@ReTuTAuPqSdm|`xIB\ngGQLBIARFdLbdMU@]ZIZweB\ngGQLBIARFdLbdMU@]ZI[WeB\ngGQLJHaQFbLbdMU@]JIP\ngGQLJIARFdLbdMU@]JIP\ngGQLL@b^BBDfmjiDNcGIjwQCP`<\ngGQ`@ZdsMTAuhisdqSdmy``\ngGQ`@ZdwSTAtiYnam[@\ngGQ`@bdwMLAuhyk^TH\ngGQ`@bdwMLAuhym^TH\ngGQ`@bdwMRAthzncn{@\ngGQ`@bdwMRAthzncn}@\ngGQ`@bdwMRAuhyj\ngGQ`@bdwMRAuhyk^Wh\ngGQ`@bdwMUMAuhyk^TH<\ngGQ`@bdwMUMAuhyk^TH>\ngGQ`@bdwMUMAuhyk^Wp<\ngGQ`@bdwMUMAuhyk^Wp>\ngGQ`@bdwMUMAuhykgQSf|hP<\ngGQ`@bdwMUMAuhykgQSf|hP>\ngGQ`@bdwMUMAuhym^TH<\ngGQ`@bdwMUMAuhym^TH>\ngGQ`@bdwUThlauhykgARV|hP<\ngGQ`@bdwUThlauhykgARV|hP>\ngGQ`@bdwUThmAuhykgARV|hP<\ngGQ`@bdwUThmAuhykgARV|hP>\ngGQ`@bdwUThmAuhykgARV|o`<\ngGQ`@bdwUUMAuhykdabdmyP`<\ngGQ`@bdwUUMAuhykdabdmyP`>\ngGQ`@jduuTAuhyK^DH\ngGQ`@jduuTAuhyKgIrV|HP\ngGQ`@jduuTAuhyM^DH\ngGQ`ALe]UTAtPiKVzHZD\ngGQ`ALe]UTAtPiKWNCEMtPtH\ngGQ`ALe]UUDatPiKWICEN[hahP<\ngGQ`AbeMUTAtPqSVzPZD\ngGQ`AbeMUTAtPqSWICEN[iAhP\ngGQ`AbeMUTAtPqS[ICEN[iAhP\ngGQa@bnR[fjf`zt\\uoJD<\ngGQa@bnR[fjf`zt\\uoJD>\ngGQa@bnR[fjf`zt\\voJD<\ngGQa@bnR[fjf`zt\\voJD>\ngGQdEb@b^BSRuPGVbfmyP`\ngGQdEb@b^BSRuPGVbfuyP`\ngGQdEbGBNBUWUPGVBfmuOTH\ngGQdHl@btFRREZ`NlGI[h~o`\ngGQdHlGBnBUSUPGVCDmtPwp\ngGQdHlGBnBUSUPGVCDmt_Wp\ngGQdHlGBnBUSUPGVCDutPwp\ngGQdHlGBtBUSUPGVCDuxP`\ngGQdHlOB~BUVuTBGVBdutPwp>\ngGQdHlOB~BUVuTBGVBdv]EI[hao`<\ngGQdHlOB~BUVuTBGVBdv]EI[hao`>\ngGQdIbBqNBRuUPGVbfmtOWp\ngGQdLZ@a^BRuSPGRbf|G`\ngGQdhlOBt@f|eTuTAu`qM]DM|\ngGQdibOAT@e\\dmUTAuhim]CuB\ngGQeEb@bN@yIijhCkQSV|o`\ngGQeEb@bN@yIijhCkQSZ|hP\ngGQhHl@cIIBmPGQCdm[hahP\ngGQhHl@cIIBmPGQCdm[h~hP\ngGQhHl@cIIBmPGQCdmkhahP\ngGQhHl@cIIBmPGQCdmkh~hP\ngGQhHl@cIIBmPGQCdu[hahP\ngGQhHl@cIIBmPGQCdukhahP\ngGQhHl@cIIJmPGVBVmy_@\ngGQhHlBqJijhChabZv\\GI[hah_rTJH\ngGQhHlGAJijhChabVmtPtH\ngGQhHlGAJijhChabVmtPwp\ngGQhHlGCIIKUHGVBVh\ngGQhHlGCIIKUPGVBVmyP`\ngGQhHlOAJkZjAChaRVmtPtH<\ngGQhHlOAJkZjAChaRVmtPtH>\ngGQhHlOAJkZjAChaRVmt_TH<\ngGQhHlOAJkZjAChaRVmt_TH>\ngGQhHlOAJkZjAChaRVn]EI[hahP<\ngGQhHlOAJkZjAChaRVn]EI[hahP>\ngGQhHlOAJkZjAChaRVn]EI[h~hP<\ngGQhHlOAJkZjAChaRVn]EI[h~hP>\ngGQhHlOAJkZjAChaRVutPtH<\ngGQhHlOAJkZjAChaRVutPtH>\ngGQhHlOAJkZjAChaRZmtPtH<\ngGQhHlOAJkZjAChaRZmtPtH>\ngGQhHlOAJkZjAChaRZutPtH<\ngGQhHlOAJkZjAChaRZutPtH>\ngGQhHlOCIIJuHGVBVmy^`\ngGQhHlOCIIJuPGVBVmyP`\ngGQhHlOCIIJuPGVBVuyP`\ngGQiAbjA\\e]UTAtPqSZz`ZD\ngGQiHl@c]ddeVhCkAKV|hP\ngGQiHl@c]ddeVhCkAKV|o`\ngGQiHlOC]ddeZjACkAKV|hP<\ngGQiHlOC]ddeZjACkAKV|hP>\ngGR@@cTfxH@MrMkYw]`=\ngGR@@cTfyi`NeKUrMkYw]`\ngGR@@cTfyi`NeKUrMkYw^`\ngGR@@cTfyi`NeKUrMkiw^`\ngGR@@cTfzj`NeGNZFJ\\e@\ngGR@@lTfYj`NeEUt]wo{Q@\ngGR@@lTfYj`NeIUrM{Yw^mD\ngGR@@lTfxJ`NijyFul{nvf@=\ngGR@@lTfxJ`NijyFul{o_vf@=\ngGR@@m\\bdMU@]JIP\ngGR@ACTjzj`NdIMuM{_{P@\ngGR@ACTjzj`NdIMuM{o{P@\ngGRA@l]rSLuPGRdjyF}l{o_vb@\ngGRD@cYPZ`R[jj@zT\\`\ngGRDHlQxWpRjYi@zPXmH\ngGREHlQxWpTiULtpH]HL\\xJRmH<\ngGREHlQxWpTiULtpH]HL\\xJRmH>\ngGREHlQxWpWIU[U@]HJ\\xLRwe}~tP\ngGREIcQxKpTiKSU@]JJ\\xLTmH\ngGRHHlQxIU[U@]XJZweC~tP\ngGRHHlQxYIHPj@zVZwtvmtO{S@\ngGRHHlQxYIHPj@zVZwtvmww{S@\ngGRHHlQxYIHPj@zVZyr\\eoim[h_vf@\ngGRHHlQxYIHPj@zV[WtvmtO{S@\ngGRIHlQxBTjfj`NlFM[ra@\ngGRIHlQxRTjmj`NlEM[raZH\ngGT@@TfX`@MrM{Yw]`\ngGT@@TfX`@MrM{Yw^`\ngGT@@TfX`@MrM{Y{]`\ngGT@@TfX`@MrM{iw^`\ngGT@@TfX`@N]EI[d[wSn}@\ngGT@@TfXa`NdfmrM{Y{P`\ngGT@@TfXa`Ndfm|M{]B\ngGT@@TfXa`NdfurM{Y{P`\ngGT@@TfXa`Ndfu|M{]B\ngGT@@TfXbPNdfmtM{X\ngGT@@TfXbPNdfm|M{]z\ngGT@@TfXbPNhjyF}l{np\ngGT@@TfXbPNhjyF}l{oP\ngGT@@TfXbPNhjyF}l}np\ngGT@@TfXbPNhjyF}t{np\ngGT@@TfXbPNhjyF}t{oP\ngGT@@TfXbPNhkNbdmrM{iw^`\ngGT@@TfYh@NiJyF}l{np\ngGT@@TfYh@NiJyF}t{np\ngGT@@TfYi`NcENZwVCP`\ngGT@@TfYi`NcENkWH{`gmB\ngGT@@TfYjPNcENZytTeoLD\ngGT@@TfYjPNmEV[{AN{l\ngGT@@TfYjPNmEV[{AN{t\ngGT@@TfZfPNeIUrM{Yw]`\ngGT@@TfZfPNeIUrM{Yw^`\ngGT@@TfZfPNeIUrM{Y{]`\ngGT@@TfZfPNeIUrM{iw^`\ngGT@@TfZfPNeIUrN{Y{]`\ngGT@@TfZfPNeIUrN{i{^`\ngGT@@TfZjeDdNcENZwVCP`\ngGT@@TfZjeDdNcENZytTenlFa@\ngGT@@TfZjeDdNcEN[WVCP`<\ngGT@@TfZjeDdNcEN[YtTynlFa@>\ngGT@@TfZjeDdNcENkWVCP`\ngGT@@TfZjeDhNcENZwVCP`<\ngGT@@TfZjeDhNcENZwVCP`>\ngGT@@TfZjeDhNcENZyhXirVzpZD<\ngGT@@TfZjeDhNcENZytTenlFa@<\ngGT@@TfZjeDhNcENZytTenlFa@>\ngGT@@TfZjeDhNcEN[WVCP`<\ngGT@@TfZjeDhNcEN[WVCP`>\ngGT@@TfZjeDhNcEN[YpXynlFa@>\ngGT@@TfZjeDhNcENkWVCP`<\ngGT@@TfZjeDhNcENkWVCP`>\ngGT@@TfZjeDhNcENkYpXynlFa@>\ngGT@@TfxJihNefm|Mk]B<\ngGT@@TfxJihNefm|Mk]B>\ngGT@@TfxJihNefm|Mk]|>\ngGT@@TfzZihNmKM\\zJ\\wpvntH<\ngGT@@TfzZihNmKM\\zJ\\wpvntH>\ngGT@@TfzZihNmKM\\zJ\\wpzntH>\ngGT@@TfzZihNmKMlzJ\\wpvntH<\ngGT@@TfzZihNmKMlzJ\\wpvntH>\ngGT@@TjZjPNbFR\\wJC`g]z=\ngGT@@TjZjPNbFR\\wJC`gmz=\ngGT@@TjZjPNbFR\\ypXenTGAN{w}h@\ngGT@@TjZjPNbFR\\ypXenTGAO[t\ngGT@@TjZjPNbFR\\ypXenTGAO[w}h@\ngGT@@TjZjPNjFJ\\undGAZ@=\ngGT@@TjZjPNjFJ\\uodGAo_v`@=\ngGT@@TjZjPNjFJ\\usPqSdm|`xM{~t@=\ngGT@@TjZjPNjFJ\\us`qK]HNC~t@\ngGT@@TjZjPNjFJ\\us`qK_HNC^m@\ngGT@@TjZjPNjFJ]Us`is_HNC^m@\ngGT@@TjZjPNjFJ]Us`qK_HNC^m@\ngGT@@TjZjdEDNjFJ\\vs`qs_HNCP`<\ngGT@@TjZjiDNjFJ\\uodGAh_v`@+\ngGT@@TjZjiDNjFJ\\urPqrV~P\\FaZ@<\ngGT@@TjZjiDNjFJ\\usPqSdm|`xMB<\ngGT@@TjZjiDNjFJ\\usPqSdm|`xMB>\ngGT@@TjZjiDNjFJ\\usPqSdm|`xMC~t@-\ngGT@@TjZjiDNjFJ\\us`qK_HNC__m@<\ngGT@@TjZjiDNjFJ\\us`qK_HNC__m@>\ngGT@@TjZjiDNjFJ\\us`qs_HNCPm@>\ngGT@@TjZjiDNjFJ\\vodGAhP>\ngGT@@TjZjiDNjFJ\\vrPqSf~P\\Fa@<\ngGT@@TjZjiDNjFJ\\vrPqSf~P\\Fa@>\ngGT@@TjZjiDNjFJ\\vs`qs_HNCPm@<\ngGT@@TjZjiDNjFJ]Vs`qs_HNCPm@<\ngGT@@TjZjiDNjFJ]Vs`qs_HNCPm@>\ngGT@@TjZjiDNlJM\\xJRwrwntO{P@<\ngGT@@TjZjiDNlJM\\xJRwrwntO{P@>\ngGT@@TjZjiDNlJMlxL\\wr{ntO{P@<\ngGT@@TjZjiDNlJMlxL\\wr{ntO{P@>\ngGT@@dfXb`NhjyF}l{nvb@=\ngGT@@dfXb`NhjyF}l{o_vb@\ngGT@@dfXb`NhjyF}l}o_vb@=\ngGT@@dfXb`NhjyF}t{nvb@=\ngGT@@dfXb`NhjyF}t{o_vb@\ngGT@@dfXb`Nldm[d[vrFaZH=\ngGT@@dfXb`Nldm[d[wRFa@\ngGT@@dfXb`Nldm[d[wRFaZH=\ngGT@@dfXb`Nldm\\zJ\\wHwndMC~tP\ngGT@@dfXb`Nldmkd[vrFaZH\ngGT@@dfXb`Nldmkd[wRFaZH\ngGT@@dfXb`Nldukd[vrFaZH=\ngGT@@dfXb`Nldukd[wRFaZH=\ngGT@@dfXbhdNldm\\zJ\\wHwndMB<\ngGT@@dfXbhdNldmlzJRwHwndMB<\ngGT@@dfXbhdNldmlzJRwHwndMB>\ngGT@@dfYj`NcIIZwHwndMC~tP=\ngGT@@dfYj`NkENRuolDah_vb@=\ngGT@@dfYj`NkENRuomxah_rPJMh`=\ngGT@@dfYj`NkENRusPqSdm}`dMC~tP=\ngGT@@dfYj`NkENRus`qs_XICPmD\ngGT@@dfYj`NkENRushis_XICPmD\ngGT@@dfYj`NkENRvs`qs_XICPmD\ngGT@@dfYj`NkENRvshiK_XICPmD\ngGT@@dfYj`NkENRvshiK_[qCPmD\ngGT@@dfYj`NkENRvshis_XICPmD\ngGT@@dfYj`NkENbuolDah_vb@=\ngGT@@dfYj`NkENbusPqSdm}`dMC~tP=\ngGT@@dfYj`NkENbus`qs_XICPmD\ngGT@@dfYj`NkENbvs`qs_XICPmD\ngGT@@dfnjPNcGIZyr\\eoBD\ngGT@@dfnj`NcGIZwQCP`\ngGT@@dfnj`NcGIZyHXiK]DMB\ngGT@@dfnj`NcGIZyr\\enbFa@\ngGT@@dfnj`NcGI[WQCP`\ngGT@@dfxH@MrMkYw]`=\ngGT@@dfxH@MrMkYw^`=\ngGT@@dfxH@MrMkY{^`=\ngGT@@dfyh@NiFzN{l=\ngGT@@dfyh@NiFzN{t\ngGT@@dfyh@NiFzO[t=\ngGT@@dfyh@NiF~GSn{@=\ngGT@@dfyh@NiF~GSn{I@p`=\ngGT@@dfyh@NiF~GSn}@\ngGT@@dfyh@NiGNBdmt]wh\ngGT@@dfyh@NiGNbdmt]wh\ngGT@@dfyh@NiJyFul{np=\ngGT@@dfyh@NiJyFul{oP\ngGT@@dfyh@NiJyFul}oP=\ngGT@@dfyh@NiJyFut{np=\ngGT@@dfyh@NiJyFut{oP\ngGT@@dfyh@NiJyFut}oP=\ngGT@@dfyh@NiKNbdmrMkiw^`\ngGT@@dfyi`NcGIZytTyncva@\ngGT@@dfyi`NeGV\\EN[h}np\ngGT@@dfyi`NeKUrMkiw^`\ngGT@@dfyj`NcGIZwQCP`\ngGT@@dfyj`NcKIZwHvndMB\ngGT@@dfyjidNcGI[WQCP`<\ngGT@@dfzh@NiFzN{l=\ngGT@@dfzh@NiFzN{t\ngGT@@dfzhIDNiGNBdmt]wh<\ngGT@@dfzhIDNiGNBdmt]wh>\ngGT@@dfzi`NeGUt]wh\ngGT@ADjZj`NbJIZwJ{ndMC~t@=\ngGT@ADjZj`NfFJ\\ek\\hNBPtO{HP=\ngGT@ADjZj`NfFJ\\ekgAcfyP\\Dah_vP`\ngGT@ADjZj`NfFJ\\em\\hNBPtO{HP=\ngGT@ADjZjiDNfFJ\\ekgAcfyP\\Dah_v`@<\ngGT@ADjzh@NdGM}`g]w~t@=\ngGT@ADjzh@NdGM}`g]{~t@\ngGT@ADjzh@NdGM}`gm{~t@=\ngGT@ADjzh@NdGM}oG]w~t@=\ngGT@ADjzh@NdGU}`g]w~t@=\ngGT@ADjzh@NhJyf}l{nv`@=\ngGT@ADjzh@NhJyf}l{o_v`@\ngGT@ADjzh@NhJyf}l}o_v`@=\ngGT@ADjzh@NhJyf}t{nv`@=\ngGT@ADjzh@NhJyf}t{o_v`@\ngGT@ADjzh@NhJyf}t}o_v`@=\ngGT@ADjzh@NhKNbdmsM{iw^m@\ngGT@ADjzi`NbIIZwLwmgmC~t@\ngGT@ADjzi`NbIIZwtwmtO{P@\ngGT@ADjzi`NjENRushis_XI{Pm@\ngGT@ADjzj`NbIIZwLwmdMC~t@\ngGT@ADjzj`NbIIZwLwndMC~t@\ngGT@ADjzj`NjENRuolDah_v`@\ngGT@ADjzj`NjENRurPqrV~pRFaZ@\ngGT@ADjzjdDhNjENRus`qs_XICP`<\ngGT@ADjzjhdNbII[WLwndMC~t@>\ngGT@ADjzjhdNbII[YtTynYo]HZG}h@>\ngGT@ADjzjhdNjENRurPqrV~pRF~Z@<\ngGT@ADjzjhdNjENRurPqrV~pRF~Z@>\ngGT@ADjzjhdNjENRus`qs_XICPm@<\ngGT@ADjzjhdNjENRus`qs_XICPm@>\ngGT@ADjzjhdNjENRvolDah_v`@<\ngGT@ADjzjhdNjENRvolDah_v`@>\ngGT@ADjzjhdNjENRvshis_XICPm@<\ngGT@ADjzjhdNjENRvshis_XICPm@>\ngGT@ADkij`NjENRuolDah_v`@\ngGT@ATeVn`NeDh\ngGT@ATffj`NcENRwVBP`\ngGT@ATffj`NcENRyLTyK]XIB\ngGT@ATffjiDNcENRytTenlDa@<\ngGT@ATffjiDNcENRytTenlDa@>\ngGT@Adijj`NjFJRuodDah_v`@\ngGT@Adijj`NjFJRus`qS_HICPm@\ngGT@Adijj`NjFJbus`qS_HICPm@\ngGT@`QIeIfH@C\\c^v]wX\ngGT@`QIeIfH@CgAcfyG]l}np\ngGT@`QIeIfjiQJChqSfn]EI[kAhP<\ngGT@`QIeIfjiQJChqSjuu`tH<\ngGT@`QIeIfjiQJChqSjuu`tH>\ngGT@`aJyInZ@CjRnQu[N{l=\ngGT@aAteJzjhCjaSdm[{AHZG}h@\ngGTA@QJSLP@FyF}l{np\ngGTA@QJSLP@FyF}l{oP\ngGTA@QJSLPpGRSV~F}na@\ngGTA@QJSLuHGVbkM}`g]v\ngGTA@QJSLuHGVbkV]EN[{AO[l\ngGTA@QJSMURbTGQbgM\\zJRwVCP`<\ngGTA@aJSLuPGUbgIZwH{`dMC~tP=\ngGTA@aJSLuPGUbgIZyhXirV~pRFaZH=\ngGTA@aJS\\D@FyFul{np=\ngGTA@aJS\\t@GTc]G]v=\ngGTA@aJS\\t@GTc]G]z\ngGTA@aJS\\t@GTc_Ciw]`=\ngGTA@aJS\\t@GTc_Ciw]d`XP=\ngGTA@aJS\\t@GTe\\cZv]wX=\ngGTA@aJS\\t@GTe\\cjz]wX=\ngGTA@erS\\t@GTe\\cZv]wX=\ngGTAAAJU\\t@GTE\\s^z^wo{P@=\ngGTAAAJU]R@GTE\\s^v]w_{P@=\ngGTAAAJU]R@GTE\\s^z]w_{P@=\ngGTAAIJTuMPGSCENRus`qS\\knBPtO{P@\ngGTAAQJSSUPGQbgI[kAHP\ngGTAAQJUSUPGUCENRyHXiK_HNBP`\ngGTBLQDSpTQ_AIkjTCiQs~tp\ngGTCLQDSpTQ_@}dTaihCiQKgIrV|oova@\ngGTD@UPZ`Rkjj@zHYImgQSfz`ZG}h@>\ngGTD@]PV`rRFUTAtPqSfz`TD>\ngGTDCPDZ`R[ij@zTlwPvm`\ngGTDEPDDHR[ff@zT\\`\ngGTDEPDDHR[ii@zTmWHvmg]v\ngGTDEaxSpRkjj`PzHTek]DMB<\ngGTDEaxSpRkjj`PzHTek]DMB>\ngGTDQMPV`Dr]uyJffXChabdnZFJ\\enmz~YB@\ngGTDcPDHHWFTfyi`NeGUt^wh\ngGTEIaxKpTiKSU@]FJSVs`qS]DMC~t`\ngGTH@]PYICJj@zhXisV~`TFa@>\ngGTH@]PYICJj@zhXisZ~`TFa@>\ngGTH@iPIMuP@]RMt]wX=\ngGTH@iPIMuP@]RMt^wh=\ngGTHAMPIUuP@]PMt]w_{P@=\ngGTHAMPIUuP@]PM}oG]w~t@=\ngGTHCPDILsS@]ZJ\\ytTenlD}@\ngGTHCPDILuH@]RUrM{Yw]`=\ngGTHCPDILuK@]JR[h[vp\ngGTHCPDILuK@]JRkd[vsn{@\ngGTHCPDILuK@]JRkd[vsn}@\ngGTHCQHILuK@]ZJ\\ytTy@\ngGTHCQxITuS@]DLeZnTGAN{t\ngGTHDPDIMtp@]RUrMkYw]`\ngGTHDPDIMtuSP]ZVZwpvmtH>\ngGTHE`DILsU@]FJRunbFaZH=\ngGTHE`DILsU@]FJRushis]DMC~tP\ngGTHE`DILsU@]FJRvnbFaZH\ngGTHE`DILsU@]FJRvshis]DMC~tP\ngGTHE`DIMtu@]FNRunbFaZX=\ngGTHE`DIMtu@]FNRushis]DMC~tp\ngGTHE`DIMtu@]FVRunQm[HZG}i`=\ngGTHHPxILuS@]FJ\\voa{Ah_vd@\ngGTHHPxILuS@]FJ\\voa{^h_vd@\ngGTHHaxITuUPH]TL]Ek_XICP`<\ngGTHHaxITuUPH]TL]Ek_XICP`>\ngGTHHaxYICJ`@z`[h{np=\ngGTH`iPBYrSWUTbGQcdm[hahP<\ngGTH`iPBYrSWUTbGQcdm[hahP>\ngGTHaMPB]rU\\t@GTC_[qw]m@=\ngGTHdPDCeJS]L@GTc]G]v\ngGTHe`DCeJS]MPGQcdm\\zJ\\wQCPmL\ngGTHe`DCeJS]MPGQcdmlzJ\\wQCPmL\ngGTICQHFTfZe`NmEN\\zJR`\ngGTICQxFTjZi`NbFRmWJC`gmz\ngGT`CPdfyi`NeGH\ngGT`CPdfyj`NeGH\ngGT`EPTfyi`NeGH\ngGT`EPTfyi`NeGN]EIP\ngGT`EPTfzZPNeKUrMkYw]`\ngGT`E`TfYjhhNmEM[ra@<\ngGT`LPdfyj`NmGM[raZX\ngGT`LPdfyj`NmGM[r~ZX\ngGT`LPdfyj`NmGMkraZX\ngGT`hPiJyInZ@CjQncn}ZP\ngGT`hPiJyInZXCiQu]G]w~t`\ngGT`hPiJyInZXCiQu]G]{~t`\ngGT`hPiJyInZdCiQu]G]w~t`\ngGT`hPiJyInZdCiQu]G]{~t`\ngGT`hPiJyInZdCiQu]Gmw~t`\ngGT`hPiJyInZdCiQu]Gm{~t`\ngGT`hPiJyInZdCkQsV|o_vd@\ngGT`hPiJyInZjYCkQsZ|h_vd@<\ngGT`hPiJyInZjYCkQsZ|h_vd@>\ngGT`i`iJyInZhChqrVmtPtO{JX=\ngGT`i`iJyInZhChqrVutPtO{JX\ngGTahPiJx|dwMRAthzncn}ZP\ngGTdLXaxWpRjvj@zPTwe|\ngGTdlX`DTHwF\\ddJu@]HN[h~oovf@\ngGTeI\\QxKpTiKSU@]JJ\\xLRmH\ngGTeLXaxWpOYIIZZ@zPRyr\\eoK{}hP\ngGThLX`DYIHUj@zp\\uoJG}i`\ngGThLX`DYIHUj@zp\\voJG}i`\ngGThLXaxIUMA@]JM[{[NzD\ngGThLXaxIUMA@]JM\\xLRwvv]tH\ngGThLXaxIUMA@]JMk{[NzD\ngGThLXaxIUMA@]JMlxLRwvv]tH\ngGThLXaxIU[U@]XJ[WeB\ngGThLXaxIU[U@]XJ[WeC~RQq@\ngGThLXaxYIHVj`Pzp\\voJG}i`<\ngGThLXaxYIHVj`Pzp\\voJG}i`>\ngGThMX`DYIHUj@zp\\foBG}i`\ngGThmX`D[kNRREZ`NlGIkpaZX\ngGTiCQePKdkjj`NlFJ[rA@\ngGTiCQePKdkjjhdNlFR\\xL\\wdB<\ngGTiLXaxGdjffhDNlFMkra@<\ngGTiLXaxGdjffhDNlFMkra@>\ngGU@CPdsMLAuhiu^XH\ngGU@CPdsMLAuhjs_XIw^`\ngGU@CPdsMLAuhju_XIw^`\ngGU@CPdsTlAtiJnQo[N{t\ngGU@DPdsMTAtXisVzpZG}h`\ngGU@DPdsMTAtXisVzp[{}h`\ngGU@DPdsMTAtXisWNbdmu`tO{Q@\ngGU@DPdsMTAtXisWNbgMu`tO{Q@\ngGU@DPdsMTAtXisZzpZG}h`\ngGU@DPdsMTAtXis[NbgMu`tO{Q@\ngGU@DPdsMTAtXiuVzpZG}h`\ngGU@DPdsMTAtXiuVzp[{}h`\ngGU@DPdsMTAtXiuWNbdmu`tO{Q@\ngGU@DPdsMTAtXiuWNbgMu`tO{Q@\ngGU@DPdsMTAtXiu[NbgMu`tO{Q@\ngGU@DPdsMTAuhjs_XIw]mD\ngGU@DPdsMTAuhjs_XIw^mD\ngGU@DPdsMTAuhjsgQRV~pSn}ZH\ngGU@DPdsMTAuhju_XIw^mD\ngGU@DPdsUUHauhjs_XIw]mD<\ngGU@DPdsUUHauhjs_XIw^mD<\ngGU@DPdsUUHauhjs_XIw^mD>\ngGU@DPdwM@AuHwQw]`\ngGU@DPdwM@AuHwQw^`\ngGU@DPdwM@AuHytTencn}@\ngGU@DPdwMLAthzncn{@\ngGU@DPdwMLAthzncn}@\ngGU@DPdwMLAuhyk]GmB\ngGU@DPdwMLAuhyk^TH\ngGU@DPdwMLAuhykgQRVzOZD\ngGU@DPdwMLAuhykgQRV|hP\ngGU@DPdwMLAuhykgQSf|hP\ngGU@DPdwMLAuhym^TH\ngGU@DPdwMLAuhymgQSf|hP\ngGU@DPdwMRAthzncn{@\ngGU@DPdwMRAthzncn}@\ngGU@DPdwMRAthzncv{@\ngGU@DPdwMRAthzncv}@\ngGU@DPdwMRAthzshiK]G]z\ngGU@DPdwMRAthzshiK]Gmz\ngGU@DPdwMRAthzshis]Gmv\ngGU@DPdwMRAuhyj\ngGU@DPdwMRAuhyk^Wh\ngGU@DPdwMRAuhykgQRT\ngGU@DPdwMRAuhykgQRV|oP\ngGU@DPdwMRAuhykgQSd\ngGU@DPdwMUMAuhyk^TH<\ngGU@DPdwMUMAuhyk^TH>\ngGU@DPdwMUMAuhyk^Wp<\ngGU@DPdwMUMAuhyk^Wp>\ngGU@DPdwMUMAuhykgQRV|hP<\ngGU@DPdwMUMAuhykgQRV|hP>\ngGU@DPdwMUMAuhykgQSf|hP<\ngGU@DPdwMUMAuhykgQSf|hP>\ngGU@DPdwMUMAuhym^TH<\ngGU@DPdwMUMAuhym^TH>\ngGU@DPdwS@AuHwQw]`\ngGU@DPdwS@AuIWHvmg]v\ngGU@DPdwSRAtiZnQm[N{t\ngGU@DPdwSUMAuhykgQSf|hP<\ngGU@DPdwSUMAuhykgQSf|hP>\ngGU@E`dsMTAtXiKVzHZG}h`=\ngGU@E`dsMTAtXiKVzH[{}h`\ngGU@E`dsMTAtXiKWNbdmtPww{Q@\ngGU@E`dsMTAtXiKWNbgMtPtO{Q@\ngGU@E`dsMTAtXiKWNbgMtPww{Q@\ngGU@E`dsMTAtXiKZzHZG}h`\ngGU@E`dsMTAtXiK[NbdmtPtO{Q@\ngGU@E`dsMTAtXiK[NbgMtPtO{Q@\ngGU@E`dsMTAtXiMZzHZG}h`=\ngGU@E`dsMTAthjshiK]G]{~tP\ngGU@E`dsMTAthjshis]Gm{~tP\ngGU@E`dwSTAtXyKVzHZG}i`=\ngGU@E`dwSTAtXyKWNbgMtPtO{S@\ngGU@E`dwSTAtXyK[NbgMtPtO{S@\ngGU@LPdmUTAuhik^TH\ngGU@h`NdiMtp@]RMt]w_{R@=\ngGUACPYRYjV@ztTynmt}@\ngGUADPYR[fi@zT]YtTencn}@\ngGUADPYR[fi@zT]YtTencv}@\ngGUADPYR[fjf`zt\\uoJD<\ngGUADPYR[fjf`zt\\uoJD>\ngGUADP^R[fi@zT]WQw^`\ngGUAE`iRYff@zLTekgQSfzOZG}h`\ngGUAE`iR[ij@zL\\ek]DMC~tp=\ngGUAE`iR[ij@zL\\fm]DMC~tp=\ngGUAIQIRZZj@zLTyKdqSdmu`dH\ngGUDLT@b^BSRuPGVbfmyPdd\\P\ngGUDLT@b^BSRuPGVbfuyP`\ngGUDLTHb^BSSPPGRSV~vsna@\ngGUDLTHb^BSSPPGRSZ~vsna@\ngGUHEjICHiCUPGRbT\ngGUHeaZCS^RYfj@ztTfshiK]DM}~tP\ngGX@@dmMTAuXirVm}`dMB\ngGX@@dmUTAuXirVm}`dMB\ngGX@@dmUTAuXirVnRFJ\\wvBPtH\ngGX@@dmUTAuXirVn\\FI[{AH[x\ngGX@@dmUTAuXirVn\\FJ[{AHZD\ngGX@@dmUTAuXirVu}`dMB\ngGX@@dmUTAuXirVv\\FI[{AHZD\ngGX@@dmUTAuXirZu}`dMB\ngGX@@dmUUDauXirVn\\FJ[{AH[x<\ngGX@@dmUUDauXirVn\\FJ[{AH[x>\ngGX@@dmUUDauXirVv\\FJ[{AHZD>\ngGX@@dsD@AnQo[N{l=\ngGX@@dsD@AnQo[N{t\ngGX@@dsD@AnQo[O[t=\ngGX@@dsD@AnQo]N{l=\ngGX@@dsD@AnQo]N{t\ngGX@@dsD@AnQo]O[t=\ngGX@@dsD@AnQw[N{l=\ngGX@@dsD@AnQw]N{l=\ngGX@@dsD@As`qK\\cnv]wh\ngGX@@dsD@AshiK\\c^z]wh\ngGX@@dsD@Ashis\\c^z^wh\ngGX@@dsDLAuEWHwng]z\ngGX@@dsDLAudek\\c^v^tH\ngGX@@dsDLAudek\\cnv^wp\ngGX@@dsDLAudek_C^wP`\ngGX@@dsDLAudem\\c^v^tH\ngGX@@dsDLAudemgAcfyG]l}hP\ngGX@@dsDLAudemgQRVyF}t}hP\ngGX@@dsM@AthynQwAN{l=\ngGX@@dsM@AthynQwAN{t\ngGX@@dsM@AthynQw^N{l=\ngGX@@dsM@AthyolD{np=\ngGX@@dsM@AthyolD{oP\ngGX@@dsM@AthyolD}oP=\ngGX@@dsM@Athyomx{np=\ngGX@@dsM@Athys`qK\\cnB]wh\ngGX@@dsM@Athys`qK_XIw^`\ngGX@@dsM@AthyshiK\\cnB]wh\ngGX@@dsM@AthyshiK_XIw^`\ngGX@@dsM@AthyshiK_[qw^`\ngGX@@dsM@Athyshis_XI{^`\ngGX@@dsM@AthznQwAN{l=\ngGX@@dsM@AthznQwAN{t\ngGX@@dsM@AthzolD{np=\ngGX@@dsM@AthzolD{oP\ngGX@@dsM@Athzs`qK\\cnB]wh\ngGX@@dsM@Athzs`qK_XIw^`\ngGX@@dsM@AthzshiK\\cnB]wh\ngGX@@dsM@AthzshiK_XIw^`\ngGX@@dsM@AuIWHwmg]v=\ngGX@@dsM@AuIWHwmg]z\ngGX@@dsM@AuIWHwmgmz=\ngGX@@dsM@AuIWHwng]v=\ngGX@@dsM@AuIWHwng]z\ngGX@@dsM@AuIWHwngmz=\ngGX@@dsM@AuIYtTenQo]N{t\ngGX@@dsMLAuXirVmu`tH\ngGX@@dsMLAuXirVm}`gmB\ngGX@@dsMLAuXirVn]EN[kAhP\ngGX@@dsMLAuXirVn]EN[{AOZD\ngGX@@dsMLAuXirVn]EN[{^OZD\ngGX@@dsMLAuXirVu}`gmB\ngGX@@dsMLAuXitVmrNxI{P`\ngGX@@dsMLAuXitVn\\FN[kAhP\ngGX@@dsMLAuhjs_XIw^`\ngGX@@dsMTAtYIKVyF}lahP\ngGX@@dsMTAtYIKVyF}tahP\ngGX@@dsMTAtYIM[IbgI[d[wRFa@\ngGX@@dsMTAuXirVmrNxICP`\ngGX@@dsMTAuXirVm}`dMB\ngGX@@dsMTAuXirVnSENRwH{`dMB\ngGX@@dsMTAuXirVnSENRwvBPtH\ngGX@@dsMUDauXirVn]EN[{AHZD<\ngGX@@dsMUDauXirVn]EN[{AHZD>\ngGX@@dsT`Athyncn{@=\ngGX@@dsT`Athyncn}@\ngGX@@dsT`Athyomt{np=\ngGX@@dsT`Athyomt{oP\ngGX@@dsT`Athys`qK]G]z\ngGX@@dsT`Athys`qK_[iw^`\ngGX@@dsT`AthyshiK_[iw^`\ngGX@@dsT`AuIWHwmg]v=\ngGX@@dsT`AuIWHwmg]z\ngGX@@dsT`AuIWHwmgmz=\ngGX@@dsT`AuIWHwng]v=\ngGX@@dsT`AuIWHwng]z\ngGX@@dsT`AuIWHwngmz=\ngGX@@dsT`AuIWH{mg]v=\ngGX@@dsT`AuIWH{mg]z\ngGX@@dsT`AuIWH{ng]v=\ngGX@@dsT`AuIWH{ng]z\ngGX@@dsT`AuIYpXenQw[N{t\ngGX@@dsT`AuIYpXenQw]N{t\ngGX@@dsT`AuIYtTenQo]N{t\ngGX@@dsT`AuIYtTenQw]N{t\ngGX@@dsTlAtYIKVyF}l}hP\ngGX@@dsTlAtYIKVyF}t}o`\ngGX@@dsTlAtYIKV~F}na@\ngGX@@dsTlAtYIKV~F}va@\ngGX@@dsTlAtYIKWNCGMrN{Y{P`\ngGX@@dsTlAtYIKZyF}l}hP\ngGX@@dsTlAtYIKZyF}t}hP\ngGX@@dsTlAtYIKZyG]l}hP\ngGX@@dsTlAtYIK[NCDm|N{]B\ngGX@@dsTlAtYIK[NCDm|N{mB\ngGX@@dsTlAtiJnQo]O[l\ngGX@@dsTlAtiJnQw]N{t\ngGX@@dsUAHathyolD{np+\ngGX@@dsUAHathyolD{np-\ngGX@@dsUAHathyolD{nrPJH+\ngGX@@dsUAHathyolD{nrPJH-\ngGX@@dsUAHathyolD{oP<\ngGX@@dsUAHathyolD{oP>\ngGX@@dsUAHathyolD}oP+\ngGX@@dsUAHathyolD}oP-\ngGX@@dsUAHathyomx{np+\ngGX@@dsUAHathyomx{np-\ngGX@@dsUAHathyomx{nrPJH+\ngGX@@dsUAHathyomx{nrPJH-\ngGX@@dsUAHathyomx{oP<\ngGX@@dsUAHathyomx{oP>\ngGX@@dsUAHathys`qK_XIw^`<\ngGX@@dsUAHathys`qK_XIw^`>\ngGX@@dsUAHathys`qK_[qw^`<\ngGX@@dsUAHathys`qK_[qw^`>\ngGX@@dsUAHathys`qs_XI{^`<\ngGX@@dsUAHathys`qs_XI{^`>\ngGX@@dsUAHathyshiK_XIw^`<\ngGX@@dsUAHathyshiK_XIw^`>\ngGX@@dsUAHathyshiK_[qw^`<\ngGX@@dsUAHathyshiK_[qw^`>\ngGX@@dsUAHathzolD{np+\ngGX@@dsUAHathzolD{np-\ngGX@@dsUAHathzolD{oP<\ngGX@@dsUAHathzolD{oP>\ngGX@@dsUAHathzolD}oP+\ngGX@@dsUAHathzolD}oP-\ngGX@@dsUAHathzs`qK_XIw^`<\ngGX@@dsUAHathzs`qK_XIw^`>\ngGX@@dsUAHathzs`qs_XI{^`<\ngGX@@dsUAHathzs`qs_XI{^`>\ngGX@@dsUMHauXirVmu`tH<\ngGX@@dsUMHauXirVmu`tH>\ngGX@@dsUMHauXirVm}`gmB<\ngGX@@dsUMHauXirVn\\FN[{AOZD<\ngGX@@dsUMHauXirVn\\FN[{AOZD>\ngGX@@dsUMHauXirVv\\FN[{AOZD>\ngGX@@dsUMHauXitVmu`tH>\ngGX@@dsUMHauXitVn\\FN[{AOZD<\ngGX@@dsUMHauXitVn\\FN[{AOZD>\ngGX@@dsUMHauhjs_XIw^`<\ngGX@@dsUMHauhjs_XIw^`>\ngGX@@dsUThdauXirVnRFJ\\wvBPtH>\ngGX@@dsUThdauXirVn\\FN[{AHZD<\ngGX@@dsUThdauXirVn\\FN[{AHZD>\ngGX@@dsUThdauXirVn]EN[{AHZD<\ngGX@@dsUThdauXirVn]EN[{AHZD>\ngGX@@dsUThdauXirVu}`dMB<\ngGX@@dsUThdauXirVu}`dMB>\ngGX@@dsUThdauXirVv]EN[{AHZD<\ngGX@@dsUThdauXirVv]EN[{AHZD>\ngGX@@dsUThdauXirVv]EN[{^HZD<\ngGX@@dsUThdauXitVn\\FN[{AHZD<\ngGX@@dsUThdauXitVn\\FN[{AHZD>\ngGX@@dsUThdauXitVu}`dMB<\ngGX@@dsUThdauXitVu}`dMB>\ngGX@@dsUTheAuXirVnRFJRwvBPwp<\ngGX@@dsUTheAuXirVnRFJRwvBPwp>\ngGX@@dsUTheAuXirVnRFJ\\wvBPtH<\ngGX@@dsUTheAuXirVnRFJ\\wvBPtH>\ngGX@@dsUTheAuXirVn\\FN[{AHZD<\ngGX@@dsUTheAuXirVn\\FN[{AHZD>\ngGX@@dsUTheAuXirVn]EN[{AHZD<\ngGX@@dsUTheAuXirVn]EN[{AHZD>\ngGX@@dsUTheAuXirVu}`dMB<\ngGX@@dsUTheAuXirVu}`dMB>\ngGX@@dsUTheAuXirVvZFJ\\eolDahP>\ngGX@@dsUTheAuXirVv]EI[{AHZD<\ngGX@@dsUTheAuXirVv]EN[{AHZD>\ngGX@@dsUTheAuXirZn]EI[{AH[x<\ngGX@@dsUTheAuXitVv\\FN[{AHZD<\ngGX@@dsUTheAuXitVv\\FN[{AHZD>\ngGX@@dsUTiDauXitVn\\FN[{AHZD<\ngGX@@dsUTiDauXitVn\\FN[{AHZD>\ngGX@@dsUTiDauXitVn]EN[{AHZD<\ngGX@@dsUUHauXirVm}`dMB<\ngGX@@dsUUHauXirVm}`dMB>\ngGX@@dsUUHauXirVm}oDMB<\ngGX@@dsUUHauXirVm}oDMB>\ngGX@@dsUUHauXirVnSENRwvBPtH>\ngGX@@dsUUHauXirVnZFJ\\eolDahP<\ngGX@@dsUUHauXirVnZFJ\\eolDahP>\ngGX@@dsUUHauXirVnZFJ\\eomxahP<\ngGX@@dsUUHauXirZu}`dMB<\ngGX@@dsUUHauXirZu}`dMB>\ngGX@@dsUUHauXitVm}`dMB<\ngGX@@dsUUHauXitVm}`dMB>\ngGX@@dsUUHauXitVnRFNRwvBPtH<\ngGX@@dsUUHauXitVnRFNRwvBPtH>\ngGX@@dtuRAuXirVmu`dH\ngGX@@dtuRAuXirVn\\FI[{AH[t\ngGX@@dtuSHauXirVn]EI[kAHP<\ngGX@@dtuSHauXirVn]EI[kAHP>\ngGX@@dtuSHauXirZn]EI[{AH[t>\ngGX@@dtuTAuXirVm}`dMB\ngGX@@dtuTAuXirVm}`dM|\ngGX@@dtuTAuXirVnSENRwvBPtH\ngGX@@dtuTAuXirVnSENRwvBPwp\ngGX@@dtuTAuXirVn\\FI[{AHZD\ngGX@@dtuTAuXirVn\\FI[{AH[x\ngGX@@dtuTAuXirVu}`dMB\ngGX@@dtuTAuXirVv\\FI[{AHZD\ngGX@@dtuUHauXirVm}`guB<\ngGX@@dtuUHauXirVm}`guB>\ngGX@@dtuUHauXirVnRFJRwvBPtH<\ngGX@@dtuUHauXirVnRFJRwvBPtH>\ngGX@@dtuUHauXirVn]EI[{AHZD<\ngGX@@dtuUHauXirVn]EI[{AHZD>\ngGX@@dtuUHauXirVn]EI[{AOjD<\ngGX@@dtuUHauXirVn]EI[{AOjD>\ngGX@@dtuUHauXirVn]GI[{AOjD<\ngGX@@dtuUHauXirVn]GI[{AOjD>\ngGX@@dtuUHauXirZm}`dMB<\ngGX@@dtuUHauXirZm}`dMB>\ngGX@@dtuUHauXirZn\\FI[{AHZD<\ngGX@@dtuUHauXirZn\\FI[{AHZD>\ngGX@@dtuUHauXirZn]EI[{AHZD<\ngGX@@dtuUHauXirZn]EI[{AHZD>\ngGX@@dwATAulek\\cZvPtH\ngGX@@dwATAulek\\cZvPtOyKDd\ngGX@@dwATAulek\\cZzPtH\ngGX@@dwATAulfm\\cZvPtH\ngGX@@dwAULaulekgQSfyFutahP<\ngGX@@dwAULaulekgQSfyFutahP>\ngGX@@dwAULaulem\\cZvPtH<\ngGX@@dwSTAtYYKVyFutahP\ngGX@@dwSTAtYYKVyGUlahP\ngGX@@dwSTAtYYMZyFulahP\ngGX@@dwSTAtYYMZyFutahP\ngGX@@dwSTAtYYMZyGUlahP\ngGX@@dwSTAuXirVmtPtH\ngGX@@dwSULatYYKWNbgMrMkiCP`<\ngGX@@dwSULatYYKWNbgMrMkiCP`>\ngGX@@dwSULatYYKWNbgMrNkiCP`>\ngGX@@dwSULatYYKZyFulahP<\ngGX@@dwSULatYYKZyFulahP>\ngGX@@dwSULauXirVn\\EN[hahP>\ngGX@@dwSULauXirVv]EN[y]HZD<\ngGX@@eMUTAtpqSdm[eApRFa@\ngGX@@eMUTAtpqSdm[eApRFaIHxv`@\ngGX@@eMUTAtpqSdm[eApRFaZ@\ngGX@@eMUTAtpqSdm[eApRF~Z@\ngGX@@eMUTAtpqSdm\\dLTynTGAHZG}h@\ngGX@@eMUTAtpqSdm\\xLTwJC`dMB\ngGX@@eMUTAtpqSdm\\xLTwJC`dMC~t@\ngGX@@eMUTAtpqSdm\\xLTwJ}`dMB\ngGX@@eMUTAtpqSdmkeApRFa@\ngGX@@eMUTAtpqSdmkeApRFaZ@\ngGX@@eMUTAtpqSdmlxLRwJC`dMC~t@\ngGX@@eMUTAtpqSdukeApRFaZ@\ngGX@@eMUTAtpqSdulxLTwJC`dMC~t@\ngGX@@eMUTAtpqShukeApRFa@\ngGX@@eMUTAtpqShukeApRFaZ@\ngGX@@eMUTAtpqUdm[eApRFa@\ngGX@@eMUTAtpqUdm[eApRFaZ@\ngGX@@eMUTAtpqUdm\\xLTwJC`dMB\ngGX@@eMUTAtpqUdm\\xLTwJC`dMC~t@\ngGX@@eMUTAtpqUdmkeApRFaZ@\ngGX@@eMUUHatpqSdu[eApRF~Z@<\ngGX@@eMUUHatpqSdu[eApRF~Z@>\ngGX@@eSU@AuAWJwmg]w~t@=\ngGX@@eSU@AuAWJwmg]{~t@=\ngGX@@eSU@AuAWJwmgm{~t@=\ngGX@@eSU@AuAWJwng]w~t@=\ngGX@@eSU@AuAWJwng]{~t@\ngGX@@eSU@AuAWJwngm{~t@=\ngGX@@eSU@AuAWJ{ng]w~t@=\ngGX@@eSU@AuAWJ{ng]{~t@=\ngGX@@eSU@AuAWJ{ngm{~t@=\ngGX@@eSU@AuAYpTenUo]N{w}h@\ngGX@@eSU@AuAYpXenUw]N{w}h@\ngGX@@eSU@Au`is\\hNB]w_yJEFt@=\ngGX@@eSU@Au`is\\hNB]w_{P@=\ngGX@@eSU@Au`is\\hNB]wh\ngGX@@eSU@Au`is\\hNB]woyJEFt@=\ngGX@@eSU@Au`is\\hNB]wo{P@=\ngGX@@eSU@Au`is\\hNB^wh=\ngGX@@eSU@Au`is\\hNB^wo{P@=\ngGX@@eSU@Au`is\\hN|]w_yJEFt@=\ngGX@@eSU@Au`is\\hN|]w_{P@=\ngGX@@eSU@Au`is\\hN|]wo{P@\ngGX@@eSU@Au`is\\hN|^wo{P@=\ngGX@@eSU@Au`isfabgI[eApSv}@=\ngGX@@eSU@Au`isfabgI[eApSv}Z@=\ngGX@@eSU@Au`isgARVyP]x{o_v`@\ngGX@@eSU@Au`isgAbVyP\\D{o_v`@\ngGX@@eSU@Au`isgAcfyP\\D}o_v`@\ngGX@@eSU@Au`iu\\hNB]w_{P@=\ngGX@@eSU@Au`iu\\hNB]wo{P@\ngGX@@eSU@Au`iu\\hNB^wo{P@=\ngGX@@eSU@Au`iugARVyP\\D{o_v`@\ngGX@@eSU@Au`iugAbVyP\\D{o_v`@\ngGX@@eSU@Au`js\\hN|]w_{P@=\ngGX@@eSU@Au`ju\\hNB]w_{P@=\ngGX@@eSU@Au`ju\\hNB]wh\ngGX@@eSU@Au`ju\\hNB]wo{P@=\ngGX@@eSU@Au`ju\\hNB^wh=\ngGX@@eSU@Au`ju\\hNB^wo{P@=\ngGX@@eSU@Au`jufabgI[eApSv}@=\ngGX@@eSU@Au`jugAbVyP\\D{o_v`@\ngGX@@eSU@Au`jugAcfyP\\D}o_v`@\ngGX@@eSUA@au`is\\hN|^wh-\ngGX@@eSUA@au`isgARVyP]x{oP<\ngGX@@eSUA@au`isgARVyP]x{oP>\ngGX@@eSUA@au`isgAbVyP\\D{oP<\ngGX@@eSUA@au`isgAbVyP\\D{oP>\ngGX@@eSUA@au`isgAcfyP\\D}oP<\ngGX@@eSUA@au`isgAcfyP\\D}oP>\ngGX@@eSUA@au`iugARVyP\\D{oP<\ngGX@@eSUA@au`iugARVyP\\D{oP>\ngGX@@eSUA@au`iugASfyP\\D}oP<\ngGX@@eSUA@au`iugASfyP\\D}oP>\ngGX@@eSUA@au`jugAbVyP\\D{oP<\ngGX@@eSUA@au`jugAbVyP\\D{oP>\ngGX@@eSULAtPrSfyP\\D}o_v`@=\ngGX@@eSULAtaRnUw]N{w}h@=\ngGX@@eSULAtpqSdm[eApSvaZ@=\ngGX@@eSULAtpqSdm[yApZG}h@=\ngGX@@eSULAtpqSdm[yAwjG}h@\ngGX@@eSULAtpqSdm\\dLTenTGAOZG}h@=\ngGX@@eSULAtpqSdm\\tLTyK_HNCPm@=\ngGX@@eSULAtpqSdm\\xLRwJC`gmC~t@\ngGX@@eSULAtpqSdm\\xLRwrC`tO{P@\ngGX@@eSULAtpqSdm\\xL\\wJC`gmC~t@\ngGX@@eSULAtpqSdm\\xL\\wrC`tO{P@\ngGX@@eSULAtpqSdmkeApSvaZ@=\ngGX@@eSULAtpqSdmkyApZG}h@=\ngGX@@eSULAtpqSdmltLTyK\\hNB^tO{P@=\ngGX@@eSULAtpqSdmlxL\\wJC`gmC~t@\ngGX@@eSULAtpqSdmlxL\\wrC`tO{P@\ngGX@@eSULAtpqShm[yApZG}h@\ngGX@@eSULAtpqShm\\xL\\wJC`gmC~t@\ngGX@@eSULAtpqShm\\xL\\wrC`tO{P@\ngGX@@eSULAtpqShmkeApSvaZ@\ngGX@@eSULAtpqShmkyApZG}h@\ngGX@@eSULAtpqShmlxL\\wJC`gmC~t@\ngGX@@eSULAtpqShmlxL\\wrC`tO{P@\ngGX@@eSULAtpqUdm\\xJ\\wJCoGmC~t@\ngGX@@eSUTAtQQKVyV}lah_v`@=\ngGX@@eSUTAtQQKVyV}tah_v`@\ngGX@@eSUTAtQQKVyW]tah_v`@=\ngGX@@eSUTAtpqSdm[eApRFa@\ngGX@@eSUTAtpqSdm[eApRFaIPhv`@=\ngGX@@eSUTAtpqSdm[eApRFaIXdv`@=\ngGX@@eSUTAtpqSdm[eApRFaZ@=\ngGX@@eSUTAtpqSdm[eAwbFaZ@\ngGX@@eSUTAtpqSdm\\dL\\enTGAHZG}h@\ngGX@@eSUTAtpqSdm\\tLTyK\\hNBPtH\ngGX@@eSUTAtpqSdm\\tLTyK\\hNBPtO{P@=\ngGX@@eSUTAtpqSdukeApRFa@\ngGX@@eSUTAtpqSdukeApRFaZ@=\ngGX@@eSUTAtpqShm[eApRFaZ@\ngGX@@eSUTAtpqShm\\dL\\enTGAHZG}h@\ngGX@@eSUT`hatpqSdm\\dL\\enTGAH[x>\ngGX@@eSUT`hatpqSdm\\xLRwJC`dM|>\ngGX@@eSUT`hatpqSdm\\xL\\wJC`dMB<\ngGX@@eSUT`hatpqSdm\\xL\\wJC`dMB>\ngGX@@eSUT`hatpqSdmlxL\\wJC`dMB<\ngGX@@eSUT`hatpqSdmlxL\\wJC`dMB>\ngGX@@eSUT`hatpqSdulxL\\wJC`dMB<\ngGX@@eSUT`hatpqSdulxL\\wJC`dMB>\ngGX@@eSUT`hatpqShm\\xJ\\wJC`dMB>\ngGX@@eSUT`hatpqShmlxJ\\wJC`dMB<\ngGX@@eSUT`iAtpqSdm\\xL\\wJC`dMB<\ngGX@@eSUT`iAtpqSdm\\xL\\wJC`dMB>\ngGX@@eSUT`iAtpqSdmldL\\enTGAHZD>\ngGX@@eSUT`iAtpqSdmlxLRwJC`dMB<\ngGX@@eSUT`iAtpqSdmlxLRwJC`dMB>\ngGX@@eSUT`iAtpqSdmlxL\\wJC`dMB<\ngGX@@eSUT`iAtpqSdu\\xLRwJC`dM|<\ngGX@@eSUT`iAtpqSdu\\xLRwJC`dM|>\ngGX@@eSUT`iAtpqShm\\xJ\\wJC`dMB<\ngGX@@eSUU@atpqSdm\\dL\\enTGAHZD<\ngGX@@eSUU@atpqSdm\\dL\\enTGAHZD>\ngGX@@eSUU@atpqShm[eApRFa@<\ngGX@@eSUU@atpqShm[eApRFa@>\ngGX@@eSUUHatQQKWNCGMrn{iCPm@<\ngGX@@eSUUHatQQKZyV}lah_v`@+\ngGX@@eSUUHatpqSdm[eApRF~Z@+\ngGX@@eSUUHatpqSdm[eApRF~Z@-\ngGX@@eSUUHatpqSdm\\dLTynTGAHZD<\ngGX@@eSUUHatpqSdm\\dLTynTGAHZD>\ngGX@@eSUUHatpqSdm\\dL\\enTGAH[{}h@<\ngGX@@eSUUHatpqSdm\\tLTyK\\hNBPwp<\ngGX@@eSUUHatpqSdm\\tLTyK\\hNBPwp>\ngGX@@eSUUHatpqSdm\\xJ\\wJCoDMC~t@<\ngGX@@eSUUHatpqSdm\\xJ\\wJCoDMC~t@>\ngGX@@eSUUHatpqSdm\\xLRwJC`dM}~t@<\ngGX@@eSUUHatpqSdm\\xLRwJC`dM}~t@>\ngGX@@eSUUHatpqSdm\\xL\\wJC`dMC~t@<\ngGX@@eSUUHatpqSdm\\xL\\wJC`dMC~t@>\ngGX@@eSUUHatpqSdm\\xL\\wJC`dM}~t@<\ngGX@@eSUUHatpqSdmkeApRFa@<\ngGX@@eSUUHatpqSdmkeApRFa@>\ngGX@@eSUUHatpqSdmkeApRFaZ@+\ngGX@@eSUUHatpqSdmkeApRFaZ@-\ngGX@@eSUUHatpqSdmldLTynTGAHZD<\ngGX@@eSUUHatpqSdmldLTynTGAHZD>\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtH<\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtH>\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtO{P@+\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtO{P@-\ngGX@@eSUUHatpqSdmlxLRwJC`dMC~t@<\ngGX@@eSUUHatpqSdmlxLRwJC`dMC~t@>\ngGX@@eSUUHatpqSdmlxL\\wJC`dMC~t@<\ngGX@@eSUUHatpqSdmlxL\\wJC`dMC~t@>\ngGX@@eSUUHatpqSdu\\tLTyK\\hNBPwp>\ngGX@@eSUUHatpqSdu\\xLRwJC`dM}~t@<\ngGX@@eSUUHatpqSdulxL\\wJC`dMC~t@>\ngGX@@eSUUHatpqShm\\xJ\\wJC`dMC~t@<\ngGX@@eSUUHatpqShm\\xJ\\wJC`dMC~t@>\ngGX@@eSUUHatpqShm\\xL\\wJC`dMC~t@<\ngGX@@eSUUHatpqShm\\xL\\wJC`dMC~t@>\ngGX@@eSUUHatpqShmkeApRFaZ@>\ngGX@@eSUUHatpqShmlxJ\\wJC`dMC~t@<\ngGX@@eSUUHatpqShmlxJ\\wJC`dMC~t@>\ngGX@@eSUUHatpqShmlxLRwJC`dMC~t@<\ngGX@@eSUUHatpqShmlxLRwJC`dMC~t@>\ngGX@@eSUUHatpqShmlxL\\wJC`dMC~t@<\ngGX@@eSUUHatpqShmlxL\\wJC`dMC~t@>\ngGX@@eSUUHatpqShulxL\\wJC`dMC~t@<\ngGX@@eSUUHatpqShulxL\\wJC`dMC~t@>\ngGX@@e]MTAtpqSdm[f]pRFaZ@\ngGX@@e]MTAtpqSdm[{AHZG}h@\ngGX@@e]MTAtpqSdm\\xLTwL{`dMC~t@\ngGX@@e]MTAtpqSdmk{AHZG}h@\ngGX@`IWITtp@]PUrm{Y{^m@=\ngGX@`IWITtp@]PUrm{i{^m@=\ngGX@`IWITtp@]XJ\\wvB^wo{P@=\ngGX@`NtiMtu@]FVSVnQm[HZD\ngGXA@IRVjj@zlTyKV~pRFa@\ngGXA@IRVjj@zlTyKWICEN[{AHZD\ngGXA@IRVjj@zlTyKWNCEM}`dMB\ngGXA@IRYb@@wH{mg]v=\ngGXA@IRYb@@wH{ng]v=\ngGXA@IRYb@@ypXenQw[N{t\ngGXA@IRYb@@ypXynQw[O[t\ngGXA@IRYb@@ypXynQw]O[t\ngGXA@IRYf`@zT\\wH{`g]v=\ngGXA@IRYf`@zdkd[vsn{@=\ngGXA@IRYjP@zdkd[vsn{@=\ngGXA@IRYjP@zdkd[wSn{@=\ngGXA@IRYjP@zdkd]vsn{@=\ngGXA@IRYjP@zdkd]wSn{@=\ngGXA@IRYj`dPzT\\wvB]wX+\ngGXA@IRYj`dPzT\\wvB]wX-\ngGXA@IRYj`dPzT\\wvB]wh<\ngGXA@IRYj`dPzT\\wvB]wh>\ngGXA@IRYj`dPzT\\ypXeolD{oP<\ngGXA@IRYj`dPzT\\ypXeolD{oP>\ngGXA@IRYj`dPzT]WvB]wX+\ngGXA@IRYj`dPzT]WvB]wX-\ngGXA@IRYjfdPzlTzKWNCGM}`gmB<\ngGXA@IRYjfdPzlTzKWNCGM}`gmB>\ngGXA@IRYjjTR`zlTyKWNCGM}`dMB>\ngGXA@IRYjjdPzlTyKV~pRFa@<\ngGXA@IRYjjdPzlTyKV~pRFa@>\ngGXA@IRZZi@zlTyKWNCDm}`dMz\ngGXA@IRZZj@zlTyKV~pRFa@\ngGXA@IRZZj@zlTyKV~pRF~@\ngGXA@IRZZj@zlTyKWIbgI[d^pRF~@\ngGXA@IRZZj@zlTyKWIbgI[{AHZD\ngGXA@IRZZj@zlTyKWNCDm}`dMB\ngGXA@IRZZjdPzlTyKWICEI[{AHZD<\ngGXA@IRZZjdPzlTyKWICEI[{AHZD>\ngGXA@IRZZjdPzlTyKWNbdm}`dMB<\ngGXA@IRZZjdPzlTyKWNbdm}`dMB>\ngGXA@IRfjj@zXXirVmr`xICP`\ngGXA@IRfjj@zXXirVn\\FJ[e^pRFa@\ngGXA@IRih@@wJwmg]w~t@=\ngGXA@IRih@@wJwng]w~t@=\ngGXA@IRih@@wJ{ng]w~t@=\ngGXA@IRihF@ztRunUo[OZG}h@=\ngGXA@IRii`@z`ke[vsn{Z@=\ngGXA@IRii`@z`ke[vsn}Z@\ngGXA@IRii`@z`ke[vsv}Z@=\ngGXA@IRii`@z`ke]vsv}Z@=\ngGXA@IRii`@z`ke]wSn{Z@=\ngGXA@IRii`@z`ke]wSv}Z@=\ngGXA@IRii`@zpTynUwAN{o}h@=\ngGXA@IRii`@zpTynUwAO[w}h@=\ngGXA@IRii`@zpTynUw^O[w}h@=\ngGXA@IRii`@zpTyolD{o_v`@\ngGXA@IRii`@zpTyolD}o_v`@=\ngGXA@IRii`@zpTznUwAN{o}h@=\ngGXA@IRij`@zpTynTGAN{l=\ngGXA@IRij`@zpTynTGAN{t\ngGXA@IRijj@zXXirVmr`xICP`\ngGXA@IRijj@zXXirVnZFJ\\enTGAHZD\ngGXA@IRijjPTPzXXirVn\\FN[eApRFa@<\ngGXA@IRijjPT`zXXirVn\\FN[eApRFa@>\ngGXA@IRijjdPzXXirVnRFJ\\wJC`dMB<\ngGXA@IRijjdPzXXirVur`xICP`>\ngGXA@IRjZj@zXXirVmr`xICP`\ngGXA@IRjZj@zXXirVnRFJRwJC`dMB\ngGXA@IRjZj@zXXirVnRFJRwJC`dM|\ngGXA@IRjZj@zXXirVn\\FI[eApRFa@\ngGXA@IRjZj@zXXirVur`xICP`\ngGXA@IRjZj@zXXirVv\\FI[eApRFa@\ngGXA@IRkfj@zHdek\\s^vPtO{P@\ngGXA@IRkfj@zHdek\\s^zPtO{P@\ngGXA@IRkfj@zHdek\\snvPtO{P@\ngGXA@IRkfj@zHdek\\snzPtO{P@\ngGXA@IRkfj@zXXirVmsNxICPm@\ngGXA@IRkfj@zXXirVm}`dMC~t@\ngGXA@IRnfj@zXXirVn\\FJ[f]pRFaZ@\ngGXA@NRYjP@zdkd[vsn{@=\ngGXA@NRYjP@zdkd[wSn{@=\ngGXA@NRYjV@zLdem\\c^v^tH\ngGXA@NRZZj@zlTyKWIbgI[{AHZD\ngGXAAiR[ij@zLlemgARVyGUlahP>\ngGXAAiR[ij@zLlemgARVyGUtahP>\ngGXAAiR[ij@zLlfkgASfyGUlao`>\ngGXAAiR[ij@zLlfm\\cZvPtH\ngGXAAiR[ij@zLlfm\\cZzPtH\ngGXAAiR[ij@zLlfmgASfyGUlahP>\ngGXAAiR[ij@zLlfmgASfyGUtahP>\ngGXD@jCTBUMT@GTC]G]w~t@=\ngGXDAjBtFRPrj`NjFJ\\eohEAHP>\ngGXDD@`aBS]MHGRejyFul{np\ngGXDD@`aBS]MHGRejyFul{oP\ngGXDD@b^BSRuPGUbgQjwvBPtO{Q@\ngGXDH@aABS]T@GTc\\cr|]w_{R@=\ngGXDH@aABS]T@GTc\\cr|]wo{R@=\ngGXDHGANBS]T@GTc\\cr|^wh=\ngGXDHGANBS]T@GTc\\cr|^woyHFD=\ngGXDHHQPbS]T@GTc]Gmz=\ngGXDHHQPbS]T@GTc]Gm{~RAa@=\ngGXDHO@~BUMUTbGUCEVjwrC`tH<\ngGXDHO@~BUMUTbGUCEVjwrC`tH>\ngGXDHOANBRtuPGUbgIZwvBPtO{R@\ngGXDHOA^BS]T@GTc]G]w~RAamH=\ngGXDHOA^BS]T@GTc]G]w~t`=\ngGXDHOA^BS]T@GTc]Gmz=\ngGXDHOA^BS]T@GTc]Gm{~RAa@=\ngGXDHOA^BS]UPGQcdm[d^WbFaI@pvd@=\ngGXDJDR^BSRuPGQbgI[kAHP\ngGXDJIARBSWUPGVcdmx_@\ngGXDL@aABS\\uPGQcdm[hah_vf@=\ngGXDL@bABUuUTRGQBdm\\dLTynbFa@<\ngGXDL@bABUuUTRGQBdm\\dLTynbFa@>\ngGXEHOA^BeIZZhCjqShuk{AHZG}i@\ngGXEHOA^DeInZ@CjQoat}o_rPLMi@=\ngGXEL@aAByInZhChqrVmtPtO{S@=\ngGXEaJAT@f\\nRfjj@zhXzMZyWlDahP\ngGXHAJAIfj@CiQs_XIw]`+\ngGXHAJAIfj@CiQs_XI{^`+\ngGXHAJAIfj@CiQu_XIw]`+\ngGXHAJAIfj@CiQu_XI{^`+\ngGXHAJAIfj@CiQugAbV~pSn}@>\ngGXHAJAIfj@CiQugAcf~pSv}@>\ngGXHAJAIfjXCkQUkNCGM}`gmv>\ngGXHAJAIfjhCjqSdm\\fJ\\eolDahP>\ngGXHAjAJfj@CiAS\\hN|]w_{P@=\ngGXHAjAJfj@CiAS\\hN|^wo{P@=\ngGXHAjAJfj@CiAS_HIw]m@=\ngGXHAjAJfj@CiAS_HI{^m@=\ngGXHAjAJfj@CiAU_HIw]m@=\ngGXHAjAJfjBACiAS_HI{^`+\ngGXHAjAJfjBACiAS_HI{^`-\ngGXHAjAJfjBACiAU_HI{^`+\ngGXHAjAJfjBACiAU_HI{^`-\ngGXHAjAJfjXCjabhmlxJ\\wrCoTO{P@\ngGXHAjAJfjjACjabdm[yAHZD<\ngGXHAjAJfjjACjabdm[yAHZD>\ngGXHAjCIHYUPGSCENRunXEAHZD\ngGXHAjCIHYUPGSCENRusPqSdms@hICPm@=\ngGXHB@aIfi@CjRnQo[N{l\ngGXHB@aIfi@CjRnQo[N{t\ngGXHB@aIfi@CjRnQo]N{l\ngGXHB@aIfiXCiRU\\c^v]wh\ngGXHB@aIfiXCkRSV~F}na@\ngGXHB@aIfidCiRU\\c^v^wX\ngGXHB@aIfidCiRU\\c^v^wh\ngGXHB@aIfidCkRSV~F}n}@\ngGXHB@aIfjBQCiQsgAbV~pSn}@>\ngGXHB@aIfjiQJChqSfn]EN[kAhP<\ngGXHB@aInfjZCkRsV~Funa@<\ngGXHB@aInfjZCkRsV~Funa@>\ngGXHBOAJfj@CkAUjyP\\D{np\ngGXHBOAJfjdCjabgM\\dLTeodGAoP\ngGXHD@aIfZhCjqSdm[{AHZG}h`=\ngGXHD@aIfZhCjqSdm\\zJ\\wvBPtO{Q@\ngGXHD@aIfZhCjqShm[{AHZG}h`=\ngGXHD@aIfZhCjqShm\\zJ\\wvBPtO{Q@\ngGXHD@aIfZhCjqShmk{AHZG}h`\ngGXHD@aIfihChrRVmrM{YCPmD=\ngGXHD@aIfihChrRVmrM{iCP`=\ngGXHD@aIfihChrRZurM{YCPmD=\ngGXHD@aIfihCiRU\\c^v]w_{Q@=\ngGXHD@aIfjjQCjqShmlxL\\wvBPtO{Q@>\ngGXHD@aIkjjQChqrVn\\gI[hahP<\ngGXHD@aIkjjQChqrVn\\gI[hahP>\ngGXHD@aInZ@CjQncn{@=\ngGXHD@aInZ@CjQncn}@\ngGXHD@aInZ@CjQshiK]G]z\ngGXHD@aInZXChqrVmt^tH\ngGXHD@aInZXChqrVmyP`\ngGXHD@aInZhChqrVmtPtH\ngGXHD@aInf@CjQncn{@=\ngGXHD@aInf@CjQncn}@\ngGXHD@aInf@CjRnQm[N{l=\ngGXHD@aInf@CjRnQm[N{t\ngGXHD@aInf@CjRnQm[O[t=\ngGXHD@aInf@CjRshiK\\cZz]wh\ngGXHD@aInfXChrrVm|Mk]B\ngGXHD@aInfXCiRu\\cZv^wh\ngGXHD@aInjBQCjQncn{@+\ngGXHD@aInjBQCjQncn{@-\ngGXHD@aInjBQCjQncn}@>\ngGXHDDQInf@CjRnQm[N{l=\ngGXHDOAInjBQCjQoax{np+\ngGXHDOAInjBQCjQoax{np-\ngGXHH@aIZjhCjqSdm[d^pRFaZP\ngGXHH@aIZjhCjqSdmk{AHZG}i@\ngGXHH@aIfj@CiQs\\cvB]w_{R@=\ngGXHH@aIfj@CiQs\\cvB]wo{R@\ngGXHH@aIfj@CiQsgAbVyGlD{o_vd@\ngGXHH@aIfj@CiQsgQRVyGlD{o_vd@\ngGXHH@aIfj@CiQsgQSfyGlD}o_vd@\ngGXHH@aIfj@CiQu\\cvB]w_{R@=\ngGXHH@aIfjXCjqSdm[d^pSvaZP\ngGXHH@aIfjXCjqSdm\\xL\\wH}`gmC~t`\ngGXHH@aIfjXCjqSdmlzJ\\wp}`tO{R@\ngGXHH@aIfjXCkQUgNCDmrOXI{^mH\ngGXHH@aIfjXCkQUgNbgMrOXI{^mH\ngGXHH@aIfjhCjqSdm[d^pRFaZP\ngGXHH@aIfjhCjqSdm[{AHZG}i@\ngGXHH@aIfjhCjqSdm\\fJ\\enQ{AHZG}i@\ngGXHH@aIfjjICjqSdm\\zJ\\wH}`dMC~t`<\ngGXHH@aIfjjICjqSdm\\zJ\\wH}`dMC~t`>\ngGXHH@aIfjjICjqSdmlzJRwH}`dMC~t`>\ngGXHH@aIfjjICjqSdmlzJ\\wH}`dMC~t`<\ngGXHH@aIfjjICjqSdmlzJ\\wH}`dMC~t`>\ngGXHH@aIfjjICjqSdulzJ\\wH}`dMC~t`>\ngGXHH@aIfjjICjqShm\\zJ\\wH}`dMC~t`<\ngGXHH@aIfjjICjqShm\\zJ\\wH}`dMC~t`>\ngGXHH@aJnZBACiAu_XIw]`+\ngGXHH@aJnZBACiAu_XIw]`-\ngGXHHGAIfj@CiQs\\cvB]w_{R@=\ngGXHHGAIfj@CiQs\\cvB^wo{R@=\ngGXHHGAIfj@CiQs_XI{^mH=\ngGXHHGAIfjXCjqShm\\xLRwp}`tO{R@\ngGXHHGAIfjXCjqShm\\xL\\wVCPmH\ngGXHHGAIfjXCjqShm\\xL\\wp}`tO{R@\ngGXHHGAIfjhCjqSdm[d^pRFaZP\ngGXHHGAIfjhCjqSdm[{AHZG|dBcZP\ngGXHHOAIZZhCjqSdm[{AHZG}i@\ngGXHHOAIZjhCjqSdm[d^pRFaZP\ngGXHHOAIZjhCjqSdm[{AHZD\ngGXHHOAIfj@CiQs\\cvB]w_{R@=\ngGXHHOAIfj@CiQs\\cvB^wo{R@=\ngGXHHOAIfj@CiQs_XIw]mH=\ngGXHHOAIfj@CiQs_XI{^mH=\ngGXHHOAIfjBQCiQs_XI{^`+\ngGXHHOAIfjBQCiQs_XI{^`-\ngGXHHOAIfjhCjqSdm[d^pRFaZP\ngGXHHOAIfjhCjqSdm[{AHZG}i@\ngGXHHOAIfjjICjqSdmkd^pRFaZP<\ngGXHHOAIfjjQCjqSdm[{AHZD<\ngGXHHOAIfjjQCjqSdm[{AHZD>\ngGXHHOAJkZhCjaSdm[f]pRFa@\ngGXHHOAJkZhCjaSdm[{AHZD\ngGXHHOAJnjBACiAu_XIw]`+\ngGXHHOAJnjBACiAu_XIw]`-\ngGXHHOAJnjjACjaSdm[{AHZD<\ngGXHHOAJnjjACjaSdm[{AHZD>\ngGXHL@aJZjhCjabdm[yAHZD\ngGXH`Z@R^RjZj@zhXisV~P\\Fa@\ngGXH`Z@R^RjZj@zhXisWICEI[yApZD\ngGXHaJ@SNRYj`@zT]WvB^wh+\ngGXHaJ@SNRZZj@zlTyKV~pRFa@\ngGXHaJ@SNRZZjdPzlTyMV~pRFa@<\ngGXHaJ@SNRZZjdPzlTyMV~pRFa@>\ngGXHaj@SnRii`@zPTwJ{oG]w~t@=\ngGXHaj@SnRii`@zPTwJ{oGm{~t@=\ngGXHaj@SnRii`@zPTwv|]w_{P@=\ngGXHaj@SnRii`@zPTwv|]wo{P@\ngGXHaj@SnRii`@zPTwv|^wo{P@=\ngGXHaj@SnRii`@zPTypTeomx{o_v`@\ngGXHaj@SnRkfj@zhXiKVyg]xah_rPJMh@\ngGXHaj@SnRkfj@zhXiKV~wbFaZ@\ngGXHhG@]IR[ij@zlTyKV~WRFaI@pvd@\ngGXI@Z@ReTuTAuPqSfm|`xMB\ngGXIAjC\\eSU@At`inTG^N{o}h@=\ngGXIDHaRdmUTAuXirVm}`dMB\ngGXIHDPReWU@At`zolD{np+\ngGXIHO@ReUuTAuPirVm}`dMB\ngGXIHOBRdmMTAuXirVm}`dMC~t`\ngGXIHOBRdsMTAuXirVm}`dMC~t`\ngGXLJIARFdLbdMU@]JIP\ngGX`BDdwM@AuHwQw]`\ngGX`BDdwM@AuHwQw^`\ngGX`BDdwMLAthzncn{@\ngGX`BDdwMLAthzncn}@\ngGX`BDdwMLAuhyk]GmB\ngGX`BDdwMLAuhyk^TH\ngGX`BDdwMLAuhym]GmB\ngGX`BDdwMLAuhym^TH\ngGX`BDdwMRAthzncn{@\ngGX`BDdwMRAthzncn}@\ngGX`BDdwMRAthzncv{@\ngGX`BDdwMRAthzncv}@\ngGX`BDdwMRAthzshiK]Gmz\ngGX`BDdwMRAuhyj\ngGX`BDdwMRAuhyk^Wh\ngGX`BDdwMRAuhykgQRT\ngGX`BDdwMRAuhykgQRV|oP\ngGX`BDdwMUMAuhyk^TH<\ngGX`BDdwMUMAuhyk^TH>\ngGX`BDdwMUMAuhyk^Wp<\ngGX`BDdwMUMAuhyk^Wp>\ngGX`BDdwMUMAuhykgQRV|hP>\ngGX`BDdwMUMAuhykgQSf|hP<\ngGX`BDdwMUMAuhykgQSf|hP>\ngGX`BDdwMUMAuhym^TH<\ngGX`BDdwMUMAuhym^TH>\ngGX`BDdwULAuhykdabdmyP`\ngGX`BDdwUThlauhykgARV|hP>\ngGX`BDdwUThmAuhykgARV|hP<\ngGX`DBdsMTAtXisVzpZG}h`\ngGX`DBdsMTAtXisWNbdmu`tO{Q@\ngGX`DBdsMTAtXiuVzpZG}h`\ngGX`DBdsMTAtXiuWNbdmu`tO{Q@\ngGX`DBdsMTAtXiuZzpZG}h`\ngGX`DBdwMLAuhyk^TH\ngGX`DBdwMLAuhym^TH\ngGX`DBdwMRAthzncn{@\ngGX`DBdwMRAthzncn}@\ngGX`DBdwMRAthzshiK]G]z\ngGX`DBdwMRAuhyj\ngGX`DBdwMRAuhykgQRT\ngGX`DBdwMRAuhykgQRV|oP\ngGX`DBdwMUMAuhyk^TH<\ngGX`DBdwMUMAuhyk^TH>\ngGX`DBdwMUMAuhykgQRV|hP<\ngGX`DBdwMUMAuhykgQRV|hP>\ngGX`DBdwMUMAuhykgQSf|hP>\ngGX`DBdwMUMAuhym^TH<\ngGX`DBdwMUMAuhym^TH>\ngGX`DBdwSRAtiZnQm[N{l\ngGX`DBdwUThmAuhykgARV|hP<\ngGX`DBdwUThmAuhykgARV|hP>\ngGX`JDduuTAuhyK^DH\ngGX`JDduuTAuhyM^DH\ngGX`LDdwMTAtXyKVzHZG|ebSZX=\ngGX`LDdwMTAtXyKVzHZG}i`=\ngGX`LDdwMTAtXyKVzH[{|ebSZX\ngGX`LDdwMTAtXyKVzH[{}i`\ngGX`LDdwMTAtXyKWNbgMtPtO{S@\ngGX`LDdwMTAtXyKZzHZG}i`\ngGX`LDdwMTAtXyK[NbgMtPtO{S@\ngGX`LDdwMTAtXyMVzH[{}i`\ngGX`LDdwMTAtXyMZzHZG}i`=\ngGX`LDdwMTAthzncn{ZX=\ngGX`LDdwMTAthzncn}ZX\ngGX`LDdwMTAthzncv}ZX=\ngGX`bDnLiMsP@]RMt]wX\ngGX`bDnLiMsT`]ZNZ`\ngGX`bDnLiMsUSP]ZNZweB<\ngGX`bDnLiMsUSP]ZNZweB>\ngGX`hEIWIMsP@]RMt]w_{R@=\ngGX`hEIWIMsP@]RMt]wo{R@\ngGX`hEIWIMsP@]RMt^wo{R@=\ngGX`hEIWIMsS@]FNRuncvaZP\ngGX`hEIWIMsS@]FNRuncv~ZP\ngGX`hEIWIMsS@]FNRuoJG}i@\ngGX`hEIWIMsS@]JNkh{nvd@\ngGX`hEIWIMsS@]JNkh{o_vd@\ngGX`hEIWIMsS@]JNkh}nvd@\ngGX`hEIWIMsS@]JNkh}o_vd@\ngGX`hEIWIMsU@]FNRunbFaZP\ngGX`hEIWIMsUSH]FNRunbF~ZP<\ngGX`hEIWIMsUSH]FNRunbF~ZP>\ngGXaBDYR[f`@zd[h{np\ngGXaBDYR[fi@zt\\uoKt\ngGXaBDYR[fjf`zt\\uoJD<\ngGXaBDYR[fjf`zt\\uoJD>\ngGXaBDYR[fjf`zt\\voJD<\ngGXaBDnR[f`@zd[h{np\ngGXaBDnR[f`@zd[h{oP\ngGXaBDnR[ff@zT]WQw^`\ngGXaBDnR[fi@zT]WQw]`\ngGXaBDnR[fi@zT]WQw^`\ngGXaBDnR[fi@zt\\u@\ngGXaBDnR[fi@zt\\uoKt\ngGXaBDnR[fjf`zt\\uoJD<\ngGXaBDnR[fjf`zt\\uoJD>\ngGXaLDnR[fj@zL\\ek]DMC~tp=\ngGXdBl@b^BSRuTbGVbfmyP`<\ngGXdBl@b^BSRuTbGVbfmyP`>\ngGXdBl@b^BSRuTbGVbfuyP`<\ngGXdBl@b^BSRuTbGVbfuyP`>\ngGXdBl@b^FQREj`NmDm[raZD\ngGXdMD@baFRREZPNlGIkhao_vf@\ngGXdMD@baFRREZPNlGIkpaZX\ngGXdMD@baFRREZ`NlGI[haoovf@\ngGXdMD@baFRREZ`NlGIkhaoovf@\ngGXeMD@baF{IIBmPGVCdmtPww{S@\ngGXeMD@baF{IIBmPGVCdmt_Ww{S@\ngGXeMD@baF{IIBmPGVCdutPww{S@\ngGXhHZ@aIfjXCkQSfzGlG}i@\ngGXhHZ@aIfjXCkQSgNbdmtOXO{R@\ngGXhLEJAInjhChqrVmtPtO{S@=\ngGXhLEJAInjhChqrVutPtO{S@\ngGXhMD@cIIBmHGQCdu[hao_vf@\ngGXhMD@cIIBmHGQCdu[paZX\ngGXhMD@cIIBmHGQCdu\\yNRwQC^mL\ngGXhMD@cIIBmHGQCdu\\yNRwaC~tp\ngGXhMD@cIIBmPGQCdm[hah_vf@\ngGXhMD@cIIBmPGQCdm[h~h_vf@\ngGXhMD@cIIBmPGQCdmkhah_vf@\ngGXhMD@cIIBmPGQCdu[hah_vf@\ngGXhMD@cIIBmPGQCdu[haoovf@\ngGXhMD@cIIBmPGQCdu\\yNRwQCPmL\ngGXhMD@cIIBmPGQCdukhah_vf@\ngGXhMD@cIIJmPGVBVmyP`\ngGXhMD@cIIJmPGVBVmy_@\ngGXhMD@cIIJmPGVBVn\\gI[ra@\ngGXhMD@cIIJmPGVBVuyP`\ngGXhMDOCIHYUPGQCdm[hahP\ngGXhbLjA\\YRnjjbPzHYImgAcfz`ZD<\ngGXhbLjA\\YRnjjbPzHYImgAcfz`ZD>\ngGXhdZ@aS^RYjV@zTdwPwmmD\ngGXiMD@c]ddaVhCharZmtPtO{S@\ngGXiMD@c]ddaVhCharZutPtO{S@\ngGY@BDfYh@NeGM}`g]v\ngGY@BDfYh@NeGN]EI[{AN{t\ngGY@BDfYh@NeGU}`g]v\ngGY@BDfYh@NeGU}`g]z\ngGY@BDfYh@NeGV]EI[{AN{t\ngGY@BDfYi`NcENZwVCP`\ngGY@BDfYi`NcENZwvB^tH\ngGY@BDfYi`NcENZytTenlFa@\ngGY@BDfYi`NcEN[YtTeolD}hP\ngGY@BDfYi`NcENjwVCP`\ngGY@BDfYi`NcENkWvB^tH\ngGY@BDfYi`NmEV[{AN{t\ngGY@BDfYi`NmEVk{AN{t\ngGY@BDfYi`NmEVlzJRwvB]wh\ngGY@BDfYjPNcENZytTenlF}@\ngGY@BDfYjPNcENZytTeoLD\ngGY@BDfYjPNcENZytTyoLD\ngGY@BDfYjPNcENjwVC^`\ngGY@BDfYjPNcENjwfB\ngGY@BDfYjPNcENjytTenlF}@\ngGY@BDfYjPNcENjytTeoLD\ngGY@BDfYjPNmEV[{AN{l\ngGY@BDfYjPNmEV[{AN{t\ngGY@BDfYjPNmEV[{AO[l\ngGY@BDfYjPNmEV\\zJRwvB]wh\ngGY@BDfYjPNmEV\\zJRwvB^wh\ngGY@BDfYjPNmEVk{AN{l\ngGY@BDfYjPNmEVk{AN{t\ngGY@BDfYjPNmEVk{AO[l\ngGY@BDfYjPNmEVk{AO[t\ngGY@BDfYjPNmEVlzJRwvB]wh\ngGY@BDfYjPNmEVlzJRwvB^wh\ngGY@BDfYjhhNcENZwVCP`>\ngGY@BDfYjhhNcENjwVCP`<\ngGY@BDfYjhhNcENjwVCP`>\ngGY@BDfZd@NiJyF}l{oP\ngGY@BDfZe`NmIM[x[vzD\ngGY@BDfZfPNeIUrM{Yw]`\ngGY@BDfZfPNmEV[h{np\ngGY@BDfZfPNmEV[h{oP\ngGY@BDfZfPNmIM[x[v{t\ngGY@BDfZhIDNeGM}`g]v>\ngGY@BDfZhIDNeGN]EI[{AO[t>\ngGY@BDfZjeDdNcENZwVCP`<\ngGY@BDfZjeDdNcENZwVCP`>\ngGY@BDfZjeDdNcENZypXenlFa@<\ngGY@BDfZjeDdNcENZypXenlFa@>\ngGY@BDfZjeDdNcENZytTenlFa@<\ngGY@BDfZjeDdNcENZytTenlFa@>\ngGY@BDfZjeDdNcENZytTynlFa@<\ngGY@BDfZjeDdNcENZytTynlFa@>\ngGY@BDfZjeDdNcEN[WVCP`<\ngGY@BDfZjeDdNcEN[YtTynlFa@<\ngGY@BDfZjeDdNcEN[YtTynlFa@>\ngGY@BDfZjeDdNcENkWVCP`>\ngGY@BDfZjeDhNcENZwVCP`<\ngGY@BDfZjeDhNcENZwVCP`>\ngGY@BDfZjeDhNcENZyLTyK]XMB<\ngGY@BDfZjeDhNcENZyLTyK]XMB>\ngGY@BDfZjeDhNcENZytTenlFa@<\ngGY@BDfZjeDhNcENZytTenlFa@>\ngGY@BDfZjeDhNcENZytTynlFa@<\ngGY@BDfZjeDhNcENZytTynlFa@>\ngGY@BDfZjeDhNcEN[WVCP`<\ngGY@BDfZjeDhNcEN[WVCP`>\ngGY@BDfZjeDhNcENjwVCP`<\ngGY@BDfZjeDhNcENjwVCP`>\ngGY@BDfZjeHhNcENjwVCP`<\ngGY@BDfZjeHhNcENjwVCP`>\ngGY@BDfZjeHhNcENjypXynlFa@>\ngGY@BDfzZihNmKM[x[VzD<\ngGY@BDfzZihNmKM[x[VzD>\ngGY@DDfYj`NkENRuolDah_vb@=\ngGY@DDfYj`NkENRuolDaoovb@\ngGY@DDfYj`NkENRuomxah_vb@=\ngGY@DDfYj`NkENRushiK_XIC__mD\ngGY@DDfYj`NkENRushiK_[qC__mD\ngGY@DDfYj`NkENRushis_XICPmD\ngGY@DDfYj`NkENRushis_XIC__mD\ngGY@DDfYj`NkENRushis_[qCPmD\ngGY@DDfYj`NkENRvolDah_vb@\ngGY@DDfYj`NkENRvomxah_vb@\ngGY@DDfYj`NkENRvshiK_XICPmD\ngGY@DDfYj`NkENRvshiK_[qCPmD\ngGY@DDfYj`NkENRvshis_XICPmD\ngGY@DDfYj`NkENRvshis_[qCPmD\ngGY@DDfYj`NkENSUolDaoovb@\ngGY@DDfYj`NkENSUshiK_XIC__mD\ngGY@DDfYj`NkENSUshiK_[qC__mD\ngGY@DDfYj`NkENSVolDah_vb@=\ngGY@DDfYj`NkENSVshis_XICPmD\ngGY@DDfYj`NkENbuolDah_vb@=\ngGY@DDfYj`NkENbuolDaoovb@\ngGY@DDfYj`NkENbushiK_XIC__mD\ngGY@DDfYj`NkENbushis_XICPmD\ngGY@DDfYj`NkENbushis_XIC__mD\ngGY@DDfYj`NkENbvolDah_vb@\ngGY@DDfYj`NkENbvshiK_XICPmD\ngGY@DDfYj`NkENbvshis_XICPmD\ngGY@DDfYj`NkENcVolDah_vb@=\ngGY@DDfYj`NkENcVshis_XICPmD\ngGY@DDfYj`NmEV[{AN{w}h`\ngGY@DDfYj`NmEV[{AO[w}h`=\ngGY@DDfYj`NmEV\\zJRwvB]wo{Q@\ngGY@DDfYj`NmEV\\zJ\\wvB^wo{Q@\ngGY@DDfYj`NmEVk{AN{w}h`\ngGY@DDfYj`NmEVk{AO[w}h`=\ngGY@DDfYj`NmEVlzJ\\wvB^wo{Q@\ngGY@DDfZf`NcIIZwHwndMB=\ngGY@DDfZf`NkENRuomtah_vb@=\ngGY@DDfZf`NkENRushis_[iCPmD\ngGY@DDfZjiDNkENRuolDah_vb@+\ngGY@DDfZjiDNkENRuolDah_vb@-\ngGY@DDfZjiDNkENRushis_XICPmD<\ngGY@DDfZjiDNkENRvolDah_vb@<\ngGY@DDfZjiDNmEV[{AN{w}h`<\ngGY@DDfZjiDNmEV[{AN{w}h`>\ngGY@DDfZjiDNmEV[{AO[w}h`-\ngGY@DDffj`NkENRuolDah_vb@\ngGY@DDffjiDNkENRushiK_XICPmD>\ngGY@DDfnjYDNcGIZypTeoCx<\ngGY@DDfnjYDNcGIZypTeoCx>\ngGY@DDfnjiDNcGIZwQCP`<\ngGY@DDfnjiDNcGIZwQCP`>\ngGY@DDfnjiDNcGIZyHXiK]DMB>\ngGY@DDfnjiDNcGIZyr\\enbFa@<\ngGY@DDfnjiDNcGIZyr\\enbFa@>\ngGY@DDfnjiDNcGIZytTenbFa@<\ngGY@DDfnjiDNcGIZytTenbFa@>\ngGY@DDfyh@NiFzN{l=\ngGY@DDfyh@NiFzN{t\ngGY@DDfyh@NiFzO[t=\ngGY@DDfyh@NiGNbdmt]wh\ngGY@DDfyh@NiGNbgMt^wh\ngGY@DDfyi`NcGIZwQ{P`\ngGY@DDfyi`NcGIZweB\ngGY@DDfyi`NcGIZytTencva@\ngGY@DDfyi`NcGIZytTeoJD\ngGY@DDfyi`NcGIZytTyncva@\ngGY@DDfyi`NcGIZytTyncv~@\ngGY@DDfyi`NcGIZytTyoJD\ngGY@DDfyi`NcGI[WQ{P`\ngGY@DDfyi`NcGI[WeB\ngGY@DDfyi`NcGI[YtTyncva@\ngGY@DDfyi`NcGI[YtTyoJD\ngGY@DDfyi`NeGUt]wh\ngGY@DDfyi`NeGUt^wX\ngGY@DDfyi`NeGUt^wh\ngGY@DDfyi`NeGV]EI[h}oP\ngGY@DDfyi`NeGV]EN[h}np\ngGY@DDfyi`NeGV]EN[h}oP\ngGY@DDfyj`NcGIZwQCP`\ngGY@DDfyj`NcGIZwQCPdlRP\ngGY@DDfyj`NcGIZyLTyK]DMB\ngGY@DDfyj`NcGIkWQCP`\ngGY@DDfyjidNcGIZwQC_@<\ngGY@DDfyjidNcGIZwQC_@>\ngGY@DDfyjidNcGIZytTenbF~@<\ngGY@DDfyjidNcGIZytTenbF~@>\ngGY@DDfyjidNcGIZytTynbFa@<\ngGY@DDfyjidNcGIZytTynbFa@>\ngGY@DDfyjidNcGIZytTynbF~@>\ngGY@DDfyjidNcGI[WQCP`<\ngGY@DDfyjidNcGI[WQCP`>\ngGY@DDfyjidNcGI[YtTynbFa@<\ngGY@DDfyjidNcGI[YtTynbFa@>\ngGY@DDfzX@NiFzN{l=\ngGY@DDfzX@NiFzN{t\ngGY@DDfzX@NiGNBdmt]wh\ngGY@DDfzX@NiJyFul{np=\ngGY@DDfzX@NiJyFul{oP\ngGY@DDfzX@NiJyFul}oP=\ngGY@DDfzX@NiKNbdmrMkiw^`\ngGY@DDfzY`NcGIZypTyoJD\ngGY@DDfzY`NcKIZwpvmtH\ngGY@DDfzZ`NcKIZwHvmdMB\ngGY@DDfzZ`NcKIZwHvmdMC~RqI@\ngGY@DDfzhIDNiFzN{l+\ngGY@DDfzhIDNiFzN{l-\ngGY@DDfzhIDNiFzN{t<\ngGY@DDfzhIDNiGNbdmt]wh<\ngGY@DDfzhIDNiGNbdmt]wh>\ngGY@HDfZh@NeGM}`g]w~t`=\ngGY@HDfZh@NeGN]EI[{AN{w}i@\ngGY@HDfZhIDNeGM}`g]v+\ngGY@HDfZhIDNeGM}`g]v-\ngGY@HDfZhIDNeGM}oG]v-\ngGY@HDfZhIDNeGM}oG]z<\ngGY@HDfZhIDNeGM}oG]z>\ngGY@HDfZhIDNeGNRFJRwvB]wh<\ngGY@HDfZhIDNeGNRFJRwvB]wh>\ngGY@HDfZi`NkENRushis]XMC~t`\ngGY@HDfZj`NkENRurPqrV~pRFaZP\ngGY@HDkjj`NjENRuolDahP\ngGY@HDkjj`NjENRus`qS_XICP`\ngGY@JDffj`NcENRwVBP`\ngGY@JDffjiDNcENRytTenlDa@<\ngGY@JDffjiDNcENRytTenlDa@>\ngGY@JDffjiDNcENRyt\\enlD~@>\ngGY@JDffjiDNcENSWVBP`<\ngGY@JDffjiDNcENSWVBP`>\ngGY@LDejj`NcEIZwQCP`\ngGY@LDejj`NcEIZypXinbFa@\ngGY@LDejjhhNcEIZwQC_@>\ngGY@LDejjhhNcEIZypXynbFa@<\ngGY@LDejjhhNcEIZypXynbFa@>\ngGY@LDijj`NjFJRuodDahP\ngGY@LDijj`NjFJRus`qS_HICP`\ngGY@LDijjiDNjFJRus`qs_HICP`<\ngGY@LDijjiDNjFJRus`qs_HICP`>\ngGY@LDijjiDNjFJbus`qs_HICP`<\ngGY@LDijjiDNjFJbus`qs_HICP`>\ngGY@LDijjiDNjFJbus`qs_HIC_@<\ngGY@LDijjiDNjFJbus`qs_HIC_@>\ngGY@bAqeIfiXChqSfn]EI[ra@\ngGY@dAreInf@CjQshiK]G]z\ngGY@hAteIfi@CiQs]G]w~t`=\ngGY@hAteIfi@CiQs_[iw]mH=\ngGY@hAteIijhCjqSdm[{AHZD\ngGY@hAteIijjQCjqSdm\\zJRwvBPtH<\ngGY@hAteIijjQCjqSdm\\zJRwvBPtH>\ngGYABCJSLuTTGQbgU[kAhP<\ngGYABCJSLuTTGQbgU[kAhP>\ngGYABCJSMURbRGQbgM\\zJRwVCP`<\ngGYABCJSMURbRGQbgUkkAhP<\ngGYABCJSMURbTGQbgM[kAhP<\ngGYABCJSMURdTGQbgU[kAhP<\ngGYABCJSMURdTGQbgU[kAhP>\ngGYABIJSMUHGVbkM}`g]v>\ngGYABIJSMUHGVbkM}`g]z>\ngGYABIJSMUHGVbkV]EN[{AO[l>\ngGYADArSMSPGUbgIZytTyomtah_vb@\ngGYADArS]L@GTc]G]v=\ngGYADEJSMTDbGRcf~pSn}ZH<\ngGYADEJS]L@GTc_Ki{^`=\ngGYAJKJSSUPGQbgI[kAHP\ngGYALMJRuUPGQbdm[hahP\ngGYDJQDJHR[jf@zT\\`\ngGYHBaxIMtp@]RMt]wX\ngGYHDIPIMuP@]RN]EI[h{oP>\ngGYHDPDIMts@]ZVZwpvmtH\ngGYHDQxILuUJIP]FJ\\uoa{^o`>\ngGYHE@DIUsUPH]TJ\\ek_[qCPmD-\ngGYHE@DYICF``Pz`[h{np+\ngGYHEAxIU[U@]TJ]Fk_XICPmD\ngGYHEAxIU[U@]TJ]Fm_XICPmD\ngGYHHPDILuS@]FJ\\uoa{Ah_vd@\ngGYHHPDILuS@]FJ\\ushiK_CvCPmH\ngGYHHPDILuS@]FJ\\voa{Ah_vd@\ngGYHHPDILuS@]FJ\\vshiK_CvCPmH\ngGYHHPDILuS@]FJ]Uoa{Ah_vd@\ngGYHHPDILuS@]FJ]UshiK_CvCPmH\ngGYHHPDILuS@]FJ]UshiK_CvC__mH\ngGYHHPDILuT`]FJ\\uoa{Ao_vd@\ngGYHHPDILuUQP]FJ\\ushiK_CvCPmH<\ngGYHHPxILuS@]FJ\\ushiK_CvCPmH\ngGYHJPDILuK@]JR[h[vp\ngGYHJPDILuK@]JR[h[wP\ngGYHJPDILuK@]JR\\zJRwPwn`\ngGYHJPDILuK@]ZJ\\`\ngGYHJPDILuK@]ZJ\\wfz\ngGYHJPDILuK@]ZJ\\ypXe@\ngGYHJPDILuL`]JRkd[vsn{@\ngGYHJPDILuL`]JRkd[wSn{@\ngGYHJPDILuSRH]ZJ\\wfB<\ngGYHJQDILuK@]ZJ\\ytTeoMt\ngGYHJQHILuK@]ZJ\\ytTe@\ngGYHJQHILuSRH]ZJ\\wfB>\ngGYHK@xIUMU@]TLTyK_HNB_@\ngGYHKAxIU[U@]DJ\\enlDa@\ngGYHKAxIU[U@]DJ\\erXirVzpRD\ngGYHKAxIU[U@]DJ]FnlDa@\ngGYHL`DIMsU@]FNRunbFaZX=\ngGYHL`DIMtu@]FNRunbFaZX=\ngGYHdIPSeJSWUTbGQcdm[hahP<\ngGYHdIPSeJSWUTbGQcdm[hahP>\ngGYHlEPKmJUuUPGUCEIkYpXiohDahP\ngGYHlEPKmJUuUPGUCIIkYpXiohDahP\ngGYIHEPKdkjj`NjENcVolDahP\ngGYILEPKdkjj`NjFJSVs`qS_PICP`\ngGYLcaHR`TaNLiM]U@]ZNZyr\\eoJD\ngGYLcaHR`TaNLiM]U@]ZN[Yr\\eoJD\ngGY`JDTfyi`NeGH\ngGY`LDTfyj`NmGM[raZX\ngGY`hDYJyInZdCiQu]G]w~t`\ngGY`hDYJyInZjZCkQsV|h_vd@>\ngGYhCE`DYIHUj@zp\\uoJD\ngGYhCE`DYIHUj@zp\\usdyK^TH\ngGYhCE`DYIHUj@zp\\voJD\ngGYhCE`DYIHUj@zp\\vsdyK^TH\ngGYhCE`DYIIUi@zpRusdyK^Wo{P`\ngGYhCE`DYIIUj@zpRuoJG}hP\ngGYhCE`DYIIUj@zpRusdyK^TO{P`\ngGYhCE`DYIIUj@zpRusdyK^Ww{P`\ngGYhCEaxIU[UPH]XJZweB<\ngGYhCEaxIU[UPH]XJZweB>\ngGYhCEaxIU[UPH]XJZytTeoJD<\ngGYhCEaxIU[UPH]XJZytTeoJD>\ngGYhCEaxIU[UPH]XJ[WeB<\ngGYhCEaxIU[UPH]XJ[WeB>\ngGYhCEaxYIIVj@zpRuoJG}hP\ngGYhCEaxYIIVj@zpRvoJG}hP\ngGYhKE`DYIHUj@zp\\foBD\ngGYhjLUPKkJUuUPGVCEMy@`\ngGYhjLUPKkJUuUPGVCIMy@`\ngGYhjLUPKkJUuUPGVCIN\\FI[rA@\ngGYhkEax[kNRRUjhDNdDh<\ngGYhkEax[kNRRUjhDNdDh>\ngGYiKE`D[lddju@]HIP\ngG\\@@ZdsDLAuDwPwm`\ngG\\@@ZdsMLAtiInao]@\ngG\\@@ZdwATAuLwPvm`\ngG\\@@bdsDTAtduoao[h_vb@\ngG\\@@bdsDTAuEWHwmg]w~tP\ngG\\@@bdsDTAuEWHwmg]{~tP\ngG\\@@bdsDTAuEWHwng]{~tP\ngG\\@@bdsMTAtXisWNCDmu`tO{Q@\ngG\\@@bdsMTAtXisWNCGMu`tO{Q@\ngG\\@@bdsMTAtXiuWNCGMu`tO{Q@\ngG\\@@bdwA@AnQm[N{l=\ngG\\@@bdwM@AuIWHvmg]v\ngG\\@@bdwM@AuIWHvng]v\ngG\\@@bdwMLAtiZnQm[N{t\ngG\\@@bdwMLAtiZnQm]N{t\ngG\\@@bdwMUMAuiYk_CZ{P`>\ngG\\@@ldsMTAtXiKVzHZG}h`=\ngG\\@@ldsMTAtXiKWMCENRwQCPmD=\ngG\\@@ldsMTAtXiKWMCENRwpzPtO{Q@=\ngG\\@@ldsMTAtXiKWNCGMtPtO{Q@\ngG\\@@ldsMTAtXiKWNbgMtPtO{Q@\ngG\\@@ldsMTAtXiK[NCGMtPtO{Q@\ngG\\@@ldsMTAtXiK[NbgMtPtO{Q@\ngG\\@@ldsMTAtYIKVyF}lah_vb@=\ngG\\@@ldsMTAthjoat}o_vb@=\ngG\\@@ldwATAuMWHvmg]w~tp=\ngG\\@@ldwATAuMWHvmgm{~tp=\ngG\\@@ldwATAulek\\cZvPtO{S@=\ngG\\@@ldwATAulem\\cZvPtO{S@=\ngG\\@@ldwATAulfm\\cZvPtO{S@=\ngG\\@ABeWURAuaIk_S^{^m@\ngG\\@ABeWUUDatPisWIbgI[kAh_v`@<\ngG\\@ABeWUUDatPisWIbgI[kAh_v`@>\ngG\\@ABeWUUDauaIk_S^{Pm@<\ngG\\@ABeWUUDauaIk_S^{Pm@>\ngG\\@ABeWUUDauaIm_S^wPm@<\ngG\\@ABeWUUDauaIm_S^wPm@>\ngG\\@ABeWUUDauaIm_S^{Pm@<\ngG\\@ABeWUUDauaIm_S^{Pm@>\ngG\\@AEddLj@CjBnYm[N{o}h@=\ngG\\@AEddLj@CjBnYm[N{w}h@=\ngG\\A@ZIRYb@@wHwmg]v=\ngG\\A@lIRYfj@zLTek]DMC~tP=\ngG\\A@lIRYfj@zLTek_CiCPmD=\ngG\\A@lIRYfj@zLTekfabgI[hah_vb@=\ngG\\A@lIRYfj@zLTekgAcf~GRFaZH\ngG\\DEb@b^BSRuPGVbfmy__dd\\[Q@\ngG\\DEb@b^BSRuPGVbfuyPmD\ngG\\EebDR^@yRYRZyjdPzt\\unev~IPxvf@>\ngG\\H@[jCIHYUPGQCEN[jAPP\ngG\\HEb@aIfZhCkQSV|h_vb@\ngG\\HEb@aInfhCkRsV~FunaZX\ngG\\HHlOAJfjhChabVmtPtH\ngG\\HHlOAJfjhChabVutPtO{R@\ngG\\IHl@`ReSUTAtPqKVzHZD\ngG\\`hZEIWIMsS@]JN_vd@\ngG\\`hZEIWIMsS@]JNkh{nvd@\ngG\\`hZEIWIMsS@]JNkh{o_vd@\ngG\\ahZEIWWdfyi`NeGUt]w_{R@\ngG]@DZDfyi`NeGUt]wX\ngG]@DZDfyi`NeGUt]wh\ngG]@EbDfYj`NmEM[raZH\ngG]@EbDfYj`NmEM\\zJ\\weC~tP\ngG]@LZDejj`NeEH\ngG]HEcAxIULE@]JM[y[vzD\ngG]HEcAxIULE@]JM\\xNRwrwmtH\ngG]HEcAxIULE@]JMlxNRwrwmtH\ngG]HEcAxIU[U@]XJZweC~tP\ngG]HEcAxIU[U@]XJ[WeC~tP\ngG]HEcAxYIIXJ@zQZyp\\eoeo[h_va@\ngG]HlZEPKmJUuUPGVCIMy@`\ngJP@DjXDCiQK]K^v=\ngJP@DjXDCiQK]K^z\ngJP@DjXDCiQK]Knz=\ngJP@DjXDCiQK_K^v^`=\ngJP@DjXDCiQK_K^z^`\ngJP@DjXDCiQK_Knz^`=\ngJP@DjXDCiQKgASfzV}t\ngJP@DjXDCiQKgASf~V}t}@\ngJP@DjXDCiQKgAcfzW]t\ngJP@DjXDCiQKgAcf~W]t}@\ngJP@DjYdCjabgI[i]pP\ngJP@DjYdCjabgI[i]w`\ngJP@DjYdCjabgI[kAOP\ngJP@DjYdCjabgI[sA@\ngJP@DjYdCjabgI[y]pSt\ngJP@DjYdCjabgI\\xJ\\wR{``\ngJP@DjYdCjabgI\\xJ\\wR{o@\ngJP@DjYdCjabgI\\xJ\\wVB^`\ngJP@DjYdCjabgI\\xJ\\wV|^`\ngJP@DjYdCjabgI\\xJ\\wfB\ngJP@DjYdCjabgI\\xJ\\wf|\ngJP@DjYdCjabgI\\xJ\\wr{`gh\ngJP@DjYdCjabgI\\xJ\\wr{oGh\ngJP@DjYdCjabgI\\xL\\wR{``\ngJP@DjYdCjabgI\\xL\\wR{o@\ngJP@DjYdCjabgI\\xL\\wVB^`\ngJP@DjYdCjabgI\\xL\\wV|^`\ngJP@DjYdCjabgI\\xL\\wfB\ngJP@DjYdCjabgI\\xL\\wf|\ngJP@DjYdCjabgI\\xL\\wr{`gh\ngJP@DjYdCjabgI\\xL\\wr{oGh\ngJP@DjYdCjabgQ[i]pP\ngJP@DjYdCjabgQ[sA@\ngJP@DjYdCjabgQ[y]pSt\ngJP@DjYdCjabgQ\\xJ\\wR{``\ngJP@DjYdCjabgQ\\xJ\\wr{`gh\ngJP@DjYdCjabgQ\\xL\\wVB^`\ngJP@DjYdCjabgQ\\xL\\wr{`gh\ngJP@DjYdCkBbVzV}l\ngJP@DjYdCkBbVzV}t\ngJP@DjYdCkBbVzW]l\ngJP@DjYdCkBbVzW]t\ngJP@DjYdCkBbV~V}t}@\ngJP@DjYdCkBbV~W]t}@\ngJP@DjZhCjabgI[yApRD\ngJP@DjZhCjabgI[yApRG|eBb\ngJP@DjZhCjabgI[yApSx\ngJP@DjZhCjabgI[y^wbD\ngJP@DjZhCjabgI\\dLTyodGAHP\ngJP@DjZhCjabgI\\dLTyodGAO`\ngJP@DjZhCjabgI\\dLTyoe{^HP\ngJP@DjZhCjabgIkyApRD\ngJP@DjZhCjabgIldLTyodGAHP\ngJP@DjZhCjabkQ[yApRD\ngJP@DjZhCjabkQ\\dLTyodGAHP\ngJP@DjZhCjabkQ\\dLTyodGAO`\ngJP@DjZhCjabkQkyApRD\ngJP@DjZjACjabgI[yAwbD<\ngJP@DjZjACjabgI[yAwbD>\ngJP@DjZjACjabgI[yAwbG|eBb>\ngJP@DjZjACjabgI[yAwcx<\ngJP@DjZjACjabgI\\dLTyodG^HP<\ngJP@DjZjACjabgI\\dLTyodG^HP>\ngJP@DjZjACjabgI\\dLTyodG^H_rTJH<\ngJP@DjZjACjabgI\\dLTyodG^H_rTJH>\ngJP@DjZjACjabgI\\dLTyodG^O`<\ngJP@DjZjACjabgI\\dLTyodG^O`>\ngJP@DjZjACjabgI\\xJ\\wrCoDH<\ngJP@DjZjACjabgI\\xJ\\wrCoDH>\ngJP@DjZjACjabgI\\xJ\\wrCoDOyJED<\ngJP@DjZjACjabgI\\xJ\\wrCoDOyJED>\ngJP@DjZjACjabgI\\xJ\\wrCoGp<\ngJP@DjZjACjabgI\\xJ\\wrCoGp>\ngJP@DjZjACjabgI\\xL\\wrC`dH<\ngJP@DjZjACjabgI\\xL\\wrC`dH>\ngJP@DjZjACjabgI\\xL\\wrC`dOyJED<\ngJP@DjZjACjabgI\\xL\\wrC`dOyJED>\ngJP@DjZjACjabgI\\xL\\wrC`gp<\ngJP@DjZjACjabgI\\xL\\wrC`gp>\ngJP@DjZjACjabgI\\xL\\wrCoDH<\ngJP@DjZjACjabgI\\xL\\wrCoDH>\ngJP@DjZjACjabgI\\xL\\wrCoDOyJED<\ngJP@DjZjACjabgI\\xL\\wrCoGp<\ngJP@DjZjACjabgI\\xL\\wrCoGp>\ngJP@DjZjACjabgI\\xL\\wr}oDH<\ngJP@DjZjACjabgI\\xL\\wr}oDH>\ngJP@DjZjACjabgI\\xL\\wr}oGp<\ngJP@DjZjACjabgI\\xL\\wr}oGp>\ngJP@DjZjACjabgIkyAwbD<\ngJP@DjZjACjabgIkyAwbD>\ngJP@DjZjACjabgIldLTyodG^H_rTJH<\ngJP@DjZjACjabgIlxJ\\wrCoDH<\ngJP@DjZjACjabgIlxJ\\wrCoDH>\ngJP@DjZjACjabgIlxL\\wrC`dH<\ngJP@DjZjACjabgIlxL\\wrC`dH>\ngJP@DjZjACjabgIlxL\\wrCoDH<\ngJP@DjZjACjabgIlxL\\wr}oDH<\ngJP@DjZjACjabgIlxL\\wr}oDH>\ngJP@DjZjACjabgQ[yApRD<\ngJP@DjZjACjabgQ[yApRD>\ngJP@DjZjACjabgQ[yApSx>\ngJP@DjZjACjabgQ\\dLTyodGAHP<\ngJP@DjZjACjabgQ\\dLTyodGAHP>\ngJP@DjZjACjabgQ\\dLTyodGAO`>\ngJP@DjZjACjabgQ\\xJ\\wrC`dH<\ngJP@DjZjACjabgQ\\xJ\\wrC`dH>\ngJP@DjZjACjabgQ\\xJ\\wrC`gp>\ngJP@DjZjACjabgQ\\xL\\wrC`dH<\ngJP@DjZjACjabgQ\\xL\\wrC`dH>\ngJP@DjZjACjabgQ\\xL\\wrC`gp<\ngJP@DjZjACjabgQ\\xL\\wrC`gp>\ngJP@DjZjACjabgQkyApRD<\ngJP@DjZjACjabgQkyApRD>\ngJP@DjZjACjabgQlxJ\\wrC`dH<\ngJP@DjZjACjabgQlxL\\wrC`dH<\ngJP@DjZjACjabgQlxL\\wrC`dH>\ngJP@DjZjACjabkI[yAwbD<\ngJP@DjZjACjabkI[yAwbD>\ngJP@DjZjACjabkI\\xJ\\wrCoDH<\ngJP@DjZjACjabkI\\xJ\\wrCoDH>\ngJP@DjZjACjabkI\\xJ\\wrCoGp<\ngJP@DjZjACjabkI\\xJ\\wrCoGp>\ngJP@DjZjACjabkQ\\xL\\wrC`dH<\ngJP@DjZjACjabkQ\\xL\\wrC`dH>\ngJP@DjZjACjabkQ\\xL\\wrC`gp<\ngJP@DjZjACjabkQ\\xL\\wrC`gp>\ngJP@DjvhCjabgI[kAHP\ngJP@DjvhCjabgI[kAO`\ngJP@DjvhCjabgI[k^HP\ngJP@DjvhCjabgI[z]pRD\ngJP@DjvhCjabgI[z]pSx\ngJP@DjvhCjabgI[z]wbD\ngJP@DjvhCjabgI\\xL\\wVBP`\ngJP@DjvhCjabgI\\xL\\wVB_@\ngJP@DjvhCjabgI\\xL\\wV|P`\ngJP@DjvhCjabgI\\xL\\wt{`dH\ngJP@DjvhCjabgI\\xL\\wt{`gp\ngJP@DjvhCjabgI\\xL\\wt{oDH\ngJP@DjvhCjabgI\\zJ\\wVBP`\ngJP@DjvhCjabgI\\zJ\\wVB_@\ngJP@DjvhCjabgI\\zJ\\wV|P`\ngJP@DjvhCjabgI\\zJ\\wV|_@\ngJP@DjvhCjabgI\\zJ\\wt{`dH\ngJP@DjvhCjabgI\\zJ\\wt{`gp\ngJP@DjvhCjabgI\\zJ\\wt{oDH\ngJP@DjvhCjabgI\\zJ\\wt{oGp\ngJP@DjvhCjabgIkkAHP\ngJP@DjvhCjabgIkz]pRD\ngJP@DjvhCjabgIlxL\\wt{`dH\ngJP@DjvhCjabgQ[kAHP\ngJP@DjvhCjabgQ[z]pRD\ngJP@DjvhCjabgQ\\xL\\wVBP`\ngJP@DjvhCjabgQ\\xL\\wVB_@\ngJP@DjvhCjabgQ\\xL\\wt{`dH\ngJP@DjvhCjabgQ\\xL\\wt{`gp\ngJP@DjvhCjabgQ\\zJ\\wt{`dH\ngJP@DjvhCjabgQkz]pRD\ngJP@DjvhCkBRV~f}la@\ngJP@DjvhCkBRV~f}ta@\ngJP@DjvhCkBRV~f}t~@\ngJP@DjvhCkBRV~g]la@\ngJP@DjvhCkBRV~g]ta@\ngJP@DjvhCkBRWNCGM}N{YB\ngJP@DjvhCkBRWNCGM}N{Y|\ngJP@DjvhCkBRWNCGM}N{iB\ngJP@DjvhCkBRWNCGM}N{i|\ngJP@DjvhCkBRWNbgM}M{iB\ngJP@DjvhCkBRWNbgM}M{i|\ngJP@DjvhCkBRWNbgM}N{iB\ngJP@DjvhCkBRZ~f}ta@\ngJP@DjvhCkBRZ~g]ta@\ngJP@DkfhCjabgI[kAHP\ngJP@DkfhCjabgI[kAH_rRNH\ngJP@DkfhCjabgI[z]pRD\ngJP@DkfhCjabgI\\dLTynlDa@\ngJP@DkfhCjabgI\\dLTyoiwAHP\ngJP@DkfhCjabgQkkAHP\ngJP@DkfhCjabgQkz]pRD\ngJP@DkfjICjabgI[kAO`<\ngJP@DkfjICjabgI[kAO`>\ngJP@DkfjICjabgI[z]pSx<\ngJP@DkfjICjabgI[z]pSx>\ngJP@DkfjICjabgI\\dLTynlD~@<\ngJP@DkfjICjabgI\\dLTynlD~@>\ngJP@DkfjICjabgI\\dLTyoiwAO`<\ngJP@DkfjICjabgI\\dLTyoiwAO`>\ngJP@DkfjICjabgI\\xLTwVBP`<\ngJP@DkfjICjabgI\\xLTwVBP`>\ngJP@DkfjICjabgI\\xLTwVB_@<\ngJP@DkfjICjabgI\\xLTwVB_@>\ngJP@DkfjICjabgI\\xLTwV|_@<\ngJP@DkfjICjabgI\\xLTwV|_@>\ngJP@DkfjICjabgI\\xLTwt{`dH<\ngJP@DkfjICjabgI\\xLTwt{`dH>\ngJP@DkfjICjabgI\\xLTwt{`gp<\ngJP@DkfjICjabgI\\xLTwt{`gp>\ngJP@DkfjICjabgI\\xLTwt{oGp<\ngJP@DkfjICjabgI\\xL\\wVB_@<\ngJP@DkfjICjabgI\\xL\\wVB_@>\ngJP@DkfjICjabgI\\xL\\wt{`gp<\ngJP@DkfjICjabgI\\xL\\wt{`gp>\ngJP@DkfjICjabgIkkAHP<\ngJP@DkfjICjabgIkkAHP>\ngJP@DkfjICjabgIkz]pRD<\ngJP@DkfjICjabgIkz]pRD>\ngJP@DkfjICjabgIldLTynlDa@<\ngJP@DkfjICjabgIldLTynlDa@>\ngJP@DkfjICjabgIlxLTwVBP`<\ngJP@DkfjICjabgIlxLTwVBP`>\ngJP@DkfjICjabgIlxLTwt{`dH<\ngJP@DkfjICjabgIlxLTwt{`dH>\ngJP@DkfjICjabgQ[kAO`<\ngJP@DkfjICjabgQ[kAO`>\ngJP@DkfjICjabgQ\\xL\\wt{`gp<\ngJP@DkfjICjabgQ\\xL\\wt{`gp>\ngJP@DkfjICjabgQlxLTwVBP`<\ngJP@DkfjICjabgQlxLTwVBP`>\ngJP@LdaB`Nedm}MkYB=\ngJP@LdaB`Nedm}MkY|=\ngJP@LdaB`Nedm}MkiB\ngJP@LdaB`Nedm}Mki|\ngJP@LdaB`Nedm}NkiB=\ngJP@LdaB`Nedm}Nki|=\ngJP@LdaB`Nedn\\EN[z]WRD\ngJP@LdaB`Nedn\\EN[z]WSx\ngJP@LdaB`Nedn]EN[z[WRD\ngJP@LdaB`Nedn]EN[z[WSx\ngJP@LdaB`Nedu}MkYB=\ngJP@LdaB`Nedu}MkiB\ngJP@LdaB`Nedu}NkiB=\ngJP@LdaB`Nedv\\EN[z]WRD\ngJP@LdaB`Nedv]EN[z[WRD\ngJPAEJUsTAuPqSdv\\FJ[kAHP>\ngJPAMJULrAuPqSdn\\EN[sA@\ngJPBABPHPQ`aJfj@zpXeoBD\ngJPBABRHPQ`aJnj@zpTeoBD>\ngJPD@DHHRYZ`NcENRwVBP`\ngJPD@DHHRYZ`NcENbwVBP`\ngJPD@DHHR[j`NmGI[pa@\ngJPD@DHHR[j`NmGI[x^WbD\ngJPD@DJ`Rfh@NhFzvsl=\ngJPD@DPHRnh@NhFzvsl=\ngJPD@DPHRnh@NhFzvst\ngJPD@DPHRnh@NhFzwSt=\ngJPD@DPHRnh@NhGNCGMumgh\ngJPD@DPHRni`NdEUungh\ngJPD@DPHRni`NdEV\\FN[k]OP\ngJPD@DPHRnj`NbENRwVBP`\ngJPD@DSpRnh@NhF~gml{@=\ngJPD@DXHRfjPNbFJRwRB^`\ngJPD@DXHRfjPNbFJRwbB\ngJPD@DXHRfjPNbFJRypXyndD}@\ngJPD@DXHRfjPNbFJbwRB^`\ngJPD@DXHRfjPNbFJbypXyndD}@\ngJPD@DXHRfjPNlFR[yAvsl\ngJPD@DXHRfjPNlFR[yAvst\ngJPD@DXHRfjPNlFRkyAvsl\ngJPD@DXHRfjPNlFRkyAvst\ngJPD@DXHRfjPNlFRlxL\\wrCmgh\ngJPD@DXHRfjiDNbFJRypXindDa@<\ngJPD@DXHRfjiDNbFJRypXindDa@>\ngJPD@DXHRfjiDNbFJSYpXindDa@<\ngJPD@DXHRfjiDNbFJSYpXindDa@>\ngJPD@VPlRnh@NhFzvst\ngJPD@bQDRnh@NhFzvsl=\ngJPD@bQDRnh@NhFzvst\ngJPD@bSpRnh@NhF~gml{@=\ngJPDAxGpRij`NbFJmWRC``\ngJPDAxSpRnX@NhFzwSt=\ngJPE@bSpdiWT@GTC_Svv]`=\ngJPH@DIKT@GTc][Yv=\ngJPH@DIKT@GTc][Yz\ngJPH@DIKT@GTc][iz=\ngJPH@DIKT@GTc_Cvv]`=\ngJPH@DIKT@GTc_Cvv^`\ngJPH@DIKT@GTcgAcfzvst\ngJPH@DIKTpGQbgI\\xLTwVzP`\ngJPH@DIKTpGQbgIkpa@\ngJPH@DIKUPGQbgI[kAHP\ngJPH@DIKUPGQbgI[x^pRD\ngJPH@DIKUTRGQbgI\\xLTwVBP`<\ngJPH@DIKUTRGQbgI\\xLTwVBP`>\ngJPH@DILmHGQbgI\\zJ\\wVB^`\ngJPH@DILmHGQbgI\\zJ\\wfB\ngJPH@DILthGVddmtM{X\ngJPH@DILthGVddmtM{h\ngJPH@DILthGVddm|M{Yz\ngJPH@DILthGVddm|M{iz\ngJPH@DILuTbGQbgI[kAHP<\ngJPH@DILuTbGQbgI[kAHP>\ngJPH@DILuTbGQbgI[x^pRD<\ngJPH@DILuTbGQbgI\\xL\\wVBP`<\ngJPH@DILuTbGQbgI\\xL\\wVBP`>\ngJPH@DILuTbGQbgI\\zJ\\wVBP`<\ngJPH@DILuTbGQbgI\\zJ\\wVBP`>\ngJPH@DILuTbGQbgI\\zJ\\wV|P`<\ngJPH@DILuTbGQbgI\\zJ\\wV|P`>\ngJPH@DILuTbGQbgI\\zJ\\wp}`dH<\ngJPH@DILuTbGQbgI\\zJ\\wp}`dH>\ngJPH@DILuTbGQbgQ[kAHP>\ngJPH@DILuTbGQbgQ\\xL\\wVBP`<\ngJPH@DILuTbGQbgQ\\xL\\wVBP`>\ngJPH@DIMsPGQbgI\\zJ\\wRzP`\ngJPH@DIMsPGVedm|MkYB\ngJPH@DIMsPGVedm|MkiB\ngJPH@DIMsPGVedn]EN[x[WRD\ngJPH@DIMsPGVedu|MkiB\ngJPH@DIST@GRBf~P]l{@=\ngJPH@DIST@GRBf~P]l}@\ngJPH@DIST@GRBf~P]t}@=\ngJPH@DIST@GRBf~Wml{@=\ngJPH@DIST@GRBf~Wml}@\ngJPH@DIST@GRBgNCEM|`{iz\ngJPH@DIST@GRBgNCGM|`{Yz\ngJPH@DIST@GRBgNCGM|o[Yz\ngJPH@DIST@GRBj~P]l{@=\ngJPH@DIST@GRBj~P]l}@\ngJPH@DIST@GRBj~P]t}@=\ngJPH@DIST@GRBkNCEM|`{iz\ngJPH@DIST@GRBkNCGM|`{Yz\ngJPH@DISTpGUCENRwRBP`\ngJPH@DISTpGUCENRwrCndH\ngJPH@DISTpGUCENRypXiodG]HP\ngJPH@DISTpGUCENRypXioe{]HP\ngJPH@DISTpGUCENSWrCndH\ngJPH@DISTpGUCENSYpXindDa@\ngJPH@DISTpGUCENSYpXiodG]HP\ngJPH@DISTpGUCEVRwRBP`\ngJPH@DISTpGUCEVRwrCndH\ngJPH@DISTpGUCEVRypXiodG]HP\ngJPH@DISTpGUCEVRypXyodG]HP\ngJPH@DISTpGUCEVSWrCndH\ngJPH@DISTpGVCIM|`{Yz\ngJPH@DISTpGVCIM|`{iv\ngJPH@DISTpGVCIM|`{iz\ngJPH@DISTpGVCIN\\FN[yAwSt\ngJPH@DISTpGVCIU|`{Yz\ngJPH@DISTpGVCIU|`{iz\ngJPH@DISUPGUCENRwrC`dH\ngJPH@DISUPGUCEVRwrC`dH\ngJPH@DISUTbGUCENRypXiodGAHP<\ngJPH@DISUTbGUCENRypXiodGAHP>\ngJPH@DISUTbGUCENSWrC`dH<\ngJPH@DISUTbGUCENSWrC`dH>\ngJPH@DISUTbGUCENSYHXis_HNBP`<\ngJPH@DISUTbGUCENSYpXiodGAHP<\ngJPH@DISUTbGUCENSYpXiodGAHP>\ngJPH@DISUTbGUCEVRwrC`gp>\ngJPH@DISUTbGUCEVRypXiodGAHP<\ngJPH@DISUTbGUCEVSWrC`dH<\ngJPH@DISUTbGUCEVSWrC`dH>\ngJPH@DISUTbGUCEVSYpXiodGAHP<\ngJPH@DISUTbGUCEVSYpXiodGAHP>\ngJPH@VIST@GRBj~P]l{@=\ngJPH@VIST@GRBj~P]l}@\ngJPH@VIST@GRBj~P]t}@=\ngJPH@VISTpGUCENSYpXiodG]HP\ngJPH@bIKT@GTc][Yv=\ngJPH@bIKT@GTc][Yz\ngJPH@bIKT@GTc][iz=\ngJPH@bIMsPGVedm|MkiB\ngJPH@bIST@GRBf~P]l{@=\ngJPH@bIST@GRBf~P]l}@\ngJPH@bIST@GRBf~Wml{@=\ngJPH@bIST@GRBj~P]l{@=\ngJPH@bIST@GRBj~P]l}@\ngJPH@bIST@GRBj~P]t}@=\ngJPH@bIST@GRBkNCGM|`{Yz\ngJPH@bISTpGUCEVRwrCndH\ngJPH@bISTpGUCEVSWrCndH\ngJPH@bISTpGVCIU|`{iz\ngJPH@bISUPGUCEVRwrC`dH\ngJPH@xIKT@GTc][iz=\ngJPH@xIKT@GTc_Cvv]`=\ngJPH@xIKT@GTc_Cvz^`=\ngJPH@xIKUPGQbgI[x^pRD\ngJPH@xILuTbGQbgI[x^pRD<\ngJPH@xILuTbGQbgI[x^pRD>\ngJPH@xILuTbGQbgI\\zJ\\wp}`dH<\ngJPH@xILuTbGQbgI\\zJ\\wp}`dH>\ngJPH@xIMsPGQbgI[x^WRD\ngJPH@xITuPGUCENRwrC`dH\ngJPH@xITuPGUCENSWrC`dH\ngJPHABIKT@GTcgAcfzvst\ngJPHADIKT@GTc][Yv=\ngJPHADIKT@GTc][Yz\ngJPHADIKUPGQbgI[kAHP\ngJPHADILthGQbgI\\zJ\\`\ngJPHADILuTbGQbgI[kAHP<\ngJPHADILuTbGQbgI[kAHP>\ngJPHADILuTbGQbgI\\zJ\\wVBP`<\ngJPHADILuTbGQbgI\\zJ\\wVBP`>\ngJPHADILuTbGQbgI\\zJ\\wV|P`<\ngJPHADILuTbGQbgI\\zJ\\wV|P`>\ngJPHAHILuLbGQbgI[sA@>\ngJPHAHILuTbGQbgI[kAHP<\ngJPHAHILuTbGQbgI[kAHP>\ngJPHAHILuTbGQbgI\\zJ\\wVBP`<\ngJPHAHILuTbGQbgI\\zJ\\wVBP`>\ngJPHAVIKUPGQbgI[kAHP\ngJPHAVILuTbGQbgI\\zJ\\wVBP`<\ngJPHAVILuTbGQbgI\\zJ\\wVBP`>\ngJPHAbIKT@GTc][Yv=\ngJPHAbIKT@GTc][Yz\ngJPHAbIKT@GTc][iz=\ngJPHAbIKTpGQbgI[k]HP\ngJPHAbIKTpGQbgI[pa@\ngJPHAbILuTbGQbgI[kAHP<\ngJPHAbILuTbGQbgI[kAHP>\ngJPHAbILuTbGQbgI\\zJ\\wVBP`<\ngJPHAbILuTbGQbgI\\zJ\\wVBP`>\ngJPHAbILuTbGQbgI\\zJ\\wVB_@>\ngJPHAbILuTbGQbgI\\zJ\\wV|P`<\ngJPHAbILuTbGQbgI\\zJ\\wV|P`>\ngJPHAxIKT@GTc][Yv=\ngJPHAxIKT@GTc][Yz\ngJPHAxIKT@GTc_Cvv]`=\ngJPHAxIKT@GTc_Cvv^`\ngJPHAxIKT@GTc_Cvz^`=\ngJPHAxIKTpGQbgI\\xLTwVzP`\ngJPHAxIKTpGQbgI\\xLTwp}ndH\ngJPHAxIKUPGQbgI[x^pRD\ngJPHAxILuTbGQbgI[x^pRD<\ngJPHAxILuTbGQbgI\\xL\\wVBP`<\ngJPHAxILuTbGQbgI\\xL\\wVBP`>\ngJPHAxILuTbGQbgI\\xL\\wp}`dH>\ngJPHAxILuTbGQbgI\\zJ\\wVBP`<\ngJPHAxILuTbGQbgI\\zJ\\wVBP`>\ngJPHAxILuTbGQbgI\\zJ\\wp}`dH<\ngJPHAxILuTbGQbgI\\zJ\\wp}`dH>\ngJPHAxILuTbGQbgQ[x^pRD<\ngJPHAxISR@GRBfzwSt=\ngJPHAxISR@GRBf~W]t}@=\ngJPHAxITuPGUCENRwrC`dH\ngJPHAxITuPGUCENSWrC`dH\ngJPHAxITuPGUCENSWr}oDH\ngJPHAxITuPGUCEVbwrC`dH\ngJPHAxITuPGUCEVcWrC`dH\ngJPHAxITuTBGUCENbwrC`dH<\ngJPHAxITuTBGUCENbwrC`dH>\ngJPHCPITuPGQCEN\\dLTyodGAO`\ngJPHEPIWUPGUCENcWtC`dH\ngJPHMPITsHGQCEI[i]worTJH\ngJPHMPITuTBGQCEI\\xJ\\wRBP`<\ngJPHMPITuTBGQCEI\\xJ\\wRBP`>\ngJPHMPITuTBGQCEI\\xJ\\wrCoDH<\ngJPHMPITuTBGQCEI\\xJ\\wrCoDH>\ngJPHMPITuTBGQCEI\\xL\\wRBP`<\ngJPHMPITuTBGQCEI\\xL\\wRBP`>\ngJPHMPITuTBGQCEI\\xL\\wrCoDH<\ngJPHMPITuTBGQCEI\\xL\\wrCoDH>\ngJPHMPYIBE@]KIkz[WRD\ngJPI@DBTjZhCjabgI[yApRD\ngJPIAVBTij@CiAS_HNv]`=\ngJPIAVBTij@CiAS_Kvv^`\ngJPIAVBTij@CiAU_HNv]`=\ngJPIAVBTij@CiAU_HNv^`\ngJPIAVBTij@CiAU_HNz^`=\ngJPIAxBTej@CjQoa{[Np=\ngJPIAxBTej@CjQoa{[OP\ngJPIAxBTfZjQChqSdn]EN[kAHP<\ngJPIAxBTfZjQChqSdn]EN[kAHP>\ngJPIAxBTfZjQChqSdn]EN[x^pRD<\ngJPIAxBTfZjQChqSdn]EN[x^pRD>\ngJPIAxBTjZhCjabkQ[yApRD\ngJPIMPZTjZjAChabdn\\EN[yAwbD<\ngJPIMPZTjZjAChabdn\\EN[yAwbD>\ngJPIMP[djZjAChabdn\\EN[iAHP<\ngJPIMP[djZjAChabdn\\EN[iAHP>\ngJPIMP[djZjAChabdn\\EN[yAwbD<\ngJPIMP[djZjAChabdn\\EN[yAwbD>\ngJPIMP[djZjAChabdn\\FN[yAwbD>\ngJPL@DHHpPdru@]ZJRwaB\ngJP`@TfVhCkQSf|pP\ngJP`@TfVhCkQSf|w`\ngJP`@TfVhCkQSgNbgMy``\ngJP`@TfVhCkQSj|pP\ngJP`@TfZjQCkQSf|pP<\ngJP`@TfZjQCkQSf|pP>\ngJP`@TfZjQCkQSf|w`<\ngJP`@TfZjQCkQSf|w`>\ngJP`@TfZjQCkQSgICEN[sA@>\ngJP`@TfZjQCkQSgNCGMy``<\ngJP`@TfZjQCkQSgNCGMy``>\ngJP`@TfZjQCkQSgNbgMy``<\ngJP`@TfZjQCkQSgNbgMy``>\ngJP`@TfZjQCkQSj|pP>\ngJP`@TfyhCiRs]CZv\ngJP`@TfyhCiRs]CZz\ngJP`@dfVhChqSdmu`dH\ngJP`@dfVhChqSdmu`gp\ngJP`@dfVhChqSdmuoDH\ngJP`@dfVhChqSdmuoGp\ngJP`@dfVhChqSdn]EN[kAHP\ngJP`@dfVhChqSdn]EN[kAO`\ngJP`@dfVhChqSdn]EN[k^HP\ngJP`@dfVhChqSdn]EN[k^O`\ngJP`@dfVhChqSduu`dH\ngJP`@dfVhChqSduuoDH\ngJP`@dfVhChqSdv]EN[kAHP\ngJP`@dfVhChqSdv]EN[k^HP\ngJP`@dfVhChqShmu`dH\ngJP`@dfVhChqShmu`gp\ngJP`@dfVhChqShn]EN[kAHP\ngJP`@dfVhChqShn]EN[kAO`\ngJP`@dfVhChqShuu`dH\ngJP`@dfVhChqShv]EN[kAHP\ngJP`@dfvdCkQrT\ngJP`@dfvdCkQrV|OP\ngJP`@dfvdCkQrWNbgH\ngJP`@dfvdCkQrWNbgMx^`\ngJP`@dfvhCkQrV|HP\ngJP`@dfvhCkQrV|O`\ngJP`@dfvhCkQrWNbgMxP`\ngJP`@dfvhCkQrWNbgMx_@\ngJP`@dfvhCkQrZ|HP\ngJP`@dfzhCkQrV|HP\ngJP`@dfzhCkQrWICEN[pa@\ngJP`@dfzjQCkQrWNBgMxP`<\ngJP`@dfzjQCkQrWNBgMxP`>\ngJP`@dfzjQCkQrWNBgMx_@<\ngJP`@dfzjQCkQrWNBgMx_@>\ngJP`ADkjhChaSdnRFJ\\wVBP`\ngJP`ADkjjIChaSdn\\FJ[kAHP<\ngJP`AdefdCiQU][Yv\ngJP`AdijdChabdmt`gh\ngJP`AdijdChabdn\\FN[iAOP\ngJP`AdijdCkAdf~P]l}@\ngJP`AdijjQChabdmt`dH<\ngJP`AdijjQChabdmt`dH>\ngJP`AdijjQChabdmt`gp<\ngJP`AdijjQChabdmt`gp>\ngJP`AdijjQChabdmtoDH<\ngJP`AdijjQChabdmtoDH>\ngJP`AdijjQChabdnRFJ\\wRBP`<\ngJP`AdijjQChabdnRFJ\\wRBP`>\ngJP`AdijjQChabdn\\FJ[iAHP<\ngJP`AdijjQChabdn\\FJ[iAHP>\ngJP`AdijjQChabdn\\FJ[iAO`<\ngJP`AdijjQChabdn\\FJ[iAO`>\ngJP`AdijjQChabdn\\FN[iAHP<\ngJP`AdijjQChabdn\\FN[iAHP>\ngJP`AdijjQChabdn\\FN[iAO`<\ngJP`AdijjQChabdn\\FN[iAO`>\ngJP`AdijjQChabdn\\FN[i^O`<\ngJP`AdijjQChabdut`dH<\ngJP`AdijjQChabdut`dH>\ngJP`AdijjQChabdv\\FJ[iAHP<\ngJP`AdijjQChabdv\\FJ[iAHP>\ngJP`AdijjQChabdv\\FN[iAHP>\ngJP`AdijjQChabhmt`dH<\ngJP`AdijjQChabhmt`dH>\ngJP`AdijjQChabhn\\FN[iAHP<\ngJP`AdijjQChabhn\\FN[iAHP>\ngJPa@erS[RAuhyJ\ngJPa@erS[RAuhyK^Gh\ngJPa@erS[TAuhyK^DH\ngJPa@erS[TAuhyK^Gp\ngJPa@erS[TAuhyM^DH\ngJPa@mrSKTAtXitVzpRD\ngJPaAiJTuTAtPqRVzPRD>\ngJPdAePF`Rnj`NlFJ\\xLTwdB>\ngJPdAiPJ`Rfj`NlFI\\xLTwa|>\ngJPdAiPJ`Rfj`NlFIlxLTwR|P`>\ngJPdAiPJ`Rfj`NlFIlxLTwaB>\ngJPdHaBFDRij`NlFN\\dLTyoLD>\ngJPdHaVFlRij`NlFNksA@>\ngJPdI`xJ`RVj`NmEIkh^HP>\ngJPeI`VIDTiKUPGVbdutODH>\ngJPh@iPIMuHGVcdh\ngJPh@iPIMuHGVcdmx^`\ngJPh@iPIMuPGVcdmxP`\ngJPhAePIWUPGQCEIkjAHP>\ngJPhAePIWUPGQCEIlxLTwTBP`>\ngJPhAePIWUPGQCIIkjAHP>\ngJPhAePIWUPGQCIIlxLTwTBP`>\ngJPhAePIWUPGQCIIlxL\\wTBP`>\ngJPhDPDIMuTbGRcd<\ngJPhE`DIMsPGVcdmxP`\ngJPhHaVITuPGQCGQ[kAHP>\ngJPhI`xIKTpGVbdmtODH\ngJPhIaVIKTpGVbdmxP`\ngJPhIaVIKTpGVbdmx_@\ngJPhLPDIKTpGRbd\ngJPhLQDIKTpGRbd\ngJPhLQxIKTpGRbf|G`\ngJPhaePRUrTuTAu`qK]KqB>\ngJPhaePRUrTuTAu`qM]KqB>\ngJPhaePRUrTuTAu`qMgAbfzWbD>\ngJPi@cPGdfVhCkQSkNbgMu`gp\ngJPiLPDGdejXCiQR\ngJQ@@dlp@]RMumgX=\ngJQ@@dlp@]RMumgh\ngJQ@@dlp@]RMungh=\ngJQ@@dls@]FJ\\enmta@\ngJQ@@dls@]FJ\\eoBD\ngJQ@@dls@]FJ\\foBD\ngJQ@@dls@]JJkk[OP\ngJQ@@dls@]JJkk]Np\ngJQ@@dls@]JJkk]OP\ngJQ@@dlu@]FJ\\enlDa@\ngJQ@@dluQH]FJ\\enlD~@<\ngJQ@@dluQH]FJ\\enlD~@>\ngJQ@@dmP@]RMumgX=\ngJQ@@dmP@]RMumgh\ngJQ@@dmP@]RMungh=\ngJQ@@dmP@]RN\\FJ[k]OP\ngJQ@@dmP@]RN\\FN[k[OP\ngJQ@@dmS@]FJ\\enmta@\ngJQ@@dmS@]FJ\\eoBD\ngJQ@@dmS@]FJ\\eoCx\ngJQ@@dmS@]FJ\\es`qS][iB\ngJQ@@dmS@]FJ\\es`qs][iB\ngJQ@@dmS@]FJ\\es`qs^DH\ngJQ@@dmS@]FJ\\es`qs^Gp\ngJQ@@dmS@]FJ\\fnmta@\ngJQ@@dmS@]FJ\\foBD\ngJQ@@dmS@]JJkk[OP\ngJQ@@dmS@]JJkk]OP\ngJQ@@dmS@]JJlxL\\wVz^`\ngJQ@@dmU@]FJ\\enlDa@\ngJQ@@dmU@]FJ\\enlDaIHx`\ngJQ@@dmU@]FJ\\enmx~@\ngJQ@@dmU@]FJ\\erPqSfzpRD\ngJQ@@dmU@]FJ\\erPqSfzpRG|dcb\ngJQ@@dmU@]FJ]FnlDa@\ngJQ@@dmUQH]FJ\\enlD~@<\ngJQ@@dmUQH]FJ\\enlD~@>\ngJQ@@dmUQH]FJ\\enlD~IHx`>\ngJQ@@dmUQH]FJ\\es`qS]XIB<\ngJQ@@dmUQH]FJ\\es`qS]XIB>\ngJQ@@dmUQH]FJ\\es`qS]XI|<\ngJQ@@dmUQH]FJ\\es`qS]XI|>\ngJQ@@dmUQH]FJ\\es`qs]XI|<\ngJQ@@dmUQH]FJ\\es`qs]XI|>\ngJQ@@dmUQH]FJ\\fnlDa@<\ngJQ@@dmUQH]FJ\\fnlDa@>\ngJQ@@dmUQH]FJ\\fs`qS]XIB<\ngJQ@@dmUQH]FJ\\fs`qS]XIB>\ngJQ@@drt`]FJ\\enlD}@\ngJQ@@drt`]FJ\\enmx}@\ngJQ@@drt`]FJ\\eoLD\ngJQ@@drt`]FJ\\eoMx\ngJQ@@drt`]FJ\\eshis]XIz\ngJQ@@drt`]FJ\\eshis][qz\ngJQ@@drt`]FJ\\eshis^XH\ngJQ@@drt`]FJ\\eshis^[p\ngJQ@@drt`]FJ]EnlD}@\ngJQ@@drt`]FJ]EoLD\ngJQ@@drt`]FJ]Eshis]XIz\ngJQ@@drt`]FJ]Eshis^XH\ngJQ@@dru@]FJ\\enlDa@\ngJQ@@dru@]FJ\\enlD~@\ngJQ@@dru@]FJ\\enmxa@\ngJQ@@dru@]FJ\\eshis]XIB\ngJQ@@dru@]FJ\\eshis]XI|\ngJQ@@dru@]FJ\\eshis][qB\ngJQ@@dru@]FJ\\eshis][q|\ngJQ@@dru@]FJ\\fnlDa@\ngJQ@@dru@]FJ]EnlDa@\ngJQ@@dru@]FJ]EnlD~@\ngJQ@@dru@]FJ]Eshis]XIB\ngJQ@@dru@]FJ]Eshis]XI|\ngJQ@@dru@]FJ]FnlDa@\ngJQ@@dsR`]FJ\\e@\ngJQ@@dsR`]FJ\\eoCt\ngJQ@@dsR`]FJ\\eoMt\ngJQ@@dsR`]FJ\\eshir\ngJQ@@dsR`]FJ\\eshis][iz\ngJQ@@dsR`]FJ\\eshis^Gh\ngJQ@@dsR`]FJ\\eshis^[h\ngJQ@@dsR`]ZRRwPwm`\ngJQ@@dsR`]ZRRwpwmgh\ngJQ@@dsTrH]FJ\\enlD}@<\ngJQ@@dsTrH]FJ\\enlD}@>\ngJQ@@dsTrH]FJ\\eoLD<\ngJQ@@dsTrH]FJ\\eoLD>\ngJQ@@dsTrH]FJ\\eoMx<\ngJQ@@dsTrH]FJ\\eoMx>\ngJQ@@dsTrH]FJ\\erPqSfzpSt>\ngJQ@@dsTrH]FJ\\erPqSf|pP<\ngJQ@@dsTrH]FJ\\erPqSf|pP>\ngJQ@@dsTrH]FJ\\eshis]XIz<\ngJQ@@dsTrH]FJ\\eshis]XIz>\ngJQ@@dsTrH]FJ\\eshis][qz<\ngJQ@@dsTrH]FJ\\eshis][qz>\ngJQ@@dsTrH]FJ\\eshis^XH<\ngJQ@@dsTrH]FJ\\eshis^XH>\ngJQ@@dsTrH]FJ\\eshis^[p<\ngJQ@@dsTrH]FJ\\eshis^[p>\ngJQ@@dsURH]FJ\\enlDa@<\ngJQ@@dsURH]FJ\\enlDa@>\ngJQ@@dsURH]FJ\\enlD~@<\ngJQ@@dsURH]FJ\\enlD~@>\ngJQ@@dsURH]FJ\\enmxa@<\ngJQ@@dsURH]FJ\\enmxa@>\ngJQ@@dsURH]FJ\\enmx~@>\ngJQ@@dsURH]FJ\\erPqSfzpRD<\ngJQ@@dsURH]FJ\\erPqSfzpRD>\ngJQ@@dsURH]FJ\\erPqSfzpSx<\ngJQ@@dsURH]FJ\\erPqSfzpSx>\ngJQ@@dsURH]FJ\\erPqSfzwbD>\ngJQ@@dsURH]FJ\\erPqSfzwcx>\ngJQ@@dsURH]FJ\\es`qs]XIB<\ngJQ@@dsURH]FJ\\es`qs]XIB>\ngJQ@@dsURH]FJ\\es`qs]XI|<\ngJQ@@dsURH]FJ\\es`qs]XI|>\ngJQ@@dsURH]FJ\\es`qs][qB<\ngJQ@@dsURH]FJ\\es`qs][qB>\ngJQ@@dsURH]FJ\\eshis]XIB<\ngJQ@@dsURH]FJ\\eshis]XIB>\ngJQ@@dsURH]FJ\\eshis]XI|<\ngJQ@@dsURH]FJ\\eshis]XI|>\ngJQ@@dsURH]FJ\\eshis][qB<\ngJQ@@dsURH]FJ\\eshis][qB>\ngJQ@@dsURH]FJ\\eshis][qC~RAQ@>\ngJQ@@dsURH]FJ\\eshis][q|<\ngJQ@@dsURH]FJ\\eshis][q|>\ngJQ@@dsURH]FJ\\fnlDa@<\ngJQ@@dsURH]FJ\\fnlDa@>\ngJQ@@dsURH]FJ\\frPqSfzpRD<\ngJQ@@dsURH]FJ\\frPqSfzpRD>\ngJQ@@dsURH]FJ\\fs`qs]XIB<\ngJQ@@dsURH]FJ\\fs`qs]XIB>\ngJQ@@dsURH]FJ\\fshis]XIB<\ngJQ@@dsURH]FJ\\fshis]XIB>\ngJQ@@dsURH]FJ\\fshis][qB<\ngJQ@@dsURH]FJ]EnlDa@<\ngJQ@@dsURH]FJ]EnlDa@>\ngJQ@@dsURH]FJ]Es`qs]XIB<\ngJQ@@dsURH]FJ]Es`qs]XIB>\ngJQ@@dsURH]FJ]Es`qs]XI|<\ngJQ@@dsURH]FJ]Es`qs]XI|>\ngJQ@@dsURH]FJ]Eshis]XIB<\ngJQ@@dsURH]FJ]Eshis]XIB>\ngJQ@@dsURH]FJ]Eshis]XI|<\ngJQ@@dsURH]FJ]FnlDa@>\ngJQ@@dwM@]FJ\\eneta@\ngJQ@@dwM@]FJ\\eoBD\ngJQ@@dwM@]FJ\\es`is]KiB\ngJQ@@dwM@]FJ\\eshis]KiB\ngJQ@@dwM@]FJ\\eshis]Ki|\ngJQ@@dwM@]FJ\\eshis^DH\ngJQ@@dwM@]FJ\\eshis^Gp\ngJQ@@dwM@]FJ\\foBD\ngJQ@@dwM@]ZVRwpvmdH\ngJQ@@dwM@]ZVRwpvndH\ngJQ@@dwM@]ZVRytTyoam]HP\ngJQ@@dwM@]ZVRytTyoam]O`\ngJQ@@eMP@]HJ[yAvsl=\ngJQ@@eMP@]HJ[yAvst\ngJQ@@eMP@]HJ[yAwSt=\ngJQ@@eMP@]HJ[y^vsl=\ngJQ@@eMP@]HJ[y^vst\ngJQ@@eMP@]HJ[y^wSt=\ngJQ@@eMP@]HJ\\xLTwrCngh\ngJQ@@eMP@]HJ\\xLTwr}ngh\ngJQ@@eMP@]HJ\\xL\\wrCmgh\ngJQ@@eMP@]HJ\\xL\\wr}mgh\ngJQ@@eMP@]HJkyAvsl=\ngJQ@@eMP@]HJkyAvst\ngJQ@@eMP@]HJkyAwSt=\ngJQ@@eMP@]HJlxLTwrCngh\ngJQ@@eMP@]HJlxL\\wrCmgh\ngJQ@@eMS@]TLTyK]HIB\ngJQ@@eMS@]TLTyK]HI|\ngJQ@@eMS@]TLTyK_HNzP`\ngJQ@@eMS@]TLTyK_HNzPdd\\P\ngJQ@@eMS@]TLTyK_HNz_@\ngJQ@@eMS@]TLTyKgAbfzPRD\ngJQ@@eMS@]TLTyKgAbfzPSx\ngJQ@@eMS@]TLTyKgAbfzWbD\ngJQ@@eMS@]TLTyKgAbf~P]ta@\ngJQ@@eMS@]TLTyKgAbf~P]t~@\ngJQ@@eMS@]TLTyKgAbf~Wmta@\ngJQ@@eMS@]TLTyKgAbf~Wmt~@\ngJQ@@eMS@]TLTyKgAcfzPRD\ngJQ@@eMS@]TLTyKgAcf~P]ta@\ngJQ@@eMS@]TLTyKgAcf~Wmt~@\ngJQ@@eMS@]TLTyM]HIB\ngJQ@@eMS@]TLTyM_HNzP`\ngJQ@@eMS@]TLTyMgAbfzPRD\ngJQ@@eMS@]TLTyMgAbfzWbD\ngJQ@@eMS@]TLTyMgAbf~P]ta@\ngJQ@@eMS@]TLTyMgAbf~Wmta@\ngJQ@@eMS@]TLTyMgAcf~P]ta@\ngJQ@@eMS@]TLUYK]HIB\ngJQ@@eMS@]TLUYK_HNzP`\ngJQ@@eMS@]TLUYKgAbfzPRD\ngJQ@@eMS@]TLUYKgAbf~P]ta@\ngJQ@@eMS@]TLUYKgAbf~P]t~@\ngJQ@@eMS@]TLUYKgAcfzPRD\ngJQ@@eMS@]TLUYKgAcf~P]ta@\ngJQ@@eMS@]TLUYM_HNzP`\ngJQ@@eMS@]TLUYMgAbfzPRD\ngJQ@@eMS@]TLUYMgAbf~P]ta@\ngJQ@@eMS@]XLdwrCmgh\ngJQ@@eMS@]XLdwrCngX\ngJQ@@eMS@]XLdwrCngh\ngJQ@@eMS@]XLdypXiodG]OP\ngJQ@@eMS@]XLdypXyodG[OP\ngJQ@@eMS@]XLdypXyodG]OP\ngJQ@@eMS@]XLeYpXiodG]OP\ngJQ@@eMS@]XLeYpXyodG[OP\ngJQ@@eMU@]TLTyK_HNBP`\ngJQ@@eMU@]TLTyK_HNBPdd\\P\ngJQ@@eMU@]TLTyK_HN|_@\ngJQ@@eMU@]TLTyK_KvBP`\ngJQ@@eMU@]TLTyKdabgM|`xIB\ngJQ@@eMU@]TLTyKdabgM|oXIB\ngJQ@@eMU@]TLTzM_HNBP`\ngJQ@@eMU@]TLUYK_HNBP`\ngJQ@@eMU@]TLUYK_HNBPdd\\P\ngJQ@@eMURH]TLTyK_HNB_@<\ngJQ@@eMURH]TLTyK_HNB_@>\ngJQ@@eMURH]TLTyK_HNB__dd\\P<\ngJQ@@eMURH]TLTyK_HNB__dd\\P>\ngJQ@@eMURH]TLTyK_KvB_@<\ngJQ@@eMURH]TLTyKdabgM|`xI|<\ngJQ@@eMURH]TLTyKdabgM|`xI|>\ngJQ@@eMURH]TLTyKgAbf~P\\Da@<\ngJQ@@eMURH]TLTyKgAbf~P\\Da@>\ngJQ@@eMURH]TLTyKgAbf~P\\D~@<\ngJQ@@eMURH]TLTyKgAbf~P\\D~@>\ngJQ@@eMURH]TLTyKgAbf~WlDa@<\ngJQ@@eMURH]TLTyKgAbf~WlDa@>\ngJQ@@eMURH]TLTyKgAcf~P\\D~@<\ngJQ@@eMURH]TLTyKgAcf~P\\D~@>\ngJQ@@eMURH]TLTyKgAcf~WlD~@<\ngJQ@@eMURH]TLTyKgAcf~WlD~@>\ngJQ@@eMURH]TLTyM_HNBP`<\ngJQ@@eMURH]TLTyM_HNBP`>\ngJQ@@eMURH]TLTyMgAbf~P\\Da@<\ngJQ@@eMURH]TLTyMgAbf~P\\Da@>\ngJQ@@eMURH]TLTyMgAbf~WlDa@<\ngJQ@@eMURH]TLTyMgAbf~WlDa@>\ngJQ@@eMURH]TLTyMgAcf~P\\Da@<\ngJQ@@eMURH]TLTyMgAcf~P\\Da@>\ngJQ@@eMURH]TLTzK_HNB_@<\ngJQ@@eMURH]TLTzK_HNB_@>\ngJQ@@eMURH]TLTzKgAcf~P\\D~@<\ngJQ@@eMURH]TLTzKgAcf~P\\D~@>\ngJQ@@eMURH]TLTzMgAbf~P\\Da@<\ngJQ@@eMURH]TLTzMgAbf~P\\Da@>\ngJQ@@eMURH]TLUYKgAbf~P\\Da@<\ngJQ@@eMURH]TLUYKgAbf~P\\Da@>\ngJQ@@eMURH]TLUYKgAbf~P\\D~@<\ngJQ@@eMURH]TLUYKgAcf~P\\D~@<\ngJQ@@eMURH]TLUYKgAcf~P\\D~@>\ngJQ@@eMURH]TLUYM_HNBP`<\ngJQ@@eMURH]TLUYM_HNBP`>\ngJQ@@eMURH]TLUYMgAbf~P\\Da@<\ngJQ@@eMURH]TLUYMgAbf~P\\Da@>\ngJQ@@eMURH]TLUZKgAcf~P\\D~@<\ngJQ@@eMURH]TLUZKgAcf~P\\D~@>\ngJQAAIRYjPNcENRytTyoLD>\ngJQAAIRYjPNcENbwVB^`>\ngJQAAIRYjPNcENbypXynlD}@>\ngJQDAJATBTuTAtPqtZzpRD\ngJQDHHPpbU]TAu`isdabgMy``>\ngJQDL@aABSKTAuhiK^DH\ngJQDL@aABS[TAuhyK^DH\ngJQH@jAJZ`@z`[k[OP\ngJQH@jAJZ`@z`[k]OP=\ngJQH@jAJZ`@z`[y^vsl=\ngJQH@jAJZ`@z`[y^vst\ngJQH@jAJZ`@z`[y^wSt=\ngJQH@jAJZ`@z`\\xLTwr}ngh\ngJQH@jAJZ`@z`\\xL\\wVv^`\ngJQH@jAJZ`@z`\\xL\\wr}mgh\ngJQH@jAJZf@zHXyKgAbfzWbD\ngJQH@jAJZf@zHXyMgAbfzWbD\ngJQH@jAJZf@zHXyMgAbf~Wmta@\ngJQH@jAJZj@zHXyK]XIB\ngJQH@jAJZjdPzHXyKgAbfzpRD<\ngJQH@jAJzj@zhXitZ~`\\Da@\ngJQHB@aIfe@zTdwPwm`\ngJQHB@aInZ@zTlwPvm`\ngJQHB@aInZ@ztTyoEt\ngJQHBDQIfjdPztTyoLD<\ngJQHBHaIfjdPztTyoLD<\ngJQHBHaIfjdPztTyoLD>\ngJQHBIAIfjdPztTyoLD>\ngJQHBOAIfjdPztTyna{A@<\ngJQHD@aIej@zLTzKgQSfzpRD\ngJQHD@aIff@zLTyKgQSfzwRD\ngJQHD@aIff@ztdeoao[HP\ngJQHD@aIfjdPzLTyKgQSfzpRD<\ngJQHD@aIfjdPzLTyKgQSfzpRD>\ngJQHDIAIfjdPzLTyKgQSfzpRD<\ngJQHH@aIZ`@zd[x^vsl=\ngJQHH@aIZ`@zd[x^vst\ngJQHH@aIZ`@zd[x^wSt=\ngJQHH@aIZ`@zd\\xL\\wp}mgh\ngJQHH@aIZf@zLTyK]CqB\ngJQHH@aIZf@zLTyK_CvzP`\ngJQHH@aIZf@zLTyKgAbfzGbD\ngJQHH@aIZf@zLTyM_CvzP`\ngJQHH@aIZj@zLTyK_CvBP`\ngJQHH@aIZjbPzLTyK_CvB_@<\ngJQHH@aJmj`PzHTyK]XIB<\ngJQHH@aJmj`PzHTyK]XIB>\ngJQHH@aJmj`PzHTyKgQSfzpRD<\ngJQHH@aJmj`PzHTyKgQSfzpRD>\ngJQHH@aJmj`PzHTyM]XIB<\ngJQHH@aJmj`PzHTyM]XIB>\ngJQHH@aJmj`PzHTzK]XIB<\ngJQHH@aJmj`PzHTzK]XIB>\ngJQHH@aJmj`PzHTzM]XIB>\ngJQHHBqIZ`@zd\\xLTwp}ngh\ngJQHHGAIZ`@zd[x^vsl=\ngJQHHGAIZ`@zd[x^vst\ngJQHHGAIZ`@zd[x^wSt=\ngJQHHGAIZ`@zd\\xLTwVz^`\ngJQHHGAIZ`@zd\\xL\\wVv^`\ngJQHHGAIZf@zLTyK]CqB\ngJQHHGAIZf@zLTyK_CvzP`\ngJQHHGAIZj@zLTyK_CvBP`\ngJQHHGAIZjbPzLTyK_CvB_@<\ngJQHHGAIZjbPzLTyK_CvB_@>\ngJQHHGAIZjbPzLTyKgAbf~GlDa@>\ngJQHHGAIZjbPzLTyM_CvBP`<\ngJQHHGAIZjbPzLTyM_CvBP`>\ngJQHHOAIZ`@zd[k[Np=\ngJQHHOAIZ`@zd[k[OP\ngJQHHOAIZ`@zd[k]OP=\ngJQHHOAIZ`@zd[x^vsl=\ngJQHHOAIZ`@zd[x^vst\ngJQHHOAIZ`@zd[x^wSt=\ngJQHHOAIZ`@zd\\xLTwVz^`\ngJQHHOAIZ`@zd\\xLTwp}ngh\ngJQHHOAIZ`@zd\\xL\\wVv^`\ngJQHHOAIZ`@zd\\xL\\wp}mgh\ngJQHHOAIZf@zLTyM_CvzP`\ngJQHHOAIZj@zLTyK]XIB\ngJQHHOAIZj@zLTyK_CvBP`\ngJQHHOAIZjbPzLTyKgAbf~GlDa@<\ngJQHHOAIZjbPzLTyKgAbf~GlDa@>\ngJQHHOAIZjbPzLTyMgAbf~GlDa@>\ngJQHHOAIZjbPzLTzKgAcf~GlD~@>\ngJQHL@aIZf@ztTeoBD\ngJQHL@aIZf@ztTfnaxa@\ngJQHL@aIZf@ztTfoBD\ngJQHL@aIZjb`ztTeoBD<\ngJQHL@aIZjb`ztTeoBD>\ngJQHL@aIZjb`ztTes`qs^DH<\ngJQHL@aIZjb`ztTes`qs^DH>\ngJQHL@aJZf@zHXiK]HIB\ngJQHL@aJZf@zHXiK]HI|\ngJQHL@aJZf@zHXiK]KqB\ngJQHL@aJZf@zHXiM]HIB\ngJQHL@aJZf@zHXjK]HIB\ngJQHL@aJZf@zHXjK]HI|\ngJQHL@aJZf@zHXjM]HIB\ngJQHL@aJZjdPzHXiK]HIB<\ngJQHL@aJZjdPzHXiK]HIB>\ngJQHL@aJZjdPzHXjK]HIB<\ngJQHL@aJZjdPzHXjK]HIB>\ngJQHLHaIZf@ztTeoBD\ngJQHLHaIZf@ztTfoBD\ngJQHLHaIZjb`ztTeoBD<\ngJQHLHaIZjb`ztTeoBD>\ngJQHLJqIZjb`ztTeoBD>\ngJQHLLQIZf@ztTfoBD\ngJQH`jBRnRfj`NbFNSYpXioe{AHP>\ngJQI@jA\\eMP@]PN\\FJ[y^wSt\ngJQI@jA\\eMP@]PN\\FN[y^vst\ngJQI@jA\\eMS@]DL\\fs`qS]KqB\ngJQI@jA\\eMS@]DL\\fs`qS_KvzP`\ngJQIHO@RdmP@]RM|O[Yv=\ngJQ`@bdvu@]JNP\ngJQ`@ldru@]ZJRwaB\ngJQ`@ldru@]ZJRwa|\ngJQ`@ldru@]ZJRytTyoBD\ngJQ`@ldru@]ZJRytTyoCx\ngJQ`@ldru@]ZJSWaB\ngJQ`AbeMU@]XLTyHXis^HH\ngJQa@bnR[Z`NeGH\ngJQdAcJATBTuTAt`qs`qR>\ngJQeAcJATByJZj@zPXypXioEx>\ngJQhAbjAJzj@zpXioHD\ngJQhAbjAJzj@zpYIoHD\ngJQhAbjAJzj@zpYIs`qS^PH>\ngJQhHl@aJmj`PzpTeshis^DH<\ngJQhHl@aJmj`PzpTeshis^DH>\ngJQhHlOAJfj@zpXeoBD\ngJQhHlOAJfj@zpXerPqSf|HP\ngJQhHlOAJfj@zpXfoBD\ngJQhHlOAJfj`PzpXfs`qs^DH<\ngJQhHlOAJfj`PzpXfs`qs^DH>\ngJR@@lTfVhCiRS]C^w~tP\ngJR@@lTfphCjYnam[ZX=\ngJR@ALTkfXCiAU][Yw~t@\ngJR@ALTkfXCiAU][Y{~t@\ngJR@`lQJyIej@zTdwPwmmD\ngJR@`lQJyIej@zTdwPwnmD\ngJR@`lQJyIej@zTdwP{nmD\ngJR@`lUqeIej@zTdwPwmmD\ngJR@`l]qeIlJ@zf[h[Vvf@=\ngJRA@lQJSKTAthiZH\ngJRA@lUrSKTAtiInao[ZH\ngJRA@lUrSKTAtiInao]ZH\ngJRAALSrUsLAt`jnml{Z@\ngJRAAL]JUsLAt`jnmt}Z@\ngJT@@TfRDCjInao[@\ngJT@@TfVhCkQSf|pP\ngJT@@TfVhCkQSkNbgMtNxH\ngJT@@TfZjQCkQSf|pP<\ngJT@@TfZjQCkQSf|pP>\ngJT@@TfZjQCkQSgNCGMy``<\ngJT@@TfZjQCkQSgNCGMy``>\ngJT@@TfZjQCkQSgNbgMy``<\ngJT@@TfZjQCkQSgNbgMy``>\ngJT@@TfZjQCkQSkNCGMy``<\ngJT@@TfZjQCkQSkNCGMy``>\ngJT@@TfphCjYnam[@\ngJT@@TfphCjYnam]@\ngJT@@TfyhCiRs]CZv\ngJT@@TfyhCiRs]CZz\ngJT@@TfyhCiRs]Cjv\ngJT@@TfyhCiRs]Cjz\ngJT@@TfyhCiRsgASfzGUl\ngJT@@TfyhCiRsgQSfzGUt\ngJT@@TjZhChabgMt`xH\ngJT@@TjZhChabgMt`xO{P@=\ngJT@@TjZhChabgMt`{w{P@\ngJT@@TjZhChabgNRFJ\\wRC``\ngJT@@TjZhChabgNRFJ\\wrC`gp\ngJT@@TjZhChabgN\\EN[iAwov`@\ngJT@@TjZhChabgN\\FN[iAp_v`@\ngJT@@TjZhChabgUt`xO{P@\ngJT@@TjZhChabgV\\FN[iAp_v`@\ngJT@@TjZhCiBc]K^w~t@=\ngJT@@TjZhCiBc]K^{~t@\ngJT@@TjZhCiBcgASfzV}w}h@\ngJT@@TjZjAChabgN\\FN[iApP<\ngJT@@TjZjAChabgN\\FN[iApP>\ngJT@@TjZjAChabgN\\FN[iAw`<\ngJT@@TjZjAChabgN\\FN[iAw`>\ngJT@@TjZjAChabgVRFJ\\wRC``<\ngJT@@TjZjAChabgVRFJ\\wRC``>\ngJT@@TjZjAChabgV\\FN[iApP>\ngJT@@defhChqSdmu`dO{Q@=\ngJT@@defhChqSdn\\FJ[kAH_vb@\ngJT@@defhChqSdv\\FJ[kAH_vb@\ngJT@@dfRHCiIK_C^vPmD\ngJT@@dfRHCiIK_C^zPmD\ngJT@@dfRHCiIK_CnvPmD\ngJT@@dfRHCiIKgQSf~F}taZH\ngJT@@dfRHCiIM_C^vPmD\ngJT@@dfRHCiIM_C^zPmD\ngJT@@dfRHCiIMgQSf~F}taZH\ngJT@@dfVhChqSdmu`dO{Q@\ngJT@@dfVhChqSdn\\FN[kAH_vb@\ngJT@@dfVhChqSdn\\FN[k^H_vb@\ngJT@@dfVhChqSdn]EN[x]pRG}h`\ngJT@@dfVhChqSduu`dO{Q@\ngJT@@dfVhChqSduuoDO{Q@\ngJT@@dfVhChqSdu|NxIC~tP\ngJT@@dfVhChqSdv\\FN[kAH_vb@\ngJT@@dfVhChqShmu`dO{Q@\ngJT@@dfVhChqShmu`gw{Q@\ngJT@@dfVhChqShn\\FN[kAH_vb@\ngJT@@dfVhChqShuu`dO{Q@\ngJT@@dfVhChqShu|NxIC~tP\ngJT@@dfVhChqShv\\FN[kAH_vb@\ngJT@@dfVhCkRRV~F}laZH\ngJT@@dfVhCkRRV~F}taZH\ngJT@@dfVhCkRRWNbgM|M{iC~tP\ngJT@@dfVhCkRRZ~F}taZH\ngJT@@dfphCiYK_CZvP`=\ngJT@@dfvdCkQrWNBgH\ngJT@@dfvdCkQrWNbgH\ngJT@@dfvdCkRrVzFut\ngJT@@dfvhCkQrV|HP\ngJT@@dfvhCkQrWNbgMxP`\ngJT@@dfvhCkQrZzGRD\ngJT@@dfvhCkQrZ|HP\ngJT@@dfvhCkRrV~Fula@\ngJT@@dfvhCkRrV~Futa@\ngJT@@dfvhCkRrZ~Fula@\ngJT@@dfvhCkRrZ~Futa@\ngJT@@dfzhCkQrV|HP\ngJT@@dfzhCkQrWICEN[pa@\ngJT@@dfzjQCkQrWNBgMxP`<\ngJT@@dfzjQCkQrWNBgMxP`>\ngJT@ADiihCjabgI[kAH_vP`=\ngJT@ADiihCjabgI[kAOovP`\ngJT@ADiihCjabgI[y]pRG}dH=\ngJT@ADiihCjabgI\\xLTwVBPla@\ngJT@ADiihCjabgI\\xLTwr{`dO{HP\ngJT@ADiihCjabgIkkAH_vP`\ngJT@ADiihCjabgIlxLTwr{`dO{HP\ngJT@ADiihCjabgQkkAH_vP`=\ngJT@ADiihCkAdfzvso}dH=\ngJT@ADiihCkAdfzwSw}dH=\ngJT@ADiihCkAdgNCEM|n{i{~rD@\ngJT@ADiihCkAdgNCGM|n{Y{~rD@\ngJT@ADjZhCjabgI[yApRG}dH=\ngJT@ADjZhCjabgI[yApRG}h@=\ngJT@ADjZhCjabgI[yApRG}i@\ngJT@ADjZhCjabgI[yAwbG}dH\ngJT@ADjZhCjabgI\\xL\\wrC`dO{P@\ngJT@ADjZhCjabgIkyApRG}dH=\ngJT@ADjZhCjabgQ[yApRG}dH\ngJT@ADjZhCjabgQkyApRG}dH\ngJT@ADjZhCkBbV~W]taYB@=\ngJT@ADjzhChaSdmu`dO{P@\ngJT@ADjzhChaSdn\\FN[kAH_v`@\ngJT@ADjzhChaSdn]EN[kAH_v`@\ngJT@ADjzhChaSduu`dO{P@\ngJT@ADjzhChaShmu`dO{P@\ngJT@ADjzhCkBRV~f}laZ@\ngJT@ADjzhCkBRV~f}l~Z@\ngJT@ADjzhCkBRV~f}taZ@\ngJT@ADjzhCkBRWNbgM}M{iC~t@\ngJT@ADjzhCkBRZ~f}laZ@\ngJT@ADjzhCkBRZ~f}taZ@\ngJT@ADjzjAChaSdmu`dH<\ngJT@ADjzjAChaSdmu`dH>\ngJT@ADjzjAChaSdn]EN[kAHP<\ngJT@ADjzjAChaSdn]EN[kAHP>\ngJT@ADjzjAChaSduu`dH<\ngJT@ADjzjAChaSduu`dH>\ngJT@ADkf@CjAnml{Z@=\ngJT@ADkf@CjAnml}Z@\ngJT@ADkf@CjAnmt}Z@=\ngJT@ADkf@CjAoiw[Nv`@=\ngJT@ADkf@CjAoiw[O_v`@\ngJT@ADkf@CjAoiw]O_v`@=\ngJT@ADkfXChaSdmundO{P@\ngJT@ADkfXChaSduundO{P@\ngJT@ADkfXCiAU][i{~t@\ngJT@ADkj@CjAnml{Z@=\ngJT@ADkj@CjAnml}Z@\ngJT@ADkj@CjAnmt}Z@=\ngJT@ADkjXChaSdmundO{P@\ngJT@AdefdCiQU][Yv\ngJT@AdefdCiQU][Yz\ngJT@AdefdCiQU][iv\ngJT@AdefdCiQUgAbf~G]t}@\ngJT@Adii@CiAS][Yw~t@\ngJT@Adii@CiAS_Knv]m@\ngJT@Adii@CiASgAbf~W]t{Z@\ngJT@Adii@CiASgAcf~W]l}Z@\ngJT@AdiiXChabdmtngw{P@\ngJT@AdiiXChabdv\\FJ[y]wRG}h@\ngJT@AdiiXChabdv\\FN[y]wRG}h@\ngJT@AdiidChabdn\\FN[i]O_v`@\ngJT@AdiidChabdn\\FN[q]Z@\ngJT@AdiidCkAdfzwSo}h@\ngJT@AdiidCkAdfzwSw}h@\ngJT@AdiidCkAdgNCEM|n{i{~t@\ngJT@AdiidCkAdgNCGMumgo{P@\ngJT@AdiidCkAdgNCGMungo{P@\ngJT@AdiidCkAdgNCGM|n{Y{~t@\ngJT@AdiidCkAdgNCGM|n{i{~t@\ngJT@AdijdChabdmt`go{P@\ngJT@AdijdChabdn\\FJ[iAO_v`@\ngJT@AdijdChabdn\\FN[iAO_v`@\ngJT@AdijdChabdn\\FN[qAZ@\ngJT@AdijdCkAdf~P]t{Z@\ngJT@AdijdCkAdf~P]t}@\ngJT@AdijdCkAdf~Wmt}@\ngJT@AdijdCkAdgNCEM|`{iz\ngJT@AdijdCkAdgNCGM|`{Y{~t@\ngJT@AdijdCkAdgNCGM|`{iz\ngJT@AdijjQChabdmt`dO{P@<\ngJT@AdijjQChabdmt`dO{P@>\ngJT@AdijjQChabdnRFJ\\wRBP`>\ngJT@AdijjQChabdv\\FJ[iAHP<\ngJT@AdijjQChabdv\\FJ[iAH_v`@<\ngJT@AdijjQChabdv\\FJ[iAH_v`@>\ngJT@AdijjQChabhmt`dO{P@<\ngJT@AdijjQChabhv\\FJ[iAH_v`@<\ngJT@AdijjQChabhv\\FJ[iAH_v`@>\ngJT@`QIeIfjdPztTys`qs^XH>\ngJT@`QIeIlJ@zf[h[Vp\ngJT@`aJyIdb@zRRypXyoaw[H_vb@\ngJT@`aJyIdb@zRRytTyoaw]H_vb@\ngJT@aAteJz`@z`[k[Nv`@=\ngJT@aAteJz`@z`[k[O_v`@\ngJT@aAteJz`@z`[k]O_v`@=\ngJT@aAteJzj@zHTyK]XIC~t@\ngJTA@QJSIBAuDwPwm`\ngJTA@QJSMUHauhis^XH<\ngJTA@QJSMUHauhis^XH>\ngJTA@QJSXTAuLwPvm`\ngJTA@QJUMTAtPqSgICEN[iApP\ngJTA@SJSXTAuLwPvm`\ngJTA@SJUMTAtPqSgICEN[iApP\ngJTA@SJUMTAtPqSgICEN[yApSx\ngJTA@aJRsTAtXirWNCEM|NxIC~tP\ngJTA@aJRsTAtXir[NCEM|NxIC~tP\ngJTA@aJSIDAtdeoao[H_vb@\ngJTA@aJSIDAtdeoaw[H_vb@\ngJTA@aJSIDAtdfoao[H_vb@\ngJTA@aJSKTAtXirWNbgMu`dO{Q@\ngJTA@aJS[RAuhyKgQSd\ngJTA@aJS[TAuiYK_CZvP`\ngJTA@aJS[TAuiYM_CjzP`\ngJTAAAJU[TAuaIK_S^vPm@\ngJTAAaJRuRAthjnml{@\ngJTAAaJRuUEAuhiK^DH>\ngJTD@UPZ`Rkj`NlFR\\zJ\\wdC~t@\ngJTDAePF`Rnj`NlFR\\xL\\wdC~t@>\ngJTDAiPJ`Rfj`NlFI\\xLTwaB>\ngJTDE`DGpRYZ`NeEMx__mD\ngJTDEaxR`RYj`NmEIlzJ\\waC~tP>\ngJTDLPDHHR[Z`NeGO{S@\ngJTDLPDPHRnh@NhFzvsl=\ngJTDLPDPHRni`NdEUumgX\ngJTDLPDPHRni`NdEUumgh\ngJTD`UPZ`DkdjzjACkAbgNbgMyO@<\ngJTD`UPZ`DkdjzjACkAbgNbgMyO@>\ngJTDe`DDHT{dfyhCiRs_CZv__mL\ngJTDlQVPHGZTejXCiQR\ngJTELPDPHtiWTpGRBd\ngJTHACPISSPGQCENlxL\\wr{`gw{HP\ngJTHAePIWUPGQCII\\xLTwTBPm@>\ngJTHDPDIMsPGRefzFul\ngJTHE`DILmHGVbdmx^mD\ngJTHE`DILmHGVbdn]EN[p}ZH\ngJTHE`DILmPGVbdmxPmD\ngJTHE`DILmPGVbdmx__mD\ngJTHE`DILmPGVbdn]EN[paZH\ngJTHE`DILmPGVbduxPmD\ngJTHE`DILmPGVbdv]EN[paZH\ngJTHE`DILthGVddmtM{_{Q@\ngJTHE`DILthGVddm|M{Y{~tP\ngJTHE`DILthGVddn]EN[x[wSw}h`\ngJTHE`DIMsPGVcdmxPmL\ngJTHE`DIMsPGVcdn]EN[paZX\ngJTHE`DIMsPGVcduxPmL\ngJTHE`DIMsPGVedm|MkYC~tp\ngJTHE`DIMsPGVedu|MkYC~tp\ngJTHEaDILthGVbdn]EN[p}ZH\ngJTHHPDILuPGVbgN]EN[h^p_vd@\ngJTHH`xIKUPGQbgI[x^pRD\ngJTHHaxILuHGQbgI[h^p_vTP\ngJTHI`DIKT@GTc_Cvv]mH\ngJTHI`DIKTpGRbj~Gml{ZP\ngJTHI`DIKUHGRbj~Gmt}ZP\ngJTHIaxIKT@GTc_Cvv]mH\ngJTHLPDIST@GRBf~P]l{@=\ngJTHLPDIST@GRBj~P]l{@=\ngJTHLPDISTpGVCEMx``\ngJTHLPDISTpGVCEN\\FJ[qA@\ngJTHLPDISTpGVCEN\\FN[iAwP\ngJTHLPDISTpGVCIM|`{Yv\ngJTHLPDISTpGVCIM|`{Yz\ngJTHLPDISTpGVCIN\\FN[yAvst\ngJTH`mPB]rS[TAuiYK_CjzP`\ngJTHe`DCeJS\\tAuhyKgQSf|H_vf@\ngJTHe`DJ]rS\\tAuiYKgQSf~FutaZX\ngJTHe`bCeJS\\tAuhyK]KiC~tp\ngJTHi`DSmJRu@AuHwp}mg_{R@\ngJTHlQxCmJTuLAu`rU_HNz^`\ngJTIE`DJTfyhCkRrV~FulaZX\ngJTILPDZTijXCkAbf|PP\ngJTIhaVCiJeJZ`@z`[k[Nvd@=\ngJTIhaVCiJeJZ`@z`[k]O_vd@=\ngJTIhabCiJeJZ`@z`[k[Nvd@=\ngJTIhabCiJeJZ`@z`[k]O_vd@=\ngJT`E`TfVhCiQR\ngJT`LPdfVhCiQR\ngJT`LPdfvhCiQs~tp\ngJT`i`iJyImi@zt\\eoCw}eL\ngJT`i`iJyImj@zt\\eoBG}eL\ngJT`i`iJyImj@zt\\foBG}eL\ngJTai`iJ{\\dvu@]ZNRwaC~rf@\ngJTai`iJ{\\dvu@]ZNSWaC~rf@\ngJU@DPdru@]ZJ\\wfC~tP\ngJU@DPdru@]ZJ\\wf}~tP\ngJU@DPdru@]ZJ\\ytTyoLG}h`\ngJU@DPdru@]ZJ]WfC~tP\ngJU@DPdru@]ZJ]YtTyoLG}h`\ngJU@DPdvt`]JN\\zJ\\`\ngJU@DPdvu@]JNP\ngJU@DPdvu@]JN\\zJ\\`\ngJU@E`drt`]ZJRwa{~tP\ngJU@E`drt`]ZJRytTyoCw}h`\ngJU@E`dru@]ZJRwaC~tP\ngJU@E`dru@]ZJRwa}~tP\ngJU@E`dru@]ZJRytTyoBG}h`\ngJU@E`dru@]ZJRytTyoC{}h`\ngJU@E`dru@]ZJSWaC~tP\ngJU@E`dru@]ZJSYtTyoBG}h`\ngJU@E`dwM@]ZVSWpvmdO{S@\ngJU@H`dlu@]FJ\\enlDaYQ@=\ngJU@H`dlu@]FJ\\fnlDaYQ@\ngJU@I`eMU@]XLdwrCmgo{R@\ngJU@LPdmS@]JJkk[Np\ngJU@LPdmS@]JJkk[OP\ngJU@LPdmS@]JJlxL\\wVv^`\ngJU@LPeMP@]HJ[yAvsl=\ngJU@LPeMP@]HJkyAvsl=\ngJU@LPeMS@]XLTwbB\ngJU@LPeMS@]XLUWbB\ngJU@LPeMU@]XLTwbB\ngJU@e`NTiMsPGVcdn]EN[paZX\ngJUADPYRYZ`NmENksAZH\ngJUADPYR[Z`NeGH\ngJUAE`nRYZ`NmEI\\zJ\\waC~tP\ngJUAE`nRYZ`NmEIlzJ\\waC~tP\ngJUAEanRYZ`NmEI[paZH\ngJUAEanRYZ`NmEI\\zJ\\waC~tP\ngJUDEhO@~BUMTAt`qIPh`\ngJUHEhOAJfj@zpXfoBG|eBb\ngJUHH\\@aIZf@zTTw`}~t`\ngJUHLPjAJzj@zpXioHD\ngJUIH\\@b\\dmS@]JJ[p^ZP\ngJX@@dlp@]RMumgX=\ngJX@@dlp@]RMumgh\ngJX@@dlp@]RMungh=\ngJX@@dlp@]RM|N{Yv=\ngJX@@dlp@]RM|N{Yz\ngJX@@dlp@]RN\\FJ[x]wSt\ngJX@@dlp@]RN\\FN[k[OP\ngJX@@dlp@]RN\\FN[x]vst\ngJX@@dls@]FJ\\enmta@\ngJX@@dls@]FJ\\eoBD\ngJX@@dls@]FJ\\foBD\ngJX@@dls@]JJkk[OP\ngJX@@dls@]JJkk]OP\ngJX@@dlu@]FJ\\enlDa@\ngJX@@dmP@]RMumgX=\ngJX@@dmP@]RMumgh\ngJX@@dmP@]RMungh=\ngJX@@dmP@]RN\\FJ[k]OP\ngJX@@dmP@]RN\\FN[k[OP\ngJX@@dmP@]RN\\FN[x^vst\ngJX@@dmS@]FJ\\enmta@\ngJX@@dmS@]FJ\\eoBD\ngJX@@dmS@]FJ\\es`qS][iB\ngJX@@dmS@]FJ\\es`qS^DH\ngJX@@dmS@]FJ\\es`qs][iB\ngJX@@dmS@]FJ\\es`qs^DH\ngJX@@dmS@]FJ\\foBD\ngJX@@dmS@]FJ\\fs`qs][iB\ngJX@@dmS@]JJlxLTwVz]`\ngJX@@dmS@]JJlxLTwVz^`\ngJX@@dmU@]FJ\\enlDa@\ngJX@@dmU@]FJ\\erPqSfzpRD\ngJX@@dmU@]FJ]FnlDa@\ngJX@@dmUQH]FJ\\enlD~@<\ngJX@@dmUQH]FJ\\es`qS]XIB<\ngJX@@dmUQH]FJ\\es`qS]XIB>\ngJX@@dmUQH]FJ\\es`qS]XI|<\ngJX@@dmUQH]FJ\\es`qS]XI|>\ngJX@@dmUQH]FJ\\es`qs]XI|<\ngJX@@dmUQH]FJ\\es`qs]XI|>\ngJX@@dmUQH]FJ\\fnlDa@<\ngJX@@dmUQH]FJ\\fnlDa@>\ngJX@@dmUQH]FJ\\frPqSfzpRD>\ngJX@@dmUQH]FJ\\fs`qS]XIB<\ngJX@@dmUQH]FJ\\fs`qS]XIB>\ngJX@@dmUQH]FJ\\fs`qs]XIB<\ngJX@@dmUQH]FJ]EnlD~@<\ngJX@@dmUQH]FJ]EnlD~@>\ngJX@@drP`]II[h[vp\ngJX@@drP`]II[h[wP\ngJX@@drP`]II[x[vst\ngJX@@drP`]II\\xL\\wp{mgh\ngJX@@drt`]FJ\\enlD}@\ngJX@@drt`]FJ\\enmx}@\ngJX@@drt`]FJ\\eoLD\ngJX@@drt`]FJ\\eoMx\ngJX@@drt`]FJ\\es`qs]XIz\ngJX@@drt`]FJ\\es`qs_CnB^`\ngJX@@drt`]FJ\\eshis]CnB\ngJX@@drt`]FJ\\eshis]XIz\ngJX@@drt`]FJ\\eshis^XH\ngJX@@drt`]FJ\\eshis_CnB^`\ngJX@@drt`]FJ]EnawA@\ngJX@@drt`]FJ]Es`qs]XIz\ngJX@@drt`]FJ]Eshis_CnB^`\ngJX@@dru@]FJ\\enlDa@\ngJX@@dru@]FJ\\enlD~@\ngJX@@dru@]FJ\\eoawAHP\ngJX@@dru@]FJ\\eoaw^HP\ngJX@@dru@]FJ\\es`qs]XIB\ngJX@@dru@]FJ\\eshis]XIB\ngJX@@dru@]FJ\\eshis][qB\ngJX@@dru@]FJ\\eshis_CnBP`\ngJX@@dru@]FJ\\eshis_Cn|P`\ngJX@@dru@]FJ\\fnlDa@\ngJX@@dru@]FJ]EnlDa@\ngJX@@dru@]FJ]EoawAHP\ngJX@@dru@]FJ]Es`qs]XIB\ngJX@@dru@]FJ]Es`qs]XI|\ngJX@@dru@]FJ]Eshis_CnBP`\ngJX@@dru@]ZRRwpwmdH\ngJX@@dru@]ZRRwpwndH\ngJX@@dru@]ZRRytTyoao]HP\ngJX@@dsR`]FJ\\e@\ngJX@@dsR`]FJ\\es`qs^Gh\ngJX@@dsR`]FJ\\es`qs^[h\ngJX@@dsR`]FJ\\eshir\ngJX@@dsR`]FJ\\eshis][iz\ngJX@@dsR`]FJ\\eshis^Gh\ngJX@@dsR`]ZRRwPwm`\ngJX@@dsR`]ZRRwPwn`\ngJX@@dsR`]ZRRwP{m`\ngJX@@dsR`]ZRRwP{n`\ngJX@@dsR`]ZRRwpwmgh\ngJX@@dsR`]ZRRwpwngh\ngJX@@dsR`]ZRRwp{mgh\ngJX@@dsR`]ZRRytTyoaw]OP\ngJX@@dsTrH]FJ\\enlD}@>\ngJX@@dsTrH]FJ\\eoLD<\ngJX@@dsTrH]FJ\\eoLD>\ngJX@@dsTrH]FJ\\erPqSf|pP<\ngJX@@dsTrH]FJ\\erPqSf|pP>\ngJX@@dsTrH]FJ\\erPqSf|w`<\ngJX@@dsTrH]FJ\\erPqSf|w`>\ngJX@@dsTrH]FJ\\es`qs^XH<\ngJX@@dsTrH]FJ\\es`qs^XH>\ngJX@@dsTrH]FJ\\eshis]XIz<\ngJX@@dsTrH]FJ\\eshis^XH<\ngJX@@dsTrH]FJ\\eshis^XH>\ngJX@@dsTrH]FJ\\eshis^[p<\ngJX@@dsTrH]FJ]EoLD<\ngJX@@dsURH]FJ\\enlDa@<\ngJX@@dsURH]FJ\\enlDa@>\ngJX@@dsURH]FJ\\enlD~@<\ngJX@@dsURH]FJ\\enlD~@>\ngJX@@dsURH]FJ\\enmxa@<\ngJX@@dsURH]FJ\\enmxa@>\ngJX@@dsURH]FJ\\erPqSfzpRD<\ngJX@@dsURH]FJ\\erPqSfzpRD>\ngJX@@dsURH]FJ\\erPqSfzwbD<\ngJX@@dsURH]FJ\\erPqSfzwbD>\ngJX@@dsURH]FJ\\es`qs]XIB<\ngJX@@dsURH]FJ\\es`qs]XIB>\ngJX@@dsURH]FJ\\es`qs]XI|<\ngJX@@dsURH]FJ\\es`qs]XI|>\ngJX@@dsURH]FJ\\es`qs][qB<\ngJX@@dsURH]FJ\\es`qs][qB>\ngJX@@dsURH]FJ\\eshis]XIB<\ngJX@@dsURH]FJ\\eshis]XIB>\ngJX@@dsURH]FJ\\eshis]XI|<\ngJX@@dsURH]FJ\\eshis]XI|>\ngJX@@dsURH]FJ\\eshis][qB<\ngJX@@dsURH]FJ\\eshis][qB>\ngJX@@dsURH]FJ\\fnlDa@<\ngJX@@dsURH]FJ\\fnlDa@>\ngJX@@dsURH]FJ\\fnmxa@<\ngJX@@dsURH]FJ\\fnmxa@>\ngJX@@dsURH]FJ\\fs`qs]XIB<\ngJX@@dsURH]FJ\\fs`qs]XIB>\ngJX@@dsURH]FJ\\fshis]XIB<\ngJX@@dsURH]FJ\\fshis]XIB>\ngJX@@dsURH]FJ\\fshis][qB>\ngJX@@dsURH]FJ]EnlDa@<\ngJX@@dsURH]FJ]EnlDa@>\ngJX@@dsURH]FJ]ErPqSfzpRD<\ngJX@@dsURH]FJ]Es`qs]XIB<\ngJX@@dsURH]FJ]Es`qs]XIB>\ngJX@@dsURH]FJ]Es`qs]XI|<\ngJX@@dsURH]FJ]Es`qs]XI|>\ngJX@@dsURH]FJ]Eshis]XIB<\ngJX@@dsURH]FJ]Eshis]XIB>\ngJX@@dsURH]FJ]FnlDa@<\ngJX@@dsURH]FJ]FnlDa@>\ngJX@@dsURH]FJ]Fs`qs]XIB<\ngJX@@dsURH]FJ]Fs`qs]XIB>\ngJX@@dvE@]KI[x[VrD\ngJX@@dvE@]KI[x[Vsx\ngJX@@dvE@]KI[x[WRD\ngJX@@dvE@]KI[x]VrD\ngJX@@dvE@]KI\\zJ\\wpvndH\ngJX@@dvE@]KI\\zJ\\wpvngp\ngJX@@dvE@]KIkx[VrD\ngJX@@dvE@]KIkx[WRD\ngJX@@dwM@]FJ\\eneta@\ngJX@@dwM@]FJ\\eoBD\ngJX@@dwM@]FJ\\es`is]KiB\ngJX@@dwM@]FJ\\es`is^DH\ngJX@@dwM@]FJ\\eshis]KiB\ngJX@@dwM@]FJ\\eshis]Ki|\ngJX@@dwM@]FJ\\eshis^DH\ngJX@@dwM@]FJ\\eshis^Gp\ngJX@@dwM@]FJ\\fneta@\ngJX@@dwM@]ZVRwpvmdH\ngJX@@dwM@]ZVRwpvndH\ngJX@@dwM@]ZVRwpzmdH\ngJX@@dwM@]ZVRwpzndH\ngJX@@dwM@]ZVRypTyoau[HP\ngJX@@dwM@]ZVRypTyoau]HP\ngJX@@dwM@]ZVRytTyoam]HP\ngJX@@dwM@]ZVRytTyoau]HP\ngJX@@dwM@]ZVRytTyoau]O`\ngJX@@dwM@]ZVSWpvmdH\ngJX@@dwM@]ZVSWpvndH\ngJX@@dwM@]ZVSWpzmdH\ngJX@@dwM@]ZVSWpzndH\ngJX@@eMH@]HJ[k[Nv`@=\ngJX@@eMH@]HJ[k[O_v`@\ngJX@@eMH@]HJ[k]O_v`@=\ngJX@@eMH@]HJ[y]vso}h@=\ngJX@@eMH@]HJ[y]vsw}h@\ngJX@@eMH@]HJ[y]wSw}h@=\ngJX@@eMH@]HJ\\xLTwVz^m@\ngJX@@eMH@]HJ\\xLTwr{ngo{P@\ngJX@@eMH@]HJ\\xL\\wVv^m@\ngJX@@eMH@]HJ\\xL\\wr{mgo{P@\ngJX@@eMK@]TLTyK][iC~t@\ngJX@@eMK@]TLTyK_KnzPm@\ngJX@@eMK@]TLTyKgAbfzWRG}h@\ngJX@@eMK@]TLTyKgAbf~W]taZ@\ngJX@@eMK@]XLdypXioew]O_v`@\ngJX@@eMP@]HJ[yAvso}h@=\ngJX@@eMP@]HJ[yAvsw}h@\ngJX@@eMP@]HJ[yAwSt=\ngJX@@eMP@]HJ[yAwSw}h@=\ngJX@@eMP@]HJ[y^vso}h@=\ngJX@@eMP@]HJ[y^vsw}h@\ngJX@@eMP@]HJ\\xLTwrCngh\ngJX@@eMP@]HJ\\xLTwrCngo{P@\ngJX@@eMP@]HJ\\xLTwr}ngh\ngJX@@eMP@]HJ\\xL\\wrCmgo{P@\ngJX@@eMP@]HJ\\xL\\wr}mgo{P@\ngJX@@eMP@]HJkyAvso}h@=\ngJX@@eMP@]HJkyAvsw}h@\ngJX@@eMP@]HJkyAwSt=\ngJX@@eMP@]HJkyAwSw}h@=\ngJX@@eMP@]HJlxLTwrCngh\ngJX@@eMP@]HJlxLTwrCngo{P@\ngJX@@eMP@]HJlxL\\wrCmgo{P@\ngJX@@eMS@]TLTyK]HIC~t@\ngJX@@eMS@]TLTyK_HNzPdd\\[P@\ngJX@@eMS@]TLTyK_HNzPm@\ngJX@@eMS@]TLTyKgAbfzPRG}h@\ngJX@@eMS@]TLTyKgAbf~P]taZ@\ngJX@@eMS@]TLTyKgAbf~WmtaZ@\ngJX@@eMS@]TLTyKgAcf~P]taZ@\ngJX@@eMS@]TLTyM_HNzPm@\ngJX@@eMS@]TLTyMgAbfzPRG}h@\ngJX@@eMS@]TLTyMgAbf~P]taZ@\ngJX@@eMS@]TLUYK]HIC~t@\ngJX@@eMS@]TLUYK_HNzPdd\\[P@\ngJX@@eMS@]TLUYK_HNzPm@\ngJX@@eMS@]TLUYKgAbfzPRG}h@\ngJX@@eMS@]TLUYKgAbf~P]taZ@\ngJX@@eMS@]TLUYKgAcf~P]taZ@\ngJX@@eMS@]TLUYM_HNzPm@\ngJX@@eMS@]TLUYMgAbf~P]taZ@\ngJX@@eMS@]XLdwrCng_{P@\ngJX@@eMS@]XLdwrCngo{P@\ngJX@@eMS@]XLeWrCmgo{P@\ngJX@@eMS@]XLeWrCngo{P@\ngJX@@eMU@]TLTyK_HNBP`\ngJX@@eMU@]TLTyK_HNBPdd\\[P@\ngJX@@eMU@]TLTyK_HNBPm@\ngJX@@eMU@]TLTyK_KvBP`\ngJX@@eMU@]TLTzM_HNBP`\ngJX@@eMU@]TLTzM_HNBPm@\ngJX@@eMU@]TLUYK_HNBP`\ngJX@@eMU@]TLUYK_HNBPm@\ngJX@@eMU@]TLUZM_HNBPm@\ngJX@@eMURH]TLTyK_HNB__m@<\ngJX@@eMURH]TLTyK_HNB__m@>\ngJX@@eMURH]TLTyKgAbf~P\\Da@<\ngJX@@eMURH]TLTyKgAbf~P\\Da@>\ngJX@@eMURH]TLTyKgAbf~P\\DaZ@<\ngJX@@eMURH]TLTyKgAbf~P\\DaZ@>\ngJX@@eMURH]TLTyKgAbf~WlDa@<\ngJX@@eMURH]TLTyM_HNBP`<\ngJX@@eMURH]TLTyM_HNBP`>\ngJX@@eMURH]TLTyM_HNBPm@<\ngJX@@eMURH]TLTyM_HNBPm@>\ngJX@@eMURH]TLTyMgAbf~P\\Da@<\ngJX@@eMURH]TLTyMgAbf~P\\Da@>\ngJX@@eMURH]TLTyMgAbf~P\\DaZ@<\ngJX@@eMURH]TLTyMgAbf~P\\DaZ@>\ngJX@@eMURH]TLTzK_HNB__m@<\ngJX@@eMURH]TLTzK_HNB__m@>\ngJX@@eMURH]TLTzKgAcf~P\\D~@<\ngJX@@eMURH]TLTzKgAcf~P\\D~@>\ngJX@@eMURH]TLTzMgAbf~P\\Da@<\ngJX@@eMURH]TLUYK_HNB__m@>\ngJX@@eMURH]TLUYKgAbf~P\\Da@<\ngJX@@eMURH]TLUYKgAbf~P\\Da@>\ngJX@@eMURH]TLUYKgAbf~P\\DaZ@<\ngJX@@eMURH]TLUYKgAbf~P\\DaZ@>\ngJX@@eMURH]TLUYM_HNBPm@<\ngJX@@eMURH]TLUYM_HNBPm@>\ngJX@@eMURH]TLUYMgAbf~P\\DaZ@<\ngJX@@eMURH]TLUYMgAbf~P\\DaZ@>\ngJX@@eMURH]TLUZK_HNB__m@<\ngJX@@eMURH]TLUZK_HNB__m@>\ngJX@@eST`]TLTyK]HNC~t@=\ngJX@@eST`]TLTyK_HNB^m@=\ngJX@@eST`]TLTyKgASfzP]{}h@\ngJX@@eST`]TLTyKgASf~P]x}Z@\ngJX@@eST`]TLTyKgAcfzP\\G}h@\ngJX@@eST`]TLTyKgAcf~P\\D}Z@\ngJX@@eST`]TLTzK]HNC~t@\ngJX@@eST`]TLTzK_HNB^m@\ngJX@@eST`]TLTzKgASf~P\\D}Z@\ngJX@@eST`]TLTzKgAcfzP\\G}h@\ngJX@@eST`]TLTzKgAcf~P\\D}Z@\ngJX@@eST`]XTRwRwnm@\ngJX@@eST`]XTRwR{nm@=\ngJX@@eSU@]TLTyK_HNBP`\ngJX@@eSU@]TLTyK_HNBPdhT[P@=\ngJX@@eSU@]TLTyK_HNBPm@=\ngJX@@eSU@]TLTyK_HNB_@\ngJX@@eSU@]TLTyK_HNB__m@=\ngJX@@eSU@]TLTyK_HN|Pm@\ngJX@@eSU@]TLTyKdabgM|`xIB\ngJX@@eSU@]TLTyKdabgM|`xIC~t@=\ngJX@@eSU@]TLTyKdabgM|`xI|\ngJX@@eSU@]TLTyKgASf~P]xaZ@\ngJX@@eSU@]TLTyKgAcf~P\\DaZ@\ngJX@@eSU@]TLTyKgAcf~P\\D~Z@\ngJX@@eSU@]TLTyKgAcf~P]xaZ@\ngJX@@eSU@]TLTyM_HNBP`\ngJX@@eSU@]TLTyM_HNBPdhT[P@=\ngJX@@eSU@]TLTyM_HNBPm@=\ngJX@@eSU@]TLTyM_HN|Pm@\ngJX@@eSU@]TLTyMgASf~P]xaZ@\ngJX@@eSU@]TLTyMgAcf~P\\DaZ@\ngJX@@eSU@]TLTzK_HNBPm@\ngJX@@eSU@]TLTzKgASf~P\\DaZ@\ngJX@@eSU@]TLTzKgAcf~P\\DaZ@\ngJX@@eSU@]TLTzKgAcf~P\\D~Z@\ngJX@@eSU@]TLTzM_HNBPm@\ngJX@@eSU@]TLTzMgASf~P\\DaZ@\ngJX@@eSU@]TLTzMgAcf~P\\DaZ@\ngJX@@eSU@]TLUZK_HNBP`\ngJX@@eSU@]TLUZK_HNBPm@=\ngJX@@eSU@]TLUZM_HNBPm@=\ngJX@@eSU@]XTRwrwmdO{P@=\ngJX@@eSU@]XTRwrwmgw{P@=\ngJX@@eSU@]XTRwrwndO{P@\ngJX@@eSU@]XTRwrwngw{P@\ngJX@@eSU@]XTRwr{ndO{P@=\ngJX@@eSU@]XTRypTyoeo]H_v`@\ngJX@@eSU@]XTRypXyoew]H_v`@\ngJX@@eSU@]XTSWrwmdO{P@=\ngJX@@eSU@]XTSWrwndO{P@\ngJX@@eSU@]XTSWr{ndO{P@=\ngJX@@eSU@]XTSYpXyoew]H_v`@\ngJX@@eSUPH]TLTyK_HN|P`<\ngJX@@eSUPH]TLTyK_HN|P`>\ngJX@@eSUPH]TLTyKgASf~P]xa@<\ngJX@@eSUPH]TLTyKgASf~P]xa@>\ngJX@@eSUPH]TLTyKgAcf~P\\Da@<\ngJX@@eSUPH]TLTyKgAcf~P\\Da@>\ngJX@@eSUPH]TLTyKgAcf~P\\D~@<\ngJX@@eSUPH]TLTyKgAcf~P\\D~@>\ngJX@@eSUPH]TLTyKgAcf~P]xa@<\ngJX@@eSUPH]TLTyKgAcf~P]xa@>\ngJX@@eSUPH]TLTyM_HN|P`<\ngJX@@eSUPH]TLTyM_HN|P`>\ngJX@@eSUPH]TLTyMgAcf~P\\Da@<\ngJX@@eSUPH]TLTyMgAcf~P\\Da@>\ngJX@@eSUPH]TLTzK_HNBP`<\ngJX@@eSUPH]TLTzK_HNBP`>\ngJX@@eSUPH]TLTzKdabgM|`xIB<\ngJX@@eSUPH]TLTzKgASf~P\\Da@<\ngJX@@eSUPH]TLTzKgASf~P\\Da@>\ngJX@@eSUPH]TLTzKgAcf~P\\Da@<\ngJX@@eSUPH]TLTzKgAcf~P\\Da@>\ngJX@@eSUPH]TLTzM_HNBP`<\ngJX@@eSUPH]TLTzM_HNBP`>\ngJX@@eSUPH]TLTzMgAcf~P\\Da@<\ngJX@@eSUPH]TLTzMgAcf~P\\Da@>\ngJX@@eSUPH]TLUYK_HN|P`<\ngJX@@eSUPH]TLUYK_HN|P`>\ngJX@@eSUPH]TLUYM_HN|P`<\ngJX@@eSUPH]TLUYM_HN|P`>\ngJX@@e\\u@]TLTyK]XIC~t@\ngJX@@e\\u@]TLTyK_SnBPm@\ngJX@@e\\u@]TLTzM]XIC~t@\ngJX@@e\\uQH]TLTyK]XI}~t@>\ngJX@@e\\uQH]TLTyKgAbf~g\\DaZ@<\ngJX@@e\\uQH]TLTyKgAbf~g\\DaZ@>\ngJX@@e\\uQH]TLTyM]XIC~t@<\ngJX@@e\\uQH]TLTyM]XIC~t@>\ngJX@@e\\uQH]TLTyMgAbf~g\\DaZ@<\ngJX@@e\\uQH]TLTyMgAbf~g\\DaZ@>\ngJXA@IRVX@NiFzvst\ngJXA@IRVX@NiGNCGM|N{Yz\ngJXA@IRVh@NiFzvsl=\ngJXA@IRVh@NiFzvst\ngJXA@IRVh@NiFzwSt=\ngJXA@IRVh@NiF~Gml{@=\ngJXA@IRVh@NiF~Gml}@\ngJXA@IRVh@NiF~Gmt}@=\ngJXA@IRVh@NiGNCEMungh\ngJXA@IRVh@NiGNCEM|O[iz\ngJXA@IRVh@NiGNCGMumgh\ngJXA@IRVi`NcENRwaB\ngJXA@IRVi`NcENRypXynmta@\ngJXA@IRVi`NcENRypXyoBD\ngJXA@IRVj`NcENRwVBP`\ngJXA@IRVjhdNcENRypXinlDa@<\ngJXA@IRVjhdNcENRypXinlDa@>\ngJXA@IRVjhdNcENRypXioa{AHP<\ngJXA@IRVjhdNcENSWVBP`>\ngJXA@IRVjhdNcENSYpXinlDa@<\ngJXA@IRYHPNddmtN{X\ngJXA@IRYZPNcENRwP{o@\ngJXA@IRYZPNcENRwVB^`\ngJXA@IRYZPNcENRwp{`gh\ngJXA@IRYZPNcENRypXyoawAOP\ngJXA@IRYZPNcENRytTyoawAOP\ngJXA@IRYjiDNcENRwVBP`<\ngJXA@IRYjiDNcENRwVBP`>\ngJXA@IRYjiDNcENRwVB_@<\ngJXA@IRYjiDNcENRwVB_@>\ngJXA@IRYjiDNcENRyHXis]XIB>\ngJXA@IRYjiDNcENRyHXis][qB<\ngJXA@IRYjiDNcENRyHXis_CvBP`<\ngJXA@IRYjiDNcENRyHXis_CvBP`>\ngJXA@IRYjiDNcENRypXynlDa@<\ngJXA@IRYjiDNcENRypXynlDa@>\ngJXA@IRYjiDNcENRytTynlDa@<\ngJXA@IRYjiDNcENRytTynlDa@>\ngJXA@IRYjiDNcENSWVBP`<\ngJXA@IRYjiDNcENSWVBP`>\ngJXA@IRYjiDNcENSYpXynlDa@<\ngJXA@IRYjiDNcENSYtTynlDa@>\ngJXA@IRYjiDNcENbwVBP`>\ngJXA@IRYjiDNcENbypXynlDa@<\ngJXA@IRYjiDNcENbypXynlDa@>\ngJXA@IR[B`Nedm|MkYB\ngJXA@IR[B`Nedm|MkiB\ngJXA@IRfd@NdEMumg_{P@=\ngJXA@IRfd@NdEMumgo{P@\ngJXA@IRfd@NdEM|n{Yw~t@=\ngJXA@IRfd@NdEM|n{Y{~t@\ngJXA@IRfd@NdEM|n{i{~t@=\ngJXA@IRfd@NdEN\\FN[y]vsw}h@\ngJXA@IRfe`NjFJ\\es`qS]KiC~t@\ngJXA@IRfh@NdEM|`{Yv=\ngJXA@IRfj`NjFJ\\eodGAHP\ngJXA@IRfjiDNjFJ\\es`qS_HNBP`<\ngJXA@IRfjiDNjFJ\\es`qS_HNBP`>\ngJXA@IRfjiDNjFJ\\fodGAHP<\ngJXA@IRfjiDNjFJ\\fodGAHP>\ngJXA@IRij`NjFJ\\eodGAHP\ngJXA@IRij`NjFJ\\eodGAO`\ngJXA@IRij`NjFJ\\erPqSf~P\\Da@\ngJXA@IRij`NjFJ\\erPqSf~P\\D~@\ngJXA@IRij`NjFJ\\fodGAHP\ngJXA@IRijhDNjFJ\\es`qs_HNBP`<\ngJXA@IRijhDNjFJ\\es`qs_HNBP`>\ngJXA@IRijhDNjFJ\\fs`qs_HNBP`<\ngJXA@IRijhDNjFJ\\fs`qs_HNBP`>\ngJXA@IRkZ`NjFJ\\enlDaZ@\ngJXA@IRkZ`NjFJ\\eoiwAH_v`@\ngJXA@IRkZ`NjFJ\\es`qs]XIC~t@\ngJXA@IRkZ`NjFJ\\es`qs_SnBPm@\ngJXA@IRkZ`NjFJ\\eshis]XIC~t@\ngJXA@IRkZ`NjFJ\\eshis_SnBPm@\ngJXA@IRkZ`NjFJ\\fnlDaZ@\ngJXA@IRkZ`NjFJ\\foiwAH_v`@\ngJXA@IRkZ`NjFJ]EoiwAH_v`@\ngJXA@IRkZ`NjFJ]Es`qs]XIC~t@\ngJXA@IRkZ`NlII[z[vrG}h@\ngJXA@IRkZ`NlII[z[wRG}h@\ngJXA@IRkZ`NlII[z]vrG}h@\ngJXA@IRkZ`NlII[z]wRG}h@\ngJXA@IRkZ`NlIIkz[vrG}h@\ngJXA@IRkZ`NlIIkz[wRG}h@\ngJXA@IRkZ`NlIIkz]vrG}h@\ngJXA@IRkZ`NlIIkz]wRG}h@\ngJXA@IRnZ`NjFJ\\eoiwAH_v`@\ngJXA@IRnZhdNjFJ\\fs`qS_SnBPm@<\ngJXA@IRnZhdNjFJ\\fs`qS_SnBPm@>\ngJXA@IrRDJ@zVRwtvmdO{P@=\ngJXA@IrRDJ@zVRwtvndO{P@\ngJXA@IrRDJ@zVRwtzndO{P@=\ngJXA@IrRDJ@zVRypTyoiu]H_v`@\ngJXA@IrRDJ@zVRytTyoim]H_v`@\ngJXA@IrRDJ@zVSWtvmdO{P@=\ngJXA@IrRDJ@zVSWtvndO{P@\ngJXA@NRfh@NdEM|`{Yw~t@=\ngJXA@NRfi`NjFJles`qS_HNzPm@\ngJXAAnR[f`NmKIkx[WRD\ngJXDB@cABTuRAu`qS^HH\ngJXDB@cABTuRAu`rS_HNv]`\ngJXDD@bABUuTAtPirVzpRG}h`=\ngJXDHOA^BS]TAuhyK^DH\ngJXDHOA^BS]TAuhyK_Cr|PmH=\ngJXDL@aABSKTAuhiK^DH\ngJXDL@aABS[TAuhyK^DO{S@\ngJXDL@bABUu@Au@wVv]`\ngJXH@jAJZ`@z`[k[Nv`@=\ngJXH@jAJZ`@z`[k]OP=\ngJXH@jAJZ`@z`\\xLTwVz^`\ngJXH@jAJZ`@z`\\xL\\wVv^m@\ngJXH@jAJzj@zhYIr[NCEM}@xIC~t@>\ngJXH@jAJzj@zhYIt[NCEM}@xIB>\ngJXH@jAJzj@zhYIt[NCEM}@xIC~t@>\ngJXHAJAIfi@zLTyKgAcf|pP>\ngJXHAJAIfi@zLTzKgAcf|pP>\ngJXHAjAJfi@zHXiKgASf|P_v`@\ngJXHAjAJfi@zHXiKgAcfzPSw}h@\ngJXHAjAJfi@zHXiKgAcf|P_v`@\ngJXHAjAJfi@zHXjK]HI{~t@\ngJXHAjAJfj@zHXiKgAcf~P]xaZ@\ngJXHAjAJfj`PzHXjK]HIB<\ngJXHAjAJfj`PzHXjK]HIB>\ngJXHB@aIfe@zTdwPwm`\ngJXHB@aInZ@zTlwPvm`\ngJXHB@aInZ@zTlwPvn`\ngJXHB@aInZ@zTlytTynam]@\ngJXHBOAJfj@zHXis]HNB\ngJXHBOAJfj@zHXisdabgMt`xH\ngJXHBOAJfj@zHXju]HNB\ngJXHBOAJfj`PzHXiu]HNB<\ngJXHBOAJfj`PzHXiu]HNB>\ngJXHD@aIZjbPzLTyKgAbfzpRD<\ngJXHD@aIZjbPzLTyKgAbfzpRD>\ngJXHD@aIej@zLTyK]XIC~tP\ngJXHD@aIej@zLTyKgQSfzpRG}h`\ngJXHD@aIej@zLTyM]XIC~tP\ngJXHD@aIej@zLTyMgQSfzpRG}h`\ngJXHD@aIej@zLTzK]XIC~tP\ngJXHD@aIej@zLTzKgQSfzpRG}h`\ngJXHD@aIej@zLTzM]XIC~tP\ngJXHD@aIfe@ztdenao]ZH\ngJXHD@aIfe@ztdeshis_C^z^mD\ngJXHD@aIff@zLTyK][iC~tP\ngJXHD@aIff@zLTyM][iC~tP\ngJXHD@aIff@ztdeoao]H_vb@\ngJXHD@aIff@ztdfoao]H_vb@\ngJXHD@aIff@ztdfshis_C^zPmD\ngJXHD@aImi@zt\\eshir\ngJXHD@aImj@zt\\eshis^DH\ngJXHD@aInZ@ztleoam[HP\ngJXHD@aInZ@ztlfoam[HP\ngJXHDHaIfe@zLTyKgQSf|O_vb@\ngJXHDOAIZj@zLTyK]XIB\ngJXHDOAIZj@zLTyK_CvBP`\ngJXHDOAIZj@zLTyKdabgMu`dH\ngJXHDOAIZj@zLTyKdabgM|OXIB\ngJXHDOAIZj@zLTyM]XIC~tP\ngJXHDOAIfjdPzLTzM_CvBPmD>\ngJXHH@aIYj@zLTyK]XIC~t`\ngJXHH@aIZ`@zd[x^vso}i@=\ngJXHH@aIZ`@zd[x^vsw}i@\ngJXHH@aIZ`@zd[x^wSw}i@=\ngJXHH@aIZ`@zd\\xL\\wp}mgo{R@\ngJXHH@aIZf@zLTyK_CvzPmH\ngJXHH@aIZf@zLTyKgAbf~GmtaZP\ngJXHH@aIZf@zTUWp}ngo{R@\ngJXHH@aIZj@zLTyK]XIC~t`\ngJXHH@aIZj@zLTyK_CvBPmH\ngJXHH@aIZj@zLTzM]XIC~t`\ngJXHH@aIZj@zLTzM_CvBPmH\ngJXHH@aIZjbPzLTyK]XI}~t`<\ngJXHH@aIZjbPzLTyK]XI}~t`>\ngJXHH@aIZjbPzLTyK_CvB__mH<\ngJXHH@aIZjbPzLTyK_CvB__mH>\ngJXHH@aIZjbPzLTyKgAbf~GlDaZP<\ngJXHH@aIZjbPzLTyKgAbf~GlDaZP>\ngJXHH@aIZjbPzLTyM]XIC~t`<\ngJXHH@aIZjbPzLTyM]XIC~t`>\ngJXHH@aIZjbPzLTyM_CvBPmH<\ngJXHH@aIZjbPzLTyM_CvBPmH>\ngJXHH@aIZjbPzLTzK]XI}~t`<\ngJXHH@aIZjbPzLTzK_CvB__mH<\ngJXHH@aIZjbPzLTzK_CvB__mH>\ngJXHH@aIfi@zLTyK_CvB^mH\ngJXHH@aIfi@zLTyKgQSfzGlG}i@\ngJXHH@aIfi@zLTyKgQSf~GlD}ZP\ngJXHH@aIfj@zLTyK_CvBPmH\ngJXHH@aIfj@zLTyKgAcf~GlDaZP\ngJXHH@aIfj@zLTyKgQSf~GlDaZP\ngJXHH@aIfj@zLTyKgQSf~GlD~ZP\ngJXHH@aIfj@zLTyKgQSf~GmxaZP\ngJXHH@aIfj@zLTyM_CvBPmH\ngJXHH@aIfj@zLTyMgQSf~GlDaZP\ngJXHH@aIfj@zLTzK_CvBPmH\ngJXHH@aIfj@zLTzKgQSf~GlDaZP\ngJXHH@aIfj@zLTzKgQSf~GlD~ZP\ngJXHH@aIfj@zLTzM_CvBPmH\ngJXHH@aJz`@z`[k[OP\ngJXHH@aJz`@z`\\xL\\wVv^`\ngJXHHGAIZ`@zd[x^vsw}i@\ngJXHHGAIZ`@zd[x^wSt=\ngJXHHGAIfj@zLTyKgQSf~GlDaZP\ngJXHHGAIfjdPzLTzK_CvB_@<\ngJXHHGAIfjdPzLTzK_CvB_@>\ngJXHHOAIY`@zd[k[Nvd@=\ngJXHHOAIY`@zd[k[O_vd@\ngJXHHOAIY`@zd[k]O_vd@=\ngJXHHOAIZ`@zd[k[O_vd@\ngJXHHOAIZ`@zd[x^vso}i@=\ngJXHHOAIZ`@zd[x^vsw}i@\ngJXHHOAIZ`@zd[x^wSw}i@=\ngJXHHOAIZ`@zd\\xL\\wp}mgo{R@\ngJXHHOAIZj@zLTyK_CvBPmH\ngJXHHOAIZjbPzLTyM_CvBPmH<\ngJXHHOAIZjbPzLTyM_CvBPmH>\ngJXHHOAIfj@zLTyK_CvBPmH\ngJXHHOAIfj@zLTyKgAcf~GlDaZP\ngJXHHOAIfj@zLTyKgAcf~GlD~ZP\ngJXHHOAIfj@zLTyKgQSf~GlDaZP\ngJXHHOAIfj@zLTyM_CvBPmH\ngJXHHOAIfj@zLTyMgAcf~GlDaZP\ngJXHHOAIfj@zLTzK]XIC~t`\ngJXHHOAIfjdPzLTyK]XIB<\ngJXHHOAIfjdPzLTyK]XIB>\ngJXHHOAIfjdPzLTyK_CvBP`>\ngJXHHOAJfj@zhXjtZ~P\\DaZP\ngJXHL@aIZ`@zd[k[Np\ngJXHL@aIZ`@zd[k[OP\ngJXHL@aIZf@ztTfs`qS^DH\ngJXHL@aIZf@ztTfs`qs_CvzP`\ngJXHL@aIZjb`ztTeoBD<\ngJXHL@aIZjb`ztTeoBD>\ngJXHL@aJZ`@zPTwrCmgX\ngJXHL@aJZ`@zPTwrCmgh\ngJXHL@aJZ`@zPTwrCngX\ngJXHL@aJZ`@zPTypXyodG[OP\ngJXHL@aJZ`@zPUWrCmgX\ngJXHL@aJZ`@zPUWrCmgh\ngJXHL@aJZ`@zPUYpXyodG[OP\ngJXHL@aJZf@zHXiK]HIB\ngJXHL@aJZf@zpYIodG[OP\ngJXHL@aJZf@zpYIs`qs_HNv^`\ngJXHL@aJZi@zHXiK]HIz\ngJXHL@aJZi@zHXjK]HIz\ngJXHL@aJZi@zpYIodG[OP\ngJXHL@aJZjdPzHXjMgAbfzPRD<\ngJXHL@aJZjdPzHXjMgAbfzPRD>\ngJXHLDQJZ`@zPTwrCmgX\ngJXHLJqIZjb`ztTeoBD<\ngJXHLLQIZ`@zd[k[OP\ngJXHLLQIZ`@zd[k]OP\ngJXHLLQIZjb`ztTeoBD<\ngJXHLOAIZ`@zd[x^vsl\ngJXHLOAIZi@zTUWp}mgX\ngJXHaj@SnRkZ`NbFJRwV|Pm@\ngJXIB@`rdwM@]JV[h[Vp\ngJXID@aRdwL`]ZVRwPvn`\ngJXIDOARdmU@]FJ\\eoa{AHP\ngJXIH@b\\dmP@]RM|O[Yw~t`=\ngJXIHOBRdlp@]RMungo{R@=\ngJXIHOBRdlu@]FJ\\enlDaZP\ngJXIHOBRdru@]FJ\\enlDaZP\ngJXIL@cRdmP@]RMumgX\ngJXIL@cRdmUQP]ZJRwaB<\ngJXIL@cRdmUQP]ZJRwaB>\ngJXLB@bAFBDkjdCiAU][Yv\ngJXLL@aAABDfVhCiQR\ngJX`BDdru@]ZJ\\wfB\ngJX`BDdru@]ZJ\\wf|\ngJX`BDdru@]ZJ]WfB\ngJX`BDdvu@]JNP\ngJX`BDdwU@]JNP\ngJX`BLeMT`]XLTwbB\ngJX`DBdru@]ZJ\\wfC~tP\ngJX`DBdru@]ZJ\\wf}~tP\ngJX`DBdru@]ZJ]WfC~tP\ngJX`DBdvu@]JNP\ngJX`DBdvu@]JN\\zJ\\`\ngJX`DBdwM@]JV[h[Vp\ngJX`LDdru@]ZJRwaB\ngJX`LDdru@]ZJRwa|\ngJX`LDdru@]ZJRytTyoBD\ngJX`LDdru@]ZJRytTyoCx\ngJX`LDdru@]ZJSWaB\ngJX`LDdru@]ZJSYtTyoBD\ngJX`LDdvt`]ZNRwa{~tp\ngJX`LDdvu@]ZNRwaC~tp\ngJX`LDdvu@]ZNRwa}~tp\ngJX`LDdvu@]ZNRytTyoBG}i`\ngJX`LDdvu@]ZNRytTyoC{}i`\ngJX`LDdvu@]ZNSWaC~tp\ngJX`LDdvu@]ZNSYtTyoBG}i`\ngJX`bDnLiMmPGRcd\ngJX`bDnLiMmPGRcf|O`\ngJX`hEIWIMmHGVcdmx^mH\ngJX`hEIWIMmHGVcdo{R@\ngJX`hEIWIMmPGVcdmxPmH\ngJX`hEIWIMmPGVcdmx__mH\ngJXaBDYR[Z`NeGH\ngJXaBDYR[Z`NeGMx_@\ngJXaBDnR[Z`NeGH\ngJXaLDnR[Z`NmGI[paZX\ngJXhMDOAJfj`PzpXfoBD<\ngJXhMDOAJfj`PzpXfoBD>\ngJXhMDOAJfj`PzpXfs`qs^DH<\ngJXhMDOAJfj`PzpXfs`qs^DH>\ngJY@BDfVhCkQSf|pP\ngJY@BDfVhCkQSj|pP\ngJY@BDfZTCiRS]C^v\ngJY@BDfZjQCkQSf|pP<\ngJY@BDfZjQCkQSf|pP>\ngJY@BDfZjQCkQSgNCGMy``<\ngJY@BDfZjQCkQSgNCGMy``>\ngJY@BDfZjQCkQSgNbgMy``<\ngJY@BDfZjQCkQSgNbgMy``>\ngJY@BDfZjQCkQSj|pP<\ngJY@BDfZjQCkQSj|pP>\ngJY@BDfZjQCkQSkNCGMy``>\ngJY@BDfyhCiRs]CZv\ngJY@DDefhChqSdmu`dO{Q@=\ngJY@DDefhChqSduu`dO{Q@\ngJY@DDejhChqSdmu`dO{Q@=\ngJY@DDejhChqSdn\\FN[kAOovb@\ngJY@DDejhChqSduu`dO{Q@\ngJY@DDejhChqSdv\\FJ[kAH_vb@\ngJY@DDejhCiQU][Y{~tP\ngJY@DDejjIChqSdn\\FJ[kAHP<\ngJY@DDejjIChqSdn\\FJ[kAHP>\ngJY@DDfVdChqSdn]EN[kAO_vb@\ngJY@DDfVdChqShmu`go{Q@\ngJY@DDfVdChqShn]EN[kAO_vb@\ngJY@DDfVhChqSdmu`dO{Q@\ngJY@DDfVhChqSdmu`gw{Q@\ngJY@DDfVhChqSdmuoDO{Q@\ngJY@DDfVhChqSdmuoGw{Q@\ngJY@DDfVhChqSdn]EN[kAH_vb@\ngJY@DDfVhChqSdn]EN[kAOovb@\ngJY@DDfVhChqSdn]EN[k^H_vb@\ngJY@DDfVhChqSdn]EN[k^Oovb@\ngJY@DDfVhChqSduu`dO{Q@\ngJY@DDfVhChqSduuoDO{Q@\ngJY@DDfVhChqSdv]EN[kAH_vb@\ngJY@DDfVhChqSdv]EN[k^H_vb@\ngJY@DDfVhChqShmu`dO{Q@\ngJY@DDfVhChqShmu`gw{Q@\ngJY@DDfVhChqShn]EN[kAH_vb@\ngJY@DDfVhChqShn]EN[kAOovb@\ngJY@DDfVhChqShuu`dO{Q@\ngJY@DDfVhChqShv]EN[kAH_vb@\ngJY@DDfZTCkRRVzF}w}h`\ngJY@DDfZXChqSdmundO{Q@\ngJY@DDfZXChqSduundO{Q@\ngJY@DDfZjQChqSdmu`dO{Q@<\ngJY@DDfZjQChqSdmu`dO{Q@>\ngJY@DDfZjQChqSdn]EN[k^H_vb@<\ngJY@DDfZjQChqSduu`dO{Q@<\ngJY@DDfZjQChqShuu`dO{Q@<\ngJY@DDfZjQChqShuu`dO{Q@>\ngJY@DDfvdCkQrT\ngJY@DDfvdCkQrV|OP\ngJY@DDfvdCkQrWNbgH\ngJY@DDfvdCkQrWNbgMx^`\ngJY@DDfvhCkQrV|HP\ngJY@DDfvhCkQrV|O`\ngJY@DDfvhCkQrWNbgMxP`\ngJY@DDfvhCkQrWNbgMx_@\ngJY@DDfvhCkQrZ|HP\ngJY@DDfvhCkQr[NbgMxP`\ngJY@DDfydCkRrVzFul\ngJY@DDfyhCkRrV~Fula@\ngJY@DDfyhCkRrZ~Fula@\ngJY@DDfzjQCkQrWNBgMxP`<\ngJY@DDfzjQCkQrWNBgMxP`>\ngJY@DDfzjQCkQrWNbgMxP`<\ngJY@DDfzjQCkQrWNbgMxP`>\ngJY@HDef@CjQnmt}ZP=\ngJY@HDfZjQChqSdn]EN[kAHP<\ngJY@HDfZjQChqSdn]EN[kAHP>\ngJY@HDfZjQChqSduu`dH<\ngJY@HDfZjQChqSduu`dH>\ngJY@HDfZjQChqShn\\FN[kAHP<\ngJY@HDijhCjabgI[yApRD\ngJY@HDijhCjabgI[yApRG}i@=\ngJY@HDijhCjabgI[yApS{}i@\ngJY@HDijhCjabgI[yAwcx\ngJY@HDijhCjabgI\\xLTwrC`dO{R@\ngJY@HDijhCjabgIkyApRG}i@\ngJY@HDijjQCjabgI[yApSx<\ngJY@HDijjQCjabgI[yApSx>\ngJY@HDijjQCjabgI\\xLTwrC`dH<\ngJY@HDijjQCjabgI\\xLTwrC`dH>\ngJY@HDijjQCjabgIlxLTwrC`dH<\ngJY@HDijjQCjabgIlxLTwrC`dH>\ngJY@HDkjhChaSdmu`dH\ngJY@HDkjhChaSdnRFJ\\wVBP`\ngJY@HDkjjIChaSdn\\FJ[kAHP<\ngJY@HDkjjIChaSdn\\FJ[kAHP>\ngJY@HDkjjIChaSduu`dH<\ngJY@HDkjjIChaSduu`dH>\ngJY@HDkjjIChaSdv\\FJ[kAHP<\ngJY@HDkjjIChaSdv\\FJ[kAHP>\ngJY@LDef@CjQnml{@\ngJY@LDefdCiQU][Yv\ngJY@LDefdCiQU][Yz\ngJY@LDefdCiQU][iv\ngJY@LDefdCiQU][iz\ngJY@LDej@CjQnml{@\ngJY@LDejXCkQRV|HP\ngJY@LDejdCiQU][Yv\ngJY@LDejdCiQU][Yz\ngJY@LDejdCiQU][iz\ngJY@LDejdCiQUgAbfzwSl\ngJY@LDejjJCkQRV|HP<\ngJY@LDejjJCkQRV|HP>\ngJY@LDejjJCkQRWNCEMxP`<\ngJY@LDejjJCkQRWNCEMxP`>\ngJY@LDejjJCkQRWNCGMxP`<\ngJY@LDejjJCkQRWNCGMxP`>\ngJY@LDejjJCkQRZ|HP<\ngJY@LDejjJCkQRZ|HP>\ngJY@LDejjJCkQR[NCEMxP`<\ngJY@LDejjJCkQR[NCEMxP`>\ngJY@LDij@CiAS_HNv]`\ngJY@LDij@CiAS_HNv^`\ngJY@LDij@CiASgAcf~P]l}@\ngJY@LDij@CiAU_HNv]`\ngJY@LDij@CiAU_HNv^`\ngJY@LDij@CiAUgAcf~P]l}@\ngJY@LDijXChabdmt`dH\ngJY@LDijXChabdmt`gp\ngJY@LDijXChabdn\\FJ[iAHP\ngJY@LDijXChabdut`dH\ngJY@LDijXChabdv\\FJ[iAHP\ngJY@LDijXChabdv\\FN[yAwRD\ngJY@LDijXChabhn\\FN[yAwRD\ngJY@LDijXCkAdf~P]l}@\ngJY@LDijXCkAdgNCGM|`{Yz\ngJY@LDijXCkAdj~P]l}@\ngJY@LDijdChabdmx``\ngJY@LDijdChabdn\\FN[iAOP\ngJY@LDijdChabdn\\FN[i^OP\ngJY@LDijdChabhn\\FN[iAOP\ngJY@LDijdCkAdf~P]t{@\ngJY@LDijdCkAdf~P]t}@\ngJY@LDijdCkAdgNCGM|`{Yz\ngJY@LDijdCkAdgNCGM|`{iz\ngJY@LDijdCkAdj~P]t}@\ngJY@LDijjQChabdmt`dH<\ngJY@LDijjQChabdmt`dH>\ngJY@LDijjQChabdn\\FJ[iAHP<\ngJY@LDijjQChabdn\\FJ[iAHP>\ngJY@LDijjQChabdn\\FN[iAHP<\ngJY@LDijjQChabdn\\FN[iAHP>\ngJY@LDijjQChabdut`dH<\ngJY@LDijjQChabdut`dH>\ngJY@LDijjQChabdv\\FJ[iAHP<\ngJY@LDijjQChabdv\\FJ[iAHP>\ngJY@LDijjQChabhv\\FJ[iAHP<\ngJY@LDijjQChabhv\\FJ[iAHP>\ngJY@dAreInZ@zt\\eshis^DH\ngJYABCJSKTAuhiu^XH\ngJYABCJSMUHauhis]XI|<\ngJYABCJSMUHauhis^XH<\ngJYABCJSMUHauhis^XH>\ngJYABCJSMUHauhiu^XH<\ngJYABCJSMUHauhiu^XH>\ngJYABCJS\\tAtiYnam[@\ngJYADArSMLAtXirWNbgMxPmD\ngJYADEJS[RAuhyKgQSf|OP\ngJYALMJRuUEAuhiK^DH<\ngJYALMJRuUEAuhiK^DH>\ngJYALMJTu@At`iodG[Np\ngJYDC`DPHRni`NdEH\ngJYHC`DIKTpGRbd\ngJYHC`DIKTpGRbgNCGH\ngJYHC`DISTpGVCEUx``\ngJYHC`DISUHGVCIM|`{Yv\ngJYHC`VIKTpGRbf|G`\ngJYHCaDIKTpGRbd\ngJYHCaxIKTpGRbf|G`\ngJYHDPDIMsPGRefzFul\ngJYHE@DIUmLBGQBgI[k^O_vb@<\ngJYHE@DIUmTBGQBgI[k^H_vb@<\ngJYHE@DIUmTBGQBgI[k^H_vb@>\ngJYHE@DIUmTBGQBgI[k^Oovb@<\ngJYHE@DIUmTBGQBgI[k^Oovb@>\ngJYHE@DIUmTBGQBgQ[kAH_vb@>\ngJYHI`DIKTpGVbdmtODO{R@\ngJYHI`DIKTpGVbdutODO{R@\ngJYHIaxIKTpGVbdmtOGw{R@\ngJYHIaxIKTpGVbdutODO{R@\ngJYHLEPISTpGVCDv\\FJ[i^HP\ngJYHL`DILmPGVbdmxP`\ngJYHL`DILmPGVbduxP`\ngJYHL`DILtpGVbdmxP`\ngJYHL`DILtpGVddm|M{YB\ngJYHL`DIMmPGVcdmxPmL\ngJYHL`DIMmPGVcduxPmL\ngJYHM@DIKT@GTc_Cvv^`\ngJYHlEPKmJTuLAu`qMgAbf~Wmta@\ngJY`BEdfVhCiQR\ngJY`LDTfvhCiQs~tp\ngJY`hEiNyIej@ztTeoBG}i@\ngJYieLPxAeIyIZf@zTTmD\ngJ\\@@bdrQ@]QMtM{_{Q@\ngJ\\@@bdrQ@]QMtM{o{Q@\ngJ\\@@bdru@]JR[h[w_vb@\ngJ\\@@bdru@]ZJ]YpXyoLG}h`\ngJ\\@@bdru@]ZJ]YtTynawAZH\ngJ\\@@bdvt`]JV[h[Vp\ngJ\\@@bdvt`]JV[h[WP\ngJ\\@@bdvu@]JNP\ngJ\\@@bdvu@]JV[h[Vp\ngJ\\@@bdvu@]JV[h[WP\ngJ\\@@ldru@]ZJRwPzPmD\ngJ\\@@ldru@]ZJRwaC~tP\ngJ\\@@ldru@]ZJRypXyoBG}h`\ngJ\\@@ldru@]ZJRytTyoBG}h`\ngJ\\@@ldru@]ZJSWPzPmD\ngJ\\@@ldru@]ZJSWaC~tP\ngJ\\@@ldru@]ZRRwpwmdO{Q@\ngJ\\@@ldru@]ZRRwpwndO{Q@\ngJ\\@@ldru@]ZRRytTyoao]H_vb@\ngJ\\@@ldru@]ZRSWpwmdO{Q@\ngJ\\@@ldru@]ZRSWpwndO{Q@\ngJ\\@@ldvE@]KI[x[VrG}i`=\ngJ\\@@ldvE@]KI[x[Vs{}i`=\ngJ\\@@ldvE@]KIkx[VrG}i`=\ngJ\\@ABeWU@]HR[j[vv`@\ngJ\\@ABeWU@]HR[j[w_v`@\ngJ\\@ABeWU@]XJ\\wfC~t@\ngJ\\@ABeWU@]XJ\\ytTyoLG}h@\ngJ\\@ADeSU@]XTSWrwndO{HP\ngJ\\@ADe\\u@]DJ\\enlDaYA@=\ngJ\\@ADe\\u@]DJ\\es`qS]XIC~rB@\ngJ\\@AEddMTAuaYK_SZvPm@=\ngJ\\@AEddMTAuaYM_SZvPm@=\ngJ\\@ALe\\p@]PMumg_{P@\ngJ\\@ALe\\s@]HJkk[O_v`@\ngJ\\@ALe\\s@]XJSYpXinitaZ@\ngJ\\@ALe\\t`]HJkk[Nv`@\ngJ\\@ALe\\t`]HJlxLTwVz^m@\ngJ\\@AbeMK@]XLTwb{~t@\ngJ\\@AbeMK@]XLTypXioEw}h@\ngJ\\@AbeMK@]XLTypXyoEw}h@\ngJ\\@`bnLiLmPGRdfzF}o}h`\ngJ\\A@bIR[Z`NeKMtMkX\ngJ\\A@bnR[Z`NeKMtMkX\ngJ\\A@lIRYZ`NmEI[h]H_vb@\ngJ\\A@lIRYZ`NmEI[paZH\ngJ\\A@lIRYZ`NmEI\\xL\\wPzPmD\ngJ\\A@lIRYZ`NmEI\\xL\\waC~tP\ngJ\\A@lIRYZ`NmEI\\zJ\\waC~tP\ngJ\\A@lIRYZ`NmEIkh]H_vb@\ngJ\\A@lIRYZ`NmEIkpaZH\ngJ\\A@lIRYZ`NmII[x[vrG}h`\ngJ\\A@lIR[B`Nedm|MkYC~tp\ngJ\\AAciRfe`NlFJ[i]w_v`@\ngJ\\AAciRfe`NlFJ[q]Z@\ngJ\\DAcJATBTuTAt`qs`qR>\ngJ\\HEb@aIej@zTTmD\ngJ\\HEb@aIfe@zTdwPwmmD\ngJ\\HEb@aInZ@zTlwPvmmL\ngJ\\HHlOAJfj@zpXeoC{|eBb\ngJ\\HHlOAJfj@zpXfoBG|eBcZP\ngJ\\HIb@aIZ`@zd[x^vso}i@=\ngJ\\HIbOAIY`@zd[k[Nvd@=\ngJ\\H`cj@SnR[Z`NeKMtNkh\ngJ\\Hib@b]iRVh@NiF~Gml{ZP\ngJ\\IIb@b\\dmP@]RM|O[Yw~t`=\ngJ\\aibEIW[dfvhCiQs~rf@\ngJ]@EbDfVhCiQS~tP\ngJ]@ebEqeIej@zTTmD\ngJ]AEbCJSKTAthiZH\ngKP@DklVj@zhXirVzpRG|dml\ngKP@DklVj@zhXirWICEN[kAH_rRvp\ngKP@DklVj@zhXirWICEN[z]pRG|dml\ngKP@DklVjbPzhXirV~g\\D~IK[@<\ngKP@DklVjbPzhXirV~g\\D~IK[@>\ngKP@DklVjbPzhXirWICEN[kAOorRvp<\ngKP@DklVjbPzhXirWICEN[kAOorRvp>\ngKP@LdabjhCjabgI[zAPRG|dML\ngKP@LdabjjACjabgI[zAWbG|dML<\ngKP@LdabjjACjabgI[zAWbG|dML>\ngKP@LdabjjACjabgI\\dLTyohE^H_rPtp<\ngKP@LdabjjACjabgI\\dLTyohE^H_rPtp>\ngKP@LdabjjACjabgI\\xJ\\wtBoDOyHZX<\ngKP@LdabjjACjabgI\\xJ\\wtBoDOyHZX>\ngKP@LdabjjACjabgI\\zJ\\wtBoDOyHZX<\ngKP@LdabjjACjabgI\\zJ\\wtBoDOyHZX>\ngKP`@TixjjdPztTyoDG|dL\\<\ngKQ@@dmcUPGQbgI[kAH_rRvp\ngKQ@@eOEUTbGQbgI[iAH_rPqp<\ngKQ@@eOEUTbGQbgI[iAH_rPqp>\ngKQ@@eOEUTbGQbgI[i^H_rPqp<\ngKQ@@eOEUTbGQbgI[i^H_rPqp>\ngKQ@@eOEUTbGQbgI\\yNRwRBPdac`<\ngKQ@@eOEUTbGQbgI\\yNRwRBPdac`>\ngKQ@@eOEUTbGQbgI\\yNRwR|Pdac`<\ngKQ@@eOEUTbGQbgI\\yNRwR|Pdac`>\ngKX@@dmcUPGQbgI[kAH_rRvp\ngNp@DiYzA@zVVwQw]`=\ngNp@DiYzA@zVVwqw]oh=\ngNp@DiYzB@zVVwqw]lH=\ngNp@DiYzB@zVVwqw^lH\ngNp@DiYzB@zVVwq{^lH=\ngNp@Djfjj@zxXirVk[uApRFaXP\ngNp@Djfjj@zxXirVk\\dLRuoTGAHZEa@\ngNp@Djfjj@zxXirVk\\dNRuoTGAOjEa@\ngNp@Djfjj@zxXirVk\\lLTyKV}P\\DahVD\ngNp@Djfjj@zxXirVk\\lLTyKV}P\\Daogx\ngNp@Djfjj@zxXirVk\\lLTyKV}P\\D~hVD\ngNp@Djfjj@zxXirVk\\tLTek^hNBPtKB\ngNp@Djfjj@zxXirVk\\tLTek^hNB_TKB\ngNp@Djfjj@zxXirVskuApRFaXP\ngNp@Djfjj@zxXirVsldNRuoTGAOjEa@\ngNp@Djfjj@zxXirZk[uApRFaXP\ngNp@Djfjj@zxXirZk\\lLTyKV}P\\DahVD\ngNp@Djfjj@zxXirZk\\tLTek^hNBPtKB\ngNp@Djfjj@zxXitZk[uApRFaXP\ngNp@Djfjj@zxXitZskuApRFaXP\ngNp@DjfjjPTPzxXirVk\\tL\\ek^hNB_TK|<\ngNp@DjfjjPTPzxXirVk\\tL\\ek^hNB_TK|>\ngNp@DjfjjPTPzxXirZk\\tL\\ek^hNBPtK|<\ngNp@DjfjjPTPzxXirZk\\tL\\ek^hNBPtK|>\ngNp@DjfjjPTPzxXirZk\\xLRwjC`dMBp`<\ngNp@DjfjjPTPzxXirZk\\xLRwjC`dMBp`>\ngNp@DjfjjPTPzxXirZklxLRwjC`dMBp`<\ngNp@DjfjjPT`zxXirVk\\dL\\eoTGAOjEa@>\ngNp@DjfjjPT`zxXirVk\\tL\\ek^hNB_TK|>\ngNp@DjfjjPT`zxXirZk\\xLRwjC`dMBp`<\ngNp@DjfjjPT`zxXirZk\\xLRwjC`dMBp`>\ngNp@DjfjjPT`zxXirZklxLRwjC`dMBp`<\ngNp@DjfjjPT`zxXirZklxLRwjC`dMBp`>\ngNp@Djfjj`PzxXirVk\\tL\\ek^hNB_TKB<\ngNp@Djfjj`PzxXirVk\\tL\\ek^hNB_TKB>\ngNp@Djfjj`PzxXirZk\\dLRuoTGAHZEa@<\ngNp@Djfjj`PzxXirZk\\tL\\ek^hNBPtKB<\ngNp@Djfjj`PzxXirZk\\tL\\ek^hNBPtKB>\ngNp@DjfjjdPzxXirVk[uApRFa_`>\ngNp@DjfjjdPzxXirVk\\dLTeoTGAHZEa@<\ngNp@DjfjjdPzxXirVk\\dLTeoTGAHZEa@>\ngNp@DjfjjdPzxXirVk\\dLTuoTGAHZE~@<\ngNp@DjfjjdPzxXirVk\\dLTuoTGAHZE~@>\ngNp@DjfjjdPzxXirVk\\lLTyKV}P\\DahWx<\ngNp@DjfjjdPzxXirVk\\lLTyKV}P\\DahWx>\ngNp@DjfjjdPzxXirVk\\lLTyKV}P\\D~hWx<\ngNp@DjfjjdPzxXirVk\\tLTek^hNBPtK|<\ngNp@DjfjjdPzxXirVk\\tLTek^hNBPtK|>\ngNp@DjfjjdPzxXirVk\\xLRwjC`dMBp`<\ngNp@DjfjjdPzxXirVk\\xLRwjC`dMBp`>\ngNp@DjfjjdPzxXirVk\\xLZwjC`dMB@<\ngNp@DjfjjdPzxXirVk\\xLZwjC`dMB@>\ngNp@DjfjjdPzxXirVk\\xNRwjC`guBp`<\ngNp@DjfjjdPzxXirVk\\xNRwjC`guBp`>\ngNp@DjfjjdPzxXirVk\\xNZwjC`guB@<\ngNp@DjfjjdPzxXirVk\\xNZwjC`guB@>\ngNp@DjfjjdPzxXirVkkuApRFaXP<\ngNp@DjfjjdPzxXirVkkuApRFaXP>\ngNp@DjfjjdPzxXirVkldLTeoTGAHZEa@>\ngNp@DjfjjdPzxXirVkltLTek^hNBPtKB<\ngNp@DjfjjdPzxXirVklxLRwjC`dMBp`<\ngNp@DjfjjdPzxXirVklxLRwjC`dMBp`>\ngNp@DjfjjdPzxXirVklxLZwjC`dMBp`<\ngNp@DjfjjdPzxXirVklxLZwjC`dMBp`>\ngNp@DjfjjdPzxXirVslxLRwjC`dMBp`>\ngNp@DjfjjdPzxXirZk\\xNRwjC`dMBp`<\ngNp@DjfjjdPzxXirZk\\xNRwjC`dMBp`>\ngNp@DjfjjdPzxXirZkkuApRFaXP<\ngNp@DjfjjdPzxXirZkkuApRFaXP>\ngNp@DjfjjdPzxXitZk\\dJ\\eoTGAHZEa@>\ngNp@DjzZj@zhdejv}f}tahVD\ngNp@DjzZj@zhdejwNCGM{N{iCPlH\ngNp@DjzZj@zhdejwNbgM{M{iCPlH\ngNp@DjzZj@zhdejz}f}tahVD\ngNp@DjzZj@zhdelz}f}tahVD\ngNp@DjzZj@zxXirVk[gAHZEa@\ngNp@DjzZj@zxXirVk[v]pRFaXP\ngNp@DjzZj@zxXirVk\\fJ\\en]xahVD\ngNp@DjzZj@zxXirVk\\lLTyKVywbFaXP\ngNp@DjzZj@zxXirVk\\lLTyKV}g\\DahVD\ngNp@DjzZj@zxXirVk\\tLTyK\\xICPlH\ngNp@DjzZj@zxXirVk\\tLTyK\\{qCPlH\ngNp@DjzZj@zxXirVk\\tLTyK^snBPtKB\ngNp@DjzZj@zxXirVk\\tLTyK^sn|PtKB\ngNp@DjzZj@zxXirVk\\xLZwl{`dMB@\ngNp@DjzZj@zxXirVk\\xL\\wNBPtKB\ngNp@DjzZj@zxXirVk\\xL\\wl{`dMBp`\ngNp@DjzZj@zxXirVk\\zJZwNBPtK|\ngNp@DjzZj@zxXirVk\\zJ\\wNBPtKB\ngNp@DjzZj@zxXirVk\\zJ\\wN|PtKB\ngNp@DjzZj@zxXirVk\\zJ\\wl{oDMBp`\ngNp@DjzZj@zxXirVkkgAHZEa@\ngNp@DjzZj@zxXirVsldLRuoYwAHZEa@\ngNp@DjzZj@zxXitVk[gAHZEa@\ngNp@DjzZj@zxXitVk[v]pRFaXP\ngNp@DjzZj@zxXitVk\\tLTyK^snBPtKB\ngNp@DjzZj@zxXitVk\\xL\\wNBPtKB\ngNp@DjzZj@zxXitVkldL\\eoYwAHZEa@\ngNp@DjzZjbPzhdej{NCGM{N{iCPlH<\ngNp@DjzZjbPzxXirVk\\tLTyk\\xICPop<\ngNp@DjzZjbPzxXirVk\\tLTyk\\xICPop>\ngNp@DjzZjbPzxXirVk\\tLTyk^snBPtK|>\ngNp@DjzZjbPzxXirVklxL\\wl{`dMBp`<\ngNp@DjzZjbPzxXirVklxL\\wl{`dMBp`>\ngNp@DjzZjbPzxXirVslxLRwl{`dMBp`<\ngNp@DjzZjbPzxXirVslxLRwl{`dMBp`>\ngNp@LdadBj@zNRu[^sZvPtKB=\ngNp@LdadBj@zNRu[^sZvPtKC~RqI@=\ngNp@LdadBj@zNRu[^sZvPtKC~VqIi@=\ngNp@LdadBj@zNRu[^sZvPtK|=\ngNp@LdadBj@zNRu[^sZvPtK}~VqIi@=\ngNp@LdadBj@zNRu[^sZzPtKB\ngNp@LdadBj@zNRu[^sjzPtKB=\ngNp@LdadBj@zNRu[^sjzPtKC~RqI@=\ngNp@LdadBj@zNRu[dqSdm{MkiCPlH\ngNp@LdadBj@zNRu[gASV}gUtahWx\ngNp@LdadBj@zNRu[gASf}gUtahVD\ngNp@LdadBj@zNRu[gQSV}futahWx\ngNp@LdadBj@zNRu[gQSf}futahVD\ngNp@LdadBj@zNRu]^sZvPtKB=\ngNp@LdadBj@zNRu]^sZvPtKC~RqI@=\ngNp@LdadBj@zNRu]^sZzPtKB\ngNp@LdadBj@zNRu]dqSdm{MkiCPlH\ngNp@LdadBj@zNRu]gQSV}futahVD\ngNp@LdadBj@zNRu]gQSV}futahVG|ebR\ngNp@LdadBj@zNRv]^sZvPtKB=\ngNp@LdadBj@zNRv]^sZzPtKB\ngNp@LdadBj@zNRv]daRVm{NkiCPlH\ngNp@LdadBj@zNRv]dqRVm{MkiCPlH\ngNp@LdadBj@zNRv]gQSf}futahVD\ngNp@LdadBj@zNSU[^sZvPws|=\ngNp@LdadBj@zNSV[^sZvPtK|=\ngNp@LdadBj@zNSV[gQSV}futahWx\ngNp@LdadBj@zNSV]^sZvPtKB=\ngNp@LdadBj@zNSV]^sZzPtKB\ngNp@LdadBj@zNSV]dqSdm{MkiCPlH\ngNp@LdadBj@zNSV]gQSf}futahVD\ngNp@LdadBjfPzNRu[^sZvPtK}~Rqi@-\ngNp@LdadBjfPzNRu[gQSf}futahWx>\ngNp@LdadBjfPzNRu]dqSfm{MkiCPlH<\ngNp@LdadBjfPzNRu]dqSfm{MkiCPlH>\ngNp@LdadBjfPzNRu]gQSf}futahVD<\ngNp@LdadBjfPzNRu]gQSf}futahVD>\ngNp@LdadBjfPzNRv[^sZvPtK|+\ngNp@LdadBjfPzNRv[^sZvPtK|-\ngNp@LdadBjfPzNRv[^sZvPtK}~Rqi@+\ngNp@LdadBjfPzNRv[^sZvPtK}~Rqi@-\ngNp@LdadBjfPzNRv[gQRV}futahW{|ecR<\ngNp@LdadBjfPzNRv[gQRV}futahW{|ecR>\ngNp@LdadBjfPzNRv]gQRV}futahVD<\ngNp@LdadBjfPzNRv]gQRV}futahVD>\ngNp@LdadBjfPzNSV[gQSf}futahWx<\ngNp@LdadBjfPzNSV[gQSf}futahWx>\ngNpB@xQpSagCIIKJj`NbDmVwl|o[uBpe`XTP\ngNpB@xQpk`wAJkjj`NbENRwNBPws|\ngNpBADFPl`yAInij`NmENP\ngNpCAHR`TaiB]dTaeT@GTc]W[z\ngNpD@DHHRZzj@CiQK_DMv}`=\ngNpD@DHHRZzj@CiQK_Guv}`=\ngNpD@DHHRZzj@CiQM_DMv}`=\ngNpD@DHHRZzjhCjqrVk\\eNRuobFaXP\ngNpD@DIpRYjfhCiqSdmVwH|PtK|\ngNpD@DIpRYjfhCjrRVk[t[vrFaXP\ngNpD@DIpRYjfhCjrRVk[t[vrFa_`\ngNpD@DIpRYjfhCjrRVk[t[wRFaXP\ngNpD@DSpRZYj@CkQrVypRF{^p=\ngNpD@DSpRZYj@CkQtZypRF{^p=\ngNpD@DSpRZYj@CkQtZypRF{_P\ngNpD@DSpRZYj@CkQtZypRF}_P=\ngNpD@DSpRZYj@CkQt[MbgIZwNBPwkz=\ngNpD@DSpRZYjBQCkQrZypRF{^p+\ngNpD@DSpRZYjBQCkQrZypRF{^p-\ngNpD@DSpRZYjhCiqSdmVwNBPtKB\ngNpD@DSpRZYjjQCiqSduVwNBPtKB<\ngNpD@DSpRZYjjQCiqSduVwNBPtKB>\ngNpD@bIpRYjfhCjrRVk[t[vrFaXP\ngNpD@bQpRZZj@CkQtZypRF{^p=\ngNpD@bSpRZYj@CkQtZypRF{^p=\ngNpD@bSpRZYj@CkQtZypRF{_P\ngNpD@bSpRZYjBQCkQrZypRF{^p+\ngNpD@bSpRZYjBQCkQrZypRF{^p-\ngNpD@bSpRZYjhCiqSdmVwNBPtKB\ngNpD@xN`RjZjXCiabgIZwJC`dMz\ngNpD@xQpRjzj@CkArV}glDanwl=\ngNpD@xQpRjzj@CkArV}glDanwt\ngNpD@xQpRjzj@CkAtZ}glDanwl=\ngNpD@xQpRjzj@CkAt[IbgM[v^pRF{_P\ngNpD@xQpRjzjBACkArZ}glDanwl-\ngNpD@xQpRjzjhCiaSdmVwNBPtKB\ngNpD@xQpRjzjhCiaSdmVwl}`dMBp`\ngNpD@xRPRjzj@CkAtZypRF{^p=\ngNpD@xRPRjzj@CkAtZypRF{_P\ngNpD@xUpRjZjdCiabgIVwJC`dM|\ngNpD@xUpRjZjjQCiabgIWWjC`dM|p`<\ngNpD@xUpRjZjjQCiabgIWWjC`dM|p`>\ngNpDADFHR[jZhCjqSfk\\fJRuoevaXP\ngNpDAHJPRZzj@CiQK_DMv~`\ngNpDAHJPRZzj@CiQK_Guv}`=\ngNpDAHJPRZzj@CiQK_Guv~`\ngNpDAHJPRZzj@CiQK_Guz~`=\ngNpDAHJPRZzjXCjqrVk[xaoVD\ngNpDAxKpR[ijhCjqrVk[xahVD\ngNpDAxSpRjyj@CkAtZypRF{^p=\ngNpDAxSpRjyjBACkArZypRF{^p+\ngNpDAxSpRjyjBACkArZypRF{^p-\ngNpD`DR`Dsdffj`@zt]Fn\\DaoWt=\ngNpDaxF`Dgdjfj`@zpTynTGAnwl=\ngNpDaxF`Dgdjfj`@zpUZnTGAnwl=\ngNpDaxF`Dgdjfj`@zpUZoTGAOkm{@=\ngNpDaxF`Dgdjfj``PzpTznTGAnwl+\ngNpDaxF`Dgdjfj``PzpTznTGAnwl-\ngNpDaxF`Dgdjfj``PzpTznTGAnwt<\ngNpDaxF`Dgdjfj``PzpTzoTGAOkm{IPx`+\ngNpDaxF`Dgdjfj``PzpTzoTGAOkm{IPx`-\ngNpDaxF`Dgdjfjj@zXXisUmr`xMBp`\ngNpDaxF`Dgdjfjj@zXXisUmz`xI}PlH\ngNpDaxF`Dgdjfjj@zXXjuUmr`xMBp`\ngNpDaxF`Dgdjfjj`PzXXiuUmr`xMBp`<\ngNpDaxF`Dgdjfjj`PzXXiuUmr`xMBp`>\ngNpDaxR`Dsdffj`@zt]Fn\\DaoWt=\ngNpDaxR`Dsdffj`@zt]FoQ{AH[u}@=\ngNpDaxR`Dsdffj`dPzt\\foQ{AH[u}I@h`+\ngNpDaxR`Dsdffj`dPzt\\foQ{AH[u}I@h`-\ngNpE@DSpdiMMU@AuhzM\\xIC]oX=\ngNpE@bSpdiMMU@AuhzM\\xIC]oX=\ngNpE@bSpdiMMUAHauhyM\\xIC]oX+\ngNpE@bSpdiMMUAHauhyM\\xIC]oX-\ngNpE@bSpdiMMUTAtxirVk[gAHZEa@\ngNpEADR`gIMMU@AuhzM\\xIC^oh=\ngNpEAHR`gIMMU@AuhzM\\xIC]oX=\ngNpEAHR`gIMMU@AuhzM\\xIC^oh=\ngNpEAHR`gIMMU@AuhzMfqSdm[gAH[u}@=\ngNpEAVRDdiMMU@AuhzM\\xIC]oX=\ngNpEAVSpdiMMU@AuhzM\\xIC]oX=\ngNpEAVSpdiMMU@AuhzM\\xIC]oh\ngNpEAVSpdiMMUTAtxirVk[gAHZEa@\ngNpEAbSpdiMMU@AuhzM\\xIC]oX=\ngNpEAxF`DiUMU@Au`ju\\hNC]oX=\ngNpEAxF`DiUMUTAtpqSfk[eApZEa@\ngNpEAxRPDiU]U@Au`zM\\xIC]oX=\ngNpEAxRPDiU]U@Au`zM\\xIC^oh=\ngNpEAxR`gIMMU@AuhzM\\xIC^oh=\ngNpEAxSpDiUMUTAupqSdmgWjC`dMBp`\ngNpEAxSpDiU]U@Au`zM\\xIC]oX=\ngNpEAxSpDiU]UA@au`yM\\xIC]oX+\ngNpEAxSpDiU]UA@au`yM\\xIC]oX-\ngNpEAxSpDiU]UTAtpirVk[gAHZEa@\ngNpH@DIMMU@AuhyK\\xIC]oX=\ngNpH@DIMMU@AuhzM\\xIC]oX=\ngNpH@DIMMU@AuhzMdqSfms`dMv~`\ngNpH@DIMMUAHauhyK^cvBPw[w~RAQ@-\ngNpH@DIMMUAHauhyMdqSfms`dMv~`<\ngNpH@DIMMUAHauhyMdqSfms`dMv~`>\ngNpH@DIMuMTAuYYKUmzMkYCPlH\ngNpH@DIMuMTAuYYKUuzMkYCPlH\ngNpH@DIMuMTAuYYKYuzMkYCPlH\ngNpH@DISmW@At`iodF{_P\ngNpH@bIMMU@AuhzMdqSfms`dMv~`\ngNpH@bISmW@At`iodF{_P\ngNpH@xIUMU@AtPirV}P\\Danwl=\ngNpH@xIUMU@AtPirV}P\\Danwt\ngNpH@xIUMU@AtPirV}P\\DaoWt=\ngNpH@xIUMU@AtPirV}P\\D~nwl=\ngNpH@xIUMU@AtPirWNCFmz`xIC]oh\ngNpH@xIUMU@AtPirZ}P\\Danwl=\ngNpH@xIUMU@AtPirZ}P\\Danwt\ngNpH@xIUMU@AtPirZ}P\\DaoWt=\ngNpH@xIUMU@AtPir[NCfmz`xIC]oh\ngNpH@xIUMU@AtPitZ}P\\Danwl=\ngNpH@xIUMU@AtPitZ}P\\Danwt\ngNpH@xIUMU@AtPjtV}P\\D~nwl=\ngNpH@xIUMU@AtPjtZ}P\\Danwl=\ngNpH@xIUMU@AtPjtZ}P\\Danwt\ngNpH@xIUMU@AtPjt[NCFmz`xIC]oh\ngNpH@xIUMUA@atPitV}P\\D~nwl+\ngNpH@xIUMUA@atPitV}P\\D~nwl-\ngNpH@xIUMULAuPrSdmz`xIC^oX\ngNpH@xIUMULAupqSdmVwJC`dKB\ngNpH@xIUMULAupqSdmVwjC`dMzp`\ngNpH@xIUMULAupqSdmVwjC`dMzpdbZP\ngNpH@xIUMULAupqSdmWWjC`dMzp`\ngNpH@xIUMULAupqSduVwJC`dKB\ngNpH@xIUMUTAupqSdmVwjC`dMBp`\ngNpH@xIUMUTAupqSdmVwjC`guBp`\ngNpH@xIUMUTAupqSduVwjC`dMBp`\ngNpH@xIUMUTAupqShuVwjC`dMBp`\ngNpHABIUMM@AtPitZ}W\\Danwl=\ngNpHADIMMULAtxirVk\\vJ\\ek\\xIC^op\ngNpHAHILuUUHatxirVk\\zJ\\wNBPtKB<\ngNpHAHIMMU@AuhyK\\xIC]oX=\ngNpHAHIMMUUHatxirVk\\vJ\\ek\\xI}PlH<\ngNpHAbILuUUHatxirVk\\zJ\\wNBPtKB>\ngNpHAxIMMU@AuhzM\\xIC]oX=\ngNpHAxIMMU@AuhzM^cvBPw[v=\ngNpHAxITuUTAupqUhmVwjC`dMBp`\ngNpHAxITuUU@aupqSdmVwjCoDMBp`<\ngNpHAxITuUU@aupqSdmVwjCoDMBp`>\ngNpHAxITuUU@aupqUdmVwjCoDMBp`<\ngNpHAxITuUU@aupqUdmVwjCoDMBp`>\ngNpHAxIUMA@AoUw]H[m{@=\ngNpHAxIUMM@AtPitZypRF{^p=\ngNpHAxIUMM@AtPitZ}W\\Danwl=\ngNpHAxIUMMA@atPirZ}W\\Danwl+\ngNpHAxIUMMA@atPirZ}W\\Danwl-\ngNpHGPYICHETAulfm\\sZvPtH=\ngNpIABBTjfj`@zHTzM^hNBPw[v=\ngNpIABBTjfj`@zHUZM^hNBPw[v=\ngNpIAxBTjZjj@zxXirVk[u^wbFaXP\ngNpIAxBTjZjj`PzxXirVk[uAwbFaXP<\ngNpIAxBTjZjj`PzxXirVk[uAwbFaXP>\ngNpIAxBTjfj`@zHTyK^hNBPwkz=\ngNpIAxBTjfj`@zHTyM^hNBPw[v=\ngNpIAxBTjfj`@zHTyM^hNBPwkz=\ngNpIAxBTjfj`@zHTzM^hNBPw[v=\ngNpIAxBTjfj`@zHTzM^hNBPw[z\ngNpIAxBTjfj`@zHTzM^hNBPwkz=\ngNpIAxBTjfj`@zHTzMgAcV}P\\Danwt\ngNpIAxBTjfj`@zHUZK^hNB_W[v=\ngNpIAxBTjfj`@zHUZM^hNBPw[v=\ngNpIAxBTjfj`@zHUZM^hNBPw[z\ngNpIAxBTjfjf@zxXjtZk[eApREa@\ngNpIAxBTjfjj@zxXirVk[uApRFaXP\ngNpIAxBTjfjj@zxXirZk[uApRFaXP\ngNpIMP[ldadBj@zNRu[^sZvPtKB=\ngNpIMP[ldadBj@zNRu]^sjzPtKB=\ngNpIMP[ldadBj@zNRv]^sZvPtKB=\ngNpIMP[ldadBj@zNRv]^sjzPtKB=\ngNpIMP[ldadBj@zNSV]^sZvPtKB=\ngNpIMP[ldadBj@zNSV]^sjzPtKB=\ngNpIMP[ldadBj@zNSV]dqSdm{MkiCPlH\ngNpL@DIpK`dsUMPGQdfk[t[vszaXP\ngNpL@VSDVIddaeT@GRBZ~H[m{@=\ngNpL@VSDVIddaeT@GRBZ~H[m}@\ngNpL@xIpsadTaeT@GTc^cr}oW[v=\ngNpL@xQpSaddaeT@GRBZ}gexanwl=\ngNpL@xQpSaddaeT@GRBZ}gexaoWw|dCB=\ngNpL@xQpSaddaeUPGUCdmVwl|oDMBpd`XP\ngNpL@xUp[`eTuUPGUCENRwjC`dM|@\ngNpLABIps`dsUUTbGUbdmVwN|PtKB<\ngNpLABIps`dsUUTbGUbdmVwN|PtKB>\ngNpLADJHtQdTaeUPGQbVskjaXP\ngNpLAHJPtadTaeT@GTc]W[v=\ngNpLAHJPtadTaeT@GTc]W[z\ngNpLAHJPtadTaeT@GTc]Wkz=\ngNpLAHJPtadTaeTpGQbVk[j}XP\ngNpLAHJPtadTaeTpGQbVk[qa@\ngNpLAHJPtadTaeTpGQbVkkqa@\ngNpLAHJPtadTaeTpGRbZzoWl\ngNpLAHJPtadTaeTpGRbZzoWt\ngNpLAHJPtadTaeUPGQbVk[jaXP\ngNpLAHJPtadTaeUTJGQbVk[ja_`<\ngNpLAHJPtadTaeUTJGQbVkkjaXP<\ngNpLAHJPtadTaeUTJGQbVkkjaXP>\ngNpLAxIps`dsUUTbGUbdmVwN|PtKB<\ngNpLAxIps`dsUUTbGUbdmVwN|PtKB>\ngNpLaxKpw`itiLtuTAuXiMYusoDMBp`\ngNpMAxZ`M@IRjZjhCjabfk[uAwczaX_rRNH\ngNpMAxZ`M@IRjZjjACjabfk[eAwjEaIHx`<\ngNpMAxZ`M@IRjZjjACjabfk[eAwjEaIHx`>\ngNpP@cTfzZj@zt\\moFD\ngNpXHmQxYIIXuUBau`e[^LH<\ngNpXHmQxYIIXuUBau`e[^LH>\ngNpXHmQxYIIXuUBau`e]^LH<\ngNpXHmQxYIIXuUBau`e]^LH>\ngNp`@TfZZj@zlTyjv~pZEa@\ngNp`@TfZZj@zlTzjv~pZEa@\ngNp`@TfZZjb`zlTyjv~pZE~@<\ngNp`@TfZZjb`zlTyjv~pZE~@>\ngNp`@TfZZjb`zlTyjwIbgI[{AhVD>\ngNp`@TfZZjb`zlTyjwNbdm}`tKB<\ngNp`@TfZZjb`zlTyjwNbdm}`tKB>\ngNp`@TfZZjb`zlTyjwNbdm}`tK|>\ngNp`@TfZZjb`zlTyjwNbdm}oTKB<\ngNp`@TfZZjb`zlTyjwNbdm}oTKB>\ngNp`@TfZZjb`zlTyjwNbfm}`tK|<\ngNp`@TfZZjb`zlTyjwNbfm}`tK|>\ngNp`@TfZZjb`zlTyj{Nbfm}`tKB<\ngNp`@TfZZjb`zlTzjwNbdm}`tKB<\ngNp`@TfZZjb`zlTzjwNbdm}`tKB>\ngNp`@TfZZjb`zlTzjwNbfm}`tK|<\ngNp`@Tfzfjf`zlTyjwNbdmuPlH>\ngNp`@dfnj`@zTRwqC]oX=\ngNp`@dfnj`@zTRwqC]oh\ngNp`@dfnj`@zTRwq}]oX=\ngNp`@dfnj`@zTRyr\\uobF{_P\ngNp`@dfnj`@zTRyr\\uocz{_P\ngNp`@dfnj`@zTSWqC]oX=\ngNp`@dfnj`dPzTRypTuobF{_P>\ngNp`@dfnjf@zl\\ejwNSdmtPlH\ngNp`@dfnjj@zl\\ejv~HZEa@\ngNp`@dfnjj@zl\\ejwISdm[xahVD\ngNp`@dfnjjTV`zl\\ejwNBdm|PtKB<\ngNp`@dfnjjTV`zl\\ejwNBdm|PtKB>\ngNp`@dfnjjdPzl\\ejwMBgIZwqCPlH<\ngNp`@dfnjjdPzl\\ejwMBgIZwqCPlH>\ngNp`@dfnjjfPzl\\ejwICEM[xahWx<\ngNp`@dfnjjfPzl\\ejwNSdm|PtKB<\ngNp`@dfnjjfPzl\\ejwNSdm|PtKB>\ngNp`@dfzZj@zl\\ejv~HZEa@\ngNp`@dfzZj@zl\\ejv~HZEaIXd`\ngNp`@dfzZj@zl\\ejv~HZEaKXdt`\ngNp`@dfzZj@zl\\ejv~HZE~@\ngNp`@dfzZj@zl\\ejv~H[y~@\ngNp`@dfzZj@zl\\ejwIbgI[xahVD\ngNp`@dfzZj@zl\\ejwNbgM|PtKB\ngNp`@dfzZj@zl\\ejz~HZEa@\ngNp`@dfzZj@zl\\elz~HZEa@\ngNp`@dfzZjfPzl\\ejv~HZE~IXt`<\ngNp`@dfzZjfPzl\\elv~HZE~@<\ngNp`@dfzZjfPzl\\elv~HZE~@>\ngNp`@dfzjj@zl\\ejv~HZEa@\ngNp`@dfzjjdPzl\\ejwNBgM|PtKB>\ngNp`ATffjjTRPzlTyJv~pSya@<\ngNp`ATffjjTRPzlTyJwMCEIZwvBPlH<\ngNp`ATffjjTRPzlTyJwMCEIZwvBPlH>\ngNp`ATffjjTRPzlTyJwNbfm}`dKB<\ngNp`ATffjjTRPzlTyJwNbfm}`dKB>\ngNp`ATffjjTRPzlTyJwNbfm}`dK|<\ngNp`ATffjjTRPzlTyJwNbfm}`dK|>\ngNp`ATffjjTRPzlTyJwNbfm}`gsB>\ngNp`ATffjjTRPzlTyJwNbfm}oGsB>\ngNp`ATffjjTRPzlTyJwNcfm}`gsB<\ngNp`ATffjjTRPzlTyJwNcfm}`gsB>\ngNp`ATffjjTR`zlTyJwICEM[{AHVD>\ngNp`ATffjjTR`zlTyJwNbdm}`dKB<\ngNp`ATffjjTR`zlTyJwNbfm}`dKB<\ngNp`ATffjjTR`zlTyJwNbfm}`dKB>\ngNp`ATffjjTR`zlTyJwNbfm}`dK|<\ngNp`ATffjjTR`zlTyJwNcfm}`gsB<\ngNp`ATffjjTR`zlTyLv~pREa@<\ngNp`ATffjjTR`zlTyLz~pREa@>\ngNp`ATffjjb`zlTyJv~pREa@<\ngNp`ATffjjb`zlTyJv~pREa@>\ngNp`ATffjjb`zlTyJv~wcya@<\ngNp`ATffjjb`zlTyJwIbgM[{AHVD>\ngNp`ATffjjb`zlTyJwNCFm}`dKB<\ngNp`ATffjjb`zlTyJwNCFm}`dKB>\ngNp`ATffjjb`zlTyJz~pREa@>\ngNp`ATffjjb`zlTzLv~pREa@<\ngNp`ATffjjb`zlTzLv~pREa@>\ngNpa@erS]MU@]VNRu[_DMBp`\ngNpa@erS]MU@]VNRu[_DMBpdlRP\ngNpa@erS]MU@]VNSV]_DMBp`\ngNpdH`DTHrRPqZjYCharYm|PwsB<\ngNpdH`DTHrRPqZjYCharYm|PwsB>\ngNpdJqHJPRZzjXCkQrV|HP\ngNpdJqHJPRZzjXCkQrV|O`\ngNpdJqHJPRZzjXCkQrZ|HP\ngNpeE`DSpGYEHYMAHauHwUv}`+\ngNphH`DYIHXm@At`eobF{^p=\ngNphH`DYIHXm@At`eobF{_P\ngNphH`DYIHXm@At`eocz{^p=\ngNphH`DYIHXm@At`eocz}_P=\ngNphH`DYIHXm@At`fobF{^p=\ngNphH`DYIHXm@At`fobF{_P\ngNphH`DYIHXm@At`fobF}_P=\ngNphH`DYIHXm@At`fsdyk_DMv~`\ngNphH`DYIHXmLAuPyMUmtPlH\ngNphH`DYIHXmLAuPyMUm|PwkB\ngNphH`DYIHXmLAuPyMUutPlH\ngNphH`DYIHXmLAuPyMUu|PwkB\ngNphH`DYIHXmLAu`zK_DMz~`\ngNphH`DYIHXmLAu`zM_DMz~`\ngNphH`DYIHXmTAuPyKUm|PtKB\ngNphH`DYIHXmTAuPyMUm|PtKB\ngNphH`DYIHXmULauPyKUn\\gI[xahVD<\ngNphH`DYIHXmULauPyKUn\\gI[xahVD>\ngNphH`DYIHXmULauPyMUm|PtK|<\ngNphH`DYIHXmULauPyMUu|PtKB<\ngNphH`DYIHXmULauPyMUu|PtKB>\ngNphH`VYIHYU@At`fobF{^p=\ngNphH`xYIHYU@At`eobF{^p=\ngNphH`xYIHYU@At`fobF{^p=\ngNphH`xYIHYU@At`fobF{_P\ngNphH`xYIHYU@At`fobF}_P=\ngNphH`xYIHYUTAuPyKUm|PtKB\ngNphHaxYIHXuA@at`eobF{^p+\ngNphHaxYIHXuA@at`eobF{^p-\ngNphHaxYIHXuA@at`fobF{^p+\ngNphHaxYIHXuA@at`fobF{^p-\ngNphJpDIMMULAtXirVzpRD\ngNphJqHIMMULAtXirVzpRD\ngNphJqbIMMULAtXirVzpRD\ngNpi@iPSdfnj`@zTSWqC]oX=\ngNpi@iPSdfnj`@zTSWqC^oh=\ngNplJqDJHtQdTaeTpGRbT\ngNplJqHJPtadTaeTpGRbT\ngNpmJqDJHtP~rJPrjXCiQJ\ngNpmJqHJPt`~rJPrjXCiQJ\ngNq@@dju\\@GTc]W[v=\ngNq@@dju\\@GTc]W[z\ngNq@@dsSUPGSbgIZmn\\DahVD\ngNq@@dsSUPGSbgIZmn\\DahWx\ngNq@@dsSUPGSbgIZmn]xahVD\ngNq@@dsSUPGSbgIZmrXirVypRFaXP\ngNq@@dsSUPGSbgIZmrXirVywbFaXP\ngNq@@dsSUPGSbgIZmshik\\xICPop\ngNq@@dsSUPGSbgIZmshik\\{qCPop\ngNq@@dsSUPGSbgIZmshis\\xICPlH\ngNq@@dsSUPGSbgIZmshis\\{qCPlH\ngNq@@dsSUPGSbgIZnn\\DahVD\ngNq@@dsSUPGSbgIZnn]xahVD\ngNq@@dsSUPGSbgIZnshik\\xICPlH\ngNq@@dsSUPGSbgI[Nn\\DahVD\ngNq@@dsSUPGSbgQZmn\\DahVD\ngNq@@dsSUPGSbgQZmn\\DahWx\ngNq@@dsSUPGSbgQZmshik\\xICPop\ngNq@@dsSUPGSbgQZmshis\\xICPlH\ngNq@@dsSUPGSbgQZnn\\DahVD\ngNq@@dsSUTRGSbgIZmrXisVypRFa_`<\ngNq@@dsSUTRGSbgIZmrXisVypRFa_`>\ngNq@@dsSUTRGSbgIZmrXisVywbFa_`<\ngNq@@dsSUTRGSbgIZmrXisVywbFa_`>\ngNq@@dsSUTRGSbgIZmshis\\xICPop<\ngNq@@dsSUTRGSbgIZmshis\\xICPop>\ngNq@@dsSUTRGSbgIZmshis\\{qCPop<\ngNq@@dsSUTRGSbgIZnshis\\xICPlH<\ngNq@@dsSUTRGSbgIZnshis\\xICPlH>\ngNq@@dsSUTRGSbgQZmshis\\xICPop>\ngNq@@dsSUTRGSbgQZnshis\\xICPlH<\ngNq@@dsUURbRGSbgIZmsPqSfms`dMB@<\ngNq@@dsUURbRGSbgIZmshis\\xICPop<\ngNq@@dsUURdRGSbgIZmshiK\\xIC_Op>\ngNq@@dsUURdRGSbgIZmshis\\xICPop<\ngNq@@dsUURdRGSbgIZmshis\\xICPop>\ngNq@@dsUURdRGSbgIZnshis\\xICPlH<\ngNq@@dsUUTbGSbgIZmn\\DahVD<\ngNq@@dsUUTbGSbgIZmn\\DahVD>\ngNq@@dsUUTbGSbgIZmn\\DahWx>\ngNq@@dsUUTbGSbgIZmrPqSfypRFaXP<\ngNq@@dsUUTbGSbgIZmrXirVypRFaXP<\ngNq@@dsUUTbGSbgIZmrXirVypRFaXP>\ngNq@@dsUUTbGSbgIZmrXirVywbFaXP<\ngNq@@dsUUTbGSbgIZmrXirVywbFaXP>\ngNq@@dsUUTbGSbgIZmsPqSdms`dMBp`<\ngNq@@dsUUTbGSbgIZmsPqSdms`dMBp`>\ngNq@@dsUUTbGSbgIZms`qs\\xICPlH<\ngNq@@dsUUTbGSbgIZmshik\\xICPop<\ngNq@@dsUUTbGSbgIZmshik\\xICPop>\ngNq@@dsUUTbGSbgIZmshis\\xICPlH<\ngNq@@dsUUTbGSbgIZmshis\\xICPlH>\ngNq@@dsUUTbGSbgIZmshis\\{qCPlH<\ngNq@@dsUUTbGSbgIZmshis\\{qCPlH>\ngNq@@dsUUTbGSbgIZnshik\\xICPlH>\ngNq@@dsUUTbGSbgQZmn\\DahVD<\ngNq@@dsUUTbGSbgQZmn\\DahVD>\ngNq@@dsUUTbGSbgQZms`qk\\xICPop>\ngNq@@dsUUTbGSbgQZms`qs\\xICPlH<\ngNq@@dsUUTbGSbgQZms`qs\\xICPlH>\ngNq@@dsUUTbGSbgQZmshis\\xICPlH>\ngNq@@dtuT@GVcdms`dMv}`=\ngNq@@dtuT@GVcdms`dMv}dd\\P=\ngNq@@dtuT@GVcdms`dMv~`\ngNq@@dtuT@GVcdmsoGuv~`\ngNq@@dtuT@GVcdn\\FM[gAH[m}@\ngNq@@dtuT@GVchus`dMv}`=\ngNq@@dtuT@GVchus`dMv~`\ngNq@@dtuT@GVchus`dMz~`=\ngNq@@dtuT@GVchvSENZwNBPw[z\ngNq@@dtuT@GVchvVFJ\\ek\\xIC^oh=\ngNq@@dtuT@GVchv\\FM[gAH[m}@\ngNq@@dtuTDbGVcdms`guv}`+\ngNq@@dtuTDbGVcdms`guv}`-\ngNq@@dtuTDbGVcdms`guv}dd\\P-\ngNq@@dtuTDbGVcdn]EM[gAH[m}@<\ngNq@@dtuTDbGVcdn]EM[gAH[m}@>\ngNq@@dtuTDbGVcdn]GM[gAOkm}@<\ngNq@@dtuTDbGVcdn]GM[gAOkm}@>\ngNq@@dtuTDbGVcdus`dMv}`+\ngNq@@dtuTDbGVcdus`dMv}`-\ngNq@@dtuTDbGVcdus`dMv~`<\ngNq@@dtuTDbGVcdus`dMv~`>\ngNq@@dtuTDbGVcdv]EM[gAH[m}@<\ngNq@@dtuTDbGVcdv]EM[gAH[m}@>\ngNq@@dtuTDbGVcdv]GI[gAH[u}@<\ngNq@@dtuTDbGVcdv]GI[gAH[u}@>\ngNq@@dtuTDbGVcdv]GM[gAH[m}@<\ngNq@@dtuTDbGVcdv]GM[gAH[m}@>\ngNq@@dtuTDbGVchms`guv}`+\ngNq@@dtuTDbGVchms`guv}`-\ngNq@@dtuTDbGVchvRFJZwNBPw[z<\ngNq@@dtuTDbGVchvRFJZwNBPw[z>\ngNq@@dtuTDbGVchv]EM[gAH[m}@<\ngNq@@dtuTDbGVchv]EM[gAH[m}@>\ngNq@@dtuTpGSbgIZmolDaXP\ngNq@@dtuTpGSbgIZmrpqSdm[{AHVD\ngNq@@dtuTpGSbgIZmsXirVm}`dKB\ngNq@@dtuTtbGSbgIZmsXirVm}`gsB<\ngNq@@dtuTtbGSbgIZmshiK\\xIC^lH<\ngNq@@dtuTtbGSbgIZmshik_XIBp`<\ngNq@@dtuTtbGSbgIZmshik_XIBp`>\ngNq@@dtuTtbGSbgIZmshik_XIB@<\ngNq@@dtuTtbGSbgIZmshyk_XI|p`<\ngNq@@dtuUPGSbgIZmn\\DahVD\ngNq@@dtuUPGSbgIZmn\\DahVG|dSR\ngNq@@dtuUPGSbgIZmrpqSdm[gAHZEa@\ngNq@@dtuUPGSbgIZmsXirVms`dMBp`\ngNq@@dtuUPGSbgI[Nn\\DahVD\ngNq@@dtuURbRGSbgIZmrPqRVypRFaXP<\ngNq@@dtuURbRGSbgIZmrXiKVypRFa_orQMH<\ngNq@@dtuURbRGSbgIZmrXiKVypRFa_orQMH>\ngNq@@dtuURbRGSbgIZmshiK\\xICPlH<\ngNq@@dtuURbRGSbgIZmshiK\\xICPlH>\ngNq@@dtuURbRGSbgIZmshik\\xICPop<\ngNq@@dtuURbRGSbgIZmshik\\xICPop>\ngNq@@dtuURbRGSbgIZmshyK\\xI}PlH<\ngNq@@dtuURbRGSbgIZmshyK\\xI}PlH>\ngNq@@dtuURbRGSbgIjmshyK\\xICPlH>\ngNq@@dtuURbRGSbgIjnn\\DahVD<\ngNq@@dtuURbRGSbgIjnn\\DahVD>\ngNq@@dtuURbTGSbgIZmrPqRVypRFaXP<\ngNq@@dtuURbTGSbgIZmsPqRVms`dMB@<\ngNq@@dtuURbTGSbgIZmsPqRVms`dMB@>\ngNq@@dtuURbTGSbgIZmshiK\\xICPlH<\ngNq@@dtuURbTGSbgIZmshiK\\xICPlH>\ngNq@@dtuURbTGSbgIZmshik\\xICPop<\ngNq@@dtuURbTGSbgIZmshik\\xICPop>\ngNq@@dtuURbTGSbgIZmshik\\xICPowyIGD>\ngNq@@dtuURbTGSbgIZmshyK\\xI}PlH>\ngNq@@dtuURbTGSbgIZnshiK\\xICPlH<\ngNq@@dtuURbTGSbgIjmshiK\\xICPlH<\ngNq@@dtuURbTGSbgIjmshiK\\xICPlH>\ngNq@@dtuURbTGSbgIjnn\\DahVD>\ngNq@@dtuUTRGSbgIZmn\\DahWx<\ngNq@@dtuUTRGSbgIZmrXirVypRFaXP<\ngNq@@dtuUTRGSbgIZmrXirVypRFaXP>\ngNq@@dtuUTRGSbgIZmsXirVms`dMB@<\ngNq@@dtuUTRGSbgIZmsXirVms`dMB@>\ngNq@@dtuUTRGSbgIZms`qK\\xICPlH<\ngNq@@dtuUTRGSbgIZms`qK\\xICPlH>\ngNq@@dtuUTRGSbgIZms`qk\\xICPop>\ngNq@@dtuUTRGSbgIZnn\\DahVD<\ngNq@@dtuUTRGSbgIZnn\\DahVD>\ngNq@@dtuUTRGSbgQjnn\\DahVD<\ngNq@@dtuUTRGSbgQjnn\\DahVD>\ngNq@@dtuUTbGSbgIZmn\\D~hVD>\ngNq@@dtuUTbGSbgIZmrXiKVypRFaXP<\ngNq@@dtuUTbGSbgIZmrXiKVypRFaXP>\ngNq@@dtuUTbGSbgIZmrXyKVypSzaXP<\ngNq@@dtuUTbGSbgIZmrXyKVypSzaXP>\ngNq@@dtuUTbGSbgIZmsPqRVms`dMBp`<\ngNq@@dtuUTbGSbgIZmsPqRVms`dMBp`>\ngNq@@dtuUTbGSbgIZmsXirVms`guBp`<\ngNq@@dtuUTbGSbgIZmsXirVms`guBp`>\ngNq@@dtuUTbGSbgIjmn\\DahVD<\ngNq@@dtuUTbGSbgIjmn\\DahVD>\ngNq@@dtuUTbGSbgIkNn\\DahVD>\ngNq@@dwTuPGSbgIZmnUtahVD\ngNq@@dwTuPGSbgIZmobFaXP\ngNq@@dwTuPGSbgIZmshis\\kiCPlH\ngNq@@dwTuPGSbgIZmshis_DMBp`\ngNq@@dwTuPGUedmVwhvmdMBp`\ngNq@@dwTuPGUedmWWhvmdMBp`\ngNqDJDR^BSSMT`]FJmFn\\Danwl\ngNqDJHaQBSWUS@]FNRnnbEa@\ngNqDJIARBSWUUSP]FNRmsdyk]GsB<\ngNqHB@aInij`NcKMgWHvmtKB\ngNqHB@aInijihNcKMWWHvmtKB<\ngNqHB@aInijihNcKMWWHvmtKB>\ngNqHBLQInijihNkENZmshiK_KmBp`<\ngNqHBLQInijihNkENZmshiK_KmBp`>\ngNqHD@aInij`NkGIZmobFaXP\ngNqHH@aJnfjhDNfENRu[\\xICPlH>\ngNqHH@aJnfjhDNfENbu[\\xICPlH<\ngNqHH@aJnfjhDNfENbu[\\xICPlH>\ngNqHHGAJkjh@NlGI[gAH[m{@=\ngNqHHGAJkjh@NlGQkgAH[m{@=\ngNqHHGAJkjhHDNlGIkgAH[m{@+\ngNqHHGAJkjhHDNlGIkgAH[m{@-\ngNqHHGAJkjhHDNlGQ[gAOkm{@+\ngNqHHGAJkjhHDNlGQ[gAOkm{@-\ngNqHHGAJkjj`NfENRu[\\xICPlH\ngNqHHGAJkjjhDNfENSU[\\xICPlH<\ngNqHHGAJkjjhDNfENSU[\\xICPlH>\ngNqHHOAJkfh@NlGI[gAH[m{@=\ngNqHHOAJkfh@NlGI[gAH[m}@\ngNqHHOAJkfh@NlGQkgAH[m{@=\ngNqHHOAJkfh@NlGQkgAH[m}@\ngNqHHOAJkfh@NlGQkgAH[u}@=\ngNqHHOAJkfh@NlGQlvJ\\ek\\xIC^oh=\ngNqHHOAJkfhHDNlGIkgAH[m{@+\ngNqHHOAJkfhHDNlGIkgAH[m{@-\ngNqHHOAJkfhHDNlGIkgAH[m}@<\ngNqHHOAJkfhHDNlGIkgAH[m}@>\ngNqHHOAJkfhHDNlGQ[gAOkm{@+\ngNqHHOAJkfhHDNlGQ[gAOkm{@-\ngNqHHOAJkfi`NfENcU[\\xIC^lH\ngNqHHOAJkfi`NfENcU]\\xIC^lH\ngNqHHOAJkfi`NfENcU]_XIBp`\ngNqHHOAJkfj`NfENRu[\\xICPlH\ngNqHHOAJkfj`NfENcU[\\xICPlH\ngNqHHOAJkfjhDNfENSU[\\xICPlH<\ngNqHHOAJkfjhDNfENSU[\\xICPlH>\ngNqHHOAJkfjhdNfENcU]\\xICPlH<\ngNqHJIAIijjeDhNkENRmshik_XI|p`>\ngNqHaJ@SNRZZj@CkQtZypRF}_P=\ngNqIAJB\\dtuT@GVchus`dMv}`=\ngNqIAJB\\dtuT@GVchus`dMz~`=\ngNqIAJB\\dtuTDbGVcdus`dMz~`+\ngNqIAJB\\dtuTDbGVcdus`dMz~`-\ngNqIHO@ReUuT@GVChus`dMv}`=\ngNqIHO@ReUuT@GVChus`dMz~`=\ngNqLJIARFdLbdLjf@ztRmoFD\ngNqLJIARFdLbdLjf@ztRnoFD\ngNqLJIARFdLbdLji@ztRmoGt\ngNqLJIARFdLbdLjja`ztRmoFD<\ngNqLJIARFdLbdLjja`ztRmoFD>\ngNqLJIARFdLbdLjja`ztRmoGx<\ngNqLJIARFdLbdLjja`ztRmoGx>\ngNqLL@b^BBLbdLZ`dPzd[j{^p+\ngNqLL@b^BBLbdLZ`dPzd[j{^p-\ngNq`@ZdsSUPGQbgK\\zJZwVBp`\ngNq`@ZdsSUPGQbgK\\zJZwV|p`\ngNq`@ZdsSUTRGQbgK\\zJ\\wVBp`<\ngNq`@bdwSUPGQcfk[jaXP\ngNq`@bdwSUPGQcfk[j~_`\ngNq`@bdwSUPGQcfskjaXP\ngNq`@bdwSUTtGQcfk[ja_`<\ngNq`@bdwSUTtGQcfk[ja_`>\ngNq`@bdwSUTtGQcfk\\zJRwUBp`>\ngNq`@bdwSUTtGQcfkkjaXP<\ngNq`@bdwSUTtGQcfkkjaXP>\ngNq`@bdwSUTtGQcfs[ja_`<\ngNq`@bdwSUTtGQcfs[ja_`>\ngNq`@jduuURbrGQcdk\\xJZwQBp`<\ngNq`@jduuURbtGQcdk\\dJ\\uncya@>\ngNq`@jduuUTtGQcdk[haXP<\ngNq`@jduuUTtGQcdk\\yNZwQBp`<\ngNq`@mdTaeT@GTc]W[v=\ngNq`AVdtuUPGQbgI\\lLTyKVzpRD\ngNqa@bnR[ijhChqsUmuPlH\ngNqhHl@cIIKEh@NhFznwl=\ngNqhHl@cIIKEh@NhFznwt\ngNqhHlBsIIKJh@NhGNSdmu^ooyHFD\ngNqhHlGCIIKJh@NhFznwl=\ngNqhHlGCIIKJh@NhFznwt\ngNqhHlGCIIKJj`NbDmVwUBp`\ngNqhHlOCIIKFh@NhFznwl=\ngNqhHlOCIIKFh@NhFznwt\ngNqhHlOCIIKFh@NhFzoWt=\ngNqhHlOCIIKFi`NbDmVwUzp`\ngNqhHlOCIIKFi`NbDmVwcB\ngNqhHlOCIIKFi`NbDmWWUzp`\ngNqhHlOCIIKFj`NbDmVwUBp`\ngNqhHlOCIIKFjhTNbDmWWUBp`>\ngNqi@mJB]dTaeT@GTc]W[v=\ngNqi@mJB]dTaeT@GTc]W[z\ngNqiHl@c]ddebt@GTC]W[v=\ngNqiHl@c]ddebt@GTC]W[z\ngNqiHl@c]ddebt@GTC]Wkz=\ngNqiHlOC]ddecTDBGTC]W[v+\ngNqiHlOC]ddecTDBGTC]W[v-\ngNr@ACTjzjj@zpdmoio[X_v`@\ngNr@ACTjzjj@zpdnoio[X_v`@\ngNrDEcPDSpRZYjhCkQRv|X_vb@\ngNrDHlQxWpRjyjhCkARwNCDmu_LO{Q@\ngNrHEcQxIMMUTAthjnkm{ZH\ngNrHHlPxIUMUTAt`rnkm}ZP\ngNrHHlQxIU\\uTAtPijvzhVG}h`=\ngNrHHlQxIU\\uTAtPijwIbgI[jaX_vb@\ngNrHHlQxYIHXETAulu[\\sZwPlO{S@=\ngNrHHlQxYIHXETAulu[gIrVyfunaX_vf@\ngNrIHlQxRTjnZj@zHTu[]TKC~tP=\ngNrIHlQxRTjnZj@zHTu[_SmBpmD=\ngNrIXlPxAiJgRYRjZj@CjAnkm{b@[R@=\ngNr`hZpiJyInfj`NeGO{R@\ngNt@@TfzBj@zvZmnQm[hVD\ngNt@@Tfzfj@zLlu[gASfyGUnaXP\ngNt@@Tfzfj@zLlu[gQSfyFuvaXP\ngNt@@TjZjj`PzXXiuUn\\EN[eApZEa@<\ngNt@@TjZjj`PzXXiuUn\\EN[eApZEa@>\ngNt@@dfnj`@zTRwqC]oX=\ngNt@@dfnj`@zTRwq}]oX=\ngNt@@dfnj`@zTSWqC]oX=\ngNt@@dfzZj@zl\\ejvyGRFaXP\ngNt@@dfzZj@zl\\ejv~HZEa@\ngNt@@dfzjj@zl\\ejv~HZEa@\ngNt@@dfzjj@zl\\ejwICEN[xahVD\ngNt@ADjzjj@zXTyKUms`dMBpm@\ngNt@ADjzjj@zhdejv}f}tahVG}h@\ngNt@ATffjjb`zlTyJz~pREa@>\ngNtDHpxUpRjZjjQCjabgI[eApRF~@<\ngNtDHpxUpRjZjjQCjabgI[eApRF~@>\ngNtDJqHJPRZzj@CiQK_Guv}`=\ngNtHH`xIUMUTAtpqrVk[gAHZEaZP=\ngNtHH`xYIHYU@At`fobF{^p=\ngNtHHaxYIHXE@AoYm[H[m{@=\ngNtH`iPBYrSWUPRH]JIkxanwl+\ngNtH`iPBYrSWUPRH]JIkxanwl-\ngNtI@]P[ldadjj@zHlv]gASfygUvaX_v`@\ngNtI@iPSdfnj`@zTSWqC]oX=\ngNtIHaxB\\ddLj`@zPSWqC]oX=\ngNtI`]PB]qgIHYFj`NbKMVwLvmtKC~t@\ngNtI`iPBYreIkjh@NeDu|Pw[v=\ngNtI`iPBYreIkjj`NkGIZmrTyKV~HZEa@\ngNtLJqDJHtQdTaeTpGRbT\ngNtLJqHJPtadTaeT@GTc]W[v=\ngNtLJqHJPtadTaeTpGRbT\ngNtLJqHJPtadTaeTpGRbZznwl\ngNtLJqHJPtadTaeTpGRbZznwt\ngNtLlQHR`TaNLiM]UTAtXyjwNSdmuPlO{S@\ngNtLlQHR`TaNLiM]UTAtXyj{NSdmuPlO{S@\ngNtLlQHR`TaNLiM]UTAthzsdyK]Wk{~tp\ngNtLlQHR`TaNtiM]U@AuHyr\\unkm}ZX\ngNtLlQHR`TaNtiM]ULAtXyj{NSdmu^lO{S@\ngNtLlQHR`TaNtiM]ULAthzsdyK]Wk{~tp\ngNtMLQHR`TaNRZzjhCiQugIrVzoWw}i`\ngNtMLQHR`TaNRZzjhCiQugIsVznww}i`\ngNt`CPdfzZj@zt\\moFD\ngNt`CPdfzZj@zt\\moGx\ngNt`EPTfzZjfPzt\\mshiK^LH<\ngNt`EPTfzZjfPzt\\mshiK^LH>\ngNt`hPiJyInfj`NcGMVwUBpdbZ[R@\ngNt`hPiJyInfj`NcGMVwUBpmH\ngNtdLx`DTHrRRqZdCiAM]W[v\ngNthJx`DYIHXmLAu`zK_DMv~`\ngNthLX`DYIHXmTAtPyjvzhVG}i`=\ngNthLX`DYIHXmTAtPyjwNSdmuPlO{S@\ngNthLX`DYIHXmTAt`znkm{ZX=\ngNthMX`DYIHXmTAtPyLvzHVG}i`\ngNthMX`DYIHXmTAtPyLvzHW{}i`\ngNthMX`DYIHXmTAu`zM_DMv~mL\ngNthMX`DYIIXm@Au@wUv}`\ngNthejqHJWrSSUSRH]ZJRwaC~tP<\ngNthejqHJWrSSUSRH]ZJRwaC~tP>\ngNtiLPiPSdfnjj@zT]Yr\\enku}ZX\ngNtiLPiPSdfnjjdPzT]YhTyKVzoWw}i`-\ngNu@DPdwSUPGQcfk[jaXP\ngNu@DPdwSUPGQcfk[jaX_rQMH\ngNu@DPdwSUPGQcfk\\zJ\\wUBp`\ngNu@DPdwSUTtGQcfk\\fJ\\enjEa@<\ngNu@DPdwSUTtGQcfk\\fJ\\enjEa@>\ngNu@DPdwSUTtGQcfk\\zJRwUBp`<\ngNu@DPdwSUTtGQcfk\\zJRwUBp`>\ngNu@DPdwSUTtGQcfkkjaXP<\ngNu@DPdwSUTtGQcfkkjaXP>\ngNuHDz@aIkjiiDNmGI\\dLTuoBD<\ngNuHDz@aIkjiiDNmGI\\dLTuoBD>\ngNuHDz@aIkjiiDNmGI\\zJZwaB<\ngNuHEhOCIIKFh@NhFznwl=\ngNx@@dju\\@GTc]W[v=\ngNx@@dsSUPGSbgIZmn\\DahVD\ngNx@@dsSUPGSbgIZmshis\\xICPlH\ngNx@@dsSUPGSbgQZmn\\DahVD\ngNx@@dsSUPGUddmVwhwmdMBp`\ngNx@@dsSUPGUddmVwhwndMBp`\ngNx@@dsUUTbGSbgIZmn\\DahVD<\ngNx@@dsUUTbGSbgIZmn\\DahVD>\ngNx@@dsUUTbGSbgIZmrPqSfypRFaXP<\ngNx@@dsUUTbGSbgIZmsPqSdms`dMBp`<\ngNx@@dsUUTbGSbgIZmsPqSdmsoDMBp`<\ngNx@@dsUUTbGSbgIZmsPqSdmsoDMBp`>\ngNx@@dsUUTbGSbgIZms`qs\\xICPlH<\ngNx@@dsUUTbGSbgIZms`qs\\xICPlH>\ngNx@@dsUUTbGSbgIZmshis\\xICPlH>\ngNx@@dsUUTbGSbgQZmn\\DahVD<\ngNx@@dsUUTbGSbgQZmn\\DahVD>\ngNx@@dsUUTbGSbgQZmsPqSdms`dMBp`<\ngNx@@dsUUTbGSbgQZms`qs\\xICPlH<\ngNx@@dsUUTbGSbgQZms`qs\\xICPlH>\ngNx@@dtuT@GVcdms`dMv}`=\ngNx@@dtuT@GVcdms`dMv~`\ngNx@@dtuT@GVcdn\\FM[gAH[m}@\ngNx@@dtuT@GVchus`dMv}`=\ngNx@@dtuT@GVchus`dMv~`\ngNx@@dtuT@GVchvSENZwNBPw[z\ngNx@@dtuTDbGVcdms`guv}`+\ngNx@@dtuTDbGVcdms`guv}`-\ngNx@@dtuTDbGVcdn]EM[gAH[m}@<\ngNx@@dtuTDbGVcdn]EM[gAH[m}@>\ngNx@@dtuTDbGVcdus`dMv}`+\ngNx@@dtuTDbGVcdus`dMv}`-\ngNx@@dtuTDbGVchv]EM[gAH[m}@<\ngNx@@dtuTDbGVchv]EM[gAH[m}@>\ngNx@@dtuTpGSbgIZms`qK\\xIC^lH\ngNx@@dtuTtbGQbkIkgAH[m}@>\ngNx@@dtuUPGSbgIZmn\\DahVD\ngNx@@dtuUPGSbgIZmrpqSdm[gAHZEa@\ngNx@@dtuURbRGSbgIZmshiK\\xICPlH>\ngNx@@dtuURbTGSbgIZmshiK\\xICPlH>\ngNx@@dtuUTRGSbgIZms`qK\\xICPlH<\ngNx@@dtuUTRGSbgIZnn\\DahVD<\ngNx@@dtuUTRGSbgIZnn\\DahVD>\ngNx@@dtuUTbGSbgIZmrXiKVypRFaXP<\ngNx@@dtuUTbGSbgIZmrXiKVypRFaXP>\ngNx@@dtuUTbGSbgIZmsPqRVms`dMBp`<\ngNx@@dtuUTbGSbgIZmsPqRVms`dMBp`>\ngNx@@dtuUTbGSbgIjmn\\DahVD<\ngNx@@dtuUTbGSbgIjmn\\DahVD>\ngNx@@dwPUPGQrVk[t[VrFaXP\ngNx@@dwPUPGQrVk\\zJ\\whvndMBp`\ngNx@@dwPUPGQrVkkt[VrFaXP\ngNx@@dwTuPGSbgIZmobFaXP\ngNx@@dwTuPGSbgIZmshis\\kiCPlH\ngNx@@dwTuPGUedmVwhvmdMBp`\ngNx@@dwTuPGUedmVwhvndMBp`\ngNx@@dwTuPGUedmVwhzmdMBp`\ngNx@@dwTuPGUedmVypTyoQu]HZEa@\ngNx@@dwTuPGUedmVytTyoQm]HZEa@\ngNx@@dwTuPGUedmWWhvmdMBp`\ngNx@@dwTuPGUedmWWhvndMBp`\ngNx@@dwTuPGUedmgWhvmdMBp`\ngNx@@dwTuPGUedmgWhvndMBp`\ngNx@@dwTuPGUedugWhvmdMBp`\ngNx@@eSUUPGUEDmVwjwmdMBpm@=\ngNx@@eSUUPGUEDmVwjwndMBpm@\ngNx@@eSUUPGUEDmVwj{ndMBpm@=\ngNx@@eSUUPGWCENRu[^hNBPtKB\ngNx@@eSUUPGWCENRu[^hNBPtKC~t@=\ngNx@@eSUUPGWCENRu[^hN|PtKC~t@\ngNx@@eSUUPGWCENRu[gASf}P]xahVG}h@\ngNx@@eSUUPGWCENRu[gAcf}P\\DahVG}h@\ngNx@@eSUUPGWCENRu]gAcV}P\\DahVG}h@\ngNx@@eSUUPGWCENbu[^hNBPtKC~t@\ngNx@@eSUUPGWCENcV]^hNBPtKC~t@\ngNx@@eSUUTBGWCENRu[gASf}P]xahVD<\ngNx@@eSUUTBGWCENRu[gASf}P]xahVD>\ngNx@@eSUUTBGWCENRu[gAcf}P\\DahVD<\ngNxA@IRZZj@CkQrVypRF{^p=\ngNxA@IRZZj@CkQtZypRF{^p=\ngNxA@IRijjhCkabgIZmoTGAHZEa@\ngNxA@IRijjjACkabgIZms`is^hN|PtKB<\ngNxA@IRijjjACkabgIZms`is^hN|PtKB>\ngNxA@IRjZj@ChaSdmz`xIC]oX=\ngNxA@IRjZjhCkabgIZmoTGAHZEa@\ngNxA@IRkijhCjbRVk[v[vrFaX_v`@\ngNxA@IRkijhCjbRVk[v]vrFaX_v`@\ngNxA@IRkijhCkabgIZmshis\\{qCPlO{P@\ngNxA@IRkijhCkabgQZmrPqrV}g\\DahVG}h@\ngNxDD@b^BSWMPRH]JIkxanwl+\ngNxDD@b^BSWMPRH]JIkxanwl-\ngNxDDDR^BSWMPRH]JIkxanwl+\ngNxDDDR^BSWMPRH]JIkxanwl-\ngNxDHDQHbS]UU@]VNRu[_DMBp`\ngNxDHGBnBUSUURH]LLTyJz}P\\DaofD<\ngNxDHGBnBUSUURH]LLTyJz}P\\DaofD>\ngNxDHOANBS]UU@]VNRu[^cr|PtKC~RAamH\ngNxDHOA^BS]UU@]VNRu[\\cqCPlOyHFFt`\ngNxDHOA^BS]UU@]VNRu[^cr|PtKC~RAamH=\ngNxDHOA^BS]UU@]VNRu[_DMBp`\ngNxDHOA^BS]UU@]VNRu[_DMBpd`XP\ngNxDHOA^BS]UU@]VNRu[_DMBpd`X[R@=\ngNxDL@aNBSMTu@]VRRu[^c^vPtKB\ngNxE@jCT@eJfjj`NjFIZmobFaXP\ngNxEHBqE`eInjjiDNkGIZmnUxahVG|dCB<\ngNxEHBqE`eInjjiDNkGIZmnUxahVG|dCB>\ngNxEHOA^DeInfj`NkGIZmnQtahVG|dCCZP\ngNxEHOA^DeInfj`NkGIZmnUxahVG|dCCZP\ngNxHAjAJfjj`NfFJRu[\\hICPlO{P@\ngNxHAjAJfjjhDNfFJRu[\\hICPlH>\ngNxHAjAJfjjhDNfFJRu[gAcfyWbFaXP<\ngNxHAjAJfjjhDNfFJRu[gAcfyWbFaXP>\ngNxHD@aIkjhIDNeDm|Pw[v-\ngNxHD@aInfj`NkGIZmobFaXP\ngNxHD@aInij`NkKIZmoQm[HZEa@\ngNxHDOAInjjiDNkGIZmnQxahVD>\ngNxHH@aIfjj`NgENRu[gQSf}GlDahVG}i@\ngNxHHGAIfjj`NgENRu[\\xICPlOyHEFt`\ngNxHHGAIfjj`NgENRu[^cvBPtKC~RAQmH\ngNxHHGAIfjj`NgENRu[^cvBPtKC~t`\ngNxHHGAIfjjiDNgENRu[^cvBPtKB<\ngNxHHGAIfjjiDNgENRu[^cvBPtKB>\ngNxHHGAJijj`NnFJ\\ejv}P\\DahVG}i@=\ngNxHHGAJkjh@NlGQkgAH[m{@=\ngNxHHGAJkjj`NfENRu[\\xICPlH\ngNxHHOAJkfh@NlGQkgAH[m{@=\ngNxHHOAJkfh@NlGQkgAH[m}@\ngNxHHOAJkfhHDNlGIkgAH[m{@+\ngNxHHOAJkfhHDNlGIkgAH[m{@-\ngNxHHOAJkfhHDNlGIkv]pRF}_P+\ngNxHHOAJkfhHDNlGIkv]pRF}_P-\ngNxHHOAJkfj`NfENRu[\\xICPlH\ngNxHHOAJnjjhDNfENRu[\\{qCPlH<\ngNxHHOAJnjjhDNfENRu[\\{qCPlH>\ngNxHJIAIiji`NcEVRwN|_W[v\ngNxHaJ@SNRZZj@CkQrVypRF{^p=\ngNxHaJ@SNRZZj@CkQtZypRF{^p=\ngNxHaJ@SNRZZj@CkQtZypRF}_P=\ngNxHaJ@SNRZZj@CkQt[MbgIZwNBPwkz=\ngNxHaJ@SNRZZj@CkQt[NCFms`dMv~`\ngNxHaJ@SNRZZjBQCkQrZypRF{^p+\ngNxHaJ@SNRZZjBQCkQrZypRF{^p-\ngNxHaJ@SNRZZjBQCkQrZypRF}_P+\ngNxHaJ@SNRZZjBQCkQrZypRF}_P-\ngNxHaJ@SNRZZjBQCkQt[Nbfms`dMv~`<\ngNxHaJ@SNRZZjBQCkQt[Nbfms`dMv~`>\ngNxHaJ@SNRZZjjQCiqSdmVyLTek\\xICPlH<\ngNxHaJ@SNRZZjjQCiqSdmVyLTek\\xICPlH>\ngNxHaj@SnrRFPJhChyKUu{MkYCPlO{P@=\ngNxHaj@SnrRFPJhChyKYu{MkYCPlO{P@=\ngNxHaj@SnrRFPJhChyKYv]EN[v[WRFaX_v`@\ngNxHaj@SnrRFPJhChyMYu{MkYCPlO{P@=\ngNxHaj@SnrRFPJhChyMYu{MkiCPlO{P@\ngNxHhG@]IR[jZhCiqSdmVwJzPtKC~RAamH\ngNxIAJB\\dtuT@GVchus`dMv}`=\ngNxIAJB\\dtuT@GVchus`dMz~`=\ngNxIAJB\\dtuTDbGVcdus`dMz~`+\ngNxIAJB\\dtuTDbGVcdus`dMz~`-\ngNxIAjC\\dwTuPGUedugWhzmdMBp`\ngNxIHGBRdwTuPGSbgIZmoQy]HZEaI@pvd@\ngNxIHO@ReUuT@GVChus`dMv}`=\ngNxIHO@ReUuTDBGVCdus`dMv}`+\ngNxIHO@ReUuTDBGVCdus`dMv}`-\ngNxIHOBReUsT@GVChus`dMv}`=\ngNxIHOB\\eUsT@GVChu{NxIC]oX=\ngNxLHGBnC\\Djfjj@zhXirV}P\\Daogx\ngNxLHGBnC\\Djnjj@zHTyK\\xIC_Op\ngNxLHGBnChDjfjjdPzhXirVyP\\Dao`<\ngNxLHGBnChDjfjjdPzhXirVyP\\Dao`>\ngNxLHOANF\\DfZjjdPzlTejvywbFaXP<\ngNxLHOANF\\DfZjjdPzlTejvywbFaXP>\ngNxLJHaQFbLbdLj`@zd[j{^p\ngNxLJIARFdLbdLj`@zd[j{^p\ngNxLJIARFdLbdLj`@zd[j{_P\ngNxLJIARFdLbdLjf@zTSWUv}`\ngNxLJIARFdLbdLjf@zTSWUv~`\ngNxLJIARFdLbdLjf@ztRmoFD\ngNxLJIARFdLbdLjf@ztRnoFD\ngNxLJIARFdLbdLji@zTSWUv}`\ngNxLJIARFdLbdLji@zTSWUv~`\ngNxLJIARFdLbdLji@zTSWUz~`\ngNxLJIARFdLbdLji@ztRm@\ngNxLJIARFdLbdLji@ztRmoGt\ngNxLJIARFdLbdLjja`ztRmoFD<\ngNxLJIARFdLbdLjja`ztRmoFD>\ngNxMHOANF\\IJSMMU@]VJRu[\\{qCPlO{R@\ngNx`BDdwSUPGQcfk[jaXP\ngNx`BDdwSUPGQcfk[jaX_rQMH\ngNx`BDdwSUPGQcfk\\zJ\\wUBp`\ngNx`BDdwSUPGQcfskjaXP\ngNx`BDdwSUTtGQcfk[ja_`<\ngNx`BDdwSUTtGQcfk[ja_`>\ngNx`BDdwSUTtGQcfk\\zJRwUBp`<\ngNx`BDdwSUTtGQcfk\\zJRwUBp`>\ngNx`BDdwSUTtGQcfkkjaXP<\ngNx`BDdwSUTtGQcfkkjaXP>\ngNx`DBdwSUPGQcfk[jaXP\ngNx`DBdwSUPGQcfk\\zJ\\wUBp`\ngNx`DBdwSUTtGQcfk[ja_`<\ngNx`DBdwSUTtGQcfk\\zJRwUBp`>\ngNx`bDnLiMtuTAtXyjvzhVD\ngNx`hEIWIMtuTAuXyKUm|PtKC~t`\ngNx`hEIWIMtuTAuXyKUm|PtK}~t`\ngNx`hEIWIMtuTAuXyKUu|PtKC~t`\ngNxaBDYR[ijhChqsUmuPlH\ngNxdMD@baFRRFKU@]DNSMobF~X_vf@\ngNxdMD@baFRRFKU@]DNSNobF~X_vf@\ngNxdMD@baFRRVKT`]HIkj{^p\ngNxhKD@cIICEh@NdDm|Pw[v\ngNxhMD@cIICEj`NjGIZmobFaX_vf@=\ngNxhMD@cIICEj`NjGIZmoczaX_vf@=\ngNxhMD@cIICEj`NjGIZnobFaX_vf@\ngNxhMD@cIICEj`NjGIZnsdyk_DMBpmL\ngNxhMD@cIICEj`NjGIjmobFaX_rQMMi`=\ngNxhMD@cIICEj`NjGIjmobFaX_vf@=\ngNxhMD@cIICEj`NjGIjmobFa_ovf@\ngNxhMD@cIICEj`NjGIjmsdyK_DMBpmL\ngNxhMD@cIICEj`NjGIjnobFaX_vf@\ngNxhMD@cIICEj`NjGIjnsdyk_DMBpmL\ngNxhMD@cIICEj`NjGIkMobFa_ovf@\ngNxhMD@cIICEj`NlGQ[xaoWw}i`=\ngNxhMD@cIICEj`NlGQkxanwo}i`=\ngNxhMD@cIICEj`NlGQkxanww}i`\ngNxhMD@cIICEj`NlGQkxaoWw}i`=\ngNxhMD@cIIKEh@NhFznwl=\ngNxhMD@cIIKEh@NhFznwt\ngNxhMD@cIIKEh@NhFzoWt=\ngNxhMD@cIIKEh@NhGNSfmu]oh\ngNxhMD@cIIKEi`NbDmVyr\\enkua@\ngNxhMD@cIIKEi`NdDv\\gI[j}^p\ngNxhlEJB]iRZzj@CiQM_DMv}mL=\ngNxhlEJB]irJPrj@CjQnkm{@=\ngNxhlEJB]irJPrj@CjQomz{^p=\ngNxhlEJB]irJPrj@CjQsdyk]W[z\ngNxiMD@c]ddebt@GTC]W[v=\ngNy@BDfZZj@zlTyjv~pZEa@\ngNy@BDfZZjb`zlTyjwNbdm}`tKB>\ngNy@BDfZZjb`zlTzjwNbdm}`tKB>\ngNy@BDfZjjTR`zlTzjwNCDm}`tKB>\ngNy@BDfZjjdPzlTyjv~pZEa@>\ngNy@BDfZjjdPzlTyl{NbgM}`tKB<\ngNy@DDffjjdPz\\TyKUn]EI[gAHZEaZH<\ngNy@DDffjjdPz\\TyKUn]EI[gAHZEaZH>\ngNy@DDfnj`dPzTRwqC]oX+\ngNy@DDfnj`dPzTRwqC]oX-\ngNy@DDfnj`dPzTRwq}]oX-\ngNy@DDfnj`dPzTRytTuobF{_P>\ngNy@DDfnj`dPzTSWqC]oX+\ngNy@DDfnj`dPzTSWqC]oX-\ngNy@DDfzZj@zl\\ejv~HZEa@\ngNy@DDfzZj@zl\\ejv~HZE~@\ngNy@DDfzZj@zl\\ejwNbfm|PtK|\ngNy@DDfzZj@zl\\ejwNbgM|PtKB\ngNy@DDfzZj@zl\\ejz~HZEa@\ngNy@DDfzZj@zl\\ej{Nbfm|PtKB\ngNy@DDfzZj@zl\\elz~HZEa@\ngNy@DDfzZj@zl\\flz~HZEa@\ngNy@DDfzZjfPzl\\ej{NbgM|PtKB<\ngNy@DDfzZjfPzl\\ej{NbgM|PtKB>\ngNy@DDfzfj@zl\\ejv~HZEa@\ngNy@DDfzfj@zllejv}FulahVD\ngNy@DDfzjjdPzl\\ejv~HZEa@<\ngNy@HDfZjjdPz\\TyKUms`dMBp`<\ngNy@HDfZjjdPz\\TyKUms`dMBp`>\ngNy@HDfZjjdPz\\TyKUn]EN[g^HZEa@<\ngNy@HDfZjjdPz\\TyKUn]EN[g^HZEa@>\ngNy@HDfZjjdPz\\TzKUms`dMBp`<\ngNy@HDfZjjdPz\\TzKUms`dMBp`>\ngNy@JDffj`@zt\\en\\Danwl\ngNy@JDffj`@zt]Fn\\Danwl\ngNy@JDffji@zLUYK\\xIC]oX\ngNy@JDffjjTRPzlTyJwNbfm}`dKB<\ngNy@JDffjjTR`zlTyJwIcdm[{AOfD<\ngNy@JDffjjTR`zlTyJwNbfm}`dK|<\ngNy@JDffjjb`zlTyJv~pREa@<\ngNy@JDffjjb`zlTyJv~pREa@>\ngNy@JDffjjb`zlTzLv~pREa@<\ngNy@JDffjjb`zlTzLv~pREa@>\ngNy@hAteInij`NgENRu[_DMBpmH\ngNyAHIJSMMU@]NJ\\ejwNbgMsoDMBpmH\ngNyDGQDJHRZzjXCkQrWNSfmxP`\ngNyDGQHJPRZzjXCkQrV|HP\ngNyDGQHJPRZzjXCkQrV|O`\ngNyHE@DYICHuU@auPyKUm|PtKB<\ngNyHE@DYICHuU@auPyKUm|PtKB>\ngNyHE@DYIHXmA@at`eobF{^p+\ngNyHE@DYIHXmA@at`eobF{^p-\ngNyHEAxIU\\uTAtPjrVywcz{__vb@\ngNyHEAxIU\\uTAtpitZk[gAHZEaZH=\ngNyHEAxYIHXuA@at`fobF{^p+\ngNyHEAxYIHXuA@at`fobF{^p-\ngNyHKAxIU\\u@Au`zM\\xIC]oX\ngNyHdIPSeJSSUP@]ZNcYpXun\\Danww}h`\ngNyHdIPSeJSSUS@]FJmFs`qK\\xIC^oo{Q@\ngNyHdIPSeJSWUPRH]JIkxanwl+\ngNyHdIPSeJSWUPRH]JIkxanwl-\ngNyHdIPSeJSWUPRH]JIkxanwt<\ngNyHdIPSeJSWUPRH]JIkxaoWt+\ngNyHdIPSeJSWUPRH]JIkxaoWt-\ngNyHdIPSeJSWUPRH]JIlyNZwqC]oh<\ngNyHdIPSeJSWUPRH]JIlyNZwqC]oh>\ngNyIDIPSdffjj@z\\TzMUv\\FI[gAHZEaZH\ngNyIDIPSdfnj`dPzTSWqC^oh+\ngNyIDIPSdfnj`dPzTSWqC^oh-\ngNyIDMP[dfzfj@zl\\ej{IbgI[e]HZEa@\ngNyLGQDJHtQdTaeTpGRbT\ngNyLGQDJHtQdTaeUHGRbT\ngNyLGQHJPtadTaeTpGRbT\ngNyLGQHJPtadTaeUHGRbT\ngNyLGQbKDvIdTaeTpGRbT\ngNyLcaHR`TaNLyEHYU@AuHyr\\enku}ZD\ngNyLcaHR`TaNLyEHYU@AuHyr\\unkm}ZD\ngNyLcaHR`TaNLyEHYULAtXejwNSdmxpmB\ngNyLcaHR`TaNLyEHYULAtXej{NSdmxpmB\ngNyLcaHR`TaNLyEHYULAthfsdyK]Wk{~tH\ngNy`JDTfzZjfPzt\\moFD>\ngNydMDpDTHrRPqZhCkAr[NSdmtPww{S@\ngNyhCE`DYIIXmTAtPejwNSdmuPlO{P`\ngNyhCEaxYIIXuTAtPejvzhVG}hP=\ngNyhKEaxYIIXuUBau`e[^LH>\ngNyhKEaxYIIXuUBau`e[^Op>\ngNyhKEaxYIIXuUBau`e]^LH<\ngNyhKEaxYIIXuUBau`e]^LH>\ngNyhMEPDYIHXmTAtPyLvzHVG}i`\ngNyhbEiPScNQRFUS@]FIZms`yK^LO{P`\ngNzHHlZGAJijj`NdFUu]oo{R@\ngN|@@ZeSUUPGVEEu|n{kC~t@=\ngN|@@bdwSUPGQefk[d[WZEa@\ngN|@@bdwSUPGQefk\\zJ\\wHvntKB\ngN|@@mdTaeT@GTc]W[z\ngN|DEbHb^FQRFPU@]XmVwJwmtKC~tH=\ngN|LlZIBTBdIqeIkjj`NmGKlyNRwcC~tp\ngN|LlZIBTBdIveIkjjPNmGK\\yNRmL\ngN|`hZEIWIMtuTAuhy[^LO{R@\ngN|`hZEIWIMtuTAuhy]^LO{R@\ngN}HEcAxIU\\uTAtPijvzhVG}h`=\ngN}HEcAxYIIYATAubu[gArVyV}naX_va@\ngN}HebIPSeJSSUS@]FJZmsXirVmu^lO{Q@\ngN}HebIPSmJSSUURH]FJZmsXirVmuPlO{Q@+\ngN}HebIPSmJSSUURH]FJZmsXirVmuPlO{Q@-\ngN}HebIPSmJSSUURH]JJlvJ\\ek]Wk{~tP+\ngN}HebIPSmJSSUURH]JJlvJ\\ek]Wk{~tP-\ngOp@DjfVjjdEDNnFJ\\ejwMBgIZwjCoDMB_die`<\ngOp@DjfVjjdEDNnFJ\\ejwMBgIZwjCoDMB_die`>\ngOp@DjfVjjdEHNnFJ\\ejwMBgIZwjCoDMB_die`>\ngOp@DjfVjjdEHNnFJ\\ejwMCGIZwj}oDMB_die`<\ngOp@DjzfZj`NnFJ\\ejv}g\\DahVG|dLl\ngOp@LdadMBj`NcdmVwlvmdMBpdmc`=\ngOp@LdadMBj`NcdmVwlvmdMB_dmc`=\ngOp@LdadMBj`NcdmVytTuoYm]HZEaI[G@\ngOp@LdadMBj`NcdmWWlvmdMBpdmc`=\ngOp@LdadMBjidNcdmVwlvmdM|pdmc`+\ngOp@LdadMBjidNcdmVwlvmdM|pdmc`-\ngOp@LdadMBjidNcdmWWlvmdM|pdmc`+\ngOp@LdadMBjidNcdmWWlvmdM|pdmc`-\ngOpB@xQpSagCIIKHjhHCjAoYy^wku}KCSH`=\ngOpBADQpSagCHiCEjhHCjQnU{^oWw|eLl=\ngOpL@xQpSaddadUTDAt`foYy^H[u}ICS@=\ngOpMAxZ`M@IRj[Fjj@zhXijv}P]x~hVG|dml\ngOp`@dfzMZj`NkGIZmobFaX_rVqp\ngOp`@dfzMZj`NkGIZnobFaX_rVqp\ngOp`@dfzMZjidNkGIZmobF~X_rVqp<\ngOp`@dfzMZjidNkGIZmobF~X_rVqp>\ngOp`@dfzMZjidNkGIZnobF~X_rVqp<\ngOp`@dfzMZjidNkGIZnobF~X_rVqp>\ngOphH`DYIHYVmU@]TNSU[_DMBpdck`\ngOq@@dsQkUTAtxitVk[gAHZEaI[G@\ngOq@@eMtUTEIAuhiK\\hIC]o_yHYx+\ngOq@@eMtUUUIAtxirVk[eAHZEaICO@<\ngOq`@bdwQkUUMAtXyjvzhVG|el\\<\ngOt@@TjZkjj`NfFJ]U[gAcfyP\\FaX_rQuuh@\ngOu@DPdwU[UTAtXyjvzhVG|d]\\\ngOx@@eSQmUTAupqSdmVwjC`dMBpdmckP@=\ngOx`hEIWIMtZuU@]VNRu[_DMBpdmckR@\ngOxhMD@cIICJujhCjarZk[xahVG|d]]ZX=\ngOxhMD@cIICJujjYCjarZk[xahW{|d]]ZX\ngOy@DDfzMZj`NkGIZmobFaX_rVqp\ngOy@DDfzMZj`NkGIZnobFaX_rVqp",H),i=0==(1&t)?null:Jl.OHb("26,60,96,180\n42,68,91,94\n147,176\n170,261\n210,231,244,267\n59,180\n26,30,38,55,81,96,118,180\n0,54,58,90\n0,55,90\n0,59,68,73\n0,57,77,180\n0,40,90\n0,31,35,46,68\n24,29,55,90\n1,47,51,56,70,75,78,85,88,90\n12,33,67\n0,38\n3,180\n0,44,61,87,90\n27\n0,14,29,35,61,78\n11,28,33,45,55,57\n57,61,63,90,145,148,180\n180\n0,40,47,51,72,179\n0,58\n0,52\n39,60,76,180\n51\n54,59,305\n47,50,66,311\n0,4,62\n63,84,125,163,180\n2,18,56\n60,94,178,180\n52,92,149,178\n42,82,160\n42,79,161\n67,180\n56,166,180\n51\n51\n61,174,180\n42\n0,2,28,174,180\n46,76,163\n60,88,180,208,306\n61,76,304\n0,7,10,13,60,82\n0,60\n3,37,57,60,97,129,180\n0,10,28,136,165,180\n59,61,63,71,169,180\n44,76,165\n44,75,165\n26,47,62,64,68,71,167,186,274,280,301\n27,43,49,55,68,74,145,169,184,190,283,297,301\n24,39,45,58,74,146,184,202,276,302\n47,52,149,162,179,285,287,308\n46,69,180\n40,43,77,158,180\n42,78,80,169\n42,44,49,62,68,156,178,180\n42,47,55,59,81,84,161,178,180\n170\n0,29,57\n180\n2,11,15,44,76,87,90\n0,24,43,76,90\n3\n0,10,18,21,37,44,64\n59,180\n50,72,175,180\n57,180\n58,180\n58,90,150,159,164,168,176,180\n0,3,30,60,64,75,94,123,154,180\n59\n46,52,72,168,172,180\n43,75,164,180\n50,72,172,195,284,315\n45,173,177,180,199,291,315\n170\n16,47,74,166\n53,100,159,180\n43,71,74,111,122,125,180\n31,49,64\n132,171\n32,58,334\n29,58,337,339\n56,180\n54,67,177\n58,160,180\n180\n41,80,173,180\n48,63,84,118,179\n3,41,73,147,166,179\n41,60,72,161,176,180\n48,51,53,78,157,194,282,316\n32,50,81,155,161,166,192,206,280,286,315,325,328\n59,180\n50,60,66,82,158,180\n61,179\n60,180\n48,74,168\n50,85,159,199,220,297,315,351\n61,71,77,83,90,173,193,284,300\n308\n308\n68,192,305\n59,169,174,180\n53\n62\n0,3,9,23,26,28,49\n52,60,62,180\n33,55,180\n35,56\n28,34,53,311\n185,288,290\n0,9,34,37,57,75,77,90,95,102,125,139,142,162,180\n17,62,77,170\n48,76,167,180\n54,58,65,180\n63,80,82,180\n45,48,72,167,179\n59,180\n56,70,74\n18,67,106\n56,180\n56,180\n50,180\n180\n65,186,299\n175\n52,189,191,221,287\n56,175\n62,177\n65,175\n51,72,90,138,181\n188,214,294\n192,226,296\n201,224,275,289\n48,68,77,174,180\n71,299\n44,52,57,59,61,75,298,321\n60,180\n41,73,88,164,180\n59,180\n47,57,60,63,165,167,171,181,287,311\n51,77,80,161,188,204,279,303\n303\n59,180\n61,180\n48,75,167,171,180\n65,183,290,305\n66,178,303\n54,70,178,191,303\n66,181,304\n62,178,194,304\n64,182,309\n53,294\n61,180\n60,180\n60,160,180\n41,45,54,68,93,159,180\n44\n39,55,162,180\n0,35\n0,10,64,92,141,180\n0,6,34\n8,46\n0,22,27,29,42,45,69,90\n0,31,180\n0,29,49,72,98,142,170,179\n42,71,163\n55,172,180\n56,179,295\n60,180\n60,180\n60,180\n43,64,175,191,289,296,303\n45,67,168,176,185,287\n59,178,303\n62,180,301\n53,60,68,70,108,165,289,295,302,305,328\n44,48,51,55,59,64,67,71,75,108,289,294,297,304,308,321\n0,5,41,106\n163,180\n0,15,17,70\n0,20,35,123,180\n61,180\n0,180\n0,20,53,55,75,84\n23,41,60,84,106,138,157\n17,34,53,82,90\n0,10,20,36,46,50,62,66,90\n0,59,61,107,123,180\n13,17,19,33,36,90\n1,31,36,56,58,70,77,90\n0,12,19,27,40,45,48,57,60,68,70,84,109,118,124,128,131,137,157,160,180\n7,54,67,85,90\n2,34,61,65,92,95,106,130,139,144,151,159,173,177\n2,25,28,65,87,109,180\n0,9,66,77,111,114,117,158\n13,34,72,90\n48,63,70,77,90,105,120,134,161,164,179\n0,14,30,54\n17,39,52,57,63,85,151,172,180\n30,51,53,59,69,71,114,136\n2,28,44,66,94,110,113,139,178\n14,34,65,79,136,211,235\n15\n28,35,45,179\n0,60,78\n12,26,40,83,86,105,126,129,137,155,180\n40,110,129,149,180\n24,57,69,180\n180\n62,180\n180\n0,32\n0,31\n0,25,30\n68,180\n66,82,180\n59,83,90,93,104,107,113,120,164,166,180\n55\n56\n0,56\n66,180\n47,77\n45,71,73,148,180\n48\n0,10,58,66,180\n0,7,56\n15,112,130,156,180\n118,147\n0,59,120,180\n123\n13,46,65\n15,44,66\n14,41,62\n17,46,63,65\n93,128,132,159\n0,93,123,149,153,168\n0,4,9,15,17,24,32,45,68\n1,44\n80,86,98\n76\n94,100,111,128,180\n89\n60,77,80,86\n0,14,84,106\n86\n63,164,173,177,180\n61,77,80,157,171\n62,180\n0,14,68\n64,70,81,147,168,180\n59,61,109\n51,53,77,124,179\n180\n60,63,71,92,180\n47,72,114\n87,103,180\n85,109,150,180\n54,73,148,167\n114,180\n43,60,80\n0,50,84\n66,180\n67,180\n60,180\n163,180\n133,140,142,145,147,162,165,169,180\n15,114\n68,88,180\n65,180\n97,180\n62,97\n65\n62\n79,176,180\n65,180\n122,163,179\n0,62,128,171\n0,36\n1,39\n137,152,180\n0,26,56\n70,180\n90,114,153,170,180\n78,97,116,129,142,154,180\n0,56\n45,61,76,96\n59,94\n66,180\n180\n46,63,66,69,79,83\n73,75,122,180\n85,91,157,162,175,180\n53,75,78\n74,126,180\n178,180\n68,180\n71,136,154,163,173,175\n68,111,119,175,179\n0,12,57,76\n3,58,62,163,180\n62,65,67,79,85,163,180\n45,48,72,146,169,180\n106,121,123\n69,78,180\n180\n180\n16,54,77\n74,164,167,179\n65,180\n66,180\n65,180\n180\n55,67,74,180\n48,66,87\n180\n180\n68,180\n69,96,99,115\n180\n72\n73,180\n72,91\n72,94\n86\n89\n78,106,180\n82,91,100,180\n0,28,31,39\n0\n100,113,116,163,180\n117,137,148,158,180\n0,76,78,108\n0,6,69,105\n0,46,71,73,76,117\n68,180\n59\n69\n73,92,111,155,161,168\n0,28,49,64,88\n75,92,180\n46\n136\n180\n180\n0,9,121,162\n0,33,82,124\n51,72,78,94,98,115,147,177,180\n11,21,32,58\n14,41,65\n64,180\n61,75,78,180\n57\n56\n0,67,180\n49\n152,154,179\n0,151,180\n34,55,58,66,75,79,82,104,131,164\n0\n0\n160,180\n0\n0\n84,180\n117,134,137,139,180\n125,134,179\n110,116,119,179\n59\n16,58,85\n58,93\n0,57\n77,180\n131,168,180\n22,50,72,86\n48\n77,180\n77,125,141,144,180\n2,47,87\n27,30,51,77\n76,180\n18,55,83\n169,172,180\n62,94\n30,77\n29\n62,156,176\n97,123,180\n144,151,153,156,164,180\n68,96\n47,78,129,148,153,175,178\n119,121,145,148,154,180\n29,36,51,53\n90,110,162,179\n104,107,129,133,179\n104,127,147,159,161,174,180\n88,111,144,166\n57,82,105\n0,55,93\n0,56\n121,156,180\n36,56,80\n68,180\n68\n67,180\n51,179\n39,66,180\n16,25,66,153,180\n67,160\n106,167,171,180\n85,91,105,111,125,132,139,142,178\n59,92\n61\n0,180\n0,26\n0,180\n0,45\n132,138,180\n130,180\n0,33,60\n180\n180\n180\n0,38\n0,27\n180\n180\n79,90,105,135,180\n77,111,145\n77,91,96,120,142,146,150\n77,101,111,121,140,180\n72,180\n180\n65,180\n0,57\n76,88,91,126,166\n32,38\n80\n40\n78,96,98,128,135,147,179\n78,93,112,154,158,172,178,180\n73,180\n8,57\n15,57\n1\n180\n63,180\n67,73,81,84,119,122,166\n0,57\n0,58\n92,180\n112,178\n165,180\n64\n0,180\n180\n0,98,117,129,138,145\n0,125\n12,80,83,116,125,142,146,157,167,170,173,180\n0,12,52,66\n12,32,69\n155,158,180\n64,180\n26,61,76,84,180\n15,56\n0,55,76\n0,54\n63,180\n49,76\n0,38\n0\n180\n180\n180\n0\n0\n180\n180\n70,180\n85,131,180\n95,152,180\n79,81,105,180\n84,106,180\n57\n0,26,52,66\n55\n19,30,73,88\n56\n65,68,180\n85,90,94,96,122,131,176\n171\n45,47\n54,72,82,148,152,180\n81,116,120,180\n81,84,87,104,113,124,129,134,149,167,178\n0,23,42\n29,46,80\n69,139,175\n80,128,142,146,180\n91,123,137,146,154,180\n123,178\n134,180\n21,37,72\n100,109,136,150,179\n6,8,12,14,27,40,119,153,156,180\n0,54,70\n180\n0,121\n180\n65,180\n136,169,171\n0,9,16,56\n1,55,83\n56\n63,180\n54\n63,180\n149,180\n152,180\n56\n62,180\n73,81,170\n47\n180\n89,109,125,127,153,160,180\n106,123,141,151\n0,27,31,69\n56,69,72,93,102,108,117,126,179\n180\n180\n97\n94,108,112,133,167,180\n153,157,165,177\n96,113,123,167,180\n141,155,180\n54\n63,101,123,130,143,148,159,161,164,180\n32\n87,95,97,104,106,149,153,156,163,180\n0,19,57\n83,101,116,133,159,180\n0,67,180\n67,85,173,179\n62\n62,83\n42,57,80,94\n65,81,83,180\n65,180\n42,57,72,178,180\n70,156,180\n83,113,135,149,153,155,161,164\n58,82,180\n74,178\n65,179\n0,25,33,36,40,52,89\n0,180\n0\n0,180\n180\n180\n1,3,36,53,55\n180\n96,102,122,126,145,156\n76,94,110,121\n75,180\n155,171\n23,56\n72,180\n64,180\n57\n59\n73,131,159,174,179\n60\n47\n61,180\n65,78,180\n58\n58\n0,3,180\n180\n6\n201,249,265\n0,4,9,23,28,30,33,86,109\n0,4,28,50,53,72,75,85,87\n0,85\n122,125,167,180\n10,35,37,168\n2,25,28,40,47,65,170\n0,28\n5,11,29\n35,55,85\n60\n1,31,53,261,356\n71\n83,110,183,189,200,215,219\n89\n221,284,312,329\n233\n274,300,307,309,338\n275,277,295,314\n260,289,291,296,305,308\n160,168,180,203,257\n177,196,226\n0,180\n0,104,134,163,170,180\n25,312,341\n24,310,313,332,358\n58,69,73,163,168,174,180\n160,180\n117,166,169\n357\n3,17,23,31,304,320,343,345\n59,187\n63,65\n74,204\n68,71,205,236\n69,204,221,223,242,284,307\n54,72,98,190,209\n281,297,313,338\n219,222,233,283,286,312,336\n279,313,338\n59,80,190,221\n58,78,188\n72,99,183,196\n2,12,17,31,33,41\n1,27\n4,6,35,167\n4,35,153\n30,181,348\n180\n72\n0\n0,21,31,36,38,164,173\n0,16,19,35,52\n1,12,137,158\n11,147\n89\n102\n180\n90\n0\n4,170\n123,134,140,178\n3,5,25,346\n5,341\n32,56,69,84,105,122,161,180\n0,31\n51,90\n69\n60,95,103,107\n90\n90\n0,48\n0,41\n153,180\n32,53\n0,21,30\n46,127,130,143,158,173,180\n0,11,17,90\n0,36,90\n62,137,180\n0,40,60,81,84,90\n37,41,44,49,95,104,118\n54,57,69,74,85,90\n56,90\n59,91,119\n57,90\n0,29\n142,180\n134,137,158,180\n1,57\n3,38\n71,88,95,113,129\n71,78,90\n8,37,56,71,90\n11,42,58,76\n82,103,106,108,123\n46,55,60,64,73,79,90\n27,30,81\n54,97,125,128,152,167,173,178,180\n1,45,61,81,83,86,90\n0,12,35,42,44,80,89\n67,69,91,121,171\n0,32\n13,35,43\n0,47,56,62\n0,11,15,25,28,56,58\n131\n123,144,166,180\n180\n180\n165,180\n0,21\n0,20\n50,90\n67,89,120\n90\n0,33\n59,84,122\n56,64,72,90\n43\n33\n180\n143,162,177,180\n7,28,48,51,54\n2,50\n0,36,46,50,52,54,152\n47,108,134\n57,77,88,118,138\n47\n52,68,85,105\n0,150,154,180\n59,73,107,123,126,129,138,157\n50,119,148\n58,66,86,114,130\n0,3,159,166,180\n44,46,66,104,136,162,180\n52,137\n60,64,74,117,119\n54,72,77,83,90,111,124,141,153\n0,55,85,90,93,96,99,106,129,180\n0,57,72,77,130,180\n63,91,108,152\n15,180\n0,155,168,179\n0,25,175\n70,89\n53\n149,180\n154,165,179\n180\n0,45\n0,39\n70,122,126,180\n50,86,167\n53,123,127,136,142,154\n23,38,53,78,103,172\n0,35,37,44\n0,17,41\n60,75,97,107,139,158\n38,45,49,57,157,180\n40,62,75,81\n0,44\n66,180\n0,34,59,180\n0,63,65,180\n0,74,180\n282,307,334\n305\n68,163,179,246,321\n21,42,55,72,162,180,231,236,242\n52,71\n55,102,113\n177,199,239,290\n155,158,178,201,285\n6,55,318\n10,56,312,354\n30,59,313,358\n0,23,45,47,50,56,58,309,327,335,338,341\n151,194,284\n152,185,279\n12,14,55,312\n15,54,313,358\n49,314\n46,314\n58,80,183,200,280,285,288\n47,61,185,283\n52,68,71,172,297,311\n64,77,144,169,171,300,308\n31,34,37,51\n0,42,46,58,302\n44,312\n0,54,180\n0,56\n182\n76,87,182\n0,52,79\n67,80,153,164,174\n70,76,80,83,85,87,166,186\n52,309\n46,307,325,345\n71,181\n176\n51\n46,49,307\n49,168,182,310,316\n83,130,175\n80,86,92,95,107,128,157,178\n66,180\n74,175\n74,163,175\n181\n181\n32,52,85,123,180,293,295\n201,300\n63,198,299\n50\n4,56,84\n183\n184\n62,116,118,131,174,293\n61,293\n19,28,50,182,300\n53,184,297\n183,226\n182,187,226\n66,164,298\n69,167,297\n60,180\n59,180\n0,54,71,171\n70,179\n63,78,177,179\n33,42,45,51,59,66,71,88,180\n131,166,178,180\n178\n180\n180\n180\n53\n0,2,4,6,49\n28,55\n9,54\n0,25,46,49\n59,180\n64,180\n49,76\n48\n55,180\n67,179\n180\n180\n46,74\n0,37\n58,175\n61,180\n164\n55\n52,55,58,66,179\n76,180\n63,88,180\n297,303\n300\n58,100\n57,102\n56,96\n54,87\n192,267,292\n189,191,193,201,291\n42,53,311\n306\n9,36,56,307,352\n56,307,339,359\n53,276,296\n36,49,55,300\n31,306\n63,74,174,177,185\n76,175,179,181\n186,207,278,282,291,304\n183,196,280,294\n199,274\n199,271\n9,25,55,61,68,96,102,104,142,174,180\n1,140\n0,30\n1,178,180\n0,2,108,123,125,160\n0,3,9,129,165\n0,8,40,121,129,160\n0\n0,2,138,179\n0,39,135,166,170\n25,94,102,126,133,143,155,161\n157,160,180\n161,180\n0\n0,7,45\n3\n66,99,129\n62,78,103,124,127\n106,124\n0,27,30,38,171,180\n0,5,133,146,150,163\n180\n3,39,164\n1,18,21,127,168,180\n162,180\n63,114\n67,85,88,90,105,125\n180\n123,148,322,336,347,357\n125,297,318,326\n8,50,342\n6,8,10,12,23,335\n2,16,342\n16,305,335,343\n1,6,111,231,245,324,347,350,359\n103,108,114,240,249,260,276,300,319,349\n72,78,85,101,105,110,120,271,287,307\n111,133,185,267,301,350\n9,25,332,348\n16,335,337,352,354\n162,164,173,188\n210,251\n13,137,235,238,298,320\n5,128,237,314,317,327,334,339\n283,303,327\n304,330\n314\n15,224,357\n3,18,43,74,212,249\n13,15,188,220,246,248,340\n200,208,226,248\n204,217,246\n202,219,231,234,252,265\n154,174,211,248,265,267\n219,264\n210,249\n1,8,10,12,45,77,291,338\n12,52,296,341\n17,27,328,345,347\n14,48,339,348\n110,329,348\n21,53,76,79,103,351\n2,6,90,105,339\n10,89,351\n122,140,166,173,208,210,220\n134,147,167\n136,217,236,266\n128,145,147,191,194,236,265\n119,126,132,136,226,239,248\n135,154,226,241\n93,116,119,123,276,302,340\n92,110,122,130,243,277,299\n98,107,114,117,123,253,310,316,342\n99,121,251,271,335,343,348,351\n306\n306\n236,250,276\n180,229,252,255,257\n247,279\n16,339\n339\n5,308,342\n13,339\n122,145\n137,155,229\n215,218,221,254,260\n216,221,224,230,232,253,269\n222,228,234,254,270\n313,343\n347\n34,54,290,309,320,345\n1,33,50,293,311,320,328,339\n10,20,26,335,353\n114,126,136,160\n103,120,204\n10,290,329,352\n0,3,25,46,56,87,123,127,135,142,145,155,180\n0,27,45,48,50,76,122,165,177,180\n78,118,148,151\n180\n180\n0,21,42\n0,2,29\n1\n0\n0,14,25,50,84,121,180\n0,13,34,41\n0,30\n56,81\n21,330,357\n17,345\n356\n6,20,34,341,351\n9,33,36,350,352,356\n31,56,355\n17,27,30,321,358\n0\n0,22,24,42,44,51,85,90\n0,66\n0,2,16,42\n180\n0,132,160,180\n0,45\n5,9,22,54\n180\n0,18\n62,88\n33\n20,145,180\n1,10,12,20,27\n180\n0\n137\n135\n144,148,161,163\n6,18,120,142,146,161,164,166\n122,271,313,325\n114,261,318,343\n305,325\n123,147\n134\n0,8,302,304,331\n2,301,335\n5,32,54,75,79,89,338\n9,26,44,47,51,87\n77,83,106\n51,75,104\n119,121,123,150,199,220,251\n116,150,161,199,225,247,250\n149,167,184,189,195\n132,135,138,150,167,182\n152,156,216\n149,175\n130,150,162,164,181\n169,177\n3,7,50,114\n2,4,48,112,169,175\n261,285,322\n261,287,323\n110,115,127,147\n116,139,155\n303\n303,323\n101,122\n102,121\n247,255,257,261,281\n247,281\n287,332,334\n8,290,332\n9,80,101,348\n12,101,348\n128,164,197,234,241\n119,125,128,148,163,190,194,196,231,233\n72,99,117,119,136\n49,96,98,106,112,134,165\n279,291,301,304,322\n250,266,278,287,301,305,332,352\n289,304\n304\n126\n126\n11,18,23,33,70,77,86,113\n21,39,59,88\n136\n136\n51,337,355\n47,338\n118,146,168,170,221,244\n118,141,154,169,172,188,221,244\n89\n90\n52,55,90\n0\n0,8\n1,3,38,58\n0,132,151,174,180\n0\n74,90\n24,337\n162,179,198\n0,10,19,39\n39,59,180\n59,180\n23,93,252,268,322,338\n0,66,180\n0,180\n0,7,33,112,142,180\n0,22,51,87,107,129,150,180\n0,43\n19,177,180\n74,296\n0\n21,159,166,173,175\n56,180\n31,46\n53\n0,10,14,29\n0\n0,44\n136,143,146,180\n60,110,150,167,180\n43,56,102,168\n60\n56\n60,68,75,80,90,178,180\n59,303\n59,302\n71,85,97,105\n49,72\n56\n0\n180\n69\n69,88,103,111,136\n0,14,18,21,34,41,131,134,156,162\n15,20,29,59,61,90,111,139,141,144,165\n48,80,164\n0\n67,180\n0,56\n56,305\n56,305\n59,173,180\n54,75,123,169,177\n57,180\n69,180\n182\n0\n0,22\n61,74,109,141,180\n29,54,77,83,89,108,162\n38,52,87,90,97,105,174\n46,62,71,107\n31,49,97,143\n35,48,73,95,141,172,286\n35,74,94,155,171,293,317\n58,83,158,164,166,180\n19,41,59,174,180\n61,63,80,179,284,338\n91,178,180,189,306\n52,57,61,114\n63,114\n99,261\n58,82,168\n61,80,177,180\n60,79,102,105,113,116,124,127,133,156,176\n63,180\n36,65\n0\n34,36,43,47,59,80,90\n1,9,35,90\n13,21,35,52,55\n49\n0\n8,12,49,126,154,180\n0,34,36,50,71,90\n1,4,39,73\n66,68,86,136,151,153,155,166,180\n0,27\n0,57,84,122,141,144,146,149,164,180\n0,47,99,131\n137\n0,39,152,180\n1,8,29,51,58,62,73,84,89,100,104,106,109,131,152,180\n0,162,180\n0,8,26,81,150,180\n65,75,81\n80\n27,29,66,68,109\n51,71,98,105\n31,33,59,79,102,235,256\n36,38,41,56,62,90,158\n180\n66\n67,108\n67,174\n12,39,54,96,153,158,174\n161,167,180\n60,145,180\n33\n24,28,45\n48,54,56,59,66,78,162,180\n55,67,86,180\n16,19,42,63,67\n47,154,180\n15,33,39,58,104\n0,20,23,45\n12,21,61\n66\n0,25,38,58,65\n43,67,73,84,87\n0,16,18,29,32,36\n22,30,44,53,56,58\n39,62,78,173\n28,61,81,153,180\n2,49,77,85\n0,26,30,37,41,45,51,55,61,65,90\n60,180\n0,16,138,157,168,180\n0,13,29,48,90\n15,131,152,158\n49,53,68,96,112,142,173\n51,71,74,87,110,132,174\n59,62,93,167\n15,40,57,73,110,115,130,139,143,149,155,180\n0,5,40,74,104,137,159,180\n0,7,85,107,134\n0,11,112,132,144\n61,180\n64,89,148,161,167,180\n60,67,77,108,148,171,176\n21,25,45\n36,40,49,54,82,157,171,180\n37,57,180\n52,55,63,155,180\n20,47\n47,67,168\n2,32,34\n0,3,19,38,64,72,79,81\n124,140,174,180\n40,47,49\n17,46,310,342\n1,31\n42,54,56,65,73,85,90\n0\n62,85\n23,32,56,71,83,87\n192,303\n63,159\n180\n67,81,84,175,177\n48,66,109,174\n238,289\n0,46,55,61,79\n0\n0\n15,32,40,63\n180\n63,76,79,176\n64,73\n57,83\n0,7\n180\n57,180\n54,75,90\n69,80,82\n66,80\n103\n71\n180\n40\n0,5,9,17,57,75,78,85\n0,9,31,43,49,63\n2,19,47,61\n60,64,86,121\n43,75\n43,47,77\n41,78,96,101,104,109\n176\n180\n180\n0,29,33,71,90\n0,118,156,180\n0\n36,40,88,90\n130\n0,3,8,20,28,30,49,70\n0\n90\n10,33,65,88,95,102,122,141,150,164\n8,64,93,109,126,149,158\n4,19,235,254,263,277,282,302,306,319,322,328,335,349\n1,235,278,288,300,325,344,358\n10,109,128,167\n10,15,21,23,25,109,124,174\n21,28,50,105,113,125,137,152\n0,6,50,64,83,121,146,173,177\n6,8,21,58\n66,85,99,104,179\n69,180\n66,209,306,338\n66,207,306,332,334\n187,280,285,291\n111,136\n105,129,133,138,141,143\n90\n35,47,56,69\n70,90\n41\n24,47,54,60,90\n64\n0,9,39,58\n0,45,91,95,122,135,155\n182\n64,90\n34,92,132,180\n0,33\n90\n180\n4\n22,44,47\n176,184\n181\n0,6,24,52,79,82,84,90\n303,330,353\n58,106\n58,92,99,114\n27,31,42,68,102,140,172,176,180\n0,3,20,22,25,32,35,37,52,78\n71\n55,80,96\n82,86,89,93\n180\n180\n51,63,71,180\n0,5,152,156,180\n0,22,29,40,88\n136\n41\n101,168\n98,164\n49,52,61,86,113,180\n63,301,323\n59,195,248,293,330\n50,52,69,167,172,180\n31,61,180\n41,48,61,69,160,180\n25,49,63,71,180\n50,71,73,169\n45,59\n57,176,180\n59,174,176,178\n0,24,34,36,90,136,158,160\n57,59,69,180\n58,180\n0,30,55,57\n32,55,59,72,78,156,171\n34,45,58\n54,81,87,90\n1,10,20,43,70,104,110,115,118,139,142,161\n128,141,145,152,180\n0,8,36,52,88\n179\n77,177,180\n180\n49,81,163\n180\n58\n62,79,82,99,106,109,112,120\n66\n67\n28,61\n0,17,123,125\n0,31,55,66,76,89,154,178\n59,102,180\n54,67,168\n62,180\n180\n30,56\n0,6,11,14,180\n0,35,120,142,146,180\n14,18,23,39,44,147,180\n0,30,59,112,121,155,159,180\n0,9,13,24\n12,92,141,156,164\n13,25,53,78,94,114,145,179\n45,70,158,171\n8,19,42,57,60,80,171,176,179,188,201,205,208,222,251,271,299,341\n11,17,38,55,169,201,309,313\n68\n48\n0,4,58,180\n0,9,46,120,166,177,180\n1,18,52,70,115,180\n180\n0,10,12,14,30,48,69,133,180\n78,99,169\n76,95,99,103,150,168\n70,141,168\n72,165\n29,49,72,74,168\n52,59,180\n33,58,90,100,148,180\n0,2,31,51\n0,2,8,42\n59,180\n13,48,178,192,297,311\n43,155,182,282,297,353\n70,72,149,164\n70,164\n33,37,41,166,177,203,308,355\n9,23,42,45,179,190,204,311\n68,163\n66,165\n0\n0\n114,133,180\n0\n0\n0\n0\n0\n0\n0,180\n180\n0,8,159,180\n151,180\n0\n11,22,35,150,179,183,194,197,348\n1,5,157,166,181,199\n15,355\n221\n216,238,244,259\n22,234,246,249,255,261,268,341,356\n248,358\n4,296,303,314,338,359\n2,246,249,305,344\n6,12,298,346\n19,76,80,117,129,131,234\n16,118,144\n0,180\n0\n68,180\n65,79,81,108,169,187\n295\n295\n292\n180\n184,292\n184,282,287,292,300\n179\n56\n21,55,309\n1,40,56,306\n65,185,302,319\n59,77,178,303\n176\n71,157,178\n180\n63,303\n65,183,305\n33,58,61,306\n33,57,300,325,334,355\n180\n181\n67,175,301\n68,175,299\n66,176\n66,131,180\n301\n187,205,293\n191,294\n192,194,297\n191,211,296\n199,268,298\n60,299\n62,300\n67,193\n59,74,298,301,310,323\n38,44,59,62,195,296\n38,62,76,79\n283,292,298,320\n65,83,176,202,228,263,296\n59,70,167,189,262,282,285\n0\n0,18,43\n63,180\n146,180\n180\n54\n14,54\n0,5,7,56,79\n50,65,170\n180\n61\n59\n13,34,55,306\n51,305\n308\n51,306\n50,307\n0\n0,40,180\n0,67,74,90\n0\n143,179\n0,48,60,90,96,98,103,129,180\n0,15,109,119,142,180\n0,25,27,30,49,55,60,77,100,103,105,138,141,173\n0,180\n0,7,135,156,180\n0,28\n0\n180\n180\n180\n0,27,31,41,46,55,57,70,102,128,144,180\n0,180\n180\n180\n8,180\n0,180\n0,179\n0,61,89,112,180\n180\n2,4,51,71,128,130,147,170,180\n0,11,35,38,55,75,78,110,130,150,170\n89,114,126,147,154,159,179\n28,103,134,150\n129,133,143,148,154,159,163,169,176,196,230,236,239,243,247,249,257,269,273,275,315,317,346\n3,138,145,156,185,217,229,232,245,249,262,272,276,294,299,305,309,329,349,359\n103,125\n2,4,21,30,39,45,67,82,97\n1,15,33,90,93\n138,152,155,171,214\n139,186,194,217\n157,173,220,224\n156,217,220\n50,93,118,147,153,183,185,209,224,258,264,270,337\n19,85,141,196,198,201,205,209,211,243,264,327,336\n139,165,219,248\n11,26,121,235,264,293,300,308,314,326,332,338,353,356\n3,7,23,26,101,172,233,257,275,294,310\n3,22,35,45,61,88\n1,133,171,180\n0,23\n151,155,158,161\n151\n65,180\n57,175\n25,57,303\n57,296,304,306\n302\n0,63,180\n133,180\n63\n60\n63\n60,62,180\n180\n0,78,96,101,110,180\n63,180\n66,174,296,303,306,309\n64,175,299\n26,65,67,173,192\n61,90,174,194\n60,172,296\n1,128,150,170,180\n59,180\n54\n180\n15,52\n10,25,53,60\n54\n48\n48,299\n52,300\n302,325\n301\n303,332\n179\n60,83,85,102,178\n60,82,173\n67,76,85,105\n58,306\n191,208,298\n189,210,216,299\n295\n265,295\n251,275,288\n195,251,266,289\n60,184,302\n58,174,303\n54,306\n55,305\n180,186,196,249,268,270,295\n179,185,192,240,273,295,300\n64,174\n65,175\n72,88,92,133,168\n190,198,206,284,289\n190,194,206,286\n236,239,263,281\n193,224,246,263,265,278,292\n0\n0\n0\n0,44,47,66,102,119,129,132,149,180\n0,57,65,90\n0,5,7,24,27,29,31,39,156,180\n0,12,15,17,46,65,85,95,104,107,130,144,150,153,158,161,169,172,180\n0,64,94,127,130,136,180\n1,112,141,256,272,313,332,349,358\n90\n0,35,55,73,109,115,123,126,130,134,180\n89,123,136,144,180\n80,97,141\n55,76,171,180\n72,178,180\n71,180\n158,180\n153,169\n9,27,50,71,78,81,98,122,145,171,180\n0\n0,21,36,45,64,75,83,94,100,127,153,156,177,180\n1\n5,25,38,67,93,164,297,313,336,341,347,353\n12,35,40,47,68,85,296,311,336,341,350\n0,7,25,35,45,48,63,65,68,94\n28,36,46,79\n50\n123,140,164\n90\n63,90,93,124,166,168,171\n0,42,62,90\n179,218\n0,30,52,85\n87,98,107,112\n0,2,14,45,47,75,114,139\n89,104\n85,105\n16,28,35,42,65,79,101,135,160,180\n36,44,46,54,75,91,216,235,252,279,300\n0,180\n0,180\n0,46,180\n0,22,27,42,78,120,122,139,143,148,158,179\n55,70,74,258,358\n0,50,71,89,218,342\n24,49,67,88,135,182,266,274,280,350\n50,83,153\n38,65,91\n70,94,96,98,104,249,259,266\n8,178\n0,97,107,180\n28,65,91,155,180\n62,165\n67,167\n107,110,126\n0,14,18\n44,48,64,80,82,84,104,106,126,131,156,168,176,178\n106,115\n68,156,180\n15,53\n65,157,172\n64,180\n62,72,85,101,143,152,165\n55,62,180\n59,69,73,75,180\n34,59,84\n0,6,19,28,46\n0,17,21\n75\n0,9,33,50,76,79\n54,59,65,74,79,82,95,180\n98,116,142,172,180\n0,26,28,43\n36,54\n35,41,55,70\n4,19,41,177,321,337\n75,118,139,151,172,180\n21,23,46,48,70,108\n0,13,16,25,82\n24,40\n40\n0,179\n0,5,14,20,28\n2,26,28\n0,10,19,24,116,135\n0,18,98,130,166\n109,142\n0\n58,180\n61,176,180\n180\n56\n42,62,180\n0\n0,40,61,66,68,143,180\n0,75,90\n1\n53,73,92,109,133,172,180\n0\n2\n180\n120,145,147,169,174,178,180\n0,28\n11,56,128,165,180\n28,66,90\n0\n180\n0,23,54,77,148,179\n145,178,180\n61,152,180\n0,80,101,122,142,145,180\n0,8,81,113,133,136,143,148,180\n0\n15,24,27,53\n6,8,25\n0,23\n2,52\n2,31,42,56\n180\n180\n141,166,180\n180\n180\n180\n0,38,50,95\n0\n141,180\n179\n8,25,41,61,64,116,124,154,156,161\n148,151,155,158,162\n0,43,54,64,93,123,140,157\n0,67,89,96,98,105,125,132,137,144,146\n4,7\n1,3,17,19\n0\n0,9,25,48\n180\n180\n180\n180\n70,117,147,151\n0,9,11,35,72,95,122\n180\n180\n144,180\n0,180\n0,177,180\n0,20,25,60,172\n128,149,171,176\n180\n180\n0,42,131,161,180\n3,23,36,51,112\n2,15,40,55,58,70,132,161,168\n180\n158,180\n0,2,9,54,89,136,144,148,151,179\n138,180\n0,159,180\n0\n0,180\n0\n97,142,161,180\n82,127\n126,165\n151\n128,140,158,182,186,190,222,244,250,256,298,345\n128,133,231,243,249,264,284,292,301,303,320,347\n107,118,124,136,142\n112,116,118,120,122\n121,132,141,148\n0,41,53,64,89,115\n40,43,50,55,63,70,92,108,110,356,359\n18,21,47,77,90,104\n149,165,167,172,229,260\n116,133,155,177,228\n179,243,268\n167,184,199,219,222,227,250,257,264\n131,155,205,208,214,236,238\n159,165,228,238,242,244,271\n150,213,242\n152,227,232,240\n140,165,178,212,214,232,234,273\n188,202,205,208,236,253,256,258\n115,124,145,172,227,231\n169,181,194,218,236\n238,251,266,282,287,292,295,298,322,348\n224,237,242,260,300,320,325,345\n25,70,96,146\n135,138,145,152,176,217\n141,145,148,159,165,167,173,179,213\n254,269,272,298,331,351,353\n266,295,298,314,334\n0\n0,35,132,134,137,180\n33,64,79\n0,39\n49,52,65,93,110,126,129\n136,154,180\n159\n0,29\n0,18\n180\n0\n0,13,33,120,149,180\n0,45,49,59,90\n0,2,7,10,19,23\n0,34,36,44,70,77,84,128,153\n0,19,21\n0\n0,15,33,162,180\n0,20\n139,180\n20,28,42,119,149\n46,118,159\n20,84,101,117,216,227,230,261\n21,52,63,108,233,239,244\n51\n28,50,76\n35,71\n36,96\n29,34,38,106,214\n39,67,224\n212,238,257\n212,237,253\n106,127,138,166,201\n102,152,201,215\n251,274,290,326,329\n6,8,13,17,268,290,309,326,338\n271,327,349\n277,292,294,302,307,315,323,337,343\n83,109,131,136,152\n85,87,105,135,141,148,152\n105,134,138,142\n72,93,98,108,127\n4,6,12,18,46,63,83,105,132,156,160\n8,15,38,44,57,96,101,116,142,159\n17,42,46,54,68,101,233,243\n15,19,25,27,41,45,47,50,77,87,101,208,251\n36,59,79,104\n109,140,163,179,198,221,238\n109,140,164\n22,55,74,102,105,110,113,188,192,217,239\n10,12,37,96,195,230\n42,198,218,238,242,246,265\n65,112,207,232,267\n32,225,246\n53,75\n25,131,133,321,349\n25,50\n1,3,8,17,34\n22,229,247,348\n2,22,251,307,343\n6,246,269,358\n246,310,349\n223,246,264,288,337,352\n6,359\n1,240,256,274,310,335\n110,147,164\n89,91,105,120,140\n111,132,155\n109,139,157\n5,13,18,241,251\n19,95,116,235,260,357\n18,112,239\n115,130,133,162,244,248\n23,98,131,239,343\n25,222\n21,40,205,225\n70,92,177\n68,158,168,180,272,309\n295,307,317\n58\n11,67\n60,301\n56,281,302,317\n42,58,299\n52,302\n65,176\n64,176\n114,118,175\n72,170,179\n75,124,155,177\n86,123,179\n93,135,176\n61,177\n118,139\n70,177,200,301\n174\n63,81,175\n146,152,178\n71,181\n1,28,48,61,63,317,354\n24,53,55,169,303,326,340\n10,355\n188,190,222\n37,57\n57\n55,305\n54,305,322,329,334\n214,235,237,300,325\n193,221,223,237,240,244,247,301\n195,217,220,258,306\n70,181\n66,129,132,174\n61,76\n79,95,98\n76,172,177,179\n58,84,95\n35,45,62,198,294,306,310\n54,69,190,306\n68,171\n46,49,58,60,62,186,303\n189,227,291\n187,221,296\n55\n58\n169,172,176,185,289\n62,177,307\n62,96,179,306\n57,177\n166\n55,85,108,111,125,138,140,152,175\n59,85,107,124,127,147,175\n103\n261,302\n302,328\n302\n59,189,233,285,289,302\n58,83,190,213,300\n62,84,303\n61,176\n62,177,304\n0,130,136,144,146,159,165\n180\n0,29\n1,17,23,30\n0,3,5,29\n0,4,136,348\n34,44,51,74\n302,333\n178\n100,130\n66,92,94,127,155\n87,100,114,117,123,130,135,145,148\n78,82,86,91,110,114,128,149\n198,218,220,225,253,262,271\n103,105,113,133\n103,133\n26,28,60,180\n46,67\n180\n159,180\n22,55\n23,29,38,57\n33,62,180\n42,61,180\n60,168,300,310\n36,58,168,298\n56,86,94\n54,78,82\n302,304\n302\n139,155,181\n64,90,172\n64,171\n55,68,88,164\n49,66,89,118,165\n66,92,169\n64,123,136,173\n64,88,160\n57,105,163\n61,164\n186,223,298\n192,228,296\n297\n193,254,259,296\n69,80,169,189\n53,177,295\n59,179,299\n47,63,307,314\n38,52,54,303\n44,300\n64,170,173,175\n63,83,171\n59,65,70,179,182,293,299\n58,182,291\n40,61,324\n61,171,314,317\n181,184,199,277,296,301\n0,4,26,53,159,180\n54,180\n24,166,177\n156,191,225\n155,174,191\n62,180\n76,172\n57,80,103,180\n0,31,49,162\n153,180\n127,159,179\n0,25,44\n15,42,59\n4,46\n0,49,82\n65,180\n69,85,180\n60,66,69,72,96,180\n67,180\n0,42,62\n8,69,156,178,180\n44,49,63\n12,45\n3,44\n67,89\n23,67,307,319,322,327,329\n21,46,302,316,338,341\n47,62,306,311,316,356\n41,60,315\n51,193,196,286,304\n52,189,284,311\n45,321\n0,4,27\n28,47,60,67,73,77,89\n0,19\n138,142,175,178\n1\n0,17,44,76,80,96,104,115,126,171,180\n0,9,16,23,28,31,34,66,88,105,112,122,124,128,135,147,156,166\n125,138,151,180\n9,29\n0,7,9,17,37,57,63,69,89,151,180\n0,3,16,36,91,122,131,151,155,158,160,177,180\n60,65\n63,180\n70\n32,58,65,180\n3,9,12,19,154,162,164,169,173\n2,69,90,95,99,120,140\n26,106,120,169,188,334\n38,40,46,59,91,106,108,115,136,138,154\n0\n143,180,216\n56,123,182,241,271,290\n118,138,174,245,316\n94\n3\n20,22,49,79,84,92,95,153\n0\n0,180\n0,14,180\n0\n2,6,13,180\n22,180\n0,24\n0,22,180\n169\n13,21,30,71,73,238,334\n0\n0\n4\n0\n0\n68,70,182,185,302\n65,186,300\n199,294\n192,194,290,300\n0\n63\n57,59,310\n189,296\n187,203,297\n0\n0,2\n196,239,292\n0\n0,25\n0\n92\n17,77,96\n68,151,172\n69,177,201\n287,290,306\n0\n0\n0,25,49,69\n0,28\n66\n66\n293\n294\n0,11,26\n83,85,102\n87,105\n7,11,14,46,54,58,148,155\n14,47\n5\n11,163\n16,51,140,171\n4,13,41,59,171\n4,35,54,86,224\n4,7,36,59,69,217,219,236,239\n257,268,270,339\n265,339\n225\n222\n225\n228\n63,163,180,279\n1,40,280,343\n0,39,62,80,162,180\n66,116,138,141,145,167,180\n0,3,27,29,65\n13,36,58,76,101,119,172\n0,9,60,74,106,157,159,171,180\n0,63,104,107,110,133,145,172,177,180\n0,2,33,39,42,59,76,102,146,155,168,174,180\n84,109,115,180\n99,152,156,165,172,176\n0,8,37,69,100,103,106,123,162,169,175,178\n63,106,133,171,177,180\n46,66,82,117,170,173\n143,163,180\n0,22,32,60,68,96,111,132,155,167,171\n1,3,7,122\n61,177\n32,34,38,56,180\n56,168\n61,180\n27,58,109,140,180\n39,64,94,180\n27,61,86,154,178,180\n0,12,30,36,51\n36,55,77,99,102,105,144,179\n21,55,71,77,87,91,95,124,139,163\n50,53,62,175,177,179\n13,50\n14\n13,102,106,260,263,282,333,351\n52,64,180\n61,180\n56,178\n59,180\n60,180\n61,180\n3,315\n0,21\n51\n3,72,114,133,162,165,180\n47,110,115,132,160,169,172,180\n0,180\n0,179\n0,180\n7,9,29,87,180\n2,102,149,154,158,185,189\n3,49,96,118,120,136,161,164,181,184,188,198,236\n8,32,41\n14,30,33,64,356\n138,143,149,172,184,188,198\n142,182,198,204\n11,48,190,205,211\n13,344,346\n181,279,297\n181\n69,177\n66,82,142,178\n76,78,141,169\n306,316\n295\n57,70,72,170\n32,56\n48,50,61,180\n60,94\n47,66\n286\n58,62,180\n180\n180\n1,187\n169,188,192,212,358\n15,17,156,184,206,208\n26,167,172,180,199\n0,3,37,180\n46,61,66,156,165,177,180\n142,155\n119,129,138,178\n180\n146,178,180\n76,92,127,131,180\n100,139,157,180\n22,26,33,74,89,102,306,321\n58,79,87,135,148\n81,103,134\n151,168\n43\n85,149,161\n150\n32,44,82,174,180\n0,75,147\n83,131,145,151,173,179\n96,103,107,117,148,180\n72,82,84,88,131,140,148,150,158,160,162,170,180\n106,150,163,180\n73,148,167\n69,129,154,171\n42,72,175\n44\n23,57,74,77,97,106,109,180\n80,152,169,180\n1,3,14,16,124\n59,180\n9,52,172,331,344\n4,17,54,166,312,340\n17,21,34,58,141,310,312,330,347\n19,28,33,36,57,60,64,312,336,341,353\n78,160\n78,131,161\n68,125,155\n68,102,117,131,152\n10,39,74,291,323,347,359\n18,43,346\n6,13,19,24,44,56,80,174,311,330,359\n15,46,53,162,180,313,357\n4,39,66,70,298\n1,40,65,75\n12,29,56,76,86\n46,64,141,163,180\n57,83,179\n44,64,180\n62,180\n39,54,56,68,72,169\n52,174,299\n56,175,194,287,300\n0,21,36\n0,180\n0,180\n180\n0,52,180\n0,180\n1,6,48,73,172,176,180\n0\n0,27,48\n45,75,168\n22,61,180\n0,11,35,117,133,157,159,173\n0,36,144,180\n21,46,54,63,93,115,180\n0,14,33,61,66,73\n212,214,235,237,255\n226,252\n0,9,15,18\n0,6,13,33\n46,62,180\n67,166,168\n55,57,72,75,80,164\n26,44\n56,73,163,173,177\n53,59,170,175\n58,143,163,179\n0,180\n0,54,139,180\n27,105,129,146,163\n48,103,105,130,180\n0\n0,25,31,180\n0,180\n0,3,8,20,23,71,91\n17,55,130,132,139,147,153,180\n0,24,34\n4,7,60,97,137,155,172\n0,177,180\n0,8,31,59,154,164,167,180\n0,7,28,34\n0,18,176\n32,66\n2\n0,179\n146,149,156,169\n180\n73,86,101\n0\n0,180\n0,6,180\n0,163,180\n0,6,150,169,180\n0,20,23,151,180\n32,64,67,95,119,122,180\n63,95,180\n51,92,123\n56,60,74,180\n0,55\n58,174,176\n74,178\n64,180\n65,170,185,201,290,312\n62,67,200,301,306,311\n68,302,320,328\n297\n191,299\n57,71,184,194,301\n60,75,176,193,288,308\n52,282,307,316\n53,60,84,297\n69,71,210,262,304,321\n57,71,300\n38,66,68,85,131,146,149,176,206,220\n49,54,56,63,68,74,76,123,128,133,140,169,180,186,224\n60,65,71,160,177,211\n173,202\n165,189,194,202\n161,194\n167,171,188,193\n164,166,171,179,191,208\n0,14,45,56,81\n31,44,55,66,89\n180\n163,180\n180\n0,4,12,18,46,66,90\n9,13,21,29,34,39,69,78,82\n0\n180\n180\n80,88,91,98,108,114,119,138\n180\n60,303\n0,107,111,118,127,132,141,143\n301,324\n59,174,299\n61,174,299\n24,38,96,150\n270\n270\n38,51,54,319,322\n30,48,182,294\n181\n181\n303,321,342\n299,314\n299,315\n49,61,68\n47,76\n17,40,327\n38,328,340,347\n0\n0,29,153,177,180\n38,41,62,90\n0,35,40,50,90\n49,56,60,64,72,75,98,119,154,160,173,180\n1,34,38,78,87,90\n101,126\n0,8,59,79\n118,180\n21,27,29,87,97,108,162,170,172,174,177\n0,44,79,96,139,180\n27\n51,59,70,90\n154,181,209,227,237\n339\n340,349,351\n0,31,42,47,51,59\n0,47\n0\n0\n0\n180\n0\n0,19\n0,5\n178,180\n0,37\n0,7,12\n0,18,62\n0,28\n6,38\n53,180\n180\n53\n55\n0\n0,6,8,18,38,71,80,83,90\n51,87,90\n0,2,31,82\n5,14,17,26,57,62,68,75,121,127,130,142,157,165\n56,60,71,82,90\n49,69\n34,55,90\n51,72,104,119\n136,180\n0,34\n0\n0,28,30,35,39,41,43,45,100,131,133,135,180\n0,22,37,58,64,67,90\n0,35,90\n51,69,102,113,127,179\n56,75\n0,30,32\n180\n37\n27,58,64,79,82,108,137\n0,23,125,136,142,156,167,172,180\n126,135,152,155,160,165,180\n337\n2,22,26,45,48,51,61,64,79,90\n0,26,104,131,148,167,176\n160,191,250\n160,167,171,203,207,217,221,244\n139,161,164,176,180\n0\n85,90\n35,53,63,80\n77\n302,305,327,333\n0,20,26\n32,51,70,78,87,103,109,113,115,122,131,133,141,143,160,164\n0,71,90\n7,35\n0,29,48,67,89\n0,8,10\n0,8,28,43,77,98,127,141,164,170,180\n34,37,57,63,67,74,90\n0,2,11,43,90\n64,75,80,114\n90\n0,2,37\n0,59,93,120,135,139\n0,6,11,180\n179\n0,2,6,28,155,180\n0,129,137,151,173,180\n2,25,34,36,180\n180\n51,305\n111,275,301,305,320,336\n168,204\n304\n305\n18,308,312,318,322,325\n4,38,42,50,53,280,310,314,323,327\n293,321,323,331,337,354\n286,288,306,325,330\n117,126,133,160\n112,140,165,206\n0,10,16,18,26,36,77,126,139,171,174,177\n20,36,77,96,99,156,180\n57,180\n180\n73,124,177\n66,84,125,173,182\n63\n0,39\n0,45,70\n0,166,169,180\n19,54\n196,298\n314\n74,308,312,315,328,335\n1,3,24,35,44,53,90\n44,58,61,75,97,99,102,123,156,159,175,180\n0,166,180\n33,126,145,159,180\n0,180\n0,180\n180\n251,304\n24\n0\n0,20\n0,15,18,33\n14,46,81,105,112,123,145,180\n37,43,63,87,90\n39,90\n0,16,21,47\n0,45,90\n0\n90\n0,2,7,9,30,47,62\n0,32,34,38,51\n28,48\n58,180\n180\n0,12,37,40,71,171,180\n0,3\n181\n87,251,258,272\n54,79,82,98,106,111,130\n163,166,180\n180\n126,319,325,329,333\n125,137,146,300,305,312,319,331,335\n155,168,180\n61,90,102\n0\n71,262,289\n69,292\n0,43,64,90\n14,36\n0,14,17,29,48\n2,8,10,17,26\n0\n0\n0\n2,8,13,180\n1,14,33,54\n180\n12,113,122,142,158,180\n0\n19,191,217,287,310,340\n0,33\n180\n1,30,180\n162,180\n0\n180\n0\n24\n15,47,49,76,127\n21,181,200,206,210\n29,200,203,231\n59,90\n184,304\n179,302\n0,29\n154,180\n180\n177,180\n0\n0,24,120,136,168\n0,37,147,180\n35,96,109,126,151,157,180\n180\n0\n180\n0,169\n1,5,180\n0,16,180\n0,180\n0,33,67,180\n0,180\n0,23,55,132,151,180\n0,180\n0,145,180\n0,180\n0,143,151,180\n3,10,19,21,30,166\n45,59,86,89,137,158,172,177,191,194,232,248,266,319\n10,43,78,103,151,153,176,245,257,266,287,326,331,338\n0,20\n1,21,167,173,180\n0,154,180\n24,44,57,84\n97\n0\n2\n64,80,119\n56\n2,64,78,135,180\n49\n71,85,111,115,145,180\n45\n47,54,61,180\n49,130\n56,63,174,185,302,342\n49,69,173,295\n61\n72,82,104\n180\n286\n188,277\n82,160,167,180,294,296\n75,95,132,156,162,168\n177,179\n129,150,180\n11,147,175,180\n0,180\n180\n0\n180\n2,4,180\n180\n6,161,180\n0,170\n0\n180\n179\n180\n180\n0\n151,176,180\n59,75,97,117,164,192,220,251,264\n74,104,237\n50,54,61,77,89,96,211\n180\n0,79,107,126,136,161,180\n0\n146,173,178\n180\n0,49,76,87\n0,122,143,173,178,180\n0\n0\n180\n0,7,144,171,180\n180\n0,180\n1,180\n0,25,127,157\n0,2,20,46,67,97,100\n0\n0\n148,175,179\n9,39,51,54,136,139,159,178\n0,75,107,180\n0\n0\n137,150,153,180\n42,44,46,113,132,162,168,171,196\n42,46,74,107,137,166,168,201,204\n30,49,73,91,119,176,181,190,199,206\n47,70,89,116,204\n4,17,323,328,341\n7,245,326,341\n107,115,150,176,181,199,219,224\n109,116,146,192\n30,121,147,166,194,204,313,317,321,324,332,335,356\n31,57,60,136,150,156,162,203,314,327\n14,180\n0,162,165,180\n8,163,180\n167,186\n155,188\n0,30,34,58\n0,84,180\n0\n180\n136,158,180\n0,180\n0\n180\n2,30\n0\n139,180\n2,7,25\n180\n180\n65,157,162,173,180\n0,21\n39,133\n0\n0\n20,26,34\n22,37,322\n180\n159,173,180\n0\n0\n180\n12,35,37,180\n13,16,19,24,40,55\n68,85,135,157,160,169\n0,58,73,179\n63,180\n0\n0,113,115,117,147\n30,61,180\n180\n49,51,57\n1,56\n57,178\n44,78\n65,171,180\n62\n61\n5,9,51,64,300,316\n0\n13,18,38,40,78,131,136,152,178,180\n45,67,89\n0,13,44,89\n71,111,118,120,145\n50,54,71,90\n0,46\n43,68,90\n163,166\n0,16,33\n155\n132,157\n0,36,56,66,123,126,138,163\n100\n0,2,146,171,176,180\n19,58,72,92,117,125,128,156,180\n0\n53\n0,72\n83,101,110\n12,34,46,49,52,67,70,84,90\n0\n47,137,180\n1,4,67,90\n1,29,70,87,90\n174\n139,168,180\n0,36\n0\n13\n143,180\n17,47,66,88\n60,68,78,98,106,110,113,150\n0,21,44,48,66,90\n41,72,114,180\n140,178\n137,164,177\n0,18,20,30\n0,20\n0\n2,24,51,144,180\n73\n2,37,70,90\n63,66,96,99,114,180\n85,90\n2,16\n0,12,25,86,180\n0\n162,180\n157,180\n179\n5,24,33\n50,70,90,105,145\n0,3\n69,154,173,180\n0,58,91,107,142,157,162,168\n8,125,138,151,161,172,180\n0\n0,37,180\n7,118,135,171\n0\n0\n125,234\n143,168,189,208,228,236\n33,69,90\n22,38,57,82,126,144,165\n0,4,50,89\n60,62,87,90,92,97,115,129,133\n132,141,152,161,173,180\n155\n0\n1\n0,21,103,128,162,180\n0,49,71,81,90\n0,35\n44,68,111,135,167,170,180\n64,67,71\n39\n50,58,63,67,87,96,128\n54,90\n52,71,98,118\n137,145,174,176\n138,143,163,180\n0,32\n0,20\n0,10,68,73,79,96,139,178,180\n23,139,159\n0,178,180\n25,47,53,60,135,180\n0\n0,141,155,157,180\n0,21,133\n118,121,138\n166,180\n150\n0,35,132\n65,131\n45,47,122\n44,99,101,119,162\n7,25,32,41,44\n13,18,21,42,44\n25,43,105,129,218,238\n27,66,73,75,77,79,107,217,236\n21,48,55,57,79,85\n53,57\n39,89,109\n36,70,101,104\n13\n23,45\n14,17,43\n29,34,46,76,80\n111,128,147,149,152,173,197,199,209,238,243,245\n110,148,172,197,251,253\n146,160,169,173,175,199\n160,180,194\n3,8,21,41\n1,22,32,40\n259,290,324\n21,282,302,308,322\n243,249,255,260,279,308,325,332,334\n256,275,318,339\n37,44,49,57,86,97,99,107,131,153\n0,14,34,50,70,83,106,108,111,114,133,138,142,153,157,178\n27,44,48,85,93,105,113,214,220,261\n28,55,93,106,114,116,140,219,221\n29,56,77\n33,35,41,48,82\n108,152,168,176,196,218,241\n106,164,200,203,206,237\n18,35\n17,42,356\n13,130,133,238,352\n5,11,17,110,131,225,232,243\n203,209,212,222,229,267\n8,29,72,292,328\n6,17,27\n13,33,342,352\n8,30,33,87,124,145,235,272\n20\n17,343\n20,61,211,236\n19,30,231,233,250\n24,59,106\n55,303\n58,305\n149,178\n146,152,158,180\n60,185,293\n61,180,182,291\n80,180\n80,145,155,181\n141,182\n56,303\n57,303\n177,303\n186\n187\n169,189\n55,57,77\n2,22,36,58\n34,57,306,332,342\n7,53,70,307,324,334,344\n71,122,181\n73,163,180\n50,190,303\n64,82,192,306\n57,59,61\n199,204,207,210,216,297\n71,177\n266,306\n47,298,322,345\n46,52,58,313,345\n0,54,305,326,328\n1,52,303,349\n186,281\n60,180,304\n63,150,179,243,304\n65,165,183,306\n61,81,157,165,169,171\n309\n63,188,296\n64,186,244,295\n43\n63,180\n62,67,292,298,305\n64,149,182,309\n62,184,297,312\n179\n177\n3,6,124,126,138\n13,25\n105,112,135,137\n111,136\n137\n61,180\n58,169\n180\n180\n53\n25,52\n61,180\n52\n71,180,191\n42,65,183,305\n53,81\n58\n68,134,173\n67,94,101,175\n65,137,193\n68,135,172,185,188\n189,201,291,298\n187,190,196,243,293\n61,170,299\n55,180,301\n49,309\n34,44,53,309,312\n68,169\n70,170\n14,19,27,30,55,144,152,176,180\n0,7,14,21,66,149,180\n134,140,154,172,180\n13,28,64,92,151,172,177,180\n123,163\n161,179,182\n38,64,93,99,105,144,158,181,303,331\n157,180\n0,19,32,50,168,177,180\n0,27,58,88,147,178,180\n109,137,150,152,166,179\n0,37,44,51\n41,180\n142,153,155,159,176,189\n128,148,162,173,183,188,199,218\n132,170\n122,128,134,150,172,200,279,299\n35,96,129,169,193,293,311\n73,293,329,344\n122,164\n52,66,85,97,179\n62,169\n57,180\n67,75,87,180\n180\n59\n1,19,37,39,41,74\n30,48\n37,67,70,180\n63,180\n0\n50,52,180\n42,59\n58,68,73,164\n47,53,62,76,166\n25,58,123,171\n41,61,180\n12,31,33,35,49\n0,3,7,10,17,44,78\n70,180\n44,310,321,324\n305\n1,33\n0,44,78,90\n90\n0,49,72,90\n48,74,76,86,91,102,120,135\n90\n56,90\n61,84\n58,90\n4,14,39\n132,160,179\n0\n0,56,88,90\n130,180\n20,45,70\n87\n0,21,44\n90\n0,3,57\n2,12,48,71,73,77,87\n55,93,110,115,126\n59,89\n90\n0,65\n0,9,36,43,68,95,100,105,116\n111,136,158,180\n7,25,33,35,37,48,67\n1,13,64,83,90\n12,38,43,45,72,93,104\n66,84,90\n0,7,49,52,78\n136,151,180\n0,3,6,36,40,51,66,90\n38,84,90\n0,22,137,175\n53,65,83,90\n0,3,5\n58,75\n65,90\n110,113,132,155,180\n11,13,40\n90,93,110,130\n12\n11,84,338\n142,164,187,204,240,249\n140,162,201,203,244\n1,69,342\n6,340\n28,351\n351\n144,215,248\n144,165,198,218,246,280\n157,193,207,238\n156,190,208\n45,58,77,84,90\n49,70\n0,57,59,66,86,89\n0,47,50,57,59,66,78\n14,125,139,163\n61\n0\n117,147,175,180\n101,158,178,180\n0\n0,27\n0,3,19,23,29,32,45,48,71,90\n1,21,35,51,57,70,74,90\n0,3,10,25\n0,38\n0,17,34\n11,66,84,124,177,180\n9\n0\n8,39,64,88,91,122,142\n3,26,73,79,86,130,155\n0,23\n0,29\n95,123,163,180\n0,18\n0,149,152,178\n0\n78,180\n12,35,51\n0\n0\n0,29,35,41,157,162,180\n180\n55,71,180\n29,33,58,80\n70,77,179\n13,18,22,26,28,68\n0,41,180\n180\n304\n300\n0,4,11,15,60,311,334\n27,57,293,310,356\n9,56,308,310\n12,15,58,309\n48,310\n48,314\n152,274\n120,156,162,164,166\n60,282,296\n63,296\n70\n80,100,131,171\n77,95,131,150,155,161\n57,278,294\n76,120,170,189,195\n75,169,187\n172,185,194,213\n182\n160,185\n20,49,63,160,169,175,178,186,291\n15,46,54,60,166,181,281,294,312\n2,5,295,326,343,345,355\n0,86,93,101,118,143,179\n95,130\n117,137\n187,206\n192,207\n291,306\n43,53,64,295,310\n47,63,172,299\n115,135,153,156,160,163,166,226,230,237,241,270,274,285\n91,113,115,120,129,132,144,194,237,264\n163,172,178,235,263,271,275,279,285\n178,208,262,278,284,296\n61,310,351,358\n27,45,55,74,314,335\n308,326\n44,184,297\n44,185,297\n98,116\n104,111,118,144\n182,202\n184\n62,174,307\n163,174,176,309\n19,21,35,41,56,91,94,150,166\n6,12,24,50,71,87,158\n264,267,271,282,312\n274,276\n42,67,314,337,358\n31,61,315,357,359\n171,279\n185,255,274\n3,318,333,346\n122,141,143,149\n110,128,149,193,209\n12,69,314,326,330,335,348,355\n313,325,355\n79,107,287\n109,113,119,127,149,168\n104,106,116,119,122,144\n178,191,223,239,244,250,266,284\n204,251,281,284\n51,307,325,342\n19,322,340,344,352\n297,315,334\n44,276,304,320,337,353\n0,7,63,93,129,131,157,160,180\n0,24,39,87,132,180\n2,39\n41,64,115,132,138,147,153,171\n90\n90\n66,72,90\n91\n64,179\n180\n52\n50,66,70,90\n76,78\n168\n30,54\n38,58\n62,80,83,87,90\n4\n0,11,36\n0,42,82\n0,14,39,41,45,56,90\n53,90\n5,56,92,104,109,138\n55,73,109,126,133\n34,36,69,82,85,89,102,107,230\n24,40,51,54,56,71,86,125,226,243\n124,139,168,195,222,225,243\n165,183,202,225\n45,62\n7,57,70,72,74,90\n21,359\n23\n7,55,304,351\n60,175,309,319\n62,172,191,312,319\n12\n62,177,180\n61,63,170,180\n180\n180\n52\n54\n54\n69,169\n71,97,169\n66,180\n49\n47\n73\n61,90\n67,69,73,78,80,86\n24,42\n44,98,123\n71,73,90\n90\n60,73\n82,90\n55,58,90\n90\n90\n43,49,60,71,78,83,89,95,104,130,161\n80,83,87,90\n53,90\n0,29,43,90\n0,148,180\n66,180\n52,180\n56,299\n62,297\n184\n12,15,57,60,302\n59,180\n180\n180\n12,54\n59,180\n45\n0,132,137,148,151,161,168,172,176,180\n0,139,159,180\n0\n0,175,180\n0,4,6,12,180\n0,20,22,24,137,142,156,171,180\n0,14,17,33\n0\n2,18,36\n0,136\n180\n180\n180\n1\n89\n92\n0\n0\n46,65,90\n90,98,101,256,264,273\n8,180\n0,179\n17,22,38,55,84\n59,89\n84,88\n0\n0,18\n0\n0,36,69\n4,19,166,188\n5,188\n0,26,32,36,117,180\n21,64,90\n89\n0,19,54\n0,7,72,87,90\n21,29,37,60,70\n52,180\n153,174,180\n0\n313,336\n311\n0,8,13,23,34,42,44,67,73,81,96,99,120,146,151,153\n0,4,8,25,37,46,69\n0\n12,18,24,89,121,152\n1,8,41,69,72,85,111,140,151,174\n70,89\n23,50,81,121,124\n32,60,75,77,83,94,120\n164,181,208\n0,28,311\n359\n0,46,318\n0,52,54,90\n72,89\n0,60,62,90\n90\n25,50,90\n74,92\n88\n77,79,89,96,101,126\n65,96,120\n146,171,178\n1,181\n3,160,163,179\n0,180\n90\n0\n0,22,93,180\n0\n0,35\n0\n0,19,33,51,134,148,180\n53,74,117,123,140\n2,179\n207\n60\n31,33,65,75,94,100,107,276,305,333\n0,17,35,58,61,65,68,71,88,165,212,269,308,316,325,344\n38,53,79\n0\n0\n178\n0\n180\n0,11,151\n0\n0,35,60,65,68\n0,14,18,22,26,84,90\n0,7,19,33\n26,52,288,292,301,319,333\n67\n67\n30,57,88\n0,8,16,24,53,106\n0\n0,128,134\n0,2,6,10,13,76,99,112,159\n89,160,180\n1,33,38\n0,17,102,110,113,175\n0\n0,42,152,180\n8,35,56,90\n8\n0,180\n0,24,78,84,99,102,105,117,134,173\n6,59,63,79,116,136\n5,39,41,48,65,72,85,111,125\n111,233,258,270,288\n0\n73,76,105\n99,102,142\n57,77,139,172,179\n32,40,44,49,57,79,165\n90\n88\n151\n30,52,70\n91,93\n70,88,90\n93,115,138\n43\n121,130,152\n148\n114,133,140,143,171\n0,10,180\n0,3,17,29,172\n1,27\n108,125,134,136,150,183,288\n111,131,142,149,156,158,165,168\n77,98,121,145,283\n106,136,148\n103,138,152,186,283\n95,114,140,149,159\n98,126,143,188\n98,101,111,134,154,171\n0,24,26,41,48,67,126,165\n22,46,81,178\n0,24,30,32\n90\n85\n180\n0,3,16\n18\n2,180\n12,27,174\n2,54,65,95,121,163,180\n6,28,46,63,88,91,117,136,162,180\n0,8,10,19,107,109,137,165\n0,18,42,62,76\n90\n0,18,36,40,90\n54,74,89\n69,107,110\n47,68,106,109\n11,42,104,153,180\n0,21,180\n99,103,128,290,333\n175,355\n179,352\n56,66,180\n52,62,180\n17,21,50,57,59,73,129,159,179\n26,46,78,102,109,122,124,146,166\n52,81,170\n54,168,302\n45,63,151,170,180\n63,180\n174,177,180\n11,14,27,52,66,74,77,108,124,157,171\n42,51,63,172,180\n65,183,308,310\n49,66,172,177,183,289,297,300,316\n51,76,78,90\n82,88,90\n2,45,47\n110\n80,90\n21,35\n0,29,31,46,56,71\n33,135,175\n24,151,176,180\n61,64,180\n43,57,75\n60,180\n29,47,63,118,143,159\n54,56,174,180\n1,46,62,92,115,149,152,156,165,170,180\n0,6,9,14,180\n60,180\n0,180\n0,8,12,39,43,52,73,78,81,93,122,128,142,146,151,177,180\n0,180\n0,28,39,47,49,57,80,110,112,135,151,156,180\n0,43,94,112\n0,180\n2,74,81,93,114\n0,2,8,145,149,176,180\n0,180\n0,180\n0,144,180\n0,20,36,48,81,145,180\n0\n0,28,127,154,179\n10,14,37,62,70,82,85,142,155,180\n0\n0\n9,30,35,86,100,105,140,173,194,216,258\n18,28,79,95,111,121,141,188,195,208,220,258\n29,34,55,59,63,67,71,128,189,198,220\n10,26,29,39,82,182\n281,318,338,357\n133,137,141,148,160,170,208,210\n138,162,185,209\n18,63,132,196,213,228,337,357\n18,51,347,355,358\n0,3\n180\n178\n15,170\n0\n0,163,171,177\n0\n0,163,165\n90,119,177\n75,94,134,145,178\n2,23,180\n0,40,97,158,160,169,171,180\n0\n12,14,17,22,180\n0\n0\n7,12,27,30,62,95,114,125,184,205,208\n22,27,33,54,61,71,93,127,185,188,212\n25,331,338,344,354,358\n18,243,265,317,352\n117,147,171,198\n16,30,32,89,190,194\n15,28,30,33,185,195,197\n0,180\n75,176\n177\n35,67,78,85,157\n54,178\n0,10,20\n0\n3,7,12,17,176,180\n0,153,180\n180\n0,180\n172\n1,7,9,15,170,180\n0,3,29,53,74\n0\n0,38,180\n0\n0,2,180\n7,155,174,178,180\n13,31,171,198,214\n2,5,17,198,356\n0\n0,33,145,165,180\n0,61,90\n0,16,38,68,86,99,131,180\n0,2,23,179\n0,23,30,180\n0,180\n0,13,141,163,179\n0,179\n0,44,47,50,59,76,85,92,127,133,143,146,180\n0,23,26,60,65,80,140,151,163,180\n100,126,158,279,288,301,319,335,339,344,353\n104,130,132,138,141,147,316,338,341,348,352\n0,180\n164,180\n1,21,145,190\n7,144,172,204,351\n20,23,353,358\n0,174,180\n1,58,77,88,96,132,145,153,177,180\n0,6,173,180\n0,180\n0,180\n1,21,171,178,180\n0,43,141,171\n17,28,158,206,338\n7,23,30,104,135,137,150,185,187,192,194,213,325,329\n0\n5,51,61,182,317,341\n4,8,12,54,58,179,298,318,342,345\n33,64,105,184,289,328\n3,25,38,44,70,315\n0,61,180\n52,68,86\n90,93\n61,84,115\n80\n78\n92,118\n78,97\n0,166,174\n0,20\n90\n90\n83,99,105,139,180\n0,3,120\n0,13,18,38,66\n0,15\n64,81,94\n87,122\n64\n66\n62,78\n51,70,72\n63\n68,180\n82,150,180\n55\n58,180\n75,87,106\n197,210,213,227,234,271\n207,268,283,290\n1,180\n68\n73\n150,179\n0\n144,150,156,160,168,173,177,180\n105,111,119,125,127,129,138,174,180\n0\n4,180\n0\n0\n0\n15,130,132,156,174,178\n97,117,119\n154,178\n150,173,176\n0\n0\n0\n180\n17,19,41,58,70,78,83,86,92,108,114,123,139,169\n12,65,70,154\n0\n0\n0,180\n0,180\n1,36\n0\n0\n1,176,180\n0,2,18,154,156,163,180\n1,16\n26,32,35,40,118\n0\n0\n12,22,25,119,140,178,212,221\n10,18,25,52,58,98,113,115,133\n15,19,21,23,32,98,100,102,112\n0,120,124,141,144,180\n0,177\n0,180\n0,180\n0,180\n0,45,125,180\n43,103,190,213,218,264\n286\n64,183,293\n69,186,292\n181\n181\n53,303\n48,64,282,304,330\n69,72,174\n75,175\n59,170,299\n69,161\n71,172\n60,180,304\n58,181,307\n65,84,174,303,320,324\n184\n177,191\n189,192,297\n181,200,267,297\n42,48,66,176\n67,170\n63,65,82,174,189,307\n63\n59,63,66,76,185,302\n59,291,301\n72,180,204,207\n70,180,192\n35,40,57,311\n54,68,75,83,186,189,202,204,206,208,229,247,294,298,303\n64,67,69,176,178,209,272,279,287,297,308\n0\n0,2,137,144,147,174,179\n0\n1\n0\n180\n166\n180\n0,180\n0,139,149,178\n0\n0\n180\n179\n3,7,172\n0,9,38\n3\n0\n180\n0,31\n85,129,147,180\n3\n180\n159,180\n0,154,174,180\n0\n180\n0,17\n180\n0,180\n0,24,50,52\n0,25\n180\n152,171,180\n23\n180\n0,3,6\n3,7,75\n180\n17,51,53,58,62,84,88,97\n18,58\n70,90,94,103,112,152,155\n66,244\n11,26,41,47,63,89,110,113,122,226,246,274\n48,68,82,85,98,269,318\n62,87\n55,59,61,63,66,87,93\n83,89,92,102,129,146\n16,347,355\n10,15,19,348\n58,183,306\n69,179,304\n295\n64,177\n64,161,176\n196,291,294,298,302\n189,203,297\n0,26,90\n0,41,57,63,79,84,124,126,180\n6,13,49,83,89\n0\n180\n0,33,40,44,53,79,88,112,129,180\n0,46,102,135\n0\n0,29\n180\n180\n180\n1,70,73,96,111,116\n0,21,25,28,110,124,129,134\n137,160,180\n129,180\n2,7,162,165,180\n0,6,180\n4,7,42,54,75,80,93,128,134,180\n0\n180\n145,180\n178,180\n82,92,108,124,149,179\n0,49\n90,118,120,144,151,166\n256,291,323,325\n294,304,308,310,328\n7,29,42,46,51,54,88,344\n5,14,29,58,85\n112,152,198,218,253\n111,121,154,178,201,222,255\n144,163,199,254\n26,153,259,270,322,341,348\n261,315,333\n144,147,195,213\n147,165,195,198,231,272\n0\n0,28,33,118,140\n180\n0\n0,124,130,144,152,154,162,180\n4,61,71,75,78\n0\n0\n1,160,180\n31,55,62,70,101,165,180\n23,28,40,60,164,166\n3,23,41,51,86,109,124,127\n6,10,12,25,60,73,79,95,121,157\n52,92,241,251,262,300,339,345,354\n47,73,101,122\n69,90,93\n1,19,36,58,64\n0\n7,13,55,117,120,141,160\n22,168\n26,43,137,178\n39,222\n36,213\n209\n208,230\n180\n145,180\n0,3,63,170\n27,54,60,64\n64,179\n65,140,169\n65,156,171\n186,209,303\n54,56,180,296\n62,187,299\n62,180\n56\n62,90,188,280,284,293,314\n64,170\n65,173\n33,62,180\n41,49,62,65,79\n249,288,290\n197,199,271,292\n199,286\n286\n214,250,260\n204,222,253,266\n0\n7,36\n33\n65,77,90\n56,64,171\n63,80\n62,137\n22\n22,32,61\n38,46,50,306\n173,296\n60,68,75,312\n64\n60,63,78\n2,174\n176,186,357\n180\n180\n0,22\n16,34,52,229\n90\n35,57,66,70,72\n54,56,180\n0,134,137,152,156,167\n10,35\n359\n0\n16\n22,24,26,36,46,56,61,67\n12,178\n22,43,61\n26,57\n1,157\n0,44\n0,8,15,137,153\n0,18,21\n1,5\n12\n13,41\n62,83\n217,239,266,269,277,279,298,312\n0\n0,180\n0,18,42,47,49,73,137,162,179\n0\n0\n0,6,33,45,48,100,102,108,155,158\n153,170,172,180\n180\n0,13,173\n15,49,58,61,96,103\n0\n0\n46,169,191,193,205\n174,179\n24,60,83,180\n180\n42,62,65\n0\n0\n61,297,317,320\n59,65,305\n12,42,44\n0,16,18,20,46\n35,58,60,72,93,154,160,167\n37\n0\n0,3,18,26\n0,83,112,180\n15,166\n0,180\n9,12,18,28,34,193,358\n61,65,97,170,180\n49,76,80\n53,80,82,98,167,180\n51\n35\n66,77\n49,57,80\n14,31,44,62,71,81\n43,70,184,304,308,317\n45,66,138,181,310,339\n75,98,100,154,168\n76,105,163\n18,40,66,309,354\n20,44,60,189,292,311,329\n3,8,17,29,36,47,179\n38,48,180\n54,66,68,180\n68,172,175\n70,131,180\n0,5,9,46\n28,38,47,64,153,184,190,201,318\n26,41,44,47,60,153,172,195,206,210,213,318\n60,180\n0,6,152,155,180\n149,180\n9,13,27,42,90,125,127,167,174,176,180\n0,43,180\n180\n121,151,180\n67,93,124,126,141,158\n141,180\n33\n12,33\n0\n0,180\n16,150,180\n0,24,32,159,163,180\n137,180\n36,95,98,118,233\n2\n0\n6\n0,40,59\n155,180\n0\n152,180\n0\n75,79,88,90\n0\n0,14,24,56\n0\n0,30,80,83,90\n1,38\n62,71,78,114,138,160\n85,101,120\n82,84,102,118\n91,93,96,98,101,114,268,296,299\n113,238,243,249,267,279,294,300\n75,91,93,101,109,133,140,147,283,288,300\n86,99,112,153,160,291,311\n91,134,275,303\n87,117,249,274,284,305\n0\n0,19,42,61,80\n0,22\n6,16\n33\n0,2\n10\n0,180\n33,48,67,128,180\n0,180\n0,26,40,154,180\n0,180\n0\n49,76,107,180\n134,154\n75,180\n0,16,156,163,180\n0,180\n0,19,142,163,172,180\n0,180\n0,161,180\n180\n0,144,149,151,157,180\n180\n50,55,62,70,167,180\n58,75,173\n49\n0,9,23,45\n49,67,179\n48,164\n0,6,50\n60,66,161,168,180\n0\n0,123,180\n1,31,56,88\n0,27\n0,40,124,180\n3,63\n147,180\n180\n0,7\n0\n0,45,57,180\n0,50,72,180\n29,41,143,180\n180\n0,7,58,131,149,180\n180\n160,173,180\n180\n152,179\n157,162,180\n179\n180\n124,163,180\n0,30,34\n0,36\n0\n0\n0\n0,29\n0\n0,33\n46,135,162,180\n0,3,27,51,180\n68,109,143,165,172,176,180\n180\n180\n0,24\n0,32\n179\n0,13,52,180\n177,180\n0,2,39,44,48,148,176\n0,33,43\n0,41,61,120,136\n54,180\n53\n0,52\n0,23,34\n180\n180\n125,129,147,180\n0,55,179\n170\n54\n158,162,180\n157,180\n53,56,128,180\n72,164,318\n73,127,148,169,276,311\n51,58,75,79,96,151,181,342\n63,96,135\n278,301\n300\n312\n312\n258,303,312,343\n276,298\n177,235,289\n177,229,287\n188,204,217,219,289\n187,215,219,293\n179,212,232,272\n177,197,199,230,273,288,290\n55,308\n55,307\n2,26,51,57,324\n21,52,311,323\n5,54,83,315,319\n11,55,90,311,331,350\n52,310\n55,311\n25,46,57,322,336\n58,78\n56,94,308\n3,60,316\n61,322\n1,10,14,18,61\n5,55,323,349,354\n52,55,72,164,178\n61,71,73,146,177,313\n314\n191,292,297,303\n168,190,282,299\n17,19,48,284,312,315\n48,81,283,302,319,358\n34,45\n45,323\n31,46,323\n68,172,284,289,293,299\n65,97,99,173,293,296\n64,66,79,158,180\n299\n298\n297,344\n155,190,287\n158,180,215,285\n184,202,278\n54,312\n55,308\n47,59,315,343\n54,316,350\n64,176\n63,174\n163,290,305,307\n49,313\n47,313\n67,149,170,180,183\n69,155,161,169,171\n174,178,231,282\n145,180,228,286,288,298\n176,232\n176,229,231\n47,310\n49,310\n40,48,314\n45,47\n0,28,107\n15,59,93\n0,61,95,97,103\n0,51,96\n99,143\n64,86,122\n0,15,42,65\n20\n0,18,46,52,60\n14,66\n18,37,64\n12,32,55\n126,167,180\n93,127,159,169,172,178\n129\n125,155,173,178,180\n128,158\n125,152,178,180\n98,129,151,180\n123,143,146,150\n0,26,64,75,94,113,143\n41,51,57,97,144\n1,37\n0,103,147\n98,113\n21,45,68\n22\n13,33,43,51,67\n29,32\n98,122,143,157,167,180\n23,67,85,88,116,120,129\n0,20,61,63,103,125,180\n0,23,25,31,108\n25,74,77,82\n78,107,130,137,180\n87\n18\n19\n15,45\n14,57,59\n128,156\n162\n130,163,180\n1,15,21,51,67,103,112\n65,68,71,74,76,93,117,145\n0,119\n0,16,52,89,118\n0,177\n180\n180\n0,100,122,128,137\n7,37\n9,120,339\n117,334,355\n80,107\n92,111,124,126,146,179\n283,303\n285,303\n305\n289,304\n15,49,65,298,328,347\n19,50,68,296,328,348\n6,13,34,66,315,333,349,355,357\n1,6,17,66,317,327\n23,42,334,351\n2,14,16,28,36,45,49,326,353\n18,41,49,69,347\n18,47,342\n3,18,68,332\n1,10,12,30,37,341,354\n342\n183,202,216,248,278,280\n180,208,229,231,251,253,257,289\n218,221,252\n179,209,241,259\n117,225,353\n121,219,347,355,357\n114,140\n107,109,128,146\n302\n302\n0,2,17,36,40,46,337,347,351\n17,48,54,330,334,350\n16,43,48,333,346\n15,23,46,338\n9,116\n116\n162,194,244,262\n182,219,225,233,239,248,263\n328,343,349,358\n328,353\n0,90\n90\n0,96\n0,83\n90\n0,90\n14,30,66\n0,17,69\n111,163\n112,149,180\n0,11,29,42,82,90\n0,16,58,89\n62,90\n0,44,66\n113,131,136,148,180\n0\n180\n0,40,180\n79,97,263,281\n1\n0,180\n40,45,64\n15,38,170\n18,39,61,79,90\n1,41,76,90\n3,11,41,65,85,100\n42,49,79\n142\n86,103\n107\n17,43,62,127\n84,90\n0,58,93,134\n0,59,72,77,180\n138,165,176,180\n0,23,30,33,56,59,86,97\n138,180\n0,3,6,30,72,104,120,144,180\n1,26,50,99\n36,76,106\n15,74,90,92,137\n126,149,157,171\n63,302\n63,305\n60\n61\n0,89\n0,3,20,77,90\n0,4,27,29,90\n62,90\n29,47\n34,90\n63,90\n0,11,80\n11,13,42,46,52,101\n90\n42,81,90\n87\n106,143\n24,44,55,57\n0,21,102\n57,180\n17,20,25,40\n15,61,299\n44,63,295,349\n180\n180\n0,27,29,37,178,180\n0,180\n0\n0\n71,190,297\n189,297\n70,185,271,289\n59,292\n48,71,269,295,312\n71,178,200\n73,142,179,201\n71,151,184\n67,150,155,161,177\n75,142,181\n78,144,180\n182,198,293,299\n54,300\n64,66,308\n165\n34,41,61,68,78,83,102,128,130,158,180\n0,22,28,55,60,82,84,97\n136,166\n0,3,15,29,53,76,78,80,88,90\n0,63,65,90\n0,45,56,58,86,113\n9,77\n0,90\n0,76,81,84\n10,26,28,36,40\n120,151,180\n128,157\n1,9,33,53,61,90\n0,47,79,105,126\n62,79,90\n0,40,65\n118,147,180\n0,26,118,165\n15,90,103,110,123,135,156,179\n0,24,39\n37\n19,133,156,165\n4,46\n0,26,34,42\n0,81,111,125,154\n26,45,48,109,127,165,178\n1,33\n143,180\n126,153\n0,96\n96,109,159,166,180\n106\n123,147\n94,106\n88,91,95,106,111\n46,72,174\n0,32,51,180\n41,49,60,310\n16,50,52,83,311\n63,73,148,168,181,246,293\n54,62,73,80,82,145,166,177,300\n292\n37,53,308\n26,56\n67,82,86,94,98,125,128,144\n23,47,58,60,317,337,343\n72,140,159,179,286,306\n62,155,160,304\n12,24,27,31,58,76,327\n17,38,76,318\n0,41,87\n0,34,43,53,77,92,94,101\n37,64,68\n0,15,27\n85,89\n23,43,75,99\n80,89\n16,100,173\n0,49,51,57,66,68,90\n2,97\n2,52,90\n12,42,90\n0,66,87,102\n68,90\n118,138,157,161,170\n103,125,155,158,180\n103,133,135,138,155,158,180\n65,97,109,112,114\n0,20,41,63,180\n90\n58,90\n90\n52\n97,133,159,187,190,287\n75,168,191,287\n68,133,180\n72,74,181\n67,77,99\n52,61,180\n47,49,69,77,85\n97,110\n0,19,29,84,90\n97\n52,180\n152,180\n158,181,188,193,273,295\n65,297\n71,179\n69,178\n70,72,158,185\n79,166,186,188,190\n5,220,245\n302\n300\n70,178\n69,89,177\n54,180\n69,178\n70,109,112,138,185\n90\n97\n90\n100,120\n114\n70,189,297\n66,191,220,292\n69,177,207\n69,177\n78,82,180\n68,70,183\n70,122,186\n63,89\n27,77,80,101\n90\n0,52,60,88\n90\n13,65\n65\n41,60\n58,92,190,205,227,242,292\n60,292\n60,290\n56,100,289,316\n179\n179\n77,183\n182\n193,285\n88\n71,90\n0,25,33,36,53,180\n48\n35,56\n34,57,168\n51\n76,81,91,110,182,303\n87,113,181,306\n180\n52,87,150,174\n180\n247,293,311,313,315\n249,293\n292\n289\n0,55,300\n8,11,55,302\n55\n6,55\n0,16,61,111,119,125\n58,79,165,180\n44,58,73,90\n21,94,97\n29,42,45,48,82\n2,14,30,35,78,87,102,105\n31,68,76,90\n90\n0,86\n180\n180\n185\n185\n59\n291\n290\n246,293\n248,295\n292\n292\n42,55\n0,5\n0,138,155,180\n0\n138,140,142,145,154,156,173\n0\n63,186,294\n65,184,293\n69,293\n67,190,210,291\n59,96\n57,80,300,333\n60,300\n69,175\n68,176\n66,162,177,180,187,191,292\n70,161,180\n55,66,80,82,180\n0\n0\n0\n0\n180\n167\n180\n177\n0\n0\n180\n180\n0\n0\n180\n168\n0\n180\n0,180\n0,180\n180\n180\n0,80,127,133,138,180\n8,39,46,49,68,78,120,146\n113,141,169,172\n120,137,169,176,178,180\n1,67,89,91,94,108,145,155,157,167,180\n57,180\n180\n35,45,58,307\n29,59,305\n56,312\n27,57,304,323\n180\n45,65,296\n0,180\n0,27,32,58\n180\n0,22,26,65\n70,106,157,161,299\n70,146,149,301\n63,65,87,91,93,122,169\n70,93,95,121,132\n63,65,81,108,143\n96,114,144\n256,298\n262,300,305,332\n60,90\n60,92\n61\n59\n178,296\n178,299\n179,198,201,247,291\n181,211,237,253,296\n180,264\n71,73,119,127,129,132,136,143,146,299\n69,133,154,298\n63\n63\n283\n40,59,63,73,76,88,97,101,139,308\n55,75,124\n151,188,196,199,202,219,271,278,280,317\n193,217,252,257,286\n0,180\n0,23,180\n0,55,96,120,137,144,180\n0,5,13,15,25,45,49,53,79,104,143\n14,37,53,88,108,110,121,136,171,180\n0\n1\n0\n0\n358\n0\n46,310\n71,87,101,124,151,223,245,263,270\n0,10,13,20,27,54,306,333,340,347,350\n78,97,263,282\n71,85,98\n34,51,76,94\n44,60,88,137\n0,176\n0\n0,23,173,178,330\n0\n182\n46,53,67,174,304\n180\n136,145,171,177,181,224\n0\n0\n0,16\n0,64,94,121,141,152,155,157,162,166,171\n0,9,40,171,180\n92,115,128\n183,358\n19,34,47,307,311,315,329,354\n7,11,14,355\n173,180\n10,29,158,180\n0\n0,180\n0,27,31\n0,180\n0,180\n180\n6,180\n0,180\n0,180\n1,15,73,81,93,95,101,111,131\n4,132,149,333,339,346\n0,110,135,145,265,356\n0,43,64,83\n0,36,58,92,109\n90\n0,17,36,71\n111,142,163\n26,97,112,136,143\n0,122\n3,8,25,28,102,113,123,141\n0,13,32\n137,139\n113,130,180\n123,127,149,169\n66,90,115,118,124,127,140\n0,34,79,100\n89,120,124,128\n93,123,136\n110,126,153\n57,180\n49,52,61,63,180\n35,44,56,172,174\n180\n159\n55,180\n65,175,292,303,308\n67,172,295,306\n62,187,331\n56,305,330\n54,303\n56,314,317\n56,293,310\n177,299\n172,196,275,293\n37,62,66,169,302\n61,176,299\n57,307\n57,305\n0,170\n0,102\n0,32,55,180\n0,5,13\n180\n180\n180\n173\n0,36\n0,178,180\n180\n180\n0,73,88,97,100,104,112,123,127,130\n5,9,41,47,51,84,113\n0,20,47,51,57,69,100\n134,151,180\n128,151,180\n131,179\n94,124,163,173,179\n0,19,22,52,55,108,121,146,149,151\n0,50,104\n0,85,97,105\n106,153\n150\n3,116\n0\n0\n0,115\n180\n180\n180\n180\n0,180\n0,179\n215,241,260,262\n193,213,234,244\n4,117,135,202,240\n2,101,130,164,197,205,235\n12,205,228,237,239,353\n1,211,218,220,223,242,342\n31,54,80\n31,57\n31,56\n94,108,112,114,135,177,179,182\n74,77,107,122,128,138,176\n102,141\n108,144,147,150\n81,105,139,164\n93,110,113,140\n101,111,114,144\n89,108,123,144,167\n60,185,297\n62,187,222,297\n41,47,53,72,171,184,190,203,213,221,229,240,284,305\n43,60,66,69,183,191,200,281,296,304\n47,56,60,184,202,258,268,295\n40,195,205,228,258,294\n227,274,280,286\n25,28,57,91\n20,23,58\n60\n62,88\n57\n64\n53,304\n52,304\n301\n1,10,34,60,304,330\n49,279,308\n278,306,326\n67,132,149,176\n69,177\n73,123,176,202\n72,124,128,149,176\n67,117,181\n44,66,108,180\n96,112\n74,100,121,144,154,169,178,181\n46,73,164,184\n64,81,183,297\n67,188,296,340\n48\n47\n52,307\n53,307\n49,74,87,91,153,170,196\n74,95,139,167,170,193\n38,72,168\n62,182,274,297\n60,182,297\n304\n50,305\n305\n50,304,352\n71,73,171\n50,72,176,200\n77,149,172\n63,180,285,298\n0,5,42,76,99,134,180\n23,61,70,101,180\n45\n164,180\n159,180\n159,180\n164\n64,68,180\n47,49,65,72,105,180\n66,75,88,100,103,161,170,175,180\n165,178\n158\n0\n0\n90\n0,18,22,28,90\n0,8,11,28,30,36,57,69,77,85\n90\n0,18\n0,20\n180\n112,162\n0,33,37,77,85,90\n0,105\n90\n0,30\n114,143,180\n0,119\n0\n0,41,43,116,180\n180\n0,4,7,27,47,67,94,121,157,159\n0\n0\n15\n0\n1,17\n13\n0,5\n162,173,180\n138,167,172\n107,149,180\n0,50,53,103\n16,25,89,112,115,136,146,153,157,179\n0\n0,27,66\n0\n11,78\n157,176,180\n1,6,92,123,127,171\n0,32,111,131,134\n0\n0\n0,18\n180\n180\n107,110,135\n0\n0\n0\n142,176\n14,83,87,113,124,147,169,180\n0,14,25\n122,165\n166\n0\n180\n0,37\n14,28,49\n1,21\n1,8,21,43,46,52\n180\n180\n42\n9,45\n0,5,22,46,49\n85,129,177\n84,105,112,116,148\n78,111,151,172\n95,140,176\n102,135\n265,271,278,298,320,324\n312\n62,304\n61,303,326\n15,23,33,62,308\n19,27,43,62,92,318,321,344\n59\n35,39,58,350,353\n133,174,176,185,218,233,289\n151,153,172,178,239,278,282,284,287\n138,176,261\n133,152,172,187,192,276\n79,108,116,162,296\n72,79,88,91,116,164,297\n27,63,103,305,329,350\n29,61,305,343\n56\n58,105\n159,186,196,226,260,267,281\n152,190,193,258,279\n75,101,126,133,139,155\n70,93,103,143,152,159\n150,171,194,263,288\n182,271\n49,308,323,326\n52,92,322\n48,80,314,317\n47,75,84,86,315\n46,320\n186,247,289,292\n175,192,198,252,270,289\n72,78,93,159\n76,78,141,163\n51,315\n16,25,52,314,325\n181,277,281,284,288,290\n176,192,279\n180\n0,154\n357\n0,10,13,15,29,32,36,67,116,129,132,153\n48,310\n0,180\n0\n16,20,27,37,40,54,56,70,103,105,115,128\n23,42,64,80,83,90\n0,5,33,63,90\n131,155\n47,54,90\n2,5,23\n180\n117,156,167,173,180\n0,24\n0,20\n0\n0,10,20\n22,33,38,335\n76,92,111\n0\n60,77,148,180\n93,135\n187,296\n71,181,294\n67,169,186,296\n289,291\n53,188,211,214,302\n180\n169,180\n1,14,180\n67,186\n65,152,183\n62,76,96,115,171\n77,80,88\n33,80\n84\n156\n68,81,83,85,93,116\n67,92,103,111,131,157\n25\n77,80,103\n0,2,9,11,19,21\n97,102,111,130,150\n296\n296\n49,172\n50,173\n46,190,291\n48,188,289,291\n49,185,291\n42,160,183,292\n40,289,309\n34\n0,18,37,55,61,63,68,90\n11,14,31,34,58,79,164,177,180\n75\n0,12,18,23,25\n147,172,176,180\n22,36,48,61,76,78,80,95,169\n59,95,109,126,144,148,172\n0\n50,61,68,92,104\n54,103,127,133,136,139,149,154,156\n45,85,355\n81,103,126,147,160\n89,109,132,151\n21,36,40,59,86,90\n0,8,13,22,43,54,69,73,75,93,95,134,143\n62,64,89\n15,20,39,48,90\n0,5,9,12,18,40,59,68,72,96\n51,90\n72\n12,43,73\n105,160,180\n109,142,170,180\n57,59,63,94,119\n0,10,40\n0,35\n40,59,312\n43,61,311\n20,29,41,54,91,325,344,358\n177\n0,3,6,10,30,44\n0,92\n0,33,95\n47,58,295\n62,181,280,299\n58,70,225\n61,171,190\n0\n0\n1\n0\n0,180\n0\n1\n55,59,297,311\n80,112,118\n64,74,290\n79,99,102,296\n0\n0\n63,189,294\n63,185,295\n186,293\n0\n351\n12,29,67\n116,160\n12\n0,16\n65,90\n0,180\n0\n0\n180\n141,170,180\n0\n180\n0,123,179\n359\n358\n85\n67,69,87\n1\n56,167\n54,66,166\n28,48,139,163,172,180\n180\n0,4,7,39,61,64,81,129,147,149,157,170,178,180\n47,49,58,63,328\n60,318,324,332\n0,180\n0,59\n0,180\n0\n0,180\n0\n0,43,146,180\n0,180\n0\n0,180\n1,180\n0\n0,180\n13,19,31,33,38,61,79,109,129,155,160,168,174,180\n0,13,180\n0,17,101,119,136\n158,160,162,180\n64,189,294,304\n69,183,304\n54,304\n54,303,327\n43,61,78,164,178\n62,72,78,163,185\n51,306\n46,50,306\n0,2,8,18,47,67,83,95,125,160,165,168,170,174,180\n0,33,56,88,110\n49,54,56,63,66,93,103,121,138,157,177\n68,108,128,174,180\n64,92,102,133,155,157,180\n59,90,101,110,116\n9,24,62\n118,167,170,180\n49,52,180\n90\n104,135,171,177,180\n180\n180\n90\n26,37,53\n73,99,110\n33,36,40,58\n41,54,56,81,84,90\n0,20,54,75,81,94,112\n106,145,168\n61,281,306\n60,282,305\n62,306\n61,305\n290,310\n291,310\n59,306,333\n0\n0\n0\n0,180\n0\n157,178,180\n180\n0,56,58,180\n0\n126,180\n0,180\n0\n0\n179\n0,2,177,179\n0\n167,172,177,180\n0,44\n0,63,69,180\n0\n0,24\n0\n0,10,17,32,66,163,165,180\n11,26\n0,56,150,179\n0,21,24,123,135,180\n152,156,180\n0,18,136\n0,19,54,67,69,72,74,90\n0\n180\n0,169\n0,45,87,105\n121,148,164,166\n102,108\n0,13,99,116\n9,30,44,79,98,128,137,146,156,180\n0,41,43,78,83,107,109\n0,33,35,37,52,81,84,92,130,180\n10,59,68,91,95,101,107,110\n13,57\n180\n59,304\n58,304\n0,47\n4,19,29,180\n0,4,27,50,55,77\n0,38,57\n0,38,78\n0,180\n0,21,28,36\n0\n0,33,35,38\n0,3,9,36,38,63,66,90\n0,27,45\n151,180\n90\n69,90\n0,155,180\n70,89\n27,59\n62,83\n74,91,97,117\n75,77,79,96\n89\n75,97\n0,54,76,82\n79,92,100,119,150,180\n40,52,72,83,101,127\n68,83,106,120,155\n71,83,88,119,122,139,173,180\n85,97,113,118\n2,7,9,18,22,89,95\n110,125,155,159,161,164,167\n44,81,111,117,142,146,159,180\n39,54,91,129\n193,205,262,270,290,296\n191,289,291\n70,181,202\n62,151,180\n182,195,300\n185,191,195,296\n0\n0,47,115,180\n0,31,57,81,90\n0,3,35,53,55\n17,45,55,128\n50,57\n0,180\n180\n4,180\n0\n0\n0,28,52,90\n180\n0\n0,180\n0\n0\n0,21,145,163,166,180\n0,27,34,70,129,134\n0\n180\n7\n8\n128,132,180\n180\n180\n162,179\n142,158,170\n9\n180\n180\n180\n180\n0,18,21,52,59,65,154\n0\n180\n180\n67,90,93,138,172,180\n0,49,129,151,170,180\n91,180\n0,22\n163,165,180\n119,167\n79,104,108,111,125,130,134,292\n64,92,119,150\n293\n40,59,84\n46,317,327\n29,48,322,336,339\n62,124,157,176,211\n54,317,345\n52,315\n53,304,340\n70,98,104,137,155\n0\n180\n1\n0\n1,33,55,64,67\n36,67,71,180\n0,180\n76,194,283,298\n188,299\n19,38,54,61,126,144,159,163\n180\n13,34,39,62,95,119,159,170\n180\n163,180\n0\n0,19\n0,180\n153,180\n0,180\n180\n180\n0,46,68,89,92,107,137,140,152,180\n44,62,125,130,136\n0,7,61,64,84,99,116,146,162,180\n82,87,115\n68,305\n180\n180\n0\n0,162,180\n173,182,188\n0,180\n0,3\n18,87,100,106,142\n0,4,7,10,13,16,74,77,82,84,90,98,109,115,132\n105,165,200\n100,170,201\n16\n0,5,169,180\n0,5,9,14,165,168,170,176,178\n180\n0\n21,27,30,53,65\n1,59\n180\n0,120,180\n0,180\n180\n0,180\n145,180\n1,154,180\n0,162,180\n180\n1,180\n163,180\n0,173,180\n0,180\n0,178\n180\n69,91,121,163\n0,2,5,24\n170\n0,156,180\n23,148,180\n89,91\n0,16,149,175\n0\n0,90\n0\n0,26\n136,164,166,176\n0,40,87,90,147,180\n0,35,65,68,89,92\n125,127,155,180\n75,94,103,109,112\n173\n180\n0,91,116\n180\n42,51,53,58,136,143\n0,180\n11,22,30,160\n21,27,33,36,73,90\n0,55\n17,27,38,46,68,90\n0,2,55,65,75\n0,10,20,164,180\n3,180\n0,180\n0,96,180\n0,14,177,180\n0,4,175,179\n0,180\n0,180\n0,180\n0\n180\n0,180\n180\n180\n0,44,109,114,154,174\n111,144,162,164,180\n5,59,62,67,97\n180\n0,180\n0\n180\n145,152,166,168\n0,180\n142,180\n0,17,180\n0\n0,176,180\n59,93\n56,100,102,150,180\n0,99,134\n110,116,123,158,162,169,178\n0\n0\n0\n0\n0,12,15,40,180\n180\n0\n0,16,54\n180\n180\n0\n180\n0,31\n0,8,25,45,131,161,163,167,180\n0,180\n0,23,35,68,88,109\n0,8,24\n0\n0,180\n0,25,41\n0\n2,10,25,143\n0\n165,180\n180\n0,31,180\n0,180\n0,180\n0,180\n0,180\n13,82,108,110,115,119,126,141,144\n55,90\n3,52,73,111,139\n37,88\n13,59\n120,165\n135,156,160\n0,6,57,96,104,109,122,128,134,139,149,153\n0,94,115,128,131,138\n11\n0,16,34,66\n126,151\n128,161\n0,119,121\n128,141,164,180\n2,15\n1,10,50\n58,180\n180\n56\n63,170\n14,56,303,320,354\n3,29,55,303\n56,300\n36,57,301\n176,180,192,194,269,271,279,293,323\n179,182,293\n63,176,291,301\n59,178,299\n305\n3,9,15,35,39,54,76,307,336\n54,77,309,322\n176,200,260,288,310\n59,168,287\n62,161\n0,180\n0\n0,156,168,179\n0\n0,180\n0,27,62\n0,21,35,152,180\n6,59,180\n0\n10\n180\n180\n180\n180\n54,63,66,133,169,180\n0,18,34,38,40\n180\n0,97,117\n0,23,35,90,117\n80,109,150\n83,102,127\n19,30,71\n130,178,180\n110,112,119,150\n91,136,152,176\n125,138,141,179\n8,39,63,85,117\n0,7,14,67,89,108\n55,90\n0,11,35,73\n18,47,75\n160\n0,25,38,69,106,120,122,145,148,151,157,161\n0,21,75,78,83,95,105\n169,180\n0,5,10,13,137,151\n9,12\n0,25\n180\n180\n180\n0,151,154,166,180\n0\n180\n19,34,37,48,119,127,144,147,152,155,167,180\n0,180\n0\n131,158,180\n180\n210,216,238,243,256\n124,127,208,233,358\n0,128,130,210,232\n32,55\n30,56,78\n56\n57\n20,345,349\n23,350\n110,115,133,144,156,162,171\n128,133,144,170,175,189\n111,142,159,179\n75,90,108,128,146,160\n1,13,101,114,238,241,245\n62,185,298\n58,188,298\n191,196,198,223,296\n54,70,194,197,213,216,241,298\n188,191,215,226,232,242,287,299\n180,190,197,290,297\n58,82\n59\n38,59\n49,54,60\n5,53,305,347\n6,53,306,340\n55,304,320,322\n51,309,327\n44,304\n45,52,58,303\n70,180\n70,179\n66,104,181\n102,180\n71,114,123,130,178\n66,79,82,171,173,177\n62,184,295\n61,83,188,297\n137,163,166,199,296\n202,221,297,305\n17,47,312\n50,310\n83,171\n88,173\n91,157,179\n53,56,191,297\n57,189,193,269,294\n63\n13,52,281,305\n51,278,306\n50,307\n40,260,310,327\n73,174\n77,173\n53,68,184,294\n68,178,196,300\n49,312\n51,309\n0,16,18,27,31,39,51,75,114,180\n16,18,43,47,54,57,84,99\n0,54,56,91\n80,180\n114,164\n154\n25,59,72,74,142,180\n0,69,76,78,100\n0,50,55,70,75,90,92\n59,73,79,148,154,180\n0,16,19,29,33,62\n19,23,27,37,65\n128,162\n160\n162,180\n156\n29,74,92\n72,108,114,128,135,162,180\n0,56,62,66,87\n50,73,94,96,151,154,180\n75,92,103,170,180\n21,39,41,64\n19,29,49,63\n130,132,137,139,141,167\n134,164\n157\n53,57,59,81,84,86,90,93,95,107,113,119,126,130,168,170,173,175\n0,2,5,9,29,62,78,90\n72,88,91,180\n77,101\n0,37\n0,41\n2,16,44,73,90\n8,58,90\n2,66,119\n90\n6\n0,40\n180\n143,180\n180\n110,135,152,180\n0\n0,42\n0\n0\n0,31,36,92,123\n0,5,16,33,35,73\n0,78\n0,44,90\n2,14,30\n0,12,43,50,53,56,66\n0,17,49\n0,26\n162,180\n117,156,179\n0,31,33\n0,108,146\n47\n0,27,90\n1,29\n0,29\n123,154,180\n0\n0,180\n0,56,59,61,63,73,131,180\n0\n12\n9,11,17,19,21,54\n180\n0,53,80,122,180\n0\n0,39\n0,177,180\n180\n21,27,29,180\n0\n1\n180\n126,141,180\n0,20\n138,175,180\n21,51,75,97,116,139,159,180\n0,18\n35,42,46,62,112,144,163\n19,50,180\n0,4,6,43,47,49\n14,24,34,180\n29\n43,62\n0,6,23,28,33,38,48,179\n0,13,24,40,43,54,76\n41\n19,40\n90,124\n84,89,103,119,126,150\n2,62,295\n30,60,93,293\n1,26,28,40,66,68,325,344,351,356\n20,28,40,67,321,338,340,355\n38,57\n59,61,63,67,70,100,119,173\n67,174\n86,152\n85,90,103,106,132,150\n62,301\n63\n26,46,330,351,353\n26,49,326,332,334\n89,105,127\n71,83,86,90,103,106,115,135\n173,289\n172,190,193\n37,41,45,314\n71,77,84,152,155\n51,303\n29,32,35,53,337\n46,84,315,322\n13,52,82,326\n73,173\n75,108,167\n47,312,336\n6,50,76,96,313,316,328\n72,87,94,119,144\n69,125,128,157\n0,33,44,48\n0,55\n134,175,180\n180\n0\n0\n0,156,180\n0,6,20,74,97,123,148,154,162\n180\n0\n0\n9,13,15,170\n1,10,13,19,26\n41,180\n29,33,37,55,68,90\n90\n1,26,52,180\n65,90\n79,105,145,166\n180\n58\n162,180\n78,101,113,123,137\n0,22,56\n0,38,57,82\n0,6,28,35,43,60,82\n48,180\n53,78,90\n87,89\n0,93,160\n78,144,178\n0,44,76\n93\n94,108,122,127,157\n24,55\n30,59\n102\n100,102,105,180\n0,14,43,81\n0,38,151,180\n55,79,81,90\n86,90\n0,22,80\n16,54,56,62,64,89\n0,27,29,100\n62,82\n90\n117,119,132,159,167,180\n32,69\n14,42,90\n1,21,38,95\n82\n4,7,28,30,32,65,67\n69,86,119,309\n69,115,304\n176,204,290,310\n150,176,247,292,309\n59,306\n59,301\n43,46,62,65,93\n61,94\n60\n60\n69\n67,80,83,142\n51,80,280,284,313\n52,286,313\n60,83,86,89,154,166,241,250,253,279,282\n66,68,84,132,152,154,161,170,245,282\n312\n112,138,161,200,278\n113,160,201,280\n59,302\n59,302\n68,87,114,120,129,156,268,274,276,284,292,294,300\n71,90,111,119,123,162,269,273,289,295\n278,315\n278,314\n62,91,285\n35,41,47,75,101,103,293,295\n78,123,138,270\n78,98,271,300\n0\n0\n0,8\n104,125\n12,16,24,40,74,327,355\n9,43,75,328,353\n123\n117,136,324\n36,72,324,359\n38,327,357\n180\n141,169,179\n13,15,35,41,90\n0,25,30,103\n86\n90\n86\n90\n15,60\n15,71\n110,165\n85,103,132\n150\n127\n57,173,175,180\n10,55,303,321,358\n19,55,304,359\n16,57,92,309,338,356\n63,176\n56,71,302\n180\n180\n0\n167,180\n0,5\n154,180\n67,189,226,298\n68,191,222,226,282,289,300\n206,299\n208,299\n56,58\n62\n57\n57\n2,53,305,353,358\n55,304,339\n72,179\n179\n61,186,207,296\n62,186,279,288,300\n45,313\n92,173\n185,299\n54,304,342\n304,343\n81,97,129,137,169\n75,95\n14\n0,4,29,173,176,180\n0,4,9,36,53,59,81\n40,51,89,110\n77,85\n124,146,155,167,177,179\n0\n23,64,90\n59,180\n57,306\n57,75,82,304\n177\n77,144,156,177\n52,180\n3,8,17,40,45,58\n180\n180\n56,180\n56,314\n56\n48,305\n48,284\n0,9,83,85,90,100,105,119\n52,91,113,119\n24,49,55,62\n0,9,70\n98,117,135\n123,151\n90,112,151\n87,96,108,129\n93\n29,57,78\n0,6,13,51,102,133,137\n10,27,41,43,69,71,101\n87\n91\n0,8,35,78,84,88,97,159,164\n0,31,38,42,93,102,109\n91,109,111,158\n58,105\n0,10,20,41\n0,35,331,354,357\n29,329,348\n85,88\n0,18,95\n90\n6,23,46,80\n106,141\n1,23,25,35,41,90\n0,6,105\n1,33\n0\n0\n0,180\n1,21,27,87,89,153,155,179\n90\n13,33,171,178\n62,66,69,86,89\n0\n0,180\n0,2,6,171,180\n25,32,41\n63,74,87,90\n0\n180\n0\n0\n357\n359\n0\n180\n0,21\n0,22\n0,31\n33,38,41\n79,284\n78,283\n0\n53,70,81,137,169\n36,53,75,84,92,126\n164\n0,41,54\n180\n0,40,58,60,180\n79,96,102,105,170\n93,96,159,165\n46,281,299,308,312,314\n49,280,303,305\n0\n180\n0\n180\n0\n180\n0,180\n0\n180\n0,2,6\n0\n0,27\n0,37,52,54,56,110,125\n118\n180\n105,142,164,167,180\n0,8,10,43,57,78,102,180\n0,29,39,43,89\n180\n40,180\n0,22,32,42,161,180\n180\n180\n80,96\n192,216,227,237,241,245,256,259\n2,34\n24,45,63,77\n27,37,71,90\n57,61,90\n99,130,151\n91,111,134\n17,36,54\n89,109,125,128\n2,30\n20\n0,35,54,143\n0,21,23,33\n80,120,133,147\n61,97,123,128,164,302,307,313\n88,94,100,104,120,126\n94,109,119,133,139\n56,93,306\n60,92\n85,105,115,141,168\n74,102,124,147,163,296,301\n79,97,102,108,146,161,164,167\n95,108,111,118,125,144,157,176\n106,136\n84,101\n75,79,109,127,141\n52,76,113,142,178\n153,172\n112,152,161,167\n91,144\n64\n95,118,162\n109,135,157,180\n89,150,164,180\n89,91,114,124,152,180\n68,73,75,92,107,119,168\n86,125,148,180\n96,118,133,151,157,161\n108,119,131,142,152,170,180\n96,141,162\n0\n114,153\n1,17\n64,90\n104,111,121,140,157,159,180\n255\n97,256\n0,50\n1,11,15,19,47,52,56,119\n63,68,90\n2,12,33,46,60\n0,45,77\n0,7,11,13,35,42,59,62,91\n90\n100,117,180\n0,22,180\n81,88,91,106,138,155,157\n91,107,118,147\n91,100,130,151\n21,52,94\n10\n108,110,157\n106,128,140,142\n10,51\n87,115\n88,102,121,211,214,216,231,236,245,248\n81,96,223,246,249\n108,221,238,263,279\n0,4,18,25,47\n0,55,66,68,88,116,118,121,146,180\n0,15,24,35,46,52,64,100\n46\n145\n64,181,199,298\n45,59,179,187,190,193,297,313\n0,6,180\n0\n180\n158,180\n0,12,78,89,102,106,114,121,136,174\n0\n145,180\n0,150,157,169\n0\n148,180\n0,3,35,59,98,102,106,110,114,135,148\n0,27,29,33,57,100,160,174,180\n0,116\n37,310\n28,33,39,58,308\n2,24\n61,182\n98\n85\n53,66,185,188,194,295\n57,80,87,110\n61,63,69,79,111,129\n0,24,66,76,88,116\n61,66,92\n0\n36,39,57,161,180\n0,35,45\n70,90\n0,22,34,37,42,60\n69,87,89,114,127\n54,61,74,101,143\n58,75,188,300\n78,184,300\n0,10,81\n1,180\n0,177\n0\n0\n0,160,170,176\n53,64,177\n0,179\n0\n3,12\n2\n0,103,180\n152,166,172,180\n14,52,62,108,173,178,180\n0\n0\n180\n160,180\n0\n154,173\n0,24,31,87\n0\n0,178\n180\n180\n0,180\n171,180\n0,145,176,180\n0,177,180\n0,24,157,180\n0,180\n16,38,61,85,88,91,99,130,158,175,180\n15,41,49,57,79,87,105,107,130,152,154,180\n0,2,169\n2\n0,154,168\n0,7,180\n34,51,79,88,94,121,160,164,173,303\n25,30,36,67,89,118,156,173,290,312\n58,330,333\n59,326\n0,5,135,153\n0\n0,180\n65,182,184,296\n66,187,204,295,325\n59,75,303\n58,303,338\n66,176\n66,86,93,164,180\n188,296\n295\n54,306\n62,145,151,179\n0\n0,174,180\n72,82,90\n87\n59,90,107\n35,64\n72,103\n62,296\n297\n180\n0,72,98\n150,157,180\n0\n0\n0\n0\n180\n180\n180\n180\n0\n0\n180\n180\n0\n0\n180\n170\n0\n180\n0\n0\n0\n223,227,247,269\n257,277,280\n74,143\n274,282,289\n288\n287\n0\n0,25,38,43,46,122,127,140,175,180\n180\n180\n0,38,48,88,180\n26,64,66,71,73,135\n113,152,173,176,180\n103,151,179\n10,27,41,56,70,148,168\n109,147,153,175\n0,180\n11,52,76,144,150,180\n41,61,66,77,79,93,119,168\n58,308\n57,354\n189,212,293\n192,292\n0\n174,191\n67,174,192\n65,71,190,289\n189,196,289\n61,305\n0,177\n90\n90,110\n0\n5,31,65,100\n85,118\n100,126\n103,109,118\n58,72,298,351\n39,45,55,75,115,302,307,313,350\n25,76,114,294,358\n76,111\n0,3,20,23,42,45,48\n170,180\n61,297,300,303\n45,60,75,299,317\n53,100,132,161\n53,82,124,144,169\n66\n12,65,307\n180\n0,180\n0,180\n0,180\n0,163,171,180\n5,8,15,17,20,23,31,39,55,65,75,113,123,127,155,176,179\n0,125\n72,74,84,88,90,140,148,163,180\n53,76,80,84,88,92,116,135\n53,66,86,140\n19,61\n62,187,298\n61,184,297,301\n53,64,300\n58,301\n66,68,137,176,192\n68,177\n67,190,192,303\n64,185,300\n53,306\n58,303\n0,180\n0\n109,154,180\n0,2,156,161,163,171,179\n1,39,56,85,99,101,123,126,180\n115,180\n0\n0\n0,22\n0\n0,64\n180\n180\n0\n180\n14\n70,125,180\n175\n161,180\n180\n114,143,153,180\n87,120,145\n180\n180\n94,106,141\n72,94,116,130,136,151,163,165,298,300\n71,105,126,140,149,297\n44,61,300\n59,63,306,317\n176,265,287\n175,193,275,295\n73,140,163,295\n68,74,121,147,299\n43,62,80\n53,68,85,308\n43,90,308,322\n47,81,311,328\n111,113,115,166\n0\n286\n273,290,307,331\n308\n302\n54,298,300,304\n70\n180\n180\n56,70,291,303\n61,174,297\n0,8,180\n0\n14,26,50,55,70,76,94,96,99,160,180\n98,134\n0,180\n28,180\n0,11,34,112\n0,40,44,74,84,101,179\n10,19,55,67,72,76,83,96\n0,25,30,59\n222,233,259,315,332\n25,220,276\n21,31,217,248,268\n249,270\n218,260,273,275\n33,49,279\n0\n0\n1\n0,2\n0\n0\n1\n180\n0,180\n1,167,174,176\n0,180\n2,6,29,77\n0,14\n0\n21,160\n0,180\n2,17,29\n0,180\n0,123,180\n0,25,29,38,85,116,158\n38\n180\n4,180\n0,180\n0,5,11,14,94,110,133\n0,25,27,31,44,47,88,114,128,132,154\n0,21,59,99,101,104,158,160\n136,180\n0,33,180\n0\n128,132,144,180\n0,8,10,164,171,177\n0,179\n0,159,164,180\n0,2,180\n180\n0,17,24,180\n2\n0\n0\n0\n74,94,138\n12,39,62,69,72,91\n43,78,109,111,125,178,180\n90,114,146,170\n74\n0\n0\n0,11,13,60,65,80,90\n0,10,50,57,78\n0,174,180\n1,15,17,52,180\n3,15\n8,180\n0\n1,24\n0\n180\n0\n22,94,135,154,180\n67,81,91,95,112,130,172,180\n35,145,167,180\n0,180\n0\n0\n180\n26,28,141,144,148,159,161,172,175\n0,23,147,150,156,180\n0,180\n0,180\n54,90,124,149,180\n0,35,54,134,153,171,174,177\n0\n0,180\n0\n0\n0\n0,3,25,180\n0,9\n0,23,30\n58,81,87,114,123,133\n168,180\n0\n0,180\n0,179\n0\n3,7,9,180\n0\n152,166,180\n180\n128,138,155,169,174\n146\n311,318,326,350\n284,312,326,352\n59\n63,67,83,206\n56,66,85,96,205,229\n29,309,333,341,359\n287,313,322,353,358\n4,10,16,30,33,65,338,358\n20,50,68,358\n219,272,326\n224,272,314,316,318,328\n79,201\n48,66\n168,180,198\n85,197\n157,179,191,208,213\n68,77,177,202\n224,271,286,303,323\n284,308\n269,281,290,302,327,345\n224,278,319,321\n58\n0,11,24,51\n7,30,83,88,90\n10,12,37,59,75\n9,96,154,158,166,168,171\n0,66,73,77,89\n59,180\n180\n136,180\n60,123,177,180\n61,180\n56,71,163,180\n49,180\n50\n53,58,178\n180\n60,180\n180\n48,51,174,180\n59,76,164,180\n0,59\n178\n179\n175\n176\n34,39,59,303\n12,31,34,60,297,326\n51,54,57,315\n50,54\n79,118,124,177,294\n52,304\n52,307,338\n51,285,309\n306\n62,188,302\n63,184,279,304\n182\n57,180,197,293\n58,180,198,288,307\n42,71,166,287,317,320\n182\n180\n27,50,62,64,68,75,78\n32,52\n57,99,178,225,309\n58,164,184,309\n227\n70,161,296\n67,165,169,296\n53,309\n54,306\n177,203,287\n178,282,288\n16,53,82,297,311\n55,310\n176,217,234\n180,223,226,237,240,285,287\n71,177,293\n57,166,184,300\n180\n73,166,293,295\n26,54,310\n2,54,307\n175,196,214,271,290\n178,197,209,290\n34,41,48,290,310\n44,310,324\n52,294,304,308,321\n55,157,181,291\n34,158,182,280,283,295\n179\n7,9,122\n1,4\n160,168,180\n0,96,101,108,133\n13,93,97,106,122,124,150\n0,120,163\n0,32,38,40,52,79,94,109,125,142,163,167,180\n2\n54,77,160\n0,18,59,98,100,104,154\n106\n83,99,101,113,122\n75,107\n82,87,110\n0,4,21,35,54\n0,7,25\n18,57\n93,113,124,148,169\n130,180\n139,174,176\n177,179\n0,106,108,121\n180\n0,3,9,30,114\n0,9,16,50,65,85,123,128,134,157,170,180\n93,121\n1,22\n180\n3,10,349,359\n150,161,163,338,357\n151,338,351\n114,143,164,352\n5,35,43,46\n4,318,325,344,348\n242\n234,246\n0,60\n45,63,90\n0,7,9,29,33,40,61,64,83,87,90\n3,10,19,90\n50,73,80\n0,54,120,173,176\n0,17,28,47,57,90\n90\n0,21,23\n0,15,26\n0,11\n143,150,177,179\n118,165\n0,57,73\n0,8,21,25,28,40,45,90\n10,26,121\n3\n119,142,180\n150,164\n14,47,49,89\n13,116\n180\n0\n145,166,180\n40\n0,22,31,44,64,69,89\n142\n0,54,89\n0,7,119,123,138,149,168,179\n13\n153,160,180\n4,23,155,158,163,166,169,177\n162,184,191,205,208,214\n237\n237\n139,165,176,179,195\n147,167,173,195,217\n6,35,37,50,167\n10,36,55,98,110,147,160\n22,27,52,55,61,67,161,175\n13,47,157\n359\n359\n18,53,69,96\n14,58,97\n209\n208\n31,58,73,170,180\n48,77,166,169,180\n58,180\n0,25,74,85,92,122,132,143,157\n38,60,80\n90\n39,46,52,72\n180\n80,91\n3,31,55,70,88,120,122,124,136,157\n47,80,90,93\n0,7,31,47,53,62,67,83,87,90,117,149,154,157,165,180\n0,10\n0,12,57,78,80\n17,107,128\n87,90\n90\n1,20,33,49,68,83,99,119,122,125,128,131,150,157,165,170\n3,22,25,49,52,54,58,88,117,164\n55,148,180\n150,171,175,179,201,283,315\n58,149,165,173,179\n29,45,63,78,105,136,158,180\n48,75\n0,13,21,32,37,47,51,74,79,90\n0,115,126\n6,10,12,32,65,87,111,146,152,179\n1,15,22,25,31,60,139,142,149,151,166\n56,60,180\n20,94,101,110,140\n79\n80,88,90,103,126\n0,29,52,81,86,90\n0\n35,64,68,118\n42,66,149,151,158,163,180\n28,44,58,63,180\n0,8,50,76,86,90\n0,2,137\n32,57,72,88,121,180\n61,80,174,198,289,291,314\n53,80,178,196,295,304,306,310,316\n0\n94,129,152,156,160\n90\n41,88\n61,90\n45,75,105,138,159\n0,3,41,74,121,136\n19,53,66,79,90\n5,43,69,72,149,151,167\n45,48,56,59,148,167\n53,55\n0,26\n0,10,33,55,90\n48\n34,78,80,92,95,118,146,166\n6,10,26,78,93,95,127,155\n2,113,343\n2,23,39,71,132,138,166\n28,64,122,147\n59,68,74,146,149,180\n24,27,35,49,62,177\n39,180\n66,167,310,321\n60,77,207,300,332\n0,9,15,28,35,41,44,60,90\n0,13,56\n26,41,45,90,111,122,159,162\n29,50,88,94,98,103,123,164\n0,8,10,23,30,51,72,90\n0,2,8,23,49,55,57,60,68,71,75\n17,38,80,111,133,158,178\n15,80,82,108,165,179\n56,180\n0,3,14,20,57\n23,55\n0,16,24,37,46,51,90\n90\n0,40,63,90\n0,21,42,54,63,90\n0,121\n58,180\n27,44,54,62\n20,22,25,47,76\n62,180\n16,51,90\n14,37,42,52,56\n22,30,40,51,54,79\n19,44,60,93,163\n0,20,66,72,84,86,90\n20,59,112,140,161\n0,19,57,108,114,139,158,169\n43,59,87,133,139,149,153,157,174,180\n0,5,11,13,46,49,69,90\n0,5,14,45,59\n0\n61,68,76\n351\n350\n45,51,59,162\n28,56,96,102,109,148,180\n39,85,137,163,169,180\n28,141,159\n0\n0,47,139,180\n1,3,26,34,39,46,71,76,90\n0,2,16,112,131\n3,25,58,90\n90\n145,168,171,174,176,179\n0,24,41,67,90\n0,39,95,121,144,180\n44,63,90\n120,153,175,180\n0,11,15,52\n18,121,136,161\n0,30,44,49,62,75\n0,26,58\n0,20,120\n144,180\n8,12,18,20,37,49,62,102,105\n3,14,26,44,58,66,106\n29,38,41,85,134,158\n0,88,102,122,135,148,150,153\n0,10,30,49,59,82,105,128,131,134,150,180\n0,22,64,109,138\n18,70,72,85,92,115,118,142,149,160,163,165,167\n0,20,34,111,115,120,138\n59,180\n33,35,51,63,70,179\n54,180\n41,61,180\n2,40,78,86,90\n107\n70,177\n0,24\n184\n75,179\n22,38,53,57,71\n0,43,51,76\n49,179\n58,79,169,171,197,299,319\n56,77,172,197,270,273,294,300,309,311,313,318,320\n35,71,73,163,165,185,265,285,311\n51,151,181,185,270,293,295,310\n26,48,55\n2,25,28,55,74,82,86,88,90\n17,19,28,83,87,90\n17,85,90,99,109,138,165\n19,109,177\n18,51,53,77\n0,2,4,11,17,47,52,67,90\n2,5,45,72\n42,75,163\n51,54,73,151,157,166,186,263,281,308\n29,51,61,153,182,270,279,283,311\n12,32,54,72,90\n4,6,8,15,19,32,42,49,65,72,90\n53\n17,47,78\n1,28,35,39,42,123,155\n0,9,52\n147,168\n29,31,33,50,66,90\n2,7,27,49,75\n0,3,10,112\n0,52,64,88,121,148,168\n44,64,82,170,172\n47,69,176,180\n0,18,33,56,79,90\n14,61\n0,12,18,20,22,47,78,81,90\n0,54\n33,60,90\n12,65\n0,3,10\n80,97\n44,49,65\n29\n0,14,17,48,59,64,68,74,87,90\n0,14,34,40,43,53,60\n57\n172\n15,18,50,63,82,95,136,163\n43,74,100,113,219,221,224,276,314,349\n40,68,73,114,160,199,225,295,312,336\n49,70,173,180\n0,6,13,19,38,70,90\n0,67,99,122,143,173\n0,5,34,38,53,59,90\n1,5,15,45,65,83,88,104,116,132,134,146,176\n0,4,112,114,121,139\n0,123\n37,45,61,68,91,150,170,175,180\n0,13,36,89,120,157\n60,180\n40,63,181,300\n60,178,299\n54,64,177,299\n75,93,112,184,215,232,281,321,354\n34,63,183,203,273,301,328\n0,3,40,48,74,80,86,113,154,169\n173,180\n22,26,34,51,185,187,284,300\n24,54,183,290,299,305\n21,34,41,59,106,125,138\n60,64,167,172,179,181,292\n48,80,183,186,277,296\n56,73,177,195,301\n66,185,300\n0,2,7,12,153,166,168,180\n3,130,158,160\n151,163,169,191,341\n123,153,189,209,241\n199,214,225,234\n230,251,260,277,280,292,304,328,330,338,340,343\n228,235,253,282,330\n244,266,269,325,332,340\n211,214,240,273,302,347\n196,244,262,286,296,301,329,338,350\n6,68,123\n3,17,20,67,115\n30,49,52\n263,321,336\n262,329,336,340\n19,48,92,95,99,106,125\n314,330,332,334\n0,19,39,90\n36,101,118,136\n90\n123,133,136,141,162\n156\n19,48,54,72,90\n151,158,161,166,186,204\n0,38\n58,180\n180\n304,310\n307\n56,184,211,298\n56,185,298\n48,67\n55,310\n55,310\n0,47,67,124\n0,20,41,72,84,103,111,121,152,180\n0,30,73,104,123,166\n11,34,86,97,109,124,170\n0,10,20,26,103,107,110,123,131,173\n0\n156,180\n4,7,39,51,53,71,75,77,106,120,135,180\n1,5,115,126,135,141,146,159,180\n8,49,87,115,133,213,235,333,345\n25,41,92,94,96,135,144,155,192,202,208,270,338,357\n4,27,88,92,95,122,154,174,195,199,201,208,211,233,330,335,341\n59,180\n56,69,306\n54\n50,180\n52,179\n48,300\n49,301\n47,290,311,331\n58,296,308,323\n26,296,328\n293\n65,172\n69,171\n180\n65,178\n185,292\n185,259,267,271,290\n174,178,181,199,201,294\n55\n65,158\n61,172,194,295\n64,127,182,302\n63,167,183,302\n161,175,177,194\n302,328\n65,93,153,178\n64,166,182\n60,175\n59,181,308\n63,182\n0,10,25,40,46,56,67,78,110,121,127\n99,128,131,134,164\n0,2,15,21,46,61,86,92,104,117,123,164\n52,67,69,172,299\n47,66,76,85,156,161,176,179,194,269,275,285\n41,61,63,70,88,91,96,104,124,134\n98,117,131\n44,85,97,119,127,136,138,151,154\n13,15,30,177\n90\n104\n90\n67,90\n90\n10,34,70,75,108,142,144\n57,59,68,90\n117,150,175\n111\n48,51,53,58,68,80,84,97,122\n112\n37,40,55,60,65,70,89,97,101,104,143\n98\n91\n48\n56,180\n48,50,84,313\n31,56,311\n56,62,93,163,166,173,198,291,307\n64,163,177,206,284,317\n64,175,198,286,314\n50,67,87\n0,9,37,63,78,90\n0,21,72,88,90\n0,17,43,106,127,131\n52,67,69\n31,60,172,178\n12,173\n14,34,176\n12,58,74,77,101,159,163,178\n8,21,42,81,84,165\n0,9,57,87,111,138,156\n0,137,180\n65,98,106,129\n10,12,39,75\n0,67,88\n9,90,112,136\n2,14,33,69,71,75,83,85,87,104,147,168\n19,53,102,122,148,167\n0,3,6,27,65,84,104,123,126,152,178\n15,66,81\n0,9,15,32,37,43,79,99,114,157,180\n0,2,25,27,29,66,123,140,161,163,175,180\n0,73,75,91,110\n0,11,24,50,108,113,116,120,140,180\n0\n0\n133,138,172,177,180\n114,118,122,138,159\n142,148,180\n156,160,173,177,179\n25,113,125,154\n3,36,61,70,100,126,141,151,154\n130,140,143,169\n0,18,20,29,111,137\n1,12,36,75,103,127,154,158,160,163,166,171,174,180\n0,28,32,84,101\n145,171\n99,151\n0,25,99,118,129\n223,255\n226,271\n225,276,288,291,293\n225,248\n128,150,217\n123,154,175,217\n165,175,196\n143,154,175,219\n146,217\n153,213\n150,214\n59,76,288,301\n68\n88,157\n189,293\n181,208\n188,193,198,202,279,298,317\n63,171,185,285,304\n60,79,186,188,304\n63,188,203,301\n56\n292,307\n299,302\n301\n303\n51,179,183,196,212,214,237,294\n52,188,237\n61,286,303\n68,175,192\n69,94,177\n69,97,176\n67,123,176\n59,80,122,157,179\n67,71,121,123,149,161,172,176,178\n169,171,173,176,186\n59,180,302\n59,68,178,306\n302\n63,299\n58,301\n72,174,185\n0,35,69,90\n0,4,6,33,40,60,70,90\n0,129,145,149,164,166,176,179\n0,133,150,152,180\n117,151,166,178,180\n0,14,31,89\n0,134,155,157,180\n45,90\n0\n0,59\n111,141,168\n32,49,52,120,123,161\n122,160,165,167\n46,82,136,144,167\n252,255,257,268,270,285,325,327\n252,280,306,329,351\n31,79,82,85,95,101,359\n10,14,16,22,38,91,95,102\n10,56,69,123,127,147\n0,3,73,122,139,152\n7,119,236,240,244\n6,121,233,359\n282,285,294,300,321\n281,284,311,313,323,326\n222,242,266\n224,232,243\n39,53,96,115,356\n18,21,25,39,51,93,108,359\n39,49,51,86,89,161\n1,7,50,70,73,77,80,90,151\n244\n243\n8,287,295,298,330,351\n5,8,287,330,351\n4,122,145\n30,63,135,180\n109,131\n88,101,253\n89,114,119,124,127,155\n9,243,261,306\n245,247,354,356\n244,258,308,316,324,339\n15,21,27,110,120\n61,180\n32,40,43,65,85,179\n47,179\n53,180\n58,66,180\n60\n68\n63\n64,166,196,199\n61,173\n46,302,332\n46,300,331\n255,262,268,298\n186,261,291,294,296\n176,197,288,304\n53,56,169,187,302\n39,59,158,180,299\n12,60\n298\n300\n64,96,164\n62,81,96,139,159,161,176\n179,196,235,297\n183,197,295,298,306\n287\n189,296\n53,70,170\n61,176\n63,167\n44,67,189,300\n172,188,303\n184\n156,184,187,191,226\n63,91,298\n59,72,144,159,172,296,298,300,308\n57,306\n31,35,57,302,325,327\n157,181,205,226\n47,60,301\n59,179,301,307\n301\n301\n173,303\n298\n297\n54\n59\n57,185,202,268,289\n55,187,292\n54,181,305,309,318,326,329\n39,47,56,174,312\n58,177,300\n58,178,296,312\n175,188\n0,24,51,56,62,92,120,139,180\n58,180\n180\n145,149,176\n45,57,62,70,173\n60,92,173,180\n47,180\n0,112,129\n71,92,168\n10,28,46,48,50,82,100,164\n30,44,50,162,272,295,323,344\n35,280,323\n300\n300\n26,73,130,148,151,155,157,163,172,180\n24,52,173,288\n41,52,175,181,196,203,291\n58,174,289\n1,28,49,64,84,86,90\n0,16,43,55,58,90\n8,45,54,89,108,138,156,162,169\n6,14,28,34,52,119,139\n13,73,84,88,91,112,122,168\n22,63,69,85,111,123,126,133,171\n59,83,142,152,180\n58,60,182,297\n59,95,184,287\n2,37,43,53,90\n0,25,111,127,144,160\n23\n6,45,117,137,154\n0,24,50,72,75\n90\n8,58,78,85,102,174\n26,45,76,100,172\n10,23,29,123,149,208,214,221,255,351\n18,107,110,124,206,228,359\n6,9,12,15,21,140,162\n8,23,27,137,139,160,173,175,179\n0,19,48,74,80,90,96,171\n13,66,113,116\n0,90,102,125,127,152\n60,64,67,70,73,76,84,179\n45,61,64,83,180\n62,156,177,188,193,203\n44,66,154,181,199,269\n254,300,340\n196\n0,51\n0,3,5,10,39,90\n0,52,90\n3,13,15,29,31,56,58,63,89,101,128,145\n59,74,96,103,130,179\n0,25,55,88\n0,23,47,68\n0,26,58,78,80,83,95,135,161,180\n0,37,47,89,109,124,154,180\n36,56,90,114,120,134,137,170\n65,189,306\n68,181,307\n58,181,299\n57,179,299\n19,22,25,38,78,94,156\n31,55,58,95,177\n143,165,180\n160,180\n120,129\n0,103,135,140,153,171,173\n0,6,10,133,155,180\n11,127,149,153,157\n3,139,164,186,189,204,324,345\n2,5,8,10,12,82,105,134,154,168,171,188,243,292,323,330,346,348\n250,284,322,335\n15,17,69,109,139,157,171,173,175,248,254,264,345\n9,20,153,155,170,180,245,341\n0,3,31,91,188,221,242,267,310,329,351\n24,40,122,125,174,195,218,253,272,308,355\n180\n194\n57,62,178,192,309\n72,149,172\n0,9,13,15,55\n180\n0,42,180\n85,89\n120\n33\n7,28,40,43,52,70,84,90\n0,119\n62,180\n0,23,41,62,90\n0,117,140,144,155,159\n0,71,79,90\n0,81,95,122,132\n0,8,101\n0,56,80\n51,55,77,79,163,180\n62,171,175,186,299\n12,30,48\n0,17,98,100,102,118,120,122\n0,6,31,65,90\n0,119,162,165\n0,33,67,87,90\n2,8,14,28,35,39,46,59,72,107,143,146,163,169,177\n9,17,29,37,46,62,69,90,139\n0,46,90,160,177,180\n17,31,38,41,44,74,77,82,85,180\n50,80,123,154\n0,5,26\n18,44,59,62\n0,6,120,135\n0,2,7,17,36,70,72,74,90\n180\n16,29,58\n40\n0,7,9,38,67,90\n13,19,30,48,59,79\n0,90\n0,19,67,77,106,111,113,129,132,160,180\n1,8,18,43,53,159,176,180\n24,35\n178\n175,177\n174\n0,3,26,29,33,39,54,70,84,86,89\n0,90\n0,10,54,59,61,64,67,72\n8,28,59,116,180\n0,2,12,122\n53,58,176,178,180\n180\n7,123\n0,24,83,86,120,122,124,143,151,180\n59,205,311\n38,59,178,184,190,218,277,280,292,295,299,312,337\n23,44,50,56,62,69,75,81,143,160,175,189,205,241,259,278,300,337\n66,90\n0,82,84,90\n0,13,22,25,45,54,61,88\n11,13,64,70,85,90\n4,12,27,50,63,65,94,125,147\n4,20,27,31,43,52,63,67,70,84,111,121,123,156,160,170,172,176,178\n0,6,9,15,28\n1,4,21,29,67,77,90\n0,31,61,73,75,90\n29,65,87,97,134\n0,18,32,74,90\n180\n0,26,104,124,138,180\n0,10,52,90\n0,29,47,94,124,152\n15,52,95,114,120,142,180\n14,79,99,126,161\n0\n0,14\n0\n156,180\n0,3\n0\n0\n180\n0,13,91,106,116,122,140,165\n3,43,76,123,143,147,150,180\n58,60,63,67,78,99\n32,56,77,80,117\n0,91,180\n0,6,24,46,69,73,92,125,149\n102,119,124,135\n13,35,60,112,117,121\n25,27,70,72,90\n17,26,31,54\n87,90\n64,120\n68\n54,73,101\n62,76,90,92,94,130\n5,21,36,42,65,218,228,349,352\n11,28,36,39,42,157,217,231,234,351,353\n0\n124,137,139\n10,34,150\n42,76,153,172\n180\n235,257\n234\n300,320,337\n263,294,307,321,349\n20,98,112,125,143,165,169,194,250,352\n118,155,177,209,234,354\n106\n103\n74,88\n0,5,7,30,32,35,37,54,90\n0,11,15,19,28,58,90\n0,2,40,94,121,137,180\n137,180\n0,3,14,20,85,119,147,180\n0,4,7,20,25,29,51,82,120,123,126,129,150,180\n2,7,10,109,113,116,118,134\n61,181,301\n65,184,303\n53\n60,75,183,290,311\n200\n191,274\n55,304,306\n55,305,307,318\n72,146,180\n62,172,195,304\n60,187,308\n193,288\n57,306,351\n52,306,329\n0,8,43,47,88,90\n0,9,92,96,127,129,149,151\n147,167\n2,4,6,48,81,83,85\n8,114,127,145\n0\n0,124,130,156,176\n15,23,27,30,53,127,148,154,158,174,178\n317,319,339\n283,324\n15,34,40,54,72,91,111,123,125,135,144,149,162,166,172\n4,16,18,20,38,51,59,61,84,87,102,124,135,145,163\n304,341\n304,337\n0,2,13,17,35\n8,115,118,222,225,233,237,246,262,265\n53,120,180\n65,180\n54,69,153,173\n41,74,82,84,88,130,172\n49,306\n49,51,60,64,67,98,168,296\n40,58,174,191,297,299,307\n299\n298\n58,76,191,288,305\n58,186,306\n54,58,66,146,175,187,309\n42,58,74,88,143,149,156,177,297\n0,3,57,118,174,180\n167\n66\n0,3,12,15,64,72,80,84,119,121,173,178,180\n142,170,173,180\n0,22,54,83,106,109,180\n0,20,55,79,88,103,106,125,169\n34,61,164,180\n22,25,27\n125,129,154,172,176,180\n2,11,52,71\n18,28,57,78,129\n51,167\n16,114,159\n38,41,46,51,80,85,180\n1,14,29,31,41,62,64,80,90\n0,33,49,53,84,86,118,132,136,142,155,180\n0,7,14,55\n44,58,180\n0,24,36,61,87\n60,180\n151,180\n2,16,23,29,48\n0,4,32\n10,60,108,125,131,137,176,180\n25,29,33,56,89,91,128,147\n172\n172\n2,57,306\n18,52,77,90\n4,41\n54,69,179\n177,265\n177,270\n2,60,90\n64,160,180\n10,93,120,139,180\n7,20,38,66,86,139,147,149,169,172,180\n139,171,180\n180\n5,24,45,55,82,117,147,160\n2,15,20,36,42,75,146,165\n20,31,41,112,134,148,150,167\n25,38,43,150,177\n0,36,45,55,82,156\n69,154,180,300,309\n54,57,180,306\n13,18,24,40,67,99,141,165\n0,8,28,39,41,43,70,81,108,157,180\n15,44,75\n35,64,77,80,95,157,171,180\n0,11,22,60,85,126,128,149,180\n37,55,82,87,90\n0,10,15,27,46,88,111,127,155\n46,71,166\n3,125,167,224,229,232,240,352,357\n3,111,165,171,177,224,227,233,240,288\n21,40,46,74,80,86,101,119,133,154,168\n44,79,161\n42,60,87,127,153,180\n38,80,125,155,175,202,224,258,281,335\n28,49,333\n27,49\n34,39,43,64,85,133,154\n23,58,100,119,142\n0,35,55,68,92,147,180\n47,170,207,291,314\n93,156,159,180\n0,10,34,39,50,79,113,133,137,139,151,165,180\n0,20,32,104,146,148,153\n0,20,100,106,117,130,147,163\n14,37,136,234,317,320,331,351,357\n89,95,116,149,208,227,315,321,332,354\n0,61\n1,38,46,55,72,77,90\n55,82,180\n0,19,70,82,90\n0,11,112,134,152,177,180\n2,21,42,45,68,89,91,93,95,97,108,111,118,126,144,148,166,169,173,176\n5,31,34,63,79,88,115,118,138\n1,30,72,97\n6,28,97\n61,90,180\n57,176,183,292,310\n49,72,166,182,196,278,306,308\n14,149,177,180\n32,55,82,90\n0,5,56,65,68,75,89\n3,6,58,90\n90\n127,175,180\n0,52,58,63,68,79,81,108,120,125,133,137,140,145,163,166\n6,17,73,98,115,148,155\n12,15,25,30,46,55,114,134,136,168\n15,46,65,86,90,105,133,170\n254,273,275,282,285,291,295,336\n256,272,274,287,295,344\n303\n303\n0,32,64,90\n0,12,25,37,40,55,71,90\n127,141\n1,19,22,31,33,49,68,90\n0,7,120\n0,17,22,30,100,118,127,137,142,144,146\n0,2,4,11,15,38,50,53,90\n0,2,23,25,59,90\n7,12,15,33,67,96,110,167\n10,96,106,113,166\n0,32,65,91,124,158\n0,18,35,83,87,90,110,120,126,142,147,149,180\n0,10,16,42,45,76,83,90\n17,23,35,63,105,120,138,154,173\n13,22,26,29,57,79,104,161\n0,20,40,68,90\n28,55,64,70\n0,22,60,67,92,108,111,155,170,180\n44,79,163\n26,43,60,147,165,169,202,249,323,356\n9,39,78,95,140,155,178,246,254,280,319,355\n25,88,197,203,210,216,222,259,311,330\n14,132,187,217,235,240,250,260,266,322,328,335\n33,58,92,95,137,157,180\n0,6,41,51,54,69,79,90,110,152,156,158,178,180\n0,23,90,97,106,125,142\n9,46,62,64,86,108,120,123,132,137,147,149,156,159,172,180\n0,14,101,104,124,126,147,180\n0,6,20,50,74,77,113,124,129,133\n18,50,103,109,115,135\n14,33,37,41,62,147,180\n0,4,9,113,132\n26,67,97,142,162,171,180\n43,46,61,175,180\n0,22,112,117,124,132,135\n60,182,285,300\n38,64,177,188,302\n0,9,26,56,59,95,107,117,137\n0,43,72,93,141\n81,101,132,146,172\n152,175,177,179\n0,24,42,120,126,134,138,147\n121,124,129,147,149,163,188,329,353,358\n5,142,144,147,181,229,258,310,334,349\n241,273,303,345\n273,288,326,334,345\n2,4,6,18,28,40,42,45,55,60,89,136,147,156,158,221,234,279,316,347,358\n7,12,17,64,126,136,147,196,200,216,265,281,290,332,344,349,356\n0,9,121,138,141,153,156,179\n144,159,169,178\n172,220\n285,307,323,331,348\n0,25,31,42,142,154,160,164,177,180\n0,13,25,45,50,68,72,89,127,171,176\n62,92,106,119,121\n0,14,16,24,77,87,109,112,141,159\n1,35,127,130,143,180\n70,91,140\n74,90\n70,81,113\n24,55,59,69,78\n73,88,90\n55,60,90\n78,117\n122,128,132,145,162\n57,60,63\n71\n73,115,119\n54\n71\n85,90,93,180\n64,78\n76,86,88\n71,90\n85\n75,90\n90\n17,19,113\n67,86,90\n120,147\n35\n32\n25,62,67,84,90\n3,23,31,40,69,88\n76,90\n148,160,172,180\n19,58,78\n9,14,24,136,157\n326\n5,253,271,292,316,319,322,325,328,334\n62,79,169\n43,67,169,190,300,303\n150,161,172,186\n55,71,98,126,137,156\n52,83,100,124,156\n8,21,126,150,168\n23,36,41,93,128,131,134,146,159\n8,34,170\n9,33,63,88,92\n18,20,45,85,158,161,165,168,174\n6,25,32,55,121,125,137,146,159\n7,59,76,103,122,142,145,169\n8,36,39,64,89\n145,164\n118,151,180\n98,105,124,126,139\n160,171,180\n0,28,109,125\n0,40,48,58,84,105,108,111,117,142,161,177,180\n163,166,169,187,205\n162,164,166,186,201\n55,59,61,158,161,179\n34,53,65,72,173,180\n59,61,180,298\n57,180,287,295\n54,56,166,172,186,300\n175\n175\n58,180,299\n57,74,179,296\n0,2,6,180\n0,10,20,30,53,82,138,161,180\n27,46,56,62,68,80,127,167,180\n296\n308\n190,274\n62,298,300\n57,80,82,177,189,299\n47,69,289,309\n50,64,80,179,304\n61,180\n138,167\n167\n0,56,81,99\n62,77,83,95\n65,184,306\n64,183,306\n0,19\n5,71,164\n170\n0,20,24,32,69\n11,13,31,34,90,98,131,143,149,174\n11,47,85,94,106,117,131,150,169\n149,153,156,180\n153,172,176,180\n0,6,9,31\n17,34,59,105,132\n6,26,54,77,117,140,158,175\n7,32,115,118,127\n15,65,69,125,139\n10,62,129\n274,301,319,340\n272,286,302,317,320,337\n35\n66,140\n2,5,64,141,143,156,162,167,175,179\n15\n1,14,53,60,78,114,118,124,139,153,180\n59,162,180\n0,33,53,63,115,160,172,180\n34,59,70,171,180\n7,27,62,71,89,119,156\n0\n167,169,180\n14\n0,16\n0\n0,6,8,15,18,56,106,183\n57\n0,43,60\n1,90\n39,181,293,307\n276,306,329\n47,50,306\n302,317\n64\n0,8,27,34\n0,7,106,115,118,124\n0,2,15,22,48,55\n131,141,144\n179\n0,24,99,122\n75\n0,37\n0,14,17\n13,37,76,136,172,176,179\n16,39,51,62,66,115,145,147,152,180\n1,33,59,67,79,90\n0,20,49\n102\n102\n100\n94\n96\n312\n98,310\n270,320\n197\n65,116\n1,3,5,45,67,90\n61,86,90\n136,145,148,157,170\n0,63,74,90\n9,12,15,36\n35,49\n41,54\n38\n12,30,33,38,59\n67\n42,60\n0,169\n1,31,40,62,85,95,106,123,179\n0,3,99,140,179\n1,26,31,185,305,315,334\n35,57,153,185,210,234,271,317,351\n4,18,24,72,154,159,165,201,246,314,346,349,352,354,357\n0,17,32,37,43,141,187,211,347\n68\n138,156\n8,26,102,136,157,166,172\n41,179,185,191\n1,22,40,62,68,74,208,329,347\n28,47,54\n149,154,175,178,180\n66,83,90\n0,25,40,140,142,163,165\n23,85,90\n105\n123,135,162,180\n99,111,150,173",H),u=0==(1&t)?null:Jl.OHb("14-38,46-74,87-105,169-191\n33-44,47-81,83-92,92-103\n133-160,167-185\n159-184,249-280\n199-221,221-232,232-255,258-267\n40-75,160-200\n18-26,28-37,37-45,48-64,72-81,93-105,109-127,171-189\n-27-27,49-56,56-76,76-104\n-43-43,45-65,65-115\n-28-28,58-61,61-70,70-90\n-16-16,44-69,69-82,157-203\n-21-21,21-52,73-107\n-11-11,20-33,33-39,39-59,59-78\n3-25,25-43,43-67,78-102\n0-24,32-49,49-52,52-69,69-73,73-77,77-79,79-87,87-89,89-91\n0-26,26-46,58-76\n-29-29,29-51\n0-20,170-190\n-14-14,21-58,58-70,70-89,89-91\n8-37\n-1-1,1-28,28-30,30-47,52-69,69-87\n0-27,27-29,29-43,43-47,47-56,56-63\n42-60,60-62,62-80,80-100,136-146,146-155,171-189\n167-193\n-12-12,24-41,41-50,50-71,71-81,164-180\n-11-11,43-70\n-23-23,40-70\n28-42,42-75,75-87,160-200\n42-70\n36-55,55-73,293-321\n31-49,49-61,61-75,294-322\n-3-3,3-15,53-71\n55-63,74-93,114-135,143-170,170-190\n0-4,7-29,42-72\n17-92,92-107,132-179,179-181\n34-65,83-101,140-153,160-180\n32-51,72-92,151-169\n33-51,70-87,151-176\n46-79,156-204\n40-67,153-175,175-185\n40-65\n40-63\n48-75,156-176,176-184\n33-52\n-1-1,1-17,21-37,165-176,176-184\n37-56,65-86,152-175\n47-74,79-88,170-190,199-217,296-315\n49-75,75-86,291-318\n-4-4,4-9,9-11,11-13,46-74,74-93\n-9-9,49-75\n0-18,28-46,47-58,58-75,85-107,125-133,169-191\n-1-1,1-13,13-42,125-146,156-167,167-193\n38-60,60-62,62-66,66-85,155-178,178-182\n33-54,64-88,155-176\n33-55,66-85,155-176\n22-29,30-59,59-63,63-65,65-70,70-79,156-181,181-195,259-277,277-286,286-319\n13-29,29-44,44-52,52-67,67-73,73-84,136-155,155-173,173-185,185-204,273-292,292-298,298-320\n15-29,34-41,41-49,49-72,72-83,137-155,171-197,197-211,267-285,288-314\n34-51,51-71,140-151,151-162,172-179,268-286,286-298,302-317\n33-58,58-78,162-198\n29-42,42-59,67-88,148-164,164-196\n29-56,62-79,79-90,158-179\n30-43,43-48,48-55,55-63,63-83,136-166,166-179,179-181\n28-46,46-51,51-58,58-71,71-83,83-100,149-174,174-179,179-181\n160-180\n-11-11,18-48,51-70\n171-189\n0-10,10-14,14-34,34-55,72-77,77-88,88-92\n-10-10,11-31,31-53,67-78,78-102\n0-19\n-9-9,9-12,12-19,19-35,35-39,39-44,55-73\n32-82,158-202\n39-61,61-83,162-177,177-183\n41-77,156-204\n45-84,159-201\n48-68,81-99,139-157,157-160,160-165,165-175,175-179,179-181\n-2-2,2-11,11-50,51-60,63-70,70-75,84-103,110-137,137-168,171-189\n48-69\n31-49,49-58,58-84,154-171,171-175,175-185\n33-56,61-87,151-177,179-181\n37-60,60-82,160-182,182-205,275-293,306-324\n32-58,161-174,174-179,179-180,187-209,282-300,306-324\n157-180\n3-19,30-61,61-89,149-180\n42-65,91-109,143-167,167-193\n27-60,60-73,73-91,100-115,115-124,124-134,159-201\n17-48,48-51,51-78\n129-132,158-180\n17-35,48-69,325-343\n20-38,48-70,321-338,338-350\n44-75,167-193\n38-59,59-80,161-180\n46-71,151-165,165-195\n166-194\n28-57,57-96,158-177,177-183\n39-53,58-72,75-93,109-127,163-180\n2-15,24-63,63-100,134-149,149-178,178-180\n26-57,57-63,63-93,147-172,172-178,178-182\n30-49,49-52,52-65,65-101,144-179,180-215,263-303,303-338\n20-33,33-62,68-93,141-160,160-162,162-178,178-203,203-219,267-281,281-300,304-324,324-326,326-341\n43-70,170-190\n38-50,56-60,65-72,72-91,149-169,169-191\n49-72,166-180\n48-72,168-192\n38-57,65-83,158-180\n37-63,74-85,150-168,190-208,211-229,288-305,307-324,338-365\n50-70,70-71,76-80,80-83,87-99,164-181,183-203,275-290,290-300\n294-319\n296-319\n48-80,183-192,296-314\n47-79,158-170,170-175,175-185\n41-65\n48-73\n-2-2,2-4,4-19,19-24,24-27,27-29,40-58\n36-54,54-61,61-76,167-193\n24-43,43-68,168-192\n26-38,39-69\n19-31,31-34,37-66,302-320\n174-195,276-289,289-306\n-1-1,1-22,22-35,35-47,47-66,66-76,76-86,86-93,93-96,96-121,121-128,128-140,140-148,148-170,170-190\n4-28,43-76,76-87,160-178\n39-48,62-91,154-179,179-181\n43-57,57-62,62-80,165-195\n30-77,77-81,81-94,164-196\n34-47,47-58,58-85,154-169,169-180\n48-71,167-193\n44-69,69-71,71-86\n5-29,56-87,97-115\n44-82,158-202\n47-65,165-195\n39-63,169-191\n164-196\n51-75,177-195,290-308\n163-191\n43-61,174-190,190-201,212-230,278-296\n45-68,163-190\n50-76,165-189\n51-79,155-190\n41-61,61-81,86-99,130-138,172-190\n178-198,202-229,276-308\n180-192,216-236,276-308\n189-212,218-233,266-279,285-298\n20-67,67-70,70-96,148-175,175-185\n54-85,289-316\n35-46,46-54,54-58,58-60,60-62,62-85,288-310,317-325\n44-76,163-197\n31-52,59-87,87-99,149-178,178-182\n40-78,160-200\n36-55,55-58,58-61,61-63,149-166,166-170,170-172,172-192,278-296,301-321\n42-58,61-78,78-90,152-170,178-194,194-213,270-288,293-313\n292-314\n47-71,169-191\n42-78,164-196\n30-61,61-92,144-170,170-178,178-182\n47-81,169-201,278-291,291-319\n42-81,163-200,282-318\n41-69,69-81,167-188,188-203,288-315\n46-80,167-196,290-316\n50-78,165-193,193-205,293-318\n48-76,167-203,298-320\n44-62,285-303\n47-76,165-195\n49-71,168-192\n38-84,149-165,165-195\n33-41,44-52,52-55,55-82,83-102,150-163,168-192\n26-55\n30-41,41-83,158-166,166-194\n-28-28,28-53\n-7-7,7-25,51-76,81-103,132-143,150-210\n-5-5,5-22,25-43\n0-25,38-46\n-17-17,17-25,25-28,28-37,37-44,44-45,61-69,80-100\n-11-11,22-40,155-205\n-4-4,16-30,30-60,60-90,90-111,131-142,156-176,176-180\n29-57,60-89,151-176\n35-80,152-179,179-181\n44-70,165-192,287-304\n46-77,167-193\n46-74,165-195\n43-73,168-192\n34-47,53-76,165-182,182-191,286-294,294-297,297-315\n37-45,58-76,158-175,175-179,179-196,275-297\n44-72,168-189,292-315\n51-74,167-190,282-313\n33-59,59-61,61-69,69-81,99-117,156-174,274-293,293-301,301-303,303-305,319-337\n32-45,45-50,50-51,54-58,58-59,61-65,65-67,70-74,74-75,99-117,275-293,293-295,295-298,298-306,306-318,318-336\n-2-2,2-16,32-50,97-116\n153-170,171-189\n-13-13,14-16,16-45,50-83\n-14-14,18-32,32-38,111-132,171-189\n50-71,170-190\n-12-12,171-189\n-10-10,10-33,35-54,54-66,66-79,79-90\n14-31,33-49,50-69,75-93,97-115,127-147,153-166\n6-31,31-40,40-71,71-89,89-91\n-5-5,5-19,19-23,23-45,45-49,49-53,53-63,63-78,78-102\n-12-12,49-60,60-78,98-113,113-132,168-192\n2-14,14-18,18-26,26-35,35-54,77-103\n0-11,11-35,35-55,55-57,57-63,63-71,71-89,89-91\n-1-1,1-14,14-22,22-34,34-41,41-46,46-53,53-59,59-66,66-69,69-73,73-96,96-117,117-119,119-127,127-129,129-135,135-148,148-159,159-168,168-192\n0-31,31-62,62-84,84-88,88-92\n0-28,28-42,48-62,62-80,80-94,94-104,104-114,114-138,138-142,142-150,150-158,158-160,160-174,174-180\n0-12,12-26,26-43,46-77,77-97,97-120,160-200\n-1-1,1-20,53-72,72-90,98-112,112-116,116-130,150-167\n0-19,19-49,49-89,89-91\n34-61,61-64,64-71,71-79,79-102,102-118,118-121,121-145,145-162,162-166,166-180\n-3-3,3-16,16-41,43-62\n8-25,29-51,51-53,53-57,62-72,76-94,142-160,163-178,178-182\n16-43,43-52,52-58,58-62,62-70,70-95,105-123,128-136\n-1-13,18-31,31-60,60-78,83-104,104-112,112-122,126-149,162-179\n5-17,17-46,56-69,75-88,127-145,202-220,224-235\n0-39\n19-33,33-35,37-55,162-180\n-11-11,46-74,74-87\n3-16,22-30,36-49,67-84,84-96,98-105,117-127,127-136,136-143,143-168,171-189\n31-49,97-122,122-138,138-163,169-191\n16-24,44-59,59-78,166-194\n168-192\n51-73,167-193\n168-192\n-10-10,22-42\n-18-18,29-44\n-10-10,21-27,27-45\n47-87,168-192\n37-80,80-115,159-201\n45-68,72-88,88-92,92-97,97-106,106-110,110-113,117-129,142-165,165-168,168-192\n44-66\n44-67\n-27-27,42-68\n42-84,165-195\n31-64,71-89\n36-47,60-72,72-82,135-149,153-207\n34-64\n-2-2,2-28,41-62,62-85,166-194\n-3-3,3-23,39-70\n0-29,74-117,117-154,154-170,170-190\n88-145,145-170\n-26-26,49-60,73-148,162-198\n96-144\n0-29,39-60,62-80\n0-32,34-56,56-77\n0-36,36-56,56-75\n0-33,35-56,56-64,64-80\n83-94,98-129,129-153,153-177\n-17-17,80-97,97-140,146-150,152-163,163-178\n-1-1,1-6,6-14,14-16,16-23,23-24,26-33,33-57,65-68\n0-14,32-59\n66-83,83-87,87-110\n65-86\n85-96,96-102,102-124,124-139,171-189\n69-111\n40-74,75-79,79-85,85-86\n-1-1,2-25,75-93,97-115\n72-102\n48-94,149-172,172-175,175-178,178-182\n44-76,76-78,78-80,143-159,159-180\n46-85,163-197\n-3-3,3-25,50-80\n50-69,69-77,77-95,137-155,155-179,179-181\n49-60,60-80,100-118\n39-52,52-57,57-99,115-133,165-180\n163-197\n44-62,62-63,69-72,72-106,171-189\n38-56,63-81,104-124\n64-99,99-112,171-189\n62-106,108-122,139-161,171-189\n45-55,55-92,139-157,158-176\n105-123,160-200\n34-46,47-75,77-89\n-15-15,24-68,75-96\n53-87,170-190\n56-79,167-193\n52-69,171-189\n143-170,170-190\n123-133,135-141,141-143,143-146,146-155,155-163,163-165,168-170,171-189\n3-28,92-131\n58-75,75-98,163-197\n49-80,165-195\n88-106,165-195\n49-74,88-106\n53-76\n52-73\n69-88,161-179,179-181\n53-81,166-194\n113-131,146-164,164-180\n-31-31,50-74,108-144,148-180\n-9-9,23-48\n0-16,31-48\n128-149,149-156,167-193\n-9-9,15-26,44-66\n51-106,156-204\n70-102,105-126,142-161,161-179,179-181\n68-87,87-112,112-120,120-140,140-144,148-155,157-203\n-3-3,22-76\n31-46,46-70,70-90,90-105\n49-69,84-105\n42-90,157-203\n159-201\n35-62,62-64,64-67,67-71,72-82,82-92\n53-74,74-101,112-129,160-200\n68-86,86-104,142-161,161-163,163-177,177-183\n25-71,71-76,76-92\n53-104,109-144,158-202\n162-179,179-181\n51-84,164-196\n62-80,123-144,144-154,162-164,164-174,174-180\n43-108,108-118,118-134,160-176,176-180\n-1-1,1-23,34-70,70-90\n2-12,26-59,59-87,151-176,176-184\n42-64,64-66,66-70,70-84,84-99,143-166,166-194\n36-46,46-55,59-82,135-154,154-177,177-183\n88-120,120-122,122-133\n51-77,77-95,163-197\n160-200\n159-201\n12-16,42-66,66-91\n63-74,152-165,165-168,168-180\n52-79,168-192\n56-76,166-194\n54-77,169-191\n161-199\n41-66,66-68,68-86,164-196\n35-48,53-80,80-95\n154-206\n162-198\n57-79,164-196\n59-78,83-98,98-100,100-135\n160-200\n48-94\n64-82,170-190\n63-75,75-104\n59-81,81-106\n71-100\n78-99\n67-94,95-106,168-192\n71-89,89-93,93-111,169-191\n-9-9,19-29,29-38,38-48\n-11-11\n82-105,105-115,115-142,154-173,176-184\n104-123,126-147,147-155,155-170,170-190\n-12-12,60-77,77-89,98-118\n-4-4,4-18,56-87,94-115\n-12-12,36-57,57-72,72-74,74-91,102-127\n53-83,157-203\n49-70\n56-89\n58-74,74-106,108-120,146-158,158-161,165-177\n-9-9,19-35,37-54,54-74,78-97\n48-80,80-101,155-205\n36-57\n123-151\n170-190\n168-192\n-6-6,6-26,107-126,151-173\n-17-17,31-46,65-85,93-149\n39-51,63-77,77-82,82-97,97-100,100-130,130-163,163-178,178-182\n0-19,19-22,22-56,56-69\n0-26,34-50,55-75\n48-80,166-194\n46-71,71-77,77-96,158-202\n45-70\n41-78\n-12-12,52-83,163-197\n37-62\n141-153,153-155,161-180\n-14-14,140-151,155-205\n24-43,52-56,56-60,60-72,72-76,76-80,80-91,94-114,122-140,155-173\n-23-23\n-23-23\n144-164,164-196\n-10-10\n-12-12\n63-119,157-203\n92-128,128-135,135-138,138-140,146-214\n117-126,126-140,148-180\n99-111,111-117,117-131,134-180\n48-69\n0-27,35-72,83-104\n43-70,81-104\n-23-23,47-67\n54-118,152-208\n121-133,136-178,178-182\n7-27,36-68,68-78,78-98\n36-67\n50-121,160-200\n64-101,103-139,139-142,142-145,151-209\n0-3,24-62,76-98\n15-28,28-31,34-66,69-91\n46-101,161-199\n8-27,37-67,72-94\n143-170,170-177,177-183\n46-75,81-105\n17-45,68-86\n16-41\n51-81,143-161,161-180\n79-105,110-124,141-219\n113-145,145-152,152-154,154-157,157-165,165-195\n50-83,83-106\n35-59,67-94,94-131,131-152,152-155,155-177,177-180\n107-120,120-127,127-146,146-152,152-156,156-204\n14-30,30-41,41-52,52-63\n81-100,101-119,145-170,170-180\n65-105,105-125,125-131,131-134,134-180\n88-115,115-146,146-156,156-160,160-163,163-175,175-185\n79-97,100-123,131-153,157-175\n43-72,72-94,97-119\n-13-13,41-69,83-104\n-13-13,47-66\n109-133,140-157,157-203\n25-46,52-65,71-95\n52-85,157-203\n58-79\n53-76,163-197\n38-70,163-180\n28-39,55-77,170-190\n4-24,24-39,53-79,143-159,165-195\n55-79,151-169\n94-121,154-168,168-172,172-188\n69-87,87-99,99-106,106-120,120-126,129-137,137-140,140-142,164-180\n48-70,83-101\n48-72\n-11-11,164-196\n-10-10,15-36\n-13-13,164-196\n-16-16,35-55\n106-137,137-147,153-207\n120-140,161-199\n-10-10,24-43,48-75\n169-191\n163-197\n165-195\n-25-25,25-51\n-9-9,18-36\n168-192\n166-194\n61-88,88-104,104-130,130-149,149-211\n62-98,98-123,136-154\n61-84,84-92,92-114,114-140,140-143,143-147,147-152\n60-95,95-105,105-112,112-130,130-149,171-189\n53-83,159-201\n165-195\n43-91,166-194\n-13-13,47-67\n62-85,85-89,89-103,116-136,157-175\n16-37,37-54\n57-92\n28-55\n45-93,93-97,97-111,118-132,132-138,142-152,152-180\n69-83,83-103,103-126,138-156,156-166,166-176,176-179,179-181\n54-94,166-194\n0-22,48-66\n0-28,49-57\n0-19\n164-196\n41-83,163-197\n55-72,72-74,74-83,83-96,110-121,121-129,148-180\n-17-17,48-67\n-20-20,48-69\n74-103,171-189\n103-122,156-180\n145-179,179-181\n54-74\n-14-14,169-191\n168-192\n-12-12,84-102,102-128,128-130,130-144,144-159\n-16-16,105-147\n1-26,67-81,81-99,102-117,117-141,141-144,144-156,156-158,158-169,169-171,171-174,174-186\n-1-1,1-40,49-54,54-78\n0-24,24-49,58-84\n145-157,157-159,159-201\n46-81,164-196\n17-35,47-71,71-79,79-98,158-202\n0-26,45-67\n-19-19,42-66,72-90\n-13-13,39-67\n43-79,162-198\n34-65,74-89\n-10-10,27-51\n-9-9\n167-193\n166-194\n156-204\n-9-9\n-9-9\n169-191\n164-196\n55-105,161-199\n62-130,130-132,132-228\n87-95,141-161,161-199\n69-80,80-83,87-136,169-191\n74-96,99-108,155-205\n44-70\n-9-9,9-51,51-53,53-84\n40-69\n7-24,24-42,64-78,83-97\n40-70\n47-66,66-91,159-201\n61-89,89-92,92-95,95-118,118-124,124-149,149-180\n155-180\n32-46,46-63\n43-60,60-80,80-94,130-149,149-159,159-201\n65-106,113-117,117-133,160-200\n72-82,82-85,85-89,89-112,112-122,122-128,128-132,132-142,142-162,162-170,170-180\n-4-4,9-25,25-60\n17-40,40-71,72-93\n51-89,130-149,154-180\n60-113,124-129,129-143,143-148,154-206\n78-98,100-136,136-138,138-147,147-158,158-202\n93-148,166-180\n99-151,167-193\n0-27,27-51,54-82\n89-107,107-109,126-137,137-158,160-180\n0-7,7-9,9-13,13-18,18-38,38-54,99-148,148-154,154-166,171-189\n-13-13,41-59,59-79\n166-194\n-13-13,104-141\n161-199\n49-82,163-197\n123-150,152-170,170-180\n-6-6,6-10,10-27,45-66\n0-24,40-66,71-97\n44-66\n51-77,163-197\n36-68\n47-95,158-202\n139-154,156-204\n137-156,160-200\n46-66\n42-83,159-201\n60-75,75-81,149-180\n37-57\n166-194\n67-102,102-120,120-126,126-138,138-158,158-162,162-198\n90-108,108-134,138-141,144-162\n-8-8,8-29,29-47,49-83\n45-56,62-70,70-80,80-101,101-107,107-108,116-117,119-126,159-180\n166-194\n166-194\n84-114\n84-106,106-110,110-120,120-144,155-178,178-182\n138-155,155-158,158-166,166-180\n70-112,112-114,114-134,134-178,178-182\n113-148,148-168,168-192\n44-74\n48-82,89-113,113-127,127-132,132-147,147-153,153-160,160-162,162-179,179-181\n14-45\n65-88,88-96,96-103,103-105,105-125,125-150,150-154,154-157,157-179,179-181\n-5-5,5-30,43-68\n71-94,94-102,102-126,126-146,146-174,175-185\n-12-12,41-87,161-199\n56-80,80-85,157-177,177-180\n52-71\n53-64,64-99\n25-54,54-57,66-81,81-104\n52-80,80-82,82-95,167-193\n53-75,169-191\n33-47,47-61,61-72,163-179,179-181\n57-83,146-168,169-191\n74-92,104-123,123-138,138-152,152-154,154-158,158-163,163-178\n46-73,73-93,164-196\n54-87,152-180\n54-86,164-180\n-4-4,11-32,32-35,35-39,39-42,42-62,68-100\n-10-10,169-191\n-12-12\n-10-10,170-190\n163-197\n160-200\n0-2,2-31,31-45,45-54,54-65\n156-204\n84-101,101-103,103-123,123-144,144-152,152-160\n64-80,80-106,106-111,111-135\n57-99,165-195\n146-156,156-180\n13-33,42-77\n55-92,160-200\n48-83,160-200\n48-67\n50-68\n56-96,121-141,147-163,163-177,177-180\n50-73\n35-60\n44-82,155-205\n48-75,75-95,164-196\n49-67\n47-67\n-2-2,2-5,170-190\n162-198\n0-24\n190-212,240-255,255-274\n-1-1,1-5,5-20,20-27,27-29,29-32,32-47,77-96,96-122\n-3-3,3-27,27-46,46-51,51-54,54-74,74-82,82-86,86-90\n-19-19,68-90\n111-123,123-149,158-169,169-191\n-5-24,24-36,36-60,147-175\n-9-17,17-27,27-39,39-41,41-64,64-74,143-171\n-9-5,5-40\n-4-5,7-12,12-42\n23-35,43-65,75-95\n36-71\n-2-16,22-40,44-62,250-272,342-358\n59-82\n69-95,95-122,168-185,185-197,197-200,207-216,216-229\n78-105\n210-232,275-293,304-322,322-329\n211-246\n263-286,287-306,306-308,308-322,327-349\n264-276,276-281,281-311,313-323\n248-270,270-290,290-293,293-297,297-307,307-326\n152-160,166-169,169-189,189-217,248-266\n158-195,195-196,217-235\n-11-11,159-201\n-5-5,95-113,121-149,149-167,167-173,173-187\n8-37,303-323,323-356\n17-35,301-312,312-314,314-357,357-372\n48-68,68-71,71-84,154-164,164-168,173-176,176-184\n132-165,165-195\n104-130,143-168,168-180\n342-370\n2-4,4-22,22-30,30-40,295-316,316-327,330-344,344-362\n45-76,168-197\n46-64,64-79\n57-87,192-215\n52-69,69-80,192-223,230-248\n59-79,184-220,220-222,222-240,240-246,275-284,296-307\n45-62,62-83,90-98,181-198,201-218\n272-291,291-300,300-323,329-347\n210-221,221-223,223-242,274-285,285-297,298-323,326-347\n269-287,298-323,323-352\n50-68,71-90,178-205,211-221\n48-66,70-88,179-198\n63-81,90-108,172-194,194-212\n-9-9,9-13,13-28,28-32,32-35,35-54\n-9-12,15-42\n-9-5,5-22,25-48,156-171\n-10-18,26-44,144-162\n13-42,166-184,339-357\n167-193\n50-90\n-17-17\n-6-7,7-30,30-33,33-37,37-58,151-169,169-174\n-19-6,6-18,18-26,26-51,51-67\n-11-5,5-23,129-137,149-169\n-13-32,138-147\n64-90\n89-115\n167-193\n76-104\n-17-17\n-5-13,158-186\n110-125,125-138,138-141,147-180\n1-4,4-16,21-34,324-361\n3-8,324-363\n21-40,45-67,67-77,77-96,96-116,116-132,150-172,172-188\n-11-11,11-51\n33-77,81-99\n47-90\n39-87,87-100,100-104,104-140\n60-120\n56-124\n-12-12,35-61\n-23-23,28-54\n124-174,174-186\n18-42,42-68\n-20-20,20-23,23-46\n27-58,117-128,128-142,142-144,144-171,171-176,176-184\n-6-6,6-14,14-30,79-101\n-1-1,17-63,78-102\n48-72,126-149,168-192\n-2-2,12-56,56-78,78-82,82-85,85-95\n25-38,38-42,42-46,46-71,82-100,100-108,108-131\n43-56,56-59,59-73,73-76,76-87,87-93\n29-81,81-99\n36-85,85-102,102-142\n44-71,71-109\n-13-13,13-43\n130-154,159-201\n121-136,136-138,138-164,164-196\n0-6,18-90\n0-25,25-58\n41-87,87-92,92-96,96-127,127-145\n44-74,74-87,87-93\n0-9,9-41,41-66,66-80,80-100\n0-41,41-54,54-58,70-88\n61-96,96-104,104-107,107-109,109-138\n30-48,48-56,56-62,62-65,65-74,74-86,86-94\n0-28,28-62,76-86\n35-80,86-107,107-127,127-142,142-163,163-170,170-177,177-179,179-181\n0-15,32-46,46-66,66-82,82-85,85-89,89-91\n-2-2,2-33,33-36,36-43,43-76,76-88,88-90\n52-68,68-79,82-100,112-130,162-179\n-2-2,2-61\n10-17,21-42,42-60\n-27-27,40-48,48-60,60-73\n-1-1,1-14,14-24,24-26,26-43,43-57,57-74\n109-148\n114-132,132-154,154-167,167-193\n154-206\n169-191\n155-165,171-189\n-11-11,11-37\n-18-18,18-33\n33-83,88-92\n45-80,80-106,106-136\n51-129\n-7-7,7-79\n42-83,83-98,98-138\n43-63,63-67,67-81,81-99\n31-68\n18-68\n158-202\n132-149,149-174,174-179,179-181\n0-18,18-45,45-50,50-53,53-63\n0-27,41-59\n-11-11,24-45,45-49,49-51,51-53,53-67,129-164\n34-61,99-117,120-146\n39-72,72-81,81-101,106-132,132-151\n31-61\n36-56,56-77,77-97,97-114\n-9-9,138-153,153-155,157-203\n50-61,61-83,98-117,117-124,124-128,128-130,130-151,151-166\n37-68,110-128,136-160\n37-59,59-80,80-86,105-120,124-139\n-2-2,2-16,147-165,165-170,171-189\n33-45,45-55,55-80,93-104,125-146,150-169,169-191\n36-63,118-147\n45-61,61-65,65-97,97-118,118-138\n40-55,55-76,76-82,82-85,85-110,110-113,113-137,137-149,149-165\n-9-9,34-79,79-89,89-92,92-94,94-98,98-103,103-109,120-149,167-193\n-12-12,33-69,69-73,73-95,118-143,163-197\n51-76,82-98,101-117,140-167\n11-19,171-189\n-10-10,151-155,160-169,169-180\n-9-9,12-38,162-180\n58-87,87-89\n41-68\n139-149,170-190\n141-164,164-167,167-180\n155-205\n-27-27,32-56\n-16-16,29-48\n50-94,103-123,123-149,171-189\n41-50,77-95,154-180\n34-70,114-123,126-135,135-139,139-142,145-167\n14-27,27-38,42-62,68-78,94-112,154-180\n-18-18,28-36,36-43,43-60\n-11-11,11-28,31-51\n45-73,73-95,95-98,98-132,132-139,147-167\n23-42,42-46,46-54,54-71,148-166,171-189\n29-52,53-74,74-75,80-90\n-18-18,30-57\n51-85,161-199\n-18-18,18-38,38-71,167-193\n-10-10,47-64,64-84,161-199\n-9-9,63-83,168-192\n273-286,295-320,326-343\n293-321\n60-77,154-166,166-188,236-246,312-330\n8-32,36-45,45-65,65-81,154-162,169-188,222-232,232-236,241-251\n39-63,63-81\n42-73,91-102,107-116\n151-190,190-208,226-253,275-305\n146-156,156-162,163-192,192-212,271-303\n-10-17,36-69,292-343\n-1-22,35-71,292-336,340-359\n18-43,44-70,302-324,346-370\n-7-9,14-28,28-46,46-49,49-51,51-57,57-71,301-309,319-334,334-337,337-340,340-350\n141-151,180-207,275-300\n143-161,176-194,266-297\n-4-13,13-25,36-67,296-330\n-1-22,31-69,298-330,349-359\n27-62,300-330\n32-63,301-324\n50-58,71-89,173-191,192-209,266-283,283-286,286-301\n35-59,59-71,176-194,270-296\n40-63,63-70,70-88,161-183,282-310,310-315\n44-76,76-89,136-144,155-170,170-181,285-302,302-325\n22-32,32-36,36-38,38-69\n-9-9,31-44,44-47,47-70,293-311\n33-55,302-323\n-14-14,36-69,167-193\n-10-10,37-67\n171-192\n59-84,84-100,164-195\n-21-21,34-67,74-90\n56-79,79-97,140-158,158-165,165-185\n57-75,75-79,79-82,82-84,84-86,86-98,156-176,176-198\n37-72,294-328\n32-70,294-324,324-341,341-349\n62-80,167-192\n161-197\n39-62\n32-47,47-63,298-316\n40-58,160-168,170-192,295-313,313-335\n71-94,117-144,149-188\n64-81,81-91,91-93,93-101,101-117,117-141,141-164,164-193\n46-82,166-194\n62-93,161-188\n63-90,141-166,166-185\n171-192\n171-190\n23-41,43-61,76-94,115-123,170-190,284-294,294-310\n175-221,288-311\n49-75,175-217,283-312\n35-67\n-5-13,36-69,74-84\n167-195\n170-197\n51-80,105-117,117-124,128-142,157-186,281-311\n51-76,282-304\n7-26,26-31,34-66,167-194,283-318\n27-69,166-209,282-319\n167-200,215-238\n168-183,183-202,217-235\n55-77,149-180,285-308\n57-81,154-181,286-307\n43-79,162-198\n47-73,166-194\n-12-12,40-65,65-85,157-180\n40-96,160-180\n54-68,73-87,152-178,178-180\n18-34,34-44,44-49,49-54,54-64,64-68,68-84,84-97,167-193\n123-131,155-170,170-179,179-181\n164-180\n169-191\n171-189\n169-191\n39-65\n-1-1,1-3,3-5,5-15,34-62\n19-37,43-66\n3-10,32-68\n-13-13,13-28,28-48,48-65\n43-78,160-200\n54-74,165-195\n34-62,68-86\n33-62\n36-74,165-195\n43-84,164-180\n170-190\n171-189\n25-62,71-88\n-12-12,25-54\n41-77,162-180\n47-74,167-193\n147-177\n44-64\n39-53,53-57,57-65,65-82,164-180\n66-85,171-189\n40-78,84-88,165-195\n282-298,298-316\n286-313\n42-72,88-112\n46-73,93-111\n37-72,87-105\n42-65,76-98\n181-204,259-267,277-306\n180-190,190-192,192-199,199-210,276-306\n31-43,45-65,296-328\n294-320\n-1-20,25-37,37-69,296-319,338-359\n40-67,295-319,329-348,348-370\n38-69,264-277,277-313\n23-39,39-50,50-68,283-321\n22-40,295-317\n51-68,68-86,159-176,176-178,178-199\n59-89,155-177,177-180,180-195\n172-197,201-216,268-281,281-290,290-303,303-313\n171-185,185-211,268-283,283-303\n190-208,263-292\n188-210,259-282\n0-23,23-36,46-58,58-61,65-77,82-98,98-103,103-116,133-151,165-176,176-184\n0-27,119-177\n-14-14,14-50\n0-22,162-179,179-181\n-1-1,1-17,95-122,122-124,124-136,147-170\n-2-2,2-8,8-26,110-152,155-174\n-3-3,3-16,18-55,107-123,123-144,146-176\n-11-11\n-1-1,1-33,129-149,154-180\n-26-26,33-50,102-161,161-168,168-180\n17-25,85-94,100-103,103-132,132-136,136-154,154-156,156-172\n147-158,158-165,171-189\n149-167,171-189\n-13-13\n-1-1,1-20,34-45\n0-18\n54-81,81-116,116-151\n52-73,77-80,81-123,123-126,126-145\n95-121,121-124\n-26-26,26-28,28-31,31-50,164-171,179-181\n-4-4,4-15,123-142,142-148,148-162,162-178\n171-189\n0-18,30-48,144-180\n0-14,14-20,20-21,109-151,155-178,178-182\n153-166,170-190\n54-72,100-126\n56-69,69-86,86-89,89-92,92-115,118-125\n171-189\n111-139,139-161,311-323,323-344,344-348,348-370\n116-134,288-299,299-319,319-343\n0-18,41-59,329-358\n-13-7,7-9,9-11,11-13,13-37,326-335\n-7-14,14-30,328-353\n1-31,293-319,323-342,342-361\n0-4,4-16,101-125,227-234,234-266,312-336,336-349,349-356,356-360\n91-107,107-109,109-127,225-248,248-251,251-271,271-286,291-309,309-329,335-364\n63-75,75-78,82-86,91-102,102-106,106-111,111-133,262-275,280-287,294-322\n91-124,124-133,176-194,258-276,292-310,342-350\n-3-24,24-39