!function(n,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((n="undefined"!=typeof globalThis?globalThis:n||self).nmrProcessing={})}(this,(function(exports){"use strict";const gyromagneticRatio={"1H":267522187.44,"2H":41065e3,"3H":285350800,"3He":-203789e3,"7Li":103962e3,"13C":67282840,"14N":19331e3,"15N":-27116e3,"17O":-36264e3,"19F":251662e3,"23Na":70761e3,"27Al":69763e3,"29Si":-5319e4,"31P":108291e3,"57Fe":8681e3,"63Cu":71118e3,"67Zn":16767e3,"129Xe":-73997e3};function getGyromagneticRatio(n){if(gyromagneticRatio[n])return gyromagneticRatio[n];if("proton"===(n=n.toLowerCase()))return gyromagneticRatio["1H"];const t=n.replace(/[^0-9]/g,"");if(!t)return null;for(const n in gyromagneticRatio)if(n.includes(t))return gyromagneticRatio[n];return null}const impuritiesContent={cdcl3:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"ds",shift:7.26}],h2o:[{proton:"H2O",coupling:0,multiplicity:"bs",shift:1.56}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.17}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.28}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.19},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.98},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.01},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.27},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.43}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.26}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.73}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.3}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.21},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.48}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.65},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.57},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.39}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.4},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.55}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.09},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.02},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.88}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.62}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.71}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.25},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.72},{proton:"OH",coupling:5,multiplicity:"s,t",shift:1.32}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.05},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.12},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.14},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.46},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.06}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.76}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.26}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.26}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.65}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.49},{proton:"OH",coupling:0,multiplicity:"s",shift:1.09}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.33}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:7},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.22},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.04}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.62},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.29},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.68}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.07}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.85},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.76}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.17},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.03},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.53}]},"(cd3)2co":{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:2.05}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.84}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.05}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.13},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.96},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.41}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.87}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.63}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.41}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.56},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.47},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.28}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.46}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.78}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.52}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.59}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.57},{proton:"OH",coupling:5,multiplicity:"s,t",shift:3.39}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.05},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.45},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.28}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.87},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.59}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"OH",coupling:0,multiplicity:"s",shift:3.12}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.43}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.1},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.9}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.35},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.76}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.13}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.79},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.63}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.5},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.5}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},dmso:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"quint",shift:2.5}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:3.33}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.91}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.07}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.19}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.08}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.87},{proton:"OHc",coupling:0,multiplicity:"s",shift:6.65},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.18},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.36}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.32}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.76}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.09},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.38}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.51},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.38},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.24}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.24},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.43}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.78}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.95},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.73}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.54}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.57}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.06},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.44},{proton:"OH",coupling:5,multiplicity:"s,t",shift:4.63}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.99},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.03},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.17}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.91}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.34}],"grease^f":[],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.25}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.53}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.16},{proton:"OH",coupling:0,multiplicity:"s",shift:4.01}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.42}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.04},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.78}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.39},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.79}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.76},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.6}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.3},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.18},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.93},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.43}]},c6d6:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:7.16}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:.4}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.15}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:1.55}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.07},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.04}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:7.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.79},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.24},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.38}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:6.15}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:2.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:4.27}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.26}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.46},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.34},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.11}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.12},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.33}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.6},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.57},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.05}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.63},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH3",coupling:0,multiplicity:"s",shift:1.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.68}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.35}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.34}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.65},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.89},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.92}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.58},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:1.81},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.85}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.41}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.92},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.36}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.24}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.4}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.07}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.23}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:.95},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.67}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:6.66},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:6.98}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.29}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.4},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.57}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.11},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.02},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.13}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.4}]},cd3cn:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:1.94}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.13}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.16},{proton:"OHc",coupling:0,multiplicity:"s",shift:2.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.14},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.97},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.2},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.39}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.58}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.44}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.81}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.44}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.42}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.53},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.45},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.29}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.45}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.77}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.5}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.54},{proton:"OH",coupling:5,multiplicity:"s,t",shift:2.47}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.06},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.06},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.51}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.27}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.57}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"OH",coupling:0,multiplicity:"s",shift:2.16}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.31}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.87},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.09},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.87}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.57},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.33},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.73}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.08}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.8},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.64}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.33},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.2},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.2}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},cd3od:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:3.31}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:4.87}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.99}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.15}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.03}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.33}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.4}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.15},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.2}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.92},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.21},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.4}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.9}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.45}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.78}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.49}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.18},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.49}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.58},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.35}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.35},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.52}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.92}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.97},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.99},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.65}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.66}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.19},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.6}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.01},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.09},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.12},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.5},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.01}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.59}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.88},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.9},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.64}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.34}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.5},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.92}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.44},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.85}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.1}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.87},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.71}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.16},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.16}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.05},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.58}]},d2o:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:4.79}],h2o:[],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.22}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.06}],benzene:[],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.24}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.21},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[],chloroform:[],cyclohexane:[],"1,2-dichloroethane":[],dichloromethane:[],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.56}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.67},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.37}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.37},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.08},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.06},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.9}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:3.01},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.85}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.71}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.75}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.65}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.14},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.19},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.18},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.65}],"grease^f":[],"n-hexane":[],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.61}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.4}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.9}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.17},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.02}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.52},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.45},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.87}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.88},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.74}],toluene:[],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.99},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.57}]}},impurities=impuritiesContent,SignalKinds=[{label:"Signal",value:"signal"},{label:"Reference",value:"reference"},{label:"Solvent",value:"solvent"},{label:"Impurity",value:"impurity"},{label:"Standard",value:"standard"},{label:"P1",value:"p1"},{label:"P2",value:"p2"},{label:"P3",value:"p3"}],SignalKindsToInclude=["signal"],DatumKind={signal:"signal",mixed:"mixed"},MultiplicityPatterns=[{label:"singlet",value:"s",multiplicity:1,names:["br s","br. s"]},{label:"triplet",value:"t",multiplicity:3,names:[]},{label:"doublet",value:"d",multiplicity:2,names:[]},{label:"quartet",value:"q",multiplicity:4,names:[]},{label:"quintet",value:"i",acs:"quint",multiplicity:5,names:["quint","qui","qnt","pentet","pnt","pent"]},{label:"sextet",value:"h",multiplicity:6,names:["x","sxt","sext","hexuplet"]},{label:"septet",value:"p",acs:"sept",multiplicity:7,names:["sept","spt","heptet","hpt","hept"]},{label:"octet",value:"o",multiplicity:8,names:["oct"]},{label:"nonet",value:"n",multiplicity:9,names:["non"]},{label:"massive",value:"m",multiplicity:null,names:[]}];MultiplicityPatterns.sort(((n,t)=>null!==n.multiplicity&&null!==t.multiplicity?n.multiplicity-t.multiplicity:Number.MAX_SAFE_INTEGER));const couplingPatterns=MultiplicityPatterns.map((n=>n.value)),couplingACSPatterns=MultiplicityPatterns.map((n=>n.acs||n.value)),toCheck=["solvent","h2o","tms"];function peaksFilterImpurities(n,t={}){const{error:e=.025,remove:i=!1}=t;if(t.solvent){let{solvent:s}=t;"(cd3)2so"===s&&(s="dmso"),"meod"===s&&(s="cd3od");const r=impurities[s];for(const t of toCheck){checkImpurity(n,r[t],{error:e,remove:i,name:t})}}return n}function checkImpurity(n,t,e){const{name:i,error:s,remove:r}=e;let a,o,l,f=t.length;for(;f--;)for(a=n.length;a--;)o=s+n[a].width,l=Math.abs(t[f].shift-n[a].x),l<o&&(r?n.splice(a,1):n[a].kind=i)}const GAUSSIAN_EXP_FACTOR=-4*Math.LN2,ROOT_PI_OVER_LN2=Math.sqrt(Math.PI/Math.LN2),ROOT_THREE=Math.sqrt(3),ROOT_2LN2=Math.sqrt(2*Math.LN2),ROOT_2LN2_MINUS_ONE=Math.sqrt(2*Math.LN2)-1;function erfinv(n){if(0===n)return 0;let t=Math.log(1-n*n),e=t/2+2/(.147*Math.PI),i=Math.sqrt(e**2-t/.147);return Math.sqrt(i-e)*(n>0?1:-1)}class Gaussian{constructor(n={}){const{fwhm:t=500,sd:e}=n;this.fwhm=e?gaussianWidthToFWHM(2*e):t}fwhmToWidth(n=this.fwhm){return gaussianFwhmToWidth(n)}widthToFWHM(n){return gaussianWidthToFWHM(n)}fct(n){return gaussianFct(n,this.fwhm)}getArea(n=calculateGaussianHeight({fwhm:this.fwhm})){return getGaussianArea({fwhm:this.fwhm,height:n})}getFactor(n){return getGaussianFactor(n)}getData(n={}){return getGaussianData(this,n)}calculateHeight(n=1){return calculateGaussianHeight({fwhm:this.fwhm,area:n})}getParameters(){return["fwhm"]}}function calculateGaussianHeight(n){let{fwhm:t=500,area:e=1,sd:i}=n;return i&&(t=gaussianWidthToFWHM(2*i)),2*e/ROOT_PI_OVER_LN2/t}function gaussianFct(n,t){return Math.exp(GAUSSIAN_EXP_FACTOR*Math.pow(n/t,2))}function gaussianWidthToFWHM(n){return n*ROOT_2LN2}function gaussianFwhmToWidth(n){return n/ROOT_2LN2}function getGaussianArea(n){let{fwhm:t=500,sd:e,height:i=1}=n;return e&&(t=gaussianWidthToFWHM(2*e)),i*ROOT_PI_OVER_LN2*t/2}function getGaussianFactor(n=.9999){return Math.sqrt(2)*erfinv(n)}function getGaussianData(n={},t={}){let{fwhm:e=500,sd:i}=n;i&&(e=gaussianWidthToFWHM(2*i));let{length:s,factor:r=getGaussianFactor(),height:a=calculateGaussianHeight({fwhm:e})}=t;s||(s=Math.min(Math.ceil(e*r),Math.pow(2,25)-1),s%2==0&&s++);const o=(s-1)/2,l=new Float64Array(s);for(let n=0;n<=o;n++)l[n]=gaussianFct(n-o,e)*a,l[s-1-n]=l[n];return l}class Lorentzian{constructor(n={}){const{fwhm:t=500}=n;this.fwhm=t}fwhmToWidth(n=this.fwhm){return lorentzianFwhmToWidth(n)}widthToFWHM(n){return lorentzianWidthToFWHM(n)}fct(n){return lorentzianFct(n,this.fwhm)}getArea(n=1){return getLorentzianArea({fwhm:this.fwhm,height:n})}getFactor(n){return getLorentzianFactor(n)}getData(n={}){return getLorentzianData(this,n)}calculateHeight(n=1){return calculateLorentzianHeight({fwhm:this.fwhm,area:n})}getParameters(){return["fwhm"]}}const calculateLorentzianHeight=({fwhm:n=1,area:t=1})=>2*t/Math.PI/n,getLorentzianArea=n=>{const{fwhm:t=500,height:e=1}=n;return e*Math.PI*t/2},lorentzianFct=(n,t)=>t**2/(4*n**2+t**2),lorentzianWidthToFWHM=n=>n*ROOT_THREE,lorentzianFwhmToWidth=n=>n/ROOT_THREE,getLorentzianFactor=(n=.9999)=>{if(n>=1)throw new Error("area should be (0 - 1)");const t=.5*(1-n),e=n=>Math.tan(Math.PI*(n-.5));return(e(1-t)-e(t))/2},getLorentzianData=(n={},t={})=>{let{fwhm:e=500}=n,{length:i,factor:s=getLorentzianFactor(),height:r=calculateLorentzianHeight({fwhm:e,area:1})}=t;i||(i=Math.min(Math.ceil(e*s),Math.pow(2,25)-1),i%2==0&&i++);const a=(i-1)/2,o=new Float64Array(i);for(let n=0;n<=a;n++)o[n]=lorentzianFct(n-a,e)*r,o[i-1-n]=o[n];return o};class PseudoVoigt{constructor(n={}){const{fwhm:t=500,mu:e=.5}=n;this.mu=e,this.fwhm=t}fwhmToWidth(n=this.fwhm,t=this.mu){return pseudoVoigtFwhmToWidth(n,t)}widthToFWHM(n,t=this.mu){return pseudoVoigtWidthToFWHM(n,t)}fct(n){return pseudoVoigtFct(n,this.fwhm,this.mu)}getArea(n=1){return getPseudoVoigtArea({fwhm:this.fwhm,height:n,mu:this.mu})}getFactor(n){return getPseudoVoigtFactor(n)}getData(n={}){const{length:t,factor:e,height:i=calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:1})}=n;return getPseudoVoigtData(this,{factor:e,length:t,height:i})}calculateHeight(n=1){return calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:n})}getParameters(){return["fwhm","mu"]}}const calculatePseudoVoigtHeight=(n={})=>{let{fwhm:t=1,mu:e=.5,area:i=1}=n;return 2*i/(t*(e*ROOT_PI_OVER_LN2+(1-e)*Math.PI))},pseudoVoigtFct=(n,t,e)=>(1-e)*lorentzianFct(n,t)+e*gaussianFct(n,t),pseudoVoigtWidthToFWHM=(n,t=.5)=>n*(t*ROOT_2LN2_MINUS_ONE+1),pseudoVoigtFwhmToWidth=(n,t=.5)=>n/(t*ROOT_2LN2_MINUS_ONE+1),getPseudoVoigtArea=n=>{const{fwhm:t=500,height:e=1,mu:i=.5}=n;return t*e*(i*ROOT_PI_OVER_LN2+(1-i)*Math.PI)/2},getPseudoVoigtFactor=(n=.9999,t=.5)=>t<1?getLorentzianFactor(n):getGaussianFactor(n),getPseudoVoigtData=(n={},t={})=>{let{fwhm:e=500,mu:i=.5}=n,{length:s,factor:r=getPseudoVoigtFactor(.999,i),height:a=calculatePseudoVoigtHeight({fwhm:e,mu:i,area:1})}=t;a||(a=1/(i/Math.sqrt(-GAUSSIAN_EXP_FACTOR/Math.PI)*e+(1-i)*e*Math.PI/2)),s||(s=Math.min(Math.ceil(e*r),Math.pow(2,25)-1),s%2==0&&s++);const o=(s-1)/2,l=new Float64Array(s);for(let n=0;n<=o;n++)l[n]=pseudoVoigtFct(n-o,e,i)*a,l[s-1-n]=l[n];return l};class Gaussian2D{constructor(n={}){let{fwhm:t=20,sd:e}=n;t=ensureFWHM2D(t,e),this.fwhmX=t.x,this.fwhmY=t.y}fct(n,t){return gaussian2DFct(n,t,this.fwhmX,this.fwhmY)}getData(n={}){return getGaussian2DData({fwhm:{x:this.fwhmX,y:this.fwhmY}},n)}getFactor(n=1){return getGaussianFactor(n)}getVolume(n=calculateGaussian2DHeight({fwhm:{x:this.fwhmX,y:this.fwhmY},volume:1})){return getGaussian2DVolume({fwhm:{x:this.fwhmX,y:this.fwhmY},height:n})}widthToFWHM(n){return gaussianWidthToFWHM(n)}fwhmToWidth(n){return gaussianFwhmToWidth(n)}calculateHeight(n=1){return calculateGaussian2DHeight({volume:n,fwhm:{x:this.fwhmX,y:this.fwhmY}})}set fwhm(n){n=ensureXYNumber$2(n),this.fwhmX=n.x,this.fwhmY=n.y}}const gaussian2DFct=(n,t,e,i)=>Math.exp(GAUSSIAN_EXP_FACTOR*(Math.pow(n/e,2)+Math.pow(t/i,2))),getGaussian2DData=(n,t={})=>{let{fwhm:e=50,sd:i}=n;e=ensureFWHM2D(e,i);let{factor:s=getGaussianFactor(),length:r={x:0,y:0},height:a=calculateGaussian2DHeight({fwhm:e,volume:1})}=t;s=ensureXYNumber$2(s),r=ensureXYNumber$2(r);for(const n of["x","y"])r[n]||(r[n]=Math.min(Math.ceil(e[n]*s[n]),Math.pow(2,25)-1),r[n]%2==0&&r[n]++);const o=(r.x-1)/2,l=(r.y-1)/2,f=new Array(r.x);for(let n=0;n<r.x;n++)f[n]=new Float64Array(r.y);for(let n=0;n<r.x;n++)for(let t=0;t<r.y;t++)f[n][t]=gaussian2DFct(n-o,t-l,e.x,e.y)*a;return f},calculateGaussian2DHeight=(n={})=>{let{volume:t=1,fwhm:e=50,sd:i}=n;return e=ensureFWHM2D(e,i),t*Math.LN2*4/(Math.PI*e.y*e.x)},getGaussian2DVolume=(n={})=>{let{fwhm:t=50,height:e=1,sd:i}=n;return t=ensureFWHM2D(t,i),e*Math.PI*t.y*t.x/Math.LN2/4};function ensureXYNumber$2(n){return"object"!=typeof n?{x:n,y:n}:{...n}}function ensureFWHM2D(n,t){if(void 0!==t){let n=ensureXYNumber$2(t);return{x:gaussianWidthToFWHM(2*n.x),y:gaussianWidthToFWHM(2*n.y)}}if(void 0!==n)return ensureXYNumber$2(n);throw new Error("ensureFWHM2D must have either fwhm or sd defined")}function getShape1D(n){const{kind:t}=n;switch(t){case"gaussian":return new Gaussian(n);case"lorentzian":return new Lorentzian(n);case"pseudoVoigt":return new PseudoVoigt(n);default:throw Error(`Unknown distribution ${t}`)}}function getShape2D(n){const{kind:t}=n;if("gaussian"===t)return new Gaussian2D(n);throw Error(`Unknown distribution ${t}`)}function addBaseline(n,t){if(!t)return n;const e=n.x,i=n.y;for(let n=0;n<e.length;n++)i[n]+=t(e[n]);return n}function reimAbsolute(n){const t=n.re.length,e=n.re,i=n.im,s=new Float64Array(t);for(let n=0;n<t;n++)s[n]=Math.sqrt(e[n]**2+i[n]**2);return s}var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function getAugmentedNamespace(n){if(n.__esModule)return n;var t=Object.defineProperty({},"__esModule",{value:!0});return Object.keys(n).forEach((function(e){var i=Object.getOwnPropertyDescriptor(n,e);Object.defineProperty(t,e,i.get?i:{enumerable:!0,get:function(){return n[e]}})})),t}var d3Array={exports:{}};!function(n,t){!function(n){function t(n,t){return n<t?-1:n>t?1:n>=t?0:NaN}function e(n){return 1===n.length&&(n=i(n)),{left:function(t,e,i,s){for(null==i&&(i=0),null==s&&(s=t.length);i<s;){var r=i+s>>>1;n(t[r],e)<0?i=r+1:s=r}return i},right:function(t,e,i,s){for(null==i&&(i=0),null==s&&(s=t.length);i<s;){var r=i+s>>>1;n(t[r],e)>0?s=r:i=r+1}return i}}}function i(n){return function(e,i){return t(n(e),i)}}var s=e(t),r=s.right,a=s.left;function o(n,t){return t<n?-1:t>n?1:t>=n?0:NaN}function l(n){return null===n?NaN:+n}function f(n,t){var e,i,s=n.length,r=0,a=0,o=-1,f=0;if(null==t)for(;++o<s;)isNaN(e=l(n[o]))||(a+=(i=e-r)*(e-(r+=i/++f)));else for(;++o<s;)isNaN(e=l(t(n[o],o,n)))||(a+=(i=e-r)*(e-(r+=i/++f)));if(f>1)return a/(f-1)}function g(n,t){var e=f(n,t);return e?Math.sqrt(e):e}function u(n,t){var e,i,s,r=-1,a=n.length;if(null==t){for(;++r<a;)if(null!=(i=n[r])&&i>=i){e=s=i;break}for(;++r<a;)null!=(i=n[r])&&(e>i&&(e=i),s<i&&(s=i))}else{for(;++r<a;)if(null!=(i=t(n[r],r,n))&&i>=i){e=s=i;break}for(;++r<a;)null!=(i=t(n[r],r,n))&&(e>i&&(e=i),s<i&&(s=i))}return[e,s]}function h(n){return function(){return n}}function d(n){return n}function c(n,t,e){n=+n,t=+t,e=(s=arguments.length)<2?(t=n,n=0,1):s<3?1:+e;for(var i=-1,s=0|Math.max(0,Math.ceil((t-n)/e)),r=new Array(s);++i<s;)r[i]=n+i*e;return r}var b=Math.sqrt(50),D=Math.sqrt(10),H=Math.sqrt(2);function j(n,t,e){var i=m(n,t,e);return c(Math.ceil(n/i)*i,Math.floor(t/i)*i+i/2,i)}function m(n,t,e){var i=Math.abs(t-n)/Math.max(0,e),s=Math.pow(10,Math.floor(Math.log(i)/Math.LN10)),r=i/s;return r>=b?s*=10:r>=D?s*=5:r>=H&&(s*=2),t<n?-s:s}function A(n){return Math.ceil(Math.log(n.length)/Math.LN2)+1}function C(n){return+n}function T(){var n=d,t=u,e=A;function i(i){var s,a,o=i.length,l=new Array(o);for(s=0;s<o;++s)l[s]=+n(i[s],s,i);var f=t(l),g=+f[0],u=+f[1],h=e(l,g,u);Array.isArray(h)||(h=j(g,u,+h));var d=h.length;for(s=0;s<d;++s)h[s]=+h[s];for(;h[0]<=g;)h.shift(),--d;for(;h[d-1]>=u;)h.pop(),--d;var c,b=new Array(d+1);for(s=0;s<=d;++s)(c=b[s]=[]).x0=s>0?h[s-1]:g,c.x1=s<d?h[s]:u;for(s=0;s<o;++s)g<=(a=l[s])&&a<=u&&b[r(h,a,0,d)].push(i[s]);return b}return i.value=function(t){return arguments.length?(n="function"==typeof t?t:h(+t),i):n},i.domain=function(n){return arguments.length?(t="function"==typeof n?n:h([+n[0],+n[1]]),i):t},i.thresholds=function(n){return arguments.length?(e="function"==typeof n?n:Array.isArray(n)?h(Array.prototype.map.call(n,C)):h(+n),i):e},i}function p(n,t,e){if(null==e&&(e=l),i=n.length){if((t=+t)<=0||i<2)return+e(n[0],0,n);if(t>=1)return+e(n[i-1],i-1,n);var i,s=(i-1)*t,r=Math.floor(s),a=+e(n[r],r,n);return a+(+e(n[r+1],r+1,n)-a)*(s-r)}}function I(n,e,i){return n.sort(t),Math.ceil((i-e)/(2*(p(n,.75)-p(n,.25))*Math.pow(n.length,-1/3)))}function P(n,t,e){return Math.ceil((e-t)/(3.5*g(n)*Math.pow(n.length,-1/3)))}function M(n,t){var e,i,s=-1,r=n.length;if(null==t){for(;++s<r;)if(null!=(i=n[s])&&i>=i){e=i;break}for(;++s<r;)null!=(i=n[s])&&i>e&&(e=i)}else{for(;++s<r;)if(null!=(i=t(n[s],s,n))&&i>=i){e=i;break}for(;++s<r;)null!=(i=t(n[s],s,n))&&i>e&&(e=i)}return e}function N(n,t){var e,i=0,s=n.length,r=-1,a=s;if(null==t)for(;++r<s;)isNaN(e=l(n[r]))?--a:i+=e;else for(;++r<s;)isNaN(e=l(t(n[r],r,n)))?--a:i+=e;if(a)return i/a}function w(n,e){var i,s=[],r=n.length,a=-1;if(null==e)for(;++a<r;)isNaN(i=l(n[a]))||s.push(i);else for(;++a<r;)isNaN(i=l(e(n[a],a,n)))||s.push(i);return p(s.sort(t),.5)}function L(n){for(var t,e,i,s=n.length,r=-1,a=0;++r<s;)a+=n[r].length;for(e=new Array(a);--s>=0;)for(t=(i=n[s]).length;--t>=0;)e[--a]=i[t];return e}function U(n,t){var e,i,s=-1,r=n.length;if(null==t){for(;++s<r;)if(null!=(i=n[s])&&i>=i){e=i;break}for(;++s<r;)null!=(i=n[s])&&e>i&&(e=i)}else{for(;++s<r;)if(null!=(i=t(n[s],s,n))&&i>=i){e=i;break}for(;++s<r;)null!=(i=t(n[s],s,n))&&e>i&&(e=i)}return e}function y(n){for(var t=0,e=n.length-1,i=n[0],s=new Array(e<0?0:e);t<e;)s[t]=[i,i=n[++t]];return s}function J(n,t){for(var e=t.length,i=new Array(e);e--;)i[e]=n[t[e]];return i}function B(n,e){if(i=n.length){var i,s,r=0,a=0,o=n[a];for(e||(e=t);++r<i;)(e(s=n[r],o)<0||0!==e(o,o))&&(o=s,a=r);return 0===e(o,o)?a:void 0}}function R(n,t,e){for(var i,s,r=(null==e?n.length:e)-(t=null==t?0:+t);r;)s=Math.random()*r--|0,i=n[r+t],n[r+t]=n[s+t],n[s+t]=i;return n}function k(n,t){var e,i=0,s=n.length,r=-1;if(null==t)for(;++r<s;)(e=+n[r])&&(i+=e);else for(;++r<s;)(e=+t(n[r],r,n))&&(i+=e);return i}function E(n){if(!(s=n.length))return[];for(var t=-1,e=U(n,x),i=new Array(e);++t<e;)for(var s,r=-1,a=i[t]=new Array(s);++r<s;)a[r]=n[r][t];return i}function x(n){return n.length}function F(){return E(arguments)}var Q="0.7.1";n.version=Q,n.bisect=r,n.bisectRight=r,n.bisectLeft=a,n.ascending=t,n.bisector=e,n.descending=o,n.deviation=g,n.extent=u,n.histogram=T,n.thresholdFreedmanDiaconis=I,n.thresholdScott=P,n.thresholdSturges=A,n.max=M,n.mean=N,n.median=w,n.merge=L,n.min=U,n.pairs=y,n.permute=J,n.quantile=p,n.range=c,n.scan=B,n.shuffle=R,n.sum=k,n.ticks=j,n.tickStep=m,n.transpose=E,n.variance=f,n.zip=F}(t)}(0,d3Array.exports);const{bisectRight:bisectRight}=d3Array.exports,quincunx=(n,t,e,i)=>{const s=n.length-1;n[0]=0,t[0]=0,e[0]=0,t[1]=t[1]/n[1],e[1]=e[1]/n[1];for(let i=2;i<s;++i)n[i]=n[i]-n[i-2]*e[i-2]*e[i-2]-n[i-1]*t[i-1]*t[i-1],t[i]=(t[i]-n[i-1]*t[i-1]*e[i-1])/n[i],e[i]=e[i]/n[i];for(let n=2;n<s;++n)i[n]=i[n]-t[n-1]*i[n-1]-e[n-2]*i[n-2];for(let t=1;t<s;++t)i[t]=i[t]/n[t];i[s-2]=i[s-2]-t[s-2]*i[s-1];for(let n=s-3;n>0;--n)i[n]=i[n]-t[n]*i[n+1]-e[n]*i[n+2]},smoothingSpline=(n,t,e,i)=>{const s=n.length-1,r=new Array(s+1),a=new Array(s+1),o=new Array(s+1),l=new Array(s+1),f=new Array(s+1),g=new Array(s+1),u=new Array(s+1),h=new Array(s+1),d=n.map((()=>[0,0,0,0]));d.pop();const c=2*(1-i)/(3*i);for(let t=0;t<s;++t)r[t]=n[t+1]-n[t],a[t]=3/r[t];f[0]=0;for(let e=1;e<s;++e)o[e]=-(a[e-1]+a[e]),l[e]=2*(n[e+1]-n[e-1]),f[e]=3*(t[e+1]-t[e])/r[e]-3*(t[e]-t[e-1])/r[e-1];f[s]=0;for(let n=1;n<s;++n)g[n]=a[n-1]*a[n-1]*e[n-1]+o[n]*o[n]*e[n]+a[n]*a[n]*e[n+1],g[n]=c*g[n]+l[n];for(let n=1;n<s-1;++n)u[n]=o[n]*a[n]*e[n]+a[n]*o[n+1]*e[n+1],u[n]=c*u[n]+r[n];for(let n=1;n<s-2;++n)h[n]=c*a[n]*a[n+1]*e[n+1];quincunx(g,u,h,f),d[0][3]=t[0]-c*a[0]*f[1]*e[0],d[1][3]=t[1]-c*(o[1]*f[1]+a[1]*f[2])*e[0],d[0][0]=f[1]/(3*r[0]),d[0][1]=0,d[0][2]=(d[1][3]-d[0][3])/r[0]-f[1]*r[0]/3,a[0]=0;for(let n=1;n<s;++n)d[n][0]=(f[n+1]-f[n])/(3*r[n]),d[n][1]=f[n],d[n][2]=(f[n]+f[n-1])*r[n-1]+d[n-1][2],d[n][3]=a[n-1]*f[n-1]+o[n]*f[n]+a[n]*f[n+1],d[n][3]=t[n]-c*d[n][3]*e[n];return d};class SplineInterpolator{constructor(n,t,e=1){const i=n.map(((n,t)=>t));i.sort(((t,e)=>n[t]-n[e]));const s=i.map((t=>n[t])),r=i.map((n=>t[n])),a=i.length,o=i.map((()=>1));this.n=a,this.x=s,this.y=r,this.params=smoothingSpline(s,r,o,e)}interpolate(n){if(n===this.x[this.n-1])return this.y[this.n-1];const t=Math.min(Math.max(0,bisectRight(this.x,n)-1),this.n-2),[e,i,s,r]=this.params[t];return e*(n-=this.x[t])*n*n+i*n*n+s*n+r}max(n=100){const t=this.x[0],e=(this.x[this.n-1]-t)/n;let i=-1/0;for(let s=0,r=t;s<n;++s,r+=e){const n=this.interpolate(r);n>i&&(i=n)}return i}min(n=100){const t=this.x[0],e=(this.x[this.n-1]-t)/n;let i=1/0;for(let s=0,r=t;s<n;++s,r+=e){const n=this.interpolate(r);n<i&&(i=n)}return i}domain(){return[this.x[0],this.x[this.x.length-1]]}range(){return[this.min(),this.max()]}curve(n,t=null){const e=((t=t||this.domain())[1]-t[0])/(n-1),i=new Array(n);for(let s=0;s<n;++s){const n=e*s+t[0];i[s]=[n,this.interpolate(n)]}return i}}var splineInterpolator=SplineInterpolator,SplineInterpolator$1=splineInterpolator;function createFromToArray(n={}){const{from:t=0,to:e=1,length:i=1e3,includeFrom:s=!0,includeTo:r=!0,distribution:a="uniform"}=n,o=new Float64Array(i);let l=i;s&&r?l=i-1:!s&&r||s&&!r?l=i:s||r||(l=i+1);const f=(e-t)/l;if("uniform"===a)if(s){let n=0;for(;n<i;)o[n]=t+f*n,n++}else{let n=0;for(;n<i;)o[n]=t+f*(n+1),n++}else{if("log"!==a)throw new Error("Please choose for the distribution either uniform or log. By default the distribution chosen is uniform.");{const n=(e/t)**(1/l),r=Math.log(t)/Math.log(n);if(s){let t=0;for(;t<i;)o[t]=n**(r+t),t++}else{let t=0;for(;t<i;)o[t]=n**(r+t+1),t++}}}return o}const Y1=.08913147449493408,P1=[-.005387729650712429,.008226878746769157,.02198786811111689,-.03656379714117627,-.012692614766297404,.03348066254097446,-.008368748197417368,-.0005087819496582806],Q1=[.0008862163904564247,-.0023339375937419,.07952836873415717,-.05273963823400997,-.7122890234154284,.662328840472003,1.5622155839842302,-1.5657455823417585,-.9700050433032906,1],Y2=2.249481201171875,P2=[-3.6719225470772936,21.12946554483405,17.445385985570866,-44.6382324441787,-18.851064805871424,17.644729840837403,8.3705032834312,.10526468069939171,-.20243350835593876],Q2=[1.7211476576120028,-22.643693341313973,10.826866735546016,48.560921310873994,-20.14326346804852,-28.66081804998,3.971343795334387,6.242641248542475,1],Y3=.807220458984375,P3=[-6.81149956853777e-10,2.8522533178221704e-8,-6.794655751811263e-7,.0021455899538880526,.029015791000532906,.14286953440815717,.3377855389120359,.38707973897260434,.11703015634199525,-.16379404719331705,-.1311027816799519],Q3=[.011059242293464892,.15226433829533179,.848854343457902,2.5930192162362027,4.778465929458438,5.381683457070069,3.4662540724256723,1],Y4=.9399557113647461,P4=[26633922742578204e-28,-2.304047769118826e-10,460469890584318e-20,.00015754461742496055,.0018712349281955923,.009508047013259196,.018557330651423107,-.0022242652921344794,-.0350353787183178],Q4=[7646752923027944e-20,.00263861676657016,.03415891436709477,.22009110576413124,.7620591645536234,1.3653349817554064,1],Y5=.9836282730102539,P5=[9905570997331033e-32,-2811287356288318e-29,4.625961635228786e-9,4.4969678992770644e-7,14962478375834237e-21,.00020938631748758808,.001056288621524929,-.0011295143874558028,-.016743100507663373],Q5=[2.82243172016108e-7,27533547476472603e-21,.0009640118070051656,.016074608709367652,.1381518657490833,.5914293448864175,1];function polyval(n,t){let e=0;for(const i of n)e=e*t+i;return e}function calc(n,t,e,i,s){const r=n-t;return s*n+polyval(e,r)/polyval(i,r)*n}function erfcinv(n){let t,e,i,s,r=!1;if(Number.isNaN(n))return Number.NaN;if(n<0||n>2)throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${n}\`.`);return 0===n?Number.POSITIVE_INFINITY:2===n?Number.NEGATIVE_INFINITY:1===n?0:(n>1?(e=2-n,n=1-e,r=!0):(e=n,n=1-n),n<=.5?(i=n*(n+10),s=polyval(P1,n)/polyval(Q1,n),t=i*Y1+i*s,r?-t:t):e>=.25?(i=Math.sqrt(-2*Math.log(e)),e-=.25,s=polyval(P2,e)/polyval(Q2,e),t=i/(Y2+s),r?-t:t):(e=Math.sqrt(-Math.log(e)),e<3?calc(e,1.125,P3,Q3,Y3):e<6?calc(e,3,P4,Q4,Y4):calc(e,6,P5,Q5,Y5)))}function rayleighCdf(n,t=1){return n<0?0:-Math.expm1(-(n**2)/(2*t**2))}function xNoiseSanPlot(n,t={}){const{mask:e,cutOff:i,refine:s=!0,magnitudeMode:r=!1,scaleFactor:a=1,factorStd:o=5,fixOffset:l=!0}=t;let f;if(f=Array.isArray(e)&&e.length===n.length?new Float64Array(n.filter(((n,t)=>!e[t]))):new Float64Array(n),a>1)for(let n=0;n<f.length;n++)f[n]*=a;if(f=f.sort().reverse(),l&&!r){const n=Math.floor(f.length/2),t=.5*(f[n]+f[n+1]);for(let n=0;n<f.length;n++)f[n]-=t}const g=f[f.length-1]>=0?f.length:f.findIndex((n=>n<0));let u=g-1;for(let n=u;n>=0;n--)if(f[n]>0){u=n;break}const h=f.slice(0,u+1),d=f.slice(g),c=i||determineCutOff(h,{magnitudeMode:r});let b=h[Math.floor(h.length*c)];const D=h[0];let H;if(d.length>0){H=-1*d[Math.floor(d.length*(1-c))]}else H=0;let j=b,m=H,A=h.slice(),C=d.slice(),T=0,p=2;if(s){let n=j*o;T=h.findIndex((t=>t<n)),T>-1&&(A=h.slice(T),j=A[Math.floor(A.length*c)]),n=m*o,p=d.findIndex((t=>t<n)),p>-1&&(C=d.slice(p),m=A[Math.floor(C.length*(1-c))])}const I=-simpleNormInvNumber(c/2,{magnitudeMode:r});let P,M;return b/=I,H/=I,s&&T>-1?(P=(c*A.length+T)/(A.length+T),M=-1*simpleNormInvNumber(P/2,{magnitudeMode:r}),j/=M,p>-1&&(P=(c*C.length+p)/(C.length+p),M=-1*simpleNormInvNumber(P/2,{magnitudeMode:r}),0!==m&&(m/=M))):(j/=I,m/=I),{positive:j,negative:m,snr:D/j,sanplot:generateSanPlot(f,{fromTo:{positive:{from:0,to:u},negative:{from:g,to:f.length}}})}}function determineCutOff(n,t={}){const{magnitudeMode:e=!1,considerList:i={from:.5,step:.1,to:.9}}=t,s=[],r=n.length-1;for(let t=.01;t<=.99;t+=.01){const i=-n[Math.round(r*t)]/simpleNormInvNumber(t/2,{magnitudeMode:e});s.push([t,i])}let a=Number.MAX_SAFE_INTEGER;const{from:o,to:l,step:f}=i,g=f/2;let u=.5;for(let n=o;n<=l;n+=f){const t=n-g,e=n+g,i=s.filter((n=>n[0]<e&&n[0]>t)),r=i.reduce(((n,t)=>n+Math.abs(t[1])),0);let o=0;for(const n of i)o+=(n[1]-r)**2;o<a&&(a=o,u=n)}return u}function simpleNormInvNumber(n,t){return simpleNormInv([n],t)[0]}function simpleNormInv(n,t={}){const{magnitudeMode:e=!1}=t,i=Array.from(createArray(0,2,.01)),s=new Float64Array(n.length),r=new Float64Array(i.length);if(e){const t=1;for(let n=0;n<r.length;n++){const e=i[n]*t;r[n]=1-rayleighCdf(e)}const e=new SplineInterpolator$1(i,r);for(let t=0;t<s.length;t++){const i=2*n[t];s[t]=-1*e.interpolate(i)}}else for(let t=0;t<s.length;t++)s[t]=-1*Math.SQRT2*erfcinv(2*n[t]);return s}function createArray(n,t,e){const i=new Float64Array(Math.abs((n-t)/e+1));for(let t=0;t<i.length;t++)i[t]=n+t*e;return i}function generateSanPlot(n,t={}){const{fromTo:e,logBaseY:i=2}=t,s={};for(const t in e){const{from:r,to:a}=e[t];s[t]=r!==a?scale(n.slice(r,a),{logBaseY:i}):{x:[],y:[]},"negative"===t&&s[t].y.reverse()}return s}function scale(n,t={}){const{log10:e,abs:i}=Math,{logBaseY:s}=t;if(s){n=n.slice();const t=e(s);for(let s=0;s<n.length;s++)n[s]=e(i(n[s]))/t}return{x:createFromToArray({from:0,to:n.length-1,length:n.length}),y:n}}function reimPhaseCorrection(n,t=0,e=0,i={}){const{reverse:s=!1}=i;t=Number.isFinite(t)?t:0,e=Number.isFinite(e)?e:0;const r=n.re,a=n.im,o=n.re.length;let l=t,f=e/o;s&&(f*=-1,l+=e);const g=2*Math.sin(f/2)**2,u=Math.sin(f);let h=Math.cos(l),d=Math.sin(l);const c=new Float64Array(o),b=new Float64Array(o);for(let n=0;n<o;n++){c[n]=r[n]*h-a[n]*d,b[n]=a[n]*h+r[n]*d;const t=d-(g*d-u*h);h=h-(g*h+u*d),d=t}return{re:c,im:b}}function reimAutoPhaseCorrection(n,t={}){const{magnitudeMode:e=!0,minRegSize:i=30,factorNoise:s=3,maxDistanceToJoin:r=256,reverse:a=!1}=t,o=detectBaselineRegions(n,{maxDistanceToJoin:r,magnitudeMode:e,factorNoise:s}),{re:l,im:f}=n,g=l.length,u=a?n=>g-1-n:n=>n;let h=0,d=-1;const c=[];for(;d<g;){const n=[],t=[];for(;!o[u(++d)]&&d<g;)h=d;for(;o[u(d)]&&d<g;d+=2)n.push(l[u(d)]),t.push(f[u(d)]);n.length>i&&c.push(autoPhaseRegion(n,t,h))}const{ph1:b,ph0:D}=determiningGlobalValues(c.map((n=>n.x0/g)),c.map((n=>n.ph0)),c.map((n=>n.area/1e11)));return{data:reimPhaseCorrection({re:l,im:f},toRadians(D),toRadians(b),{reverse:a}),ph0:D,ph1:b}}function determiningGlobalValues(n,t,e){const[i,s]=weightedLinearRegression(n,t,e);let r=-1,a=Number.MIN_SAFE_INTEGER;for(let e=0;e<n.length;e++){const o=n[e]*i+s,l=Math.abs(t[e]-o);l>34&&a<l&&(r=e,a=l)}return r>-1?(n.splice(r,1),t.splice(r,1),e.splice(r,1),determiningGlobalValues(n,t,e)):{ph0:s,ph1:i}}function detectBaselineRegions(n,t){const e=t.magnitudeMode?reimAbsolute(n):n.re,i=robustBaseLineRegionsDetection(holoborodko(e),t);return robustBaseLineRegionsDetection(e,t).map(((n,t)=>n&&i[t]))}function autoPhaseRegion(n,t,e){let i=-180,s=180;let r=10,a=0,o=Number.MAX_SAFE_INTEGER;for(;r>0;){const e=(s-i)/7;for(let r=i;r<=s;r+=e){const e=reimPhaseCorrection({re:n,im:t},toRadians(r),0),i=getNegArea(e.re);i<o&&([o,a]=[i,r])}i=a-e,s=a+e,r--}const l=reimPhaseCorrection({re:n,im:t},toRadians(a),0);let f=0,g=0;for(let t=0;t<n.length;t++)f+=l.re[t],g+=l.re[t]*(t+e);return{ph0:a,area:f,x0:g/f}}function holoborodko(n){const t=new Float64Array(n.length);for(let e=5;e<n.length-5;e++)t[e]=(42*(n[e+1]-n[e-1])+48*(n[e+2]-n[e-2])+27*(n[e+3]+n[e-3])+8*(n[e+4]-n[e-4])+n[e+5]-n[e-5])/512;for(let e=0;e<5;e++)t[e]=t[5],t[n.length-e-1]=t[n.length-6];return t}function robustBaseLineRegionsDetection(n,t){const{maxDistanceToJoin:e,magnitudeMode:i,factorNoise:s}=t,r=new Uint8Array(n.length);for(let t=0;t<n.length;t++)r[t]=0;let a=!0;for(;a;){const t=s*xNoiseSanPlot(n,{magnitudeMode:i}).positive;a=!1;for(let e=0;e<n.length;e++)Math.abs(n[e])>t&&!r[e]&&(a=!0,r[e]=1)}let o=0,l=0;for(let t=0;t<n.length;t++)if(r[t]){if(o<e)for(let n=0;n<=o;n++)r[l+n]=1;for(;r[++t]&&t<n.length;);l=t,o=0}else o++;return r}function weightedLinearRegression(n,t,e){let i=0,s=0,r=0,a=0,o=0;for(let l=0;l<n.length;l++)i+=n[l]*n[l]*e[l],s+=n[l]*e[l],r+=e[l],a+=n[l]*e[l]*t[l],o+=e[l]*t[l];const l=i*r-s*s,f=[[r/l,-s/l],[-s/l,i/l]];return[f[0][0]*a+f[0][1]*o,f[1][0]*a+f[1][1]*o]}const toRadians=n=>n*Math.PI/180,getNegArea=n=>{let t=0;for(const e of n)e<0&&(t-=e);return t};function FFT$1(n){if(this.size=0|n,this.size<=1||0!=(this.size&this.size-1))throw new Error("FFT size must be a power of two and bigger than 1");this._csize=n<<1;for(var t=new Array(2*this.size),e=0;e<t.length;e+=2){const n=Math.PI*e/this.size;t[e]=Math.cos(n),t[e+1]=-Math.sin(n)}this.table=t;for(var i=0,s=1;this.size>s;s<<=1)i++;this._width=i%2==0?i-1:i,this._bitrev=new Array(1<<this._width);for(var r=0;r<this._bitrev.length;r++){this._bitrev[r]=0;for(var a=0;a<this._width;a+=2){var o=this._width-a-2;this._bitrev[r]|=(r>>>a&3)<<o}}this._out=null,this._data=null,this._inv=0}var fft$1=FFT$1;FFT$1.prototype.fromComplexArray=function(n,t){for(var e=t||new Array(n.length>>>1),i=0;i<n.length;i+=2)e[i>>>1]=n[i];return e},FFT$1.prototype.createComplexArray=function(){const n=new Array(this._csize);for(var t=0;t<n.length;t++)n[t]=0;return n},FFT$1.prototype.toComplexArray=function(n,t){for(var e=t||this.createComplexArray(),i=0;i<e.length;i+=2)e[i]=n[i>>>1],e[i+1]=0;return e},FFT$1.prototype.completeSpectrum=function(n){for(var t=this._csize,e=t>>>1,i=2;i<e;i+=2)n[t-i]=n[i],n[t-i+1]=-n[i+1]},FFT$1.prototype.transform=function(n,t){if(n===t)throw new Error("Input and output buffers must be different");this._out=n,this._data=t,this._inv=0,this._transform4(),this._out=null,this._data=null},FFT$1.prototype.realTransform=function(n,t){if(n===t)throw new Error("Input and output buffers must be different");this._out=n,this._data=t,this._inv=0,this._realTransform4(),this._out=null,this._data=null},FFT$1.prototype.inverseTransform=function(n,t){if(n===t)throw new Error("Input and output buffers must be different");this._out=n,this._data=t,this._inv=1,this._transform4();for(var e=0;e<n.length;e++)n[e]/=this.size;this._out=null,this._data=null},FFT$1.prototype._transform4=function(){var n,t,e=this._out,i=this._csize,s=1<<this._width,r=i/s<<1,a=this._bitrev;if(4===r)for(n=0,t=0;n<i;n+=r,t++){const e=a[t];this._singleTransform2(n,e,s)}else for(n=0,t=0;n<i;n+=r,t++){const e=a[t];this._singleTransform4(n,e,s)}var o=this._inv?-1:1,l=this.table;for(s>>=2;s>=2;s>>=2){var f=(r=i/s<<1)>>>2;for(n=0;n<i;n+=r)for(var g=n+f,u=n,h=0;u<g;u+=2,h+=s){const n=u,t=n+f,i=t+f,s=i+f,r=e[n],a=e[n+1],g=e[t],d=e[t+1],c=e[i],b=e[i+1],D=e[s],H=e[s+1],j=r,m=a,A=l[h],C=o*l[h+1],T=g*A-d*C,p=g*C+d*A,I=l[2*h],P=o*l[2*h+1],M=c*I-b*P,N=c*P+b*I,w=l[3*h],L=o*l[3*h+1],U=D*w-H*L,y=D*L+H*w,J=j+M,B=m+N,R=j-M,k=m-N,E=T+U,x=p+y,F=o*(T-U),Q=o*(p-y),X=J+E,S=B+x,z=J-E,G=B-x,q=R+Q,Y=k-F,v=R-Q,Z=k+F;e[n]=X,e[n+1]=S,e[t]=q,e[t+1]=Y,e[i]=z,e[i+1]=G,e[s]=v,e[s+1]=Z}}},FFT$1.prototype._singleTransform2=function(n,t,e){const i=this._out,s=this._data,r=s[t],a=s[t+1],o=s[t+e],l=s[t+e+1],f=r+o,g=a+l,u=r-o,h=a-l;i[n]=f,i[n+1]=g,i[n+2]=u,i[n+3]=h},FFT$1.prototype._singleTransform4=function(n,t,e){const i=this._out,s=this._data,r=this._inv?-1:1,a=2*e,o=3*e,l=s[t],f=s[t+1],g=s[t+e],u=s[t+e+1],h=s[t+a],d=s[t+a+1],c=s[t+o],b=s[t+o+1],D=l+h,H=f+d,j=l-h,m=f-d,A=g+c,C=u+b,T=r*(g-c),p=r*(u-b),I=D+A,P=H+C,M=j+p,N=m-T,w=D-A,L=H-C,U=j-p,y=m+T;i[n]=I,i[n+1]=P,i[n+2]=M,i[n+3]=N,i[n+4]=w,i[n+5]=L,i[n+6]=U,i[n+7]=y},FFT$1.prototype._realTransform4=function(){var n,t,e=this._out,i=this._csize,s=1<<this._width,r=i/s<<1,a=this._bitrev;if(4===r)for(n=0,t=0;n<i;n+=r,t++){const e=a[t];this._singleRealTransform2(n,e>>>1,s>>>1)}else for(n=0,t=0;n<i;n+=r,t++){const e=a[t];this._singleRealTransform4(n,e>>>1,s>>>1)}var o=this._inv?-1:1,l=this.table;for(s>>=2;s>=2;s>>=2){var f=(r=i/s<<1)>>>1,g=f>>>1,u=g>>>1;for(n=0;n<i;n+=r)for(var h=0,d=0;h<=u;h+=2,d+=s){var c=n+h,b=c+g,D=b+g,H=D+g,j=e[c],m=e[c+1],A=e[b],C=e[b+1],T=e[D],p=e[D+1],I=e[H],P=e[H+1],M=j,N=m,w=l[d],L=o*l[d+1],U=A*w-C*L,y=A*L+C*w,J=l[2*d],B=o*l[2*d+1],R=T*J-p*B,k=T*B+p*J,E=l[3*d],x=o*l[3*d+1],F=I*E-P*x,Q=I*x+P*E,X=M+R,S=N+k,z=M-R,G=N-k,q=U+F,Y=y+Q,v=o*(U-F),Z=o*(y-Q),V=X+q,O=S+Y,K=z+Z,W=G-v;if(e[c]=V,e[c+1]=O,e[b]=K,e[b+1]=W,0!==h){if(h!==u){var _=z+-o*Z,$=-G+-o*v,nn=X+-o*q,tn=-S- -o*Y,en=n+g-h,sn=n+f-h;e[en]=_,e[en+1]=$,e[sn]=nn,e[sn+1]=tn}}else{var rn=X-q,an=S-Y;e[D]=rn,e[D+1]=an}}}},FFT$1.prototype._singleRealTransform2=function(n,t,e){const i=this._out,s=this._data,r=s[t],a=s[t+e],o=r+a,l=r-a;i[n]=o,i[n+1]=0,i[n+2]=l,i[n+3]=0},FFT$1.prototype._singleRealTransform4=function(n,t,e){const i=this._out,s=this._data,r=this._inv?-1:1,a=2*e,o=3*e,l=s[t],f=s[t+e],g=s[t+a],u=s[t+o],h=l+g,d=l-g,c=f+u,b=r*(f-u),D=h+c,H=d,j=-b,m=h-c,A=d,C=b;i[n]=D,i[n+1]=0,i[n+2]=H,i[n+3]=j,i[n+4]=m,i[n+5]=0,i[n+6]=A,i[n+7]=C};var FFT$2=fft$1;function xRotate(n,t){(t%=n.length)<0&&(t+=n.length);const e=new Float64Array(n.length);return e.set(n.slice(n.length-t)),e.set(n.slice(0,n.length-t),t),e}function reimFFT(n,t={}){const{inverse:e=!1,applyZeroShift:i=!1}=t,{re:s,im:r}=n,a=s.length,o=a<<1;let l=new Float64Array(o);for(let n=0;n<o;n+=2)l[n]=s[n>>>1],l[n+1]=r[n>>>1];const f=new FFT$2(a);let g=new Float64Array(o);e?(i&&(l=zeroShift(l,!0)),f.inverseTransform(g,l)):(f.transform(g,l),i&&(g=zeroShift(g)));const u=new Float64Array(a),h=new Float64Array(a);for(let n=0;n<o;n+=2)u[n>>>1]=g[n],h[n>>>1]=g[n+1];return{re:u,im:h}}const zeroShift=(n,t)=>xRotate(n,t?Math.ceil(n.length/2):Math.floor(n.length/2));function xAbsolute(n){const t=n.slice();for(let n=0;n<t.length;n++)t[n]<0&&(t[n]*=-1);return t}const toString$2=Object.prototype.toString;function isAnyArray$1(n){const t=toString$2.call(n);return t.endsWith("Array]")&&!t.includes("Big")}var libEsm=Object.freeze({__proto__:null,isAnyArray:isAnyArray$1});function xMedian(n){if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");const t=n.slice();let e=0,i=t.length-1,s=0,r=0,a=0;const o=calcMiddle(e,i);for(;;){if(i<=e)return t[o];if(i===e+1)return t[e]>t[i]&&swap(t,e,i),t[o];for(s=calcMiddle(e,i),t[s]>t[i]&&swap(t,s,i),t[e]>t[i]&&swap(t,e,i),t[s]>t[e]&&swap(t,s,e),swap(t,s,e+1),r=e+1,a=i;;){do{r++}while(t[e]>t[r]);do{a--}while(t[a]>t[e]);if(a<r)break;swap(t,r,a)}swap(t,e,a),a<=o&&(e=r),a>=o&&(i=a-1)}}function swap(n,t,e){const i=n[e];n[e]=n[t],n[t]=i}function calcMiddle(n,t){return Math.floor((n+t)/2)}function xAbsoluteMedian(n){return xMedian(xAbsolute(n))}function xAdd(n,t){let e=!1,i=0;if(isAnyArray$1(t)){if(n.length!==t.length)throw new Error("xAdd: size of array1 and array2 must be identical")}else e=!0,i=t;const s=new Float64Array(n.length);if(e)for(let t=0;t<n.length;t++)s[t]=n[t]+i;else for(let e=0;e<n.length;e++)s[e]=n[e]+t[e];return s}function xApplyFunctionStr(n,t={}){const{variableLabel:e="x",fctString:i=e}=t,s=new Function(e,`return Number(${i.replace(/(?<before>^|\W)(?<after>[\da-z]{2,}\()/g,"$<before>Math.$<after>").replace(/Math\.Math/g,"Math")})`),r=Float64Array.from(n);for(let t=0;t<n.length;t++)if(r[t]=s(n[t]),Number.isNaN(r[t]))throw new Error(`The callback ${i} does not return a number: ${n[t]}`);return r}function getOutputArray(n,t){if(void 0!==n){if(!isAnyArray$1(n))throw new TypeError("output option must be an array if specified");if(n.length!==t)throw new TypeError("the output array does not have the correct length");return n}return new Float64Array(t)}function xMultiply(n,t,e={}){let i=!1,s=0;if(isAnyArray$1(t)){if(n.length!==t.length)throw new Error("xMultiply: size of array1 and array2 must be identical")}else i=!0,s=Number(t);const r=getOutputArray(e.output,n.length);if(i)for(let t=0;t<n.length;t++)r[t]=n[t]*s;else for(let e=0;e<n.length;e++)r[e]=n[e]*t[e];return r}function xCheck(n,t={}){const{minLength:e}=t;if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");if(e&&n.length<e)throw new Error(`input must have a length of at least ${e}`)}var matrix={},require$$0=getAugmentedNamespace(libEsm);function max(n){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");var e=t.fromIndex,i=void 0===e?0:e,s=t.toIndex,r=void 0===s?n.length:s;if(i<0||i>=n.length||!Number.isInteger(i))throw new Error("fromIndex must be a positive integer smaller than length");if(r<=i||r>n.length||!Number.isInteger(r))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=n[i],o=i+1;o<r;o++)n[o]>a&&(a=n[o]);return a}function min(n){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");var e=t.fromIndex,i=void 0===e?0:e,s=t.toIndex,r=void 0===s?n.length:s;if(i<0||i>=n.length||!Number.isInteger(i))throw new Error("fromIndex must be a positive integer smaller than length");if(r<=i||r>n.length||!Number.isInteger(r))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=n[i],o=i+1;o<r;o++)n[o]<a&&(a=n[o]);return a}function rescale$2(n){var t,e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");if(void 0!==e.output){if(!isAnyArray$1(e.output))throw new TypeError("output option must be an array if specified");t=e.output}else t=new Array(n.length);var i=min(n),s=max(n);if(i===s)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var r=e.min,a=void 0===r?e.autoMinMax?i:0:r,o=e.max,l=void 0===o?e.autoMinMax?s:1:o;if(a>=l)throw new RangeError("min option must be smaller than max option");for(var f=(l-a)/(s-i),g=0;g<n.length;g++)t[g]=(n[g]-i)*f+a;return t}var libEs6=Object.freeze({__proto__:null,default:rescale$2}),require$$1=getAugmentedNamespace(libEs6);Object.defineProperty(matrix,"__esModule",{value:!0});var isAnyArray=require$$0,rescale$1=require$$1;const indent=" ".repeat(2),indentData=" ".repeat(4);function inspectMatrix(){return inspectMatrixWithOptions(this)}function inspectMatrixWithOptions(n,t={}){const{maxRows:e=15,maxColumns:i=10,maxNumSize:s=8,padMinus:r="auto"}=t;return`${n.constructor.name} {\n${indent}[\n${indentData}${inspectData(n,e,i,s,r)}\n${indent}]\n${indent}rows: ${n.rows}\n${indent}columns: ${n.columns}\n}`}function inspectData(n,t,e,i,s){const{rows:r,columns:a}=n,o=Math.min(r,t),l=Math.min(a,e),f=[];if("auto"===s){s=!1;n:for(let t=0;t<o;t++)for(let e=0;e<l;e++)if(n.get(t,e)<0){s=!0;break n}}for(let t=0;t<o;t++){let e=[];for(let r=0;r<l;r++)e.push(formatNumber(n.get(t,r),i,s));f.push(`${e.join(" ")}`)}return l!==a&&(f[f.length-1]+=` ... ${a-e} more columns`),o!==r&&f.push(`... ${r-t} more rows`),f.join(`\n${indentData}`)}function formatNumber(n,t,e){return(n>=0&&e?` ${formatNumber2(n,t-1)}`:formatNumber2(n,t)).padEnd(t)}function formatNumber2(n,t){let e=n.toString();if(e.length<=t)return e;let i=n.toFixed(t);if(i.length>t&&(i=n.toFixed(Math.max(0,t-(i.length-t)))),i.length<=t&&!i.startsWith("0.000")&&!i.startsWith("-0.000"))return i;let s=n.toExponential(t);return s.length>t&&(s=n.toExponential(Math.max(0,t-(s.length-t)))),s.slice(0)}function installMathOperations(n,t){n.prototype.add=function(n){return"number"==typeof n?this.addS(n):this.addM(n)},n.prototype.addS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n);return this},n.prototype.addM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n.get(t,e));return this},n.add=function(n,e){return new t(n).add(e)},n.prototype.sub=function(n){return"number"==typeof n?this.subS(n):this.subM(n)},n.prototype.subS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n);return this},n.prototype.subM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n.get(t,e));return this},n.sub=function(n,e){return new t(n).sub(e)},n.prototype.subtract=n.prototype.sub,n.prototype.subtractS=n.prototype.subS,n.prototype.subtractM=n.prototype.subM,n.subtract=n.sub,n.prototype.mul=function(n){return"number"==typeof n?this.mulS(n):this.mulM(n)},n.prototype.mulS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n);return this},n.prototype.mulM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n.get(t,e));return this},n.mul=function(n,e){return new t(n).mul(e)},n.prototype.multiply=n.prototype.mul,n.prototype.multiplyS=n.prototype.mulS,n.prototype.multiplyM=n.prototype.mulM,n.multiply=n.mul,n.prototype.div=function(n){return"number"==typeof n?this.divS(n):this.divM(n)},n.prototype.divS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n);return this},n.prototype.divM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n.get(t,e));return this},n.div=function(n,e){return new t(n).div(e)},n.prototype.divide=n.prototype.div,n.prototype.divideS=n.prototype.divS,n.prototype.divideM=n.prototype.divM,n.divide=n.div,n.prototype.mod=function(n){return"number"==typeof n?this.modS(n):this.modM(n)},n.prototype.modS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)%n);return this},n.prototype.modM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)%n.get(t,e));return this},n.mod=function(n,e){return new t(n).mod(e)},n.prototype.modulus=n.prototype.mod,n.prototype.modulusS=n.prototype.modS,n.prototype.modulusM=n.prototype.modM,n.modulus=n.mod,n.prototype.and=function(n){return"number"==typeof n?this.andS(n):this.andM(n)},n.prototype.andS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)&n);return this},n.prototype.andM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)&n.get(t,e));return this},n.and=function(n,e){return new t(n).and(e)},n.prototype.or=function(n){return"number"==typeof n?this.orS(n):this.orM(n)},n.prototype.orS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)|n);return this},n.prototype.orM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)|n.get(t,e));return this},n.or=function(n,e){return new t(n).or(e)},n.prototype.xor=function(n){return"number"==typeof n?this.xorS(n):this.xorM(n)},n.prototype.xorS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)^n);return this},n.prototype.xorM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)^n.get(t,e));return this},n.xor=function(n,e){return new t(n).xor(e)},n.prototype.leftShift=function(n){return"number"==typeof n?this.leftShiftS(n):this.leftShiftM(n)},n.prototype.leftShiftS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)<<n);return this},n.prototype.leftShiftM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)<<n.get(t,e));return this},n.leftShift=function(n,e){return new t(n).leftShift(e)},n.prototype.signPropagatingRightShift=function(n){return"number"==typeof n?this.signPropagatingRightShiftS(n):this.signPropagatingRightShiftM(n)},n.prototype.signPropagatingRightShiftS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>n);return this},n.prototype.signPropagatingRightShiftM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>n.get(t,e));return this},n.signPropagatingRightShift=function(n,e){return new t(n).signPropagatingRightShift(e)},n.prototype.rightShift=function(n){return"number"==typeof n?this.rightShiftS(n):this.rightShiftM(n)},n.prototype.rightShiftS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>>n);return this},n.prototype.rightShiftM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>>n.get(t,e));return this},n.rightShift=function(n,e){return new t(n).rightShift(e)},n.prototype.zeroFillRightShift=n.prototype.rightShift,n.prototype.zeroFillRightShiftS=n.prototype.rightShiftS,n.prototype.zeroFillRightShiftM=n.prototype.rightShiftM,n.zeroFillRightShift=n.rightShift,n.prototype.not=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,~this.get(n,t));return this},n.not=function(n){return new t(n).not()},n.prototype.abs=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.abs(this.get(n,t)));return this},n.abs=function(n){return new t(n).abs()},n.prototype.acos=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.acos(this.get(n,t)));return this},n.acos=function(n){return new t(n).acos()},n.prototype.acosh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.acosh(this.get(n,t)));return this},n.acosh=function(n){return new t(n).acosh()},n.prototype.asin=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.asin(this.get(n,t)));return this},n.asin=function(n){return new t(n).asin()},n.prototype.asinh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.asinh(this.get(n,t)));return this},n.asinh=function(n){return new t(n).asinh()},n.prototype.atan=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.atan(this.get(n,t)));return this},n.atan=function(n){return new t(n).atan()},n.prototype.atanh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.atanh(this.get(n,t)));return this},n.atanh=function(n){return new t(n).atanh()},n.prototype.cbrt=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.cbrt(this.get(n,t)));return this},n.cbrt=function(n){return new t(n).cbrt()},n.prototype.ceil=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.ceil(this.get(n,t)));return this},n.ceil=function(n){return new t(n).ceil()},n.prototype.clz32=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.clz32(this.get(n,t)));return this},n.clz32=function(n){return new t(n).clz32()},n.prototype.cos=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.cos(this.get(n,t)));return this},n.cos=function(n){return new t(n).cos()},n.prototype.cosh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.cosh(this.get(n,t)));return this},n.cosh=function(n){return new t(n).cosh()},n.prototype.exp=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.exp(this.get(n,t)));return this},n.exp=function(n){return new t(n).exp()},n.prototype.expm1=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.expm1(this.get(n,t)));return this},n.expm1=function(n){return new t(n).expm1()},n.prototype.floor=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.floor(this.get(n,t)));return this},n.floor=function(n){return new t(n).floor()},n.prototype.fround=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.fround(this.get(n,t)));return this},n.fround=function(n){return new t(n).fround()},n.prototype.log=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log(this.get(n,t)));return this},n.log=function(n){return new t(n).log()},n.prototype.log1p=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log1p(this.get(n,t)));return this},n.log1p=function(n){return new t(n).log1p()},n.prototype.log10=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log10(this.get(n,t)));return this},n.log10=function(n){return new t(n).log10()},n.prototype.log2=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log2(this.get(n,t)));return this},n.log2=function(n){return new t(n).log2()},n.prototype.round=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.round(this.get(n,t)));return this},n.round=function(n){return new t(n).round()},n.prototype.sign=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sign(this.get(n,t)));return this},n.sign=function(n){return new t(n).sign()},n.prototype.sin=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sin(this.get(n,t)));return this},n.sin=function(n){return new t(n).sin()},n.prototype.sinh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sinh(this.get(n,t)));return this},n.sinh=function(n){return new t(n).sinh()},n.prototype.sqrt=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sqrt(this.get(n,t)));return this},n.sqrt=function(n){return new t(n).sqrt()},n.prototype.tan=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.tan(this.get(n,t)));return this},n.tan=function(n){return new t(n).tan()},n.prototype.tanh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.tanh(this.get(n,t)));return this},n.tanh=function(n){return new t(n).tanh()},n.prototype.trunc=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.trunc(this.get(n,t)));return this},n.trunc=function(n){return new t(n).trunc()},n.pow=function(n,e){return new t(n).pow(e)},n.prototype.pow=function(n){return"number"==typeof n?this.powS(n):this.powM(n)},n.prototype.powS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.pow(this.get(t,e),n));return this},n.prototype.powM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.pow(this.get(t,e),n.get(t,e)));return this}}function checkRowIndex(n,t,e){let i=e?n.rows:n.rows-1;if(t<0||t>i)throw new RangeError("Row index out of range")}function checkColumnIndex(n,t,e){let i=e?n.columns:n.columns-1;if(t<0||t>i)throw new RangeError("Column index out of range")}function checkRowVector(n,t){if(t.to1DArray&&(t=t.to1DArray()),t.length!==n.columns)throw new RangeError("vector size must be the same as the number of columns");return t}function checkColumnVector(n,t){if(t.to1DArray&&(t=t.to1DArray()),t.length!==n.rows)throw new RangeError("vector size must be the same as the number of rows");return t}function checkRowIndices(n,t){if(!isAnyArray.isAnyArray(t))throw new TypeError("row indices must be an array");for(let e=0;e<t.length;e++)if(t[e]<0||t[e]>=n.rows)throw new RangeError("row indices are out of range")}function checkColumnIndices(n,t){if(!isAnyArray.isAnyArray(t))throw new TypeError("column indices must be an array");for(let e=0;e<t.length;e++)if(t[e]<0||t[e]>=n.columns)throw new RangeError("column indices are out of range")}function checkRange(n,t,e,i,s){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(checkNumber("startRow",t),checkNumber("endRow",e),checkNumber("startColumn",i),checkNumber("endColumn",s),t>e||i>s||t<0||t>=n.rows||e<0||e>=n.rows||i<0||i>=n.columns||s<0||s>=n.columns)throw new RangeError("Submatrix indices are out of range")}function newArray$1(n,t=0){let e=[];for(let i=0;i<n;i++)e.push(t);return e}function checkNumber(n,t){if("number"!=typeof t)throw new TypeError(`${n} must be a number`)}function checkNonEmpty(n){if(n.isEmpty())throw new Error("Empty matrix has no elements to index")}function sumByRow(n){let t=newArray$1(n.rows);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[e]+=n.get(e,i);return t}function sumByColumn(n){let t=newArray$1(n.columns);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[i]+=n.get(e,i);return t}function sumAll(n){let t=0;for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)t+=n.get(e,i);return t}function productByRow(n){let t=newArray$1(n.rows,1);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[e]*=n.get(e,i);return t}function productByColumn(n){let t=newArray$1(n.columns,1);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[i]*=n.get(e,i);return t}function productAll(n){let t=1;for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)t*=n.get(e,i);return t}function varianceByRow(n,t,e){const i=n.rows,s=n.columns,r=[];for(let a=0;a<i;a++){let i=0,o=0,l=0;for(let t=0;t<s;t++)l=n.get(a,t)-e[a],i+=l,o+=l*l;t?r.push((o-i*i/s)/(s-1)):r.push((o-i*i/s)/s)}return r}function varianceByColumn(n,t,e){const i=n.rows,s=n.columns,r=[];for(let a=0;a<s;a++){let s=0,o=0,l=0;for(let t=0;t<i;t++)l=n.get(t,a)-e[a],s+=l,o+=l*l;t?r.push((o-s*s/i)/(i-1)):r.push((o-s*s/i)/i)}return r}function varianceAll(n,t,e){const i=n.rows,s=n.columns,r=i*s;let a=0,o=0,l=0;for(let t=0;t<i;t++)for(let i=0;i<s;i++)l=n.get(t,i)-e,a+=l,o+=l*l;return t?(o-a*a/r)/(r-1):(o-a*a/r)/r}function centerByRow(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)-t[e])}function centerByColumn(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)-t[i])}function centerAll(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)-t)}function getScaleByRow(n){const t=[];for(let e=0;e<n.rows;e++){let i=0;for(let t=0;t<n.columns;t++)i+=Math.pow(n.get(e,t),2)/(n.columns-1);t.push(Math.sqrt(i))}return t}function scaleByRow(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)/t[e])}function getScaleByColumn(n){const t=[];for(let e=0;e<n.columns;e++){let i=0;for(let t=0;t<n.rows;t++)i+=Math.pow(n.get(t,e),2)/(n.rows-1);t.push(Math.sqrt(i))}return t}function scaleByColumn(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)/t[i])}function getScaleAll(n){const t=n.size-1;let e=0;for(let i=0;i<n.columns;i++)for(let s=0;s<n.rows;s++)e+=Math.pow(n.get(s,i),2)/t;return Math.sqrt(e)}function scaleAll(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)/t)}class AbstractMatrix{static from1DArray(n,t,e){if(n*t!==e.length)throw new RangeError("data length does not match given dimensions");let i=new Matrix$2(n,t);for(let s=0;s<n;s++)for(let n=0;n<t;n++)i.set(s,n,e[s*t+n]);return i}static rowVector(n){let t=new Matrix$2(1,n.length);for(let e=0;e<n.length;e++)t.set(0,e,n[e]);return t}static columnVector(n){let t=new Matrix$2(n.length,1);for(let e=0;e<n.length;e++)t.set(e,0,n[e]);return t}static zeros(n,t){return new Matrix$2(n,t)}static ones(n,t){return new Matrix$2(n,t).fill(1)}static rand(n,t,e={}){if("object"!=typeof e)throw new TypeError("options must be an object");const{random:i=Math.random}=e;let s=new Matrix$2(n,t);for(let e=0;e<n;e++)for(let n=0;n<t;n++)s.set(e,n,i());return s}static randInt(n,t,e={}){if("object"!=typeof e)throw new TypeError("options must be an object");const{min:i=0,max:s=1e3,random:r=Math.random}=e;if(!Number.isInteger(i))throw new TypeError("min must be an integer");if(!Number.isInteger(s))throw new TypeError("max must be an integer");if(i>=s)throw new RangeError("min must be smaller than max");let a=s-i,o=new Matrix$2(n,t);for(let e=0;e<n;e++)for(let n=0;n<t;n++){let t=i+Math.round(r()*a);o.set(e,n,t)}return o}static eye(n,t,e){void 0===t&&(t=n),void 0===e&&(e=1);let i=Math.min(n,t),s=this.zeros(n,t);for(let n=0;n<i;n++)s.set(n,n,e);return s}static diag(n,t,e){let i=n.length;void 0===t&&(t=i),void 0===e&&(e=t);let s=Math.min(i,t,e),r=this.zeros(t,e);for(let t=0;t<s;t++)r.set(t,t,n[t]);return r}static min(n,t){n=this.checkMatrix(n),t=this.checkMatrix(t);let e=n.rows,i=n.columns,s=new Matrix$2(e,i);for(let r=0;r<e;r++)for(let e=0;e<i;e++)s.set(r,e,Math.min(n.get(r,e),t.get(r,e)));return s}static max(n,t){n=this.checkMatrix(n),t=this.checkMatrix(t);let e=n.rows,i=n.columns,s=new this(e,i);for(let r=0;r<e;r++)for(let e=0;e<i;e++)s.set(r,e,Math.max(n.get(r,e),t.get(r,e)));return s}static checkMatrix(n){return AbstractMatrix.isMatrix(n)?n:new Matrix$2(n)}static isMatrix(n){return null!=n&&"Matrix"===n.klass}get size(){return this.rows*this.columns}apply(n){if("function"!=typeof n)throw new TypeError("callback must be a function");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n.call(this,t,e);return this}to1DArray(){let n=[];for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n.push(this.get(t,e));return n}to2DArray(){let n=[];for(let t=0;t<this.rows;t++){n.push([]);for(let e=0;e<this.columns;e++)n[t].push(this.get(t,e))}return n}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let n=0;n<this.rows;n++)for(let t=0;t<=n;t++)if(this.get(n,t)!==this.get(t,n))return!1;return!0}return!1}isDistance(){if(!this.isSymmetric())return!1;for(let n=0;n<this.rows;n++)if(0!==this.get(n,n))return!1;return!0}isEchelonForm(){let n=0,t=0,e=-1,i=!0,s=!1;for(;n<this.rows&&i;){for(t=0,s=!1;t<this.columns&&!1===s;)0===this.get(n,t)?t++:1===this.get(n,t)&&t>e?(s=!0,e=t):(i=!1,s=!0);n++}return i}isReducedEchelonForm(){let n=0,t=0,e=-1,i=!0,s=!1;for(;n<this.rows&&i;){for(t=0,s=!1;t<this.columns&&!1===s;)0===this.get(n,t)?t++:1===this.get(n,t)&&t>e?(s=!0,e=t):(i=!1,s=!0);for(let e=t+1;e<this.rows;e++)0!==this.get(n,e)&&(i=!1);n++}return i}echelonForm(){let n=this.clone(),t=0,e=0;for(;t<n.rows&&e<n.columns;){let i=t;for(let s=t;s<n.rows;s++)n.get(s,e)>n.get(i,e)&&(i=s);if(0===n.get(i,e))e++;else{n.swapRows(t,i);let s=n.get(t,e);for(let i=e;i<n.columns;i++)n.set(t,i,n.get(t,i)/s);for(let i=t+1;i<n.rows;i++){let s=n.get(i,e)/n.get(t,e);n.set(i,e,0);for(let r=e+1;r<n.columns;r++)n.set(i,r,n.get(i,r)-n.get(t,r)*s)}t++,e++}}return n}reducedEchelonForm(){let n=this.echelonForm(),t=n.columns,e=n.rows,i=e-1;for(;i>=0;)if(0===n.maxRow(i))i--;else{let s=0,r=!1;for(;s<e&&!1===r;)1===n.get(i,s)?r=!0:s++;for(let e=0;e<i;e++){let r=n.get(e,s);for(let a=s;a<t;a++){let t=n.get(e,a)-r*n.get(i,a);n.set(e,a,t)}}i--}return n}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(n={}){if("object"!=typeof n)throw new TypeError("options must be an object");const{rows:t=1,columns:e=1}=n;if(!Number.isInteger(t)||t<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(e)||e<=0)throw new TypeError("columns must be a positive integer");let i=new Matrix$2(this.rows*t,this.columns*e);for(let n=0;n<t;n++)for(let t=0;t<e;t++)i.setSubMatrix(this,this.rows*n,this.columns*t);return i}fill(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,n);return this}neg(){return this.mulS(-1)}getRow(n){checkRowIndex(this,n);let t=[];for(let e=0;e<this.columns;e++)t.push(this.get(n,e));return t}getRowVector(n){return Matrix$2.rowVector(this.getRow(n))}setRow(n,t){checkRowIndex(this,n),t=checkRowVector(this,t);for(let e=0;e<this.columns;e++)this.set(n,e,t[e]);return this}swapRows(n,t){checkRowIndex(this,n),checkRowIndex(this,t);for(let e=0;e<this.columns;e++){let i=this.get(n,e);this.set(n,e,this.get(t,e)),this.set(t,e,i)}return this}getColumn(n){checkColumnIndex(this,n);let t=[];for(let e=0;e<this.rows;e++)t.push(this.get(e,n));return t}getColumnVector(n){return Matrix$2.columnVector(this.getColumn(n))}setColumn(n,t){checkColumnIndex(this,n),t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)this.set(e,n,t[e]);return this}swapColumns(n,t){checkColumnIndex(this,n),checkColumnIndex(this,t);for(let e=0;e<this.rows;e++){let i=this.get(e,n);this.set(e,n,this.get(e,t)),this.set(e,t,i)}return this}addRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n[e]);return this}subRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n[e]);return this}mulRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n[e]);return this}divRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n[e]);return this}addColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n[t]);return this}subColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n[t]);return this}mulColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n[t]);return this}divColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n[t]);return this}mulRow(n,t){checkRowIndex(this,n);for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)*t);return this}mulColumn(n,t){checkColumnIndex(this,n);for(let e=0;e<this.rows;e++)this.set(e,n,this.get(e,n)*t);return this}max(n){if(this.isEmpty())return NaN;switch(n){case"row":{const n=new Array(this.rows).fill(Number.NEGATIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)>n[t]&&(n[t]=this.get(t,e));return n}case"column":{const n=new Array(this.columns).fill(Number.NEGATIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)>n[e]&&(n[e]=this.get(t,e));return n}case void 0:{let n=this.get(0,0);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)>n&&(n=this.get(t,e));return n}default:throw new Error(`invalid option: ${n}`)}}maxIndex(){checkNonEmpty(this);let n=this.get(0,0),t=[0,0];for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.get(e,i)>n&&(n=this.get(e,i),t[0]=e,t[1]=i);return t}min(n){if(this.isEmpty())return NaN;switch(n){case"row":{const n=new Array(this.rows).fill(Number.POSITIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)<n[t]&&(n[t]=this.get(t,e));return n}case"column":{const n=new Array(this.columns).fill(Number.POSITIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)<n[e]&&(n[e]=this.get(t,e));return n}case void 0:{let n=this.get(0,0);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)<n&&(n=this.get(t,e));return n}default:throw new Error(`invalid option: ${n}`)}}minIndex(){checkNonEmpty(this);let n=this.get(0,0),t=[0,0];for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.get(e,i)<n&&(n=this.get(e,i),t[0]=e,t[1]=i);return t}maxRow(n){if(checkRowIndex(this,n),this.isEmpty())return NaN;let t=this.get(n,0);for(let e=1;e<this.columns;e++)this.get(n,e)>t&&(t=this.get(n,e));return t}maxRowIndex(n){checkRowIndex(this,n),checkNonEmpty(this);let t=this.get(n,0),e=[n,0];for(let i=1;i<this.columns;i++)this.get(n,i)>t&&(t=this.get(n,i),e[1]=i);return e}minRow(n){if(checkRowIndex(this,n),this.isEmpty())return NaN;let t=this.get(n,0);for(let e=1;e<this.columns;e++)this.get(n,e)<t&&(t=this.get(n,e));return t}minRowIndex(n){checkRowIndex(this,n),checkNonEmpty(this);let t=this.get(n,0),e=[n,0];for(let i=1;i<this.columns;i++)this.get(n,i)<t&&(t=this.get(n,i),e[1]=i);return e}maxColumn(n){if(checkColumnIndex(this,n),this.isEmpty())return NaN;let t=this.get(0,n);for(let e=1;e<this.rows;e++)this.get(e,n)>t&&(t=this.get(e,n));return t}maxColumnIndex(n){checkColumnIndex(this,n),checkNonEmpty(this);let t=this.get(0,n),e=[0,n];for(let i=1;i<this.rows;i++)this.get(i,n)>t&&(t=this.get(i,n),e[0]=i);return e}minColumn(n){if(checkColumnIndex(this,n),this.isEmpty())return NaN;let t=this.get(0,n);for(let e=1;e<this.rows;e++)this.get(e,n)<t&&(t=this.get(e,n));return t}minColumnIndex(n){checkColumnIndex(this,n),checkNonEmpty(this);let t=this.get(0,n),e=[0,n];for(let i=1;i<this.rows;i++)this.get(i,n)<t&&(t=this.get(i,n),e[0]=i);return e}diag(){let n=Math.min(this.rows,this.columns),t=[];for(let e=0;e<n;e++)t.push(this.get(e,e));return t}norm(n="frobenius"){switch(n){case"max":return this.max();case"frobenius":return Math.sqrt(this.dot(this));default:throw new RangeError(`unknown norm type: ${n}`)}}cumulativeSum(){let n=0;for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n+=this.get(t,e),this.set(t,e,n);return this}dot(n){AbstractMatrix.isMatrix(n)&&(n=n.to1DArray());let t=this.to1DArray();if(t.length!==n.length)throw new RangeError("vectors do not have the same size");let e=0;for(let i=0;i<t.length;i++)e+=t[i]*n[i];return e}mmul(n){n=Matrix$2.checkMatrix(n);let t=this.rows,e=this.columns,i=n.columns,s=new Matrix$2(t,i),r=new Float64Array(e);for(let a=0;a<i;a++){for(let t=0;t<e;t++)r[t]=n.get(t,a);for(let n=0;n<t;n++){let t=0;for(let i=0;i<e;i++)t+=this.get(n,i)*r[i];s.set(n,a,t)}}return s}strassen2x2(n){n=Matrix$2.checkMatrix(n);let t=new Matrix$2(2,2);const e=this.get(0,0),i=n.get(0,0),s=this.get(0,1),r=n.get(0,1),a=this.get(1,0),o=n.get(1,0),l=this.get(1,1),f=n.get(1,1),g=(e+l)*(i+f),u=(a+l)*i,h=e*(r-f),d=l*(o-i),c=(e+s)*f,b=g+d-c+(s-l)*(o+f),D=h+c,H=u+d,j=g-u+h+(a-e)*(i+r);return t.set(0,0,b),t.set(0,1,D),t.set(1,0,H),t.set(1,1,j),t}strassen3x3(n){n=Matrix$2.checkMatrix(n);let t=new Matrix$2(3,3);const e=this.get(0,0),i=this.get(0,1),s=this.get(0,2),r=this.get(1,0),a=this.get(1,1),o=this.get(1,2),l=this.get(2,0),f=this.get(2,1),g=this.get(2,2),u=n.get(0,0),h=n.get(0,1),d=n.get(0,2),c=n.get(1,0),b=n.get(1,1),D=n.get(1,2),H=n.get(2,0),j=n.get(2,1),m=n.get(2,2),A=(e-r)*(-h+b),C=(-e+r+a)*(u-h+b),T=(r+a)*(-u+h),p=e*u,I=(-e+l+f)*(u-d+D),P=(-e+l)*(d-D),M=(l+f)*(-u+d),N=(-s+f+g)*(b+H-j),w=(s-g)*(b-j),L=s*H,U=(f+g)*(-H+j),y=(-s+a+o)*(D+H-m),J=(s-o)*(D-m),B=(a+o)*(-H+m),R=p+L+i*c,k=(e+i+s-r-a-f-g)*b+C+T+p+N+L+U,E=p+I+M+(e+i+s-a-o-l-f)*D+L+y+B,x=A+a*(-u+h+c-b-D-H+m)+C+p+L+y+J,F=A+C+T+p+o*j,Q=L+y+J+B+r*d,X=p+I+P+f*(-u+d+c-b-D-H+j)+N+w+L,S=N+w+L+U+l*h,z=p+I+P+M+g*m;return t.set(0,0,R),t.set(0,1,k),t.set(0,2,E),t.set(1,0,x),t.set(1,1,F),t.set(1,2,Q),t.set(2,0,X),t.set(2,1,S),t.set(2,2,z),t}mmulStrassen(n){n=Matrix$2.checkMatrix(n);let t=this.clone(),e=t.rows,i=t.columns,s=n.rows,r=n.columns;function a(n,t,e){let i=n.rows,s=n.columns;if(i===t&&s===e)return n;{let i=AbstractMatrix.zeros(t,e);return i=i.setSubMatrix(n,0,0),i}}i!==s&&console.warn(`Multiplying ${e} x ${i} and ${s} x ${r} matrix: dimensions do not match.`);let o=Math.max(e,s),l=Math.max(i,r);return t=a(t,o,l),function n(t,e,i,s){if(i<=512||s<=512)return t.mmul(e);i%2==1&&s%2==1?(t=a(t,i+1,s+1),e=a(e,i+1,s+1)):i%2==1?(t=a(t,i+1,s),e=a(e,i+1,s)):s%2==1&&(t=a(t,i,s+1),e=a(e,i,s+1));let r=parseInt(t.rows/2,10),o=parseInt(t.columns/2,10),l=t.subMatrix(0,r-1,0,o-1),f=e.subMatrix(0,r-1,0,o-1),g=t.subMatrix(0,r-1,o,t.columns-1),u=e.subMatrix(0,r-1,o,e.columns-1),h=t.subMatrix(r,t.rows-1,0,o-1),d=e.subMatrix(r,e.rows-1,0,o-1),c=t.subMatrix(r,t.rows-1,o,t.columns-1),b=e.subMatrix(r,e.rows-1,o,e.columns-1),D=n(AbstractMatrix.add(l,c),AbstractMatrix.add(f,b),r,o),H=n(AbstractMatrix.add(h,c),f,r,o),j=n(l,AbstractMatrix.sub(u,b),r,o),m=n(c,AbstractMatrix.sub(d,f),r,o),A=n(AbstractMatrix.add(l,g),b,r,o),C=n(AbstractMatrix.sub(h,l),AbstractMatrix.add(f,u),r,o),T=n(AbstractMatrix.sub(g,c),AbstractMatrix.add(d,b),r,o),p=AbstractMatrix.add(D,m);p.sub(A),p.add(T);let I=AbstractMatrix.add(j,A),P=AbstractMatrix.add(H,m),M=AbstractMatrix.sub(D,H);M.add(j),M.add(C);let N=AbstractMatrix.zeros(2*p.rows,2*p.columns);return N=N.setSubMatrix(p,0,0),N=N.setSubMatrix(I,p.rows,0),N=N.setSubMatrix(P,0,p.columns),N=N.setSubMatrix(M,p.rows,p.columns),N.subMatrix(0,i-1,0,s-1)}(t,n=a(n,o,l),o,l)}scaleRows(n={}){if("object"!=typeof n)throw new TypeError("options must be an object");const{min:t=0,max:e=1}=n;if(!Number.isFinite(t))throw new TypeError("min must be a number");if(!Number.isFinite(e))throw new TypeError("max must be a number");if(t>=e)throw new RangeError("min must be smaller than max");let i=new Matrix$2(this.rows,this.columns);for(let n=0;n<this.rows;n++){const s=this.getRow(n);s.length>0&&rescale$1(s,{min:t,max:e,output:s}),i.setRow(n,s)}return i}scaleColumns(n={}){if("object"!=typeof n)throw new TypeError("options must be an object");const{min:t=0,max:e=1}=n;if(!Number.isFinite(t))throw new TypeError("min must be a number");if(!Number.isFinite(e))throw new TypeError("max must be a number");if(t>=e)throw new RangeError("min must be smaller than max");let i=new Matrix$2(this.rows,this.columns);for(let n=0;n<this.columns;n++){const s=this.getColumn(n);s.length&&rescale$1(s,{min:t,max:e,output:s}),i.setColumn(n,s)}return i}flipRows(){const n=Math.ceil(this.columns/2);for(let t=0;t<this.rows;t++)for(let e=0;e<n;e++){let n=this.get(t,e),i=this.get(t,this.columns-1-e);this.set(t,e,i),this.set(t,this.columns-1-e,n)}return this}flipColumns(){const n=Math.ceil(this.rows/2);for(let t=0;t<this.columns;t++)for(let e=0;e<n;e++){let n=this.get(e,t),i=this.get(this.rows-1-e,t);this.set(e,t,i),this.set(this.rows-1-e,t,n)}return this}kroneckerProduct(n){n=Matrix$2.checkMatrix(n);let t=this.rows,e=this.columns,i=n.rows,s=n.columns,r=new Matrix$2(t*i,e*s);for(let a=0;a<t;a++)for(let t=0;t<e;t++)for(let e=0;e<i;e++)for(let o=0;o<s;o++)r.set(i*a+e,s*t+o,this.get(a,t)*n.get(e,o));return r}kroneckerSum(n){if(n=Matrix$2.checkMatrix(n),!this.isSquare()||!n.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let t=this.rows,e=n.rows,i=this.kroneckerProduct(Matrix$2.eye(e,e)),s=Matrix$2.eye(t,t).kroneckerProduct(n);return i.add(s)}transpose(){let n=new Matrix$2(this.columns,this.rows);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n.set(e,t,this.get(t,e));return n}sortRows(n=compareNumbers){for(let t=0;t<this.rows;t++)this.setRow(t,this.getRow(t).sort(n));return this}sortColumns(n=compareNumbers){for(let t=0;t<this.columns;t++)this.setColumn(t,this.getColumn(t).sort(n));return this}subMatrix(n,t,e,i){checkRange(this,n,t,e,i);let s=new Matrix$2(t-n+1,i-e+1);for(let r=n;r<=t;r++)for(let t=e;t<=i;t++)s.set(r-n,t-e,this.get(r,t));return s}subMatrixRow(n,t,e){if(void 0===t&&(t=0),void 0===e&&(e=this.columns-1),t>e||t<0||t>=this.columns||e<0||e>=this.columns)throw new RangeError("Argument out of range");let i=new Matrix$2(n.length,e-t+1);for(let s=0;s<n.length;s++)for(let r=t;r<=e;r++){if(n[s]<0||n[s]>=this.rows)throw new RangeError(`Row index out of range: ${n[s]}`);i.set(s,r-t,this.get(n[s],r))}return i}subMatrixColumn(n,t,e){if(void 0===t&&(t=0),void 0===e&&(e=this.rows-1),t>e||t<0||t>=this.rows||e<0||e>=this.rows)throw new RangeError("Argument out of range");let i=new Matrix$2(e-t+1,n.length);for(let s=0;s<n.length;s++)for(let r=t;r<=e;r++){if(n[s]<0||n[s]>=this.columns)throw new RangeError(`Column index out of range: ${n[s]}`);i.set(r-t,s,this.get(r,n[s]))}return i}setSubMatrix(n,t,e){if((n=Matrix$2.checkMatrix(n)).isEmpty())return this;checkRange(this,t,t+n.rows-1,e,e+n.columns-1);for(let i=0;i<n.rows;i++)for(let s=0;s<n.columns;s++)this.set(t+i,e+s,n.get(i,s));return this}selection(n,t){checkRowIndices(this,n),checkColumnIndices(this,t);let e=new Matrix$2(n.length,t.length);for(let i=0;i<n.length;i++){let s=n[i];for(let n=0;n<t.length;n++){let r=t[n];e.set(i,n,this.get(s,r))}}return e}trace(){let n=Math.min(this.rows,this.columns),t=0;for(let e=0;e<n;e++)t+=this.get(e,e);return t}clone(){return this.constructor.copy(this,new Matrix$2(this.rows,this.columns))}static copy(n,t){for(const[e,i,s]of n.entries())t.set(e,i,s);return t}sum(n){switch(n){case"row":return sumByRow(this);case"column":return sumByColumn(this);case void 0:return sumAll(this);default:throw new Error(`invalid option: ${n}`)}}product(n){switch(n){case"row":return productByRow(this);case"column":return productByColumn(this);case void 0:return productAll(this);default:throw new Error(`invalid option: ${n}`)}}mean(n){const t=this.sum(n);switch(n){case"row":for(let n=0;n<this.rows;n++)t[n]/=this.columns;return t;case"column":for(let n=0;n<this.columns;n++)t[n]/=this.rows;return t;case void 0:return t/this.size;default:throw new Error(`invalid option: ${n}`)}}variance(n,t={}){if("object"==typeof n&&(t=n,n=void 0),"object"!=typeof t)throw new TypeError("options must be an object");const{unbiased:e=!0,mean:i=this.mean(n)}=t;if("boolean"!=typeof e)throw new TypeError("unbiased must be a boolean");switch(n){case"row":if(!isAnyArray.isAnyArray(i))throw new TypeError("mean must be an array");return varianceByRow(this,e,i);case"column":if(!isAnyArray.isAnyArray(i))throw new TypeError("mean must be an array");return varianceByColumn(this,e,i);case void 0:if("number"!=typeof i)throw new TypeError("mean must be a number");return varianceAll(this,e,i);default:throw new Error(`invalid option: ${n}`)}}standardDeviation(n,t){"object"==typeof n&&(t=n,n=void 0);const e=this.variance(n,t);if(void 0===n)return Math.sqrt(e);for(let n=0;n<e.length;n++)e[n]=Math.sqrt(e[n]);return e}center(n,t={}){if("object"==typeof n&&(t=n,n=void 0),"object"!=typeof t)throw new TypeError("options must be an object");const{center:e=this.mean(n)}=t;switch(n){case"row":if(!isAnyArray.isAnyArray(e))throw new TypeError("center must be an array");return centerByRow(this,e),this;case"column":if(!isAnyArray.isAnyArray(e))throw new TypeError("center must be an array");return centerByColumn(this,e),this;case void 0:if("number"!=typeof e)throw new TypeError("center must be a number");return centerAll(this,e),this;default:throw new Error(`invalid option: ${n}`)}}scale(n,t={}){if("object"==typeof n&&(t=n,n=void 0),"object"!=typeof t)throw new TypeError("options must be an object");let e=t.scale;switch(n){case"row":if(void 0===e)e=getScaleByRow(this);else if(!isAnyArray.isAnyArray(e))throw new TypeError("scale must be an array");return scaleByRow(this,e),this;case"column":if(void 0===e)e=getScaleByColumn(this);else if(!isAnyArray.isAnyArray(e))throw new TypeError("scale must be an array");return scaleByColumn(this,e),this;case void 0:if(void 0===e)e=getScaleAll(this);else if("number"!=typeof e)throw new TypeError("scale must be a number");return scaleAll(this,e),this;default:throw new Error(`invalid option: ${n}`)}}toString(n){return inspectMatrixWithOptions(this,n)}[Symbol.iterator](){return this.entries()}*entries(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)yield[n,t,this.get(n,t)]}*values(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)yield this.get(n,t)}}function compareNumbers(n,t){return n-t}function isArrayOfNumbers(n){return n.every((n=>"number"==typeof n))}AbstractMatrix.prototype.klass="Matrix","undefined"!=typeof Symbol&&(AbstractMatrix.prototype[Symbol.for("nodejs.util.inspect.custom")]=inspectMatrix),AbstractMatrix.random=AbstractMatrix.rand,AbstractMatrix.randomInt=AbstractMatrix.randInt,AbstractMatrix.diagonal=AbstractMatrix.diag,AbstractMatrix.prototype.diagonal=AbstractMatrix.prototype.diag,AbstractMatrix.identity=AbstractMatrix.eye,AbstractMatrix.prototype.negate=AbstractMatrix.prototype.neg,AbstractMatrix.prototype.tensorProduct=AbstractMatrix.prototype.kroneckerProduct;class Matrix$2 extends AbstractMatrix{data;#n(n,t){if(this.data=[],!(Number.isInteger(t)&&t>=0))throw new TypeError("nColumns must be a positive integer");for(let e=0;e<n;e++)this.data.push(new Float64Array(t));this.rows=n,this.columns=t}constructor(n,t){if(super(),Matrix$2.isMatrix(n))this.#n(n.rows,n.columns),Matrix$2.copy(n,this);else if(Number.isInteger(n)&&n>=0)this.#n(n,t);else{if(!isAnyArray.isAnyArray(n))throw new TypeError("First argument must be a positive number or an array");{const e=n;if("number"!=typeof(t=(n=e.length)?e[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let i=0;i<n;i++){if(e[i].length!==t)throw new RangeError("Inconsistent array dimensions");if(!isArrayOfNumbers(e[i]))throw new TypeError("Input data contains non-numeric values");this.data.push(Float64Array.from(e[i]))}this.rows=n,this.columns=t}}}set(n,t,e){return this.data[n][t]=e,this}get(n,t){return this.data[n][t]}removeRow(n){return checkRowIndex(this,n),this.data.splice(n,1),this.rows-=1,this}addRow(n,t){return void 0===t&&(t=n,n=this.rows),checkRowIndex(this,n,!0),t=Float64Array.from(checkRowVector(this,t)),this.data.splice(n,0,t),this.rows+=1,this}removeColumn(n){checkColumnIndex(this,n);for(let t=0;t<this.rows;t++){const e=new Float64Array(this.columns-1);for(let i=0;i<n;i++)e[i]=this.data[t][i];for(let i=n+1;i<this.columns;i++)e[i-1]=this.data[t][i];this.data[t]=e}return this.columns-=1,this}addColumn(n,t){void 0===t&&(t=n,n=this.columns),checkColumnIndex(this,n,!0),t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++){const i=new Float64Array(this.columns+1);let s=0;for(;s<n;s++)i[s]=this.data[e][s];for(i[s++]=t[e];s<this.columns+1;s++)i[s]=this.data[e][s-1];this.data[e]=i}return this.columns+=1,this}}installMathOperations(AbstractMatrix,Matrix$2);class SymmetricMatrix extends AbstractMatrix{#t;get size(){return this.#t.size}get rows(){return this.#t.rows}get columns(){return this.#t.columns}get diagonalSize(){return this.rows}static isSymmetricMatrix(n){return Matrix$2.isMatrix(n)&&"SymmetricMatrix"===n.klassType}static zeros(n){return new this(n)}static ones(n){return new this(n).fill(1)}constructor(n){if(super(),Matrix$2.isMatrix(n)){if(!n.isSymmetric())throw new TypeError("not symmetric data");this.#t=Matrix$2.copy(n,new Matrix$2(n.rows,n.rows))}else if(Number.isInteger(n)&&n>=0)this.#t=new Matrix$2(n,n);else if(this.#t=new Matrix$2(n),!this.isSymmetric())throw new TypeError("not symmetric data")}clone(){const n=new SymmetricMatrix(this.diagonalSize);for(const[t,e,i]of this.upperRightEntries())n.set(t,e,i);return n}toMatrix(){return new Matrix$2(this)}get(n,t){return this.#t.get(n,t)}set(n,t,e){return this.#t.set(n,t,e),this.#t.set(t,n,e),this}removeCross(n){return this.#t.removeRow(n),this.#t.removeColumn(n),this}addCross(n,t){void 0===t&&(t=n,n=this.diagonalSize);const e=t.slice();return e.splice(n,1),this.#t.addRow(n,e),this.#t.addColumn(n,t),this}applyMask(n){if(n.length!==this.diagonalSize)throw new RangeError("Mask size do not match with matrix size");const t=[];for(const[e,i]of n.entries())i||t.push(e);t.reverse();for(const n of t)this.removeCross(n);return this}toCompact(){const{diagonalSize:n}=this,t=new Array(n*(n+1)/2);for(let e=0,i=0,s=0;s<t.length;s++)t[s]=this.get(i,e),++e>=n&&(e=++i);return t}static fromCompact(n){const t=n.length,e=(Math.sqrt(8*t+1)-1)/2;if(!Number.isInteger(e))throw new TypeError(`This array is not a compact representation of a Symmetric Matrix, ${JSON.stringify(n)}`);const i=new SymmetricMatrix(e);for(let s=0,r=0,a=0;a<t;a++)i.set(s,r,n[a]),++s>=e&&(s=++r);return i}*upperRightEntries(){for(let n=0,t=0;n<this.diagonalSize;void 0){const e=this.get(n,t);yield[n,t,e],++t>=this.diagonalSize&&(t=++n)}}*upperRightValues(){for(let n=0,t=0;n<this.diagonalSize;void 0){const e=this.get(n,t);yield e,++t>=this.diagonalSize&&(t=++n)}}}SymmetricMatrix.prototype.klassType="SymmetricMatrix";class DistanceMatrix extends SymmetricMatrix{static isDistanceMatrix(n){return SymmetricMatrix.isSymmetricMatrix(n)&&"DistanceMatrix"===n.klassSubType}constructor(n){if(super(n),!this.isDistance())throw new TypeError("Provided arguments do no produce a distance matrix")}set(n,t,e){return n===t&&(e=0),super.set(n,t,e)}addCross(n,t){return void 0===t&&(t=n,n=this.diagonalSize),(t=t.slice())[n]=0,super.addCross(n,t)}toSymmetricMatrix(){return new SymmetricMatrix(this)}clone(){const n=new DistanceMatrix(this.diagonalSize);for(const[t,e,i]of this.upperRightEntries())t!==e&&n.set(t,e,i);return n}toCompact(){const{diagonalSize:n}=this,t=new Array((n-1)*n/2);for(let e=1,i=0,s=0;s<t.length;s++)t[s]=this.get(i,e),++e>=n&&(e=1+ ++i);return t}static fromCompact(n){const t=n.length,e=(Math.sqrt(8*t+1)+1)/2;if(!Number.isInteger(e))throw new TypeError(`This array is not a compact representation of a DistanceMatrix, ${JSON.stringify(n)}`);const i=new this(e);for(let s=1,r=0,a=0;a<t;a++)i.set(s,r,n[a]),++s>=e&&(s=1+ ++r);return i}}DistanceMatrix.prototype.klassSubType="DistanceMatrix";class BaseView extends AbstractMatrix{constructor(n,t,e){super(),this.matrix=n,this.rows=t,this.columns=e}}class MatrixColumnView extends BaseView{constructor(n,t){checkColumnIndex(n,t),super(n,n.rows,1),this.column=t}set(n,t,e){return this.matrix.set(n,this.column,e),this}get(n){return this.matrix.get(n,this.column)}}class MatrixColumnSelectionView extends BaseView{constructor(n,t){checkColumnIndices(n,t),super(n,n.rows,t.length),this.columnIndices=t}set(n,t,e){return this.matrix.set(n,this.columnIndices[t],e),this}get(n,t){return this.matrix.get(n,this.columnIndices[t])}}class MatrixFlipColumnView extends BaseView{constructor(n){super(n,n.rows,n.columns)}set(n,t,e){return this.matrix.set(n,this.columns-t-1,e),this}get(n,t){return this.matrix.get(n,this.columns-t-1)}}class MatrixFlipRowView extends BaseView{constructor(n){super(n,n.rows,n.columns)}set(n,t,e){return this.matrix.set(this.rows-n-1,t,e),this}get(n,t){return this.matrix.get(this.rows-n-1,t)}}class MatrixRowView extends BaseView{constructor(n,t){checkRowIndex(n,t),super(n,1,n.columns),this.row=t}set(n,t,e){return this.matrix.set(this.row,t,e),this}get(n,t){return this.matrix.get(this.row,t)}}class MatrixRowSelectionView extends BaseView{constructor(n,t){checkRowIndices(n,t),super(n,t.length,n.columns),this.rowIndices=t}set(n,t,e){return this.matrix.set(this.rowIndices[n],t,e),this}get(n,t){return this.matrix.get(this.rowIndices[n],t)}}class MatrixSelectionView extends BaseView{constructor(n,t,e){checkRowIndices(n,t),checkColumnIndices(n,e),super(n,t.length,e.length),this.rowIndices=t,this.columnIndices=e}set(n,t,e){return this.matrix.set(this.rowIndices[n],this.columnIndices[t],e),this}get(n,t){return this.matrix.get(this.rowIndices[n],this.columnIndices[t])}}class MatrixSubView extends BaseView{constructor(n,t,e,i,s){checkRange(n,t,e,i,s),super(n,e-t+1,s-i+1),this.startRow=t,this.startColumn=i}set(n,t,e){return this.matrix.set(this.startRow+n,this.startColumn+t,e),this}get(n,t){return this.matrix.get(this.startRow+n,this.startColumn+t)}}class MatrixTransposeView$1 extends BaseView{constructor(n){super(n,n.columns,n.rows)}set(n,t,e){return this.matrix.set(t,n,e),this}get(n,t){return this.matrix.get(t,n)}}class WrapperMatrix1D extends AbstractMatrix{constructor(n,t={}){const{rows:e=1}=t;if(n.length%e!=0)throw new Error("the data length is not divisible by the number of rows");super(),this.rows=e,this.columns=n.length/e,this.data=n}set(n,t,e){let i=this._calculateIndex(n,t);return this.data[i]=e,this}get(n,t){let e=this._calculateIndex(n,t);return this.data[e]}_calculateIndex(n,t){return n*this.columns+t}}class WrapperMatrix2D extends AbstractMatrix{constructor(n){super(),this.data=n,this.rows=n.length,this.columns=n[0].length}set(n,t,e){return this.data[n][t]=e,this}get(n,t){return this.data[n][t]}}function wrap(n,t){if(isAnyArray.isAnyArray(n))return n[0]&&isAnyArray.isAnyArray(n[0])?new WrapperMatrix2D(n):new WrapperMatrix1D(n,t);throw new Error("the argument is not an array")}class LuDecomposition{constructor(n){let t,e,i,s,r,a,o,l,f,g=(n=WrapperMatrix2D.checkMatrix(n)).clone(),u=g.rows,h=g.columns,d=new Float64Array(u),c=1;for(t=0;t<u;t++)d[t]=t;for(l=new Float64Array(u),e=0;e<h;e++){for(t=0;t<u;t++)l[t]=g.get(t,e);for(t=0;t<u;t++){for(f=Math.min(t,e),r=0,i=0;i<f;i++)r+=g.get(t,i)*l[i];l[t]-=r,g.set(t,e,l[t])}for(s=e,t=e+1;t<u;t++)Math.abs(l[t])>Math.abs(l[s])&&(s=t);if(s!==e){for(i=0;i<h;i++)a=g.get(s,i),g.set(s,i,g.get(e,i)),g.set(e,i,a);o=d[s],d[s]=d[e],d[e]=o,c=-c}if(e<u&&0!==g.get(e,e))for(t=e+1;t<u;t++)g.set(t,e,g.get(t,e)/g.get(e,e))}this.LU=g,this.pivotVector=d,this.pivotSign=c}isSingular(){let n=this.LU,t=n.columns;for(let e=0;e<t;e++)if(0===n.get(e,e))return!0;return!1}solve(n){n=Matrix$2.checkMatrix(n);let t=this.LU;if(t.rows!==n.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let e,i,s,r=n.columns,a=n.subMatrixRow(this.pivotVector,0,r-1),o=t.columns;for(s=0;s<o;s++)for(e=s+1;e<o;e++)for(i=0;i<r;i++)a.set(e,i,a.get(e,i)-a.get(s,i)*t.get(e,s));for(s=o-1;s>=0;s--){for(i=0;i<r;i++)a.set(s,i,a.get(s,i)/t.get(s,s));for(e=0;e<s;e++)for(i=0;i<r;i++)a.set(e,i,a.get(e,i)-a.get(s,i)*t.get(e,s))}return a}get determinant(){let n=this.LU;if(!n.isSquare())throw new Error("Matrix must be square");let t=this.pivotSign,e=n.columns;for(let i=0;i<e;i++)t*=n.get(i,i);return t}get lowerTriangularMatrix(){let n=this.LU,t=n.rows,e=n.columns,i=new Matrix$2(t,e);for(let s=0;s<t;s++)for(let t=0;t<e;t++)s>t?i.set(s,t,n.get(s,t)):s===t?i.set(s,t,1):i.set(s,t,0);return i}get upperTriangularMatrix(){let n=this.LU,t=n.rows,e=n.columns,i=new Matrix$2(t,e);for(let s=0;s<t;s++)for(let t=0;t<e;t++)s<=t?i.set(s,t,n.get(s,t)):i.set(s,t,0);return i}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function hypotenuse(n,t){let e=0;return Math.abs(n)>Math.abs(t)?(e=t/n,Math.abs(n)*Math.sqrt(1+e*e)):0!==t?(e=n/t,Math.abs(t)*Math.sqrt(1+e*e)):0}class QrDecomposition{constructor(n){let t,e,i,s,r=(n=WrapperMatrix2D.checkMatrix(n)).clone(),a=n.rows,o=n.columns,l=new Float64Array(o);for(i=0;i<o;i++){let n=0;for(t=i;t<a;t++)n=hypotenuse(n,r.get(t,i));if(0!==n){for(r.get(i,i)<0&&(n=-n),t=i;t<a;t++)r.set(t,i,r.get(t,i)/n);for(r.set(i,i,r.get(i,i)+1),e=i+1;e<o;e++){for(s=0,t=i;t<a;t++)s+=r.get(t,i)*r.get(t,e);for(s=-s/r.get(i,i),t=i;t<a;t++)r.set(t,e,r.get(t,e)+s*r.get(t,i))}}l[i]=-n}this.QR=r,this.Rdiag=l}solve(n){n=Matrix$2.checkMatrix(n);let t=this.QR,e=t.rows;if(n.rows!==e)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let i,s,r,a,o=n.columns,l=n.clone(),f=t.columns;for(r=0;r<f;r++)for(s=0;s<o;s++){for(a=0,i=r;i<e;i++)a+=t.get(i,r)*l.get(i,s);for(a=-a/t.get(r,r),i=r;i<e;i++)l.set(i,s,l.get(i,s)+a*t.get(i,r))}for(r=f-1;r>=0;r--){for(s=0;s<o;s++)l.set(r,s,l.get(r,s)/this.Rdiag[r]);for(i=0;i<r;i++)for(s=0;s<o;s++)l.set(i,s,l.get(i,s)-l.get(r,s)*t.get(i,r))}return l.subMatrix(0,f-1,0,o-1)}isFullRank(){let n=this.QR.columns;for(let t=0;t<n;t++)if(0===this.Rdiag[t])return!1;return!0}get upperTriangularMatrix(){let n,t,e=this.QR,i=e.columns,s=new Matrix$2(i,i);for(n=0;n<i;n++)for(t=0;t<i;t++)n<t?s.set(n,t,e.get(n,t)):n===t?s.set(n,t,this.Rdiag[n]):s.set(n,t,0);return s}get orthogonalMatrix(){let n,t,e,i,s=this.QR,r=s.rows,a=s.columns,o=new Matrix$2(r,a);for(e=a-1;e>=0;e--){for(n=0;n<r;n++)o.set(n,e,0);for(o.set(e,e,1),t=e;t<a;t++)if(0!==s.get(e,e)){for(i=0,n=e;n<r;n++)i+=s.get(n,e)*o.get(n,t);for(i=-i/s.get(e,e),n=e;n<r;n++)o.set(n,t,o.get(n,t)+i*s.get(n,e))}}return o}}class SingularValueDecomposition{constructor(n,t={}){if((n=WrapperMatrix2D.checkMatrix(n)).isEmpty())throw new Error("Matrix must be non-empty");let e=n.rows,i=n.columns;const{computeLeftSingularVectors:s=!0,computeRightSingularVectors:r=!0,autoTranspose:a=!1}=t;let o,l=Boolean(s),f=Boolean(r),g=!1;if(e<i)if(a){o=n.transpose(),e=o.rows,i=o.columns,g=!0;let t=l;l=f,f=t}else o=n.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else o=n.clone();let u=Math.min(e,i),h=Math.min(e+1,i),d=new Float64Array(h),c=new Matrix$2(e,u),b=new Matrix$2(i,i),D=new Float64Array(i),H=new Float64Array(e),j=new Float64Array(h);for(let n=0;n<h;n++)j[n]=n;let m=Math.min(e-1,i),A=Math.max(0,Math.min(i-2,e)),C=Math.max(m,A);for(let n=0;n<C;n++){if(n<m){d[n]=0;for(let t=n;t<e;t++)d[n]=hypotenuse(d[n],o.get(t,n));if(0!==d[n]){o.get(n,n)<0&&(d[n]=-d[n]);for(let t=n;t<e;t++)o.set(t,n,o.get(t,n)/d[n]);o.set(n,n,o.get(n,n)+1)}d[n]=-d[n]}for(let t=n+1;t<i;t++){if(n<m&&0!==d[n]){let i=0;for(let s=n;s<e;s++)i+=o.get(s,n)*o.get(s,t);i=-i/o.get(n,n);for(let s=n;s<e;s++)o.set(s,t,o.get(s,t)+i*o.get(s,n))}D[t]=o.get(n,t)}if(l&&n<m)for(let t=n;t<e;t++)c.set(t,n,o.get(t,n));if(n<A){D[n]=0;for(let t=n+1;t<i;t++)D[n]=hypotenuse(D[n],D[t]);if(0!==D[n]){D[n+1]<0&&(D[n]=0-D[n]);for(let t=n+1;t<i;t++)D[t]/=D[n];D[n+1]+=1}if(D[n]=-D[n],n+1<e&&0!==D[n]){for(let t=n+1;t<e;t++)H[t]=0;for(let t=n+1;t<e;t++)for(let e=n+1;e<i;e++)H[t]+=D[e]*o.get(t,e);for(let t=n+1;t<i;t++){let i=-D[t]/D[n+1];for(let s=n+1;s<e;s++)o.set(s,t,o.get(s,t)+i*H[s])}}if(f)for(let t=n+1;t<i;t++)b.set(t,n,D[t])}}let T=Math.min(i,e+1);if(m<i&&(d[m]=o.get(m,m)),e<T&&(d[T-1]=0),A+1<T&&(D[A]=o.get(A,T-1)),D[T-1]=0,l){for(let n=m;n<u;n++){for(let t=0;t<e;t++)c.set(t,n,0);c.set(n,n,1)}for(let n=m-1;n>=0;n--)if(0!==d[n]){for(let t=n+1;t<u;t++){let i=0;for(let s=n;s<e;s++)i+=c.get(s,n)*c.get(s,t);i=-i/c.get(n,n);for(let s=n;s<e;s++)c.set(s,t,c.get(s,t)+i*c.get(s,n))}for(let t=n;t<e;t++)c.set(t,n,-c.get(t,n));c.set(n,n,1+c.get(n,n));for(let t=0;t<n-1;t++)c.set(t,n,0)}else{for(let t=0;t<e;t++)c.set(t,n,0);c.set(n,n,1)}}if(f)for(let n=i-1;n>=0;n--){if(n<A&&0!==D[n])for(let t=n+1;t<i;t++){let e=0;for(let s=n+1;s<i;s++)e+=b.get(s,n)*b.get(s,t);e=-e/b.get(n+1,n);for(let s=n+1;s<i;s++)b.set(s,t,b.get(s,t)+e*b.get(s,n))}for(let t=0;t<i;t++)b.set(t,n,0);b.set(n,n,1)}let p=T-1,I=Number.EPSILON;for(;T>0;){let n,t;for(n=T-2;n>=-1&&-1!==n;n--){const t=Number.MIN_VALUE+I*Math.abs(d[n]+Math.abs(d[n+1]));if(Math.abs(D[n])<=t||Number.isNaN(D[n])){D[n]=0;break}}if(n===T-2)t=4;else{let e;for(e=T-1;e>=n&&e!==n;e--){let t=(e!==T?Math.abs(D[e]):0)+(e!==n+1?Math.abs(D[e-1]):0);if(Math.abs(d[e])<=I*t){d[e]=0;break}}e===n?t=3:e===T-1?t=1:(t=2,n=e)}switch(n++,t){case 1:{let t=D[T-2];D[T-2]=0;for(let e=T-2;e>=n;e--){let s=hypotenuse(d[e],t),r=d[e]/s,a=t/s;if(d[e]=s,e!==n&&(t=-a*D[e-1],D[e-1]=r*D[e-1]),f)for(let n=0;n<i;n++)s=r*b.get(n,e)+a*b.get(n,T-1),b.set(n,T-1,-a*b.get(n,e)+r*b.get(n,T-1)),b.set(n,e,s)}break}case 2:{let t=D[n-1];D[n-1]=0;for(let i=n;i<T;i++){let s=hypotenuse(d[i],t),r=d[i]/s,a=t/s;if(d[i]=s,t=-a*D[i],D[i]=r*D[i],l)for(let t=0;t<e;t++)s=r*c.get(t,i)+a*c.get(t,n-1),c.set(t,n-1,-a*c.get(t,i)+r*c.get(t,n-1)),c.set(t,i,s)}break}case 3:{const t=Math.max(Math.abs(d[T-1]),Math.abs(d[T-2]),Math.abs(D[T-2]),Math.abs(d[n]),Math.abs(D[n])),s=d[T-1]/t,r=d[T-2]/t,a=D[T-2]/t,o=d[n]/t,g=D[n]/t,u=((r+s)*(r-s)+a*a)/2,h=s*a*(s*a);let H=0;0===u&&0===h||(H=u<0?0-Math.sqrt(u*u+h):Math.sqrt(u*u+h),H=h/(u+H));let j=(o+s)*(o-s)+H,m=o*g;for(let t=n;t<T-1;t++){let s=hypotenuse(j,m);0===s&&(s=Number.MIN_VALUE);let r=j/s,a=m/s;if(t!==n&&(D[t-1]=s),j=r*d[t]+a*D[t],D[t]=r*D[t]-a*d[t],m=a*d[t+1],d[t+1]=r*d[t+1],f)for(let n=0;n<i;n++)s=r*b.get(n,t)+a*b.get(n,t+1),b.set(n,t+1,-a*b.get(n,t)+r*b.get(n,t+1)),b.set(n,t,s);if(s=hypotenuse(j,m),0===s&&(s=Number.MIN_VALUE),r=j/s,a=m/s,d[t]=s,j=r*D[t]+a*d[t+1],d[t+1]=-a*D[t]+r*d[t+1],m=a*D[t+1],D[t+1]=r*D[t+1],l&&t<e-1)for(let n=0;n<e;n++)s=r*c.get(n,t)+a*c.get(n,t+1),c.set(n,t+1,-a*c.get(n,t)+r*c.get(n,t+1)),c.set(n,t,s)}D[T-2]=j;break}case 4:if(d[n]<=0&&(d[n]=d[n]<0?-d[n]:0,f))for(let t=0;t<=p;t++)b.set(t,n,-b.get(t,n));for(;n<p&&!(d[n]>=d[n+1]);){let t=d[n];if(d[n]=d[n+1],d[n+1]=t,f&&n<i-1)for(let e=0;e<i;e++)t=b.get(e,n+1),b.set(e,n+1,b.get(e,n)),b.set(e,n,t);if(l&&n<e-1)for(let i=0;i<e;i++)t=c.get(i,n+1),c.set(i,n+1,c.get(i,n)),c.set(i,n,t);n++}T--}}if(g){let n=b;b=c,c=n}this.m=e,this.n=i,this.s=d,this.U=c,this.V=b}solve(n){let t=n,e=this.threshold,i=this.s.length,s=Matrix$2.zeros(i,i);for(let n=0;n<i;n++)Math.abs(this.s[n])<=e?s.set(n,n,0):s.set(n,n,1/this.s[n]);let r=this.U,a=this.rightSingularVectors,o=a.mmul(s),l=a.rows,f=r.rows,g=Matrix$2.zeros(l,f);for(let n=0;n<l;n++)for(let t=0;t<f;t++){let e=0;for(let s=0;s<i;s++)e+=o.get(n,s)*r.get(t,s);g.set(n,t,e)}return g.mmul(t)}solveForDiagonal(n){return this.solve(Matrix$2.diag(n))}inverse(){let n=this.V,t=this.threshold,e=n.rows,i=n.columns,s=new Matrix$2(e,this.s.length);for(let r=0;r<e;r++)for(let e=0;e<i;e++)Math.abs(this.s[e])>t&&s.set(r,e,n.get(r,e)/this.s[e]);let r=this.U,a=r.rows,o=r.columns,l=new Matrix$2(e,a);for(let n=0;n<e;n++)for(let t=0;t<a;t++){let e=0;for(let i=0;i<o;i++)e+=s.get(n,i)*r.get(t,i);l.set(n,t,e)}return l}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let n=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,t=0,e=this.s;for(let i=0,s=e.length;i<s;i++)e[i]>n&&t++;return t}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return Matrix$2.diag(this.s)}}function inverse$1(n,t=!1){return n=WrapperMatrix2D.checkMatrix(n),t?new SingularValueDecomposition(n).inverse():solve$1(n,Matrix$2.eye(n.rows))}function solve$1(n,t,e=!1){return n=WrapperMatrix2D.checkMatrix(n),t=WrapperMatrix2D.checkMatrix(t),e?new SingularValueDecomposition(n).solve(t):n.isSquare()?new LuDecomposition(n).solve(t):new QrDecomposition(n).solve(t)}function determinant(n){if((n=Matrix$2.checkMatrix(n)).isSquare()){if(0===n.columns)return 1;let t,e,i,s;if(2===n.columns)return t=n.get(0,0),e=n.get(0,1),i=n.get(1,0),s=n.get(1,1),t*s-e*i;if(3===n.columns){let s,r,a;return s=new MatrixSelectionView(n,[1,2],[1,2]),r=new MatrixSelectionView(n,[1,2],[0,2]),a=new MatrixSelectionView(n,[1,2],[0,1]),t=n.get(0,0),e=n.get(0,1),i=n.get(0,2),t*determinant(s)-e*determinant(r)+i*determinant(a)}return new LuDecomposition(n).determinant}throw Error("determinant can only be calculated for a square matrix")}function xrange(n,t){let e=[];for(let i=0;i<n;i++)i!==t&&e.push(i);return e}function dependenciesOneRow(n,t,e,i=1e-9,s=1e-9){if(n>s)return new Array(t.rows+1).fill(0);{let n=t.addRow(e,[0]);for(let t=0;t<n.rows;t++)Math.abs(n.get(t,0))<i&&n.set(t,0,0);return n.to1DArray()}}function linearDependencies(n,t={}){const{thresholdValue:e=1e-9,thresholdError:i=1e-9}=t;let s=(n=Matrix$2.checkMatrix(n)).rows,r=new Matrix$2(s,s);for(let t=0;t<s;t++){let a=Matrix$2.columnVector(n.getRow(t)),o=n.subMatrixRow(xrange(s,t)).transpose(),l=new SingularValueDecomposition(o).solve(a),f=Matrix$2.sub(a,o.mmul(l)).abs().max();r.setRow(t,dependenciesOneRow(f,l,t,e,i))}return r}function pseudoInverse(n,t=Number.EPSILON){if((n=Matrix$2.checkMatrix(n)).isEmpty())return n.transpose();let e=new SingularValueDecomposition(n,{autoTranspose:!0}),i=e.leftSingularVectors,s=e.rightSingularVectors,r=e.diagonal;for(let n=0;n<r.length;n++)Math.abs(r[n])>t?r[n]=1/r[n]:r[n]=0;return s.mmul(Matrix$2.diag(r).mmul(i.transpose()))}function covariance(n,t=n,e={}){n=new Matrix$2(n);let i=!1;if("object"!=typeof t||Matrix$2.isMatrix(t)||isAnyArray.isAnyArray(t)?t=new Matrix$2(t):(e=t,t=n,i=!0),n.rows!==t.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:s=!0}=e;s&&(n=n.center("column"),i||(t=t.center("column")));const r=n.transpose().mmul(t);for(let t=0;t<r.rows;t++)for(let e=0;e<r.columns;e++)r.set(t,e,r.get(t,e)*(1/(n.rows-1)));return r}function correlation(n,t=n,e={}){n=new Matrix$2(n);let i=!1;if("object"!=typeof t||Matrix$2.isMatrix(t)||isAnyArray.isAnyArray(t)?t=new Matrix$2(t):(e=t,t=n,i=!0),n.rows!==t.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:s=!0,scale:r=!0}=e;s&&(n.center("column"),i||t.center("column")),r&&(n.scale("column"),i||t.scale("column"));const a=n.standardDeviation("column",{unbiased:!0}),o=i?a:t.standardDeviation("column",{unbiased:!0}),l=n.transpose().mmul(t);for(let t=0;t<l.rows;t++)for(let e=0;e<l.columns;e++)l.set(t,e,l.get(t,e)*(1/(a[t]*o[e]))*(1/(n.rows-1)));return l}class EigenvalueDecomposition{constructor(n,t={}){const{assumeSymmetric:e=!1}=t;if(!(n=WrapperMatrix2D.checkMatrix(n)).isSquare())throw new Error("Matrix is not a square matrix");if(n.isEmpty())throw new Error("Matrix must be non-empty");let i,s,r=n.columns,a=new Matrix$2(r,r),o=new Float64Array(r),l=new Float64Array(r),f=n,g=!1;if(g=!!e||n.isSymmetric(),g){for(i=0;i<r;i++)for(s=0;s<r;s++)a.set(i,s,f.get(i,s));tred2(r,l,o,a),tql2(r,l,o,a)}else{let n=new Matrix$2(r,r),t=new Float64Array(r);for(s=0;s<r;s++)for(i=0;i<r;i++)n.set(i,s,f.get(i,s));orthes(r,n,t,a),hqr2(r,l,o,a,n)}this.n=r,this.e=l,this.d=o,this.V=a}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let n,t,e=this.n,i=this.e,s=this.d,r=new Matrix$2(e,e);for(n=0;n<e;n++){for(t=0;t<e;t++)r.set(n,t,0);r.set(n,n,s[n]),i[n]>0?r.set(n,n+1,i[n]):i[n]<0&&r.set(n,n-1,i[n])}return r}}function tred2(n,t,e,i){let s,r,a,o,l,f,g,u;for(l=0;l<n;l++)e[l]=i.get(n-1,l);for(o=n-1;o>0;o--){for(u=0,a=0,f=0;f<o;f++)u+=Math.abs(e[f]);if(0===u)for(t[o]=e[o-1],l=0;l<o;l++)e[l]=i.get(o-1,l),i.set(o,l,0),i.set(l,o,0);else{for(f=0;f<o;f++)e[f]/=u,a+=e[f]*e[f];for(s=e[o-1],r=Math.sqrt(a),s>0&&(r=-r),t[o]=u*r,a-=s*r,e[o-1]=s-r,l=0;l<o;l++)t[l]=0;for(l=0;l<o;l++){for(s=e[l],i.set(l,o,s),r=t[l]+i.get(l,l)*s,f=l+1;f<=o-1;f++)r+=i.get(f,l)*e[f],t[f]+=i.get(f,l)*s;t[l]=r}for(s=0,l=0;l<o;l++)t[l]/=a,s+=t[l]*e[l];for(g=s/(a+a),l=0;l<o;l++)t[l]-=g*e[l];for(l=0;l<o;l++){for(s=e[l],r=t[l],f=l;f<=o-1;f++)i.set(f,l,i.get(f,l)-(s*t[f]+r*e[f]));e[l]=i.get(o-1,l),i.set(o,l,0)}}e[o]=a}for(o=0;o<n-1;o++){if(i.set(n-1,o,i.get(o,o)),i.set(o,o,1),a=e[o+1],0!==a){for(f=0;f<=o;f++)e[f]=i.get(f,o+1)/a;for(l=0;l<=o;l++){for(r=0,f=0;f<=o;f++)r+=i.get(f,o+1)*i.get(f,l);for(f=0;f<=o;f++)i.set(f,l,i.get(f,l)-r*e[f])}}for(f=0;f<=o;f++)i.set(f,o+1,0)}for(l=0;l<n;l++)e[l]=i.get(n-1,l),i.set(n-1,l,0);i.set(n-1,n-1,1),t[0]=0}function tql2(n,t,e,i){let s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m;for(a=1;a<n;a++)t[a-1]=t[a];t[n-1]=0;let A=0,C=0,T=Number.EPSILON;for(f=0;f<n;f++){for(C=Math.max(C,Math.abs(e[f])+Math.abs(t[f])),g=f;g<n&&!(Math.abs(t[g])<=T*C);)g++;if(g>f)do{for(s=e[f],u=(e[f+1]-s)/(2*t[f]),h=hypotenuse(u,1),u<0&&(h=-h),e[f]=t[f]/(u+h),e[f+1]=t[f]*(u+h),d=e[f+1],r=s-e[f],a=f+2;a<n;a++)e[a]-=r;for(A+=r,u=e[g],c=1,b=c,D=c,H=t[f+1],j=0,m=0,a=g-1;a>=f;a--)for(D=b,b=c,m=j,s=c*t[a],r=c*u,h=hypotenuse(u,t[a]),t[a+1]=j*h,j=t[a]/h,c=u/h,u=c*e[a]-j*s,e[a+1]=r+j*(c*s+j*e[a]),l=0;l<n;l++)r=i.get(l,a+1),i.set(l,a+1,j*i.get(l,a)+c*r),i.set(l,a,c*i.get(l,a)-j*r);u=-j*m*D*H*t[f]/d,t[f]=j*u,e[f]=c*u}while(Math.abs(t[f])>T*C);e[f]=e[f]+A,t[f]=0}for(a=0;a<n-1;a++){for(l=a,u=e[a],o=a+1;o<n;o++)e[o]<u&&(l=o,u=e[o]);if(l!==a)for(e[l]=e[a],e[a]=u,o=0;o<n;o++)u=i.get(o,a),i.set(o,a,i.get(o,l)),i.set(o,l,u)}}function orthes(n,t,e,i){let s,r,a,o,l,f,g,u=n-1;for(f=1;f<=u-1;f++){for(g=0,o=f;o<=u;o++)g+=Math.abs(t.get(o,f-1));if(0!==g){for(a=0,o=u;o>=f;o--)e[o]=t.get(o,f-1)/g,a+=e[o]*e[o];for(r=Math.sqrt(a),e[f]>0&&(r=-r),a-=e[f]*r,e[f]=e[f]-r,l=f;l<n;l++){for(s=0,o=u;o>=f;o--)s+=e[o]*t.get(o,l);for(s/=a,o=f;o<=u;o++)t.set(o,l,t.get(o,l)-s*e[o])}for(o=0;o<=u;o++){for(s=0,l=u;l>=f;l--)s+=e[l]*t.get(o,l);for(s/=a,l=f;l<=u;l++)t.set(o,l,t.get(o,l)-s*e[l])}e[f]=g*e[f],t.set(f,f-1,g*r)}}for(o=0;o<n;o++)for(l=0;l<n;l++)i.set(o,l,o===l?1:0);for(f=u-1;f>=1;f--)if(0!==t.get(f,f-1)){for(o=f+1;o<=u;o++)e[o]=t.get(o,f-1);for(l=f;l<=u;l++){for(r=0,o=f;o<=u;o++)r+=e[o]*i.get(o,l);for(r=r/e[f]/t.get(f,f-1),o=f;o<=u;o++)i.set(o,l,i.get(o,l)+r*e[o])}}}function hqr2(n,t,e,i,s){let r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A=n-1,C=n-1,T=Number.EPSILON,p=0,I=0,P=0,M=0,N=0,w=0,L=0,U=0;for(r=0;r<n;r++)for((r<0||r>C)&&(e[r]=s.get(r,r),t[r]=0),a=Math.max(r-1,0);a<n;a++)I+=Math.abs(s.get(r,a));for(;A>=0;){for(l=A;l>0&&(w=Math.abs(s.get(l-1,l-1))+Math.abs(s.get(l,l)),0===w&&(w=I),!(Math.abs(s.get(l,l-1))<T*w));)l--;if(l===A)s.set(A,A,s.get(A,A)+p),e[A]=s.get(A,A),t[A]=0,A--,U=0;else if(l===A-1){if(u=s.get(A,A-1)*s.get(A-1,A),P=(s.get(A-1,A-1)-s.get(A,A))/2,M=P*P+u,L=Math.sqrt(Math.abs(M)),s.set(A,A,s.get(A,A)+p),s.set(A-1,A-1,s.get(A-1,A-1)+p),h=s.get(A,A),M>=0){for(L=P>=0?P+L:P-L,e[A-1]=h+L,e[A]=e[A-1],0!==L&&(e[A]=h-u/L),t[A-1]=0,t[A]=0,h=s.get(A,A-1),w=Math.abs(h)+Math.abs(L),P=h/w,M=L/w,N=Math.sqrt(P*P+M*M),P/=N,M/=N,a=A-1;a<n;a++)L=s.get(A-1,a),s.set(A-1,a,M*L+P*s.get(A,a)),s.set(A,a,M*s.get(A,a)-P*L);for(r=0;r<=A;r++)L=s.get(r,A-1),s.set(r,A-1,M*L+P*s.get(r,A)),s.set(r,A,M*s.get(r,A)-P*L);for(r=0;r<=C;r++)L=i.get(r,A-1),i.set(r,A-1,M*L+P*i.get(r,A)),i.set(r,A,M*i.get(r,A)-P*L)}else e[A-1]=h+P,e[A]=h+P,t[A-1]=L,t[A]=-L;A-=2,U=0}else{if(h=s.get(A,A),d=0,u=0,l<A&&(d=s.get(A-1,A-1),u=s.get(A,A-1)*s.get(A-1,A)),10===U){for(p+=h,r=0;r<=A;r++)s.set(r,r,s.get(r,r)-h);w=Math.abs(s.get(A,A-1))+Math.abs(s.get(A-1,A-2)),h=d=.75*w,u=-.4375*w*w}if(30===U&&(w=(d-h)/2,w=w*w+u,w>0)){for(w=Math.sqrt(w),d<h&&(w=-w),w=h-u/((d-h)/2+w),r=0;r<=A;r++)s.set(r,r,s.get(r,r)-w);p+=w,h=d=u=.964}for(U+=1,f=A-2;f>=l&&(L=s.get(f,f),N=h-L,w=d-L,P=(N*w-u)/s.get(f+1,f)+s.get(f,f+1),M=s.get(f+1,f+1)-L-N-w,N=s.get(f+2,f+1),w=Math.abs(P)+Math.abs(M)+Math.abs(N),P/=w,M/=w,N/=w,f!==l)&&!(Math.abs(s.get(f,f-1))*(Math.abs(M)+Math.abs(N))<T*(Math.abs(P)*(Math.abs(s.get(f-1,f-1))+Math.abs(L)+Math.abs(s.get(f+1,f+1)))));)f--;for(r=f+2;r<=A;r++)s.set(r,r-2,0),r>f+2&&s.set(r,r-3,0);for(o=f;o<=A-1&&(j=o!==A-1,o!==f&&(P=s.get(o,o-1),M=s.get(o+1,o-1),N=j?s.get(o+2,o-1):0,h=Math.abs(P)+Math.abs(M)+Math.abs(N),0!==h&&(P/=h,M/=h,N/=h)),0!==h);o++)if(w=Math.sqrt(P*P+M*M+N*N),P<0&&(w=-w),0!==w){for(o!==f?s.set(o,o-1,-w*h):l!==f&&s.set(o,o-1,-s.get(o,o-1)),P+=w,h=P/w,d=M/w,L=N/w,M/=P,N/=P,a=o;a<n;a++)P=s.get(o,a)+M*s.get(o+1,a),j&&(P+=N*s.get(o+2,a),s.set(o+2,a,s.get(o+2,a)-P*L)),s.set(o,a,s.get(o,a)-P*h),s.set(o+1,a,s.get(o+1,a)-P*d);for(r=0;r<=Math.min(A,o+3);r++)P=h*s.get(r,o)+d*s.get(r,o+1),j&&(P+=L*s.get(r,o+2),s.set(r,o+2,s.get(r,o+2)-P*N)),s.set(r,o,s.get(r,o)-P),s.set(r,o+1,s.get(r,o+1)-P*M);for(r=0;r<=C;r++)P=h*i.get(r,o)+d*i.get(r,o+1),j&&(P+=L*i.get(r,o+2),i.set(r,o+2,i.get(r,o+2)-P*N)),i.set(r,o,i.get(r,o)-P),i.set(r,o+1,i.get(r,o+1)-P*M)}}}if(0!==I){for(A=n-1;A>=0;A--)if(P=e[A],M=t[A],0===M)for(l=A,s.set(A,A,1),r=A-1;r>=0;r--){for(u=s.get(r,r)-P,N=0,a=l;a<=A;a++)N+=s.get(r,a)*s.get(a,A);if(t[r]<0)L=u,w=N;else if(l=r,0===t[r]?s.set(r,A,0!==u?-N/u:-N/(T*I)):(h=s.get(r,r+1),d=s.get(r+1,r),M=(e[r]-P)*(e[r]-P)+t[r]*t[r],g=(h*w-L*N)/M,s.set(r,A,g),s.set(r+1,A,Math.abs(h)>Math.abs(L)?(-N-u*g)/h:(-w-d*g)/L)),g=Math.abs(s.get(r,A)),T*g*g>1)for(a=r;a<=A;a++)s.set(a,A,s.get(a,A)/g)}else if(M<0)for(l=A-1,Math.abs(s.get(A,A-1))>Math.abs(s.get(A-1,A))?(s.set(A-1,A-1,M/s.get(A,A-1)),s.set(A-1,A,-(s.get(A,A)-P)/s.get(A,A-1))):(m=cdiv(0,-s.get(A-1,A),s.get(A-1,A-1)-P,M),s.set(A-1,A-1,m[0]),s.set(A-1,A,m[1])),s.set(A,A-1,0),s.set(A,A,1),r=A-2;r>=0;r--){for(c=0,b=0,a=l;a<=A;a++)c+=s.get(r,a)*s.get(a,A-1),b+=s.get(r,a)*s.get(a,A);if(u=s.get(r,r)-P,t[r]<0)L=u,N=c,w=b;else if(l=r,0===t[r]?(m=cdiv(-c,-b,u,M),s.set(r,A-1,m[0]),s.set(r,A,m[1])):(h=s.get(r,r+1),d=s.get(r+1,r),D=(e[r]-P)*(e[r]-P)+t[r]*t[r]-M*M,H=2*(e[r]-P)*M,0===D&&0===H&&(D=T*I*(Math.abs(u)+Math.abs(M)+Math.abs(h)+Math.abs(d)+Math.abs(L))),m=cdiv(h*N-L*c+M*b,h*w-L*b-M*c,D,H),s.set(r,A-1,m[0]),s.set(r,A,m[1]),Math.abs(h)>Math.abs(L)+Math.abs(M)?(s.set(r+1,A-1,(-c-u*s.get(r,A-1)+M*s.get(r,A))/h),s.set(r+1,A,(-b-u*s.get(r,A)-M*s.get(r,A-1))/h)):(m=cdiv(-N-d*s.get(r,A-1),-w-d*s.get(r,A),L,M),s.set(r+1,A-1,m[0]),s.set(r+1,A,m[1]))),g=Math.max(Math.abs(s.get(r,A-1)),Math.abs(s.get(r,A))),T*g*g>1)for(a=r;a<=A;a++)s.set(a,A-1,s.get(a,A-1)/g),s.set(a,A,s.get(a,A)/g)}for(r=0;r<n;r++)if(r<0||r>C)for(a=r;a<n;a++)i.set(r,a,s.get(r,a));for(a=n-1;a>=0;a--)for(r=0;r<=C;r++){for(L=0,o=0;o<=Math.min(a,C);o++)L+=i.get(r,o)*s.get(o,a);i.set(r,a,L)}}}function cdiv(n,t,e,i){let s,r;return Math.abs(e)>Math.abs(i)?(s=i/e,r=e+s*i,[(n+s*t)/r,(t-s*n)/r]):(s=e/i,r=i+s*e,[(s*n+t)/r,(s*t-n)/r])}class CholeskyDecomposition{constructor(n){if(!(n=WrapperMatrix2D.checkMatrix(n)).isSymmetric())throw new Error("Matrix is not symmetric");let t,e,i,s=n,r=s.rows,a=new Matrix$2(r,r),o=!0;for(e=0;e<r;e++){let n=0;for(i=0;i<e;i++){let r=0;for(t=0;t<i;t++)r+=a.get(i,t)*a.get(e,t);r=(s.get(e,i)-r)/a.get(i,i),a.set(e,i,r),n+=r*r}for(n=s.get(e,e)-n,o&=n>0,a.set(e,e,Math.sqrt(Math.max(n,0))),i=e+1;i<r;i++)a.set(e,i,0)}this.L=a,this.positiveDefinite=Boolean(o)}isPositiveDefinite(){return this.positiveDefinite}solve(n){n=WrapperMatrix2D.checkMatrix(n);let t=this.L,e=t.rows;if(n.rows!==e)throw new Error("Matrix dimensions do not match");if(!1===this.isPositiveDefinite())throw new Error("Matrix is not positive definite");let i,s,r,a=n.columns,o=n.clone();for(r=0;r<e;r++)for(s=0;s<a;s++){for(i=0;i<r;i++)o.set(r,s,o.get(r,s)-o.get(i,s)*t.get(r,i));o.set(r,s,o.get(r,s)/t.get(r,r))}for(r=e-1;r>=0;r--)for(s=0;s<a;s++){for(i=r+1;i<e;i++)o.set(r,s,o.get(r,s)-o.get(i,s)*t.get(i,r));o.set(r,s,o.get(r,s)/t.get(r,r))}return o}get lowerTriangularMatrix(){return this.L}}class nipals{constructor(n,t={}){n=WrapperMatrix2D.checkMatrix(n);let{Y:e}=t;const{scaleScores:i=!1,maxIterations:s=1e3,terminationCriteria:r=1e-10}=t;let a;if(e){if(e=isAnyArray.isAnyArray(e)&&"number"==typeof e[0]?Matrix$2.columnVector(e):WrapperMatrix2D.checkMatrix(e),e.rows!==n.rows)throw new Error("Y should have the same number of rows as X");a=e.getColumnVector(0)}else a=n.getColumnVector(0);let o,l,f,g,u=1;for(let t=0;t<s&&u>r;t++)f=n.transpose().mmul(a).div(a.transpose().mmul(a).get(0,0)),f=f.div(f.norm()),o=n.mmul(f).div(f.transpose().mmul(f).get(0,0)),t>0&&(u=o.clone().sub(g).pow(2).sum()),g=o.clone(),e?(l=e.transpose().mmul(o).div(o.transpose().mmul(o).get(0,0)),l=l.div(l.norm()),a=e.mmul(l).div(l.transpose().mmul(l).get(0,0))):a=o;if(e){let t=n.transpose().mmul(o).div(o.transpose().mmul(o).get(0,0));t=t.div(t.norm());let i=n.clone().sub(o.clone().mmul(t.transpose())),s=a.transpose().mmul(o).div(o.transpose().mmul(o).get(0,0)),r=e.clone().sub(o.clone().mulS(s.get(0,0)).mmul(l.transpose()));this.t=o,this.p=t.transpose(),this.w=f.transpose(),this.q=l,this.u=a,this.s=o.transpose().mmul(o),this.xResidual=i,this.yResidual=r,this.betas=s}else this.w=f.transpose(),this.s=o.transpose().mmul(o).sqrt(),this.t=i?o.clone().div(this.s.get(0,0)):o,this.xResidual=n.sub(o.mmul(f.transpose()))}}matrix.AbstractMatrix=AbstractMatrix,matrix.CHO=CholeskyDecomposition,matrix.CholeskyDecomposition=CholeskyDecomposition,matrix.DistanceMatrix=DistanceMatrix;var EVD$1=matrix.EVD=EigenvalueDecomposition;matrix.EigenvalueDecomposition=EigenvalueDecomposition,matrix.LU=LuDecomposition,matrix.LuDecomposition=LuDecomposition;var Matrix_1=matrix.Matrix=Matrix$2;matrix.MatrixColumnSelectionView=MatrixColumnSelectionView,matrix.MatrixColumnView=MatrixColumnView,matrix.MatrixFlipColumnView=MatrixFlipColumnView,matrix.MatrixFlipRowView=MatrixFlipRowView,matrix.MatrixRowSelectionView=MatrixRowSelectionView,matrix.MatrixRowView=MatrixRowView,matrix.MatrixSelectionView=MatrixSelectionView,matrix.MatrixSubView=MatrixSubView;var MatrixTransposeView_1=matrix.MatrixTransposeView=MatrixTransposeView$1;matrix.NIPALS=nipals,matrix.Nipals=nipals,matrix.QR=QrDecomposition,matrix.QrDecomposition=QrDecomposition;var SVD$1=matrix.SVD=SingularValueDecomposition;matrix.SingularValueDecomposition=SingularValueDecomposition,matrix.SymmetricMatrix=SymmetricMatrix,matrix.WrapperMatrix1D=WrapperMatrix1D,matrix.WrapperMatrix2D=WrapperMatrix2D,matrix.correlation=correlation,matrix.covariance=covariance;var _default=matrix.default=Matrix$2;matrix.determinant=determinant;var inverse_1=matrix.inverse=inverse$1;matrix.linearDependencies=linearDependencies,matrix.pseudoInverse=pseudoInverse;var solve_1=matrix.solve=solve$1;matrix.wrap=wrap;const EVD=EVD$1,Matrix=Matrix_1,MatrixTransposeView=MatrixTransposeView_1,SVD=SVD$1;var Matrix$1=_default.Matrix?_default.Matrix:Matrix_1;const inverse=inverse_1,solve=solve_1;function xEnsureFloat64(n){return xCheck(n),n instanceof Float64Array?n.slice(0):Float64Array.from(n)}function xFindClosestIndex(n,t,e={}){const{sorted:i=!0}=e;if(i){let e=0,i=n.length-1,s=0;for(;i-e>1;)if(s=e+(i-e>>1),n[s]<t)e=s;else{if(!(n[s]>t))return s;i=s}return e<n.length-1?Math.abs(t-n[e])<Math.abs(n[e+1]-t)?e:e+1:e}{let e=0,i=Number.POSITIVE_INFINITY;for(let s=0;s<n.length;s++){const r=Math.abs(n[s]-t);r<i&&(i=r,e=s)}return e}}function xGetFromToIndex(n,t={}){let{fromIndex:e,toIndex:i}=t;const{from:s,to:r}=t;return void 0===e&&(e=void 0!==s?xFindClosestIndex(n,s):0),void 0===i&&(i=void 0!==r?xFindClosestIndex(n,r):n.length-1),e<0&&(e=0),i<0&&(i=0),e>=n.length&&(e=n.length-1),i>=n.length&&(i=n.length-1),e>i&&([e,i]=[i,e]),{fromIndex:e,toIndex:i}}const LOOP=8,FLOAT_MUL=1/16777216,sh1=15,sh2=18,sh3=11;function multiply_uint32(n,t){const e=65535&(n>>>=0);return((n-e)*(t>>>=0)>>>0)+e*t>>>0}class XSadd{constructor(n=Date.now()){this.state=new Uint32Array(4),this.init(n),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*FLOAT_MUL}init(n){if(!Number.isInteger(n))throw new TypeError("seed must be an integer");this.state[0]=n,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let n=1;n<LOOP;n++)this.state[3&n]^=n+multiply_uint32(1812433253,this.state[n-1&3]^this.state[n-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let n=0;n<LOOP;n++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let n=this.state[0];n^=n<<sh1,n^=n>>>sh2,n^=this.state[3]<<sh3,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=n}}let spare,hasSpare=!1;function createRandomArray(n={}){const{mean:t=0,standardDeviation:e=1,length:i=1e3,range:s=1,seed:r,distribution:a="normal"}=n,o=new XSadd(r),l=new Float64Array(i);switch(a){case"normal":for(let n=0;n<i;n++)l[n]=generateGaussian(t,e,o);break;case"uniform":for(let n=0;n<i;n++)l[n]=(o.random()-.5)*s+t;break;default:throw new Error(`unknown distribution: ${a}`)}return l}function generateGaussian(n,t,e){let i,s,r,a;if(hasSpare)hasSpare=!1,i=spare*t+n;else{do{s=2*e.random()-1,r=2*e.random()-1,a=s*s+r*r}while(a>=1||0===a);a=Math.sqrt(-2*Math.log(a)/a),spare=r*a,hasSpare=!0,i=n+t*s*a}return i}function xMaxValue(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let s=n[e];for(let t=e+1;t<=i;t++)n[t]>s&&(s=n[t]);return s}function xMinValue(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let s=n[e];for(let t=e+1;t<=i;t++)n[t]<s&&(s=n[t]);return s}function xIsEquallySpaced(n,t={}){if(n.length<3)return!0;const{tolerance:e=.05}=t;let i=0,s=Number.MAX_SAFE_INTEGER;for(let t=0;t<n.length-1;++t){const e=n[t+1]-n[t];e<s&&(s=e),e>i&&(i=e)}return(i-s)/i<e}function xIsMonotonic(n){if(n.length<=2)return 1;if(n[0]===n[1]){for(let t=1;t<n.length-1;t++)if(n[t]!==n[t+1])return 0;return 1}if(n[0]<n[n.length-1]){for(let t=0;t<n.length-1;t++)if(n[t]>=n[t+1])return 0;return 1}for(let t=0;t<n.length-1;t++)if(n[t]<=n[t+1])return 0;return-1}function xMean(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let s=n[e];for(let t=e+1;t<=i;t++)s+=n[t];return s/(i-e+1)}function xMedianAbsoluteDeviation(n){const t=xMedian(n),e=new Float64Array(n.length);for(let i=0;i<n.length;i++)e[i]=Math.abs(n[i]-t);return{median:t,mad:xMedian(e)}}function xMinMaxValues(n){xCheck(n);let t=n[0],e=n[0];for(const i of n)i<t&&(t=i),i>e&&(e=i);return{min:t,max:e}}function xNoiseStandardDeviation(n){const{mad:t,median:e}=xMedianAbsoluteDeviation(n);return{sd:t/.6744897501960817,mad:t,median:e}}function xNorm(n){let t=0;for(const e of n)t+=e**2;return Math.sqrt(t)}function xSum(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let s=n[e];for(let t=e+1;t<=i;t++)s+=n[t];return s}function xNormed(n,t={}){const{algorithm:e="absolute",value:i=1}=t;xCheck(n);const s=getOutputArray(t.output,n.length);if(0===n.length)throw new Error("input must not be empty");switch(e.toLowerCase()){case"absolute":{const t=absoluteSum(n)/i;if(0===t)throw new Error("xNormed: trying to divide by 0");for(let e=0;e<n.length;e++)s[e]=n[e]/t;return s}case"max":{const t=xMaxValue(n);if(0===t)throw new Error("xNormed: trying to divide by 0");const e=i/t;for(let t=0;t<n.length;t++)s[t]=n[t]*e;return s}case"sum":{const t=xSum(n)/i;if(0===t)throw new Error("xNormed: trying to divide by 0");for(let e=0;e<n.length;e++)s[e]=n[e]/t;return s}default:throw new Error(`norm: unknown algorithm: ${e}`)}}function absoluteSum(n){let t=0;for(let e=0;e<n.length;e++)t+=Math.abs(n[e]);return t}function xPadding(n,t={}){const{size:e=0,value:i=0,algorithm:s=""}=t;if(xCheck(n),!s)return n instanceof Float64Array?n.slice():Float64Array.from(n);const r=new Float64Array(n.length+2*e);for(let t=0;t<n.length;t++)r[t+e]=n[t];const a=e+n.length,o=2*e+n.length;switch(s.toLowerCase()){case"value":for(let n=0;n<e;n++)r[n]=i;for(let n=a;n<o;n++)r[n]=i;break;case"duplicate":for(let t=0;t<e;t++)r[t]=n[0];for(let t=a;t<o;t++)r[t]=n[n.length-1];break;case"circular":for(let t=0;t<e;t++)r[t]=n[(n.length-e%n.length+t)%n.length];for(let t=0;t<e;t++)r[t+a]=n[t%n.length];break;default:throw new Error("xPadding: unknown algorithm")}return r}function xVariance(n,t={}){if(!isAnyArray$1(n))throw new TypeError("input must be an array");const{unbiased:e=!0,mean:i=xMean(n)}=t;let s=0;for(let t=0;t<n.length;t++){const e=n[t]-i;s+=e*e}return e?s/(n.length-1):s/n.length}function xStandardDeviation(n,t={}){return Math.sqrt(xVariance(n,t))}function xParetoNormalization(n){xCheck(n);const t=[],e=Math.sqrt(xStandardDeviation(n));for(const i of n)t.push(i/e);return t}function xRescale(n,t={}){xCheck(n);const e=getOutputArray(t.output,n.length),i=xMinValue(n),s=xMaxValue(n);if(i===s)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");const{min:r=0,max:a=1}=t;if(r>=a)throw new RangeError("min option must be smaller than max option");const o=(a-r)/(s-i);for(let t=0;t<n.length;t++)e[t]=(n[t]-i)*o+r;return e}function xRolling(n,t,e={}){if(xCheck(n),"function"!=typeof t)throw new Error("fct has to be a function");const{window:i=5,padding:s={}}=e,{size:r=i-1,algorithm:a,value:o}=s;n=xPadding(n,{size:r,algorithm:a,value:o});const l=[];for(let e=0;e<n.length-i+1;e++)l.push(t(n.subarray(e,e+i)));return l}function xRollingAverage(n,t={}){return xRolling(n,xMean,t)}function xRollingMedian(n,t={}){return xRolling(n,xMedian,t)}function xSequentialFill(n=[],t={}){if("object"!=typeof n||isAnyArray$1(n)||(t=n,n=[]),!isAnyArray$1(n))throw new TypeError("input must be an array");const{to:e=10}=t;let{from:i=0,size:s=(Array.isArray(n)||n.constructor===Float64Array||n.constructor===Uint16Array?n.length:0),step:r=null}=t;if(s||(s=r?Math.floor((e-i)/r)+1:e-i+1),!r&&s&&(r=(e-i)/(s-1)),Array.isArray(n)){n.length=0;for(let t=0;t<s;t++)n.push(i),r&&(i+=r)}else{if(Array.isArray(n)||n.constructor===Float64Array||n.constructor===Uint16Array&&n.length!==s)throw new Error("sequentialFill typed array must have the correct length");for(let t=0;t<s;t++)(Array.isArray(n)||n.constructor===Float64Array||n.constructor===Uint16Array)&&(n[t]=i),r&&(i+=r)}return Array.isArray(n)||n.constructor===Float64Array||n.constructor===Uint16Array?Array.from(n):[]}function xSubtract(n,t){let e=!1,i=0;if(isAnyArray$1(t)){if(n.length!==t.length)throw new Error("xSubtract: size of array1 and array2 must be identical")}else e=!0,i=Number(t);const s=new Float64Array(n.length);if(e)for(let t=0;t<n.length;t++)s[t]=n[t]-i;else for(let e=0;e<n.length;e++)s[e]=n[e]-t[e];return s}function xyCheck(n,t={}){const{minLength:e}=t;if("object"!=typeof n||!isAnyArray$1(n.x)||!isAnyArray$1(n.y))throw new Error("Data must be an object of x and y arrays");if(n.x.length!==n.y.length)throw new Error("The x and y arrays must have the same length");if(e&&n.x.length<e)throw new Error(`data.x must have a length of at least ${e}`)}function xyFindClosestPoint(n,t){const{x:e,y:i}=n,s=xFindClosestIndex(e,t);return{x:e[s],y:i[s]}}function xyEnsureGrowingX(n){if(xyCheck(n),1===xIsMonotonic(n.x))return n;const t=Array.from(n.x),e=Array.from(n.y);let i=Number.NEGATIVE_INFINITY,s=0;for(let n=0;n<t.length;n++)i<t[n]&&(s<n&&(t[s]=t[n],e[s]=e[n]),s++,i=t[n]);return t.length=s,e.length=s,{x:t,y:e}}function zonesNormalize(n=[],t={}){const{exclusions:e=[]}=t;let{from:i=Number.NEGATIVE_INFINITY,to:s=Number.POSITIVE_INFINITY}=t;i>s&&([i,s]=[s,i]),0===(n=(n=JSON.parse(JSON.stringify(n)).map((n=>n.from>n.to?{from:n.to,to:n.from}:n))).sort(((n,t)=>n.from!==t.from?n.from-t.from:n.to-t.to))).length&&n.push({from:i,to:s});for(const t of n)i>t.from&&(t.from=i),s<t.to&&(t.to=s);if(0===(n=n.filter((n=>n.from<=n.to))).length)return[];let r=n[0];const a=[r];for(let t=1;t<n.length;t++){const e=n[t];e.from<=r.to?r.to<e.to&&(r.to=e.to):(r=e,a.push(r))}if(0===e.length)return a;const o=zonesNormalize(e);let l=0;const f=[];let g=0;for(let n=0;n<a.length&&!(g++>5);n++){const t=a[n];if(l!==o.length){for(;l<o.length&&o[l].to<=t.from;)l++;if(l!==o.length)if(t.to<o[l].from)f.push(t);else{if(o[l].to>=t.to){if(o[l].from<=t.from)continue;f.push({from:o[l].to,to:t.to})}o[l].from>t.from&&f.push({from:t.from,to:o[l].from}),t.from=o[l].to,n--}else f.push(t)}else f.push(t)}return f}function zonesWithPoints(n=[],t=10,e={}){if(0===n.length)return n;const i=zonesNormalize(n,e),s=i.reduce(((n,t)=>n+(t.to-t.from)),0)/t;let r=0;for(let n=0;n<i.length-1;n++){const e=i[n];e.numberOfPoints=Math.min(Math.round((e.to-e.from)/s),t-r),r+=e.numberOfPoints}return i[i.length-1].numberOfPoints=t-r,i}function equallySpacedSlot(n,t,e,i,s){const r=n.length,a=(i-e)/(s>1?s-1:1),o=a/2,l=n[n.length-1]-n[n.length-2],f=e-o,g=new Float64Array(s);let u=f,h=f+a,d=-Number.MAX_VALUE,c=0,b=n[0],D=t[0],H=0,j=!0,m=0,A=0,C=1,T=0;n:for(;;){if(d>=b)throw new Error("x must be a growing series");for(;d-h>0;){if(j&&(A++,j=!1),g[T]=A<=0?0:m/A,T++,T===s)break n;u=h,h+=a,m=0,A=0}d>u&&(m+=c,A++),(d===-Number.MAX_VALUE||H>1)&&A--,d=b,c=D,C<r?(b=n[C],D=t[C],C++):(b+=l,D=0,H++)}return g}function integral(n,t,e,i){return.5*e*t*t+i*t-(.5*e*n*n+i*n)}function equallySpacedSmooth(n,t,e,i,s){const r=n.length,a=(i-e)/(s>1?s-1:1),o=a/2,l=new Float64Array(s),f=n[1]-n[0],g=n[r-1]-n[r-2];let u=e-o,h=e+o,d=Number.MIN_SAFE_INTEGER,c=0,b=n[0]-f,D=0,H=0,j=0,m=0,A=0,C=0,T=0,p=0,I=0;n:for(;;){if(d>=b)throw new Error("x must be a growing series");for(d<=u&&u<=b&&(I=integral(0,u-d,j,c),A=H+I);b-h>=0;){if(I=integral(0,h-d,j,c),C=H+I,l[p++]=(C-A)/a,p===s)break n;u=h,h+=a,A=C}H+=integral(d,b,j,m),d=b,c=D,T<r?(b=n[T],D=t[T],T++):T===r&&(b+=g,D=0),j=getSlope(d,c,b,D),m=-j*d+c}return l}function getSlope(n,t,e,i){return(i-t)/(e-n)}function xyEquallySpaced(n,t={}){const{x:e,y:i}=n,s=e.length,{from:r=e[0],to:a=e[s-1],variant:o="smooth",numberOfPoints:l=100,exclusions:f=[],zones:g=[{from:r,to:a}]}=t;if(r>a)throw new RangeError("from should be larger than to");if(xyCheck(n),l<2)throw new RangeError("'numberOfPoints' option must be greater than 1");const u=zonesWithPoints(zonesNormalize(g,{from:r,to:a,exclusions:f}),l,{from:r,to:a});let h=[],d=[];for(const n of u){n.numberOfPoints||(n.numberOfPoints=0);const t=processZone(Array.from(e),Array.from(i),n.from,n.to,n.numberOfPoints,o);h=h.concat(t.x),d=d.concat(t.y)}return{x:h,y:d}}function processZone(n,t,e,i,s,r){if(s<1)throw new RangeError("the number of points must be at least 1");const a="slot"===r?Array.from(equallySpacedSlot(n,t,e,i,s)):Array.from(equallySpacedSmooth(n,t,e,i,s));return{x:Array.from(createFromToArray({from:e,to:i,length:s})),y:a}}function xyExtract(n,t={}){xyCheck(n);const{x:e,y:i}=n;let{zones:s}=t;if(s=zonesNormalize(s),void 0===e||void 0===i||!Array.isArray(s)||0===s.length)return n;const r=[],a=[];let o=s[0],l=0;n:for(let n=0;n<e.length;n++){for(;o.to<e[n];)if(l++,o=s[l],!o){n=e.length;break n}e[n]>=o.from&&(r.push(e[n]),a.push(i[n]))}return{x:r,y:a}}function xyFilterX(n,t={}){const{x:e,y:i}=n,{from:s=e[0],to:r=e[e.length-1],zones:a=[{from:s,to:r}],exclusions:o=[]}=t,l=zonesNormalize(a,{from:s,to:r,exclusions:o});let f=0;const g=[],u=[];let h=0;for(;h<e.length;){if(e[h]<=l[f].to&&e[h]>=l[f].from)g.push(e[h]),u.push(i[h]);else if(e[h]>l[f].to&&(f++,!l[f]))break;h++}return{x:g,y:u}}function xyIntegration(n,t={}){xyCheck(n,{minLength:1});const{x:e,y:i}=n;if(1===e.length)return 0;const{fromIndex:s,toIndex:r}=xGetFromToIndex(e,t);let a=0;for(let n=s;n<r;n++)a+=(e[n+1]-e[n])*(i[n+1]+i[n])/2;return a}function xySetYValue(n,t={}){xyCheck(n);const{x:e,y:i}=n,{value:s=0}=t;let{zones:r}=t;if(!Array.isArray(r)||0===r.length)return n;r=zonesNormalize(r);const a=e.slice(),o=i.slice();let l=r[0],f=0;n:for(let n=0;n<e.length;n++){for(;l.to<e[n];)if(f++,l=r[f],!l){n=e.length;break n}e[n]>=l.from&&(o[n]=s)}return{x:a,y:o}}function matrixCreateEmpty(n){const{matrix:t,nbRows:e=t?.length||1,nbColumns:i=t?.[0].length||1,ArrayConstructor:s=Float64Array}=n,r=new Array(e);for(let n=0;n<e;n++)r[n]=new s(i);return r}function matrixCheck(n){if(0===n.length||0===n[0].length)throw new RangeError("matrix should contain data");const t=n[0].length;for(let e=1;e<n.length;e++)if(n[e].length!==t)throw new RangeError("All rows should has the same length")}function matrixMinMaxZ(n){matrixCheck(n);const t=n.length,e=n[0].length;let i=n[0][0],s=n[0][0];for(let r=0;r<e;r++)for(let e=0;e<t;e++)n[e][r]<i&&(i=n[e][r]),n[e][r]>s&&(s=n[e][r]);return{min:i,max:s}}function addNoise(n,t={}){const{seed:e=0,distribution:i="normal",percent:s=1}=t,r=xMaxValue(n.y)*s/100,a=createRandomArray({distribution:i,seed:e,mean:0,standardDeviation:r,range:r,length:n.x.length});return n.y=xAdd(n.y,a),n}class SpectrumGenerator{constructor(n={}){const{from:t=0,to:e=1e3,nbPoints:i=10001,peakWidthFct:s,shape:r={kind:"gaussian",fwhm:5}}=n;this.from=t,this.to=e,this.nbPoints=i,this.interval=(this.to-this.from)/(this.nbPoints-1),this.peakWidthFct=s,this.maxPeakHeight=Number.MIN_SAFE_INTEGER,this.data={x:new Float64Array(this.nbPoints),y:new Float64Array(this.nbPoints)};const a=getShape1D(r);if(this.shape=a,assertNumber$2(this.from,"from"),assertNumber$2(this.to,"to"),assertInteger$1(this.nbPoints,"nbPoints"),this.to<=this.from)throw new RangeError("to option must be larger than from");if(this.peakWidthFct&&"function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(n,t){if(!(Array.isArray(n)||"object"==typeof n&&void 0!==n.x&&void 0!==n.y&&Array.isArray(n.x)&&Array.isArray(n.y)&&n.x.length===n.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(n))for(const e of n)this.addPeak(e,t);else for(let e=0;e<n.x.length;e++)this.addPeak([n.x[e],n.y[e]],t)}addPeak(n,t={}){if(Array.isArray(n)&&n.length<2)throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");if(!Array.isArray(n)&&(void 0===n.x||void 0===n.y))throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");let e,i,s,r,a;Array.isArray(n)?[e,i,s,a]=n:(e=n.x,i=n.y,r=n.width,a=n.shape),i>this.maxPeakHeight&&(this.maxPeakHeight=i);let{shape:o}=t;a&&(o=o?{...o,...a}:a);const l=o?getShape1D(o):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),this.shape),{width:f}=t;let{widthLeft:g,widthRight:u}=t;const h=void 0!==s?s:r?l.widthToFWHM(r):this.peakWidthFct?this.peakWidthFct(e):void 0!==f?f:l.fwhm;if(g||(g=h),u||(u=h),!g||!u)throw new Error("Width left or right is undefined or zero");const d=void 0===t.factor?l.getFactor():t.factor,c=e-g/2*d,b=e+u/2*d,D=Math.max(0,Math.floor((c-this.from)/this.interval)),H=Math.min(this.nbPoints-1,Math.ceil((b-this.from)/this.interval)),j=Math.round((e-this.from)/this.interval);l.fwhm=g;for(let n=D;n<Math.max(j,0);n++)this.data.y[n]+=i*l.fct(this.data.x[n]-e);l.fwhm=u;for(let n=Math.min(j,H);n<=H;n++)this.data.y[n]+=i*l.fct(this.data.x[n]-e)}addBaseline(n){return addBaseline(this.data,n),this}addNoise(n){return addNoise(this.data,n),this}getSpectrum(n={}){"boolean"==typeof n&&(n={copy:n});const{copy:t=!0,threshold:e=0}=n;if(e){const n=this.maxPeakHeight*e,t=[],i=[];for(let e=0;e<this.data.x.length;e++)this.data.y[e]>=n&&(t.push(this.data.x[e]),i.push(this.data.y[e]));return{x:Float64Array.from(t),y:Float64Array.from(i)}}return t?{x:this.data.x.slice(),y:this.data.y.slice()}:this.data}reset(){const n=this.data;for(let t=0;t<this.nbPoints;t++)n.x[t]=this.from+t*this.interval;return this}}function assertInteger$1(n,t){if(!Number.isInteger(n))throw new TypeError(`${t} option must be an integer`)}function assertNumber$2(n,t){if(!Number.isFinite(n))throw new TypeError(`${t} option must be a number`)}function generateSpectrum(n,t={}){const{generator:e,noise:i,baseline:s,threshold:r,peakOptions:a}=t,o=new SpectrumGenerator(e);return o.addPeaks(n,a),s&&o.addBaseline(s),i&&o.addNoise(i),o.getSpectrum({threshold:r})}const axis2D=["x","y"],peakCoordinates=["x","y","z"],convertWidthToFWHM=(n,t)=>{const e=ensureXYNumber$1(t);for(const t of axis2D)e[t]=n.widthToFWHM(e[t]);return e};class Spectrum2DGenerator{constructor(n={}){const{peakWidthFct:t=(()=>5),shape:e={kind:"gaussian"}}=n;let{from:i=0,to:s=100,nbPoints:r=1001}=n;i=ensureXYNumber$1(i),s=ensureXYNumber$1(s),r=ensureXYNumber$1(r);for(const n of axis2D)assertNumber$1(i[n],`from-${n}`),assertNumber$1(s[n],`to-${n}`),assertInteger(r[n],`nbPoints-${n}`);this.from=i,this.to=s,this.nbPoints=r,this.interval=calculeIntervals(i,s,r),this.peakWidthFct=t,this.maxPeakHeight=Number.MIN_SAFE_INTEGER;const a=getShape2D(e);this.shape=a,this.data={x:new Float64Array(r.x),y:new Float64Array(r.y),z:createMatrix(this.nbPoints)};for(const n of axis2D)if(this.to[n]<=this.from[n])throw new RangeError("to option must be larger than from");if("function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(n,t){if(!(Array.isArray(n)||"object"==typeof n&&void 0!==n.x&&void 0!==n.y&&Array.isArray(n.x)&&Array.isArray(n.y)&&n.x.length===n.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(n))for(const e of n)this.addPeak(e,t);else{const e=n.x.length;for(const t of peakCoordinates)if(n[t]&&Array.isArray(n[t])&&e!==n[t].length)throw new Error("x, y, z should have the same length");for(let e=0;e<n.x.length;e++)this.addPeak([n.x[e],n.y[e],n.z[e]],t)}return this}addPeak(n,t={}){if(Array.isArray(n)&&n.length<3)throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");if(!Array.isArray(n)&&peakCoordinates.some((t=>void 0===n[t])))throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");let e,i,s,r,a,o;Array.isArray(n)?[e,i,s,r,o]=n:(e=n.x,i=n.y,s=n.z,r=n.fwhm,a=n.width,o=n.shape);const l={x:e,y:i};s>this.maxPeakHeight&&(this.maxPeakHeight=s);const{width:f}=t;let{shape:g}=t;o&&(g=g?{...g,...o}:o);const u=g?getShape2D(g):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),JSON.parse(JSON.stringify(this.shape)));let{fwhm:h=(void 0!==r?r:a?convertWidthToFWHM(u,a):f?convertWidthToFWHM(u,f):this.peakWidthFct(e,i))}=t;h=ensureXYNumber$1(h);let d=void 0===t.factor?u.getFactor():t.factor;d=ensureXYNumber$1(d);const c={x:0,y:0},b={x:0,y:0};for(const n of axis2D){const t=l[n]-h[n]/2*d[n],e=l[n]+h[n]/2*d[n];c[n]=Math.max(0,Math.floor((t-this.from[n])/this.interval[n])),b[n]=Math.min(this.nbPoints[n],Math.ceil((e-this.from[n])/this.interval[n]))}u.fwhm=h;for(let n=c.x;n<b.x;n++)for(let t=c.y;t<b.y;t++){const e=s*u.fct(this.data.x[n]-l.x,this.data.y[t]-l.y);e>1e-6&&(this.data.z[t][n]+=e)}return this}getSpectrum(n={}){"boolean"==typeof n&&(n={copy:n});const{copy:t=!0}=n,e=matrixMinMaxZ(this.data.z);return{minX:this.from.x,maxX:this.to.x,maxY:this.to.y,minY:this.from.y,minZ:e.min,maxZ:e.max,z:t?this.data.z.slice():this.data.z}}reset(){const n=this.data;for(const t of axis2D)for(let e=0;e<this.nbPoints[t];e++)n[t][e]=this.from[t]+e*this.interval[t];for(const t of n.z)for(let n=0;n<t.length;n++)t[n]=0;return this}}function generateSpectrum2D(n,t={}){const{generator:e,peaks:i}=t,s=new Spectrum2DGenerator(e);return s.addPeaks(n,i),s.getSpectrum()}function ensureXYNumber$1(n){return"object"!=typeof n?{x:n,y:n}:{...n}}function calculeIntervals(n,t,e){return{x:(t.x-n.x)/(e.x-1),y:(t.y-n.y)/(e.y-1)}}function assertInteger(n,t){if(!Number.isInteger(n))throw new TypeError(`${t} option must be an integer`)}function assertNumber$1(n,t){if(!Number.isFinite(n))throw new TypeError(`${t} option must be a number`)}function createMatrix(n){const t=new Array(n.y);for(let e=0;e<n.y;e++)t[e]=new Float64Array(n.x);return t}function hasProperty(n,t){return t in n}const{parse:parse$7,stringify:stringify$7}=JSON;function convertWidth(n,t){const{frequency:e,convertTo:i,output:s=parse$7(stringify$7(n))}=t,r=getConverter(i,e);for(const n of s)if(n.width=r(n.width),hasProperty(n,"shape")){const t=n.shape;t.fwhm&&(t.fwhm=r(t.fwhm))}return s}function getConverter(n,t){switch(n){case"ppm":return n=>n/t;case"hz":return n=>n*t;default:throw new Error(`Does not support convert to ${n}`)}}function convertWidthToPPM(n,t){return convertWidth(n,{...t,convertTo:"ppm"})}function peaksToXY(n,t){const{frequency:e,nbPoints:i=1024,shape:s}=t;if(!e)throw new Error("frequency is mandatory");const r=convertWidthToPPM(n,{frequency:e});return generateSpectrum(r,{generator:{...getFromTo$1(r,t),nbPoints:i,shape:s}})}function getFromTo$1(n,t){if("to"in t&&"from"in t)return{from:t.from,to:t.to};n.sort(((n,t)=>n.x-t.x));const e=n[0],i=n[n.length-1],{from:s=e.x-2*e.width/t.frequency,to:r=i.x+2*i.width/t.frequency}=t;return{from:s,to:r}}for(var IDX=256,HEX=[],BUFFER;IDX--;)HEX[IDX]=(IDX+256).toString(16).substring(1);function v4(){var n,t=0,e="";if(!BUFFER||IDX+16>256){for(BUFFER=Array(t=256);t--;)BUFFER[t]=256*Math.random()|0;t=IDX=0}for(;t<16;t++)n=BUFFER[IDX+t],e+=6==t?HEX[15&n|64]:8==t?HEX[63&n|128]:HEX[n],1&t&&t>1&&t<11&&(e+="-");return IDX++,e}function sgg(n,t,e={}){let{windowSize:i=9,derivative:s=0,polynomial:r=3}=e;if(i%2==0||i<5||!Number.isInteger(i))throw new RangeError("Invalid window size (should be odd and at least 5 integer number)");if(!isAnyArray$1(n))throw new TypeError("Y values must be an array");if(void 0===t)throw new TypeError("X must be defined");if(i>n.length)throw new RangeError(`Window size is higher than the data length ${i}>${n.length}`);if(s<0||!Number.isInteger(s))throw new RangeError("Derivative should be a positive integer");if(r<1||!Number.isInteger(r))throw new RangeError("Polynomial should be a positive integer");r>=6&&console.warn("You should not use polynomial grade higher than 5 if you are not sure that your data arises from such a model. Possible polynomial oscillation problems");let a=Math.floor(i/2),o=n.length,l=new Float64Array(o),f=fullWeights(i,r,s),g=0,u=!0;isAnyArray$1(t)?u=!1:g=Math.pow(t,s);for(let e=0;e<a;e++){let r=f[a-e-1],h=f[a+e+1],d=0,c=0;for(let t=0;t<i;t++)d+=r[t]*n[t],c+=h[t]*n[o-i+t];u?(l[a-e-1]=d/g,l[o-a+e]=c/g):(g=getHs(t,a-e-1,a,s),l[a-e-1]=d/g,g=getHs(t,o-a+e,a,s),l[o-a+e]=c/g)}let h=f[a];for(let e=i;e<=o;e++){let r=0;for(let t=0;t<i;t++)r+=h[t]*n[t+e-i];u||(g=getHs(t,e-a-1,a,s)),l[e-a-1]=r/g}return l}function getHs(n,t,e,i){let s=0,r=0;for(let i=t-e;i<t+e;i++)i>=0&&i<n.length-1&&(s+=n[i+1]-n[i],r++);return Math.pow(s/r,i)}function gramPoly(n,t,e,i){let s=0;return s=e>0?(4*e-2)/(e*(2*t-e+1))*(n*gramPoly(n,t,e-1,i)+i*gramPoly(n,t,e-1,i-1))-(e-1)*(2*t+e)/(e*(2*t-e+1))*gramPoly(n,t,e-2,i):0===e&&0===i?1:0,s}function genFact(n,t){let e=1;if(n>=t)for(let i=n-t+1;i<=n;i++)e*=i;return e}function weight(n,t,e,i,s){let r=0;for(let a=0;a<=i;a++)r+=(2*a+1)*(genFact(2*e,a)/genFact(2*e+a+1,a+1))*gramPoly(n,e,a,0)*gramPoly(t,e,a,s);return r}function fullWeights(n,t,e){let i=new Array(n),s=Math.floor(n/2);for(let r=-s;r<=s;r++){i[r+s]=new Float64Array(n);for(let n=-s;n<=s;n++)i[r+s][n+s]=weight(n,r,s,t,e)}return i}function optimizeTop(n,t){const{x:e,y:i}=n;for(const n of t){let t=n.index;if(i[t-1]>=i[t-2]&&i[t-1]>=i[t]?t--:i[t+1]>=i[t]&&i[t+1]>=i[t+2]?t++:i[t-2]>=i[t-3]&&i[t-2]>=i[t-1]?t-=2:i[t+2]>=i[t+1]&&i[t+2]>=i[t+3]&&(t+=2),i[t-1]>0&&i[t+1]>0&&i[t]>=i[t-1]&&i[t]>=i[t+1]&&(i[t]!==i[t-1]||i[t]!==i[t+1])){let s=20*Math.log10(i[t-1]),r=20*Math.log10(i[t]),a=20*Math.log10(i[t+1]),o=.5*(s-a)/(s-2*r+a);n.x=e[t]+(e[t]-e[t-1])*o,n.y=i[t]-.25*(i[t-1]-i[t+1])*o}}}function gsd(n,t={}){let{sgOptions:e={windowSize:9,polynomial:3},noiseLevel:i,smoothY:s=!1,maxCriteria:r=!0,minMaxRatio:a=25e-5,realTopDetection:o=!1}=t,{x:l,y:f}=n;if(1!==xIsMonotonic(l))throw new Error("GSD only accepts monotone increasing x values");f=f.slice();let g=xIsEquallySpaced(l);if(void 0===i)if(g){const n=xNoiseStandardDeviation(f);i=r?n.median+1.5*n.sd:-n.median+1.5*n.sd}else i=0;else r||(i*=-1);if(!r)for(let n=0;n<f.length;n++)f[n]*=-1;if(void 0!==i)for(let n=0;n<f.length;n++)f[n]<i&&(f[n]=i);let u,h,d=f;const{windowSize:c,polynomial:b}=e;g?(s&&(d=sgg(f,l[1]-l[0],{windowSize:c,polynomial:b,derivative:0})),u=sgg(f,l[1]-l[0],{windowSize:c,polynomial:b,derivative:1}),h=sgg(f,l[1]-l[0],{windowSize:c,polynomial:b,derivative:2})):(s&&(d=sgg(f,l,{windowSize:c,polynomial:b,derivative:0})),u=sgg(f,l,{windowSize:c,polynomial:b,derivative:1}),h=sgg(f,l,{windowSize:c,polynomial:b,derivative:2}));const D=xMinValue(d),H=xMaxValue(d);if(D>H||D===H)return[];const j=D+(H-D)*a,m=l[1]-l[0];let A=null,C=null,T=[],p=[],I=[];for(let n=1;n<d.length-1;++n)(u[n]<u[n-1]&&u[n]<=u[n+1]||u[n]<=u[n-1]&&u[n]<u[n+1])&&(C={x:l[n],index:n},m>0&&null!==A&&(p.push(A),I.push(C))),(u[n]>=u[n-1]&&u[n]>u[n+1]||u[n]>u[n-1]&&u[n]>=u[n+1])&&(A={x:l[n],index:n},m<0&&null!==C&&(p.push(A),I.push(C))),h[n]<h[n-1]&&h[n]<h[n+1]&&T.push(n);let P=-1;const M=[];for(const n of T){let t=l[n],e=-1,i=P+1,s=Number.POSITIVE_INFINITY,r=0;for(;-1===e&&i<p.length&&(r=Math.abs(t-(p[i].x+I[i].x)/2),r<(I[i].x-p[i].x)/2&&(e=i,P=i),++i,!(r>=s));)s=r;if(-1!==e&&d[n]>j){let i=Math.abs(I[e].x-p[e].x);M.push({id:v4(),x:t,y:d[n],width:i,index:n,ddY:h[n],inflectionPoints:{from:p[e],to:I[e]}})}}return o&&optimizeTop({x:l,y:d},M),M.forEach((n=>{r||(n.y*=-1,n.ddY=-1*n.ddY)})),M.sort(((n,t)=>n.x-t.x)),M}function getSumOfShapes$1(n){return function(t){return e=>{let i=0;for(const s of n){const n=t[s.fromIndex],r=t[s.fromIndex+1];for(let n=2;n<t.length;n++)s.shapeFct[s.parameters[n]]=t[s.fromIndex+n];i+=r*s.shapeFct.fct(e-n)}return i}}}function assert(n,t){if(!n)throw new Error(t||"unreachable")}const DefaultParameters={x:{init:n=>n.x,min:(n,t)=>n.x-2*t.fwhm,max:(n,t)=>n.x+2*t.fwhm,gradientDifference:(n,t)=>.002*t.fwhm},y:{init:n=>n.y,min:n=>n.y<0?-1.1:0,max:n=>n.y<0?0:1.1,gradientDifference:()=>.001},fwhm:{init:(n,t)=>t.fwhm,min:(n,t)=>.25*t.fwhm,max:(n,t)=>4*t.fwhm,gradientDifference:(n,t)=>.002*t.fwhm},mu:{init:(n,t)=>t.mu,min:()=>0,max:()=>1,gradientDifference:()=>.01}},properties$1=["init","min","max","gradientDifference"];function getInternalPeaks(n,t,e={}){let i=0,s=[];const{baseline:r=t.min}=e,a=n.map((n=>({...n,y:(n.y-r)/t.range})));for(const n of a){const{id:r,shape:a=(e.shape?e.shape:{kind:"gaussian"})}=n,o=getShape1D(a),l=["x","y",...o.getParameters()],f={min:[],max:[],init:[],gradientDifference:[]};for(let i of l)for(let s of properties$1){let r=n?.parameters?.[i]?.[s];if(r){r=getNormalizedValue$1(r,i,s,t,e.baseline),f[s].push(r);continue}let a=e?.parameters?.[i]?.[s];if(a){if("number"==typeof a){a=getNormalizedValue$1(a,i,s,t,e.baseline),f[s].push(a);continue}{let r=a(n);r=getNormalizedValue$1(r,i,s,t,e.baseline),f[s].push(r);continue}}assert(DefaultParameters[i],`No default parameter for ${i}`);const l=DefaultParameters[i][s];f[s].push(l(n,o))}const g=i,u=g+l.length-1;i+=u-g+1,s.push({id:r,shape:a,shapeFct:o,parameters:l,propertiesValues:f,fromIndex:g,toIndex:u})}return s}function getNormalizedValue$1(n,t,e,i,s){return"y"===t?"gradientDifference"===e?n:void 0!==s?(n-s)/i.range:(n-i.min)/i.range:n}function checkOptions(n,t,e){let{timeout:i,minValues:s,maxValues:r,initialValues:a,weights:o=1,damping:l=.01,dampingStepUp:f=11,dampingStepDown:g=9,maxIterations:u=100,errorTolerance:h=1e-7,centralDifference:d=!1,gradientDifference:c=.1,improvementThreshold:b=.001}=e;if(l<=0)throw new Error("The damping option must be a positive number");if(!n.x||!n.y)throw new Error("The data parameter must have x and y elements");if(!isAnyArray$1(n.x)||n.x.length<2||!isAnyArray$1(n.y)||n.y.length<2)throw new Error("The data parameter elements must be an array with more than 2 points");if(n.x.length!==n.y.length)throw new Error("The data parameter elements must have the same size");if(!(a&&a.length>0))throw new Error("The initialValues option is mandatory and must be an array");let D,H,j=a,m=n.y.length,A=j.length;if(r=r||new Array(A).fill(Number.MAX_SAFE_INTEGER),s=s||new Array(A).fill(Number.MIN_SAFE_INTEGER),r.length!==s.length)throw new Error("minValues and maxValues must be the same size");if("number"==typeof c)c=new Array(j.length).fill(c);else{if(!isAnyArray$1(c))throw new Error("gradientDifference should be a number or array with length equal to the number of parameters");c.length!==A&&(c=new Array(A).fill(c[0]))}if("number"==typeof o){let n=1/o**2;D=()=>n}else{if(!isAnyArray$1(o))throw new Error("weights should be a number or array with length equal to the number of data points");if(o.length<n.x.length){let n=1/o[0]**2;D=()=>n}else D=n=>1/o[n]**2}if(void 0!==i){if("number"!=typeof i)throw new Error("timeout should be a number");let n=Date.now()+1e3*i;H=()=>Date.now()>n}else H=()=>!1;let C=new Array(n.x.length);for(let n=0;n<m;n++)C[n]=D(n);return{checkTimeout:H,minValues:s,maxValues:r,parameters:j,weightSquare:C,damping:l,dampingStepUp:f,dampingStepDown:g,maxIterations:u,errorTolerance:h,centralDifference:d,gradientDifference:c,improvementThreshold:b}}function errorCalculation(n,t,e,i){let s=0;const r=e(t);for(let t=0;t<n.x.length;t++)s+=Math.pow(n.y[t]-r(n.x[t]),2)/i[t];return s}function gradientFunction(n,t,e,i,s,r){const a=e.length,o=n.x.length;let l=Matrix.zeros(a,o),f=0;for(let g=0;g<a;g++){if(0===i[g])continue;let a=i[g],u=e.slice();u[g]+=a;let h=s(u);if(r){u=e.slice(),u[g]-=a,a*=2;let t=s(u);for(let e=0;e<o;e++)l.set(f,e,(t(n.x[e])-h(n.x[e]))/a)}else for(let e=0;e<o;e++)l.set(f,e,(t[e]-h(n.x[e]))/a);f++}return l}function matrixFunction(n,t){const e=n.x.length;let i=new Matrix(e,1);for(let s=0;s<e;s++)i.set(s,0,n.y[s]-t[s]);return i}function step(n,t,e,i,s,r,a){let o=e,l=Matrix.eye(t.length,t.length,o);const f=s(t);let g=new Float64Array(n.x.length);for(let t=0;t<n.x.length;t++)g[t]=f(n.x[t]);let u=gradientFunction(n,g,t,i,s,r),h=matrixFunction(n,g),d=inverse(l.add(u.mmul(u.transpose().scale("row",{scale:a})))),c=u.mmul(h.scale("row",{scale:a}));return{perturbations:d.mmul(c),jacobianWeightResidualError:c}}function levenbergMarquardt(n,t,e){let{checkTimeout:i,minValues:s,maxValues:r,parameters:a,weightSquare:o,damping:l,dampingStepUp:f,dampingStepDown:g,maxIterations:u,errorTolerance:h,centralDifference:d,gradientDifference:c,improvementThreshold:b}=checkOptions(n,t,e),D=errorCalculation(n,a,t,o),H=D,j=a.slice(),m=D<=h,A=0;for(;A<u&&!m;A++){let u=D,{perturbations:A,jacobianWeightResidualError:C}=step(n,a,l,c,t,d,o);for(let n=0;n<a.length;n++)a[n]=Math.min(Math.max(s[n],a[n]-A.get(n,0)),r[n]);if(D=errorCalculation(n,a,t,o),isNaN(D))break;if(D<H-h&&(H=D,j=a.slice()),l=(u-D)/A.transpose().mmul(A.mul(l).add(C)).get(0,0)>b?Math.max(l/g,1e-7):Math.min(l*f,1e7),i())throw new Error(`The execution time is over to ${e.timeout} seconds`);m=D<=h}return{parameterValues:j,parameterError:H,iterations:A}}function antiLowerConvexHull(n,t){if(n.length!==t.length)throw new RangeError("X and Y vectors has different dimensions");const e=n.length-1;if(0===e)return[0];if(1===e)return[0,1];let i=0,s=new Array(n.length).fill(!0);for(;;){const r=i,a=moveOn(i,e,s),o=moveOn(moveOn(i,e,s),e,s);if(n[o]*(t[r]-t[a])+n[r]*(t[a]-t[o])+n[a]*(t[o]-t[r])>=0?i=a:(s[a]=!1,i=moveBack(i,e,s)),o===e)break}return s.map(((n,t)=>!1!==n&&t)).filter((n=>!1!==n))}function moveBack(n,t,e){let i=n-1;for(;!1===e[i];)i--;return 0===n?t:i}function moveOn(n,t,e){let i=n+1;for(;!1===e[i];)i++;return n===t?0:i}function direct(n,t,e,i={}){const{iterations:s=50,epsilon:r=1e-4,tolerance:a=1e-16,tolerance2:o=1e-12,initialState:l={}}=i;if(void 0===n||void 0===t||void 0===e)throw new RangeError("There is something undefined");if(t=new Float64Array(t),e=new Float64Array(e),t.length!==e.length)throw new Error("Lower bounds and Upper bounds for x are not of the same length");let f=t.length,g=e.map(((n,e)=>n-t[e])),{numberOfRectangles:u=0,totalIterations:h=0,unitaryCoordinates:d=[new Float64Array(f).fill(.5)],middlePoint:c=new Float64Array(f).map(((n,e)=>t[e]+d[0][e]*g[e])),bestCurrentValue:b=n(c),fCalls:D=1,smallerDistance:H=0,edgeSizes:j=[new Float64Array(f).fill(.5)],diagonalDistances:m=[Math.sqrt(f*Math.pow(.5,2))],functionValues:A=[b],differentDistances:C=m,smallerValuesByDistance:T=[b],choiceLimit:p}=l;if(l.originalCoordinates&&l.originalCoordinates.length>0){b=xMinValue(A),p=r*Math.abs(b)>1e-8?r*Math.abs(b):1e-8,H=getMinIndex(A,m,p,b),d=l.originalCoordinates.slice();for(let n=0;n<d.length;n++)for(let e=0;e<t.length;e++)d[n][e]=(d[n][e]-t[e])/g[e]}let I=0;for(;I<s;){let e,i,s=[],l=C.findIndex((n=>n===m[H])),f=0;for(let n=l;n<C.length;n++)for(let t=0;t<A.length;t++)A[t]===T[n]&m[t]===C[n]&&(s[f++]=t);if(C.length-l>1){let n=m[H],t=A[H],e=C[C.length-1],r=(T[C.length-1]-t)/(e-n),a=t-r*n,l=new Uint32Array(f);f=0;for(let n=0;n<l.length;n++){let t=s[n];A[t]<=r*m[t]+a+o&&(l[f++]=t)}let g=[],u=[];for(let n=0;n<f;n++)g.push(m[l[n]]),u.push(A[l[n]]);let h=antiLowerConvexHull(g,u);i=[];for(let n=0;n<h.length;n++)i.push(l[h[n]])}else i=s.slice(0,f);e=i;for(let i=0;i<e.length;i++){let s=e[i],r=xMaxValue(j[s]),o=new Uint32Array(j[s].length);f=0;for(let n=0;n<j[s].length;n++)Math.abs(j[s][n]-r)<a&&(o[f++]=n);let l=2*r/3,h=[];for(let e=0;e<f;e++){let i=o[e],r=d[s].slice(),a=d[s].slice();r[i]+=l,a[i]-=l;let f=new Float64Array(r.length),u=new Float64Array(a.length);for(let n=0;n<r.length;n++)f[n]=t[n]+r[n]*g[n],u[n]=t[n]+a[n]*g[n];let c=n(f),b=n(u);D+=2,h.push({minValue:Math.min(c,b),index:e}),d.push(r,a),A.push(c,b)}let c=h.sort(((n,t)=>n.minValue-t.minValue));for(let n=0;n<f;n++){let t=o[c[n].index],e=u+2*(c[n].index+1)-1,i=u+2*(c[n].index+1);j[s][t]=l/2,j[e]=j[s].slice(),j[i]=j[s].slice(),m[s]=xNorm(j[s]),m[e]=m[s],m[i]=m[s]}u+=2*f}b=xMinValue(A),p=r*Math.abs(b)>1e-8?r*Math.abs(b):1e-8,H=getMinIndex(A,m,p,b),C=Array.from(new Set(m)),C=C.sort(((n,t)=>n-t)),T=[];for(let n=0;n<C.length;n++){let t,e=Number.POSITIVE_INFINITY;for(let i=0;i<m.length;i++)m[i]===C[n]&&A[i]<e&&(e=A[i],t=i);T.push(A[t])}for(let n=0;n<A.length;n++)if(A[n]===b){let e=[];for(let i=0;i<t.length;i++)e.push(t[i]+d[n][i]*g[i])}I+=1}let P={};P.minFunctionValue=b,P.iterations=I;let M=[];for(let n=0;n<u+1;n++){let e=[];for(let i=0;i<t.length;i++)e.push(t[i]+d[n][i]*g[i]);M.push(e)}P.finalState={numberOfRectangles:u,totalIterations:h+=s,originalCoordinates:M,middlePoint:c,fCalls:D,smallerDistance:H,edgeSizes:j,diagonalDistances:m,functionValues:A,differentDistances:C,smallerValuesByDistance:T,choiceLimit:p};let N=[];for(let n=0;n<A.length;n++)A[n]===b&&N.push(M[n]);return P.optima=N,P}function getMinIndex(n,t,e,i){let s=[];for(let r=0;r<n.length;r++)s[r]=Math.abs(n[r]-(i+e))/t[r];const r=xMinValue(s);return s.findIndex((n=>n===r))}function directOptimization$1(n,t,e){const{minValues:i,maxValues:s,maxIterations:r,epsilon:a,tolerance:o,tolerance2:l,initialState:f}=e,g=direct(getObjectiveFunction$1(n,t),i,s,{iterations:r,epsilon:a,tolerance:o,tolerance2:l,initialState:f}),{optima:u}=g;return{parameterError:g.minFunctionValue,iterations:g.iterations,parameterValues:u[0]}}function getObjectiveFunction$1(n,t){const{x:e,y:i}=n,s=e.length;return n=>{const r=t(n);let a=0;for(let n=0;n<s;n++)a+=Math.pow(i[n]-r(e[n]),2);return a}}function selectMethod(n={}){let{kind:t="lm",options:e}=n;switch(t){case"lm":case"levenbergMarquardt":return{algorithm:levenbergMarquardt,optimizationOptions:{damping:1.5,maxIterations:100,errorTolerance:1e-8,...e}};case"direct":return{algorithm:directOptimization$1,optimizationOptions:{iterations:20,epsilon:1e-4,tolerance:1e-16,tolerance2:1e-12,initialState:{},...e}};default:throw new Error("Unknown fitting algorithm")}}function optimize(n,t,e={}){let i=xMinMaxValues(n.y);const s={...i,range:i.max-i.min},r=getInternalPeaks(t,s,e),{baseline:a=s.min}=e;let o=new Float64Array(n.y.length);for(let t=0;t<n.y.length;t++)o[t]=(n.y[t]-a)/s.range;const l=r[r.length-1].toIndex+1,f=new Float64Array(l),g=new Float64Array(l),u=new Float64Array(l),h=new Float64Array(l);let d=0;for(const n of r)for(let t=0;t<n.parameters.length;t++)f[d]=n.propertiesValues.min[t],g[d]=n.propertiesValues.max[t],u[d]=n.propertiesValues.init[t],h[d]=n.propertiesValues.gradientDifference[t],d++;let{algorithm:c,optimizationOptions:b}=selectMethod(e.optimization),D=getSumOfShapes$1(r),H=c({x:n.x,y:o},D,{minValues:f,maxValues:g,initialValues:u,gradientDifference:h,...b});const j=H.parameterValues;let m=[];for(let n of r){const{id:t,shape:e,parameters:i,fromIndex:r}=n;let o={x:0,y:0,shape:e};t&&(o={...o,id:t}),o.x=j[r],o.y=j[r+1]*s.range+a;for(let n=2;n<i.length;n++)o.shape[i[n]]=j[r+n];m.push(o)}return{error:H.parameterError,iterations:H.iterations,peaks:m}}const{parse:parse$6,stringify:stringify$6}=JSON;function addMissingShape(n,t={}){const{shape:e={kind:"gaussian"},output:i=parse$6(stringify$6(n))}=t;let s=getShape1D(e);return i.map((n=>{if(hasShape(n)){if(!("fwhm"in n.shape)){const t=getShape1D(n.shape);n.shape.fwhm=t.widthToFWHM(n.width)}return n}return{...n,shape:{fwhm:s.widthToFWHM(n.width),...e}}}))}function hasShape(n){return"shape"in n}function groupPeaks(n,t={}){if(n&&0===n.length)return[];const{factor:e=1}=t;(n=JSON.parse(JSON.stringify(n))).sort(((n,t)=>n.x-t.x));let i=n[0],s=[i],r=[s];for(let t=1;t<n.length;t++){const a=n[t];(a.x-i.x)/((a.width+i.width)/2)<=e?s.push(a):(s=[a],r.push(s)),i=a}return r}function optimizePeaksWithLogs(n,t,e={}){const{fromTo:i={},baseline:s,shape:r={kind:"gaussian"},groupingFactor:a=1,factorLimits:o=2,optimization:l={kind:"lm",options:{timeout:10}}}=e;let f=groupPeaks(t,{factor:a}),g=[],u=[];return f.forEach((t=>{const e=Date.now(),a=addMissingShape(t,{shape:r}),f=a[0],h=a[a.length-1],{from:d=f.x-f.width*o,to:c=h.x+h.width*o}=i,{fromIndex:b,toIndex:D}=xGetFromToIndex(n.x,{from:d,to:c}),H=n.x instanceof Float64Array?n.x.subarray(b,D):n.x.slice(b,D),j=n.y instanceof Float64Array?n.y.subarray(b,D):n.y.slice(b,D),m={range:{from:d,to:c},parameters:l,groupSize:t.length,time:Date.now()-e};if(H.length>5){const{iterations:n,error:t,peaks:e}=optimize({x:H,y:j},a,{shape:r,baseline:s,optimization:l});for(let n=0;n<a.length;n++)u.push({...e[n],width:getShape1D(a[n].shape).fwhmToWidth(e[n].shape.fwhm)});g.push({...m,iterations:n,error:t,message:"optimization successful"})}else u.push(...a),g.push({...m,iterations:0,message:"x length too small for optimization"})})),{logs:g,optimizedPeaks:u}}function optimizePeaks(n,t,e={}){return optimizePeaksWithLogs(n,t,e).optimizedPeaks}const{parse:parse$5,stringify:stringify$5}=JSON;function addMissingIDs$1(n,t={}){const{output:e=parse$5(stringify$5(n))}=t;for(const n of e)"id"in n||(n.id=v4());return e}function joinBroadPeaks(n,t={}){let{shape:e={kind:"gaussian"},optimization:i={kind:"lm",options:{timeout:10}},broadWidth:s=.25,broadRatio:r=.0025}=t,a=0,o=0,l=1;const f=[];if(n.length<2)return addMissingIDs$1(addMissingShape(n.map(getGSDPeakOptimizedStructure),{shape:e}));let g=n[0].ddY;for(let t=1;t<n.length;t++)Math.abs(n[t].ddY)>g&&(g=Math.abs(n[t].ddY));const u=[];for(const t of n)Math.abs(t.ddY)<=r*g?f.push(t):u.push(getGSDPeakOptimizedStructure(t));f.push({x:Number.MAX_VALUE,y:0});let h={x:[f[0].x],y:[f[0].y]},d=[0];for(let n=1;n<f.length;n++)if(Math.abs(f[n-1].x-f[n].x)<s)h.x.push(f[n].x),h.y.push(f[n].y),f[n].y>a&&(a=f[n].y,o=n),d.push(n),l++;else{if(l>2){let n=optimizePeaks(h,[{id:v4(),x:f[o].x,y:a,width:h.x[0]-h.x[h.x.length-1]}],{shape:e,optimization:i});u.push(n[0])}else for(const n of d)u.push(getGSDPeakOptimizedStructure(f[n]));h={x:[f[n].x],y:[f[n].y]},d=[n],a=f[n].y,o=n,l=1}return u.sort(((n,t)=>n.x-t.x)),addMissingIDs$1(u,{output:u})}function getGSDPeakOptimizedStructure(n){const{id:t,shape:e,x:i,y:s,width:r}=n;let a={x:i,y:s,width:r,shape:e};return t&&(a.id=t),a}const{parse:parse$4,stringify:stringify$4}=JSON;function setShape(n,t={}){let{shape:e={kind:"gaussian"},output:i=parse$4(stringify$4(n))}=t,s=getShape1D(e);return i.map((n=>({...n,shape:{fwhm:s.widthToFWHM(n.width),...e}})))}function peakToXY(n,t){const e=addMissingShape([n])[0],i=getShape1D(e.shape).getFactor(),{from:s=e.x-n.width*i/t.frequency,to:r=e.x+n.width*i/t.frequency}=t;return peaksToXY([n],{...t,from:s,to:r})}class TreeSet{constructor(n){this.length=0,this.elements=[],this.compatator=n||function(n,t){return n-t}}size(){return this.elements.length}last(){return this.elements[this.length-1]}first(){return this.elements[0]}isEmpty(){return 0===this.size()}pollLast(){return this.length>0?(this.length--,this.elements.splice(this.length,1)):null}pollFirst(){return this.length>0?(this.length--,this.elements.splice(0,1)):null}add(n){let t=this.binarySearch(n);t<0&&(t=-t-1),this.elements.splice(t,0,n),this.length++}binarySearch(n){for(var t=0,e=this.elements.length-1;t<=e;){var i=t+e>>>1,s=this.elements[i],r=this.compatator(s,n);if(r<0)t=i+1;else{if(!(r>0))return i;e=i-1}}return-(t+1)}}var src$2=TreeSet,TreeSet$1=src$2;function createMapPossibleAssignments(n){const{restrictionByCS:t,predictions:e,targets:i,useIntegrationRestriction:s}=n,{tolerance:r,chemicalShiftRestriction:a}=t,o=Math.abs(r),l={};for(const n in e){const t=e[n];if(t.error&&(t.error=Math.abs(t.error)),l[n]=[],i)for(const e in i){const r=i[e],{nbAtoms:f}=t,{integration:g}=r;if(!s||(!(g>0)||f-g<1))if(a&&void 0!==t.delta){let i=o;t.error&&(i=Math.max(i,t.error));const s=r.signals&&r.signals.length>0?r.signals[0].delta:(r.to+r.from)/2;Math.abs(t.delta-s-o)<4*o&&l[n].push(e)}else l[n].push(e)}l[n].push("*")}return l}function partialScore$1(n,t){const{useIntegrationRestriction:e,diaIDPeerPossibleAssignment:i,nbAllowedUnAssigned:s,restrictionByCS:r,predictions:a,targets:o}=t,{useChemicalShiftScore:l}=r;let f=0;const g=n.length,u={};for(let t=0;t<n.length;t++){const e=n[t];e&&"*"!==e&&(u[e]||(u[e]=[]),u[e].push(i[t])),"*"===e&&f++}if(f>s)return 0;const h=Object.keys(u);if(0===h.length)return 0;if(e)for(const n of h){const t=u[n];let e=0;for(const n of t){e+=a[n].allHydrogens}const{integration:i}=o[n];if(e-i>=.5)return 0}return(l?chemicalShiftScoring(n,t):1)-f/g}function chemicalShiftScoring(n,t){const{tolerance:e}=t.restrictionByCS,{diaIDPeerPossibleAssignment:i,predictions:s,targets:r}=t;let a=0,o=0;for(let t=0;t<n.length;t++){const l=n[t];if(l&&"*"!==l){o++;const n=s[i[t]],f=r[l];let g=e;if(n.error&&(g=Math.max(n.error,e)),void 0===n.delta)a+=1;else{const t=f.signals&&f.signals.length>0?f.signals[0].delta:(f.to+f.from)/2;let e=Math.abs(n.delta-t);e<g?a+=1:(e=Math.abs(e-g),a+=-.25/g*e+1)}}}return o>0&&(a/=o),a}function exploreTreeRec(n,t,e,i){const{nSources:s,restrictionByCS:r,timeout:a,timeStart:o,maxSolutions:l,targets:f,predictions:g,lowerBoundScore:u,nbAllowedUnAssigned:h,possibleAssignmentMap:d,useIntegrationRestriction:c,diaIDPeerPossibleAssignment:b}=n;if(Date.now()-o>a)return i;const D=d[b[t]];for(const n of D){e[t]=n;const D=partialScore$1(e,{useIntegrationRestriction:c,diaIDPeerPossibleAssignment:b,nbAllowedUnAssigned:h,restrictionByCS:r,predictions:g,targets:f});0!==D?t===s-1&&D>=u?addSolution$1(i,{predictions:g,partial:e,score:D,maxSolutions:l}):t<s-1&&exploreTreeRec({nSources:s,restrictionByCS:r,timeout:a,timeStart:o,maxSolutions:l,targets:f,predictions:g,lowerBoundScore:u,nbAllowedUnAssigned:h,possibleAssignmentMap:d,useIntegrationRestriction:c,diaIDPeerPossibleAssignment:b},t+1,JSON.parse(JSON.stringify(e)),i):"*"===n&&(e[t]=null)}}function addSolution$1(n,t){const{score:e,maxSolutions:i,partial:s,predictions:r}=t;n.nSolutions++;const a={assignment:JSON.parse(JSON.stringify(s)),score:e/doubleAssignmentPenalty$1(s,r)};n.nSolutions>=i?a.score>n.solutions.last().score&&(n.solutions.pollLast(),n.solutions.add(a)):(n.solutions.add(a),n.nSolutions++)}function doubleAssignmentPenalty$1(n,t){const e=Object.keys(t).length-new Set(n).size;return e>0?2*e:1}const comparator$1=(n,t)=>t.score-n.score;async function buildAssignments$1(n){const{restrictionByCS:t={},useIntegrationRestriction:e,timeout:i,minScore:s,nbAllowedUnAssigned:r,maxSolutions:a,targets:o,joinedSignals:l}=n,{tolerance:f=1,useChemicalShiftScore:g=!1,chemicalShiftRestriction:u=!0}=t;let h={solutions:new TreeSet$1(comparator$1),nSolutions:0};const d=l.length,c={};for(const n of l){const t=n.diaIDs[0],e=n.atoms[0];c[t]={...n,diaIDIndex:e,allHydrogens:n.nbAtoms}}const b=createMapPossibleAssignments({restrictionByCS:{tolerance:f,useChemicalShiftScore:g,chemicalShiftRestriction:u},useIntegrationRestriction:e,predictions:c,targets:o}),D=Object.keys(b),H=fillPartial$1(d);h={solutions:new TreeSet$1(comparator$1),nSolutions:0};exploreTreeRec({nSources:d,restrictionByCS:{tolerance:f,useChemicalShiftScore:g,chemicalShiftRestriction:u},timeout:i,timeStart:Date.now(),targets:o,predictions:c,maxSolutions:a,lowerBoundScore:s,nbAllowedUnAssigned:r,possibleAssignmentMap:b,diaIDPeerPossibleAssignment:D,useIntegrationRestriction:e},0,H,h);const j=[];for(const n of h.solutions.elements){const{assignment:t,score:e}=n,i=JSON.parse(JSON.stringify(o));for(let n=0;n<t.length;n++){const e=i[t[n]];e.diaIDs||(e.diaIDs=[]),t[n]&&e.diaIDs.push(D[n])}j.push({score:e,assignment:Object.values(i)})}return j}function fillPartial$1(n,t=null){const e=new Array(n);for(let i=0;i<n;i++)e[i]=t;return e}function checkAtomsAndDiaIDs$1(n){for(const t of n){if(!t.atoms)throw new Error("signal has not atoms property");if(!t.diaIDs)throw new Error("signal has not diaIDs property");if(!t.nbAtoms)throw new Error("signal has not nbAtoms property")}}function checkForIntegration(n){for(const t of n)if(void 0===t.integration)throw new Error("ranges has not integration property")}async function get1HAssignments(n,t,e={}){const{restrictionByCS:i,minScore:s=1,maxSolutions:r=10,nbAllowedUnAssigned:a=0,timeout:o=6e3,predictionOptions:l={}}=e;if(!t)throw new Error("It is needed a OCL molecule instance to assign");const{spectra:f}=await predict(t,{predictOptions:{H:l}}),g=f.proton?.joinedSignals||[];checkForIntegration(n),checkAtomsAndDiaIDs$1(g);const u={};for(const t of n){const{id:n=v4()}=t;u[n]=JSON.parse(JSON.stringify(t))}return buildAssignments$1({restrictionByCS:i,timeout:o,minScore:s,nbAllowedUnAssigned:a,maxSolutions:r,targets:u,joinedSignals:g,useIntegrationRestriction:!0})}function checkAtomsAndDiaIDs(n){for(const t of n){if(!t.atoms)throw new Error("signal has not atoms property");if(!t.diaIDs)throw new Error("signal has not diaIDs property");if(!t.nbAtoms)throw new Error("signal has not nbAtoms property")}}function checkIntegration(n){for(const t of n)void 0===t.integration&&(t.integration=0);return n}async function get13CAssignments(n,t,e={}){const{restrictionByCS:i={},minScore:s=1,maxSolutions:r=10,nbAllowedUnAssigned:a=0,timeout:o=6e3,predictionOptions:l={}}=e;if(!t)throw new Error("It is needed a OCL molecule instance to assign");const{spectra:f}=await predict(t,{predictOptions:{C:l}}),g=f.carbon?.joinedSignals||[];checkAtomsAndDiaIDs(g);const u=checkIntegration(n),h={};for(const n of u){const{id:t=v4()}=n;h[t]=JSON.parse(JSON.stringify(n))}return buildAssignments$1({restrictionByCS:i,timeout:o,minScore:s,nbAllowedUnAssigned:a,maxSolutions:r,targets:h,joinedSignals:g,useIntegrationRestriction:!1})}function floydWarshall(n){if(Matrix.isMatrix(n)&&n.columns!==n.rows)throw new TypeError("The adjacency matrix should be squared");const t=n.columns;let e=new Matrix(t,t);e.apply(((t,i)=>{if(t===i)e.set(t,i,0);else{let s=n.get(t,i);s||Object.is(s,-0)?e.set(t,i,s):e.set(t,i,Number.POSITIVE_INFINITY)}}));for(let n=0;n<t;++n)for(let i=0;i<t;++i)for(let s=0;s<t;++s){let t=e.get(i,n)+e.get(n,s);e.get(i,s)>t&&e.set(i,s,t)}return e.apply(((n,t)=>{e.get(n,t)===Number.POSITIVE_INFINITY&&e.set(n,t,-1)})),e}function getConnectivityMatrix(n,t={}){const e=n.getOCL();n.ensureHelperArrays(e.Molecule.cHelperNeighbours);const i=n.getAllAtoms();let s=new Array(i).fill();if(s=s.map((()=>new Array(i).fill(0))),!t.pathLength)if(t.atomicNo)for(let t=0;t<i;t++)s[t][t]=n.getAtomicNo(t);else if(t.negativeAtomicNo)for(let t=0;t<i;t++)s[t][t]=-n.getAtomicNo(t);else if(t.mass)for(let t=0;t<i;t++)s[t][t]=e.Molecule.cRoundedMass[n.getAtomicNo(t)];else for(let n=0;n<i;n++)s[n][n]=1;if(t.sdt)for(let t=0;t<i;t++){const e=n.getAllConnAtoms(t);for(let i=0;i<e;i++)s[t][n.getConnAtom(t,i)]=n.getConnBondOrder(t,i)}else if(t.sdta)for(let t=0;t<i;t++){const e=n.getAllConnAtoms(t);for(let i=0;i<e;i++){const e=n.getConnBond(t,i);n.isAromaticBond(e)?s[t][n.getConnAtom(t,i)]=4:s[t][n.getConnAtom(t,i)]=n.getConnBondOrder(t,i)}}else for(let t=0;t<i;t++){const e=n.getAllConnAtoms(t);for(let i=0;i<e;i++)s[t][n.getConnAtom(t,i)]=1}return t.pathLength&&(s=floydWarshall(new Matrix(s)).to2DArray()),s}function makeRacemic(n){const{Molecule:t}=n.getOCL();n.ensureHelperArrays(t.cHelperCIP);for(let e=0;e<n.getAllAtoms();e++)n.getAtomParity(e)!==t.cAtomParityNone&&n.setAtomESR(e,t.cESRTypeAnd,0);n.ensureHelperArrays(t.cHelperCIP)}let xAtomicNumber=0;function getXAtomicNumber(n){if(!xAtomicNumber){const t=n.getOCL();xAtomicNumber=t.Molecule.getAtomicNoFromLabel("X",t.Molecule.cPseudoAtomX)}return xAtomicNumber}function tagAtom(n,t){const e=`${n.getAtomLabel(t)}*`;return n.setAtomCustomLabel(t,e),1===n.getAtomicNo(t)?n.setAtomicNo(t,getXAtomicNumber(n)):n.setAtomMass(t,n.getAtomMass(t)+5),e}function getCanonizedDiaIDs(n){const t=n.heterotopicSymmetryRanks,e=n.moleculeWithH,i=n.finalRanks,s=new Array(e.getAllAtoms());e.ensureHelperArrays(n.Molecule.cHelperSymmetryStereoHeterotopicity);const r={};for(let e=0;e<n.moleculeWithH.getAllAtoms();e++){const a=t[e];if(a&&r[a]){s[i[e]]=r[a].diaID;continue}const o=n.moleculeWithH.getCompactCopy();tagAtom(o,e),makeRacemic(o);const l=o.getCanonizedIDCode(n.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS);s[i[e]]=l}return s}function isCsp3(n,t){return 6===n.getAtomicNo(t)&&(0===n.getAtomCharge(t)&&n.getImplicitHydrogens(t)+n.getConnAtoms(t)===4)}const FULL_HOSE_CODE=1,HOSE_CODE_CUT_C_SP3_SP3=2;function getHoseCodesForAtomsInternal(n,t={}){const e=n.getOCL(),{allowedCustomLabels:i,minSphereSize:s=0,maxSphereSize:r=4,kind:a=FULL_HOSE_CODE}=t;n.ensureHelperArrays(e.Molecule.cHelperNeighbours);const o=[];for(let t=0;t<n.getAllAtoms();t++)(i?.includes(n.getAtomCustomLabel(t))||n.getAtomCustomLabel(t))&&o.push(t);const l=new e.Molecule(0,0),f=[];let g=0,u=0;const h=new Array(n.getAllAtoms()),d=new Array(n.getAllAtoms());for(let t=0;t<=r;t++){if(0===u)for(const n of o)d[u]=n,h[n]=!0,u++;else{let t=u;for(let e=g;e<u;e++){const i=d[e];for(let e=0;e<n.getAllConnAtoms(i);e++){const s=n.getConnAtom(i,e);if(!h[s])switch(a){case FULL_HOSE_CODE:h[s]=!0,d[t++]=s;break;case HOSE_CODE_CUT_C_SP3_SP3:isCsp3(n,i)&&isCsp3(n,s)||(h[s]=!0,d[t++]=s);break;default:throw new Error("getHoseCoesForAtom unknown kind")}}}g=u,u=t}n.copyMoleculeByAtoms(l,h,!0,null),t>=s&&(makeRacemic(l),f.push(l.getCanonizedIDCode(e.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS)))}return f}function getCanonizedHoseCodes(n,t={}){const e=n.heterotopicSymmetryRanks,i=n.moleculeWithH,s=n.finalRanks,r=new Array(i.getAllAtoms());i.ensureHelperArrays(n.Molecule.cHelperSymmetryStereoHeterotopicity);const a={};for(let i=0;i<n.moleculeWithH.getAllAtoms();i++){const o=e[i];if(o&&a[o]){r[s[i]]=a[o].diaID;continue}const l=n.moleculeWithH.getCompactCopy();tagAtom(l,i);const f=getHoseCodesForAtomsInternal(l,t);r[s[i]]=f}return r}function getDiaIDsAndInfo(n,t){const e=[],i=n.moleculeWithH,s={};for(const n of t)s[n]||(s[n]=0),s[n]++;for(let r=0;r<t.length;r++){const a=t[n.finalRanks[r]],o={idCode:a,attachedHydrogensIDCodes:[],nbAttachedHydrogens:0,atomLabel:i.getAtomLabel(r),nbEquivalentAtoms:s[a],heavyAtom:void 0,atomMapNo:i.getAtomMapNo(r)};if(1===i.getAtomicNo(r)){const e=i.getConnAtom(r,0);o.heavyAtom=t[n.finalRanks[e]]}for(let e=0;e<i.getAllConnAtoms(r);e++){const s=i.getConnAtom(r,e);if(1===i.getAtomicNo(s)){o.nbAttachedHydrogens++;const e=t[n.finalRanks[s]];o.attachedHydrogensIDCodes.includes(e)||o.attachedHydrogensIDCodes.push(e)}}e.push(o)}return e}function getHeterotopicSymmetryRanks(n){n.ensureHelperArrays(n.getOCL().Molecule.cHelperSymmetryStereoHeterotopicity);const t=[];for(let e=0;e<n.getAllAtoms();e++)t.push(n.getSymmetryRank(e));return t}function getFinalRanks(n){return n.ensureHelperArrays(n.getOCL().Molecule.cHelperSymmetryStereoHeterotopicity),n.getFinalRanks(0).map((n=>n-1))}function getChiralOrHeterotopicCarbons(n){const{Molecule:t}=n.getOCL(),e=getXAtomicNumber(n),i=n.getCompactCopy();i.addImplicitHydrogens();for(let n=0;n<i.getAllAtoms();n++)1===i.getAtomicNo(n)&&i.setAtomicNo(n,e);addPossibleChiralBonds(i),i.ensureHelperArrays(t.cHelperSymmetryStereoHeterotopicity);const s=[];for(let t=0;t<n.getAllAtoms();t++){if(i.getAtomicNo(t)===e)continue;if(n.getAtomicNo(t)!==i.getAtomicNo(t))throw new Error("getChiralOrHeterotopicCarbons: mismatching atomic numbers");if(6!==i.getAtomicNo(t))continue;4===getNeighbourSymmetries(i,t).length&&s.push(t)}return s}function addPossibleChiralBonds(n){const{Molecule:t}=n.getOCL();n.ensureHelperArrays(t.cHelperSymmetryStereoHeterotopicity);for(let e=0;e<n.getAtoms();e++){if(6!==n.getAtomicNo(e))continue;if(n.getStereoBond(e)>=0)continue;if(getNeighbourSymmetries(n,e).length<=2)continue;const i=n.getAtomPreferredStereoBond(e);if(-1!==i){if(n.setBondType(i,t.cBondTypeUp),n.getBondAtom(1,i)===e){const t=n.getBondAtom(0,i);n.setBondAtom(0,i,e),n.setBondAtom(1,i,t)}n.setAtomESR(e,t.cESRTypeAnd,0)}}}function getNeighbourSymmetries(n,t){const e=[];for(let i=0;i<n.getAllConnAtoms(t);i++){const s=n.getConnAtom(t,i),r=n.getSymmetryRank(s);e.includes(r)||e.push(n.getSymmetryRank(s))}return e}function ensureHeterotopicChiralBonds(n,t={}){const{Molecule:e}=n.getOCL(),{esrType:i=e.cESRTypeAnd,atLeastThreeAtoms:s=!0}=t;n.ensureHelperArrays(e.cHelperBitNeighbours);const r=getChiralOrHeterotopicCarbons(n);for(const t of r)if(!(s&&n.getAllConnAtoms(t)<3)&&-1===n.getStereoBond(t)){const s=n.getAtomPreferredStereoBond(t);if(-1!==s){if(n.setBondType(s,e.cBondTypeUp),n.getBondAtom(1,s)===t){const e=n.getBondAtom(0,s);n.setBondAtom(0,s,t),n.setBondAtom(1,s,e)}n.setAtomESR(t,i,0)}}}const MAX_NB_ATOMS=250;function getMoleculeWithH(n){const t=n.getCompactCopy();if(t.addImplicitHydrogens(),t.getAllAtoms()>MAX_NB_ATOMS)throw new Error(`Too many atoms to add hydrogens: ${t.getAllAtoms()} > ${MAX_NB_ATOMS}`);return ensureHeterotopicChiralBonds(t),t}function getXMolecule(n){const t=getXAtomicNumber(n),e=n.getCompactCopy();for(let n=0;n<e.getAllAtoms();n++)1===e.getAtomicNo(n)&&e.setAtomicNo(n,t);return e}class TopicMolecule{constructor(n){this.originalMolecule=n,this.idCode=n.getIDCode(),this.molecule=this.originalMolecule.getCompactCopy(),this.molecule.ensureHelperArrays(n.getOCL().Molecule.cHelperNeighbours),this.Molecule=this.molecule.getOCL().Molecule,this.molecule.ensureHelperArrays(this.Molecule.cHelperNeighbours),this.cache={}}ensureMapNo(){const n={};for(let t=0;t<this.molecule.getAllAtoms();t++){const e=this.molecule.getAtomMapNo(t);if(e){if(n[e])throw new Error("The molecule contains several atoms with the same mapNo");n[e]=!0}}let t=1;for(let e=0;e<this.molecule.getAllAtoms();e++){if(!this.molecule.getAtomMapNo(e)){for(;n[t];)t++;n[t]=!0,this.molecule.setAtomMapNo(e,t,!1)}}}toMolfile(n={}){const{version:t=2}=n;return 2===t?this.molecule.toMolfile():this.molecule.toMolfileV3()}getMolecule(){return this.molecule}fromMolecule(n){if(n.getIDCode()!==this.idCode)return new TopicMolecule(n);const t=new TopicMolecule(n);return t.cache={canonizedDiaIDs:this.cache.canonizedDiaIDs,canonizedHoseCodes:this.cache.canonizedHoseCodes},t}get moleculeWithH(){return this.cache.moleculeWithH||(this.cache.moleculeWithH=getMoleculeWithH(this.molecule)),this.cache.moleculeWithH}get xMolecule(){return this.cache.xMolecule||(this.cache.xMolecule=getXMolecule(this.moleculeWithH)),this.cache.xMolecule}get diaIDs(){if(this.cache.diaIDs)return this.cache.diaIDs;const n=[];for(let t=0;t<this.moleculeWithH.getAllAtoms();t++)n.push(this.canonizedDiaIDs[this.finalRanks[t]]);return this.cache.diaIDs=n,n}getDiaIDsObject(){return groupDiastereotopicAtomIDsAsObject(this.diaIDs,this.molecule,this.moleculeWithH)}get hoseCodes(){if(this.cache.hoseCodes)return this.cache.hoseCodes;const n=[];for(let t=0;t<this.moleculeWithH.getAllAtoms();t++)n.push(this.canonizedHoseCodes[this.finalRanks[t]]);return this.cache.hoseCodes=n,n}get canonizedDiaIDs(){return this.cache.canonizedDiaIDs||(this.cache.canonizedDiaIDs=getCanonizedDiaIDs(this)),this.cache.canonizedDiaIDs}get canonizedHoseCodes(){return this.cache.canonizedHoseCodes||(this.cache.canonizedHoseCodes=getCanonizedHoseCodes(this)),this.cache.canonizedHoseCodes}get distanceMatrix(){return getConnectivityMatrix(this.moleculeWithH,{pathLength:!0})}get diaIDsAndInfo(){return this.cache.diaIDsAndInfo||(this.cache.diaIDsAndInfo=getDiaIDsAndInfo(this,this.canonizedDiaIDs)),this.cache.diaIDsAndInfo}get heterotopicSymmetryRanks(){return this.cache.heterotopicSymmetryRanks?this.cache.heterotopicSymmetryRanks:(this.cache.heterotopicSymmetryRanks=getHeterotopicSymmetryRanks(this.xMolecule),[...this.cache.heterotopicSymmetryRanks])}get finalRanks(){return this.cache.finalRanks||(this.cache.finalRanks=getFinalRanks(this.xMolecule)),this.cache.finalRanks}toMolfileWithH(n={}){const{version:t=2}=n;return 2===t?this.moleculeWithH.toMolfile():this.moleculeWithH.toMolfileV3()}getGroupedDiastereotopicAtomIDs(n={}){return groupDiastereotopicAtomIDs(this.diaIDs,this.moleculeWithH,n)}getDiaIDsMapping(n){const t=new TopicMolecule(n),e=this.diaIDsAndInfo.filter((n=>n.atomMapNo)),i=t.diaIDsAndInfo.filter((n=>n.atomMapNo)),s={};for(const n of i){const t=e.find((t=>t.atomMapNo===n.atomMapNo)),i=n.idCode,r=t.idCode;r in s?s[r]!==i&&(s[r]=void 0):s[r]=i}for(const n of i){const t=e.find((t=>t.atomMapNo===n.atomMapNo));for(let e=0;e<t.attachedHydrogensIDCodes.length;e++){const i=t.attachedHydrogensIDCodes[e];if(s[i])continue;const r=n.attachedHydrogensIDCodes[e];i&&r&&(i in s?s[i]!==r&&(s[i]=void 0):s[i]=r)}}return s}}function groupDiastereotopicAtomIDs(n,t,e={}){const i=groupDiastereotopicAtomIDsAsObject(n,t,t,e);return Object.keys(i).map((n=>i[n]))}function groupDiastereotopicAtomIDsAsObject(n,t,e,i={}){const{atomLabel:s}=i,r={};for(let i=0;i<n.length;i++)if(!s||e.getAtomLabel(i)===s){const s=n[i];if(r[s]||(r[s]={counter:0,atoms:[],oclID:s,atomLabel:e.getAtomLabel(i),heavyAtoms:[],attachedHydrogens:[],existingAtoms:[]}),1===e.getAtomicNo(i)){const n=e.getConnAtom(i,0);r[s].heavyAtoms.includes(n)||r[s].heavyAtoms.push(n),t.getAtomicNo(i)?r[s].existingAtoms.push(i):r[s].existingAtoms.includes(n)||r[s].existingAtoms.push(n)}else{for(let n=0;n<e.getAllConnAtoms(i);n++){const t=e.getConnAtom(i,n);1===e.getAtomicNo(t)&&r[s].attachedHydrogens.push(t)}r[s].existingAtoms.push(i)}r[s].counter++,r[s].atoms.push(i)}for(const n in r)r[n].existingAtoms.sort(((n,t)=>n-t)),r[n].attachedHydrogens.sort(((n,t)=>n-t));return r}function squaredEuclidean(n,t){let e=0;for(let i=0;i<n.length;i++)e+=(n[i]-t[i])*(n[i]-t[i]);return e}function euclidean(n,t){return Math.sqrt(squaredEuclidean(n,t))}function distanceMatrix(n,t){const e=getMatrix(n.length);for(let i=0;i<n.length;i++)for(let s=0;s<=i;s++)e[i][s]=t(n[i],n[s]),e[s][i]=e[i][s];return e}function getMatrix(n){const t=[];for(let e=0;e<n;e++){const e=[];t.push(e);for(let t=0;t<n;t++)e.push(0)}return t}var heap$1={exports:{}};!function(n,t){(function(){var t,e,i,s,r,a,o,l,f,g,u,h,d,c,b;i=Math.floor,g=Math.min,e=function(n,t){return n<t?-1:n>t?1:0},f=function(n,t,s,r,a){var o;if(null==s&&(s=0),null==a&&(a=e),s<0)throw new Error("lo must be non-negative");for(null==r&&(r=n.length);s<r;)a(t,n[o=i((s+r)/2)])<0?r=o:s=o+1;return[].splice.apply(n,[s,s-s].concat(t)),t},a=function(n,t,i){return null==i&&(i=e),n.push(t),c(n,0,n.length-1,i)},r=function(n,t){var i,s;return null==t&&(t=e),i=n.pop(),n.length?(s=n[0],n[0]=i,b(n,0,t)):s=i,s},l=function(n,t,i){var s;return null==i&&(i=e),s=n[0],n[0]=t,b(n,0,i),s},o=function(n,t,i){var s;return null==i&&(i=e),n.length&&i(n[0],t)<0&&(t=(s=[n[0],t])[0],n[0]=s[1],b(n,0,i)),t},s=function(n,t){var s,r,a,o,l,f;for(null==t&&(t=e),l=[],r=0,a=(o=function(){f=[];for(var t=0,e=i(n.length/2);0<=e?t<e:t>e;0<=e?t++:t--)f.push(t);return f}.apply(this).reverse()).length;r<a;r++)s=o[r],l.push(b(n,s,t));return l},d=function(n,t,i){var s;if(null==i&&(i=e),-1!==(s=n.indexOf(t)))return c(n,0,s,i),b(n,s,i)},u=function(n,t,i){var r,a,l,f,g;if(null==i&&(i=e),!(a=n.slice(0,t)).length)return a;for(s(a,i),l=0,f=(g=n.slice(t)).length;l<f;l++)r=g[l],o(a,r,i);return a.sort(i).reverse()},h=function(n,t,i){var a,o,l,u,h,d,c,b,D;if(null==i&&(i=e),10*t<=n.length){if(!(l=n.slice(0,t).sort(i)).length)return l;for(o=l[l.length-1],u=0,d=(c=n.slice(t)).length;u<d;u++)i(a=c[u],o)<0&&(f(l,a,0,null,i),l.pop(),o=l[l.length-1]);return l}for(s(n,i),D=[],h=0,b=g(t,n.length);0<=b?h<b:h>b;0<=b?++h:--h)D.push(r(n,i));return D},c=function(n,t,i,s){var r,a,o;for(null==s&&(s=e),r=n[i];i>t&&s(r,a=n[o=i-1>>1])<0;)n[i]=a,i=o;return n[i]=r},b=function(n,t,i){var s,r,a,o,l;for(null==i&&(i=e),r=n.length,l=t,a=n[t],s=2*t+1;s<r;)(o=s+1)<r&&!(i(n[s],n[o])<0)&&(s=o),n[t]=n[s],s=2*(t=s)+1;return n[t]=a,c(n,l,t,i)},t=function(){function n(n){this.cmp=null!=n?n:e,this.nodes=[]}return n.push=a,n.pop=r,n.replace=l,n.pushpop=o,n.heapify=s,n.updateItem=d,n.nlargest=u,n.nsmallest=h,n.prototype.push=function(n){return a(this.nodes,n,this.cmp)},n.prototype.pop=function(){return r(this.nodes,this.cmp)},n.prototype.peek=function(){return this.nodes[0]},n.prototype.contains=function(n){return-1!==this.nodes.indexOf(n)},n.prototype.replace=function(n){return l(this.nodes,n,this.cmp)},n.prototype.pushpop=function(n){return o(this.nodes,n,this.cmp)},n.prototype.heapify=function(){return s(this.nodes,this.cmp)},n.prototype.updateItem=function(n){return d(this.nodes,n,this.cmp)},n.prototype.clear=function(){return this.nodes=[]},n.prototype.empty=function(){return 0===this.nodes.length},n.prototype.size=function(){return this.nodes.length},n.prototype.clone=function(){var t;return(t=new n).nodes=this.nodes.slice(0),t},n.prototype.toArray=function(){return this.nodes.slice(0)},n.prototype.insert=n.prototype.push,n.prototype.top=n.prototype.peek,n.prototype.front=n.prototype.peek,n.prototype.has=n.prototype.contains,n.prototype.copy=n.prototype.clone,n}(),n.exports=t}).call(commonjsGlobal)}(heap$1);var heap=heap$1.exports,Heap=heap;class Cluster{constructor(){this.children=[],this.height=0,this.size=1,this.index=-1,this.isLeaf=!1}cut(n){if("number"!=typeof n)throw new TypeError("threshold must be a number");if(n<0)throw new RangeError("threshold must be a positive number");let t=[this];const e=[];for(;t.length>0;){const i=t.shift();n>=i.height?e.push(i):t=t.concat(i.children)}return e}group(n){if(!Number.isInteger(n)||n<1)throw new RangeError("groups must be a positive integer");const t=new Heap(((n,t)=>t.height-n.height));for(t.push(this);t.size()<n;){const n=t.pop();if(0===n.children.length)break;n.children.forEach((n=>t.push(n)))}const e=new Cluster;return e.children=t.toArray(),e.height=this.height,e}traverse(n){!function n(t,e){if(e(t),t.children)for(const i of t.children)n(i,e)}(this,n)}indices(){const n=[];return this.traverse((t=>{t.isLeaf&&n.push(t.index)})),n}}function singleLink(n,t){return Math.min(n,t)}function completeLink(n,t){return Math.max(n,t)}function averageLink(n,t,e,i,s){return i/(i+s)*n+s/(i+s)*t}function weightedAverageLink(n,t){return(n+t)/2}function centroidLink(n,t,e,i,s){return i/(i+s)*n+s/(i+s)*t+-i*s/(i+s)**2*e}function medianLink(n,t,e){return n/2+t/2-e/4}function wardLink(n,t,e,i,s,r){return(i+r)/(i+s+r)*n+(s+r)/(i+s+r)*t+-r/(i+s+r)*e}function wardLink2(n,t,e,i,s,r){const a=(i+r)/(i+s+r),o=(s+r)/(i+s+r),l=-r/(i+s+r);return Math.sqrt(a*n*n+o*t*t+l*e*e)}function agnes(n,t={}){const{distanceFunction:e=euclidean,method:i="complete",isDistanceMatrix:s=!1}=t;let r;s||(n=distanceMatrix(n,e));let a=new Matrix(n);const o=a.rows;if("string"==typeof i)switch(i.toLowerCase()){case"single":r=singleLink;break;case"complete":r=completeLink;break;case"average":case"upgma":r=averageLink;break;case"wpgma":r=weightedAverageLink;break;case"centroid":case"upgmc":r=centroidLink;break;case"median":case"wpgmc":r=medianLink;break;case"ward":r=wardLink;break;case"ward2":r=wardLink2;break;default:throw new RangeError(`unknown clustering method: ${i}`)}else if("function"!=typeof i)throw new TypeError("method must be a string or function");let l=[];for(let n=0;n<o;n++){const t=new Cluster;t.isLeaf=!0,t.index=n,l.push(t)}for(let n=0;n<o-1;n++){const[n,t,e]=getSmallestDistance(a),i=l[n],s=l[t],o=new Cluster;o.size=i.size+s.size,o.children.push(i,s),o.height=e;const f=[o],g=new Matrix(a.rows-1,a.rows-1),u=e=>getPreviousIndex(e,Math.min(n,t),Math.max(n,t));for(let o=1;o<g.rows;o++){const h=u(o),d=l[h];f.push(d);for(let l=0;l<o;l++)if(0===l){const f=r(a.get(n,h),a.get(h,t),e,i.size,s.size,d.size);g.set(o,l,f),g.set(l,o,f)}else{const n=a.get(h,u(l));g.set(o,l,n),g.set(l,o,n)}}l=f,a=g}return l[0]}function getSmallestDistance(n){let t=1/0,e=0,i=0;for(let s=1;s<n.rows;s++)for(let r=0;r<s;r++)n.get(s,r)<t&&(t=n.get(s,r),e=s,i=r);return[e,i,t]}function getPreviousIndex(n,t,e){return(n-=1)>=t&&n++,n>=e&&n++,n}var full={},openchemlibFull={};!function(n){!function(t){var e,i;"undefined"!=typeof self?(e=!0,i=self):void 0!==commonjsGlobal?(e=!1,i=commonjsGlobal):(e=!1,i=t);var s,r=i.document||{};r.compatMode||(r.compatMode="CSS1Compat"),e?s=i:((s={}).setTimeout=i.setTimeout?i.setTimeout.bind(i):o,s.clearTimeout=i.clearTimeout?i.clearTimeout.bind(i):o,s.setInterval=i.setInterval?i.setInterval.bind(i):o,s.clearInterval=i.clearInterval?i.clearInterval.bind(i):o,s.Error=i.Error,s.Math=i.Math,s.RegExp=i.RegExp,s.TypeError=i.TypeError),s.document||(s.document=r);var a=function(n){var t=n.document,e={},i={userAgent:"webkit"};function s(){}var a=s;a.__moduleStartupDone=s;var o,l,f,g,u,h,d,c="object",b="anonymous",D="fnStack",H="\n",j={4:1,9:1,5:1,7:1},m="Unknown",A="boolean",C="number",T="string",p="function",I=2147483647,P='For input string: "',M="null",N="__noinit__",w={4:1,5:1,7:1},L={4:1,18:1,28:1},U=" (copy)",y={4:1,9:1,15:1,5:1,11:1,7:1,14:1},J=65536,B=65535,R=1e4,k=", length: ",E="Index: ",x=", Size: ",F="fromIndex: ",Q=", toIndex: ",X={13:1,4:1,5:1},S={4:1},z={8:1,4:1,5:1},G=16777215,q=65280,Y=.30000001192092896,v=545460846592,Z=4294967296,V=8589934592,O=17179869184,K=34359738368,W=68719476736,_=137438953472,$=274877906944,nn={12:1,4:1,5:1},tn=536870912,en=2.617993878,sn=3.665191429,rn=6.283185307179586,an=3.141592653589793,on=1.5707963267948966,ln=16384,fn=4096,gn={l:0,m:0,h:1},un={l:0,m:0,h:2},hn={l:0,m:0,h:4},dn=1920,cn=1024,bn=234881024,Dn=167772160,Hn=100663296,jn=201326592,mn=114688,An=4063232,Cn=3801088,Tn=3538944,pn=3014656,In=3145728,Pn=2097152,Mn=393216,Nn=917504,wn=1966080,Ln=0xf8000000000,Un=0xf0000000000,yn=0xe8000000000,Jn=0xd8000000000,Bn=0xb8000000000,Rn=8796093022208,kn=549755813888,En=1649267441664,xn=3848290697216,Fn=8246337208320,Qn=29360128,Xn=268435456,Sn=8192,zn=2048,Gn=-1.5707963267948966,qn=130560,Yn=6291456,vn=-2.0943951023931953,Zn=1.0471975511965976,Vn=.5235987755982988,On=786432,Kn=524288,Wn=262144,_n=-16777216,$n=-65536,nt=-32768,tt='<DrawingObject type="',et="></DrawingObject>",it={4:1,5:1,16:1},st={4:1,5:1},rt="unsupported atomicNo:",at=2.8415926535897933,ot={41:1,4:1,9:1,5:1,7:1},lt={4:1,5:1,11:1,7:1},ft={10:1,4:1,5:1},gt=131072,ut=196608,ht={l:6,m:0,h:4},dt=1048576,ct=3221225472,bt={l:0,m:0,h:3},Dt=8388608,Ht="text",jt={30:1,60:1,62:1},mt={30:1,60:1,104:1,62:1,121:1},At={4:1,5:1,30:1,60:1,104:1,21:1,62:1,121:1,193:1},Ct="??",Tt=2013265920,pt=32505856,It=31744,Pt=17976931348623157e292,Mt={152:1,4:1,9:1,5:1,11:1,7:1},Nt=33554432,wt=67108864,Lt=32768,Ut=-33554433,yt=-33292289,Jt=-3.141592653589793,Bt=4194303,Rt=3072,kt={59:1,4:1,5:1},Et=.7853981633974483,xt=3.061592653589793,Ft=1073741824,Qt=541165879296,Xt={17:1,4:1,5:1,7:1},St=281.17,zt=289.19,Gt=294.21,qt="0.0000",Yt="M  END\n",vt="ATOMS",Zt=-2147483648,Vt="M  END",Ot="$$$$",Kt="M  V30 ",Wt="M  V30 COUNTS ",_t=")\n",$t="M  V30 MDLV30/STEREL",ne="M  V30 MDLV30/STERAC",te=34028234663852886e22,ee={l:2,m:0,h:4},ie=4194304,se={l:4179966,m:4063288,h:7},re={l:4194302,m:4193343,h:7},ae={90:1,85:1,98:1,4:1,9:1,5:1,7:1},oe='" ',le='stroke="',fe='stroke-width="',ge='" />',ue='class="event" ',he='opacity="0" />',de=16711680,ce="Assignment of aromatic double bonds failed",be=1099511627776,De=2199023255552,He=4398046511104,je={115:1,4:1},me="Members of ESR groups must only be stereo centers with known configuration.",Ae="Over- or under-specified stereo feature or more than one racemic type bond",Ce="Ambiguous configuration at stereo center because of 2 parallel bonds",Te={97:1,113:1,24:1,4:1},pe=1e5,Ie="style",Pe=3.1415927410125732,Me=1.5707963705062866,Ne=.029999999329447746,we=6.2831854820251465,Le=1.9106119871139526,Ue=2.2639999389648438,ye=2.16759991645813,Je=2.0662999153137207,Be=2.3561999797821045,Re=2.2844998836517334,ke=1.9106120066311025,Ee=2.094395160675049,xe=.6000000238418579,Fe=1.7999999523162842,Qe=.05000000074505806,Xe={4:1,9:1,5:1,7:1,48:1},Se=.2617993950843811,ze=2.0943951023931953,Ge=1.2000000476837158,qe=1.4299999475479126,Ye=1.659999966621399,ve=1.4600000381469727,Ze=1.8200000524520874,Ve=2.4600000381469727,Oe=2.4200000762939453,Ke=2.450000047683716,We=2.440000057220459,_e=2.4000000953674316,$e=2.319999933242798,ni=2.2899999618530273,ti=1.8600000143051147,ei=2.5299999713897705,ii=2.490000009536743,si=2.4700000286102295,ri=2.880000114440918,ai=2.9200000762939453,oi=2.869999885559082,li=2.8299999237060547,fi=2.7899999618530273,gi=2.809999942779541,ui=2.799999952316284,hi=3.049999952316284,di=.3199999928474426,ci=1.3300000429153442,bi=1.3899999856948853,Di=1.159999966621399,Hi=1.1100000143051147,ji=1.0700000524520874,mi=1.9600000381469727,Ai=1.7100000381469727,Ci=1.3600000143051147,Ti=1.340000033378601,pi=1.2200000286102295,Ii=1.2400000095367432,Pi=1.2100000381469727,Mi=1.850000023841858,Ni=1.6299999952316284,wi=1.4700000286102295,Li=1.2799999713897705,Ui=1.440000057220459,yi=1.399999976158142,Ji=1.7599999904632568,Bi=1.7300000190734863,Ri=1.7200000286102295,ki=1.6799999475479126,Ei=1.690000057220459,xi=1.6699999570846558,Fi=1.649999976158142,Qi=1.7000000476837158,Xi=1.6200000047683716,Si=1.3700000047683716,zi=1.2899999618530273,Gi=1.4500000476837158,qi=1.5700000524520874,Yi=-.5235987755982988,vi=-1.0471975511965976,Zi=-.7853981633974483,Vi=.017453292519943295,Oi=.17453292519943295,Ki=1e-4,Wi={168:1},_i=57.29577951308232,$i=.021922173386725217,ns=1e-8,ts=2.5120960256267386,es=1e-5,is="MMFF94s+",ss="nonbonded cutoff",rs="dielectric constant",as="dielectric model",os="angle bend",ls="bond stretch",fs="electrostatic",gs="out of plane",us="stretch bend",hs="torsion angle",ds="van der waals",cs={4:1,9:1,5:1,11:1,7:1},bs=.07000000000000006,Ds=.1200000000000001,Hs=-7.840000000000001,js="OCL_RXN_V1.0:",ms="'$MOL' tag not found",As="'M  END' not found",Cs="\nActelion Java MolfileCreator 2.0\n\n  0  0  0  0  0  0              0 V3000\n",Ts="M  V30 END CTAB",ps=2475109711874,Is=2475109711875,Ps=2887426572290,Ms=2887426572291,Ns=2887627898882,ws=2887627898883,Ls=2887627997186,Us=3437182386178,ys=3437182386179,Js=3437383712770,Bs=3437383811074,Rs=3437652148226,ks=3437652377602,Es=4674132967426,xs=4674334294018,Fs=4674334392322,Qs=4674602729474,Xs=4674602958850,Ss=5086449827842,zs=5086449827848,Gs=5086651154434,qs=5086651252738,Ys=5086651252743,vs=5086919589890,Zs=5086919688194,Vs=5636406968322,Os=5636407066626,Ks=5636675502082,Ws={l:589826,m:590112,h:4},_s={l:589827,m:590112,h:4},$s={l:589826,m:590160,h:4},nr={l:589827,m:590160,h:4},tr={l:688130,m:590160,h:4},er={l:589826,m:590224,h:4},ir={l:589827,m:590224,h:4},sr={l:819203,m:590224,h:4},rr={l:589826,m:590368,h:4},ar={l:688130,m:590368,h:4},or={l:819202,m:590368,h:4},lr={l:819208,m:590368,h:4},fr={l:589826,m:590416,h:4},gr={l:589832,m:590416,h:4},ur={l:688130,m:590416,h:4},hr={l:819202,m:590416,h:4},dr={l:589826,m:598304,h:4},cr={l:589827,m:598304,h:4},br={l:688130,m:598304,h:4},Dr={l:1114114,m:598304,h:4},Hr={l:1212418,m:598304,h:4},jr={l:589826,m:598308,h:4},mr={l:589826,m:688416,h:4},Ar={l:589826,m:688464,h:4},Cr={l:589826,m:688720,h:4},Tr={l:688130,m:688720,h:4},pr={l:589826,m:590112,h:288},Ir={l:589826,m:590112,h:336},Pr={l:589826,m:688416,h:336},Mr={l:589826,m:688464,h:336},Nr={l:688130,m:688464,h:336},wr={l:589826,m:590112,h:400},Lr={l:589826,m:688416,h:400},Ur={l:589826,m:688464,h:400},yr={l:688130,m:688464,h:400},Jr={l:589826,m:819488,h:400},Br={l:589826,m:819536,h:400},Rr={l:589826,m:819600,h:400},kr={l:688130,m:819600,h:400},Er={l:819202,m:819600,h:400},xr={l:589831,m:688416,h:592},Fr={l:589831,m:688464,h:592},Qr={l:688135,m:688464,h:592},Xr={l:589831,m:819536,h:592},Sr={l:688135,m:819536,h:592},zr={l:688135,m:819600,h:592},Gr={l:589832,m:1212704,h:592},qr={l:589832,m:1212752,h:592},Yr={l:688136,m:1212752,h:592},vr={l:589831,m:688464,h:656},Zr={l:589826,m:590112,h:8480},Vr={l:589826,m:688416,h:8480},Or={l:589826,m:688464,h:8480},Kr={l:688130,m:688464,h:8480},Wr={l:819202,m:819600,h:8480},_r={l:688135,m:1212752,h:8480},$r={l:589832,m:1213008,h:8480},na={l:688136,m:1213008,h:8480},ta={l:589826,m:590112,h:8484},ea={l:589826,m:590160,h:8484},ia={l:688130,m:598304,h:8484},sa=.6262000203132629,ra=-1.3825000524520874,aa=.33169999718666077,oa=-1.4915000200271606,la=.3540000021457672,fa=.38179999589920044,ga=-.6019999980926514,ua=.07999999821186066,ha=-.7379999756813049,da="Atom-types are 64-bit numbers describing atoms and their near surrounding.",ca="Recognized atom types and their contributions are:",ba="Druglikeness predictor not properly initialized.",Da=3.009999990463257,Ha=-.17000000178813934,ja=-.1809999942779541,ma=-.2029999941587448,Aa=2147483648,Ca="MMFF94",Ta="MMFF94s",pa="117\nint,int,int,int,float\n0,2,0,0,0.020\n1,2,1,2,0.030\n1,2,2,2,0.027\n1,2,2,3,0.026\n1,2,2,5,0.013\n1,2,2,37,0.032\n2,2,2,5,0.013\n2,2,3,5,0.012\n2,2,5,5,0.006\n2,2,5,6,0.027\n2,2,5,37,0.017\n2,2,5,40,0.012\n2,2,5,41,0.008\n0,3,0,0,0.130\n1,3,1,7,0.146\n1,3,2,7,0.138\n1,3,3,7,0.134\n1,3,5,7,0.122\n1,3,6,7,0.141\n1,3,7,10,0.129\n1,3,7,37,0.138\n2,3,5,7,0.113\n2,3,5,9,0.081\n2,3,6,7,0.127\n2,3,7,10,0.116\n3,3,5,7,0.113\n3,3,6,7,0.127\n5,3,5,7,0.103\n5,3,5,9,0.074\n5,3,5,54,0.078\n5,3,6,7,0.119\n5,3,7,10,0.102\n5,3,9,40,0.067\n6,3,7,37,0.127\n7,3,10,10,0.113\n7,3,20,20,0.151\n9,3,40,40,0.057\n0,8,0,0,0.000\n0,10,0,0,0.015\n1,10,1,3,0.015\n1,10,3,6,0.015\n1,10,3,28,0.015\n3,10,3,28,0.015\n3,10,28,28,0.015\n0,17,0,0,0.000\n0,26,0,0,0.000\n0,30,0,0,0.010\n5,30,20,30,0.008\n0,37,0,0,0.035\n1,37,37,37,0.040\n2,37,37,37,0.031\n3,37,37,37,0.027\n5,37,37,37,0.015\n5,37,37,38,0.046\n5,37,37,63,0.008\n5,37,37,64,0.012\n5,37,37,69,0.016\n5,37,38,38,0.084\n6,37,37,37,0.048\n15,37,37,37,0.025\n37,37,37,40,0.046\n0,39,0,0,0.020\n1,39,63,63,0.012\n23,39,63,63,-0.014\n23,39,63,65,0.021\n23,39,65,65,0.062\n0,40,0,0,0.030\n1,40,28,37,0.030\n2,40,28,28,0.030\n3,40,28,28,0.030\n28,40,28,37,0.030\n0,41,0,0,0.180\n1,41,32,32,0.178\n2,41,32,32,0.161\n5,41,32,32,0.158\n0,43,0,0,0.000\n0,45,0,0,0.150\n0,49,0,0,0.000\n50,49,50,50,0.000\n0,54,0,0,0.020\n1,54,3,36,0.016\n3,54,36,36,0.018\n0,55,0,0,0.020\n1,55,36,57,0.020\n36,55,36,57,0.020\n0,56,0,0,0.020\n1,56,36,57,0.020\n36,56,36,57,0.020\n0,57,0,0,0.080\n5,57,55,55,0.038\n56,57,56,56,0.158\n0,58,0,0,0.025\n0,63,0,0,0.050\n5,63,39,64,0.019\n5,63,39,66,0.068\n5,63,44,64,0.014\n5,63,44,66,0.055\n5,63,59,64,0.033\n5,63,59,66,0.085\n37,63,39,64,0.010\n0,64,0,0,0.040\n5,64,63,64,0.006\n5,64,63,66,0.043\n5,64,64,65,0.052\n5,64,65,66,0.094\n37,64,63,64,-0.01\n0,67,0,0,0.070\n0,69,0,0,0.070\n32,69,37,37,0.067\n0,73,0,0,0.000\n0,78,0,0,0.045\n5,78,78,81,0.046\n0,80,0,0,0.080\n5,80,81,81,0.057\n0,81,0,0,0.025\n36,81,78,80,0.016\n0,82,0,0,0.000\n",Ia={196:1,4:1,5:1,7:1},Pa="div",Ma="position:absolute;left:",Na="px;",wa="rgba(",La=4278190080,Ua="px",ya={203:1},Ja={378:1,27:1},Ba={379:1,27:1},Ra="position:absolute;width:",ka="px;height:",Ea={46:1,4:1,5:1,7:1},xa=22.5,Fa=21.176470588235293,Qa={205:1,27:1},Xa={206:1,27:1},Sa={251:1,27:1},za={365:1,27:1},Ga="true",qa="data-idcode",Ya="MutationObserver",va="Parse exception ",Za="error setting idcode data ",Va={249:1,27:1},Oa={102:1,27:1},Ka="data:image/gif;base64,R0lGODlhHABGANUAAISChPLx8ubl5uDf4NLR0s/OzwAA//Hx8tHR0svLzMXFxuvs7OXm5t/g4MvMzAD/APf49+vs6+Xm5dfY18vMy/j49/Ly8enp6ODg38bGxdbTzv8AAPj39+zr68bFxcC/v/////39/fr6+vf39/T09PHx8e7u7uzs7Obm5uPj4+Dg4N3d3dra2tfX19TU1NHR0czMzMvLy8nJycbGxsPDw8DAwL29vbq6uqqqqiEhIQAAAAAAAAAAAAAAAAAAAAAAACwAAAAAHABGAAAG/0CQcEgsGo0AkGbJbDqfzqQGQK1ar1iqUgrIeb/gsFi33eZAp7R6zV6Tp+bTzfahzWSUAsLVYq02KQIXEThvXDknNjU0GTIxBS98fhuUFwsmhWVTiIsKjpCSf5SUJhaZcJsnNJ4OeqEqo6Mkp4cnHp+RE36wsaO0cTIwrn0rDb2jIr+pCQUEoQPHlCIhyl0nw34DKccc0yDViLl+GNu9I97fhnGv5bHdIUPgJ8Qq5To6GyTn8PHqqbspJFC6pw9dP03Wit27t2GhDngO0yFEVI9BQx0H7omIeBCVtRQoHJK4F+IeiIVC5Am4Z+IeBJMmhZiUd8Ghjo0oOco7YeIACf8IBo9I9IgIh9GjSJMi9ddFjFOnTM+0mdomqhw6dvBgW2Eg0CB5ihjhCmWgrCVMVjuNJVa2bSl5q2S02kOvbdtZVm89ErdChV278oJtbfC3bTKrzJwRG1C47DR5W7UVfje0Fl9yhfeltMpuskF59FL8Lchv88QTACXYJV1EXrFAq1GenGm1YlufJGGSqRwH5IWyAfTpnm2a6AlBHUyU+ImTeEyaPJdX8Cb7uVWePoGWFipPqXelUZ+K/xIVDdXzJ6zOqXMnD10/D7wSshq20d5QD/Kflaf2PrH8AL5lVVxzvQIggHidphcouvR14IGBCfNeMQ8CeNhpiT1TYX6PWRVvWQoVUibPZSA+qBlvqbAT4mdWhfbgSLKhaE1qB8JY0m4yIvKaADUCFWOOJ1QEoE/n/Aikb/kFVyQZNgGJnHLM3SiTdaddEB0J0/FjE22nYRelUB3V8t2YRjG15Zlo+gPmmkWgAsWbcMKRxZx0VhEEADs=",Wa="data:image/gif;base64,R0lGODlhHABGANUAAISChH59fnt6e3h3eHRzdMTDxLi3uJiXmAAAw3d3eLe3uKamp5eXmI+PkIaGh4ODhH1+fsPExLe4uJGSkgDDAM/Qz8DBwHh4d76+vZ6enZiYl4qKidbTzsMAANDPz8fGxqSjo5KRkYqJiYSDg////9LS0svLy76+vru7u7i4uLW1tbKysq+vr6ysrKmpqaOjo6GhoZubm5iYmJWVlZKSko+Pj4yMjImJiYSEhIODg4CAgHh4eG9vb19fXyEhIQAAACwAAAAAHABGAAAG/0CScEgsGo0AEmfJbDqfziQHQK1ar1iqUgrweb/gsPi33YrPaF956qXx3vC4PL7u+t4EQkIQ0AEcNzY1NB0HMRkwPXVePHk7fDojgIKEHR2IL4pTZncEAwIQOjkOIpSWpyALmlyMF5A4k4Mzp6cuq5w8kA+xNLO0p7dsd6GjgbK/pyzBdjyRvL7ILCvLjLvGEzMayC3SKtR3DhuCITMy290p3zzGvQznKyoKKOqU2ZY/Px0u3PAGKCfqGvSSEePej33d/J2woK4XPnwdHv6AJ7GAunIF8S3Ax0IiBgsFPqjTEEOiC3wr8KF4+MGEupI/XuBrgU8FvoUR8LlcdCeDxP8fHR9ikGjCgzoYLxYghCcBxceQJkxUKKGuh9WrWLNi5Zmmq5pNwtzMGSuHJx49kP6wQ2AIkTpHkCStRYAA09tHxEhRoss3lTpXfWCxm8GXry2zup4VLqwu7+DFfJWZdfYYMgJp6qwJwqYBMj9vZsONK+cZnbrBDErDk0dPVufCS1UoDDgwBuzPChmarQ37oYoUDy2axchXKUqV+EKOPERXKc0fNn+cwNfyJSbnQQ3gs6BzJ1hmiFLFfghSp1GzSLEzdQqypVSqZrXK18rVKxqeYsnqN9sIbR+1lFDQViJmwdWHXAFSQIFdBX6SVymDKCihX2YBpoNg9Ugo4WHfMZKO2GAaatiYKM+EKKFkHd5BWYYmUoCZWZrVwJmJn6kjWg3kyECjaWahtuNq85hVjwYhnvTQbGYJhJGGRqb0wz+6pchDbUxy8xB7wkm5pILYXfmUSGaRlAGXCOEDHFHWpbeUStN1p0546v32Ez7nSanmZ019GdVUy/xwx3yAWrXGEYQWChYUiCa6SRaMNlpFEAA7",_a=21.333333333333332,$a={238:1,27:1},no="width",to="height",eo="offsetHeight",io="offsetWidth",so="Null widget handle. If you are creating a composite, ensure that initWidget() has been called.",ro="Style names cannot be empty",ao="aria-hidden",oo={43:1,37:1,40:1,39:1,44:1,35:1,34:1},lo={43:1,37:1,40:1,39:1,44:1,35:1,34:1,30:1},fo="left",go="visibility",uo="hidden",ho="visible",co="popupContent",bo=1281818470,Do={25:1},Ho={167:1,25:1},jo=23.333333333333332,mo=4294967295,Ao="font: 12px sans-serif",Co="Atom Properties",To="cellPadding",po="Cancel",Io="excluded atoms:",Po="allowed atoms:",Mo="200px",No="any ring state",wo={324:1,27:1},Lo="disabled",Uo="px Helvetica",yo="Helvetica",Jo="canvas",Bo="undefined",Ro=.08726646502812703,ko=4278190335,Eo=5e-324,xo={90:1,85:1,4:1,9:1,5:1,7:1},Fo=.003921568859368563,Qo="CENTER",Xo="position",So="absolute",zo="CSS1Compat",Go={38:1,31:1,4:1,19:1,20:1},qo={36:1,31:1,4:1,19:1,20:1},Yo={31:1,86:1,4:1,19:1,20:1},vo={58:1,4:1,19:1,20:1},Zo="load",Vo={146:1,4:1,18:1,28:1},Oo='Too many percent/per mille characters in pattern "',Ko=1048575,Wo=17592186044416,_o=1e9,$o=-17592186044416,nl=16777216,tl="__gwtLastUnhandledEvent",el="__uiObjectID",il="cellSpacing",sl="Column index: ",rl=", Column size: ",al="Row index: ",ol=", Row size: ",ll="overflow",fl={43:1,37:1,40:1,39:1,44:1,182:1,35:1,34:1,30:1},gl={89:1,4:1,19:1,20:1},ul=5.56,hl=11.12,dl=13.34,cl=14.44,bl=.3010299956639812,Dl="BigInteger divide by zero",Hl={l:0,m:0,h:524288},jl={19:1,133:1},ml={149:1},Al={30:1,60:1,62:1,131:1},Cl="delete",Tl=15525485,pl=5.960464477539063e-8,Il={4:1,149:1},Pl={4:1,19:1,20:1,93:1},Ml="Invalid UTF8 sequence",Nl=.20000000298023224,wl=" distance:",Ll="gGP`@dfyjidNcGI[WQCP`<",Ul={65:1},yl={},Jl={},Bl={},Rl={},kl={},El={},xl={},Fl={},Ql={},Xl={},Sl={},zl={},Gl={},ql={},Yl={},vl={},Zl={},Vl={},Ol={},Kl={},Wl={},_l={},$l={},nf={},tf={},ef={},sf={},rf={},af={},of={},lf={},ff={},gf={},uf={},hf={},df={},cf={},bf={},Df={},Hf={},jf={},mf={},Af={},Cf={},Tf={},pf={},If={},Pf={},Mf={},Nf={},wf={},Lf={},Uf={},yf={},Jf={},Bf={},Rf={},kf={};function Ef(){}function xf(n){return Array.isArray(n)&&n.he===Ef?Jl.Mc(n):n.toString()}function Ff(t,e){var i=n;if(""===t)return i;var s,r=t.split(".");(!(r[0]in i)&&i.execScript&&i.execScript("var "+r[0]),e)&&(e.prototype.fe.e=e);for(;r.length&&(s=r.shift());)i=i[s]=i[s]||!r.length&&e||{};return i}function Qf(n,t,e){var i=function(){return n.apply(i,arguments)};return t.apply(i,e),i}function Xf(){}function Sf(n,t){for(var e in t)t[e].configurable=!0;Object.defineProperties(n,t)}function zf(n,t,e){var i=l,s=i[n],r=yl.Kxb(s);s&&!r?o=s:((o=yl.Fxb(t)).ge=e,!t&&(o.he=Ef),i[n]=o);for(var a=3;a<arguments.length;++a)arguments[a].prototype=o;r&&(o.fe=r)}function Gf(){}function qf(n,t){return yl.Vjb(n,t)}function Yf(n,t,e,i,s,r){return yl.Zjb(n,t,e,i,s,0,r)}function vf(n,t,e,i,s,r){var a;return a=yl._jb(s,i),10!=s&&Of(qf(n,r),t,e,s,a),a}function Zf(n){return Array.isArray(n)&&n.he===Ef}function Vf(n,t,e){return yl.bkb(n,t,e)}function Of(n,t,e,i,s){return yl.dkb(s,n),s.ge=t,s.he=Ef,yl.fkb(s,e),yl.ekb(s,i),s}function Kf(n){return String.fromCharCode(n)}function Wf(n){return!Array.isArray(n)&&n.he===Ef}function _f(n,t){return null!=n&&function(n,t){return ig(n)?!!h[t]:n.ge?!!n.ge[t]:ng(n)?!!u[t]:!!$f(n)&&!!g[t]}(n,t)}function $f(n){return typeof n===A}function ng(n){return typeof n===C}function tg(n){return null!=n&&yl.llb(n)&&!(n.he===Ef)}function eg(n,t){return yl.mlb(n,t)}function ig(n){return typeof n===T}function sg(n){return null==n?null:n}function rg(n){return 0|Math.max(Math.min(n,I),-2147483648)}function ag(n){var t;return _f(n,28)?n:((t=yl.Owb(n))||(t=new Bl.b9(n),Rl.$9(t)),t)}function og(n){return n.backingJsObject}function lg(n){var t;return t=Jl._Fb(n),Jl.nGb(n,t),t}function fg(n,t){var e;return e=Jl._Fb(n),Jl.nGb(n,e),e.f=t?8:0,e}function gg(n){var t;return(t=Jl._Fb(n)).k=n,t.f=1,t}yl.Nwb=function(){},yl.Axb=function(){null==f&&(f=[])},yl.yxb=function(){},yl.Lxb=function(n){function t(){}return t.prototype=n||{},new t},yl.Kxb=function(n){return n instanceof Array?n[0]:null},yl.Fxb=function(n){var t=n&&n.prototype;return!t&&(t=l[n]),yl.Lxb(t)},yl.Exb=function(){},n.goog=n.goog||{},n.goog.global=n.goog.global||n,l={},Jl.Bc=function(n,t){return sg(n)===sg(t)},Jl.Cc=function(n){return n.fe},Jl.Dc=function(n){return kl.ATb(n)},Jl.Gc=function(n,t){return ig(n)?Jl.KHb(n,t):ng(n)?Jl.AGb(n,t):$f(n)?Jl.vFb(n,t):Wf(n)?n.ib(t):Zf(n)?Jl.Bc(n,t):Bl.E7(n,t)},Jl.Ic=function(n){return ig(n)?Jl.MHb():ng(n)?Jl.BGb():$f(n)?Jl.wFb():Wf(n)?n.fe:Zf(n)?Jl.Cc(n):Bl.F7(n)},Jl.Kc=function(n){return ig(n)?Jl.NHb(n):ng(n)?Jl.CGb(n):$f(n)?Jl.xFb(n):Wf(n)?n.kb():Zf(n)?Jl.Dc(n):Bl.G7(n)},Jl.Mc=function(n){return Jl.WFb(Jl.Ic(n))+"@"+kl.TTb(kl.STb(Jl.Kc(n))).toString(16)},zf(1,null,{},Gf),o.ib=function(n){return Jl.Bc(this,n)},o.jb=function(){return Jl.Cc(this)},o.kb=function(){return Jl.Dc(this)},o.lb=function(){return Jl.WFb(Jl.Ic(this))+"@"+kl.TTb(kl.STb(Jl.Kc(this))).toString(16)},o.equals=function(n){return this.ib(n)},o.hashCode=function(){return this.kb()},o.toString=function(){return this.lb()},Bl.E7=function(n,t){return Bl.K7(n)?Bl.H7(n,t):sg(n)===sg(t)},Bl.F7=function(n){return n.fe||Array.isArray(n)&&qf(yl.Gqb,1)||yl.Gqb},Bl.G7=function(n){return Bl.L7(n)?Bl.I7(n):kl.ATb(n)},Bl.H7=function(n,t){return n.equals(t)},Bl.I7=function(n){return n.hashCode()},Bl.J7=function(){return[]},Bl.K7=function(n){return!!n&&!!n.equals},Bl.L7=function(n){return!!n&&!!n.hashCode},Bl.M7=function(n){return n.toString?n.toString():"[JavaScriptObject]"},Rl.Z9=function(){var n,t;Rl.Z9=Xf,t=!Rl.gab(),n=new Rl.pab,Rl.Y9=t?new Rl.hab:n},Rl.$9=function(n){Rl.Z9(),Rl.Y9.td(n)},Rl._9=function(n){var t;return Rl.Z9(),t=Rl.Y9.ud(n),Rl.aab(t)},Rl.aab=function(t){var e;for("$9","Sz",e=n.Math.min(t.length,5)-1;e>=0;e--)if(Jl.KHb(t[e].d,"$9")||Jl.KHb(t[e].d,"Sz")){t.length>=e+1&&kl.TTb(t).splice(0,e+1);break}return t},Rl.bab=function(n){var t=/function(?:\s+([\w$]+))?\s*\(/.exec(n);return t&&t[1]||b},Rl.cab=function(n){return Rl.Z9(),n&&n[D]?n[D]:[]},Rl.dab=function(n){return Rl.Z9(),n.name||(n.name=Rl.bab(n.toString()))},Rl.eab=function(n){return Rl.Z9(),parseInt(n)||-1},Rl.fab=function(n){Rl.Z9();var t=n.backingJsObject;if(t&&t.stack){var e=t.stack,i=t+H;return e.substring(0,i.length)==i&&(e=e.substring(i.length)),e.split(H)}return[]},Rl.gab=function(){return Error.stackTraceLimit>0?(n.Error.stackTraceLimit=Error.stackTraceLimit=64,!0):"stack"in new Error},zf(654,1,{}),Rl.hab=function(){},zf(389,654,{},Rl.hab),o.td=function(n){var t={},e=[];n[D]=e;for(var i=arguments.callee.caller;i;){var s=Rl.dab(i);e.push(s);var r,a,o=":"+s,l=t[o];if(l)for(r=0,a=l.length;r<a;r++)if(l[r]===i)return;(l||(t[o]=[])).push(i),i=i.caller}},o.ud=function(n){var t,e,i,s;for(i=Rl.cab(n),e=Bl.m9(i),s=vf(yl.Tub,j,96,e,0,1),t=0;t<e;t++)s[t]=new Jl.zHb(Bl.l9(i,t),null,-1);return s},Rl.kab=function(n,t){var e,i,s,r,a,o,l,f,g;return f="",0==kl.TTb(t).length?n.vd(m,b,-1,-1):(g=Jl.ZHb(t),Jl.KHb(kl.TTb(g).substr(0,3),"at ")&&(kl.OTb(3,kl.TTb(g).length+1),g=kl.TTb(g).substr(3)),g=Rl.lab(g),-1==(a=kl.TTb(g).indexOf("("))?-1==(a=kl.TTb(g).indexOf("@"))?(f=g,g=""):(f=Jl.ZHb((kl.OTb(a+1,kl.TTb(g).length+1),kl.TTb(g).substr(a+1))),g=Jl.ZHb((kl.NTb(0,a,kl.TTb(g).length),kl.TTb(g).substr(0,a)))):(e=kl.TTb(g).indexOf(")",a),kl.NTb(a+1,e,kl.TTb(g).length),f=kl.TTb(g).substr(a+1,e-(a+1)),g=Jl.ZHb((kl.NTb(0,a,kl.TTb(g).length),kl.TTb(g).substr(0,a)))),-1!=(a=Jl.OHb(g,bg(46)))&&(kl.OTb(a+1,kl.TTb(g).length+1),g=kl.TTb(g).substr(a+1)),(0==kl.TTb(g).length||Jl.KHb(g,"Anonymous function"))&&(g=b),o=Jl.RHb(f,bg(58)),s=Jl.SHb(f,bg(58),o-1),l=-1,i=-1,r=m,-1!=o&&-1!=s&&(kl.NTb(0,s,kl.TTb(f).length),r=kl.TTb(f).substr(0,s),l=Rl.eab((kl.NTb(s+1,o,kl.TTb(f).length),kl.TTb(f).substr(s+1,o-(s+1)))),i=Rl.eab((kl.OTb(o+1,kl.TTb(f).length+1),kl.TTb(f).substr(o+1)))),n.vd(r,g,l,i))},Rl.lab=function(n){return n.replace(/\[.*?\]/g,"")},zf(655,654,{}),o.td=function(n){},o.vd=function(n,t,e,i){return new Jl.zHb(t,n+"@"+i,e<0?-1:e)},o.ud=function(n){var t,e,i,s,r,a;if(s=Rl.fab(n),r=vf(yl.Tub,j,96,0,0,1),t=0,0==(i=Bl.m9(s)))return r;for(a=Rl.kab(this,Bl.l9(s,0)),Jl.KHb(a.d,b)||(r[t++]=a),e=1;e<i;e++)r[t++]=Rl.kab(this,Bl.l9(s,e));return r},Rl.pab=function(){},zf(390,655,{},Rl.pab),o.vd=function(n,t,e,i){return new Jl.zHb(t,n,-1)},yl.Tjb=function(n){return n},yl.Vjb=function(n,t){return Jl.fGb(n,t)},yl.Wjb=function(n){return null==n.__elementTypeCategory$?10:n.__elementTypeCategory$},yl.Xjb=function(n){return n.__elementTypeId$},yl.Zjb=function(n,t,e,i,s,r,a){var o,l,f,g,u;if(g=s[r],o=(f=r==a-1)?i:0,u=yl._jb(o,g),10!=i&&Of(qf(n,a-r),t[r],e[r],o,u),!f)for(++r,l=0;l<g;++l)yl.bkb(u,l,yl.Zjb(n,t,e,i,s,r,a));return u},yl._jb=function(n,t){var e,i=new Array(t);switch(n){case 14:case 15:e=0;break;case 16:e=!1;break;default:return i}for(var s=0;s<t;++s)i[s]=e;return i},yl.bkb=function(n,t,e){return n[t]=e},yl.dkb=function(n,t){n.fe=t},yl.ekb=function(n,t){n.__elementTypeCategory$=t},yl.fkb=function(n,t){n.__elementTypeId$=t},yl.hkb=function(n,t){return 10!=yl.Wjb(t)&&Of(Jl.Ic(t),t.ge,yl.Xjb(t),yl.Wjb(t),n),yl.Tjb(n)},yl.llb=function(n){return typeof n===c||typeof n===p},yl.mlb=function(n,t){return n&&t&&n instanceof t},yl.Owb=function(n){return n&&n.__java$exception},Jl.rFb=function(){Jl.rFb=Xf,d=kl.TTb(!1),kl.TTb(!0)},Jl.sFb=function(n){return kl.UTb((kl.ITb(n),n))},Jl.tFb=function(n,t){return function(n,t){return Jl.rFb(),n==t?0:n?1:-1}(kl.UTb((kl.ITb(n),n)),kl.UTb((kl.ITb(t),t)))},Jl.uFb=function(n,t){return Jl.tFb(n,t)},Jl.vFb=function(n,t){return kl.ITb(n),n===t},Jl.wFb=function(){return yl.Bub},Jl.xFb=function(n){return kl.UTb((kl.ITb(n),n))?1231:1237},Jl.AFb=function(n,t){return Jl.rFb(),ig(n)?Jl.EHb(n,t):ng(n)?Jl.yGb(n,t):$f(n)?Jl.uFb(n,t):n.Eb(t)},g={4:1,380:1,19:1},Jl.UFb=function(n){n.i=hg++},Jl.VFb=function(n){null==n.n&&Jl.jGb(n)},Jl.WFb=function(n){return Jl.VFb(n),n.n},Jl.XFb=function(n){return 0!=(4&n.f)},Jl.YFb=function(n){return 0!=(1&n.f)},Jl.ZFb=function(){Jl.UFb(this),this.n=null,this.j=null,this.g=null,this.d=null,this.b=null,this.k=null,this.a=null},Jl._Fb=function(n){var t;return(t=new Jl.ZFb).n="Class$"+(n?"S"+n:""+t.i),t.b=t.n,t.j=t.n,t},Jl.fGb=function(n,t){var e=n.a=n.a||[];return e[t]||(e[t]=n.Kd(t))},Jl.jGb=function(n){if(n.Od()){var t=n.c;return t.Pd()?n.n="["+t.k:t.Od()?n.n="["+t.Md():n.n="[L"+t.Md()+";",n.b=t.Ld()+"[]",void(n.j=t.Nd()+"[]")}var e=n.g,i=n.d;i=i.split("/"),n.n=Jl.mGb(".",[e,Jl.mGb("$",i)]),n.b=Jl.mGb(".",[e,Jl.mGb(".",i)]),n.j=i[i.length-1]},Jl.mGb=function(n,t){for(var e=0;!t[e]||""==t[e];)e++;for(var i=t[e++];e<t.length;e++)t[e]&&""!=t[e]&&(i+=n+t[e]);return i},Jl.nGb=function(n,t){if(n){t.k=n;var e=function(n){if(n.Pd())return null;var t=n.k;return l[t]}(t);e?e.fe=t:l[n]=[t]}},zf(239,1,{},Jl.ZFb),o.Kd=function(n){var t;return(t=new Jl.ZFb).f=4,t.c=n>1?Jl.fGb(this,n-1):this,t},o.Ld=function(){return Jl.VFb(this),this.b},o.Md=function(){return Jl.WFb(this)},o.Nd=function(){return Jl.VFb(this),this.j},o.Od=function(){return Jl.XFb(this)},o.Pd=function(){return Jl.YFb(this)},o.lb=function(){return(0!=(2&this.f)?"interface ":0!=(1&this.f)?"":"class ")+(Jl.VFb(this),this.n)},o.f=0,o.i=0;var ug,hg=1;function dg(n,t){return n<t?-1:n>t?1:n==t?0==n?dg(1/n,1/t):0:isNaN(n)?isNaN(t)?0:1:-1}function cg(n){return isNaN(n)?{l:0,m:0,h:524160}:kl.PTb(n)}function bg(n){var t,e;return n>=J?(t=55296+(n-J>>10&1023)&B,e=56320+(n-J&1023)&B,String.fromCharCode(t)+""+String.fromCharCode(e)):String.fromCharCode(n&B)}function Dg(n,t){this.b=n,this.c=t}Jl.sGb=function(t){return Jl.KHb(C,typeof t)||eg(t,n.java.lang.Number$impl)},Jl.tGb=function(n){if(null==Jl.rGb&&(Jl.rGb=new RegExp("^\\s*[+-]?(NaN|Infinity|((\\d+\\.?\\d*)|(\\.\\d+))([eE][+-]?\\d+)?[dDfF]?)\\s*$")),!Jl.rGb.test(n))throw og(new Jl.yHb(P+n+'"'));return parseFloat(n)},Jl.uGb=function(n,t,e){var i,s,r,a;if(null==n)throw og(new Jl.yHb(M));for(i=(r=kl.TTb(n).length)>0&&(kl.OTb(0,kl.TTb(n).length),45==kl.TTb(n).charCodeAt(0)||(kl.OTb(0,kl.TTb(n).length),43==kl.TTb(n).charCodeAt(0)))?1:0;i<r;i++)if(-1==Zg((kl.OTb(i,kl.TTb(n).length),kl.TTb(n).charCodeAt(i))))throw og(new Jl.yHb(P+n+'"'));if(s=(a=parseInt(n,10))<t,isNaN(a))throw og(new Jl.yHb(P+n+'"'));if(s||a>e)throw og(new Jl.yHb(P+n+'"'));return a},Jl.vGb=function(n){return ng(n)?Jl.zGb(n):n.Qd()},Jl.wGb=function(n){return ng(n)?Jl.DGb(n):n.Rd()},zf(142,1,{4:1,142:1}),Jl.xGb=function(n,t){return dg(kl.VTb((kl.ITb(n),n)),kl.VTb((kl.ITb(t),t)))},Jl.yGb=function(n,t){return Jl.xGb(n,t)},Jl.zGb=function(n){return kl.VTb((kl.ITb(n),n))},Jl.AGb=function(n,t){return kl.ITb(n),sg(n)===sg(t)},Jl.BGb=function(){return yl.Eub},Jl.CGb=function(n){return rg(kl.VTb((kl.ITb(n),n)))},Jl.DGb=function(n){return rg(kl.VTb((kl.ITb(n),n)))},u={4:1,19:1,387:1,142:1},Jl.xz=function(n){n.i=vf(yl.Tub,j,96,0,0,1)},Jl.yz=function(n,t){kl.JTb(t,"Cannot suppress a null exception."),kl.CTb(t!=n,"Exception can not suppress itself."),n.g||(null==n.j?n.j=Of(qf(yl.Yub,1),j,28,0,[t]):n.j[n.j.length]=t)},Jl.zz=function(n){Rl.$9(n)},Jl.Az=function(n){return Rl._9(n)},Jl.Bz=function(n){return n.k&&(n.backingJsObject!==N&&n.Xb(),n.i=null),n},Jl.Cz=function(n){return n.e},Jl.Dz=function(n,e){if(e instanceof Object)try{if(e.__java$exception=n,-1!=i.userAgent.toLowerCase().indexOf("msie")&&t.documentMode<9)return;var s=n;Object.defineProperties(e,{cause:{get:function(){var n=s.Vb();return n&&n.Tb()}},suppressed:{get:function(){return s.Ub()}}})}catch(n){}},Jl.Ez=function(n,t,e){var i,s,r,a,o;for(Jl.Fz(n),null==n.j&&(n.j=vf(yl.Yub,j,28,0,0,1)),r=0,a=(s=n.j).length;r<a;++r)i=s[r],Jl.Ez(i,t,"\t"+e);(o=n.e)&&Jl.Ez(o,t,e)},Jl.Fz=function(n){var t,e;for(null==n.i&&(n.i=Jl.Az(n)),t=0,e=n.i.length;t<e;++t);},Jl.Gz=function(n,t){n.backingJsObject=t,Jl.Dz(n,t)},Jl.Hz=function(n){return Jl.Iz(n,n.Wb())},Jl.Iz=function(n,t){var e;return e=Jl.WFb(n.fe),null==t?e:e+": "+t},Jl.Jz=function(){Jl.xz(this),Jl.Bz(this),this.Xb()},Jl.Kz=function(n){Jl.xz(this),this.f=n,Jl.Bz(this),this.Xb()},Jl.Lz=function(n,t){Jl.xz(this),this.e=t,this.f=n,Jl.Bz(this),this.Xb()},Jl.Nz=function(n){if(!("stack"in n))try{throw n}catch(n){}return n},zf(28,1,{4:1,28:1}),o.Sb=function(n){return new Error(n)},o.Tb=function(){return this.backingJsObject},o.Ub=function(){var n,t,e;for(null==this.j&&(this.j=vf(yl.Yub,j,28,0,0,1)),e=this.j,t=vf(yl.Rub,w,1,e.length,5,1),n=0;n<e.length;n++)t[n]=e[n].backingJsObject;return t},o.Vb=function(){return Jl.Cz(this)},o.Wb=function(){return this.f},o.Xb=function(){Jl.Gz(this,Jl.Nz(this.Sb(Jl.Iz(this,this.f)))),Jl.zz(this)},o.lb=function(){return Jl.Hz(this)},o.backingJsObject=N,o.g=!1,o.k=!0,Jl.Vz=function(){Jl.Jz.call(this)},Jl.Wz=function(n){Jl.xz(this),Jl.Bz(this),this.backingJsObject=n,Jl.Dz(this,n),this.f=null==n?M:xf(n)},Jl.Xz=function(n){Jl.Kz.call(this,n)},Jl.Yz=function(n,t){Jl.Lz.call(this,n,t)},zf(18,28,L,Jl.Xz),Jl.Zz=function(){Jl.Vz.call(this)},Jl.$z=function(n){Jl.Wz.call(this,n)},Jl._z=function(n){Jl.Xz.call(this,n)},Jl.aA=function(n,t){Jl.Yz.call(this,n,t)},zf(55,18,L,Jl._z),Jl.mFb=function(){Jl.Zz.call(this)},Jl.nFb=function(n){Jl._z.call(this,n)},zf(56,55,L,Jl.mFb,Jl.nFb),Jl.U8=function(){Jl.Zz.call(this)},Jl.V8=function(n){Jl.$z.call(this,n)},Jl.W8=function(n){Jl._z.call(this,n)},zf(150,55,L,Jl.V8),Jl.uHb=function(){Jl.U8.call(this)},Jl.vHb=function(n){Jl.V8.call(this,n)},Jl.wHb=function(n){Jl.W8.call(this,n)},zf(74,150,L,Jl.uHb,Jl.vHb,Jl.wHb),o.Sb=function(n){return new TypeError(n)},Jl.DHb=function(n,t){return kl.OTb(t,kl.TTb(n).length),kl.TTb(n).charCodeAt(t)},Jl.EHb=function(n,t){return Jl.FHb(n,t)},Jl.FHb=function(n,t){var e,i;return(e=Jl.zGb(kl.TTb(n)))==(i=Jl.zGb(kl.TTb(t)))?0:e<i?-1:1},Jl.GHb=function(n,t){return Jl.FHb(kl.TTb(n).toLowerCase(),kl.TTb(t).toLowerCase())},Jl.HHb=function(n,t){return kl.ITb(n),n+""+(kl.ITb(t),t)},Jl.IHb=function(n){return Jl.bIb(kl.sTb(n,0,n.length))},Jl.JHb=function(n){var t;return t=kl.TTb(U).length,Jl.KHb(kl.TTb(n).substr(kl.TTb(n).length-t,t),U)},Jl.KHb=function(n,t){return kl.ITb(n),sg(n)===sg(t)},Jl.LHb=function(n,t){return kl.ITb(n),null!=t&&(!!Jl.KHb(n,t)||kl.TTb(n).length==kl.TTb(t).length&&Jl.KHb(kl.TTb(n).toLowerCase(),kl.TTb(t).toLowerCase()))},Jl.MHb=function(){return yl.Xub},Jl.NHb=function(n){var t,e;for(t=0,e=0;e<kl.TTb(n).length;e++)t=(t<<5)-t+(kl.OTb(e,kl.TTb(n).length),kl.TTb(n).charCodeAt(e))|0;return t},Jl.OHb=function(n,t){return kl.TTb(n).indexOf(t)},Jl.PHb=function(n,t,e){return kl.TTb(n).indexOf(t,e)},Jl.RHb=function(n,t){return kl.TTb(n).lastIndexOf(t)},Jl.SHb=function(n,t,e){return kl.TTb(n).lastIndexOf(t,e)},Jl.THb=function(n,t){var e;return e=Jl.UHb(t,"([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])","\\\\$1"),Jl.UHb(n,e,"")},Jl.UHb=function(n,t,e){return e=Jl.aIb(e),kl.TTb(n).replace(new RegExp(t,"g"),e)},Jl.VHb=function(n,t){var e,i,s,r,a,o,l,f;for(e=new RegExp(t,"g"),l=vf(yl.Xub,y,2,0,6,1),i=0,f=n,r=null;;){if(null==(o=e.exec(f))||""==f){l[i]=f;break}a=o.index,l[i]=(kl.NTb(0,a,kl.TTb(f).length),kl.TTb(f).substr(0,a)),f=Jl.YHb(f,a+kl.TTb(kl.TTb(o)[0]).length,kl.TTb(f).length),e.lastIndex=0,r==f&&(l[i]=(kl.NTb(0,1,kl.TTb(f).length),kl.TTb(f).substr(0,1)),kl.OTb(1,kl.TTb(f).length+1),f=kl.TTb(f).substr(1)),r=f,++i}if(kl.TTb(n).length>0){for(s=l.length;s>0&&""==l[s-1];)--s;s<l.length&&(kl.TTb(l).length=s)}return l},Jl.WHb=function(n,t){return Jl.KHb(kl.TTb(n).substr(0,kl.TTb(t).length),t)},Jl.XHb=function(n,t){return kl.OTb(t,kl.TTb(n).length+1),kl.TTb(n).substr(t)},Jl.YHb=function(n,t,e){return kl.NTb(t,e,kl.TTb(n).length),kl.TTb(n).substr(t,e-t)},Jl.ZHb=function(n){var t,e,i;for(e=kl.TTb(n).length,i=0;i<e&&(kl.OTb(i,kl.TTb(n).length),kl.TTb(n).charCodeAt(i)<=32);)++i;for(t=e;t>i&&(kl.OTb(t-1,kl.TTb(n).length),kl.TTb(n).charCodeAt(t-1)<=32);)--t;return i>0||t<e?(kl.NTb(i,t,kl.TTb(n).length),kl.TTb(n).substr(i,t-i)):n},Jl.$Hb=function(n){return String.fromCharCode.apply(null,n)},Jl.aIb=function(n){var t;for(t=0;0<=(t=kl.TTb(n).indexOf("\\",t));)kl.OTb(t+1,kl.TTb(n).length),36==kl.TTb(n).charCodeAt(t+1)?(kl.NTb(0,t,kl.TTb(n).length),n=kl.TTb(n).substr(0,t)+"$"+Jl.XHb(n,++t)):(kl.NTb(0,t,kl.TTb(n).length),n=kl.TTb(n).substr(0,t)+""+Jl.XHb(n,++t));return n},Jl.bIb=function(n){return Jl.cIb(n,0,n.length)},Jl.cIb=function(t,e,i){var s,r,a,o;for(a=e+i,kl.NTb(e,a,t.length),o="",r=e;r<a;)s=n.Math.min(r+R,a),o+=Jl.$Hb(kl.TTb(t).slice(r,s)),r=s;return o},h={4:1,241:1,19:1,2:1},Jl.tIb=function(n){Jl.nFb.call(this,n)},zf(263,56,L,Jl.tIb),kl.eTb=function(n){var t;return t=kl.TTb(n).slice(),kl.oTb(t,n)},kl.fTb=function(t,e,i,s,r,a){var o,l,f,g,u;if(0!=r)for(sg(t)===sg(i)&&(t=kl.TTb(t).slice(e,e+r),e=0),f=kl.TTb(i),l=e,g=e+r;l<g;)r=(o=n.Math.min(l+R,g))-l,u=kl.TTb(t).slice(l,o),kl.TTb(u).splice(0,0,kl.TTb(s),kl.TTb(a?r:0)),Array.prototype.splice.apply(f,u),l=o,s+=r},kl.gTb=function(n,t){return kl.oTb(new Array(t),n)},kl.hTb=function(n,t,e){kl.TTb(n).splice(t,0,e)},kl.iTb=function(n,t,e){kl.fTb(e,0,n,t,e.length,!1)},kl.jTb=function(n,t){kl.TTb(n).push(t)},kl.kTb=function(n,t){kl.TTb(n).push(t)},kl.lTb=function(n,t,e){kl.TTb(n).splice(t,e)},kl.mTb=function(n,t){kl.TTb(n).length=t},kl.nTb=function(n,t){kl.TTb(n).sort(t)},zf(742,1,{}),kl.xTb=function(){},kl.yTb=function(n){switch(typeof n){case T:return Jl.NHb(kl.TTb(n));case C:return Jl.CGb(kl.TTb(n));case A:return Jl.xFb(kl.TTb(n));default:return null==n?0:kl.ATb(n)}},kl.zTb=function(){return++kl.wTb},kl.ATb=function(n){return n.$H||(n.$H=kl.zTb())},zf(652,1,{},kl.xTb),kl.wTb=0,kl.BTb=function(n){if(!n)throw og(new Jl.IGb)},kl.CTb=function(n,t){if(!n)throw og(new Jl.JGb(t))},kl.DTb=function(n,t){if(0>n)throw og(new Jl.JGb("fromIndex: 0 > toIndex: "+n));if(n>t)throw og(new Jl.pFb("fromIndex: 0, toIndex: "+n+k+t))},kl.ETb=function(n){if(n<0)throw og(new Jl.tHb("Negative array size: "+n))},kl.FTb=function(n,t){if(n!=t)throw og(new Fl.JPb)},kl.GTb=function(n){if(!n)throw og(new Fl.RQb)},kl.HTb=function(n,t){if(n<0||n>=t)throw og(new Jl.nFb(E+n+x+t))},kl.ITb=function(n){if(null==n)throw og(new Jl.uHb);return n},kl.JTb=function(n,t){if(null==n)throw og(new Jl.wHb(t))},kl.KTb=function(n,t){if(n<0||n>t)throw og(new Jl.nFb(E+n+x+t))},kl.LTb=function(n,t,e){if(n<0||t>e)throw og(new Jl.nFb(F+n+Q+t+", size: "+e));if(n>t)throw og(new Jl.JGb(F+n+" > toIndex: "+t))},kl.MTb=function(n){if(!n)throw og(new Jl.KGb)},kl.NTb=function(n,t,e){if(n<0||t>e||t<n)throw og(new Jl.tIb(F+n+Q+t+k+e))},kl.OTb=function(n,t){if(n<0||n>=t)throw og(new Jl.tIb(E+n+x+t))},kl.PTb=function(n){var t,e;return t=new ArrayBuffer(8),kl.TTb(new Float64Array(t))[0]=n,e=kl.TTb(new Uint32Array(t)),kl.WTb(0|e[0],0|e[1])},kl.QTb=function(n,t){return n[t]},kl.RTb=function(n){return void 0===n},kl.STb=function(n){return n>>>0},kl.TTb=function(n){return n},kl.UTb=function(n){return n},kl.VTb=function(n){return n},zf(653,1,{}),yl.Rub=lg(1),yl.Gqb=lg(0),yl.Pqb=lg(654),yl.Mqb=lg(389),yl.Oqb=lg(655),yl.Nqb=lg(390),yl.Bub=lg(380),yl.Dub=lg(239),yl.Qub=lg(142),yl.Eub=lg(387),yl.Yub=lg(28),yl.Gub=lg(18),yl.Sub=lg(55),yl.Jub=lg(56),yl.Lub=lg(150),yl.Oub=lg(74),yl.Xub=lg(2),yl.Wub=lg(263),yl.fwb=lg(652),yl.gwb=lg(653),El.Nc=function(t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,m,A,C,T,p,I,P,M,N,w,L,U,y,J,B,R,k,E,x,F,Q;for(this.c=t.length,this.d=t[0].length,L=n.Math.min(this.c,this.d),this.e=vf(yl.rlb,X,6,n.Math.min(this.c+1,this.d),15,1),this.a=Yf(yl.rlb,[j,X],[13,6],15,[this.c,L],2),this.b=Yf(yl.rlb,[j,X],[13,6],15,[this.d,this.d],2),r=vf(yl.rlb,X,6,this.d,15,1),Q=vf(yl.rlb,X,6,this.c,15,1),N=n.Math.min(this.c-1,this.d),w=n.Math.max(0,n.Math.min(this.d-2,this.c)),T=0;T<n.Math.max(N,w);T++){if(T<N){for(this.e[T]=0,h=T;h<this.c;h++)this.e[T]=El.Oc(this.e[T],t[h][T]);if(0!=this.e[T]){for(t[T][T]<0&&(this.e[T]=-this.e[T]),u=T;u<this.c;u++)t[u][T]/=this.e[T];t[T][T]+=1}this.e[T]=-this.e[T]}for(D=T+1;D<this.d;D++){if(T<N&0!=this.e[T]){for(F=0,h=T;h<this.c;h++)F+=t[h][T]*t[h][D];for(F=-F/t[T][T],u=T;u<this.c;u++)t[u][D]+=F*t[u][T]}r[D]=t[T][D]}if(!0&T<N)for(u=T;u<this.c;u++)this.a[u][T]=t[u][T];if(T<w){for(r[T]=0,h=T+1;h<this.d;h++)r[T]=El.Oc(r[T],r[h]);if(0!=r[T]){for(r[T+1]<0&&(r[T]=-r[T]),d=T+1;d<this.d;d++)r[d]/=r[T];r[T+1]+=1}if(r[T]=-r[T],T+1<this.c&0!=r[T]){for(d=T+1;d<this.c;d++)Q[d]=0;for(H=T+1;H<this.d;H++)for(c=T+1;c<this.c;c++)Q[c]+=r[H]*t[c][H];for(m=T+1;m<this.d;m++)for(F=-r[m]/r[T+1],c=T+1;c<this.c;c++)t[c][m]+=F*Q[c]}for(u=T+1;u<this.d;u++)this.b[u][T]=r[u]}}for(U=n.Math.min(this.d,this.c+1),N<this.d&&(this.e[N]=t[N][N]),this.c<U&&(this.e[U-1]=0),w+1<U&&(r[w]=t[w][U-1]),r[U-1]=0,A=N;A<L;A++){for(u=0;u<this.c;u++)this.a[u][A]=0;this.a[A][A]=1}for(p=N-1;p>=0;p--)if(0!=this.e[p]){for(b=p+1;b<L;b++){for(F=0,h=p;h<this.c;h++)F+=this.a[h][p]*this.a[h][b];for(F=-F/this.a[p][p],d=p;d<this.c;d++)this.a[d][b]+=F*this.a[d][p]}for(c=p;c<this.c;c++)this.a[c][p]=-this.a[c][p];for(this.a[p][p]=1+this.a[p][p],u=0;u<p-1;u++)this.a[u][p]=0}else{for(u=0;u<this.c;u++)this.a[u][p]=0;this.a[p][p]=1}for(I=this.d-1;I>=0;I--){if(I<w&0!=r[I])for(b=I+1;b<L;b++){for(F=0,h=I+1;h<this.d;h++)F+=this.b[h][I]*this.b[h][b];for(F=-F/this.b[I+1][I],d=I+1;d<this.d;d++)this.b[d][b]+=F*this.b[d][I]}for(u=0;u<this.d;u++)this.b[u][I]=0;this.b[I][I]=1}for(y=U-1,l=n.Math.pow(2,-52);U>0;){for(C=U-2;C>=-1&&-1!=C;C--)if(n.Math.abs(r[C])<=l*(n.Math.abs(this.e[C])+n.Math.abs(this.e[C+1]))){r[C]=0;break}if(C==U-2)P=4;else{for(M=U-1;M>=C&&M!=C;M--)if(F=(M!=U?n.Math.abs(r[M]):0)+(M!=C+1?n.Math.abs(r[M-1]):0),n.Math.abs(this.e[M])<=l*F){this.e[M]=0;break}M==C?P=3:M==U-1?P=1:(P=2,C=M)}switch(++C,P){case 1:for(f=r[U-2],r[U-2]=0,b=U-2;b>=C;b--)for(F=El.Oc(this.e[b],f),s=this.e[b]/F,k=f/F,this.e[b]=F,b!=C&&(f=-k*r[b-1],r[b-1]=s*r[b-1]),u=0;u<this.d;u++)F=s*this.b[u][b]+k*this.b[u][U-1],this.b[u][U-1]=-k*this.b[u][b]+s*this.b[u][U-1],this.b[u][b]=F;break;case 2:for(f=r[C-1],r[C-1]=0,b=C;b<U;b++)for(F=El.Oc(this.e[b],f),s=this.e[b]/F,k=f/F,this.e[b]=F,f=-k*r[b],r[b]=s*r[b],u=0;u<this.c;u++)F=s*this.a[u][b]+k*this.a[u][C-1],this.a[u][C-1]=-k*this.a[u][b]+s*this.a[u][C-1],this.a[u][b]=F;break;case 3:for(J=n.Math.max(n.Math.max(n.Math.max(n.Math.max(n.Math.abs(this.e[U-1]),n.Math.abs(this.e[U-2])),n.Math.abs(r[U-2])),n.Math.abs(this.e[C])),n.Math.abs(r[C])),E=this.e[U-1]/J,x=this.e[U-2]/J,o=r[U-2]/J,R=this.e[C]/J,a=r[C]/J,B=0,0!=(e=((x+E)*(x-E)+o*o)/2)|0!=(i=E*o*(E*o))&&(B=n.Math.sqrt(e*e+i),e<0&&(B=-B),B=i/(e+B)),f=(R+E)*(R-E)+B,g=R*a,b=C;b<U-1;b++){for(s=f/(F=El.Oc(f,g)),k=g/F,b!=C&&(r[b-1]=F),f=s*this.e[b]+k*r[b],r[b]=s*r[b]-k*this.e[b],g=k*this.e[b+1],this.e[b+1]=s*this.e[b+1],h=0;h<this.d;h++)F=s*this.b[h][b]+k*this.b[h][b+1],this.b[h][b+1]=-k*this.b[h][b]+s*this.b[h][b+1],this.b[h][b]=F;if(s=f/(F=El.Oc(f,g)),k=g/F,this.e[b]=F,f=s*r[b]+k*this.e[b+1],this.e[b+1]=-k*r[b]+s*this.e[b+1],g=k*r[b+1],r[b+1]=s*r[b+1],b<this.c-1)for(u=0;u<this.c;u++)F=s*this.a[u][b]+k*this.a[u][b+1],this.a[u][b+1]=-k*this.a[u][b]+s*this.a[u][b+1],this.a[u][b]=F}r[U-2]=f;break;case 4:if(this.e[C]<=0)for(this.e[C]=this.e[C]<0?-this.e[C]:0,u=0;u<=y;u++)this.b[u][C]=-this.b[u][C];for(;C<y&&!(this.e[C]>=this.e[C+1]);){if(F=this.e[C],this.e[C]=this.e[C+1],this.e[C+1]=F,C<this.d-1)for(u=0;u<this.d;u++)F=this.b[u][C+1],this.b[u][C+1]=this.b[u][C],this.b[u][C]=F;if(C<this.c-1)for(u=0;u<this.c;u++)F=this.a[u][C+1],this.a[u][C+1]=this.a[u][C],this.a[u][C]=F;++C}--U}}},El.Oc=function(t,e){var i;return n.Math.abs(t)>n.Math.abs(e)?(i=e/t,i=n.Math.abs(t)*n.Math.sqrt(1+i*i)):0!=e?(i=t/e,i=n.Math.abs(e)*n.Math.sqrt(1+i*i)):i=0,i},zf(232,1,S,El.Nc),o.c=0,o.d=0,yl.vlb=lg(232),xl.Qc=function(){xl.Qc=Xf,xl.Pc=Of(qf(yl.tlb,1),z,6,15,[0,G,14286847,13402367,12779264,16758197,9474192,3166456,16715021,9494608,11789301,11230450,9109248,12560038,1578e4,16744448,16777008,2093087,8442339,9388244,4062976,15132390,12567239,10921643,9083335,10255047,14706227,15765664,5296208,13140019,8224944,12750735,6721423,12419299,16752896,10889513,6076625,7351984,q,9764863,9756896,7586505,5551541,3907230,2396047,687500,27013,12632256,16767375,10909043,6717568,10380213,13924864,9699476,4366e3,5707663,51456,7394559,16777159,14286791,13107143,10747847,9437127,6422471,4587463,3211207,2097095,65436,58997,54354,48952,43812,5096191,5089023,2200790,2522539,2516630,1528967,13684960,16765219,12105936,10900557,5724513,10375093,11230208,7688005,4358806,4325478,32e3,7384058,47871,41471,36863,33023,27647,5528818,7888099,9064419,10565332,11739092,11739066,11734438,12389767,13041766,13369433,13697103,14221381,14680120,15073326,15400998,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13158600,1334015,56540,15075850,15132160,56540,15075850,15461355,8553170,1016335,1016335,1334015,15132160,3289770,14456450,16422400,16422400,11819700,3289770,1016335])},xl.Rc=function(n){n.w=new Kl.IG},xl.Sc=function(n){var t,e;0==(32&n.G)&&null!=(e=xl.lu(n.L))&&(0==n.A.a&&0==n.A.b&&(t=n.R.c*xl.Jk(n.L),n.w=xl.Od(n),xl.cd(n,t),xl.Kd(n,null,t,0)),n.yb(rg(n.B)),1!=n.L.O&&xl.Ld(n,448),n.pb(e,n.A.a,n.A.b+Y*n.B))},xl.Tc=function(n,t){return null==n?t:null==t?n:n+","+t},xl.Uc=function(n,t){xl.Ph(t,n.R),xl.Sh(t,n.w),xl.Rh(t,n.A)},xl.Vc=function(n){var t;t=n.R.c*(0!=n.r?n.r:xl.Jk(n.L)),n.Y=.06*t,n.T=.15*t,n.S=.38*t,n.W=.47*t,n.X=rg(t*n.J*.6+.5),n.V=.12*t,n.Z=.4*t,n.B=.5*t+.5},xl.Wc=function(n){var t,e;for(n=Cg(n,v),e=0;e<(Ol.xG(),Ol.wG).length;e++)if(Ig(n,Ol.wG[e]))return Ol.vG[e];return t=new Jl.sIb("R"),Rg(Cg(n,Z),0)&&(t.a+="0"),Rg(Cg(n,V),0)&&(t.a+="3"),Rg(Cg(n,O),0)&&(t.a+="4"),Rg(Cg(n,K),0)&&(t.a+="5"),Rg(Cg(n,W),0)&&(t.a+="6"),Rg(Cg(n,_),0)&&(t.a+="7"),Rg(Cg(n,$),0)&&(t.a+="8"),t.a},xl.Xc=function(n,t,e,i){var s,r;s=new xl.Zd,r=new xl.Zd,s.a=t.a,s.c=t.c,s.b=(t.a+t.b)/2,s.d=(t.c+t.d)/2,r.a=s.b,r.c=s.d,r.b=t.b,r.d=t.d,xl.Hd(n,s)&&(xl.Ld(n,n.p[e]),n.mb(s)),xl.Hd(n,r)&&(xl.Ld(n,n.p[i]),n.mb(r)),xl.Ld(n,n.Q)},xl.Yc=function(n,t,e,i){var s,r,a,o,l;o=(t.b-t.a)/10,l=(t.d-t.c)/10,s=new xl.Zd,xl.rl(n.L,xl.In(n.L,e,i))?(r=-3,a=-3):(r=n.p[e],a=n.p[i]),xl.Ld(n,r),s.a=t.a,s.c=t.c,s.b=t.a+2*o,s.d=t.c+2*l,n.mb(s),s.a=t.a+4*o,s.c=t.c+4*l,s.b=t.a+5*o,s.d=t.c+5*l,n.mb(s),xl.Ld(n,a),s.a=t.a+5*o,s.c=t.c+5*l,s.b=t.a+6*o,s.d=t.c+6*l,n.mb(s),s.a=t.a+8*o,s.c=t.c+8*l,s.b=t.b,s.d=t.d,n.mb(s),xl.Ld(n,n.Q)},xl.Zc=function(n,t,e){n.qb(t-n.V/2,e-n.V/2,n.V)},xl.$c=function(n,t,e,i){xl.rl(n.L,xl.In(n.L,e,i))?(xl.Ld(n,-3),n.mb(t),xl.Ld(n,n.Q)):n.p[e]!=n.p[i]?xl.Xc(n,t,e,i):0!=n.p[e]?(xl.Ld(n,n.p[e]),n.mb(t),xl.Ld(n,n.Q)):n.mb(t)},xl._c=function(n,t,e,i,s,r,a){a.a=t.a+s,a.c=t.c+r,a.b=t.b+s,a.d=t.d+r,xl.$c(n,a,e,i)},xl.ad=function(t,e,i,s){var r,a,o,l,f,g,u,h,d,c,b,D;for(h=e.b-e.a,b=e.d-e.c,f=n.Math.sqrt(h*h+b*b),d=h/((g=2*zg(Pg(n.Math.round(f/(4*t.Y)))))-1),D=b/(g-1),xl.rl(t.L,xl.In(t.L,i,s))?(r=-3,a=-3):(r=t.p[i],a=t.p[s]),u=e.a-t.Y/2,c=e.c-t.Y/2,xl.Ld(t,r),l=0;l<(g/2|0);l++)t.qb(u,c,t.Y),u+=d,c+=D;for(xl.Ld(t,a),o=0;o<(g/2|0);o++)t.qb(u,c,t.Y),u+=d,c+=D;xl.Ld(t,t.Q)},xl.bd=function(n,t,e,i){var s,r,a,o,l,f,g,u,h,d,c,b,D,H;l=(t.c-t.d)/9,d=(t.b-t.a)/9,f=t.b+l,c=t.d+d,g=t.b-l,b=t.d-d,u=(t.a+f)/2,D=(t.c+c)/2,h=(t.a+g)/2,H=(t.c+b)/2,a=new Kl.DG(3),o=new Kl.DG(4),Kl.CG(a,t.a,t.c),Kl.CG(a,u,D),Kl.CG(a,h,H),Kl.CG(o,h,H),Kl.CG(o,u,D),Kl.CG(o,f,c),Kl.CG(o,g,b),xl.rl(n.L,xl.In(n.L,e,i))?(s=-3,r=-3):(s=n.p[e],r=n.p[i],1!=n.L.O&&(r=xl.fd(n,e),s==xl.sk(n.L,e)&&(s=r))),xl.Ld(n,s),n.ob(a),xl.Ld(n,r),n.ob(o),xl.Ld(n,n.Q)},xl.cd=function(n,t){var e,i;for(i=0;i<n.$.a.length;i++)n.w=Kl.HG(n.w,Fl.Pi(n.$,i));xl.dd(n,t),e=.1*t,n.w.c-=e,n.w.d-=e,n.w.b+=2*e,n.w.a+=2*e},xl.dd=function(n,t){var e,i,s,r,a,o,l;for(s=vf(yl.Lwb,nn,6,n.L.q,16,1),i=0;i<n.L.r;i++)xl.pl(n.L,i)&&(s[xl.Nk(n.L,0,i)]=!0,s[xl.Nk(n.L,1,i)]=!0);for(a=new Kl.IG,e=0;e<n.L.q;e++)0!=(r=Rg(Cg(xl.Dk(n.L,e),tn),0)?.47*t:s[e]?.38*t:0)&&(o=xl.Vh(n.R,xl.Fk(n.L,e)),l=xl.Wh(n.R,xl.Gk(n.L,e)),Kl.GG(a,o-r,l-r,2*r,2*r),n.w=Kl.HG(n.w,a))},xl.ed=function(n,t){var e;return e=0!=n.M?n.M:0!=n.D?n.D:-1,gf.w6(t,e)},xl.fd=function(n,t){var e,i;if(0!=(4224&n.G))return n.p[t];if(-1==(i=xl.gd(n,t))&&-1!=(e=xl.qn(n.L,t))&&(t=e,i=xl.gd(n,t)),-1==i)return n.p[t];switch(255&i){case 1:return 384;case 2:return 64;default:return 448}},xl.gd=function(n,t){var e,i,s;return s=-1,i=-1,0!=(128&n.G)||(xl.nl(n.L,t)&&(s=xl.wk(n.L,t),i=xl.vk(n.L,t)),-1!=(e=xl.sn(n.L,t))&&(s=xl.Sk(n.L,e),i=xl.Rk(n.L,e)),-1!=s&&0!=s&&(s|=i<<8)),s},xl.hd=function(n){var t,e,i,s;for(n.wb(2*n.S),s=new xl.Zd,i=0;i<n.L.r;i++)t=xl.Nk(n.L,0,i),e=xl.Nk(n.L,1,i),xl.pl(n.L,i)&&(s.a=xl.Vh(n.R,xl.Fk(n.L,t)),s.c=xl.Wh(n.R,xl.Gk(n.L,t)),s.b=xl.Vh(n.R,xl.Fk(n.L,e)),s.d=xl.Wh(n.R,xl.Gk(n.L,e)),xl.Ld(n,-2),n.mb(s))},xl.jd=function(n){var t,e,i,s,r,a;if(n.L.K){for(a=n.W,xl.Ld(n,-7),t=0;t<n.L.f;t++)Rg(Cg(xl.Dk(n.L,t),tn),0)&&n.qb(xl.Vh(n.R,xl.Fk(n.L,t))-a,xl.Wh(n.R,xl.Gk(n.L,t))-a,2*a);for(n.wb(2*n.W),r=new xl.Zd,s=0;s<n.L.r;s++)e=xl.Nk(n.L,0,s),i=xl.Nk(n.L,1,s),Rg(Cg(Cg(xl.Dk(n.L,e),xl.Dk(n.L,i)),tn),0)&&(r.a=xl.Vh(n.R,xl.Fk(n.L,e)),r.c=xl.Wh(n.R,xl.Gk(n.L,e)),r.b=xl.Vh(n.R,xl.Fk(n.L,i)),r.d=xl.Wh(n.R,xl.Gk(n.L,i)),n.mb(r))}},xl.kd=function(n){var t,e,i,s;if(n.L.K){if(xl.Ld(n,320),0!=(8&n.G))for(t=0;t<n.L.f;t++)Rg(Cg(xl.Dk(n.L,t),-536870913),0)&&n.qb(xl.Vh(n.R,xl.Fk(n.L,t))-n.Z/2,xl.Wh(n.R,xl.Gk(n.L,t))-n.Z/2,n.Z);for(s=0;s<n.L.g;s++)0!=xl.Xk(n.L,s)&&(e=xl.Nk(n.L,0,s),i=xl.Nk(n.L,1,s),n.qb((xl.Vh(n.R,xl.Fk(n.L,e))+xl.Vh(n.R,xl.Fk(n.L,i))-n.Z)/2,(xl.Wh(n.R,xl.Gk(n.L,e))+xl.Wh(n.R,xl.Gk(n.L,i))-n.Z)/2,n.Z))}},xl.ld=function(n){n.J=1,n.R=new xl.Xh,n.$=new Fl.cj,n.U=new Fl.cj,n.s=vf(yl.Lwb,nn,6,n.L.q,16,1),n.A=new Kl.zG,n.Q=0,n.C=-1,xl.Qd(n)},xl.md=function(n,t){var e;if(0==xl.wn(n.L,t))return!1;for(e=0;e<xl.wn(n.L,t);e++)if(!xl.rl(n.L,xl.Mn(n.L,t,e)))return!1;return!0},xl.nd=function(n){var t;for(n.q=vf(yl.Lwb,nn,6,n.L.q,16,1),t=0;t<n.L.r;t++)n.q[xl.Nk(n.L,0,t)]=!0,n.q[xl.Nk(n.L,1,t)]=!0},xl.od=function(n,t){var e;if(2!=xl.Ln(n.L,t))return!1;for(e=0;e<2;e++)if(2!=xl.Nn(n.L,t,e))return!1;return!0},xl.pd=function(t,e,i,s,r){var a,o,l,f,g,u,h,d,c,b;for(d=!1,r.a=0,r.b=0,a=s>0?en:sn,b=xl.Mk(t.L,e,i),u=0;u<xl.Ln(t.L,e);u++)o=xl.Mn(t.L,e,u),l=b,(h=xl.Nk(t.L,0,o)==e?xl.Nk(t.L,1,o):xl.Nk(t.L,0,o))!=i&&(l<(c=xl.Mk(t.L,e,h))&&(l+=rn),f=l-c,s>0?(f<an&&(d=!0),f>en&&(f=en),f<.523598776&&(f=.523598776),f<=a&&(a=f,g=t.T*n.Math.tan(a-on)/2,r.a=-g*n.Math.sin(l),r.b=-g*n.Math.cos(l))):(f>=an&&(d=!0),f<sn&&(f=sn),f>5.759586531&&(f=5.759586531),f>=a&&(a=f,g=t.T*n.Math.tan(4.712388981-a)/2,r.a=-g*n.Math.sin(l),r.b=-g*n.Math.cos(l))));return d},xl.qd=function(t,e,i,s){var r;if(0==e)return s.a=i<0?t.T:-t.T,void(s.b=0);r=n.Math.atan(i/e),e<0&&(r+=an),s.a=-t.T*n.Math.sin(r),s.b=t.T*n.Math.cos(r)},xl.rd=function(n,t,e,i){var s,r,a,o,l,f,g,u,h,d,c,b;s=new xl.Zd,l=new xl.Zd,g=new Kl.zG,f=new Kl.zG,a=xl.Nk(n.L,0,e),o=xl.Nk(n.L,1,e),i&&(h=t.a,t.a=t.b,t.b=h,h=t.c,t.c=t.d,t.d=h,d=a,a=o,o=d),xl.Hd(n,t)&&(xl.Qo(n.L,e)?(s.a=t.a,s.c=t.c,s.b=t.b,s.d=t.d,0==(u=i?-xl.mo(n.L,e):xl.mo(n.L,e))&&(u=1),xl.qd(n,t.b-t.a,t.d-t.c,g),u>0?(l.a=t.a+g.a,l.c=t.c+g.b,l.b=t.b+g.a,l.d=t.d+g.b,(xl.pd(n,a,o,1,f)||xl.Ln(n.L,a)>1)&&(l.a+=f.a+g.b,l.c+=f.b-g.a)):(l.a=t.a-g.a,l.c=t.c-g.b,l.b=t.b-g.a,l.d=t.d-g.b,(xl.pd(n,a,o,-1,f)||xl.Ln(n.L,a)>1)&&(l.a+=f.a+g.b,l.c+=f.b-g.a)),386==xl.Yk(n.L,e)&&xl.Gd(s,l),xl.Hd(n,s)&&xl.$c(n,s,a,o),64==xl.Yk(n.L,e)?xl.Hd(n,l)&&xl.Yc(n,l,a,o):xl.Hd(n,l)&&xl.$c(n,l,a,o)):(xl.qd(n,t.b-t.a,t.d-t.c,g),c=g.a/2,b=g.b/2,r=!1,s.a=t.a+c,s.c=t.c+b,s.b=t.b+c,s.d=t.d+b,xl.Ln(n.L,a)>1&&(xl.pd(n,a,o,1,f)?(s.a+=f.a,s.c+=f.b,2==xl.Ln(n.L,a)&&(0==f.a&&0==f.b||(s.a+=g.b,s.c-=g.a))):n.o[a]=new Kl.AG(s.a,s.c)),l.a=t.a-c,l.c=t.c-b,l.b=t.b-c,l.d=t.d-b,xl.Ln(n.L,a)>1&&(xl.pd(n,a,o,0,f)?(l.a+=f.a,l.c+=f.b,2==xl.Ln(n.L,a)&&(0==f.a&&0==f.b||(l.a+=g.b,l.c-=g.a))):(n.o[a]=new Kl.AG(l.a,l.c),r=!0)),386==xl.Yk(n.L,e)&&xl.Gd(s,l),64==xl.Yk(n.L,e)?r?(xl.Yc(n,s,a,o),xl.$c(n,l,a,o)):(xl.$c(n,s,a,o),xl.Yc(n,l,a,o)):(xl.$c(n,s,a,o),xl.$c(n,l,a,o))))},xl.sd=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c;for(g=n.Q,u=n.F,0!=(n.G&ln)&&(n.Q=-6,n.F=-8355712,xl.Ld(n,1)),n.o=vf(yl.Knb,w,33,n.L.q,0,1),l=0;l<n.L.r;l++)(2==xl.Yk(n.L,l)||386==xl.Yk(n.L,l)||64==xl.Yk(n.L,l))&&xl.vd(n,l);for(f=0;f<n.L.r;f++)2!=xl.Yk(n.L,f)&&386!=xl.Yk(n.L,f)&&64!=xl.Yk(n.L,f)&&xl.vd(n,f);if(0==(64&n.G))for(o=0;o<n.L.r;o++)0!=xl.Qk(n.L,o)&&(s=null,1==xl.Qk(n.L,o)||2==xl.Qk(n.L,o)?(2==xl.Vk(n.L,o)||0==xl.Sk(n.L,o)||t[xl.Sk(n.L,o)][xl.Rk(n.L,o)]>1)&&(s=1==xl.Qk(n.L,o)?2==xl.Vk(n.L,o)?"E":xl.tl(n.L,o)?"p":"P":2==xl.Vk(n.L,o)?"Z":xl.tl(n.L,o)?"m":"M"):s="?",null!=s&&(n.yb((2*n.X+1)/3|0),xl.Ld(n,xl.rl(n.L,o)?-3:1==n.L.O||0!=(n.G&fn)?n.Q:448),e=xl.Nk(n.L,0,o),i=xl.Nk(n.L,1,o),d=(xl.Vh(n.R,xl.Fk(n.L,e))+xl.Vh(n.R,xl.Fk(n.L,i)))/2,c=(xl.Wh(n.R,xl.Gk(n.L,e))+xl.Wh(n.R,xl.Gk(n.L,i)))/2,r=(xl.Vh(n.R,xl.Fk(n.L,e))-xl.Vh(n.R,xl.Fk(n.L,i)))/3,a=(xl.Wh(n.R,xl.Gk(n.L,e))-xl.Wh(n.R,xl.Gk(n.L,i)))/3,xl.yd(n,d+a,c-r,s,!0),xl.Ld(n,n.Q),n.yb(n.X)));if(0!=(4&n.G)){for(n.yb((2*n.X+1)/3|0),xl.Ld(n,384),o=0;o<n.L.r;o++)e=xl.Nk(n.L,0,o),i=xl.Nk(n.L,1,o),h=xl.Ho(n.L,o)?"d":xl.Do(n.L,o)?"a":"",d=(xl.Vh(n.R,xl.Fk(n.L,e))+xl.Vh(n.R,xl.Fk(n.L,i)))/2,c=(xl.Wh(n.R,xl.Gk(n.L,e))+xl.Wh(n.R,xl.Gk(n.L,i)))/2,xl.yd(n,d,c,h+""+o,!0);xl.Ld(n,n.Q),n.yb(n.X)}0!=(n.G&ln)&&(n.Q=g,n.F=u)},xl.td=function(n){var t,e;for(e=new Fl.zOb(n.U);e.a<e.c.a.length;)t=Fl.yOb(e),xl.Ld(n,t.a),xl.Zc(n,t.b,t.c);xl.Ld(n,n.Q)},xl.ud=function(t,e,i){var s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,I,P,M,N,w,L,U,y,J,B,R,k,E,x,F,Q,S,z,G,q,Y,Z;if(t.K||t.tb(e,xl.xk(t.L,e),xl.Vh(t.R,xl.Fk(t.L,e)),xl.Wh(t.R,xl.Gk(t.L,e))),k=null,0!=xl.rk(t.L,e)&&(z=1==n.Math.abs(xl.rk(t.L,e))?"":""+n.Math.abs(xl.rk(t.L,e)),k=xl.rk(t.L,e)<0?z+"-":z+"+"),null!=t.t&&e<t.t.length&&null!=t.t[e]&&kl.TTb(t.t[e]).length>0&&(k=xl.Tc(k,t.t[e])),N=null,0!=Tg(E=xl.Dk(t.L,e),0)&&(Rg(Cg(E,gn),0)&&(N=null==N?"*":N+",*"),Rg(Cg(E,un),0)&&(N=null==N?"!*":N+",!*"),Rg(Cg(E,hn),0)?N=null==N?"ha":N+",ha":Rg(Cg(E,2),0)?N=null==N?"a":N+",a":Rg(Cg(E,4),0)&&(N=null==N?"!a":N+",!a"),Rg(Cg(E,fn),0)&&(N=null==N?"s":N+",s"),Rg(Cg(E,dn),0)&&(0==Tg(p=Cg(E,dn),1792)?N=null==N?"h0":N+",h0":0==Tg(p,1664)?N=null==N?"h1":N+",h1":0==Tg(p,1408)?N=null==N?"h2":N+",h2":0==Tg(p,128)?N=null==N?"h>0":N+",h>0":0==Tg(p,384)?N=null==N?"h>1":N+",h>1":0==Tg(p,896)?N=null==N?"h>2":N+",h>2":0==Tg(p,cn)?N=null==N?"h<3":N+",h<3":0==Tg(p,1536)&&(N=null==N?"h<2":N+",h<2")),Rg(Cg(E,bn),0)&&(0==Tg(f=Cg(E,bn),Dn)?N=null==N?"c0":N+",c0":0==Tg(f,Hn)?N=null==N?"c+":N+",c+":0==Tg(f,jn)&&(N=null==N?"c-":N+",c-")),Rg(Cg(E,mn),0)&&(0==Tg(R=Cg(E,mn),98304)?N=null==N?"pi0":N+",pi0":0==Tg(R,81920)?N=null==N?"pi1":N+",pi1":0==Tg(R,49152)?N=null==N?"pi2":N+",pi2":0==Tg(R,ln)&&(N=null==N?"pi>0":N+",pi>0")),Rg(Cg(E,An),0)&&(0==Tg(B=Cg(E,An),Cn)?N=null==N?"n1":N+",n1":0==Tg(B,Tn)?N=null==N?"n2":N+",n2":0==Tg(B,pn)?N=null==N?"n3":N+",n3":0==Tg(B,In)?N=null==N?"n<3":N+",n<3":0==Tg(B,Pn)?N=null==N?"n<4":N+",n<4":0==Tg(B,Mn)?N=null==N?"n>1":N+",n>1":0==Tg(B,Nn)?N=null==N?"n>2":N+",n>2":0==Tg(B,wn)&&(N=null==N?"n>3":N+",n>3")),Rg(Cg(E,Ln),0)&&(0==Tg(b=Cg(E,Ln),Un)?N=null==N?"e0":N+",e0":0==Tg(b,yn)?N=null==N?"e1":N+",e1":0==Tg(b,Jn)?N=null==N?"e2":N+",e2":0==Tg(b,Bn)?N=null==N?"e3":N+",e3":0==Tg(b,0xe0000000000)?N=null==N?"e<2":N+",e<2":0==Tg(b,0xc0000000000)?N=null==N?"e<3":N+",e<3":0==Tg(b,Rn)?N=null==N?"e<4":N+",e<4":0==Tg(b,kn)?N=null==N?"e>0":N+",e>0":0==Tg(b,En)?N=null==N?"e>1":N+",e>1":0==Tg(b,xn)?N=null==N?"e>2":N+",e>2":0==Tg(b,Fn)?N=null==N?"e>3":N+",e>3":0==Tg(b,4947802324992)?N=null==N?"e1-2":N+",e1-2":0==Tg(b,9345848836096)?N=null==N?"e1-3":N+",e1-3":0==Tg(b,0x98000000000)&&(N=null==N?"e2-3":N+",e2-3")),Rg(Cg(E,120),0)&&(0==Tg(x=Cg(E,120),112)?N=null==N?"!r":N+",!r":0==Tg(x,8)?N=null==N?"r":N+",r":0==Tg(x,96)?N=null==N?"rb<3":N+",rb<3":0==Tg(x,104)?N=null==N?"rb2":N+",rb2":0==Tg(x,88)?N=null==N?"rb3":N+",rb3":0==Tg(x,56)&&(N=null==N?"rb4":N+",rb4")),Rg(Cg(E,Qn),0)&&(N=null==N?"r"+Gg(Fg(Cg(E,Qn),22)):N+",r"+Gg(Fg(Cg(E,Qn),22))),Rg(Cg(E,v),0)&&(N=xl.Tc(N,xl.Wc(E))),Rg(Cg(E,Xn),0)&&(N=null==N?"f":N+",f")),0!=xl.Bk(t.L,e)&&(N=xl.Tc(N,""+xl.Bk(t.L,e))),S=0,0!=xl.Ek(t.L,e))switch(xl.Ek(t.L,e)){case 16:k=null==k?"|":k+",|";break;case 32:S=1;break;case 48:S=2}if(h=null,0==(64&t.G))if(xl.kl(t.L,e))h="?";else if(0!=xl.qk(t.L,e)&&(0==xl.wk(t.L,e)||null==i||i[xl.wk(t.L,e)][xl.vk(t.L,e)]>1))if(2==xl.Ln(t.L,e))switch(xl.qk(t.L,e)){case 2:h=xl.ml(t.L,e)?"p":"P";break;case 1:h=xl.ml(t.L,e)?"m":"M";break;default:h="*"}else switch(xl.qk(t.L,e)){case 1:h=xl.ml(t.L,e)?"r":"R";break;case 2:h=xl.ml(t.L,e)?"s":"S";break;default:h="*"}if(0!=(768&t.G)&&(h=xl.Tc(h,""+xl.tu(t.L,e))),y=null,0!=(16&t.G)&&0!=xl.Ak(t.L,e)&&(y=""+xl.Ak(t.L,e)),H=null,-1!=xl.ro(t.L,e)&&-1!=(D=xl.gd(t,e))&&(H=0==D?"abs":(1==(255&D)?"&":"or")+(1+(D>>8))),I=0,0==(t.G&Sn)&&(t.L.K?Rg(Cg(xl.Dk(t.L,e),zn),0)&&(I=xl.$n(t.L,e)):(6!=xl.Ik(t.L,e)||0!=xl.Bk(t.L,e)||!t.q[e]||0!=xl.Ek(t.L,e))&&(I=xl.$n(t.L,e))),U=!1,null!=(a=xl.tk(t.L,e))&&Jl.KHb(kl.TTb(a).substr(0,1),"]")&&(N=xl.Tc((kl.OTb(1,kl.TTb(a).length+1),kl.TTb(a).substr(1)),N),a=null,U=!0),null!=a?I=0:null!=xl.yk(t.L,e)?(a=(r=Rg(Cg(xl.Dk(t.L,e),1),0)?"[!":"[")+xl.zk(t.L,e)+"]",kl.TTb(a).length>5&&(a=r+xl.yk(t.L,e).length+"]"),Rg(Cg(xl.Dk(t.L,e),zn),0)&&(I=-1)):Rg(Cg(xl.Dk(t.L,e),1),0)?(a="?",Rg(Cg(xl.Dk(t.L,e),zn),0)&&(I=-1)):(6!=xl.Ik(t.L,e)||null!=k||null!=N||I>0||!t.q[e])&&(a=xl.xk(t.L,e)),L=0,!xl.Cl(t.L,e)&Rg(Cg(xl.Dk(t.L,e),tn),0)&&xl.Ld(t,-8),null!=a?(L=t.rb(a),xl.yd(t,xl.Vh(t.R,xl.Fk(t.L,e)),xl.Wh(t.R,xl.Gk(t.L,e)),a,!0),t.s[e]=!0):xl.od(t,e)&&xl.xd(t,xl.Vh(t.R,xl.Fk(t.L,e)),xl.Wh(t.R,xl.Gk(t.L,e)),e),null!=k&&(t.yb((2*t.X+1)/3|0),G=xl.Vh(t.R,xl.Fk(t.L,e))+((L+t.rb(k))/2+1),Y=xl.Wh(t.R,xl.Gk(t.L,e))-((4*t.sb()-4)/8|0),xl.yd(t,G,Y,k,!0),t.yb(t.X)),0!=(2&t.G)&&(N=""+e),null!=N&&(U?t.yb((5*t.X+1)/6|0):t.yb((2*t.X+1)/3|0),G=xl.Vh(t.R,xl.Fk(t.L,e))-(L+t.rb(N))/2,Y=xl.Wh(t.R,xl.Gk(t.L,e))-((4*t.sb()-4)/8|0),xl.yd(t,G,Y,N,!0),t.yb(t.X)),null!=h&&(t.yb((2*t.X+1)/3|0),G=xl.Vh(t.R,xl.Fk(t.L,e))-(L+t.rb(h))/2,Y=xl.Wh(t.R,xl.Gk(t.L,e))+((4*t.sb()+4)/8|0),Q=t.C,1!=t.L.O&&0==(t.G&fn)&&xl.Ld(t,448),xl.yd(t,G,Y,h,!1),xl.Ld(t,Q),t.yb(t.X)),null!=y&&(t.yb((2*t.X+1)/3|0),G=xl.Vh(t.R,xl.Fk(t.L,e))+((L+t.rb(y))/2+1),Y=xl.Wh(t.R,xl.Gk(t.L,e))+((4*t.sb()+4)/8|0),Q=t.C,xl.Ld(t,xl.ol(t.L,e)?384:448),xl.yd(t,G,Y,y,!0),xl.Ld(t,Q),t.yb(t.X)),null!=H&&(s=xl.Cd(t,e),t.yb((2*t.X+1)/3|0),G=xl.Vh(t.R,xl.Fk(t.L,e))+.7*t.sb()*n.Math.sin(s),Y=xl.Wh(t.R,xl.Gk(t.L,e))+.7*t.sb()*n.Math.cos(s),Q=t.C,!t.K&&1!=t.L.O&&xl.Ld(t,xl.fd(t,e)),xl.yd(t,G,Y,H,!1),xl.Ld(t,Q),t.yb(t.X)),0!=I||0!=S){for(C=vf(yl.rlb,X,6,4,15,1),M=0;M<xl.xn(t.L,e);M++)for(l=xl.Mn(t.L,e,M),w=0;w<2;w++)xl.Nk(t.L,w,l)==e&&((F=xl.Mk(t.L,xl.Nk(t.L,w,l),xl.Nk(t.L,1-w,l)))<Gn?(C[0]-=F+on,C[3]+=F+an):F<0?(C[2]+=F+on,C[3]-=F):F<on?(C[1]+=F,C[2]+=on-F):(C[0]+=F-on,C[1]+=an-F));if(0==xl.Ln(t.L,e)?xl.vl(t.L,e)?C[3]-=.2:C[1]-=.2:C[1]-=.1,(null!=k||null!=y)&&(C[1]+=10),(null!=N||null!=h)&&(C[3]+=10),m="",0!=I&&(T=t.rb("H"),A=0,j=t.sb(),-1==I?(m="n",t.yb((2*t.X+1)/3|0),A=t.rb(m)):I>1&&(m=""+I,t.yb((2*t.X+1)/3|0),A=t.rb(m)),C[1]<.6||C[3]<.6?(u=xl.Wh(t.R,xl.Gk(t.L,e)),C[1]<=C[3]?(C[1]+=10,g=xl.Vh(t.R,xl.Fk(t.L,e))+(L+T)/2):(C[3]+=10,g=xl.Vh(t.R,xl.Fk(t.L,e))-(L+T)/2-A)):(g=xl.Vh(t.R,xl.Fk(t.L,e)),C[0]<C[2]?(C[0]+=10,u=xl.Wh(t.R,xl.Gk(t.L,e))-j):(C[2]+=10,u=xl.Wh(t.R,xl.Gk(t.L,e))+j)),A>0&&(G=g+(T+A)/2,Y=u+((4*t.sb()+4)/8|0),xl.yd(t,G,Y,m,!0),t.yb(t.X)),xl.yd(t,g,u,"H",!0)),o=0,0!=S){for(J=50,d=0,P=0;P<4;P++)c=P>1?P-2:P+2,C[P]<J?(o=P,J=C[P],d=C[c]):C[P]==J&&C[c]>d&&(o=P,d=C[c]);switch(o){case 0:g=xl.Vh(t.R,xl.Fk(t.L,e)),u=xl.Wh(t.R,xl.Gk(t.L,e))-t.V-L/2;break;case 1:g=xl.Vh(t.R,xl.Fk(t.L,e))+t.V+L/2,u=xl.Wh(t.R,xl.Gk(t.L,e));break;case 2:g=xl.Vh(t.R,xl.Fk(t.L,e)),u=xl.Wh(t.R,xl.Gk(t.L,e))+t.V+L/2;break;default:g=xl.Vh(t.R,xl.Fk(t.L,e))-t.V-L/2,u=xl.Wh(t.R,xl.Gk(t.L,e))}if(1==S)Fl.Ki(t.$,new Kl.JG(g-t.V,u-t.V,2*t.V,2*t.V)),t.K||Fl.Ki(t.U,new xl.Yd(g,u,xl.md(t,e)?-3:t.p[e]));else{switch(o){case 2:case 0:q=2*t.V,Z=0,g-=t.V;break;default:q=0,Z=2*t.V,u-=t.V}Fl.Ki(t.$,new Kl.JG(g-t.V,u-t.V,2*t.V,2*t.V)),t.K||Fl.Ki(t.U,new xl.Yd(g,u,xl.md(t,e)?-3:t.p[e])),Fl.Ki(t.$,new Kl.JG(g+q-t.V,u+Z-t.V,2*t.V,2*t.V)),t.K||Fl.Ki(t.U,new xl.Yd(g+q,u+Z,xl.md(t,e)?-3:t.p[e]))}}-8==t.C&&xl.Ld(t,-9)}else-8==t.C&&xl.Ld(t,-9)},xl.vd=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C;if(m=new xl.Zd,e=new xl.Zd,a=new xl.Zd,D=new Kl.zG,b=new Kl.zG,s=xl.Nk(n.L,0,t),r=xl.Nk(n.L,1,t),n.ub(t,xl.Vh(n.R,xl.Fk(n.L,s)),xl.Wh(n.R,xl.Gk(n.L,s)),xl.Vh(n.R,xl.Fk(n.L,r)),xl.Wh(n.R,xl.Gk(n.L,r))),!xl.Cl(n.L,s)&&!xl.Cl(n.L,r)&&Rg(Cg(Eg(xl.Dk(n.L,s),xl.Dk(n.L,r)),tn),0)&&xl.Ld(n,-8),n.o[s]?(m.a=n.o[s].a,m.c=n.o[s].b):(m.a=xl.Vh(n.R,xl.Fk(n.L,s)),m.c=xl.Wh(n.R,xl.Gk(n.L,s))),n.o[r]?(m.b=n.o[r].a,m.d=n.o[r].b):(m.b=xl.Vh(n.R,xl.Fk(n.L,r)),m.d=xl.Wh(n.R,xl.Gk(n.L,r))),0!=(xl.Xk(n.L,t)&qn))return xl.Hd(n,m)&&n.nb(m),void xl.Ld(n,-9);switch(o=64==xl.Yk(n.L,t)?0:32==xl.Yk(n.L,t)?1:xl.Vk(n.L,t)){case 1:if(l=xl.Yk(n.L,t),0!=(128&n.G)&&(257==l||129==l)&&(j=xl.Nk(n.L,0,t),0!=(d=xl.wk(n.L,j)))){for(h=xl.vk(n.L,j),u=0,i=0;i<n.L.f;i++)xl.wk(n.L,i)==d&&xl.vk(n.L,i)==h&&++u;1==u&&(l=1)}switch(l){case 1:xl.Hd(n,m)&&xl.$c(n,m,s,r);break;case 257:xl.Ed(n,m,s,r);break;case 129:for(A=m.b-m.a,C=m.d-m.c,xl.rl(n.L,xl.In(n.L,s,r))?(f=-3,g=-3):(f=n.p[s],g=xl.fd(n,s),f==xl.sk(n.L,s)&&(f=g)),c=2;c<17;c+=2)e.a=m.a+c*A/17-c*C/128,e.c=m.c+c*C/17+c*A/128,e.b=m.a+c*A/17+c*C/128,e.d=m.c+c*C/17-c*A/128,xl.Hd(n,e)&&(xl.Ld(n,c<9?f:g),n.mb(e),xl.Ld(n,n.Q));break;case 32:xl.Hd(n,m)&&xl.ad(n,m,s,r)}break;case 0:case 2:if(!n.s[s]&&2!=xl.Bn(n.L,s)||!n.s[r]&&2!=xl.Bn(n.L,r)||xl.Qo(n.L,t)||2!=o)!n.s[r]&&2!=xl.Bn(n.L,r)||2!=o?!n.s[s]&&2!=xl.Bn(n.L,s)||2!=o?(0==(H=xl.mo(n.L,t))&&(H=1),e.a=m.a,e.c=m.c,e.b=m.b,e.d=m.d,xl.qd(n,m.b-m.a,m.d-m.c,D),H>0?(a.a=m.a+D.a,a.c=m.c+D.b,a.b=m.b+D.a,a.d=m.d+D.b,(xl.pd(n,s,r,1,b)||xl.Ln(n.L,s)>1)&&(a.a+=b.a+D.b,a.c+=b.b-D.a),(xl.pd(n,r,s,-1,b)||xl.Ln(n.L,r)>1)&&(a.b+=b.a-D.b,a.d+=b.b+D.a)):(a.a=m.a-D.a,a.c=m.c-D.b,a.b=m.b-D.a,a.d=m.d-D.b,(xl.pd(n,s,r,-1,b)||xl.Ln(n.L,s)>1)&&(a.a+=b.a+D.b,a.c+=b.b-D.a),(xl.pd(n,r,s,1,b)||xl.Ln(n.L,r)>1)&&(a.b+=b.a-D.b,a.d+=b.b+D.a)),386==xl.Yk(n.L,t)&&xl.Gd(e,a),xl.Hd(n,e)&&xl.$c(n,e,s,r),2==o?xl.Hd(n,a)&&xl.$c(n,a,s,r):xl.Hd(n,a)&&xl.Yc(n,a,s,r)):xl.rd(n,m,t,!0):xl.rd(n,m,t,!1);else{if(!xl.Hd(n,m))break;xl.qd(n,m.b-m.a,m.d-m.c,D),A=D.a/2,C=D.b/2,e.a=m.a+A,e.c=m.c+C,e.b=m.b+A,e.d=m.d+C,a.a=m.a-A,a.c=m.c-C,a.b=m.b-A,a.d=m.d-C,386==xl.Yk(n.L,t)&&xl.Gd(e,a),xl.$c(n,e,s,r),2==o?xl.$c(n,a,s,r):xl.Yc(n,a,s,r)}break;case 3:xl.Hd(n,m)&&(xl.$c(n,m,s,r),xl.qd(n,m.b-m.a,m.d-m.c,D),xl._c(n,m,s,r,D.a,D.b,e),xl._c(n,m,s,r,-D.a,-D.b,e));break;case 4:xl.Hd(n,m)&&(xl.qd(n,m.b-m.a,m.d-m.c,D),xl._c(n,m,s,r,1.5*D.a,1.5*D.b,e),xl._c(n,m,s,r,.5*D.a,.5*D.b,e),xl._c(n,m,s,r,-.5*D.a,-.5*D.b,e),xl._c(n,m,s,r,-1.5*D.a,-1.5*D.b,e));break;case 5:xl.Hd(n,m)&&(xl.$c(n,m,s,r),xl.qd(n,m.b-m.a,m.d-m.c,D),xl._c(n,m,s,r,2*D.a,2*D.b,e),xl._c(n,m,s,r,D.a,D.b,e),xl._c(n,m,s,r,-D.a,-D.b,e),xl._c(n,m,s,r,-2*D.a,-2*D.b,e))}-8==n.C&&xl.Ld(n,-9)},xl.wd=function(t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D;for(c=!1,s=0;s<t.L.g;s++)g=null,xl.ql(t.L,s)?g=(h=xl.Pk(t.L,s))==(u=xl.Ok(t.L,s))?"["+h+"]":"["+h+":"+u+"]":0!=(xl.Xk(t.L,s)&Yn)?g=(xl.Xk(t.L,s)&Yn)==Pn?"a":256==(384&xl.Xk(t.L,s))?"r!a":"!a":0!=(384&xl.Xk(t.L,s))&&(g=256==(384&xl.Xk(t.L,s))?"r":"!r"),0!=(d=(xl.Xk(t.L,s)&Nn)>>17)&&(g=(null==g?"":g)+d),null!=g&&(e=xl.Nk(t.L,0,s),i=xl.Nk(t.L,1,s),c||(t.yb((2*t.X+1)/3|0),c=!0),b=(xl.Vh(t.R,xl.Fk(t.L,e))+xl.Vh(t.R,xl.Fk(t.L,i)))/2,D=(xl.Wh(t.R,xl.Gk(t.L,e))+xl.Wh(t.R,xl.Gk(t.L,i)))/2,a=xl.Vh(t.R,xl.Fk(t.L,i))-xl.Vh(t.R,xl.Fk(t.L,e)),o=xl.Wh(t.R,xl.Gk(t.L,i))-xl.Wh(t.R,xl.Gk(t.L,e)),r=n.Math.sqrt(a*a+o*o),f=.6*t.rb(g),l=.55*t.sb(),0!=r&&(a>0?xl.yd(t,b+f*o/r,D-l*a/r,g,!0):xl.yd(t,b-f*o/r,D+l*a/r,g,!0)));c&&t.yb(t.X)},xl.xd=function(n,t,e,i){Fl.Ki(n.$,new Kl.JG(t-n.V,e-n.V,2*n.V,2*n.V)),n.K||Fl.Ki(n.U,new xl.Yd(t,e,xl.md(n,i)?-3:n.p[i]))},xl.yd=function(n,t,e,i,s){var r,a;s&&(r=n.rb(i)/2+(n.sb()/8|0),a=n.sb()/2|0,("+"==i||"-"==i)&&(a=2*a/3),Fl.Ki(n.$,new Kl.JG(t-r,e-a,2*r,2*a))),n.K||n.pb(i,t,e)},xl.zd=function(n){var t;t=n.a,n.a=n.b,n.b=t,t=n.c,n.c=n.d,n.d=t},xl.Ad=function(t,e,i){var s;return s=0==e?rn+t[0]-t[t.length-1]:t[e]-t[e-1],s-=i>vn&&i<Zn?2*n.Math.cos(i+Vn):.5*n.Math.cos(i+Vn)},xl.Bd=function(n){var t;return t=new Kl.IG,n.a<=n.b?(t.c=n.a,t.b=n.b-n.a):(t.c=n.b,t.b=n.a-n.b),n.c<=n.d?(t.d=n.c,t.a=n.d-n.c):(t.d=n.d,t.a=n.c-n.d),t},xl.Cd=function(n,t){var e,i,s,r,a,o,l;for(e=vf(yl.rlb,X,6,xl.wn(n.L,t),15,1),s=0;s<xl.wn(n.L,t);s++)e[s]=xl.Mk(n.L,t,xl.Kn(n.L,t,s));for(kl.nTb(e,kl.TTb(Qf(Fl._Ob.prototype.Zd,Fl._Ob,[]))),r=xl.Dd(e,0),a=xl.Ad(e,0,r),i=1;i<e.length;i++)o=xl.Dd(e,i),a<(l=xl.Ad(e,i,o))&&(a=l,r=o);return r},xl.Dd=function(n,t){var e;return t>0?(n[t]+n[t-1])/2:(e=an+(n[0]+n[n.length-1])/2)>an?e-rn:e},xl.Ed=function(n,t,e,i){var s,r,a,o;if(o=new xl.Zd,t.a!=t.b||t.c!=t.d){for(o.a=t.a,o.c=t.c,o.b=t.b,o.d=t.d,a=xl.Bd(o),s=0;s<n.$.a.length;s++)if(!((r=Fl.Pi(n.$,s)).c>a.c+a.b||r.d>a.d+a.a||a.c>r.c+r.b||a.d>r.d+r.a)){if(xl.Fd(n,o.a,o.c,s)){if(xl.Fd(n,o.b,o.d,s))return;return xl.Id(n,o,0,s),void xl.Ed(n,o,e,i)}if(xl.Fd(n,o.b,o.d,s))return xl.Id(n,o,1,s),void xl.Ed(n,o,e,i)}xl.bd(n,o,e,i)}},xl.Fd=function(n,t,e,i){var s;return 0==(1&n.G)&&(t>(s=Fl.Pi(n.$,i)).c&&t<s.c+s.b&&e>s.d&&e<s.d+s.a)},xl.Gd=function(n,t){var e;e=n.b,n.b=t.b,t.b=e,e=n.d,n.d=t.d,t.d=e},xl.Hd=function(n,t){var e,i,s,r,a,o;if(t.a==t.b&&t.c==t.d){for(a=new Fl.zOb(n.$);a.a<a.c.a.length;)if(r=Fl.yOb(a),Kl.EG(r,t.a,t.c))return!1;return!0}for(o=xl.Bd(t),e=!1,t.a>t.b&&(xl.zd(t),e=!0),i=0;i<n.$.a.length;i++)if(!((r=Fl.Pi(n.$,i)).c>o.c+o.b||r.d>o.d+o.a||o.c>r.c+r.b||o.d>r.d+r.a)){if(xl.Fd(n,t.a,t.c,i))return xl.Fd(n,t.b,t.d,i)?(e&&xl.zd(t),!1):(xl.Id(n,t,0,i),s=xl.Hd(n,t),e&&xl.zd(t),s);if(xl.Fd(n,t.b,t.d,i))return xl.Id(n,t,1,i),s=xl.Hd(n,t),e&&xl.zd(t),s}return e&&xl.zd(t),!0},xl.Id=function(t,e,i,s){var r,a,o,l,f,g,u,h,d,c,b;0==i?(h=e.a,c=e.c,d=e.b,b=e.d):(h=e.b,c=e.d,d=e.a,b=e.c),u=Fl.Pi(t.$,s),f=d>h?u.c+u.b:u.c,g=b>c?u.d+u.a:u.d,r=d-h,a=b-c,n.Math.abs(r)>n.Math.abs(a)?c==b?(o=f,l=c):d>h==f>(o=h+r*(g-c)/a)?l=g:(o=f,l=c+a*(f-h)/r):h==d?(o=h,l=g):b>c==g>(l=c+a*(f-h)/r)?o=f:(o=h+r*(g-c)/a,l=g),0==i?(e.a=o,e.c=l):(e.b=o,e.d=l)},xl.Jd=function(n){var t,e,i,s;if(0!=n.L.q){for(xl.iu(n.L,0!=(256&n.G)?63:0!=(512&n.G)?95:31),xl.Vc(n),e=xl.nu(n.L),i=!1,n.p=vf(yl.tlb,z,6,n.L.q,15,1),t=0;t<n.L.q;t++)n.p[t]=xl.sk(n.L,t),0!=n.p[t]&&(i=!0),xl.Cl(n.L,t)&&(n.p[t]=128),xl.fl(n.L,t)&&0==(n.G&zn)&&(n.p[t]=256);for(xl.Ld(n,-10),xl.jd(n),xl.hd(n),xl.kd(n),xl.Sc(n),n.yb(n.X),n.wb(n.Y),xl.Ld(n,n.Q),xl.nd(n),kl.mTb(n.U.a,0),kl.mTb(n.$.a,0),0!=(1&n.G)&&(xl.sd(n,e),xl.td(n),xl.wd(n)),s=0;s<n.L.q;s++)xl.md(n,s)?(xl.Ld(n,-3),xl.ud(n,s,e),xl.Ld(n,n.Q)):0!=n.p[s]?(xl.Ld(n,n.p[s]),xl.ud(n,s,e),xl.Ld(n,n.Q)):!i&&1!=n.L.O&&1!=xl.Ik(n.L,s)&&6!=xl.Ik(n.L,s)&&0==(n.G&cn)&&null==xl.yk(n.L,s)&&xl.Ik(n.L,s)<xl.Pc.length?(xl.Nd(n,xl.ed(n,xl.Pc[xl.Ik(n.L,s)])),xl.ud(n,s,e),xl.Ld(n,n.Q)):xl.ud(n,s,e);0==(1&n.G)&&(xl.td(n),xl.wd(n),xl.sd(n,e))}},xl.Kd=function(n,t,e,i){var s;switch(s=e/2,i&On){case On:if(t){n.A.a=t.c+t.b/2,n.A.b=t.d+t.a-s;break}case 0:n.A.a=n.w.c+n.w.b/2,n.A.b=n.w.d+n.w.a+s,t&&n.A.b>t.d+t.a-s&&(n.A.b=t.d+t.a-s);break;case Kn:if(t){n.A.a=t.c+t.b/2,n.A.b=t.d+s;break}case Wn:n.A.a=n.w.c+n.w.b/2,n.A.b=n.w.d-s,t&&n.A.b<t.d+s&&(n.A.b=t.d+s)}},xl.Ld=function(n,t){if(!n.K&&(-10==t&&(n.C=-999,t=n.Q),-2!=t&&-7!=t&&0!=n.N&&(t=-4),t!=n.C&&(-8!=n.C||-9==t)))switch(-8==t&&(n.O=n.C),-9==t&&(t=n.O),n.C=t,t){case 0:n.xb(0==n.F?_n:n.F);break;case-6:n.xb(n.F);break;case-4:n.xb(n.N);break;case-2:n.xb(n.u);break;case-3:n.xb(n.v);break;case-7:n.xb(n.H);break;case-8:n.xb(n.I);break;case-5:n.xb(n.P);break;case 64:n.xb(-14655233);break;case 128:n.xb($n);break;case 256:n.xb(-4194049);break;case 192:n.xb(-16711936);break;case 320:n.xb(-24576);break;case 384:n.xb(-16744448);break;case 448:n.xb(-6291456);break;case 1:n.xb(-8355712);break;default:n.xb(_n)}},xl.Md=function(n,t){n.G=t},xl.Nd=function(n,t){0==n.N?(n.C=-5,n.P=t,n.xb(t)):-4!=n.C&&(n.C=-4,n.xb(n.N))},xl.Od=function(n){var t,e,i,s,r;for(s=xl.Vh(n.R,xl.Fk(n.L,0)),e=xl.Vh(n.R,xl.Fk(n.L,0)),r=xl.Wh(n.R,xl.Gk(n.L,0)),i=xl.Wh(n.R,xl.Gk(n.L,0)),t=0;t<n.L.q;t++)s>xl.Vh(n.R,xl.Fk(n.L,t))&&(s=xl.Vh(n.R,xl.Fk(n.L,t))),e<xl.Vh(n.R,xl.Fk(n.L,t))&&(e=xl.Vh(n.R,xl.Fk(n.L,t))),r>xl.Wh(n.R,xl.Gk(n.L,t))&&(r=xl.Wh(n.R,xl.Gk(n.L,t))),i<xl.Wh(n.R,xl.Gk(n.L,t))&&(i=xl.Wh(n.R,xl.Gk(n.L,t)));return new Kl.JG(s,r,e-s,i-r)},xl.Pd=function(n,t,e){var i,s;return 0==n.L.q?null:(n.w=xl.Od(n),i=n.R.c*xl.Jk(n.L),1==(s=new xl.Zh(n.w,t,i,e)).c&&0==s.a&&0==s.b?s=null:(xl.Ph(s,n.R),xl.Sh(s,n.w)),xl.Kd(n,t,i,e),s)},xl.Qd=function(n){var t;t=0!=n.M?n.M:0!=n.D?n.D:-1,n.u=gf.x6(t),n.v=gf.w6(nt,t),n.H=-24321,n.I=-6291392},xl.Rd=function(n,t){var e;return xl.Sd(n,t,J),xl.Uh(n.R)?null:(e=n.R,xl.Qh(n.R,n.L),n.R=new xl.Xh,e)},xl.Sd=function(n,t,e){var i,s,r,a;if(0==n.L.q)return null;for(r=n.zb(t,e),xl.iu(n.L,0!=(256&n.G)?63:0!=(512&n.G)?95:31),xl.nd(n),kl.mTb(n.U.a,0),kl.mTb(n.$.a,0),xl.Vc(n),n.yb(n.X),n.K=!0,s=0;s<n.L.q;s++)xl.ud(n,s,null);return n.K=!1,i=n.R.c*xl.Jk(n.L),xl.cd(n,i),xl.Kd(n,t,i,e),!t||Kl.FG(t,n.w)?r:(a=new xl.Zh(n.w,t,i,e),xl.Ph(a,n.R),xl.Sh(a,n.w),xl.Rh(a,n.A),r?(xl.Ph(a,r),r):a)},xl.Td=function(n,t){xl.Qc(),xl.Rc(this),this.L=n,this.G=t,xl.ld(this)},zf(144,1,{144:1}),o.tb=function(n,t,e,i){},o.ub=function(n,t,e,i,s){},o.vb=function(n){xl.Jd(this)},o.zb=function(n,t){return xl.Pd(this,n,t)},o.r=0,o.u=0,o.v=0,o.B=0,o.C=0,o.D=0,o.F=0,o.G=0,o.H=0,o.I=0,o.J=0,o.K=!1,o.M=0,o.N=0,o.O=0,o.P=0,o.Q=0,o.S=0,o.T=0,o.V=0,o.W=0,o.X=0,o.Y=0,o.Z=0,yl.ylb=lg(144),xl.Yd=function(n,t,e){this.b=n,this.c=t,this.a=e},zf(161,1,{161:1},xl.Yd),o.a=0,o.b=0,o.c=0,yl.wlb=lg(161),xl.Zd=function(){},zf(81,1,{},xl.Zd),o.a=0,o.b=0,o.c=0,o.d=0,yl.xlb=lg(81),xl.$d=function(n){return tt+n.Cb()+'"'+n.Bb()+et},zf(230,1,{230:1}),o.lb=function(){var n;return n=new Jl.gIb,Jl.fIb(n,tt+this.Cb()+'"'+this.Bb()+et),n.a},o.d=!1,yl.zlb=lg(230),xl.ae=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,I,P,M,N,w,L,U,y,J,B,R,k,E,x,F,Q,X,S,G,q,Y,v;for(y=vf(yl.Lwb,nn,6,t.i.a.length,16,1),p=vf(yl.tlb,z,6,n.f.f,15,1),S=0;S<t.i.a.length;S++){for(y[S]=!0,H=0,j=(D=Fl.Pi(t.j,S)).length;H<j;++H)if(m=D[H],!n.e[m]){y[S]=!1;break}if(y[S])for(a=0,f=(i=Fl.Pi(t.i,S)).length;a<f;++a)++p[e=i[a]]}for(U=vf(yl.Lwb,nn,6,n.f.f,16,1),G=0;G<t.i.a.length;G++)if((3==(q=Fl.Pi(t.j,G).length)||5==q||6==q||7==q)&&y[G]){for(o=0,g=(s=Fl.Pi(t.i,G)).length;o<g;++o)U[e=s[o]]=!0;for(F=!0,R=-1,k=0,l=0,u=(r=Fl.Pi(t.i,G)).length;l<u;++l)if(e=r[l],6==q||p[e]>1){if(!xl.ee(n,e,!1)){F=!1;break}}else if(X=5==q?xl.be(n,e,!1):xl.ce(n,e,!1),xl.ee(n,e,!1))k<X&&(k=X,R=e);else{if(10==k){F=!1;break}R=e,k=20}if(F)for(a=0,f=(i=Fl.Pi(t.i,G)).length;a<f;++a)(e=i[a])==R?(5==q?xl.be(n,e,!0):xl.ce(n,e,!0),xl.pe(n,e)):xl.ee(n,e,!0)}for(T=vf(yl.tlb,z,6,n.f.f,15,1),P=vf(yl.Lwb,nn,6,n.f.f,16,1),b=0;b<n.f.g;b++)h=xl.Nk(n.f,0,b),d=xl.Nk(n.f,1,b),U[h]||U[d]||(n.e[b]&&(++T[h],++T[d]),32==xl.Yk(n.f,b)&&(P[h]=!0,P[d]=!0));for(Q=vf(yl.tlb,z,6,n.f.f,15,1),I=vf(yl.tlb,z,6,n.f.f,15,1),v=0;v<n.f.f;v++)if(1==T[v])for(I[0]=v,C=0,M=0;C<=M;){for(N=0;N<xl.Ln(n.f,I[C]);N++)if(n.e[xl.Mn(n.f,I[C],N)]&&(A=xl.Kn(n.f,I[C],N),(0==C||A!=I[C-1])&&0!=T[A])){if(I[++M]=A,0!=(1&T[A])){for(B=1;B<M;B+=2)Q[I[B]]=-1;M=0}break}++C}for(c=vf(yl.Lwb,nn,6,n.f.f,16,1),Y=0;Y<n.f.f;Y++)if(!c[Y]&&0!=T[Y]){for(I[0]=Y,c[Y]=!0,C=0,M=0;C<=M;){for(N=0;N<xl.Ln(n.f,I[C]);N++)n.e[xl.Mn(n.f,I[C],N)]&&(c[A=xl.Kn(n.f,I[C],N)]||(I[++M]=A,c[A]=!0));++C}if(0==(1&M)){for(w=0;w<=M;w++)0==Q[I[w]]&&(Q[I[w]]=xl.de(n,I[w],!1));for(J=!0,L=0;L<=M;L++)if(Q[I[L]]<=0&&!xl.ee(n,I[L],!1)){J=!1;break}if(J){for(x=0,E=-1,N=0;N<=M;N++)x<Q[I[N]]&&(x=Q[I[N]],E=I[N]);x>0&&(xl.de(n,E,!0),xl.pe(n,E))}}}},xl.be=function(n,t,e){if(7==xl.Ik(n.f,t)){if(3==xl.wn(n.f,t))return 6;if(2==xl.Ln(n.f,t))return 4}else{if(8==xl.Ik(n.f,t))return 10;if(15==xl.Ik(n.f,t)||33==xl.Ik(n.f,t)){if(3==xl.Ln(n.f,t))return 8}else if(16==xl.Ik(n.f,t)||34==xl.Ik(n.f,t)||52==xl.Ik(n.f,t)){if(2==xl.Ln(n.f,t))return 12}else if(6==xl.Ik(n.f,t))return e&&xl.Xl(n.f,t,-1),xl.wn(n.f,t)!=xl.xn(n.f,t)?2:3}return 0},xl.ce=function(n,t,e){if(n.a){if(3!=xl.wn(n.f,t))return 0}else if(xl.wn(n.f,t)>3)return 0;return 6==xl.Ik(n.f,t)?(e&&xl.Xl(n.f,t,1),2):5==xl.Ik(n.f,t)?4:0},xl.de=function(n,t,e){if(0!=xl.rk(n.f,t))return 0;if(n.a){if(5==xl.Ik(n.f,t))return 2!=xl.fo(n.f,t)?0:(e&&xl.Xl(n.f,t,1),1);if(7==xl.Ik(n.f,t))return 2!=xl.fo(n.f,t)?0:(e&&xl.Xl(n.f,t,-1),xl.ge(n,t)?6:3);if(8==xl.Ik(n.f,t))return 1!=xl.fo(n.f,t)?0:(e&&xl.Xl(n.f,t,-1),xl.ge(n,t)?7:4);if(16==xl.Ik(n.f,t))return 1!=xl.fo(n.f,t)?0:(e&&xl.Xl(n.f,t,-1),xl.ge(n,t)?5:2);if(34==xl.Ik(n.f,t))return 1!=xl.fo(n.f,t)?0:(e&&xl.Xl(n.f,t,-1),xl.ge(n,t)?4:1)}else{if(5==xl.Ik(n.f,t))return xl.fo(n.f,t)>2?0:(e&&xl.Xl(n.f,t,1),1);if(7==xl.Ik(n.f,t))return xl.fo(n.f,t)>2?0:(e&&xl.Xl(n.f,t,-1),xl.ge(n,t)?5:3);if(8==xl.Ik(n.f,t))return xl.fo(n.f,t)>1?0:(e&&xl.Xl(n.f,t,-1),xl.ge(n,t)?7:4);if(16==xl.Ik(n.f,t))return xl.fo(n.f,t)>1?0:(e&&xl.Xl(n.f,t,-1),xl.ge(n,t)?5:2)}return 0},xl.ee=function(n,t,e){var i,s;if((i=xl.Ik(n.f,t))>=5&&i<=8||15==i||16==i||33==i||34==i||52==i){if(0!=xl._n(n.f,t))return!0;if(s=xl.rk(n.f,t),5==i&&s>=0)return e&&xl.Xl(n.f,t,s-1),!0;if(5!=i&&s<=0)return e&&xl.Xl(n.f,t,s+1),!0}return!1},xl.fe=function(n,t,e,i){var s;for(s=0;s<xl.Ln(n.f,t);s++)if(1==i[xl.Mn(n.f,t,s)]&&xl.Kn(n.f,t,s)!=e)return s;return-1},xl.ge=function(n,t){var e;for(e=0;e<xl.Ln(n.f,t);e++)if(xl.yl(n.f,xl.Kn(n.f,t,e)))return!0;return!1},xl.he=function(n,t,e){var i;for(i=0;i<xl.Ln(n.f,t);i++)if(e[xl.Mn(n.f,t,i)]>1)return!0;return!1},xl.ie=function(n,t){var e;for(e=0;e<xl.Ln(n.f,t);e++)if(n.e[xl.Mn(n.f,t,e)])return!0;return!1},xl.je=function(n,t,e){var i,s,r,a,o,l,f,g,u,h;if(xl.iu(n.f,1),null!=t)n.e=t;else for(n.e=vf(yl.Lwb,nn,6,n.f.g,16,1),s=0;s<n.f.g;s++)64==xl.Yk(n.f,s)&&(n.e[s]=!0,xl.ym(n.f,s,1));for(n.g=0,n.d=vf(yl.Lwb,nn,6,n.f.f,16,1),r=0;r<n.f.g;r++)if(n.e[r])for(++n.c,o=0;o<2;o++)n.d[xl.Nk(n.f,o,r)]||(n.d[xl.Nk(n.f,o,r)]=!0,++n.b);if(0==n.c)return!0;for(n.a=!1,xl.re(n,e),n.f.K&&xl.le(n),h=new xl._r(n.f,1),e&&xl.ae(n,h),xl.se(n,h),xl.oe(n,h),xl.qe(n),xl.me(n);xl.ne(n,h);)xl.me(n);for(;0!=n.c;){if(!(a=!1))for(g=0;g<h.i.a.length;g++)if(6==Fl.Pi(h.j,g).length){for(f=!0,u=Fl.Pi(h.j,g),l=0;l<6;l++)if(!n.e[u[l]]){f=!1;break}if(f){for(o=0;o<6;o+=2)xl.ke(n,u[o]);a=!0;break}}if(!a)for(i=0;i<n.f.g;i++)if(n.e[i]){xl.ke(n,i),xl.me(n),a=!0;break}}return n.b==n.g},xl.ke=function(n,t){var e,i,s,r;for(1==xl.Yk(n.f,t)&&(xl.ym(n.f,t,2),n.g+=2),s=0;s<2;s++)for(e=xl.Nk(n.f,s,t),n.d[e]=!1,r=0;r<xl.Ln(n.f,e);r++)i=xl.Mn(n.f,e,r),n.e[i]&&(n.e[i]=!1,--n.c)},xl.le=function(n){var t,e,i,s,r,a,o,l;for(e=0;e<n.f.g;e++)if(n.e[e])for(s=0;s<2;s++){for(o=xl.Nk(n.f,s,e),t=!1,a=0;a<xl.Ln(n.f,o);a++)if(e!=xl.Mn(n.f,o,a)&&n.e[xl.Mn(n.f,o,a)]){t=!0;break}if(!t){for(l=e,i=xl.Nk(n.f,1-s,e);-1!=l;)for(n.e[l]=!1,--n.c,xl.ym(n.f,l,64),l=-1,o=i,r=0;r<xl.Ln(n.f,o);r++)if(n.e[xl.Mn(n.f,o,r)]){if(-1!=l){o=-1,l=-1;break}l=xl.Mn(n.f,o,r),i=xl.Kn(n.f,o,r)}break}}},xl.me=function(n){var t,e,i,s,r,a,o;do{for(o=!1,e=0;e<n.f.g;e++)if(n.e[e]){for(r=!1,s=0;s<2;s++){for(i=xl.Nk(n.f,s,e),t=!1,a=0;a<xl.Ln(n.f,i);a++)if(e!=xl.Mn(n.f,i,a)&&n.e[xl.Mn(n.f,i,a)]){t=!0;break}if(!t){r=!0;break}}r&&(o=!0,xl.ke(n,e))}}while(o)},xl.ne=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c;for(c=vf(yl.tlb,z,6,n.f.g,15,1),h=0;h<t.i.a.length;h++){for(d=Fl.Pi(t.j,h),u=!0,g=0;g<d.length;g++)if(!n.e[d[g]]){u=!1;break}if(u)for(f=0;f<d.length;f++)++c[d[f]]}for(l=n.c,r=0;r<n.f.g;r++)if(1==c[r])for(f=0;f<2&&n.e[r];f++)if(e=xl.Nk(n.f,f,r),i=xl.Nk(n.f,1-f,r),xl.he(n,e,c)&&!xl.he(n,i,c))for(;-1!=(o=xl.fe(n,i,e,c))&&(s=xl.Kn(n.f,i,o),a=xl.Mn(n.f,i,o),n.e[a])&&(xl.ke(n,a),-1!=(o=xl.fe(n,s,i,c)));)e=s,i=xl.Kn(n.f,s,o);return l!=n.c},xl.oe=function(n,t){var e;for(e=0;e<n.f.g;e++)n.e[e]&&xl.Ur(t,e)&&(xl.pe(n,xl.Nk(n.f,0,e)),xl.pe(n,xl.Nk(n.f,1,e)))},xl.pe=function(n,t){var e,i;for(n.d[t]&&(n.d[t]=!1,--n.b),i=0;i<xl.Ln(n.f,t);i++)e=xl.Mn(n.f,t,i),n.e[e]&&(n.e[e]=!1,--n.c)},xl.qe=function(n){var t,e,i,s,r;for(e=0;e<n.f.g;e++)if(2==xl.Vk(n.f,e))for(s=0;s<2;s++)if(t=xl.Nk(n.f,s,e),xl.Ik(n.f,t)<=8)for(r=0;r<xl.Ln(n.f,t);r++)if(i=xl.Mn(n.f,t,r),n.e[i]){xl.pe(n,t);break}},xl.re=function(n,t){var e;for(e=0;e<n.f.f;e++)n.d[e]&&0==xl._n(n.f,e)&&(!t||5==xl.Ik(n.f,e)&&xl.rk(n.f,e)<0||6==xl.Ik(n.f,e)||14==xl.Ik(n.f,e)||xl.vl(n.f,e)&&xl.rk(n.f,e)>0)&&xl.pe(n,e)},xl.se=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d;for(g=0;g<t.i.a.length;g++)if(3==(d=Fl.Pi(t.j,g).length)||5==d||7==d)for(u=Fl.Pi(t.i,g),i=0;i<d;i++)e=u[i],xl.ie(n,e)&&(5==d?(6==xl.Ik(n.f,e)&&-1==xl.rk(n.f,e)&&3==xl.wn(n.f,e)||7==xl.Ik(n.f,e)&&0==xl.rk(n.f,e)&&3==xl.wn(n.f,e)||8==xl.Ik(n.f,e)&&0==xl.rk(n.f,e)&&2==xl.Ln(n.f,e)||16==xl.Ik(n.f,e)&&0==xl.rk(n.f,e)&&2==xl.Ln(n.f,e)||34==xl.Ik(n.f,e)&&0==xl.rk(n.f,e)&&2==xl.Ln(n.f,e))&&xl.pe(n,e):(5==xl.Ik(n.f,e)&&0==xl.rk(n.f,e)&&3==xl.wn(n.f,e)||6==xl.Ik(n.f,e)&&1==xl.rk(n.f,e))&&xl.pe(n,e));for(f=0;f<t.i.a.length;f++)if(5==Fl.Pi(t.j,f).length){for(h=Fl.Pi(t.j,f),r=!0,s=0;s<h.length;s++)if(!n.e[h[s]]){r=!1;break}if(r){for(u=Fl.Pi(t.i,f),o=0,a=-1,i=0;i<h.length;i++)-1==xl.rk(n.f,u[i])&&6==xl.Ik(n.f,u[i])&&o<(l=3==xl.wn(n.f,u[i])?3:3==xl.xn(n.f,u[i])?2:1)&&(o=l,a=u[i]);-1!=a&&xl.pe(n,a)}}},xl.te=function(n){this.f=n},zf(114,1,{},xl.te),o.a=!1,o.b=0,o.c=0,o.g=0,yl.Alb=lg(114),xl.ue=function(n,t){var e,i;for(e=0,i=0;i<n.j[t];i++)2==n.n[t][i]&&(7==xl.Ik(n,n.i[t][i])||8==xl.Ik(n,n.i[t][i])||16==xl.Ik(n,n.i[t][i]))&&++e;return e},xl.ve=function(t,e){var i,s,r,a,o,l;if(0==t.s[e])return!1;for(l=!0,i=t.s[e],a=t.j[e],o=0,s=0;s<a;s++)r=t.i[e][s],o+=t.s[r];return n.Math.abs(i)<=n.Math.abs(o)&&Jl.sHb(i)!=Jl.sHb(o)&&(l=!1),l},xl.we=function(n,t){var e,i,s,r,a,o,l;if(8!=n.C[t]||0!=n.s[t]||1!=n.j[t]||1!=n.n[t][0])return!1;if(e=n.i[t][0],6==n.C[e]){for(a=n.j[e],i=0;i<a;i++)if((s=n.i[e][i])!=t&&8==n.C[s]&&(r=xl.In(n,e,s),2==n.H[r]))return!0}else if(7==n.C[e]){if(1==n.s[e])return!0}else if(16==n.C[e]){for(o=n.j[e],l=0,i=0;i<o;i++)(s=n.i[e][i])!=t&&8==n.C[s]&&(r=xl.In(n,e,s),2==n.H[r]&&++l);if(2==l)return!0}else if(xl.xe(n,t))return!0;return!1},xl.xe=function(n,t){var e,i,s,r,a;if(8!=n.C[t])return!1;if(1!=n.j[t])return!1;if(e=n.i[t][0],15==n.C[e])for(a=n.j[e],i=0;i<a;i++)if((s=n.i[e][i])!=t&&8==n.C[s]&&(r=xl.In(n,e,s),2==n.H[r]))return!0;return!1},xl.ye=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p;if(7!=n.C[t]||0!=n.s[t]||n.j[t]+n.o[t]>3)return!1;if(t<n.f&&xl.Nr(n.p,t)){if(1!=n.o[t])return!1;if(1!=xl.En(n,t,7))return!1;for(xl.iu(n,7),A=n.p,j=0;j<A.i.a.length;j++)if(xl.Pr(A,j,t)){if(5==Fl.Pi(A.j,j).length||6==Fl.Pi(A.j,j).length){for(C=Fl.Pi(A.i,j),D=-1,l=0;l<C.length;l++)if(C[l]==t){D=l;break}for(s=0,H=null,b=null,5==C.length&&((H=vf(yl.tlb,z,6,2,15,1))[0]=C[D-1<0?D+4:D-1],H[1]=C[D-4<0?D+1:D-4],(b=vf(yl.tlb,z,6,2,15,1))[0]=C[D-2<0?D+3:D-2],b[1]=C[D-3<0?D+2:D-3]),6==C.length&&((H=vf(yl.tlb,z,6,3,15,1))[0]=C[D-1<0?D+5:D-1],H[1]=C[D-3<0?D+3:D-3],H[2]=C[D-5<0?D+1:D-5],(b=vf(yl.tlb,z,6,2,15,1))[0]=C[D-2<0?D+4:D-2],b[1]=C[D-4<0?D+2:D-4]),f=0;f<C.length;f++)t!=C[f]&&7==xl.Ik(n,C[f])&&1==xl.Bn(n,C[f])&&--s;for(g=0;g<H.length;g++){for(r=-1,a=-1,c=0;c<xl.Ln(n,H[g]);c++)if(!xl.Do(n,xl.Mn(n,H[g],c))){r=xl.Kn(n,H[g],c),a=xl.Mn(n,H[g],c);break}if(-1!=r){if(7==n.C[r]&&0==n.o[r]&&n.j[r]+n.o[r]<=3&&!xl.ze(n,r,!1)){++s;continue}if(8==n.C[r]&&1==n.j[r]){s+=2;continue}if(a<n.g&&xl.Or(n.p,a))for(T=0;T<A.i.a.length;T++)if(A.d[T]&&xl.Pr(A,T,r)){for(m=Fl.Pi(A.i,T),d=0;d<m.length;d++)if(7==xl.Ik(n,m[d])&&1==xl.Bn(n,m[d])){--s;break}break}}}for(u=0;u<b.length;u++){for(r=-1,d=0;d<xl.Ln(n,b[u]);d++)xl.Do(n,xl.Mn(n,b[u],d))||(r=xl.Kn(n,b[u],d));6==xl.Ik(n,b[u])?-1!=r&&0!=xl.ue(n,r)&&--s:7==xl.Ik(n,b[u])&&0==xl.Bn(n,b[u])&&(-1==r||!(r<n.f&&xl.Nr(n.p,r))&&0==xl.ue(n,r))&&++s}return s>0}break}return!1}if(n.o[t]>1)return!1;if(1==n.o[t]){for(h=-1,p=0,l=0;l<n.j[t];l++)if(i=n.i[t][l],2!=n.n[t][l]){if(8==n.C[i])return!1;7!=n.C[i]?i<n.f&&xl.Nr(n.p,i)&&--p:(--p,xl.ze(n,i,!1)&&--p)}else{if(6!=n.C[i])return!1;h=i}if(-1==h)return!1;for(e=0,f=0;f<n.j[h];f++)if(1==n.n[h][f]){if(i=n.i[h][f],0!=xl.ue(n,i))return!1;i<n.f&&xl.Nr(n.p,i)&&++e,7==n.C[i]&&!xl.ze(n,i,!0)&&++p,(8==n.C[i]||16==n.C[i])&&--p}return 2==e&&--p,p>=0}for(o=0;o<n.j[t];o++){if((i=n.i[t][o])<n.f&&xl.Nr(n.p,i))return!1;if(6!=n.C[i])return!1;if(0!=xl.ue(n,i))return!1;if(0!=n.o[i]&&xl.Ae(n,i))return!1}return!0},xl.ze=function(n,t,e){var i,s,r;for(i=!1,r=0;r<n.j[t];r++)if(!xl.Do(n,n.k[t][r])&&1==n.n[t][r]&&!((s=n.i[t][r])<n.f&&xl.Nr(n.p,s))&&(6==n.C[s]&&1==xl.ue(n,s)||16==n.C[s]&&2==xl.ue(n,s))){if(i||!e)return!0;i=!0}return!1},xl.Ae=function(n,t){var e,i,s;for(i=0;i<n.j[t];i++)if(1!=n.n[t][i])for(e=n.i[t][i],s=0;s<n.j[e];s++)if(1==n.n[e][s]&&0!=xl.ue(n,n.i[e][s]))return!0;return!1},xl.De=function(){xl.De=Xf,xl.Be=Of(qf(yl.Kwb,1),it,6,15,[-1,-1,-1,0,0,1,2,3,4,5,-1,0,0,0,6,7,8,9,-1,0,0,10,10,10,10,10,10,10,10,10,10,1,11,11,12,13,-1,0,0,10,10,10,10,10,10,10,10,10,10,0,0,0,11,14,-1,0,0,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,10,10,10,10,10,10,10,10,1,1,1,1,-1,-1,-1,-1,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]),xl.Ce=Of(qf(yl.Kwb,1),it,6,15,[-1,-1,-1,0,0,0,2,5,5,5,-1,0,0,0,0,9,9,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])},xl.Ee=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d,c,b;for(xl.De(),xl.iu(n,7),d=vf(yl.ulb,st,6,n.j[t],14,1),h=0,l=0;l<n.j[t];l++)if(s=n.i[t][l],1!=n.C[s]){if(a=0,0!=(32&e)&&(r=Mg(n.n[t][l]),32190==e?Tg(r,3)<0&&xl.Ho(n,n.k[t][l])&&1==n.o[t]&&(r=0):Tg(r,3)<0&&xl.Do(n,n.k[t][l])&&(r=0),a=Eg(a,xg(r,4))),0!=(128&e)){if(-1==xl.Be[n.C[s]])throw og(new Jl.Xz(rt+n.C[s]));a=Ag(a,Mg(xl.Be[n.C[s]]))}else if(0!=(64&e)){if(-1==xl.Ce[n.C[s]])throw og(new Jl.Xz(rt+n.C[s]));a=Ag(a,Mg(xl.Ce[n.C[s]]))}for(0!=(256&e)&&((c=n.j[s]-1)>3&&(c=3),0==(512&e)&&c>1&&(c=1),a=Eg(a,yl.$wb(c<<6))),0!=(e&cn)&&0!=(8&n.u[s])&&(a=Eg(a,256)),0!=(e&zn)&&s<n.f&&xl.Nr(n.p,s)&&(a=Eg(a,512)),0!=(e&ln)&&0!=(n.u[s]&Sn)&&(a=Eg(a,cn)),g=0;Tg(a,d[g])<0;)++g;for(u=l;u>g;u--)d[u]=d[u-1];d[g]=a,++h}for(h>4&&(h=4),i=0,f=0;f<h;f++)i=Eg(i=xg(i,11),d[f]);if(i=xg(i,15),-1==xl.Be[n.C[t]])throw og(new Jl.Xz(rt+n.C[t]));if(i=Eg(i,Mg(xl.Be[n.C[t]])),0!=(2&e)?((b=n.p&&t<n.f?xl.Cr(n.p,t):0)>9&&(b=9),b>2&&(b-=2),i=Eg(i,yl.$wb(b<<4))):0!=(1&e)&&0!=(8&n.u[t])&&(i=Eg(i,64)),0!=(4&e)&&t<n.f&&xl.Nr(n.p,t)&&(i=Eg(i,cn)),0!=(8&e)&&0!=(n.u[t]&fn)&&(i=Eg(i,zn)),0!=(16&e)&&0!=(n.u[t]&Sn)&&(i=Eg(i,fn)),0!=(e&fn)&&(xl.ve(n,t)&&(i=Eg(i,Sn)),xl.ye(n,t)))for(o=0;o<n.f;o++)if(xl.we(n,o)){i=Eg(i,ln);break}return 0!=(e&Sn)&&(i=Eg(i,xg(Mg(xl.En(n,t,10)),7))),i},xl.Fe=function(n,t,e,i,s,r){var a,o,l,f;for(l=0,o=0;o<n.P.f;o++)Rg(Cg(xl.Dk(n.P,n.w[o]),i),0)&&++l;if(0!=l)for(xl.Df(n,t),xl.yf(n,yl.$wb(l),e),a=0;a<n.P.f;a++)0!=Tg(f=Cg(xl.Dk(n.P,n.w[a]),i),0)&&(xl.yf(n,yl.$wb(a),e),1!=s&&xl.yf(n,Fg(f,r),s))},xl.Ge=function(n,t,e,i,s,r){var a,o,l,f;for(l=0,o=0;o<n.P.g;o++)0!=(xl.Xk(n.P,n.A[o])&i)&&++l;if(0!=l)for(xl.Df(n,t),xl.yf(n,yl.$wb(l),e),a=0;a<n.P.g;a++)0!=(f=xl.Xk(n.P,n.A[a])&i)&&(xl.yf(n,yl.$wb(a),e),1!=s&&xl.yf(n,yl.$wb(f>>r),s))},xl.He=function(n){for(var t,e,i,s,r,a;;){for(r=vf(yl.Lwb,nn,6,n.S+1,16,1),i=-1,e=0;e<n.P.f;e++)0!=xl._n(n.P,e)&&(r[n.d[e]]&&i<n.d[e]&&(i=n.d[e]),r[n.d[e]]=!0);if(-1==i)break;for(s=0,t=0;t<n.P.f;t++)a=0,n.d[t]==i&&(a=++s),xl.zg(n.c[t],t),xl.wg(n.c[t],n.b,Mg(n.d[t])),xl.wg(n.c[t],8,yl.$wb(a));n.S=xl.gf(n)}},xl.Ie=function(n){var t,e,i,s;for(e=0;e<n.P.f;e++)xl.zg(n.c[e],e),xl.wg(n.c[e],2*n.b+4,xg(Mg(n.d[e]),n.b+4));for(s=!1,t=0;t<n.P.f;t++)s|=xl.Ve(n,t,3);for(i=0;i<n.P.g;i++)s|=xl.Qe(n,i,3);if(!s)return!1;for(;n.S<n.P.f&&(s=xl.df(n));)xl.ff(n),n.N&&xl.Pg(n.N,n.d);return!0},xl.Je=function(n){var t,e,i,s,r;for(e=0;e<n.P.f;e++)xl.zg(n.c[e],e),xl.wg(n.c[e],n.b+1,Mg(2*n.d[e]));for(r=vf(yl.tlb,z,6,n.S+1,15,1),i=0;i<n.P.f;i++)++r[n.d[i]];for(s=1;1==r[s];)++s;for(t=0;t<n.P.f;t++)if(n.d[t]==s){xl.xg(n.c[t],1);break}n.S=xl.gf(n)},xl.Ke=function(n,t,e){var i,s,r,a,o;return(6==xl.Ik(n.P,t)||7==xl.Ik(n.P,t))&&(s=xl.Kn(n.P,t,0),r=xl.Kn(n.P,t,1),1==xl.Bn(n.P,s)&&1==xl.Bn(n.P,r)&&(1!=xl.Ln(n.P,s)&&1!=xl.Ln(n.P,r)&&(!(xl.wn(n.P,s)>3||xl.wn(n.P,r)>3)&&((!(a=new xl.Cj(n.P,n.d,t,s)).f||1!=e)&&((!(o=new xl.Cj(n.P,n.d,t,r)).f||1!=e)&&((!a.f||!o.f)&&(3==e&&(a.f&&a.c&&(n.U[t]=!0),o.f&&o.c&&(n.U[t]=!0)),i=n.hb?xl.Me(n,a,o):xl.Le(a,o),1==e?n.bb[t]=i:2==e&&(a.f&&(1==i?xl.xg(n.c[a.b],Mg(n.d[s])):xl.xg(n.c[a.d],Mg(n.d[s]))),o.f&&(2==i?xl.xg(n.c[o.b],Mg(n.d[r])):xl.xg(n.c[o.d],Mg(n.d[r])))),!0)))))))},xl.Le=function(n,t){var e,i,s;if(i=xl.Bj(n),s=xl.Bj(t),-1==i||-1==s||0==(i+s&1))return 3;switch(e=0,i+s){case 3:case 7:e=2;break;case 5:e=1}return e},xl.Me=function(t,e,i){var s,r;return(s=vf(yl.tlb,z,6,4,15,1))[0]=e.b,s[1]=e.a,s[2]=i.a,s[3]=i.b,r=xl.Xj(t.P,s),n.Math.abs(r)<.3||n.Math.abs(r)>at?3:r<0?2:1},xl.Ne=function(n,t,e){var i,s,r,a,o;return!!xl.Eo(n.P,t)&&(i=xl.Nk(n.P,0,t),s=xl.Nk(n.P,1,t),(!(a=new xl.Cj(n.P,n.d,i,s)).f||1!=e)&&((!(o=new xl.Cj(n.P,n.d,s,i)).f||1!=e)&&((!a.f||!o.f)&&(3==e&&(a.f&&(n.T[t]=xl.Tf(n,s)),o.f&&(n.T[t]=xl.Tf(n,i))),r=n.hb?xl.Pe(n,a,o):xl.Oe(a,o),1==e?n.k[t]=r:2==e&&(a.f&&(2==r?xl.xg(n.c[a.b],Mg(n.d[s])):xl.xg(n.c[a.d],Mg(n.d[s]))),o.f&&(2==r?xl.xg(n.c[o.b],Mg(n.d[i])):xl.xg(n.c[o.d],Mg(n.d[i])))),!0))))},xl.Oe=function(n,t){var e,i,s;if(i=xl.Bj(n),s=xl.Bj(t),-1==i||-1==s||0==(i+s&1))return 3;switch(e=0,i+s){case 3:case 7:e=1;break;case 5:e=2}return e},xl.Pe=function(t,e,i){var s,r;return(s=vf(yl.tlb,z,6,4,15,1))[0]=e.b,s[1]=e.a,s[2]=i.a,s[3]=i.b,r=xl.Xj(t.P,s),n.Math.abs(r)<.3||n.Math.abs(r)>at?3:r<0?1:2},xl.Qe=function(n,t,e){var i,s,r,a,o;return 0==n.k[t]&&(1==xl.Vk(n.P,t)?xl.Ne(n,t,e):2==xl.Vk(n.P,t)&&(!xl.Do(n.P,t)&&(s=xl.Nk(n.P,0,t),r=xl.Nk(n.P,1,t),1!=xl.Ln(n.P,s)&&1!=xl.Ln(n.P,r)&&(!(xl.Ln(n.P,s)>3||xl.Ln(n.P,r)>3)&&(2!=xl.Bn(n.P,s)&&2!=xl.Bn(n.P,r)&&((!(a=new xl.Cj(n.P,n.d,r,s)).f||1!=e)&&((!(o=new xl.Cj(n.P,n.d,s,r)).f||1!=e)&&((!a.f||!o.f)&&(3==e&&(a.f&&a.c&&(n.T[t]=!0),o.f&&o.c&&(n.T[t]=!0)),i=xl.ul(n.P,t)?3:n.hb?xl.Se(n,a,o):xl.Re(a,o),1==e?n.k[t]=i:2==e&&(a.f&&(1==i?xl.xg(n.c[a.b],Mg(n.d[s])):2==i&&xl.xg(n.c[a.d],Mg(n.d[s]))),o.f&&(1==i?xl.xg(n.c[o.b],Mg(n.d[r])):2==i&&xl.xg(n.c[o.d],Mg(n.d[r])))),!0)))))))))},xl.Re=function(n,t){return-1==xl.Bj(n)||-1==xl.Bj(t)||0!=(1&(xl.Bj(n)|xl.Bj(t)))?3:xl.Bj(n)==xl.Bj(t)?1:2},xl.Se=function(t,e,i){var s,r,a,o,l;return(s=vf(yl.rlb,X,6,3,15,1))[0]=xl.Fk(t.P,i.a)-xl.Fk(t.P,e.a),s[1]=xl.Gk(t.P,i.a)-xl.Gk(t.P,e.a),s[2]=xl.Hk(t.P,i.a)-xl.Hk(t.P,e.a),(o=vf(yl.rlb,X,6,3,15,1))[0]=xl.Fk(t.P,e.b)-xl.Fk(t.P,e.a),o[1]=xl.Gk(t.P,e.b)-xl.Gk(t.P,e.a),o[2]=xl.Hk(t.P,e.b)-xl.Hk(t.P,e.a),(l=vf(yl.rlb,X,6,3,15,1))[0]=xl.Fk(t.P,i.b)-xl.Fk(t.P,i.a),l[1]=xl.Gk(t.P,i.b)-xl.Gk(t.P,i.a),l[2]=xl.Hk(t.P,i.b)-xl.Hk(t.P,i.a),(r=vf(yl.rlb,X,6,3,15,1))[0]=s[1]*o[2]-s[2]*o[1],r[1]=s[2]*o[0]-s[0]*o[2],r[2]=s[0]*o[1]-s[1]*o[0],(a=vf(yl.rlb,X,6,3,15,1))[0]=s[1]*r[2]-s[2]*r[1],a[1]=s[2]*r[0]-s[0]*r[2],a[2]=s[0]*r[1]-s[1]*r[0],(o[0]*a[0]+o[1]*a[1]+o[2]*a[2])/(n.Math.sqrt(o[0]*o[0]+o[1]*o[1]+o[2]*o[2])*n.Math.sqrt(a[0]*a[0]+a[1]*a[1]+a[2]*a[2]))<0^(l[0]*a[0]+l[1]*a[1]+l[2]*a[2])/(n.Math.sqrt(l[0]*l[0]+l[1]*l[1]+l[2]*l[2])*n.Math.sqrt(a[0]*a[0]+a[1]*a[1]+a[2]*a[2]))<0?1:2},xl.Te=function(n,t){var e,i,s,r;return e=xl.pk(n.P,t),r=-1,(i=xl.Zn(n.P,t,!1))!=(s=xl.Zn(n.P,t,!0))?r=-1!=e&&e>i?e<<24>>24:i<<24>>24:-1!=e?(e>s||e<s&&e>=xl.fo(n.P,t))&&(r=e<<24>>24):xl.ip(n.P,t)||0==xl.Pn(n.P,t)||(r=xl.fo(n.P,t),r-=xl.al(n.P,t,r)),xl.of(n,t,r),r},xl.Ue=function(n){var t,e,i,s,r,a,o,l,f,g,u;for(i=vf(yl.tlb,z,6,n.M,15,1),t=0;t<n.P.f;t++){for(g=xl.Ln(n.P,t)+xl.bo(n.P,t),f=0,r=0;r<xl.xn(n.P,t);r++)if(r<xl.Ln(n.P,t)||r>=xl.wn(n.P,t)){for(u=2*n.d[xl.Kn(n.P,t,r)],e=xl.Mn(n.P,t,r),2==xl.Vk(n.P,e)&&(xl.Do(n.P,e)||++u),o=0;o<f&&!(u<i[o]);o++);for(l=f;l>o;l--)i[l]=i[l-1];i[o]=u,++f}for(xl.zg(n.c[t],t),xl.wg(n.c[t],n.b,Mg(n.d[t])),a=g;a<n.M;a++)xl.wg(n.c[t],n.b+1,0);for(s=0;s<g;s++)xl.wg(n.c[t],n.b+1,yl.$wb(i[s]))}},xl.Ve=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d,c;if(0!=n.bb[t])return!1;if(5!=xl.Ik(n.P,t)&&6!=xl.Ik(n.P,t)&&7!=xl.Ik(n.P,t)&&14!=xl.Ik(n.P,t)&&15!=xl.Ik(n.P,t)&&16!=xl.Ik(n.P,t))return!1;if(0!=xl.Bn(n.P,t)){if(xl.Fo(n.P,t))return xl.Ke(n,t,e);if(15!=xl.Ik(n.P,t)&&16!=xl.Ik(n.P,t))return!1}if(xl.Ln(n.P,t)<3||xl.wn(n.P,t)>4)return!1;if(xl.rk(n.P,t)>0&&6==xl.Ik(n.P,t))return!1;if(5==xl.Ik(n.P,t)&&4!=xl.wn(n.P,t))return!1;if(7==xl.Ik(n.P,t)&&!n.Q[t])return!1;for(d=vf(yl.tlb,z,6,4,15,1),c=vf(yl.tlb,z,6,4,15,1),f=vf(yl.Lwb,nn,6,4,16,1),o=0;o<xl.wn(n.P,t);o++){for(r=-1,s=0,l=0;l<xl.wn(n.P,t);l++)f[l]||r<n.d[xl.Kn(n.P,t,l)]&&(r=n.d[xl.Kn(n.P,t,l)],s=l);d[o]=s,c[o]=r,f[s]=!0}if(4==xl.wn(n.P,t)&&c[0]==c[1]&&c[2]==c[3])return!1;if(4==xl.wn(n.P,t)&&(c[0]==c[2]||c[1]==c[3]))return!1;if(3==xl.wn(n.P,t)&&c[0]==c[2])return!1;for(g=0,u=0,h=!1,a=1;a<xl.wn(n.P,t);a++)if(c[a-1]==c[a]){if(1==e||0==c[a])return!1;g=xl.Kn(n.P,t,d[a-1]),u=xl.Kn(n.P,t,d[a]),3==e&&xl.Qo(n.P,xl.Mn(n.P,t,d[a]))&&(n.U[t]=!0),h=!0}return!(1!=e&&!h)&&(i=n.hb?xl.Xe(n,t,d):xl.We(n,t,d),1==e?n.bb[t]=i:2==e&&(1==i?xl.xg(n.c[g],Mg(n.d[t])):2==i&&xl.xg(n.c[u],Mg(n.d[t]))),!0)},xl.We=function(n,t,e){var i,s,r,a,o,l,f,g,u,h;for(h=Of(qf(yl.tlb,2),ot,8,0,[Of(qf(yl.tlb,1),z,6,15,[2,1,2,1]),Of(qf(yl.tlb,1),z,6,15,[1,2,2,1]),Of(qf(yl.tlb,1),z,6,15,[1,1,2,2]),Of(qf(yl.tlb,1),z,6,15,[2,1,1,2]),Of(qf(yl.tlb,1),z,6,15,[2,2,1,1]),Of(qf(yl.tlb,1),z,6,15,[1,2,1,2])]),i=vf(yl.rlb,X,6,xl.wn(n.P,t),15,1),a=0;a<xl.wn(n.P,t);a++)i[a]=xl.Mk(n.P,xl.Kn(n.P,t,e[a]),t);if(3!=(f=xl.Rn(n.P,t,e,i,null)<<24>>24))return f;for(g=0,u=0,o=0;o<xl.wn(n.P,t);o++)s=xl.Mn(n.P,t,e[o]),xl.Nk(n.P,0,s)==t&&(129==xl.Yk(n.P,s)&&(0!=u&&xl.Hm(n.P,t),g=o,u=1),257==xl.Yk(n.P,s)&&(0!=u&&xl.Hm(n.P,t),g=o,u=2));if(0==u)return 3;for(r=1;r<xl.wn(n.P,t);r++)i[r]<i[0]&&(i[r]+=rn);if(3==xl.wn(n.P,t)){switch(g){case 0:(i[1]<i[2]&&i[2]-i[1]<an||i[1]>i[2]&&i[1]-i[2]>an)&&(u=3-u);break;case 1:i[2]-i[0]>an&&(u=3-u);break;case 2:i[1]-i[0]<an&&(u=3-u)}return 1==u?2:1}return l=0,i[1]<=i[2]&&i[2]<=i[3]?l=0:i[1]<=i[3]&&i[3]<=i[2]?l=1:i[2]<=i[1]&&i[1]<=i[3]?l=2:i[2]<=i[3]&&i[3]<=i[1]?l=3:i[3]<=i[1]&&i[1]<=i[2]?l=4:i[3]<=i[2]&&i[2]<=i[1]&&(l=5),h[l][g]==u?2:1},xl.Xe=function(t,e,i){var s,r,a,o,l;for(s=vf(yl.tlb,z,6,4,15,1),o=0;o<xl.wn(t.P,e);o++)s[o]=xl.Kn(t.P,e,i[o]);for(3==xl.wn(t.P,e)&&(s[3]=e),r=Yf(yl.rlb,[j,X],[13,6],15,[3,3],2),a=0;a<3;a++)r[a][0]=xl.Fk(t.P,s[a+1])-xl.Fk(t.P,s[0]),r[a][1]=xl.Gk(t.P,s[a+1])-xl.Gk(t.P,s[0]),r[a][2]=xl.Hk(t.P,s[a+1])-xl.Hk(t.P,s[0]);return(l=vf(yl.rlb,X,6,3,15,1))[0]=r[0][1]*r[1][2]-r[0][2]*r[1][1],l[1]=r[0][2]*r[1][0]-r[0][0]*r[1][2],l[2]=r[0][0]*r[1][1]-r[0][1]*r[1][0],(r[2][0]*l[0]+r[2][1]*l[1]+r[2][2]*l[2])/(n.Math.sqrt(r[2][0]*r[2][0]+r[2][1]*r[2][1]+r[2][2]*r[2][2])*n.Math.sqrt(l[0]*l[0]+l[1]*l[1]+l[2]*l[2]))>0?1:2},xl.Ye=function(n){var t,e;for(t=0,Fl.XOb(n.c),e=0;e<n.c.length;e++)(0==e||0!=xl.yg(n.c[e],n.c[e-1]))&&++t,n.d[n.c[e].a]=t;return t},xl.Ze=function(n){var t,e,i,s,r,a,o,l,f,g,u,h;if(!n.v)for(n.v=new Fl.cj,g=0,u=vf(yl.tlb,z,6,n.P.f,15,1),a=vf(yl.tlb,z,6,n.P.f,15,1),l=vf(yl.tlb,z,6,n.P.g,15,1),t=0;t<n.P.f;t++)if(0==u[t]&&(xl.Po(n.P,t)||1==xl.Bn(n.P,t))){for(a[0]=t,o=1,f=0,u[t]=++g,e=vf(yl.Lwb,nn,6,n.P.g,16,1),r=0;r<o;r++)for(h=0;h<xl.Ln(n.P,a[r]);h++)s=xl.Mn(n.P,a[r],h),(xl.Qo(n.P,s)||2==xl.Vk(n.P,s)||xl.Eo(n.P,s))&&(i=xl.Kn(n.P,a[r],h),e[s]||(l[f++]=s,e[s]=!0),0==u[i]&&(a[o++]=i,u[i]=g));Fl.Ki(n.v,new xl.Fg(a,o,l,f))}},xl.$e=function(n){var t;for(n.Q=vf(yl.Lwb,nn,6,n.P.f,16,1),t=0;t<n.P.f;t++)if(7==xl.Ik(n.P,t)){if(4==xl.Ln(n.P,t)){n.Q[t]=!0;continue}if(3==xl.Ln(n.P,t)){if(3==xl.Fn(n.P,t)){n.Q[t]=!0;continue}if(1==xl.rk(n.P,t)){n.Q[t]=!0;continue}if(xl.Jo(n.P,t,!0))continue;if(0!=(32&n.O)){n.Q[t]=!0;continue}if(xl.Oo(n.P,t)){n.Q[t]=!0;continue}}}},xl._e=function(n,t){var e,i,s,r;for(s=!1,i=0;i<n.P.g;i++)xl.Qe(n,i,1)&&(n.o[i]=n.J,t&&xl.pf(n,i),s=!0);for(r=!1,e=0;e<n.P.f;e++)xl.Ve(n,e,1)&&(n.gb[e]=n.J,t&&xl.qf(n,e),r=!0);return r&&(n.J=!n.J),s||r},xl.af=function(n){var t,e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,I;for(j=vf(yl.Lwb,nn,6,n.P.f,16,1),m=vf(yl.Lwb,nn,6,n.P.g,16,1),t=0,C=!1,0!=(128&n.O)&&(n.W=vf(yl.tlb,z,6,n.P.f,15,1),n.V=vf(yl.tlb,z,6,n.P.g,15,1)),i=0;i<n.P.f;i++)n.U[i]&&(n.db[i]||xl.Ve(n,i,1)&&(n.db[i]=!0,j[i]=!0,++t));for(r=0;r<n.P.g;r++)n.T[r]&&(n.n[r]||xl.Qe(n,r,1)&&(n.n[r]=!0,m[r]=!0,++t));if(1==t){for(e=0;e<n.P.f;e++)if(j[e]){n.bb[e]=0;break}for(s=0;s<n.P.g;s++)if(m[s]){n.k[s]=0;break}}else if(t>1)for(xl.Ze(n),n.R=0,o=new Fl.zOb(n.v);o.a<o.c.a.length;){for(a=Fl.yOb(o),A=0,T=0,g=0,f=0,u=-1,l=-1,c=0;c<a.a.length;c++)j[a.a[c]]&&(++A,1!=n.bb[a.a[c]]&&2!=n.bb[a.a[c]]||(++T,C=!0,u<n.d[a.a[c]]&&(u=n.d[a.a[c]],g=a.a[c])));for(b=0;b<a.b.length;b++)m[a.b[b]]&&(++A,h=(p=n.d[xl.Nk(n.P,0,a.b[b])])>(I=n.d[xl.Nk(n.P,1,a.b[b])])?(p<<16)+I:(I<<16)+p,1!=n.k[a.b[b]]&&2!=n.k[a.b[b]]||(++T,C=!0,l<h&&(l=h,f=a.b[b])));if(0!=A)if(1==A){for(D=0;D<a.a.length;D++)j[a.a[D]]&&(n.bb[a.a[D]]=0);for(d=0;d<a.b.length;d++)m[a.b[d]]&&(n.k[a.b[d]]=0)}else if(1==T){for(D=0;D<a.a.length;D++)j[a.a[D]]&&(n.bb[a.a[D]]=3);for(d=0;d<a.b.length;d++)m[a.b[d]]&&(n.k[a.b[d]]=3)}else{if(0!=(128&n.O)){for(++n.R,D=0;D<a.a.length;D++)j[a.a[D]]&&(n.W[a.a[D]]=n.R);for(d=0;d<a.b.length;d++)m[a.b[d]]&&(n.V[a.b[d]]=n.R)}if(H=!1,-1!=u?2==n.bb[g]&&(H=!0):2==n.k[f]&&(H=!0),H){for(D=0;D<a.a.length;D++)if(j[a.a[D]])switch(n.bb[a.a[D]]){case 1:n.bb[a.a[D]]=2;break;case 2:n.bb[a.a[D]]=1}for(d=0;d<a.b.length;d++)if(m[a.b[d]])switch(n.k[a.b[d]]){case 1:n.k[a.b[d]]=2;break;case 2:n.k[a.b[d]]=1}}}}return C},xl.bf=function(n,t){var e,i,s,r,a,o,l,f,g,u,h;for(r=Yf(yl.tlb,[ot,z],[8,6],15,[2,32],2),a=0;a<2;a++){for(e=vf(yl.tlb,ot,8,32,0,2),h=0,s=0;s<32;s++)if(null!=t[a][s]){for(g=t[a][s].length,e[s]=vf(yl.tlb,z,6,g,15,1),o=0;o<g;o++)e[s][o]=n.d[t[a][s][o]];kl.nTb(e[s],kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[]))),++h}for(u=h;u>0;u--){for(f=0,l=null,i=0;i<32;i++)if(null!=e[i])if(null==l||l.length<e[i].length)l=e[i],f=i;else if(l.length==e[i].length)for(o=l.length-1;o>=0;o--)if(l[o]<e[i][o]){l=e[i],f=i;break}r[a][f]=u,e[f]=null}}return r},xl.cf=function(t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A;if(h=!1,t.P.K)for(g=0;g<t.P.g;g++)if(0!=xl.Xk(t.P,g)){h=!0;break}for(t.M=2,i=0;i<t.P.f;i++)t.M=n.Math.max(t.M,xl.Ln(t.P,i)+xl.bo(t.P,i));for(f=n.Math.max(2,h?(62+t.b+t.M*(t.b+23))/63|0:(62+t.b+t.M*(t.b+5))/63|0),t.d=vf(yl.tlb,z,6,t.P.q,15,1),t.c=vf(yl.Flb,lt,160,t.P.f,0,1),s=0;s<t.P.f;s++)t.c[s]=new xl.Ag(f);for(l=!1,r=0;r<t.P.f;r++)xl.zg(t.c[r],r),Rg(Cg(xl.Dk(t.P,r),1),0)||null!=xl.yk(t.P,r)?xl.wg(t.c[r],8,6):xl.wg(t.c[r],8,Mg(xl.Ik(t.P,r))),xl.wg(t.c[r],8,Mg(xl.Bk(t.P,r))),xl.wg(t.c[r],2,Mg(xl.Bn(t.P,r))),xl.wg(t.c[r],4,Mg(xl.Ln(t.P,r)+xl.bo(t.P,r))),Rg(Cg(xl.Dk(t.P,r),1),0)?xl.wg(t.c[r],4,8):xl.wg(t.c[r],4,Mg(8+xl.rk(t.P,r))),xl.wg(t.c[r],5,Mg(n.Math.min(31,xl.Fn(t.P,r)))),xl.wg(t.c[r],4,Mg(xl.Te(t,r)+1)),xl.wg(t.c[r],2,Mg(xl.Ek(t.P,r)>>4)),t.P.K&&(xl.wg(t.c[r],46,xl.Dk(t.P,r)),null!=xl.yk(t.P,r)&&(l=!0));if(t.S=xl.gf(t),t.S<t.P.f){for(e=0;e<t.P.f;e++){for(xl.zg(t.c[e],e),xl.wg(t.c[e],t.b,Mg(t.d[e])),d=vf(yl.tlb,z,6,xl.Ln(t.P,e),15,1),b=0;b<xl.Ln(t.P,e);b++)d[b]=t.d[xl.Kn(t.P,e,b)]<<5,d[b]|=n.Math.min(31,xl.Jn(t.P,xl.Mn(t.P,e,b)));for(kl.nTb(d,kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[]))),D=t.M;D>d.length;D--)xl.wg(t.c[e],t.b+5,0);for(c=d.length-1;c>=0;c--)xl.wg(t.c[e],t.b+5,yl.$wb(d[c]))}t.S=xl.gf(t)}if(l&&t.S<t.P.f){for(e=0;e<t.P.f;e++){for(xl.zg(t.c[e],e),xl.wg(t.c[e],t.b,Mg(t.d[e])),m=null==(o=xl.yk(t.P,e))?0:n.Math.min(12,o.length),b=12;b>m;b--)xl.wg(t.c[e],8,0);for(c=m-1;c>=0;c--)xl.wg(t.c[e],8,yl.$wb(o[c]))}t.S=xl.gf(t)}if(h&&t.S<t.P.f){for(e=0;e<t.P.f;e++){for(xl.zg(t.c[e],e),xl.wg(t.c[e],t.b,Mg(t.d[e])),u=vf(yl.ulb,st,6,xl.Ln(t.P,e)+xl.bo(t.P,e),14,1),H=0,b=0;b<xl.xn(t.P,e);b++)(b<xl.Ln(t.P,e)||b>=xl.wn(t.P,e))&&(u[H]=Mg(t.d[xl.Kn(t.P,e,b)]),u[H]=xg(u[H],23),u[H]=Eg(u[H],Mg(xl.Xk(t.P,xl.Mn(t.P,e,b)))),++H);for(kl.nTb(u,kl.TTb(Qf(Fl.cPb.prototype.$d,Fl.cPb,[]))),D=t.M;D>u.length;D--)xl.wg(t.c[e],t.b+23,0);for(c=u.length-1;c>=0;c--)xl.wg(t.c[e],t.b+23,u[c])}t.S=xl.gf(t)}if(0!=(8&t.O)&&t.S<t.P.f){for(j=new xl.fu,a=0;a<t.P.f;a++)null!=xl.tk(t.P,a)&&xl.du(j,xl.tk(t.P,a));for(e=0;e<t.P.f;e++)A=null==xl.tk(t.P,e)?0:1+xl.eu(j,xl.tk(t.P,e)),xl.zg(t.c[e],e),xl.wg(t.c[e],t.b,Mg(t.d[e])),xl.wg(t.c[e],t.b,yl.$wb(A));t.S=xl.gf(t)}if(0!=(16&t.O)&&t.S<t.P.f){for(e=0;e<t.P.f;e++)xl.zg(t.c[e],e),xl.wg(t.c[e],t.b,Mg(t.d[e])),xl.wg(t.c[e],1,Mg(xl.Cl(t.P,e)?1:0));t.S=xl.gf(t)}0!=(512&t.O)&&t.P.K&&xl.He(t)},xl.df=function(n){var t,e,i,s,r,a,o,l,f;for(e=0;e<n.P.f;e++)xl.zg(n.c[e],e),xl.wg(n.c[e],2*n.b+4,xg(Mg(n.d[e]),n.b+4));for(l=1;l<=n.S;l++){for(s=!1,i=0;i<n.P.f;i++)n.d[i]==l&&(s|=xl.Ve(n,i,2));if(s){if(o=n.S,n.S=xl.gf(n),n.S!=o)return!0;for(t=0;t<n.P.f;t++)xl.zg(n.c[t],t),xl.wg(n.c[t],2*n.b+4,xg(Mg(n.d[t]),n.b+4))}}for(f=vf(yl.Glb,lt,212,n.P.g,0,1),a=0;a<f.length;a++)f[a]=new xl.Dg(n.d[xl.Nk(n.P,0,a)],n.d[xl.Nk(n.P,1,a)],a);for(Fl.VOb(f,0,f.length,null),r=0;r<f.length;r++)if(xl.Qe(n,f[r].a,2)){for(;r+1<f.length&&0==xl.Cg(f[r],f[r+1]);)xl.Qe(n,f[++r].a,2);if(o=n.S,n.S=xl.gf(n),n.S!=o)return!0;for(t=0;t<n.P.f;t++)xl.zg(n.c[t],t),xl.wg(n.c[t],2*n.b+4,xg(Mg(n.d[t]),n.b+4))}return!1},xl.ef=function(n){var t,e,i,s,r,a,o,l,f,g;for(r=0,e=0;e<n.P.f;e++)0!=n._[e]&&(2!=n._[e]||0==(256&n.O))&&++r;if(0!=r){for(g=vf(yl.tlb,z,6,r,15,1),r=0,i=0;i<n.P.f;i++)0==n._[i]||2==n._[i]&&0!=(256&n.O)||(g[r]=n._[i]<<29|n.$[i]<<24|n.d[i]<<12|i,++r);for(kl.nTb(g,kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[]))),a=0,f=0,o=g[0]&_n;;)if(++f==g.length||o!=(g[f]&_n)){for(s=vf(yl.tlb,z,6,f-a,15,1),l=a;l<f;l++)t=4095&g[l],s[l-a]=t,n.eb[t]=!0;if(Fl.Ki(n.fb,s),f==g.length)break;o=g[f]&_n,a=f}}},xl.ff=function(n){var t,e,i,s,r,a,o,l,f,g,u,h,d;for(o=!1,l=0;l<n.fb.a.length;l++){for(a=Fl.Pi(n.fb,l),t=!0,d=-1,f=!1,u=0;u<a.length;u++){if(e=a[u],0==n.bb[e]){t=!1;break}if(3!=n.bb[e]){for(g=!0,h=0;h<a.length;h++)if(h!=u&&n.d[e]==n.d[a[h]]){g=!1;break}g&&d<n.d[e]&&(d=n.d[e],f=1==n.bb[e])}}if(t&&-1!=d){for(s=0,r=(i=a).length;s<r;++s)e=i[s],(1==n.bb[e]||2==n.bb[e])&&(n.cb[e]=f),n.eb[e]=!1;Fl.Xi(n.fb,a),o=!0,--l}}return o},xl.gf=function(n){var t,e;t=xl.Ye(n);do{e=t,xl.Ue(n),t=xl.Ye(n)}while(e!=t);return t},xl.hf=function(n){for(0!=(1&n.O)&&0==(2&n.O)&&(n.e=Fl.FOb(n.d,n.P.f)),0==(n.O&zn)&&(n.U=vf(yl.Lwb,nn,6,n.P.f,16,1),n.T=vf(yl.Lwb,nn,6,n.P.g,16,1),n.S<n.P.f&&(xl.Ie(n),0==(n.O&zn)&&(xl.ff(n),n.N&&xl.Pg(n.N,n.d)))),null==n.e&&0!=(1&n.O)&&0!=(2&n.O)&&(n.e=Fl.FOb(n.d,n.P.f));n.S<n.P.f;)xl.Je(n),0==(n.O&zn)&&(xl.ff(n),n.N&&xl.Pg(n.N,n.d));0==(n.O&zn)&&(xl.ff(n),xl.af(n),xl.Gf(n))},xl.jf=function(n){var t,e,i,s,r;for(r=n.S,s=Fl.FOb(n.d,n.P.f),n.P.K||(xl.lf(n),xl.Yf(n,r,s)),n._=vf(yl.plb,ft,6,n.P.f,15,1),n.$=vf(yl.plb,ft,6,n.P.f,15,1),e=0;e<n.P.f;e++)n._[e]=xl.wk(n.P,e)<<24>>24,n.$[e]=xl.vk(n.P,e)<<24>>24;for(n.j=vf(yl.plb,ft,6,n.P.g,15,1),n.i=vf(yl.plb,ft,6,n.P.g,15,1),i=0;i<n.P.g;i++)n.j[i]=xl.Sk(n.P,i)<<24>>24,n.i[i]=xl.Rk(n.P,i)<<24>>24;for(xl.kf(n),n.X=!1,n.K=vf(yl.Lwb,nn,6,n.P.f,16,1),t=0;t<n.P.f;t++)0!=n.bb[t]&&(n.K[t]=!0,n.X=!0);xl.nf(n),n.N=null,n.ab=vf(yl.Lwb,nn,6,n.P.f,16,1),n.X&&(n.N=new xl.Vg(n.P,s,n.K,n.bb,n.k,n._,n.$,n.gb,n.o,n.ab),xl.Qg(n.N)),n.cb=vf(yl.Lwb,nn,6,n.P.f,16,1),n.eb=vf(yl.Lwb,nn,6,n.P.f,16,1),n.fb=new Fl.cj,n.N&&xl.Pg(n.N,n.d),xl.ef(n),xl.Yf(n,r,s),xl.mf(n),n.N&&(n.I=xl.Mg(n.N)),xl.xf(n)},xl.kf=function(n){var t,e,i,s,r,a;for(n.J=!0,r=xl._e(n,!1);n.S<n.P.f&&r;){for(t=0;t<n.P.f;t++)xl.zg(n.c[t],t),xl.wg(n.c[t],n.b,Mg(n.d[t])),a=n.bb[t]<<7,1!=n.bb[t]&&2!=n.bb[t]||0==n._[t]||(a|=n._[t]<<5,a|=n.$[t]),xl.wg(n.c[t],18,yl.$wb(a<<9));for(e=0;e<n.P.g;e++)i=n.k[e]<<7,1!=n.k[e]&&2!=n.k[e]||1!=xl.Yk(n.P,e)||0==n.j[e]||(i|=n.j[e]<<5,i|=n.i[e]),xl.xg(n.c[xl.Nk(n.P,0,e)],yl.$wb(i)),xl.xg(n.c[xl.Nk(n.P,1,e)],yl.$wb(i));if(s=xl.gf(n),n.S==s)break;n.S=s,r=xl._e(n,!1)}},xl.lf=function(n){var t,e,i,s;for(n.J=!0,n.Y=vf(yl.plb,ft,6,n.P.f,15,1),n.f=vf(yl.plb,ft,6,n.P.g,15,1),s=xl._e(n,!0);n.S<n.P.f&&s;){for(t=0;t<n.P.f;t++)xl.zg(n.c[t],t),xl.wg(n.c[t],n.b+4,Mg(n.d[t]<<4|n.bb[t]<<2));for(e=0;e<n.P.g;e++)xl.xg(n.c[xl.Nk(n.P,0,e)],Mg(n.k[e])),xl.xg(n.c[xl.Nk(n.P,1,e)],Mg(n.k[e]));if(i=xl.gf(n),n.S==i)break;n.S=i,s=xl._e(n,!0)}},xl.mf=function(n){var t,e,i,s,r,a,o;for(n.J=!0,i=xl.wf(n),n.N&&xl.Pg(n.N,n.d)&&(i=xl.wf(n)),xl._e(n,!1)&&xl.ff(n),a=!0;n.S<n.P.f&&a;){for(s=xl.bf(n,i),t=0;t<n.P.f;t++)xl.zg(n.c[t],t),xl.wg(n.c[t],n.b,Mg(n.d[t])),xl.wg(n.c[t],20,0),!n.ab[t]&&0!=n._[t]&&xl.xg(n.c[t],Mg((n._[t]<<18)+(s[1==n._[t]?0:1][n.$[t]]<<8))),o=n.bb[t],n.cb[t]&&(1==o?o=2:2==o&&(o=1)),xl.xg(n.c[t],yl.$wb(o<<4));for(e=0;e<n.P.g;e++)xl.xg(n.c[xl.Nk(n.P,0,e)],Mg(n.k[e])),xl.xg(n.c[xl.Nk(n.P,1,e)],Mg(n.k[e]));if(r=xl.gf(n),n.S==r)break;n.S=r,a=!1,n.N&&xl.Pg(n.N,n.d)&&(a=!0,i=xl.wf(n)),xl._e(n,!1)&&(a=!0,xl.ff(n))}},xl.nf=function(n){var t,e;for(t=0;t<n.P.f;t++)(!n.K[t]||3==n.bb[t])&&(n._[t]=0);for(e=0;e<n.P.g;e++)(1!=xl.Yk(n.P,e)||0==n.k[e]||3==n.k[e])&&(n.j[e]=0)},xl.of=function(n,t,e){null==n.a&&(n.a=vf(yl.plb,ft,6,n.P.f,15,1),Fl.IOb(n.a)),n.a[t]=e<<24>>24},xl.pf=function(n,t){var e,i,s,r,a,o;if((1==n.k[t]||2==n.k[t])&&!xl.To(n.P,t)){a=!1;try{for(r=0;r<2;r++)if(e=xl.Nk(n.P,r,t),3==xl.Ln(n.P,e)){for(i=vf(yl.tlb,z,6,2,15,1),s=0,o=0;o<xl.Ln(n.P,e);o++)xl.Mn(n.P,e,o)!=t&&(i[s++]=xl.Kn(n.P,e,o));n.d[i[0]]>n.d[i[1]]^xl.rf(n,e,i[0],i[1])&&(a=!a)}}catch(e){if(_f(e=ag(e),18))return void(n.f[t]=3);throw og(e)}1==n.k[t]^a?n.f[t]=1:n.f[t]=2}},xl.qf=function(n,t){var e,i,s,r,a,o,l;if(1==n.bb[t]||2==n.bb[t]){if(o=!1,2==xl.Bn(n.P,t)&&2==xl.Ln(n.P,t))try{for(a=0;a<2;a++)if(e=xl.Kn(n.P,t,a),3==xl.Ln(n.P,e)){for(s=vf(yl.tlb,z,6,2,15,1),r=0,l=0;l<xl.Ln(n.P,e);l++)1==xl.Nn(n.P,e,l)&&(s[r++]=xl.Kn(n.P,e,l));n.d[s[0]]>n.d[s[1]]^xl.rf(n,e,s[0],s[1])&&(o=!o)}}catch(e){if(_f(e=ag(e),18))return void(n.Y[t]=3);throw og(e)}else{try{i=xl.tf(n,t)}catch(e){if(_f(e=ag(e),18))return void(n.Y[t]=3);throw og(e)}for(a=1;a<i.length;a++)for(l=0;l<a;l++)n.d[i[a]]<n.d[i[l]]&&(o=!o)}1==n.bb[t]^o?n.Y[t]=1:n.Y[t]=2}},xl.rf=function(n,t,e,i){var s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,I,P,M,N,w,L,U,y;if(xl.Ik(n.P,e)!=xl.Ik(n.P,i))return xl.Ik(n.P,e)>xl.Ik(n.P,i);if(xl.Bk(n.P,e)!=xl.Bk(n.P,i))return(xl.zl(n.P,e)?(xl.Kj(),xl.Ij)[xl.Ik(n.P,e)]:xl.Bk(n.P,e))>(xl.zl(n.P,i)?(xl.Kj(),xl.Ij)[xl.Ik(n.P,i)]:xl.Bk(n.P,i));for(T=n.P.f,j=vf(yl.tlb,z,6,T,15,1),A=vf(yl.tlb,z,6,T,15,1),C=vf(yl.tlb,z,6,T,15,1),m=vf(yl.Lwb,nn,6,T,16,1),l=vf(yl.Lwb,nn,6,n.P.q,16,1),j[0]=t,j[1]=e,j[2]=i,A[0]=-1,A[1]=0,A[2]=0,l[t]=!0,l[e]=!0,l[i]=!0,h=1,p=2,(w=vf(yl.tlb,z,6,64,15,1))[1]=1,w[2]=3,c=2;h<=p;){for(;h<w[c];){if(d=j[h],!m[h]){for(b=0,D=0,P=0;P<xl.Ln(n.P,d);P++){if(g=xl.Kn(n.P,d,P),p+xl.Nn(n.P,d,P)+1>=T&&(T+=n.P.f,j=xl.ag(j,T),A=xl.ag(A,T),C=xl.ag(C,T),m=xl.bg(m,T)),xl.Ho(n.P,xl.Mn(n.P,d,P)))++b,D+=xl.Ik(n.P,g);else if(g!=t)for(N=1;N<xl.Nn(n.P,d,P);N++)j[++p]=g,A[p]=h,m[p]=!0;if(g!=j[U=A[h]]){if(o=!1,l[g])for(L=A[U];-1!=L;){if(g==j[L]){o=!0;break}L=A[L]}o?(j[++p]=g,A[p]=h,m[p]=!0):(j[++p]=g,A[p]=h,l[g]=!0)}}0!=b&&(C[++p]=(D<<2)/b|0,A[p]=h,m[p]=!0)}if(++h==R)throw og(new Jl.Xz("Emergency break in while loop."))}for(w.length==c+1&&(w=xl.ag(w,w.length+64)),w[c+1]=p+1,I=w[c];I<w[c+1];I++)0==C[I]&&(C[I]=(151==xl.Ik(n.P,j[I])||152==xl.Ik(n.P,j[I])?1:xl.Ik(n.P,j[I]))<<2),C[I]+=C[A[I]]<<16;if(xl.vf(n,m,C,A,j,w,c),C[1]!=C[2])return C[1]>C[2];c>1&&xl.sf(C,A,w,c),++c}for(u=vf(yl.tlb,z,6,n.P.f,15,1),M=!1,r=0;r<n.P.f;r++)if(l[r]&&!xl.zl(n.P,r)){M=!0;break}if(M){for(a=0;a<n.P.f;a++)u[a]=xl.zl(n.P,a)?(xl.Kj(),xl.Ij)[xl.Ik(n.P,a)]:xl.Bk(n.P,a);if(xl.uf(n,m,C,A,j,u,w,c))return C[1]>C[2]}for(Fl.OOb(u,u.length,0),H=!1,f=0;f<n.P.g;f++)(l[xl.Nk(n.P,0,f)]||l[xl.Nk(n.P,1,f)])&&(1==n.f[f]?(u[xl.Nk(n.P,0,f)]=1,u[xl.Nk(n.P,1,f)]=1,H=!0):2==n.f[f]&&(u[xl.Nk(n.P,0,f)]=2,u[xl.Nk(n.P,1,f)]=2,H=!0));if(H&&xl.uf(n,m,C,A,j,u,w,c))return C[1]>C[2];for(Fl.OOb(u,u.length,0),y=!1,s=0;s<n.P.f;s++)l[s]&&(2==n.Y[s]?(u[s]=1,y=!0):1==n.Y[s]&&(u[s]=2,y=!0));if(y&&xl.uf(n,m,C,A,j,u,w,c))return C[1]>C[2];throw og(new Jl.Xz("no distinction applying CIP rules"))},xl.sf=function(n,t,e,i){var s,r,a,o,l,f,g,u,h;for(u=e[i],a=e[i+1]-u,h=vf(yl.Dlb,w,214,a,0,1),l=0;l<a;l++)h[l]=new xl.vg,h[l].c=n[l+u],h[l].b=t[l+u],h[l].a=l+u;for(s=new xl.sg,g=i;g>1;g--){for(f=0;f<a;f++)h[f].c+=n[h[f].b]<<16,h[f].b=t[h[f].b];for(Fl.VOb(h,0,h.length,s),r=1,o=0;o<a;o++)n[h[o].a]=r,o!=a-1&&0!=xl.rg(h[o],h[o+1])&&++r}},xl.tf=function(n,t){var e,i,s,r,a,o,l;for(a=xl.wn(n.P,t),o=vf(yl.tlb,z,6,a,15,1),s=0;s<a;s++)o[s]=xl.Kn(n.P,t,s);for(i=a;i>1;i--){for(e=!1,r=1;r<i;r++)xl.rf(n,t,o[r-1],o[r])&&(e=!0,l=o[r-1],o[r-1]=o[r],o[r]=l);if(!e)break}return o},xl.uf=function(n,t,e,i,s,r,a,o){var l,f;for(f=1;f<o;f++){for(l=a[f];l<a[f+1];l++)e[l]=r[s[l]]+(e[i[l]]<<8);if(xl.vf(n,t,e,i,s,a,f),e[1]!=e[2])return!0;f>1&&xl.sf(e,i,a,f)}return!1},xl.vf=function(n,t,e,i,s,r,a){var o,l,f,g,u,h,d,c,b,D,H;for(u=a;u>1;u--){for(b=r[u]-r[u-1],H=vf(yl.Blb,w,213,b,0,1),o=r[u],c=0;c<b;c++){for(D=r[u-1]+c,h=o;h<r[u+1]&&i[h]==D;)++h;for(H[c]=new xl.pg,H[c].c=D,H[c].d=e[D],H[c].b=t[D]?0:xl.lo(n.P,s[D]),H[c].a=vf(yl.tlb,z,6,h-o,15,1),g=o;g<h;g++)H[c].a[g-o]=e[g];kl.nTb(H[c].a,kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[]))),o=h}for(l=new xl.mg,Fl.VOb(H,0,H.length,l),f=1,d=0;d<b;d++)e[H[d].c]=f,d!=b-1&&0!=xl.lg(H[d],H[d+1])&&++f}},xl.wf=function(n){var t,e;for(e=Yf(yl.tlb,[j,ot],[41,8],0,[2,32],2),t=0;t<n.P.f;t++)n.K[t]&&(1==n._[t]?e[0][n.$[t]]=xl.Wg(e[0][n.$[t]],t):2==n._[t]&&(e[1][n.$[t]]=xl.Wg(e[0][n.$[t]],t)));return e},xl.xf=function(n){var t,e,i,s,r,a,o,l,f,g,u,h;for(r=0,g=0,a=0,o=0,l=0,f=0,u=0,h=!1,t=vf(yl.Lwb,nn,6,32,16,1),e=0;e<n.P.f;e++)0!=n.bb[e]&&(++r,3==n.bb[e]?++g:0==n._[e]?(++a,n.N&&xl.Lg(n.N,e)&&++o):2==n._[e]?0==n.$[e]&&++f:1==n._[e]&&(t[s=n.$[e]]||(++u,t[s]=!0),0==n.$[e]&&++l,n.N&&xl.Lg(n.N,e)&&(h=!0)));for(i=0;i<n.P.g;i++)0!=n.k[i]&&1==xl.Yk(n.P,i)&&(++r,3==n.k[i]?++g:0==n.j[i]?(++a,n.N&&xl.Lg(n.N,xl.Nk(n.P,0,i))&&xl.Lg(n.N,xl.Nk(n.P,1,i))&&++o):2==n.j[i]?0==n.i[i]&&++f:1==n.j[i]&&(t[s=n.i[i]]||(++u,t[s]=!0),0==n.i[i]&&++l,n.N&&xl.Lg(n.N,xl.Nk(n.P,0,i))&&xl.Lg(n.N,xl.Nk(n.P,1,i))&&(h=!0)));0!=r?0==g?n.I?xl.zm(n.P,gt+(1<<u)):l+o!=r||h?a==r?xl.zm(n.P,Wn):f==r?xl.zm(n.P,327680):a==r-1&&1==l?xl.zm(n.P,Mn):xl.zm(n.P,458752+(1<<u)):xl.zm(n.P,ut):xl.zm(n.P,0):xl.zm(n.P,J)},xl.yf=function(n,t,e){for(;0!=e;)0==n.r&&((!n.p||63!=n.t)&&(n.t+=64),Jl.jIb(n.s,n.t&B),n.r=6,n.t=0),n.t<<=1,n.t=zg(Eg(Mg(n.t),Cg(t,1))),t=Fg(t,1),--e,--n.r},xl.zf=function(n){return n.t<<=n.r,(!n.p||63!=n.t)&&(n.t+=64),Jl.jIb(n.s,n.t&B),n.s.a},xl.Af=function(n,t){n.s=new Jl.qIb,n.r=6,n.t=0,n.p=t},xl.Bf=function(t,e,i){var s,r,a,o,l,f,g,u,h,d,c,b,D,H;if(0!=t.P.f){if(h=!1,t.hb&&t.P.q>t.P.f&&!t.P.K)for(h=!0,f=0;f<t.P.f;f++)if(0!=xl.$n(t.P,f)){h=!1;break}for(H=t.hb?16:8,xl.Af(t,!0),Jl.jIb(t.s,h?35:33),xl.yf(t,Mg(t.hb?1:0),1),xl.yf(t,yl.$wb(e?1:0),1),xl.yf(t,yl.$wb(H/2|0),4),b=0,g=1;g<t.P.f;g++)b=xl.Of(t,t.w[g],-1==t.C[g]?-1:t.w[t.C[g]],b,i);if(h)for(f=0;f<t.P.f;f++)for(s=t.w[f],c=xl.Ln(t.P,s);c<xl.wn(t.P,s);c++)b=xl.Of(t,xl.Kn(t.P,s,c),s,b,i);if(t.P.f>1&&0==b)t.q="";else{for(D=b+(d=b/((o=1<<H)/2-1))/2,u=1;u<t.P.f;u++)xl.Cf(t,t.w[u],-1==t.C[u]?-1:t.w[t.C[u]],D,d,H,i);if(h)for(l=0;l<t.P.f;l++)for(s=t.w[l],c=xl.Ln(t.P,s);c<xl.wn(t.P,s);c++)xl.Cf(t,xl.Kn(t.P,s,c),s,D,d,H,i);e&&(a=t.hb?1.5:(xl.Kj(),xl.Kj(),xl.Jj),r=xl.Lk(t.P,h?t.P.q:t.P.f,h?t.P.r:t.P.g,a,i),xl.yf(t,Mg(n.Math.min(o-1,n.Math.max(0,rg(.5+n.Math.log(r/.1)*n.Math.LOG10E/(n.Math.log(2e3)*n.Math.LOG10E)*(o-1))))),H),xl.yf(t,Mg(xl.Ff(i[t.w[0]].a/r,o)),H),xl.yf(t,Mg(xl.Ff(i[t.w[0]].b/r,o)),H),t.hb&&xl.yf(t,Mg(xl.Ff(i[t.w[0]].c/r,o)),H)),t.q=xl.zf(t)}}else t.q=""},xl.Cf=function(n,t,e,i,s,r,a){var o,l,f;o=-1==e?(a[t].a-a[n.w[0]].a)/8:a[t].a-a[e].a,l=-1==e?(a[t].b-a[n.w[0]].b)/8:a[t].b-a[e].b,xl.yf(n,Mg(rg((i+o)/s)),r),xl.yf(n,Mg(rg((i+l)/s)),r),n.hb&&(f=-1==e?(a[t].c-a[n.w[0]].c)/8:a[t].c-a[e].c,xl.yf(n,Mg(rg((i+f)/s)),r))},xl.Df=function(n,t){var e;for(e=0;e<n.u;e++)t-=16;for(t<0&&(Jl.vIb(),String.fromCharCode(10));t>15;)xl.yf(n,1,1),xl.yf(n,15,4),t-=16,++n.u;xl.yf(n,1,1),xl.yf(n,yl.$wb(t),4)},xl.Ef=function(n){var t,e,i,s,r,a;if(0!=n.P.f){for(r=0,i=!1,s=!1,e=0;e<n.P.f;e++)r<xl.Ak(n.P,e)&&(r=xl.Ak(n.P,e)),xl.ol(n.P,e)?i=!0:s=!0;if(0!=r){for(a=xl.jg(r),xl.Af(n,!0),xl.yf(n,yl.$wb(a),4),xl.yf(n,yl.$wb(i?1:0),1),xl.yf(n,yl.$wb(s?1:0),1),t=0;t<n.P.f;t++)xl.yf(n,Mg(xl.Ak(n.P,n.w[t])),a),i&&s&&xl.yf(n,Mg(xl.ol(n.P,n.w[t])?1:0),1);n.L=xl.zf(n)}else n.L=""}else n.L=""},xl.Ff=function(t,e){var i,s,r,a;return i=e/2|0,r=t<0,t=n.Math.abs(t),a=e/32|0,s=n.Math.min(i-1,zg(Pg(n.Math.round(t*i/(t+a))))),r?i+s:s},xl.Gf=function(n){var t,e,i;for(t=0;t<n.P.f;t++)3==n.bb[t]&&!xl.kl(n.P,t)&&xl.Hm(n.P,t),(1==xl.wk(n.P,t)||2==xl.wk(n.P,t))&&3==n.bb[t]&&xl.Hm(n.P,t),xl.kl(n.P,t)&&3!=n.bb[t]&&!xl.$f(n,t)&&xl.Hm(n.P,t);for(i=0;i<n.P.r;i++)xl.El(n.P,i)&&!xl.Zf(n,i)&&xl.Hm(n.P,xl.Nk(n.P,0,i));for(e=0;e<n.P.g;e++)2==xl.Vk(n.P,e)&&(!xl.ul(n.P,e)||1!=n.k[e]&&2!=n.k[e]||(n.k[e]=3,xl.ym(n.P,e,386)),3!=n.k[e]||n.n[e]||386!=xl.Yk(n.P,e)&&(xl.Hm(n.P,xl.Nk(n.P,0,e)),xl.Hm(n.P,xl.Nk(n.P,1,e)))),1!=xl.Yk(n.P,e)||3!=n.k[e]||xl.kl(n.P,xl.Nk(n.P,0,e))||xl.kl(n.P,xl.Nk(n.P,1,e))||(xl.Hm(n.P,xl.Nk(n.P,0,e)),xl.Hm(n.P,xl.Nk(n.P,1,e))),1!=xl.Sk(n.P,e)&&2!=xl.Sk(n.P,e)||1==xl.Yk(n.P,e)&&(1==n.k[e]||2==n.k[e])||(xl.Hm(n.P,xl.Nk(n.P,0,e)),xl.Hm(n.P,xl.Nk(n.P,1,e)))},xl.Hf=function(n){var t,e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A;if(0!=n.P.f&&!n.D){for(n.G=0,A=0,e=1;e<n.P.f;e++)n.d[e]>n.d[A]&&(A=e);for(i=vf(yl.Lwb,nn,6,n.P.f,16,1),r=vf(yl.Lwb,nn,6,n.P.g,16,1),n.F=vf(yl.tlb,z,6,n.P.f,15,1),n.w=vf(yl.tlb,z,6,n.P.f,15,1),n.C=vf(yl.tlb,z,6,n.P.f,15,1),n.A=vf(yl.tlb,z,6,n.P.g,15,1),n.w[0]=A,n.F[A]=0,i[A]=!0,o=0,l=1,f=0;o<n.P.f;)if(o<l){for(;;){for(d=0,c=0,u=-1,t=n.w[o],b=0;b<xl.xn(n.P,t);b++)(b<xl.Ln(n.P,t)||b>=xl.wn(n.P,t))&&!i[a=xl.Kn(n.P,t,b)]&&n.d[a]>u&&(d=a,c=xl.Mn(n.P,t,b),u=n.d[a]);if(-1==u)break;n.F[d]=l,n.C[l]=o,n.w[l++]=d,n.A[f++]=c,i[d]=!0,r[c]=!0}++o}else{for(h=0,u=-1,t=0;t<n.P.f;t++)!i[t]&&n.d[t]>u&&(h=t,u=n.d[t]);n.F[h]=l,n.C[l]=-1,n.w[l++]=h,i[h]=!0}for(n.B=vf(yl.tlb,z,6,2*(n.P.g-f),15,1);;){for(H=n.P.M,j=n.P.M,m=-1,s=0;s<n.P.g;s++)r[s]||(n.F[xl.Nk(n.P,0,s)]<n.F[xl.Nk(n.P,1,s)]?(D=n.F[xl.Nk(n.P,0,s)],g=n.F[xl.Nk(n.P,1,s)]):(D=n.F[xl.Nk(n.P,1,s)],g=n.F[xl.Nk(n.P,0,s)]),(D<H||D==H&&g<j)&&(H=D,j=g,m=s));if(-1==m)break;r[m]=!0,n.A[f++]=m,n.B[2*n.G]=H,n.B[2*n.G+1]=j,++n.G}n.D=!0}},xl.If=function(n){var t,e,i,s,r,a,o,l,f,g,u,h,d,c;for(l=null,c=xl.no(n.P),u=0;u<c.i.a.length;u++)if(c.e[u]){for(r=0,i=0,s=(e=h=Fl.Pi(c.i,u)).length;i<s;++i)t=e[i],xl.Uf(n,t)&&++r;if(0!=r)if(d=Fl.Pi(c.j,u),null==l&&(l=vf(yl.Lwb,nn,6,n.P.g,16,1)),r==h.length){for(f=-1,g=I,a=0;a<h.length;a++)g>n.w[d[a]]&&(g=n.w[d[a]],f=a);for(;r>0;)l[d[f]]=!0,f=xl.gg(f+2,h.length),r-=2}else{for(o=0;xl.Uf(n,h[o]);)++o;for(;!xl.Uf(n,h[o]);)o=xl.gg(o+1,h.length);for(;r>0;)for(l[d[o]]=!0,o=xl.gg(o+2,h.length),r-=2;!xl.Uf(n,h[o]);)o=xl.gg(o+1,h.length)}}return l},xl.Jf=function(n,t){return n.k[t]},xl.Kf=function(n){return xl.Lf(n,n.hb)},xl.Lf=function(n,t){return null==n.q&&(xl.Hf(n),xl.Bf(n,t,n.P.J)),n.q},xl.Mf=function(n){return null==n.L&&(xl.Hf(n),xl.Ef(n)),n.L},xl.Nf=function(n){return null==n.H&&(xl.Hf(n),0==(n.O&zn)&&(xl.Wf(n),xl.Xf(n,1),xl.Xf(n,2)),xl.Vf(n)),n.H},xl.Of=function(t,e,i,s,r){var a,o,l;return s<(a=-1==i?n.Math.abs(r[e].a-r[t.w[0]].a)/8:n.Math.abs(r[e].a-r[i].a))&&(s=a),s<(o=-1==i?n.Math.abs(r[e].b-r[t.w[0]].b)/8:n.Math.abs(r[e].b-r[i].b))&&(s=o),t.hb&&s<(l=-1==i?n.Math.abs(r[e].c-r[t.w[0]].c)/8:n.Math.abs(r[e].c-r[i].c))&&(s=l),s},xl.Pf=function(n,t){return n.V[t]},xl.Qf=function(n,t){return n.W[t]},xl.Rf=function(n,t){return null==n.e?-1:n.e[t]},xl.Sf=function(n,t){return n.bb[t]},xl.Tf=function(n,t){var e,i,s,r,a,o,l;for(l=xl.no(n.P),e=0;e<l.i.a.length;e++)if(l.d[e]&&xl.Pr(l,e,t)){for(r=0,a=(s=Fl.Pi(l.i,e)).length;r<a;++r)if((i=s[r])!=t)for(o=0;o<xl.Ln(n.P,i);o++)if(xl.Eo(n.P,xl.Mn(n.P,i,o)))return!0;return!1}return!1},xl.Uf=function(n,t){var e,i,s;if(xl.Bn(n.P,t)<2)return!1;if(2==xl.Ln(n.P,t))return!0;for(e=0,s=0;s<xl.Ln(n.P,t);s++)i=xl.Mn(n.P,t,s),xl.Do(n.P,i)&&(e+=xl.Vk(n.P,i)-1);return e>1},xl.Vf=function(t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,I,P,M,N,w,L,U,y,J,B,R,k,E,x,F,Q,X,S,z,G,q,Y,Z;if(xl.Af(t,!1),xl.yf(t,9,4),z=n.Math.max(xl.jg(t.P.f),xl.jg(t.P.g)),xl.yf(t,yl.$wb(z),4),0==z)return xl.yf(t,Mg(t.P.K?1:0),1),xl.yf(t,0,1),void(t.H=xl.zf(t));for(G=Y=q=U=0,f=0;f<t.P.f;f++)if(Ig(Cg(xl.Dk(t.P,f),1),0)){switch(xl.Ik(t.P,f)){case 6:break;case 7:++G;break;case 8:++Y;break;default:++q}0!=xl.rk(t.P,f)&&++U}for(xl.yf(t,Mg(t.P.f),z),xl.yf(t,Mg(t.P.g),z),xl.yf(t,yl.$wb(G),z),xl.yf(t,yl.$wb(Y),z),xl.yf(t,yl.$wb(q),z),xl.yf(t,yl.$wb(U),z),g=0;g<t.P.f;g++)7==xl.Ik(t.P,t.w[g])&&Ig(Cg(xl.Dk(t.P,t.w[g]),1),0)&&xl.yf(t,yl.$wb(g),z);for(d=0;d<t.P.f;d++)8==xl.Ik(t.P,t.w[d])&&Ig(Cg(xl.Dk(t.P,t.w[d]),1),0)&&xl.yf(t,yl.$wb(d),z);for(c=0;c<t.P.f;c++)6!=xl.Ik(t.P,t.w[c])&&7!=xl.Ik(t.P,t.w[c])&&8!=xl.Ik(t.P,t.w[c])&&Ig(Cg(xl.Dk(t.P,t.w[c]),1),0)&&(xl.yf(t,yl.$wb(c),z),xl.yf(t,Mg(xl.Ik(t.P,t.w[c])),8));for(b=0;b<t.P.f;b++)0!=xl.rk(t.P,t.w[b])&&Ig(Cg(xl.Dk(t.P,t.w[b]),1),0)&&(xl.yf(t,yl.$wb(b),z),xl.yf(t,Mg(8+xl.rk(t.P,t.w[b])),4));for(S=0,T=0,D=1;D<t.P.f;D++)-1==t.C[D]?R=0:(R=1+t.C[D]-T,T=t.C[D]),S<R&&(S=R);for(B=xl.jg(S),xl.yf(t,yl.$wb(B),4),T=0,H=1;H<t.P.f;H++)-1==t.C[H]?R=0:(R=1+t.C[H]-T,T=t.C[H]),xl.yf(t,yl.$wb(R),B);for(E=0;E<2*t.G;E++)xl.yf(t,Mg(t.B[E]),z);for(I=0;I<t.P.g;I++)L=0!=(xl.Xk(t.P,t.A[I])&qn)||32==xl.Yk(t.P,t.A[I])?1:xl.Ho(t.P,t.A[I])?0:n.Math.min(3,xl.Vk(t.P,t.A[I])),xl.yf(t,yl.$wb(L),2);if(i=0,0==(t.O&zn))for(j=0;j<t.P.f;j++)0!=t.Z[t.w[j]]&&3!=t.Z[t.w[j]]&&++i;if(xl.yf(t,yl.$wb(i),z),0==(t.O&zn))for(j=0;j<t.P.f;j++)0!=t.Z[t.w[j]]&&3!=t.Z[t.w[j]]&&(xl.yf(t,yl.$wb(j),z),0==t._[t.w[j]]?xl.yf(t,Mg(t.Z[t.w[j]]),3):(Z=1==t.Z[t.w[j]]?1==t._[t.w[j]]?4:6:1==t._[t.w[j]]?5:7,xl.yf(t,yl.$wb(Z),3),xl.yf(t,Mg(t.$[t.w[j]]),3)));if(e=0,0==(t.O&zn))for(P=0;P<t.P.g;P++)0!=t.g[t.A[P]]&&3!=t.g[t.A[P]]&&(!xl.To(t.P,t.A[P])||1==xl.Yk(t.P,t.A[P]))&&++e;if(xl.yf(t,yl.$wb(e),z),0==(t.O&zn))for(P=0;P<t.P.g;P++)0==t.g[t.A[P]]||3==t.g[t.A[P]]||xl.To(t.P,t.A[P])&&1!=xl.Yk(t.P,t.A[P])||(xl.yf(t,yl.$wb(P),z),1==xl.Yk(t.P,t.A[P])?0==t.j[t.A[P]]?xl.yf(t,Mg(t.g[t.A[P]]),3):(Z=1==t.g[t.A[P]]?1==t.j[t.A[P]]?4:6:1==t.j[t.A[P]]?5:7,xl.yf(t,yl.$wb(Z),3),xl.yf(t,Mg(t.i[t.A[P]]),3)):xl.yf(t,Mg(t.g[t.A[P]]),2));for(xl.yf(t,Mg(t.P.K?1:0),1),y=0,m=0;m<t.P.f;m++)0!=xl.Bk(t.P,t.w[m])&&++y;if(0!=y)for(xl.Df(t,1),xl.yf(t,yl.$wb(y),z),j=0;j<t.P.f;j++)0!=xl.Bk(t.P,t.w[j])&&(xl.yf(t,yl.$wb(j),z),xl.yf(t,Mg(xl.Bk(t.P,t.w[j])),8));if(t.u=0,t.P.K){for(xl.Fe(t,0,z,zn,1,-1),xl.Fe(t,3,z,fn,1,-1),xl.Fe(t,4,z,120,4,3),xl.Fe(t,5,z,ht,2,1),xl.Fe(t,6,z,1,1,-1),xl.Fe(t,7,z,dn,4,7),y=0,j=0;j<t.P.f;j++)null!=xl.yk(t.P,t.w[j])&&++y;if(y>0)for(xl.Df(t,8),xl.yf(t,yl.$wb(y),z),A=0;A<t.P.f;A++)if(null!=(C=xl.yk(t.P,t.w[A])))for(xl.yf(t,yl.$wb(A),z),xl.yf(t,Mg(C.length),4),a=0,o=(r=C).length;a<o;++a)s=r[a],xl.yf(t,yl.$wb(s),8);xl.Ge(t,9,z,384,2,7),xl.Ge(t,10,z,31,5,0),xl.Fe(t,11,z,Sn,1,-1),xl.Ge(t,12,z,qn,8,9),xl.Fe(t,13,z,mn,3,14),xl.Fe(t,14,z,An,5,17),xl.Fe(t,16,z,Qn,3,22)}for(y=0,u=0;u<t.P.f;u++)null!=t.a&&-1!=t.a[t.w[u]]&&++y;if(0!=y)for(xl.Df(t,17),xl.yf(t,yl.$wb(y),z),j=0;j<t.P.f;j++)null!=t.a&&-1!=t.a[t.w[j]]&&(xl.yf(t,yl.$wb(j),z),xl.yf(t,Mg(t.a[t.w[j]]),4));if(0!=(8&t.O)||0!=(t.O&cn)){for(y=0,X=0,j=0;j<t.P.f;j++)null!=(F=xl.tk(t.P,t.w[j]))&&(++y,X=n.Math.max(X,kl.TTb(F).length));if(0!=y)for(Q=xl.jg(X),xl.Df(t,18),xl.yf(t,yl.$wb(y),z),xl.yf(t,yl.$wb(Q),4),A=0;A<t.P.f;A++)if(null!=(J=xl.tk(t.P,t.w[A])))for(xl.yf(t,yl.$wb(A),z),xl.yf(t,Mg(kl.TTb(J).length),Q),k=0;k<kl.TTb(J).length;k++)xl.yf(t,(kl.OTb(k,kl.TTb(J).length),Mg(kl.TTb(J).charCodeAt(k))),7)}for(t.P.K&&(xl.Fe(t,19,z,bn,3,25),xl.Ge(t,20,z,Nn,3,17)),y=0,h=0;h<t.P.f;h++)0!=xl.Ek(t.P,t.w[h])&&++y;if(0!=y)for(xl.Df(t,21),xl.yf(t,yl.$wb(y),z),l=0;l<t.P.f;l++)0!=xl.Ek(t.P,t.w[l])&&(xl.yf(t,yl.$wb(l),z),xl.yf(t,Mg(xl.Ek(t.P,t.w[l])>>4),2));if(t.P.K&&(xl.Fe(t,22,z,Xn,1,-1),xl.Ge(t,23,z,dt,1,-1),xl.Ge(t,24,z,Yn,2,21)),0!=(16&t.O))for(l=0;l<t.P.f;l++)if(xl.Cl(t.P,t.w[l])){for(xl.Df(t,25),s=0;s<t.P.f;s++)xl.yf(t,Mg(xl.Cl(t.P,t.w[s])?1:0),1);break}if(null!=(x=xl.If(t))){for(y=0,P=0;P<t.P.g;P++)x[t.A[P]]&&++y;for(xl.Df(t,26),xl.yf(t,yl.$wb(y),z),M=0;M<t.P.g;M++)x[t.A[M]]&&xl.yf(t,yl.$wb(M),z)}for(t.P.K&&xl.Fe(t,27,z,tn,1,-1),y=0,N=0;N<t.P.g;N++)32==xl.Yk(t.P,t.A[N])&&++y;if(0!=y)for(xl.Df(t,28),xl.yf(t,yl.$wb(y),z),P=0;P<t.P.g;P++)32==xl.Yk(t.P,t.A[P])&&xl.yf(t,yl.$wb(P),z);for(t.P.K&&(xl.Fe(t,29,z,ct,2,30),xl.Fe(t,30,z,v,7,32),xl.Fe(t,32,z,bt,2,44),xl.Fe(t,33,z,Ln,5,39),xl.Fe(t,34,z,hn,1,-1),xl.Ge(t,35,z,Dt,1,-1),xl.Ge(t,36,z,96,2,5)),y=0,w=0;w<t.P.g;w++)(8==xl.Yk(t.P,t.A[w])||16==xl.Yk(t.P,t.A[w]))&&++y;if(0!=y)for(xl.Df(t,37),xl.yf(t,yl.$wb(y),z),p=0;p<t.P.g;p++)8!=xl.Yk(t.P,t.A[p])&&16!=xl.Yk(t.P,t.A[p])||(xl.yf(t,yl.$wb(p),z),xl.yf(t,Mg(8==xl.Yk(t.P,t.A[p])?0:1),1));xl.yf(t,0,1),t.H=xl.zf(t)},xl.Wf=function(n){var t,e,i,s,r,a,o,l,f,g,u;for(n.Z=vf(yl.plb,ft,6,n.P.f,15,1),t=0;t<n.P.f;t++)if(1==n.bb[t]||2==n.bb[t]){if(l=n.cb[t],xl.Fo(n.P,t))for(o=0;o<xl.Ln(n.P,t);o++){for(s=xl.Kn(n.P,t,o),u=0,g=vf(yl.tlb,z,6,3,15,1),f=0;f<xl.Ln(n.P,s);f++)g[u]=xl.Kn(n.P,s,f),g[u]!=t&&++u;2==u&&n.d[g[0]]>n.d[g[1]]^n.F[g[0]]<n.F[g[1]]&&(l=!l)}else for(o=1;o<xl.Ln(n.P,t);o++)for(f=0;f<o;f++)r=xl.Kn(n.P,t,o),a=xl.Kn(n.P,t,f),n.d[r]>n.d[a]&&(l=!l),n.F[r]<n.F[a]&&(l=!l);n.Z[t]=1==n.bb[t]^l?1:2}else n.Z[t]=n.bb[t];for(n.g=vf(yl.plb,ft,6,n.P.g,15,1),e=0;e<n.P.g;e++)if(1==n.k[e]||2==n.k[e]){for(l=!1,o=0;o<2;o++)if(i=xl.Nk(n.P,o,e),3==xl.Ln(n.P,i)){for(g=vf(yl.tlb,z,6,2,15,1),u=0,f=0;f<3;f++)xl.Kn(n.P,i,f)!=xl.Nk(n.P,1-o,e)&&(g[u++]=xl.Kn(n.P,i,f));n.d[g[0]]>n.d[g[1]]&&(l=!l),n.F[g[0]]<n.F[g[1]]&&(l=!l)}n.g[e]=1==n.k[e]^l?1:2}else n.g[e]=n.k[e]},xl.Xf=function(t,e){var i,s,r,a,o,l,f,g,u,h,d,c,b;for(f=vf(yl.tlb,z,6,32,15,1),g=0,s=0;s<t.P.f;s++)1!=t.Z[s]&&2!=t.Z[s]||t._[s]!=e||f[l=t.$[s]]<t.d[s]&&(0==f[l]&&++g,f[l]=t.d[s]);for(a=0;a<t.P.g;a++)1!=t.g[a]&&2!=t.g[a]||t.j[a]!=e||1!=xl.Yk(t.P,a)||(l=t.i[a],b=n.Math.max(t.d[xl.Nk(t.P,0,a)],t.d[xl.Nk(t.P,1,a)]),f[l]<b&&(0==f[l]&&++g,f[l]=b));for(o=vf(yl.plb,ft,6,32,15,1),u=0;u<g;u++){for(d=-1,c=0,h=0;h<32;h++)c<f[h]&&(c=f[h],d=h);f[d]=0,o[d]=u<<24>>24}for(i=0;i<t.P.f;i++)(1==t.Z[i]||2==t.Z[i])&&t._[i]==e&&(t.$[i]=o[t.$[i]]);for(r=0;r<t.P.g;r++)(1==t.g[r]||2==t.g[r])&&t.j[r]==e&&1==xl.Yk(t.P,r)&&(t.i[r]=o[t.i[r]])},xl.Yf=function(n,t,e){var i,s;for(n.S=t,i=0;i<n.P.f;i++)n.d[i]=e[i],n.bb[i]=0,n.gb[i]=!1;for(s=0;s<n.P.g;s++)n.k[s]=0,n.o[s]=!1},xl.Zf=function(n,t){var e,i,s;if((e=xl.Nk(n.P,0,t))>=n.P.f)return!1;if(1==n.bb[e]||2==n.bb[e])return!0;if(3==n.bb[e])return!1;if(-1!=(i=xl.sn(n.P,e)))return 1==n.k[i]||2==n.k[i];for(s=0;s<xl.Ln(n.P,e);s++)if(2==xl.Nn(n.P,e,s)&&(1==n.bb[xl.Kn(n.P,e,s)]||2==n.bb[xl.Kn(n.P,e,s)]))return!0;return!1},xl.$f=function(n,t){var e;for(e=0;e<xl.Ln(n.P,t);e++)if(3==n.k[xl.Mn(n.P,t,e)]&&1==xl.Nn(n.P,t,e))return!0;return!1},xl._f=function(n){var t,e,i,s,r,a,o;for(a=vf(yl.tlb,z,6,n.S+1,15,1),e=0;e<n.P.f;e++)0==xl.wk(n.P,e)&&(1==n.bb[e]?++a[n.d[e]]:2==n.bb[e]&&--a[n.d[e]]);for(s=0;s<n.P.g;s++)1==xl.Vk(n.P,s)&&0==xl.Sk(n.P,s)&&(1==n.k[s]?(++a[n.d[xl.Nk(n.P,0,s)]],++a[n.d[xl.Nk(n.P,1,s)]]):2==n.k[s]&&(--a[n.d[xl.Nk(n.P,0,s)]],--a[n.d[xl.Nk(n.P,1,s)]]));for(o=1;o<=n.S;o++)if(0!=a[o]){if(r=a[o]<0){for(t=0;t<n.P.f;t++)0==xl.wk(n.P,t)&&(1==n.bb[t]?n.bb[t]=2:2==n.bb[t]&&(n.bb[t]=1));for(i=0;i<n.P.g;i++)1==xl.Vk(n.P,i)&&0==xl.Sk(n.P,i)&&(1==n.k[i]?n.k[i]=2:2==n.k[i]&&(n.k[i]=1))}return r}return!1},xl.ag=function(n,t){var e;return e=vf(yl.tlb,z,6,t,15,1),Jl.wIb(n,0,e,0,n.length),e},xl.bg=function(n,t){var e;return e=vf(yl.Lwb,nn,6,t,16,1),Jl.wIb(n,0,e,0,n.length),e},xl.cg=function(n){var t,e;if(null!=n.Y)for(t=0;t<n.P.f;t++)xl.Wl(n.P,t,n.Y[t]);if(null!=n.f)for(e=0;e<n.P.g;e++)xl.rm(n.P,e,n.f[e])},xl.dg=function(n){var t,e,i,s,r,a,o,l,f,g,u;for(t=0;t<n.P.f;t++)if(1==n.bb[t]||2==n.bb[t]){if(l=!1,xl.Fo(n.P,t))for(o=0;o<xl.Ln(n.P,t);o++){for(s=xl.Kn(n.P,t,o),u=0,g=vf(yl.tlb,z,6,3,15,1),f=0;f<xl.Ln(n.P,s);f++)g[u]=xl.Kn(n.P,s,f),g[u]!=t&&++u;2==u&&n.d[g[0]]>n.d[g[1]]^g[0]<g[1]&&(l=!l)}else for(o=1;o<xl.Ln(n.P,t);o++)for(f=0;f<o;f++)r=xl.Kn(n.P,t,o),a=xl.Kn(n.P,t,f),n.d[r]>n.d[a]&&(l=!l),r<a&&(l=!l);xl.gm(n.P,t,1==n.bb[t]^l?1:2,n.db[t])}else xl.gm(n.P,t,n.bb[t],n.db[t]);for(e=0;e<n.P.g;e++)if(1==n.k[e]||2==n.k[e]){for(l=!1,o=0;o<2;o++)if(i=xl.Nk(n.P,o,e),3==xl.Ln(n.P,i)){for(g=vf(yl.tlb,z,6,2,15,1),u=0,f=0;f<3;f++)xl.Kn(n.P,i,f)!=xl.Nk(n.P,1-o,e)&&(g[u++]=xl.Kn(n.P,i,f));n.d[g[0]]>n.d[g[1]]&&(l=!l),g[0]<g[1]&&(l=!l)}xl.vm(n.P,e,1==n.k[e]^l?1:2,n.n[e])}else xl.vm(n.P,e,n.k[e],n.n[e])},xl.eg=function(n){var t;for(t=0;t<n.P.f;t++)xl.km(n.P,t,n.K[t])},xl.fg=function(n){var t,e,i;for(t=0;t<n.P.f;t++)!xl.kl(n.P,t)&&3==n.bb[t]&&xl.Zl(n.P,t,!0);for(e=0;e<n.P.g;e++)3==n.k[e]&&(1==(i=xl.Vk(n.P,e))?xl.Zl(n.P,xl.Nk(n.P,0,e),!0):2==i&&xl.ym(n.P,e,386))},xl.gg=function(n,t){return n<t?n:n-t},xl.hg=function(n){xl.ig.call(this,n,0)},xl.ig=function(n,t){this.P=n,this.O=t,xl.iu(this.P,7),this.b=xl.jg(this.P.f),0==(this.O&zn)&&xl.$e(this),this.hb=0!=(64&t)||xl.jl(this.P),0==(this.O&zn)&&(this.bb=vf(yl.plb,ft,6,this.P.f,15,1),this.db=vf(yl.Lwb,nn,6,this.P.f,16,1),this.gb=vf(yl.Lwb,nn,6,this.P.f,16,1),this.k=vf(yl.plb,ft,6,this.P.g,15,1),this.o=vf(yl.Lwb,nn,6,this.P.g,16,1),this.n=vf(yl.Lwb,nn,6,this.P.g,16,1)),xl.cf(this),0==(this.O&zn)&&xl.jf(this),xl.hf(this)},xl.jg=function(n){var t;for(t=0;n>0;)n>>=1,++t;return t},zf(47,1,{},xl.hg,xl.ig),o.b=0,o.p=!1,o.r=0,o.t=0,o.u=0,o.D=!1,o.G=0,o.I=!1,o.J=!1,o.M=0,o.O=0,o.R=0,o.S=0,o.X=!1,o.hb=!1,yl.Llb=lg(47),xl.kg=function(t,e){var i,s,r,a;if(t.d!=e.d)return t.d>e.d?1:-1;for(r=t.a.length,a=e.a.length,i=n.Math.min(r,a),s=0;s<i;s++)if(--r,--a,t.a[r]!=e.a[a])return t.a[r]>e.a[a]?1:-1;return r!=a?r>a?1:-1:t.b!=e.b?t.b>e.b?1:-1:0},xl.lg=function(n,t){return xl.kg(n,t)},xl.mg=function(){},zf(391,1,{},xl.mg),o.Db=function(n,t){return xl.lg(n,t)},o.ib=function(n){return this===n},yl.Clb=lg(391),xl.pg=function(){},zf(213,1,{213:1},xl.pg),o.b=0,o.c=0,o.d=0,yl.Blb=lg(213),xl.qg=function(n,t){return n.c!=t.c?n.c>t.c?1:-1:0},xl.rg=function(n,t){return xl.qg(n,t)},xl.sg=function(){},zf(392,1,{},xl.sg),o.Db=function(n,t){return xl.rg(n,t)},o.ib=function(n){return this===n},yl.Elb=lg(392),xl.vg=function(){},zf(214,1,{214:1},xl.vg),o.a=0,o.b=0,o.c=0,yl.Dlb=lg(214),xl.wg=function(n,t,e){0==n.b&&(++n.c,n.b=63),63==n.b?(n.d[n.c]=Eg(n.d[n.c],e),n.b-=t):n.b>=t?(n.d[n.c]=xg(n.d[n.c],t),n.d[n.c]=Eg(n.d[n.c],e),n.b-=t):(n.d[n.c]=xg(n.d[n.c],n.b),n.d[n.c]=Eg(n.d[n.c],Fg(e,t-n.b)),t-=n.b,++n.c,n.b=63-t,n.d[n.c]=Eg(n.d[n.c],Cg(e,yl.$wb((1<<t)-1))))},xl.xg=function(n,t){n.d[n.c]=Ag(n.d[n.c],t)},xl.yg=function(n,t){var e;for(e=0;e<n.c;e++)if(Rg(n.d[e],t.d[e]))return Lg(n.d[e],t.d[e])?-1:1;return Ig(n.d[n.c],t.d[n.c])?0:Lg(n.d[n.c],t.d[n.c])?-1:1},xl.zg=function(n,t){n.a=t,n.c=0,n.b=63,Fl.KOb(n.d)},xl.Ag=function(n){this.d=vf(yl.ulb,st,6,n,14,1)},zf(160,1,{160:1,19:1},xl.Ag),o.Eb=function(n){return xl.yg(this,n)},o.a=0,o.b=0,o.c=0,yl.Flb=lg(160),xl.Cg=function(n,t){return n.b!=t.b?n.b>t.b?-1:1:n.c!=t.c?n.c>t.c?-1:1:0},xl.Dg=function(t,e,i){this.b=n.Math.max(t,e),this.c=n.Math.min(t,e),this.a=i},zf(212,1,{212:1,19:1},xl.Dg),o.Eb=function(n){return xl.Cg(this,n)},o.a=0,o.b=0,o.c=0,yl.Glb=lg(212),xl.Fg=function(n,t,e,i){this.a=(kl.ETb(t),Fl.HOb(n,vf(yl.tlb,z,6,t,15,1),t)),this.b=(kl.ETb(i),Fl.HOb(e,vf(yl.tlb,z,6,i,15,1),i))},zf(256,1,{256:1},xl.Fg),yl.Hlb=lg(256),xl.Gg=function(n,t){var e,i;for(i=0;i<n.g[t].length;i++)if(e=n.g[t][i],n.f[e]&&(1==n.o[e]||2==n.o[e])&&0==n.k[e])return!0;return!1},xl.Hg=function(n,t,e){var i,s,r,a,o;for(s=0,a=0,o=0;o<n.g[t].length;o++)i=n.g[t][o],n.k[i]==e&&0==(a&(r=1<<n.j[i]))&&(a|=r,++s);return s},xl.Ig=function(n){var t,e,i,s,r,a,o,l,f,g,u;for(f=new Fl.lSb,g=0;g<n.i.f;g++)if(xl.Bn(n.i,g)<2||xl.Ln(n.i,g)>2)for(r=1;r<xl.Ln(n.i,g);r++)for(t=xl.Kn(n.i,g,r),a=0;a<r;a++)e=xl.Kn(n.i,g,a),xl.Ng(n,t,e)&&((o=xl.Ug(n,t,e))&&xl.nq(o,n.f)&&Fl.oRb(f.a,o,(Jl.rFb(),d)));for(u=0;u<n.i.g;u++)(0==n.c[u]||2==xl.Vk(n.i,u)&&2==n.c[u])&&(t=xl.Nk(n.i,0,u),e=xl.Nk(n.i,1,u),xl.Ng(n,t,e)&&((o=xl.Ug(n,t,e))&&xl.nq(o,n.f)&&Fl.oRb(f.a,o,(Jl.rFb(),d))));for(n.g=vf(yl.tlb,ot,8,f.a.c,0,2),n.e=vf(yl.Lwb,nn,6,n.i.f,16,1),s=0,i=new Fl.GRb(new Fl.LRb(new Fl.HNb(f.a).a).b),l=new Fl.PNb(i);Fl.pMb(l.a.a);)for(o=Fl.ERb(l.a).Wd(),n.g[s++]=o.b,r=0;r<o.b.length;r++)n.e[o.b[r]]=!0},xl.Jg=function(n,t,e,i){var s,r,a,o,l,f,g;for(s=vf(yl.tlb,z,6,xl.Ln(n.i,e),15,1),o=0,a=0;a<xl.Ln(n.i,e);a++)s[o]=xl.Kn(n.i,e,a),!i[s[o]]&&xl.Ng(n,t,s[o])&&++o;if(0==o)return-1;if(1==o)return s[0];for(l=-1,f=I,r=0;r<o;r++)(g=xl.ko(n.i,t,s[r],I,i))<f&&(f=g,l=s[r]);return l},xl.Kg=function(n,t){return n.f[t]&&(1==n.o[t]||2==n.o[t])},xl.Lg=function(n,t){return n.e[t]},xl.Mg=function(n){var t,e;for(e=!0,t=0;t<n.i.f;t++)if(0!=n.o[t]&&!n.e[t]){e=!1;break}return e},xl.Ng=function(n,t,e){var i,s,r,a,o;if(t==e)return!1;if(n.a[t]!=n.a[e])return!1;if(0!=n.o[t]){if(3==n.o[t]||3==n.o[e])return!1;if(n.p[t]^n.o[t]!==n.o[e])return!1;if(n.k[t]!==n.k[e]||n.j[t]!==n.j[e])return!1}if(-1!=(i=xl.In(n.i,t,e))){if(1==xl.Vk(n.i,i)&&0!=n.c[i])return!1;if(2==xl.Vk(n.i,i)&&1==n.c[i])return!1}if(1==xl.Bn(n.i,t)&&!xl.Co(n.i,t)){for(s=-1,o=0;o<xl.Ln(n.i,t);o++)if(xl.Kn(n.i,t,o)!=e&&2==xl.Nn(n.i,t,o)){s=xl.Mn(n.i,t,o);break}for(r=-1,a=0;a<xl.Ln(n.i,e);a++)if(xl.Kn(n.i,e,a)!=t&&2==xl.Nn(n.i,e,a)){r=xl.Mn(n.i,e,a);break}if(-1!=s&&0!=n.c[s]&&n.d[s]^n.c[s]===n.c[r])return!1}return!0},xl.Og=function(n,t,e,i,s){var r,a,o,l,f,g;for(l=null,r=null,g=0;g<n.g[t].length;g++)a=n.g[t][g],n.f[a]&&(1==n.o[a]||2==n.o[a])&&(0==n.k[a]?r=xl.Wg(r,(s[a]<<16)+a):n.k[a]==i&&n.j[a]==e&&(l=xl.Wg(l,(s[a]<<16)+a)));if(0==(o=xl.jh(l,r)))return!1;if(o<0)for(f=0;f<n.g[t].length;f++)a=n.g[t][f],!n.f[a]||1!=n.o[a]&&2!=n.o[a]||(0==n.k[a]?(n.k[a]=i<<24>>24,n.j[a]=e<<24>>24):n.k[a]==i&&n.j[a]==e&&(n.k[a]=0,n.j[a]=-1));return!0},xl.Pg=function(n,t){var e,i,s,r,a,o;if(!n.b)return!1;for(s=!1,r=n.b.a.length-1;r>=0;r--)if(i=!1,2==(a=Fl.Pi(n.b,r)).a?i=xl.Og(n,a.b,a.c,a.d,t):1==a.a&&(i=xl.Tg(n,a.b,t)),i){for(Fl.Xi(n.b,a),o=0;o<n.g[a.b].length;o++)e=n.g[a.b][o],n.n[e]=!1;s=!0}return s},xl.Qg=function(n){var t,e,i,s,r,a,o,l;if(null!=n.g)for(a=new xl.ih(n),n.b=new Fl.cj,s=0;s<n.g.length;s++)0==(i=xl._g(a,s))?(xl.Xg(a,s),o=xl.Hg(n,s,2),t=xl.Hg(n,s,1),e=xl.Gg(n,s),1!=o||1!=t||e||(xl.Sg(n,s,a.a+a.f++),Fl.Ki(n.b,new xl.Aj(s,1,-1,-1))),o>0?(e&&(xl.Rg(n,s,a.i+a.g++,2),++o),Fl.Ki(n.b,new xl.Aj(s,1,-1,-1))):t>0?(e&&xl.Rg(n,s,a.a+a.f++,1),Fl.Ki(n.b,new xl.Aj(s,1,-1,-1))):e&&(xl.Rg(n,s,a.a+a.f++,1),Fl.Ki(n.b,new xl.Aj(s,1,-1,-1)))):1==i&&(xl.Gg(n,s)?(r=xl.$g(a,s),l=xl.ah(a,s),Fl.Ki(n.b,new xl.Aj(s,2,r,l))):(xl.Xg(a,s),Fl.Ki(n.b,new xl.Aj(s,1,-1,-1))))},xl.Rg=function(n,t,e,i){var s,r;for(r=0;r<n.g[t].length;r++)s=n.g[t][r],!n.f[s]||1!=n.o[s]&&2!=n.o[s]||0!=n.k[s]||(n.k[s]=i<<24>>24,n.j[s]=e<<24>>24)},xl.Sg=function(n,t,e){var i,s;for(s=0;s<n.g[t].length;s++)i=n.g[t][s],2==n.k[i]&&(n.k[i]=1,n.j[i]=e<<24>>24)},xl.Tg=function(n,t,e){var i,s,r,a,o,l,f,g;for(r=n.g[t],s=1,l=0;l<r.length;l++)if(i=r[l],n.f[i]&&2==n.k[i]){s=2;break}for(a=vf(yl.tlb,ot,8,32,0,2),f=0;f<r.length;f++)i=r[f],n.f[i]&&n.k[i]==s&&(a[n.j[i]]=xl.Wg(a[n.j[i]],(e[i]<<16)+i));for(g=0;g<32;g++)null!=a[g]&&kl.nTb(a[g],kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[])));if(Fl.ZOb(a,new xl.kh),0==xl.jh(a[0],a[1]))return!1;for(o=0;o<a[0].length;o++)i=a[0][o]&B,n.k[i]=0,n.j[i]=-1;return!0},xl.Ug=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C;for(l=vf(yl.tlb,z,6,n.i.f,15,1),H=vf(yl.tlb,z,6,n.i.f,15,1),c=vf(yl.Lwb,nn,6,n.i.f,16,1),f=vf(yl.Lwb,nn,6,n.i.f,16,1),j=new xl.oq(n.i.f),l[0]=t,H[t]=e,H[e]=-2,j.a[t]=!0,j.a[e]=!0,r=0,g=0;r<=g;){if(H[a=l[r]]==a){for(u=0;u<xl.Ln(n.i,a);u++)if(i=xl.Kn(n.i,a,u),!j.a[i])if(2==xl.Nn(n.i,a,u)&&xl.Ik(n.i,i)<10)l[++g]=i,H[i]=i,f[i]=f[a]||2==xl.Bn(n.i,i),c[i]=f[a]&&!c[a],j.a[i]=!0;else if(f[a]&&c[a]){if(-1==(m=xl.Jg(n,i,H[a],j.a)))return null;l[++g]=i,H[i]=m,H[m]=-2,f[i]=!1,j.a[i]=!0,j.a[m]=!0}else if(xl.Qo(n.i,xl.Mn(n.i,a,u))&&(l[++g]=i,H[i]=i,f[i]=!1,j.a[i]=!0,(6==xl.Ik(n.i,i)&&0==xl.Bn(n.i,i)||7==xl.Ik(n.i,i)&&1==xl.rk(n.i,i)||14==xl.Ik(n.i,i)||15==xl.Ik(n.i,i)&&xl.Ln(n.i,i)>2||16==xl.Ik(n.i,i)&&xl.Ln(n.i,i)>2)&&xl.Ln(n.i,i)>2)){for(o=!1,b=1;b<xl.Ln(n.i,i);b++)if(A=xl.Kn(n.i,i,b),!j.a[A])for(D=0;D<b;D++)C=xl.Kn(n.i,i,D),j.a[C]||xl.Ng(n,A,C)&&(l[++g]=A,H[A]=C,H[C]=-2,f[A]=!1,j.a[A]=!0,j.a[C]=!0,o=!0);if(!o)return null}}else{for(s=vf(yl.Lwb,nn,6,xl.Ln(n.i,a),16,1),h=0;h<xl.Ln(n.i,a);h++)if(i=xl.Kn(n.i,a,h),j.a[i])s[h]=H[i]==i;else for(b=0;b<xl.Ln(n.i,i);b++)if(xl.Kn(n.i,i,b)==H[a]){s[h]=!0;break}for(d=0;d<xl.Ln(n.i,a);d++)if(s[d])if(i=xl.Kn(n.i,a,d),j.a[i]){if(-1==xl.In(n.i,i,H[a]))return null}else l[++g]=i,H[i]=i,c[i]=!1,f[i]=!0,j.a[i]=!0;for(u=0;u<xl.Ln(n.i,a);u++)if(!s[u]&&(i=xl.Kn(n.i,a,u),!j.a[i])){if(-1==(m=xl.Jg(n,i,H[a],j.a)))return null;l[++g]=i,H[i]=m,H[m]=-2,f[i]=!1,j.a[i]=!0,j.a[m]=!0}}++r}return j},xl.Vg=function(n,t,e,i,s,r,a,o,l,f){this.i=n,this.a=t,this.f=e,this.o=i,this.c=s,this.k=r,this.j=a,this.p=o,this.d=l,this.n=f,xl.Ig(this)},xl.Wg=function(n,t){var e,i;for(i=vf(yl.tlb,z,6,null==n?1:n.length+1,15,1),e=0;e<i.length-1;e++)i[e]=n[e];return i[i.length-1]=t,i},zf(493,1,{},xl.Vg),yl.Jlb=lg(493),xl.Xg=function(n,t){var e,i,s,r,a,o;for(s=0;s<n.b;s++)if(n.e[s][t]&&-3!=n.c[s])for(i=0;i<=n.j.g.length;i++)if(i!=t&&n.e[s][i])for(n.e[s][t]=!1,o=s<n.a?s:s<n.b?s-n.a:-1,a=xl.gh(n,s<n.a?1:s<n.b?2:0),r=0;r<n.j.g[t].length;r++)e=n.j.g[t][r],xl.Kg(n.j,e)&&n.j.j[e]==o&&(n.j.j[e]=a<<24>>24)},xl.Yg=function(n,t,e){var i,s,r,a,o;for(o=!1,a=1,t[e]=a,i=!0;i;){for(i=!1,s=0;s<n.b;s++)if(t[s]==a)for(r=0;r<n.b;r++)0==t[r]&&xl.fh(n,s,r)&&(-2==n.c[r]?(t[r]=a+1,i=!0):n.c[r]!=n.c[e]&&(t[r]=a+1,o=!0));++a}return o},xl.Zg=function(n,t,e,i){var s,r,a,o,l,f,g,u,h,d,c;for(l=i+1;l<n.j.g.length;l++)if(l!=i&&n.e[t][l]&&n.e[e][l])return(a=vf(yl.tlb,z,6,2,15,1))[0]=e,a[1]=t,a;for(c=vf(yl.tlb,z,6,n.b,15,1),g=vf(yl.tlb,z,6,n.b,15,1),r=0,u=0,(f=vf(yl.tlb,z,6,n.b,15,1))[0]=t,g[t]=1;r<=u;){for(h=0;h<n.d[f[r]].length;h++){if((s=n.d[f[r]][h])==e){if(0==r)continue;for(o=g[f[r]]+1,(a=vf(yl.tlb,z,6,o,15,1))[0]=s,a[1]=f[r],d=2;d<o;d++)a[d]=c[a[d-1]];return a}0==g[s]&&-3!=n.c[s]&&(g[s]=g[f[r]]+1,f[++u]=s,c[s]=f[r])}++r}return null},xl.$g=function(n,t){var e;for(e=0;e<n.b;e++)if(n.e[e][t]&&-3==n.c[e])return e<n.a?e:e<n.b?e-n.a:-1;return-1},xl._g=function(n,t){var e,i;for(e=0,i=0;i<n.b;i++)n.e[i][t]&&-3==n.c[i]&&++e;return e},xl.ah=function(n,t){var e;for(e=0;e<n.b;e++)if(n.e[e][t]&&-3==n.c[e])return e<n.a?1:e<n.b?2:0;return-1},xl.bh=function(n,t){return t<n.a?t:t<n.b?t-n.a:-1},xl.dh=function(n,t){return t<n.a?1:t<n.b?2:0},xl.eh=function(n,t){var e,i;return i=n.j.k[t],e=n.j.j[t],0==i?n.b:1==i?e:n.a+e},xl.fh=function(n,t,e){var i;for(i=0;i<n.j.g.length;i++)if(n.e[t][i]&&n.e[e][i])return!0;return!1},xl.gh=function(n,t){return 1==t?n.a+n.f++:n.i+n.g++},xl.hh=function(n,t){var e,i,s,r,a,o,l,f,g,u;for(g=I,l=-1,u=-1,f=-1,i=0;i<n.j.i.f;i++)if(xl.Kg(n.j,i)&&0!=n.j.k[i])for(o=0;o<t.length;o++)s=xl.bh(n,t[o]),r=xl.dh(n,t[o]),n.j.k[i]==r&&n.j.j[i]==s&&g>n.j.a[i]+(1==r?J:0)&&(g=n.j.a[i]+(1==r?J:0),l=s,u=r,f=t[o]);for(e=0;e<n.j.i.f;e++)xl.Kg(n.j,e)&&n.j.k[e]==u&&n.j.j[e]==l&&(n.j.k[e]=0,n.j.j[e]=-1);for(a=0;a<n.j.g.length;a++)n.e[f][a]=!1},xl.ih=function(n){var t,e,i,s,r,a,o,l,f,g,u,h,d,c,b,D;for(this.j=n,i=0;i<n.i.f;i++)n.f[i]&&(1==n.o[i]||2==n.o[i])&&(1==n.k[i]?this.a<=n.j[i]&&(this.a=1+n.j[i]):2==n.k[i]&&this.i<=n.j[i]&&(this.i=1+n.j[i]));for(this.b=this.a+this.i,this.e=Yf(yl.Lwb,[j,nn],[12,6],16,[this.b+1,n.g.length+1],2),s=0;s<n.i.f;s++)n.f[s]&&(1==n.o[s]||2==n.o[s])&&!n.e[s]&&(this.e[xl.eh(this,s)][n.g.length]=!0);for(l=0;l<n.g.length;l++)for(D=0;D<n.g[l].length;D++)e=n.g[l][D],n.f[e]&&(1==n.o[e]||2==n.o[e])&&(this.e[xl.eh(this,e)][l]=!0);for(this.d=vf(yl.tlb,ot,8,this.b,0,2),f=0;f<n.g.length;f++)for(d=1;d<this.b;d++)if(this.e[d][f])for(c=0;c<d;c++)this.e[c][f]&&(this.d[d]=xl.Wg(this.d[d],c),this.d[c]=xl.Wg(this.d[c],d));for(this.c=vf(yl.tlb,z,6,this.b+1,15,1),h=0;h<this.b;h++)this.e[h][n.g.length]?this.c[h]=-1:this.c[h]=-2;for(g=0;g<n.g.length;g++)if(this.e[this.b][g])for(u=0;u<this.b;u++)this.e[u][g]&&this.c[u]!=g&&(-2==this.c[u]?this.c[u]=g:this.c[u]=-3);for(t=0;t<this.b;t++)if(this.c[t]>=-1&&(r=vf(yl.tlb,z,6,this.b,15,1),xl.Yg(this,r,t)))for(u=0;u<this.b;u++)0!=r[u]&&(this.c[u]=-3);for(o=0;o<n.g.length-1;o++)for(d=1;d<this.b;d++)if(this.e[d][o]&&-3!=this.c[d])for(c=0;c<d;c++)if(this.e[c][o]&&-3!=this.c[c]&&null!=(a=xl.Zg(this,d,c,o))){for(b=0;b<a.length;b++)this.c[a[b]]=-3;xl.hh(this,a);break}},zf(494,1,{},xl.ih),o.a=0,o.b=0,o.f=0,o.g=0,o.i=0,yl.Ilb=lg(494),xl.jh=function(t,e){var i,s;if(null==t)return null==e?0:1;if(null==e)return-1;for(i=n.Math.min(t.length,e.length),s=0;s<i;s++)if((t[s]&$n)!=(e[s]&$n))return(t[s]&$n)<(e[s]&$n)?-1:1;return t.length==e.length?0:t.length<e.length?-1:1},xl.kh=function(){},zf(495,1,{},xl.kh),o.Db=function(n,t){return xl.jh(n,t)},o.ib=function(n){return this===n},yl.Klb=lg(495),xl.nh=function(n,t){switch(t){case 0:return xl.oh(n,!1);case 1:return xl.qh(n);case 2:return xl.ph(n);case 3:return xl.sh(n);case 4:return xl.rh(n)}return null},xl.oh=function(n,t){try{return t?(n=xl.mu(n),xl.hp(n,!0),xl.Aq(n),xl.Nf(new xl.hg(n))):xl.Nf(new xl.hg(n))}catch(n){if(_f(n=ag(n),28))return Jl.vIb(),null;throw og(n)}},xl.ph=function(n){var t,e;try{for(n=xl.mu(n),xl.wu(n),t=n.r,e=0;e<t;e++)n.H[e]=1,n.T=0;return xl.Nf(new xl.hg(n))}catch(n){if(_f(n=ag(n),28))return Jl.vIb(),null;throw og(n)}},xl.qh=function(n){try{return n=xl.mu(n),xl.wu(n),xl.Nf(new xl.hg(n))}catch(n){if(_f(n=ag(n),28))return Jl.vIb(),null;throw og(n)}},xl.rh=function(n){var t;try{return n=xl.mu(n),xl.wu(n),t=xl.Ou(new xl.Ru(n)),xl.Nf(new xl.ig(t,8))}catch(n){if(_f(n=ag(n),28))return Jl.vIb(),null;throw og(n)}},xl.sh=function(n){var t;try{return t=xl.Ou(new xl.Ru(n)),xl.Nf(new xl.ig(t,8))}catch(n){if(_f(n=ag(n),28))return Jl.vIb(),null;throw og(n)}},xl.th=function(n,t,e,i){n.a+=t,n.b+=e,n.c+=i},xl.uh=function(n,t){return n.a+=t.a,n.b+=t.b,n.c+=t.c,n},xl.vh=function(n,t){return new xl.Kh(n.a+t.a,n.b+t.b,n.c+t.c)},xl.wh=function(n,t){return n.a=(n.a+t.a)/2,n.b=(n.b+t.b)/2,n.c=(n.c+t.c)/2,n},xl.xh=function(n,t){return n.a!=t.a?n.a<t.a?-1:1:n.b!=t.b?n.b<t.b?-1:1:n.c!=t.c?n.c<t.c?-1:1:0},xl.yh=function(n,t){return new xl.Kh(n.b*t.c-n.c*t.b,-(n.a*t.c-n.c*t.a),n.a*t.b-n.b*t.a)},xl.zh=function(t,e){return n.Math.sqrt((e.a-t.a)*(e.a-t.a)+(e.b-t.b)*(e.b-t.b)+(e.c-t.c)*(e.c-t.c))},xl.Ah=function(t,e){var i;return!(null==e||!_f(e,32))&&(i=e,n.Math.abs(i.a-t.a)+n.Math.abs(i.b-t.b)+n.Math.abs(i.c-t.c)<1e-6)},xl.Bh=function(t,e){var i,s,r;return s=t.a*t.a+t.b*t.b+t.c*t.c,r=e.a*e.a+e.b*e.b+e.c*e.c,0==s||0==r||(i=(t.a*e.a+t.b*e.b+t.c*e.c)/n.Math.sqrt(s*r))>=1?0:i<=-1?an:n.Math.acos(i)},xl.Ch=function(n,t){var e,i,s;return e=n.a,i=n.b,s=n.c,n.a=e*t[0][0]+i*t[1][0]+s*t[2][0],n.b=e*t[0][1]+i*t[1][1]+s*t[2][1],n.c=e*t[0][2]+i*t[1][2]+s*t[2][2],n},xl.Dh=function(n,t){return n.a*=t,n.b*=t,n.c*=t,n},xl.Eh=function(n,t,e,i){n.a=t,n.b=e,n.c=i},xl.Fh=function(n,t){return xl.Eh(n,t.a,t.b,t.c),n},xl.Gh=function(n,t){return n.a-=t.a,n.b-=t.b,n.c-=t.c,n},xl.Hh=function(n,t){return new xl.Kh(n.a-t.a,n.b-t.b,n.c-t.c)},xl.Ih=function(t){var e;return 0==(e=n.Math.sqrt(t.a*t.a+t.b*t.b+t.c*t.c))?(Jl.vIb(),t.a=1,t.b=0,t.c=0,t):(t.a/=e,t.b/=e,t.c/=e,t)},xl.Jh=function(){},xl.Kh=function(n,t,e){this.a=n,this.b=t,this.c=e},xl.Lh=function(n){xl.Kh.call(this,n.a,n.b,n.c)},zf(32,1,{32:1,4:1,19:1},xl.Jh,xl.Kh,xl.Lh),o.Eb=function(n){return xl.xh(this,n)},o.ib=function(n){return xl.Ah(this,n)},o.lb=function(){var n;return n=new Jf.$Kb("0.00"),"["+Jf.YKb(n,this.a)+", "+Jf.YKb(n,this.b)+", "+Jf.YKb(n,this.c)+"]"},o.a=0,o.b=0,o.c=0,yl.Mlb=lg(32),xl.Ph=function(n,t){t.c*=n.c,t.a=t.a*n.c+n.a,t.b=t.b*n.c+n.b},xl.Qh=function(n,t){xl.Sl(t,n.c),xl.Nm(t,n.a,n.b)},xl.Rh=function(n,t){t.a=t.a*n.c+n.a,t.b=t.b*n.c+n.b},xl.Sh=function(n,t){t.c=t.c*n.c+n.a,t.d=t.d*n.c+n.b,t.b*=n.c,t.a*=n.c},xl.Th=function(n){n.a=0,n.b=0,n.c=1},xl.Uh=function(n){return 1==n.c&&0==n.a&&0==n.b},xl.Vh=function(n,t){return t*n.c+n.a},xl.Wh=function(n,t){return t*n.c+n.b},xl.Xh=function(){xl.Th(this)},xl.Yh=function(n,t){this.c=1,this.a=n,this.b=t},xl.Zh=function(t,e,i,s){var r,a,o,l;xl.Th(this),e?0==(s&ut)?Kl.EG(e,t.c,t.d)&&Kl.EG(e,t.c+t.b,t.d+t.a)||((t.b>e.b||t.a>e.a)&&(a=e.b/t.b,l=e.a/t.a,this.c=n.Math.min(a,l)),t.c*this.c<e.c?this.a=e.c-t.c*this.c:(t.c+t.b)*this.c>e.c+e.b&&(this.a=e.c+e.b-(t.c+t.b)*this.c),t.d*this.c<e.d?this.b=e.d-t.d*this.c:(t.d+t.a)*this.c>e.d+e.a&&(this.b=e.d+e.a-(t.d+t.a)*this.c)):(a=e.b/t.b,l=e.a/t.a,0==(o=s&B)?o=24:0!=(s&gt)&&(o/=256),r=o/i,this.c=n.Math.min(r,n.Math.min(a,l)),this.a=e.c+e.b/2-this.c*(t.c+t.b/2),this.b=e.d+e.a/2-this.c*(t.d+t.a/2)):0!=(s&J)&&(o=0!=(s&B)?s&B:24,this.c=o/i)},zf(106,1,{},xl.Xh,xl.Yh,xl.Zh),o.lb=function(){return"DepictorTransformation Offset: "+this.a+","+this.b+" Scaling: "+this.c},o.a=0,o.b=0,o.c=0,yl.Nlb=lg(106),xl._h=function(n){var t,e,i,s;return Jl.KHb(kl.TTb(n).substr(0,21),tt)&&(i=kl.TTb(et).length,Jl.KHb(kl.TTb(n).substr(kl.TTb(n).length-i,i),et))?-1==(e=Jl.PHb(n,bg(34),21))?null:(kl.NTb(21,e,kl.TTb(n).length),s=kl.TTb(n).substr(21,e-21),t=Jl.YHb(n,21+kl.TTb(s).length+1,kl.TTb(n).length-17),Jl.KHb(s,"arrow")?new Vl.HF(t):Jl.KHb(s,Ht)?new xl.ev(t):null):null},Fl.ai=function(n,t,e){var i,s;for(s=n.Fb();s.Fd();)if(i=s.Gd(),sg(t)===sg(i)||null!=t&&Jl.Gc(t,i))return e&&s.Hd(),!0;return!1},Fl.bi=function(n,t){var e,i;for(kl.ITb(t),i=t.Fb();i.Fd();)if(e=i.Gd(),!n.contains(e))return!1;return!0},Fl.ci=function(n,t){var e,i,s;for(kl.ITb(t),e=!1,i=n.Fb();i.Fd();)s=i.Gd(),t.contains(s)&&(i.Hd(),e=!0);return e},Fl.di=function(n){var t,e,i;for(i=new Fl.eRb("[","]"),e=n.Fb();e.Fd();)t=e.Gd(),Fl.cRb(i,sg(t)===sg(n)?"(this Collection)":null==t?M:xf(t));return i.a?0==kl.TTb(i.e).length?i.a.a:i.a.a+""+i.e:i.c},zf(60,1,jt),o.add=function(n){throw og(new Jl.zIb("Add not supported on this collection"))},o.addAll=function(n){var t,e,i;for(kl.ITb(n),t=!1,i=n.Fb();i.Fd();)e=i.Gd(),t|=this.add(e);return t},o.clear=function(){var n;for(n=this.Fb();n.Fd();)n.Gd(),n.Hd()},o.contains=function(n){return Fl.ai(this,n,!1)},o.containsAll=function(n){return Fl.bi(this,n)},o.isEmpty=function(){return 0==this.size()},o.remove=function(n){return Fl.ai(this,n,!0)},o.removeAll=function(n){return Fl.ci(this,n)},o.retainAll=function(n){var t,e,i;for(kl.ITb(n),t=!1,e=this.Fb();e.Fd();)i=e.Gd(),n.contains(i)||(e.Hd(),t=!0);return t},o.toArray=function(){return this.Gb(vf(yl.Rub,w,1,this.size(),5,1))},o.Gb=function(n){var t,e,i,s;for(s=this.size(),n.length<s&&(n=kl.oTb(new Array(s),n)),i=n,e=this.Fb(),t=0;t<s;++t)Vf(i,t,e.Gd());return n.length>s&&yl.bkb(n,s,null),n},o.lb=function(){return Fl.di(this)},yl.evb=lg(60),Fl.qi=function(n){return new Fl.yMb(n,0)},Fl.ri=function(n,t){return new Fl.yMb(n,t)},Fl.si=function(n,t,e){return new Fl.CMb(n,t,e)},zf(104,60,mt),o.addAtIndex=function(n,t){throw og(new Jl.zIb("Add not supported on this list"))},o.add=function(n){return this.addAtIndex(this.size(),n),!0},o.addAllAtIndex=function(n,t){var e,i,s;for(kl.ITb(t),e=!1,s=t.Fb();s.Fd();)i=s.Gd(),this.addAtIndex(n++,i),e=!0;return e},o.clear=function(){this.Jb(0,this.size())},o.ib=function(n){var t,e,i,s,r;if(n===this)return!0;if(!_f(n,121))return!1;if(r=n,this.size()!=r.size())return!1;for(s=r.Fb(),e=this.Fb();e.Fd();)if(t=e.Gd(),i=s.Gd(),!(sg(t)===sg(i)||null!=t&&Jl.Gc(t,i)))return!1;return!0},o.kb=function(){return Fl.kPb(this)},o.indexOf=function(n){var t,e;for(t=0,e=this.size();t<e;++t)if(Fl.SQb(n,this.getAtIndex(t)))return t;return-1},o.Fb=function(){return new Fl.sMb(this)},o.lastIndexOf=function(n){var t;for(t=this.size()-1;t>-1;--t)if(Fl.SQb(n,this.getAtIndex(t)))return t;return-1},o.Hb=function(){return Fl.qi(this)},o.Ib=function(n){return Fl.ri(this,n)},o.removeAtIndex=function(n){throw og(new Jl.zIb("Remove not supported on this list"))},o.Jb=function(n,t){var e,i;for(i=new Fl.yMb(this,n),e=n;e<t;++e)kl.GTb(i.b<i.d.size()),i.d.getAtIndex(i.c=i.b++),Fl.rMb(i)},o.setAtIndex=function(n,t){throw og(new Jl.zIb("Set not supported on this list"))},o.subList=function(n,t){return Fl.si(this,n,t)},yl.lvb=lg(104),Fl.Ii=function(n){n.a=vf(yl.Rub,w,1,0,5,1)},Fl.Ji=function(n,t,e){kl.KTb(t,n.a.length),kl.hTb(n.a,t,e)},Fl.Ki=function(n,t){return kl.kTb(n.a,t),!0},Fl.Li=function(n,t,e){var i;return kl.KTb(t,n.a.length),0!=(i=e.toArray()).length&&(kl.iTb(n.a,t,i),!0)},Fl.Mi=function(n,t){var e;return 0!=(e=t.toArray()).length&&(kl.iTb(n.a,n.a.length,e),!0)},Fl.Ni=function(n){kl.mTb(n.a,0)},Fl.Oi=function(n,t){return-1!=Fl.Ri(n,t,0)},Fl.Pi=function(n,t){return kl.HTb(t,n.a.length),n.a[t]},Fl.Qi=function(n,t){return Fl.Ri(n,t,0)},Fl.Ri=function(n,t,e){for(;e<n.a.length;++e)if(Fl.SQb(t,n.a[e]))return e;return-1},Fl.Si=function(n){return 0==n.a.length},Fl.Ti=function(n){return new Fl.zOb(n)},Fl.Ui=function(n,t){return Fl.Vi(n,t,n.a.length-1)},Fl.Vi=function(n,t,e){for(;e>=0;--e)if(Fl.SQb(t,n.a[e]))return e;return-1},Fl.Wi=function(n,t){var e;return kl.HTb(t,n.a.length),e=n.a[t],kl.lTb(n.a,t,1),e},Fl.Xi=function(n,t){var e;return-1!=(e=Fl.Ri(n,t,0))&&(Fl.Wi(n,e),!0)},Fl.Yi=function(n,t,e){var i;kl.LTb(t,e,n.a.length),i=e-t,kl.lTb(n.a,t,i)},Fl.Zi=function(n,t,e){var i;return kl.HTb(t,n.a.length),i=n.a[t],n.a[t]=e,i},Fl.$i=function(n){return n.a.length},Fl._i=function(n,t){Fl.YOb(n.a,n.a.length,t)},Fl.aj=function(n){return kl.eTb(n.a)},Fl.bj=function(n,t){var e,i;for(i=n.a.length,t.length<i&&(t=kl.oTb(new Array(i),t)),e=0;e<i;++e)Vf(t,e,n.a[e]);return t.length>i&&yl.bkb(t,i,null),t},Fl.cj=function(){Fl.Ii(this)},Fl.dj=function(n){Fl.Ii(this),kl.CTb(n>=0,"Initial capacity must not be negative")},zf(21,104,At,Fl.cj,Fl.dj),o.addAtIndex=function(n,t){Fl.Ji(this,n,t)},o.add=function(n){return Fl.Ki(this,n)},o.addAllAtIndex=function(n,t){return Fl.Li(this,n,t)},o.addAll=function(n){return Fl.Mi(this,n)},o.clear=function(){Fl.Ni(this)},o.contains=function(n){return Fl.Oi(this,n)},o.getAtIndex=function(n){return Fl.Pi(this,n)},o.indexOf=function(n){return Fl.Qi(this,n)},o.isEmpty=function(){return Fl.Si(this)},o.Fb=function(){return Fl.Ti(this)},o.lastIndexOf=function(n){return Fl.Ui(this,n)},o.removeAtIndex=function(n){return Fl.Wi(this,n)},o.remove=function(n){return Fl.Xi(this,n)},o.Jb=function(n,t){Fl.Yi(this,n,t)},o.setAtIndex=function(n,t){return Fl.Zi(this,n,t)},o.size=function(){return Fl.$i(this)},o.toArray=function(){return Fl.aj(this)},o.Gb=function(n){return Fl.bj(this,n)},yl.Cvb=lg(21),xl.wj=function(n){var t,e;for(e=new Jl.gIb,t=0;t<n.a.length;t++)Jl.fIb(e,xl.$d((kl.HTb(t,n.a.length),n.a[t]))+H);return e.a},xl.xj=function(n){var t;Fl.cj.call(this);try{if(n)for(t=0;t<n.a.length;t++)Fl.Ki(this,(kl.HTb(t,n.a.length),n.a[t]).Ab())}catch(n){if(!_f(n=ag(n),18))throw og(n)}},xl.yj=function(n){var t,e,i;if(Fl.cj.call(this),null!=n&&0!=kl.TTb(n).length)for(t=0,e=Jl.OHb(n,bg(10));-1!=e;)(i=xl._h((kl.NTb(t,e,kl.TTb(n).length),kl.TTb(n).substr(t,e-t))))&&kl.kTb(this.a,i),t=e+1,e=Jl.PHb(n,bg(10),t)},zf(247,21,At,xl.xj,xl.yj),o.lb=function(){return xl.wj(this)},yl.Olb=lg(247),xl.Aj=function(n,t,e,i){this.b=n,this.a=t,this.c=e,this.d=i},zf(125,1,{125:1},xl.Aj),o.a=0,o.b=0,o.c=0,o.d=0,yl.Plb=lg(125),xl.Bj=function(n){var t,e,i,s,r,a;if(0!=n.j)return n.j;if(n.i&&15!=xl.Ik(n.e,n.a)&&16!=xl.Ik(n.e,n.a))for(a=0;a<xl.wn(n.e,n.a);a++)if(r=xl.Mn(n.e,n.a,a),xl.Fl(n.e,r,n.a))return xl.Kn(n.e,n.a,a)==n.b?n.j=257==xl.Yk(n.e,r)?3:1:n.j=257==xl.Yk(n.e,r)?1:3,n.j;return t=xl.Mk(n.e,n.a,n.g),(i=xl.Mk(n.e,n.a,n.b))<t&&(i+=rn),2==xl.wn(n.e,n.a)?(e=i-t)>3.0915926535897933&&e<3.191592653589793?(n.j=-1,n.j):(n.j=e<an?4:2,n.j):((s=xl.Mk(n.e,n.a,n.d))<t&&(s+=rn),n.j=s<i?2:4,n.j)},xl.Cj=function(n,t,e,i){var s,r,a,o;for(this.e=n,this.g=e,this.a=i,a=-1,o=0;o<xl.wn(this.e,this.a);o++)s=xl.Kn(this.e,this.a,o),r=xl.Mn(this.e,this.a,o),s!=this.g?(xl.Fl(this.e,r,this.a)&&(this.i&&(n.u[i]|=J),this.i=!0),a==t[s]?(this.d=s,this.f=!0,this.c=xl.Qo(this.e,r)):a<t[s]?(a=t[s],this.d=this.b,this.b=s):this.d=s):386==xl.Yk(this.e,r)&&(this.j=-1)},zf(143,1,{},xl.Cj),o.a=0,o.b=0,o.c=!1,o.d=0,o.f=!1,o.g=0,o.i=!1,o.j=0,yl.Qlb=lg(143),xl.Kj=function(){xl.Kj=Xf,xl.Ej=Of(qf(yl.Xub,1),y,2,6,["?","H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og",Ct,Ct,Ct,Ct,Ct,Ct,Ct,Ct,Ct,Ct,"R4","R5","R6","R7","R8","R9","R10","R11","R12","R13","R14","R15","R16","R1","R2","R3","A","A1","A2","A3",Ct,Ct,"D","T","X","R","H2","H+","Nnn","HYD","Pol",Ct,Ct,Ct,Ct,Ct,Ct,Ct,Ct,Ct,Ct,Ct,"Ala","Arg","Asn","Asp","Cys","Gln","Glu","Gly","His","Ile","Leu","Lys","Met","Phe","Pro","Ser","Thr","Trp","Tyr","Val"]),xl.Ij=Of(qf(yl.Kwb,1),it,6,15,[0,1,4,7,9,11,12,14,16,19,20,23,24,27,28,31,32,35,40,39,40,45,48,51,52,55,56,59,58,63,64,69,74,75,80,79,84,85,88,89,90,93,98,0,102,103,106,107,114,115,120,121,130,127,132,133,138,139,140,141,142,0,152,153,158,159,164,165,166,169,174,175,180,181,184,187,192,193,195,197,202,205,208,209,209,210,222,223,226,227,232,231,238,237,244,243,247,247,251,252,257,258,259,262,267,268,271,270,277,276,281,281,283,285,289,289,293,294,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,156,114,115,103,128,129,57,137,113,113,128,131,147,97,87,101,186,163,99]),xl.Hj=Of(qf(yl.plb,1),ft,6,15,[6]),xl.Dj=Of(qf(yl.plb,1),ft,6,15,[2]),xl.Fj=Of(qf(yl.plb,2),j,10,0,[null,Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[0]),Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[4]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[0]),Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[4]),Of(qf(yl.plb,1),ft,6,15,[3,5]),Of(qf(yl.plb,1),ft,6,15,[2,4,6]),Of(qf(yl.plb,1),ft,6,15,[1,3,5,7]),Of(qf(yl.plb,1),ft,6,15,[0]),Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),null,null,null,null,null,null,null,null,null,null,Of(qf(yl.plb,1),ft,6,15,[2,3]),Of(qf(yl.plb,1),ft,6,15,[2,4]),Of(qf(yl.plb,1),ft,6,15,[3,5]),Of(qf(yl.plb,1),ft,6,15,[2,4,6]),Of(qf(yl.plb,1),ft,6,15,[1,3,5,7]),Of(qf(yl.plb,1),ft,6,15,[0,2]),Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),null,null,null,null,null,null,null,null,null,null,Of(qf(yl.plb,1),ft,6,15,[1,2,3]),Of(qf(yl.plb,1),ft,6,15,[2,4]),Of(qf(yl.plb,1),ft,6,15,[3,5]),Of(qf(yl.plb,1),ft,6,15,[2,4,6]),Of(qf(yl.plb,1),ft,6,15,[1,3,5,7]),Of(qf(yl.plb,1),ft,6,15,[0,2,4,6]),Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[2])]),xl.Gj=Of(qf(yl.plb,2),j,10,0,[null,Of(qf(yl.plb,1),ft,6,15,[1]),null,Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),null,null,Of(qf(yl.plb,1),ft,6,15,[-3]),Of(qf(yl.plb,1),ft,6,15,[-2]),Of(qf(yl.plb,1),ft,6,15,[-1]),null,Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[3]),null,Of(qf(yl.plb,1),ft,6,15,[-3]),Of(qf(yl.plb,1),ft,6,15,[-2]),Of(qf(yl.plb,1),ft,6,15,[-1]),null,Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[2,3,4]),Of(qf(yl.plb,1),ft,6,15,[2,3,4,5]),Of(qf(yl.plb,1),ft,6,15,[2,3,6]),Of(qf(yl.plb,1),ft,6,15,[2,3,4,7]),Of(qf(yl.plb,1),ft,6,15,[2,3]),Of(qf(yl.plb,1),ft,6,15,[2,3]),Of(qf(yl.plb,1),ft,6,15,[2,3]),Of(qf(yl.plb,1),ft,6,15,[1,2]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[2,4]),Of(qf(yl.plb,1),ft,6,15,[-3,3,5]),Of(qf(yl.plb,1),ft,6,15,[-2]),Of(qf(yl.plb,1),ft,6,15,[-1]),null,Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[4]),Of(qf(yl.plb,1),ft,6,15,[3,5]),Of(qf(yl.plb,1),ft,6,15,[6]),Of(qf(yl.plb,1),ft,6,15,[4,6,7]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[2,4]),Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[2,4]),Of(qf(yl.plb,1),ft,6,15,[-3,3,5]),Of(qf(yl.plb,1),ft,6,15,[-2,4,6]),Of(qf(yl.plb,1),ft,6,15,[-1]),null,Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3,4]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[2,3]),Of(qf(yl.plb,1),ft,6,15,[2,3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[2,3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[4]),Of(qf(yl.plb,1),ft,6,15,[5]),Of(qf(yl.plb,1),ft,6,15,[6]),Of(qf(yl.plb,1),ft,6,15,[4,6,7]),Of(qf(yl.plb,1),ft,6,15,[3,4]),Of(qf(yl.plb,1),ft,6,15,[3,4]),Of(qf(yl.plb,1),ft,6,15,[2,4]),Of(qf(yl.plb,1),ft,6,15,[1,3]),Of(qf(yl.plb,1),ft,6,15,[1,2]),Of(qf(yl.plb,1),ft,6,15,[1,3]),Of(qf(yl.plb,1),ft,6,15,[2,4]),Of(qf(yl.plb,1),ft,6,15,[3,5]),Of(qf(yl.plb,1),ft,6,15,[-2,2,4]),Of(qf(yl.plb,1),ft,6,15,[-1,1]),null,Of(qf(yl.plb,1),ft,6,15,[1]),Of(qf(yl.plb,1),ft,6,15,[2]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[4]),Of(qf(yl.plb,1),ft,6,15,[4,5]),Of(qf(yl.plb,1),ft,6,15,[3,4,5,6]),Of(qf(yl.plb,1),ft,6,15,[3,4,5,6]),Of(qf(yl.plb,1),ft,6,15,[3,4,5,6]),Of(qf(yl.plb,1),ft,6,15,[3,4,5,6]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3,4]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[3]),Of(qf(yl.plb,1),ft,6,15,[2,3]),Of(qf(yl.plb,1),ft,6,15,[2,3]),Of(qf(yl.plb,1),ft,6,15,[3])])},xl.Lj=function(n,t,e,i){var s;return s=xl.Mj(n,6),xl.Eh(n.J[s],t,e,i),s},xl.Mj=function(n,t){return n.q>=n.M&&xl.Dm(n,2*n.M),n.C[n.q]=0,xl.om(n,n.q,t),n.s[n.q]=0,n.u[n.q]=0,n.B[n.q]=0,n.w[n.q]=0,xl.Eh(n.J[n.q],0,0,0),null!=n.v&&(n.v[n.q]=null),null!=n.t&&(n.t[n.q]=null),n.T=0,n.q++},xl.Nj=function(n,t,e){return xl.Oj(n,t,e,xl.yl(n,t)||xl.yl(n,e)?32:1)},xl.Oj=function(n,t,e,i){var s;if(t==e)return-1;for(s=0;s<n.r;s++)if(n.D[0][s]==t&&n.D[1][s]==e||n.D[0][s]==e&&n.D[1][s]==t)return n.H[s]<i&&(n.H[s]=i),s;return n.r>=n.N&&xl.Em(n,2*n.N),n.D[0][n.r]=t,n.D[1][n.r]=e,n.H[n.r]=i,n.F[n.r]=0,n.G[n.r]=0,n.T=0,n.r++},xl.Pj=function(n,t){return xl.Qj(n,t,t.q,t.r)},xl.Qj=function(n,t,e,i){var s,r,a,o,l;for(n.K=n.K|t.K,r=vf(yl.tlb,z,6,t.q,15,1),o=xl.Rl(n,1),l=xl.Rl(n,2),s=0;s<e;s++)r[s]=xl.bk(t,n,s,o,l);for(a=0;a<i;a++)xl.ck(t,n,a,o,l,r[t.D[0][a]],r[t.D[1][a]],!1);return n.L=n.L&&t.L,n.I=0,n.T=0,r},xl.Rj=function(n,t,e,i,s,r,a,o){var l,f;return-1==(l=xl.nk(n,t,e))?(n.q>=n.M&&xl.Dm(n,2*n.M),l=xl.Mj(n,i),xl.Eh(n.J[l],t,e,0),n.A[l]=s,xl.Vl(n,l,r),xl.im(n,l,a),xl.$l(n,l,o),!0):(f=xl.Yj(n,l,i,s,r,a),xl.$l(n,l,o),f)},xl.Sj=function(n,t,e,i){var s;for(s=0;s<n.r;s++)if(n.D[0][s]==t&&n.D[1][s]==e||n.D[0][s]==e&&n.D[1][s]==t)return xl.$j(n,s,i),n.T=0,s;return n.r>=n.N&&xl.Em(n,2*n.N),n.D[0][n.r]=t,n.D[1][n.r]=e,n.H[n.r]=i,n.F[n.r]=0,n.G[n.r]=0,n.T=0,n.r++},xl.Tj=function(n,t,e,i,s,r){for(var a,o,l;n.q+i>n.M;)xl.Dm(n,2*n.M);for(;n.r+i>n.N;)xl.Em(n,2*n.N);return-1!=(a=xl.nk(n,t,e))?xl.Uj(n,a,i,s,r):-1!=(o=xl.ok(n,t,e))?xl.Vj(n,o,i,s,r):(a=xl.Lj(n,t,e,0),l=an*(i-2)/i,xl.Jl(n,a,i,a,s,0,an-l,r),n.T=0,!0)},xl.Uj=function(t,e,i,s,r){var a,o,l,f,g,u;if(s&&xl.fo(t,e)>1||!s&&xl.fo(t,e)>2)return!1;for(o=0,a=vf(yl.rlb,X,6,4,15,1),f=0;f<t.r;f++){for(g=0;g<2;g++)if(t.D[g][f]==e){if(2==o){o=3;break}a[o++]=xl.Mk(t,e,t.D[1-g][f])}if(3==o)break}return 3!=o&&(u=1==o?a[0]+an:n.Math.abs(a[0]-a[1])>an?(a[0]+a[1])/2:(a[0]+a[1])/2+an,l=an*(i-2)/i,xl.Jl(t,e,i,e,s,u-l/2,an-l,r),t.T=0,!0)},xl.Vj=function(n,t,e,i,s){var r,a,o,l,f,g,u,h,d,c,b;if(f=vf(yl.tlb,z,6,2,15,1),l=vf(yl.rlb,X,6,2,15,1),f[0]=n.D[0][t],f[1]=n.D[1][t],xl.fo(n,f[0])>3)return!1;if(xl.fo(n,f[1])>3)return!1;for(a=0,r=vf(yl.rlb,X,6,4,15,1),h=0;h<n.r;h++)if(h!=t){for(d=0;d<2;d++){for(c=0;c<2;c++)if(n.D[d][h]==f[c]){if(4==a){a=5;break}r[a++]=xl.Mk(n,f[c],n.D[1-d][h])}if(5==a)break}if(5==a)break}if(5==a)return!1;for(l[0]=xl.Mk(n,f[0],f[1]),l[0]<0?(l[1]=l[0]+an,o=0):(l[1]=l[0],l[0]=l[1]-an,o=1),b=0,u=0;u<a;u++)r[u]>l[0]&&r[u]<l[1]?--b:++b;return o=b>0?1-o:o,g=an*(e-2)/e,xl.Jl(n,f[o],e-1,f[1-o],i,l[b>0?0:1]+an-g,an-g,s),n.T=0,!0},xl.Wj=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d,c,b;for(s=vf(yl.tlb,z,6,t.q,15,1),l=xl.Rl(n,1),f=xl.Rl(n,2),i=0;i<t.q;i++)if(0!=t.C[i]||null!=(null==t.t||null==t.t[i]?null:Jl.IHb((d=t.t[i],yf.XKb(),d))))s[i]=xl.bk(t,n,i,l,f);else if(s[i]=e,0!=(8&t.T))for(o=0;o<t.r;o++)for(g=0;g<2;g++)if(t.D[g][o]==i){if(c=t.D[1-g][o],u=!1,1==(b=3&t.u[c])||2==b)for(r=0;r<t.r;r++)if(r!=o)for(h=0;h<2;h++)t.D[h][r]==c&&t.D[1-h][r]<i&&(u=!u);u&&xl.gm(t,c,1==b?2:1,0!=(4&t.u[c]))}for(a=0;a<t.r;a++)xl.ck(t,n,a,l,f,s[t.D[0][a]],s[t.D[1][a]],!1);return n.L=n.L&&t.L,n.I=0,n.T=0,s},xl.Xj=function(t,e){var i,s,r,a,o,l,f,g,u;return i=t.J[e[0]],s=t.J[e[1]],r=t.J[e[2]],a=t.J[e[3]],f=new xl.Kh(s.a-i.a,s.b-i.b,s.c-i.c),g=new xl.Kh(r.a-s.a,r.b-s.b,r.c-s.c),u=new xl.Kh(a.a-r.a,a.b-r.b,a.c-r.c),o=new xl.Kh(f.b*g.c-f.c*g.b,-(f.a*g.c-f.c*g.a),f.a*g.b-f.b*g.a),l=new xl.Kh(g.b*u.c-g.c*u.b,-(g.a*u.c-g.c*u.a),g.a*u.b-g.b*u.a),-n.Math.atan2(n.Math.sqrt(g.a*g.a+g.b*g.b+g.c*g.c)*(f.a*l.a+f.b*l.b+f.c*l.c),o.a*l.a+o.b*l.b+o.c*l.c)},xl.Yj=function(n,t,e,i,s,r){return(1!=e&&151!=e&&152!=e||!(xl.fo(n,t)>1))&&(n.B[t]=Cg(n.B[t],-2),null!=n.v&&(n.v[t]=null),null!=n.t&&(n.t[t]=null),(e!=n.C[t]||i!=n.A[t]||s!=((n.u[t]&Tt)>>>27)-1||r!=(48&n.u[t]))&&(151!=e&&152!=e||(i=e-149,e=1),n.u[t]&=960,n.C[t]=e,n.A[t]=i,n.s[t]=0,n.B[t]=0,xl.Vl(n,t,s),xl.im(n,t,r),xl.Pl(n,n.w[t]),n.T=0,!0))},xl.Zj=function(n,t,e){if(e){if(n.s[t]>8)return!1;++n.s[t]}else{if(n.s[t]<-8)return!1;--n.s[t]}return n.T=0,!0},xl.$j=function(n,t,e){var i,s,r,a,o;return r=!1,a=n.H[t],511==e?r=xl.gl(n,t):xl.kp(n,t,e)&&(257==e||129==e?(i=xl.Kl(n,t,n.D[0][t]),s=xl.Kl(n,t,n.D[1][t]),e==a?(i==s||s)&&(o=n.D[0][t],n.D[0][t]=n.D[1][t],n.D[1][t]=o,r=!0):(!i&&s&&(o=n.D[0][t],n.D[0][t]=n.D[1][t],n.D[1][t]=o),n.H[t]=e,r=!0)):(n.H[t]=e,r=!0)),r&&(n.T=(127&a)==(127&e)?7&n.T:0,n.G[t]=0),r},xl._j=function(n){n.q=0,n.r=0,n.K=!1,n.L=!1,n.I=0,n.v=null,n.t=null,n.P=null,n.T=0},xl.ak=function(n){var t,e,i,s,r,a,o,l;for(a=0;a<n.r;a++)512==n.H[a]&&(e=n.D[0][a],i=n.D[1][a],-1==n.C[e]^-1==n.C[i]&&0!=n.s[e]&&0!=n.s[i]&&n.s[e]<0^n.s[i]<0&&(n.s[e]<0?(++n.s[e],--n.s[i]):(--n.s[e],++n.s[i])));for(l=vf(yl.tlb,z,6,n.q,15,1),s=0,t=0;t<n.q;t++)-1!=n.C[t]?(s<t&&(n.C[s]=n.C[t],n.s[s]=n.s[t],n.A[s]=n.A[t],n.u[s]=n.u[t],n.B[s]=n.B[t],n.w[s]=n.w[t],xl.Fh(n.J[s],n.J[t]),null!=n.v&&(n.v[s]=n.v[t]),null!=n.t&&(n.t[s]=n.t[t])),l[t]=s,++s):l[t]=-1;for(n.q=s,o=0,r=0;r<n.r;r++)512!=n.H[r]&&(n.H[o]=n.H[r],n.F[o]=n.F[r],n.G[o]=n.G[r],n.D[0][o]=l[n.D[0][r]],n.D[1][o]=l[n.D[1][r]],++o);return n.r=o,l},xl.bk=function(t,e,i,s,r){var a,o,l;return(a=e.q)>=e.M&&xl.Dm(e,2*e.M),o=-1,1==(l=(t.u[i]&On)>>18)?o=-1==s?xl.Rl(e,l):n.Math.min(31,s+((t.u[i]&On)>>18!=1&&(t.u[i]&On)>>18!=2?-1:(t.u[i]&pt)>>20)):2==l&&(o=-1==r?xl.Rl(e,l):n.Math.min(31,r+((t.u[i]&On)>>18!=1&&(t.u[i]&On)>>18!=2?-1:(t.u[i]&pt)>>20))),e.C[a]=t.C[i],e.s[a]=t.s[i],e.A[a]=t.A[i],e.u[a]=t.u[i],e.B[a]=e.K?t.B[i]:0,xl.Fh(e.J[a],t.J[i]),e.w[a]=t.w[i],null!=e.v&&(e.v[a]=null),null!=t.v&&null!=t.v[i]&&e.K&&(null==e.v&&(e.v=vf(yl.tlb,ot,8,e.C.length,0,2)),e.v[a]=Fl.FOb(t.v[i],t.v[i].length)),null!=e.t&&(e.t[a]=null),null!=t.t&&null!=t.t[i]&&(null==e.t&&(e.t=vf(yl.plb,j,10,e.C.length,0,2)),e.t[a]=Fl.DOb(t.t[i],t.t[i].length)),-1!=o&&(e.u[a]&=-32505857,e.u[a]|=o<<20),++e.q,e.T=0,a},xl.ck=function(t,e,i,s,r,a,o,l){var f,g,u,h;return(g=e.r)>=e.N&&xl.Em(e,2*e.N),u=-1,1==(h=(768&t.F[i])>>8)&&(u=-1==s?xl.Rl(e,h):n.Math.min(32,s+((768&t.F[i])>>8!=1&&(768&t.F[i])>>8!=2?-1:(t.F[i]&It)>>10))),2==h&&(u=-1==r?xl.Rl(e,h):n.Math.min(32,r+((768&t.F[i])>>8!=1&&(768&t.F[i])>>8!=2?-1:(t.F[i]&It)>>10))),e.D[0][g]=a,e.D[1][g]=o,f=l&&t.Lb(i)?64:t.H[i],e.H[g]=f,e.F[g]=t.F[i],e.G[g]=e.K?t.G[i]:0,-1!=u&&(e.F[g]&=-31745,e.F[g]|=u<<10),++e.r,e.T=0,g},xl.dk=function(n,t,e,i,s,r,a){return xl.ck(n,t,e,i,s,null==r?n.D[0][e]:r[n.D[0][e]],null==r?n.D[1][e]:r[n.D[1][e]],a)},xl.ek=function(n,t){var e,i;for(t.v=null,t.t=null,t.K=n.K,t.q=0,e=0;e<n.q;e++)xl.bk(n,t,e,0,0);for(t.r=0,i=0;i<n.r;i++)xl.ck(n,t,i,0,0,n.D[0][i],n.D[1][i],!1);n.Kb(t)},xl.fk=function(n,t){t.K=n.K,t.L=n.L,t.S=n.S,t.I=n.I,t.P=n.P,t.T=24&n.T},xl.gk=function(n,t){var e,i,s,r;for(e=0;e<n.r;e++)for(s=0;s<2;s++)if(n.D[s][e]==t){for(n.H[e]=512,i=0,r=0;r<n.r;r++)r!=e&&(n.D[0][r]===n.D[1-s][e]||n.D[1][r]===n.D[1-s][e])&&++i;0==i&&(xl.Pl(n,n.w[n.D[1-s][e]]),n.C[n.D[1-s][e]]=-1)}xl.Pl(n,n.w[t]),n.C[t]=-1,null!=n.v&&(n.v[t]=null),null!=n.t&&(n.t[t]=null),xl.ak(n),n.T=0},xl.hk=function(n,t,e){var i,s;return-1!=(i=xl.nk(n,t,e))?(0!=(512&n.u[i])?xl.mk(n):xl.gk(n,i),n.T=0,!0):-1!=(s=xl.ok(n,t,e))&&(0!=(n.u[n.D[0][s]]&n.u[n.D[1][s]]&512)?xl.mk(n):xl.kk(n,s),n.T=0,!0)},xl.ik=function(n,t){var e,i,s,r;if(0==t.length)return null;for(s=0,r=(i=t).length;s<r;++s)e=i[s],n.C[e]=-1;return xl.lk(n)},xl.jk=function(n,t){n.H[t]=512,xl.ak(n),n.T=0},xl.kk=function(n,t){var e,i,s;for(i=0;i<2;i++){for(e=0,s=0;s<n.r;s++)s!=t&&(n.D[0][s]===n.D[i][t]||n.D[1][s]===n.D[i][t])&&++e;0==e&&(xl.Pl(n,n.w[n.D[i][t]]),n.C[n.D[i][t]]=-1)}n.H[t]=512,xl.ak(n),n.T=0},xl.lk=function(n){var t,e,i;for(i=!1,t=0;t<n.q;t++)-1==n.C[t]&&(i=!0,xl.Pl(n,n.w[t]));for(e=0;e<n.r;e++)512==n.H[e]?i=!0:-1!=n.C[n.D[0][e]]&&-1!=n.C[n.D[1][e]]||(n.H[e]=512,i=!0);return i?(n.T=0,xl.ak(n)):null},xl.mk=function(n){var t,e;for(e=!1,t=0;t<n.q;t++)0!=(512&n.u[t])&&(n.C[t]=-1,e=!0);return e&&null!=xl.lk(n)},xl.nk=function(n,t,e){var i,s,r,a,o,l,f,g;for(a=-1,s=xl.Kk(n,n.q,n.r,xl.Jj),o=Pt,l=s*s/12,i=0;i<n.q;i++)(r=(t-(f=n.J[i].a))*(t-f)+(e-(g=n.J[i].b))*(e-g))<l&&r<o&&(o=r,a=i);return a},xl.ok=function(t,e,i){var s,r,a,o,l,f,g,u,h,d,c,b,D,H;for(u=-1,d=xl.Kk(t,t.q,t.r,xl.Jj),h=Pt,s=0;s<t.r;s++)c=t.J[t.D[0][s]].a,D=t.J[t.D[0][s]].b,f=(b=t.J[t.D[1][s]].a)-c,g=(H=t.J[t.D[1][s]].b)-D,r=n.Math.sqrt(f*f+g*g),f=e-(c+b)/2,g=i-(D+H)/2,n.Math.sqrt(f*f+g*g)>r/2||(b==c?l=n.Math.abs(c-e):(o=-(a=(H-D)/(c-b))*c-D,l=n.Math.abs((a*e+i+o)/n.Math.sqrt(a*a+1))),l<d&&l<h&&(h=l,u=s));return u},xl.pk=function(n,t){return((n.u[t]&Tt)>>>27)-1},xl.qk=function(n,t){return(49152&n.u[t])>>14},xl.rk=function(n,t){return n.s[t]},xl.sk=function(n,t){return 448&n.u[t]},xl.tk=function(n,t){var e;return null==n.t||null==n.t[t]?null:Jl.IHb((e=n.t[t],yf.XKb(),e))},xl.uk=function(n,t){return null==n.t?null:n.t[t]},xl.vk=function(n,t){return(n.u[t]&On)>>18!=1&&(n.u[t]&On)>>18!=2?-1:(n.u[t]&pt)>>20},xl.wk=function(n,t){return(n.u[t]&On)>>18},xl.xk=function(n,t){return xl.Ej[n.C[t]]},xl.yk=function(n,t){return null==n.v?null:n.v[t]},xl.zk=function(n,t){var e,i,s;if(null==n.v||null==n.v[t])return Rg(Cg(n.B[t],1),0)?"":xl.Ej[n.C[t]];for(s="",i=0;i<n.v[t].length;i++)i>0&&(kl.ITb(s),s+=(kl.ITb(","),",")),e=n.v[t][i],s=Jl.HHb(s,xl.Ej[e]);return s},xl.Ak=function(t,e){return n.Math.abs(t.w[e])},xl.Bk=function(n,t){return n.A[t]},xl.Ck=function(n,t){return 3&n.u[t]},xl.Dk=function(n,t){return n.B[t]},xl.Ek=function(n,t){return 48&n.u[t]},xl.Fk=function(n,t){return n.J[t].a},xl.Gk=function(n,t){return n.J[t].b},xl.Hk=function(n,t){return n.J[t].c},xl.Ik=function(n,t){return n.C[t]},xl.Jk=function(n){return xl.Kk(n,n.q,n.r,xl.Jj)},xl.Kk=function(n,t,e,i){return xl.Lk(n,t,e,i,n.J)},xl.Lk=function(n,t,e,i,s){var r,a,o,l,f,g,u,h,d,c;for(u=!1,h=0,f=0;f<e;f++)32!=n.H[f]&&0==(n.G[f]&qn)&&++h;if(0==h){for(g=0;g<e;g++)0==(n.G[g]&qn)&&++h;u=!0}if(0==h){if(t<2)return i;for(c=Pt,r=1;r<t;r++)for(a=0;a<r;a++)(d=xl.zh(s[r],s[a]))>0&&d<c&&(c=d);return c!=Pt?.6*c:i}for(o=0,l=0;l<e;l++)(u||32!=n.H[l])&&0==(n.G[l]&qn)&&(o+=xl.zh(s[n.D[1][l]],s[n.D[0][l]]));return o/h},xl.Mk=function(n,t,e){return xl.$m(n.J[t].a,n.J[t].b,n.J[e].a,n.J[e].b)},xl.Nk=function(n,t,e){return n.D[t][e]},xl.Ok=function(n,t){return((7680&n.G[t])>>9)+((122880&n.G[t])>>13)},xl.Pk=function(n,t){return(7680&n.G[t])>>9},xl.Qk=function(n,t){return(48&n.F[t])>>4},xl.Rk=function(n,t){return(768&n.F[t])>>8!=1&&(768&n.F[t])>>8!=2?-1:(n.F[t]&It)>>10},xl.Sk=function(n,t){return(768&n.F[t])>>8},xl.Tk=function(t,e){var i,s,r,a;return i=t.D[0][e],s=t.D[1][e],r=t.J[s].a-t.J[i].a,a=t.J[s].b-t.J[i].b,n.Math.sqrt(r*r+a*a)},xl.Uk=function(n,t,e){var i;for(i=0;i<n.r;i++)if((n.D[0][i]==t&&n.D[1][i]==e||n.D[0][i]==e&&n.D[1][i]==t)&&512!=n.H[i])return i;return-1},xl.Vk=function(n,t){switch(127&n.H[t]){case 1:case 64:return 1;case 2:return 2;case 4:return 3;case 8:return 4;case 16:return 5;default:return 0}},xl.Wk=function(n,t){return 3&n.F[t]},xl.Xk=function(n,t){return n.G[t]},xl.Yk=function(n,t){return n.H[t]},xl.Zk=function(n,t){return 127&n.H[t]},xl.$k=function(n,t){var e,i,s,r,a;if(0==n.q)return null;for(i=n.J[0].a,r=n.J[0].b,s=n.J[0].a,a=n.J[0].b,e=1;e<n.q;e++)i>n.J[e].a?i=n.J[e].a:s<n.J[e].a&&(s=n.J[e].a),r>n.J[e].b?r=n.J[e].b:a<n.J[e].b&&(a=n.J[e].b);return t?(t.c=i,t.d=r,t.b=s-i,t.a=a-r):t=new Kl.JG(i,r,s-i,a-r),t},xl._k=function(n,t){var e;return null==(e=n.C[t]<xl.Fj.length?xl.Fj[n.C[t]]:null)?6:e[e.length-1]},xl.al=function(n,t,e){return xl.bl(n,t,e,n.C[t])},xl.bl=function(t,e,i,s){var r,a;return s>=171&&s<=190?0:(a=0,32==(48&t.u[e])&&(a-=1),(16==(48&t.u[e])||48==(48&t.u[e]))&&(a-=2),0==(r=t.s[e])&&t.K&&(Ig(Cg(t.B[e],bn),jn)&&(r=-1),Ig(Cg(t.B[e],bn),Hn)&&(r=1)),7==s||8==s||9==s?a+=r:6==s||14==s||32==s?a-=n.Math.abs(r):15==s||33==s?i-a-r<=3?a+=r:a-=r:16==s||34==s||52==s?i-a-r<=4?a+=r:a-=n.Math.abs(r):17==s||35==s||53==s?i-a-r<=5?a+=r:a-=n.Math.abs(r):a-=r,a)},xl.cl=function(n,t){var e;return(e=xl.dl(n,t))+xl.bl(n,t,e,n.C[t])},xl.dl=function(n,t){var e,i;return-1==(e=((n.u[t]&Tt)>>>27)-1)&&(e=null==(i=n.C[t]<xl.Fj.length?xl.Fj[n.C[t]]:null)?6:i[i.length-1]),e},xl.el=function(n,t){var e,i,s,r,a;for(r=xl.Gl(n,n.D[0][t])||xl.Gl(n,n.D[1][t])?5:3,i=0;i<2;i++)e=n.D[i][t],r>(s=xl.Vk(n,t)+((a=xl.dl(n,e))+xl.bl(n,e,a,n.C[e]))-xl.fo(n,e))&&(r=s);return r},xl.fl=function(n,t){return 0!=(n.u[t]&J)},xl.gl=function(n,t){var e,i,s;return i=xl.el(n,t),s=(e=xl.yl(n,n.D[0][t])||xl.yl(n,n.D[1][t]))?32:1,16==n.H[t]?(n.H[t]=s,n.T=0,!0):8==n.H[t]?(n.H[t]=i>4?16:s,n.T=0,!0):4==n.H[t]?(n.H[t]=i>3?8:s,n.T=0,!0):2==n.H[t]&&(n.H[t]=386,n.T&=7,0==(128&n.F[t]))||(386==n.H[t]?(n.H[t]=i>2?4:s,n.T=0,!0):0!=(384&n.H[t])?(n.H[t]=1,n.T&=7,!0):!(!e&&i<2)&&(1==n.H[t]?(n.H[t]=2,n.T=0,!0):!(i<1)&&(32==n.H[t]&&(n.H[t]=1,n.T=0,!0))))},xl.hl=function(n){var t;for(n.T=0,n.C=vf(yl.tlb,z,6,n.M,15,1),n.s=vf(yl.tlb,z,6,n.M,15,1),n.w=vf(yl.tlb,z,6,n.M,15,1),n.J=vf(yl.Mlb,Mt,32,n.M,0,1),t=0;t<n.M;t++)n.J[t]=new xl.Jh;n.A=vf(yl.tlb,z,6,n.M,15,1),n.u=vf(yl.tlb,z,6,n.M,15,1),n.B=vf(yl.ulb,st,6,n.M,14,1),n.v=null,n.t=null,n.D=Yf(yl.tlb,[ot,z],[8,6],15,[2,n.N],2),n.H=vf(yl.tlb,z,6,n.N,15,1),n.F=vf(yl.tlb,z,6,n.N,15,1),n.G=vf(yl.tlb,z,6,n.N,15,1)},xl.il=function(n,t){n.T&=~t},xl.jl=function(n){var t;for(t=0;t<n.q;t++)if(0!=n.J[t].c)return!0;return!1},xl.kl=function(n,t){return 0!=(n.u[t]&Nt)},xl.ll=function(n,t){return-1==n.C[t]},xl.ml=function(n,t){return 0!=(4&n.u[t])},xl.nl=function(n,t){return 0!=(n.u[t]&wt)},xl.ol=function(n,t){return n.w[t]<0},xl.pl=function(n,t){return 0!=(n.F[t]&Lt)},xl.ql=function(n,t){return 0!=(n.G[t]&qn)},xl.rl=function(n,t){return 0!=(n.F[t]&J)},xl.sl=function(n,t){return 512==n.H[t]},xl.tl=function(n,t){return 0!=(4&n.F[t])},xl.ul=function(n,t){return 0!=(n.F[t]&gt)},xl.vl=function(n,t){var e,i,s,r;if(n.K){if(Rg(Cg(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(s=0,r=(i=n.v[t]).length;s<r;++s)if(e=i[s],!xl.bn(e))return!1}return xl.bn(n.C[t])},xl.wl=function(n,t){var e,i,s,r;if(n.K){if(Rg(Cg(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(s=0,r=(i=n.v[t]).length;s<r;++s)if(e=i[s],!xl.cn(e))return!1}return xl.cn(n.C[t])},xl.xl=function(n,t){return 0!=(n.u[t]&gt)},xl.yl=function(n,t){var e,i,s,r;if(n.K){if(Rg(Cg(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(s=0,r=(i=n.v[t]).length;s<r;++s)if(!((e=i[s])>=3&&e<=4||e>=11&&e<=13||e>=19&&e<=31||e>=37&&e<=51||e>=55&&e<=84||e>=87&&e<=112))return!1}return xl.dn(n.C[t])},xl.zl=function(n,t){return 0==n.A[t]},xl.Al=function(n,t){var e,i,s,r;if(n.K){if(Rg(Cg(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(s=0,r=(i=n.v[t]).length;s<r;++s)if(!(1==(e=i[s])||e>=5&&e<=9||e>=14&&e<=17||e>=32&&e<=35||e>=52&&e<=53))return!1}return xl.en(n.C[t])},xl.Bl=function(n){var t;for(t=0;t<n.q;t++)switch(n.C[t]){case 1:case 5:case 6:case 7:case 8:case 9:case 14:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:continue;default:return!1}return!0},xl.Cl=function(n,t){return 0!=(512&n.u[t])},xl.Dl=function(n,t){return 0!=(n.u[n.D[0][t]]&n.u[n.D[1][t]]&512)},xl.El=function(n,t){return 257==n.H[t]||129==n.H[t]},xl.Fl=function(n,t,e){return(257==n.H[t]||129==n.H[t])&&n.D[0][t]==e},xl.Gl=function(n,t){var e,i,s,r;if(n.K){if(Rg(Cg(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(s=0,r=(i=n.v[t]).length;s<r;++s)if(!((e=i[s])>=21&&e<=30||e>=39&&e<=48||57==e||e>=72&&e<=80||89==e||e>=104&&e<=112))return!1}return xl.fn(n.C[t])},xl.Hl=function(n,t){n.C[t]=-1},xl.Il=function(n,t){n.H[t]=512},xl.Jl=function(t,e,i,s,r,a,o,l){var f,g,u,h,d,c,b,D,H,j;for(e!=s&&(H=t.J[e].a-t.J[s].a,j=t.J[e].b-t.J[s].b,l=n.Math.sqrt(H*H+j*j)),f=e,u=3!=xl.Im(t,e),D=1;D<i;D++){for(d=t.J[f].a+l*n.Math.sin(a),c=t.J[f].b+l*n.Math.cos(a),b=-1,h=0;h<t.q;h++)if(n.Math.abs(d-t.J[h].a)<4&&n.Math.abs(c-t.J[h].b)<4){b=h;break}-1==b&&(b=xl.Lj(t,d,c,0),t.J[b].a=d,t.J[b].b=c,t.J[b].c=0),-1==(g=xl.Uk(t,f,b))&&(g=xl.Oj(t,f,b,xl.yl(t,f)||xl.yl(t,b)?32:1),r&&(u&&xl.Im(t,t.D[0][g])<4&&xl.Im(t,t.D[1][g])<3&&(t.H[g]=2),u=!u)),f=b,a+=o}-1==(g=xl.Uk(t,f,s))&&(g=xl.Oj(t,f,s,xl.yl(t,f)||xl.yl(t,s)?32:1)),r&&u&&xl.Im(t,t.D[0][g])<4&&xl.Im(t,t.D[1][g])<4&&(t.H[g]=2)},xl.Kl=function(n,t,e){var i,s;if(1!=xl.Vk(n,t))return!1;if(0!=(3&n.u[e]))return!0;for(s=0;s<n.r;s++)if(s!=t&&2==n.H[s]&&(n.D[0][s]==e&&0!=(3&n.u[n.D[1][s]])||n.D[1][s]==e&&0!=(3&n.u[n.D[0][s]])))return!0;for(i=0;i<n.r;i++)if(i!=t&&1==n.H[i]&&(n.D[0][i]==e||n.D[1][i]==e)&&0!=(3&n.F[i]))return!0;return!1},xl.Ll=function(n){var t;for(t=0;t<n.q;t++)n.u[t]&=-449},xl.Ml=function(n){var t;for(t=0;t<n.q;t++)n.u[t]&=-131073},xl.Nl=function(n){var t;for(t=0;t<n.q;t++)n.u[t]&=-513},xl.Ol=function(n){var t;for(t=0;t<n.r;t++)n.F[t]&=-98305},xl.Pl=function(t,e){var i;for(i=0;i<t.q;i++)n.Math.abs(t.w[i])==n.Math.abs(e)&&(t.w[i]=0)},xl.Ql=function(n){var t,e,i,s;for(s=!1,e=0;e<n.q;e++)Rg(Cg(n.B[e],tn),0)&&(n.C[e]=-1,s=!0);for(s&&xl.lk(n),null!=n.v&&(n.v=null,s=!0),t=0;t<n.q;t++)Rg(n.B[t],0)&&(n.B[t]=0,s=!0);for(i=0;i<n.r;i++)0!=n.G[i]&&(n.G[i]=0,s=!0),64==n.H[i]&&(n.H[i]=1,s=!0);return s&&(n.T=0),s},xl.Rl=function(n,t){var e,i,s,r,a,o,l,f,g;if(0==t)return 0;for(o=null,i=0;i<n.q;i++)(n.u[i]&On)>>18==t&&(null==o&&(o=vf(yl.Lwb,nn,6,32,16,1)),o[(n.u[i]&On)>>18!=1&&(n.u[i]&On)>>18!=2?-1:(n.u[i]&pt)>>20]=!0);for(r=0;r<n.r;r++)(768&n.F[r])>>8==t&&(null==o&&(o=vf(yl.Lwb,nn,6,32,16,1)),o[(768&n.F[r])>>8!=1&&(768&n.F[r])>>8!=2?-1:(n.F[r]&It)>>10]=!0);if(g=0,null!=o){for(f=vf(yl.tlb,z,6,32,15,1),l=0;l<32;l++)o[l]&&(f[l]=g++);for(e=0;e<n.q;e++)(n.u[e]&On)>>18==t&&(a=f[(n.u[e]&On)>>18!=1&&(n.u[e]&On)>>18!=2?-1:(n.u[e]&pt)>>20],n.u[e]&=-32505857,n.u[e]|=a<<20);for(s=0;s<n.r;s++)(768&n.F[s])>>8==t&&(a=f[(768&n.F[s])>>8!=1&&(768&n.F[s])>>8!=2?-1:(n.F[s]&It)>>10],n.F[s]&=-31745,n.F[s]|=a<<10)}return g},xl.Sl=function(n,t){var e;for(e=0;e<n.q;e++)n.J[e].a*=t,n.J[e].b*=t},xl.Tl=function(n,t){n.q=t,n.T=0},xl.Ul=function(n,t){n.r=t,n.T=0},xl.Vl=function(n,t,e){e>=-1&&e<=14&&(n.u[t]&=-2013265921,n.u[t]|=1+e<<27,6==n.C[t]&&(-1!=e&&0!=e&&2!=e&&4!=e||(n.u[t]&=-49,2==e&&(n.u[t]|=16))))},xl.Wl=function(n,t,e){n.u[t]&=-49153,n.u[t]|=e<<14},xl.Xl=function(n,t,e){n.s[t]=e,n.T=0},xl.Yl=function(n,t,e){n.u[t]&=-449,n.u[t]|=e},xl.Zl=function(n,t,e){e?n.u[t]|=Nt:n.u[t]&=Ut,n.T&=7},xl.$l=function(n,t,e){var i,s;null!=e&&(0==kl.TTb(e).length?e=null:(0!=(i=xl.an(e,321))&&Jl.KHb(e,xl.Ej[i])||Jl.KHb(e,"?"))&&(xl.om(n,t,i),e=null)),null==e?null!=n.t&&(n.t[t]=null):(null==n.t&&(n.t=vf(yl.plb,j,10,n.M,0,2)),n.t[t]=kl.uTb((s=e,yf.XKb(),s)))},xl._l=function(n,t,e){null!=e&&0==e.length&&(e=null),null==e?null!=n.t&&(n.t[t]=null):(null==n.t&&(n.t=vf(yl.plb,j,10,n.M,0,2)),n.t[t]=e)},xl.am=function(n,t,e,i){var s,r,a;if(0==e)n.u[t]&=yt,n.u[t]|=e<<18;else{if(i>=32)return;if(-1==i){for(a=-1,r=0;r<n.q;r++)r!=t&&e==(n.u[r]&On)>>18&&a<((n.u[r]&On)>>18!=1&&(n.u[r]&On)>>18!=2?-1:(n.u[r]&pt)>>20)&&(a=(n.u[r]&On)>>18!=1&&(n.u[r]&On)>>18!=2?-1:(n.u[r]&pt)>>20);for(s=0;s<n.r;s++)e==(768&n.F[s])>>8&&a<((768&n.F[s])>>8!=1&&(768&n.F[s])>>8!=2?-1:(n.F[s]&It)>>10)&&(a=(768&n.F[s])>>8!=1&&(768&n.F[s])>>8!=2?-1:(n.F[s]&It)>>10);if((i=a+1)>=32)return}n.u[t]&=yt,n.u[t]|=e<<18|i<<20}n.T&=7},xl.bm=function(n,t,e){null==n.v&&(n.v=vf(yl.tlb,ot,8,n.M,0,2)),kl.nTb(e,kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[]))),n.v[t]=e,n.T=0,n.K=!0},xl.cm=function(n,t,e,i){var s;if(null!=e){if(1==e.length&&!i)return s=e[0],n.C[t]!=s&&xl.Yj(n,t,s,0,-1,0),void(null!=n.v&&(n.v[t]=null));null==n.v&&(n.v=vf(yl.tlb,ot,8,n.M,0,2)),n.v[t]=e,i&&(n.B[t]=Eg(n.B[t],1)),n.T=0,n.K=!0}else null!=n.v&&(n.v[t]=null)},xl.dm=function(n,t,e,i){n.w[t]=i?-e:e},xl.em=function(n,t,e){e?n.u[t]|=gt:n.u[t]&=-131073},xl.fm=function(n,t,e){n.A[t]=e,n.T&=1==n.C[t]?0:7},xl.gm=function(n,t,e,i){n.u[t]&=-8,3!=e&&(n.u[t]&=Ut),n.u[t]|=e,i&&(n.u[t]|=4)},xl.hm=function(n,t,e,i){n.B[t]=i?Eg(n.B[t],e):Cg(n.B[t],kg(e)),n.T=0,n.K=!0},xl.im=function(n,t,e){n.u[t]&=-49,n.u[t]|=e,n.T&=7},xl.jm=function(n,t,e){e?n.u[t]|=512:n.u[t]&=-513},xl.km=function(n,t,e){n.u[t]&=-67108865,e&&(n.u[t]|=wt)},xl.lm=function(n,t,e){n.J[t].a=e,n.T&=7},xl.mm=function(n,t,e){n.J[t].b=e,n.T&=7},xl.nm=function(n,t,e){n.J[t].c=e,n.T&=7},xl.om=function(n,t,e){e>=0&&e<=190&&(151==e||152==e?(n.C[t]=1,n.A[t]=e-149):(n.C[t]=e,n.A[t]=0),n.u[t]&=-2013265921,n.T=0)},xl.pm=function(n,t,e,i){n.D[t][e]=i,n.T=0},xl.qm=function(n,t,e){e?n.F[t]|=Lt:n.F[t]&=-32769},xl.rm=function(n,t,e){n.F[t]&=-49,n.F[t]|=e<<4},xl.sm=function(n,t,e,i){var s,r,a;if(0==e)n.F[t]&=-32513,n.F[t]|=e<<8;else{if(i>=32)return;if(-1==i){for(a=-1,r=0;r<n.q;r++)e==(n.u[r]&On)>>18&&a<((n.u[r]&On)>>18!=1&&(n.u[r]&On)>>18!=2?-1:(n.u[r]&pt)>>20)&&(a=(n.u[r]&On)>>18!=1&&(n.u[r]&On)>>18!=2?-1:(n.u[r]&pt)>>20);for(s=0;s<n.r;s++)s!=t&&e==(768&n.F[s])>>8&&a<((768&n.F[s])>>8!=1&&(768&n.F[s])>>8!=2?-1:(n.F[s]&It)>>10)&&(a=(768&n.F[s])>>8!=1&&(768&n.F[s])>>8!=2?-1:(n.F[s]&It)>>10);if((i=a+1)>=32)return}n.F[t]&=-32513,n.F[t]|=e<<8|i<<10}n.T&=7},xl.tm=function(n,t,e){e?n.F[t]|=J:n.F[t]&=-65537},xl.um=function(n,t,e){n.H[t]=1==e?1:2==e?2:3==e?4:32,n.T=0},xl.vm=function(n,t,e,i){n.F[t]&=-131080,n.F[t]|=e,i&&(n.F[t]|=4)},xl.wm=function(n,t){n.F[t]|=gt};xl.xm=function(n,t,e,i){i?n.G[t]|=e:n.G[t]&=~e,n.T=0,n.K=!0},xl.ym=function(n,t,e){n.H[t]=e,n.T=0},xl.zm=function(n,t){n.I=t},xl.Am=function(n,t){n.K!=t&&(n.K=t,t||xl.Ql(n),n.T=0)},xl.Bm=function(n,t){n.T=t},xl.Cm=function(n,t){n.S=t},xl.Dm=function(n,t){var e,i;for(n.C=xl.Um(n.C,t),n.s=xl.Um(n.s,t),n.w=xl.Um(n.w,t),i=n.J.length,n.J=xl.Wm(n.J,t),e=i;e<t;e++)n.J[e]=new xl.Jh;n.A=xl.Um(n.A,t),n.u=xl.Um(n.u,t),n.B=xl.Vm(n.B,t),null!=n.v&&(n.v=xl.Ym(n.v,t)),null!=n.t&&(n.t=xl.Xm(n.t,t)),n.M=t},xl.Em=function(n,t){n.D[0]=xl.Um(n.D[0],t),n.D[1]=xl.Um(n.D[1],t),n.H=xl.Um(n.H,t),n.F=xl.Um(n.F,t),n.G=xl.Um(n.G,t),n.N=t},xl.Fm=function(n,t){n.O=t},xl.Gm=function(n,t){n.P=t},xl.Hm=function(n,t){n.u[t]|=J},xl.Im=function(n,t){var e,i;for(i=0,e=0;e<n.r;e++)(n.D[0][e]==t||n.D[1][e]==t)&&(i+=xl.Vk(n,e));return i},xl.Jm=function(n){var t,e,i;for(e=!1,i=!1,t=0;t<n.q;t++)0!=n.A[t]&&(n.A[t]=0,e=!0,1==n.C[t]&&(i=!0));return i&&(n.T=0),e},xl.Km=function(n,t,e){return xl.yl(n,t)||xl.yl(n,e)?32:1},xl.Lm=function(n,t,e){var i,s,r,a,o,l;for(a=n.C[t],n.C[t]=n.C[e],n.C[e]=a,a=n.s[t],n.s[t]=n.s[e],n.s[e]=a,a=n.A[t],n.A[t]=n.A[e],n.A[e]=a,a=n.u[t],n.u[t]=n.u[e],n.u[e]=a,l=n.B[t],n.B[t]=n.B[e],n.B[e]=l,a=n.w[t],n.w[t]=n.w[e],n.w[e]=a,r=n.J[t],n.J[t]=n.J[e],n.J[e]=r,null!=n.v&&(o=n.v[t],n.v[t]=n.v[e],n.v[e]=o),null!=n.t&&(o=n.t[t],n.t[t]=n.t[e],n.t[e]=o),i=0;i<n.r;i++)for(s=0;s<2;s++)n.D[s][i]==t?n.D[s][i]=e:n.D[s][i]==e&&(n.D[s][i]=t);n.T=0},xl.Mm=function(n,t,e){var i;i=n.D[0][t],n.D[0][t]=n.D[0][e],n.D[0][e]=i,i=n.D[1][t],n.D[1][t]=n.D[1][e],n.D[1][e]=i,i=n.H[t],n.H[t]=n.H[e],n.H[e]=i,i=n.F[t],n.F[t]=n.F[e],n.F[e]=i,i=n.G[t],n.G[t]=n.G[e],n.G[e]=i,n.T=0},xl.Nm=function(n,t,e){var i;for(i=0;i<n.q;i++)n.J[i].a+=t,n.J[i].b+=e;n.U+=t,n.V+=e},xl.Om=function(n,t,e){var i,s;switch(s=127&e,i=xl.el(n,t),s){case 1:case 64:return i>=1;case 2:return i>=2;case 4:return i>=3;case 8:return i>=4;case 16:return i>=5;case 32:return!0;default:return!1}},xl.Pm=function(t,e,i,s){var r,a,o;for(r=0;r<t.q;r++)s&&0==(512&t.u[r])||(o=t.R[r]*e,a=t.Q[r]-i,t.J[r].a=t.U+o*n.Math.sin(a),t.J[r].b=t.V+o*n.Math.cos(a));s&&(t.T&=7)},xl.Qm=function(t,e,i){var s,r,a;for(t.U=e,t.V=i,t.Q=vf(yl.rlb,X,6,t.q,15,1),t.R=vf(yl.rlb,X,6,t.q,15,1),s=0;s<t.q;s++)r=e-t.J[s].a,a=i-t.J[s].b,t.R[s]=n.Math.sqrt(r*r+a*a),t.Q[s]=xl.$m(e,i,t.J[s].a,t.J[s].b)},xl.Rm=function(){this.M=this.N=256,xl.hl(this)},xl.Sm=function(t,e){this.M=n.Math.max(1,t),this.N=n.Math.max(1,e),xl.hl(this)},xl.Um=function(t,e){var i;return i=vf(yl.tlb,z,6,e,15,1),Jl.wIb(t,0,i,0,n.Math.min(t.length,e)),i},xl.Vm=function(t,e){var i;return i=vf(yl.ulb,st,6,e,14,1),Jl.wIb(t,0,i,0,n.Math.min(t.length,e)),i},xl.Wm=function(n,t){var e,i;for(e=vf(yl.Mlb,Mt,32,t,0,1),i=0;i<n.length;i++)n[i]&&(e[i]=new xl.Lh(n[i]));return e},xl.Xm=function(n,t){var e,i;for(e=vf(yl.plb,j,10,t,0,2),i=0;i<n.length;i++)null!=n[i]&&(e[i]=vf(yl.plb,ft,6,n[i].length,15,1),Jl.wIb(n[i],0,e[i],0,n[i].length));return e},xl.Ym=function(n,t){var e,i;for(e=vf(yl.tlb,ot,8,t,0,2),i=0;i<n.length;i++)null!=n[i]&&(e[i]=vf(yl.tlb,z,6,n[i].length,15,1),Jl.wIb(n[i],0,e[i],0,n[i].length));return e},xl.Zm=function(n){return xl.Kj(),n>=0&&n<xl.Fj.length&&null!=xl.Fj[n]?xl.Fj[n]:n>=171&&n<=190?xl.Dj:xl.Hj},xl.$m=function(t,e,i,s){var r,a,o;return xl.Kj(),a=i-t,0!=(o=s-e)?(r=n.Math.atan(a/o),o<0&&(a<0?r-=an:r+=an)):r=a>0?on:Gn,r},xl._m=function(n,t){var e;for(xl.Kj(),e=n-t;e<Jt;)e+=rn;for(;e>an;)e-=rn;return e},xl.an=function(n,t){var e,i,s,r,a;if(xl.Kj(),0!=(256&t)&&Jl.KHb(n,"?"))return 0;for(i=1;i<=128;i++)if(!Jl.KHb(n,Ct)&&Jl.LHb(n,xl.Ej[i]))return i;if(0!=(2&t))for(s=129;s<=144;s++)if(Jl.LHb(n,xl.Ej[s]))return s;if(0!=(4&t))for(r=146;r<=148;r++)if(Jl.LHb(n,xl.Ej[r]))return r;if(0!=(1&t))for(a=151;a<=152;a++)if(Jl.LHb(n,xl.Ej[a]))return a;if(0!=(32&t)&&Jl.LHb(n,xl.Ej[153]))return 153;if(0!=(8&t)&&Jl.LHb(n,xl.Ej[154]))return 154;if(0!=(16&t)&&Jl.LHb(n,xl.Ej[145]))return 145;if(0!=(128&t)&&Jl.LHb(n,xl.Ej[159]))return 159;if(0!=(64&t))for(e=171;e<=190;e++)if(Jl.LHb(n,xl.Ej[e]))return e;return 0},xl.bn=function(n){switch(xl.Kj(),n){case 7:case 8:case 9:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:return!0}return!1},xl.cn=function(n){return xl.Kj(),1!=n&&6!=n&&(!xl.bn(n)&&(2!=n&&10!=n&&18!=n&&36!=n&&54!=n&&!(n>103)))},xl.dn=function(n){return n>=3&&n<=4||n>=11&&n<=13||n>=19&&n<=31||n>=37&&n<=51||n>=55&&n<=84||n>=87&&n<=112},xl.en=function(n){return 1==n||n>=5&&n<=9||n>=14&&n<=17||n>=32&&n<=35||n>=52&&n<=53},xl.fn=function(n){return n>=21&&n<=30||n>=39&&n<=48||57==n||n>=72&&n<=80||89==n||n>=104&&n<=112},zf(113,1,{113:1,4:1}),o.Kb=function(n){xl.fk(this,n)},o.Lb=function(n){return 64==this.H[n]},o.q=0,o.r=0,o.I=0,o.K=!1,o.L=!1,o.M=0,o.N=0,o.O=0,o.S=!1,o.T=0,o.U=0,o.V=0,xl.Jj=24,yl.Ylb=lg(113),xl.hn=function(n,t,e,i){var s,r,a,o,l,f,g,u,h;for(xl.iu(t,1),null==i&&(i=vf(yl.tlb,z,6,t.q,15,1)),o=xl.Rl(n,1),l=xl.Rl(n,2),h=vf(yl.Lwb,nn,6,t.q,16,1),(f=vf(yl.tlb,z,6,t.q,15,1))[0]=e,h[e]=!0,i[e]=xl.bk(t,n,e,o,l),a=0,g=0;a<=g;){for(u=0;u<xl.wn(t,f[a]);u++)h[r=t.i[f[a]][u]]||(f[++g]=r,h[r]=!0,i[r]=xl.bk(t,n,r,o,l));++a}for(s=0;s<t.r;s++)h[t.D[0][s]]&&xl.ck(t,n,s,o,l,null==i?t.D[0][s]:i[t.D[0][s]],null==i?t.D[1][s]:i[t.D[1][s]],!1);xl.Rl(n,1),xl.Rl(n,2),n.T=0},xl.jn=function(n){var t,e,i,s,r,a,o,l,f,g,u,h;for(n.j=vf(yl.tlb,z,6,n.q,15,1),n.e=vf(yl.tlb,z,6,n.q,15,1),n.i=vf(yl.tlb,ot,8,n.q,0,2),n.k=vf(yl.tlb,ot,8,n.q,0,2),n.n=vf(yl.tlb,ot,8,n.q,0,2),n.o=vf(yl.tlb,z,6,n.f,15,1),f=vf(yl.tlb,z,6,n.q,15,1),a=0;a<n.r;a++)++f[n.D[0][a]],++f[n.D[1][a]];for(i=0;i<n.q;i++)n.i[i]=vf(yl.tlb,z,6,f[i],15,1),n.k[i]=vf(yl.tlb,z,6,f[i],15,1),n.n[i]=vf(yl.tlb,z,6,f[i],15,1);for(u=!1,o=0;o<n.g;o++)if(0!=(h=xl.Vk(n,o)))for(g=0;g<2;g++)e=n.D[g][o],t=n.e[e],n.n[e][t]=h,n.i[e][t]=n.D[1-g][o],n.k[e][t]=o,++n.e[e],++n.j[e],e<n.f&&(h>1?n.o[e]+=h-1:64==n.H[o]&&(n.o[e]=1));else u=!0;for(l=n.g;l<n.r;l++)if(0!=(h=xl.Vk(n,l)))for(g=0;g<2;g++)e=n.D[g][l],t=n.e[e],n.n[e][t]=h,n.i[e][t]=n.D[1-g][l],n.k[e][t]=l,++n.e[e],n.D[1-g][l]<n.f&&++n.j[e];else u=!0;if(u){for(t=vf(yl.tlb,z,6,n.q,15,1),s=0;s<n.q;s++)t[s]=n.e[s];for(r=0;r<n.r;r++)if(0==(h=xl.Vk(n,r)))for(g=0;g<2;g++)e=n.D[g][r],n.n[e][t[e]]=h,n.i[e][t[e]]=n.D[1-g][r],n.k[e][t[e]]=r,++t[e]}},xl.kn=function(t,e,i){var s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p;for(xl.iu(t,1),i&&(e=!0),f=0;f<t.r;f++)if(1==(g=xl.Vk(t,f))||2==g){if(t.s[t.D[0][f]]>0&&t.s[t.D[1][f]]<0)a=t.D[0][f],o=t.D[1][f];else{if(!(t.s[t.D[0][f]]<0&&t.s[t.D[1][f]]>0))continue;a=t.D[1][f],o=t.D[0][f]}if(xl.yl(t,a)||xl.yl(t,o))continue;if(t.C[a]<9&&xl.fo(t,a)>3||t.C[o]<9&&xl.fo(t,o)>3)continue;h=0!=xl.$n(t,a),t.s[a]-=1,t.s[o]+=1,h||(m=t.H[f],t.H[f]=1==g?2:4,129!=m&&257!=m||(p=t.D[0][f],j=xl.Zo(t,p,!1),t.D[0][j]!=p&&(t.D[1][j]=t.D[0][j],t.D[1][j]=p))),t.T=0}for(A=0,D=0,c=0,r=0;r<t.q;r++)A+=t.s[r],t.s[r]<0&&!xl.yo(t,r)&&(++D,xl.vl(t,r)&&(c-=t.s[r]));if(!e&&0!=A)throw og(new Jl.Xz("molecule's overall charges are not balanced"));for(xl.iu(t,1),C=0,T=i?A+c:c,l=0;l<t.q;l++)t.s[l]>0&&!xl.xo(t,l)&&xl.vl(t,l)&&0!=(u=n.Math.min(xl.$n(t,l),t.s[l]))&&T>=u&&(A-=u,C-=u,T-=u,t.s[l]-=u,t.T&=1);if((H=i?A:C)<0){for(b=vf(yl.tlb,z,6,D,15,1),D=0,a=0;a<t.q;a++)t.s[a]<0&&!xl.yo(t,a)&&(b[D++]=(t.C[a]<<22)+a);for(kl.nTb(b,kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[]))),d=b.length-1;H<0&&d>=b.length-D;d--)s=b[d]&Bt,xl.vl(t,s)&&(A+=u=n.Math.min(-H,-t.s[s]),H+=u,t.s[s]+=u,t.T&=1)}return A},xl.ln=function(n){var t,e,i,s,r,a,o,l,f,g,u,h,d;if(!n.K)return!1;for(e=0;e<n.q;e++)(d=xl.dl(n,e))+xl.bl(n,e,d,n.C[e])-xl.fo(n,e)<=0&&(0!=n.s[e]||5!=n.C[e]&&(7!=(s=n.C[e])&&15!=s&&33!=s)&&(8!=(i=n.C[e])&&16!=i&&34!=i&&52!=i))&&(n.B[e]=Cg(n.B[e],-6145));for(a=!1,t=0;t<n.f;t++)if(o=n.e[t]-n.j[t],!n.S&&o>0)for(Ig(Cg(n.B[t],zn),0)&&(g=Ig(Cg(n.B[t],dn),896)?3:Ig(Cg(n.B[t],dn),384)?2:Ig(Cg(n.B[t],128),128)?1:0,l=(d=xl.dl(n,t))+xl.bl(n,t,d,n.C[t])-xl.fo(n,t),0==n.s[t]&&Ig(Cg(n.B[t],bn),0)&&6!=n.C[t]&&++l,(u=o)>3-g&&(u=3-g),u>l+o-g&&(u=l+o-g),u>0&&(h=Eg(h=0==g?0:xg(Cg(n.B[t],dn),u),yl.$wb((3==u?7:2==o?3:1)<<7)),n.B[t]=Cg(n.B[t],-1921),n.B[t]=Eg(n.B[t],Cg(dn,h)))),f=n.j[t];f<n.e[t];f++)r=n.k[t][f],1==n.H[r]&&(n.C[n.i[t][f]]=-1,n.H[r]=512,a=!0);return a&&xl.ak(n),a},xl.mn=function(n,t){var e,i,s,r;if(2!=n.o[t]||2!=n.j[t]||2!=n.n[t][0]){if(0==n.o[t]||n.C[t]>=15)for(s=0;s<n.e[t];s++)i=n.k[t][s],(257==n.H[i]||129==n.H[i])&&n.D[0][i]==t&&n.D[0][i]==t&&(n.H[i]=1)}else for(s=0;s<2;s++)if(-1!=(e=xl.rn(n,t,n.i[t][s])))for(r=0;r<n.j[e];r++)i=n.k[e][r],(257==n.H[i]||129==n.H[i])&&n.D[0][i]==e&&(n.H[n.k[e][r]]=1)},xl.nn=function(n,t,e,i,s){var r,a,o,l,f,g,u,h;for(xl.iu(n,i?7:1),t.v=null,n.K&&xl.Am(t,!0),l=e.length,null==s&&(s=vf(yl.tlb,z,6,l,15,1)),t.q=0,r=0;r<l;r++)if(e[r]){if(s[r]=xl.bk(n,t,r,0,0),1==n.C[r]&&(h=xl.fo(n,r))>1)for(u=0;u<n.e[r];u++)if(!e[n.i[r][u]]){xl.Vl(t,s[r],h);break}}else s[r]=-1;for(g=vf(yl.tlb,z,6,n.r,15,1),Fl.OOb(g,g.length,-1),t.r=0,f=0;f<n.r;f++)a=n.D[0][f],o=n.D[1][f],a<l&&o<l&&(e[a]&&e[o]?g[f]=xl.ck(n,t,f,0,0,null==s?n.D[0][f]:s[n.D[0][f]],null==s?n.D[1][f]:s[n.D[1][f]],i):0!=n.s[a]&&0!=n.s[o]&&n.s[a]<0^n.s[o]<0&&(e[a]&&(t.s[s[a]]+=n.s[a]<0?1:-1),e[o]&&(t.s[s[o]]+=n.s[o]<0?1:-1)));xl.fk(n,t),n.d&&(t.T=0),t.T=0,xl.Rl(t,1),xl.Rl(t,2),t.q!=l&&xl.Am(t,!0),xl.ap(n,t,l,s,g),xl._o(n,t,l,s),i&&xl.je(new xl.te(t),null,!1)},xl.on=function(n,t,e,i,s){var r,a,o,l,f,g,u,h;for(xl.iu(n,i?7:1),t.v=null,n.K&&xl.Am(t,!0),null==s&&(s=vf(yl.tlb,z,6,n.q,15,1)),t.q=0,r=0;r<n.q;r++)for(s[r]=-1,g=0;g<n.j[r];g++)if(e[n.k[r][g]]){if(s[r]=xl.bk(n,t,r,0,0),1==n.C[r]&&(h=xl.fo(n,r))>1)for(u=0;u<n.e[r];u++)if(!e[n.k[r][u]]){xl.Vl(t,s[r],h);break}break}for(f=vf(yl.tlb,z,6,n.r,15,1),t.r=0,l=0;l<n.r;l++)e[l]?f[l]=xl.ck(n,t,l,0,0,null==s?n.D[0][l]:s[n.D[0][l]],null==s?n.D[1][l]:s[n.D[1][l]],i):(f[l]=-1,a=n.D[0][l],o=n.D[1][l],-1==s[a]^-1==s[o]&&0!=n.s[a]&&0!=n.s[o]&&n.s[a]<0^n.s[o]<0&&(-1!=s[a]&&(t.s[s[a]]+=n.s[a]<0?1:-1),-1!=s[o]&&(t.s[s[o]]+=n.s[o]<0?1:-1)));return xl.fk(n,t),n.d&&(t.T=0),t.T=0,xl.Rl(t,1),xl.Rl(t,2),t.q!=n.q&&xl.Am(t,!0),xl.ap(n,t,n.q,s,f),xl._o(n,t,n.q,s),i&&xl.je(new xl.te(t),null,!1),s},xl.pn=function(n,t){var e,i,s,r,a,o,l,f,g,u;if(0!=(t&~n.T)&&(0==(1&n.T)&&(xl.wo(n),xl.jn(n),n.T|=1,xl.ln(n)&&(xl.wo(n),xl.jn(n))),0!=(t&~n.T))){if(0!=(-7&n.T)){for(i=0;i<n.f;i++)n.u[i]&=-15369;for(r=0;r<n.g;r++)n.F[r]&=-705;if(0==(4&t))return xl.un(n,1),void(n.T|=2);for(xl.un(n,7),s=0;s<n.f;s++)for(g=0;g<n.j[s];g++)if(!((l=n.k[s][g])<n.g&&xl.Or(n.p,l)))for(o=n.i[s][g],u=0;u<n.j[o];u++)n.k[o][u]!=l&&n.n[o][u]>1&&(6==n.C[n.i[o][u]]?n.u[s]|=fn:!xl.Do(n,n.k[o][u])&&xl.vl(n,n.i[o][u])&&(n.u[s]|=Sn));for(;;){for(f=!1,e=0;e<n.f;e++)if(n.o[e]>0&&0!=(n.u[e]&Sn)&&!xl.Nr(n.p,e))for(g=0;g<n.j[e];g++)if(n.n[e][g]>1)for(o=n.i[e][g],l=n.k[e][g],u=0;u<n.j[o];u++)n.k[o][u]!=l&&(a=n.i[o][u],0==(n.u[a]&Sn)&&(n.u[a]|=Sn,f=!0));if(!f)break}}n.T|=6}},xl.qn=function(n,t){var e,i,s,r,a;if(e=-1,1==n.o[t])for(r=0;r<n.j[t];r++)if(2==n.n[t][r]){if(i=n.i[t][r],2==n.j[i]&&2==n.o[i])for(a=0;a<2;a++)if((s=n.i[i][a])!=t&&1==n.o[s]){e=i;break}break}return e},xl.rn=function(n,t,e){var i,s;for(i=t;2==n.j[e]&&2==n.o[e]&&e!=i;)s=e,e=n.i[e][0]==t?n.i[e][1]:n.i[e][0],t=s;return e==i?-1:e},xl.sn=function(n,t){var e;if(3==n.j[t]&&t<n.f&&xl.Nr(n.p,t)&&(n.p&&t<n.f?xl.Cr(n.p,t):0)>=5)for(e=0;e<n.j[t];e++)if(xl.Eo(n,n.k[t][e]))return n.k[t][e];return-1},xl.tn=function(n,t,e,i,s){var r,a,o,l,f,g;if(xl.iu(n,7),0!=(n.u[t]&Rt)&&(!e||t<n.f&&xl.Nr(n.p,t)))for((l=vf(yl.tlb,z,6,n.f,15,1))[0]=t,i[t]=!0,o=0,f=0;o<=f;){for(g=0;g<n.j[l[o]];g++)s[a=n.k[l[o]][g]]||0==(64&n.F[a])||e&&!(a<n.g&&xl.Or(n.p,a))||(s[a]=!0,i[r=n.i[l[o]][g]]||(i[r]=!0,l[++f]=r));++o}},xl.un=function(n,t){var e,i,s,r,a,o,l,f;for(n.p=new xl._r(n,t),i=vf(yl.tlb,z,6,n.f,15,1),s=0;s<n.g;s++)0!=xl.Er(n.p,s)&&(n.F[s]|=64,++i[n.D[0][s]],++i[n.D[1][s]]);for(e=0;e<n.f;e++)2==i[e]?n.u[e]|=cn:3==i[e]?n.u[e]|=zn:i[e]>3&&(n.u[e]|=Rt);for(f=0;f<n.p.i.a.length;f++)for(a=xl.Gr(n.p,f),l=xl.Hr(n.p,f),o=a.length,r=0;r<o;r++)n.u[a[r]]|=8,n.F[l[r]]|=128,386==n.H[l[r]]&&(n.H[l[r]]=2)},xl.vn=function(n){var t,e,i,s,r,a,o,l;for(o=vf(yl.Lwb,nn,6,n.q,16,1),e=0;e<n.q;e++)o[e]=1==n.C[e]&&0==n.A[e]&&0==n.s[e]&&0==(n.u[e]&Tt)&&(null==n.t||null==n.t[e]);for(l=vf(yl.Lwb,nn,6,n.q,16,1),a=0;a<n.r;a++)i=n.D[0][a],s=n.D[1][a],1==xl.Vk(n,a)?(l[i]&&(o[i]=!1),l[s]&&(o[s]=!1),o[i]&&xl.yl(n,s)&&13!=n.C[s]&&(o[i]=!1),o[s]&&xl.yl(n,i)&&13!=n.C[i]&&(o[s]=!1),l[i]=!0,l[s]=!0):(o[i]=!1,o[s]=!1);for(r=0;r<n.r;r++)o[n.D[0][r]]&&o[n.D[1][r]]&&(o[n.D[0][r]]=!1,o[n.D[1][r]]=!1);for(t=0;t<n.q;t++)l[t]||(o[t]=!1);return o},xl.wn=function(n,t){return n.e[t]},xl.xn=function(n,t){return n.i[t].length},xl.yn=function(n,t){return n.e[t]-xl.eo(n,t)+xl.$n(n,t)},xl.zn=function(n){var t,e;for(xl.iu(n,7),t=0,e=0;e<n.p.i.a.length;e++)xl.Mr(n.p,e)&&++t;return t},xl.An=function(n,t){var e,i;for(e=0,i=0;i<n.j[t];i++)xl.vl(n,n.i[t][i])&&!xl.ql(n,n.k[t][i])&&++e;return e},xl.Bn=function(n,t){return n.o[t]},xl.Cn=function(n,t){return xl.iu(n,7),2==n.o[t]&&2==n.j[t]?xl.Xo(n,t,!1):xl.Zo(n,t,!1)},xl.Dn=function(n,t){var e;return 0==(e=n.u[t]&Rt)?0:e==cn?2:e==zn?3:4},xl.En=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d,c;for(xl.iu(n,7),r=vf(yl.Lwb,nn,6,n.g,16,1),u=vf(yl.Lwb,nn,6,n.g,16,1),c=vf(yl.tlb,z,6,n.f,15,1),a=0,o=1;o<n.j[t];o++)if(i=n.k[t][o],0!=(64&n.F[i]))for(f=0;f<o;f++)if(s=n.k[t][f],0!=(64&n.F[s])&&(u[i]=!0,u[s]=!0,d=xl.ho(n,c,n.i[t][o],n.i[t][f],e-2,null,u),u[i]=!1,u[s]=!1,-1!=d)){for(l=!1,h=vf(yl.tlb,z,6,d,15,1),xl.io(n,c,h,d),g=0;g<d;g++)r[h[g]]||(r[h[g]]=!0,l=!0);l&&++a}return a},xl.Fn=function(n,t){return n.p&&t<n.f?xl.Cr(n.p,t):0},xl.Gn=function(n,t){return t?(xl.iu(n,1),xl.Kk(n,n.f,n.g,xl.Jj)):xl.Kk(n,n.q,n.r,xl.Jj)},xl.Hn=function(n){var t,e,i,s,r,a,o,l;for(xl.iu(n,1),o=vf(yl.slb,kt,6,n.f,15,1),i=vf(yl.tlb,z,6,n.f,15,1),l=0;l<n.f;l++){for(i[0]=l,(s=vf(yl.tlb,z,6,n.f,15,1))[l]=1,e=0,r=0;e<=r;){for(a=0;a<n.j[i[e]];a++)0==s[t=n.i[i[e]][a]]&&(s[t]=s[i[e]]+1,i[++r]=t,o[l]+=s[t]-1);++e}o[l]/=r}return o},xl.In=function(n,t,e){var i;for(i=0;i<n.i[t].length;i++)if(n.i[t][i]==e)return n.k[t][i];return-1},xl.Jn=function(n,t){return n.p&&t<n.g?xl.Er(n.p,t):0},xl.Kn=function(n,t,e){return n.i[t][e]},xl.Ln=function(n,t){return n.j[t]},xl.Mn=function(n,t,e){return n.k[t][e]},xl.Nn=function(n,t,e){return n.n[t][e]},xl.On=function(n,t){var e,i;for(e=0,i=0;i<n.j[t];i++)Rg(Cg(n.B[i],tn),0)&&++e;return e},xl.Pn=function(n,t){return n.e[t]-n.j[t]},xl.Qn=function(t,e,i,s,r){var a,o,l,f;if(o=t.e[e],0!=t.o[e]||e<t.f&&xl.Nr(t.p,e)||t.j[e]<3||o>4)return!1;for(f=vf(yl.Lwb,nn,6,4,16,1),l=0;l<o;l++){if(a=3.9269908169872414-s[l],n.Math.abs(Et-a%on)>.0872664675116539)return!1;if(r[l]=3&rg(a/on),f[r[l]])return!1;if(f[r[l]]=!0,0==(1&r[l])){if(1!=t.H[t.k[e][i[l]]])return!1}else if(!xl.Fl(t,t.k[e][i[l]],e))return!1}return f[0]&&f[2]},xl.Rn=function(t,e,i,s,r){var a,o,l,f,g,u;if((t.p&&e<t.f?xl.Cr(t.p,e):0)>24)return 3;if(a=t.e[e],null==r&&(r=vf(yl.tlb,z,6,a,15,1)),!xl.Qn(t,e,i,s,r))return 3;for(f=-1,g=0;g<a;g++)if(1==(1&r[g])){if(o=t.H[t.k[e][i[g]]],-1!=f&&f!=o)return 3;f=o}return l=r[u=2==n.Math.abs(r[0]-r[1])?1:0]-r[u+1],3==n.Math.abs(l)^r[u]<r[u+1]^(3==a||1==(1&r[3]))^129==f?1:2},xl.Sn=function(n,t,e){var i,s,r,a;for(a=a=vf(yl.Lwb,nn,6,n.q,16,1),r=xl.Tn(n,t,e,a),s=vf(yl.tlb,z,6,r,15,1),r=0,i=0;i<n.q;i++)a[i]&&(s[r++]=i);return s},xl.Tn=function(n,t,e,i){var s,r,a,o,l,f,g;for(xl.iu(n,1),null==i&&(i=vf(yl.Lwb,nn,6,n.q,16,1)),(l=vf(yl.tlb,z,6,n.q,15,1))[0]=t,i[t]=!0,a=0,f=0,o=1;a<=f;){for(r=e?xl.xn(n,l[a]):n.e[l[a]],g=0;g<r;g++)(s=n.i[l[a]][g])<i.length&&!i[s]&&(l[++f]=s,i[s]=!0,++o);++a}return o},xl.Un=function(n,t,e,i){var s,r,a,o,l,f,g,u,h;for(xl.iu(n,1),r=0;r<n.q;r++)t[r]=-1;for(f=0,s=0;s<n.q;s++)if(-1==t[s]&&(!e||0!=(n.u[s]&gt))){for(t[s]=f,(g=vf(yl.tlb,z,6,n.q,15,1))[0]=s,l=0,u=0;l<=u;){for(o=i?xl.xn(n,g[l]):n.e[g[l]],h=0;h<o;h++)-1!=t[a=n.i[g[l]][h]]||e&&0==(n.u[a]&gt)||(g[++u]=a,t[a]=f);++l}++f}return f},xl.Vn=function(n,t,e,i){var s,r,a,o,l,f,g,u,h;for(xl.iu(n,1),r=0;r<n.q;r++)t[r]=-1;for(f=0,s=0;s<n.q;s++)if(-1==t[s]){for(t[s]=f,(g=vf(yl.tlb,z,6,n.q,15,1))[0]=s,l=0,u=0;l<=u;){for(o=i?xl.xn(n,g[l]):n.e[g[l]],h=0;h<o;h++)-1!=t[a=n.i[g[l]][h]]||e[n.k[g[l]][h]]||(g[++u]=a,t[a]=f);++l}++f}return f},xl.Wn=function(n,t){var e;return(e=xl.dl(n,t))+xl.bl(n,t,e,n.C[t])-xl.fo(n,t)},xl.Xn=function(n,t){var e,i,s,r,a,o;for(r=vf(yl.tlb,z,6,n.q,15,1),i=0;i<n.q;i++)r[i]=i;s=n.q;do{--s}while(s>=0&&t[s]);for(e=0;e<s;e++)if(t[r[e]]){o=r[e],r[e]=r[s],r[s]=o,a=t[e],t[e]=t[s],t[s]=a;do{--s}while(t[s])}return r},xl.Yn=function(n){return xl.Xn(n,xl.vn(n))},xl.Zn=function(n,t,e){var i,s,r;if(s=xl.fo(n,t),s-=xl.bl(n,t,s,n.C[t]),e&&(s-=n.e[t]-n.j[t]),s<=(r=xl.Zm(n.C[t]))[0])return-1;for(i=1;i<r.length;i++)if(r[i]>=s)return r[i];return s},xl.$n=function(t,e){var i,s,r,a,o,l;if(t.K&&Ig(Cg(t.B[e],zn),0))return 0;if(!xl.ip(t,e))return 0;for(xl.iu(t,1),o=0,r=0;r<t.e[e];r++)o+=t.n[e][r];if(t.K){for(i=1,s=0;s<t.j[e];s++)64==t.H[t.k[e][s]]&&++i;o+=i>>1}if(o-=xl.bl(t,e,o,t.C[e]),-1==(a=((t.u[e]&Tt)>>>27)-1))for(a=(l=xl.Zm(t.C[e]))[0],s=1;a<o&&s<l.length;s++)a=l[s];return n.Math.max(0,a-o)},xl._n=function(t,e){var i,s,r,a,o;if(!t.K||null==t.v||null==t.v[e])return xl.ao(t,e,t.C[e]);for(o=0,r=0,a=(s=t.v[e]).length;r<a;++r)i=s[r],o=n.Math.max(o,xl.ao(t,e,i));return o},xl.ao=function(n,t,e){var i,s,r,a,o;if(r=xl.fo(n,t),i=xl.bl(n,t,r,e),-1==(a=((n.u[t]&Tt)>>>27)-1)){for(o=xl.Zm(n.C[t]),s=0;r>o[s]+i&&s<o.length-1;)++s;a=o[s]}return a+i-r},xl.bo=function(n,t){return n.i[t].length-n.e[t]},xl.co=function(n){var t,e,i;for(xl.iu(n,1),i=0,t=0;t<n.q;t++)i+=(0!=n.A[t]?n.A[t]:xl.Ij[n.C[t]])+xl.$n(n,t)*xl.Ij[1],n.C[t]>=171&&n.C[t]<=190&&(e=n.e[t])>2&&(i-=(e-2)*xl.Ij[1]);return i},xl.eo=function(n,t){var e,i;for(e=n.j[t],i=0;i<n.j[t];i++)1==n.C[n.i[t][i]]&&--e;return e},xl.fo=function(n,t){var e,i,s,r,a,o;for(n.Mb(1),a=!1,i=!1,o=0,s=0;s<n.e[t];s++)n.K&&!Ig(Cg(n.B[n.i[t][s]],tn),0)||(o+=r=n.n[t][s],r>1&&(a=!0),e=n.k[t][s],64==n.H[e]&&(i=!0));return i&&!a&&++o,o},xl.go=function(n,t,e){var i,s,r;for(s=0,r=0;r<n.j[t];r++)(i=n.i[t][r])!=e&&n.j[i]>2&&++s;return s},xl.ho=function(n,t,e,i,s,r,a){var o,l,f,g,u,h,d,c,b;if(e==i)return t[0]=e,0;for(n.Mb(1),g=vf(yl.tlb,z,6,n.q,15,1),f=vf(yl.tlb,z,6,n.q,15,1),b=vf(yl.tlb,z,6,n.q,15,1),f[0]=e,g[e]=1,l=0,u=0;l<=u&&g[f[l]]<=s;){for(c=f[l],h=0;h<n.e[c];h++)if(null==a||a.length<=n.k[c][h]||!a[n.k[c][h]]){if((o=n.i[c][h])==i){for(t[d=g[c]]=o,t[--d]=c;d>0;)t[d-1]=b[t[d]],--d;return g[c]}0==g[o]&&(null==r||r.length<=o||!r[o])&&(f[++u]=o,g[o]=g[c]+1,b[o]=c)}++l}return-1},xl.io=function(n,t,e,i){var s,r;for(xl.iu(n,1),s=0;s<i;s++)for(r=0;r<n.e[t[s]];r++)if(n.i[t[s]][r]==t[s+1]){e[s]=n.k[t[s]][r];break}},xl.jo=function(n,t,e){var i,s,r,a,o,l;if(t==e)return 0;for(xl.iu(n,1),a=vf(yl.tlb,z,6,n.q,15,1),(r=vf(yl.tlb,z,6,n.q,15,1))[0]=t,a[t]=1,s=0,o=0;s<=o;){for(l=0;l<n.e[r[s]];l++){if((i=n.i[r[s]][l])==e)return a[r[s]];0==a[i]&&(r[++o]=i,a[i]=a[r[s]]+1)}++s}return-1},xl.ko=function(n,t,e,i,s){var r,a,o,l,f,g;if(t==e)return 0;for(n.Mb(1),l=vf(yl.tlb,z,6,n.q,15,1),(o=vf(yl.tlb,z,6,n.q,15,1))[0]=t,l[t]=1,a=0,f=0;a<=f&&l[o[a]]<=i;){for(g=0;g<n.e[o[a]];g++){if((r=n.i[o[a]][g])==e)return l[o[a]];0==l[r]&&(null==s||s.length<=r||!s[r])&&(o[++f]=r,l[r]=l[o[a]]+1)}++a}return-1},xl.lo=function(n,t){return n.e[t]-n.j[t]+xl.$n(n,t)},xl.mo=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c;for(c=vf(yl.tlb,z,6,16,15,1),e=vf(yl.rlb,X,6,16,15,1),r=vf(yl.rlb,X,6,2,15,1),i=0,g=0;g<2;g++)for(s=n.D[g][t],u=0;u<n.j[s];u++)if((l=n.k[s][u])!=t){if(4==i)return 0;o=n.i[s][u],c[i]=16,0!=n.o[o]&&(c[i]+=0!=(n.u[o]&Rt)?1:4),0!=(64&n.F[t])&&0!=(64&n.F[l])&&-1!=(h=xl.Kr(n.p,t,l))&&(c[i]+=xl.Mr(n.p,h)?64:6),e[i++]=xl.$m(n.J[s].a,n.J[s].b,n.J[o].a,n.J[o].b)}for(r[0]=xl.Mk(n,n.D[0][t],n.D[1][t]),r[0]<0?(r[1]=r[0]+an,a=!1):(r[1]=r[0],r[0]=r[1]-an,a=!0),d=0,f=0;f<i;f++)e[f]>r[0]&&e[f]<r[1]?d-=c[f]:d+=c[f];return a?-d:d},xl.no=function(n){return xl.iu(n,7),n.p},xl.oo=function(n){var t,e,i,s,r,a,o,l,f;for(f=0,xl.iu(n,7),i=0;i<n.g;i++)if(1==xl.Vk(n,i)&&0==(64&n.F[i])){for(o=!0,a=0;a<2;a++){if(t=n.D[a][i],1==n.j[t]){o=!1;break}if(7==n.C[t]&&!(t<n.f&&xl.Nr(n.p,t)))for(e=n.D[1-a][i],l=0;l<n.j[e];l++)if(s=n.i[e][l],(r=n.k[e][l])!=i&&xl.Vk(n,r)>1&&!(s<n.f&&xl.Nr(n.p,s))&&xl.vl(n,s)){o=!1;break}}o&&!xl.Mo(n,i)&&++f}return f},xl.po=function(n,t,e){var i,s,r,a,o,l;for(s=0,r=0;r<n.j[t];r++)if((i=n.i[t][r])!=e){for(a=0,o=0;o<n.j[i];o++)(l=n.i[i][o])!=t&&xl.Do(n,n.k[i][o])&&n.j[l]>2&&++a;2==a&&++s}return s},xl.qo=function(n,t){var e,i,s,r;for(e=n.e[t],r=vf(yl.tlb,z,6,e,15,1),s=0;s<e;s++)r[s]=(n.i[t][s]<<16)+s;for(kl.nTb(r,kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[]))),i=0;i<e;i++)r[i]&=B;return r},xl.ro=function(n,t){var e,i;if(xl.iu(n,1),2==n.j[t]&&2==n.n[t][0]&&2==n.n[t][1]){for(e=0;e<2;e++)for(i=0;i<n.e[n.i[t][e]];i++)if(xl.Fl(n,n.k[n.i[t][e]][i],n.i[t][e]))return n.k[n.i[t][e]][i]}else for(e=0;e<n.e[t];e++)if(xl.Fl(n,n.k[t][e],t))return n.k[t][e];return-1},xl.so=function(t,e,i){return 1!=xl.Vk(t,e)?0:16-t.e[i]+16*n.Math.max(0,n.Math.min(9,t.p&&e<t.g?xl.Er(t.p,e):0)-2)+(0==(384&t.H[e])||t.D[0][e]!=i?Lt:0)+(0==(3&t.u[i])?fn:0)+(1==t.C[i]?zn:0)+(1==t.e[i]?cn:0)+(0!=(64&t.F[e])?0:512)+(6!=t.C[i]?256:0)},xl.to=function(n,t,e,i,s,r){var a,o,l,f,g;for(xl.iu(n,1),s&&(xl._j(s),s.K=!1),l=vf(yl.tlb,z,6,n.q,15,1),null==i?i=vf(yl.Lwb,nn,6,n.q,16,1):Fl.ROb(i,i.length),l[0]=t,l[1]=e,i[t]=!0,i[e]=!0,o=1,f=1;o<=f;){for(g=0;g<n.e[l[o]];g++){if((a=n.i[l[o]][g])==t&&1!=o)return-1;i[a]||(i[a]=!0,l[++f]=a)}++o}return s&&(null==r&&(r=vf(yl.tlb,z,6,i.length,15,1)),xl.nn(n,s,i,!1,r),xl.Yj(s,r[t],0,0,-1,0)),i[t]=!1,f},xl.uo=function(n,t,e){var i,s,r,a,o,l;for(xl.iu(n,1),r=vf(yl.tlb,z,6,n.f,15,1),l=vf(yl.Lwb,nn,6,n.f,16,1),r[0]=t,r[1]=e,l[t]=!0,l[e]=!0,s=1,a=1;s<=a;){for(o=0;o<n.j[r[s]];o++){if((i=n.i[r[s]][o])==t&&1!=s)return-1;l[i]||(l[i]=!0,r[++a]=i)}++s}return a},xl.vo=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d;if(2!=xl.Vk(n,e)&&!(e<n.g&&xl.Or(n.p,e)))return-1;if(1!=(d=3&n.F[e])&&2!=d)return-1;for(l=0;l<2;l++){for(i=n.D[l][e],s=n.D[1-l][e],h=-1,a=!1,g=0;g<n.j[i];g++)(r=n.i[i][g])!=s&&(r==t?a=!0:h=r);if(a){for(u=-1,o=-1,f=0;f<n.j[s];f++)(r=n.i[s][f])!=i&&(-1==u?u=r:r>u?o=r:(o=u,u=r));return 2==n.j[i]?2==n.j[s]?2==d?u:-1:2==d?u:o:2==n.j[s]?2==d^t<h?-1:u:2==d^t<h?o:u}}return-1},xl.wo=function(n){var t,e,i,s,r,a,o,l,f,g;a=xl.vn(n),l=n.q;do{--l}while(l>=0&&a[l]);for(t=0;t<l;t++)if(a[t]){xl.Lm(n,t,l),g=a[t],a[t]=a[l],a[l]=g;do{--l}while(a[l])}if(n.f=l+1,n.q!=n.f){for(o=vf(yl.Lwb,nn,6,n.r,16,1),r=0;r<n.r;r++)e=n.D[0][r],i=n.D[1][r],(a[e]||a[i])&&(o[r]=!0);f=n.r;do{--f}while(f>=0&&o[f]);for(s=0;s<f;s++)if(o[s]){xl.Mm(n,s,f),o[s]=!1;do{--f}while(o[f])}n.g=f+1}else n.g=n.r},xl.xo=function(n,t){var e;for(e=0;e<n.j[t];e++)if(n.s[n.i[t][e]]<0)return!0;return!1},xl.yo=function(n,t){var e;for(e=0;e<n.j[t];e++)if(n.s[n.i[t][e]]>0)return!0;return!1},xl.zo=function(n,t){var e;return 3==(e=n.C[t])||11==e||19==e||37==e||55==e},xl.Ao=function(n,t){return 0!=(n.u[t]&fn)},xl.Bo=function(n,t){var e,i,s,r,a,o;for(xl.iu(n,1),a=0;a<2;a++)if(e=n.D[a][t],7==n.C[e])for(i=n.D[1-a][t],o=0;o<n.j[i];o++)if(s=n.i[i][o],r=n.k[i][o],(7==n.C[s]||8==n.C[s]||16==n.C[s])&&xl.Vk(n,r)>=2)return!0;return!1},xl.Co=function(n,t){return t<n.f&&xl.Nr(n.p,t)},xl.Do=function(n,t){return t<n.g&&xl.Or(n.p,t)},xl.Eo=function(n,t){var e,i,s,r,a,o;return!(1!=n.H[t]||t<n.g&&xl.Or(n.p,t)||0!=(64&n.F[t])&&(n.p&&t<n.g?xl.Er(n.p,t):0)<7)&&(!(!((e=n.D[0][t])<n.f&&xl.Nr(n.p,e))||(n.p&&e<n.f?xl.Cr(n.p,e):0)<5)&&(!(!((i=n.D[1][t])<n.f&&xl.Nr(n.p,i))||(n.p&&i<n.f?xl.Cr(n.p,i):0)<5)&&(s=xl.go(n,e,i),r=xl.go(n,i,e),(n.p&&e<n.f?xl.Cr(n.p,e):0)>5&&(n.p&&i<n.f?xl.Cr(n.p,i):0)>5?s+r>2:(a=xl.po(n,e,i),o=xl.po(n,i,e),2==s&&o>=1||(2==r&&a>=1||(2==a&&(r>=1||o>=1)||2==o&&(s>=1||a>=1)))))))},xl.Fo=function(n,t){return 2==n.o[t]&&2==n.j[t]&&2==n.n[t][0]&&2==n.n[t][1]&&n.C[t]<=7},xl.Go=function(n,t){var e;return 8==(e=n.C[t])||16==e||34==e||52==e},xl.Ho=function(n,t){return t<n.g&&(xl.Sr(n.p,t)||64==n.H[t])},xl.Io=function(n,t){var e;return 12==(e=n.C[t])||20==e||38==e||56==e},xl.Jo=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d,c,b;if(7!=n.C[t]||4==n.j[t])return!1;if(t<n.f&&xl.Nr(n.p,t)||0!=n.o[t]||Rg(Cg(n.B[t],Xn),0))return!0;if(1==n.s[t])return!1;for(l=0;l<n.j[t];l++)if(3==xl.Jn(n,n.k[t][l]))return!1;for(a=0,f=0;f<n.j[t];f++)1==n.n[t][f]&&(8==(i=n.C[n.i[t][f]])||9==i||17==i)&&++a;if(0==a)for(o=0;o<n.j[t];o++)if(s=n.i[t][o],0!=n.o[s]){if(s<n.f&&xl.Nr(n.p,s)){if((n.p&&s<n.f?xl.Cr(n.p,s):0)>=5){for(b=0,h=0;h<n.j[s];h++)(c=n.i[s][h])!=t&&xl.eo(n,c)>=3&&++b;if(d=xl.eo(n,t),2==b&&d>=2||1==b&&3==d)continue}return!e||!xl.Oo(n,t)}for(u=0;u<n.j[s];u++)if(2==n.n[s][u]||xl.Do(n,n.k[s][u]))return!e||!xl.Oo(n,t)}if(a<2)for(o=0;o<n.j[t];o++){for(s=n.i[t][o],g=!1,r=!1,u=0;u<n.j[s];u++)n.i[s][u]!=t&&(1!=n.n[s][u]&&(7==n.C[n.i[s][u]]||8==n.C[n.i[s][u]]||16==n.C[n.i[s][u]])&&(g=!0),1==n.n[s][u]&&7==n.C[n.i[s][u]]&&(r=!0));if(g&&(!r||0==a))return!e||!xl.Oo(n,t)}return!1},xl.Ko=function(n,t){var e;return 9==(e=n.C[t])||17==e||35==e||53==e},xl.Lo=function(n,t){var e;return 7==(e=n.C[t])||15==e||33==e},xl.Mo=function(n,t){var e,i,s,r,a,o;if(1!=xl.Vk(n,t))return!1;for(r=0;r<2;r++){for(e=n.D[r][t],o=n.D[1-r][t];2==n.o[e]&&2==n.j[e]&&n.C[e]<10;)for(a=0;a<2;a++)if((i=n.i[e][a])!=o){if(1==n.j[i])return!0;if(s=n.k[e][a],1==xl.Vk(n,s)&&s<t)return!0;o=e,e=i;break}if(1==n.j[e])return!0}return!1},xl.No=function(n,t,e,i,s){var r,a,o,l,f,g,u,h,d,c,b,D,H;if((h=vf(yl.Lwb,nn,6,n.g,16,1))[s]=!0,d=vf(yl.tlb,z,6,11,15,1),-1==(c=xl.ho(n,d,i,t,10,null,h)))return!1;for(a=1;!xl.Pr(n.p,e,d[a]);)++a;if(r=c-a,o=d[a],6==(H=xl.Jr(n.p,e))&&2==r&&3==a&&xl.Dn(n,d[1])>=3)for(D=xl.Gr(n.p,e),u=0;u<6;u++)if(t==D[u]){if(b=D[xl.$r(n.p,e,o==D[xl.$r(n.p,e,u+2)]?u-2:u+2)],(0==(g=n.u[b]&Rt)?0:g==cn?2:g==zn?3:4)>=3&&2==xl.ko(n,d[1],b,2,null))return!0;break}if(f=!(l=1==n.o[o]||o<n.f&&xl.Nr(n.p,o)||xl.Jo(n,o,!1))&&7==n.C[o]&&1!=n.s[o],1==r)return!l&&!f&&H<=4&&a<=3;switch(H){case 4:if(!l&&!f&&a<=4)return!0;break;case 5:if(f){if(a<=3)return!0}else if(!l&&a<=4)return!0;break;case 6:if(2==r){if(l){if(a<=4)return!0}else if(!f&&a<=3)return!0}else if(3==r)if(l){if(a<=6)return!0}else if(a<=4)return!0;break;case 7:if(3==r&&a<=3)return!0}return!1},xl.Oo=function(n,t){var e,i,s,r,a;if(t<n.f&&xl.Nr(n.p,t)||0!=n.o[t]||Rg(Cg(n.B[t],Xn),0)||(0==(i=n.u[t]&Rt)?0:i==cn?2:i==zn?3:4)<3)return!1;if((a=n.p&&t<n.f?xl.Cr(n.p,t):0)>7)return!1;for(r=0;r<n.p.i.a.length&&(xl.Jr(n.p,r)!=a||!xl.Pr(n.p,r,t));)++r;if(r>=cn&&r==n.p.i.a.length)return!1;for(s=0;s<n.j[t];s++)if(e=n.k[t][s],!xl.Qr(n.p,r,e)&&xl.No(n,t,r,n.i[t][s],e))return!0;return!1},xl.Po=function(n,t){return 0!=(n.u[t]&Rt)},xl.Qo=function(n,t){return 0!=(64&n.F[t])},xl.Ro=function(n,t){return 1==n.C[t]&&0==n.A[t]&&0==n.s[t]&&0==(n.u[t]&Tt)&&(null==n.t||null==n.t[t])},xl.So=function(n,t){return 0!=(8&n.u[t])},xl.To=function(n,t){return 0!=(128&n.F[t])},xl.Uo=function(n,t){return 0!=(n.u[t]&Sn)},xl.Vo=function(n){var t,e,i,s,r,a,o,l,f,g,u;for(xl.iu(n,1),xl.Wo(n),f=!1,e=0;e<n.f;e++)if(7==n.C[e]&&0==n.s[e])if(4==(u=xl.fo(n,e))){for(g=0;g<n.j[e];g++)if(o=n.i[e][g],1==n.n[e][g]&&8==n.C[o]&&1==n.j[o]&&0==n.s[o]){f=!0,++n.s[e],--n.s[o];break}}else if(5==u)for(g=0;g<n.j[e];g++){if(o=n.i[e][g],l=n.k[e][g],2==n.n[e][g]&&8==n.C[o]){f=!0,++n.s[e],--n.s[o],n.H[l]=1;break}if(3==n.n[e][g]&&7==n.C[o]){f=!0,++n.s[e],--n.s[o],n.H[l]=2;break}}for(a=!1,r=0;r<n.g;r++)for(g=0;g<2;g++)if(xl.vl(n,n.D[g][r])){t=n.D[1-g][r],3!=(s=n.C[t])&&11!=s&&19!=s&&37!=s&&55!=s&&(12!=(i=n.C[t])&&20!=i&&38!=i&&56!=i)||(1==xl.Vk(n,r)?(++n.s[t],--n.s[n.D[g][r]],n.H[r]=512,a=!0):32==n.H[r]&&(n.H[r]=512,a=!0));break}return a&&(xl.ak(n),f=!0),f&&(n.T=0),f},xl.Wo=function(n){var t;for(t=0;t<n.g;t++)if(64==n.H[t])return xl.je(new xl.te(n),null,!1);return!1},xl.Xo=function(n,t,e){var i,s,r,a,o,l,f,g;for(f=-1,s=0,o=0;o<2;o++)for(i=n.i[t][o],l=0;l<n.e[i];l++)(r=n.i[i][l])!=t&&(a=n.k[i][l],s<(g=xl.so(n,a,r))&&(!e||257!=n.H[a]&&129!=n.H[a])&&(s=g,f=a));return f},xl.Yo=function(n,t){var e,i,s,r,a,o,l,f;for(l=-1,i=0,a=0;a<2;a++)for(e=n.D[a][t],o=0;o<n.e[e];o++)(s=n.i[e][o])!=n.D[1-a][t]&&(r=n.k[e][o],i<(f=xl.so(n,r,s))&&(i=f,l=r));return l},xl.Zo=function(t,e,i){var s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m;for(s=t.e[e],r=vf(yl.rlb,X,6,s,15,1),c=0;c<s;c++)r[c]=xl.Mk(t,e,t.i[e][c]);for(b=1;b<s;b++)for(D=0;D<b;D++)if((a=n.Math.abs(xl._m(r[b],r[D])))<.08||a>xt){for(o=0,l=0,H=0;H<s;H++)H!=b&&H!=D&&(o+=n.Math.abs(gf.q6(r[b],r[H])),l+=n.Math.abs(gf.q6(r[D],r[H])));if(g=o<l?t.k[e][b]:t.k[e][D],1==xl.Vk(t,g)&&(!i||257!=t.H[g]&&129!=t.H[g]))return g}for(j=-1,f=0,d=0;d<s;d++)u=t.i[e][d],h=t.k[e][d],f<(m=xl.so(t,h,u))&&(!i||257!=t.H[h]&&129!=t.H[h])&&(f=m,j=h);return j},xl.$o=function(n,t){var e,i,s;for(xl.iu(n,t?15:1),n.q=n.f,n.r=n.g,i=0;i<n.f;i++)n.e[i]!=n.j[i]&&(e=xl.Zn(n,i,!1),n.e[i]=n.j[i],-1!=e&&e!=xl.Zn(n,i,!0)&&(-1==(s=((n.u[i]&Tt)>>>27)-1)||s<e)&&xl.Vl(n,i,e));t&&xl.gp(n),n.T=0},xl._o=function(n,t,e,i){var s,r,a;for(xl.iu(t,1),r=0;r<e;r++)-1!=i[r]&&1!=n.C[r]&&n.e[r]!=xl.wn(t,i[r])&&-1!=(s=xl.Zn(n,r,!1))&&s!=xl.Zn(t,i[r],!1)&&(-1==(a=xl.pk(t,i[r]))||a<s)&&xl.Vl(t,i[r],s)},xl.ap=function(t,e,i,s,r){var a,o,l,f,g,u,h,d,c,b,D;for(l=0;l<i;l++)if(-1!=s[l]&&t.e[l]>3&&0!=(t.u[l]&wt)){for(D=0,d=-1,h=-1,u=0;u<t.e[l];u++)s.length>t.i[l][u]&&-1!=s[t.i[l][u]]?++D:1==t.n[l][u]&&xl.El(t,t.k[l][u])&&t.D[0][t.k[l][u]]==l&&(d=t.k[l][u],h=t.i[l][u]);if(-1!=d&&D>=3){for(a=xl.$m(t.J[l].a,t.J[l].b,t.J[h].a,t.J[h].b),c=10,b=-1,g=0;g<t.e[l];g++)1==t.n[l][g]&&(!xl.El(t,t.k[l][g])||t.D[0][t.k[l][g]]==l)&&s.length>t.i[l][g]&&-1!=s[t.i[l][g]]&&c>(o=n.Math.abs(xl._m(a,xl.Mk(t,l,t.i[l][g]))))&&(c=o,b=t.k[l][g]);-1!=b&&(f=r[b],xl.ym(e,f,257==t.H[b]?129:257),t.D[0][b]!=l&&(xl.pm(e,1,f,s[t.D[0][b]]),xl.pm(e,0,f,s[l])))}}},xl.bp=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C;if(2!=n.j[t]||2!=n.n[t][0]||2!=n.n[t][1]||n.j[n.i[t][0]]<2||n.j[n.i[t][1]]<2||1!=n.o[n.i[t][0]]||1!=n.o[n.i[t][1]])xl.gm(n,t,0,!1);else{for(m=-1,j=-1,H=-1,c=-1,r=0,g=0;g<2;g++)for(i=n.i[t][g],d=0;d<n.e[i];d++)(a=n.i[i][d])!=t&&(o=n.k[i][d],r<(A=xl.so(n,o,a))&&(r=A,j=a,m=o,H=i,c=n.i[t][1-g]));if(-1!=j){for(u=0;u<2;u++)for(i=n.i[t][u],d=0;d<n.e[i];d++)a=n.i[i][d],o=n.k[i][d],a!=t&&n.D[0][o]==i&&(n.H[o]=1);for(n.D[1][m]!=j&&(n.D[0][m]=n.D[1][m],n.D[1][m]=j),l=I,h=0;h<n.j[H];h++)(a=n.i[H][h])!=t&&l>a&&(l=a);for(b=vf(yl.tlb,z,6,2,15,1),D=0,f=0;f<n.j[c];f++)(a=n.i[c][f])!=t&&(b[D++]=a);e=xl.$m(n.J[t].a,n.J[t].b,n.J[c].a,n.J[c].b),s=0,2==D?(b[0]>b[1]&&(C=b[0],b[0]=b[1],b[1]=C),s=xl._m(e,xl.Mk(n,c,b[0]))-xl._m(e,xl.Mk(n,c,b[1]))):s=xl._m(e,xl.Mk(n,c,b[0])),s<0^1==(3&n.u[t])^l==j?n.H[m]=257:n.H[m]=129}}},xl.cp=function(n,t,e,i){var s,r,a,o,l,f;if(s=n.e[t],o=vf(yl.tlb,z,6,s,15,1),3==(f=xl.Rn(n,t,e,i,o)))return!1;for(a=(3&n.u[t])==f?257:129,l=0;l<s;l++)1==(1&o[l])&&(r=n.k[t][e[l]],n.H[r]=a,n.D[0][r]!=t&&(n.D[1][r]=n.D[0][r],n.D[0][r]=t));return!0},xl.dp=function(n,t){n.T|=248&(8|t)},xl.ep=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D;if(xl.mn(n,t),0!=(3&n.u[t])&&3!=(3&n.u[t]))if(2!=n.o[t]||2!=n.j[t])if(n.j[t]<3||n.j[t]>4)xl.gm(n,t,0,!1);else{for(e=n.e[t],c=!1,a=0;a<e;a++)if(1==xl.Vk(n,n.k[t][a])){c=!0;break}if(c){for(b=xl.qo(n,t),i=vf(yl.rlb,X,6,e,15,1),o=0;o<e;o++)i[o]=xl.Mk(n,n.i[t][b[o]],t);for(l=0;l<e;l++)n.D[0][n.k[t][l]]==t&&1==xl.Vk(n,n.k[t][l])&&(n.H[n.k[t][l]]=1);if(!((n.p&&t<n.f?xl.Cr(n.p,t):0)<=24&&xl.cp(n,t,b,i))&&-1!=(h=xl.Zo(n,t,!0))){for(n.D[0][h]!=t&&(n.D[1][h]=n.D[0][h],n.D[0][h]=t),d=-1,f=0;f<e;f++)if(h==n.k[t][b[f]]){d=f;break}for(D=Of(qf(yl.tlb,2),ot,8,0,[Of(qf(yl.tlb,1),z,6,15,[2,1,2,1]),Of(qf(yl.tlb,1),z,6,15,[1,2,2,1]),Of(qf(yl.tlb,1),z,6,15,[1,1,2,2]),Of(qf(yl.tlb,1),z,6,15,[2,1,1,2]),Of(qf(yl.tlb,1),z,6,15,[2,2,1,1]),Of(qf(yl.tlb,1),z,6,15,[1,2,1,2])]),r=1;r<e;r++)i[r]<i[0]&&(i[r]+=rn);if(3==e){switch(g=!1,d){case 0:g=i[1]<i[2]&&i[2]-i[1]<an||i[1]>i[2]&&i[1]-i[2]>an;break;case 1:g=i[2]-i[0]>an;break;case 2:g=i[1]-i[0]<an}s=1==(3&n.u[t])^g?257:129}else u=0,i[1]<=i[2]&&i[2]<=i[3]?u=0:i[1]<=i[3]&&i[3]<=i[2]?u=1:i[2]<=i[1]&&i[1]<=i[3]?u=2:i[2]<=i[3]&&i[3]<=i[1]?u=3:i[3]<=i[1]&&i[1]<=i[2]?u=4:i[3]<=i[2]&&i[2]<=i[1]&&(u=5),s=1==(3&n.u[t])^1==D[u][d]?129:257;n.H[h]=s}}}else xl.bp(n,t)},xl.fp=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C;if(0!=(3&n.F[t])&&3!=(3&n.F[t])&&xl.Eo(n,t)){for(m=-1,H=-1,j=-1,D=-1,s=0,g=0;g<2;g++)for(i=n.D[g][t],d=0;d<n.e[i];d++)(o=n.k[i][d])!=t&&1==xl.Vk(n,o)&&(a=n.i[i][d],s<(A=xl.so(n,o,a))&&(s=A,H=a,m=o,j=i,D=n.D[1-g][t]));if(-1!=H){for(u=0;u<2;u++)for(d=0;d<n.e[n.D[u][t]];d++)(o=n.k[n.D[u][t]][d])!=t&&1==xl.Vk(n,o)&&(n.H[o]=1);for(n.D[1][m]!=H&&(n.D[0][m]=n.D[1][m],n.D[1][m]=H),l=I,h=0;h<n.j[j];h++)a=n.i[j][h],n.k[j][h]!=t&&l>a&&(l=a);for(c=vf(yl.tlb,z,6,2,15,1),b=0,f=0;f<n.j[D];f++)n.k[D][f]!=t&&(c[b++]=n.i[D][f]);r=xl.$m(n.J[j].a,n.J[j].b,n.J[D].a,n.J[D].b),e=0,2==b?(c[0]>c[1]&&(C=c[0],c[0]=c[1],c[1]=C),e=xl._m(r,xl.Mk(n,D,c[0]))-xl._m(r,xl.Mk(n,D,c[1]))):e=xl._m(r,xl.Mk(n,D,c[0])),e<0^2==(3&n.F[t])^l==H?n.H[m]=257:n.H[m]=129}}},xl.gp=function(n){var t,e,i,s;for(xl.iu(n,7),i=0;i<n.g;i++)(257==n.H[i]||129==n.H[i])&&(n.H[i]=1);for(t=0;t<n.f;t++)xl.ep(n,t);for(s=0;s<n.g;s++)xl.fp(n,s);for(e=0;e<n.g;e++)2==n.H[e]&&3==(3&n.F[e])&&(n.H[e]=386)},xl.hp=function(n,t){var e,i,s,r,a,o,l,f,g,u;if(o=vf(yl.tlb,z,6,n.q,15,1),(a=xl.Un(n,o,!1,t))<=1)return null;for(l=vf(yl.tlb,z,6,a,15,1),i=0;i<n.f;i++)++l[o[i]];for(g=0,u=l[0],f=1;f<a;f++)u<l[f]&&(u=l[f],g=f);for(e=0;e<n.q;e++)o[e]!=g&&(n.C[e]=-1);for(r=0;r<n.r;r++)(!t&&32==n.H[r]||o[n.D[0][r]]!=g)&&(n.H[r]=512);s=xl.ak(n),n.T=0;try{xl.kn(n,!0,!0)}catch(n){if(!_f(n=ag(n),18))throw og(n)}return s},xl.ip=function(n,t){return 0!=(n.u[t]&Tt)||1!=n.C[t]&&(xl.Al(n,t)||13==n.C[t]||n.C[t]>=171)},xl.jp=function(n){var t,e,i,s,r,a,o,l,f,g;for(a=(r=xl.Kk(n,n.q,n.r,xl.Jj))*r/16,i=1;i<n.q;i++)for(s=0;s<i;s++)if((l=n.J[s].a-n.J[i].a)*l+(f=n.J[s].b-n.J[i].b)*f+(g=n.J[s].c-n.J[i].c)*g<a)throw og(new Jl.Xz("The distance between two atoms is too close."));for(xl.iu(n,1),t=0,e=0;e<n.f;e++){if(xl.fo(n,e)>(o=xl.dl(n,e))+xl.bl(n,e,o,n.C[e]))throw og(new Jl.Xz("atom valence exceeded"));t+=n.s[e]}if(0!=t)throw og(new Jl.Xz("unbalanced atom charge"))},xl.kp=function(n,t,e){var i;return(i=xl.Om(n,t,e))&&386==e&&(xl.iu(n,7),i&=0==(128&n.F[t])),i},xl.lp=function(){xl.Rm.call(this)},xl.mp=function(n,t){xl.Sm.call(this,n,t)},xl.np=function(n){xl.Sm.call(this,n?n.M:256,n?n.N:256),n&&xl.ek(n,this)},zf(97,113,{97:1,113:1,4:1}),o.Mb=function(n){xl.pn(this,n)},o.Lb=function(n){return xl.Ho(this,n)},o.f=0,o.g=0,yl.Rlb=lg(97),xl.qp=function(t,e){return n.Math.pow(10,n.Math.log(2e3)*n.Math.LOG10E*t/(e-1)-1)},xl.rp=function(n,t){var e,i;for(e=t,i=0;0!=t;)0==n.d&&(n.f=(63&n.c[++n.e])<<11,n.d=6),i|=(J&n.f)>>16-e+t,n.f<<=1,--t,--n.d;return i},xl.sp=function(n,t,e){n.d=6,n.e=e,n.c=t,n.f=(63&t[n.e])<<11},xl.tp=function(n,t){var e,i,s;return(s=n>=(i=t/2|0))&&(n-=i),e=(t/32|0)*n/(i-n),s?-e:e},xl.up=function(n,t){var e;return null==t||0==kl.TTb(t).length?null:xl.wp(n,kl.uTb((e=t,yf.XKb(),e)),null)},xl.vp=function(n,t,e){var i;return null==t?null:xl.wp(n,kl.uTb((i=t,yf.XKb(),i)),null==e?null:kl.uTb(e))},xl.wp=function(n,t,e){var i,s,r,a,o;return xl.sp(n,t,0),i=xl.rp(n,4),a=xl.rp(n,4),i>8&&(i=a),s=xl.rp(n,i),r=xl.rp(n,a),o=new xl.Bu(s,r),xl.Ap(n,o,t,e,0),o},xl.xp=function(n,t,e){var i,s,r;null!=e&&0!=kl.TTb(e).length?(i=Jl.OHb(e,bg(32)))>0&&i<kl.TTb(e).length-1?xl.zp(n,t,kl.uTb((kl.NTb(0,i,kl.TTb(e).length),r=kl.TTb(e).substr(0,i),yf.XKb(),r)),kl.uTb((kl.OTb(i+1,kl.TTb(e).length+1),kl.TTb(e).substr(i+1)))):xl.zp(n,t,kl.uTb((s=e,yf.XKb(),s)),null):xl.zp(n,t,null,null)},xl.yp=function(n,t,e,i){var s,r,a,o;r=null==e?null:kl.uTb((o=e,yf.XKb(),o)),s=null==i?null:kl.uTb((a=i,yf.XKb(),a)),xl.zp(n,t,r,s)},xl.zp=function(n,t,e,i){null!=e&&0!=e.length?xl.Ap(n,t,e,i,0):xl._j(t)},xl.Ap=function(t,e,i,s,r){var a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,I,P,M,N,w,L,U,y,J,B,R,k,E,x,F,Q,X,S,G,q,Y,v,Z,V,O,K,W,_,$,en,sn,rn,an,on,ln,gn,un,dn,cn,bn,Dn,Hn,jn,mn,An,Cn,Tn,pn,In,Pn,Mn,Nn,wn,Ln,Un,yn,Jn,Bn,Rn,kn,En,xn,Fn,Qn,Gn,qn,Yn,vn,Zn,Vn,On,Kn,Wn,_n,$n,nt,tt,et,it,st,rt,at,ot,lt,gt,ut,ht,ct,bt,Ht,jt,mt,At,Ct,Tt,pt,It,Pt,Mt,Nt,wt,Lt,Ut,yt;if(xl._j(e),!(null==i||0>=i.length))if(t.g=e,Pt=8,null!=s&&(r<0||r>=s.length)&&(s=null),xl.sp(t,i,0),l=xl.rp(t,4),I=xl.rp(t,4),l>8&&(Pt=l,l=I),0!=l){for(f=xl.rp(t,l),g=xl.rp(t,I),ut=xl.rp(t,l),Ht=xl.rp(t,l),bt=xl.rp(t,l),k=xl.rp(t,l),c=0;c<f;c++)xl.Mj(t.g,6);for(on=0;on<ut;on++)xl.om(t.g,xl.rp(t,l),7);for(ln=0;ln<Ht;ln++)xl.om(t.g,xl.rp(t,l),8);for(Cn=0;Cn<bt;Cn++)xl.om(t.g,xl.rp(t,l),xl.rp(t,8));for(Jn=0;Jn<k;Jn++)xl.Xl(t.g,xl.rp(t,l),xl.rp(t,4)-8);for(E=1+g-f,S=xl.rp(t,4),p=0,xl.lm(t.g,0,0),xl.mm(t.g,0,0),xl.nm(t.g,0,0),It=0,Nt=0,Lt=0,yt=0,F=!1,Q=!1,(G=null!=s&&s[r]>=39)&&(s.length>2*f-2&&39==s[2*f-2]||s.length>3*f-3&&39==s[3*f-3]?(Q=!0,T=86*(s[(tt=(F=s.length==3*f-3+9)?3*f-3:2*f-2)+1]-40)+s[tt+2]-40,It=n.Math.pow(10,T/2e3-1),Mt=86*(s[(tt+=2)+1]-40)+s[tt+2]-40,Nt=n.Math.pow(10,Mt/1500-1),wt=86*(s[(tt+=2)+1]-40)+s[tt+2]-40,Lt=n.Math.pow(10,wt/1500-1),F&&(Ut=86*(s[(tt+=2)+1]-40)+s[tt+2]-40,yt=n.Math.pow(10,Ut/1500-1))):F=s.length==3*f-3),t.Nb()&&F&&(s=null,G=!1),vn=1;vn<f;vn++)0!=(q=xl.rp(t,S))?(p+=q-1,G&&(xl.lm(t.g,vn,xl.Fk(t.g,p)+s[2*vn-2]-83),xl.mm(t.g,vn,xl.Gk(t.g,p)+s[2*vn-1]-83),F&&xl.nm(t.g,vn,xl.Hk(t.g,p)+(s[2*f-3+vn]-83))),xl.Oj(t.g,p,vn,1)):(G&&(xl.lm(t.g,vn,xl.Fk(t.g,0)+8*(s[2*vn-2]-83)),xl.mm(t.g,vn,xl.Gk(t.g,0)+8*(s[2*vn-1]-83)),F&&xl.nm(t.g,vn,xl.Hk(t.g,0)+8*(s[2*f-3+vn]-83))),++E);for(Kn=0;Kn<E;Kn++)xl.Oj(t.g,xl.rp(t,l),xl.rp(t,l),1);for(et=vf(yl.Lwb,nn,6,g,16,1),U=0;U<g;U++)switch(xl.rp(t,2)){case 0:et[U]=!0;break;case 2:xl.ym(t.g,U,2);break;case 3:xl.ym(t.g,U,4)}for(o=xl.rp(t,l),Wn=0;Wn<o;Wn++)if(d=xl.rp(t,l),8==Pt)3==(jt=xl.rp(t,2))?(xl.am(t.g,d,1,0),xl.gm(t.g,d,1,!1)):xl.gm(t.g,d,jt,!1);else switch(jt=xl.rp(t,3)){case 4:xl.gm(t.g,d,1,!1),xl.am(t.g,d,1,xl.rp(t,3));break;case 5:xl.gm(t.g,d,2,!1),xl.am(t.g,d,1,xl.rp(t,3));break;case 6:xl.gm(t.g,d,1,!1),xl.am(t.g,d,2,xl.rp(t,3));break;case 7:xl.gm(t.g,d,2,!1),xl.am(t.g,d,2,xl.rp(t,3));break;default:xl.gm(t.g,d,jt,!1)}for(8==Pt&&0==xl.rp(t,1)&&(t.g.L=!0),a=xl.rp(t,I),_n=0;_n<a;_n++)if(M=xl.rp(t,I),1==xl.Yk(t.g,M))switch(jt=xl.rp(t,3)){case 4:xl.vm(t.g,M,1,!1),xl.sm(t.g,M,1,xl.rp(t,3));break;case 5:xl.vm(t.g,M,2,!1),xl.sm(t.g,M,1,xl.rp(t,3));break;case 6:xl.vm(t.g,M,1,!1),xl.sm(t.g,M,2,xl.rp(t,3));break;case 7:xl.vm(t.g,M,2,!1),xl.sm(t.g,M,2,xl.rp(t,3));break;default:xl.vm(t.g,M,jt,!1)}else xl.vm(t.g,M,xl.rp(t,2),!1);for(xl.Am(t.g,1==xl.rp(t,1)),h=null,ct=0;1==xl.rp(t,1);)switch(ct+xl.rp(t,4)){case 0:for(ht=xl.rp(t,l),$n=0;$n<ht;$n++)d=xl.rp(t,l),xl.hm(t.g,d,zn,!0);break;case 1:for(ht=xl.rp(t,l),nt=0;nt<ht;nt++)d=xl.rp(t,l),lt=xl.rp(t,8),xl.fm(t.g,d,lt);break;case 2:for(ht=xl.rp(t,I),gn=0;gn<ht;gn++)xl.rp(t,I);break;case 3:for(ht=xl.rp(t,l),un=0;un<ht;un++)d=xl.rp(t,l),xl.hm(t.g,d,fn,!0);break;case 4:for(ht=xl.rp(t,l),dn=0;dn<ht;dn++)d=xl.rp(t,l),Tt=xg(Mg(xl.rp(t,4)),3),xl.hm(t.g,d,Tt,!0);break;case 5:for(ht=xl.rp(t,l),cn=0;cn<ht;cn++)d=xl.rp(t,l),u=xg(Mg(xl.rp(t,2)),1),xl.hm(t.g,d,u,!0);break;case 6:for(ht=xl.rp(t,l),bn=0;bn<ht;bn++)d=xl.rp(t,l),xl.hm(t.g,d,1,!0);break;case 7:for(ht=xl.rp(t,l),Dn=0;Dn<ht;Dn++)d=xl.rp(t,l),sn=xg(Mg(xl.rp(t,4)),7),xl.hm(t.g,d,sn,!0);break;case 8:for(ht=xl.rp(t,l),Hn=0;Hn<ht;Hn++){for(d=xl.rp(t,l),m=xl.rp(t,4),H=vf(yl.tlb,z,6,m,15,1),it=0;it<m;it++)j=xl.rp(t,8),H[it]=j;xl.bm(t.g,d,H)}break;case 9:for(ht=xl.rp(t,I),jn=0;jn<ht;jn++)M=xl.rp(t,I),Tt=xl.rp(t,2)<<7,xl.xm(t.g,M,Tt,!0);break;case 10:for(ht=xl.rp(t,I),mn=0;mn<ht;mn++)M=xl.rp(t,I),J=xl.rp(t,5),xl.xm(t.g,M,J,!0);break;case 11:for(ht=xl.rp(t,l),An=0;An<ht;An++)d=xl.rp(t,l),xl.hm(t.g,d,Sn,!0);break;case 12:for(ht=xl.rp(t,I),Tn=0;Tn<ht;Tn++)M=xl.rp(t,I),B=xl.rp(t,8)<<9,xl.xm(t.g,M,B,!0);break;case 13:for(ht=xl.rp(t,l),pn=0;pn<ht;pn++)d=xl.rp(t,l),mt=xg(Mg(xl.rp(t,3)),14),xl.hm(t.g,d,mt,!0);break;case 14:for(ht=xl.rp(t,l),In=0;In<ht;In++)d=xl.rp(t,l),gt=xg(Mg(xl.rp(t,5)),17),xl.hm(t.g,d,gt,!0);break;case 15:case 31:ct+=16;break;case 16:for(ht=xl.rp(t,l),Pn=0;Pn<ht;Pn++)d=xl.rp(t,l),Ct=xg(Mg(xl.rp(t,3)),22),xl.hm(t.g,d,Ct,!0);break;case 17:for(ht=xl.rp(t,l),Mn=0;Mn<ht;Mn++)d=xl.rp(t,l),xl.Vl(t.g,d,xl.rp(t,4));break;case 18:for(ht=xl.rp(t,l),ot=xl.rp(t,4),Nn=0;Nn<ht;Nn++){for(d=xl.rp(t,l),X=xl.rp(t,ot),st=vf(yl.plb,ft,6,X,15,1),it=0;it<X;it++)st[it]=xl.rp(t,7)<<24>>24;xl.$l(t.g,d,Jl.IHb((rt=st,yf.XKb(),rt)))}break;case 19:for(ht=xl.rp(t,l),wn=0;wn<ht;wn++)d=xl.rp(t,l),R=xg(Mg(xl.rp(t,3)),25),xl.hm(t.g,d,R,!0);break;case 20:for(ht=xl.rp(t,I),Ln=0;Ln<ht;Ln++)M=xl.rp(t,I),Ct=xl.rp(t,3)<<17,xl.xm(t.g,M,Ct,!0);break;case 21:for(ht=xl.rp(t,l),Un=0;Un<ht;Un++)d=xl.rp(t,l),xl.im(t.g,d,xl.rp(t,2)<<4);break;case 22:for(ht=xl.rp(t,l),yn=0;yn<ht;yn++)d=xl.rp(t,l),xl.hm(t.g,d,Xn,!0);break;case 23:for(ht=xl.rp(t,I),Bn=0;Bn<ht;Bn++)M=xl.rp(t,I),xl.xm(t.g,M,dt,!0);break;case 24:for(ht=xl.rp(t,I),Rn=0;Rn<ht;Rn++)M=xl.rp(t,I),u=xl.rp(t,2)<<21,xl.xm(t.g,M,u,!0);break;case 25:for(kn=0;kn<f;kn++)1==xl.rp(t,1)&&xl.jm(t.g,kn,!0);break;case 26:for(ht=xl.rp(t,I),h=vf(yl.tlb,z,6,ht,15,1),En=0;En<ht;En++)h[En]=xl.rp(t,I);break;case 27:for(ht=xl.rp(t,l),xn=0;xn<ht;xn++)d=xl.rp(t,l),xl.hm(t.g,d,tn,!0);break;case 28:for(ht=xl.rp(t,I),Fn=0;Fn<ht;Fn++)xl.ym(t.g,xl.rp(t,I),32);break;case 29:for(ht=xl.rp(t,l),Qn=0;Qn<ht;Qn++)d=xl.rp(t,l),en=xg(Mg(xl.rp(t,2)),30),xl.hm(t.g,d,en,!0);break;case 30:for(ht=xl.rp(t,l),Gn=0;Gn<ht;Gn++)d=xl.rp(t,l),Ct=xg(Mg(xl.rp(t,7)),32),xl.hm(t.g,d,Ct,!0);break;case 32:for(ht=xl.rp(t,l),qn=0;qn<ht;qn++)d=xl.rp(t,l),pt=xg(Mg(xl.rp(t,2)),44),xl.hm(t.g,d,pt,!0);break;case 33:for(ht=xl.rp(t,l),Yn=0;Yn<ht;Yn++)d=xl.rp(t,l),O=xg(Mg(xl.rp(t,5)),39),xl.hm(t.g,d,O,!0);break;case 34:for(ht=xl.rp(t,l),Zn=0;Zn<ht;Zn++)d=xl.rp(t,l),xl.hm(t.g,d,hn,!0);break;case 35:for(ht=xl.rp(t,I),Vn=0;Vn<ht;Vn++)M=xl.rp(t,I),xl.xm(t.g,M,Dt,!0);break;case 36:for(ht=xl.rp(t,I),On=0;On<ht;On++)M=xl.rp(t,I),y=xl.rp(t,2)<<5,xl.xm(t.g,M,y,!0);break;case 37:for(ht=xl.rp(t,I),an=0;an<ht;an++)M=xl.rp(t,I),y=0==xl.rp(t,1)?8:16,xl.ym(t.g,M,y)}if(xl.je(new xl.te(t.g),et,!1),null!=h)for(w=0,L=(N=h).length;w<L;++w)M=N[w],xl.ym(t.g,M,2==xl.Yk(t.g,M)?4:2);if(null==s&&!t.i&&i.length>t.e+1&&(32==i[t.e+1]||9==i[t.e+1])&&(s=i,r=t.e+2),null!=s)try{if(33==s[r]||35==s[r]){for(xl.sp(t,s,r+1),F=1==xl.rp(t,1),Q=1==xl.rp(t,1),P=1<<(At=2*xl.rp(t,4)),_=0,M=0,b=1;b<f;b++)M<g&&xl.Nk(t.g,1,M)==b?(_=xl.Nk(t.g,0,M++),W=1):(_=0,W=8),xl.lm(t.g,b,xl.Fk(t.g,_)+W*(xl.rp(t,At)-(P/2|0))),xl.mm(t.g,b,xl.Gk(t.g,_)+W*(xl.rp(t,At)-(P/2|0))),F&&xl.nm(t.g,b,xl.Hk(t.g,_)+W*(xl.rp(t,At)-(P/2|0)));if(35==s[r]){for(rn=0,$=vf(yl.tlb,z,6,f,15,1),D=0;D<f;D++)rn+=$[D]=xl.$n(t.g,D);for(d=0;d<f;d++)for(an=0;an<$[d];an++)sn=xl.Mj(t.g,1),xl.Oj(t.g,d,sn,1),xl.lm(t.g,sn,xl.Fk(t.g,d)+(xl.rp(t,At)-(P/2|0))),xl.mm(t.g,sn,xl.Gk(t.g,d)+(xl.rp(t,At)-(P/2|0))),F&&xl.nm(t.g,sn,xl.Hk(t.g,d)+(xl.rp(t,At)-(P/2|0)));f+=rn,g+=rn}if(C=F?1.5:(xl.Kj(),xl.Kj(),xl.Jj),A=xl.Kk(t.g,f,g,C),Q)for(Nt=(It=xl.qp(xl.rp(t,At),P))*xl.tp(xl.rp(t,At),P),Lt=It*xl.tp(xl.rp(t,At),P),F&&(yt=It*xl.tp(xl.rp(t,At),P)),W=It/A,d=0;d<f;d++)xl.lm(t.g,d,Nt+W*xl.Fk(t.g,d)),xl.mm(t.g,d,Lt+W*xl.Gk(t.g,d)),F&&xl.nm(t.g,d,yt+W*xl.Hk(t.g,d));else for(W=(It=1.5)/A,d=0;d<f;d++)xl.lm(t.g,d,W*xl.Fk(t.g,d)),xl.mm(t.g,d,W*xl.Gk(t.g,d)),F&&xl.nm(t.g,d,W*xl.Hk(t.g,d))}else if(F&&!Q&&0==It&&(It=1.5),0!=It&&0!=t.g.r){for(A=0,M=0;M<t.g.r;M++)Y=xl.Fk(t.g,xl.Nk(t.g,0,M))-xl.Fk(t.g,xl.Nk(t.g,1,M)),v=xl.Gk(t.g,xl.Nk(t.g,0,M))-xl.Gk(t.g,xl.Nk(t.g,1,M)),Z=F?xl.Hk(t.g,xl.Nk(t.g,0,M))-xl.Hk(t.g,xl.Nk(t.g,1,M)):0,A+=n.Math.sqrt(Y*Y+v*v+Z*Z);for(K=It/(A/=t.g.r),d=0;d<t.g.q;d++)xl.lm(t.g,d,xl.Fk(t.g,d)*K+Nt),xl.mm(t.g,d,xl.Gk(t.g,d)*K+Lt),F&&xl.nm(t.g,d,xl.Hk(t.g,d)*K+yt)}}catch(n){if(!_f(n=ag(n),18))throw og(n);V=n,Jl.Ez(V,(Jl.vIb(),Jl.uIb),""),Jl.IHb((at=i,yf.XKb(),at)),Jl.IHb(rt=s),s=null,F=!1}if((x=null!=s&&!F)||t.Nb())for(xl.iu(t.g,7),M=0;M<t.g.g;M++)2==xl.Vk(t.g,M)&&!xl.To(t.g,M)&&0==xl.Wk(t.g,M)&&xl.wm(t.g,M);if(xl.dp(t.g,0),!x&&t.Nb())try{t.Ob(t.g),x=!0}catch(n){if(!_f(n=ag(n),18))throw og(n);V=n,Jl.Ez(V,(Jl.vIb(),Jl.uIb),""),Jl.IHb((rt=i,yf.XKb(),rt))}x?(xl.gp(t.g),xl.vu(t.g)):F||xl.dp(t.g,0)}else xl.Am(t.g,1==xl.rp(t,1))},xl.Bp=function(n,t){var e,i,s,r,a,o;if(!(t.length<=0||t[0]<64))for(xl.sp(n,t,0),o=xl.rp(n,4),s=1==xl.rp(n,1),r=1==xl.rp(n,1),e=0;e<n.g.f;e++)a=xl.rp(n,o),i=s,s&&r&&(i=1==xl.rp(n,1)),xl.dm(n.g,e,a,i)},xl.Cp=function(){},zf(397,1,{},xl.Cp),o.Nb=function(){return!1},o.Ob=function(n){throw og(new Jl.Xz("Unexpected request to invent coordinates. Check source code logic!"))},o.d=0,o.e=0,o.f=0,o.i=!1,yl.Slb=lg(397),xl.Fp=function(n){},xl.Gp=function(){xl.Hp.call(this,!0)},xl.Hp=function(n){xl.Fp(this),this.b=n},zf(51,397,{},xl.Gp,xl.Hp),o.Nb=function(){return this.b},o.Ob=function(n){var t;(t=new Sl.ty(this.a)).g=new Fl.bRb(78187493520),Sl.ay(t,n)},o.a=2,o.b=!1,yl.Tlb=lg(51),xl.Kp=function(t,e,i,s){var r,a,o,l,f,g,u,h,d,c,b,D,H,j;r=e.a,c=e.g,g=Rg(Cg(xl.Dk(t.k,r),1),0),h=null!=(a=xl.yk(t.k,r))?xl.Rp(t,r,a,s):g?"*":xl.xk(t.k,r),!g&&null==a&&xl.Co(t.k,r)&&0==(4&t.j)&&(0!=xl.Bn(t.k,r)||-1==xl.pk(t.k,r)&&0==xl.Ek(t.k,r))&&(h=kl.TTb(h).toLowerCase()),e.f&&(i.a+="("),-1!=c&&xl.Op(t,xl.In(t.k,e.a,e.g),e.g,i),0==(o=xl.rk(t.k,r))&&0!=(1&t.j)&&(0==Tg(l=Cg(xl.Dk(t.k,r),bn),jn)?o=-1:0==Tg(l,Hn)&&(o=1)),u=xl.Bk(t.k,r),d=0!=(2&t.j)?xl.Ak(t.k,r):0,b=0!=(1&t.j)?xl.Xp(t,r,s):null,(j=!g&&!xl.cq(xl.Ik(t.k,r))||null!=a||(1==xl.Ck(t.k,r)||2==xl.Ck(t.k,r))&&!(-1!=(H=xl.wk(t.k,r)-1)&&t.i[H][xl.vk(t.k,r)]<=1)&&(7!=xl.Ik(t.k,r)||xl.rk(t.k,r)>0)||xl.Co(t.k,r)&&0==xl.Bn(t.k,r)&&0==(4&t.j)||0!=o||0!=u||0!=d||-1!=xl.pk(t.k,r)||0!=xl.Ek(t.k,r)||null!=b)&&(i.a+="["),0!=u&&(i.a+=u),i.a+=""+h,(1==xl.Ck(t.k,r)||2==xl.Ck(t.k,r))&&!(-1!=(D=xl.wk(t.k,r)-1)&&t.i[D][xl.vk(t.k,r)]<=1)&&(7!=xl.Ik(t.k,r)||xl.rk(t.k,r)>0)&&Jl.nIb(i,xl.Wp(t,r,c)),0==(1&t.j)&&j&&(1==(f=xl.lo(t.k,r))?i.a+="H":f>1&&(i.a+="H"+f)),0!=o&&(i.a+=String.fromCharCode(o>0?43:45),n.Math.abs(o)>1&&Jl.kIb(i,n.Math.abs(o))),null!=b&&(i.a+=""+b),0!=d&&(i.a+=":",i.a+=d),j&&(i.a+="]"),xl.Pp(t,e,i),e.e&&(i.a+=")")},xl.Lp=function(n,t,e){var i,s,r,a,o;for(r=!0,o=Fl.Pi(n.g,t).a,a=xl.$p(n,o);-1!=a;)i=xl.Kn(n.k,o,a),s=xl.Mn(n.k,o,a),a=xl.$p(n,i),xl.Np(n,new xl.vt(i,s,o,e&&r,e&&-1==a),++t),o=i,r=!1},xl.Mp=function(n,t,e){var i,s,r,a;for(r=0,a=(s=t).length;r<a;++r)i=s[r],n.f[1073741823&i]=0!=(i&Ft)^e?2:1},xl.Np=function(n,t,e){Fl.Ji(n.g,e,t),n.b[t.a]=!0,-1!=t.g&&(n.c[xl.In(n.k,t.a,t.g)]=!0)},xl.Op=function(n,t,e,i){var s,r,a,o,l;l=kl.TTb(i.a).length,0!=n.f[t]&&Jl.jIb(i,1==n.f[t]?47:92),1==n.j&&0!=(r=xl.Xk(n.k,127))&&(0!=(1&r)&&0==n.f[t]&&(i.a+="-"),0!=(2&r)&&(kl.TTb(i.a).length!=l&&(i.a+=","),i.a+="="),0!=(4&r)&&(kl.TTb(i.a).length!=l&&(i.a+=","),i.a+="#"),0!=(8&r)&&(kl.TTb(i.a).length!=l&&(i.a+=","),i.a+="$"),0!=(16&r)&&(kl.TTb(i.a).length!=l&&(i.a+=","),i.a+="$"),0!=(64&r)&&(kl.TTb(i.a).length!=l&&(i.a+=","),i.a+=":"),0!=(32&r)&&(kl.TTb(i.a).length!=l&&(i.a+=","),Jl.nIb(i,xl.yl(n.k,e)?"<-":"->"))),l!=kl.TTb(i.a).length||xl.Do(n.k,t)&&0==(4&n.j)||(1==(s=127&xl.Yk(n.k,t))?xl.Co(n.k,xl.Nk(n.k,0,t))&&xl.Co(n.k,xl.Nk(n.k,1,t))&&0==(4&n.j)&&0==n.f[t]&&(i.a+="-"):2==s?i.a+="=":4==s?i.a+="#":8==s||16==s?i.a+="$":64==s?i.a+=":":32==s&&Jl.nIb(i,xl.yl(n.k,e)?"<-":"->")),1==n.j&&(a=l==kl.TTb(i.a).length?"":";",256==(o=384&xl.Xk(n.k,t))?i.a+=a+"@":128==o&&(i.a+=a+"!@"))},xl.Pp=function(n,t,e){var i,s,r;if(null!=t.c)for(s=0;s<t.c.length;s++)for(r=0;r<xl.Ln(n.k,t.a);r++)t.c[s]==xl.Kn(n.k,t.a,r)&&(i=xl.Mn(n.k,t.a,r),t.d[s]||xl.Op(n,i,t.a,e),n.e[i]>9&&(e.a+="%"),Jl.kIb(e,n.e[i]))},xl.Qp=function(n){var t,e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,P,M,N,w,L,U,y,J,B,R,k,E,x;for(k=new Fl.cj,H=new Fl.zOb(n.g);H.a<H.c.a.length;)if(-1!=(D=Fl.yOb(H)).g&&(m=xl.In(n.k,D.a,D.g),!(xl.Eo(n.k,m)||xl.To(n.k,m)||1!=xl.Wk(n.k,m)&&2!=xl.Wk(n.k,m)))){if(B=Fl.Pi(n.g,n.q[D.g]),e=vf(yl.tlb,z,6,xl.Ln(n.k,D.a)+xl.Ln(n.k,B.a)-2,15,1),P=0,R=!1,-1!=B.g)e[P++]=B.b;else{for(A=-1,E=-1,C=I,N=0;N<xl.Ln(n.k,B.a);N++)(u=xl.Kn(n.k,B.a,N))!=D.a&&(-1==A?(A=N,C=n.q[u]):C<n.q[u]?E=N:(E=A,A=N));-1==E?(U=xl.Kn(n.k,B.a,A),y=xl.Mn(n.k,B.a,A),e[P++]=y|(xl.aq(n,B.a,U)?Ft:0)):(h=xl.Kn(n.k,B.a,A),c=xl.Mn(n.k,B.a,A),d=xl.Kn(n.k,B.a,E),b=xl.Mn(n.k,B.a,E),e[P++]=c|(xl.aq(n,B.a,h)?Ft:0),e[P++]=b|(xl.aq(n,B.a,d)?0:Ft))}if(3==xl.Ln(n.k,B.a)&&-1!=B.g)for(N=0;N<xl.Ln(n.k,B.a);N++)if((u=xl.Kn(n.k,B.a,N))!=B.g&&u!=D.a){i=xl.Mn(n.k,B.a,N),e[P++]=i|(xl.aq(n,B.a,u)?Ft:0),u<B.g&&(R=!R);break}for(2==xl.Wk(n.k,m)&&(R=!R),M=0;M<xl.Ln(n.k,D.a);M++)if((l=xl.Kn(n.k,D.a,M))!=D.g){if(p=R,3==xl.Ln(n.k,D.a))for(L=0;L<xl.Ln(n.k,D.a);L++)if((u=xl.Kn(n.k,D.a,L))!=D.g&&u!=l){u<l&&(p=!p);break}xl.tl(n.k,m)&&(T=xl.Pf(n.d,m),n.n[T]||(n.n[T]=!0,n.o[T]=p),n.o[T]&&(p=!p)),f=xl.In(n.k,D.a,l),e[P++]=f|(p^xl.aq(n,D.a,l)?0:Ft)}kl.kTb(k.a,e)}for(n.f=vf(yl.tlb,z,6,n.k.g,15,1),0!=k.a.length&&xl.Mp(n,Fl.Wi(k,0),!1);0!=k.a.length;){for(x=k.a.length,M=k.a.length-1;M>=0;M--){for(kl.HTb(M,k.a.length),J=0,w=!1,g=!1,a=0,o=(r=e=k.a[M]).length;a<o;++a)t=1073741823&(s=r[a]),0!=n.f[t]&&(j=0!=(s&Ft)^2==n.f[t],0==J?w=j:w!=j&&(g=!0),++J);0!=J&&(e=Fl.Wi(k,M),g||xl.Mp(n,e,w))}x==k.a.length&&xl.Mp(n,Fl.Wi(k,0),!1)}},xl.Rp=function(n,t,e,i){var s,r,a,o,l,f,g;for(0<(g=kl.TTb(i.a).length)?i.a=Jl.YHb(i.a,0,0):0>g&&(i.a+=Jl.bIb(vf(yl.qlb,st,6,-g,15,1))),l=xl.Co(n.k,t)&&0==(4&n.j),a=0,o=(r=e).length;a<o;++a)s=r[a],0!=kl.TTb(i.a).length&&(i.a+=","),f=(xl.Kj(),xl.Ej)[s],Jl.nIb(i,l?kl.TTb(f).toLowerCase():f);return i.a},xl.Sp=function(n){var t,e,i,s,r,a,o,l;if(!n.k||0==n.k.q)return"";for(xl.iu(n.k,15),n.d=new xl.ig(n.k,129),s=n.d.R,n.o=vf(yl.Lwb,nn,6,s+1,16,1),n.n=vf(yl.Lwb,nn,6,s+1,16,1),n.i=Yf(yl.tlb,[ot,z],[8,6],15,[2,32],2),t=0;t<n.k.f;t++)-1!=(l=xl.wk(n.k,t)-1)&&++n.i[l][xl.vk(n.k,t)];for(xl.Vp(n),xl.Tp(n),xl.Qp(n),i=new Jl.qIb,e=new Jl.qIb,r=!0,o=new Fl.zOb(n.g);o.a<o.c.a.length;)-1==(a=Fl.yOb(o)).g&&(r?r=!1:i.a+="."),xl.Kp(n,a,i,e);return i.a},xl.Tp=function(n){var t,e,i,s,r,a,o,l,f,g,u;for(u=new Fl.zOb(n.g);u.a<u.c.a.length;){for(f=Fl.yOb(u),e=0,r=0;r<xl.Ln(n.k,f.a);r++)n.c[xl.Mn(n.k,f.a,r)]||++e;if(0!=e){for(f.c=vf(yl.tlb,z,6,e,15,1),e=0,a=0;a<xl.Ln(n.k,f.a);a++)n.c[xl.Mn(n.k,f.a,a)]||(l=xl.Kn(n.k,f.a,a),f.c[e++]=n.q[l]<<16|l);for(kl.nTb(f.c,kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[]))),s=0;s<f.c.length;s++)f.c[s]=B&f.c[s]}}for(i=vf(yl.Lwb,nn,6,n.k.g,16,1),n.e=vf(yl.tlb,z,6,n.k.g,15,1),g=new Fl.zOb(n.g);g.a<g.c.a.length;)if(null!=(f=Fl.yOb(g)).c)for(f.d=vf(yl.Lwb,nn,6,f.c.length,16,1),s=0;s<f.c.length;s++)for(o=0;o<xl.Ln(n.k,f.a);o++)if(f.c[s]==xl.Kn(n.k,f.a,o))if(t=xl.Mn(n.k,f.a,o),n.c[t])i[n.e[t]]=!1;else{for(n.c[t]=!0,f.d[s]=!0,n.e[t]=1;i[n.e[t]];)++n.e[t];i[n.e[t]]=!0}},xl.Up=function(n){var t,e,i,s;for(i=-1,s=I,t=0;t<n.k.f;t++)n.b[t]||(e=n.a[t],Rg(Cg(xl.Dk(n.k,t),tn),0)&&(e+=Ft),0==xl.Ln(n.k,t)?e+=1056964608:e+=xl.Ln(n.k,t)<<24,s>e&&(s=e,i=t));return i},xl.Vp=function(n){var t,e,i,s,r;for(n.a=n.d.d,n.b=vf(yl.Lwb,nn,6,n.k.f,16,1),n.c=vf(yl.Lwb,nn,6,n.k.g,16,1),n.g=new Fl.cj,t=xl.Up(n);-1!=t;){if(e=n.g.a.length,xl.Np(n,new xl.vt(t,-1,-1,!1,!1),e),0!=xl.Ln(n.k,t))for(xl.Lp(n,e,!1);e<n.g.a.length-1;){for(;xl._p(n,Fl.Pi(n.g,e).a);)xl.Lp(n,e,!0);++e}t=xl.Up(n)}for(n.q=vf(yl.tlb,z,6,n.k.f,15,1),i=0,r=new Fl.zOb(n.g);r.a<r.c.a.length;)s=Fl.yOb(r),n.q[s.a]=i++},xl.Wp=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d;if(o=!1,0!=xl.Bn(n.k,t)&&2==xl.Ln(n.k,t)&&2==xl.Nn(n.k,t,0)&&2==xl.Nn(n.k,t,1))for(r=0;r<xl.Ln(n.k,t);r++){for(i=xl.Kn(n.k,t,r),d=0,h=vf(yl.tlb,z,6,3,15,1),f=0;f<xl.Ln(n.k,i);f++)h[d]=xl.Kn(n.k,i,f),h[d]!=t&&++d;2==d&&n.q[h[0]]<n.q[h[1]]^h[0]<h[1]&&(o=!o)}else{for(g=vf(yl.tlb,z,6,4,15,1),u=vf(yl.tlb,z,6,4,15,1),a=0,-1!=e&&(g[a]=e,u[a++]=8*n.q[e]),(0!=xl.$n(n.k,t)||3==xl.Ln(n.k,t))&&(g[a]=I,u[a++]=8*n.q[t]),r=0;r<xl.Ln(n.k,t);r++)(i=xl.Kn(n.k,t,r))!=e&&(g[a]=i,u[a++]=xl.Zp(n,t,r));o=xl.bq(g,u)}return l=1==xl.Ck(n.k,t)^o,xl.ml(n.k,t)&&(s=xl.Qf(n.d,t),n.n[s]||(n.n[s]=!0,n.o[s]=l),n.o[s]&&(l=!l)),l?"@@":"@"},xl.Xp=function(n,t,e){var i,s,r,a,o,l,f;switch(0<(a=kl.TTb(e.a).length)?e.a=Jl.YHb(e.a,0,0):0>a&&(e.a+=Jl.bIb(vf(yl.qlb,st,6,-a,15,1))),zg(Fg(Cg(o=xl.Dk(n.k,t),bn),3))){case 20971520:e.a+="+0";break;case 25165824:0==xl.rk(n.k,t)&&(e.a+="-");break;case 12582912:0==xl.rk(n.k,t)&&(e.a+="+")}return 0==Tg(i=Cg(o,ht),2)?e.a+=";a":0==Tg(i,4)&&(e.a+=";A"),0!=Tg(s=Cg(o,dn),0)&&(0==Tg(s,1792)?e.a+=";H0":0==Tg(s,1664)?e.a+=";H1":0==Tg(s,1408)?e.a+=";H2":0==Tg(s,896)?e.a+=";H3":0==Tg(s,128)?e.a+=";!H0":0==Tg(s,384)?e.a+=";!H0;!H1":0==Tg(s,1536)?e.a+=";!H2;!H3":0==Tg(s,cn)&&(e.a+=";!H3")),0==Tg(f=Cg(o,120),8)?e.a+=";!R0":0==Tg(f,16)?e.a+=";!R1":0==Tg(f,32)?e.a+=";!R2":0==Tg(f,64)?e.a+=";!R3":0==Tg(f,112)?e.a+=";R0":0==Tg(f,104)?e.a+=";R1":0==Tg(f,88)?e.a+=";R2":0==Tg(f,56)&&(e.a+=";R3"),0==Tg(l=Cg(o,v),Z)?e.a+=";!r"+Gg(l):0==Tg(l,Qt)?e.a+=";r"+Gg(l):0!=Tg(l,0)&&(Rg(Cg(l,$),0)?(Ig(Cg(l,Z),0)&&(e.a+=";!r0"+Gg(l)),Ig(Cg(l,V),0)&&(e.a+=";!r3"+Gg(l)),Ig(Cg(l,O),0)&&(e.a+=";!r4"+Gg(l)),Ig(Cg(l,K),0)&&(e.a+=";!r5"+Gg(l)),Ig(Cg(l,W),0)&&(e.a+=";!r6"+Gg(l)),Ig(Cg(l,_),0)&&(e.a+=";!r7"+Gg(l))):(e.a+=";",Rg(Cg(l,Z),0)&&(e.a+="r0,"+Gg(l)),Rg(Cg(l,V),0)&&(e.a+="r3,"+Gg(l)),Rg(Cg(l,O),0)&&(e.a+="r4,"+Gg(l)),Rg(Cg(l,K),0)&&(e.a+="r5,"+Gg(l)),Rg(Cg(l,W),0)&&(e.a+="r6,"+Gg(l)),Rg(Cg(l,_),0)&&(e.a+="r7,"+Gg(l)),Jl.hFb(e,kl.TTb(e.a).length-1))),0==Tg(l,0)&&0!=Tg(l=Fg(Cg(o,Qn),22),0)&&(e.a+=";r"+Gg(l)),0==Tg(r=Cg(o,An),Cn)&&(e.a+=";D1"),0==Tg(r,Tn)&&(e.a+=";D2"),0==Tg(r,pn)&&(e.a+=";D3"),0==Tg(r,In)&&(e.a+=";!D3;!D4"),0==Tg(r,Pn)&&(e.a+=";!D4"),0==Tg(r,Mn)&&(e.a+=";!D0;!D1"),0==Tg(r,Nn)&&(e.a+=";!D0;!D1;!D2"),0==Tg(r,wn)&&(e.a+=";!D0;!D1;!D2;!D3"),Rg(Cg(o,zn),0)&&Jl.nIb(e,";D"+xl.Ln(n.k,t)),Rg(Cg(o,fn),0)&&Jl.nIb(e,";!D"+xl.Ln(n.k,t)),0==kl.TTb(e.a).length?null:e.a},xl.Yp=function(n){return null==n.p&&(n.p=xl.Sp(n)),n.p},xl.Zp=function(n,t,e){var i,s,r,a,o;if(i=xl.Mn(n.k,t,e),a=xl.Kn(n.k,t,e),0!=n.e[i]){for(o=8*n.q[t]+1,s=Fl.Pi(n.g,n.q[t]).c,r=0;r<s.length&&a!=s[r];r++)++o;return o}return 8*n.q[a]},xl.$p=function(n,t){var e,i,s,r,a;for(e=-1,i=-1,r=0;r<xl.Ln(n.k,t);r++)s=xl.Kn(n.k,t,r),a=(xl.Nn(n.k,t,r)<<24)+n.a[s],!n.b[s]&&(-1==e||i<a)&&(e=r,i=a);return e},xl._p=function(n,t){var e;for(e=0;e<xl.Ln(n.k,t);e++)if(!n.b[xl.Kn(n.k,t,e)])return!0;return!1},xl.aq=function(n,t,e){var i;return Fl.Pi(n.g,n.q[t]).g!=e&&((i=Fl.Pi(n.g,n.q[e])).g==t||xl.ut(i,t))},xl.bq=function(n,t){var e,i,s;for(i=!1,e=1;e<4;e++)for(s=0;s<e;s++)n[s]>n[e]&&(i=!i),t[s]>t[e]&&(i=!i);return i},xl.cq=function(n){return n>=5&&n<=9||n>=15&&n<=17||35==n||53==n},xl.dq=function(n){xl.fq.call(this,n,!1)},xl.eq=function(n,t){this.k=n,this.j=t},xl.fq=function(n,t){xl.eq.call(this,n,t?2:0)},xl.gq=function(n){var t,e,i,s;for(s=new Jl.qIb,e=0;e<n.g.a.length;e++)0!=e&&(s.a+="."),Jl.nIb(s,xl.Yp(new xl.eq(Fl.Pi(n.g,e),2)));for(s.a+=">",i=0;i<n.a.a.length;i++)0!=i&&(s.a+="."),Jl.nIb(s,xl.Yp(new xl.dq(Fl.Pi(n.a,i))));for(s.a+=">",t=0;t<n.f.a.length;t++)0!=t&&(s.a+="."),Jl.nIb(s,xl.Yp(new xl.eq(Fl.Pi(n.f,t),2)));return s.a},zf(112,1,{},xl.dq,xl.eq,xl.fq),o.j=0,yl.Ulb=lg(112),xl.hq=function(n,t){this.b=n,this.a=t},zf(3,1,{3:1},xl.hq),o.a=0,o.b=0,yl.Vlb=lg(3),xl.jq=function(){xl.jq=Xf,xl.iq=Of(qf(yl.Vlb,2),j,17,0,[null,Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(0,1.007825032),new xl.hq(1,2.014101778),new xl.hq(2,3.016049268),new xl.hq(3,4.027834627),new xl.hq(4,5.039542911),new xl.hq(5,6.044942608)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(1,3.01602931),new xl.hq(2,4.00260325),new xl.hq(3,5.012223628),new xl.hq(4,6.018888072),new xl.hq(5,7.028030527),new xl.hq(6,8.033921838),new xl.hq(7,9.043820323),new xl.hq(8,10.052399713)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(1,4.027182329),new xl.hq(2,5.012537796),new xl.hq(3,6.015122281),new xl.hq(4,7.016004049),new xl.hq(5,8.02248667),new xl.hq(6,9.026789122),new xl.hq(7,10.035480884),new xl.hq(8,11.043796166),new xl.hq(9,12.05378)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(1,5.04079),new xl.hq(2,6.019725804),new xl.hq(3,7.016929246),new xl.hq(4,8.005305094),new xl.hq(5,9.012182135),new xl.hq(6,10.01353372),new xl.hq(7,11.021657653),new xl.hq(8,12.026920631),new xl.hq(9,13.036133834),new xl.hq(10,14.042815522)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(2,7.029917389),new xl.hq(3,8.024606713),new xl.hq(4,9.013328806),new xl.hq(5,10.012937027),new xl.hq(6,11.009305466),new xl.hq(7,12.014352109),new xl.hq(8,13.017780267),new xl.hq(9,14.025404064),new xl.hq(10,15.031097291),new xl.hq(11,16.039808836),new xl.hq(12,17.046931399),new xl.hq(13,18.05617),new xl.hq(14,19.06373)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(2,8.037675026),new xl.hq(3,9.031040087),new xl.hq(4,10.01685311),new xl.hq(5,11.011433818),new xl.hq(6,12),new xl.hq(7,13.003354838),new xl.hq(8,14.003241988),new xl.hq(9,15.010599258),new xl.hq(10,16.014701243),new xl.hq(11,17.022583712),new xl.hq(12,18.026757058),new xl.hq(13,19.035248094),new xl.hq(14,20.040322395),new xl.hq(15,21.04934),new xl.hq(16,22.05645)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(3,10.042618),new xl.hq(4,11.026796226),new xl.hq(5,12.018613202),new xl.hq(6,13.005738584),new xl.hq(7,14.003074005),new xl.hq(8,15.000108898),new xl.hq(9,16.006101417),new xl.hq(10,17.008449673),new xl.hq(11,18.014081827),new xl.hq(12,19.017026896),new xl.hq(13,20.023367295),new xl.hq(14,21.027087574),new xl.hq(15,22.034440259),new xl.hq(16,23.04051),new xl.hq(17,24.0505)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(4,12.034404776),new xl.hq(5,13.0248104),new xl.hq(6,14.008595285),new xl.hq(7,15.003065386),new xl.hq(8,15.994914622),new xl.hq(9,16.999131501),new xl.hq(10,17.999160419),new xl.hq(11,19.00357873),new xl.hq(12,20.00407615),new xl.hq(13,21.008654631),new xl.hq(14,22.009967157),new xl.hq(15,23.015691325),new xl.hq(16,24.020369922),new xl.hq(17,25.02914),new xl.hq(18,26.03775)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(5,14.03608),new xl.hq(6,15.018010856),new xl.hq(7,16.01146573),new xl.hq(8,17.002095238),new xl.hq(9,18.000937667),new xl.hq(10,18.998403205),new xl.hq(11,19.999981324),new xl.hq(12,20.999948921),new xl.hq(13,22.00299925),new xl.hq(14,23.003574385),new xl.hq(15,24.008099371),new xl.hq(16,25.012094963),new xl.hq(17,26.019633157),new xl.hq(18,27.026892316),new xl.hq(19,28.03567),new xl.hq(20,29.04326)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(6,16.025756907),new xl.hq(7,17.017697565),new xl.hq(8,18.005697066),new xl.hq(9,19.001879839),new xl.hq(10,19.992440176),new xl.hq(11,20.993846744),new xl.hq(12,21.99138551),new xl.hq(13,22.994467337),new xl.hq(14,23.993615074),new xl.hq(15,24.997789899),new xl.hq(16,26.000461498),new xl.hq(17,27.0076152),new xl.hq(18,28.012108072),new xl.hq(19,29.019345902),new xl.hq(20,30.023872),new xl.hq(21,31.03311),new xl.hq(22,32.03991)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(7,18.02718),new xl.hq(8,19.01387945),new xl.hq(9,20.00734826),new xl.hq(10,20.997655099),new xl.hq(11,21.994436782),new xl.hq(12,22.989769675),new xl.hq(13,23.990963332),new xl.hq(14,24.989954352),new xl.hq(15,25.992589898),new xl.hq(16,26.994008702),new xl.hq(17,27.99889041),new xl.hq(18,29.002811301),new xl.hq(19,30.009226487),new xl.hq(20,31.013595108),new xl.hq(21,32.019649792),new xl.hq(22,33.027386),new xl.hq(23,34.0349),new xl.hq(24,35.04418)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(8,20.018862744),new xl.hq(9,21.011714174),new xl.hq(10,21.999574055),new xl.hq(11,22.99412485),new xl.hq(12,23.985041898),new xl.hq(13,24.985837023),new xl.hq(14,25.98259304),new xl.hq(15,26.984340742),new xl.hq(16,27.983876703),new xl.hq(17,28.988554743),new xl.hq(18,29.990464529),new xl.hq(19,30.996548459),new xl.hq(20,31.999145889),new xl.hq(21,33.005586975),new xl.hq(22,34.00907244),new xl.hq(23,35.018669),new xl.hq(24,36.02245),new xl.hq(25,37.03124)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(8,21.02804),new xl.hq(9,22.01952),new xl.hq(10,23.0072649),new xl.hq(11,23.999940911),new xl.hq(12,24.990428555),new xl.hq(13,25.986891659),new xl.hq(14,26.981538441),new xl.hq(15,27.981910184),new xl.hq(16,28.980444848),new xl.hq(17,29.982960304),new xl.hq(18,30.983946023),new xl.hq(19,31.988124379),new xl.hq(20,32.990869587),new xl.hq(21,33.996927255),new xl.hq(22,34.99993765),new xl.hq(23,36.006351501),new xl.hq(24,37.01031),new xl.hq(25,38.0169),new xl.hq(26,39.0219)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(8,22.03453),new xl.hq(9,23.02552),new xl.hq(10,24.011545711),new xl.hq(11,25.00410664),new xl.hq(12,25.992329935),new xl.hq(13,26.986704764),new xl.hq(14,27.976926533),new xl.hq(15,28.976494719),new xl.hq(16,29.973770218),new xl.hq(17,30.975363275),new xl.hq(18,31.974148129),new xl.hq(19,32.97800052),new xl.hq(20,33.978575745),new xl.hq(21,34.984584158),new xl.hq(22,35.986687363),new xl.hq(23,36.99299599),new xl.hq(24,37.99598),new xl.hq(25,39.0023),new xl.hq(26,40.0058),new xl.hq(27,41.0127),new xl.hq(28,42.0161)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(9,24.03435),new xl.hq(10,25.02026),new xl.hq(11,26.01178),new xl.hq(12,26.999191645),new xl.hq(13,27.99231233),new xl.hq(14,28.981801376),new xl.hq(15,29.978313807),new xl.hq(16,30.973761512),new xl.hq(17,31.973907163),new xl.hq(18,32.971725281),new xl.hq(19,33.973636381),new xl.hq(20,34.973314249),new xl.hq(21,35.978259824),new xl.hq(22,36.979608338),new xl.hq(23,37.98447),new xl.hq(24,38.98642),new xl.hq(25,39.99105),new xl.hq(26,40.9948),new xl.hq(27,42.00009),new xl.hq(28,43.00331),new xl.hq(29,44.00988),new xl.hq(30,45.01514),new xl.hq(31,46.02383)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(10,26.02788),new xl.hq(11,27.018795),new xl.hq(12,28.004372661),new xl.hq(13,28.996608805),new xl.hq(14,29.984902954),new xl.hq(15,30.979554421),new xl.hq(16,31.97207069),new xl.hq(17,32.971458497),new xl.hq(18,33.967866831),new xl.hq(19,34.96903214),new xl.hq(20,35.96708088),new xl.hq(21,36.971125716),new xl.hq(22,37.971163443),new xl.hq(23,38.975135275),new xl.hq(24,39.97547),new xl.hq(25,40.98003),new xl.hq(26,41.98149),new xl.hq(27,42.9866),new xl.hq(28,43.98832),new xl.hq(29,44.99482),new xl.hq(30,45.99957),new xl.hq(31,47.00762),new xl.hq(32,48.01299),new xl.hq(33,49.02201)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(11,28.02851),new xl.hq(12,29.01411),new xl.hq(13,30.00477),new xl.hq(14,30.992416014),new xl.hq(15,31.985688908),new xl.hq(16,32.977451798),new xl.hq(17,33.973761967),new xl.hq(18,34.968852707),new xl.hq(19,35.968306945),new xl.hq(20,36.9659026),new xl.hq(21,37.96801055),new xl.hq(22,38.968007677),new xl.hq(23,39.970415555),new xl.hq(24,40.970650212),new xl.hq(25,41.973174994),new xl.hq(26,42.974203385),new xl.hq(27,43.978538712),new xl.hq(28,44.9797),new xl.hq(29,45.98412),new xl.hq(30,46.98795),new xl.hq(31,47.99485),new xl.hq(32,48.99989),new xl.hq(33,50.00773),new xl.hq(34,51.01353)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(12,30.02156),new xl.hq(13,31.012126),new xl.hq(14,31.99766066),new xl.hq(15,32.989928719),new xl.hq(16,33.980270118),new xl.hq(17,34.975256726),new xl.hq(18,35.967546282),new xl.hq(19,36.966775912),new xl.hq(20,37.962732161),new xl.hq(21,38.964313413),new xl.hq(22,39.962383123),new xl.hq(23,40.964500828),new xl.hq(24,41.963046386),new xl.hq(25,42.965670701),new xl.hq(26,43.965365269),new xl.hq(27,44.968094979),new xl.hq(28,45.968093467),new xl.hq(29,46.972186238),new xl.hq(30,47.97507),new xl.hq(31,48.98218),new xl.hq(32,49.98594),new xl.hq(33,50.99324),new xl.hq(34,51.99817),new xl.hq(35,53.006227)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(13,32.02192),new xl.hq(14,33.00726),new xl.hq(15,33.99841),new xl.hq(16,34.988011615),new xl.hq(17,35.981293405),new xl.hq(18,36.973376915),new xl.hq(19,37.969080107),new xl.hq(20,38.963706861),new xl.hq(21,39.963998672),new xl.hq(22,40.961825972),new xl.hq(23,41.962403059),new xl.hq(24,42.960715746),new xl.hq(25,43.961556146),new xl.hq(26,44.960699658),new xl.hq(27,45.961976203),new xl.hq(28,46.961677807),new xl.hq(29,47.965512946),new xl.hq(30,48.967450084),new xl.hq(31,49.972782832),new xl.hq(32,50.97638),new xl.hq(33,51.98261),new xl.hq(34,52.98712),new xl.hq(35,53.99399),new xl.hq(36,54.999388)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(14,34.01412),new xl.hq(15,35.004765),new xl.hq(16,35.993087234),new xl.hq(17,36.985871505),new xl.hq(18,37.976318637),new xl.hq(19,38.970717729),new xl.hq(20,39.962591155),new xl.hq(21,40.962278349),new xl.hq(22,41.958618337),new xl.hq(23,42.958766833),new xl.hq(24,43.955481094),new xl.hq(25,44.956185938),new xl.hq(26,45.953692759),new xl.hq(27,46.954546459),new xl.hq(28,47.952533512),new xl.hq(29,48.955673302),new xl.hq(30,49.957518286),new xl.hq(31,50.961474238),new xl.hq(32,51.9651),new xl.hq(33,52.97005),new xl.hq(34,53.97468),new xl.hq(35,54.98055),new xl.hq(36,55.98579),new xl.hq(37,56.992356)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(15,36.01492),new xl.hq(16,37.00305),new xl.hq(17,37.9947),new xl.hq(18,38.984790009),new xl.hq(19,39.977964014),new xl.hq(20,40.969251316),new xl.hq(21,41.965516761),new xl.hq(22,42.96115098),new xl.hq(23,43.959403048),new xl.hq(24,44.955910243),new xl.hq(25,45.95517025),new xl.hq(26,46.952408027),new xl.hq(27,47.952234991),new xl.hq(28,48.950024065),new xl.hq(29,49.952187008),new xl.hq(30,50.9536027),new xl.hq(31,51.95665),new xl.hq(32,52.95817),new xl.hq(33,53.963),new xl.hq(34,54.9694),new xl.hq(35,55.97266),new xl.hq(36,56.97704),new xl.hq(37,57.98307),new xl.hq(38,58.988041)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(16,38.00977),new xl.hq(17,39.001323),new xl.hq(18,39.990498907),new xl.hq(19,40.983131),new xl.hq(20,41.973031622),new xl.hq(21,42.968523342),new xl.hq(22,43.959690235),new xl.hq(23,44.958124349),new xl.hq(24,45.952629491),new xl.hq(25,46.951763792),new xl.hq(26,47.947947053),new xl.hq(27,48.947870789),new xl.hq(28,49.944792069),new xl.hq(29,50.946616017),new xl.hq(30,51.946898175),new xl.hq(31,52.949731709),new xl.hq(32,53.95087),new xl.hq(33,54.95512),new xl.hq(34,55.95799),new xl.hq(35,56.9643),new xl.hq(36,57.96611),new xl.hq(37,58.97196),new xl.hq(38,59.97564),new xl.hq(39,60.982018)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(17,40.01109),new xl.hq(18,40.99974),new xl.hq(19,41.99123),new xl.hq(20,42.98065),new xl.hq(21,43.9744),new xl.hq(22,44.965782286),new xl.hq(23,45.960199491),new xl.hq(24,46.954906918),new xl.hq(25,47.95225448),new xl.hq(26,48.948516914),new xl.hq(27,49.947162792),new xl.hq(28,50.943963675),new xl.hq(29,51.944779658),new xl.hq(30,52.944342517),new xl.hq(31,53.946444381),new xl.hq(32,54.947238194),new xl.hq(33,55.95036),new xl.hq(34,56.95236),new xl.hq(35,57.95665),new xl.hq(36,58.9593),new xl.hq(37,59.9645),new xl.hq(38,60.96741),new xl.hq(39,61.97314),new xl.hq(40,62.97675)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(18,42.00643),new xl.hq(19,42.997707),new xl.hq(20,43.98547),new xl.hq(21,44.97916),new xl.hq(22,45.968361649),new xl.hq(23,46.962906512),new xl.hq(24,47.954035861),new xl.hq(25,48.951341135),new xl.hq(26,49.946049607),new xl.hq(27,50.944771767),new xl.hq(28,51.940511904),new xl.hq(29,52.940653781),new xl.hq(30,53.938884921),new xl.hq(31,54.940844164),new xl.hq(32,55.940645238),new xl.hq(33,56.9437538),new xl.hq(34,57.94425),new xl.hq(35,58.94863),new xl.hq(36,59.94973),new xl.hq(37,60.95409),new xl.hq(38,61.9558),new xl.hq(39,62.96186),new xl.hq(40,63.9642),new xl.hq(41,64.97037)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(19,44.00687),new xl.hq(20,44.99451),new xl.hq(21,45.98672),new xl.hq(22,46.9761),new xl.hq(23,47.96887),new xl.hq(24,48.959623415),new xl.hq(25,49.95424396),new xl.hq(26,50.948215487),new xl.hq(27,51.945570079),new xl.hq(28,52.941294702),new xl.hq(29,53.940363247),new xl.hq(30,54.938049636),new xl.hq(31,55.938909366),new xl.hq(32,56.938287458),new xl.hq(33,57.939986451),new xl.hq(34,58.940447166),new xl.hq(35,59.943193998),new xl.hq(36,60.94446),new xl.hq(37,61.94797),new xl.hq(38,62.94981),new xl.hq(39,63.95373),new xl.hq(40,64.9561),new xl.hq(41,65.96082),new xl.hq(42,66.96382)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(19,45.01456),new xl.hq(20,46.00081),new xl.hq(21,46.99289),new xl.hq(22,47.98056),new xl.hq(23,48.97361),new xl.hq(24,49.962993316),new xl.hq(25,50.956824936),new xl.hq(26,51.948116526),new xl.hq(27,52.945312282),new xl.hq(28,53.939614836),new xl.hq(29,54.938298029),new xl.hq(30,55.934942133),new xl.hq(31,56.935398707),new xl.hq(32,57.933280458),new xl.hq(33,58.934880493),new xl.hq(34,59.934076943),new xl.hq(35,60.936749461),new xl.hq(36,61.936770495),new xl.hq(37,62.940118442),new xl.hq(38,63.94087),new xl.hq(39,64.94494),new xl.hq(40,65.94598),new xl.hq(41,66.95),new xl.hq(42,67.95251),new xl.hq(43,68.9577)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(21,48.00176),new xl.hq(22,48.98972),new xl.hq(23,49.98154),new xl.hq(24,50.97072),new xl.hq(25,51.96359),new xl.hq(26,52.954224985),new xl.hq(27,53.948464147),new xl.hq(28,54.942003149),new xl.hq(29,55.939843937),new xl.hq(30,56.936296235),new xl.hq(31,57.935757571),new xl.hq(32,58.933200194),new xl.hq(33,59.933822196),new xl.hq(34,60.932479381),new xl.hq(35,61.934054212),new xl.hq(36,62.933615218),new xl.hq(37,63.935813523),new xl.hq(38,64.936484581),new xl.hq(39,65.939825412),new xl.hq(40,66.94061),new xl.hq(41,67.94436),new xl.hq(42,68.9452),new xl.hq(43,69.94981),new xl.hq(44,70.95173),new xl.hq(45,71.95641)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(22,49.99593),new xl.hq(23,50.98772),new xl.hq(24,51.97568),new xl.hq(25,52.96846),new xl.hq(26,53.957910508),new xl.hq(27,54.951336329),new xl.hq(28,55.942136339),new xl.hq(29,56.939800489),new xl.hq(30,57.935347922),new xl.hq(31,58.934351553),new xl.hq(32,59.930790633),new xl.hq(33,60.931060442),new xl.hq(34,61.928348763),new xl.hq(35,62.929672948),new xl.hq(36,63.927969574),new xl.hq(37,64.930088013),new xl.hq(38,65.929115232),new xl.hq(39,66.931569638),new xl.hq(40,67.931844932),new xl.hq(41,68.935181837),new xl.hq(42,69.93614),new xl.hq(43,70.94),new xl.hq(44,71.9413),new xl.hq(45,72.94608),new xl.hq(46,73.94791),new xl.hq(47,74.95297),new xl.hq(48,75.95533),new xl.hq(49,76.96083),new xl.hq(50,77.9638)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(23,51.99718),new xl.hq(24,52.98555),new xl.hq(25,53.97671),new xl.hq(26,54.96605),new xl.hq(27,55.95856),new xl.hq(28,56.949215695),new xl.hq(29,57.944540734),new xl.hq(30,58.939504114),new xl.hq(31,59.937368123),new xl.hq(32,60.933462181),new xl.hq(33,61.932587299),new xl.hq(34,62.929601079),new xl.hq(35,63.929767865),new xl.hq(36,64.927793707),new xl.hq(37,65.928873041),new xl.hq(38,66.927750294),new xl.hq(39,67.929637875),new xl.hq(40,68.929425281),new xl.hq(41,69.932409287),new xl.hq(42,70.932619818),new xl.hq(43,71.93552),new xl.hq(44,72.93649),new xl.hq(45,73.9402),new xl.hq(46,74.9417),new xl.hq(47,75.94599),new xl.hq(48,76.94795),new xl.hq(49,77.95281),new xl.hq(50,78.95528),new xl.hq(51,79.96189)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(24,53.99295),new xl.hq(25,54.98398),new xl.hq(26,55.97238),new xl.hq(27,56.96491),new xl.hq(28,57.954596465),new xl.hq(29,58.949267074),new xl.hq(30,59.941832031),new xl.hq(31,60.939513907),new xl.hq(32,61.934334132),new xl.hq(33,62.933215563),new xl.hq(34,63.929146578),new xl.hq(35,64.929245079),new xl.hq(36,65.926036763),new xl.hq(37,66.927130859),new xl.hq(38,67.924847566),new xl.hq(39,68.926553538),new xl.hq(40,69.92532487),new xl.hq(41,70.927727195),new xl.hq(42,71.926861122),new xl.hq(43,72.929779469),new xl.hq(44,73.929458261),new xl.hq(45,74.932937379),new xl.hq(46,75.933394207),new xl.hq(47,76.937085857),new xl.hq(48,77.938569576),new xl.hq(49,78.942095175),new xl.hq(50,79.944414722),new xl.hq(51,80.95048),new xl.hq(52,81.95484)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(25,55.99491),new xl.hq(26,56.98293),new xl.hq(27,57.97425),new xl.hq(28,58.96337),new xl.hq(29,59.95706),new xl.hq(30,60.94917),new xl.hq(31,61.944179608),new xl.hq(32,62.939141527),new xl.hq(33,63.936838307),new xl.hq(34,64.932739322),new xl.hq(35,65.931592355),new xl.hq(36,66.928204915),new xl.hq(37,67.927983497),new xl.hq(38,68.925580912),new xl.hq(39,69.926027741),new xl.hq(40,70.92470501),new xl.hq(41,71.92636935),new xl.hq(42,72.925169832),new xl.hq(43,73.926940999),new xl.hq(44,74.926500645),new xl.hq(45,75.928928262),new xl.hq(46,76.929281189),new xl.hq(47,77.93165595),new xl.hq(48,78.932916371),new xl.hq(49,79.936588154),new xl.hq(50,80.937752955),new xl.hq(51,81.94316),new xl.hq(52,82.94687),new xl.hq(53,83.95234)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(26,57.99101),new xl.hq(27,58.98175),new xl.hq(28,59.97019),new xl.hq(29,60.96379),new xl.hq(30,61.95465),new xl.hq(31,62.94964),new xl.hq(32,63.941572638),new xl.hq(33,64.939440762),new xl.hq(34,65.933846798),new xl.hq(35,66.932738415),new xl.hq(36,67.928097266),new xl.hq(37,68.927972002),new xl.hq(38,69.924250365),new xl.hq(39,70.924953991),new xl.hq(40,71.922076184),new xl.hq(41,72.923459361),new xl.hq(42,73.921178213),new xl.hq(43,74.922859494),new xl.hq(44,75.921402716),new xl.hq(45,76.923548462),new xl.hq(46,77.922852886),new xl.hq(47,78.92540156),new xl.hq(48,79.925444764),new xl.hq(49,80.928821065),new xl.hq(50,81.929550326),new xl.hq(51,82.93451),new xl.hq(52,83.93731),new xl.hq(53,84.94269),new xl.hq(54,85.94627)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(27,59.99313),new xl.hq(28,60.98062),new xl.hq(29,61.9732),new xl.hq(30,62.96369),new xl.hq(31,63.957572),new xl.hq(32,64.949484),new xl.hq(33,65.944099147),new xl.hq(34,66.939190417),new xl.hq(35,67.936792976),new xl.hq(36,68.932280154),new xl.hq(37,69.930927811),new xl.hq(38,70.927114724),new xl.hq(39,71.926752647),new xl.hq(40,72.923825288),new xl.hq(41,73.923929076),new xl.hq(42,74.921596417),new xl.hq(43,75.922393933),new xl.hq(44,76.920647703),new xl.hq(45,77.921828577),new xl.hq(46,78.920948498),new xl.hq(47,79.922578162),new xl.hq(48,80.922132884),new xl.hq(49,81.924504668),new xl.hq(50,82.924980625),new xl.hq(51,83.92906),new xl.hq(52,84.93181),new xl.hq(53,85.93623),new xl.hq(54,86.93958),new xl.hq(55,87.94456),new xl.hq(56,88.94923)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(31,64.96466),new xl.hq(32,65.95521),new xl.hq(33,66.95009),new xl.hq(34,67.94187),new xl.hq(35,68.939562155),new xl.hq(36,69.933504),new xl.hq(37,70.931868378),new xl.hq(38,71.927112313),new xl.hq(39,72.9267668),new xl.hq(40,73.922476561),new xl.hq(41,74.922523571),new xl.hq(42,75.919214107),new xl.hq(43,76.91991461),new xl.hq(44,77.917309522),new xl.hq(45,78.918499802),new xl.hq(46,79.916521828),new xl.hq(47,80.917992931),new xl.hq(48,81.9167),new xl.hq(49,82.919119072),new xl.hq(50,83.918464523),new xl.hq(51,84.922244678),new xl.hq(52,85.924271165),new xl.hq(53,86.928520749),new xl.hq(54,87.931423982),new xl.hq(55,88.93602),new xl.hq(56,89.93942),new xl.hq(57,90.94537),new xl.hq(58,91.94933)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(32,66.96479),new xl.hq(33,67.958248),new xl.hq(34,68.950178),new xl.hq(35,69.944208),new xl.hq(36,70.939246),new xl.hq(37,71.936496876),new xl.hq(38,72.931794889),new xl.hq(39,73.929891152),new xl.hq(40,74.92577641),new xl.hq(41,75.924541974),new xl.hq(42,76.921380123),new xl.hq(43,77.92114613),new xl.hq(44,78.918337647),new xl.hq(45,79.918529952),new xl.hq(46,80.91629106),new xl.hq(47,81.916804666),new xl.hq(48,82.915180219),new xl.hq(49,83.916503685),new xl.hq(50,84.915608027),new xl.hq(51,85.918797162),new xl.hq(52,86.920710713),new xl.hq(53,87.924065908),new xl.hq(54,88.92638726),new xl.hq(55,89.930634988),new xl.hq(56,90.9339653),new xl.hq(57,91.939255258),new xl.hq(58,92.9431),new xl.hq(59,93.94868)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(33,68.96532),new xl.hq(34,69.95601),new xl.hq(35,70.95051),new xl.hq(36,71.94190754),new xl.hq(37,72.938931115),new xl.hq(38,73.933258225),new xl.hq(39,74.931033794),new xl.hq(40,75.925948304),new xl.hq(41,76.92466788),new xl.hq(42,77.920386271),new xl.hq(43,78.920082992),new xl.hq(44,79.91637804),new xl.hq(45,80.916592419),new xl.hq(46,81.913484601),new xl.hq(47,82.914135952),new xl.hq(48,83.911506627),new xl.hq(49,84.912526954),new xl.hq(50,85.910610313),new xl.hq(51,86.913354251),new xl.hq(52,87.914446951),new xl.hq(53,88.917632505),new xl.hq(54,89.919523803),new xl.hq(55,90.923442418),new xl.hq(56,91.926152752),new xl.hq(57,92.931265246),new xl.hq(58,93.934362),new xl.hq(59,94.93984),new xl.hq(60,95.94307),new xl.hq(61,96.94856)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(34,70.96532),new xl.hq(35,71.95908),new xl.hq(36,72.950366),new xl.hq(37,73.944470376),new xl.hq(38,74.938569199),new xl.hq(39,75.935071448),new xl.hq(40,76.930406599),new xl.hq(41,77.928141485),new xl.hq(42,78.923996719),new xl.hq(43,79.922519322),new xl.hq(44,80.918994165),new xl.hq(45,81.918207691),new xl.hq(46,82.915111951),new xl.hq(47,83.914384676),new xl.hq(48,84.911789341),new xl.hq(49,85.91116708),new xl.hq(50,86.909183465),new xl.hq(51,87.911318556),new xl.hq(52,88.912279939),new xl.hq(53,89.914808941),new xl.hq(54,90.91653416),new xl.hq(55,91.919725442),new xl.hq(56,92.922032765),new xl.hq(57,93.926407326),new xl.hq(58,94.92931926),new xl.hq(59,95.934283962),new xl.hq(60,96.937342863),new xl.hq(61,97.941703557),new xl.hq(62,98.945420616),new xl.hq(63,99.94987),new xl.hq(64,100.953195994),new xl.hq(65,101.95921)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(35,72.96597),new xl.hq(36,73.95631),new xl.hq(37,74.94992),new xl.hq(38,75.94161),new xl.hq(39,76.937761511),new xl.hq(40,77.932179362),new xl.hq(41,78.929707076),new xl.hq(42,79.924524588),new xl.hq(43,80.923213095),new xl.hq(44,81.918401258),new xl.hq(45,82.917555029),new xl.hq(46,83.913424778),new xl.hq(47,84.912932689),new xl.hq(48,85.909262351),new xl.hq(49,86.908879316),new xl.hq(50,87.905614339),new xl.hq(51,88.907452906),new xl.hq(52,89.907737596),new xl.hq(53,90.910209845),new xl.hq(54,91.911029895),new xl.hq(55,92.91402241),new xl.hq(56,93.915359856),new xl.hq(57,94.919358213),new xl.hq(58,95.921680473),new xl.hq(59,96.926148757),new xl.hq(60,97.928471177),new xl.hq(61,98.933315038),new xl.hq(62,99.935351729),new xl.hq(63,100.940517434),new xl.hq(64,101.943018795),new xl.hq(65,102.94895),new xl.hq(66,103.95233)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(38,76.94962),new xl.hq(39,77.9435),new xl.hq(40,78.937350712),new xl.hq(41,79.931982402),new xl.hq(42,80.929128719),new xl.hq(43,81.926792071),new xl.hq(44,82.922352572),new xl.hq(45,83.920387768),new xl.hq(46,84.916427076),new xl.hq(47,85.914887724),new xl.hq(48,86.910877833),new xl.hq(49,87.909503361),new xl.hq(50,88.905847902),new xl.hq(51,89.907151443),new xl.hq(52,90.907303415),new xl.hq(53,91.908946832),new xl.hq(54,92.909581582),new xl.hq(55,93.911594008),new xl.hq(56,94.912823709),new xl.hq(57,95.915897787),new xl.hq(58,96.918131017),new xl.hq(59,97.922219525),new xl.hq(60,98.924634736),new xl.hq(61,99.927756402),new xl.hq(62,100.930313395),new xl.hq(63,101.933555501),new xl.hq(64,102.93694),new xl.hq(65,103.94145),new xl.hq(66,104.94509),new xl.hq(67,105.95022)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(39,78.94916),new xl.hq(40,79.94055),new xl.hq(41,80.936815296),new xl.hq(42,81.931086249),new xl.hq(43,82.92865213),new xl.hq(44,83.92325),new xl.hq(45,84.92146522),new xl.hq(46,85.916472851),new xl.hq(47,86.914816578),new xl.hq(48,87.910226179),new xl.hq(49,88.908888916),new xl.hq(50,89.904703679),new xl.hq(51,90.905644968),new xl.hq(52,91.905040106),new xl.hq(53,92.906475627),new xl.hq(54,93.906315765),new xl.hq(55,94.908042739),new xl.hq(56,95.908275675),new xl.hq(57,96.910950716),new xl.hq(58,97.912746366),new xl.hq(59,98.916511084),new xl.hq(60,99.917761704),new xl.hq(61,100.921139958),new xl.hq(62,101.922981089),new xl.hq(63,102.926597062),new xl.hq(64,103.92878),new xl.hq(65,104.93305),new xl.hq(66,105.93591),new xl.hq(67,106.94086),new xl.hq(68,107.94428)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(40,80.94905),new xl.hq(41,81.94313),new xl.hq(42,82.936703713),new xl.hq(43,83.93357),new xl.hq(44,84.927906486),new xl.hq(45,85.925037588),new xl.hq(46,86.920361435),new xl.hq(47,87.91833144),new xl.hq(48,88.913495503),new xl.hq(49,89.911264109),new xl.hq(50,90.906990538),new xl.hq(51,91.907193214),new xl.hq(52,92.906377543),new xl.hq(53,93.907283457),new xl.hq(54,94.906835178),new xl.hq(55,95.908100076),new xl.hq(56,96.908097144),new xl.hq(57,97.91033069),new xl.hq(58,98.911617864),new xl.hq(59,99.914181434),new xl.hq(60,100.915251567),new xl.hq(61,101.918037417),new xl.hq(62,102.919141297),new xl.hq(63,103.922459464),new xl.hq(64,104.923934023),new xl.hq(65,105.92819),new xl.hq(66,106.93031),new xl.hq(67,107.93501),new xl.hq(68,108.93763),new xl.hq(69,109.94268)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(41,82.94874),new xl.hq(42,83.94009),new xl.hq(43,84.93659),new xl.hq(44,85.930695167),new xl.hq(45,86.92732683),new xl.hq(46,87.921952728),new xl.hq(47,88.919480562),new xl.hq(48,89.913936161),new xl.hq(49,90.911750754),new xl.hq(50,91.90681048),new xl.hq(51,92.906812213),new xl.hq(52,93.905087578),new xl.hq(53,94.905841487),new xl.hq(54,95.904678904),new xl.hq(55,96.906021033),new xl.hq(56,97.905407846),new xl.hq(57,98.907711598),new xl.hq(58,99.907477149),new xl.hq(59,100.910346543),new xl.hq(60,101.910297162),new xl.hq(61,102.913204596),new xl.hq(62,103.913758387),new xl.hq(63,104.916972087),new xl.hq(64,105.918134284),new xl.hq(65,106.921694724),new xl.hq(66,107.923973837),new xl.hq(67,108.92781),new xl.hq(68,109.92973),new xl.hq(69,110.93451),new xl.hq(70,111.93684),new xl.hq(71,112.94203)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(42,84.94894),new xl.hq(43,85.94288),new xl.hq(44,86.93653),new xl.hq(45,87.93283),new xl.hq(46,88.92754288),new xl.hq(47,89.92355583),new xl.hq(48,90.9184282),new xl.hq(49,91.915259655),new xl.hq(50,92.910248473),new xl.hq(51,93.909656309),new xl.hq(52,94.907656454),new xl.hq(53,95.907870803),new xl.hq(54,96.906364843),new xl.hq(55,97.907215692),new xl.hq(56,98.906254554),new xl.hq(57,99.907657594),new xl.hq(58,100.90731438),new xl.hq(59,101.909212938),new xl.hq(60,102.909178805),new xl.hq(61,103.911444898),new xl.hq(62,104.911658043),new xl.hq(63,105.914355408),new xl.hq(64,106.915081691),new xl.hq(65,107.918479973),new xl.hq(66,108.919980998),new xl.hq(67,109.92339),new xl.hq(68,110.92505),new xl.hq(69,111.92924),new xl.hq(70,112.93133),new xl.hq(71,113.93588),new xl.hq(72,114.93828)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(43,86.94918),new xl.hq(44,87.94042),new xl.hq(45,88.93611),new xl.hq(46,89.92978),new xl.hq(47,90.926377434),new xl.hq(48,91.92012),new xl.hq(49,92.917051523),new xl.hq(50,93.911359569),new xl.hq(51,94.910412729),new xl.hq(52,95.907597681),new xl.hq(53,96.907554546),new xl.hq(54,97.905287111),new xl.hq(55,98.905939307),new xl.hq(56,99.904219664),new xl.hq(57,100.905582219),new xl.hq(58,101.904349503),new xl.hq(59,102.906323677),new xl.hq(60,103.905430145),new xl.hq(61,104.907750341),new xl.hq(62,105.907326913),new xl.hq(63,106.909907207),new xl.hq(64,107.910192211),new xl.hq(65,108.913201565),new xl.hq(66,109.913966185),new xl.hq(67,110.91756),new xl.hq(68,111.918821673),new xl.hq(69,112.92254),new xl.hq(70,113.923891981),new xl.hq(71,114.92831),new xl.hq(72,115.93016),new xl.hq(73,116.93479),new xl.hq(74,117.93703)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(44,88.94938),new xl.hq(45,89.94287),new xl.hq(46,90.93655),new xl.hq(47,91.93198),new xl.hq(48,92.92574),new xl.hq(49,93.921698),new xl.hq(50,94.915898541),new xl.hq(51,95.914518212),new xl.hq(52,96.911336643),new xl.hq(53,97.910716431),new xl.hq(54,98.908132101),new xl.hq(55,99.90811663),new xl.hq(56,100.906163526),new xl.hq(57,101.906842845),new xl.hq(58,102.905504182),new xl.hq(59,103.906655315),new xl.hq(60,104.905692444),new xl.hq(61,105.907284615),new xl.hq(62,106.90675054),new xl.hq(63,107.908730768),new xl.hq(64,108.908735621),new xl.hq(65,109.910949525),new xl.hq(66,110.91166),new xl.hq(67,111.913969253),new xl.hq(68,112.91542),new xl.hq(69,113.91734336),new xl.hq(70,114.920124676),new xl.hq(71,115.922746643),new xl.hq(72,116.92535),new xl.hq(73,117.92943),new xl.hq(74,118.93136),new xl.hq(75,119.93578),new xl.hq(76,120.93808)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(45,90.94948),new xl.hq(46,91.94042),new xl.hq(47,92.93591),new xl.hq(48,93.92877),new xl.hq(49,94.92469),new xl.hq(50,95.91822194),new xl.hq(51,96.916478921),new xl.hq(52,97.912720751),new xl.hq(53,98.911767757),new xl.hq(54,99.908504596),new xl.hq(55,100.908289144),new xl.hq(56,101.905607716),new xl.hq(57,102.906087204),new xl.hq(58,103.904034912),new xl.hq(59,104.905084046),new xl.hq(60,105.903483087),new xl.hq(61,106.905128453),new xl.hq(62,107.903894451),new xl.hq(63,108.905953535),new xl.hq(64,109.905152385),new xl.hq(65,110.907643952),new xl.hq(66,111.907313277),new xl.hq(67,112.910151346),new xl.hq(68,113.910365322),new xl.hq(69,114.91368341),new xl.hq(70,115.914158288),new xl.hq(71,116.91784),new xl.hq(72,117.918983915),new xl.hq(73,118.92268),new xl.hq(74,119.92403),new xl.hq(75,120.92818),new xl.hq(76,121.9298),new xl.hq(77,122.93426)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(47,93.94278),new xl.hq(48,94.93548),new xl.hq(49,95.93068),new xl.hq(50,96.924),new xl.hq(51,97.921759995),new xl.hq(52,98.917597103),new xl.hq(53,99.916069387),new xl.hq(54,100.912802135),new xl.hq(55,101.911999996),new xl.hq(56,102.908972453),new xl.hq(57,103.908628228),new xl.hq(58,104.906528234),new xl.hq(59,105.906666431),new xl.hq(60,106.90509302),new xl.hq(61,107.905953705),new xl.hq(62,108.904755514),new xl.hq(63,109.90611046),new xl.hq(64,110.905294679),new xl.hq(65,111.907004132),new xl.hq(66,112.906565708),new xl.hq(67,113.908807907),new xl.hq(68,114.908762282),new xl.hq(69,115.911359558),new xl.hq(70,116.911684187),new xl.hq(71,117.914582383),new xl.hq(72,118.915666045),new xl.hq(73,119.918788609),new xl.hq(74,120.919851074),new xl.hq(75,121.92332),new xl.hq(76,122.9249),new xl.hq(77,123.92853),new xl.hq(78,124.93054),new xl.hq(79,125.9345),new xl.hq(80,126.93688)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(48,95.93977),new xl.hq(49,96.93494),new xl.hq(50,97.927579),new xl.hq(51,98.92501),new xl.hq(52,99.920230232),new xl.hq(53,100.918681442),new xl.hq(54,101.914777255),new xl.hq(55,102.913418952),new xl.hq(56,103.909848091),new xl.hq(57,104.909467818),new xl.hq(58,105.906458007),new xl.hq(59,106.906614232),new xl.hq(60,107.904183403),new xl.hq(61,108.904985569),new xl.hq(62,109.903005578),new xl.hq(63,110.904181628),new xl.hq(64,111.902757226),new xl.hq(65,112.904400947),new xl.hq(66,113.903358121),new xl.hq(67,114.905430553),new xl.hq(68,115.904755434),new xl.hq(69,116.907218242),new xl.hq(70,117.906914144),new xl.hq(71,118.909922582),new xl.hq(72,119.909851352),new xl.hq(73,120.91298039),new xl.hq(74,121.9135),new xl.hq(75,122.917003675),new xl.hq(76,123.917648302),new xl.hq(77,124.92124717),new xl.hq(78,125.922353996),new xl.hq(79,126.926434822),new xl.hq(80,127.927760617),new xl.hq(81,128.93226),new xl.hq(82,129.93398)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(49,97.94224),new xl.hq(50,98.93461),new xl.hq(51,99.931149033),new xl.hq(52,100.92656),new xl.hq(53,101.924707541),new xl.hq(54,102.919913896),new xl.hq(55,103.918338416),new xl.hq(56,104.914673434),new xl.hq(57,105.913461134),new xl.hq(58,106.910292195),new xl.hq(59,107.909719683),new xl.hq(60,108.907154078),new xl.hq(61,109.907168783),new xl.hq(62,110.905110677),new xl.hq(63,111.905533338),new xl.hq(64,112.904061223),new xl.hq(65,113.904916758),new xl.hq(66,114.903878328),new xl.hq(67,115.905259995),new xl.hq(68,116.904515731),new xl.hq(69,117.906354623),new xl.hq(70,118.905846334),new xl.hq(71,119.907961505),new xl.hq(72,120.907848847),new xl.hq(73,121.910277103),new xl.hq(74,122.910438951),new xl.hq(75,123.913175916),new xl.hq(76,124.913601387),new xl.hq(77,125.916464532),new xl.hq(78,126.917344048),new xl.hq(79,127.920170658),new xl.hq(80,128.921657958),new xl.hq(81,129.924854941),new xl.hq(82,130.926767408),new xl.hq(83,131.932919005),new xl.hq(84,132.93834),new xl.hq(85,133.94466)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(50,99.938954),new xl.hq(51,100.93606),new xl.hq(52,101.93049),new xl.hq(53,102.92813),new xl.hq(54,103.923185469),new xl.hq(55,104.921390409),new xl.hq(56,105.916880472),new xl.hq(57,106.915666702),new xl.hq(58,107.911965339),new xl.hq(59,108.911286879),new xl.hq(60,109.907852688),new xl.hq(61,110.907735404),new xl.hq(62,111.90482081),new xl.hq(63,112.905173373),new xl.hq(64,113.902781816),new xl.hq(65,114.903345973),new xl.hq(66,115.901744149),new xl.hq(67,116.902953765),new xl.hq(68,117.901606328),new xl.hq(69,118.90330888),new xl.hq(70,119.902196571),new xl.hq(71,120.904236867),new xl.hq(72,121.903440138),new xl.hq(73,122.905721901),new xl.hq(74,123.90527463),new xl.hq(75,124.907784924),new xl.hq(76,125.907653953),new xl.hq(77,126.91035098),new xl.hq(78,127.910534953),new xl.hq(79,128.913439976),new xl.hq(80,129.913852185),new xl.hq(81,130.916919144),new xl.hq(82,131.917744455),new xl.hq(83,132.923814085),new xl.hq(84,133.928463576),new xl.hq(85,134.93473),new xl.hq(86,135.93934),new xl.hq(87,136.94579)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(52,102.94012),new xl.hq(53,103.936287),new xl.hq(54,104.931528593),new xl.hq(55,105.928183134),new xl.hq(56,106.92415),new xl.hq(57,107.92216),new xl.hq(58,108.918136092),new xl.hq(59,109.917533911),new xl.hq(60,110.912534147),new xl.hq(61,111.91239464),new xl.hq(62,112.909377941),new xl.hq(63,113.909095876),new xl.hq(64,114.906598812),new xl.hq(65,115.906797235),new xl.hq(66,116.90483959),new xl.hq(67,117.905531885),new xl.hq(68,118.90394646),new xl.hq(69,119.905074315),new xl.hq(70,120.903818044),new xl.hq(71,121.905175415),new xl.hq(72,122.904215696),new xl.hq(73,123.905937525),new xl.hq(74,124.905247804),new xl.hq(75,125.907248153),new xl.hq(76,126.906914564),new xl.hq(77,127.90916733),new xl.hq(78,128.909150092),new xl.hq(79,129.911546459),new xl.hq(80,130.911946487),new xl.hq(81,131.914413247),new xl.hq(82,132.915236466),new xl.hq(83,133.920551554),new xl.hq(84,134.925167962),new xl.hq(85,135.93066),new xl.hq(86,136.93531),new xl.hq(87,137.94096),new xl.hq(88,138.94571)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(54,105.937702),new xl.hq(55,106.935036),new xl.hq(56,107.929486838),new xl.hq(57,108.927456483),new xl.hq(58,109.922407164),new xl.hq(59,110.921120589),new xl.hq(60,111.917061617),new xl.hq(61,112.915452551),new xl.hq(62,113.912498025),new xl.hq(63,114.911578627),new xl.hq(64,115.908420253),new xl.hq(65,116.90863418),new xl.hq(66,117.905825187),new xl.hq(67,118.90640811),new xl.hq(68,119.904019891),new xl.hq(69,120.904929815),new xl.hq(70,121.903047064),new xl.hq(71,122.904272951),new xl.hq(72,123.902819466),new xl.hq(73,124.904424718),new xl.hq(74,125.903305543),new xl.hq(75,126.90521729),new xl.hq(76,127.904461383),new xl.hq(77,128.906595593),new xl.hq(78,129.906222753),new xl.hq(79,130.90852188),new xl.hq(80,131.908523782),new xl.hq(81,132.910939068),new xl.hq(82,133.911540546),new xl.hq(83,134.916450782),new xl.hq(84,135.920103155),new xl.hq(85,136.925324769),new xl.hq(86,137.92922),new xl.hq(87,138.93473),new xl.hq(88,139.9387),new xl.hq(89,140.94439),new xl.hq(90,141.9485)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(55,107.943291),new xl.hq(56,108.938191658),new xl.hq(57,109.934634181),new xl.hq(58,110.930276),new xl.hq(59,111.92797),new xl.hq(60,112.923644245),new xl.hq(61,113.92185),new xl.hq(62,114.918272),new xl.hq(63,115.916735014),new xl.hq(64,116.913647692),new xl.hq(65,117.91337523),new xl.hq(66,118.910180837),new xl.hq(67,119.910047843),new xl.hq(68,120.907366063),new xl.hq(69,121.907592451),new xl.hq(70,122.905597944),new xl.hq(71,123.906211423),new xl.hq(72,124.90462415),new xl.hq(73,125.905619387),new xl.hq(74,126.90446842),new xl.hq(75,127.905805254),new xl.hq(76,128.904987487),new xl.hq(77,129.906674018),new xl.hq(78,130.906124168),new xl.hq(79,131.907994525),new xl.hq(80,132.907806465),new xl.hq(81,133.909876552),new xl.hq(82,134.91005031),new xl.hq(83,135.914655105),new xl.hq(84,136.917872653),new xl.hq(85,137.922383666),new xl.hq(86,138.926093402),new xl.hq(87,139.93121),new xl.hq(88,140.93483),new xl.hq(89,141.94018),new xl.hq(90,142.94407),new xl.hq(91,143.94961)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(56,109.944476),new xl.hq(57,110.941632),new xl.hq(58,111.93566535),new xl.hq(59,112.933382836),new xl.hq(60,113.928145),new xl.hq(61,114.926979032),new xl.hq(62,115.921394197),new xl.hq(63,116.920564355),new xl.hq(64,117.91657092),new xl.hq(65,118.915554295),new xl.hq(66,119.91215199),new xl.hq(67,120.911386497),new xl.hq(68,121.908548396),new xl.hq(69,122.908470748),new xl.hq(70,123.905895774),new xl.hq(71,124.906398236),new xl.hq(72,125.904268868),new xl.hq(73,126.905179581),new xl.hq(74,127.903530436),new xl.hq(75,128.904779458),new xl.hq(76,129.903507903),new xl.hq(77,130.90508192),new xl.hq(78,131.904154457),new xl.hq(79,132.90590566),new xl.hq(80,133.905394504),new xl.hq(81,134.907207499),new xl.hq(82,135.907219526),new xl.hq(83,136.911562939),new xl.hq(84,137.913988549),new xl.hq(85,138.918786859),new xl.hq(86,139.921635665),new xl.hq(87,140.926646282),new xl.hq(88,141.929702981),new xl.hq(89,142.93489),new xl.hq(90,143.93823),new xl.hq(91,144.94367),new xl.hq(92,145.9473),new xl.hq(93,146.95301)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(57,111.950331),new xl.hq(58,112.944535512),new xl.hq(59,113.940841319),new xl.hq(60,114.935939),new xl.hq(61,115.932914152),new xl.hq(62,116.928639484),new xl.hq(63,117.926554883),new xl.hq(64,118.922370879),new xl.hq(65,119.920678219),new xl.hq(66,120.917183637),new xl.hq(67,121.916121946),new xl.hq(68,122.912990168),new xl.hq(69,123.912245731),new xl.hq(70,124.909724871),new xl.hq(71,125.909447953),new xl.hq(72,126.9074176),new xl.hq(73,127.907747919),new xl.hq(74,128.906063369),new xl.hq(75,129.906706163),new xl.hq(76,130.905460232),new xl.hq(77,131.906429799),new xl.hq(78,132.90544687),new xl.hq(79,133.906713419),new xl.hq(80,134.905971903),new xl.hq(81,135.907305741),new xl.hq(82,136.907083505),new xl.hq(83,137.911010537),new xl.hq(84,138.913357921),new xl.hq(85,139.917277075),new xl.hq(86,140.920043984),new xl.hq(87,141.924292317),new xl.hq(88,142.927330292),new xl.hq(89,143.932027373),new xl.hq(90,144.935388226),new xl.hq(91,145.940162028),new xl.hq(92,146.943864435),new xl.hq(93,147.948899539),new xl.hq(94,148.95272),new xl.hq(95,149.95797),new xl.hq(96,150.962)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(58,113.950941),new xl.hq(59,114.94771),new xl.hq(60,115.94168),new xl.hq(61,116.937700229),new xl.hq(62,117.93344),new xl.hq(63,118.931051927),new xl.hq(64,119.926045941),new xl.hq(65,120.924485908),new xl.hq(66,121.92026),new xl.hq(67,122.91885),new xl.hq(68,123.915088437),new xl.hq(69,124.914620234),new xl.hq(70,125.911244146),new xl.hq(71,126.911121328),new xl.hq(72,127.90830887),new xl.hq(73,128.908673749),new xl.hq(74,129.906310478),new xl.hq(75,130.906930798),new xl.hq(76,131.905056152),new xl.hq(77,132.906002368),new xl.hq(78,133.904503347),new xl.hq(79,134.905682749),new xl.hq(80,135.904570109),new xl.hq(81,136.905821414),new xl.hq(82,137.905241273),new xl.hq(83,138.908835384),new xl.hq(84,139.910599485),new xl.hq(85,140.914406439),new xl.hq(86,141.916448175),new xl.hq(87,142.920617184),new xl.hq(88,143.922940468),new xl.hq(89,144.926923807),new xl.hq(90,145.930106645),new xl.hq(91,146.933992519),new xl.hq(92,147.937682377),new xl.hq(93,148.94246),new xl.hq(94,149.94562),new xl.hq(95,150.9507),new xl.hq(96,151.95416),new xl.hq(97,152.95961)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(60,116.95001),new xl.hq(61,117.94657),new xl.hq(62,118.94099),new xl.hq(63,119.93807),new xl.hq(64,120.93301),new xl.hq(65,121.93071),new xl.hq(66,122.92624),new xl.hq(67,123.92453),new xl.hq(68,124.92067),new xl.hq(69,125.91937),new xl.hq(70,126.91616),new xl.hq(71,127.91544794),new xl.hq(72,128.912667334),new xl.hq(73,129.91232),new xl.hq(74,130.910108489),new xl.hq(75,131.910110399),new xl.hq(76,132.908396372),new xl.hq(77,133.908489607),new xl.hq(78,134.906971003),new xl.hq(79,135.907651181),new xl.hq(80,136.906465656),new xl.hq(81,137.907106826),new xl.hq(82,138.90634816),new xl.hq(83,139.909472552),new xl.hq(84,140.910957016),new xl.hq(85,141.914074489),new xl.hq(86,142.916058646),new xl.hq(87,143.919591666),new xl.hq(88,144.92163837),new xl.hq(89,145.925700146),new xl.hq(90,146.927819639),new xl.hq(91,147.932191197),new xl.hq(92,148.93437),new xl.hq(93,149.93857),new xl.hq(94,150.94156),new xl.hq(95,151.94611),new xl.hq(96,152.94945),new xl.hq(97,153.9544),new xl.hq(98,154.95813)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(61,118.95276),new xl.hq(62,119.94664),new xl.hq(63,120.94367),new xl.hq(64,121.93801),new xl.hq(65,122.93551),new xl.hq(66,123.93052),new xl.hq(67,124.92854),new xl.hq(68,125.9241),new xl.hq(69,126.92275),new xl.hq(70,127.91887),new xl.hq(71,128.918679183),new xl.hq(72,129.914339361),new xl.hq(73,130.914424137),new xl.hq(74,131.91149),new xl.hq(75,132.91155),new xl.hq(76,133.909026379),new xl.hq(77,134.909145555),new xl.hq(78,135.907143574),new xl.hq(79,136.907777634),new xl.hq(80,137.905985574),new xl.hq(81,138.906646605),new xl.hq(82,139.905434035),new xl.hq(83,140.908271103),new xl.hq(84,141.909239733),new xl.hq(85,142.912381158),new xl.hq(86,143.913642686),new xl.hq(87,144.917227871),new xl.hq(88,145.918689722),new xl.hq(89,146.922510962),new xl.hq(90,147.924394738),new xl.hq(91,148.928289207),new xl.hq(92,149.930226399),new xl.hq(93,150.93404),new xl.hq(94,151.93638),new xl.hq(95,152.94058),new xl.hq(96,153.94332),new xl.hq(97,154.94804),new xl.hq(98,155.95126),new xl.hq(99,156.95634)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(62,120.955364),new xl.hq(63,121.95165),new xl.hq(64,122.94596),new xl.hq(65,123.94296),new xl.hq(66,124.93783),new xl.hq(67,125.93531),new xl.hq(68,126.93083),new xl.hq(69,127.9288),new xl.hq(70,128.92486),new xl.hq(71,129.92338),new xl.hq(72,130.920060245),new xl.hq(73,131.91912),new xl.hq(74,132.9162),new xl.hq(75,133.915672),new xl.hq(76,134.91313914),new xl.hq(77,135.912646935),new xl.hq(78,136.910678351),new xl.hq(79,137.910748891),new xl.hq(80,138.908932181),new xl.hq(81,139.909071204),new xl.hq(82,140.907647726),new xl.hq(83,141.910039865),new xl.hq(84,142.910812233),new xl.hq(85,143.913300595),new xl.hq(86,144.914506897),new xl.hq(87,145.917588016),new xl.hq(88,146.918979001),new xl.hq(89,147.922183237),new xl.hq(90,148.923791056),new xl.hq(91,149.926995031),new xl.hq(92,150.928227869),new xl.hq(93,151.9316),new xl.hq(94,152.93365),new xl.hq(95,153.93739),new xl.hq(96,154.93999),new xl.hq(97,155.94412),new xl.hq(98,156.94717),new xl.hq(99,157.95178),new xl.hq(100,158.95523)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(66,125.94307),new xl.hq(67,126.9405),new xl.hq(68,127.93539),new xl.hq(69,128.932385),new xl.hq(70,129.92878),new xl.hq(71,130.927102697),new xl.hq(72,131.92312),new xl.hq(73,132.92221),new xl.hq(74,133.918645),new xl.hq(75,134.91824),new xl.hq(76,135.915020542),new xl.hq(77,136.91463973),new xl.hq(78,137.91291745),new xl.hq(79,138.91192415),new xl.hq(80,139.909309824),new xl.hq(81,140.9096048),new xl.hq(82,141.907718643),new xl.hq(83,142.909809626),new xl.hq(84,143.910082629),new xl.hq(85,144.912568847),new xl.hq(86,145.913112139),new xl.hq(87,146.916095794),new xl.hq(88,147.916888516),new xl.hq(89,148.92014419),new xl.hq(90,149.920886563),new xl.hq(91,150.923824739),new xl.hq(92,151.924682428),new xl.hq(93,152.927694534),new xl.hq(94,153.929483295),new xl.hq(95,154.932629551),new xl.hq(96,155.9352),new xl.hq(97,156.93927),new xl.hq(98,157.94187),new xl.hq(99,158.94639),new xl.hq(100,159.94939),new xl.hq(101,160.95433)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(67,127.94826),new xl.hq(68,128.94316),new xl.hq(69,129.94045),new xl.hq(70,130.9358),new xl.hq(71,131.93375),new xl.hq(72,132.92972),new xl.hq(73,133.92849),new xl.hq(74,134.924617),new xl.hq(75,135.923447865),new xl.hq(76,136.920713),new xl.hq(77,137.920432261),new xl.hq(78,138.916759814),new xl.hq(79,139.915801649),new xl.hq(80,140.913606636),new xl.hq(81,141.912950738),new xl.hq(82,142.910927571),new xl.hq(83,143.912585768),new xl.hq(84,144.912743879),new xl.hq(85,145.914692165),new xl.hq(86,146.915133898),new xl.hq(87,147.917467786),new xl.hq(88,148.918329195),new xl.hq(89,149.920979477),new xl.hq(90,150.921202693),new xl.hq(91,151.923490557),new xl.hq(92,152.924113189),new xl.hq(93,153.926547019),new xl.hq(94,154.928097047),new xl.hq(95,155.931060357),new xl.hq(96,156.9332),new xl.hq(97,157.93669),new xl.hq(98,158.93913),new xl.hq(99,159.94299),new xl.hq(100,160.94586),new xl.hq(101,161.95029),new xl.hq(102,162.95352)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(68,129.94863),new xl.hq(69,130.94589),new xl.hq(70,131.94082),new xl.hq(71,132.93873),new xl.hq(72,133.93402),new xl.hq(73,134.93235),new xl.hq(74,135.9283),new xl.hq(75,136.927046709),new xl.hq(76,137.92354),new xl.hq(77,138.922302),new xl.hq(78,139.918991),new xl.hq(79,140.918468512),new xl.hq(80,141.915193274),new xl.hq(81,142.914623555),new xl.hq(82,143.91199473),new xl.hq(83,144.913405611),new xl.hq(84,145.91303676),new xl.hq(85,146.914893275),new xl.hq(86,147.914817914),new xl.hq(87,148.917179521),new xl.hq(88,149.917271454),new xl.hq(89,150.919928351),new xl.hq(90,151.919728244),new xl.hq(91,152.922093907),new xl.hq(92,153.922205303),new xl.hq(93,154.92463594),new xl.hq(94,155.925526236),new xl.hq(95,156.928354506),new xl.hq(96,157.929987938),new xl.hq(97,158.9332),new xl.hq(98,159.93514),new xl.hq(99,160.93883),new xl.hq(100,161.94122),new xl.hq(101,162.94536),new xl.hq(102,163.94828),new xl.hq(103,164.95298)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(69,131.95416),new xl.hq(70,132.9489),new xl.hq(71,133.94632),new xl.hq(72,134.94172),new xl.hq(73,135.9395),new xl.hq(74,136.93521),new xl.hq(75,137.93345),new xl.hq(76,138.92882915),new xl.hq(77,139.928083921),new xl.hq(78,140.924885867),new xl.hq(79,141.923400033),new xl.hq(80,142.920286634),new xl.hq(81,143.918774116),new xl.hq(82,144.916261285),new xl.hq(83,145.917199714),new xl.hq(84,146.916741206),new xl.hq(85,147.918153775),new xl.hq(86,148.917925922),new xl.hq(87,149.919698294),new xl.hq(88,150.919846022),new xl.hq(89,151.921740399),new xl.hq(90,152.921226219),new xl.hq(91,153.922975386),new xl.hq(92,154.922889429),new xl.hq(93,155.924750855),new xl.hq(94,156.925419435),new xl.hq(95,157.927841923),new xl.hq(96,158.9290845),new xl.hq(97,159.931460406),new xl.hq(98,160.93368),new xl.hq(99,161.93704),new xl.hq(100,162.93921),new xl.hq(101,163.94299),new xl.hq(102,164.94572),new xl.hq(103,165.94997),new xl.hq(104,166.95305)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(72,135.94707),new xl.hq(73,136.94465),new xl.hq(74,137.93997),new xl.hq(75,138.93808),new xl.hq(76,139.933236934),new xl.hq(77,140.93221),new xl.hq(78,141.927908919),new xl.hq(79,142.926738636),new xl.hq(80,143.923390357),new xl.hq(81,144.921687498),new xl.hq(82,145.918305344),new xl.hq(83,146.919089446),new xl.hq(84,147.918109771),new xl.hq(85,148.919336427),new xl.hq(86,149.918655455),new xl.hq(87,150.920344273),new xl.hq(88,151.919787882),new xl.hq(89,152.921746283),new xl.hq(90,153.920862271),new xl.hq(91,154.922618801),new xl.hq(92,155.922119552),new xl.hq(93,156.923956686),new xl.hq(94,157.924100533),new xl.hq(95,158.926385075),new xl.hq(96,159.927050616),new xl.hq(97,160.929665688),new xl.hq(98,161.930981211),new xl.hq(99,162.93399),new xl.hq(100,163.93586),new xl.hq(101,164.93938),new xl.hq(102,165.9416),new xl.hq(103,166.94557),new xl.hq(104,167.94836),new xl.hq(105,168.95287)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(73,137.95287),new xl.hq(74,138.94803),new xl.hq(75,139.945367985),new xl.hq(76,140.94116),new xl.hq(77,141.939073781),new xl.hq(78,142.93475),new xl.hq(79,143.93253),new xl.hq(80,144.92888),new xl.hq(81,145.927180629),new xl.hq(82,146.924037176),new xl.hq(83,147.924298636),new xl.hq(84,148.92324163),new xl.hq(85,149.923654158),new xl.hq(86,150.923098169),new xl.hq(87,151.924071324),new xl.hq(88,152.923430858),new xl.hq(89,153.924686236),new xl.hq(90,154.923500411),new xl.hq(91,155.924743749),new xl.hq(92,156.924021155),new xl.hq(93,157.92541026),new xl.hq(94,158.925343135),new xl.hq(95,159.927164021),new xl.hq(96,160.927566289),new xl.hq(97,161.929484803),new xl.hq(98,162.930643942),new xl.hq(99,163.933347253),new xl.hq(100,164.93488),new xl.hq(101,165.93805),new xl.hq(102,166.94005),new xl.hq(103,167.94364),new xl.hq(104,168.94622),new xl.hq(105,169.95025),new xl.hq(106,170.9533)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(74,139.95379),new xl.hq(75,140.95119),new xl.hq(76,141.946695946),new xl.hq(77,142.94383),new xl.hq(78,143.93907),new xl.hq(79,144.936717),new xl.hq(80,145.932720118),new xl.hq(81,146.930878496),new xl.hq(82,147.927177882),new xl.hq(83,148.927333981),new xl.hq(84,149.925579728),new xl.hq(85,150.92617963),new xl.hq(86,151.924713874),new xl.hq(87,152.925760865),new xl.hq(88,153.924422046),new xl.hq(89,154.92574895),new xl.hq(90,155.924278273),new xl.hq(91,156.925461256),new xl.hq(92,157.924404637),new xl.hq(93,158.92573566),new xl.hq(94,159.925193718),new xl.hq(95,160.926929595),new xl.hq(96,161.926794731),new xl.hq(97,162.928727532),new xl.hq(98,163.929171165),new xl.hq(99,164.931699828),new xl.hq(100,165.932803241),new xl.hq(101,166.935649025),new xl.hq(102,167.93723),new xl.hq(103,168.940303648),new xl.hq(104,169.94267),new xl.hq(105,170.94648),new xl.hq(106,171.94911),new xl.hq(107,172.95344)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(75,141.95986),new xl.hq(76,142.95469),new xl.hq(77,143.95164),new xl.hq(78,144.94688),new xl.hq(79,145.9441),new xl.hq(80,146.93984),new xl.hq(81,147.937269),new xl.hq(82,148.933789944),new xl.hq(83,149.932760914),new xl.hq(84,150.931680791),new xl.hq(85,151.931740598),new xl.hq(86,152.930194506),new xl.hq(87,153.930596268),new xl.hq(88,154.929079084),new xl.hq(89,155.929001869),new xl.hq(90,156.928188059),new xl.hq(91,157.92894573),new xl.hq(92,158.927708537),new xl.hq(93,159.928725679),new xl.hq(94,160.927851662),new xl.hq(95,161.92909242),new xl.hq(96,162.928730286),new xl.hq(97,163.930230577),new xl.hq(98,164.930319169),new xl.hq(99,165.932281267),new xl.hq(100,166.933126195),new xl.hq(101,167.935496424),new xl.hq(102,168.936868306),new xl.hq(103,169.939614951),new xl.hq(104,170.941461227),new xl.hq(105,171.94482),new xl.hq(106,172.94729),new xl.hq(107,173.95115),new xl.hq(108,174.95405)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(76,143.96059),new xl.hq(77,144.95746),new xl.hq(78,145.95212),new xl.hq(79,146.94931),new xl.hq(80,147.94444),new xl.hq(81,148.942780527),new xl.hq(82,149.937171034),new xl.hq(83,150.93746),new xl.hq(84,151.935078452),new xl.hq(85,152.935093125),new xl.hq(86,153.932777294),new xl.hq(87,154.933204273),new xl.hq(88,155.931015001),new xl.hq(89,156.931945517),new xl.hq(90,157.929912),new xl.hq(91,158.930680718),new xl.hq(92,159.929078924),new xl.hq(93,160.930001348),new xl.hq(94,161.928774923),new xl.hq(95,162.930029273),new xl.hq(96,163.929196996),new xl.hq(97,164.9307228),new xl.hq(98,165.93028997),new xl.hq(99,166.932045448),new xl.hq(100,167.932367781),new xl.hq(101,168.934588082),new xl.hq(102,169.935460334),new xl.hq(103,170.938025885),new xl.hq(104,171.939352149),new xl.hq(105,172.9424),new xl.hq(106,173.94434),new xl.hq(107,174.94793),new xl.hq(108,175.95029),new xl.hq(109,176.95437)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(77,145.966495),new xl.hq(78,146.961081),new xl.hq(79,147.95755),new xl.hq(80,148.95265),new xl.hq(81,149.94967),new xl.hq(82,150.944842),new xl.hq(83,151.9443),new xl.hq(84,152.942027631),new xl.hq(85,153.940832325),new xl.hq(86,154.939191562),new xl.hq(87,155.939006895),new xl.hq(88,156.936756069),new xl.hq(89,157.936996),new xl.hq(90,158.934808966),new xl.hq(91,159.935090772),new xl.hq(92,160.933398042),new xl.hq(93,161.933970147),new xl.hq(94,162.932647648),new xl.hq(95,163.933450972),new xl.hq(96,164.932432463),new xl.hq(97,165.933553133),new xl.hq(98,166.932848844),new xl.hq(99,167.934170375),new xl.hq(100,168.934211117),new xl.hq(101,169.935797877),new xl.hq(102,170.936425817),new xl.hq(103,171.938396118),new xl.hq(104,172.939600336),new xl.hq(105,173.942164618),new xl.hq(106,174.943832897),new xl.hq(107,175.946991412),new xl.hq(108,176.94904),new xl.hq(109,177.95264),new xl.hq(110,178.95534)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(78,147.96676),new xl.hq(79,148.96348),new xl.hq(80,149.95799),new xl.hq(81,150.954657965),new xl.hq(82,151.950167),new xl.hq(83,152.94921),new xl.hq(84,153.945651145),new xl.hq(85,154.945792),new xl.hq(86,155.942847109),new xl.hq(87,156.94265865),new xl.hq(88,157.939857897),new xl.hq(89,158.940153735),new xl.hq(90,159.93756),new xl.hq(91,160.937357719),new xl.hq(92,161.93575),new xl.hq(93,162.936265492),new xl.hq(94,163.93452),new xl.hq(95,164.935397592),new xl.hq(96,165.933879623),new xl.hq(97,166.934946862),new xl.hq(98,167.933894465),new xl.hq(99,168.93518712),new xl.hq(100,169.934758652),new xl.hq(101,170.936322297),new xl.hq(102,171.936377696),new xl.hq(103,172.938206756),new xl.hq(104,173.938858101),new xl.hq(105,174.941272494),new xl.hq(106,175.942568409),new xl.hq(107,176.945257126),new xl.hq(108,177.946643396),new xl.hq(109,178.95017),new xl.hq(110,179.95233),new xl.hq(111,180.95615)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(79,149.972668),new xl.hq(80,150.967147),new xl.hq(81,151.96361),new xl.hq(82,152.95869),new xl.hq(83,153.9571),new xl.hq(84,154.953641324),new xl.hq(85,155.952907),new xl.hq(86,156.950101536),new xl.hq(87,157.948577981),new xl.hq(88,158.946615113),new xl.hq(89,159.945383),new xl.hq(90,160.943047504),new xl.hq(91,161.943222),new xl.hq(92,162.941203796),new xl.hq(93,163.941215),new xl.hq(94,164.939605886),new xl.hq(95,165.939762646),new xl.hq(96,166.938307056),new xl.hq(97,167.938698576),new xl.hq(98,168.937648757),new xl.hq(99,169.93847219),new xl.hq(100,170.937909903),new xl.hq(101,171.939082239),new xl.hq(102,172.938926901),new xl.hq(103,173.940333522),new xl.hq(104,174.940767904),new xl.hq(105,175.942682399),new xl.hq(106,176.943754987),new xl.hq(107,177.945951366),new xl.hq(108,178.947324216),new xl.hq(109,179.949879968),new xl.hq(110,180.95197),new xl.hq(111,181.95521),new xl.hq(112,182.95757),new xl.hq(113,183.96117)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(82,153.96425),new xl.hq(83,154.96276),new xl.hq(84,155.959247),new xl.hq(85,156.958127),new xl.hq(86,157.95405528),new xl.hq(87,158.954003),new xl.hq(88,159.950713588),new xl.hq(89,160.950330852),new xl.hq(90,161.947202977),new xl.hq(91,162.947057),new xl.hq(92,163.944422),new xl.hq(93,164.94454),new xl.hq(94,165.94225),new xl.hq(95,166.9426),new xl.hq(96,167.94063),new xl.hq(97,168.941158567),new xl.hq(98,169.93965),new xl.hq(99,170.94049),new xl.hq(100,171.93945798),new xl.hq(101,172.94065),new xl.hq(102,173.940040159),new xl.hq(103,174.941502991),new xl.hq(104,175.941401828),new xl.hq(105,176.943220013),new xl.hq(106,177.943697732),new xl.hq(107,178.945815073),new xl.hq(108,179.94654876),new xl.hq(109,180.949099124),new xl.hq(110,181.950552893),new xl.hq(111,182.953531012),new xl.hq(112,183.95544788),new xl.hq(113,184.95878),new xl.hq(114,185.96092)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(83,155.971689),new xl.hq(84,156.968145),new xl.hq(85,157.966368),new xl.hq(86,158.96232309),new xl.hq(87,159.961358),new xl.hq(88,160.958372992),new xl.hq(89,161.956556553),new xl.hq(90,162.95431665),new xl.hq(91,163.95357),new xl.hq(92,164.950817),new xl.hq(93,165.95047),new xl.hq(94,166.948639),new xl.hq(95,167.947787),new xl.hq(96,168.94592),new xl.hq(97,169.94609),new xl.hq(98,170.94446),new xl.hq(99,171.944739818),new xl.hq(100,172.94459),new xl.hq(101,173.944167937),new xl.hq(102,174.94365),new xl.hq(103,175.944740551),new xl.hq(104,176.944471766),new xl.hq(105,177.945750349),new xl.hq(106,178.945934113),new xl.hq(107,179.947465655),new xl.hq(108,180.947996346),new xl.hq(109,181.950152414),new xl.hq(110,182.951373188),new xl.hq(111,183.954009331),new xl.hq(112,184.955559086),new xl.hq(113,185.9585501),new xl.hq(114,186.96041),new xl.hq(115,187.96371)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(84,157.973939),new xl.hq(85,158.97228),new xl.hq(86,159.968369),new xl.hq(87,160.967089),new xl.hq(88,161.962750303),new xl.hq(89,162.962532),new xl.hq(90,163.95898381),new xl.hq(91,164.958335962),new xl.hq(92,165.955019896),new xl.hq(93,166.954672),new xl.hq(94,167.951863),new xl.hq(95,168.951759),new xl.hq(96,169.948473988),new xl.hq(97,170.94946),new xl.hq(98,171.948228837),new xl.hq(99,172.948884),new xl.hq(100,173.94616),new xl.hq(101,174.94677),new xl.hq(102,175.94559),new xl.hq(103,176.94662),new xl.hq(104,177.945848364),new xl.hq(105,178.947071733),new xl.hq(106,179.946705734),new xl.hq(107,180.948198054),new xl.hq(108,181.948205519),new xl.hq(109,182.950224458),new xl.hq(110,183.950932553),new xl.hq(111,184.953420586),new xl.hq(112,185.954362204),new xl.hq(113,186.957158365),new xl.hq(114,187.958486954),new xl.hq(115,188.96191222),new xl.hq(116,189.963179541)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(85,159.981485),new xl.hq(86,160.977661),new xl.hq(87,161.975707),new xl.hq(88,162.971375872),new xl.hq(89,163.970319),new xl.hq(90,164.967050268),new xl.hq(91,165.965211372),new xl.hq(92,166.962564),new xl.hq(93,167.961609),new xl.hq(94,168.95883),new xl.hq(95,169.958163),new xl.hq(96,170.955547),new xl.hq(97,171.955285),new xl.hq(98,172.953062),new xl.hq(99,173.952114),new xl.hq(100,174.951393),new xl.hq(101,175.95157),new xl.hq(102,176.95027),new xl.hq(103,177.950851081),new xl.hq(104,178.949981038),new xl.hq(105,179.95078768),new xl.hq(106,180.950064596),new xl.hq(107,181.951211444),new xl.hq(108,182.950821349),new xl.hq(109,183.952524289),new xl.hq(110,184.952955747),new xl.hq(111,185.954986529),new xl.hq(112,186.955750787),new xl.hq(113,187.958112287),new xl.hq(114,188.959228359),new xl.hq(115,189.961816139),new xl.hq(116,190.963123592),new xl.hq(117,191.96596)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(86,161.983819),new xl.hq(87,162.982048),new xl.hq(88,163.977927),new xl.hq(89,164.976475),new xl.hq(90,165.971934911),new xl.hq(91,166.971554),new xl.hq(92,167.967832911),new xl.hq(93,168.967076205),new xl.hq(94,169.963569716),new xl.hq(95,170.96304),new xl.hq(96,171.960078),new xl.hq(97,172.959791),new xl.hq(98,173.956307704),new xl.hq(99,174.95708),new xl.hq(100,175.953757941),new xl.hq(101,176.955045),new xl.hq(102,177.953348225),new xl.hq(103,178.953951),new xl.hq(104,179.952308241),new xl.hq(105,180.953274494),new xl.hq(106,181.952186222),new xl.hq(107,182.95311),new xl.hq(108,183.952490808),new xl.hq(109,184.954043023),new xl.hq(110,185.953838355),new xl.hq(111,186.955747928),new xl.hq(112,187.955835993),new xl.hq(113,188.958144866),new xl.hq(114,189.95844521),new xl.hq(115,190.960927951),new xl.hq(116,191.961479047),new xl.hq(117,192.964148083),new xl.hq(118,193.965179314),new xl.hq(119,194.968123889),new xl.hq(120,195.96962255)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(88,164.98758),new xl.hq(89,165.985506),new xl.hq(90,166.980951577),new xl.hq(91,167.979966),new xl.hq(92,168.976390868),new xl.hq(93,169.974441697),new xl.hq(94,170.971779),new xl.hq(95,171.970643),new xl.hq(96,172.967707),new xl.hq(97,173.966804),new xl.hq(98,174.964279),new xl.hq(99,175.963511),new xl.hq(100,176.96117),new xl.hq(101,177.960084944),new xl.hq(102,178.95915),new xl.hq(103,179.958555615),new xl.hq(104,180.957642156),new xl.hq(105,181.958127689),new xl.hq(106,182.956814),new xl.hq(107,183.957388318),new xl.hq(108,184.95659),new xl.hq(109,185.957951104),new xl.hq(110,186.95736083),new xl.hq(111,187.958851962),new xl.hq(112,188.958716473),new xl.hq(113,189.960592299),new xl.hq(114,190.960591191),new xl.hq(115,191.962602198),new xl.hq(116,192.9629237),new xl.hq(117,193.96507561),new xl.hq(118,194.9659768),new xl.hq(119,195.968379906),new xl.hq(120,196.969636496),new xl.hq(121,197.97228),new xl.hq(122,198.973787159)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(90,167.988035),new xl.hq(91,168.986421),new xl.hq(92,169.981734918),new xl.hq(93,170.981251),new xl.hq(94,171.977376138),new xl.hq(95,172.976499642),new xl.hq(96,173.972811276),new xl.hq(97,174.972276),new xl.hq(98,175.969),new xl.hq(99,176.968453),new xl.hq(100,177.964894223),new xl.hq(101,178.965475),new xl.hq(102,179.962023729),new xl.hq(103,180.963177),new xl.hq(104,181.961267637),new xl.hq(105,182.961729),new xl.hq(106,183.959851685),new xl.hq(107,184.960753782),new xl.hq(108,185.959432346),new xl.hq(109,186.960697),new xl.hq(110,187.959395697),new xl.hq(111,188.9608319),new xl.hq(112,189.959930073),new xl.hq(113,190.961684653),new xl.hq(114,191.961035158),new xl.hq(115,192.962984504),new xl.hq(116,193.962663581),new xl.hq(117,194.964774449),new xl.hq(118,195.964934884),new xl.hq(119,196.967323401),new xl.hq(120,197.967876009),new xl.hq(121,198.970576213),new xl.hq(122,199.971423885),new xl.hq(123,200.974496467),new xl.hq(124,201.97574)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(92,170.991183),new xl.hq(93,171.990109),new xl.hq(94,172.986398138),new xl.hq(95,173.984325861),new xl.hq(96,174.981552),new xl.hq(97,175.980269),new xl.hq(98,176.977215),new xl.hq(99,177.975975),new xl.hq(100,178.973412),new xl.hq(101,179.972396),new xl.hq(102,180.969948),new xl.hq(103,181.968621416),new xl.hq(104,182.96762),new xl.hq(105,183.966776046),new xl.hq(106,184.965806956),new xl.hq(107,185.965997671),new xl.hq(108,186.964562),new xl.hq(109,187.965321662),new xl.hq(110,188.9642243),new xl.hq(111,189.964698757),new xl.hq(112,190.963649239),new xl.hq(113,191.964810107),new xl.hq(114,192.964131745),new xl.hq(115,193.96533889),new xl.hq(116,194.965017928),new xl.hq(117,195.966551315),new xl.hq(118,196.966551609),new xl.hq(119,197.968225244),new xl.hq(120,198.968748016),new xl.hq(121,199.970717886),new xl.hq(122,200.971640839),new xl.hq(123,201.973788431),new xl.hq(124,202.975137256),new xl.hq(125,203.977705),new xl.hq(126,204.97961)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(95,174.991411),new xl.hq(96,175.987413248),new xl.hq(97,176.986336874),new xl.hq(98,177.982476325),new xl.hq(99,178.981783),new xl.hq(100,179.978322),new xl.hq(101,180.977806),new xl.hq(102,181.97393546),new xl.hq(103,182.974561),new xl.hq(104,183.970705219),new xl.hq(105,184.971983),new xl.hq(106,185.969460021),new xl.hq(107,186.969785),new xl.hq(108,187.967511693),new xl.hq(109,188.968733187),new xl.hq(110,189.966958568),new xl.hq(111,190.96706311),new xl.hq(112,191.965921572),new xl.hq(113,192.966644169),new xl.hq(114,193.965381832),new xl.hq(115,194.966638981),new xl.hq(116,195.965814846),new xl.hq(117,196.967195333),new xl.hq(118,197.96675183),new xl.hq(119,198.968262489),new xl.hq(120,199.968308726),new xl.hq(121,200.970285275),new xl.hq(122,201.970625604),new xl.hq(123,202.972857096),new xl.hq(124,203.97347564),new xl.hq(125,204.976056104),new xl.hq(126,205.977498672),new xl.hq(127,206.982577025),new xl.hq(128,207.98594)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(96,176.996881),new xl.hq(97,177.994637),new xl.hq(98,178.991466),new xl.hq(99,179.990194),new xl.hq(100,180.986904),new xl.hq(101,181.98561),new xl.hq(102,182.982697),new xl.hq(103,183.98176),new xl.hq(104,184.9791),new xl.hq(105,185.977549881),new xl.hq(106,186.97617),new xl.hq(107,187.97592),new xl.hq(108,188.974290451),new xl.hq(109,189.974473379),new xl.hq(110,190.972261952),new xl.hq(111,191.972770785),new xl.hq(112,192.970548),new xl.hq(113,193.971053),new xl.hq(114,194.96965),new xl.hq(115,195.970515),new xl.hq(116,196.9695362),new xl.hq(117,197.970466294),new xl.hq(118,198.969813837),new xl.hq(119,199.970945394),new xl.hq(120,200.97080377),new xl.hq(121,201.972090569),new xl.hq(122,202.972329088),new xl.hq(123,203.973848646),new xl.hq(124,204.97441227),new xl.hq(125,205.976095321),new xl.hq(126,206.977407908),new xl.hq(127,207.982004653),new xl.hq(128,208.985349125),new xl.hq(129,209.990065574)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(99,180.996714),new xl.hq(100,181.992676101),new xl.hq(101,182.99193),new xl.hq(102,183.988198),new xl.hq(103,184.98758),new xl.hq(104,185.983485388),new xl.hq(105,186.98403),new xl.hq(106,187.979869108),new xl.hq(107,188.98088),new xl.hq(108,189.978180008),new xl.hq(109,190.9782),new xl.hq(110,191.975719811),new xl.hq(111,192.97608),new xl.hq(112,193.974648056),new xl.hq(113,194.975920279),new xl.hq(114,195.97271),new xl.hq(115,196.97338),new xl.hq(116,197.97198),new xl.hq(117,198.972909384),new xl.hq(118,199.97181556),new xl.hq(119,200.972846589),new xl.hq(120,201.972143786),new xl.hq(121,202.973375491),new xl.hq(122,203.973028761),new xl.hq(123,204.974467112),new xl.hq(124,205.974449002),new xl.hq(125,206.975880605),new xl.hq(126,207.97663585),new xl.hq(127,208.981074801),new xl.hq(128,209.984173129),new xl.hq(129,210.988731474),new xl.hq(130,211.991887495),new xl.hq(131,212.9965),new xl.hq(132,213.999798147)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(102,184.997708),new xl.hq(103,185.99648),new xl.hq(104,186.993458),new xl.hq(105,187.992173),new xl.hq(106,188.989505),new xl.hq(107,189.987520007),new xl.hq(108,190.986053),new xl.hq(109,191.985368),new xl.hq(110,192.983662229),new xl.hq(111,193.983430186),new xl.hq(112,194.98112697),new xl.hq(113,195.981236107),new xl.hq(114,196.978934287),new xl.hq(115,197.979024396),new xl.hq(116,198.977576953),new xl.hq(117,199.978141983),new xl.hq(118,200.976970721),new xl.hq(119,201.977674504),new xl.hq(120,202.976868118),new xl.hq(121,203.977805161),new xl.hq(122,204.977374688),new xl.hq(123,205.978482854),new xl.hq(124,206.978455217),new xl.hq(125,207.979726699),new xl.hq(126,208.980383241),new xl.hq(127,209.984104944),new xl.hq(128,210.987258139),new xl.hq(129,211.991271542),new xl.hq(130,212.994374836),new xl.hq(131,213.998698664),new xl.hq(132,215.001832349),new xl.hq(133,216.006199)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(106,189.994293888),new xl.hq(107,190.994653),new xl.hq(108,191.99033039),new xl.hq(109,192.991102),new xl.hq(110,193.988284107),new xl.hq(111,194.988045),new xl.hq(112,195.985469432),new xl.hq(113,196.985567),new xl.hq(114,197.984024384),new xl.hq(115,198.985044507),new xl.hq(116,199.981735),new xl.hq(117,200.982209),new xl.hq(118,201.980704),new xl.hq(119,202.981412863),new xl.hq(120,203.980307113),new xl.hq(121,204.981165396),new xl.hq(122,205.980465241),new xl.hq(123,206.981578228),new xl.hq(124,207.981231059),new xl.hq(125,208.982415788),new xl.hq(126,209.982857396),new xl.hq(127,210.986636869),new xl.hq(128,211.988851755),new xl.hq(129,212.992842522),new xl.hq(130,213.995185949),new xl.hq(131,214.999414609),new xl.hq(132,216.001905198),new xl.hq(133,217.006253),new xl.hq(134,218.008965773)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(108,193.000188),new xl.hq(109,193.997973),new xl.hq(110,194.996554),new xl.hq(111,195.995702),new xl.hq(112,196.993891293),new xl.hq(113,197.99343368),new xl.hq(114,198.991008569),new xl.hq(115,199.990920883),new xl.hq(116,200.988486908),new xl.hq(117,201.988448629),new xl.hq(118,202.986847216),new xl.hq(119,203.987261559),new xl.hq(120,204.986036352),new xl.hq(121,205.986599242),new xl.hq(122,206.985775861),new xl.hq(123,207.986582508),new xl.hq(124,208.986158678),new xl.hq(125,209.987131308),new xl.hq(126,210.987480806),new xl.hq(127,211.990734657),new xl.hq(128,212.99292115),new xl.hq(129,213.996356412),new xl.hq(130,214.998641245),new xl.hq(131,216.002408839),new xl.hq(132,217.004709619),new xl.hq(133,218.008681458),new xl.hq(134,219.011296478),new xl.hq(135,220.015301),new xl.hq(136,221.01814),new xl.hq(137,222.02233),new xl.hq(138,223.02534)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(110,196.001117268),new xl.hq(111,197.001661),new xl.hq(112,197.998779978),new xl.hq(113,198.998309),new xl.hq(114,199.995634148),new xl.hq(115,200.995535),new xl.hq(116,201.993899382),new xl.hq(117,202.994765192),new xl.hq(118,203.991365),new xl.hq(119,204.991668),new xl.hq(120,205.99016),new xl.hq(121,206.990726826),new xl.hq(122,207.989631237),new xl.hq(123,208.990376634),new xl.hq(124,209.989679862),new xl.hq(125,210.99058541),new xl.hq(126,211.990688899),new xl.hq(127,212.993868354),new xl.hq(128,213.995346275),new xl.hq(129,214.998729195),new xl.hq(130,216.000258153),new xl.hq(131,217.003914555),new xl.hq(132,218.005586315),new xl.hq(133,219.009474831),new xl.hq(134,220.011384149),new xl.hq(135,221.015455),new xl.hq(136,222.017570472),new xl.hq(137,223.02179),new xl.hq(138,224.02409),new xl.hq(139,225.02844),new xl.hq(140,226.03089),new xl.hq(141,227.035407),new xl.hq(142,228.038084)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(113,200.006499),new xl.hq(114,201.00458692),new xl.hq(115,202.00396885),new xl.hq(116,203.001423829),new xl.hq(117,204.001221209),new xl.hq(118,204.998663961),new xl.hq(119,205.998486886),new xl.hq(120,206.996859385),new xl.hq(121,207.997133849),new xl.hq(122,208.995915421),new xl.hq(123,209.996398327),new xl.hq(124,210.995529332),new xl.hq(125,211.996194988),new xl.hq(126,212.996174845),new xl.hq(127,213.99895474),new xl.hq(128,215.000326029),new xl.hq(129,216.003187873),new xl.hq(130,217.004616452),new xl.hq(131,218.007563326),new xl.hq(132,219.009240843),new xl.hq(133,220.012312978),new xl.hq(134,221.014245654),new xl.hq(135,222.017543957),new xl.hq(136,223.019730712),new xl.hq(137,224.023235513),new xl.hq(138,225.025606914),new xl.hq(139,226.029343423),new xl.hq(140,227.031833167),new xl.hq(141,228.034776087),new xl.hq(142,229.038426),new xl.hq(143,230.04251),new xl.hq(144,231.045407),new xl.hq(145,232.049654)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(115,203.00921),new xl.hq(116,204.006434513),new xl.hq(117,205.006187),new xl.hq(118,206.004463814),new xl.hq(119,207.005176607),new xl.hq(120,208.001776),new xl.hq(121,209.001944),new xl.hq(122,210.000446),new xl.hq(123,211.000893996),new xl.hq(124,211.999783492),new xl.hq(125,213.000345847),new xl.hq(126,214.000091141),new xl.hq(127,215.002704195),new xl.hq(128,216.003518402),new xl.hq(129,217.00630601),new xl.hq(130,218.007123948),new xl.hq(131,219.010068787),new xl.hq(132,220.011014669),new xl.hq(133,221.013907762),new xl.hq(134,222.01536182),new xl.hq(135,223.01849714),new xl.hq(136,224.020202004),new xl.hq(137,225.023604463),new xl.hq(138,226.025402555),new xl.hq(139,227.029170677),new xl.hq(140,228.031064101),new xl.hq(141,229.034820309),new xl.hq(142,230.037084774),new xl.hq(143,231.04122),new xl.hq(144,232.043693),new xl.hq(145,233.047995),new xl.hq(146,234.050547)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(118,207.012469754),new xl.hq(119,208.012112949),new xl.hq(120,209.009568736),new xl.hq(121,210.009256802),new xl.hq(122,211.007648196),new xl.hq(123,212.007811441),new xl.hq(124,213.006573689),new xl.hq(125,214.006893072),new xl.hq(126,215.006450832),new xl.hq(127,216.008721268),new xl.hq(128,217.009332676),new xl.hq(129,218.011625045),new xl.hq(130,219.012404918),new xl.hq(131,220.014752105),new xl.hq(132,221.015575746),new xl.hq(133,222.017828852),new xl.hq(134,223.01912603),new xl.hq(135,224.021708435),new xl.hq(136,225.023220576),new xl.hq(137,226.026089848),new xl.hq(138,227.027746979),new xl.hq(139,228.031014825),new xl.hq(140,229.032930871),new xl.hq(141,230.036025144),new xl.hq(142,231.038551503),new xl.hq(143,232.042022474),new xl.hq(144,233.04455),new xl.hq(145,234.04842),new xl.hq(146,235.051102),new xl.hq(147,236.055178)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(120,210.015711883),new xl.hq(121,211.016306912),new xl.hq(122,212.012916),new xl.hq(123,213.012962),new xl.hq(124,214.011451),new xl.hq(125,215.011726597),new xl.hq(126,216.011050963),new xl.hq(127,217.013066169),new xl.hq(128,218.013267744),new xl.hq(129,219.015521253),new xl.hq(130,220.015733126),new xl.hq(131,221.018171499),new xl.hq(132,222.018454131),new xl.hq(133,223.020795153),new xl.hq(134,224.02145925),new xl.hq(135,225.023941441),new xl.hq(136,226.024890681),new xl.hq(137,227.027698859),new xl.hq(138,228.028731348),new xl.hq(139,229.03175534),new xl.hq(140,230.033126574),new xl.hq(141,231.03629706),new xl.hq(142,232.03805036),new xl.hq(143,233.041576923),new xl.hq(144,234.043595497),new xl.hq(145,235.04750442),new xl.hq(146,236.04971),new xl.hq(147,237.053894),new xl.hq(148,238.056243)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(122,213.021183209),new xl.hq(123,214.02073923),new xl.hq(124,215.019097612),new xl.hq(125,216.019109649),new xl.hq(126,217.018288571),new xl.hq(127,218.020007906),new xl.hq(128,219.019880348),new xl.hq(129,220.021876493),new xl.hq(130,221.021863742),new xl.hq(131,222.023726),new xl.hq(132,223.023963748),new xl.hq(133,224.025614854),new xl.hq(134,225.026115172),new xl.hq(135,226.02793275),new xl.hq(136,227.028793151),new xl.hq(137,228.031036942),new xl.hq(138,229.032088601),new xl.hq(139,230.034532562),new xl.hq(140,231.035878898),new xl.hq(141,232.03858172),new xl.hq(142,233.040240235),new xl.hq(143,234.043302325),new xl.hq(144,235.045436759),new xl.hq(145,236.048675176),new xl.hq(146,237.05113943),new xl.hq(147,238.054497046),new xl.hq(148,239.05713),new xl.hq(149,240.06098)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(126,218.023487),new xl.hq(127,219.024915423),new xl.hq(128,220.024712),new xl.hq(129,221.026351),new xl.hq(130,222.02607),new xl.hq(131,223.027722956),new xl.hq(132,224.027590139),new xl.hq(133,225.029384369),new xl.hq(134,226.02933975),new xl.hq(135,227.031140069),new xl.hq(136,228.031366357),new xl.hq(137,229.033496137),new xl.hq(138,230.033927392),new xl.hq(139,231.036289158),new xl.hq(140,232.03714628),new xl.hq(141,233.039628196),new xl.hq(142,234.040945606),new xl.hq(143,235.043923062),new xl.hq(144,236.045561897),new xl.hq(145,237.048723955),new xl.hq(146,238.050782583),new xl.hq(147,239.054287777),new xl.hq(148,240.056585734),new xl.hq(149,241.06033),new xl.hq(150,242.062925)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(132,225.033899689),new xl.hq(133,226.035129),new xl.hq(134,227.034958261),new xl.hq(135,228.03618),new xl.hq(136,229.036246866),new xl.hq(137,230.037812591),new xl.hq(138,231.038233161),new xl.hq(139,232.040099),new xl.hq(140,233.04073235),new xl.hq(141,234.042888556),new xl.hq(142,235.044055876),new xl.hq(143,236.046559724),new xl.hq(144,237.048167253),new xl.hq(145,238.050940464),new xl.hq(146,239.052931399),new xl.hq(147,240.056168828),new xl.hq(148,241.058246266),new xl.hq(149,242.061635),new xl.hq(150,243.064273),new xl.hq(151,244.06785)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(134,228.038727686),new xl.hq(135,229.040138934),new xl.hq(136,230.039645603),new xl.hq(137,231.041258),new xl.hq(138,232.041179445),new xl.hq(139,233.04298757),new xl.hq(140,234.043304681),new xl.hq(141,235.0452815),new xl.hq(142,236.046048088),new xl.hq(143,237.048403774),new xl.hq(144,238.0495534),new xl.hq(145,239.052156519),new xl.hq(146,240.05380746),new xl.hq(147,241.056845291),new xl.hq(148,242.058736847),new xl.hq(149,243.061997013),new xl.hq(150,244.06419765),new xl.hq(151,245.067738657),new xl.hq(152,246.070198429),new xl.hq(153,247.07407)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(136,231.04556),new xl.hq(137,232.04659),new xl.hq(138,233.046472),new xl.hq(139,234.047794),new xl.hq(140,235.048029),new xl.hq(141,236.049569),new xl.hq(142,237.049970748),new xl.hq(143,238.051977839),new xl.hq(144,239.053018481),new xl.hq(145,240.055287826),new xl.hq(146,241.056822944),new xl.hq(147,242.059543039),new xl.hq(148,243.061372686),new xl.hq(149,244.064279429),new xl.hq(150,245.066445398),new xl.hq(151,246.069768438),new xl.hq(152,247.072086),new xl.hq(153,248.075745),new xl.hq(154,249.07848)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(137,233.0508),new xl.hq(138,234.05024),new xl.hq(139,235.051591),new xl.hq(140,236.051405),new xl.hq(141,237.052891),new xl.hq(142,238.053016298),new xl.hq(143,239.054951),new xl.hq(144,240.055519046),new xl.hq(145,241.057646736),new xl.hq(146,242.058829326),new xl.hq(147,243.061382249),new xl.hq(148,244.062746349),new xl.hq(149,245.065485586),new xl.hq(150,246.067217551),new xl.hq(151,247.070346811),new xl.hq(152,248.072342247),new xl.hq(153,249.075947062),new xl.hq(154,250.078350687),new xl.hq(155,251.082277873),new xl.hq(156,252.08487)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(138,235.05658),new xl.hq(139,236.05733),new xl.hq(140,237.057127),new xl.hq(141,238.058266),new xl.hq(142,239.058362),new xl.hq(143,240.059749),new xl.hq(144,241.060223),new xl.hq(145,242.06205),new xl.hq(146,243.06300157),new xl.hq(147,244.065167882),new xl.hq(148,245.066355386),new xl.hq(149,246.068666836),new xl.hq(150,247.070298533),new xl.hq(151,248.07308),new xl.hq(152,249.074979937),new xl.hq(153,250.078310529),new xl.hq(154,251.08075344),new xl.hq(155,252.084303),new xl.hq(156,253.08688),new xl.hq(157,254.0906)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(139,237.06207),new xl.hq(140,238.06141),new xl.hq(141,239.062579),new xl.hq(142,240.062295),new xl.hq(143,241.063716),new xl.hq(144,242.063688713),new xl.hq(145,243.065421),new xl.hq(146,244.06599039),new xl.hq(147,245.068039),new xl.hq(148,246.068798807),new xl.hq(149,247.070992043),new xl.hq(150,248.07217808),new xl.hq(151,249.074846818),new xl.hq(152,250.076399951),new xl.hq(153,251.079580056),new xl.hq(154,252.081619582),new xl.hq(155,253.085126791),new xl.hq(156,254.087316198),new xl.hq(157,255.091039),new xl.hq(158,256.09344)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(141,240.06892),new xl.hq(142,241.068662),new xl.hq(143,242.069699),new xl.hq(144,243.069631),new xl.hq(145,244.070969),new xl.hq(146,245.071317),new xl.hq(147,246.072965),new xl.hq(148,247.07365),new xl.hq(149,248.075458),new xl.hq(150,249.076405),new xl.hq(151,250.078654),new xl.hq(152,251.079983592),new xl.hq(153,252.082972247),new xl.hq(154,253.084817974),new xl.hq(155,254.088016026),new xl.hq(156,255.090266386),new xl.hq(157,256.093592),new xl.hq(158,257.095979)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(142,242.07343),new xl.hq(143,243.07451),new xl.hq(144,244.074077),new xl.hq(145,245.075375),new xl.hq(146,246.075281634),new xl.hq(147,247.076819),new xl.hq(148,248.077184411),new xl.hq(149,249.079024),new xl.hq(150,250.079514759),new xl.hq(151,251.081566467),new xl.hq(152,252.082460071),new xl.hq(153,253.085176259),new xl.hq(154,254.086847795),new xl.hq(155,255.089955466),new xl.hq(156,256.091766522),new xl.hq(157,257.095098635),new xl.hq(158,258.097069),new xl.hq(159,259.100588)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(144,245.081017),new xl.hq(145,246.081933),new xl.hq(146,247.081804),new xl.hq(147,248.082909),new xl.hq(148,249.083002),new xl.hq(149,250.084488),new xl.hq(150,251.084919),new xl.hq(151,252.08663),new xl.hq(152,253.08728),new xl.hq(153,254.089725),new xl.hq(154,255.091075196),new xl.hq(155,256.094052757),new xl.hq(156,257.095534643),new xl.hq(157,258.098425321),new xl.hq(158,259.100503),new xl.hq(159,260.103645)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(147,249.087823),new xl.hq(148,250.087493),new xl.hq(149,251.08896),new xl.hq(150,252.088965909),new xl.hq(151,253.090649),new xl.hq(152,254.090948746),new xl.hq(153,255.093232449),new xl.hq(154,256.094275879),new xl.hq(155,257.096852778),new xl.hq(156,258.0982),new xl.hq(157,259.101024),new xl.hq(158,260.102636),new xl.hq(159,261.105743),new xl.hq(160,262.10752)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(148,251.09436),new xl.hq(149,252.09533),new xl.hq(150,253.095258),new xl.hq(151,254.096587),new xl.hq(152,255.096769),new xl.hq(153,256.098763),new xl.hq(154,257.099606),new xl.hq(155,258.101883),new xl.hq(156,259.10299),new xl.hq(157,260.105572),new xl.hq(158,261.106941),new xl.hq(159,262.109692),new xl.hq(160,263.111394)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(149,253.100679),new xl.hq(150,254.100166),new xl.hq(151,255.101492),new xl.hq(152,256.101179573),new xl.hq(153,257.103072),new xl.hq(154,258.103568),new xl.hq(155,259.105628),new xl.hq(156,260.106434),new xl.hq(157,261.108752),new xl.hq(158,262.109918),new xl.hq(159,263.11254),new xl.hq(160,264.113978)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(150,255.107398),new xl.hq(151,256.10811),new xl.hq(152,257.107858),new xl.hq(153,258.109438),new xl.hq(154,259.109721),new xl.hq(155,260.111427),new xl.hq(156,261.112106),new xl.hq(157,262.114153),new xl.hq(158,263.115078),new xl.hq(159,264.117473),new xl.hq(160,265.118659)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(152,258.113151),new xl.hq(153,259.114652),new xl.hq(154,260.114435447),new xl.hq(155,261.116199),new xl.hq(156,262.116477),new xl.hq(157,263.118313),new xl.hq(158,264.118924),new xl.hq(159,265.121066),new xl.hq(160,266.121928)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(153,260.121803),new xl.hq(154,261.1218),new xl.hq(155,262.123009),new xl.hq(156,263.123146),new xl.hq(157,264.12473),new xl.hq(158,265.125198),new xl.hq(159,266.127009),new xl.hq(160,267.12774)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(155,263.12871),new xl.hq(156,264.128408258),new xl.hq(157,265.130001),new xl.hq(158,266.130042),new xl.hq(159,267.131774),new xl.hq(160,268.132156),new xl.hq(161,269.134114)]),Of(qf(yl.Vlb,1),Xt,3,0,[new xl.hq(156,265.136567),new xl.hq(157,266.13794),new xl.hq(158,267.137526),new xl.hq(159,268.138816),new xl.hq(160,269.139106),new xl.hq(161,270.140723),new xl.hq(162,271.141229)])])},xl.kq=function(n,t){var e,i;for(xl.jq(),i=t-n,e=0;e<xl.iq[n].length;e++)if(xl.iq[n][e].b==i)return xl.iq[n][e].a;return NaN},xl.lq=function(n,t){var e;if(n.b.length!=t.b.length)return n.b.length<t.b.length?-1:1;for(e=0;e<n.b.length;e++)if(n.b[e]!=t.b[e])return n.b[e]<t.b[e]?-1:1;return 0},xl.mq=function(n){var t,e,i,s,r;for(e=0,s=0,r=(i=n.a).length;s<r;++s)i[s]&&++e;for(n.b=vf(yl.tlb,z,6,e,15,1),e=0,t=0;t<n.a.length;t++)n.a[t]&&(n.b[e++]=t)},xl.nq=function(n,t){var e;for(xl.mq(n),e=0;e<n.b.length;e++)if(t[n.b[e]])return!0;return!1},xl.oq=function(n){this.a=vf(yl.Lwb,nn,6,n,16,1)},zf(273,1,{273:1,19:1},xl.oq),o.Eb=function(n){return xl.lq(this,n)},yl.Wlb=lg(273),xl.tq=function(){xl.tq=Xf,xl.sq=Of(qf(yl.rlb,1),X,6,15,[0,1.00794,4.0026,6.941,9.0122,10.811,12.011,14.007,15.999,18.998,20.18,22.99,24.305,26.982,28.086,30.974,32.066,35.453,39.948,39.098,40.078,44.956,47.867,50.942,51.996,54.938,55.845,58.933,58.693,63.546,65.39,69.723,72.61,74.922,78.96,79.904,83.8,85.468,87.62,88.906,91.224,92.906,95.94,98.906,101.07,102.91,106.42,107.87,112.41,114.82,118.71,121.76,127.6,126.9,131.29,132.91,137.33,138.91,140.12,140.91,144.24,146.92,150.36,151.96,157.25,158.93,162.5,164.93,167.26,168.93,173.04,174.97,178.49,180.95,183.84,186.21,190.23,192.22,195.08,196.97,200.59,204.38,207.2,208.98,209.98,209.99,222.02,223.02,226.03,227.03,232.04,231.04,238.03,237.05,239.05,241.06,244.06,249.08,252.08,252.08,257.1,258.1,259.1,262.11,267.12,268.13,271.13,270.13,277.15,276.15,St,St,283.17,285.18,zt,zt,293.2,Gt,Gt,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.0141,3.016,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71.0787,156.18828,114.10364,115.0877,103.1447,128.13052,129.11458,57.05182,137.14158,113.15934,113.15934,128.17428,131.19846,147.17646,97.11658,87.0777,101.10458,186.2134,163.17546,99.13246]),xl.qq=Of(qf(yl.rlb,1),X,6,15,[0,1.007825,4.0026,7.016003,9.012182,11.009305,12,14.003074,15.994915,18.998403,19.992435,22.989767,23.985042,26.98153,27.976927,30.973762,31.97207,34.968852,39.962384,38.963707,39.962591,44.95591,47.947947,50.943962,51.940509,54.938047,55.934939,58.933198,57.935346,62.939598,63.929145,68.92558,73.921177,74.921594,79.91652,78.918336,83.911507,84.911794,87.905619,88.905849,89.904703,92.906377,97.905406,89.92381,101.904348,102.9055,105.903478,106.905092,113.903357,114.90388,119.9022,120.903821,129.906229,126.904473,131.904144,132.905429,137.905232,138.906346,139.905433,140.907647,141.907719,135.92398,151.919729,152.921225,157.924099,158.925342,163.929171,164.930319,165.93029,168.934212,173.938859,174.94077,179.946545,180.947992,183.950928,186.955744,191.961467,192.962917,194.964766,196.966543,201.970617,204.974401,207.976627,208.980374,193.98818,195.99573,199.9957,201.00411,206.0038,210.00923,232.038054,216.01896,238.050784,229.03623,232.041169,237.05005,238.05302,242.06194,240.06228,243.06947,243.07446,248.08275,251.08887,253.09515,257.10295,257.10777,271.13,270.13,277.15,276.15,St,St,283.17,285.18,zt,zt,291.2,Gt,Gt,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.014,3.01605,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]),xl.rq=Of(qf(yl.tlb,1),z,6,15,[6,1,7,8])},xl.uq=function(n){var t,e;for(e=n.a,t=0;t<n.b.length;t++)e+=n.b[t]*xl.qq[n.c[t]];return e},xl.vq=function(n){var t,e;for(t=new Jl.gIb,e=0;e<n.b.length;e++)Jl.fIb(t,(xl.Kj(),xl.Ej)[n.c[e]]),n.b[e]>1&&Jl.eIb(t,n.b[e]);return t.a},xl.wq=function(n){var t,e;for(e=n.d,t=0;t<n.b.length;t++)e+=n.b[t]*xl.sq[n.c[t]];return e},xl.xq=function(n){var t,e,i,s,r,a,o,l,f,g,u;for(xl.iu(n,1),s=vf(yl.tlb,z,6,191,15,1),e=0;e<n.q;e++)switch(n.C[e]){case 171:s[1]+=5,s[6]+=3,s[7]+=1,s[8]+=1;break;case 172:s[1]+=12,s[6]+=6,s[7]+=4,s[8]+=1;break;case 173:s[1]+=6,s[6]+=4,s[7]+=2,s[8]+=2;break;case 174:s[1]+=5,s[6]+=4,s[7]+=1,s[8]+=3;break;case 175:s[1]+=5,s[6]+=3,s[7]+=1,s[8]+=1,s[16]+=1;break;case 176:s[1]+=8,s[6]+=5,s[7]+=2,s[8]+=2;break;case 177:s[1]+=7,s[6]+=5,s[7]+=1,s[8]+=3;break;case 178:s[1]+=3,s[6]+=2,s[7]+=1,s[8]+=1;break;case 179:s[1]+=7,s[6]+=6,s[7]+=3,s[8]+=1;break;case 181:case 180:s[1]+=11,s[6]+=6,s[7]+=1,s[8]+=1;break;case 182:s[1]+=12,s[6]+=6,s[7]+=2,s[8]+=1;break;case 183:s[1]+=9,s[6]+=5,s[7]+=1,s[8]+=1,s[16]+=1;break;case 184:s[1]+=9,s[6]+=9,s[7]+=1,s[8]+=1;break;case 185:s[1]+=7,s[6]+=5,s[7]+=1,s[8]+=1;break;case 186:s[1]+=5,s[6]+=3,s[7]+=1,s[8]+=2;break;case 187:s[1]+=7,s[6]+=4,s[7]+=1,s[8]+=2;break;case 188:s[1]+=10,s[6]+=11,s[7]+=2,s[8]+=1;break;case 189:s[1]+=9,s[6]+=9,s[7]+=1,s[8]+=2;break;case 190:s[1]+=9,s[6]+=5,s[7]+=1,s[8]+=1;break;case 1:switch(n.A[e]){case 0:case 1:++s[1];break;case 2:++s[151];break;case 3:++s[152]}break;default:++s[n.C[e]]}for(i=0;i<n.q;i++)n.C[i]>=171&&n.C[i]<=190?s[1]+=2-xl.fo(n,i):s[1]+=xl.$n(n,i);for(o=0,f=1;f<=190;f++)0!=s[f]&&++o;for(this.b=vf(yl.tlb,z,6,o,15,1),this.c=vf(yl.tlb,z,6,o,15,1),o=0,l=0;l<xl.rq.length;l++)0!=s[xl.rq[l]]&&(this.b[o]=s[xl.rq[l]],this.c[o]=xl.rq[l],++o,s[xl.rq[l]]=0);for(;;){for(u="zzz",g=-1,a=1;a<=190;a++)s[a]>0&&Jl.FHb(u,(xl.Kj(),xl.Ej)[a])>0&&(u=(xl.Kj(),xl.Ej)[a],g=a);if(-1==g)break;this.b[o]=s[g],this.c[o]=g,++o,s[g]=0}for(this.a=0,this.d=0,t=0;t<n.f;t++)1!=n.C[t]&&0!=n.A[t]&&(a=n.C[t],r=n.A[t],this.a+=xl.kq(a,r)-xl.qq[a],this.d+=xl.kq(a,r)-xl.sq[a])},zf(170,1,{170:1}),o.ib=function(n){var t;if(n===this)return!0;if(!_f(n,170))return!1;for(t=0;t<this.b.length;t++)if(this.b[t]!=n.b[t])return!1;return!0},o.a=0,o.d=0,yl.Xlb=lg(170),xl.zq=function(n){switch(n){case 6:return 1;case 53:return 2;case 33:return 3;case 34:return 4;case 35:return 5;case 15:return 6;case 16:return 7;case 17:return 8;case 7:return 9;case 8:return 10;case 9:return 11}return 0},xl.Aq=function(n){var t,e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,I,P;for(xl.iu(n,7),I=0,d=vf(yl.Lwb,nn,6,n.f,16,1),P=vf(yl.tlb,z,6,n.f,15,1),r=0;r<n.g;r++)e=n.D[0][r],i=n.D[1][r],a=n.s[e],o=n.s[i],0!=a&&0!=o&&a<0^o<0&&(d[e]=!0,d[i]=!0),P[e]+=xl.Vk(n,r),P[i]+=xl.Vk(n,r);for(l=0;l<n.f;l++)if(I+=n.s[l],1==n.s[l]){if(7==n.C[l]&&!d[l])if(P[l]<=3)I-=1,n.s[l]=0,n.T=0,n.j[l]!=n.e[l]&&(xl.gk(n,xl.Kn(n,l,n.e[l]-1)),xl.iu(n,7));else if(l<n.f&&xl.Nr(n.p,l))for(H=vf(yl.Lwb,nn,6,n.f,16,1),j=vf(yl.Lwb,nn,6,n.g,16,1),xl.tn(n,l,!0,H,j),g=0;g<n.f;g++)if(H[g]&&7==n.C[g]&&0==n.s[g]&&2==P[g]&&xl.Dq(n,j,l,g)){I-=1;break}}else if(n.s[l]<0&&(6==n.C[l]||7==n.C[l]||8==n.C[l]||16==n.C[l]))if(d[l]){for((C=vf(yl.tlb,z,6,16,15,1))[0]=l,p=1,T=0;T<p;){for(s=0;s<n.r;s++)if(t=-1,n.D[0][s]==C[T]?t=n.D[1][s]:n.D[1][s]==C[T]&&(t=n.D[0][s]),-1!=t&&0!=n.s[t]){for(u=!1,b=0;b<p;b++)if(t==C[b]){u=!0;break}u||(p==C.length&&(f=vf(yl.tlb,z,6,2*C.length,15,1),Jl.wIb(C,0,f,0,C.length),C=f),C[p++]=t)}++T}for(h=0,D=0;D<p;D++)h+=xl.rk(n,C[D]);if(h<0){for(m=-1,A=99,c=0;c<p;c++)xl.rk(n,C[c])<0&&A>xl.zq(xl.Ik(n,C[c]))&&(A=xl.zq(xl.Ik(n,C[c])),m=C[c]);-1!=m&&(I-=n.s[m],n.s[m]=0,n.T=0)}}else I-=n.s[l],n.s[l]=0,n.T=0;return I>0&&(I=xl.Bq(n,I)),I},xl.Bq=function(n,t){var e,i,s,r;if(t>0&&(t=xl.Eq(n,t,9)),t>0&&(t=xl.Eq(n,t,17)),t>0&&(t=xl.Eq(n,t,35)),t>0&&(t=xl.Eq(n,t,53)),t>0)for(e=0;e<n.f;e++)if(n.s[e]>0){for(s=!1,r=0;r<n.j[e];r++)if(i=n.i[e][r],0==n.s[i]&&xl.vl(n,i)&&xl.$n(n,i)>0){if(n.s[i]=-1,n.T=0,0==--t)return 0;s=!0;break}if(s)continue}return t>0&&(t=xl.Cq(n,t,8,16)),t>0&&(t=xl.Cq(n,t,8,15)),t>0&&(t=xl.Cq(n,t,8,6)),t>0&&(t=xl.Cq(n,t,7,16)),t},xl.Cq=function(n,t,e,i){var s,r,a,o,l,f,g,u;for(s=0;s<n.f;s++)if(n.C[s]==e&&0==n.s[s]&&xl.$n(n,s)>0)for(o=!1,f=0;f<n.j[s];f++){if(1==n.n[s][f]&&(r=n.i[s][f],n.C[r]==i)){for(u=!1,l=!1,g=0;g<n.j[r];g++){if(a=n.i[r][g],n.s[a]<0){l=!0;break}a!=s&&8==n.C[a]&&2==n.n[r][g]&&(u=!0)}if(!l&&u){if(n.s[s]=-1,n.T=0,0==--t)return 0;o=!0}}if(o)break}return t},xl.Dq=function(n,t,e,i){var s,r,a,o,l,f,g,u;for(u=vf(yl.tlb,z,6,n.g,15,1),l=vf(yl.Lwb,nn,6,n.g,16,1),a=0;a<n.g;a++)u[a]=n.H[a],t[a]&&(l[a]=!0,n.H[a]=1,n.T=0);for(s=0;s<n.f;s++)if(s!=i&&0==n.o[s]&&l[n.k[i][0]])for(g=0;g<n.j[s];g++)o=n.k[s][g],n.H[o]=1,n.T=0,l[o]=!1;for(f=0;f<n.j[e];f++)o=n.k[e][f],n.H[o]=1,n.T=0,l[o]=!1;if(xl.je(new xl.te(n),l,!1))return n.s[e]=0,n.T=0,n.j[i]!=n.e[i]&&xl.gk(n,xl.Kn(n,i,n.e[i]-1)),xl.iu(n,7),!0;for(r=0;r<n.g;r++)xl.ym(n,r,u[r]);return!1},xl.Eq=function(n,t,e){var i;for(i=0;i<n.f;i++)if(n.C[i]==e&&0==n.s[i]&&0==n.j[i]&&(n.s[i]=-1,n.T=0,0==--t))return 0;return t},xl.Fq=function(n,t){var e,i;for(i=Jf.YKb(n.b,t),e=kl.TTb(i).length;e<10;e++)Jl.jIb(n.a,32);Jl.nIb(n.a,i)},xl.Gq=function(n,t){var e,i,s;if(t<0||t>999)Jl.nIb(n.a,"  ?");else for(e=!1,i=0;i<3;i++)0==(s=t/100|0)?2==i||e?Jl.jIb(n.a,48):Jl.jIb(n.a,32):(Jl.jIb(n.a,48+s&B),e=!0),t=t%100*10},xl.Hq=function(n,t){Lf.bFb(t,n.a.a)},xl.Iq=function(n){xl.Jq.call(this,n)},xl.Jq=function(n){xl.Lq.call(this,n,new Jl.rIb)},xl.Kq=function(t,e,i){var s,r,a,o,l,f,g,u,h,d,c,b,D,j,m,A,C,T,p,I,P,M,N,w,L,U,y,J,R,k,E,x,F,Q,X,S,G,q,Y,v,Z,V,O,K;for(this.b=new Jf._Kb(qt),xl.iu(t,15),E=!0,r=0;r<t.f;r++)if(0!=(3&t.u[r])&&3!=(3&t.u[r])&&(t.u[r]&On)>>18!=1){E=!1;break}if(F=-1,E)for(L=vf(yl.tlb,z,6,32,15,1),Q=0,a=0;a<t.f;a++)if(0!=(3&t.u[a])&&3!=(3&t.u[a])&&(t.u[a]&On)>>18==1){++L[y=(t.u[a]&On)>>18!=1&&(t.u[a]&On)>>18!=2?-1:(t.u[a]&pt)>>20],Q<L[y]&&(Q=L[y],F=y);break}for(this.a=i||new Jl.qIb,S=null!=t.P?t.P:"",Jl.nIb(this.a,S+H),Jl.nIb(this.a,"Actelion Java MolfileCreator 1.0\n\n"),xl.Gq(this,t.q),xl.Gq(this,t.r),Jl.nIb(this.a,"  0  0"),xl.Gq(this,E?0:1),Jl.nIb(this.a,"  0  0  0  0  0999 V2000\n"),J=1==t.q,f=1;f<t.q;f++)if(t.J[f].a!=t.J[0].a||t.J[f].b!=t.J[0].b||t.J[f].c!=t.J[0].c){J=!0;break}if(U=1,J)if(0!=e)U=e;else if(0!=(A=xl.Kk(t,t.q,t.r,(xl.Kj(),xl.Jj))))(A<1||A>3)&&(U=1.5/A);else{for(X=Pt,a=1;a<t.q;a++)for(l=0;l<a;l++)X>(P=(M=t.J[l].a-t.J[a].a)*M+(N=t.J[l].b-t.J[a].b)*N+(w=t.J[l].c-t.J[a].c)*w)&&(X=P);U=3/X}for(g=0;g<t.q;g++)J?(xl.Fq(this,U*t.J[g].a),xl.Fq(this,U*-t.J[g].b),xl.Fq(this,U*-t.J[g].c)):Jl.nIb(this.a,"    0.0000    0.0000    0.0000"),null!=(null==t.v?null:t.v[g])?Jl.nIb(this.a," L  "):Rg(Cg(t.B[g],1),0)?Jl.nIb(this.a," A  "):t.C[g]>=129&&t.C[g]<=144||154==t.C[g]?Jl.nIb(this.a," R# "):(D=(xl.Kj(),xl.Ej)[t.C[g]],Jl.nIb(this.a," "+D),1==kl.TTb(D).length?Jl.nIb(this.a,"  "):2==kl.TTb(D).length&&Jl.nIb(this.a," ")),Jl.nIb(this.a," 0  0  0"),0==Tg(R=Cg(dn,t.B[g]),0)?Jl.nIb(this.a,"  0"):0==Tg(R,384)?Jl.nIb(this.a,"  3"):0==Tg(R,128)?Jl.nIb(this.a,"  2"):0==Tg(R,1792)?Jl.nIb(this.a,"  1"):0==Tg(R,1664)&&Jl.nIb(this.a,"  2"),Jl.nIb(this.a,Rg(Cg(t.B[g],Sn),0)?"  1":"  0"),-1==(K=((t.u[g]&Tt)>>>27)-1)?Jl.nIb(this.a,"  0"):0==K?Jl.nIb(this.a," 15"):xl.Gq(this,K),Jl.nIb(this.a,"  0  0  0"),xl.Gq(this,n.Math.abs(t.w[g])),Jl.nIb(this.a,"  0  0\n");for(C=0;C<t.r;C++){switch(t.H[C]){case 1:default:q=1,Z=0;break;case 2:q=2,Z=0;break;case 4:q=3,Z=0;break;case 129:q=1,Z=6;break;case 257:q=1,Z=1;break;case 386:q=2,Z=3;break;case 64:q=4,Z=0;break;case 32:q=8,Z=0}!E||1!=Z&&6!=Z||(a=t.D[0][C],(t.u[a]&On)>>18==2?Z=0:(t.u[a]&On)>>18==1&&((t.u[a]&On)>>18!=1&&(t.u[a]&On)>>18!=2?-1:(t.u[a]&pt)>>20)!=F&&(Z=4)),0!=(T=31&t.G[C])&&(q=8==T?4:3==T?5:9==T?6:10==T?7:8),O=0==(v=384&t.G[C])?0:256==v?1:2,xl.Gq(this,1+t.D[0][C]),xl.Gq(this,1+t.D[1][C]),xl.Gq(this,q),xl.Gq(this,Z),Jl.nIb(this.a,"  0"),xl.Gq(this,O),Jl.nIb(this.a,"  0\n")}for(G=0,u=0;u<t.q;u++)0!=t.s[u]&&++G;if(0!=G)for(I=0,a=0;a<t.q;a++)0!=t.s[a]&&(0==I&&(Jl.nIb(this.a,"M  CHG"),xl.Gq(this,n.Math.min(8,G))),Jl.nIb(this.a," "),xl.Gq(this,a+1),(p=t.s[a])<0?(Jl.nIb(this.a,"  -"),p=-p):Jl.nIb(this.a,"   "),Jl.jIb(this.a,48+p&B),--G,8!=++I&&0!=G||(I=0,Jl.nIb(this.a,H)));for(G=0,h=0;h<t.q;h++)0==t.A[h]||++G;if(0!=G)for(I=0,a=0;a<t.q;a++)0!=t.A[a]&&(0==I&&(Jl.nIb(this.a,"M  ISO"),xl.Gq(this,n.Math.min(8,G))),Jl.nIb(this.a," "),xl.Gq(this,a+1),Jl.nIb(this.a," "),xl.Gq(this,t.A[a]),--G,8!=++I&&0!=G||(I=0,Jl.nIb(this.a,H)));for(G=0,d=0;d<t.q;d++)0!=(48&t.u[d])&&++G;if(0!=G)for(I=0,a=0;a<t.q;a++)if(0!=(48&t.u[a])){switch(0==I&&(Jl.nIb(this.a,"M  RAD"),xl.Gq(this,n.Math.min(8,G))),Jl.nIb(this.a," "),xl.Gq(this,a+1),48&t.u[a]){case 16:Jl.nIb(this.a,"   1");break;case 32:Jl.nIb(this.a,"   2");break;case 48:Jl.nIb(this.a,"   3")}--G,8!=++I&&0!=G||(I=0,Jl.nIb(this.a,H))}for(G=0,c=0;c<t.q;c++)(t.C[c]>=129&&t.C[c]<=144||154==t.C[c])&&++G;if(0!=G)for(I=0,s=0;s<t.q;s++)((m=t.C[s])>=129&&m<=144||154==m)&&(0==I&&(Jl.nIb(this.a,"M  RGP"),xl.Gq(this,n.Math.min(8,G))),Jl.nIb(this.a," "),xl.Gq(this,s+1),Jl.nIb(this.a," "),xl.Gq(this,154==m?0:m>=142?m-141:m-125),--G,8!=++I&&0!=G||(I=0,Jl.nIb(this.a,H)));if(t.K){for(G=0,a=0;a<t.q;a++)Rg(Cg(t.B[a],120),0)&&++G;if(0!=G)for(I=0,l=0;l<t.q;l++)0!=Tg(Y=Cg(t.B[l],120),0)&&(0==I&&(Jl.nIb(this.a,"M  RBC"),xl.Gq(this,n.Math.min(8,G))),Jl.nIb(this.a," "),xl.Gq(this,l+1),0==Tg(Y,112)?Jl.nIb(this.a,"  -1"):0==Tg(Y,8)?Jl.nIb(this.a,"   1"):0==Tg(Y,104)?Jl.nIb(this.a,"   2"):0==Tg(Y,88)?Jl.nIb(this.a,"   3"):0==Tg(Y,56)&&Jl.nIb(this.a,"   4"),--G,8!=++I&&0!=G||(I=0,Jl.nIb(this.a,H)));for(b=0;b<t.q;b++)if(null!=(j=null==t.v?null:t.v[b])){for(Jl.nIb(this.a,"M  ALS "),xl.Gq(this,b+1),xl.Gq(this,j.length),Jl.nIb(this.a,Rg(Cg(t.B[b],1),0)?" T ":" F "),k=0;k<j.length;k++)switch(x=(xl.Kj(),xl.Ej)[j[k]],kl.TTb(x).length){case 1:Jl.nIb(this.a,x+"   ");break;case 2:Jl.nIb(this.a,x+"  ");break;case 3:Jl.nIb(this.a,x+" ");break;default:Jl.nIb(this.a,"   ?")}Jl.nIb(this.a,H)}for(G=0,o=0;o<t.q;o++)Rg(Cg(t.B[o],6144),0)&&++G;if(0!=G)for(I=0,s=0;s<t.q;s++)0!=Tg(V=Cg(t.B[s],6144),0)&&(0==I&&(Jl.nIb(this.a,"M  SUB"),xl.Gq(this,n.Math.min(8,G))),Jl.nIb(this.a," "),xl.Gq(this,s+1),Rg(Cg(V,fn),0)?Jl.nIb(this.a,"   "+(t.e[s]+1)):Jl.nIb(this.a,"  -2"),--G,8!=++I&&0!=G||(I=0,Jl.nIb(this.a,H)))}Jl.nIb(this.a,Yt)},xl.Lq=function(n,t){xl.Kq.call(this,n,0,t)},zf(135,1,{},xl.Iq,xl.Kq),yl.Zlb=lg(135),xl.Mq=function(n,t,e,i,s,r){var a,o,l,f;switch(f=1,o=!1,s){case 1:f=257;break;case 3:f=386;break;case 4:f=257,o=!0;break;case 6:f=129;break;default:switch(i){case 1:f=1;break;case 2:f=2;break;case 3:f=4;break;case 4:f=64;break;case 9:f=32}}if(a=xl.Oj(n.j,t,e,f),l=0,o&&xl.am(n.j,t,1,-1),i>4)switch(i){case 5:l|=3;break;case 6:l|=9;break;case 7:l|=10;break;case 8:32!=f&&(l|=31)}return 1==r&&(l|=256),2==r&&(l|=128),0!=l&&xl.xm(n.j,a,l,!0),a},xl.Nq=function(t){var e,i,s,r,a,o,l,f,g,u,h;for(o=vf(yl.tlb,z,6,t.j.q,15,1),i=0;i<t.j.q;i++)o[i]=-xl.rk(t.j,i);for(xl.je(new xl.te(t.j),null,!0),s=0;s<t.j.q;s++)o[s]+=xl.rk(t.j,s);for(e=0;e<t.j.q;e++)if(0!=o[e])for(l=-o[e],r=0;r<t.j.r;r++)for(g=0;g<2;g++)l>0&&32==xl.Yk(t.j,r)&&xl.Nk(t.j,1-g,r)==e&&(h=xl.Nk(t.j,g,r),xl.yl(t.j,h)&&(u=xl.Pq(t,h),(a=xl.rk(t.j,h))<u&&(f=n.Math.min(l,u-a),xl.Xl(t.j,h,a+f),l-=f)))},xl.Oq=function(n,t){return n.j=null,xl.er(n,new Lf.YEb(new Lf.aFb(t)))?n.j:null},xl.Pq=function(n,t){var e,i;return null==(i=(e=xl.Ik(n.j,t))<(xl.Kj(),xl.Gj).length?xl.Gj[e]:null)?0:i[i.length-1]},xl.Qq=function(n,t){var e;return(e=n.b?Fl.tNb(n.b,new Jl.PGb(t)):null)?e.a:t-1},xl.Rq=function(n,t){var e;return(e=n.c?Fl.tNb(n.c,new Jl.PGb(t)):null)?e.a:t-1},xl.Sq=function(n,t){var e,i;if(null!=t)for(xl.iu(n.j,1),e=0;e<n.j.f;e++)0!=t[e]&&(i=xl.al(n.j,e,xl.fo(n.j,e)),15==t[e]?i>=0&&xl.Vl(n.j,e,0):t[e]!=xl.cl(n.j,e)&&xl.Vl(n.j,e,t[e]-i))},xl.Tq=function(n,t){var e;if(-1==t)return-1;for(e=t+1;e<kl.TTb(n).length;e++)if(kl.OTb(e,kl.TTb(n).length),32!=kl.TTb(n).charCodeAt(e)&&(kl.OTb(e,kl.TTb(n).length),9!=kl.TTb(n).charCodeAt(e)))return e;return-1},xl.Uq=function(n,t){var e;for(e=t;e<kl.TTb(n).length;e++)if(kl.OTb(e,kl.TTb(n).length),32==kl.TTb(n).charCodeAt(e)||(kl.OTb(e,kl.TTb(n).length),9==kl.TTb(n).charCodeAt(e)))return e;return-1},xl.Vq=function(n){return-1!=kl.TTb(n).indexOf("ATOMS=(")?vt:-1!=kl.TTb(n).indexOf("BONDS=(")?"BONDS":null},xl.Wq=function(t,e){var i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,P,M,N,w,L;for(D=0,H=-1==(l=xl.Uq(e,D+1))?kl.TTb(e).length:l,s=Jl.uGb((kl.NTb(D,H,kl.TTb(e).length),kl.TTb(e).substr(D,H-D)),Zt,I),D=xl.Tq(e,H),H=-1==(f=xl.Uq(e,D+1))?kl.TTb(e).length:f,kl.NTb(D,H,kl.TTb(e).length),m=kl.TTb(e).substr(D,H-D),P=null,r=!1,0!=(j=xl.br(e))&&(P=xl.Xq(e),j<0&&(r=!0),H=n.Math.abs(j)),D=xl.Tq(e,H),H=-1==(g=xl.Uq(e,D+1))?kl.TTb(e).length:g,N=$g((kl.NTb(D,H,kl.TTb(e).length),kl.TTb(e).substr(D,H-D))),D=xl.Tq(e,H),H=-1==(u=xl.Uq(e,D+1))?kl.TTb(e).length:u,w=$g((kl.NTb(D,H,kl.TTb(e).length),kl.TTb(e).substr(D,H-D))),D=xl.Tq(e,H),H=-1==(h=xl.Uq(e,D+1))?kl.TTb(e).length:h,L=$g((kl.NTb(D,H,kl.TTb(e).length),kl.TTb(e).substr(D,H-D))),D=xl.Tq(e,H),H=-1==(d=xl.Uq(e,D+1))?kl.TTb(e).length:d,C=Jl.uGb((kl.NTb(D,H,kl.TTb(e).length),kl.TTb(e).substr(D,H-D)),Zt,I),(i=xl.Lj(t.j,N,-w,-L))+1!=s&&(!t.b&&(t.b=new Fl.wRb),Fl.oRb(t.b,new Jl.PGb(s),new Jl.PGb(i))),null!=P&&(xl.om(t.j,i,6),xl.cm(t.j,i,P,r)),0!=C&&xl.dm(t.j,i,C,!1),Jl.KHb(m,"A")||Jl.KHb(m,"*")?xl.hm(t.j,i,1,!0):Jl.KHb(m,"Q")?((A=vf(yl.tlb,z,6,1,15,1))[0]=6,xl.cm(t.j,i,A,!0)):xl.om(t.j,i,xl.an(m,67));-1!=(D=xl.Tq(e,H));)if(H=-1==(o=xl.Uq(e,D+1))?kl.TTb(e).length:o,kl.NTb(D,H,kl.TTb(e).length),T=kl.TTb(e).substr(D,H-D),b=Jl.OHb(T,bg(61)),kl.NTb(0,b,kl.TTb(T).length),c=kl.TTb(T).substr(0,b),M=Jl.uGb((kl.OTb(b+1,kl.TTb(T).length+1),kl.TTb(T).substr(b+1)),Zt,I),Jl.KHb(c,"CHG"))xl.Xl(t.j,i,M);else if(Jl.KHb(c,"RAD"))switch(M){case 1:xl.im(t.j,i,16);break;case 2:xl.im(t.j,i,32);break;case 3:xl.im(t.j,i,48)}else if(Jl.KHb(c,"CFG"));else if(Jl.KHb(c,"MASS"))xl.fm(t.j,i,M);else if(Jl.KHb(c,"VAL"))xl.Vl(t.j,i,-1==M?0:0==M?-1:M);else if(Jl.KHb(c,"HCOUNT"))switch(M){case 0:break;case-1:xl.hm(t.j,i,1792,!0);break;case 1:xl.hm(t.j,i,128,!0);break;case 2:xl.hm(t.j,i,384,!0);break;default:xl.hm(t.j,i,896,!0)}else if(Jl.KHb(c,"SUBST")){if(-1==M)xl.hm(t.j,i,zn,!0);else if(M>0){for(p=0,a=0;a<t.j.r;a++)(xl.Nk(t.j,0,a)==i||xl.Nk(t.j,1,a)==i)&&++p;M>p&&xl.hm(t.j,i,fn,!0)}}else if(Jl.KHb(c,"RBCNT"))switch(M){case 3:case-1:xl.hm(t.j,i,112,!0);break;case 1:xl.hm(t.j,i,8,!0);break;case 2:xl.hm(t.j,i,104,!0);break;case 4:xl.hm(t.j,i,56,!0)}},xl.Xq=function(n){var t,e,i,s,r,a,o,l;if(o=null,e=kl.TTb(n).indexOf("["),i=kl.TTb(n).indexOf("]",e),e>=0&&i>0){for(t=vf(yl.tlb,z,6,16,15,1),kl.NTb(e+1,i,kl.TTb(n).length),l=kl.TTb(n).substr(e+1,i-(e+1)),s=0,a=!0;a&&s<16;)r=null,-1==(e=kl.TTb(l).indexOf(","))?(r=l,a=!1):(kl.NTb(0,e,kl.TTb(l).length),r=kl.TTb(l).substr(0,e),kl.OTb(e+1,kl.TTb(l).length+1),l=kl.TTb(l).substr(e+1)),t[s++]=xl.an(r,1);o=vf(yl.tlb,z,6,s,15,1),Jl.wIb(t,0,o,0,s)}return o},xl.Yq=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m;for(c=0,b=-1==(l=xl.Uq(t,c+1))?kl.TTb(t).length:l,r=Jl.uGb((kl.NTb(c,b,kl.TTb(t).length),kl.TTb(t).substr(c,b-c)),Zt,I),c=xl.Tq(t,b),b=-1==(f=xl.Uq(t,c+1))?kl.TTb(t).length:f,a=Jl.uGb((kl.NTb(c,b,kl.TTb(t).length),kl.TTb(t).substr(c,b-c)),Zt,I),c=xl.Tq(t,b),b=-1==(g=xl.Uq(t,c+1))?kl.TTb(t).length:g,e=xl.Qq(n,Jl.uGb((kl.NTb(c,b,kl.TTb(t).length),kl.TTb(t).substr(c,b-c)),Zt,I)),c=xl.Tq(t,b),b=-1==(u=xl.Uq(t,c+1))?kl.TTb(t).length:u,i=xl.Qq(n,Jl.uGb((kl.NTb(c,b,kl.TTb(t).length),kl.TTb(t).substr(c,b-c)),Zt,I)),H=0,j=0;-1!=(c=xl.Tq(t,b));)if(b=-1==(o=xl.Uq(t,c+1))?kl.TTb(t).length:o,kl.NTb(c,b,kl.TTb(t).length),D=kl.TTb(t).substr(c,b-c),d=Jl.OHb(D,bg(61)),kl.NTb(0,d,kl.TTb(D).length),h=kl.TTb(D).substr(0,d),m=Jl.uGb((kl.OTb(d+1,kl.TTb(D).length+1),kl.TTb(D).substr(d+1)),Zt,I),Jl.KHb(h,"CFG"))switch(m){case 1:H=1;break;case 2:H=2==a?3:4;break;case 3:H=6}else Jl.KHb(h,"TOPO")&&(j=m);(s=xl.Mq(n,e,i,a,H,j))+1!=r&&(!n.c&&(n.c=new Fl.wRb),Fl.oRb(n.c,new Jl.PGb(r),new Jl.PGb(s)))},xl.Zq=function(n,t){var e,i,s,r,a,o;if(null!=(o=xl.Vq(t)))if(a=xl._q(t,o),Jl.KHb(kl.TTb(t).substr(0,13),"MDLV30/STEABS"))if(Jl.KHb(o,vt))for(r=0;r<a.length;r++)xl.am(n.j,xl.Qq(n,a[r]),0,-1);else for(s=0;s<a.length;s++)xl.sm(n.j,xl.Rq(n,a[s]),0,-1);else if(Jl.KHb(kl.TTb(t).substr(0,13),"MDLV30/STERAC"))if(i=Jl.uGb(Jl.YHb(t,13,xl.Uq(t,13)),Zt,I),Jl.KHb(o,vt))for(r=0;r<a.length;r++)xl.am(n.j,xl.Qq(n,a[r]),1,i-1);else for(s=0;s<a.length;s++)xl.sm(n.j,xl.Rq(n,a[s]),1,i-1);else if(Jl.KHb(kl.TTb(t).substr(0,13),"MDLV30/STEREL"))if(i=Jl.uGb(Jl.YHb(t,13,xl.Uq(t,13)),Zt,I),Jl.KHb(o,vt))for(r=0;r<a.length;r++)xl.am(n.j,xl.Qq(n,a[r]),2,i-1);else for(s=0;s<a.length;s++)xl.sm(n.j,xl.Rq(n,a[s]),2,i-1);else if(Jl.KHb(kl.TTb(t).substr(0,13),"MDLV30/HILITE"))if(Jl.KHb(o,vt))for(s=0;s<a.length;s++)xl.Yl(n.j,xl.Qq(n,a[s]),448);else for(s=0;s<a.length;s++)e=xl.Rq(n,a[s]),xl.Yl(n.j,xl.Nk(n.j,0,e),448),xl.Yl(n.j,xl.Nk(n.j,1,e),448)},xl.$q=function(n,t){var e,i,s;n.j||Jl.KHb(kl.TTb(t).substr(0,6),"COUNTS")&&(e=xl.Tq(t,xl.Uq(t,7)),i=Jl.uGb(Jl.YHb(t,7,xl.Uq(t,7)),Zt,I),s=Jl.uGb(Jl.YHb(t,e,xl.Uq(t,e)),Zt,I),n.j=new xl.Bu(i,s))},xl._q=function(n,t){var e,i,s,r,a,o;for(r=kl.TTb(n).indexOf(t+"=(")+kl.TTb(t).length+2,a=Jl.PHb(n,bg(41),r),s=xl.Uq(n,r),e=Jl.uGb((kl.NTb(r,s,kl.TTb(n).length),kl.TTb(n).substr(r,s-r)),Zt,I),o=vf(yl.tlb,z,6,e,15,1),i=0;i<e;i++)r=xl.Tq(n,s),(-1==(s=xl.Uq(n,r))||s>a)&&(s=a),o[i]=Jl.uGb((kl.NTb(r,s,kl.TTb(n).length),kl.TTb(n).substr(r,s-r)),Zt,I);return o},xl.ar=function(n){var t,e,i,s,r,a,o,l,f;for(l=vf(yl.tlb,z,6,n.j.q,15,1),i=0;i<n.j.r;i++)if(64==xl.Yk(n.j,i))for(a=0;a<2;a++)l[xl.Nk(n.j,a,i)]=1;for(s=0;s<n.j.r;s++)for(f=xl.Vk(n.j,s),r=0;r<2;r++)l[xl.Nk(n.j,r,s)]+=f;for(e=0;e<n.j.r;e++)if(1==xl.Vk(n.j,e))for(r=0;r<2;r++)o=xl.Nk(n.j,1-r,e),xl.yl(n.j,o)&&(t=xl.Nk(n.j,r,e),xl.vl(n.j,t)&&l[t]>xl.cl(n.j,t))&&xl.ym(n.j,e,32)},xl.br=function(n){var t,e;if(kl.TTb(n).indexOf("[")>=0){if(t=kl.TTb(n).indexOf(" NOT["),e=kl.TTb(n).indexOf("]",t),t>=0&&e>0)return-(e+1);if(t=kl.TTb(n).indexOf(" ["),e=kl.TTb(n).indexOf("]",t),t>=0&&e>0)return e+1;if(t=kl.TTb(n).indexOf(" 'NOT["),e=kl.TTb(n).indexOf("]'",t),t>=0&&e>0)return-(e+2);if(t=kl.TTb(n).indexOf(" '["),e=kl.TTb(n).indexOf("]'",t),t>=0&&e>0)return e+2;Jl.vIb()}return 0},xl.cr=function(n,t,e){return n.j=t,xl.er(n,e)},xl.dr=function(n){return 0==kl.TTb(n).length?0:Jl.uGb(n,Zt,I)},xl.er=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,P,M,N,w,L,U,y,J,B,R,k,E,x,F,Q,X,S,G;F=null;try{if(n.f=null,n.j&&(xl._j(n.j),xl.Am(n.j,!1)),null==(P=m=Lf.XEb(t)))return!1;if(null==(m=Lf.XEb(t)))return!1;if(null==(m=Lf.XEb(t)))return!1;if(n.k=-1!=kl.TTb(m).indexOf("From CSD data. Using bond type 'Any'"),n.e=-1!=kl.TTb(m).indexOf("From CSD data."),null==(m=Lf.XEb(t)))return!1;n.g=!1,n.d=n.a;try{M=Jl.uGb(Jl.ZHb((kl.NTb(0,3,kl.TTb(m).length),kl.TTb(m).substr(0,3))),Zt,I),N=Jl.uGb(Jl.ZHb((kl.NTb(3,6,kl.TTb(m).length),kl.TTb(m).substr(3,3))),Zt,I),w=xl.dr(Jl.ZHb((kl.NTb(6,9,kl.TTb(m).length),kl.TTb(m).substr(6,3)))),n.d=n.d|1==xl.dr(Jl.ZHb((kl.NTb(12,15,kl.TTb(m).length),kl.TTb(m).substr(12,3)))),n.g=kl.TTb(m).length>=39&&Jl.KHb(kl.TTb(m).substr(34,kl.TTb("V3000").length),"V3000")}catch(n){if(_f(n=ag(n),18))return!1;throw og(n)}if(n.g)return U=xl.fr(n,t),xl.Gm(n.j,P),U;if(!n.j&&(n.j=new xl.Bu(M,N)),xl.Gm(n.j,P),n.d||(n.j.L=!0),0==M){for(;null!=m&&!(Jl.KHb(m,Vt)||Jl.KHb(m,Ot)||Jl.KHb((kl.OTb(1,kl.TTb(m).length+1),kl.TTb(m).substr(1)),"$"));)m=Lf.XEb(t);return!0}for(c=0;c<M;c++){if(null==(m=Lf.XEb(t)))return!1;switch(X=$g(Jl.ZHb((kl.NTb(0,10,kl.TTb(m).length),kl.TTb(m).substr(0,10)))),S=$g(Jl.ZHb((kl.NTb(10,20,kl.TTb(m).length),kl.TTb(m).substr(10,10)))),G=$g(Jl.ZHb((kl.NTb(20,30,kl.TTb(m).length),kl.TTb(m).substr(20,10)))),i=xl.Lj(n.j,X,-S,-G),j=Jl.ZHb((kl.NTb(31,34,kl.TTb(m).length),kl.TTb(m).substr(31,3))),Jl.KHb(j,"A")||Jl.KHb(j,"*")?xl.hm(n.j,i,1,!0):Jl.KHb(j,"Q")?((A=vf(yl.tlb,z,6,1,15,1))[0]=6,xl.cm(n.j,i,A,!0)):(a=xl.an(j,67),xl.om(n.j,i,a)),0!=(p=xl.dr(Jl.ZHb((kl.NTb(34,36,kl.TTb(m).length),kl.TTb(m).substr(34,2)))))&&xl.fm(n.j,i,(xl.Kj(),xl.Ij)[xl.Ik(n.j,i)]+p),0!=(u=xl.dr(Jl.ZHb((kl.NTb(36,39,kl.TTb(m).length),kl.TTb(m).substr(36,3)))))&&(4==u?xl.im(n.j,i,32):xl.Xl(n.j,i,4-u)),C=kl.TTb(m).length<63?0:xl.dr(Jl.ZHb((kl.NTb(60,63,kl.TTb(m).length),kl.TTb(m).substr(60,3)))),xl.dm(n.j,i,C,!1),kl.TTb(m).length<45?0:xl.dr(Jl.ZHb((kl.NTb(42,45,kl.TTb(m).length),kl.TTb(m).substr(42,3))))){case 0:break;case 1:xl.hm(n.j,i,768,!0);break;case 2:xl.hm(n.j,i,128,!0);break;case 3:xl.hm(n.j,i,384,!0);break;default:xl.hm(n.j,i,896,!0)}kl.TTb(m).length>=48&&(kl.OTb(47,kl.TTb(m).length),49==kl.TTb(m).charCodeAt(47))&&xl.hm(n.j,i,Sn,!0),0!=(x=kl.TTb(m).length<51?0:xl.dr(Jl.ZHb((kl.NTb(48,51,kl.TTb(m).length),kl.TTb(m).substr(48,3)))))&&(null==F&&(F=vf(yl.tlb,z,6,M,15,1)),F[i]=x)}for(b=0;b<N;b++){if(null==(m=Lf.XEb(t)))return!1;s=Jl.uGb(Jl.ZHb((kl.NTb(0,3,kl.TTb(m).length),kl.TTb(m).substr(0,3))),Zt,I)-1,r=Jl.uGb(Jl.ZHb((kl.NTb(3,6,kl.TTb(m).length),kl.TTb(m).substr(3,3))),Zt,I)-1,f=Jl.uGb(Jl.ZHb((kl.NTb(6,9,kl.TTb(m).length),kl.TTb(m).substr(6,3))),Zt,I),J=kl.TTb(m).length<12?0:xl.dr(Jl.ZHb((kl.NTb(9,12,kl.TTb(m).length),kl.TTb(m).substr(9,3)))),E=kl.TTb(m).length<18?0:xl.dr(Jl.ZHb((kl.NTb(15,18,kl.TTb(m).length),kl.TTb(m).substr(15,3)))),8==f&&(n.k||xl.yl(n.j,s)||xl.yl(n.j,r))&&(f=9),xl.Mq(n,s,r,f,J,E)}for(d=0;d<w;d++)if(null==(m=Lf.XEb(t)))return!1;if(null==(m=Lf.XEb(t)))return 0!=(1&n.i)&&(n.f=xl.Yn(n.j)),xl.Sq(n,F),n.d||xl.iu(n.j,15),!0;for(;null!=m&&!Jl.KHb(m,Vt)&&!Jl.KHb(m,Ot);){if(Jl.KHb(kl.TTb(m).substr(0,6),"M  CHG")&&(D=Jl.uGb(Jl.ZHb((kl.NTb(6,9,kl.TTb(m).length),kl.TTb(m).substr(6,3))),Zt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)i=Jl.uGb(Jl.ZHb((kl.NTb(e,e+3,kl.TTb(m).length),kl.TTb(m).substr(e,e+3-e))),Zt,I)-1,g=Jl.uGb(Jl.ZHb((kl.NTb(Q,Q+3,kl.TTb(m).length),kl.TTb(m).substr(Q,Q+3-Q))),Zt,I),xl.Xl(n.j,i,g);if(Jl.KHb(kl.TTb(m).substr(0,6),"M  ISO")&&(D=Jl.uGb(Jl.ZHb((kl.NTb(6,9,kl.TTb(m).length),kl.TTb(m).substr(6,3))),Zt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)i=Jl.uGb(Jl.ZHb((kl.NTb(e,e+3,kl.TTb(m).length),kl.TTb(m).substr(e,e+3-e))),Zt,I)-1,T=Jl.uGb(Jl.ZHb((kl.NTb(Q,Q+3,kl.TTb(m).length),kl.TTb(m).substr(Q,Q+3-Q))),Zt,I),xl.fm(n.j,i,T);if(Jl.KHb(kl.TTb(m).substr(0,6),"M  RAD")&&(D=Jl.uGb(Jl.ZHb((kl.NTb(6,9,kl.TTb(m).length),kl.TTb(m).substr(6,3))),Zt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)switch(i=Jl.uGb(Jl.ZHb((kl.NTb(e,e+3,kl.TTb(m).length),kl.TTb(m).substr(e,e+3-e))),Zt,I)-1,Jl.uGb(Jl.ZHb((kl.NTb(Q,Q+3,kl.TTb(m).length),kl.TTb(m).substr(Q,Q+3-Q))),Zt,I)){case 1:xl.im(n.j,i,16);break;case 2:xl.im(n.j,i,32);break;case 3:xl.im(n.j,i,48)}if((Jl.KHb(kl.TTb(m).substr(0,6),"M  RBC")||Jl.KHb(kl.TTb(m).substr(0,6),"M  RBD"))&&(D=Jl.uGb(Jl.ZHb((kl.NTb(6,9,kl.TTb(m).length),kl.TTb(m).substr(6,3))),Zt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)switch(i=Jl.uGb(Jl.ZHb((kl.NTb(e,e+3,kl.TTb(m).length),kl.TTb(m).substr(e,e+3-e))),Zt,I)-1,Jl.uGb(Jl.ZHb((kl.NTb(Q,Q+3,kl.TTb(m).length),kl.TTb(m).substr(Q,Q+3-Q))),Zt,I)){case 3:case-1:xl.hm(n.j,i,112,!0);break;case 1:xl.hm(n.j,i,8,!0);break;case 2:xl.hm(n.j,i,104,!0);break;case 4:xl.hm(n.j,i,56,!0)}if(Jl.KHb(kl.TTb(m).substr(0,6),"M  ALS")&&(i=Jl.uGb(Jl.ZHb((kl.NTb(7,10,kl.TTb(m).length),kl.TTb(m).substr(7,3))),Zt,I)-1)>=0){for(L=Jl.uGb(Jl.ZHb((kl.NTb(10,13,kl.TTb(m).length),kl.TTb(m).substr(10,3))),Zt,I),kl.OTb(14,kl.TTb(m).length),o=84==kl.TTb(m).charCodeAt(14),x=vf(yl.tlb,z,6,L,15,1),e=16,H=0;H<L;++H,e+=4)k=Jl.ZHb((kl.NTb(e,e+4,kl.TTb(m).length),kl.TTb(m).substr(e,e+4-e))),x[H]=xl.an(k,1);xl.om(n.j,i,6),xl.cm(n.j,i,x,o)}if(Jl.KHb(kl.TTb(m).substr(0,6),"M  SUB")&&(D=Jl.uGb(Jl.ZHb((kl.NTb(6,9,kl.TTb(m).length),kl.TTb(m).substr(6,3))),Zt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)if(i=Jl.uGb(Jl.ZHb((kl.NTb(e,e+3,kl.TTb(m).length),kl.TTb(m).substr(e,e+3-e))),Zt,I)-1,-2==(B=Jl.uGb(Jl.ZHb((kl.NTb(Q,Q+3,kl.TTb(m).length),kl.TTb(m).substr(Q,Q+3-Q))),Zt,I)))xl.hm(n.j,i,zn,!0);else if(B>0){for(R=0,l=0;l<n.j.r;l++)(xl.Nk(n.j,0,l)==i||xl.Nk(n.j,1,l)==i)&&++R;B>R&&xl.hm(n.j,i,fn,!0)}if(Jl.KHb(kl.TTb(m).substr(0,6),"M  RGP")&&(D=Jl.uGb(Jl.ZHb((kl.NTb(6,9,kl.TTb(m).length),kl.TTb(m).substr(6,3))),Zt,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)i=Jl.uGb(Jl.ZHb((kl.NTb(e,e+3,kl.TTb(m).length),kl.TTb(m).substr(e,e+3-e))),Zt,I)-1,(y=Jl.uGb(Jl.ZHb((kl.NTb(Q,Q+3,kl.TTb(m).length),kl.TTb(m).substr(Q,Q+3-Q))),Zt,I))>=1&&y<=20&&xl.om(n.j,i,xl.an("R"+y,2));m=Lf.XEb(t)}}catch(n){if(_f(n=ag(n),18))return h=n,Jl.Ez(h,(Jl.vIb(),Jl.uIb),""),!1;throw og(n)}return n.e&&(xl.ar(n),xl.Nq(n)),0!=(1&n.i)&&(n.f=xl.Yn(n.j)),xl.Sq(n,F),xl.iu(n.j,15),!0},xl.fr=function(n,t){var e,i,s,r,a;for(n.b&&Fl.hRb(n.b),n.c&&Fl.hRb(n.c),s=0,i=Lf.XEb(t);null!=i&&Jl.KHb(kl.TTb(i).substr(0,7),Kt);){for(i=Jl.ZHb((kl.OTb(7,kl.TTb(i).length+1),kl.TTb(i).substr(7)));a=kl.TTb("-").length,Jl.KHb(kl.TTb(i).substr(kl.TTb(i).length-a,a),"-");){if(e=Lf.XEb(t),!Jl.KHb(kl.TTb(e).substr(0,7),Kt))return!1;i=Jl.ZHb(Jl.HHb(Jl.YHb(i,0,kl.TTb(i).length-1),(kl.OTb(7,kl.TTb(e).length+1),kl.TTb(e).substr(7))))}if(Jl.KHb(kl.TTb(i).substr(0,5),"BEGIN"))if(r=Jl.ZHb((kl.OTb(6,kl.TTb(i).length+1),kl.TTb(i).substr(6))),Jl.KHb(kl.TTb(r).substr(0,4),"CTAB"))s=1;else if(Jl.KHb(kl.TTb(r).substr(0,4),"ATOM"))s=2;else if(Jl.KHb(kl.TTb(r).substr(0,4),"BOND"))s=3;else{if(!Jl.KHb(kl.TTb(r).substr(0,10),"COLLECTION"))return!1;s=4}else if(Jl.KHb(kl.TTb(i).substr(0,3),"END"))s=0;else if(1==s)xl.$q(n,i);else if(2==s)xl.Wq(n,i);else if(3==s)xl.Yq(n,i);else{if(4!=s)return!1;xl.Zq(n,i)}i=Lf.XEb(t)}for(;null!=i&&!Jl.KHb(kl.TTb(i).substr(0,6),Vt)&&!Jl.KHb(i,Ot);)i=Lf.XEb(t);return!0},xl.gr=function(){this.i=0},xl.hr=function(){this.i=1},zf(111,1,{},xl.gr,xl.hr),o.a=!1,o.d=!1,o.e=!1,o.g=!1,o.i=0,o.k=!1,yl.$lb=lg(111),xl.ir=function(n){},xl.jr=function(t,e,i){var s,r,a,o,l,f,g,u,h,d,c,b,D,j,m,A,C,T,p,I,P,M,N,w,L,U,y,J,B;for(Jl.nIb(t.a,"M  V30 BEGIN CTAB\n"),Jl.nIb(t.a,Wt+e.q+" "+e.r+" 0 0 0"+H),Jl.nIb(t.a,"M  V30 BEGIN ATOM\n"),f=0;f<e.q;f++){if(Jl.nIb(t.a,Kt+(f+1)),null!=(null==e.v?null:e.v[f])){for(u=null==e.v?null:e.v[f],T=Rg(Cg(e.B[f],1),0),Jl.nIb(t.a,T?" NOT[":" ["),A=0;A<u.length;A++)switch(A>0&&Jl.nIb(t.a,","),C=(xl.Kj(),xl.Ej)[u[A]],kl.TTb(C).length){case 2:case 3:case 1:Jl.nIb(t.a,C);break;default:Jl.nIb(t.a,"?")}Jl.nIb(t.a,"]")}else Rg(Cg(e.B[f],1),0)?Jl.nIb(t.a," A"):e.C[f]>=129&&e.C[f]<=144||154==e.C[f]?Jl.nIb(t.a," R#"):Jl.nIb(t.a," "+(xl.Kj(),xl.Ej)[e.C[f]]);if(i?(Jl.nIb(t.a," "+rg(R*t.b*e.J[f].a)/R),Jl.nIb(t.a," "+rg(R*t.b*-e.J[f].b)/R),Jl.nIb(t.a," "+rg(R*t.b*-e.J[f].c)/R)):Jl.nIb(t.a," 0 0 0"),Jl.nIb(t.a," "+n.Math.abs(e.w[f])),0!=e.s[f]&&Jl.nIb(t.a," CHG="+e.s[f]),0!=(48&e.u[f]))switch(Jl.nIb(t.a," RAD="),48&e.u[f]){case 16:Jl.nIb(t.a,"1");break;case 32:Jl.nIb(t.a,"2");break;case 48:Jl.nIb(t.a,"3")}1!=(3&e.u[f])&&2!=(3&e.u[f])||(Jl.nIb(t.a," CFG="),1==(3&e.u[f])?Jl.nIb(t.a,"1"):Jl.nIb(t.a,"2")),0!=e.A[f]&&Jl.nIb(t.a," MASS="+e.A[f]),-1!=(B=((e.u[f]&Tt)>>>27)-1)&&Jl.nIb(t.a," VAL="+(0==B?"-1":Jl._Gb(B))),((h=e.C[f])>=129&&h<=144||154==h)&&Jl.nIb(t.a," RGROUPS=(1 "+(154==h?0:h>=142?h-141:h-125)+")"),0==Tg(m=Cg(dn,e.B[f]),384)?Jl.nIb(t.a," HCOUNT=2"):0==Tg(m,128)?Jl.nIb(t.a," HCOUNT=1"):0==Tg(m,1792)?Jl.nIb(t.a," HCOUNT=-1"):0==Tg(m,1664)&&Jl.nIb(t.a," HCOUNT=1"),0!=Tg(U=Cg(e.B[f],6144),0)&&(Rg(Cg(U,fn),0)?Jl.nIb(t.a," SUBST="+(e.e[f]+1)):Jl.nIb(t.a," SUBST=-1")),0!=Tg(N=Cg(e.B[f],120),0)&&(0==Tg(N,112)?Jl.nIb(t.a," RBCNT=-1"):0==Tg(N,8)||0==Tg(N,104)?Jl.nIb(t.a," RBCNT=2"):0==Tg(N,88)?Jl.nIb(t.a," RBCNT=3"):0==Tg(N,56)&&Jl.nIb(t.a," RBCNT=4")),Jl.nIb(t.a,H)}for(Jl.nIb(t.a,"M  V30 END ATOM\n"),Jl.nIb(t.a,"M  V30 BEGIN BOND\n"),c=0;c<e.r;c++){switch(Jl.nIb(t.a,Kt+(c+1)),e.H[c]){case 1:default:P=1,L=0;break;case 2:P=2,L=0;break;case 4:P=3,L=0;break;case 129:P=1,L=3;break;case 257:P=1,L=1;break;case 386:P=2,L=2;break;case 64:P=4,L=0;break;case 32:P=9,L=0}0!=(D=31&e.G[c])&&(P=8==D?4:3==D?5:9==D?6:10==D?7:8),Jl.nIb(t.a," "+P+" "+(e.D[0][c]+1)+" "+(e.D[1][c]+1)),0!=L&&Jl.nIb(t.a," CFG="+L),0!=(y=0==(w=384&e.G[c])?0:256==w?1:2)&&Jl.nIb(t.a," TOPO="+y),Jl.nIb(t.a,H)}for(Jl.nIb(t.a,"M  V30 END BOND\n"),M=!1,s=0,p=vf(yl.tlb,z,6,32,15,1),a=vf(yl.tlb,z,6,32,15,1),g=0;g<e.f;g++)1!=(3&e.u[g])&&2!=(3&e.u[g])||(M=!0,1==(J=(e.u[g]&On)>>18)?++a[(e.u[g]&On)>>18!=1&&(e.u[g]&On)>>18!=2?-1:(e.u[g]&pt)>>20]:2==J?++p[(e.u[g]&On)>>18!=1&&(e.u[g]&On)>>18!=2?-1:(e.u[g]&pt)>>20]:++s);for(r=0,I=vf(yl.tlb,z,6,32,15,1),o=vf(yl.tlb,z,6,32,15,1),b=0;b<e.g;b++)2==xl.Vk(e,b)||1!=(3&e.F[b])&&2!=(3&e.F[b])||(M=!0,1==(J=(768&e.F[b])>>8)?++o[(768&e.F[b])>>8!=1&&(768&e.F[b])>>8!=2?-1:(e.F[b]&It)>>10]:2==J?++I[(768&e.F[b])>>8!=1&&(768&e.F[b])>>8!=2?-1:(e.F[b]&It)>>10]:++r);if(M){if(Jl.nIb(t.a,"M  V30 BEGIN COLLECTION\n"),0!=s){for(Jl.nIb(t.a,"M  V30 MDLV30/STEABS ATOMS=("+s),l=0;l<e.f;l++)(1==(3&e.u[l])||2==(3&e.u[l]))&&(e.u[l]&On)>>18==0&&Jl.nIb(t.a," "+(l+1));Jl.nIb(t.a,_t)}if(0!=r){for(Jl.nIb(t.a,"M  V30 MDLV30/STEABS BONDS=("+r),d=0;d<e.g;d++)2!=xl.Vk(e,d)&&(1==(3&e.F[d])||2==(3&e.F[d]))&&(768&e.F[d])>>8==0&&Jl.nIb(t.a," "+(d+1));Jl.nIb(t.a,_t)}for(j=0;j<32;j++){if(0!=p[j]){for(Jl.nIb(t.a,$t+(j+1)+" ATOMS=("+p[j]),l=0;l<e.f;l++)(1==(3&e.u[l])||2==(3&e.u[l]))&&(e.u[l]&On)>>18==2&&((e.u[l]&On)>>18!=1&&(e.u[l]&On)>>18!=2?-1:(e.u[l]&pt)>>20)==j&&Jl.nIb(t.a," "+(l+1));Jl.nIb(t.a,_t)}if(0!=a[j]){for(Jl.nIb(t.a,ne+(j+1)+" ATOMS=("+a[j]),l=0;l<e.f;l++)(1==(3&e.u[l])||2==(3&e.u[l]))&&(e.u[l]&On)>>18==1&&((e.u[l]&On)>>18!=1&&(e.u[l]&On)>>18!=2?-1:(e.u[l]&pt)>>20)==j&&Jl.nIb(t.a," "+(l+1));Jl.nIb(t.a,_t)}if(0!=I[j]){for(Jl.nIb(t.a,$t+(j+1)+" BONDS=("+I[j]),d=0;d<e.g;d++)2!=xl.Vk(e,d)&&(1==(3&e.F[d])||2==(3&e.F[d]))&&(768&e.F[d])>>8==2&&((768&e.F[d])>>8!=1&&(768&e.F[d])>>8!=2?-1:(e.F[d]&It)>>10)==j&&Jl.nIb(t.a," "+(d+1));Jl.nIb(t.a,_t)}if(0!=o[j]){for(Jl.nIb(t.a,ne+(j+1)+" BONDS=("+o[j]),d=0;d<e.g;d++)2!=xl.Vk(e,d)&&(1==(3&e.F[d])||2==(3&e.F[d]))&&(768&e.F[d])>>8==1&&((768&e.F[d])>>8!=1&&(768&e.F[d])>>8!=2?-1:(e.F[d]&It)>>10)==j&&Jl.nIb(t.a," "+(d+1));Jl.nIb(t.a,_t)}}Jl.nIb(t.a,"M  V30 END COLLECTION\n")}Jl.nIb(t.a,"M  V30 END CTAB\n")},xl.kr=function(){xl.ir(this),this.a=new Jl.rIb},xl.lr=function(n){xl.mr.call(this,n)},xl.mr=function(n){xl.nr.call(this,n,new Jl.rIb)},xl.nr=function(n,t){var e,i;xl.ir(this),xl.iu(n,15),this.a=t,i=null!=n.P?n.P:"",Jl.nIb(this.a,i+H),Jl.nIb(this.a,"Actelion Java MolfileCreator 2.0\n\n"),Jl.nIb(this.a,"  0  0  0  0  0  0              0 V3000\n"),this.b=1,(e=xl.pr(n))&&(this.b=xl.or(n)),xl.jr(this,n,e),Jl.nIb(this.a,Yt)},xl.or=function(t){var e,i,s,r,a,o,l,f,g;if(g=1,0!=(s=xl.Kk(t,t.q,t.r,(xl.Kj(),xl.Jj))))(s<1||s>3)&&(g=1.5/s);else{for(f=te,e=1;e<t.q;e++)for(i=0;i<e;i++)f>(r=(a=t.J[i].a-t.J[e].a)*a+(o=t.J[i].b-t.J[e].b)*o+(l=t.J[i].c-t.J[e].c)*l)&&(f=r);g=3/n.Math.max(.75,f)}return g},xl.pr=function(n){var t;if(1==n.q)return!0;for(t=1;t<n.q;t++)if(n.J[t].a!=n.J[0].a||n.J[t].b!=n.J[0].b||n.J[t].c!=n.J[0].c)return!0;return!1},xl.qr=function(n,t){var e;return(e=new xl.kr).b=t,xl.iu(n,15),xl.jr(e,n,!0),e.a.a},zf(136,1,{},xl.kr,xl.lr),o.b=1,yl._lb=lg(136),xl.tr=function(){xl.tr=Xf,xl.rr=Of(qf(yl.Xub,2),j,14,0,[Of(qf(yl.Xub,1),y,2,6,["Acyl","gCaHA`AIf`@"]),Of(qf(yl.Xub,1),y,2,6,["Alloc","gNph@l@ILzuR@@"]),Of(qf(yl.Xub,1),y,2,6,["Allyl","Al"]),Of(qf(yl.Xub,1),y,2,6,["Benzyl;Bn","daD@`F@DjUZxHH@@"]),Of(qf(yl.Xub,1),y,2,6,["Boc","daxD`@S@AIgijj@@"]),Of(qf(yl.Xub,1),y,2,6,["BOM;BzOM","deTH`@H@Re[TYj`@@@"]),Of(qf(yl.Xub,1),y,2,6,["Bs","dmtDpAdLS`aPAIe]jf`@e`@@"]),Of(qf(yl.Xub,1),y,2,6,["Bt","dew@`@aJ@DiY]paej`@@@"]),Of(qf(yl.Xub,1),y,2,6,["Btm","did@P@BJ@Die_ahH@@@"]),Of(qf(yl.Xub,1),y,2,6,["Butyl;nButyl","gJPHB@IRuP@"]),Of(qf(yl.Xub,1),y,2,6,["Benzoyl;Bz","didH`@p@RYm^Eh@@@@"]),Of(qf(yl.Xub,1),y,2,6,["Bzh","dg|@`N@LdbRbtJUB]aAP@@@@"]),Of(qf(yl.Xub,1),y,2,6,["Cbz","dmtD`@S@AIgYVUZh@@@@"]),Of(qf(yl.Xub,1),y,2,6,["cButyl","gKPHL@IThuT@@"]),Of(qf(yl.Xub,1),y,2,6,["cHeptyl","daD@`L@DjWVzjj`@"]),Of(qf(yl.Xub,1),y,2,6,["cHexyl","gOpHL@IToWUU@@"]),Of(qf(yl.Xub,1),y,2,6,["cOctyl","did@`L@DjWWajjj@@"]),Of(qf(yl.Xub,1),y,2,6,["cPentyl","gFpHL@ITimUP@"]),Of(qf(yl.Xub,1),y,2,6,["cPropyl","gBPHL@Qxjh@"]),Of(qf(yl.Xub,1),y,2,6,["COOH","gC`h@l@ILt@@ !Bb@K~@Hc}"]),Of(qf(yl.Xub,1),y,2,6,["DEAE","daz@`@x@RiUjj`@"]),Of(qf(yl.Xub,1),y,2,6,["DEIPS","diD@P@\\B@DjfVjj`@"]),Of(qf(yl.Xub,1),y,2,6,["DMIPS","gNpD@xD@RjZjh@"]),Of(qf(yl.Xub,1),y,2,6,["DMPM","dcLD`@kPCIEMDdcttDDT@@"]),Of(qf(yl.Xub,1),y,2,6,["DMPS","deT@P@\\B@LddTjPsU@@@@"]),Of(qf(yl.Xub,1),y,2,6,["DMTr","fak@b@@Mt@ISZ{SMjo{NQKfm@AU@@@E@@@@"]),Of(qf(yl.Xub,1),y,2,6,["DNP","dkmB`hdDt~@HeNfS{HihheCAUhBHX@@"]),Of(qf(yl.Xub,1),y,2,6,["DNS;Dan","fhi`a@KPP@HH@YIHYheEhYKQgKP@@QP@@@"]),Of(qf(yl.Xub,1),y,2,6,["DPIPS","fdyAA@H@\\B@FRRIQSQIHzp_Qjh@h@@@@@"]),Of(qf(yl.Xub,1),y,2,6,["DPTBS","fleAA@H@\\B@FRRIQSRIIWNbEMU@EP@@@@@"]),Of(qf(yl.Xub,1),y,2,6,["DTBMS","dmT@P@\\B@Djffjjjh@@"]),Of(qf(yl.Xub,1),y,2,6,["Ethyl","eMBD@ch@"]),Of(qf(yl.Xub,1),y,2,6,["Fmoc","fde@b@@Hp@IL{LrjxeVCzKUT@@@P@@@"]),Of(qf(yl.Xub,1),y,2,6,["iAmyl","gGPHJ@YIDZj@@"]),Of(qf(yl.Xub,1),y,2,6,["iButyl","gJPHB@ITuP@"]),Of(qf(yl.Xub,1),y,2,6,["Im","gFtHAj@IRnKSP@"]),Of(qf(yl.Xub,1),y,2,6,["iPropyl","gC`HL@Qz`@"]),Of(qf(yl.Xub,1),y,2,6,["MDIPS","diD@P@\\B@DjfZjj`@"]),Of(qf(yl.Xub,1),y,2,6,["MDPS","foA@A@@NA@CIIEEBdeeVLzj@@@@@@"]),Of(qf(yl.Xub,1),y,2,6,["Methyl","eFBH@c@@"]),Of(qf(yl.Xub,1),y,2,6,["MEM","gNphAR@IRoUT@@"]),Of(qf(yl.Xub,1),y,2,6,["Mes","deT@`J@DjY{[`bB`@@"]),Of(qf(yl.Xub,1),y,2,6,["MMTr","ffcAB@@Z@Dim]ifuWYrI\\uh@Jh@@@@@@"]),Of(qf(yl.Xub,1),y,2,6,["MOM","gCaHA`AJZ`@"]),Of(qf(yl.Xub,1),y,2,6,["MPM;PMB","deTH`@d@Rfuunh@J@@"]),Of(qf(yl.Xub,1),y,2,6,["Ms","gJPdH`DD@cuh@"]),Of(qf(yl.Xub,1),y,2,6,["MTM","gC`D@DX@Rfh@"]),Of(qf(yl.Xub,1),y,2,6,["mTolyl","daD@`N@DjWjXHB@@"]),Of(qf(yl.Xub,1),y,2,6,["N3","gClHaE`@RnReX@"]),Of(qf(yl.Xub,1),y,2,6,["nAmyl;Amyl","gGPHJ@IRmU@@"]),Of(qf(yl.Xub,1),y,2,6,["neoAm","gGPHJ@IUMU@@"]),Of(qf(yl.Xub,1),y,2,6,["NO2,Nitro","gChhhE`BRnRYh@"]),Of(qf(yl.Xub,1),y,2,6,["Np","deVDaHAI@HeNR[e_aZ@B@@"]),Of(qf(yl.Xub,1),y,2,6,["nPropyl;Propyl","gC`HL@IST@@"]),Of(qf(yl.Xub,1),y,2,6,["oTolyl","daD@`J@DjYvxH`@@"]),Of(qf(yl.Xub,1),y,2,6,["Phenyl","gOpHL@IToVD@@@"]),Of(qf(yl.Xub,1),y,2,6,["Pht","dcLL`@RU@Dfyed]ZBA`@@"]),Of(qf(yl.Xub,1),y,2,6,["Piv;Pv","gNqHA`AIffj`@"]),Of(qf(yl.Xub,1),y,2,6,["PMBM","dcLD`@T`AJUm]FZh@J@@"]),Of(qf(yl.Xub,1),y,2,6,["PNB","dcNLaHAEt@bTyInUvxV`@f@@"]),Of(qf(yl.Xub,1),y,2,6,["Poc","didD`@S@AIgexVjj`@"]),Of(qf(yl.Xub,1),y,2,6,["PPi","diDFsHSB[`|J|A@Lxn{lddqdZih@@"]),Of(qf(yl.Xub,1),y,2,6,["pTolyl","daD@`N@DjWzXHB@@"]),Of(qf(yl.Xub,1),y,2,6,["sAmyl","gGPHL@YIDZj@@"]),Of(qf(yl.Xub,1),y,2,6,["sButyl","gJPHL@ITuP@"]),Of(qf(yl.Xub,1),y,2,6,["SEM","diDHPFApD@rRQUJjj`@"]),Of(qf(yl.Xub,1),y,2,6,["SES","dedDpHP@``AgCIICeHmUT@@"]),Of(qf(yl.Xub,1),y,2,6,["SO3H","gJQdHl@``D^m@@"]),Of(qf(yl.Xub,1),y,2,6,["tAmyl","gGPHB@IUMU@@"]),Of(qf(yl.Xub,1),y,2,6,["TBDMS;TBS","dax@P@\\B@Djfjjh@@"]),Of(qf(yl.Xub,1),y,2,6,["TBDPS","fdy@A@@NA@CIIEEEIde]XOhuPAT@@@@@"]),Of(qf(yl.Xub,1),y,2,6,["TBMPS","dg\\HPHApH@rRQJJPjg]UAT@@@"]),Of(qf(yl.Xub,1),y,2,6,["tButyl,tBu","gJPHB@Q}T@@"]),Of(qf(yl.Xub,1),y,2,6,["TDS","ded@P@\\B@LddTeeUUP@@"]),Of(qf(yl.Xub,1),y,2,6,["Tf","daxDhHP@``BiAiCiCIICHmU@@"]),Of(qf(yl.Xub,1),y,2,6,["TFA","gNqBJIARFdF@YEHYUL@@"]),Of(qf(yl.Xub,1),y,2,6,["Thexyl","gNpHB@IUMUT@@"]),Of(qf(yl.Xub,1),y,2,6,["THF","gFqH@PAJYujj@@"]),Of(qf(yl.Xub,1),y,2,6,["THP","gOqH@PAJYZzjh@"]),Of(qf(yl.Xub,1),y,2,6,["TIPS","dmT@P@\\B@DjfYjjjh@@"]),Of(qf(yl.Xub,1),y,2,6,["TMS","gJPD@xD@czh@"]),Of(qf(yl.Xub,1),y,2,6,["Tosyl;Ts","dmtDPHP@``CIICLeaeZ@B@@"]),Of(qf(yl.Xub,1),y,2,6,["Troc","diDDHJxHaHcH`PCHiBeJjf@@"]),Of(qf(yl.Xub,1),y,2,6,["Trt","fbm@B@A@FRQIRKQPiIZdoIcdHJ`@@@@@@"]),Of(qf(yl.Xub,1),y,2,6,["Xyl","did@`J@DjYynBHH@@"])])},xl.ur=function(){var n,t,e,i,s,r,a,o;for(xl.tr(),xl.sr=new Fl.wRb,a=0,o=(r=xl.rr).length;a<o;++a)for(s=r[a],e=0,i=(t=Jl.VHb(s[0],";")).length;e<i;++e)n=t[e],Fl.oRb(xl.sr,Jl.THb(kl.TTb(n).toLowerCase(),"-"),s[1])},xl.vr=function(n){var t,e,i;for(xl.tr(),!xl.sr&&xl.ur(),n=Jl.THb(kl.TTb(n).toLowerCase(),"-"),t=new Fl.GRb(new Fl.LRb(new Fl.HNb(xl.sr).a).b),i=new Fl.PNb(t);Fl.pMb(i.a.a);)if(e=Fl.ERb(i.a).Wd(),Jl.KHb(kl.TTb(e).substr(0,kl.TTb(n).length),n))return!0;return!1},xl.sr=null,xl.wr=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d,c;for(f=n.g.M,g=0,r=0;r<e;r++)f>t[r]&&(f=t[r],g=r);for(c=vf(yl.tlb,z,6,e,15,1),u=g<e-1?g+1:0,o=t[g>0?g-1:e-1]<t[u],a=0;a<e;a++)c[a]=t[g],o?--g<0&&(g=e-1):++g==e&&(g=0);for(s=0;s<n.i.a.length;s++)if((d=Fl.Pi(n.i,s)).length==e){for(i=!0,l=0;l<e;l++)if(d[l]!=c[l]){i=!1;break}if(i)return}Fl.Ki(n.i,c),h=xl.Ir(n,c),Fl.Ki(n.j,h),xl.Zr(n,c,h)},xl.xr=function(n,t,e){var i,s,r,a,o,l,f;for(l=vf(yl.tlb,z,6,n.f,15,1),a=vf(yl.tlb,z,6,n.f,15,1),f=vf(yl.Lwb,nn,6,n.g.f,16,1),i=xl.Nk(n.g,0,t),s=xl.Nk(n.g,1,t),l[0]=i,l[1]=s,a[1]=-1,f[s]=!0,o=1;o>=1;)if(++a[o],a[o]!=xl.Ln(n.g,l[o])){if(!f[r=xl.Kn(n.g,l[o],a[o])]&&!e[r])if(r==i&&o>1){if(xl.wr(n,l,o+1),n.i.a.length>=cn)return}else o+1<n.f&&(l[++o]=r,f[r]=!0,a[o]=-1)}else f[l[o]]=!1,--o},xl.yr=function(n,t,e,i,s,r,a,o){var l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,I,P,M;for(h=0,d=(u=p=Fl.Pi(n.i,t)).length;h<d;++h)if(g=u[h],!xl.Vr(n,g))return!0;for(P=(I=Fl.Pi(n.j,t)).length,c=0,f=0,M=!1,C=0;C<P;C++)c<<=1,f<<=1,xl.Xr(n,I[C])?c|=1:o&&xl.Ur(n,I[C])?(c|=1,f|=1):-1!=(l=e[t][C])&&(i[l]?s[l]&&(c|=1,r[l]||(f|=1)):M=!0);switch(A=!1,P){case 3:for(b=Of(qf(yl.tlb,1),z,6,15,[2,1,4]),A=!0,m=0;m<3;m++)(c&b[m])==b[m]&&(6==xl.Ik(n.g,p[m])&&1==xl.rk(n.g,p[m])||5==xl.Ik(n.g,p[m])&&0==xl.rk(n.g,p[m]))&&(s[t]=!0,a[t]=m,0==(f&b[m])&&(A=!1));break;case 5:for(D=Of(qf(yl.tlb,1),z,6,15,[10,5,18,9,20]),A=!0,T=0;T<5;T++)if((c&D[T])==D[T])switch(xl.Ik(n.g,p[T])){case 6:-1==xl.rk(n.g,p[T])&&(s[t]=!0,a[t]=T,0==(f&D[T])&&(A=!1));break;case 7:xl.rk(n.g,p[T])<=0&&(s[t]=!0,a[t]=T);break;case 8:s[t]=!0,a[t]=T;break;case 16:case 34:case 52:2==xl.Ln(n.g,p[T])&&(s[t]=!0,a[t]=T)}break;case 6:A=!0,21==(21&c)&&(s[t]=!0,0==(21&f)&&(A=!1)),42==(42&c)&&(s[t]=!0,0==(42&f)&&(A=!1));break;case 7:for(H=Of(qf(yl.tlb,1),z,6,15,[42,21,74,37,82,41,84]),A=!0,j=0;j<7;j++)(c&H[j])==H[j]&&(6==xl.Ik(n.g,p[j])&&(1==xl.rk(n.g,p[j])||o&&xl.Lr(n,p[j]))||5==xl.Ik(n.g,p[j])&&0==xl.rk(n.g,p[j]))&&(s[t]=!0,a[t]=j,0==(f&H[j])&&(A=!1))}return s[t]&&!A&&(r[t]=!0),!!s[t]||!M},xl.zr=function(n,t,e,i,s){var r,a,o,l,f,g,u,h,d,c,b,D;for(r=vf(yl.tlb,ot,8,n.i.a.length,0,2),f=0;f<n.i.a.length;f++)for(r[f]=vf(yl.tlb,z,6,Fl.Pi(n.i,f).length,15,1),g=0;g<Fl.Pi(n.i,f).length;g++)r[f][g]=-1;for(b=vf(yl.tlb,z,6,n.g.g,15,1),d=0;d<n.j.a.length;d++)if(3==(c=Fl.Pi(n.j,d)).length||c.length>=5&&c.length<=7)for(l=0;l<c.length;l++)o=c[l],3==xl.Ln(n.g,xl.Nk(n.g,0,o))&&3==xl.Ln(n.g,xl.Nk(n.g,1,o))&&(b[o]>0?(r[b[o]>>>16][32767&b[o]]=d,r[d][l]=b[o]>>>16):b[o]=(d<<16)+Lt+l);for(a=vf(yl.Lwb,nn,6,n.i.a.length,16,1),D=0,u=-1;D>u;)for(u=D,h=0;h<n.i.a.length;h++)a[h]||xl.yr(n,h,r,a,t,e,i,s)&&(a[h]=!0,++D)},xl.Ar=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d,c;for(s=xl.Nk(n.g,0,t),r=xl.Nk(n.g,1,t),l=vf(yl.tlb,z,6,n.g.f,15,1),f=vf(yl.tlb,z,6,n.g.f,15,1),g=vf(yl.tlb,z,6,n.g.f,15,1),l[0]=s,l[1]=r,f[s]=1,f[r]=2,g[s]=-1,g[r]=s,o=1,u=1;o<=u;){for(h=0;h<xl.Ln(n.g,l[o]);h++){if(a=xl.Kn(n.g,l[o],h),o>1&&a==s){for(c=vf(yl.tlb,z,6,f[l[o]],15,1),i=l[o],d=0;d<c.length;d++)c[d]=i,i=g[i];return c}0!=f[a]||e[a]||(l[++u]=a,f[a]=f[l[o]]+1,g[a]=l[o])}++o}return null},xl.Br=function(n,t,e){var i,s;for(s=Fl.Pi(n.i,t),i=0;i<s.length;i++)if(e==s[i])return i;return-1},xl.Cr=function(n,t){return n.a[t]&B},xl.Dr=function(n,t,e){var i,s;for(s=Fl.Pi(n.j,t),i=0;i<s.length;i++)if(e==s[i])return i;return-1},xl.Er=function(n,t){return n.b[t]&B},xl.Fr=function(n,t){return n.c[t]},xl.Gr=function(n,t){return Fl.Pi(n.i,t)},xl.Hr=function(n,t){return Fl.Pi(n.j,t)},xl.Ir=function(n,t){var e,i,s,r,a;for(r=t.length,a=vf(yl.tlb,z,6,r,15,1),i=0;i<r;i++)for(e=i==r-1?t[0]:t[i+1],s=0;s<xl.Ln(n.g,t[i]);s++)if(xl.Kn(n.g,t[i],s)==e){a[i]=xl.Mn(n.g,t[i],s);break}return a},xl.Jr=function(n,t){return Fl.Pi(n.j,t).length},xl.Kr=function(n,t,e){var i;for(i=0;i<n.j.a.length;i++)if(xl.Qr(n,i,t)&&xl.Qr(n,i,e))return i;return-1},xl.Lr=function(n,t){var e;for(e=0;e<xl.Ln(n.g,t);e++)if(2==xl.Nn(n.g,t,e)&&8==xl.Ik(n.g,xl.Kn(n.g,t,e)))return!0;return!1},xl.Mr=function(n,t){return n.d[t]},xl.Nr=function(n,t){return 0!=(n.a[t]&J)},xl.Or=function(n,t){return 0!=(n.b[t]&J)},xl.Pr=function(n,t,e){var i,s;for(s=Fl.Pi(n.i,t),i=0;i<s.length;i++)if(e==s[i])return!0;return!1},xl.Qr=function(n,t,e){var i,s;for(s=Fl.Pi(n.j,t),i=0;i<s.length;i++)if(e==s[i])return!0;return!1},xl.Rr=function(n,t){return n.e[t]},xl.Sr=function(n,t){return 0!=(n.b[t]&gt)},xl.Tr=function(n,t){return 0!=(n.a[t]&Wn)},xl.Ur=function(n,t){var e,i,s,r,a,o;for(a=0;a<2;a++)if(e=xl.Nk(n.g,a,t),7==xl.Ik(n.g,e)&&2==xl.Ln(n.g,e)&&(i=xl.Nk(n.g,1-a,t),6==xl.Ik(n.g,i)))for(o=0;o<xl.Ln(n.g,i);o++)if(s=xl.Kn(n.g,i,o),r=xl.Mn(n.g,i,o),(8==xl.Ik(n.g,s)||16==xl.Ik(n.g,s))&&2==xl.Vk(n.g,r)&&1==xl.Ln(n.g,s))return!0;return!1},xl.Vr=function(n,t){var e,i,s,r,a;if(n.g.K){if(Rg(Cg(xl.Dk(n.g,t),1),0))return!0;if(null!=(a=xl.yk(n.g,t))){for(s=0,r=(i=a).length;s<r;++s)if(5==(e=i[s])||6==e||7==e||8==e||15==e||16==e||33==e||34==e)return!0;return!1}}return xl.bs(xl.Ik(n.g,t))},xl.Wr=function(n,t){var e,i,s,r,a;if(n.g.K){if(Rg(Cg(xl.Dk(n.g,t),1),0))return!1;if(null!=(e=xl.yk(n.g,t))){for(r=0,a=(s=e).length;r<a;++r)if(i=s[r],!xl.bn(i))return!1;return!0}}return xl.bn(xl.Ik(n.g,t))},xl.Xr=function(n,t){return xl.Vk(n.g,t)>1||64==xl.Yk(n.g,t)},xl.Yr=function(n){var t,e,i,s,r,a,o,l,f,g,u,h,d,c,b,D;for(D=0;D<n.d.length;D++)if(n.d[D]){for(b=!1,r=0,o=(i=Fl.Pi(n.i,D)).length;r<o;++r)t=i[r],n.a[t]|=J,xl.Wr(n,t)&&(b=!0);for(h=0,c=(g=Fl.Pi(n.j,D)).length;h<c;++h)l=g[h],n.b[l]|=J;if(n.e[D]){for(s=0,a=(e=Fl.Pi(n.i,D)).length;s<a;++s)t=e[s],n.a[t]|=gt;for(u=0,d=(f=Fl.Pi(n.j,D)).length;u<d;++u)l=f[u],n.b[l]|=gt}if(b){for(s=0,a=(e=Fl.Pi(n.i,D)).length;s<a;++s)t=e[s],n.a[t]|=Wn;for(u=0,d=(f=Fl.Pi(n.j,D)).length;u<d;++u)l=f[u],n.b[l]|=Wn}}},xl.Zr=function(n,t,e){var i,s,r,a;for(a=t.length,r=0;r<a;r++)(0==(i=n.a[t[r]]&B)||i>a)&&(n.a[t[r]]&=$n,n.a[t[r]]|=a);for(s=0;s<a;s++)(0==(i=n.b[e[s]]&B)||i>a)&&(n.b[e[s]]&=$n,n.b[e[s]]|=a)},xl.$r=function(n,t,e){var i;for(i=Fl.Pi(n.j,t).length;e>=i;)e-=i;for(;e<0;)e+=i;return e},xl._r=function(n,t){xl.as.call(this,n,t)},xl.as=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j;this.g=n,this.f=7,this.i=new Fl.cj,this.j=new Fl.cj,this.a=vf(yl.tlb,z,6,this.g.f,15,1),this.b=vf(yl.tlb,z,6,this.g.g,15,1),this.g.Mb(1),h=vf(yl.Lwb,nn,6,this.g.f,16,1),d=vf(yl.Lwb,nn,6,this.g.g,16,1);do{for(a=!1,e=0;e<this.g.f;e++)if(!h[e]){for(D=0,u=0;u<xl.Ln(this.g,e);u++)h[xl.Kn(this.g,e,u)]||++D;if(D<2){for(h[e]=!0,g=0;g<xl.Ln(this.g,e);g++)d[xl.Mn(this.g,e,g)]=!0;a=!0}}}while(a);for(j=0;j<this.g.f&&h[j];)++j;if(j!=this.g.f){for((l=vf(yl.tlb,z,6,this.g.f,15,1))[0]=j,(b=vf(yl.tlb,z,6,this.g.f,15,1))[0]=-1,(o=vf(yl.tlb,z,6,this.g.f,15,1))[j]=1,r=0,f=0,c=1;r<=f;){for(g=0;g<xl.Ln(this.g,l[r]);g++)(s=xl.Kn(this.g,l[r],g))!=b[l[r]]&&(0==o[s]?h[s]||(o[s]=c,b[s]=l[r],l[++f]=s):xl.xr(this,xl.Mn(this.g,l[r],g),h));if(++r>f)for(e=0;e<this.g.f;e++)if(0==o[e]&&!h[e]){o[e]=++c,l[++f]=e,b[e]=-1;break}}if(0!=(4&t)&&(this.d=vf(yl.Lwb,nn,6,this.i.a.length,16,1),this.e=vf(yl.Lwb,nn,6,this.i.a.length,16,1),this.c=vf(yl.tlb,z,6,this.i.a.length,15,1),xl.zr(this,this.d,this.e,this.c,0!=(8&t)),xl.Yr(this)),0!=(2&t))for(i=0;i<this.g.g;i++)d[i]||0==xl.Vk(this.g,i)||null!=(H=xl.Ar(this,i,h))&&xl.Zr(this,H,xl.Ir(this,H))}},xl.bs=function(n){return 5==n||6==n||7==n||8==n||15==n||16==n||33==n||34==n},zf(169,1,{},xl._r),o.f=0,yl.amb=lg(169),xl.cs=function(n,t){var e,i,s,r,a,o,l,f,g,u;if(2==t||5==t)Fl.Ki(n.D,xl.Hs(n.F,n.F.length)),n.b&&Fl.Ki(n.a,xl.Is(n.B,n.B.length));else if(4==t)u=xl.os(xl.Hs(n.F,n.F.length)),Fl.iSb(n.N,u)||(Fl.gSb(n.N,u),Fl.Ki(n.D,xl.Hs(n.F,n.F.length)),n.b&&Fl.Ki(n.a,xl.Is(n.B,n.B.length)));else if(3==t){if(u=xl.os(xl.Hs(n.F,n.F.length)),!Fl.iSb(n.N,u)){for(g=!1,a=new Fl.GRb(new Fl.LRb(new Fl.HNb(n.N.a).a).b),l=new Fl.PNb(a);Fl.pMb(l.a.a);){for(o=Fl.ERb(l.a).Wd(),f=0,s=0,r=(i=u).length;s<r;++s){for(e=i[s];f<o.length&&o[f]<e;)++f;if(f<o.length&&e==o[f]){g=!0;break}}if(g)break}g||(Fl.gSb(n.N,u),Fl.Ki(n.D,xl.Hs(n.F,n.F.length)),n.b&&Fl.Ki(n.a,xl.Is(n.B,n.B.length)))}}else 6==t&&(u=xl.ps(n,xl.Hs(n.F,n.F.length)),Fl.iSb(n.N,u)||(Fl.gSb(n.N,u),Fl.Ki(n.D,xl.Hs(n.F,n.F.length)),n.b&&Fl.Ki(n.a,xl.Is(n.B,n.B.length))))},xl.ds=function(n,t,e){var i,s,r,a,o,l,f,g,u;if(o=xl.Ln(n.G,t),(i=n.n[e])>o)return!1;if(f=xl.Dk(n.G,t),r=xl.Dk(n.g,e),s=xl.yk(n.g,e),l=xl.yk(n.G,t),Rg(Cg(r,1),0)){if(null!=s)if(Rg(Cg(f,1),0)){if(null==l)return!1;if(!xl.us(s,l))return!1}else if(null!=l){if(xl.ws(l,s))return!1}else if(xl.ts(xl.Ik(n.G,t),s))return!1}else{if(Rg(Cg(f,1),0))return!1;if(null!=s){if(null!=l){if(!xl.us(l,s))return!1}else if(!xl.ts(xl.Ik(n.G,t),s))return!1}else{if(null!=l)return!1;if(n.I[t]!=n.j[e])return!1}}if(Rg(Eg(f,r),0)){if(Rg(Cg(r,zn),0)){if(n.G.K&&Ig(Cg(f,zn),0))return!1;if(i!=o)return!1}if(Rg(Cg(r,fn),0)&&i>=o&&Ig(Cg(f,fn),0))return!1}if(Rg(Cg(n.H[t],kg(n.i[e])),0))return!1;if(Rg(Cg(n.A[e],kg(n.L[t])),0))return!1;if(a=Cg(r,v),n.G.K){if(0!=Tg(g=Cg(r,v),0)&&(0==Tg(a,0)||Rg(Cg(a,kg(g)),0)))return!1}else if(0!=Tg(a,0)&&Ig(Cg(a,n.L[t]),0))return!1;if(0!=xl.rk(n.g,e)&&xl.rk(n.g,e)!=xl.rk(n.G,t))return!1;if(0!=xl.Bk(n.g,e)&&xl.Bk(n.g,e)!=xl.Bk(n.G,t))return!1;if(0!=xl.Ek(n.g,e)&&xl.Ek(n.g,e)!=xl.Ek(n.G,t))return!1;if(0!=(u=zg(Fg(Cg(xl.Dk(n.g,e),Qn),22))))if(n.G.K){if(u!=zg(Fg(Cg(xl.Dk(n.G,t),Qn),22)))return!1}else if(xl.Fn(n.G,t)!=u)return!1;return!0},xl.es=function(n,t,e){var i,s,r,a,o,l,f,g,u;if(f=n.J[t],a=n.k[e],0!=(xl.Xk(n.g,e)&Dt)){if(l=xl.Zk(n.G,t),s=xl.Zk(n.g,e),r=31&xl.Xk(n.g,e),!(l==s||1==l&&0!=(1&r)||2==l&&0!=(2&r)||4==l&&0!=(4&r)||8==l&&0!=(32&r)||16==l&&0!=(64&r)||32==l&&0!=(16&r)||64==l&&0!=(8&r)))return!1;f&=-32,a&=-32}if(0!=(f&~a))return!1;if(0!=(u=(xl.Xk(n.g,e)&Nn)>>17)){if(n.G.K&&u==(xl.Xk(n.G,e)&Nn)>>17)return!0;for(i=!1,g=xl.no(n.G),o=0;o<g.i.a.length;o++)if(Fl.Pi(g.j,o).length==u&&xl.Qr(g,o,t)){i=!0;break}if(!i)return!1}return!0},xl.fs=function(n){var t,e;for(n.b=null,t=0;t<n.g.g;t++)xl.ql(n.g,t)&&(!n.b&&(n.b=new Fl.cj),(e=new xl.Js).a=xl.Nk(n.g,0,t),e.b=xl.Nk(n.g,1,t),e.d=xl.Pk(n.g,t),e.c=xl.Ok(n.g,t),Fl.Ki(n.b,e))},xl.gs=function(t){var e,i,s,r,a,o,l,f,g,u,h,d;for(xl.iu(t.g,t.M),f=n.Math.max(t.g.f,t.g.g)+16,t.r=vf(yl.tlb,z,6,f,15,1),t.t=vf(yl.tlb,z,6,f,15,1),t.u=vf(yl.tlb,z,6,f,15,1),t.s=vf(yl.Lwb,nn,6,f+1,16,1),o=vf(yl.Lwb,nn,6,t.g.f,16,1),l=vf(yl.Lwb,nn,6,t.g.g,16,1),s=0,i=0;i<t.g.f;i++)if(!t.C[i]&&!o[i])for(t.r[s]=i,t.u[s]=-1,t.t[s]=-1,g=s;s<=g;){for(u=0;u<xl.xn(t.g,t.r[s]);u++)g=xl.Es(t,s,g,u,o,l,-1);for(;t.s[++s];);}if(t.v=s,0!=t.o){for(g=t.v-1,a=0;a<t.d;a++)for(s=0;s<=g;){for(h=0;h<xl.xn(t.g,t.r[s]);h++)g=xl.Es(t,s,g,h,o,l,a);for(;t.s[++s];);}for(e=0;e<t.g.f;e++)if(t.C[e]&&!o[e])for(t.r[s]=e,t.u[s]=-1,t.t[s]=-1,g=s;s<=g;){for(h=0;h<xl.xn(t.g,t.r[s]);h++)xl.Kn(t.g,t.r[s],h)<t.g.f&&(g=xl.Es(t,s,g,h,o,l,t.f[e]));for(;t.s[++s];);}for(t.e=vf(yl.tlb,z,6,t.d,15,1),d=0;d<t.d;d++)t.e[d]=-1;for(u=t.v;u<s;u++)r=t.f[t.r[u]],-1==t.e[r]&&(t.e[r]=u)}t.w=s},xl.hs=function(n,t){var e,i,s,r,a,o,l,f;for(f=xl.no(n.G),o=0;o<f.i.a.length;o++)if(xl.Qr(f,o,t)){for(l=vf(yl.tlb,z,6,2,15,1),s=0;s<2;s++)for(l[s]=I,i=xl.Nk(n.G,s,t),r=0;r<xl.Ln(n.G,i);r++)(e=xl.Kn(n.G,i,r))!=xl.Nk(n.G,1-s,t)&&l[s]>e&&(l[s]=e);return a=0,xl.Pr(f,o,l[0])&&++a,xl.Pr(f,o,l[1])&&++a,2==a?2:1==a?1:2}return 0},xl.is=function(n,t,e){var i,s,r,a,o;if(n.b)for(n.B=vf(yl.Lwb,nn,6,t.length,16,1),s=new Fl.zOb(n.b);s.a<s.c.a.length;)if(i=Fl.yOb(s),null==n.f||-1==e&&-1==n.f[i.a]&&-1==n.f[i.b]||-1!=e&&(n.f[i.a]==e||n.f[i.b]==e)){if(o=vf(yl.tlb,z,6,i.c+2,15,1),(r=xl.ho(n.G,o,n.F[i.a],n.F[i.b],i.c+1,t,null)-1)<i.d||r>i.c)return!1;for(a=1;a<=r;a++)n.B[o[a]]=!0}return!0},xl.js=function(n,t){var e,i,s,r,a,o,l,f;for(s=0;s<n.g.g;s++)if(0!=(xl.Xk(n.g,s)&dt)){if(0==(r=xl.Wk(n.g,s)))continue;if(e=xl.Nk(n.g,0,s),i=xl.Nk(n.g,1,s),null==n.f||-1==t&&-1==n.f[e]&&-1==n.f[i]||-1!=t&&(n.f[e]==t||n.f[i]==t)){if(a=n.F[e],o=n.F[i],l=xl.In(n.G,a,o),0==(f=xl.Wk(n.G,l))&&(xl.To(n.G,l)&&(f=xl.hs(n,l)),0==f))continue;if(3==r)continue;if(3==f)continue;if(xl.qs(n,s)==(r==f))return!1}}return!0},xl.ks=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c;for(a=0,l=0;l<n.g.f;l++)if((null==n.f||n.f[l]==t)&&Rg(Cg(xl.Dk(n.g,l),Sn),0)){if(h=n.F[l],u=xl.Ck(n.g,l),c=xl.Ck(n.G,h),0==u)continue;if(3==u)continue;if(0==c||3==c)return!1;if(1==xl.wk(n.g,l)){++a;continue}if(1==xl.wk(n.G,h))return!1;if(2==xl.wk(n.g,l)){++a;continue}if(2==xl.wk(n.G,h))return!1;if(xl.vs(n,l)==(u==c))return!1}if(0!=a){for(s=vf(yl.tlb,z,6,a,15,1),r=0,f=0;f<n.g.f;f++)null!=n.f&&n.f[f]!=t||!Rg(Cg(xl.Dk(n.g,f),Sn),0)||0!=(u=xl.Ck(n.g,f))&&3!=u&&(s[r++]=xl.vk(n.g,f)<<24|xl.wk(n.g,f)<<22|f);for(kl.nTb(s,kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[]))),r=0;r<s.length;)for(g=s[r]&Bt,d=n.F[g],e=-4194304&s[r],i=xl.vs(n,g)^xl.Ck(n.g,g)==xl.Ck(n.G,d),++r;r<s.length&&(-4194304&s[r])==e;r++){if(o=s[r]&Bt,h=n.F[o],xl.wk(n.G,h)!=xl.wk(n.G,d)||xl.vk(n.G,h)!=xl.vk(n.G,d))return!1;if((xl.vs(n,o)^xl.Ck(n.g,o)==xl.Ck(n.G,h))!=i)return!1}}return!0},xl.ls=function(n,t,e){var i,s,r,a,o,l,f;if(n.O=!1,n.D=new Fl.cj,n.a=new Fl.cj,Fl.hRb(n.N.a),!n.G||!n.g)return 0;if(n.g.f-n.o>n.G.f||n.g.g-n.p>n.G.g)return 0;if(0==n.g.f)return 0;for(6==t&&(n.M=63),xl.As(n,e),i=vf(yl.Lwb,nn,6,n.G.f,16,1),n.F=vf(yl.tlb,z,6,n.g.f,15,1),Fl.JOb(n.F),o=vf(yl.tlb,z,6,n.w,15,1),Fl.OOb(o,o.length,-1),r=0;!n.O;){if(0!=n.v){if(f=-1==n.t[r]?n.G.f:xl.xn(n.G,n.F[n.t[r]]),++o[r],o[r]==f){if(o[r]=-1,0==r)break;--r,n.s[r]||(i[n.F[n.r[r]]]=!1);continue}if(-1==n.t[r])i[o[r]]||xl.ds(n,o[r],n.r[r])&&(n.F[n.r[r]]=o[r],i[o[r]]=!0,++r);else{if(xl.Kn(n.G,n.F[n.t[r]],o[r])>=n.G.f)continue;s=xl.Kn(n.G,n.F[n.t[r]],o[r]),n.s[r]?s==n.F[n.r[r]]&&xl.es(n,xl.Mn(n.G,n.F[n.t[r]],o[r]),n.u[r])&&++r:i[s]||xl.ds(n,s,n.r[r])&&xl.es(n,xl.Mn(n.G,n.F[n.t[r]],o[r]),n.u[r])&&(i[s]=!0,n.F[n.r[r]]=s,++r)}}if(r==n.v){if(xl.ks(n,-1)&&xl.js(n,-1)&&xl.is(n,i,-1)){for(l=!1,a=0;a<n.d;a++)if(xl.rs(n,i,o,a)){l=!0;break}if(1==t&&!l)return 1;if(!l&&(xl.cs(n,t),2==t))return 1}if(0==r)break;--r,n.s[r]||(i[n.F[n.r[r]]]=!1)}}return n.D.a.length},xl.ms=function(n,t){var e,i,s,r,a;if(r=0,n.K){switch(t<n.f&&xl.Tr(n.p,t)?r=Eg(r,ee):t<n.f&&xl.Nr(n.p,t)&&(r=Eg(r,2)),0!=(a=0==(i=n.u[t]&Rt)?0:i==cn?2:i==zn?3:4)&&(r=Eg(r,8),a>2&&(r=Eg(r,16)),a>3&&(r=Eg(r,32))),(e=n.s[t])<0?r=Eg(r,jn):e>0&&(r=Eg(r,Hn)),n.j[t]){case 0:break;case 1:r=Eg(r,gt);break;case 2:r=Eg(r,Mn);break;case 3:r=Eg(r,Nn);break;default:r=Eg(r,wn)}switch(xl.An(n,t)){case 0:break;case 1:r=Eg(r,kn);break;case 2:r=Eg(r,En);break;case 3:r=Eg(r,xn);break;default:r=Eg(r,Fn)}(s=n.o[t])>0&&(r=Eg(r,ln)),s>1&&(r=Eg(r,Lt))}else{switch(r=t<n.f&&xl.Tr(n.p,t)?Eg(r,ee):t<n.f&&xl.Nr(n.p,t)?Eg(r,2):Eg(r,4),r=0!=(n.u[t]&wt)?Eg(r,gn):Eg(r,un),r=Eg(r,0==(a=0==(i=n.u[t]&Rt)?0:i==cn?2:i==zn?3:4)?112:2==a?104:3==a?88:56),0==(e=n.s[t])?r=Eg(r,Dn):e<0?r=Eg(r,jn):e>0&&(r=Eg(r,Hn)),n.e[t]-xl.eo(n,t)+xl.$n(n,t)){case 0:r=Eg(r,1792);break;case 1:r=Eg(r,1664);break;case 2:r=Eg(r,1408);break;default:r=Eg(r,896)}switch(n.j[t]){case 0:r=Eg(r,3932160);break;case 1:r=Eg(r,Cn);break;case 2:r=Eg(r,Tn);break;case 3:r=Eg(r,pn);break;default:r=Eg(r,wn)}switch(xl.An(n,t)){case 0:r=Eg(r,Un);break;case 1:r=Eg(r,yn);break;case 2:r=Eg(r,Jn);break;case 3:r=Eg(r,Bn);break;default:r=Eg(r,Fn)}switch(s=n.o[t]){case 0:r=Eg(r,98304);break;case 1:r=Eg(r,81920);break;default:r=Eg(r,49152)}}return r},xl.ns=function(n,t){var e;if(e=0,t<n.g&&(xl.Sr(n.p,t)||64==n.H[t])||64==n.H[t])e|=8;else switch(xl.Vk(n,t)){case 4:case 0:e|=32;break;case 1:e|=1;break;case 2:e|=2;break;case 3:e|=4;break;case 5:e|=64}return 0!=(64&n.F[t])?e|=256:n.K||(e|=128),t<n.g&&xl.Or(n.p,t)?e|=Pn:n.K||(e|=ie),e},xl.os=function(n){var t,e,i,s,r,a,o,l,f,g;for(l=0,r=0,o=(i=n).length;r<o;++r)-1==(t=i[r])&&++l;if(0!=l)for(g=n,n=vf(yl.tlb,z,6,g.length-l,15,1),f=0,s=0,a=(e=g).length;s<a;++s)-1!=(t=e[s])&&(n[f++]=t);return kl.nTb(n,kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[]))),n},xl.ps=function(n,t){var e,i,s,r,a,o,l;for(r=0,i=0,s=(e=t).length;i<s;++i)-1==e[i]&&++r;for(l=vf(yl.tlb,z,6,t.length-r,15,1),o=0,a=0;a<t.length;a++)-1!=t[a]&&(l[o]=xl.tu(n.g,a)<<16|xl.tu(n.G,t[a]),++o);return kl.nTb(l,kl.TTb(Qf(Fl.fPb.prototype.Zd,Fl.fPb,[]))),l},xl.qs=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d;for(r=!1,s=0;s<2;s++)if(e=xl.Nk(n.g,s,t),g=n.F[e],xl.Ln(n.G,g)>2){for(h=xl.Nk(n.g,1-s,t),l=I,o=0;o<xl.Ln(n.g,e);o++)(i=xl.Kn(n.g,e,o))!=h&&l>i&&(l=i);for(d=n.F[h],f=I,a=0;a<xl.Ln(n.G,g);a++)(u=xl.Kn(n.G,g,a))!=d&&f>u&&(f=u);n.F[l]!=f&&(r=!r)}return r},xl.rs=function(n,t,e,i){var s,r,a,o,l,f,g,u;for(l=(o=n.e[i])+1;l<n.w&&n.f[n.r[l]]==i;)++l;for(g=o;g<l;g++)e[g]=-1;for(a=o;;)if(u=-1==n.t[a]?n.G.f:xl.xn(n.G,n.F[n.t[a]]),++e[a],e[a]!=u){if(-1==n.t[a])t[e[a]]||xl.ds(n,e[a],n.r[a])&&(n.F[n.r[a]]=e[a],t[e[a]]=!0,++a);else{if(xl.Kn(n.G,n.F[n.t[a]],e[a])>=n.G.f){++e[a];continue}r=xl.Kn(n.G,n.F[n.t[a]],e[a]),n.s[a]?r==n.F[n.r[a]]&&xl.es(n,xl.Mn(n.G,n.F[n.t[a]],e[a]),n.u[a])&&++a:t[r]||xl.ds(n,r,n.r[a])&&xl.es(n,xl.Mn(n.G,n.F[n.t[a]],e[a]),n.u[a])&&(t[r]=!0,n.F[n.r[a]]=r,++a)}if(a==l){if(xl.ks(n,i)&&xl.js(n,i)&&xl.is(n,t,i)){for(f=o;f<l;f++)n.s[f]||(s=n.r[f],t[n.F[s]]=!1,n.F[s]=-1);return!0}--a,n.s[a]||(t[n.F[n.r[a]]]=!1,n.F[n.r[a]]=-1)}}else{if(e[a]=-1,a==o)break;--a,n.s[a]||(t[n.F[n.r[a]]]=!1,n.F[n.r[a]]=-1)}return!1},xl.ss=function(n){return xl.ls(n,1,n.c)>0},xl.ts=function(n,t){var e;for(e=0;e<t.length;e++)if(t[e]==n)return!0;return!1},xl.us=function(n,t){var e,i,s;for(s=0,i=0;i<n.length;i++){for(e=n[i];t[s]<e;)if(++s==t.length)return!1;if(t[s]>e)return!1}return!0},xl.vs=function(n,t){var e,i,s,r,a,o,l,f;if(a=!1,0==xl.Bn(n.g,t))for(r=1;r<xl.Ln(n.g,t);r++)for(o=0;o<r;o++)i=xl.Kn(n.g,t,r),s=xl.Kn(n.g,t,o),n.F[i]>n.F[s]^i>s&&(a=!a);else for(r=0;r<xl.Ln(n.g,t);r++){for(e=xl.Kn(n.g,t,r),f=0,l=vf(yl.tlb,z,6,3,15,1),o=0;o<xl.Ln(n.g,e);o++)l[f]=xl.Kn(n.g,e,o),l[f]!=t&&++f;2==f&&n.F[l[0]]>n.F[l[1]]^l[0]>l[1]&&(a=!a)}return a},xl.ws=function(n,t){var e,i,s,r;for(s=0,r=0;s<n.length&&r<t.length;){if((e=n[s])==(i=t[r]))return!0;e<i?++s:++r}return!1},xl.xs=function(n,t){var e,i,s,r,a;if(t&&0!=t.q&&t.K){for(n.g=t,n.q=!1,xl.iu(n.g,1),n.M=7,i=0;i<n.g.f;i++)Rg(Cg(xl.Dk(n.g,i),{l:Sn,m:0,h:3}),0)&&(n.M=15);for(a=0;a<n.g.g;a++)0!=(xl.Xk(n.g,a)&dt)&&(n.M=15);for(n.K&&7!=n.M&&xl.iu(n.G,n.M),n.o=0,n.p=0,n.C=vf(yl.Lwb,nn,6,n.g.f,16,1),s=0;s<n.g.f;s++)n.C[s]=Rg(Cg(xl.Dk(n.g,s),tn),0),n.C[s]&&++n.o;if(n.d=0,n.f=null,0!=n.o){if(0!=n.o)for(r=0;r<n.g.g;r++)(n.C[xl.Nk(n.g,0,r)]||n.C[xl.Nk(n.g,1,r)])&&++n.p;for(e=0;e<n.g.q;e++)xl.em(n.g,e,n.C[e]);n.f=vf(yl.tlb,z,6,n.g.q,15,1),n.d=xl.Un(n.g,n.f,!0,!1)}}else n.g=null},xl.ys=function(n,t,e){xl.zs(n,e),xl.xs(n,t)},xl.zs=function(n,t){t&&0!=t.q?(n.G=t,n.K=!1,xl.iu(n.G,1)):n.G=null},xl.As=function(n,t){n.K||(xl.Ds(n,t),n.K=!0),n.q||(xl.Bs(n,t),xl.gs(n),xl.fs(n),n.q=!0)},xl.Bs=function(n,t){var e,i,s,r,a,o,l,f,g,u;for(r=null,l=null,a=null,xl.iu(n.g,n.M),n.n=vf(yl.tlb,z,6,n.g.f,15,1),i=0;i<n.g.f;i++)n.n[i]=xl.Ln(n.g,i);if(0!=n.o){for(f=new xl.Bu(n.g.q,n.g.r),u=vf(yl.Lwb,nn,6,n.g.q,16,1),s=0;s<n.g.q;s++)u[s]=!n.C[s];for(xl.nn(n.g,f,u,!0,null),xl.iu(f,n.M),xl.Cs(n,f,t),r=n.i,l=n.k,a=n.j,g=0,e=0;e<n.g.f;e++)n.C[e]||(n.n[e]=xl.Ln(f,g++))}if(xl.Cs(n,n.g,t),0!=n.o){for(g=0,e=0;e<n.g.q;e++)n.C[e]||(n.i[e]=r[g],n.j[e]=a[g++]);for(g=0,o=0;o<n.g.r;o++)!n.C[xl.Nk(n.g,0,o)]&&!n.C[xl.Nk(n.g,1,o)]&&(n.k[o]=l[g++])}},xl.Cs=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j;for(b=t.f,n.i=vf(yl.ulb,st,6,t.f,14,1),n.j=vf(yl.tlb,z,6,t.f,15,1),o=0;o<b;o++)n.i[o]=qg(Cg(Eg(xl.ms(t,o),t.B[o]),se),re),n.j[o]=t.C[o],0!=(1&e)&&(n.j[o]+=t.s[o]+16<<8),0!=(2&e)&&(n.j[o]+=t.A[o]<<16);for(n.A=vf(yl.ulb,st,6,t.f,14,1),xl.iu(t,7),H=t.p,c=0;c<H.i.a.length;c++){for(d=!1,g=0,u=(f=Fl.Pi(H.j,c)).length;g<u;++g)if(h=f[g],0!=(t.G[h]&qn)){d=!0;break}if(!d)for(j=Fl.Pi(H.j,c).length,r=0,a=(s=Fl.Pi(H.i,c)).length;r<a;++r)i=s[r],3==j?n.A[i]=Eg(n.A[i],V):4==j?n.A[i]=Eg(n.A[i],O):5==j?n.A[i]=Eg(n.A[i],K):6==j?n.A[i]=Eg(n.A[i],W):7==j&&(n.A[i]=Eg(n.A[i],_))}for(D=t.g,n.k=vf(yl.tlb,z,6,t.g,15,1),l=0;l<D;l++)n.k[l]=6291967&(xl.ns(t,l)|t.G[l])^6291840,0!=(4&e)?0!=(2&n.k[l])&&(n.k[l]|=8):0!=(8&e)&&0!=(2&n.k[l])&&l<t.g&&xl.Or(t.p,l)&&(n.k[l]|=8)},xl.Ds=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d;for(xl.iu(n.G,n.M),g=n.G.f,n.I=vf(yl.tlb,z,6,g,15,1),n.H=vf(yl.ulb,st,6,g,14,1),a=0;a<g;a++)n.H[a]=qg(Cg(Eg(xl.ms(n.G,a),xl.Dk(n.G,a)),se),re),n.I[a]=xl.Ik(n.G,a),0!=(1&t)&&(n.I[a]+=xl.rk(n.G,a)+16<<8),0!=(2&t)&&(n.I[a]+=xl.Bk(n.G,a)<<16);for(n.L=vf(yl.ulb,st,6,g,14,1),h=xl.no(n.G),f=0;f<h.i.a.length;f++)for(d=Fl.Pi(h.j,f).length,s=0,r=(i=Fl.Pi(h.i,f)).length;s<r;++s)o=i[s],3==d?n.L[o]=Eg(n.L[o],V):4==d?n.L[o]=Eg(n.L[o],O):5==d?n.L[o]=Eg(n.L[o],K):6==d?n.L[o]=Eg(n.L[o],W):7==d&&(n.L[o]=Eg(n.L[o],_));for(e=0;e<g;e++)0==(d=xl.Fn(n.G,e))?n.L[e]=Eg(n.L[e],Z):d>7&&(n.L[e]=Eg(n.L[e],$));for(u=n.G.g,n.J=vf(yl.tlb,z,6,u,15,1),l=0;l<u;l++)n.J[l]=6422527&(xl.ns(n.G,l)|xl.Xk(n.G,l))^6291840},xl.Es=function(n,t,e,i,s,r,a){var o,l;return o=xl.Kn(n.g,n.r[t],i),n.C[o]&&n.f[o]!=a||o==n.t[t]||r[l=xl.Mn(n.g,n.r[t],i)]||xl.ql(n.g,l)||(n.r[++e]=o,n.t[e]=n.r[t],n.u[e]=l,r[l]=!0,s[o]?n.s[e]=!0:s[o]=!0),e},xl.Fs=function(){this.c=8,this.N=new Fl.mSb(new gf.E6)},xl.Gs=function(){this.c=1,this.N=new Fl.mSb(new gf.E6)},xl.Hs=function(t,e){var i;return i=vf(yl.tlb,z,6,e,15,1),Jl.wIb(t,0,i,0,n.Math.min(t.length,e)),i},xl.Is=function(t,e){var i;return i=vf(yl.Lwb,nn,6,e,16,1),Jl.wIb(t,0,i,0,n.Math.min(t.length,e)),i},zf(91,1,{},xl.Fs,xl.Gs),o.c=0,o.d=0,o.o=0,o.p=0,o.q=!1,o.v=0,o.w=0,o.K=!1,o.M=0,o.O=!1,yl.dmb=lg(91),xl.Js=function(){},zf(250,1,{250:1},xl.Js),o.a=0,o.b=0,o.c=0,o.d=0,yl.bmb=lg(250),xl.Ms=function(){xl.Ms=Xf,xl.Ks=Of(qf(yl.Xub,1),y,2,6,["QM@HzAmdqjF@","RF@Q``","qC`@ISTAlQE`","`J@H","QM@HzAmdqbF@","qC`@ISTAlQEhqPp@","sJP@DiZhAmQEb","RF@QPvR@","QM@HzA@","qC`@ISTAlQEhpPp@","qC`@Qz`MbHl","sJP@DiZhAmQEcFZF@","RFPDXH","qC`@IVtAlQE`","QM@HvAmdqfF@","sGP@DiVj`FsDVM@","`L@H","sJP@DizhAmQEcFBF@","sJP@DjvhAmQEb","sFp@DiTt@@AlqEcP","sGP@LdbMU@MfHlZ","QMHAIhD","QM@HzAy@","sJP@DkVhAmQEb","sNp@DiUjj@[\\QXu`","sJP@DiZhAmQEcFBF@","sGP@DjVj`FsDVM@","RFPDTH","RG@DXOH@","sGP@Divj`FsDVMcAC@","sGP@Dj}j`FsDVM@","qC`@Qz`MbHmFRF@","sNp@LdbJjj@[\\QXu`","QMHAIhGe@","QM@HzAyd`","QM`AIhD","qC`@ISTA@","sGP@DkUj`FsDVM@","qC`@IVtAlQEhqPp@","sNp@DiUjj@[\\QXuqea`@","KAx@@IRjuUPAlHPfES\\","QM`BN`P","sJP@DjZhAmQEcFJF@","Hid@@DjU^nBBH@FtaBXUMp`","sNp@Diujj@[\\QXuq`a`@","sJP@DjvhAmQEcFZF@","sJP@DjZhAmQEcFFF@","sOp@DjWkB@@FwDVM\\YhX@","sNp@Dj}Zj@[\\QXu`","sNp@DiWjj@[\\QXuq`a`@","sOp@DjWkB@@D","KAx@@ITouUPAlHPfES\\","KAx@@YIDTjjh@vDHSBin@","sNp@DkUZj@[\\QXu`","RFPDXOH@","QM`BN`^L`","qC`@ISTAy@","sGP@LdbMU@MfHl[FVF@","qCb@AIZ`H","KAx@@IRjuUPAlHPfES]FFa`@","KAx@@ITnuUPAlHPfES\\","HiD@@DiUVjj`AmHPfES\\H","sNp@DjUjj@[\\QXu`","sJP@DkVhAmQEcFJF@","sGP@DjVj`FsDVMcCC@","qC`@Qz`MbHmFBF@","sJP@DkfhAmQEb","qC`@IVtAlQEhsPp@","sGP@Djuj`FsDVM@","sGP@Dj}j`FsDVMcMC@","sJP@DiZhA@","KAx@@ISjuUPAlHPfES]F@a`@","sJP@DjZhAmQEcFRF@","KAx@@IRnuUPAlHPfES]F@a`@","HiD@@DjWvjj`AmHPfES\\H","QMHAIhGd@","sNp@DiUjj@[\\QXuq`a`@","KAx@@IVjmUPAlHPfES\\","sGP@DjVj`FsDVMcMC@","QM`AIhGe@","HiD@@LdbJRjjh@[RDIaTwB","qCp@AIZ`H","sGP@LdbMU@MfHl[FFF@","QMDARVA@","sNp@LdbJjj@[\\QXuqba`@","sNp@LdbJjj@[\\QXuqca`@","sGP@Dkej`FsDVM@","qCb@AIZ`OI@","HaD@@DjUZxHH@AlHPfES]FLa`@","sGP@DkYj`FsDVM@","qCb@AIV`H","sNp@LdbJjj@[\\QXuqea`@","sGP@DkUj`FsDVMcEC@","sFp@DiTt@@Axa@","Hmt@@DjU_ZxHHj@AmhPfES\\Lj","QM`BN`^P","qCb@AIZ`OH`","sFp@DiTt@@AxaP","sGP@Djuj`FsDVMcEC@","sGP@Djuj`FsDVMcIC@","sGP@DkUj`FsDVMcKC@","sJP@DkfhAmQEcFRF@","sGP@DjVj`FsDVMcIC@","HaD@@DjUZxHH@AlHPfES]FFa`@","qC`@IRtDVqDV@","sNp@Dj}Zj@[\\QXuqfa`@","KAx@@ITnuUPAlHPfES]FFa`@","HiD@@DkUUjj`AmHPfES\\H","sJQ@@dkU@H","qC`@Qz`H","KAx@@IUkmUPAlHPfES\\","KAx@@ITouUPAlHPfES]FJa`@","sJP@H~j@[TQX`","sGP@DjZj`FsDVM@","sJP@DkVhAmQEcFFF@","sJX@@eKU@H","sJP@DizhAy@","QMHAIhGbP","KAx@@ITouUPAlHPfES]FNa`@","HaD@@DjUZxHD@AlHPfES\\","HaD@@DjUZxHH@A@","sNp@LdbJjj@[\\QXuqaa`@","Hed@@LdbRQUUUP@vTHSBinFP","KAx@@ITouUPAlHPfES]FLa`@","sNp@DkUZj@[\\QXuqba`@","KAx@@ITjuUPAlHPfES]FNa`@","KAx@@YIDTjjh@vDHSBincGPp@","HaD@@DjYvxH`@AlHPfES]FLa`@","RF@QP`","qCb@AIj`H","sNp@DjUjj@[\\QXuqaa`@","sNp@DkVZj@[\\QXu`","KAx@@YIDUJjh@vDHSBin@","sGP@DkYj`FsDVMcIC@","sGP@DjVj`FsDVMcAC@","sGP@DiVj`D","sJP@DkVhAmQEcFZF@","sNp@LdbLjj@[\\QXu`","QM@HvAmdqbF@","HaD@@DjWjXHB@AlHPfES\\","sNp@DjwZj@[\\QXuqba`@","sNp@LdbJjj@[\\QXuqda`@","sFp@DiTt@@Axa`","HiD@@Djuujj`AmHPfES\\H","sNp@DkUZj@[\\QXuqca`@","sJP@DiZhAy@","KAx@@YIDTjjh@vDHSBincCPp@","KAx@@IWNmUPAlHPfES\\","KAx@@IVkMUPAlHPfES\\","sJQ@@dju@H","qCb@AIZ`OH@","qC`@ISTAxa@","sNp@DjyZj@[\\QXu`","Hid@@DjUfaBB`@FtaBXUMp`","HiD@@DiUVjj`AmHPfES\\LXBF@","KAx@@IUjmUPAlHPfES\\","HiD@@DjWvjj`AmHPfES\\LXjF@","sJP@DjVhAmQEb","qCb@AIV`OH`","HiD@@LdbJRjjh@[RDIaTwCFDa`@","KAx@@YIDTjjh@vDHSBinc@Pp@","sNp@DjUjj@[\\QXuqda`@","qC`@Qz`OED","sJP@DkfhAmQEcFZF@","KAx@@YIDbjjh@vDHSBincDPp@","sGP@Djyj`FsDVMcMC@","KAx@@IVrmUPAlHPfES\\","qCp@AIZ`OI@","sJX@@dkU@H","sJQ@@dkU@OH`","sNp@Di]ZjBBvxbqk@","Hkl@@DjU_Uk``bj`@[VDIaTwCJzX","sGP@DjZj`FsDVMcEC@","Hid@@DjU^nBBH@FtaBXUMpqcHX@","sNp@DkeZj@[\\QXu`","sNp@DjYjj@[\\QXuqca`@","sGQ@@djuT@`","HiD@@LdbJTjjh@[RDIaTwB","sOp@DjWkB@@Gd`","HeT@@LdbbRKBDQD@CYPaLJfxY@","qCr@XIKTA@","HiD@@DjW^jj`AmHPfES\\LXJF@","HeT@@DjU]k``b`@[JDIaTwCH","sGP@Djuj`FsDVMcCC@","`IH`B","sOp@DjWkB@@GdX","sJQ@@eKU@H","KAx@@YIDUJjh@vDHSBincBPp@","sJX@@eKU@OH@","KAx@@YIDTjjh@vDHSBincAPp@","sOq@@drm\\@@@`","KAx@@IUkMUPAlHPfES\\","qCp@AIj`H","Hed@@DjUUjjj@FraBXUMpr","sGX@@eJuT@`","sGP@DkUj`FsDVMcCC@","HiD@@Dj}Ujj`AmHPfES\\LXrF@","KAx@@ITouUPAlHPfES]FHa`@","Hed@@DjWujjj@FraBXUMpsFIa`@","sGP@DiUj``mfHlZ","sFp@DiTvjhAlqEcP","Hid@@DjU^nBBH@FtaBXUMpq`XX@","sJP@DkVdAmQEb","qCp@AIZ`OH`","QMhDRVA@","qC`@ISJAlQE`","qCp@BOTAyhl","sJX@@eOU@ODB","sFp@DiTt@@AyaB","sGP@DkUj`FsDVMcMC@","Hid@@DjYUaBH`@FtaBXUMpqcHX@","qC`@Qz`OH@","HiD@@DjUVjj`AmHPfES\\LXZF@","sJP@H~j@[TQXqda`@","sJX@@eKU@OI@","sNp@Djejj@[\\QXu`","sJQ@@dsU@H","sJQ@@dkU@OI`","KAx@@YIMDVjh@vDHSBin@","Hid@@DjU^nBBD@FtaBXUMp`","sNp@DkgZj@[\\QXuqca`@","qC`@IRtDVqDVcEC@","Hed@@LdbRQeUUP@vTHSBinFP","sNp@DiUjj@P","qC`@IRtDT","sNp@DkYZj@[\\QXuqca`@","KAx@@IUkmUPAlHPfES]FDa`@","KAx@@IVjmUPAlHPfES]FNa`@","sOx@@drm\\@@@`","KAx@@ITjuUPAlHPfES]FBa`@","QMDARVAyH","sJP`@dfvhA@","HeT@@DjU_k``b`@[JDIaTwCLXfF@","KAx@@IToUUPAlHPfES]FJa`@","sGP@DkYj`FsDVMcEC@","qCb@AIZ`ODH","`I@`B","KAx@@IUzmUPAlHPfES]FFa`@","sNp@DkfZj@[\\QXu`","KAx@@ITnuUPAlHPfES]F@a`@","HiD@@LddURjjh@[RDIaTwB","sNp@Dj~Zj@[\\QXuqfa`@","Hed@@Dj{uZjj@FraBXUMpr","KAx@@ITsUUPAlHPfES\\","Hid@@LdbRQk``b@AmHPfES\\LXrF@","sOp@DjWkB@@GdH","sJQ@@dkU@OH@","Hid@@DjU^nBBH@FtaBXUMpqahX@","sGP@DiYj``mfHlZ","KAx@@IToUUPAlHPfES]FLa`@","qCp@AJZ`ODH","Hmt@@DjU]ZxHHj@AmhPfES\\Lj","sGP@DkUjPFsDVM@","qC`@IVtA@","Hed@@LdbJReUUP@vTHSBinFP","sNp@DjuZj@[\\QXuqea`@","KAx@@IUkmUPAlHPfES]FNa`@","HiD@@DkVUjj`AmHPfES\\H","Hed@@DkUeZjj@FraBXUMpr","sNp@DkVZj@[\\QXuqea`@","sJP@DiVhHKZbKFLLL@","HiD@@Djuyjj`AmHPfES\\H","sNp@DjUjj@[\\QXuq`a`@","HeT@@DjYUXPbH`@[JDIaTwCH","HiD@@DjwUjj`AmHPfES\\LXRF@","sNq@@djmUPB","KAx@@YIEEZjh@vDHSBincCPp@","sGP@Di^V`dmfHlZ","Hid@@DjYUaBHP@FtaBXUMp`","sNp@DjYjj@[\\QXuqba`@","sGP@Dkej`FsDVMcKC@","HeT@@DjU^k``b`@[JDIaTwCH","qC`@Qv`MbHmFBF@","sGQ@@djmT@`","qCr@XIKTAyH","qC`@IVtAlQEhpPp@","Hid@@LdbbQxXF@@AmHPfES\\LXjF@","sGP@DkYj`FsDVMcCC@","KAx@@IVsMUPAlHPfES\\","qCp@AIj`ODl","HiD@@DkeUjj`AmHPfES\\H","deT@@DjU[k``b`@vTHSBinFP","sJP@DkVdAmQEcFRF@","HiD@@LdbJTjjh@[RDIaTwCFDa`@","HiD@@DkYyjj`AmHPfES\\H","sJP@DjZhAyH","KAx@@IVkMUPAlHPfES]FDa`@","sJX@@dkU@OI@","Hed@@LdbRQUUUP@vTHSBinFXpLL@","Hed@@DjuUZjj@FraBXUMpr","sGP@Djfj`FsDVMcKC@","sNp@DkVZj@[\\QXuqba`@","sNp@DjyZj@[\\QXuqfa`@","qCb@AIj`OH@","sNp@DjUZj@[\\QXu`","KAx@@IWOMUPAlHPfES\\","Hid@@DjU^nBBH@D","Hed@@DjuvZjj@FraBXUMpr","sJP@DiVhHKZbKFLtL@","dmt@@DjU_ZxHHj@C[PaLJfxYVLKC@","sNp@DjuZj@[\\QXuqca`@","sJP@DkfhAmQEcFJF@","sNp@LdbJZj@[\\QXu`","HeT@@DjU_k``b`@[JDIaTwCLXFF@","KAx@@IVlmUPAlHPfES]FNa`@","HeT@@LdbbRKBDQD@CYPaLJfxYcEPp@","Hid@@DjUZnBBH@FtaBXUMpqcHX@","qCa@CIKTA@","HiD@@Dj~]jj`AmHPfES\\LXFF@","sKP@Di\\Zj@[TQX`","sGP@Djfj`FsDVMcEC@","HiD@@DkgYjj`AmHPfES\\H","sNp@DjuZj@[\\QXuqaa`@","KAx@@YIMDVjh@vDHSBincDPp@","sJP@DjVhHKZbKFLTL@","Hid@@LdbRQk``b@AmHPfES\\LXZF@","HiD@@Dj}Ujj`AmHPfES\\LXzF@","HeT@@DjU_k``bP@[JDIaTwCH","sNp@DkUZi@[\\QXu`","HiD@@DjYfjj`AmHPfES\\H","sGP@DjZj`FsDVMcAC@","Hmt@@DjU_jxHHj@AmhPfES\\Lj","Hid@@LdbRQk``R@AmHPfES\\H","KAx@@YIDUJjh@vDHSBincDPp@","qCr@XIKTAyD","sOq@@drm\\@@@|`@","Hed@@DjW^jjj@FraBXUMpsFBa`@","HeT@@DjY]zXFB@@[JDIaTwCH","Hkl@@DjU_Vk``bj`@[VDIaTwCJzX","Hid@@DjY}nBHH@FtaBXUMpqcHX@","sGX@@eKuT@|d@","sGP@Dj^Y`FsDVM@","HcL@@DjU_ZnBBJh@FqaBXUMprn`","sJP@DkVdAmQEcFJF@","sOq@@drm\\@@@|b@","sNp@DjyZj@[\\QXuqaa`@","HaD@@DjUZxHH@AyD@","qC`@Qv`H","dmt@@DjU_ZxHHj@C[PaLJfxYVLYC@","sGP@Dkej`FsDVMcMC@","Hed@@DjUUjjj@FraBXUMpsFHa`@","HeT@@LdbbRkBDQD@CYPaLJfxY@","KAx@@IU{MUPAlHPfES]FLa`@","RG@DTH","sJY@DDeVhA@","KAx@@YIDUJjh@vDHSBinc@Pp@","sJX@@dkU@OI`","sJQ@@dju@OI`","HeT@@LdbbRKBDQD@CYPaLJfxYcFPp@","sFp@DiTvjhAlqEcXpPp@","HaD@@DjUZxHH@AyG@","sNx@@eJ}UPB","sNp@LddUjj@[\\QXuqca`@","HaDH@@RVU[j@@@D","sNp@DkgZi@[\\QXu`","sGY@LDeVj`D","sNp@LdbJfZBZvxbqk@","sJP`@dfvhAyL","sGX@AddQjhAxe`","Hmt@@DjU_ZxHHj@AmhPfES\\LkFIa`@","qCh@CIKTA@","sNp@LdbLjj@[\\QXuq`a`@","sOq@@drm\\@@@|a@","KAx@@IUzmUPAlHPfES]FJa`@","sNx@AddQUUPB","sGP@Di]jP`mfHlZ","sJP`@TeZhA@","KAx@@IRjmUPHKXPaLJfx","HeT@@LdbRTM\\DDT@CYPaLJfxY@","HaF@@@Rfu[j@@@D","Hid@@DjYUaBH`@FtaBXUMpqchX@","KAx@@IUjmTpAlHPfES\\","Hid@@DjU^nBBD@FtaBXUMpqcHX@","sGP@DiUj``mfHl[FFF@","KAx@@IUvmUPAlHPfES]FLa`@","Hed@@LdbQTUUUP@vTHSBinFXqDL@","sJP@DkVhA@","sOx@@drm\\@@@|b@","KAx@@IUkMUPAlHPfES]FDa`@","HeT@@LdbRQU\\DDT@CYPaLJfxY@","HiD@@Dj}Yjj`AmHPfES\\LXrF@","HiD@@Dj{ujj`AmHPfES\\LXFF@","KAx@@IWNmUPAlHPfES]FFa`@","KAx@@IRkMUPHKXPaLJfx","sJP@DjYdAmQEcFZF@","sJY@LDeZhAyL","HaDH@@RVU[f@@@D","sJP`@deVhAyB","HaD@@DjWjZjj`AlHPfES\\","sGP@DkYj`FsDVMcMC@","sNp@DkgZj@[\\QXuqea`@","sJQ@@dlu@H","HeT@@DjU]k``b`@[JDIaTwCLXrF@","sJX@@dkU@OH`","RFDDQFCr`","sJP@DiYXIKZbKFLLL@","KAx@@YIHjjjh@vDHSBincGPp@","Hk\\@@DjU^ukmLHH@@@AmXPfES\\Lki`","sGQ@@djmT@|b@","Hid@@DjUfaBB`@FtaBXUMpqahX@","sNx@@eRmUPB","Hmt@@LdbRVak``ah@FvaBXUMprh","qCr@XIJtA@","KAx@@IWMmUPAlHPfES]FNa`@","HeT@@DjYYZPbJ@@[JDIaTwCH","sNp@DkfZj@[\\QXuqea`@","Hid@@DjU^nBAHAEVtaBXUMp`","dmt@@DjUgZDHJJ@C[PaLJfxYT","sGP@DkejPFsDVM@","sNx@@eJmUPB","qCb@AIf`H","HcL@@DjU_VnBBJh@FqaBXUMprnqcXX@","Hid@@DjUZnBBH@FtaBXUMpqahX@","sNp@LdbQZjBBvxbqkcGC@","sOx@@drm\\@@@|c@","sJP@H~j@^R@","KAx@@YIDcFjhDElHPfES\\","Hid@@DjUZnBAH@FtaBXUMp`","sNp@LddUji@[\\QXu`","sGP@DjfjPFsDVM@","HeT@@DjYUXPbD`@[JDIaTwCH","KAx@@IUoMUPAlHPfES]FDa`@","sFp@DiTt@@AyaD","Hed@@DjuuZjj@FraBXUMpsFIa`@","HeT@@DjUghP`h`@[JDIaTwCLXfF@","sOp@DjWkjj`FwDVM\\YhX@","sGP@Djfj`FsDVMcIC@","KAx@@IRkmUPHKXPaLJfzL]C@","sNx@@djmUPB","QM`AIdD","sOp@DjWkB@@Gbe@","sNp@DjyZj@[\\QXuqca`@","QM@HuAmd`","sNp@LddUjj@[\\QXuqea`@","daD@@DjUZxHD@CXPaLJfzLYC@","qCb@AIZPH","HiD@@LdbJTjjh@[RDIaTwCF@a`@","Hmt@@DjU_ZxHHi@AmhPfES\\Lj","HaDH@@RYWih@H@D","HiD@@LdbJTjjh@[RDIaTwCFHa`@","sGX@@djuT@|a@","sNp@DkfZj@[\\QXuqaa`@","Hid@@DjU^nBBH@GdL","KAx@@IVkMUPAlHPfES]FJa`@","qCr@XIKTAy@","HmT@@Dj{uVjjh@[ZDIaTwCJqaXX@","dmt@@DjYWVDHbJ@C[PaLJfxYT","Hif@@@RUe^Fh@@@P","HaDH@@Rfu[j@@@GdH","KAx@@IVsMUPAlHPfES]FDa`@","sKP@Di\\Zj@[TQXq`a`@","sJX@@eMU@OH@","HeT@@DjU^k``b`@[JDIaTwCLXFF@","Hmt@@LdbbRJXPbHh@FvaBXUMprh","sJP@DjvhAmQEcFBF@","dmt@@LdbbRNXPbHh@MmBDpj[aeXplL@","sJP`@dfvhAyD","sGP@Di^V`dmfHl[FVF@","KAx@@IVsmUPAlHPfES]FBa`@","sOq@@drm\\@@@|PP","sJY@BDeZhA@","HeT@@LdbRbmBDED@CYPaLJfxY@","Hed@@Djy[Zjj@FraBXUMpr","HeT@@DjU]k``b`@[JDIaTwCLXFF@","Hid@@DjUfaBB`@D","qCa@CIJtA@","QMPARVA@","Hid@@DjUfaBB`@FtaBXUMpqcHX@","sJY@BDfZhA@","HeT@@DjUghP`hP@[JDIaTwCH","Hed@@Dj{uZjj@FraBXUMpsFIa`@","dmt@@DjYUvDHbJ@C[PaLJfxYVLUC@","sNp`@dfuZj@P","sJQ@@dmU@OH@","sJX@@dmU@H","HeT@@DjU]k``b`@[JDIaTwCLXZF@","HiD@@LdfbJZjh@[RDIaTwCFAa`@","sOx@@drm\\@@@|a@","deT@@DjUfhP`h`@vTHSBinFP","dmt@@DjU]ZxHHj@C[PaLJfxYVLKC@","sOp@DjWkjj`FwDVM\\XHX@","HcL@@LdbbRNSBDQEP@McBDpj[ae]cFpp@","HiD@@Dj}Yji`AmHPfES\\H","HaDH@@RYe[hB@@D","Hid@@DjU^njjj@FtaBXUMpq`XX@","deT@@LdbbRKBDQB@FraBXUMpr","QMPARZA@","sOq@@drm\\@@@|QX","HaD@@DjYvxH`@A@","HcL@@LdbbRNcBDQEP@McBDpj[ae]@","QMhDRZA@","RG@DXLHmP","QM`BN`XQYd","RG@DTLHmP","QMHAIXFEVd","QMDARVAaH","RFPDXLHmP","RF@Q`vRbdLEC@","RF@QpvR@","QO@HyjAmd`","`II@B","`II@CFspqJp","`II@CF[@hM@prB`","`H@[T[|B`XN@PdM@p|@bHrBcDk@","RG@DXMj}F@","QM`BN`[L~b@","RG@DTMj}D@","QMHAIXFt~j@","QMDARVA}L@","RFPDXMj}D@","sKP@Di\\YZ@[TQXqaa`@","eF`BHD"])},xl.Ns=function(n,t){var e,i;if(!t)return null;for(i=vf(yl.tlb,z,6,(xl.Ks.length+31)/32|0,15,1),t=xl.Ss(t),xl.zs(n.e,t),e=0;e<xl.Ks.length;e++)xl.xs(n.e,xl.Ls[e]),xl.ls(n.e,1,4)>0&&(i[e/32|0]|=1<<31-e%32);return i},xl.Os=function(n,t){var e,i;if(!t)return null;for(i=vf(yl.ulb,st,6,(xl.Ks.length+63)/64|0,14,1),t=xl.Ss(t),xl.zs(n.e,t),e=0;e<xl.Ks.length;e++)xl.xs(n.e,xl.Ls[e]),xl.ls(n.e,1,4)>0&&(i[e/64|0]=Eg(i[e/64|0],xg(1,63-e%64)));return i},xl.Ps=function(){var n,t;if(null==xl.Ls)for(t=new xl.Hp(!1),xl.Ls=vf(yl.nmb,ae,24,xl.Ks.length,0,1),n=0;n<xl.Ks.length;n++)xl.Ls[n]=xl.up(t,xl.Ks[n]),xl.iu(xl.Ls[n],1)},xl.Qs=function(n){var t;if(null==n.d)return!1;for(t=0;t<n.d.length;t++)if(0!=(n.b[t]&~n.d[t]))return!1;return xl.Rs(n)},xl.Rs=function(n){return!n.c&&(n.c=(new xl.Hp(!1),null)),!n.a&&(n.a=(new xl.Hp(!1),null)),xl.zs(n.e,n.c),xl.xs(n.e,n.a),xl.ss(n.e)},xl.Ss=function(n){var t,e;if(n.K)for(t=0;t<n.q;t++)if(Rg(Cg(n.B[t],tn),0)){for(n=new xl.Cu(n),e=t;e<n.q;e++)Rg(Cg(n.B[e],tn),0)&&(n.C[e]=-1);xl.lk(n)}return n},xl.Ts=function(n,t,e){n.a=t,n.b=null==e?xl.Ns(n,t):e},xl.Us=function(n,t,e){n.c=t,n.d=null==e?xl.Ns(n,t):e},xl.Vs=function(){xl.Ms(),this.e=new xl.Fs,xl.Ps()},xl.Ws=function(n){var t,e,i,s,r,a;if(xl.Ms(),null==n)return null;for(t=vf(yl.plb,ft,6,8*n.length,15,1),i=0;i<n.length;i++)for(a=n[i],s=7;s>=0;s--)(e=15&a)>9&&(e+=7),t[8*i+s]=48+e<<24>>24,a>>=4;return Jl.IHb((r=t,yf.XKb(),r))},xl.Xs=function(n){var t,e,i,s;if(xl.Ms(),0==kl.TTb(n).length||0!=(7&kl.TTb(n).length))return null;for(i=vf(yl.tlb,z,6,kl.TTb(n).length/8|0,15,1),e=0;e<kl.TTb(n).length;e++)s=e/8|0,kl.OTb(e,kl.TTb(n).length),(t=kl.TTb(n).charCodeAt(e)-48)>16&&(t-=7),i[s]<<=4,i[s]+=t;return i},xl.Ys=function(t,e){var i,s,r,a;for(xl.Ms(),a=0,s=0,r=0,i=0;i<t.length;i++)a+=nu(t[i]&e[i]),s+=nu(t[i]),r+=nu(e[i]);return a/n.Math.sqrt(s*r)},xl.Zs=function(n,t){var e,i,s;for(xl.Ms(),s=0,e=0,i=0;i<n.length;i++)s+=nu(n[i]&t[i]),e+=nu(n[i]|t[i]);return s/e},zf(197,1,{},xl.Vs),yl.cmb=lg(197),xl._s=function(n){n.j=1,n.k=10,n.n=400,n.f=400,n.i=!0,n.d="black",n.b=new Fl.cj,n.a=new Fl.cj,n.c=new Jl.qIb,n.e=new Nf.BEb(12)},xl.at=function(n,t){var e;return(e=Nf.zEb(n.e,t),new wf.VEb(e)).b},xl.bt=function(n){return n.k},xl.ct=function(n){var t,e,i,s,r;if(r='<svg id="'+(null!=n.g?n.g:"mol"+xl.$s)+'" xmlns="http://www.w3.org/2000/svg" version="1.1" width="'+n.n+'px" height="'+n.f+'px" viewBox="0 0 '+n.n+" "+n.f+'">\n',r+="  ",r+=n.i?"<style> #"+(null!=n.g?n.g:"mol"+xl.$s)+" { pointer-events:none; } #"+(null!=n.g?n.g:"mol"+xl.$s)+" .event  { pointer-events:all; } line { stroke-linecap:round; } polygon { stroke-linejoin:round; } </style>\n":'<g style="font-size:'+n.k+'px; fill-opacity:1; stroke-opacity:1; fill:black; stroke:black; font-weight:normal; text-rendering:optimizeLegibility; font-family:sans-serif; stroke-linejoin:round; stroke-linecap:round; stroke-dashoffset:0;">',n.i){for(s=new Fl.zOb(n.b);s.a<s.c.a.length;)i=Fl.yOb(s),xl.dt(n,i);for(e=new Fl.zOb(n.a);e.a<e.c.a.length;)t=Fl.yOb(e),xl.dt(n,t)}return n.i||xl.dt(n,"</g>"),r+n.c.a+"</svg>"},xl.dt=function(n,t){Jl.nIb(n.c,"  "),Jl.nIb(n.c,t),Jl.nIb(n.c,H)},xl.et=function(n,t,e){xl.Qc(),xl.Td.call(this,n,t),xl._s(this),this.g=e,++xl.$s},xl.ft=function(n){xl.Qc(),xl.et.call(this,n,0,null)},zf(195,144,{144:1},xl.et,xl.ft),o.mb=function(n){var t;t='<line x1="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(n.a),(Uf.OKb(),Uf.KKb))))+'" y1="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(n.c),Uf.KKb)))+'" x2="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(n.b),Uf.KKb)))+'" y2="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(n.d),Uf.KKb)))+oe+le+this.d+oe+fe+this.j+ge,xl.dt(this,t)},o.nb=function(n){var t,e;e='<line stroke-dasharray="'+(t=Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(3*this.j),(Uf.OKb(),Uf.KKb)))))+","+t+'" x1="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(n.a),Uf.KKb)))+'" y1="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(n.c),Uf.KKb)))+'" x2="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(n.b),Uf.KKb)))+'" y2="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(n.d),Uf.KKb)))+oe+le+this.d+'" stroke-width:'+this.j+ge,xl.dt(this,e)},o.ob=function(t){var e,i;for(i=new Jl.sIb('<polygon points="'),e=0;e<t.a;e++)Jl.lIb(i,Pg(n.Math.round(t.b[e]))),i.a+=",",Jl.lIb(i,Pg(n.Math.round(t.c[e]))),i.a+=" ";Jl.nIb(i,'" fill="'+this.d+oe+le+this.d+oe+fe+this.j+ge),xl.dt(this,i.a)},o.pb=function(n,t,e){var i,s,r;s=(r=Nf.zEb(this.e,n),new wf.VEb(r)).b,i='<text x="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(t-s/2),(Uf.OKb(),Uf.KKb))))+'" y="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(e+this.k/3),Uf.KKb)))+'" stroke="none" font-size="'+this.e.b+'" fill="'+this.d+'">'+n+"</text>",xl.dt(this,i)},o.qb=function(n,t,e){var i;i='<circle cx="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(n+e/2),(Uf.OKb(),Uf.KKb))))+'" cy="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(t+e/2),Uf.KKb)))+'" r="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(e/2),Uf.KKb)))+'" fill="'+this.d+ge,xl.dt(this,i)},o.rb=function(n){return xl.at(this,n)},o.sb=function(){return xl.bt(this)},o.tb=function(n,t,e,i){var s,r;s=xl.Ak(this.L,n),r='<circle id="'+(null!=this.g?this.g:"mol"+xl.$s)+":Atom:"+n+oe+ue+(0==s?"":'data-atom-map-no="'+s+oe)+'cx="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(e),(Uf.OKb(),Uf.KKb))))+'" cy="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(i),Uf.KKb)))+'" r="8'+oe+he,Fl.Ki(this.a,r)},o.ub=function(n,t,e,i,s){var r;r='<line id="'+(null!=this.g?this.g:"mol"+xl.$s)+":Bond:"+n+oe+ue+'x1="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(t),(Uf.OKb(),Uf.KKb))))+'" y1="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(e),Uf.KKb)))+'" x2="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(i),Uf.KKb)))+'" y2="'+Jl.tGb(Uf.PIb(Uf.MIb(new Uf.QIb(s),Uf.KKb)))+oe+fe+8+oe+he,Fl.Ki(this.b,r)},o.wb=function(t){this.j=Sg(Pg(n.Math.round(100*n.Math.max(t,1))))/100},o.xb=function(n){this.d="rgb("+((n&de)>>16)+","+((n&q)>>8)+","+(255&n)+")"},o.yb=function(n){this.k!=n&&(this.k=n,this.e=new Nf.BEb(n))},o.zb=function(t,e){return this.n=zg(Pg(n.Math.round(t.b))),this.f=zg(Pg(n.Math.round(t.a))),xl.Pd(this,t,e)},o.lb=function(){return xl.ct(this)},o.f=0,o.i=!1,o.j=0,o.k=0,o.n=0,xl.$s=0,yl.emb=lg(195),xl.ut=function(n,t){var e;if(null!=n.c)for(e=0;e<n.c.length;e++)if(t==n.c[e]&&n.d[e])return!0;return!1},xl.vt=function(n,t,e,i,s){this.a=n,this.b=t,this.g=e,this.f=i,this.e=s},zf(211,1,{211:1},xl.vt),o.a=0,o.b=0,o.e=!1,o.f=!1,o.g=0,yl.fmb=lg(211),xl.wt=function(n,t){var e,i,s,r;for(r=!1,n.b=t,xl.iu(n.b,15),e=n.b.f,i=n.b.g,n.j=vf(yl.Lwb,nn,6,i,16,1),s=0;s<i;++s)n.j[s]=!1;for(n.g=vf(yl.Lwb,nn,6,e,16,1),n.c=vf(yl.tlb,z,6,e,15,1),s=0;s<e;++s)n.g[s]=!1,n.c[s]=-1;for(n.e=vf(yl.Xub,y,2,3*e,6,1),n.i=0,n.d=0,n.a=0;!r;){for(s=0;s<e;++s)if(!n.g[s]){n.a>0&&(n.e[n.i++]="."),xl.yt(n,s,-1),++n.a;break}s==e&&(r=!0)}for(n.f="",s=0;s<n.i;++s)n.f+=""+n.e[s];return n.f},xl.xt=function(n){switch(n){case 5:case 6:case 7:case 8:case 9:case 15:case 16:case 17:case 35:case 53:return!0;default:return!1}},xl.yt=function(t,e,i){var s,r,a,o,l,f,g,u,h,d,c,b,D;if(s=!0,f=0,D=0,d=t.i,t.c[e]=d,l=xl.Ik(t.b,e),o=xl.xk(t.b,e),r=xl.rk(t.b,e),a=xl.Bk(t.b,e),u=xl.Ln(t.b,e),0==r&&0==a&&xl.xt(l)&&(s=!1),t.e[d]="",-1!=i)switch(xl.Vk(t.b,i)){case 0:t.e[d]+="~";break;case 2:t.e[d]+="=";break;case 3:t.e[d]+="#"}for(s&&(t.e[d]+="["),0!=a&&(t.e[d]+=""+a),t.e[d]+=""+o,s&&0<(b=xl.$n(t.b,e))&&(t.e[d]+="H",1<b&&(t.e[d]+=b)),0!=r&&(t.e[d]+=r>0?"+":"-",n.Math.abs(r)>1&&(t.e[d]+=""+n.Math.abs(r))),s&&(t.e[d]+="]"),-1!=i&&(t.j[i]=!0),t.g[e]=!0,++t.i,c=0;c<u;++c)t.j[xl.Mn(t.b,e,c)]||++f;for(c=0;c<u;++c)if(g=xl.Kn(t.b,e,c),h=xl.Mn(t.b,e,c),t.j[h])++D;else if(t.g[g]){switch(++t.d,t.j[h]=!0,xl.Vk(t.b,h)){case 0:t.e[t.c[g]]+="~",t.e[d]+="~";break;case 2:t.e[t.c[g]]+="=",t.e[d]+="=";break;case 3:t.e[t.c[g]]+="#",t.e[d]+="3"}t.d>9&&(t.e[t.c[g]]+="%",t.e[d]+="%"),t.e[t.c[g]]+=""+t.d,t.e[d]+=""+t.d}else c-D<f-1&&(t.e[t.i++]="("),xl.yt(t,g,h),c-D<f-1&&(t.e[t.i++]=")")},xl.zt=function(){},zf(328,1,{},xl.zt),o.a=0,o.d=0,o.i=0,yl.gmb=lg(328),xl.At=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c;for(f=vf(yl.tlb,z,6,n.i.f,15,1),o=vf(yl.tlb,z,6,n.i.f,15,1),l=vf(yl.tlb,z,6,n.i.f,15,1),g=vf(yl.tlb,z,6,n.i.f,15,1),e=xl.Nk(n.i,0,t),i=xl.Nk(n.i,1,t),o[0]=e,o[1]=i,l[0]=-1,l[1]=t,f[e]=1,f[i]=2,g[e]=-1,g[i]=e,a=1,u=1;a<=u&&f[o[a]]<15;){for(c=o[a],h=0;h<xl.Ln(n.i,c);h++)if((s=xl.Kn(n.i,c,h))!=g[c]){if(r=xl.Mn(n.i,c,h),s==e){for(l[0]=r,d=0;d<=u;d++)n.f[l[h]]||(n.f[l[h]]=!0,++n.c);return}xl.xl(n.i,s)&&0==f[s]&&(o[++u]=s,l[u]=r,f[s]=f[c]+1,g[s]=c)}++a}},xl.Bt=function(n){var t,e,i,s,r,a,o,l,f,g,u,h,d;for(xl.iu(n.i,7),u=!1,h=vf(yl.tlb,z,6,2,15,1),d=vf(yl.tlb,z,6,2,15,1),g=vf(yl.tlb,z,6,2,15,1),i=0;i<n.i.g;i++)if(!xl.To(n.i,i)&&2==xl.Yk(n.i,i)){for(a=0;a<2;a++){for(h[a]=-1,g[a]=-1,t=xl.Nk(n.i,a,i),f=0;f<xl.Ln(n.i,t);f++)(s=xl.Mn(n.i,t,f))!=i&&(-1!=h[a]||257!=xl.Yk(n.i,s)&&129!=xl.Yk(n.i,s)?g[a]=xl.Kn(n.i,t,f):(h[a]=xl.Kn(n.i,t,f),d[a]=s));if(-1==h[a])break}if(-1!=h[0]&&-1!=h[1]){for(l=xl.Yk(n.i,d[0])==xl.Yk(n.i,d[1]),o=0;o<2;o++)h[o]==xl.Nk(n.i,0,d[o])&&(l=!l);for(r=0;r<2;r++)-1!=g[r]&&g[r]<h[r]&&(l=!l);xl.vm(n.i,i,l?2:1,!1),u=!0}}for(e=0;e<n.i.g;e++)(257==xl.Yk(n.i,e)||129==xl.Yk(n.i,e))&&xl.ym(n.i,e,1);return u},xl.Ct=function(n){return 61==n?2:35==n?4:36==n?32:58==n?8:62==n?16:126==n?31:1},xl.Dt=function(n,t){var e,i,s,r,a,o,l,f,g,u,h;for(e=0;e<n.i.f;e++)if(xl.xl(n.i,e))for(l=vf(yl.tlb,z,6,n.i.f,15,1),o=vf(yl.tlb,z,6,n.i.f,15,1),f=vf(yl.tlb,z,6,n.i.f,15,1),o[0]=e,l[e]=1,f[e]=-1,a=0,g=0;a<=g;){for(s=1==(1&l[o[a]])?1:2,u=0;u<xl.Ln(n.i,o[a]);u++)if(i=xl.Mn(n.i,o[a],u),xl.Vk(n.i,i)==s&&t[i]&&0==l[r=xl.Kn(n.i,o[a],u)]){if(1==s&&xl.xl(n.i,r)){for(h=o[a];-1!=h;)xl.ym(n.i,xl.In(n.i,r,h),1==s?2:1),s=3-s,r=h,h=f[h];return xl.em(n.i,e,!1),xl.em(n.i,r,!1),n.b-=2,!0}o[++g]=r,f[r]=o[a],l[r]=l[o[a]]+1}++a}return!1},xl.Et=function(n){var t,e,i,s;for(t=0;t<n.i.f;t++)if(7==xl.Ik(n.i,t)&&0==xl.rk(n.i,t)&&xl.fo(n.i,t)>3&&xl.Bn(n.i,t)>0)for(s=0;s<xl.Ln(n.i,t);s++)if(e=xl.Kn(n.i,t,s),i=xl.Mn(n.i,t,s),xl.Vk(n.i,i)>1&&xl.vl(n.i,e)){4==xl.Yk(n.i,i)?xl.ym(n.i,i,2):xl.ym(n.i,i,1),xl.Xl(n.i,t,xl.rk(n.i,t)+1),xl.Xl(n.i,e,xl.rk(n.i,e)-1),xl.Vl(n.i,t,-1);break}},xl.Ft=function(n,t,e,i){var s;if(i.d=!0,i.c=!0,35==n[t]){for(++t,i.a=0,i.b=1;t<e&&Og(n[t]&B);)i.a=10*i.a+n[t]-48,++i.b,++t;if(0==i.a||i.a>=(xl.Kj(),xl.Ej).length)throw og(new Jl.Xz("SmilesParser: Atomic number out of range."))}else if(n[t]>=65&&n[t]<=90)i.b=n[t+1]>=97&&n[t+1]<=122?2:1,i.a=(xl.Kj(),xl.an(Jl.bIb(kl.sTb(n,t,(s=i.b,yf.XKb(),s))),321)),i.d=!1;else{if(!(n[t]>=97&&n[t]<=122))throw og(new Jl.Xz("SmilesParser: Unexpected character within brackets:'"+String.fromCharCode(n[t]&B)+"'"));i.b=n[t+1]>=97&&n[t+1]<=122?2:1,i.a=(xl.Kj(),xl.an(Jl.bIb(kl.sTb(n,t,(s=i.b,yf.XKb(),s))),321)),i.c=!1}},xl.Gt=function(n){return n.n?"Unresolved SMARTS features:"+n.n:""},xl.Ht=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,I,P,M,N,w,L,U,y,J;for(xl.iu(n.i,1),n.f=vf(yl.Lwb,nn,6,n.i.g,16,1),n.c=0,g=0;g<n.i.g;g++)64==xl.Yk(n.i,g)&&(xl.ym(n.i,g,1),n.f[g]=!0,++n.c);for(T=vf(yl.Lwb,nn,6,n.i.f,16,1),J=new xl._r(n.i,3),C=vf(yl.Lwb,nn,6,J.i.a.length,16,1),w=0;w<J.i.a.length;w++){for(U=Fl.Pi(J.i,w),C[w]=!0,D=0;D<U.length;D++)if(!xl.xl(n.i,U[D])){C[w]=!1;break}if(C[w]){for(H=0;H<U.length;H++)T[U[H]]=!0;for(y=Fl.Pi(J.j,w),j=0;j<y.length;j++)n.f[y[j]]||(n.f[y[j]]=!0,++n.c)}}for(u=0;u<n.i.g;u++)!n.f[u]&&0!=(J.b[u]&B)&&xl.xl(n.i,xl.Nk(n.i,0,u))&&xl.xl(n.i,xl.Nk(n.i,1,u))&&xl.At(n,u);for(h=0;h<n.i.g;h++)n.f[h]||(s=xl.Nk(n.i,0,h),r=xl.Nk(n.i,1,h),!T[s]&&!T[r]&&xl.xl(n.i,s)&&xl.xl(n.i,r)&&(n.f[h]=!0,++n.c));for(xl.iu(n.i,7),A=vf(yl.Lwb,nn,6,n.i.g,16,1),m=0;m<n.i.g;m++)A[m]=n.f[m];for(L=0;L<J.i.a.length;L++)if(C[L])for(U=Fl.Pi(J.i,L),b=0;b<U.length;b++)if(!xl.Ot(n,U[b]))for(xl.xl(n.i,U[b])&&(xl.em(n.i,U[b],!1),--n.b),I=0;I<xl.Ln(n.i,U[b]);I++)c=xl.Mn(n.i,U[b],I),n.f[c]&&(n.f[c]=!1,--n.c);for(xl.Nt(n),N=0;N<J.i.a.length;N++)if(C[N]&&6==Fl.Pi(J.j,N).length){for(p=!0,l=0,f=(o=y=Fl.Pi(J.j,N)).length;l<f;++l)if(a=o[l],!n.f[a]){p=!1;break}p&&(xl.Mt(n,y[0]),xl.Mt(n,y[2]),xl.Mt(n,y[4]),xl.Nt(n))}for(M=5;M>=4;M--)do{for(P=!1,a=0;a<n.i.g;a++)if(n.f[a]){for(e=0,b=0;b<2;b++)for(d=xl.Nk(n.i,b,a),I=0;I<xl.Ln(n.i,d);I++)n.f[xl.Mn(n.i,d,I)]&&++e;if(e==M){xl.Mt(n,a),xl.Nt(n),P=!0;break}}}while(P);for(;n.b>=2&&xl.Dt(n,A););if(t){if(0!=n.b)for(i=0;i<n.i.f;i++)xl.xl(n.i,i)&&(xl.em(n.i,i,!1),xl.hm(n.i,i,2,!0),--n.b);if(0!=n.c)for(a=0;a<n.i.g;a++)n.f[a]&&(n.f[a]=!1,xl.ym(n.i,a,64),--n.c)}else for(i=0;i<n.i.f;i++)xl.xl(n.i,i)&&0!=xl.$n(n.i,i)&&(xl.em(n.i,i,!1),xl.im(n.i,i,32),--n.b);if(0!=n.b)throw og(new Jl.Xz(ce));if(0!=n.c)throw og(new Jl.Xz(ce))},xl.It=function(t,e,i,s,r,a,o){var l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,I,P,M,N,w,L,U,y,R,k,E,x,F,Q,X,S,G,q,Y,v,Z,V,O,K,W,_,$,nn,tn,en,sn,rn,an,on,fn,gn,un,hn,bn,Hn,jn,Cn,Tn,pn,In,Mn,Nn;for(t.i=e,xl._j(t.i),t.n&&Jl.hFb(t.n,0),t.b=0,f=0!=t.k,nn=null,(H=vf(yl.tlb,z,6,32,15,1))[0]=-1,an=vf(yl.tlb,z,6,16,15,1),gn=vf(yl.tlb,z,6,16,15,1),fn=vf(yl.tlb,z,6,16,15,1),on=vf(yl.tlb,z,6,16,15,1),x=0;x<16;x++)an[x]=-1;for(c=0,U=-1,bn=!1,X=!1,hn=!1,T=0,A=1,m=0,d=new gf.N6,tn=new xl.au(i),h=new xl.Tt;i[s]<=32;)++s;for(;s<r;)if(Kg(jn=i[s++]&B)||42==jn||63==jn||33==jn&&f&&bn||35==jn&&f&&bn){if(D=-1,I=0,q=0,l=-1,w=-1,$=!1,Q=!1,b=0,bn){if(42==jn)D=6,b=zg(Eg(yl.$wb(b),1));else if(63==jn)D=0;else if((S=33==jn)&&(hn=!0,b=zg(Eg(yl.$wb(b),1)),++s),82==i[s-1]&&f&&(Og(i[s]&B)||t.a&&123==i[s]))D=6,b=zg(Eg(yl.$wb(b),1)),--s,S&&--s;else if(xl.Ft(i,s-1,r,h),D=h.a,s+=h.b-1,w=9,f&&(44==i[s]||S)){for(v=h.d,Y=h.c,Hn=s-h.b;Hn<r&&(xl.Ft(i,Hn,r,h),gf.I6(d,Jl._Gb(h.a)),v|=h.d,Y|=h.c,44==i[Hn+=h.b]);)if(33==i[++Hn]){if(!S)throw og(new Jl.Xz("SmilesParser: inconsistent '!' in atom list."));++Hn}d.d.a.length>1&&(w=-1,Y?v||(b=zg(Eg(yl.$wb(b),4))):b=zg(Eg(yl.$wb(b),2))),s=Hn}for(;bn;)if(64!=i[s])if(58!=i[s]){if(91==i[s])throw og(new Jl.Xz("SmilesParser: nested square brackets found"));if(93!=i[s])if(43!=i[s])if(45!=i[s])if((S=33==i[s])&&++s,72!=i[s])if(68!=i[s])if(122==i[s]&&t.a)++s,s+=xl.Zt(tn,i,s,4),L=0,tn.c<=0&&tn.b>=0&&(L=Eg(L,kn)),tn.c<=1&&tn.b>=1&&(L=Eg(L,be)),tn.c<=2&&tn.b>=2&&(L=Eg(L,De)),tn.c<=3&&tn.b>=3&&(L=Eg(L,He)),tn.c<=4&&tn.b>=4&&(L=Eg(L,Rn)),0!=Tg(L,0)&&(S||(L=qg(L,Ln)),b=zg(Eg(yl.$wb(b),L)));else if(88!=i[s])if(65!=i[s]&&97!=i[s])if(82!=i[s])if(114!=i[s])if(118!=i[s]){if(!f||59!=i[s]&&38!=i[s])throw og(new Jl.Xz("SmilesParser: unexpected character inside brackets: '"+String.fromCharCode(i[s]&B)+"'"));hn=!0,++s}else++s,s+=xl.Zt(tn,i,s,1),Tn=tn.c,tn.b>tn.c&&xl.Qt(t,(S?"!v":"v")+"{"+tn.c+"-"+tn.b+"}"),!S&&Tn<=14?l=Tn:tn.b>tn.c||xl.Qt(t,(S?"!v":"v")+Tn);else{if(++s,s+=xl.Zt(tn,i,s,1),tn.a){b=zg(Eg(yl.$wb(b),S?384:8));continue}un=tn.c,tn.b>tn.c&&xl.Qt(t,(S?"!r":"r")+"{"+tn.c+"-"+tn.b+"}"),!S&&un>=3&&un<=7?b|=un<<22:tn.b>tn.c||xl.Qt(t,(S?"!r":"r")+un)}else++s,s+=xl.Zt(tn,i,s,3),L=0,tn.c<=0&&tn.b>=0&&(L=Eg(L,8)),tn.c<=1&&tn.b>=1&&(L=Eg(L,16)),tn.c<=2&&tn.b>=2&&(L=Eg(L,32)),tn.c<=3&&tn.b>=3&&(L=Eg(L,64)),tn.b>3&&xl.Qt(t,(S?"!R":"R")+tn.b),0!=Tg(L,0)&&(S||(L=qg(L,120)),b=zg(Eg(yl.$wb(b),L)));else++s,b=zg(Eg(yl.$wb(b),S^65==i[s]?4:2));else{if(++s,s+=xl.Zt(tn,i,s,1),null==(Nn=(xl.Kj(),xl.Fj)[D]))continue;L=0,(Tn=Nn[0])-tn.c<=0&&Tn-tn.b>=0&&(L=Eg(L,ln)),Tn-tn.c<=1&&Tn-tn.b>=1&&(L=Eg(L,Lt)),Tn-tn.c<=2&&Tn-tn.b>=2&&(L=Eg(L,J)),0!=Tg(L,0)&&(S||(L=qg(L,mn)),b=zg(Eg(yl.$wb(b),L)))}else++s,s+=xl.Zt(tn,i,s,1),L=0,tn.c<=0&&tn.b>=0&&(L=Eg(L,gt)),tn.c<=1&&tn.b>=1&&(L=Eg(L,Wn)),tn.c<=2&&tn.b>=2&&(L=Eg(L,Kn)),tn.c<=3&&tn.b>=3&&(L=Eg(L,dt)),tn.c<=4&&tn.b>=4&&(L=Eg(L,Pn)),0!=Tg(L,0)&&(S||(L=qg(L,An)),b=zg(Eg(yl.$wb(b),L)));else++s,s+=xl.Zt(tn,i,s,1),w=tn.c,L=0,tn.c<=0&&tn.b>=0&&(L=zg(Eg(yl.$wb(L),128))),tn.c<=1&&tn.b>=1&&(L=zg(Eg(yl.$wb(L),256))),tn.c<=2&&tn.b>=2&&(L=zg(Eg(yl.$wb(L),512))),tn.c<=3&&tn.b>=3&&(L=zg(Eg(yl.$wb(L),cn))),S?(b|=L,w=-1):tn.b==tn.c?w=tn.c:(b=zg(Eg(yl.$wb(b),Cg(dn,yl.$wb(~L)))),w=-1);else{for(I=-1,++s;45==i[s];)--I,++s;-1==I&&Og(i[s]&B)&&(I=48-i[s],++s),0==I&&(b=zg(Eg(yl.$wb(b),Dn)))}else{for(I=1,++s;43==i[s];)++I,++s;1==I&&Og(i[s]&B)&&(I=i[s]-48,++s),0==I&&(b=zg(Eg(yl.$wb(b),Dn)))}else++s,bn=!1}else for(++s;Og(i[s]&B);)q=10*q+i[s]-48,++s;else 64==i[++s]&&(Q=!0,++s),$=!0}else if(42==jn)D=6,b=zg(Eg(yl.$wb(b),1));else if(63==jn)D=0;else if(65!=jn&&97!=jn||!f)switch(String.fromCharCode(jn).toUpperCase().charCodeAt(0)){case 66:s<r&&114==i[s]?(D=35,++s):D=5;break;case 67:s<r&&108==i[s]?(D=17,++s):D=6;break;case 70:D=9;break;case 73:D=53;break;case 78:D=7;break;case 79:D=8;break;case 80:D=15;break;case 83:D=16}else D=6,b=zg(Eg(yl.$wb(b),1)),b=zg(Eg(yl.$wb(b),65==jn?4:2)),hn=!0;if(-1==D&&63!=jn)throw og(new Jl.Xz("SmilesParser: unknown element label found"));if(u=xl.Mj(t.i,D),xl.Xl(t.i,u,I),xl.dm(t.i,u,q,!1),xl.Vl(t.i,u,l),0!=b&&(hn=!0,Rg(Cg(yl.$wb(b),2),0)?(b=zg(Cg(yl.$wb(b),-3)),xl.em(t.i,u,!0),++t.b):xl.em(t.i,u,!1),xl.hm(t.i,u,yl.$wb(b),!0)),0!=d.d.a.length){for(hn=!0,G=vf(yl.tlb,z,6,d.d.a.length,15,1),E=0;E<d.d.a.length;E++)G[E]=(E<0?null:Fl.Pi(d.d,E)).a;xl.bm(t.i,u,G),kl.mTb(d.d.a,0)}else if(String.fromCharCode(jn).toLowerCase().charCodeAt(0)==jn&&Kg(jn)){if(5!=D&&6!=D&&7!=D&&8!=D&&15!=D&&16!=D&&33!=D&&34!=D)throw og(new Jl.Xz("SmilesParser: atomicNo "+D+" must not be aromatic"));xl.em(t.i,u,!0),++t.b}else xl.em(t.i,u,!1);-1!=w&&1!=D&&((p=vf(yl.plb,ft,6,1,15,1))[0]=(9==w?0:w)<<24>>24,xl._l(t.i,u,p)),U=H[T],-1!=H[T]&&512!=A&&(j=xl.Oj(t.i,H[T],u,A),0!=m&&(hn=!0,xl.xm(t.i,j,m,!0))),A=1,m=0,H[T]=u,0!=c&&(xl.fm(t.i,u,c),c=0),o&&((W=nn?Fl.tNb(nn,Jl._Gb(U)):null)&&xl.Vt(W,u,s),$&&(!nn&&(nn=new Fl.wRb),k=9==w?0:w,Fl.oRb(nn,Jl._Gb(u),new xl.Yt(u,s-2,U,k,Q))))}else if(46!=jn)if(45!=jn&&61!=jn&&35!=jn&&36!=jn&&58!=jn&&47!=jn&&92!=jn&&60!=jn&&126!=jn&&33!=jn&&64!=jn)if(jn<=32)s=r;else if(Og(jn))if(V=jn-48,bn){for(;s<r&&Og(i[s]&B);)V=10*V+i[s]-48,++s;c=V}else{if(R=45==i[C=X?s-3:s-2]||47==i[C]||92==i[C]||61==i[C]||35==i[C]||36==i[C]||58==i[C]||62==i[C]||126==i[C],X&&s<r&&Og(i[s]&B)&&(V=10*V+i[s]-48,X=!1,++s),V>=an.length){if(V>=100)throw og(new Jl.Xz("SmilesParser: ringClosureAtom number out of range"));for(O=an.length,Z=an.length;Z<=V;)Z=n.Math.min(100,Z+16);for(kl.ETb(Z),an=Fl.HOb(an,vf(yl.tlb,z,6,Z,15,1),Z),kl.ETb(Z),gn=Fl.HOb(gn,vf(yl.tlb,z,6,Z,15,1),Z),kl.ETb(Z),fn=Fl.HOb(fn,vf(yl.tlb,z,6,Z,15,1),Z),kl.ETb(Z),on=Fl.HOb(on,vf(yl.tlb,z,6,Z,15,1),Z),E=O;E<Z;E++)an[E]=-1}if(-1==an[V])an[V]=H[T],gn[V]=s-1,fn[V]=R?A:-1,on[V]=R?m:0;else{if(an[V]==H[T])throw og(new Jl.Xz("SmilesParser: ring closure to same atom"));o&&nn&&((W=Fl.tNb(nn,Jl._Gb(an[V])))&&xl.Vt(W,H[T],gn[V]),(W=Fl.tNb(nn,Jl._Gb(H[T])))&&xl.Vt(W,an[V],s-1)),-1!=fn[V]?A=fn[V]:257==A?A=129:129==A&&(A=257),j=xl.Oj(t.i,an[V],H[T],A),0!=on[V]&&(m=on[V]),0!=m&&(hn=!0,xl.xm(t.i,j,on[V],!0)),an[V]=-1}A=1,m=0}else{if(43==jn)throw og(new Jl.Xz("SmilesParser: '+' found outside brackets"));if(40!=jn)if(41!=jn)if(91!=jn){if(93==jn)throw og(new Jl.Xz("SmilesParser: closing bracket at unexpected position"));if(37!=jn)throw og(new Jl.Xz("SmilesParser: unexpected character outside brackets: '"+String.fromCharCode(jn)+"'"));X=!0}else bn=!0;else--T;else{if(-1==H[T])throw og(new Jl.Xz("Smiles with leading parenthesis are not supported"));++T,H.length==T&&(H=Fl.FOb(H,H.length+32)),H[T]=H[T-1]}}else{if(bn)throw og(new Jl.Xz("SmilesParser: unexpected bond symbol inside square brackets: '"+String.fromCharCode(jn)+"'"));for(M=0;45==jn||61==jn||35==jn||36==jn||58==jn||47==jn||92==jn||60==jn||126==jn||33==jn||64==jn;){if(33==jn)if(64==(jn=i[s++]&B)&&(m|=128),45==jn&&62==i[s]||60==jn&&45==i[s])M|=32,++s;else if(45==jn)M|=1;else if(61==jn)M|=2;else if(35==jn)M|=4;else if(36==jn)M|=32;else{if(58!=jn)throw og(new Jl.Xz("SmilesParser: bond symbol '"+String.fromCharCode(jn)+"' not allowed after '!'."));M|=8}else if(64==jn?m|=256:61==jn?A=2:35==jn?A=4:36==jn?A=8:58==jn?A=64:126==jn?m|=31:47==jn?o&&(A=257):92==jn?o&&(A=129):(45==jn&&62==i[s]||60==jn&&45==i[s])&&(A=32,++s),44==i[s])for(m|=61==(32==A?62:jn)?2:35==(32==A?62:jn)?4:36==(32==A?62:jn)?32:58==(32==A?62:jn)?8:62==(32==A?62:jn)?16:126==(32==A?62:jn)?31:1;44==i[s];)60==i[s+1]&&45==i[s+2]||45==i[s+1]&&62==i[s+2]?(m|=16,s+=3):(m|=xl.Ct(i[s+1]&B),s+=2);if(59!=i[s]){0!=M&&(m|=31&~M);break}++s,jn=i[s++]&B}}else H[T]=-1,A=512;if(1!=A)throw og(new Jl.Xz("SmilesParser: dangling open bond"));for(sn=0,rn=(en=an).length;sn<rn;++sn)if(-1!=en[sn])throw og(new Jl.Xz("SmilesParser: dangling ring closure"));for(y=xl.Yn(t.i),xl.Cm(t.i,!0),xl.iu(t.i,1),g=0;g<t.i.q;g++)if(null!=xl.tk(t.i,g))if(N=xl.uk(t.i,g)[0],hn||2==t.k)if(t.g)for(E=0;E<N;E++)xl.Oj(t.i,g,xl.Mj(t.i,1),1);else 0==N&&xl.hm(t.i,g,1792,!0),1==N&&xl.hm(t.i,g,1664,!0),2==N&&xl.hm(t.i,g,1408,!0),3==N&&xl.hm(t.i,g,896,!0);else{if(!xl.yl(t.i,g)&&(!xl.xl(t.i,g)||6==xl.Ik(t.i,g)&&0==xl.rk(t.i,g))){for(Nn=xl.Zm(xl.Ik(t.i,g)),P=!1,Cn=xl.fo(t.i,g),Cn-=xl.al(t.i,g,Cn),Cn+=N,xl.xl(t.i,g)&&++Cn,In=0,Mn=(pn=Nn).length;In<Mn;++In)if(Cn<=(Tn=pn[In])){P=!0,Tn==Cn+2?xl.im(t.i,g,48):Tn==Cn+1?xl.im(t.i,g,32):(Tn!=Cn||Tn!=Nn[0])&&xl.Vl(t.i,g,Cn);break}P||xl.Vl(t.i,g,Cn)}if(t.g||!xl.ip(t.i,g))for(E=0;E<N;E++)xl.Oj(t.i,g,xl.Mj(t.i,1),1)}else t.g||!hn&&2!=t.k||((N=xl.Pn(t.i,g))>=1&&xl.hm(t.i,g,128,!0),N>=2&&xl.hm(t.i,g,256,!0),N>=3&&xl.hm(t.i,g,512,!0),N>=4&&xl.hm(t.i,g,cn,!0));if(!t.g&&(hn||2==t.k)&&xl.$o(t.i,!0),xl.iu(t.i,1),xl.Et(t),xl.Ht(t,f),t.i.t=null,xl.Cm(t.i,!1),o&&(xl.Bt(t),nn)){for(K=new Fl.UMb(nn).a.Td().Fb(),_=new Fl._Mb(K);_.a.Fd();)W=_.a.Gd().Xd(),xl.gm(t.i,W.a,xl.Wt(W,y),!1);xl.dp(t.i,0)}xl.dp(t.i,0),a&&(F=new Sl.ty(t.d),Rg(t.j,0)&&Sl.py(F,t.j),Sl.ay(F,t.i),o&&xl.vu(t.i)),(hn||2==t.k)&&xl.Am(t.i,!0)},xl.Jt=function(n,t,e,i,s){xl.It(n,t,e,0,e.length,i,s)},xl.Kt=function(n,t){var e;return null==t?null:xl.Lt(n,kl.uTb((e=t,yf.XKb(),e)))},xl.Lt=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c;for(o=gf.r6(t,0);o>0&&45==t[o-1];)o=gf.r6(t,o+1);for(l=-1==o?-1:gf.r6(t,o+1);l>0&&45==t[l-1];)l=gf.r6(t,l+1);if(-1==l)throw og(new Jl.Xz("Missing one or both separators ('>')."));if(-1!=gf.r6(t,l+1))throw og(new Jl.Xz("Found more than 2 separators ('>')."));for(d=new Vl.DF,r=c=0;r<o-1;r++)46==t[r]&&46==t[r+1]&&(r>c&&(u=new xl.Au,xl.It(n,u,t,c,r,!0,!0),Fl.Ki(d.g,u),d.d=-1),c=r+2);if(h=new xl.Au,xl.It(n,h,t,c,o,!0,!0),Fl.Ki(d.g,h),d.d=-1,l-o>1){for(a=c=o+1;a<l-1;a++)46==t[a]&&46==t[a+1]&&(a>c&&(e=new xl.Au,xl.It(n,e,t,c,a,!0,!0),Fl.Ki(d.a,e)),c=a+2);i=new xl.Au,xl.It(n,i,t,c,l,!0,!0),Fl.Ki(d.a,i)}for(s=c=l+1;s<t.length-1;s++)46==t[s]&&46==t[s+1]&&(s>c&&(f=new xl.Au,xl.It(n,f,t,c,s,!0,!0),Fl.Ki(d.f,f),d.d=-1),c=s+2);return g=new xl.Au,xl.It(n,g,t,c,t.length,!0,!0),Fl.Ki(d.f,g),d.d=-1,d},xl.Mt=function(n,t){var e,i,s,r;for(1==xl.Yk(n.i,t)&&xl.ym(n.i,t,2),s=0;s<2;s++)for(e=xl.Nk(n.i,s,t),xl.xl(n.i,e)&&(xl.em(n.i,e,!1),--n.b),r=0;r<xl.Ln(n.i,e);r++)i=xl.Mn(n.i,e,r),n.f[i]&&(n.f[i]=!1,--n.c)},xl.Nt=function(n){var t,e,i,s,r,a,o;do{for(o=!1,e=0;e<n.i.g;e++)if(n.f[e]){for(r=!1,s=0;s<2;s++){for(t=!1,i=xl.Nk(n.i,s,e),a=0;a<xl.Ln(n.i,i);a++)if(e!=xl.Mn(n.i,i,a)&&n.f[xl.Mn(n.i,i,a)]){t=!0;break}if(!t){r=!0;break}}r&&(o=!0,xl.Mt(n,e))}}while(o)},xl.Ot=function(n,t){var e,i;if(!xl.bs(xl.Ik(n.i,t)))return!1;if(6==xl.Ik(n.i,t)){if(!xl.xl(n.i,t))return!1;if(xl.rk(n.i,t)>0)return!1}if(e=null==xl.tk(n.i,t)?0:xl.uk(n.i,t)[0],(i=xl.Wn(n.i,t)-e)<1)return!1;if(16==xl.Ik(n.i,t)||34==xl.Ik(n.i,t)||52==xl.Ik(n.i,t)){if(2==xl.Ln(n.i,t)&&xl.rk(n.i,t)<=0)return!1;if(2==i)return!1}return!0},xl.Pt=function(n,t){n.j=t},xl.Qt=function(n,t){n.e&&(!n.n&&(n.n=new Jl.qIb),Jl.nIb(n.n," "),Jl.nIb(n.n,t))},xl.Rt=function(){xl.St.call(this,0,!1)},xl.St=function(n,t){this.k=3&n,this.a=0==(16&n),this.e=t,this.g=0!=(8&n),this.d=2,0!=(4&n)&&(this.d|=1),this.g&&(this.d&=-3)},zf(151,1,{},xl.Rt,xl.St),o.a=!1,o.b=0,o.c=0,o.d=0,o.e=!1,o.g=!1,o.j=0,o.k=0,yl.kmb=lg(151),xl.Tt=function(){},zf(386,1,{},xl.Tt),o.a=0,o.b=0,o.c=!1,o.d=!1,yl.hmb=lg(386),xl.Ut=function(n,t){this.a=n,this.b=t},zf(210,1,{210:1},xl.Ut),o.a=0,o.b=0,yl.imb=lg(210),xl.Vt=function(n,t,e){if(!n.c){if(4==n.e.a.length)return void(n.c=!0);Fl.Ki(n.e,new xl.Ut(t,e))}},xl.Wt=function(n,t){var e,i;if(n.c)return 3;for(i=new Fl.zOb(n.e);i.a<i.c.a.length;)2147483646!=(e=Fl.yOb(i)).a&&e.a!=I&&(e.a=t[e.a]);if(3==n.e.a.length)Fl.Ki(n.e,new xl.Ut(I,n.b));else if(4!=n.e.a.length)return 3;return n.d^xl.Xt(n)?1:2},xl.Xt=function(n){var t,e,i;for(e=!1,t=1;t<n.e.a.length;t++)for(i=0;i<t;i++)Fl.Pi(n.e,i).a>Fl.Pi(n.e,t).a&&(e=!e),Fl.Pi(n.e,i).b>Fl.Pi(n.e,t).b&&(e=!e);return e},xl.Yt=function(n,t,e,i,s){0!=i&&1!=i?this.c=!0:(this.a=n,this.b=t,this.d=s,this.e=new Fl.cj,-1!=e&&xl.Vt(this,e,t-1),-1!=e&&1==i&&xl.Vt(this,2147483646,t+1))},zf(252,1,{252:1},xl.Yt),o.a=0,o.b=0,o.c=!1,o.d=!1,yl.jmb=lg(252),xl.Zt=function(n,t,e,i){return n.a=!1,n.d=e,Og(t[e]&B)?(n.c=n.b=xl.$t(n),n.d-e):123==t[e]&&Og(t[e+1]&B)?(++n.d,n.c=xl.$t(n),45!=t[n.d++]?0:Og(t[n.d]&B)?(n.b=xl.$t(n),125!=t[n.d++]?0:n.d-e):0):(n.c=1,n.b=i,n.a=!0,0)},xl.$t=function(n){var t;return t=n.e[n.d++]-48,Og(n.e[n.d]&B)&&(t=10*t+(n.e[n.d++]-48)),t},xl._t=function(n){return"{"+n.c+"-"+n.b+"}"},xl.au=function(n){this.e=n},zf(385,1,{},xl.au),o.lb=function(){return xl._t(this)},o.a=!1,o.b=0,o.c=0,o.d=0,yl.lmb=lg(385),xl.cu=function(n){n.c=new Fl.cj},xl.du=function(n,t){var e,i,s,r;if(0==(r=n.c.a.length))return Fl.Ji(n.c,0,t),0;for(s=1;2*s<=r;)s<<=1;for(i=s,--s;0!=i;)if(i>>=1,s>=r)s-=i;else{if(0==(e=Jl.FHb(t,Fl.Pi(n.c,s))))return-1;if(0==i)break;e<0?s-=i:s+=i}return s<r&&Jl.FHb(t,Fl.Pi(n.c,s))>0&&++s,Fl.Ji(n.c,s,t),s},xl.eu=function(n,t){var e,i,s,r;if(0==(r=n.c.a.length))return-1;for(s=1;2*s<=r;)s<<=1;for(i=s,--s;0!=i;)if(i>>=1,s>=r)s-=i;else{if(0==(e=Jl.FHb(t,Fl.Pi(n.c,s))))return s;if(0==i)break;e<0?s-=i:s+=i}return-1},xl.fu=function(){xl.cu(this)},zf(115,1,je,xl.fu),o.Pb=function(n){return xl.eu(this,n)},yl.mmb=lg(115),xl.hu=function(n,t){xl.fk(n,t),n.d&&(t.T=0)},xl.iu=function(n,t){var e,i,s,r;if(xl.pn(n,t),0!=(t&~n.T)){for(0!=(15&n.T)&&n.q>1&&xl.Ah(n.J[0],n.J[1])&&Sl.ay(new Sl.ty(0),n),n.c&&(t|=128),e=0;e<n.q;e++)n.u[e]&=-67223560;for(i=0;i<n.g;i++)n.F[i]&=-64;s=0,r=0,0!=(32&t)?(s=32,r=1):0!=(64&t)&&(s=64,r=3),0!=(128&t)&&(s|=128,r|=32),n.d=new xl.ig(n,r),xl.dg(n.d),xl.eg(n.d),xl.cg(n.d),xl.zu(n)&&(n.d=new xl.ig(n,r)),n.T|=24|s}},xl.ju=function(n,t){return xl.Sf(n.d,t)},xl.ku=function(n,t){return xl.Jf(n.d,t)},xl.lu=function(n){var t;switch(xl.iu(n,31),t=n.I&B,n.I&$n){case J:return null;case gt:return 1==t?"meso":t+" meso diastereomers";case 0:return"unknown chirality";case ut:return"both enantiomers";case Wn:return"this enantiomer";case 327680:return"this or other enantiomer";case Mn:return"two epimers";default:return 1==t?"one stereo isomer":t+" stereo isomers"}},xl.mu=function(n){var t;return t=new xl.Bu(n.q,n.r),xl.ek(n,t),t},xl.nu=function(t){var e,i,s,r,a,o,l;for(xl.iu(t,15),o=vf(yl.tlb,z,6,3,15,1),i=0;i<t.f;i++)0!=(t.u[i]&wt)&&0!=(l=(t.u[i]&On)>>18)&&(o[l]=n.Math.max(o[l],(t.u[i]&On)>>18!=1&&(t.u[i]&On)>>18!=2?-1:(t.u[i]&pt)>>20));for(r=0;r<t.g;r++)1!=(3&t.F[r])&&2!=(3&t.F[r])||1!=t.H[r]||0!=(l=(768&t.F[r])>>8)&&(o[l]=n.Math.max(o[l],(768&t.F[r])>>8!=1&&(768&t.F[r])>>8!=2?-1:(t.F[r]&It)>>10));for((a=vf(yl.tlb,ot,8,3,0,2))[1]=vf(yl.tlb,z,6,1+o[1],15,1),a[2]=vf(yl.tlb,z,6,1+o[2],15,1),e=0;e<t.f;e++)0!=(t.u[e]&wt)&&0!=(l=(t.u[e]&On)>>18)&&++a[l][(t.u[e]&On)>>18!=1&&(t.u[e]&On)>>18!=2?-1:(t.u[e]&pt)>>20];for(s=0;s<t.g;s++)1!=(3&t.F[s])&&2!=(3&t.F[s])||1!=t.H[s]||0!=(l=(768&t.F[s])>>8)&&++a[l][(768&t.F[s])>>8!=1&&(768&t.F[s])>>8!=2?-1:(t.F[s]&It)>>10];return a},xl.ou=function(n){var t,e;return t=vf(yl.tlb,z,6,n.q,15,1),e=xl.Un(n,t,!1,!1),xl.pu(n,t,e)},xl.pu=function(n,t,e){var i,s,r,a,o,l,f,g,u,h,d,c,b,D;for(b=vf(yl.nmb,ae,24,e,0,1),a=vf(yl.tlb,z,6,e,15,1),f=vf(yl.tlb,z,6,e,15,1),r=vf(yl.tlb,z,6,n.q,15,1),s=0;s<n.q;s++)-1!=t[s]&&(r[s]=a[t[s]]++);for(l=0;l<n.r;l++)(c=t[n.D[0][l]])==t[n.D[1][l]]&&-1!=c&&++f[c];for(D=0;D<e;D++)b[D]=new xl.Bu(a[D],f[D]),xl.hu(n,b[D]);for(i=0;i<n.q;i++)-1!=t[i]&&xl.bk(n,b[t[i]],i,0,0);for(o=0;o<n.r;o++)(c=t[n.D[0][o]])==t[n.D[1][o]]&&-1!=c&&xl.dk(n,b[c],o,0,0,r,!1);for(h=0,d=(u=b).length;h<d;++h)g=u[h],xl.Rl(g,1),xl.Rl(g,2);return b},xl.qu=function(n){return xl.iu(n,15),!n.d&&(n.f<2||!xl.Ah(n.J[0],n.J[1]))&&(n.d=new xl.hg(n)),n.d?xl.Nf(n.d):null},xl.ru=function(n){return xl.iu(n,15),!n.d&&(n.f<2||!xl.Ah(n.J[0],n.J[1]))&&(n.d=new xl.hg(n)),n.d?xl.Kf(n.d):null},xl.su=function(n){var t,e;for(xl.iu(n,31),e=0,t=0;t<n.f;t++)0!=(3&n.u[t])&&0==(4&n.u[t])&&++e;return e},xl.tu=function(n,t){return xl.Rf(n.d,t)},xl.uu=function(n,t){n.c=t,n.T&=-144},xl.vu=function(n){xl.iu(n,31),n.d&&xl.fg(n.d)},xl.wu=function(n){var t,e;for(xl.iu(n,15),n.L=!1,t=0;t<n.q;t++)n.u[t]&=yt,0!=(3&n.u[t])?n.u[t]|=Nt:n.u[t]&=Ut;for(e=0;e<n.r;e++)0!=(3&n.F[e])&&2==xl.Vk(n,e)?n.H[e]=386:n.H[e]&=-385;n.T&=-249},xl.xu=function(n,t,e){var i,s,r,a,o,l,f,g,u;if(1==(u=3&n.u[t])||2==u){if(o=!1,2==n.o[t]&&2==n.j[t]&&2==n.n[t][0]&&2==n.n[t][1]&&n.C[t]<=7)for(a=0;a<n.j[t];a++){for(i=n.i[t][a],g=0,f=vf(yl.tlb,z,6,3,15,1),l=0;l<n.j[i];l++)f[g]=n.i[i][l],f[g]!=t&&++g;2==g&&f[0]<f[1]^e[f[0]]<e[f[1]]&&(o=!o)}else for(a=1;a<n.j[t];a++)for(l=0;l<a;l++)(s=n.i[t][a])<(r=n.i[t][l])^e[s]<e[r]&&(o=!o);o&&(u=1==u?2:1)}return u},xl.yu=function(t){var e,i,s,r,a,o;for(xl.jp(t),xl.iu(t,31),s=0;s<t.f;s++){if(!((t.u[s]&On)>>18!=1&&(t.u[s]&On)>>18!=2||0!=(t.u[s]&wt)&&3!=(3&t.u[s])))throw og(new Jl.Xz(me));if(0!=(t.u[s]&J))throw og(new Jl.Xz(Ae));if((1==(3&t.u[s])||2==(3&t.u[s]))&&0==t.o[s]){for(e=vf(yl.rlb,X,6,t.j[s],15,1),a=0;a<t.j[s];a++)e[a]=xl.Mk(t,s,t.i[s][a]);for(r=1;r<t.j[s];r++)if(!xl.Fl(t,t.k[s][r],s))for(o=0;o<r;o++)if(!xl.Fl(t,t.k[s][o],s)&&((i=n.Math.abs(xl._m(e[r],e[o])))<.08||i>xt))throw og(new Jl.Xz(Ce))}}},xl.zu=function(n){var t,e,i,s,r,a,o;for(o=!1,e=0;e<n.f;e++)(0==(n.u[e]&wt)||3==(3&n.u[e]))&&(n.u[e]&=yt);for(r=0;r<n.g;r++)(1!=xl.Vk(n,r)||0==(3&n.F[r])||3==(3&n.F[r]))&&(n.F[r]&=-32513);if(n.L){if((n.I&$n)!=gt){for(a=vf(yl.Lwb,nn,6,n.f,16,1),i=0;i<n.f;i++)0!=(n.u[i]&wt)&&3!=(3&n.u[i])&&(n.u[i]&On)>>18==1&&(a[i]=!0);for(s=0;s<n.f;s++)0!=(n.u[s]&wt)&&3!=(3&n.u[s])&&(xl.am(n,s,1,0),o=!0);for(t=0;t<n.f;t++)a[t]&&(xl.gm(n,t,1,!1),xl.am(n,t,1,-1),o=!0)}n.L=!1}return xl.Rl(n,1),xl.Rl(n,2),o},xl.Au=function(){xl.Kj(),xl.lp.call(this)},xl.Bu=function(n,t){xl.Kj(),xl.mp.call(this,n,t)},xl.Cu=function(n){xl.Kj(),xl.np.call(this,n)},zf(24,97,Te,xl.Au,xl.Bu,xl.Cu),o.Kb=function(n){xl.hu(this,n)},o.Mb=function(n){xl.iu(this,n)},o.c=!1,yl.nmb=lg(24),xl.Gu=function(n,t){var e,i,s,r,a,o,l,f,g,u,h;for(o=new Fl.cj,xl.iu(t,1),f=vf(yl.Lwb,nn,6,t.f,16,1),e=0;e<t.f;e++)if(n.f[e]&&(7==xl.Ik(n.i,e)||8==xl.Ik(n.i,e)||16==xl.Ik(n.i,e)||34==xl.Ik(n.i,e)||52==xl.Ik(n.i,e))){for(f[e]=!0,l=0;l<t.j[e];l++)if(i=t.i[e][l],r=t.k[e][l],u=t.n[e][l],0!=t.o[i]&&t.o[e]<u){for(f[i]=!0,Fl.Ki(o,Jl._Gb(r)),g=0;g<t.j[i];g++)f[s=t.i[i][g]]||(f[s]=!0,a=t.k[i][g],h=t.n[i][g],t.o[i]+2==u+h&&(Fl.Ki(o,Jl._Gb(a)),u>=h&&(t.o[s]<h?xl.Pu(t,s)&&xl.Ju(n,t,s,!0,!1,f,o):xl.Ju(n,t,s,!0,!0,f,o)),h>=u&&xl.Pu(t,e)&&xl.Ju(n,t,s,!1,!1,f,o),n.f[s]&&(5==xl.Ik(n.i,s)||6==xl.Ik(n.i,s)||7==xl.Ik(n.i,s)||8==xl.Ik(n.i,s)||16==xl.Ik(n.i,s)||34==xl.Ik(n.i,s)||52==xl.Ik(n.i,s))&&t.o[s]<h&&(u<=2&&h>=2&&xl.Pu(t,e)&&xl.Hu(n,t,r,a),u>=2&&h<=2&&xl.Pu(t,s)&&xl.Hu(n,t,a,r)),Fl.Wi(o,o.a.length-1)),f[s]=!1);Fl.Wi(o,o.a.length-1),f[i]=!1}f[e]=!1}},xl.Hu=function(n,t,e,i){var s;s=new xl.Vu(n,t),xl.Uu(s,e,1==xl.Vk(t,e)?2:3),xl.Uu(s,i,2==xl.Vk(t,i)?1:2),n.g[e]=!0,n.g[i]=!0,Fl.gSb(n.e,s)&&Fl.UNb(n.d,s)},xl.Iu=function(n,t){Fl.gSb(n.e,t)&&Fl.UNb(n.d,t)},xl.Ju=function(n,t,e,i,s,r,a){var o,l,f,g,u,h,d,c,b,D,H;for(d=0;d<t.j[e];d++)if(!r[o=t.i[e][d]]&&(g=t.k[e][d],D=xl.Vk(t,g),i&&D>=2||!i&&D<=2)){for(r[o]=!0,a.add(Jl._Gb(g)),c=0;c<t.j[o];c++)if(!r[l=t.i[o][c]]&&(u=t.k[o][c],H=xl.Vk(t,u),t.o[o]+2==D+H&&(i&&H<=2||!i&&H>=2))){if(r[l]=!0,a.add(Jl._Gb(u)),!n.f[l]||5!=xl.Ik(n.i,l)&&6!=xl.Ik(n.i,l)&&7!=xl.Ik(n.i,l)&&8!=xl.Ik(n.i,l)&&16!=xl.Ik(n.i,l)&&34!=xl.Ik(n.i,l)&&52!=xl.Ik(n.i,l)||i&&!xl.Pu(t,l))xl.Ju(n,t,l,i,s,r,a);else{for(h=new xl.Vu(n,t),b=0;b<a.a.length;b++)f=(kl.HTb(b,a.a.length),a.a[b]).a,(b<2?i^0==(1&b):s^0==(1&b))?xl.Uu(h,f,1==xl.Vk(t,f)?2:3):xl.Uu(h,f,2==xl.Vk(t,f)?1:2),n.g[f]=!0;Fl.gSb(n.e,h)&&Fl.UNb(n.d,h)}Fl.Wi(a,a.a.length-1),r[l]=!1}Fl.Wi(a,a.a.length-1),r[o]=!1}return!1},xl.Ku=function(n){var t,e,i,s,r,a,o,l,f,g,u;for(n.b=vf(yl.tlb,z,6,n.i.f,15,1),o=vf(yl.tlb,z,6,n.i.f,15,1),i=vf(yl.Lwb,nn,6,n.i.g,16,1),u=0,e=0;e<n.i.g;e++)if(!i[e]&&n.g[e])for(++u,n.b[xl.Nk(n.i,0,e)]=u,n.b[xl.Nk(n.i,1,e)]=u,i[e]=!0,f=0;f<2;f++)for(t=xl.Nk(n.i,f,e),n.b[t]=u,a=0,l=0,o[0]=t;a<=l;){for(g=0;g<xl.Ln(n.i,o[a]);g++)!i[r=xl.Mn(n.i,o[a],g)]&&n.g[r]&&(i[r]=!0,s=xl.Kn(n.i,o[a],g),0==n.b[s]&&(n.b[s]=u,o[++l]=s));++a}n.j=u},xl.Lu=function(n){var t,e,i;for(n.n=vf(yl.tlb,z,6,n.j,15,1),n.k=vf(yl.tlb,z,6,n.j,15,1),n.o=vf(yl.tlb,z,6,n.j,15,1),t=0;t<n.i.f;t++)0!=n.b[t]&&(i=n.b[t]-1,null!=n.a&&(n.k[i]+=n.a[t]),null!=n.c&&(n.o[i]+=n.c[t]));for(e=0;e<n.i.g;e++)n.g[e]&&2==xl.Vk(n.i,e)&&(n.n[n.b[xl.Nk(n.i,0,e)]-1]+=2)},xl.Mu=function(n){var t,e,i,s;for(i=0;i<n.i.r;i++)for(s=0;s<2;s++)t=xl.Nk(n.i,s,i),e=xl.Nk(n.i,1-s,i),1==xl.Ik(n.i,t)&&xl.Bk(n.i,t)>1&&xl.Ik(n.i,e)>1&&0!=n.b[e]&&(2==xl.Bk(n.i,t)?(null==n.a&&(n.a=vf(yl.tlb,z,6,n.i.q,15,1)),++n.a[e]):(null==n.c&&(n.c=vf(yl.tlb,z,6,n.i.q,15,1)),++n.c[e]),xl.Hl(n.i,t));(null!=n.a||null!=n.c)&&xl.lk(n.i)},xl.Nu=function(n){var t;for(n.e=new Fl.lSb,n.d=new Fl.eOb,xl.Iu(n,new xl.Vu(n,n.i)),t=xl.mu(n.i);!Fl.YNb(n.d);)if(xl.Tu(Fl.$Nb(n.d),t),xl.Gu(n,t),n.e.a.c>=xl.Fu){Jl.vIb(),xl.Nf(new xl.hg(n.i));break}},xl.Ou=function(n){var t,e,i,s,r,a,o,l,f,g;if(1==n.e.a.c)return n.i;for(f=xl.mu(n.i),xl.Am(f,!0),xl.iu(f,7),s=0;s<f.g;s++)n.g[s]&&(f.H[s]=1,f.T=0,xl.xm(f,s,3,!0));for(e=0;e<f.f;e++)0!=n.b[e]&&xl.eo(n.i,e)<4&&(xl.mn(f,e),f.u[e]&=Ut,f.T&=7,xl.am(f,e,0,-1));for(o=vf(yl.tlb,z,6,n.j,15,1),l=vf(yl.tlb,z,6,n.j,15,1),i=new xl.hg(f).d,t=0;t<f.f;t++)0!=n.b[t]&&l[g=n.b[t]-1]<i[t]&&(l[g]=i[t],o[g]=t);for(r=0;r<n.j;r++)a=n.n[r]+"|"+n.k[r]+"|"+n.o[r],xl.$l(f,o[r],a);return f},xl.Pu=function(n,t){return!(n.e[t]-xl.eo(n,t)+xl.$n(n,t)<=0)&&(!!xl.vl(n,t)||0==n.o[t])},xl.Qu=function(n){var t,e,i,s,r,a,o,l;xl.iu(n.i,1),o=n.i.f;do{--o}while(o>=0&&1==xl.Ik(n.i,o));for(t=0;t<o;t++)if(1==xl.Ik(n.i,t)){xl.Lm(n.i,t,o);do{--o}while(1==xl.Ik(n.i,o))}if(o!=n.i.f-1){for(a=vf(yl.Lwb,nn,6,n.i.g,16,1),r=0;r<n.i.g;r++)e=xl.Nk(n.i,0,r),i=xl.Nk(n.i,1,r),(1==xl.Ik(n.i,e)||1==xl.Ik(n.i,i))&&(a[r]=!0);l=n.i.g;do{--l}while(l>=0&&a[l]);for(s=0;s<l;s++)if(a[s]){xl.Mm(n.i,s,l),a[s]=!1;do{--l}while(a[l])}}},xl.Ru=function(n){var t,e;for(this.i=xl.mu(n),xl.Qu(this),xl.iu(this.i,7),this.g=vf(yl.Lwb,nn,6,this.i.g,16,1),this.f=vf(yl.Lwb,nn,6,this.i.f,16,1),t=0;t<this.i.f;t++)e=xl.Zm(xl.Ik(this.i,t))[0],this.f[t]=xl.eo(this.i,t)<e;xl.Nu(this),xl.Ku(this),xl.Mu(this),xl.Lu(this)},zf(275,1,{},xl.Ru),o.j=0,xl.Fu=pe,yl.pmb=lg(275),xl.Su=function(n,t){return gf.D6(n.a,t.a)},xl.Tu=function(n,t){var e,i;for(i=0;i<n.b.i.g;i++)n.b.g[i]&&(e=3&n.a[i>>4]>>2*(15&i),xl.ym(t,i,1==e?1:2==e?n.b.g[i]&&!xl.To(n.b.i,i)?386:2:3==e?4:32))},xl.Uu=function(n,t,e){var i,s;i=t>>4,s=2*(15&t),n.a[i]&=~(3<<s),n.a[i]|=e<<s},xl.Vu=function(t,e){var i;for(this.b=t,this.a=vf(yl.tlb,z,6,(t.i.g+15)/16|0,15,1),i=0;i<t.i.g;i++)this.a[i>>4]|=n.Math.min(3,xl.Vk(e,i))<<2*(15&i)},zf(183,1,{183:1,19:1},xl.Vu),o.Eb=function(n){return xl.Su(this,n)},yl.omb=lg(183),xl.Xu=function(n){var t,e,i,s,r;if(-1==(e=Jl.OHb(n,bg(38))))return n;for(s=0,r=new Jl.gIb;-1!=e;)Jl.fIb(r,(kl.NTb(s,e,kl.TTb(n).length),kl.TTb(n).substr(s,e-s))),kl.OTb(e+1,kl.TTb(n).length),38==kl.TTb(n).charCodeAt(e+1)?(r.a+="&",s=e+2):(kl.OTb(e+1,kl.TTb(n).length),t=kl.TTb(n).charCodeAt(e+1),t-=t<65?48:t<97?65:97,kl.OTb(e+2,kl.TTb(n).length),i=kl.TTb(n).charCodeAt(e+2),i-=i<65?48:i<97?65:97,Jl.dIb(r,16*t+i&B),s=e+3),e=Jl.PHb(n,bg(38),s);return Jl.fIb(r,(kl.OTb(s,kl.TTb(n).length+1),kl.TTb(n).substr(s))),r.a},xl.Yu=function(n){var t,e;for(e=new Jl.gIb,t=0;t<kl.TTb(n).length;t++)switch(kl.OTb(t,kl.TTb(n).length),kl.TTb(n).charCodeAt(t)){case 38:e.a+="&&";break;case 9:e.a+="&09";break;case 10:e.a+="&0A";break;case 32:e.a+="&20";break;default:Jl.dIb(e,(kl.OTb(t,kl.TTb(n).length),kl.TTb(n).charCodeAt(t)))}return e.a},xl.Zu=function(n,t,e){n.e[0].a=t,n.e[0].b=e},xl.$u=function(n,t){try{n.a=$g(t)}catch(n){if(!_f(n=ag(n),53))throw og(n)}},xl._u=function(n,t){try{n.b=Jl.uGb(t,Zt,I)}catch(n){if(!_f(n=ag(n),53))throw og(n)}},xl.av=function(n,t,e,i){n.c=t,n.a=e,n.b=i},xl.bv=function(n,t){try{n.e[0].a=$g(t)}catch(n){if(!_f(n=ag(n),53))throw og(n)}},xl.cv=function(n,t){try{n.e[0].b=$g(t)}catch(n){if(!_f(n=ag(n),53))throw og(n)}},xl.dv=function(){xl.fv.call(this,new Kl.zG)},xl.ev=function(n){var t,e,i,s;for(xl.dv.call(this),t=0;-1!=t&&-1!=(e=kl.TTb(n).indexOf('="',t));)kl.NTb(t+1,e,kl.TTb(n).length),i=kl.TTb(n).substr(t+1,e-(t+1)),s=-1==(t=kl.TTb(n).indexOf('"',e+2))?(kl.OTb(e+1,kl.TTb(n).length+1),kl.TTb(n).substr(e+1)):(kl.NTb(e+1,t,kl.TTb(n).length),kl.TTb(n).substr(e+1,t-(e+1))),Jl.KHb(i,Ht)?this.c=xl.Xu(s):Jl.KHb(i,"x")?xl.bv(this,s):Jl.KHb(i,"y")?xl.cv(this,s):Jl.KHb(i,"size")?xl.$u(this,s):Jl.KHb(i,Ie)&&xl._u(this,s)},xl.fv=function(n){this.c="",this.a=9,this.b=0,this.e=vf(yl.Knb,w,33,1,0,1),this.e[0]=n},zf(188,230,{230:1},xl.dv,xl.ev),o.Ab=function(){var n;return n=new xl.dv,xl.av(n,this.c,this.a,this.b),xl.Zu(n,this.e[0].a,this.e[0].b),n.d=this.d,n},o.Bb=function(){var n;return n=new Jl.qIb,Jl.nIb(n,' text="'+xl.Yu(this.c)+'"'),Jl.nIb(n,' x="'+this.e[0].a+'"'),Jl.nIb(n,' y="'+this.e[0].b+'"'),9!=this.a&&Jl.nIb(n,' size="'+this.a+'"'),0!=this.b&&Jl.nIb(n,' style="'+this.b+'"'),n.a},o.Cb=function(){return Ht},o.a=0,o.b=0,yl.qmb=lg(188),xl.jv=function(n){n.b=new Fl.cj,n.a=new Fl.cj},xl.kv=function(n,t){var e,i;return-1==(e=xl.du(n,t))?-1:(i=n.b.a.length,Fl.Ki(n.b,t),Fl.Ji(n.a,e,new Jl.PGb(i)),i)},xl.lv=function(){xl.fu.call(this),xl.jv(this)},zf(384,115,je,xl.lv),o.Pb=function(n){var t;return-1==(t=xl.eu(this,n))?-1:Fl.Pi(this.a,t).a},yl.rmb=lg(384),Ql.nv=function(t,e){var i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,j,m,A,C,T,p,I,P,M,N,w,L,U,y,J,B,R,k;for(J=xl.no(t.e),B=Fl.Pi(J.j,e).length,U=Fl.Pi(J.i,e),y=Fl.Pi(J.j,e),P=!0,H=1;H<B;H++)if(Ql.Cv(t.b,y[H])!=Ql.Cv(t.b,y[0])){P=!1;break}if(P)for(a=(B-2)*Pe/B,j=0;j<B;j++)Ql.sv(t,U[j],y[j],y[0==j?B-1:j-1],a);else{for(w=vf(yl.slb,kt,6,B,15,1),r=0,m=0;m<B;m++)w[m]=0==xl.Bn(t.e,U[m])?1.9106119386631804:1==xl.Bn(t.e,U[m])?2.094499897810209:Pe,r+=w[m];for(s=((B-2)*Pe-r)/B,A=0;A<B;A++)w[A]+=s;for(u=vf(yl.slb,kt,6,B,15,1),C=1;C<B;C++)u[C]=u[C-1]+Pe-w[C];for(l=vf(yl.slb,kt,6,B,15,1),o=0;o<100;o++){for(R=0,k=0,j=0;j<B;j++)R+=Ql.Cv(t.b,y[j])*n.Math.sin(u[j]),k+=Ql.Cv(t.b,y[j])*n.Math.cos(u[j]);for(c=xl.$m(0,0,R,k),b=n.Math.sqrt(R*R+k*k),N=-1,M=0,T=0;T<B;T++)p=0==T?B-1:T-1,I=T+1==B?0:T+1,f=xl._m(u[T],u[p]),g=xl._m(u[I],u[T]),L=xl._m(w[T],w[I]),l[T]=2*f-2*g+2*L,d=b*n.Math.cos(u[T]-Me-c)-Ne*l[T],n.Math.abs(d)>n.Math.abs(M)&&(M=d,N=T);h=n.Math.exp(-5*o/100),u[N]+=h*M}for(D=0;D<B;D++)(i=u[p=0==D?B-1:D-1]+Pe-u[D])>rn&&(i-=rn),Ql.sv(t,U[D],y[p],y[D],i)}},Ql.ov=function(n,t){var e,i,s,r,a,o,l,f,g;for(l=xl.no(n.e),f=Fl.Pi(l.j,t).length,o=Fl.Pi(l.j,t),g=!1,s=0;s<f;s++)if(0==n.f[o[s]]){g=!0;break}if(g){for(e=(180*f-360)/f*.01745329238474369,a=Fl.Pi(l.i,t),r=0;r<f;r++)Ql.sv(n,a[r],o[0==r?f-1:r-1],o[r],e);if(f<=4)for(i=0;i<f;i++)n.f[o[i]]+=f}},Ql.pv=function(n,t,e,i){var s,r,a,o;for(r=-1,a=-1,o=0;o<xl.wn(n.e,t);o++)if((s=xl.Kn(n.e,t,o))==e||s==i){if(-1!=a){r=o;break}a=o}return n.a[t][r][a]},Ql.qv=function(n,t,e,i){return e<i?n.a[t][i][e]:n.a[t][e][i]},Ql.rv=function(n,t){var e,i,s,r,a,o,l;for(i=vf(yl.Lwb,nn,6,xl.Ln(n.e,t),16,1),l=0,s=0;s<xl.Ln(n.e,t);s++){for(o=0,a=-1,r=0;r<xl.Ln(n.e,t);r++)i[r]||(e=xl.Mn(n.e,t,r),o<n.f[e]&&(o=n.f[e],a=r));if(0==o)return l;l<<=8,l+=o,i[a]=!0}return l},Ql.sv=function(n,t,e,i,s){var r,a,o,l;for(r=-1,a=-1,l=0;l<xl.wn(n.e,t);l++)if((o=xl.Mn(n.e,t,l))==e||o==i){if(-1!=r){a=l;break}r=l}0==n.a[t][a][r]&&(n.a[t][a][r]=s,n.d[t]+=s,++n.c[t])},Ql.tv=function(n,t,e,i,s){var r,a,o,l,f,g;for(r=xl.wn(n.e,t),l=xl.Ln(n.e,t),f=1;f<r;f++)for(a=f<l?n.f[xl.Mn(n.e,t,f)]:0,g=0;g<f;g++)0==n.a[t][f][g]&&(o=g<l?n.f[xl.Mn(n.e,t,g)]:0,(a==e&&o==i||a==i&&o==e)&&(n.a[t][f][g]=s))},Ql.uv=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,H,m,A,C,T,p;for(this.b=t,this.e=n,this.a=vf(yl.slb,j,680,this.e.f,0,3),s=0;s<this.e.f;s++)for(this.a[s]=vf(yl.slb,{680:1,4:1,9:1,5:1,7:1},59,xl.wn(this.e,s),0,2),l=1;l<xl.wn(this.e,s);l++)this.a[s][l]=vf(yl.slb,kt,6,l,15,1);for(this.c=vf(yl.tlb,z,6,this.e.f,15,1),this.d=vf(yl.slb,kt,6,this.e.f,15,1),this.f=vf(yl.tlb,z,6,this.e.g,15,1),T=xl.no(this.e),h=vf(yl.Lwb,nn,6,T.i.a.length,16,1),xl.zr(T,h,vf(yl.Lwb,nn,6,T.i.a.length,16,1),vf(yl.tlb,z,6,T.i.a.length,15,1),!0),o=3;o<=7;o++)for(H=0;H<T.i.a.length;H++)(p=Fl.Pi(T.j,H).length)==o&&(h[H]?Ql.nv(this,H):p<=4&&Ql.ov(this,H));for(u=vf(yl.Lwb,nn,6,this.e.f,16,1),D=0;D<T.i.a.length;D++)if(h[D])for(A=0,C=(m=Fl.Pi(T.i,D)).length;A<C;++A)u[m[A]]=!0;for(r=Of(qf(yl.tlb,1),z,6,15,[0,0,1,3,6,10,15,21]),i=0;i<this.e.f;i++)if((a=xl.wn(this.e,i))>4){for(l=1;l<a;l++)for(c=0;c<l;c++)this.a[i][l][c]=Me;this.c[i]=r[a]}else if(this.c[i]!=r[a])if(xl.So(this.e,i)&&(u[i]||xl.Fn(this.e,i)<=4&&xl.Bn(this.e,i)>0)){if(a>2){if(1==this.c[i])e=xl.Ik(this.e,i)<=14?(we-this.d[i])/2:Le+.18000000715255737*(Le-this.d[i]);else if(e=we-this.d[i],a>3){if(2==this.c[i]){for(d=vf(yl.Lwb,nn,6,xl.wn(this.e,i),16,1),f=1;f<a;f++)for(b=0;b<f;b++)0!=this.a[i][f][b]&&(d[f]=!d[f],d[b]=!d[b]);for(g=0;g<a;g++)if(d[g]){for(b=g+1;b<a;b++)if(d[b]){this.a[i][b][g]=e;break}break}}e=Me}for(l=1;l<a;l++)for(c=0;c<l;c++)0==this.a[i][l][c]&&(this.a[i][l][c]=e)}}else if(xl.So(this.e,i)&&xl.Fn(this.e,i)<=4)switch(Ql.rv(this,i)){case 771:Ql.tv(this,i,0,3,2.0653998851776123),Ql.tv(this,i,0,0,1.9814722631346626);break;case 1028:Ql.tv(this,i,0,4,1.9797999858856201),Ql.tv(this,i,0,0,1.94691481878138);break;case 393987:Ql.tv(this,i,0,3,Ue),Ql.tv(this,i,0,6,Ue),Ql.tv(this,i,3,3,1.7229016938441077);break;case 459779:Ql.tv(this,i,0,3,ye),Ql.tv(this,i,0,4,ye),Ql.tv(this,i,0,7,ye),Ql.tv(this,i,3,4,1.9322539839360076);break;case 525316:Ql.tv(this,i,0,4,Je),Ql.tv(this,i,0,8,Je),Ql.tv(this,i,4,4,1.99944913298566);case 394758:Ql.tv(this,i,0,6,2.526099920272827);break;case 460550:Ql.tv(this,i,0,6,Be),Ql.tv(this,i,0,7,Be);break;case 526087:Ql.tv(this,i,0,7,Re),Ql.tv(this,i,0,8,Re);break;case 526344:Ql.tv(this,i,0,8,2.186300039291382);break;case 50529027:Ql.tv(this,i,3,3,2.4189000129699707);break;case 67371779:Ql.tv(this,i,3,4,2.2298998832702637);break;case 67372036:Ql.tv(this,i,4,4,2.094399929046631);break;case 101057283:Ql.tv(this,i,3,6,1.839926051241747),Ql.tv(this,i,3,3,2.9061476191098734);break;case 117834755:Ql.tv(this,i,3,4,2.812249087174905),Ql.tv(this,i,3,7,1.7910569124592968),Ql.tv(this,i,4,6,2.1224948975613245);break;case 134677507:Ql.tv(this,i,3,4,2.642428360523752),Ql.tv(this,i,3,8,2.027723514585844),Ql.tv(this,i,4,7,2.251474717631936);break;case 117900035:Ql.tv(this,i,3,7,2.109753935530918),Ql.tv(this,i,3,3,3.1052897491356646);break;case 117900292:Ql.tv(this,i,4,7,2.090729910747413),Ql.tv(this,i,4,4,2.551671293386306);break;case 134743044:Ql.tv(this,i,4,8,2.139250042271712),Ql.tv(this,i,4,4,2.3520055858942612)}else for(e=xl.Ik(this.e,i)>10?ke:2==xl.Bn(this.e,i)?Pe:xl.Jo(this.e,i,!0)?Ee:0==xl.Bn(this.e,i)?ke:Ee,l=1;l<a;l++)for(c=0;c<l;c++)this.a[i][l][c]=e},zf(526,1,{},Ql.uv),yl.smb=lg(526),Ql.Bv=function(){Ql.Bv=Xf,Ql.zv=Of(qf(yl.Lwb,1),nn,6,16,[!1,!1,!1,!1,!1,!0,!0,!0,!0,!1,!1,!1,!1,!1,!1,!0,!0])},Ql.Cv=function(n,t){return n.a[t]},Ql.Dv=function(n){var t,e;for(Ql.Bv(),xl.iu(n,7),this.a=vf(yl.slb,kt,6,n.r,15,1),this.b=vf(yl.slb,kt,6,n.r,15,1),t=0;t<n.r;t++)-1==(e=Ql.Gv(n,t))?(this.a[t]=Ql.Hv(n,t),this.b[t]=Ql.Iv(n,t)):(this.a[t]=-1==e?2.000499963760376:Ql.xv[e],this.b[t]=-1==e?1:Ql.yv[e])},Ql.Ev=function(n,t){return t>=n.f?0:t<n.f&&xl.Nr(n.p,t)&&6==n.C[t]&&0!=n.s[t]?1:n.o[t]},Ql.Fv=function(n,t,e,i,s,r,a){var o,l;return((e?0:t?4+n:n)<<24)+((o=(i<Ql.zv.length&&Ql.zv[i]?r<<8:0)+i)<(l=(s<Ql.zv.length&&Ql.zv[s]?a<<8:0)+s)?(o<<12)+l:(l<<12)+o)},Ql.Gv=function(n,t){var e,i,s,r;return e=n.D[0][t],i=n.D[1][t],s=n.C[e],r=n.C[i],Ql.Kv(Ql.Fv(xl.Vk(n,t),t<n.g&&xl.Or(n.p,t),t<n.g&&(xl.Sr(n.p,t)||64==n.H[t]),s,r,Ql.Ev(n,e),Ql.Ev(n,i)))},Ql.Hv=function(n,t){var e,i;return e=xl.Ik(n,n.D[0][t]),i=xl.Ik(n,n.D[1][t]),(e<(Ql.hx(),Ql.fx).length?Ql.fx[e]:e<Ql.gx.length?xe*Ql.gx[e]:Fe)+(i<Ql.fx.length?Ql.fx[i]:i<Ql.gx.length?xe*Ql.gx[i]:Fe)},Ql.Iv=function(n,t){var e,i;return e=xl.Ik(n,n.D[0][t]),i=xl.Ik(n,n.D[1][t]),(e<(Ql.hx(),Ql.fx).length?Qe:.125)+(i<Ql.fx.length?Qe:.125)},Ql.Jv=function(){var n,t,e,i,s,r;if(!Ql.Av){for(e=(n=Jl.VHb("2312\n4099\t2.403\t0.282\t466\n4100\t1.407\t0.2\t28\n4103\t1.561\t0.023\t5\n4104\t1.42\t0.092\t491\n4105\t1.313\t0.149\t32\n4107\t2.677\t0.401\t190\n4108\t2.118\t0.244\t325\n4109\t1.978\t0.26\t968\n4113\t1.819\t0.033\t4\n4115\t3.194\t0.482\t381\n4116\t2.771\t0.32\t198\n4117\t2.398\t0.235\t145\n4118\t2.317\t0.22\t208\n4119\t2.034\t0.212\t34\n4120\t2.033\t0.286\t103\n4121\t1.959\t0.264\t122\n4122\t1.918\t0.267\t664\n4123\t1.893\t0.257\t185\n4124\t1.877\t0.218\t259\n4125\t2.05\t0.257\t556\n4126\t2.012\t0.239\t129\n4127\t1.979\t0.292\t196\n4133\t3.305\t0.429\t34\n4134\t2.593\t0.367\t83\n4135\t2.74\t0.174\t706\n4136\t2.462\t0.196\t611\n4137\t2.207\t0.264\t78\n4138\t2.16\t0.225\t359\n4140\t2.004\t0.188\t2204\n4141\t1.916\t0.256\t610\n4142\t1.95\t0.234\t126\n4143\t2.3\t0.213\t81\n4144\t2.187\t0.116\t6\n4145\t2.103\t0.153\t21\n4146\t2.031\t0.308\t83\n4147\t1.752\t0.443\t21\n4151\t3.49\t0.4\t83\n4152\t3.017\t0.331\t40\n4153\t2.932\t0.276\t176\n4154\t2.39\t0.34\t24\n4155\t3.124\t0.377\t16\n4156\t2.907\t0.232\t198\n4158\t2.857\t0.237\t142\n4159\t2.687\t0.244\t49\n4160\t2.787\t0.359\t29\n4161\t2.785\t0.306\t37\n4162\t2.623\t0.298\t175\n4163\t2.812\t0.154\t70\n4164\t2.745\t0.281\t100\n4165\t2.719\t0.184\t37\n4166\t2.683\t0.361\t231\n4167\t2.655\t0.253\t198\n4168\t2.546\t0.208\t37\n4169\t2.259\t0.231\t190\n4170\t2.043\t0.289\t251\n4171\t2.001\t0.221\t391\n4172\t1.984\t0.164\t885\n4173\t1.904\t0.228\t1074\n4174\t2.036\t0.224\t250\n4175\t1.955\t0.184\t6\n4176\t2.35\t0.15\t12\n4177\t2.367\t0.216\t7\n4178\t2.47\t0.186\t11\n4179\t0.95\t-1.0\t1\n4186\t2.88\t0.309\t39\n4188\t2.804\t0.289\t136\n4189\t2.172\t0.082\t12\n4190\t2.321\t0.0\t2\n4359\t1.503\t0.106\t24\n4360\t1.425\t0.052\t40\n12291\t2.861\t0.27\t1069\n12292\t2.773\t0.086\t4\n12293\t2.507\t0.251\t27\n12294\t2.769\t0.373\t370\n12299\t3.1\t0.221\t116\n12300\t2.844\t0.146\t9\n12301\t3.636\t0.002\t3\n12302\t2.779\t0.318\t189\n12307\t3.639\t0.518\t25\n12308\t3.205\t0.245\t16\n12317\t3.036\t0.064\t4\n12318\t2.88\t-1.0\t1\n12319\t2.615\t0.864\t3\n12320\t2.857\t0.129\t247\n12325\t3.557\t0.41\t18\n12326\t3.273\t0.208\t23\n12330\t3.496\t0.025\t2\n12333\t3.012\t0.276\t2\n12334\t2.679\t0.0\t2\n12338\t2.886\t0.196\t80\n12339\t2.871\t0.221\t18\n12343\t3.628\t0.266\t9\n12344\t3.37\t0.145\t35\n12346\t2.859\t0.0\t4\n12352\t2.722\t0.017\t4\n12354\t3.317\t0.016\t4\n12355\t2.714\t0.006\t2\n12357\t2.703\t0.005\t2\n12365\t2.615\t-1.0\t1\n12367\t2.729\t0.0\t2\n12368\t2.841\t0.0\t2\n12369\t2.889\t0.082\t5\n12370\t2.913\t0.126\t64\n12549\t3.003\t0.175\t18\n12550\t2.797\t0.21\t1156\n12805\t2.63\t0.0\t2\n12806\t2.939\t0.243\t85\n16388\t2.29\t0.104\t57\n16389\t2.022\t0.097\t6\n16390\t2.097\t0.127\t21\n16391\t1.771\t0.395\t281\n16392\t1.648\t0.242\t634\n16393\t1.567\t0.555\t264\n16395\t2.926\t0.104\t14\n16397\t2.368\t-1.0\t1\n16398\t3.269\t-1.0\t1\n16399\t2.211\t0.15\t6\n16400\t2.1\t-1.0\t1\n16401\t2.065\t0.622\t37\n16403\t3.355\t0.087\t11\n16404\t2.9\t0.136\t2\n16416\t2.399\t0.154\t3\n16417\t2.06\t0.0\t2\n16418\t2.195\t-1.0\t1\n16419\t2.167\t0.95\t16\n16421\t3.378\t-1.0\t1\n16422\t2.886\t0.031\t2\n16429\t2.375\t0.124\t6\n16435\t2.635\t-1.0\t1\n16436\t2.399\t-1.0\t1\n16437\t2.417\t0.96\t23\n16439\t3.716\t0.078\t2\n16442\t3.052\t0.0\t4\n16463\t2.64\t-1.0\t1\n16466\t2.23\t-1.0\t1\n16474\t3.061\t0.0\t4\n16476\t3.017\t0.004\t8\n16645\t1.954\t-1.0\t1\n16646\t2.276\t0.281\t56\n16647\t1.966\t0.14\t51\n16648\t1.843\t0.124\t41\n16902\t1.739\t0.003\t2\n16903\t2.003\t-1.0\t1\n20491\t2.681\t-1.0\t1\n20492\t2.402\t0.287\t12\n20493\t2.373\t0.17\t6\n20499\t3.054\t0.395\t11\n20500\t3.076\t0.081\t2\n20501\t2.3\t1.168\t20\n20502\t2.221\t0.057\t3\n20503\t1.964\t-1.0\t1\n20504\t2.515\t0.236\t21\n20505\t1.97\t0.231\t70\n20506\t2.056\t0.352\t138\n20507\t2.553\t0.302\t81\n20508\t2.489\t0.321\t24\n20509\t2.215\t0.363\t36\n20510\t2.786\t0.026\t6\n20511\t2.418\t0.106\t10\n20517\t3.193\t0.063\t3\n20519\t2.598\t0.187\t9\n20520\t2.376\t0.309\t9\n20522\t2.708\t0.265\t154\n20524\t2.526\t0.319\t123\n20525\t2.262\t0.289\t122\n20526\t2.502\t0.287\t18\n20527\t2.365\t0.284\t11\n20528\t2.966\t0.038\t6\n20529\t2.584\t0.061\t7\n20530\t2.771\t0.387\t5\n20531\t1.29\t0.001\t12\n20535\t3.368\t0.154\t5\n20536\t3.023\t0.074\t6\n20537\t2.913\t0.0\t2\n20538\t3.021\t0.331\t2\n20540\t2.651\t0.201\t5\n20543\t2.735\t0.344\t5\n20546\t2.531\t0.277\t7\n20549\t3.267\t-1.0\t1\n20550\t2.329\t0.34\t7\n20552\t2.499\t0.02\t6\n20553\t2.703\t0.218\t20\n20554\t2.693\t0.292\t46\n20555\t2.639\t0.27\t40\n20556\t2.066\t0.059\t39\n20557\t2.599\t0.324\t183\n20558\t2.048\t0.149\t134\n20559\t2.327\t0.386\t34\n20560\t2.179\t-1.0\t1\n20561\t2.619\t-1.0\t1\n20562\t2.967\t-1.0\t1\n20570\t2.665\t0.007\t2\n20572\t2.63\t0.19\t9\n20742\t1.87\t0.155\t40\n24587\t3.525\t0.393\t28\n24588\t2.763\t0.313\t380\n24589\t2.462\t0.308\t5373\n24595\t4.077\t0.356\t19\n24596\t3.17\t0.362\t45\n24597\t2.829\t0.525\t432\n24598\t2.656\t0.164\t627\n24599\t2.654\t0.158\t57\n24600\t2.57\t0.26\t309\n24601\t2.625\t0.288\t208\n24602\t2.45\t0.223\t1004\n24603\t2.182\t0.257\t1071\n24604\t2.355\t0.185\t1159\n24605\t2.384\t0.162\t130\n24606\t2.479\t0.188\t1375\n24607\t2.547\t0.23\t805\n24613\t3.789\t0.188\t2\n24614\t3.484\t0.291\t8\n24615\t3.089\t0.34\t499\n24616\t2.809\t0.177\t912\n24617\t2.665\t0.147\t106\n24618\t2.632\t0.3\t598\n24620\t2.419\t0.207\t1127\n24621\t2.466\t0.217\t582\n24622\t2.456\t0.168\t1672\n24623\t2.573\t0.135\t12\n24624\t2.753\t0.503\t34\n24625\t2.695\t0.487\t478\n24626\t2.644\t0.444\t4321\n24627\t2.655\t0.961\t518\n24631\t3.712\t0.709\t3\n24632\t3.745\t0.575\t6\n24633\t3.382\t0.306\t128\n24634\t3.417\t0.336\t41\n24635\t3.236\t0.278\t27\n24636\t3.365\t0.272\t72\n24638\t3.236\t0.316\t52\n24639\t3.097\t0.0\t2\n24640\t2.718\t0.258\t39\n24641\t3.353\t0.103\t6\n24642\t3.087\t0.178\t51\n24643\t2.988\t0.348\t31\n24644\t2.995\t0.182\t58\n24645\t3.221\t0.798\t58\n24646\t3.104\t0.353\t86\n24647\t3.019\t0.515\t320\n24648\t2.735\t0.176\t341\n24649\t2.703\t0.204\t299\n24650\t2.595\t0.331\t829\n24651\t2.536\t0.58\t227\n24652\t2.472\t0.25\t206\n24653\t2.534\t0.168\t933\n24654\t2.491\t0.326\t1889\n24655\t2.445\t0.168\t254\n24656\t2.51\t0.162\t95\n24657\t3.004\t0.801\t27\n24658\t2.961\t0.516\t71\n24659\t3.105\t0.444\t106\n24666\t3.114\t0.326\t123\n24668\t3.098\t0.303\t230\n28685\t2.353\t0.307\t3006\n28693\t2.684\t0.241\t703\n28694\t2.452\t0.242\t3992\n28695\t2.409\t0.319\t1209\n28696\t2.464\t0.534\t2219\n28697\t2.577\t0.289\t2590\n28698\t2.456\t0.2\t6911\n28699\t2.41\t0.36\t7053\n28700\t2.487\t0.231\t7446\n28701\t2.406\t0.194\t9772\n28702\t2.479\t0.227\t5502\n28703\t2.471\t0.309\t929\n28711\t2.921\t0.239\t1714\n28712\t2.679\t0.232\t2798\n28713\t2.442\t0.272\t911\n28714\t2.445\t0.293\t2412\n28716\t2.475\t0.298\t2904\n28717\t2.428\t0.335\t1207\n28718\t2.458\t0.222\t3289\n28719\t2.487\t0.247\t1033\n28720\t2.81\t0.231\t768\n28721\t2.785\t0.35\t616\n28722\t2.606\t0.37\t1703\n28723\t2.599\t0.29\t531\n28729\t3.125\t0.329\t626\n28730\t3.082\t0.337\t728\n28731\t3.179\t0.249\t153\n28732\t3.022\t0.208\t458\n28734\t3.032\t0.245\t890\n28735\t3.194\t0.258\t616\n28736\t3.148\t0.29\t455\n28737\t3.124\t0.266\t301\n28738\t3.028\t0.263\t602\n28739\t2.987\t0.306\t159\n28740\t2.919\t0.28\t496\n28741\t3.182\t0.365\t119\n28742\t2.892\t0.229\t1179\n28743\t2.821\t0.212\t549\n28744\t2.607\t0.225\t683\n28745\t2.503\t0.227\t1194\n28746\t2.395\t0.326\t1012\n28747\t2.447\t0.267\t941\n28748\t2.383\t0.233\t326\n28749\t2.511\t0.279\t970\n28750\t2.457\t0.24\t1884\n28751\t2.393\t0.172\t533\n28752\t2.849\t0.285\t194\n28753\t2.973\t0.272\t62\n28754\t2.876\t0.236\t326\n28755\t2.753\t0.232\t424\n28762\t3.088\t0.249\t588\n28764\t2.972\t0.34\t2780\n28765\t3.016\t0.335\t10\n28766\t3.297\t0.204\t7\n32781\t2.145\t0.448\t7124\n32789\t2.625\t0.845\t799\n32790\t2.338\t0.282\t13095\n32791\t2.352\t0.77\t18035\n32792\t2.299\t0.427\t5228\n32793\t2.387\t0.292\t15567\n32794\t2.358\t0.225\t12153\n32795\t2.38\t0.29\t13623\n32796\t2.421\t0.301\t14996\n32797\t2.272\t0.223\t19019\n32798\t2.378\t0.357\t12982\n32799\t2.317\t0.208\t831\n32807\t2.796\t0.315\t3153\n32808\t2.497\t0.249\t4631\n32809\t2.375\t0.365\t1523\n32810\t2.347\t0.467\t31965\n32812\t2.419\t0.158\t3311\n32813\t2.436\t0.193\t2109\n32814\t2.4\t0.154\t2649\n32815\t2.661\t0.256\t865\n32816\t2.694\t0.218\t2847\n32817\t2.616\t0.276\t949\n32818\t2.579\t0.438\t4702\n32819\t2.309\t0.553\t1993\n32825\t2.994\t0.343\t2113\n32826\t2.856\t0.3\t2621\n32827\t2.93\t0.228\t1218\n32828\t2.905\t0.207\t2518\n32830\t2.869\t0.237\t2353\n32831\t2.827\t0.209\t3697\n32832\t2.834\t0.197\t5222\n32833\t2.78\t0.177\t4383\n32834\t2.738\t0.205\t8482\n32835\t2.747\t0.193\t1707\n32836\t2.742\t0.193\t2196\n32837\t2.798\t0.21\t502\n32838\t2.734\t0.235\t2716\n32839\t2.767\t0.212\t885\n32840\t2.498\t0.29\t774\n32841\t2.373\t0.261\t1221\n32842\t2.285\t0.417\t9618\n32843\t2.218\t0.348\t3304\n32844\t2.411\t0.2\t303\n32845\t2.462\t0.304\t1297\n32846\t2.393\t0.203\t1953\n32847\t2.305\t0.24\t286\n32848\t2.736\t0.309\t162\n32849\t2.822\t0.336\t202\n32850\t2.624\t0.233\t1404\n32851\t2.579\t0.268\t1906\n32858\t2.759\t0.291\t759\n32860\t2.611\t0.412\t7083\n32861\t2.503\t0.425\t287\n32862\t2.802\t0.399\t255\n32863\t2.837\t0.483\t20\n32864\t3.097\t0.448\t5\n32865\t2.94\t0.02\t3\n32866\t2.916\t0.021\t3\n36877\t1.811\t0.461\t1163\n36885\t2.022\t0.295\t129\n36886\t2.262\t0.492\t1106\n36887\t2.576\t0.889\t536\n36888\t1.937\t0.267\t474\n36889\t2.093\t0.73\t296\n36890\t1.929\t0.743\t373\n36891\t2.283\t0.257\t113\n36892\t2.221\t0.196\t116\n36893\t2.345\t0.817\t110\n36894\t2.065\t0.336\t75\n36895\t2.412\t0.358\t76\n36903\t2.125\t0.259\t44\n36904\t2.154\t1.055\t667\n36905\t2.12\t0.459\t502\n36906\t2.031\t0.453\t512\n36908\t2.395\t0.388\t43\n36909\t2.339\t0.338\t54\n36910\t2.361\t0.307\t101\n36911\t2.57\t0.191\t9\n36912\t2.427\t0.207\t26\n36913\t2.059\t1.008\t121\n36914\t2.126\t0.626\t419\n36915\t2.193\t0.262\t8674\n36921\t2.731\t0.286\t10\n36922\t2.995\t1.207\t51\n36923\t2.406\t0.044\t8\n36924\t2.742\t0.246\t33\n36926\t2.795\t0.182\t52\n36927\t2.799\t0.303\t24\n36928\t2.454\t0.018\t4\n36929\t1.96\t0.0\t6\n36930\t2.434\t0.192\t19\n36931\t2.857\t-1.0\t1\n36932\t2.747\t0.211\t25\n36934\t2.687\t0.139\t19\n36935\t2.806\t0.003\t4\n36936\t2.107\t0.444\t90\n36937\t2.149\t0.225\t250\n36938\t1.882\t0.247\t232\n36939\t2.0\t0.93\t274\n36940\t2.276\t0.144\t56\n36941\t2.293\t1.188\t69\n36942\t2.356\t0.364\t53\n36943\t1.893\t0.555\t149\n36944\t2.373\t0.0\t2\n36945\t2.015\t0.261\t45\n36946\t2.333\t0.203\t37\n36947\t2.152\t0.196\t94\n36954\t2.666\t0.268\t30\n36955\t2.205\t0.007\t16\n36956\t2.285\t0.379\t153\n36957\t2.26\t0.017\t10\n45067\t3.369\t0.477\t389\n45068\t3.242\t-1.0\t1\n45069\t3.524\t0.425\t2\n45070\t3.558\t0.0\t2\n45075\t3.592\t0.346\t36\n45076\t3.383\t0.133\t22\n45081\t3.221\t0.182\t3\n45082\t2.923\t0.336\t4\n45083\t3.382\t-1.0\t1\n45084\t2.961\t0.097\t3\n45087\t3.136\t-1.0\t1\n45088\t3.161\t0.174\t9\n45093\t3.645\t0.249\t17\n45094\t3.529\t0.167\t10\n45101\t3.618\t-1.0\t1\n45106\t3.243\t0.311\t72\n45107\t3.33\t0.219\t17\n45111\t3.704\t0.248\t22\n45112\t3.585\t0.155\t9\n45134\t3.136\t-1.0\t1\n45136\t3.234\t0.09\t7\n45137\t3.405\t0.105\t12\n45138\t3.441\t0.118\t15\n45139\t3.281\t0.068\t7\n45317\t3.245\t0.017\t2\n45318\t3.261\t0.178\t294\n45573\t2.685\t-1.0\t1\n45574\t3.187\t0.261\t35\n49164\t3.052\t0.123\t490\n49165\t3.401\t-1.0\t1\n49166\t2.887\t0.569\t39\n49171\t4.275\t0.055\t2\n49172\t3.412\t0.019\t8\n49177\t3.408\t-1.0\t1\n49178\t3.072\t0.063\t8\n49181\t3.334\t0.086\t3\n49182\t3.217\t0.061\t2\n49183\t2.836\t0.772\t13\n49184\t2.807\t0.438\t17\n49190\t3.648\t0.307\t28\n49191\t2.187\t0.0\t6\n49194\t2.466\t0.0\t2\n49197\t2.818\t0.099\t91\n49202\t2.927\t0.036\t9\n49203\t2.862\t0.432\t19\n49207\t3.807\t0.0\t2\n49208\t3.659\t0.045\t20\n49209\t3.53\t0.075\t16\n49210\t3.447\t0.003\t12\n49211\t3.506\t0.0\t3\n49212\t3.54\t0.0\t3\n49214\t3.463\t0.0\t3\n49215\t3.48\t0.014\t8\n49216\t3.364\t0.0\t3\n49221\t3.144\t0.0\t12\n49229\t2.7\t0.086\t48\n49230\t3.087\t0.019\t2\n49233\t3.145\t0.004\t2\n49413\t2.826\t0.154\t5\n49414\t2.811\t0.216\t411\n49670\t2.681\t0.238\t49\n53261\t3.147\t0.471\t69\n53262\t3.263\t0.176\t31\n53263\t3.143\t0.346\t218\n53264\t2.983\t0.385\t264\n53265\t2.601\t0.322\t2017\n53268\t3.669\t-1.0\t1\n53272\t2.557\t-1.0\t1\n53273\t2.309\t-1.0\t1\n53274\t2.908\t0.179\t18\n53275\t2.828\t0.234\t10\n53276\t2.655\t0.245\t6\n53277\t2.352\t0.06\t13\n53278\t3.3\t0.187\t3\n53279\t3.414\t0.37\t3\n53280\t2.499\t0.185\t12\n53281\t2.448\t0.051\t41\n53282\t2.875\t0.469\t72\n53283\t2.741\t0.288\t381\n53286\t3.495\t0.045\t15\n53292\t2.999\t-1.0\t1\n53293\t3.023\t0.354\t19\n53294\t2.951\t0.089\t21\n53295\t3.08\t-1.0\t1\n53297\t3.715\t-1.0\t1\n53298\t3.418\t0.0\t2\n53299\t2.655\t0.502\t19\n53300\t2.915\t0.495\t30\n53301\t3.049\t0.382\t137\n53303\t2.804\t1.394\t2\n53304\t3.582\t0.06\t4\n53305\t3.584\t0.347\t3\n53308\t3.56\t0.086\t2\n53322\t3.218\t0.048\t2\n53325\t3.468\t0.243\t2\n53326\t3.202\t0.139\t4\n53331\t3.74\t0.255\t4\n53340\t4.01\t0.006\t2\n53509\t2.605\t0.31\t8\n53510\t2.407\t0.249\t1700\n53511\t2.374\t0.163\t1982\n53512\t2.216\t0.23\t533\n53519\t2.935\t0.196\t5\n53520\t2.843\t0.186\t40\n53766\t2.468\t0.199\t96\n53767\t2.448\t0.135\t44\n53768\t1.978\t0.199\t4\n57363\t4.548\t0.464\t19\n57364\t3.083\t0.417\t13\n57366\t3.671\t0.019\t4\n57367\t3.246\t0.035\t4\n57368\t2.795\t0.193\t8\n57369\t2.811\t0.292\t27\n57370\t2.847\t0.192\t233\n57371\t2.715\t0.262\t77\n57372\t2.749\t0.228\t147\n57373\t2.884\t0.306\t43\n57374\t3.288\t0.273\t42\n57375\t3.561\t0.36\t4\n57382\t3.347\t0.097\t2\n57384\t3.775\t0.176\t18\n57385\t3.436\t0.115\t26\n57386\t3.224\t0.255\t49\n57388\t2.956\t0.338\t151\n57389\t2.78\t0.227\t106\n57390\t2.921\t0.275\t97\n57391\t3.357\t0.302\t20\n57393\t3.19\t0.085\t14\n57394\t3.662\t0.527\t210\n57395\t3.917\t0.191\t58\n57399\t3.91\t0.0\t4\n57400\t3.327\t0.062\t5\n57402\t3.01\t0.585\t8\n57406\t4.511\t0.25\t17\n57407\t4.503\t0.08\t6\n57409\t3.926\t0.003\t2\n57411\t3.905\t0.012\t2\n57414\t4.362\t0.205\t19\n57416\t3.87\t0.205\t13\n57417\t3.437\t0.24\t5\n57418\t3.085\t0.21\t66\n57419\t2.96\t0.12\t14\n57420\t3.028\t0.125\t7\n57421\t2.797\t0.286\t150\n57422\t2.978\t0.215\t175\n57423\t2.761\t0.465\t12\n57424\t3.53\t0.211\t22\n57426\t3.874\t0.316\t17\n57427\t4.031\t0.321\t9\n61461\t3.38\t0.299\t100\n61462\t3.21\t0.369\t276\n61463\t3.131\t0.207\t110\n61464\t2.873\t0.244\t730\n61465\t2.696\t0.32\t774\n61466\t2.697\t0.243\t4802\n61467\t2.679\t0.235\t3056\n61468\t2.676\t0.196\t4702\n61469\t2.64\t0.179\t5253\n61470\t2.912\t0.244\t119\n61471\t3.023\t0.242\t152\n61479\t3.617\t0.27\t57\n61480\t3.41\t0.235\t240\n61481\t3.284\t0.297\t129\n61482\t3.002\t0.261\t2058\n61484\t2.758\t0.203\t6616\n61485\t2.714\t0.205\t4052\n61486\t2.713\t0.193\t6710\n61487\t2.863\t0.16\t1964\n61488\t3.199\t0.271\t42\n61489\t3.285\t0.255\t93\n61490\t3.243\t0.31\t221\n61491\t3.183\t0.277\t77\n61497\t3.201\t0.305\t27\n61498\t2.934\t0.476\t9\n61500\t3.451\t0.1\t14\n61502\t3.794\t0.117\t26\n61506\t3.579\t0.083\t13\n61507\t3.584\t0.109\t8\n61508\t3.774\t0.0\t2\n61510\t3.577\t0.217\t22\n61511\t3.739\t0.336\t7\n61512\t3.408\t0.222\t72\n61513\t3.244\t0.257\t147\n61514\t3.003\t0.256\t1665\n61515\t2.906\t0.239\t1623\n61516\t2.798\t0.241\t1057\n61517\t2.754\t0.215\t2863\n61518\t2.714\t0.201\t6668\n61519\t2.668\t0.172\t4216\n61520\t2.879\t0.203\t76\n61521\t3.471\t0.204\t33\n61522\t3.487\t0.164\t39\n61523\t3.141\t0.234\t30\n61530\t3.726\t0.298\t60\n61532\t3.891\t0.328\t80\n65557\t3.412\t0.368\t35\n65558\t2.901\t0.267\t387\n65559\t2.852\t0.348\t489\n65560\t2.881\t0.289\t268\n65561\t2.726\t0.281\t883\n65562\t2.718\t0.226\t7921\n65563\t2.724\t0.272\t1489\n65564\t2.606\t0.234\t5975\n65565\t2.755\t0.225\t5038\n65566\t2.788\t0.225\t1360\n65567\t2.767\t0.214\t227\n65575\t3.418\t0.184\t159\n65576\t3.376\t0.277\t123\n65577\t2.954\t0.528\t373\n65578\t2.911\t0.288\t3355\n65580\t2.816\t0.192\t1907\n65581\t2.839\t0.173\t765\n65582\t2.775\t0.192\t2485\n65583\t3.093\t0.232\t4438\n65584\t3.087\t0.238\t609\n65585\t3.111\t0.393\t484\n65586\t2.949\t0.477\t1247\n65587\t2.995\t0.415\t696\n65593\t3.611\t0.276\t65\n65594\t3.5\t0.164\t59\n65595\t3.551\t0.145\t18\n65596\t3.459\t0.169\t45\n65598\t3.453\t0.18\t175\n65599\t3.683\t0.232\t44\n65600\t3.412\t0.05\t10\n65601\t3.114\t0.282\t6\n65602\t3.516\t0.333\t73\n65603\t3.018\t0.572\t5\n65604\t3.488\t0.196\t81\n65605\t3.266\t0.272\t10\n65606\t3.254\t0.188\t179\n65607\t3.336\t0.194\t34\n65608\t3.554\t0.326\t21\n65609\t2.461\t0.31\t329\n65610\t2.919\t0.288\t2082\n65611\t2.8\t0.267\t1996\n65612\t2.475\t0.252\t240\n65613\t2.833\t0.153\t655\n65614\t2.73\t0.196\t2208\n65615\t2.776\t0.277\t3697\n65616\t2.944\t0.23\t538\n65617\t3.031\t0.277\t17\n65618\t3.147\t0.26\t222\n65619\t3.099\t0.284\t350\n65626\t3.319\t0.35\t170\n65628\t3.382\t0.265\t290\n65629\t3.399\t0.077\t8\n65630\t2.931\t0.387\t17\n65631\t3.438\t0.046\t3\n65632\t3.441\t0.047\t3\n69653\t3.008\t0.308\t233\n69654\t2.799\t0.246\t2597\n69655\t2.789\t0.215\t490\n69656\t2.8\t0.199\t1394\n69657\t2.875\t0.267\t1182\n69658\t2.712\t0.238\t3474\n69659\t2.694\t0.227\t2713\n69660\t2.758\t0.28\t2082\n69661\t2.701\t0.25\t5780\n69662\t2.642\t0.425\t3822\n69663\t2.661\t0.254\t1485\n69671\t3.218\t0.274\t409\n69672\t2.991\t0.248\t1900\n69673\t2.903\t0.356\t1449\n69674\t2.907\t0.475\t2267\n69676\t2.885\t0.203\t5377\n69677\t2.863\t0.235\t2604\n69678\t2.776\t0.213\t6900\n69679\t3.032\t0.245\t617\n69680\t2.974\t0.221\t1026\n69681\t2.957\t0.377\t932\n69682\t2.928\t0.391\t2452\n69683\t2.872\t0.46\t1745\n69689\t3.393\t0.345\t120\n69690\t3.542\t0.471\t133\n69691\t3.384\t0.328\t54\n69692\t3.319\t0.289\t122\n69694\t3.354\t0.248\t151\n69695\t3.179\t0.349\t113\n69696\t3.251\t0.372\t116\n69697\t3.069\t0.3\t85\n69698\t3.114\t0.336\t295\n69699\t3.273\t0.344\t35\n69700\t3.214\t0.336\t160\n69701\t2.947\t0.43\t25\n69702\t3.224\t0.207\t183\n69703\t3.182\t0.198\t73\n69704\t2.972\t0.302\t357\n69705\t2.911\t0.327\t1000\n69706\t2.885\t0.369\t1787\n69707\t2.801\t0.257\t2221\n69708\t2.851\t0.255\t681\n69709\t2.879\t0.222\t2186\n69710\t2.757\t0.265\t4336\n69711\t2.675\t0.201\t2687\n69712\t2.804\t0.27\t1229\n69713\t2.554\t0.473\t192\n69714\t3.224\t0.457\t625\n69715\t3.107\t0.371\t1402\n69722\t3.417\t0.306\t157\n69723\t2.64\t0.0\t4\n69724\t3.21\t0.343\t893\n69725\t3.181\t0.284\t122\n69726\t3.088\t0.296\t154\n69727\t2.915\t-1.0\t1\n69728\t2.915\t-1.0\t1\n69729\t2.465\t0.0\t6\n77843\t3.904\t0.444\t476\n77844\t3.931\t0.219\t13\n77847\t3.213\t0.001\t2\n77848\t3.318\t0.114\t5\n77849\t3.574\t0.313\t3\n77850\t3.205\t-1.0\t1\n77851\t3.463\t0.411\t4\n77852\t3.491\t0.534\t2\n77853\t3.822\t0.039\t3\n77854\t3.511\t0.765\t6\n77856\t3.502\t0.647\t78\n77861\t3.9\t0.078\t12\n77862\t3.806\t0.091\t8\n77864\t3.807\t-1.0\t1\n77865\t3.535\t0.137\t7\n77870\t3.386\t0.218\t17\n77871\t3.245\t0.006\t2\n77874\t3.754\t0.595\t67\n77875\t3.655\t0.42\t25\n77879\t3.899\t0.365\t31\n77880\t4.729\t0.676\t2\n77898\t4.496\t0.606\t3\n77902\t3.48\t0.0\t4\n77905\t3.736\t0.08\t11\n77906\t3.724\t0.099\t26\n77907\t3.562\t0.045\t4\n77917\t4.592\t-1.0\t1\n78085\t3.76\t0.113\t8\n78086\t3.713\t0.29\t1287\n78342\t3.557\t0.28\t73\n81940\t3.661\t0.289\t176\n81943\t3.019\t-1.0\t1\n81944\t2.85\t-1.0\t1\n81945\t3.324\t0.0\t2\n81951\t3.151\t-1.0\t1\n81952\t3.185\t0.116\t25\n81957\t3.75\t0.247\t3\n81958\t3.579\t0.106\t3\n81967\t3.517\t0.128\t5\n81969\t3.26\t0.128\t3\n81970\t3.346\t0.13\t71\n81971\t3.246\t0.132\t128\n81975\t3.895\t0.219\t5\n81976\t3.719\t0.202\t10\n81997\t3.133\t0.007\t2\n81999\t3.088\t0.086\t20\n82000\t3.26\t0.098\t4\n82001\t3.332\t-1.0\t1\n82002\t3.427\t0.083\t10\n82003\t3.25\t0.171\t45\n82012\t3.805\t-1.0\t1\n82182\t3.212\t0.212\t411\n82438\t2.973\t0.227\t13\n86044\t2.357\t-1.0\t1\n86050\t3.301\t0.106\t5\n86051\t3.223\t0.408\t15\n86053\t3.906\t-1.0\t1\n86062\t2.711\t0.034\t2\n86068\t3.534\t0.111\t4\n86069\t3.014\t0.266\t86\n86277\t3.132\t0.206\t3\n86278\t3.08\t0.205\t1002\n86279\t2.704\t0.168\t460\n86280\t2.561\t0.163\t44\n86287\t3.292\t0.078\t26\n86288\t3.128\t0.068\t7\n86534\t2.902\t0.101\t13\n86535\t2.446\t0.18\t5\n90134\t3.158\t0.093\t9\n90138\t2.576\t0.185\t3\n90139\t2.835\t0.161\t13\n90140\t2.925\t0.174\t8\n90141\t3.761\t-1.0\t1\n90143\t3.058\t0.0\t2\n90144\t2.522\t0.784\t3\n90145\t2.482\t0.209\t46\n90146\t3.164\t0.558\t44\n90147\t2.774\t0.281\t113\n90150\t3.233\t0.034\t7\n90156\t3.193\t-1.0\t1\n90157\t2.921\t-1.0\t1\n90161\t3.271\t0.0\t2\n90162\t3.869\t0.023\t3\n90163\t3.573\t0.143\t28\n90164\t3.347\t0.022\t18\n90165\t2.62\t0.414\t54\n90168\t3.427\t0.036\t8\n90194\t3.897\t-1.0\t1\n90373\t3.171\t0.268\t3\n90374\t2.926\t0.185\t13105\n90375\t2.587\t0.178\t1875\n90376\t2.456\t0.185\t917\n90383\t3.113\t0.322\t22\n90384\t3.044\t0.167\t14\n90630\t2.624\t0.183\t73\n90631\t2.431\t0.217\t59\n90632\t2.541\t0.214\t13\n94231\t2.269\t0.138\t9\n94234\t2.503\t0.095\t6\n94235\t2.637\t0.592\t3\n94236\t3.236\t0.203\t2\n94242\t2.529\t0.487\t29\n94243\t2.969\t0.254\t17\n94264\t3.486\t-1.0\t1\n94286\t2.784\t0.083\t10\n94470\t2.664\t0.196\t1656\n94471\t2.46\t0.141\t1730\n94472\t2.373\t0.21\t563\n94479\t3.002\t0.084\t9\n94480\t2.809\t0.211\t72\n94726\t2.339\t0.204\t93\n94727\t2.461\t0.173\t28\n94728\t2.22\t0.033\t36\n98328\t2.585\t0.33\t139\n98329\t3.026\t0.483\t6\n98330\t3.053\t0.116\t7\n98331\t2.861\t0.157\t7\n98332\t3.016\t0.06\t2\n98333\t2.906\t-1.0\t1\n98334\t3.171\t-1.0\t1\n98335\t2.778\t0.078\t6\n98336\t2.83\t0.006\t4\n98337\t2.984\t0.301\t63\n98338\t3.557\t0.536\t97\n98339\t2.852\t0.31\t66\n98341\t3.47\t0.104\t3\n98349\t3.572\t-1.0\t1\n98350\t3.259\t0.092\t4\n98354\t3.11\t0.137\t19\n98355\t3.017\t0.193\t20\n98356\t3.203\t0.219\t43\n98357\t3.129\t0.376\t67\n98378\t3.04\t-1.0\t1\n98381\t3.568\t-1.0\t1\n98382\t3.15\t0.188\t5\n98383\t3.133\t0.037\t3\n98384\t3.045\t0.0\t2\n98386\t3.121\t0.097\t12\n98387\t3.325\t0.016\t2\n98565\t2.688\t0.12\t18\n98566\t2.619\t0.153\t6878\n98567\t2.404\t0.141\t2515\n98568\t2.41\t0.174\t638\n98575\t3.098\t0.146\t259\n98576\t2.876\t0.25\t37\n98822\t2.158\t0.152\t4143\n98823\t2.42\t0.131\t56\n98824\t2.468\t0.236\t5\n102425\t3.087\t0.258\t19\n102426\t2.867\t0.103\t4\n102427\t3.03\t0.131\t2\n102428\t2.886\t-1.0\t1\n102431\t3.326\t0.375\t7\n102432\t2.775\t0.168\t35\n102433\t2.737\t0.092\t14\n102434\t3.052\t0.275\t320\n102435\t2.947\t0.279\t501\n102438\t3.136\t0.442\t2\n102442\t3.198\t-1.0\t1\n102444\t2.998\t0.081\t3\n102445\t2.848\t0.318\t2\n102447\t3.116\t0.312\t4\n102449\t2.668\t0.007\t12\n102450\t2.65\t0.156\t37\n102451\t2.804\t0.128\t97\n102452\t3.71\t0.389\t143\n102453\t3.196\t0.352\t77\n102476\t2.993\t0.038\t4\n102478\t3.256\t-1.0\t1\n102479\t3.089\t0.272\t5\n102480\t2.61\t0.003\t4\n102481\t3.397\t-1.0\t1\n102482\t2.754\t0.035\t4\n102483\t2.878\t0.096\t25\n102661\t2.718\t0.111\t3\n102662\t2.482\t0.226\t2788\n102663\t2.511\t0.177\t8370\n102664\t2.493\t0.179\t2602\n102671\t2.643\t0.184\t45\n102672\t2.962\t0.176\t53\n102918\t2.052\t0.149\t4796\n102919\t2.51\t0.179\t433\n102920\t2.374\t0.161\t19\n106522\t2.941\t0.371\t219\n106523\t2.892\t0.261\t5\n106524\t2.877\t0.111\t7\n106525\t2.863\t0.149\t85\n106526\t2.98\t0.096\t34\n106527\t2.834\t0.242\t89\n106528\t2.743\t0.335\t128\n106529\t2.701\t0.254\t143\n106530\t2.739\t0.223\t715\n106531\t2.904\t0.242\t866\n106536\t3.002\t0.349\t8\n106537\t2.799\t0.229\t2\n106538\t3.086\t0.144\t4\n106540\t2.735\t0.302\t14\n106541\t2.768\t0.387\t2\n106542\t3.159\t0.157\t17\n106543\t2.781\t0.205\t11\n106545\t3.031\t0.266\t33\n106546\t3.013\t0.266\t96\n106547\t2.844\t0.229\t38\n106548\t2.92\t0.185\t202\n106549\t3.146\t0.267\t200\n106551\t3.701\t0.004\t2\n106552\t3.508\t0.08\t2\n106554\t3.692\t-1.0\t1\n106556\t3.882\t-1.0\t1\n106566\t3.665\t0.215\t7\n106570\t3.257\t0.114\t4\n106571\t2.863\t0.015\t4\n106572\t2.976\t0.164\t5\n106574\t3.224\t0.085\t11\n106575\t2.779\t0.247\t4\n106576\t2.981\t0.124\t18\n106577\t3.014\t0.072\t10\n106579\t3.124\t0.117\t28\n106757\t2.221\t0.408\t15\n106758\t2.401\t0.141\t81624\n106759\t2.351\t0.184\t21226\n106760\t2.431\t0.13\t2185\n106767\t2.782\t0.218\t230\n106768\t2.742\t0.183\t221\n107014\t2.077\t0.157\t13871\n107015\t2.286\t0.144\t1126\n107016\t2.261\t0.186\t6\n107023\t2.555\t-1.0\t1\n110619\t2.657\t0.367\t240\n110620\t2.816\t0.234\t12\n110621\t2.849\t0.093\t2\n110622\t2.914\t0.068\t12\n110623\t2.683\t0.337\t23\n110624\t2.349\t0.547\t34\n110625\t2.914\t0.287\t44\n110626\t2.37\t0.334\t254\n110627\t2.823\t0.245\t593\n110629\t3.216\t-1.0\t1\n110632\t3.168\t0.262\t18\n110633\t3.517\t-1.0\t1\n110634\t3.188\t-1.0\t1\n110636\t2.935\t0.025\t5\n110637\t2.659\t0.073\t4\n110638\t2.964\t0.14\t43\n110641\t2.808\t0.245\t6\n110642\t2.669\t0.36\t18\n110643\t2.899\t0.004\t2\n110644\t2.907\t0.266\t28\n110645\t3.111\t0.233\t239\n110654\t3.746\t0.042\t4\n110664\t3.213\t0.095\t2\n110665\t3.535\t-1.0\t1\n110666\t3.211\t-1.0\t1\n110669\t2.652\t-1.0\t1\n110670\t3.108\t0.335\t20\n110671\t3.078\t0.114\t48\n110672\t2.505\t0.007\t4\n110673\t2.66\t0.009\t3\n110674\t2.75\t0.014\t4\n110675\t2.821\t0.241\t50\n110682\t3.786\t-1.0\t1\n110684\t3.602\t0.211\t2\n110853\t2.51\t0.032\t24\n110854\t2.424\t0.18\t7855\n110855\t2.35\t0.165\t15280\n110856\t2.397\t0.151\t2600\n110863\t2.753\t0.315\t114\n110864\t2.718\t0.212\t256\n111110\t2.057\t0.162\t5916\n111111\t2.347\t0.183\t580\n111120\t3.119\t-1.0\t1\n114716\t2.861\t0.204\t423\n114717\t2.956\t0.144\t62\n114718\t3.07\t0.105\t55\n114719\t2.884\t0.235\t61\n114720\t2.67\t0.388\t26\n114721\t2.959\t0.219\t18\n114722\t2.832\t0.233\t173\n114723\t2.869\t0.229\t1269\n114727\t2.635\t0.109\t4\n114728\t2.753\t-1.0\t1\n114730\t2.796\t0.0\t2\n114733\t2.529\t0.017\t3\n114737\t2.923\t0.325\t25\n114738\t3.191\t0.145\t154\n114739\t3.085\t0.122\t9\n114740\t3.439\t0.421\t52\n114741\t3.061\t0.179\t190\n114743\t3.288\t-1.0\t1\n114745\t2.617\t0.062\t2\n114759\t3.289\t0.325\t3\n114760\t2.798\t-1.0\t1\n114762\t2.961\t-1.0\t1\n114765\t2.702\t-1.0\t1\n114766\t3.089\t0.135\t10\n114767\t3.047\t0.066\t62\n114768\t3.431\t0.011\t4\n114769\t3.198\t-1.0\t1\n114770\t3.331\t0.009\t16\n114771\t3.287\t0.091\t62\n114780\t3.048\t-1.0\t1\n114949\t2.438\t0.289\t13\n114950\t2.447\t0.207\t5143\n114951\t2.359\t0.153\t15318\n114952\t2.422\t0.153\t2635\n114959\t2.635\t0.231\t43\n114960\t2.669\t0.201\t795\n115206\t2.167\t0.159\t1651\n115207\t2.384\t0.147\t685\n115208\t2.377\t-1.0\t1\n118813\t2.913\t0.463\t3054\n118814\t2.839\t0.079\t11\n118815\t2.711\t0.001\t4\n118816\t2.916\t0.195\t36\n118817\t2.906\t0.257\t48\n118818\t3.003\t0.19\t1185\n118819\t2.89\t0.233\t2162\n118821\t4.015\t-1.0\t1\n118826\t2.96\t-1.0\t1\n118828\t2.952\t0.11\t39\n118829\t2.507\t0.024\t3\n118830\t2.938\t0.19\t22\n118831\t2.849\t0.2\t37\n118834\t2.765\t0.134\t305\n118835\t3.108\t0.155\t31\n118836\t3.39\t0.219\t189\n118837\t3.139\t0.235\t3644\n118839\t3.839\t-1.0\t1\n118858\t2.994\t-1.0\t1\n118861\t2.937\t0.024\t4\n118862\t2.749\t0.231\t11\n118863\t3.089\t0.14\t128\n118864\t2.73\t0.419\t10\n118867\t4.236\t-1.0\t1\n119046\t2.301\t0.205\t1784\n119047\t2.304\t0.132\t28601\n119048\t2.278\t0.16\t3943\n119055\t2.752\t0.18\t205\n119056\t2.764\t0.209\t1501\n119302\t2.425\t0.207\t1326\n119303\t2.302\t0.163\t1333\n119304\t2.514\t0.012\t2\n122910\t2.933\t0.511\t46\n122911\t2.702\t0.368\t7\n122912\t2.663\t0.513\t47\n122913\t2.561\t0.197\t22\n122914\t2.985\t0.238\t269\n122915\t2.799\t0.235\t1020\n122917\t3.448\t-1.0\t1\n122920\t3.428\t0.0\t2\n122922\t3.262\t0.063\t13\n122924\t3.141\t0.257\t36\n122925\t3.024\t0.038\t68\n122926\t3.08\t0.273\t30\n122929\t3.163\t0.018\t2\n122930\t2.751\t0.402\t11\n122932\t3.359\t0.441\t18\n122933\t3.021\t0.24\t382\n122935\t3.714\t-1.0\t1\n122955\t3.014\t0.026\t6\n122957\t3.238\t0.02\t4\n122958\t3.092\t0.105\t29\n122960\t3.074\t0.0\t2\n122961\t2.928\t0.007\t10\n122962\t3.518\t0.023\t8\n122963\t2.553\t0.0\t2\n123142\t2.737\t0.301\t850\n123143\t2.41\t0.137\t13630\n123144\t2.395\t0.157\t2260\n123151\t2.989\t0.176\t11\n123152\t2.86\t0.169\t504\n123398\t2.392\t0.233\t92\n123399\t2.348\t0.155\t241\n127007\t3.02\t0.246\t86\n127008\t2.974\t0.088\t8\n127009\t3.494\t0.451\t21\n127010\t2.829\t0.38\t37\n127011\t2.708\t0.245\t196\n127014\t3.469\t0.079\t7\n127016\t3.23\t0.0\t2\n127018\t3.049\t0.131\t23\n127020\t2.953\t0.101\t22\n127021\t3.009\t0.238\t45\n127022\t3.086\t0.158\t56\n127023\t3.058\t0.009\t4\n127025\t3.335\t0.196\t5\n127026\t3.283\t0.062\t7\n127027\t2.651\t0.769\t24\n127028\t3.434\t0.203\t18\n127029\t3.123\t0.373\t261\n127031\t3.789\t0.084\t6\n127032\t4.457\t-1.0\t1\n127033\t3.667\t-1.0\t1\n127036\t4.074\t0.0\t2\n127039\t4.048\t-1.0\t1\n127046\t4.093\t-1.0\t1\n127050\t2.953\t0.101\t7\n127052\t3.076\t0.218\t4\n127053\t3.176\t0.156\t3\n127054\t2.924\t0.124\t38\n127055\t2.909\t0.082\t10\n127059\t4.205\t0.525\t4\n127068\t3.948\t0.013\t2\n127237\t2.513\t0.281\t7\n127238\t2.422\t0.173\t417\n127239\t2.418\t0.176\t782\n127240\t2.39\t0.178\t153\n127247\t2.978\t0.075\t57\n127248\t2.775\t0.184\t61\n127494\t2.47\t0.44\t42\n127495\t2.406\t0.044\t2\n131109\t3.618\t0.424\t54\n131110\t3.321\t0.053\t36\n131111\t2.973\t0.025\t4\n131112\t3.771\t0.94\t5\n131113\t3.619\t0.341\t9\n131114\t3.143\t0.38\t30\n131116\t2.916\t0.159\t157\n131117\t2.917\t0.159\t121\n131118\t3.04\t0.268\t107\n131119\t2.922\t0.222\t15\n131120\t3.307\t0.038\t4\n131122\t3.411\t0.477\t35\n131123\t3.351\t-1.0\t1\n131127\t3.814\t0.114\t37\n131128\t3.49\t0.107\t29\n131130\t2.988\t0.0\t6\n131137\t2.864\t-1.0\t1\n131138\t3.615\t0.013\t2\n131144\t3.909\t0.169\t5\n131146\t3.079\t0.227\t59\n131147\t2.946\t0.309\t17\n131148\t2.938\t0.152\t48\n131149\t2.889\t0.075\t105\n131150\t2.932\t0.142\t86\n131151\t2.965\t0.315\t19\n131154\t4.158\t0.0\t3\n131155\t3.469\t0.0\t2\n135208\t3.392\t0.193\t9\n135209\t2.553\t0.506\t113\n135210\t2.846\t0.341\t42\n135212\t2.866\t0.212\t135\n135213\t2.927\t0.123\t16\n135214\t2.871\t0.163\t78\n135215\t2.95\t0.206\t41\n135216\t2.799\t0.488\t10\n135217\t2.858\t0.374\t47\n135218\t3.171\t0.414\t88\n135219\t3.525\t0.292\t6\n135226\t2.999\t0.0\t6\n135230\t3.926\t0.069\t11\n135234\t3.555\t0.069\t7\n135237\t4.014\t0.007\t2\n135240\t2.589\t0.032\t8\n135241\t2.464\t0.036\t10\n135242\t2.986\t0.141\t77\n135243\t2.924\t-1.0\t1\n135244\t2.773\t0.037\t5\n135245\t3.046\t0.0\t2\n135246\t2.825\t0.185\t175\n135247\t2.784\t0.162\t65\n135248\t3.475\t0.422\t13\n135249\t3.243\t0.492\t4\n135250\t3.627\t0.385\t15\n135251\t3.822\t0.36\t16\n135258\t3.001\t0.0\t2\n135260\t3.608\t0.228\t9\n135430\t2.312\t0.051\t4\n139303\t3.535\t0.292\t31\n139304\t3.38\t0.183\t24\n139305\t2.623\t0.529\t104\n139306\t3.083\t0.33\t321\n139308\t2.96\t0.162\t229\n139309\t2.923\t0.274\t63\n139310\t2.882\t0.149\t259\n139311\t3.27\t0.202\t438\n139312\t2.668\t0.417\t260\n139313\t3.241\t0.429\t63\n139314\t3.163\t0.399\t546\n139315\t3.191\t0.461\t290\n139321\t3.855\t0.226\t50\n139322\t3.709\t0.138\t100\n139323\t3.684\t0.123\t46\n139324\t3.633\t0.072\t70\n139326\t3.545\t0.123\t112\n139327\t3.991\t0.038\t4\n139328\t3.786\t0.526\t8\n139329\t3.979\t0.001\t4\n139330\t3.537\t0.014\t6\n139331\t3.355\t0.108\t12\n139332\t3.159\t0.173\t21\n139333\t3.624\t0.136\t27\n139334\t3.334\t0.167\t126\n139336\t3.239\t0.487\t10\n139337\t2.614\t0.35\t62\n139338\t3.123\t0.251\t218\n139339\t3.229\t0.309\t1334\n139340\t3.562\t0.717\t14\n139341\t2.945\t0.19\t49\n139342\t2.914\t0.165\t139\n139343\t2.866\t0.183\t165\n139344\t3.14\t0.274\t105\n139345\t3.078\t0.295\t50\n139346\t3.558\t0.371\t43\n139347\t3.512\t0.445\t86\n139354\t3.623\t0.348\t57\n139356\t3.581\t0.414\t207\n139357\t3.553\t0.26\t12\n139358\t3.738\t0.14\t26\n139526\t2.278\t0.056\t6\n143399\t2.881\t0.269\t29\n143400\t3.289\t0.207\t165\n143401\t2.903\t0.415\t136\n143402\t2.928\t0.263\t822\n143404\t2.981\t0.274\t225\n143405\t3.002\t0.373\t123\n143406\t2.929\t0.211\t1350\n143407\t3.15\t0.245\t392\n143408\t3.115\t0.214\t390\n143409\t2.892\t0.454\t277\n143410\t3.152\t0.327\t288\n143411\t3.118\t0.344\t421\n143417\t3.489\t0.306\t26\n143418\t3.66\t0.441\t102\n143419\t2.889\t0.02\t3\n143420\t3.311\t0.239\t14\n143422\t3.519\t0.117\t10\n143423\t3.405\t0.182\t14\n143424\t3.622\t0.201\t10\n143425\t2.902\t0.279\t14\n143426\t3.441\t0.397\t31\n143427\t2.869\t0.248\t16\n143428\t2.769\t0.111\t12\n143430\t3.342\t0.101\t8\n143433\t3.029\t0.413\t218\n143434\t2.63\t0.358\t237\n143435\t2.974\t0.223\t787\n143436\t2.871\t0.256\t91\n143437\t3.02\t0.255\t120\n143438\t2.97\t0.262\t730\n143439\t2.839\t0.219\t570\n143440\t2.939\t0.303\t600\n143441\t2.709\t0.226\t130\n143442\t3.393\t0.358\t470\n143443\t3.237\t0.326\t869\n143450\t3.569\t0.067\t21\n143452\t3.3\t0.463\t144\n143453\t2.771\t0.0\t6\n143454\t3.655\t0.021\t3\n143455\t2.882\t0.023\t3\n151589\t4.027\t0.433\t171\n151590\t3.818\t0.355\t2\n151594\t3.871\t0.0\t2\n151598\t3.586\t0.162\t20\n151599\t3.353\t0.049\t2\n151601\t3.937\t0.0\t2\n151602\t3.839\t0.296\t15\n151603\t3.859\t0.378\t36\n151607\t4.188\t0.029\t2\n151631\t3.626\t0.064\t26\n151633\t3.814\t0.025\t4\n151634\t3.849\t0.071\t10\n151635\t4.057\t0.0\t2\n151814\t3.815\t0.247\t64\n152069\t3.392\t0.0\t2\n152070\t3.728\t0.185\t7\n155686\t3.715\t0.263\t197\n155692\t3.291\t0.0\t2\n155693\t3.275\t0.0\t2\n155695\t3.371\t-1.0\t1\n155696\t3.544\t0.083\t4\n155697\t3.415\t0.077\t36\n155698\t3.446\t0.074\t26\n155699\t3.346\t0.137\t70\n155703\t4.039\t0.114\t2\n155704\t3.785\t-1.0\t1\n155725\t3.3\t0.0\t4\n155726\t3.174\t0.064\t8\n155727\t3.236\t0.051\t4\n155728\t3.411\t0.02\t2\n155729\t3.492\t0.006\t3\n155730\t3.53\t0.066\t10\n155731\t3.424\t0.132\t88\n155740\t3.534\t-1.0\t1\n155910\t3.584\t0.272\t112\n156166\t2.793\t0.019\t4\n159783\t4.713\t0.009\t2\n159790\t3.627\t0.388\t4\n159795\t3.832\t0.039\t12\n159797\t3.719\t0.347\t56\n159799\t4.168\t0.0\t2\n159822\t3.558\t0.003\t2\n160005\t3.476\t0.074\t35\n160006\t3.258\t0.191\t4054\n160007\t2.913\t0.142\t1412\n160008\t2.796\t0.249\t708\n160015\t3.636\t0.026\t3\n160016\t3.367\t0.408\t27\n160262\t2.99\t0.127\t72\n160263\t3.031\t0.264\t24\n163884\t3.712\t0.084\t3\n163885\t3.713\t0.26\t5\n163889\t3.399\t0.0\t2\n163890\t3.989\t0.377\t5\n163892\t3.476\t0.0\t2\n163893\t3.302\t0.424\t87\n163917\t3.364\t0.045\t5\n163918\t3.314\t0.355\t6\n163922\t4.034\t-1.0\t1\n164101\t3.255\t0.125\t9\n164102\t3.029\t0.219\t13290\n164103\t2.812\t0.186\t1007\n164104\t2.599\t0.231\t718\n164111\t3.355\t0.275\t19\n164112\t3.184\t0.119\t22\n164358\t2.805\t0.151\t103\n164359\t2.642\t0.21\t22\n164360\t2.844\t0.216\t9\n167977\t2.746\t0.433\t12\n167986\t3.166\t-1.0\t1\n167988\t3.668\t0.819\t15\n167989\t2.936\t0.216\t20\n168198\t2.975\t0.237\t953\n168199\t2.749\t0.24\t450\n168200\t2.532\t0.296\t44\n168207\t3.165\t0.13\t49\n168208\t3.318\t0.08\t14\n168454\t2.601\t0.169\t111\n168455\t2.727\t0.161\t25\n172074\t2.912\t0.373\t1298\n172076\t3.157\t0.34\t9\n172078\t3.301\t0.025\t5\n172079\t3.222\t0.067\t8\n172082\t3.28\t0.259\t30\n172083\t3.177\t0.165\t15\n172084\t3.327\t0.193\t23\n172085\t3.272\t0.292\t557\n172087\t3.799\t-1.0\t1\n172088\t3.528\t-1.0\t1\n172106\t2.727\t0.462\t6\n172107\t3.735\t-1.0\t1\n172109\t3.252\t0.082\t43\n172110\t3.239\t0.183\t9\n172111\t3.197\t0.132\t22\n172112\t3.584\t0.076\t4\n172114\t3.693\t0.232\t12\n172115\t3.359\t0.28\t40\n172124\t3.744\t0.013\t2\n172293\t3.03\t0.256\t14\n172294\t2.789\t0.167\t9278\n172295\t2.577\t0.18\t3098\n172296\t2.467\t0.259\t1296\n172303\t2.908\t0.239\t150\n172304\t2.957\t0.217\t165\n172550\t2.341\t0.159\t4663\n172551\t2.511\t0.149\t218\n172559\t2.202\t0.279\t10\n180268\t3.063\t0.299\t1102\n180269\t2.945\t0.515\t10\n180270\t3.082\t0.36\t14\n180271\t3.086\t-1.0\t1\n180272\t3.242\t0.131\t2\n180273\t3.439\t0.268\t6\n180274\t3.072\t0.196\t129\n180275\t3.213\t0.211\t24\n180276\t3.091\t0.153\t98\n180277\t3.22\t0.208\t173\n180295\t3.709\t0.109\t4\n180296\t3.674\t0.024\t2\n180298\t3.338\t0.368\t8\n180299\t3.08\t0.02\t2\n180300\t3.051\t0.136\t6\n180301\t3.2\t0.237\t31\n180302\t3.182\t0.186\t59\n180303\t2.975\t0.164\t24\n180304\t3.255\t-1.0\t1\n180306\t2.931\t0.041\t12\n180307\t2.734\t0.077\t20\n180485\t2.755\t0.204\t14\n180486\t2.611\t0.146\t28221\n180487\t2.363\t0.139\t11820\n180488\t2.408\t0.153\t1326\n180495\t2.75\t0.202\t77\n180496\t2.828\t0.175\t621\n180742\t2.163\t0.16\t10524\n180743\t2.394\t0.13\t880\n180744\t2.447\t0.224\t6\n180751\t2.688\t0.012\t5\n180752\t2.464\t0.284\t5\n184365\t2.871\t0.285\t392\n184366\t3.302\t0.52\t4\n184367\t2.634\t0.029\t2\n184368\t2.701\t-1.0\t1\n184369\t3.216\t0.427\t13\n184370\t3.333\t0.264\t124\n184371\t3.063\t0.086\t29\n184372\t3.343\t0.188\t5\n184373\t3.193\t0.194\t327\n184396\t2.794\t0.148\t26\n184397\t2.962\t0.816\t2\n184398\t2.985\t0.39\t19\n184399\t3.255\t0.176\t61\n184400\t3.215\t0.059\t6\n184402\t3.402\t0.003\t2\n184403\t3.348\t0.247\t21\n184412\t3.283\t0.005\t3\n184581\t2.634\t0.295\t6\n184582\t2.568\t0.171\t12855\n184583\t2.441\t0.153\t3081\n184584\t2.416\t0.166\t1225\n184591\t2.739\t0.094\t61\n184592\t2.805\t0.202\t148\n184837\t2.886\t-1.0\t1\n184838\t2.196\t0.199\t2670\n184839\t2.45\t0.148\t279\n184848\t2.287\t0.009\t6\n188462\t3.197\t0.284\t549\n188463\t3.567\t0.174\t71\n188465\t3.129\t0.275\t2\n188466\t3.378\t0.343\t81\n188467\t3.278\t0.49\t122\n188468\t3.121\t0.318\t140\n188469\t3.118\t0.179\t936\n188472\t3.155\t0.189\t11\n188486\t2.788\t-1.0\t1\n188487\t3.697\t0.043\t2\n188490\t3.361\t-1.0\t1\n188491\t3.319\t0.01\t2\n188492\t3.071\t0.101\t16\n188494\t3.253\t0.286\t17\n188495\t3.308\t0.347\t126\n188496\t3.082\t0.313\t5\n188497\t3.342\t0.379\t39\n188498\t3.685\t0.035\t11\n188499\t2.981\t0.028\t91\n188508\t3.265\t0.257\t3\n188677\t2.545\t0.218\t11\n188678\t2.381\t0.169\t6266\n188679\t2.365\t0.135\t7580\n188680\t2.446\t0.147\t1073\n188687\t2.778\t0.159\t82\n188688\t2.732\t0.177\t615\n188934\t2.405\t0.21\t1341\n188935\t2.38\t0.131\t281\n188936\t2.152\t0.004\t2\n188944\t2.657\t0.082\t9\n192559\t3.554\t0.226\t4083\n192561\t2.716\t-1.0\t1\n192562\t3.443\t0.292\t14\n192563\t3.163\t0.241\t12\n192564\t3.698\t0.229\t62\n192565\t3.522\t0.275\t796\n192572\t3.827\t0.068\t3\n192587\t3.3\t0.096\t6\n192588\t3.119\t0.06\t30\n192589\t3.417\t0.237\t27\n192590\t3.436\t0.273\t279\n192591\t3.326\t0.24\t399\n192592\t2.823\t0.436\t7\n192774\t2.472\t0.2\t1611\n192775\t2.535\t0.173\t5301\n192776\t2.731\t0.17\t305\n192783\t2.898\t0.163\t18\n192784\t3.194\t0.23\t847\n193030\t2.719\t0.257\t1011\n193031\t2.571\t0.187\t351\n196656\t2.962\t0.143\t4\n196659\t2.984\t0.064\t32\n196660\t3.488\t0.2\t53\n196661\t3.212\t0.24\t422\n196664\t3.568\t0.009\t4\n196686\t3.302\t0.12\t162\n196687\t3.375\t0.136\t15\n196690\t3.639\t0.028\t8\n196691\t3.016\t0.052\t32\n196870\t2.546\t0.218\t32\n196871\t2.669\t0.125\t3379\n196872\t2.711\t0.152\t719\n196880\t3.123\t0.225\t349\n197126\t2.828\t0.381\t77\n197127\t2.606\t0.119\t56\n197128\t2.751\t-1.0\t1\n200753\t2.968\t0.291\t109\n200754\t3.781\t0.18\t17\n200755\t2.926\t0.006\t4\n200756\t3.55\t0.394\t50\n200757\t3.215\t0.314\t179\n200759\t3.813\t0.152\t8\n200760\t3.68\t0.079\t15\n200778\t3.2\t0.021\t2\n200779\t2.798\t0.024\t24\n200781\t2.816\t0.38\t2\n200782\t3.146\t0.138\t51\n200783\t3.783\t-1.0\t1\n200784\t3.608\t0.06\t2\n200787\t3.701\t0.063\t13\n200966\t2.737\t0.248\t164\n200967\t2.638\t0.193\t666\n200968\t2.735\t0.196\t128\n200975\t3.61\t0.145\t5\n200976\t2.787\t0.336\t60\n201222\t2.754\t0.18\t12\n201223\t2.897\t0.149\t12\n204850\t3.629\t0.476\t976\n204851\t2.793\t0.054\t34\n204852\t3.367\t0.645\t98\n204853\t3.325\t0.463\t310\n204855\t3.996\t0.344\t33\n204856\t3.682\t0.08\t11\n204857\t3.947\t0.023\t6\n204858\t3.186\t0.0\t6\n204863\t3.44\t0.0\t11\n204866\t3.929\t-1.0\t1\n204870\t3.525\t0.118\t8\n204872\t4.135\t0.14\t3\n204874\t3.301\t0.205\t57\n204875\t3.121\t0.234\t55\n204876\t3.203\t0.168\t70\n204877\t3.061\t0.08\t42\n204878\t3.284\t0.173\t281\n204879\t4.309\t0.589\t23\n204881\t3.669\t0.346\t5\n204882\t3.46\t0.055\t10\n204883\t3.636\t0.704\t18\n204892\t4.537\t-1.0\t1\n205061\t2.753\t0.308\t17\n205062\t2.528\t0.15\t3869\n205063\t2.708\t0.199\t1070\n205064\t2.716\t0.2\t545\n205071\t3.421\t0.246\t38\n205072\t3.123\t0.212\t212\n205318\t2.574\t0.174\t88\n205319\t2.626\t0.158\t25\n208947\t2.969\t0.506\t259\n208948\t3.77\t0.671\t12\n208949\t3.392\t0.45\t229\n208951\t3.952\t0.118\t44\n208952\t3.545\t0.115\t138\n208953\t3.197\t0.0\t6\n208954\t3.176\t0.0\t6\n208962\t3.825\t0.039\t12\n208968\t3.44\t-1.0\t1\n208970\t3.273\t0.166\t30\n208971\t3.245\t0.214\t83\n208972\t2.968\t0.115\t113\n208973\t3.43\t0.067\t4\n208974\t3.1\t0.205\t80\n208975\t3.122\t0.204\t60\n208976\t3.551\t0.081\t6\n208977\t4.668\t0.032\t6\n208978\t4.088\t0.033\t12\n208979\t2.917\t0.271\t11\n209158\t2.495\t0.15\t1844\n209159\t2.721\t0.28\t225\n209160\t2.668\t0.436\t78\n209167\t3.017\t0.046\t5\n209168\t3.149\t0.165\t38\n209414\t2.509\t0.24\t10\n209415\t2.427\t0.146\t6\n213050\t4.433\t0.045\t6\n213054\t4.024\t0.099\t10\n213065\t5.027\t-1.0\t1\n213066\t2.704\t0.455\t23\n213067\t3.276\t0.286\t165\n213068\t3.025\t0.034\t20\n213070\t3.155\t0.284\t48\n213071\t3.03\t0.209\t38\n213072\t3.343\t0.249\t92\n213073\t4.446\t0.01\t2\n213074\t4.01\t0.314\t16\n213075\t3.489\t0.653\t32\n213084\t3.85\t0.333\t22\n213086\t4.355\t0.043\t6\n217145\t3.893\t0.312\t115\n217146\t4.057\t0.272\t72\n217147\t3.309\t0.409\t38\n217148\t3.875\t0.23\t104\n217150\t3.913\t0.338\t122\n217151\t4.078\t0.166\t14\n217152\t3.772\t0.324\t18\n217153\t3.606\t0.456\t25\n217154\t3.192\t0.524\t27\n217156\t3.103\t0.413\t22\n217157\t3.863\t0.489\t46\n217158\t3.761\t0.157\t82\n217159\t3.66\t0.413\t6\n217160\t3.35\t0.322\t22\n217161\t2.816\t0.4\t52\n217162\t2.801\t0.247\t341\n217163\t2.814\t0.353\t94\n217164\t2.999\t0.191\t26\n217165\t3.222\t0.232\t233\n217166\t3.234\t0.277\t811\n217167\t3.066\t0.296\t281\n217168\t3.131\t0.252\t665\n217169\t2.89\t0.413\t19\n217170\t3.801\t0.427\t565\n217171\t3.582\t0.409\t827\n217178\t3.927\t0.242\t20\n217180\t3.819\t0.264\t406\n217182\t3.899\t0.189\t7\n217183\t3.278\t-1.0\t1\n225335\t4.276\t0.49\t265\n225336\t4.479\t0.154\t3\n225338\t4.3\t0.0\t2\n225345\t4.243\t-1.0\t1\n225346\t4.182\t-1.0\t1\n225354\t3.789\t-1.0\t1\n225359\t3.687\t0.153\t5\n225360\t4.965\t0.0\t3\n225361\t4.086\t0.077\t5\n225362\t3.938\t0.124\t17\n225363\t4.209\t0.153\t5\n225542\t4.026\t0.331\t148\n225797\t3.377\t0.162\t3\n225798\t3.864\t0.248\t33\n229432\t4.077\t0.334\t194\n229450\t3.552\t0.0\t2\n229455\t3.61\t0.0\t2\n229458\t3.779\t0.076\t5\n229459\t3.62\t0.105\t15\n229638\t3.726\t0.142\t169\n229893\t2.88\t0.148\t17\n233547\t3.663\t0.041\t4\n233733\t3.661\t0.127\t9\n233734\t3.511\t0.169\t1320\n233735\t3.103\t0.143\t699\n233736\t2.952\t0.191\t544\n233743\t4.137\t0.779\t6\n233744\t3.541\t0.191\t21\n233990\t3.356\t0.17\t18\n233991\t3.128\t0.157\t55\n237830\t3.517\t0.262\t866\n237831\t3.053\t0.238\t780\n237832\t2.942\t0.272\t364\n237839\t3.058\t0.078\t3\n237840\t3.557\t0.208\t14\n238086\t3.309\t0.197\t15\n238087\t3.084\t0.184\t40\n241926\t3.477\t0.124\t197\n241927\t3.016\t0.163\t300\n241928\t2.871\t0.151\t320\n241936\t3.545\t0.074\t6\n242182\t3.213\t0.142\t3\n242183\t3.034\t0.049\t17\n246021\t3.749\t-1.0\t1\n246022\t3.442\t0.199\t803\n246023\t3.027\t0.153\t733\n246024\t2.83\t0.16\t737\n246031\t3.715\t0.509\t10\n246032\t3.489\t0.117\t10\n246278\t3.07\t0.175\t7\n246279\t3.018\t0.113\t65\n254014\t3.621\t0.145\t11\n254027\t3.568\t0.017\t3\n254214\t3.39\t0.158\t2671\n254215\t2.996\t0.161\t998\n254216\t2.805\t0.192\t556\n254223\t3.737\t0.252\t40\n254224\t3.439\t0.148\t13\n254470\t3.227\t0.142\t6\n254471\t3.139\t0.173\t24\n254472\t2.911\t0.206\t20\n258111\t2.215\t0.23\t2\n258310\t3.466\t0.262\t271\n258311\t2.927\t0.187\t1239\n258312\t2.76\t0.166\t1083\n258320\t3.383\t0.05\t12\n258566\t3.457\t0.042\t4\n258567\t2.819\t0.112\t11\n262406\t3.329\t0.213\t453\n262407\t2.926\t0.184\t889\n262408\t2.796\t0.186\t1231\n262416\t3.355\t0.381\t10\n262662\t2.919\t0.044\t2\n262663\t2.999\t0.226\t11\n266502\t3.401\t0.179\t388\n266503\t2.89\t0.17\t992\n266504\t2.734\t0.193\t1159\n266511\t3.732\t-1.0\t1\n266512\t3.445\t0.0\t2\n266758\t2.926\t-1.0\t1\n266759\t2.857\t0.231\t31\n270597\t3.404\t0.076\t3\n270598\t3.222\t0.253\t1595\n270599\t2.866\t0.193\t2042\n270600\t2.707\t0.189\t2073\n270607\t3.718\t-1.0\t1\n270608\t3.41\t0.38\t13\n270854\t2.9\t-1.0\t1\n270855\t2.794\t0.192\t30\n274510\t4.001\t0.0\t2\n274694\t3.388\t0.171\t354\n274695\t2.87\t0.172\t416\n274696\t2.724\t0.185\t439\n274950\t2.925\t0.039\t8\n274951\t2.479\t0.253\t12\n278789\t3.409\t0.069\t2\n278790\t3.158\t0.169\t1145\n278791\t2.849\t0.175\t801\n278792\t2.672\t0.179\t577\n278799\t3.625\t-1.0\t1\n278800\t3.474\t0.092\t7\n279046\t2.934\t0.097\t12\n279047\t2.89\t0.09\t12\n282693\t3.553\t0.0\t4\n282886\t3.443\t0.178\t536\n282887\t2.879\t0.209\t168\n282888\t2.725\t0.147\t129\n282895\t3.631\t0.142\t21\n282896\t3.222\t0.01\t8\n283143\t2.527\t0.136\t9\n286981\t3.507\t0.084\t5\n286982\t3.184\t0.155\t3390\n286983\t2.859\t0.153\t1245\n286984\t2.682\t0.159\t499\n286991\t3.54\t0.155\t13\n286992\t3.365\t0.159\t9\n287238\t3.019\t0.138\t24\n287239\t2.855\t0.076\t16\n287240\t2.979\t0.21\t26\n290891\t3.455\t0.011\t2\n290894\t3.514\t-1.0\t1\n291077\t3.476\t0.16\t11\n291078\t3.284\t0.204\t878\n291079\t2.84\t0.187\t460\n291080\t2.635\t0.193\t132\n291088\t3.528\t0.062\t2\n291334\t2.883\t0.06\t12\n291335\t2.948\t0.137\t14\n294994\t3.999\t-1.0\t1\n295173\t3.165\t0.193\t2\n295174\t3.107\t0.177\t2432\n295175\t2.774\t0.182\t341\n295176\t2.652\t0.204\t104\n295184\t3.109\t0.166\t9\n295430\t2.767\t0.112\t12\n295431\t2.657\t0.278\t12\n299081\t2.935\t0.369\t17\n299085\t3.119\t0.214\t10\n299270\t2.918\t0.218\t1400\n299271\t2.737\t0.199\t305\n299272\t2.492\t0.248\t40\n299279\t2.559\t0.037\t4\n299526\t2.488\t0.241\t28\n299527\t2.804\t0.155\t6\n303178\t2.675\t0.417\t434\n303181\t3.222\t0.078\t41\n303182\t3.654\t-1.0\t1\n303183\t3.21\t0.023\t4\n303186\t3.733\t0.044\t8\n303187\t3.128\t0.192\t8\n303365\t2.968\t0.028\t2\n303366\t2.8\t0.213\t3774\n303367\t2.584\t0.227\t2258\n303368\t2.49\t0.297\t312\n303375\t2.904\t0.202\t124\n303376\t3.053\t0.272\t32\n303622\t2.342\t0.159\t6180\n303623\t2.471\t0.154\t65\n307275\t3.127\t0.383\t1161\n307276\t3.076\t0.401\t28\n307277\t3.191\t0.02\t2\n307278\t3.567\t0.117\t38\n307279\t3.269\t0.094\t25\n307280\t3.228\t0.038\t20\n307281\t3.587\t0.03\t2\n307283\t3.205\t0.081\t30\n307292\t3.713\t0.164\t4\n307462\t2.629\t0.197\t1542\n307463\t2.457\t0.127\t3999\n307464\t2.435\t0.206\t207\n307471\t2.732\t0.251\t11\n307472\t2.825\t0.122\t121\n307718\t2.178\t0.135\t8471\n307719\t2.383\t0.156\t157\n307720\t2.299\t0.121\t3\n307728\t2.409\t0.014\t6\n311372\t3.106\t0.207\t804\n311373\t3.181\t-1.0\t1\n311374\t3.548\t0.146\t32\n311375\t3.12\t0.036\t62\n311379\t2.887\t0.06\t22\n311558\t2.597\t0.187\t2089\n311559\t2.357\t0.157\t1187\n311560\t2.486\t0.163\t95\n311567\t3.048\t0.26\t4\n311568\t3.082\t0.291\t44\n311814\t2.108\t0.152\t4572\n311815\t2.428\t0.139\t86\n311824\t2.543\t0.001\t4\n315469\t3.151\t0.278\t365\n315470\t3.549\t0.122\t63\n315471\t3.157\t0.118\t31\n315475\t3.22\t0.061\t39\n315653\t2.65\t0.215\t20\n315654\t2.552\t0.195\t16080\n315655\t2.382\t0.126\t6084\n315656\t2.483\t0.127\t418\n315663\t2.762\t0.14\t37\n315664\t2.816\t0.196\t162\n315910\t2.215\t0.168\t2203\n315911\t2.436\t0.105\t204\n315920\t2.977\t-1.0\t1\n319566\t3.225\t0.248\t552\n319567\t3.367\t0.293\t115\n319568\t3.169\t0.205\t20\n319569\t3.36\t0.238\t50\n319570\t3.392\t0.286\t42\n319571\t2.929\t0.286\t8\n319580\t2.758\t-1.0\t1\n319749\t2.528\t0.434\t19\n319750\t2.374\t0.187\t4743\n319751\t2.364\t0.145\t6282\n319752\t2.404\t0.169\t399\n319759\t2.743\t0.15\t63\n319760\t2.674\t0.189\t638\n320005\t2.585\t0.095\t3\n320006\t2.331\t0.173\t2612\n320007\t2.357\t0.121\t135\n320015\t2.781\t0.006\t2\n320016\t2.898\t0.124\t6\n323663\t3.245\t0.336\t4562\n323664\t3.526\t0.142\t2\n323665\t3.286\t0.102\t22\n323666\t3.306\t0.022\t2\n323667\t2.881\t0.196\t25\n323846\t2.35\t0.15\t3014\n323847\t2.354\t0.137\t1158\n323848\t2.403\t0.253\t6\n323855\t2.769\t0.169\t45\n323856\t2.739\t0.213\t222\n324102\t2.337\t0.19\t1691\n324103\t2.388\t0.156\t45\n327760\t2.694\t0.474\t53\n327941\t2.577\t-1.0\t1\n327942\t2.266\t0.136\t922\n327943\t2.741\t0.157\t953\n327944\t2.741\t0.235\t37\n327951\t2.904\t0.093\t8\n327952\t2.866\t0.242\t158\n328198\t2.38\t0.168\t94\n328199\t2.875\t0.15\t3\n331857\t3.111\t0.21\t60\n332038\t2.542\t0.227\t19\n332039\t2.984\t0.13\t175\n332040\t2.942\t0.295\t20\n332048\t3.399\t0.21\t18\n332294\t2.174\t0.0\t4\n335954\t3.231\t0.429\t436\n336134\t2.776\t0.248\t252\n336135\t2.833\t0.135\t693\n336136\t2.76\t0.196\t207\n336143\t3.678\t0.123\t15\n336144\t3.263\t0.218\t66\n336390\t2.874\t0.122\t4\n336391\t2.699\t0.147\t7\n340051\t3.126\t0.27\t404\n340229\t2.797\t-1.0\t1\n340230\t2.623\t0.24\t807\n340231\t2.807\t0.169\t491\n340232\t2.771\t0.212\t269\n340239\t3.206\t0.012\t2\n340240\t3.325\t0.293\t98\n340486\t2.701\t0.167\t16\n340487\t3.129\t0.34\t2\n368902\t3.528\t0.229\t2516\n368903\t3.077\t0.237\t337\n368904\t2.966\t0.304\t84\n368911\t3.616\t0.121\t7\n368912\t3.535\t0.376\t64\n369158\t3.14\t0.113\t14\n369159\t3.146\t0.323\t8\n369160\t3.179\t0.006\t2\n376924\t3.747\t0.0\t2\n377094\t3.44\t0.227\t3394\n377095\t2.982\t0.201\t1971\n377096\t2.826\t0.242\t770\n377103\t2.998\t0.426\t10\n377104\t3.462\t0.179\t110\n377350\t3.258\t0.302\t74\n377351\t3.02\t0.219\t96\n377352\t3.011\t0.211\t9\n381190\t3.595\t0.186\t49\n381191\t3.016\t0.171\t33\n381192\t3.071\t0.23\t47\n381200\t3.429\t0.053\t8\n385286\t3.676\t0.046\t15\n385287\t3.005\t0.218\t31\n385288\t3.065\t0.263\t47\n385296\t3.84\t0.251\t6\n389383\t3.107\t0.032\t5\n389384\t2.858\t0.234\t18\n389392\t3.517\t0.038\t3\n393479\t3.128\t0.008\t2\n393488\t3.419\t0.064\t3\n397575\t3.05\t0.029\t3\n397576\t2.942\t0.008\t3\n401671\t3.038\t0.025\t3\n401672\t2.931\t0.016\t3\n1073414\t1.594\t0.077\t2000853\n1073415\t1.527\t0.071\t91806\n1073423\t2.001\t0.161\t74\n1073424\t1.981\t0.067\t42\n1073679\t2.05\t0.093\t4\n1073680\t1.992\t0.039\t7\n1077511\t1.504\t0.087\t791\n1077519\t1.839\t0.106\t1862\n1077520\t1.811\t0.097\t38\n1077776\t1.753\t0.11\t23\n1110287\t2.325\t0.221\t8\n16781317\t1.299\t0.138\t2655\n16781318\t1.157\t0.073\t2154155\n16781319\t1.027\t0.087\t120477\n16781320\t1.0\t0.102\t99234\n16781321\t1.229\t0.768\t39\n16781326\t1.698\t0.206\t492\n16781327\t1.491\t0.16\t461\n16781328\t1.414\t0.148\t260\n16781329\t1.46\t0.267\t16\n16781344\t1.768\t0.207\t170\n16781345\t1.64\t0.233\t13\n16781346\t1.184\t0.24\t11\n16781347\t1.193\t0.14\t10\n16781365\t1.612\t0.001\t2\n16781573\t1.266\t-1.0\t1\n16781574\t1.083\t0.054\t1399983\n16781575\t1.026\t0.08\t10086\n16781576\t1.035\t0.083\t62\n16781583\t1.555\t0.169\t170\n16781830\t1.082\t0.064\t1503\n16781831\t1.012\t0.075\t9\n16797701\t2.055\t0.175\t200\n16797702\t1.917\t0.136\t1968\n16797703\t1.74\t0.145\t4307\n16797704\t1.627\t0.111\t7838\n16797705\t1.579\t0.095\t5410\n16797710\t2.643\t0.184\t32\n16797711\t2.367\t0.191\t736\n16797712\t2.279\t0.266\t207\n16797713\t2.22\t0.188\t513\n16797728\t2.564\t0.128\t21\n16797729\t2.481\t0.101\t5\n16797730\t2.577\t0.148\t48\n16797731\t2.401\t0.231\t244\n16797748\t2.725\t0.14\t4\n16797749\t2.87\t0.374\t77\n16797958\t1.838\t0.106\t11969\n16797959\t1.825\t0.108\t1915\n16797967\t2.268\t0.255\t20\n16798214\t1.868\t0.127\t268\n16798215\t1.772\t0.141\t42\n16798224\t2.259\t-1.0\t1\n16801798\t1.819\t0.111\t650683\n16801799\t1.721\t0.104\t153277\n16801800\t1.674\t0.089\t194202\n16801801\t1.483\t0.083\t37441\n16801806\t2.363\t0.237\t31159\n16801807\t2.243\t0.189\t5173\n16801808\t2.128\t0.132\t11654\n16801809\t2.024\t0.124\t15529\n16801824\t2.527\t0.248\t999\n16801825\t2.422\t0.325\t206\n16801826\t2.378\t0.18\t872\n16801827\t2.279\t0.155\t2704\n16801844\t2.666\t0.308\t172\n16801845\t2.522\t0.166\t717\n16802054\t1.762\t0.092\t352183\n16802055\t1.72\t0.097\t14388\n16802056\t1.688\t0.108\t6\n16802063\t2.207\t0.172\t3307\n16802064\t2.105\t0.131\t3350\n16802310\t1.696\t0.091\t7665\n16802311\t1.656\t0.128\t75\n16802320\t2.082\t0.116\t4919\n16805895\t1.623\t0.108\t3208\n16805896\t1.666\t0.126\t2100\n16805897\t1.415\t0.162\t17\n16805902\t2.205\t0.191\t1967\n16805903\t2.079\t0.152\t1682\n16805904\t1.93\t0.103\t249\n16805905\t1.958\t0.111\t24\n16805920\t2.362\t0.195\t1315\n16805921\t2.241\t0.173\t128\n16805922\t2.3\t0.193\t96\n16805923\t2.162\t0.118\t32\n16805940\t2.674\t0.201\t118\n16805941\t2.473\t0.194\t38\n16806150\t1.59\t0.082\t164495\n16806151\t1.574\t0.081\t7627\n16806159\t1.986\t0.139\t3197\n16806160\t2.009\t0.09\t401\n16806406\t1.512\t0.069\t153\n16806407\t1.394\t0.086\t533\n16806416\t1.9\t0.093\t9234\n16809992\t1.741\t0.264\t647\n16809998\t1.995\t0.155\t7813\n16809999\t1.925\t0.144\t1208\n16810000\t1.916\t0.201\t51\n16810001\t1.673\t0.087\t998\n16810016\t2.152\t0.242\t1021\n16810017\t1.796\t0.244\t670\n16810018\t2.006\t0.2\t174\n16810019\t1.965\t0.381\t4\n16810036\t2.404\t0.302\t460\n16810037\t2.386\t0.22\t205\n16810246\t1.562\t0.08\t163577\n16810247\t1.393\t0.102\t21110\n16810255\t1.861\t0.129\t9068\n16810256\t1.926\t0.104\t123\n16810502\t1.408\t0.07\t41\n16810503\t1.354\t0.073\t7\n16810512\t1.734\t0.114\t5958\n16814089\t1.446\t0.064\t5\n16814094\t1.979\t0.162\t679\n16814095\t1.82\t0.095\t9307\n16814096\t1.773\t0.108\t625\n16814097\t1.615\t0.213\t20\n16814112\t2.054\t0.303\t209\n16814113\t1.845\t0.169\t415\n16814114\t2.218\t0.193\t16\n16814115\t1.836\t0.098\t23\n16814132\t1.837\t0.254\t287\n16814133\t2.14\t0.294\t84\n16814342\t1.478\t0.072\t44091\n16814343\t1.246\t0.169\t3\n16814351\t1.618\t0.194\t150\n16814352\t1.613\t0.103\t16\n16814608\t1.556\t0.127\t44\n16834574\t3.378\t0.364\t2682\n16834575\t2.882\t0.272\t162\n16834576\t2.626\t0.23\t157\n16834577\t2.549\t0.274\t1011\n16834592\t3.473\t0.286\t507\n16834593\t3.314\t0.371\t24\n16834594\t2.897\t0.327\t42\n16834595\t2.87\t0.389\t169\n16834612\t3.665\t0.536\t15\n16834613\t3.09\t0.417\t78\n16834822\t2.235\t0.149\t6897\n16834823\t2.299\t0.166\t545\n16835078\t2.237\t0.123\t1405\n16835079\t2.102\t0.162\t46\n16838671\t2.751\t0.246\t664\n16838672\t2.368\t0.224\t165\n16838673\t2.447\t0.27\t425\n16838688\t3.18\t0.313\t89\n16838689\t2.773\t0.119\t26\n16838690\t2.582\t0.333\t127\n16838691\t2.563\t0.288\t58\n16838708\t3.027\t0.178\t12\n16838709\t2.915\t0.394\t101\n16838918\t2.115\t0.115\t8657\n16838919\t1.855\t0.183\t439\n16838927\t2.715\t0.169\t135\n16838928\t2.658\t0.069\t6\n16839174\t1.936\t0.185\t23\n16839175\t2.101\t0.064\t2\n16839184\t2.948\t-1.0\t1\n16842768\t2.281\t0.201\t1234\n16842769\t2.015\t0.03\t13\n16842784\t2.754\t0.331\t616\n16842785\t2.241\t0.25\t917\n16842786\t2.475\t0.266\t49\n16842787\t2.694\t0.214\t14\n16842804\t3.261\t0.399\t44\n16842805\t3.241\t0.251\t46\n16843014\t2.01\t0.115\t20813\n16843015\t1.834\t0.133\t156\n16843023\t2.464\t0.209\t339\n16843024\t2.494\t0.161\t19\n16843270\t1.935\t0.13\t225\n16843280\t2.489\t0.19\t50\n16846865\t1.992\t0.399\t44\n16846880\t2.745\t0.286\t511\n16846881\t2.728\t0.235\t235\n16846882\t2.384\t0.337\t109\n16846900\t3.03\t0.369\t277\n16846901\t2.906\t0.468\t87\n16847110\t1.969\t0.095\t20992\n16847111\t1.77\t0.177\t16\n16847119\t2.289\t0.187\t1133\n16847120\t2.181\t0.113\t8\n16847366\t1.923\t0.203\t4\n16847376\t2.231\t0.165\t28\n16908320\t3.119\t0.561\t1100\n16908321\t2.481\t0.4\t70\n16908322\t2.624\t0.585\t344\n16908323\t2.911\t0.375\t127\n16908340\t3.181\t0.424\t124\n16908341\t3.271\t0.469\t73\n16908550\t2.342\t0.169\t2233\n16908551\t2.432\t0.175\t414\n16908552\t2.284\t0.062\t14\n16908559\t3.148\t0.384\t31\n16908806\t2.273\t0.193\t233\n16912417\t2.568\t0.286\t226\n16912418\t2.384\t0.277\t52\n16912419\t2.383\t0.526\t37\n16912436\t2.868\t0.102\t3\n16912437\t3.175\t0.376\t43\n16912646\t2.247\t0.155\t563\n16912647\t2.196\t0.137\t13\n16912655\t2.8\t0.063\t13\n16912902\t1.902\t0.429\t4\n16912903\t2.164\t0.088\t7\n16916514\t2.705\t0.288\t257\n16916515\t2.826\t0.329\t129\n16916532\t3.054\t0.385\t17\n16916533\t3.596\t0.24\t25\n16916742\t2.215\t0.127\t1635\n16916743\t1.989\t0.141\t55\n16916751\t2.686\t0.173\t226\n16916752\t2.64\t-1.0\t1\n16916998\t2.197\t0.154\t196\n16920611\t3.015\t0.264\t187\n16920628\t3.279\t0.255\t239\n16920629\t3.195\t0.403\t63\n16920838\t2.164\t0.108\t13670\n16920839\t2.524\t0.134\t43\n16920847\t2.176\t0.207\t50\n16920848\t2.785\t0.214\t9\n16921094\t2.117\t0.097\t16\n16990260\t3.228\t0.382\t40\n16990261\t3.606\t0.35\t107\n16990470\t2.49\t0.154\t812\n16990471\t2.273\t0.267\t50\n16990472\t3.042\t-1.0\t1\n16990479\t3.31\t0.124\t16\n16990726\t2.535\t0.253\t17\n16994357\t3.54\t0.331\t863\n16994566\t2.373\t0.134\t5123\n16994567\t2.597\t0.154\t114\n16994575\t3.258\t0.143\t18\n16994822\t2.308\t0.108\t265\n16994823\t2.683\t0.0\t2\n17846534\t1.807\t0.004\t6\n17850630\t1.686\t0.082\t194786\n17850631\t1.634\t0.082\t26774\n17850632\t1.542\t0.034\t5\n17850639\t2.101\t0.105\t7379\n17850640\t2.077\t0.073\t1123\n17850886\t1.624\t0.087\t18128\n17850887\t1.587\t0.111\t90\n17850896\t2.041\t0.093\t13784\n17854727\t1.605\t0.077\t739\n17854735\t1.988\t0.193\t481\n17854736\t2.01\t0.157\t103\n17854982\t1.518\t0.05\t118\n17854983\t1.299\t0.035\t2\n17854991\t2.079\t0.0\t2\n17854992\t1.872\t0.081\t564\n17858824\t1.212\t0.0\t2\n17887503\t2.816\t0.232\t70\n17887504\t2.775\t-1.0\t1\n17887750\t2.038\t0.159\t42\n17887760\t2.72\t0.033\t2\n17891600\t2.75\t0.187\t12\n17891856\t2.984\t-1.0\t1\n18899462\t1.586\t0.08\t708\n18899472\t2.099\t0.117\t10\n18940432\t2.57\t0.156\t5\n33611790\t2.862\t0.219\t107\n33611809\t3.023\t-1.0\t1\n33611810\t1.697\t0.952\t3\n33611828\t3.382\t-1.0\t1\n33612038\t2.267\t0.06\t19\n33612039\t2.076\t0.084\t9\n33612040\t2.213\t0.116\t7\n33612047\t3.299\t0.356\t32\n33612048\t2.829\t-1.0\t1\n33612294\t2.498\t0.086\t4\n33624117\t2.68\t0.0\t2\n33624326\t2.051\t0.166\t7\n33624328\t1.644\t0.085\t2970\n33685536\t3.587\t0.192\t22\n33685537\t3.362\t0.618\t7\n33685539\t2.768\t-1.0\t1\n33685766\t2.418\t0.096\t23\n33685767\t2.3\t-1.0\t1\n33685768\t1.911\t0.307\t75\n33685775\t3.061\t0.334\t74\n33685776\t3.159\t0.258\t11\n33686022\t2.244\t-1.0\t1\n33689633\t2.268\t0.368\t3\n33689634\t3.2\t0.0\t2\n33689653\t3.142\t0.113\t4\n33689862\t1.874\t0.13\t10\n33689863\t1.999\t-1.0\t1\n33689864\t2.138\t0.163\t58\n33689871\t2.766\t0.099\t11\n33689872\t2.702\t0.904\t6\n33693731\t3.211\t0.049\t4\n33693748\t3.96\t0.381\t8\n33693749\t3.32\t0.198\t7\n33693958\t2.081\t0.047\t6\n33693959\t2.112\t0.21\t9\n33693960\t1.88\t0.205\t162\n33693967\t2.503\t0.176\t332\n33697844\t3.872\t0.0\t2\n33698055\t1.967\t-1.0\t1\n33698056\t1.612\t0.028\t8\n33767476\t2.657\t-1.0\t1\n33767477\t3.446\t-1.0\t1\n33767686\t2.131\t0.005\t3\n33767687\t2.1\t-1.0\t1\n33767688\t2.267\t0.518\t6\n33767695\t2.857\t0.194\t7\n33767696\t3.719\t0.957\t3\n33771573\t3.614\t0.457\t10\n33771783\t2.249\t0.088\t5\n33771784\t2.127\t0.16\t106\n33771791\t3.098\t-1.0\t1\n33771792\t3.166\t0.428\t3\n34623750\t1.78\t0.012\t7\n34627846\t1.55\t0.083\t65623\n34627847\t1.486\t0.077\t27424\n34627848\t1.404\t0.071\t156637\n34627855\t2.044\t0.135\t373\n34627856\t1.945\t0.103\t4751\n34628102\t1.526\t0.109\t716\n34628112\t1.965\t0.141\t8\n34631943\t1.436\t0.08\t1641\n34631944\t1.371\t0.063\t17326\n34631951\t1.879\t0.175\t1347\n34631952\t1.901\t0.158\t89\n34632198\t1.396\t0.123\t200\n34632199\t1.374\t0.136\t116\n34632207\t2.095\t0.0\t2\n34632208\t1.812\t0.114\t109\n34636040\t1.131\t0.253\t79\n34636047\t1.751\t0.123\t5003\n34636048\t1.76\t0.092\t2467\n34636294\t1.228\t0.157\t96\n34636295\t1.111\t0.035\t20\n34636304\t1.661\t0.085\t34493\n34664719\t2.605\t0.159\t86\n34664720\t2.299\t0.162\t912\n34664966\t1.951\t0.174\t35\n34664967\t1.804\t0.217\t28\n34664975\t2.749\t0.0\t2\n34664976\t2.399\t-1.0\t1\n34668816\t2.417\t0.111\t4\n34669062\t1.893\t0.17\t143\n34669071\t2.291\t0.138\t2\n35676678\t1.475\t0.093\t37\n52453894\t1.376\t0.081\t8518\n52453895\t1.293\t0.068\t14577\n52453896\t1.593\t0.165\t45\n52453903\t1.768\t0.204\t5\n52457991\t1.263\t0.085\t581\n52458000\t1.392\t0.156\t3\n83914759\t1.547\t0.085\t5\n83915013\t1.739\t0.204\t7\n83915014\t1.572\t0.079\t50584\n83915015\t1.539\t0.074\t8699\n83915023\t1.977\t0.137\t53\n83919110\t1.558\t0.068\t8984\n83919111\t1.575\t0.101\t961\n83919119\t2.014\t0.019\t9\n83951650\t2.389\t0.04\t4\n83951878\t1.973\t0.109\t22593\n83951879\t1.799\t0.11\t991\n83951887\t2.464\t-1.0\t1\n83951888\t2.672\t0.158\t11\n84025378\t2.575\t0.005\t2\n84025606\t2.151\t0.135\t549\n84025607\t2.077\t0.132\t184\n84959494\t1.626\t0.085\t32317\n84959495\t1.575\t0.081\t14689\n84959503\t2.111\t0.074\t20\n84959504\t2.015\t0.127\t36\n84963591\t1.557\t0.073\t2345\n84963599\t1.935\t0.256\t2\n84963600\t2.2\t0.296\t11\n100802822\t2.071\t0.051\t5\n100802823\t1.97\t0.021\t4\n101732615\t1.731\t0.197\t7\n101736710\t1.567\t0.082\t49304\n101736711\t1.502\t0.079\t23379\n101736719\t2.028\t0.119\t39\n101736720\t1.978\t0.107\t31\n101740807\t1.481\t0.072\t2974\n101740815\t1.989\t0.139\t38\n101740816\t1.737\t0.078\t11\n101773584\t2.915\t0.094\t4",H))[0],t=Jl.uGb(e,Zt,I),Ql.wv=vf(yl.tlb,z,6,t,15,1),Ql.xv=vf(yl.slb,kt,6,t,15,1),Ql.yv=vf(yl.slb,kt,6,t,15,1),Ql.vv=vf(yl.tlb,z,6,t,15,1),i=0;i<t;i++)if(r=n[i+1],4==(s=Jl.VHb(r,"\t")).length)try{Ql.wv[i]=Jl.uGb(s[0],Zt,I),Ql.xv[i]=$g(s[1]),Ql.yv[i]=$g(s[2]),Ql.vv[i]=Jl.uGb(s[3],Zt,I)}catch(n){if(_f(n=ag(n),53))break;throw og(n)}Ql.Av=!0}},Ql.Kv=function(n){var t,e,i,s;for(Ql.Av||Ql.Jv(),s=zn,i=cn,e=0;e<12;e++){if(0==(t=s>=Ql.wv.length||n<Ql.wv[s]?-1:n==Ql.wv[s]?0:1))return s;s=t<0?s-i:s+i,i=i/2|0}return-1},zf(525,1,{},Ql.Dv),Ql.Av=!1,yl.tmb=lg(525),Ql.Lv=function(n,t){n.q=Ql.Iw(new Ql.Lw(n.o,t),n)},Ql.Mv=function(t,e){var i,s,r,a,o,l,f,g,u;return i=Ql.Sv(t,e[0]),s=Ql.Sv(t,e[1]),r=Ql.Sv(t,e[2]),a=Ql.Sv(t,e[3]),f=new xl.Kh(s.a-i.a,s.b-i.b,s.c-i.c),g=new xl.Kh(r.a-s.a,r.b-s.b,r.c-s.c),u=new xl.Kh(a.a-r.a,a.b-r.b,a.c-r.c),o=new xl.Kh(f.b*g.c-f.c*g.b,-(f.a*g.c-f.c*g.a),f.a*g.b-f.b*g.a),l=new xl.Kh(g.b*u.c-g.c*u.b,-(g.a*u.c-g.c*u.a),g.a*u.b-g.b*u.a),-n.Math.atan2(n.Math.sqrt(g.a*g.a+g.b*g.b+g.c*g.c)*(f.a*l.a+f.b*l.b+f.c*l.c),o.a*l.a+o.b*l.b+o.c*l.c)},Ql.Nv=function(n,t){return Ql.Qv(n,t),Ql.ww(n.q,t.q)},Ql.Ov=function(n,t){var e;for(e=0;e<t.q;e++)xl.Fh(n.k[e],t.J[e])},Ql.Pv=function(n,t){var e;for(e=0;e<t.k.length;e++)xl.Fh(n.k[e],t.k[e]);null==t.j?n.j=null:n.j=Fl.GOb(t.j,t.j.length)},Ql.Qv=function(n,t){var e;n.q&&t.q||(e=new Ql.Kw(n.o),!n.q&&(n.q=Ql.Iw(e,n)),!t.q&&(t.q=Ql.Iw(e,t)))},Ql.Rv=function(n,t){return null==n.j?-1:n.j[t]},Ql.Sv=function(n,t){return n.k[t]},Ql.Tv=function(n){return null==n.p?n.o.P:n.p},Ql.Uv=function(n,t){return n.k[t].a},Ql.Vv=function(n,t){return n.k[t].b},Ql.Wv=function(n,t){return n.k[t].c},Ql.Xv=function(n,t,e){for(null==n.j&&(n.j=vf(yl.Kwb,it,6,n.o.r,15,1),Fl.LOb(n.j));e<0;)e=e+360<<16>>16;for(;e>=360;)e=e-360<<16>>16;n.j[t]=e},Ql.Yv=function(n,t,e){xl.Fh(n.k[t],e)},Ql.Zv=function(n,t,e){n.k[t]=e},Ql.$v=function(n,t){n.p=t},Ql._v=function(n,t,e){n.k[t].a=e},Ql.aw=function(n,t,e){n.k[t].b=e},Ql.bw=function(n,t,e){n.k[t].c=e},Ql.cw=function(n,t){var e;for(!t&&(t=xl.mu(n.o)),e=0;e<t.q;e++)xl.Fh(t.J[e],n.k[e]);return null!=n.p&&xl.Gm(t,n.p),t},Ql.dw=function(n){var t;for(this.o=n,this.k=vf(yl.Mlb,Mt,32,n.q,0,1),t=0;t<n.q;t++)this.k[t]=new xl.Lh(n.J[t]);this.n=NaN},Ql.ew=function(n){Ql.fw.call(this,n,n.o)},Ql.fw=function(n,t){var e;for(this.o=t,this.k=vf(yl.Mlb,Mt,32,n.k.length,0,1),e=0;e<this.k.length;e++)this.k[e]=new xl.Lh(n.k[e]);null!=n.j&&(this.j=Fl.GOb(n.j,n.j.length)),this.p=null==n.p||Jl.JHb(n.p)?n.p:Jl.HHb(n.p,U),this.n=NaN},zf(79,1,{79:1,19:1},Ql.ew),o.Eb=function(n){return Ql.Nv(this,n)},o.n=0,yl.umb=lg(79),Ql.iw=function(n,t){var e,i,s,r,a;return null==t?null:(a=Fl.tNb(n.c,t))?a:(i=kl.TTb("<").length,(Jl.KHb(kl.TTb(t).substr(kl.TTb(t).length-i,i),"<")||(s=kl.TTb("-").length,Jl.KHb(kl.TTb(t).substr(kl.TTb(t).length-s,s),"-")))&&(a=Fl.tNb(n.c,(r=kl.TTb("<").length,Jl.KHb(kl.TTb(t).substr(kl.TTb(t).length-r,r),"<")?Jl.YHb(t,0,kl.TTb(t).length-1)+">":(e=kl.TTb("-").length,Jl.KHb(kl.TTb(t).substr(kl.TTb(t).length-e,e),"-")?Jl.YHb(t,0,kl.TTb(t).length-1)+"+":t))))?(a=new Ql.dx(a),Fl.oRb(n.c,t,a),a):null)},Ql.jw=function(n,t){var e,i,s,r,a,o,l,f,g,u,h,d,c,b,D,j,m,A,C;for(n.b|=t,m=Jl.VHb("daD@h@\\H\\D\\L\\B\\Djfdrjj`Cj`XZV^[lgl|WjBp^C~RQdp\ndaDD`HP@cIICISKUT@]LCbURss\\bCPVCp_rPmV@\ndaDH@@RfzaJjjbHGWPhxdtl|yXEGDfgf}HDoTE`|G|dC]`<\ndaDH@@RfzaJjjbHGWPhxdtl|yqGDf}HDoTE`|G|dC]`<\ndaDH@@RfzaJjjbHGWPhxdtl|yqGDf}HDoTE`|G|dC]`>\ndaT@`@\\DjfjZn[jjjkJcKhGP`phxdtl|wY@xD`uyo]{|lKUfp\ndax@@DiU[zh@zHfegfzLG``\ndax@@DiYn`@@wHmumm}l=\ndax@@DiYn`@@wHmumm}t=\ndax@@DiYn`@@wHmumn}t=\ndax@@DiYn`@@wHmuum}t\ndax@@DiYn`@@wHmuun}t=\ndax@@DiYn`@@wHnuun}t=\ndax@@DiYn`h@zsEgfyEnmlG``=\ndax@@DiYnf@@zaJyEnnmom`=\ndax@@DiYnf@@zaJyEvnmom`=\ndax@@DiYnf@@zqDffyEv`mom`=\ndax@@DiYnf@@zqDffyEv`mon`\ndax@@DiYnf@@zqDff~TEm}l=\ndax@@DiYnf@@zqDff~Uyn}t=\ndax@@DiYnf@@zqDfjyEv`mom`=\ndax@@DiYnf@@zqDfj~TEm}l=\ndax@@Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@@Djfjjh@zDFEGDfeggI@phdwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggM@phdtwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggN@pdwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggN@plwY@xD`tE`}x\ndax@@Djfjjh@zDFEGDjegj{HG@dF`lG``\ndax@@DjfjjjHP]BCBcbSRssd`XRV[l`\\BPZBp^|>\ndax@@DjfjjjHP]BCBcbSRsug@XR[l`\\BPZBp^B<\ndax@@DjfjjjHP]BCBcbSRsug@XR[l`\\BPZBp^B>\ndax@D@bH\\DbL\\B\\JbFbN\\Dfnjjh@zRGGNHxlwPo]x\ndax@H@\\H\\D\\J\\Djfjjh@zXFGDegf{I{@dFoLG``\ndax@H@\\H\\D\\J\\Djfjjh@zXFGDeggN@pdwYOXD`uy`|D\ndax@H@\\H\\D\\L\\Djfjjh@zXFDfegf{I{ODF`lG``\ndax@H@\\H\\J\\F\\Djfjjh@zXFEGDgj{HG@dFoM{``\ndax@H@\\J\\F\\N\\Djfjjh@zhFEGDf{HG@dFoM{o@\ndax@H@\\J\\F\\N\\Djfjjh@zhFEGDf}HG@dFoMx\ndax@H@dDdJdFdDfnjjh@zJGDgfzDGo@\ndax@H@dDdJdFdDfnjjh@zJGDgfzE{o@\ndax@H@dDdJdFdDfnjjh@zJGDggNHxlwP`|D\ndax@H@dDdJdFdDfnjjh@zJGDggNHxlwPo]x\ndax@H@dDdJdFdDfnjjh@zJGDkfzDGo@\ndax@H@dDdJdFdDfnjjh@zJGDkgNHxlwP`}x\ndax@H@dDdJdFdDfnjjh@zJGDkjzDG``\ndax@H@dDdLdJdLbdLeUT@]EBRss]F}w`\ndax@H@dDdLdJdLbdLeUUAPNbaIZyncA{p<\ndax@H@dDdLdJdLbdLeUUAPNbaIZyncA{p>\ndax@P@BFBDiuZ{h@zHEEgfzHG``\ndax@P@QFQDiuZ{h@zHEEgfzHG``\ndax@P@\\H\\Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@P@\\H\\Djfjjh@zDFEGDjegj{HG@dF`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf{Q{@dF`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf{Q{OEz`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf}YxoTE`|D\ndax@P@\\H\\Djnjjj@P]\\BcbSRss]h}`R}PVCpP<\ndax@P@\\H\\Djnjjj@P]\\BcbSRss]h}`R}PVCpP>\ndax@P@\\H\\Djnjjj@P]\\BcbSRss^lBWjBp^B<\ndax@P@\\H\\Djnjjj@P]\\BcbSRss^lBWjBp^B>\ndax@Q@|Bh@dnRjZjj`Ck`XT\\ZV^[t`\\CPVCpP\ndax@R@BH|HeIijjj@NnaQqIiYyoV^KuAXOA@\ndax@R@QH|HeIijjj@NnaQqIiYyoV^KuAXOA@\ndax@R@\\H\\HyJkjjj@NnAQqIiYyoV^KuAXOA@\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEgf{I{OEzoLG``\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEggI@phdwYOYxoUy`|D\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEggN@pdwYOYxoUy`|D\ndax@X@kDdLdJkFdNdLbdLeUT@]IBR\ndax@`@BDf]j^@@zbJyAoMmom`=\ndax@`@BDf]j^@@zbJyAoNmom`=\ndax@`@BDf]j^@@zbJyAoNmwn`=\ndax@`@\\Df]j^@@zRGFyA{Nmom`=\ndax@`@\\Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEGDfegf{HG@ez`lG``\ndax@`@\\Djfjjh@zDFEGDjegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEGHjegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEKHjegf{HG@dF`lG``\ndax@`@\\LddUUUr@]LBcbRss\\dC`RCwP\ndax@`@dDffjjjHP]]BcbSRssgHTR[u`RCPVCpP<\ndax@b@|@eJijjj@NaAaQqIiYynrApI^hKAxH\ndax@b@|@eJijjj@NaAaQqIiYynrAsq^hKAxH\ndax@b@|@eJijjj`DGP`phyDtl|wY@xDoTE`|D<\ndax@b@|@eJijjj`DGP`phyDtl|wY@xDoTE`|D>\ndax@h@BDdLdJdFdLbdLeUT@]YBSs]@}w`\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf{I{OEz`lG``\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf{I{OEz`lG`ddEB\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf}I{OTE`|D\ndax@h@\\H\\D\\L\\J\\Djfjjh@zhFDegf{I{ODFoLG``\ndax@h@\\H\\D\\L\\J\\Djfjjh@zhFDeggI@phdwYOYx`uy`|D\ndax@h@\\H\\D\\L\\J\\Djfjjj@P]TCBRssg@XR[lgl|PZ|p^B<\ndax@h@\\H\\D\\L\\J\\Djfjjj@P]TCBRssg@XR[lgl|PZ|p^B>\ndax@h@dDdLdJdFdLbdLeUT@]YBSs^NB\ndax@h@dDdLdJdFdLbdLeUT@]YBSs^N|\ndax@h@dDdLdJdFdLbdLeUT@]YBSu^NB\ndax@h@kDdLdJdFdLbdLeUT@]YBSs^N|\ndax@p@\\H\\D\\Djfjjh@zxFGDfegf{I{@dF`lG``\ndax@p@\\H\\D\\Djfjjh@zxFGDfegj{I{@dF`lG``\ndax@p@\\J\\F\\Djfjjh@zXFEGDgf{HG@dFoM{``\ndax@p@\\J\\F\\Djfjjh@zXFEGDgj{HG@dFoM{``\ndax@p@\\J\\F\\DjfjjjHP]LCBcbSs^dC`RCWnB<\ndax@p@\\J\\F\\DjfjjjHP]LCBcbSs^dC`RCWnB>\ndax@p@dDdLdLbdLeUT@]UBSRss_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSRss_JBp^|\ndax@p@dDdLdLbdLeUT@]UBSRsu_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSRuu_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSTus_JBp^|\ndax@p@|D\\L\\DffjjjHP]MBbSRss^l|PZBp^B<\ndax@p@|D\\L\\DffjjjHP]MBbSRss^l|PZBp^B>\ndaxB@@RfRZzjjdaX`zJGDggN@hdwP`|D<\ndaxB@@RfRZzjjdaX`zJGDggN@hdwP`|D>\ndaxBRHSFCpkpslddlcUT`HdGV@d|wRo\\D>\ndaxB`HSJCprRRrMUPAtPIKOMtXOA@\ndaxD@@QIkjjj@NfaqIiYysbNIMrHMAXOA@\ndaxD@@QIkjjjbDGSPxdtl|yHEGDfyDF`lG``<\ndaxD@@QImYk`@Nhanc[{X=\ndaxD@@iIijjj@NfaQqIYynVAHKAxH\ndaxD@@iIijjj@NfaQqIYysTJNMKMrpIAXOA@\ndaxD@@iIijjjRDbCihT\\RV^\\yBcS\\lBPVCpP\ndaxD@@iIijjjRDdCihT\\RV^\\yBbs\\lBPVCw`>\ndaxD@@iIijjjRDdCihT\\RV^\\yBcS\\lBPVCpP<\ndaxD@@yIUVnz@NdaY@\ndaxDHHP@biAiCiCIICHmU@GV@xdw```\ndaxDPHP@b`cIICHmU@GU@xeL|wH`uy`|D\ndaxD`HP@cIICHmU@GS@xdtl|wH`tE`|D\ndaxD`HP@cIICHmU@GS@xeTl|wH`tE`|D\ndaxD`HPGCIICIUU@GS@xdtl|wHoTE`|D\ndaxDpJXIAICICHiCIUU@GVPd|wc``\ndaxDpJXIAICICHiCIUU@GVPd|wco@\ndaxH@@RYvjxHaAtdNM|pK[{X+\ndaxH@@RZZjj`CkhT\\RZV^[u`RCPVCpP\ndaxH@@RZZjj`CkhT\\RZV^\\lCBcbSS^lBPZBp^B\ndaxH@@RZZjj`CkhT\\RZV^\\uBcbSS^lBPZBp^B\ndaxH@@RZZjj`CkhT\\RZV^lmBcbSRs^lBPZBp^B\ndaxH@@RZZjjhQAutJNIMKONZaQqIYoVAHMAXO^@<\ndaxH@@RZZjjhaAutJNIMKONVAaQqIioVAKuAXOA@<\ndaxH@@RZZjjhaAutJNIMKONZAaQIioVAHMAXOA@<\ndaxH@@RZZjjhaAutJNIMKONZaQqIioVAKuAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aQIoVAHMAXOA@<\ndaxH@@RZZjjhaAutJNIMKON\\aQIoVAHMAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aQYoVAHMAXO^@>\ndaxH@@RZZjjhaAutJNIMKON\\aqIoVAKuAXOA@<\ndaxH@@RZZjjhaAutJNIMKON\\aqIoVAKuAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aqYoVAKuAXO^@<\ndaxHHBApapQpqpRjZjj`Cj`XZV^[tgl}PVCpP\ndaxHPJBPRPRZzjjhrAuTNIKWM|KsA{p<\ndaxHPJBPRPRZzjjhrAuTNIKWM|KsA{p>\ndaxH`HApRjzjj`Ck`T\\RZV^[u`RCPVCpP\ndaxH`HApRjzjj`Ck`T\\RZV^[ugb}PVCpP\ndaxH`HApRjzjj`Ck`T\\bjV^[u`RCPVCpP\ndaxH`HApRjzjjhAAupJNIMKOMzpI^hKAxH<\ndaxH`HApRjzjjhAAupJNIMKOMzpI^hKAxH>\ndaxH`JBHRZZjjhaAttJNIKONRaQiYnVAHKAxH>\ndaxHpJBHRHrHrJPrUUPAtTIKOMtXOA@\ndaxHpJBPRPrPrJPrUUPAtTIKOMtXOA@\ndaxHpJBPRPrPrJPrUUPAtTIKOMt[w^@\ndaxHpJBPRPrPrJPrUUTE@zJDegfzLGo@<\ndaxHpJBPRPrPrJPrUUTE@zJDegfzLGo@>\ndaxHpJBPRPrPrJPrUUTE@zJDegjzLG``<\ndaxHpJBPRPrPrJPrUUTE@zJDegjzLG``>\ndaxHpJBPRPrPrJPrUUTE@zJDekfzLGo@<\ndaxHpJBPRPrPrJPrUUTE@zJDekfzLGo@>\ndaxL@@RdfnjjjHP]UCbRsse`T\\RZV[xPVCpP<\ndaxLHHS@BJdFdNdLddlbuT@]HBR\ndaxLJHS@BJdFdNdL{IIKHmU@GR@d`\ndaxL`HS@\\LddleUT@]TBSRss_JBp^B\ndaxLhJ[`\\H\\D\\L\\B\\Djfjjh@zPFF~I{OEx\nday@@@QIkjjj@NfaqIiYysPLJIMMrHMAXOA@\ndayDaLJD@HrR{IICHmU@GU@xtl|wr`lG``\ndaz@@@RYvHx@C\\`wfvwvp=\ndaz@@@RYvHx@C\\`wfvwwP\ndaz@@@RYvHx@C\\`wgVwvp=\ndaz@@@RYvix@CjHkdF|zv~v=\ndaz@@@RYvix@CjHkdG\\zv~v=\ndaz@B@BTf]bN@@wHMymm}t\ndaz@HBApapQpqpRjZjj`Cj`XZV^[tgl}PVCpP\ndaz@bHCpBTjnjjh@zxEGDfegf}YxoTE`|D\ndaz@pJBPRPrPrJPrUUPAtTIKOMtXOA@\ndaz@pJBPRPrPrJPrUUTE@zJDegjzLG``>\ndazDHLa@BJdFdNdLddlbuT@]HBR\ndazDJLa@BJdFdNdL{IIKHmU@GR@d`\ndazD`La@BLddlbuT@]TBSRss_JBp^B\ndazH`D`OCIICHuUPBCi`\\RZV^[dWjBp^B<\ndazH`D`OCIICHuUPBCi`\\RZV^[dWjBp^B>\ndazHpFhIAICICHiCIUUPRCkHR^[qpP<\ndazHpFhIAICICHiCIUUPRCkHR^[qpP>\ndazLQFaLCpkpsfgIIKHuUHBIAu`IOMtkwA@<\ndazLQFaLCpkpsfgIIKHuUHBIAu`IOMtkwA@>\ndctD@@gHiDTeIU]uPAttNIHjnmrpIATNa@\ndctD@@gHiDTeIU]uPAttNQPjvurpIATNa@\nded@@DiUfoh@@Mr[_[G\\{@=\nded@@DiUfoh@@Mr[_]G\\}@\nded@P@\\F\\LddUTeUuPAtHJNIKOHlmvPNAHOADLa@\ndedD@@{HiDUIU]T@]MCdTrMM\\lBPQCHP\ndiD@@DiYkhJ`ChlV^Q[tVzvp^BHP=\ndiD@@DiYkhJ`ChlV^Q[tVzzp^BHP\ndiD@@DiYkhJ`ChlV^aktVzvp^BHP=\ndiD@@DiYkhJ`ChlVnaktVzvp^BHP=\ndiD@@DiYkhJ`ChlVnaktVzzp^BHP\ndiD@H@\\H\\D\\L\\LddjTjn@@z`F}QyOY{nct=\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGmcl=\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGmct\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGnct=\ndiD@`@\\LddUTjnX@zhEGDej}HG@dGnct\ndiD@`@\\LddUTjnX@zxEGDegdV}HG@dGnbD\ndiD@`@\\LddUTjnX@zxEGDegdZ}HG@dGnbD\ndiDH@@rJQERjx@CkH\\R[e`RCvqv=\ndiDH@@rJQERjx@CkH\\R[e`RCvqz\ndiDH@@rJQERjx@CkH\\bke`RCvqv=\ndiDH@@rJQERjx@CkH\\bke`RCvqz\ndiDH@@rJQERjxHaAudNIMrpI^{X{@+\ndiDH@@rJQERjxHaAudNIMrpI^{X{@-\ndiDH@@rJQERjxHaAudNIMrpI^{X}@<\ndiDH@@rJQERjy`Cih\\RV^Q[y`RBO`\ndiDH@@rJQERjy`Cih\\bf^Q[e`RCwQB\ndiF@@@rJQERjx@CkH\\R[e`RCvqv=\ndiF@`NAprRQURjx@Ch`T\\R[t`\\BP^vNp\ndiF@a@b`BX{HiDUJk`@NlarJnVAHO[Gh\ndiFH@NCHiDUJk`@NlaqInVAHO[GX\ngC`@Die@zHXir\ngC`@Die@zHXis]Knz\ngC`@Die@zHXis^Kh\ngC`@Die@zHXisgAbd\ngC`@Die@zHXisgAbfzW]t\ngC`@Die@zHXisgAbf|WP\ngC`@Dij@zHXis]HNB\ngC`@Dij@zHXis]HN|\ngC`@Dij@zHXis]Kv|\ngC`@Dij@zHXisgAbfzP\\D\ngC`@Dij@zHXisgAbfzP]x\ngC`@Dij@zHXisgAbfzWmx\ngC`@Dij@zHXiu]HNB\ngC`@Dij@zHXiugAbfzP\\D\ngC`@Dij@zHXjs]HN|\ngC`@Dij@zHXjsgAbfzP]x\ngC`@Dij@zHXju]HNB\ngC`@Dij@zHXjugAbfzP\\D\ngC`@DkZ@zHXis]SnB\ngC`@DkZ@zHXis]Sn|\ngC`@DkZ@zHXis^XH\ngC`@DkZ@zHXis^[p\ngC`@DkZ@zHXisgAbfzg\\D\ngC`@DkZ@zHXisgAbfzg]x\ngC`@DkZ@zHXisgAbf|pP\ngC`@DkZ@zHXisgAbf|w`\ngC`@DkZ@zHXiu]SnB\ngC`@DkZ@zHXiu^XH\ngC`@DkZ@zHXiugAbfzg\\D\ngC`@DkZ@zHXiugAbf|pP\ngC`B@DPHPQ`aJZ`NdFH\ngC`B@DPHPQ`aJZ`NdFN\\FJP\ngC`B@DPHWaoAJZ`NdFMto[p\ngC`D@DPHRfhChabgMt`xH\ngC`D@DPHRfhChabgN\\FJ[iApP\ngC`D@DPHRfhChabgN\\FJ[i^w`\ngC`D@DPHRfhChabkUt`xH\ngC`D@DPHRnhCkASf|pP\ngC`D@DPHRnhCkASj|pP\ngC`D@DXHRVhCiQR\ngC`D@DXHRVhCiQSgAbd\ngC`D@DXHRfhCkAbf|PP\ngC`D@DXHRfhCkAbgNCEMx``\ngC`D@DXHRfhCkAbj|PP\ngC`D@DYpRVhCiQS]Cv|\ngC`D@VPlRfhChabkUt`xH\ngC`D@VYpRfhCkAbfzP]x\ngC`D@bQDRfhChabgMt`xH\ngC`D@bQDRfhChabkUt`xH\ngC`D@bSpRnhCkASfzglD\ngC`D@xYpRVhCiQS]Cv|\ngC`D@xYpRVhCiQSgAbfzGmx\ngC`DABPHRVhCkQSj|pP\ngC`DADZHRVhCiQR\ngC`DAb[DRVhCiQR\ngC`DAx[pRVhCiQR\ngC`DAx[pRVhCiQS]Cv|\ngC`Dax[pDzTej@zTTwP}o@\ngC`H@DIKRAuhir\ngC`H@DIKTAuhis]CvB\ngC`H@DIKTAuhis^XH\ngC`H@DIKTAuhis^[p\ngC`H@DIKTAuhisgAbfzGlD\ngC`H@DIKTAuhisgAbf|pP\ngC`H@DIKTAuhisgAbf|w`\ngC`H@DIKTAuhiu]CvB\ngC`H@DIKTAuhiu^XH\ngC`H@DISRAtPqSfzP]t\ngC`H@DISRAtPqSf|PP\ngC`H@DISRAtPqSgNCEMt`{h\ngC`H@DISRAtPqSgNCEMx``\ngC`H@DISRAtPqUfzP]t\ngC`H@DISRAtPqUgNCEMt`{h\ngC`H@DISTAtPqSfzP\\D\ngC`H@DISTAtPqSfzP]x\ngC`H@DISTAtPqSfzWlD\ngC`H@DISTAtPqSgNCEMt`xH\ngC`H@DISTAtPqSgNCEMt`{p\ngC`H@DISTAtPqSgNCEMtoXH\ngC`H@DISTAtPqSjzP\\D\ngC`H@DISTAtPqSjzWlD\ngC`H@DISTAtPqSkNCEMt`xH\ngC`H@DISTAtPqUfzP\\D\ngC`H@DISTAtPqUfzP]x\ngC`H@DISTAtPqUgNCEMt`xH\ngC`H@DISTAtPqUjzP\\D\ngC`H@VIKTAuhis]CvB\ngC`H@bIKTAuhis^XH\ngC`H@bISRAtPqSf|PP\ngC`H@bISTAtPqSfzP\\D\ngC`H@bISTAtPqSgNCEMt`xH\ngC`H@bISTAtPqSjzP\\D\ngC`H@bISTAtPqUfzP\\D\ngC`H@bISTAtPqUjzP\\D\ngC`H@xIKRAuhis^Cp\ngC`H@xIKTAuhis]CvB\ngC`H@xIKTAuhis]Cv|\ngC`H@xIKTAuhis^XH\ngC`H@xIKTAuhisgAbfzGlD\ngC`H@xIKTAuhiu]CvB\ngC`HADIKTAuhis^XH\ngC`HAVIKTAuhis^XH\ngC`HAbIKTAuhis^XH\ngC`HAxIKTAuhis]CvB\ngC`HAxIKTAuhis^XH\ngC`HAxIKTAuhisgAbfzGlD\ngC`HAxIKTAuhiu]CvB\ngC`HMPISTAu`qS]HN|\ngC`HMPISTAu`qS^HH\ngC`IAVBTii@zHXjs]HNz\ngC`IAxBTej@ztTyna{A@\ngC`IAxBTej@ztTys`qS]CvB\ngC`IMP[dij@zpXindG^@\ngC`L@DPHPPeMPGVCGMy``\ngC`L@DPHPPeMPGVCGMyo@\ngC`L@DPHPPeMPGVCGUy``\ngC`L@DPHPPeMPGVCGV\\FJ[sA@\ngC`L@VPHPPeMPGVCGMy``\ngC`L@bPHPPeMPGVCGMy``\ngC`PAEdij@zPXypXi@\ngC``@deZ@ztTyoLD\ngC``ADij@zHXis]HN|\ngC``ADij@zHXis]Kv|\ngC``ADij@zHXisgAbfzP\\D\ngC``ADij@zHXisgAbfzP]x\ngC``ADij@zHXisgAbfzWmx\ngC``Adej@zTT`\ngC``Adej@zTTypXi@\ngC``Adij@zpXioDD\ngC``Adij@zpXioEx\ngC``Adij@zpXis`qS^HH\ngC``Adij@zpXjoDD\ngC``Adij@zpXjs`qS^HH\ngC`hH`xIKTAuhis]Cv|\ngCa@@dkHGVbgH\ngCa@@dkHGVbgMyn`\ngCa@@dkPGVbgMy``\ngCa@@dmHGVbgH\ngCa@@dmHGVbgMyn`\ngCa@@dmHGVbgN\\FJP\ngCa@@dmHGVbgN\\FJ[s]@\ngCa@@dmPGVbgMy``\ngCa@@dmPGVbgMyo@\ngCa@@dmPGVbgN\\FJ[sA@\ngCa@@dmPGVbgN\\FJ[s^@\ngCa@@dmPGVbgUy``\ngCa@@dmPGVbgV\\FJ[sA@\ngCa@@eMHGQCEN[iAwP\ngCa@@eMHGQCEN[qA@\ngCa@@eMHGQCEN[q^@\ngCa@@eMHGQCEN\\xLTwRCn`\ngCa@@eMHGQCEN\\xLTwbB\ngCa@@eMHGQCEV[iAwP\ngCa@@eMHGQCEV\\xLTwRCn`\ngCa@@eMHGQCEV\\xLTwbB\ngCa@@eMPGQCEN[iApP\ngCa@@eMPGQCEN[iAw`\ngCa@@eMPGQCEN[i^pP\ngCa@@eMPGQCEN[i^w`\ngCa@@eMPGQCEN\\xLTwRC``\ngCa@@eMPGQCEN\\xLTwRCo@\ngCa@@eMPGQCEN\\xLTwR}``\ngCa@@eMPGQCEN\\xLTwR}o@\ngCa@@eMPGQCENkiApP\ngCa@@eMPGQCENki^pP\ngCa@@eMPGQCENlxLTwRC``\ngCa@@eMPGQCENlxLTwR}``\ngCa@@eMPGQCEV[iApP\ngCa@@eMPGQCEV[iAw`\ngCa@@eMPGQCEV\\xLTwRC``\ngCa@@eMPGQCEV\\xLTwRCo@\ngCa@@eMPGQCEVkiApP\ngCa@@eMPGQCEVlxLTwRC``\ngCaH@jAJZ`NlFN[i^pP\ngCaH@jAJZ`NlFN\\xLTwR}``\ngCaH@jAJZ`NlFN\\xLTwfB\ngCaH@jAJZ`NlFN\\xLTwf|\ngCaHDGAIZ`NmEN[h^pP\ngCaHH@aIZ`NmEN[h^pP\ngCaHH@aIZ`NmEN[h^w`\ngCaHH@aIZ`NmEN\\xLTwP}``\ngCaHHGAIZ`NmEN[h^pP\ngCaHHGAIZ`NmEN[h^w`\ngCaHHGAIZ`NmEN\\xLTwP}``\ngCaHHGAIZ`NmENkh^pP\ngCaHHOAIZ`NmEN[h^pP\ngCaHHOAIZ`NmEN[h^w`\ngCaHHOAIZ`NmEN[sA@\ngCaHHOAIZ`NmEN\\xLTwP}``\ngCaHHOAIZ`NmEN\\xLTwP}o@\ngCaHHOAIZ`NmEN\\xLTwf|\ngCaHHOAIZ`NmENkh^pP\ngCaHHOAIZ`NmENlxLTwP}``\ngCaHL@aIZ`NeEH\ngCaHL@aIZ`NeEN\\FJP\ngCaHLDQIZ`NeEH\ngCaHLGAIZ`NeEMxO@\ngCaHLHaIZ`NeEH\ngCaHLLQIZ`NeEH\ngCaHLOAIZ`NeEMxO@\ngCaI@jA\\eMPGVCGMtoXH\ngCaIHO@RdmPGVbgMtOXH\ngCaIHO@RdmPGVbgN\\FJ[h^pP\ngCaIL@`RdmPGRbd\ngCd@@deZ@ztTyoLG}h`\ngCd@@deZ@ztTys`qS^XO{Q@\ngCd@@deZ@ztTzoLG}h`\ngCd@@deZ@ztTzs`qS^XO{Q@\ngCd@ADie@zHXis]Kn{~rD@\ngCd@ADie@zHXis^Ko{HP\ngCd@ADie@zHXisgAbfzW]w}dH\ngCd@ADie@zHXis~rD@\ngCd@ADif@zHXis]KnC~rD@\ngCd@ADif@zHXis^XO{HP\ngCd@ADif@zHXisgAbfzW\\G}dH\ngCd@ADif@zHXisgAbf|p_vP`\ngCd@ADif@zHXiu]KnC~rD@\ngCd@ADif@zHXiu^XO{HP\ngCd@ADij@zHXis]HNC~rD@\ngCd@ADij@zHXis]HNC~t@\ngCd@ADij@zHXiu]HNC~rD@\ngCd@ADij@zHXju]HNC~rD@\ngCd@ADkj@zpTzoLD\ngCd@AdeY@zTT`\ngCd@Adej@zTT`\ngCd@Adej@zTTypXi@\ngCd@Adij@zpXioDG}h@\ngCd@Adij@zpXis`qS^HO{P@\ngCd@Adij@zpXjoDG}h@\ngCd@Adij@zpXjs`qS^HO{P@\ngCd@aAteJz`NlEN[sAZ@\ngCd@aAteJz`NlEN[s^Z@\ngCd@aaNeIZ`NeEH\ngCd@aaNeIZ`NeEN\\FJP\ngCd@aaNeIZ`NeEN\\FJ[h^w`\ngCd@aaNeIZ`NeEN\\FJ[p^@\ngCdAAIrTs@]DLTznewAYB@\ngCdAAaJRu@]JJP\ngCdAAaJRu@]JJ[p^@\ngCdAAaJRu@]JJ\\xLT`\ngCdAAaJRu@]JJ\\xLTw`|\ngCdDE`DPHRfhCiAb\ngCdHH`DIKRAuhis]Cv{~rb@\ngCdHH`DIKRAuhis^Cw{JH\ngCdHI`DIKTAthis`qS^Cw{R@\ngCe@E`dkPGRbg}h`\ngCh@@dkHGVbgH\ngCh@@dkPGVbgMy``\ngCh@@dmHGVbgH\ngCh@@dmHGVbgMyn`\ngCh@@dmHGVbgN\\FJP\ngCh@@dmHGVbgN\\FJ[s]@\ngCh@@dmPGVbgMtOXH\ngCh@@dmPGVbgMy``\ngCh@@dmPGVbgMyo@\ngCh@@dmPGVbgN\\FJ[h^pP\ngCh@@dmPGVbgN\\FJ[sA@\ngCh@@dmPGVbgN\\FJ[s^@\ngCh@@dmPGVbgUy``\ngCh@@dmPGVbgV\\FJ[sA@\ngCh@@eLhGQCEN\\xLTwR{nm@\ngCh@@eLhGQCEN\\xLTwb{~t@\ngCh@@eMHGQCEN[iAw_v`@\ngCh@@eMHGQCEN[i^w_v`@\ngCh@@eMHGQCEN[qAZ@\ngCh@@eMHGQCEN\\xLTwRCnm@\ngCh@@eMHGQCEN\\xLTwbC~t@\ngCh@@eMHGQCEV[iAw_v`@\ngCh@@eMHGQCEV[qAZ@\ngCh@@eMPGQCEN[iApP\ngCh@@eMPGQCEN[iAp_v`@\ngCh@@eMPGQCEN[iAw`\ngCh@@eMPGQCEN[iAwov`@\ngCh@@eMPGQCEN[i^pP\ngCh@@eMPGQCEN\\xLTwRC``\ngCh@@eMPGQCEN\\xLTwRC`m@\ngCh@@eMPGQCEN\\xLTwRCo@\ngCh@@eMPGQCEN\\xLTwRCo_m@\ngCh@@eMPGQCEN\\xLTwR}``\ngCh@@eMPGQCENkiApP\ngCh@@eMPGQCENkiAp_v`@\ngCh@@eMPGQCENki^pP\ngCh@@eMPGQCENlxLTwRC``\ngCh@@eMPGQCEV[iApP\ngCh@@eMPGQCEV[iAp_v`@\ngCh@@eMPGQCEV[iAwov`@\ngCh@@eMPGQCEV\\xLTwRC``\ngCh@@eMPGQCEV\\xLTwRC`m@\ngCh@@eMPGQCEVkiApP\ngCh@@eMPGQCEVkiAp_v`@\ngCh@@e[PGQCEN[j]p_v`@\ngCh@@e[PGQCEN[sAZ@\ngCh@@e[PGQCEN[s^Z@\ngCh@@e[PGQCEN\\xLTwT{`m@\ngCh@@e[PGQCENkj]p_v`@\ngCh@@e[PGQCENksAZ@\ngCh@@e[PGQCENlxLTwT{`m@\ngChA@IRUdCkQSf|GP\ngChA@IRVdCkQSd\ngChA@IRVhCkQSfzGlD\ngChA@IRVhCkQSf|pP\ngChA@IRVhCkQSf|w`\ngChA@IRVhCkQSgNCEMtOXH\ngChA@IRVhCkQSgNCEMy``\ngChA@IRVhCkQSgNCEMyo@\ngChA@IRVhCkQSj|pP\ngChA@IRVhCkQSkNCEMy``\ngChA@IRfhChabgMt`xH\ngChA@IRfhChabgMt`{p\ngChA@IRfhChabgMtoXH\ngChA@IRfhChabgN\\FJ[iApP\ngChA@IRfhChabgUt`xH\ngChA@IRfhChabgUtoXH\ngChA@IRfhChabgV\\FJ[iApP\ngChA@IRfhChabkUt`xH\ngChA@IRmhChabgMuNxO{P@\ngChA@IRmhChabgMy`m@\ngChA@IRmhChabgN\\FJ[j]p_v`@\ngChA@IRmhChabgUuNxO{P@\ngChDD@bABUt`]XJ\\wf{~tP\ngChDDDRHbUt`]XJ\\wf{~tP\ngChHD@aIZ`NmEN[h^p_vb@\ngChHDOAIZ`NmENkh^p_vb@\ngChHH@aIZPNmEN[h^w_vd@\ngChHH@aIZ`NmEN[h^p_vd@\ngChHH@aIZ`NmEN[h^wovd@\ngChHH@aIZ`NmEN\\xLTwP}`mH\ngChHH@aIZ`NmENkh^p_vd@\ngChHH@aJZPNbFJlypXindG]ZP\ngChHHOAIZ`NmEN[h^p_vd@\ngChHHOAIZ`NmEN\\xLTwP}`mH\ngChHHOAIZ`NmENkh^p_vd@\ngChHL@aIZ`NeEH\ngChHL@aIZ`NeEMxO@\ngChHL@aIZ`NeEN\\FJP\ngChHL@aJZ`NlFJ[qA@\ngChHL@aJZ`NlFJ\\xLTwbB\ngChHLHaIZ`NeEH\ngChHLLQIZ`NeEH\ngChHLOAIZ`NeEH\ngChIDOARdmPGVbgMtOXH\ngChIHOBRdkPGVbgMy`mH\ngChIL@cRdmPGRbd\ngChIL@cRdmPGRbf|G`\ngChILLSRdmPGRbd\ngCh`LHe]PGRBd\ngCi@DDeZ@ztTyoLG}h`\ngCi@DDeZ@ztTyoM{}h`\ngCi@DDeZ@ztTzoLG}h`\ngCi@HDii@zHXis]HN{~t`\ngCi@HDii@zHXis^HO{R@\ngCi@HDii@zHXisgAbfzP]w}i@\ngCi@HDii@zHXjs]HN{~t`\ngCi@HDij@zHXis]HNB\ngCi@HDij@zHXis]HNC~t`\ngCi@HDkj@zpTyoLD\ngCi@HDkj@zpTyoMx\ngCi@HDkj@zpTys`qS^XH\ngCi@HDkj@zpTzoLD\ngCi@LDej@zTT`\ngCi@LDej@zTTypXi@\ngCi@LDej@zTTypXioMx\ngCi@LDij@zpXioDD\ngCi@LDij@zpXis`qS^HH\ngCi@LDij@zpXjs`qS^HH\ngCiALMJRu@]JJP\ngCiALMJRu@]JJ[s^@\ngCiALMJRu@]JJ\\xLT`\ngCiALMJRu@]JJ\\xLTwf|\ngCl@ADe[PGVBgUy`l``\ngClAADnRmhCkASj|p_vPP\ngFp@DjYZXHCkASfyW]x{nrTrp=\ngFp@DjYZjjQCiabgIZyHXis\\kv|_WwyJYX<\ngFp@DjxujhCiabgIZwL{`dMC~RvN@\ngFp@LdaahUPGVrVmsMkYCPdmc`=\ngFp@LdaahUPGVrVmsMkY}__dmc`=\ngFp@LdaahUPGVrVmsMkiCPdmc`\ngFp@LdaahUTrGVrVmsMkYC__dmc`+\ngFp@LdaahUTrGVrVmsMkYC__dmc`-\ngFp@LdaahUTrGVrVmsMkiC__dmc`<\ngFp@LdaahUTrGVrVmsMkiC__dmc`>\ngFp@LddLUUPGSCENRusdyK\\pJBPtOyHZX\ngFp@LddLUUPGSCENRusdyK\\sr|PtOyHZX\ngFp@LddLUUTBGSCENRurPqRVy`Uxah_rPtp>\ngFp@LddLUUTBGSCENRus`iK\\sr|PtOyHZX>\ngFp@LddLUUTBGSCENRusdyK\\pJ|PtOyHZX<\ngFp@LddLUUTBGSCENRusdyK\\pJ|PtOyHZX>\ngFp@LddLUUTBGSCENRushiK\\pJ|PtOyHZX<\ngFp`@TfXujjJChqSfnSENRwVCPdmc`<\ngFp`@TizJjiRYChqSfn\\dm[iAh_rPup<\ngFp`@TizJjiRZChqSfmtoTOyHZx<\ngFp`@TizJjiRZChqSfmtoTOyHZx>\ngFp`@TizJjiRZChqSfn\\dm[iAh_rPup<\ngFp`@TizJjiRZChqSfn\\dm[iAh_rPup>\ngFp`@dfxujhChqrVmtPtOyKXx\ngFp`@dfxujhChqrVmt_WwyKXx\ngFp`@dfxujjYChqrVmtPwwyKXx<\ngFp`@dfxujjYChqrVmtPwwyKXx>\ngFq@@dmXuU@]VJ\\ek_XICPdem`\ngFq@@dsFmU@]VJ\\ek_XICPdmc`\ngFq@@dsFmU@]VJ]Ek_XICPdmc`\ngFq@@dsFmUQH]VJ]Ek_XIC__dmc`<\ngFq@@dsFmUQH]VJ]Ek_XIC__dmc`>\ngFq@@dsFuURH]VJ\\ek_XICPdmc`<\ngFq@@dsFuURH]VJ\\ek_XICPdmc`>\ngFq@@eMXuURH]LLTyKVyP\\D~h_rRvp<\ngFq@@eMqUURH]VJ\\ek_HICPdak`<\ngFq@@eMqUURH]VJ\\ek_HICPdak`>\ngFq@@eMqUURH]VJ\\ek_KqCPdak`<\ngFq@@eMqUURH]VJ\\ekdaRVm|oDMC~RFn@>\ngFq@@eMqUURH]VJ\\ekgIKV~WbFaICW@<\ngFq@@eMqUURH]VJ\\ekgIKV~WbFaICW@>\ngFq@@eMqUURH]VJ\\ekgIrV~PRFaICW@<\ngFq@@eMqUURH]VJ\\ekgIrV~PRFaICW@>\ngFq@@eMqUURH]VJ\\ekgIrV~PSzaICW@<\ngFq@@eOQUARP]JJ[yAN{o|dM\\+\ngFq@@eOQUARP]JJ[yAN{o|dM\\-\ngFq@@eOQUARP]JJ[y^N{o|dM\\+\ngFq@@eOQUARP]JJ[y^N{o|dM\\-\ngFq`@bdwFmUSP]ZNZweC~RvN@>\ngFq`ALe\\qUU@]ENRunbFaISW@\ngFx@@eMXuU@]LLTyKVyP\\Dah_rRvuh@\ngFx@@eOQMA@]JJ[y^N{o|dM\\=\ngFx@@eOQUARP]JJ[yAN{o|dM\\+\ngFx@@eOQUARP]JJ[yAN{o|dM\\-\ngFx@@eOQUARP]JJ[y^N{o|dM\\+\ngFx@@eOQUARP]JJ[y^N{o|dM\\-\ngFx@@eSFuU@]LLTyKVyP\\Dah_rVquh@=\ngFx@@eSFuU@]LLTzKVyP\\Dah_rVquh@\ngFx@@eSFuU@]LLUZKVyP\\Dah_rVqp\ngFxAAIRicZ`@NbFR\\wJC`gm{~RvN@=\ngFxAAYRicZ`@NbFR\\wJC`gm{~RvNm@=\ngFx`DBdwFmUSP]ZNZweC~RvN@<\ngFy@DDfxujhChqrVmtPtOyKXx\ngFy@DDfxujjYChqrVmtPwwyKXx<\ngFy@DDfxujjYChqrVmtPwwyKXx>\ngGP@DiWj`NbgIZwQCP`\ngGP@DjZ@@Mrm{Yw]`=\ngGP@DjZ@@Mrm{Yw^`=\ngGP@DjZ@@Mrm{Y{^`=\ngGP@DjZ@@Mrm{iw^`\ngGP@DjZ@@Mrm{i{^`=\ngGP@DjZ@@Mrn{i{^`=\ngGP@DjZ@@NZFJ\\enUw]O[t=\ngGP@DjZ@@N\\EI[e[wSn}@\ngGP@DjZ@@N\\EN[e[wSv}@\ngGP@DjZ@@N\\FN[e]wSv}@\ngGP@DjZX@NhJyV}l{np=\ngGP@DjZX@NhJyV}l{oP\ngGP@DjZX@NhJyV}l}oP=\ngGP@DjZX@NhJyV}t{np=\ngGP@DjZX@NhJyV}t{oP\ngGP@DjZX@NhJyW]l{np=\ngGP@DjZX@NhJyW]l{oP\ngGP@DjZX@NhJyW]l}oP=\ngGP@DjZX@NhJyW]t{np=\ngGP@DjZX@NhJyW]t{oP\ngGP@DjZX@NhJyW]t}oP=\ngGP@DjZX@NhKNBdmrn{iw^`\ngGP@DjZX@NhKNCDmrn{Yw^`\ngGP@DjZX@NhKNCDmrn{iw^`\ngGP@DjZX@NlEN[e]pSn{@=\ngGP@DjZX@NlEN[e]pSn{IPh`=\ngGP@DjZX@NlEN[e]pSn}@\ngGP@DjZX@NlEN[e]pSv}@=\ngGP@DjZX@NlEN[e]wcn{@=\ngGP@DjZX@NlEN[e]wcn{IPh`=\ngGP@DjZX@NlEN[e]wcn}@\ngGP@DjZX@NlEN[e]wcv}@=\ngGP@DjZX@NlEN[{AN{l=\ngGP@DjZX@NlEN[{AN{t\ngGP@DjZX@NlEN[{AO[t=\ngGP@DjZX@NlEN[{^N{l=\ngGP@DjZX@NlEN[{^N{t\ngGP@DjZX@NlEN\\xJRwJ{`g]z\ngGP@DjZX@NlEN\\xJRwJ{oG]z\ngGP@DjZX@NlEN\\xJRwvB]wh\ngGP@DjZX@NlEN\\xJRwv|]wh\ngGP@DjZX@NlEN\\xJ\\wJ{`gmz\ngGP@DjZX@NlEN\\xJ\\wvB^wh\ngGP@DjZX@NlEN\\xLRwJ{`g]z\ngGP@DjZX@NlEN\\xLRwvB]wh\ngGP@DjZX@NlEN\\xLRwv|]wh\ngGP@DjZX@NlEN\\xL\\wJ{`gmz\ngGP@DjZX@NlEN\\xL\\wvB^wh\ngGP@DjZX@NlENke]pSn{@=\ngGP@DjZX@NlENke]pSn}@\ngGP@DjZX@NlENke]pSv}@=\ngGP@DjZX@NlENk{AN{l=\ngGP@DjZX@NlENk{AN{t\ngGP@DjZX@NlENk{AO[t=\ngGP@DjZX@NlENlxJRwJ{`g]z\ngGP@DjZX@NlENlxJRwvB]wh\ngGP@DjZX@NlENlxLRwJ{`g]z\ngGP@DjZX@NlENlxLRwvB]wh\ngGP@DjZX@NlENlxL\\wJ{`gmz\ngGP@DjZX@NlENlxL\\wvB^wh\ngGP@DjZY`NbFR\\wJ{`g]z\ngGP@DjZY`NbFR\\wJ{`gmv\ngGP@DjZY`NbFR\\wJ{`gmz\ngGP@DjZY`NbFR\\wJ{oGmv\ngGP@DjZY`NbFR\\wJ{oGmz\ngGP@DjZY`NbFR\\wvB]wX\ngGP@DjZY`NbFR\\wvB^wh\ngGP@DjZY`NbFR]WJ{`gmv\ngGP@DjZY`NbFR]WJ{`gmz\ngGP@DjZY`NdJUrm{Yw]`\ngGP@DjZY`NdJUrm{iw^`\ngGP@DjZY`NdJUrn{Y{]`\ngGP@DjZY`NdJUrn{i{^`\ngGP@DjZY`NfFJ\\ek\\knB^tH\ngGP@DjZY`NfFJ\\ek]XMB\ngGP@DjZY`NfFJ\\ek_KnCP`\ngGP@DjZY`NfFJ\\ek_XI{_@\ngGP@DjZY`NfFJ\\ekfabgI[e]pSva@\ngGP@DjZY`NfFJ\\ekfabgI[kAhP\ngGP@DjZY`NfFJ\\ekfabgI[y]pZD\ngGP@DjZY`NfFJ\\ekgARVyW\\D}hP\ngGP@DjZY`NfFJ\\ekgARV~W\\Fa@\ngGP@DjZY`NfFJ\\ekgASf~W\\Fa@\ngGP@DjZY`NfFJ\\ekgAbVzpZD\ngGP@DjZY`NfFJ\\ekgAbV~W\\Fa@\ngGP@DjZY`NfFJ\\ekgAcfyW\\D}hP\ngGP@DjZY`NfFJ\\ekgAcf~W\\Fa@\ngGP@DjZY`NfFJ\\em\\knB^tH\ngGP@DjZY`NfFJ\\em]XMB\ngGP@DjZY`NfFJ\\em_KnCP`\ngGP@DjZY`NfFJ\\em_XI{P`\ngGP@DjZY`NfFJ\\emgAcfyW\\D}hP\ngGP@DjZY`NfFJ\\emgAcf~W\\Fa@\ngGP@DjZY`NfFJ]Em\\knB^tH\ngGP@DjZY`NfFJ]Em]XMB\ngGP@DjZY`NfFJ]Em_KnCP`\ngGP@DjZY`NfFJ]EmgAcfyW\\D}hP\ngGP@DjZj`NfFJ\\ek\\hNBPtH\ngGP@DjZj`NfFJ\\ekfabgI[eApRFa@\ngGP@DjZj`NfFJ\\fm\\hNBPtH\ngGP@DjZj`NfFJmFm\\hNBPtH\ngGP@DjZjdEDNfFJ\\ekdacdmr`xIC_@<\ngGP@DjZjdEDNfFJ\\ekdacdmr`xIC_@>\ngGP@DjZjdEDNfFJ\\ekfabgI[eAwbF~@<\ngGP@DjZjdEDNfFJ\\ekfabgI[eAwbF~@>\ngGP@DjZjdEDNfFJ\\ekgARVyP]xao`<\ngGP@DjZjdEDNfFJ\\ekgARVyP]xao`>\ngGP@DjZjdEDNfFJ\\ekgAbVyP\\Dao`<\ngGP@DjZjdEDNfFJ\\ekgAbVyP\\Dao`>\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\Dao`<\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\Dao`>\ngGP@DjZjdEDNfFJ\\emgAbVyP\\DahP<\ngGP@DjZjdEDNfFJ\\emgAbVyP\\DahP>\ngGP@DjZjdEDNfFJ\\emgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\emgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ\\fmgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\fmgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ]EkfabgI[eApRF~@<\ngGP@DjZjdEDNfFJ]EkfabgI[eApRF~@>\ngGP@DjZjdEDNfFJ]Em\\hNBPtH<\ngGP@DjZjdEDNfFJ]Em\\hNBPtH>\ngGP@DjZjdEDNfFJ]EmgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ]EmgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ]FmgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\ekfabgI[eAwbF~@\ngGP@DjZjdEHNfFJ\\ekgARVyP]xao`\ngGP@DjZjdEHNfFJ\\ekgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ\\ekgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ\\ekgAcfyP\\DahP\ngGP@DjZjdEHNfFJ\\emgAbVyP\\DahP<\ngGP@DjZjdEHNfFJ\\emgAbVyP\\DahP>\ngGP@DjZjdEHNfFJ\\emgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\emgAcfyP\\DahP>\ngGP@DjZjdEHNfFJ\\fkgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ\\fkgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ\\fmgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\fmgAcfyP\\DahP>\ngGP@DjZjdEHNfFJ]EkfabgI[eApRF~@>\ngGP@DjZjdEHNfFJ]EkgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ]EkgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ]Em\\hNBPtH\ngGP@DjZjdEHNfFJ]EmgAbVyP\\DahP<\ngGP@DjZjdEHNfFJ]EmgAbVyP\\DahP>\ngGP@DjZjhDNfFJ\\fmdacdmr`xICP`<\ngGP@DjZjhDNfFJ\\fmdacdmr`xICP`>\ngGP@DjZjhDNfFJ]Fm\\hNBPtH>\ngGP@DjZjiDNfFJ\\ek\\hNBPwp<\ngGP@DjZjiDNfFJ\\ek\\hNBPwp>\ngGP@DjZjiDNfFJ\\ekdabdmr`xIC_@<\ngGP@DjZjiDNfFJ\\ekdabdmr`xIC_@>\ngGP@DjZjiDNfFJ\\ekdabgMr`xICP`<\ngGP@DjZjiDNfFJ\\ekdabgMr`xICP`>\ngGP@DjZjiDNfFJ\\ekfabgI[eApRF~@<\ngGP@DjZjiDNfFJ\\ekfabgI[eApRF~@>\ngGP@DjZjiDNfFJ\\em\\hNBPtH<\ngGP@DjZjiDNfFJ\\em\\hNBPtH>\ngGP@DjZjiDNfFJ\\emdabgMr`xICP`<\ngGP@DjZjiDNfFJ\\emdabgMr`xICP`>\ngGP@DjZjiDNfFJ\\emfabgI[eApRFa@<\ngGP@DjZjiDNfFJ\\emfabgI[eApRFa@>\ngGP@Djfj`NfFJ\\ek\\hNBPtH\ngGP@Djfj`NfFJ\\ek\\hNBPtOyJED\ngGP@Djfj`NfFJ\\ek\\hNBPwp\ngGP@Djfj`NfFJ\\ek\\hNB_TH\ngGP@Djfj`NfFJ\\ek\\hNB_Wp\ngGP@Djfj`NfFJ\\ek\\hN|_TH\ngGP@Djfj`NfFJ\\ekdaSdmr`{q}P`\ngGP@Djfj`NfFJ\\ekdaSdmr`{q}_@\ngGP@Djfj`NfFJ\\ekdabdmr`xICP`\ngGP@Djfj`NfFJ\\ekdabdmr`xIC_@\ngGP@Djfj`NfFJ\\ekdabdmr`xI}P`\ngGP@Djfj`NfFJ\\ekgAbVyP\\DahP\ngGP@Djfj`NfFJ\\ekgAbVyP\\Dao`\ngGP@Djfj`NfFJ\\ekgArVyP\\Dah_rTJH\ngGP@Djfj`NfFJ\\ekgArVyP\\D~hP\ngGP@Djfj`NfFJ\\ekgArVyP\\D~o`\ngGP@Djfj`NfFJ\\em\\hNBPtH\ngGP@Djfj`NfFJ\\em\\hNB_TH\ngGP@Djfj`NfFJ\\emgAbVyP\\DahP\ngGP@Djfj`NfFJ\\emgArVyP\\D~hP\ngGP@Djfj`NfFJ\\fk\\hNBPtH\ngGP@Djfj`NfFJ\\fk\\hNBPwp\ngGP@Djfj`NfFJ\\fkdabdmr`xICP`\ngGP@Djfj`NfFJ\\fkdabdmr`xIC_@\ngGP@Djfj`NfFJ\\fkgArVyP\\DahP\ngGP@Djfj`NfFJ\\fkgArVyP\\Dao`\ngGP@Djfj`NfFJ\\fm\\hNBPtH\ngGP@Djfj`NfFJ]Fk\\hNBPtH\ngGP@Djfj`NfFJ]Fk\\hNBPwp\ngGP@Djfj`NfFJ]FkgAbVyP\\DahP\ngGP@Djfj`NfFJ]Fm\\hNBPtH\ngGP@Djfj`NfFJmEk\\hNB_TH\ngGP@Djfj`NfFJmFk\\hNBPtH\ngGP@DjfjhDNfFJ\\ekdabdmr`{q}P`<\ngGP@DjfjhDNfFJ\\ekdabdmr`{q}P`>\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}P`<\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}P`>\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}_@<\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}_@>\ngGP@DjfjhDNfFJ\\ekgARVyP]x~hP<\ngGP@DjfjhDNfFJ\\ekgARVyP]x~hP>\ngGP@DjfjhDNfFJ\\ekgAbVyP\\D~hP<\ngGP@DjfjhDNfFJ\\ekgAbVyP\\D~hP>\ngGP@DjfjhDNfFJ\\fkgAbVyP\\DahP<\ngGP@DjfjhDNfFJ\\fkgAbVyP\\DahP>\ngGP@DjfjhDNfFJ]Ek\\hNB_TH<\ngGP@DjfjhDNfFJ]Ek\\hNB_TH>\ngGP@DjfjhDNfFJ]EkgAbVyP\\D~hP<\ngGP@DjfjhDNfFJ]EkgArVyP\\D~hP<\ngGP@DjfjhDNfFJ]EkgArVyP\\D~hP>\ngGP@DjfjhDNfFJ]FkgARVyP\\DahP<\ngGP@DjfjhDNfFJ]FkgARVyP\\DahP>\ngGP@DjfjhDNfFJ]FkgARVyP\\Dao`<\ngGP@DjfjhDNfFJ]FkgARVyP\\Dao`>\ngGP@Djyj`NbIIZwLwmdMB\ngGP@Djyj`NbIIZwLwndMB\ngGP@Djyj`NbIIZwL{mdMB\ngGP@Djyj`NbIIZwL{ndMB\ngGP@Djyj`NbIIkWLwmdMB\ngGP@Djyj`NbIIkWLwndMB\ngGP@Djyj`NbIIkWL{ndMB\ngGP@Djyj`NbIIkYLTyK\\s^zPtH\ngGP@Djyj`NfFJ\\ek\\snBPtH\ngGP@Djyj`NfFJ\\ek_XICP`\ngGP@Djyj`NfFJ\\ek_XICPdlRP\ngGP@Djyj`NfFJ\\ekdacdmsNxICP`\ngGP@Djyj`NfFJ\\ekdacdm}`dMB\ngGP@Djyj`NfFJ\\ekdqSdmsNxICP`\ngGP@Djyj`NfFJ\\ekdqSdmsN{qCP`\ngGP@Djyj`NfFJ\\ekdqSdm}`dMB\ngGP@Djyj`NfFJ\\ekfabgI[f]pRFa@\ngGP@Djyj`NfFJ\\ekfabgI[{AHZD\ngGP@Djyj`NfFJ\\ekfabgI[{^HZD\ngGP@Djyj`NfFJ\\fm\\snBPtH\ngGP@Djyj`NfFJ\\fm_XICP`\ngGP@Djyj`NfFJ\\fmdacdmsNxICP`\ngGP@Djyj`NfFJ]Ek\\snBPtH\ngGP@Djyj`NfFJ]Ek_XICP`\ngGP@Djyj`NfFJ]Ekdacdm}`dMB\ngGP@Djyj`NfFJ]EkfabgI[f]pRFa@\ngGP@Djyj`NfFJ]EkfabgI[{AHZD\ngGP@Djyj`NfFJ]FmdacdmsNxICP`\ngGP@DjyjhdNbIIZwLwmdM|>\ngGP@DjyjhdNbIIZwLwndM|<\ngGP@DjyjhdNbIIZypXynYw[HZD<\ngGP@DjyjhdNbIIZypXynYw[HZD>\ngGP@DjyjhdNbIIZypXynYw]HZD<\ngGP@DjyjhdNbIIZypXynYw]HZD>\ngGP@DjyjhdNbII[WLwndMB<\ngGP@DjyjhdNbII[WLwndMB>\ngGP@DjyjhdNbII[WL{ndMB<\ngGP@DjyjhdNbII[WL{ndMB>\ngGP@DjyjhdNbII[YpXynYw]HZD<\ngGP@DjyjhdNbII[YpXynYw]HZD>\ngGP@DjyjhdNbII[YtTynYw]HZD<\ngGP@DjyjhdNbIIjypXenYw]H[x<\ngGP@DjyjhdNfFJ\\ek_XIC_@<\ngGP@DjyjhdNfFJ\\ek_XIC_@>\ngGP@DjyjhdNfFJ\\ekdacdm}`dM|<\ngGP@DjyjhdNfFJ\\ekdacdm}`dM|>\ngGP@DjyjhdNfFJ\\ekdacdm}`dM}~RqI@>\ngGP@DjyjhdNfFJ\\ekfabgI[f]pRF~@>\ngGP@DjyjhdNfFJ\\ekfabgI[{AH[x<\ngGP@DjyjhdNfFJ\\ekfabgI[{AH[x>\ngGP@DjyjhdNfFJ\\ekfabgI[{^H[x<\ngGP@DjyjhdNfFJ\\ekfabgI[{^H[x>\ngGP@DjyjhdNfFJ\\ekgAbVyg\\Dao`<\ngGP@DjyjhdNfFJ\\ekgAbVyg\\Dao`>\ngGP@DjyjhdNfFJ\\ekgAbV~pRF~@<\ngGP@DjyjhdNfFJ\\ekgAbV~pRF~@>\ngGP@DjyjhdNfFJ\\ekgAcfyg\\DahP<\ngGP@DjyjhdNfFJ\\ekgAcfyg\\DahP>\ngGP@DjyjhdNfFJ\\ekgAcf~pRFa@<\ngGP@DjyjhdNfFJ\\ekgAcf~pRFa@>\ngGP@DjyjhdNfFJ\\ekgQRV~pRF~@<\ngGP@DjyjhdNfFJ\\ekgQRV~pRF~@>\ngGP@DjyjhdNfFJ\\ekgQRV~wbF~@<\ngGP@DjyjhdNfFJ\\ekgQRV~wbF~@>\ngGP@DjyjhdNfFJ\\ekgQSfyg\\DahP<\ngGP@DjyjhdNfFJ\\ekgQSfyg\\DahP>\ngGP@DjyjhdNfFJ\\ekgQSf~pRFa@<\ngGP@DjyjhdNfFJ\\ekgQSf~pRFa@>\ngGP@DjyjhdNfFJ\\ekgQSf~wbFa@<\ngGP@DjyjhdNfFJ\\ekgQSf~wbFa@>\ngGP@DjyjhdNfFJ\\em\\snBPtH<\ngGP@DjyjhdNfFJ\\em\\snBPtH>\ngGP@DjyjhdNfFJ\\em_XICP`<\ngGP@DjyjhdNfFJ\\em_XICP`>\ngGP@DjyjhdNfFJ\\emdacdmsNxICP`<\ngGP@DjyjhdNfFJ\\emdacdmsNxICP`>\ngGP@DjyjhdNfFJ\\emgAbVyg\\DahP<\ngGP@DjyjhdNfFJ\\emgAbVyg\\DahP>\ngGP@DjyjhdNfFJ\\emgAbV~pRFa@<\ngGP@DjyjhdNfFJ\\emgAcfyg\\DahP<\ngGP@DjyjhdNfFJ\\emgAcfyg\\DahP>\ngGP@DjyjhdNfFJ\\emgAcf~pRFa@<\ngGP@DjyjhdNfFJ\\emgAcf~pRFa@>\ngGP@DjyjhdNfFJ\\emgQSfyg\\DahP<\ngGP@DjyjhdNfFJ\\emgQSf~pRFa@>\ngGP@DjyjhdNfFJ\\fkgAbVyg\\Dao`<\ngGP@DjyjhdNfFJ\\fkgAbVyg\\Dao`>\ngGP@DjyjhdNfFJ\\fkgAbV~pRF~@<\ngGP@DjyjhdNfFJ\\fmgAcfyg\\DahP<\ngGP@DjyjhdNfFJ\\fmgAcfyg\\DahP>\ngGP@DjyjhdNfFJ]EkgAcfyg\\DahP<\ngGP@DjyjhdNfFJ]EkgAcfyg\\DahP>\ngGP@DjyjhdNfFJ]EkgAcf~pRFa@<\ngGP@DjyjhdNfFJ]EkgQSfyg\\DahP<\ngGP@DjyjhdNfFJ]EkgQSfyg\\DahP>\ngGP@DjyjhdNfFJ]EmgAcf~pRFa@>\ngGP@Dkij`NfFJ\\ek\\snBPtH\ngGP@Dkij`NfFJ\\ek_XICP`\ngGP@Dkij`NfFJ\\ek_XIC_@\ngGP@Dkij`NfFJ\\ekdabgMsNxICP`\ngGP@Dkij`NfFJ\\ekdabgM}`dMB\ngGP@Dkij`NfFJ\\ekgAbVyg\\Dao`\ngGP@Dkij`NfFJ\\ekgAbV~pRF~@\ngGP@Dkij`NfFJ\\ekgAbfyg\\DahP\ngGP@Dkij`NfFJ\\ekgAbf~pRFa@\ngGP@Dkij`NfFJ\\em_XICP`\ngGP@Dkij`NfFJ\\fmgAbfyg\\DahP\ngGP@Dkij`NfFJ\\fmgAbf~pRFa@\ngGP@DkijhdNfFJ\\ekdabdm}`dM|<\ngGP@DkijhdNfFJ\\ekgAbfyg\\Dao`>\ngGP@DkijhdNfFJ\\ekgAbf~pRF~@<\ngGP@DkijhdNfFJ\\ekgAbf~pRF~@>\ngGP@DkijhdNfFJ\\emgAbfyg\\DahP<\ngGP@DkijhdNfFJ\\emgAbfyg\\DahP>\ngGP@DkijhdNfFJ\\emgAbf~pRFa@<\ngGP@DkijhdNfFJ\\emgAbf~pRFa@>\ngGP@Lda`U@][IZwLvmdMB=\ngGP@Lda`U@][IZwLvmdMC~RqI@=\ngGP@Lda`U@][IZwLvmgu|=\ngGP@Lda`U@][IZwLvmgu}~RqI@=\ngGP@Lda`U@][IZwLvndMB\ngGP@Lda`U@][IZwLvndMC~RqI@\ngGP@Lda`U@][IZwLzndMB=\ngGP@Lda`U@][IZwLzndMC~RqI@=\ngGP@Lda`U@][IZyHTyK\\sjzPtH\ngGP@Lda`U@][IZyLTyK\\sZzPtH\ngGP@Lda`U@][IZyhXirVygUtahP=\ngGP@Lda`U@][IkWLvmdMB=\ngGP@Lda`U@][IkWLvndMB\ngGP@Lda`U@][IkWLzndMB=\ngGP@Lda`U@][IkYHTyK\\sjzPtH\ngGP@Lda`U@][IkYLTyK\\sZzPtH\ngGP@Lda`USH][IZwLvmdM|+\ngGP@Lda`USH][IZwLvmdM|-\ngGP@Lda`USH][IZwLvmdM}~RqI@+\ngGP@Lda`USH][IZwLvmdM}~RqI@-\ngGP@Lda`USH][IZwLvndM|<\ngGP@Lda`USH][IZwLvndM|>\ngGP@Lda`USH][IZyHTyK\\sjzPwp>\ngGP@Lda`USH][IZyLTyK\\sZzPwp>\ngGP@Lda`USH][IZyLTyK\\sZzPwwyKDd>\ngGP@Lda`USH][IZypTynYu]HZD<\ngGP@Lda`USH][IZypTynYu]HZD>\ngGP@Lda`USH][IZytTenYm]H[x<\ngGP@Lda`USH][IZytTenYm]H[x>\ngGP@Lda`USH][IZytTenYm]H[{|ebR<\ngGP@Lda`USH][IZytTenYm]H[{|ebR>\ngGP@Lda`USH][IZytTynYm]HZD<\ngGP@Lda`USH][IZytTynYm]HZD>\ngGP@Lda`USH][IZytTynYm]HZG|ebR<\ngGP@Lda`USH][IZytTynYm]HZG|ebR>\ngGP@Lda`USH][IZytTynYm]H[x<\ngGP@Lda`USH][IZytTynYm]H[x>\ngGP@Lda`USH][IZytTynYm]Okx<\ngGP@Lda`USH][IZytTynYm]Okx>\ngGP@Lda`USH][I[WLvmdMB+\ngGP@Lda`USH][I[WLvmdMB-\ngGP@Lda`USH][I[WLvndMB<\ngGP@Lda`USH][I[WLvndMB>\ngGP@Lda`USH][I[WLzndMB+\ngGP@Lda`USH][I[WLzndMB-\ngGP@Lda`USH][I[YHTyK\\sjzPtH<\ngGP@Lda`USH][I[YHTyK\\sjzPtH>\ngGP@Lda`USH][I[YLTyK\\sZzPtH<\ngGP@Lda`USH][I[YLTyK\\sZzPtH>\ngGP@Lda`USH][I[YpTenYu]HZD<\ngGP@Lda`USH][I[YpTenYu]HZD>\ngGP@Lda`USH][I[YpTynYu]HZD<\ngGP@Lda`USH][I[YpTynYu]HZD>\ngGP@Lda`USH][I[YtTenYm]HZD<\ngGP@Lda`USH][I[YtTenYm]HZD>\ngGP@Lda`USH][I[YtTynYm]HZD<\ngGP@Lda`USH][I[YtTynYm]HZD>\ngGP@Lda`USH][IjwLvmdM|+\ngGP@Lda`USH][IjwLvmdM|-\ngGP@Lda`USH][IjwLvndM|<\ngGP@Lda`USH][IjwLvndM|>\ngGP@Lda`USH][IjyHTyK\\sjzPwp<\ngGP@Lda`USH][IjyHTyK\\sjzPwp>\ngGP@Lda`USH][IjyLTyK\\sZzPwp<\ngGP@Lda`USH][IjyLTyK\\sZzPwp>\ngGP@Lda`USH][IjytTenYm]H[x<\ngGP@Lda`USH][IjytTenYm]H[x>\ngGP@Lda`USH][IjytTynYm]H[x<\ngGP@Lda`USH][IjytTynYm]H[x>\ngGP@Lda`USH][IkYpTynYu]HZD<\ngGP@Lda`USH][IkYpTynYu]HZD>\ngGP@Lda`USH][IkYtTynYm]HZD<\ngGP@Lda`USH][IkYtTynYm]HZD>\ngGPAEJU\\uPGSCENRusPqSdmsNxICP`\ngGPAEJU\\uPGSCENRusPqSdm}`dMB\ngGPAKrUM@@FyV}l}oP=\ngGPAMJUML@GVBgN\\EI[{AN{t\ngGPAMNRPpJ`Nmdm[f]WRFa@=\ngGPAMNRPpJ`Nmdukf[VrFa@=\ngGPAMNRPpJ`Nmdukf[WRFa@\ngGPAMNRPpJ`Nmdukf]WRFa@=\ngGPAMNRPpJ`NmdultLTyK\\sjzPtH=\ngGPAMNRPpJ`NmdulxJ\\wLzndMB>\ngGPAMNRPpJ`NmdulzJ\\wLvndMB>\ngGPAMvRPpJ`Nijyful}oP=\ngGPB@DZPLaYAJZjhCkAbf|PP\ngGPB@DZPLaYAJZjhCkAbj|PP\ngGPBABRDKaWAJnjhCkASf~pSz~@>\ngGPBADJHLQXaInjhCiQr\ngGPD@DDHRYjY@zTeWHwmg]v\ngGPD@DDHRYjY@zTeWHwmg]z\ngGPD@DDHRYjY@zTeWHwng]z\ngGPD@DDHRYjY@zTeYtTenQo]N{t\ngGPD@DDHRYjY@ztdunao[@\ngGPD@DDHRYjjTR`zLTykgAcfzpZD>\ngGPD@DFPRYfi@zLTykgQRVzp[t\ngGPD@DGpRYjY@ztduoao[oP\ngGPD@DHHRZzj@zL\\ek]DMB\ngGPD@DHHRZzj@zL\\ekgIrVyGexahP\ngGPD@DHHRZzj@zL\\ekgIrVzHZD\ngGPD@DHHR[f`@zd[h{np=\ngGPD@DHHR[ff@zL\\ek]GmB\ngGPD@DHHR[j`@zd[h{np=\ngGPD@DHHR[j`@zd[h{oP\ngGPD@DKpRYjZ@zLdfm\\c^vPtH\ngGPD@DSpRZVj@zlTyKV~pRFa@\ngGPD@DXHRfjj@zhXiKV~PRFa@\ngGPD@DXHRfjj@zhXiKWNCEM|`dMB\ngGPD@DXHRfjj@zhXjKV~PRFa@\ngGPD@DXHRfjjdPzhXiK[NCEM|`dMB<\ngGPD@DXHRfjjdPzhXiK[NCEM|`dMB>\ngGPD@DZ`R[ij@zLlfm\\cZvPtH\ngGPD@VIpRVjj@zlTyKV~pRFa@\ngGPD@bSpRZVj@zlTzMV~pRFa@\ngGPD@xIpR[j`@zd[d^Wcn{@=\ngGPD@xIpR[j`@zd[d^Wcn}@\ngGPD@xQpRjzj@zhTyKVyglDahP\ngGPD@xQpRkf`@zP\\wL{`gmz+\ngGPD@xQpRkf`@zP]WL{`g]v+\ngGPD@xQpRkf`@zP]WL{`gmz+\ngGPD@xUpRjZj@zhXirVyP\\Dao`\ngGPDADFHRYjY@zLTykgQRVzw[t\ngGPDADFHRYjjTRPzLTyk]XMB\ngGPDAHFPRYjjTRPzLTykgQRVzpZD\ngGPDAHFPRYjjTRPzLTykgQRVzp[x<\ngGPDAHFPRYjjTRPzLTykgQRVzp[x>\ngGPDAHJPRZzj@zL\\ek]DMB\ngGPDAHJPRZzj@zL\\ek]DM|\ngGPDAHJPRZzj@zL\\ek]GuB\ngGPDAbGDRYjjTRPzLTyk]XMB\ngGPDAbGDRYjjTRPzLTym]XMB>\ngGPDAbR`RYj`@zT]YtTeolD{oP>\ngGPDAxKpRYfj@zlTyKV~pRFa@\ngGPDAxSpRijj@zXXirVmr`xICP`\ngGPDAxSpRkj``PzP]WL}`g]v+\ngGPDAxSpRkj``PzP]WL}`g]v-\ngGPDAxSpRkj``PzP]WvB]wX+\ngGPDAxSpRkj``PzP]WvB]wX-\ngGPDAxSpRkjj`PzhTyKV~pRFa@<\ngGPDAxSpRkjj`PzhTyKV~pRFa@>\ngGPDaxF`Dgdjfj`NjFJ\\unTGAOjD\ngGPDaxF`Dgdjfj`NjFJ\\uodGAhP\ngGPDaxF`DgdjfjhDNjFJ]UodGAhP<\ngGPDaxF`DgdjfjhDNjFJ]UodGAhP>\ngGPEAxSpdiUuPPH]HNkf^pSn{@+\ngGPEAxSpdiUuPPH]HNkf^pSn{@-\ngGPFAVRDTIhPueaDfZj`NeEN]EIP>\ngGPH@DIJm]@]ZIZweB\ngGPH@DIKUU@]VJ\\ek\\cvBPtH\ngGPH@DIKUU@]VJ\\ek\\cvBPwp\ngGPH@DIKUU@]VJ\\ek_XICP`\ngGPH@DIKUU@]VJ\\ekgAbf~pRFa@\ngGPH@DILsP@]JNlzJRwvB]wh\ngGPH@DILuH@]JN[d^wSn{@=\ngGPH@DILuH@]JN[h{np=\ngGPH@DILuH@]JN[x^N{l=\ngGPH@DILuH@]JN[{]N{l=\ngGPH@DILuH@]RUrM{Yw]`=\ngGPH@DILuH@]RUrM{Yw^`\ngGPH@DILuH@]RUrM{Y{^`=\ngGPH@DILuH@]RUrM{iw]`=\ngGPH@DILuH@]RUrM{iw^`\ngGPH@DILuH@]RV]EI[d[wSn}@\ngGPH@DILuK@]FRRunQo[OZD\ngGPH@DILuK@]FRRunQo]OZD\ngGPH@DILuK@]FRRunQo]O[x\ngGPH@DILuK@]FRRuoao[hP\ngGPH@DILuK@]FRRvnQo[OZD\ngGPH@DILuK@]JRkd[vsn}@\ngGPH@DILuK@]JRkd[vsv}@\ngGPH@DILuPRH]JN[d^pSn{@+\ngGPH@DILuPRH]JN[d^pSn{@-\ngGPH@DILuPRH]JN[{AN{l+\ngGPH@DILuPRH]JN[{AN{l-\ngGPH@DILuPRH]JN[{AN{t>\ngGPH@DILuPRH]JNk{AN{l-\ngGPH@DIMMU@]VJ\\ekdqSdm}`dMB\ngGPH@DIMMU@]VJ\\ekgAbV~pRFa@\ngGPH@DIMMURH]VJ\\ekgQRV~pRFa@<\ngGPH@DIMMURH]VJ\\ekgQRV~pRFa@>\ngGPH@DIMtu@]FVRunQm[HZD\ngGPH@DIMtu@]FVRunQm]HZD\ngGPH@DISUU@]LLTyKVyP\\DahP\ngGPH@DISUU@]LLTyKWNCDmr`xIC_@\ngGPH@DISUU@]LLTyKWNCEMr`xICP`\ngGPH@DISUU@]LLTzMZyP\\DahP\ngGPH@DISUU@]LLUYKVyP\\DahP\ngGPH@DISUU@]LLUYKWNCEMr`xICP`\ngGPH@DISUU@]LLUYKZyP\\DahP\ngGPH@DISm]@]DJRundFa@\ngGPH@VILuH@]JN[h{np=\ngGPH@VILuH@]JN[x^N{l=\ngGPH@VILuH@]JN[{]N{l=\ngGPH@bILuH@]JN[h{np=\ngGPH@bILuH@]JN[{]N{l=\ngGPH@bILuH@]RUrM{Yw]`=\ngGPH@bILuH@]RUrM{iw]`=\ngGPH@bISUU@]LLUYKVyP\\DahP\ngGPH@xIKUU@]VJ\\ek\\cvBPtH\ngGPH@xILuH@]JN[d^wSn{@=\ngGPH@xILuH@]JN[x^N{l=\ngGPH@xIMMU@]VJ\\ek\\cvBPtH\ngGPH@xITuP@]XJ\\wJC`g]z\ngGPH@xITuP@]XJmWJC`g]v=\ngGPH@xITuP@]XJmWJC`g]z\ngGPH@xITuPPH]XJ]WJC`g]v+\ngGPH@xITuPPH]XJ]WJC`g]v-\ngGPH@xITuU@]LLTyKVyP\\DahP\ngGPH@xIUMT`]LLTyKVyP\\DaoP\ngGPH@xIUMT`]LLTyKV~P\\Da@\ngGPH@xIUMT`]LLTyMV~P\\Da@\ngGPH@xIUMT`]LLTzMV~P\\Da@\ngGPH@xIUMU@]LLTyKVyP\\DahP\ngGPH@xIUMU@]LLTyKVyP\\Dao`\ngGPH@xIUMU@]LLTyKVyP\\D~hP\ngGPH@xIUMU@]LLTyKWNCDmr`xICP`\ngGPH@xIUMU@]LLTyKZyP\\DahP\ngGPH@xIUMU@]LLTyMVyP\\DahP\ngGPH@xIUMU@]LLTzMVyP\\DahP\ngGPH@xIUMU@]LLTzMWNCDmr`xICP`\ngGPH@xIUMU@]LLTzMZyP\\DahP\ngGPHABILuH@]JN[h{np=\ngGPHABITuP@]XJmWJC`g]v=\ngGPHABITuP@]XJmWJC`g]z\ngGPHABITuP@]XJmWJC`gmz=\ngGPHABITuS@]LLTyKWNCGMr`xI{P`>\ngGPHADILuH@]JN[h{np=\ngGPHADILuH@]JN[{]N{l=\ngGPHADILuH@]JN\\zJRwvz]wh\ngGPHADILuPRH]JN[{AN{l+\ngGPHADILuPRH]JN[{AN{l-\ngGPHADILuUJIP]VJ\\ekgQRV~pRF~@<\ngGPHADIMMU@]VJ\\ek_XICP`\ngGPHADIMMU@]VJ\\ekdqSdm}`dMB\ngGPHADIMMURH]VJ\\ekgQRV~pRFa@<\ngGPHADIMMURH]VJ\\ekgQRV~pRFa@>\ngGPHADIMMURH]VJ\\ekgQrV~pSza@>\ngGPHAHILuH@]JN[{]N{l=\ngGPHAHILuK@]VJ\\ekgQRVzOZD\ngGPHAHILuK@]VJ\\ekgQRV~wSva@\ngGPHAHILuPRH]JN[{AN{l-\ngGPHAHIMMU@]VJ\\ekdqSdm}`dMB\ngGPHAHIMMURH]VJ\\ekgQRV~pRFa@<\ngGPHAHIMMURH]VJ\\ekgQRV~pRFa@>\ngGPHAVILuH@]JN[{]N{l=\ngGPHAVILuH@]JN\\zJRwvz]wh\ngGPHAVIMMU@]VJ\\ekdqSdm}`dMB\ngGPHAbIKUU@]VJ\\ek_XICP`\ngGPHAbILuH@]JN[{]N{l=\ngGPHAbILuPRH]JN[{AN{l+\ngGPHAbILuPRH]JN[{AN{l-\ngGPHAbILuPRH]JN\\zJ\\wvB^wh<\ngGPHAbILuUJIH]VJ]EmgQSf~pRFa@>\ngGPHAbIMMU@]VJ\\ekdqSdm}`dM|\ngGPHAxILsP@]JNk{AN{l=\ngGPHAxILuH@]JN[d^wSn{@=\ngGPHAxILuH@]JN[h{np=\ngGPHAxILuH@]JN[x^N{l=\ngGPHAxILuH@]JN[x^N{t\ngGPHAxILuH@]JN[{]N{l=\ngGPHAxILuPRH]JN[d^pSn{@+\ngGPHAxILuPRH]JN[d^pSn{@-\ngGPHAxILuUJIH]VJ\\ekgQSfyGlDahP<\ngGPHAxIMMU@]VJ\\ekdqSdmrOXICP`\ngGPHAxIMMU@]VJ\\ekdqSdm}`dMB\ngGPHAxITuP@]XJ\\wJC`g]v=\ngGPHAxITuP@]XJ\\wJC`g]z\ngGPHAxITuP@]XJ\\wJC`gmz=\ngGPHAxITuP@]XJmWJC`g]v=\ngGPHAxITuP@]XJmWJC`g]z\ngGPHAxITuP@]XJmWJC`gmz=\ngGPHAxITuP@]XJmYHXiK\\hNB]wh\ngGPHAxITuP@]XJmYhXirVyP\\D}oP=\ngGPHAxITuPPH]XJ]WJC`g]v+\ngGPHAxITuPPH]XJ]WJC`g]v-\ngGPHAxITuPPH]XJ]WJC`g]z<\ngGPHAxITuPPH]XJ]WJC`g]z>\ngGPHAxITuPPH]XJ]WJC`gmz+\ngGPHAxITuPPH]XJ]WJC`gmz-\ngGPHAxITuPPH]XJlwJCoG]v+\ngGPHAxITuPPH]XJlwJCoG]v-\ngGPHAxITuS@]LLUZKVyP\\D}hP\ngGPHAxITuU@]LLTyKVyP\\DahP\ngGPHAxITuU@]LLUZKVyP\\DahP\ngGPHAxITuUPH]LLTzKVyP\\DahP<\ngGPHAxITuUPH]LLTzKVyP\\DahP>\ngGPHKPITuURH]TLTyM\\hNBPwp<\ngGPHKPYIC@jfPzVRwtvmdH+\ngGPHKPYIC@jfPzVRwtvmdH-\ngGPHKPYIC@jfPzVRytTenYm]H[x>\ngGPHMPITtp@]HJ[e]wcn{@=\ngGPHMPITtp@]HJ[e]wcv}@=\ngGPHMPITtp@]HJ[h{np=\ngGPHMPITtp@]HJ[y]N{l=\ngGPHMPITtp@]HJ[y]O[t=\ngGPHMPYIC@j@zvRunYu]HZD=\ngGPHMPYIC@j@zvRvnYu]HZD+\ngGPHMPYIC@j@zvRvshis\\sZzPtH>\ngGPHMPYIC@j@zvSVnYm[HZD=\ngGPHMPYIC@j@zvSVnYm]HZD\ngGPHMPYIC@j@zvSVnYu]HZD=\ngGPHMPYIC@j@zvSVsPqSdmsNkiCP`=\ngGPHMPYIC@j@zvSVshis\\sZzPtH>\ngGPHMPYICFj@zXXjrVv\\EN[f]PRFa@>\ngGPHMPYICFj@zXXjrZusNhICP`\ngGPHMPYICJj@zXXirVnRFJ\\wLB`dMB>\ngGPHaxCeJSLuPGUbgI[YtTynQwAHZD>\ngGPI@DBTjZh@NlEVkeApSn{@=\ngGPI@DBTjZhHDNlENkeApSn}@<\ngGPI@DBTjZhHDNlENlxJRwJC`g]z<\ngGPI@DBTjZhHDNlENlxJRwJC`g]z>\ngGPI@DZTfzZ`NcKIkWHvmdMB\ngGPI@VBTjZh@NlEVkeApSn{@=\ngGPIAxBTfZd@NeGMrO[iw]`=\ngGPIAxBTfZhIDNeGMrOXIw]`+\ngGPIAxBTfZhIDNeGMrOXIw]`-\ngGPIAxBTffj`NkENRurXirVyGlDahP\ngGPIAxBTffj`NkENRurXirV~pRFa@\ngGPIAxBTijj`NfFJ\\ek\\kvBPtH\ngGPIAxBTjZh@NlEN[eApSn}@\ngGPIAxBTjZh@NlEVkeApSn{@=\ngGPIAxBTjZh@NlEVkeApSn}@\ngGPIAxBTjZh@NlEVkeApSv}@=\ngGPIAxBTjZhHDNlENkeApSv}@+\ngGPIAxBTjZhHDNlENkeApSv}@-\ngGPIAxBTjZj`NfFJ\\ek\\hNBPtH\ngGPIAxBTjZjhDNfFJ]Ek\\hNBPtH<\ngGPIAxBTjZjhDNfFJ]Ek\\hNBPtH>\ngGPIAxBTjfjPNfFJmFk\\hNBPwh\ngGPIAxBTjfj`NfFJ\\ek\\hNBPtH\ngGPIAxBTjfj`NfFJ\\em\\hNBPtH\ngGPIAxBTjfj`NfFJ\\fk\\hNBPtH\ngGPIAxBTjfj`NfFJ]Fk\\hNBPtH\ngGPIAxBTjfj`NfFJ]FkgAbVyP\\DahP\ngGPIAxBTjfj`NfFJmFk\\hNBPtH\ngGPIAxBTjfj`NfFJmFm\\hNBPtH\ngGPIEPKdkij`NfFJ]Fm\\snBPtH\ngGPIEPKdkjj`NfFJ\\em\\pNBPtH\ngGPIEPKdkjj`NfFJ\\fm\\pNBPtH\ngGPIEPKdkjj`NfFJ\\fmgAbfy`\\DahP\ngGPIEPKdkjj`NfFJ]Fm\\pNBPtH\ngGPIMP[djZX@NdEMrn{qw]`=\ngGPIMP[djZX@NdEMrn{q{^`=\ngGPIMP[lda`U@][I[WLzndMB+\ngGPIMP[lda`U@][IkWLvndMB\ngGPIMP[lda`U@][IkWLzndMB=\ngGPIMP[ldaeU@]LLTyK[ICEN[fAPRFa@>\ngGPIMP[ldaeU@]LLTyMZy`TDahP\ngGPJ@DQpSa``aBTuUPGVCFvRFJ\\wR}P`\ngGPJ@xQpSagBnFRRVj`NdDmsOKv}_@\ngGPL@DXHHPeMUTAtPqSWICEN[i^hP\ngGPL@xIpsadTajhCkQKWNSdm|OKuB\ngGPL@xQpSaddLZ@CjAnYu^O[t+\ngGPL@xQpSaddajhCharVmsOKqCP`\ngGPL@xQpSaddajhCharVmsOKqC__d`XP\ngGPLADHHhPdtuTAtXirVzwc{|dcb\ngGPLAHJPtadTajdCkQKT\ngGPLAHJPtadTajdCkQKV|oP\ngGPLAHJPtadTajhCkQKV|hP\ngGPLAHJPtadTajhCkQKV|o`\ngGPLAHJPtadTajhCkQKZ|hP\ngGPP@cTfyi`NeGH\ngGPPAcTijj`NlFJ\\xLTwbB\ngGPP`cUuyInZXCiQr\ngGPQ@c[rS\\tpGRcd\ngGPT@cYPZ`R[jj@zT\\`\ngGPTHlPxUpRjZj@zPXwe|\ngGPTHlPxUpRjZj@zPXypXeoKx\ngGPTHlQxUpRjvj@zPTwe|\ngGPTHlQxWpRjvj@zPTwe|\ngGPTIcQxIpRVjj@zTTw`|\ngGPUHlQxWpOIU[UPH]HJ[r~@<\ngGPUHlQxWpOIU[UPH]HJ[r~@>\ngGPXHlPDYIHUj@zp\\uoJD\ngGPXHlPDYIHUj@zp\\usdyK^TH\ngGPXHlPxIUMU@]XLZweB\ngGPXHlPxIUMU@]XL[WeB\ngGPXHlQxIU[U@]XJZweB\ngGPXHlQxIU[U@]XJZyLTyK^TH\ngGPXHlQxIU[U@]XJ[WeB\ngGPXHlQxIU[UPH]XJZytTeoJD<\ngGPXHlQxIU[UPH]XJZytTeoJD>\ngGPXHlQxIU[UPH]XJ[YtTeoJD<\ngGPXHlQxIU[UPH]XJ[YtTeoJD>\ngGPXIcPVIKUU@]JJP\ngGPXhlQx[crUVuPGVBfmyP`\ngGPYAcUPKdkjj`NlFJ[rA@\ngGPYAcUPKdkjj`NlFJ\\xLTwdB\ngGPYAcUPKdkjj`NlFR\\xLTwdB\ngGPYHlPDGlddJu@]XNZweB\ngGPYHlQxGdjmjhDNlEM[ra@<\ngGPYHlQxGdjmjhDNlEM[ra@>\ngGPYHlQxGdjmjhDNlEM\\zJRweB<\ngGPYHlQxGdjmjhDNlEM\\zJRweB>\ngGPYHlQxGdjmjhDNlEMkra@<\ngGPYHlQxGdjmjhDNlEMkra@>\ngGPYHlQxGdjmjhDNlEMlzJRweB<\ngGPYHlQxGdjmjhDNlEMlzJRweB>\ngGP`@TfYi`NcENZytTenlFa@\ngGP`@TfYi`NcEN[YtTenlFa@\ngGP`@TfYi`NcENkWVCP`\ngGP`@TfYi`NcENkYtTenlFa@\ngGP`@TfYjPNcENZytTenlF}@\ngGP`@TfYjPNcENZytTenmz}@\ngGP`@TfYjPNcENZytTeoLD\ngGP`@TfYjPNcENjytTenlF}@\ngGP`@TfYjPNcENjytTeoLD\ngGP`@TfYjPNmEV[{AN{l\ngGP`@TfYjPNmEV[{AN{t\ngGP`@TfYjPNmEVk{AN{l\ngGP`@TfYjPNmEVk{AN{t\ngGP`@TfYjPNmEVlzJRwvB]wh\ngGP`@TfYjhhNcENZwVCP`<\ngGP`@TfYjhhNcENZwVCP`>\ngGP`@TfYjhhNcENZwV}P`<\ngGP`@TfYjhhNcENZyLTyK]XMB<\ngGP`@TfYjhhNcENZyLTyK]XMB>\ngGP`@TfYjhhNcENZytTenlFa@<\ngGP`@TfYjhhNcENZytTenlFa@>\ngGP`@TfYjhhNcENZytTenlF~@<\ngGP`@TfYjhhNcENZytTenlF~@>\ngGP`@TfYjhhNcENZytTenmza@<\ngGP`@TfYjhhNcENjwVCP`<\ngGP`@TfYjhhNcENjwVCP`>\ngGP`@TfZfPNeIUrM{Yw]`\ngGP`@TfZfPNeIV]EI[d[wSn}@\ngGP`@TfZjeDdNcENZwVCP`\ngGP`@TfZjeDdNcENZwVC_@<\ngGP`@TfZjeDdNcENZyHXiK]XMB<\ngGP`@TfZjeDdNcENZyHXiK]XMB>\ngGP`@TfZjeDdNcENZyHXiK]XM|<\ngGP`@TfZjeDdNcENZyhXirVzpZD\ngGP`@TfZjeDdNcENZypXenlFa@<\ngGP`@TfZjeDdNcENZypXenlFa@>\ngGP`@TfZjeDdNcENZypXenlF~@>\ngGP`@TfZjeDdNcENZytTenlFa@\ngGP`@TfZjeDdNcENZytTenlF~@<\ngGP`@TfZjeDdNcENZytTenlF~@>\ngGP`@TfZjeDdNcEN[WVCP`<\ngGP`@TfZjeDdNcEN[WVCP`>\ngGP`@TfZjeDdNcEN[YtTynlFa@<\ngGP`@TfZjeDdNcEN[YtTynlFa@>\ngGP`@TfZjeDdNcENkWVCP`\ngGP`@TfZjeDhNcENZwVCP`<\ngGP`@TfZjeDhNcENZwVCP`>\ngGP`@TfZjeDhNcENZwVC_@<\ngGP`@TfZjeDhNcENZwVC_@>\ngGP`@TfZjeDhNcENZyHXiK]XMB<\ngGP`@TfZjeDhNcENZyHXiK]XMB>\ngGP`@TfZjeDhNcENZyhXirVzpZD<\ngGP`@TfZjeDhNcENZyhXirVzpZD>\ngGP`@TfZjeDhNcENZypXenlFa@<\ngGP`@TfZjeDhNcENZypXenlFa@>\ngGP`@TfZjeDhNcENZypXynlFa@>\ngGP`@TfZjeDhNcENZytTenlFa@<\ngGP`@TfZjeDhNcENZytTenlFa@>\ngGP`@TfZjeDhNcENZytTenlF~@<\ngGP`@TfZjeDhNcENZytTenlF~@>\ngGP`@TfZjeDhNcENZytTenmz~@<\ngGP`@TfZjeDhNcEN[WVCP`<\ngGP`@TfZjeDhNcEN[WVCP`>\ngGP`@TfZjeDhNcEN[YpXenlFa@<\ngGP`@TfZjeDhNcENkWVCP`<\ngGP`@TfZjeDhNcENkWVCP`>\ngGP`@TfzZihNcENZweB>\ngGP`@TfzZihNcENZytTeneva@>\ngGP`@TfzZihNmKM[x[VzD<\ngGP`@TfzZihNmKM[x[VzD>\ngGP`@dfnjPNcGIZyr\\enbF}@\ngGP`@dfnjPNcGIZyr\\eoBD\ngGP`@dfnj`NcGIZwQCP`\ngGP`@dfnj`NcGIZyHXiK]DMB\ngGP`@dfnj`NcGIZyHXiK]DM|\ngGP`@dfnj`NcGIZyr\\enbFa@\ngGP`@dfnj`NcGIZyr\\enbF~@\ngGP`@dfnj`NcGIZyr\\encza@\ngGP`@dfnj`NcGI[WQCP`\ngGP`@dfnj`NcGIjyHXiK]DMB\ngGP`@dfnjiDNcGIZyHTyK]DMB<\ngGP`@dfnjiDNcGIZyHTyK]DMB>\ngGP`@dfnjiDNcGIZypTenbFa@<\ngGP`@dfnjiDNcGIZypTenbFa@>\ngGP`@dfnjiDNcGIZypTenbF~@<\ngGP`@dfnjiDNcGIZypTencza@<\ngGP`@dfnjiDNcGIZypTencza@>\ngGP`@dfyh@NiFzN{l=\ngGP`@dfyh@NiFzN{t\ngGP`@dfyh@NiFzO[t=\ngGP`@dfyh@NiGNbdmt]wh\ngGP`@dfyh@NiGNbgMt^wh\ngGP`@dfyi`NcGIZwQ{P`\ngGP`@dfyi`NcGIZwQ{PdlRP\ngGP`@dfyi`NcGIZwQ{_@\ngGP`@dfyi`NcGIZweB\ngGP`@dfyi`NcGIZwe|\ngGP`@dfyi`NcGIZytTencva@\ngGP`@dfyi`NcGIZytTeoJD\ngGP`@dfyi`NcGIZytTyncva@\ngGP`@dfyi`NcGIZytTyncv~@\ngGP`@dfyi`NcGIZytTyoJD\ngGP`@dfyi`NcGI[WQ{P`\ngGP`@dfyi`NcGI[WeB\ngGP`@dfyi`NcGI[YtTyncva@\ngGP`@dfyi`NcGI[YtTyoJD\ngGP`@dfyi`NeGUt]wX\ngGP`@dfyi`NeGUt]wh\ngGP`@dfyi`NeGUt^wX\ngGP`@dfyi`NeGUt^wh\ngGP`@dfyi`NeGV]EN[h}oP\ngGP`@dfyj`NcGIZwQCP`\ngGP`@dfyj`NcGIZwQCPdlRP\ngGP`@dfyj`NcGIZwQ}_@\ngGP`@dfyj`NcGIkWQCP`\ngGP`@dfyjidNcGIZwQC_@<\ngGP`@dfyjidNcGIZwQC_@>\ngGP`@dfyjidNcGIZyLTyK]DM|>\ngGP`@dfyjidNcGIZytTenbF~@<\ngGP`@dfyjidNcGIZytTenbF~@>\ngGP`@dfyjidNcGIZytTynbFa@<\ngGP`@dfyjidNcGIZytTynbFa@>\ngGP`@dfyjidNcGIZytTynbF~@<\ngGP`@dfyjidNcGIZytTynbF~@>\ngGP`@dfyjidNcGI[WQCP`<\ngGP`@dfyjidNcGI[WQCP`>\ngGP`@dfyjidNcGI[YtTynbFa@>\ngGP`@dfyjidNcGIjwQC_@<\ngGP`@dfyjidNcGIjwQC_@>\ngGP`@dfzh@NiFzN{l=\ngGP`@dfzh@NiFzN{t\ngGP`@dfzh@NiGICEI[h{oP\ngGP`@dfzhIDNiGNBdmt]wh<\ngGP`@dfzhIDNiGNBdmt]wh>\ngGP`@dfzj`NcGIZwQCP`\ngGP`@dfzj`NcGIZyhXirVzHZD\ngGP`@dfzjeEdNcGIZypTynbFa@<\ngGP`@dfzjeEdNcGIZypTynbFa@>\ngGP`@dfzjeEhNcGIZypTynbFa@>\ngGP`ADkjj`NjENRuolDahP\ngGP`ADkjj`NjENRurPqSf~pRFa@\ngGP`ADkjj`NjENRus`qK_XIC_@\ngGP`ADkjj`NjENRus`qS_XICP`\ngGP`ADkjj`NjENRvolDahP\ngGP`ADkjj`NjENcVolDahP\ngGP`ADkjj`NjENcVrPqSf~pRFa@\ngGP`ATeVn`NeDh\ngGP`ATffj`NcENRwVBP`\ngGP`ATffjiDNcENRwVB_@<\ngGP`ATffjiDNcENRwVB_@>\ngGP`ATffjiDNcENRytTenlDa@<\ngGP`ATffjiDNcENRytTenlDa@>\ngGP`ATffjiDNcENSWVBP`>\ngGP`Adeij`NcEIZwQCP`\ngGP`Adijj`NjFJRuodDahP\ngGP`Adijj`NjFJRuodD~o`\ngGP`Adijj`NjFJRurPqrV~WbFa@\ngGP`Adijj`NjFJRus`qS_HICP`\ngGP`Adijj`NjFJRus`qS_KqCP`\ngGP`Adijj`NjFJSVs`qS_HICP`\ngGP`Adijj`NjFJbus`qS_HICP`\ngGP`AdijjiDNjFJRuodDao`<\ngGP`AdijjiDNjFJRuodDao`>\ngGP`AdijjiDNjFJRurPqSf~PRFa@>\ngGP`AdijjiDNjFJRurPqSf~WbFa@<\ngGP`AdijjiDNjFJRurPqSf~WbFa@>\ngGP`AdijjiDNjFJRurPqrV~PRF~@>\ngGP`AdijjiDNjFJRus`qK_HIC_@<\ngGP`AdijjiDNjFJRus`qK_HIC_@>\ngGP`AdijjiDNjFJRus`qK_KqC_@>\ngGP`AdijjiDNjFJRus`qS_HIC_@<\ngGP`AdijjiDNjFJRus`qs_HICP`<\ngGP`AdijjiDNjFJRus`qs_HICP`>\ngGP`AdijjiDNjFJRus`qs_HIC_@<\ngGP`AdijjiDNjFJRus`qs_HIC_@>\ngGP`AdijjiDNjFJRus`qs_KqCP`<\ngGP`AdijjiDNjFJRus`qs_KqCP`>\ngGP`AdijjiDNjFJRvodDahP<\ngGP`AdijjiDNjFJRvodDahP>\ngGP`AdijjiDNjFJRvs`qS_HICP`<\ngGP`AdijjiDNjFJRvs`qS_HICP`>\ngGP`AdijjiDNjFJRvs`qs_HICP`<\ngGP`AdijjiDNjFJRvs`qs_HICP`>\ngGP`AdijjiDNjFJSUs`qK_HIC_@<\ngGP`AdijjiDNjFJSUs`qK_HIC_@>\ngGP`AdijjiDNjFJbus`qK_HIC_@<\ngGP`AdijjiDNjFJbus`qs_HICP`<\ngGP`AdijjiDNjFJbus`qs_HICP`>\ngGP`AdijjiDNjFJbvs`qs_HICP`<\ngGP`AdijjiDNjFJbvs`qs_HICP`>\ngGPa@SrSLuHGQbgM\\zJRwVC^`\ngGPa@SrSMSHGQbgM\\zJRwV{^`\ngGPa@erS\\t@GTc]G]v=\ngGPa@erS\\t@GTc]G]z\ngGPa@erS\\t@GTc]Gmz=\ngGPa@erS\\tpGQcdm[ra@\ngGPa@erS\\uPGQcdm[hahP\ngGPa@erS\\uPGQcdm[hah_rVIH\ngGPa@erS\\uTrGQcdmkhahP<\ngGPa@iJS]T@GTc]G]v=\ngGPa@krS\\t@GTc]Gmz\ngGPa@mrS\\uPGRcjzO[t\ngGPdCPVZ`R[ij@ztTyoEt\ngGPdE`DRPrRRrtAu`ek^TH\ngGPdH`DTHrRPkTAu`yK]DM|\ngGPdH`DWprRPkTAu`yK]DM|\ngGPdH`VTlRjZj@zHXzM_XIC_@\ngGPdH`VUpRjZj@zHXzM_XIC_@\ngGPdH`xUpRjZj@zHXyK_XIC_@\ngGPdH`xUpRjZj@zHXyKgAbV~pRF~@\ngGPdH`xUpRjZj@zHXzM_XIC_@\ngGPdH`xUpRjZj@zHXzMgAbV~pRF~@\ngGPdH`xUpRjZj`PzHXyM_XIC_@<\ngGPdH`xUpRjZj`PzHXyM_XIC_@>\ngGPdH`xV`RjZj@zHXzM]XIB\ngGPdI`VIpRVjj@zLTfm_CqCP`\ngGPeE`DSpGIM\\uRH]FNSUnbFa@>\ngGPeH`VUDliUMU@]DL]FnlDa@\ngGPh@iPIMuP@]RMt]wX=\ngGPh@iPIMuP@]RMt]wh\ngGPh@iPIMuP@]RMt^wh=\ngGPh@iPIMuP@]RN\\EI[h{oP>\ngGPh@iPIMuS@]FNRuncva@\ngGPh@iPIMuS@]FNRuoJD\ngGPh@iPIMuS@]FNRvncva@\ngGPh@iPIMuS@]FNRvoJD\ngGPh@iPIMuS@]JNkh{oP\ngGPh@iPIMuU@]FNRunbFa@\ngGPh@iPIMuUSH]FNRvnbFa@>\ngGPhCPDILuK@]JR[h[vp\ngGPhCPDILuK@]JR[h[wP\ngGPhCPDILuK@]ZJ\\`\ngGPhCPDILuK@]ZJ\\wfz\ngGPhCPDILuSRH]ZJ\\wP}``>\ngGPhCPDILuSRH]ZJ\\wfB<\ngGPhCPDILuSRH]ZJ\\wfB>\ngGPhCQBILuK@]ZJ\\wfz\ngGPhCQDILuSRH]ZJ\\wfB>\ngGPhCQbILuSRH]ZJ\\wfB>\ngGPhCQxILsS@]ZJ\\wfB\ngGPhCQxILuK@]ZJ\\wP}n`\ngGPhCQxILuK@]ZJ\\wfz\ngGPhDPDIMuUJKH]ZNZytTeoJD<\ngGPhDPDIMuUJKH]ZNZytTeoJD>\ngGPhH`DYIHUi@zH\\ek^DH\ngGPhH`DYIHUi@zH\\ekgIrVzH[t\ngGPhH`DYIHUi@zH\\fk]DMz\ngGPhH`DYIHUi@zH\\fk^DH\ngGPhH`DYIHUj@zH\\ek]DMB\ngGPhH`DYIHUj@zH\\ekgIrVzHZD\ngGPhH`DYIHUj@zH\\em]DMB\ngGPhH`DYIHUj@zH\\fk]DMB\ngGPhH`DYIHUj@zH\\fk]DM|\ngGPhH`DYIHUj@zH\\fm]DMB\ngGPhH`xIUMU@]TL\\ek_XICP`\ngGPhH`xIUMU@]TL\\ek_[q}P`\ngGPhH`xIUMU@]TL\\ekgAbV~pRF~@\ngGPhH`xIUMU@]TL\\ekgAbV~wcza@\ngGPhH`xIUMU@]TL\\em_XICP`\ngGPhH`xIUMU@]TL]Fm_XICP`\ngGPhH`xYIHZj@zH\\ek]DMB\ngGPhHaVYICE`@z`[h{oP\ngGPhHaVYICJ`@z`[h{np=\ngGPhHaxIU[U@]TJ\\ek_XICP`\ngGPhHaxIU[U@]TJ]Fm_XICP`\ngGPhHaxIU[UPH]TJ\\fk_XICP`<\ngGPhHaxYICJ`@z`[h{oP\ngGPhI`xIKUU@]FJRuoaxahP\ngGPhaePRUrUuUPGUCEIkWtBPtH\ngGPhaePRUrUuUPGUCEIkYpXiohDahP\ngGPiAePKdkjj`NjFJSVs`qS_PICP`\ngGPiCPDWdfZe`NeIMtM{X\ngGPllQHR`TaNliM]U@]ZNZyr\\eoJD\ngGPmLQHR`TaNRZzj@zt\\usdyK^TH\ngGQ@@dmMTAuXirVm}`dMB\ngGQ@@dmMTAuXirVm}`dM|\ngGQ@@dmMTAuXirVu}`dMB\ngGQ@@dmMTAuXirZu}`dMB\ngGQ@@dmUTAuXirVm}`dMB\ngGQ@@dmUTAuXirVm}`dM|\ngGQ@@dmUTAuXirVnRFJ\\wvBPtH\ngGQ@@dmUTAuXirVn\\FJ[{AHZD\ngGQ@@dmUTAuXirVu}`dMB\ngGQ@@dsM@AthyolD{np=\ngGQ@@dsM@AthyolD{oP\ngGQ@@dsM@AthyolD}oP=\ngGQ@@dsM@Athyomx{np=\ngGQ@@dsM@Athyomx{oP\ngGQ@@dsM@AthyshiK_XIw^`\ngGQ@@dsM@AthyshiK_[qw^`\ngGQ@@dsM@Athyshis_XI{^`\ngGQ@@dsM@Athyshis_[q{^`\ngGQ@@dsM@AthzolD{np=\ngGQ@@dsM@AthzolD{oP\ngGQ@@dsM@AthzolD}oP=\ngGQ@@dsM@AthzshiK_XIw^`\ngGQ@@dsM@Athzshis_XI{^`\ngGQ@@dsMLAuXirVmu`tH\ngGQ@@dsMLAuXirVmu`wp\ngGQ@@dsMLAuXirVmuoTH\ngGQ@@dsMLAuXirVm}`gmB\ngGQ@@dsMLAuXirVm}`gm|\ngGQ@@dsMLAuXirVn]EI[kAhP\ngGQ@@dsMLAuXirVn]EI[kAo`\ngGQ@@dsMLAuXirVn]EI[k^hP\ngGQ@@dsMLAuXirVn]EI[{AOZD\ngGQ@@dsMLAuXirVn]EI[{AO[x\ngGQ@@dsMLAuXirVn]EI[{^OZD\ngGQ@@dsMLAuXirVn]EN[kAhP\ngGQ@@dsMLAuXirVn]EN[kAo`\ngGQ@@dsMLAuXirVn]EN[k^hP\ngGQ@@dsMLAuXirVn]EN[{AOZD\ngGQ@@dsMLAuXirVn]EN[{AO[x\ngGQ@@dsMLAuXirVn]EN[{^OZD\ngGQ@@dsMLAuXirVu}`gmB\ngGQ@@dsMLAuXirVv]EI[{AOZD\ngGQ@@dsMLAuXirVv]EN[kAhP\ngGQ@@dsMLAuXirVv]EN[{AOZD\ngGQ@@dsMLAuXitVmu`tH\ngGQ@@dsMLAuXitVmu`wp\ngGQ@@dsMLAuXitVm}`gmB\ngGQ@@dsMLAuXitVm}`gm|\ngGQ@@dsMLAuXitVn]EI[kAhP\ngGQ@@dsMLAuXitVn]EI[kAo`\ngGQ@@dsMLAuXitVn]EI[{AOZD\ngGQ@@dsMLAuXitVn]EI[{AO[x\ngGQ@@dsMLAuXitVn]EN[kAhP\ngGQ@@dsMLAuXitVn]EN[kAo`\ngGQ@@dsMLAuXitVn]EN[{AOZD\ngGQ@@dsMLAuXitVn]EN[{AO[x\ngGQ@@dsMLAuXitVuu`tH\ngGQ@@dsMLAuXitVu}`gmB\ngGQ@@dsMLAuXitVv]EN[kAhP\ngGQ@@dsMLAuXitVv]EN[{AOZD\ngGQ@@dsMLAuhjs_XIw]`\ngGQ@@dsMLAuhjs_XIw^`\ngGQ@@dsMLAuhjs_XI{]`\ngGQ@@dsMLAuhjs_XI{^`\ngGQ@@dsMLAuhjs_[qw^`\ngGQ@@dsMLAuhjsgQSf~pSv{@\ngGQ@@dsMLAuhjsgQSf~pSv}@\ngGQ@@dsMLAuhju_XIw^`\ngGQ@@dsMLAuhju_XI{]`\ngGQ@@dsMLAuhju_XI{^`\ngGQ@@dsMLAuhjugQSf~pSv{@\ngGQ@@dsMLAuhjugQSf~pSv}@\ngGQ@@dsMTAuXirVm}`dMB\ngGQ@@dsMTAuXirVm}`dMC~RqI@\ngGQ@@dsMTAuXirVm}oDMB\ngGQ@@dsMTAuXirVnSENRwvBPtH\ngGQ@@dsMTAuXirVnSENRwv|PtH\ngGQ@@dsMTAuXirZvSENRwvBPtH\ngGQ@@dsMTAuXitVm}`dMB\ngGQ@@dsMTAuXitVm}`dMC~RqI@\ngGQ@@dsMTAuXitVm}`gu|\ngGQ@@dsMTAuXitZu}`dMB\ngGQ@@dsMUDauXirVm}`dM|<\ngGQ@@dsMUDauXirVm}`dM|>\ngGQ@@dsMUDauXirVnSENRwvBPwp<\ngGQ@@dsMUDauXirVnSENRwvBPwp>\ngGQ@@dsMUDauXirVnSENRwv|Pwp>\ngGQ@@dsMUDauXirVn]EI[{AH[x<\ngGQ@@dsMUDauXirVn]EI[{AH[x>\ngGQ@@dsMUDauXirVn]EI[{AH[{|ebR>\ngGQ@@dsMUDauXirVn]EN[{AHZD<\ngGQ@@dsMUDauXirVn]EN[{AHZD>\ngGQ@@dsMUDauXirVn]EN[{AHZG|ebR<\ngGQ@@dsMUDauXirVn]EN[{AHZG|ebR>\ngGQ@@dsMUDauXirVn]EN[{AH[x<\ngGQ@@dsMUDauXirVn]EN[{AH[x>\ngGQ@@dsMUDauXirVn]EN[{AOkx<\ngGQ@@dsMUDauXirVn]EN[{AOkx>\ngGQ@@dsMUDauXirVn]EN[{^HZD<\ngGQ@@dsMUDauXirVn]EN[{^HZD>\ngGQ@@dsMUDauXirVv]EN[{AHZD<\ngGQ@@dsMUDauXirVv]EN[{AHZD>\ngGQ@@dsMUDauXitVm}`dM|<\ngGQ@@dsMUDauXitVm}`dM|>\ngGQ@@dsMUDauXitVn]EI[{AH[x<\ngGQ@@dsMUDauXitVn]EN[{AHZD<\ngGQ@@dsMUDauXitVn]EN[{AHZD>\ngGQ@@dsMUDauXitVu}`dMB<\ngGQ@@dsMUDauXitVu}`dMB>\ngGQ@@dsT`Athyncn{@=\ngGQ@@dsT`Athyncn}@\ngGQ@@dsT`Athyncv}@=\ngGQ@@dsT`Athyomt{np=\ngGQ@@dsT`Athyomt{oP\ngGQ@@dsT`Athys`qK]G]z\ngGQ@@dsT`Athys`qK_[iw^`\ngGQ@@dsT`AthyshiK]G]z\ngGQ@@dsT`AthyshiK_[iw^`\ngGQ@@dsT`Athyshis_[i{^`\ngGQ@@dsT`AuIWHwmg]v=\ngGQ@@dsT`AuIWHwmg]z\ngGQ@@dsT`AuIWHwmgmz=\ngGQ@@dsT`AuIWHwng]v=\ngGQ@@dsT`AuIWHwng]z\ngGQ@@dsT`AuIYtTenQo]N{t\ngGQ@@dsTlAtYIKV~F}na@\ngGQ@@dsTlAtYIKZyF}l}hP\ngGQ@@dsTlAuXirVnZFJ\\encva@\ngGQ@@dsTlAuXirVn]EN[{]OZD\ngGQ@@dsUAHathyolD{np+\ngGQ@@dsUAHathyolD{np-\ngGQ@@dsUAHathyolD{oP<\ngGQ@@dsUAHathyolD{oP>\ngGQ@@dsUAHathyolD}oP+\ngGQ@@dsUAHathyolD}oP-\ngGQ@@dsUAHathyomx{np+\ngGQ@@dsUAHathyomx{np-\ngGQ@@dsUAHathyomx{oP<\ngGQ@@dsUAHathyomx{oP>\ngGQ@@dsUAHathyrPqRV~pSn}@<\ngGQ@@dsUAHathyrPqRV~pSn}@>\ngGQ@@dsUAHathys`qK_XIw^`<\ngGQ@@dsUAHathys`qK_XIw^`>\ngGQ@@dsUAHathyshiK_XIw^`<\ngGQ@@dsUAHathyshiK_XIw^`>\ngGQ@@dsUAHathyshiK_[qw^`<\ngGQ@@dsUAHathyshiK_[qw^`>\ngGQ@@dsUAHathyshis_XI{^`<\ngGQ@@dsUAHathyshis_XI{^`>\ngGQ@@dsUAHathyshis_[q{^`<\ngGQ@@dsUAHathyshis_[q{^`>\ngGQ@@dsUAHathzolD{np+\ngGQ@@dsUAHathzolD{np-\ngGQ@@dsUAHathzolD{oP<\ngGQ@@dsUAHathzolD{oP>\ngGQ@@dsUAHathzolD}oP-\ngGQ@@dsUAHathzs`qK_XIw^`<\ngGQ@@dsUAHathzs`qK_XIw^`>\ngGQ@@dsUMHauXirVmu`tH<\ngGQ@@dsUMHauXirVmu`tH>\ngGQ@@dsUMHauXirVm}`gmB<\ngGQ@@dsUMHauXirVm}`gmB>\ngGQ@@dsUMHauXirVm}`gm|>\ngGQ@@dsUMHauXirVnRFJ\\wVCP`<\ngGQ@@dsUMHauXirVnZFJ\\enlFa@>\ngGQ@@dsUMHauXirVn\\FN[{AOZD<\ngGQ@@dsUMHauXirVn\\FN[{AOZD>\ngGQ@@dsUMHauXirVn]EI[kAhP<\ngGQ@@dsUMHauXirVn]EI[kAhP>\ngGQ@@dsUMHauXirVn]EI[kAo`<\ngGQ@@dsUMHauXirVn]EI[kAo`>\ngGQ@@dsUMHauXirVn]EI[k^hP>\ngGQ@@dsUMHauXirVn]EI[{AO[x>\ngGQ@@dsUMHauXirVn]EI[{^OZD<\ngGQ@@dsUMHauXirVn]EN[kAhP<\ngGQ@@dsUMHauXirVn]EN[kAhP>\ngGQ@@dsUMHauXirVn]EN[{AOZD<\ngGQ@@dsUMHauXirVn]EN[{AOZD>\ngGQ@@dsUMHauXirVuu`tH<\ngGQ@@dsUMHauXitVmu`tH<\ngGQ@@dsUMHauXitVmu`tH>\ngGQ@@dsUMHauhjs_XIw]`<\ngGQ@@dsUMHauhjs_XIw]`>\ngGQ@@dsUMHauhjs_[qw]`<\ngGQ@@dsUMHauhjs_[qw]`>\ngGQ@@dsUThdauXirVm}`dM|<\ngGQ@@dsUThdauXirVm}`dM|>\ngGQ@@dsUThdauXirVnRFJRwvBPwp<\ngGQ@@dsUThdauXirVnRFJ\\wvBPtH>\ngGQ@@dsUThdauXirVnSENRwvBPwp>\ngGQ@@dsUThdauXirVn\\FN[{AHZD<\ngGQ@@dsUThdauXirVn\\FN[{AHZD>\ngGQ@@dsUThdauXirVn]EI[{AH[x<\ngGQ@@dsUThdauXirVn]EI[{AH[x>\ngGQ@@dsUThdauXirVn]EN[{AHZD<\ngGQ@@dsUThdauXirVn]EN[{AHZD>\ngGQ@@dsUThdauXirVn]EN[{AH[x<\ngGQ@@dsUThdauXirVn]EN[{AH[x>\ngGQ@@dsUThdauXirVn]EN[{AOkx<\ngGQ@@dsUThdauXirVn]EN[{AOkx>\ngGQ@@dsUThdauXirVn]EN[{^HZD<\ngGQ@@dsUThdauXirVn]EN[{^HZD>\ngGQ@@dsUThdauXirVn]EN[{^Okx<\ngGQ@@dsUThdauXirVu}`dMB<\ngGQ@@dsUThdauXirVv]EN[{AHZD<\ngGQ@@dsUThdauXirVv]EN[{AHZD>\ngGQ@@dsUThdauXitVn]EN[{AHZD<\ngGQ@@dsUThdauXitVn]EN[{AHZD>\ngGQ@@dsUTheAuXirVm}`dM|<\ngGQ@@dsUTheAuXirVm}`dM|>\ngGQ@@dsUTheAuXirVm}oDM|<\ngGQ@@dsUTheAuXirVnRFJRwvBPwp>\ngGQ@@dsUTheAuXirVnRFJ\\wvBPtH<\ngGQ@@dsUTheAuXirVnRFJ\\wvBPtH>\ngGQ@@dsUTheAuXirVn\\FN[{AHZD<\ngGQ@@dsUTheAuXirVn\\FN[{AHZD>\ngGQ@@dsUTheAuXirVn]EI[{AH[x<\ngGQ@@dsUTheAuXirVn]EI[{AH[x>\ngGQ@@dsUTheAuXirVn]EI[{^H[x>\ngGQ@@dsUTheAuXirVn]EN[{AHZD<\ngGQ@@dsUTheAuXirVn]EN[{AHZD>\ngGQ@@dsUTheAuXirVn]EN[{AH[x<\ngGQ@@dsUTheAuXirVn]EN[{AH[x>\ngGQ@@dsUTheAuXirVn]EN[{AOkx<\ngGQ@@dsUTheAuXirVn]EN[{AOkx>\ngGQ@@dsUTheAuXirVu}`dMB<\ngGQ@@dsUTheAuXirVu}`dMB>\ngGQ@@dsUTheAuXirVv]EN[{AHZD<\ngGQ@@dsUTheAuXitVm}`dM|>\ngGQ@@dsUTiDauXirVn]EN[{^HZD<\ngGQ@@dsUTiDauXirVn]EN[{^HZD>\ngGQ@@dsUTiDauXitVn\\FN[{AHZD<\ngGQ@@dsUTiDauXitVn\\FN[{AHZD>\ngGQ@@dsUTiDauXitVn]EN[{AHZD>\ngGQ@@dsUUHauXirVm}`dMB<\ngGQ@@dsUUHauXirVm}`dMB>\ngGQ@@dsUUHauXirVm}`dMC~RqI@<\ngGQ@@dsUUHauXirVm}`gu|>\ngGQ@@dsUUHauXirVm}oDMB<\ngGQ@@dsUUHauXirVm}oDMB>\ngGQ@@dsUUHauXirVm}oGu|<\ngGQ@@dsUUHauXirVnSENRwvBPtH<\ngGQ@@dsUUHauXirVnSENRwvBPtH>\ngGQ@@dsUUHauXirVnSENRwv|PtH<\ngGQ@@dsUUHauXirVnZFJ\\eolDahP<\ngGQ@@dsUUHauXirVnZFJ\\eolDahP>\ngGQ@@dsUUHauXirVnZFJ\\eomxahP<\ngGQ@@dsUUHauXitVm}`dMB<\ngGQ@@dsUUHauXitVm}`dMB>\ngGQ@@dtuRAuXirVmu`dH\ngGQ@@dtuRAuXirVnSENRwVBP`\ngGQ@@dtuRAuXirVn\\FI[kAHP\ngGQ@@dtuRAuXirVn\\FI[{AH[t\ngGQ@@dtuRAuXitZn\\FI[kAHP\ngGQ@@dtuSHauXirVmu`gp>\ngGQ@@dtuSHauXirVnRFJRwVBP`<\ngGQ@@dtuSHauXirVnRFNRwVB_@<\ngGQ@@dtuSHauXirVnSENRwVB_@>\ngGQ@@dtuSHauXirVn]EI[kAHP<\ngGQ@@dtuSHauXirVn]EI[kAHP>\ngGQ@@dtuSHauXirVn]EI[{AH[t<\ngGQ@@dtuSHauXirVn]EI[{AH[t>\ngGQ@@dtuSHauXirVn]GI[kAO`<\ngGQ@@dtuSHauXirZn]EI[kAHP<\ngGQ@@dtuSHauXirZn]EI[kAHP>\ngGQ@@dtuTAuXirVm}`dMB\ngGQ@@dtuTAuXirVm}oGuB\ngGQ@@dtuTAuXirVnSENRwvBPtH\ngGQ@@dtuTAuXirVnSENRwvBPwp\ngGQ@@dtuTAuXirVn\\FI[{AHZD\ngGQ@@dtuTAuXirVn\\FI[{AH[x\ngGQ@@dtuTAuXirVu}`dMB\ngGQ@@dtuTAuXitZm}`dMB\ngGQ@@dtuUHauXirVm}`guB<\ngGQ@@dtuUHauXirVm}`guB>\ngGQ@@dtuUHauXirVnRFJRwvBPtH<\ngGQ@@dtuUHauXirVnRFJRwvBPtH>\ngGQ@@dtuUHauXirVnRFNRwvB_TH<\ngGQ@@dtuUHauXirVnRFNRwvB_TH>\ngGQ@@dtuUHauXirVnSENRwvB_TH<\ngGQ@@dtuUHauXirVn]EI[{AHZD<\ngGQ@@dtuUHauXirVn]EI[{AHZD>\ngGQ@@dtuUHauXirVn]EI[{AHZG|dcb>\ngGQ@@dtuUHauXirVn]EI[{AH[x<\ngGQ@@dtuUHauXirVn]EI[{AH[x>\ngGQ@@dtuUHauXirVn]EI[{AOjD<\ngGQ@@dtuUHauXirVn]EI[{AOjD>\ngGQ@@dtuUHauXirVn]EI[{^OjD<\ngGQ@@dtuUHauXirVn]EI[{^OjD>\ngGQ@@dtuUHauXirVn]GI[{AOjD<\ngGQ@@dtuUHauXirVn]GI[{AOjD>\ngGQ@@dtuUHauXirVn]GI[{AOkx<\ngGQ@@dtuUHauXirVn]GI[{AOkx>\ngGQ@@dtuUHauXirVv]EI[{AHZD<\ngGQ@@dtuUHauXirZm}`dMB<\ngGQ@@dtuUHauXirZm}`dMB>\ngGQ@@dtuUHauXirZm}`dM|<\ngGQ@@dtuUHauXirZn\\FI[{AHZD<\ngGQ@@dtuUHauXirZn\\FI[{AHZD>\ngGQ@@dtuUHauXirZn]EI[{AHZD<\ngGQ@@dtuUHauXirZn]EI[{AHZD>\ngGQ@@dtuUHauXirZu}`dMB<\ngGQ@@dtuUHauXirZu}`dMB>\ngGQ@@dtuUHauXitVm}`guB<\ngGQ@@dtuUHauXitVm}`guB>\ngGQ@@dtuUHauXitVn]GI[{AOjD>\ngGQ@@dwSTAtYYKVyFulahP\ngGQ@@dwSTAuXirVmtPtH\ngGQ@@dwSTAuXirVm|ndMB\ngGQ@@dwSULauXirVn]EN[hahP>\ngGQ@@dwSULauXirVn]EN[y]HZD<\ngGQ@@eMUTAtpqSdm[eApRFa@\ngGQ@@eMUTAtpqSdm[eApRFaIHx`\ngGQ@@eMUTAtpqSdm[eApRF~@\ngGQ@@eMUTAtpqSdm[eApSz~@\ngGQ@@eMUTAtpqSdm\\dLTynTGAHZD\ngGQ@@eMUTAtpqSdm\\dLTynU{AHZD\ngGQ@@eMUTAtpqSdm\\xLRwJC`dM|\ngGQ@@eMUTAtpqSdm\\xLRwJ}`dM|\ngGQ@@eMUTAtpqSdm\\xLTwJC`dMB\ngGQ@@eMUTAtpqSdm\\xLTwJ}`dMB\ngGQ@@eMUTAtpqSdmkeApRFa@\ngGQ@@eMUTAtpqSdmkeApRFaIHx`\ngGQ@@eMUTAtpqSdukeApRFa@\ngGQ@@eMUTAtpqShukeApRFa@\ngGQ@@eMUTAtpqShulxLTwJ}`dMB\ngGQ@@eMUTAtpqUdm[eApRFa@\ngGQ@@eMUTAtpqUdm\\xLRwJC`dM|\ngGQ@@eMUTAtpqUdm\\xLTwJC`dMB\ngGQ@@eMUTAtpqUdulxLTwJC`dMB\ngGQ@@eMUUHatpqSdm\\dLTenU{AH[x>\ngGQ@@eMUUHatpqSdm\\xLTwJC`dM|<\ngGQ@@eMUUHatpqSdm\\xLTwJC`dM|>\ngGQ@@eMUUHatpqSdmlxLTwJC`dMB<\ngGQ@@eMUUHatpqSdmlxLTwJC`dMB>\ngGQ@@eMUUHatpqSdu[eApRF~@<\ngGQ@@eMUUHatpqSdu[eApRF~@>\ngGQ@@eMUUHatpqUdmlxLTwJC`dMB>\ngGQA@NRYjP@zT\\wQw]`=\ngGQA@NRYjP@zT\\wvz]wX=\ngGQA@NRYjP@zT\\ytTeomt{oP\ngGQAAIRYj`@zT\\wvB]wX+\ngGQAAIRYjf@zlTyK[Nbdm}`gmB>\ngGQBBGBNB\\LxYIIZj@zpRunYy^wjD\ngGQDHGBnBUSUPGUCENRwJC`dM|\ngGQDHGBnBUSUPGUCENRwJC`gu|\ngGQDHGBnBUSUPGUCENRypXenTGAH[x\ngGQDHGBnBUSUPGUCENSWJC`dM|\ngGQDHGBnBUSUPGUCEVcWJC`dM|\ngGQDJ@aABSWUPGVcdmxP`\ngGQDJIARBSWUPGVcdmx_@\ngGQDJIARBSWUPGVcdn\\gI[p~@\ngGQDLOA^FQRFj`NmDm[x^WjD\ngGQHAJAIfj@CiQs_XIw]`+\ngGQHAJAIfj@CiQs_XI{^`+\ngGQHAJAIfj@CiQu_XIw^`>\ngGQHAJAIfj@CiQu_XI{^`+\ngGQHAJAIfj@CiQugQRV~pSn}@>\ngGQHAJAIfj@CiQugQSf~pSv}@>\ngGQHAJAIfjXCjqShmk{AOZD>\ngGQHAJAIfjhCjqSdm[{AHZD>\ngGQHAjAInfhChrrZurMkYCP`\ngGQHB@aIfiXChqSfn]EI[k]hP\ngGQHB@aIfiXChqSfuyP`\ngGQHB@aIfiXChqSfv]EI[k]hP\ngGQHB@aIfiXCkRSV~F}na@\ngGQHB@aIfiXCkRSV~F}va@\ngGQHB@aIfiXCkRSWNbdm|M{mB\ngGQHB@aIfiXCkRSZ~F}na@\ngGQHB@aIfiXCkRSZ~F}va@\ngGQHB@aIfiXCkRS[Nbdm|M{mB\ngGQHB@aIfidCiRU\\c^v]wX\ngGQHB@aIfjiQJChqSjn\\FI[kAhP>\ngGQHB@aInfjZCkRsV~Fuva@<\ngGQHBGAIfiXChqSfn]EI[h^hP\ngGQHBHaIfiXChqSfn]EI[k]hP\ngGQHBHaIfiXChqSfn]EI[k]o`\ngGQHBHaIfiXChqSfn]EI[ra@\ngGQHBHaIfiXChqSfv]EI[k]hP\ngGQHBHaIfjiQIChqSfmu`tH<\ngGQHBHaIfjiQJChqSfmu`tH>\ngGQHBHaIfjiQJChqSfn]EI[kAhP<\ngGQHBHaIfjiQJChqSfn]EI[kAhP>\ngGQHBIAIfiXChqSfn]EI[k]hP\ngGQHBIAIfjiQIChqSfnSENRwVCP`>\ngGQHBIAIfjiQIChqSfn]EI[kAhP>\ngGQHBIAIfjiQJChqSfn]EI[kAhP<\ngGQHBIAIfjiQJChqSfn]EI[kAhP>\ngGQHBJqIfiXChqSfn]EI[k]hP\ngGQHBJqIfiXChqSfn]EI[ra@\ngGQHBJqIfjiQJChqSfn]EI[kAhP<\ngGQHBLQIfiXChqSfn]EI[k]hP\ngGQHBLQIfiXChqSfn]EI[ra@\ngGQHBLQIfiXChqSfv]EI[k]hP\ngGQHBLQIfjZQChqSfuu`tH<\ngGQHBLQIfjZQChqSfuu`tH>\ngGQHBLQIfjiQIChqSfmu`tH>\ngGQHBLQIfjiQJChqSfmu`tH>\ngGQHBLQInfjZChqSfn]EI[ra@>\ngGQHD@aInZ@CjQshiK]G]z\ngGQHD@aInf@CjQncn{@=\ngGQHD@aInfhChqrVmtPtH\ngGQHDHaInf@CjQncn{@=\ngGQHDOAIijjQCjqSdm\\dLTenQ{AH[x<\ngGQHDOAIijjQCjqSdm\\dLTeolDao`<\ngGQHDOAIkjjQChqrVnRFJRwQC_@<\ngGQHDOAIkjjQChqrVnRFJRwp|Pwp<\ngGQHDOAInf@CjQncn{@=\ngGQHDOAInjBQCjQoax{np+\ngGQHDOAInjBQCjQoax{np-\ngGQHH@aJnZBACiAs_XIw]`+\ngGQHH@aJnZBACiAs_XIw]`-\ngGQHH@aJnZBACiAs_XIw^`>\ngGQHH@aJnZBACiAs_[qw]`-\ngGQHH@aJnZBACiAu_XIw]`+\ngGQHH@aJnZBACiAu_XIw]`-\ngGQHH@aJnZBACiAu_XIw^`<\ngGQHH@aJnZBACiAu_XIw^`>\ngGQHH@aJnZBACiAugQRV~pSn}@<\ngGQHH@aJnZBACiAugQRV~pSn}@>\ngGQHH@aJnZZACkAUf~pSv}@<\ngGQHH@aJnZZACkAUf~pSv}@>\ngGQHH@aJnZZACkAUj~pSv}@<\ngGQHH@aJnZZACkAUj~pSv}@>\ngGQHH@aJnZjACjaShm[{AHZD>\ngGQHHDQJnZ@CiAu_XIw^`>\ngGQHHGAIZjhCjqSdm[d^pRFa@\ngGQHHGAIZjhCjqSdm[d^pRF~@\ngGQHHGAIZjhCjqSdm\\xLTwH}`dMB\ngGQHHGAIZjhCjqSdmkd^pRFa@\ngGQHHGAIZjhCjqSdukd^pRFa@\ngGQHHGAJijhCiabgIZwJC`dMB\ngGQHHGAJijhCiabgIZwJC`dM|\ngGQHHGAJijhCiabgIZwJC`guB\ngGQHHGAJijhCiabgIZwJC`gu|\ngGQHHGAJijhCiabgI[WJC`dMB\ngGQHHGAJijhCiabgI[WJC`guB\ngGQHHGAJijhCiabkQZwJC`guB\ngGQHHGAJijhCiabkQ[WJC`guB\ngGQHHGAJijhCiabkQjwJC`dMB\ngGQHHGAJkjdCjaSdm[kAHP\ngGQHHGAJkjhCjaSdm[{AHZD\ngGQHHOAJkZhCjaSdm[{AHZD\ngGQHHOAJkZhCjaShu[{AHZD\ngGQHHOAJkZhCjaShuk{AHZD\ngGQHJGAJijhCjabgI[yApRD\ngGQH`jBRnRnjj@zXXitZus@xICP`\ngGQI@jA\\e]UTAtpqSdukfApRFa@\ngGQI@jA\\e]UTAtpqSdulxLTwLC`dMB\ngGQI@jA\\e]UTAtpqShukfApRFa@\ngGQIAJB\\dsU@AthzolD}oP+\ngGQIAJB\\dtuTAuXirVm}`dMB\ngGQIAJB\\dtuTAuXitZn\\FI[{AHZD\ngGQIB@`|dsTrAuiIkgQRV~F}v}@\ngGQIHBpReWU@At`zolD{oP>\ngGQIHO@ReUuTAuPirVm}`dMB\ngGQIJO@ReTuTAuPqSdm|`xIB\ngGQLBIARFdLbdMU@]ZIZweB\ngGQLBIARFdLbdMU@]ZI[WeB\ngGQLJHaQFbLbdMU@]JIP\ngGQLJIARFdLbdMU@]JIP\ngGQLL@b^BBDfmjiDNcGIjwQCP`<\ngGQ`@ZdsMTAuhisdqSdmy``\ngGQ`@ZdwSTAtiYnam[@\ngGQ`@bdwMLAuhyk^TH\ngGQ`@bdwMLAuhym^TH\ngGQ`@bdwMRAthzncn{@\ngGQ`@bdwMRAthzncn}@\ngGQ`@bdwMRAuhyj\ngGQ`@bdwMRAuhyk^Wh\ngGQ`@bdwMUMAuhyk^TH<\ngGQ`@bdwMUMAuhyk^TH>\ngGQ`@bdwMUMAuhyk^Wp<\ngGQ`@bdwMUMAuhyk^Wp>\ngGQ`@bdwMUMAuhykgQSf|hP<\ngGQ`@bdwMUMAuhykgQSf|hP>\ngGQ`@bdwMUMAuhym^TH<\ngGQ`@bdwMUMAuhym^TH>\ngGQ`@bdwUThlauhykgARV|hP<\ngGQ`@bdwUThlauhykgARV|hP>\ngGQ`@bdwUThmAuhykgARV|hP<\ngGQ`@bdwUThmAuhykgARV|hP>\ngGQ`@bdwUThmAuhykgARV|o`<\ngGQ`@bdwUUMAuhykdabdmyP`<\ngGQ`@bdwUUMAuhykdabdmyP`>\ngGQ`@jduuTAuhyK^DH\ngGQ`@jduuTAuhyKgIrV|HP\ngGQ`@jduuTAuhyM^DH\ngGQ`ALe]UTAtPiKVzHZD\ngGQ`ALe]UTAtPiKWNCEMtPtH\ngGQ`ALe]UUDatPiKWICEN[hahP<\ngGQ`AbeMUTAtPqSVzPZD\ngGQ`AbeMUTAtPqSWICEN[iAhP\ngGQ`AbeMUTAtPqS[ICEN[iAhP\ngGQa@bnR[fjf`zt\\uoJD<\ngGQa@bnR[fjf`zt\\uoJD>\ngGQa@bnR[fjf`zt\\voJD<\ngGQa@bnR[fjf`zt\\voJD>\ngGQdEb@b^BSRuPGVbfmyP`\ngGQdEb@b^BSRuPGVbfuyP`\ngGQdEbGBNBUWUPGVBfmuOTH\ngGQdHl@btFRREZ`NlGI[h~o`\ngGQdHlGBnBUSUPGVCDmtPwp\ngGQdHlGBnBUSUPGVCDmt_Wp\ngGQdHlGBnBUSUPGVCDutPwp\ngGQdHlGBtBUSUPGVCDuxP`\ngGQdHlOB~BUVuTBGVBdutPwp>\ngGQdHlOB~BUVuTBGVBdv]EI[hao`<\ngGQdHlOB~BUVuTBGVBdv]EI[hao`>\ngGQdIbBqNBRuUPGVbfmtOWp\ngGQdLZ@a^BRuSPGRbf|G`\ngGQdhlOBt@f|eTuTAu`qM]DM|\ngGQdibOAT@e\\dmUTAuhim]CuB\ngGQeEb@bN@yIijhCkQSV|o`\ngGQeEb@bN@yIijhCkQSZ|hP\ngGQhHl@cIIBmPGQCdm[hahP\ngGQhHl@cIIBmPGQCdm[h~hP\ngGQhHl@cIIBmPGQCdmkhahP\ngGQhHl@cIIBmPGQCdmkh~hP\ngGQhHl@cIIBmPGQCdu[hahP\ngGQhHl@cIIBmPGQCdukhahP\ngGQhHl@cIIJmPGVBVmy_@\ngGQhHlBqJijhChabZv\\GI[hah_rTJH\ngGQhHlGAJijhChabVmtPtH\ngGQhHlGAJijhChabVmtPwp\ngGQhHlGCIIKUHGVBVh\ngGQhHlGCIIKUPGVBVmyP`\ngGQhHlOAJkZjAChaRVmtPtH<\ngGQhHlOAJkZjAChaRVmtPtH>\ngGQhHlOAJkZjAChaRVmt_TH<\ngGQhHlOAJkZjAChaRVmt_TH>\ngGQhHlOAJkZjAChaRVn]EI[hahP<\ngGQhHlOAJkZjAChaRVn]EI[hahP>\ngGQhHlOAJkZjAChaRVn]EI[h~hP<\ngGQhHlOAJkZjAChaRVn]EI[h~hP>\ngGQhHlOAJkZjAChaRVutPtH<\ngGQhHlOAJkZjAChaRVutPtH>\ngGQhHlOAJkZjAChaRZmtPtH<\ngGQhHlOAJkZjAChaRZmtPtH>\ngGQhHlOAJkZjAChaRZutPtH<\ngGQhHlOAJkZjAChaRZutPtH>\ngGQhHlOCIIJuHGVBVmy^`\ngGQhHlOCIIJuPGVBVmyP`\ngGQhHlOCIIJuPGVBVuyP`\ngGQiAbjA\\e]UTAtPqSZz`ZD\ngGQiHl@c]ddeVhCkAKV|hP\ngGQiHl@c]ddeVhCkAKV|o`\ngGQiHlOC]ddeZjACkAKV|hP<\ngGQiHlOC]ddeZjACkAKV|hP>\ngGR@@cTfxH@MrMkYw]`=\ngGR@@cTfyi`NeKUrMkYw]`\ngGR@@cTfyi`NeKUrMkYw^`\ngGR@@cTfyi`NeKUrMkiw^`\ngGR@@cTfzj`NeGNZFJ\\e@\ngGR@@lTfYj`NeEUt]wo{Q@\ngGR@@lTfYj`NeIUrM{Yw^mD\ngGR@@lTfxJ`NijyFul{nvf@=\ngGR@@lTfxJ`NijyFul{o_vf@=\ngGR@@m\\bdMU@]JIP\ngGR@ACTjzj`NdIMuM{_{P@\ngGR@ACTjzj`NdIMuM{o{P@\ngGRA@l]rSLuPGRdjyF}l{o_vb@\ngGRD@cYPZ`R[jj@zT\\`\ngGRDHlQxWpRjYi@zPXmH\ngGREHlQxWpTiULtpH]HL\\xJRmH<\ngGREHlQxWpTiULtpH]HL\\xJRmH>\ngGREHlQxWpWIU[U@]HJ\\xLRwe}~tP\ngGREIcQxKpTiKSU@]JJ\\xLTmH\ngGRHHlQxIU[U@]XJZweC~tP\ngGRHHlQxYIHPj@zVZwtvmtO{S@\ngGRHHlQxYIHPj@zVZwtvmww{S@\ngGRHHlQxYIHPj@zVZyr\\eoim[h_vf@\ngGRHHlQxYIHPj@zV[WtvmtO{S@\ngGRIHlQxBTjfj`NlFM[ra@\ngGRIHlQxRTjmj`NlEM[raZH\ngGT@@TfX`@MrM{Yw]`\ngGT@@TfX`@MrM{Yw^`\ngGT@@TfX`@MrM{Y{]`\ngGT@@TfX`@MrM{iw^`\ngGT@@TfX`@N]EI[d[wSn}@\ngGT@@TfXa`NdfmrM{Y{P`\ngGT@@TfXa`Ndfm|M{]B\ngGT@@TfXa`NdfurM{Y{P`\ngGT@@TfXa`Ndfu|M{]B\ngGT@@TfXbPNdfmtM{X\ngGT@@TfXbPNdfm|M{]z\ngGT@@TfXbPNhjyF}l{np\ngGT@@TfXbPNhjyF}l{oP\ngGT@@TfXbPNhjyF}l}np\ngGT@@TfXbPNhjyF}t{np\ngGT@@TfXbPNhjyF}t{oP\ngGT@@TfXbPNhkNbdmrM{iw^`\ngGT@@TfYh@NiJyF}l{np\ngGT@@TfYh@NiJyF}t{np\ngGT@@TfYi`NcENZwVCP`\ngGT@@TfYi`NcENkWH{`gmB\ngGT@@TfYjPNcENZytTeoLD\ngGT@@TfYjPNmEV[{AN{l\ngGT@@TfYjPNmEV[{AN{t\ngGT@@TfZfPNeIUrM{Yw]`\ngGT@@TfZfPNeIUrM{Yw^`\ngGT@@TfZfPNeIUrM{Y{]`\ngGT@@TfZfPNeIUrM{iw^`\ngGT@@TfZfPNeIUrN{Y{]`\ngGT@@TfZfPNeIUrN{i{^`\ngGT@@TfZjeDdNcENZwVCP`\ngGT@@TfZjeDdNcENZytTenlFa@\ngGT@@TfZjeDdNcEN[WVCP`<\ngGT@@TfZjeDdNcEN[YtTynlFa@>\ngGT@@TfZjeDdNcENkWVCP`\ngGT@@TfZjeDhNcENZwVCP`<\ngGT@@TfZjeDhNcENZwVCP`>\ngGT@@TfZjeDhNcENZyhXirVzpZD<\ngGT@@TfZjeDhNcENZytTenlFa@<\ngGT@@TfZjeDhNcENZytTenlFa@>\ngGT@@TfZjeDhNcEN[WVCP`<\ngGT@@TfZjeDhNcEN[WVCP`>\ngGT@@TfZjeDhNcEN[YpXynlFa@>\ngGT@@TfZjeDhNcENkWVCP`<\ngGT@@TfZjeDhNcENkWVCP`>\ngGT@@TfZjeDhNcENkYpXynlFa@>\ngGT@@TfxJihNefm|Mk]B<\ngGT@@TfxJihNefm|Mk]B>\ngGT@@TfxJihNefm|Mk]|>\ngGT@@TfzZihNmKM\\zJ\\wpvntH<\ngGT@@TfzZihNmKM\\zJ\\wpvntH>\ngGT@@TfzZihNmKM\\zJ\\wpzntH>\ngGT@@TfzZihNmKMlzJ\\wpvntH<\ngGT@@TfzZihNmKMlzJ\\wpvntH>\ngGT@@TjZjPNbFR\\wJC`g]z=\ngGT@@TjZjPNbFR\\wJC`gmz=\ngGT@@TjZjPNbFR\\ypXenTGAN{w}h@\ngGT@@TjZjPNbFR\\ypXenTGAO[t\ngGT@@TjZjPNbFR\\ypXenTGAO[w}h@\ngGT@@TjZjPNjFJ\\undGAZ@=\ngGT@@TjZjPNjFJ\\uodGAo_v`@=\ngGT@@TjZjPNjFJ\\usPqSdm|`xM{~t@=\ngGT@@TjZjPNjFJ\\us`qK]HNC~t@\ngGT@@TjZjPNjFJ\\us`qK_HNC^m@\ngGT@@TjZjPNjFJ]Us`is_HNC^m@\ngGT@@TjZjPNjFJ]Us`qK_HNC^m@\ngGT@@TjZjdEDNjFJ\\vs`qs_HNCP`<\ngGT@@TjZjiDNjFJ\\uodGAh_v`@+\ngGT@@TjZjiDNjFJ\\urPqrV~P\\FaZ@<\ngGT@@TjZjiDNjFJ\\usPqSdm|`xMB<\ngGT@@TjZjiDNjFJ\\usPqSdm|`xMB>\ngGT@@TjZjiDNjFJ\\usPqSdm|`xMC~t@-\ngGT@@TjZjiDNjFJ\\us`qK_HNC__m@<\ngGT@@TjZjiDNjFJ\\us`qK_HNC__m@>\ngGT@@TjZjiDNjFJ\\us`qs_HNCPm@>\ngGT@@TjZjiDNjFJ\\vodGAhP>\ngGT@@TjZjiDNjFJ\\vrPqSf~P\\Fa@<\ngGT@@TjZjiDNjFJ\\vrPqSf~P\\Fa@>\ngGT@@TjZjiDNjFJ\\vs`qs_HNCPm@<\ngGT@@TjZjiDNjFJ]Vs`qs_HNCPm@<\ngGT@@TjZjiDNjFJ]Vs`qs_HNCPm@>\ngGT@@TjZjiDNlJM\\xJRwrwntO{P@<\ngGT@@TjZjiDNlJM\\xJRwrwntO{P@>\ngGT@@TjZjiDNlJMlxL\\wr{ntO{P@<\ngGT@@TjZjiDNlJMlxL\\wr{ntO{P@>\ngGT@@dfXb`NhjyF}l{nvb@=\ngGT@@dfXb`NhjyF}l{o_vb@\ngGT@@dfXb`NhjyF}l}o_vb@=\ngGT@@dfXb`NhjyF}t{nvb@=\ngGT@@dfXb`NhjyF}t{o_vb@\ngGT@@dfXb`Nldm[d[vrFaZH=\ngGT@@dfXb`Nldm[d[wRFa@\ngGT@@dfXb`Nldm[d[wRFaZH=\ngGT@@dfXb`Nldm\\zJ\\wHwndMC~tP\ngGT@@dfXb`Nldmkd[vrFaZH\ngGT@@dfXb`Nldmkd[wRFaZH\ngGT@@dfXb`Nldukd[vrFaZH=\ngGT@@dfXb`Nldukd[wRFaZH=\ngGT@@dfXbhdNldm\\zJ\\wHwndMB<\ngGT@@dfXbhdNldmlzJRwHwndMB<\ngGT@@dfXbhdNldmlzJRwHwndMB>\ngGT@@dfYj`NcIIZwHwndMC~tP=\ngGT@@dfYj`NkENRuolDah_vb@=\ngGT@@dfYj`NkENRuomxah_rPJMh`=\ngGT@@dfYj`NkENRusPqSdm}`dMC~tP=\ngGT@@dfYj`NkENRus`qs_XICPmD\ngGT@@dfYj`NkENRushis_XICPmD\ngGT@@dfYj`NkENRvs`qs_XICPmD\ngGT@@dfYj`NkENRvshiK_XICPmD\ngGT@@dfYj`NkENRvshiK_[qCPmD\ngGT@@dfYj`NkENRvshis_XICPmD\ngGT@@dfYj`NkENbuolDah_vb@=\ngGT@@dfYj`NkENbusPqSdm}`dMC~tP=\ngGT@@dfYj`NkENbus`qs_XICPmD\ngGT@@dfYj`NkENbvs`qs_XICPmD\ngGT@@dfnjPNcGIZyr\\eoBD\ngGT@@dfnj`NcGIZwQCP`\ngGT@@dfnj`NcGIZyHXiK]DMB\ngGT@@dfnj`NcGIZyr\\enbFa@\ngGT@@dfnj`NcGI[WQCP`\ngGT@@dfxH@MrMkYw]`=\ngGT@@dfxH@MrMkYw^`=\ngGT@@dfxH@MrMkY{^`=\ngGT@@dfyh@NiFzN{l=\ngGT@@dfyh@NiFzN{t\ngGT@@dfyh@NiFzO[t=\ngGT@@dfyh@NiF~GSn{@=\ngGT@@dfyh@NiF~GSn{I@p`=\ngGT@@dfyh@NiF~GSn}@\ngGT@@dfyh@NiGNBdmt]wh\ngGT@@dfyh@NiGNbdmt]wh\ngGT@@dfyh@NiJyFul{np=\ngGT@@dfyh@NiJyFul{oP\ngGT@@dfyh@NiJyFul}oP=\ngGT@@dfyh@NiJyFut{np=\ngGT@@dfyh@NiJyFut{oP\ngGT@@dfyh@NiJyFut}oP=\ngGT@@dfyh@NiKNbdmrMkiw^`\ngGT@@dfyi`NcGIZytTyncva@\ngGT@@dfyi`NeGV\\EN[h}np\ngGT@@dfyi`NeKUrMkiw^`\ngGT@@dfyj`NcGIZwQCP`\ngGT@@dfyj`NcKIZwHvndMB\ngGT@@dfyjidNcGI[WQCP`<\ngGT@@dfzh@NiFzN{l=\ngGT@@dfzh@NiFzN{t\ngGT@@dfzhIDNiGNBdmt]wh<\ngGT@@dfzhIDNiGNBdmt]wh>\ngGT@@dfzi`NeGUt]wh\ngGT@ADjZj`NbJIZwJ{ndMC~t@=\ngGT@ADjZj`NfFJ\\ek\\hNBPtO{HP=\ngGT@ADjZj`NfFJ\\ekgAcfyP\\Dah_vP`\ngGT@ADjZj`NfFJ\\em\\hNBPtO{HP=\ngGT@ADjZjiDNfFJ\\ekgAcfyP\\Dah_v`@<\ngGT@ADjzh@NdGM}`g]w~t@=\ngGT@ADjzh@NdGM}`g]{~t@\ngGT@ADjzh@NdGM}`gm{~t@=\ngGT@ADjzh@NdGM}oG]w~t@=\ngGT@ADjzh@NdGU}`g]w~t@=\ngGT@ADjzh@NhJyf}l{nv`@=\ngGT@ADjzh@NhJyf}l{o_v`@\ngGT@ADjzh@NhJyf}l}o_v`@=\ngGT@ADjzh@NhJyf}t{nv`@=\ngGT@ADjzh@NhJyf}t{o_v`@\ngGT@ADjzh@NhJyf}t}o_v`@=\ngGT@ADjzh@NhKNbdmsM{iw^m@\ngGT@ADjzi`NbIIZwLwmgmC~t@\ngGT@ADjzi`NbIIZwtwmtO{P@\ngGT@ADjzi`NjENRushis_XI{Pm@\ngGT@ADjzj`NbIIZwLwmdMC~t@\ngGT@ADjzj`NbIIZwLwndMC~t@\ngGT@ADjzj`NjENRuolDah_v`@\ngGT@ADjzj`NjENRurPqrV~pRFaZ@\ngGT@ADjzjdDhNjENRus`qs_XICP`<\ngGT@ADjzjhdNbII[WLwndMC~t@>\ngGT@ADjzjhdNbII[YtTynYo]HZG}h@>\ngGT@ADjzjhdNjENRurPqrV~pRF~Z@<\ngGT@ADjzjhdNjENRurPqrV~pRF~Z@>\ngGT@ADjzjhdNjENRus`qs_XICPm@<\ngGT@ADjzjhdNjENRus`qs_XICPm@>\ngGT@ADjzjhdNjENRvolDah_v`@<\ngGT@ADjzjhdNjENRvolDah_v`@>\ngGT@ADjzjhdNjENRvshis_XICPm@<\ngGT@ADjzjhdNjENRvshis_XICPm@>\ngGT@ADkij`NjENRuolDah_v`@\ngGT@ATeVn`NeDh\ngGT@ATffj`NcENRwVBP`\ngGT@ATffj`NcENRyLTyK]XIB\ngGT@ATffjiDNcENRytTenlDa@<\ngGT@ATffjiDNcENRytTenlDa@>\ngGT@Adijj`NjFJRuodDah_v`@\ngGT@Adijj`NjFJRus`qS_HICPm@\ngGT@Adijj`NjFJbus`qS_HICPm@\ngGT@`QIeIfH@C\\c^v]wX\ngGT@`QIeIfH@CgAcfyG]l}np\ngGT@`QIeIfjiQJChqSfn]EI[kAhP<\ngGT@`QIeIfjiQJChqSjuu`tH<\ngGT@`QIeIfjiQJChqSjuu`tH>\ngGT@`aJyInZ@CjRnQu[N{l=\ngGT@aAteJzjhCjaSdm[{AHZG}h@\ngGTA@QJSLP@FyF}l{np\ngGTA@QJSLP@FyF}l{oP\ngGTA@QJSLPpGRSV~F}na@\ngGTA@QJSLuHGVbkM}`g]v\ngGTA@QJSLuHGVbkV]EN[{AO[l\ngGTA@QJSMURbTGQbgM\\zJRwVCP`<\ngGTA@aJSLuPGUbgIZwH{`dMC~tP=\ngGTA@aJSLuPGUbgIZyhXirV~pRFaZH=\ngGTA@aJS\\D@FyFul{np=\ngGTA@aJS\\t@GTc]G]v=\ngGTA@aJS\\t@GTc]G]z\ngGTA@aJS\\t@GTc_Ciw]`=\ngGTA@aJS\\t@GTc_Ciw]d`XP=\ngGTA@aJS\\t@GTe\\cZv]wX=\ngGTA@aJS\\t@GTe\\cjz]wX=\ngGTA@erS\\t@GTe\\cZv]wX=\ngGTAAAJU\\t@GTE\\s^z^wo{P@=\ngGTAAAJU]R@GTE\\s^v]w_{P@=\ngGTAAAJU]R@GTE\\s^z]w_{P@=\ngGTAAIJTuMPGSCENRus`qS\\knBPtO{P@\ngGTAAQJSSUPGQbgI[kAHP\ngGTAAQJUSUPGUCENRyHXiK_HNBP`\ngGTBLQDSpTQ_AIkjTCiQs~tp\ngGTCLQDSpTQ_@}dTaihCiQKgIrV|oova@\ngGTD@UPZ`Rkjj@zHYImgQSfz`ZG}h@>\ngGTD@]PV`rRFUTAtPqSfz`TD>\ngGTDCPDZ`R[ij@zTlwPvm`\ngGTDEPDDHR[ff@zT\\`\ngGTDEPDDHR[ii@zTmWHvmg]v\ngGTDEaxSpRkjj`PzHTek]DMB<\ngGTDEaxSpRkjj`PzHTek]DMB>\ngGTDQMPV`Dr]uyJffXChabdnZFJ\\enmz~YB@\ngGTDcPDHHWFTfyi`NeGUt^wh\ngGTEIaxKpTiKSU@]FJSVs`qS]DMC~t`\ngGTH@]PYICJj@zhXisV~`TFa@>\ngGTH@]PYICJj@zhXisZ~`TFa@>\ngGTH@iPIMuP@]RMt]wX=\ngGTH@iPIMuP@]RMt^wh=\ngGTHAMPIUuP@]PMt]w_{P@=\ngGTHAMPIUuP@]PM}oG]w~t@=\ngGTHCPDILsS@]ZJ\\ytTenlD}@\ngGTHCPDILuH@]RUrM{Yw]`=\ngGTHCPDILuK@]JR[h[vp\ngGTHCPDILuK@]JRkd[vsn{@\ngGTHCPDILuK@]JRkd[vsn}@\ngGTHCQHILuK@]ZJ\\ytTy@\ngGTHCQxITuS@]DLeZnTGAN{t\ngGTHDPDIMtp@]RUrMkYw]`\ngGTHDPDIMtuSP]ZVZwpvmtH>\ngGTHE`DILsU@]FJRunbFaZH=\ngGTHE`DILsU@]FJRushis]DMC~tP\ngGTHE`DILsU@]FJRvnbFaZH\ngGTHE`DILsU@]FJRvshis]DMC~tP\ngGTHE`DIMtu@]FNRunbFaZX=\ngGTHE`DIMtu@]FNRushis]DMC~tp\ngGTHE`DIMtu@]FVRunQm[HZG}i`=\ngGTHHPxILuS@]FJ\\voa{Ah_vd@\ngGTHHPxILuS@]FJ\\voa{^h_vd@\ngGTHHaxITuUPH]TL]Ek_XICP`<\ngGTHHaxITuUPH]TL]Ek_XICP`>\ngGTHHaxYICJ`@z`[h{np=\ngGTH`iPBYrSWUTbGQcdm[hahP<\ngGTH`iPBYrSWUTbGQcdm[hahP>\ngGTHaMPB]rU\\t@GTC_[qw]m@=\ngGTHdPDCeJS]L@GTc]G]v\ngGTHe`DCeJS]MPGQcdm\\zJ\\wQCPmL\ngGTHe`DCeJS]MPGQcdmlzJ\\wQCPmL\ngGTICQHFTfZe`NmEN\\zJR`\ngGTICQxFTjZi`NbFRmWJC`gmz\ngGT`CPdfyi`NeGH\ngGT`CPdfyj`NeGH\ngGT`EPTfyi`NeGH\ngGT`EPTfyi`NeGN]EIP\ngGT`EPTfzZPNeKUrMkYw]`\ngGT`E`TfYjhhNmEM[ra@<\ngGT`LPdfyj`NmGM[raZX\ngGT`LPdfyj`NmGM[r~ZX\ngGT`LPdfyj`NmGMkraZX\ngGT`hPiJyInZ@CjQncn}ZP\ngGT`hPiJyInZXCiQu]G]w~t`\ngGT`hPiJyInZXCiQu]G]{~t`\ngGT`hPiJyInZdCiQu]G]w~t`\ngGT`hPiJyInZdCiQu]G]{~t`\ngGT`hPiJyInZdCiQu]Gmw~t`\ngGT`hPiJyInZdCiQu]Gm{~t`\ngGT`hPiJyInZdCkQsV|o_vd@\ngGT`hPiJyInZjYCkQsZ|h_vd@<\ngGT`hPiJyInZjYCkQsZ|h_vd@>\ngGT`i`iJyInZhChqrVmtPtO{JX=\ngGT`i`iJyInZhChqrVutPtO{JX\ngGTahPiJx|dwMRAthzncn}ZP\ngGTdLXaxWpRjvj@zPTwe|\ngGTdlX`DTHwF\\ddJu@]HN[h~oovf@\ngGTeI\\QxKpTiKSU@]JJ\\xLRmH\ngGTeLXaxWpOYIIZZ@zPRyr\\eoK{}hP\ngGThLX`DYIHUj@zp\\uoJG}i`\ngGThLX`DYIHUj@zp\\voJG}i`\ngGThLXaxIUMA@]JM[{[NzD\ngGThLXaxIUMA@]JM\\xLRwvv]tH\ngGThLXaxIUMA@]JMk{[NzD\ngGThLXaxIUMA@]JMlxLRwvv]tH\ngGThLXaxIU[U@]XJ[WeB\ngGThLXaxIU[U@]XJ[WeC~RQq@\ngGThLXaxYIHVj`Pzp\\voJG}i`<\ngGThLXaxYIHVj`Pzp\\voJG}i`>\ngGThMX`DYIHUj@zp\\foBG}i`\ngGThmX`D[kNRREZ`NlGIkpaZX\ngGTiCQePKdkjj`NlFJ[rA@\ngGTiCQePKdkjjhdNlFR\\xL\\wdB<\ngGTiLXaxGdjffhDNlFMkra@<\ngGTiLXaxGdjffhDNlFMkra@>\ngGU@CPdsMLAuhiu^XH\ngGU@CPdsMLAuhjs_XIw^`\ngGU@CPdsMLAuhju_XIw^`\ngGU@CPdsTlAtiJnQo[N{t\ngGU@DPdsMTAtXisVzpZG}h`\ngGU@DPdsMTAtXisVzp[{}h`\ngGU@DPdsMTAtXisWNbdmu`tO{Q@\ngGU@DPdsMTAtXisWNbgMu`tO{Q@\ngGU@DPdsMTAtXisZzpZG}h`\ngGU@DPdsMTAtXis[NbgMu`tO{Q@\ngGU@DPdsMTAtXiuVzpZG}h`\ngGU@DPdsMTAtXiuVzp[{}h`\ngGU@DPdsMTAtXiuWNbdmu`tO{Q@\ngGU@DPdsMTAtXiuWNbgMu`tO{Q@\ngGU@DPdsMTAtXiu[NbgMu`tO{Q@\ngGU@DPdsMTAuhjs_XIw]mD\ngGU@DPdsMTAuhjs_XIw^mD\ngGU@DPdsMTAuhjsgQRV~pSn}ZH\ngGU@DPdsMTAuhju_XIw^mD\ngGU@DPdsUUHauhjs_XIw]mD<\ngGU@DPdsUUHauhjs_XIw^mD<\ngGU@DPdsUUHauhjs_XIw^mD>\ngGU@DPdwM@AuHwQw]`\ngGU@DPdwM@AuHwQw^`\ngGU@DPdwM@AuHytTencn}@\ngGU@DPdwMLAthzncn{@\ngGU@DPdwMLAthzncn}@\ngGU@DPdwMLAuhyk]GmB\ngGU@DPdwMLAuhyk^TH\ngGU@DPdwMLAuhykgQRVzOZD\ngGU@DPdwMLAuhykgQRV|hP\ngGU@DPdwMLAuhykgQSf|hP\ngGU@DPdwMLAuhym^TH\ngGU@DPdwMLAuhymgQSf|hP\ngGU@DPdwMRAthzncn{@\ngGU@DPdwMRAthzncn}@\ngGU@DPdwMRAthzncv{@\ngGU@DPdwMRAthzncv}@\ngGU@DPdwMRAthzshiK]G]z\ngGU@DPdwMRAthzshiK]Gmz\ngGU@DPdwMRAthzshis]Gmv\ngGU@DPdwMRAuhyj\ngGU@DPdwMRAuhyk^Wh\ngGU@DPdwMRAuhykgQRT\ngGU@DPdwMRAuhykgQRV|oP\ngGU@DPdwMRAuhykgQSd\ngGU@DPdwMUMAuhyk^TH<\ngGU@DPdwMUMAuhyk^TH>\ngGU@DPdwMUMAuhyk^Wp<\ngGU@DPdwMUMAuhyk^Wp>\ngGU@DPdwMUMAuhykgQRV|hP<\ngGU@DPdwMUMAuhykgQRV|hP>\ngGU@DPdwMUMAuhykgQSf|hP<\ngGU@DPdwMUMAuhykgQSf|hP>\ngGU@DPdwMUMAuhym^TH<\ngGU@DPdwMUMAuhym^TH>\ngGU@DPdwS@AuHwQw]`\ngGU@DPdwS@AuIWHvmg]v\ngGU@DPdwSRAtiZnQm[N{t\ngGU@DPdwSUMAuhykgQSf|hP<\ngGU@DPdwSUMAuhykgQSf|hP>\ngGU@E`dsMTAtXiKVzHZG}h`=\ngGU@E`dsMTAtXiKVzH[{}h`\ngGU@E`dsMTAtXiKWNbdmtPww{Q@\ngGU@E`dsMTAtXiKWNbgMtPtO{Q@\ngGU@E`dsMTAtXiKWNbgMtPww{Q@\ngGU@E`dsMTAtXiKZzHZG}h`\ngGU@E`dsMTAtXiK[NbdmtPtO{Q@\ngGU@E`dsMTAtXiK[NbgMtPtO{Q@\ngGU@E`dsMTAtXiMZzHZG}h`=\ngGU@E`dsMTAthjshiK]G]{~tP\ngGU@E`dsMTAthjshis]Gm{~tP\ngGU@E`dwSTAtXyKVzHZG}i`=\ngGU@E`dwSTAtXyKWNbgMtPtO{S@\ngGU@E`dwSTAtXyK[NbgMtPtO{S@\ngGU@LPdmUTAuhik^TH\ngGU@h`NdiMtp@]RMt]w_{R@=\ngGUACPYRYjV@ztTynmt}@\ngGUADPYR[fi@zT]YtTencn}@\ngGUADPYR[fi@zT]YtTencv}@\ngGUADPYR[fjf`zt\\uoJD<\ngGUADPYR[fjf`zt\\uoJD>\ngGUADP^R[fi@zT]WQw^`\ngGUAE`iRYff@zLTekgQSfzOZG}h`\ngGUAE`iR[ij@zL\\ek]DMC~tp=\ngGUAE`iR[ij@zL\\fm]DMC~tp=\ngGUAIQIRZZj@zLTyKdqSdmu`dH\ngGUDLT@b^BSRuPGVbfmyPdd\\P\ngGUDLT@b^BSRuPGVbfuyP`\ngGUDLTHb^BSSPPGRSV~vsna@\ngGUDLTHb^BSSPPGRSZ~vsna@\ngGUHEjICHiCUPGRbT\ngGUHeaZCS^RYfj@ztTfshiK]DM}~tP\ngGX@@dmMTAuXirVm}`dMB\ngGX@@dmUTAuXirVm}`dMB\ngGX@@dmUTAuXirVnRFJ\\wvBPtH\ngGX@@dmUTAuXirVn\\FI[{AH[x\ngGX@@dmUTAuXirVn\\FJ[{AHZD\ngGX@@dmUTAuXirVu}`dMB\ngGX@@dmUTAuXirVv\\FI[{AHZD\ngGX@@dmUTAuXirZu}`dMB\ngGX@@dmUUDauXirVn\\FJ[{AH[x<\ngGX@@dmUUDauXirVn\\FJ[{AH[x>\ngGX@@dmUUDauXirVv\\FJ[{AHZD>\ngGX@@dsD@AnQo[N{l=\ngGX@@dsD@AnQo[N{t\ngGX@@dsD@AnQo[O[t=\ngGX@@dsD@AnQo]N{l=\ngGX@@dsD@AnQo]N{t\ngGX@@dsD@AnQo]O[t=\ngGX@@dsD@AnQw[N{l=\ngGX@@dsD@AnQw]N{l=\ngGX@@dsD@As`qK\\cnv]wh\ngGX@@dsD@AshiK\\c^z]wh\ngGX@@dsD@Ashis\\c^z^wh\ngGX@@dsDLAuEWHwng]z\ngGX@@dsDLAudek\\c^v^tH\ngGX@@dsDLAudek\\cnv^wp\ngGX@@dsDLAudek_C^wP`\ngGX@@dsDLAudem\\c^v^tH\ngGX@@dsDLAudemgAcfyG]l}hP\ngGX@@dsDLAudemgQRVyF}t}hP\ngGX@@dsM@AthynQwAN{l=\ngGX@@dsM@AthynQwAN{t\ngGX@@dsM@AthynQw^N{l=\ngGX@@dsM@AthyolD{np=\ngGX@@dsM@AthyolD{oP\ngGX@@dsM@AthyolD}oP=\ngGX@@dsM@Athyomx{np=\ngGX@@dsM@Athys`qK\\cnB]wh\ngGX@@dsM@Athys`qK_XIw^`\ngGX@@dsM@AthyshiK\\cnB]wh\ngGX@@dsM@AthyshiK_XIw^`\ngGX@@dsM@AthyshiK_[qw^`\ngGX@@dsM@Athyshis_XI{^`\ngGX@@dsM@AthznQwAN{l=\ngGX@@dsM@AthznQwAN{t\ngGX@@dsM@AthzolD{np=\ngGX@@dsM@AthzolD{oP\ngGX@@dsM@Athzs`qK\\cnB]wh\ngGX@@dsM@Athzs`qK_XIw^`\ngGX@@dsM@AthzshiK\\cnB]wh\ngGX@@dsM@AthzshiK_XIw^`\ngGX@@dsM@AuIWHwmg]v=\ngGX@@dsM@AuIWHwmg]z\ngGX@@dsM@AuIWHwmgmz=\ngGX@@dsM@AuIWHwng]v=\ngGX@@dsM@AuIWHwng]z\ngGX@@dsM@AuIWHwngmz=\ngGX@@dsM@AuIYtTenQo]N{t\ngGX@@dsMLAuXirVmu`tH\ngGX@@dsMLAuXirVm}`gmB\ngGX@@dsMLAuXirVn]EN[kAhP\ngGX@@dsMLAuXirVn]EN[{AOZD\ngGX@@dsMLAuXirVn]EN[{^OZD\ngGX@@dsMLAuXirVu}`gmB\ngGX@@dsMLAuXitVmrNxI{P`\ngGX@@dsMLAuXitVn\\FN[kAhP\ngGX@@dsMLAuhjs_XIw^`\ngGX@@dsMTAtYIKVyF}lahP\ngGX@@dsMTAtYIKVyF}tahP\ngGX@@dsMTAtYIM[IbgI[d[wRFa@\ngGX@@dsMTAuXirVmrNxICP`\ngGX@@dsMTAuXirVm}`dMB\ngGX@@dsMTAuXirVnSENRwH{`dMB\ngGX@@dsMTAuXirVnSENRwvBPtH\ngGX@@dsMUDauXirVn]EN[{AHZD<\ngGX@@dsMUDauXirVn]EN[{AHZD>\ngGX@@dsT`Athyncn{@=\ngGX@@dsT`Athyncn}@\ngGX@@dsT`Athyomt{np=\ngGX@@dsT`Athyomt{oP\ngGX@@dsT`Athys`qK]G]z\ngGX@@dsT`Athys`qK_[iw^`\ngGX@@dsT`AthyshiK_[iw^`\ngGX@@dsT`AuIWHwmg]v=\ngGX@@dsT`AuIWHwmg]z\ngGX@@dsT`AuIWHwmgmz=\ngGX@@dsT`AuIWHwng]v=\ngGX@@dsT`AuIWHwng]z\ngGX@@dsT`AuIWHwngmz=\ngGX@@dsT`AuIWH{mg]v=\ngGX@@dsT`AuIWH{mg]z\ngGX@@dsT`AuIWH{ng]v=\ngGX@@dsT`AuIWH{ng]z\ngGX@@dsT`AuIYpXenQw[N{t\ngGX@@dsT`AuIYpXenQw]N{t\ngGX@@dsT`AuIYtTenQo]N{t\ngGX@@dsT`AuIYtTenQw]N{t\ngGX@@dsTlAtYIKVyF}l}hP\ngGX@@dsTlAtYIKVyF}t}o`\ngGX@@dsTlAtYIKV~F}na@\ngGX@@dsTlAtYIKV~F}va@\ngGX@@dsTlAtYIKWNCGMrN{Y{P`\ngGX@@dsTlAtYIKZyF}l}hP\ngGX@@dsTlAtYIKZyF}t}hP\ngGX@@dsTlAtYIKZyG]l}hP\ngGX@@dsTlAtYIK[NCDm|N{]B\ngGX@@dsTlAtYIK[NCDm|N{mB\ngGX@@dsTlAtiJnQo]O[l\ngGX@@dsTlAtiJnQw]N{t\ngGX@@dsUAHathyolD{np+\ngGX@@dsUAHathyolD{np-\ngGX@@dsUAHathyolD{nrPJH+\ngGX@@dsUAHathyolD{nrPJH-\ngGX@@dsUAHathyolD{oP<\ngGX@@dsUAHathyolD{oP>\ngGX@@dsUAHathyolD}oP+\ngGX@@dsUAHathyolD}oP-\ngGX@@dsUAHathyomx{np+\ngGX@@dsUAHathyomx{np-\ngGX@@dsUAHathyomx{nrPJH+\ngGX@@dsUAHathyomx{nrPJH-\ngGX@@dsUAHathyomx{oP<\ngGX@@dsUAHathyomx{oP>\ngGX@@dsUAHathys`qK_XIw^`<\ngGX@@dsUAHathys`qK_XIw^`>\ngGX@@dsUAHathys`qK_[qw^`<\ngGX@@dsUAHathys`qK_[qw^`>\ngGX@@dsUAHathys`qs_XI{^`<\ngGX@@dsUAHathys`qs_XI{^`>\ngGX@@dsUAHathyshiK_XIw^`<\ngGX@@dsUAHathyshiK_XIw^`>\ngGX@@dsUAHathyshiK_[qw^`<\ngGX@@dsUAHathyshiK_[qw^`>\ngGX@@dsUAHathzolD{np+\ngGX@@dsUAHathzolD{np-\ngGX@@dsUAHathzolD{oP<\ngGX@@dsUAHathzolD{oP>\ngGX@@dsUAHathzolD}oP+\ngGX@@dsUAHathzolD}oP-\ngGX@@dsUAHathzs`qK_XIw^`<\ngGX@@dsUAHathzs`qK_XIw^`>\ngGX@@dsUAHathzs`qs_XI{^`<\ngGX@@dsUAHathzs`qs_XI{^`>\ngGX@@dsUMHauXirVmu`tH<\ngGX@@dsUMHauXirVmu`tH>\ngGX@@dsUMHauXirVm}`gmB<\ngGX@@dsUMHauXirVn\\FN[{AOZD<\ngGX@@dsUMHauXirVn\\FN[{AOZD>\ngGX@@dsUMHauXirVv\\FN[{AOZD>\ngGX@@dsUMHauXitVmu`tH>\ngGX@@dsUMHauXitVn\\FN[{AOZD<\ngGX@@dsUMHauXitVn\\FN[{AOZD>\ngGX@@dsUMHauhjs_XIw^`<\ngGX@@dsUMHauhjs_XIw^`>\ngGX@@dsUThdauXirVnRFJ\\wvBPtH>\ngGX@@dsUThdauXirVn\\FN[{AHZD<\ngGX@@dsUThdauXirVn\\FN[{AHZD>\ngGX@@dsUThdauXirVn]EN[{AHZD<\ngGX@@dsUThdauXirVn]EN[{AHZD>\ngGX@@dsUThdauXirVu}`dMB<\ngGX@@dsUThdauXirVu}`dMB>\ngGX@@dsUThdauXirVv]EN[{AHZD<\ngGX@@dsUThdauXirVv]EN[{AHZD>\ngGX@@dsUThdauXirVv]EN[{^HZD<\ngGX@@dsUThdauXitVn\\FN[{AHZD<\ngGX@@dsUThdauXitVn\\FN[{AHZD>\ngGX@@dsUThdauXitVu}`dMB<\ngGX@@dsUThdauXitVu}`dMB>\ngGX@@dsUTheAuXirVnRFJRwvBPwp<\ngGX@@dsUTheAuXirVnRFJRwvBPwp>\ngGX@@dsUTheAuXirVnRFJ\\wvBPtH<\ngGX@@dsUTheAuXirVnRFJ\\wvBPtH>\ngGX@@dsUTheAuXirVn\\FN[{AHZD<\ngGX@@dsUTheAuXirVn\\FN[{AHZD>\ngGX@@dsUTheAuXirVn]EN[{AHZD<\ngGX@@dsUTheAuXirVn]EN[{AHZD>\ngGX@@dsUTheAuXirVu}`dMB<\ngGX@@dsUTheAuXirVu}`dMB>\ngGX@@dsUTheAuXirVvZFJ\\eolDahP>\ngGX@@dsUTheAuXirVv]EI[{AHZD<\ngGX@@dsUTheAuXirVv]EN[{AHZD>\ngGX@@dsUTheAuXirZn]EI[{AH[x<\ngGX@@dsUTheAuXitVv\\FN[{AHZD<\ngGX@@dsUTheAuXitVv\\FN[{AHZD>\ngGX@@dsUTiDauXitVn\\FN[{AHZD<\ngGX@@dsUTiDauXitVn\\FN[{AHZD>\ngGX@@dsUTiDauXitVn]EN[{AHZD<\ngGX@@dsUUHauXirVm}`dMB<\ngGX@@dsUUHauXirVm}`dMB>\ngGX@@dsUUHauXirVm}oDMB<\ngGX@@dsUUHauXirVm}oDMB>\ngGX@@dsUUHauXirVnSENRwvBPtH>\ngGX@@dsUUHauXirVnZFJ\\eolDahP<\ngGX@@dsUUHauXirVnZFJ\\eolDahP>\ngGX@@dsUUHauXirVnZFJ\\eomxahP<\ngGX@@dsUUHauXirZu}`dMB<\ngGX@@dsUUHauXirZu}`dMB>\ngGX@@dsUUHauXitVm}`dMB<\ngGX@@dsUUHauXitVm}`dMB>\ngGX@@dsUUHauXitVnRFNRwvBPtH<\ngGX@@dsUUHauXitVnRFNRwvBPtH>\ngGX@@dtuRAuXirVmu`dH\ngGX@@dtuRAuXirVn\\FI[{AH[t\ngGX@@dtuSHauXirVn]EI[kAHP<\ngGX@@dtuSHauXirVn]EI[kAHP>\ngGX@@dtuSHauXirZn]EI[{AH[t>\ngGX@@dtuTAuXirVm}`dMB\ngGX@@dtuTAuXirVm}`dM|\ngGX@@dtuTAuXirVnSENRwvBPtH\ngGX@@dtuTAuXirVnSENRwvBPwp\ngGX@@dtuTAuXirVn\\FI[{AHZD\ngGX@@dtuTAuXirVn\\FI[{AH[x\ngGX@@dtuTAuXirVu}`dMB\ngGX@@dtuTAuXirVv\\FI[{AHZD\ngGX@@dtuUHauXirVm}`guB<\ngGX@@dtuUHauXirVm}`guB>\ngGX@@dtuUHauXirVnRFJRwvBPtH<\ngGX@@dtuUHauXirVnRFJRwvBPtH>\ngGX@@dtuUHauXirVn]EI[{AHZD<\ngGX@@dtuUHauXirVn]EI[{AHZD>\ngGX@@dtuUHauXirVn]EI[{AOjD<\ngGX@@dtuUHauXirVn]EI[{AOjD>\ngGX@@dtuUHauXirVn]GI[{AOjD<\ngGX@@dtuUHauXirVn]GI[{AOjD>\ngGX@@dtuUHauXirZm}`dMB<\ngGX@@dtuUHauXirZm}`dMB>\ngGX@@dtuUHauXirZn\\FI[{AHZD<\ngGX@@dtuUHauXirZn\\FI[{AHZD>\ngGX@@dtuUHauXirZn]EI[{AHZD<\ngGX@@dtuUHauXirZn]EI[{AHZD>\ngGX@@dwATAulek\\cZvPtH\ngGX@@dwATAulek\\cZvPtOyKDd\ngGX@@dwATAulek\\cZzPtH\ngGX@@dwATAulfm\\cZvPtH\ngGX@@dwAULaulekgQSfyFutahP<\ngGX@@dwAULaulekgQSfyFutahP>\ngGX@@dwAULaulem\\cZvPtH<\ngGX@@dwSTAtYYKVyFutahP\ngGX@@dwSTAtYYKVyGUlahP\ngGX@@dwSTAtYYMZyFulahP\ngGX@@dwSTAtYYMZyFutahP\ngGX@@dwSTAtYYMZyGUlahP\ngGX@@dwSTAuXirVmtPtH\ngGX@@dwSULatYYKWNbgMrMkiCP`<\ngGX@@dwSULatYYKWNbgMrMkiCP`>\ngGX@@dwSULatYYKWNbgMrNkiCP`>\ngGX@@dwSULatYYKZyFulahP<\ngGX@@dwSULatYYKZyFulahP>\ngGX@@dwSULauXirVn\\EN[hahP>\ngGX@@dwSULauXirVv]EN[y]HZD<\ngGX@@eMUTAtpqSdm[eApRFa@\ngGX@@eMUTAtpqSdm[eApRFaIHxv`@\ngGX@@eMUTAtpqSdm[eApRFaZ@\ngGX@@eMUTAtpqSdm[eApRF~Z@\ngGX@@eMUTAtpqSdm\\dLTynTGAHZG}h@\ngGX@@eMUTAtpqSdm\\xLTwJC`dMB\ngGX@@eMUTAtpqSdm\\xLTwJC`dMC~t@\ngGX@@eMUTAtpqSdm\\xLTwJ}`dMB\ngGX@@eMUTAtpqSdmkeApRFa@\ngGX@@eMUTAtpqSdmkeApRFaZ@\ngGX@@eMUTAtpqSdmlxLRwJC`dMC~t@\ngGX@@eMUTAtpqSdukeApRFaZ@\ngGX@@eMUTAtpqSdulxLTwJC`dMC~t@\ngGX@@eMUTAtpqShukeApRFa@\ngGX@@eMUTAtpqShukeApRFaZ@\ngGX@@eMUTAtpqUdm[eApRFa@\ngGX@@eMUTAtpqUdm[eApRFaZ@\ngGX@@eMUTAtpqUdm\\xLTwJC`dMB\ngGX@@eMUTAtpqUdm\\xLTwJC`dMC~t@\ngGX@@eMUTAtpqUdmkeApRFaZ@\ngGX@@eMUUHatpqSdu[eApRF~Z@<\ngGX@@eMUUHatpqSdu[eApRF~Z@>\ngGX@@eSU@AuAWJwmg]w~t@=\ngGX@@eSU@AuAWJwmg]{~t@=\ngGX@@eSU@AuAWJwmgm{~t@=\ngGX@@eSU@AuAWJwng]w~t@=\ngGX@@eSU@AuAWJwng]{~t@\ngGX@@eSU@AuAWJwngm{~t@=\ngGX@@eSU@AuAWJ{ng]w~t@=\ngGX@@eSU@AuAWJ{ng]{~t@=\ngGX@@eSU@AuAWJ{ngm{~t@=\ngGX@@eSU@AuAYpTenUo]N{w}h@\ngGX@@eSU@AuAYpXenUw]N{w}h@\ngGX@@eSU@Au`is\\hNB]w_yJEFt@=\ngGX@@eSU@Au`is\\hNB]w_{P@=\ngGX@@eSU@Au`is\\hNB]wh\ngGX@@eSU@Au`is\\hNB]woyJEFt@=\ngGX@@eSU@Au`is\\hNB]wo{P@=\ngGX@@eSU@Au`is\\hNB^wh=\ngGX@@eSU@Au`is\\hNB^wo{P@=\ngGX@@eSU@Au`is\\hN|]w_yJEFt@=\ngGX@@eSU@Au`is\\hN|]w_{P@=\ngGX@@eSU@Au`is\\hN|]wo{P@\ngGX@@eSU@Au`is\\hN|^wo{P@=\ngGX@@eSU@Au`isfabgI[eApSv}@=\ngGX@@eSU@Au`isfabgI[eApSv}Z@=\ngGX@@eSU@Au`isgARVyP]x{o_v`@\ngGX@@eSU@Au`isgAbVyP\\D{o_v`@\ngGX@@eSU@Au`isgAcfyP\\D}o_v`@\ngGX@@eSU@Au`iu\\hNB]w_{P@=\ngGX@@eSU@Au`iu\\hNB]wo{P@\ngGX@@eSU@Au`iu\\hNB^wo{P@=\ngGX@@eSU@Au`iugARVyP\\D{o_v`@\ngGX@@eSU@Au`iugAbVyP\\D{o_v`@\ngGX@@eSU@Au`js\\hN|]w_{P@=\ngGX@@eSU@Au`ju\\hNB]w_{P@=\ngGX@@eSU@Au`ju\\hNB]wh\ngGX@@eSU@Au`ju\\hNB]wo{P@=\ngGX@@eSU@Au`ju\\hNB^wh=\ngGX@@eSU@Au`ju\\hNB^wo{P@=\ngGX@@eSU@Au`jufabgI[eApSv}@=\ngGX@@eSU@Au`jugAbVyP\\D{o_v`@\ngGX@@eSU@Au`jugAcfyP\\D}o_v`@\ngGX@@eSUA@au`is\\hN|^wh-\ngGX@@eSUA@au`isgARVyP]x{oP<\ngGX@@eSUA@au`isgARVyP]x{oP>\ngGX@@eSUA@au`isgAbVyP\\D{oP<\ngGX@@eSUA@au`isgAbVyP\\D{oP>\ngGX@@eSUA@au`isgAcfyP\\D}oP<\ngGX@@eSUA@au`isgAcfyP\\D}oP>\ngGX@@eSUA@au`iugARVyP\\D{oP<\ngGX@@eSUA@au`iugARVyP\\D{oP>\ngGX@@eSUA@au`iugASfyP\\D}oP<\ngGX@@eSUA@au`iugASfyP\\D}oP>\ngGX@@eSUA@au`jugAbVyP\\D{oP<\ngGX@@eSUA@au`jugAbVyP\\D{oP>\ngGX@@eSULAtPrSfyP\\D}o_v`@=\ngGX@@eSULAtaRnUw]N{w}h@=\ngGX@@eSULAtpqSdm[eApSvaZ@=\ngGX@@eSULAtpqSdm[yApZG}h@=\ngGX@@eSULAtpqSdm[yAwjG}h@\ngGX@@eSULAtpqSdm\\dLTenTGAOZG}h@=\ngGX@@eSULAtpqSdm\\tLTyK_HNCPm@=\ngGX@@eSULAtpqSdm\\xLRwJC`gmC~t@\ngGX@@eSULAtpqSdm\\xLRwrC`tO{P@\ngGX@@eSULAtpqSdm\\xL\\wJC`gmC~t@\ngGX@@eSULAtpqSdm\\xL\\wrC`tO{P@\ngGX@@eSULAtpqSdmkeApSvaZ@=\ngGX@@eSULAtpqSdmkyApZG}h@=\ngGX@@eSULAtpqSdmltLTyK\\hNB^tO{P@=\ngGX@@eSULAtpqSdmlxL\\wJC`gmC~t@\ngGX@@eSULAtpqSdmlxL\\wrC`tO{P@\ngGX@@eSULAtpqShm[yApZG}h@\ngGX@@eSULAtpqShm\\xL\\wJC`gmC~t@\ngGX@@eSULAtpqShm\\xL\\wrC`tO{P@\ngGX@@eSULAtpqShmkeApSvaZ@\ngGX@@eSULAtpqShmkyApZG}h@\ngGX@@eSULAtpqShmlxL\\wJC`gmC~t@\ngGX@@eSULAtpqShmlxL\\wrC`tO{P@\ngGX@@eSULAtpqUdm\\xJ\\wJCoGmC~t@\ngGX@@eSUTAtQQKVyV}lah_v`@=\ngGX@@eSUTAtQQKVyV}tah_v`@\ngGX@@eSUTAtQQKVyW]tah_v`@=\ngGX@@eSUTAtpqSdm[eApRFa@\ngGX@@eSUTAtpqSdm[eApRFaIPhv`@=\ngGX@@eSUTAtpqSdm[eApRFaIXdv`@=\ngGX@@eSUTAtpqSdm[eApRFaZ@=\ngGX@@eSUTAtpqSdm[eAwbFaZ@\ngGX@@eSUTAtpqSdm\\dL\\enTGAHZG}h@\ngGX@@eSUTAtpqSdm\\tLTyK\\hNBPtH\ngGX@@eSUTAtpqSdm\\tLTyK\\hNBPtO{P@=\ngGX@@eSUTAtpqSdukeApRFa@\ngGX@@eSUTAtpqSdukeApRFaZ@=\ngGX@@eSUTAtpqShm[eApRFaZ@\ngGX@@eSUTAtpqShm\\dL\\enTGAHZG}h@\ngGX@@eSUT`hatpqSdm\\dL\\enTGAH[x>\ngGX@@eSUT`hatpqSdm\\xLRwJC`dM|>\ngGX@@eSUT`hatpqSdm\\xL\\wJC`dMB<\ngGX@@eSUT`hatpqSdm\\xL\\wJC`dMB>\ngGX@@eSUT`hatpqSdmlxL\\wJC`dMB<\ngGX@@eSUT`hatpqSdmlxL\\wJC`dMB>\ngGX@@eSUT`hatpqSdulxL\\wJC`dMB<\ngGX@@eSUT`hatpqSdulxL\\wJC`dMB>\ngGX@@eSUT`hatpqShm\\xJ\\wJC`dMB>\ngGX@@eSUT`hatpqShmlxJ\\wJC`dMB<\ngGX@@eSUT`iAtpqSdm\\xL\\wJC`dMB<\ngGX@@eSUT`iAtpqSdm\\xL\\wJC`dMB>\ngGX@@eSUT`iAtpqSdmldL\\enTGAHZD>\ngGX@@eSUT`iAtpqSdmlxLRwJC`dMB<\ngGX@@eSUT`iAtpqSdmlxLRwJC`dMB>\ngGX@@eSUT`iAtpqSdmlxL\\wJC`dMB<\ngGX@@eSUT`iAtpqSdu\\xLRwJC`dM|<\ngGX@@eSUT`iAtpqSdu\\xLRwJC`dM|>\ngGX@@eSUT`iAtpqShm\\xJ\\wJC`dMB<\ngGX@@eSUU@atpqSdm\\dL\\enTGAHZD<\ngGX@@eSUU@atpqSdm\\dL\\enTGAHZD>\ngGX@@eSUU@atpqShm[eApRFa@<\ngGX@@eSUU@atpqShm[eApRFa@>\ngGX@@eSUUHatQQKWNCGMrn{iCPm@<\ngGX@@eSUUHatQQKZyV}lah_v`@+\ngGX@@eSUUHatpqSdm[eApRF~Z@+\ngGX@@eSUUHatpqSdm[eApRF~Z@-\ngGX@@eSUUHatpqSdm\\dLTynTGAHZD<\ngGX@@eSUUHatpqSdm\\dLTynTGAHZD>\ngGX@@eSUUHatpqSdm\\dL\\enTGAH[{}h@<\ngGX@@eSUUHatpqSdm\\tLTyK\\hNBPwp<\ngGX@@eSUUHatpqSdm\\tLTyK\\hNBPwp>\ngGX@@eSUUHatpqSdm\\xJ\\wJCoDMC~t@<\ngGX@@eSUUHatpqSdm\\xJ\\wJCoDMC~t@>\ngGX@@eSUUHatpqSdm\\xLRwJC`dM}~t@<\ngGX@@eSUUHatpqSdm\\xLRwJC`dM}~t@>\ngGX@@eSUUHatpqSdm\\xL\\wJC`dMC~t@<\ngGX@@eSUUHatpqSdm\\xL\\wJC`dMC~t@>\ngGX@@eSUUHatpqSdm\\xL\\wJC`dM}~t@<\ngGX@@eSUUHatpqSdmkeApRFa@<\ngGX@@eSUUHatpqSdmkeApRFa@>\ngGX@@eSUUHatpqSdmkeApRFaZ@+\ngGX@@eSUUHatpqSdmkeApRFaZ@-\ngGX@@eSUUHatpqSdmldLTynTGAHZD<\ngGX@@eSUUHatpqSdmldLTynTGAHZD>\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtH<\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtH>\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtO{P@+\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtO{P@-\ngGX@@eSUUHatpqSdmlxLRwJC`dMC~t@<\ngGX@@eSUUHatpqSdmlxLRwJC`dMC~t@>\ngGX@@eSUUHatpqSdmlxL\\wJC`dMC~t@<\ngGX@@eSUUHatpqSdmlxL\\wJC`dMC~t@>\ngGX@@eSUUHatpqSdu\\tLTyK\\hNBPwp>\ngGX@@eSUUHatpqSdu\\xLRwJC`dM}~t@<\ngGX@@eSUUHatpqSdulxL\\wJC`dMC~t@>\ngGX@@eSUUHatpqShm\\xJ\\wJC`dMC~t@<\ngGX@@eSUUHatpqShm\\xJ\\wJC`dMC~t@>\ngGX@@eSUUHatpqShm\\xL\\wJC`dMC~t@<\ngGX@@eSUUHatpqShm\\xL\\wJC`dMC~t@>\ngGX@@eSUUHatpqShmkeApRFaZ@>\ngGX@@eSUUHatpqShmlxJ\\wJC`dMC~t@<\ngGX@@eSUUHatpqShmlxJ\\wJC`dMC~t@>\ngGX@@eSUUHatpqShmlxLRwJC`dMC~t@<\ngGX@@eSUUHatpqShmlxLRwJC`dMC~t@>\ngGX@@eSUUHatpqShmlxL\\wJC`dMC~t@<\ngGX@@eSUUHatpqShmlxL\\wJC`dMC~t@>\ngGX@@eSUUHatpqShulxL\\wJC`dMC~t@<\ngGX@@eSUUHatpqShulxL\\wJC`dMC~t@>\ngGX@@e]MTAtpqSdm[f]pRFaZ@\ngGX@@e]MTAtpqSdm[{AHZG}h@\ngGX@@e]MTAtpqSdm\\xLTwL{`dMC~t@\ngGX@@e]MTAtpqSdmk{AHZG}h@\ngGX@`IWITtp@]PUrm{Y{^m@=\ngGX@`IWITtp@]PUrm{i{^m@=\ngGX@`IWITtp@]XJ\\wvB^wo{P@=\ngGX@`NtiMtu@]FVSVnQm[HZD\ngGXA@IRVjj@zlTyKV~pRFa@\ngGXA@IRVjj@zlTyKWICEN[{AHZD\ngGXA@IRVjj@zlTyKWNCEM}`dMB\ngGXA@IRYb@@wH{mg]v=\ngGXA@IRYb@@wH{ng]v=\ngGXA@IRYb@@ypXenQw[N{t\ngGXA@IRYb@@ypXynQw[O[t\ngGXA@IRYb@@ypXynQw]O[t\ngGXA@IRYf`@zT\\wH{`g]v=\ngGXA@IRYf`@zdkd[vsn{@=\ngGXA@IRYjP@zdkd[vsn{@=\ngGXA@IRYjP@zdkd[wSn{@=\ngGXA@IRYjP@zdkd]vsn{@=\ngGXA@IRYjP@zdkd]wSn{@=\ngGXA@IRYj`dPzT\\wvB]wX+\ngGXA@IRYj`dPzT\\wvB]wX-\ngGXA@IRYj`dPzT\\wvB]wh<\ngGXA@IRYj`dPzT\\wvB]wh>\ngGXA@IRYj`dPzT\\ypXeolD{oP<\ngGXA@IRYj`dPzT\\ypXeolD{oP>\ngGXA@IRYj`dPzT]WvB]wX+\ngGXA@IRYj`dPzT]WvB]wX-\ngGXA@IRYjfdPzlTzKWNCGM}`gmB<\ngGXA@IRYjfdPzlTzKWNCGM}`gmB>\ngGXA@IRYjjTR`zlTyKWNCGM}`dMB>\ngGXA@IRYjjdPzlTyKV~pRFa@<\ngGXA@IRYjjdPzlTyKV~pRFa@>\ngGXA@IRZZi@zlTyKWNCDm}`dMz\ngGXA@IRZZj@zlTyKV~pRFa@\ngGXA@IRZZj@zlTyKV~pRF~@\ngGXA@IRZZj@zlTyKWIbgI[d^pRF~@\ngGXA@IRZZj@zlTyKWIbgI[{AHZD\ngGXA@IRZZj@zlTyKWNCDm}`dMB\ngGXA@IRZZjdPzlTyKWICEI[{AHZD<\ngGXA@IRZZjdPzlTyKWICEI[{AHZD>\ngGXA@IRZZjdPzlTyKWNbdm}`dMB<\ngGXA@IRZZjdPzlTyKWNbdm}`dMB>\ngGXA@IRfjj@zXXirVmr`xICP`\ngGXA@IRfjj@zXXirVn\\FJ[e^pRFa@\ngGXA@IRih@@wJwmg]w~t@=\ngGXA@IRih@@wJwng]w~t@=\ngGXA@IRih@@wJ{ng]w~t@=\ngGXA@IRihF@ztRunUo[OZG}h@=\ngGXA@IRii`@z`ke[vsn{Z@=\ngGXA@IRii`@z`ke[vsn}Z@\ngGXA@IRii`@z`ke[vsv}Z@=\ngGXA@IRii`@z`ke]vsv}Z@=\ngGXA@IRii`@z`ke]wSn{Z@=\ngGXA@IRii`@z`ke]wSv}Z@=\ngGXA@IRii`@zpTynUwAN{o}h@=\ngGXA@IRii`@zpTynUwAO[w}h@=\ngGXA@IRii`@zpTynUw^O[w}h@=\ngGXA@IRii`@zpTyolD{o_v`@\ngGXA@IRii`@zpTyolD}o_v`@=\ngGXA@IRii`@zpTznUwAN{o}h@=\ngGXA@IRij`@zpTynTGAN{l=\ngGXA@IRij`@zpTynTGAN{t\ngGXA@IRijj@zXXirVmr`xICP`\ngGXA@IRijj@zXXirVnZFJ\\enTGAHZD\ngGXA@IRijjPTPzXXirVn\\FN[eApRFa@<\ngGXA@IRijjPT`zXXirVn\\FN[eApRFa@>\ngGXA@IRijjdPzXXirVnRFJ\\wJC`dMB<\ngGXA@IRijjdPzXXirVur`xICP`>\ngGXA@IRjZj@zXXirVmr`xICP`\ngGXA@IRjZj@zXXirVnRFJRwJC`dMB\ngGXA@IRjZj@zXXirVnRFJRwJC`dM|\ngGXA@IRjZj@zXXirVn\\FI[eApRFa@\ngGXA@IRjZj@zXXirVur`xICP`\ngGXA@IRjZj@zXXirVv\\FI[eApRFa@\ngGXA@IRkfj@zHdek\\s^vPtO{P@\ngGXA@IRkfj@zHdek\\s^zPtO{P@\ngGXA@IRkfj@zHdek\\snvPtO{P@\ngGXA@IRkfj@zHdek\\snzPtO{P@\ngGXA@IRkfj@zXXirVmsNxICPm@\ngGXA@IRkfj@zXXirVm}`dMC~t@\ngGXA@IRnfj@zXXirVn\\FJ[f]pRFaZ@\ngGXA@NRYjP@zdkd[vsn{@=\ngGXA@NRYjP@zdkd[wSn{@=\ngGXA@NRYjV@zLdem\\c^v^tH\ngGXA@NRZZj@zlTyKWIbgI[{AHZD\ngGXAAiR[ij@zLlemgARVyGUlahP>\ngGXAAiR[ij@zLlemgARVyGUtahP>\ngGXAAiR[ij@zLlfkgASfyGUlao`>\ngGXAAiR[ij@zLlfm\\cZvPtH\ngGXAAiR[ij@zLlfm\\cZzPtH\ngGXAAiR[ij@zLlfmgASfyGUlahP>\ngGXAAiR[ij@zLlfmgASfyGUtahP>\ngGXD@jCTBUMT@GTC]G]w~t@=\ngGXDAjBtFRPrj`NjFJ\\eohEAHP>\ngGXDD@`aBS]MHGRejyFul{np\ngGXDD@`aBS]MHGRejyFul{oP\ngGXDD@b^BSRuPGUbgQjwvBPtO{Q@\ngGXDH@aABS]T@GTc\\cr|]w_{R@=\ngGXDH@aABS]T@GTc\\cr|]wo{R@=\ngGXDHGANBS]T@GTc\\cr|^wh=\ngGXDHGANBS]T@GTc\\cr|^woyHFD=\ngGXDHHQPbS]T@GTc]Gmz=\ngGXDHHQPbS]T@GTc]Gm{~RAa@=\ngGXDHO@~BUMUTbGUCEVjwrC`tH<\ngGXDHO@~BUMUTbGUCEVjwrC`tH>\ngGXDHOANBRtuPGUbgIZwvBPtO{R@\ngGXDHOA^BS]T@GTc]G]w~RAamH=\ngGXDHOA^BS]T@GTc]G]w~t`=\ngGXDHOA^BS]T@GTc]Gmz=\ngGXDHOA^BS]T@GTc]Gm{~RAa@=\ngGXDHOA^BS]UPGQcdm[d^WbFaI@pvd@=\ngGXDJDR^BSRuPGQbgI[kAHP\ngGXDJIARBSWUPGVcdmx_@\ngGXDL@aABS\\uPGQcdm[hah_vf@=\ngGXDL@bABUuUTRGQBdm\\dLTynbFa@<\ngGXDL@bABUuUTRGQBdm\\dLTynbFa@>\ngGXEHOA^BeIZZhCjqShuk{AHZG}i@\ngGXEHOA^DeInZ@CjQoat}o_rPLMi@=\ngGXEL@aAByInZhChqrVmtPtO{S@=\ngGXEaJAT@f\\nRfjj@zhXzMZyWlDahP\ngGXHAJAIfj@CiQs_XIw]`+\ngGXHAJAIfj@CiQs_XI{^`+\ngGXHAJAIfj@CiQu_XIw]`+\ngGXHAJAIfj@CiQu_XI{^`+\ngGXHAJAIfj@CiQugAbV~pSn}@>\ngGXHAJAIfj@CiQugAcf~pSv}@>\ngGXHAJAIfjXCkQUkNCGM}`gmv>\ngGXHAJAIfjhCjqSdm\\fJ\\eolDahP>\ngGXHAjAJfj@CiAS\\hN|]w_{P@=\ngGXHAjAJfj@CiAS\\hN|^wo{P@=\ngGXHAjAJfj@CiAS_HIw]m@=\ngGXHAjAJfj@CiAS_HI{^m@=\ngGXHAjAJfj@CiAU_HIw]m@=\ngGXHAjAJfjBACiAS_HI{^`+\ngGXHAjAJfjBACiAS_HI{^`-\ngGXHAjAJfjBACiAU_HI{^`+\ngGXHAjAJfjBACiAU_HI{^`-\ngGXHAjAJfjXCjabhmlxJ\\wrCoTO{P@\ngGXHAjAJfjjACjabdm[yAHZD<\ngGXHAjAJfjjACjabdm[yAHZD>\ngGXHAjCIHYUPGSCENRunXEAHZD\ngGXHAjCIHYUPGSCENRusPqSdms@hICPm@=\ngGXHB@aIfi@CjRnQo[N{l\ngGXHB@aIfi@CjRnQo[N{t\ngGXHB@aIfi@CjRnQo]N{l\ngGXHB@aIfiXCiRU\\c^v]wh\ngGXHB@aIfiXCkRSV~F}na@\ngGXHB@aIfidCiRU\\c^v^wX\ngGXHB@aIfidCiRU\\c^v^wh\ngGXHB@aIfidCkRSV~F}n}@\ngGXHB@aIfjBQCiQsgAbV~pSn}@>\ngGXHB@aIfjiQJChqSfn]EN[kAhP<\ngGXHB@aInfjZCkRsV~Funa@<\ngGXHB@aInfjZCkRsV~Funa@>\ngGXHBOAJfj@CkAUjyP\\D{np\ngGXHBOAJfjdCjabgM\\dLTeodGAoP\ngGXHD@aIfZhCjqSdm[{AHZG}h`=\ngGXHD@aIfZhCjqSdm\\zJ\\wvBPtO{Q@\ngGXHD@aIfZhCjqShm[{AHZG}h`=\ngGXHD@aIfZhCjqShm\\zJ\\wvBPtO{Q@\ngGXHD@aIfZhCjqShmk{AHZG}h`\ngGXHD@aIfihChrRVmrM{YCPmD=\ngGXHD@aIfihChrRVmrM{iCP`=\ngGXHD@aIfihChrRZurM{YCPmD=\ngGXHD@aIfihCiRU\\c^v]w_{Q@=\ngGXHD@aIfjjQCjqShmlxL\\wvBPtO{Q@>\ngGXHD@aIkjjQChqrVn\\gI[hahP<\ngGXHD@aIkjjQChqrVn\\gI[hahP>\ngGXHD@aInZ@CjQncn{@=\ngGXHD@aInZ@CjQncn}@\ngGXHD@aInZ@CjQshiK]G]z\ngGXHD@aInZXChqrVmt^tH\ngGXHD@aInZXChqrVmyP`\ngGXHD@aInZhChqrVmtPtH\ngGXHD@aInf@CjQncn{@=\ngGXHD@aInf@CjQncn}@\ngGXHD@aInf@CjRnQm[N{l=\ngGXHD@aInf@CjRnQm[N{t\ngGXHD@aInf@CjRnQm[O[t=\ngGXHD@aInf@CjRshiK\\cZz]wh\ngGXHD@aInfXChrrVm|Mk]B\ngGXHD@aInfXCiRu\\cZv^wh\ngGXHD@aInjBQCjQncn{@+\ngGXHD@aInjBQCjQncn{@-\ngGXHD@aInjBQCjQncn}@>\ngGXHDDQInf@CjRnQm[N{l=\ngGXHDOAInjBQCjQoax{np+\ngGXHDOAInjBQCjQoax{np-\ngGXHH@aIZjhCjqSdm[d^pRFaZP\ngGXHH@aIZjhCjqSdmk{AHZG}i@\ngGXHH@aIfj@CiQs\\cvB]w_{R@=\ngGXHH@aIfj@CiQs\\cvB]wo{R@\ngGXHH@aIfj@CiQsgAbVyGlD{o_vd@\ngGXHH@aIfj@CiQsgQRVyGlD{o_vd@\ngGXHH@aIfj@CiQsgQSfyGlD}o_vd@\ngGXHH@aIfj@CiQu\\cvB]w_{R@=\ngGXHH@aIfjXCjqSdm[d^pSvaZP\ngGXHH@aIfjXCjqSdm\\xL\\wH}`gmC~t`\ngGXHH@aIfjXCjqSdmlzJ\\wp}`tO{R@\ngGXHH@aIfjXCkQUgNCDmrOXI{^mH\ngGXHH@aIfjXCkQUgNbgMrOXI{^mH\ngGXHH@aIfjhCjqSdm[d^pRFaZP\ngGXHH@aIfjhCjqSdm[{AHZG}i@\ngGXHH@aIfjhCjqSdm\\fJ\\enQ{AHZG}i@\ngGXHH@aIfjjICjqSdm\\zJ\\wH}`dMC~t`<\ngGXHH@aIfjjICjqSdm\\zJ\\wH}`dMC~t`>\ngGXHH@aIfjjICjqSdmlzJRwH}`dMC~t`>\ngGXHH@aIfjjICjqSdmlzJ\\wH}`dMC~t`<\ngGXHH@aIfjjICjqSdmlzJ\\wH}`dMC~t`>\ngGXHH@aIfjjICjqSdulzJ\\wH}`dMC~t`>\ngGXHH@aIfjjICjqShm\\zJ\\wH}`dMC~t`<\ngGXHH@aIfjjICjqShm\\zJ\\wH}`dMC~t`>\ngGXHH@aJnZBACiAu_XIw]`+\ngGXHH@aJnZBACiAu_XIw]`-\ngGXHHGAIfj@CiQs\\cvB]w_{R@=\ngGXHHGAIfj@CiQs\\cvB^wo{R@=\ngGXHHGAIfj@CiQs_XI{^mH=\ngGXHHGAIfjXCjqShm\\xLRwp}`tO{R@\ngGXHHGAIfjXCjqShm\\xL\\wVCPmH\ngGXHHGAIfjXCjqShm\\xL\\wp}`tO{R@\ngGXHHGAIfjhCjqSdm[d^pRFaZP\ngGXHHGAIfjhCjqSdm[{AHZG|dBcZP\ngGXHHOAIZZhCjqSdm[{AHZG}i@\ngGXHHOAIZjhCjqSdm[d^pRFaZP\ngGXHHOAIZjhCjqSdm[{AHZD\ngGXHHOAIfj@CiQs\\cvB]w_{R@=\ngGXHHOAIfj@CiQs\\cvB^wo{R@=\ngGXHHOAIfj@CiQs_XIw]mH=\ngGXHHOAIfj@CiQs_XI{^mH=\ngGXHHOAIfjBQCiQs_XI{^`+\ngGXHHOAIfjBQCiQs_XI{^`-\ngGXHHOAIfjhCjqSdm[d^pRFaZP\ngGXHHOAIfjhCjqSdm[{AHZG}i@\ngGXHHOAIfjjICjqSdmkd^pRFaZP<\ngGXHHOAIfjjQCjqSdm[{AHZD<\ngGXHHOAIfjjQCjqSdm[{AHZD>\ngGXHHOAJkZhCjaSdm[f]pRFa@\ngGXHHOAJkZhCjaSdm[{AHZD\ngGXHHOAJnjBACiAu_XIw]`+\ngGXHHOAJnjBACiAu_XIw]`-\ngGXHHOAJnjjACjaSdm[{AHZD<\ngGXHHOAJnjjACjaSdm[{AHZD>\ngGXHL@aJZjhCjabdm[yAHZD\ngGXH`Z@R^RjZj@zhXisV~P\\Fa@\ngGXH`Z@R^RjZj@zhXisWICEI[yApZD\ngGXHaJ@SNRYj`@zT]WvB^wh+\ngGXHaJ@SNRZZj@zlTyKV~pRFa@\ngGXHaJ@SNRZZjdPzlTyMV~pRFa@<\ngGXHaJ@SNRZZjdPzlTyMV~pRFa@>\ngGXHaj@SnRii`@zPTwJ{oG]w~t@=\ngGXHaj@SnRii`@zPTwJ{oGm{~t@=\ngGXHaj@SnRii`@zPTwv|]w_{P@=\ngGXHaj@SnRii`@zPTwv|]wo{P@\ngGXHaj@SnRii`@zPTwv|^wo{P@=\ngGXHaj@SnRii`@zPTypTeomx{o_v`@\ngGXHaj@SnRkfj@zhXiKVyg]xah_rPJMh@\ngGXHaj@SnRkfj@zhXiKV~wbFaZ@\ngGXHhG@]IR[ij@zlTyKV~WRFaI@pvd@\ngGXI@Z@ReTuTAuPqSfm|`xMB\ngGXIAjC\\eSU@At`inTG^N{o}h@=\ngGXIDHaRdmUTAuXirVm}`dMB\ngGXIHDPReWU@At`zolD{np+\ngGXIHO@ReUuTAuPirVm}`dMB\ngGXIHOBRdmMTAuXirVm}`dMC~t`\ngGXIHOBRdsMTAuXirVm}`dMC~t`\ngGXLJIARFdLbdMU@]JIP\ngGX`BDdwM@AuHwQw]`\ngGX`BDdwM@AuHwQw^`\ngGX`BDdwMLAthzncn{@\ngGX`BDdwMLAthzncn}@\ngGX`BDdwMLAuhyk]GmB\ngGX`BDdwMLAuhyk^TH\ngGX`BDdwMLAuhym]GmB\ngGX`BDdwMLAuhym^TH\ngGX`BDdwMRAthzncn{@\ngGX`BDdwMRAthzncn}@\ngGX`BDdwMRAthzncv{@\ngGX`BDdwMRAthzncv}@\ngGX`BDdwMRAthzshiK]Gmz\ngGX`BDdwMRAuhyj\ngGX`BDdwMRAuhyk^Wh\ngGX`BDdwMRAuhykgQRT\ngGX`BDdwMRAuhykgQRV|oP\ngGX`BDdwMUMAuhyk^TH<\ngGX`BDdwMUMAuhyk^TH>\ngGX`BDdwMUMAuhyk^Wp<\ngGX`BDdwMUMAuhyk^Wp>\ngGX`BDdwMUMAuhykgQRV|hP>\ngGX`BDdwMUMAuhykgQSf|hP<\ngGX`BDdwMUMAuhykgQSf|hP>\ngGX`BDdwMUMAuhym^TH<\ngGX`BDdwMUMAuhym^TH>\ngGX`BDdwULAuhykdabdmyP`\ngGX`BDdwUThlauhykgARV|hP>\ngGX`BDdwUThmAuhykgARV|hP<\ngGX`DBdsMTAtXisVzpZG}h`\ngGX`DBdsMTAtXisWNbdmu`tO{Q@\ngGX`DBdsMTAtXiuVzpZG}h`\ngGX`DBdsMTAtXiuWNbdmu`tO{Q@\ngGX`DBdsMTAtXiuZzpZG}h`\ngGX`DBdwMLAuhyk^TH\ngGX`DBdwMLAuhym^TH\ngGX`DBdwMRAthzncn{@\ngGX`DBdwMRAthzncn}@\ngGX`DBdwMRAthzshiK]G]z\ngGX`DBdwMRAuhyj\ngGX`DBdwMRAuhykgQRT\ngGX`DBdwMRAuhykgQRV|oP\ngGX`DBdwMUMAuhyk^TH<\ngGX`DBdwMUMAuhyk^TH>\ngGX`DBdwMUMAuhykgQRV|hP<\ngGX`DBdwMUMAuhykgQRV|hP>\ngGX`DBdwMUMAuhykgQSf|hP>\ngGX`DBdwMUMAuhym^TH<\ngGX`DBdwMUMAuhym^TH>\ngGX`DBdwSRAtiZnQm[N{l\ngGX`DBdwUThmAuhykgARV|hP<\ngGX`DBdwUThmAuhykgARV|hP>\ngGX`JDduuTAuhyK^DH\ngGX`JDduuTAuhyM^DH\ngGX`LDdwMTAtXyKVzHZG|ebSZX=\ngGX`LDdwMTAtXyKVzHZG}i`=\ngGX`LDdwMTAtXyKVzH[{|ebSZX\ngGX`LDdwMTAtXyKVzH[{}i`\ngGX`LDdwMTAtXyKWNbgMtPtO{S@\ngGX`LDdwMTAtXyKZzHZG}i`\ngGX`LDdwMTAtXyK[NbgMtPtO{S@\ngGX`LDdwMTAtXyMVzH[{}i`\ngGX`LDdwMTAtXyMZzHZG}i`=\ngGX`LDdwMTAthzncn{ZX=\ngGX`LDdwMTAthzncn}ZX\ngGX`LDdwMTAthzncv}ZX=\ngGX`bDnLiMsP@]RMt]wX\ngGX`bDnLiMsT`]ZNZ`\ngGX`bDnLiMsUSP]ZNZweB<\ngGX`bDnLiMsUSP]ZNZweB>\ngGX`hEIWIMsP@]RMt]w_{R@=\ngGX`hEIWIMsP@]RMt]wo{R@\ngGX`hEIWIMsP@]RMt^wo{R@=\ngGX`hEIWIMsS@]FNRuncvaZP\ngGX`hEIWIMsS@]FNRuncv~ZP\ngGX`hEIWIMsS@]FNRuoJG}i@\ngGX`hEIWIMsS@]JNkh{nvd@\ngGX`hEIWIMsS@]JNkh{o_vd@\ngGX`hEIWIMsS@]JNkh}nvd@\ngGX`hEIWIMsS@]JNkh}o_vd@\ngGX`hEIWIMsU@]FNRunbFaZP\ngGX`hEIWIMsUSH]FNRunbF~ZP<\ngGX`hEIWIMsUSH]FNRunbF~ZP>\ngGXaBDYR[f`@zd[h{np\ngGXaBDYR[fi@zt\\uoKt\ngGXaBDYR[fjf`zt\\uoJD<\ngGXaBDYR[fjf`zt\\uoJD>\ngGXaBDYR[fjf`zt\\voJD<\ngGXaBDnR[f`@zd[h{np\ngGXaBDnR[f`@zd[h{oP\ngGXaBDnR[ff@zT]WQw^`\ngGXaBDnR[fi@zT]WQw]`\ngGXaBDnR[fi@zT]WQw^`\ngGXaBDnR[fi@zt\\u@\ngGXaBDnR[fi@zt\\uoKt\ngGXaBDnR[fjf`zt\\uoJD<\ngGXaBDnR[fjf`zt\\uoJD>\ngGXaLDnR[fj@zL\\ek]DMC~tp=\ngGXdBl@b^BSRuTbGVbfmyP`<\ngGXdBl@b^BSRuTbGVbfmyP`>\ngGXdBl@b^BSRuTbGVbfuyP`<\ngGXdBl@b^BSRuTbGVbfuyP`>\ngGXdBl@b^FQREj`NmDm[raZD\ngGXdMD@baFRREZPNlGIkhao_vf@\ngGXdMD@baFRREZPNlGIkpaZX\ngGXdMD@baFRREZ`NlGI[haoovf@\ngGXdMD@baFRREZ`NlGIkhaoovf@\ngGXeMD@baF{IIBmPGVCdmtPww{S@\ngGXeMD@baF{IIBmPGVCdmt_Ww{S@\ngGXeMD@baF{IIBmPGVCdutPww{S@\ngGXhHZ@aIfjXCkQSfzGlG}i@\ngGXhHZ@aIfjXCkQSgNbdmtOXO{R@\ngGXhLEJAInjhChqrVmtPtO{S@=\ngGXhLEJAInjhChqrVutPtO{S@\ngGXhMD@cIIBmHGQCdu[hao_vf@\ngGXhMD@cIIBmHGQCdu[paZX\ngGXhMD@cIIBmHGQCdu\\yNRwQC^mL\ngGXhMD@cIIBmHGQCdu\\yNRwaC~tp\ngGXhMD@cIIBmPGQCdm[hah_vf@\ngGXhMD@cIIBmPGQCdm[h~h_vf@\ngGXhMD@cIIBmPGQCdmkhah_vf@\ngGXhMD@cIIBmPGQCdu[hah_vf@\ngGXhMD@cIIBmPGQCdu[haoovf@\ngGXhMD@cIIBmPGQCdu\\yNRwQCPmL\ngGXhMD@cIIBmPGQCdukhah_vf@\ngGXhMD@cIIJmPGVBVmyP`\ngGXhMD@cIIJmPGVBVmy_@\ngGXhMD@cIIJmPGVBVn\\gI[ra@\ngGXhMD@cIIJmPGVBVuyP`\ngGXhMDOCIHYUPGQCdm[hahP\ngGXhbLjA\\YRnjjbPzHYImgAcfz`ZD<\ngGXhbLjA\\YRnjjbPzHYImgAcfz`ZD>\ngGXhdZ@aS^RYjV@zTdwPwmmD\ngGXiMD@c]ddaVhCharZmtPtO{S@\ngGXiMD@c]ddaVhCharZutPtO{S@\ngGY@BDfYh@NeGM}`g]v\ngGY@BDfYh@NeGN]EI[{AN{t\ngGY@BDfYh@NeGU}`g]v\ngGY@BDfYh@NeGU}`g]z\ngGY@BDfYh@NeGV]EI[{AN{t\ngGY@BDfYi`NcENZwVCP`\ngGY@BDfYi`NcENZwvB^tH\ngGY@BDfYi`NcENZytTenlFa@\ngGY@BDfYi`NcEN[YtTeolD}hP\ngGY@BDfYi`NcENjwVCP`\ngGY@BDfYi`NcENkWvB^tH\ngGY@BDfYi`NmEV[{AN{t\ngGY@BDfYi`NmEVk{AN{t\ngGY@BDfYi`NmEVlzJRwvB]wh\ngGY@BDfYjPNcENZytTenlF}@\ngGY@BDfYjPNcENZytTeoLD\ngGY@BDfYjPNcENZytTyoLD\ngGY@BDfYjPNcENjwVC^`\ngGY@BDfYjPNcENjwfB\ngGY@BDfYjPNcENjytTenlF}@\ngGY@BDfYjPNcENjytTeoLD\ngGY@BDfYjPNmEV[{AN{l\ngGY@BDfYjPNmEV[{AN{t\ngGY@BDfYjPNmEV[{AO[l\ngGY@BDfYjPNmEV\\zJRwvB]wh\ngGY@BDfYjPNmEV\\zJRwvB^wh\ngGY@BDfYjPNmEVk{AN{l\ngGY@BDfYjPNmEVk{AN{t\ngGY@BDfYjPNmEVk{AO[l\ngGY@BDfYjPNmEVk{AO[t\ngGY@BDfYjPNmEVlzJRwvB]wh\ngGY@BDfYjPNmEVlzJRwvB^wh\ngGY@BDfYjhhNcENZwVCP`>\ngGY@BDfYjhhNcENjwVCP`<\ngGY@BDfYjhhNcENjwVCP`>\ngGY@BDfZd@NiJyF}l{oP\ngGY@BDfZe`NmIM[x[vzD\ngGY@BDfZfPNeIUrM{Yw]`\ngGY@BDfZfPNmEV[h{np\ngGY@BDfZfPNmEV[h{oP\ngGY@BDfZfPNmIM[x[v{t\ngGY@BDfZhIDNeGM}`g]v>\ngGY@BDfZhIDNeGN]EI[{AO[t>\ngGY@BDfZjeDdNcENZwVCP`<\ngGY@BDfZjeDdNcENZwVCP`>\ngGY@BDfZjeDdNcENZypXenlFa@<\ngGY@BDfZjeDdNcENZypXenlFa@>\ngGY@BDfZjeDdNcENZytTenlFa@<\ngGY@BDfZjeDdNcENZytTenlFa@>\ngGY@BDfZjeDdNcENZytTynlFa@<\ngGY@BDfZjeDdNcENZytTynlFa@>\ngGY@BDfZjeDdNcEN[WVCP`<\ngGY@BDfZjeDdNcEN[YtTynlFa@<\ngGY@BDfZjeDdNcEN[YtTynlFa@>\ngGY@BDfZjeDdNcENkWVCP`>\ngGY@BDfZjeDhNcENZwVCP`<\ngGY@BDfZjeDhNcENZwVCP`>\ngGY@BDfZjeDhNcENZyLTyK]XMB<\ngGY@BDfZjeDhNcENZyLTyK]XMB>\ngGY@BDfZjeDhNcENZytTenlFa@<\ngGY@BDfZjeDhNcENZytTenlFa@>\ngGY@BDfZjeDhNcENZytTynlFa@<\ngGY@BDfZjeDhNcENZytTynlFa@>\ngGY@BDfZjeDhNcEN[WVCP`<\ngGY@BDfZjeDhNcEN[WVCP`>\ngGY@BDfZjeDhNcENjwVCP`<\ngGY@BDfZjeDhNcENjwVCP`>\ngGY@BDfZjeHhNcENjwVCP`<\ngGY@BDfZjeHhNcENjwVCP`>\ngGY@BDfZjeHhNcENjypXynlFa@>\ngGY@BDfzZihNmKM[x[VzD<\ngGY@BDfzZihNmKM[x[VzD>\ngGY@DDfYj`NkENRuolDah_vb@=\ngGY@DDfYj`NkENRuolDaoovb@\ngGY@DDfYj`NkENRuomxah_vb@=\ngGY@DDfYj`NkENRushiK_XIC__mD\ngGY@DDfYj`NkENRushiK_[qC__mD\ngGY@DDfYj`NkENRushis_XICPmD\ngGY@DDfYj`NkENRushis_XIC__mD\ngGY@DDfYj`NkENRushis_[qCPmD\ngGY@DDfYj`NkENRvolDah_vb@\ngGY@DDfYj`NkENRvomxah_vb@\ngGY@DDfYj`NkENRvshiK_XICPmD\ngGY@DDfYj`NkENRvshiK_[qCPmD\ngGY@DDfYj`NkENRvshis_XICPmD\ngGY@DDfYj`NkENRvshis_[qCPmD\ngGY@DDfYj`NkENSUolDaoovb@\ngGY@DDfYj`NkENSUshiK_XIC__mD\ngGY@DDfYj`NkENSUshiK_[qC__mD\ngGY@DDfYj`NkENSVolDah_vb@=\ngGY@DDfYj`NkENSVshis_XICPmD\ngGY@DDfYj`NkENbuolDah_vb@=\ngGY@DDfYj`NkENbuolDaoovb@\ngGY@DDfYj`NkENbushiK_XIC__mD\ngGY@DDfYj`NkENbushis_XICPmD\ngGY@DDfYj`NkENbushis_XIC__mD\ngGY@DDfYj`NkENbvolDah_vb@\ngGY@DDfYj`NkENbvshiK_XICPmD\ngGY@DDfYj`NkENbvshis_XICPmD\ngGY@DDfYj`NkENcVolDah_vb@=\ngGY@DDfYj`NkENcVshis_XICPmD\ngGY@DDfYj`NmEV[{AN{w}h`\ngGY@DDfYj`NmEV[{AO[w}h`=\ngGY@DDfYj`NmEV\\zJRwvB]wo{Q@\ngGY@DDfYj`NmEV\\zJ\\wvB^wo{Q@\ngGY@DDfYj`NmEVk{AN{w}h`\ngGY@DDfYj`NmEVk{AO[w}h`=\ngGY@DDfYj`NmEVlzJ\\wvB^wo{Q@\ngGY@DDfZf`NcIIZwHwndMB=\ngGY@DDfZf`NkENRuomtah_vb@=\ngGY@DDfZf`NkENRushis_[iCPmD\ngGY@DDfZjiDNkENRuolDah_vb@+\ngGY@DDfZjiDNkENRuolDah_vb@-\ngGY@DDfZjiDNkENRushis_XICPmD<\ngGY@DDfZjiDNkENRvolDah_vb@<\ngGY@DDfZjiDNmEV[{AN{w}h`<\ngGY@DDfZjiDNmEV[{AN{w}h`>\ngGY@DDfZjiDNmEV[{AO[w}h`-\ngGY@DDffj`NkENRuolDah_vb@\ngGY@DDffjiDNkENRushiK_XICPmD>\ngGY@DDfnjYDNcGIZypTeoCx<\ngGY@DDfnjYDNcGIZypTeoCx>\ngGY@DDfnjiDNcGIZwQCP`<\ngGY@DDfnjiDNcGIZwQCP`>\ngGY@DDfnjiDNcGIZyHXiK]DMB>\ngGY@DDfnjiDNcGIZyr\\enbFa@<\ngGY@DDfnjiDNcGIZyr\\enbFa@>\ngGY@DDfnjiDNcGIZytTenbFa@<\ngGY@DDfnjiDNcGIZytTenbFa@>\ngGY@DDfyh@NiFzN{l=\ngGY@DDfyh@NiFzN{t\ngGY@DDfyh@NiFzO[t=\ngGY@DDfyh@NiGNbdmt]wh\ngGY@DDfyh@NiGNbgMt^wh\ngGY@DDfyi`NcGIZwQ{P`\ngGY@DDfyi`NcGIZweB\ngGY@DDfyi`NcGIZytTencva@\ngGY@DDfyi`NcGIZytTeoJD\ngGY@DDfyi`NcGIZytTyncva@\ngGY@DDfyi`NcGIZytTyncv~@\ngGY@DDfyi`NcGIZytTyoJD\ngGY@DDfyi`NcGI[WQ{P`\ngGY@DDfyi`NcGI[WeB\ngGY@DDfyi`NcGI[YtTyncva@\ngGY@DDfyi`NcGI[YtTyoJD\ngGY@DDfyi`NeGUt]wh\ngGY@DDfyi`NeGUt^wX\ngGY@DDfyi`NeGUt^wh\ngGY@DDfyi`NeGV]EI[h}oP\ngGY@DDfyi`NeGV]EN[h}np\ngGY@DDfyi`NeGV]EN[h}oP\ngGY@DDfyj`NcGIZwQCP`\ngGY@DDfyj`NcGIZwQCPdlRP\ngGY@DDfyj`NcGIZyLTyK]DMB\ngGY@DDfyj`NcGIkWQCP`\ngGY@DDfyjidNcGIZwQC_@<\ngGY@DDfyjidNcGIZwQC_@>\ngGY@DDfyjidNcGIZytTenbF~@<\ngGY@DDfyjidNcGIZytTenbF~@>\ngGY@DDfyjidNcGIZytTynbFa@<\ngGY@DDfyjidNcGIZytTynbFa@>\ngGY@DDfyjidNcGIZytTynbF~@>\ngGY@DDfyjidNcGI[WQCP`<\ngGY@DDfyjidNcGI[WQCP`>\ngGY@DDfyjidNcGI[YtTynbFa@<\ngGY@DDfyjidNcGI[YtTynbFa@>\ngGY@DDfzX@NiFzN{l=\ngGY@DDfzX@NiFzN{t\ngGY@DDfzX@NiGNBdmt]wh\ngGY@DDfzX@NiJyFul{np=\ngGY@DDfzX@NiJyFul{oP\ngGY@DDfzX@NiJyFul}oP=\ngGY@DDfzX@NiKNbdmrMkiw^`\ngGY@DDfzY`NcGIZypTyoJD\ngGY@DDfzY`NcKIZwpvmtH\ngGY@DDfzZ`NcKIZwHvmdMB\ngGY@DDfzZ`NcKIZwHvmdMC~RqI@\ngGY@DDfzhIDNiFzN{l+\ngGY@DDfzhIDNiFzN{l-\ngGY@DDfzhIDNiFzN{t<\ngGY@DDfzhIDNiGNbdmt]wh<\ngGY@DDfzhIDNiGNbdmt]wh>\ngGY@HDfZh@NeGM}`g]w~t`=\ngGY@HDfZh@NeGN]EI[{AN{w}i@\ngGY@HDfZhIDNeGM}`g]v+\ngGY@HDfZhIDNeGM}`g]v-\ngGY@HDfZhIDNeGM}oG]v-\ngGY@HDfZhIDNeGM}oG]z<\ngGY@HDfZhIDNeGM}oG]z>\ngGY@HDfZhIDNeGNRFJRwvB]wh<\ngGY@HDfZhIDNeGNRFJRwvB]wh>\ngGY@HDfZi`NkENRushis]XMC~t`\ngGY@HDfZj`NkENRurPqrV~pRFaZP\ngGY@HDkjj`NjENRuolDahP\ngGY@HDkjj`NjENRus`qS_XICP`\ngGY@JDffj`NcENRwVBP`\ngGY@JDffjiDNcENRytTenlDa@<\ngGY@JDffjiDNcENRytTenlDa@>\ngGY@JDffjiDNcENRyt\\enlD~@>\ngGY@JDffjiDNcENSWVBP`<\ngGY@JDffjiDNcENSWVBP`>\ngGY@LDejj`NcEIZwQCP`\ngGY@LDejj`NcEIZypXinbFa@\ngGY@LDejjhhNcEIZwQC_@>\ngGY@LDejjhhNcEIZypXynbFa@<\ngGY@LDejjhhNcEIZypXynbFa@>\ngGY@LDijj`NjFJRuodDahP\ngGY@LDijj`NjFJRus`qS_HICP`\ngGY@LDijjiDNjFJRus`qs_HICP`<\ngGY@LDijjiDNjFJRus`qs_HICP`>\ngGY@LDijjiDNjFJbus`qs_HICP`<\ngGY@LDijjiDNjFJbus`qs_HICP`>\ngGY@LDijjiDNjFJbus`qs_HIC_@<\ngGY@LDijjiDNjFJbus`qs_HIC_@>\ngGY@bAqeIfiXChqSfn]EI[ra@\ngGY@dAreInf@CjQshiK]G]z\ngGY@hAteIfi@CiQs]G]w~t`=\ngGY@hAteIfi@CiQs_[iw]mH=\ngGY@hAteIijhCjqSdm[{AHZD\ngGY@hAteIijjQCjqSdm\\zJRwvBPtH<\ngGY@hAteIijjQCjqSdm\\zJRwvBPtH>\ngGYABCJSLuTTGQbgU[kAhP<\ngGYABCJSLuTTGQbgU[kAhP>\ngGYABCJSMURbRGQbgM\\zJRwVCP`<\ngGYABCJSMURbRGQbgUkkAhP<\ngGYABCJSMURbTGQbgM[kAhP<\ngGYABCJSMURdTGQbgU[kAhP<\ngGYABCJSMURdTGQbgU[kAhP>\ngGYABIJSMUHGVbkM}`g]v>\ngGYABIJSMUHGVbkM}`g]z>\ngGYABIJSMUHGVbkV]EN[{AO[l>\ngGYADArSMSPGUbgIZytTyomtah_vb@\ngGYADArS]L@GTc]G]v=\ngGYADEJSMTDbGRcf~pSn}ZH<\ngGYADEJS]L@GTc_Ki{^`=\ngGYAJKJSSUPGQbgI[kAHP\ngGYALMJRuUPGQbdm[hahP\ngGYDJQDJHR[jf@zT\\`\ngGYHBaxIMtp@]RMt]wX\ngGYHDIPIMuP@]RN]EI[h{oP>\ngGYHDPDIMts@]ZVZwpvmtH\ngGYHDQxILuUJIP]FJ\\uoa{^o`>\ngGYHE@DIUsUPH]TJ\\ek_[qCPmD-\ngGYHE@DYICF``Pz`[h{np+\ngGYHEAxIU[U@]TJ]Fk_XICPmD\ngGYHEAxIU[U@]TJ]Fm_XICPmD\ngGYHHPDILuS@]FJ\\uoa{Ah_vd@\ngGYHHPDILuS@]FJ\\ushiK_CvCPmH\ngGYHHPDILuS@]FJ\\voa{Ah_vd@\ngGYHHPDILuS@]FJ\\vshiK_CvCPmH\ngGYHHPDILuS@]FJ]Uoa{Ah_vd@\ngGYHHPDILuS@]FJ]UshiK_CvCPmH\ngGYHHPDILuS@]FJ]UshiK_CvC__mH\ngGYHHPDILuT`]FJ\\uoa{Ao_vd@\ngGYHHPDILuUQP]FJ\\ushiK_CvCPmH<\ngGYHHPxILuS@]FJ\\ushiK_CvCPmH\ngGYHJPDILuK@]JR[h[vp\ngGYHJPDILuK@]JR[h[wP\ngGYHJPDILuK@]JR\\zJRwPwn`\ngGYHJPDILuK@]ZJ\\`\ngGYHJPDILuK@]ZJ\\wfz\ngGYHJPDILuK@]ZJ\\ypXe@\ngGYHJPDILuL`]JRkd[vsn{@\ngGYHJPDILuL`]JRkd[wSn{@\ngGYHJPDILuSRH]ZJ\\wfB<\ngGYHJQDILuK@]ZJ\\ytTeoMt\ngGYHJQHILuK@]ZJ\\ytTe@\ngGYHJQHILuSRH]ZJ\\wfB>\ngGYHK@xIUMU@]TLTyK_HNB_@\ngGYHKAxIU[U@]DJ\\enlDa@\ngGYHKAxIU[U@]DJ\\erXirVzpRD\ngGYHKAxIU[U@]DJ]FnlDa@\ngGYHL`DIMsU@]FNRunbFaZX=\ngGYHL`DIMtu@]FNRunbFaZX=\ngGYHdIPSeJSWUTbGQcdm[hahP<\ngGYHdIPSeJSWUTbGQcdm[hahP>\ngGYHlEPKmJUuUPGUCEIkYpXiohDahP\ngGYHlEPKmJUuUPGUCIIkYpXiohDahP\ngGYIHEPKdkjj`NjENcVolDahP\ngGYILEPKdkjj`NjFJSVs`qS_PICP`\ngGYLcaHR`TaNLiM]U@]ZNZyr\\eoJD\ngGYLcaHR`TaNLiM]U@]ZN[Yr\\eoJD\ngGY`JDTfyi`NeGH\ngGY`LDTfyj`NmGM[raZX\ngGY`hDYJyInZdCiQu]G]w~t`\ngGY`hDYJyInZjZCkQsV|h_vd@>\ngGYhCE`DYIHUj@zp\\uoJD\ngGYhCE`DYIHUj@zp\\usdyK^TH\ngGYhCE`DYIHUj@zp\\voJD\ngGYhCE`DYIHUj@zp\\vsdyK^TH\ngGYhCE`DYIIUi@zpRusdyK^Wo{P`\ngGYhCE`DYIIUj@zpRuoJG}hP\ngGYhCE`DYIIUj@zpRusdyK^TO{P`\ngGYhCE`DYIIUj@zpRusdyK^Ww{P`\ngGYhCEaxIU[UPH]XJZweB<\ngGYhCEaxIU[UPH]XJZweB>\ngGYhCEaxIU[UPH]XJZytTeoJD<\ngGYhCEaxIU[UPH]XJZytTeoJD>\ngGYhCEaxIU[UPH]XJ[WeB<\ngGYhCEaxIU[UPH]XJ[WeB>\ngGYhCEaxYIIVj@zpRuoJG}hP\ngGYhCEaxYIIVj@zpRvoJG}hP\ngGYhKE`DYIHUj@zp\\foBD\ngGYhjLUPKkJUuUPGVCEMy@`\ngGYhjLUPKkJUuUPGVCIMy@`\ngGYhjLUPKkJUuUPGVCIN\\FI[rA@\ngGYhkEax[kNRRUjhDNdDh<\ngGYhkEax[kNRRUjhDNdDh>\ngGYiKE`D[lddju@]HIP\ngG\\@@ZdsDLAuDwPwm`\ngG\\@@ZdsMLAtiInao]@\ngG\\@@ZdwATAuLwPvm`\ngG\\@@bdsDTAtduoao[h_vb@\ngG\\@@bdsDTAuEWHwmg]w~tP\ngG\\@@bdsDTAuEWHwmg]{~tP\ngG\\@@bdsDTAuEWHwng]{~tP\ngG\\@@bdsMTAtXisWNCDmu`tO{Q@\ngG\\@@bdsMTAtXisWNCGMu`tO{Q@\ngG\\@@bdsMTAtXiuWNCGMu`tO{Q@\ngG\\@@bdwA@AnQm[N{l=\ngG\\@@bdwM@AuIWHvmg]v\ngG\\@@bdwM@AuIWHvng]v\ngG\\@@bdwMLAtiZnQm[N{t\ngG\\@@bdwMLAtiZnQm]N{t\ngG\\@@bdwMUMAuiYk_CZ{P`>\ngG\\@@ldsMTAtXiKVzHZG}h`=\ngG\\@@ldsMTAtXiKWMCENRwQCPmD=\ngG\\@@ldsMTAtXiKWMCENRwpzPtO{Q@=\ngG\\@@ldsMTAtXiKWNCGMtPtO{Q@\ngG\\@@ldsMTAtXiKWNbgMtPtO{Q@\ngG\\@@ldsMTAtXiK[NCGMtPtO{Q@\ngG\\@@ldsMTAtXiK[NbgMtPtO{Q@\ngG\\@@ldsMTAtYIKVyF}lah_vb@=\ngG\\@@ldsMTAthjoat}o_vb@=\ngG\\@@ldwATAuMWHvmg]w~tp=\ngG\\@@ldwATAuMWHvmgm{~tp=\ngG\\@@ldwATAulek\\cZvPtO{S@=\ngG\\@@ldwATAulem\\cZvPtO{S@=\ngG\\@@ldwATAulfm\\cZvPtO{S@=\ngG\\@ABeWURAuaIk_S^{^m@\ngG\\@ABeWUUDatPisWIbgI[kAh_v`@<\ngG\\@ABeWUUDatPisWIbgI[kAh_v`@>\ngG\\@ABeWUUDauaIk_S^{Pm@<\ngG\\@ABeWUUDauaIk_S^{Pm@>\ngG\\@ABeWUUDauaIm_S^wPm@<\ngG\\@ABeWUUDauaIm_S^wPm@>\ngG\\@ABeWUUDauaIm_S^{Pm@<\ngG\\@ABeWUUDauaIm_S^{Pm@>\ngG\\@AEddLj@CjBnYm[N{o}h@=\ngG\\@AEddLj@CjBnYm[N{w}h@=\ngG\\A@ZIRYb@@wHwmg]v=\ngG\\A@lIRYfj@zLTek]DMC~tP=\ngG\\A@lIRYfj@zLTek_CiCPmD=\ngG\\A@lIRYfj@zLTekfabgI[hah_vb@=\ngG\\A@lIRYfj@zLTekgAcf~GRFaZH\ngG\\DEb@b^BSRuPGVbfmy__dd\\[Q@\ngG\\DEb@b^BSRuPGVbfuyPmD\ngG\\EebDR^@yRYRZyjdPzt\\unev~IPxvf@>\ngG\\H@[jCIHYUPGQCEN[jAPP\ngG\\HEb@aIfZhCkQSV|h_vb@\ngG\\HEb@aInfhCkRsV~FunaZX\ngG\\HHlOAJfjhChabVmtPtH\ngG\\HHlOAJfjhChabVutPtO{R@\ngG\\IHl@`ReSUTAtPqKVzHZD\ngG\\`hZEIWIMsS@]JN_vd@\ngG\\`hZEIWIMsS@]JNkh{nvd@\ngG\\`hZEIWIMsS@]JNkh{o_vd@\ngG\\ahZEIWWdfyi`NeGUt]w_{R@\ngG]@DZDfyi`NeGUt]wX\ngG]@DZDfyi`NeGUt]wh\ngG]@EbDfYj`NmEM[raZH\ngG]@EbDfYj`NmEM\\zJ\\weC~tP\ngG]@LZDejj`NeEH\ngG]HEcAxIULE@]JM[y[vzD\ngG]HEcAxIULE@]JM\\xNRwrwmtH\ngG]HEcAxIULE@]JMlxNRwrwmtH\ngG]HEcAxIU[U@]XJZweC~tP\ngG]HEcAxIU[U@]XJ[WeC~tP\ngG]HEcAxYIIXJ@zQZyp\\eoeo[h_va@\ngG]HlZEPKmJUuUPGVCIMy@`\ngJP@DjXDCiQK]K^v=\ngJP@DjXDCiQK]K^z\ngJP@DjXDCiQK]Knz=\ngJP@DjXDCiQK_K^v^`=\ngJP@DjXDCiQK_K^z^`\ngJP@DjXDCiQK_Knz^`=\ngJP@DjXDCiQKgASfzV}t\ngJP@DjXDCiQKgASf~V}t}@\ngJP@DjXDCiQKgAcfzW]t\ngJP@DjXDCiQKgAcf~W]t}@\ngJP@DjYdCjabgI[i]pP\ngJP@DjYdCjabgI[i]w`\ngJP@DjYdCjabgI[kAOP\ngJP@DjYdCjabgI[sA@\ngJP@DjYdCjabgI[y]pSt\ngJP@DjYdCjabgI\\xJ\\wR{``\ngJP@DjYdCjabgI\\xJ\\wR{o@\ngJP@DjYdCjabgI\\xJ\\wVB^`\ngJP@DjYdCjabgI\\xJ\\wV|^`\ngJP@DjYdCjabgI\\xJ\\wfB\ngJP@DjYdCjabgI\\xJ\\wf|\ngJP@DjYdCjabgI\\xJ\\wr{`gh\ngJP@DjYdCjabgI\\xJ\\wr{oGh\ngJP@DjYdCjabgI\\xL\\wR{``\ngJP@DjYdCjabgI\\xL\\wR{o@\ngJP@DjYdCjabgI\\xL\\wVB^`\ngJP@DjYdCjabgI\\xL\\wV|^`\ngJP@DjYdCjabgI\\xL\\wfB\ngJP@DjYdCjabgI\\xL\\wf|\ngJP@DjYdCjabgI\\xL\\wr{`gh\ngJP@DjYdCjabgI\\xL\\wr{oGh\ngJP@DjYdCjabgQ[i]pP\ngJP@DjYdCjabgQ[sA@\ngJP@DjYdCjabgQ[y]pSt\ngJP@DjYdCjabgQ\\xJ\\wR{``\ngJP@DjYdCjabgQ\\xJ\\wr{`gh\ngJP@DjYdCjabgQ\\xL\\wVB^`\ngJP@DjYdCjabgQ\\xL\\wr{`gh\ngJP@DjYdCkBbVzV}l\ngJP@DjYdCkBbVzV}t\ngJP@DjYdCkBbVzW]l\ngJP@DjYdCkBbVzW]t\ngJP@DjYdCkBbV~V}t}@\ngJP@DjYdCkBbV~W]t}@\ngJP@DjZhCjabgI[yApRD\ngJP@DjZhCjabgI[yApRG|eBb\ngJP@DjZhCjabgI[yApSx\ngJP@DjZhCjabgI[y^wbD\ngJP@DjZhCjabgI\\dLTyodGAHP\ngJP@DjZhCjabgI\\dLTyodGAO`\ngJP@DjZhCjabgI\\dLTyoe{^HP\ngJP@DjZhCjabgIkyApRD\ngJP@DjZhCjabgIldLTyodGAHP\ngJP@DjZhCjabkQ[yApRD\ngJP@DjZhCjabkQ\\dLTyodGAHP\ngJP@DjZhCjabkQ\\dLTyodGAO`\ngJP@DjZhCjabkQkyApRD\ngJP@DjZjACjabgI[yAwbD<\ngJP@DjZjACjabgI[yAwbD>\ngJP@DjZjACjabgI[yAwbG|eBb>\ngJP@DjZjACjabgI[yAwcx<\ngJP@DjZjACjabgI\\dLTyodG^HP<\ngJP@DjZjACjabgI\\dLTyodG^HP>\ngJP@DjZjACjabgI\\dLTyodG^H_rTJH<\ngJP@DjZjACjabgI\\dLTyodG^H_rTJH>\ngJP@DjZjACjabgI\\dLTyodG^O`<\ngJP@DjZjACjabgI\\dLTyodG^O`>\ngJP@DjZjACjabgI\\xJ\\wrCoDH<\ngJP@DjZjACjabgI\\xJ\\wrCoDH>\ngJP@DjZjACjabgI\\xJ\\wrCoDOyJED<\ngJP@DjZjACjabgI\\xJ\\wrCoDOyJED>\ngJP@DjZjACjabgI\\xJ\\wrCoGp<\ngJP@DjZjACjabgI\\xJ\\wrCoGp>\ngJP@DjZjACjabgI\\xL\\wrC`dH<\ngJP@DjZjACjabgI\\xL\\wrC`dH>\ngJP@DjZjACjabgI\\xL\\wrC`dOyJED<\ngJP@DjZjACjabgI\\xL\\wrC`dOyJED>\ngJP@DjZjACjabgI\\xL\\wrC`gp<\ngJP@DjZjACjabgI\\xL\\wrC`gp>\ngJP@DjZjACjabgI\\xL\\wrCoDH<\ngJP@DjZjACjabgI\\xL\\wrCoDH>\ngJP@DjZjACjabgI\\xL\\wrCoDOyJED<\ngJP@DjZjACjabgI\\xL\\wrCoGp<\ngJP@DjZjACjabgI\\xL\\wrCoGp>\ngJP@DjZjACjabgI\\xL\\wr}oDH<\ngJP@DjZjACjabgI\\xL\\wr}oDH>\ngJP@DjZjACjabgI\\xL\\wr}oGp<\ngJP@DjZjACjabgI\\xL\\wr}oGp>\ngJP@DjZjACjabgIkyAwbD<\ngJP@DjZjACjabgIkyAwbD>\ngJP@DjZjACjabgIldLTyodG^H_rTJH<\ngJP@DjZjACjabgIlxJ\\wrCoDH<\ngJP@DjZjACjabgIlxJ\\wrCoDH>\ngJP@DjZjACjabgIlxL\\wrC`dH<\ngJP@DjZjACjabgIlxL\\wrC`dH>\ngJP@DjZjACjabgIlxL\\wrCoDH<\ngJP@DjZjACjabgIlxL\\wr}oDH<\ngJP@DjZjACjabgIlxL\\wr}oDH>\ngJP@DjZjACjabgQ[yApRD<\ngJP@DjZjACjabgQ[yApRD>\ngJP@DjZjACjabgQ[yApSx>\ngJP@DjZjACjabgQ\\dLTyodGAHP<\ngJP@DjZjACjabgQ\\dLTyodGAHP>\ngJP@DjZjACjabgQ\\dLTyodGAO`>\ngJP@DjZjACjabgQ\\xJ\\wrC`dH<\ngJP@DjZjACjabgQ\\xJ\\wrC`dH>\ngJP@DjZjACjabgQ\\xJ\\wrC`gp>\ngJP@DjZjACjabgQ\\xL\\wrC`dH<\ngJP@DjZjACjabgQ\\xL\\wrC`dH>\ngJP@DjZjACjabgQ\\xL\\wrC`gp<\ngJP@DjZjACjabgQ\\xL\\wrC`gp>\ngJP@DjZjACjabgQkyApRD<\ngJP@DjZjACjabgQkyApRD>\ngJP@DjZjACjabgQlxJ\\wrC`dH<\ngJP@DjZjACjabgQlxL\\wrC`dH<\ngJP@DjZjACjabgQlxL\\wrC`dH>\ngJP@DjZjACjabkI[yAwbD<\ngJP@DjZjACjabkI[yAwbD>\ngJP@DjZjACjabkI\\xJ\\wrCoDH<\ngJP@DjZjACjabkI\\xJ\\wrCoDH>\ngJP@DjZjACjabkI\\xJ\\wrCoGp<\ngJP@DjZjACjabkI\\xJ\\wrCoGp>\ngJP@DjZjACjabkQ\\xL\\wrC`dH<\ngJP@DjZjACjabkQ\\xL\\wrC`dH>\ngJP@DjZjACjabkQ\\xL\\wrC`gp<\ngJP@DjZjACjabkQ\\xL\\wrC`gp>\ngJP@DjvhCjabgI[kAHP\ngJP@DjvhCjabgI[kAO`\ngJP@DjvhCjabgI[k^HP\ngJP@DjvhCjabgI[z]pRD\ngJP@DjvhCjabgI[z]pSx\ngJP@DjvhCjabgI[z]wbD\ngJP@DjvhCjabgI\\xL\\wVBP`\ngJP@DjvhCjabgI\\xL\\wVB_@\ngJP@DjvhCjabgI\\xL\\wV|P`\ngJP@DjvhCjabgI\\xL\\wt{`dH\ngJP@DjvhCjabgI\\xL\\wt{`gp\ngJP@DjvhCjabgI\\xL\\wt{oDH\ngJP@DjvhCjabgI\\zJ\\wVBP`\ngJP@DjvhCjabgI\\zJ\\wVB_@\ngJP@DjvhCjabgI\\zJ\\wV|P`\ngJP@DjvhCjabgI\\zJ\\wV|_@\ngJP@DjvhCjabgI\\zJ\\wt{`dH\ngJP@DjvhCjabgI\\zJ\\wt{`gp\ngJP@DjvhCjabgI\\zJ\\wt{oDH\ngJP@DjvhCjabgI\\zJ\\wt{oGp\ngJP@DjvhCjabgIkkAHP\ngJP@DjvhCjabgIkz]pRD\ngJP@DjvhCjabgIlxL\\wt{`dH\ngJP@DjvhCjabgQ[kAHP\ngJP@DjvhCjabgQ[z]pRD\ngJP@DjvhCjabgQ\\xL\\wVBP`\ngJP@DjvhCjabgQ\\xL\\wVB_@\ngJP@DjvhCjabgQ\\xL\\wt{`dH\ngJP@DjvhCjabgQ\\xL\\wt{`gp\ngJP@DjvhCjabgQ\\zJ\\wt{`dH\ngJP@DjvhCjabgQkz]pRD\ngJP@DjvhCkBRV~f}la@\ngJP@DjvhCkBRV~f}ta@\ngJP@DjvhCkBRV~f}t~@\ngJP@DjvhCkBRV~g]la@\ngJP@DjvhCkBRV~g]ta@\ngJP@DjvhCkBRWNCGM}N{YB\ngJP@DjvhCkBRWNCGM}N{Y|\ngJP@DjvhCkBRWNCGM}N{iB\ngJP@DjvhCkBRWNCGM}N{i|\ngJP@DjvhCkBRWNbgM}M{iB\ngJP@DjvhCkBRWNbgM}M{i|\ngJP@DjvhCkBRWNbgM}N{iB\ngJP@DjvhCkBRZ~f}ta@\ngJP@DjvhCkBRZ~g]ta@\ngJP@DkfhCjabgI[kAHP\ngJP@DkfhCjabgI[kAH_rRNH\ngJP@DkfhCjabgI[z]pRD\ngJP@DkfhCjabgI\\dLTynlDa@\ngJP@DkfhCjabgI\\dLTyoiwAHP\ngJP@DkfhCjabgQkkAHP\ngJP@DkfhCjabgQkz]pRD\ngJP@DkfjICjabgI[kAO`<\ngJP@DkfjICjabgI[kAO`>\ngJP@DkfjICjabgI[z]pSx<\ngJP@DkfjICjabgI[z]pSx>\ngJP@DkfjICjabgI\\dLTynlD~@<\ngJP@DkfjICjabgI\\dLTynlD~@>\ngJP@DkfjICjabgI\\dLTyoiwAO`<\ngJP@DkfjICjabgI\\dLTyoiwAO`>\ngJP@DkfjICjabgI\\xLTwVBP`<\ngJP@DkfjICjabgI\\xLTwVBP`>\ngJP@DkfjICjabgI\\xLTwVB_@<\ngJP@DkfjICjabgI\\xLTwVB_@>\ngJP@DkfjICjabgI\\xLTwV|_@<\ngJP@DkfjICjabgI\\xLTwV|_@>\ngJP@DkfjICjabgI\\xLTwt{`dH<\ngJP@DkfjICjabgI\\xLTwt{`dH>\ngJP@DkfjICjabgI\\xLTwt{`gp<\ngJP@DkfjICjabgI\\xLTwt{`gp>\ngJP@DkfjICjabgI\\xLTwt{oGp<\ngJP@DkfjICjabgI\\xL\\wVB_@<\ngJP@DkfjICjabgI\\xL\\wVB_@>\ngJP@DkfjICjabgI\\xL\\wt{`gp<\ngJP@DkfjICjabgI\\xL\\wt{`gp>\ngJP@DkfjICjabgIkkAHP<\ngJP@DkfjICjabgIkkAHP>\ngJP@DkfjICjabgIkz]pRD<\ngJP@DkfjICjabgIkz]pRD>\ngJP@DkfjICjabgIldLTynlDa@<\ngJP@DkfjICjabgIldLTynlDa@>\ngJP@DkfjICjabgIlxLTwVBP`<\ngJP@DkfjICjabgIlxLTwVBP`>\ngJP@DkfjICjabgIlxLTwt{`dH<\ngJP@DkfjICjabgIlxLTwt{`dH>\ngJP@DkfjICjabgQ[kAO`<\ngJP@DkfjICjabgQ[kAO`>\ngJP@DkfjICjabgQ\\xL\\wt{`gp<\ngJP@DkfjICjabgQ\\xL\\wt{`gp>\ngJP@DkfjICjabgQlxLTwVBP`<\ngJP@DkfjICjabgQlxLTwVBP`>\ngJP@LdaB`Nedm}MkYB=\ngJP@LdaB`Nedm}MkY|=\ngJP@LdaB`Nedm}MkiB\ngJP@LdaB`Nedm}Mki|\ngJP@LdaB`Nedm}NkiB=\ngJP@LdaB`Nedm}Nki|=\ngJP@LdaB`Nedn\\EN[z]WRD\ngJP@LdaB`Nedn\\EN[z]WSx\ngJP@LdaB`Nedn]EN[z[WRD\ngJP@LdaB`Nedn]EN[z[WSx\ngJP@LdaB`Nedu}MkYB=\ngJP@LdaB`Nedu}MkiB\ngJP@LdaB`Nedu}NkiB=\ngJP@LdaB`Nedv\\EN[z]WRD\ngJP@LdaB`Nedv]EN[z[WRD\ngJPAEJUsTAuPqSdv\\FJ[kAHP>\ngJPAMJULrAuPqSdn\\EN[sA@\ngJPBABPHPQ`aJfj@zpXeoBD\ngJPBABRHPQ`aJnj@zpTeoBD>\ngJPD@DHHRYZ`NcENRwVBP`\ngJPD@DHHRYZ`NcENbwVBP`\ngJPD@DHHR[j`NmGI[pa@\ngJPD@DHHR[j`NmGI[x^WbD\ngJPD@DJ`Rfh@NhFzvsl=\ngJPD@DPHRnh@NhFzvsl=\ngJPD@DPHRnh@NhFzvst\ngJPD@DPHRnh@NhFzwSt=\ngJPD@DPHRnh@NhGNCGMumgh\ngJPD@DPHRni`NdEUungh\ngJPD@DPHRni`NdEV\\FN[k]OP\ngJPD@DPHRnj`NbENRwVBP`\ngJPD@DSpRnh@NhF~gml{@=\ngJPD@DXHRfjPNbFJRwRB^`\ngJPD@DXHRfjPNbFJRwbB\ngJPD@DXHRfjPNbFJRypXyndD}@\ngJPD@DXHRfjPNbFJbwRB^`\ngJPD@DXHRfjPNbFJbypXyndD}@\ngJPD@DXHRfjPNlFR[yAvsl\ngJPD@DXHRfjPNlFR[yAvst\ngJPD@DXHRfjPNlFRkyAvsl\ngJPD@DXHRfjPNlFRkyAvst\ngJPD@DXHRfjPNlFRlxL\\wrCmgh\ngJPD@DXHRfjiDNbFJRypXindDa@<\ngJPD@DXHRfjiDNbFJRypXindDa@>\ngJPD@DXHRfjiDNbFJSYpXindDa@<\ngJPD@DXHRfjiDNbFJSYpXindDa@>\ngJPD@VPlRnh@NhFzvst\ngJPD@bQDRnh@NhFzvsl=\ngJPD@bQDRnh@NhFzvst\ngJPD@bSpRnh@NhF~gml{@=\ngJPDAxGpRij`NbFJmWRC``\ngJPDAxSpRnX@NhFzwSt=\ngJPE@bSpdiWT@GTC_Svv]`=\ngJPH@DIKT@GTc][Yv=\ngJPH@DIKT@GTc][Yz\ngJPH@DIKT@GTc][iz=\ngJPH@DIKT@GTc_Cvv]`=\ngJPH@DIKT@GTc_Cvv^`\ngJPH@DIKT@GTcgAcfzvst\ngJPH@DIKTpGQbgI\\xLTwVzP`\ngJPH@DIKTpGQbgIkpa@\ngJPH@DIKUPGQbgI[kAHP\ngJPH@DIKUPGQbgI[x^pRD\ngJPH@DIKUTRGQbgI\\xLTwVBP`<\ngJPH@DIKUTRGQbgI\\xLTwVBP`>\ngJPH@DILmHGQbgI\\zJ\\wVB^`\ngJPH@DILmHGQbgI\\zJ\\wfB\ngJPH@DILthGVddmtM{X\ngJPH@DILthGVddmtM{h\ngJPH@DILthGVddm|M{Yz\ngJPH@DILthGVddm|M{iz\ngJPH@DILuTbGQbgI[kAHP<\ngJPH@DILuTbGQbgI[kAHP>\ngJPH@DILuTbGQbgI[x^pRD<\ngJPH@DILuTbGQbgI\\xL\\wVBP`<\ngJPH@DILuTbGQbgI\\xL\\wVBP`>\ngJPH@DILuTbGQbgI\\zJ\\wVBP`<\ngJPH@DILuTbGQbgI\\zJ\\wVBP`>\ngJPH@DILuTbGQbgI\\zJ\\wV|P`<\ngJPH@DILuTbGQbgI\\zJ\\wV|P`>\ngJPH@DILuTbGQbgI\\zJ\\wp}`dH<\ngJPH@DILuTbGQbgI\\zJ\\wp}`dH>\ngJPH@DILuTbGQbgQ[kAHP>\ngJPH@DILuTbGQbgQ\\xL\\wVBP`<\ngJPH@DILuTbGQbgQ\\xL\\wVBP`>\ngJPH@DIMsPGQbgI\\zJ\\wRzP`\ngJPH@DIMsPGVedm|MkYB\ngJPH@DIMsPGVedm|MkiB\ngJPH@DIMsPGVedn]EN[x[WRD\ngJPH@DIMsPGVedu|MkiB\ngJPH@DIST@GRBf~P]l{@=\ngJPH@DIST@GRBf~P]l}@\ngJPH@DIST@GRBf~P]t}@=\ngJPH@DIST@GRBf~Wml{@=\ngJPH@DIST@GRBf~Wml}@\ngJPH@DIST@GRBgNCEM|`{iz\ngJPH@DIST@GRBgNCGM|`{Yz\ngJPH@DIST@GRBgNCGM|o[Yz\ngJPH@DIST@GRBj~P]l{@=\ngJPH@DIST@GRBj~P]l}@\ngJPH@DIST@GRBj~P]t}@=\ngJPH@DIST@GRBkNCEM|`{iz\ngJPH@DIST@GRBkNCGM|`{Yz\ngJPH@DISTpGUCENRwRBP`\ngJPH@DISTpGUCENRwrCndH\ngJPH@DISTpGUCENRypXiodG]HP\ngJPH@DISTpGUCENRypXioe{]HP\ngJPH@DISTpGUCENSWrCndH\ngJPH@DISTpGUCENSYpXindDa@\ngJPH@DISTpGUCENSYpXiodG]HP\ngJPH@DISTpGUCEVRwRBP`\ngJPH@DISTpGUCEVRwrCndH\ngJPH@DISTpGUCEVRypXiodG]HP\ngJPH@DISTpGUCEVRypXyodG]HP\ngJPH@DISTpGUCEVSWrCndH\ngJPH@DISTpGVCIM|`{Yz\ngJPH@DISTpGVCIM|`{iv\ngJPH@DISTpGVCIM|`{iz\ngJPH@DISTpGVCIN\\FN[yAwSt\ngJPH@DISTpGVCIU|`{Yz\ngJPH@DISTpGVCIU|`{iz\ngJPH@DISUPGUCENRwrC`dH\ngJPH@DISUPGUCEVRwrC`dH\ngJPH@DISUTbGUCENRypXiodGAHP<\ngJPH@DISUTbGUCENRypXiodGAHP>\ngJPH@DISUTbGUCENSWrC`dH<\ngJPH@DISUTbGUCENSWrC`dH>\ngJPH@DISUTbGUCENSYHXis_HNBP`<\ngJPH@DISUTbGUCENSYpXiodGAHP<\ngJPH@DISUTbGUCENSYpXiodGAHP>\ngJPH@DISUTbGUCEVRwrC`gp>\ngJPH@DISUTbGUCEVRypXiodGAHP<\ngJPH@DISUTbGUCEVSWrC`dH<\ngJPH@DISUTbGUCEVSWrC`dH>\ngJPH@DISUTbGUCEVSYpXiodGAHP<\ngJPH@DISUTbGUCEVSYpXiodGAHP>\ngJPH@VIST@GRBj~P]l{@=\ngJPH@VIST@GRBj~P]l}@\ngJPH@VIST@GRBj~P]t}@=\ngJPH@VISTpGUCENSYpXiodG]HP\ngJPH@bIKT@GTc][Yv=\ngJPH@bIKT@GTc][Yz\ngJPH@bIKT@GTc][iz=\ngJPH@bIMsPGVedm|MkiB\ngJPH@bIST@GRBf~P]l{@=\ngJPH@bIST@GRBf~P]l}@\ngJPH@bIST@GRBf~Wml{@=\ngJPH@bIST@GRBj~P]l{@=\ngJPH@bIST@GRBj~P]l}@\ngJPH@bIST@GRBj~P]t}@=\ngJPH@bIST@GRBkNCGM|`{Yz\ngJPH@bISTpGUCEVRwrCndH\ngJPH@bISTpGUCEVSWrCndH\ngJPH@bISTpGVCIU|`{iz\ngJPH@bISUPGUCEVRwrC`dH\ngJPH@xIKT@GTc][iz=\ngJPH@xIKT@GTc_Cvv]`=\ngJPH@xIKT@GTc_Cvz^`=\ngJPH@xIKUPGQbgI[x^pRD\ngJPH@xILuTbGQbgI[x^pRD<\ngJPH@xILuTbGQbgI[x^pRD>\ngJPH@xILuTbGQbgI\\zJ\\wp}`dH<\ngJPH@xILuTbGQbgI\\zJ\\wp}`dH>\ngJPH@xIMsPGQbgI[x^WRD\ngJPH@xITuPGUCENRwrC`dH\ngJPH@xITuPGUCENSWrC`dH\ngJPHABIKT@GTcgAcfzvst\ngJPHADIKT@GTc][Yv=\ngJPHADIKT@GTc][Yz\ngJPHADIKUPGQbgI[kAHP\ngJPHADILthGQbgI\\zJ\\`\ngJPHADILuTbGQbgI[kAHP<\ngJPHADILuTbGQbgI[kAHP>\ngJPHADILuTbGQbgI\\zJ\\wVBP`<\ngJPHADILuTbGQbgI\\zJ\\wVBP`>\ngJPHADILuTbGQbgI\\zJ\\wV|P`<\ngJPHADILuTbGQbgI\\zJ\\wV|P`>\ngJPHAHILuLbGQbgI[sA@>\ngJPHAHILuTbGQbgI[kAHP<\ngJPHAHILuTbGQbgI[kAHP>\ngJPHAHILuTbGQbgI\\zJ\\wVBP`<\ngJPHAHILuTbGQbgI\\zJ\\wVBP`>\ngJPHAVIKUPGQbgI[kAHP\ngJPHAVILuTbGQbgI\\zJ\\wVBP`<\ngJPHAVILuTbGQbgI\\zJ\\wVBP`>\ngJPHAbIKT@GTc][Yv=\ngJPHAbIKT@GTc][Yz\ngJPHAbIKT@GTc][iz=\ngJPHAbIKTpGQbgI[k]HP\ngJPHAbIKTpGQbgI[pa@\ngJPHAbILuTbGQbgI[kAHP<\ngJPHAbILuTbGQbgI[kAHP>\ngJPHAbILuTbGQbgI\\zJ\\wVBP`<\ngJPHAbILuTbGQbgI\\zJ\\wVBP`>\ngJPHAbILuTbGQbgI\\zJ\\wVB_@>\ngJPHAbILuTbGQbgI\\zJ\\wV|P`<\ngJPHAbILuTbGQbgI\\zJ\\wV|P`>\ngJPHAxIKT@GTc][Yv=\ngJPHAxIKT@GTc][Yz\ngJPHAxIKT@GTc_Cvv]`=\ngJPHAxIKT@GTc_Cvv^`\ngJPHAxIKT@GTc_Cvz^`=\ngJPHAxIKTpGQbgI\\xLTwVzP`\ngJPHAxIKTpGQbgI\\xLTwp}ndH\ngJPHAxIKUPGQbgI[x^pRD\ngJPHAxILuTbGQbgI[x^pRD<\ngJPHAxILuTbGQbgI\\xL\\wVBP`<\ngJPHAxILuTbGQbgI\\xL\\wVBP`>\ngJPHAxILuTbGQbgI\\xL\\wp}`dH>\ngJPHAxILuTbGQbgI\\zJ\\wVBP`<\ngJPHAxILuTbGQbgI\\zJ\\wVBP`>\ngJPHAxILuTbGQbgI\\zJ\\wp}`dH<\ngJPHAxILuTbGQbgI\\zJ\\wp}`dH>\ngJPHAxILuTbGQbgQ[x^pRD<\ngJPHAxISR@GRBfzwSt=\ngJPHAxISR@GRBf~W]t}@=\ngJPHAxITuPGUCENRwrC`dH\ngJPHAxITuPGUCENSWrC`dH\ngJPHAxITuPGUCENSWr}oDH\ngJPHAxITuPGUCEVbwrC`dH\ngJPHAxITuPGUCEVcWrC`dH\ngJPHAxITuTBGUCENbwrC`dH<\ngJPHAxITuTBGUCENbwrC`dH>\ngJPHCPITuPGQCEN\\dLTyodGAO`\ngJPHEPIWUPGUCENcWtC`dH\ngJPHMPITsHGQCEI[i]worTJH\ngJPHMPITuTBGQCEI\\xJ\\wRBP`<\ngJPHMPITuTBGQCEI\\xJ\\wRBP`>\ngJPHMPITuTBGQCEI\\xJ\\wrCoDH<\ngJPHMPITuTBGQCEI\\xJ\\wrCoDH>\ngJPHMPITuTBGQCEI\\xL\\wRBP`<\ngJPHMPITuTBGQCEI\\xL\\wRBP`>\ngJPHMPITuTBGQCEI\\xL\\wrCoDH<\ngJPHMPITuTBGQCEI\\xL\\wrCoDH>\ngJPHMPYIBE@]KIkz[WRD\ngJPI@DBTjZhCjabgI[yApRD\ngJPIAVBTij@CiAS_HNv]`=\ngJPIAVBTij@CiAS_Kvv^`\ngJPIAVBTij@CiAU_HNv]`=\ngJPIAVBTij@CiAU_HNv^`\ngJPIAVBTij@CiAU_HNz^`=\ngJPIAxBTej@CjQoa{[Np=\ngJPIAxBTej@CjQoa{[OP\ngJPIAxBTfZjQChqSdn]EN[kAHP<\ngJPIAxBTfZjQChqSdn]EN[kAHP>\ngJPIAxBTfZjQChqSdn]EN[x^pRD<\ngJPIAxBTfZjQChqSdn]EN[x^pRD>\ngJPIAxBTjZhCjabkQ[yApRD\ngJPIMPZTjZjAChabdn\\EN[yAwbD<\ngJPIMPZTjZjAChabdn\\EN[yAwbD>\ngJPIMP[djZjAChabdn\\EN[iAHP<\ngJPIMP[djZjAChabdn\\EN[iAHP>\ngJPIMP[djZjAChabdn\\EN[yAwbD<\ngJPIMP[djZjAChabdn\\EN[yAwbD>\ngJPIMP[djZjAChabdn\\FN[yAwbD>\ngJPL@DHHpPdru@]ZJRwaB\ngJP`@TfVhCkQSf|pP\ngJP`@TfVhCkQSf|w`\ngJP`@TfVhCkQSgNbgMy``\ngJP`@TfVhCkQSj|pP\ngJP`@TfZjQCkQSf|pP<\ngJP`@TfZjQCkQSf|pP>\ngJP`@TfZjQCkQSf|w`<\ngJP`@TfZjQCkQSf|w`>\ngJP`@TfZjQCkQSgICEN[sA@>\ngJP`@TfZjQCkQSgNCGMy``<\ngJP`@TfZjQCkQSgNCGMy``>\ngJP`@TfZjQCkQSgNbgMy``<\ngJP`@TfZjQCkQSgNbgMy``>\ngJP`@TfZjQCkQSj|pP>\ngJP`@TfyhCiRs]CZv\ngJP`@TfyhCiRs]CZz\ngJP`@dfVhChqSdmu`dH\ngJP`@dfVhChqSdmu`gp\ngJP`@dfVhChqSdmuoDH\ngJP`@dfVhChqSdmuoGp\ngJP`@dfVhChqSdn]EN[kAHP\ngJP`@dfVhChqSdn]EN[kAO`\ngJP`@dfVhChqSdn]EN[k^HP\ngJP`@dfVhChqSdn]EN[k^O`\ngJP`@dfVhChqSduu`dH\ngJP`@dfVhChqSduuoDH\ngJP`@dfVhChqSdv]EN[kAHP\ngJP`@dfVhChqSdv]EN[k^HP\ngJP`@dfVhChqShmu`dH\ngJP`@dfVhChqShmu`gp\ngJP`@dfVhChqShn]EN[kAHP\ngJP`@dfVhChqShn]EN[kAO`\ngJP`@dfVhChqShuu`dH\ngJP`@dfVhChqShv]EN[kAHP\ngJP`@dfvdCkQrT\ngJP`@dfvdCkQrV|OP\ngJP`@dfvdCkQrWNbgH\ngJP`@dfvdCkQrWNbgMx^`\ngJP`@dfvhCkQrV|HP\ngJP`@dfvhCkQrV|O`\ngJP`@dfvhCkQrWNbgMxP`\ngJP`@dfvhCkQrWNbgMx_@\ngJP`@dfvhCkQrZ|HP\ngJP`@dfzhCkQrV|HP\ngJP`@dfzhCkQrWICEN[pa@\ngJP`@dfzjQCkQrWNBgMxP`<\ngJP`@dfzjQCkQrWNBgMxP`>\ngJP`@dfzjQCkQrWNBgMx_@<\ngJP`@dfzjQCkQrWNBgMx_@>\ngJP`ADkjhChaSdnRFJ\\wVBP`\ngJP`ADkjjIChaSdn\\FJ[kAHP<\ngJP`AdefdCiQU][Yv\ngJP`AdijdChabdmt`gh\ngJP`AdijdChabdn\\FN[iAOP\ngJP`AdijdCkAdf~P]l}@\ngJP`AdijjQChabdmt`dH<\ngJP`AdijjQChabdmt`dH>\ngJP`AdijjQChabdmt`gp<\ngJP`AdijjQChabdmt`gp>\ngJP`AdijjQChabdmtoDH<\ngJP`AdijjQChabdmtoDH>\ngJP`AdijjQChabdnRFJ\\wRBP`<\ngJP`AdijjQChabdnRFJ\\wRBP`>\ngJP`AdijjQChabdn\\FJ[iAHP<\ngJP`AdijjQChabdn\\FJ[iAHP>\ngJP`AdijjQChabdn\\FJ[iAO`<\ngJP`AdijjQChabdn\\FJ[iAO`>\ngJP`AdijjQChabdn\\FN[iAHP<\ngJP`AdijjQChabdn\\FN[iAHP>\ngJP`AdijjQChabdn\\FN[iAO`<\ngJP`AdijjQChabdn\\FN[iAO`>\ngJP`AdijjQChabdn\\FN[i^O`<\ngJP`AdijjQChabdut`dH<\ngJP`AdijjQChabdut`dH>\ngJP`AdijjQChabdv\\FJ[iAHP<\ngJP`AdijjQChabdv\\FJ[iAHP>\ngJP`AdijjQChabdv\\FN[iAHP>\ngJP`AdijjQChabhmt`dH<\ngJP`AdijjQChabhmt`dH>\ngJP`AdijjQChabhn\\FN[iAHP<\ngJP`AdijjQChabhn\\FN[iAHP>\ngJPa@erS[RAuhyJ\ngJPa@erS[RAuhyK^Gh\ngJPa@erS[TAuhyK^DH\ngJPa@erS[TAuhyK^Gp\ngJPa@erS[TAuhyM^DH\ngJPa@mrSKTAtXitVzpRD\ngJPaAiJTuTAtPqRVzPRD>\ngJPdAePF`Rnj`NlFJ\\xLTwdB>\ngJPdAiPJ`Rfj`NlFI\\xLTwa|>\ngJPdAiPJ`Rfj`NlFIlxLTwR|P`>\ngJPdAiPJ`Rfj`NlFIlxLTwaB>\ngJPdHaBFDRij`NlFN\\dLTyoLD>\ngJPdHaVFlRij`NlFNksA@>\ngJPdI`xJ`RVj`NmEIkh^HP>\ngJPeI`VIDTiKUPGVbdutODH>\ngJPh@iPIMuHGVcdh\ngJPh@iPIMuHGVcdmx^`\ngJPh@iPIMuPGVcdmxP`\ngJPhAePIWUPGQCEIkjAHP>\ngJPhAePIWUPGQCEIlxLTwTBP`>\ngJPhAePIWUPGQCIIkjAHP>\ngJPhAePIWUPGQCIIlxLTwTBP`>\ngJPhAePIWUPGQCIIlxL\\wTBP`>\ngJPhDPDIMuTbGRcd<\ngJPhE`DIMsPGVcdmxP`\ngJPhHaVITuPGQCGQ[kAHP>\ngJPhI`xIKTpGVbdmtODH\ngJPhIaVIKTpGVbdmxP`\ngJPhIaVIKTpGVbdmx_@\ngJPhLPDIKTpGRbd\ngJPhLQDIKTpGRbd\ngJPhLQxIKTpGRbf|G`\ngJPhaePRUrTuTAu`qK]KqB>\ngJPhaePRUrTuTAu`qM]KqB>\ngJPhaePRUrTuTAu`qMgAbfzWbD>\ngJPi@cPGdfVhCkQSkNbgMu`gp\ngJPiLPDGdejXCiQR\ngJQ@@dlp@]RMumgX=\ngJQ@@dlp@]RMumgh\ngJQ@@dlp@]RMungh=\ngJQ@@dls@]FJ\\enmta@\ngJQ@@dls@]FJ\\eoBD\ngJQ@@dls@]FJ\\foBD\ngJQ@@dls@]JJkk[OP\ngJQ@@dls@]JJkk]Np\ngJQ@@dls@]JJkk]OP\ngJQ@@dlu@]FJ\\enlDa@\ngJQ@@dluQH]FJ\\enlD~@<\ngJQ@@dluQH]FJ\\enlD~@>\ngJQ@@dmP@]RMumgX=\ngJQ@@dmP@]RMumgh\ngJQ@@dmP@]RMungh=\ngJQ@@dmP@]RN\\FJ[k]OP\ngJQ@@dmP@]RN\\FN[k[OP\ngJQ@@dmS@]FJ\\enmta@\ngJQ@@dmS@]FJ\\eoBD\ngJQ@@dmS@]FJ\\eoCx\ngJQ@@dmS@]FJ\\es`qS][iB\ngJQ@@dmS@]FJ\\es`qs][iB\ngJQ@@dmS@]FJ\\es`qs^DH\ngJQ@@dmS@]FJ\\es`qs^Gp\ngJQ@@dmS@]FJ\\fnmta@\ngJQ@@dmS@]FJ\\foBD\ngJQ@@dmS@]JJkk[OP\ngJQ@@dmS@]JJkk]OP\ngJQ@@dmS@]JJlxL\\wVz^`\ngJQ@@dmU@]FJ\\enlDa@\ngJQ@@dmU@]FJ\\enlDaIHx`\ngJQ@@dmU@]FJ\\enmx~@\ngJQ@@dmU@]FJ\\erPqSfzpRD\ngJQ@@dmU@]FJ\\erPqSfzpRG|dcb\ngJQ@@dmU@]FJ]FnlDa@\ngJQ@@dmUQH]FJ\\enlD~@<\ngJQ@@dmUQH]FJ\\enlD~@>\ngJQ@@dmUQH]FJ\\enlD~IHx`>\ngJQ@@dmUQH]FJ\\es`qS]XIB<\ngJQ@@dmUQH]FJ\\es`qS]XIB>\ngJQ@@dmUQH]FJ\\es`qS]XI|<\ngJQ@@dmUQH]FJ\\es`qS]XI|>\ngJQ@@dmUQH]FJ\\es`qs]XI|<\ngJQ@@dmUQH]FJ\\es`qs]XI|>\ngJQ@@dmUQH]FJ\\fnlDa@<\ngJQ@@dmUQH]FJ\\fnlDa@>\ngJQ@@dmUQH]FJ\\fs`qS]XIB<\ngJQ@@dmUQH]FJ\\fs`qS]XIB>\ngJQ@@drt`]FJ\\enlD}@\ngJQ@@drt`]FJ\\enmx}@\ngJQ@@drt`]FJ\\eoLD\ngJQ@@drt`]FJ\\eoMx\ngJQ@@drt`]FJ\\eshis]XIz\ngJQ@@drt`]FJ\\eshis][qz\ngJQ@@drt`]FJ\\eshis^XH\ngJQ@@drt`]FJ\\eshis^[p\ngJQ@@drt`]FJ]EnlD}@\ngJQ@@drt`]FJ]EoLD\ngJQ@@drt`]FJ]Eshis]XIz\ngJQ@@drt`]FJ]Eshis^XH\ngJQ@@dru@]FJ\\enlDa@\ngJQ@@dru@]FJ\\enlD~@\ngJQ@@dru@]FJ\\enmxa@\ngJQ@@dru@]FJ\\eshis]XIB\ngJQ@@dru@]FJ\\eshis]XI|\ngJQ@@dru@]FJ\\eshis][qB\ngJQ@@dru@]FJ\\eshis][q|\ngJQ@@dru@]FJ\\fnlDa@\ngJQ@@dru@]FJ]EnlDa@\ngJQ@@dru@]FJ]EnlD~@\ngJQ@@dru@]FJ]Eshis]XIB\ngJQ@@dru@]FJ]Eshis]XI|\ngJQ@@dru@]FJ]FnlDa@\ngJQ@@dsR`]FJ\\e@\ngJQ@@dsR`]FJ\\eoCt\ngJQ@@dsR`]FJ\\eoMt\ngJQ@@dsR`]FJ\\eshir\ngJQ@@dsR`]FJ\\eshis][iz\ngJQ@@dsR`]FJ\\eshis^Gh\ngJQ@@dsR`]FJ\\eshis^[h\ngJQ@@dsR`]ZRRwPwm`\ngJQ@@dsR`]ZRRwpwmgh\ngJQ@@dsTrH]FJ\\enlD}@<\ngJQ@@dsTrH]FJ\\enlD}@>\ngJQ@@dsTrH]FJ\\eoLD<\ngJQ@@dsTrH]FJ\\eoLD>\ngJQ@@dsTrH]FJ\\eoMx<\ngJQ@@dsTrH]FJ\\eoMx>\ngJQ@@dsTrH]FJ\\erPqSfzpSt>\ngJQ@@dsTrH]FJ\\erPqSf|pP<\ngJQ@@dsTrH]FJ\\erPqSf|pP>\ngJQ@@dsTrH]FJ\\eshis]XIz<\ngJQ@@dsTrH]FJ\\eshis]XIz>\ngJQ@@dsTrH]FJ\\eshis][qz<\ngJQ@@dsTrH]FJ\\eshis][qz>\ngJQ@@dsTrH]FJ\\eshis^XH<\ngJQ@@dsTrH]FJ\\eshis^XH>\ngJQ@@dsTrH]FJ\\eshis^[p<\ngJQ@@dsTrH]FJ\\eshis^[p>\ngJQ@@dsURH]FJ\\enlDa@<\ngJQ@@dsURH]FJ\\enlDa@>\ngJQ@@dsURH]FJ\\enlD~@<\ngJQ@@dsURH]FJ\\enlD~@>\ngJQ@@dsURH]FJ\\enmxa@<\ngJQ@@dsURH]FJ\\enmxa@>\ngJQ@@dsURH]FJ\\enmx~@>\ngJQ@@dsURH]FJ\\erPqSfzpRD<\ngJQ@@dsURH]FJ\\erPqSfzpRD>\ngJQ@@dsURH]FJ\\erPqSfzpSx<\ngJQ@@dsURH]FJ\\erPqSfzpSx>\ngJQ@@dsURH]FJ\\erPqSfzwbD>\ngJQ@@dsURH]FJ\\erPqSfzwcx>\ngJQ@@dsURH]FJ\\es`qs]XIB<\ngJQ@@dsURH]FJ\\es`qs]XIB>\ngJQ@@dsURH]FJ\\es`qs]XI|<\ngJQ@@dsURH]FJ\\es`qs]XI|>\ngJQ@@dsURH]FJ\\es`qs][qB<\ngJQ@@dsURH]FJ\\es`qs][qB>\ngJQ@@dsURH]FJ\\eshis]XIB<\ngJQ@@dsURH]FJ\\eshis]XIB>\ngJQ@@dsURH]FJ\\eshis]XI|<\ngJQ@@dsURH]FJ\\eshis]XI|>\ngJQ@@dsURH]FJ\\eshis][qB<\ngJQ@@dsURH]FJ\\eshis][qB>\ngJQ@@dsURH]FJ\\eshis][qC~RAQ@>\ngJQ@@dsURH]FJ\\eshis][q|<\ngJQ@@dsURH]FJ\\eshis][q|>\ngJQ@@dsURH]FJ\\fnlDa@<\ngJQ@@dsURH]FJ\\fnlDa@>\ngJQ@@dsURH]FJ\\frPqSfzpRD<\ngJQ@@dsURH]FJ\\frPqSfzpRD>\ngJQ@@dsURH]FJ\\fs`qs]XIB<\ngJQ@@dsURH]FJ\\fs`qs]XIB>\ngJQ@@dsURH]FJ\\fshis]XIB<\ngJQ@@dsURH]FJ\\fshis]XIB>\ngJQ@@dsURH]FJ\\fshis][qB<\ngJQ@@dsURH]FJ]EnlDa@<\ngJQ@@dsURH]FJ]EnlDa@>\ngJQ@@dsURH]FJ]Es`qs]XIB<\ngJQ@@dsURH]FJ]Es`qs]XIB>\ngJQ@@dsURH]FJ]Es`qs]XI|<\ngJQ@@dsURH]FJ]Es`qs]XI|>\ngJQ@@dsURH]FJ]Eshis]XIB<\ngJQ@@dsURH]FJ]Eshis]XIB>\ngJQ@@dsURH]FJ]Eshis]XI|<\ngJQ@@dsURH]FJ]FnlDa@>\ngJQ@@dwM@]FJ\\eneta@\ngJQ@@dwM@]FJ\\eoBD\ngJQ@@dwM@]FJ\\es`is]KiB\ngJQ@@dwM@]FJ\\eshis]KiB\ngJQ@@dwM@]FJ\\eshis]Ki|\ngJQ@@dwM@]FJ\\eshis^DH\ngJQ@@dwM@]FJ\\eshis^Gp\ngJQ@@dwM@]FJ\\foBD\ngJQ@@dwM@]ZVRwpvmdH\ngJQ@@dwM@]ZVRwpvndH\ngJQ@@dwM@]ZVRytTyoam]HP\ngJQ@@dwM@]ZVRytTyoam]O`\ngJQ@@eMP@]HJ[yAvsl=\ngJQ@@eMP@]HJ[yAvst\ngJQ@@eMP@]HJ[yAwSt=\ngJQ@@eMP@]HJ[y^vsl=\ngJQ@@eMP@]HJ[y^vst\ngJQ@@eMP@]HJ[y^wSt=\ngJQ@@eMP@]HJ\\xLTwrCngh\ngJQ@@eMP@]HJ\\xLTwr}ngh\ngJQ@@eMP@]HJ\\xL\\wrCmgh\ngJQ@@eMP@]HJ\\xL\\wr}mgh\ngJQ@@eMP@]HJkyAvsl=\ngJQ@@eMP@]HJkyAvst\ngJQ@@eMP@]HJkyAwSt=\ngJQ@@eMP@]HJlxLTwrCngh\ngJQ@@eMP@]HJlxL\\wrCmgh\ngJQ@@eMS@]TLTyK]HIB\ngJQ@@eMS@]TLTyK]HI|\ngJQ@@eMS@]TLTyK_HNzP`\ngJQ@@eMS@]TLTyK_HNzPdd\\P\ngJQ@@eMS@]TLTyK_HNz_@\ngJQ@@eMS@]TLTyKgAbfzPRD\ngJQ@@eMS@]TLTyKgAbfzPSx\ngJQ@@eMS@]TLTyKgAbfzWbD\ngJQ@@eMS@]TLTyKgAbf~P]ta@\ngJQ@@eMS@]TLTyKgAbf~P]t~@\ngJQ@@eMS@]TLTyKgAbf~Wmta@\ngJQ@@eMS@]TLTyKgAbf~Wmt~@\ngJQ@@eMS@]TLTyKgAcfzPRD\ngJQ@@eMS@]TLTyKgAcf~P]ta@\ngJQ@@eMS@]TLTyKgAcf~Wmt~@\ngJQ@@eMS@]TLTyM]HIB\ngJQ@@eMS@]TLTyM_HNzP`\ngJQ@@eMS@]TLTyMgAbfzPRD\ngJQ@@eMS@]TLTyMgAbfzWbD\ngJQ@@eMS@]TLTyMgAbf~P]ta@\ngJQ@@eMS@]TLTyMgAbf~Wmta@\ngJQ@@eMS@]TLTyMgAcf~P]ta@\ngJQ@@eMS@]TLUYK]HIB\ngJQ@@eMS@]TLUYK_HNzP`\ngJQ@@eMS@]TLUYKgAbfzPRD\ngJQ@@eMS@]TLUYKgAbf~P]ta@\ngJQ@@eMS@]TLUYKgAbf~P]t~@\ngJQ@@eMS@]TLUYKgAcfzPRD\ngJQ@@eMS@]TLUYKgAcf~P]ta@\ngJQ@@eMS@]TLUYM_HNzP`\ngJQ@@eMS@]TLUYMgAbfzPRD\ngJQ@@eMS@]TLUYMgAbf~P]ta@\ngJQ@@eMS@]XLdwrCmgh\ngJQ@@eMS@]XLdwrCngX\ngJQ@@eMS@]XLdwrCngh\ngJQ@@eMS@]XLdypXiodG]OP\ngJQ@@eMS@]XLdypXyodG[OP\ngJQ@@eMS@]XLdypXyodG]OP\ngJQ@@eMS@]XLeYpXiodG]OP\ngJQ@@eMS@]XLeYpXyodG[OP\ngJQ@@eMU@]TLTyK_HNBP`\ngJQ@@eMU@]TLTyK_HNBPdd\\P\ngJQ@@eMU@]TLTyK_HN|_@\ngJQ@@eMU@]TLTyK_KvBP`\ngJQ@@eMU@]TLTyKdabgM|`xIB\ngJQ@@eMU@]TLTyKdabgM|oXIB\ngJQ@@eMU@]TLTzM_HNBP`\ngJQ@@eMU@]TLUYK_HNBP`\ngJQ@@eMU@]TLUYK_HNBPdd\\P\ngJQ@@eMURH]TLTyK_HNB_@<\ngJQ@@eMURH]TLTyK_HNB_@>\ngJQ@@eMURH]TLTyK_HNB__dd\\P<\ngJQ@@eMURH]TLTyK_HNB__dd\\P>\ngJQ@@eMURH]TLTyK_KvB_@<\ngJQ@@eMURH]TLTyKdabgM|`xI|<\ngJQ@@eMURH]TLTyKdabgM|`xI|>\ngJQ@@eMURH]TLTyKgAbf~P\\Da@<\ngJQ@@eMURH]TLTyKgAbf~P\\Da@>\ngJQ@@eMURH]TLTyKgAbf~P\\D~@<\ngJQ@@eMURH]TLTyKgAbf~P\\D~@>\ngJQ@@eMURH]TLTyKgAbf~WlDa@<\ngJQ@@eMURH]TLTyKgAbf~WlDa@>\ngJQ@@eMURH]TLTyKgAcf~P\\D~@<\ngJQ@@eMURH]TLTyKgAcf~P\\D~@>\ngJQ@@eMURH]TLTyKgAcf~WlD~@<\ngJQ@@eMURH]TLTyKgAcf~WlD~@>\ngJQ@@eMURH]TLTyM_HNBP`<\ngJQ@@eMURH]TLTyM_HNBP`>\ngJQ@@eMURH]TLTyMgAbf~P\\Da@<\ngJQ@@eMURH]TLTyMgAbf~P\\Da@>\ngJQ@@eMURH]TLTyMgAbf~WlDa@<\ngJQ@@eMURH]TLTyMgAbf~WlDa@>\ngJQ@@eMURH]TLTyMgAcf~P\\Da@<\ngJQ@@eMURH]TLTyMgAcf~P\\Da@>\ngJQ@@eMURH]TLTzK_HNB_@<\ngJQ@@eMURH]TLTzK_HNB_@>\ngJQ@@eMURH]TLTzKgAcf~P\\D~@<\ngJQ@@eMURH]TLTzKgAcf~P\\D~@>\ngJQ@@eMURH]TLTzMgAbf~P\\Da@<\ngJQ@@eMURH]TLTzMgAbf~P\\Da@>\ngJQ@@eMURH]TLUYKgAbf~P\\Da@<\ngJQ@@eMURH]TLUYKgAbf~P\\Da@>\ngJQ@@eMURH]TLUYKgAbf~P\\D~@<\ngJQ@@eMURH]TLUYKgAcf~P\\D~@<\ngJQ@@eMURH]TLUYKgAcf~P\\D~@>\ngJQ@@eMURH]TLUYM_HNBP`<\ngJQ@@eMURH]TLUYM_HNBP`>\ngJQ@@eMURH]TLUYMgAbf~P\\Da@<\ngJQ@@eMURH]TLUYMgAbf~P\\Da@>\ngJQ@@eMURH]TLUZKgAcf~P\\D~@<\ngJQ@@eMURH]TLUZKgAcf~P\\D~@>\ngJQAAIRYjPNcENRytTyoLD>\ngJQAAIRYjPNcENbwVB^`>\ngJQAAIRYjPNcENbypXynlD}@>\ngJQDAJATBTuTAtPqtZzpRD\ngJQDHHPpbU]TAu`isdabgMy``>\ngJQDL@aABSKTAuhiK^DH\ngJQDL@aABS[TAuhyK^DH\ngJQH@jAJZ`@z`[k[OP\ngJQH@jAJZ`@z`[k]OP=\ngJQH@jAJZ`@z`[y^vsl=\ngJQH@jAJZ`@z`[y^vst\ngJQH@jAJZ`@z`[y^wSt=\ngJQH@jAJZ`@z`\\xLTwr}ngh\ngJQH@jAJZ`@z`\\xL\\wVv^`\ngJQH@jAJZ`@z`\\xL\\wr}mgh\ngJQH@jAJZf@zHXyKgAbfzWbD\ngJQH@jAJZf@zHXyMgAbfzWbD\ngJQH@jAJZf@zHXyMgAbf~Wmta@\ngJQH@jAJZj@zHXyK]XIB\ngJQH@jAJZjdPzHXyKgAbfzpRD<\ngJQH@jAJzj@zhXitZ~`\\Da@\ngJQHB@aIfe@zTdwPwm`\ngJQHB@aInZ@zTlwPvm`\ngJQHB@aInZ@ztTyoEt\ngJQHBDQIfjdPztTyoLD<\ngJQHBHaIfjdPztTyoLD<\ngJQHBHaIfjdPztTyoLD>\ngJQHBIAIfjdPztTyoLD>\ngJQHBOAIfjdPztTyna{A@<\ngJQHD@aIej@zLTzKgQSfzpRD\ngJQHD@aIff@zLTyKgQSfzwRD\ngJQHD@aIff@ztdeoao[HP\ngJQHD@aIfjdPzLTyKgQSfzpRD<\ngJQHD@aIfjdPzLTyKgQSfzpRD>\ngJQHDIAIfjdPzLTyKgQSfzpRD<\ngJQHH@aIZ`@zd[x^vsl=\ngJQHH@aIZ`@zd[x^vst\ngJQHH@aIZ`@zd[x^wSt=\ngJQHH@aIZ`@zd\\xL\\wp}mgh\ngJQHH@aIZf@zLTyK]CqB\ngJQHH@aIZf@zLTyK_CvzP`\ngJQHH@aIZf@zLTyKgAbfzGbD\ngJQHH@aIZf@zLTyM_CvzP`\ngJQHH@aIZj@zLTyK_CvBP`\ngJQHH@aIZjbPzLTyK_CvB_@<\ngJQHH@aJmj`PzHTyK]XIB<\ngJQHH@aJmj`PzHTyK]XIB>\ngJQHH@aJmj`PzHTyKgQSfzpRD<\ngJQHH@aJmj`PzHTyKgQSfzpRD>\ngJQHH@aJmj`PzHTyM]XIB<\ngJQHH@aJmj`PzHTyM]XIB>\ngJQHH@aJmj`PzHTzK]XIB<\ngJQHH@aJmj`PzHTzK]XIB>\ngJQHH@aJmj`PzHTzM]XIB>\ngJQHHBqIZ`@zd\\xLTwp}ngh\ngJQHHGAIZ`@zd[x^vsl=\ngJQHHGAIZ`@zd[x^vst\ngJQHHGAIZ`@zd[x^wSt=\ngJQHHGAIZ`@zd\\xLTwVz^`\ngJQHHGAIZ`@zd\\xL\\wVv^`\ngJQHHGAIZf@zLTyK]CqB\ngJQHHGAIZf@zLTyK_CvzP`\ngJQHHGAIZj@zLTyK_CvBP`\ngJQHHGAIZjbPzLTyK_CvB_@<\ngJQHHGAIZjbPzLTyK_CvB_@>\ngJQHHGAIZjbPzLTyKgAbf~GlDa@>\ngJQHHGAIZjbPzLTyM_CvBP`<\ngJQHHGAIZjbPzLTyM_CvBP`>\ngJQHHOAIZ`@zd[k[Np=\ngJQHHOAIZ`@zd[k[OP\ngJQHHOAIZ`@zd[k]OP=\ngJQHHOAIZ`@zd[x^vsl=\ngJQHHOAIZ`@zd[x^vst\ngJQHHOAIZ`@zd[x^wSt=\ngJQHHOAIZ`@zd\\xLTwVz^`\ngJQHHOAIZ`@zd\\xLTwp}ngh\ngJQHHOAIZ`@zd\\xL\\wVv^`\ngJQHHOAIZ`@zd\\xL\\wp}mgh\ngJQHHOAIZf@zLTyM_CvzP`\ngJQHHOAIZj@zLTyK]XIB\ngJQHHOAIZj@zLTyK_CvBP`\ngJQHHOAIZjbPzLTyKgAbf~GlDa@<\ngJQHHOAIZjbPzLTyKgAbf~GlDa@>\ngJQHHOAIZjbPzLTyMgAbf~GlDa@>\ngJQHHOAIZjbPzLTzKgAcf~GlD~@>\ngJQHL@aIZf@ztTeoBD\ngJQHL@aIZf@ztTfnaxa@\ngJQHL@aIZf@ztTfoBD\ngJQHL@aIZjb`ztTeoBD<\ngJQHL@aIZjb`ztTeoBD>\ngJQHL@aIZjb`ztTes`qs^DH<\ngJQHL@aIZjb`ztTes`qs^DH>\ngJQHL@aJZf@zHXiK]HIB\ngJQHL@aJZf@zHXiK]HI|\ngJQHL@aJZf@zHXiK]KqB\ngJQHL@aJZf@zHXiM]HIB\ngJQHL@aJZf@zHXjK]HIB\ngJQHL@aJZf@zHXjK]HI|\ngJQHL@aJZf@zHXjM]HIB\ngJQHL@aJZjdPzHXiK]HIB<\ngJQHL@aJZjdPzHXiK]HIB>\ngJQHL@aJZjdPzHXjK]HIB<\ngJQHL@aJZjdPzHXjK]HIB>\ngJQHLHaIZf@ztTeoBD\ngJQHLHaIZf@ztTfoBD\ngJQHLHaIZjb`ztTeoBD<\ngJQHLHaIZjb`ztTeoBD>\ngJQHLJqIZjb`ztTeoBD>\ngJQHLLQIZf@ztTfoBD\ngJQH`jBRnRfj`NbFNSYpXioe{AHP>\ngJQI@jA\\eMP@]PN\\FJ[y^wSt\ngJQI@jA\\eMP@]PN\\FN[y^vst\ngJQI@jA\\eMS@]DL\\fs`qS]KqB\ngJQI@jA\\eMS@]DL\\fs`qS_KvzP`\ngJQIHO@RdmP@]RM|O[Yv=\ngJQ`@bdvu@]JNP\ngJQ`@ldru@]ZJRwaB\ngJQ`@ldru@]ZJRwa|\ngJQ`@ldru@]ZJRytTyoBD\ngJQ`@ldru@]ZJRytTyoCx\ngJQ`@ldru@]ZJSWaB\ngJQ`AbeMU@]XLTyHXis^HH\ngJQa@bnR[Z`NeGH\ngJQdAcJATBTuTAt`qs`qR>\ngJQeAcJATByJZj@zPXypXioEx>\ngJQhAbjAJzj@zpXioHD\ngJQhAbjAJzj@zpYIoHD\ngJQhAbjAJzj@zpYIs`qS^PH>\ngJQhHl@aJmj`PzpTeshis^DH<\ngJQhHl@aJmj`PzpTeshis^DH>\ngJQhHlOAJfj@zpXeoBD\ngJQhHlOAJfj@zpXerPqSf|HP\ngJQhHlOAJfj@zpXfoBD\ngJQhHlOAJfj`PzpXfs`qs^DH<\ngJQhHlOAJfj`PzpXfs`qs^DH>\ngJR@@lTfVhCiRS]C^w~tP\ngJR@@lTfphCjYnam[ZX=\ngJR@ALTkfXCiAU][Yw~t@\ngJR@ALTkfXCiAU][Y{~t@\ngJR@`lQJyIej@zTdwPwmmD\ngJR@`lQJyIej@zTdwPwnmD\ngJR@`lQJyIej@zTdwP{nmD\ngJR@`lUqeIej@zTdwPwmmD\ngJR@`l]qeIlJ@zf[h[Vvf@=\ngJRA@lQJSKTAthiZH\ngJRA@lUrSKTAtiInao[ZH\ngJRA@lUrSKTAtiInao]ZH\ngJRAALSrUsLAt`jnml{Z@\ngJRAAL]JUsLAt`jnmt}Z@\ngJT@@TfRDCjInao[@\ngJT@@TfVhCkQSf|pP\ngJT@@TfVhCkQSkNbgMtNxH\ngJT@@TfZjQCkQSf|pP<\ngJT@@TfZjQCkQSf|pP>\ngJT@@TfZjQCkQSgNCGMy``<\ngJT@@TfZjQCkQSgNCGMy``>\ngJT@@TfZjQCkQSgNbgMy``<\ngJT@@TfZjQCkQSgNbgMy``>\ngJT@@TfZjQCkQSkNCGMy``<\ngJT@@TfZjQCkQSkNCGMy``>\ngJT@@TfphCjYnam[@\ngJT@@TfphCjYnam]@\ngJT@@TfyhCiRs]CZv\ngJT@@TfyhCiRs]CZz\ngJT@@TfyhCiRs]Cjv\ngJT@@TfyhCiRs]Cjz\ngJT@@TfyhCiRsgASfzGUl\ngJT@@TfyhCiRsgQSfzGUt\ngJT@@TjZhChabgMt`xH\ngJT@@TjZhChabgMt`xO{P@=\ngJT@@TjZhChabgMt`{w{P@\ngJT@@TjZhChabgNRFJ\\wRC``\ngJT@@TjZhChabgNRFJ\\wrC`gp\ngJT@@TjZhChabgN\\EN[iAwov`@\ngJT@@TjZhChabgN\\FN[iAp_v`@\ngJT@@TjZhChabgUt`xO{P@\ngJT@@TjZhChabgV\\FN[iAp_v`@\ngJT@@TjZhCiBc]K^w~t@=\ngJT@@TjZhCiBc]K^{~t@\ngJT@@TjZhCiBcgASfzV}w}h@\ngJT@@TjZjAChabgN\\FN[iApP<\ngJT@@TjZjAChabgN\\FN[iApP>\ngJT@@TjZjAChabgN\\FN[iAw`<\ngJT@@TjZjAChabgN\\FN[iAw`>\ngJT@@TjZjAChabgVRFJ\\wRC``<\ngJT@@TjZjAChabgVRFJ\\wRC``>\ngJT@@TjZjAChabgV\\FN[iApP>\ngJT@@defhChqSdmu`dO{Q@=\ngJT@@defhChqSdn\\FJ[kAH_vb@\ngJT@@defhChqSdv\\FJ[kAH_vb@\ngJT@@dfRHCiIK_C^vPmD\ngJT@@dfRHCiIK_C^zPmD\ngJT@@dfRHCiIK_CnvPmD\ngJT@@dfRHCiIKgQSf~F}taZH\ngJT@@dfRHCiIM_C^vPmD\ngJT@@dfRHCiIM_C^zPmD\ngJT@@dfRHCiIMgQSf~F}taZH\ngJT@@dfVhChqSdmu`dO{Q@\ngJT@@dfVhChqSdn\\FN[kAH_vb@\ngJT@@dfVhChqSdn\\FN[k^H_vb@\ngJT@@dfVhChqSdn]EN[x]pRG}h`\ngJT@@dfVhChqSduu`dO{Q@\ngJT@@dfVhChqSduuoDO{Q@\ngJT@@dfVhChqSdu|NxIC~tP\ngJT@@dfVhChqSdv\\FN[kAH_vb@\ngJT@@dfVhChqShmu`dO{Q@\ngJT@@dfVhChqShmu`gw{Q@\ngJT@@dfVhChqShn\\FN[kAH_vb@\ngJT@@dfVhChqShuu`dO{Q@\ngJT@@dfVhChqShu|NxIC~tP\ngJT@@dfVhChqShv\\FN[kAH_vb@\ngJT@@dfVhCkRRV~F}laZH\ngJT@@dfVhCkRRV~F}taZH\ngJT@@dfVhCkRRWNbgM|M{iC~tP\ngJT@@dfVhCkRRZ~F}taZH\ngJT@@dfphCiYK_CZvP`=\ngJT@@dfvdCkQrWNBgH\ngJT@@dfvdCkQrWNbgH\ngJT@@dfvdCkRrVzFut\ngJT@@dfvhCkQrV|HP\ngJT@@dfvhCkQrWNbgMxP`\ngJT@@dfvhCkQrZzGRD\ngJT@@dfvhCkQrZ|HP\ngJT@@dfvhCkRrV~Fula@\ngJT@@dfvhCkRrV~Futa@\ngJT@@dfvhCkRrZ~Fula@\ngJT@@dfvhCkRrZ~Futa@\ngJT@@dfzhCkQrV|HP\ngJT@@dfzhCkQrWICEN[pa@\ngJT@@dfzjQCkQrWNBgMxP`<\ngJT@@dfzjQCkQrWNBgMxP`>\ngJT@ADiihCjabgI[kAH_vP`=\ngJT@ADiihCjabgI[kAOovP`\ngJT@ADiihCjabgI[y]pRG}dH=\ngJT@ADiihCjabgI\\xLTwVBPla@\ngJT@ADiihCjabgI\\xLTwr{`dO{HP\ngJT@ADiihCjabgIkkAH_vP`\ngJT@ADiihCjabgIlxLTwr{`dO{HP\ngJT@ADiihCjabgQkkAH_vP`=\ngJT@ADiihCkAdfzvso}dH=\ngJT@ADiihCkAdfzwSw}dH=\ngJT@ADiihCkAdgNCEM|n{i{~rD@\ngJT@ADiihCkAdgNCGM|n{Y{~rD@\ngJT@ADjZhCjabgI[yApRG}dH=\ngJT@ADjZhCjabgI[yApRG}h@=\ngJT@ADjZhCjabgI[yApRG}i@\ngJT@ADjZhCjabgI[yAwbG}dH\ngJT@ADjZhCjabgI\\xL\\wrC`dO{P@\ngJT@ADjZhCjabgIkyApRG}dH=\ngJT@ADjZhCjabgQ[yApRG}dH\ngJT@ADjZhCjabgQkyApRG}dH\ngJT@ADjZhCkBbV~W]taYB@=\ngJT@ADjzhChaSdmu`dO{P@\ngJT@ADjzhChaSdn\\FN[kAH_v`@\ngJT@ADjzhChaSdn]EN[kAH_v`@\ngJT@ADjzhChaSduu`dO{P@\ngJT@ADjzhChaShmu`dO{P@\ngJT@ADjzhCkBRV~f}laZ@\ngJT@ADjzhCkBRV~f}l~Z@\ngJT@ADjzhCkBRV~f}taZ@\ngJT@ADjzhCkBRWNbgM}M{iC~t@\ngJT@ADjzhCkBRZ~f}laZ@\ngJT@ADjzhCkBRZ~f}taZ@\ngJT@ADjzjAChaSdmu`dH<\ngJT@ADjzjAChaSdmu`dH>\ngJT@ADjzjAChaSdn]EN[kAHP<\ngJT@ADjzjAChaSdn]EN[kAHP>\ngJT@ADjzjAChaSduu`dH<\ngJT@ADjzjAChaSduu`dH>\ngJT@ADkf@CjAnml{Z@=\ngJT@ADkf@CjAnml}Z@\ngJT@ADkf@CjAnmt}Z@=\ngJT@ADkf@CjAoiw[Nv`@=\ngJT@ADkf@CjAoiw[O_v`@\ngJT@ADkf@CjAoiw]O_v`@=\ngJT@ADkfXChaSdmundO{P@\ngJT@ADkfXChaSduundO{P@\ngJT@ADkfXCiAU][i{~t@\ngJT@ADkj@CjAnml{Z@=\ngJT@ADkj@CjAnml}Z@\ngJT@ADkj@CjAnmt}Z@=\ngJT@ADkjXChaSdmundO{P@\ngJT@AdefdCiQU][Yv\ngJT@AdefdCiQU][Yz\ngJT@AdefdCiQU][iv\ngJT@AdefdCiQUgAbf~G]t}@\ngJT@Adii@CiAS][Yw~t@\ngJT@Adii@CiAS_Knv]m@\ngJT@Adii@CiASgAbf~W]t{Z@\ngJT@Adii@CiASgAcf~W]l}Z@\ngJT@AdiiXChabdmtngw{P@\ngJT@AdiiXChabdv\\FJ[y]wRG}h@\ngJT@AdiiXChabdv\\FN[y]wRG}h@\ngJT@AdiidChabdn\\FN[i]O_v`@\ngJT@AdiidChabdn\\FN[q]Z@\ngJT@AdiidCkAdfzwSo}h@\ngJT@AdiidCkAdfzwSw}h@\ngJT@AdiidCkAdgNCEM|n{i{~t@\ngJT@AdiidCkAdgNCGMumgo{P@\ngJT@AdiidCkAdgNCGMungo{P@\ngJT@AdiidCkAdgNCGM|n{Y{~t@\ngJT@AdiidCkAdgNCGM|n{i{~t@\ngJT@AdijdChabdmt`go{P@\ngJT@AdijdChabdn\\FJ[iAO_v`@\ngJT@AdijdChabdn\\FN[iAO_v`@\ngJT@AdijdChabdn\\FN[qAZ@\ngJT@AdijdCkAdf~P]t{Z@\ngJT@AdijdCkAdf~P]t}@\ngJT@AdijdCkAdf~Wmt}@\ngJT@AdijdCkAdgNCEM|`{iz\ngJT@AdijdCkAdgNCGM|`{Y{~t@\ngJT@AdijdCkAdgNCGM|`{iz\ngJT@AdijjQChabdmt`dO{P@<\ngJT@AdijjQChabdmt`dO{P@>\ngJT@AdijjQChabdnRFJ\\wRBP`>\ngJT@AdijjQChabdv\\FJ[iAHP<\ngJT@AdijjQChabdv\\FJ[iAH_v`@<\ngJT@AdijjQChabdv\\FJ[iAH_v`@>\ngJT@AdijjQChabhmt`dO{P@<\ngJT@AdijjQChabhv\\FJ[iAH_v`@<\ngJT@AdijjQChabhv\\FJ[iAH_v`@>\ngJT@`QIeIfjdPztTys`qs^XH>\ngJT@`QIeIlJ@zf[h[Vp\ngJT@`aJyIdb@zRRypXyoaw[H_vb@\ngJT@`aJyIdb@zRRytTyoaw]H_vb@\ngJT@aAteJz`@z`[k[Nv`@=\ngJT@aAteJz`@z`[k[O_v`@\ngJT@aAteJz`@z`[k]O_v`@=\ngJT@aAteJzj@zHTyK]XIC~t@\ngJTA@QJSIBAuDwPwm`\ngJTA@QJSMUHauhis^XH<\ngJTA@QJSMUHauhis^XH>\ngJTA@QJSXTAuLwPvm`\ngJTA@QJUMTAtPqSgICEN[iApP\ngJTA@SJSXTAuLwPvm`\ngJTA@SJUMTAtPqSgICEN[iApP\ngJTA@SJUMTAtPqSgICEN[yApSx\ngJTA@aJRsTAtXirWNCEM|NxIC~tP\ngJTA@aJRsTAtXir[NCEM|NxIC~tP\ngJTA@aJSIDAtdeoao[H_vb@\ngJTA@aJSIDAtdeoaw[H_vb@\ngJTA@aJSIDAtdfoao[H_vb@\ngJTA@aJSKTAtXirWNbgMu`dO{Q@\ngJTA@aJS[RAuhyKgQSd\ngJTA@aJS[TAuiYK_CZvP`\ngJTA@aJS[TAuiYM_CjzP`\ngJTAAAJU[TAuaIK_S^vPm@\ngJTAAaJRuRAthjnml{@\ngJTAAaJRuUEAuhiK^DH>\ngJTD@UPZ`Rkj`NlFR\\zJ\\wdC~t@\ngJTDAePF`Rnj`NlFR\\xL\\wdC~t@>\ngJTDAiPJ`Rfj`NlFI\\xLTwaB>\ngJTDE`DGpRYZ`NeEMx__mD\ngJTDEaxR`RYj`NmEIlzJ\\waC~tP>\ngJTDLPDHHR[Z`NeGO{S@\ngJTDLPDPHRnh@NhFzvsl=\ngJTDLPDPHRni`NdEUumgX\ngJTDLPDPHRni`NdEUumgh\ngJTD`UPZ`DkdjzjACkAbgNbgMyO@<\ngJTD`UPZ`DkdjzjACkAbgNbgMyO@>\ngJTDe`DDHT{dfyhCiRs_CZv__mL\ngJTDlQVPHGZTejXCiQR\ngJTELPDPHtiWTpGRBd\ngJTHACPISSPGQCENlxL\\wr{`gw{HP\ngJTHAePIWUPGQCII\\xLTwTBPm@>\ngJTHDPDIMsPGRefzFul\ngJTHE`DILmHGVbdmx^mD\ngJTHE`DILmHGVbdn]EN[p}ZH\ngJTHE`DILmPGVbdmxPmD\ngJTHE`DILmPGVbdmx__mD\ngJTHE`DILmPGVbdn]EN[paZH\ngJTHE`DILmPGVbduxPmD\ngJTHE`DILmPGVbdv]EN[paZH\ngJTHE`DILthGVddmtM{_{Q@\ngJTHE`DILthGVddm|M{Y{~tP\ngJTHE`DILthGVddn]EN[x[wSw}h`\ngJTHE`DIMsPGVcdmxPmL\ngJTHE`DIMsPGVcdn]EN[paZX\ngJTHE`DIMsPGVcduxPmL\ngJTHE`DIMsPGVedm|MkYC~tp\ngJTHE`DIMsPGVedu|MkYC~tp\ngJTHEaDILthGVbdn]EN[p}ZH\ngJTHHPDILuPGVbgN]EN[h^p_vd@\ngJTHH`xIKUPGQbgI[x^pRD\ngJTHHaxILuHGQbgI[h^p_vTP\ngJTHI`DIKT@GTc_Cvv]mH\ngJTHI`DIKTpGRbj~Gml{ZP\ngJTHI`DIKUHGRbj~Gmt}ZP\ngJTHIaxIKT@GTc_Cvv]mH\ngJTHLPDIST@GRBf~P]l{@=\ngJTHLPDIST@GRBj~P]l{@=\ngJTHLPDISTpGVCEMx``\ngJTHLPDISTpGVCEN\\FJ[qA@\ngJTHLPDISTpGVCEN\\FN[iAwP\ngJTHLPDISTpGVCIM|`{Yv\ngJTHLPDISTpGVCIM|`{Yz\ngJTHLPDISTpGVCIN\\FN[yAvst\ngJTH`mPB]rS[TAuiYK_CjzP`\ngJTHe`DCeJS\\tAuhyKgQSf|H_vf@\ngJTHe`DJ]rS\\tAuiYKgQSf~FutaZX\ngJTHe`bCeJS\\tAuhyK]KiC~tp\ngJTHi`DSmJRu@AuHwp}mg_{R@\ngJTHlQxCmJTuLAu`rU_HNz^`\ngJTIE`DJTfyhCkRrV~FulaZX\ngJTILPDZTijXCkAbf|PP\ngJTIhaVCiJeJZ`@z`[k[Nvd@=\ngJTIhaVCiJeJZ`@z`[k]O_vd@=\ngJTIhabCiJeJZ`@z`[k[Nvd@=\ngJTIhabCiJeJZ`@z`[k]O_vd@=\ngJT`E`TfVhCiQR\ngJT`LPdfVhCiQR\ngJT`LPdfvhCiQs~tp\ngJT`i`iJyImi@zt\\eoCw}eL\ngJT`i`iJyImj@zt\\eoBG}eL\ngJT`i`iJyImj@zt\\foBG}eL\ngJTai`iJ{\\dvu@]ZNRwaC~rf@\ngJTai`iJ{\\dvu@]ZNSWaC~rf@\ngJU@DPdru@]ZJ\\wfC~tP\ngJU@DPdru@]ZJ\\wf}~tP\ngJU@DPdru@]ZJ\\ytTyoLG}h`\ngJU@DPdru@]ZJ]WfC~tP\ngJU@DPdru@]ZJ]YtTyoLG}h`\ngJU@DPdvt`]JN\\zJ\\`\ngJU@DPdvu@]JNP\ngJU@DPdvu@]JN\\zJ\\`\ngJU@E`drt`]ZJRwa{~tP\ngJU@E`drt`]ZJRytTyoCw}h`\ngJU@E`dru@]ZJRwaC~tP\ngJU@E`dru@]ZJRwa}~tP\ngJU@E`dru@]ZJRytTyoBG}h`\ngJU@E`dru@]ZJRytTyoC{}h`\ngJU@E`dru@]ZJSWaC~tP\ngJU@E`dru@]ZJSYtTyoBG}h`\ngJU@E`dwM@]ZVSWpvmdO{S@\ngJU@H`dlu@]FJ\\enlDaYQ@=\ngJU@H`dlu@]FJ\\fnlDaYQ@\ngJU@I`eMU@]XLdwrCmgo{R@\ngJU@LPdmS@]JJkk[Np\ngJU@LPdmS@]JJkk[OP\ngJU@LPdmS@]JJlxL\\wVv^`\ngJU@LPeMP@]HJ[yAvsl=\ngJU@LPeMP@]HJkyAvsl=\ngJU@LPeMS@]XLTwbB\ngJU@LPeMS@]XLUWbB\ngJU@LPeMU@]XLTwbB\ngJU@e`NTiMsPGVcdn]EN[paZX\ngJUADPYRYZ`NmENksAZH\ngJUADPYR[Z`NeGH\ngJUAE`nRYZ`NmEI\\zJ\\waC~tP\ngJUAE`nRYZ`NmEIlzJ\\waC~tP\ngJUAEanRYZ`NmEI[paZH\ngJUAEanRYZ`NmEI\\zJ\\waC~tP\ngJUDEhO@~BUMTAt`qIPh`\ngJUHEhOAJfj@zpXfoBG|eBb\ngJUHH\\@aIZf@zTTw`}~t`\ngJUHLPjAJzj@zpXioHD\ngJUIH\\@b\\dmS@]JJ[p^ZP\ngJX@@dlp@]RMumgX=\ngJX@@dlp@]RMumgh\ngJX@@dlp@]RMungh=\ngJX@@dlp@]RM|N{Yv=\ngJX@@dlp@]RM|N{Yz\ngJX@@dlp@]RN\\FJ[x]wSt\ngJX@@dlp@]RN\\FN[k[OP\ngJX@@dlp@]RN\\FN[x]vst\ngJX@@dls@]FJ\\enmta@\ngJX@@dls@]FJ\\eoBD\ngJX@@dls@]FJ\\foBD\ngJX@@dls@]JJkk[OP\ngJX@@dls@]JJkk]OP\ngJX@@dlu@]FJ\\enlDa@\ngJX@@dmP@]RMumgX=\ngJX@@dmP@]RMumgh\ngJX@@dmP@]RMungh=\ngJX@@dmP@]RN\\FJ[k]OP\ngJX@@dmP@]RN\\FN[k[OP\ngJX@@dmP@]RN\\FN[x^vst\ngJX@@dmS@]FJ\\enmta@\ngJX@@dmS@]FJ\\eoBD\ngJX@@dmS@]FJ\\es`qS][iB\ngJX@@dmS@]FJ\\es`qS^DH\ngJX@@dmS@]FJ\\es`qs][iB\ngJX@@dmS@]FJ\\es`qs^DH\ngJX@@dmS@]FJ\\foBD\ngJX@@dmS@]FJ\\fs`qs][iB\ngJX@@dmS@]JJlxLTwVz]`\ngJX@@dmS@]JJlxLTwVz^`\ngJX@@dmU@]FJ\\enlDa@\ngJX@@dmU@]FJ\\erPqSfzpRD\ngJX@@dmU@]FJ]FnlDa@\ngJX@@dmUQH]FJ\\enlD~@<\ngJX@@dmUQH]FJ\\es`qS]XIB<\ngJX@@dmUQH]FJ\\es`qS]XIB>\ngJX@@dmUQH]FJ\\es`qS]XI|<\ngJX@@dmUQH]FJ\\es`qS]XI|>\ngJX@@dmUQH]FJ\\es`qs]XI|<\ngJX@@dmUQH]FJ\\es`qs]XI|>\ngJX@@dmUQH]FJ\\fnlDa@<\ngJX@@dmUQH]FJ\\fnlDa@>\ngJX@@dmUQH]FJ\\frPqSfzpRD>\ngJX@@dmUQH]FJ\\fs`qS]XIB<\ngJX@@dmUQH]FJ\\fs`qS]XIB>\ngJX@@dmUQH]FJ\\fs`qs]XIB<\ngJX@@dmUQH]FJ]EnlD~@<\ngJX@@dmUQH]FJ]EnlD~@>\ngJX@@drP`]II[h[vp\ngJX@@drP`]II[h[wP\ngJX@@drP`]II[x[vst\ngJX@@drP`]II\\xL\\wp{mgh\ngJX@@drt`]FJ\\enlD}@\ngJX@@drt`]FJ\\enmx}@\ngJX@@drt`]FJ\\eoLD\ngJX@@drt`]FJ\\eoMx\ngJX@@drt`]FJ\\es`qs]XIz\ngJX@@drt`]FJ\\es`qs_CnB^`\ngJX@@drt`]FJ\\eshis]CnB\ngJX@@drt`]FJ\\eshis]XIz\ngJX@@drt`]FJ\\eshis^XH\ngJX@@drt`]FJ\\eshis_CnB^`\ngJX@@drt`]FJ]EnawA@\ngJX@@drt`]FJ]Es`qs]XIz\ngJX@@drt`]FJ]Eshis_CnB^`\ngJX@@dru@]FJ\\enlDa@\ngJX@@dru@]FJ\\enlD~@\ngJX@@dru@]FJ\\eoawAHP\ngJX@@dru@]FJ\\eoaw^HP\ngJX@@dru@]FJ\\es`qs]XIB\ngJX@@dru@]FJ\\eshis]XIB\ngJX@@dru@]FJ\\eshis][qB\ngJX@@dru@]FJ\\eshis_CnBP`\ngJX@@dru@]FJ\\eshis_Cn|P`\ngJX@@dru@]FJ\\fnlDa@\ngJX@@dru@]FJ]EnlDa@\ngJX@@dru@]FJ]EoawAHP\ngJX@@dru@]FJ]Es`qs]XIB\ngJX@@dru@]FJ]Es`qs]XI|\ngJX@@dru@]FJ]Eshis_CnBP`\ngJX@@dru@]ZRRwpwmdH\ngJX@@dru@]ZRRwpwndH\ngJX@@dru@]ZRRytTyoao]HP\ngJX@@dsR`]FJ\\e@\ngJX@@dsR`]FJ\\es`qs^Gh\ngJX@@dsR`]FJ\\es`qs^[h\ngJX@@dsR`]FJ\\eshir\ngJX@@dsR`]FJ\\eshis][iz\ngJX@@dsR`]FJ\\eshis^Gh\ngJX@@dsR`]ZRRwPwm`\ngJX@@dsR`]ZRRwPwn`\ngJX@@dsR`]ZRRwP{m`\ngJX@@dsR`]ZRRwP{n`\ngJX@@dsR`]ZRRwpwmgh\ngJX@@dsR`]ZRRwpwngh\ngJX@@dsR`]ZRRwp{mgh\ngJX@@dsR`]ZRRytTyoaw]OP\ngJX@@dsTrH]FJ\\enlD}@>\ngJX@@dsTrH]FJ\\eoLD<\ngJX@@dsTrH]FJ\\eoLD>\ngJX@@dsTrH]FJ\\erPqSf|pP<\ngJX@@dsTrH]FJ\\erPqSf|pP>\ngJX@@dsTrH]FJ\\erPqSf|w`<\ngJX@@dsTrH]FJ\\erPqSf|w`>\ngJX@@dsTrH]FJ\\es`qs^XH<\ngJX@@dsTrH]FJ\\es`qs^XH>\ngJX@@dsTrH]FJ\\eshis]XIz<\ngJX@@dsTrH]FJ\\eshis^XH<\ngJX@@dsTrH]FJ\\eshis^XH>\ngJX@@dsTrH]FJ\\eshis^[p<\ngJX@@dsTrH]FJ]EoLD<\ngJX@@dsURH]FJ\\enlDa@<\ngJX@@dsURH]FJ\\enlDa@>\ngJX@@dsURH]FJ\\enlD~@<\ngJX@@dsURH]FJ\\enlD~@>\ngJX@@dsURH]FJ\\enmxa@<\ngJX@@dsURH]FJ\\enmxa@>\ngJX@@dsURH]FJ\\erPqSfzpRD<\ngJX@@dsURH]FJ\\erPqSfzpRD>\ngJX@@dsURH]FJ\\erPqSfzwbD<\ngJX@@dsURH]FJ\\erPqSfzwbD>\ngJX@@dsURH]FJ\\es`qs]XIB<\ngJX@@dsURH]FJ\\es`qs]XIB>\ngJX@@dsURH]FJ\\es`qs]XI|<\ngJX@@dsURH]FJ\\es`qs]XI|>\ngJX@@dsURH]FJ\\es`qs][qB<\ngJX@@dsURH]FJ\\es`qs][qB>\ngJX@@dsURH]FJ\\eshis]XIB<\ngJX@@dsURH]FJ\\eshis]XIB>\ngJX@@dsURH]FJ\\eshis]XI|<\ngJX@@dsURH]FJ\\eshis]XI|>\ngJX@@dsURH]FJ\\eshis][qB<\ngJX@@dsURH]FJ\\eshis][qB>\ngJX@@dsURH]FJ\\fnlDa@<\ngJX@@dsURH]FJ\\fnlDa@>\ngJX@@dsURH]FJ\\fnmxa@<\ngJX@@dsURH]FJ\\fnmxa@>\ngJX@@dsURH]FJ\\fs`qs]XIB<\ngJX@@dsURH]FJ\\fs`qs]XIB>\ngJX@@dsURH]FJ\\fshis]XIB<\ngJX@@dsURH]FJ\\fshis]XIB>\ngJX@@dsURH]FJ\\fshis][qB>\ngJX@@dsURH]FJ]EnlDa@<\ngJX@@dsURH]FJ]EnlDa@>\ngJX@@dsURH]FJ]ErPqSfzpRD<\ngJX@@dsURH]FJ]Es`qs]XIB<\ngJX@@dsURH]FJ]Es`qs]XIB>\ngJX@@dsURH]FJ]Es`qs]XI|<\ngJX@@dsURH]FJ]Es`qs]XI|>\ngJX@@dsURH]FJ]Eshis]XIB<\ngJX@@dsURH]FJ]Eshis]XIB>\ngJX@@dsURH]FJ]FnlDa@<\ngJX@@dsURH]FJ]FnlDa@>\ngJX@@dsURH]FJ]Fs`qs]XIB<\ngJX@@dsURH]FJ]Fs`qs]XIB>\ngJX@@dvE@]KI[x[VrD\ngJX@@dvE@]KI[x[Vsx\ngJX@@dvE@]KI[x[WRD\ngJX@@dvE@]KI[x]VrD\ngJX@@dvE@]KI\\zJ\\wpvndH\ngJX@@dvE@]KI\\zJ\\wpvngp\ngJX@@dvE@]KIkx[VrD\ngJX@@dvE@]KIkx[WRD\ngJX@@dwM@]FJ\\eneta@\ngJX@@dwM@]FJ\\eoBD\ngJX@@dwM@]FJ\\es`is]KiB\ngJX@@dwM@]FJ\\es`is^DH\ngJX@@dwM@]FJ\\eshis]KiB\ngJX@@dwM@]FJ\\eshis]Ki|\ngJX@@dwM@]FJ\\eshis^DH\ngJX@@dwM@]FJ\\eshis^Gp\ngJX@@dwM@]FJ\\fneta@\ngJX@@dwM@]ZVRwpvmdH\ngJX@@dwM@]ZVRwpvndH\ngJX@@dwM@]ZVRwpzmdH\ngJX@@dwM@]ZVRwpzndH\ngJX@@dwM@]ZVRypTyoau[HP\ngJX@@dwM@]ZVRypTyoau]HP\ngJX@@dwM@]ZVRytTyoam]HP\ngJX@@dwM@]ZVRytTyoau]HP\ngJX@@dwM@]ZVRytTyoau]O`\ngJX@@dwM@]ZVSWpvmdH\ngJX@@dwM@]ZVSWpvndH\ngJX@@dwM@]ZVSWpzmdH\ngJX@@dwM@]ZVSWpzndH\ngJX@@eMH@]HJ[k[Nv`@=\ngJX@@eMH@]HJ[k[O_v`@\ngJX@@eMH@]HJ[k]O_v`@=\ngJX@@eMH@]HJ[y]vso}h@=\ngJX@@eMH@]HJ[y]vsw}h@\ngJX@@eMH@]HJ[y]wSw}h@=\ngJX@@eMH@]HJ\\xLTwVz^m@\ngJX@@eMH@]HJ\\xLTwr{ngo{P@\ngJX@@eMH@]HJ\\xL\\wVv^m@\ngJX@@eMH@]HJ\\xL\\wr{mgo{P@\ngJX@@eMK@]TLTyK][iC~t@\ngJX@@eMK@]TLTyK_KnzPm@\ngJX@@eMK@]TLTyKgAbfzWRG}h@\ngJX@@eMK@]TLTyKgAbf~W]taZ@\ngJX@@eMK@]XLdypXioew]O_v`@\ngJX@@eMP@]HJ[yAvso}h@=\ngJX@@eMP@]HJ[yAvsw}h@\ngJX@@eMP@]HJ[yAwSt=\ngJX@@eMP@]HJ[yAwSw}h@=\ngJX@@eMP@]HJ[y^vso}h@=\ngJX@@eMP@]HJ[y^vsw}h@\ngJX@@eMP@]HJ\\xLTwrCngh\ngJX@@eMP@]HJ\\xLTwrCngo{P@\ngJX@@eMP@]HJ\\xLTwr}ngh\ngJX@@eMP@]HJ\\xL\\wrCmgo{P@\ngJX@@eMP@]HJ\\xL\\wr}mgo{P@\ngJX@@eMP@]HJkyAvso}h@=\ngJX@@eMP@]HJkyAvsw}h@\ngJX@@eMP@]HJkyAwSt=\ngJX@@eMP@]HJkyAwSw}h@=\ngJX@@eMP@]HJlxLTwrCngh\ngJX@@eMP@]HJlxLTwrCngo{P@\ngJX@@eMP@]HJlxL\\wrCmgo{P@\ngJX@@eMS@]TLTyK]HIC~t@\ngJX@@eMS@]TLTyK_HNzPdd\\[P@\ngJX@@eMS@]TLTyK_HNzPm@\ngJX@@eMS@]TLTyKgAbfzPRG}h@\ngJX@@eMS@]TLTyKgAbf~P]taZ@\ngJX@@eMS@]TLTyKgAbf~WmtaZ@\ngJX@@eMS@]TLTyKgAcf~P]taZ@\ngJX@@eMS@]TLTyM_HNzPm@\ngJX@@eMS@]TLTyMgAbfzPRG}h@\ngJX@@eMS@]TLTyMgAbf~P]taZ@\ngJX@@eMS@]TLUYK]HIC~t@\ngJX@@eMS@]TLUYK_HNzPdd\\[P@\ngJX@@eMS@]TLUYK_HNzPm@\ngJX@@eMS@]TLUYKgAbfzPRG}h@\ngJX@@eMS@]TLUYKgAbf~P]taZ@\ngJX@@eMS@]TLUYKgAcf~P]taZ@\ngJX@@eMS@]TLUYM_HNzPm@\ngJX@@eMS@]TLUYMgAbf~P]taZ@\ngJX@@eMS@]XLdwrCng_{P@\ngJX@@eMS@]XLdwrCngo{P@\ngJX@@eMS@]XLeWrCmgo{P@\ngJX@@eMS@]XLeWrCngo{P@\ngJX@@eMU@]TLTyK_HNBP`\ngJX@@eMU@]TLTyK_HNBPdd\\[P@\ngJX@@eMU@]TLTyK_HNBPm@\ngJX@@eMU@]TLTyK_KvBP`\ngJX@@eMU@]TLTzM_HNBP`\ngJX@@eMU@]TLTzM_HNBPm@\ngJX@@eMU@]TLUYK_HNBP`\ngJX@@eMU@]TLUYK_HNBPm@\ngJX@@eMU@]TLUZM_HNBPm@\ngJX@@eMURH]TLTyK_HNB__m@<\ngJX@@eMURH]TLTyK_HNB__m@>\ngJX@@eMURH]TLTyKgAbf~P\\Da@<\ngJX@@eMURH]TLTyKgAbf~P\\Da@>\ngJX@@eMURH]TLTyKgAbf~P\\DaZ@<\ngJX@@eMURH]TLTyKgAbf~P\\DaZ@>\ngJX@@eMURH]TLTyKgAbf~WlDa@<\ngJX@@eMURH]TLTyM_HNBP`<\ngJX@@eMURH]TLTyM_HNBP`>\ngJX@@eMURH]TLTyM_HNBPm@<\ngJX@@eMURH]TLTyM_HNBPm@>\ngJX@@eMURH]TLTyMgAbf~P\\Da@<\ngJX@@eMURH]TLTyMgAbf~P\\Da@>\ngJX@@eMURH]TLTyMgAbf~P\\DaZ@<\ngJX@@eMURH]TLTyMgAbf~P\\DaZ@>\ngJX@@eMURH]TLTzK_HNB__m@<\ngJX@@eMURH]TLTzK_HNB__m@>\ngJX@@eMURH]TLTzKgAcf~P\\D~@<\ngJX@@eMURH]TLTzKgAcf~P\\D~@>\ngJX@@eMURH]TLTzMgAbf~P\\Da@<\ngJX@@eMURH]TLUYK_HNB__m@>\ngJX@@eMURH]TLUYKgAbf~P\\Da@<\ngJX@@eMURH]TLUYKgAbf~P\\Da@>\ngJX@@eMURH]TLUYKgAbf~P\\DaZ@<\ngJX@@eMURH]TLUYKgAbf~P\\DaZ@>\ngJX@@eMURH]TLUYM_HNBPm@<\ngJX@@eMURH]TLUYM_HNBPm@>\ngJX@@eMURH]TLUYMgAbf~P\\DaZ@<\ngJX@@eMURH]TLUYMgAbf~P\\DaZ@>\ngJX@@eMURH]TLUZK_HNB__m@<\ngJX@@eMURH]TLUZK_HNB__m@>\ngJX@@eST`]TLTyK]HNC~t@=\ngJX@@eST`]TLTyK_HNB^m@=\ngJX@@eST`]TLTyKgASfzP]{}h@\ngJX@@eST`]TLTyKgASf~P]x}Z@\ngJX@@eST`]TLTyKgAcfzP\\G}h@\ngJX@@eST`]TLTyKgAcf~P\\D}Z@\ngJX@@eST`]TLTzK]HNC~t@\ngJX@@eST`]TLTzK_HNB^m@\ngJX@@eST`]TLTzKgASf~P\\D}Z@\ngJX@@eST`]TLTzKgAcfzP\\G}h@\ngJX@@eST`]TLTzKgAcf~P\\D}Z@\ngJX@@eST`]XTRwRwnm@\ngJX@@eST`]XTRwR{nm@=\ngJX@@eSU@]TLTyK_HNBP`\ngJX@@eSU@]TLTyK_HNBPdhT[P@=\ngJX@@eSU@]TLTyK_HNBPm@=\ngJX@@eSU@]TLTyK_HNB_@\ngJX@@eSU@]TLTyK_HNB__m@=\ngJX@@eSU@]TLTyK_HN|Pm@\ngJX@@eSU@]TLTyKdabgM|`xIB\ngJX@@eSU@]TLTyKdabgM|`xIC~t@=\ngJX@@eSU@]TLTyKdabgM|`xI|\ngJX@@eSU@]TLTyKgASf~P]xaZ@\ngJX@@eSU@]TLTyKgAcf~P\\DaZ@\ngJX@@eSU@]TLTyKgAcf~P\\D~Z@\ngJX@@eSU@]TLTyKgAcf~P]xaZ@\ngJX@@eSU@]TLTyM_HNBP`\ngJX@@eSU@]TLTyM_HNBPdhT[P@=\ngJX@@eSU@]TLTyM_HNBPm@=\ngJX@@eSU@]TLTyM_HN|Pm@\ngJX@@eSU@]TLTyMgASf~P]xaZ@\ngJX@@eSU@]TLTyMgAcf~P\\DaZ@\ngJX@@eSU@]TLTzK_HNBPm@\ngJX@@eSU@]TLTzKgASf~P\\DaZ@\ngJX@@eSU@]TLTzKgAcf~P\\DaZ@\ngJX@@eSU@]TLTzKgAcf~P\\D~Z@\ngJX@@eSU@]TLTzM_HNBPm@\ngJX@@eSU@]TLTzMgASf~P\\DaZ@\ngJX@@eSU@]TLTzMgAcf~P\\DaZ@\ngJX@@eSU@]TLUZK_HNBP`\ngJX@@eSU@]TLUZK_HNBPm@=\ngJX@@eSU@]TLUZM_HNBPm@=\ngJX@@eSU@]XTRwrwmdO{P@=\ngJX@@eSU@]XTRwrwmgw{P@=\ngJX@@eSU@]XTRwrwndO{P@\ngJX@@eSU@]XTRwrwngw{P@\ngJX@@eSU@]XTRwr{ndO{P@=\ngJX@@eSU@]XTRypTyoeo]H_v`@\ngJX@@eSU@]XTRypXyoew]H_v`@\ngJX@@eSU@]XTSWrwmdO{P@=\ngJX@@eSU@]XTSWrwndO{P@\ngJX@@eSU@]XTSWr{ndO{P@=\ngJX@@eSU@]XTSYpXyoew]H_v`@\ngJX@@eSUPH]TLTyK_HN|P`<\ngJX@@eSUPH]TLTyK_HN|P`>\ngJX@@eSUPH]TLTyKgASf~P]xa@<\ngJX@@eSUPH]TLTyKgASf~P]xa@>\ngJX@@eSUPH]TLTyKgAcf~P\\Da@<\ngJX@@eSUPH]TLTyKgAcf~P\\Da@>\ngJX@@eSUPH]TLTyKgAcf~P\\D~@<\ngJX@@eSUPH]TLTyKgAcf~P\\D~@>\ngJX@@eSUPH]TLTyKgAcf~P]xa@<\ngJX@@eSUPH]TLTyKgAcf~P]xa@>\ngJX@@eSUPH]TLTyM_HN|P`<\ngJX@@eSUPH]TLTyM_HN|P`>\ngJX@@eSUPH]TLTyMgAcf~P\\Da@<\ngJX@@eSUPH]TLTyMgAcf~P\\Da@>\ngJX@@eSUPH]TLTzK_HNBP`<\ngJX@@eSUPH]TLTzK_HNBP`>\ngJX@@eSUPH]TLTzKdabgM|`xIB<\ngJX@@eSUPH]TLTzKgASf~P\\Da@<\ngJX@@eSUPH]TLTzKgASf~P\\Da@>\ngJX@@eSUPH]TLTzKgAcf~P\\Da@<\ngJX@@eSUPH]TLTzKgAcf~P\\Da@>\ngJX@@eSUPH]TLTzM_HNBP`<\ngJX@@eSUPH]TLTzM_HNBP`>\ngJX@@eSUPH]TLTzMgAcf~P\\Da@<\ngJX@@eSUPH]TLTzMgAcf~P\\Da@>\ngJX@@eSUPH]TLUYK_HN|P`<\ngJX@@eSUPH]TLUYK_HN|P`>\ngJX@@eSUPH]TLUYM_HN|P`<\ngJX@@eSUPH]TLUYM_HN|P`>\ngJX@@e\\u@]TLTyK]XIC~t@\ngJX@@e\\u@]TLTyK_SnBPm@\ngJX@@e\\u@]TLTzM]XIC~t@\ngJX@@e\\uQH]TLTyK]XI}~t@>\ngJX@@e\\uQH]TLTyKgAbf~g\\DaZ@<\ngJX@@e\\uQH]TLTyKgAbf~g\\DaZ@>\ngJX@@e\\uQH]TLTyM]XIC~t@<\ngJX@@e\\uQH]TLTyM]XIC~t@>\ngJX@@e\\uQH]TLTyMgAbf~g\\DaZ@<\ngJX@@e\\uQH]TLTyMgAbf~g\\DaZ@>\ngJXA@IRVX@NiFzvst\ngJXA@IRVX@NiGNCGM|N{Yz\ngJXA@IRVh@NiFzvsl=\ngJXA@IRVh@NiFzvst\ngJXA@IRVh@NiFzwSt=\ngJXA@IRVh@NiF~Gml{@=\ngJXA@IRVh@NiF~Gml}@\ngJXA@IRVh@NiF~Gmt}@=\ngJXA@IRVh@NiGNCEMungh\ngJXA@IRVh@NiGNCEM|O[iz\ngJXA@IRVh@NiGNCGMumgh\ngJXA@IRVi`NcENRwaB\ngJXA@IRVi`NcENRypXynmta@\ngJXA@IRVi`NcENRypXyoBD\ngJXA@IRVj`NcENRwVBP`\ngJXA@IRVjhdNcENRypXinlDa@<\ngJXA@IRVjhdNcENRypXinlDa@>\ngJXA@IRVjhdNcENRypXioa{AHP<\ngJXA@IRVjhdNcENSWVBP`>\ngJXA@IRVjhdNcENSYpXinlDa@<\ngJXA@IRYHPNddmtN{X\ngJXA@IRYZPNcENRwP{o@\ngJXA@IRYZPNcENRwVB^`\ngJXA@IRYZPNcENRwp{`gh\ngJXA@IRYZPNcENRypXyoawAOP\ngJXA@IRYZPNcENRytTyoawAOP\ngJXA@IRYjiDNcENRwVBP`<\ngJXA@IRYjiDNcENRwVBP`>\ngJXA@IRYjiDNcENRwVB_@<\ngJXA@IRYjiDNcENRwVB_@>\ngJXA@IRYjiDNcENRyHXis]XIB>\ngJXA@IRYjiDNcENRyHXis][qB<\ngJXA@IRYjiDNcENRyHXis_CvBP`<\ngJXA@IRYjiDNcENRyHXis_CvBP`>\ngJXA@IRYjiDNcENRypXynlDa@<\ngJXA@IRYjiDNcENRypXynlDa@>\ngJXA@IRYjiDNcENRytTynlDa@<\ngJXA@IRYjiDNcENRytTynlDa@>\ngJXA@IRYjiDNcENSWVBP`<\ngJXA@IRYjiDNcENSWVBP`>\ngJXA@IRYjiDNcENSYpXynlDa@<\ngJXA@IRYjiDNcENSYtTynlDa@>\ngJXA@IRYjiDNcENbwVBP`>\ngJXA@IRYjiDNcENbypXynlDa@<\ngJXA@IRYjiDNcENbypXynlDa@>\ngJXA@IR[B`Nedm|MkYB\ngJXA@IR[B`Nedm|MkiB\ngJXA@IRfd@NdEMumg_{P@=\ngJXA@IRfd@NdEMumgo{P@\ngJXA@IRfd@NdEM|n{Yw~t@=\ngJXA@IRfd@NdEM|n{Y{~t@\ngJXA@IRfd@NdEM|n{i{~t@=\ngJXA@IRfd@NdEN\\FN[y]vsw}h@\ngJXA@IRfe`NjFJ\\es`qS]KiC~t@\ngJXA@IRfh@NdEM|`{Yv=\ngJXA@IRfj`NjFJ\\eodGAHP\ngJXA@IRfjiDNjFJ\\es`qS_HNBP`<\ngJXA@IRfjiDNjFJ\\es`qS_HNBP`>\ngJXA@IRfjiDNjFJ\\fodGAHP<\ngJXA@IRfjiDNjFJ\\fodGAHP>\ngJXA@IRij`NjFJ\\eodGAHP\ngJXA@IRij`NjFJ\\eodGAO`\ngJXA@IRij`NjFJ\\erPqSf~P\\Da@\ngJXA@IRij`NjFJ\\erPqSf~P\\D~@\ngJXA@IRij`NjFJ\\fodGAHP\ngJXA@IRijhDNjFJ\\es`qs_HNBP`<\ngJXA@IRijhDNjFJ\\es`qs_HNBP`>\ngJXA@IRijhDNjFJ\\fs`qs_HNBP`<\ngJXA@IRijhDNjFJ\\fs`qs_HNBP`>\ngJXA@IRkZ`NjFJ\\enlDaZ@\ngJXA@IRkZ`NjFJ\\eoiwAH_v`@\ngJXA@IRkZ`NjFJ\\es`qs]XIC~t@\ngJXA@IRkZ`NjFJ\\es`qs_SnBPm@\ngJXA@IRkZ`NjFJ\\eshis]XIC~t@\ngJXA@IRkZ`NjFJ\\eshis_SnBPm@\ngJXA@IRkZ`NjFJ\\fnlDaZ@\ngJXA@IRkZ`NjFJ\\foiwAH_v`@\ngJXA@IRkZ`NjFJ]EoiwAH_v`@\ngJXA@IRkZ`NjFJ]Es`qs]XIC~t@\ngJXA@IRkZ`NlII[z[vrG}h@\ngJXA@IRkZ`NlII[z[wRG}h@\ngJXA@IRkZ`NlII[z]vrG}h@\ngJXA@IRkZ`NlII[z]wRG}h@\ngJXA@IRkZ`NlIIkz[vrG}h@\ngJXA@IRkZ`NlIIkz[wRG}h@\ngJXA@IRkZ`NlIIkz]vrG}h@\ngJXA@IRkZ`NlIIkz]wRG}h@\ngJXA@IRnZ`NjFJ\\eoiwAH_v`@\ngJXA@IRnZhdNjFJ\\fs`qS_SnBPm@<\ngJXA@IRnZhdNjFJ\\fs`qS_SnBPm@>\ngJXA@IrRDJ@zVRwtvmdO{P@=\ngJXA@IrRDJ@zVRwtvndO{P@\ngJXA@IrRDJ@zVRwtzndO{P@=\ngJXA@IrRDJ@zVRypTyoiu]H_v`@\ngJXA@IrRDJ@zVRytTyoim]H_v`@\ngJXA@IrRDJ@zVSWtvmdO{P@=\ngJXA@IrRDJ@zVSWtvndO{P@\ngJXA@NRfh@NdEM|`{Yw~t@=\ngJXA@NRfi`NjFJles`qS_HNzPm@\ngJXAAnR[f`NmKIkx[WRD\ngJXDB@cABTuRAu`qS^HH\ngJXDB@cABTuRAu`rS_HNv]`\ngJXDD@bABUuTAtPirVzpRG}h`=\ngJXDHOA^BS]TAuhyK^DH\ngJXDHOA^BS]TAuhyK_Cr|PmH=\ngJXDL@aABSKTAuhiK^DH\ngJXDL@aABS[TAuhyK^DO{S@\ngJXDL@bABUu@Au@wVv]`\ngJXH@jAJZ`@z`[k[Nv`@=\ngJXH@jAJZ`@z`[k]OP=\ngJXH@jAJZ`@z`\\xLTwVz^`\ngJXH@jAJZ`@z`\\xL\\wVv^m@\ngJXH@jAJzj@zhYIr[NCEM}@xIC~t@>\ngJXH@jAJzj@zhYIt[NCEM}@xIB>\ngJXH@jAJzj@zhYIt[NCEM}@xIC~t@>\ngJXHAJAIfi@zLTyKgAcf|pP>\ngJXHAJAIfi@zLTzKgAcf|pP>\ngJXHAjAJfi@zHXiKgASf|P_v`@\ngJXHAjAJfi@zHXiKgAcfzPSw}h@\ngJXHAjAJfi@zHXiKgAcf|P_v`@\ngJXHAjAJfi@zHXjK]HI{~t@\ngJXHAjAJfj@zHXiKgAcf~P]xaZ@\ngJXHAjAJfj`PzHXjK]HIB<\ngJXHAjAJfj`PzHXjK]HIB>\ngJXHB@aIfe@zTdwPwm`\ngJXHB@aInZ@zTlwPvm`\ngJXHB@aInZ@zTlwPvn`\ngJXHB@aInZ@zTlytTynam]@\ngJXHBOAJfj@zHXis]HNB\ngJXHBOAJfj@zHXisdabgMt`xH\ngJXHBOAJfj@zHXju]HNB\ngJXHBOAJfj`PzHXiu]HNB<\ngJXHBOAJfj`PzHXiu]HNB>\ngJXHD@aIZjbPzLTyKgAbfzpRD<\ngJXHD@aIZjbPzLTyKgAbfzpRD>\ngJXHD@aIej@zLTyK]XIC~tP\ngJXHD@aIej@zLTyKgQSfzpRG}h`\ngJXHD@aIej@zLTyM]XIC~tP\ngJXHD@aIej@zLTyMgQSfzpRG}h`\ngJXHD@aIej@zLTzK]XIC~tP\ngJXHD@aIej@zLTzKgQSfzpRG}h`\ngJXHD@aIej@zLTzM]XIC~tP\ngJXHD@aIfe@ztdenao]ZH\ngJXHD@aIfe@ztdeshis_C^z^mD\ngJXHD@aIff@zLTyK][iC~tP\ngJXHD@aIff@zLTyM][iC~tP\ngJXHD@aIff@ztdeoao]H_vb@\ngJXHD@aIff@ztdfoao]H_vb@\ngJXHD@aIff@ztdfshis_C^zPmD\ngJXHD@aImi@zt\\eshir\ngJXHD@aImj@zt\\eshis^DH\ngJXHD@aInZ@ztleoam[HP\ngJXHD@aInZ@ztlfoam[HP\ngJXHDHaIfe@zLTyKgQSf|O_vb@\ngJXHDOAIZj@zLTyK]XIB\ngJXHDOAIZj@zLTyK_CvBP`\ngJXHDOAIZj@zLTyKdabgMu`dH\ngJXHDOAIZj@zLTyKdabgM|OXIB\ngJXHDOAIZj@zLTyM]XIC~tP\ngJXHDOAIfjdPzLTzM_CvBPmD>\ngJXHH@aIYj@zLTyK]XIC~t`\ngJXHH@aIZ`@zd[x^vso}i@=\ngJXHH@aIZ`@zd[x^vsw}i@\ngJXHH@aIZ`@zd[x^wSw}i@=\ngJXHH@aIZ`@zd\\xL\\wp}mgo{R@\ngJXHH@aIZf@zLTyK_CvzPmH\ngJXHH@aIZf@zLTyKgAbf~GmtaZP\ngJXHH@aIZf@zTUWp}ngo{R@\ngJXHH@aIZj@zLTyK]XIC~t`\ngJXHH@aIZj@zLTyK_CvBPmH\ngJXHH@aIZj@zLTzM]XIC~t`\ngJXHH@aIZj@zLTzM_CvBPmH\ngJXHH@aIZjbPzLTyK]XI}~t`<\ngJXHH@aIZjbPzLTyK]XI}~t`>\ngJXHH@aIZjbPzLTyK_CvB__mH<\ngJXHH@aIZjbPzLTyK_CvB__mH>\ngJXHH@aIZjbPzLTyKgAbf~GlDaZP<\ngJXHH@aIZjbPzLTyKgAbf~GlDaZP>\ngJXHH@aIZjbPzLTyM]XIC~t`<\ngJXHH@aIZjbPzLTyM]XIC~t`>\ngJXHH@aIZjbPzLTyM_CvBPmH<\ngJXHH@aIZjbPzLTyM_CvBPmH>\ngJXHH@aIZjbPzLTzK]XI}~t`<\ngJXHH@aIZjbPzLTzK_CvB__mH<\ngJXHH@aIZjbPzLTzK_CvB__mH>\ngJXHH@aIfi@zLTyK_CvB^mH\ngJXHH@aIfi@zLTyKgQSfzGlG}i@\ngJXHH@aIfi@zLTyKgQSf~GlD}ZP\ngJXHH@aIfj@zLTyK_CvBPmH\ngJXHH@aIfj@zLTyKgAcf~GlDaZP\ngJXHH@aIfj@zLTyKgQSf~GlDaZP\ngJXHH@aIfj@zLTyKgQSf~GlD~ZP\ngJXHH@aIfj@zLTyKgQSf~GmxaZP\ngJXHH@aIfj@zLTyM_CvBPmH\ngJXHH@aIfj@zLTyMgQSf~GlDaZP\ngJXHH@aIfj@zLTzK_CvBPmH\ngJXHH@aIfj@zLTzKgQSf~GlDaZP\ngJXHH@aIfj@zLTzKgQSf~GlD~ZP\ngJXHH@aIfj@zLTzM_CvBPmH\ngJXHH@aJz`@z`[k[OP\ngJXHH@aJz`@z`\\xL\\wVv^`\ngJXHHGAIZ`@zd[x^vsw}i@\ngJXHHGAIZ`@zd[x^wSt=\ngJXHHGAIfj@zLTyKgQSf~GlDaZP\ngJXHHGAIfjdPzLTzK_CvB_@<\ngJXHHGAIfjdPzLTzK_CvB_@>\ngJXHHOAIY`@zd[k[Nvd@=\ngJXHHOAIY`@zd[k[O_vd@\ngJXHHOAIY`@zd[k]O_vd@=\ngJXHHOAIZ`@zd[k[O_vd@\ngJXHHOAIZ`@zd[x^vso}i@=\ngJXHHOAIZ`@zd[x^vsw}i@\ngJXHHOAIZ`@zd[x^wSw}i@=\ngJXHHOAIZ`@zd\\xL\\wp}mgo{R@\ngJXHHOAIZj@zLTyK_CvBPmH\ngJXHHOAIZjbPzLTyM_CvBPmH<\ngJXHHOAIZjbPzLTyM_CvBPmH>\ngJXHHOAIfj@zLTyK_CvBPmH\ngJXHHOAIfj@zLTyKgAcf~GlDaZP\ngJXHHOAIfj@zLTyKgAcf~GlD~ZP\ngJXHHOAIfj@zLTyKgQSf~GlDaZP\ngJXHHOAIfj@zLTyM_CvBPmH\ngJXHHOAIfj@zLTyMgAcf~GlDaZP\ngJXHHOAIfj@zLTzK]XIC~t`\ngJXHHOAIfjdPzLTyK]XIB<\ngJXHHOAIfjdPzLTyK]XIB>\ngJXHHOAIfjdPzLTyK_CvBP`>\ngJXHHOAJfj@zhXjtZ~P\\DaZP\ngJXHL@aIZ`@zd[k[Np\ngJXHL@aIZ`@zd[k[OP\ngJXHL@aIZf@ztTfs`qS^DH\ngJXHL@aIZf@ztTfs`qs_CvzP`\ngJXHL@aIZjb`ztTeoBD<\ngJXHL@aIZjb`ztTeoBD>\ngJXHL@aJZ`@zPTwrCmgX\ngJXHL@aJZ`@zPTwrCmgh\ngJXHL@aJZ`@zPTwrCngX\ngJXHL@aJZ`@zPTypXyodG[OP\ngJXHL@aJZ`@zPUWrCmgX\ngJXHL@aJZ`@zPUWrCmgh\ngJXHL@aJZ`@zPUYpXyodG[OP\ngJXHL@aJZf@zHXiK]HIB\ngJXHL@aJZf@zpYIodG[OP\ngJXHL@aJZf@zpYIs`qs_HNv^`\ngJXHL@aJZi@zHXiK]HIz\ngJXHL@aJZi@zHXjK]HIz\ngJXHL@aJZi@zpYIodG[OP\ngJXHL@aJZjdPzHXjMgAbfzPRD<\ngJXHL@aJZjdPzHXjMgAbfzPRD>\ngJXHLDQJZ`@zPTwrCmgX\ngJXHLJqIZjb`ztTeoBD<\ngJXHLLQIZ`@zd[k[OP\ngJXHLLQIZ`@zd[k]OP\ngJXHLLQIZjb`ztTeoBD<\ngJXHLOAIZ`@zd[x^vsl\ngJXHLOAIZi@zTUWp}mgX\ngJXHaj@SnRkZ`NbFJRwV|Pm@\ngJXIB@`rdwM@]JV[h[Vp\ngJXID@aRdwL`]ZVRwPvn`\ngJXIDOARdmU@]FJ\\eoa{AHP\ngJXIH@b\\dmP@]RM|O[Yw~t`=\ngJXIHOBRdlp@]RMungo{R@=\ngJXIHOBRdlu@]FJ\\enlDaZP\ngJXIHOBRdru@]FJ\\enlDaZP\ngJXIL@cRdmP@]RMumgX\ngJXIL@cRdmUQP]ZJRwaB<\ngJXIL@cRdmUQP]ZJRwaB>\ngJXLB@bAFBDkjdCiAU][Yv\ngJXLL@aAABDfVhCiQR\ngJX`BDdru@]ZJ\\wfB\ngJX`BDdru@]ZJ\\wf|\ngJX`BDdru@]ZJ]WfB\ngJX`BDdvu@]JNP\ngJX`BDdwU@]JNP\ngJX`BLeMT`]XLTwbB\ngJX`DBdru@]ZJ\\wfC~tP\ngJX`DBdru@]ZJ\\wf}~tP\ngJX`DBdru@]ZJ]WfC~tP\ngJX`DBdvu@]JNP\ngJX`DBdvu@]JN\\zJ\\`\ngJX`DBdwM@]JV[h[Vp\ngJX`LDdru@]ZJRwaB\ngJX`LDdru@]ZJRwa|\ngJX`LDdru@]ZJRytTyoBD\ngJX`LDdru@]ZJRytTyoCx\ngJX`LDdru@]ZJSWaB\ngJX`LDdru@]ZJSYtTyoBD\ngJX`LDdvt`]ZNRwa{~tp\ngJX`LDdvu@]ZNRwaC~tp\ngJX`LDdvu@]ZNRwa}~tp\ngJX`LDdvu@]ZNRytTyoBG}i`\ngJX`LDdvu@]ZNRytTyoC{}i`\ngJX`LDdvu@]ZNSWaC~tp\ngJX`LDdvu@]ZNSYtTyoBG}i`\ngJX`bDnLiMmPGRcd\ngJX`bDnLiMmPGRcf|O`\ngJX`hEIWIMmHGVcdmx^mH\ngJX`hEIWIMmHGVcdo{R@\ngJX`hEIWIMmPGVcdmxPmH\ngJX`hEIWIMmPGVcdmx__mH\ngJXaBDYR[Z`NeGH\ngJXaBDYR[Z`NeGMx_@\ngJXaBDnR[Z`NeGH\ngJXaLDnR[Z`NmGI[paZX\ngJXhMDOAJfj`PzpXfoBD<\ngJXhMDOAJfj`PzpXfoBD>\ngJXhMDOAJfj`PzpXfs`qs^DH<\ngJXhMDOAJfj`PzpXfs`qs^DH>\ngJY@BDfVhCkQSf|pP\ngJY@BDfVhCkQSj|pP\ngJY@BDfZTCiRS]C^v\ngJY@BDfZjQCkQSf|pP<\ngJY@BDfZjQCkQSf|pP>\ngJY@BDfZjQCkQSgNCGMy``<\ngJY@BDfZjQCkQSgNCGMy``>\ngJY@BDfZjQCkQSgNbgMy``<\ngJY@BDfZjQCkQSgNbgMy``>\ngJY@BDfZjQCkQSj|pP<\ngJY@BDfZjQCkQSj|pP>\ngJY@BDfZjQCkQSkNCGMy``>\ngJY@BDfyhCiRs]CZv\ngJY@DDefhChqSdmu`dO{Q@=\ngJY@DDefhChqSduu`dO{Q@\ngJY@DDejhChqSdmu`dO{Q@=\ngJY@DDejhChqSdn\\FN[kAOovb@\ngJY@DDejhChqSduu`dO{Q@\ngJY@DDejhChqSdv\\FJ[kAH_vb@\ngJY@DDejhCiQU][Y{~tP\ngJY@DDejjIChqSdn\\FJ[kAHP<\ngJY@DDejjIChqSdn\\FJ[kAHP>\ngJY@DDfVdChqSdn]EN[kAO_vb@\ngJY@DDfVdChqShmu`go{Q@\ngJY@DDfVdChqShn]EN[kAO_vb@\ngJY@DDfVhChqSdmu`dO{Q@\ngJY@DDfVhChqSdmu`gw{Q@\ngJY@DDfVhChqSdmuoDO{Q@\ngJY@DDfVhChqSdmuoGw{Q@\ngJY@DDfVhChqSdn]EN[kAH_vb@\ngJY@DDfVhChqSdn]EN[kAOovb@\ngJY@DDfVhChqSdn]EN[k^H_vb@\ngJY@DDfVhChqSdn]EN[k^Oovb@\ngJY@DDfVhChqSduu`dO{Q@\ngJY@DDfVhChqSduuoDO{Q@\ngJY@DDfVhChqSdv]EN[kAH_vb@\ngJY@DDfVhChqSdv]EN[k^H_vb@\ngJY@DDfVhChqShmu`dO{Q@\ngJY@DDfVhChqShmu`gw{Q@\ngJY@DDfVhChqShn]EN[kAH_vb@\ngJY@DDfVhChqShn]EN[kAOovb@\ngJY@DDfVhChqShuu`dO{Q@\ngJY@DDfVhChqShv]EN[kAH_vb@\ngJY@DDfZTCkRRVzF}w}h`\ngJY@DDfZXChqSdmundO{Q@\ngJY@DDfZXChqSduundO{Q@\ngJY@DDfZjQChqSdmu`dO{Q@<\ngJY@DDfZjQChqSdmu`dO{Q@>\ngJY@DDfZjQChqSdn]EN[k^H_vb@<\ngJY@DDfZjQChqSduu`dO{Q@<\ngJY@DDfZjQChqShuu`dO{Q@<\ngJY@DDfZjQChqShuu`dO{Q@>\ngJY@DDfvdCkQrT\ngJY@DDfvdCkQrV|OP\ngJY@DDfvdCkQrWNbgH\ngJY@DDfvdCkQrWNbgMx^`\ngJY@DDfvhCkQrV|HP\ngJY@DDfvhCkQrV|O`\ngJY@DDfvhCkQrWNbgMxP`\ngJY@DDfvhCkQrWNbgMx_@\ngJY@DDfvhCkQrZ|HP\ngJY@DDfvhCkQr[NbgMxP`\ngJY@DDfydCkRrVzFul\ngJY@DDfyhCkRrV~Fula@\ngJY@DDfyhCkRrZ~Fula@\ngJY@DDfzjQCkQrWNBgMxP`<\ngJY@DDfzjQCkQrWNBgMxP`>\ngJY@DDfzjQCkQrWNbgMxP`<\ngJY@DDfzjQCkQrWNbgMxP`>\ngJY@HDef@CjQnmt}ZP=\ngJY@HDfZjQChqSdn]EN[kAHP<\ngJY@HDfZjQChqSdn]EN[kAHP>\ngJY@HDfZjQChqSduu`dH<\ngJY@HDfZjQChqSduu`dH>\ngJY@HDfZjQChqShn\\FN[kAHP<\ngJY@HDijhCjabgI[yApRD\ngJY@HDijhCjabgI[yApRG}i@=\ngJY@HDijhCjabgI[yApS{}i@\ngJY@HDijhCjabgI[yAwcx\ngJY@HDijhCjabgI\\xLTwrC`dO{R@\ngJY@HDijhCjabgIkyApRG}i@\ngJY@HDijjQCjabgI[yApSx<\ngJY@HDijjQCjabgI[yApSx>\ngJY@HDijjQCjabgI\\xLTwrC`dH<\ngJY@HDijjQCjabgI\\xLTwrC`dH>\ngJY@HDijjQCjabgIlxLTwrC`dH<\ngJY@HDijjQCjabgIlxLTwrC`dH>\ngJY@HDkjhChaSdmu`dH\ngJY@HDkjhChaSdnRFJ\\wVBP`\ngJY@HDkjjIChaSdn\\FJ[kAHP<\ngJY@HDkjjIChaSdn\\FJ[kAHP>\ngJY@HDkjjIChaSduu`dH<\ngJY@HDkjjIChaSduu`dH>\ngJY@HDkjjIChaSdv\\FJ[kAHP<\ngJY@HDkjjIChaSdv\\FJ[kAHP>\ngJY@LDef@CjQnml{@\ngJY@LDefdCiQU][Yv\ngJY@LDefdCiQU][Yz\ngJY@LDefdCiQU][iv\ngJY@LDefdCiQU][iz\ngJY@LDej@CjQnml{@\ngJY@LDejXCkQRV|HP\ngJY@LDejdCiQU][Yv\ngJY@LDejdCiQU][Yz\ngJY@LDejdCiQU][iz\ngJY@LDejdCiQUgAbfzwSl\ngJY@LDejjJCkQRV|HP<\ngJY@LDejjJCkQRV|HP>\ngJY@LDejjJCkQRWNCEMxP`<\ngJY@LDejjJCkQRWNCEMxP`>\ngJY@LDejjJCkQRWNCGMxP`<\ngJY@LDejjJCkQRWNCGMxP`>\ngJY@LDejjJCkQRZ|HP<\ngJY@LDejjJCkQRZ|HP>\ngJY@LDejjJCkQR[NCEMxP`<\ngJY@LDejjJCkQR[NCEMxP`>\ngJY@LDij@CiAS_HNv]`\ngJY@LDij@CiAS_HNv^`\ngJY@LDij@CiASgAcf~P]l}@\ngJY@LDij@CiAU_HNv]`\ngJY@LDij@CiAU_HNv^`\ngJY@LDij@CiAUgAcf~P]l}@\ngJY@LDijXChabdmt`dH\ngJY@LDijXChabdmt`gp\ngJY@LDijXChabdn\\FJ[iAHP\ngJY@LDijXChabdut`dH\ngJY@LDijXChabdv\\FJ[iAHP\ngJY@LDijXChabdv\\FN[yAwRD\ngJY@LDijXChabhn\\FN[yAwRD\ngJY@LDijXCkAdf~P]l}@\ngJY@LDijXCkAdgNCGM|`{Yz\ngJY@LDijXCkAdj~P]l}@\ngJY@LDijdChabdmx``\ngJY@LDijdChabdn\\FN[iAOP\ngJY@LDijdChabdn\\FN[i^OP\ngJY@LDijdChabhn\\FN[iAOP\ngJY@LDijdCkAdf~P]t{@\ngJY@LDijdCkAdf~P]t}@\ngJY@LDijdCkAdgNCGM|`{Yz\ngJY@LDijdCkAdgNCGM|`{iz\ngJY@LDijdCkAdj~P]t}@\ngJY@LDijjQChabdmt`dH<\ngJY@LDijjQChabdmt`dH>\ngJY@LDijjQChabdn\\FJ[iAHP<\ngJY@LDijjQChabdn\\FJ[iAHP>\ngJY@LDijjQChabdn\\FN[iAHP<\ngJY@LDijjQChabdn\\FN[iAHP>\ngJY@LDijjQChabdut`dH<\ngJY@LDijjQChabdut`dH>\ngJY@LDijjQChabdv\\FJ[iAHP<\ngJY@LDijjQChabdv\\FJ[iAHP>\ngJY@LDijjQChabhv\\FJ[iAHP<\ngJY@LDijjQChabhv\\FJ[iAHP>\ngJY@dAreInZ@zt\\eshis^DH\ngJYABCJSKTAuhiu^XH\ngJYABCJSMUHauhis]XI|<\ngJYABCJSMUHauhis^XH<\ngJYABCJSMUHauhis^XH>\ngJYABCJSMUHauhiu^XH<\ngJYABCJSMUHauhiu^XH>\ngJYABCJS\\tAtiYnam[@\ngJYADArSMLAtXirWNbgMxPmD\ngJYADEJS[RAuhyKgQSf|OP\ngJYALMJRuUEAuhiK^DH<\ngJYALMJRuUEAuhiK^DH>\ngJYALMJTu@At`iodG[Np\ngJYDC`DPHRni`NdEH\ngJYHC`DIKTpGRbd\ngJYHC`DIKTpGRbgNCGH\ngJYHC`DISTpGVCEUx``\ngJYHC`DISUHGVCIM|`{Yv\ngJYHC`VIKTpGRbf|G`\ngJYHCaDIKTpGRbd\ngJYHCaxIKTpGRbf|G`\ngJYHDPDIMsPGRefzFul\ngJYHE@DIUmLBGQBgI[k^O_vb@<\ngJYHE@DIUmTBGQBgI[k^H_vb@<\ngJYHE@DIUmTBGQBgI[k^H_vb@>\ngJYHE@DIUmTBGQBgI[k^Oovb@<\ngJYHE@DIUmTBGQBgI[k^Oovb@>\ngJYHE@DIUmTBGQBgQ[kAH_vb@>\ngJYHI`DIKTpGVbdmtODO{R@\ngJYHI`DIKTpGVbdutODO{R@\ngJYHIaxIKTpGVbdmtOGw{R@\ngJYHIaxIKTpGVbdutODO{R@\ngJYHLEPISTpGVCDv\\FJ[i^HP\ngJYHL`DILmPGVbdmxP`\ngJYHL`DILmPGVbduxP`\ngJYHL`DILtpGVbdmxP`\ngJYHL`DILtpGVddm|M{YB\ngJYHL`DIMmPGVcdmxPmL\ngJYHL`DIMmPGVcduxPmL\ngJYHM@DIKT@GTc_Cvv^`\ngJYHlEPKmJTuLAu`qMgAbf~Wmta@\ngJY`BEdfVhCiQR\ngJY`LDTfvhCiQs~tp\ngJY`hEiNyIej@ztTeoBG}i@\ngJYieLPxAeIyIZf@zTTmD\ngJ\\@@bdrQ@]QMtM{_{Q@\ngJ\\@@bdrQ@]QMtM{o{Q@\ngJ\\@@bdru@]JR[h[w_vb@\ngJ\\@@bdru@]ZJ]YpXyoLG}h`\ngJ\\@@bdru@]ZJ]YtTynawAZH\ngJ\\@@bdvt`]JV[h[Vp\ngJ\\@@bdvt`]JV[h[WP\ngJ\\@@bdvu@]JNP\ngJ\\@@bdvu@]JV[h[Vp\ngJ\\@@bdvu@]JV[h[WP\ngJ\\@@ldru@]ZJRwPzPmD\ngJ\\@@ldru@]ZJRwaC~tP\ngJ\\@@ldru@]ZJRypXyoBG}h`\ngJ\\@@ldru@]ZJRytTyoBG}h`\ngJ\\@@ldru@]ZJSWPzPmD\ngJ\\@@ldru@]ZJSWaC~tP\ngJ\\@@ldru@]ZRRwpwmdO{Q@\ngJ\\@@ldru@]ZRRwpwndO{Q@\ngJ\\@@ldru@]ZRRytTyoao]H_vb@\ngJ\\@@ldru@]ZRSWpwmdO{Q@\ngJ\\@@ldru@]ZRSWpwndO{Q@\ngJ\\@@ldvE@]KI[x[VrG}i`=\ngJ\\@@ldvE@]KI[x[Vs{}i`=\ngJ\\@@ldvE@]KIkx[VrG}i`=\ngJ\\@ABeWU@]HR[j[vv`@\ngJ\\@ABeWU@]HR[j[w_v`@\ngJ\\@ABeWU@]XJ\\wfC~t@\ngJ\\@ABeWU@]XJ\\ytTyoLG}h@\ngJ\\@ADeSU@]XTSWrwndO{HP\ngJ\\@ADe\\u@]DJ\\enlDaYA@=\ngJ\\@ADe\\u@]DJ\\es`qS]XIC~rB@\ngJ\\@AEddMTAuaYK_SZvPm@=\ngJ\\@AEddMTAuaYM_SZvPm@=\ngJ\\@ALe\\p@]PMumg_{P@\ngJ\\@ALe\\s@]HJkk[O_v`@\ngJ\\@ALe\\s@]XJSYpXinitaZ@\ngJ\\@ALe\\t`]HJkk[Nv`@\ngJ\\@ALe\\t`]HJlxLTwVz^m@\ngJ\\@AbeMK@]XLTwb{~t@\ngJ\\@AbeMK@]XLTypXioEw}h@\ngJ\\@AbeMK@]XLTypXyoEw}h@\ngJ\\@`bnLiLmPGRdfzF}o}h`\ngJ\\A@bIR[Z`NeKMtMkX\ngJ\\A@bnR[Z`NeKMtMkX\ngJ\\A@lIRYZ`NmEI[h]H_vb@\ngJ\\A@lIRYZ`NmEI[paZH\ngJ\\A@lIRYZ`NmEI\\xL\\wPzPmD\ngJ\\A@lIRYZ`NmEI\\xL\\waC~tP\ngJ\\A@lIRYZ`NmEI\\zJ\\waC~tP\ngJ\\A@lIRYZ`NmEIkh]H_vb@\ngJ\\A@lIRYZ`NmEIkpaZH\ngJ\\A@lIRYZ`NmII[x[vrG}h`\ngJ\\A@lIR[B`Nedm|MkYC~tp\ngJ\\AAciRfe`NlFJ[i]w_v`@\ngJ\\AAciRfe`NlFJ[q]Z@\ngJ\\DAcJATBTuTAt`qs`qR>\ngJ\\HEb@aIej@zTTmD\ngJ\\HEb@aIfe@zTdwPwmmD\ngJ\\HEb@aInZ@zTlwPvmmL\ngJ\\HHlOAJfj@zpXeoC{|eBb\ngJ\\HHlOAJfj@zpXfoBG|eBcZP\ngJ\\HIb@aIZ`@zd[x^vso}i@=\ngJ\\HIbOAIY`@zd[k[Nvd@=\ngJ\\H`cj@SnR[Z`NeKMtNkh\ngJ\\Hib@b]iRVh@NiF~Gml{ZP\ngJ\\IIb@b\\dmP@]RM|O[Yw~t`=\ngJ\\aibEIW[dfvhCiQs~rf@\ngJ]@EbDfVhCiQS~tP\ngJ]@ebEqeIej@zTTmD\ngJ]AEbCJSKTAthiZH\ngKP@DklVj@zhXirVzpRG|dml\ngKP@DklVj@zhXirWICEN[kAH_rRvp\ngKP@DklVj@zhXirWICEN[z]pRG|dml\ngKP@DklVjbPzhXirV~g\\D~IK[@<\ngKP@DklVjbPzhXirV~g\\D~IK[@>\ngKP@DklVjbPzhXirWICEN[kAOorRvp<\ngKP@DklVjbPzhXirWICEN[kAOorRvp>\ngKP@LdabjhCjabgI[zAPRG|dML\ngKP@LdabjjACjabgI[zAWbG|dML<\ngKP@LdabjjACjabgI[zAWbG|dML>\ngKP@LdabjjACjabgI\\dLTyohE^H_rPtp<\ngKP@LdabjjACjabgI\\dLTyohE^H_rPtp>\ngKP@LdabjjACjabgI\\xJ\\wtBoDOyHZX<\ngKP@LdabjjACjabgI\\xJ\\wtBoDOyHZX>\ngKP@LdabjjACjabgI\\zJ\\wtBoDOyHZX<\ngKP@LdabjjACjabgI\\zJ\\wtBoDOyHZX>\ngKP`@TixjjdPztTyoDG|dL\\<\ngKQ@@dmcUPGQbgI[kAH_rRvp\ngKQ@@eOEUTbGQbgI[iAH_rPqp<\ngKQ@@eOEUTbGQbgI[iAH_rPqp>\ngKQ@@eOEUTbGQbgI[i^H_rPqp<\ngKQ@@eOEUTbGQbgI[i^H_rPqp>\ngKQ@@eOEUTbGQbgI\\yNRwRBPdac`<\ngKQ@@eOEUTbGQbgI\\yNRwRBPdac`>\ngKQ@@eOEUTbGQbgI\\yNRwR|Pdac`<\ngKQ@@eOEUTbGQbgI\\yNRwR|Pdac`>\ngKX@@dmcUPGQbgI[kAH_rRvp\ngNp@DiYzA@zVVwQw]`=\ngNp@DiYzA@zVVwqw]oh=\ngNp@DiYzB@zVVwqw]lH=\ngNp@DiYzB@zVVwqw^lH\ngNp@DiYzB@zVVwq{^lH=\ngNp@Djfjj@zxXirVk[uApRFaXP\ngNp@Djfjj@zxXirVk\\dLRuoTGAHZEa@\ngNp@Djfjj@zxXirVk\\dNRuoTGAOjEa@\ngNp@Djfjj@zxXirVk\\lLTyKV}P\\DahVD\ngNp@Djfjj@zxXirVk\\lLTyKV}P\\Daogx\ngNp@Djfjj@zxXirVk\\lLTyKV}P\\D~hVD\ngNp@Djfjj@zxXirVk\\tLTek^hNBPtKB\ngNp@Djfjj@zxXirVk\\tLTek^hNB_TKB\ngNp@Djfjj@zxXirVskuApRFaXP\ngNp@Djfjj@zxXirVsldNRuoTGAOjEa@\ngNp@Djfjj@zxXirZk[uApRFaXP\ngNp@Djfjj@zxXirZk\\lLTyKV}P\\DahVD\ngNp@Djfjj@zxXirZk\\tLTek^hNBPtKB\ngNp@Djfjj@zxXitZk[uApRFaXP\ngNp@Djfjj@zxXitZskuApRFaXP\ngNp@DjfjjPTPzxXirVk\\tL\\ek^hNB_TK|<\ngNp@DjfjjPTPzxXirVk\\tL\\ek^hNB_TK|>\ngNp@DjfjjPTPzxXirZk\\tL\\ek^hNBPtK|<\ngNp@DjfjjPTPzxXirZk\\tL\\ek^hNBPtK|>\ngNp@DjfjjPTPzxXirZk\\xLRwjC`dMBp`<\ngNp@DjfjjPTPzxXirZk\\xLRwjC`dMBp`>\ngNp@DjfjjPTPzxXirZklxLRwjC`dMBp`<\ngNp@DjfjjPT`zxXirVk\\dL\\eoTGAOjEa@>\ngNp@DjfjjPT`zxXirVk\\tL\\ek^hNB_TK|>\ngNp@DjfjjPT`zxXirZk\\xLRwjC`dMBp`<\ngNp@DjfjjPT`zxXirZk\\xLRwjC`dMBp`>\ngNp@DjfjjPT`zxXirZklxLRwjC`dMBp`<\ngNp@DjfjjPT`zxXirZklxLRwjC`dMBp`>\ngNp@Djfjj`PzxXirVk\\tL\\ek^hNB_TKB<\ngNp@Djfjj`PzxXirVk\\tL\\ek^hNB_TKB>\ngNp@Djfjj`PzxXirZk\\dLRuoTGAHZEa@<\ngNp@Djfjj`PzxXirZk\\tL\\ek^hNBPtKB<\ngNp@Djfjj`PzxXirZk\\tL\\ek^hNBPtKB>\ngNp@DjfjjdPzxXirVk[uApRFa_`>\ngNp@DjfjjdPzxXirVk\\dLTeoTGAHZEa@<\ngNp@DjfjjdPzxXirVk\\dLTeoTGAHZEa@>\ngNp@DjfjjdPzxXirVk\\dLTuoTGAHZE~@<\ngNp@DjfjjdPzxXirVk\\dLTuoTGAHZE~@>\ngNp@DjfjjdPzxXirVk\\lLTyKV}P\\DahWx<\ngNp@DjfjjdPzxXirVk\\lLTyKV}P\\DahWx>\ngNp@DjfjjdPzxXirVk\\lLTyKV}P\\D~hWx<\ngNp@DjfjjdPzxXirVk\\tLTek^hNBPtK|<\ngNp@DjfjjdPzxXirVk\\tLTek^hNBPtK|>\ngNp@DjfjjdPzxXirVk\\xLRwjC`dMBp`<\ngNp@DjfjjdPzxXirVk\\xLRwjC`dMBp`>\ngNp@DjfjjdPzxXirVk\\xLZwjC`dMB@<\ngNp@DjfjjdPzxXirVk\\xLZwjC`dMB@>\ngNp@DjfjjdPzxXirVk\\xNRwjC`guBp`<\ngNp@DjfjjdPzxXirVk\\xNRwjC`guBp`>\ngNp@DjfjjdPzxXirVk\\xNZwjC`guB@<\ngNp@DjfjjdPzxXirVk\\xNZwjC`guB@>\ngNp@DjfjjdPzxXirVkkuApRFaXP<\ngNp@DjfjjdPzxXirVkkuApRFaXP>\ngNp@DjfjjdPzxXirVkldLTeoTGAHZEa@>\ngNp@DjfjjdPzxXirVkltLTek^hNBPtKB<\ngNp@DjfjjdPzxXirVklxLRwjC`dMBp`<\ngNp@DjfjjdPzxXirVklxLRwjC`dMBp`>\ngNp@DjfjjdPzxXirVklxLZwjC`dMBp`<\ngNp@DjfjjdPzxXirVklxLZwjC`dMBp`>\ngNp@DjfjjdPzxXirVslxLRwjC`dMBp`>\ngNp@DjfjjdPzxXirZk\\xNRwjC`dMBp`<\ngNp@DjfjjdPzxXirZk\\xNRwjC`dMBp`>\ngNp@DjfjjdPzxXirZkkuApRFaXP<\ngNp@DjfjjdPzxXirZkkuApRFaXP>\ngNp@DjfjjdPzxXitZk\\dJ\\eoTGAHZEa@>\ngNp@DjzZj@zhdejv}f}tahVD\ngNp@DjzZj@zhdejwNCGM{N{iCPlH\ngNp@DjzZj@zhdejwNbgM{M{iCPlH\ngNp@DjzZj@zhdejz}f}tahVD\ngNp@DjzZj@zhdelz}f}tahVD\ngNp@DjzZj@zxXirVk[gAHZEa@\ngNp@DjzZj@zxXirVk[v]pRFaXP\ngNp@DjzZj@zxXirVk\\fJ\\en]xahVD\ngNp@DjzZj@zxXirVk\\lLTyKVywbFaXP\ngNp@DjzZj@zxXirVk\\lLTyKV}g\\DahVD\ngNp@DjzZj@zxXirVk\\tLTyK\\xICPlH\ngNp@DjzZj@zxXirVk\\tLTyK\\{qCPlH\ngNp@DjzZj@zxXirVk\\tLTyK^snBPtKB\ngNp@DjzZj@zxXirVk\\tLTyK^sn|PtKB\ngNp@DjzZj@zxXirVk\\xLZwl{`dMB@\ngNp@DjzZj@zxXirVk\\xL\\wNBPtKB\ngNp@DjzZj@zxXirVk\\xL\\wl{`dMBp`\ngNp@DjzZj@zxXirVk\\zJZwNBPtK|\ngNp@DjzZj@zxXirVk\\zJ\\wNBPtKB\ngNp@DjzZj@zxXirVk\\zJ\\wN|PtKB\ngNp@DjzZj@zxXirVk\\zJ\\wl{oDMBp`\ngNp@DjzZj@zxXirVkkgAHZEa@\ngNp@DjzZj@zxXirVsldLRuoYwAHZEa@\ngNp@DjzZj@zxXitVk[gAHZEa@\ngNp@DjzZj@zxXitVk[v]pRFaXP\ngNp@DjzZj@zxXitVk\\tLTyK^snBPtKB\ngNp@DjzZj@zxXitVk\\xL\\wNBPtKB\ngNp@DjzZj@zxXitVkldL\\eoYwAHZEa@\ngNp@DjzZjbPzhdej{NCGM{N{iCPlH<\ngNp@DjzZjbPzxXirVk\\tLTyk\\xICPop<\ngNp@DjzZjbPzxXirVk\\tLTyk\\xICPop>\ngNp@DjzZjbPzxXirVk\\tLTyk^snBPtK|>\ngNp@DjzZjbPzxXirVklxL\\wl{`dMBp`<\ngNp@DjzZjbPzxXirVklxL\\wl{`dMBp`>\ngNp@DjzZjbPzxXirVslxLRwl{`dMBp`<\ngNp@DjzZjbPzxXirVslxLRwl{`dMBp`>\ngNp@LdadBj@zNRu[^sZvPtKB=\ngNp@LdadBj@zNRu[^sZvPtKC~RqI@=\ngNp@LdadBj@zNRu[^sZvPtKC~VqIi@=\ngNp@LdadBj@zNRu[^sZvPtK|=\ngNp@LdadBj@zNRu[^sZvPtK}~VqIi@=\ngNp@LdadBj@zNRu[^sZzPtKB\ngNp@LdadBj@zNRu[^sjzPtKB=\ngNp@LdadBj@zNRu[^sjzPtKC~RqI@=\ngNp@LdadBj@zNRu[dqSdm{MkiCPlH\ngNp@LdadBj@zNRu[gASV}gUtahWx\ngNp@LdadBj@zNRu[gASf}gUtahVD\ngNp@LdadBj@zNRu[gQSV}futahWx\ngNp@LdadBj@zNRu[gQSf}futahVD\ngNp@LdadBj@zNRu]^sZvPtKB=\ngNp@LdadBj@zNRu]^sZvPtKC~RqI@=\ngNp@LdadBj@zNRu]^sZzPtKB\ngNp@LdadBj@zNRu]dqSdm{MkiCPlH\ngNp@LdadBj@zNRu]gQSV}futahVD\ngNp@LdadBj@zNRu]gQSV}futahVG|ebR\ngNp@LdadBj@zNRv]^sZvPtKB=\ngNp@LdadBj@zNRv]^sZzPtKB\ngNp@LdadBj@zNRv]daRVm{NkiCPlH\ngNp@LdadBj@zNRv]dqRVm{MkiCPlH\ngNp@LdadBj@zNRv]gQSf}futahVD\ngNp@LdadBj@zNSU[^sZvPws|=\ngNp@LdadBj@zNSV[^sZvPtK|=\ngNp@LdadBj@zNSV[gQSV}futahWx\ngNp@LdadBj@zNSV]^sZvPtKB=\ngNp@LdadBj@zNSV]^sZzPtKB\ngNp@LdadBj@zNSV]dqSdm{MkiCPlH\ngNp@LdadBj@zNSV]gQSf}futahVD\ngNp@LdadBjfPzNRu[^sZvPtK}~Rqi@-\ngNp@LdadBjfPzNRu[gQSf}futahWx>\ngNp@LdadBjfPzNRu]dqSfm{MkiCPlH<\ngNp@LdadBjfPzNRu]dqSfm{MkiCPlH>\ngNp@LdadBjfPzNRu]gQSf}futahVD<\ngNp@LdadBjfPzNRu]gQSf}futahVD>\ngNp@LdadBjfPzNRv[^sZvPtK|+\ngNp@LdadBjfPzNRv[^sZvPtK|-\ngNp@LdadBjfPzNRv[^sZvPtK}~Rqi@+\ngNp@LdadBjfPzNRv[^sZvPtK}~Rqi@-\ngNp@LdadBjfPzNRv[gQRV}futahW{|ecR<\ngNp@LdadBjfPzNRv[gQRV}futahW{|ecR>\ngNp@LdadBjfPzNRv]gQRV}futahVD<\ngNp@LdadBjfPzNRv]gQRV}futahVD>\ngNp@LdadBjfPzNSV[gQSf}futahWx<\ngNp@LdadBjfPzNSV[gQSf}futahWx>\ngNpB@xQpSagCIIKJj`NbDmVwl|o[uBpe`XTP\ngNpB@xQpk`wAJkjj`NbENRwNBPws|\ngNpBADFPl`yAInij`NmENP\ngNpCAHR`TaiB]dTaeT@GTc]W[z\ngNpD@DHHRZzj@CiQK_DMv}`=\ngNpD@DHHRZzj@CiQK_Guv}`=\ngNpD@DHHRZzj@CiQM_DMv}`=\ngNpD@DHHRZzjhCjqrVk\\eNRuobFaXP\ngNpD@DIpRYjfhCiqSdmVwH|PtK|\ngNpD@DIpRYjfhCjrRVk[t[vrFaXP\ngNpD@DIpRYjfhCjrRVk[t[vrFa_`\ngNpD@DIpRYjfhCjrRVk[t[wRFaXP\ngNpD@DSpRZYj@CkQrVypRF{^p=\ngNpD@DSpRZYj@CkQtZypRF{^p=\ngNpD@DSpRZYj@CkQtZypRF{_P\ngNpD@DSpRZYj@CkQtZypRF}_P=\ngNpD@DSpRZYj@CkQt[MbgIZwNBPwkz=\ngNpD@DSpRZYjBQCkQrZypRF{^p+\ngNpD@DSpRZYjBQCkQrZypRF{^p-\ngNpD@DSpRZYjhCiqSdmVwNBPtKB\ngNpD@DSpRZYjjQCiqSduVwNBPtKB<\ngNpD@DSpRZYjjQCiqSduVwNBPtKB>\ngNpD@bIpRYjfhCjrRVk[t[vrFaXP\ngNpD@bQpRZZj@CkQtZypRF{^p=\ngNpD@bSpRZYj@CkQtZypRF{^p=\ngNpD@bSpRZYj@CkQtZypRF{_P\ngNpD@bSpRZYjBQCkQrZypRF{^p+\ngNpD@bSpRZYjBQCkQrZypRF{^p-\ngNpD@bSpRZYjhCiqSdmVwNBPtKB\ngNpD@xN`RjZjXCiabgIZwJC`dMz\ngNpD@xQpRjzj@CkArV}glDanwl=\ngNpD@xQpRjzj@CkArV}glDanwt\ngNpD@xQpRjzj@CkAtZ}glDanwl=\ngNpD@xQpRjzj@CkAt[IbgM[v^pRF{_P\ngNpD@xQpRjzjBACkArZ}glDanwl-\ngNpD@xQpRjzjhCiaSdmVwNBPtKB\ngNpD@xQpRjzjhCiaSdmVwl}`dMBp`\ngNpD@xRPRjzj@CkAtZypRF{^p=\ngNpD@xRPRjzj@CkAtZypRF{_P\ngNpD@xUpRjZjdCiabgIVwJC`dM|\ngNpD@xUpRjZjjQCiabgIWWjC`dM|p`<\ngNpD@xUpRjZjjQCiabgIWWjC`dM|p`>\ngNpDADFHR[jZhCjqSfk\\fJRuoevaXP\ngNpDAHJPRZzj@CiQK_DMv~`\ngNpDAHJPRZzj@CiQK_Guv}`=\ngNpDAHJPRZzj@CiQK_Guv~`\ngNpDAHJPRZzj@CiQK_Guz~`=\ngNpDAHJPRZzjXCjqrVk[xaoVD\ngNpDAxKpR[ijhCjqrVk[xahVD\ngNpDAxSpRjyj@CkAtZypRF{^p=\ngNpDAxSpRjyjBACkArZypRF{^p+\ngNpDAxSpRjyjBACkArZypRF{^p-\ngNpD`DR`Dsdffj`@zt]Fn\\DaoWt=\ngNpDaxF`Dgdjfj`@zpTynTGAnwl=\ngNpDaxF`Dgdjfj`@zpUZnTGAnwl=\ngNpDaxF`Dgdjfj`@zpUZoTGAOkm{@=\ngNpDaxF`Dgdjfj``PzpTznTGAnwl+\ngNpDaxF`Dgdjfj``PzpTznTGAnwl-\ngNpDaxF`Dgdjfj``PzpTznTGAnwt<\ngNpDaxF`Dgdjfj``PzpTzoTGAOkm{IPx`+\ngNpDaxF`Dgdjfj``PzpTzoTGAOkm{IPx`-\ngNpDaxF`Dgdjfjj@zXXisUmr`xMBp`\ngNpDaxF`Dgdjfjj@zXXisUmz`xI}PlH\ngNpDaxF`Dgdjfjj@zXXjuUmr`xMBp`\ngNpDaxF`Dgdjfjj`PzXXiuUmr`xMBp`<\ngNpDaxF`Dgdjfjj`PzXXiuUmr`xMBp`>\ngNpDaxR`Dsdffj`@zt]Fn\\DaoWt=\ngNpDaxR`Dsdffj`@zt]FoQ{AH[u}@=\ngNpDaxR`Dsdffj`dPzt\\foQ{AH[u}I@h`+\ngNpDaxR`Dsdffj`dPzt\\foQ{AH[u}I@h`-\ngNpE@DSpdiMMU@AuhzM\\xIC]oX=\ngNpE@bSpdiMMU@AuhzM\\xIC]oX=\ngNpE@bSpdiMMUAHauhyM\\xIC]oX+\ngNpE@bSpdiMMUAHauhyM\\xIC]oX-\ngNpE@bSpdiMMUTAtxirVk[gAHZEa@\ngNpEADR`gIMMU@AuhzM\\xIC^oh=\ngNpEAHR`gIMMU@AuhzM\\xIC]oX=\ngNpEAHR`gIMMU@AuhzM\\xIC^oh=\ngNpEAHR`gIMMU@AuhzMfqSdm[gAH[u}@=\ngNpEAVRDdiMMU@AuhzM\\xIC]oX=\ngNpEAVSpdiMMU@AuhzM\\xIC]oX=\ngNpEAVSpdiMMU@AuhzM\\xIC]oh\ngNpEAVSpdiMMUTAtxirVk[gAHZEa@\ngNpEAbSpdiMMU@AuhzM\\xIC]oX=\ngNpEAxF`DiUMU@Au`ju\\hNC]oX=\ngNpEAxF`DiUMUTAtpqSfk[eApZEa@\ngNpEAxRPDiU]U@Au`zM\\xIC]oX=\ngNpEAxRPDiU]U@Au`zM\\xIC^oh=\ngNpEAxR`gIMMU@AuhzM\\xIC^oh=\ngNpEAxSpDiUMUTAupqSdmgWjC`dMBp`\ngNpEAxSpDiU]U@Au`zM\\xIC]oX=\ngNpEAxSpDiU]UA@au`yM\\xIC]oX+\ngNpEAxSpDiU]UA@au`yM\\xIC]oX-\ngNpEAxSpDiU]UTAtpirVk[gAHZEa@\ngNpH@DIMMU@AuhyK\\xIC]oX=\ngNpH@DIMMU@AuhzM\\xIC]oX=\ngNpH@DIMMU@AuhzMdqSfms`dMv~`\ngNpH@DIMMUAHauhyK^cvBPw[w~RAQ@-\ngNpH@DIMMUAHauhyMdqSfms`dMv~`<\ngNpH@DIMMUAHauhyMdqSfms`dMv~`>\ngNpH@DIMuMTAuYYKUmzMkYCPlH\ngNpH@DIMuMTAuYYKUuzMkYCPlH\ngNpH@DIMuMTAuYYKYuzMkYCPlH\ngNpH@DISmW@At`iodF{_P\ngNpH@bIMMU@AuhzMdqSfms`dMv~`\ngNpH@bISmW@At`iodF{_P\ngNpH@xIUMU@AtPirV}P\\Danwl=\ngNpH@xIUMU@AtPirV}P\\Danwt\ngNpH@xIUMU@AtPirV}P\\DaoWt=\ngNpH@xIUMU@AtPirV}P\\D~nwl=\ngNpH@xIUMU@AtPirWNCFmz`xIC]oh\ngNpH@xIUMU@AtPirZ}P\\Danwl=\ngNpH@xIUMU@AtPirZ}P\\Danwt\ngNpH@xIUMU@AtPirZ}P\\DaoWt=\ngNpH@xIUMU@AtPir[NCfmz`xIC]oh\ngNpH@xIUMU@AtPitZ}P\\Danwl=\ngNpH@xIUMU@AtPitZ}P\\Danwt\ngNpH@xIUMU@AtPjtV}P\\D~nwl=\ngNpH@xIUMU@AtPjtZ}P\\Danwl=\ngNpH@xIUMU@AtPjtZ}P\\Danwt\ngNpH@xIUMU@AtPjt[NCFmz`xIC]oh\ngNpH@xIUMUA@atPitV}P\\D~nwl+\ngNpH@xIUMUA@atPitV}P\\D~nwl-\ngNpH@xIUMULAuPrSdmz`xIC^oX\ngNpH@xIUMULAupqSdmVwJC`dKB\ngNpH@xIUMULAupqSdmVwjC`dMzp`\ngNpH@xIUMULAupqSdmVwjC`dMzpdbZP\ngNpH@xIUMULAupqSdmWWjC`dMzp`\ngNpH@xIUMULAupqSduVwJC`dKB\ngNpH@xIUMUTAupqSdmVwjC`dMBp`\ngNpH@xIUMUTAupqSdmVwjC`guBp`\ngNpH@xIUMUTAupqSduVwjC`dMBp`\ngNpH@xIUMUTAupqShuVwjC`dMBp`\ngNpHABIUMM@AtPitZ}W\\Danwl=\ngNpHADIMMULAtxirVk\\vJ\\ek\\xIC^op\ngNpHAHILuUUHatxirVk\\zJ\\wNBPtKB<\ngNpHAHIMMU@AuhyK\\xIC]oX=\ngNpHAHIMMUUHatxirVk\\vJ\\ek\\xI}PlH<\ngNpHAbILuUUHatxirVk\\zJ\\wNBPtKB>\ngNpHAxIMMU@AuhzM\\xIC]oX=\ngNpHAxIMMU@AuhzM^cvBPw[v=\ngNpHAxITuUTAupqUhmVwjC`dMBp`\ngNpHAxITuUU@aupqSdmVwjCoDMBp`<\ngNpHAxITuUU@aupqSdmVwjCoDMBp`>\ngNpHAxITuUU@aupqUdmVwjCoDMBp`<\ngNpHAxITuUU@aupqUdmVwjCoDMBp`>\ngNpHAxIUMA@AoUw]H[m{@=\ngNpHAxIUMM@AtPitZypRF{^p=\ngNpHAxIUMM@AtPitZ}W\\Danwl=\ngNpHAxIUMMA@atPirZ}W\\Danwl+\ngNpHAxIUMMA@atPirZ}W\\Danwl-\ngNpHGPYICHETAulfm\\sZvPtH=\ngNpIABBTjfj`@zHTzM^hNBPw[v=\ngNpIABBTjfj`@zHUZM^hNBPw[v=\ngNpIAxBTjZjj@zxXirVk[u^wbFaXP\ngNpIAxBTjZjj`PzxXirVk[uAwbFaXP<\ngNpIAxBTjZjj`PzxXirVk[uAwbFaXP>\ngNpIAxBTjfj`@zHTyK^hNBPwkz=\ngNpIAxBTjfj`@zHTyM^hNBPw[v=\ngNpIAxBTjfj`@zHTyM^hNBPwkz=\ngNpIAxBTjfj`@zHTzM^hNBPw[v=\ngNpIAxBTjfj`@zHTzM^hNBPw[z\ngNpIAxBTjfj`@zHTzM^hNBPwkz=\ngNpIAxBTjfj`@zHTzMgAcV}P\\Danwt\ngNpIAxBTjfj`@zHUZK^hNB_W[v=\ngNpIAxBTjfj`@zHUZM^hNBPw[v=\ngNpIAxBTjfj`@zHUZM^hNBPw[z\ngNpIAxBTjfjf@zxXjtZk[eApREa@\ngNpIAxBTjfjj@zxXirVk[uApRFaXP\ngNpIAxBTjfjj@zxXirZk[uApRFaXP\ngNpIMP[ldadBj@zNRu[^sZvPtKB=\ngNpIMP[ldadBj@zNRu]^sjzPtKB=\ngNpIMP[ldadBj@zNRv]^sZvPtKB=\ngNpIMP[ldadBj@zNRv]^sjzPtKB=\ngNpIMP[ldadBj@zNSV]^sZvPtKB=\ngNpIMP[ldadBj@zNSV]^sjzPtKB=\ngNpIMP[ldadBj@zNSV]dqSdm{MkiCPlH\ngNpL@DIpK`dsUMPGQdfk[t[vszaXP\ngNpL@VSDVIddaeT@GRBZ~H[m{@=\ngNpL@VSDVIddaeT@GRBZ~H[m}@\ngNpL@xIpsadTaeT@GTc^cr}oW[v=\ngNpL@xQpSaddaeT@GRBZ}gexanwl=\ngNpL@xQpSaddaeT@GRBZ}gexaoWw|dCB=\ngNpL@xQpSaddaeUPGUCdmVwl|oDMBpd`XP\ngNpL@xUp[`eTuUPGUCENRwjC`dM|@\ngNpLABIps`dsUUTbGUbdmVwN|PtKB<\ngNpLABIps`dsUUTbGUbdmVwN|PtKB>\ngNpLADJHtQdTaeUPGQbVskjaXP\ngNpLAHJPtadTaeT@GTc]W[v=\ngNpLAHJPtadTaeT@GTc]W[z\ngNpLAHJPtadTaeT@GTc]Wkz=\ngNpLAHJPtadTaeTpGQbVk[j}XP\ngNpLAHJPtadTaeTpGQbVk[qa@\ngNpLAHJPtadTaeTpGQbVkkqa@\ngNpLAHJPtadTaeTpGRbZzoWl\ngNpLAHJPtadTaeTpGRbZzoWt\ngNpLAHJPtadTaeUPGQbVk[jaXP\ngNpLAHJPtadTaeUTJGQbVk[ja_`<\ngNpLAHJPtadTaeUTJGQbVkkjaXP<\ngNpLAHJPtadTaeUTJGQbVkkjaXP>\ngNpLAxIps`dsUUTbGUbdmVwN|PtKB<\ngNpLAxIps`dsUUTbGUbdmVwN|PtKB>\ngNpLaxKpw`itiLtuTAuXiMYusoDMBp`\ngNpMAxZ`M@IRjZjhCjabfk[uAwczaX_rRNH\ngNpMAxZ`M@IRjZjjACjabfk[eAwjEaIHx`<\ngNpMAxZ`M@IRjZjjACjabfk[eAwjEaIHx`>\ngNpP@cTfzZj@zt\\moFD\ngNpXHmQxYIIXuUBau`e[^LH<\ngNpXHmQxYIIXuUBau`e[^LH>\ngNpXHmQxYIIXuUBau`e]^LH<\ngNpXHmQxYIIXuUBau`e]^LH>\ngNp`@TfZZj@zlTyjv~pZEa@\ngNp`@TfZZj@zlTzjv~pZEa@\ngNp`@TfZZjb`zlTyjv~pZE~@<\ngNp`@TfZZjb`zlTyjv~pZE~@>\ngNp`@TfZZjb`zlTyjwIbgI[{AhVD>\ngNp`@TfZZjb`zlTyjwNbdm}`tKB<\ngNp`@TfZZjb`zlTyjwNbdm}`tKB>\ngNp`@TfZZjb`zlTyjwNbdm}`tK|>\ngNp`@TfZZjb`zlTyjwNbdm}oTKB<\ngNp`@TfZZjb`zlTyjwNbdm}oTKB>\ngNp`@TfZZjb`zlTyjwNbfm}`tK|<\ngNp`@TfZZjb`zlTyjwNbfm}`tK|>\ngNp`@TfZZjb`zlTyj{Nbfm}`tKB<\ngNp`@TfZZjb`zlTzjwNbdm}`tKB<\ngNp`@TfZZjb`zlTzjwNbdm}`tKB>\ngNp`@TfZZjb`zlTzjwNbfm}`tK|<\ngNp`@Tfzfjf`zlTyjwNbdmuPlH>\ngNp`@dfnj`@zTRwqC]oX=\ngNp`@dfnj`@zTRwqC]oh\ngNp`@dfnj`@zTRwq}]oX=\ngNp`@dfnj`@zTRyr\\uobF{_P\ngNp`@dfnj`@zTRyr\\uocz{_P\ngNp`@dfnj`@zTSWqC]oX=\ngNp`@dfnj`dPzTRypTuobF{_P>\ngNp`@dfnjf@zl\\ejwNSdmtPlH\ngNp`@dfnjj@zl\\ejv~HZEa@\ngNp`@dfnjj@zl\\ejwISdm[xahVD\ngNp`@dfnjjTV`zl\\ejwNBdm|PtKB<\ngNp`@dfnjjTV`zl\\ejwNBdm|PtKB>\ngNp`@dfnjjdPzl\\ejwMBgIZwqCPlH<\ngNp`@dfnjjdPzl\\ejwMBgIZwqCPlH>\ngNp`@dfnjjfPzl\\ejwICEM[xahWx<\ngNp`@dfnjjfPzl\\ejwNSdm|PtKB<\ngNp`@dfnjjfPzl\\ejwNSdm|PtKB>\ngNp`@dfzZj@zl\\ejv~HZEa@\ngNp`@dfzZj@zl\\ejv~HZEaIXd`\ngNp`@dfzZj@zl\\ejv~HZEaKXdt`\ngNp`@dfzZj@zl\\ejv~HZE~@\ngNp`@dfzZj@zl\\ejv~H[y~@\ngNp`@dfzZj@zl\\ejwIbgI[xahVD\ngNp`@dfzZj@zl\\ejwNbgM|PtKB\ngNp`@dfzZj@zl\\ejz~HZEa@\ngNp`@dfzZj@zl\\elz~HZEa@\ngNp`@dfzZjfPzl\\ejv~HZE~IXt`<\ngNp`@dfzZjfPzl\\elv~HZE~@<\ngNp`@dfzZjfPzl\\elv~HZE~@>\ngNp`@dfzjj@zl\\ejv~HZEa@\ngNp`@dfzjjdPzl\\ejwNBgM|PtKB>\ngNp`ATffjjTRPzlTyJv~pSya@<\ngNp`ATffjjTRPzlTyJwMCEIZwvBPlH<\ngNp`ATffjjTRPzlTyJwMCEIZwvBPlH>\ngNp`ATffjjTRPzlTyJwNbfm}`dKB<\ngNp`ATffjjTRPzlTyJwNbfm}`dKB>\ngNp`ATffjjTRPzlTyJwNbfm}`dK|<\ngNp`ATffjjTRPzlTyJwNbfm}`dK|>\ngNp`ATffjjTRPzlTyJwNbfm}`gsB>\ngNp`ATffjjTRPzlTyJwNbfm}oGsB>\ngNp`ATffjjTRPzlTyJwNcfm}`gsB<\ngNp`ATffjjTRPzlTyJwNcfm}`gsB>\ngNp`ATffjjTR`zlTyJwICEM[{AHVD>\ngNp`ATffjjTR`zlTyJwNbdm}`dKB<\ngNp`ATffjjTR`zlTyJwNbfm}`dKB<\ngNp`ATffjjTR`zlTyJwNbfm}`dKB>\ngNp`ATffjjTR`zlTyJwNbfm}`dK|<\ngNp`ATffjjTR`zlTyJwNcfm}`gsB<\ngNp`ATffjjTR`zlTyLv~pREa@<\ngNp`ATffjjTR`zlTyLz~pREa@>\ngNp`ATffjjb`zlTyJv~pREa@<\ngNp`ATffjjb`zlTyJv~pREa@>\ngNp`ATffjjb`zlTyJv~wcya@<\ngNp`ATffjjb`zlTyJwIbgM[{AHVD>\ngNp`ATffjjb`zlTyJwNCFm}`dKB<\ngNp`ATffjjb`zlTyJwNCFm}`dKB>\ngNp`ATffjjb`zlTyJz~pREa@>\ngNp`ATffjjb`zlTzLv~pREa@<\ngNp`ATffjjb`zlTzLv~pREa@>\ngNpa@erS]MU@]VNRu[_DMBp`\ngNpa@erS]MU@]VNRu[_DMBpdlRP\ngNpa@erS]MU@]VNSV]_DMBp`\ngNpdH`DTHrRPqZjYCharYm|PwsB<\ngNpdH`DTHrRPqZjYCharYm|PwsB>\ngNpdJqHJPRZzjXCkQrV|HP\ngNpdJqHJPRZzjXCkQrV|O`\ngNpdJqHJPRZzjXCkQrZ|HP\ngNpeE`DSpGYEHYMAHauHwUv}`+\ngNphH`DYIHXm@At`eobF{^p=\ngNphH`DYIHXm@At`eobF{_P\ngNphH`DYIHXm@At`eocz{^p=\ngNphH`DYIHXm@At`eocz}_P=\ngNphH`DYIHXm@At`fobF{^p=\ngNphH`DYIHXm@At`fobF{_P\ngNphH`DYIHXm@At`fobF}_P=\ngNphH`DYIHXm@At`fsdyk_DMv~`\ngNphH`DYIHXmLAuPyMUmtPlH\ngNphH`DYIHXmLAuPyMUm|PwkB\ngNphH`DYIHXmLAuPyMUutPlH\ngNphH`DYIHXmLAuPyMUu|PwkB\ngNphH`DYIHXmLAu`zK_DMz~`\ngNphH`DYIHXmLAu`zM_DMz~`\ngNphH`DYIHXmTAuPyKUm|PtKB\ngNphH`DYIHXmTAuPyMUm|PtKB\ngNphH`DYIHXmULauPyKUn\\gI[xahVD<\ngNphH`DYIHXmULauPyKUn\\gI[xahVD>\ngNphH`DYIHXmULauPyMUm|PtK|<\ngNphH`DYIHXmULauPyMUu|PtKB<\ngNphH`DYIHXmULauPyMUu|PtKB>\ngNphH`VYIHYU@At`fobF{^p=\ngNphH`xYIHYU@At`eobF{^p=\ngNphH`xYIHYU@At`fobF{^p=\ngNphH`xYIHYU@At`fobF{_P\ngNphH`xYIHYU@At`fobF}_P=\ngNphH`xYIHYUTAuPyKUm|PtKB\ngNphHaxYIHXuA@at`eobF{^p+\ngNphHaxYIHXuA@at`eobF{^p-\ngNphHaxYIHXuA@at`fobF{^p+\ngNphHaxYIHXuA@at`fobF{^p-\ngNphJpDIMMULAtXirVzpRD\ngNphJqHIMMULAtXirVzpRD\ngNphJqbIMMULAtXirVzpRD\ngNpi@iPSdfnj`@zTSWqC]oX=\ngNpi@iPSdfnj`@zTSWqC^oh=\ngNplJqDJHtQdTaeTpGRbT\ngNplJqHJPtadTaeTpGRbT\ngNpmJqDJHtP~rJPrjXCiQJ\ngNpmJqHJPt`~rJPrjXCiQJ\ngNq@@dju\\@GTc]W[v=\ngNq@@dju\\@GTc]W[z\ngNq@@dsSUPGSbgIZmn\\DahVD\ngNq@@dsSUPGSbgIZmn\\DahWx\ngNq@@dsSUPGSbgIZmn]xahVD\ngNq@@dsSUPGSbgIZmrXirVypRFaXP\ngNq@@dsSUPGSbgIZmrXirVywbFaXP\ngNq@@dsSUPGSbgIZmshik\\xICPop\ngNq@@dsSUPGSbgIZmshik\\{qCPop\ngNq@@dsSUPGSbgIZmshis\\xICPlH\ngNq@@dsSUPGSbgIZmshis\\{qCPlH\ngNq@@dsSUPGSbgIZnn\\DahVD\ngNq@@dsSUPGSbgIZnn]xahVD\ngNq@@dsSUPGSbgIZnshik\\xICPlH\ngNq@@dsSUPGSbgI[Nn\\DahVD\ngNq@@dsSUPGSbgQZmn\\DahVD\ngNq@@dsSUPGSbgQZmn\\DahWx\ngNq@@dsSUPGSbgQZmshik\\xICPop\ngNq@@dsSUPGSbgQZmshis\\xICPlH\ngNq@@dsSUPGSbgQZnn\\DahVD\ngNq@@dsSUTRGSbgIZmrXisVypRFa_`<\ngNq@@dsSUTRGSbgIZmrXisVypRFa_`>\ngNq@@dsSUTRGSbgIZmrXisVywbFa_`<\ngNq@@dsSUTRGSbgIZmrXisVywbFa_`>\ngNq@@dsSUTRGSbgIZmshis\\xICPop<\ngNq@@dsSUTRGSbgIZmshis\\xICPop>\ngNq@@dsSUTRGSbgIZmshis\\{qCPop<\ngNq@@dsSUTRGSbgIZnshis\\xICPlH<\ngNq@@dsSUTRGSbgIZnshis\\xICPlH>\ngNq@@dsSUTRGSbgQZmshis\\xICPop>\ngNq@@dsSUTRGSbgQZnshis\\xICPlH<\ngNq@@dsUURbRGSbgIZmsPqSfms`dMB@<\ngNq@@dsUURbRGSbgIZmshis\\xICPop<\ngNq@@dsUURdRGSbgIZmshiK\\xIC_Op>\ngNq@@dsUURdRGSbgIZmshis\\xICPop<\ngNq@@dsUURdRGSbgIZmshis\\xICPop>\ngNq@@dsUURdRGSbgIZnshis\\xICPlH<\ngNq@@dsUUTbGSbgIZmn\\DahVD<\ngNq@@dsUUTbGSbgIZmn\\DahVD>\ngNq@@dsUUTbGSbgIZmn\\DahWx>\ngNq@@dsUUTbGSbgIZmrPqSfypRFaXP<\ngNq@@dsUUTbGSbgIZmrXirVypRFaXP<\ngNq@@dsUUTbGSbgIZmrXirVypRFaXP>\ngNq@@dsUUTbGSbgIZmrXirVywbFaXP<\ngNq@@dsUUTbGSbgIZmrXirVywbFaXP>\ngNq@@dsUUTbGSbgIZmsPqSdms`dMBp`<\ngNq@@dsUUTbGSbgIZmsPqSdms`dMBp`>\ngNq@@dsUUTbGSbgIZms`qs\\xICPlH<\ngNq@@dsUUTbGSbgIZmshik\\xICPop<\ngNq@@dsUUTbGSbgIZmshik\\xICPop>\ngNq@@dsUUTbGSbgIZmshis\\xICPlH<\ngNq@@dsUUTbGSbgIZmshis\\xICPlH>\ngNq@@dsUUTbGSbgIZmshis\\{qCPlH<\ngNq@@dsUUTbGSbgIZmshis\\{qCPlH>\ngNq@@dsUUTbGSbgIZnshik\\xICPlH>\ngNq@@dsUUTbGSbgQZmn\\DahVD<\ngNq@@dsUUTbGSbgQZmn\\DahVD>\ngNq@@dsUUTbGSbgQZms`qk\\xICPop>\ngNq@@dsUUTbGSbgQZms`qs\\xICPlH<\ngNq@@dsUUTbGSbgQZms`qs\\xICPlH>\ngNq@@dsUUTbGSbgQZmshis\\xICPlH>\ngNq@@dtuT@GVcdms`dMv}`=\ngNq@@dtuT@GVcdms`dMv}dd\\P=\ngNq@@dtuT@GVcdms`dMv~`\ngNq@@dtuT@GVcdmsoGuv~`\ngNq@@dtuT@GVcdn\\FM[gAH[m}@\ngNq@@dtuT@GVchus`dMv}`=\ngNq@@dtuT@GVchus`dMv~`\ngNq@@dtuT@GVchus`dMz~`=\ngNq@@dtuT@GVchvSENZwNBPw[z\ngNq@@dtuT@GVchvVFJ\\ek\\xIC^oh=\ngNq@@dtuT@GVchv\\FM[gAH[m}@\ngNq@@dtuTDbGVcdms`guv}`+\ngNq@@dtuTDbGVcdms`guv}`-\ngNq@@dtuTDbGVcdms`guv}dd\\P-\ngNq@@dtuTDbGVcdn]EM[gAH[m}@<\ngNq@@dtuTDbGVcdn]EM[gAH[m}@>\ngNq@@dtuTDbGVcdn]GM[gAOkm}@<\ngNq@@dtuTDbGVcdn]GM[gAOkm}@>\ngNq@@dtuTDbGVcdus`dMv}`+\ngNq@@dtuTDbGVcdus`dMv}`-\ngNq@@dtuTDbGVcdus`dMv~`<\ngNq@@dtuTDbGVcdus`dMv~`>\ngNq@@dtuTDbGVcdv]EM[gAH[m}@<\ngNq@@dtuTDbGVcdv]EM[gAH[m}@>\ngNq@@dtuTDbGVcdv]GI[gAH[u}@<\ngNq@@dtuTDbGVcdv]GI[gAH[u}@>\ngNq@@dtuTDbGVcdv]GM[gAH[m}@<\ngNq@@dtuTDbGVcdv]GM[gAH[m}@>\ngNq@@dtuTDbGVchms`guv}`+\ngNq@@dtuTDbGVchms`guv}`-\ngNq@@dtuTDbGVchvRFJZwNBPw[z<\ngNq@@dtuTDbGVchvRFJZwNBPw[z>\ngNq@@dtuTDbGVchv]EM[gAH[m}@<\ngNq@@dtuTDbGVchv]EM[gAH[m}@>\ngNq@@dtuTpGSbgIZmolDaXP\ngNq@@dtuTpGSbgIZmrpqSdm[{AHVD\ngNq@@dtuTpGSbgIZmsXirVm}`dKB\ngNq@@dtuTtbGSbgIZmsXirVm}`gsB<\ngNq@@dtuTtbGSbgIZmshiK\\xIC^lH<\ngNq@@dtuTtbGSbgIZmshik_XIBp`<\ngNq@@dtuTtbGSbgIZmshik_XIBp`>\ngNq@@dtuTtbGSbgIZmshik_XIB@<\ngNq@@dtuTtbGSbgIZmshyk_XI|p`<\ngNq@@dtuUPGSbgIZmn\\DahVD\ngNq@@dtuUPGSbgIZmn\\DahVG|dSR\ngNq@@dtuUPGSbgIZmrpqSdm[gAHZEa@\ngNq@@dtuUPGSbgIZmsXirVms`dMBp`\ngNq@@dtuUPGSbgI[Nn\\DahVD\ngNq@@dtuURbRGSbgIZmrPqRVypRFaXP<\ngNq@@dtuURbRGSbgIZmrXiKVypRFa_orQMH<\ngNq@@dtuURbRGSbgIZmrXiKVypRFa_orQMH>\ngNq@@dtuURbRGSbgIZmshiK\\xICPlH<\ngNq@@dtuURbRGSbgIZmshiK\\xICPlH>\ngNq@@dtuURbRGSbgIZmshik\\xICPop<\ngNq@@dtuURbRGSbgIZmshik\\xICPop>\ngNq@@dtuURbRGSbgIZmshyK\\xI}PlH<\ngNq@@dtuURbRGSbgIZmshyK\\xI}PlH>\ngNq@@dtuURbRGSbgIjmshyK\\xICPlH>\ngNq@@dtuURbRGSbgIjnn\\DahVD<\ngNq@@dtuURbRGSbgIjnn\\DahVD>\ngNq@@dtuURbTGSbgIZmrPqRVypRFaXP<\ngNq@@dtuURbTGSbgIZmsPqRVms`dMB@<\ngNq@@dtuURbTGSbgIZmsPqRVms`dMB@>\ngNq@@dtuURbTGSbgIZmshiK\\xICPlH<\ngNq@@dtuURbTGSbgIZmshiK\\xICPlH>\ngNq@@dtuURbTGSbgIZmshik\\xICPop<\ngNq@@dtuURbTGSbgIZmshik\\xICPop>\ngNq@@dtuURbTGSbgIZmshik\\xICPowyIGD>\ngNq@@dtuURbTGSbgIZmshyK\\xI}PlH>\ngNq@@dtuURbTGSbgIZnshiK\\xICPlH<\ngNq@@dtuURbTGSbgIjmshiK\\xICPlH<\ngNq@@dtuURbTGSbgIjmshiK\\xICPlH>\ngNq@@dtuURbTGSbgIjnn\\DahVD>\ngNq@@dtuUTRGSbgIZmn\\DahWx<\ngNq@@dtuUTRGSbgIZmrXirVypRFaXP<\ngNq@@dtuUTRGSbgIZmrXirVypRFaXP>\ngNq@@dtuUTRGSbgIZmsXirVms`dMB@<\ngNq@@dtuUTRGSbgIZmsXirVms`dMB@>\ngNq@@dtuUTRGSbgIZms`qK\\xICPlH<\ngNq@@dtuUTRGSbgIZms`qK\\xICPlH>\ngNq@@dtuUTRGSbgIZms`qk\\xICPop>\ngNq@@dtuUTRGSbgIZnn\\DahVD<\ngNq@@dtuUTRGSbgIZnn\\DahVD>\ngNq@@dtuUTRGSbgQjnn\\DahVD<\ngNq@@dtuUTRGSbgQjnn\\DahVD>\ngNq@@dtuUTbGSbgIZmn\\D~hVD>\ngNq@@dtuUTbGSbgIZmrXiKVypRFaXP<\ngNq@@dtuUTbGSbgIZmrXiKVypRFaXP>\ngNq@@dtuUTbGSbgIZmrXyKVypSzaXP<\ngNq@@dtuUTbGSbgIZmrXyKVypSzaXP>\ngNq@@dtuUTbGSbgIZmsPqRVms`dMBp`<\ngNq@@dtuUTbGSbgIZmsPqRVms`dMBp`>\ngNq@@dtuUTbGSbgIZmsXirVms`guBp`<\ngNq@@dtuUTbGSbgIZmsXirVms`guBp`>\ngNq@@dtuUTbGSbgIjmn\\DahVD<\ngNq@@dtuUTbGSbgIjmn\\DahVD>\ngNq@@dtuUTbGSbgIkNn\\DahVD>\ngNq@@dwTuPGSbgIZmnUtahVD\ngNq@@dwTuPGSbgIZmobFaXP\ngNq@@dwTuPGSbgIZmshis\\kiCPlH\ngNq@@dwTuPGSbgIZmshis_DMBp`\ngNq@@dwTuPGUedmVwhvmdMBp`\ngNq@@dwTuPGUedmWWhvmdMBp`\ngNqDJDR^BSSMT`]FJmFn\\Danwl\ngNqDJHaQBSWUS@]FNRnnbEa@\ngNqDJIARBSWUUSP]FNRmsdyk]GsB<\ngNqHB@aInij`NcKMgWHvmtKB\ngNqHB@aInijihNcKMWWHvmtKB<\ngNqHB@aInijihNcKMWWHvmtKB>\ngNqHBLQInijihNkENZmshiK_KmBp`<\ngNqHBLQInijihNkENZmshiK_KmBp`>\ngNqHD@aInij`NkGIZmobFaXP\ngNqHH@aJnfjhDNfENRu[\\xICPlH>\ngNqHH@aJnfjhDNfENbu[\\xICPlH<\ngNqHH@aJnfjhDNfENbu[\\xICPlH>\ngNqHHGAJkjh@NlGI[gAH[m{@=\ngNqHHGAJkjh@NlGQkgAH[m{@=\ngNqHHGAJkjhHDNlGIkgAH[m{@+\ngNqHHGAJkjhHDNlGIkgAH[m{@-\ngNqHHGAJkjhHDNlGQ[gAOkm{@+\ngNqHHGAJkjhHDNlGQ[gAOkm{@-\ngNqHHGAJkjj`NfENRu[\\xICPlH\ngNqHHGAJkjjhDNfENSU[\\xICPlH<\ngNqHHGAJkjjhDNfENSU[\\xICPlH>\ngNqHHOAJkfh@NlGI[gAH[m{@=\ngNqHHOAJkfh@NlGI[gAH[m}@\ngNqHHOAJkfh@NlGQkgAH[m{@=\ngNqHHOAJkfh@NlGQkgAH[m}@\ngNqHHOAJkfh@NlGQkgAH[u}@=\ngNqHHOAJkfh@NlGQlvJ\\ek\\xIC^oh=\ngNqHHOAJkfhHDNlGIkgAH[m{@+\ngNqHHOAJkfhHDNlGIkgAH[m{@-\ngNqHHOAJkfhHDNlGIkgAH[m}@<\ngNqHHOAJkfhHDNlGIkgAH[m}@>\ngNqHHOAJkfhHDNlGQ[gAOkm{@+\ngNqHHOAJkfhHDNlGQ[gAOkm{@-\ngNqHHOAJkfi`NfENcU[\\xIC^lH\ngNqHHOAJkfi`NfENcU]\\xIC^lH\ngNqHHOAJkfi`NfENcU]_XIBp`\ngNqHHOAJkfj`NfENRu[\\xICPlH\ngNqHHOAJkfj`NfENcU[\\xICPlH\ngNqHHOAJkfjhDNfENSU[\\xICPlH<\ngNqHHOAJkfjhDNfENSU[\\xICPlH>\ngNqHHOAJkfjhdNfENcU]\\xICPlH<\ngNqHJIAIijjeDhNkENRmshik_XI|p`>\ngNqHaJ@SNRZZj@CkQtZypRF}_P=\ngNqIAJB\\dtuT@GVchus`dMv}`=\ngNqIAJB\\dtuT@GVchus`dMz~`=\ngNqIAJB\\dtuTDbGVcdus`dMz~`+\ngNqIAJB\\dtuTDbGVcdus`dMz~`-\ngNqIHO@ReUuT@GVChus`dMv}`=\ngNqIHO@ReUuT@GVChus`dMz~`=\ngNqLJIARFdLbdLjf@ztRmoFD\ngNqLJIARFdLbdLjf@ztRnoFD\ngNqLJIARFdLbdLji@ztRmoGt\ngNqLJIARFdLbdLjja`ztRmoFD<\ngNqLJIARFdLbdLjja`ztRmoFD>\ngNqLJIARFdLbdLjja`ztRmoGx<\ngNqLJIARFdLbdLjja`ztRmoGx>\ngNqLL@b^BBLbdLZ`dPzd[j{^p+\ngNqLL@b^BBLbdLZ`dPzd[j{^p-\ngNq`@ZdsSUPGQbgK\\zJZwVBp`\ngNq`@ZdsSUPGQbgK\\zJZwV|p`\ngNq`@ZdsSUTRGQbgK\\zJ\\wVBp`<\ngNq`@bdwSUPGQcfk[jaXP\ngNq`@bdwSUPGQcfk[j~_`\ngNq`@bdwSUPGQcfskjaXP\ngNq`@bdwSUTtGQcfk[ja_`<\ngNq`@bdwSUTtGQcfk[ja_`>\ngNq`@bdwSUTtGQcfk\\zJRwUBp`>\ngNq`@bdwSUTtGQcfkkjaXP<\ngNq`@bdwSUTtGQcfkkjaXP>\ngNq`@bdwSUTtGQcfs[ja_`<\ngNq`@bdwSUTtGQcfs[ja_`>\ngNq`@jduuURbrGQcdk\\xJZwQBp`<\ngNq`@jduuURbtGQcdk\\dJ\\uncya@>\ngNq`@jduuUTtGQcdk[haXP<\ngNq`@jduuUTtGQcdk\\yNZwQBp`<\ngNq`@mdTaeT@GTc]W[v=\ngNq`AVdtuUPGQbgI\\lLTyKVzpRD\ngNqa@bnR[ijhChqsUmuPlH\ngNqhHl@cIIKEh@NhFznwl=\ngNqhHl@cIIKEh@NhFznwt\ngNqhHlBsIIKJh@NhGNSdmu^ooyHFD\ngNqhHlGCIIKJh@NhFznwl=\ngNqhHlGCIIKJh@NhFznwt\ngNqhHlGCIIKJj`NbDmVwUBp`\ngNqhHlOCIIKFh@NhFznwl=\ngNqhHlOCIIKFh@NhFznwt\ngNqhHlOCIIKFh@NhFzoWt=\ngNqhHlOCIIKFi`NbDmVwUzp`\ngNqhHlOCIIKFi`NbDmVwcB\ngNqhHlOCIIKFi`NbDmWWUzp`\ngNqhHlOCIIKFj`NbDmVwUBp`\ngNqhHlOCIIKFjhTNbDmWWUBp`>\ngNqi@mJB]dTaeT@GTc]W[v=\ngNqi@mJB]dTaeT@GTc]W[z\ngNqiHl@c]ddebt@GTC]W[v=\ngNqiHl@c]ddebt@GTC]W[z\ngNqiHl@c]ddebt@GTC]Wkz=\ngNqiHlOC]ddecTDBGTC]W[v+\ngNqiHlOC]ddecTDBGTC]W[v-\ngNr@ACTjzjj@zpdmoio[X_v`@\ngNr@ACTjzjj@zpdnoio[X_v`@\ngNrDEcPDSpRZYjhCkQRv|X_vb@\ngNrDHlQxWpRjyjhCkARwNCDmu_LO{Q@\ngNrHEcQxIMMUTAthjnkm{ZH\ngNrHHlPxIUMUTAt`rnkm}ZP\ngNrHHlQxIU\\uTAtPijvzhVG}h`=\ngNrHHlQxIU\\uTAtPijwIbgI[jaX_vb@\ngNrHHlQxYIHXETAulu[\\sZwPlO{S@=\ngNrHHlQxYIHXETAulu[gIrVyfunaX_vf@\ngNrIHlQxRTjnZj@zHTu[]TKC~tP=\ngNrIHlQxRTjnZj@zHTu[_SmBpmD=\ngNrIXlPxAiJgRYRjZj@CjAnkm{b@[R@=\ngNr`hZpiJyInfj`NeGO{R@\ngNt@@TfzBj@zvZmnQm[hVD\ngNt@@Tfzfj@zLlu[gASfyGUnaXP\ngNt@@Tfzfj@zLlu[gQSfyFuvaXP\ngNt@@TjZjj`PzXXiuUn\\EN[eApZEa@<\ngNt@@TjZjj`PzXXiuUn\\EN[eApZEa@>\ngNt@@dfnj`@zTRwqC]oX=\ngNt@@dfnj`@zTRwq}]oX=\ngNt@@dfnj`@zTSWqC]oX=\ngNt@@dfzZj@zl\\ejvyGRFaXP\ngNt@@dfzZj@zl\\ejv~HZEa@\ngNt@@dfzjj@zl\\ejv~HZEa@\ngNt@@dfzjj@zl\\ejwICEN[xahVD\ngNt@ADjzjj@zXTyKUms`dMBpm@\ngNt@ADjzjj@zhdejv}f}tahVG}h@\ngNt@ATffjjb`zlTyJz~pREa@>\ngNtDHpxUpRjZjjQCjabgI[eApRF~@<\ngNtDHpxUpRjZjjQCjabgI[eApRF~@>\ngNtDJqHJPRZzj@CiQK_Guv}`=\ngNtHH`xIUMUTAtpqrVk[gAHZEaZP=\ngNtHH`xYIHYU@At`fobF{^p=\ngNtHHaxYIHXE@AoYm[H[m{@=\ngNtH`iPBYrSWUPRH]JIkxanwl+\ngNtH`iPBYrSWUPRH]JIkxanwl-\ngNtI@]P[ldadjj@zHlv]gASfygUvaX_v`@\ngNtI@iPSdfnj`@zTSWqC]oX=\ngNtIHaxB\\ddLj`@zPSWqC]oX=\ngNtI`]PB]qgIHYFj`NbKMVwLvmtKC~t@\ngNtI`iPBYreIkjh@NeDu|Pw[v=\ngNtI`iPBYreIkjj`NkGIZmrTyKV~HZEa@\ngNtLJqDJHtQdTaeTpGRbT\ngNtLJqHJPtadTaeT@GTc]W[v=\ngNtLJqHJPtadTaeTpGRbT\ngNtLJqHJPtadTaeTpGRbZznwl\ngNtLJqHJPtadTaeTpGRbZznwt\ngNtLlQHR`TaNLiM]UTAtXyjwNSdmuPlO{S@\ngNtLlQHR`TaNLiM]UTAtXyj{NSdmuPlO{S@\ngNtLlQHR`TaNLiM]UTAthzsdyK]Wk{~tp\ngNtLlQHR`TaNtiM]U@AuHyr\\unkm}ZX\ngNtLlQHR`TaNtiM]ULAtXyj{NSdmu^lO{S@\ngNtLlQHR`TaNtiM]ULAthzsdyK]Wk{~tp\ngNtMLQHR`TaNRZzjhCiQugIrVzoWw}i`\ngNtMLQHR`TaNRZzjhCiQugIsVznww}i`\ngNt`CPdfzZj@zt\\moFD\ngNt`CPdfzZj@zt\\moGx\ngNt`EPTfzZjfPzt\\mshiK^LH<\ngNt`EPTfzZjfPzt\\mshiK^LH>\ngNt`hPiJyInfj`NcGMVwUBpdbZ[R@\ngNt`hPiJyInfj`NcGMVwUBpmH\ngNtdLx`DTHrRRqZdCiAM]W[v\ngNthJx`DYIHXmLAu`zK_DMv~`\ngNthLX`DYIHXmTAtPyjvzhVG}i`=\ngNthLX`DYIHXmTAtPyjwNSdmuPlO{S@\ngNthLX`DYIHXmTAt`znkm{ZX=\ngNthMX`DYIHXmTAtPyLvzHVG}i`\ngNthMX`DYIHXmTAtPyLvzHW{}i`\ngNthMX`DYIHXmTAu`zM_DMv~mL\ngNthMX`DYIIXm@Au@wUv}`\ngNthejqHJWrSSUSRH]ZJRwaC~tP<\ngNthejqHJWrSSUSRH]ZJRwaC~tP>\ngNtiLPiPSdfnjj@zT]Yr\\enku}ZX\ngNtiLPiPSdfnjjdPzT]YhTyKVzoWw}i`-\ngNu@DPdwSUPGQcfk[jaXP\ngNu@DPdwSUPGQcfk[jaX_rQMH\ngNu@DPdwSUPGQcfk\\zJ\\wUBp`\ngNu@DPdwSUTtGQcfk\\fJ\\enjEa@<\ngNu@DPdwSUTtGQcfk\\fJ\\enjEa@>\ngNu@DPdwSUTtGQcfk\\zJRwUBp`<\ngNu@DPdwSUTtGQcfk\\zJRwUBp`>\ngNu@DPdwSUTtGQcfkkjaXP<\ngNu@DPdwSUTtGQcfkkjaXP>\ngNuHDz@aIkjiiDNmGI\\dLTuoBD<\ngNuHDz@aIkjiiDNmGI\\dLTuoBD>\ngNuHDz@aIkjiiDNmGI\\zJZwaB<\ngNuHEhOCIIKFh@NhFznwl=\ngNx@@dju\\@GTc]W[v=\ngNx@@dsSUPGSbgIZmn\\DahVD\ngNx@@dsSUPGSbgIZmshis\\xICPlH\ngNx@@dsSUPGSbgQZmn\\DahVD\ngNx@@dsSUPGUddmVwhwmdMBp`\ngNx@@dsSUPGUddmVwhwndMBp`\ngNx@@dsUUTbGSbgIZmn\\DahVD<\ngNx@@dsUUTbGSbgIZmn\\DahVD>\ngNx@@dsUUTbGSbgIZmrPqSfypRFaXP<\ngNx@@dsUUTbGSbgIZmsPqSdms`dMBp`<\ngNx@@dsUUTbGSbgIZmsPqSdmsoDMBp`<\ngNx@@dsUUTbGSbgIZmsPqSdmsoDMBp`>\ngNx@@dsUUTbGSbgIZms`qs\\xICPlH<\ngNx@@dsUUTbGSbgIZms`qs\\xICPlH>\ngNx@@dsUUTbGSbgIZmshis\\xICPlH>\ngNx@@dsUUTbGSbgQZmn\\DahVD<\ngNx@@dsUUTbGSbgQZmn\\DahVD>\ngNx@@dsUUTbGSbgQZmsPqSdms`dMBp`<\ngNx@@dsUUTbGSbgQZms`qs\\xICPlH<\ngNx@@dsUUTbGSbgQZms`qs\\xICPlH>\ngNx@@dtuT@GVcdms`dMv}`=\ngNx@@dtuT@GVcdms`dMv~`\ngNx@@dtuT@GVcdn\\FM[gAH[m}@\ngNx@@dtuT@GVchus`dMv}`=\ngNx@@dtuT@GVchus`dMv~`\ngNx@@dtuT@GVchvSENZwNBPw[z\ngNx@@dtuTDbGVcdms`guv}`+\ngNx@@dtuTDbGVcdms`guv}`-\ngNx@@dtuTDbGVcdn]EM[gAH[m}@<\ngNx@@dtuTDbGVcdn]EM[gAH[m}@>\ngNx@@dtuTDbGVcdus`dMv}`+\ngNx@@dtuTDbGVcdus`dMv}`-\ngNx@@dtuTDbGVchv]EM[gAH[m}@<\ngNx@@dtuTDbGVchv]EM[gAH[m}@>\ngNx@@dtuTpGSbgIZms`qK\\xIC^lH\ngNx@@dtuTtbGQbkIkgAH[m}@>\ngNx@@dtuUPGSbgIZmn\\DahVD\ngNx@@dtuUPGSbgIZmrpqSdm[gAHZEa@\ngNx@@dtuURbRGSbgIZmshiK\\xICPlH>\ngNx@@dtuURbTGSbgIZmshiK\\xICPlH>\ngNx@@dtuUTRGSbgIZms`qK\\xICPlH<\ngNx@@dtuUTRGSbgIZnn\\DahVD<\ngNx@@dtuUTRGSbgIZnn\\DahVD>\ngNx@@dtuUTbGSbgIZmrXiKVypRFaXP<\ngNx@@dtuUTbGSbgIZmrXiKVypRFaXP>\ngNx@@dtuUTbGSbgIZmsPqRVms`dMBp`<\ngNx@@dtuUTbGSbgIZmsPqRVms`dMBp`>\ngNx@@dtuUTbGSbgIjmn\\DahVD<\ngNx@@dtuUTbGSbgIjmn\\DahVD>\ngNx@@dwPUPGQrVk[t[VrFaXP\ngNx@@dwPUPGQrVk\\zJ\\whvndMBp`\ngNx@@dwPUPGQrVkkt[VrFaXP\ngNx@@dwTuPGSbgIZmobFaXP\ngNx@@dwTuPGSbgIZmshis\\kiCPlH\ngNx@@dwTuPGUedmVwhvmdMBp`\ngNx@@dwTuPGUedmVwhvndMBp`\ngNx@@dwTuPGUedmVwhzmdMBp`\ngNx@@dwTuPGUedmVypTyoQu]HZEa@\ngNx@@dwTuPGUedmVytTyoQm]HZEa@\ngNx@@dwTuPGUedmWWhvmdMBp`\ngNx@@dwTuPGUedmWWhvndMBp`\ngNx@@dwTuPGUedmgWhvmdMBp`\ngNx@@dwTuPGUedmgWhvndMBp`\ngNx@@dwTuPGUedugWhvmdMBp`\ngNx@@eSUUPGUEDmVwjwmdMBpm@=\ngNx@@eSUUPGUEDmVwjwndMBpm@\ngNx@@eSUUPGUEDmVwj{ndMBpm@=\ngNx@@eSUUPGWCENRu[^hNBPtKB\ngNx@@eSUUPGWCENRu[^hNBPtKC~t@=\ngNx@@eSUUPGWCENRu[^hN|PtKC~t@\ngNx@@eSUUPGWCENRu[gASf}P]xahVG}h@\ngNx@@eSUUPGWCENRu[gAcf}P\\DahVG}h@\ngNx@@eSUUPGWCENRu]gAcV}P\\DahVG}h@\ngNx@@eSUUPGWCENbu[^hNBPtKC~t@\ngNx@@eSUUPGWCENcV]^hNBPtKC~t@\ngNx@@eSUUTBGWCENRu[gASf}P]xahVD<\ngNx@@eSUUTBGWCENRu[gASf}P]xahVD>\ngNx@@eSUUTBGWCENRu[gAcf}P\\DahVD<\ngNxA@IRZZj@CkQrVypRF{^p=\ngNxA@IRZZj@CkQtZypRF{^p=\ngNxA@IRijjhCkabgIZmoTGAHZEa@\ngNxA@IRijjjACkabgIZms`is^hN|PtKB<\ngNxA@IRijjjACkabgIZms`is^hN|PtKB>\ngNxA@IRjZj@ChaSdmz`xIC]oX=\ngNxA@IRjZjhCkabgIZmoTGAHZEa@\ngNxA@IRkijhCjbRVk[v[vrFaX_v`@\ngNxA@IRkijhCjbRVk[v]vrFaX_v`@\ngNxA@IRkijhCkabgIZmshis\\{qCPlO{P@\ngNxA@IRkijhCkabgQZmrPqrV}g\\DahVG}h@\ngNxDD@b^BSWMPRH]JIkxanwl+\ngNxDD@b^BSWMPRH]JIkxanwl-\ngNxDDDR^BSWMPRH]JIkxanwl+\ngNxDDDR^BSWMPRH]JIkxanwl-\ngNxDHDQHbS]UU@]VNRu[_DMBp`\ngNxDHGBnBUSUURH]LLTyJz}P\\DaofD<\ngNxDHGBnBUSUURH]LLTyJz}P\\DaofD>\ngNxDHOANBS]UU@]VNRu[^cr|PtKC~RAamH\ngNxDHOA^BS]UU@]VNRu[\\cqCPlOyHFFt`\ngNxDHOA^BS]UU@]VNRu[^cr|PtKC~RAamH=\ngNxDHOA^BS]UU@]VNRu[_DMBp`\ngNxDHOA^BS]UU@]VNRu[_DMBpd`XP\ngNxDHOA^BS]UU@]VNRu[_DMBpd`X[R@=\ngNxDL@aNBSMTu@]VRRu[^c^vPtKB\ngNxE@jCT@eJfjj`NjFIZmobFaXP\ngNxEHBqE`eInjjiDNkGIZmnUxahVG|dCB<\ngNxEHBqE`eInjjiDNkGIZmnUxahVG|dCB>\ngNxEHOA^DeInfj`NkGIZmnQtahVG|dCCZP\ngNxEHOA^DeInfj`NkGIZmnUxahVG|dCCZP\ngNxHAjAJfjj`NfFJRu[\\hICPlO{P@\ngNxHAjAJfjjhDNfFJRu[\\hICPlH>\ngNxHAjAJfjjhDNfFJRu[gAcfyWbFaXP<\ngNxHAjAJfjjhDNfFJRu[gAcfyWbFaXP>\ngNxHD@aIkjhIDNeDm|Pw[v-\ngNxHD@aInfj`NkGIZmobFaXP\ngNxHD@aInij`NkKIZmoQm[HZEa@\ngNxHDOAInjjiDNkGIZmnQxahVD>\ngNxHH@aIfjj`NgENRu[gQSf}GlDahVG}i@\ngNxHHGAIfjj`NgENRu[\\xICPlOyHEFt`\ngNxHHGAIfjj`NgENRu[^cvBPtKC~RAQmH\ngNxHHGAIfjj`NgENRu[^cvBPtKC~t`\ngNxHHGAIfjjiDNgENRu[^cvBPtKB<\ngNxHHGAIfjjiDNgENRu[^cvBPtKB>\ngNxHHGAJijj`NnFJ\\ejv}P\\DahVG}i@=\ngNxHHGAJkjh@NlGQkgAH[m{@=\ngNxHHGAJkjj`NfENRu[\\xICPlH\ngNxHHOAJkfh@NlGQkgAH[m{@=\ngNxHHOAJkfh@NlGQkgAH[m}@\ngNxHHOAJkfhHDNlGIkgAH[m{@+\ngNxHHOAJkfhHDNlGIkgAH[m{@-\ngNxHHOAJkfhHDNlGIkv]pRF}_P+\ngNxHHOAJkfhHDNlGIkv]pRF}_P-\ngNxHHOAJkfj`NfENRu[\\xICPlH\ngNxHHOAJnjjhDNfENRu[\\{qCPlH<\ngNxHHOAJnjjhDNfENRu[\\{qCPlH>\ngNxHJIAIiji`NcEVRwN|_W[v\ngNxHaJ@SNRZZj@CkQrVypRF{^p=\ngNxHaJ@SNRZZj@CkQtZypRF{^p=\ngNxHaJ@SNRZZj@CkQtZypRF}_P=\ngNxHaJ@SNRZZj@CkQt[MbgIZwNBPwkz=\ngNxHaJ@SNRZZj@CkQt[NCFms`dMv~`\ngNxHaJ@SNRZZjBQCkQrZypRF{^p+\ngNxHaJ@SNRZZjBQCkQrZypRF{^p-\ngNxHaJ@SNRZZjBQCkQrZypRF}_P+\ngNxHaJ@SNRZZjBQCkQrZypRF}_P-\ngNxHaJ@SNRZZjBQCkQt[Nbfms`dMv~`<\ngNxHaJ@SNRZZjBQCkQt[Nbfms`dMv~`>\ngNxHaJ@SNRZZjjQCiqSdmVyLTek\\xICPlH<\ngNxHaJ@SNRZZjjQCiqSdmVyLTek\\xICPlH>\ngNxHaj@SnrRFPJhChyKUu{MkYCPlO{P@=\ngNxHaj@SnrRFPJhChyKYu{MkYCPlO{P@=\ngNxHaj@SnrRFPJhChyKYv]EN[v[WRFaX_v`@\ngNxHaj@SnrRFPJhChyMYu{MkYCPlO{P@=\ngNxHaj@SnrRFPJhChyMYu{MkiCPlO{P@\ngNxHhG@]IR[jZhCiqSdmVwJzPtKC~RAamH\ngNxIAJB\\dtuT@GVchus`dMv}`=\ngNxIAJB\\dtuT@GVchus`dMz~`=\ngNxIAJB\\dtuTDbGVcdus`dMz~`+\ngNxIAJB\\dtuTDbGVcdus`dMz~`-\ngNxIAjC\\dwTuPGUedugWhzmdMBp`\ngNxIHGBRdwTuPGSbgIZmoQy]HZEaI@pvd@\ngNxIHO@ReUuT@GVChus`dMv}`=\ngNxIHO@ReUuTDBGVCdus`dMv}`+\ngNxIHO@ReUuTDBGVCdus`dMv}`-\ngNxIHOBReUsT@GVChus`dMv}`=\ngNxIHOB\\eUsT@GVChu{NxIC]oX=\ngNxLHGBnC\\Djfjj@zhXirV}P\\Daogx\ngNxLHGBnC\\Djnjj@zHTyK\\xIC_Op\ngNxLHGBnChDjfjjdPzhXirVyP\\Dao`<\ngNxLHGBnChDjfjjdPzhXirVyP\\Dao`>\ngNxLHOANF\\DfZjjdPzlTejvywbFaXP<\ngNxLHOANF\\DfZjjdPzlTejvywbFaXP>\ngNxLJHaQFbLbdLj`@zd[j{^p\ngNxLJIARFdLbdLj`@zd[j{^p\ngNxLJIARFdLbdLj`@zd[j{_P\ngNxLJIARFdLbdLjf@zTSWUv}`\ngNxLJIARFdLbdLjf@zTSWUv~`\ngNxLJIARFdLbdLjf@ztRmoFD\ngNxLJIARFdLbdLjf@ztRnoFD\ngNxLJIARFdLbdLji@zTSWUv}`\ngNxLJIARFdLbdLji@zTSWUv~`\ngNxLJIARFdLbdLji@zTSWUz~`\ngNxLJIARFdLbdLji@ztRm@\ngNxLJIARFdLbdLji@ztRmoGt\ngNxLJIARFdLbdLjja`ztRmoFD<\ngNxLJIARFdLbdLjja`ztRmoFD>\ngNxMHOANF\\IJSMMU@]VJRu[\\{qCPlO{R@\ngNx`BDdwSUPGQcfk[jaXP\ngNx`BDdwSUPGQcfk[jaX_rQMH\ngNx`BDdwSUPGQcfk\\zJ\\wUBp`\ngNx`BDdwSUPGQcfskjaXP\ngNx`BDdwSUTtGQcfk[ja_`<\ngNx`BDdwSUTtGQcfk[ja_`>\ngNx`BDdwSUTtGQcfk\\zJRwUBp`<\ngNx`BDdwSUTtGQcfk\\zJRwUBp`>\ngNx`BDdwSUTtGQcfkkjaXP<\ngNx`BDdwSUTtGQcfkkjaXP>\ngNx`DBdwSUPGQcfk[jaXP\ngNx`DBdwSUPGQcfk\\zJ\\wUBp`\ngNx`DBdwSUTtGQcfk[ja_`<\ngNx`DBdwSUTtGQcfk\\zJRwUBp`>\ngNx`bDnLiMtuTAtXyjvzhVD\ngNx`hEIWIMtuTAuXyKUm|PtKC~t`\ngNx`hEIWIMtuTAuXyKUm|PtK}~t`\ngNx`hEIWIMtuTAuXyKUu|PtKC~t`\ngNxaBDYR[ijhChqsUmuPlH\ngNxdMD@baFRRFKU@]DNSMobF~X_vf@\ngNxdMD@baFRRFKU@]DNSNobF~X_vf@\ngNxdMD@baFRRVKT`]HIkj{^p\ngNxhKD@cIICEh@NdDm|Pw[v\ngNxhMD@cIICEj`NjGIZmobFaX_vf@=\ngNxhMD@cIICEj`NjGIZmoczaX_vf@=\ngNxhMD@cIICEj`NjGIZnobFaX_vf@\ngNxhMD@cIICEj`NjGIZnsdyk_DMBpmL\ngNxhMD@cIICEj`NjGIjmobFaX_rQMMi`=\ngNxhMD@cIICEj`NjGIjmobFaX_vf@=\ngNxhMD@cIICEj`NjGIjmobFa_ovf@\ngNxhMD@cIICEj`NjGIjmsdyK_DMBpmL\ngNxhMD@cIICEj`NjGIjnobFaX_vf@\ngNxhMD@cIICEj`NjGIjnsdyk_DMBpmL\ngNxhMD@cIICEj`NjGIkMobFa_ovf@\ngNxhMD@cIICEj`NlGQ[xaoWw}i`=\ngNxhMD@cIICEj`NlGQkxanwo}i`=\ngNxhMD@cIICEj`NlGQkxanww}i`\ngNxhMD@cIICEj`NlGQkxaoWw}i`=\ngNxhMD@cIIKEh@NhFznwl=\ngNxhMD@cIIKEh@NhFznwt\ngNxhMD@cIIKEh@NhFzoWt=\ngNxhMD@cIIKEh@NhGNSfmu]oh\ngNxhMD@cIIKEi`NbDmVyr\\enkua@\ngNxhMD@cIIKEi`NdDv\\gI[j}^p\ngNxhlEJB]iRZzj@CiQM_DMv}mL=\ngNxhlEJB]irJPrj@CjQnkm{@=\ngNxhlEJB]irJPrj@CjQomz{^p=\ngNxhlEJB]irJPrj@CjQsdyk]W[z\ngNxiMD@c]ddebt@GTC]W[v=\ngNy@BDfZZj@zlTyjv~pZEa@\ngNy@BDfZZjb`zlTyjwNbdm}`tKB>\ngNy@BDfZZjb`zlTzjwNbdm}`tKB>\ngNy@BDfZjjTR`zlTzjwNCDm}`tKB>\ngNy@BDfZjjdPzlTyjv~pZEa@>\ngNy@BDfZjjdPzlTyl{NbgM}`tKB<\ngNy@DDffjjdPz\\TyKUn]EI[gAHZEaZH<\ngNy@DDffjjdPz\\TyKUn]EI[gAHZEaZH>\ngNy@DDfnj`dPzTRwqC]oX+\ngNy@DDfnj`dPzTRwqC]oX-\ngNy@DDfnj`dPzTRwq}]oX-\ngNy@DDfnj`dPzTRytTuobF{_P>\ngNy@DDfnj`dPzTSWqC]oX+\ngNy@DDfnj`dPzTSWqC]oX-\ngNy@DDfzZj@zl\\ejv~HZEa@\ngNy@DDfzZj@zl\\ejv~HZE~@\ngNy@DDfzZj@zl\\ejwNbfm|PtK|\ngNy@DDfzZj@zl\\ejwNbgM|PtKB\ngNy@DDfzZj@zl\\ejz~HZEa@\ngNy@DDfzZj@zl\\ej{Nbfm|PtKB\ngNy@DDfzZj@zl\\elz~HZEa@\ngNy@DDfzZj@zl\\flz~HZEa@\ngNy@DDfzZjfPzl\\ej{NbgM|PtKB<\ngNy@DDfzZjfPzl\\ej{NbgM|PtKB>\ngNy@DDfzfj@zl\\ejv~HZEa@\ngNy@DDfzfj@zllejv}FulahVD\ngNy@DDfzjjdPzl\\ejv~HZEa@<\ngNy@HDfZjjdPz\\TyKUms`dMBp`<\ngNy@HDfZjjdPz\\TyKUms`dMBp`>\ngNy@HDfZjjdPz\\TyKUn]EN[g^HZEa@<\ngNy@HDfZjjdPz\\TyKUn]EN[g^HZEa@>\ngNy@HDfZjjdPz\\TzKUms`dMBp`<\ngNy@HDfZjjdPz\\TzKUms`dMBp`>\ngNy@JDffj`@zt\\en\\Danwl\ngNy@JDffj`@zt]Fn\\Danwl\ngNy@JDffji@zLUYK\\xIC]oX\ngNy@JDffjjTRPzlTyJwNbfm}`dKB<\ngNy@JDffjjTR`zlTyJwIcdm[{AOfD<\ngNy@JDffjjTR`zlTyJwNbfm}`dK|<\ngNy@JDffjjb`zlTyJv~pREa@<\ngNy@JDffjjb`zlTyJv~pREa@>\ngNy@JDffjjb`zlTzLv~pREa@<\ngNy@JDffjjb`zlTzLv~pREa@>\ngNy@hAteInij`NgENRu[_DMBpmH\ngNyAHIJSMMU@]NJ\\ejwNbgMsoDMBpmH\ngNyDGQDJHRZzjXCkQrWNSfmxP`\ngNyDGQHJPRZzjXCkQrV|HP\ngNyDGQHJPRZzjXCkQrV|O`\ngNyHE@DYICHuU@auPyKUm|PtKB<\ngNyHE@DYICHuU@auPyKUm|PtKB>\ngNyHE@DYIHXmA@at`eobF{^p+\ngNyHE@DYIHXmA@at`eobF{^p-\ngNyHEAxIU\\uTAtPjrVywcz{__vb@\ngNyHEAxIU\\uTAtpitZk[gAHZEaZH=\ngNyHEAxYIHXuA@at`fobF{^p+\ngNyHEAxYIHXuA@at`fobF{^p-\ngNyHKAxIU\\u@Au`zM\\xIC]oX\ngNyHdIPSeJSSUP@]ZNcYpXun\\Danww}h`\ngNyHdIPSeJSSUS@]FJmFs`qK\\xIC^oo{Q@\ngNyHdIPSeJSWUPRH]JIkxanwl+\ngNyHdIPSeJSWUPRH]JIkxanwl-\ngNyHdIPSeJSWUPRH]JIkxanwt<\ngNyHdIPSeJSWUPRH]JIkxaoWt+\ngNyHdIPSeJSWUPRH]JIkxaoWt-\ngNyHdIPSeJSWUPRH]JIlyNZwqC]oh<\ngNyHdIPSeJSWUPRH]JIlyNZwqC]oh>\ngNyIDIPSdffjj@z\\TzMUv\\FI[gAHZEaZH\ngNyIDIPSdfnj`dPzTSWqC^oh+\ngNyIDIPSdfnj`dPzTSWqC^oh-\ngNyIDMP[dfzfj@zl\\ej{IbgI[e]HZEa@\ngNyLGQDJHtQdTaeTpGRbT\ngNyLGQDJHtQdTaeUHGRbT\ngNyLGQHJPtadTaeTpGRbT\ngNyLGQHJPtadTaeUHGRbT\ngNyLGQbKDvIdTaeTpGRbT\ngNyLcaHR`TaNLyEHYU@AuHyr\\enku}ZD\ngNyLcaHR`TaNLyEHYU@AuHyr\\unkm}ZD\ngNyLcaHR`TaNLyEHYULAtXejwNSdmxpmB\ngNyLcaHR`TaNLyEHYULAtXej{NSdmxpmB\ngNyLcaHR`TaNLyEHYULAthfsdyK]Wk{~tH\ngNy`JDTfzZjfPzt\\moFD>\ngNydMDpDTHrRPqZhCkAr[NSdmtPww{S@\ngNyhCE`DYIIXmTAtPejwNSdmuPlO{P`\ngNyhCEaxYIIXuTAtPejvzhVG}hP=\ngNyhKEaxYIIXuUBau`e[^LH>\ngNyhKEaxYIIXuUBau`e[^Op>\ngNyhKEaxYIIXuUBau`e]^LH<\ngNyhKEaxYIIXuUBau`e]^LH>\ngNyhMEPDYIHXmTAtPyLvzHVG}i`\ngNyhbEiPScNQRFUS@]FIZms`yK^LO{P`\ngNzHHlZGAJijj`NdFUu]oo{R@\ngN|@@ZeSUUPGVEEu|n{kC~t@=\ngN|@@bdwSUPGQefk[d[WZEa@\ngN|@@bdwSUPGQefk\\zJ\\wHvntKB\ngN|@@mdTaeT@GTc]W[z\ngN|DEbHb^FQRFPU@]XmVwJwmtKC~tH=\ngN|LlZIBTBdIqeIkjj`NmGKlyNRwcC~tp\ngN|LlZIBTBdIveIkjjPNmGK\\yNRmL\ngN|`hZEIWIMtuTAuhy[^LO{R@\ngN|`hZEIWIMtuTAuhy]^LO{R@\ngN}HEcAxIU\\uTAtPijvzhVG}h`=\ngN}HEcAxYIIYATAubu[gArVyV}naX_va@\ngN}HebIPSeJSSUS@]FJZmsXirVmu^lO{Q@\ngN}HebIPSmJSSUURH]FJZmsXirVmuPlO{Q@+\ngN}HebIPSmJSSUURH]FJZmsXirVmuPlO{Q@-\ngN}HebIPSmJSSUURH]JJlvJ\\ek]Wk{~tP+\ngN}HebIPSmJSSUURH]JJlvJ\\ek]Wk{~tP-\ngOp@DjfVjjdEDNnFJ\\ejwMBgIZwjCoDMB_die`<\ngOp@DjfVjjdEDNnFJ\\ejwMBgIZwjCoDMB_die`>\ngOp@DjfVjjdEHNnFJ\\ejwMBgIZwjCoDMB_die`>\ngOp@DjfVjjdEHNnFJ\\ejwMCGIZwj}oDMB_die`<\ngOp@DjzfZj`NnFJ\\ejv}g\\DahVG|dLl\ngOp@LdadMBj`NcdmVwlvmdMBpdmc`=\ngOp@LdadMBj`NcdmVwlvmdMB_dmc`=\ngOp@LdadMBj`NcdmVytTuoYm]HZEaI[G@\ngOp@LdadMBj`NcdmWWlvmdMBpdmc`=\ngOp@LdadMBjidNcdmVwlvmdM|pdmc`+\ngOp@LdadMBjidNcdmVwlvmdM|pdmc`-\ngOp@LdadMBjidNcdmWWlvmdM|pdmc`+\ngOp@LdadMBjidNcdmWWlvmdM|pdmc`-\ngOpB@xQpSagCIIKHjhHCjAoYy^wku}KCSH`=\ngOpBADQpSagCHiCEjhHCjQnU{^oWw|eLl=\ngOpL@xQpSaddadUTDAt`foYy^H[u}ICS@=\ngOpMAxZ`M@IRj[Fjj@zhXijv}P]x~hVG|dml\ngOp`@dfzMZj`NkGIZmobFaX_rVqp\ngOp`@dfzMZj`NkGIZnobFaX_rVqp\ngOp`@dfzMZjidNkGIZmobF~X_rVqp<\ngOp`@dfzMZjidNkGIZmobF~X_rVqp>\ngOp`@dfzMZjidNkGIZnobF~X_rVqp<\ngOp`@dfzMZjidNkGIZnobF~X_rVqp>\ngOphH`DYIHYVmU@]TNSU[_DMBpdck`\ngOq@@dsQkUTAtxitVk[gAHZEaI[G@\ngOq@@eMtUTEIAuhiK\\hIC]o_yHYx+\ngOq@@eMtUUUIAtxirVk[eAHZEaICO@<\ngOq`@bdwQkUUMAtXyjvzhVG|el\\<\ngOt@@TjZkjj`NfFJ]U[gAcfyP\\FaX_rQuuh@\ngOu@DPdwU[UTAtXyjvzhVG|d]\\\ngOx@@eSQmUTAupqSdmVwjC`dMBpdmckP@=\ngOx`hEIWIMtZuU@]VNRu[_DMBpdmckR@\ngOxhMD@cIICJujhCjarZk[xahVG|d]]ZX=\ngOxhMD@cIICJujjYCjarZk[xahW{|d]]ZX\ngOy@DDfzMZj`NkGIZmobFaX_rVqp\ngOy@DDfzMZj`NkGIZnobFaX_rVqp",H),i=0==(1&t)?null:Jl.VHb("26,60,96,180\n42,68,91,94\n147,176\n170,261\n210,231,244,267\n59,180\n26,30,38,55,81,96,118,180\n0,54,58,90\n0,55,90\n0,59,68,73\n0,57,77,180\n0,40,90\n0,31,35,46,68\n24,29,55,90\n1,47,51,56,70,75,78,85,88,90\n12,33,67\n0,38\n3,180\n0,44,61,87,90\n27\n0,14,29,35,61,78\n11,28,33,45,55,57\n57,61,63,90,145,148,180\n180\n0,40,47,51,72,179\n0,58\n0,52\n39,60,76,180\n51\n54,59,305\n47,50,66,311\n0,4,62\n63,84,125,163,180\n2,18,56\n60,94,178,180\n52,92,149,178\n42,82,160\n42,79,161\n67,180\n56,166,180\n51\n51\n61,174,180\n42\n0,2,28,174,180\n46,76,163\n60,88,180,208,306\n61,76,304\n0,7,10,13,60,82\n0,60\n3,37,57,60,97,129,180\n0,10,28,136,165,180\n59,61,63,71,169,180\n44,76,165\n44,75,165\n26,47,62,64,68,71,167,186,274,280,301\n27,43,49,55,68,74,145,169,184,190,283,297,301\n24,39,45,58,74,146,184,202,276,302\n47,52,149,162,179,285,287,308\n46,69,180\n40,43,77,158,180\n42,78,80,169\n42,44,49,62,68,156,178,180\n42,47,55,59,81,84,161,178,180\n170\n0,29,57\n180\n2,11,15,44,76,87,90\n0,24,43,76,90\n3\n0,10,18,21,37,44,64\n59,180\n50,72,175,180\n57,180\n58,180\n58,90,150,159,164,168,176,180\n0,3,30,60,64,75,94,123,154,180\n59\n46,52,72,168,172,180\n43,75,164,180\n50,72,172,195,284,315\n45,173,177,180,199,291,315\n170\n16,47,74,166\n53,100,159,180\n43,71,74,111,122,125,180\n31,49,64\n132,171\n32,58,334\n29,58,337,339\n56,180\n54,67,177\n58,160,180\n180\n41,80,173,180\n48,63,84,118,179\n3,41,73,147,166,179\n41,60,72,161,176,180\n48,51,53,78,157,194,282,316\n32,50,81,155,161,166,192,206,280,286,315,325,328\n59,180\n50,60,66,82,158,180\n61,179\n60,180\n48,74,168\n50,85,159,199,220,297,315,351\n61,71,77,83,90,173,193,284,300\n308\n308\n68,192,305\n59,169,174,180\n53\n62\n0,3,9,23,26,28,49\n52,60,62,180\n33,55,180\n35,56\n28,34,53,311\n185,288,290\n0,9,34,37,57,75,77,90,95,102,125,139,142,162,180\n17,62,77,170\n48,76,167,180\n54,58,65,180\n63,80,82,180\n45,48,72,167,179\n59,180\n56,70,74\n18,67,106\n56,180\n56,180\n50,180\n180\n65,186,299\n175\n52,189,191,221,287\n56,175\n62,177\n65,175\n51,72,90,138,181\n188,214,294\n192,226,296\n201,224,275,289\n48,68,77,174,180\n71,299\n44,52,57,59,61,75,298,321\n60,180\n41,73,88,164,180\n59,180\n47,57,60,63,165,167,171,181,287,311\n51,77,80,161,188,204,279,303\n303\n59,180\n61,180\n48,75,167,171,180\n65,183,290,305\n66,178,303\n54,70,178,191,303\n66,181,304\n62,178,194,304\n64,182,309\n53,294\n61,180\n60,180\n60,160,180\n41,45,54,68,93,159,180\n44\n39,55,162,180\n0,35\n0,10,64,92,141,180\n0,6,34\n8,46\n0,22,27,29,42,45,69,90\n0,31,180\n0,29,49,72,98,142,170,179\n42,71,163\n55,172,180\n56,179,295\n60,180\n60,180\n60,180\n43,64,175,191,289,296,303\n45,67,168,176,185,287\n59,178,303\n62,180,301\n53,60,68,70,108,165,289,295,302,305,328\n44,48,51,55,59,64,67,71,75,108,289,294,297,304,308,321\n0,5,41,106\n163,180\n0,15,17,70\n0,20,35,123,180\n61,180\n0,180\n0,20,53,55,75,84\n23,41,60,84,106,138,157\n17,34,53,82,90\n0,10,20,36,46,50,62,66,90\n0,59,61,107,123,180\n13,17,19,33,36,90\n1,31,36,56,58,70,77,90\n0,12,19,27,40,45,48,57,60,68,70,84,109,118,124,128,131,137,157,160,180\n7,54,67,85,90\n2,34,61,65,92,95,106,130,139,144,151,159,173,177\n2,25,28,65,87,109,180\n0,9,66,77,111,114,117,158\n13,34,72,90\n48,63,70,77,90,105,120,134,161,164,179\n0,14,30,54\n17,39,52,57,63,85,151,172,180\n30,51,53,59,69,71,114,136\n2,28,44,66,94,110,113,139,178\n14,34,65,79,136,211,235\n15\n28,35,45,179\n0,60,78\n12,26,40,83,86,105,126,129,137,155,180\n40,110,129,149,180\n24,57,69,180\n180\n62,180\n180\n0,32\n0,31\n0,25,30\n68,180\n66,82,180\n59,83,90,93,104,107,113,120,164,166,180\n55\n56\n0,56\n66,180\n47,77\n45,71,73,148,180\n48\n0,10,58,66,180\n0,7,56\n15,112,130,156,180\n118,147\n0,59,120,180\n123\n13,46,65\n15,44,66\n14,41,62\n17,46,63,65\n93,128,132,159\n0,93,123,149,153,168\n0,4,9,15,17,24,32,45,68\n1,44\n80,86,98\n76\n94,100,111,128,180\n89\n60,77,80,86\n0,14,84,106\n86\n63,164,173,177,180\n61,77,80,157,171\n62,180\n0,14,68\n64,70,81,147,168,180\n59,61,109\n51,53,77,124,179\n180\n60,63,71,92,180\n47,72,114\n87,103,180\n85,109,150,180\n54,73,148,167\n114,180\n43,60,80\n0,50,84\n66,180\n67,180\n60,180\n163,180\n133,140,142,145,147,162,165,169,180\n15,114\n68,88,180\n65,180\n97,180\n62,97\n65\n62\n79,176,180\n65,180\n122,163,179\n0,62,128,171\n0,36\n1,39\n137,152,180\n0,26,56\n70,180\n90,114,153,170,180\n78,97,116,129,142,154,180\n0,56\n45,61,76,96\n59,94\n66,180\n180\n46,63,66,69,79,83\n73,75,122,180\n85,91,157,162,175,180\n53,75,78\n74,126,180\n178,180\n68,180\n71,136,154,163,173,175\n68,111,119,175,179\n0,12,57,76\n3,58,62,163,180\n62,65,67,79,85,163,180\n45,48,72,146,169,180\n106,121,123\n69,78,180\n180\n180\n16,54,77\n74,164,167,179\n65,180\n66,180\n65,180\n180\n55,67,74,180\n48,66,87\n180\n180\n68,180\n69,96,99,115\n180\n72\n73,180\n72,91\n72,94\n86\n89\n78,106,180\n82,91,100,180\n0,28,31,39\n0\n100,113,116,163,180\n117,137,148,158,180\n0,76,78,108\n0,6,69,105\n0,46,71,73,76,117\n68,180\n59\n69\n73,92,111,155,161,168\n0,28,49,64,88\n75,92,180\n46\n136\n180\n180\n0,9,121,162\n0,33,82,124\n51,72,78,94,98,115,147,177,180\n11,21,32,58\n14,41,65\n64,180\n61,75,78,180\n57\n56\n0,67,180\n49\n152,154,179\n0,151,180\n34,55,58,66,75,79,82,104,131,164\n0\n0\n160,180\n0\n0\n84,180\n117,134,137,139,180\n125,134,179\n110,116,119,179\n59\n16,58,85\n58,93\n0,57\n77,180\n131,168,180\n22,50,72,86\n48\n77,180\n77,125,141,144,180\n2,47,87\n27,30,51,77\n76,180\n18,55,83\n169,172,180\n62,94\n30,77\n29\n62,156,176\n97,123,180\n144,151,153,156,164,180\n68,96\n47,78,129,148,153,175,178\n119,121,145,148,154,180\n29,36,51,53\n90,110,162,179\n104,107,129,133,179\n104,127,147,159,161,174,180\n88,111,144,166\n57,82,105\n0,55,93\n0,56\n121,156,180\n36,56,80\n68,180\n68\n67,180\n51,179\n39,66,180\n16,25,66,153,180\n67,160\n106,167,171,180\n85,91,105,111,125,132,139,142,178\n59,92\n61\n0,180\n0,26\n0,180\n0,45\n132,138,180\n130,180\n0,33,60\n180\n180\n180\n0,38\n0,27\n180\n180\n79,90,105,135,180\n77,111,145\n77,91,96,120,142,146,150\n77,101,111,121,140,180\n72,180\n180\n65,180\n0,57\n76,88,91,126,166\n32,38\n80\n40\n78,96,98,128,135,147,179\n78,93,112,154,158,172,178,180\n73,180\n8,57\n15,57\n1\n180\n63,180\n67,73,81,84,119,122,166\n0,57\n0,58\n92,180\n112,178\n165,180\n64\n0,180\n180\n0,98,117,129,138,145\n0,125\n12,80,83,116,125,142,146,157,167,170,173,180\n0,12,52,66\n12,32,69\n155,158,180\n64,180\n26,61,76,84,180\n15,56\n0,55,76\n0,54\n63,180\n49,76\n0,38\n0\n180\n180\n180\n0\n0\n180\n180\n70,180\n85,131,180\n95,152,180\n79,81,105,180\n84,106,180\n57\n0,26,52,66\n55\n19,30,73,88\n56\n65,68,180\n85,90,94,96,122,131,176\n171\n45,47\n54,72,82,148,152,180\n81,116,120,180\n81,84,87,104,113,124,129,134,149,167,178\n0,23,42\n29,46,80\n69,139,175\n80,128,142,146,180\n91,123,137,146,154,180\n123,178\n134,180\n21,37,72\n100,109,136,150,179\n6,8,12,14,27,40,119,153,156,180\n0,54,70\n180\n0,121\n180\n65,180\n136,169,171\n0,9,16,56\n1,55,83\n56\n63,180\n54\n63,180\n149,180\n152,180\n56\n62,180\n73,81,170\n47\n180\n89,109,125,127,153,160,180\n106,123,141,151\n0,27,31,69\n56,69,72,93,102,108,117,126,179\n180\n180\n97\n94,108,112,133,167,180\n153,157,165,177\n96,113,123,167,180\n141,155,180\n54\n63,101,123,130,143,148,159,161,164,180\n32\n87,95,97,104,106,149,153,156,163,180\n0,19,57\n83,101,116,133,159,180\n0,67,180\n67,85,173,179\n62\n62,83\n42,57,80,94\n65,81,83,180\n65,180\n42,57,72,178,180\n70,156,180\n83,113,135,149,153,155,161,164\n58,82,180\n74,178\n65,179\n0,25,33,36,40,52,89\n0,180\n0\n0,180\n180\n180\n1,3,36,53,55\n180\n96,102,122,126,145,156\n76,94,110,121\n75,180\n155,171\n23,56\n72,180\n64,180\n57\n59\n73,131,159,174,179\n60\n47\n61,180\n65,78,180\n58\n58\n0,3,180\n180\n6\n201,249,265\n0,4,9,23,28,30,33,86,109\n0,4,28,50,53,72,75,85,87\n0,85\n122,125,167,180\n10,35,37,168\n2,25,28,40,47,65,170\n0,28\n5,11,29\n35,55,85\n60\n1,31,53,261,356\n71\n83,110,183,189,200,215,219\n89\n221,284,312,329\n233\n274,300,307,309,338\n275,277,295,314\n260,289,291,296,305,308\n160,168,180,203,257\n177,196,226\n0,180\n0,104,134,163,170,180\n25,312,341\n24,310,313,332,358\n58,69,73,163,168,174,180\n160,180\n117,166,169\n357\n3,17,23,31,304,320,343,345\n59,187\n63,65\n74,204\n68,71,205,236\n69,204,221,223,242,284,307\n54,72,98,190,209\n281,297,313,338\n219,222,233,283,286,312,336\n279,313,338\n59,80,190,221\n58,78,188\n72,99,183,196\n2,12,17,31,33,41\n1,27\n4,6,35,167\n4,35,153\n30,181,348\n180\n72\n0\n0,21,31,36,38,164,173\n0,16,19,35,52\n1,12,137,158\n11,147\n89\n102\n180\n90\n0\n4,170\n123,134,140,178\n3,5,25,346\n5,341\n32,56,69,84,105,122,161,180\n0,31\n51,90\n69\n60,95,103,107\n90\n90\n0,48\n0,41\n153,180\n32,53\n0,21,30\n46,127,130,143,158,173,180\n0,11,17,90\n0,36,90\n62,137,180\n0,40,60,81,84,90\n37,41,44,49,95,104,118\n54,57,69,74,85,90\n56,90\n59,91,119\n57,90\n0,29\n142,180\n134,137,158,180\n1,57\n3,38\n71,88,95,113,129\n71,78,90\n8,37,56,71,90\n11,42,58,76\n82,103,106,108,123\n46,55,60,64,73,79,90\n27,30,81\n54,97,125,128,152,167,173,178,180\n1,45,61,81,83,86,90\n0,12,35,42,44,80,89\n67,69,91,121,171\n0,32\n13,35,43\n0,47,56,62\n0,11,15,25,28,56,58\n131\n123,144,166,180\n180\n180\n165,180\n0,21\n0,20\n50,90\n67,89,120\n90\n0,33\n59,84,122\n56,64,72,90\n43\n33\n180\n143,162,177,180\n7,28,48,51,54\n2,50\n0,36,46,50,52,54,152\n47,108,134\n57,77,88,118,138\n47\n52,68,85,105\n0,150,154,180\n59,73,107,123,126,129,138,157\n50,119,148\n58,66,86,114,130\n0,3,159,166,180\n44,46,66,104,136,162,180\n52,137\n60,64,74,117,119\n54,72,77,83,90,111,124,141,153\n0,55,85,90,93,96,99,106,129,180\n0,57,72,77,130,180\n63,91,108,152\n15,180\n0,155,168,179\n0,25,175\n70,89\n53\n149,180\n154,165,179\n180\n0,45\n0,39\n70,122,126,180\n50,86,167\n53,123,127,136,142,154\n23,38,53,78,103,172\n0,35,37,44\n0,17,41\n60,75,97,107,139,158\n38,45,49,57,157,180\n40,62,75,81\n0,44\n66,180\n0,34,59,180\n0,63,65,180\n0,74,180\n282,307,334\n305\n68,163,179,246,321\n21,42,55,72,162,180,231,236,242\n52,71\n55,102,113\n177,199,239,290\n155,158,178,201,285\n6,55,318\n10,56,312,354\n30,59,313,358\n0,23,45,47,50,56,58,309,327,335,338,341\n151,194,284\n152,185,279\n12,14,55,312\n15,54,313,358\n49,314\n46,314\n58,80,183,200,280,285,288\n47,61,185,283\n52,68,71,172,297,311\n64,77,144,169,171,300,308\n31,34,37,51\n0,42,46,58,302\n44,312\n0,54,180\n0,56\n182\n76,87,182\n0,52,79\n67,80,153,164,174\n70,76,80,83,85,87,166,186\n52,309\n46,307,325,345\n71,181\n176\n51\n46,49,307\n49,168,182,310,316\n83,130,175\n80,86,92,95,107,128,157,178\n66,180\n74,175\n74,163,175\n181\n181\n32,52,85,123,180,293,295\n201,300\n63,198,299\n50\n4,56,84\n183\n184\n62,116,118,131,174,293\n61,293\n19,28,50,182,300\n53,184,297\n183,226\n182,187,226\n66,164,298\n69,167,297\n60,180\n59,180\n0,54,71,171\n70,179\n63,78,177,179\n33,42,45,51,59,66,71,88,180\n131,166,178,180\n178\n180\n180\n180\n53\n0,2,4,6,49\n28,55\n9,54\n0,25,46,49\n59,180\n64,180\n49,76\n48\n55,180\n67,179\n180\n180\n46,74\n0,37\n58,175\n61,180\n164\n55\n52,55,58,66,179\n76,180\n63,88,180\n297,303\n300\n58,100\n57,102\n56,96\n54,87\n192,267,292\n189,191,193,201,291\n42,53,311\n306\n9,36,56,307,352\n56,307,339,359\n53,276,296\n36,49,55,300\n31,306\n63,74,174,177,185\n76,175,179,181\n186,207,278,282,291,304\n183,196,280,294\n199,274\n199,271\n9,25,55,61,68,96,102,104,142,174,180\n1,140\n0,30\n1,178,180\n0,2,108,123,125,160\n0,3,9,129,165\n0,8,40,121,129,160\n0\n0,2,138,179\n0,39,135,166,170\n25,94,102,126,133,143,155,161\n157,160,180\n161,180\n0\n0,7,45\n3\n66,99,129\n62,78,103,124,127\n106,124\n0,27,30,38,171,180\n0,5,133,146,150,163\n180\n3,39,164\n1,18,21,127,168,180\n162,180\n63,114\n67,85,88,90,105,125\n180\n123,148,322,336,347,357\n125,297,318,326\n8,50,342\n6,8,10,12,23,335\n2,16,342\n16,305,335,343\n1,6,111,231,245,324,347,350,359\n103,108,114,240,249,260,276,300,319,349\n72,78,85,101,105,110,120,271,287,307\n111,133,185,267,301,350\n9,25,332,348\n16,335,337,352,354\n162,164,173,188\n210,251\n13,137,235,238,298,320\n5,128,237,314,317,327,334,339\n283,303,327\n304,330\n314\n15,224,357\n3,18,43,74,212,249\n13,15,188,220,246,248,340\n200,208,226,248\n204,217,246\n202,219,231,234,252,265\n154,174,211,248,265,267\n219,264\n210,249\n1,8,10,12,45,77,291,338\n12,52,296,341\n17,27,328,345,347\n14,48,339,348\n110,329,348\n21,53,76,79,103,351\n2,6,90,105,339\n10,89,351\n122,140,166,173,208,210,220\n134,147,167\n136,217,236,266\n128,145,147,191,194,236,265\n119,126,132,136,226,239,248\n135,154,226,241\n93,116,119,123,276,302,340\n92,110,122,130,243,277,299\n98,107,114,117,123,253,310,316,342\n99,121,251,271,335,343,348,351\n306\n306\n236,250,276\n180,229,252,255,257\n247,279\n16,339\n339\n5,308,342\n13,339\n122,145\n137,155,229\n215,218,221,254,260\n216,221,224,230,232,253,269\n222,228,234,254,270\n313,343\n347\n34,54,290,309,320,345\n1,33,50,293,311,320,328,339\n10,20,26,335,353\n114,126,136,160\n103,120,204\n10,290,329,352\n0,3,25,46,56,87,123,127,135,142,145,155,180\n0,27,45,48,50,76,122,165,177,180\n78,118,148,151\n180\n180\n0,21,42\n0,2,29\n1\n0\n0,14,25,50,84,121,180\n0,13,34,41\n0,30\n56,81\n21,330,357\n17,345\n356\n6,20,34,341,351\n9,33,36,350,352,356\n31,56,355\n17,27,30,321,358\n0\n0,22,24,42,44,51,85,90\n0,66\n0,2,16,42\n180\n0,132,160,180\n0,45\n5,9,22,54\n180\n0,18\n62,88\n33\n20,145,180\n1,10,12,20,27\n180\n0\n137\n135\n144,148,161,163\n6,18,120,142,146,161,164,166\n122,271,313,325\n114,261,318,343\n305,325\n123,147\n134\n0,8,302,304,331\n2,301,335\n5,32,54,75,79,89,338\n9,26,44,47,51,87\n77,83,106\n51,75,104\n119,121,123,150,199,220,251\n116,150,161,199,225,247,250\n149,167,184,189,195\n132,135,138,150,167,182\n152,156,216\n149,175\n130,150,162,164,181\n169,177\n3,7,50,114\n2,4,48,112,169,175\n261,285,322\n261,287,323\n110,115,127,147\n116,139,155\n303\n303,323\n101,122\n102,121\n247,255,257,261,281\n247,281\n287,332,334\n8,290,332\n9,80,101,348\n12,101,348\n128,164,197,234,241\n119,125,128,148,163,190,194,196,231,233\n72,99,117,119,136\n49,96,98,106,112,134,165\n279,291,301,304,322\n250,266,278,287,301,305,332,352\n289,304\n304\n126\n126\n11,18,23,33,70,77,86,113\n21,39,59,88\n136\n136\n51,337,355\n47,338\n118,146,168,170,221,244\n118,141,154,169,172,188,221,244\n89\n90\n52,55,90\n0\n0,8\n1,3,38,58\n0,132,151,174,180\n0\n74,90\n24,337\n162,179,198\n0,10,19,39\n39,59,180\n59,180\n23,93,252,268,322,338\n0,66,180\n0,180\n0,7,33,112,142,180\n0,22,51,87,107,129,150,180\n0,43\n19,177,180\n74,296\n0\n21,159,166,173,175\n56,180\n31,46\n53\n0,10,14,29\n0\n0,44\n136,143,146,180\n60,110,150,167,180\n43,56,102,168\n60\n56\n60,68,75,80,90,178,180\n59,303\n59,302\n71,85,97,105\n49,72\n56\n0\n180\n69\n69,88,103,111,136\n0,14,18,21,34,41,131,134,156,162\n15,20,29,59,61,90,111,139,141,144,165\n48,80,164\n0\n67,180\n0,56\n56,305\n56,305\n59,173,180\n54,75,123,169,177\n57,180\n69,180\n182\n0\n0,22\n61,74,109,141,180\n29,54,77,83,89,108,162\n38,52,87,90,97,105,174\n46,62,71,107\n31,49,97,143\n35,48,73,95,141,172,286\n35,74,94,155,171,293,317\n58,83,158,164,166,180\n19,41,59,174,180\n61,63,80,179,284,338\n91,178,180,189,306\n52,57,61,114\n63,114\n99,261\n58,82,168\n61,80,177,180\n60,79,102,105,113,116,124,127,133,156,176\n63,180\n36,65\n0\n34,36,43,47,59,80,90\n1,9,35,90\n13,21,35,52,55\n49\n0\n8,12,49,126,154,180\n0,34,36,50,71,90\n1,4,39,73\n66,68,86,136,151,153,155,166,180\n0,27\n0,57,84,122,141,144,146,149,164,180\n0,47,99,131\n137\n0,39,152,180\n1,8,29,51,58,62,73,84,89,100,104,106,109,131,152,180\n0,162,180\n0,8,26,81,150,180\n65,75,81\n80\n27,29,66,68,109\n51,71,98,105\n31,33,59,79,102,235,256\n36,38,41,56,62,90,158\n180\n66\n67,108\n67,174\n12,39,54,96,153,158,174\n161,167,180\n60,145,180\n33\n24,28,45\n48,54,56,59,66,78,162,180\n55,67,86,180\n16,19,42,63,67\n47,154,180\n15,33,39,58,104\n0,20,23,45\n12,21,61\n66\n0,25,38,58,65\n43,67,73,84,87\n0,16,18,29,32,36\n22,30,44,53,56,58\n39,62,78,173\n28,61,81,153,180\n2,49,77,85\n0,26,30,37,41,45,51,55,61,65,90\n60,180\n0,16,138,157,168,180\n0,13,29,48,90\n15,131,152,158\n49,53,68,96,112,142,173\n51,71,74,87,110,132,174\n59,62,93,167\n15,40,57,73,110,115,130,139,143,149,155,180\n0,5,40,74,104,137,159,180\n0,7,85,107,134\n0,11,112,132,144\n61,180\n64,89,148,161,167,180\n60,67,77,108,148,171,176\n21,25,45\n36,40,49,54,82,157,171,180\n37,57,180\n52,55,63,155,180\n20,47\n47,67,168\n2,32,34\n0,3,19,38,64,72,79,81\n124,140,174,180\n40,47,49\n17,46,310,342\n1,31\n42,54,56,65,73,85,90\n0\n62,85\n23,32,56,71,83,87\n192,303\n63,159\n180\n67,81,84,175,177\n48,66,109,174\n238,289\n0,46,55,61,79\n0\n0\n15,32,40,63\n180\n63,76,79,176\n64,73\n57,83\n0,7\n180\n57,180\n54,75,90\n69,80,82\n66,80\n103\n71\n180\n40\n0,5,9,17,57,75,78,85\n0,9,31,43,49,63\n2,19,47,61\n60,64,86,121\n43,75\n43,47,77\n41,78,96,101,104,109\n176\n180\n180\n0,29,33,71,90\n0,118,156,180\n0\n36,40,88,90\n130\n0,3,8,20,28,30,49,70\n0\n90\n10,33,65,88,95,102,122,141,150,164\n8,64,93,109,126,149,158\n4,19,235,254,263,277,282,302,306,319,322,328,335,349\n1,235,278,288,300,325,344,358\n10,109,128,167\n10,15,21,23,25,109,124,174\n21,28,50,105,113,125,137,152\n0,6,50,64,83,121,146,173,177\n6,8,21,58\n66,85,99,104,179\n69,180\n66,209,306,338\n66,207,306,332,334\n187,280,285,291\n111,136\n105,129,133,138,141,143\n90\n35,47,56,69\n70,90\n41\n24,47,54,60,90\n64\n0,9,39,58\n0,45,91,95,122,135,155\n182\n64,90\n34,92,132,180\n0,33\n90\n180\n4\n22,44,47\n176,184\n181\n0,6,24,52,79,82,84,90\n303,330,353\n58,106\n58,92,99,114\n27,31,42,68,102,140,172,176,180\n0,3,20,22,25,32,35,37,52,78\n71\n55,80,96\n82,86,89,93\n180\n180\n51,63,71,180\n0,5,152,156,180\n0,22,29,40,88\n136\n41\n101,168\n98,164\n49,52,61,86,113,180\n63,301,323\n59,195,248,293,330\n50,52,69,167,172,180\n31,61,180\n41,48,61,69,160,180\n25,49,63,71,180\n50,71,73,169\n45,59\n57,176,180\n59,174,176,178\n0,24,34,36,90,136,158,160\n57,59,69,180\n58,180\n0,30,55,57\n32,55,59,72,78,156,171\n34,45,58\n54,81,87,90\n1,10,20,43,70,104,110,115,118,139,142,161\n128,141,145,152,180\n0,8,36,52,88\n179\n77,177,180\n180\n49,81,163\n180\n58\n62,79,82,99,106,109,112,120\n66\n67\n28,61\n0,17,123,125\n0,31,55,66,76,89,154,178\n59,102,180\n54,67,168\n62,180\n180\n30,56\n0,6,11,14,180\n0,35,120,142,146,180\n14,18,23,39,44,147,180\n0,30,59,112,121,155,159,180\n0,9,13,24\n12,92,141,156,164\n13,25,53,78,94,114,145,179\n45,70,158,171\n8,19,42,57,60,80,171,176,179,188,201,205,208,222,251,271,299,341\n11,17,38,55,169,201,309,313\n68\n48\n0,4,58,180\n0,9,46,120,166,177,180\n1,18,52,70,115,180\n180\n0,10,12,14,30,48,69,133,180\n78,99,169\n76,95,99,103,150,168\n70,141,168\n72,165\n29,49,72,74,168\n52,59,180\n33,58,90,100,148,180\n0,2,31,51\n0,2,8,42\n59,180\n13,48,178,192,297,311\n43,155,182,282,297,353\n70,72,149,164\n70,164\n33,37,41,166,177,203,308,355\n9,23,42,45,179,190,204,311\n68,163\n66,165\n0\n0\n114,133,180\n0\n0\n0\n0\n0\n0\n0,180\n180\n0,8,159,180\n151,180\n0\n11,22,35,150,179,183,194,197,348\n1,5,157,166,181,199\n15,355\n221\n216,238,244,259\n22,234,246,249,255,261,268,341,356\n248,358\n4,296,303,314,338,359\n2,246,249,305,344\n6,12,298,346\n19,76,80,117,129,131,234\n16,118,144\n0,180\n0\n68,180\n65,79,81,108,169,187\n295\n295\n292\n180\n184,292\n184,282,287,292,300\n179\n56\n21,55,309\n1,40,56,306\n65,185,302,319\n59,77,178,303\n176\n71,157,178\n180\n63,303\n65,183,305\n33,58,61,306\n33,57,300,325,334,355\n180\n181\n67,175,301\n68,175,299\n66,176\n66,131,180\n301\n187,205,293\n191,294\n192,194,297\n191,211,296\n199,268,298\n60,299\n62,300\n67,193\n59,74,298,301,310,323\n38,44,59,62,195,296\n38,62,76,79\n283,292,298,320\n65,83,176,202,228,263,296\n59,70,167,189,262,282,285\n0\n0,18,43\n63,180\n146,180\n180\n54\n14,54\n0,5,7,56,79\n50,65,170\n180\n61\n59\n13,34,55,306\n51,305\n308\n51,306\n50,307\n0\n0,40,180\n0,67,74,90\n0\n143,179\n0,48,60,90,96,98,103,129,180\n0,15,109,119,142,180\n0,25,27,30,49,55,60,77,100,103,105,138,141,173\n0,180\n0,7,135,156,180\n0,28\n0\n180\n180\n180\n0,27,31,41,46,55,57,70,102,128,144,180\n0,180\n180\n180\n8,180\n0,180\n0,179\n0,61,89,112,180\n180\n2,4,51,71,128,130,147,170,180\n0,11,35,38,55,75,78,110,130,150,170\n89,114,126,147,154,159,179\n28,103,134,150\n129,133,143,148,154,159,163,169,176,196,230,236,239,243,247,249,257,269,273,275,315,317,346\n3,138,145,156,185,217,229,232,245,249,262,272,276,294,299,305,309,329,349,359\n103,125\n2,4,21,30,39,45,67,82,97\n1,15,33,90,93\n138,152,155,171,214\n139,186,194,217\n157,173,220,224\n156,217,220\n50,93,118,147,153,183,185,209,224,258,264,270,337\n19,85,141,196,198,201,205,209,211,243,264,327,336\n139,165,219,248\n11,26,121,235,264,293,300,308,314,326,332,338,353,356\n3,7,23,26,101,172,233,257,275,294,310\n3,22,35,45,61,88\n1,133,171,180\n0,23\n151,155,158,161\n151\n65,180\n57,175\n25,57,303\n57,296,304,306\n302\n0,63,180\n133,180\n63\n60\n63\n60,62,180\n180\n0,78,96,101,110,180\n63,180\n66,174,296,303,306,309\n64,175,299\n26,65,67,173,192\n61,90,174,194\n60,172,296\n1,128,150,170,180\n59,180\n54\n180\n15,52\n10,25,53,60\n54\n48\n48,299\n52,300\n302,325\n301\n303,332\n179\n60,83,85,102,178\n60,82,173\n67,76,85,105\n58,306\n191,208,298\n189,210,216,299\n295\n265,295\n251,275,288\n195,251,266,289\n60,184,302\n58,174,303\n54,306\n55,305\n180,186,196,249,268,270,295\n179,185,192,240,273,295,300\n64,174\n65,175\n72,88,92,133,168\n190,198,206,284,289\n190,194,206,286\n236,239,263,281\n193,224,246,263,265,278,292\n0\n0\n0\n0,44,47,66,102,119,129,132,149,180\n0,57,65,90\n0,5,7,24,27,29,31,39,156,180\n0,12,15,17,46,65,85,95,104,107,130,144,150,153,158,161,169,172,180\n0,64,94,127,130,136,180\n1,112,141,256,272,313,332,349,358\n90\n0,35,55,73,109,115,123,126,130,134,180\n89,123,136,144,180\n80,97,141\n55,76,171,180\n72,178,180\n71,180\n158,180\n153,169\n9,27,50,71,78,81,98,122,145,171,180\n0\n0,21,36,45,64,75,83,94,100,127,153,156,177,180\n1\n5,25,38,67,93,164,297,313,336,341,347,353\n12,35,40,47,68,85,296,311,336,341,350\n0,7,25,35,45,48,63,65,68,94\n28,36,46,79\n50\n123,140,164\n90\n63,90,93,124,166,168,171\n0,42,62,90\n179,218\n0,30,52,85\n87,98,107,112\n0,2,14,45,47,75,114,139\n89,104\n85,105\n16,28,35,42,65,79,101,135,160,180\n36,44,46,54,75,91,216,235,252,279,300\n0,180\n0,180\n0,46,180\n0,22,27,42,78,120,122,139,143,148,158,179\n55,70,74,258,358\n0,50,71,89,218,342\n24,49,67,88,135,182,266,274,280,350\n50,83,153\n38,65,91\n70,94,96,98,104,249,259,266\n8,178\n0,97,107,180\n28,65,91,155,180\n62,165\n67,167\n107,110,126\n0,14,18\n44,48,64,80,82,84,104,106,126,131,156,168,176,178\n106,115\n68,156,180\n15,53\n65,157,172\n64,180\n62,72,85,101,143,152,165\n55,62,180\n59,69,73,75,180\n34,59,84\n0,6,19,28,46\n0,17,21\n75\n0,9,33,50,76,79\n54,59,65,74,79,82,95,180\n98,116,142,172,180\n0,26,28,43\n36,54\n35,41,55,70\n4,19,41,177,321,337\n75,118,139,151,172,180\n21,23,46,48,70,108\n0,13,16,25,82\n24,40\n40\n0,179\n0,5,14,20,28\n2,26,28\n0,10,19,24,116,135\n0,18,98,130,166\n109,142\n0\n58,180\n61,176,180\n180\n56\n42,62,180\n0\n0,40,61,66,68,143,180\n0,75,90\n1\n53,73,92,109,133,172,180\n0\n2\n180\n120,145,147,169,174,178,180\n0,28\n11,56,128,165,180\n28,66,90\n0\n180\n0,23,54,77,148,179\n145,178,180\n61,152,180\n0,80,101,122,142,145,180\n0,8,81,113,133,136,143,148,180\n0\n15,24,27,53\n6,8,25\n0,23\n2,52\n2,31,42,56\n180\n180\n141,166,180\n180\n180\n180\n0,38,50,95\n0\n141,180\n179\n8,25,41,61,64,116,124,154,156,161\n148,151,155,158,162\n0,43,54,64,93,123,140,157\n0,67,89,96,98,105,125,132,137,144,146\n4,7\n1,3,17,19\n0\n0,9,25,48\n180\n180\n180\n180\n70,117,147,151\n0,9,11,35,72,95,122\n180\n180\n144,180\n0,180\n0,177,180\n0,20,25,60,172\n128,149,171,176\n180\n180\n0,42,131,161,180\n3,23,36,51,112\n2,15,40,55,58,70,132,161,168\n180\n158,180\n0,2,9,54,89,136,144,148,151,179\n138,180\n0,159,180\n0\n0,180\n0\n97,142,161,180\n82,127\n126,165\n151\n128,140,158,182,186,190,222,244,250,256,298,345\n128,133,231,243,249,264,284,292,301,303,320,347\n107,118,124,136,142\n112,116,118,120,122\n121,132,141,148\n0,41,53,64,89,115\n40,43,50,55,63,70,92,108,110,356,359\n18,21,47,77,90,104\n149,165,167,172,229,260\n116,133,155,177,228\n179,243,268\n167,184,199,219,222,227,250,257,264\n131,155,205,208,214,236,238\n159,165,228,238,242,244,271\n150,213,242\n152,227,232,240\n140,165,178,212,214,232,234,273\n188,202,205,208,236,253,256,258\n115,124,145,172,227,231\n169,181,194,218,236\n238,251,266,282,287,292,295,298,322,348\n224,237,242,260,300,320,325,345\n25,70,96,146\n135,138,145,152,176,217\n141,145,148,159,165,167,173,179,213\n254,269,272,298,331,351,353\n266,295,298,314,334\n0\n0,35,132,134,137,180\n33,64,79\n0,39\n49,52,65,93,110,126,129\n136,154,180\n159\n0,29\n0,18\n180\n0\n0,13,33,120,149,180\n0,45,49,59,90\n0,2,7,10,19,23\n0,34,36,44,70,77,84,128,153\n0,19,21\n0\n0,15,33,162,180\n0,20\n139,180\n20,28,42,119,149\n46,118,159\n20,84,101,117,216,227,230,261\n21,52,63,108,233,239,244\n51\n28,50,76\n35,71\n36,96\n29,34,38,106,214\n39,67,224\n212,238,257\n212,237,253\n106,127,138,166,201\n102,152,201,215\n251,274,290,326,329\n6,8,13,17,268,290,309,326,338\n271,327,349\n277,292,294,302,307,315,323,337,343\n83,109,131,136,152\n85,87,105,135,141,148,152\n105,134,138,142\n72,93,98,108,127\n4,6,12,18,46,63,83,105,132,156,160\n8,15,38,44,57,96,101,116,142,159\n17,42,46,54,68,101,233,243\n15,19,25,27,41,45,47,50,77,87,101,208,251\n36,59,79,104\n109,140,163,179,198,221,238\n109,140,164\n22,55,74,102,105,110,113,188,192,217,239\n10,12,37,96,195,230\n42,198,218,238,242,246,265\n65,112,207,232,267\n32,225,246\n53,75\n25,131,133,321,349\n25,50\n1,3,8,17,34\n22,229,247,348\n2,22,251,307,343\n6,246,269,358\n246,310,349\n223,246,264,288,337,352\n6,359\n1,240,256,274,310,335\n110,147,164\n89,91,105,120,140\n111,132,155\n109,139,157\n5,13,18,241,251\n19,95,116,235,260,357\n18,112,239\n115,130,133,162,244,248\n23,98,131,239,343\n25,222\n21,40,205,225\n70,92,177\n68,158,168,180,272,309\n295,307,317\n58\n11,67\n60,301\n56,281,302,317\n42,58,299\n52,302\n65,176\n64,176\n114,118,175\n72,170,179\n75,124,155,177\n86,123,179\n93,135,176\n61,177\n118,139\n70,177,200,301\n174\n63,81,175\n146,152,178\n71,181\n1,28,48,61,63,317,354\n24,53,55,169,303,326,340\n10,355\n188,190,222\n37,57\n57\n55,305\n54,305,322,329,334\n214,235,237,300,325\n193,221,223,237,240,244,247,301\n195,217,220,258,306\n70,181\n66,129,132,174\n61,76\n79,95,98\n76,172,177,179\n58,84,95\n35,45,62,198,294,306,310\n54,69,190,306\n68,171\n46,49,58,60,62,186,303\n189,227,291\n187,221,296\n55\n58\n169,172,176,185,289\n62,177,307\n62,96,179,306\n57,177\n166\n55,85,108,111,125,138,140,152,175\n59,85,107,124,127,147,175\n103\n261,302\n302,328\n302\n59,189,233,285,289,302\n58,83,190,213,300\n62,84,303\n61,176\n62,177,304\n0,130,136,144,146,159,165\n180\n0,29\n1,17,23,30\n0,3,5,29\n0,4,136,348\n34,44,51,74\n302,333\n178\n100,130\n66,92,94,127,155\n87,100,114,117,123,130,135,145,148\n78,82,86,91,110,114,128,149\n198,218,220,225,253,262,271\n103,105,113,133\n103,133\n26,28,60,180\n46,67\n180\n159,180\n22,55\n23,29,38,57\n33,62,180\n42,61,180\n60,168,300,310\n36,58,168,298\n56,86,94\n54,78,82\n302,304\n302\n139,155,181\n64,90,172\n64,171\n55,68,88,164\n49,66,89,118,165\n66,92,169\n64,123,136,173\n64,88,160\n57,105,163\n61,164\n186,223,298\n192,228,296\n297\n193,254,259,296\n69,80,169,189\n53,177,295\n59,179,299\n47,63,307,314\n38,52,54,303\n44,300\n64,170,173,175\n63,83,171\n59,65,70,179,182,293,299\n58,182,291\n40,61,324\n61,171,314,317\n181,184,199,277,296,301\n0,4,26,53,159,180\n54,180\n24,166,177\n156,191,225\n155,174,191\n62,180\n76,172\n57,80,103,180\n0,31,49,162\n153,180\n127,159,179\n0,25,44\n15,42,59\n4,46\n0,49,82\n65,180\n69,85,180\n60,66,69,72,96,180\n67,180\n0,42,62\n8,69,156,178,180\n44,49,63\n12,45\n3,44\n67,89\n23,67,307,319,322,327,329\n21,46,302,316,338,341\n47,62,306,311,316,356\n41,60,315\n51,193,196,286,304\n52,189,284,311\n45,321\n0,4,27\n28,47,60,67,73,77,89\n0,19\n138,142,175,178\n1\n0,17,44,76,80,96,104,115,126,171,180\n0,9,16,23,28,31,34,66,88,105,112,122,124,128,135,147,156,166\n125,138,151,180\n9,29\n0,7,9,17,37,57,63,69,89,151,180\n0,3,16,36,91,122,131,151,155,158,160,177,180\n60,65\n63,180\n70\n32,58,65,180\n3,9,12,19,154,162,164,169,173\n2,69,90,95,99,120,140\n26,106,120,169,188,334\n38,40,46,59,91,106,108,115,136,138,154\n0\n143,180,216\n56,123,182,241,271,290\n118,138,174,245,316\n94\n3\n20,22,49,79,84,92,95,153\n0\n0,180\n0,14,180\n0\n2,6,13,180\n22,180\n0,24\n0,22,180\n169\n13,21,30,71,73,238,334\n0\n0\n4\n0\n0\n68,70,182,185,302\n65,186,300\n199,294\n192,194,290,300\n0\n63\n57,59,310\n189,296\n187,203,297\n0\n0,2\n196,239,292\n0\n0,25\n0\n92\n17,77,96\n68,151,172\n69,177,201\n287,290,306\n0\n0\n0,25,49,69\n0,28\n66\n66\n293\n294\n0,11,26\n83,85,102\n87,105\n7,11,14,46,54,58,148,155\n14,47\n5\n11,163\n16,51,140,171\n4,13,41,59,171\n4,35,54,86,224\n4,7,36,59,69,217,219,236,239\n257,268,270,339\n265,339\n225\n222\n225\n228\n63,163,180,279\n1,40,280,343\n0,39,62,80,162,180\n66,116,138,141,145,167,180\n0,3,27,29,65\n13,36,58,76,101,119,172\n0,9,60,74,106,157,159,171,180\n0,63,104,107,110,133,145,172,177,180\n0,2,33,39,42,59,76,102,146,155,168,174,180\n84,109,115,180\n99,152,156,165,172,176\n0,8,37,69,100,103,106,123,162,169,175,178\n63,106,133,171,177,180\n46,66,82,117,170,173\n143,163,180\n0,22,32,60,68,96,111,132,155,167,171\n1,3,7,122\n61,177\n32,34,38,56,180\n56,168\n61,180\n27,58,109,140,180\n39,64,94,180\n27,61,86,154,178,180\n0,12,30,36,51\n36,55,77,99,102,105,144,179\n21,55,71,77,87,91,95,124,139,163\n50,53,62,175,177,179\n13,50\n14\n13,102,106,260,263,282,333,351\n52,64,180\n61,180\n56,178\n59,180\n60,180\n61,180\n3,315\n0,21\n51\n3,72,114,133,162,165,180\n47,110,115,132,160,169,172,180\n0,180\n0,179\n0,180\n7,9,29,87,180\n2,102,149,154,158,185,189\n3,49,96,118,120,136,161,164,181,184,188,198,236\n8,32,41\n14,30,33,64,356\n138,143,149,172,184,188,198\n142,182,198,204\n11,48,190,205,211\n13,344,346\n181,279,297\n181\n69,177\n66,82,142,178\n76,78,141,169\n306,316\n295\n57,70,72,170\n32,56\n48,50,61,180\n60,94\n47,66\n286\n58,62,180\n180\n180\n1,187\n169,188,192,212,358\n15,17,156,184,206,208\n26,167,172,180,199\n0,3,37,180\n46,61,66,156,165,177,180\n142,155\n119,129,138,178\n180\n146,178,180\n76,92,127,131,180\n100,139,157,180\n22,26,33,74,89,102,306,321\n58,79,87,135,148\n81,103,134\n151,168\n43\n85,149,161\n150\n32,44,82,174,180\n0,75,147\n83,131,145,151,173,179\n96,103,107,117,148,180\n72,82,84,88,131,140,148,150,158,160,162,170,180\n106,150,163,180\n73,148,167\n69,129,154,171\n42,72,175\n44\n23,57,74,77,97,106,109,180\n80,152,169,180\n1,3,14,16,124\n59,180\n9,52,172,331,344\n4,17,54,166,312,340\n17,21,34,58,141,310,312,330,347\n19,28,33,36,57,60,64,312,336,341,353\n78,160\n78,131,161\n68,125,155\n68,102,117,131,152\n10,39,74,291,323,347,359\n18,43,346\n6,13,19,24,44,56,80,174,311,330,359\n15,46,53,162,180,313,357\n4,39,66,70,298\n1,40,65,75\n12,29,56,76,86\n46,64,141,163,180\n57,83,179\n44,64,180\n62,180\n39,54,56,68,72,169\n52,174,299\n56,175,194,287,300\n0,21,36\n0,180\n0,180\n180\n0,52,180\n0,180\n1,6,48,73,172,176,180\n0\n0,27,48\n45,75,168\n22,61,180\n0,11,35,117,133,157,159,173\n0,36,144,180\n21,46,54,63,93,115,180\n0,14,33,61,66,73\n212,214,235,237,255\n226,252\n0,9,15,18\n0,6,13,33\n46,62,180\n67,166,168\n55,57,72,75,80,164\n26,44\n56,73,163,173,177\n53,59,170,175\n58,143,163,179\n0,180\n0,54,139,180\n27,105,129,146,163\n48,103,105,130,180\n0\n0,25,31,180\n0,180\n0,3,8,20,23,71,91\n17,55,130,132,139,147,153,180\n0,24,34\n4,7,60,97,137,155,172\n0,177,180\n0,8,31,59,154,164,167,180\n0,7,28,34\n0,18,176\n32,66\n2\n0,179\n146,149,156,169\n180\n73,86,101\n0\n0,180\n0,6,180\n0,163,180\n0,6,150,169,180\n0,20,23,151,180\n32,64,67,95,119,122,180\n63,95,180\n51,92,123\n56,60,74,180\n0,55\n58,174,176\n74,178\n64,180\n65,170,185,201,290,312\n62,67,200,301,306,311\n68,302,320,328\n297\n191,299\n57,71,184,194,301\n60,75,176,193,288,308\n52,282,307,316\n53,60,84,297\n69,71,210,262,304,321\n57,71,300\n38,66,68,85,131,146,149,176,206,220\n49,54,56,63,68,74,76,123,128,133,140,169,180,186,224\n60,65,71,160,177,211\n173,202\n165,189,194,202\n161,194\n167,171,188,193\n164,166,171,179,191,208\n0,14,45,56,81\n31,44,55,66,89\n180\n163,180\n180\n0,4,12,18,46,66,90\n9,13,21,29,34,39,69,78,82\n0\n180\n180\n80,88,91,98,108,114,119,138\n180\n60,303\n0,107,111,118,127,132,141,143\n301,324\n59,174,299\n61,174,299\n24,38,96,150\n270\n270\n38,51,54,319,322\n30,48,182,294\n181\n181\n303,321,342\n299,314\n299,315\n49,61,68\n47,76\n17,40,327\n38,328,340,347\n0\n0,29,153,177,180\n38,41,62,90\n0,35,40,50,90\n49,56,60,64,72,75,98,119,154,160,173,180\n1,34,38,78,87,90\n101,126\n0,8,59,79\n118,180\n21,27,29,87,97,108,162,170,172,174,177\n0,44,79,96,139,180\n27\n51,59,70,90\n154,181,209,227,237\n339\n340,349,351\n0,31,42,47,51,59\n0,47\n0\n0\n0\n180\n0\n0,19\n0,5\n178,180\n0,37\n0,7,12\n0,18,62\n0,28\n6,38\n53,180\n180\n53\n55\n0\n0,6,8,18,38,71,80,83,90\n51,87,90\n0,2,31,82\n5,14,17,26,57,62,68,75,121,127,130,142,157,165\n56,60,71,82,90\n49,69\n34,55,90\n51,72,104,119\n136,180\n0,34\n0\n0,28,30,35,39,41,43,45,100,131,133,135,180\n0,22,37,58,64,67,90\n0,35,90\n51,69,102,113,127,179\n56,75\n0,30,32\n180\n37\n27,58,64,79,82,108,137\n0,23,125,136,142,156,167,172,180\n126,135,152,155,160,165,180\n337\n2,22,26,45,48,51,61,64,79,90\n0,26,104,131,148,167,176\n160,191,250\n160,167,171,203,207,217,221,244\n139,161,164,176,180\n0\n85,90\n35,53,63,80\n77\n302,305,327,333\n0,20,26\n32,51,70,78,87,103,109,113,115,122,131,133,141,143,160,164\n0,71,90\n7,35\n0,29,48,67,89\n0,8,10\n0,8,28,43,77,98,127,141,164,170,180\n34,37,57,63,67,74,90\n0,2,11,43,90\n64,75,80,114\n90\n0,2,37\n0,59,93,120,135,139\n0,6,11,180\n179\n0,2,6,28,155,180\n0,129,137,151,173,180\n2,25,34,36,180\n180\n51,305\n111,275,301,305,320,336\n168,204\n304\n305\n18,308,312,318,322,325\n4,38,42,50,53,280,310,314,323,327\n293,321,323,331,337,354\n286,288,306,325,330\n117,126,133,160\n112,140,165,206\n0,10,16,18,26,36,77,126,139,171,174,177\n20,36,77,96,99,156,180\n57,180\n180\n73,124,177\n66,84,125,173,182\n63\n0,39\n0,45,70\n0,166,169,180\n19,54\n196,298\n314\n74,308,312,315,328,335\n1,3,24,35,44,53,90\n44,58,61,75,97,99,102,123,156,159,175,180\n0,166,180\n33,126,145,159,180\n0,180\n0,180\n180\n251,304\n24\n0\n0,20\n0,15,18,33\n14,46,81,105,112,123,145,180\n37,43,63,87,90\n39,90\n0,16,21,47\n0,45,90\n0\n90\n0,2,7,9,30,47,62\n0,32,34,38,51\n28,48\n58,180\n180\n0,12,37,40,71,171,180\n0,3\n181\n87,251,258,272\n54,79,82,98,106,111,130\n163,166,180\n180\n126,319,325,329,333\n125,137,146,300,305,312,319,331,335\n155,168,180\n61,90,102\n0\n71,262,289\n69,292\n0,43,64,90\n14,36\n0,14,17,29,48\n2,8,10,17,26\n0\n0\n0\n2,8,13,180\n1,14,33,54\n180\n12,113,122,142,158,180\n0\n19,191,217,287,310,340\n0,33\n180\n1,30,180\n162,180\n0\n180\n0\n24\n15,47,49,76,127\n21,181,200,206,210\n29,200,203,231\n59,90\n184,304\n179,302\n0,29\n154,180\n180\n177,180\n0\n0,24,120,136,168\n0,37,147,180\n35,96,109,126,151,157,180\n180\n0\n180\n0,169\n1,5,180\n0,16,180\n0,180\n0,33,67,180\n0,180\n0,23,55,132,151,180\n0,180\n0,145,180\n0,180\n0,143,151,180\n3,10,19,21,30,166\n45,59,86,89,137,158,172,177,191,194,232,248,266,319\n10,43,78,103,151,153,176,245,257,266,287,326,331,338\n0,20\n1,21,167,173,180\n0,154,180\n24,44,57,84\n97\n0\n2\n64,80,119\n56\n2,64,78,135,180\n49\n71,85,111,115,145,180\n45\n47,54,61,180\n49,130\n56,63,174,185,302,342\n49,69,173,295\n61\n72,82,104\n180\n286\n188,277\n82,160,167,180,294,296\n75,95,132,156,162,168\n177,179\n129,150,180\n11,147,175,180\n0,180\n180\n0\n180\n2,4,180\n180\n6,161,180\n0,170\n0\n180\n179\n180\n180\n0\n151,176,180\n59,75,97,117,164,192,220,251,264\n74,104,237\n50,54,61,77,89,96,211\n180\n0,79,107,126,136,161,180\n0\n146,173,178\n180\n0,49,76,87\n0,122,143,173,178,180\n0\n0\n180\n0,7,144,171,180\n180\n0,180\n1,180\n0,25,127,157\n0,2,20,46,67,97,100\n0\n0\n148,175,179\n9,39,51,54,136,139,159,178\n0,75,107,180\n0\n0\n137,150,153,180\n42,44,46,113,132,162,168,171,196\n42,46,74,107,137,166,168,201,204\n30,49,73,91,119,176,181,190,199,206\n47,70,89,116,204\n4,17,323,328,341\n7,245,326,341\n107,115,150,176,181,199,219,224\n109,116,146,192\n30,121,147,166,194,204,313,317,321,324,332,335,356\n31,57,60,136,150,156,162,203,314,327\n14,180\n0,162,165,180\n8,163,180\n167,186\n155,188\n0,30,34,58\n0,84,180\n0\n180\n136,158,180\n0,180\n0\n180\n2,30\n0\n139,180\n2,7,25\n180\n180\n65,157,162,173,180\n0,21\n39,133\n0\n0\n20,26,34\n22,37,322\n180\n159,173,180\n0\n0\n180\n12,35,37,180\n13,16,19,24,40,55\n68,85,135,157,160,169\n0,58,73,179\n63,180\n0\n0,113,115,117,147\n30,61,180\n180\n49,51,57\n1,56\n57,178\n44,78\n65,171,180\n62\n61\n5,9,51,64,300,316\n0\n13,18,38,40,78,131,136,152,178,180\n45,67,89\n0,13,44,89\n71,111,118,120,145\n50,54,71,90\n0,46\n43,68,90\n163,166\n0,16,33\n155\n132,157\n0,36,56,66,123,126,138,163\n100\n0,2,146,171,176,180\n19,58,72,92,117,125,128,156,180\n0\n53\n0,72\n83,101,110\n12,34,46,49,52,67,70,84,90\n0\n47,137,180\n1,4,67,90\n1,29,70,87,90\n174\n139,168,180\n0,36\n0\n13\n143,180\n17,47,66,88\n60,68,78,98,106,110,113,150\n0,21,44,48,66,90\n41,72,114,180\n140,178\n137,164,177\n0,18,20,30\n0,20\n0\n2,24,51,144,180\n73\n2,37,70,90\n63,66,96,99,114,180\n85,90\n2,16\n0,12,25,86,180\n0\n162,180\n157,180\n179\n5,24,33\n50,70,90,105,145\n0,3\n69,154,173,180\n0,58,91,107,142,157,162,168\n8,125,138,151,161,172,180\n0\n0,37,180\n7,118,135,171\n0\n0\n125,234\n143,168,189,208,228,236\n33,69,90\n22,38,57,82,126,144,165\n0,4,50,89\n60,62,87,90,92,97,115,129,133\n132,141,152,161,173,180\n155\n0\n1\n0,21,103,128,162,180\n0,49,71,81,90\n0,35\n44,68,111,135,167,170,180\n64,67,71\n39\n50,58,63,67,87,96,128\n54,90\n52,71,98,118\n137,145,174,176\n138,143,163,180\n0,32\n0,20\n0,10,68,73,79,96,139,178,180\n23,139,159\n0,178,180\n25,47,53,60,135,180\n0\n0,141,155,157,180\n0,21,133\n118,121,138\n166,180\n150\n0,35,132\n65,131\n45,47,122\n44,99,101,119,162\n7,25,32,41,44\n13,18,21,42,44\n25,43,105,129,218,238\n27,66,73,75,77,79,107,217,236\n21,48,55,57,79,85\n53,57\n39,89,109\n36,70,101,104\n13\n23,45\n14,17,43\n29,34,46,76,80\n111,128,147,149,152,173,197,199,209,238,243,245\n110,148,172,197,251,253\n146,160,169,173,175,199\n160,180,194\n3,8,21,41\n1,22,32,40\n259,290,324\n21,282,302,308,322\n243,249,255,260,279,308,325,332,334\n256,275,318,339\n37,44,49,57,86,97,99,107,131,153\n0,14,34,50,70,83,106,108,111,114,133,138,142,153,157,178\n27,44,48,85,93,105,113,214,220,261\n28,55,93,106,114,116,140,219,221\n29,56,77\n33,35,41,48,82\n108,152,168,176,196,218,241\n106,164,200,203,206,237\n18,35\n17,42,356\n13,130,133,238,352\n5,11,17,110,131,225,232,243\n203,209,212,222,229,267\n8,29,72,292,328\n6,17,27\n13,33,342,352\n8,30,33,87,124,145,235,272\n20\n17,343\n20,61,211,236\n19,30,231,233,250\n24,59,106\n55,303\n58,305\n149,178\n146,152,158,180\n60,185,293\n61,180,182,291\n80,180\n80,145,155,181\n141,182\n56,303\n57,303\n177,303\n186\n187\n169,189\n55,57,77\n2,22,36,58\n34,57,306,332,342\n7,53,70,307,324,334,344\n71,122,181\n73,163,180\n50,190,303\n64,82,192,306\n57,59,61\n199,204,207,210,216,297\n71,177\n266,306\n47,298,322,345\n46,52,58,313,345\n0,54,305,326,328\n1,52,303,349\n186,281\n60,180,304\n63,150,179,243,304\n65,165,183,306\n61,81,157,165,169,171\n309\n63,188,296\n64,186,244,295\n43\n63,180\n62,67,292,298,305\n64,149,182,309\n62,184,297,312\n179\n177\n3,6,124,126,138\n13,25\n105,112,135,137\n111,136\n137\n61,180\n58,169\n180\n180\n53\n25,52\n61,180\n52\n71,180,191\n42,65,183,305\n53,81\n58\n68,134,173\n67,94,101,175\n65,137,193\n68,135,172,185,188\n189,201,291,298\n187,190,196,243,293\n61,170,299\n55,180,301\n49,309\n34,44,53,309,312\n68,169\n70,170\n14,19,27,30,55,144,152,176,180\n0,7,14,21,66,149,180\n134,140,154,172,180\n13,28,64,92,151,172,177,180\n123,163\n161,179,182\n38,64,93,99,105,144,158,181,303,331\n157,180\n0,19,32,50,168,177,180\n0,27,58,88,147,178,180\n109,137,150,152,166,179\n0,37,44,51\n41,180\n142,153,155,159,176,189\n128,148,162,173,183,188,199,218\n132,170\n122,128,134,150,172,200,279,299\n35,96,129,169,193,293,311\n73,293,329,344\n122,164\n52,66,85,97,179\n62,169\n57,180\n67,75,87,180\n180\n59\n1,19,37,39,41,74\n30,48\n37,67,70,180\n63,180\n0\n50,52,180\n42,59\n58,68,73,164\n47,53,62,76,166\n25,58,123,171\n41,61,180\n12,31,33,35,49\n0,3,7,10,17,44,78\n70,180\n44,310,321,324\n305\n1,33\n0,44,78,90\n90\n0,49,72,90\n48,74,76,86,91,102,120,135\n90\n56,90\n61,84\n58,90\n4,14,39\n132,160,179\n0\n0,56,88,90\n130,180\n20,45,70\n87\n0,21,44\n90\n0,3,57\n2,12,48,71,73,77,87\n55,93,110,115,126\n59,89\n90\n0,65\n0,9,36,43,68,95,100,105,116\n111,136,158,180\n7,25,33,35,37,48,67\n1,13,64,83,90\n12,38,43,45,72,93,104\n66,84,90\n0,7,49,52,78\n136,151,180\n0,3,6,36,40,51,66,90\n38,84,90\n0,22,137,175\n53,65,83,90\n0,3,5\n58,75\n65,90\n110,113,132,155,180\n11,13,40\n90,93,110,130\n12\n11,84,338\n142,164,187,204,240,249\n140,162,201,203,244\n1,69,342\n6,340\n28,351\n351\n144,215,248\n144,165,198,218,246,280\n157,193,207,238\n156,190,208\n45,58,77,84,90\n49,70\n0,57,59,66,86,89\n0,47,50,57,59,66,78\n14,125,139,163\n61\n0\n117,147,175,180\n101,158,178,180\n0\n0,27\n0,3,19,23,29,32,45,48,71,90\n1,21,35,51,57,70,74,90\n0,3,10,25\n0,38\n0,17,34\n11,66,84,124,177,180\n9\n0\n8,39,64,88,91,122,142\n3,26,73,79,86,130,155\n0,23\n0,29\n95,123,163,180\n0,18\n0,149,152,178\n0\n78,180\n12,35,51\n0\n0\n0,29,35,41,157,162,180\n180\n55,71,180\n29,33,58,80\n70,77,179\n13,18,22,26,28,68\n0,41,180\n180\n304\n300\n0,4,11,15,60,311,334\n27,57,293,310,356\n9,56,308,310\n12,15,58,309\n48,310\n48,314\n152,274\n120,156,162,164,166\n60,282,296\n63,296\n70\n80,100,131,171\n77,95,131,150,155,161\n57,278,294\n76,120,170,189,195\n75,169,187\n172,185,194,213\n182\n160,185\n20,49,63,160,169,175,178,186,291\n15,46,54,60,166,181,281,294,312\n2,5,295,326,343,345,355\n0,86,93,101,118,143,179\n95,130\n117,137\n187,206\n192,207\n291,306\n43,53,64,295,310\n47,63,172,299\n115,135,153,156,160,163,166,226,230,237,241,270,274,285\n91,113,115,120,129,132,144,194,237,264\n163,172,178,235,263,271,275,279,285\n178,208,262,278,284,296\n61,310,351,358\n27,45,55,74,314,335\n308,326\n44,184,297\n44,185,297\n98,116\n104,111,118,144\n182,202\n184\n62,174,307\n163,174,176,309\n19,21,35,41,56,91,94,150,166\n6,12,24,50,71,87,158\n264,267,271,282,312\n274,276\n42,67,314,337,358\n31,61,315,357,359\n171,279\n185,255,274\n3,318,333,346\n122,141,143,149\n110,128,149,193,209\n12,69,314,326,330,335,348,355\n313,325,355\n79,107,287\n109,113,119,127,149,168\n104,106,116,119,122,144\n178,191,223,239,244,250,266,284\n204,251,281,284\n51,307,325,342\n19,322,340,344,352\n297,315,334\n44,276,304,320,337,353\n0,7,63,93,129,131,157,160,180\n0,24,39,87,132,180\n2,39\n41,64,115,132,138,147,153,171\n90\n90\n66,72,90\n91\n64,179\n180\n52\n50,66,70,90\n76,78\n168\n30,54\n38,58\n62,80,83,87,90\n4\n0,11,36\n0,42,82\n0,14,39,41,45,56,90\n53,90\n5,56,92,104,109,138\n55,73,109,126,133\n34,36,69,82,85,89,102,107,230\n24,40,51,54,56,71,86,125,226,243\n124,139,168,195,222,225,243\n165,183,202,225\n45,62\n7,57,70,72,74,90\n21,359\n23\n7,55,304,351\n60,175,309,319\n62,172,191,312,319\n12\n62,177,180\n61,63,170,180\n180\n180\n52\n54\n54\n69,169\n71,97,169\n66,180\n49\n47\n73\n61,90\n67,69,73,78,80,86\n24,42\n44,98,123\n71,73,90\n90\n60,73\n82,90\n55,58,90\n90\n90\n43,49,60,71,78,83,89,95,104,130,161\n80,83,87,90\n53,90\n0,29,43,90\n0,148,180\n66,180\n52,180\n56,299\n62,297\n184\n12,15,57,60,302\n59,180\n180\n180\n12,54\n59,180\n45\n0,132,137,148,151,161,168,172,176,180\n0,139,159,180\n0\n0,175,180\n0,4,6,12,180\n0,20,22,24,137,142,156,171,180\n0,14,17,33\n0\n2,18,36\n0,136\n180\n180\n180\n1\n89\n92\n0\n0\n46,65,90\n90,98,101,256,264,273\n8,180\n0,179\n17,22,38,55,84\n59,89\n84,88\n0\n0,18\n0\n0,36,69\n4,19,166,188\n5,188\n0,26,32,36,117,180\n21,64,90\n89\n0,19,54\n0,7,72,87,90\n21,29,37,60,70\n52,180\n153,174,180\n0\n313,336\n311\n0,8,13,23,34,42,44,67,73,81,96,99,120,146,151,153\n0,4,8,25,37,46,69\n0\n12,18,24,89,121,152\n1,8,41,69,72,85,111,140,151,174\n70,89\n23,50,81,121,124\n32,60,75,77,83,94,120\n164,181,208\n0,28,311\n359\n0,46,318\n0,52,54,90\n72,89\n0,60,62,90\n90\n25,50,90\n74,92\n88\n77,79,89,96,101,126\n65,96,120\n146,171,178\n1,181\n3,160,163,179\n0,180\n90\n0\n0,22,93,180\n0\n0,35\n0\n0,19,33,51,134,148,180\n53,74,117,123,140\n2,179\n207\n60\n31,33,65,75,94,100,107,276,305,333\n0,17,35,58,61,65,68,71,88,165,212,269,308,316,325,344\n38,53,79\n0\n0\n178\n0\n180\n0,11,151\n0\n0,35,60,65,68\n0,14,18,22,26,84,90\n0,7,19,33\n26,52,288,292,301,319,333\n67\n67\n30,57,88\n0,8,16,24,53,106\n0\n0,128,134\n0,2,6,10,13,76,99,112,159\n89,160,180\n1,33,38\n0,17,102,110,113,175\n0\n0,42,152,180\n8,35,56,90\n8\n0,180\n0,24,78,84,99,102,105,117,134,173\n6,59,63,79,116,136\n5,39,41,48,65,72,85,111,125\n111,233,258,270,288\n0\n73,76,105\n99,102,142\n57,77,139,172,179\n32,40,44,49,57,79,165\n90\n88\n151\n30,52,70\n91,93\n70,88,90\n93,115,138\n43\n121,130,152\n148\n114,133,140,143,171\n0,10,180\n0,3,17,29,172\n1,27\n108,125,134,136,150,183,288\n111,131,142,149,156,158,165,168\n77,98,121,145,283\n106,136,148\n103,138,152,186,283\n95,114,140,149,159\n98,126,143,188\n98,101,111,134,154,171\n0,24,26,41,48,67,126,165\n22,46,81,178\n0,24,30,32\n90\n85\n180\n0,3,16\n18\n2,180\n12,27,174\n2,54,65,95,121,163,180\n6,28,46,63,88,91,117,136,162,180\n0,8,10,19,107,109,137,165\n0,18,42,62,76\n90\n0,18,36,40,90\n54,74,89\n69,107,110\n47,68,106,109\n11,42,104,153,180\n0,21,180\n99,103,128,290,333\n175,355\n179,352\n56,66,180\n52,62,180\n17,21,50,57,59,73,129,159,179\n26,46,78,102,109,122,124,146,166\n52,81,170\n54,168,302\n45,63,151,170,180\n63,180\n174,177,180\n11,14,27,52,66,74,77,108,124,157,171\n42,51,63,172,180\n65,183,308,310\n49,66,172,177,183,289,297,300,316\n51,76,78,90\n82,88,90\n2,45,47\n110\n80,90\n21,35\n0,29,31,46,56,71\n33,135,175\n24,151,176,180\n61,64,180\n43,57,75\n60,180\n29,47,63,118,143,159\n54,56,174,180\n1,46,62,92,115,149,152,156,165,170,180\n0,6,9,14,180\n60,180\n0,180\n0,8,12,39,43,52,73,78,81,93,122,128,142,146,151,177,180\n0,180\n0,28,39,47,49,57,80,110,112,135,151,156,180\n0,43,94,112\n0,180\n2,74,81,93,114\n0,2,8,145,149,176,180\n0,180\n0,180\n0,144,180\n0,20,36,48,81,145,180\n0\n0,28,127,154,179\n10,14,37,62,70,82,85,142,155,180\n0\n0\n9,30,35,86,100,105,140,173,194,216,258\n18,28,79,95,111,121,141,188,195,208,220,258\n29,34,55,59,63,67,71,128,189,198,220\n10,26,29,39,82,182\n281,318,338,357\n133,137,141,148,160,170,208,210\n138,162,185,209\n18,63,132,196,213,228,337,357\n18,51,347,355,358\n0,3\n180\n178\n15,170\n0\n0,163,171,177\n0\n0,163,165\n90,119,177\n75,94,134,145,178\n2,23,180\n0,40,97,158,160,169,171,180\n0\n12,14,17,22,180\n0\n0\n7,12,27,30,62,95,114,125,184,205,208\n22,27,33,54,61,71,93,127,185,188,212\n25,331,338,344,354,358\n18,243,265,317,352\n117,147,171,198\n16,30,32,89,190,194\n15,28,30,33,185,195,197\n0,180\n75,176\n177\n35,67,78,85,157\n54,178\n0,10,20\n0\n3,7,12,17,176,180\n0,153,180\n180\n0,180\n172\n1,7,9,15,170,180\n0,3,29,53,74\n0\n0,38,180\n0\n0,2,180\n7,155,174,178,180\n13,31,171,198,214\n2,5,17,198,356\n0\n0,33,145,165,180\n0,61,90\n0,16,38,68,86,99,131,180\n0,2,23,179\n0,23,30,180\n0,180\n0,13,141,163,179\n0,179\n0,44,47,50,59,76,85,92,127,133,143,146,180\n0,23,26,60,65,80,140,151,163,180\n100,126,158,279,288,301,319,335,339,344,353\n104,130,132,138,141,147,316,338,341,348,352\n0,180\n164,180\n1,21,145,190\n7,144,172,204,351\n20,23,353,358\n0,174,180\n1,58,77,88,96,132,145,153,177,180\n0,6,173,180\n0,180\n0,180\n1,21,171,178,180\n0,43,141,171\n17,28,158,206,338\n7,23,30,104,135,137,150,185,187,192,194,213,325,329\n0\n5,51,61,182,317,341\n4,8,12,54,58,179,298,318,342,345\n33,64,105,184,289,328\n3,25,38,44,70,315\n0,61,180\n52,68,86\n90,93\n61,84,115\n80\n78\n92,118\n78,97\n0,166,174\n0,20\n90\n90\n83,99,105,139,180\n0,3,120\n0,13,18,38,66\n0,15\n64,81,94\n87,122\n64\n66\n62,78\n51,70,72\n63\n68,180\n82,150,180\n55\n58,180\n75,87,106\n197,210,213,227,234,271\n207,268,283,290\n1,180\n68\n73\n150,179\n0\n144,150,156,160,168,173,177,180\n105,111,119,125,127,129,138,174,180\n0\n4,180\n0\n0\n0\n15,130,132,156,174,178\n97,117,119\n154,178\n150,173,176\n0\n0\n0\n180\n17,19,41,58,70,78,83,86,92,108,114,123,139,169\n12,65,70,154\n0\n0\n0,180\n0,180\n1,36\n0\n0\n1,176,180\n0,2,18,154,156,163,180\n1,16\n26,32,35,40,118\n0\n0\n12,22,25,119,140,178,212,221\n10,18,25,52,58,98,113,115,133\n15,19,21,23,32,98,100,102,112\n0,120,124,141,144,180\n0,177\n0,180\n0,180\n0,180\n0,45,125,180\n43,103,190,213,218,264\n286\n64,183,293\n69,186,292\n181\n181\n53,303\n48,64,282,304,330\n69,72,174\n75,175\n59,170,299\n69,161\n71,172\n60,180,304\n58,181,307\n65,84,174,303,320,324\n184\n177,191\n189,192,297\n181,200,267,297\n42,48,66,176\n67,170\n63,65,82,174,189,307\n63\n59,63,66,76,185,302\n59,291,301\n72,180,204,207\n70,180,192\n35,40,57,311\n54,68,75,83,186,189,202,204,206,208,229,247,294,298,303\n64,67,69,176,178,209,272,279,287,297,308\n0\n0,2,137,144,147,174,179\n0\n1\n0\n180\n166\n180\n0,180\n0,139,149,178\n0\n0\n180\n179\n3,7,172\n0,9,38\n3\n0\n180\n0,31\n85,129,147,180\n3\n180\n159,180\n0,154,174,180\n0\n180\n0,17\n180\n0,180\n0,24,50,52\n0,25\n180\n152,171,180\n23\n180\n0,3,6\n3,7,75\n180\n17,51,53,58,62,84,88,97\n18,58\n70,90,94,103,112,152,155\n66,244\n11,26,41,47,63,89,110,113,122,226,246,274\n48,68,82,85,98,269,318\n62,87\n55,59,61,63,66,87,93\n83,89,92,102,129,146\n16,347,355\n10,15,19,348\n58,183,306\n69,179,304\n295\n64,177\n64,161,176\n196,291,294,298,302\n189,203,297\n0,26,90\n0,41,57,63,79,84,124,126,180\n6,13,49,83,89\n0\n180\n0,33,40,44,53,79,88,112,129,180\n0,46,102,135\n0\n0,29\n180\n180\n180\n1,70,73,96,111,116\n0,21,25,28,110,124,129,134\n137,160,180\n129,180\n2,7,162,165,180\n0,6,180\n4,7,42,54,75,80,93,128,134,180\n0\n180\n145,180\n178,180\n82,92,108,124,149,179\n0,49\n90,118,120,144,151,166\n256,291,323,325\n294,304,308,310,328\n7,29,42,46,51,54,88,344\n5,14,29,58,85\n112,152,198,218,253\n111,121,154,178,201,222,255\n144,163,199,254\n26,153,259,270,322,341,348\n261,315,333\n144,147,195,213\n147,165,195,198,231,272\n0\n0,28,33,118,140\n180\n0\n0,124,130,144,152,154,162,180\n4,61,71,75,78\n0\n0\n1,160,180\n31,55,62,70,101,165,180\n23,28,40,60,164,166\n3,23,41,51,86,109,124,127\n6,10,12,25,60,73,79,95,121,157\n52,92,241,251,262,300,339,345,354\n47,73,101,122\n69,90,93\n1,19,36,58,64\n0\n7,13,55,117,120,141,160\n22,168\n26,43,137,178\n39,222\n36,213\n209\n208,230\n180\n145,180\n0,3,63,170\n27,54,60,64\n64,179\n65,140,169\n65,156,171\n186,209,303\n54,56,180,296\n62,187,299\n62,180\n56\n62,90,188,280,284,293,314\n64,170\n65,173\n33,62,180\n41,49,62,65,79\n249,288,290\n197,199,271,292\n199,286\n286\n214,250,260\n204,222,253,266\n0\n7,36\n33\n65,77,90\n56,64,171\n63,80\n62,137\n22\n22,32,61\n38,46,50,306\n173,296\n60,68,75,312\n64\n60,63,78\n2,174\n176,186,357\n180\n180\n0,22\n16,34,52,229\n90\n35,57,66,70,72\n54,56,180\n0,134,137,152,156,167\n10,35\n359\n0\n16\n22,24,26,36,46,56,61,67\n12,178\n22,43,61\n26,57\n1,157\n0,44\n0,8,15,137,153\n0,18,21\n1,5\n12\n13,41\n62,83\n217,239,266,269,277,279,298,312\n0\n0,180\n0,18,42,47,49,73,137,162,179\n0\n0\n0,6,33,45,48,100,102,108,155,158\n153,170,172,180\n180\n0,13,173\n15,49,58,61,96,103\n0\n0\n46,169,191,193,205\n174,179\n24,60,83,180\n180\n42,62,65\n0\n0\n61,297,317,320\n59,65,305\n12,42,44\n0,16,18,20,46\n35,58,60,72,93,154,160,167\n37\n0\n0,3,18,26\n0,83,112,180\n15,166\n0,180\n9,12,18,28,34,193,358\n61,65,97,170,180\n49,76,80\n53,80,82,98,167,180\n51\n35\n66,77\n49,57,80\n14,31,44,62,71,81\n43,70,184,304,308,317\n45,66,138,181,310,339\n75,98,100,154,168\n76,105,163\n18,40,66,309,354\n20,44,60,189,292,311,329\n3,8,17,29,36,47,179\n38,48,180\n54,66,68,180\n68,172,175\n70,131,180\n0,5,9,46\n28,38,47,64,153,184,190,201,318\n26,41,44,47,60,153,172,195,206,210,213,318\n60,180\n0,6,152,155,180\n149,180\n9,13,27,42,90,125,127,167,174,176,180\n0,43,180\n180\n121,151,180\n67,93,124,126,141,158\n141,180\n33\n12,33\n0\n0,180\n16,150,180\n0,24,32,159,163,180\n137,180\n36,95,98,118,233\n2\n0\n6\n0,40,59\n155,180\n0\n152,180\n0\n75,79,88,90\n0\n0,14,24,56\n0\n0,30,80,83,90\n1,38\n62,71,78,114,138,160\n85,101,120\n82,84,102,118\n91,93,96,98,101,114,268,296,299\n113,238,243,249,267,279,294,300\n75,91,93,101,109,133,140,147,283,288,300\n86,99,112,153,160,291,311\n91,134,275,303\n87,117,249,274,284,305\n0\n0,19,42,61,80\n0,22\n6,16\n33\n0,2\n10\n0,180\n33,48,67,128,180\n0,180\n0,26,40,154,180\n0,180\n0\n49,76,107,180\n134,154\n75,180\n0,16,156,163,180\n0,180\n0,19,142,163,172,180\n0,180\n0,161,180\n180\n0,144,149,151,157,180\n180\n50,55,62,70,167,180\n58,75,173\n49\n0,9,23,45\n49,67,179\n48,164\n0,6,50\n60,66,161,168,180\n0\n0,123,180\n1,31,56,88\n0,27\n0,40,124,180\n3,63\n147,180\n180\n0,7\n0\n0,45,57,180\n0,50,72,180\n29,41,143,180\n180\n0,7,58,131,149,180\n180\n160,173,180\n180\n152,179\n157,162,180\n179\n180\n124,163,180\n0,30,34\n0,36\n0\n0\n0\n0,29\n0\n0,33\n46,135,162,180\n0,3,27,51,180\n68,109,143,165,172,176,180\n180\n180\n0,24\n0,32\n179\n0,13,52,180\n177,180\n0,2,39,44,48,148,176\n0,33,43\n0,41,61,120,136\n54,180\n53\n0,52\n0,23,34\n180\n180\n125,129,147,180\n0,55,179\n170\n54\n158,162,180\n157,180\n53,56,128,180\n72,164,318\n73,127,148,169,276,311\n51,58,75,79,96,151,181,342\n63,96,135\n278,301\n300\n312\n312\n258,303,312,343\n276,298\n177,235,289\n177,229,287\n188,204,217,219,289\n187,215,219,293\n179,212,232,272\n177,197,199,230,273,288,290\n55,308\n55,307\n2,26,51,57,324\n21,52,311,323\n5,54,83,315,319\n11,55,90,311,331,350\n52,310\n55,311\n25,46,57,322,336\n58,78\n56,94,308\n3,60,316\n61,322\n1,10,14,18,61\n5,55,323,349,354\n52,55,72,164,178\n61,71,73,146,177,313\n314\n191,292,297,303\n168,190,282,299\n17,19,48,284,312,315\n48,81,283,302,319,358\n34,45\n45,323\n31,46,323\n68,172,284,289,293,299\n65,97,99,173,293,296\n64,66,79,158,180\n299\n298\n297,344\n155,190,287\n158,180,215,285\n184,202,278\n54,312\n55,308\n47,59,315,343\n54,316,350\n64,176\n63,174\n163,290,305,307\n49,313\n47,313\n67,149,170,180,183\n69,155,161,169,171\n174,178,231,282\n145,180,228,286,288,298\n176,232\n176,229,231\n47,310\n49,310\n40,48,314\n45,47\n0,28,107\n15,59,93\n0,61,95,97,103\n0,51,96\n99,143\n64,86,122\n0,15,42,65\n20\n0,18,46,52,60\n14,66\n18,37,64\n12,32,55\n126,167,180\n93,127,159,169,172,178\n129\n125,155,173,178,180\n128,158\n125,152,178,180\n98,129,151,180\n123,143,146,150\n0,26,64,75,94,113,143\n41,51,57,97,144\n1,37\n0,103,147\n98,113\n21,45,68\n22\n13,33,43,51,67\n29,32\n98,122,143,157,167,180\n23,67,85,88,116,120,129\n0,20,61,63,103,125,180\n0,23,25,31,108\n25,74,77,82\n78,107,130,137,180\n87\n18\n19\n15,45\n14,57,59\n128,156\n162\n130,163,180\n1,15,21,51,67,103,112\n65,68,71,74,76,93,117,145\n0,119\n0,16,52,89,118\n0,177\n180\n180\n0,100,122,128,137\n7,37\n9,120,339\n117,334,355\n80,107\n92,111,124,126,146,179\n283,303\n285,303\n305\n289,304\n15,49,65,298,328,347\n19,50,68,296,328,348\n6,13,34,66,315,333,349,355,357\n1,6,17,66,317,327\n23,42,334,351\n2,14,16,28,36,45,49,326,353\n18,41,49,69,347\n18,47,342\n3,18,68,332\n1,10,12,30,37,341,354\n342\n183,202,216,248,278,280\n180,208,229,231,251,253,257,289\n218,221,252\n179,209,241,259\n117,225,353\n121,219,347,355,357\n114,140\n107,109,128,146\n302\n302\n0,2,17,36,40,46,337,347,351\n17,48,54,330,334,350\n16,43,48,333,346\n15,23,46,338\n9,116\n116\n162,194,244,262\n182,219,225,233,239,248,263\n328,343,349,358\n328,353\n0,90\n90\n0,96\n0,83\n90\n0,90\n14,30,66\n0,17,69\n111,163\n112,149,180\n0,11,29,42,82,90\n0,16,58,89\n62,90\n0,44,66\n113,131,136,148,180\n0\n180\n0,40,180\n79,97,263,281\n1\n0,180\n40,45,64\n15,38,170\n18,39,61,79,90\n1,41,76,90\n3,11,41,65,85,100\n42,49,79\n142\n86,103\n107\n17,43,62,127\n84,90\n0,58,93,134\n0,59,72,77,180\n138,165,176,180\n0,23,30,33,56,59,86,97\n138,180\n0,3,6,30,72,104,120,144,180\n1,26,50,99\n36,76,106\n15,74,90,92,137\n126,149,157,171\n63,302\n63,305\n60\n61\n0,89\n0,3,20,77,90\n0,4,27,29,90\n62,90\n29,47\n34,90\n63,90\n0,11,80\n11,13,42,46,52,101\n90\n42,81,90\n87\n106,143\n24,44,55,57\n0,21,102\n57,180\n17,20,25,40\n15,61,299\n44,63,295,349\n180\n180\n0,27,29,37,178,180\n0,180\n0\n0\n71,190,297\n189,297\n70,185,271,289\n59,292\n48,71,269,295,312\n71,178,200\n73,142,179,201\n71,151,184\n67,150,155,161,177\n75,142,181\n78,144,180\n182,198,293,299\n54,300\n64,66,308\n165\n34,41,61,68,78,83,102,128,130,158,180\n0,22,28,55,60,82,84,97\n136,166\n0,3,15,29,53,76,78,80,88,90\n0,63,65,90\n0,45,56,58,86,113\n9,77\n0,90\n0,76,81,84\n10,26,28,36,40\n120,151,180\n128,157\n1,9,33,53,61,90\n0,47,79,105,126\n62,79,90\n0,40,65\n118,147,180\n0,26,118,165\n15,90,103,110,123,135,156,179\n0,24,39\n37\n19,133,156,165\n4,46\n0,26,34,42\n0,81,111,125,154\n26,45,48,109,127,165,178\n1,33\n143,180\n126,153\n0,96\n96,109,159,166,180\n106\n123,147\n94,106\n88,91,95,106,111\n46,72,174\n0,32,51,180\n41,49,60,310\n16,50,52,83,311\n63,73,148,168,181,246,293\n54,62,73,80,82,145,166,177,300\n292\n37,53,308\n26,56\n67,82,86,94,98,125,128,144\n23,47,58,60,317,337,343\n72,140,159,179,286,306\n62,155,160,304\n12,24,27,31,58,76,327\n17,38,76,318\n0,41,87\n0,34,43,53,77,92,94,101\n37,64,68\n0,15,27\n85,89\n23,43,75,99\n80,89\n16,100,173\n0,49,51,57,66,68,90\n2,97\n2,52,90\n12,42,90\n0,66,87,102\n68,90\n118,138,157,161,170\n103,125,155,158,180\n103,133,135,138,155,158,180\n65,97,109,112,114\n0,20,41,63,180\n90\n58,90\n90\n52\n97,133,159,187,190,287\n75,168,191,287\n68,133,180\n72,74,181\n67,77,99\n52,61,180\n47,49,69,77,85\n97,110\n0,19,29,84,90\n97\n52,180\n152,180\n158,181,188,193,273,295\n65,297\n71,179\n69,178\n70,72,158,185\n79,166,186,188,190\n5,220,245\n302\n300\n70,178\n69,89,177\n54,180\n69,178\n70,109,112,138,185\n90\n97\n90\n100,120\n114\n70,189,297\n66,191,220,292\n69,177,207\n69,177\n78,82,180\n68,70,183\n70,122,186\n63,89\n27,77,80,101\n90\n0,52,60,88\n90\n13,65\n65\n41,60\n58,92,190,205,227,242,292\n60,292\n60,290\n56,100,289,316\n179\n179\n77,183\n182\n193,285\n88\n71,90\n0,25,33,36,53,180\n48\n35,56\n34,57,168\n51\n76,81,91,110,182,303\n87,113,181,306\n180\n52,87,150,174\n180\n247,293,311,313,315\n249,293\n292\n289\n0,55,300\n8,11,55,302\n55\n6,55\n0,16,61,111,119,125\n58,79,165,180\n44,58,73,90\n21,94,97\n29,42,45,48,82\n2,14,30,35,78,87,102,105\n31,68,76,90\n90\n0,86\n180\n180\n185\n185\n59\n291\n290\n246,293\n248,295\n292\n292\n42,55\n0,5\n0,138,155,180\n0\n138,140,142,145,154,156,173\n0\n63,186,294\n65,184,293\n69,293\n67,190,210,291\n59,96\n57,80,300,333\n60,300\n69,175\n68,176\n66,162,177,180,187,191,292\n70,161,180\n55,66,80,82,180\n0\n0\n0\n0\n180\n167\n180\n177\n0\n0\n180\n180\n0\n0\n180\n168\n0\n180\n0,180\n0,180\n180\n180\n0,80,127,133,138,180\n8,39,46,49,68,78,120,146\n113,141,169,172\n120,137,169,176,178,180\n1,67,89,91,94,108,145,155,157,167,180\n57,180\n180\n35,45,58,307\n29,59,305\n56,312\n27,57,304,323\n180\n45,65,296\n0,180\n0,27,32,58\n180\n0,22,26,65\n70,106,157,161,299\n70,146,149,301\n63,65,87,91,93,122,169\n70,93,95,121,132\n63,65,81,108,143\n96,114,144\n256,298\n262,300,305,332\n60,90\n60,92\n61\n59\n178,296\n178,299\n179,198,201,247,291\n181,211,237,253,296\n180,264\n71,73,119,127,129,132,136,143,146,299\n69,133,154,298\n63\n63\n283\n40,59,63,73,76,88,97,101,139,308\n55,75,124\n151,188,196,199,202,219,271,278,280,317\n193,217,252,257,286\n0,180\n0,23,180\n0,55,96,120,137,144,180\n0,5,13,15,25,45,49,53,79,104,143\n14,37,53,88,108,110,121,136,171,180\n0\n1\n0\n0\n358\n0\n46,310\n71,87,101,124,151,223,245,263,270\n0,10,13,20,27,54,306,333,340,347,350\n78,97,263,282\n71,85,98\n34,51,76,94\n44,60,88,137\n0,176\n0\n0,23,173,178,330\n0\n182\n46,53,67,174,304\n180\n136,145,171,177,181,224\n0\n0\n0,16\n0,64,94,121,141,152,155,157,162,166,171\n0,9,40,171,180\n92,115,128\n183,358\n19,34,47,307,311,315,329,354\n7,11,14,355\n173,180\n10,29,158,180\n0\n0,180\n0,27,31\n0,180\n0,180\n180\n6,180\n0,180\n0,180\n1,15,73,81,93,95,101,111,131\n4,132,149,333,339,346\n0,110,135,145,265,356\n0,43,64,83\n0,36,58,92,109\n90\n0,17,36,71\n111,142,163\n26,97,112,136,143\n0,122\n3,8,25,28,102,113,123,141\n0,13,32\n137,139\n113,130,180\n123,127,149,169\n66,90,115,118,124,127,140\n0,34,79,100\n89,120,124,128\n93,123,136\n110,126,153\n57,180\n49,52,61,63,180\n35,44,56,172,174\n180\n159\n55,180\n65,175,292,303,308\n67,172,295,306\n62,187,331\n56,305,330\n54,303\n56,314,317\n56,293,310\n177,299\n172,196,275,293\n37,62,66,169,302\n61,176,299\n57,307\n57,305\n0,170\n0,102\n0,32,55,180\n0,5,13\n180\n180\n180\n173\n0,36\n0,178,180\n180\n180\n0,73,88,97,100,104,112,123,127,130\n5,9,41,47,51,84,113\n0,20,47,51,57,69,100\n134,151,180\n128,151,180\n131,179\n94,124,163,173,179\n0,19,22,52,55,108,121,146,149,151\n0,50,104\n0,85,97,105\n106,153\n150\n3,116\n0\n0\n0,115\n180\n180\n180\n180\n0,180\n0,179\n215,241,260,262\n193,213,234,244\n4,117,135,202,240\n2,101,130,164,197,205,235\n12,205,228,237,239,353\n1,211,218,220,223,242,342\n31,54,80\n31,57\n31,56\n94,108,112,114,135,177,179,182\n74,77,107,122,128,138,176\n102,141\n108,144,147,150\n81,105,139,164\n93,110,113,140\n101,111,114,144\n89,108,123,144,167\n60,185,297\n62,187,222,297\n41,47,53,72,171,184,190,203,213,221,229,240,284,305\n43,60,66,69,183,191,200,281,296,304\n47,56,60,184,202,258,268,295\n40,195,205,228,258,294\n227,274,280,286\n25,28,57,91\n20,23,58\n60\n62,88\n57\n64\n53,304\n52,304\n301\n1,10,34,60,304,330\n49,279,308\n278,306,326\n67,132,149,176\n69,177\n73,123,176,202\n72,124,128,149,176\n67,117,181\n44,66,108,180\n96,112\n74,100,121,144,154,169,178,181\n46,73,164,184\n64,81,183,297\n67,188,296,340\n48\n47\n52,307\n53,307\n49,74,87,91,153,170,196\n74,95,139,167,170,193\n38,72,168\n62,182,274,297\n60,182,297\n304\n50,305\n305\n50,304,352\n71,73,171\n50,72,176,200\n77,149,172\n63,180,285,298\n0,5,42,76,99,134,180\n23,61,70,101,180\n45\n164,180\n159,180\n159,180\n164\n64,68,180\n47,49,65,72,105,180\n66,75,88,100,103,161,170,175,180\n165,178\n158\n0\n0\n90\n0,18,22,28,90\n0,8,11,28,30,36,57,69,77,85\n90\n0,18\n0,20\n180\n112,162\n0,33,37,77,85,90\n0,105\n90\n0,30\n114,143,180\n0,119\n0\n0,41,43,116,180\n180\n0,4,7,27,47,67,94,121,157,159\n0\n0\n15\n0\n1,17\n13\n0,5\n162,173,180\n138,167,172\n107,149,180\n0,50,53,103\n16,25,89,112,115,136,146,153,157,179\n0\n0,27,66\n0\n11,78\n157,176,180\n1,6,92,123,127,171\n0,32,111,131,134\n0\n0\n0,18\n180\n180\n107,110,135\n0\n0\n0\n142,176\n14,83,87,113,124,147,169,180\n0,14,25\n122,165\n166\n0\n180\n0,37\n14,28,49\n1,21\n1,8,21,43,46,52\n180\n180\n42\n9,45\n0,5,22,46,49\n85,129,177\n84,105,112,116,148\n78,111,151,172\n95,140,176\n102,135\n265,271,278,298,320,324\n312\n62,304\n61,303,326\n15,23,33,62,308\n19,27,43,62,92,318,321,344\n59\n35,39,58,350,353\n133,174,176,185,218,233,289\n151,153,172,178,239,278,282,284,287\n138,176,261\n133,152,172,187,192,276\n79,108,116,162,296\n72,79,88,91,116,164,297\n27,63,103,305,329,350\n29,61,305,343\n56\n58,105\n159,186,196,226,260,267,281\n152,190,193,258,279\n75,101,126,133,139,155\n70,93,103,143,152,159\n150,171,194,263,288\n182,271\n49,308,323,326\n52,92,322\n48,80,314,317\n47,75,84,86,315\n46,320\n186,247,289,292\n175,192,198,252,270,289\n72,78,93,159\n76,78,141,163\n51,315\n16,25,52,314,325\n181,277,281,284,288,290\n176,192,279\n180\n0,154\n357\n0,10,13,15,29,32,36,67,116,129,132,153\n48,310\n0,180\n0\n16,20,27,37,40,54,56,70,103,105,115,128\n23,42,64,80,83,90\n0,5,33,63,90\n131,155\n47,54,90\n2,5,23\n180\n117,156,167,173,180\n0,24\n0,20\n0\n0,10,20\n22,33,38,335\n76,92,111\n0\n60,77,148,180\n93,135\n187,296\n71,181,294\n67,169,186,296\n289,291\n53,188,211,214,302\n180\n169,180\n1,14,180\n67,186\n65,152,183\n62,76,96,115,171\n77,80,88\n33,80\n84\n156\n68,81,83,85,93,116\n67,92,103,111,131,157\n25\n77,80,103\n0,2,9,11,19,21\n97,102,111,130,150\n296\n296\n49,172\n50,173\n46,190,291\n48,188,289,291\n49,185,291\n42,160,183,292\n40,289,309\n34\n0,18,37,55,61,63,68,90\n11,14,31,34,58,79,164,177,180\n75\n0,12,18,23,25\n147,172,176,180\n22,36,48,61,76,78,80,95,169\n59,95,109,126,144,148,172\n0\n50,61,68,92,104\n54,103,127,133,136,139,149,154,156\n45,85,355\n81,103,126,147,160\n89,109,132,151\n21,36,40,59,86,90\n0,8,13,22,43,54,69,73,75,93,95,134,143\n62,64,89\n15,20,39,48,90\n0,5,9,12,18,40,59,68,72,96\n51,90\n72\n12,43,73\n105,160,180\n109,142,170,180\n57,59,63,94,119\n0,10,40\n0,35\n40,59,312\n43,61,311\n20,29,41,54,91,325,344,358\n177\n0,3,6,10,30,44\n0,92\n0,33,95\n47,58,295\n62,181,280,299\n58,70,225\n61,171,190\n0\n0\n1\n0\n0,180\n0\n1\n55,59,297,311\n80,112,118\n64,74,290\n79,99,102,296\n0\n0\n63,189,294\n63,185,295\n186,293\n0\n351\n12,29,67\n116,160\n12\n0,16\n65,90\n0,180\n0\n0\n180\n141,170,180\n0\n180\n0,123,179\n359\n358\n85\n67,69,87\n1\n56,167\n54,66,166\n28,48,139,163,172,180\n180\n0,4,7,39,61,64,81,129,147,149,157,170,178,180\n47,49,58,63,328\n60,318,324,332\n0,180\n0,59\n0,180\n0\n0,180\n0\n0,43,146,180\n0,180\n0\n0,180\n1,180\n0\n0,180\n13,19,31,33,38,61,79,109,129,155,160,168,174,180\n0,13,180\n0,17,101,119,136\n158,160,162,180\n64,189,294,304\n69,183,304\n54,304\n54,303,327\n43,61,78,164,178\n62,72,78,163,185\n51,306\n46,50,306\n0,2,8,18,47,67,83,95,125,160,165,168,170,174,180\n0,33,56,88,110\n49,54,56,63,66,93,103,121,138,157,177\n68,108,128,174,180\n64,92,102,133,155,157,180\n59,90,101,110,116\n9,24,62\n118,167,170,180\n49,52,180\n90\n104,135,171,177,180\n180\n180\n90\n26,37,53\n73,99,110\n33,36,40,58\n41,54,56,81,84,90\n0,20,54,75,81,94,112\n106,145,168\n61,281,306\n60,282,305\n62,306\n61,305\n290,310\n291,310\n59,306,333\n0\n0\n0\n0,180\n0\n157,178,180\n180\n0,56,58,180\n0\n126,180\n0,180\n0\n0\n179\n0,2,177,179\n0\n167,172,177,180\n0,44\n0,63,69,180\n0\n0,24\n0\n0,10,17,32,66,163,165,180\n11,26\n0,56,150,179\n0,21,24,123,135,180\n152,156,180\n0,18,136\n0,19,54,67,69,72,74,90\n0\n180\n0,169\n0,45,87,105\n121,148,164,166\n102,108\n0,13,99,116\n9,30,44,79,98,128,137,146,156,180\n0,41,43,78,83,107,109\n0,33,35,37,52,81,84,92,130,180\n10,59,68,91,95,101,107,110\n13,57\n180\n59,304\n58,304\n0,47\n4,19,29,180\n0,4,27,50,55,77\n0,38,57\n0,38,78\n0,180\n0,21,28,36\n0\n0,33,35,38\n0,3,9,36,38,63,66,90\n0,27,45\n151,180\n90\n69,90\n0,155,180\n70,89\n27,59\n62,83\n74,91,97,117\n75,77,79,96\n89\n75,97\n0,54,76,82\n79,92,100,119,150,180\n40,52,72,83,101,127\n68,83,106,120,155\n71,83,88,119,122,139,173,180\n85,97,113,118\n2,7,9,18,22,89,95\n110,125,155,159,161,164,167\n44,81,111,117,142,146,159,180\n39,54,91,129\n193,205,262,270,290,296\n191,289,291\n70,181,202\n62,151,180\n182,195,300\n185,191,195,296\n0\n0,47,115,180\n0,31,57,81,90\n0,3,35,53,55\n17,45,55,128\n50,57\n0,180\n180\n4,180\n0\n0\n0,28,52,90\n180\n0\n0,180\n0\n0\n0,21,145,163,166,180\n0,27,34,70,129,134\n0\n180\n7\n8\n128,132,180\n180\n180\n162,179\n142,158,170\n9\n180\n180\n180\n180\n0,18,21,52,59,65,154\n0\n180\n180\n67,90,93,138,172,180\n0,49,129,151,170,180\n91,180\n0,22\n163,165,180\n119,167\n79,104,108,111,125,130,134,292\n64,92,119,150\n293\n40,59,84\n46,317,327\n29,48,322,336,339\n62,124,157,176,211\n54,317,345\n52,315\n53,304,340\n70,98,104,137,155\n0\n180\n1\n0\n1,33,55,64,67\n36,67,71,180\n0,180\n76,194,283,298\n188,299\n19,38,54,61,126,144,159,163\n180\n13,34,39,62,95,119,159,170\n180\n163,180\n0\n0,19\n0,180\n153,180\n0,180\n180\n180\n0,46,68,89,92,107,137,140,152,180\n44,62,125,130,136\n0,7,61,64,84,99,116,146,162,180\n82,87,115\n68,305\n180\n180\n0\n0,162,180\n173,182,188\n0,180\n0,3\n18,87,100,106,142\n0,4,7,10,13,16,74,77,82,84,90,98,109,115,132\n105,165,200\n100,170,201\n16\n0,5,169,180\n0,5,9,14,165,168,170,176,178\n180\n0\n21,27,30,53,65\n1,59\n180\n0,120,180\n0,180\n180\n0,180\n145,180\n1,154,180\n0,162,180\n180\n1,180\n163,180\n0,173,180\n0,180\n0,178\n180\n69,91,121,163\n0,2,5,24\n170\n0,156,180\n23,148,180\n89,91\n0,16,149,175\n0\n0,90\n0\n0,26\n136,164,166,176\n0,40,87,90,147,180\n0,35,65,68,89,92\n125,127,155,180\n75,94,103,109,112\n173\n180\n0,91,116\n180\n42,51,53,58,136,143\n0,180\n11,22,30,160\n21,27,33,36,73,90\n0,55\n17,27,38,46,68,90\n0,2,55,65,75\n0,10,20,164,180\n3,180\n0,180\n0,96,180\n0,14,177,180\n0,4,175,179\n0,180\n0,180\n0,180\n0\n180\n0,180\n180\n180\n0,44,109,114,154,174\n111,144,162,164,180\n5,59,62,67,97\n180\n0,180\n0\n180\n145,152,166,168\n0,180\n142,180\n0,17,180\n0\n0,176,180\n59,93\n56,100,102,150,180\n0,99,134\n110,116,123,158,162,169,178\n0\n0\n0\n0\n0,12,15,40,180\n180\n0\n0,16,54\n180\n180\n0\n180\n0,31\n0,8,25,45,131,161,163,167,180\n0,180\n0,23,35,68,88,109\n0,8,24\n0\n0,180\n0,25,41\n0\n2,10,25,143\n0\n165,180\n180\n0,31,180\n0,180\n0,180\n0,180\n0,180\n13,82,108,110,115,119,126,141,144\n55,90\n3,52,73,111,139\n37,88\n13,59\n120,165\n135,156,160\n0,6,57,96,104,109,122,128,134,139,149,153\n0,94,115,128,131,138\n11\n0,16,34,66\n126,151\n128,161\n0,119,121\n128,141,164,180\n2,15\n1,10,50\n58,180\n180\n56\n63,170\n14,56,303,320,354\n3,29,55,303\n56,300\n36,57,301\n176,180,192,194,269,271,279,293,323\n179,182,293\n63,176,291,301\n59,178,299\n305\n3,9,15,35,39,54,76,307,336\n54,77,309,322\n176,200,260,288,310\n59,168,287\n62,161\n0,180\n0\n0,156,168,179\n0\n0,180\n0,27,62\n0,21,35,152,180\n6,59,180\n0\n10\n180\n180\n180\n180\n54,63,66,133,169,180\n0,18,34,38,40\n180\n0,97,117\n0,23,35,90,117\n80,109,150\n83,102,127\n19,30,71\n130,178,180\n110,112,119,150\n91,136,152,176\n125,138,141,179\n8,39,63,85,117\n0,7,14,67,89,108\n55,90\n0,11,35,73\n18,47,75\n160\n0,25,38,69,106,120,122,145,148,151,157,161\n0,21,75,78,83,95,105\n169,180\n0,5,10,13,137,151\n9,12\n0,25\n180\n180\n180\n0,151,154,166,180\n0\n180\n19,34,37,48,119,127,144,147,152,155,167,180\n0,180\n0\n131,158,180\n180\n210,216,238,243,256\n124,127,208,233,358\n0,128,130,210,232\n32,55\n30,56,78\n56\n57\n20,345,349\n23,350\n110,115,133,144,156,162,171\n128,133,144,170,175,189\n111,142,159,179\n75,90,108,128,146,160\n1,13,101,114,238,241,245\n62,185,298\n58,188,298\n191,196,198,223,296\n54,70,194,197,213,216,241,298\n188,191,215,226,232,242,287,299\n180,190,197,290,297\n58,82\n59\n38,59\n49,54,60\n5,53,305,347\n6,53,306,340\n55,304,320,322\n51,309,327\n44,304\n45,52,58,303\n70,180\n70,179\n66,104,181\n102,180\n71,114,123,130,178\n66,79,82,171,173,177\n62,184,295\n61,83,188,297\n137,163,166,199,296\n202,221,297,305\n17,47,312\n50,310\n83,171\n88,173\n91,157,179\n53,56,191,297\n57,189,193,269,294\n63\n13,52,281,305\n51,278,306\n50,307\n40,260,310,327\n73,174\n77,173\n53,68,184,294\n68,178,196,300\n49,312\n51,309\n0,16,18,27,31,39,51,75,114,180\n16,18,43,47,54,57,84,99\n0,54,56,91\n80,180\n114,164\n154\n25,59,72,74,142,180\n0,69,76,78,100\n0,50,55,70,75,90,92\n59,73,79,148,154,180\n0,16,19,29,33,62\n19,23,27,37,65\n128,162\n160\n162,180\n156\n29,74,92\n72,108,114,128,135,162,180\n0,56,62,66,87\n50,73,94,96,151,154,180\n75,92,103,170,180\n21,39,41,64\n19,29,49,63\n130,132,137,139,141,167\n134,164\n157\n53,57,59,81,84,86,90,93,95,107,113,119,126,130,168,170,173,175\n0,2,5,9,29,62,78,90\n72,88,91,180\n77,101\n0,37\n0,41\n2,16,44,73,90\n8,58,90\n2,66,119\n90\n6\n0,40\n180\n143,180\n180\n110,135,152,180\n0\n0,42\n0\n0\n0,31,36,92,123\n0,5,16,33,35,73\n0,78\n0,44,90\n2,14,30\n0,12,43,50,53,56,66\n0,17,49\n0,26\n162,180\n117,156,179\n0,31,33\n0,108,146\n47\n0,27,90\n1,29\n0,29\n123,154,180\n0\n0,180\n0,56,59,61,63,73,131,180\n0\n12\n9,11,17,19,21,54\n180\n0,53,80,122,180\n0\n0,39\n0,177,180\n180\n21,27,29,180\n0\n1\n180\n126,141,180\n0,20\n138,175,180\n21,51,75,97,116,139,159,180\n0,18\n35,42,46,62,112,144,163\n19,50,180\n0,4,6,43,47,49\n14,24,34,180\n29\n43,62\n0,6,23,28,33,38,48,179\n0,13,24,40,43,54,76\n41\n19,40\n90,124\n84,89,103,119,126,150\n2,62,295\n30,60,93,293\n1,26,28,40,66,68,325,344,351,356\n20,28,40,67,321,338,340,355\n38,57\n59,61,63,67,70,100,119,173\n67,174\n86,152\n85,90,103,106,132,150\n62,301\n63\n26,46,330,351,353\n26,49,326,332,334\n89,105,127\n71,83,86,90,103,106,115,135\n173,289\n172,190,193\n37,41,45,314\n71,77,84,152,155\n51,303\n29,32,35,53,337\n46,84,315,322\n13,52,82,326\n73,173\n75,108,167\n47,312,336\n6,50,76,96,313,316,328\n72,87,94,119,144\n69,125,128,157\n0,33,44,48\n0,55\n134,175,180\n180\n0\n0\n0,156,180\n0,6,20,74,97,123,148,154,162\n180\n0\n0\n9,13,15,170\n1,10,13,19,26\n41,180\n29,33,37,55,68,90\n90\n1,26,52,180\n65,90\n79,105,145,166\n180\n58\n162,180\n78,101,113,123,137\n0,22,56\n0,38,57,82\n0,6,28,35,43,60,82\n48,180\n53,78,90\n87,89\n0,93,160\n78,144,178\n0,44,76\n93\n94,108,122,127,157\n24,55\n30,59\n102\n100,102,105,180\n0,14,43,81\n0,38,151,180\n55,79,81,90\n86,90\n0,22,80\n16,54,56,62,64,89\n0,27,29,100\n62,82\n90\n117,119,132,159,167,180\n32,69\n14,42,90\n1,21,38,95\n82\n4,7,28,30,32,65,67\n69,86,119,309\n69,115,304\n176,204,290,310\n150,176,247,292,309\n59,306\n59,301\n43,46,62,65,93\n61,94\n60\n60\n69\n67,80,83,142\n51,80,280,284,313\n52,286,313\n60,83,86,89,154,166,241,250,253,279,282\n66,68,84,132,152,154,161,170,245,282\n312\n112,138,161,200,278\n113,160,201,280\n59,302\n59,302\n68,87,114,120,129,156,268,274,276,284,292,294,300\n71,90,111,119,123,162,269,273,289,295\n278,315\n278,314\n62,91,285\n35,41,47,75,101,103,293,295\n78,123,138,270\n78,98,271,300\n0\n0\n0,8\n104,125\n12,16,24,40,74,327,355\n9,43,75,328,353\n123\n117,136,324\n36,72,324,359\n38,327,357\n180\n141,169,179\n13,15,35,41,90\n0,25,30,103\n86\n90\n86\n90\n15,60\n15,71\n110,165\n85,103,132\n150\n127\n57,173,175,180\n10,55,303,321,358\n19,55,304,359\n16,57,92,309,338,356\n63,176\n56,71,302\n180\n180\n0\n167,180\n0,5\n154,180\n67,189,226,298\n68,191,222,226,282,289,300\n206,299\n208,299\n56,58\n62\n57\n57\n2,53,305,353,358\n55,304,339\n72,179\n179\n61,186,207,296\n62,186,279,288,300\n45,313\n92,173\n185,299\n54,304,342\n304,343\n81,97,129,137,169\n75,95\n14\n0,4,29,173,176,180\n0,4,9,36,53,59,81\n40,51,89,110\n77,85\n124,146,155,167,177,179\n0\n23,64,90\n59,180\n57,306\n57,75,82,304\n177\n77,144,156,177\n52,180\n3,8,17,40,45,58\n180\n180\n56,180\n56,314\n56\n48,305\n48,284\n0,9,83,85,90,100,105,119\n52,91,113,119\n24,49,55,62\n0,9,70\n98,117,135\n123,151\n90,112,151\n87,96,108,129\n93\n29,57,78\n0,6,13,51,102,133,137\n10,27,41,43,69,71,101\n87\n91\n0,8,35,78,84,88,97,159,164\n0,31,38,42,93,102,109\n91,109,111,158\n58,105\n0,10,20,41\n0,35,331,354,357\n29,329,348\n85,88\n0,18,95\n90\n6,23,46,80\n106,141\n1,23,25,35,41,90\n0,6,105\n1,33\n0\n0\n0,180\n1,21,27,87,89,153,155,179\n90\n13,33,171,178\n62,66,69,86,89\n0\n0,180\n0,2,6,171,180\n25,32,41\n63,74,87,90\n0\n180\n0\n0\n357\n359\n0\n180\n0,21\n0,22\n0,31\n33,38,41\n79,284\n78,283\n0\n53,70,81,137,169\n36,53,75,84,92,126\n164\n0,41,54\n180\n0,40,58,60,180\n79,96,102,105,170\n93,96,159,165\n46,281,299,308,312,314\n49,280,303,305\n0\n180\n0\n180\n0\n180\n0,180\n0\n180\n0,2,6\n0\n0,27\n0,37,52,54,56,110,125\n118\n180\n105,142,164,167,180\n0,8,10,43,57,78,102,180\n0,29,39,43,89\n180\n40,180\n0,22,32,42,161,180\n180\n180\n80,96\n192,216,227,237,241,245,256,259\n2,34\n24,45,63,77\n27,37,71,90\n57,61,90\n99,130,151\n91,111,134\n17,36,54\n89,109,125,128\n2,30\n20\n0,35,54,143\n0,21,23,33\n80,120,133,147\n61,97,123,128,164,302,307,313\n88,94,100,104,120,126\n94,109,119,133,139\n56,93,306\n60,92\n85,105,115,141,168\n74,102,124,147,163,296,301\n79,97,102,108,146,161,164,167\n95,108,111,118,125,144,157,176\n106,136\n84,101\n75,79,109,127,141\n52,76,113,142,178\n153,172\n112,152,161,167\n91,144\n64\n95,118,162\n109,135,157,180\n89,150,164,180\n89,91,114,124,152,180\n68,73,75,92,107,119,168\n86,125,148,180\n96,118,133,151,157,161\n108,119,131,142,152,170,180\n96,141,162\n0\n114,153\n1,17\n64,90\n104,111,121,140,157,159,180\n255\n97,256\n0,50\n1,11,15,19,47,52,56,119\n63,68,90\n2,12,33,46,60\n0,45,77\n0,7,11,13,35,42,59,62,91\n90\n100,117,180\n0,22,180\n81,88,91,106,138,155,157\n91,107,118,147\n91,100,130,151\n21,52,94\n10\n108,110,157\n106,128,140,142\n10,51\n87,115\n88,102,121,211,214,216,231,236,245,248\n81,96,223,246,249\n108,221,238,263,279\n0,4,18,25,47\n0,55,66,68,88,116,118,121,146,180\n0,15,24,35,46,52,64,100\n46\n145\n64,181,199,298\n45,59,179,187,190,193,297,313\n0,6,180\n0\n180\n158,180\n0,12,78,89,102,106,114,121,136,174\n0\n145,180\n0,150,157,169\n0\n148,180\n0,3,35,59,98,102,106,110,114,135,148\n0,27,29,33,57,100,160,174,180\n0,116\n37,310\n28,33,39,58,308\n2,24\n61,182\n98\n85\n53,66,185,188,194,295\n57,80,87,110\n61,63,69,79,111,129\n0,24,66,76,88,116\n61,66,92\n0\n36,39,57,161,180\n0,35,45\n70,90\n0,22,34,37,42,60\n69,87,89,114,127\n54,61,74,101,143\n58,75,188,300\n78,184,300\n0,10,81\n1,180\n0,177\n0\n0\n0,160,170,176\n53,64,177\n0,179\n0\n3,12\n2\n0,103,180\n152,166,172,180\n14,52,62,108,173,178,180\n0\n0\n180\n160,180\n0\n154,173\n0,24,31,87\n0\n0,178\n180\n180\n0,180\n171,180\n0,145,176,180\n0,177,180\n0,24,157,180\n0,180\n16,38,61,85,88,91,99,130,158,175,180\n15,41,49,57,79,87,105,107,130,152,154,180\n0,2,169\n2\n0,154,168\n0,7,180\n34,51,79,88,94,121,160,164,173,303\n25,30,36,67,89,118,156,173,290,312\n58,330,333\n59,326\n0,5,135,153\n0\n0,180\n65,182,184,296\n66,187,204,295,325\n59,75,303\n58,303,338\n66,176\n66,86,93,164,180\n188,296\n295\n54,306\n62,145,151,179\n0\n0,174,180\n72,82,90\n87\n59,90,107\n35,64\n72,103\n62,296\n297\n180\n0,72,98\n150,157,180\n0\n0\n0\n0\n180\n180\n180\n180\n0\n0\n180\n180\n0\n0\n180\n170\n0\n180\n0\n0\n0\n223,227,247,269\n257,277,280\n74,143\n274,282,289\n288\n287\n0\n0,25,38,43,46,122,127,140,175,180\n180\n180\n0,38,48,88,180\n26,64,66,71,73,135\n113,152,173,176,180\n103,151,179\n10,27,41,56,70,148,168\n109,147,153,175\n0,180\n11,52,76,144,150,180\n41,61,66,77,79,93,119,168\n58,308\n57,354\n189,212,293\n192,292\n0\n174,191\n67,174,192\n65,71,190,289\n189,196,289\n61,305\n0,177\n90\n90,110\n0\n5,31,65,100\n85,118\n100,126\n103,109,118\n58,72,298,351\n39,45,55,75,115,302,307,313,350\n25,76,114,294,358\n76,111\n0,3,20,23,42,45,48\n170,180\n61,297,300,303\n45,60,75,299,317\n53,100,132,161\n53,82,124,144,169\n66\n12,65,307\n180\n0,180\n0,180\n0,180\n0,163,171,180\n5,8,15,17,20,23,31,39,55,65,75,113,123,127,155,176,179\n0,125\n72,74,84,88,90,140,148,163,180\n53,76,80,84,88,92,116,135\n53,66,86,140\n19,61\n62,187,298\n61,184,297,301\n53,64,300\n58,301\n66,68,137,176,192\n68,177\n67,190,192,303\n64,185,300\n53,306\n58,303\n0,180\n0\n109,154,180\n0,2,156,161,163,171,179\n1,39,56,85,99,101,123,126,180\n115,180\n0\n0\n0,22\n0\n0,64\n180\n180\n0\n180\n14\n70,125,180\n175\n161,180\n180\n114,143,153,180\n87,120,145\n180\n180\n94,106,141\n72,94,116,130,136,151,163,165,298,300\n71,105,126,140,149,297\n44,61,300\n59,63,306,317\n176,265,287\n175,193,275,295\n73,140,163,295\n68,74,121,147,299\n43,62,80\n53,68,85,308\n43,90,308,322\n47,81,311,328\n111,113,115,166\n0\n286\n273,290,307,331\n308\n302\n54,298,300,304\n70\n180\n180\n56,70,291,303\n61,174,297\n0,8,180\n0\n14,26,50,55,70,76,94,96,99,160,180\n98,134\n0,180\n28,180\n0,11,34,112\n0,40,44,74,84,101,179\n10,19,55,67,72,76,83,96\n0,25,30,59\n222,233,259,315,332\n25,220,276\n21,31,217,248,268\n249,270\n218,260,273,275\n33,49,279\n0\n0\n1\n0,2\n0\n0\n1\n180\n0,180\n1,167,174,176\n0,180\n2,6,29,77\n0,14\n0\n21,160\n0,180\n2,17,29\n0,180\n0,123,180\n0,25,29,38,85,116,158\n38\n180\n4,180\n0,180\n0,5,11,14,94,110,133\n0,25,27,31,44,47,88,114,128,132,154\n0,21,59,99,101,104,158,160\n136,180\n0,33,180\n0\n128,132,144,180\n0,8,10,164,171,177\n0,179\n0,159,164,180\n0,2,180\n180\n0,17,24,180\n2\n0\n0\n0\n74,94,138\n12,39,62,69,72,91\n43,78,109,111,125,178,180\n90,114,146,170\n74\n0\n0\n0,11,13,60,65,80,90\n0,10,50,57,78\n0,174,180\n1,15,17,52,180\n3,15\n8,180\n0\n1,24\n0\n180\n0\n22,94,135,154,180\n67,81,91,95,112,130,172,180\n35,145,167,180\n0,180\n0\n0\n180\n26,28,141,144,148,159,161,172,175\n0,23,147,150,156,180\n0,180\n0,180\n54,90,124,149,180\n0,35,54,134,153,171,174,177\n0\n0,180\n0\n0\n0\n0,3,25,180\n0,9\n0,23,30\n58,81,87,114,123,133\n168,180\n0\n0,180\n0,179\n0\n3,7,9,180\n0\n152,166,180\n180\n128,138,155,169,174\n146\n311,318,326,350\n284,312,326,352\n59\n63,67,83,206\n56,66,85,96,205,229\n29,309,333,341,359\n287,313,322,353,358\n4,10,16,30,33,65,338,358\n20,50,68,358\n219,272,326\n224,272,314,316,318,328\n79,201\n48,66\n168,180,198\n85,197\n157,179,191,208,213\n68,77,177,202\n224,271,286,303,323\n284,308\n269,281,290,302,327,345\n224,278,319,321\n58\n0,11,24,51\n7,30,83,88,90\n10,12,37,59,75\n9,96,154,158,166,168,171\n0,66,73,77,89\n59,180\n180\n136,180\n60,123,177,180\n61,180\n56,71,163,180\n49,180\n50\n53,58,178\n180\n60,180\n180\n48,51,174,180\n59,76,164,180\n0,59\n178\n179\n175\n176\n34,39,59,303\n12,31,34,60,297,326\n51,54,57,315\n50,54\n79,118,124,177,294\n52,304\n52,307,338\n51,285,309\n306\n62,188,302\n63,184,279,304\n182\n57,180,197,293\n58,180,198,288,307\n42,71,166,287,317,320\n182\n180\n27,50,62,64,68,75,78\n32,52\n57,99,178,225,309\n58,164,184,309\n227\n70,161,296\n67,165,169,296\n53,309\n54,306\n177,203,287\n178,282,288\n16,53,82,297,311\n55,310\n176,217,234\n180,223,226,237,240,285,287\n71,177,293\n57,166,184,300\n180\n73,166,293,295\n26,54,310\n2,54,307\n175,196,214,271,290\n178,197,209,290\n34,41,48,290,310\n44,310,324\n52,294,304,308,321\n55,157,181,291\n34,158,182,280,283,295\n179\n7,9,122\n1,4\n160,168,180\n0,96,101,108,133\n13,93,97,106,122,124,150\n0,120,163\n0,32,38,40,52,79,94,109,125,142,163,167,180\n2\n54,77,160\n0,18,59,98,100,104,154\n106\n83,99,101,113,122\n75,107\n82,87,110\n0,4,21,35,54\n0,7,25\n18,57\n93,113,124,148,169\n130,180\n139,174,176\n177,179\n0,106,108,121\n180\n0,3,9,30,114\n0,9,16,50,65,85,123,128,134,157,170,180\n93,121\n1,22\n180\n3,10,349,359\n150,161,163,338,357\n151,338,351\n114,143,164,352\n5,35,43,46\n4,318,325,344,348\n242\n234,246\n0,60\n45,63,90\n0,7,9,29,33,40,61,64,83,87,90\n3,10,19,90\n50,73,80\n0,54,120,173,176\n0,17,28,47,57,90\n90\n0,21,23\n0,15,26\n0,11\n143,150,177,179\n118,165\n0,57,73\n0,8,21,25,28,40,45,90\n10,26,121\n3\n119,142,180\n150,164\n14,47,49,89\n13,116\n180\n0\n145,166,180\n40\n0,22,31,44,64,69,89\n142\n0,54,89\n0,7,119,123,138,149,168,179\n13\n153,160,180\n4,23,155,158,163,166,169,177\n162,184,191,205,208,214\n237\n237\n139,165,176,179,195\n147,167,173,195,217\n6,35,37,50,167\n10,36,55,98,110,147,160\n22,27,52,55,61,67,161,175\n13,47,157\n359\n359\n18,53,69,96\n14,58,97\n209\n208\n31,58,73,170,180\n48,77,166,169,180\n58,180\n0,25,74,85,92,122,132,143,157\n38,60,80\n90\n39,46,52,72\n180\n80,91\n3,31,55,70,88,120,122,124,136,157\n47,80,90,93\n0,7,31,47,53,62,67,83,87,90,117,149,154,157,165,180\n0,10\n0,12,57,78,80\n17,107,128\n87,90\n90\n1,20,33,49,68,83,99,119,122,125,128,131,150,157,165,170\n3,22,25,49,52,54,58,88,117,164\n55,148,180\n150,171,175,179,201,283,315\n58,149,165,173,179\n29,45,63,78,105,136,158,180\n48,75\n0,13,21,32,37,47,51,74,79,90\n0,115,126\n6,10,12,32,65,87,111,146,152,179\n1,15,22,25,31,60,139,142,149,151,166\n56,60,180\n20,94,101,110,140\n79\n80,88,90,103,126\n0,29,52,81,86,90\n0\n35,64,68,118\n42,66,149,151,158,163,180\n28,44,58,63,180\n0,8,50,76,86,90\n0,2,137\n32,57,72,88,121,180\n61,80,174,198,289,291,314\n53,80,178,196,295,304,306,310,316\n0\n94,129,152,156,160\n90\n41,88\n61,90\n45,75,105,138,159\n0,3,41,74,121,136\n19,53,66,79,90\n5,43,69,72,149,151,167\n45,48,56,59,148,167\n53,55\n0,26\n0,10,33,55,90\n48\n34,78,80,92,95,118,146,166\n6,10,26,78,93,95,127,155\n2,113,343\n2,23,39,71,132,138,166\n28,64,122,147\n59,68,74,146,149,180\n24,27,35,49,62,177\n39,180\n66,167,310,321\n60,77,207,300,332\n0,9,15,28,35,41,44,60,90\n0,13,56\n26,41,45,90,111,122,159,162\n29,50,88,94,98,103,123,164\n0,8,10,23,30,51,72,90\n0,2,8,23,49,55,57,60,68,71,75\n17,38,80,111,133,158,178\n15,80,82,108,165,179\n56,180\n0,3,14,20,57\n23,55\n0,16,24,37,46,51,90\n90\n0,40,63,90\n0,21,42,54,63,90\n0,121\n58,180\n27,44,54,62\n20,22,25,47,76\n62,180\n16,51,90\n14,37,42,52,56\n22,30,40,51,54,79\n19,44,60,93,163\n0,20,66,72,84,86,90\n20,59,112,140,161\n0,19,57,108,114,139,158,169\n43,59,87,133,139,149,153,157,174,180\n0,5,11,13,46,49,69,90\n0,5,14,45,59\n0\n61,68,76\n351\n350\n45,51,59,162\n28,56,96,102,109,148,180\n39,85,137,163,169,180\n28,141,159\n0\n0,47,139,180\n1,3,26,34,39,46,71,76,90\n0,2,16,112,131\n3,25,58,90\n90\n145,168,171,174,176,179\n0,24,41,67,90\n0,39,95,121,144,180\n44,63,90\n120,153,175,180\n0,11,15,52\n18,121,136,161\n0,30,44,49,62,75\n0,26,58\n0,20,120\n144,180\n8,12,18,20,37,49,62,102,105\n3,14,26,44,58,66,106\n29,38,41,85,134,158\n0,88,102,122,135,148,150,153\n0,10,30,49,59,82,105,128,131,134,150,180\n0,22,64,109,138\n18,70,72,85,92,115,118,142,149,160,163,165,167\n0,20,34,111,115,120,138\n59,180\n33,35,51,63,70,179\n54,180\n41,61,180\n2,40,78,86,90\n107\n70,177\n0,24\n184\n75,179\n22,38,53,57,71\n0,43,51,76\n49,179\n58,79,169,171,197,299,319\n56,77,172,197,270,273,294,300,309,311,313,318,320\n35,71,73,163,165,185,265,285,311\n51,151,181,185,270,293,295,310\n26,48,55\n2,25,28,55,74,82,86,88,90\n17,19,28,83,87,90\n17,85,90,99,109,138,165\n19,109,177\n18,51,53,77\n0,2,4,11,17,47,52,67,90\n2,5,45,72\n42,75,163\n51,54,73,151,157,166,186,263,281,308\n29,51,61,153,182,270,279,283,311\n12,32,54,72,90\n4,6,8,15,19,32,42,49,65,72,90\n53\n17,47,78\n1,28,35,39,42,123,155\n0,9,52\n147,168\n29,31,33,50,66,90\n2,7,27,49,75\n0,3,10,112\n0,52,64,88,121,148,168\n44,64,82,170,172\n47,69,176,180\n0,18,33,56,79,90\n14,61\n0,12,18,20,22,47,78,81,90\n0,54\n33,60,90\n12,65\n0,3,10\n80,97\n44,49,65\n29\n0,14,17,48,59,64,68,74,87,90\n0,14,34,40,43,53,60\n57\n172\n15,18,50,63,82,95,136,163\n43,74,100,113,219,221,224,276,314,349\n40,68,73,114,160,199,225,295,312,336\n49,70,173,180\n0,6,13,19,38,70,90\n0,67,99,122,143,173\n0,5,34,38,53,59,90\n1,5,15,45,65,83,88,104,116,132,134,146,176\n0,4,112,114,121,139\n0,123\n37,45,61,68,91,150,170,175,180\n0,13,36,89,120,157\n60,180\n40,63,181,300\n60,178,299\n54,64,177,299\n75,93,112,184,215,232,281,321,354\n34,63,183,203,273,301,328\n0,3,40,48,74,80,86,113,154,169\n173,180\n22,26,34,51,185,187,284,300\n24,54,183,290,299,305\n21,34,41,59,106,125,138\n60,64,167,172,179,181,292\n48,80,183,186,277,296\n56,73,177,195,301\n66,185,300\n0,2,7,12,153,166,168,180\n3,130,158,160\n151,163,169,191,341\n123,153,189,209,241\n199,214,225,234\n230,251,260,277,280,292,304,328,330,338,340,343\n228,235,253,282,330\n244,266,269,325,332,340\n211,214,240,273,302,347\n196,244,262,286,296,301,329,338,350\n6,68,123\n3,17,20,67,115\n30,49,52\n263,321,336\n262,329,336,340\n19,48,92,95,99,106,125\n314,330,332,334\n0,19,39,90\n36,101,118,136\n90\n123,133,136,141,162\n156\n19,48,54,72,90\n151,158,161,166,186,204\n0,38\n58,180\n180\n304,310\n307\n56,184,211,298\n56,185,298\n48,67\n55,310\n55,310\n0,47,67,124\n0,20,41,72,84,103,111,121,152,180\n0,30,73,104,123,166\n11,34,86,97,109,124,170\n0,10,20,26,103,107,110,123,131,173\n0\n156,180\n4,7,39,51,53,71,75,77,106,120,135,180\n1,5,115,126,135,141,146,159,180\n8,49,87,115,133,213,235,333,345\n25,41,92,94,96,135,144,155,192,202,208,270,338,357\n4,27,88,92,95,122,154,174,195,199,201,208,211,233,330,335,341\n59,180\n56,69,306\n54\n50,180\n52,179\n48,300\n49,301\n47,290,311,331\n58,296,308,323\n26,296,328\n293\n65,172\n69,171\n180\n65,178\n185,292\n185,259,267,271,290\n174,178,181,199,201,294\n55\n65,158\n61,172,194,295\n64,127,182,302\n63,167,183,302\n161,175,177,194\n302,328\n65,93,153,178\n64,166,182\n60,175\n59,181,308\n63,182\n0,10,25,40,46,56,67,78,110,121,127\n99,128,131,134,164\n0,2,15,21,46,61,86,92,104,117,123,164\n52,67,69,172,299\n47,66,76,85,156,161,176,179,194,269,275,285\n41,61,63,70,88,91,96,104,124,134\n98,117,131\n44,85,97,119,127,136,138,151,154\n13,15,30,177\n90\n104\n90\n67,90\n90\n10,34,70,75,108,142,144\n57,59,68,90\n117,150,175\n111\n48,51,53,58,68,80,84,97,122\n112\n37,40,55,60,65,70,89,97,101,104,143\n98\n91\n48\n56,180\n48,50,84,313\n31,56,311\n56,62,93,163,166,173,198,291,307\n64,163,177,206,284,317\n64,175,198,286,314\n50,67,87\n0,9,37,63,78,90\n0,21,72,88,90\n0,17,43,106,127,131\n52,67,69\n31,60,172,178\n12,173\n14,34,176\n12,58,74,77,101,159,163,178\n8,21,42,81,84,165\n0,9,57,87,111,138,156\n0,137,180\n65,98,106,129\n10,12,39,75\n0,67,88\n9,90,112,136\n2,14,33,69,71,75,83,85,87,104,147,168\n19,53,102,122,148,167\n0,3,6,27,65,84,104,123,126,152,178\n15,66,81\n0,9,15,32,37,43,79,99,114,157,180\n0,2,25,27,29,66,123,140,161,163,175,180\n0,73,75,91,110\n0,11,24,50,108,113,116,120,140,180\n0\n0\n133,138,172,177,180\n114,118,122,138,159\n142,148,180\n156,160,173,177,179\n25,113,125,154\n3,36,61,70,100,126,141,151,154\n130,140,143,169\n0,18,20,29,111,137\n1,12,36,75,103,127,154,158,160,163,166,171,174,180\n0,28,32,84,101\n145,171\n99,151\n0,25,99,118,129\n223,255\n226,271\n225,276,288,291,293\n225,248\n128,150,217\n123,154,175,217\n165,175,196\n143,154,175,219\n146,217\n153,213\n150,214\n59,76,288,301\n68\n88,157\n189,293\n181,208\n188,193,198,202,279,298,317\n63,171,185,285,304\n60,79,186,188,304\n63,188,203,301\n56\n292,307\n299,302\n301\n303\n51,179,183,196,212,214,237,294\n52,188,237\n61,286,303\n68,175,192\n69,94,177\n69,97,176\n67,123,176\n59,80,122,157,179\n67,71,121,123,149,161,172,176,178\n169,171,173,176,186\n59,180,302\n59,68,178,306\n302\n63,299\n58,301\n72,174,185\n0,35,69,90\n0,4,6,33,40,60,70,90\n0,129,145,149,164,166,176,179\n0,133,150,152,180\n117,151,166,178,180\n0,14,31,89\n0,134,155,157,180\n45,90\n0\n0,59\n111,141,168\n32,49,52,120,123,161\n122,160,165,167\n46,82,136,144,167\n252,255,257,268,270,285,325,327\n252,280,306,329,351\n31,79,82,85,95,101,359\n10,14,16,22,38,91,95,102\n10,56,69,123,127,147\n0,3,73,122,139,152\n7,119,236,240,244\n6,121,233,359\n282,285,294,300,321\n281,284,311,313,323,326\n222,242,266\n224,232,243\n39,53,96,115,356\n18,21,25,39,51,93,108,359\n39,49,51,86,89,161\n1,7,50,70,73,77,80,90,151\n244\n243\n8,287,295,298,330,351\n5,8,287,330,351\n4,122,145\n30,63,135,180\n109,131\n88,101,253\n89,114,119,124,127,155\n9,243,261,306\n245,247,354,356\n244,258,308,316,324,339\n15,21,27,110,120\n61,180\n32,40,43,65,85,179\n47,179\n53,180\n58,66,180\n60\n68\n63\n64,166,196,199\n61,173\n46,302,332\n46,300,331\n255,262,268,298\n186,261,291,294,296\n176,197,288,304\n53,56,169,187,302\n39,59,158,180,299\n12,60\n298\n300\n64,96,164\n62,81,96,139,159,161,176\n179,196,235,297\n183,197,295,298,306\n287\n189,296\n53,70,170\n61,176\n63,167\n44,67,189,300\n172,188,303\n184\n156,184,187,191,226\n63,91,298\n59,72,144,159,172,296,298,300,308\n57,306\n31,35,57,302,325,327\n157,181,205,226\n47,60,301\n59,179,301,307\n301\n301\n173,303\n298\n297\n54\n59\n57,185,202,268,289\n55,187,292\n54,181,305,309,318,326,329\n39,47,56,174,312\n58,177,300\n58,178,296,312\n175,188\n0,24,51,56,62,92,120,139,180\n58,180\n180\n145,149,176\n45,57,62,70,173\n60,92,173,180\n47,180\n0,112,129\n71,92,168\n10,28,46,48,50,82,100,164\n30,44,50,162,272,295,323,344\n35,280,323\n300\n300\n26,73,130,148,151,155,157,163,172,180\n24,52,173,288\n41,52,175,181,196,203,291\n58,174,289\n1,28,49,64,84,86,90\n0,16,43,55,58,90\n8,45,54,89,108,138,156,162,169\n6,14,28,34,52,119,139\n13,73,84,88,91,112,122,168\n22,63,69,85,111,123,126,133,171\n59,83,142,152,180\n58,60,182,297\n59,95,184,287\n2,37,43,53,90\n0,25,111,127,144,160\n23\n6,45,117,137,154\n0,24,50,72,75\n90\n8,58,78,85,102,174\n26,45,76,100,172\n10,23,29,123,149,208,214,221,255,351\n18,107,110,124,206,228,359\n6,9,12,15,21,140,162\n8,23,27,137,139,160,173,175,179\n0,19,48,74,80,90,96,171\n13,66,113,116\n0,90,102,125,127,152\n60,64,67,70,73,76,84,179\n45,61,64,83,180\n62,156,177,188,193,203\n44,66,154,181,199,269\n254,300,340\n196\n0,51\n0,3,5,10,39,90\n0,52,90\n3,13,15,29,31,56,58,63,89,101,128,145\n59,74,96,103,130,179\n0,25,55,88\n0,23,47,68\n0,26,58,78,80,83,95,135,161,180\n0,37,47,89,109,124,154,180\n36,56,90,114,120,134,137,170\n65,189,306\n68,181,307\n58,181,299\n57,179,299\n19,22,25,38,78,94,156\n31,55,58,95,177\n143,165,180\n160,180\n120,129\n0,103,135,140,153,171,173\n0,6,10,133,155,180\n11,127,149,153,157\n3,139,164,186,189,204,324,345\n2,5,8,10,12,82,105,134,154,168,171,188,243,292,323,330,346,348\n250,284,322,335\n15,17,69,109,139,157,171,173,175,248,254,264,345\n9,20,153,155,170,180,245,341\n0,3,31,91,188,221,242,267,310,329,351\n24,40,122,125,174,195,218,253,272,308,355\n180\n194\n57,62,178,192,309\n72,149,172\n0,9,13,15,55\n180\n0,42,180\n85,89\n120\n33\n7,28,40,43,52,70,84,90\n0,119\n62,180\n0,23,41,62,90\n0,117,140,144,155,159\n0,71,79,90\n0,81,95,122,132\n0,8,101\n0,56,80\n51,55,77,79,163,180\n62,171,175,186,299\n12,30,48\n0,17,98,100,102,118,120,122\n0,6,31,65,90\n0,119,162,165\n0,33,67,87,90\n2,8,14,28,35,39,46,59,72,107,143,146,163,169,177\n9,17,29,37,46,62,69,90,139\n0,46,90,160,177,180\n17,31,38,41,44,74,77,82,85,180\n50,80,123,154\n0,5,26\n18,44,59,62\n0,6,120,135\n0,2,7,17,36,70,72,74,90\n180\n16,29,58\n40\n0,7,9,38,67,90\n13,19,30,48,59,79\n0,90\n0,19,67,77,106,111,113,129,132,160,180\n1,8,18,43,53,159,176,180\n24,35\n178\n175,177\n174\n0,3,26,29,33,39,54,70,84,86,89\n0,90\n0,10,54,59,61,64,67,72\n8,28,59,116,180\n0,2,12,122\n53,58,176,178,180\n180\n7,123\n0,24,83,86,120,122,124,143,151,180\n59,205,311\n38,59,178,184,190,218,277,280,292,295,299,312,337\n23,44,50,56,62,69,75,81,143,160,175,189,205,241,259,278,300,337\n66,90\n0,82,84,90\n0,13,22,25,45,54,61,88\n11,13,64,70,85,90\n4,12,27,50,63,65,94,125,147\n4,20,27,31,43,52,63,67,70,84,111,121,123,156,160,170,172,176,178\n0,6,9,15,28\n1,4,21,29,67,77,90\n0,31,61,73,75,90\n29,65,87,97,134\n0,18,32,74,90\n180\n0,26,104,124,138,180\n0,10,52,90\n0,29,47,94,124,152\n15,52,95,114,120,142,180\n14,79,99,126,161\n0\n0,14\n0\n156,180\n0,3\n0\n0\n180\n0,13,91,106,116,122,140,165\n3,43,76,123,143,147,150,180\n58,60,63,67,78,99\n32,56,77,80,117\n0,91,180\n0,6,24,46,69,73,92,125,149\n102,119,124,135\n13,35,60,112,117,121\n25,27,70,72,90\n17,26,31,54\n87,90\n64,120\n68\n54,73,101\n62,76,90,92,94,130\n5,21,36,42,65,218,228,349,352\n11,28,36,39,42,157,217,231,234,351,353\n0\n124,137,139\n10,34,150\n42,76,153,172\n180\n235,257\n234\n300,320,337\n263,294,307,321,349\n20,98,112,125,143,165,169,194,250,352\n118,155,177,209,234,354\n106\n103\n74,88\n0,5,7,30,32,35,37,54,90\n0,11,15,19,28,58,90\n0,2,40,94,121,137,180\n137,180\n0,3,14,20,85,119,147,180\n0,4,7,20,25,29,51,82,120,123,126,129,150,180\n2,7,10,109,113,116,118,134\n61,181,301\n65,184,303\n53\n60,75,183,290,311\n200\n191,274\n55,304,306\n55,305,307,318\n72,146,180\n62,172,195,304\n60,187,308\n193,288\n57,306,351\n52,306,329\n0,8,43,47,88,90\n0,9,92,96,127,129,149,151\n147,167\n2,4,6,48,81,83,85\n8,114,127,145\n0\n0,124,130,156,176\n15,23,27,30,53,127,148,154,158,174,178\n317,319,339\n283,324\n15,34,40,54,72,91,111,123,125,135,144,149,162,166,172\n4,16,18,20,38,51,59,61,84,87,102,124,135,145,163\n304,341\n304,337\n0,2,13,17,35\n8,115,118,222,225,233,237,246,262,265\n53,120,180\n65,180\n54,69,153,173\n41,74,82,84,88,130,172\n49,306\n49,51,60,64,67,98,168,296\n40,58,174,191,297,299,307\n299\n298\n58,76,191,288,305\n58,186,306\n54,58,66,146,175,187,309\n42,58,74,88,143,149,156,177,297\n0,3,57,118,174,180\n167\n66\n0,3,12,15,64,72,80,84,119,121,173,178,180\n142,170,173,180\n0,22,54,83,106,109,180\n0,20,55,79,88,103,106,125,169\n34,61,164,180\n22,25,27\n125,129,154,172,176,180\n2,11,52,71\n18,28,57,78,129\n51,167\n16,114,159\n38,41,46,51,80,85,180\n1,14,29,31,41,62,64,80,90\n0,33,49,53,84,86,118,132,136,142,155,180\n0,7,14,55\n44,58,180\n0,24,36,61,87\n60,180\n151,180\n2,16,23,29,48\n0,4,32\n10,60,108,125,131,137,176,180\n25,29,33,56,89,91,128,147\n172\n172\n2,57,306\n18,52,77,90\n4,41\n54,69,179\n177,265\n177,270\n2,60,90\n64,160,180\n10,93,120,139,180\n7,20,38,66,86,139,147,149,169,172,180\n139,171,180\n180\n5,24,45,55,82,117,147,160\n2,15,20,36,42,75,146,165\n20,31,41,112,134,148,150,167\n25,38,43,150,177\n0,36,45,55,82,156\n69,154,180,300,309\n54,57,180,306\n13,18,24,40,67,99,141,165\n0,8,28,39,41,43,70,81,108,157,180\n15,44,75\n35,64,77,80,95,157,171,180\n0,11,22,60,85,126,128,149,180\n37,55,82,87,90\n0,10,15,27,46,88,111,127,155\n46,71,166\n3,125,167,224,229,232,240,352,357\n3,111,165,171,177,224,227,233,240,288\n21,40,46,74,80,86,101,119,133,154,168\n44,79,161\n42,60,87,127,153,180\n38,80,125,155,175,202,224,258,281,335\n28,49,333\n27,49\n34,39,43,64,85,133,154\n23,58,100,119,142\n0,35,55,68,92,147,180\n47,170,207,291,314\n93,156,159,180\n0,10,34,39,50,79,113,133,137,139,151,165,180\n0,20,32,104,146,148,153\n0,20,100,106,117,130,147,163\n14,37,136,234,317,320,331,351,357\n89,95,116,149,208,227,315,321,332,354\n0,61\n1,38,46,55,72,77,90\n55,82,180\n0,19,70,82,90\n0,11,112,134,152,177,180\n2,21,42,45,68,89,91,93,95,97,108,111,118,126,144,148,166,169,173,176\n5,31,34,63,79,88,115,118,138\n1,30,72,97\n6,28,97\n61,90,180\n57,176,183,292,310\n49,72,166,182,196,278,306,308\n14,149,177,180\n32,55,82,90\n0,5,56,65,68,75,89\n3,6,58,90\n90\n127,175,180\n0,52,58,63,68,79,81,108,120,125,133,137,140,145,163,166\n6,17,73,98,115,148,155\n12,15,25,30,46,55,114,134,136,168\n15,46,65,86,90,105,133,170\n254,273,275,282,285,291,295,336\n256,272,274,287,295,344\n303\n303\n0,32,64,90\n0,12,25,37,40,55,71,90\n127,141\n1,19,22,31,33,49,68,90\n0,7,120\n0,17,22,30,100,118,127,137,142,144,146\n0,2,4,11,15,38,50,53,90\n0,2,23,25,59,90\n7,12,15,33,67,96,110,167\n10,96,106,113,166\n0,32,65,91,124,158\n0,18,35,83,87,90,110,120,126,142,147,149,180\n0,10,16,42,45,76,83,90\n17,23,35,63,105,120,138,154,173\n13,22,26,29,57,79,104,161\n0,20,40,68,90\n28,55,64,70\n0,22,60,67,92,108,111,155,170,180\n44,79,163\n26,43,60,147,165,169,202,249,323,356\n9,39,78,95,140,155,178,246,254,280,319,355\n25,88,197,203,210,216,222,259,311,330\n14,132,187,217,235,240,250,260,266,322,328,335\n33,58,92,95,137,157,180\n0,6,41,51,54,69,79,90,110,152,156,158,178,180\n0,23,90,97,106,125,142\n9,46,62,64,86,108,120,123,132,137,147,149,156,159,172,180\n0,14,101,104,124,126,147,180\n0,6,20,50,74,77,113,124,129,133\n18,50,103,109,115,135\n14,33,37,41,62,147,180\n0,4,9,113,132\n26,67,97,142,162,171,180\n43,46,61,175,180\n0,22,112,117,124,132,135\n60,182,285,300\n38,64,177,188,302\n0,9,26,56,59,95,107,117,137\n0,43,72,93,141\n81,101,132,146,172\n152,175,177,179\n0,24,42,120,126,134,138,147\n121,124,129,147,149,163,188,329,353,358\n5,142,144,147,181,229,258,310,334,349\n241,273,303,345\n273,288,326,334,345\n2,4,6,18,28,40,42,45,55,60,89,136,147,156,158,221,234,279,316,347,358\n7,12,17,64,126,136,147,196,200,216,265,281,290,332,344,349,356\n0,9,121,138,141,153,156,179\n144,159,169,178\n172,220\n285,307,323,331,348\n0,25,31,42,142,154,160,164,177,180\n0,13,25,45,50,68,72,89,127,171,176\n62,92,106,119,121\n0,14,16,24,77,87,109,112,141,159\n1,35,127,130,143,180\n70,91,140\n74,90\n70,81,113\n24,55,59,69,78\n73,88,90\n55,60,90\n78,117\n122,128,132,145,162\n57,60,63\n71\n73,115,119\n54\n71\n85,90,93,180\n64,78\n76,86,88\n71,90\n85\n75,90\n90\n17,19,113\n67,86,90\n120,147\n35\n32\n25,62,67,84,90\n3,23,31,40,69,88\n76,90\n148,160,172,180\n19,58,78\n9,14,24,136,157\n326\n5,253,271,292,316,319,322,325,328,334\n62,79,169\n43,67,169,190,300,303\n150,161,172,186\n55,71,98,126,137,156\n52,83,100,124,156\n8,21,126,150,168\n23,36,41,93,128,131,134,146,159\n8,34,170\n9,33,63,88,92\n18,20,45,85,158,161,165,168,174\n6,25,32,55,121,125,137,146,159\n7,59,76,103,122,142,145,169\n8,36,39,64,89\n145,164\n118,151,180\n98,105,124,126,139\n160,171,180\n0,28,109,125\n0,40,48,58,84,105,108,111,117,142,161,177,180\n163,166,169,187,205\n162,164,166,186,201\n55,59,61,158,161,179\n34,53,65,72,173,180\n59,61,180,298\n57,180,287,295\n54,56,166,172,186,300\n175\n175\n58,180,299\n57,74,179,296\n0,2,6,180\n0,10,20,30,53,82,138,161,180\n27,46,56,62,68,80,127,167,180\n296\n308\n190,274\n62,298,300\n57,80,82,177,189,299\n47,69,289,309\n50,64,80,179,304\n61,180\n138,167\n167\n0,56,81,99\n62,77,83,95\n65,184,306\n64,183,306\n0,19\n5,71,164\n170\n0,20,24,32,69\n11,13,31,34,90,98,131,143,149,174\n11,47,85,94,106,117,131,150,169\n149,153,156,180\n153,172,176,180\n0,6,9,31\n17,34,59,105,132\n6,26,54,77,117,140,158,175\n7,32,115,118,127\n15,65,69,125,139\n10,62,129\n274,301,319,340\n272,286,302,317,320,337\n35\n66,140\n2,5,64,141,143,156,162,167,175,179\n15\n1,14,53,60,78,114,118,124,139,153,180\n59,162,180\n0,33,53,63,115,160,172,180\n34,59,70,171,180\n7,27,62,71,89,119,156\n0\n167,169,180\n14\n0,16\n0\n0,6,8,15,18,56,106,183\n57\n0,43,60\n1,90\n39,181,293,307\n276,306,329\n47,50,306\n302,317\n64\n0,8,27,34\n0,7,106,115,118,124\n0,2,15,22,48,55\n131,141,144\n179\n0,24,99,122\n75\n0,37\n0,14,17\n13,37,76,136,172,176,179\n16,39,51,62,66,115,145,147,152,180\n1,33,59,67,79,90\n0,20,49\n102\n102\n100\n94\n96\n312\n98,310\n270,320\n197\n65,116\n1,3,5,45,67,90\n61,86,90\n136,145,148,157,170\n0,63,74,90\n9,12,15,36\n35,49\n41,54\n38\n12,30,33,38,59\n67\n42,60\n0,169\n1,31,40,62,85,95,106,123,179\n0,3,99,140,179\n1,26,31,185,305,315,334\n35,57,153,185,210,234,271,317,351\n4,18,24,72,154,159,165,201,246,314,346,349,352,354,357\n0,17,32,37,43,141,187,211,347\n68\n138,156\n8,26,102,136,157,166,172\n41,179,185,191\n1,22,40,62,68,74,208,329,347\n28,47,54\n149,154,175,178,180\n66,83,90\n0,25,40,140,142,163,165\n23,85,90\n105\n123,135,162,180\n99,111,150,173",H),u=0==(1&t)?null:Jl.VHb("14-38,46-74,87-105,169-191\n33-44,47-81,83-92,92-103\n133-160,167-185\n159-184,249-280\n199-221,221-232,232-255,258-267\n40-75,160-200\n18-26,28-37,37-45,48-64,72-81,93-105,109-127,171-189\n-27-27,49-56,56-76,76-104\n-43-43,45-65,65-115\n-28-28,58-61,61-70,70-90\n-16-16,44-69,69-82,157-203\n-21-21,21-52,73-107\n-11-11,20-33,33-39,39-59,59-78\n3-25,25-43,43-67,78-102\n0-24,32-49,49-52,52-69,69-73,73-77,77-79,79-87,87-89,89-91\n0-26,26-46,58-76\n-29-29,29-51\n0-20,170-190\n-14-14,21-58,58-70,70-89,89-91\n8-37\n-1-1,1-28,28-30,30-47,52-69,69-87\n0-27,27-29,29-43,43-47,47-56,56-63\n42-60,60-62,62-80,80-100,136-146,146-155,171-189\n167-193\n-12-12,24-41,41-50,50-71,71-81,164-180\n-11-11,43-70\n-23-23,40-70\n28-42,42-75,75-87,160-200\n42-70\n36-55,55-73,293-321\n31-49,49-61,61-75,294-322\n-3-3,3-15,53-71\n55-63,74-93,114-135,143-170,170-190\n0-4,7-29,42-72\n17-92,92-107,132-179,179-181\n34-65,83-101,140-153,160-180\n32-51,72-92,151-169\n33-51,70-87,151-176\n46-79,156-204\n40-67,153-175,175-185\n40-65\n40-63\n48-75,156-176,176-184\n33-52\n-1-1,1-17,21-37,165-176,176-184\n37-56,65-86,152-175\n47-74,79-88,170-190,199-217,296-315\n49-75,75-86,291-318\n-4-4,4-9,9-11,11-13,46-74,74-93\n-9-9,49-75\n0-18,28-46,47-58,58-75,85-107,125-133,169-191\n-1-1,1-13,13-42,125-146,156-167,167-193\n38-60,60-62,62-66,66-85,155-178,178-182\n33-54,64-88,155-176\n33-55,66-85,155-176\n22-29,30-59,59-63,63-65,65-70,70-79,156-181,181-195,259-277,277-286,286-319\n13-29,29-44,44-52,52-67,67-73,73-84,136-155,155-173,173-185,185-204,273-292,292-298,298-320\n15-29,34-41,41-49,49-72,72-83,137-155,171-197,197-211,267-285,288-314\n34-51,51-71,140-151,151-162,172-179,268-286,286-298,302-317\n33-58,58-78,162-198\n29-42,42-59,67-88,148-164,164-196\n29-56,62-79,79-90,158-179\n30-43,43-48,48-55,55-63,63-83,136-166,166-179,179-181\n28-46,46-51,51-58,58-71,71-83,83-100,149-174,174-179,179-181\n160-180\n-11-11,18-48,51-70\n171-189\n0-10,10-14,14-34,34-55,72-77,77-88,88-92\n-10-10,11-31,31-53,67-78,78-102\n0-19\n-9-9,9-12,12-19,19-35,35-39,39-44,55-73\n32-82,158-202\n39-61,61-83,162-177,177-183\n41-77,156-204\n45-84,159-201\n48-68,81-99,139-157,157-160,160-165,165-175,175-179,179-181\n-2-2,2-11,11-50,51-60,63-70,70-75,84-103,110-137,137-168,171-189\n48-69\n31-49,49-58,58-84,154-171,171-175,175-185\n33-56,61-87,151-177,179-181\n37-60,60-82,160-182,182-205,275-293,306-324\n32-58,161-174,174-179,179-180,187-209,282-300,306-324\n157-180\n3-19,30-61,61-89,149-180\n42-65,91-109,143-167,167-193\n27-60,60-73,73-91,100-115,115-124,124-134,159-201\n17-48,48-51,51-78\n129-132,158-180\n17-35,48-69,325-343\n20-38,48-70,321-338,338-350\n44-75,167-193\n38-59,59-80,161-180\n46-71,151-165,165-195\n166-194\n28-57,57-96,158-177,177-183\n39-53,58-72,75-93,109-127,163-180\n2-15,24-63,63-100,134-149,149-178,178-180\n26-57,57-63,63-93,147-172,172-178,178-182\n30-49,49-52,52-65,65-101,144-179,180-215,263-303,303-338\n20-33,33-62,68-93,141-160,160-162,162-178,178-203,203-219,267-281,281-300,304-324,324-326,326-341\n43-70,170-190\n38-50,56-60,65-72,72-91,149-169,169-191\n49-72,166-180\n48-72,168-192\n38-57,65-83,158-180\n37-63,74-85,150-168,190-208,211-229,288-305,307-324,338-365\n50-70,70-71,76-80,80-83,87-99,164-181,183-203,275-290,290-300\n294-319\n296-319\n48-80,183-192,296-314\n47-79,158-170,170-175,175-185\n41-65\n48-73\n-2-2,2-4,4-19,19-24,24-27,27-29,40-58\n36-54,54-61,61-76,167-193\n24-43,43-68,168-192\n26-38,39-69\n19-31,31-34,37-66,302-320\n174-195,276-289,289-306\n-1-1,1-22,22-35,35-47,47-66,66-76,76-86,86-93,93-96,96-121,121-128,128-140,140-148,148-170,170-190\n4-28,43-76,76-87,160-178\n39-48,62-91,154-179,179-181\n43-57,57-62,62-80,165-195\n30-77,77-81,81-94,164-196\n34-47,47-58,58-85,154-169,169-180\n48-71,167-193\n44-69,69-71,71-86\n5-29,56-87,97-115\n44-82,158-202\n47-65,165-195\n39-63,169-191\n164-196\n51-75,177-195,290-308\n163-191\n43-61,174-190,190-201,212-230,278-296\n45-68,163-190\n50-76,165-189\n51-79,155-190\n41-61,61-81,86-99,130-138,172-190\n178-198,202-229,276-308\n180-192,216-236,276-308\n189-212,218-233,266-279,285-298\n20-67,67-70,70-96,148-175,175-185\n54-85,289-316\n35-46,46-54,54-58,58-60,60-62,62-85,288-310,317-325\n44-76,163-197\n31-52,59-87,87-99,149-178,178-182\n40-78,160-200\n36-55,55-58,58-61,61-63,149-166,166-170,170-172,172-192,278-296,301-321\n42-58,61-78,78-90,152-170,178-194,194-213,270-288,293-313\n292-314\n47-71,169-191\n42-78,164-196\n30-61,61-92,144-170,170-178,178-182\n47-81,169-201,278-291,291-319\n42-81,163-200,282-318\n41-69,69-81,167-188,188-203,288-315\n46-80,167-196,290-316\n50-78,165-193,193-205,293-318\n48-76,167-203,298-320\n44-62,285-303\n47-76,165-195\n49-71,168-192\n38-84,149-165,165-195\n33-41,44-52,52-55,55-82,83-102,150-163,168-192\n26-55\n30-41,41-83,158-166,166-194\n-28-28,28-53\n-7-7,7-25,51-76,81-103,132-143,150-210\n-5-5,5-22,25-43\n0-25,38-46\n-17-17,17-25,25-28,28-37,37-44,44-45,61-69,80-100\n-11-11,22-40,155-205\n-4-4,16-30,30-60,60-90,90-111,131-142,156-176,176-180\n29-57,60-89,151-176\n35-80,152-179,179-181\n44-70,165-192,287-304\n46-77,167-193\n46-74,165-195\n43-73,168-192\n34-47,53-76,165-182,182-191,286-294,294-297,297-315\n37-45,58-76,158-175,175-179,179-196,275-297\n44-72,168-189,292-315\n51-74,167-190,282-313\n33-59,59-61,61-69,69-81,99-117,156-174,274-293,293-301,301-303,303-305,319-337\n32-45,45-50,50-51,54-58,58-59,61-65,65-67,70-74,74-75,99-117,275-293,293-295,295-298,298-306,306-318,318-336\n-2-2,2-16,32-50,97-116\n153-170,171-189\n-13-13,14-16,16-45,50-83\n-14-14,18-32,32-38,111-132,171-189\n50-71,170-190\n-12-12,171-189\n-10-10,10-33,35-54,54-66,66-79,79-90\n14-31,33-49,50-69,75-93,97-115,127-147,153-166\n6-31,31-40,40-71,71-89,89-91\n-5-5,5-19,19-23,23-45,45-49,49-53,53-63,63-78,78-102\n-12-12,49-60,60-78,98-113,113-132,168-192\n2-14,14-18,18-26,26-35,35-54,77-103\n0-11,11-35,35-55,55-57,57-63,63-71,71-89,89-91\n-1-1,1-14,14-22,22-34,34-41,41-46,46-53,53-59,59-66,66-69,69-73,73-96,96-117,117-119,119-127,127-129,129-135,135-148,148-159,159-168,168-192\n0-31,31-62,62-84,84-88,88-92\n0-28,28-42,48-62,62-80,80-94,94-104,104-114,114-138,138-142,142-150,150-158,158-160,160-174,174-180\n0-12,12-26,26-43,46-77,77-97,97-120,160-200\n-1-1,1-20,53-72,72-90,98-112,112-116,116-130,150-167\n0-19,19-49,49-89,89-91\n34-61,61-64,64-71,71-79,79-102,102-118,118-121,121-145,145-162,162-166,166-180\n-3-3,3-16,16-41,43-62\n8-25,29-51,51-53,53-57,62-72,76-94,142-160,163-178,178-182\n16-43,43-52,52-58,58-62,62-70,70-95,105-123,128-136\n-1-13,18-31,31-60,60-78,83-104,104-112,112-122,126-149,162-179\n5-17,17-46,56-69,75-88,127-145,202-220,224-235\n0-39\n19-33,33-35,37-55,162-180\n-11-11,46-74,74-87\n3-16,22-30,36-49,67-84,84-96,98-105,117-127,127-136,136-143,143-168,171-189\n31-49,97-122,122-138,138-163,169-191\n16-24,44-59,59-78,166-194\n168-192\n51-73,167-193\n168-192\n-10-10,22-42\n-18-18,29-44\n-10-10,21-27,27-45\n47-87,168-192\n37-80,80-115,159-201\n45-68,72-88,88-92,92-97,97-106,106-110,110-113,117-129,142-165,165-168,168-192\n44-66\n44-67\n-27-27,42-68\n42-84,165-195\n31-64,71-89\n36-47,60-72,72-82,135-149,153-207\n34-64\n-2-2,2-28,41-62,62-85,166-194\n-3-3,3-23,39-70\n0-29,74-117,117-154,154-170,170-190\n88-145,145-170\n-26-26,49-60,73-148,162-198\n96-144\n0-29,39-60,62-80\n0-32,34-56,56-77\n0-36,36-56,56-75\n0-33,35-56,56-64,64-80\n83-94,98-129,129-153,153-177\n-17-17,80-97,97-140,146-150,152-163,163-178\n-1-1,1-6,6-14,14-16,16-23,23-24,26-33,33-57,65-68\n0-14,32-59\n66-83,83-87,87-110\n65-86\n85-96,96-102,102-124,124-139,171-189\n69-111\n40-74,75-79,79-85,85-86\n-1-1,2-25,75-93,97-115\n72-102\n48-94,149-172,172-175,175-178,178-182\n44-76,76-78,78-80,143-159,159-180\n46-85,163-197\n-3-3,3-25,50-80\n50-69,69-77,77-95,137-155,155-179,179-181\n49-60,60-80,100-118\n39-52,52-57,57-99,115-133,165-180\n163-197\n44-62,62-63,69-72,72-106,171-189\n38-56,63-81,104-124\n64-99,99-112,171-189\n62-106,108-122,139-161,171-189\n45-55,55-92,139-157,158-176\n105-123,160-200\n34-46,47-75,77-89\n-15-15,24-68,75-96\n53-87,170-190\n56-79,167-193\n52-69,171-189\n143-170,170-190\n123-133,135-141,141-143,143-146,146-155,155-163,163-165,168-170,171-189\n3-28,92-131\n58-75,75-98,163-197\n49-80,165-195\n88-106,165-195\n49-74,88-106\n53-76\n52-73\n69-88,161-179,179-181\n53-81,166-194\n113-131,146-164,164-180\n-31-31,50-74,108-144,148-180\n-9-9,23-48\n0-16,31-48\n128-149,149-156,167-193\n-9-9,15-26,44-66\n51-106,156-204\n70-102,105-126,142-161,161-179,179-181\n68-87,87-112,112-120,120-140,140-144,148-155,157-203\n-3-3,22-76\n31-46,46-70,70-90,90-105\n49-69,84-105\n42-90,157-203\n159-201\n35-62,62-64,64-67,67-71,72-82,82-92\n53-74,74-101,112-129,160-200\n68-86,86-104,142-161,161-163,163-177,177-183\n25-71,71-76,76-92\n53-104,109-144,158-202\n162-179,179-181\n51-84,164-196\n62-80,123-144,144-154,162-164,164-174,174-180\n43-108,108-118,118-134,160-176,176-180\n-1-1,1-23,34-70,70-90\n2-12,26-59,59-87,151-176,176-184\n42-64,64-66,66-70,70-84,84-99,143-166,166-194\n36-46,46-55,59-82,135-154,154-177,177-183\n88-120,120-122,122-133\n51-77,77-95,163-197\n160-200\n159-201\n12-16,42-66,66-91\n63-74,152-165,165-168,168-180\n52-79,168-192\n56-76,166-194\n54-77,169-191\n161-199\n41-66,66-68,68-86,164-196\n35-48,53-80,80-95\n154-206\n162-198\n57-79,164-196\n59-78,83-98,98-100,100-135\n160-200\n48-94\n64-82,170-190\n63-75,75-104\n59-81,81-106\n71-100\n78-99\n67-94,95-106,168-192\n71-89,89-93,93-111,169-191\n-9-9,19-29,29-38,38-48\n-11-11\n82-105,105-115,115-142,154-173,176-184\n104-123,126-147,147-155,155-170,170-190\n-12-12,60-77,77-89,98-118\n-4-4,4-18,56-87,94-115\n-12-12,36-57,57-72,72-74,74-91,102-127\n53-83,157-203\n49-70\n56-89\n58-74,74-106,108-120,146-158,158-161,165-177\n-9-9,19-35,37-54,54-74,78-97\n48-80,80-101,155-205\n36-57\n123-151\n170-190\n168-192\n-6-6,6-26,107-126,151-173\n-17-17,31-46,65-85,93-149\n39-51,63-77,77-82,82-97,97-100,100-130,130-163,163-178,178-182\n0-19,19-22,22-56,56-69\n0-26,34-50,55-75\n48-80,166-194\n46-71,71-77,77-96,158-202\n45-70\n41-78\n-12-12,52-83,163-197\n37-62\n141-153,153-155,161-180\n-14-14,140-151,155-205\n24-43,52-56,56-60,60-72,72-76,76-80,80-91,94-114,122-140,155-173\n-23-23\n-23-23\n144-164,164-196\n-10-10\n-12-12\n63-119,157-203\n92-128,128-135,135-138,138-140,146-214\n117-126,126-140,148-180\n99-111,111-117,117-131,134-180\n48-69\n0-27,35-72,83-104\n43-70,81-104\n-23-23,47-67\n54-118,152-208\n121-133,136-178,178-182\n7-27,36-68,68-78,78-98\n36-67\n50-121,160-200\n64-101,103-139,139-142,142-145,151-209\n0-3,24-62,76-98\n15-28,28-31,34-66,69-91\n46-101,161-199\n8-27,37-67,72-94\n143-170,170-177,177-183\n46-75,81-105\n17-45,68-86\n16-41\n51-81,143-161,161-180\n79-105,110-124,141-219\n113-145,145-152,152-154,154-157,157-165,165-195\n50-83,83-106\n35-59,67-94,94-131,131-152,152-155,155-177,177-180\n107-120,120-127,127-146,146-152,152-156,156-204\n14-30,30-41,41-52,52-63\n81-100,101-119,145-170,170-180\n65-105,105-125,125-131,131-134,134-180\n88-115,115-146,146-156,156-160,160-163,163-175,175-185\n79-97,100-123,131-153,157-175\n43-72,72-94,97-119\n-13-13,41-69,83-104\n-13-13,47-66\n109-133,140-157,157-203\n25-46,52-65,71-95\n52-85,157-203\n58-79\n53-76,163-197\n38-70,163-180\n28-39,55-77,170-190\n4-24,24-39,53-79,143-159,165-195\n55-79,151-169\n94-121,154-168,168-172,172-188\n69-87,87-99,99-106,106-120,120-126,129-137,137-140,140-142,164-180\n48-70,83-101\n48-72\n-11-11,164-196\n-10-10,15-36\n-13-13,164-196\n-16-16,35-55\n106-137,137-147,153-207\n120-140,161-199\n-10-10,24-43,48-75\n169-191\n163-197\n165-195\n-25-25,25-51\n-9-9,18-36\n168-192\n166-194\n61-88,88-104,104-130,130-149,149-211\n62-98,98-123,136-154\n61-84,84-92,92-114,114-140,140-143,143-147,147-152\n60-95,95-105,105-112,112-130,130-149,171-189\n53-83,159-201\n165-195\n43-91,166-194\n-13-13,47-67\n62-85,85-89,89-103,116-136,157-175\n16-37,37-54\n57-92\n28-55\n45-93,93-97,97-111,118-132,132-138,142-152,152-180\n69-83,83-103,103-126,138-156,156-166,166-176,176-179,179-181\n54-94,166-194\n0-22,48-66\n0-28,49-57\n0-19\n164-196\n41-83,163-197\n55-72,72-74,74-83,83-96,110-121,121-129,148-180\n-17-17,48-67\n-20-20,48-69\n74-103,171-189\n103-122,156-180\n145-179,179-181\n54-74\n-14-14,169-191\n168-192\n-12-12,84-102,102-128,128-130,130-144,144-159\n-16-16,105-147\n1-26,67-81,81-99,102-117,117-141,141-144,144-156,156-158,158-169,169-171,171-174,174-186\n-1-1,1-40,49-54,54-78\n0-24,24-49,58-84\n145-157,157-159,159-201\n46-81,164-196\n17-35,47-71,71-79,79-98,158-202\n0-26,45-67\n-19-19,42-66,72-90\n-13-13,39-67\n43-79,162-198\n34-65,74-89\n-10-10,27-51\n-9-9\n167-193\n166-194\n156-204\n-9-9\n-9-9\n169-191\n164-196\n55-105,161-199\n62-130,130-132,132-228\n87-95,141-161,161-199\n69-80,80-83,87-136,169-191\n74-96,99-108,155-205\n44-70\n-9-9,9-51,51-53,53-84\n40-69\n7-24,24-42,64-78,83-97\n40-70\n47-66,66-91,159-201\n61-89,89-92,92-95,95-118,118-124,124-149,149-180\n155-180\n32-46,46-63\n43-60,60-80,80-94,130-149,149-159,159-201\n65-106,113-117,117-133,160-200\n72-82,82-85,85-89,89-112,112-122,122-128,128-132,132-142,142-162,162-170,170-180\n-4-4,9-25,25-60\n17-40,40-71,72-93\n51-89,130-149,154-180\n60-113,124-129,129-143,143-148,154-206\n78-98,100-136,136-138,138-147,147-158,158-202\n93-148,166-180\n99-151,167-193\n0-27,27-51,54-82\n89-107,107-109,126-137,137-158,160-180\n0-7,7-9,9-13,13-18,18-38,38-54,99-148,148-154,154-166,171-189\n-13-13,41-59,59-79\n166-194\n-13-13,104-141\n161-199\n49-82,163-197\n123-150,152-170,170-180\n-6-6,6-10,10-27,45-66\n0-24,40-66,71-97\n44-66\n51-77,163-197\n36-68\n47-95,158-202\n139-154,156-204\n137-156,160-200\n46-66\n42-83,159-201\n60-75,75-81,149-180\n37-57\n166-194\n67-102,102-120,120-126,126-138,138-158,158-162,162-198\n90-108,108-134,138-141,144-162\n-8-8,8-29,29-47,49-83\n45-56,62-70,70-80,80-101,101-107,107-108,116-117,119-126,159-180\n166-194\n166-194\n84-114\n84-106,106-110,110-120,120-144,155-178,178-182\n138-155,155-158,158-166,166-180\n70-112,112-114,114-134,134-178,178-182\n113-148,148-168,168-192\n44-74\n48-82,89-113,113-127,127-132,132-147,147-153,153-160,160-162,162-179,179-181\n14-45\n65-88,88-96,96-103,103-105,105-125,125-150,150-154,154-157,157-179,179-181\n-5-5,5-30,43-68\n71-94,94-102,102-126,126-146,146-174,175-185\n-12-12,41-87,161-199\n56-80,80-85,157-177,177-180\n52-71\n53-64,64-99\n25-54,54-57,66-81,81-104\n52-80,80-82,82-95,167-193\n53-75,169-191\n33-47,47-61,61-72,163-179,179-181\n57-83,146-168,169-191\n74-92,104-123,123-138,138-152,152-154,154-158,158-163,163-178\n46-73,73-93,164-196\n54-87,152-180\n54-86,164-180\n-4-4,11-32,32-35,35-39,39-42,42-62,68-100\n-10-10,169-191\n-12-12\n-10-10,170-190\n163-197\n160-200\n0-2,2-31,31-45,45-54,54-65\n156-204\n84-101,101-103,103-123,123-144,144-152,152-160\n64-80,80-106,106-111,111-135\n57-99,165-195\n146-156,156-180\n13-33,42-77\n55-92,160-200\n48-83,160-200\n48-67\n50-68\n56-96,121-141,147-163,163-177,177-180\n50-73\n35-60\n44-82,155-205\n48-75,75-95,164-196\n49-67\n47-67\n-2-2,2-5,170-190\n162-198\n0-24\n190-212,240-255,255-274\n-1-1,1-5,5-20,20-27,27-29,29-32,32-47,77-96,96-122\n-3-3,3-27,27-46,46-51,51-54,54-74,74-82,82-86,86-90\n-19-19,68-90\n111-123,123-149,158-169,169-191\n-5-24,24-36,36-60,147-175\n-9-17,17-27,27-39,39-41,41-64,64-74,143-171\n-9-5,5-40\n-4-5,7-12,12-42\n23-35,43-65,75-95\n36-71\n-2-16,22-40,44-62,250-272,342-358\n59-82\n69-95,95-122,168-185,185-197,197-200,207-216,216-229\n78-105\n210-232,275-293,304-322,322-329\n211-246\n263-286,287-306,306-308,308-322,327-349\n264-276,276-281,281-311,313-323\n248-270,270-290,290-293,293-297,297-307,307-326\n152-160,166-169,169-189,189-217,248-266\n158-195,195-196,217-235\n-11-11,159-201\n-5-5,95-113,121-149,149-167,167-173,173-187\n8-37,303-323,323-356\n17-35,301-312,312-314,314-357,357-372\n48-68,68-71,71-84,154-164,164-168,173-176,176-184\n132-165,165-195\n104-130,143-168,168-180\n342-370\n2-4,4-22,22-30,30-40,295-316,316-327,330-344,344-362\n45-76,168-197\n46-64,64-79\n57-87,192-215\n52-69,69-80,192-223,230-248\n59-79,184-220,220-222,222-240,240-246,275-284,296-307\n45-62,62-83,90-98,181-198,201-218\n272-291,291-300,300-323,329-347\n210-221,221-223,223-242,274-285,285-297,298-323,326-347\n269-287,298-323,323-352\n50-68,71-90,178-205,211-221\n48-66,70-88,179-198\n63-81,90-108,172-194,194-212\n-9-9,9-13,13-28,28-32,32-35,35-54\n-9-12,15-42\n-9-5,5-22,25-48,156-171\n-10-18,26-44,144-162\n13-42,166-184,339-357\n167-193\n50-90\n-17-17\n-6-7,7-30,30-33,33-37,37-58,151-169,169-174\n-19-6,6-18,18-26,26-51,51-67\n-11-5,5-23,129-137,149-169\n-13-32,138-147\n64-90\n89-115\n167-193\n76-104\n-17-17\n-5-13,158-186\n110-125,125-138,138-141,147-180\n1-4,4-16,21-34,324-361\n3-8,324-363\n21-40,45-67,67-77,77-96,96-116,116-132,150-172,172-188\n-11-11,11-51\n33-77,81-99\n47-90\n39-87,87-100,100-104,104-140\n60-120\n56-124\n-12-12,35-61\n-23-23,28-54\n124-174,174-186\n18-42,42-68\n-20-20,20-23,23-46\n27-58,117-128,128-142,142-144,144-171,171-176,176-184\n-6-6,6-14,14-30,79-101\n-1-1,17-63,78-102\n48-72,126-149,168-192\n-2-2,12-56,56-78,78-82,82-85,85-95\n25-38,38-42,42-46,46-71,82-100,100-108,108-131\n43-56,56-59,59-73,73-76,76-87,87-93\n29-81,81-99\n36-85,85-102,102-142\n44-71,71-109\n-13-13,13-43\n130-154,159-201\n121-136,136-138,138-164,164-196\n0-6,18-90\n0-25,25-58\n41-87,87-92,92-96,96-127,127-145\n44-74,74-87,87-93\n0-9,9-41,41-66,66-80,80-100\n0-41,41-54,54-58,70-88\n61-96,96-104,104-107,107-109,109-138\n30-48,48-56,56-62,62-65,65-74,74-86,86-94\n0-28,28-62,76-86\n35-80,86-107,107-127,127-142,142-163,163-170,170-177,177-179,179-181\n0-15,32-46,46-66,66-82,82-85,85-89,89-91\n-2-2,2-33,33-36,36-43,43-76,76-88,88-90\n52-68,68-79,82-100,112-130,162-179\n-2-2,2-61\n10-17,21-42,42-60\n-27-27,40-48,48-60,60-73\n-1-1,1-14,14-24,24-26,26-43,43-57,57-74\n109-148\n114-132,132-154,154-167,167-193\n154-206\n169-191\n155-165,171-189\n-11-11,11-37\n-18-18,18-33\n33-83,88-92\n45-80,80-106,106-136\n51-129\n-7-7,7-79\n42-83,83-98,98-138\n43-63,63-67,67-81,81-99\n31-68\n18-68\n158-202\n132-149,149-174,174-179,179-181\n0-18,18-45,45-50,50-53,53-63\n0-27,41-59\n-11-11,24-45,45-49,49-51,51-53,53-67,129-164\n34-61,99-117,120-146\n39-72,72-81,81-101,106-132,132-151\n31-61\n36-56,56-77,77-97,97-114\n-9-9,138-153,153-155,157-203\n50-61,61-83,98-117,117-124,124-128,128-130,130-151,151-166\n37-68,110-128,136-160\n37-59,59-80,80-86,105-120,124-139\n-2-2,2-16,147-165,165-170,171-189\n33-45,45-55,55-80,93-104,125-146,150-169,169-191\n36-63,118-147\n45-61,61-65,65-97,97-118,118-138\n40-55,55-76,76-82,82-85,85-110,110-113,113-137,137-149,149-165\n-9-9,34-79,79-89,89-92,92-94,94-98,98-103,103-109,120-149,167-193\n-12-12,33-69,69-73,73-95,118-143,163-197\n51-76,82-98,101-117,140-167\n11-19,171-189\n-10-10,151-155,160-169,169-180\n-9-9,12-38,162-180\n58-87,87-89\n41-68\n139-149,170-190\n141-164,164-167,167-180\n155-205\n-27-27,32-56\n-16-16,29-48\n50-94,103-123,123-149,171-189\n41-50,77-95,154-180\n34-70,114-123,126-135,135-139,139-142,145-167\n14-27,27-38,42-62,68-78,94-112,154-180\n-18-18,28-36,36-43,43-60\n-11-11,11-28,31-51\n45-73,73-95,95-98,98-132,132-139,147-167\n23-42,42-46,46-54,54-71,148-166,171-189\n29-52,53-74,74-75,80-90\n-18-18,30-57\n51-85,161-199\n-18-18,18-38,38-71,167-193\n-10-10,47-64,64-84,161-199\n-9-9,63-83,168-192\n273-286,295-320,326-343\n293-321\n60-77,154-166,166-188,236-246,312-330\n8-32,36-45,45-65,65-81,154-162,169-188,222-232,232-236,241-251\n39-63,63-81\n42-73,91-102,107-116\n151-190,190-208,226-253,275-305\n146-156,156-162,163-192,192-212,271-303\n-10-17,36-69,292-343\n-1-22,35-71,292-336,340-359\n18-43,44-70,302-324,346-370\n-7-9,14-28,28-46,46-49,49-51,51-57,57-71,301-309,319-334,334-337,337-340,340-350\n141-151,180-207,275-300\n143-161,176-194,266-297\n-4-13,13-25,36-67,296-330\n-1-22,31-69,298-330,349-359\n27-62,300-330\n32-63,301-324\n50-58,71-89,173-191,192-209,266-283,283-286,286-301\n35-59,59-71,176-194,270-296\n40-63,63-70,70-88,161-183,282-310,310-315\n44-76,76-89,136-144,155-170,170-181,285-302,302-325\n22-32,32-36,36-38,38-69\n-9-9,31-44,44-47,47-70,293-311\n33-55,302-323\n-14-14,36-69,167-193\n-10-10,37-67\n171-192\n59-84,84-100,164-195\n-21-21,34-67,74-90\n56-79,79-97,140-158,158-165,165-185\n57-75,75-79,79-82,82-84,84-86,86-98,156-176,176-198\n37-72,294-328\n32-70,294-324,324-341,341-349\n62-80,167-192\n161-197\n39-62\n32-47,47-63,298-316\n40-58,160-168,170-192,295-313,313-335\n71-94,117-144,149-188\n64-81,81-91,91-93,93-101,101-117,117-141,141-164,164-193\n46-82,166-194\n62-93,161-188\n63-90,141-166,166-185\n171-192\n171-190\n23-41,43-61,76-94,115-123,170-190,284-294,294-310\n175-221,288-311\n49-75,175-217,283-312\n35-67\n-5-13,36-69,74-84\n167-195\n170-197\n51-80,105-117,117-124,128-142,157-186,281-311\n51-76,282-304\n7-26,26-31,34-66,167-194,283-318\n27-69,166-209,282-319\n167-200,215-238\n168-183,183-202,217-235\n55-77,149-180,285-308\n57-81,154-181,286-307\n43-79,162-198\n47-73,166-194\n-12-12,40-65,65-85,157-180\n40-96,160-180\n54-68,73-87,152-178,178-180\n18-34,34-44,44-49,49-54,54-64,64-68,68-84,84-97,167-193\n123-131,155-170,170-179,179-181\n164-180\n169-191\n171-189\n169-191\n39-65\n-1-1,1-3,3-5,5-15,34-62\n19-37,43-66\n3-10,32-68\n-13-13,13-28,28-48,48-65\n43-78,160-200\n54-74,165-195\n34-62,68-86\n33-62\n36-74,165-195\n43-84,164-180\n170-190\n171-189\n25-62,71-88\n-12-12,25-54\n41-77,162-180\n47-74,167-193\n147-177\n44-64\n39-53,53-57,57-65,65-82,164-180\n66-85,171-189\n40-78,84-88,165-195\n282-298,298-316\n286-313\n42-72,88-112\n46-73,93-111\n37-72,87-105\n42-65,76-98\n181-204,259-267,277-306\n180-190,190-192,192-199,199-210,276-306\n31-43,45-65,296-328\n294-320\n-1-20,25-37,37-69,296-319,338-359\n40-67,295-319,329-348,348-370\n38-69,264-277,277-313\n23-39,39-50,50-68,283-321\n22-40,295-317\n51-68,68-86,159-176,176-178,178-199\n59-89,155-177,177-180,180-195\n172-197,201-216,268-281,281-290,290-303,303-313\n171-185,185-211,268-283,283-303\n190-208,263-292\n188-210,259-282\n0-23,23-36,46-58,58-61,65-77,82-98,98-103,103-116,133-151,165-176,176-184\n0-27,119-177\n-14-14,14-50\n0-22,162-179,179-181\n-1-1,1-17,95-122,122-124,124-136,147-170\n-2-2,2-8,8-26,110-152,155-174\n-3-3,3-16,18-55,107-123,123-1