/**
 * dynamic-typing - Dynamically type a string
 * @version v1.0.0
 * @link https://github.com/cheminfo/dynamic-typing#readme
 * @license MIT
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.DynamicTyping = {}));
})(this, (function (exports) { 'use strict';

  /**
   * Dynamically type a string
   * @param {string} value String to dynamically type
   * @returns {boolean|string|number}
   */
  function parseString(value) {
    if (value.length === 4 || value.length === 5) {
      let lowercase = value.toLowerCase();
      if (lowercase === 'true') return true;
      if (lowercase === 'false') return false;
    }
    let number = Number(value);
    if (number === 0 && !value.includes('0')) {
      return value;
    }
    if (!Number.isNaN(number)) return number;
    return value;
  }

  exports.parseString = parseString;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=dynamic-typing.js.map
